﻿USE sofia;
DROP TABLE IF EXISTS sofia.jni_vpl;
CREATE TABLE jni_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jni_vpl WRITE;
INSERT INTO jni_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Utuba abanga Yeso, vana Udauda, bi Sana bi Ibrahim Bini. ");
INSERT INTO jni_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim maa yoo Ishaku, Ishaku ma yoo yakubu, Yakubu mayoo Yahuda, nan anu henu umeme. ");
INSERT INTO jni_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda me mani maa yoo Larisa nan Zaraha nan Farisa, usuro u Tamar, Farisa ma yoo Hasruna, Hasruna mayoo Aram. ");
INSERT INTO jni_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ma yoo Aminadab, Aminadab ma yoo Nashon, Nashon ma yoo Salman. ");
INSERT INTO jni_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salman mayoo Bo'aza usuro u Rahab. Bo'aza ma yoo Obida usuro u Rut, Obida ma yoo Yesse. ");
INSERT INTO jni_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesse ma yoo Dauda ugomo, Dauda ma yoo Sulemanu desa a ino me mani unee u Uriya. ");
INSERT INTO jni_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemanu ma yoo Rehoboulam, Rehoboulam ma yoo Abiya, Abiya ma yoo Asa. ");
INSERT INTO jni_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ma yoo Yehoshafat, Yehoshafat ma yoo yoram, Yoram ma yoo Azariya. ");
INSERT INTO jni_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","A zariya ma yoo Yotam, Yotam ma yoo Ahas ma yoo Hezekiya. ");
INSERT INTO jni_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya ma yoo Manassa, Manassa ma yoo Amon, Amon ma yooYosiya. ");
INSERT INTO jni_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya mayoo Yakoniya nan anu henu ume. ");
INSERT INTO jni_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uganya sa a ziki we u hana Ubabila, ba Yakoniya ma yoo Sheyaltiyel, sheyeltiyel ma yoo Zarubabel. ");
INSERT INTO jni_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabel ma yoo Abihudu, Abihudu ma yoo Eliyakim, Eliyakim ma yoo Azuro. ");
INSERT INTO jni_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azuro ma yoo Suduku, Suduku ma yoo Akimu, Akimu ma yoo Aliyidu. ");
INSERT INTO jni_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyudu ma yoo Ele'azara, Ele'azara ma yoo Matana, Matana mayoo Yakubu. ");
INSERT INTO jni_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu ma yoo Isubu uruma' u maryamu desa ma yoo Yeso, sa atisa me unu bura. ");
INSERT INTO jni_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Vat bisana bi Ibrahim uhana u Dauda bisana kanu kirau in ka nazi. Usuro Udauda u'inta uwe uhani uwe ubabila me, bisana ukirau inkani ka nazi kani, u inta uwe ubabila uhana unu bura bisana ukirau in kani ka nazi. ");
INSERT INTO jni_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Uyoo u Yeso uzi gusi ana sa Isubu maa zin inti nyari ti Maryamu a i'no a Yeso, adaza sarki uzika ume, a iri me ma tonno u suro ubibe bilau. ");
INSERT INTO jni_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uruma ume Isubu unu mani shew si, mada nyara me ma nya mu'i aje anu, ma ziki iriba ime madi harzina nan me in nihunzi. ");
INSERT INTO jni_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sa mara anyimo ubasa imum me, bibe bi ka dura kasere bi'e ahira ame atiroo, bigu, “Yusufu vana Dauda katu kun biyau ziki une uwe maryamu, barki apuru a gino bibe bilau bini” ");
INSERT INTO jni_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Madi yoo vana udi nyame niza Yesu barki me mani madi buri a nu ame amadini. ");
INSERT INTO jni_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vat uwuzi ani me, barki a myinca imumbe sa Ugomo Asere ma buka unu kur zoutize. ");
INSERT INTO jni_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“I ye kubura kudi we puru, ku yoo vana, adi wume ni za Emmanuel” (bi nyo bini zame Asere azi nan haru). ");
INSERT INTO jni_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sa Yusufu ma zuma amoro, matar si ti ze ti bibe bi kadura kasere ma ziki une ume. ");
INSERT INTO jni_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dama rusi nipum nume mayo ma in kime ni za Yesu. ");
INSERT INTO jni_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","U ganiya sa, aa yoo Yesu u Baitalami a ma nyanga mu yahudiya, Hirudus mani ma Ugomo, a kem ara anu tusa wirau ana za we e a Urushalima wa gu. ");
INSERT INTO jni_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Unu sa ayo me maraa Ugomo a Yahudawa? ta ira iwirau inza ta ayee ti nonzo me” ");
INSERT INTO jni_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sa Ugomo Hiridus mankunna anime, ma kem ma ayee anyimo iruba imeme nan nanu urushalima. ");
INSERT INTO jni_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma ori ana katuma kasere vat nan nanu dungara ma iki nani adi yo me abani Almasihu. ");
INSERT INTO jni_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba we gun me U Baitalami uni ama nyau ga mu Yahudiya, barki ane yetike in nu guna. ");
INSERT INTO jni_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Hu Baitalami, u Yahudiya da humani ucici a nyimo atipin pin ti da dang tu Yahuda, barki anyimo awenadi yoo unu bari desa madi tarsin in Isara'ila ");
INSERT INTO jni_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hiridus ma titi ma rusa ugino me ni hunzi, ma rusi ati nyo tuwe uganiya sa iwiran iginome adi iri ini. ");
INSERT INTO jni_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A anime ma tumi we ubaitalami, magu, “Hanani ika igizoni abanga vana me men'meru inki yakemme, i'e inbukinimi barki mima inka nunzome” ");
INSERT INTO jni_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","We sa wa kunna tize tugomo, wadusa we. I ye biwiran me sa wa iran ana za bi haka aje awe, bi'e bitonno ahirame sa vaname maram. ");
INSERT INTO jni_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sa wa ira biwiran me wawu afuru aram. ");
INSERT INTO jni_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sa wa ribe akurame, wai iri vana me nan ka ino me maryamu, wa rizi aje ame wa nonzome. Wa sopi turunga tuwe, wa nya ni isi nan na dodu ani za. ");
INSERT INTO jni_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sa abuka we ati ro kati wa kuri a hira a Hiridus me wadusa wa tarsi uruna sas wa kuri ani pin nuweme. ");
INSERT INTO jni_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sa wa hira, wakem bibe bikadura ku goma sere bibuki Yusufu atiro, magunwe, “hira uziki vana me nan ka inomeni ha a manyangamu masar, icikuno abirkome ma buka we Hiridus ma zunu igizo abanga vana me ma hume. ");
INSERT INTO jni_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufu mahira maziki vaname nan ka inome in niye wa dusa umasar. ");
INSERT INTO jni_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma cukuno abirkome uhana iwono i Hiridus Abang agino me barki a nyincikina imumbe sa Ugomo Asere ma buki a nyo unu kurza zo utize ta sere “u suro u masar matita vana um” ");
INSERT INTO jni_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sa Hiridus ma ira unurusa ugino me wakini me bibabana. makuna iriba kan, matumi a huzi ahana acin cin aruma sa wara anyimo babila nan mataraa vat. uzika uti we tire utino, uzika uganiya sa anu rusa wabuki me. ");
INSERT INTO jni_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Uganiya ugino amying cikkinanubukan Irimiya unu kurzo tize agi. ");
INSERT INTO jni_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","A kun na ni nyiran urama, na sonko inna puru abit kan. Rahila mani ma zinna so barki wa zoni. ");
INSERT INTO jni_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sa Hirudus ma wono, bibebi kadura ka sere bi é Yesuf a nyimoti ro, Umasar, bigu. ");
INSERT INTO jni_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hira u ziki vanaa nan ka inome, idusa a ma nyango mu Isaraila. ");
INSERT INTO jni_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","barko anu nyara uhuna uvanaa wa wono” Mahiri, mazi vanaa nan ka inome, maze ama nyanga mu Isaraila. ");
INSERT INTO jni_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sa ma kunna Arkilayus ma kaba acome mamani ukwanku udang u Yahudawa, ma kunna biyau bu biki abirko me. ");
INSERT INTO jni_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sa anyame tize atiro, mawata u hana u Galili. Maha maka cukuno anire nipin agi u Nazarat barki amyinca ubuka anu kurzuzo utize agi adi titime banazaret. ");
INSERT INTO jni_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","U ganiya uginome Yahaya unu zorsa anu zorsa anu ma'e, mazintize ani ja nu Yahudiya. ");
INSERT INTO jni_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Innu gusa, “Hemni, barki uvenke a sesere wa aye mamu. ");
INSERT INTO jni_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Unu age mani Ishaya unu kurzo utize ma buni “Nimyiran nu tisa anyimo ani ja nigusa, barkana tume. ");
INSERT INTO jni_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahaya maturi inturunga innu subu uronkomi, matiri uzu uwa, immumare imme makene nan matu. ");
INSERT INTO jni_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anu Urshalima nan nu Yahudiya vat, nan ana ma nyanga murabi uraba udang u'urdu wa ezi ahira ame. ");
INSERT INTO jni_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mennu zorso uwe uraba u'urdu me, wen nubo imum izonzen iwe. ");
INSERT INTO jni_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa Yahaya ma ira ma Farisiyawa wan ma Sadukiyawa gwardan, wa'e zi barki a zorso we, ma gunwe “she” iwa! a verri mubuka shi isumi iruba iburu uwui ugino su eze. ");
INSERT INTO jni_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wu zani katuma sa kadi bezi u him ukaba tize tasere. ");
INSERT INTO jni_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kati iziki amuruba mushi agi Ibrahim mani a co ushi. barki anime inboshi. Asere abari abari Ibrahim a hana in na po ageme. ");
INSERT INTO jni_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A' atara anyo abitem anitini nu titti. barki anime vat ulitti me sa daki wa nya ahana ariri ba, akoriko uni areki ura. ");
INSERT INTO jni_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi, inmei mani inzinu zorsuzo ushi, ubuka uhim ushi, a' aname unu aye adumo am matakum innu gwardang, desa bi nyimo bukwatak umeme indake invon kiba. memani madi zorso in bibe lau won ura. ");
INSERT INTO jni_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Utanika ura atar tume, madi visi ahira abi suya-suya lau, ma humuko bi home mawu ukere ume. ma mindin me, ma uni ura uzatu biso ma punsi. ");
INSERT INTO jni_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Uganiya ugino uni Yesu ma e usuro manyanga mu Galili, maha uraba urdu ahira Yahaya, barki azorome. ");
INSERT INTO jni_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yahaya ma nyari ukarki ume, magu “misan in nyari hu uzorom, u'e ahira am?” ");
INSERT INTO jni_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ba Yesu makabirka me magu, “aca icuku anime a name, barki anime animya wuna to mincikina kadure” a' anime Yahaya ma hemme. ");
INSERT INTO jni_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sa' azoro Yesu, ahirame ma suri a nyimo me I, Asesere awata, ma iri bibe bilau ba were both kasi bi hurbe. butu ani ce nume. ");
INSERT INTO jni_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Akin na no miram azesere nigusa, “unite Mani vana um sa mahem inme. dewan in zin Inna puru arum taking.” ");
INSERT INTO jni_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Anime bibe bilau bihan in Yesu ani ja, barki unu guru maman same. ");
INSERT INTO jni_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sama wuza no we no me I tiye a kurra Nazi niye man nu Wei ikomo imukurkame. ");
INSERT INTO jni_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Unu mansa ugino ma'e, “inki hu vana sere mani, kurzo a po ageme acukuno immare”. ");
INSERT INTO jni_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu makabirka magu, a citike uguna, dakin in bisana bini cas unu madi vengizo ba, senke inti zo sati suso ahira sere. ");
INSERT INTO jni_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Anime unu uburu mahan me ani pin ni lau, matarime asesere me. ");
INSERT INTO jni_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Magun me, inki hu vana sere mani, hinna adizi. Barki a nyirtike agi, 'Madi gu ibe ikadura ka me ikurso we', Barki kati upilliko anipo. ");
INSERT INTO jni_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu magunme, anyetike, udaman sawa Ugomo Asere aweba. ");
INSERT INTO jni_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Unu buri makuri mahanme anire ni po nijongoron adodu une ariri. ");
INSERT INTO jni_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Magun me “vat in we rizomadizi wa non zom indi nyawe”. ");
INSERT INTO jni_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeso magunme, dusa abame, unu uburi! Abuka idi nonzo Ugomo Asere mani, barki memqni cas udi rizi adizii unonzome. ");
INSERT INTO jni_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A' animo unu buru maduku ceki me igab. ");
INSERT INTO jni_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sa Yeso ma kunna akorso Yahaya, mahiri uhana u Galili. ");
INSERT INTO jni_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma ceki unazarat, makuri unahun inti cukum, abirko upuru uruba udang, ubinani umanga mu zabalina wan nu naf tali. ");
INSERT INTO jni_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Barki amin cikina uba u Ishaya. ");
INSERT INTO jni_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Manyanga mumzabaluna nan nu Naftali, nan nu bahar, nan nuhuru uraba u'urdu, amanyanga mu Galili anu zatu urusa utize tasere. ");
INSERT INTO jni_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Anu ciki uma reu wa ira masa anu ciki anyimo livono nan ma aye, masa ma ulata we. ");
INSERT INTO jni_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Usuro uganiya uginome, Yeso matubi tize, innu gusa, kabanitize tasere barki Asere a' aye mamu. ");
INSERT INTO jni_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mahaki urabi uraba udang Ugalilu, ma iri anu henu ware, saminusa atissa me Bitrus, nan nu henume Andrawus wa zinnu vingizi itaru uraba udang barki we anu minsi icere ini. ");
INSERT INTO jni_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma gun we tarsan mi, indi kurzo shi anu mensuzanu. ");
INSERT INTO jni_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa ha wa aki watarsime. ");
INSERT INTO jni_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sa ma reje, ma iri aye ana were wema ani henu, yakubu vanu Zabadi, nan nu henume Yahaya, anyimo jirgi nan ka co uwe Zabadi innubara itaw iwe, mati tuwe. ");
INSERT INTO jni_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A hira me wa ceki u jirgi nan ka come, watar sime. ");
INSERT INTO jni_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bamakase manyanga mu Galili, in nu dungara anu ati denge titarsa sere we, inkur uhumza inna num zatu ni huma a tikoni tuwe. Anime memani amanyanga mu Suriya. ");
INSERT INTO jni_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A ezzinme innanu zatu nu huma, ani jas inti koni sassas. nan nanu zito, nan nana gwargene nan ana ma tiri zi, nan nanu wijo utikira tini pum ma hum mumzan we. ");
INSERT INTO jni_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ni ori nanungwen watarsime umGalili nan nu dikafolis, nan nu Urshalima nan ma nyanga mu Yahudiya, wannu kafa urabà udang u'urdu me. ");
INSERT INTO jni_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sa Yeso ma ira ni gura nanu gbardang, ma hiri maka nyene ani hoho ma cukunun, anu tarsa umeme wa ka kemme. ");
INSERT INTO jni_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma poki anyo ma gunwe. ");
INSERT INTO jni_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Anu ringirka wani an de sa wa zika a che awe anu usizikime abi bee, ti gomo ta sesere tuwe tini. ");
INSERT INTO jni_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Anu ringirka wani anu apuru abid, adi natti we muruba. ");
INSERT INTO jni_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Anu ringirka wani anu utuzo ace, we wani wadi kem unee. ");
INSERT INTO jni_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anu ringirka wani ana mukumo nan ana mu ruba mu benki, wadi ti a sereri. ");
INSERT INTO jni_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Anu ringirka wani anu gogoni, adi kunna ugogoni uwee. ");
INSERT INTO jni_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anu ringirka wani ana mu ruba mu rum, wewani wadi iri Asere. ");
INSERT INTO jni_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Anu ringirka wani anu nyara iti cukum ti hama, we wani adi titiwe a hanq Asere. ");
INSERT INTO jni_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anu ringirka wani an de sa wazin unu zito barki mu ruba mu benki, ti gomo ta sesere tuwee tini. ");
INSERT INTO jni_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Shi, unu ringirka wani an de sa ana bu wa zogizo shi, wa patti shi wa wuza shi imum iburki me. ");
INSERT INTO jni_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Zunzukani nan tipuru tirum kang idi kem ulada udandang asesere. Anu me ani, anu wa patti anu kurzo utize ta sere, sa wa eh aje ashi. ");
INSERT INTO jni_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Shee, wani muhu mu nee, ingi mu ma harzina nan urunta umuni adi wu aneni a kurzo mu neen? barki sa macurnome ma dee a kponko munin anu wa pattali. ");
INSERT INTO jni_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Shee, wani ma saa mu nee, ni piri me sa anuka nin abi koworo ni zome ni hunziba. ");
INSERT INTO jni_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aka da wuna uraa upitila, a impi ini isso ba, ani me aka tari a hira me sa udi nya masaa akurame vat. ");
INSERT INTO jni_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Barki ani me ca masaa mashi me ma bizi bati anu wa iri katuma. ka ririn ka shi me wa nonzuko ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kati ibasa ma aye unu guna invisi udungura u Musa nan anu kurzuzo uyi zee ta sere. Daki ma aye uniu tubur ko ba ma ayen unu myinciza. ");
INSERT INTO jni_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka dundura in boo shi a sasari nan adizi adi mari, ada visame iri imum cingilin anyu mo udungara u Musa ba sadai ya myinca vat. ");
INSERT INTO jni_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Barki ani me vat de sa ma vete imum icingilin inde anyumo me adi kurzo me anu ucin anyumo ati yomo ta sesere. vat de sa ma tarsa ma kuri ma dungura anu adi titi me unu udandang aseseri. ");
INSERT INTO jni_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa in boo shi, ca muruba mu benki ushi me mu akki manu bizizi udungara u Musa na anu ubezi urusa, ida ribe shi anyumo ati gomo ta sere ba ko cinginlin. ");
INSERT INTO jni_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ya kunna uguna aabuki a cukoro anu udatti unu guna, kati u hun uye, dee sa ma hunu uye, adi porikome. ");
INSERT INTO jni_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","In kuri in bushi, de sa ma kunna iruba wanu hennu adi hunguko me titui de sa ma hira u hennu ma zome anyo ari mum ba ma bari a hanme ubabbana madi ribe ura. ");
INSERT INTO jni_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Barki ani me inge uhaka unya usadiga wa ringe uhenu uweme mazin na puru abi nan hu. ");
INSERT INTO jni_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","U inki usadiga me ukakeme ibarka uku eh unya usadiga me. ");
INSERT INTO jni_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Inga uye ma hanan hu ani kubu wuna mass ibarka unaa, ka ti uhem ibiki ani kubu ba. In daki ani me ba madi patti we nan unu barka utize unu barka utize ma patti we nan udanduka a hennu aura ari rere aka korso we. ");
INSERT INTO jni_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka dundura inboo we, ada suso huba sede wa nya vat ikirfi me sa a tarsa we. ");
INSERT INTO jni_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ya kuna aa buki kati u muri nan vana u e nan uruma uge za ma zome uwe ba. ");
INSERT INTO jni_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","In ani me in boo shi ingi unu ma ira vanu emma inko iruba, ma mara umura nan me. ");
INSERT INTO jni_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ingi nije ni tari tinare tuweme nidi wuwe upilko ukari nin uvetenin. Iteki udiri are ahira ani pum nuweme unu guna arekiwe uraa. ");
INSERT INTO jni_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ingi tari tina ree tuwe me tidi wuwe upilko, nyoro tini uvetten. Iteki udiri are ahira ani pum nuweme unu guna ureki nin vat uraa. ");
INSERT INTO jni_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A kuri aboki uguna de sa ma gido unee umeme a ma nya mee unyertike uharzina. ");
INSERT INTO jni_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","I mumme sa in kuri inboo shi i nee ini ingi unu ma gido unee umeme inzo barki upilko wa mura nan de sa inzo uruma ume mani ba, ma wuna me unaa uma dini vat de sa ma zika me, mee ma mazim ma dini. ");
INSERT INTO jni_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ya kuri ya kunna abuki anu datti unu guna, kati uuwuzi itono sa we ziki huu nan Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Imum sa inkuri inbu shi, ine ini, kari iba toniko nanin na seseri, barki a hira ati cukum ti gomo Asere ani. ");
INSERT INTO jni_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kati itoniko inna dizi barki sa ane ani Ugomo Asere ma patala, nan Urushalima barki sa une uni nipin ni gomo dang. ");
INSERT INTO jni_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kati utonikon in nice nuwe, barki sa daki wa bari ugamirka usuba u inde unice nuwe urun nan ubid ba. ");
INSERT INTO jni_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","In mum sa irizi ibuki ine ini ee nan um - um, ingi ya akka ani me inu ubur ini. ");
INSERT INTO jni_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ya kunna abuki nije ani je, ni lini ani lini. ");
INSERT INTO jni_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A ani me min boshi kati inyareshi de sa ma pilkoshi ba. Ingi unu ma vavvi we upuu utari tinare u gimirka me ukure ma vavvi ");
INSERT INTO jni_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ingi uye ma nyara ubura uwe udibi upati me ugebtu utozo uwenme. ");
INSERT INTO jni_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Inge unu bari ma wuna we tanu tu ukilomita u inde, hem i wuzi umakilomita ma re. ");
INSERT INTO jni_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ingi uye ma iko we imum u nya me. De sa ma aye unyara imum a hira awe kati ukarti me ba. ");
INSERT INTO jni_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ya kunna abuki unu guna, hem de sa ma hem hu, u gaa we desa ma gaa hu. ");
INSERT INTO jni_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A anu me ingusan shi hemni an de sa wa nyareshi, i wuzi an de sa wa nyinza shi ijasi bi ringara. ");
INSERT INTO jni_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","U wuzi anime ani udiwu i cukuno a hana aco ushi me aseseri, de sa ma wuza uwui unya ma saa ahira unu ruba uninza nan unu zati uninza. ama kuri ma tuzo uree aseseri a hira unu iruba ubenki nan unu iruba izatu ubenki. ");
INSERT INTO jni_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyanini idi kem ingi shi ya hem in an de sa wa hem shi cass? anu kabsa ikirfi ima nyanga wa wuza cangi. ");
INSERT INTO jni_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ingi i issizo si anu henu ushinwani cass, nyanini usass ushi na aye? an de sa wanzowe ayahudawa ba wa wuza ani me cangi. ");
INSERT INTO jni_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Barki ani me cukuno ni gbemka si acoo ushi me wa seseri sa mazi gbem. ");
INSERT INTO jni_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wa zani seke kati katuma kashime ka cukuno ku hira aje, barki inki yawuza ani me idaa keshi imum Asesere ba. ");
INSERT INTO jni_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Inki udi nya usadiga, kati uwuzi kasi anu aburu sa wawuza udenge Asere nannu na barki anu wa nanzo we, kadure kani inboshi wanu kaba u lada uwe. ");
INSERT INTO jni_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Anime inki uzinnu nyiza usadiga, kati tari tinan gure tirusi imumbe sa tinare tizin nu wuza ba. ");
INSERT INTO jni_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Barki u sadiga u cukuno ni hunzi, aco ushi sa ma hira madi nyawe wada uwe. ");
INSERT INTO jni_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Inki idi wu birindara, kati icukuno kasi anu aburu, sawa tonzuno aje anu wa wuza biringara, ati denge ta Asere nan ti naa, agi anu wa iri u we wamu kaba ulada uwe. ");
INSERT INTO jni_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Inka udi wu biringara, uribe anyimo udenge u we, ukorso ana tukum uwu biringara acoo ushime sa mahira ni hunzi madi nyawe ulada u we. ");
INSERT INTO jni_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Inki iziz biringara, anu zatu urusa utize ta sere wa wuza, ubasa uwe akunna we barki ti ze tuwe. ");
INSERT INTO jni_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kati icukuno kasi we, barki sa acoo ushime masarusa imumbe sa inyara. ");
INSERT INTO jni_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","A anime senke iwuzi biringara kasi ana, acoo uru Asesere akpici ni za nu we. ");
INSERT INTO jni_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ti gomo tuwe ti cukuno awuzi imum ewe anyimo nee kasi u wuza Asesere. ");
INSERT INTO jni_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyan duru immare ini hiri. ");
INSERT INTO jni_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vette ucara banga arun kasi be sa tiverse ucarsa abanga adesa wa wuza duru ni. ");
INSERT INTO jni_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kati uhan haru ahira ubata a nime buran duru anu uburu. ");
INSERT INTO jni_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","A' nime inki ya vette abanga zenzen anu ni, acoo Asere madi vette asime. ");
INSERT INTO jni_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Inki daki ya ababanga azenzen anu ni ba a coo ushime mada vette me i shime ba. ");
INSERT INTO jni_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Inki idi cukuno innu uzumi kati ibezi anu henu kasi anu aburi ba, barki wake wa bezi amuhenu ani wa iri. ");
INSERT INTO jni_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Inki wa zika u azumi u humuka mani ani ce ukpici mu henu. ");
INSERT INTO jni_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kati anu wa iri wa rusi u zin nu wuza u azumi acoo ushi sama zi ni hunzi mahira. Acoo ushi me madi nyawe ulada. ");
INSERT INTO jni_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kati i'ori ace ashime imum ahira me sa biru-ruk nan nu corno me ahira sa akari wadi perse wa ciri. ");
INSERT INTO jni_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Senke i orso ace ashime imum Asesere, ahira sa iru-ruk nan ni mum besa idi carini, nani kuma akarime sa wadi puri waziki. ");
INSERT INTO jni_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Barki aba sa ucira u we urani, abine ani eruba iwe irani. ");
INSERT INTO jni_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Aje ane ani masa mani pum inki aje awe me azi ahuma, vat ni pum nuwe nidi myin ca in masa. ");
INSERT INTO jni_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Inki aje aweme azoo me ahuma ba, vat nipum na nyin ca in mareu. ");
INSERT INTO jni_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Unu madake matarsi me Asere kare ba, nani ma kini indai ma hem inna indai, nani kuma mahem in are ma izi are daki ya wuna uri upat Asere nan ni mumu u nee. ");
INSERT INTO jni_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Anime in bashi kati ibasa abanga inbesa idiri nani idi si, nani ni pum nishi nani turunga sa idi soki. Asere uvengize u da te keme imumma re ba? nani nipumnida teki me turunga? ");
INSERT INTO jni_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","I rani inyin re, isiza wa da zome niti kereba aka deshi sa izin ina dodu agino vat ma aye ma nyani in zin. ");
INSERT INTO jni_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aveni anyimo ashime, barki u hem in ni ce nume madake makin ki tiye tini ce nume. ");
INSERT INTO jni_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Anime nyanini ya wuna izin ma aye Azesere aturunga? Irani ifuriye ni ja sa e' uza sarki ijasi. ");
INSERT INTO jni_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vat in anime in boshi, sulaimanu me anyimo a ninonzo ma sonsi turunga gu anu ageme ba. ");
INSERT INTO jni_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Inka Asere mawuna ti kpe tini ja'a u zu, uni u zinnu yata nisi zo areki uni atibo, ani u zu me uraba sa udi wuzi shi ni shi anu hem ucin? ");
INSERT INTO jni_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A' anime kati wuzi ma, 'Aye igusi nyani tidi ri?' nani nyani tidi si? nani 'Kuma nyani tidi soki?' ");
INSERT INTO jni_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Anu zatu urusa utize ta Asere wa zinu nyara adadu aginome acoo ushi Asesere marusa nyara vat. ");
INSERT INTO jni_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Renaje innu nyara uti gomo ta Asere nan ni ruba ubenki, vat adadu agino adi nya shi. ");
INSERT INTO jni_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Barki anime kati ibasa barki ni sizoba, in ani me ni sizo nidi basa inice num, konde uya uwui umyinci ini jasi. ");
INSERT INTO jni_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kati i cani uye uzatu kadure, barki kati a cani shi mani cangi. ");
INSERT INTO jni_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Barki imum me sa ya weki, ine ini adi weki shini uyanga sa ya gutan, in une uni adi guti shini. ");
INSERT INTO jni_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Barki yanini u hira ni kpeki ani je nu hume, da wa ira ukunti sa anuwe ni je me. ");
INSERT INTO jni_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aneni udi gu unu henu uwe, can inkari we nikpeki ani je nuweme, daki wa kara ni ge sa ni ra anwe nijeba. ");
INSERT INTO jni_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hu unu umum mu apuru, tuba kara nikpeki nini je nuweme, uduku iri riri uka kara unije nu henu uweme. ");
INSERT INTO jni_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kati inya iwoci imum igesa iri zi ba, kati ukuri i reki kapadari imum mu ihuma barki wadi patili, wa gamirka wa jani shi. ");
INSERT INTO jni_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ikoni ade yashi yara ni, idi kem nokini ade poki shini. ");
INSERT INTO jni_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vat desa ma iko adi yame, unu yara ma kenzi unu nosi u ana tukun a pogime ni. ");
INSERT INTO jni_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aveni ayimo shime, desa vana madi iki me imum are ma yame nipo. ");
INSERT INTO jni_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nani ingi ma iko me be cere, madi yame bi we. ");
INSERT INTO jni_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A' anime shi adesa izin mu riba mu buri irusa uyiza a hana ashime imum iriri anime, akodi aco ashime sa mara Aseseri, sa ma yiza a desa wa iko me imum iriri. ");
INSERT INTO jni_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","A' anime vat imum me sa i yara anu wa wuzi shine, shi cangi wuzani weni, ane ani u inko u tize me uzi. ");
INSERT INTO jni_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ribeni aku na ku cin, barki una upas una iwono ini anu gwardang wa zwrsa uni. ");
INSERT INTO jni_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kuna ku me irere kune kuni una be sa idi han haru Aseseri, anu tarsa kuni wada ori me ba. ");
INSERT INTO jni_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Rusani in na anu kurzozo utize a ma cico, a de sa wa eze shi unu subu i tam, a anime kadure ka zome ahira aweba. ");
INSERT INTO jni_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A hira atanu ti we me tidi rusi we, adi wusi ane ni anu wa ori bisana ayimo ikana nyani uyo upom ukintu. ");
INSERT INTO jni_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ane ana vat utiti uriri uyozo ahana ariri, ane ani utiti uzenzeng uyozo ahana azenzeng. ");
INSERT INTO jni_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Utiti uriri uda yiza me ahana azenzeng ba, ane ani utiti uzenzeng uda yizame ahana ariri ba. ");
INSERT INTO jni_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vat utiti ugebe sa unyinza ahana aririba adi koriko uni a punsi-ura. ");
INSERT INTO jni_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Barki anime ani usuro ahana a we me adi rusi we. ");
INSERT INTO jni_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Da koda aveni sa ma gusan mi, Asere Asere, madi ribe Aseseriba, an de wani sa wa wuza katuma ka aco am cas wadi ribe Aseseri. ");
INSERT INTO jni_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anu gwardang wadi gusin me runo ugino me, Asere Asere, data wuza katuma ayimo ni za nuwe me baa, ayimo aniza nuweme ta suzo agwergene, ta kuri ta wuza katuma ka dang ayimo ni nuwe mee. ");
INSERT INTO jni_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abine ani mi indi gun we, in tam inshi ba hirani abame shi ana katuma kaburk. ");
INSERT INTO jni_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","A, ani vat desa ma kunna tize tum ma tarsa madi cukuno gusi desa ma bari a kura aseseri anipo. ");
INSERT INTO jni_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ure rubi mei ma eh, upebu u hiri vat ani me akura agino me da arizo ba, barki sa a bari ani aseseri anipo ");
INSERT INTO jni_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","De sa ma kunna tize tum da ma tarsa ba mazi gusi ubabana ugino me sa ma bari akura Aseseri a b i kiki. ");
INSERT INTO jni_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ingi ure wa aye, mei ma tunno upebu w hure utuburko akura me, a rizi urizo udandang. ");
INSERT INTO jni_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sa yeso ma mari uboo utize ti ginome, anu gwardang wa hem unu dungara umeme. ");
INSERT INTO jni_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Madunguri we kashi de sa ma bari, da kashi anu uyetike awe me ba. ");
INSERT INTO jni_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sa ma tuno ani po, ni ori gwardang ni tarsi me. ");
INSERT INTO jni_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akem uree ukuturu ma e ahira amee ma nonzome, magu, “Ugama sere, inki wa hem u zinu bari kpicom.” ");
INSERT INTO jni_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeso ma witi tari madari me, magu, “Mahem u kpicuno.” Ahirame tikuturu tume tuhuma. ");
INSERT INTO jni_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeso magunme, “Tarsa sekee kati ubuki uye iri mum senke uha ahira u nudang mabuku we uwuzi u sadiga barki we warusi, kasi gusi ubuka u musa. ");
INSERT INTO jni_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mazin inu ribe ukafar nahum makem ure vanu ruma ma' aye ahira ame innu pottiko ume tari. ");
INSERT INTO jni_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Magu, “Ugomo Asere, vana um marari akura mawuno anire ni kira mazin nu zitto kan.” ");
INSERT INTO jni_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeso magun me, “Indi e' in human me” ");
INSERT INTO jni_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Vanuu ruma magu, “ugomo Asere, mabari u e' akura amba senke ubuki tizze vana um madi huma. ");
INSERT INTO jni_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Barki mi cangi inra tari tiuye tini, anani kara nini kono maraa tari tum, senke ingu innu nuginome, 'Hana' amaha uye ingunme 'ayee' a-ma eye, ingu in nu ureree um, wuza ege mum a-ma wuzi.” ");
INSERT INTO jni_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sa yeso makunna anime, mabasa abanga magun nanu tarsa ume, inboshi kadure a'a nyimo isaraila cangi daa mu kem usa-sana uka dure kunu ge me ba. ");
INSERT INTO jni_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","In boshi, anu wdi e gwardang inna za nan na dizii wa cukuno in nare imummare nan ki Ibrahim, a Ishaku a yakubu Asesere. ");
INSERT INTO jni_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ahana ati gomo adi rekuwe ammareu abinime madi shi marumzi anyoo. ");
INSERT INTO jni_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yeso magun innu nani kame, “Dusa a ca uhemme sa wa hem ni u cukuno we anime.” Ahira me vana mahuma. ");
INSERT INTO jni_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sa yeso ma ribe akura a Bitrus, ma iri ugiri ubitrus ma rari uye si. ");
INSERT INTO jni_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma dari me atari, ma humamari jen katuma kame. ");
INSERT INTO jni_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","U wun joro uwu wa ezzimen nanu agwerge ne gwardang, masu so we in tizee cas, mawu anu zattunu huma wa huma vat. ");
INSERT INTO jni_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Agino me barki amyincikina ubuka u ishaya agi, inni cenu me ma inta u zatu uni huma niru, ma zika ti koni tiru.” ");
INSERT INTO jni_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sa yeso ma ira ni ori na kateme gwardang madusa mabu ki akuri u huru gino. ");
INSERT INTO jni_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ure unu dungara attaut ma e magun me, “Yeso indi tars a we vat ahira sa hana.” ");
INSERT INTO jni_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeso magun me, ikukkure izin tuna tuwe i nyingin ma suu ma we vana unu ma zoo in kura ba. ");
INSERT INTO jni_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Uye anyimo anu tarsa ume ma gunme, “Ugomo Asere da cekum inha inka vati ucokro um.” ");
INSERT INTO jni_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeso ma gunme, “Tarsa ceki ande sa wa tawe Asere ba wa vatii anu u we sa tawe tize ta sere ba”. ");
INSERT INTO jni_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sa ma ribe ujirigi, anu tarsa u yeso wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Upebu uhiri uraba udandang e barka imei hiri itonno itubi u mensi uzirgime, amen moroo. ");
INSERT INTO jni_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Anu arsa umeme wa hirza me wagu, “Ugomo Asere buran duru tidi wi!” ");
INSERT INTO jni_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Magun we, “Barki nyani ya kuna iyau ani me, anu hem u cin?” madiku hiri ma gwarika upebu nan meime, ahirame vat attonno dang. ");
INSERT INTO jni_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anu wa kunna biyau wagun, “Uyaa nu ma u dandang makunna me?” ");
INSERT INTO jni_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sama bi uhuru u ma nyanga ma garasiyawa, are ana ware in na gderigene wasuri anyimo anu cau waguri me, in wa in wa irawe imum ibi ya bini, ada tarsa me uname ba. ");
INSERT INTO jni_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wa'wu hunu wagun, “Nyani mei ma weni nan haru hu vana Asere? wa e ani barki uyumukon duru uganiya u daa?” ");
INSERT INTO jni_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma haha cin ma iri nigo a nimaladu in nu kase. ");
INSERT INTO jni_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agdergene aburu wagu, “Inka wasuson duru utuburu kon duru ani go nimaladu.” ");
INSERT INTO jni_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Magun we, “Hananii” bawa suri waribe amaladu wadusa nigome ukatino u raba udang waka rizzo amei wantiji.” ");
INSERT INTO jni_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Anu kasen in maladu me wa sumi, wa ribe anipin wameki ukise imum be sa ya kem ana gberigene me. ");
INSERT INTO jni_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Akem anani pinme wasuro wa gunna yeso, sa wa irame wa nyarme ma ce kuwe manyanga me. ");
INSERT INTO jni_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeso ma ribe uzirgi umei ma kafa uraba udandang ma ha ukatar nahum, a ba sa ma uni. ");
INSERT INTO jni_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A dusa a en unu koni uwono unu kira, ma rarri upenge. sa yeso ma ira u hem unu ruba muwe ma, ma gun me vana um nata iruba a vatte ucara uwe men. ");
INSERT INTO jni_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sa wa kunna ani me are anu nyirte udangara u musa wa wa gun ina cece unu ugeme mazin unu cara Asere a bangan. ");
INSERT INTO jni_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeso ma russi imum me sa wazin nu bassa me anu ruba, ma gun we, yanini ya wuna izin nu bassa imum ibur a mu ruba mushi me. ");
INSERT INTO jni_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nyanini ireki a gun hu a vatte ucara uwe men nan a gun hu hira dusa? ");
INSERT INTO jni_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","In nyara irusi vana unu mazin unu bari sa ma dake ma vette ucara unun une “ma dusa ma gun me zika upenge uwe me udusa akura”. ");
INSERT INTO jni_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Unu me ma hiri ma dusa akura ame. Sa ni gura nanu na ira anime wa kunna biyau, wa nenziko Asere sa a nya anu usandi uni gino nikara me. ");
INSERT INTO jni_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sa Yeso ma re aje in tanu ma gurna nan uye sa a gusan me matiyu ma ciki ahira u kabsa ikirfi ima nyanga. ");
INSERT INTO jni_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeso ma gun me tarsam ma hiri matarsi me. ");
INSERT INTO jni_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Abini me sa Yeso mazin na re imum yare a kura a Matiyu, anu kabsa ikirfi imanyanga nan anu cara ababga gbardang wa eh wa cukuno nan me nan anu tarsa ume me. ");
INSERT INTO jni_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sa anu bezi urussa wa ira ani me, wa gun anu tarsa ume me nyanini ya wuna unu dungara ushi me mazin nare imum yare nan anu kabsa ikirfi imanyanga nan anu carsa abangan? ");
INSERT INTO jni_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sa Yeso ma kunna, ma gun we, “Ana ti kun wani wa nyarsa uka inzo ana ahuna ba. ");
INSERT INTO jni_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hanani ika nyara urusa imum me sa ma buki shi, 'In nyara iruba ineze inzo u nya imum ba' Russani ma aye barki anu usizikime inzo barki any sa wa mu kem ba. ");
INSERT INTO jni_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Abini me anu tarsa u Yohana unu baptismanwa eh a hira a Yeso wa iki me “Nyanini ya wuna haru nan anu bezi urusa ri wuza ba. ");
INSERT INTO jni_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeso ma kabirka ma gun we “iruba inyani itiyon ida kee i curno me a ma nyani matiyon me nan wee? Tiye ti eze sa adi ziki manyani matiyon me a ceki we. A bini me ani wayi ribe ucenti. ");
INSERT INTO jni_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Unu ma da ke ma wuzi ubarka udibi ukusu in nitira ni so ba, ubarka me udi nyungurko udibi me, u janika kang u akki aje me. ");
INSERT INTO jni_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ba de sa ma di wu uwangu uso anyumo aru a kuzu, ingi ma a wunan aru me adi tuza, uwangu me ukpeko akuri a curso me. Uwangu uso awu uni aru aso. Ani me amda dirame uwangu me nan aru me ba. ");
INSERT INTO jni_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeso ma ra anyumo ubo uwe ani me urunu ukatuma ka Asere ma eh ma tunguno ma gun me “Uca um mara wono aye dara me, ma di hiri”. ");
INSERT INTO jni_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeso ma hiri nan anu tarsa umeme wa dusa nan nunume. ");
INSERT INTO jni_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A bini me une sa ma kem tiwe belum unu koni umaye, ma dari me udibi ana dumo. ");
INSERT INTO jni_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma mu hem iruba, ingi ma dari me udibi umeme indi huma. ");
INSERT INTO jni_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeso ma gamirka ma iri me, ma gun me, “Nata iruba iwe me uca um uhem uwe me wa human hu” abini me une me ma huma ");
INSERT INTO jni_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sa Yeso ma hana akura una katuma me, makem ani shuruwa nan anu unu gbejere. ");
INSERT INTO jni_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma gun we hirani abame uca me mazin moro mani daki ma wono ba. wa wu me tizuza ti bi izi. ");
INSERT INTO jni_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sa ma gido we ma ribe ma meki uca me tari, ma hiri. ");
INSERT INTO jni_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Abanga me a samirka vat a manganga me. ");
INSERT INTO jni_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sa Yeso ma ceki ahira me, arubo wa re wa tarsi unu tisa ume inikara “usam u Dauda burau duru”. ");
INSERT INTO jni_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sa Yeso ma ribe ara kura, arubu wa tarsi me, ma gun we “ya hem in da ke ihuman shi? wa kabirka” ee Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma dari aje a we me ma gun we “Adi human shi barki u hem ushi me”. ");
INSERT INTO jni_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Abini me aje awe me a pokkino, Yeso ma hunguko we titui “kati ibuki aye ba. ");
INSERT INTO jni_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sa wa suro wa samirka a banga me vat a manyanga me. ");
INSERT INTO jni_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A ehn uye sa ugbergene ma karti me tizi awe tantu dusa. ");
INSERT INTO jni_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sa asusso ugbergene me unu me ma tubi tize. Anu sa wa gurna ahira me wa tubi gusa “Dakki ta mu ira ana me anyumo Isarila ba”. ");
INSERT INTO jni_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anu bezi urusa wa gu “Ahap in nikara nu gomo agbergene nini ma suzo agnergene men. ");
INSERT INTO jni_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeso ma tarsi tipinpin nan ti denge tini gura unu bo abanga urunta Asere, nanunu humza ana tikoni sassas. ");
INSERT INTO jni_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sa ma ira anu wa gurna gbardang ma kunna ugogoni uwe barki ijassesa wazin unu same sarki unu benki, kasi item ige sa izome unu nakura. ");
INSERT INTO jni_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma gun nanu tarsa ume me “katuma ka ori gbardang, ana katumame cingilin. ");
INSERT INTO jni_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Barki ani me ikko ni ugomo Asere ukatuma ma tumi innanu akatuma wa wuzi me katuma”. ");
INSERT INTO jni_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Barki titi anu tarsa umeme u kirau in nana ware, ma nyawe ni kara nu suzo agberdene abit. Wa hummu zan inti koni sasas. ");
INSERT INTO jni_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A na kadura ukirau na na wera tiza tiye, unu tuba saminu desa atissame bitrus nan nu henu me Andrawus, a yakubu vanu Zabadi, nan nu henu me yahaya. ");
INSERT INTO jni_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","A filibus, nan Bartamawus, nan Toma, a matiyu unu kabsa ikirfi, nan yakubu vanu Halfa, nan yahuza. ");
INSERT INTO jni_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","A saminu bakani ane, nan yahuda isikarayoti desa ma nya yeso atanri tana madini. ");
INSERT INTO jni_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","We ukirau inna na ware yeso matu mi we, mabuku we, magu, “Kati irebe a ma nyarga manu tame tize ta Asere nani ani ain ni masamariyawa. ");
INSERT INTO jni_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Senke iha ahira itam anu isaraila. ");
INSERT INTO jni_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","I zin tanu in tize turunta, innugussa ti gomo taere ta aye mamu. ");
INSERT INTO jni_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Humu zzni inna nu zatu nuhuma, i hirza anu wijo, i vissi makuturu, i suzo agbergene. Kasi gussi sa ya kem anime, anime ani idi nyin zi. ");
INSERT INTO jni_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kati i inta ikirfi ya zumo a wal-wal, ba nani a zumo alau, nani azumo abit, u cira ushime. ");
INSERT INTO jni_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kati iziki u badau atanu tishime, nani turunga kare, nani akwatak nan nu bina, yawuna uri unu ma ri anyimo akatuma kame. ");
INSERT INTO jni_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vat nipinme sa ya ribe, i nyari unu u tep i wuzi ni gen ni shine ni u shi. ");
INSERT INTO jni_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Inki idi ribe akurame i gu ga aja u shi. ");
INSERT INTO jni_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Inki akura ahuma ani, wadi kabi ni issi ni shime, inki a zoome ahuma ba idi kuri wada kababa. ");
INSERT INTO jni_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vat desa magame ubuka utize nan shi, nani makunna tize tishi, innu suro ushi ikuburukka ussusuru utubuna tishime idusa. ");
INSERT INTO jni_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kadundure kani, inboshi roni tize me adi tekki innu cekki uni pin nu sabo ma nan nu gomarata inni nipin niginome. ");
INSERT INTO jni_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","I ye, matumashi kasi itam atii amadaru. Anime cukuno ni jinji kasi iwa, anu zatu ticari kasi ihurbe. ");
INSERT INTO jni_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wuzani seke innanu, wadi hanshi ati gomo, wa cobi shi ati denge tini nonzo nuweme. ");
INSERT INTO jni_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wadi hanshi aje ati gomo barki mi, barki ibuki immum aje anu zatu urusa utize ta sere. ");
INSERT INTO jni_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Uganiya sawa hannan shi, kati i wuzi ma aye matize sei di wuzi ba, nani imummu ubuka. ");
INSERT INTO jni_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Dakki shewani idi buki tize meba, bibe ba coo ushime bini bukki ati nyo ti shime. ");
INSERT INTO jni_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","U henu madi nya uhenu ahume, a coo maddi nya vana. A' hana wadi wudi uzattu kunna wawu a hu anka coo. ");
INSERT INTO jni_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ko davi madi game shi barki mi, vat desa ma tonno in i kara me mani madi kem u bura. ");
INSERT INTO jni_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","In ki wagame u ira ushi ani pin me i akki uhana aje. Vannu nu madizee a shii da sarki ukatee uti pin-pin ti isaraila. ");
INSERT INTO jni_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Unu tarsa u dungara mada akkame unu dungarame ba, urere madaa aggi zame una kura ame ba. ");
INSERT INTO jni_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yabari unu tarsa unu dungara ma cukkuno kashi unu dungara ume, ure re kassi una kura ame, in watitta una kura ba'al zabul, ana kuramee wadi titti me ani! ");
INSERT INTO jni_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Katti ikkunnabiyau ba, barki imum be sa i inpi idi pokino nani imum be sa izi nihunzi adi dezi ini. ");
INSERT INTO jni_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Imumbe sa yakkunna abi bukkum inye ne assrer ibezi. ");
INSERT INTO jni_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Katti kunna biyau banu huna unu, wadake wada huname bibeu buwe ba, senke ikunna biyau bide sa madake ma hu bibeu me nan ni pun vat akura ura. ");
INSERT INTO jni_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Daa, vana ubi uyin ikobu ini re ini ba? bire bidi da wonome sarki u hem ume. ");
INSERT INTO jni_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Marusa vat ugwardan utice ti shine. ");
INSERT INTO jni_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kati kunna biyau ba ugancan ushine uteki umu uyin gwardang. ");
INSERT INTO jni_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Anabu wa be zum uhem, micangi indi bezi uhem ahira a coo uru asesere. ");
INSERT INTO jni_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Desa magu na ma taa me, mi cangi indi gu in taamme amuhe nu ma nabu ahira ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kati iziki ma aye innu runta uni a nyomo unee um. U vira uni daa gi uruntaba. ");
INSERT INTO jni_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma ayee ni inpati unu ishina nan ka coome, u ca nan ka inome, unee nan nu giri. ");
INSERT INTO jni_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","I di cukukono ana kura wani ani shina unu. ");
INSERT INTO jni_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Desa mateki innu hemun inka coo nan ka ino daki ummani mazi ba, ane ani vana nan nu ca daki um mani ba. ");
INSERT INTO jni_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Desa daki mazikka ugankirka utiti umeme ba, daa yawuna uri macukuno umba. ");
INSERT INTO jni_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Vat desa ma hem inni ce nume, ma di diri nini. Vat desa madira nice nu me barki mi, madi kem asesere. ");
INSERT INTO jni_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Desa maa hemmin shi, mahemmim mi, desa mahemmin mi mahemmin desa matuma. ");
INSERT INTO jni_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Desa mahem in ureunu kurzuzo u tize madi kunna urunta unu kurzuzo tizee. Dedesa mahem innu adili madi kunna urunya uadili ne. ");
INSERT INTO jni_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vat desa ma nya ure vana uledai umei barki me unu tarsa ummani madi da dirame imum b a. ");
INSERT INTO jni_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sa yeso ma mara ubo anu tarsa ume me tize tigeme anu belum, ma tarsi tipinpin tuwe me unu dungara anu. ");
INSERT INTO jni_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ugzniya me yahona unu baptisima ma rani akura ani rere. Sa mamunna timum me sa yeso mazi unu wuza me matumi ara nutarsa ume me ahira me. ");
INSERT INTO jni_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wa ikki me “Ho mani unu aye me na nii tibe?” ");
INSERT INTO jni_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeso ma kabirka ma gun we “Kuroni i ka buka yohana imum be sa ya ira nan ige sa ya kunna. ");
INSERT INTO jni_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Arubo wa kem u ira, anu zati uti buna wazin tanu, anu koni kunna unawa mapum wa humza, aluri wa kunna tize, azin unu vangizi umu kizi azin unu bezizi anu tize turunta. ");
INSERT INTO jni_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Unu rinbirka mani de sa ma hem ime.” ");
INSERT INTO jni_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sa wa dusa yeso ma ri aji unu bo anu tizi anice ni yohana magu, “Ya aye ani ja i iri nyanin i iri tikpe ti jojoko sa upebu uzun unu hurse mee? ");
INSERT INTO jni_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ya suro i iri nyanini i bassa idi iri de sa ma kokki tirunga tiririn? Ana kura ugomo wani wa sonsi tirunga tiririn. ");
INSERT INTO jni_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya suro i iri nyanini? Unu kurzo utize ta Asere? Eh, in bo shi mateki unu kurzuzo utize ta Asere. ");
INSERT INTO jni_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Me mani sa a nyirtike anice nume me inu guna.” Imbe ma tuma una kadura ma aggize we aje, de sa madi barka we una sa udi eh. ");
INSERT INTO jni_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kadundara in bo shi daki amu yoo uye sa ma biki yohana unu baptisma unu gbardang unee ugeme ba. Vat ani me unu cin ati gomo ta sere ma takki me. ");
INSERT INTO jni_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Datti uganiya u yohana unu baptisma u aye ukani ti gomo ta Asere tizin unu kenzi ijunguta, ani junguta wa nyara wa buri ti gomo ta Asere in ni kara. ");
INSERT INTO jni_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anyumo udungara u musa nan anu kurzuzo utize ta Asere vat wa buu abanga ati gomo me yohana ma duku eh in na dummu. ");
INSERT INTO jni_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ingi izin niruba ukaba me, Elesha ma zigeme, de sa maazi ma di eh. ");
INSERT INTO jni_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Una ti tui tu kunna ma kunna. ");
INSERT INTO jni_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nyarini indi batti ucara ugemen? Ka si ahana ani buji ni bi ranzan unu gusa in na roni awe me. ");
INSERT INTO jni_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Ta hurse shi ishiriwa ya game morso ta wuza shi alali iwono ya game aso.' ");
INSERT INTO jni_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sa yohana ma eh sarki are sarki usa wa gu mazin na gbergene. ");
INSERT INTO jni_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sa vana unu ma aye ma ri a ma sizi wa gu ma zin tire kang nan bisizasiza, uroni wa nu kabsa ikirfi ima uyanga nan anu caran, vattin ani me tanu tunu tiki bezi urusa Asere. ");
INSERT INTO jni_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeso ma wuzi kubung ati pinpin me sa ma wuzi ti mum ti dandang barki sa wa game ubarka. ");
INSERT INTO jni_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wadi hu Ukorasin! Wadi hu Ubetsaida! Dagi ti mum ti dandang sa a wuzi anyumo ashime ani a wuzi utaya nan Usidon wada barka datti wa tiri mapori wa hummi muto apum awe me. ");
INSERT INTO jni_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","In booshi ahira ugomo Asere adi kunna ugogoni wanu Utaya nan Usidon sarki shi. ");
INSERT INTO jni_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hu ukatarnahum ubassa adi nonzo we uhana Asere? Um-um adi kaska we uhana ahira ati cukum tani wono. ");
INSERT INTO jni_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Daagi ti mum tidandang sa awuzi we tini. Adi teki unu kunna ugogoni wanu Usodom nan shi.” ");
INSERT INTO jni_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Uganiya uni yeso ma gu. “Ma wuna apuru, arum aco, ugomo Asere wa seseri nan unee, barki sa wa hunze anu rusa nan anu poko aje timum tigeme wa kuri wa bezi ahana acicin. ");
INSERT INTO jni_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Anime ani hu aco, barki sa imum me sa ya wuna we reb ya zigenne me. ");
INSERT INTO jni_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aco um ma nyam timum vat, aco me mani ma rusa vana me cass vana me marusi aco me cass nan de sa vana me mahem ma bezi me. ");
INSERT INTO jni_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aye ni ahira am, shi an de sa izin nijassi nan ucira ugittak indi nya shi u venke. ");
INSERT INTO jni_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nyani ace ashi me atize tum barki me unu gongoni mani nan iruba ishew, idi kuri ikem uvenke amuruba mu shi me. ");
INSERT INTO jni_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Barki tize tum tizi shew, ucira um uzome gittak ba.” ");
INSERT INTO jni_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Uganiya uginome uwui wa asabar uni, yeso ma wata a tiruu ti zalkama, anu tarsa umeme wa kuna ikomo, wa tubi uhuba i alkama areme. ");
INSERT INTO jni_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sa anu bezi urusa wa ira anime, we gun we, “Ira, anu tarsa uweme wa zinu wuza imum ige sa idi rize awuzi unu wui asabar ba.” ");
INSERT INTO jni_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma gun we, dayamu ira imum me sa Dauda ma wuzi sa ma kuna ikomo ba, me wan aruni atanu tumeme. ");
INSERT INTO jni_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sa ma ribe udange Asere ma ri imumare sa yazi ya Asere igebe sa yazi dayari ime ba, nani aroni ameme wari, anu akatuma ka Asere wani cas wa rizi. ");
INSERT INTO jni_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nani dayamu ira anyimo atize ta Asere, unu wui asabar, anu katuma ka Asere wadi wuzi katuma uwui asabar sarki u ira aburi. ");
INSERT INTO jni_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","In bushi uye be sama teki aginome. ");
INSERT INTO jni_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Daagi irusa ani me, ami ticukun ti runta tini nyara da uya uni ceba, da ida ira aburi ana buri ba. ");
INSERT INTO jni_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Barki vana unu memani Asere Asabar. ");
INSERT INTO jni_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mari aje unu ribize ati denge ta Asere. ");
INSERT INTO jni_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Urunu ma rani desa tari me ta wi, wa iki Yeso, wa gu, “Ya wuna uri ahuman unu nu rono Asabar?” Vat anime wa barki wa kem ahira umeki uni. ");
INSERT INTO jni_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma gun we, “Cangi aveni a unyimo ashime ingi ma zin in katuma, ku rizi anyimo uwa rono Asabar, mada meki kuni masusuba. ");
INSERT INTO jni_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka huno kani unu ma tami kutam ku ginome, barki anime ya wuna uri awuzi imum mu i huma uwui wa Asabar.” ");
INSERT INTO jni_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sa yeso ma gun unu nume, “Wito tari tuweme.” ma witi, ti kuri ti huma gusi ti umureme. ");
INSERT INTO jni_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anu ubezi urusa wa suri, wa gamirka tize ani ce numeme, unu nyara una uhuna ume. ");
INSERT INTO jni_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sa yeso ma tinka we, ma hiri ahira me, anu gwardang wa tarsi me, ma humani in we vat. ");
INSERT INTO jni_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma kwadiwe kati wa buki aye abanga me. ");
INSERT INTO jni_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A'anime barki a nyinca ubuka ishaya agi. ");
INSERT INTO jni_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“U rere um be sa ma zauka, desa mara iriba in, de sa iriba in irumza barki me, indi wu me bi be biriri, madi buu anu zatu tarsa tize ta Asere una ukadure. ");
INSERT INTO jni_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mada cara iriba nani ma buu haw-haw, ba desa madi kunna ni myira nu me u nah. ");
INSERT INTO jni_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nisubo sa na biki upura ni puraba; upitila sa wa biki uwuno uda wono ba, kadura adi ri aje. ");
INSERT INTO jni_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Anu uzatu tarsa Asere wadi inki iriba ani za unmeme. ");
INSERT INTO jni_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","A eh me unu babana urubo desa ma zin na agwergene, ma human in me, ku babana kabuki tizze mu kuri ma iri ahira. ");
INSERT INTO jni_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Anu vat wa gamirka tizze, wa gu, “Nani unuge mani vana u dauda?” ");
INSERT INTO jni_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sa anu ubezi urusa wa kunna anime wagu, “Unu ubari uba, zabul ugomo agwargene, unu me ma su zo agwegene.” ");
INSERT INTO jni_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeso sa marusa ugamara uweme, magun we, “Vat tigomo sa ta harzina barki ni eru, ti di curno. Nipin nani akura sadi harzina barki ni eru sadi adi ir aje. ");
INSERT INTO jni_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ingi unu uburi masuzo unu uburi, wa harzina ahira ani eru azigino me. Aneni tigomo me tidi tunno? ");
INSERT INTO jni_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ingi unu bari u ba, azabul uni suzo agwergene, ahana ashime we, wa suzo unu bari wa vi? I anime we wani wadi cukuno anu bara utize tishime. ");
INSERT INTO jni_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ingi me unu bari ubi be biriri ba Asere in suzo agwergene anime, tigomo ta Asere ta aye shi a zigino me. ");
INSERT INTO jni_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Adi wu aneni aribe a kura unani kara a ciri me tirunga, indaki atuba utira umemba, adi ku cari tirunga ta akura me. ");
INSERT INTO jni_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Desa da mazo nan mi ba, nan debe sa mazon in orso nan mi ba madi samirka. ");
INSERT INTO jni_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Barki anime in boo shi, na ti veteni vat madini marume, nan usizikeme wanu, vat desa ma sizikeme bi beu biriri ada ceke meba. ");
INSERT INTO jni_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Vat desa ma tissa vana Asere, ca a veteme madini mameme. Dasa ma titta bibe biriri, ada vete madini mamebe, une nan-akura iwono. ");
INSERT INTO jni_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nani igu matiti ma rizi uyo me cangi urizi, nani igu matte mazi zenzeg uyo me cangi uda rizi meba, barki a tingiza utiti ahira uyo me uni. ");
INSERT INTO jni_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Shi ahana iwa, aneni ida ke i bu tizze ti huma, sa izi ana aburi, barki imum be sa ya re iriba, ine ini unu ma boo. ");
INSERT INTO jni_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Unu iriba ishew, anyimo iriba shew imeme maka wuzi imum mu ihuma, unu uburi, anyimo ani hara niburi numeme maka wuzi imum mu iburi. ");
INSERT INTO jni_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","In booshi, uwui umara une vat imum be sa unu ma wuzi adi gunguno ini. ");
INSERT INTO jni_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tizze tiwe tini tidi burwe, nan ti ri w. e” ");
INSERT INTO jni_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aye anu dungara wan na nu bezzu urusa, wa kabirka me wagu, “Unu dungara, ti nyara ti iri bire bi huri ahira aweme.” ");
INSERT INTO jni_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeso ma kabirka we magu, “Anu uneh ana aburu. Anu bezi uzatu hem, wa nyara wa iri bihuri, bi huri bi zoni sa adi bezzi we in daki bi Yunasa unu ukurzo. ");
INSERT INTO jni_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kasi sa Yunusa mawu tiye ti taru uwui nan niye anyimo apuru abicere, ane ani vana unu madi wu tiye ti taru niye nan nuwui anyimo adizi. ");
INSERT INTO jni_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Rono uweki utizze ti unineba wadi hiri nan anu uneh ugeme wadi reki we. Nani wadi hem in tizze ti Yunusa abame. ");
INSERT INTO jni_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rono uweki utizze ti ugomo ane u kudu, madi hiri wanna nu uneh ugeme madi reki we. Barki ma eh usuro upingaru une ma kunna urusa u Sulemanu. Desa mateki sulemanu mayeh. ");
INSERT INTO jni_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sa ugwergene ubit ingi masuro ahira unu, madi tarsi ti hira ti uzatume umei barki u nyara u venke, mada kenze ba. ");
INSERT INTO jni_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Abinime ani madi gu, 'In di kuri akura sa ma suroni.' Ingi makuro, madi kem akurame unu ma zoni aciki anime. ");
INSERT INTO jni_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Abinime ani madi ha maka inta agwergene usunare sa wa teki me ini mumu iburi. Wa ribe wa cukuno abini me. Unu uginomr ticukun ta dumo me ti teki ta jeme uni curnome. Ane ani idi cukuno inune uburi ugeme.” ");
INSERT INTO jni_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mara anyimo atizze nan nigora, a inome nan anu henume wa turi a matara. Wanyari wa buki tizze wan me. ");
INSERT INTO jni_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Uye ma gun me, “Uwari uweme nan anu henu uwe me wa turi a matara wa nyara ubuka utizze nan hu.” ");
INSERT INTO jni_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma kabirka magun me, “Aveni a ino um? Aka veni anu henu um?” ");
INSERT INTO jni_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma witi tari uwatu anu tarsa ume, masa, “Uwari um be nan anu henu um. ");
INSERT INTO jni_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vat desa ma wuza imum me sa aco um, anyimo aseseri ma nyara, memani u henu um, nan ka ino um.” ");
INSERT INTO jni_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Roni ginome yeso ma suri akura me, maha maka cukuno ani kiru nu raba udanga. ");
INSERT INTO jni_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nigura na nu gwem ni orno ahira ame, maribe uzirgi mackuno. Nigura me ni orno uhana ubinani. ");
INSERT INTO jni_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mabuwe timumum gwardang in nu rezi utize, magu, “Uye maha atibira. ");
INSERT INTO jni_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mara anyimo ucobo isana ire hoo irizi una, i nyin itingi ini. ");
INSERT INTO jni_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ire irizii upambara sarki manyanga. Isuri memme rum. ");
INSERT INTO jni_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sa uwui wanyen-nyene i nami iwu lau iwazi. ");
INSERT INTO jni_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ire irizi anyimo ikana, ikana i gwinciri ini. ");
INSERT INTO jni_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ire irizi a manyanga mariri, iwu bihoo, irre ak kem mareu ma'inoa-ino, irre akuru tattasi, ire akura tata-taru. ");
INSERT INTO jni_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Vat una titui tu kunna ma kunna. ");
INSERT INTO jni_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anu tarsa ummeme wa e, wagun me, “Nyani yawuna uzin innu bo u we tize tigino me?” ");
INSERT INTO jni_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma kabirka we magu, “A hem shi irusi tigomo ta sesere, daki weme ba. ");
INSERT INTO jni_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Barki unimu ake akinkimen ā makem gwardang. Unnu dira ā kabi imumbe sama zini ");
INSERT INTO jni_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ine ini ya wuna in zunu bo uwe tize in gamari anime. A myincikina ubuka u Ishaya agi. Kunna idi d ");
INSERT INTO jni_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A hira uce me tize ti Ishaya ta minca, ta guana anda sa ula kunna wadi kunna, shi iso shi unu una be sa idi rusi; ahira uhiraa idi hirii, abine ani idi cukuno sarki urusa. ");
INSERT INTO jni_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mu ruba mamuwuna makotoros, wa korso titui tuwe, wakuru wa korso aje awe, barki kati wa iri in na je awe nami, wakun na intitui tuwe, wakuri warusin inni riba i we wa gamirka in human we.' ");
INSERT INTO jni_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aringirka aje ashime barki sa ahira, nan titui tishime barki tikunna. ");
INSERT INTO jni_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","In boshi kadure, annu kurzuzo utize wa bara bi barka bu hira imumbe sa i hira a anime daki wa ira nani wakunna ba. ");
INSERT INTO jni_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","A tizee tunna ti bira tigino me sa ma wuza. ");
INSERT INTO jni_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vat dee wuza makunna tize ta azesere daki wuza katumani ba, unu buru ma huppi imumbe sa abira anyimo iri a imeme. I nee ini isana sa ya rizo azesere una. ");
INSERT INTO jni_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","I gebe sa ya rizo apo, ine ini unu innu kunna utize amawu puru arum. ");
INSERT INTO jni_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mazomen inni tini, i ye uzattu utonno ame, tak inki uzito wa kemme anyimo atize tasere ama piliko. ");
INSERT INTO jni_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","I gesa ga rizo anyimo ikana, ine ini debe sa ma kunna tize ta sere barki urunta imummu unee tize me tida wuza katuma ame ba. ");
INSERT INTO jni_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","I ge de sa ahira amanyanga mariri, i nee ini debe sama kunna tizeme, ma wuza katuma ni. Kadun dure we wa ni anu kem umare ma inoa, i no nan akurtat tasi uye akura ta'aru. ");
INSERT INTO jni_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ma ewen tire tize anyimo atize, magu, “Adi tigomo ta sere nan nunu be sa ma cofo isana uru ume. ");
INSERT INTO jni_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anu wa rari inti moro, oroni masuri maha maka coffo isana i'ure ukwe sas anyimo i alkama me, madusa. ");
INSERT INTO jni_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ti bira me ti hiri ni gome, ukwe u bezi nice ni uni. ");
INSERT INTO jni_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Arere una kuame wa e wagun me 'Unu kura, isana iginome daa ya rizi ba? Ane ni ya wuna ukwe?' ");
INSERT INTO jni_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Magun.' we urrunu uburu mani ma w uza katuma ka gino me; Arere me wagun me, ani tika kara ti orii?' ");
INSERT INTO jni_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Magun we, 'Um kati ahira ukarame ikari nan bi sana me. ");
INSERT INTO jni_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cekkini i'u zi nigome u hana uganiya uwesi, “Indi buki anu wesi me wasuso ukweme sas wa tirzi uni atira tiri a punsi, bi hoo me a wu ukere.'” ");
INSERT INTO jni_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma e' we tire tize anyimo atize, magu, “Tigomo ta zesere kasi gussi bi hoo bibiwi, gussi sa uye maha maka bira uru ume. ");
INSERT INTO jni_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bihoo bicin anyimo amatiti, inki wa una, uke u'aki marre matitin in nu gwuik, inyin ike i bari masu iri me.” ");
INSERT INTO jni_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Makuru manyawa tize anyimo atize magu, “Tigomo ta zezsere tizi kasi uyisti uni, u ge be sa uru nee ma ziki mu ina mu alkama muso mataru maduri vat mamari.” ");
INSERT INTO jni_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vat yeso ma uu ni orime tize a nyimo tizee. Madaa bowe imum senke ini tize anyimo atze. ");
INSERT INTO jni_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Barki amyincikina ubuka u Ishaya a gi, “Indi buki tizee anyimo atize indi kiti imumbe sa izi ni hunzi da ati utuba une.” ");
INSERT INTO jni_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ma cekki ni orime maribe akura, a u tarsa u yeso wa e'ahira ame wagu, “Bee zin duru tize anyimo alize titi kwe anyimo uruu. ");
INSERT INTO jni_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma kabirka we magu, “Unu cobo isana iriri iginome memani vana unu. ");
INSERT INTO jni_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Urume une, uni unee; isana iriri ginome wewani ahana ati gomo tasere tikwe ahana unu uburu. ");
INSERT INTO jni_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Debe sama coffi isana iginome, unu buru mani. Uganiya uwesi une uni umara unee, a u wesi me wewani ibee ikadura kasere. ");
INSERT INTO jni_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kasi, gussi sa orso tikwe, ane ani icukuno umara unee. ");
INSERT INTO jni_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Vana unu madi tumi i beu ikadura kameme, andebe sa wawuza nu upillizo vat, nan nanu wuza anu wawuzi nihara niburu, wasussowe atigomo tume. ");
INSERT INTO jni_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A di rekuwe anyimo ura ubanban. Washi abini me warumzi ti nyo. ");
INSERT INTO jni_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A bine ani anu asheu wadi nya masa atigomo ta coo uweme. Una titui tu kunna wa kunna. ");
INSERT INTO jni_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tigomo ta zezsere kasi ukem uni sa, urari a dizii uru, ugebe sa uye ma kem, makur makorso uni anyimo urume ma zizi bi sana vat innu be zizi apuru arum ame maka kwa u rume. ");
INSERT INTO jni_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tigomo ta zessere kasi unu kem mani, imum iriri ihuma. ");
INSERT INTO jni_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sa maa kem imum iriri i indai, ba maha maka ziza imumbe samaa zini makwi ini in. ");
INSERT INTO jni_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","U hanna ukanime tigomo ta zessere tizi kasi ikalli sa a reki uraba udang, imensi icere sas, sas. ");
INSERT INTO jni_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Saya myinca, ahunguko ini ani kira acukuno a zawi icere ihuma me, areki ani ruu, izenzen me a sairka. ");
INSERT INTO jni_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Umara unee idi cukuno ane ani. I beu kadura ka Asere wadi shri, wa wati anu aburu anyimo anu huma. ");
INSERT INTO jni_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wa rekuwe anyimo ukabisa. Wadi shi warumzi tinyo. ");
INSERT INTO jni_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Yarusa agino vatti? wagu e. ");
INSERT INTO jni_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Magun we, “Vat anudungara atarrat sama cukuno anu tarsa uti gomo ta zessere, kasi u akura mani, de sa maa inta imummu itari isoo na ni kuzu i so.” ");
INSERT INTO jni_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sa yeso mamara tize anyimo tize, ma hiri ahira me. ");
INSERT INTO jni_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sa maa aye ani pin nuwe me, ma dun garwe ati denge tutarsa Asere, imum ibi yau imekuwe wagu, “Abani uni u geme makem urusa ugeme anime nan nu besi ubari? ");
INSERT INTO jni_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Unu geme daki vana una si ba agino ani baa? Da anu he reewani in yakubu, nan yusufu, a saminu, nan yahuza baa? ");
INSERT INTO jni_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Anu henu umeme a'ee wa zōo ni gome nan haru baa? Abani unu ugeme ma kem imumu igeme vat ana me?” ");
INSERT INTO jni_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wa pilizo barki me. Ba yeso magun in we, “A i adaa nyinzame unu kurzuzzo tize ta Asere uturu ume ani pin nu we nan na kura awe me ba. ");
INSERT INTO jni_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dakki mawuzi imumu bari gwardang abirkome ba, barki u zatu hem uwe. ");
INSERT INTO jni_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Uganiya me ugomo hiridus antitas makunna abanga a yeso. ");
INSERT INTO jni_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Magun nanu aka tuma kameme yohana ubaptisma mani. A hirza me a hira ani wono, ine ini ya wuna mazin una bari u wuza uti mum tidandand. ");
INSERT INTO jni_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","I rusa hiridus mā meki yohana ma tirzizi me ma han me akura ani rer barki hirudiya, unee u henu u filibus. ");
INSERT INTO jni_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Barki sa mā buki me idda rizi me ma wuzi anya nan Hirudiya ba usuro u, inko utize. ");
INSERT INTO jni_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus ma nyari uhuna ume, ma kunna biyau barki sa anu wa ziki me unu kurzuzo utize ta Asere mani. ");
INSERT INTO jni_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sa uwui uyo uhiridus wa kete uca u hirudiya ma wuzi morso anyumo anu Hiridus ma kunna urunta kang. ");
INSERT INTO jni_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma inki me tize nan itono agi madi nyame vat imum me sa ma ikmo. ");
INSERT INTO jni_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A ino me gun uca me ma nyame nice yohana unu baptisma a'ana me ayumo iso. ");
INSERT INTO jni_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ugomo ma wu apuru abid, barki itono sa mamu wuza anyimo anu ma gu anyame. ");
INSERT INTO jni_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma tuburko akura anirere me a ha aka yoro nice ni yohana. ");
INSERT INTO jni_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A en nice me anyumo iso a nya uca me maka nya a ino me. ");
INSERT INTO jni_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Anu tarsa ume me wa ziki ikizi me waka vatti wa ha wa ka buka yeso. ");
INSERT INTO jni_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sa yeso makunna ani me ma ribe uzirgi umei ma kata a ara hira sa madi cukuno in sisin me. Anu ati pinpin sassas wa tarsi me ati buna. ");
INSERT INTO jni_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sa ma tuno uzirgi me ma iri anu wa orno gbardang ma kunna ugogoni uwe ma hunzan are ana tikoni. ");
INSERT INTO jni_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa uwunjoro wawuna anu tarsa ume me wa ka kem me wa gun me uwui wa mara ceki anu wa ka nyara ace awe imum yare ati hihira. ");
INSERT INTO jni_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeso magu, “Dakiya cukunnu gbass wa dusa ba, nyani we ire ium wa dusa ba, nyari we ire imum wari.” ");
INSERT INTO jni_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wa gun me ubiredi unu cibi uni tizin nan icere ini ire cass. ");
INSERT INTO jni_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeso ma gu nyani mi. ");
INSERT INTO jni_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yeso ma gun nanu me wa cuku ati kpe. Ma ziki ubiredi unu cibi nan ni cere ini ire me, ma yese aje aseseri ma ringirka ma pussi ubiredi me ma nya anu tarsa ume me wa nya niura na nume. ");
INSERT INTO jni_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vat wa re wa tii, wa orre ukasi me umyinca mugira belum. ");
INSERT INTO jni_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Anu sa wa re wa biki aru cibi ahana aruma sarki ane nan ahana . ");
INSERT INTO jni_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sa wa mara yeso ma wu anu tarsa umeme wa ribe uzirgi mei bati wa kuri nikira, ma tonno bati ma gun we wa dusa. ");
INSERT INTO jni_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sa ma gunna we wa dusa ma nyene ani pana in nice nume uwuna ubiringara. A hira abee a me abini me in sisin me. ");
INSERT INTO jni_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Uganiya me sa uzirgi me wa biki atii uraba udandang, i barka imei nun zuro uzirgime, upebu in nishina nan we. ");
INSERT INTO jni_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","In na rumu a taru aniye wa iri yeso ma haka asesere a mei me tantu aye ukem uwe. ");
INSERT INTO jni_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sa anu tarse umeme wa ira me in tannu asesere amei wa kunna biyau wa gu, “Imoli ini,” barki biyau wa wu uhunu. ");
INSERT INTO jni_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yeso ma buki we tize dibedibe ma gun we, “Katti ikunna biyau ba in mani natani muruba.” ");
INSERT INTO jni_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitrus ma kabirka ma gun me “Ingi homani ugomo Asere wuna in ee ikem we asesere amei me. ");
INSERT INTO jni_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeso ma gun me, “Aye.” Sa Bitrus ma suro anumo uzirgi me, ma tunguno tanu asesere amei tantu ka kem u yeso. ");
INSERT INTO jni_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sa Bitrus ma ira upebu me ma kunna biyau ma tubi upirsa ma wu uhunu ma gun, ''Ugomo Asere buram.” ");
INSERT INTO jni_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeso ma witti tari, dibedibe ma meki me ma gun me'' Hu unu hem ucin nyanini ya wuna we uhara iruba? ");
INSERT INTO jni_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sa yeso nan Bitrus wa rube uzirgi me upebu me u tunno. ");
INSERT INTO jni_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","An de sa wa rani uzirgime wa nonzo Yeso wa gun me, “Kadundura hu vana Asere mani.” ");
INSERT INTO jni_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sa wa kafa wa tu a manyanga mu jansarat. ");
INSERT INTO jni_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sa ana nipin me wa rusa yeso mani wa tuni vat ana nyaga me a een na nu ati koni. ");
INSERT INTO jni_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wa ikki me ca w dari udibi ume me, vat de sa maz dāri ma huma. ");
INSERT INTO jni_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A ra anime anu bezi urusa nan anu nyerte udungara u musa wa eh ahira a yeso usuro urushalima wa gu, ");
INSERT INTO jni_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nyanini ya wuna anu tarsa uwe me wapattilka utanda wa nanu? bark sa waka ri imu yere sarki ukpico utari.” ");
INSERT INTO jni_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeso ma kabirka we ma gun, “Nyanini ya wuna shi i pattala tize ta Asere barki utanda ushiq? ");
INSERT INTO jni_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","A gino me Asere ma gu, 'Nya aco uwe me,' nan 'Ka ino uwe me ti nanu, vat de sa ma zogo aco umeme nan a ino umeme a hume.' ");
INSERT INTO jni_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Shi be ya guna, vat de sa ma gunna in ka co umeme nan a ino umeme, “Imumme sa izi idi kem a hira am ma nyanki Asere.'” ");
INSERT INTO jni_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dakki ya cukunu gbass unu me ma nya aco me tinanu ba, barki utanda u shi me ya zika tize ta Azere tizo me anyo imum ba. ");
INSERT INTO jni_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A nu abur ine ini Ishaya ma buuki ace ashime unu guna, ");
INSERT INTO jni_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Inozon me in tinyo tini cass mu ruba mu shi me mu zi pitt nan mi. ");
INSERT INTO jni_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Heem ini i nonzo ni mi, i bezizi utanda wanu anyo atize ta Asere.'” ");
INSERT INTO jni_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeso ma titi anu ma gun we, “Kunnani i rusi.” ");
INSERT INTO jni_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","I mum me sa idi suri anyo unu ine ini idi cari unun inzo imum me sa unu madi ri ba.” ");
INSERT INTO jni_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Anu tarsa ume me wa eh wa gun me, “U rusa anu bezi urusa wa kunna muruba in tize tigino me?” ");
INSERT INTO jni_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeso ma kabirka ma gu, “Vat tibira sa tizome ta co um tini Aseseri ba ca a ruti tini.” ");
INSERT INTO jni_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cekini we a rubo wani zi unu hungo arubo, i ngi urubo ma hunguko urubo vatti uwe wadi rizi anyumo uwaa. ");
INSERT INTO jni_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitrus ma gun me, “Pokon duru tige tize me.” ");
INSERT INTO jni_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yes ma gu, “Ana me daki ya rusa ba? ");
INSERT INTO jni_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Daki ya ira imum sa aka ri, iki tarsa, apuru ika suro ati tere? ");
INSERT INTO jni_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","I mum sa idi suri anyo ine ini iki cari unun barki sa ya suro iruba ini. ");
INSERT INTO jni_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ti mum ti bur ti suso iruba ini, u huna unu, a mura nan une nan uruma sa ma, ome uwe, iruba utarsa ahana aruma nan a ee, nikari, moco nan ti zogo. ");
INSERT INTO jni_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ti mum sa ti car sa unun ta zigene inzo imum sa unu ma diri sarki ukpico utari ba.” ");
INSERT INTO jni_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeso ma dusa uhana amanyanga mati pinpin tu taya nan usidon. ");
INSERT INTO jni_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A bini me uru nee wanu kanana ma eh inu hunu unu gusa” buramugomo Asere, usan u Dauda, ugbergene ma mekim uca uni.” ");
INSERT INTO jni_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeso ma ciki tik, unu tarsa u yeso ma gun me gido me mazi unu wuza uru sisip nan nugbejere. ");
INSERT INTO jni_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeso ma kabirka ma gun we, “A tummam barki itam isaraila sa ya hunna me inzo barki uye ba.” ");
INSERT INTO jni_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma eh ma tungunu ma gu, “Ugomo Asere buram.” ");
INSERT INTO jni_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma kabirka ma gu, “I da rizi me a ziki imumyare ya hana anya ahana i woci ba.” ");
INSERT INTO jni_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma gu, Ee ugomo Asere, a hana iwoci me wa ka ri imumyare sa irizizo a dizi yana tikura tuwe me.” ");
INSERT INTO jni_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeso ma kabirka ma gun me, “Une u hem uweme uzin ni kara, ca imumme sa unyara kukunu.” ");
INSERT INTO jni_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A bini me yeso ma tarsi urabi uraba udandand ugalili. Ma nyene ahira azallan ma cukunun. ");
INSERT INTO jni_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Anu bardang wa eh ahira ameme nigome nan zati uti buna nan tari, arubo, anu nyungurzuno nan aturi wan anu koni gbardang wa inki we ati buna ti yeso ma humman we. ");
INSERT INTO jni_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","I cukuno anu imum ugamara, aturi in tize, anu nyungurzuno wa witino, anu zati uti buna in tanu, arubo uru bira. Abini me wa nonzo Asere u isaraila. ");
INSERT INTO jni_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeso ma titi anu tarsa umeme ma gun, “In kunna ugogoni wanuageme, kani tiye ti taru nan mi, sarki imumyare. In da nyaram in ceki we wa dusa ani me ba kati wa akki wa zitti una. ");
INSERT INTO jni_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Anu tarsa umeme wa gun me.” Abani tidi kem imumyare sa idi bari anu wa gene gbardang ana me, ani jaa nige me? ");
INSERT INTO jni_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeso ma ikki ma gun we” ubiridi uhunnu uni izin? Wa gum” unu sunare nan mu cere mu cinci cingili. ");
INSERT INTO jni_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma wu nigura nanu me wa cukuno adizi. ");
INSERT INTO jni_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma ziki ubiredi u u sunare me nan icere ma ringiga ma pussi, ma nyanu tarsa umeme, wa hari anu me. ");
INSERT INTO jni_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Anu me vat wa ri wa ti, wa ori ukasu me u myinca mu gira usunare. ");
INSERT INTO jni_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anu me waa ri waa biki aru anazi, sarki ane nan ahana. ");
INSERT INTO jni_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sa yeso ma gunan ina nu me wa dusa, ma nyene uzirgi umei ma dusa uhana umagadan. ");
INSERT INTO jni_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Anu bezi urusa nan ma sadukiyawa wa eh ahira a yeso wa nuari ubatta ume, ca ma bezi we imum idandang sa idi bezi ubari umeme. ");
INSERT INTO jni_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma kabirka ma gun we, “Ingi aseseri avuna innu wunjoro, i gu, 'Im-hh nisizo nisa rizi.' ");
INSERT INTO jni_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ingi ya ira aseseri avuna nisisizo abe, igu, kani adi rubu ure. Ya rusa uzina seseri, i dake irusi uzina uganiya ugino me ba. ");
INSERT INTO jni_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anu ganiya ugino me anu zattu rusan Asere wani wani ana buri wa nyara a bezi we imum, ada beze we ba. Si i yanana, yeso ma dusa ma ceki we. ");
INSERT INTO jni_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sa anu tarsa umeme wa hana anire nikira, wa ringi wa pirke me ubiredi. ");
INSERT INTO jni_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeso ma gun wa, “Hirani, i wuzi seke unu yistin wa nu bezi urusa nan ma sadukiyawa.” ");
INSERT INTO jni_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wa tubi ubo acece unu gusa, “Nan uzatu aye unu biredi me unni.” ");
INSERT INTO jni_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sa yeso ma ira anime ma gu, “Shi anu hem ucin, nyanini ya wuna igusa i zoshi unu biredi? ");
INSERT INTO jni_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anu me daki ya rusa ba? mu gira mu hono muni ya oro? ");
INSERT INTO jni_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Uganiya sa ma rin nanu aru anazi uni biredi unu sunare, mu gira muhono muni ya ori? ");
INSERT INTO jni_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nyanini ya wuna daki ya rusa uguna inbo aba ga ubiredi uni ba? ma guna wuzani seke unu yistin wanu bezi urusa nan ma sadukiyawa. ");
INSERT INTO jni_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A bini me anu tarsa umeme wa russi uguna wa wuzi seke in nanu bezi urusa nan masadukiyawa inzo uyistin me sa awuza ubiredi ba. ");
INSERT INTO jni_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sa yeso ma aye ukaisariya ufilibi ma ikki anu tarsa umeme ma gu, “Aveni anu wa gusan vana unu?” ");
INSERT INTO jni_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wa gun me, “Aye wa gusa yohana unu baptisma, aye wa gussi Iliya, wa gussi Irimiya nan uye anyimo anu kurzuzo utize ta Asere.” ");
INSERT INTO jni_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma gun we, “Shi naa, mi aveni?” ");
INSERT INTO jni_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Siman Bitrus ma kabirka ma gu, “Ho mani vana Asere unu ivai.” ");
INSERT INTO jni_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeso kabirka me ma gu, “Hu una re-aje mani siman vana u yohana unubu binama nan maye mani ma bezi we ba aco mani sa ma ra aseseri. ");
INSERT INTO jni_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","In kuri inbu we hu Bitrus mani, anipo nigeme indi bari anu am anu tarsa Asere, an de sa iwono izo me unu bari awe ba. ");
INSERT INTO jni_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","In di nya we mabudi mati gomo ta seseri imum me sa ya tirza une izin unnu tira aseseri, imum me sa ya sopo une izin unu sopo aseseri. ");
INSERT INTO jni_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma hunguko anu tarsa ume me ti tui kang kati wa buki uye agi memani vana Asere ba. ");
INSERT INTO jni_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Abini me yeso ma tubi ubezi anu tarsa umeme ya cukuno me gbass ma ha urushalima make zito sasas atari ta nanu nan anu adandang nan anu unyirte udungara u musa a hume rono uku taru mahiri. ");
INSERT INTO jni_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bitrus ma titi me nikira ma gbarika me ma gu, “Asere awu pit in ani me nan hu, ani me ida kemme hu ba ugomo Asere.” ");
INSERT INTO jni_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeso ma gamirka ma gun Bitrus, “Abame unu bur, hu unu nyara irizi ini, ubassa timum ta nabo tini inzo ta Asere ba.” ");
INSERT INTO jni_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeso ma gun anu tarsa umeme, “De sa ma nyara matarsum ca maya ri me nice nume ma ziki ijassi ma tarsum. ");
INSERT INTO jni_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","De sa ma nyara maburi nice nume madi diri nice nume, de sa ma nyari me nice nume madi kem nini. ");
INSERT INTO jni_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nyanini unu madi kem une vat i ikki nice nume? nani nyanini unu madi nya anyo anice nume? ");
INSERT INTO jni_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Vana unu madi eh nan ana kadura kameme anyumo ani nonzo na co ume me. Abini me madi nya kondevi imum anyo akatuma kame. ");
INSERT INTO jni_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kadundure in bo shi aye ashi me sa wa turi abame wada wono we ba, wadi iri u aye uvana unu anyumo ati gomo time.” ");
INSERT INTO jni_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yeso ma ziki Bitrus adumo atiye utasi, wan yakubu nan nuhe nu ne yahaya, mahem we anire nipo zantaran we i sis iwe. ");
INSERT INTO jni_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","U zi na umumeme uni aje awe, muhene muwu kasi masa mu wui, turunga tuwo me ti wu tirum tizinnu nyinza u masaa. ");
INSERT INTO jni_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","I ye musa Iliya watonno ahira awe, in tize nan yeso. ");
INSERT INTO jni_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","bitrus magun in yeso, “Ugomo Asere, yawuna uri, tirani ahirame. Inki u nyara, inturi madanga ahirame u indai uwe, u indai u musa aa uindai u Iliya.” ");
INSERT INTO jni_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Araa anyimo atize akem uganjimari uma saa wa aye wa inpo we. Akunna nimyiram unyimo uganjimari me, nigussa, “Unigeme vana ummani san in nyara in zini iruba irum imme ka, kunnani me.” ");
INSERT INTO jni_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sa anutursa u yeso wa kunna anime wa rizi adizii, biyau bimikiwe. ");
INSERT INTO jni_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeso ma'e madarwe, magu, hiranii kati kunna biyau ba. ");
INSERT INTO jni_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sa wa yeze ace daa wa ira u nuba, wa iri yeso mani cas. ");
INSERT INTO jni_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wara anyimo utuno anipome, ba yeso ma kpadu we magu, kati ibuki u ye imumbe saya ira, senke vanu unu mahira anu cau. ");
INSERT INTO jni_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Anu tarsa u yeso wa iki me, wagu, ane-in anu dungara utize ta taura, wagu, yaa cukuno Iliya ma aggi za u aye? ");
INSERT INTO jni_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Makabir kawe magu, yaa cukunno iliya madi e barki madi cikki i cukuno. ");
INSERT INTO jni_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","I nee ini inboshi, Iliya mamu aye, wa taa' meni ba, wuzame imumbe sa wa ira yawunawe. ");
INSERT INTO jni_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A nee ani vana unu madi zitti atari tuwe me. Abinee ani anu tarsa u yeso wadi ku rusin inti zeme, ti yahaya unu zorsizanu tini. ");
INSERT INTO jni_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sa wa biki ahira ani gura, urrunu ma e ahira ame, matungono, aje amee, magu. ");
INSERT INTO jni_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ugonaa sere, kunna ugogoni u vana um, mazinnu zitto in matirizi, kan mahari ki u rizizzo ura nan mei. ");
INSERT INTO jni_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi be mahannan we ahira anu tarsa uweme iye daa warusa u humanime ba.” ");
INSERT INTO jni_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ba yeso ma kabirka we magu, shi anu u zattuu hem in tize ta Asere, anu agwas u ganiya ugeme! innu mayaa uni indicukuno nan shi? innu maya uni indi dodon kuno shi? me nin me abanna. ");
INSERT INTO jni_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ba yeso ma bubbukime, bibe bunu burume bi cekime, vana ma huma. ");
INSERT INTO jni_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anu tarsa u yeso wa'e ahira me wa hungu kome ani kira, wagu nyaani ya wuna maa gaa haru u suso?” ");
INSERT INTO jni_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Magun we, “Ucin uhemu shi uni wa wunu” kadundure kani in bo shi, gussi izin nu hem cin kaasi umustad, ida gu nan innipo niginome, hira abanna me ukuri abirko!” ani kuhiri aherame immumu ugame ushi izoni. ");
INSERT INTO jni_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Usasana iginome ida susso me ba senke in biringara nan niwe nimei. ");
INSERT INTO jni_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A wada ugalili, yeso magunwe, “Vana unu adi nya atari ta nu. ");
INSERT INTO jni_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Adi hume, roono ukku taru adi hirzame.”Vat wa in pino intipuru ti bit. ");
INSERT INTO jni_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sawa aye ukafar nahum anu kabsa ukassu ikirf ubenki utize tu dengesere wa ha ahira abitrus, wagu, “Unu dun gara ushime ma'nya uben?” ");
INSERT INTO jni_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma gu, “E, make ma nya.” Sama ze akura, yeso ma buki me tize magu, “Bitrus nya'ani wa ira?” Avee ni agomoo nee wa orso ikirfi ahira hanna a we, nani ahira a'aye. ");
INSERT INTO jni_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Samaa guna, “Ahiraa aye” ba yeso magun me, “A nyo azika me ahanna me. ");
INSERT INTO jni_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Vat in anime, barki kati ti carwe hana uraba udang uwuzzi tiwita, bicere sawa tuba u mikime uziki. Inwa pokko anyome udi iri ikirfi anyimome u ziki ikirfi iginoo uhaweni in, nan iwe”. ");
INSERT INTO jni_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Uganiya uguno me anu tasa umeme wa eh ahira a yeso wa ikki me wagu, “Aveni ma teki unu gbadang anyimo ati gomo ta seseri?” ");
INSERT INTO jni_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ma titi vana ucin anyumo awe. ");
INSERT INTO jni_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma gu, kadundure inbo shi in daki ya kurzo ace ashi kasi ahana acicin ba ida ribe shi anyimo ati gomo ta seseri ba. ");
INSERT INTO jni_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Vat de sa daki ma zika nice anyo ire imum kasi vana ucin ugeme ba, mada ribe me ati gomo ta seseri ba. ");
INSERT INTO jni_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Vat de sa makaba vana ucin kasi ugeme barki mi, i mani makaba. ");
INSERT INTO jni_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Vat de sa ma wunā unu inde anyumo a hana ageme macara abangan sa wa hem in mi, idi teki a tirzi me unanzu udandang irir areki me anyumo uraba udandang uconcon. ");
INSERT INTO jni_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wa dee une barki ucara abangan ya cukuno gbass ucara ucara abanga u eh, de sa ma wuna una me ma dee. ");
INSERT INTO jni_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nyoro ubuna nan tari tuwe me u vetten ingi ti wuza we ucara abangan iteki uriba ati gomo ta seseri inu buna u inde nan tari ti inde wanu guna areki we anyumo ura uzatu umara inti buna tuwe tire nan tari tire. ");
INSERT INTO jni_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ingi nije wuwe upilko kara nini uveten, iteki uribe ati gomo ta seseri in nije ni inde innu areki we anyumo ura in naje arere. ");
INSERT INTO jni_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hirani kati i izi unu inde anyumo ahana acicin wa geme ba, in bo shi ibe ikadura ka Asere aweme aseseri wa hira muhenu maco um de sa mara anyumo aseseri. ");
INSERT INTO jni_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","I rusa vana unu ma aye barki ma buri an de sa wa hunne we. ");
INSERT INTO jni_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","I bassa ingi urunu mazin ini tam ini ni ino bi inde ba hunne me i hira mada ceki me ukasu me ma dusa unyara ubi inde me ba? ");
INSERT INTO jni_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ingi ma tinka bini, iruba ime me idi rume i teki unu ni, ino uzati ubi inde me. ");
INSERT INTO jni_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ani me ani aco ushi me sa ma rani anyumo aseseri mada nyarā me unu inde anyumo a hana acincin wa geme mahunne ba. ");
INSERT INTO jni_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ingi u hennu uwe me macara we abanga, hana uka buka me hu nan me, ingi makunna we wa bura me. ");
INSERT INTO jni_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ingi daki makunna we ba nyara unu inde utizi anyo ana ware nan watara ikeki. ");
INSERT INTO jni_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ingi daki makunna we ba, ubuki anu tarsa Asere ingi magame ukunna anu tarsa Asere uziki me de sa ma tame Asere nan unu cara abangan sa magame ubarka. ");
INSERT INTO jni_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kadundura inbo shivatti imum me sa ya tira une izin nutira aseseri imum be sa ya sopo aseseri. ");
INSERT INTO jni_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","In kuri inbu shi, ingi anu ware anyumo ashi me une wa hem wa iko ire imum, aco um sa marani anyumo aseseri madi nya we. ");
INSERT INTO jni_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Barki vat ahira me sa ana ware nani wataru gurnan izi na we. ");
INSERT INTO jni_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ara anyumo anime Bitrus ma eh ma gun yeso, ugomo Asere kani ka hono kani uhenu um madi carrum iruban in vette? kanu sunare? ");
INSERT INTO jni_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeso ma gun inzo kanu sunare ba akuru sunare kanu sunare. ");
INSERT INTO jni_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Barki ani me adi bati tigomo ta seseri nan urugomo sa ma nyara ma bassa ucira ume me atari tarere ame me. ");
INSERT INTO jni_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sa ugomo me mara anyumo ubassa me a eh mu reme wazurta sa matarsa me uge sa mada ke makurzo ba vat uciki ume une. ");
INSERT INTO jni_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sa madira ukurzo men, ugono magu azizi me nan une me wanna hana me vat nan imum me sa mazin akurzo ikirfi men. ");
INSERT INTO jni_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Urere matunguno ma gun me nata iruba indi kurzo we kondi nyanin. ");
INSERT INTO jni_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ugomo me makunna ugogoni urere me maceki me ma ceki ureme me. ");
INSERT INTO jni_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sa ma suro magurna nan ure uroni me sa matarsa me ureme ikiirfi cin ma tappi me iriri ma gu nyam imumme sa in tarsa we. ");
INSERT INTO jni_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Uroni me matunguno ma gun me nata iruba indi kurzo wen . ");
INSERT INTO jni_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Urere me ma ga me mahan unu rani me akura ani rere, agi makurzo men. ");
INSERT INTO jni_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sa aroni akatuma wakunna imum me icari we muruban wa kurzo ugomo imum nan. ");
INSERT INTO jni_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ugomo matiti me ma gun me gu unu ubur mani, ma ceki vat imum me sa imtarsa sa wa tizom. ");
INSERT INTO jni_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Daki ya wuna inu ukunna ugogoni uroni akatuma kawe ba? ");
INSERT INTO jni_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ugomo makunna iruba kang ma gu anyame titere makurzo vat ureme sa matarsa me. ");
INSERT INTO jni_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ani me ani aco um sa marani anyuno aseseri madi wuzi vat de sa ma nyari me uceki uhenu umeme ini ruba ka inde. ");
INSERT INTO jni_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sa yeso mara tize tiginome vat, macekki manyanga mu galili, maribe uyahudiya sa uraa in nuhuru umacanga mu urdu. ");
INSERT INTO jni_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ni orinanu gwardang ni tarsime, ma humuzan we abirko me. ");
INSERT INTO jni_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Are anu bezirusa wa e ahira me wabatime, wagu, “yawuna ari unu ma cekki unee ahira kadiya imum?” ");
INSERT INTO jni_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma kabirka magu, “ani daa yamu ira uguna desa mabarwe daat, utubame mabarwe unee nan vanuu mar?” ");
INSERT INTO jni_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Makuri magun we, unu madi cekki a inoo nan ka coo ume, mapattina nan unee ume ware wageno wacukuno nipum ni inde. ");
INSERT INTO jni_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Uhana je dakki apum are ba, ni inde ni ni, imumbe sa Asere apatta katti unu ma hari ini. ");
INSERT INTO jni_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba wa gun me, “Nyaa ni yawu musa magu kini anyettiki ahu anya, nani a cekki unee ma dussa?” ");
INSERT INTO jni_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Magun we, “Barki ugbas ushi uni wawu musa mahem shi anime, daa ti utuba idazome aniba. ");
INSERT INTO jni_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","In kurin bushi, dee sa ma cekki unee ume, inki daki ma wuza imumu zenzen in ba, maka zika uru nee sas mawuza imum izenzen ini, debe sa ma zika unee me sa agido cangi ma wuza imum izenzen.” ");
INSERT INTO jni_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Banu tarasa wagun me, “Inki ane ani izi a tii nunan nu ne ume, uzatu wuza nyame uteki.” ");
INSERT INTO jni_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Magun we, “Daki koya nu mani madakee maziki ani me ba, senke da sa ahem imme anime. ");
INSERT INTO jni_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aye wa rani ayozowe ane ani, aye warani anu wani wuna we ani me. A ye wewani inna ce u we barki unyara utigomo ta zesere. Vat unu kunna utize tigeme ma ziki, ama ziki.” ");
INSERT INTO jni_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","U ganiya uginome a e men ina hana acincin barki matarwe tari, ma wuwe biringara, ba anu tarsa umeme wa kuburka we. ");
INSERT INTO jni_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ba yeso magu, “Kini ahana a cincin wa e ahira am barki tigomo ta sesere me tu saa sana uwee uni. ");
INSERT INTO jni_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","“Bama tarwe tari madusa. ");
INSERT INTO jni_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ba uye ma'e'e' mamu nan me magu, unu dungara nyani indi wuzi in kem u vengize uzatu marsa?” ");
INSERT INTO jni_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bama gunme, “Nyaa u'ige zom ahira imum e' gebe sa izi i huna? unu huma unu inde mani, inki unyara u kem ivei uzatu marsa, tarsa in u buka ugeme” ");
INSERT INTO jni_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bama gunme, “Uyayya?” Yeso magu, “Katti uhunu ba. Katti u wuzi zenzen ba. Katti uwuzi nikariba. Katti ubuki imun mu igebe su tawe inni ba. ");
INSERT INTO jni_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nya acoo nan ka ino uwe tima nu, u hem innu hoo kasi ni ce nuwe. ");
INSERT INTO jni_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ba manyani me magunme, “Vat mamu tarsan anime, nyani ya dem?” ");
INSERT INTO jni_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeso magunme, “Imum inde ini ya de we, hana uka ziize vat imumbe sa uzini, unya ande sa akara amara, udikim gwardang a zesere. U' e, utarsum?” ");
INSERT INTO jni_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sa ma nyani ma kunna anime, ma dusa, inna puru abit barki me unu imum manikam. ");
INSERT INTO jni_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ba yeso magun innanu tarsa umeme, kadundure inboshi idi cukkuno in ni jas si uni mum maribe atigomo ta zesere. ");
INSERT INTO jni_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Akkanime inboshi, idi teki innu seke uronkomi uribe ani hara na lira, innu guna unu kem maribe ati gomo ta zesere. ");
INSERT INTO jni_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anu tarsa umeme biyau bimek we sa wa kunna anime, wagu inka anime ani avee ni madi kem u bura. ");
INSERT INTO jni_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ba yeso ma iriwe, magun we, “ahira anu, daa imimu wuna uniba, ahiraa sere kodi nyani idake wu. ");
INSERT INTO jni_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ba bitrus makabirka magu, “iye ta cekki adodu aru vat tatar sawe, nyaani tidikem?” ");
INSERT INTO jni_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeso magunwe, inboshi kadundure, uganiya uso sa vana madi cukkuno ukwanku uti gomo tume, shi saya tarsam, shi wani idi cukkuno u kwanku alem ukirau in kare usarila. ");
INSERT INTO jni_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Vattu shi ya censi ti kura, nan nanu henu a'e, anu henu aruma, nan ka ino, nani acoo nan na hana, atiru, barki nizanum madi kem gwardang, makuri makem ivai zatu marsa. ");
INSERT INTO jni_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Anu tuba gwardang wadi cukuno ana dumo ana dumo wa cukuno anje. ");
INSERT INTO jni_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ti gomo tz seseri tizi kasi una kura sa ma suro ni sissizo u nyara anu sa wadi wuzi me katuma u in nabi. ");
INSERT INTO jni_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sa wa barka nihiri ma hanwe uru. ");
INSERT INTO jni_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sa ma masuro inna zumo utara ma kem aye wa ciki sarki katuma kuwuza. ");
INSERT INTO jni_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma gunwe, “shima tarni wa hem indi nya shi imum iihuna” wa hem. ");
INSERT INTO jni_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sa makuri masuru unu wui inna zumo ataru ma han in aye. ");
INSERT INTO jni_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Makuri masuri in na zumo udibi ma kem aye, wa turi heem a ime, ma gun we nyanini ya wuna ituri heem anime? ");
INSERT INTO jni_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wa gun me, daki ta kem de sa madi nyan duru katuma kani ba, magun we, “Hanani uru um changi” ");
INSERT INTO jni_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sa uwunjoro wa wuna ma gun unu tarsa unu rume tita ana katuma me u nya kondevi ikirfi ime, tuba ahira an de sa we wani wa aye inna dumo u masirkan ande sa wa tuba u aye. ");
INSERT INTO jni_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","An de sa wa aye inna, umo uchibi ma nya we ikirfi inni hiri. ");
INSERT INTO jni_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Anu tuba aye me wa bassa adi kinki wen, wa iri a nya we ikirfi ini hire nini. ");
INSERT INTO jni_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa kabi unu curno me iruba. ");
INSERT INTO jni_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","In nu gusa haru sa ti hiri usa uwui hu be wa nyan duru ikirfi rep nan an de sa wa wuna u awa u inde inka inna. ");
INSERT INTO jni_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma kabirka unu inde anyumo awe me ma gun me, uroni um barki ma wuza shi zenzen ba. In gusa ta barki ni hiri nini? ");
INSERT INTO jni_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kaba imum sa izi iwe udusa mi mani ma iri ya wunna uri in uya ana dumo me rep na hu. ");
INSERT INTO jni_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Daki ma bari iwuzi imum sa ya wunam in imum in ba? nan ni ukunna inni eru mini barki sa inzin iruba ubenki gbardang? ");
INSERT INTO jni_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ani me ani ana dumo wa di aje anaje wa kuri anaje wa kuri adumo. ");
INSERT INTO jni_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yaso nan anu tarsa umeme sa wa haka unyene uhana urushalima, yeso ma hunguko we nikira nuna ma gun we. ");
INSERT INTO jni_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Haru be tihaza urushalima, adi nya vana unu atari tunu udandang u katuma nan anu nyerte udungara u musa, wa di gu a hume. ");
INSERT INTO jni_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Adi nya anu zati utarsa Asere me wadi wuzi me nibasa, wa cobi me gankirka me, unu wui utaru adi hirza me.” ");
INSERT INTO jni_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abini me a eno ahana zabadi ma eh nan ahana ameme wa wa turguno awu henu mu yeso ma gu inyara iri imum. ");
INSERT INTO jni_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeso ma gun me, “Nyanini unyara?” ma gu “Wuna ahana am ware wa geme wa cukuno anyumo ati gomo tuwe me unu inde atari tinare unu inde tari tinan gure” ");
INSERT INTO jni_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeso ma gun nahana me, “Itashi imum me sa i igizo ba, idake isi iso ijasse sa indi si?” ");
INSERT INTO jni_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","wa gun me “ti da ke” Ma gun we, “Kandundure ida ke isi iso im, u cukuno atari tinare nan ni tinangure inzo mimani ini kara nu nya ba aco um asesri ma inki barki de sa ma zauka” ");
INSERT INTO jni_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ukasu anu tarsa ume ukirau me wa kunna iruba wanu kasu ana were me. ");
INSERT INTO jni_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yeso matiti we vat ma gu, “I rusa ubere sa agomo ande sa inzo a yanhudawa wani ba wa ka bezi anice nanu awe, ananu aweme cangi anice wa bezi ubari anice nanu awe. ");
INSERT INTO jni_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ida cukuno me anime anyumo ashi me ba, de sa ma nyara macukuno unu udandang gbas macukuno una katuma ku kasu ushi. ");
INSERT INTO jni_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","De sa ma nyara ma cukuno unaje ashi, gbas macukuno urere ushi. ");
INSERT INTO jni_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ani me ani azi vana unu ma aye inzo agi awuzi nirere ba, me mani madi wuzi nirere bati maburi anu gbardang” ");
INSERT INTO jni_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sa yeso nan anu tarsa umeme wadi ceki ujeriko, anu gbardang wa tarsi we. ");
INSERT INTO jni_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wa kem arubo were wa ciki ani kira nuna, sa kunna yeso tatu aka wa yeze amyiran wa gu, “Unu dang, usn u Dauda kunna ugogoni uru” ");
INSERT INTO jni_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Anu wa tarika we agi wawu tic wa kuri wa kinki uyeze amyiran wa gu “unu dang usan u Dauda buran duru.” ");
INSERT INTO jni_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeso matonno ma gun we, “I nyara in wu shi aneni?” ");
INSERT INTO jni_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wa gun me, “Unu dang tinyara tikem u era ahura” ");
INSERT INTO jni_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Barki ugogoni yeso ma dari aje awe me, apokino uganiya me wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sa Yeso na nu tarsa ume me wa hana agiro a betafaji ani hoho ni matiti muzaitun, Yeso matumi anu tarsa umeme ware. ");
INSERT INTO jni_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma gun we, “Hanani anyimo agiro aje ashi me idi ir atirza ku zenki i sapi i eh mini. ");
INSERT INTO jni_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","In ka uye ma iko shi igu ugomo Asere mani ma nyara, unu me madi nya shio debe debe.” ");
INSERT INTO jni_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ya cukuno anime bati a mwincika imujm me sa unuukurzo utize ta sere ma gu. ");
INSERT INTO jni_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Buka ni bi sana bi urushalima, irani ugomo ushi me monno tantu aye ushi una ni ce ni shew ma haka azsere aku zenki. ");
INSERT INTO jni_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Anu tarsa umeme wa wuzi imum sa ma wuna we rep. ");
INSERT INTO jni_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wa ehn ku zenki me wa tari turunga tuwe me Yeso ma cukuno, ");
INSERT INTO jni_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","maro mani gura me wa nasa tirunga tiwe me una me aye wa pussi mava wa nasa una me. ");
INSERT INTO jni_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Anu me sa wa haka aje a Yeso nan anu tarsa ume wa yeze amigwiran wagu,” Hossana vana uDauda ugongon mani dee sa ma aye ani za ni gomo Asere. Hossana una ni nonzo kang. ");
INSERT INTO jni_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sa Yeso maribe uurshalima nipim niwu buu unnu gusa, Aveni mazigeme? ");
INSERT INTO jni_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nigo nanu ni kabirka,” Yeso unazarat nan ugalilio mani unnu kurzo utize ta sere.”. ");
INSERT INTO jni_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeso maribe udenge Asere magidi ana biziza nan ana bikpija kpija a nyimo me, ana ka curo kikirfi nan makpankun manu ziza uma hurbe. ");
INSERT INTO jni_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma gun we, “nyettike akura am adi cukuno ahira abi ringara, shi be ya kurzo ani ahira ugunzuno akari. ");
INSERT INTO jni_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A rubo nan nanu zatu tibuna wa eh anyimo udenge Asere ma human we. ");
INSERT INTO jni_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sa ana dangdang aka tuma nan anu nyerte udungara u musa wa ira timum tibi yau sa ma wuza wa kunna a hana inti hunu a nyimo udenge me unu gusa, “Hossana vana udauda muruba mu curno we. ");
INSERT INTO jni_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wa gun me, ukunna imum me sa anu ageme waboo? Yeso magun we eh! daki ya ira unyettike atinyo ta hana nan na hana anige wa suso ninonzo nuwe me? ");
INSERT INTO jni_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A binime Yeso ma suri ani pin me ma dusa uhana ubetanya maka mura abini me. ");
INSERT INTO jni_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sa makuro ani pin me nisisizo makunna ikomo. S ");
INSERT INTO jni_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","a ma ira utiti upom ani kira nu na ma haa daki makem ire imum ni ba, si mava, ma gu uni,” kati uka yoo ba, abini me utiti me waa. ");
INSERT INTO jni_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sa anu tarsa umeme wa ira wa kunna biyau wa gu “Awuza ana nime utiti upom me wa waa ana me? ");
INSERT INTO jni_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeso ma kabirka ma gun we kadundere in boshi in gi izi innu hem sarki uhara iruba, idi wuzi imum sa iteki ige sa a wuza utiti upom, idi gu unu pana uhira uka rizo uraba udang i cukuno anime. ");
INSERT INTO jni_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Vat imum be sa ya iko in biringara a nyimo uhem idi kem. ");
INSERT INTO jni_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sa Yeso maribe a nyimo udenge Asere anu adangdang aka tuma nan anu ww eh ahira me wa gu,” in ni ya nikara nini uzin unuwuza im ");
INSERT INTO jni_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","um igeme? aveni ma nya we nikara me? Yeso makabirka ma gun we, mi cangi in di iki shi imum indai, inka ya bukani mi, in di buki shi ini kara na veni in zin katuma ka geme. ");
INSERT INTO jni_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubaptisma uyohana wa suri abani wa suri a hira Asere a hira anaboo? wa gamari ace awe unu gusa,” ");
INSERT INTO jni_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ingi ta guna ahira Asere, madi gu nyanini ya wuna daki ya hem mi ba. Ingi ta guna a hira anaboo, ti ta duru imum me sa anu wadi wuzin duru ba barki sa wa zika Yohana unu kurzo utize ta Asere mani. ");
INSERT INTO jni_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wa kabitka wa gun Yeso, ti tan duru ba, ma gu in we “mi in da bukam shi nikara sa in wuza timum ti geme ba cangi.” ");
INSERT INTO jni_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ani nya nini ya ira? uye ma zin na hana ware a ruma, ma ha a hira anu tuba me ma gu “usam um hana ka wuza katuma ku ruu. ");
INSERT INTO jni_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Vana ma gu,”inda hanam ba”. unu sa ma eh inna dumo magamari maha. ");
INSERT INTO jni_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aco me ma ha a hira unu kure me ma buki me ma gu, indi ha aco um. ma gaa me uhana me. ");
INSERT INTO jni_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A nyimo awe ware me aveni ma wuza imum me sa aco ume me ma nyari? wa gu “unu tuba me”. Yeso ma gun we,” kadundere im boo shi anu kabsa ikirfi ima nyanga nan anu ziza apum wadi agiza shi u ribe ati gomo ta Sere. ");
INSERT INTO jni_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","I rusa Yohana ma bezi shi una iruba ubenki I ga shi uhem. Anu kabsa ikirfi ima nyanga nan na nu ziza apum wa hem in me. vati ani me daki ya hem ya barka ba” ");
INSERT INTO jni_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kunna ni tire tize ta nyimo, ure unu mara ni ma wuzi tibira uruu me ma bari ugumbi nan a hira upillo umgwei ma ma titi wanu denge unu bee urume ma nya age ma dusa a mare ma nyanga. ");
INSERT INTO jni_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sa uganiya uoro usanna wa aye na tumi arere ame me a hira anu kaba uruu me wa ka bi me ime . ");
INSERT INTO jni_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ani me wa meki arere me wa tiri unu indai wa hu uye wa kuri wa tizi uye. ");
INSERT INTO jni_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Unu uruu me ma kuri ma tumi aye sa wa teki ana je me, ana katuma uruu me wa kuri wa wuzi we kasi ana tuba me. ");
INSERT INTO jni_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A ani me unu ruu me ma kuri ma tumi vana umeme unu guna wadi ka nata me nice. ");
INSERT INTO jni_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sa ana katuma ku ruu me wa ira vana me, wa gu na cec, usam me mani Ca ti hu me ti can ti uruu me. ");
INSERT INTO jni_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Abini me wa ziki me wa suri a nyimo uruume wa ka huna me. ");
INSERT INTO jni_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ani me ingi unu ruu me ma aye nyanini madi wuzi ana ka tuma kuruu me? ");
INSERT INTO jni_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Anu wa gu madi hu anu abur agino me unaa upazaza, ma kabi uruu me ma nya aye sa wadi nya me inni ganiya U uro usana. ");
INSERT INTO jni_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeso ma gun we,” daki ya ira a nyimo u nyettike Asere, Nipo me sa ana soo wa nyari me niney nini na cukuno ni huma, anime ani a hira Asere ani imum ibi biyau ini aje aruu. ");
INSERT INTO jni_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Barki anime in boo shi, ti gomo ta Asere adi kabi ashi a nya wnde sa wadi yozo ahana. ");
INSERT INTO jni_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dee sa ma rizo ani po ni geme madi pussa magitum, dee sa nipo me na rizo ame nidi nyezirke me. ");
INSERT INTO jni_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sa ana dangdang aka tuma nan anu bezi urusa wa kunna tize tini hunzi tumeme wa russi ma boo we wani. ");
INSERT INTO jni_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wa nyari umeki ume wa kunna biyau banu, barki sa anu wa zika me unu kurzo utize ta Asere mani. ");
INSERT INTO jni_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeso ma kuri ma wuzi we tizze ma bati we ire imum magu. ");
INSERT INTO jni_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Adi bati tigomo ta Asere nan ure ugomo desa ma wuzi vana umeme igab. ");
INSERT INTO jni_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Matumi anu utarsa umeme wa titi andesa aboo we wa ēh ahira igab me andesa aboo. ");
INSERT INTO jni_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Makuri ma tumi are anu tarsa umeme ukure, magun we, ka bukani we mamu mara ubara imumare a wesi ina wan bige be sa a inta bini akura, vat a mara ubara ukodi nyani ayeni igab me. ");
INSERT INTO jni_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A' ani me wa game uwna uni cheni, wa dusa we imum iwe, uye madusa me uru uye madusa uziza adadu. ");
INSERT INTO jni_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ukasu me wa miki arere una akura me, wa duri we wa hoo we. ");
INSERT INTO jni_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ugomo ma wu iriba, ma tuburko anani kara nini kono numeme, wa ka huna an desa wa wuza me anime wa punsi ku pin me vat. ");
INSERT INTO jni_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Magun in nanu utarsa umeme, nigura me na cukuno nigora an desa aboo we ni da wa ha nam ba. ");
INSERT INTO jni_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Barki anime hanani ana tukun ani pin, boo ni vat adesa ya kem, wa ē anigora me. ");
INSERT INTO jni_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anu tarsa umeme wa dusa utarsa uti naa, wa urso vat an desa we kem ana aburi nan ariri vat a urso we a ēni, ahira anigora a myinca ina ganu. ");
INSERT INTO jni_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sa ugomo ma ribe u ira unigora ma iri ure unu da ma suki udibi u aye unigora ba. ");
INSERT INTO jni_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ugomo ma gun me, unu-ubu aneni wa aye bame sarki udibi unigoraa unu me da kem imum i buka ba. ");
INSERT INTO jni_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ugomo magun inanu utarsa umeme, tirani me tibuna nan tari i vengime anyimo mare mabibiti abini me adi shi a rummizi ahini. ");
INSERT INTO jni_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Atiti anu gwardang anyimo aweme azauka ana acin. ");
INSERT INTO jni_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafarisawa wa gomirka imumu i gebe sa idi cara tizemeni. ");
INSERT INTO jni_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wa tumi anu tarsa umeme ahira mer nan adesa wa zinan Hiridus, wa gu, unu ubu haru ti rusawe una kadure mani, uzini udungara tize ta Asere gwem barki wa zika kodavi. ");
INSERT INTO jni_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bukan duru imumme sa wa ira, ya wuna uri ti nya imumme sa izi ikasari nani ani. ");
INSERT INTO jni_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sa yeso ma tinka imumu imu riba mu weme, ma gun we nyanini wuna inyara imansam shi ana mu riba muburyi. ");
INSERT INTO jni_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bezi mi ikirfi, wa dusa wa ēn me in bikirfi. ");
INSERT INTO jni_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeso magun we, ihuri igeme nan niza ini geme na veni. ");
INSERT INTO jni_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wagun me, ni kaisar nini ba magun we, nyani kaisar imum be sa izi i kaisar Asere imum be sa izi ya Asere. ");
INSERT INTO jni_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sa wa kunna anime, wa kunna biyau wa dusa we. ");
INSERT INTO jni_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Uwui uginome mara masa dukiya wa (an desa wa gusa, ingi wa wono uka hira uzoni) wa ē ahira ameme, wa ikime. ");
INSERT INTO jni_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wagun me, unubu musa magun, ingi unu ma wono da ma ceki uye aduma ba, uhenu me madi cukuno nan uneme anime barki ma yoo uhenu ahana. ");
INSERT INTO jni_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A wuzi aye anu usunare ahana aruma ani henu nu weme, unu utuba ma wuzi ya sa ma wono barki da ma yooba ma ceki uhenu umemeni uneme. ");
INSERT INTO jni_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ane ani unu ukureme ma wuzi nan unu utaru me, awuzi anime uka biki unu su sunareme. ");
INSERT INTO jni_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sa wa mara uwuza ugino me, une madusa ma wi. ");
INSERT INTO jni_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Uwui uhira a yimo iwono, une wa aveni madi zi anyimo aweme anu usunare uginome barki vat uwe wa wuzi aya nan me. ");
INSERT INTO jni_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeso makabirkawe magun, ya camani barki sa ida rusani tize ta Asere ba, ida kuri irusi shi ubari Asere ba. ");
INSERT INTO jni_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Barki uwui uhira anyimo iwono, anyā azoni uwuza anyā uzoni, ti di cukuno kasi ibe ika dura ka Asere sa wara aseseri. ");
INSERT INTO jni_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Abanga uhira anyimo iwono, dayamu iraba imum me sa Asere a gushiba agi. ");
INSERT INTO jni_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mimani Asere aweme ma vengize dā anu zatu uvengize waniba. ");
INSERT INTO jni_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sa anu wa kunna anime, wa kunna biyau ini mumme. ");
INSERT INTO jni_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafarisawa sa wa kunna mā maran in masadukiyawe, ba wa urno. ");
INSERT INTO jni_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Unu inde anyimo aweme, ure unu bezi urusa barki ma mansa me ma iki magu. ");
INSERT INTO jni_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Unu dungara, nyanini itteki in nikara anyimo tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeso magun me, hem in na Asere aweme ini riba iwe me me vat nan nice nuweme. ");
INSERT INTO jni_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ine ini imumu idan dan in nu tuba . ");
INSERT INTO jni_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","I kure izi gusi ituba ini, hem inu henu uweme gusi nice nuweme. ");
INSERT INTO jni_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ahira imum kare kagino vat tize ta Asere nan ta anu dungara ta hem in. ");
INSERT INTO jni_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Datti afarisawa wa uri ahira a inde, ba yeso ma iki we. ");
INSERT INTO jni_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Magun we i ciram aveni, mi vana aveni ba wagun me vana udauda mani. ");
INSERT INTO jni_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeso magun we, aneni Me Dauda me unu bari u bi be biriri ba Asere ma kuri magu. ");
INSERT INTO jni_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Asere agunka Asere am, cukuno a tari tinare tum, indi tari we aseseri ade sa wada nyara u ira uweba. ");
INSERT INTO jni_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ingi Dauda matita Asere anime, adi wu aneni ma cukuno vana umeme. ");
INSERT INTO jni_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba desa ma kuri mā buki tize, abini me unu iriba ihu mazoni sa madi kuri ma iki me iri mum. ");
INSERT INTO jni_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeso mawuzi we tize, magu. ");
INSERT INTO jni_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Anu dungara wa taurat nan nanu bezi uru wa tonno u turi umu sa. ");
INSERT INTO jni_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Barki anime, tarsani i wuzi vat imumbe sa wabuka shi, kati i wuzi imum sa wazin nu wuzame ba. ");
INSERT INTO jni_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wake wa caniwwe cira ugittak, ujas uhanna, wacana anu uni agirza we acece awe wadake wa hana ba. ");
INSERT INTO jni_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vat biwuza wuza buwe aje anu ani, wabara iliya idandang in ti di bi tuwe u tuzo adizi. ");
INSERT INTO jni_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wa nyara ticukum ti gan can a hiri agab, nan tihira titi cukum ti hu ma udenge Asere. ");
INSERT INTO jni_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A issiziwe ati hira tini gura, agussin we anu dungara. ");
INSERT INTO jni_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kati hem a gussin shi anu dungara ba, barki unu dungara ushime u inde mani vat tu shi ni henu nini. ");
INSERT INTO jni_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kati ititi uye acoo anyimo unee, barki acoo u inde mani asesere. ");
INSERT INTO jni_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kati atiti shi anu tarsan nanu wani ba unu tarsan na nu memani yeso. ");
INSERT INTO jni_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","De sa mazi unanu anyimo a shi me mani urere. ");
INSERT INTO jni_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vat desa m yeze nice nume, adituzo me, desa ma tuzo nice adi yeze me. ");
INSERT INTO jni_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Shi wono shi anime anu dungara, nan anu uyetike a nu bezizi urusa, ana mi yakorsizo tina turibize azesese ace a shi, shi dakki ya ribe ba. ");
INSERT INTO jni_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Shi wono shi anu dungara wataura nan nanu bezizi urusa, ana matin! ike iri imumare aneme sa anu ruma wawijo ike hunze tubunani in bi ringara bi jokon anime azin nu tara u shi. ");
INSERT INTO jni_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Shi wono shi anime, anu dungara wataura, nan nanu be zizi rusa, anamalin ike tar si ti hihira nan ma rba ma dandn dang, barki unyara unu tarsa ushi cas inki ya kem ikurzo me una yimo ura. ");
INSERT INTO jni_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Shi wono shi, shi anu hungo arubo, shi sa igussa, vattu shi yatonizo undenge Asere imum i zoni, aname desa ma tonikon in ni mumu ihuma udenge Asere, itoni idi rime. ");
INSERT INTO jni_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Shi ababana, arobo! iya ini iteki shi innu gwardang, bizinariya bini nani udenge Asere sa u zi lau. ");
INSERT INTO jni_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ike gu, kodavi matoniko innu bagadi sadi ga imum izoni. vat de sa matoni kon innu wito nice, itono idimekime. ");
INSERT INTO jni_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Shi arubo iya ini iteki innu gwarndang, u sadiga uni nani ubagadi uwito sa u zi usadiga alau. ");
INSERT INTO jni_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Barki anime kovi magoni kon in nu bagadi uhaya sa uzi lau nani vat inni mumbe sa ira anyimo me. ");
INSERT INTO jni_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Vat desa ma tonikon innu denge Asere, matonikon me, nan desa mara anyimo me. ");
INSERT INTO jni_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","koda vi matonikon na zesere, matonikon inn hira ati cukuno tu gomo masere. ");
INSERT INTO jni_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Shi wono shi anu dungara wataura nan nanu bezizi urusa, anamalin! ike isusso imum ye sere reppii? Iye yavete imumu ihuna ini kara ya taura, me ini kadure, nan imum iriri, ubeziu inko iginọ ini ya wuna inguna iwuzi, kati iceki ireba ba. ");
INSERT INTO jni_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anu hungo arubo, ike i inki iruba u kwaro dan mitsil, anime ike itu be ronkoni. ");
INSERT INTO jni_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Shi wono shi anu dungara wa taura nan naun bezizi uru sa, anamalin! ike i kpici mamaru miso anyimo me ini madiri. ");
INSERT INTO jni_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hu urubo unu bezi urusa! tuba u kpico u mamaru miso udiku kpici anyumo me barki mataraa macukuno lau. ");
INSERT INTO jni_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Shiwono shi, anu dungara ataura nan nanu bezizi urusa, anamalin! kasi mucau sa a humuka muni, amatara anyimo me a ubo ani zenzen. ");
INSERT INTO jni_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aje shi ana huma wani, iye a nyimoo malin mani in katuma kaburu. ");
INSERT INTO jni_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Shiwono shi anu dungara ataura nan nanu bezizi urusa, anamalin! ike i bari tikura a mu cau manu dang akatuma ka sere, ibara tihira. ");
INSERT INTO jni_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Igusa da ta cukuno uganiya acokoro aru utuba, sa daki ta benkuwe u kwon gizo umaye manu adang akatuma. ");
INSERT INTO jni_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","A anime ya bezi ace ashi, she wani ahana uhuza ana katuma kadang ka sere. ");
INSERT INTO jni_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ba mincikinani katuma kacokoro ashime. ");
INSERT INTO jni_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Shi iwa! aneni idi sumi u gwari ka anyimo ura. ");
INSERT INTO jni_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Barkin anime ma tuman shi ana katuma kadang kasere, nan nanu urusa imum, nan anu rusa atau ra, idi huzi aye awe i gankirka aye, icobi aye suwe ti pin tipin, in nu mnsa uwe u zitto. ");
INSERT INTO jni_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Barki nihaiki ni maye manu nanni ruba ubenki a kponkoni unee, makuro ace ashi uzi ka umaye mahabila unu uriri uhana uma zakariya unu barikiya, desa ya hu atii udenge Asere. ");
INSERT INTO jni_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kadure inboshi, vat agimo me adi kem anu ganiya ugeme. ");
INSERT INTO jni_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Shi ananu u urshalima! ananu urshalima anu huzza ana katuma ka dang kasere, anu vingizi an de sa atuma ahira ashi! ka ka hono kani manyara in orso shi kasi bi tukuru sabike bi orso ahana anyimo ama gawre mabini! ");
INSERT INTO jni_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iyenne aceki shi akura anime. ");
INSERT INTO jni_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","In bossi shi, idaka ira miba, senke ronobesa ya guna, biringara bi cukuno ahira unu ezen ni za ni gomo sere.” ");
INSERT INTO jni_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeso masuri u denge Asere, mara anyimo atanu anu tarsa umeme awa e innu be zizzi ume bibara-bara biti denge tuta sa Asere. ");
INSERT INTO jni_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bama kabirkawe magu, “Vat ya ira tinii? ka dundure kani in bosh, adi samariri ka apo age me ada cekime nire a sesser anire ba.” ");
INSERT INTO jni_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ma ciki ani po nu zaitun anu tarsa ume me wa e ahira ame wagu, “Bukam duru, uya uwui uni adi wuzi anime? nyani idi bezi uguna u ye uwome? nan nu mra unee?” ");
INSERT INTO jni_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ba yeso makabirka magu, wuzani seeke katti uye ma witi shi. ");
INSERT INTO jni_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Barki anu wadi e gbardang anyimo ani za num, wagu we wani Asere, wadi witti anu gbardang. ");
INSERT INTO jni_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","I di kunna tizee tini kono nan bi bobo binin, kati muraba mushime muhiri ba, uwuna anime wacukuno a wuzi daa umara wa aye ba. ");
INSERT INTO jni_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Anabu wadi hirza anabu, tigomo tidi hirza tgomo. Adi uzi ikomo nan uzuruzuno adi zii ati hira sassas. ");
INSERT INTO jni_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ani vat utuba u zitto uni. ");
INSERT INTO jni_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","A' anime wadi witi shi, apatti shi wakuri wa huzzi shi anu vat wadi nyaree shi barki in za num. ");
INSERT INTO jni_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A' anime anu wadi pilizo abardang, wari inama ya ce'ce wa nyarime ace'ce. ");
INSERT INTO jni_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anu kurzuzzo utize tima cuco wadi suri, warangizi anu gbardang. ");
INSERT INTO jni_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Katuma kaburu kadu wu gben u hem umaro manu uduwu seeke. ");
INSERT INTO jni_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Adi buri desa ma tonno. ");
INSERT INTO jni_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Adi wuzi tize titi gomo tazeesere vat anyimo unee ugeme abuki anabu, unee wa aye umara. ");
INSERT INTO jni_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","A' anime inki ya ira kattuma ka zenzen fai kaso, ka gebe sa daniyel unu kurzo uti mabuka, atura me ahira a lau (u nu hira me rusi). ");
INSERT INTO jni_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tu, ande sa wa ra ama canga mayahudiyawa sumi uribe anyimo apo. ");
INSERT INTO jni_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Desa makunna biyau, kati matu u ka ziki udee sa mara akura amme. ");
INSERT INTO jni_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dee sa mara uruu cangi ugebtu umee ba. ");
INSERT INTO jni_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Udee ana tipuru nan nanu cira a hanna uganiya uginome. ");
INSERT INTO jni_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wuzani bi ringara kati usum ushime u wui uvenke inni kuzi. ");
INSERT INTO jni_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Uganiya uginome adi wuzzi i jassi kan, usassana igibe sa nu mansa u wuzame daati utubbu nee u aye ukani me, adaa akuri a wuzi me ba. ");
INSERT INTO jni_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bansa a kaska tiye tigino ba, ada'daa kemme de sama game ba. Barki anu zau ka uginome a kaska tiye me. ");
INSERT INTO jni_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","A' anime desa ma gunna shi, ya ira ugomo Asere monno! nani, monno abirko! katti ihemba. ");
INSERT INTO jni_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Barki ugomo Asere nan nanu kurzuzzo utizee tina cuco wadi suri, wabezi katuma ka dandang ku bari, barki wa hunze ande a zauka inki yawuna. ");
INSERT INTO jni_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ta, mabuka shi dibe. ");
INSERT INTO jni_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A' anime inki wagunan shi, “monno ani ja” katii suriba inka nain waguna, monno anyimo ati hira ti gunzine, kati ihem ba. ");
INSERT INTO jni_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gussi umelme azeesere, mel mel ane ani u aye uvana unu udi zi. ");
INSERT INTO jni_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A hira me sa aush araa ni abmee ani magulluk marsa maka orzino a hira me. ");
INSERT INTO jni_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ussuro ijassi ginome, a inpi u wui upeu udaa nya masba. Iwiran ya sesere idi rizizzi, adi zaa rika imumbe sa ira azesere ");
INSERT INTO jni_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uganiya uginome uni u' aye uvana unu udi cukkuno, vat alem unee adi shi, wadi iri vana unu ma ezze aniyimo a tiwiri, innu bari nan ni nonzo gbem. ");
INSERT INTO jni_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Madi tumi ibe ikadura kameme wa hure nihure na so kan, wakuri wa orso me anu ati kira ti nazi nyimo unee. ");
INSERT INTO jni_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Manzani ahira utiti upuom, ukee u zarika inki nikuzi na aye mamu u tiro. ");
INSERT INTO jni_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Rusani vat inki ya ira adodu aginome ma aye mamu ini. ");
INSERT INTO jni_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka dundure kani, inboshi uganiya akame sarki uguna imumu igino idi kem. ");
INSERT INTO jni_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A zesere nan na dizii adi mari, atize tum ni. ");
INSERT INTO jni_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Baa dee sa marusa u wui nan nu ganiya uginome, nani ibe ikkadure kasere, nani vana senke acoo mani cass. ");
INSERT INTO jni_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kasi uwuza uganiya u Nuhu, anee ani idi cukuno u' aye uvana unu udi zi. ");
INSERT INTO jni_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Waazin nare, innu siza nan tinya, uhana umara ubara uzirigi u Nuhu. ");
INSERT INTO jni_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ure uganiya u Nuhu u' e umukkur kawe, anee ani u zee uvana unu udi cukuno. ");
INSERT INTO jni_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A' anime adi iri ana ware u ruu, azikki unu indai acekki unu indai. ");
INSERT INTO jni_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Adi iri anu ware intinanzu, azikki u' indai aceki u indai. ");
INSERT INTO jni_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ta' cukunoni innu russa, iti shi u wuibe sa ugomo Asere madi e, ba. ");
INSERT INTO jni_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Agu una kura marusa uganiya sa ukari madi e, madada wuzame moro pit ba. ");
INSERT INTO jni_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A' anime cukuno ni innu rusa uganiya sa ita shi ba vana unumadi e. ");
INSERT INTO jni_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","A veni unu huma uni riba ubenki, sa una kura ameme manyin zame unnu mare ka re-re. ");
INSERT INTO jni_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kadundure, inboshi madi tari me imumbe sama zini. ");
INSERT INTO jni_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kadundure, kani inboshi madi tarme imumbe sama zini. ");
INSERT INTO jni_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Inki urere uginome unu buru mani, maguna iruba ine una kura am maga me u aye dibe. ");
INSERT INTO jni_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ba' ma tubi atira aroni ani nonzo umeme, mazin na are in bi sizza sizza. ");
INSERT INTO jni_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Una kura urere ugino me madi e u wui me sa ma tā meba. ");
INSERT INTO jni_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma warime nipum in nu cobo, ma uyame ukālu ume nan nanu aburu. Madi shi marumazi a nyo. ");
INSERT INTO jni_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Adi bati tigomo ta zesere kasi mabura manu kirau sa ma ziki mafitila maweme tantu u gura umanyani ma tiyum. ");
INSERT INTO jni_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Anu chibi anyimo aweme anu zatu jinjin wani, anu ciibi anyimo aweme anu jinjin wani. ");
INSERT INTO jni_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Asenke anu zatu jinjin ugino me wada inta mani anyimo amafitila maweme ba. ");
INSERT INTO jni_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anu ajinjin me wa inta aru amani nan mafitila mawe anyimo me. ");
INSERT INTO jni_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sa manyani matiyom made U aye watubi ugbiso moro mazikiwe. ");
INSERT INTO jni_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Inna tii aniye akunna utissa, agusa, manyani matiyom me maye! Suro ni iguri me! ");
INSERT INTO jni_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Vat mabura magino me mahiri mabari mafitila maweme. ");
INSERT INTO jni_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anu zatu jinjin me wagun nanu ajinjinme, nyangizi haru mani mashime cincin mafitila maru mazinni wijo! ");
INSERT INTO jni_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ba anu ajinjin me wakabirka waagu mada bari haru nan shi ba, hanani ahira anu ziza me. ika kwa inna ce ashi me. ");
INSERT INTO jni_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sa wa dusa ahira ukwa me, manyani matiyom me ma e, ande sa wara ahira me waribe akorso udenge me. ");
INSERT INTO jni_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sa adondonkino mabura magino ka aye, wagu Ugomo Asere pokon duru ana tukum. ");
INSERT INTO jni_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma kabirka magun we, kadundere, in boshi, in tam shi ba. ");
INSERT INTO jni_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Barki anime, cukunoni ibe, ita shi uganiya ba. ");
INSERT INTO jni_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kasi unu mani sa ma haza atanu, matiti arere ameme ma nya we vat imum be sa ma zinni. ");
INSERT INTO jni_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma nya unu indai matelenti manu ciibi. Unu indai matelenti mare uye ma nya me u indai. ko da avi ubina ni uni kara ni meme, madusa. ");
INSERT INTO jni_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Desa makaba matelenti u ciibi ma gun me ma ha maka gamara mani, makem mare. ");
INSERT INTO jni_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ani me ani unu kaba matelenti mare me cangi makem mare. ");
INSERT INTO jni_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Me de sa ma kaba utelenti u indai me, maka gense adizi ma hunze ni. ");
INSERT INTO jni_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sa adondonkino, una kura arere agino me ma zee ma basa nan we. ");
INSERT INTO jni_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Me dee sa ma kaba matelenti manu ciibi, mahaha mamu ma witi mare matelenti uciibi, magu una kura wa nyam matelenti manu ciibi, iye makem mare kaba. ");
INSERT INTO jni_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Una kuraa magun me gai urere uhuma, wa wuza kadundere anyimo imum icin, indi tar we a nyimo igbardang aye cukunno uvenke. ");
INSERT INTO jni_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Una ma telenti mani mare ma haha mamu, magu, ");
INSERT INTO jni_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Una kura, wa nyam matelenti mare. I ye makem mani mare kaba. una kura me me magu imme, gai, urere uhuma. wazauka kadundere a nyimo cin in di tariwe a nyiomo gbardang aye cukuno uvenke. ");
INSERT INTO jni_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Me de sa maa kaba utalenti uindai me, mahaha mamu magu, Una kura min rusa hu unu nyara uziki imum ahira sa da wa inko ni ba, kaba bitelenti buweme. ");
INSERT INTO jni_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Barki anime ani ma kunna bi yau, ma gense adizi mahunze bitalenti buwo meni kaba! ");
INSERT INTO jni_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ba una kura me ma kabirka magu, hu urere uburi mani, ugbara! uru sam incira ahira me sa daki ma inkoni ba. ");
INSERT INTO jni_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ya wuna urii uda ayem ni kirfi me a inki ahira me sa adi kem mareu ni in kabi ire azesere me. ");
INSERT INTO jni_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Barki anime kaba ni bi talenti bi gino me inya una manu kirau me. ");
INSERT INTO jni_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Barki vat inu imum ake akinkimeni, iwu gbardangunu zatu imum akabi ini ame. Rekkini unu sa ma zoo anyo imumba a ");
INSERT INTO jni_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","nyimo a mareu marumzi anyo abinime. ");
INSERT INTO jni_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Inki vana unu ma aye a nyimo ani nonzo nume nan ribe ikadura kame, madi cukuno a hira adang ame. ");
INSERT INTO jni_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Adi ori anabu vat aje ame, madi suzo we ma inki sassas, kasi unutarsa itam. Sa ma suzzo imum sas. Madi inki itam atari tinare, ma inki imani ");
INSERT INTO jni_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","atari tinann gure. ");
INSERT INTO jni_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ugomo madi gu an de sa wa ra atari tinare time, aye ni shi sa acoo maringirka shi, i kabi tigomo tishi sa amu inko shini dati utuba uney. ");
INSERT INTO jni_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Barki ma kunna ikomo ya nyam imumare. makunna niwe nimei, ya nyani mi masa. ma aye ani genu ya kaban mi. ");
INSERT INTO jni_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","In zi bihurba ya sokin mi turunga, ma wuzi ukoni i eh i irim u hira ani rebe ya issizon ni mi. ");
INSERT INTO jni_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Abinee ani anu tanu tiriri me wadi kabirka, wagu, Ugomo Asere, ta ira we abani ta nya we imum yare, nani niwe ni mgwei ta nya we wa sa? ");
INSERT INTO jni_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Innu maya uni ta ira we ini genu me ti kabi we nani inbihurba ti sokiwe tirunga. ");
INSERT INTO jni_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nani inniu maya ini ta iri we uzo uhuma, nan na nyimo akura ani rere me. ");
INSERT INTO jni_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ba ugomo ma kabirka we, magu, kadundere in boshi vat de sa ya wuza meni anyimo ani za num ya wuza miniminini. ");
INSERT INTO jni_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Abini ani madi gu inna na tari tinan gure, cekinni mi, a wuna shi anyo ribeni a nyimo ura nan unu uburu sa a barka barki a malaiku nan unu uburu. ");
INSERT INTO jni_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Barki ma kunna ikomo daki ya nya ni mi imum are ba. ma kunna niwe ni mgwei ya nya nimi masa ba. Ma wuza nigen daki ya kaba ni ba. In zi ");
INSERT INTO jni_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","bihurba daki ya sokin mi turunga ba. Ma wuzi ukoni daki ya aye ya gunkunom ba, mara a nyimo akura ani rere daki ya ikon mi ba. ");
INSERT INTO jni_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Abini me cangi wadi gu, Ugomo Asere innu maya uni ta iri we inni komo me nani inn niwe ni mgwei, nani inn ni gen, nani innu zatu turunganani uzatu nihuma, nani akura ani rere daki ta iko hu ba. ");
INSERT INTO jni_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","46","Abini madi kabirka, magu in we, kadundere, imboshi ani me saki ya wu unu indai a nyimo anu tarsa um ni ba mi mani. A nigino wani wadi ribe a nyimo u zitto, anu tank to riri wadi venke a kura Address. ");
INSERT INTO jni_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sa Yeso mara tize tigino vat, ba ma gun nanu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“I rusa uidi uhangirka me wade tiye tire adi nya vana unu agankirka me.” ");
INSERT INTO jni_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Banu adang akatuma kasere nan ana je anu waguna akura unu dang ukatuma kasere me, una niza kayafa. ");
INSERT INTO jni_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wa tirzi uguna wa meki Yeso wa hu me. ");
INSERT INTO jni_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba wa gu dakki uganiya uidi ba, kati wa shagilna. ");
INSERT INTO jni_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Uganiya sa Yeso mara ubatanya akur Saminu ukuturu, ");
INSERT INTO jni_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ure uney ma eh inni ro ni mani mi kirfi innu nya urunta, ma wume mani anice, meh inna re imumare. ");
INSERT INTO jni_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sa anu tarsa umeme wa ira anime, wa kunna iriba wagu “tige ti cara na”! ");
INSERT INTO jni_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","In guna azizi mani mageme inni kirfi gbardang anya anu zatu ni kara. ");
INSERT INTO jni_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","11","Yeso sa ma iri anime ma gun we nyani ya wuna izinnu bunkoro uney uge me. ma wuzam imum ihuma kang. Izinn nan nanu dira ko ya umaya daki izinan mi Koya umaya ba. ");
INSERT INTO jni_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ugamirka umani mage sa ma wuza ani pum num, mawuza ini barki abanga uvati um. ");
INSERT INTO jni_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kadundere imboshi, vat adi han tize tigeme anyimo uneh adi ringizi inni mum be sa uney ugeme ma wuza. ");
INSERT INTO jni_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Unu indai a nyimo anu kirau in nanu are gino me, unani za Iskaryoti, maha ahira anu a dang akatuma kasere. ");
INSERT INTO jni_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Magu “nyani idi nyani inki ma wito shi me?” wabassa ikirfi ya zumo walwal akura taru wa nya me. Uganiya ugino me uni mameki tibinga ");
INSERT INTO jni_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","tuguna ma witi me. ");
INSERT INTO jni_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ronoutuba uidi imumare uzatu uyisti anu tarsa umeme wa eh ahira Yeso wagu, “A bani u nyara ti barka a hira are imumare u idi uhangirka me ni? ");
INSERT INTO jni_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ba magu “Ribe nii ani pin ahira a uye in gun me, unu dungara mani uganiya ume wa aye mamu, madi ri uidi uhangirka akura aweme nan nu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anu tarsa umeme wa wuzi kasi gussi besa ma bukawe, wa barka imumare uhangirka. ");
INSERT INTO jni_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa uwunjoro wa wuna, ma cukuno are imumare nan nanu tarsa umeme we ukirau inna nu ware. ");
INSERT INTO jni_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wara anyimo are imumare ba ma gunwe, “kadundere in boshi uye a nyimo ashi me madi witum” ");
INSERT INTO jni_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22",". Wa wuzi tipuru ti bit, wa tubi uigizo ume wa inde inde nani mimani ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ba ma kabirka magu, de sa tira iso iso indai nan me, me mani madi witum. ");
INSERT INTO jni_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Vana unu madi dusa ini kasi gussi de sa unyetike utize timeme uzi. ");
INSERT INTO jni_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ba Yahuda sa ma wito me magu “Nani mimani unaje? Yesu magun me, wa buka inni ce niwe. ");
INSERT INTO jni_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sa wara anyimo are imumare, Yeso ma ziki mawu biringara anyimo aniza ni na Asere, ma pusi ma nya anu tarsa ume magu,” iye re ni. Nipum num nini. ");
INSERT INTO jni_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sa ma ziki mgwei mawu biringara anyimo ani za na Sere, ma nya we magu, Vatti ushi sizani. ");
INSERT INTO jni_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Maye mam mani mu inko utize ma gebe sa adi kwonkoni barki anu gwardang, barki ukpwico imum izenzen ");
INSERT INTO jni_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29",". In boshi indaa kuri in si mani nan shi ba, senke rono ugino me sa tidi si ma soh ni gome nan si atigomo ta coo um. ");
INSERT INTO jni_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sa wa wuza ireh ini nonzo na sere, wa suri uhana anipo ni zaitun. ");
INSERT INTO jni_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ba Yeso ma gun we vat idi pilzo barki mi anyettike aniye ni gino me, “indi anun tarsan nin tam ni gomo nidi pura. ");
INSERT INTO jni_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Adumo uhira um, indi agiza shi uhana ugalili “. ");
INSERT INTO jni_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ba Bitrus magun me “vat inki wa pilko barki hu, mi daa pilkom ba koo cin. ");
INSERT INTO jni_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeso ma gun me, kadundere kani in bowe, aniye nigeme cangi, agi agu una uhuna urono ubi goro udi wu matara mu rusa um kataaru”. ");
INSERT INTO jni_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitrus magu imme, inki adi hummi ini nan hu inda wunam matara murusa uwe ba” ane ani anu tarsa ume wagu. ");
INSERT INTO jni_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A' anime Yeso ma eh inwe a hira sa atisa ani ugetsemeni. Magu nanu tarsa umeme, cukononi abaanna me, mindi ha abirko inka wuna biringara “. ");
INSERT INTO jni_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma ziki Bitrus nan na hana a Zabadi ware wa ginno me matubi apuru abit nan nun basa a banga kang. ");
INSERT INTO jni_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ba ma gun we, in zinni zito anyimo uvengize um kan in kunna kasi diwe. Daa tonno ni abanna me, cukunoni unnu rusa nan mi abanna me. ");
INSERT INTO jni_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sa ma haa cin, ma rizzi adizi mawu biringara magu, “A coo um inki i wuna ini zikam ijasi igeme. vat in anime daki unyara um ba, senke uwe”. ");
INSERT INTO jni_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma kuri ahira anu tarsa umeme, ma iri we immoro, ba magu in Bitrus, aca! idaa cukuno me shi in nu rusa nigome nan mi ba? ");
INSERT INTO jni_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cukunoni unnu rusa iwuzi biringara katti irizi anyimo ubata. Iye iriba ya hem nipum me na siziki me”. ");
INSERT INTO jni_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A anime ukuro ukure, maha maka wuna biringara magu, “A coo um inki ani me idaa ak me ba a wuzi ini, aca! uwuzi imum iruba iruba i we”. ");
INSERT INTO jni_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A na me ma ze makem we immoro bar ki sa moro maraa we aje. ");
INSERT INTO jni_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uhana uka nime makuru ma ce ki we, ukuro uku taru uka wuna biringara innu kuruu boh tize tu datti me. ");
INSERT INTO jni_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma ha ahira anu tarsa umeme ma gun we, “idah sisi im moro me inu vengize ni? I yeh uganiya wa aye mamu a nya vana unu atari ta na madini. ");
INSERT INTO jni_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hira ni ti dusa, ya ira unnu wito um monno ma ezeh! ");
INSERT INTO jni_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma zinni bo anyo akem Yahuda, a nyimo anu kirau inna nu are wa ge no me inni goh nanu inti vira nan mu bina anu adnagdang wa tubur ko we. ");
INSERT INTO jni_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Unu wito mamu bara nan we agi, dee sa indi gwindirko me, me ma mani unu me, ih meki me. ");
INSERT INTO jni_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma eh debe upuru u Yeso magu, “gajja una je!” ma meki ugwindiro ume. ");
INSERT INTO jni_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeso magun we, “uroni um imum be sa ya ayen hu ya zigeme? wa ehye wa meki Yeso. ");
INSERT INTO jni_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Uye ma haki nan yeso masuso uvira ume, makoriko uye a nyimo anu meki umeme utui. ");
INSERT INTO jni_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeso magun me, kurzo uvira uwemeni upubu me, vat dee sa ma suso uvira uvira uni udi cukuno iwono ime ");
INSERT INTO jni_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I hira daki ma bari in nyari ubenki a hir acoo umme ba, sa mada ke matumi ibe kadura kameme agu ukirau in kani kare? ");
INSERT INTO jni_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","A nee ni adi amincikina im be sa a nyettike uguna imum igeme idi cukuno. ");
INSERT INTO jni_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A hira me Yeso ma gu inna nanu, ya suro ni in ti vira nan mubina i mekini mi kasi ukari? ko umaya in ka in rib udenge Asere in nu dungura anu daki ya mekini mi ba. ");
INSERT INTO jni_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","a nime ya kenzi vat barki amgwncika tize ta sere nanu kurzuzo utize ta sere. ");
INSERT INTO jni_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Anu meki uYeso wa hann me a hira a kayafa, unu dang utize ta sere a hira anu dungara attaura ni go me nan ana je me. ");
INSERT INTO jni_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Akem Bitrus mahaka ma tarsa piit uhana akura unu udang me. sa maa ribe, macukuno nan nu tonzino ana tukum udenge wa sere barki iri uma ubanga me. ");
INSERT INTO jni_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ba anui adangdang nan nanu ugursuna uwe me vat innu nyara utize me sa wadi meki Yeso barki wa hu me. ");
INSERT INTO jni_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A anime daki wa kem ba a anime anu nyara uwuna ume macico wa nyaru hirsa, akem anuare wa hana mamu. ");
INSERT INTO jni_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wa gu, “unu ugeme magu agi mada kee matuburko udenge Asere ma bari uni anyimo atiye ti taru.” ");
INSERT INTO jni_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Unu udang me mahiri ma tonno magu, “nani udi kabirka tize tigeme sa anu age wazinnu nyinza me ani ce nuwe me”? ");
INSERT INTO jni_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yeso ma ciki me tik. unu udang me ma gun me mapatawe nan na kasere nani una massa mu nee ugen me vanaa sere. ");
INSERT INTO jni_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeso ma kabirka magu, “wa buka in kuri in boshi uhana aje idi vana unu ma ciki a tari tina tunu bari, maaze anyimo atiwiri. ");
INSERT INTO jni_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ba unu udang me ma jani turunga tu meme magu, “ma cara abangani! nya nini tidi kuri ti nyari? ana me ya kunna imumbe sa ma buka. ");
INSERT INTO jni_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","nyani ya ira? wa kabirka wagu,” ma bari uhunna. ");
INSERT INTO jni_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba ma meki tuffizi ume tohbi amuhenu, wa tiri me, aye wa sonsi me tari ");
INSERT INTO jni_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68",", In nu gusa wuza duru u anabci inki hu vana Asere mani buka dee sa ma vavi we! ");
INSERT INTO jni_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A Bitrus ma ciki atii akura, ure uneh ma tonno ahira ame ma gu, “hu cangi uzi nan Yeso unu ugalili. ");
INSERT INTO jni_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ba ma sokorno aje awe magu, min ta imum be sa ubassa ba”. ");
INSERT INTO jni_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sa ma suroani kubi, ure uneh ma iri me magu, ande sa wa tuturi ahira me unu geme wa zin ni go me nan Yeso Bana zaret. ");
INSERT INTO jni_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma kuri mawu matara inni tonno magu, “mi inda ba tam unu ge ba”. ");
INSERT INTO jni_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A dondokino cin anu tutturi me wa gu in bitrus, “Hu geme uzi nan me tize tuwe ta bezi “. ");
INSERT INTO jni_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma meki wuza unice nume anyo inni tonno sasas, in gusa shi inda tam immum me ba”. A hira me bigoro bi runo. ");
INSERT INTO jni_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ba bitrus maringi tize ti Yeso me uguna uduwu matara ani ce num kataru biugoro bidi kuruno”. Ma suri a matara mameki aso kang. ");
INSERT INTO jni_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sa a hiraa sana ana katuma ka sere nan ana je wabari abanga agi wa hume. ");
INSERT INTO jni_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba watiri me wa dusa in me, wa wa tii meatari ti Bitrus. ");
INSERT INTO jni_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sa Yahuda unu wito in guna ahume mairi aweki tize ti guna a hume, i mmume i wume nyei ma kurzo ikirfi me azumo awalwal akuro a taru. ");
INSERT INTO jni_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Magu, “ma wuza imum izenzen sa ma nya unu ulau agi ahume”, Ba wagu, nyanini mgwei maruni? ade awe. ");
INSERT INTO jni_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma samirka ikirfi azumo awal wal agino me udenge Asere, masuri maka cerike nice nume. ");
INSERT INTO jni_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Anu agang akatuma kasere wa orso ikirfi me wa gu, “daki ya wuna uri tiwu ikirfi udenge Asere, barki ikirfi me ihunu. ");
INSERT INTO jni_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba wa gamari tize wakpi masa ma hira uvarsi anu inni kirfi me. ");
INSERT INTO jni_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Barki anime, u' aye uka nime atissa a hira me masa ma maye. ");
INSERT INTO jni_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A nime a mgwinca ubuka uirimiya agi,” wa zika ikirfi azumo nawal wal akur ataru agino me uwal ataru uginome nan are a Israilawa wa wuzi a hira me gu uboo Asere. ");
INSERT INTO jni_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wa kpi masa munu bara umu haru ni, kasi gusi sa ugomo Asere ma buki. ");
INSERT INTO jni_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeso ma tonno aje, ugomo ma ikki me. Aca hamani ugomo u ma yahudawa? Yeso ma gun me, “wa buka”. ");
INSERT INTO jni_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sa ana katuma ka sere nan ana je me in tize tume, daki ma buka imum ba. ");
INSERT INTO jni_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ba Bilatus ma gun me, dakki wa kunna bi gusa saw zinni ani ce niwe ba ? ");
INSERT INTO jni_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A anime dakki makabirka me ani guran ni indai, ugomo me, biyau bi meki me kang. ");
INSERT INTO jni_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","U ganiya uidi una tigomo ma meyme ucensi uwe uni indai sa wa nyara. ");
INSERT INTO jni_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","U ganiya me atirzi uye nan me una niza Barnabas. ");
INSERT INTO jni_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sa wa orno Bilatus ma gun we, “Aveni i nyara in ceki shi ni? barnabas nani Yeso sa atisa me ugomo Asere?'. ");
INSERT INTO jni_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Barki marusa malem mani mawu na a wito me. ");
INSERT INTO jni_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Barki anime cangi, uganiya sa ma ciki azesere atigomo, une me ma tumi inka dura agi, suro abanga unu zattu abanga aburu agino me. ma zitton we atiroo. ");
INSERT INTO jni_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ba anu adang aka tuma ka sere wa rigiza anu inguna wa zauka Barnabas ahu Yeso. ");
INSERT INTO jni_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Una tigomo me ma kuri ma gun we, “Aveni anyimo ana ware wa gino i nyara in ceki me?”, ba wa gu, Barnabas. ");
INSERT INTO jni_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatus ma gun we ani me ani indi wuzi, aveni Yeso sa atisa me mazaya? vat wa gu a gankirka me. ");
INSERT INTO jni_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mahgu iya imum? iya imum iburu ini ma wuza? wa kinki iyeze akme ra ni,” Agankirka me”. ");
INSERT INTO jni_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sa Bilatus ma ira daki ma mekin ace awe ba, ma kpici tari aje anbu magu, “mi ma suro in zoom in mgwei anyimo imum igeme, a ginop adee ashi”. ");
INSERT INTO jni_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Anu wa kabrka vat wagu,' ni haiki nime ni ra ace aru nan ahana aru”. ");
INSERT INTO jni_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Abini we madi cekuwe Barnabas, a mamu cobo Yeso ba ma nya a gankirka me. ");
INSERT INTO jni_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Anani kara nini kono nu gomo me wa ha in Yeso a nyimo ani kubi nu gomo, wa wa ori ana ni kara nini kono ani ce ni me. ");
INSERT INTO jni_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","wa suso me turunga titi gomo as soki me things titi gomo. ");
INSERT INTO jni_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wa bari ni ire ni kana, wa sokki me wa witti me ubina a tari tinare, wa tunguno aje ame innu wuza ume ni bassa, innu gusa, “ivai idodonkino ugomo uma yahudawa! ");
INSERT INTO jni_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wa cof me tobi wa ziki ubina wa cofi me ani ce. ");
INSERT INTO jni_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sa wa mara uwuza ume nibassa, w suso udibi uti gomo me, wa soki me turunga ti meme, wa dusan me wa ka gankirka me. ");
INSERT INTO jni_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wa zi in tanu, wa gun nan ure unu nizame Saminu. Wa wu me ma han nu titi ugankirka u yeso. ");
INSERT INTO jni_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sa wa biki a hira me sa a tisa ani ugolgota, unu guna ukuku u nice. ");
INSERT INTO jni_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wa ketilke uwangu nan ire imum gban gban masi, sa ma donkino ma gaa me usa me. ");
INSERT INTO jni_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sa wa gankirka me wa wu awuzi bizawazawa a hira u hara me. ");
INSERT INTO jni_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wa cukuno wa zinnu bee ume. ");
INSERT INTO jni_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wa nyettike upuru unice, wagu,” me mani ugomo umayahudawa . ");
INSERT INTO jni_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A kuri a gankirka a kari ware nan me, unu indai a tari tinare unu indai a tari ti nan gure ti meme. ");
INSERT INTO jni_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Anu agiza una wa aki innu boo u tize tu zattu runta innu zuro ace. Innu gusa, “Hu sa udi tuburko udenge ");
INSERT INTO jni_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","asere u bari ati ye ti taru bura nice niwe ti iri! Inki hu vana Asere mani tonno azere utiti me ni! ");
INSERT INTO jni_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Anee ani anu adangdang aka tuma ka Asere nan na nu dungara ataurat nan ana je me wa mekki uwuza ume nibassa, wa zi innu gusa, ");
INSERT INTO jni_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ma bursa aye, ca ma buri nice ni meme. me ugomo wa israilawa mani ca matu ana me tidi hem imme. ");
INSERT INTO jni_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Barki Asere ani ma tonno, na Aserer me a buri me ana me, sa ma gussa agi me vanna Asere. ");
INSERT INTO jni_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A karii agino me sa a gankirka we ni goo me wa zoogizi me cangi. ");
INSERT INTO jni_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Innu wui atie ace a hira awu mareu uhana azumo kataru uwunjoro. ");
INSERT INTO jni_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A zumo a taru me Yeso ma yeze nimigran magu, “Eloi Eloi lama sabaktani? Ugomo Asere Ugomo Asere nya nini ya wuna wa ce kum? ");
INSERT INTO jni_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aye wa turi maamu a hira me wa kunna, wa gu,” unu me ma zinnu tisa u Iliya mani”. ");
INSERT INTO jni_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba uye anyimo awe ma hiri innu sum, maka rumzo usoso a mgwei ma gwarara, ma yeze innu bina ma nya me masi. ");
INSERT INTO jni_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","U kasu u aye anyimo awe me wagu cekki anime ti iri nani Iliya madi buri me. ");
INSERT INTO jni_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeso ma kuri ma yeze nigwiran inni kara, ma diku nya nice. ");
INSERT INTO jni_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ugebtu me sa ura a nyimo udenge Asere me u wata kare inna zessere utino adizi. Adizi azuruno, apo awara. ");
INSERT INTO jni_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Apokizo mucau, anu alau sawa wijo wa hirsa. ");
INSERT INTO jni_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wa sussi a nyimo amu cau, a mamu hira iwono me, wa ribe ani pin ni lau wa bezi ace awe me. ");
INSERT INTO jni_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sa una ni kara nini kono nan aaye ni go me sa wa zinnu bee uYeso me wa iri a hira azuruno imum be sa ya kem, biyau bi meki we, wa gu, “kadundere unu ge vanaa Asere mani. ");
INSERT INTO jni_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ara nu gwardang wa zi watarsa usuro uma nyanga mu Galili, innu wuza ume imum iriri. ");
INSERT INTO jni_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A nyimo awe Maryamu magdaliya nan Maryamu a ino a yakubu nan Yusufu nan ka ino a hana a zabadi. ");
INSERT INTO jni_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Innu wunjoro shew uru nu kem ma eh, unanu Armatiya, niza me Yusufu, me cangi unu tarsa u Yeso mani. ");
INSERT INTO jni_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma ha ahira a Bitrus ma iki anya me nipum ni Yeso. Ba Bilatus ma wu anya me. ");
INSERT INTO jni_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu maziki nipum me, matirzi innu malti ulau. ");
INSERT INTO jni_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma wu me. ara hira sama bara urobo nipo ma inko nice nu me ni, mavenki nipo ni dang ma inki me ni ma dussa. ");
INSERT INTO jni_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","maryamu magadaliya nan Maryamu ukure me wa ciki aje icau me. ");
INSERT INTO jni_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sa a hira asana, umara, ubara abanga me, anuj katuma ka sere nan nanu beezi urusa wa gunna a hira a bilatus. ");
INSERT INTO jni_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wa gu ugomo udang, taa ringi imum be unu rangigizaa nu a ginome sa maa vengize mabuki madi hiri a nyimo ati ye ti taru amu cau. ");
INSERT INTO jni_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A nime buka aka be icau me u hana a tiye ti taru katti anu tarsa umeme w cuzi me, wa guin nanu agi a mahira a nyimo. icau ini, urangiza umaassiza udi tekki utuba. ");
INSERT INTO jni_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus ma gun we, “A nee ani in tani an kara nini kono ika korso a hira me innin kara ni shi. ");
INSERT INTO jni_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wa dussa waka korso a hira. mu cau me, wa wu. u inko. ubezi. ahira me . ");
INSERT INTO jni_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Unnu sana a hira uwui wa asabar uribe uwui utuba anyimo usati, Maryamu Magadaliya nan ure Maryamu, wa eh barki wa gun kuno icau. ");
INSERT INTO jni_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Abini me uzuruko adizi adangdang uhiri bibe bi ka dura ka sere bi tuu usuro azesere, bi dusa tuburko nipo me bi cukuno ani po me. ");
INSERT INTO jni_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uzina umeme wa zi kasi umelke azesere, turunga ti meme ta zi tirum pau. Anu beeh icau wa dusa wa kunna biyau, ");
INSERT INTO jni_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","warizi zi gusi wa wijo. ");
INSERT INTO jni_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bibe bi ka dura kasere bi dusa bi gun in na neh agino me ma gun we, “kati ikunna biyau ba, in rusa i zin nu nyara uyeso ss agankirka me azesere utiti. ");
INSERT INTO jni_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mada rani aba me ba, mamu hira, gusi uguna umeme. Aye ni e iri a hura me sa a nati me ni. ");
INSERT INTO jni_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hana ni dibe dibe i buki anu tarsa umeme, ma hira usuro iwono, ira nii ma dusa aje ashi me u hana ugalili. Abini me ani idika ira me nin, mz buka shi. ");
INSERT INTO jni_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Anime wa dusa wa ceki iccau me ini yau nan iriba irum, wa sumibwa ka buka anu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Abini me Yeso sa ma gurna nan we ma gu, gajja ushi! wa dusa wa eh wa gwindirko tibuna ti me. wawuzi ninonzo. ");
INSERT INTO jni_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeso ma gun we p, “kati i kunna ni biyau, ka buka ni ni henu wa mekibuna u hana ugalili, abini me wadi irum”. ");
INSERT INTO jni_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sa anu me wa zinin tanu tu dusa are anu beh iccau wa ribe anipin wakw buka anu anu adang imum be sa wa kem we. ");
INSERT INTO jni_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sa anu adang a katuma wa kunna, wa dusa wa titi ti cukum wa gamir ka tize, wa nya ana nikara ni kono ni kirfi igwardang. ");
INSERT INTO jni_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wa gun we huka ni ukasu anu, anu tarsa uyeso a eh inni ye wa cuzi nipum ni meme uganiya sa ta zin moro . ");
INSERT INTO jni_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Inki ka dura ka geme ka biki ahira unu kpaku udang, ti rigiza me bati ti korso anyimo uzito. ");
INSERT INTO jni_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ana ni kara ni kono me wa kabi ikirfi me, wa wuzi imum be sa abukawe. Tize ti geme ta samirka uribe anyimo e Yahudawa vat, ta re aje u e aye kani me. ");
INSERT INTO jni_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anu tarsa uyeso ukirau nan nu indai wagino me wa dusa uhana ugalili ani pana me sa Yeso ma buki we. ");
INSERT INTO jni_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sa wa iri me, wa nya me ninonzo aye a nyimo awe me wazin unu harsa iriba ");
INSERT INTO jni_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeso ma eh ma kem we ma buki tize magu,” a nyam tigomo ta zesere nan ta dizivvat ");
INSERT INTO jni_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19",". Hana ni anyimo uney ika nyara anu jabisa utize ta sere i zorsizo we a nyimo niza na coo ni vana nan bi be bi lau. ");
INSERT INTO jni_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Dungura we wa tarsi imum be sa ma buka shi, in zi nigoo nan shi kode uya uwui uhana umasirka uney. ");
INSERT INTO jni_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","U tuba uka dura kurunta ka Yesu vana Asere. ");
INSERT INTO jni_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kasi unu kurzo tize ta sere Ishaya ma nyetike “ira, “indi tuburko we una kadura a hira awe me, meh mani madi barka we uname.” ");
INSERT INTO jni_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Akunna nimyera nu uye ani jaa, 'unu tisa, cukuno unu rusa anu nan Ugomo Asere, hakani una umeme dert'”. ");
INSERT INTO jni_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana ma eh ma zorso anu anyimo anijaa makuri ma beziwe una uzorso me nannu guna wa ceki a cara abanga a zenzen barki akabiwe usuro abanga aburume. ");
INSERT INTO jni_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vat nipin nu Judiya nan anu Urushalima, wasuri wa ha ahira ameme manno ma zorowe uraba u Juda. sawabuki uguna wa ceki a banga a buru aweme. ");
INSERT INTO jni_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana ma soki u dibi utiwui unu subu urakumi ma kuri ma tirzi utinome ini wa imimare imeme yazi matu mishii ini jaa. ");
INSERT INTO jni_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Maboo tize ti Ugomo Asere maguwe uye ma eze sa ma tekum ini kara mi indaki mabari uguna in tunguno in sopi be nyumo ba kpatak ameme. ");
INSERT INTO jni_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mima zoroshi imgwei me madi zorsoshi inbibe beriri. ");
INSERT INTO jni_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Anyimo atiye tigonome tine Yesu ma suri Unazarat anyimo Ugalili Yohana mani ma zoro me uraba Ujorda. ");
INSERT INTO jni_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sa Yesu ma suro agwei me, Asesere a pokino bibe biriri ba Asere bi tu anipum nimeme gusi bihurge ");
INSERT INTO jni_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa nimyrang na suro Asesere. Hu, vana um mani sa inteki unu nyara me. in kunna urunta uweme. ");
INSERT INTO jni_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Abinime bibe biziki me bi hamme ani jaa. ");
INSERT INTO jni_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma cukuno ani jaa me tiye tina akura nazi, una bi be bizenzen ma eh ma mansame, maciki ni gome nan ni nama ini jaa una katuma ka Asere ma nyinzi me imum besa manyara. ");
INSERT INTO jni_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Uganiya sa a meki Yohana Yesu ma ennu boo anu tize ka Asere. ");
INSERT INTO jni_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Magu ana uganiya wa aye ma saa mu Ugomo Asere ma aye mamu. hem mi ikabi tize tum. ");
INSERT INTO jni_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Madusa ani kira nu raba udan Ugalili, ma iri Siman nan Andrawus uhenu u Siman wazi ma hurba uraba me. wazi numensi icere. ");
INSERT INTO jni_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ma guwe aye tarsan nimi indi wushi anu mensi anabu. ");
INSERT INTO jni_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wa ba ceki ma hurba me wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mara anyimo a tanu ma iri Yakubu vana u Zabadi nan Yohana uhenume. wah ra anyimo ujirgi umgwei unu urezi umakoma. ");
INSERT INTO jni_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Matiti we, wa dusa waba ceki acho awe me Zabadi anyimo ujirgi umgwei me wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ma haki a nyimo Ukaparnahum Asabar adusa a ribe, me ma ka ribe a nyimo udenge unigura ma boo tize ta Asere. Wa kunna biyau inni mumbe sa ba we wa ");
INSERT INTO jni_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ziki me debe sa mazin nikara azoh gusi debe sa ma bezizi abanga . ");
INSERT INTO jni_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A nyimo udenge unigura me uye mara ni in bibe bizenzeng. Maha ma wu uhunu gangang. ");
INSERT INTO jni_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nyanini tidi wuzi in hu Yeso una nu nazareth? Wa aye uhuzin duru? Marusa we hu bibe ba Asere bini. ");
INSERT INTO jni_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeso ma busurka ugbergene me magu, ingara u suri abini me. ");
INSERT INTO jni_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Abini me bibe bi zenzeng me bi vete me adizi bi yeze nigmirang gangang bi ku sura me. ");
INSERT INTO jni_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","vat anu wa kunna biya, wa ikki nya nini izigeme, uboo abanga asoh nan ni kara! Mayenne anu ibe zenzeng wa yenne wa kunna me. ");
INSERT INTO jni_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Abini me abanga adusa a ribize vat a nyimo nan matara mu Galili. ");
INSERT INTO jni_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A hira me sa wa ceki udenge unigura me, wa ribe anyimo a kura Simon wan Andarawus an Yakubu nan Yohana. ");
INSERT INTO jni_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ugiri u Simon marari innipum ba wa buki me abanga ameme. ");
INSERT INTO jni_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ba amini me ma meki tari ma hirza me. ma ba huma. ma ziki imumare ma nyawe. ");
INSERT INTO jni_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Unnu wunjoro, wa ezime inna na tikoni nan bibe sa agbergene wa ribe we. ");
INSERT INTO jni_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ni pin me ni gurna vat ana tukum. ");
INSERT INTO jni_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ma humza vat ana tikoni sassas ma kuri ma suzo agbergene wa buki tize barki wa rusi me. ");
INSERT INTO jni_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma suri nisssizo maka wuna biringara in sissimme. ");
INSERT INTO jni_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siman nan bibe sa wa zi nigome wa nyarime. ");
INSERT INTO jni_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wa dusa wa iri me a hira sa ma rani. sa wa ira me, wa gu imme, anabu wa zin innu nyara uwe. ");
INSERT INTO jni_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma guna taru ni, arahira a ninjo a nipin imbuki we tize abini me cangi. Imumbe sa ya en me ya zigino me. ");
INSERT INTO jni_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma dusa vat a nyimo uGalili, ma boo tize ta Asere a nyimo a tidenge ti nigura, ma suzo a gbergene. ");
INSERT INTO jni_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uku taru maka aye ma tun guno inna ruu, magu imme ana inki wa hem uhuman. ");
INSERT INTO jni_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma ngwimca innu gogoni, Yeso ma yeze tari timeme ma dari me, magu inn zinnu su me, magu, huma. ");
INSERT INTO jni_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A hira me ma ba huma. ");
INSERT INTO jni_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yeso ma gu imme innki wa buka uye abanga agino adi huwe, dusa ana me. Yeso ma gu imme hana kati ubuki uye iri mum. ");
INSERT INTO jni_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ka nya una katuma ka Asere udanga me, umm be sa Musa mabuki we unnu guna wuzi ini. ");
INSERT INTO jni_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ba unu me ma tunguno ubo anabu imum me vat. Abini ani Yeso ma diri ace usuro a nipin. Ma dusa maka cukuno a manyanga ma huu im bikki cas barki anu wa nyarai me. ");
INSERT INTO jni_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Uganiya sa Yesu ma ze usuro u capernaum a tiye chingiling, a nu a hirame wa kunna agi ma ra a kura. ");
INSERT INTO jni_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Anu wa orno gbardan uka biki a natuhumme. Yesu ma duku zin nu bezizi uwe tize ta sere. ");
INSERT INTO jni_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aye wa eh a hira Yesu me in nu nu koni uwujo uti hira; we wa nazi wani wa hanname wa eh ni. ");
INSERT INTO jni_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","U ganiyame barki ugbardan anu, waha wa pere urufime, wa tuzome a hirame sa yesu ma turini in nu komi me sa ma rarini ");
INSERT INTO jni_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sa Yesu ma iri u hem uweme, magun nu nu konime, vena, a kpicowe we usizikime uweme. ");
INSERT INTO jni_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Are anu rusa wa chiki a hira changi, wa basa amu ruba muweme, ");
INSERT INTO jni_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Wa gu ane ni unu ugeme ma boo tize anu anime fee. in gusa Ugomo Asere mani cas ma kpijo usizikime wa noo. ");
INSERT INTO jni_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dibedibesi, Yesu sa ma rusa imumbe sa wazin nu basame a muruba muweme, ma gun we, nyanini izin nu basa me a muruba mushime? ");
INSERT INTO jni_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nyanini i teki in nu zati u zito, agun nu nu konime, a kpichowe usizikime uweme, nani agu hira zika ukomi uweme udusa? ");
INSERT INTO jni_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rusa changi unu koni, vana wa Asere mazin ni kara nu kpijo usizizime wa nabu. ");
INSERT INTO jni_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Magunan hu, hira zika upenge uweme udusa akura a weme. ");
INSERT INTO jni_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma dusa ma hiri dibedibe, maziki upengeme, ma surij akurame ma dusa a ame akurame aje anabu vat. ");
INSERT INTO jni_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ma kiri ma dusa, upuri uwah anume wa eh vat a hirame, agi ma beziziwe urusa Asere. ");
INSERT INTO jni_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sa mazin nu aka, ma iri uru lawiyawa vana u Alpheus, sa ma chiki ahira unu kapsa Ikirfi ima nyanga, magumme “Tarsam” ma hiri ma tarsime. ");
INSERT INTO jni_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sa Yesu mazin nu re imumare a kura an levime, Anu kapsa Ikirfi ima nyanga, nan nanu amu riba mu facak wazin na reme upata anu tara umeme ukirau in wa re. anu gbarda wa tungunu tarsa ume. ");
INSERT INTO jni_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sa anu Nyerte a Farisawa wa iri Yesu unu ri mumare nan nanu amu riba mu facak, anu kapsa Ikirfi ima nyanga, wagu, nyanini ya wuna mazin nari mumare nan wee. ");
INSERT INTO jni_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sa Yesu ma kunna, magunwe, an debe sa wazin ahuma pum wada nyarawe unu kaba, anu koni wani cas wa nyara anu ka. in da ma eh u nyara ana mu riba muririba ana mu riba mu facak wani ma aye u nyara uwe. ");
INSERT INTO jni_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anu tarsa u Yuhana nan nanu tarsa a Farisawa wazin inu hiri sarku rimumare. Wa eh, wa gumme, “Nyanini” ya wuna anu tarsa u Yuhana nom na nu tarsa a Farisawa waka wa hiri sarki uremumu? ");
INSERT INTO jni_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ma gunwe, “Anu eze a hira nyah wadake wa hiri sarki ure imumu uneh usome ma da nan we, inka une usome mada nan we, wadake we hiri sarki urimumba. ");
INSERT INTO jni_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tire tiye tidi eh sa adi ziki uneh usoo me a hira ashi. A nyimo atiye tiginome, wadi hiri sarki ire imum. ");
INSERT INTO jni_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Unu mazoni sa madi ziki kutira ma duzi udibi ukuzi, ingi awuna anime kutirane kudi janika ani pum ni ukuzime, anime adi kem ujanika uzenzeng. ");
INSERT INTO jni_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Uye mada ke ma wu ubere uso, uwa ubere ukuzuba, inge ma wuna anime, u wa ubereme udi tusa har adiri ubereme, nan nu wa ubereme sa awu ubereme a nyumo uwa uso ubereme. ");
INSERT INTO jni_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Innu wui usabat, Yesu ma ha uru idawa, nan nanu tarsa umeme ukirau ware wazin nu suzo idawa bati wa ri. ");
INSERT INTO jni_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A Farisawame wa gume “ira, nyanini ya wuna wazin nu wuza imum sa ada wuzame rono a sabar baa. ");
INSERT INTO jni_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma gun we, “Dagi ya kunna imum sa Dawuda nan na nume sa wuzi nan me wawu sa ikomo ya hume ba? ");
INSERT INTO jni_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Indabe sama ha akura Ugomo Asere sa Abiathar mazi unu dang mari u biredi ugebe sa unu dang wa sere mani madake mari ma nyanki ande sa wazi nanme baa. ");
INSERT INTO jni_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu magu “ba barka uwui wa sabar barki anu mani daki anabu barki uwui wa sabar ba. ");
INSERT INTO jni_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ane ani, mi vana Asere mani Asere. a roni a sabar.” ");
INSERT INTO jni_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu ma ku ma kuri a nyumo u denge sa uni gura, uye sa tare ta wano maa rani abnyumome. ");
INSERT INTO jni_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","wa zi unu nyasra kuna sa wadi meki me unu caran unu wui wa sabath. ");
INSERT INTO jni_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ma buki una tare sa ta wano ma hiri ma tunno a ti anu. ");
INSERT INTO jni_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma buki a nabu “Irizi unu ma wuzi ka tuma ka ririn nan ka bur unu wui wa sasbath mee; u buri unu nan u humee” wa ciki tik. ");
INSERT INTO jni_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ma gamirka ma iri we ma puru a bit barku ugbas umu riba muwe mee, ma gunmee witi Yesu ma meki tari tu numee ti dusa ti ti huma. ");
INSERT INTO jni_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Daki dadankino ma Farisiyawa na ma Herodiyawa wa suri ama tara waka wuza ti chukum wa tiri ti nyo agi wa hu mee. ");
INSERT INTO jni_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ma ziki a hana a tami tume mee wa dusa u hana uraba dangi. ");
INSERT INTO jni_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Anu Gallilee nai nu Judiya wa tarsi gbardan. Anu Jerusalem, Iduniya ana ma tara mu Jodan nan ti kira tu teira wanu Sidon gbardan sa wa kunna imum me sa ma zinowuza me wa e. ");
INSERT INTO jni_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ma buki a hana a tanu tume mee wa nyarme ku zuki ku mei barki u gbardan wa nu kati wa humee. ");
INSERT INTO jni_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa ma humzan na nu gbardan, barki anime ana ti koni gbardan wa meki u sonsiace bati wa dari mee. ");
INSERT INTO jni_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ingi ani ibe i amemee ma so, “wa guse ho mani vana Asere”. ");
INSERT INTO jni_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma bussurka we kati anu wa rusume. ");
INSERT INTO jni_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma nyene asesari ani po ma titi an de sa ma nyara wa e wa kem me. ");
INSERT INTO jni_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma zanka ana kirau inwa re (andee sa ma nya we ni za Adura) bati wa chukuno nan me ma kur ma tunzi we wa ka bizi anu tize ta sere. ");
INSERT INTO jni_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nan ni kara mu suzo agbargene. ");
INSERT INTO jni_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ma zauka anu kirau inwa re: Simon de sa ma nyame ni za Bitrus ");
INSERT INTO jni_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu u sam u Zebedee nan Yohana u nanu u Yakubu (ma nya we ni zo buwanajis wati a hana u tusa Asere); ");
INSERT INTO jni_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nan Andrawus, Filip, Batalomi, Matiyu, Toma Yakubu u sam wa Alfarsus, Tadawus, Simon u Zailot. ");
INSERT INTO jni_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nan Yahuda Iskarioti de sa madi zizime. ");
INSERT INTO jni_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sa ma kuro a kura anu wa gurna gbardan nan wa iri me, wa diri ace are imumare. ");
INSERT INTO jni_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ana kura awe me sa wa kuna age iriba imeme izo nan me wa suri uguma waka burame. ");
INSERT INTO jni_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anu rusa sawa suri u Jerusalem wa gu mazin ibibe ba gbargene. ");
INSERT INTO jni_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu ma titiwe a hira ame ma bukuwe tize ani hunzi; Adi wu aneni u gbargenee. ");
INSERT INTO jni_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Inge ana ma nyanga wa hara ace awe ma nyanga me ma rizo. ");
INSERT INTO jni_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inge ana kura wa hara ace awe, a kura me a rizo. ");
INSERT INTO jni_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tuge u gbargeme ma garte ani ce nume ibinani ime ya aye. ");
INSERT INTO jni_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Unu mada kee ma riba akura una ni kura ma cuzi tinanga tu na nikara sarki u tirza umee. ");
INSERT INTO jni_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ka dundura ma buka shi vat u rizizo wanu adi parkumen uni vat nan nu chara sa wa charsan. ");
INSERT INTO jni_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vat de sa ma chara bi be biririn ba Asere ada cheke meba. ");
INSERT INTO jni_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ma buku we aniwe barki su wa gu mazin in bibe bi zenze. ");
INSERT INTO jni_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A ino umeme nan anu henu meme wa e wa tunno ama tara, wa tumi aye atitime. ");
INSERT INTO jni_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Anu sa wa kete me gbem wa gun me a ino uweme nan anu heme henu uweme wa turi a ma tari a ma tara wa nyara u ira uwe. ");
INSERT INTO jni_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma kabirka ka we unu ikko, aka veni anka ino um nan anu henu um. ");
INSERT INTO jni_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma venki aje ma iri an de sa wa kete ma gu wewani anka ino nan anu henu umeme. ");
INSERT INTO jni_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Barki anime an de sa wa tarsa ti ze ta sere wewa ni hanu enu am nan aka ino am. ");
INSERT INTO jni_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mari aje ino bezizi anome tize ta Asere ani winme, ma ribee Ujerusalem ma chukuno anabu uwara nikyerainge maniwii. ");
INSERT INTO jni_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mare aje tibe yau, maze inu buu maguwe itilem tilem maguwe ana. ");
INSERT INTO jni_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kunna nii u na tibira masuri atibira? ");
INSERT INTO jni_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Samabira ire esana iresa una ignyin eyitingi. ");
INSERT INTO jni_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ire isaname yarizo adezi upanbara inka uwui wa tusa idusa iwa. ");
INSERT INTO jni_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sa uwi watusa idusa awa. ");
INSERT INTO jni_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ire ya rizi, ire kana ikame ahiri inpime daki yawuna uhoba. ");
INSERT INTO jni_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ire ya rizi adizi ariri inya biho akuro atataru ire akuro ta tasi ire aino aino. ");
INSERT INTO jni_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Anu ati anatitui tu kunna me na wa kunna wa wuzi katuma neinni imumume sawa kunna. ");
INSERT INTO jni_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Uganiya sa Yesu ma ciki nana a hana kadura ka meme anu kirau in kare ukasume wa iki me nyanini imumu ibiyau bi sa mazi ni bo iru. ");
INSERT INTO jni_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Shime ma hiri shi iboke shi imumbesa ira Asesere i sa wa zome nan shi ba sa dai ma buka. ");
INSERT INTO jni_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wa di hiri a wada ira ini? wadi kunna e wa wadi caki imumbesa wa kunna ");
INSERT INTO jni_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma gwawe indaki ya kunna imumbesa mabuka shi ba ide wa aneni iri Asere. ");
INSERT INTO jni_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Unu cobo isana igenneme tize ta Asere tini barki ini mumbesa abeziwe inime. ");
INSERT INTO jni_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aye wazi kasi i sana ya rinzo una barki wakunna tize ta Asere dibe wazowe ina bangu iveteme niba. ");
INSERT INTO jni_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Anabu wazi kaniya isanasa ya rizo upambara inka uwui wa tusa inki we vati. ");
INSERT INTO jni_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wazi kasi andebesa wa kaba tize ta Asere wenno iri mumu ya hira ibiyau wa zome inna bangu zetiminiba. ");
INSERT INTO jni_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Isanasa ya rizi ikanu ineini anabu sa wakunna tize ta Asereme. ");
INSERT INTO jni_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Adezusa a cere anu ine eni ya unni geme na nu una urunta wa kati anabu ukunna u tize ta Asereme. ");
INSERT INTO jni_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kasi andebesa wa kabi tize ta Asere we wani kasi isana sa yarizo adizariri wa niza iburi irir ire kuro ataru ire aguro utasi ire mi ino. ");
INSERT INTO jni_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ma bukiwe innu guna adatawu ura upitila a inpi ine gira nani aka a inpi ini so ene a masama e. ");
INSERT INTO jni_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Indaki ire imumu irani sa izi mubunzi sa daki inki tasi ini ba anu haze ushi tire tize. ");
INSERT INTO jni_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Vati anatitui tu unna na makuna da besa daki ma kunna ba ade ame. ");
INSERT INTO jni_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mkuri mabukawe inoguna imu dusa wa guta me une uni, uni adegutuwen harma atinkuweni. ");
INSERT INTO jni_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Desa mazini adi kinkimeni da sa ma zo mani ade kabi a cheki enime. ");
INSERT INTO jni_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ma reje ini gusa tize ta Asere tize kaniya unu wuza otibira uru umeme. ");
INSERT INTO jni_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Amori ahiri unu ugenome mada urusame indabesa aru uru uzi ba har asani usanna ahira. ");
INSERT INTO jni_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Adizi ata anya bisana biriri gusi iriri ma e inyanice iriri sa adi irin nini me merun. ");
INSERT INTO jni_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uganiya sa ya hina maka ma imumu uwesi maka barki ya hina. ");
INSERT INTO jni_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ma buki madi bezuwe anabu aneni barki watinka nani ma bezuwe uya anu rusa sa wada rusa ba. ");
INSERT INTO jni_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wazi kasi isana icicinci sa una tibira ma ha maka bira uru uwu iriri. ");
INSERT INTO jni_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Akabiri ini iki isuri hari iwu ure memerun ulambume. ");
INSERT INTO jni_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ma reje inu bo uwe tasi timumu gbardan sa ma bezuzu we tene barki kati wa perkeme ba. ");
INSERT INTO jni_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Madaki beziziwe inka mazi nan na hana akatuma ka meme wa daki wa cukuno wa zi vati ani gino makama ma bukuwe vati imumbesa ize. ");
INSERT INTO jni_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Uru uwui ma gu ahana akatuma kameme tarini ti kafani uhuru utekume. ");
INSERT INTO jni_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wa dusa wa hiri wa dibe ugirgime wadusa uhana uhuru ugino nan mare ma jirgi. ");
INSERT INTO jni_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ukpebu udandang wa uhiri udari ukeme u e mei u winca u jirgi me ama rari wa gwame buka tize ma dusa ma buki tize na nu kpebu me utonno. ");
INSERT INTO jni_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu mararume imumu ime unu nyetike ihori u urdu uceki duru tiwui. ");
INSERT INTO jni_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sama zuma ma barka ukpebu me magu a une tunno ukpebu udusa utonno rik. ");
INSERT INTO jni_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma gwewe nyanini yawuna izindiyau inda ki ya kaba tize ta Asere ba? ");
INSERT INTO jni_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ahana akatuma ta meme aveni ma bari uguna ma karti me ma nyanga ma gene. ");
INSERT INTO jni_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sa wa kafa uhuru uraba udang anyimo ama nyanga magasinawa. ");
INSERT INTO jni_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sa ma tuno a nyimo ujirgi me uru nu una gbergene abit sa ma ciki ahira amucau ma e ma kem Yeso. ");
INSERT INTO jni_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma dusa ma kurzo yeso ni agi ahira mucau muni ahira aticukum ti meme, barki anime unu tirza umeme ma zoni. ");
INSERT INTO jni_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Barki amu tirza me in tizini ma tazi tini tiyorso unu rusa utirza umeme ma zoni. ");
INSERT INTO jni_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ahira amucau acukuno gusi akura ameme niye nan wuyi sarki uhirsa. ");
INSERT INTO jni_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sa ma ira Yeso ma aze madusa ma ka rizo aje ameme. ");
INSERT INTO jni_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma dusa ma wu uhunu magu, “nyanini indi wuzi Yesu, vanaa asere una ninonzo mapata nan na asere. kati gidim. ");
INSERT INTO jni_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ba yesu magu “suro ani pum ni nu ugeme hu bibe bizenze” ");
INSERT INTO jni_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu ma iki me niza ni weme aveni, ma kabirka magu”na za nim gbem barki ti ori. ");
INSERT INTO jni_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Magun Yesu nyara kati Yesu ma gidi me a manya ma meme ba. ");
INSERT INTO jni_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ahira me nigo ni maladu nazi unu kase unu nyara imum yare azeser upana. ");
INSERT INTO jni_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Agbergene wa iki Yesu wa gu” tuburko duru anyimo amaladu tika ribe anyimo awe”. ");
INSERT INTO jni_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Madusa ma hem unu iko wa agbergene abit me, wa dusa wa suri inti sum sum wa ka ribe anyimo amaladu akuro ukirau, wa dusa wa rizo anyimo uraba udang, mei ma dusa ma ziki we. ");
INSERT INTO jni_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abini me anu me sa wazi unu kasen imaladu me wa dusa unu sum uhana anyimo anipim nan nagiro waka buka imum me sa wa ira. Anu gwardang wa suri wa ha ahira me bati wa ka ira imum me sa Yesu ma wuza. ");
INSERT INTO jni_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa wa aye ahira Yesu me wa iri una agberne agino me sa ma zi maciki a dizi maaduku soki turunga ti riri ani pum ni meme sa wa ira wa dusa wa kunna biyau. ");
INSERT INTO jni_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Andesa wa e wa iri imum me sa ya kem unu agbergene agino me ma buki we imum me vat sa ya kem me nan maladu me. ");
INSERT INTO jni_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wadusa wa gun desa mazin inna gbergene me, ma ceki we manyanga. ");
INSERT INTO jni_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sa yesu mazi unu ribe ujirgi umei una agbergene me magu madi tarsi me. ");
INSERT INTO jni_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu daki ma hem ma dusa nan me ba, magun me”dusa akura ashi me ahira anu aweme uka buka imum me sa ugomo Asere ma wuza we. ");
INSERT INTO jni_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ba ma dusa unu boo timumum ti dangdang me sa Yesu ma wuza me a nyimo Udikafolis, anu wa kunna biyau vat desa ma kunna. ");
INSERT INTO jni_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa Yesu ma kafa unuhuru uraba udang anyimo ukwale kwale ni'ori na nu gbardang ni e ni kem me sa ma raa ani kira nuraba me. ");
INSERT INTO jni_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ure una katuma anyimo udenge unigura nahana Asere una niza Yayirus sa ma ira Yesu, ma dusa ma tunguno ina ruu aje ameme. ");
INSERT INTO jni_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma vovi tari ahira me ma gun yesu”kusu ucaa um mada zo me uhuma, ma aye mamu iwono, aye tara tari tiwe me ani ce ni meme bati ma huma. ");
INSERT INTO jni_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Madusa nigome nan me, ni'ori nanu gbardang unu tarsa ume unu haza mamu nan me. ");
INSERT INTO jni_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ure une maka aye sa ma ziki tiwe ukirau nan tini re unu kpongizo uma ye. ");
INSERT INTO jni_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma tarsi ana tika gbardang, ma hu vat imum me sa ma zini, daki ma huma. imum me isabi ikingizi. ");
INSERT INTO jni_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sa ma kunna abanga Yesu. Madusa ma tarsi me adumo sa mazin intanu, madusa ma dari udibi Yesu. ");
INSERT INTO jni_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ma buki anyimo iriba imeme, “inki ma dara udibi uyesu indidi huma”. ");
INSERT INTO jni_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sa ma dara udibi me ukpogizo umaye me udusa utonno, ma kunna ani pum nimeme ma huma ma venke ini jasi imeme. ");
INSERT INTO jni_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu kunna nikara na suro ani pum nimeme. Ma dusa ma gamirka ma iki ni'ori nanu me magu “aveni ma dara udibi um”? ");
INSERT INTO jni_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ba anu tarsa umeme wagu”wa ira ni'ori na nabu na aka upuru uwe, iduku gu”aveni ma dara we”? ");
INSERT INTO jni_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu madusa ma gunkuno bati ma iri desa ma dara me. ");
INSERT INTO jni_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uneme sa ma rusi imum me sa ya kem me, madusa unu kira imbiyau. Madusa ma e ma rizi aje Yesu ma buki me kadure me. ");
INSERT INTO jni_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Madusa ma gun me”uca um nihem ni weme na benki we wa huma. Dusa anyimo iriba irum wa huma. ");
INSERT INTO jni_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sa ma raa anyimo atize are ana katuma udenge ubirigira, wagu”uca uwe me mamu wono. nyanini ya wuna daki wa kini ba? ");
INSERT INTO jni_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sa Yesu ma kunna imum sa wazi unu boo me, nan ana akatuma udenge ubi unigura,”kati i kunna biyau, hem ni shi”. ");
INSERT INTO jni_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Daki ma ceki uye ma tarsi me ba an Bitrus, Yakubu nan Yohana uhenu Yakubu cas ma hem wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sa wa aye akura una katuma udenge uni gura ma e ma kem anu wazin tiso nan tihunu. ");
INSERT INTO jni_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sa ma ribe akura me, ba ma iki we “nyanini ya wuna iriba ishi me ya corno me nyanini ya wuna izin ti soo me? vanaa me daki ma wono ba, moro mani mazini”. ");
INSERT INTO jni_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba ma dusa mazunzuka, ma suso anu me vat amatara, ma ziki aco nan ka a'ino nan an desa wazi nigo me nan me, wa ha ahira sa uca me marari ni. ");
INSERT INTO jni_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma yeze tari tikubura me ma gu me “Talitha koum” sa igusa kubura, ma gunan hu hira” ");
INSERT INTO jni_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kubura ku dusa ku hiri ku tubi tanu tiwe timeme tazi ukirau in tini tire. Anu wa dusa wa kunna biyau. ");
INSERT INTO jni_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Madusa hunguko we titui kati wa buki uye ba. Ba ma gu me imum yare mari. ");
INSERT INTO jni_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ma suri abini me ma ribe a nyimo atibuba timeme. ");
INSERT INTO jni_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rono Asesere me a eh, ma bezi we tize a nyimo a hira ugursuna. Anabu gwardan sa wazi un nu kunna ume biyau ba meki we. Wa gu, a bani ma kem tize tigeme? uyaya urusa ugamara utize tinit Asere a nya me? Abani makem imum ibi yau i genne me ni. ");
INSERT INTO jni_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ugo me mani unu aso, vana u maryamu nan uhenu u yakubu nan yosisnan yahuda nan siman? ingo tizi ni go me nan na henu a a eh ameme? wonno wa kunna iriba in Yesu. ");
INSERT INTO jni_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ma buki we “udura ma zome me in nin non zo ni rini a kura nan a nyimo anu ameme nan na henu ameme ba. ");
INSERT INTO jni_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sa ma wuzi katuma ka dandan a bini me ba ma wu tari Asesere a nu chingilin wa huma. ");
INSERT INTO jni_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Uzatu kaba tize me wa wu ma kunna sas. mari aje unnu kese a nyimo agiro a we me in tize ta sere. ");
INSERT INTO jni_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Matiti anu kirau inna re matumi we wa rere ma nya we nikara Asesere nu bengizi. ");
INSERT INTO jni_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Makuri ma kati we uzika ire imum ban ubina cas. kati waziki ubiredi ubakara, u nyara kirfi a nyimo ittino ba. ");
INSERT INTO jni_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Senke ya soki ma kwatak, kati wa ziki madibi mare ba. ");
INSERT INTO jni_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Magu “in ka ya ribo a kura, cukunoni ingi uganiya udusa” wa ayei. ");
INSERT INTO jni_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Inka da akaba shi ahira, wa nyari kunna ushi in ka idi cheki a hira me, kuburkani ususuru utishi me, barki i chukono imummu ubezi. ");
INSERT INTO jni_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wa suri wa buki anabu wa cheki imum ima dini. ");
INSERT INTO jni_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wa gidi a gbergenu gwardan wa kuri wa zemka a nu mei wa nya ana ti koni ni huma. ");
INSERT INTO jni_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ugomo Hiridus ma kunna nizi ni Yesu na hana piit. Aye wa gusi Yohana unu uzoibo anabu ma hiri a nyimo anu imono barki ani, mazinne wuza imum ibi yau. ");
INSERT INTO jni_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aye wa gu, me Iliya mani aye udura Asere mazigu uye a nyimo a na dura ka Asere ka dati. ");
INSERT INTO jni_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sa Hiridus ma kunna agi Yohana sa makari niche ni me meh, ma hiri. ");
INSERT INTO jni_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Barki matuma a meki Yohana a korso meh ahira ani rere, barki Hirudiya uney u henu unemeh Filibus; barki ma wuzi a nya nan me. ");
INSERT INTO jni_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana ma buki Hiridus “idariziba u ziki uney u hana uwe meh. ");
INSERT INTO jni_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hiriduya ma inki Yohana ni barda barki ma hu meh, da ma rusi ba. ");
INSERT INTO jni_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hiridus ma kunna biyau bi Yohana, ma rusi ma zi inbi yau ba sere mazi lau. Hiridus ma nyari kati adari meh ba. Sa mah kunna tize ta sere a nyo a Yohana tize me ta chari me iri ba, vat ani me ma kunna urunta utize me. ");
INSERT INTO jni_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sa uwui wa biki Hiriduya ma nyari uganiya utita anabuh. Rono uniza ni Hiridus mah titi a nuh adanda ari imumare ana katuma ka ti soja nan nuh aje u Galilee. ");
INSERT INTO jni_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ucha u Hiridiya ma wuzi morso, Hiridus nan agenu me wakuna urunta kang. Ogomo ma gu unnu cha me, vat imum sa uyara innya we. ");
INSERT INTO jni_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma toniko, vat imum sa wa iko in di nya we vat nan u watu uma nyaga mam. ");
INSERT INTO jni_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Masuri maka gona me nya nini indi iki? A ino magu niche ni Yohana unu uzorso anu tarsa u Yesu. ");
INSERT INTO jni_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma kuri debe a nyimo ahira anabuh me, makem ugomo magu in me in yara a nyam a-a na me, Asesere a hira zalang, niche ni Yohana una uzorso anuh bi. ");
INSERT INTO jni_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ugomo ma kunna iriba barki tize ti tuba me nan na genu, da ma rushi u nyari me ba. ");
INSERT INTO jni_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ugomo ma tumi usoja a nyimo ana katuma ka memeh me eh inni che ni Yohana; monno ma ha maka kara niche me ayimo ani reremeh. ");
INSERT INTO jni_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ma eh inni che me, a nyimo imum ihuma ma nya ucha me, ucha ma ziki ma nya a inome. ");
INSERT INTO jni_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Anu tarsa Yesu wa kunna, wonno wa eh wa ziki ikizi me waka vati a nyimo mu chau. ");
INSERT INTO jni_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Adara wa gurna a hiri Yesu, wa buki vat imum sa wa wuzi. ");
INSERT INTO jni_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Magu inweh, “aye ni a nyi mo ani jaa i venke chinilin. anu gwardan wa ehzi. Wa kursi wa ga we u kunna runta, nanni ganiya are imum are. ");
INSERT INTO jni_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wa dusa a nyimo u jirgi umei a hira atik. ");
INSERT INTO jni_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Anuh gwardan wa iri nwe wa rusu we wa sumi in ti buna a nyime a nabuh, wa agiza weh. ");
INSERT INTO jni_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sa ma biki upuru uni goba me Yesu ma iri ni gubiri na nuh, monno ma kunna ugogoni barki wa zi gu itam sarki unni boh uwe tize ta sere meh gwardan. ");
INSERT INTO jni_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa uganiya wa ha piit a nutarsa umemeh wa kem me wa gu “a hira a geme a wuna ni jaa nan u ganiya wa aka. ");
INSERT INTO jni_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","matumi weh waribe a nyimo ani pin nan morobo meh, wa kpi in imum wa ri. ");
INSERT INTO jni_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma karbika ma guh in weh “Shi nya we iri imum wari” wa buki ti da ke ti ha tikakpa imum ya re ikirfi a ino a kur are ti nya we wari? ");
INSERT INTO jni_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma gu in weh ubiredi uhono uni ichanti? ana ika ira. sa wa iri wa gu ana, ma biredi uchibi nan ni chere ini re. ");
INSERT INTO jni_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma busurka anu vat wa chukuno a dizi tikura Asesere ukpe. ");
INSERT INTO jni_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wa chukuno tikura, anu akuru ukirau (100s) nan anu akuru uchibi (50s). ");
INSERT INTO jni_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sa ma zika ubiredi u chibi me nan ni chere ini re ma ayeze Asesere ma wu biringara ma puri ubiredi me ma anabu meh. wa hari anu ichere ira nee. ");
INSERT INTO jni_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wa ri vat har wa tisi. ");
INSERT INTO jni_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wonno wa ziki ma kasu mu mum ya re me igira ukirau nan mare gwem, nan mu gitu mi chere me. ");
INSERT INTO jni_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Uganiya me anu akura akuri uchibi (5000) sa wa re. ");
INSERT INTO jni_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ayimo uganiya me wu anu tarsa ume me wa ribe ayi mo jirgi umei, wa haki aje uwaru u gino me; u Besaida ma sabi ma ma tumi a nuh me wa dusa. ");
INSERT INTO jni_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sa wa dusa monno nyene ani pana ma wu biringara. ");
INSERT INTO jni_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Unu wunjoro ujirgi umei wa ra a matara ma nigaba meh me mazi insisi meha matara. ");
INSERT INTO jni_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma iri ma rusu wa da kunna tize kang ba barki bigirmo ba kati we. Ayimo atiye me ma ha maka kem we, mazi in tanu Asesere a mei, ma nyari aka uweh. ");
INSERT INTO jni_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sa wa iri meh wa gusi nani immoli ini bawa wa wu uhuna. ");
INSERT INTO jni_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Barki vat wa iri me wa kunna biyau, a nyimo uganiya me, ma gu in weh. Wuna ni iri ba ihu! mi mani kati ikunna biyau ba. ");
INSERT INTO jni_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma ribe a nyimo ujirgi umei ba nipupuru ni tonno, wonno wa kunna biyau a meh. ");
INSERT INTO jni_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sa wa kunna abanga ubiredi me, iri bi iwe me i wushew. ");
INSERT INTO jni_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sa wa kafa, wa biki a mayanga mu Genesarat, a nyimo ijirgi umei meh. ");
INSERT INTO jni_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sa wa suri a nyimo a ugirgi umeime, anuh wa rusu Yesu meh. ");
INSERT INTO jni_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Anuh wa ribe a nyimo a ma nyanga vat, wa hazin na anati koni wa en a hira meme. vat a hira sa wa kunna ma hazin. ");
INSERT INTO jni_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Vat a hira sa ma ribe a arobo me ani pin pin nan mayanga me; wa ziki ana ti koni a makasuwa, wa tiri tari barki ma dari wa u nyara udara uwatu u dibi umemeh vat, vat ana ge sa wa duri udibi wa huma. ");
INSERT INTO jni_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Afarisawa wa e anu nyetike i hori imumsa wa e a Yesu wasuri Urushelima wa e urunu a Yesu me. ");
INSERT INTO jni_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wa ti ka inu guna are ahana a kadura ka meme waze inare imumu yare sareke ukpicu utare, barke utanda uwe wa Yahudawa, inke uno maze uru, nanitanu nani ahira tijamani madake mare imumu ini me ba sai makpico iso na iharu menanu ulaidayi me upatu utari tumeme maduku rimumare. ");
INSERT INTO jni_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","We Afisawa nanu kasu ayahudawa indaki wazi warize imumu yare sarki ukpico utareba barki utanda uwe wananu awe me. ");
INSERT INTO jni_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Utanda uwe me inka waze usuro atanu nani ahira tijamani unume makama zuri ma kpico tare muharu nan muso ulaidayi indaki a kura unume mazoro tihihira timeme lau ma dukuri imumu yare. ");
INSERT INTO jni_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A Yahudawa anu nyatike ihori i Musa we wani wazi Yesume wa iki inuguna aneni ahana kadura kawame wazome inu tarsa utanda wananu ashimeba wanu ware imumu yare intari. ");
INSERT INTO jni_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Monno ma kabirkawe maguwe ane ani Ishaya mabuki tize inu guna shime izi muruba mubit shi wono igusa aki tarsa tize ta Asere eni me mucumani izini no wasa me ikirze tarsa utize tum. ");
INSERT INTO jni_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Izee wuza eni sarke uguna indake imumusa indake ma tarsi tishime eze tarsa utanda wana abu ino gunasa agi wasiri. ");
INSERT INTO jni_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ya ceki imumbesa agoshi iwozi shibe izi inuweza yanabu. ");
INSERT INTO jni_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Munu magu awe eni me ane ani ya ceki imumsa Ugomo Asere magu awozume eni shiwono izi shi be ezi ino utanda. ");
INSERT INTO jni_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa magu kati izogi aco uweme nan kaino uweme ba desa mawuza enime aduhume. ");
INSERT INTO jni_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaniya iceki aco ushime aka anu ashime imumu ikaye wazi enime vat imumbe yaze idikem amu aye aze eni. ");
INSERT INTO jni_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Anime ani ya karti me ma benki aco me nan ka inome. ");
INSERT INTO jni_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Enime ya gusi tize ta Asere iza ini mumu ini ba barki atanda ani ize inu bezizi ahana ashime ene eni izinnu wuza timumu timadini. ");
INSERT INTO jni_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu be makurzi sake utita anabu magu awe kunanimime ikuri irusi mimeru kuma kai. ");
INSERT INTO jni_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Imumusa yaribe a puronu amatara indaki ineini ya cara kuma madiniba ahira Asere imumusayesuro anyo unu ineeni madinime ma dandang ahira Asere. ");
INSERT INTO jni_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Vati da sa mazi intutui kini makunna. ");
INSERT INTO jni_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Madusa maribe akura ahana akatuma kameme wa wuzi u ukon inu guna nyanini imumubesa wa buka enime. ");
INSERT INTO jni_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mabuka awe inu guna indaki irusa inu guna imumusa yaribe apuru unobu inze ine eni idaki ene eni madini ba. ");
INSERT INTO jni_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aguna imumu yaribe anyu iriba nabu ine yakuri ya suro ine apuru nome Yesu muno magu iza ine ini madinimeba. ");
INSERT INTO jni_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mano marege mabuki imumbesa yasuro apuromo ine eni yake icukuno madini munu. ");
INSERT INTO jni_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ayemu irebe unovu abini ani akazi ubasu tize ta Asere a iriba unobu kasi mikara uchara umadini uhuza anabu akenzi ayeme iri imumu. ");
INSERT INTO jni_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Okolomo katuma ka zenzen uhem ache ureme ibabana unyarume uni henu ukuna urunta udara umeme. ");
INSERT INTO jni_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vati timumu tiginome tisuso a hira iruba inu vat tekati cera unu meni. ");
INSERT INTO jni_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Madusa ma heri ma ribe ma akura sadaki manyari arusuba Tarya, u Sidon barki kati anu wa ruse ba inime anu wa ruse. ");
INSERT INTO jni_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uru uni sama invana uce sama unu koni uzenze sa ma kunna abanga Yesume mawu masi maka rizo atibuna. ");
INSERT INTO jni_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Eni me u Bahiliniya mani maze ageme u Finikiya a Yome a Yeh Yemo Mayega masuri maha maka tirame tari masusome abergeme avaname. ");
INSERT INTO jni_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu ma gwa we cekinime ahana wari indaki ya wuna riba akabi mumu mare ya hana anya ani iwoci. ");
INSERT INTO jni_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kuma unume ma kabirka ma buu anenime ani unu yataki iharo iwuci inke yare mumu yare ake tizi adizi utu buru. ");
INSERT INTO jni_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Magu ame barki tize tigeme sawa buka teni dusa akura agirome waceki anu wuza me. ");
INSERT INTO jni_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Madusa makori akura makyem vana me ma ribe wakem a bergeneme wa chekime wa mahuma. ");
INSERT INTO jni_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma Yesu ma dusa ma ceke ahira me Tarya madusa uhana u Sodom ma eni wani dandang uGalili aname ma e atari tipem tinu kawe. ");
INSERT INTO jni_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wa e ame inu ture madaki mabari tizeba wa tarime tari akema tarsu me mahuma me. ");
INSERT INTO jni_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mhu kume akira madusa madere me utun sa bibame sa ma dusa madari me melem. ");
INSERT INTO jni_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma yiziniche ma heri Asere madusa magu ame “Ephatha” eni ene “poko!”. ");
INSERT INTO jni_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sa abuka enime madusa makem titui tumeme ta pokino imumusa ya trezeze me nilenme nume ya cekime ma dusa ukuno tize. ");
INSERT INTO jni_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mabuka awe inu guna katu uwe bizi ayeba sa ma kunna wa kati ubenki ubuka we ba wa ri age inu hunume. ");
INSERT INTO jni_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vati mumbesa ma wuza iriri ini mazino kunna tize aruhu unu ahira uhira. ");
INSERT INTO jni_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ayimu tiye, ti gino ni orin na nabu gwardan, wa diri imum ya re vana Asere ma gun we. ");
INSERT INTO jni_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Inzin nu basa ababga ani ori me. barki wa re aje inti cukun na mi. tiye ti taru sarki are imimare. ");
INSERT INTO jni_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","In gi ma tuburko we uhana tikura tuweme sarka are imimare wadi sizizime una. Barki aye awe me, wasuri atina ti piit. ");
INSERT INTO jni_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ahana katuma kameme wa kabirkame, “Abani tidi kem ubiredi ni gwarda ayimo ani ja nigeme ti nya ana geme wa ri wa tii? ");
INSERT INTO jni_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma iki we, “ubiredi ni uhono uni izini? wa gume unu “sunare”. ");
INSERT INTO jni_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Munno ma gun ni ori na nume wa cukuno adizi. Ma ziki ubiredi unu sunareme, ma wu, biringara ma pusi ubiredime ma hari we ");
INSERT INTO jni_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wa kuri wa contikucere cinginlin, ma kuri mawuwe biringara maguwe harani iri. ");
INSERT INTO jni_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wano wa re wa tii. wano wa orso ukasu me sawa re wa ceki ukaso me ma myinca mu gira munu sunare. ");
INSERT INTO jni_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wa zi ahana ruma, anuakuru sunare. vana Asere ma tuburko. we wa dusa. ");
INSERT INTO jni_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Vana Asere ma ribi ayimo uzirgi uwei nan na hana katuma kameme wa ribe ayimo ni kiri nu Dalmanutha. ");
INSERT INTO jni_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarisiyawa wa suru wa tunguno ama tara na me. Wano wa susu me iri mum Asesere, wa mansame wa iri. ");
INSERT INTO jni_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma gunkuno ayimo urusa umeme, ma gu we, nyanini ya wuna ana geme wa nyara irimum kadura kani ma bukashi ada nyame ana geme bihori ba. ");
INSERT INTO jni_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Madusa ma cekiwe, ma kuri ma ribe uzirgi umei ma kuri anikira nu kure nini win me. ");
INSERT INTO jni_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ahana akatuma kameme wa perkewa uzika ukasu ubiredime ahira ameme wa zowe ure ba su ubirede u inde. ");
INSERT INTO jni_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma nyawe ma duku gun we hira na hira i haki ihiri uyeast wanu Farisiyawa nan wa nu Herod ");
INSERT INTO jni_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A hana aka tuma komeme wa hira a cece “wa gu barki sa wa zin unu biredi”. ");
INSERT INTO jni_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu Asere maru sin ani me, ma gunwe, “nyanini ya wuna iziru basa abanga uzatu ubiredi? daki yanu iri ba” daki yamu rusa ba? mu riba mushime ma wanoo? ");
INSERT INTO jni_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Izin na je ida hira shi ba? izin tutoi inda kuna shiba, inda Ringizishi? ");
INSERT INTO jni_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Uganiya sa ma pusi mabiredi manu cibi in hari anu akuru cibi, ya ziki mugira mu ma gitu me mu hono muni? wa kabarkame wa gu munu kirau in munu mu re. ");
INSERT INTO jni_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sa ma pusi mabiredi manu suna mare anyimo akuri anazi, mu gira sa ma nyinca mu hono muniya ziki? wa kabirka me wa gu, munu sunare. ");
INSERT INTO jni_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma gun, da da yamu rusaba? ");
INSERT INTO jni_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wa eh ani pin nu ubethsaida. Ana ni pin me wa eh me unu rubo wa gun Yesu ma dari me. ");
INSERT INTO jni_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ma meki tari tu rubu me, ma surin me akamaru kani pin. sa ma tufo me tobi aje ma tari, tari aje me, ma ikime “wa ira iri imum? ");
INSERT INTO jni_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Urubo ma yeze aje Asesere magu “ma ira anu. wa zi kasi matiti ma tanu. ");
INSERT INTO jni_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma kar ma tara me tari ajeme urubo ma poki ajeme. uhiri umeme udusa uze, ma tunguno uhira u kondi nyani memerun. ");
INSERT INTO jni_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ma kurzo me akura, ma gunme, “ka ti uribe ani pinbe”. ");
INSERT INTO jni_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma gun unu uneh, na tubi a nya ahana imimare wari. ida rizi me ba aziki ubiredi na hana areki a nyimo i wuci ba. ");
INSERT INTO jni_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Une makarbirkame magu aye acu, iwuci indi cukuno ana dizi utabur wa ri ukasu imimare ya hana. ");
INSERT INTO jni_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma kudu ma gun unu neh me, barki sa wa buka ani, dusa bibe bi bur basuru aca uweme.” ");
INSERT INTO jni_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Une makuri ahira ahana akura maka kem vana ma rari ukomi. bibe bibur kasuru. ");
INSERT INTO jni_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Makuri masuri ani pin nu utypre ma eh usidon uraba u Galilee ani kira nu Decapolus. ");
INSERT INTO jni_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa ka aye me unu turi sa ma da kuna tizeba. wa gun Yesu ma tari me tari tumeme. ");
INSERT INTO jni_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mazikime uhana anikiri na nabu, ma soki me nibo ni a nyimo intuime ma tufime tobi ma dari ni lem me. ");
INSERT INTO jni_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma heze aje Asesere, ma gume. poko! ");
INSERT INTO jni_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yesu Mapoki utuime, ma kuna. ");
INSERT INTO jni_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","I binani urai umeme. ");
INSERT INTO jni_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ayimo Uganiya me imum be ya ira anilem me ya dusa. ma tunguno ubootize akuna. ");
INSERT INTO jni_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","De sa ma kuna mue mu boo utize tum uganita uzatu u imbizo uni henu nan uganiya uwuza uti mumu tizezen, Vana unubu ma di kuna mu mue mu rusa ume, ugana sa ma aye akura Asere nan ibe riri. ");
INSERT INTO jni_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ma gun we “kadudure kani ma buka, aye ashi me sa wa turi abame wada donkino me iwono ba wadi ku iri akura ugomo Asere nan ugwardang umeme. ");
INSERT INTO jni_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sa tiye utasi ta aka Yesu ma zauka Bitrus, Yakubu nan Yohana ma han we uzalan. A hira aginome madusa ma gamirka uzina umeme a hira aweme. ");
INSERT INTO jni_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tirunga ti me me dusa ti cukuno ti rum sa adake abati nan iri mum ba. ");
INSERT INTO jni_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wa dusa wa iri Iliya nan Musa wa suro, wa iri we wazi nigo me nan Yesu. ");
INSERT INTO jni_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bitrus ma dusa ma poki anyo ma gun Yesu unudungura ya wuna uri ti cukuno abame na ti barka madanga mataru: hu u'inde, Musa cangi u'inde nan Iliya u'inde. ");
INSERT INTO jni_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bitrus madusa ma diri imum ibuka. Vat uwe ana nigoo ni Yesu me wa kunna biyau. ");
INSERT INTO jni_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ni wiri ni dusa ni korso we. Wa kunna ni myira anyimo aniwiri me ni gusa”vanaa um ma zigene me kunna ni tize time”. ");
INSERT INTO jni_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Daki adodonkino ba, wa dusa daki wa kuri wa ira unu ba, wa iri Yesu mani cas ma turi nan we. ");
INSERT INTO jni_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Uganiya wa zini utuno usuro uzala me, madusa ma gwarika we kati wa ka buka uye ba imum me sa wa ira ba, sai Vanaa unu bu ma hira usuro iwono. ");
INSERT INTO jni_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Barki anime daki wa ka buka uye ba. wa cukuno ubasa imum acece awe ani cas, iri mum sa wa meki igizo ace aweme “nyanini usuro iwono?” ");
INSERT INTO jni_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","wa iki me gu nyanini ya wu anu rusa wa buki agiIliya mani madi tubi u aye? ");
INSERT INTO jni_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ba ma kabirka ma gun we Iliya ma tubi u'aye barki ma barka timum.”Ani nyanini ya wu anyertike agi vanaa unuu madi ribe ijasi” ");
INSERT INTO jni_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba Yesu ma gu Iliya mamu aye, ma e wa wuzi me imum sa ya wu urii, gusi imum me tize tu ugomo asere ta buka ani ce ni meme. ");
INSERT INTO jni_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa wa ze a hira ukasu anu tarsa uyesu, wa e wa iri ni'ori na nu gwardan, anu rusa wadi ku zini inmatara acece awe me. ");
INSERT INTO jni_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sa wa ira Yesu wa dusa wa kunna biyau kan, wa sumi waka kem me. ");
INSERT INTO jni_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Madusa ma iki anu tarsa umeme abanga imum sa wazini matara nan we a hira a nyanini? ");
INSERT INTO jni_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uye anyimo ani ori ma kabirkame magu unu dungura ma aye unu saam um ahira awe me mazan unu ukuni wa gbergene sa ingi wa hira daki maka rusi tize ba. ");
INSERT INTO jni_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Uganiyasa wa hira uke reki me adizi make matoti gusi desa ma wono ufukum umeki ususo anyo ameme ma meki uyadka ahini madi ku cukuno gagan. Ma vovi anutarsa uweme tari wa suso me ni wa ye wa siziki we. ");
INSERT INTO jni_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma dusa ma gun we anu zatu ukuna utize unu maya unu maya uni indi cukuno nan shi aneni indi kunna urunta ushi me aye ni me ahira am. ");
INSERT INTO jni_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wa dusa en invanaa me a hira ameme. Sa ugberge me wa ira Yesu, ma dusa ma reki vanaa me adizi, vanaa me ma dusa ma toti gusi ma wono ufukum unu suso anyo ameme. ");
INSERT INTO jni_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ma iki aco avanaa me uganiya sa vanaa ma zika unu koni me? Aco me gu ma ukoni wa tubisi dati ma daza vanaa uneze. ");
INSERT INTO jni_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vat uganiya sa imum me ya hira iki reki me anyimo ura nani anyimo amei gusi idi hu me. Inki uda ke uwuzi iri mum, kusu benkum kunna ugogoni uru. ");
INSERT INTO jni_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu iki me,”nani udi hem”? vat imum iwuna ini ahira adesa ma hem. ");
INSERT INTO jni_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aco avanaa ma dusa ma kabirka “ma hem benkum unu zati urusa um”. ");
INSERT INTO jni_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sa Yesu ma ira ni'ori na gbardan unu sum u aye ahira aweme ba Yesu ma gbarika ugbergene neme ma”hu bibe bi gbas nan bi uzatu ukunna, ma gunna hu suro amatara kini me kati ukuri uribe anyimo ameme ba. ");
INSERT INTO jni_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma dusa ma wu uhunu ma reki vanaa madi ku suri. vanaa ma toti gusi desa ma wono anu wa tunguno ugusa vanaa me wono. ");
INSERT INTO jni_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu ma meki tari ti yeze, vanaa ma dusa ma tonno. ");
INSERT INTO jni_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sa Yesu ma ribe anyimo akura anu tarsa umeme wa e wa kem me nihunzi ya iki “nyanini ya wuna daki haru ta rusa ugberne me ba?” ");
INSERT INTO jni_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ma kabirka ma gu”ugberne madake ma suri sarki birigara ba”. ");
INSERT INTO jni_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa suri wa meki nibaba wa aki Ugalili, Yesu daki nyarsi uye ma rusi sa wa rani ba. ");
INSERT INTO jni_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Abinime wa cukuno mazi unu dungura anu tarsa umeme ma buki we “adi nya vanna unu atari ta nuu wadi hu me, inki ma wono anyimo tiye ti taru”. ");
INSERT INTO jni_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anu tarsa umeme daki wa rusi imum me sa mazini boo me ba, wadusa wa kunna biyau bi iko ume. ");
INSERT INTO jni_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anyimo atanu tiwe me sa wa biki Ukafanum. Sa wa ciki anyimo akura, ma iki anu tarsa umeme magu “nyanini iba zina unu gamara me una me”? ");
INSERT INTO jni_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wa cukuno tik daki wa buka imum ba. Tize me sa waa zini, matara mani acece aweme agi aveni unu dang. ");
INSERT INTO jni_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sa ma cukuno ba ma titi anu tarsa umeme ukirau nan ware. Ma gun we vat desa ma nyara ma cukuno unu dang, m adi cukuno una dumo ma kuri ma cukuno urere. ");
INSERT INTO jni_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma yeze vanaa atii awe me. Ma inta ani kira ni meme ma gu.” ");
INSERT INTO jni_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Vat desa ma kaba vanaa ugeme anyimo ani za nim ma kaba mi mani, desa ma kabam daki ma kaba mi mani isisi im ba, ma kaba desa ma tumum mani. ");
INSERT INTO jni_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana ma gun me unu udungura, ta ira uye unu karsa agbergene in niza ni weme, haru be ta karti me, barki mada tarsa duru ba. ");
INSERT INTO jni_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ma kabirka magu” kati i karti me ba barki vat desa ma wuza katuma ka dangdang anyimo ani za nim mada buka imum izenze ani ce nim ba”. ");
INSERT INTO jni_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vat desa ma zo me ini shina nan haru ba ma cukuno mazi nigome nan haru. ");
INSERT INTO jni_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Desa ma nya meini masa barki hu wa asere mani ma buka shi mada dira me ba. ");
INSERT INTO jni_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Vat desa ma wuna a hanaa acinci ageme wa rizo idi wu ri atiri me unanzu iriri avingi me ani wiin niconco. ");
INSERT INTO jni_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Inki tari ti we me wuza we uwuzi imum be sa ida rizi me ba u yori tini. idi teki' akura ati gomo ta sere in tari ti inde ini guna u ribe anyimo ura in tari ̧tire. ura sa uda biso me ba. ");
INSERT INTO jni_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ahira izom sa ida wijome ba ada bisome uraa me ba. ");
INSERT INTO jni_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Inki ubuna uweme u wuza u wuza urizi u yori uni. Idi teki unu rii uribe uvenke aseser unu buna u inde unu guna u ribe u raa in ti buna ti re. ");
INSERT INTO jni_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ahira sa izom idi ri we sarki uwijo ada biso me uraa ahira me ba. ");
INSERT INTO jni_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Inki nije ni we me ni wuza urizi ukari nini idi teki unu rii uribe ahira asere ini je ni inde ini uguna u ribe uraa inna je are. ");
INSERT INTO jni_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ahira me sa izom nan ura wadi ri we sarki uwono. ");
INSERT INTO jni_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Adi vingi anu zati u kunna tize ta Asere anyimo uraa rono u aye ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Muhu mu rizi, inki ma corno me ada ke a barka muni? cukuno nin muhu macece ashi me, wuza nin ticukum ti urunta nan ni henu. ");
INSERT INTO jni_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ma ceki ahira aginome ma ha ani kira nu yahudiya ma kuri madusa piit uhana uraba u urdu ni gura na nabu ni kuri ni a hira meme ma zin nu dungura uwe imumbesa maharika u wuzame. ");
INSERT INTO jni_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Anu bezurusa wa e ahira ame wa ikime, “nani ya wuna uri u ruma “uruma ma harzina nan nu ne umeme?” wa ilime wa iri ini. ");
INSERT INTO jni_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma kabirkawe, “ane ni Musa ma inki shi tize? ");
INSERT INTO jni_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wa gu Musa ma him vana uruma ma nyertike ihori ama cikime madusa. ");
INSERT INTO jni_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu magunwe barki ugbas usheni. ");
INSERT INTO jni_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Usuro utuba Asere a bari vanu ruma nan nu u e. ");
INSERT INTO jni_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Barki ani me vanu ruma madi kiri a co nan ka ino wapat ina. ");
INSERT INTO jni_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wa ware wa cukuno binama bi inde aziguna wa kadza anawari wa cukuno binama bi inde. ");
INSERT INTO jni_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vat imumbesa Asere apata unu hara ma zoni. ");
INSERT INTO jni_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Uganiya sa wa ra anyumo akura anu tarsa ume wa kura wa ikime abangame. ");
INSERT INTO jni_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma gunme, vat desa ma gido une umeme ma huza anya nan uru nee ma wuza madini. ");
INSERT INTO jni_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inki vanu e makini uruma ume maka wuza ara nyasas nan ure vanu runa ma wuza madini. ");
INSERT INTO jni_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anabuwa en inna hana acincin madarwe anu tarsa Uyesu wa gwari kawe. ");
INSERT INTO jni_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ma iri ani me ma kunna iriba inwe, ma gun we cekini ahana cincin wa e a hira am, kati ikartuwe ba, akura Ugomo Asere usas-suna uwe uni a nyara. ");
INSERT INTO jni_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ka dure in boshi, vat de sa da makaba tizee ti ugomo sere kasi vana ucin mada ribe me Asesere. ");
INSERT INTO jni_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Maduku gbemdurko ahana ahabu ameme ma ringir ka we. ");
INSERT INTO jni_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sa ma tuba tanu, urunu ma sumi mabikime matun guno aje ameme ma iki me “unu dungura nyanini indi wuzi in kim bibeu bu zatu mara? ");
INSERT INTO jni_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu magu “nyanini utisom uni dungara uriri? unu dungura uriri memani Ugoma Asere. ");
INSERT INTO jni_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Urusa uinko tize udida hunawe udida wuza imum imadin udida wuzawe ni kari udida wuzawe ma cuco udida nokuwe unu nya aconanka ino tina nu” ");
INSERT INTO jni_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Unume magu “unudugwa vat adodu aginome martarsan ani, ami manyam. ");
INSERT INTO jni_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ma irime ma gun me imumu inde ini ya dewe kaziza adodu aweme vat u e utarsum, udikum ani Asesere. ");
INSERT INTO jni_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sa ma kunna tize tigino nipum niwi me camcam ma kunna gwan-gwan ma suri ma kini ahirame barki me uni mum taritini. ");
INSERT INTO jni_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ma iri anu tarsa umeme magu idi zinijas inimum maribe Asesere. ");
INSERT INTO jni_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ahana utarsa umeme biyau bimikuwe inni gurang me sa mabuka, Yesu ma kuru ma gun we “idi cukono ini jas unukim maribe Asesere! ");
INSERT INTO jni_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Idi cukuno sheu bironkomi biribe ani hara na lira inni guna uni kim ma ribe Asesere. ");
INSERT INTO jni_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Innu kunna anime saya kini muruba mu wuwe seke “wagu aveni madikafaa.” ");
INSERT INTO jni_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","“ Yesu mahiriwe magu”uhira ushime uwuna imum izoni, vat imum iwuna ini a hira asere. ");
INSERT INTO jni_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus ma gume haru betakini adodu aru ti tar su we. ");
INSERT INTO jni_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu madusa ma gume bade sa ma kini, a kura, nihenu, a ino, aco, a hani nani tiru, barki mi nantize tum. ");
INSERT INTO jni_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Makabi imum gwardan sa idi tekitimum me sama kini adumo. ");
INSERT INTO jni_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anu gwardan sa we wani anu tuba wadi cukuno anu masi za. ");
INSERT INTO jni_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wara anyimo tuna uhana urshalima yesu mara aje wawuzi imum ibiyau. ");
INSERT INTO jni_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tiyen ne ti ha za, u'urshalima adi nya vana, unu atiri tanua dadan dam anu rusa u nyetike litize. Wadi in tize ahume. ");
INSERT INTO jni_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wa di wuze me ni basa wa tufzi me tobi wa cobi me wahume, inki wa huname madi hiri anyimo atiye titaru.” ");
INSERT INTO jni_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakubu nan yohanna a hana, a zabadi wa'e ahira ame wagu,”unudungara ti nyara uwu zin dura immumbe sata iko we. ");
INSERT INTO jni_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Magunwe”nyanini nyara in wuzi shiri”? ");
INSERT INTO jni_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wagu me kirin duru ti cukuno ani nonzo nowome, unu inde atari tinare uye atinan gure tuweme. ");
INSERT INTO jni_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ma kabarka magurwe”ida rusa shi imum me sa izunu igizome idake isi ijas me san disi? Wak ");
INSERT INTO jni_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","abirka wadake, Yesu ma kabirikawe rusani ijas me san indisi idi si. ");
INSERT INTO jni_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Desa madi cukuno atare tinare nan tinan gure da immani indi nya se an de sa anyawe.” ");
INSERT INTO jni_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Anu kirau anyimo anutarsa ume sa wa kumna anime. watubi kunzuna umu ruba in yakubu nan yohana. ");
INSERT INTO jni_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu matit tuwe magunwe,”irusa anuagebe sawazi agomo aweme wa bezizi anu zatu tarsa asere nikara. ");
INSERT INTO jni_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Daki ame ani idi cukuno anyimo ashime. vat desa ma nyara ma cukuno unanu anyume ashime memani madi cukuno urere a nyimo ma ashime. ");
INSERT INTO jni_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vat desa ma nyara ma cukuno aje shime, ama cukuno urere. ");
INSERT INTO jni_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vana unu ma e uwuza ukatuma ka co me kani, da awuzi meni. ");
INSERT INTO jni_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Waribe uyariko sa wa suro uyariko ni gome nan ni go namu tarsa ume. a nyimo atanu tuwe me wasusa wagun na nanurru urubo una ni za bartamawa su sammu timawas ma ciki ani kira nuna. ");
INSERT INTO jni_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Samakuna yesu banazera mani mayezen nigmyirang magu”yesu vana udauda kunna ugogoni um!” ");
INSERT INTO jni_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anume vat wa kwadi me, wagun me wana tik makuri mayeze nigmyirang ukure. ");
INSERT INTO jni_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu matunno magu atitime wa dusa wa tunno wa titime wagu uni ribahu aye. ");
INSERT INTO jni_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma suso udibi ma'hiri matonno ma ha ahira ayeso. ");
INSERT INTO jni_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ma kabirki me, “nyani ni u nyara in wu zuwe ni?” urubo magu unu rusa in nyara in kin, uhira ahira. ");
INSERT INTO jni_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu magu dusa u hem u'wo me wa humman hu.”Sama kim u hira ma dusa ma tarsime, wa dusa nigome. ");
INSERT INTO jni_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sa wa e mamu nan Urushalima, nan Betafaji, a ubetanya u watu ini po nu zaitun, yesu ma tumi ana wa re ayimo ni go ni meme ");
INSERT INTO jni_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2",". magun we hanani aku giro ku ginome aje ashime, unu ribe ushi idi iri kuzenki kutiri, anu hira shi ba i sopi i eni, ");
INSERT INTO jni_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3",". vat de sa ma gunan shi nyanini i wuza anime? i gun me (sakura mani ma nyara, madi kurzoni ingi ma mara. ");
INSERT INTO jni_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","wa dusa waka kem kuzenki kutiri ana tukum akura upuru una wa sopi. ");
INSERT INTO jni_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","A de sa wa ra ahira me wa iki we yanini ya wuna ya sapo kuzenki me? wa buki we imumme sa sakura ma buki. ");
INSERT INTO jni_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ba wa cheki we wa dusa. ");
INSERT INTO jni_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba wa e yesu in ku zenki me, wa nassa madibi maweme a maro a Luzern me madi ku nyene ");
INSERT INTO jni_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anu gwardan wa nasa madibi mawame uname aye waka nyarsa mava mama titi wanasa uname. ");
INSERT INTO jni_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ana je nan ana dumo wa yeze amyira wa nonzo de sa ma eze ayimo ni za na asere. ");
INSERT INTO jni_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nonzoti somo sa ti eze uwatu aco aru Dauda 'Nonzo ogomo asere. ");
INSERT INTO jni_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu ma ribe urushalima ma ha uwatu udenge asere. ma gunkuno kodi nyani ahira me. uganiya uwunjoro, masuri madusa ubetanya nan nanu kirau in wa re. ");
INSERT INTO jni_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ni ye ni kure, sa wa ze usuro ubetanya, ikomo, imeki me. ");
INSERT INTO jni_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma iri utiti upom piit in mava mariri, maha nani madi ka kem ahana mari, dama kem i muma ahira me ban mava cas, da uganiya iburi ini ba ");
INSERT INTO jni_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14",". Magu titime,” uye mada kuri ure ire imumu ahira aweme,” anutarsa ume unuy kunna me. ");
INSERT INTO jni_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sa waze urushalima, maribe udenge aser, ma kem azinu ziza adodo ahira udenge asere me ma gidiwa, ma gamari tihira tanu ugamara i kirfi na makwanku manu ziza uti mumu ma vingizi. ");
INSERT INTO jni_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma karti uzika koyani uwatu udenge asere sa azi unizizame ahira me. ");
INSERT INTO jni_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma dunguri we magu,” Akura am adi chukuno ahira tize nan asere vat une'? shibe ya kurzo ya kurzo ani mabere ma kari ");
INSERT INTO jni_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18",". Unu udandan udungara katoma ka asere nan anu nyetike ihori wa kuna imum me sa buki, wa ziki una uguna wadi hume, barki bi yau ziki una uguna wadi hone. barki bi yau wa iri vat adesa waa ra ahira me wahem in yeso iriba iweme ");
INSERT INTO jni_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19",". ko ya uwunjoro wadi cekki ni pin me. ");
INSERT INTO jni_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sa wa hira ni sisizo, wa iri utiti upom me wa-waa nan ti ji me ");
INSERT INTO jni_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21",". Bitrus maringi me magu,”una akura ira' utiti upom me sa wa wu uni anyo wa-waa kpagarak. ");
INSERT INTO jni_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","yeso ma kabirka magun we, inko ni iriba ahira asere ");
INSERT INTO jni_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23",". kadure kani in boshi vat de sa ma inko riba ahira asere mada ke magu unu pana, hira abame uha anyimo a niwin, in daki ma wuza ma, aye ba mahem iri ba imeme idi cukuno anime, asere adiwuzi katuma kameme. ");
INSERT INTO jni_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","yeso magu mabukashi, vat imum sa ya iko a bi ringara, inkoni iriba idi kem, idi cukuno anime ");
INSERT INTO jni_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25",". ingi idi wu biringara -ivete vat imumme sa uye ma wuna shi, barki acoo ashi me anyimo aseseri ma vete shi meni cangi ");
INSERT INTO jni_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","in daki ya veteni ba, acoo ashi anyimo aseseri mada vete sheni ba cangi. ");
INSERT INTO jni_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa wa kuro urishalima, yesu mahazi uribe udenge asere, unu dandang, anu nyetike ihori wa nanu-udenge asere wa e wa kem me. ");
INSERT INTO jni_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wa gun me,” unu uya ubari uni uzin katuma ka geme? aveni ma nya we ni kara ni wuza katuma ka geme? ");
INSERT INTO jni_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ma gun we, ca mi, in ikishi changi. ingi yabuka ni mi indi buki shi desa ma nyam ni kara ni wuza ka katuma ka geme ");
INSERT INTO jni_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","uzurso uyohana, wa seseri uni nani wa annu, uni? kabirkani mi”. ");
INSERT INTO jni_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","wa gamirka tize acece aweme wa gu, ingi ta guna aseseri ani- madigu, nyani ya wuna daki ya hem in me ba? ");
INSERT INTO jni_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ingi ta guna ahira unnu ani” wa kuna iyau ya nu, vat wa hem in yohanna una ka tuma ka asere mani. Abini me wa kabirka Yesu wa gu, tida tanduru ba, ");
INSERT INTO jni_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Abini me Yesu ma gun we,” mi cangi inda bukashi nani aveni ma nyam nikara ni katuma ba,” nani in buki shi in ni kara na veni in zini wuza katuma me” ");
INSERT INTO jni_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","I Yesubma tubi inwe in ze torusa, magu unu nubu mabari imum uru imeme maketi a hirama in matiti ma henzi uwa coco makarsi madini makuri mabari ahira uzu mei urun uma titi, madusa a tanu ta piit. ");
INSERT INTO jni_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Imum yanyame matonue anakadura kameme ura ma owawane ore sa makakaba ibru imatitima ma meki vana me watri wahu arume. ");
INSERT INTO jni_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Koma wazekime, watirime, wa birko me wa dusa sarki iri mum. ");
INSERT INTO jni_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wa sake utumma aye ahira awame una kadura, watri me wakunna me iwowo anice wacekime in mu e. ");
INSERT INTO jni_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Makuri matumi u ye unu inde ahu, wagumari aye awa me, watiri watiri wahuwatuzi we. ");
INSERT INTO jni_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mazi uni inde sa madi tumi, una adimo me ma guana unadumo sa madi tumime, wadi kunna biyau bi meme. ");
INSERT INTO jni_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Anaka tuma waguana vana uyo ume mazi geme cati hu me ti cati imum ya choo me. ");
INSERT INTO jni_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wa meki me wa hu wa vingi me a ni kira ni ru. ");
INSERT INTO jni_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nyanini unu ru me, madi wu, madi huzi anu inta uru me, ma nya aye. ");
INSERT INTO jni_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Da ya basa ihori ige me sa, nipo sa anyarime nini, ni neni na cukuna nipo ni tuba uru tini. ");
INSERT INTO jni_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tize uwatu Asere imumu ibiyau a je aru me. ");
INSERT INTO jni_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Watubi unyarsa umaki Yesu. ");
INSERT INTO jni_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wa tuburko ma Farisiyawa wana Hiridiyawa, wa nyarisi me intize. ");
INSERT INTO jni_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sa wa e, wagumme, unudungara, inzome iri imumbe sa mabizema sizi anime, mazi neziwe nibaba nigome Asere ma nya kaisar imumsa izi kaisa. ");
INSERT INTO jni_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Matinka malim mawa me nyanini i we me wa pattum. unyam imum sa mari ini. ");
INSERT INTO jni_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wa nya Yesu unu inde, mabukwe, muhenu maveni ma zige me, wa gu muhenu ma kaisar. ");
INSERT INTO jni_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu magu nya kisari imumbe sa izi kisari unya Yesu, imeme nyani imum be sizi ya Asere inyan Asere. ");
INSERT INTO jni_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A Sadukiyawa e ahira a! eme wa debe sa maguna u hira uzoni wa iki me. ");
INSERT INTO jni_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Uni bizizi Musa ma nyetike durin ingi uhenu ma womo maceki unej umeme, sarki vana anyimo uni henu, a uye mazi uneh me bayi mayo vana unu neti unanu me. ");
INSERT INTO jni_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Anu sunare anihenu, wazi anya unu ne u inde unu tuba uzika me ma wii, ma ceki me sarki vana. ");
INSERT INTO jni_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Unu ure ma wii maceki ine me sarki vana unu uku taru cangi ma wii. ");
INSERT INTO jni_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Unu usunare ma wii ma ceki me sarki ahana u aye adumo me une ma wii. ");
INSERT INTO jni_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Romo be sa Ugomo Asere madi e une me madi wa veni. ");
INSERT INTO jni_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu magu ine ini ya wuna i carsa abangan, barki uzatu urusa uni kara na Asere. ");
INSERT INTO jni_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rono u zauka anabuu, anya adi zoni, vat uru tidi cukunomana kadura Asere. ");
INSERT INTO jni_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Abanga iwono, nanu uhirza ibe daki ya bassani ihori i Musa sa ma nyetike anyimo anijaa unu guna immani Asere Ibrahim, Asere a Ishaku, nan Asere a Yakubu. ");
INSERT INTO jni_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","An, debe sa Asere mazi Asere a weme anu vengize mani, wazome anu vengize mani wazome u guna aginwe mukizi muni ya hurna shi gbardang. ");
INSERT INTO jni_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Uye ma e mazi kunna imum be sa wazi unu boo me, ma iri Yesu makabarka ma iki we, tiye tize yini tiduandang. ");
INSERT INTO jni_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu makabirka we tize ti dandang, kunna ni, anu IrailamUgomo Asere azia inde. ");
INSERT INTO jni_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Udi tafna nan na Asere, Ugomo Asere vat ini riba iwe me, nanbi be biweme, wa nikara. ");
INSERT INTO jni_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tize tu kure, tine tini in taa uroni utura uwe me gusi nice nu we me, ure ukuri uka zoni sa uteki ugeme. ");
INSERT INTO jni_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Unu nyetike, magu, rep unu urusa, ka dura kani Asere azi a inde, ara Asere azo ni. ");
INSERT INTO jni_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uhem me vat ini riba inde wanu rusa, vat nikara uhem uroni utura gusi ni wome ine ini itaki uni ure, ubonza adodu nan wiro udi roronga. ");
INSERT INTO jni_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sa Yesu ma iri, ukabirka umeme urisi, magun we uzo we piit nan nakura Asere abini ani daki uye makuri ma iki me iri mum. ");
INSERT INTO jni_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu mara udenge Asere magi unu boo uwe ti ze ta Asere, vana u Dauda. ");
INSERT INTO jni_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauda biriri ba gunana, Asere, cukuno atinare tam indi kurzo aroni ishine iwome ati buna tiwome. ");
INSERT INTO jni_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda nice ni meme magu una kaba uru “Asere”, nyani ya wu a gum me vanu Dauda?, ni ori na nu kunna anyimo iri ba irum. ");
INSERT INTO jni_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu unu bezizi haka sake ina nu unyeyike anu unyara uniza uni sansani uni izini we ajira ani gura. ");
INSERT INTO jni_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Anu nyara ahira ticukuno ti dandang ati denge ta Asere wanti hira tu tanda. ");
INSERT INTO jni_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wadi ribize ati kura ta neti a koro wa kuri wa wusi bi ringara bi joko bati uwuna ugino me imum izenze ini. ");
INSERT INTO jni_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ba abini me Yesu ma cukuno a nikuri a nyimo udenge Asere, unu hira anu unu rezi ikirfi anyimo ani kuri, anu gbardang wa rezi ikirfi idandang anyimo imumbesa wazini. ");
INSERT INTO jni_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ure ukoro une ma e ma reki anini ana re cas. ");
INSERT INTO jni_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma titi anu tarsa umeme magu we, kudura ka zigeme imboo shi, imumbe ukoro uweri ugeme, mareki iso igeme iteki ukasu anume. ");
INSERT INTO jni_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wa nyaniza anyino ukem uwe, sa wazin, me anyimo udira ume uni, ma nya vat, mum be sa mazi. ");
INSERT INTO jni_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Uganiya sa Yesu ma suri udenge Asere ure unu tarsa umeme ma gu ma”unu dungara. ");
INSERT INTO jni_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ira a poo nan ti kura ti riri ti geme”. Yesu ma iki me ma gu ira ti kura ti riri ti geme ada ceke me iri imum ba. ");
INSERT INTO jni_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma iki Asere uzalang uzaitun upuri udenge Asere ba yakubu, yohana nan Andrawus wa eh wa kem me, wa iki me ni hunzi. ");
INSERT INTO jni_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ma iki unu maya uni imum i geme idi eh? wadi wu aneni wa rusi? ");
INSERT INTO jni_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ma kabirka we magu”cukuno ni unu rusa kati arangi shi. ");
INSERT INTO jni_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aye wadi eh anyimo ani za num, wadi wadi rangizi aye wa hunne me unna. ");
INSERT INTO jni_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma guu ingi ya kunna abanga ani kono kati i basa ba, daki yamu ira imum ba imum i dadang i eze a dumo. ");
INSERT INTO jni_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ni henu ni di game ni henu ni lem ni di game ni lem idi kunna abanga uzuro adizi a ti hira sas, sas, adi wuzi ikomo. Ituba ijasi ya zigino me. ");
INSERT INTO jni_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cukuno ni unu rusa, wadi han shi aje a gomo, adi tirzi shi anyimo ati denge tini gura ahan shi aje ananu ama nyanga nan na agomo adang une barki niza nim, idi cukuno imum kunna a hira awe me. ");
INSERT INTO jni_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ti mum ti ginome ti da karti tize ti ugomo Asere u re aje ba, tize ti ugomo Asere at une. ");
INSERT INTO jni_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Inki wa meki shi wa hanan aje ati gomo kati igizo imum me sa idi buki ba, anyimo. uganiya me, daki shi wa ni idi buki tize ba, Ugomo Asere ma di nya shi imum be sa idi. buki. ");
INSERT INTO jni_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","uhenu ma di nyari uhenu a hume, aco madi nya vanna u meme. Ahanna wadi game an de sa wa yoo we wadi nyari una sa adi huu anu yoo uweme. ");
INSERT INTO jni_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vat anu wadi game shi barki niza num. Desa ma tonno inikara barki mi, madi kem. uvenke. ");
INSERT INTO jni_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Inki ya ira ti mum ti ma dini ti zezen ati hira sa daki ya wunu ri ti cukuno nin ca unu poko aje marusi nan ande sa wa ra u yahudiya wa sumi uhana ahira zalan. ");
INSERT INTO jni_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Desa ma tari asesere udenge kati ma tu ba, nani ma ziki iri mum a nyimo me. ");
INSERT INTO jni_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kati desa mamu hana uruu magu madi ze ma ziki ugeptu uimpino ba. ");
INSERT INTO jni_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Idi cukuno imum ugogoni ahira a desa wadi inta tipuru tu yoo nani a hana aneze nyimo tiye ti gino me. ");
INSERT INTO jni_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wuzani biringara kati imum me i kem in nikuzi. ");
INSERT INTO jni_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Adi kunna ijasi igeme sa a mu kunna ba, adi iri imum me sa da mu ira usasana u ini ba. ");
INSERT INTO jni_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sarki Ugomo Asere ma kaska tiye ti inoma ba, inu ma bari uvenke ba, barki andesa azauka we madi kaska tiye ti gino me. ");
INSERT INTO jni_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","In ki uye ma ranga shi ma ira Ugomo Asere aba, nani abini kati i hem ba. ");
INSERT INTO jni_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Atiye ti gino me agomo ama cico nan anu rusa utize ta sere amacico wadi suri wa bezi shi tire ti mumum bati wa rangizi shi vat nan de sa ma zauka we. ");
INSERT INTO jni_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cukuno nin unu rusa ma buka shi. ");
INSERT INTO jni_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Inki tiye ti jasi ti gino me ta aka uwuyi udi game usuro, upeu udi game u nya u ma saa. ");
INSERT INTO jni_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iwira idi rizizi asesere, adi zuruko une ini kara nu Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Abini adi. iri vana Ugomo Asere madi eh anyimo ati wiri anyimo ani kara nan ni nonzo ni meme. ");
INSERT INTO jni_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abini madi ku tuma ahana akadura ka meme madi ori an desa mazauka we vat atikira tu nee na na asesere nan na asesere nan nadizi. ");
INSERT INTO jni_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tinka ni iri mum. ahira utiti upom. Inki wa. Kponko ma wa ma. uni urusi ni kuzi na biki urizo. ");
INSERT INTO jni_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ane ani. Inki ya ira ti mum ti geme ta aye irusi Ugomo Asere mabiki uzee. ");
INSERT INTO jni_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma buka shi ucara ugeme udi aki me sarki u ira uti mumum ti geme. ");
INSERT INTO jni_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asesere nan adizi wadi mari, tize tum ti da mara me ba. ");
INSERT INTO jni_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Abanga uwuyi nan uganiya uge me uye mada rusa me ba, nani ahana akadura ka meme, nan vana Ugomo Asere, aco me mani marusa unu ganiya ma. ");
INSERT INTO jni_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cukuno ni a nyimo u rusa, kati iperke ba, ida rusa uganiya sa madi eh ba. ");
INSERT INTO jni_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ya cukuno gusi unakura mani sa ma nyari wuza tanu bama dusa ma nya urere umeme utarsa ina kura, ma hari we katuma koda vi in kame. Ba dusa magun unu nu hira akura me na cukuno sarki ugbiso. ");
INSERT INTO jni_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Barki an me cukuni unu be, barki ida rusa uwuyi me sa acoo akura me madi ze ba, nani madi ze unu wunjoro uni, nan ina ti aniye, uganiya sa bigoro bidi zin unu runzo. ");
INSERT INTO jni_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","in ki ma aye sarki urusa u we me kati mukurka we. ");
INSERT INTO jni_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Imum sa ma buka shi, mabuka koda vi! cukunoni unu rusa. ");
INSERT INTO jni_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tiye ti re ta dii uguna a wuzi utanda uringi ukafa ani rere nan u biredi uzatu pata nan iri mum. anu adangdang aka tuma nan anu rusa wa gurna anu rusa wa gurna unu nyara una me sa wadi maki Yeso bati wa huu me. ");
INSERT INTO jni_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wa gamarka ace awe me inki wa guna wadi meki me unu wuyi unu gori nini mu ruba ma nu mu hiri. ");
INSERT INTO jni_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uganiya sa yeso marani Ubatani akura simon una tikuturu, saa ma ciki ure une ma dusa ma en mani mi kirfi ma kari ma kari yesu mani ani ce vat. ");
INSERT INTO jni_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aye sa wa raa ahira me mu ruba mu corno me. Unu boo tize acece awe me, unu gusa nyanini ya karti a zizi a hari anu dira ikirfi me? ");
INSERT INTO jni_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waa gu mani mageme sa adake azizi ini kirfi idang sa iteki madinari akuri ataru, wa dusa wa meki ugbara ume. ");
INSERT INTO jni_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu ma kabirka magun we nyanini ya wuna izinu busura ume? me sa ma wuzam imum iriri. ");
INSERT INTO jni_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mi ida dem na shi ba, anu dira wazi nigome nan shi ida kee ibenki we uganiya sa wa wuna shi. ");
INSERT INTO jni_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Une uge me ma wuza imum me sa mada ke ma wuzi: ma kpicom barki uvatti um. ");
INSERT INTO jni_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma buka shi kadure me vat ahira sa adi buu tize ti ugomo asere anyimo une, imum me sa une ugeme ma wuza adi rigi nin. ");
INSERT INTO jni_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anyimo ukirau nan ure me, Yahuda iskariyoti ma dusa ma ha ahira ana dangdang magu madi bezi we yeso. ");
INSERT INTO jni_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Barki u kunna urunta wagu wadi nya me ikirfi, ma tubi ubasa una me sa madibezi we me. ");
INSERT INTO jni_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Unu wuyi utuba ubirede uzatti upatta nan iri imum sa ake weki bitam barki ukpico, ahanaa aka dura wa iki me”abani wadi ka barka ahira sa wadi ka re imum yare? ");
INSERT INTO jni_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Madusa ma tumi ana ware anyimo ani pin, ma gun we idi gurna nan uye sa ma cira bidaka bi mei. ");
INSERT INTO jni_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","I tarsi me akura sa madi ribe ni, i gun unu na kura me unu dungura ma guna”udenge me u raba sa madi cukuno nin ma ri imum ye re yi tanda i kafa nin nan anu tarsa u meme?” ");
INSERT INTO jni_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Madi bezi shi udenge udangdang sa wuza vat ti hira ti tikum nan vat ti mum me sa a nyara i barka ni uni memeru. ");
INSERT INTO jni_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Adura me wa dusa wa ribe ani pin me, waka kem imum me reb nan tize ti meme. ");
INSERT INTO jni_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa uwunjoro wa wuna wa dusa wa ribe akura me nan anu tarsa umeme ukirau nan wa re wa gino me. ");
INSERT INTO jni_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sa wa zini ure imum ya re, Yesu madusa ma poki anyo magu “indi buki shi kadure me uye anyimo ashi sa ti zini ure imum yare nigo me madi wuzim malim ma witim a tari ta roni ani eru. ");
INSERT INTO jni_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mu ruba mu we me mu corno me wa tubi u igizo me”nani mi mani” ");
INSERT INTO jni_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeso ma gun we anyimo ashi me ukirau nan wa re sa tizin unu re imum yare isso I inde. ");
INSERT INTO jni_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kasi Ubuka utize tu ugomo asere ta buka vanaa unu madi tarsi imum me sa ta buka ani ce ni meme. Desa ma nya vanaa unu ahu, madi kunna dagi ayoo me ba. ");
INSERT INTO jni_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","sa wa zin unu re umum ya re, Yeso ma ziki ubiredi ma yorsi uni ma nya we ma gu re nipum nim nini imum iringizi in mi. ");
INSERT INTO jni_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma inti mei magu sa ni maye mam mani, maye mu inko tize barki anu gbardang. ");
INSERT INTO jni_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma gun we maye mam Mani mu myinca imum idi benki shi sa ma pkonko. ");
INSERT INTO jni_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kadundure ma buka shi ahanaa aka dura ku gomo asere atikira tinazi tu nee adizi nan aseser wadi gurna vat ati gomo ta asere. ");
INSERT INTO jni_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sa wa wuza ira ini nonzo wa dusa wa suri uhana upana u Olifis. ");
INSERT INTO jni_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ma gun we,”vat ushi idi rizi barki mi gu unyerte me. ma gu “itam me idi samirka inki ma kara unu tarsan we”. ");
INSERT INTO jni_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Inki ma hira, indi agiza shi uribe Ugalili”. ");
INSERT INTO jni_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ba Bitrus ma gu inki vat ukasu udi rizi mi inda rizon ba. ");
INSERT INTO jni_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ma gu,”kadundura anyimo aniye ni geme udi nyare mi kataru adaa bigoro ba runo kare ba. ");
INSERT INTO jni_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bitrus ma kuri ma gu ingi iwono ini tidi wi nigo me vat uwe wa buki ani me. ");
INSERT INTO jni_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa wa e ahira sa a tisa ani UGethsamani, Yesu ma gu inanu tarsa umeme”cukuno nin aba me idika wuna birigira”. ");
INSERT INTO jni_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ba ma dusa nan Bitrus, Yakubu, nan Yohana ma tubi u kunna upazaza me. ");
INSERT INTO jni_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma gun we “izin apuru abit, gusiindi wi. Be ni mi abame kati i ha amoro” ");
INSERT INTO jni_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu manyari kure kuhira matunguno ina ruu biringira dagi unyara gu ukem uni mada ira aje avu ageme ba. ");
INSERT INTO jni_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Magu “Asere acoo, vat inki imum iwuna karam upazaza ugeme. daki barki unyara um ba caa ucukuno uweme uni. ");
INSERT INTO jni_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Makuri ma ken we wazin immoro, magun we Bitrus, Siman, izin moroo? Ida ke izi uganiya daki ya wuza moroo. ");
INSERT INTO jni_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hira ni wuza ni biringira kati irizi nin, urubu ya hem nipum na game. ");
INSERT INTO jni_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Makurri ahira abirigira ma ze ma kuri buki imum me sa mabuki unu tuba. ");
INSERT INTO jni_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma kuri ukure ma e ma ken we wazin imoro, aje awe me idi ku pazaza barki moroo wadiri imum be sa wadi buki me. ");
INSERT INTO jni_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma kuri utaru, magun we idazan moroo, unuvenke imum ishi? Ya bari ani me uganiya wa aye sa idi nya vanaa unu bu atari ta nu cara abanga. ");
INSERT INTO jni_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hira ni tidusa, desa madi witim atari ti we me ma raa mamu. ");
INSERT INTO jni_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sa ma raa anyimo atize me Yahuda i, sa ma raa anyimo ukirau nan ware wa gino me maka aye in na nu gbardang inti vira nan ti bina nan anu akatuma ka asere nan anu unyetike nan a nanu. ");
INSERT INTO jni_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yahuda unu unya umeme mamu bezi we imum me sa madi wuzi ma bezi Yesu,”desa indi gbidirko me” ");
INSERT INTO jni_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sa yahuda ma aye ma e ahira Yesu ma gu”rabbi” madusa ma gbidirko me. ");
INSERT INTO jni_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wa dusa maki me wa hunguko wa dusa ni. ");
INSERT INTO jni_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Uye anyimo ani goo ni Yesu madusa ma suso uvira ma yori utiyui ure vanaa una ukatuma. ");
INSERT INTO jni_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu ma iki we magun”ya ayen inti vira nan ti bina gusi ya aye umeki ukari?” ");
INSERT INTO jni_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sa mazi ini go me nan shi uni bezizi tize anyimo ti denge tini gura daki ya meki ni mi ba. Awu ani me barki amyinca tize tasere tini. ");
INSERT INTO jni_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Adesa wa zi nigome nan Yesu wa sumi wa ceki me. ");
INSERT INTO jni_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ure vanaa sa mazi tarsa me sa soki udubi, wa dusa wa meki. ");
INSERT INTO jni_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Madusa ma summi bihurba me. ");
INSERT INTO jni_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wa ziki Yesu wa han me ahira unu dang uka tuma kasere, ananu nan anu nyetike. ");
INSERT INTO jni_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitrus ma tarsi uwe me piit uka biki udenge unu dang kasere. ma cukuno nan anu bee ahira me unu kunna ura . ");
INSERT INTO jni_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abini me unu dang me vat nan ana katuma kameme nyari tina be sa wadi meki me unu siziki me. Wa kem me mazi lau. ");
INSERT INTO jni_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anu gbardang wa aziin tize ti macico ani ce nimeme, wa kem me mazi lau. ");
INSERT INTO jni_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aye wa ezinin intize ti macico ani ce nimeme wagu ana. ");
INSERT INTO jni_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Wa kunna me maguna”indi ke intuburko akura ani gura ageme im barka ageme sa daki abarkan in tari ba anyimo ati ye ti taru”. ");
INSERT INTO jni_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","vat ani me daki a hem ini mum mem sa wa buka ba. ");
INSERT INTO jni_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Unu dang me ma hiri ma iki Yesu”u da zo unu ukabirka utize, imum ma sa anu ageme wa buka ani ce ni we me ba”? ");
INSERT INTO jni_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Daki ma kabirka me ba. Unu dang me ma kuri ma iki me hu mani Yesu vanaa ulau. ");
INSERT INTO jni_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu magu”imimani” udi iri unuu ma ciki atari tinare titi gomo nan niwiri aseser”. ");
INSERT INTO jni_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Unu dang me ma maki udibi uyesu me mahammirka uni, magu”nyanini tinyara, ti kuri ti nyara mare masaa?” ");
INSERT INTO jni_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya kunna ni tizogo ta asere me sa ma wuza. Nyanini shi ya buka?” wadusa wa gu ahu me. ");
INSERT INTO jni_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aye wa dusa utira ume, aye unu tuffsi ume tobi, wa tirzi me muhenu, wa gun me”buka imum me sa idi kem unu rusa utize” ");
INSERT INTO jni_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bitrus sa mazin nigo me nan Yesu upuru nikubu sa ahan Yesu, kure kubura sa ka zin inka tuma ani kubu una katuma kasere ku e ahira ameme. ");
INSERT INTO jni_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma iri Bitrus ma turi unu kunna uraa ma gume hume cangi uzi nigoo me nan Yesu unu Nazaret. ");
INSERT INTO jni_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Magu inda tam imum be sa uzini boo me ba, ma dusa ma suri ma dusa me imum ime. ");
INSERT INTO jni_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ure ucca makuri sa ma ira me, makuri ma buki anu sa wa ciki nigoo me magu, unu ugeme unani goo nimeme nini. ");
INSERT INTO jni_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Magu mada zo me nigoo me nan me ba. Ara anyimo anime anu age sawa turi abini me wagun ti rusa uzi nigoo nan me barki hu ma unu Galili mani. ");
INSERT INTO jni_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba ma wu nice nimeme a nyimo usiziki me, ma tunguno itono unu gusa inda rusam unu uge me sa izi tize ani ce nimeme ba. ");
INSERT INTO jni_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Abine ani bigoro bi runo ukure. Bitrus maringi tize sa Yesu ma buki me madi bezi uzatu urusa umeme inki bigoro ba runo kare. Ma kuri ani kira inna so. ");
INSERT INTO jni_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ani sisizo unu udandang uka tuma wa gurna ahira nigora nan a nanu nan anu nyiti nan nigura, wa tirzizi Yesu wa suru in me, wa ziki me wa nya Bilatus. ");
INSERT INTO jni_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus ma iki me, hamani oigome wa Yahudawa/ ma karbirka me, magu wa buka. ");
INSERT INTO jni_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Anu adadandang unyitike wa nan in bi bukum gwardang ");
INSERT INTO jni_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatus ma kuri ma iki me, ma gun me, ida kuri iboki iri mumba? ira bi bukum me sa ahaza ni anice nuwe me. ");
INSERT INTO jni_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu da ma kuru ma buki ire imum ba, Bilatus ma diri imumu ubuka. ");
INSERT INTO jni_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Anyimo atiye ti uru usana, ma meme madi sapi we niteru ni inde, vat uge sa iko. ");
INSERT INTO jni_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Uru marani agusa me Barnaba, ma tiri ma inde sa wa hirziza muruba, anu wani sa wa huzi anabu anyimo uhirziza umuruba me. ");
INSERT INTO jni_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ni ori na nabu, ni ha ahira ameme wa ka rizizo me adizi ma gunkune we kasi utanda umeme. ");
INSERT INTO jni_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus makabirkawemmagu, inarani in sopi, shi ogomo wa yaduwa me? ");
INSERT INTO jni_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ma rusa izin iniriba i bit nan anu adadandang u nyetikeme sa wa nya Yesu. ");
INSERT INTO jni_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","In ka ta nya ace ti di cukunu ni gome, a hira imumu iriri i Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatus ma kabirka we ma kuru magu nyanini idi wuzi ana me. nan Ugomo wa Yahudawa? ");
INSERT INTO jni_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wa yeze a nyira magu, ga kirka ni me. ");
INSERT INTO jni_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatus ma gu we, nyanini ma wu za? wa aje unu kabarsa ume, ga kirka nime. ");
INSERT INTO jni_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus ma nuari uwuza anabu imumu iriri, ma cekewe Barabas, uganiya sa ma mari ucubo Yesu, ma gu zikani i aka baka me utiti unu rere. ");
INSERT INTO jni_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anu uhira uni pin wa ziki me uhana anyimo udange unu dan anipin, wadi titi ni nanu uhira unu pin me. ");
INSERT INTO jni_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Waduku tiezizi me, upori uvu, waduku barki anice me. ");
INSERT INTO jni_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Waduku tunguno visisu ume, wa gunme, Asere akinkiwe ti gomoni, Ugomo wa Yahudawa. ");
INSERT INTO jni_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Waduku dingi vubo ume anice, wa tufizizime tobe, waduku tungunu agi wa zunu nya za ume ti Ugomo. ");
INSERT INTO jni_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sa wa mara uzuza ume biranza, waduku sopi upori uvume, waduku suki me ti runga tumeme, wa surin me, amatara uhen uku baka ume utiti uni rere. ");
INSERT INTO jni_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Uye ma e u aka, niza numeme saminu unanu bakura, acu a Istifanus nan Rufas,! a suru ani guro, wa dusa wa busurka me ahi ma ziki utiti uni rere ni Yesu. ");
INSERT INTO jni_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wa han in Yesu a ara ahira agusa ani ugolgota, a hira sa a iso nice ni. ");
INSERT INTO jni_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Waduku nyame ubere agi ma si, ma game usa me. ");
INSERT INTO jni_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Waduku gakimga tume me wa hari acece awa me, wa wuzi matara aceve awame, wa iri imum besa wadi kenzi. ");
INSERT INTO jni_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Azumo ukirau udira inde ini sisizo, waduku garkirka me utiti uni rere me. ");
INSERT INTO jni_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wa nyetike ihori Asesere utiti uni rere me, wa buki imumu izezen ba ma wuzipa, agi me Ugomo wa Yahudawa. ");
INSERT INTO jni_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sa wa gakirka me utiti uni rere me, ana wa re wazi na me, unu inde atari ti na re, unu indw a tari tina agure tumeme. ");
INSERT INTO jni_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Uganiya uni umyica utize me sa ma buki, a basa ini a nyimo anu wuza uti mumum tizezen. ");
INSERT INTO jni_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anu agiza una wa dingi unoo ume tize rizezen, wa haki wa zuri ace, wa gusi, u sa udi u kuri uberla uni anyimo atiye ti tarua. ");
INSERT INTO jni_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tuno Asesere utiti uni rere, ubenki nice nuwe me. ");
INSERT INTO jni_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ane ani anadandandanh nan anu nyetike utize ta Asere, wa dingi u zunza ume, acece aweme, wa gusi, ma bursa aye, sizikime ubura unice numeme. ");
INSERT INTO jni_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Unu bursa anu age, Ugomo u Yahudawa ca ma tuu utiti uni rere nigeme a ana me, ti iri haru yi kabi tize ta Asere, a desa agarki kawe nan me we cangi ma zunzi me. ");
INSERT INTO jni_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Unu wui ace, maree ma impi nipin vat, uhana azumi ataru uwinjoro. ");
INSERT INTO jni_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uhana azumo atari Yesu ma hirza ni myiran Asesere magu, Eloi, Eloi Lama Sabatani? agi Asere, Asere nyanini yawuna wa ga mi? ");
INSERT INTO jni_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aye wa turi, sa wa kuna ani me, wq gu, ya kuna mazinu tisa Uliya. ");
INSERT INTO jni_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uye a nyimo awe, ma sumi maka rumzo nire uni tira in mei ma gwarara, ma tumi ani titi, ma witi Asesere age ma shimbiko, maduku gusi ca tiri nani iliya madi eh ma tuzo me. ");
INSERT INTO jni_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ma hirza ni myira Asesere uganiya uduku myinca. ");
INSERT INTO jni_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Atira anyimo udenge Asere awata tihira kare, uzika Asesere utuno adizi. ");
INSERT INTO jni_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Uganiya sa vanu uruma uni kara, ma turu mazinu hira u Yesu, ma iri ani me, ma gu, kadura kani unu geme vana Asere mani. ");
INSERT INTO jni_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ara ne, wa turu piit wa hiri anyimo, aweme, maryamu magada liya, nan maryamu a ino a Yakubu unu niza ni Yusufu nan Solome. ");
INSERT INTO jni_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wa wani a de sa wa tarsi me u ganiya sa mara u Galili wa zin unu wuza ume katuma, nan ane gwardan sa wa igizome Urushalima. ");
INSERT INTO jni_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Uru winjoro, uwui u bara adudu ani, barki nisizo uwui asabar ani. ");
INSERT INTO jni_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yesufu ma eh, unu watu Arimatiya, urunu uka tuma kanipin udadandang, unu nyarga u aye u tize ta Asere, ma wu iriba ihu, ma ribe ahira a Bilatus, ma gu a nyame ikizi Yesu. ");
INSERT INTO jni_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus ma basa iriba magu na ma wuu anime, ma titi unu uginome, ma iki me, nani Yesu madodankunu unu wano. ");
INSERT INTO jni_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sa ma kuna ani ahira unu dadandang ugino me, ma nya Yusufu ikizi me. Yusufu ma kpe malti, sa ma tuzo iki me nani Yesu madodankunu unu wano. ");
INSERT INTO jni_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sa ma kuna ani ahira unu dandang ugino me, ma nya Yusufu ikizi me. Yusufu ma kpe u malti, sa ma tuzo ikizi i Yesu me, ma tirzizi ini umaltime, ma ka suki ini i cau sa a hingir ko nipome acume. ");
INSERT INTO jni_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu Magadaliya nan Maryamu a ino a Yusufu wa iri ahira me sa awuna meni. ");
INSERT INTO jni_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sa uwui kapata wa aki, madakin nan maremu a ino yakubu wan salomi, wa kpi ti runga ti unya urunta barki waka wuna ikizi Yesu ayimo icau me ");
INSERT INTO jni_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","wa hiri inisisizo uwui uladi uwui utu ba wa ha ahira sa avati Yeso ni uganiya usuro uwui. ");
INSERT INTO jni_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wa gamari acece awa me aveni madi hingirkon duru nipo sa atara icau me? ");
INSERT INTO jni_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","sa wa gunkuno, wairi uye mamu hin-girko nipo me barki mazi nidandan. ");
INSERT INTO jni_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wa ribe ayimo icau me wa iri uye ma turi ayimo me in te runga ti rum, maciki tari tina re, wa kuna biyau iriba iweme, ");
INSERT INTO jni_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ma gun we,”kati ikunna iyau ba,”ya ira Yesu una unazaret, de sa a vati me abame. ma hiri, ma zoni abama. irani ahira me sa a nati ");
INSERT INTO jni_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7",". dusani, ika bukani anu tarsa umeme nan bitrus ma ra ajeshime uhana ugalili. abi ne ani idi iri meni kasi sa ma buki shi,” ");
INSERT INTO jni_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wa suri unu sum, wa bilozo nan uganara utize. vat uwe wa myinca in bi yau. ");
INSERT INTO jni_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nisisizo uwui utuba ayinmo tiye sunare, natubi aye ahira ");
INSERT INTO jni_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","maremu madakin, de sa ma sussume agwergenen usunare. marenu ma ha maka buka adesa mazina na we a hira aso atiyon. ");
INSERT INTO jni_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","sa wa kunna agi ma hira maremu ma ira me, da wa hem ba. ");
INSERT INTO jni_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma e makem ana wa re ayimo aweme sa wa hazi suro a yimo ani pin me. ");
INSERT INTO jni_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wa ha waka buka nihenu, ni henu cangi da wa hem ba. ");
INSERT INTO jni_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A dodonkino Yeso ma kem anj kirau unu inde, wa kete acece, ma bezi we bezi we uzatu uya iriba i weme nan ni mumme saikartiziwe uhem in me. barki sa da wa him nan adesa wa irame, sa mahiri ahira iwono imeme. ");
INSERT INTO jni_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ma gun we,” lana ni ayimo une i boo ni henu vat. ");
INSERT INTO jni_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","de sa mahem azoro me madi venke, de sa magame madi ribe ijassi . ");
INSERT INTO jni_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","An desa wa hem tidi zi nigome. ayimo ni za num wadi suzzo agwerge. wadi boo ni lem ni soo. ");
INSERT INTO jni_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","wadi mesi iwa in tari, in wa sa iri mum iti kono i da huna we ba, wadi tarsa ana ti koni tari barki wa humza ");
INSERT INTO jni_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sa ma mari tize wan we adusa aziki me u hana aseseri maka cukuno atari tine reta asere. ");
INSERT INTO jni_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","anu tarsa umeme wa dingi ubo abanga me vataba, ogomo asere ma tarsin in we unu wuza i mumu obasa utize. ");
INSERT INTO jni_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anu gbardang waa wuzi u inko iriba u nyettke u timum sa taa myinca anyimo aru. ");
INSERT INTO jni_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kasi anime sa wa nyan duru, an deba sa wa tari ajeni, we ana kadura wani. ");
INSERT INTO jni_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Barki anime ani mi ma, sa ma gunguzuno memerum timum ti riri ti tuba sa mi ma nyettiki i inde hu unu udandang Tiyofilos. ");
INSERT INTO jni_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bati irusi kadere ki mum besa abezizi shi. ");
INSERT INTO jni_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Anyimo a tiye ti Hiridus, Ugomo wa Yahudawa, ure una katuma ka Asere ma rani niza ni meme zakariya, masuri u watu u Abija. Une umeme ma suri anikura ni Haruna mani, niza ni meme naa zi Alisabatu. ");
INSERT INTO jni_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vat uwe ana biyyau bi Ugomo Asere wani, anu tarsa u inso u tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ani me waa zin vana ba, barki sa Alisabatu ma kem uyoo ba vat uwe waa mu una. ");
INSERT INTO jni_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yaa cukuno sa Zakariya ma raa ahira Asere ma zinu cira ukatuma ka kadura kage sa a nya me. ");
INSERT INTO jni_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kasi sa aka zauka debe sa madi hang kadura me, aka zauka a nyimo zauka barki katuma ku Ugomo Asere barki upunsa umucungo. ");
INSERT INTO jni_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Vat ni ori na nabu wadi wuzi biringara amatara ingi azin nu punsa umucungo. ");
INSERT INTO jni_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aname Bibe bi kadura ka Asere ba eh me bi tonno a tari ti nare ta hira u agadi ahira upunsa u wito unice. ");
INSERT INTO jni_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sa Zakariya ma iri me ma wu zabot biyau bi meki me. ");
INSERT INTO jni_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ani me bibe bi kadura ka Asere bi gun me, “Kati u kunna biyau ba, Zakariya, barki a kunna biringara bi we me. une uwe me madi yoo vana adi nya me niza Yuhana. ");
INSERT INTO jni_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Udi kunna mang nan shew, anu gbardang wadi kunna urunta uyoo umeme. ");
INSERT INTO jni_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Madi cukuno unu udangdang a hira Asere madi da sa me ubere ba, nani bire bi sizasiza bini kara ba, madi myinca in bi be usuro apuru a inome. ");
INSERT INTO jni_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Adi kurzo a Isarailawa gbardang a hira Ugomo uwe me Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Madi haki in mu henu mubi be nan nikara ni Iliya. Madi wuzi anime bati ma gamirka muriba manka coo ahira ahana, bati anu zatu kunna utize wadi haaki unu sa abarka anu Ugomo Asere mani. ");
INSERT INTO jni_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya magun bibe bikadura ka Asere, “Indi wu aneni in rusi ani me? mi be ucokoro, une um uwari.” ");
INSERT INTO jni_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bibe bi kadura ka Asere, bi kabirka bi gun me, “Mi mani Jibirailu, debe sa ma tunzino aje Asere. A tumum in buki we, tize turunta. ");
INSERT INTO jni_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ira, udi cukuno ubabana udda boo tize ba, se rono be sa timum tigeme tidi myinca. Ane ani barki daki ya hem in tize tum ba, sa tidi myinca anyimo uganiya uhuma.” ");
INSERT INTO jni_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Uganiya anu waa zin nu be u Zakariya. waa innu simira sa ma ziki uganiya gbardang a nyimo udenge Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sa ma suri, dama kem ache u boo utize nan we ba. Wa rusi ma iri imum a tiroo sa ma rani a nyimo udenge Asere. Maa wuzi kasi ubabana sarki tize. ");
INSERT INTO jni_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sa tiye ti katuma kame me ka aki, ma dusa akura ameme. ");
INSERT INTO jni_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Usuro atiye ti geme, une umeme Alisabatu ma wu apuru tipeu cibi ma ciki nihunzi me. Magu, ");
INSERT INTO jni_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Imum be sa Asere ma wuzum bati ma karum mu'i aje anabu. ");
INSERT INTO jni_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anyimo upeu utasi, Asere maa tumi bibe bika kadura ka Asere Jibirailu anipin nu Galili sa agusan u Nazaret. ");
INSERT INTO jni_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ahira aku bura ku mare manyani niza me Isubu uni nikura ni Dauda mani, niza niku bura me Maryamu. ");
INSERT INTO jni_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma eh magun kubura me, “Ni isi, hu sa wa kem ukaba Asere mazi nan hu.” ");
INSERT INTO jni_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anime, ubasa u kubura me uhun ne me barki agburang magu “niyaya ni isi nazige me.” ");
INSERT INTO jni_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bibeu bi kadura ka Asere bi gu, “Kati ukunna biyau ba, Maryamu, hu wa kem uhem ahira Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ira, udi wu apuru u yoo vana udi nya me niza 'Yeso'. ");
INSERT INTO jni_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Madi wu niza adi tisa me vana ugomo udadang. Ugomo Asere madi nya me ukpanku wa acoo me Dauda. ");
INSERT INTO jni_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Madi wuzi tigomo akura a Yakubu sarki umarsa, tigomo ti manyanga ma meme tida mara ba.” ");
INSERT INTO jni_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu magun bibeu bi kadura ka Asere me, “Adi wu aneni imum igeme iwu, mi sa inda tam vana uruma ba?” ");
INSERT INTO jni_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bibeu bi kadura ka Asere bi kabirka bi gun me, “Bibeu biriri bi di eh we in nikara nu Ugomo Asere. Ane ani unu ulau sa udi yoo me adi tisa me vana Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ira, uhenu uweme Alisabatu ma wuna apuru anyimo a tiwari, upeu utasi wa zigeme in na apuru sa a tisa me unu wabi. ");
INSERT INTO jni_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rusa ire imum ida tekime nikara na Asere ba.” ");
INSERT INTO jni_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyamu magu, “Ira mi une ukatuma ka Asere kani. Ca kadura ka weme ka cukuno anime.” Anime Bibeu bi kadura ka Asere bi dusa. ");
INSERT INTO jni_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mariyamu ma hiri dibe dibe ati ye tigino me ma ha anyimo ani pana ni nipin nu Yahudiya. ");
INSERT INTO jni_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma dusa akura a Zakariya maka iso Alisabatu. ");
INSERT INTO jni_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sa Alisabatu ma kunna ni isi ni Maryamu, vana umeme anyimo apuru ma hinna, anime Alisabatu ma myinca in bibeu bi lau. ");
INSERT INTO jni_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma yeze ni myirang ni meme in nikara magu, “Hu unu imum iriri ini anyimo aneh, imum iriri ini a zo iburu ini ba apuru aweme. ");
INSERT INTO jni_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyanini ya kem sa a'ino Asere am ma aye ahira am? ");
INSERT INTO jni_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ira, uganiya sa ni isi niwe me na ribem a titui, vana apuru amme ma hinna inni riba irum. ");
INSERT INTO jni_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Imumu ihuma ini me sa ma hem agi timum sa abuki me ta suri ahira Asere.” ");
INSERT INTO jni_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyamu magu, “Iriba im nonziko Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bibeu bum ba kunna mang inna Asere unu bura um. ");
INSERT INTO jni_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Barki anime ma ira usiziki me urere u'eh. Barki uhira ana me uhana uka biki ure ucara wadi nonzo Asere. ");
INSERT INTO jni_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Barki anime meme ugomo udangdang sa ma wuzam anyimo aniza nu meme ni lau. ");
INSERT INTO jni_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ubenki umeme uda marsa me ba uzika ucara u hana ucara sa wa nonzo me. ");
INSERT INTO jni_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ma bezi nikara in tari tume, ma samirka ande sa wazin nu wetere unu basa umuriba muwe me. ");
INSERT INTO jni_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Maa tuzo ahana atigomo a makpanku mawe me maduku yaze ande sa wa sizikiwe. ");
INSERT INTO jni_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Maa rin ina nu mukomo inti mum tiriri, anu u kem, ma gidi we wa dusan tari ti hura. ");
INSERT INTO jni_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ma benki urere u meme Isaraila, bati ma ringi, ma bezi me iriba ineze. ");
INSERT INTO jni_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(kasi sa maa buki anka coo aru) uhana Ibrahim nan nikura numeme sarki umarsa.” ");
INSERT INTO jni_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyamu ma cukuno nan Alisabatu ti peu ti taru maduku kuri akura ameme. ");
INSERT INTO jni_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aname sa tiye tu yoo uvana u Alisabatu ta wuu ma yoo vana uruma. ");
INSERT INTO jni_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Anu utura ume me nan nanu akura aweme wa kunna agi Asere a bezi me iriba ineze kang, wa kunna mang nan me. ");
INSERT INTO jni_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sa a cukuno anime rono uwitutari wa eh wa gbari vana me, wada nyame niza “Zakariya” usuro acoo me. ");
INSERT INTO jni_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Daki aneba a inome magu, “Manyarum, adi tisame Yuhana” ");
INSERT INTO jni_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wa gunme, “Uye mazoni sa a tisame inni za nigeme anyumo anu henu uweme”. ");
INSERT INTO jni_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","WA wuzi ure ugunguzino niya niza nini acoo ma nyara a nyame. ");
INSERT INTO jni_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Acoo me ma ikiwe imumbe sa madi nyettike nizameni, “Ma nynyettike yuhana” imumme i nyawe biyau vat uwe. ");
INSERT INTO jni_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sa ma poko anyo ameme ni lem me ni dusa derti, ma buu tiza nan ni nonzo na sere. ");
INSERT INTO jni_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Biyau bi meki anume ta dusa piit apana a ma nyanga ma Yahudawa. ");
INSERT INTO jni_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ande sa wa kunna tize tiginome wa inki tini amu riba vat, wagusi, “Nyanini vana ugeme madi cukuno fee?” Barki sa tari ta Asere tizi nanme. ");
INSERT INTO jni_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","“Ni nonzo na Asere, Asere a Isarailawa, barki sa ma aye ubenki nan nuguguzino u bura anabu. ");
INSERT INTO jni_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Asere anu Israila azi gongon, barki ma kem makuri ma nya nice barki anu a meme. ");
INSERT INTO jni_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma yezen duru ni hure nu bura uru a nyumo ani kura ni Dawuda, ");
INSERT INTO jni_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kasi imum be sa ma buki usuru a nyoo una kadurame sa ma rani datti. ");
INSERT INTO jni_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Madi eh duru in nunu bura a tari ta nu nyara u huza uru vat sa da wa hem in haru ba. ");
INSERT INTO jni_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Madi wuzi anime bati ma bezi anka coo uru iruba ineze nan ni mum be sa wa barka ire-re wa inki, ");
INSERT INTO jni_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Imum be sa wamu barka nan Ibrahim a coo uru. ");
INSERT INTO jni_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ma tonikon duru, indabe sa a burin duru a tari tanu nyara uhuza uru, tidi tarsime sarki biyyau, ");
INSERT INTO jni_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ahira a lau, tidi cukunoni tau vat ti yei turu. ");
INSERT INTO jni_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Eh, nan hu, vaname, adi gum me una kadura ka hira a dandang, ane ani udi nani ahira a Asere bati ubarka tina, ukuri ubarka anabu barki u aye umeme, ");
INSERT INTO jni_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ubuki anabu abanga ubenki nan nu visa u sizikime uweme. ");
INSERT INTO jni_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Udi cukunoo anime barki ubenki sa Asere wa wuzin duru usuru uwui ahira ana za ma eh u benki uru, ");
INSERT INTO jni_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ti bezi ma saa ahira ande sa wa ciki ama rew nan nu hurtu iwono. madi wuzi anime bati ma tarsi in tibuna turu u hana ahira ati cukum ti mang”. ");
INSERT INTO jni_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aname sa vaname ma unna ma wu nikara abi beu, ma ciki ani jaa uka biki tiyei to suru umeme anyumo anu a Isaraila. ");
INSERT INTO jni_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ara anyimo atiye me, kaisar Augustas ma buki guna abassa vat anu unce. ");
INSERT INTO jni_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ubassa utuba uganiya sa kiriniyus mā zi ugumna usuriya. ");
INSERT INTO jni_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anime kondevi ma dusa ani pin nuwe me bati aka bassa we. ");
INSERT INTO jni_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isubu ma hiri u Nazarat ani pin nu Baita Lami uhana Yahudiya, aba sa agusan nipin ni Dauda. Barki me bisana bi Dauda bini. ");
INSERT INTO jni_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ma ha nan Maryamu de sa mazin inti nyari tume inna puru bati aka bassa we. ");
INSERT INTO jni_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Uganiya sa wa rani abirko me uganiya me uni madi yoo vana. ");
INSERT INTO jni_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma yoo Uvana, utuba uyoo uvana, ma impi me in mapori ma natti me uhugu, barki sa wa zowe unu denge ba abini me. ");
INSERT INTO jni_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Uwata me aye wa rani ama saa unu bee itam iwee in niye. ");
INSERT INTO jni_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bibe bika dura ka Asere bi ē ahira awe, Ma saa ma Asere maketi we, wa kunna biyan bidandang. ");
INSERT INTO jni_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Abinime bibe bika dura ka Asere be gun we “Kati ikunna biyan ba, ma aye shi inna banga aririn age sa Vat anu wadi kunna urunta udandang. ");
INSERT INTO jni_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ayoo unu bura kānime ani pin ni Dauda, memani Asere Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma saa me mazigenme sa adi nya shi, idi iri vana a impo me imma pori anata me hungu”. ");
INSERT INTO jni_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sārki ucara uganiyan wa iri nigura nanuu nan Bibe bikadura ka Asere unu nonzo Asere innugusa. ");
INSERT INTO jni_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ninonzo na Asere unaza, nan ticukum tihuma acee anu nee nan de sa ma kunna urunta ume”. ");
INSERT INTO jni_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Abiki uganiya me sa Bibe bika dura ka Asere ba dusa anyimo a seseri, ani tam me wa gun nacece “Ca tihaa ubaitalami, tika iri imum igeme sa takunna sa Asere abukan duru”. ");
INSERT INTO jni_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wa haa dibe-dibe waka kem Maryamu nan Isubu wan vana me anata uhungu. ");
INSERT INTO jni_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sa wa ira me, wa buki anu imum me sa abuka we anicee ne vana me. ");
INSERT INTO jni_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vat ande sa wa kunna icukuno Imum ugamara imum me sa anu hira itam me wa buka. ");
INSERT INTO jni_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryamu ma meki ubassa utimum me sa ma kunna, unu gamara me Iruba. ");
INSERT INTO jni_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Anu hira itam me wa kuri. Ininonzo nan ununonzo Asere, barki imum me sa wa kunna, wa ira, ka si ubuka me sa wa kunna. ");
INSERT INTO jni_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sa tiyee uwito-utari ta wuna sa adi gbari me, anya me niza Yeso, niza me sa Bibe bika dura ka Asere ba nyame ada Sārki uzika apuru amè. ");
INSERT INTO jni_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sa tiyee tusuro tawuna kasi u' inko utize ta Asere “Vat utuba uyoo uruma adi witi Asere me”. ");
INSERT INTO jni_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kasi unyertike U' inko utize ta Asere “Vat utuba uyoo uruma adi witi Asere me”. ");
INSERT INTO jni_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wa nya me unyanki kasi u' inko utize ta Asere “Mu hurbe muni muree nan matatabara marce”. ");
INSERT INTO jni_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ure unyu marani ujerusalem niza nume Siman, una biyan ba Asere mani ini ruba ilau. Mazin nunyara ubarka u Isaraila, Bibe ba Asere baazi nan me. ");
INSERT INTO jni_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bibe bilau ba Asere ba bezi me unu guna mada wono ba senke ma ira Asere Yeso. ");
INSERT INTO jni_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Uru wui Bibe bilau ba Asere bihan Siman udenge Asere. An ka coo me wa ēn Yeso vana uneze, kasi utanda nan u'inko utize ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ma gbindirko me abigiri ma nonziko Asere ma gu. ");
INSERT INTO jni_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Aname ca urere uweme madusa inna puru arum Asere, kasi ubuka uweme. ");
INSERT INTO jni_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Barki sa aje am a'era nibussi nuweme, ");
INSERT INTO jni_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sa wa wuza amu hennu manun vat. ");
INSERT INTO jni_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ma saa mani mati roo uhana anuu uzati utarsa Asere nan ninonzo uhana anuu aweme Isarailawa”. ");
INSERT INTO jni_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Acoo avana me nan ka inoo we wa kunna urunta imum me sa mubuka. ");
INSERT INTO jni_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siman ma nonziko we ma gun Maryamu a inoo me “Kunna memmerum Vana ugeme madi cukuno unaa urizo nan uhira wa nun gbardang anyimo Isaraila nan ubezi sa adi nyarime. ");
INSERT INTO jni_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Uvira udi watti iruba iweme bati arusi muruba manu”. ");
INSERT INTO jni_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Unun kurzuzo utize ta Asere ahiran me unani zaa Hanatu. Ucaa ufanuyila nilem ni Ashiru mamu wuna uwari kang. Wa wuu tiwee usunare inna nyaa nan uruma umeme. ");
INSERT INTO jni_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma zi'inti wee a'ino-uwitotari intini tinazi (84 years). Daki maceki udenge Asere ba inka tuma unu canti anyoo nan biringara niyee nan nuwui. ");
INSERT INTO jni_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Uganiya me ma nyene uhana ahira awe unu nonzo Asere, ma buki vat ande sa waazin nubee uburu Urshalima abanga a vana me. ");
INSERT INTO jni_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sa wa mara kondi nyani wa wuzi kasi u inko utize ta Asere, wa kuri Ugalili ani pin nuweme Unazarat. ");
INSERT INTO jni_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Vaname ma uu mawu nikara, nan ukingizi urusa, nan ubenki Asere anicee nume. ");
INSERT INTO jni_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Anka coo me waka haa Ujerusalem ingi niwee na kette barki u'idin Faska. ");
INSERT INTO jni_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sa mawuna tiwe ukirau-tire, Wa kuri kurri uganiya u'idi utanda. ");
INSERT INTO jni_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sa tiyee tu idi ta mara, wa tubi kurso ati kura. Yeso ma dii adumo Ujerusalem Sārki urusan anka coo me. ");
INSERT INTO jni_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wa bassa nan mazi nanni goo nanume sa wa haka nan we, wa hiri tanu. Wa tubi u nyara ume anyimo anu turra uweme nan aronni. ");
INSERT INTO jni_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sa daki wa ira me ba, wa kuri Ujerusalem waka tunguno unyara ume abini me. ");
INSERT INTO jni_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wawu tiyee titaru unu nyara ume wa tinka me udenge Asere, ma ciki atii anu bezizi, unu kunna nan nu'igizo uwe. ");
INSERT INTO jni_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vat andee sa wa kunna me wa meki ugamara urusa nan ukabara umeme. ");
INSERT INTO jni_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sa wa ira me wa meki ugamara me kang. A'inome ma gun me “Vana, nyanini wa wuzan duru aname? Kunna, acoo uweme nan mi tizin nunyara uwe unu curnome Iruba”. ");
INSERT INTO jni_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma gun we, “Barki nyani izin nunyan um? Ita shi izi gbass incukuno akura acou um ba?” ");
INSERT INTO jni_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Daki wa rusa imum sa ma boo ba. ");
INSERT INTO jni_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ma dusa akura nan we Unazarat ma tarsi tize tuweme. A'ino me ma inki Vat timum tigeme Iruba. ");
INSERT INTO jni_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeso ma re'aje unu uzza nan nurusa, ma kuri ma kinki ukem ukaba ahira Asere nan nanuu. ");
INSERT INTO jni_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Anyimo ani we ni kirau inti cibi ati gomo ti Kaisar Agusta, Bilatus Babunti inti gumna tu Yahudiya, Hiridus inti gomo to Galili, Uhenu umeme Filibus inti gomo tu Ituriya nan Tirakonitis, Lisaniyas inti gomo tu Abiliya. ");
INSERT INTO jni_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Uganiya me Hanana nan kayata we wani ana dandang aka tuma ka Asere, tize ta Asere ti ē Yohanna usam uzakariya anyimo ani jaa. ");
INSERT INTO jni_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma haki vat ati hihira sa ta kete uraba urdu, unu bezizi utize ta Asere nan ubaptisma ubarka barki uvette ucaran. ");
INSERT INTO jni_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kasi uyerte utize ti Ishaya unu kurzuzo utize ta Asere, “Ni Myiran unu tissa ani Jaa, 'Barkani unaa Asere, Barkani tinaa tumeme dret. ");
INSERT INTO jni_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kondi uya ugbangbang undi myinca, nan kondi niya nihoho nan nipana nidi tuu, nan ti naa ti mammangaran adi witti tini adi myinciza tinaa me sa tizin inti waa. ");
INSERT INTO jni_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vat anuu wadi iri ubura wa Asere”. ");
INSERT INTO jni_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana ma gun nigura nanuu me sa wa aye bati ma wuzi we ubaptisma “Shi ahana iwaa iti kono aveni magunan shi Isumi ucurnome iruba me sa I'eze? ");
INSERT INTO jni_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nyani ahana sa wazin in niruba ubarka, kati itubi ugusa “Tizin Ibrahim acoo uru, barki sa in boo shi Asere Madake ma kurzo apoo ageme ahana Ibrahim. ");
INSERT INTO jni_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ana me amu wuna bitem atini ama titi barki anime vat utiti me sa wa game uyoo ahana wa ririn adi yori uni avetten anyimo uraa”. ");
INSERT INTO jni_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nigura me niriaje unu igizo ume unu gusa “Nyanini tidi wuzi?” ");
INSERT INTO jni_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma kabirka ma gun we “De sa mazin tidibi tini tiree ma nya de sa ma zomen ba u'inde, de sa mazin ini mumyarce ma wuzi anime cangi. ");
INSERT INTO jni_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Anu kabsa Ikirfi imanyanga wa ē ma wuzi baptisma wa gun me “Unuu ubezizi, nyanini tidi wuzi?” ");
INSERT INTO jni_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma gun we “Kati ikabi ikirfi me sa iteki ige sa agunan shi ikabi ba”. ");
INSERT INTO jni_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anani kara nini kono wa iki me, wa gu, “A haru naa? Ma gun we, “Kati iburri uye ikirfi innikara ba, nan i canni uye upilko sa ma taame ba Tonnoni ikirfi uppe ushi me”. ");
INSERT INTO jni_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sa anuu waa zin nucanta uguna Yeso ma ē, konderi mameki ugamara me iruba anicee ni Yohana, nan memani Yeso. ");
INSERT INTO jni_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana makabirka ma gun Vat uwe “Me inzi shi unu baptisma inmei uye ma eze sa ma teki nikara num, ma bari in soppi tizin ta kpattak ameme ba. Madi wuzi shi ubaptisma in Bibe ba Asere bilau nan uraa. ");
INSERT INTO jni_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Upija utana wa alkana umeme uraa atari bati ma ori ma wuu ati kere tume Madi punsi mucini me unu raa sa uda bito ba”. ");
INSERT INTO jni_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Unu gbara kang, Yohana ma bezizi anuu abanga urunta. ");
INSERT INTO jni_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana ma gbarika ugomo Hiridus sa ma wuza anya nan unee uhenu me, Hiruduya, nan ukasu uti mum sa Hiridus ma wuza. ");
INSERT INTO jni_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma kurima kinkin ma wuu aka kurso Yohana akura anirere. ");
INSERT INTO jni_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sa awuza anuu ubaptisma awuzi Yeso ubaptisma cangi, sa ma zin biringara Aseseri apokino. ");
INSERT INTO jni_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bibe ba Asere bilau bituu me kasi uhurbe, nimyiran ni Aseseri “Hu vana mani, de sa inkunna me. In kunna urunta ume”. ");
INSERT INTO jni_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeso maa tubi katuma a tiwe akuru ataru. Maa zi vana (kasi basa me) Isubu vana u Lawi ");
INSERT INTO jni_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Vana u Matat, vana a lawi, vana u Malki, vana u Yanna, vana u Isubu, ");
INSERT INTO jni_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Vana Umatatiya, vana u Amos, vana u Nahum, vana Hasli, vana Najjaya ");
INSERT INTO jni_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Vana u Maata, vana u Matatiya, vana u Shumeya, vana a Yuseka, vana u Yoda, ");
INSERT INTO jni_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","vana Yowana, vana u Resa, vana u Zarubabila, vana u Shiyaltiyel, vana u Niri, ");
INSERT INTO jni_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","vana u Malki, vana u Addi, vana u Kosama, vana u Almadama, vana u Er, ");
INSERT INTO jni_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","vana u Yosi, vana u Alyeza, vana u Yorima, vana u Matat, vana u Lawi ");
INSERT INTO jni_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","vana u Saminu, vana u Yahuda, vana u Isubu, vana u Yuhana, vana u Aliyakima, ");
INSERT INTO jni_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","vana u Malaya, vana u Mainana, vana u Matata, vana u Natan, vana u Dauda, ");
INSERT INTO jni_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","vana u Yesse, vana u Obida, vana u Bo'aza, vana u Salmo, vana u Nashon, ");
INSERT INTO jni_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","vana u Amminadab, vana u Adimi, vana u Arama, vana u Hezruna, vana u Feresa, vana u Yahuda, ");
INSERT INTO jni_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","vana u Yakubu, vana u Ishaku, vanu Ibrahim, vanu Tera, vanu Nahor, ");
INSERT INTO jni_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","vanu Serug, vanu Reyu, vanu Feleg, vanu Abiru, vanu Shela, ");
INSERT INTO jni_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","vana u Kainana, vana u Arfakshada, vana u Shem, vana u Nuhu, vana u Lamek, ");
INSERT INTO jni_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","vana u Metusela, vana u Anuhu, vana u Yaret, vana u Mahalel, vana u Kainana, ");
INSERT INTO jni_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","vana u Enosh, vana u Shitu, vana u Adamu, vana Asere. ");
INSERT INTO jni_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeso gbem in Bibe biririn, uze ume usuro uraba urdu. Bibe bitarsin me anijaa. ");
INSERT INTO jni_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sa atiyee akuru aniza unu ubur unu manza ume. Atiyee tigenome daki ma ree imum ba, umassirka ma kunna ikomo. ");
INSERT INTO jni_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Unu ubur ma gun me “Ingi huu vana Asere mani gamirka apoo ageme acukuno imum yaree”. ");
INSERT INTO jni_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeso ma kabirka me, “I Ciki unu nyetike unu mada ciki me barki imum yareeba”. ");
INSERT INTO jni_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Abini me unu ubur ma ziki Yeso ma han me ahira atankaran ma bezi me tigomo tunee vat. ");
INSERT INTO jni_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Unu ubur ma gun me “Indi nyawe vat tigomo nan timum tigeme barki sa anyam, mi inda ke innya de sa ma wunan. ");
INSERT INTO jni_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ingi wa tunguno wa nonzom indi nya we”. ");
INSERT INTO jni_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeso ma kabirka ma gun me “I ciki unu nyertike 'Udi tarsi ugomo Asere nan Asere awe memani udi nonzo me cas”. ");
INSERT INTO jni_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Abinime unu ubur ma ziki Yeso ma hanme Urushalima abi tenteri bu denge Asere ma gun me “Ingi vana Asere mani, hinna adizi. ");
INSERT INTO jni_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iciki unu nyertike madi buki ibe ika dura ka Asere iburu we ");
INSERT INTO jni_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","nan, 'Wadi kpatika we in tari kati u vabbi ubuna anipoo”. ");
INSERT INTO jni_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ukabirka me, Yeso ma gun me “A gu kati umansa ugomo Asere nan Asere awe ba”. ");
INSERT INTO jni_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sa unu ubur me ma mara umanza u Yeso, ma cekime uhana uru ganiya. ");
INSERT INTO jni_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeso ma kuri Ugalili inni kara ni Bibe, abangame a Samirka vat ati kikira ta hirame. ");
INSERT INTO jni_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma tubi ubezizi a udenge unu gura anuu wa nonzo me vat. ");
INSERT INTO jni_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ma ē Unazarat, nipin me sa acanti min ma ribe udenge unu gura unu wui Asabar ma hiri ma tonno ubassa ihori. ");
INSERT INTO jni_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anyame anyimo u nyertike u Ishaya ma poki unyertikeme ma iri ahira me sa a guna, ");
INSERT INTO jni_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bibe ba Asere bira anice num, ma zaukan inbuki anu dira abanga aririn ma tummim inbuki aciki arere, nan inpoki arubo aje, inwu aceki ande sa apatti we, ");
INSERT INTO jni_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","inbuki anu niwee nin bussi na Asere”. ");
INSERT INTO jni_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ma dusa ma impi inyerte me, makurzo una katuma men, Wa nuki me aje. ");
INSERT INTO jni_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma tunguno we tize, “Kani unyertike Asere wa myinca ati tui tishi”. ");
INSERT INTO jni_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vat anuu sa wa rani ahira wa buu mang anice nume, wa kunna urunta utize me sa ta susso anyoo ame, wa iki me “Inzo vana Isubu ma zigeme ba?” ");
INSERT INTO jni_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma gun we “Kadundura inrusa idi bukini me tize anyimo atize tigeme, 'Unuu ninza utika huuman nicee nuwe. Vat imum sa la kunna wa wuzi u kafanahum, wa wuzzi ani pin nuwe cangi”. ");
INSERT INTO jni_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma kuri ma gu “Kadundura ma buka shi, ada kabame unuu kurzo utize ta Asere ani pin nume ba. ");
INSERT INTO jni_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Inboo shi kadurra akoro waa rani Isaraila gbardang uganiya u Iliya, uganiya sa a impi Aseseri tiwee titaru nan tipe utasi Sārk uree, uganiya me sa awuzi ikomo idandang amanyanga mevat. ");
INSERT INTO jni_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Anime daki atuma Iliya ahira a uye uwe ba, Senke ure ukoro sa ma ciki Uzarifat mamu nan nu Sidon. ");
INSERT INTO jni_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Akuturu waa kuri warani gbardang a Isaraila uganiya Elaisha unu Kurzuzo Utize ta Asere, Naaman unanu Suriya mani cas ahumanme. ");
INSERT INTO jni_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Murubu manu sa warani udenge unu gura me mu curno me sa wa kunna tize me. ");
INSERT INTO jni_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wa hiri wa tuburko uwatu uni pin, wa han me ani poo me sa a nukki nipin nuwe men bati wa vinge me adizi. ");
INSERT INTO jni_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma akki atii awe ma haa arahira. ");
INSERT INTO jni_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma tuu uhana kafanahum nire nipin U Galili. Are Asabar unu bezizi anun anyimo udenge unu gura. ");
INSERT INTO jni_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wa gamari ubezizi umeme tak, barki sa tize tumeme tizin unubari. ");
INSERT INTO jni_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Uganiya ure unuu anyimo udenge unu gura me in bibe bizenzen, ma wu uhunu ini myiran hidandang, ");
INSERT INTO jni_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nyanini mei mawe nan haru, Yeso unu Nazarat? Wa aye barki uhunduru? In rusa hu aveni, Ho mani wa Asere ulau”. ");
INSERT INTO jni_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeso ma taarika ugbergene me ma gu “Wuna tik suro anyimo ame”. Sa ugbergene me ma reki unuu me adizi atii awe, ma suri daki ma kunno me iwono ba. ");
INSERT INTO jni_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vat anuu wa meki ugamara me, wa meki uboo me acece. Wa gu “Tiyaya tize tazigino me? Ma busurka bibe bizenzen me unu bari nan nikara, wa suri”. ");
INSERT INTO jni_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Atubi uboo abangame vat atikikira tini pin me. ");
INSERT INTO jni_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeso ma ceki udenge unu gura me ma ribe akura Siman. A'ino unee u Siman maa Zin unukon kang, wa tiri me tari anyo ame. ");
INSERT INTO jni_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma bussarka ukono, uceki me. Abini me ma hiri ma tubi we katuma. ");
INSERT INTO jni_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Unu wunjoro, unuu wa ē Yeso inna nuu ati kon sassas. Matari we tari wa huuma. ");
INSERT INTO jni_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Abgergene wa suri anyimo awe gbardang, inti soo unu gusa “Huu vana Asere mani” Yeso matarika agbergene me ma karti we tize, barki wa rusa me Asere ani. ");
INSERT INTO jni_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sa ahira asana, ma nyari ahira ma kuri anikira. Nigura na nuu unu nyara ume bati wa haa ahira me sa ma rani. Wa nyari inko ume kati madusa. ");
INSERT INTO jni_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma gun we “Ya cukunom gbas inka boo abanga urunta uti Gomo ta Asere ati pinpin Sassas, barki anime ani atumum abame. ");
INSERT INTO jni_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma ree aje unu boo utize ta Asere anyimo ati denge tini gura vat upash Yahudiya. ");
INSERT INTO jni_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ya cukuno uganiya sa anu wa orno ahira Yeso unu kunna utize ta Asere, ma turi anikira nini win nu Janisarata. ");
INSERT INTO jni_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Manno ma iri ma Jirigi ma mei mana ma re ma turi anikira nini win me. Anu mesi icere wa suro Ujirigime wazinu kpijo imumu imisi icere. ");
INSERT INTO jni_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeso mano ma ribe a ure Ujirigi me uge sa uzi u Simon, manno magu in Simon ma seserke inu jirigi me ahira ani win me cin uhana anyimo mei. Manno ma cukuno mazinu bezizi anu anyimo ujirigi me. ");
INSERT INTO jni_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sa ma mara tize me, ma gun i Simon, “Seserke unu Jirigi me uhana ahira a concong uduku reki imumu imisi icere me bati umesi”. ");
INSERT INTO jni_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon ma kabirka magu, “Ugomo Asere, ta wuzi katu ini yeh da ta meki iri imum ba, barki tize tuwe me indi reki imumu mesi icere me”. ");
INSERT INTO jni_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sa wa wuna ani me, wa meki icere gbardang, ani imumu mesi icere ya Janika. Wanne wa nyari aroni akatuma ku Jirigi ukure me wa eh wa benku we. ");
INSERT INTO jni_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wanno wa eh wa myinca ma Jirigi mana ma re unicere, wanno wa tubi upirsa anyimo a mei. ");
INSERT INTO jni_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon, sa ma ira anime, ma dungunu aje a Yeso, magusi, “Cekum ugomo Asere, mi unu madini mani.” ");
INSERT INTO jni_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Barki sa ma wuzi ma aye, nan andesa wazi nan me, barki ugbardang icere sa wa meki. ");
INSERT INTO jni_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Agino a pata nan Yakubu nan Yahaya ahana azabadi aroni akatuma ka Simon. Yeso ma gu in Simon, “Kati u kunna biyau ba, barki ana me, udi mesi amabu wani”. ");
INSERT INTO jni_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sa wa aye unu Jirigi uwe me amatara ma dizi, we ceke timum me wa tungunu utarsa ume. ");
INSERT INTO jni_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uganiya sa ma ra ani pin nu kure me, ure unu u koni umakin karu. Sa ma ira Yesu, Marizi aje a Yesu ma tungunu ugusa, “Ugomo Asere inka wa hem uda ke u human me”. ");
INSERT INTO jni_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sa Yeso ma wito tari ma dara me, magu, ida ki. “Ma hem idi human huu. Manno madusa mahuma”. ");
INSERT INTO jni_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Manno magu me kati ma buki uye ba, manno magu me, “Dusa uka buka unu ukatuma ka Asere, kasi sa Musa mabezi imumu ihuma ahira awe me”. ");
INSERT INTO jni_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tize tinno ta dus pitii, anu gbardang wa ey ahira ameme bati wa kem uhumza ahira ameme. ");
INSERT INTO jni_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Manno ma hunguko nipum uhana ahira sa anu wa zoni ma wu biringara ");
INSERT INTO jni_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ya cukuno imumu inde anyimo atiye tu bezizi utize anu bezi urusa nananu dungara ande sa wa kete nipin nanu ujuda, nan Urushalima. Nikara na Asere ni zi nan we barki uhumza anabu. ");
INSERT INTO jni_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Uganiya ugino are anu wa eh, nan ure unu sa ma wono anikira ni inde anati u penge, wa nyari una uge besa wadi ribe in me anyimo wa natime aje a Yeso. ");
INSERT INTO jni_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Da wa kem una sa wadi ribe in me ba barki ni ori na nu. Wanno wa nyene Asesere undenge me wa duku tuzo Asesere urufi wa nati me upenge a tii anu aje ayeso. ");
INSERT INTO jni_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sa ma ira u inko iriba iweme, Yeso magu, “Una kura akpico madini ma we me”. ");
INSERT INTO jni_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anu nyetike nan anu bizi urusa wa tubi u igizo agino, “Aveni nan ka veni wa wuza imumu ibur? Aveni madake ma kpici madini, inka azo asere ba?” ");
INSERT INTO jni_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sa Yeso ma rusa imum besa wazin inu gamara me, ma kabirka magu, “nyanini ya wuna izini JOHKO Utigino me ariba mu shi me? ");
INSERT INTO jni_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A ya ani ateki unu shew ahira ashime, “Akpico madini ma we nani ashime, “Akpico madini ma we nani agu hu hira haka?' ");
INSERT INTO jni_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Barki urusi unu guna vana unubu madake ma kpici madini mu unee, ma gunan hu, “Hira uziki upenge uwe u dusa akura awe me”. ");
INSERT INTO jni_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahira me ma hiri aje aweme maziki upenge sa ma rari ni, ma dusa uhana akura unu nonzo Asere. ");
INSERT INTO jni_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Konde vi mazinu basa me nanu nonze Asere. Unu kuna ubi yau inu gusa, “Kani ta ira imumu ibiyau”. ");
INSERT INTO jni_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uganiya u aka imumu igino me, Yeso masuri ma iri unu kabisa ugandu nizame Lawi ma ciki ahira ukapisa ugandu. Ma gun me, “Tarisami”. ");
INSERT INTO jni_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi manno ma hiri ma tarsi me, mano ma ceki kondi nyani ma tarsi me. ");
INSERT INTO jni_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi manno ma siri imimare gbardang akura ameme barki Yeso, Anu kabisa ugandu wa ciki upenge ina re imimare ingome nan we. ");
INSERT INTO jni_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Abini me anu bezi utize nan anu unyite utize wa tubi u i gizo ahana akatuma kameme, unu gusa, “Nyanini ya wuna izin na re nan nanu kabisa ugandu nan na nu amadini?” Yeso ");
INSERT INTO jni_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ma kabirka magu, “Anu zatu koni wada nyara we uni nyiza utika ba, ana tikoni we wani wa nyara unu nyiza uti ka. ");
INSERT INTO jni_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Da ma aye barki in tisa ana alau ba, ma aye unyara ana madini wa kabi tize ta Asere”. ");
INSERT INTO jni_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wa gun me, “Ahana Yahaya wadi uzi ni hiri sarki are wa wuzi biringara, ahana anu bezi utize wadi wuzi ani me. Ahana awe me wadi ri wa si”. ");
INSERT INTO jni_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeso mangun we, “Uye marani sa mada ma wuna aroni una anya wa hiri sarki are imimare uganiya una nya mazin na we? ");
INSERT INTO jni_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Uwui me u eze sa adi ziki una anya me ahira awe me abine ani wadi hiri sarki are imimare. ");
INSERT INTO jni_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeso manno makuri ma buki we u inko ugino me. “Azo de sa madi janika tirunga tiso ma duzi ti kuzi niba, in ka ma wuza anime, ti runga ti so me tida wuna uri nan ti kuzu me ba. ");
INSERT INTO jni_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Azo desa madi ziki uwongo iso ma wu anyimo idaka ikuzu. Inka ma wuza ani me, uwangu uso me udi pusi ida me, uwango me udi kwanko, idaka me idi corno me. ");
INSERT INTO jni_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Barki ani me uwangu uso adi wu uni anyimo amu daka mu so. ");
INSERT INTO jni_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Azo desa madi nyari uwongo igino me, uganiya sa ma sa ukuzu me, madi gu ukuzu me uteki u so me”. ");
INSERT INTO jni_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","In ure uwui asabar Yeso ma ra anyimo uru ubisana ahana katuma kameme wa zinu pusa uma gbangu ma bi sana me, wazunu para me atari tuwe me unu siza ma. ");
INSERT INTO jni_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aye anyimo anu bezi utize wagh, “barki nyanini ya wuna iwuza anime unu wui sa da aguna awuzi ane ba?” ");
INSERT INTO jni_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeso ma kabirka we magu, da ya basa imum besa Dauda ma wuzi uganiya sa ma kunna ikomo ba, me nan ananu sa ma zi nigome nan we ba? ");
INSERT INTO jni_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ma ribi anyimo kura Asere, maziki imumare ya kura Asere mari ma kuri ma nya ahana aruma sa wa zi nan me, ya zi anime anu dungara utize wani wadi ri. ");
INSERT INTO jni_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma gu we, “vana unubu me mani ugomo Asere asabar me” ");
INSERT INTO jni_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ya cukuno u uru uwui asabar maribe anyimo udenge Asere. Uye mara ahira sa tari tina re tume ta wii. ");
INSERT INTO jni_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anu nyiteke nan nanu bezi tize wa inki aje nani madi humam me unu uwui asabar me, barki wa kem imumu boo ume unu wuza imum besa da ya wuna ba. ");
INSERT INTO jni_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Barki anime marusa imum besa ma basa manno ma kuri magu inu nu zatu utari me, “hira tonno abanna me atii anabu” unu me manno ma hiri ma tonno. ");
INSERT INTO jni_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeso ma gun we, “In zinu igizo ushi, da ya wuna uri awuzi imumu iriri nan ihuma, aburi unu nani aceki me ma wi?” ");
INSERT INTO jni_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Manno ma hiru we vat ma gun unu nu me, “Wito tari tuwe me” ma wuzi ani me tari tume me ti huma. ");
INSERT INTO jni_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wanno wa kunna iriba kan, wa kuri wa titi ace wa gamira tize imum be sa wadi wuzi in Yeso. ");
INSERT INTO jni_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Acukuno atiye tigino me, sa ma nyene asesere anipo ma wuzi biringara. Ma ri aje iniye nigino me inu wuza ubiringa ahira Asere. ");
INSERT INTO jni_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Inisi sizo, matiti ahana utarsa umeme, wa eh ahira ameme, ma zauka anu kirau ina nawa re, ande sa matiti we “anu kurzizo, utize ta Asere”. ");
INSERT INTO jni_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tiza ta hana ameme simon (desa ma gusa me Bitrus) nan uhenu ume me Andrawus, Yakubu, Yahaya, Philibus, Bartalamawu, ");
INSERT INTO jni_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Toma, Yakubu Vana u Halfa, Simon desa agusa Zaloti, Yahuda vana u Yakubu. ");
INSERT INTO jni_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nan Yahuda vana uiskariyoti, desa ma cukuno unu re inama Yeso. ");
INSERT INTO jni_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa Yeso ma tunno usuru anipo nan we, wanno wa tonno amassa ahana katuma kame gbardang wa ra ahira me, nan anu gbardang usuru uyahudiya nan urushalima nan ageno usuro utaya nan usidon. ");
INSERT INTO jni_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wa eh barki wa kunna me, wa kuru wa kem uhumuza uti koni tu weme. Ande sa wa zin inti koni dati wa kem uhumuza. ");
INSERT INTO jni_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Konda avi anyimo ani orime ma nyari udara ume barki ubezi uhuma ura ahira ameme ani, ma kuri ma humuza we vat. ");
INSERT INTO jni_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Manno ma hiri ahana akatuma kame me magu, “Anu kem imumu iriri shi anu dira, barki anime akura Asere ashe ani. ");
INSERT INTO jni_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Shi anu imumu iriri shi anu ikomo aname, barki ti inshi. She anu imumu iriri ana so ana me, barki idi zunzi. ");
INSERT INTO jni_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Shi anu imumu iriri ini inka anabu wa ga shi, wa bezi shi usasas wa guna tiza tishi me anu imumu iriba, bari vana unubu. ");
INSERT INTO jni_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Idi zunzi ronigino me, barki idi kem imumu iriri anyimo Asesere, barki anime a cokoro acokoro anka coo uwe me wa wuzi ana kadura. ");
INSERT INTO jni_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ude ushi anu kem barki sa ya kem tiyom tishi me. ");
INSERT INTO jni_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ude ushi anu itii, barki idi kunna ikomo uhana aje, ude ushi anu atizunza ya de ni idi shizi uhana aje, shi ana tizunza idi wuzi tiyom nan naso uhana aje. ");
INSERT INTO jni_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ude ushi inka anabu wa nonzo shi barki ane ani acokoro acokoro an ka coo uwe me wazi anu bezi rusa moco. ");
INSERT INTO jni_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Barki anime ingusa shi anu kunna um, hem ni inde sa ma ga shi ikuri iwuzi anu ga shi imumu iriri. ");
INSERT INTO jni_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Buka ni anu ati zumza tishi tize tiriri, in kuri iwuzi andesa wa wuzi shi bi ringara. ");
INSERT INTO jni_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","De sa ma vavi we upo uginne, gamira ukure me, inka uye mazi ugudu uwe me, kati ukartime udibi uwe me ba. ");
INSERT INTO jni_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nyizani ande sa wa nyara imum ahira ashi. Inka uye ma zika ire imum sa izi ishi me, kati igu ma kurzo inini ba. ");
INSERT INTO jni_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Vat imum be sa unyara anu wa wuzi weni, waza anime cangi. ");
INSERT INTO jni_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","In wa hem unu nu hem uwe mani cas, nyanini igino me wa wuza? ko ana madini wa hem ina nu hem uwe. ");
INSERT INTO jni_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Inka i bezi imumu iriri ahira anu wuza ushi imumu iriri inicas, nyanini imumu irunta ushi uba me? Ko ana madini wa hem ina nu hem uwe. ");
INSERT INTO jni_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Inka ya nya ureme ahira andesa ya inko iribani wadi kurzo shi ni cas, Nyanini uhana aje ashi me? Ana madini wa nyaza ana madini ureme, wa nyara akurzo imum besa wa nya sarki ukinki u ire imum ni. ");
INSERT INTO jni_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","In anime hem ni ina hem ushi, i wuzi we imumu iriri. Nyani we ureme kati i inki iriba uguna adi kurzo shi ba, ukalum ushi me udi cukuno gbardang. Idi cukuno ahana ani nonzo barki me i nice num ma bezi ugogoni ahira anu zutu bezi ukunna urunta ahira anabu. ");
INSERT INTO jni_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cukunoni anu iriba i shew barki aco ushime unu iriba ishew mani. ");
INSERT INTO jni_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kati iwuzi u inko utize tini kubu, shi ada inko tize tini kuba nanshi ba, kati iwuzi moco ba, ida kuri agu shi ana moco ba, imbizo ni ana madini shi ma adi imbizo shi. ");
INSERT INTO jni_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nyizani aye, shi ma adi nya shi gbardan, unu yanga sa a guta ni une uni adi guti shini ikwangizo ati buna tishi me barki uyaga uge saya gusani, une uni adi gusa shine. ");
INSERT INTO jni_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma kuri ma bukuwe ure ubezi, “Urubu ma misi urubu ubina? Inka ma wuna anime, vat uwe wadi rizi anyimo uwaa, azo ane aniba? ");
INSERT INTO jni_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Vana ukatuma mada teki me unu bezizi ume ba, barki ani de sa makem ubezi ukem madi cukuno kasi unu bizizi ume me. ");
INSERT INTO jni_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Barki nyani ya wuna uhira ukunti anije nu henu uwe me, uda wa rusa uira imum be sa ira anije nu we ba? ");
INSERT INTO jni_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Barki nyanini udi gunu henu uwe, uhenu um, nan ikari imum besa ira anije nu we me, hu da wa ira imum be sa ira ani je nuwe ba? Hu unu iriba ibur tuba ukara ukunti sa ura ani je nuwe, uduku iri memeru imum besa ira ani je nuhenu uwe me. ");
INSERT INTO jni_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Barki ani me ure utiti uriri sa uda ke uyo ahana azensen ba, nani utiti uwice uda ke uyo ahana ariri. ");
INSERT INTO jni_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Barki a da ke arusa konde uya utiti ahira yoh ahana ameme. Barki anabu wada ke wa tazi ahana upom anipum nibi kana, nani wada ke wa inti mei mu wangu anyimo ikana. ");
INSERT INTO jni_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Una kadure ahira iraba ishew ime me madi yo ahna ariri. Una madini madi anyimo iriba izensen ime madi wuzi imum izenzen barki anyimo u inko imm iriba ime ini anyo adi buki tize. ");
INSERT INTO jni_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Barki nya ugusam anime, ugomo Asere, ugomo Asere, 'I da tarsa shi tize tum ba? ");
INSERT INTO jni_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vat desa ma aye ahira ama ma kuna tize tum ma wuza katuma ni, idi buki shi uzina ume. ");
INSERT INTO jni_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mazin kasi de sa mazinu bara akura, desa ma henze uwa pitii inka ure wa ruba, inka mei ma myinca, mada ke ma zuruko ani ba barki abara ani memmeru. ");
INSERT INTO jni_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Barki vat desa ma kunna tize tum maga me utarsa me, mazi kasi desa ma bara akura ameme adize ahura. Inka ure wa vavi ani akura me adi rizi, urizo akura me uzin ini kara. ");
INSERT INTO jni_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Uganiya sa Yeso ma mari kondi nyani ahira anabu, manno maribe uhana ukafarhum. ");
INSERT INTO jni_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Urere uruna niza, mazi uhuma ba ma haku uwono. ");
INSERT INTO jni_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sama kunna abanga a Yeso, una niza ni ginome tumi ara ananu a yahudawa ahira Yeso waka gunna mē ma eh, ma buri urere umeme ma hazu uwono. ");
INSERT INTO jni_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Uganiya sa wa eye mamu nan Yeso, wa igizo me inka dure, unuguna, “unu gino ma bari uguna awuzi me anime. ");
INSERT INTO jni_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Barki sa me unu hem in manyanga maru mani, mani ma barin duru udenge Asere. ");
INSERT INTO jni_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeso manno ma dusa nigome nan we, uganiya sa ma eh mamu nan na kura me, una niza nigino ma tumi a gun in Yeso, “ugomo Asere da ma bari in wu we u eh akura am ba. ");
INSERT INTO jni_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ine ini ya wana da ma bari in eh ahira awe ba, buka tize cas urere um ma huma. ");
INSERT INTO jni_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Barki mi nun mani unu bari, izin nanu nu nyara unipin adizi am, ida ke ugu unu ge, dusa ama dusa, in kuri ingu unigino 'aye' ama eh, inkuri ingu urere um, wuna ana, ama wu” ");
INSERT INTO jni_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Uganiya sa Yeso ma kunna anime, ma kunna ma aye kan, ma gamirka ahira de sa wa tarisame, magu, “ma buka shi, vat anyimo isar'ila da ma kem uye unu inko iriba kashi unu gino ba.” ");
INSERT INTO jni_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Abini ande sa atumi we, wa ze akura wa kem urere ma huma. ");
INSERT INTO jni_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ban anime Yeso ma ha anire nipin agusa nini na'in, ahana ka tuma kameme nan are anu gbardang wa dusa nan me. ");
INSERT INTO jni_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Uganiya sa wa eh mamu nan ana tukum anipin me, wa iri ure unu acira me ukizi, me mani vana me cas ahira aco me. A ino me mazo unu ruma ba, anu gbardang anyimo anipin wazi nan me. ");
INSERT INTO jni_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Unu ira ume, ugomo Asere ma kunna ugogoni um,”kati ushiba.” ");
INSERT INTO jni_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sa Yeso ma dara mawaga me sa anu cira me wa tunno, magu, “ma nyani hira.” ");
INSERT INTO jni_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ikizi me idusa ihiri itungun tize, Yeso ma ziki vana me ma nya aino me. ");
INSERT INTO jni_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Biyau bi dusa bi meku we, wa tunno unonzo Asere, wz gusi, “a hirz ure unudang anyimo aru” “Asere a iri anu ameme.” ");
INSERT INTO jni_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tize tigino me ti Yeso ta dusa kode aba anyimo nipin nu yahudawa nan ti hira sa tizi mamu nan we. ");
INSERT INTO jni_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ahana akatuma ka yahaya wa buki me timumu tigino vat. ");
INSERT INTO jni_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yahaya ma titi ahana akatuma ka meme ana wa re, ma tumu we ahira ugomo Asere, wagume, “hama ni unu aye me nani uye mani sa ti di be u aye umeme?” ");
INSERT INTO jni_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sa wa eh mamu nan Yeso, anu wa gu, “yahaya unu zorso anabu, ma tuman duru ti iki we,” “ha mani desa u aze, anani ti nyargi uye?” ");
INSERT INTO jni_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Uganiya ugino me mahumuza ina na ti koni gbardang nan anu ijasi ana na nu ibe ibur, arubo gbardang wa kem uhira ahira. ");
INSERT INTO jni_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yeso ma kabirka magun we, uganiya sa ya dusa ika buka yahaya imum be sa ya kunna nan imum besa ya iri, arubu wa kem uhira ahira, anu dira uti buna wa hirsa, akuri a kpici anu dira uti boo, a turi wa kunna, ahirza anu wijo, buki anu dira tize turunta. ");
INSERT INTO jni_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Unu imumu iriri ini desa ma tunno unu nya iriba ahira am barki timumu tum sa in wuza. ");
INSERT INTO jni_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Uganiya sa ana kadure ka yahaya wa dusa, Yeso ma tubi boo anu ani ori tize anice ni yahaya me, nyani ni yaha ika ira anjame, tikpe tige sa ukpebu wazinu zuro me? ");
INSERT INTO jni_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nyani ni yaha barki ika ika ira, unu turi in tiranga ti ubulubu? ira anu sa wa turi intirunga tini nonzo, wa zin in ti cukum tu kunna urunta wa ra ani kubu na gomo. ");
INSERT INTO jni_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Barki nyanini ya hana inka ira unu bezi utize? ē in busa shi, ma ba teki unu bezi utize. ");
INSERT INTO jni_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Igino me ine ini a nyetike a iza hume me, “ira itumu za vana uka dura kam aje aweme, de sa madi barki we unaa aje awem.” ");
INSERT INTO jni_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Inzinu boo ushi, anyimo ande sa aneh wa yozo we, azo desa ma teki yahaya unu gbardang ba. Vat in ani me, desa ma teki unu cingilin akura Asere, ma teki unu gbardang. ");
INSERT INTO jni_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Uganiya anu vat wa kunna ani me, vat nan nanu kabisa ugandu, wa bezi Asere una kadure mani. Wazin unu wuza anime yahay ma zorso we. ");
INSERT INTO jni_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A farisayawa nan ande sa wazin ini kara a yimo u inko utize tini ubu na ayahudawa, ande sa azo me mani ma zorso we ba, wa vete urusa wa Asere ni inace awe me. ");
INSERT INTO jni_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeso manno magu, idi bati anu unee uge me in nyanini? wa wuna kasi nyani ni? ");
INSERT INTO jni_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wa zi kasi ahana sa wa zin in biranza ahira abiziza ziza, ande sa wa zin in tize ace awe wa gusa, ta wuza shi ahure, daya wuza murso ba. ta wuza tiyom izoni, da so ba. ");
INSERT INTO jni_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ane ani yahaya ma aye, da mare imumara ya Asere ba, da ma sa mei mu wungo ba, shi be ya guna, u bgergene mani ma tarsan ime. ");
INSERT INTO jni_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Vanu unu bu, ma aye, mare mazi na sa me, shibe, ya gashi me, igusa ira unu ita pash, unu sa u wango gbardang, uroni anu, kabisa ugandu nan anu amadini. ");
INSERT INTO jni_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ingi aneni urusa wa Asere ubizi zi vat anu ameme. ");
INSERT INTO jni_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ure uwui ure unu wa farisiyawa, ma iki Yeso maka re imimare nan me. Uganiya sa Yeso ma ribe akura ufariyawa me, ma cukuno ahira u iso imimare me, barki ma ri imimare. ");
INSERT INTO jni_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ure uneh u madini ma eh, masuro anyimo anipin. Uganiya ma kunna Yeso ma ra akura ufarisiyawa, barki ma ri imimare, maziki ni ru ni mani mu nya urunta. ");
INSERT INTO jni_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma tunno upuru u Yeso mazin ina so, ma tubi urumuzo itibuna in maje, maduku hummimtibuna tumeme in tice nume, maduku gwindiri tibuna me ma hummi tini mani mu nya urunta me. ");
INSERT INTO jni_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sa ufarisiyawa me ma titi Yeso me, ma ira anime, monnō ma basa anyimo iriba imeme unu guna, “da unu geme unu kurzo utiza mani” mada urasu uya ya umeh mani, unuge sa ma zinu darsa ume, me ina madini mani. ");
INSERT INTO jni_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeso ma kabirka magu, “simon inyara ibuku we ire imum.” magu, “unu nyetike se ubuki.” ");
INSERT INTO jni_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeso magu, “ure unu unu nyiza ureme ma tarsa are anu ware ikirfi, uye tarsa uye isule akuru ukirau, uyenma kuri ma tarsa me isule a inu ucibi. ");
INSERT INTO jni_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ya cukuno wa zowe ini kirfi sa wa deke wa kurzo meni ba, mano ma cekiwe ni, vat uwe wa re me. Anyimo aweme wa re me, aveni anyimo awe madi teke unu hem unu ugino me?” ");
INSERT INTO jni_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon ma kabirka magu, “ubasa um kasi desa aceki me ikirfi idang me,” Yeso ma utize tini ukubu me rebi. ");
INSERT INTO jni_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeso ma gamirka ahira uneh me, magun in simon, wa ira uneh ugino me. Ma ribe akura aweme, dawa nyam mei barki tibuna tum ba, uneh ma nyam, in maje ma meme ma kpico ti buna tum, ma vizi tini in tice tume me. ");
INSERT INTO jni_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huda wa gwindirkom ba, me ma wuzi, dati uganiya sa ma ribe abame da ma ceki ugwindoro um ba. ");
INSERT INTO jni_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hu dawa humuka nice num in mani ba, me ma humma tinbuna tum in mani mu nya urunta. ");
INSERT INTO jni_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Barki anime, me sa mazin in ma dini gbardang ma nya gbardang, ma kuru ma bezi uhem gbardang, barki anime akpico madini ma meme cingilin, ma kuri ma bezi u hem cingilin. ");
INSERT INTO jni_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Abi nime magun uneh me, “a kpico madini ma weme,” ");
INSERT INTO jni_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ande sa wa ciki ahira me nan me wa tubi tize ace awe me, “aveni ma zigino sa me ma kpijo madini? ");
INSERT INTO jni_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeso ma gun unu neh me, n nya iriba iwe me ubenku we, dusa ini riba irum,” ");
INSERT INTO jni_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","I'mA anime, Yeso nan nanu tarsa umeme u kirau nana ware, wa keti tipin tipin tigiro sas-san, wa zin nu kisa inteze turunta azesere Atigomo ta Asere, ");
INSERT INTO jni_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a nee gbardan agebe sa Yeso mahumu zan a gbergene nan tikoni sas-sas, wahaki ni gome nan we. A nyimo awe Maryamu de sa agusan me Magadaliya, desa maāsuso a gbergene anyimo ame, ");
INSERT INTO jni_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwana, une ukuza, udura u Hiridus, nan Suzana, a ara nēgbardang. Usuro imum itari tuwe wa orwe ni ");
INSERT INTO jni_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Uru wui a ori ni ori nanu gbardang, barki anu wa eze ususo ati pin pin gbardang barki wa iri Yeso. Mabu tize nan we tize anyimo atize. ");
INSERT INTO jni_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uru una ti bira nadusa barki mabirai sana. Sama zin nu cofe sana, ire isa na irizi azesere una. Una wapata li ini inyin itngi ire iri. ");
INSERT INTO jni_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ire ikuri irizi azesere apo sarki nyan ga gbardang Sa ya suro itubi ti uza, ahira me ikuri iwa barki sa ahirame ada intame mazuzu ba ");
INSERT INTO jni_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","isana ikuri irizi anyimo kana tikpe nan ni kana tisuri ni gome nan ni sana sa abira, ipatti we daya rusa ti uzaba. ");
INSERT INTO jni_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","isana irizi amanyan ga ma riri, i uza kan inya bisan gbardang, inya mareu kanu ukirau,” Sa Yesu mabuka abanga agino me, bama titiwe, “Uat unatatui tukuma, aca makun na,” ");
INSERT INTO jni_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ba nu tarsa uYeso wa ikkime mabu ku we nyani bi nyo bibuka uginome. ");
INSERT INTO jni_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Magunwe, “Shiwani a nyashi irusi imum be sa izi nihunzi, iti gomo ta Asere. Ukasu anu inbowe tize anyimo atize, 'barki ko gussi wa ire wadda surame ba, ko gussi wa kunna wa dida rusameba. ");
INSERT INTO jni_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","biti ze toge biye. I sana me ine ini tizee ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","sa yarizo Azesere una ine ini anu sa wa kunna tize ta Asere awe kuri inna dumo unu buru ma ē ma ziki tize me amu ruba muwe me, barki wa hem wa ke ubura. ");
INSERT INTO jni_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","saya rizi apo we wani anu me sa, wa zin nu kunna utize, wake wa kaba in na puru arum, wada zome in ti jiba: Wake wa nya uhem sisi uganiya cin, inki umansa wa kem we awa cikki una ");
INSERT INTO jni_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","saya rizo i kana, wewani anu mw sa ingi wa kun na tizeme, inki warwe aje innu vengi ze, waceki are a dodu ukem imumu uneē nan nu kunnaurunta u aki ni kara nuwe, icuno wadeke wada nyame ahana sa daki wa unaba. ");
INSERT INTO jni_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","sa yarizo amanyanga mahuma, ine ini anu me sawa kun na ti zeme wakabi tini innu hem inni ruba i inde, wa inta gan-ganWa tonzino ahira unyinza a hana. ");
INSERT INTO jni_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","unu rusa u pitila, ma inpi in nun buru, nani wa inki adizi ukomi. Sen ke at ari uni ahira aticukumtu uni barki vat desa maribe ma iri mamsa ma uni. ");
INSERT INTO jni_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ige be sa izi nihinzi sa idida pokome ini ba, nani imumu ini hunzi sa adake adarusame iniba. ");
INSERT INTO jni_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","nii sēke innu kuna, barki vat u ni mum, me mani adi kinki meni, vat u nu zatti immu, acin sama basa-ma zini adi ziki.” ");
INSERT INTO jni_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ino Yeso nan na nu ameme, wa ē ahira ame, daki wa rusa u hana mamma mu nan me ba barki nigura nanu. ");
INSERT INTO jni_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","mabukine, “Aino uwe maye nan na nu'henu uweme, waturi amatara, wa nyara u'ira uwe.” ");
INSERT INTO jni_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeso makabirka we, “A ino um nan 'anu' henu un wewani ande sa wa kunna tize ta Asere, watarsa tini.” ");
INSERT INTO jni_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","wui Yeso ma ribe anyimo u zirgi umei, nan nanu tarsa umeme. Magun we, “In nyara tiha ani winme.” Ba wa tubi tanu uka kafa ani winme. ");
INSERT INTO jni_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","wahaka Yeso matubi muro, ba urru pebu uni kara uhiri anyimo ani win me, ahirame uzirgime, utubi umyi nca un mei, we anyimo. ama aye. ");
INSERT INTO jni_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","anu tarsa u Yeso wa ē watubi amoro me. Wa gun me, Una akura! Una kura! Tidi wi!” Bama hiri mabuki upebu me, Ba upebu iran za u gamara u mei waton no dang. ");
INSERT INTO jni_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","bama gunwe, “Uhem ushime uraā?” Anu tarsa wne wa kunna bi yau. Wameki ubasa abanga inni mum be saya kem ahirame. Wagunna acece, “Aveni ugume samadake ma gbarikka upebu nan mei watar si Imumbe sama buka.” ");
INSERT INTO jni_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","e uwatu uma Garasinawa, sawa zi mamu nan nu Galili. ");
INSERT INTO jni_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesomatuno adizi, bā urrunu u watu ugino me makabi me. Unu ugino me mazin inna gbergene. Unume ma dodon kino mada son sime turunga ba, mada kuri ma cukuzu no akura ba. muni macukuzuno ni. ");
INSERT INTO jni_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","maā ira Yeso, unume mawu uhu nu in ni kara. Matunguno aji ame inni myiram ni dang magu, Nyani in di wuzinn hu, Yeso, vana Asere unu bari? izinu iggizo uwe, katti u wum izitto!” ");
INSERT INTO jni_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Barki Yeso mabuki a gbergene me wa su ri anyimo ame, barki a agbargeneme wa ma atira ini inni nyan a korsome, make matazi ini ibe zezen ike i gidi me anyimo anija. ");
INSERT INTO jni_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ma ikki me, “Anee ni ni zanuwe me?” Bama kabirka, “Niza'numu gben-gben ini.” maguane ani barki agbergene wa ribe unu ge me. ");
INSERT INTO jni_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","wa meki u iggizo u Yeso ka ki ma gun we wa ribe anyimo aniwa ni com com ");
INSERT INTO jni_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","nima ladu na rani wazin nu ka se a zesere apana mamu nan na hirame. Agbergene me wa ikki Yeso ma cekku we wa ribe anyimo amaladu me ma hem in we. ");
INSERT INTO jni_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","me wa cikki unume waaribe anyimo ama ladu me, Bani goo ni ma ladu me tu uhana ani win, wapira. ");
INSERT INTO jni_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","sa anu tarsan maladu me wa iri imumbe Saya kem, bawa sumi! Waka nya tize timumbe saya kem a hiraa nu anyimo ani pin nan na gi ro agino me. ");
INSERT INTO jni_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ani me, anu sa sa wakunna anime wa dusa barkiwaka ira imumbe saya ken, wa e ahirame sa Yeso marani wa iri unu be sa agbergene wa suro a me. Wa iri ma soki turunga, mara anyimo urusa imum ime ba biyau bime kki we. ");
INSERT INTO jni_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","sawa ira imunbe sa yakem, iNabuki yae uhuma me sa ahuman nu nu sa agbergene wazin nu barinme. ");
INSERT INTO jni_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","be sawara anyimo uwatu umgarasinawa nan desa wara a mo tikikira, wa ikki Yeso ma suri anyi mo u watu uni pin nuwe barki wa kunna biyau kan. Abine Yeso nan a nu tarsa ume waribe anyimo uzirgi umei wa kuri. ");
INSERT INTO jni_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","sa agbergene wa suri anyimo ame, ma ikki Yeso uguna, “Cekkum in dusa nigome nan hu! Yeso ma ceki me agi, ");
INSERT INTO jni_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","akura ubuki imum idandang ige be sa Asere awuzawe.” Abinime ba unume madusa in nu bo anu ani pin me vat usuro imumbe sa Yeso mawu za me ini. ");
INSERT INTO jni_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeso ma zee, anu wawume mahabi we vat wa be me. ");
INSERT INTO jni_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","kem uye ma yen ne unani za yayirus, uye anyimo ana je udunge uni nan zo ma e mamu nan Yeso matunguno in ni ce nume adizi. Ma ikkime barki ma e akura ameme. ");
INSERT INTO jni_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sa uce ume samazin tiwe u turwai in tire maraa anyo iwono, me mani cas ucame sa hira. Anime sama haka, nigo nanu gbardang in nu patti ume. ");
INSERT INTO jni_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","nee marani samaye ma kpa ngizo me uzika utiwe uturuwai in tire. Mahuna ikirfi ume vat a hira abere, barki wahuman me anime dakki akem desa ma rusa u human me. ");
INSERT INTO jni_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","amaru a Yeso madari u dibi me. Ahirame u lpongizo umaye me u tonno. ");
INSERT INTO jni_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeso magu, “Aveeni manyam?” Ande sa wa kate me, ko vi magu dama darame ba, Bitrus magu, “Ande sa wa kate me, ko vi magu, “Unaje anu gben wa zin nu orrizino ana me in nu eze mammamu nan hu.” ");
INSERT INTO jni_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yeso magu “In rusa uye ma daram, barki ubari wa suro a hira am. ");
INSERT INTO jni_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sa unee marusa madake mada gunne ba, ba ma e ahira ame a nyimo abiyau. Matunguna madarame sisi ahira ma huma. ");
INSERT INTO jni_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bama gun me, “Uca, uhem uwe uhuman hu. Dusa in ni ruba uranta. ");
INSERT INTO jni_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mara anyimo uboo tize, Uye anyimo akura una je anbu ma e, magu, “Uca uweme mamu wono, cekkime uca uwe mamu wono.”. ");
INSERT INTO jni_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sa Yeso makum na anime bamagu nme, “Kati ukukanna biyau. Nya kadure uca uwe madi huma.” ");
INSERT INTO jni_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sa ma aye akurame, da ma ceki u ye maribe akuame nigome nan me ba sinke Bitrus nan Yahana nan Yakubu aino uca me nan ka coo me. ");
INSERT INTO jni_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vatta anu ahirame, intiso inni kara barki wa zin ma eye ma came ma wono. Yeso magun we. “Cekini aso! Dakki ma wono ba! Mazin moroma ni! ");
INSERT INTO jni_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Anu wa wuzime ti zunza tibi i zu, barki sa wa rusa ucama wono. ");
INSERT INTO jni_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma meki tari tume matitit uguna, “Uca, magu na uhiri.” ");
INSERT INTO jni_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ahira-hirame bibe bumee bize ani pun numeme mahiri. magun wa nyame i mare mari. ");
INSERT INTO jni_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A nka coome imum ibiyau ime kuwe anime Yeso mabeki anka coome katti wabeki uye imum be saya kem ba. ");
INSERT INTO jni_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Matti anu tarsa umeme anu kirau in ware mangawe ubari wasuzo a gberge ne ko ayayya, mahu mu zanina na ti koni. ");
INSERT INTO jni_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma tumu we, wabu tize titi gomo Asere wakuri wahum zan na na ti koni. ");
INSERT INTO jni_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Magunwe, katti izi imum barki tam u tigino me ba, kati izi ubina nani ubadau barki tanu, a imumare nan ni kirfi kati iba zika turunga ka re. ");
INSERT INTO jni_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Vatta akurame saya ribe, ni icukuno akurame uhana uganiya sa idi dusa i kini u watu gino me. ");
INSERT INTO jni_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Vatti ande sa daki wawuna shi ma habiba, inki idi ceki nipin me, ikuburu ususuru utibuna ti shi anyo u inko u ira ahira awe. ");
INSERT INTO jni_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Abini me anu tarsa ume wadusa agiro, wa kisa tizeme, innu wuza ire koba nan nanu. ");
INSERT INTO jni_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Azi Hiridus, una tigoma, makun na ubo abangame vatti imumba sa izinnu ken zi. Ma wuzi ugamara u tize barka sa are anu wagusa Yahaya unu zursu za anu mani maku ri maze inn vengize. ");
INSERT INTO jni_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aye wakur wagusa, Iliya unu kurzu zo utize mani ma aye, a aye in nu gussa uye mani anyimo anu kur zuzo utize tu daati tini makuru ma aye innu vengize. ");
INSERT INTO jni_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridus magu, “Dakki Yahaya mani ba, barki makori kome nice. Ani aveni mazi geme sa inzunu kunzi nna mumu iginome ani ce nume?” A anime mari aje mu nyara u naa sa madi iri Yeso. ");
INSERT INTO jni_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sa anaka dura waze usuro a tanu tuwe, wabuki Yeso vatti imumbe sawa wuza. Abine mazi kuwe barki wadusa nigome nan me uhana ani pin nu Baitsaida. ");
INSERT INTO jni_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sa ni ori na kunna ahira sa Yeso mahana, ba wa tarsime uhana a birko me. Mawuwe rabashi mawuzi we tize abanga ati gomota Asere, makari anu be sa wa nya ra ni huma. ");
INSERT INTO jni_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ā uwunjoro watuba uwuna anu tarsa umeme anu kirau in nana ware wa e wagunme, “Inki wahem u gu inni gura ni geme ni mari barki anu waribi ze agiro, sa akete tiru, barki wakemi imumare nan tihira sa wadi musini, barki sa tirani ahira me sa anu wazoni! ");
INSERT INTO jni_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ba ma gunwe, “Nyani we imumme sa wadiri”. Wakabirkame “Vatti imumbe sa tizini ine ini, 'Kukasu ku borodi mugitu munu ciibi nan mi cere muni mure, tidake tida ke kemme imumare sa idi bari anabu vattiba'. ");
INSERT INTO jni_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Anume sa wara ahirame wabiki ugbardang aha aruma ukirau kanu kanu kanu ciibi (5,000) Bayeso magu inna nu tarsa umeme, “Gunani nanu wacuku zuno tigo-tigo, anu akuru ciibi kō niya nigo.” ");
INSERT INTO jni_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ba anu tarsa ume me wawuzi a nime, anu vat wa cukuno. ");
INSERT INTO jni_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma zikka mugitu mimumare munu cii bi, nan ni ceremire, mazin hirame uhana azesere maringirka ini, ma zikki mapusi, manya anu tarsa ume me barki wa hari anu. ");
INSERT INTO jni_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vat uwe wari ko avi mati. Abine anu tarsa umeme wa ori ukasu i mumare saya de, mugira munu kirau in muni mure mumyinca! ");
INSERT INTO jni_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","U ru wui Yeso mazin ibi ringara me isisi me, ba anu tarsa u meme wa e bama ikwe, “Anu wagu san mi aveni?” ");
INSERT INTO jni_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wa kabirka, “Aye wagusa, Yahaya unu zorso anu, aye wagusa hulliya mani unu kurzuzo utize. A ana me aye wa gussa hu uye mani anu kurzu zo utize tu daāti mani ma aye in nu vengize”. ");
INSERT INTO jni_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma ikwe, “Shina? Igusani mi avi?” Bitrus ma kabirka, 'Hu wa suro a zesere ani”. ");
INSERT INTO jni_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ba Yeso ma nyawe tize in kara, kati wada buki uye ani ba. ");
INSERT INTO jni_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Anime magu, “Ya cukuno Gwas ini vana unu masi ijas ati mumum gbardang: Ananu wadi game nan na nu adandan akatuma nan anu nyitike, anime adi hume. Adumo ati ye ti taru adi hirzame innu vengize. ");
INSERT INTO jni_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bama gunwe vat, “Vatti desa manyara matar sum, ya cukuno me gbas ma wu matara mani ce nume, maziki ugankirka ume koya umaya, matarsum. ");
INSERT INTO jni_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vat de sa manyara maburi nice nume, madidiri, inki wa nya iriba i we barki me, madi burime. ");
INSERT INTO jni_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Maya mareu mani unu madi kem inki makem unee vat, madiku diri ni ce nume? ");
INSERT INTO jni_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vat desa ma kunna mu i mum nan tize tum, vana unu madi kunna mu i mume cangi, inki maze anyimo u gogon ume nan nu gonggon wacoō a ibe ikadura kame ilau. ");
INSERT INTO jni_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Anime inboshi gbas, aye anyimo a shime sa ira aba ituri, wadida wonome ba senke wa ira ti gomo ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tiye u wititari sata aki Yeso mabuki aguran aginome, Bama ziki Bitrus nan Yahaya a Yakubu, manyine ani po barki wuzi biran gara ahira me. ");
INSERT INTO jni_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Uganiya sa ma zin nu wuza ubi ringara matiri muhenu mume turnga tume me ticukuno tirum pau imma sa kasi umelme Asere. ");
INSERT INTO jni_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sisi ahira me ba ake ana ware wazin tize nan me, Musa nan Iliya. ");
INSERT INTO jni_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wa e innu gongon ukatuwe, wabuki tize nan Yeso usuro Utanu tume sa ti di e dakin nu dodon kino ba a Urshalima. ");
INSERT INTO jni_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus nan anu tarsa me sawazi ni gome nan me muro mazikuwe gittak sa wa zuma bawa iri ni nonzo ni Yeso; wa iri anu awe me ware waturi nan me. ");
INSERT INTO jni_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Uganiya sa Musa nan Iliya wazin nu bara abanga wa kini ahira Yeso. Ba Bitrus magu, “Hu unaje, ya wuna uri sa tira abame. Idi wu uri tibari madak mataru, u inde barki hu, u inde barki Musa unde barki Iliya “Kadure matame imumbe sama zin nu bome ba. ");
INSERT INTO jni_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sa mazin nu bome anime ba nire niwiri nie ni impuwe. Ba wa kun na biyau sa tiwiri me ta kete we. ");
INSERT INTO jni_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ba akunna nire ni myiran anyimo atiwiri nigusa, “Unu gino me vana um mani sama zauka kunnani me”. ");
INSERT INTO jni_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sa nimyiran na mara tize, Yeso ni isisi ime. Wawu tik daki waru sa ubuka imumba azesere imumbe sa wa ira atiye tiginome. ");
INSERT INTO jni_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sa ahira a sana, sawa tono usuro inipo, ba ni ori nanu gbardang wa e ahira ame. ");
INSERT INTO jni_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A hira me sisi uru nu anyimo ani ori na nume mabuki tize in kar, “Unu dungara, wuza irimum barki u benki vana um, me isisi me ini ahira am. ");
INSERT INTO jni_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bibe biburu bike binyene anice nu me, make mawuzi magowa. Ike izuruko me inni kara iwu me mame ki usozo ufuki anyo. Mahar zina in ni Jassi inni, ikke ikunno me iwono dakki cinba inki ya aye ya ciki me. ");
INSERT INTO jni_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma ikko anu tarsa uwowe wa buki bibe biburu bisuri anyimo ame, daki wa rusa ba!” ");
INSERT INTO jni_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeso, Makabirka, magu, “Shi ucara u gambalan anu zatu hem, innu maya uni indi cukuno indo donki no nan shi? “Ayen vana uwome aban na. ");
INSERT INTO jni_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sa vanaa ma eze, bibe biburu me be coofi vaname adizi, bi zuru kome kank. Yeso ma bubuki bibe biburu me, mawu vana mahuma manya a n ka coome. ");
INSERT INTO jni_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vatti uwe imumu ibiyau innu bezi ubari Asere. Sawa zinnu gamara abanga azesere imumu ubezi ubari sama wuza, magun innanu tarsa umeme, ");
INSERT INTO jni_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kunna ni memmeru azesere unube san di buki shi, daki adi dodon ki ni ba adi nya vana unu atari tanu”. ");
INSERT INTO jni_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Anime daki anu tarsa ume meda ki wa rusa imumba samaba sa ani ba, akartuwe warusi, barki katii wa rusi imumbe sa ma da basa, wakunna biyau bu guna wa ikkime. ");
INSERT INTO jni_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Uru Ganiya, anu tarsa umeme wake watubi matara ace-ce awe me avee ni madicuku no unamu anyimo aweme. ");
INSERT INTO jni_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeso masa rusa imumbe wa basa iriba iweme, bama ewen vana u cin ma turi upuru umeme. ");
INSERT INTO jni_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ba ma gunwe, “Inke uye makaba vana u cin ugeme barki mi, repini gusi mimani. Inki uye madabam, makaba desa tuma ini. Desa mema ni ucicii anyimo ashiu, memani mate ki innu ira”. ");
INSERT INTO jni_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahaya makabirka magu, “Hu unanu ta ira urru nu mazin bo ibe iburu i susi anyimo anu inniza nuwome. Ba tigun ma ceki uwuza anime barki ma zinan haruba”. ");
INSERT INTO jni_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeso magu, “Katti kartime uwuza animeba, barki vat desa mazin nishi na nan shiba mazi nigome nan shi”. ");
INSERT INTO jni_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sa uwui wa wuna sa madi nyene u hana azesere, ma zikki kank madi dusa a Urshalima. ");
INSERT INTO jni_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma tumi are anakadura (manzani) wabarka ahira barkime ma'e. Waribe a aragiro anyimo usamariya barki wa barka me ahira abirkome. ");
INSERT INTO jni_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A naa birko me daki wakabame ba tunsa u Urshalima uni madi dusa. ");
INSERT INTO jni_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sa ana ware anyimo anu tarsa u meme, watu Yakubu nan Yahaya waira anime, wagu, “Ugoma Asere, unyara tugunnura u tu ana zesere, uhuwe?” ");
INSERT INTO jni_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Magamirk ma gbarikawe, ");
INSERT INTO jni_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ba wa dusa araagiro sas. ");
INSERT INTO jni_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sa wa ra anyimo atanu una, ba urrunu magun me, “Indi tarsuwe vat ahira sa uhana”. ");
INSERT INTO jni_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeso ma kabirka, “I nya-nyau izinti wa adizi sa wa di ribe, inyin iyin masuu, vana unu mazin na hiraa sadi totiniba. ");
INSERT INTO jni_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeso, makuri magun urrunu, “Tar sam”. Unume magu, “Ugoma Asere, ceki inkuri akura indaka vati aino um”. ");
INSERT INTO jni_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeso magun me, “Kini anu wijo wa varsi anu wijo: Hudusa uka kissa anu abanga atigomo ta Asere koo ba”. ");
INSERT INTO jni_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Uye ma kur magu, “Ugoma Asere idi tarsuwe, da cekkum inha inka wu na saa mura nan na nuam”. ");
INSERT INTO jni_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeso magun me, “Vat desa matuba avara uru ume magunkuno a dumo, daki mabari maribe at gomo ta Asere ba”. ");
INSERT INTO jni_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Adomo imumu ginome, ugomo Asere makuri maturi aye ukirau, kanu sunare, maharawe wa rere, barki wadusa ati pintinpin nan na hira me sa manyar u haname. ");
INSERT INTO jni_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Magun we, “Ukuzame u ori ana kana tuma wahuma cin. Barki anime wuzani biringara kan u hana Asere ukuzame, barki ma tumin inana katuma anyimo u ruu umeme. ");
INSERT INTO jni_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dusanni, wa matumashi kasi muzara anyimo ikukure. ");
INSERT INTO jni_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kati ziki ubadu ikirfi, nani u badau ana tanu, nani akwatak, kati issi uye azesere una ba. ");
INSERT INTO jni_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Vat ta akura sa ya ribe, itubi uguna, 'aca urunta u cukuno aku ra aginome. ");
INSERT INTO jni_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inki uye una ticukum tirunta mara ni akurame, urunta urunta ushi udi cukuno ani ce nume, inki uzome ba, urunta ushi udi kuri ahira ashi. ");
INSERT INTO jni_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cukunoni akura aginome, iri isi imum be sawa nyara shini. Yawuna uri una katuma makabi ukalum ume. Kati tarsi tikura tikura ba. ");
INSERT INTO jni_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vatti nipinme saya kuri yarbeni, iri imumbe sawa inko aje ashi. ");
INSERT INTO jni_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I humuzan nanu uzatu nuhuma a hira me. igunwe, 'tigomo ta Asere ta aya mamu nan shi. ");
INSERT INTO jni_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Vatti nipinme saya ribeni, inki daki wakaba shi ba, idusa anyi mo ati na tu we me, igu. ");
INSERT INTO jni_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Inki usussuru unipin nishime watafi na atibuna tiru, ti kubur kashi u ni anyo uinko u ira ace ashi! Senke irusi tigomo ta Asere ta aye mamu nan shi'. ");
INSERT INTO jni_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mabuka shi, roni uweku tize u sadoma udi teki innu sheu. ");
INSERT INTO jni_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hu wono sis anime, ukirosino! Huwono sis anime u Baitsaida! Biwuza wuza bidang sa awuza anyimo ashi, dagi a wuza ini anyimo u Taya nan nu Sidon, sa dati wakabi tize ta Asere wa ciki anyimo amuto in turum ga titiyom. ");
INSERT INTO jni_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aname roni weki utize Utaya nan nu Sidon wadi teki innu kenu us Sheu. ");
INSERT INTO jni_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hu U Kafarnahum, ubasa uhana azesere adi nonzowe? Mmmm, a di tiburkowe uhana uhadas. ");
INSERT INTO jni_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Deve sa makunna shi makun nam, des a magaa shi, ma gaa mi, aname desa magaami magaa desama tuma”. ");
INSERT INTO jni_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","We ainoo ino kanu sunare me waze inti puru tirum, wazinnu gusa, “Asere, a gbergene cangi wa kunnan duru, anyimo ani zanuwe. ");
INSERT INTO jni_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bayeso magun we, “Ma ira u nu uburu mazin nu rizizo kasi u melme azesere. ");
INSERT INTO jni_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ira ni manya shi ubari inni, iwa nan ninu, nan nu vat ubari u na ticari, ko cin madake mada aye shi in ire mu ba. ");
INSERT INTO jni_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Vat a anime katu iwuzi apuru arum in nuguna anime cas agi ibe iburu ikunna shi, anime wu zani apuru arum barki a nyeti ke tiza tishi anyimo Asesere”. ");
INSERT INTO jni_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Anyimo uganiya uginome, ma wuzi apuru arum kank anyimo abibe bilau, magu, manyawe ti nanu, hu acoo, ugoma Asere nan nadizi. Barki umpo iginome ti mumum to suro anu rusa, ubuki tini ahiran desa daki wamazaba, kasi ahana acincin e acoo a ne ani ya wunawe. ");
INSERT INTO jni_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Vatti imum, acoo ma nyam ini, badesa marusa vaname, Senke acoo me, anime ani badesa maru sa coo me, Senke vaname. Desa vaname manyari ma poki acoome ahirame”. ");
INSERT INTO jni_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Magamirka ahira anu tarsa u me, magun we ame isisi ime, “Anu ringirka ulani an desa wa ira imumbe saya ira. ");
INSERT INTO jni_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mabuka shi, anu kur zuzo utize gbardang, nan na gomo gbardang wanya ra wada ira mumme sa izin nu hira me, daki wa iraba. Wanyara wa da kunna imumme sa ikunna, daki wa kunna ba”. ");
INSERT INTO jni_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ba akem uye unu dungara utize tini kubu tima yahudawa, ma e ma masame in nu guna, “unu dungara, nyani indi wuzi barki inkem u vengize uzatu mara?” ");
INSERT INTO jni_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ba Yeso magun me, “Ine ni uhira u hira imumbe sa anyitike anyimo uweki utize tini kubume?” ");
INSERT INTO jni_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Makabarka, magu, “Ya cukuno uhem innu gomo Asere vat inni riba i we, nan nikara nuwe, nan nubasa u we. Ukuri uhem innu puru u we kasi nice nuwe”. ");
INSERT INTO jni_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeso magun ne, “Wakabirka rep, inki wawuna ani me udi vengize”. ");
INSERT INTO jni_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Unu dungara me manyari ubura uni ce nume, bama gun inye so, “A veni unu puru ume?” ");
INSERT INTO jni_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma kabirka magu, “Ure unu mahaka usuro a urshalima mahaza uyari ko. Ba ma rizi atari tanu gartize anu. Wa susome turunga, waburi vat imumbe sama zini, wa tiri me, wace ki me kasi ikizi. ");
INSERT INTO jni_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A kem ure una katuma matasa uname, samaa wame ba matarsi ni kira ni inde ma aki. ");
INSERT INTO jni_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Akuri a iri ure ubalawi, sama aye ahirame, ma iri me ba ma tarsi nikira ma akki. ");
INSERT INTO jni_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ure u samariyawa, ma zin tanu sama aye ahira me sa unume maraa ni, sama ira unume ba ugogoni umekime. ");
INSERT INTO jni_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma ē ahira sa umume marani, ma tirzi me tinuru me sa a kunnome ni, mazin nu humma ume mani nan mei mu inabi. Maturi me abi zenki bumeme ma en me ahira amusa, mahirime. ");
INSERT INTO jni_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A hira asani ma ēn nidinari inire ma nya hira amura me magu, 'hirame, inki wahu na imumbe sa ite ki anime, inki mazee indi indi kur zo we ni'. ");
INSERT INTO jni_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Anyimo we wataru me, aveni u basa mara upuru unu ugino me sa ma rizo atari tanu gartize anu me?” ");
INSERT INTO jni_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ba unu dungara magu, “Unuge sama bezime ubura” ba Yeso ma gun me, “Huma kawuza anime”. ");
INSERT INTO jni_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sa wa haka ba ma ribe anyimo are agiro, ba uru ne uni ni marta ma wume rabahu akura meme. ");
INSERT INTO jni_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma zin henu ni zame Maryamu, desa ma cukuno ati buna tu gomo Asere mazin nu kunna imum sa ma buka. ");
INSERT INTO jni_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Me marta mazin na banga imumare. Ba ma ahira ye so magu, “Ugomo Asare, adaa igizo in nu henu um sa ma cekum isisi im? Gunan me ma benkum”. ");
INSERT INTO jni_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ugomo Asere ma kabir ka me, “Marta, Marta, uzin ma aye a hira imum gbardang. ");
INSERT INTO jni_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","I mum inde ini ya cukuno gbas. Maryamu ma zauka imum iri ri. Igebe sa adake aburi ini ame ba”. ");
INSERT INTO jni_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ure uganiya Yeso māzin in Biringara a are ahira, uye anyimo ahana utarsa umeme, magun me, “Ugomo-Asere, bezin duru uwana ubirgngara gusi Yahaya me sa mā sa mā bezi a unu tarsa umeme”. ");
INSERT INTO jni_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeso magun we, “Uganiya sa izin in biringara i gu, Acco, ackpici nizanu we me tigomo tiwome ti e, ");
INSERT INTO jni_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nyam duru imumbe sa tide ree konde uya uwui. ");
INSERT INTO jni_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kpicon duru madini marume, gusi ande sa ticensu we in muruba mu inde. Kati uhan haru anyimo uwuza umadini. ");
INSERT INTO jni_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","“Yeso magunwe, “Aveni anyimo ashi me inka mazin unu roni, madi haa ahira ameme ina tee niye, magun me, “Uroni, nyam ureme ubi mara immare inituru. ");
INSERT INTO jni_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sa azi anime ure uroni mā aye a'ana me usuro atanu, abanna me izom mi mum be sa indi nyame, ");
INSERT INTO jni_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Unuge sa maraa anyimo, makabirka, magu, kati-uwuzum dundung. Mamu kursa ana tukum am, in kuri inzi ina hana am ta mu totto. In daki in hiri inya we bi mana bi mare. ");
INSERT INTO jni_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma buka shi, sa daki mahira ma nya we immare ba, abinime sa mazi uroni ume, daki wa kunna mu e ba, ugusa unu tira utari time ne, madi hiri ma nyawe vat immare sa unyara. ");
INSERT INTO jni_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mi in kuri ingusa shi, ikoni adi nya shi, nyara ni indi kem, kpotikon ana tukum adi poki shin. ");
INSERT INTO jni_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Barki vat de be sa mā iko ma ke makabi, vat de sa ma nyara madi kuri makem; vat de sa ma kpotiko ana tukum me, adi poki men. ");
INSERT INTO jni_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ire imum ini anyimo ashi me, inki vana umeme ma ikome bi cere, madi nyame biwa anyo abi cere me? ");
INSERT INTO jni_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nyani inki ma iko me niwa, any me be bino? ");
INSERT INTO jni_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sa azi shi sa iwuza we imum iburu irusa ya nya ahana ashi me umum irere. Ahana ahira Aco ushi me sa maraa uzezsere, madi bibe bilau ba sere bige sa wa tiri me tari? ");
INSERT INTO jni_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ure uganiya, sa ye mazinu suso agbērgene anipum ure ubabbana. Uganiya sa ugbergene masuri, unu me sa mazi ubabbana mā buki tize. Abini me ni ori nanu ni kunna biyyau! ");
INSERT INTO jni_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Abanna me, aye anyimo anabu wa guana, “In nikara ni Ba'alzabuba ugomo wa gbergene mani māzinu suzo agbergene. ");
INSERT INTO jni_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aye wa masa me, wa nyara uguna wa bezi we uzina uire imum usuro azezsere. ");
INSERT INTO jni_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Abini me sa Yeso marusa a buru awe me, “Vat tigomo be sa ta harzina kare, ina je adini, tamare ini inome, ikure in akura a harzina kare, ina je nan ani a rizo in nome. ");
INSERT INTO jni_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inki bibe biburu ba harzina kare ina je nan bini nibin, adiwu aneni tigomo ti meme ti rusi utonno? Abanna ya guna agi in suzo agbergene in nikara ni Ba'alzabuba. ");
INSERT INTO jni_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Inki ma suso agbergene usuro Ba'alzabuba, ahira ande sa wa tarsa shi wa suso agbergene me? Barki anime, we wani wadi cukuno shi anu yesi utize tini kobbi. ");
INSERT INTO jni_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Abanna me in ahira Asere ani in suzo agbergene, ya cukuno uguana tigomo tigomo-Asere ta aye ahira ashi me. ");
INSERT INTO jni_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Inki unubu una nikara, una tirunga tinikono madi ke matonno a kura ame ani, tironga time me tidi suri. ");
INSERT INTO jni_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Inki ure unu uge be sa mateki me in nikama ma aye mare nikara nime, madi zaki tironga timi kono ahira unu me, makuri ma humuko tironga me. ");
INSERT INTO jni_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Desa zo me nigoo nan me, ishina ini mazin nan nan me; desa ma zome unu orso nan me, mazinu samara me uni. ");
INSERT INTO jni_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Inki bibe bizenze ba suro anyimo unubu, make matarsi ti hira ti huu mazinu nyara ahira be sa madi venken. Inki daki makem ba, aguana, 'Tonno in akura am sa ma suroni. ");
INSERT INTO jni_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uganiya sa maze, makem a visa akura me, a kuri abarka ani lau. ");
INSERT INTO jni_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Madusa mazika are gbergene wani sunare agebe sa wateki me ini imum iburu, wa ē wa cukuno ahira me. Umaska unu ugino uteki utuba me unu zenze. ");
INSERT INTO jni_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya cukuno, uganiya sa māzin unboo timūmuū tigino, ure uneh mahira anyimo ani gura me mayeza nigmirang magun me, a buru sa a yoo arere ani ahira Asere, nan nihene sa wa hanzi. ");
INSERT INTO jni_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Me makuri magu ana rere wani ande sa kunna tize ta Asere wakuri wa tarsi tini. ");
INSERT INTO jni_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uganiya sa anu waraa anyimo u eze ayimo u eze ahira ani ori, mahaa matubi maguana, uge cara me, u cara uzenze uni. Unyara uira ure imum, imum be sa unyara uguna anya uni une uni gusi uyunusa. ");
INSERT INTO jni_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Barki gusi yunusa sa ma cukuno imum uira ahira anu neneba, animani ahira avana unuba madi cukuno imum be anyara sa u ira uge ucara me. ");
INSERT INTO jni_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Korimo ukudi, madi tonno ma bui tize tini kobbo nan nabo ucar uge me, wadi kuri wa huzi we. Abanna me, ma aye ahira a put barki ma kunna urusa utize ti sulaimanu. Abanna me uye mayenne sa mateki Sulaimanu me. ");
INSERT INTO jni_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anu Neneba wadi tonno atize tini kobbo nan nu ucara ugeme, wadi kuri wa huzi we. Abanna me wa kunna tize ti Ugomo-Asere ahira Yunusa wanno wa kabi abanna me uye ma yenne sa mateki yunusa me. ");
INSERT INTO jni_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Daki uye marani sa madi 'Ponsi' upitila ma hunze unin, nyani ma impi uni unu ucorom, abanna madi inki uni ahira aticukun ti uni barki vat de be sa ribe anyimo udenge me ama iri masaa me. ");
INSERT INTO jni_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aje ashi me ane ani upitila ushi me, inki aje ashi me ahira memerom, apum ashi me adi minca in masaa, abanna me inki aje ashi ada hira memorm ba, apum ashi me adi cukuno in mariu. ");
INSERT INTO jni_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wusani Seke, barki kati masaa me macukuno shi mariu. ");
INSERT INTO jni_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Inki vat apum ashi me aminca in masaa, mariu mazoni ko cingilin, vat apum acukuno gusi upitila uge sa uzin in masaa ma uni ahira a “Shi me”. ");
INSERT INTO jni_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Uganiya sa māmari tize me ure ubafarise magu ame ma ē akura ameme mari imare, Yeso maribe macukono. ");
INSERT INTO jni_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ubafirse madusa makunna biyyau barki ma iri me ma dunkuno aree imare saarki ukpico utari. ");
INSERT INTO jni_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Abanna me ugomo-Asere magua me shi Afarisiya ikpicjo kamaru kisso nan u isso idang, abanna a nyimo me a ciki in madini nan mu mummu gbem amu ruba. ");
INSERT INTO jni_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Shi anabu anuu uzatu ubasa utize, debe sa mabara matara me daki memani mabara anyimo me ba? ");
INSERT INTO jni_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nyani imum be sa izi yanu dira abanna vat imumu idi cukuno shi lau. ");
INSERT INTO jni_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Abanna me, kash ushi anu bezi urusa, ayenne ikapsa bi inde azezsere ukirau umu pene, nan ti tuni-tizuu nan kondi tiya titene tu nyinza u gmei, abanna me ya samirka imum ihuuma nan irere ya Asere. Gbas ini a wuzi imum irere, ti hem Asere, a wuzi ukasu ati roronga. ");
INSERT INTO jni_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kash ushi anurusa, barki inyara anya tihira titicukum tirere anyimo ati denge ta Asere, akuri a Issi shi a u usi shi ninonzo anyimo ukasuwa. ");
INSERT INTO jni_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kash ushi izi kasi mucau sa daki awuzi muni uraa amaru ba, anubo wanno wa haka azezsere amuni azo uguna warusa ba. ");
INSERT INTO jni_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ure unu bezizi anyimo anu rusa Ayahudawa mā kabirka magua we, unu bezizi imum be sa wa buka ya caran duru iriba cangi. ");
INSERT INTO jni_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeso magu, “Kash ushi anu bezizi utize! Abana ya cana unu ucira ugilak ugebe sa teki nikara vat. Abanna shi, in nipo ma daki ya dara tironga me ba. ");
INSERT INTO jni_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kash ushi, abanna me ibara tiroronga ti ringizi amucau ma a dura Asere ayene unu uneze unu uneze ushi memani wa huu me. ");
INSERT INTO jni_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ya cukuno ane unu guna irusa inti hara tinu uneze-uneze ushi me, barki we wa huu ana kudura ka Asere sa iringizi in we. ");
INSERT INTO jni_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Barki agino abanga urusa Asere wagu “Indi tumi ahana kadura nan ana dura ka Asere ahira aweme wadi kuri patti we, wa huuzi aye anyimo awe me. ");
INSERT INTO jni_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ucara ugene me, udi ziki kaduma ka mayye mana kadura Asere sa ahuu datti utuba unee. ");
INSERT INTO jni_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Usuro amayye mattabila uhana ama Zakariya unuge sa ahuu atii hira utonzino unu tize ta Asere ti lau. Ee, mabuki shi adi nyari mayeje magino me ucara ugino me. ");
INSERT INTO jni_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kash ushi, anu bezizi urusa uti ze ta Yahudawa, barki ya zi kani imum ipoko ana tukumm urusa, shi acce ashime daki ya ribe ni ba, ya kuri ya kanti anu rie-uribe. ");
INSERT INTO jni_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sa Yeso ma ceki abanna me, unu nyetike nan Farisayawa wa wuzi ni eru nan me, wa wuzi matara nan me ti roronga gbardang. ");
INSERT INTO jni_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wazin unu nyara uti nah be sa wadi maki me anyimo a gbarang sa mazinu uboo me. ");
INSERT INTO jni_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Inu daddakino cingilin, sa anu gbardang ya orno in nu pattla ace aweme, matunguno atize nan na ahana akatuma ka meme, wuzan seke ini imare ya Farisiya, ige be ine ini malim. ");
INSERT INTO jni_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abanna me iremum izoni sa ada poko ini ba ire imum ikuri izo ni sa ada rusa ini ba. ");
INSERT INTO jni_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Barki anime ire imum izoni sa idi boki ani hungi ige be sa ine ini ige be sa ada kunna ini a masaa. Imum be sa ya wuza bikum anyimo ani kira adi wuzi tize ti timi vat ti hi hira. ");
INSERT INTO jni_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","In boshi aroni am, kati ikunna biyyau ba ande sa wadi huu nipum, wazome in ire imum sa wadake wa wuzi ini. ");
INSERT INTO jni_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ceki in gbarka shi ahira de sa idi kunna biyyau bu me, kunnan biyyau bi de sa madake mahuu makuri mareki shi anyimo uraa. Ee in boshi kunnan biyyau bime. ");
INSERT INTO jni_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","In gusa a siza ahana amu nyin muni cibi in ma nini mani mare ba? Vat anime, Asere mada parke me unu inde anyimo aweme ba. ");
INSERT INTO jni_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aname ticce sa tira ani ce ni shi me marusa ugbardang utini, kati u kunna biyyau, shi itekin imum izenze unu gongo ahira ameme. ");
INSERT INTO jni_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","In boshi, vat de sa madi buki imum be sa mabuka aje anabu, van unubu madi bezi me ahira Asere. ");
INSERT INTO jni_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Abanna me vat de sa ma nyare me aje anabu, adi nyare me ahira Asere. ");
INSERT INTO jni_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Vat de ma buka tize aje a vana Asere adi kpici madini me. Abanna me vat de sa macara bibe bilau ba Asere ada kpico me mame madini me ba. ");
INSERT INTO jni_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Inki wa ayen shi aje ana tize nyani aje anu atize tini kobbo, nyani aje ana nikara, kati i kunna in ni mum be sa idi buki ine ini icukuno kadura kashi me, nyani imum be sa idi buki. ");
INSERT INTO jni_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Abanna me bibe birere bidi bezi imum be sa idi buki uginiya ugino me. ");
INSERT INTO jni_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Uye anyimo ani ori magun me unu bezizi buka uhenu tize ti hari imum be sa a cekin dura ni. ");
INSERT INTO jni_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeso magun me, “Hu, aveni adaki uwum in cukuno una tize tini kobbo nyani in cukuno a tii ashime?” ");
INSERT INTO jni_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Abini me, magun we “Hirani kati icukuno ana re ama roo, Abanna daki imum me im sa unu makem ini gbardang idi cukuno me ukanna uronta umeba. ");
INSERT INTO jni_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Uganiya me uni Yeso mabuki we ure ugunkuno, māgu ugunkuno, māgu, “Uruu ure unu wa nya bissana birere kang. ");
INSERT INTO jni_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma bassa imum iriba māgu, indi wuzi ane ni, barki inzom inahira sa indi in bissana ba re? ");
INSERT INTO jni_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Madusa magu, in rusa imumbe sa indi wuu, indi pusi tikere tum in zui tire ti dadan-dang abine ani indi inki bisana bum nan vat tirononga tum. ");
INSERT INTO jni_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","In gu ini vai im, ivai im, uzin ini imuni gbardang sa a inko barki hu, ayyene udi venke, urii, usi, uzi iruba irom. ");
INSERT INTO jni_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Abanna me, Asere magun me, unu udira unicce, anyimo aniye nige me anyara ivai iweme ahira aweme. Tironga sa wa oro wa barka nice niwemen, ya veni idi zi. ");
INSERT INTO jni_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ani mani desa ma oro nicce nime imum unee mazi, in mazo me in ni imum une ahira Asere. ");
INSERT INTO jni_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aleso magu ina kadura kameme, “Barki anime in gusa shi, kati i kunna zenze iruba ishime abanna me, imum besa idi re, nyani imum be sa idi soki apum ashime. ");
INSERT INTO jni_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Abanna me ivai iteki imare, nipum ni ti ronga. ");
INSERT INTO jni_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Irani magoron sa mada wuza ti bira, wada orso bisana. Wada zome intigere nyani ti denge tu inzo imummu, abanna Asere ma nyinza imare. Shine iteki inyim unu ira! ");
INSERT INTO jni_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aveni anyimo ashime madaki umāyi unice me madaki makinki nice ni me tiye? ");
INSERT INTO jni_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inki daki ya rusa uwuza acee ashime imum be sa izi cingilin ba, nyanini ya wuna idi cari mu ruba mu shi me ahira ukasu utiro ronga? ");
INSERT INTO jni_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Irani iburi matiti ani jaa sa i uza azo agi i wuza katuma kaniba, i da rizizo me ba, in boshi, nyani Sulaimanu, anyimo ani nonzo mime me, daki ma soki tironga tige besa ta teki tiwume unu re ba. ");
INSERT INTO jni_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Inki Asere asoki makpe tironga tirere anime, kani me sati zi, nisizo akuri a wutini uraā, adi wu aneni madiri acce ma soki shi tironga, shi anu ukadura ka cin! ");
INSERT INTO jni_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kati apum ashi me awu barki imum besa idi re, nyani imumbe sa idi sii, ane ani kati i in tari atipo. ");
INSERT INTO jni_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Abanna me vat anu nee wa nyara usasana uti mummu tigino, ane ani Aco ashi me marusa inyara tiroronga tigino me. ");
INSERT INTO jni_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Abanna me, nyaran nikara nu meme, tiroronga tige idi kinki shi tini. ");
INSERT INTO jni_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kati i kunna iyyau ba, shi ana a cin-ci, ina aburu arom ani Aco ushi madi nya shi tigomo. ");
INSERT INTO jni_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Zizan imum be sa izini inya anu udira. Barkan ace-ce ashi mabadau magebe sa mada cornoba, inko ni imummu ishi me anyimo azezsere abba sa ida mara ba, ahira be sa akari wadaki wahaa ba. Ijiji idaki i cari ni ba. ");
INSERT INTO jni_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Barki ani me aba sa utamani uweme urani abine ani i ruba i weme irani. ");
INSERT INTO jni_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kaskanin ujoko utironga tishi me, ihiri itonno, i cukuno upitila ushi iciki unu raa kodi uya uwui. ");
INSERT INTO jni_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ikuri icukuno kasi ande sa wazin ini nyariga ni una kura sa mazeze usuro akura ubuki, uganiya sa māze magbotiko udenge me a wa hiri debe-wa poki me ni. ");
INSERT INTO jni_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Anu kem uni lem ni huma arere agino me, anige besa Aco uweme madi Ee ma kem we waciki wazin in ni nyarga nu ze umeme. Kadura kani in zinu buka ushi, ma hiri ma tonno mawu we wa cuku suno ma nya we imare in nice nu meme. ");
INSERT INTO jni_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Inka sa akura uweme ma aye in niye nyani ina te niye, ma ken we wa ciki unu be. Ume ana nilem ni huma arere agino. ");
INSERT INTO jni_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kini irusi agino me, da una akura maka rusi uganiya sa ukari ma Ee, mada ceki meakura a meme ukari maribe ba. ");
INSERT INTO jni_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Cukuno ni ini nyarga barki i tashi uganiya sa vana unu madi ze ba. ");
INSERT INTO jni_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitrus magun me, “Ugomo-Asere haruwani uzi nu ubo uru tigege tize me, nyani vat uru ini? ");
INSERT INTO jni_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ugomo-Asere magu, “Uye una je mani unu inta utize, unu urusa abanga unu uge sa unakura umeme madi nyame arere a tari timeme, barki hiri we, manyawe imare iweme uganiya sa wuna? ");
INSERT INTO jni_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Unu kaba unu lem ni rere mani ure-re ugino, unuge sa unakura me madi kem unu wuza imumbe maguna ma wuzi. ");
INSERT INTO jni_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kadura kani, mabuka shi inda nya me vat ana kadura ka Asere tari tumeme. ");
INSERT INTO jni_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Abanna me, inki maguna anyimo iruba imeme, sa kura un da ma ze debe ba; monno ma tubi ucira are-re me, ahana wa ruma nan na eh aroni ani re-re, mari masi, i huu me, ");
INSERT INTO jni_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Una akura ure-re ugino madi ze uganiya sa ure-re ma inko iriba ba, abanna me uganiya sa ma tame ba, ma kuzi me magitu magitu, makuri patti me nande sa wazo me in biyyau ba Asere. ");
INSERT INTO jni_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ure-re ugin marusa uzina una akura ameme, abanna me daki ina barka imum be sa una akura ame mema nyara ini ba. Masi u tira nan nu cobo gbardang. ");
INSERT INTO jni_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Abanna me, me sa marusa ba ma wuza imum be sa izi re ba, mada saa ti si sari gbardang ba, vat de be sa anya me imum gbardang, adi kuri anyere imum gbardang atari ti meme. Ane ani desa nyame imum gbardang i inpp uni rubu, adi nyari imum igardang ahira ameme. ");
INSERT INTO jni_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma aye barki in wu ura unee, manyara uda zina ma wa maki. ");
INSERT INTO jni_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Abanna me, mi izi nu zoro uge sa inzin une uni adi zorom in uni, abanna me magam ini ada zina a wuzam. ");
INSERT INTO jni_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ibassa agi ma aye unee unu ronta? Ma guna a'a, abanna ma aye nu harzina. ");
INSERT INTO jni_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ana me adi anu cibi anyimo akure a inde, wadi harzina, ana taru wadi wuzi ishine nan an ware, ware me wazin nishena nan ana wa taru. ");
INSERT INTO jni_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vana nan kaco wadi wuzi ishine, nan na cee-ce, vana madi wuzi nan kaco, A ino madi wuzi ishina nan nu uca me, uca madi wuzi ishina nan ka ino, a ino uruma madi wuzi ishina nan nu ugiri me, ugiri me madi wuzi ishiine nan ka” Ino uruma me. ");
INSERT INTO jni_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","“Yeso mabuki ahira ani ori” inka ya ira azezsere abee ina dizii, a'ana me idi ki igu adi rubu ureh, ani mani idiki cukuno. ");
INSERT INTO jni_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inki updebu wa huburko u hana ukudu, idiki igu ahira azi buu, ani mani idi ke cukuno. ");
INSERT INTO jni_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ana muruba mu bit, ya rusa imum be sa inbo, adizii nan na zezsere, abanna me, daki ya rusa ubezi imum besa izinu harsa harsa ba? ");
INSERT INTO jni_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nyanini ya karti urasa imum be sa idi benki shi? ");
INSERT INTO jni_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Inki ihaza ani kobo nan nu uroni utize ti weme, nyara me ibarka una barki kati ma haa hu ahira unu baru utize kati ma wa anu mensi anu wa mekuwe wa haa hu udenge unu re-re, unu inta unu me mada be hu urusa ba. ");
INSERT INTO jni_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","mabuka we uhira kasi u wa kana a birko uda kurzo we ikirfi unu gino me ba? ");
INSERT INTO jni_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Uganiya, ara anu wa buki me Bilatus wa are galilawa samapatti maye ma weme nan nu hadaya uweme. ");
INSERT INTO jni_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeso mabirka we, Ibassa a Galilawa wagino wateki ukasu me in madini, sa wa ziti anime? ");
INSERT INTO jni_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A, a in bo shi, inda ya nya a acce ashime, lali wii kasi weme. ");
INSERT INTO jni_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nyani gusi anu siluwam ukirau ina nu witi-tari gino u husmiya wa rizi a we uhuu we, ibassa wateki ukasu wanu Urushalima vat unu cara abanga? ");
INSERT INTO jni_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Inpo shi izome ani mani, vat de sa daki manya nicce vat uwe wadi wii, ");
INSERT INTO jni_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeso mabuki agino me, ure unu ma biri upom urung inabi umeme unyara a hana dakimā kem ba. ");
INSERT INTO jni_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Madusa magu inde sa ma hira urung me, tiiue ta zige me in ezizze ahing upom ugeme agi ingazi in iremum mun ba. Ca akorko uni, A wuzi aneni a ceki uni ukursu ahira me hem anime? ");
INSERT INTO jni_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Deusa mahira urung me magu, nya uni uganiya cingun in butuko in wuu uni utenki. ");
INSERT INTO jni_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Inki wa yoo ani wee nu kuro, a memerum ini nome. ");
INSERT INTO jni_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ure uwui Yeso mazinu bezi utize, Bono me Asabar ani azi. ");
INSERT INTO jni_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ure uce mawu tiwe ukirau intini witi-tari mazin unu koni uzenze, ma ciki tungoron, da ma rusi utonno ba. ");
INSERT INTO jni_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeso ma iri me, ma ti ti me magun me, ukoni ugame ma humawe uni, ");
INSERT INTO jni_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yeso ma tāri-tāri a me, ma dusa mahiri matonno madusa nonzo Asere. ");
INSERT INTO jni_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Abanna me, una je udenge utize ta sere ma guna iruba barki Yeso mahuma unu rono Asabaci. Unaje magu ma anu, “Tu wui utasi tirani sa unu madake mawuzi katuma. Ayeni a humza shi, kati I ezi rono Asabaci ba. ");
INSERT INTO jni_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Abinime Ugomo-Asere, makabirka me, Ana Iriba ibit! Ida sapso shi izenki ishi me nyani inna amatu-kum maweme ika nyani we gmei rono Asabaci? ");
INSERT INTO jni_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uca wa kura Ibrahim, de sa bibe bi buru ba tirza tiwe ukirau in tini witi-tari. Adake a sapi me rono asabaci ba? ");
INSERT INTO jni_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sa buka anime vat ande sa nyare me wa kunna mu eh, vat ana ori wa wu iriba irom in ti mum ti humma sa mawuzi. ");
INSERT INTO jni_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeso maguana, “Ane ni adi iri tigomo ta Sere, indi kuri inki tini aneni? ");
INSERT INTO jni_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Izi kasi biho bi ukungu, sa ure unu mabiri anyimo urung umeme, usuri uzi uwuu bi titi bi dandang, inyi Ibara tisu iriri me. ");
INSERT INTO jni_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Makuri magu, in Nyanini indi bati in tigomo ta Sere? ");
INSERT INTO jni_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tizi kasi uyist sa ure uneh ma pitti nan mudu mataru mumu ina ma alkama bati mupoo. ");
INSERT INTO jni_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeso māha ati pin nan na giro, una me sa hazi Urushalima mabezi we tize ta Sere. ");
INSERT INTO jni_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uye magun me, “Ugomo-Asere, ande sa adi kabiwe wadizi cingilin ini?” Magunwa, ");
INSERT INTO jni_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Inkoni Iruba iribe ana tukum a shut, barki magunan shi, anu gbardang wadi nyari uribe abanna me wada keme uribe ba. ");
INSERT INTO jni_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Inki una kura mā impo ana tukum, idi tonno amatara imeki ukpotiko ana tukum me, Ugomo-Asere, tonno tiribe. Madi kabirka magun shi, mi intam shi nan na hira mesa ya suroni. ");
INSERT INTO jni_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Abini me idi gu, 'Tare ta saa a mu henu muweme, wa kuri wa bezizi a tina tiru. ");
INSERT INTO jni_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Abanna me madi kabirka, magu, “In boshi, intam nyani abani ya suroni ba. Seserken mi upuro, vat ushi anu wuza imum izenze! ");
INSERT INTO jni_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Adi shii a romsi ahiini uganiya sa ya ira Ibrahim, nan Ishaku nan Yakubu wanu vat ana kadura ka sere a tigomo ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wadi ezi usoro ugabas, uwatu dizii, ukudu nan Arewa, wadi re utebiri umari utigomo ta Sere. ");
INSERT INTO jni_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Irusi ini gino me, ana dumo wadi cukuno anaje, ana je wakuri wa cukuno ana dumo.” ");
INSERT INTO jni_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ahira-ahirame, are Farisiwa e wa wagun me, “Hira abame Hirudus manyara uhuna uwe. ");
INSERT INTO jni_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeso magu, hana ni ika buka udila ugino ugino unuguna, ira, ma suzo a gbergene, in humza inanu koya uwui, uwui ukutaru uni in mari kadumakam. ");
INSERT INTO jni_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Indi tarzi vat tina, ya cukuno gbas ini reje in tanu tum kani me nan ni sizo nan urono, barki daki ya wuna ure ahun una kadura ka Sere piit na nu Urushalima ba. ");
INSERT INTO jni_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Urushalima, Urushalima anu uhuza ana kadura kasere, anu tisa ande sa tumawa ahira aweme. Kani ka hono kani in nyara uguna in ori ahana aweme gusi bitukoro sa bidi ke bi ori ahana abiru anyimo magaure mabini, abanna me unyara anime ba. ");
INSERT INTO jni_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ira, a humuko a kura aweme. In bo shi sisi, ida kuri irin me ba rono be sa ya guna, imumu ire-re icukuno ahira unu be sa ma eze anyimo aniza nu ugomo-Asere. ");
INSERT INTO jni_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uru uwui wa Asabar, ma ribe akura ure unu, udan anyimo anu bezi urusa barki are imumare, anu wa zin unu wuza ume aje. ");
INSERT INTO jni_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wa iri uye aje aweme unu ukoni usum utobi. ");
INSERT INTO jni_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeso ma iki anu iso utize nan anu ubezi Urusa, “Ya wuna uri unu wuli Asabar a human unu nu, nani mmh?” ");
INSERT INTO jni_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba wa ingara tik, ba Yeso ma mekime, ma human in me, ma ceki me ma dusa. ");
INSERT INTO jni_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bama gun we, “Aveni anyimo ashime ingima zin in ku zenki nani kubarka ku rizi uwa rono Asabar, mada suso kuni debe-debe ba?” ");
INSERT INTO jni_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Da wa kabirka me imum ba. ");
INSERT INTO jni_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sa Yeso ma ira cundesa abuku we u aye unigora wa zanka ti hira ti cukuno ti huma, ba ma nyawe ure ubata ma gusin we. ");
INSERT INTO jni_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ingi uye ma beze we nigora na anya, kati uka cukuno ukwanko a huma, barki nani una hira me ma rani sa ma teki we. ");
INSERT INTO jni_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ingi desa ma bezi shi nigora me maaye, madi gun hu, 'nya unu ugino me ahira sa u cikini' Udi ku hiri in mu ime uka cukuno ahira an desa da wa bikiwe ba. ");
INSERT INTO jni_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ingi a bezi we nigora, uha uka cukuno ahira sa da azi ananuba, barki nigi desa ma beziu we nigora me ma aye, mada ke magunhu, 'Uruni' nyene aba ucukuno ni, abine ani uduku kem u nyezeni aje adesa in ciki nan we ahira anigora me. ");
INSERT INTO jni_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vat desa ma nyeze nice numeme, adi tuzo me, desa ma tuzo nice numeme adi nyezeme. ");
INSERT INTO jni_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yeso ma gun unu nume sa ma bezime, “Ingi udi bezi are Imumare inigora nani nigora, kati ubezi urom uwe, nani ami henu uwe, nani nikora nuwe, nani anu upuru uwe anu kem, kasi sa wada ke wa bezi hume, ya cukuno wa kurzo weni. ");
INSERT INTO jni_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ingi udi titi nigorah u nyari anu dira, nan adesa wa ke wa wu ure uwunaba, nan anu zatu tibuna nan arubo. ");
INSERT INTO jni_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","udi kem ure aje barki sa da wa zin unu nā u kurzo uweniba. Adi nyawe ure aje uwui u hira ana imumu i huma?” ");
INSERT INTO jni_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Unu inde sama ciki nan na nanu sa Yeso ma kunna ani me, magun me, “Ure aje ucukuno ahira desa madi ri a kura Asere”. ");
INSERT INTO jni_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeso magun me, “Ure unu mani ma bezi nigora ni dang ma bezizi anu gbardang. ");
INSERT INTO jni_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Uganiya unigora u ē, ma tumi urere umeme maka guna an desa ma beziziwe, “Ayeni, amu mara ubara adadu Vat. ");
INSERT INTO jni_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Vat uwe, wa tubi u boo imum igebe sa idi kartiwe u aye ahira nigora me. Unu utuba magun me, “In zi unu ruu, indi ha inka ira, cekum in ha. ");
INSERT INTO jni_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Uye magu, “Makwa inaa ya fara inu cibi in nyara in ka bata ini, Cekum in ha. ");
INSERT INTO jni_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Uye magu, 'ma wuza a nya, barki anime inda kem u ayeba. ");
INSERT INTO jni_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sa Urere ma ze ma buki Sakurame vat imum igino me, sakura ma kuna iriba, magun unu rere umeme, hana debe utarsi tina tini pin nan ti hira ti cukuzino, u em inanu uzatu nikara, nan an desa wada ke wa wuzi ire imum ba, arubo nan anu zatu tibuna' ");
INSERT INTO jni_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Urere magu, Sakura, Imum me sa wa buka amara, anime ahira arani. ");
INSERT INTO jni_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sakura magu urere me, hana, ka tarsa tinaa, nan ti hira ti cukuzono ta amani pin me, utisam anu, barki akura am a myinca. ");
INSERT INTO jni_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","In zinu booshi, an desa ma bezizi we unu tuba sa madi donkino nigora num. ");
INSERT INTO jni_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Abini me, nigora nanu wazin in tanu nan me, ma gamirka magu, ");
INSERT INTO jni_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Vat desa madi ē ahira am in daki ma game acu me, nan ka ino me, nan une me, nan ahana me, nan anu henu me ahana aroma nan nane, mada ke ma cukuno unutarsa um ba. ");
INSERT INTO jni_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Vat desa dama zika uzito ume matarsam ba. Mada ke macukuno unutarsa umba. ");
INSERT INTO jni_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aveni anyimo ashime sa ma nyara ubara akura, mada cukuno me urso imum igebe sa madi hu, nani mazini ikirfi me sa idi bari me umara ukatuma me? ");
INSERT INTO jni_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kat i cukuno sa ma mara unuka udenge me ugame umara, vat adesa wa hira me wa tubi me nibasa. ");
INSERT INTO jni_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wa gusi, unu ugemani matubi aso da ma masizikime umasirka me. ");
INSERT INTO jni_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nani uya ugomo mani, ingi ma haza nikono nan ure ugomo, maki da cukuno ma bati tizze ma iri me unami madubu akure ukirau (10,000) mada ke maka wuza ukara nan ugomo sa ma zin nanu anikara madubu akure are (20,000). ");
INSERT INTO jni_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ingi mada rusa ba, dati a unigino mada pit, na ma tumi aka iko una ticukun tihuma. ");
INSERT INTO jni_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ane ani, ba uye anyimo ashi desa dama ceki imum be sa mazini ba, mada ke ma cukuno unu tarsa um. ");
INSERT INTO jni_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Muhu imum ini ihuma, ingi muhu curnome, in nyanini adi barka munini? ");
INSERT INTO jni_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Muzome in ire imumuwaza adizi, nani mu cukuno uteki. Senke akwankoni cas. De sa mazi in titui ti kuna na ma kunna. ");
INSERT INTO jni_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vat anu u kabsa ikirfi ima nyanga nan anu amadini wa ezi ahira a Yeso wa kunna ume. ");
INSERT INTO jni_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Vat afatisiyawa nan anu yetteke wa zi unu humuro acece aweme, agi, “unu ugeme mazi unu kabsa anu kabsa ana madini, wa rē imumare nigome.” ");
INSERT INTO jni_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeso ma buki ubata uginome, magu. ");
INSERT INTO jni_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ingi uye shime ma zini itam inu akuri ukirau(100), bi inde be hunne me, mada ceki me ina kuri turwai in nanu turuwI(99), igino me ahira ukese, ma tarsi bi inde be sa ba hunne me maka tinka bini? ");
INSERT INTO jni_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ingi maka tinka, madi tari agirza ini iriba irum. ");
INSERT INTO jni_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ingi maze akura, m titi aroni nan anu uppru umeme, magu, benkini mi iriba irum barki ma tinka ku tam me sa ka hunne mi. ");
INSERT INTO jni_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","In boo shi, ane adi wuzi uriba irum anyimo Aseseri, ahira uni imum iburi sa ma kaba tize ti Yeso, ma teki ana kuri turwai ina nanu turwai (99) adesa wa zome ini riba ukaba u Yeso. ");
INSERT INTO jni_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nani uya unemeni, ingi ma zini ikirki azumo akelkel anu ukirau(10) ingi biinde ba hunne me, mada wuna me ura ubitila ma visi akurame, ma dingi unyara me barki ma tika? ");
INSERT INTO jni_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ingi ma tinka madi ori oromi ameme nan anu upuru umeme, magu, benkini me iriba irum barki matinka bi kirfi bumme sa ba hunne me. ");
INSERT INTO jni_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ane ani boo shi, imummu iriba irum ini ahira ahana kadure ka Asere ingi una madini u inde ma kaba Yeso. ");
INSERT INTO jni_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ba Yeso magun we, uye ma rani mazina ahana ware aruma. ");
INSERT INTO jni_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kuci me anyimo ahana me magun in kacoo uweme, acoo, nyam ukalum um anyimo imumbe sa uzini, ba acoo me hari we imumbe sa ma zini karee. ");
INSERT INTO jni_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tiye ti akici, vana unezeme ma ori vat tirunga tumeme, ma meki unā uhana anire nipit. Abine ani maka huna ikirfi imeni, ma kpiji imumbe sa ma nyara, mahu ikirfi imeme ahira katuma kaburi. ");
INSERT INTO jni_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sa ma mara u huna imumbe sa mazini, awuzi ikomo idandang ani pim me, ma ribe udira. ");
INSERT INTO jni_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Maha maka nyara katuma ahira uye una nipin me, ma ziki me katuma kunyinza maladu imum are. ");
INSERT INTO jni_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Maka kuna are imumare imaladume barki da a nyizi me imumare ba. ");
INSERT INTO jni_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sa iriba me ya koro ahira me, magu ana katuma ka acoo am, am wani wazin in imumare sa ya bar we, mi be indi wi barki ikono. ");
INSERT INTO jni_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Indi biri in ha ahira'”acoo am, in ka gunan me, acoo am ma wuza aseseri imum iburi, makuri ma wuzo weni. ");
INSERT INTO jni_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Da ma bari akuri agun mi vana uwe ba, kurzom gusi anyimo ana katuma ka akura aweme.” ");
INSERT INTO jni_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ba ma hiri ma dusa ahira acoo me. Datti mazi pit, acoo me ma iri me ugogoni u meka me, dusa unu sum maka meki me ma gbendiriko. ");
INSERT INTO jni_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Vana ma gun me, ma wuza Asesere imum ima dini ma kuri ma wuza we. Da ma bari utitim vana uweba. ");
INSERT INTO jni_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Acoo me magun na arere akurame, wuzani debe i ēn unu dibi uriri, isoki me, sokini me bicofo atari timeme nan akwatak ati buna tumeme. ");
INSERT INTO jni_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aka nyara ku naa sa inta akura, aweki, ti wuzi nigora. ");
INSERT INTO jni_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vana um ma wi ana me ma zinu vengize, ma hune me ana me a kem me, watubi are imumare. ");
INSERT INTO jni_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Uganiya nginome, vana u unu ma ra uru, sa ma aye mamu in nakura, ma kuma azin unu tira umanganga nan murso. ");
INSERT INTO jni_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Matiti ure urere akura me, ma iki me nyannini azini wuza me anime. ");
INSERT INTO jni_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Urere magun me, uhenu uwemani maze akura, acoo aweme ma weki ku naa kugino, barki maze akura merum. ");
INSERT INTO jni_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Uhenu me ma kuna iriba, ma game uribe akura me, acoo me ma suri ma rigaga me. ");
INSERT INTO jni_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ya u unu me magun inka acoo me, ira vat ugbardang uti wee ti geme in zi in nirere dama mamu cara we iribani ba, vat anime da wamu nyan ku naa sa s indi wuzi nire ni hara nan runi am ba. ");
INSERT INTO jni_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sa vana uwe ugino me maze desa ma poki we nirubu unu kem uweme ahira anee uziza arubu, wa weki me kunaa ku naa ku ginime. ");
INSERT INTO jni_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Acoo me ma gun me, vana um, tizi na hu kondi uya uwui, vat imum be sa izi in iwe ini. ");
INSERT INTO jni_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ya wuna uri awuzi iriba irm, barki uhenu uweme ma wi, a' ana me ma vengize, ma hunne me a kem me. ");
INSERT INTO jni_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeso ma gu inanu utarsa umeme, “Awuzi ure unu mazi ini kirfi mazi indesa matarsa me ini kirfi me, a ē agun me unutarsa ini kirfi iweme ma huza ini Sarki nice. ");
INSERT INTO jni_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Unu kirfi me ma titi me magun me, nyanini in kuna ani ce nuwe me? Aye mu ini benani ikirfi me, barki uda kuri u tarsum in ini ba. ");
INSERT INTO jni_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Unu tarsa ini kirfi me magu iriba imeme, “Indi wu aneni, una kura madi kabi unu tarsa ina kura ame a tari tum? Mebe, in zomu in nikara na avara in kunna mu'i'in iki imum. ");
INSERT INTO jni_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","In rusa imum me sa indi wu ingi a karam u tarsa ina kura me, Anu wa kabum ati kura tuweme. ");
INSERT INTO jni_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Unu tarsa ina kura me ma titi an desa una kura ma tarsa me ureme, magun unu nutuba ihuno ini una kura matarsa we? ");
INSERT INTO jni_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Magun me, magarwa ma mani manu akuru ukirau (100), Magun me, 'Kaba utagarda uweme, cukuno debe, u yetteke akuri ucibi! ");
INSERT INTO jni_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma kuri magun in uye, 'Ihuno ini una kura matarsa we?' Magu, ma buhu manu akure u karau me ialkama, magun me kaba utagarda, u yetteke manu akure uwiti tari (80). ");
INSERT INTO jni_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Una kura ma nonziko unu tarsa ina kura me barki upoko aje ameme. A hana une ugeme wa ribeze anyimo anu nee wa aka ahana masaa. ");
INSERT INTO jni_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","In booshi ingi ya wuza ni runi gusi imumu un barki uzatu kadure, ingi ya mara, wadi kabi shi ati kura tishime ana imumu muriba. ");
INSERT INTO jni_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Desa ma wuga kadure imum icin, una kadure mani imum idangi, desa mazome inkadure ba a hira imum icin unu zatu kadure kani udang. ");
INSERT INTO jni_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","In daki ya wuza kadure ahira imum unu zatu kadure, aveni madi hem inshi ini mum ika dure? ");
INSERT INTO jni_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ingi daya kuri ya wuza uzatu kadure ini kirfi i uyeba, aveni madi nyashi i kirfi sa izi ishi? ");
INSERT INTO jni_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ba desa mada ke ma tarsi Asere kare, nani ma game a inde ma hem a inde, nani ma hem ina inde magame a inde ida ke i tarsi Asere i kuri i tarsi imumu une ba. ");
INSERT INTO jni_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafarisawa anu su ikirfi sa wa kunna ani me vat watungono tizuza tume. ");
INSERT INTO jni_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ba ma gun we, “Shewani anu nyeze ace anyimo anu, Asere a rusa iriba ishime. ");
INSERT INTO jni_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ubata utize nan anu kurzizo utize wa rani Yohana madiku ē. Datti uganiya ugino me azinu boo tize ta Asere, kodavi mazini uyakara u sosi niceni anyimo me. ");
INSERT INTO jni_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Vat in anime, iteki unu seke Aseseri nan adezi amari, ini gona horibi inde be tize tum bi visa. ");
INSERT INTO jni_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Vat desa ma gido unē umeme ma zika uye ma zinu wuza katuma kaburi, desa ma zika unē me sa agido me vat mazinu wuza katuma kaburi. ");
INSERT INTO jni_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Awuzi uye unu imumu itari, ma sositi runga ti huma ti kirfi madi gala imum ime kondi uya uwui. ");
INSERT INTO jni_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A inki uye sa mamu uzo ana tukum ameme, unani 30 Liazaru desa vat nipun numeme tinuru tini. ");
INSERT INTO jni_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Madi isi iriba agi matingi mu gitu mu imumare sa idi rizizi adizi barki ma ti iwuxi cangi iki limbi magembu mameme. ");
INSERT INTO jni_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Arā anyimo anime unu dira unikara ma wi, ibe ika dura ka Asere wa ē wa ziki me wa hamme a hira Ibrahim, Unu imum itarari ma wi, a vati me. ");
INSERT INTO jni_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma rā nyimo icau unu zito, ma venki nice ma iri Ibrahim pit, nan Liazaru a bigiri bumeme. ");
INSERT INTO jni_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma titi magu, “Acoo Ibrahim, kuna ugogoni um, u tumi Liazaru ma soki kubo kucin kumeme a mei ma tenzikem ani lem, barki nirere nini izinu same anyimo Urā. ");
INSERT INTO jni_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ibrahim magu, 'Vana, ringi inti cukum tuwe unē uwe, ukuri ukabi adadu a huma, me Liazaru nirere nini masi. A' aname urunta uni azinu nyiza ume abame, hu ni rere nini uzi na same. ");
INSERT INTO jni_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ban anime, uwaa u concon urani, barki an desa wa nyara wa kafa uaye ahira ashi kati wa rusi, kati kodavi makafa uaye uwatu uru. ");
INSERT INTO jni_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Una imumu itari magu, 'In nyara, acoo Ibrahim, tuma me ma hā akura acoo am'. ");
INSERT INTO jni_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Barki in zin ina nuhenu aruma ucibi, ma ha maka wuza tize kati wa ē ahira ani rere nigeme. ");
INSERT INTO jni_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibrahim magun, 'Wa zin Musa nan anu u kurzizo tize ta Asere, na wa kunna we. ");
INSERT INTO jni_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Una imumu itari magu, 'Mmh' acoo Ibrahim, ungi uye ma hana ingi uye ma hana a nyimo adesa wa wono wadi kunna we, wa kabi tizeme. ");
INSERT INTO jni_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibrahim ma gun me, 'Ingi daki wa kunna Musa nan anu ukurzizo tize ta Asere ba, koda uye ma hira anyimo anu won cangi wadida kunna we ba. ");
INSERT INTO jni_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeso magu nanu tarsa umem, ya cukono animetire timumu tiwuzan duru tipiko, senke ushi sa udi eh anice ni uye. ");
INSERT INTO jni_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Uteki in ka a wuna nipa ni iriri, a soki we a nyimo a niwun, kati ma wu a hana wa rizi. ");
INSERT INTO jni_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hira nice ni weme, inka uhenu uwe me ma chama, gbarka me, inka ma gamirka, kati iriba iweme. ");
INSERT INTO jni_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Inka ma chara we iriba kanu sunare, ma kuro kanu sunare, unu guna, ''Maceki'' ya cukumo iriri, kara iriba. ");
INSERT INTO jni_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Anu tarsa wa gu imme, ''Kinki duru nikara ni tarsa uwe me,'' ");
INSERT INTO jni_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Unaa kura magu, ''Inka izinni inlo iriba gu biho bi titi u mastad, idi gu unnutiti, ''Ta rufa,'' a nuka a nyimo ani gwin,'' udi wu imumsa wa buka. ");
INSERT INTO jni_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Senke aveni a nyimo a shi me, ma zinnu rere in katuma uuu nani itom, madi buki me, inka ka aye usuro anijaa, aye uri, imun are? ");
INSERT INTO jni_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma nyari me u buka urere me, siram ire imumare tira nitira a tiruma tiwe me, uhem in mari are me. Hu uri inna dumo ");
INSERT INTO jni_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma gunme u guna urere me tononzo barki ma wuzi imumsa a dungurkame, ma wu? ");
INSERT INTO jni_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Shi me cengi, inka ya wuza vat imum udungurka me, idigu, ''Taa bari ba,'' ti wunn imumsa a buka duru. ");
INSERT INTO jni_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A biki uganiya a sa maaribe Urshalima, ma ha ubinani usamariya nan uGalilee. ");
INSERT INTO jni_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sa maribe a nyimo anigiro, monno ma gurna nan are anu ukirau a kuturu. Wa tonno piit. ");
INSERT INTO jni_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wa yeze a mgmirang wa gu, ''Kunna ngogoni uru, Yeso.'' ");
INSERT INTO jni_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sa ma iri we ma gu in we, hana ni ika bezi unu inusa tizeta sere. ");
INSERT INTO jni_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unu inde a nyimo a we me sa ma huma, ma gamirka innu gmirang ni dandang innu honzo Asere. ");
INSERT INTO jni_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Maa tunguno a tibuna ti Yeso, inna puru arom, uSamariyawa mani. ");
INSERT INTO jni_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeso ma gu, ''In gusa ani kirau wani wa huma? anu uuro wa ra? ");
INSERT INTO jni_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Daki akan uyesamakuri wa nonzo Asere ba Senki ugenu ugeme? ");
INSERT INTO jni_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma gu imme, Hira u dusa! Kadura kawu me ya wuna wa hum.'' ");
INSERT INTO jni_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sa anu ubazi urusa wa iki, rono u aye Asere Yeso ma kabirka we magu,'' A kura Asere ada aye barki ugamara a nu ba. ");
INSERT INTO jni_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nani wadi gu, ira, iyenne! nani, ira a birko, Akura Asere a raa anyimo a shime. ");
INSERT INTO jni_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma gu inna nu atarsa umeme, tiye ti eze sa idi inki iriba u ira u vanna sere, idi kaa ira me ba. ");
INSERT INTO jni_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wadi gu inshi, ira, a birko, ira, a banna, kati isuri a matara nani itar si we ba; ");
INSERT INTO jni_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gu u wuna a hira mel-mel a hira a zesere uhana are me, a nine ani vana Asere madi zo rono uwui umeme. ");
INSERT INTO jni_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Senke utuba me madi zitti atinaa sasas ani wadi nyari me. ");
INSERT INTO jni_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","U ganiya ugeme, gu a tiye ti Nuhu anime ani atiye ti vana unubu. ");
INSERT INTO jni_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Waari, iva sizi, wa wuzi anya, a nyizi we anya senke rono sa Nuhu ma ribo a nyimo u zirgi, urigawa ma eh mahuu wevat. ");
INSERT INTO jni_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A nime ani ya kem ani atiyet Lot, wa zin tire, ukpija nan nu ziga, tibira nan asoh. ");
INSERT INTO jni_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Senke rono sa Lot ma suri a nyimo u Sodom, a rubi ure ura a zesere wa huu we vat. ");
INSERT INTO jni_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A ne ani idi zi rono u aye uvana unu. ");
INSERT INTO jni_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A nyimo rono me, katli iceki unu sa ma raa azesure a kura matuu uzika tirannga a kura ba, kati a ceki unu uge sa mara a masa a makuriba. ");
INSERT INTO jni_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ringin une u Lot. ");
INSERT INTO jni_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Unu uge sa ma zinnu nyara wai imeme madi diri ini senke unu uge sa madira ivai imeme madi kem ini. ");
INSERT INTO jni_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma buka shi, aniye nigeme adikem ana ware warari ukomi, inde aziki unu inde a ceki unu inde. ");
INSERT INTO jni_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A di kem ane ware iti nanzu, a ziki unu inde a seki unu inde. ");
INSERT INTO jni_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anu war a uruu, adi ziki unu inde a ceki unu inde. ");
INSERT INTO jni_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wa iki me, abba una kura? ma gu in we, a hira sa ikizi irani magbuluk cangi wadi ornon. ");
INSERT INTO jni_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ma buki we tize ta nyimo, abanga a birangara ko uya uganiya. Katti wa kuri inna dumo. ");
INSERT INTO jni_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Innu gusa, “Anyumo nire nipin ure unu urusa tize ma zo meni biyau ba Aere ba dāā ma hiri anu in tice ani ce ba. ");
INSERT INTO jni_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ure ukoro ma rani a nyimo ani pin ma ziki innu eze ahira a meme, unnu gusa, “Ben kim in kem in suri a tari ti nu ukara um. ");
INSERT INTO jni_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A tiye joko ma zunusu ma benki meba, kamarka tiye cin magu nice nimeme, inda zom biyau ba Asere ba nannu hira anabu gu imum ba. ");
INSERT INTO jni_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Barki ukoro ugeme ma hum nipum. ");
INSERT INTO jni_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Asere magu, “kunna imum ige sa unu rusa itize ma buki. ");
INSERT INTO jni_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A ana Asere mada ayen kadundere a hira anu zonka sa wa zin na so innu wui nan niye ba? ");
INSERT INTO jni_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ma buka shi agi madi e in kadundere debe. anime ani, inka vana Asere ma aye, madi kem u inko iriba a ma nyanga? ");
INSERT INTO jni_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Monno ma kuri mabuki tize tanyimo a ayesa wa inki iriban agi wa zi lau wa izi aye. ");
INSERT INTO jni_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Anu are wa ha udenge ASere abiringara, anu bezi urusa nan nu kabsa ukirfi. ");
INSERT INTO jni_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Unu bezi ursa ma tonno in biringara anice nimeme, akari, anu imum ibur, anu tozoin na ney nani gu unu imum ibur, anutozo in na ney nani gu unu ukabsa ikirfi igeme. ");
INSERT INTO jni_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","In kee in gam ure imum are kare ka tiya tiye sunare, in nyiza udukym anyimo ukirau vatimum sa ma kem. ");
INSERT INTO jni_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Senke unu kabsa ikirfi me, maa turi put, ma yeze aje a sere senke ma vavi nihenu ni meme, unnu gusa, Asere kunna ugogoni um una maa dini”. ");
INSERT INTO jni_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma gu imme, unun ugeme makuri a kura ameme lau, ma teki uroni me, barki vat unu uge sa ma yeze nice nimeme adi yeze me. ");
INSERT INTO jni_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anu me wa kuri wa e inna hana cincin, barki wa dari we, senke anu tarsa wa iri waa gwarika me. ");
INSERT INTO jni_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Senke Yeso ma titi me, innu guna, cekini mu hana mu cincin wa e a hira am, kati ikarti weba akura Asere awe ani. ");
INSERT INTO jni_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kadundere ma bukashi, unu yesa ma nyari me ukaba a kura Asere gu vana cingilin, madaa ribe a nyimo ba. ");
INSERT INTO jni_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ure unu ugomo ma iki me, u nyettike, indi wu aneni in kem urai wa Asere? ");
INSERT INTO jni_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeso magu imme, nyani utisam unu uriri? unu uriri mazoni senke Asere cas. ");
INSERT INTO jni_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Urusa udungurka me, kati utoti unni ney u uye ba, kati u huu uye, kati uwuzi nikari, kati u wu moco, wuza aka coo uwe me imum iriri. ");
INSERT INTO jni_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ugomo ma gu, “Vat timumum me ma wuzi dati innu ti nyani tum. ");
INSERT INTO jni_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sa Yeso maa kunna magu imme, imum ineisa wa dira. udi zizi vat imum sa uzin u nya anu dira, u kabi ya zesere, u e u tarsim. ");
INSERT INTO jni_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Senke sa ugomo ma kunna timumun me, ma kunna iriba kang, barki ikirfi imeme. ");
INSERT INTO jni_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","unnu ira umeme maa kunna iriba, magu, a ikunna. Unnu ikirfi maribe akura Asere. ");
INSERT INTO jni_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","me inna banga ba U Pakumi uribe anyimo anije ni alira, unnu guna una kirfi ma ribe Akura Asere. ");
INSERT INTO jni_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","kunna wagu, “Ani aveni madi suburka?” ");
INSERT INTO jni_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","makabirka, imum sa idaa hem anu ba idi hem a hira Asere. ");
INSERT INTO jni_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","magu, “Ba, ta ceki tirunga tiru vat ti tarsa we?” ");
INSERT INTO jni_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","magu in weh, kadundere maguna si, daki uye sa ma ceki akura ameme, uney, a henu nan aka coo, nan na hana, barki akuru Asere, ");
INSERT INTO jni_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","madaa kaba ige sa iteki uneh nannu uney u eze, urai wa Asere. ");
INSERT INTO jni_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ma ori anu tarsa a hira ameme, magu in we ira, ti haza urshalima, vat unyettike wa na kadura me abanga vana unubu idi Ngwinca. ");
INSERT INTO jni_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","nya me atari alumai, Wadi Wuzi me nieru, wa nya me mu ih wa wu me tobi. ");
INSERT INTO jni_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","wa maari utira ume, we hu me, rono utaru ma hiri. ");
INSERT INTO jni_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","rusi timumum ba, a hunze Wen, daa wa rusi ba imum sa abuki ba. ");
INSERT INTO jni_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeso ma eh mamu nan uyeriko, ure urubo ma ciki upuru una unnu nyara. ");
INSERT INTO jni_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ma kunna nigoh nanu wa aaki, ma iki, ");
INSERT INTO jni_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","izi?” Wa gu imme, Yeso u Nazeret ma aka. ");
INSERT INTO jni_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Me ma Yeze nigwiran, magu, “Yeso, vana u Dauda, kuma ngogoni um”. ");
INSERT INTO jni_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sa wa haaki aje wa gwangirka urobo me, wa gu 'imme ma ingara tik. Senke ma ru aje innu hunu kang, Vana U Dauda! Kunna ugogoni um”. ");
INSERT INTO jni_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ma tonno dang ma dungurka a eh innu nu me a hira a meme. ");
INSERT INTO jni_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","U nyara u wu we?” Magu, “Una kura, in nyara in hiri a hira?” ");
INSERT INTO jni_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma gu imme, kaba uhira, u inko iriba uwe me wa nya we ni huma. ");
INSERT INTO jni_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Me maa huma, matarsi me, unnu nonzo Asere. Anu vat sa wa iri, wa nonzo Asere. ");
INSERT INTO jni_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeso ma ribe ma hai u hana ujeriko. ");
INSERT INTO jni_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ure unu niza nimeme takka, ma zi ugomo u kabsa. ");
INSERT INTO jni_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma zin nu suu u ira Yeso, senke ma iri meba, barki ma zi kauf. ");
INSERT INTO jni_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma sumi aje ma nyene utiti ma iri Yeso, barki Yeso ma zinnu aka. ");
INSERT INTO jni_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sa Yeso ma eh a hira me, ma yeze aje ma iri zakka ma gu, “Aye debe, ka nime in di cukuno a kura awe me. ");
INSERT INTO jni_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Maa tuu debe debe, ma ziki me inna puru arum. ");
INSERT INTO jni_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa anu vat wa iri we, wa wu bibukum innu gusa, “Ma hana akura unu madini”. ");
INSERT INTO jni_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka ma tonno magu, “Una kura ira, ukasu uturunga tum in di nya dira, inka ma cuzo i uye, indi kurzo wen kani na nazi. ");
INSERT INTO jni_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeso ma gu in me, “Ka nime, ubura unice wa eye akura ageme, barki me me vana u Ibrahim mani. ");
INSERT INTO jni_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Barki vana unubu ma eh unyara 'imum ige sa ya kurno me, ma buri anu sa wa hurno we'. ");
INSERT INTO jni_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sa wa kuna tize me vat, ma tunga no uboo tize ta nyimo barki ma eh mamu nan Urshalima, wa gusi akura Asere adi kem we debe. ");
INSERT INTO jni_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ma gu ba! Ure unu ribe a mare ma nyanga a piit ma kabi akura a nice ni meme, makuri. ");
INSERT INTO jni_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma titi ukirau a nyimo anu rere me, ma nya we ikirfi ukirau, magu in we, gamara tarin wa be u aye umeme. ");
INSERT INTO jni_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Senke anu ni pin me nyari me, wa timi aye adumo ameme, wa gu, “Wada hem unu ugeme ma cukuno ugomo uruba. ");
INSERT INTO jni_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ya cukuno ani me sa ma kuuri ma eh, makabi ni nonzo, ma dungurka arere me sa ma nyawe ikirfi me a hira a meme, barki ma rusi nyanini wakem a nyimo katuma me. ");
INSERT INTO jni_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Unutuba aye a hira ame magu unakura! Unu katuma kawe me ma kinki ikirfi inu kirau a hira igino me. ");
INSERT INTO jni_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Una dandang magun me, “Gajiya, ureme uriri, barki wa wuzi katuma kang imum 'icin', udi kem nikara ni canta utibira tinu kirau. ");
INSERT INTO jni_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Uhana ukure me, mangu unakura ukure uwe me ma kem ukinki mani ciibi. ");
INSERT INTO jni_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Unu dandang magu, udi canti ti hira tinu ciibi. ");
INSERT INTO jni_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Uye ma eh magu, “Una kura! Kaba ikirfi iweme sa ma inki memerum a nyimo aturunga. ");
INSERT INTO jni_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Barki ma kumna biyau bi we me barki hu unu buru mani. Uke uziki a hira sa daa wa inkon ba, uke u ari ahira sa da wa birin ba. ");
INSERT INTO jni_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Unu udandang magu in me, “Atize tiwe me indi weki tize we me hu uburu mani. Urusa me unu buru mani, uni zinsa imum sa daa ma inki ba, unnu oro igesa da ma bira ma. ");
INSERT INTO jni_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Barki nyanini da wa inki ikirfi um me a hira u inso ikirfi ba, barki inka uganiya u kurzo ikirfi akem ya yoo. ");
INSERT INTO jni_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Unu udandang magu in nanu age sa wa turi upuru umeme. Kaba ni ikirfi inya a deesa anya manu kiran. ");
INSERT INTO jni_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wa gu imme, “Una kura'. Me mazin inu kirau. ");
INSERT INTO jni_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma buka shi, vat deesa mazin adi kinki men, senki deesa mazin adi kabi a hira ameme. ");
INSERT INTO jni_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Senke anu ishina um, An deesa wada zo me innu suu a wuzi katuma ace a we me, ayen we a hira am ihu we aje am. ");
INSERT INTO jni_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sa ma buki tizeme, ma meki una uhana Urshalima. ");
INSERT INTO jni_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Uganiya wa biki sa ma eh upuru u Betafaji na u Baitanya, a nipana sa a tisa ulivet, ma a tumi anu ware ana tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Magu, “hani a giro ukure me, inka ya ribe idi kem vana ubezenki sa daa amu tara me ucira ba, sopo ni bini i eh mini. ");
INSERT INTO jni_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Inka uye ma iko shi nyani ya wuna izinni sopo ubini? Guna, “Una kura ma nyara bini”. ");
INSERT INTO jni_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Anu age sa a tume we wa kem vana ubizenki gu ubuka u Yeso me. ");
INSERT INTO jni_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sa wa zinnu sopo u vana ubizenki me, unu ubini magu in we aneni izinnu sopo u bini? ");
INSERT INTO jni_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Waa gu, “Una kura ma zinmu suu ubini. ");
INSERT INTO jni_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wa ha in bini a hira Yeso, wa vete turunga tiwe me azesere a bini watari Yeso azesere me. ");
INSERT INTO jni_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sa ma ha, waa nati turunga tiwe uname. ");
INSERT INTO jni_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sa ma eh mamu ahira a ni pana ni o live ma tuu, vat anu tarsa umeme wa tunguno u tarsa ume unu. nonzo ume innu yeze agwiran barki vat katuma ka dandang sa wa iri. ");
INSERT INTO jni_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wa ga, “Ugomo ugongon mani sa ma di eh a nyimo aniza ni na kura. Apuru arum azesere nan ni nonzo ni dandang. ");
INSERT INTO jni_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aye anu rusa utize a nyimo anu agwardang wa gun me “Anu bezi utize, gwarika anu tarsa uwe me. ");
INSERT INTO jni_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeso ma gu, “Ma buka shi in ka anu wa wu tik, apo adi yeze angiran. ");
INSERT INTO jni_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sa Yeso ma biki a nipin, maa shii barki nipin me. ");
INSERT INTO jni_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Magu, “Inka i nisa vat a tiye tigeme, ko shi me, imum sa i eze inna purum! Senke a humze uni aje ashi me. ");
INSERT INTO jni_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ba! Tiye tide eh ace ashi me sa anushina ushi me wadi barka ugombi uhara uru, wadi kete shin wa noko shi ko uya uwatu. ");
INSERT INTO jni_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wadi vavi shi adizi nan na hana ashi me. Wa daa ciki nire nipo azesere anire ba, barki ya nyari uka ba me uganiya sa Asere ma nyari ubura ushi me. ");
INSERT INTO jni_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeso marube a nyimo udenge Asere ma tun gono u suzo anu age sa wazin bi ziza ziza. ");
INSERT INTO jni_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Magu in we. A nyettike a kura am adi cukuno a biringara, ya kurzo ani ubanku u cukuzono wa kari. ");
INSERT INTO jni_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ba! Yeso ma zinni beziza anu ko uya uwui a nyimo udenge wa Asere me. Una dang anu dungurka ma nan na nu rusa, nan na na aje wa nabu wa nyari wa hume. ");
INSERT INTO jni_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Senke daa wa kem una uwuza anime ba, senke vat anime sa wazi inna kumna ume memerum. ");
INSERT INTO jni_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sa ure uwui wa eh, Yeso mazin nu bezizi anu tize ta Asere adange ubi ringara, anu adangdang nan nanu nyettike nan na nanu. ");
INSERT INTO jni_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wa buu tize, wa gumme, “Bukan duru, nikara nu wuze uti mum tigeme ta surowe abani? nani aveni ma nyawe nige nikarame”. ");
INSERT INTO jni_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma kabirkawe magu, “Me ma indi ikishi, bukanime. ");
INSERT INTO jni_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Abanga ubaptisma u Yuhana, wa suri aseseri ani nan ahira anu ani? ");
INSERT INTO jni_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wa rusi inna ce awe, wagusi, “Inka taguna, wa suri asesere ani, madi gu, ani nyanini ya wuna daya hem in me ba? ");
INSERT INTO jni_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Inka taguna ahira anu, anume vat wadi tizin duru in na poo, barki sa we wamu zika Yuhana una kadura ka Asere mani. ");
INSERT INTO jni_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ba wakabirka wagu me we wada rusame a hirame sa ya surini ba. ");
INSERT INTO jni_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeso magunwe, “Mima inda bukamshi a hirame sa ni kara nu wuza uti mum tigeme na suri mini ba”. ");
INSERT INTO jni_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma buki anume tire tize tukama, “Uye ma biri unuu, ma nya ana vara u intame, ma dusa amare manyanga maka dadankino. ");
INSERT INTO jni_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uganiya u eze sa indi tumi una katuma kam a hira ana vara me, barti wa nyame imumme sa wa oro uruume, ana uruu waka tirame wa gidime in tari ti hura. ");
INSERT INTO jni_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma kuri ma tumi ure unu benki ume katuma, wa kuri wa tirime, wa wume ma cukuno imum imu i, wa gimdime in tari ti hura. ");
INSERT INTO jni_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma kuri ma tumi unu taru wa kunnome iwono, wa vingi me a matara. ");
INSERT INTO jni_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Anime unu uruu magu, 'Indi wu aneni? indi tumi vana uyoo um. Ba wuya wa kunna me', ");
INSERT INTO jni_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sa ana vara me wa irame, wa barka tize ache awe, wugu, 'Usanme mazikuno uru'. ");
INSERT INTO jni_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wa vete mani anatara wa hume. Nyanini unu uruu madi ki gunan we? ");
INSERT INTO jni_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Madi eh ma cari anu varsa uruu me, madi nya aye uruu me”. Uganiya me sa wa kunna anime, wa gu,”Kati Asere a hem!”. ");
INSERT INTO jni_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Anime, Yeso ma riki we aje, magu, “Nyanini ya ziginome sa a nyettike: 'Ni poo me sa anu bara uti denge wa nyarime nini nibura nu pingaru udenge'? ");
INSERT INTO jni_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Debe sa ma rizo ani poo niginome madi pusa magitum magitum. debe sa na rizo ame, nidi nanzi,” ");
INSERT INTO jni_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Barki anime, anu nyettike me nan nanu a dandang me wa nyari wa tarime tari uganiya me, we wa rusi tize tukama sa ma bu barki wewani. Agi we wa kunna bi yau ba nume. ");
INSERT INTO jni_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Innu hira ume seeke wa tuburko anu ani hunzi sa wa wuzi kasi wazi lau bati wa kem ure u sizikime a tize tumeme, bati wa tuburko me a tari tanu yorso utize a dandang ugomna. ");
INSERT INTO jni_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wa iki me, wagu, “Unu bezizi, tirusa uka ubuki ubazizi memerum, daki uya ma bari ma gamirka we ba, senke hu u bezizi umum ihuma una wa Aser. ");
INSERT INTO jni_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ya wuna memerum ti bisi ugandu ahira a kaisar, nani babu?” ");
INSERT INTO jni_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Senke Yeso ma rusi ugamara uweme, ma gun we, ");
INSERT INTO jni_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bezini mi ikirfi me, muhenu ma veni mura a ini?” wagu, “Mu kaisar muni”. ");
INSERT INTO jni_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma gun we, barki anime “Nyani kaisar umumbe sa izi ime, a i nyani Ugomo Asere igebe sa izi ume”. ");
INSERT INTO jni_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wada wa kem ure usizikime inni mum sa ma buki we ba anyumo anu u ira ukabirka umeme wa wu tik. ");
INSERT INTO jni_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sa are Asadsukiyawa wa eh me, ande sa wa gusa usuro icau uzoni, ");
INSERT INTO jni_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wa ikime wagu, “Unu bezizi, Musa ma nyettiken duru agi inka uhenu unu ma wono, ama zin innu nee, sarki vana, mada ke ma ziki unee u henume in marizi ma yoo uhenu me vana. ");
INSERT INTO jni_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Azin are ahana usunare u tubame ma wuzi anya, ma wi sarki vana, ");
INSERT INTO jni_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nannu nu kure me amme. ");
INSERT INTO jni_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Anu taru me ma ziki uneme, anime cangi unu sunare me madu ma wi sarki a hana. ");
INSERT INTO jni_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A ciki ati yei me uneme ma wi cangi. ");
INSERT INTO jni_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Rono usuro icau me madi cukuno une wa veni? inji ma wuzi anya nan we usunareme vat”. ");
INSERT INTO jni_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeso ma gun we, “Ahana une ugeme waka wa wuzi a nya ak nya aye a wuzi a nya nan we. ");
INSERT INTO jni_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Senke ande sa a hiri we kasi anu a lau ati wee tiginome wadi kabi u hira u mu cau barki sa wada ke wa wuza a nya ba na ni a nyawe inna nya. ");
INSERT INTO jni_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wada ke wa kinki uwono ba, barki sa wazi rep nan cukuno a hana u suso amu cau. ");
INSERT INTO jni_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Barki mu kizi mu suru, musa ma bezi cangi, ahira a babga ani jaa, abinime ma titi Asere a Ibrahim nan na Asere a Ishaku nan na Asere a Yakubu. ");
INSERT INTO jni_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ana daki me Asere a mukizi aniba ingi me Asere anu a huma ani, barki sa vat a ciki amemani”. ");
INSERT INTO jni_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aye anu nyettike me wa kabirka, “Unu bezizi, wa kabirka memerum” ");
INSERT INTO jni_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Anime wada wa kuri wa iki me imum ba. ");
INSERT INTO jni_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeso ma gun we, “Aneni wa gusa agi kristi vana u Dauda mani? ");
INSERT INTO jni_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Senke Dauda me niche numeme magu anyumo ani tabi ni zabura, Asere magu a Asere am, 'cukuno a tari ti nare tum, ");
INSERT INTO jni_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mi indi wu we u patili anu a buri intibuna'. ");
INSERT INTO jni_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda sa mytiti kristi “Asere adi wu areni ma cukuno vana u Dawuda? ");
INSERT INTO jni_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A anu in nu kunna vat magu in almariyai ameme, ");
INSERT INTO jni_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Hirani anu nyettike merum, we wa ka wa nyari wa haki aseseri ati tizimti jojoko, wa hem inni isi a nyumo ati kasuwa, nan na hira ati cukum ta nu adandang a ma sinagog, nan ahira agomo ugani usanna. ");
INSERT INTO jni_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wa ka wa zazani akoro ati kura tiweme, barki iwetere wa ka tunguno iringara jojoko. Anu kasi weme wadi kem uhuna udandang”. ");
INSERT INTO jni_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeso maveni aje ma iri anu imumu itari adesa wa isi ikirfi iweme ahira u isome. ");
INSERT INTO jni_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma iri ure unee unu zatu nee uruma ma wuna munini muni mure anyimo me. ");
INSERT INTO jni_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ba magu, “Kadure in boo shi, unee unu zatu nee uruma ugemu ma wuna imum me sa iteki iwe me vat uwe. ");
INSERT INTO jni_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vat anu aginome wa nya anyimo imun igebesa wa wa zini. Me unee ugeme sa ma zome unu rumaba, anyimo udira umeme ma nya vat imum igebesa ma ma zini u ciki umeme”. ");
INSERT INTO jni_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kasi aye sa wa boo abanga udenge Asere, kasi sa abara uni inu yaba ina po ahuma mi ikirfa sa a nyiza, Magu, ");
INSERT INTO jni_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ahira imumu iginome sa Ihira, uwui u eze sa nipo nizomi ni inde sa nidi cukuno Aseseri uroni sada tuburko mini adezi ba. ");
INSERT INTO jni_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba wa iki me, agi, “Unudungara, unu maya uni adi wuzi imumu iginome? Nyanini tidi iri ubata uya uni aku tubi. ");
INSERT INTO jni_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeso makabirka, “Wuzani Seki kati uye ma rangishi. Anu gbardang wadi ē anyimo niza num wagusi, 'mimani mē, 'anime', uganiya wa aye mamu kati itarsi we. ");
INSERT INTO jni_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ingi ya kunna abanga ani kono nan tikara, kati i wu zabut ba, doli ni imumu iginome i wuzi ani, ibinani ida ayeme debe-debe anime ba”. ");
INSERT INTO jni_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma gun we, “Anu wadi yeze anu, Tigomo tidi yeze a tigomo. ");
INSERT INTO jni_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Adi wuzi tiwiri ta dizi, ati hira sassas adi kuri awuzi ikomo nan imum iburi ani weme. ");
INSERT INTO jni_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ingi imum igino vat adi wuzi, wadi mekishi, wa nya shi tetene, wa nya shi ati denge ta Asere nan ti hira ti ukursoso anu, wade ēn shi aje a gomo na magumna barki nizanum. ");
INSERT INTO jni_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Idi cukuno shi unaa u bezizi. ");
INSERT INTO jni_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Barki anime barkani iriba ishi me barkani unā sa idi kabirka. ");
INSERT INTO jni_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mi, indi nya shi teze nan ugamirka, sa vat anu ishina ishi me wada ke wa tunno wa gun shi izin macicu ba. ");
INSERT INTO jni_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nan anu yoza, nan ni henu, nan nikura nan a roni wadi gā shi wa huzi ayeshime. ");
INSERT INTO jni_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Konda avi madi game shi barki niza num. ");
INSERT INTO jni_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko nice ni nide nishi ni da wonoba. ");
INSERT INTO jni_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Anyimo iriba ishew idi uri muriba mushi. ");
INSERT INTO jni_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ingi ya ira Urishalima ana nikara mini kono wa kete uni, i rusa urizo unini wa aye. ");
INSERT INTO jni_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","An desa wazi mayahudawa wa sumi uhana uzalan, m an desa wa rā ati anipin wa dusa, kati a ceki adesa wa rā amupin mu cincin wa ribe. ");
INSERT INTO jni_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti wui tiginome ti ugarziza tini, barki vat imum be sa aye Heke i myinca. ");
INSERT INTO jni_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Shi be shi ana ti puro nan adesa wa hamza ahana a ti yē tiginome, ");
INSERT INTO jni_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wadi rizi ufenfan uni gbinang adi ha inwe anyimo ni rere vat ama-nyanga anu zatu tarsa Asere wadi mari Urishalima, u hana uganiya uweme u mynica. ");
INSERT INTO jni_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Idi iri U iso abanga anyimo uwui nan upe nan iwirang. U nē anu zatu tarsa Asere wadi si nirere, wadi wu hu barki ugumuzo u raba udang nan ibarka imei. ");
INSERT INTO jni_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anu wadi wi wa zumi barki biyau nan u gamara abanga imum igesa idi kem unē, adi zuruko ubari Aseseri. ");
INSERT INTO jni_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Idi ku iri vana unu ma eze anyimo amagaji mari unu bari ninonzo gbardang. ");
INSERT INTO jni_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vat uganiya sa imum iginome ya tuba utubsa, hira, tunni, I venki aceshi asseseri, barki ubura ushi wa aye mamu. ");
INSERT INTO jni_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeso ma nya ubata, “Irani utiti upom, nan matiti vat. ");
INSERT INTO jni_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Uganiya sa wa tuba utirso, idi iri ina ce ashi me bi kwugba ba aye mamu, ");
INSERT INTO jni_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ane ani, ingi ya ira imumu igino me izini wuza irusi tigomo ta Asere ta biki. ");
INSERT INTO jni_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kadure in boo shi, uge uneme uda maraba, adi wuzi vat imumu igeme. ");
INSERT INTO jni_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aseseri nan adizi adi aki, Tize tum tida tida akaba. ");
INSERT INTO jni_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hirani cece ashi, kati i noki mu riba mushi unu gamara abanga une nan bisiza siza nan ubasa utize uti cukum. Uwui u eze udi mukurkan duru. ");
INSERT INTO jni_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kasi imumu imesi, udi ē ahira akonda avi sa ma vengize a muhenu mu unee. ");
INSERT INTO jni_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cukononi uni rusa koya uganiya, in biringara barki i kem ni kara nu cika vat imumu iginome sa idi ē, kasi sa idi tunno aje uvana unū. ");
INSERT INTO jni_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Unu wui mazi unu dungara anyimo udenge Asere, vat niye maka dusa anipo sa agusan ni uzaitun. ");
INSERT INTO jni_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vat anu waka dingi uhaza ahira ame nisisizo barki wa kunna me udenge Asere. ");
INSERT INTO jni_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Uganiya sa uidi imare uzatu yist wa e mamamu, uge sa atisa uidi uke terewa. ");
INSERT INTO jni_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ana Dandang akatuma kasere nan anu nyetike wa bari tize wa inki wadi hu Yeso, abine wa kunna biyyau ba nabu. ");
INSERT INTO jni_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Unu uburu maribe a Yahuza Iskariyoti, uni inde anyimo anu kirau ina naware me. ");
INSERT INTO jni_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuza Mahaa ma bara tize nan Ana a dandang a tuma kasere nem na soja sa madu witi we Yeso. ");
INSERT INTO jni_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iruba ya suniwe we hem wa nyame ikirfi. ");
INSERT INTO jni_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Abini me, mā nyari una be sa makem mawiti me ahira a weme man nu uganiya sa ni ori na zo ni. ");
INSERT INTO jni_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Roni uidi ubiredi uzati yist wā wu, sa gbas ini adi witi uhadaya ubizara bi idi uketerewa. ");
INSERT INTO jni_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yeso ma tumi Bitrus nan Yahaya, magun we, “Hana kabarkani haru imare u idu keterewa, barki tirii”. ");
INSERT INTO jni_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wa iki me, “Abani unyara tiribe?” ");
INSERT INTO jni_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Makabirka we, “Kunna ni, uganiya sa yaribe apin me, ure unu macira nitang nigmei madi kem shi, i tarsi me ahira sa maribe. ");
INSERT INTO jni_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ibuki una kura me, “Unu urusa in raa anyimo udenge agyen, ahira sa idi re imare idi uketerewa wana hana akatuma kam? ");
INSERT INTO jni_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Indi bezi shi akura anazaa (gidan sama) age sa aciki una barka, ibarka abirko”. ");
INSERT INTO jni_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wanno wa dusa waka kem kondi nyani imumbe sa mabukiwe, wanno wa barka imare uidi uketerewa. ");
INSERT INTO jni_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Uganiya sa uganiya wa wuu, ma cukuno nan na hana akatuma ka meme. ");
INSERT INTO jni_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Monno magunwe, “Izin nu kolimo uguna inre Imare u idi katarewa indi ku sii nirere. ");
INSERT INTO jni_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Abanna me magunan shi, inda kuri in re ini ba senke inki agminca ini anyimo a tigomo ta Sere”. ");
INSERT INTO jni_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Abini me Yeso maziki kusso me mabezi aburu arom, magu, “Ukabani i hari”. ");
INSERT INTO jni_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Abanna me inbo shi, inda kuri insii gmei mu inabi mage ba, senki inki tigomo ta sere taze”. ");
INSERT INTO jni_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Monno maziki Uborodi ma bezi iriba irom, mapusi ma nyinzi we, unu guna, “Igeme nipum num nini sanya barki shi. Wuzani anime barki iringize in mi. ");
INSERT INTO jni_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Makuri mazi 'ki' kusso adumo itanu unuguna, “Kusso ku geme u inko u tize tini anyimo amaye mam, mage sa a kpokan barki shi. ");
INSERT INTO jni_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Abanna me, zikani seke, de be sa witom mazi nigo nan mi utebut. ");
INSERT INTO jni_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Abanna vana madusa tabbas, kasi imum be sa izi, abanna kash unu gino me sa memanani madi witom. ");
INSERT INTO jni_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wanno watubi ugizo acce awe me, aveni anyimo arume sa wadi wuzi igino imume. ");
INSERT INTO jni_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wanno wa tubi matara acce ce awene unu guna aveni madi cukuno udang. ");
INSERT INTO jni_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Magun we, “Agomo wabezi tigomo ahira anu awome, ande sa wazin in tigomo ahira aweme a gusan we ana tigomo nan nu gancan. ");
INSERT INTO jni_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Abanna me kati icukuno shi anime. Unu guna, ceki de sa mateki shi unu ira anyimo ashime ma cukuno mamoni unu u cingilin. Ceki de be sa mazi me mani a kunna me makuri cukuno una katuma. ");
INSERT INTO jni_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Abanna avani mateki unu ira, unu gesa ma cukuno utebul, unuge sa mā cukuno utebul, nyani de sa mazin inkatuma? Azo de sa ma cukuno tebul? Vat anime nizi gusi una kaduma a tii ashi me. ");
INSERT INTO jni_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Abanna she wani sa izi nigo nan mi anyimo atina sasas. ");
INSERT INTO jni_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Manya shi tigomo, kasi acco ume sa manyam timogomo. ");
INSERT INTO jni_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Barki ire ikuri isi utebul uti gomo tom. Idi cukuno ama kpanku I buitize tini kobbo a ti kura tini kirau in ti tini re tanu Israi'la. ");
INSERT INTO jni_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siman, Siman, hira memeru, kati unu buru igino makem un ahira awe me barki azikawe kasi alkama. ");
INSERT INTO jni_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Abanna me ma wuna we be ringara kati kadundare ka we me ka rizi. Udi ku e in na dumo, uwu anu henu uwewe iruba i huū. ");
INSERT INTO jni_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus ma magun me, “Ugomo-Asere, in ciki lak indusa nigo nan hu uhana udenge unu re-re nan nu hana iwono. ");
INSERT INTO jni_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeso makabirka me, “In boowe Bitrus, udi wu matara mu rusa um kataru abigoro bida Sarki urono. ");
INSERT INTO jni_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Uganiya Yeso magunwe, “Uganiya sa matumi shi Sarki mabadau, nyani uburga, nyani agbatak nyani ya diri ire imum? Wa kabirka me, “Babu”. ");
INSERT INTO jni_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma kuri magun we, “Abanna ana me, vat de sa zini nu badau a ma ziki, nan nu burga. Desa mazo me unu vira ujoko ma zizi u dibi umeme ama kpi u inde. ");
INSERT INTO jni_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Abanna me ingusa shi, imum be sa a nyetike ani ce num gbas ini igminca. “A batta i inde anyimo me i hankirka u inko utize tini. Abanna imum be sa abuka ini anice num ya gminca”. ");
INSERT INTO jni_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wanno magu, Ugomo-Asere, Ira! Tivira tire tiyenne, “Monno magun we, “Ta bari”. ");
INSERT INTO jni_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sa wa mara ure imare uwunjoro, Yeso madusa, gusi uwuza sama wuza, uhana anipo nuzaiton, hana katuma ka meme wadusa wa tarsi me. ");
INSERT INTO jni_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Uganiya sa wa biki, magun we, “Wunan biringara barki kati iribe a nyimo umasa”. ");
INSERT INTO jni_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma sesirke nan we kasi umansa unipo, matunguno mawu biringira. ");
INSERT INTO jni_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Magusi, Aco, inki wa hem, zika kusso ku geme anice num, sa azi azo animani in nyara ba abanna me ceki vat imum be sa unyara icukuno anime. ");
INSERT INTO jni_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Vana ukadura kasere monno ma suri azessere ma Ee ahira ameme, ma nyinzi me tize. ");
INSERT INTO jni_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Marau anyimo uzito kang, monno inki iruba inbiringara, matum masuzi anipum ni meme kasi agoro a maye. ");
INSERT INTO jni_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uganiya sa ma suri ahira abiringara bi meme monno ma Ee ahira aha aka dura ka meme, makem wazin im moro barki aburu abit awe me, ");
INSERT INTO jni_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Monno ma iki we, Nyanini ya wuna izin immoro? Hirani iwu biringirang barki kati iribe anyimo umansa”. ");
INSERT INTO jni_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Uganiya sa maraa anyimo atize, abini me, ni ori na nu ni Ee, nigo nan Yahuza, Uye anyimo ukiran ina naware me, marani aje aweme. Monno ma Ee ahira a Yeso barki ma gbindirko me, ");
INSERT INTO jni_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Abanna me Yeso magun me, “Yahuza, unu gbindirko uni udi witi vana unu? ");
INSERT INTO jni_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Uganiya sa anuge sa keti Yeso wa iri imum be ara anyimo me, wagu, “Ugomo-Asere, tikoriko in ka sangali me? ");
INSERT INTO jni_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Uye monno makoriko ure ure-ure unu udang ukatuma ka sere utoi, madusa ma yori me utoi utari tina-re. ");
INSERT INTO jni_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yeso magu, “Ya bari anime”, Monno madari utoi me, madusa huma in me. ");
INSERT INTO jni_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeso magun ina na dandang akatuma ka sere, nan anu utonzino anatukum udange utize ta sere, nan nan nanu an desa wazin ini shina nan me, “Ya suro kasi idi meki ukari, in ma Sangali nan ti bina? ");
INSERT INTO jni_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Uganiya sa māzi nigo nan shi anyimo at denge ti tize tasere, daki, yamekin mi ba. Abanna uganiya shi ushi me wazige me, nan nikara ni manu. ");
INSERT INTO jni_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Madusa meki me, wanno wadasan me, wa Em me anyimo akura ana katuna ka dandang. Abanna me Bitrus mazinu tarsa ume pit. ");
INSERT INTO jni_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sa ma hure ura anyimo atii akura sa wa cukuno nigome, Bitrus ma cukuno atii awe me. Ure uca ure-re ma iri me ma ciki amasaa mura, monno. ");
INSERT INTO jni_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Abini me ure uca ukatuma ma iri me a masaa mu wura, ma inki me aje magu, unu geme mazin na me”, ");
INSERT INTO jni_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bitrus monno māwu matara, unu gusa, “uca, in rusa me ba. ");
INSERT INTO jni_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A kure kuganiya cingilin ure unu ma iri me, monno magu, hume uye mani anyimo aweme, “Abanna Bitrus magu “Unu ugino, azo im mani ba.” ");
INSERT INTO jni_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uhana uzumo a inde, uru unu ma inki iruba unu gusa ana, “Kadura unu geme mazi nigo nan me, barki me vana anu Galili mani. ");
INSERT INTO jni_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Abanna Bitrus magu, “Unume, in tam imum sa uzi nu boo me, Abini me, sama raa anyimo atize bigoro bi dusa birino. ");
INSERT INTO jni_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ugamirka wazigino, abinime Ugomo-Asere maguri aje nan Bitrus. Abini me Bitrus ma ringi ni gburang ni Ugomo-Sere, uganiya sa magun me, udi wuzi matara murasa um kataru bigoro bidi ku runo. ");
INSERT INTO jni_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sama suro a mataraa, Bitrus ma meki asso kang. ");
INSERT INTO jni_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abini anume sa wa kurso Yeso wa wuzi me ni bassa wa kuri wa cabi me. ");
INSERT INTO jni_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sa wa hupo me aje, wa iki me, unu guna, “Rusa ire Imumu! Aveni ma vavvi we?” ");
INSERT INTO jni_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wa bui me tire tize tizenze tu cara azezsere ayeso. ");
INSERT INTO jni_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa ahira asana, Abinime ananu wa cukuno ahira inde, ana adandang akatu kasere nan anu nyetike. Abini me wa han me ahira ana katuma kami kobbo. ");
INSERT INTO jni_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wa gu, “Bukan duru, inki homani Ugomo-Asere”, Abanna me magun we, “Inki mabuka shi, ida hem shi ba. ");
INSERT INTO jni_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","In ma iko shi, ida gamirkan min ba. ");
INSERT INTO jni_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Abanna uganiya uni cingilin wade, vana unubu madi cukuno atari tinare tinikara na Asere. ");
INSERT INTO jni_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“Wagun me” A se hu vana Asere mani?” Yeso magun we, “Ani mani ya buka, im mani”. ");
INSERT INTO jni_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wagu, “Nyanini ti nyara ti kunna? Abanna ta kunna in ti toi tiru me anyo ameme. ");
INSERT INTO jni_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Vat anuu me sa wa tarsa wa hiri wa tonno, wa ēn Yeso ahira Bilatus. ");
INSERT INTO jni_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wa hiri me inna banga ayari, unu gusa “Ta kem unun geme unu hara umu ruba manu, agi kati wa nya ikirfi ima nyanga ba, unu gusa agi memani Asere, Ugomo”. ");
INSERT INTO jni_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatus ma iki me “Ho mani Ugomo a Yahudawa?” Yeso makabirka me ma gu “Wa buka anime”. ");
INSERT INTO jni_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bilatus ma gun anu adandang aka tuma nan anuu gbardang, “Daki ma kem unun ugeme unu pilko ba. ");
INSERT INTO jni_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wa gaawe unu gusa “Ma bunkurko anuu unu bezizi umeme vat uyahuda, matuba ugalili nanu aye abame.” ");
INSERT INTO jni_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sa Bilatus ma kunna anime, ma iki nan unuu nuu Galili mani. ");
INSERT INTO jni_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sa ma rusa unun maran atari ti Hiridua tini, ma tuburko Yeso u hana ahira Hiridus u Jerusalem ati yee me. ");
INSERT INTO jni_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sa Hiridus ma ira Yeso, ma wu apuru arum, barki sa ma nyara u ira ume datti. Mamu kunna abanga ame, ma nyara ma iri imum ibiyau me sa ma wuza. ");
INSERT INTO jni_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hiridus ma iki Yeso timum gbardang, Yeso ma game kabirka me. ");
INSERT INTO jni_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Unuu adandang aka tuma nan anuu nyerte wa hirri ummu ruba wa nya me ayari. ");
INSERT INTO jni_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hiridus nan ana nikara nini kono (Ma'Soja) wa zogizi me wa wuzi me nibassa. Wa sukki me udibi udandang wa kurzo me ahira Bilatus. ");
INSERT INTO jni_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Barki Hiridus nan Bilatus wazin ruroni inna cece atiyee me (wazin inni erru atiyee ta dumo) ");
INSERT INTO jni_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus ma titi anuu adandang aka tuma nan Agomo dandang nan nigura na nuu. ");
INSERT INTO jni_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma gun we “Ya aye nime unu nuu ugeme kasi unuu sa mazin nuwuza anun wa wuzi imum izenzen, irani ma iko me ashin, daki ma kem me inna bur imumme sa ya booni anicee numeba. ");
INSERT INTO jni_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nan Hiridus sa ma kurzo me ahira aru ma ira me inna bur sa abari ahun me ba. ");
INSERT INTO jni_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","“Barki anime indi cobi me in ceki me”. ");
INSERT INTO jni_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bilatus maka nya a Yahudawa unun inde anyimo ande sa wa rani akura ani rere uganiya idin keterewa. ");
INSERT INTO jni_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wa meki tihunu vat uwe unu gusa “Ceki unuu geme u nyan duru Barabas”. ");
INSERT INTO jni_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas unuu me sa aka korso me udenge uni rere sa ma guri ahira ahun unuu. ");
INSERT INTO jni_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus ma kuri ma buki we tize uguna ma ceki Yeso. ");
INSERT INTO jni_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wa wuu tihunu wa gu “Gankirka me, Gankirka me”. ");
INSERT INTO jni_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma gun we uku taru, “Barki nyani, a ya bur ani unuu geme ma wuza shi? Daki makemme unu pilko sa wa bari ahume ba. Barki anime imma Cobo me indi ceki me”. ");
INSERT INTO jni_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wa game inti myiran inna za, unu nyara a nyawe me wa gankirka me. Tihunu tuweme tihunguko iruba i Bilatus. ");
INSERT INTO jni_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Abinime Bilatus ma nya we me. ");
INSERT INTO jni_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma ceki Barnabas sa maa guri ahira ahun unuu. Ma nyawe Yeso sa wa nyara. ");
INSERT INTO jni_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sa wa haka nan me, wa gurna nan Siman unanuu Sayirin, ma zeze usuro ani pin, wa canni me ukunti ugankirka ma tarsi Yeso. ");
INSERT INTO jni_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Unu hem unu gura nanuu nan nanee intisso nan tihunu, unu tarsa ume. ");
INSERT INTO jni_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeso ma gamirka ma gu “Acaa anu Jerusalem, kati ishinime ba, sooni acee ashi nan na hana ashi. ");
INSERT INTO jni_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Irani barki, tiyee tieze sa wadi gu, 'Ani ruba irum wani anuu zattu yozo, nan tipuru sa daki ta yozo nan na hene sa daki a hamza ba. ");
INSERT INTO jni_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Abini me wadi tubi ugusan na pana 'Rizo aharu', nan napoo, 'Impon duru', ");
INSERT INTO jni_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ingi awuza matiti mazu aname, nyanini idi kem mage sa mawaa?” ");
INSERT INTO jni_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ukassu anuu, akari waree wazi nigome nan me tantu kahuname. ");
INSERT INTO jni_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sa wa aye ahirame sa atisa “Ukunkuwa”, Wa gankirka me nan akari waree unuu inde atari tinanre unuu inde atari tinangure. ");
INSERT INTO jni_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeso ma gu “Acoo, vette ucara uwemen, barki sa wa taawe imume sa wazin unuwuza ba”. Wa acece tirunga tumeme in bizawazawa. ");
INSERT INTO jni_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Anuu wa turi unu hirame, agomo unu wuza ume nibassa, unu gusa “Ma bursa aye ca ma buri nice nume, ingi memani Ugomo Asere nan Asere sa a Zauka”. ");
INSERT INTO jni_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Anani kara nini kono (Ma Soja) wa meki uhaza upuru ume unu wuza ume nibassa, unu ninza ume mei magbarara. ");
INSERT INTO jni_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Unu gusa, “Ingi homan Ugomo wa Yahudawa, bura nicee nuwe”. ");
INSERT INTO jni_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","U'ira warani ame “Ugomo wa Yahudawa mazigeneme”. ");
INSERT INTO jni_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uye anyimo akarime mazogeme sa agankirka we nan me unu gusa “Inzo homani Ugomo Asere? Bura nicee nuwe nan haru”. ");
INSERT INTO jni_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Unuu kureme ma tarika me, magu “Uda kunna we biyau ba Asere ba, tunsa imun inde ini ya kem shi? ");
INSERT INTO jni_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Haru tiraa abame rep, barki ucara urun. Unuu ugeme daki ma cara imum ninba”. ");
INSERT INTO jni_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma gu, “Yeso, ringinmi anyimo ati Gomo tuweme”. ");
INSERT INTO jni_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeso ma gunme “Kadundura ma gunan huu, kani udizi nan mi akura Asere.” ");
INSERT INTO jni_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Inna tii uwui (Azumu kirau in anaree) ahira abee Uhana uniyee. ");
INSERT INTO jni_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Masaa mu wui ma inpino. Ugebtu udenge unigurame ujanika atii. ");
INSERT INTO jni_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Inna soo, inni nyiran nidandang Yeso ma gu, “Acoo, ma nya Bibe bum atari tuwe”. Sa ma buka anime ma wii. ");
INSERT INTO jni_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sa una nikara nini kono (Usoja U Romawa) ma ira imumme sa ya cukuno anime ma gu “Kadundura unuu geme ma zome ma dini ba”. ");
INSERT INTO jni_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vat nigura nanbu sa wa aye bati iri imumme sa awuza, wa kuri unu tira igiri. ");
INSERT INTO jni_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vat ande sa wa rusa me, nan anee me sa wa tarsa me usuro u Galili, wa tonno pit, unu hira utimumme. ");
INSERT INTO jni_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Russani, uru nun maa rani unaniza Isubu, de sa maa rani anyimo anuu hirra. Unuu uririn mani ini ruba ubenki. ");
INSERT INTO jni_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Unuu ugeme daki ma hem ini mumme sa anuu hirra wa wuza ba nan bi wuzawuza buweme ba. Mee unanuu Yahuda mani ani pin nu Arimatiya mazin nunyara uti Gomo ta Asere. ");
INSERT INTO jni_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Unuu me makem Bilatus, ma iki ikizi Yeso. ");
INSERT INTO jni_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma tuzo ini, ma impi ini unu malti uririn, ma ka natta a ire ican upuru uni poo, sa daki amuwuna ire ikizin ba. ");
INSERT INTO jni_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Uwui ubibarabara bini nan Asabar a ezi. ");
INSERT INTO jni_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Anee me sa wa tarsi Yeso usuro U Galili, wa tarsi waka ira ican me nan nuvati me. ");
INSERT INTO jni_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wa kuri, waka nyara uturari nan mani munya urunta. Wa venke unu wui wa sabar kasi udungara U Musa. ");
INSERT INTO jni_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni sisizo roni tuba utiye usunare, wa ē icaume, in turunga tu nya urunta tigebe sa wabar ka. ");
INSERT INTO jni_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba wakem agamir ka ni pome. ");
INSERT INTO jni_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Waribe anyimo me, daki wakem ni pum ni gomo Asere Yeso ba. ");
INSERT INTO jni_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya kem anime, wawu huū abanga agino me, Sarki urusa ana ware wa tonno aje awe in turnga ti walwal. ");
INSERT INTO jni_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Awe me wa tungurko ace adizii barki biyau, wagun na neme, “Nyaani yawuna izin unu vengize anyimo amu kizi?” ");
INSERT INTO jni_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma zoni, mahira! Ringini mabuki shi daa ti ame U Galili, ");
INSERT INTO jni_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Agi adi nya vana unu atarita na madini wagan kirka me, u wui utaru, madi hiri”. ");
INSERT INTO jni_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ba ane me waringin inna guran me, ");
INSERT INTO jni_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wakuri u suro icaume ba wabu anu kirau innu inde me vatti imummu igino nan nu kansu me. ");
INSERT INTO jni_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","An Maryamu Magadaliya, nan Juwa na, nan Maryamu ano Yakubu nan nu kasa aneme sa wazi ni gome wabuki imumbe sa awuza. ");
INSERT INTO jni_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A naka dura daā ula zikka tize me anyo imumba daki wahem inna nemeba. ");
INSERT INTO jni_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vatti anime Bitrus mahiri, masumi uhana icaume, matunguno innu hira anyimo me, Bama u malti cas. Bitrus madusa uhana akura ame, mazin gamara utize. ");
INSERT INTO jni_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Rome akem aware anyimo we wahaka uhana a aragaro in zame immawus, sa upiit u ani mel u inde usuro u Urshalima. ");
INSERT INTO jni_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wa zin nu gamara ace ce awe me usuwo imum be saya kem. ");
INSERT INTO jni_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba icuku no innuguna, sawa zin nu gamara me nan nu igizome. Ba Yeso in nicee nume ma ē ma mu in tanu nan we. ");
INSERT INTO jni_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aje awe medakat inka avee ni Yeso ba. ");
INSERT INTO jni_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeso magun we, “Iboo nyari ugani ya sa ihaka?” Wat onno ahira me inti puru tibit. ");
INSERT INTO jni_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Uye anyimo awe, unaniza kiliyobas, makabirka me, “Humani unume cas sama raa Urshalima mesa tame imumbe sa yakem abirkome atiye tiginome ba?” ");
INSERT INTO jni_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeso magun we, “Tiya timu mum?” Wa kabirka, “Timumum usoro uyeso uba Nazaret, igebe sa una kadura mani unaka tuma kadan dang nan aguran ahira Asere nan na nu. ");
INSERT INTO jni_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kasi anaka tuma kadang ka Asere nan ana tigomo wa witi me barki awekime tize uhana iwono agankirka me. ");
INSERT INTO jni_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Taā inko iruba uguna memani madi buri ma Israila. Ire adumo igino me a name tiye titaru daati sa imum igino me yakem. ");
INSERT INTO jni_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akaa nime, are anee sa tizi nanwe wawuza imumu ira, sa cukuno i caume usuro in sisizo. ");
INSERT INTO jni_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sa daki wakem nipum numemba, ē in nu guna we cangi wa ira tiroō tibe ikadura ka Asere igebe sa ya gun we mavengije. ");
INSERT INTO jni_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Are ahana aruma sati zini go me wadusa icau me, wakem me ni kasi ubuka anee me. Dakki wa ira me ba. ");
INSERT INTO jni_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeso magun we, “Shi anu ani ba bana nan na nu uzatu hem in ni mumbe sa ana katuna ka Asere wa buka. ");
INSERT INTO jni_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dakki ya cukuna gbas masi i jas ati mumun tiginome, maribe a nyimo atigono tume?” ");
INSERT INTO jni_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","U suro utuba me Musa uhana ana katuma ka Asere, Yeso matuba we vat dodu sa izi ani ce nume u vat unyiti. ");
INSERT INTO jni_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sa wa hana mamu nan nagiro me, ahiraa sa wa hakani, Yeso mawu kasi madi akku we. ");
INSERT INTO jni_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wume gbas, innu guna, “Cukuno nan haru, u wunjuro wa anye mamu uwui wamara”. Ba Yeso madusa maka cukuno nan we. ");
INSERT INTO jni_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yakem agi, sama cukuno nan we barki mari imumare, ba ma ziki ubreedi, ma ringarka uni, mapusi, bama nyawe. ");
INSERT INTO jni_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Abini me aje aweme apokino, sawa ru same, ba ma hunne me aje awe. ");
INSERT INTO jni_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wa gun na ce-ce we, daki muruba muru macunnome ba, sa ma zin tize nan haru una, sa ma poko duru unyitike ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wahiri uganiya uginome, bawaku ri a Urshalima. Wakem anu kirau innu inde nigome, nande sa wazi ni gome. ");
INSERT INTO jni_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ya cukuno, gbas ugomo Asere mahiri, mapoki nice nume ahira Simon. ");
INSERT INTO jni_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ba wabuki imumbe saya kem we u na, kasi sa abezi we Yeso sama pusi uborodi. ");
INSERT INTO jni_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sa wazin nu bo imum iginome, ba Yeso matonno atti awe, bama gunwe, gaja ushi. ");
INSERT INTO jni_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wa wu huū wa myin can biyau, wa'basa wa ira imoli. ");
INSERT INTO jni_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yeso magun we, barki nyanini izin ma aye? Barki nyani ya wuna u igi zo u suso iruba shi me? ");
INSERT INTO jni_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ira tari tum nan tibuna tum, mimani in sisi im. Darani mi i iri. Iyenne bibe bizome inni pum nan na ubo, kasi gusa ira inzini. ");
INSERT INTO jni_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sama buka anime, bama beziwe tari tume me nan tibuna tumeme. ");
INSERT INTO jni_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sa myinci na puru arum, inni mu in ibiyau, Yeso magun we, izin ni mumare? ");
INSERT INTO jni_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba wa nyame icere hu. ");
INSERT INTO jni_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yeso makabi, mari aje awe. ");
INSERT INTO jni_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ba magun we uganiya sama zinan shi mabu ki shi agi vat imumbe sa anyitike anyimo u inko utize timusa nan ana katuma Asere nan nu zabura ya cukuno gbas imyinca. ");
INSERT INTO jni_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bama poki muruba muwe, barki warusi unyitike. ");
INSERT INTO jni_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Magun we, “Anyitike, agi ugomo Asere madi si i jassi, ma anyimo iwono rono taru. ");
INSERT INTO jni_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wuzani tize tuka ba ugomo Asere nan nu vete umadini anyimo ani zanu menan nanu zatu rusa utize ta Asere, tuba ni a Urshalima. ");
INSERT INTO jni_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Shi aje ani ahira timumum. ");
INSERT INTO jni_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ukaba Asere, inzin nu tumuza utira utize ta coo umace ashi. Anime beni anipin, senke a soki shi ubari azesere. ");
INSERT INTO jni_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Anime madusa nan we waha mamu nan nu Batanya. Bama yeze tari tumeme maringirka we. ");
INSERT INTO jni_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Icukuno uganiya sa mazin nu rin girka uwe, macekiwe madu uhana Asere. ");
INSERT INTO jni_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba wa nunzome, wakuri a Urshalima in na puru arum kank. ");
INSERT INTO jni_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Koyo wui wara anyimo udenge Asere, wazin nu ringara Asere. ");
INSERT INTO jni_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dati inu tuba Nigburang na rani, nigbura nazi nigino me nan Asere, nigbura nigino me Asere mani. ");
INSERT INTO jni_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Me mani datti unu tuba mazi nan Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Vatt timumum, awuzi ahira ameme, daki a barka ire imum sarki me ba. ");
INSERT INTO jni_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me mani ivai irani, ivai igino me ya cukuno masaa ma nabu. ");
INSERT INTO jni_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Masaa mazin nu gido mareu, mareu me daki ma ranga masaa ba. ");
INSERT INTO jni_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kadure ka masaa me ka raani sa ka ehzi unee me sa mazi nu bezi anu masaa me. ");
INSERT INTO jni_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Maa ra anyimo unee me, unee me wa cukuno atari ti meme vat anime unee me waa rusi in me ba. ");
INSERT INTO jni_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Maa eh ahira anu meme, anu ameme wa nyare me. ");
INSERT INTO jni_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vat ibinani andesa waa kabi me, andesa wahemi in niza ni meme maa nya we nikara wa cukuno ahana Asere. ");
INSERT INTO jni_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ande besa ayoo inzo a maye ba nani usuro unipum nani unubu, usuro Asere ani. ");
INSERT INTO jni_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nigburang niginome na cukuno nipum. Anyimo aru ta ira ni nonzo nimeme, ninonzo ni vana u inde ugino me ahira acoo umeme, gbem ini mum iriri nan kadure. ");
INSERT INTO jni_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhana maa bezi uni tisa in nikara magu, “Unu ugeme me mani maa buki tize anice nimeme unu guna, 'Desa ma ehze adumo am ma tekum, barki maa rani aje am.”' ");
INSERT INTO jni_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Barki umyinca umeme taa kabi imum iriri aseser imum iriri. ");
INSERT INTO jni_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Barki u inko utize atari ti Musa a nya tini urunta nan kadure. ka ciki ahira a Yeso vana Asere cas. ");
INSERT INTO jni_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Daki a iri uganiya sa uye ma iri Asere ba. Vana u inde Asere me, me sa ma hibi abigiri ba acoo, me mani maa bezi me. ");
INSERT INTO jni_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yahaya ma beziwe imumbe samarusa, ine ini ayahudawa watumi ahira ana katuma kudege. Ugomo Asere nannan lawiya uhana urshalima wa ikime nani memani aveni. ");
INSERT INTO jni_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Manno mabuki kadura, daki mawuzi matara nan weba ma; azomemani ugomo asere ba. ");
INSERT INTO jni_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wanna wa ikime wagun me aneni homami iliya me? makabirkawe, “A'a azomemaniba.” Wanno wagunme hamani unu beze tizeme? Manno magunwe, A; a”. ");
INSERT INTO jni_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wanno wakuri wa ikime hu aveni barki tikem ukabirka uweme barki tirusi imumbe satidi kabuka andesa tumanduru? Utisa nicce agi aveni? ");
INSERT INTO jni_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Makabirka we magun mi nigmirangnige sa nitisa anija'a nigusa nyani ugomo asere muriba mushime gusi imumbe sa Ishaya mazinnu boo me.” ");
INSERT INTO jni_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","We me, Afarisiyawa wani watumi we. ");
INSERT INTO jni_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wanno wa ikime barki nyanini uzorsanu azohu ugomo asere mani ba a zohu iliya mani ba hume unu bezizzi kadura kagino me? ");
INSERT INTO jni_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahaya makabirka we, magunwe me in gei mani in zorso anabon, uye maluri anyimo ashime sa iteshi me. ");
INSERT INTO jni_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Memani ma-eze adumo umunu be sa binyimo bakpatak ameme daki mabari in suso ini ma ba. ");
INSERT INTO jni_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Awuzi anime ubatanya uni uhuru uraba u urdu uni, ahira sa yahaya ma zorso anabon. ");
INSERT INTO jni_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Unu sana-ahira yahaya ma iri yeso ma eze ahira ameme, yahaya magu,”yaira mi vana ubitan bu gomo asere, desa madi ziki madini munee. ");
INSERT INTO jni_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Anime ani mabukishi uye ma eze adumo am, memani unaje am barki dati marani aminiba. ");
INSERT INTO jni_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dati maruseme ba me abezeme ayumu isaraila ma-ah ma zorsanu in maye. ");
INSERT INTO jni_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahaya kaberka magu ma-ira bibewu bezennu tuzo. Kase kuhurge ka sure a zesare ku cukuno ane gerza numeme. ");
INSERT INTO jni_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dati maruseme ba, memani dese matumum in zorso anu in mayi, memani ma bukum dese ma ira bibew ba asere batu bikure bicukunu aneeh numeme memani. Ma zorsa anabu in bibew ba asere. ");
INSERT INTO jni_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Makure ire in kure beze, unu uginome vana asere mane. ");
INSERT INTO jni_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Unu sana ahirs yahaya ma lure nan na nakatuma ana ware. ");
INSERT INTO jni_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mazen nuhira yeso mazen tanu manno magu irane vana ubetam baasere!” ");
INSERT INTO jni_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ahana akztumame ana ware sa wakunna ma rezo adeze, wanno wadusa wa tarse yeso. ");
INSERT INTO jni_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeso magamirka ma iri wazinnu tarsa ume, manno maunwe, “Nyanini izin nu nyarame? Wanno wagun me, hu unu urusa abanga abanname unu unyenkike uciki abanie. ");
INSERT INTO jni_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Manno magun wae ayeni, i'iri.” Wanno waha waka ira ahira me sa machikin, wanno wahirii negome uhana azumo anazi unu wunjoro. ");
INSERT INTO jni_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Unu idai ayumo ana wareme sa wakunna tize ti yahaya wanno wa kuri wa tarzi yeso, andarawas mani mazi uhenu u bitrus. ");
INSERT INTO jni_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Maubi ma uhenu umeme sa bitrus, takem Asere, “Memani asere ma hummaka maturi me. ");
INSERT INTO jni_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Manno mahan me ahira Ayeso, Yeso ma iri me, magun me hamani saminu vana u yahaya? adi tesawe kefas.” (ni neni bitrus). ");
INSERT INTO jni_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sa ahira asana yeso mahiri udusa a manyanga mu galili, abini me ani makem Filibus magun me ano tarsam. ");
INSERT INTO jni_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus unanu betsaida mani nepeni numeme nan andarawas, nan bitrus. ");
INSERT INTO jni_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibus ma kemnata-ala, magumme ta kem dey sa musa ma nyatike abanga ameme anyimo aka dura be sa ugomo. Asere ma inki men, ana kadura ka asere wa kuri wa nyentika abanga ameme, memani yeso una anu nazere, vana u yusufu. ");
INSERT INTO jni_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nata ala magunme ade kem imum ihuma unazarat me filibus magun me aye u'iri. ");
INSERT INTO jni_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeso ma-iri nata-ala ma eze ahira ameme, magu ina nu ana ira'a ni, unu u isara-ile nun ukadura, de besa mazo me ini mum izenze a puru ameme. ");
INSERT INTO jni_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nata-ala magunme urusam abane? Yeso ma kabir kame ma gunme udaniya, sa wara akurame filibus matitiwe mamu rusawe. ");
INSERT INTO jni_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nata-al ma kabirka me magu, “Una kura huu vana asere mani hurugomo isara'ila mani!” ");
INSERT INTO jni_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeso makabir ka me, “Ma gumme mi maguna huu mairawe akura uzunu bezi kadura, ude ire imum be sa iteki iginome.” ");
INSERT INTO jni_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yeso ma bukime ane ani mabuka, “Shi ide ire a zesere a harzena Malika asere wazen nu yize nan na tazu nan vana unuboo. ");
INSERT INTO jni_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Uwui utaru uwuzi nigura ukana amanyanga mu galili, alno yeso marani ahirame. ");
INSERT INTO jni_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Abezi yeso nan an a akatum kameme, ");
INSERT INTO jni_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sa gmei mu in nabi, masizi kime aino Yeso magu wazin nukasu ugmei mu inabi.” ");
INSERT INTO jni_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeso magun ka inome, “inne tizetiginome tiwe me tiniba uganiya um, wamu unaba udaza. ");
INSERT INTO jni_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ine ini, a'ino a yeso magu narereme, “Vat imum be sama buka shi, iwu hirani, iwu ini.” ");
INSERT INTO jni_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ahirame masirau manu tasi. Mapo ainki usura utanda wa yahudawabarki ukpijo umadini vat masirau me maciri adong uta-tasi. ");
INSERT INTO jni_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeso magunwe “myincani adonga ginome, in gmei, wanno wa myinciza ani, gbem-gbem. ");
INSERT INTO jni_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Manno ma gunwe intani ika nya aco anigurame wanno waka nya me. ");
INSERT INTO jni_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sa aco ani gurame, sama kuro gmei me sa ahanna men, mage sa a gamirka macukuno gmei mu inabi. Daki marusi ahira musa akem manin, (We arere me waruse ahirame sa akemni). ");
INSERT INTO jni_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Magu gmei mariri mani mu inabi mu inabi manno mameki unyinza anabu. Sa anabu wa siza maduku en magebe sa masiziki me maje me unu ure am, huu wa hunze mari-rimen ana mani wadiku ayyen immani.” ");
INSERT INTO jni_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ine ini mu ujizai mutuba sa yeso mawuzi, mano mawuzi u kana amanyanga mu galili. Mabezi ubari umeme, ahana aka tuma kameme wano wahem in me ");
INSERT INTO jni_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Manno madusa ukafarnaham, me nan ka inome, anu kenu umeme nan ana katuma kameme, maka cukuno abirko wa wu kayen ni. ");
INSERT INTO jni_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ni gura na yahudawa, na-eh mamu yeso madusa urshalima. ");
INSERT INTO jni_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Anyimo udenge uninanzo numeme, waziki uni ucokono we ahira atijamani tinah, nan nitam ma tantabara, nan nanu corso ikirfi waciki ahira akatuma ka wome. ");
INSERT INTO jni_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Manno mapi macobiwen ma gidiwe vat uwe anyimo udenge ubiringara me nan ni tamme a iname anu corso ekirfi ma samirka nan ma tantabara me vat. ");
INSERT INTO jni_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Magun na nabo hum koni adadu ageme yazika, akura ugomo asere a cukono ahira ati jamani;. ");
INSERT INTO jni_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ine ini ahana aka kuma kameme. Waringi a nyentike ihori agi acara akura ugomo asere. ");
INSERT INTO jni_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayahudawa wakabirka me wagu nyanini udi bezinduru sa uzi ana me. ");
INSERT INTO jni_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeso makabirka we magu, tuburkoni udenge ugomo asere mi indi hirza uni anyimo atiye. ");
INSERT INTO jni_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A yahudawa wagu awu time akure anazi in tinu tasi azinu bara ahira aninonzo no gomo asere, me maguna. Tiye ti taru madi barkaa. ");
INSERT INTO jni_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Udenge uninonzome sa yeso mabukani uneni nepom nu meme. ");
INSERT INTO jni_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Barka anime uganiya sa ahirzame, anyimo a mu cau ahana akatuma kameme, wanno waringi agi mabuki anime wanno wa hem in ni mum be sa abuki unu tuba nan tize ti yeso sa ma buki. ");
INSERT INTO jni_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Abinime uganiya samarzni u urshalima atiye tini gura na yahudawa, anabu gbardang wa hem inza nimeme barki uira imumbe sa mawuzi. ");
INSERT INTO jni_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ine ini yeso ma hem we be. ");
INSERT INTO jni_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Barki marusa ma ri a muwe me, azome agi uyye mani mabezime barki me, licce ni me me marusa vat imum be sa iraa a mu ruba ma nabu. ");
INSERT INTO jni_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Urunu marane neza numeme nikodimo memani unaje wa yahudawa. ");
INSERT INTO jni_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unu uginome ma e ahira a yeso in niye magunmme hu una jetirusa hu unu rusamani sa wa e ahire asere, barki unu rusa wuza katuma kawe ma maraneba, de be sa mazi nigo nan na Asere memani madi uiuzi kani.” ");
INSERT INTO jni_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeso makabirka me magu aneni inzinu bezi uwe in kadaki akuri ayo unububa mada irame akura asere be. ");
INSERT INTO jni_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimo magun me adi wo aneni ayo unubu sama uiuna ucokoro? ani madi kuri maribe aburu aino meme makuri mayome?” ");
INSERT INTO jni_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeso makabirka me magu, “Inkadaki ayo unubu usuro ugmei nan bibe ba asere ba mada ribeneme akura asere ba. ");
INSERT INTO jni_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Immum be sa unubu mayo unubu mani, imum be sa bibe ba yo bibe bini. ");
INSERT INTO jni_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kati icukuno we imum itize barki sa ma guna ya cukuno gbas akuri ayo we. ");
INSERT INTO jni_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ueebu usuma uhama ahira iriba u uni uduki u kunna tanu tu uni utame ahira sa wasuroni uyami ahira me sa uhazani, anima izi ahira ade be sa bibe ba yo me.” ");
INSERT INTO jni_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimo ma kabirka me magu, “Aneni idi cukuno?” ");
INSERT INTO jni_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeso ma kabirka me magu hume sa uzi unu bezi ihori anyimo isra'ila daki wa rusa ani me ba? ");
INSERT INTO jni_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ine ini inzin nu gusan hu, imumbe sa tirusa ine ini ta buka we tizin nu kuri ubizi imumbe sata ira yagashi uhem inni mumbe sata bezi. ");
INSERT INTO jni_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Izi nu uboo ushi abanga uneh da hem ni ba, indi wa aneni i hem in na banga atize ta zezzere? ");
INSERT INTO jni_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Avene mamu nyene azesere in daki memani de be sa matuu usuro azezze abanname me mani vana unu be sa marani azezzere me. ");
INSERT INTO jni_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kasi musa sama yeze biwa, biginome ani ja'a, ane ani adi yeze vana unubu. ");
INSERT INTO jni_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Barki vat desa ma hem in me madi kem uvenke uzatu umara. ");
INSERT INTO jni_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Barki uhemme sa ugomo asere mawu uneh men madusa ma nya vana uinde ugino me, barki vat debe sama kaba me kati macorno me, idi cukono me madi kem venke uzatu umarsa. ");
INSERT INTO jni_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ugomo asere matubarka vana umeme uneh ugeme barki agi ma weki tize tini ba manyari uneh ukem ukaba ahira amame. ");
INSERT INTO jni_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Vat debe sama hem me, ada weke me tize ba vat debe sa ma nyari me uhem in niza nu vana u inde ugino ugomo asere. ");
INSERT INTO jni_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","U weki utize teki u yenne masa'a mariba uneh anabu wa taki unu nyara u mareu nan kani. ");
INSERT INTO jni_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Vat de sa ma wuza imum izenzen ma nyar si me masa'a me nyani agu ma hanaa hira anmasa'a me barki kati a iri katuma ka zenze ka meme. ");
INSERT INTO jni_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Unu uwuza ukadura me mani madike ma-e ahira a masaa me, barki masuso tize timeme, unuguna, ugomo asere mani mawuna ini. ");
INSERT INTO jni_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yeso nan nahana akatuma kameme wa dusa amanyanga mu yahudiya abinime madii nan we mazi nu zarso anabu. ");
INSERT INTO jni_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahaya mazin nu zorso anabu uainon mamamun nan nu salima barki gmei marani gbardan ahira me anabu wa ezi azorsowe. ");
INSERT INTO jni_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Barki anime da amu hanan yahaya udenge uni rereba. ");
INSERT INTO jni_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Abineme ana katuma ka yahaya wa meki matara nan ure u yahude ahira a tize tumeki unicce. ");
INSERT INTO jni_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wakuri wa eh ahira a yahaya, wagunmme desa dati wazi wazi nanme, urusa u urdun me, desa hu necce nu we wabezi urusa ume, manno mazin nu zorso anabu ine ini anabu wazin nu haza ahira ameme. ");
INSERT INTO jni_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahaya ma kabirka magu in daki anya unu imum ahira a sere unu ukem ini mazoni. ");
INSERT INTO jni_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Shi acce ashime irusa uguna ana azo mimani asere me, mi a tuburkon ini a je ameme. ");
INSERT INTO jni_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Una anya memani unu unee uso uroni unu nee sa ma turi, magunna tize timeme, ma wuza apuru arom kgan innu kunna uni gmirang ni manyani manya me, barki ani me iriba iram in ya gminca. ");
INSERT INTO jni_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Me madingi ukingizi mi, indii unu kaza unupum. ");
INSERT INTO jni_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Unu aye usuro azesere marani azesere nan na nabu desa marani adizii me una dizzii mani tize ta dizii tini mawuza, unu uayye azezere mara azezere a ko de avi. ");
INSERT INTO jni_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Imum be sama kunna ma kuri ma ira, ine ini mazin nukurzo men, vat anime anu wa game imum be sa mazi nu boo me. ");
INSERT INTO jni_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Vat desa mahem ini mum be sa maboo makuri, matunno azezzere ani uguna ugomo Asere una kadura mani. ");
INSERT INTO jni_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Barki desa ugomo asere matu mime, abanga ugomo asere ani maboo, ugomo asere ma nyinza bibe bizatu ubinani. ");
INSERT INTO jni_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Acome ma hem invana me makuri mawu vat imum atari ti meme. ");
INSERT INTO jni_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Desa ma hem invaname mazin nu venke uzatu ubinani. De be sa ma game vana me, mada kem me uvenke ugino me, madi ribe anyimo iriba ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Sa ugomo asere Yeso mausi unu guna afarisiyawa wa kunna agi ma kem ahana akatuma makuri ma zorsowe matike yahaya me. ");
INSERT INTO jni_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Azome yeso mani ma zorso anuba ahana aka tuma kami kani). ");
INSERT INTO jni_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma dusa maceki manyanga mu yahudiya, makuri a manyanga mu galili. ");
INSERT INTO jni_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya cukuno gbas ni uwatu a manyanga mu samariya. ");
INSERT INTO jni_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma-eh anire nipin ni manyanga mu samariya, sa atisa nini agi saikar, ma-manu nan nu ubinani u manyanga me sa yakubu mei nya van umeme yusufu. ");
INSERT INTO jni_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Urijiya uyakubuwabini ani urani: Barki auzo atanu, Yeso macukuno ani me ayo urijiya me, ina tii ma uwui uni wazi. ");
INSERT INTO jni_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Abini me ure uca wanu samariya ma-eh utuka uymei. Yeso magun me, “Nyankum gmei in sii.” ");
INSERT INTO jni_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ana katuma kameme waribe anipin ukpa imumare. ");
INSERT INTO jni_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ucha wanu Samariya magun, “Yeso aneni u Yahude udi ikum gmei ma saa ahira am mi sanzi unanu samariya?” (Barki a yahudawa wazo me anu inde nan anu samariya). 10 ");
INSERT INTO jni_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeso makabirka me magu dagusi urusa unyanki wa asere uni, nani desa magunan hu unyanki me gmei me uda ikome ma nyaki we gmei mu zatu marsa. ");
INSERT INTO jni_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uneme magunmme hu una aje uzo we ini imum u inta ugei me, urijiya me uyenne uzi coccom abani hu udi kem gmei mu zatu umarsa. ");
INSERT INTO jni_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ya cukuno hu uteki acco uru me yakubu unuge sa cekin duru urijiya me, nicce ni meme wana ahana ameme, nan ma damba ma meme, sa wa sii gmei mu rijiya ugenne me. ");
INSERT INTO jni_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeso maka birka me magu, “Vat desa masa gmei maginome madi kuri makunna niwee ne gmei. ");
INSERT INTO jni_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Desa masaa gmei me sa indi nya me madi kuri makunna niwee nigmei ba gmei me sandi nyame madi cukuna me uvenke uni ahira ameme uzatu umarsa.” ");
INSERT INTO jni_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Unee me magume, hu una kura gmei me mu venke me, kati niwee nigmei nikuri nimekum, barki inkuri in'eh utukame. ");
INSERT INTO jni_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeso magumme dusa uka aye nan nu ruma uwe me. ");
INSERT INTO jni_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uneeme makabirka me inzin nu rumaba, “Yeso magummee kadura kani wabuka uzin nu uruma ba. ");
INSERT INTO jni_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wa wuza anya kani chibi desazi nan me uruma une maniba abanna wakuka kadura.” ");
INSERT INTO jni_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uneeme magumme hu una kura marusa hu una kadura kani. ");
INSERT INTO jni_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Acokoro aru uzi biregara anipo nige me shi be yagu u urshalima uni ahira me sa ateki shi unu uree idingi u wuzizza ubi ringara men.” ");
INSERT INTO jni_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeso magunmme unee hem mi uganiya u eze, sa adi da wuzaa biregara ba, azesere anipo, nani urshalima ba. ");
INSERT INTO jni_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Shi itunguzuno imum be sa ita shi ini, haru ti tunguzuno imum be sa ti rusa ini, barki ukem ubura uro usoro yahudawa uni zi. ");
INSERT INTO jni_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Uganiya u eze, wamu aye, sa anu tukunzino ukadura wadi tunguno acco anyimo abibe, nan kadura anu usanda utugungino ugino uni asere ma nyara we. ");
INSERT INTO jni_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ugomo asere bibe bini an debe sa wa tunguzino me wa tunguzino me anyino abibe nan kadura. ");
INSERT INTO jni_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Unee me magunme, “Inrusa masihiya ma eze, desa atisame ugomo Asere uganiyame sama aye, madi bezi imum vat. ");
INSERT INTO jni_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeso magunme mimani unatize tige me sa in zin.” ");
INSERT INTO jni_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Abinime ahana akatuma kameme waze wakemme mazin tize nan vanu u'eh imum me i nyawe biygan anyimo aweme daki uye magu nyanini vana u'eh me ma nyara nyani nyanini ya wuna mazin in tize nan me. ");
INSERT INTO jni_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uneh me mahiri ma ceki nidong ni meme, ma kuri anipin ma buki anu, ");
INSERT INTO jni_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ayyenii liri unu be sa mabom vat imum sa ma wuza ini kati nyani memani asere me?” ");
INSERT INTO jni_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wanno wasuri anyimo anipin me wa ka kem me. ");
INSERT INTO jni_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Arani anyimo anime ahana akatuma kameme wa tir me tari wagunmme hu una aje, “Re'imare.” ");
INSERT INTO jni_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Abini me magun we inzini imare be sa shi iteshi ini.” 33 ");
INSERT INTO jni_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ahana akatuma kameme wa igi acce awe me, kat uyye mani ma ayye men inimare me?” ");
INSERT INTO jni_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeso magun, “We imimare im ine ini in wuzi katuma kade sa matuman inkuri in minca katuma ka meme. ");
INSERT INTO jni_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Izinu gusa agi usana-ahira wade tipeu tinazi hanii? In zini uboo ushi, irani tirung l iri in tabari uguna adri bisana me. ");
INSERT INTO jni_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Unu kara ubisana me madi kem imum be sa ma nyara, makuri mazinu orzo ubi sana me ahana uvenke uzatu umarsa, barki una tibira nan unu orso wa wuzi iraba irom nigo me. ");
INSERT INTO jni_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Abanna me, ni gbuang ne tizeme kadura kani sa na guna uyyen inti bira, a uyyen unu orso. ");
INSERT INTO jni_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Matumashi uka wa saa ni re-ren shi ya kem ya re uronta me.” ");
INSERT INTO jni_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamariyawa gbardang anipin ni gino me wa hem imme barki tize tu unee ugino me sa ma magu, ma boom vat imum be sa ma wuzii ini. ");
INSERT INTO jni_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa asamariyawa wa ha-a ahira ameme wa gunme matuu ahira aweme mawu tiye tire nan we. ");
INSERT INTO jni_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ayye gbardang wa keki ana je me wa hem in kadura me barki tize timeme. ");
INSERT INTO jni_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wa dusa wagun, “Vanu u-eh me haru ta hem in kadura barki imumbe sawabuka cas ba barki haru ta kunna ina cee aru me.” ");
INSERT INTO jni_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sa mawuna tiye tire mahiri madusa ama nyanga mu galili. ");
INSERT INTO jni_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Barki anime Yeso mabuki uguna vana ukadra ka sere ada hira me iri imum ini amanyanganmu meme. ");
INSERT INTO jni_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sa ma biki a manyanga mu galili ini anu galiliyawa wa-eh wakabi me barki wa iri vat imum be sa ma wuzi ini a urshalima uganiya u idi, barki we me wa haa udi me. ");
INSERT INTO jni_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Manno makuri mahaa ukana a manyanga mu galili, ahirame sa magamirka gmei macukuno, uwango. Ukarna hum uyye marani desa vana umeme mazi uhumaba. ");
INSERT INTO jni_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sawa kunna Yeso masuro amanyanga muyahudiya makuri amanyanga mu galili mano madusa ahira ameme maka tirame tari agi ma-eh ma human vaname barki amarani ayino iwono. ");
INSERT INTO jni_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeso magume inka daki mawuza imombe sa idi nyashi biyyau ida nyashi kadura ba. ");
INSERT INTO jni_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Una katuma kanyino kalikobo me, magunme unu-udang aye a kpana kum kudaa sarki wono. ");
INSERT INTO jni_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeso magunme; dusa imum iwe vana me maciki uhuma mawono ba, unome madusa ma hem in tizeme sa Yeso mabuka ma dusa atan tume. ");
INSERT INTO jni_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maraa anyimo tanu ba ana katuma ka meme wa kabi me, wagun me, vana u weme ma huma. ");
INSERT INTO jni_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Madusa ma ikiwe uganiya be sa nipum ni vana me ni ba tuba uwuna u me shew wagun me, ninji inna azumo a inde uwui ukoni me wa ceki me.” ");
INSERT INTO jni_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ine ini acco me marusi uganiyame sa Yeso maukime, vana uwe me mahuma. Meme in nicce ni meme ma kabi kadura me, nan ana akura ameme vat. ");
INSERT INTO jni_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iginome ine ini imum ibiyyau ikure sa Yeso mawuzi, sa ma kuri amanyanga mu galili usoro amanyanga mu yahudiya. ");
INSERT INTO jni_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Anyino anime awuzi ure uidi wa yahuduwa, yeso abini me ma dusa me urshalima. ");
INSERT INTO jni_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A urshalima, mamu nan nana tukum itam mare gmei marani a tisa mani betasda inti yahudawa akiti ahirame in madanga manu cibi. ");
INSERT INTO jni_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A ma dangame anatikoni wameme utozoni, arubo nan na gurgu nannu kasu ana tikoni wa nyarga abankurko gmei me. ");
INSERT INTO jni_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Urunu marani ma wu tiwe akure taru in tini wititari unu koni. ");
INSERT INTO jni_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sa Yeso ma iri me marari, marusi madadan kino innu konime, manno ma ikime unyara uhuma?” ");
INSERT INTO jni_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Unu konime makabirka me magu hu unaje, inzin desa madi benkum ba uganiya sa bukurko gmei me uganiya sa ahira u hana ahira a gmei me uye madi agizamni uribe me. ");
INSERT INTO jni_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeso magunme hira uziki upenge uwe me udusa. ");
INSERT INTO jni_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Abinime unu konime mahuma maziki upenge umeme mamiki tanu unu uwui asabar. ");
INSERT INTO jni_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Barki anime ayahudawa wagun in de sa ahumame, kanime asabar ani daki yawuna uree uzeki upenge uwe meba. ");
INSERT INTO jni_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Manno makabirka we mi desa mahumanmi memani maguna inziki upenge umme in dusa.” ");
INSERT INTO jni_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wanno wa ikime uya unu mani maguna hu uziki upenge uwe me u dusa?” ");
INSERT INTO jni_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Me de sa a huma me daki marusi unu uhumam me ba, barki Yeso manu ceki ahira me barki anu wa ori gbem. ");
INSERT INTO jni_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yeso makuri ma iri me udenge ubiringara magumme, ira wahuma ceki uwuza umadini, barki kati iri mumbe sa iteki igino me unu zenze ikewwe. ");
INSERT INTO jni_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Unu me madusa mabuka a Yahudawa agi Yeso mani mahunan me. ");
INSERT INTO jni_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Barki anime ayahudawa watubu suzurka u Yeso agi mahumzuna anu uwui asabar. ");
INSERT INTO jni_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeso makabirka magu acco-am mazin katuma ana me, mi me in zin nu wuza me. ");
INSERT INTO jni_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Barki anime Ayahudawa watubu unyara unaa uge sa wadi hu Yeso barki uwuza ukatuma ihuwui wa asabar cas ba agi maguna acco ume mani Asere agi mainso nicce numeme rep nannu gomo asere. ");
INSERT INTO jni_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeso makabirka we magu, “Aneani mabuka shi vana mada wuza katuma in sissi me ba barki vat imum be sa acco mazi nu wuza me, ine ini me vana me kane kani vana mazi nu wuza ma. ");
INSERT INTO jni_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Barki acco me mahem vaname makuri mabezime imumbe sa ma wuza, madi kuri mabezime bi wuza-wuza bige sa biteki bigino me, barki i kunna biyyau. ");
INSERT INTO jni_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kasi acco me sama hirza mukizi makuri ma wuzi we ivai ni ani mani vana me madi wu de be sa tutto me iriba iai. ");
INSERT INTO jni_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Acco mada hungo un titoi hem anime ba madi ceki imum atari ti vana tini vat. ");
INSERT INTO jni_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Barki kodevi manonziko vaname, kasi acco me sadi nonziko vana me ba mazo me uni nonziko acco me ini. ");
INSERT INTO jni_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ine ini mabuka shi, vat desa madi kunna tizetum manya kadura nan desa matumam, mazin nu venke uzatu binani. Ada hunguko me tittoi ba barki mamu hangirka iwono, ma hana nan nu venke. ");
INSERT INTO jni_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mabuka shi uhaniya u'eze wamu aye sa andesa wawijo wadi kunna gmirang nivana asere anu kunna me a wa kem uvenke. ");
INSERT INTO jni_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kasi acco me sa me mani nitin nu venke animani ma wuna vaname macukuno nitin nu venke. ");
INSERT INTO jni_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Makuri manya me nikara nu inko utize barki me vana unuboo mani. ");
INSERT INTO jni_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kati ikunna sas tiye ti eze tige sa andesa warani amucau wadi kunna tize tumeme. ");
INSERT INTO jni_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Wakuri wasuri desa wuza katuma karere wadi hiri andesa wawuza katuma kazenzen, wadi hiri u hira u weki utize. ");
INSERT INTO jni_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Indake in wuzi ire imum ni iri sisii um, kasi rep imum be sa in kunna animani in wesi tize uwesi utize tume tire-retini barki azo imum iriba in iniinzini euza imum ide be sa tumam. ");
INSERT INTO jni_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Inzin nubezi nicce num ubezi unicce num wacukuno irimum ini ba. ");
INSERT INTO jni_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Un tize ani nicce num marani sas mi in rusa tize me sa mazin anicce nume tire-retini. ");
INSERT INTO jni_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yatumi ahira a yahaya meme mabuki kadura. ");
INSERT INTO jni_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vatin anemi tize me sa ma tonnon azo ti nuboo tini tizi ba. Mi mabuka anime bati i kem ubura uni. ");
INSERT INTO jni_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya upitila uni sa uzin inu raa nan ma saa ya hem unu guna iwu aburu arom gbardang anyimo aku ganiya cingilin. ");
INSERT INTO jni_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Abanna me tize me sa in boo shi ti keki ti yahaya in nikara barki katuma sa acco manyam immari, kane karu ka sa in zin nu wuzame, kane karu ka di susom ama saa unu guna acco am mani matumam. ");
INSERT INTO jni_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Acco me sa matumam me cangi mabuka tize anicce num, ite shi ni gmirang ni meme nyani irusi uzina umeme. ");
INSERT INTO jni_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tize timeme tacukono amuriba mushi me ba, barki ya nyare shi in kadura ka desa ma tumam. ");
INSERT INTO jni_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Izi nu gungizino utize ta sere, shi ibassa anyimo ati ne tini idi kem uvenke uzatu umarsa, ani me tine tini ta sabi ta susom am saa. ");
INSERT INTO jni_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Vat anime ya nyare shi u aye ahira am ikem uvenke. ");
INSERT INTO jni_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","In da uyaram tinanu ahira anabu ba. ");
INSERT INTO jni_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ayimo ani me in rusa shi izo shi unu hem Asere a mu riba mushi me. ");
INSERT INTO jni_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi ma aye in niza nacoo om iyenne, shi be ya nyare mi a gusi uyye mani madi eh in niza ni cicce nume, me mani idi kabin me. ");
INSERT INTO jni_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Idi wuzi aneni ihem kadura shi sa i uyinza acce ashi tina nu ugomo asere mani una tinanu cas ya gaa shi a nyara ume? ");
INSERT INTO jni_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kati ibassa indi han in tize tishi me ahira acco unu hana in tize tishi me marani, me mani Musa. Unu me sa shi ibassan me. ");
INSERT INTO jni_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A gusi ya hem in musa ida hem in mi barki abanga am ma nyentike ani. ");
INSERT INTO jni_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","In daki ya hem ini mum be sa ma nyetike ini idi wuzi aneni i hem in tize tume?” ");
INSERT INTO jni_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Anyimo anime yeso makafa u teku ugalili, a gusan uni uteki utibariya. ");
INSERT INTO jni_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ni gura gbardang ni tarsime barki wa iri katuma ka biyyau sa mazi unu wuza ana tikoni. ");
INSERT INTO jni_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeso ma nyane anipo macukuno abirko nan na hana a katuma kameme. ");
INSERT INTO jni_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(U idi wa yahudawa wa mu aye mamamu.) ");
INSERT INTO jni_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sa yeso mavanki nicce ma iri ni gura ni gbardang ni haza ahira ameme, magun in filibus, “Abani tidi kem immu'are be sa anu age me wadi ree.” ");
INSERT INTO jni_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mabuki anime bati madari me ma iri, barki meme nicce ni meme marusa imumbe sa madi wuu. ");
INSERT INTO jni_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibus ma kabirka magu, immare dinari a ino ana akure ida barime kode vi makem ma re cingiln ba ma. ");
INSERT INTO jni_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Abini me andarawas uhenu u bitrus debe sa mazi vana u katuma me, magun me ana. ");
INSERT INTO jni_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ira kure ku kpana kuinta immare ma mara u cibi musha'ir, nan ni cere ini-re idi wuzi ane ni ibari anabu gbardang ana me. ");
INSERT INTO jni_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeso magu bukan anabu wacukono ahira me azin ukpe. A hana ruma wa cukuno ahiranawwe wazi we udabu cibi. ");
INSERT INTO jni_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeso mazeki ugurasa me, sa bezi a puru aram a meme ahira Asere ma hari andebe sa cicaki ani mani makuri mawun in nicere me, ubinani imumbe sa wa bari we. ");
INSERT INTO jni_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sa ware watii magun na hana aatuma kameme, orsoni ukasume sawade kati iremum ihun neme. ");
INSERT INTO jni_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wanno wa orso ukasu ugurasa ugino unu cibi usha'ir uge sawa din sa koda vi mari matii, ukasume wa minca mugira kirau in mure. ");
INSERT INTO jni_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sa anabu wa iri ubari sa ma wuzi, wa gu ani mani, unu ugeme memani una kadura kasere ugino sa ma eze unee. ");
INSERT INTO jni_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sa yeso marusa wa nyarsa uzika ume inni kafa nan nu binani urusa abanga aweme wa tirzi me tigomo, madusa makuri anipo me in sissi ume. ");
INSERT INTO jni_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Unu wonjoro a hana akatuma kameme wattu uhana uteku. ");
INSERT INTO jni_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wa ribe uzirgi me wa dusa ukafa uhana ukafarna hum, uganiya me mareu mamu wuna Yeso mada sarku u aye. ");
INSERT INTO jni_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ine ini uteku utubi ranza barki upebu wa hiiri ini nikara. ");
INSERT INTO jni_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sa wazin in tanu wa biki gusi ma mei ma taru ahana manzi, wa dusa iri Yeso ma haka azezzere agmei me, ma aye mamamu nan nu zirgi me wanno wadiri urusa ahira me sa warani. ");
INSERT INTO jni_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yeso manno magun we kati i kunna biyyau. ");
INSERT INTO jni_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Abini me ani wa hem me maribe uzirgi me, uzirgi me uba dusa ubiki ukiri me sa wa hazan. ");
INSERT INTO jni_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sa ahira asana ukasu uni ori me sa wadii uhuru uteku me warusi uguna ure uzirgi usoni ahira me, kure ku ciniln kuni karani, iri daki Yeso maribe une nan na hana akatuma kameme, ahana a katuma kameme kani wa dusa cas. ");
INSERT INTO jni_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mure muzirgi mu nan na ahira sa a na ori ware immaren sa ugomo asere ma wu iriba irom men. ");
INSERT INTO jni_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sa niori na ira yeso mazoni, ahana akatuma wa zoni ahirame, wa dusa waribise a mu cinici mugino cangi, uhana ukafarna hum unyara u yeso. ");
INSERT INTO jni_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sa wa kem me uhuru utekum me, wagume hu unudang, “Wa aye abanname unu mayya uni?” ");
INSERT INTO jni_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeso makabirka we magu, rep animami, in booshi izi na nyara um azo barki imum ibiyyau, barki immare ini sa yare ya tonii. ");
INSERT INTO jni_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kati iziti unu nyara immare ige be sa idi corno me, inki immare ido-dongino uhana uvenke uka biki uvenke uzatu umara, uge sa vana unubo mani madi nya shiBarki me mani unu be sa acco, mamani Asere, ma nya me likara ni wuna ugino.” ");
INSERT INTO jni_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wanno imum be sa asere ma nyara? ");
INSERT INTO jni_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeso makabirka we magu, katuma ka gino kane kani Asere nyara, ine ini ihem in de sa ma matuma me.” ");
INSERT INTO jni_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wanno wagumme nyanini udi wu i biyyau sa tidi iri ti hem in huu? uyanini udi wu? ");
INSERT INTO jni_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","acokoro aka cokoro aru ware inama anijaa, sa anyetike unuguna, ma nyawe immare usuro azesere warii.” ");
INSERT INTO jni_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ine ini yeso magun we, inzinnu buka ushi, izome musa mani manya shi immare me sa asuso ini azesere me ba, acco am mani manyin shi immare me. ");
INSERT INTO jni_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ya ira immare igomo Asere ine ini i suso azesere, unu nya unee uvenke. ");
INSERT INTO jni_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wanno wagumme ugomo Asere uyan duru immare igino-koya uwui. ");
INSERT INTO jni_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeso magum we, mimani immare nyinza uvenke me, desa ma aye ahire am, madi kunna ikomo ba desa manya kadura madi kunna niwe ni gmei ba. ");
INSERT INTO jni_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma mabuka shi ya ira vat ani ma daki yanya kadura me ba. ");
INSERT INTO jni_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vat desa acco me manyan, madi eh ahira am, desa ma aye ahira am mi inda gido me ba. ");
INSERT INTO jni_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Barki matino azezsere azo gunna intarsi iriba ini cce num neneba, sai intarsi ireba idesa matumam. ");
INSERT INTO jni_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iriba idesa matumam, ine ini in hem nan kodevi anyimo aninonzo nan desa manyam, indi hirza we rono aye umeme. ");
INSERT INTO jni_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iriba yaco am, vat desa mahira vaname, manya kadura nanmi, madi kem uvenke udadankino, mi indi hirzame rono aye ugomo asere. ");
INSERT INTO jni_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A Yahudawa wa meki ugbejere agi Yeso maguna memani immare iginome saya suro azezsere. ");
INSERT INTO jni_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wanno wagu, “Ingusa Yeso mani, vana u Yusufu, desa ainome nan ka come. Ingusa tirusa we? Nyanini yawuna me maguna, masuro azizsere ani?” ");
INSERT INTO jni_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeso makabirka magun we, “Kati ihummoro acce ashimi ba. ");
INSERT INTO jni_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Unu rusa uhana ahira am mara niba, aco memani cas desa matumum, memani ma hungu kom madi hirza anaboo rono umara unee. ");
INSERT INTO jni_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Anyentike anyimo atize ta sere, nanu bezi tize ta asere vat uwe asere ani adi beziwe, vat desa makaba mamanza ahira acome madi eh ahira am. ");
INSERT INTO jni_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Unu ira acco me mazoni abanna me desa marani ahira Asere memani maira a come. ");
INSERT INTO jni_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mabuka shi makuri mabuka shi, desa ma nyara kadura mazinnu venke udandang. ");
INSERT INTO jni_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mimani immare uninza uvenke. ");
INSERT INTO jni_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vat aka co ashi me wari umanna anijaa wanno wa wee. ");
INSERT INTO jni_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Immare inno izinno tuzo azezsere kode vi marii kati kadevi ma wee. ");
INSERT INTO jni_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mimane uzatu umara sa in zin nu tuzo azezsere desa mare immare me madi wii ba immare me sa manya inama inipum nom nini barki unee ukem uvenke. ");
INSERT INTO jni_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A Yahudawa wa hiran initize acece aure me agi aneni unu ugene me madi nyam duru inama inipum nameme har tirii?” ");
INSERT INTO jni_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ine Yeso magun we ine ni mabuka shi, inki daki yare inama inepum ni vana unububa, ikuri isii maye mameme, izo shi unu venke ahira a shi me. ");
INSERT INTO jni_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Vat andesa wariza inama inipum num, wasii maye mam, maraa anyimo uvenke uzatu umarsa, mi indi hirzame rono umara unee. ");
INSERT INTO jni_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Barki inama inipum immare ige be sa ahira ini, maye mam immare be sa ahirani ini. ");
INSERT INTO jni_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Vat andesa wariza inama inipum num, amasii maye mam maciki anyimo am, mima ayimo ameme. ");
INSERT INTO jni_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Gusi acco me sa ma ciki anyimo uvenke sa matumum, in raa anyimo ati cukum ta cco me tini, ani mani ahira unu ge be sa imani immare imeme madi venke barki mi. ");
INSERT INTO jni_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ige me ine ini immare sa ya tuu usuro azezsere, azo ige sa acokoro anka cokoro ushi me sa warii, vat ani me wanno wa wii. Vat desa mare immare ige me madi madi venke ukabiki. ");
INSERT INTO jni_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mabuki anime anyimo udenge wasere, ahira me sa ma zinu bezi uwe tize ukafarnahu. ");
INSERT INTO jni_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Innu kunnu anime anugbardang anyimo ahana akatuma kameme. Wanno wagu tize tiginome tikuna, aveni madi kunna tini?” ");
INSERT INTO jni_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeso sammu rusa irba imeme ahana akatuma kameme wazennu humoro, mano magunwe eginome ini yacukono imum upilko? ");
INSERT INTO jni_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Idi zi ani inkiya ira vana unubu mazinnu nyeze ahirame sama rani dati? ");
INSERT INTO jni_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Abanna bibe sere bini bi eze nu venke nipum ni zin katuma ka hura, asap me sa mabuka shi abibe bi rere bini wannu, wannu venke. ");
INSERT INTO jni_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ayye ashi me sa warani wa nyarima kadura me, barki datti Yeso marusa ande sa nyara me unya acce in kadurame, nan de be sa madi vete wen. ");
INSERT INTO jni_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Manno makuri magu ine ini mabukashi, unu aye ahira am ma, omi, inki acco am maceki me abine ani madi eh. ");
INSERT INTO jni_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Barki tize gino me ahana akatuma ka meme gbardang wakuri madumo, daki wakuri wa haki nan me. ");
INSERT INTO jni_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeso magun nanu kirau in wa-re me, shi me cangi inyara udusa? ");
INSERT INTO jni_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bitrus makabirka magu, ugomo Asere ahira aveni tidihan? Hamani uzin tize tu venke uzatu marsa. ");
INSERT INTO jni_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Harume tanya kadura takuri taira hamani unu lau ugi wa Asere.” ");
INSERT INTO jni_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeso makabirka magunwe ingusa mimane mazauka shi kirau nanawarem? Unu inde ushi uburu mani. ");
INSERT INTO jni_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ma insi ani cce ni yahuza isicaroti usan usamanu barki memani nyam me, sa izi uye anyimo ashi me ukirau ina na ware. ");
INSERT INTO jni_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anyimo anime Yeso mameki ukesse amanyanga mugalili mahem mateki manyanga muhudaidaba, barki ayahudawa wa nyari huna ume. ");
INSERT INTO jni_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Uidi wa yahuduwa wamu aye mamamu. ");
INSERT INTO jni_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ine ini anu henu umeme wagunme, hira abanname udusa a manyanga mahudiya, ahana akatuma ka we me wa iri imum be sa uzinu wuza ma. ");
INSERT INTO jni_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Una katuma nihunzi maraniba, inka manyara macukono ma bari hu sa u wuza ti mum-mum tige me, kini ubezi unee nice niweme. ");
INSERT INTO jni_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Barki we anu henume daki wa hem in kadura ka meme. ");
INSERT INTO jni_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ine ini Yeso magun we, uganiya um udazo asime vat uganiya ushe uni uzi. ");
INSERT INTO jni_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Unee ukaki uda nyare shi, abanname mi, mani wa nyare mi barki ma buka uguna katuma ka uni kaburu kani. ");
INSERT INTO jni_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Shi dusani ahira uidi me, mi inda hanam a'aname, barki uganiya um udaa sarki u aye. ");
INSERT INTO jni_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sa mabuka we anime mausa matonno amanyanga mu galili. ");
INSERT INTO jni_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sa anu henu umeme sawa dusa udime, me mahiri madusa anyimo awi hunzi, daki masuso nice ni meme a masaa. ");
INSERT INTO jni_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayahudawa wameki unyara ume ahira uidi me wameki gusa, agi maraa abani? ");
INSERT INTO jni_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nigura nimeki bibukom anicce numeme, aye wa gusi, unubo mani sa adi iri aye wagusi mazin nu ranga anabu. ");
INSERT INTO jni_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Daki uye matonno ma buki tize timeme a ma saa, barki wa kunna biyyau ba Yahudawa. ");
INSERT INTO jni_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sa u idi wabiki atii Yeso maribe u denge utize ta sere mabui tize. ");
INSERT INTO jni_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A yahudawa pum a wu we cam-ca, wa gu ama, aneni unu uge me maruse u bassi ihuri lau aname, iyenne daki mabezi uguna marusa ire imum. 16 ");
INSERT INTO jni_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeso makabarki magu, urusa ugime sanzini umumi ba. Udesa matumum uni. ");
INSERT INTO jni_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Vat de sa manyara ma wuzi katuma ka Asere, madirusi ubezi wa asere uni, nya in, inzi nu uboo me anicce nu mini. 18 ");
INSERT INTO jni_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Desa maboo tize barki necce nume, manyara unonzo unicce ni meme nini unu nyara unonzo udesa matumame, memani una kadura, macico mazoni anyo ameme. ");
INSERT INTO jni_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Azo musa mani manya shi ainko utize me? Vat ani me daki ya inko ni tize me anyimo ashi me. Nyanini ya wuna ingara uhuna um?” ");
INSERT INTO jni_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Anu me sa orno wakirka wagu, “Uzinu pebui aveni manyara ahuna uwe?” ");
INSERT INTO jni_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeso makabirka magu, katuma ka inde kani ma wuza, vat ushi izinu hira imu isso ini. ");
INSERT INTO jni_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa maceki shi nigbari, uguna memani matubi acokoro wa cokro wani, ayenne, i wuza nu nigbari rono uwui wa sabar. ");
INSERT INTO jni_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Unubo nigbari unu wui asabar barki kati agu afatilka tize ti muusa, ine ini ya kunna iriba barki a human nu unu rono uwui asabar? ");
INSERT INTO jni_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kati i waki tise anyimo uzatu urusa, abanna me wenki imum be sa idi ronta.” ");
INSERT INTO jni_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ara anu urshalima wanno wagu, azome unu ugino mani sa wa nyara uhuna umeme ba? ");
INSERT INTO jni_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mayenne mazin tize a masaa, daki wagunamme imumba, nani anaje arumae warusa memani vana aserer me? ");
INSERT INTO jni_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Agino haru tirusa ahira me samarani, uganiya sa vana asere ma eh unu urusa ahira me sa marani mazoni.” ");
INSERT INTO jni_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeso mazennu bezi anaboo. Tize ta asere anyimo udenge Asere, manno mayeze nigmirang magu, irusam irusa ahirame sa in rani. A zo agi ma ayye barki nicce num, de sa matuman una kadura kani, meme teshi me. ");
INSERT INTO jni_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mi in rusa me, barki ahira ame ani masuron, memani matumam. ");
INSERT INTO jni_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bark anime wanyari guna wudi mekime, a diri de sa madi darimme barki uganiya umeme wada sa arku aye. ");
INSERT INTO jni_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vatin aneme anabo gbardang ahira anigura me wa hem in kadura ka meme, wazi nu gusa ana, uganiya sa ugoma asere ma aye, madi muzi ti mummu tige sa ti teki ti unu geme? ");
INSERT INTO jni_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afarisiyawa sa wa kunna magusa- magusa anime, abini me ana adandang atize wa farisiyawa watumi ana katuma kudenge Asere agi wa mekime. ");
INSERT INTO jni_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeso magu, “Ana uganiya um wa dee cingilin nan shi, abini me ani indi kuri ahira ade sa ma tumam. ");
INSERT INTO jni_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Idi nyarin ni, ida irani ba, ahira me sa indi rani ida kem i haa ahira me ba.” ");
INSERT INTO jni_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Abini me ayaduawa wanno wagu acce-acce awene, “Abani ma hazanna sa tida ke ti haa ahira mee? Ma haza ahira a Yahudawa be sa warani anyimo alem, ma bezi alem mee. ");
INSERT INTO jni_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma bassa aneni unu guna agi, idi nyari ni mi ida kem mi ba? Nan nu guna agi ahira me sa in rani ida kem i haa ani ba?” ");
INSERT INTO jni_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Rono masirka uidi, uwui udandand yeso mahiri matono, mayeze nigmirang magu, desa makunna asaa agmei a ma eh ahira am masi gmei. ");
INSERT INTO jni_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Vat sa ma hem mi, gusi ubuku utize ta Asere, usuro iriba imamani maraba ma gmei madi zi. ");
INSERT INTO jni_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Agino me ani mabuki abanga abibeu, ahiran ande be sa hem me wadi kabi, barki daki a munya bibeu me, barki sa a daa saarku unoziko u Yeso. ");
INSERT INTO jni_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sa kunna tize tiginame, aye anyimo ani gura wagu, animani unu uge me memani una tize ta sere ugino me. ");
INSERT INTO jni_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aye wagu, unu geme Asere mani, aye wagu nyanaa? Asere madi sura a manyanga mu galilinmani?” ");
INSERT INTO jni_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tize ta sere daki ta buka uguna Asere madi suri ani kura ni Dauda nini ba, nyani ubaitalami uni tirani, nigiro sa Dauda ma a'kin?” ");
INSERT INTO jni_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","U harzina waribe a acce-acce aweme ameme. ");
INSERT INTO jni_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ayye wanyari umeki ume, wanno wa diri acce uguna wa meki me nyani unu inde ma daki madari me ba. ");
INSERT INTO jni_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Abini me ana katuma kudenge Asere wakuri ahira ananu a ma firistoci nanna Farisiyawa wanno ayen me ahira aru me? ");
INSERT INTO jni_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ane ani ana katuma kudenge wagu, azo animani izi, daki uye ma ma cukuno mabui tize gusi tigino me! ");
INSERT INTO jni_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afarisiyawa waka birka we wage, kati, shi me cangi a soki shi a ma reu? ");
INSERT INTO jni_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Antani uye marani anyimo ana jaa nyani Afarisiyawa ma hem in m? ");
INSERT INTO jni_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nagura nigenome sani da ta me tize ta sere me, Asere a vavi we tari adii-si. ");
INSERT INTO jni_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimo sa mahaa ahira ameme dati, me arani nanwe, mayunwe. ");
INSERT INTO jni_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ani, tize tiru ta guna weki unu tize azo akunna anyo amemeba, arusi imumbe sa ma rani anyimo me?” ");
INSERT INTO jni_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wa kabirka me wagu, hume unanu galili mani? Gunkonon memeru uiri, unu ube zi utize ta sere mago ni sa madi suri amanyanga mu Galili.” ");
INSERT INTO jni_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Abini me kondevi ma dusa akura. ");
INSERT INTO jni_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeso maha ani po nu zaitun, ");
INSERT INTO jni_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ni sisizo maze udenge wasere, anu vat wa eh ahira ame; ma cukuno madun garwe. ");
INSERT INTO jni_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ba anu nitike nan nanubezizi uru sa wa en ure vanau e sa amekki me in ni hara ni ma dini. Wawume atii. ");
INSERT INTO jni_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ba wagun me, “Unu dungara, unee uginome a mekkime mara anyimo uwuza uni hara ni madi. ");
INSERT INTO jni_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Anyimo uweki utize ti Musa maguna n duru ti tizi usasana wanu aginome, hu nyani waguna me?” ");
INSERT INTO jni_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wabuki anime barki wa masame. Wa kem imumbe sa wadi buki ani ce nu me, Ba Yeso ma tunguno ma nitiki a dizii inni bo nume. ");
INSERT INTO jni_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sawa reje innu igizo ume, maluri ma tonno magunwe, “Deebe sa ma zoome in madini ba anyimo ashime, matubi u vingizi ume inpo”. ");
INSERT INTO jni_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Makuri mutunguno, ma nitiki innibo nume adizii. ");
INSERT INTO jni_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sawa kunna anime, wasusi a inde-inde, umeki uzika unaanu uwe. Umasir ka a ceki Yeso me i sisi ime nan nu ne me sa mara atii awe. ");
INSERT INTO jni_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeso mahiri matonno ma gunme, “Unee, ani anu boo uwe wa raa? Daa unu reki uwe marani ba? ");
INSERT INTO jni_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Magu, “Unu mazoni, Ugomo Asere” Yeso magu, “micangi daki mare kuwe ba. Dusaule kati ukuri u wuzi ni hara nimadini. ");
INSERT INTO jni_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeso ma kinki ubuku tize nan nanume magu, mimani masz munee, me desa ma tarsam, mada wuza me tanu anyi mo amareuba. Anime madi kem masa mi vai. ");
INSERT INTO jni_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Anu bezizi urusa wagun me, “U nyinza urusa uni ce nuwe, urusa uwe daki u ka daure kaniba”. ");
INSERT INTO jni_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeso ma kabirka magunwe, “Inki manya urasa ani ce num kadure kani, inrusa ahira sama suroni nan na hirame sandi dusani shi tashi ahira sa masuro ni ba, ida kuri irusi shi ahira sandi dusa niba. ");
INSERT INTO jni_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","I wesi tize tu hemu ni ce, mi daa mawe ki uye tize ba. ");
INSERT INTO jni_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko gusi ma agu ma weki uye tize, u weki utize tum kadure kani barki dakki min sisi in iniba, inzi nanka coo desa ma tumam. ");
INSERT INTO jni_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Um, anyimo u inko u tize tishi a ni tike u guna unyinza urusa ana ware kadure kani. ");
INSERT INTO jni_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mimani in zini nyinza urusa unice num, me a coo desa matumam mazin nu nyinza urasa um. ");
INSERT INTO jni_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wagun me, “Acoome maraa?” Yeso ma ka birka we magu, “itashimiba nani a coo um, inda gi irusam ida rusa a coo u me. ");
INSERT INTO jni_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mabuki ni guran nigino mamu nan na hira ati inso uganiya amen nu dungara anyimo udenge Asere, ani me daki uye ma meki barki sa u ganiya u me dakki wa wuna ba udaza. ");
INSERT INTO jni_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Makinki uguna uwe, “indi dusa, idi nyarini mi ida kem me miba, idi wiji a nyimo u cara abanga ashimeni. Ahira san in haza idake irusa u hana me ba. ");
INSERT INTO jni_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mayahudawa magu, “Madi hu ni ce nume ni ni, sama guna ahira sa in haza idakee ida hana shiba?” ");
INSERT INTO jni_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu magun we, shi a dizi ani irani, mi Asesere ani. Shi ira unee ugeuni, mi kuma daki un nee ugen ne uniba. ");
INSERT INTO jni_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inee ini ya wuna magunan shi idi wiji anyimo ucara abanga ashime in. Indaki ya hem in mi ba idi wiji anyimo amadi mashi. ");
INSERT INTO jni_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba wagun me,”Humani aveni?” Yeso magun we, “imumbe sa mabuka shi da ti utuba. ");
INSERT INTO jni_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","In zin ni mum gwardang san di buki shi, inkuri in gbarika shi aini. Vat a ani me de sa ma, tumam, una kadure mani, ati mumume sa makuna ahirame, ti mu mum tigino tini in bo unee.” ");
INSERT INTO jni_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Daki wa rusa imumbe sa mazin nu bo me ani ce na coo me. ");
INSERT INTO jni_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeso magu, “Inki yahiriza vana unu Azesere ani me idi rusi mimani, daki ma wuza ani me barki ni ce mumba, kasi gusi a coo ma dungaram, ane ani in bo ti mumum tiginoo. ");
INSERT INTO jni_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mede sa ma tuma, ma zi nigome nan mi daki ma cekum isisi imba, barki in wuza timumu sa ti mumum tiginoo. ");
INSERT INTO jni_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sa Yeso mazin nu bo uti mumu, gbardang wa hem in me. ");
INSERT INTO jni_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeso ma buki Ayahudawa sa wa hem in me, “inki yatonno anyimo atize tum shi anu tarsa um wani aka dure. ");
INSERT INTO jni_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Idi rusi kadure, kadure kadi burishi. ");
INSERT INTO jni_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wakabirka, “We bisana bi Ibrahim bini daki tamu wuza nirere ahira a uyeba, aneni udigu, a dibuiri shi?” ");
INSERT INTO jni_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeso magun we, “kadure, kadundure, in gussan shi, vat de sa ma wuza bi wuza wuza bima dini urere u madini mani. ");
INSERT INTO jni_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Urere be, mada cikke akura madini ba, dama ciki madisani. ");
INSERT INTO jni_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Barki anime, inki vana mabura shi, idi cukuno anu bura kam. ");
INSERT INTO jni_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","In rusa shi bisana bi Ibrahim bini, inyara ihuni mi barki ni guran num ni zomen na hira ati cukum anyimo ashi. ");
INSERT INTO jni_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mabuka ti mu mum sa ma ira ahira a coo um, shi iwuza imumbe sa ya kunna ahira a coo ushi.” ");
INSERT INTO jni_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wa kabirka wagun me, “Ibrahim mani a coo uru” Yeso magun we, “Gussishi a hanna Ibrahim wani ida wuza i mumbe sa Ibrahim ma wuza. ");
INSERT INTO jni_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ine ini aname inyara ihunimi, unume sama buka shi kadura sa makunna a hira Aserte. Ibrahim daka ma wuzi anime ba. ");
INSERT INTO jni_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","I wuzi imumu ya coo ushi. Wagun me, “Haru daki ayon duru upebu uniba, tizinka coo u inde: Asere.” ");
INSERT INTO jni_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeso magun we, “Gusi Asere a coo u shi mani, ida hemin mi, barki ma aye usuro a hira Asere mibe abame, daki barki ni ce num nini ma aye ba, Me nani matuman. ");
INSERT INTO jni_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nyani ya wuna daki ya rusa tize tumba? barki sadaki sa idake ikuntize tum tiniba. ");
INSERT INTO jni_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Shi wa coo, ushi uburu mani inyara i wuzi imumu ya coo ushi. Me unu huzaa nu mani daati utuba mada tunzino me a kadure barki kadure ka zoni a anyimo ame. Uganiya sa mabo ma cuco, mabo u zina ume uni barki me una macuco mani nan ka coo a mooco. ");
INSERT INTO jni_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","In boshi kadure daki ya nyaa ce in mi ba. ");
INSERT INTO jni_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Avee ni anyimo ashime mamekum in hara nimadi? Inki mabuka kadu re kani nyani yawuna daki ya hen in miba? ");
INSERT INTO jni_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Me de sama zi wasere make ma kunna tize ta, asere, shi da kunna shi tize tasere barki sa shi da Asere.” ");
INSERT INTO jni_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mayaduwa wakabirka me, “tidabome kadure ba barki sa taguna hu ubasamariya mani u zin na gbergene?” ");
INSERT INTO jni_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeso makabirka, “Minzoom na gbergene, inyinza a coo um ti nanu. Slibe ida nyin zami tinanu tum ba.” ");
INSERT INTO jni_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Idaa nyaram u ye zize u nice numba, anunyara u anime warani wagwara. ");
INSERT INTO jni_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kadure, Kadure imboshi. Vat due sa matarsa tize tum, madida irame iwono ba.” ");
INSERT INTO jni_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ba mayahudawa wagunme, anume tarusa in zin na gbergene. Ibrahim nan ana katuma kasere wa wijo. hube waguna, debesa matarsa tize tuwe madi da donkin kino me iwowoba'. ");
INSERT INTO jni_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Uda tekuwe a coo uru Ibrahim sama ma wi, nani uteki me? ana dang aka tuma kasere wawijo, hu ucira nice nuwe aveni?” ");
INSERT INTO jni_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeso makubirka, “Inki ma heza nice num uyeze usisi unee ani, acooum mani Asere ashime. ");
INSERT INTO jni_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Shibe itashime ba, min inrusanme. inki maguna intamin me, macukuno kasi we ini, una ma cuco. ");
INSERT INTO jni_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Min rusanme intarsa tize tume. Aco ushi ibrahim ma zin na puru a rum in nu ira u wui um, ma ira uni ma wuna apum arum”. ");
INSERT INTO jni_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma yahudawa wagun me, “Daki wabiki tiwe akuru ciibi sa udigu wamu ira Ibrahim?” ");
INSERT INTO jni_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeso ma gun we, “kadundure kani in boshi, ayoo Ibrahim adumo am ani. ");
INSERT INTO jni_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wa ziki apo wadi tizimeni, Yeso ma hunze nice mimeni, ma suri u denge Asere me. ");
INSERT INTO jni_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sa Yeso ma haka u aka ma iri ure urubu datti sa ayo me. ");
INSERT INTO jni_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Anu tarsa umeme wa iki me”vana udungara utize ta Asere, aveni ma cari abangan, me mani nani aka co me, sa ayo me urubo? ");
INSERT INTO jni_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeso makabirka, Inzo memani ba nan aka co me wa cari abangan ba, ani me bati abezi katuma ka Asere anyumo ame. ");
INSERT INTO jni_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ya cukuno gbass tiwuzi katuma ka de sa matuman unu wui. Niye ni ize ba de sa madake ma wuzi katuma. ");
INSERT INTO jni_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Uganiya sa marani une mi mani ma saa mune. ");
INSERT INTO jni_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sa Yeso ma boo timum tigeme, ma cofi tobi adizi, ma cumzo manyanga me in tobi tumeme, ma humka aje unu me inti nyanga me. ");
INSERT INTO jni_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma gun me, dusa, uka kpico ani w(n nu siliom (Agi kadura). unu me ma dusa maka kpico aje me apokino. ");
INSERT INTO jni_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Anu turra umeme nan nabu sa wa russi me ini kuri wa gu, “Inzo unu ugeme mani unu wuza unukuri nigemeba?” ");
INSERT INTO jni_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aye wa gun “memani”. Aye wa gu “im-im, anime ma insa muhenu mumeme”. Anime ma gu “mimani unu igino me”. ");
INSERT INTO jni_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wa gun me “Awuza aneni a poko we aje?” ");
INSERT INTO jni_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma kabirka “Unu me sa agusan me Yeso mani ma rumo tinyanga ma humka aje ma gunan mi. hana uraba u siluwam uka kpico. mi be maka kpico. aje anno apokino”. ");
INSERT INTO jni_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wa gun me “ma raa? ma kabirka in tam ba?” ");
INSERT INTO jni_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wa eh unu nume sa maazi urubo me ahira anu bize urusa. ");
INSERT INTO jni_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Unu wui wa sabar uni Yeso ma pitti tinyanga, ma poki me aje men. ");
INSERT INTO jni_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Anu bezi urusa wa kuri wa iki awuza aneni apoko me aje me. ma gun we “ma wunam tinyanga aje am, ana me in hira”. ");
INSERT INTO jni_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aye anyumo anu bezi urusa me wa gu “unu ugino me unu Asere mani ba barki mada tarsa uwui asabar ba” Aye wa gu “Adi wu aneni unu cara abanga ma wuzi usandi imum igeme?” Abini me wa harzina. ");
INSERT INTO jni_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wa kuri wa iki urubo me, “Nyanini u boo anice nume barki sa ma poko we aje?” urubo ma gu “unu kurzo utize ta Asere mani”. ");
INSERT INTO jni_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ana me daki a Yahudawa wa hem ini rubo imeme nan upokino aje ameme ba, senke sa wa titi anu uyo ude sa makem upokino aje me. ");
INSERT INTO jni_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wa iki anu yo umeme, “Vana ushi me mazigeme sa ya guna ya yoo me urubo me? a wuna aneni ma hira aname?” ");
INSERT INTO jni_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anu yo umeme wa kabirka we “Tirusa vana ugeme uru mani, ta yoo me urubo. ");
INSERT INTO jni_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ana me sa ma hira titandura ba, de sa ma poki me aje me titandura me ba. Ikoni tize inice nume” . ");
INSERT INTO jni_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anu yo umeme wa buu timum tigeme, barki sa wa kunna biyau ba Yahudawa. Barki sa a Yahudawa wamu hem vat de sa ma guna Yeso vana Asere mani, wadi suso me udenge Asere me. ");
INSERT INTO jni_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Barki anime ani anu yo umeme wa gu, “ma zome vana ba ikomme”. ");
INSERT INTO jni_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wa kuri wa titi urubo me uku kure wa gun me, “Nonzo Asere. Haru tirusa unu ugeme unu cara abanga man”. ");
INSERT INTO jni_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Unu ugino me makabirka, “In tam nan me unu cara abanga mani, imum inde ini inrusa mazi urubo mani, aname be in hira”. ");
INSERT INTO jni_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wa gun me “Nyanini ma wuna we? ma wuu aneni ma poki aje awe me?” ");
INSERT INTO jni_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mamu buka shi daki ya kunnaba! nyanini ya wuna inyara ikuri ikunna? Nani inyara icukuno anu tarsa umeme, ana me? ");
INSERT INTO jni_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wa cari me iruban wa gu “Huu unu tarsa ume mani, haru anu tarsa u Musa mani. ");
INSERT INTO jni_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tirusa Asere ma buu tize nan Musa titanduru unu ugeme ma suro abaniba”. ");
INSERT INTO jni_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Uni me ma kabirka ma gunwe “kash ita shi ahira me sa ma suron ba, ma ye ma poko aje am. ");
INSERT INTO jni_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tirusa Asere madi kunna anu csara abanga ba, ingi unu ma nya nice ma wuza imum sa ma ma nyara, maka kunna me. ");
INSERT INTO jni_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Datti sa abari unu daki amu kunna uye ma poko aje unu sa ayoo me urubo ba. ");
INSERT INTO jni_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","In dagi unu ugeme inzo ahira Asere mani ba, madada wuza imum ba”. ");
INSERT INTO jni_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wa kabirka wa gun me “Aye we anyumo ucara abangan, huu be u nyara u dungaran duru?” wa suso me. ");
INSERT INTO jni_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeso ma kunna agi we suso me udenhe Asere. Ma kem me ma gun me “Wa nya vana Asere uhem?” ");
INSERT INTO jni_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma kabirka me ma gu “Aeni me, Ugomo Asere, sa indi hem me?” ");
INSERT INTO jni_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeso ma gun me “wa ira me, memani mazin tize nan hu” ");
INSERT INTO jni_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Unu me ma gu. “Ugomo Asere ma hem”. Ma wuzi me ninonzo. ");
INSERT INTO jni_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeso ma gu “Ma aye unē ugeme barki ubarka an de sa wa ira wa iri, barki ande sa wa hira wa cukuno arubo”. ");
INSERT INTO jni_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Are anu bezi urusa sa wazi nan me wa kunna timum tigeme, waiki me “Haru arubo wani cangi?” ");
INSERT INTO jni_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeso ma gun we “Idada zina shi anu cara abangan ba ingi shi arubo wani ana me ya guna, Ti hira,' ani me ucara ushi me wa cukuno. ");
INSERT INTO jni_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kadura, kadura inboshi desa daki maribe ana tukum uhana itamba, manno matarsa ure una, unu uginome ukari mani. ");
INSERT INTO jni_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Desa da maribe ana tukum memani unu tarsan ini tam imi. ");
INSERT INTO jni_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Unu hira anatukum ma adi pokimeni itamme ikuna nimyiran numeme, matisa item imeme in ta zaa tiwe na kuri ma han we amatara. ");
INSERT INTO jni_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sa ma ēn we vat a matara, ma haki aje aweme, itame unu tarsa ume, barki wa rusa nimyiran numeme. ");
INSERT INTO jni_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wa ke wa tarsa ugenuba senke wa sumime, barki wa tame nimyiran ni ugenuba. ");
INSERT INTO jni_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeso ma wuzi we tize in nubata, da wa tinka imum me sa ma buu we ba. ");
INSERT INTO jni_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeso makuri magun we, “Kadundura, kadundura, in buu shi, mimani ana tukum item. ");
INSERT INTO jni_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vat andesa wa ē aje am akari wani nan anu bursa tirunga tanu, da itam me ya kunna we ba. ");
INSERT INTO jni_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mimani anatukum, me desa maribe ahira am, madi kem ubura, madi ribe ma suri makure makim ahiraukese. ");
INSERT INTO jni_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ukari mada ezeba senke barki ma wuzi ni kari nan uhuna anu, ma aye ini barki wa kem uvengize wa kuri wa kem uvenke gbardan. ");
INSERT INTO jni_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mi mani unu tarsa inanu uhem, unutarsa inanu uhuma maki nyanice nume barki itam ime. ");
INSERT INTO jni_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Desa mazi vana uka dura, da unu keseba, desa da memani unu itam, ingi ma ira Biyayau bi eze madi sumima ceki itam me, Biyayau me bidi zike itam me bi samirkawe. ");
INSERT INTO jni_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma sumi barki me una katuma ki kirfi kani mada igizome ini itam ba. ");
INSERT INTO jni_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nimani unu tarsa ina anu uhuma, in rusa am, am wa rusam. ");
INSERT INTO jni_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Acoo me ma rusam, nima in rusa acoo me, ma nya nice num barki itam. ");
INSERT INTO jni_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","In zin in ire itam sade ini goo nige niniba itam iginome, ya cuku, in ēn in ini, we cangi wadi kuna nimyira num barki wa cukuno nigoo ni inde unu utarsa u inde. ");
INSERT INTO jni_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Barki ane ani acoo ma hem in ni ma nya iriba barki in kem me. ");
INSERT INTO jni_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Unu zika ume ahira am ma raniba, ini nice num ma nya shi me barki ma bari in nya me, inzini ubari in ziki me. Na kaba ubuka ugino me ahira acoo um. ");
INSERT INTO jni_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","“Uhana ace wa ribe anyimo ama Yahudawa, barki ogoran agino me. ");
INSERT INTO jni_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gardan anyimo awe wa gu, nizin unu gbardan, unu iranza mani. Barki nyanini in zinu kunna ume”. ");
INSERT INTO jni_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aye aweme wa gu, agoran agino da ade sa mazin in na gbargena mani ba. Nani una gbargene mada ke ma poki aje urubo? ");
INSERT INTO jni_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uganiya u udi kpechu a Urushalima wa aya. ");
INSERT INTO jni_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Uganiya unikuzi nini, Yeso mahak anyimo anikobo ni Sulemanu. ");
INSERT INTO jni_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A Yahudawa zogizi wa gu, “Unu maya uni idi ceki duru, anyimo ma, aye, ingi hama iri Asere, bukan duru ti rusa”. ");
INSERT INTO jni_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeso magun we, “In boo shi a ani daki ya hem ba, imum be sa in wuza anyimo nizana acoo um ine ini ibezizi me aveni. ");
INSERT INTO jni_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Vat ani me daya hem ba barki shi da itam in ini ba. ");
INSERT INTO jni_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Itam ini ikuna nimyiran num, in rusa we wa tarsam. ");
INSERT INTO jni_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","In nyizawe i zatu marsa, wada dinkino me iwono ba, unu bara uwe ataritum mazoni. ");
INSERT INTO jni_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Acoo um, desa ma nyam we mateki kondavi uni gbardan, unu rusa ubura uwe atari acoo ma rani ba. ");
INSERT INTO jni_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni nan kacoo a inde ani. ");
INSERT INTO jni_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ba ma Yahudawa wa ziki apo barki wa vingizi meni. ");
INSERT INTO jni_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeso makabirkawe, “Mabezi shi timu mum tihuma gbardang ahira acoo um barki iya imum ini anyimo iginome izin vingizi umni?”. ");
INSERT INTO jni_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ba ma Yahudawa wakabirkame, “Da barki kare katuma kahuma kani ti nyara uvingizi uwe ni ba, barki u cara, barki hu unu ma ni, ukurzuzo nice nuwe Asere”. ");
INSERT INTO jni_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeso makabarka we, “Unyitike u ginome u zoni, anyimo ashi, maguna, “Shi makiri?”. ");
INSERT INTO jni_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Inki mattawe makiri we ande sa tize ta Asere ta ē ahira aweme (wadake wa da pura me tize ba). ");
INSERT INTO jni_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ibo desa acoo ma zauka makuri matumime unē, uzinnu cara, Barki maguna, mi vana Asere mani? ");
INSERT INTO jni_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Indaki ka coo um kaniba kati ihemin mi ba. ");
INSERT INTO jni_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ingi in wuza anime, daki shi yahem inmi ba, hemni inni mu me barki i rusi, ikuri irusi acoo ma raa anyimo am, mi in raa anyimo coo. ");
INSERT INTO jni_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wakuri wa sokace umeki ume, madusa me imumime, masuri atari tuwe. ");
INSERT INTO jni_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma dusame imum ime uhana uraba u Urdu, uhana ahira sa Yohana ma zin nu wuza u baptisma makuri ma cukkuno a hirame. ");
INSERT INTO jni_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Anu gbardang wa ē ahira me, wagu “Kadure daki Yahaya ma wuzi ire imum u ira ba, vat imum me sa Yahaya magu anice ninu ugeme kadure kani”. ");
INSERT INTO jni_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Anu gbardang wa hemen imme a hirame. ");
INSERT INTO jni_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Urunu nisame Li'azaru, mawzi uko ni. Me unanu Batayamani agiro an maryamu nan nu henu me Matta. ");
INSERT INTO jni_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu uginome sama humuka Ugomo Asere in mani mahuma mavisi me ti buna tume inti ce tumeme, deebe sa uhenu me Li'azarus mazi uhumaba. ");
INSERT INTO jni_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Anu henunugino me a eh watumin inkadura ahira a Yeso, agi, “Ugomo Asere, gunkuno, me de sa wahem ni mazome nihuma ba”. ");
INSERT INTO jni_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sa Yeso ma kunna, bama gu “ukoni uginome udaa ayo me in ni wonoba, anime uzika Asere uni, barki vana Asere makem ninonzo ahira ame”. ");
INSERT INTO jni_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeso ma hemum matta, nan nu henu u me a Li'azaru. ");
INSERT INTO jni_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sama kunna uguna Li'azaru mazi uhumaba, ba ma cukkuno uha atiye tire ahira sa ma raa ni. ");
INSERT INTO jni_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A' anime, magun nanu tarsa unme, “Acatiha u Yahudiya”. ");
INSERT INTO jni_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ba anu tarsa umeme wagunme, “Unu dungara aname ma Yahudawa ma nyarawe barki wa tizziwe inna poo, anime unyara ukuro abirkome?” ");
INSERT INTO jni_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeso makabirka magu, “Ingussa uganiya kana kirau in kani kare ka ni ani hiriba? inki unu ma wuza tanu inwui, Mada pilikome ba, barki mahira u suro umasa mune ugeme. ");
INSERT INTO jni_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Anime inki unu ma wuza tanu a nyimo aniye, madi pillizo barki masa ma zoo me nan meba. ");
INSERT INTO jni_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mabuka immum iginome, adomo atinum tigino me, bama gunwe, “Uroni uru Li'azaru mahama amoro ma, indiha inka hiriza me. ");
INSERT INTO jni_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ba nu tarsa umeme wagunme, “Ugomo Asere, inki moromanimazin innu wuza madi hiri”. ");
INSERT INTO jni_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeso ma buki tize tiwono i Li'azaru we wa gusi mazin inmoro muvenk u ni. ");
INSERT INTO jni_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeso beziwe uguna, “Li'azaru ma wono. ");
INSERT INTO jni_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Inzin hiruba irum barki shi, san zoo ni barki ihem. Acetiha ahira. ");
INSERT INTO jni_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma sa atissame bibara, magun nu kasu anu tarsa umeme, “Acatidusa barki tiwi nogome nan Yeso”. ");
INSERT INTO jni_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sa Yeso ma buki, makem Li'azaru mamu wuna tiye tinaazi anyimo acau. ");
INSERT INTO jni_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ubatanya uzi mamu nan nu Urshalima, “Tanu tini cin sa ti zoome piit nan we. ");
INSERT INTO jni_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma Yahudawa gbardang wa eh u iso u Maryamu nan matta tiyom ti wono unu uwe. ");
INSERT INTO jni_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sa Matta ma kunna Yeso ma eh ze, bama dusa barki maka kemme, a Maryamu ma ciki anyimo kura. ");
INSERT INTO jni_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matta magun Yeso, “Ugomo Asere, dagu urani unu ura, mada wonoba”. ");
INSERT INTO jni_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","A anu ma vat imube sawa ikko ahira Asere madi nyawe. ");
INSERT INTO jni_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeso ma gunme, “Unu uwe madi vengize”. ");
INSERT INTO jni_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ba matta ma gunme, “Min rusa maa vengize roo nu hira anu wijo roni mara vat”. ");
INSERT INTO jni_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeso magunme, “Mimani uhirsa a nu wijo, im mani u veno ize, desa maa nya kaduren in mi, in ma wono madi vengize. ");
INSERT INTO jni_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Anime vat desa ma vengize, mahem in mi, mada wono ba, wa hem in ani me?” ");
INSERT INTO jni_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ba magunme, “mh. Ugomo Asere, mahem ma inko iriba hamani vena Asere sa u eh ze unee. ");
INSERT INTO jni_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sa maa buki anime, makuri makatita uhe nu me Maryamuanikira. magu “Unu dungara mabiki, matissawe”. ");
INSERT INTO jni_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sa ma kunna anime, mahiri dibe maha ahirame. ");
INSERT INTO jni_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeso mazi mamu ribe akkupinme ba, maraa ahirame sa matta ma kem meni. ");
INSERT INTO jni_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nan ma Yahudawa maginome sa ma zi nan Maryamu, ande sawa eh me tiyom. Wairi ma suro akura dibe, watar sime, waa basa agi mahana a so a ni icau. ");
INSERT INTO jni_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sa Maryamu mabiki ahira a Yeso, ma rizi atibuna tumeme, magu, “Asere, agi wa zi nan haru, uhenu um mada wonoba”. ");
INSERT INTO jni_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sa Yeso ma irame mazinna so, nan ma Yahudawa ma gino sama tar sime, ma bassa anyimo abibe bilau makuri ma wuzi ma aye. ");
INSERT INTO jni_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Magu, “Abani ya natameni?” bawa gunme, “Asere, aye ira”. ");
INSERT INTO jni_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeso ma shi. ");
INSERT INTO jni_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma Yahuidawa wagu, “ira u hemme sama zini ahira a Li'azaru!” ");
INSERT INTO jni_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aye wagu, “Unu geme sa ma nya u rubo u hira hira, madake makarti unu uge me iwonoba? ");
INSERT INTO jni_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeso mazinnu basa abanga in nice nume, madusa icaume, icaume ubere unu a inpin inipo. ");
INSERT INTO jni_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeso magu, “Akari nipome” matta u he nu u Li'azaru sa wi, magun Yeso, “Asere, nipomme naa mu ma wuna tiye tinaazi”. ");
INSERT INTO jni_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeso magunme, “Magunan u inki wa hem udi iri ubari Asere”. ");
INSERT INTO jni_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wa kari nipome. Yeso ma yeze aje magu, “Acoo, ankoi barki u kunnam”. ");
INSERT INTO jni_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","In rusa ukunnam vat uganiya, barki nigura nige sana katem inzin tizee tiginome, barki wa hem hamani wa tumam. ");
INSERT INTO jni_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sama guna anime, mayeze nimyiran magu, “Li'azaru, suro! ");
INSERT INTO jni_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Uni wonome ma suri, tibuna tumeme nan tari me atirzi innu malti, muhenu me a impi unu poru. Yeso maa gunwe, “Soponi me, madusa”. ");
INSERT INTO jni_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Anyimo Yahudawa sa wa eh ahira a Maryamu wa iri mmme sa Yeso ma wuza, wahem. ");
INSERT INTO jni_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aye wukuri ahiraanu bezi urusa wa buku we imumbe sa Yeso ma wuza. ");
INSERT INTO jni_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ana katuma kadang ka sere nan anu bezi urusa wa ari ti cukum ahira inde, wagu, “nyaani tidi wuzi?” unu geme mazin nu bezi imum gbardang. ");
INSERT INTO jni_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Inki ta ceki me anime, vat wadi hem imme, ma Romawa wadi eh waburi a hira aru nan ti mum tiru. ");
INSERT INTO jni_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Vat anime, uye anyomo, kayafa sa me mani unu dangdang ukatuma ka sere aniwe niginome, magun wa “Ita shi imumba”. ");
INSERT INTO jni_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Daki ya merum unu inde mawi barki anu, innu vat ta nu wawi. ");
INSERT INTO jni_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mabuki anime barki daki ni ce nu meba, barki me mani una katuma ka sere kadang, mawuzi tizee tigino ubezi uguna Yeso madiwi wi barki anabu. ");
INSERT INTO jni_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Daa barki sa anu cas ba, barki a orso ahana Asere sa wa shagali ahira a inde. ");
INSERT INTO jni_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Datti usuro uwui ugino me watubi unyara una uhuna u Yeso. ");
INSERT INTO jni_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Datti abinime Yeso ma cekki tanu amasa anyimo a Yaudawa, makuri unire nikira anija ai pine sa atissa Ifraimu. Abirko me ma cukunonan nanu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Uganiya vidi wa Yahudawa wa eh maa mu, vat uwe wadusa u urshalima ani kira nini pin me da uwui u idime wamu aye ba barki wa kpici ace a we. ");
INSERT INTO jni_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Waribe unyara Yeso in tize inna cece awe sa wa tutur anyimo u denge Asere, agi, “Nyani ibassa? mada aye me u idime ba?”. ");
INSERT INTO jni_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Unakatuma kadang ka sere nan anu bezi rusa wamu nya tize agi vat ahira sa a ira Yeso ni a eh abukkuwe barki waka mikime. ");
INSERT INTO jni_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Adi tiye utasi u idi u eh yeso vana Asere ma eh ubatanya ahira sa li'azaru marani, de sa yeso ma hirza me iwono. ");
INSERT INTO jni_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Asiri imumare ini yee abini me, marta mani ma wuzi niyau me, li'azaru mara anyimo anu reeme na yeso me. ");
INSERT INTO jni_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maryamu ma ziki mani ma humaka atibuna ti yeso, ma ditri in tice tumeme, akura a dusa agumurka unu nya umani me. ");
INSERT INTO jni_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yahuda iskariyoti, unu anyimo ahana aka tuma kameme, de sa madi nya yeso me, ma gu. ");
INSERT INTO jni_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Nyani ya karti azizi mani mage me, ama danarii akura ataru, ahari anu dira ikirfi me? ");
INSERT INTO jni_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma buki ahini me, barki ma da nyiza me anu dira ba, barki me ukari mani ulalitan ikirfi me ura atari time tini madi sosi tari anyimo me ma isa ikirfi me. ");
INSERT INTO jni_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeso magu, aceki me ma inki mani me, barki ronu uvati um uni. ");
INSERT INTO jni_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iciki na nanu udiri ko di uya uwui, ida ciki shi na mi kodi uya uwui ba. ");
INSERT INTO jni_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sa ni ori na yahudawa gbardan na kuna agi ma rani, wano wa eh, u aye uweme azo barki yeso mani cas ba barki wa iri li'azaru desa ahirza me iwono. ");
INSERT INTO jni_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","An dadan dang wa cukuno wa gu, ahu li'azaru me cangi. ");
INSERT INTO jni_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Barki me mani ayahudawa gbardan, wazinu harzina utarsa u yeso. ");
INSERT INTO jni_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ahira asani ni ori na u sa wa eh u idi, sa wa kuna yeso madi eh a urushalima. ");
INSERT INTO jni_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wa ciri mava mu dasino wa susi uka kaba ume, wa heze amyinan wa gusi hossana a, anonzo niza nun eye anyimo aniza nu gomo Asere ugomo isra'ilawa. ");
INSERT INTO jni_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sa yeso ma kyem ku zanki ma nyineni, kasi sa anyetike agu. ");
INSERT INTO jni_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kati ukuna biyau, uca anu sihiyona, ugomo uwe mano ma eze asesere aku zenki. ");
INSERT INTO jni_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Unu tuba ahana katuma kememe wa rusi imume ba, sa amare ninonzo ni yesu, wadu ringi imume sa anyetike abanga mameme i yenne awuza me ini. ");
INSERT INTO jni_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ni ori me sa ma zina we uganiya sa ma titi li'zaru masuri anyimo icau, ma hirza me iwono, we wani wa bezizi agi ana. ");
INSERT INTO jni_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ine ini ya wuna ni ori me na suri ukaba ume, barki sa wa kuna ma wuza timumum. ");
INSERT INTO jni_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Afarisiyawa a gusin na cece awe me, ya ira! ti darusan duru iri mambe irani une vat ura amaru ame ani. ");
INSERT INTO jni_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ade sa wa eh u idi uni nonzo a helenawa wa rani. ");
INSERT INTO jni_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Sa wa eh ahira a filibus, unu anu betsaida amyanga mu galili, wa iki me wa gu, “Una kura ti zin nuzo ti iri yeso.” ");
INSERT INTO jni_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sa filibus ma ha maka buka Andarawus, andarawus makuri maka aye nan filibus wa duku buki yeso. ");
INSERT INTO jni_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeso makabirka we magu, uganiya wa aye sa adi nonozo vana unubu. ");
INSERT INTO jni_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ane ani in boo shi, ingi da abira be hoo bi alkama ba wono ba, bidi cukuno isi si bini. Ingi ba wono bidi nyozo ahana. ");
INSERT INTO jni_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Unu so urai umeme madi diri uni, desa ma game urai umeme unee ugeme, mabarka uni uhana umara unee. ");
INSERT INTO jni_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Desa madi wuzom katuma, ma tarsum, Ahira sa irani abine ani urere um madi cukuno ni, desa ma nonzom aco madi nonziko me. ");
INSERT INTO jni_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ana me in kuna gitak iriba im, nyanini indi gu? in gu aco zikam uganiya ugeme? ma aye ini barki uganiya ugeme. ");
INSERT INTO jni_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aco nonziko niza nu we me, a kunna nire ni nyira asesesre na guna, ma nonzome idi kuri in nonziko me. ");
INSERT INTO jni_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni ori me sa ma turi ahira aweme wa kuna ni myira, wagu, “Iri imum ini ya gumo” aye wa kuru wa gu, “Bibe biri ba sere bini ba buka me tize”. ");
INSERT INTO jni_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeso ma kabirka magu, azo barki mimani awuzi nimyiran nigin aba, barki she wani. ");
INSERT INTO jni_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ana ani adi wuzi une dang une ugeme . ");
INSERT INTO jni_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Me uganiya sa ahenzem asesere adizi indi hunguko anu vat ahira am. ");
INSERT INTO jni_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ubuka anime ma bezi usanda iwono sa madi wuzi. ");
INSERT INTO jni_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ni ori me na kabirka me nigu, u shiria uru wa bezin duru unu guna a vana Asere madi cukuno uhana umara unee. Anani udi gu udoli uni ayeze vana unu? aveni vana unu me? ");
INSERT INTO jni_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeso magun we, masa mazin nan shi uhana uganiya cin waje. Wuza ni tanu uganiya sa masa mazi na shi kati mare ma biki shi, una tanu anyimo amare ma tame ahira sa ma hakani ba. ");
INSERT INTO jni_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hem ni in masa me, uganiya sa in zi nan mani, barki icukuno in me a ma sa. A yahudawa wa hem in me ba, yeso ma buki ani me uganiya sa ma dusa uka gune uwe. ");
INSERT INTO jni_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeso ma wuzi we tere timumum gbardan aje aweme, in anime wa hem in me ba. ");
INSERT INTO jni_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Barki amyinca ubuka ishaya magu, ugomo Asere, aveni ma hem in tize tuwe me? ahira aveni abuki ubari ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ine ini ya wuna da wa hem ba barki ishaya ma kuru magu. ");
INSERT INTO jni_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ma wuna we irubu, makuru ma wuna we ugas umu riba, kati wa hira inaje aweme, wa kuri wa rusi amu riba. ");
INSERT INTO jni_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya ma buki ani barki ma iri ninonzo na Asere, ma kuri ma bo ubari Asere. ");
INSERT INTO jni_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Barki anime anu gbardan anyimo ana katuma me wa hem in me, anime barki biyau ba farisiyawa, sa wa be za ace ba, barki kati agz we. ");
INSERT INTO jni_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wa tikin nu su ninzo na nabu ini nonzo na Asere. ");
INSERT INTO jni_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeso ma yeze nimyira magu, desa ma hem in mi azo imani ma hem in mi ba, de sa ma tumam ini. ");
INSERT INTO jni_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Desa ma hiram, ma hira desa mz tumam ini. ");
INSERT INTO jni_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma aye unee unu guna mi masa mani, de sa ma hem in mi kati ma wuzi tixukum ti maree. ");
INSERT INTO jni_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Desa ma kuna tize tum, da ma inko me imum in wuza ba, azo ma aye in weki une imum in wuza ba, ma aye barki in buri unee. ");
INSERT INTO jni_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","De sa ma gami, da ma kaba tize tum ba, mazin ununn waki ume imum iwuza, tize sa ma buka tene tini tidi weki me imumiwuza rono umara unee. ");
INSERT INTO jni_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Azo barki nice num nini ma buka tize ba, ac uge sa ma tuma ini ce nume ma nyam nikara ni mumsa indi buki, nan imum sa indi wuzi. ");
INSERT INTO jni_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","In kuri in rusi imum imeme urai uhana umara unee. Barki anime, imum be sa in boo izi nu boo me kasi sa aco ma bukam. ");
INSERT INTO jni_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uganiya idi wa mu aye ba, yeso ma rusi uganiya uhira ume unee ukuro ahira aco, ma zinu su anu ame sa wara unee, mazinu su uwe uhana mara unee. ");
INSERT INTO jni_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Azinu re imimare ini yee bi be bi burbamu ribe iriba iyahuza iskariyoti vanu saminu madi zizi Yeso. ");
INSERT INTO jni_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeso marusi kondi nyani ya cu udang ira atari tume, ma rusanya suro ahira Asere ani ya suroni, idi kuri ikuri ahira Asere. ");
INSERT INTO jni_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Manno ma ceki are imimare me, ma inki u gyeptu u impino umeme, ma ziki ku puri ma tiri utino. ");
INSERT INTO jni_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma gamirka myei ukwano dan, ma kpici tibuna ta hana akatuma ka meme, madu vizi unu puri me sa ma tira utino umeme. ");
INSERT INTO jni_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sa ma aye kpicu utibuna ti Bitrus, bitrus magun me, “Ugomo Asere, hamani ini ce nuwe udi kpicum tibuna?” ");
INSERT INTO jni_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeso ma kabirka magu, “Ana me utawe imum me sa izinu wuza me ba, inka ma mara udi rusi.” ");
INSERT INTO jni_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitrus ma gu me, “Mi ma hem ba, uda kpico mi tibuna ba sa unee wa mara!” Yeso ma kabirka me magu, “ingi da ma kpico we niba, uzo we unu um ba. ");
INSERT INTO jni_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Bitrus magu me, ugomo Asere azo tibuna nan nice num” ");
INSERT INTO jni_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeso magu me, De sa ma zoro mada nyara ukpico v iri mum ba, tibuna tini cas adi kpici, barki amu kpico me. Izi lau azo vat ushi ba.” ");
INSERT INTO jni_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Barki ma rusa uye madi nyare me, ine ini ya wuna maguna, “Izi lau vat ushi ba.” ");
INSERT INTO jni_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sa ma mara ukpico uwe tibuna me, ma, i ugyeptu u impino umeme ma impino ni ma duku gun we, irsa imum be sa ma wuza shi? I gusam unu nyetike, nan ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ane ani daki ya hunne me ba, ane ani inzi. ");
INSERT INTO jni_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi unu nyetike, nan ugomo Asere, ma kpico tibuna tishi, shi idi kpici tibuna ta cee ashi. ");
INSERT INTO jni_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma wuza ani me bati shi iwuzi kasi mime. ");
INSERT INTO jni_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kadure kani izinu boo shi, urere mada teki me una kura ame ba, vana uka dura mada teki me desa ma tuma me ba. ");
INSERT INTO jni_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Inki irusa anime, i kuri iwuzi imumu ihuma shi ana muriba murum muni. ");
INSERT INTO jni_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Azo vat ushini in boo shi ba, in rusa ande sa ma zauka. In wuzi anime barki amyinca tize ta Asere tini, unu guna desa mazina re imimare im, ma ga mi. ");
INSERT INTO jni_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","In di booki shi ana me uganiya wamu aye ba, in! i uganiya wa wuna inya mu riba mimani me. ");
INSERT INTO jni_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kadure kani, in booshi, desa ma hem indesa ma tuburko, ma hem in mi mamani. Desa ma hem in mi, ma hem indesa ma tumam. ");
INSERT INTO jni_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ugainya sa yeso ma suka anime, iriba ya wume gitak ma boki magu, kadure kani in booshi uye anyimo ashime madi zizum. ");
INSERT INTO jni_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ahana katuma kameme wa tunguno u hira acece, unu gusa aveni ma boo me. ");
INSERT INTO jni_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Uye anyimo ahana akatuma kameme, desa yeso mazinu su ume, ma ciki upuru umeme. ");
INSERT INTO jni_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bitrus ma dari me magu, “Bukan duru yeso ma boo aveni”. ");
INSERT INTO jni_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Desa mara upuru uyeso magu me, “Ugomo Asere aveni?” ");
INSERT INTO jni_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeso ma kabirka magu, “me mani desa indi inta imumare in nya me” sa ma inta imimare, ma wu yahuza iskariyoti vana usaminu ayo. ");
INSERT INTO jni_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sa ma kaba imumare me, imum me irizi me iriba, yeso magun me, “Wuza imum be sa udi wuzi ana me”. ");
INSERT INTO jni_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Anyimo ande sa wazina re imumare me, wata we imum me sa ya wuna yeso ma boka anime ba. ");
INSERT INTO jni_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Wa gusi nani yeso maguna me ma kuri ma siri iri imumare in, nan ma nya anu dira akara ire imum, barki sa me yahuza mani ma canti ulalinta ikirfi iweme. ");
INSERT INTO jni_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Me yahuza sa ma kaba imimare me, ma ba soru, ini yeeme. ");
INSERT INTO jni_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Uganiya sa ma suro yeso ma kuri unu magun, ana ani adi nonziko vana unu bo aduku nonziko Asere ahira ameme. ");
INSERT INTO jni_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Asere adi nonziko me, me ma nonziko Asere. ");
INSERT INTO jni_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ahana acincin am, ade uganiya cingilin inzi nashi, idi nyarum ma mu boka ayahudawa magu, ahira sa in hanzani idaki iha ba ane ani inboo shi ana me. ");
INSERT INTO jni_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","In nyiza shi tize tiso, ine ini iwuzi usu ace ashi, kasi sa ma wuna usu ushi ane shi idi wuzi. ");
INSERT INTO jni_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Uwuza anime ani udi wu marusi shi ahana akatuma kame kani, ingi izinu su ace ashi me. ");
INSERT INTO jni_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Bitrus magun me, “UgomoAsere, uhaza abani?” yeso ma kabirka magun, “Ahira sa in hazani udake utarsum ana me ba, udi tarsaum ana dumo”. ");
INSERT INTO jni_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus magun me, “Ugomo Asere nyani ya wuna, adake in tarsuwe ana me ba? yeso magun me, indi. nya nice num barki hu”. ");
INSERT INTO jni_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeso kabirka magun, “Udi nya nice nu we barki mi? kadure kani in boo we, urunu ubi goro unu sana ahira, udi gu uda rusa mi ba kani ka taru” ");
INSERT INTO jni_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kati icari mu riba mu shi ba inko ni urusa ushi ahira Asere, in kuri in ya urusa ushi ahira am. ");
INSERT INTO jni_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Akura aco am ti hira ti cukuno a rani gbardan, barki anime un boo shi indi dusa inka barka shi ahira. ");
INSERT INTO jni_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ingi ma dusa ma ka barka shi ahira, indi kuri ni ey in ziki shi uhana ahira am, ahira sa in rani, icukuno nan mi. ");
INSERT INTO jni_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ahira sa in hazani, irusa una uname. ");
INSERT INTO jni_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma magu me, ugomo Asere ti tame ahira sa u haza ni ba, aneni tidi rusi una me? ");
INSERT INTO jni_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeso magu me, mi mani una, mimani kadure, mi mana urai, unu hana ahira aco mazoni, se ahira am. ");
INSERT INTO jni_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Da irusam, inda rusa aco am, uhan aje idi rusi me, idi iri me ina aje ashi. ");
INSERT INTO jni_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibus magun me, ugomo Asere bezin duru aco me, ma barin guru. ");
INSERT INTO jni_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeso magun me, ma dan donkino nan shi anama filibus uda rusa mi ba? desa ma iram ma ira aco, aneni i gusa akuri abezi shi aco? ");
INSERT INTO jni_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Da hem imi ira anyino aco ba, aco ma kuri ma raa a nyimo am? Tize sa in boo shi azo ahira am ani ti suso ni ba, aco me sa ma ciki anyimo am me mani ma wuza timumum tume me. ");
INSERT INTO jni_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Rusa ni ka dure kani inra anyimo aco, aco ma kuri mara anyimo am; Inke azo ane ba timumum ini ce nuwe ti hem in me. ");
INSERT INTO jni_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kadure kadure in gusan shi, desa ma hem in mi timumum sa in wuza me ma madi wuzi timumum sa ti tike tige sa in wuza madi wuzi, barki in haka ahira aco. ");
INSERT INTO jni_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Barki konyanini idi inki anyimo ani za num, indi wuzi anime barki a ziko aco me ahira avana me. ");
INSERT INTO jni_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ingi ya ikom ko nyani anyimo aniza num, idi wuzi anime. ");
INSERT INTO jni_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","In ya hem in me idi tarsi tize tum. ");
INSERT INTO jni_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Me indi iki aco, madi nya shi unu benki ma cukuno nan shi uhana umara uneeh. ");
INSERT INTO jni_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bi be bu ugomo Asere ba boo kadure, be sa uneeh wa kabi bini ba, uneeh uda hira me ba uda rusa me ba, shi irusa me ciki nan shi madi cukuno anyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Inda ce keshi a unu ba, mi indi ey ahira ashi me. ");
INSERT INTO jni_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","U ganiya uda cingilin, sa uneeh uda kuri u irum ba, ana me shi i hiram barki mi inda vengize shi idi kem urai. ");
INSERT INTO jni_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Anyimo uwai ugino idi rusi ira anyimo aco am, shi anyimo am mi anyimo ashi. ");
INSERT INTO jni_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","De sa ma kuna ugara um, ma tara tize tum, me mani mazin unu su um; desa mazin unu su um, madi cukuno unu su aco am, mi idi wu usu ume, in kuri bezi nice num ahira ameme. ");
INSERT INTO jni_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ya huda (ba iskariyoti ba) magun me, ugomo Asere nyanini ya wuna udi bezi nice nuwe me ahira aru, azo ahira unee ba? ");
INSERT INTO jni_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeso ma kabirka me, magun me, ingi nu mazin unu su um, ma tarsi tize tum, aco um madi wu usu ume, ca ti ey ahira ame, ti cukuno nigo me nan me. ");
INSERT INTO jni_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","De sa mazo unu su um ba, mada tarsa tize tum ba, tize tum sa in kunna azo tum tini ba, ta co tini desa ma tumam. ");
INSERT INTO jni_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tize tige sa ma boo shi, ma dazan in ti cukum nan shi. ");
INSERT INTO jni_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Unu benki, bibe bilau desa aco madi tuburko anyimo aniza nume me, madi bazizi shi timumum vat ma ringi shi timumum besa ma boo shi. ");
INSERT INTO jni_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","In cesi shi iriba rum, riba irum im in nyiza shi shi; azo u iri uniza unee sa unyiza ba, ane ani mi in nyiza shi ba, kati iriba ishi in curno me ba, ka ikuna iriba ba. ");
INSERT INTO jni_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya kunna magu na shi idi wuzi tanu, idi ey ahira ashi me. De ya wu usu um, ahira ida wuza iriba irum, barki in haza ahira aco, barki aco ma tekum unu gbardan. ");
INSERT INTO jni_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ana ma boo ka shi ida sarku aye, uganiya sa ya aye inya mu riba. ");
INSERT INTO jni_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inda kuri inboo tize gbardan na shi ana ba, barki ugomo unee ma eze, ma zo iri mum anyimo am ba. ");
INSERT INTO jni_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Barki unee urusi izin nu su aco, kasi aco ma nyam katuma, ane ani in wuza, ti hiri ti dusa a birko. ");
INSERT INTO jni_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mi mani nijee nika dure, Aco um ugomo avara mani. ");
INSERT INTO jni_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Birii bige sa bida bi yozo ba, madi gwanika bini bi gesa bi yozo ahana madi bari bini bati bi yozo ahana gbardan. ");
INSERT INTO jni_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Shi anime izi lau barki tize tum sa ma buka shi. ");
INSERT INTO jni_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cukunoni anyimo am, mi anyimo ashi me, kasi birii bi gebe sa bida yozo me ahana inice nume ba se inka ba cukuno ba, se ya cukuna atini me, ane ani shime ida rusa shi ba, seya cukuno ahira am. ");
INSERT INTO jni_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi mani nijii nimkadure, shi wani iri me, de sa ma ciki anyimo am, anyimo am, anyimo ame, anime iyozo ahana gbardan; Ingi azo nami ba, ida wuza shi iri mum ba. ");
INSERT INTO jni_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ingi da unu ma cukuno anyimo am ba, adi suso me anyimo ti cukum ti birii, ma ku waa, adi urso we we areki anyimo uraa abuzi we. ");
INSERT INTO jni_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ingi iciki anyimo am, tize ashime igizo timumum bisa inyara adi wuzi shini. ");
INSERT INTO jni_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ahira sa anozo aco am ni, nyizani ahana gbardan, ane ani idi cukunu ahana akatuma kam. ");
INSERT INTO jni_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ane ani aco um, ma wusu um, ani ani mi ma wuna usu ushi, cukuno ni anyimo anu su um. ");
INSERT INTO jni_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ingi ya kuna tize tum, idi cukuno anyimo anu su um; Kasi sa mi ma kuna tize ta co um, in ciki anyimo anu su umeme. ");
INSERT INTO jni_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma buka shi tize tigeme barki iriba irum im, icukunu anyimo a shi me, barki iriba irum ishime i myinca. ");
INSERT INTO jni_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ubuka um anime, iwu usu ace ashime kasi mime sa wuna usu ushi. ");
INSERT INTO jni_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Uye mazo me unu su, sa utaki ugeme ba, kasi unu ma nya nice nume barki aroni ame ba. ");
INSERT INTO jni_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Shi wani aroni am ingi ya wuza imumbe sa ma buka shi. ");
INSERT INTO jni_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ida ka guna shi arere ba, urere mada rusa me umum besa una kura ame ma wu za ba, barki anime ma guna shi aroni, barki imum sa ma kuna ahira aco um, buka shi. ");
INSERT INTO jni_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Azo shi wani ya zaukam ba, mi mani ma zauka shi barki idusa ika nyoza ahana, timum tishi me ti cukuno anime; Ibinani imum besa idi iki ahira aco anyimo aniza num, ma nya shi. ");
INSERT INTO jni_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Timum ti geme inboshi, barki iwusu acece ahi. ");
INSERT INTO jni_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ingi unee wa ga shi, urusa ni wa mu gami uduku gami shi. ");
INSERT INTO jni_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Da anu nee wani shi, nee uda wuna usu um, barki sa shi anu nee wani ba, barki sa shi zauka shi anyimo unee, ine ini ya wuna unee wa ga shi. ");
INSERT INTO jni_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ringi tize me sa ma buka shi, urere mada teki me una kura ame ba, ingi wa yomom wada yomi kunna tishi me. ");
INSERT INTO jni_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wadi wuzi shi timum tigino me vat, barki niza num, barki wada rusa desa ma tumam ba. ");
INSERT INTO jni_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Barki ma eh in bukuwe tizeba, wada madini ba ana me wazo we ini mum ibukaba wa mu wuza imum izenzen. ");
INSERT INTO jni_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","De sa ma gami ma game aco am. ");
INSERT INTO jni_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Barki da ma wuzi timum sa da uye ma wuzi ba, ahira aweme, wada zo we ini mumu izenzen ba; Ana me wa iram, wakuru na ga mi ubata aco ume. ");
INSERT INTO jni_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ya cukuno anime barki a myinca tize ta Asere sa a nyetika, wagu mi sarki iri imum. ");
INSERT INTO jni_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Uganiya sa unu benki ma aye desa idi tumi shini urusu ahira aco bibe bika dure desa ma suso ahira aco, madi bezi shi mi. ");
INSERT INTO jni_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Shi idi rusum, barki sa izi nan mi dati utuba. ");
INSERT INTO jni_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ma buka shi ti mumum tigeme kati awu shi iri zizi. ");
INSERT INTO jni_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Adi suso shi ayimo udenge unonzo Asere, ane ani uganiya u eze sa kasi mazinu wuza Asere katuma kani. ");
INSERT INTO jni_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wadi wuza timummum tigino me, barki wa rusa me aco me ba wda rusa mi ba. Tize tigino me sa ma buka shi, barki inka uganiya uwe me wa eye, irusin we ikuri irusi ma buka ski. ");
INSERT INTO jni_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Timumum tigino me daki ma buki shi dati utuba ba, barki mazi nigo me na shi. ");
INSERT INTO jni_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ana me in haka uhana ahira sa ma tuma mini, anyimo ashi me daki uye ma ikom uhaza abani? ");
INSERT INTO jni_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A ani barki sa ma buka shi tize, muriba mushi ma corzino me. ");
INSERT INTO jni_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A ani inboo shi kadure; ya wuna uri in dusa inka da ma dusa ba, unu benki mada aye ahira ashi ba inka ma dusa idi ka tuburko shi me. ");
INSERT INTO jni_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Me sa ma eze, uganiya sa ma aye madi karti uwuza imum izenzen anyimo unee in kadure. ");
INSERT INTO jni_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Asese imum izenzen, barki sa da wa nya muriba ahir am ba. ");
INSERT INTO jni_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ahira a kadure barki sa ma hana ahira aco, ida ka iram ba. ");
INSERT INTO jni_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ahira uzatu urusa, barka sa anya ugomo unee ugeme uzatu rusa. ");
INSERT INTO jni_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Izinu kasu utize sa idi boo shi idaki irusi tini ana ba. ");
INSERT INTO jni_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Uganiya sa me, bibe bikadure ba aye, bidi tarsa inshi vat anyimo akadure; Bi da rizo inice nume ba ibinani imum be sa ma kunna ine ini madi buki, madi buki shi imumbe sa i eze. ");
INSERT INTO jni_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Madi nonzikom; anyimo imum im madi kabi, ma buki shi. ");
INSERT INTO jni_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ibinani imum vat sa aco mazini, im ini barki ane ani ma buka, anyimo im ini makabsa madi boosgi. ");
INSERT INTO jni_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Uganiya u eze cingilin, ida ka ira ni miba, inka adandankino cingilin, ikuri irim. ");
INSERT INTO jni_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aye anyimo ahana akatuma kameme wa gu acece awe me, nyanini ma gusan duru anime adandandankino cigilin, ida kur irimmba; inka kuri adandankino idi kuri irim barki in haka uhana ahira aco? ");
INSERT INTO jni_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wa kuri wagu, nyanini ma boo anime ika adndankino cingikin? Tintaduru imum mesa mazinu boo me ba. ");
INSERT INTO jni_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeso ma rusi wa nyara wa iki me, magun we, izini igino acece shi imum besa ma boo, iki adandankino cingilin ida ka irani ba. ");
INSERT INTO jni_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kadure, kadure, in gusa shi idi shi i mu ruba mushi mu di bezi, unee udi wuzi aburu arum; mu riba mu shi mudi bezi, ubezi uriba mushi udi kuri muriba murum. ");
INSERT INTO jni_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uganiya sa uneh madi zini jasi uyo madi zini riba abiti barki uganiya um wa ate; ugana sa vana ma suru mada ringi me ijasi sa wuza ba, barki iriba irum ivana sa ayo anyimo unee. ");
INSERT INTO jni_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Shi ana me izin muruba mu bit ana me idi kuri in iri shi, muriba mushi me tumi, muriba murum mushi me ibina irani ba. ");
INSERT INTO jni_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Anyimo uwui ugino me ida nimi iri imum ba, kadure kadure ingusa shi inka ya iko ko nyanini ahira aco madi nya shi anyimo aniza num. ");
INSERT INTO jni_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Daki ya mu iko iri imum anyimo anza num bai nyara ni idi kabi, barki iriba irum ishime imyinca. ");
INSERT INTO jni_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Timumum ti ginome ma booshi unu basa uganiya u eze sa adaka buka shi tize unu bata ba, indi nya shi abanga aco kandavi ma kunna . ");
INSERT INTO jni_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Anyimo uwui uginome idi nyari imum anyimo aniza num, da ma gu nan shi idi wu biringara ahira aco bark shi ba. ");
INSERT INTO jni_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aco me inice nume ma zinu su ushi, barki sa ya wuna usu um ya hem ma suro ahira aco. ");
INSERT INTO jni_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ma suro anyimo aco, ma biki anyimo ahira izinu ceki unee in hana ahira aco. ");
INSERT INTO jni_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ahana akatuma kameme wagu ane ani, ana ani ya poko tize azo ubasa uni uzin ba. Ana me ta rusa urusa timumum vat, uda nyara we uye ma iki we ba; ");
INSERT INTO jni_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ana me ta urusa wa suro ahira Asere. ");
INSERT INTO jni_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeso ma kabirka we, magu ana me ya kaba Asere? ");
INSERT INTO jni_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Irani uganiya u eze, wa mu aye idi sa mara konda vi madi tarsi ume idi cekum isisis im; azo mi isis im ini ba, aco mazi nan mi. ");
INSERT INTO jni_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma buka shi timumum tigeme barki anyimo am ya kem utoto umu riba, anyimo unee ya zito ana me wuza mu riba mu rum, unee vat um uni. ");
INSERT INTO jni_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tize tigino me sa Yeso ma buki ma yeze aje asesere magu, ugomo Asere, uganiya wa aye; Nonziko vana uwe me, barki vana me ma nonzikowe. ");
INSERT INTO jni_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Barki wa nyame timumum unu hem iriba ibinani ande sa wa nyame, ma nyawe urai uhana umara unee. ");
INSERT INTO jni_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Urai uhana umara unee uni, wa rusiwe ugomo Asere isiswe, una kadure nan desa ma tumam Yeso. ");
INSERT INTO jni_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma nonzowe unee, uganiya sa ma myinca katuma sa nyam uwuzame. ");
INSERT INTO jni_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ana me aco, nonziko inice nuwe me nan nurusa sa izin nan huu unee uda sarki uwuna. ");
INSERT INTO jni_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma bezi niza nuwe me ahira anu age sa wa nyam anyimo unee; anu awe wani wanyam we; wa tarsi tize tuwe me. ");
INSERT INTO jni_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ana wa rusa ibinani imum vat sa wa nya ya suru ahira awe ani. ");
INSERT INTO jni_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ibinani itize sa wa nyam, ma nya we, wa kaba wa rusa unu guna ma suro anyimo awe ani, wa kuru wa hem hamani wa tumam. ");
INSERT INTO jni_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ingi ma wuna we birigara, azo ma wuna unee ini biringara ba, barki ande sa wa nyami awe wano. ");
INSERT INTO jni_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ibinani imum besa izi im iwe ini, imum iwe im ini anozikom anyimo ini. ");
INSERT INTO jni_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Uhana aje indaka zom anyimo unee ba, mi in haza ahira aweme. Ugomo Asere ulau, rusan we anyimo aniza nuwe me sa nyam, barki wa cukuno a inde kasi haru. ");
INSERT INTO jni_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Uganiya sa inze nan we, ma nonzowe anyimo aniza nuwe me sa wa nyam; Ma tarsi unwe, ko unu inde anyimo awe dama hune me ba, se de sa ma curnome, barki tize ta Asere ta myinca. ");
INSERT INTO jni_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ana me in ahira ashi me; Tize tigeme izinu boo me anyimo unee, bzrki wa kem iriba irum im imyinca muruba muwe me. ");
INSERT INTO jni_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma nya we tize tuwe me; Unee wa g we barki we azo anu nee waniba, aneni mi azo unu nee mani ba. ");
INSERT INTO jni_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inda wuzam biringara uziki we anyimo unee ba, biringara bum uhari we nan imum ibur. ");
INSERT INTO jni_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Azo we anu unee wani ba, ane ani me azo unu nee mani ba. ");
INSERT INTO jni_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kpicuwe anyimo akadure; Tize tuwe me tine tini kadure. ");
INSERT INTO jni_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kasi sa wa tumum anyimo unee, ane ani ma tumu we anyimo unee. ");
INSERT INTO jni_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Barki we wani izinu kpico unice num, barki we wa kpici ace awe me in kadure. ");
INSERT INTO jni_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Azo barki agino ana cas inzi biringara ba, barki anagino sa wa nya kadure ahira am ahira boo utize tuwe me. ");
INSERT INTO jni_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Barki we vat wa cukuno a inde; Kasi huu aco, ura anyimo am, me anyimo awe, barki we wa cukuno anyimo aru; Barki unee u hem hamani wa tumam. ");
INSERT INTO jni_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni nonzo sa wa nyam, ma nya we; Barki wa cukuno a inde kasi haruna inde wani. ");
INSERT INTO jni_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi anyimo awe, huu anyimo am, bark wa cukuno a inde kan, barki unee urusi wa tumam, wa wuna usu uwe wa kuru wa hem in mi. ");
INSERT INTO jni_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Aco, ande sa wa nyam, in nyara wa cukuno ahira sa irani, nigome nan mi; Barki wa iri ninonzo num, sa wa nyam wa wu usu um ada amu tuba unee ba. ");
INSERT INTO jni_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aco unu bursa, unee urusa we ba; Mi in rusa we, ana geme wa rusa wa tumam. ");
INSERT INTO jni_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma bezi we niza nuwe me, idi bizizi nini, barki usu uge besa wa bezum ucukuno anyimo awe me, mi anyimo awe. ");
INSERT INTO jni_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sa Yeso ma mara ubo utize tigino me, masuri nan nanu tarsa umeme u hana a urewatu ukdoron ahira sa urei ubene ura'ani, makuri maribe nan anu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda de sa Yeso mahazi zi nan anu tarsa umeme. ");
INSERT INTO jni_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahudi, maziki anani kara nini kono u suro anu adang akatuma, nan nanu bezi urusa, nan nanu gunguzuno. We ē ahira me, wa inta mafitila, nan matoci nan turun ga tini kono. ");
INSERT INTO jni_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sa Yeso sama rusa vat mumbe sa ikem zi me ma hanna je, magun we, “Aveni inyara me.” ");
INSERT INTO jni_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wa kabirka me wagu, “Yeso unu nazaret” Yeso magun we, “mimani” yahudawa mauri, desa ma witime, maturi nan ana ni kara nini kono. ");
INSERT INTO jni_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sama gunan we, “mmani” wakuri inna dumo, warizi adizi. ");
INSERT INTO jni_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Makuri ma ikkiwe, “aveni inyar?” wagu, “Yeso unanu nazere.” ");
INSERT INTO jni_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesommakabirka, “mabuka shi agi mimani inki mimani i nyara, cekini anigino wadu sa.” ");
INSERT INTO jni_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Igino barki tize sa ma buka timyinca, “a nyimo ande sa wa nyam, da uni inde ma hunne ma ba.” ");
INSERT INTO jni_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon desa agusan me bitrus, barki sama inta uvira, mahupi makoriko unu udanga, makari me utui utari tinare, niza ni nume malikus. ");
INSERT INTO jni_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeso magu in bitrus, kurzo uvira uwe me upanu, inda sam nu rire sa acoo ma nyam ba? ");
INSERT INTO jni_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Anani kara inini kono sa hafsam nan nanu ira uma yahudawa, wa miki Yeso watirze me. ");
INSERT INTO jni_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","U tuba wadusan me ahira hanana, barki me kumara ku kayafa kuni, ugebe sa me mani unu katuma ka dang aniwe ni ginome. ");
INSERT INTO jni_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa mani ma gamirka mayahudawa tize, agi itekuwe unu inde ma wi barki anu. ");
INSERT INTO jni_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon nan Bitrus matarsa Yeso, ane ani uye unu tarsa umeme ma wu unu tarsa ugino me unu dang me ma rusame, maribe uhana anyimo ani kubu nu nu u dang me nan Yose. ");
INSERT INTO jni_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ba bitrus maton no amatara mana tukum me unu inde anyimo anu tarsa sa unu u dang me ma sa rusa me ma suri, mawuzi tize nan nune me sa turi innu be ana tukumme anime maduku riben in Bitrus . ");
INSERT INTO jni_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Akem kuca kunu be ana katuma me ku gun bitrus, “Huda ura nyimo anu tarsa unu geme ba?” magu “in zoom anyimo.” ");
INSERT INTO jni_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Avari nan nanu tonzino ana katuma udenga Asere waturi ahira me, wa hure tine tura wazin nu kunna din-din, barki azin ti wui. Bitrus maturi ni gome nan we innu kunna utum. ");
INSERT INTO jni_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Una katuma kadang ma iki Yeso abanga anu tarsa umeme nan nu dungara umeme. ");
INSERT INTO jni_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeso ma k abirka me, mabuka une tize kwas. Musa udangara mae ati denge ta Asere ahira sa vat mayahudawa magun na. Daki mabuka ire mum ni hum ziba. ");
INSERT INTO jni_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Barki nyani u igizom ni? igizo ande sa wakun nan azesere imum be sama buka, we warusa imum be sama buka. ");
INSERT INTO jni_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sa Yeso mabuka anime, uye anyimo a nu ira sa turi ahira me ma kumi, Yeso yace, “uzinmnumkadure unu dang ukatuma anime.” ");
INSERT INTO jni_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeso ma kabirka me magu, “imma buka imumu iburu, abuki imbe urusa anu awe wani nan ana katuma kadang wawitowe atari tum” “nyani wawu za?” ");
INSERT INTO jni_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ba hanana ma tumi adusan Yeso barki akatirame ahira akayafa una katuma kadang. ");
INSERT INTO jni_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Bitrus maturi innu kunna u tum. Anume wagun me, “aco hume cangin daki ura anyimo anu tarsa ume meba?” bama wuma tara magu, “mm'mm, inra anyimo ba.” ");
INSERT INTO jni_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Uye anyimo arere unu dang uka tumame, uhenu udebe sa Bitrus ma yorime utui magu, “aco daki ma irawe nigome nan me anyimo ubene ba?” ");
INSERT INTO jni_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus makuri mawu matara, sisi a hira me bigoro bi runo. ");
INSERT INTO jni_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","U zika ahira kayafa mahan Yeso ahira anu zauka. (Gwanna). Ni sisizo ini usahira, we ace aweme daki waribe ani kubu nu gwamname ba, kati wa cari ace awe ni wadiri are ujibi uhangirka. ");
INSERT INTO jni_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ba Bitrus masuri uhana ahira awe magu, “iya umum ini inzin nu bome ahira unu ginome?” ");
INSERT INTO jni_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba wa kabirka wagu, ingusi unu gino me da mawuza iri mum ba, nya ni ida wu na ti entize tume ahira awe. ");
INSERT INTO jni_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatus magun we, “Dussani immesisi ishi ni, ka gbarani usuro u wesi utize tishi” Ba mayahudawa wa gun me, daki tabari tuhu tize ahira uye ba. ");
INSERT INTO jni_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Abuki anime barki amyinca tize me sa Yeso wuzi, ige saya bezi usasana iwono sa madi wuzi. ");
INSERT INTO jni_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ba Bitrus makuri maribe ani kubu nu cawamna, matiti Yeso magun me, “hu ugomo umayahudawa mani?” ");
INSERT INTO jni_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeso makabirka, “igino me ubuka uwe uni, nani aye wani wabukam anime ahira a we?” ");
INSERT INTO jni_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus makabirka, “mi daki uyahudawa wa mani ba, nani ani?” ");
INSERT INTO jni_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeso makabirka, tigomo tum daki tu nee ugeme tini ba. Dagusi tigomo tum tu nee ugeme uni arere am wada wuza nikono barki kati azizin ahira ama yahudawa iye tigomo tum da ki a ban na ani tirani ba. ");
INSERT INTO jni_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ba bilatus magun me, “ana a senke hu ugomo mani?” Yeso makabirka, gussi be sawa buka mi ugomo mani. Barki a bi nyobigino bini ayom, nan barki a' anime ma ē anyimo unee, in nya urusa akadure. Koya unu hem in kadure make makunna ni myiran num.” ");
INSERT INTO jni_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatus magun me, “nyani kadure?” sa ma buka anime, makuri masuri ahira ama yahudawa magun we, “mi daki ma kem un uge me inna buri ba. ");
INSERT INTO jni_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Shi dei inmhira izin ure u tanda u ni, inki u idi ukafa wa wuna, in kini shi unu u inde. Aname inyara in ceki shi ugomo uma yahudawa?” ");
INSERT INTO jni_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wa kuri wa ziki ukaruwa innu gusa “mm-mm, daki unu gino ba, senke aceki barabas” barabas me mā ukari mani. ");
INSERT INTO jni_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bilatus ma cobi Yeso. ");
INSERT INTO jni_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ana nikara nini kono wa ririko Yeso ni'ere nikana anice, wa soki me tirunga titi gomo. ");
INSERT INTO jni_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wa ē ahira ame wa gu “Asere akinki we ivai, ugomo a Yahudawa, wa kumi me. ");
INSERT INTO jni_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilatus makuri ma suri amatara ma gun we “Ira ni, indi ē shi unu nume bati irusi daki makem me ina yari ba. ");
INSERT INTO jni_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeso ma suri, in ni'ere nikana nan tirunga titi gomo. Bilatus ma gu “Unu me ba”. ");
INSERT INTO jni_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ana dandang akatuma ka Asere nan anu ira sa wa ira Yeso, wa tunguno tihunu unu gusa “Gankirka nime, gankirka nime” Bilatus ma gun we “Zikini me i gankirka, daki makem me ina buri ba”. ");
INSERT INTO jni_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A Yahudawa wa gun me “Tizin tini kubu mabari iwano barki sa ma zika nice nume vana Asere”. ");
INSERT INTO jni_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sa Bilatus ma kunna tize tigeno biyau bimeke kang. ");
INSERT INTO jni_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma kuri maribe ani kuba nu gomna ma gun Yeso, “Abani wa suron?” daki Yeso ma kabirka me ba. ");
INSERT INTO jni_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bilatus ma gun me “Uda buka me tize ba? uta we inzin nikara sa indi cekiwe nan ingankirka we ba? ");
INSERT INTO jni_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeso makabirka me, “Uzo we in uru bari anice num ba, ingi daki a nyawe ahira Asere ba, barki anime de sa ma ayen mi ahira aweme memani unu cara abanga adang”. ");
INSERT INTO jni_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sa Bilatus makumna anime ma nyari uguna aceki me, ma Yahudawa wa yeze anyiran wa gu “Ingi wa ceki unu ugeme uzo we uroni ukarsa ba, vat de sa ma kurzo nice nume ugomo, ma cara Kaisar”. ");
INSERT INTO jni_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sa Bilatus ma kunna tize tuwe me ma susso Yeso amatara ma cukuno ukpunku umeme aba sa atisa “Ukpunka unu kubu” inti Yahudawa “Gabbata”. ");
INSERT INTO jni_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aroni ginome azin inabanga u idin keterewa, in na zumo utasi ani, inna tii uwui, Bilatus ma gun ma Yahudawa me “Kabani ugomo ushi me”. ");
INSERT INTO jni_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wa tunguno tihunu, ca adusan me, ca adusan me, aka gankirka me, Bilatus ma gun we “Ingankirka ugomo ushi me?” anu adangdang akatuma wa gu “Ti zon duru unu gomo ba bancen kaisar”. ");
INSERT INTO jni_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bilatus ma nyawe Yeso waka gankirka me. ");
INSERT INTO jni_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wa dusan Yeso, ma suri unu cira ukunte ugankirka uhana ahirame sa agusan u Golgota inti Yahudawa (Golgota). ");
INSERT INTO jni_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wa gankirka Yeso ahira me, nan are anu ware, uye atari tinanre uye atari tinangure, Yeso atii awe. ");
INSERT INTO jni_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus ma nyertike ure u'ira asesere ukunti ugankirka me, “Yeso unanu Nazarat ugomo ayanhu dawa”. ");
INSERT INTO jni_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A yahudawa gbardang wa aki wahiri i uhori me barki ahirame sa a gankirka men ara upuru uni pin. Ihori me awuza inti Yahudawa, ti Romawa nan ti helenanci. ");
INSERT INTO jni_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ana dangdang akatuma ka Asere kama Yhudawa wa gun Bilatus, kati unyertike agi ugomo wa Yahudawa ba, guna unu ugeme ma guna “mi mani ugomo wa Yahudawa”. ");
INSERT INTO jni_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus makabirka “Imum me sa ma nyertike mamu nyertike”. ");
INSERT INTO jni_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sa ana nikara nini kono wa genkirka Yeso, wa jani udibi umeme kani kanazi, kondi vi in ume upori, nan u-alkebba. U-alkebba me sarki adusa abara naza me utuno ana dizzi. ");
INSERT INTO jni_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wa gun nacece, “Kati tijanika u-alkebba me ba, ca azauka a iri de sa madi ree unu, a wuzi anime bati amyinca tize ta Asere sa ta guna “Wa hara acece awe udibi um, wa kuri wa rekki uzanka a alkebba am. ");
INSERT INTO jni_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ana nini kara kono wa wuzi timum tigeno me. A ino a Yeso, nan uhenume, nan Maryamu unee u Kilofas, nan Maryamu Magadaliya Anee ageme wa turi mamu nan ugakirka u Yeso. ");
INSERT INTO jni_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sa Yeso ma ira a ino umeme nan unu tarsa umeme sa ma hem inme wa turi mamu nan nacece, ma gu “Unee uge, ira vana uwe me”. ");
INSERT INTO jni_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma gun unu tarsa umeme “Ira a ino uweme” ugeno uganiya me unu tarsa umeme ma ziki me uhana ukura ame. ");
INSERT INTO jni_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Abini me Yeso, barki sa ma russa kondi nyani ya mara, batti amyincikina tize ta Asere, ma gu “In kunna niwee nimei. ");
INSERT INTO jni_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ani kira nuwe me aduku myinca niruu in mei ma innabi ma gbarrara, wa jonbi usoso anyumo amei ma innabi magbarrara me wa tirzizi ubuinan wa witti wawu me anyo. ");
INSERT INTO jni_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sa Yeso ma simbiko mei magbarrara me, ma gu “A mara” ma tungurko nice adizi ma ceki bibe bumeme. ");
INSERT INTO jni_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Abini me a Yahudawa, barki uwui ubi bara-bara bini, kati aceki mukizi muwe me ugankirka uwui wa sabar u'ē ba (barki asabar ueui uni uhuma), wa tirri Bilatus tari agi mapussi tibuna tuwe me ma tuzo we. ");
INSERT INTO jni_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ana nikara nini kowo wa ē wa pussi tubuna yuba me nan tunu-tarsa me sa agankirka we nan Yeso. ");
INSERT INTO jni_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sa wa aye ahira a Yeso wa kem manu wono, abini me dakki wa pussa tibuna tumeme ba. ");
INSERT INTO jni_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Vattin anime unu inde anyumo ana nikara nini k) no ma tummi nipara numeme inni gbinnan, maye nan mei masuri dibe-dibe. ");
INSERT INTO jni_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","De sa ma ira anime, ma cukuno unu imo amaru, u impo amaru ukadundura, ma russi imum me sa ma buka kadundura kani bati shima ihem. ");
INSERT INTO jni_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ya wuna anime batti anyenca tize ta Asere, “Ada purrame ni uboo ni inde anyumo a'uboo ameme ba. ");
INSERT INTO jni_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A tiri tize ta Asere ta guna “Wadi hiri me de sa waa tummi me”. ");
INSERT INTO jni_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sa awuza timum tigeme, Isuba una nu Arimatiya, de sa ma raa anyumo anu tarsa u Yeso mani (Nihunzi barki biyau bima Yahudawa) ma iki Bilatus batti ma ziki ikizi i Yeso. Bilatus ma nya me, Isubu ma ē ma ziki ikizi me. ");
INSERT INTO jni_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimo ma ē cangi, de sa maa tubi u aye ahira a Yeso in niye, ma ēn unu mai uman ununya umur nan al-ul ugittak wa ino'ukirau. ");
INSERT INTO jni_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wa ziki ikizi i Yeso wawu umalti ulubulubu nan umai unya uman me ugino me, bati wa vatti rep nan utanda wa Yahudawa. ");
INSERT INTO jni_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A hira me sa agankirka men uruu ubene wa rani, icau isoo ya rani anyumo uruu me igebe sa daki amu wuna iren ba. ");
INSERT INTO jni_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sa ya cukuno uwui ubi bara-bara ba Yahudawa uni, icau me ya raa manu, wa dusa wawu Yeso anyumo me. ");
INSERT INTO jni_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nisisizo unu wui utuba anyimo tiye usunare. Da hira amu sanaba, Maryamu madalin wa ē ahira icaw me wa iri nipo me atuburko nini. ");
INSERT INTO jni_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma dusa unu sum uhana ahira Simon desa agusin me Bitrus nan uye unu utarsa u Yeso de sa Yeso ma hem in me, ma gun we, “Azika Asere aro me anyimo iaw me, tidi tan duru ahira me sa aka nata meni”. ");
INSERT INTO jni_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bitrus nan unu utarsa u Yeso we suri, wa hā ahira icaw me. ");
INSERT INTO jni_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wadusa unu sum vat uwe, unu utarsa u Yeso ma sumi gangan ma ciki Bitrus me ma tubi ubiki ahira icaw me. ");
INSERT INTO jni_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sa ma gunkuno anyimome, ma iri mapuri me mani, da ma iribeba. ");
INSERT INTO jni_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sa Bitrus ma aye adumo ameme ma ribe anyimo icaw me, ma iri mapuri mani ma rari ahirame. ");
INSERT INTO jni_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nan tirunga sa ta ra ani cē numeme. Da tazi nan mapuri me ahira ba ta rabi ani kira. ");
INSERT INTO jni_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Unu utarsa u Yeso, de sa matubi uhana icau me me cangi ma ribe, ma iri ma hem. ");
INSERT INTO jni_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Barki uganiya ugino da wa mu tinka tizze me ba, agi uhira urani ingi a wono. ");
INSERT INTO jni_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Abini me anu utarsa u Yeso wa kuri akura. ");
INSERT INTO jni_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu ma turi a matara u watu icaw me ina sō, sa ma sō magunkuno anyimo icaw me. ");
INSERT INTO jni_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma iri ibe ika dura ka Asere ana wa rē ni ti runga tirum wa ciki, uye u watu unice uye uwatu tibuna ahira me sa anati Yeso meni. ");
INSERT INTO jni_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wa gun Maryamu, “Unu, nyanini uzinasoni?” ma gun we, “Barki wa zikam Asere, in da risam ahira me sa wa hanan me”. ");
INSERT INTO jni_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sa ma guna anime, ma gamirka ma iri Yeso maturi abini me, me dama rusi agi Yeso mani ba. ");
INSERT INTO jni_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeso ma gun me, “Unē, nyanini uzin nasoni? aveni u nyara?” ma gusi agi unu uhira a hira mani, ma gun me, “Unakura, ingi haman wa zika me, bukam ahira sa wa hanan inme, indi ka zika me. ");
INSERT INTO jni_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeso ma gun me, “Maryamu” magamirka, ma gun me inti ibiriniyawa, “Rabboni” (agi unu udungara). ");
INSERT INTO jni_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeso ma gun me, “Kati udurumba, barki da mamu nyeni a hira acu am ba, dusa ahira anu henu um u gun we agi in haza ahira acu am nan ka acu uweme, Asere am nan aweme”. ");
INSERT INTO jni_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu madalin ma ē ma gun in na nu utarsa u Yeso, “ma ira Asere, “Manno ma gunan in mi. ");
INSERT INTO jni_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Unu ganiya uwunjuro, uwui utuba anyimo tiye usunare, anatukum ahirasa anu tarsa u Yeso wa rani, a inpi barki biyau ba ayahudawa, Yeso ma ē ma tunno ati awe magun in we, “Iriba ishi iwu irum”. ");
INSERT INTO jni_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Sa ma guna anime, ma bezi we tari tumeme. anu utarsa umeme wa wuzi uriba irum sa wa iri me. ");
INSERT INTO jni_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeso ma kuri magun we, “Iriba ishi iwu irum, kasi sa acu ma tumam, mima matuma shi”. ");
INSERT INTO jni_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sa Yeso ma guna ani me, ma hure wa magu, “Kabani bibe biriri”. ");
INSERT INTO jni_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Desa ma wuza shi imummu iburi, cekini me adi cekishi, ingi ya inko adi inki shini cangi. ");
INSERT INTO jni_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, uye anyimo anu kirau in wa re de sa agusin me vana ibari, mazinan we ba uganiya sa Yeso ma ē. ");
INSERT INTO jni_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Unu utarsa u Yeso uginome ma magun me, “Ta ira Yeso”. Ma gun we,”Sede ma ira ni hara sa ni ra atari tu meme sa a kutiku men, indi ku hemi. ");
INSERT INTO jni_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sa tiye uwititari ta aki anu utarsa u Yeso wa raa anyimo akura, Toma ma zinan we, tina tikum ti inpino, wadusa wa iri Yeso anyimo aweme, magu, “Iriba ishi irummi”. ");
INSERT INTO jni_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Abini me magun in Toma, “Biki abame in nibo nuweme u iri tari tum, biki u wu nibo nuwem anyimo tihara. Kati ucukuno unu zatu me uhemzi”. ");
INSERT INTO jni_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma makabirka magun me,”Asere Asere am”. ");
INSERT INTO jni_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeso ma gun me, barkisa wairam, wadiku hem in mi. ");
INSERT INTO jni_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeso ma wuzi timumum sas-sas aje anu utarsa umeme, igebe sa da ayetiki ini abame ba. ");
INSERT INTO jni_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sede a Yetirke anime, barki i inki a muriba Yeso mani, vana Asere, ahira u inko a muriba mushi idi kem uvengize anyimo niza numeme. ");
INSERT INTO jni_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sa imumu igino me ya aka, Yeso makuri ma bezi nice numeme ahira anu utarsa umeme ukure a uraba tibariya. Tibariya, A' ani ma bezi nice numeme. ");
INSERT INTO jni_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon sa gusi me Bitrus ma rani na toma desa agusi me bi bari. Nataliya uwatu uakana ugalili, vana uzabadi, nan unu tarsa u Yeso warē. ");
INSERT INTO jni_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon sa agusi me Bitrus ma gun we, “in haza umisi icere” “wagun me, “haru cangi, tidi tarsi we.” wa hā waka ribe uzirigi, da wa miki imumbe vat niyē me. ");
INSERT INTO jni_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Anime ahira sana, Yeso matunno ani kira anu utarsa umeme da wa rusi agi Yeso mani maziba. ");
INSERT INTO jni_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sa Yeso magu nan in we, “iyani i zoshi in ire imumare baa” wagun me, “muh.” ");
INSERT INTO jni_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma gun we, “vingini ikali ishime uwatu utari tinare idi mesi ire.” wa dusa wa reki ikali u watu me da wa guna uhungu koba barki ugbardan icere me. ");
INSERT INTO jni_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Unu utarsa u Yeso sa Yeso ma hem in me, magun in Bitrus, “Asere mani” sa simon sa gusa mu saki tirunga(barki mazi myenpere), maka rizo anyimo uraba udangang. ");
INSERT INTO jni_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Uye um utarsa u Yeso maribi izirigi me (barki da wa zi pit ba, kasi umiki kanu akure are u hana aseseri). Wa hunuko ikati me gbem in ceri. ");
INSERT INTO jni_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sa wa suri matara, wa iri in ene nura ini cere asereri me, nan uborodi. ");
INSERT INTO jni_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeso ma gun nwe, “ayeni in ire icere sa ya mesi.” ");
INSERT INTO jni_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon sa agusi me bitrus ma hā maka hunguko ikali me a matara, gbem ini cere inu a ino kirau ina kuri ucibi in ana taru (153). Vat unu gbardan icere me de ikali me ya janikaba. ");
INSERT INTO jni_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeso magun nwe, “aye reni imumare” anyimo anu tarsa umeme ba desa mawu iriba ihu sa madi iki me iri mum, “hō aweni?” wa rusi Aere mani. ");
INSERT INTO jni_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeso ma ē, ma ziki uborodi me, ma nyiziwe nan icere me. ");
INSERT INTO jni_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","U taru wa zigino me Yeso ma bezzi nice nu meme ahira anu utarsa umeme sa ma hiri anyimo ani wono. ");
INSERT INTO jni_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Sa wa mara are imu are, Yeso magun in simon desa agusame bitrus, “simon vavna uyohana wa hem in mi anime?” Bitrus magun me, “Asere, u rusa ma hem in hu, “Yeso magun me,” hiram itam in”. ");
INSERT INTO jni_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma kuri magun na ukure, “simon vana u yohana wa hem in mi?” bitrus magun me, “Asere urusa ma hem in hu” Yeso magun me, “hiram itam im”. ");
INSERT INTO jni_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma kuri ma iki me uturu, “simon vana u yohanna wa hem in mi?” bitrus ma kunna iriba barki Yeso ma iko me kataru “agi wa hem in me?” magun me, “Asere” urusa imum vati, irusa ma hem in hu, “Haram itam in.” ");
INSERT INTO jni_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kadure, kadure in boo shi, datti ya zi cincin, ya rusi u inbizo aceshi i hazi ahira sa i nyara sa ya una, iki witi tari tishi, aye wa sosi shi tirunga wa kuri wa hazin in shi ati hira me sa i nyara uhaza mani.” ");
INSERT INTO jni_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeso mabuki anime barki ma bezi Bitrus usandi iwono sa madi wuzi ma nonzo Asere, sa ma buka anime, magun Bitrus tarsam. ");
INSERT INTO jni_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus magamirka ma iri un utarsa sa Yeos ma hem in mē ma tarsa we. Desa ma hibina abigiri bi' Yeso uganiya ugino me sa magu, “Asere aveni madi gahu?” ");
INSERT INTO jni_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sa bitrus ma ira anime magun Yeso, “Asere, nyanini unu ugino madi wu?” ");
INSERT INTO jni_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeso magun me, “Ingi in nyara ma cukuno ma bem in zē nyanini mei maweni? Tarsam.” ");
INSERT INTO jni_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tize ti geme taha ahira ani henu agi, unu utarsa u Yeso ugino me mada wonoba. Yeso dama gun Bitrus, unu utarsa u Yeso ugino mada wononba. A' anime, “ingi magun nan me macukuno in ē nyanini mei maweni?” ");
INSERT INTO jni_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Unu uge mani unu utarsa um sa ira imum igeme. Desa ma yetiki, ta hem mi kadure kameme. ");
INSERT INTO jni_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Timumum ti rani gbardan sa Yeso ma wuzi, dagi ayetiki vat imumme ka i' inde in boo shi, nan ni unē uda zika me vat imumbe sa a yetiki. ");
INSERT INTO jni_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Uyettike utakarda utuba sa maa nya, Tiyofilus maa buki. ");
INSERT INTO jni_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Vat abanga akatuma ka yeso, yeso maa tubisi katuma ku dungura uwiyi ukaba umeme udi ku. A dungurka una ubi be biriri a tari ta anu tize ta asere sa azauka. ");
INSERT INTO jni_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa ma marii uzito me ya akaa ma en inice nimeme u huma daki ire imum ya kem ma ba ");
INSERT INTO jni_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Uganiya sa ma zin ni'ori nan we ma gbarika we kati wa ceki Ujarusalem ba, ca wa be u'inko utize ta coo abanga ugu ana, ya kuna ya kuna ahira am. ");
INSERT INTO jni_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana anu in mei shi adi zorso in bibe biririin ye cingili sa ti eze. ");
INSERT INTO jni_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Uganiya sa wa gurna vat, wa iki me “vanaa asere uganiya uge uni udi buri anu tarsa Asere anyimo israila me.” ");
INSERT INTO jni_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma gun we, azo ka tuma kashi kani ba irusi uganiya nan uwuyi aco mani unurusa uwuyi uginome. ");
INSERT INTO jni_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Shi idi kabi nikara, ingi bibe biriri ba aye shi idi cukuno aje am. Ujarusalem u hana Ujidiya nanu samariya uhana ibinani unee. ");
INSERT INTO jni_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Uganiya sa vanaa Asere ma buki ti mum tige me, uganiya sa wa zi unu hira asesere, wadusa wa iri ma hira wadusa aseser niwiri ni dusa ni inpi me daki wa ira me ba. ");
INSERT INTO jni_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sa wa riki aje aseser wazi unu hira ume u dusa u meme wa dusa are anu wa re in turunga tirum pert wa turi ani kira ni we me. ");
INSERT INTO jni_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wa gun we, “shi anu ugalili, nyanini ya tonno aba me izi hira aseser me? Yesu ugeme sa ma dusa aseser madi kuri ma ze, gusi u dusa sa ya inu dusa me.” ");
INSERT INTO jni_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wa dusa wa kuri uhana Ujarusalem u hana ani poo ni olives, nazi mamu nan Ujarusalem, tanu me ta zi unu wui Asabar ani. ");
INSERT INTO jni_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sa wa biki wa nyene ahira ati gura ana zaa. Ahira sa wa ciki ni wazi Bitrus, Andrawus, Toma, Bartatimawus, Simon, Matiyu, Yakubu ussam u Alfasus, Simon una biyau ba asere nan Yahuda vanaa u Yakubu. ");
INSERT INTO jni_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wa guri ace awe me wa cukuno a inde a nyimo u wuza birigara. Wazi nigo me nan ane; Maryamu a'ino a Yesu nan anu henu umeme. ");
INSERT INTO jni_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Anyimo ati ye ti gino me Bitrus ma hiri ma atii ani henu, wazi a'ino ukirau nan na akue are (120), ma gu. ");
INSERT INTO jni_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nihenu, kadure kani ta Asere ti myinca, sa bibe biriri ba buki tize usuro anyo a Dauda abanga a Yahudawa, desa ma nya Yesu atari ta desa wa meki me.” ");
INSERT INTO jni_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Barki, mazi nigo me nan haru ma kabi ukalum utanda uka tuma ka Asere.” ");
INSERT INTO jni_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ana me unu ugeme ma kpi uru ini mum me sa ma kem ahira a katuma ka buri sa ma wuzi, abi ni me ani marizi mawi ni, nipum me ni wici, tini me ti kponko amatara. ");
INSERT INTO jni_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ya cukuno unu rusa ahira anu me sa wa ciki anyimo Urshalima vat, wa dusa wa inki niza na hira me in nilem niwe me, “Akeldama,” ya cukuno uru umaye. ");
INSERT INTO jni_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Anyettike anyimo u zabura; na uru me ucukuno ani me, kati aceki uye ma cukuno anyimo me ba. Na aceki uye ma ziki katuma ka meme. ");
INSERT INTO jni_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Idi wu rii desa madi ziki katuma me, ma cukuno a nyimo anu sa ma tarsi vat nan uganiya sa Yesu ma zi nigome nan haru. ");
INSERT INTO jni_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Uzika uganiya uzorso Uyohana, uhana uwui sa aziki me ahira aru, ca ma cukuno ukalum iwono nan uhira umeme. ");
INSERT INTO jni_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wa dusa wa reki anu wa re aje; Yusufu sa atisa me Barnaba akuri atisa me Justus we nan Mathias. ");
INSERT INTO jni_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wa wuzi birigara wagu, “ugomo Asere sa u rusa mu ruba ma nabu vat, bezi duru desa tidi zauka anyimo anu wa re wa geme.” ");
INSERT INTO jni_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Sa ma madi cukuno udura uwe me; anyimo atuma kawe me. ma cukuno ahira a yuhuda me sa ma wuzi ugbas me. ");
INSERT INTO jni_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba wa dusa rezi uzauka, ba urizi ini nice ni Mathias, madusa macukuno anyimo ana tarsa uYesu ukirau nan u'inde ugino me. ");
INSERT INTO jni_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Unu uwui Ufentacus wa eh vat uwe wa orno a hira inde. ");
INSERT INTO jni_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wa dusa wa kunna u gumurka u ire mu gusi ni pupur ni dusa ni myina a kura me sa cikini. ");
INSERT INTO jni_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Are myiran kasi urah a harzina, atu, ani ceh ni konda avi anyimo a we me. ");
INSERT INTO jni_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wa myica in bibe bi riri vat uwe wa tunguno u boo a myiran me sa a harsi we ni. ");
INSERT INTO jni_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ayimo urishlima are a yahudawa rani anu. tarsa Asere, ko da ba anyimo uneh. ");
INSERT INTO jni_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sa wa kunna ugumurka ugino me, vat nigoru na nu me orno ahira a inde barki wa ko a vi ma zin in tize in ni myiran nu me. ");
INSERT INTO jni_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Imum me i cukuno we i bosa utize, wnagu,' kadura, na vat u weme sa wa zin tize ti geme da anu uGalatiya wani ba. ");
INSERT INTO jni_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aneni ti kunna weh, konda vi ma boo nyiran na hira me sa ayo meni. ");
INSERT INTO jni_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Haru be anu, ufaritiya, wan anu Elamawa nan anu Ubagadaza wan anu Uyahudiya, wan anu Fantus nan Asiya. ");
INSERT INTO jni_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Nan anu Firijiya, wan anu Banfiliya, nan anu Nasar, nan adesa wa ra ati kira ti Kurane a mayanga mu Libiya, nan na genu sa wa suri Uroma, ma Yahudawa an de sa wa ribe ati Yahudanci. ");
INSERT INTO jni_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Makaritawa wan ma Larabawa vat ta kuna we wa zin unu boo abanga Asre inti lem ti ti pin turu. ");
INSERT INTO jni_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Vat uwe biyau ba mekibwe, wa gusi acece nyanini ya zige me. ");
INSERT INTO jni_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aye wa wuzi ni basa wa gu,” wa sa ubere uni. ");
INSERT INTO jni_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bitrus ma hiri ma tunno anu ukirau unu inde, ma nyeze ni myira, magu we,” Anu yahudiya nan a de sa wa ra a Urushalima, rusani imum igeme, rikani titui a tize tum. ");
INSERT INTO jni_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ana geme dawa sa ubere ba kasi u hira ushi me. ");
INSERT INTO jni_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imum be sa Yowel ma gu. ");
INSERT INTO jni_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Asere a gu, indi wuu bi be bi riri a nyimo anabu vat, ahana wan na ruma vat wadi buu tize tum, i nyani i shi me wadi iri imumu i ge sa wa mu ira ba, Cukoro wadi wuzi ti ro. ");
INSERT INTO jni_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A tiye ti geme indi wu we bi be biriri wadi buu imum sa i eze aje aru. ");
INSERT INTO jni_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Indi bezi we imum idandang ya sesere wani ige sa ira adizi, maye, urah, matum wan mu cingo. ");
INSERT INTO jni_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zuwui udi gamirka ucukuno Maree, Upeh uhana Maye, Uwui Ogomo Asere uku eh, uwui udang u gino me. ");
INSERT INTO jni_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abine ani koda avi madi wuzi biringara anyimo aniza na Asere unu bura uru. ");
INSERT INTO jni_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Anu Isaraila, kuna ni, Yesu unu Unazarat, de sa Asere a nya shi barki uhem ume, ahira imum idang wan imum i busa itize sa ma wuzi anyimo a shi me, kasi urusa ushi me. ");
INSERT INTO jni_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesu ugino me Aserea nya shi me unu rusa ume shi igankirka me utiti, a tari tanu zatu urusa Asere. ");
INSERT INTO jni_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","De sa Asere a hirza me unu ui, ma sopi me iwono iginome, barki iwono ya bari i inta me ba. ");
INSERT INTO jni_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dauda magu, vat uganiya in hirsa Asere aje am, ma ra atari ti na ree tm barki kti in urno. ");
INSERT INTO jni_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Barki ani me, iriba im izi pau, in zin ini riba i rum sarki i binani, in ra anyimo ani pum, indi wuzi ivai sarki ibinani. ");
INSERT INTO jni_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Barki mada hem in mi “iriba im iribe u ra ba, uda kuri hem iriba i we me iwici ba. ");
INSERT INTO jni_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wa be zum una iuai, udi kuri u wum i myinca ini riba irum a mu henu mu we me. ");
INSERT INTO jni_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ni henu, in da ki in boo shi tize in riba ka inde an ce ni ucokoro uru Dauda, ma wi vat me, kani igeme icau imeme ira ahira aru. ");
INSERT INTO jni_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Barki ani me, mazi unu kurzizo utize ta Asere mani, Asere a toniko me, madi tari uye a nyimo ni kura nu meme ahira ti cukun ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma ira ma kuri mabuki abanga uhira u Yesu a nyimo iwono, agi madi ceki me anyimo ura ba,”ni pum nu meme ni da wicu ba. ");
INSERT INTO jni_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu ugeme, sa Asere a hirza me, unu rusa uru. ");
INSERT INTO jni_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Barki sa a yeze me ma cukuno atari tina reh ta Asere, anyimo a bibe bi riri ahira aco, ma kwonko bi be biriri unu kunna ushime. ");
INSERT INTO jni_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Da Dauda mani ma nyene Asere ba, ma eh inice nu mume ma gu,”Asere a gunna Asere am cukuno a tari tina reh tum. ");
INSERT INTO jni_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Sede sa mapalki ana nu eru nu meme. ");
INSERT INTO jni_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Barki ane ani ani, na vat akura Isaraila wa rusi Asere akurzo me ma cukuno Asere nan unu bura uru de sa ya gankirka me. ");
INSERT INTO jni_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sa wa kunna imum igeme, tize me ti tumi we a muriba mu we me, wa gu Butrus wan nu kasu anu tarsa UYesu,”Ni henu nyanini tidi wuzi? ");
INSERT INTO jni_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitrus ma gu we, kabirka ni tize ta Sere a zoro shi, koda avi a nyimo ni za ni Yesu unu ubura uru madi kwiji ma dini vat, idi kabi u nyanki ubi be biriri. ");
INSERT INTO jni_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ubuka ugino me bark shewani, wan na ahana ashime, nan andesa wa zi pit, an desa Ogomo Asere aru ma titi we. ");
INSERT INTO jni_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma boo we tize gwardang, ma boo ma kingizini be mag” Bura ni ace ashime uneh uneh ubari ugeme. ");
INSERT INTO jni_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba wa kabi tizeme, a zorowe wa kinki in na nu akura- kuri a taru (300). ");
INSERT INTO jni_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wa dusa wa ri ajenan anu tarsa uYesu wan anu dungara uni henu a nyimo a tanume, wan upusa ubiredi nan biringara. ");
INSERT INTO jni_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Biyau bi meki kodi ya unu, imumu i basa u tize gwardan anu tarsa u Yesu wa wuzi. ");
INSERT INTO jni_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vat adesa wa hem wa zi ni gome wa kurinwa wuzi imumu inde me. ");
INSERT INTO jni_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wa zi zizi ti runga tu we me, wa hari konda vi ikirfi me, i binani u nyara u konda avi. ");
INSERT INTO jni_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kondi uya uwui wadi ha anyimo udenge Asere, wa pusi ubiredi ati kura ini riba i inde wa ri ini riba irum wanu toto iriba. ");
INSERT INTO jni_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wa nonzo Asere, wa kuri wa zin in mayee ma rum ahira anu. Asere a kinkiwe adesa a bura sa we a nyimo ni za ni Yesu kondi uya uwui. ");
INSERT INTO jni_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bitrus nan Yohana wahazi inni yeh udenge Asere. ");
INSERT INTO jni_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sa wabiki upuru ana tukum ariri wadusa wa iri uru nu ma ciki carki ayome sarki tanu, ake ayeze a inki ahirame koya ni sisizo mamiki urigiza utari anabu wa nyangizi adudo. ");
INSERT INTO jni_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sa ma ira Bitrus nan Yohana wa udenge Asere ma rikuwe tari. ");
INSERT INTO jni_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bitrus nan Yohana warikuwe je, magu, iran duru”. ");
INSERT INTO jni_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iriba ime idusa ikuri a hirawe inu basa madi kin iri, mum ahira awe. ");
INSERT INTO jni_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bitrus magu, “Inzom inni kirifi sandi nyawe ba, imumbe san zini ine ini indi nyawe, a nyimo ani za ni Yeso unu zatu madini. ");
INSERT INTO jni_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bitrus ma meki tari tinare tumeme ma hirzame mahiri tihihira timeme tiwitino inni kara. ");
INSERT INTO jni_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mahiri fagat, ma tunno, matubi tanu, maribe anyumo udenge Asere nan we unnu hinzina inni nonzo na Asere. ");
INSERT INTO jni_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vat anu wa irime mahhaka inu, haka ununzo Asere. ");
INSERT INTO jni_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wairime memani desa ma cukuzuno ana tukum a riri aginome uribi ze udenge Asere bi yau bi mekuwe kan imumbe sa awuza me. ");
INSERT INTO jni_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mara anyimo inta Bitrus nan Yohana anu wa sumi, uhana, ukagunna nan we anyimo anikubu sa atisa, nikubu ni Solomon imum ibiyau imikuwe. ");
INSERT INTO jni_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sa Bitrus ma ira anime ma bukiwe shi, unu Isaraila, nyanini ya wu ikuna biyau? aneni ya inkon duru aje gusi tahiri zame inni kara niruni? ");
INSERT INTO jni_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Asere Ibrahim, nan Ishaku, a Yakubu, acokoro utuba ma nunzi ka urere ume Yeso nan uzika urere ume Yeso, de sa ya nya, game, aje a Bilatus, sa ma zikin inguna madi cekime. ");
INSERT INTO jni_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Na iri me unu lau, nan nukabanu ugime agi aceki shi unu huzanu. ");
INSERT INTO jni_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Isabi hu nitini nu vengize uzatu mara. Asere a hirza me a mu cau, haru ta ira anime. ");
INSERT INTO jni_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aname nizanime nini, uham inni za nimeme, ini yanya unu ugino sa ihira irusa nikara, anime ani uhem in Yeso wa nyame ni huma a ve ashi me. ");
INSERT INTO jni_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Aname, nihenu, in rusa utasa utame uni uzi ya wuza anime, kasi a ana je ashime wa wu zi anime. ");
INSERT INTO jni_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","A, anime Asere a myinca mtize time mu atinyo tanu kurzu utize, Yeso Kristi madiziti. ");
INSERT INTO jni_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","A, anime cekini imomu izenzeng, gamirkani, barki a visa madini mashi me, Ugomo Asere ma nya shi ni huma. ");
INSERT INTO jni_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma tumi innunu zatu umadini sa nyara shi dati unu nu utuba me mani, Yeso. ");
INSERT INTO jni_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Me mani desa tigomo ta sereti nyara ukabi barki uganiya udati ubarka utimumum, sa Ugomo Asere manya atinyo tanu kurzuzzo utize ti lau. ");
INSERT INTO jni_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa magu, Ugomo Asere madi hirza shi ure unu kurzo anyimo'anu henu shime, kasibe sa ma hirzam, kadure kani i kunna imumbe sa mabuki. ");
INSERT INTO jni_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Idi cukuno vat de sa makunna unu kurzuzo tizetige me madi ribe ijas. ");
INSERT INTO jni_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","E, Samaila ma bu aban ga gino me, vat tize ti inde me tini. ");
INSERT INTO jni_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Shi ahana anu kurzuzo tize tini sa Ugomo Asere ma inki tize nanaka co ushime utuba, bishime vat nan tikura tishime anyimo une me wakim uringiringirka. ");
INSERT INTO jni_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sa, Asere mahirza udura u meme matubi matumime ahira ashime barki maringirkashi maro mashime ma kini tihara tiburi. ");
INSERT INTO jni_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Barki anime vana Asere ma ziti ani pum, kine haru ti tirizizi apum aru unu gino ubuka me. Vat desa ma zito anipum ma ceki wuza imumu izezen. ");
INSERT INTO jni_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Unu gino mada kuru ma tarsi tize tanu u ira uzenzen uni pum, se unu hem wa Asere vat tiye tume me unee. ");
INSERT INTO jni_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Barki anime tiye tamu aka sa tidi wuzi imube sa anu zato tarsa Asere wa nyara tiwuzi, imum izenzen, mei maje, bisisiza, imum ihuza apum, utarsa umakiri nan timumu ti zatu uri. ");
INSERT INTO jni_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wa zinu basa imum igino igenu ini izunu waza me sa da data ace nan we ba ana awuza timumu tigino me, wanno wa zogizo shi. ");
INSERT INTO jni_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sa ahira asani ni ye nikoree, ogorno uni pin, nan anu tarsa ume, wan anu nyettike ihori wa orno ahira inde anyimo urushalima. ");
INSERT INTO jni_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas unu unu dang udenge Asere mara ahira me, nan Kayafas, wan Yahanna a Alizanda, wan vat ni kura ni unudandang ukatuma ka Asere. ");
INSERT INTO jni_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sa wa anyen Bitrus nan Yohana ati aweme, wa iki we, ''an ni kara na veni, nani anyimo niza na veni i wuza imum igeme?'' ");
INSERT INTO jni_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bitrus, sa myinca in bi be biriri, magun we, ''ho ugomo anu nan anu tarsa uwe. ");
INSERT INTO jni_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ingi kani game i igizo duru ahira imum iriri sata wuza-agi barki nyanini ta huma unu nu okoni. ");
INSERT INTO jni_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Rusani vat ushi wan anu ashime a isaraila, anyimo niza ni Yeso unu nazarat, desa ya cerkeme utiti, desa Asere ahirza me u suro iwono, usuro ume uni geme ma turi aje shime in nihuma. ");
INSERT INTO jni_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeso memani nipo sa ana so wa gawe, ni kori ni cikuno nipon sa wa yara. ");
INSERT INTO jni_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uye mazoni sa tidi kem uburani; Nire niza ni zoni adizi ageme sa aya anyimo anu-unee sa tidi kem uvenkeni. ");
INSERT INTO jni_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sa wa iri katuma ka Bitrus wan Yohanna, wa kem da ane ani cas ba, agu agi anu zatu rusa imum wani unu wuza ana me. Wa e wa tinka a mu ziba muweme Bitrus wa Yohanna wa zi nan Yeso. ");
INSERT INTO jni_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Barki sa wa iri unu koni me sa an Bitrus na Yohanna wa humame ma turi nigime wa we. ");
INSERT INTO jni_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wa dosa wa samirka ti cikon me, wa tun gono ugamara me acece weme. ");
INSERT INTO jni_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wa iki, yamini tidi wuzi ina na geme? barki imumme sa ana geme wa wuza aje akonda vi anyimo urshalima, ti da ke ti ganduru ba. ");
INSERT INTO jni_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Da imumme yana hana pit ba nati hunguko we titui kati wa kuri wa buki uye tize ti Yeso anyimo ni pin ni gemeba. ");
INSERT INTO jni_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wa titi Bitrus wan Yohanna wa gun we kati i saki ubuka utize nani i dungori anu anyimo ni za ni Yeso. ");
INSERT INTO jni_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ba Bitrus wan Yohanna wa kabirka wa gu, ingi ya wuna uri ahira Asere ti kunna shi nani me, gunkuni i iri. ");
INSERT INTO jni_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Haru tida cekinduru ubo imumu ge sa ta ira izin masa ti kuri ti zin umi rusa imumme. ");
INSERT INTO jni_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sa wa hungu a Bitrus wa Yohanna titui wa ceki we wa dusa, barki sa da wa kem una ukuri ugwara uwe ba, vat ani ahira me wa zin unu nonzo Asere barki imumme sa ma wuzi we. ");
INSERT INTO jni_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Desa aceki a Bitrus wan Yohanna wa humame ma zin ti wee akura nazi (40) unu yoo. ");
INSERT INTO jni_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sa aceki an Bitrus wan Yohanna wa kuri waka buka ni henu imumme sa unu dang udenge Asere wan andesa waa zi wan me wa bukuwe. ");
INSERT INTO jni_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sa wa kunna, wa yeze amyra vat uwe wa nonzo Asere wa gu Asere, hamani wa bara unee, wan Adizi, wan awen wan vat imumum sa ira anyimo awe. ");
INSERT INTO jni_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ho sa bi be biriri bi soso ayoh aweme aco aro Dauda magu, yanini ya cara ana ma reh iriba. Alem awuza malim ahira ahura. ");
INSERT INTO jni_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Agomo unee ya orno ahira inde, anati gomo cangi wa orno ahira inde, agi barki wa iri urizo uvana Asere. ");
INSERT INTO jni_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kadure, an Hiridus wan Bilatus wan anu Israila wa orno wa muti ace agi barki wa iri urizo uvanaa Asere. ");
INSERT INTO jni_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wa orno ahira a'inde barki wa wuzi imum me sa Asere a rusi. ");
INSERT INTO jni_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ana orno ahira a inde barki wa wuzi imum me sa Asere arusi. ");
INSERT INTO jni_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Barki ingi wa wito tari tuweh barki uburri unee imumu ubasa tizee idi eh barki vana uweh yeso. ");
INSERT INTO jni_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Sa wa mari biringara, ahira me sa wa orzono vat uweh atunguno uzoro, barki vat uweh wa myinca in bi be behuma, wa buu tize ta Asere in ni kara. ");
INSERT INTO jni_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Anu gwardang wa kabi tize me iriba iweme da uye m buka ire imum iburi ba nan ma wuzi iri imum isas, anime wa wuzi vat imu inde. ");
INSERT INTO jni_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","In kara adura wa zin unu buu abanga u hira u Yeso nan urunta wa kem ");
INSERT INTO jni_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Da akem uye anyimo aweme sa madiri ire mum, vat desa mazin in iri mum ini ce nume wa zizi wa ezin mikirfi me. ");
INSERT INTO jni_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Wa isi ati buna ta adura. A hari vat adesa wa hem in tize ti Yesu, a tarsi anu dira. ");
INSERT INTO jni_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu, ulawiyawa, unanu kuburus anyame niza Barnabas ahira ana kadura ka Asere agi unu unasa iriba. ");
INSERT INTO jni_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mazi unuroo, ma zizzi uni ma ēn ini kirfi me ma inki ati buna ta ana kadura ka Asere. ");
INSERT INTO jni_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uru nu una niza Hananiya nan unee umeme Safiratu, wa zizi uru uweme. ");
INSERT INTO jni_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hananiya ma hunze ire ikirfi anyimo ikirfi urume, (unu rusa unee me), wanno wa eh unu ikirfi me ahira anu rusa me. ");
INSERT INTO jni_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bitrus manno magu, ''Hananiya nini ya wuna wa ceki bibe bibur ba myinca iruba iweme, hube wa wuza bibe biriri moco? hu wa hunze ire ikirfi urume? ");
INSERT INTO jni_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Uganiya sa da wamuziza urume ba, azo uwe uni wazi ba? uganiya sa wa zizi uni, azo uwe uni ba? nyanini ya wuna wa wuza ugino basa me iruba iweme? in anime azo anabu wa wuza moco ba, Asere ani wa wuza me. ");
INSERT INTO jni_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ahira me sa ma kunna anime, Hananiya ma hunguko ivai imeme imaza. Vat anabu sa wa kunna tize tigino me biyau bi dandang bameki we. ");
INSERT INTO jni_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Inyani ya eh igemdirko ikizi imeme wa suri ni amatara waka vatime. ");
INSERT INTO jni_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Uganiya ka taru wa aki, unee manno ma eh, unu tame imum be sa izi ba. ");
INSERT INTO jni_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bitrus manno magu, ''buka ihono ini ya zizi uru me?'' ma kabirka magu, ''ana ani tazizi.'' ");
INSERT INTO jni_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bitrus mauku gun me, '' nyani ni ya wuna ya bara magino moco me nan uruma uweme bati imansa bibe ba Asere? kunna tanu ta desa wa ka vati uruma uwe me ana tukum, we wani wadi ziki we ana me.'' ");
INSERT INTO jni_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ahira ma rizi aje ameme, ma hunguko ivai imara, inyani ya eh ikem me ma wono; wa ziki ikizi me wa ka vati upuru uruma me. ");
INSERT INTO jni_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Biyau bi dandag ba meki anu tarsa Asere me vat uwe nan andesa wa kunna imumu igino me. ");
INSERT INTO jni_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Imum biyau nan nu basa kan wa meki anabu, atari ta dura me. Vat uwe wa ra nigime ukpanku u sulaimanu. ");
INSERT INTO jni_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Azo me uye uni iriba ihuu ma pati nice nigome nan we; Barki anime ukaba kang aje anabu. ");
INSERT INTO jni_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Uhana ana me akenzi ukinkin anu nyaza iriba, gbardang ahana ruma nan na eh. ");
INSERT INTO jni_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wadi ziki ana ti koni han we unaa, wadi nasa we asesere ati komi nan ti penge, barki inka Bitrus ma aye u aka nani mazu ma me madarsi aye aweme. ");
INSERT INTO jni_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anu gbardang wa eze usuro ati pinpin sa ta keti urushalima, wa ezi nan nati koni, nan andesa agwergene wa meki we, anno ahumu zan we vat. ");
INSERT INTO jni_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Barki anime una katuma ka Asere udandang ma hiri nan vat andesa wa zin nan me (Anu tarsa asadukiyawa); wa myinci in ni ero kan. ");
INSERT INTO jni_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wanno wa meki ana kadura me wa reki we anyimo udenge uni rere. ");
INSERT INTO jni_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Anyimo ani yee me bibe bi kadura ka Asere ba poki tina tukum tu denge uni rere me ma suzo we a matara, magu. ");
INSERT INTO jni_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","''Hana ni ika tunno anaje udenge Asere ibuki anabu tize tigeme ti vai.'' ");
INSERT INTO jni_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sa wa kunna anime, wanno wa dusa udenge Asere unu sana ahira wa bezi tize me. Barki ani me una katuma ka Asere udang nan nanu ameme wa eh wa titi ni ori nan aroni akatuma, nan na nanu anu isra'ilawa wa suri wa meku nyaza uni kar, asuso we ana katuma kadandag. ");
INSERT INTO jni_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sa ana katuma wa hana uenge uni rer me da wa kem uye, udenge uni rer ba, wanno wa ze wa eh wa buki. ");
INSERT INTO jni_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Wa gu udenge uni rere me u impi gangang anu hira wa rani wa turi ana tukum sa ta ribi, da ta kem uye anyimo ba. ");
INSERT INTO jni_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ana me sa unudang udenge Asere nan nanu ana katuma ka Asere sawa kunna agino aguran me, wanno wa tunno ukira kan abanga aweme, ana me nyanini agino me adi yoo. ");
INSERT INTO jni_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Uye manno ma eh ma gun we, ''anu agino me sa ya reki we anyimo udenge uni rere me wa ra abirko anyimo udenge Asere wazi nu bezizi anabu tize.'' ");
INSERT INTO jni_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Udang udenge Asere ma ha nan ahana akatuma kameme wa ka ayen we, azo unu hiza iruba ba, barki asuma kati anu wa vingi we. ");
INSERT INTO jni_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sa wa ayen we, beizi aje anabu, una katuma ka Asere udang ma igizo we. ");
INSERT INTO jni_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Unu guna, ''da ta karti shi kara kati ibezizi tize anyimo aniza nigino ba? barki anime shibe ya myinca urshalima unu bezizi utize tishi me, izinu nyara guna maye mu nu gino me tuu ace aru.'' ");
INSERT INTO jni_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Barki anime Bitrus nan ana katuma kameme wa kabirka wa gu, ''gwas ini ti tarsi asere azo anubu ba. ");
INSERT INTO jni_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Asere aka co uru ma hirza Yeso, desa ya huu me, ahira ugankira ume asesere utiti. ");
INSERT INTO jni_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Asere manno ma heze me atri tina re tumeme, barki ma cukuno ugomo nan unu bura, ma nya isra'ila ubarka nan uvete umadini. ");
INSERT INTO jni_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Haru anu tunno amaru wani imumu igino me, ane bibeu ba Asere, bi gesa Asere anya ahira avat andesa wa tarsa in me. ");
INSERT INTO jni_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sa anu tarsa umeme wa kunna anime wanno wa kunna iriba kang, wanno wa nyari uhuza adura me. ");
INSERT INTO jni_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Barki anime ure ufarisawa una niza ni gamaliel, unu bezi urusa desa anu wa nonzo me, manno ma tonno ma wu anu wa suso unu rusa me a matara cing ");
INSERT INTO jni_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Manno magun we, 'shi anu isra'ila, rusa ni kan ini mumbe sa iwuzi ana gino me. ");
INSERT INTO jni_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Atiye tu aka uye ma eh una niza Tundas mazika nice nume ire imum, ugbardang anu akura anazi wani wa tarsi me, sa ahuna me anu ameme vat wa samirka, azo desa ma kunna ahira sa wa rani. ");
INSERT INTO jni_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Maru ameme, awuzi uye una niza Yahuza ugalili desa atiye tu basa, ma eh ma rangi anabu gbardang me ma corno me, vat andesa wa tarsi me wa samirka. ");
INSERT INTO jni_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Barki anime inboo shi nyettike ni nan nanu agino me, barki anika ubara uwe me nanu wuza uwe wa nabu uni idi corno me. ");
INSERT INTO jni_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Barki anime inka imumu igino ahira Asere ani ida icari ini ni ba, kati icukuno arangi we. ");
INSERT INTO jni_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sa wa tita anu rusa anyimo wa tiri we, waduku gun we kati ikuri uwuzi ubezi utize anyimo aniza ni Yeso ba, wanno wa ceki wa dusa. ");
INSERT INTO jni_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wanno wa suri anyimo anu tarsa me, uni iriba irum barki bari ayomu we barki niza nigino me. ");
INSERT INTO jni_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ban anime kode uya uwui wa haza udenge Asere, wa tarsa ti kura, wazi nu bezizi, wa kuru wa dusa sarki ude unu guna Yeso memani vana Asere. ");
INSERT INTO jni_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Anyimo atiye, uganiya sa anu tarsa uYesu wa kinki, ayahudawa u watu ugirkawa wa eh imbi bukum ba yahudawa me, barki kati akarti ane akoro imumare. ");
INSERT INTO jni_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","A nu u tarsa uYesu ukirau in na wa re wa titi u kasu unu tarsa wakem we, wa gu”ida rizi me ti vete tize ta Asere barki abanga imuma re ba. ");
INSERT INTO jni_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","shi wani idi zauka ahana aruma usunare a nyimo aru, anu aniza, ni riri, sa wa myinca in bi be bi lau nan u gamara u tize, sa ti di zauka we anyimo a katuma ka geme. ");
INSERT INTO jni_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Barki haru, ti di ri je in bi ringara a nyimo a katuma ka Asere. ");
INSERT INTO jni_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A nu wa kuna u runta u tize ti we me. wano wa zauka Istifanus, sa zi in bi be bi riri, nan Filibus, Firokorus, nikano, Timon, Pariminas nan Nikalus, ugenuanyimo uAntakiya. ");
INSERT INTO jni_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Anu wa eh in na nu me a hira anu tarsa u Yesu, wa wu bi ringara, wa wu tari. ");
INSERT INTO jni_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tize ta Asere ta ri aje a nabu me wa kinki gwardan a nyimo u Urushalima. anu adandang gwardan wa soki ni ce anyimo katuma ka Asere me. ");
INSERT INTO jni_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanus sa ma kem ni kara ma wnzi katuma ka danang anyimo a na bu ");
INSERT INTO jni_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9",". Ine ini anu ahira anigora me, wa hiri, atisa we, anu udengi uni Libartinawa, anu Sirinia nan anu Kuraniyawa aye anyimo nan Silisia. Anu ageme wa wuzi matara nan Istifanus. ");
INSERT INTO jni_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wa diri utonno urusa abanga a bibe nan u urusa ugamara utize ti Istifanus. ");
INSERT INTO jni_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wa cuzi ni pum ruri aye agi wa gu, Takuna Istifanus ma cari niza ni Musa nan Asere. ");
INSERT INTO jni_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wa turika anume nan nu urusa u tize ta Asere, wa hunguko Istifanus uhana a nyimo a hira anu a dandang. ");
INSERT INTO jni_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wa eh uye ma buki ma cico, agi, unu geme ma nyara mi in ingara tik in ti zogo ta hira ani gura me nan nu inko utize. ");
INSERT INTO jni_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta kunna ma gu,”Yesu una nu Nazaret madi cari hiri a geme ma kuri ma gamirka utanda sa Musa ma nya duri.” ");
INSERT INTO jni_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vat unu sa wa ra ahira ticukum me a inki me aje wa iri mu henu mu me me gu mu vanu katuma ka Asere. ");
INSERT INTO jni_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Una katuma ka dandang ma gu ka dundure kani. ");
INSERT INTO jni_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanus ma gu a henu nan a ka co kunnanime aco uni nonzo ma kem aco aru Ibrahim anyumu a Misopotamiya otuba ticukum u hara. ");
INSERT INTO jni_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma gu imme ceki ma nyanga ma we me nan nanu henu uwe me, hana a manyangamage sa indi bezi we. ");
INSERT INTO jni_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Monno ma ceki manyanga mu kaldiya ma cukuno u haran, ba abim me sa a co me ma wi, Asere a e imme a nyimo a manyanga mageme sa inci kin. ");
INSERT INTO jni_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ma nyari unga umeme nyania hira a indai barki ukalum, ko a hira sa madi inki ubuna. se ma inki tize, u zatu u kem u vana u ibrahim dati. ");
INSERT INTO jni_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Asere ma boo me a nime barki wadi chukuno a ma nyanga ma soh nan a na a hira me wadi wu wa ziti ti we esoh inaze. ");
INSERT INTO jni_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","''In di hungu ko titui ta nu age sa wadi wu we a ni rere me,'' ingi asere, Inna dumo me wadi eh wa wu zim niru a banna me. ");
INSERT INTO jni_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma kuri ma nya Ibrahim in inko u tize tini gbari Ibrahim ma yoh Ishayu ma gbari me rono u witotari Ishaya ma yoh Yakubu, Yakubu aco a nu kirau i. ");
INSERT INTO jni_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A cokoro wa wu ni eru ni Yususu wa ziki me u masar, Asere magi nan me. ");
INSERT INTO jni_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ma suso me a nyimo anirereme, ma nya me mu henu nan nu rusa utize a hira a Firauna Ugomo u masar, Firauna ma nya me ucanti u masar nan na kura ameme vat. ");
INSERT INTO jni_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","An no a ribe ikomo ukene a manyanga mu masar vat nan kanana nan nu zito kang, a kaco aru wa diri imumare. ");
INSERT INTO jni_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Serki sa Yakubu ma kunna imare ira anyimo umasar, matumi akaco aru me. ");
INSERT INTO jni_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ukure me Yusufu ma suri wa iri me, firauna ma gurna nan na henu a Yusufu me. ");
INSERT INTO jni_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu ma tumi a henu ameme waka buka Yakubu a co ameme ma e u masar, vat nan ni henu wa biki eso sunare nan nu cibi. ");
INSERT INTO jni_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu ma ha umasar monno ma wi nan aka co arume. ");
INSERT INTO jni_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aziki we u hana ushekem a nyimo a mu cau sa Ibrahim ma kpi a zurfa a tarin ta hana a hamor ushekem me. ");
INSERT INTO jni_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","U ganiya sa u u gwinci ka utize wa eh mamu, sa Asere ma buki Ibrahim, anume wa uh wa kinki u masar me. ");
INSERT INTO jni_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ure Ugomo ma hiri in na dumo, sa da ma rusi Yusufu ba. ");
INSERT INTO jni_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Me mani ma cangi anu acu me, ma nya we titene wa veti a hana awe me barki wa hama. ");
INSERT INTO jni_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","U ganiya sa a yo Musa ma rizi memerun aje Asere inta me tipieu ti taru a nyimo a kura a co ameme. ");
INSERT INTO jni_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sa a vete me a matara uco u Firauna ma wuzi ni wari ni me gu usam ume. ");
INSERT INTO jni_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa ma manza tu katuma anu u mesar tize time me nan katuma ka me ka zi memerun. ");
INSERT INTO jni_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Serke sa mabiki ti we a ino anazi, iri ba ime ya be zi me ma ka ira ahenu ameme ahana a Israilawa. ");
INSERT INTO jni_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sa ma iri azi un nutira ure u Istrailawa, Musa ma benki me, ma garza men ma dusa mahu unu ugino me. ");
INSERT INTO jni_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ma gusi agu ahenu me wadi iri tari ta Asere tini tidi benkiwe, da wa hemba. ");
INSERT INTO jni_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Rono ukure me ma biki a hana ameme wa zi in nukara ma ha ma gu in we, “A nu a dandang shi a henu wani, nya nini izi innu matara a cece ashi me? ");
INSERT INTO jni_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Unu ukwabi me matuburko musa me, ma gu “Aveni ma nya we tigomo tiru? ");
INSERT INTO jni_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Udi hem? gu sa wa hu u masara me ninjo me? ");
INSERT INTO jni_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa ma sumi sa ma kunna ani me ma cukuno gu ugenu a manyanga mu midia, monno ma yo a huna ruma ware. ");
INSERT INTO jni_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tiwe ti aino a aki, umalaika ma ha a hira a musa a nyimo a nijaa upana u Sinai, a nyimo a nilem ni ura. ");
INSERT INTO jni_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sa Musa ma iri ura, ma kunna bi yau, sa ma hana mamu, monno ma kunna ni gbiran na Asere, na gu. ");
INSERT INTO jni_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Mi mani Asere a kaco wa co aweme, aco a Ibrahim nan Ishaku, nan Yakubu, nipum ni Musa na tuba ukirsa, ma kari aje amemen. ");
INSERT INTO jni_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Asere agu imme, kara makwatak me, a hira a gemesa uturin a zo me imma dini ba. ");
INSERT INTO jni_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma mu ira utito a nu amme a nyimo umasar, ma kunna aso ashi me, mi be ma ringi in burishi, ayeni ana me, in di tumi shi u masar. ");
INSERT INTO jni_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa ugeme sa ya gidi me sa we gu, Aveni ma nya we tigomo aru? me mani Asere ma tumi me atari ti malaika sa ma kem me a nyimo ani jaa. ");
INSERT INTO jni_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa ma suso we a nyimo u masar, sa ma wuzi timumu ti dandang a nyimo umasar nan ni win nivu, nan a nyimo a nijaa a ti we ti nu a ino a nazi. ");
INSERT INTO jni_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa sa irusa me mani magu in na Israilawa Asere adi nya shi udura anyimo ashime nan na henu a shi, udura gimi. ");
INSERT INTO jni_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Me mani sa mara a nyimo a ni gurna a ni jaa nan malaika sa ma buki metize a nipana ni sinai me mani sa mazi nan aka co aru me, me mani ma kabi tize ti urai ma nya dura. ");
INSERT INTO jni_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Me mani unu me sa aka co aru wa nyaru u kunma utize ti meme wa idi me ahira awe me, nan a nyimo iriba iwemme wa kuri u masar. ");
INSERT INTO jni_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A nyimo uganiya uginome wa gu in haruna bara duru mu Asere sa wadi canti duru, Musa ugeme sa ma suso duru umasar, tita duru imum me sa ya kenme ba. ");
INSERT INTO jni_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wonno wa ba barka ku maruka atiye me wa nya madodo imumare, wa kunna urunta kang. ");
INSERT INTO jni_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Senke Asere a ceki we wa wuzi anu akura Asere kadtuma gu sa a nyetike a nyimo a matakarda ma adura kAsere, ya wekimi iname ya iro anyimo atiwe a ino a nazi a rujaa, a kura a Israilawa? ");
INSERT INTO jni_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yakabi a hira ni gurna ni molek nan Asere a Refan, nan na imum sa ya barka barki ni ru, indi ziki shi in aki u Babila. ");
INSERT INTO jni_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aka co arume wa zi inni rusa Asere a nyimo a nijaa, gu udungurka me umusa ma barka gu sa ma ira. ");
INSERT INTO jni_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A hira a nigurna nan kaco arume wa gamirka wa riben a manyanga a tari ti Joshua imum ya hiri sa wa ribe wa meki ti tihira sa Asere ma gidi we, aje a kaco aru me, Anime ani har uganiya u Dauda. ");
INSERT INTO jni_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Sa ma hem ahira Asere, ma ikki barki makem Asere a Yakubu a hira. ");
INSERT INTO jni_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Senke sulemanu ma barka Asere a kura. ");
INSERT INTO jni_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Unu udandang ma da ciki a nyumo a tikura sa abara in tari ba, gu ubukamwa na kadura me. ");
INSERT INTO jni_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Aza me a hira ti cukum tum tini, adizi me a hira upatala tibuna tum, aye akura ani udi barka mini? ubo wa Asere, nani abani indi venke? ");
INSERT INTO jni_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Da tari tum me tini ta wuzi ba? ");
INSERT INTO jni_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Shi anu sa ida kunna tize ba, da agwara muriba mushi nan titui, ko uya uganiya ya nyari ukana bibe ba Asere, i wuza gu aka co ashi me. ");
INSERT INTO jni_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Uya unu dura mani sa da aka co ashi wa yomo me ba, wa hu anu dura sa wa emaje unu ulau, shi be ya cikuno anu uhaza anu. ");
INSERT INTO jni_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Shi me sa ya kabi udungurka Asere me sa malaiku wa inko, shi be yaga shi ucanti me. ");
INSERT INTO jni_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sa anu adandang wa kunna timumume ya dari iriba iwe me, wa chari Istifanus in na nyo. ");
INSERT INTO jni_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sarki ma macika in bibe biriri, ma inki aje Asesere ma iri ni nonzo na Asere, ma iri Yesu maturi a tari tinare ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanus magu, ira, ma ira a poko Asesere me vana Asere ma turi a tari tinare ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Senki anu adangdang me wa wu uhanu in nigbirang we impi titui tu we me, wa rizi a me. ");
INSERT INTO jni_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wa kari me anyimo a nipin me wa tizi me in napo, anu hiri me, wa nati tirunga adizi a tibuna ti shawulu me. ");
INSERT INTO jni_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sa wazi innu tiza u Istifanus, ma ri aje innu tisa Asere, ma gusi, “Ugomo Asere kaba bine bimme”. ");
INSERT INTO jni_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma tunguno a dizi ma yeze nigbirang inni kara, Asere, kati ucanti ucara tize a nice ni we me ba, sa ma mari ubo anime, monno ma wi. ");
INSERT INTO jni_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu ma hem inni wano imemee, ronome a tubi u mensi anu tarsa Asere a nyumo u Jerusalem; an dee sa wa kabi tize ta Asere citi pin tu Judiya nan nu Samariya a meki we a samarka, ana ka dira wani wa dii chass. ");
INSERT INTO jni_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Anu nya ce sa wa vati Sitivin wa buki tize tiririn ani ce nume. ");
INSERT INTO jni_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shawulu ma ribe u tarsa uti kura unu mensi anu tarsa Asere unu korsuzo ma nan ni Jessi. ");
INSERT INTO jni_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vatin ani me anu kaba uti zeeta Asere me sa Asamirkawe wa ri aje uni boo utini. ");
INSERT INTO jni_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus ma dusa a nyumo ani pin nu Samariya unu boo uwe abanga ukirsti. ");
INSERT INTO jni_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A nabu gbardang sa wa kunna wa kiri wa iri ti mum sa ma zin unu wuza mee wa gamika muriba muwe mee a hira ame. ");
INSERT INTO jni_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ani bee izezen gbardang we e unu karsa u hunu, anu wijo uti hihira wa kem u humza. ");
INSERT INTO jni_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mu riba manu ani pin mee mu runme. ");
INSERT INTO jni_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Uye mamu rani ani pinme sa atisa me simon, dee sa ma dodonkinon anu Vengizi uwe muriba ini bere na nu bezi ubari. ");
INSERT INTO jni_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ASamariyawa a cincin nan a dandang vat, mu riba mu wemee mu kuri ahira ame, unu gusa unu geme mazin ni kara na Asere sa ri ori. ");
INSERT INTO jni_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wa re aje unu kunna umee barki sa ma dodonkino unu wuza uwe ribere. ");
INSERT INTO jni_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sa wa hem inka dura ku runtame sa Filibus ma hanawen, ka banga a kura Asere nan Yesu kirsti, a zursowe ana ruma nan na eh. ");
INSERT INTO jni_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon me changi ma hem inka durame a zorome, ma dusa more aje inti cuku na Filibus ma ira timum gbardang sa ma wuza ma kunna biyau. ");
INSERT INTO jni_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A dura me sa warani Ujerusalem wa kuma agi anu samariya wa kaba tize ta Asere, wa tuburko Bitrus nan Yohana. ");
INSERT INTO jni_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sa wa hana wa hana wa wuwe biringara bati wa kabi bibee biririn. ");
INSERT INTO jni_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","A zorsowe a nyumo ani zaa nu gomo Asere Yesu vati anime daki wa kem bibee biririn. ");
INSERT INTO jni_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","U aye u Bitrus nan Yohana wa tarsawe tari ace waduku kem. ");
INSERT INTO jni_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sa simon ma ira azin unu ninza ubibee biririn una utarsa utari ace ma witiwe ikirfi. ");
INSERT INTO jni_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ma gunwe nyanime ni ge nikaramee vat dee sa ma tarame tara anice makem bibee biririn. ");
INSERT INTO jni_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bitrus ma gunmee cornowe nan ikirfi iwemee, u basa uda kee ukpee u nyanki wa Asere ini kirfi. ");
INSERT INTO jni_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Iriba ya Asere izoo na huu, barki anime udaa kemwe baa. ");
INSERT INTO jni_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Barki anime ceki imum iburri iweme uwu biringara bati Asere a kpeeciwe. ");
INSERT INTO jni_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ma ira uraa anyumo ati kono tigwangwang tucharan. ");
INSERT INTO jni_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sion ma gu ringirkanme Asere kati timumme sa ya buka tikem. ");
INSERT INTO jni_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sa Bitrus nan Yohana wa mara uboo anu tizee tu Ugomo asere, wa kuri u hana Ujerusalem wa haki wa buu ana agiro u Samariya tizee ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bire bibee bika dura ka Asere bigun Filibus, hira tarsa ni kira nu kudu una Ujerusalem u hana ugaza (una ubikiki bine). ");
INSERT INTO jni_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ma hiri ma dusa. uru naa katuma a kura usarauniya wani Itopiya sa maaye Ujerusalem bati ma wuzi Ugomo Asere rinonzo. ");
INSERT INTO jni_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tantu kuro ma ciki unu hira citi zee ti Tshaya unu kurzo utize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bibee bi gun Filibus hana ka benki unu ugenemee. ");
INSERT INTO jni_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibus maka kem me unu hira uti Ishaya una tizee ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Indi wuu ani in russi sarki uye sa madiu benkum, aye benkum. ");
INSERT INTO jni_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A hira me sa unu Itopiya maazi unu hirame, a gusa, A hunge mee kassi bitan tantu kaweki nan bizara in ku tikmee sarki u buku tizee. ");
INSERT INTO jni_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A nyumo u yomomee sa wawuza me wacekimee, aveni madi buki uchara umemee, sa a hunamee unee. ");
INSERT INTO jni_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uchukorome ma iki Filibus ma gu kussu, unu kurzo utizee mee mazin anice numee nan ni uyee. ");
INSERT INTO jni_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filibus ma tubimee tizee ti Yesu unyertike u Ishaya. ");
INSERT INTO jni_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wa haki unaa wa wa eh a hira mare mei uchokoromee ma gunnme nyanini idi karti a zoron abamee. ");
INSERT INTO jni_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Inki wa hem anyumo iriba iwemee adi zorowee, ma gu ma hem Yesu Kirsti vana Asere mani. ");
INSERT INTO jni_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","U nani Itopiya me ma turi kubakura mee, wa dusa na Filibus me maka Zoromee. ");
INSERT INTO jni_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sa wa suro anyumo a mei mee bibee ba Asere biziki Filibus uchokorome ma nyarimee daki ma iramee, ma dusa ma meki unaa inninonzo. ");
INSERT INTO jni_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus maka suro Azotus, mari aje unu boo ukadura ku runta ati pinpin to watu me chip uka biki casariya. ");
INSERT INTO jni_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawulu anyumo ure aje inka tuma ku inza wanu tarsa ugomo asere, ma haa ahira unu udang ullatima. ");
INSERT INTO jni_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","U nyara inyerte mee saa indi nyame nikara nu guna maka mensimanu tarsa asere adi maskus a ma mekiwee ma ehn ujerusalem ahamna wa rumma nan na eeh. ");
INSERT INTO jni_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","maraa anyumo afanu mamu uribe adamas kas, ma iri masa ma suro asesere ma keteme. ");
INSERT INTO jni_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma dusa ma rizi adizi ma kuna nimyiran unu tissa umme shawulu, shawulu nyanini ya wuna uzin unu yomo uum. ");
INSERT INTO jni_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu ma gu hu aveni ugomo asers ma kabirka me ma gumme in manni ugomo asere yesu sa uzin unu yomo umee. ");
INSERT INTO jni_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma gun me hira ribe anyumo ani pin me adi bukuwe imumme sa udi wuu. ");
INSERT INTO jni_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aroni a tanu ti shawulu wa turin in kufik, wa kunna nimyiran intize sarki u ira unu. ");
INSERT INTO jni_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ma hiri ma kem urubo ya meki me a chanti me tari a riben me adimas kas. ");
INSERT INTO jni_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tiye tuma ti taru ini rubomee saki mare daki ma saa. ");
INSERT INTO jni_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ure unu tarsa asere maa rani anyumo adimaskas me sa atissa me hananiyai ugomo asere ma buki me tize ati roo. ");
INSERT INTO jni_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ugomo asere ma gunme hira hana ani kirame sa atisa nin derte a kura a yahuda u ikki una ni zaa shawulu sa ma suro u tasus. ");
INSERT INTO jni_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma raa nyumo abi ringara ma irri unu sa atisa hananiya ati roo, ma ehzee madi tarme tari bati aje ameme a pagno. ");
INSERT INTO jni_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiya ma ugomo asere mamu kumna ahira anu gbardang, uyomome sa unu ugeme mazi anu awemen ujerusalem. ");
INSERT INTO jni_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Anya me nikara ahira unu udandang uka tuma, ma meki vat de sa ma tarsa we. ");
INSERT INTO jni_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ugomo asere ma gunme hana ma zauka me, ma kurze me, imum ika tuma kami madi han intize tum a hira andesa wa taa me, nan nagomo wana hana ujerusalem. ");
INSERT INTO jni_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Barki imumme sa ma wuzam madi sih ijassi. ");
INSERT INTO jni_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiya ma hirimaka ribe akurame ma tari me tari ma gumme uhaanu (uroni) ugomo asere yesu sa wa gurna nan me unaa mani ma tamman batu aje awe me a pagkino ukuri ukabi bibee biririm. ");
INSERT INTO jni_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saarki u dodonkimo ure imum kasi uhama isuri aje shawulu irizi aje me a pagkino a dusa azorome. ");
INSERT INTO jni_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mari imum yaree nan ni kara. ma cukuno nan anu tarsa u yesu adimaskas, thiye gbardang. ");
INSERT INTO jni_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A birime udenge unu gurmee ma turguno tisa uni za ni yesu memani vana asere. ");
INSERT INTO jni_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vat anu wa tubi uhumoro, in gusa de sa ma huzza anu ujerusalem barki ni zaa nigemee, ma aye ma mensi anu abanamema haa unu udandang ukatuma. ");
INSERT INTO jni_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mu riba manu dimaskas mu kinki mu hunneme sa mazin mu gusa yesu mama ni kirsti. ");
INSERT INTO jni_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sa awuna tiye gbardang yahuwawa wa nyari uhuna ume. ");
INSERT INTO jni_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wah beh tinaa tukum me unu wai nan niye shawulu ma russi vat imumme sa wa inko. ");
INSERT INTO jni_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A nu tarsa u shawulu me wa zikime inye, wa wume igira waka tuzouzunu a matara. ");
INSERT INTO jni_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sa shawulu ma aye ujerusalem ma nyara utarsa anu tarsa u yesu, vat uwe wa kina biyau, a nyumo u taa me uguna mamu cukuno unu tarsa u yesu. ");
INSERT INTO jni_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas ma ziki me ma hanme a hira ana kaduraka yesu. ma kurzo we u gurna u shawulu nan asere wani tizeme sa asere ma boo me u naa, nan tize sa ma boo aniceh ni yesu adimaskas. ");
INSERT INTO jni_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma gursuna nan anu ribize nan nu susso anyumo ujerisalem, mazen tize a seseri ani ceh ni yesu ugomo asere. ");
INSERT INTO jni_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma kuri ma riajen matara nan ma yahuda wa mu brik, wa kuri wa naye unu nyara uhuna umme. ");
INSERT INTO jni_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sa anu henu me wa tuburko me utaarsus. ");
INSERT INTO jni_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A bini me anu tarsa asere u judiya, galile nan u samariya wa kem ti lukum ti mang wann reaje anyumo a tana tu tarsa ugomo asere gbardang nan bibee biririn. ");
INSERT INTO jni_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Sa bitrus ma mara utarsa uti hihira ma han ma kakem anu asere an de sa wa ciki u lidda. ");
INSERT INTO jni_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A bini me maka kem urunua sa a tissa me aniyas, ti weeh uwittitari unn kon uwono nire ni kiraa. ");
INSERT INTO jni_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitrus ma gun me aniyas yesu kirsti wa humanhu hira tonno mahiri matonno. ");
INSERT INTO jni_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ana ti cukum to lidda nan u sharon sa wa ira anime wa kabi tize ti gomo asere. ");
INSERT INTO jni_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Uye ma rani u joppa unu tarsa asere atisa tabitha, uneh mani inka tuma karirin ku benki anu dira. ");
INSERT INTO jni_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A tiye me ma zin unukon, sa ma wono a zoro ikisi me aka nata udenge. ");
INSERT INTO jni_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Barki u maamu lidda nan u joppa amu tarsa u yeso wa tumi ana wa ree a hira a bitrus ma benkiwe ma ee jibi. ");
INSERT INTO jni_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bitrus ma hiri ma tarsiwe. sa ma hana wa riben me udenge sa ikizi me iranrin. a koro wa ketti me ma soo, unu bizizi ume ti runga nan ti mum sa tabita ma wuza we. ");
INSERT INTO jni_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus ma susso we anyumo udenge me, ma tunguno naruu ma wuu biringara ma gamirka u watu ikizi me ma guu”tabita hira” ma pakki aje ma iri bitirus ma hiri macuku no. ");
INSERT INTO jni_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitirus ma witti me tari ma hiri matonno, ma titti anu tarsa asere nan na koro ma nyawe me uhuma. ");
INSERT INTO jni_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A bangame a samika vat u joppa anu wa kabi tizee ta sere. ");
INSERT INTO jni_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bitrus ma wuu tiye gbardang u joppa nan una riza simon unu duro uti waa. ");
INSERT INTO jni_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Urunu ma rani ani pen nu kaisariya niza nimeme Karniliyas, una je uma soja nan nigo sa atisa Italiya. ");
INSERT INTO jni_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Unu me makunna biyyau ba Asere, mi nan na hanna ameme wa tarsi Asere, mazi ma benki Ayahudawa ini kirfi gbardang, ama wuzi biringara ko ya uwui. ");
INSERT INTO jni_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uhana uganiya azumo kataru innu winjoro, abezime anyimo atiro tibi bibeu ba Asere ba ē ahira ameme bibeu me ba gunme, ''Karniliyas.'' ");
INSERT INTO jni_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Karniliyas ma riki bibeu bu gomo Asere aje ani hunzi, magu, ''nyanini izi una kura?'' Bibeu bi kadura ba gun me, ''biringara bu weme nan nu ningizi anabu aweme wa benki azesere, imum irengizi ahira ugomo Asere.'' ");
INSERT INTO jni_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","''Ana me tuma anabu, uhan anipin nu yafa waka ayen desa atisa me sminu sa, a tisa me Bitrus.'' ");
INSERT INTO jni_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ma ciki nigo nan saminu, desa akura ameme aciki ani kira nuraba. ");
INSERT INTO jni_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sa bibeu me ba buki tize nan me madusa, Kaniliyas ma tit anwa re, anyimo arere akura ameme, nanu soja u inde unu tarsa Asere anyimo ama soja me sawa wuzi me katuma. ");
INSERT INTO jni_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Karniliyas bukiwe vat imumbe sa awuzi manno ma tumiwe uyafa. ");
INSERT INTO jni_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A amura uhana azumo anu tasi (inna atii uwui) wazin tanu sa wa hana mamu nan nipin me, Bitrus ma nyene ahira akunta barki mawu biringara. ");
INSERT INTO jni_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mano makunna ikomo, mazinu nyara imumare, mazin nu unyara imare sa madi rii, uganiya me aye wazin nu sira imare. ");
INSERT INTO jni_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Manno mā iri masa mazesere ma pokino ma iri iremum ituzo kasi iso, ire mum kasi ugudom udandang uzin nu tuzo anyimo unee, azin nu tuzo ini tikira kanazi. ");
INSERT INTO jni_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Anyimo a ini vat bibar bara binama ya-iro iti buna tinazi nan anu hungoapuru adize nan ni nyin ya zesere. ");
INSERT INTO jni_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ine ini nigmirang nabuki tize nan me, ''hira, Bitrus, uweki u-rii.'' ");
INSERT INTO jni_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bitrus magu, ''ane ani ba, ugomo Asere, mi inriza imum izenzen ba nani imim imadini ba.'' ");
INSERT INTO jni_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ine ini nigmirang na kuri ni ē me; ''u-aye ukure, imumbe sa ugomo Asere ma kpico ini, kati ititi ini imum izenzen ba.'' ");
INSERT INTO jni_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Iginome yakem kataru; abineme aziki isome uhana anyimo azesere. ");
INSERT INTO jni_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Uganiya me sa Bitrus mazi bidi bidi anyimo ati rome sa ma iri ma iri anabu sa Karniliyas matumi we wa turi ana tukum akura me, sawa iki una uhana akura me. ");
INSERT INTO jni_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wanno wa isi ana kura me wa ikiwe nani saminu desa atisa me Bitrus a ma rāa abini me. ");
INSERT INTO jni_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Uganiya sa Bitrus maizn nu basa iriba usuro utiro me sa ma wuzi, bibeu ba Asere bagun me, ''ira anawa taru wazin nu nyara uwe.'' ");
INSERT INTO jni_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hira utuu udusa nigo nan we. Kati udi ba dusa nigo nan we, ''barki mimani matuma we.'' ");
INSERT INTO jni_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bitrus matuu maha ahira anabu magu, ''mimani desa izinnu nyara me, nyanizi ya ayeni?'' ");
INSERT INTO jni_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wanno wagu, ''unaje uma soja mani nizame Karniliyas una kadura kani matarsa ugomo Asere, mazin nu rusa uririn vat anyimo ayahudawa me mani desa bibeu birere ba Asere batu mi me agi ma ē ma kunna kadura ahira ameme.'' ");
INSERT INTO jni_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Biturs titi we wa ē wa cukuno nigome nan we. Anu henu me sa wa rani uyafa waka tibime. ");
INSERT INTO jni_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Innu sana ahira ukure sawa ribe ukaisariya, Karniliyas me ma nyargi we; Manno ma kiti anu henu umeme nan na roni ameme amamu. ");
INSERT INTO jni_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ya cukuno uganiya sa Bitrus ma ribe, Karniliyas ma gurna nan me manno ma tunguno ma nonziko me. ");
INSERT INTO jni_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bitrus manno ma hirza me, ''magun me hira utonno unubo mani kasi hu.'' ");
INSERT INTO jni_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Uganiya me sa Bitrus mazin tize nan me, ma ribe ahira ameme makem anabu gbardang wa orno ahira inde. ");
INSERT INTO jni_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Manno magun we, ''shi ina acce asheme irusa daki ya wuna urii unu wa yahudawa ma uzi nironi nani maka iso uye nani nire nikura sas. Ugomo Asere magun me kati iireni nan na namadini nani unu zenzen. ");
INSERT INTO jni_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ine ini ya wuna ma aye azome mataraba, uganiya me sa ya titi mi ma ikiwe barki anime ma iko shi nyanizi yatu ma ahira am agi in ē.'' ");
INSERT INTO jni_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Karniliyas magu, ''tiye ti nazi sata aka rep uganiya uginome, inze biringara uhana (azuma kataru) akura am, manno ma iri aye maturi in tirunga ti lau. ");
INSERT INTO jni_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Magun Karniliyas Asere ma kunna biringara buwe me, ubengizi wanabu wa una ugomo Asere ma ringin hu. ");
INSERT INTO jni_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Barki anime tuma uye uyafa, maka titawe unani za ni saminu desa atisa me Bitrus. Ma ciki akura asaminu, sa arani ani kira nuraba. ");
INSERT INTO jni_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","(Inka ma aye madi buki tize nan hu.) ");
INSERT INTO jni_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bitrus mā poki anyo ameme magu, ''kadure, kani ugomo Asere ma beziz uhar zina ba. ");
INSERT INTO jni_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Usuro anime, anyimo anabo vat unu tarsa Asere nan desa ma wuza imum iriri imumu ukaba Asere. ");
INSERT INTO jni_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Shi irusan kadura me sa ma tumi anu isra'ila, uganiya sama bu abanga ariri, unata iriba ahira a Yeso, desa memani ugomo Asere vat. ");
INSERT INTO jni_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Shi inna ace ashime irusa, abanga aginome, sa awuzi anyimo Ayahudawa ani ugalili, uganiya me sa Yahya mabuki abanga u zorso anabo. ");
INSERT INTO jni_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Abanga a Yeso unu nozari, ane ani ugomo Asere ma inki me sas nan bibeu ba Asere ubezi. Makuri mareje innu wuza imum iriri nan nu hamza andesa bibeu bi zenzen ba tirzi we, barki Asere mazi nigo nan me. ");
INSERT INTO jni_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Haru anu bezi wani, usuro u timumu tige sa mā wuzi vat amanyanga ma yahudawa nan na anyimo urshalima, mimani Yeso sa wā hume, usuro ukotiko ume azesere utiti. ");
INSERT INTO jni_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Unu gino me, Asere ahirza me, u wui utaru ugomo Asere mā buki anabu Yeso ma hira. ");
INSERT INTO jni_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Azo usuro vat anabu, usuro andesa ugomo Asere mamu zaukawe dati haru acce aru, andesa tare ti sii nigo nan me uganiya me sa ahirza me anyimo icau. ");
INSERT INTO jni_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma hem haru tibu anabu tize tumeme, tikuri tirusi memani Asere azauka me, ma wuzi we tize tini kabbo usuro andesa wa vengize nan nadesa wazi mu kizi. ");
INSERT INTO jni_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Usuro ahira ame vat anu kurizizo uyize wa bezi, urusa umeme barki vat desa manya kadure ahira ameme madi kem ukpico umadini usuro uni za nu meme. ");
INSERT INTO jni_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Uganiya sa Bitrus mazin tize abanga atimumum tigino me, bibeu bu gomo Asere batuu ahira andesa wazinnu kunna tize tumeme. ");
INSERT INTO jni_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Anabu sa wa rani anyimo ani gura nanu tarsa utize, ta Asere sa wa hem inni gbari vat andesa wa ē nigo nan Bitrus wa iri imum ibiyau, barki ukem ubibeu ba Asere sa ba-tuu anyimo anabu. ");
INSERT INTO jni_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Barki wa kunna anabu wazin tize in are lem wanno wa nonziko ugomo Asere. Bitrus manno makabirka. ");
INSERT INTO jni_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","''Nani uye marani sa madi karti azoro anabo in gmei, barki we wakaba bibeu ba ASere kasi haru.'' ");
INSERT INTO jni_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Manno mabuki azorowe anyimo aniza ni Yeso. Wanno wagun me ma cukuno nan we uhana tire tiye. ");
INSERT INTO jni_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sa ana tize ta Asere nan anu henu an de sa wa raa u Judiya wa gunna uguna anu zatu utarsa utize ta Asere wa kaba Asere. ");
INSERT INTO jni_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Uganiya sa Bitrus ma eh usuro u Rushalima an de be sa agbari we wa nyare me. ");
INSERT INTO jni_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wa gunme, hu u haka nan de be sa daki a gbara we ukuri uzi ina re amare nan we. ");
INSERT INTO jni_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ba Bitrus ma tunguno u kurzo uwe imum me va, ma gunwe. ");
INSERT INTO jni_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Mazii in biringara u Joppa, a nyimo atiro, in dusa in iri u gbetum wa tinu a zez sere vat ati kira ka nazi me. ");
INSERT INTO jni_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Sa ma ira ini in dusa ubassa a banga a ini, in dusa iri are adedu inama unee, inama inijaa, inama ihungo uti buru, nan ni nyin ya sesere. ");
INSERT INTO jni_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","In dusa in gunna ni myira a guna mi “Hira, Bitrus, huna uree. ");
INSERT INTO jni_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","In guna “In zom mei ni Ugomo Asere, daki iri mum be sa izo me lau nyani izenze be sa ya mu ribe a nyo am. ");
INSERT INTO jni_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ba ni myira ni kuri ni kabirka mi anyimo a sesere, imumbe sa Ugomo Asere maguna izi lau, hu kati ugu izo me lau. ");
INSERT INTO jni_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A wuu ani me kataru, a dusa a ziki vat imum me u hana a nyimo asesere. ");
INSERT INTO jni_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ana wa taru wa turi a na tukum a kara me sa ta rani, wa suri u Kasariya u ni sa a tumi we a hira am. ");
INSERT INTO jni_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bibe bi riri bi gun me dusa nan we, kati in hiri we uri zinaa, in dusa ti ribe nananu tasi me anyimo a kura unu ugino me. ");
INSERT INTO jni_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma dusa ma bukin diru maguna ma iri una kadura ka Asere a kura am, ma guna tuburko anu u hana u Joppa i en Simon, de be sa a tisa me Bitrus. ");
INSERT INTO jni_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Madi buki we kadura be sa kadi buri we wa naakura a wome. ");
INSERT INTO jni_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Sa ma tuba we tize bibe birere bi ribe we, gusi haru me sa ba tubi bi riben diru. ");
INSERT INTO jni_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","In ringi tize ta Asere, sa ma buki “Yohanna ma zoro a nu in mei, adi zorso shi in bi be biriri. ");
INSERT INTO jni_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","In ki Asere madi nyawe imum irir gusi uganiya me sa ta kabi me mono ma nyan duru, mi mazi a veni sa indi nyaru imum be sa Asere a buki. ");
INSERT INTO jni_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Uganiya sa wa gunna imum i gino me, wa cukuno we tik, wa dusa a ni nonzo na Asere, wa guna Asere a poko una u hana a hira a meme nan de be sa wa tobi tize ti meme. ");
INSERT INTO jni_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A nu tarsa Asere be sa wa zinti, uzika iwono isitiven wa suri u u Rushalima wa samirka wa dusa wa ribize a nyimo a ti hira gusi Phoenicia, Cyprus nan Antioch, wa buu masi a ibiriniyawa wa ni tize ti Yeso cas. ");
INSERT INTO jni_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aye a nyimo awome wa suri u cyrene wa e u Antioch, wa buu anu Greek wani tizee wa kuri wa buu tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ugomo Asere mazi nigo nan we, anu gbardan si wa kabi tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sa anu u denge utar sa u tize ta Asere u Urushalima wa kunna wa dusa wa tuburko Barnabas u hana u Antioch. ");
INSERT INTO jni_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sa ma ira imum be sa Ugomo Asere ma wuza, iriba irum imaki me kang magun we ita ni Asere ini riba ishi me vat. ");
INSERT INTO jni_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ma zi sheu; makuri ma myinca in bibe bi riri nan nu kaba a nyimo iriba imeme, anu gbardang wa kabi tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas ma ha u Tarsus a hira u ka nyara u soul. ");
INSERT INTO jni_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sa ma ira me maziki me ma em me Antioch, sa liwe na kuro wa dusa wa gurna udenge uni gura nanu tarsa tize tanu tarza Asere, wa bui anu gbardang tizee ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Anyimo a tiye tini ana kadura ka Asere wa eh usuro u u Russhalima u hana u Atioch. ");
INSERT INTO jni_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Uye a nyimo a wome una ni zah ni Agabus, sa mazin in bi be bi riri ma tonno, ma dusa ubo uwe unu guna ana, adi wuzi ikomo idandang vat unee, a wuzi imum igino me, atiye ti claudias. ");
INSERT INTO jni_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Anu tarsa u Yesu wahiri wa orso ikirfi wa tomi ini a ka nya ni he nu u Judea. ");
INSERT INTO jni_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wa nya an Barnabas wan Saul mani ikirfi me barki we wani wuzin in nanu me. ");
INSERT INTO jni_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Uganiya ugino me ugomo Hiridus ma wu aye anu tarsa ASere tari barki ma wu we waziti. ");
INSERT INTO jni_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ma hu Yakubu uhenu u yahaya innu vira. ");
INSERT INTO jni_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sama ira anime ya wuna ayahudawa rep, ma dusa ma meki Bitrus cagi. ");
INSERT INTO jni_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Uganiya sama meki maka korsome udenge uni re-re makuri mawu ma soja ma ni manazi wa wuze ni nyarga nume mazin inu guna madi zikime uhana ahira anabo uganiya ubuki utanda uweme. ");
INSERT INTO jni_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Uganiya ugino me Bitrus ma rani udang, ukorsisu anu, anime nihinu a nyemo udenge Asere wazin ibiringara ahira Asere kang barki me. ");
INSERT INTO jni_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Azi kasi nisizo Hiridus madi susome anite nigino me, Bitrus mazin moroo atii ama soja mare inu tirza ini nyang ini re-re a soja wazin ini nyarga nu me anyimo udenge me. ");
INSERT INTO jni_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sarki urusa, madusa ma iri bibe bikadura ba Asere ugomo Asere madusa ma bezi nice nu me ahira ameme, masa madusa ma poki udenge me, madari Bitrus anikira ma hirza me makuri magu, ''hira dibe-dibe.'' madusa ma iri inyang ya kponko tari tume me. ");
INSERT INTO jni_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Una katuma ka Asere magu me, ''barki uzu usuki akpa taki awe me.'' ''Bitrus madusa ma wu ani bibe be kadura magu ame, suna uguddu aweme, utarsi me.'' ");
INSERT INTO jni_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bitrus matarsi bibe be katuma ka Asere wadusa amatara, madaki rusi imum sa bibe be katuma ka Asere mazin nu wuza ka dumakani ba, ma ciki nani mazen tiro tini. ");
INSERT INTO jni_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Uganiya sa wa aki ani anyerga ni tuba nan ani je, wa ha ana tukum sa abari ani ini ina zomo igibisa aweti hana ani pen, ma puki we ni ini ce nu me, wa suri wa tarsi una udandang, abinime ida ki ma cari uganiya ni ba bibe be kadura Asere wa ceki me. ");
INSERT INTO jni_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Sa iri ba Bitrus ya to-to magu, ''ane ani ma ira ugomo Asere ma tumi ibibe ba Asere bume-me barki bikabi me atari ti Hiridus nan imum bisa ayahudawa wazin inu bassa me.'' ");
INSERT INTO jni_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sa ma rosa anime maha akura a maryamu a'ino ayahaya andesa wa zi unu uyo ume markus; anu tarsa Asere gbardang wa ornu a vat uwe wa wuzi biringara. ");
INSERT INTO jni_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Sa ma gbotiko ana tukumme akura, uriri wa kurame una niza Roda masuni madipoki anatukum. ");
INSERT INTO jni_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sa ma tika ani nigmyirang ni Bitrus. Barki apuru arom madeki marosi upoko ana tukume, barki anime makuri udenge inusom barki mahuri u tide u Bitrus maturi anatukum. ");
INSERT INTO jni_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wagu me, ''wani iranza.'' Manu inki iriba inguna animi ani wagu bibe bi katuma ka Asere bini. ");
INSERT INTO jni_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mw Bitrus ma re aje unu gbotiko, sa wa poki anatukum, wa dusa wa iri me meni, wa dusa wa kunna biyyau. ");
INSERT INTO jni_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitrus ma dusa ma yezewe tari inu guna wa ingara tek, madusa ubezizi uwe tize ti ugomo Asere inu hunkuko ume anyimo magu, ''bukani Yakubu nani vat nihenu imum besa izi.'' Madusa ma cekuwe maha are ahira. ");
INSERT INTO jni_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Uganiya sa ahira asani idaki imum icikilin ini yahiri ba anyimo ama soja ba, barki timumum sa ta hiri nan Bitrus. ");
INSERT INTO jni_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Uganiya sa Hiridus ma nyari me idaki ma kemme ba, ma inki a huwe madusa utuno uhana yahudiya uhana kaisariya wa ze ticukum tume abukome. ");
INSERT INTO jni_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Anami Hiridus ma kunna iriba kang nan nanu taya nanu sidon. Uwatu uwe nigome watiri Bilastasa tari, unu benki ugomo katuma mabenki we, wa nyari ubarka barki we kizi imu yari amanyanga ma meme. ");
INSERT INTO jni_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Uwui me sa a inki Hiridus matari uzu ume atirunga titi gomo ama cukuno azesere upkanku umeme; ma wuzi we tize. ");
INSERT INTO jni_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Anabu wa wuzi ti hunu, ''nigino nigmyirang me na Asere idaki nu nubo ba!'' ");
INSERT INTO jni_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Abini me bibe bi gomo Asere ba vavi me barki sa daki ma nya Asere ni nonzo ba abini me izong yari me madusa ma wii. ");
INSERT INTO jni_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tize ta Asere ta wu buu ta wu gbardang. ");
INSERT INTO jni_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Uganiya sa Barnabas nan shawulu wa mari katuma kawe u urushalima. Wazezi nigo na yahaya unu ge sa ma zi una nyo markus mani. (Barnaba nan shawulu wakuri urushalima). ");
INSERT INTO jni_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anyimo udenge unigura sa wa rani vantakiya, anu ukurzuzo utize nan anu dungura wa rani. We wani Barnabas, saminu (sa a tisa we agenu) nan lukiya Barkurame nan manayin (desa wa hiri nigoo me nan ugomo Hiridus) nan shawulu. ");
INSERT INTO jni_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uganiya sa zin ni nonzo na Asere nan unu canti ikono, abini me bibe bi Asere bi dusa bi gu, ''suso ri mi Barnabas nan shawulu bati katuma me sa ma tit we wa wuzi.'' ");
INSERT INTO jni_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sa nigura me na mara wa wuzi biringira nan u'inta ikoma, wa tari we tari wa gun we dusa. ");
INSERT INTO jni_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Abini me shawulu nan Barnabas wa dusa wa kunna imum sa bibe bi ugomo Asere ba, buki wa dusa uhana usulukiya; wa kafa udusa ani zabu ku kuburus. ");
INSERT INTO jni_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Uganiya sa wa raa anipin ni usalami, wa dunguri tize ti ugomo Asere udenge unigura umayahudawa, waa zin ingoo me nan Yahaya Markus unu benki uwe. ");
INSERT INTO jni_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Sa wa kafa anizabu nu Bafusa, wa dusa wakem ure ubire uyahuadwa una niza Bat Yeshua. ");
INSERT INTO jni_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Unu umakiri nanu desa mazi nigoo me nan unu kkpanku udang me sajus Bulus unu rusa mani. Ma dusa ma titi shawalu nan Barnabas barki maa nyari ma kunna tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Me Elimas ''ubire mani (imum sa nize nime me na buka ini) ma wuzi ni'eru nan we; Ma nyari ma hunze unu kpanku udang nibaba ni'inko iriba. ");
INSERT INTO jni_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Abini me shawulu desa me Bulus maa myinci in bibe ba ASere ma riki me aje. ");
INSERT INTO jni_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ma dusa magu, ''hu vana unu uburi mani, u myinci unu hunzuze abanga nan imum iburi. Hu uruni u'eru uwuza utimum ti riri mani uda kini we umangara uti na tu ugomo Asere ba?'' ");
INSERT INTO jni_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ana me, tari ta Asere be azesere anice ni we me, udi cukuno urubo. Uda ira we uwui ba ana me aku uganiya ku cing, ''Abini me uputuru nan maree wa korso kase unyara anabu sa wadi benki me. ");
INSERT INTO jni_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sa unu kpanku udang ma ira imum be sa ya kem ma dusa ma nya uhem a tize ti ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulus nan aroni ame me wa barka wa dusa wa kafa anyimo ujirgi umei usuro Bafusa uhana Fijiya u bamfiliya. Yahaya maa ceki we ma kuri uhana a urshalima. ");
INSERT INTO jni_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bulus nan aroni ameme wadusa usuro firjiya uhana u'antakiya amanyanga Bisidiya. Abini me wa ribe udenge unigura uni wui Asabar wa cukuno. ");
INSERT INTO jni_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sa amara ubasa i hori i'uinso utize nan anu ukurzizo utize, anu adang udenge ubi gura wa dusa wa tuburko kadura wa gu, ''ni henu, ingi izin kare kadura ka unya uni kara ahira anabu i nya.'' ");
INSERT INTO jni_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulus ma dusa ma hiri ma bezi wen in tari magu, ''shi anu u'isra'ila nan shi andesa iwono Asere, kuna nin. ");
INSERT INTO jni_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ugomo Asere u'israi'la maa zauka acokoro aru, maa kinki ugbardang uweme uganiya me sa rani umasar nan usuro akatuma kadang ka meme maa suso we anyimo me. ");
INSERT INTO jni_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Maa nati iriba nan we uhana tiwe akuri anaze anyimo anija. ");
INSERT INTO jni_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sama mara uhua uti pinping tini usunare a ma nyanga mu kan'ana maa nya acokoro aru ukalu. ");
INSERT INTO jni_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Vat timum tiginome taa kem anyimo ati we akuri anazi unu cibi sa taa aki sa igono me ya aka ugomo maa wuzi u'inko utize nan se sa ya biki uganiya u'aye samaila unu ukurzuzo utize maa ē. ");
INSERT INTO jni_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Anabu wa dusa wa iki wa gu anya we ugomo, ugomo Asere ma nya we saul vana ukish, unu unilem ni Benjamin maa cukuno we ugomo uhana utiwe akuri anazi. ");
INSERT INTO jni_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ugomo Asere maa tuzo me ukpanku utigomo, ma hirza Dauda ma cukuno ugomo uwe. ");
INSERT INTO jni_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Usuro ubisana bi unu ugino me, ugomo Asere maa suso Yeso unu bura, gusi u'inko sa anu inko. ");
INSERT INTO jni_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Igene me ya kem uduku u aye u Yeso u'e, Yahaya ma buu abanga uzurso ukaba utize wa anu Isara'ila. ");
INSERT INTO jni_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sa Yahaya ma mara katuma ka meme, ma dusa magu, ''ibasa mi aveni? Daki mi mani ba. Kunna nin uye ma rani sa ma'eze adumo am de besa in bari in sofi tizin ta kwatak ameme ba. ");
INSERT INTO jni_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ni henu, ahana usuro ubisana bi Ibrahim, nan an desa wa tarsa Asere anyimo ashi me, barki haru wani a nyan duru kadura kubura kageme. ");
INSERT INTO jni_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Barki an desa wa aki anyimo urushalima, nan anu atigomo tiwe me, daki wa rusa me ba, wa kuri wa myinca uboo anu kurzuzo utize ta Asere sa a basa konde uya uwui wa Asabar abanga uhuna ume. ");
INSERT INTO jni_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Vat sa daki wa kem imum besa idi wu wa hume ba, wa dusa iki Bilatus ma hu me. ");
INSERT INTO jni_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sa wa mara me asesere utiti me sa agangirka me, wa soki anyimo icau. ");
INSERT INTO jni_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ugomo Asere ma hirza me usuro iwono. ");
INSERT INTO jni_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Anabu sa wa e nigo me nan me usuro ugalili nan urshalima wa meki uhura ume uhana uti ye gbardang. Anu aginome we wani anu tonno umeme ana me. ");
INSERT INTO jni_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ta ayen shi in utize ti urunta, aban utira utize me sa a wuzi acoro ashime ni. ");
INSERT INTO jni_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ugomo Asere ceki duru utira utize ti ge me. Barki anime ma hirza Yeso usuro icau gusi uzina me sa tizi anyimo uzabura ukure, ''hu vana um mani kani me, ma cukuno acoo aweme kani me.'' ");
INSERT INTO jni_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Imum sa ya kuri iwu ahirza usuro icau ine ini kati nipum nimeme niwici, ma buki ana, ''indi nya shi ure aje u Dauda ulau, tikadura.'' ");
INSERT INTO jni_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ige me ure uzabura, ''be sa ya wuna ma kuri ma buka a ure uzabura, ''uda aki unu lau um wici ba. ");
INSERT INTO jni_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Sa Dauda ma wuzi nirere ni tarsa Asere anyimo iriba ime me nan imum besa ugomo Asere ma unyara, maa wi, avati nigoo me nan acoro ameme, maa wici. ");
INSERT INTO jni_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Desa ugomo Asere maa hirza daki maa iri uwuco ba. ");
INSERT INTO jni_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ni henu, rusani usuro unu ugino me uni, adunguri shi tize ti ugomo Asere barki aperkin in madini mashi me. ");
INSERT INTO jni_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Usuro umeme uni vat desa ma nya nice made kem ubura usuro u'inko utize ti Musa daki ta ceki fong ba. ");
INSERT INTO jni_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Barki anime tarsa nin seke in timum sa anu kurzu utize ta Asere sa waa buki kati myinca ace ashi me. ");
INSERT INTO jni_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Shi anu zatu kunna utize, idi wu hem, i kunna biyau, i kuri imari, barki in zin katuma atiye tishi me, katuma sa ida hem ba, inki uye ma buka shi. ");
INSERT INTO jni_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Usuro wan Bulus nan Barnabas waazigino me, anu wa dusa wa meki utira uwe tari, bati wa kuri wa buu usasana utize tigino me roni Asabar ukuro. ");
INSERT INTO jni_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sa biringira ba mara, mayahudawa gbardang nan an desa wa kabi tize ta mayahudawa wa tarsi bulus nan Barnabas, wa gbarika uguna wa rī aje in katuma ka Asere. ");
INSERT INTO jni_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sa Asabar akuro vat nipin wa gurna bati wa kunna tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sa mayahudawa wa ira nigura na anabu, wa myinca in ni riba ibiit (ni'eru). Wa dusa boo utize tizenzen anice ni tize ti Bulus wa zogizi me. ");
INSERT INTO jni_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bulus nan Barnabas wa wuzi tize in ni iriba ihu wa gu, ''ya wunna uri atubi she wani tize ta Asere shi ya gashi tini ya tuburko ni tini ani kira, ya kurzo ni ace ashi me gusi andesa daki wa bari u kem uvengize uzati umarsa akura Asere ba, kunna nin, tidi gamirka uhana ahira anu zatu urusa Asere.'' ");
INSERT INTO jni_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Barki anime, ugomo Asere ma guna, ''ma wuna we u cukuno masaa ahira andesa wa ta we Asere ba, bati ucukuno una ukem ubura antimo unee vat.'' ");
INSERT INTO jni_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sa anu zatu rusa Asere wa kunna abanga age me, wa wuzi iriba irum, wa nonziko tize ugomo Asere. Maroo ma an de be sa amu inko uguna wa kem uvengize uzatu marsa wa hem. ");
INSERT INTO jni_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tize ti ugomo Asere taa ribe vat anyimo a manyanga me. ");
INSERT INTO jni_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Sa ya cukuno anime, mayahudawa wa dusa wa turi ane age be sa wa wito ace awe atize ta Asere nan anu kaba wan ananu anipin, imum i ge me yaa hunguko ijasi anice ni Bulus nan Barnabas, wa gidi we anyimo a manyanga ma we me. ");
INSERT INTO jni_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bulus nan Barnbas wa dusa wa zamir ususur me sa wa rani atbuna ti we me, ya bezi imum ubasa, wa dusa uhana ikoniya. ");
INSERT INTO jni_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Anu tarsa u Yeso waa myinca ni ni riba irum nan bibe bi lau ba Asere. ");
INSERT INTO jni_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Uganiya sa bulus nan Barnabas waribe anipin ni ikoniya waribe udenge Asere amayahudawa nan hellinawa wa nya uhem. ");
INSERT INTO jni_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ba ayahudawa sa daki wa tarsa ba, waturi anabu wawu muruba inna nu henu me. ");
INSERT INTO jni_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wa ziki uganiya waciki ahirame, innu boo utize sarki ma aye innu bari ugomo Asere, mazin nu bezi utonno ukadura kurunta. Mawuzi aginome usuro u inko ura al'ajibi atari ti bulus nan barnabas. ");
INSERT INTO jni_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Barki anime anani pinme wa harzina; Aye awe watarsi muruba mayahaudawa, aye awe watarsi mamanzani. ");
INSERT INTO jni_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Anabu ani pinme sa ayahudawa wa nyari uhungu ko umuruba manaje aweme, barki wa yomnuko bulus nan barbanas, wa tiziwe. ");
INSERT INTO jni_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sawa rusa anime wa suni uhaza ati pinti likoniya, listra nan udarbe, nan tipin me sa tizi mamu nan we. ");
INSERT INTO jni_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Abirkome wabu tize tu gomo Asere. ");
INSERT INTO jni_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ulistira uye marani da manu mansa utonno inti buna tumeme ba, barki me ugurgu mani dati usuro uyo ume. ");
INSERT INTO jni_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Unu ugino makunna bulus mazin tize. Bulus ma nuki me aje, marusi unu ginome mazin nu hem ugebe sa adi human me. Bama yeze ni myiran magunme, ''hira utonno ati buna tuwome.'' ");
INSERT INTO jni_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ba unume ma hinna, matubi tanu in tibu na tumeme, mazin nu kase. ");
INSERT INTO jni_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sa anu anipin me wa ira imumbe sa Bulus mawuza, wa yeze amyiran awe innu gusa inti likoniyanci, ''makiri mayen duru suro azesere, innu bezi umuhenu manabu. ");
INSERT INTO jni_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","WA tissa barnabas inni zame, ''zafsa,'' bulus watitime inni zame, ''hamisa,'' barki me mani mateki inti ze. ");
INSERT INTO jni_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ba una katuma ka Asere me zafsa desa udenge uni nonzo nume ura ana tukum ani pinme; Ma en ni na inire izatu cina nan ni puriye sa abarki kasi ni ere; Me nan nu ame wa nyara wa witime. ");
INSERT INTO jni_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sa ana kadura, barnabas nan bulus, wa kunna tizeme, wa jani tidibi tuwo me wa muntuno uhana ani ori na nume. ");
INSERT INTO jni_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Wa zin nu gusa, ''kunna ni! shi anabu nya ni ya wuna izinu wuza imum iginome? haru cangi anabu wani kasi shime, ta aye shin intize turunta tini, in nu guna, cekini timumum me sa tida rizeme ba kuro ni ahira Asere uvengize, agesa abara asesere nan na dizi nan nu raba udang nan timumum me sa vat tira anyimo uni. ");
INSERT INTO jni_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","In nu dadati ma ceki anu wa wuzi in umbe sa wa ira. ");
INSERT INTO jni_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Vat in anime, daki ma ceki nice nume sarki imumu u inko u ira ba, barki ma nyin za timumum tiriri, ma nyin ure, uganiya uringirka wa myinca amuriba mushime nan ni mumare nan na puru arum. ");
INSERT INTO jni_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Vat inna guran aginome, bulus nan barnabas wa rusi utura ume usuro u we u wito. ");
INSERT INTO jni_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Vat ayahudawa u antakiya nan aye awe a ikoniya wahunguko muruba muni orime. Watizi bulus wahungukome uhana amatara mani pinme, wahiri kasi mawono. ");
INSERT INTO jni_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Vatin anime sa anu tarsa uYeso watonzino wakatime, sama hiri anyimo ani pin. Usana hira utaru nigome nan barnba. ");
INSERT INTO jni_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sa wa wuza tizeme ani pin nigino me wa kem anu tarsa UYeso gbardang waze u suro ulistira, nan nu ikoniya nan antakiya. ");
INSERT INTO jni_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Waz in nu nonsi umuruba manu tarsa u Yeso wa inta uhem uweme, aca ware je in uni wazin nu gusa we, ''ahira utonno memmerum tidi ribe ati gomo ta sesere, barkani me ya cukuno gbas tisi jas.'' ");
INSERT INTO jni_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","sa wa zaukawe anaje akoya udenge Asere, ba wa wuziwe biringara nan niwe ni mei, wa witi we atari tu gomo Asere, uhanan desa wa hem in ine. ");
INSERT INTO jni_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Waha watrsi ubisidiya wabiki ubamfiliya. ");
INSERT INTO jni_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","sawa wuza tize tuwe u biriya wa aki uhana u italiya. ");
INSERT INTO jni_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Uzirgi umei uhana u antakiya abine ani a witi imum iriri ya Asere barki sa wamara aname. ");
INSERT INTO jni_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sa wabiki u antakiya wa ori amu udenge Asere me ahira a inde, wabu kuwe vat imumbe sa Asere awuza usuro u we. Nan gusibe saa poko ana tukum ahira anu zatu urusa utize ta Asere uhana uhme. ");
INSERT INTO jni_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wa cukuno nigome nan anu tarsa U Yeso u zika uganiya jokon. ");
INSERT INTO jni_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Aye sa wa suri Uyahudiya wa e Uantakiya, unu bezizi anu tarsa Asere agi ingi daki agbara anu kasi ubuka utanda u Musa unu mada kem me ubura wasere ba. ");
INSERT INTO jni_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Barki u gbardang umataran a tuburko Bulus, Barnabas nan aye wa haa Ujarusalem ahira adura nan ananu anu tarsa Asere. ");
INSERT INTO jni_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anu tarsa Asere wa ka tibi we, wa tarsinFinikiya nan Usamariya wa aki wa buu abanga an desa wa zo we Mayahudawa sa wa kabi tize ta Asere, mu ruba manu tarsa Asere mu rum. ");
INSERT INTO jni_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sawa aye Ujarusalem wa kurzo vat ti mum me sa Asere awuza in we, ana kadura kasere, ananu nan anu tarsa Asere wa issi we unu aye. ");
INSERT INTO jni_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Aye anyimo Amafarisiyawa wa tonno wa gu,” ya cukuno gbas ande sa wa zo we Mayahudawa agbari we”. Wa kuri wa tarsi tize ti Musa. ");
INSERT INTO jni_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ana kadura kasere nan annu wa cukuno wa gamiri tizee me. ");
INSERT INTO jni_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Anyimo ugamara utizee me Bitrus m hiri ma tonno ma gun wee,”Anuhenu in rusa dadatti Ugomo Asere ma zaukam unu guna ande sa wa zoo we Mayahudawa wadi kunna tize tasere anyo am wa kabi tini “. ");
INSERT INTO jni_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Asere sa arusa iruba ikonde vi, ma kaba we madi nya we bibe biriri kasi haru me”. ");
INSERT INTO jni_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Daki ma harzinan duru nan wee, ma wuna mu ruba muweme lau, nanu inko iruba. ");
INSERT INTO jni_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Barki ani me, nyani ya wuna i nyara ibati Asere, unu cira udangdang sa uteki ni kara na coo nan haru, i cani anu tarsa Uyesu. I rusa barki ugomo Asere sa Yesu maninta kem uburaa kasi we me. ");
INSERT INTO jni_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Irusa barki ugomo Asere sa Yesu mani ta kem uburaa kasi we me. ");
INSERT INTO jni_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Vat ni gura nanu me ni cukuno tik unu me ni cukuno tik unu kunna Ubarnabas nan Bulus, in nu boo ti mum tibi yau sa Ugomo Asere ma wuza ahiran de sa wa zo we Mayahudawa. ");
INSERT INTO jni_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sa wa mara tizee Yakubu ma gu “nihenu kunnan me”. ");
INSERT INTO jni_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon ma tubi u boo uhem me sa Asere awuzi an desa wa zo we Mayahudawa unu tuba, barki niza nimeme. ");
INSERT INTO jni_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tizee me ta wuna rep nan tanu kurzozo utize ta sere. ");
INSERT INTO jni_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Indi kuri uzee in kurzo ani kasi utuba me. ");
INSERT INTO jni_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Batti ukasu wasu wannu upata ande sa wa zoo we Mayahudawa wa kabi Yesu. ");
INSERT INTO jni_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","U buka ugomo Asere wazigino me sa ma buki datti. ");
INSERT INTO jni_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","U iraa um wazigenne me, ande sa wa kati a bussur we. ");
INSERT INTO jni_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Caa ti nyertike wen unu guna kati wa ree imum yare ima kiri nan inama sa daki aweki wan mayee. ");
INSERT INTO jni_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","I rusa ati wee tu datti sa ta agiza u cara sassas ati pinpin sassas anyimo ati denge tinigura wa wuza katuma in tizee ti Musa vat uwui uvenke wa asabar. ");
INSERT INTO jni_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ya wuu are ana kadura kasere nan nanu vat na anu tarsa Asere wa zauka Yahuda, Barnabas nan Silas wa tono we U think antakiya upata Bulus nan Barnabas. ");
INSERT INTO jni_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wa nyertike kadura kani iss ahira anu henu uwe ande sa inzo Ayahudawa, sa wa rani Uantakiya, Suriya nan Kilikiya. ");
INSERT INTO jni_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ta kunna agi aye anyimo aruu wa suro sarki urusa uroo in tire tize sa wazin unu carsa ushi murubani. ");
INSERT INTO jni_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Barki ani me ta ira ya wuna urii ti tummi aye upata u Bulus nan Barnabas ahirabashi me. ");
INSERT INTO jni_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","An desa wa nya ace awe barki katuma ku ugomo Asere Yesu kristi. ");
INSERT INTO jni_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ta kuru ta tuma Yahuda nan Silas wa e wa buki shi imum i' inde me. ");
INSERT INTO jni_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bibe bi ugomo Asere nan haru ta iraa ya wuna urii kati acani shi imum sa idi aki ni kara nishi. ");
INSERT INTO jni_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kati irii nan isii imum be sa barka barki makiri, kati iri binama sa daki aweki bini, kati irii maye. ");
INSERT INTO jni_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wa dusa uhana Uantakiya wa ori anu tarsa Asere wa nya we kadura me. ");
INSERT INTO jni_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Sa wa kunna kadura me wa wuu mu ruba mu rum. ");
INSERT INTO jni_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuda nan Silas wa nya we tizee sa tidi kinki we akara amuruba. ");
INSERT INTO jni_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sa wa wuna tiye nan we wa kuri in na puru arum uka kem ande sa wa tuma we. ");
INSERT INTO jni_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas ma iri ya wuna me uri ma cukuno nan we. ");
INSERT INTO jni_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bulus nan Barnabas wa tonno u Antakiya nan aye gbardang wa ri aje anu boo anu tize tu ugomo Asere ");
INSERT INTO jni_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sa wa wuna tiye, Bulus ma gun Banabas caa ti tarsi anu me sa ta bezi we tizee tasere ti iri nyanini wa rani anyimo me. ");
INSERT INTO jni_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ma nyari uguna wada dusa me nan Yohana desa atisa me Markus. ");
INSERT INTO jni_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bulus magu “ida rizi me ti dusa nan Markus sa maa ceki during u Familiya daki ma ree aje nan haru”. ");
INSERT INTO jni_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Matara acee awe me wa harzina, Banabas ma ziki Markus wa dusa u hana Sayifurus. ");
INSERT INTO jni_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Sa anu tarsa Asere wa wuna we birigara, Bulus ma ziki Silas wa dusa. ");
INSERT INTO jni_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ma tarsi Suriya nan kilikiya unu kingizi anu tarsa Asere nikara. ");
INSERT INTO jni_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus ma haa u darbe nan nu listira, ure unu tarsa u Yeso ani pin nu Listira, una ni zaa Timoti a ino mee u caa Yahudawa, a choo me ubaleleni. ");
INSERT INTO jni_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Anu tarsa Asere sa waa rani u listira nan Ikoniya wa nanziko Timoti kang. ");
INSERT INTO jni_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ma nyari udusa nan Timoti, ma gbari me bati ma Yahudawa me sa waa raniu abini me wa rusi uguna aco me ma zee uba Heleni mani. ");
INSERT INTO jni_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Uganiya me sa Bulus na Silas wa zin unu tarsa uti pinpin wa haki wa boo anu timum sa ana ka dura ka Asere, ananu nan anu tarsa Asere u Jerusalem wa hem wadi tarsi tini. ");
INSERT INTO jni_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ani me anu tarsa Asere wa kinki ni kara amu riba muweme wa kini wa kinki u gbardang. ");
INSERT INTO jni_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus nan aroni atanu tumeme wa tarsi Firijiya nan u Galantiya, wa gaa me uribi u Asiya barki sa bibe biririn ba sere baa karti wee u hanan inti zee ta sere abini mee. ");
INSERT INTO jni_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sa wa aye mamu umisiya wa nyari uribe ubitiniya bibee bi Yeso bi karti wee. ");
INSERT INTO jni_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Sa wa tarsa nikira nima nyanga mu misiya wa tuu hana Turuwas. ");
INSERT INTO jni_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bulus ma wuzi tiroo in niye, agi ure unanu makiduniya ma aye ma aye mazin unu gusa umee, aye a Makiduiya ubenkin dura. ");
INSERT INTO jni_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sa Bulus ma maratiroo tiginome wa dusa, wa hira uhana a Makiduniya unu guna Asere; a guna wa ka bezi we kadura kurunta ka sere. ");
INSERT INTO jni_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","An Bulus wa cheki u Toruwas u hana samotiras, rono unu kure wa haa u Niyafolis. ");
INSERT INTO jni_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","A bini me wa aki u hana u Filipi, ni pin ni dandang ni Makiduniya an de sa waa raa tari tanu aRumawa. ");
INSERT INTO jni_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Unnu wui wa sabath ti suri ana tukum ani pin ti haa uraba nan tidi kem udenge ubiringara ti cukuno ti wuzi tizee wana nee sa wa gurna a hira mee. ");
INSERT INTO jni_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uru nee unu tarsa Asere una ni za Lidiya, uca wanu Tiyatira unu zika uti runga ti kirfi wandang unu kunna uru, Ugomo Asere ma pakki iribi ime mee makuna imum mee sa Bulus mazin unu boo mee. ");
INSERT INTO jni_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sa a Zorome nan ana kurameme ma gun hanu kussi, ingi ya heem guna mi kadundura ma heem in Ugomo Asere aye tarni a kura am, ma rigizan dura ti heem. ");
INSERT INTO jni_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uru wui ti hazi ahira abiringara ti gurna nan kure kubura sa mazin na gbergene ma wuza ni bere, anu henume wa kenzi ikirfi kang a hira ani bere numeme. ");
INSERT INTO jni_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Unee u geme ma tarsa Bulus nan haru, in ni myiran in na sesere unu gusa “Anu ageme areree Asere adandang ani sa wa bezizi una unu bussi. ");
INSERT INTO jni_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ma ziki tiye gbardang unu boo me, Bulus makunna iriban in me kang, ma gun in bibee mee “A nyumo ani zaa ni Yeso kirati suro anyuma ame” bi dusa bi suri. ");
INSERT INTO jni_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sa anu henu me wa ira unaa wa ree uweme wa korso ni pum wa meki Bulus na Silas wa hanwe nyumo a hira a bizizaziza, wa witi we atar tanu gunguzuno uti zee. ");
INSERT INTO jni_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Sa wa hanan we ahira unuyoro utize wa gun me “Anu ageme a Yahudawa wazin nubungmurko uru nipin. ");
INSERT INTO jni_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wa zin nu boo uru timum tige sa ti sassas nan tunu Romawa agi ti kabi. ");
INSERT INTO jni_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A nabu wa dusa wa murna we, anu yoro utizee me, wa jani we tirunga wa cekiwe nyenperen, wa gu a cobiwe. ");
INSERT INTO jni_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sa wa tirawe kang, wa tuburko we aka korso, wa gun anu hira ande sa a korso we, wa hiriwe memerun. ");
INSERT INTO jni_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Unu me ma sokki we udange una nyumo, ma duku tirzizi we ma kunti ati buna. ");
INSERT INTO jni_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","In na taaniye Bulus nan silas wa zin biringara nan ire ya sere, u kasu wanna uwe. ");
INSERT INTO jni_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ara anyumo ani me, uzuruko wadizi udandang u eh, ni tin na soo udenge me sa wa rani; ni zuruko tina tukkum me vat ti pagkino dibedibee, vat inyang me sa atirziza anu me isopso. ");
INSERT INTO jni_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Unu bee uweme sa ma zuma a moro ma iri tina tukum me kang ma gussi nan anume wa susso ma ziki uvira agi madi weki nicee numemen. ");
INSERT INTO jni_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bulus ma tussan me in nimyirang ni dandang, ma gun “Kati u kunno nicee nuwe iwono vat uru ti rani. ");
INSERT INTO jni_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Unu beh uweme ma gu ca a ehn ima saa, ma wuu dibedibe ma ribe anyumo maka rizo aje an Bulus nan Silas inbi yau. ");
INSERT INTO jni_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","A suru we a matara magu “Unu dang nyanini indi wuzi bati a burum”. ");
INSERT INTO jni_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wa gun me “Kaba Ugomo Asere Yeso adi buru we huu nan a kura wee”. ");
INSERT INTO jni_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wa bezi me tize tu Ogomo Asere vat uwe akura me. ");
INSERT INTO jni_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A nyumo uganiya ugunome inniye unu bee akura ukorsuzo anu me, ma ziki we ma kpiji we ti nuru me, vat ume nan ana kura ameme azoro we. ");
INSERT INTO jni_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ma ziki Bulus nan Silas ma henwe akura ameme, ma nya we imum yare ma wuzi ire kang nan ana kura amemebarki sa wa kaba Asere. ");
INSERT INTO jni_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sa ahira a sana ma gun ana katuma me “Cekini unu agino me wa dusa”. ");
INSERT INTO jni_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ma kurzo Bulus tize me agi “Unu dang uru ma nya kudura agi a ceki shi idusa: barki anime suroni dusa a huma”. ");
INSERT INTO jni_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bulus ma gun we “Ina tiran duru anyumo ana buu, haru anu Romawa sahiki iko uru, wa ka kurson duru; ane ani wa nyara wa suson duru nihunzii, ta gaan duru; ca wa e in na ce awe wa susonduru. ");
INSERT INTO jni_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wa kuri wa ka buka kadura me ana dang me wa kunna biyau sa a gunan we Bulus nan Silas anu Romawa wani. ");
INSERT INTO jni_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Unu wessi utizee me ma gun wa wuu muriba mu shew, sa ma suso we ma gun Bulus nan Silas wa ceki ni pin me. ");
INSERT INTO jni_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bulus nan Silas wa suri wa akura a Lidiya. Sa Bulus nan Silas wa ira aroni me wa nya we tize tu natta umuriba wa suri wa dusa. ");
INSERT INTO jni_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anyimo atanu ti we me wa tarsi una u Amfibolis nan Aboloniya uhana ani pin ni utasalonika a hira sa udenge unigura na Yahudawa. ");
INSERT INTO jni_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus, gusi imum me sa ma harika uwuza me ma kem we waziki ti auto ta asabar ti taru uni gunguzino tize ta Asere nigo me. ");
INSERT INTO jni_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Sa mazi unu dungura uwe tize ti ugomo Asere unu bezi uwe abanga a vana ugomo Asere ini ijasi nan iwono me sa idi kem me, magun we Yesu ugeme sa inzini u boo shi me, me mani unu dang me. ");
INSERT INTO jni_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sa wa kunna tize me, are ayahudawa wa dusa wa kabi tini, wa kuri ani kira ni Bulus nan Silas nan ni'ori na Ahelinawa ana katuma ka Asere wa ane adangdang. ");
INSERT INTO jni_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Abini me anu zatu tarsa Asere Ayahudawa wa kunna ni'eru amu ruba wa dusa ha wa tita aye anu dire ace wa ori anu gbardang wa hem wadi shagilka ni pin me; wadi muruba ma nu, abini me wa ribe akura a Jason, wa nyari asuso we Bulus nan Silas. ");
INSERT INTO jni_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sa wa ribe daki wa ira a Bulus me ni ba, wa dusa waki Jason nan are anuhenu wa han we aje ati gomo wa gu “anu ageme wani wa cara ticukum tiru me, wa cara timumum kan. ");
INSERT INTO jni_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Anu ageme sa Jason ma kaba wa cara cara tize me sa kaisar ma inki wa gusa ure ugomo ma kuri marani sa a tisa me Yesu. ");
INSERT INTO jni_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sa ni'ori na nabu nan anu adangdang anipin wa kunna mu ruba. ");
INSERT INTO jni_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Adusa ari Jason ikirfi, barki imum me sa ma wuza, wadi ku ceki me ma dusa. ");
INSERT INTO jni_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sa niye na euna nihenu ni ntuburko Bulus nan Silas ubiriya, sa wa biki abini me, wa ha udenge unigura wa Ayahudawa. ");
INSERT INTO jni_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abini me anu me wa bezi uruba iti nanu wa teki an desa wa ra Utasalonikawa, wa kabi tize me in tari ti re, wa gunguzuno tini konde uya uwui bati wa rusi ti mum me ti ra a ynimo tize me. ");
INSERT INTO jni_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abini me maro ma nu me wa kabi tize ti ugomo Asere nan anu adang wa Heniyawa ahana arum nan ahana a e. ");
INSERT INTO jni_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sa a yahudawa Utasalonika wa kunna Bulus ma zini uwuza tize ta Asere a Ubiriya wa ha wa ka samirka ni'ori na nume. ");
INSERT INTO jni_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nihenu anu tarsa Asere wa dusa wa tuburko Bulus uhana uraba udang; wadi ku ceki Silas nan Timoti abini me ");
INSERT INTO jni_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15",". Andesa wa bezi Bulus una me waka tibi piit uhana Antina. Wadi ku zen in kadura ka Bulus wa nya Silas nan Timoti. Kadura ka gu wa ha dibe. ");
INSERT INTO jni_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sa Bulus mazin unu be uwe Utina iruba imeme ya corno sa ma ira anu unu tarsa umakiri. ");
INSERT INTO jni_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","konda umaya wake wa wuzi matara nan Ayahudawa udenge uni gura na hana Asere nan anu me sa ahira abipkija kpija ");
INSERT INTO jni_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Are Abikuriya nan sitokiya anu poko aje wa dusa wa hiri wa tonno ani ce ni Bulus. Unu igizo nyanini unu ipirkan igeme mazini ubo me? Aye unu gusa, aye unu gusa mazini bo utize anice ni mare makiri unu tisa niza ni Yesu nan uhira amu cau. ");
INSERT INTO jni_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wadusa wa ziki wa han me ani po ni Urasa wa iki me uya udungura usso uni mazini? ");
INSERT INTO jni_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wagu “ta ira wa aye intire tize tisso atitui tiru sa daki ta mu kunna tini. Barki ani me ti nyara ti rusi tini ti gusa nyanini? ");
INSERT INTO jni_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ta ira Antaniya nan agenu aweme wa huza uganiya uweme unu kunna tize tisso. ");
INSERT INTO jni_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ba Bulus ma dusa ma tonno ani po ni urasa magu”ma ira usassana una me sa itarsa agi itarsa Asere. “ ");
INSERT INTO jni_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ma iri imum me sa itarsa, in kuri in iri ahira sa i nonzizo makiri mashi me sa ya nyertike ani ce na Asere sa ada rusa ni ba”nyanini ya wuna i haka amare ma buka shi imum igeme. ");
INSERT INTO jni_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ugomo Asere madi sa ma barka Asere nan adizi nan utimumun sa first anyimo meme, mada ciki me udenge sa a barka Ontari ba. ");
INSERT INTO jni_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ada nonzo me Asere in tari tu nu ba, gusi ma nyari iri mum, sa me mani ma nyiza anu nihuma, bivai nan ukasu utimumum me. ");
INSERT INTO jni_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Usuro unu u'inde ma barka anu sa wa ra une ugeme sa a nya we ibinani nan uganiya barki ticukum ti nu. ");
INSERT INTO jni_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ca anu wa nyari ugomo Asere wadi kem me. ");
INSERT INTO jni_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Anyimo ameme ani ti cikini ti kenzi nihuma, gusi ure uni gyerte ira ishi me ma buki” haru anu abisana ameme wani”. ");
INSERT INTO jni_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ucukuno uru bisana bi ugomo Asere kati gusi ugomo Asere mazi gusi nipo, nani are asiba unu. ");
INSERT INTO jni_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ugomo Asere mada bassa timumum sa uganiya uzatu rusa utize ta Asere. Barki ani me mamu inko uwui sa madi inki une aje ameme, konde vi ma nya timumum me sa ma wuza. ");
INSERT INTO jni_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Usuro unu me zauka, Asere ma nya unu ugeme bati ma bezi unu ugeme ahira uhirza usur icau. ");
INSERT INTO jni_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sa anu Antaniya wa kunna abanga uhira inki unu ma wono, aye wa zuzi Bulus aye wagu “tidi kuri ti kunna abanga ageme”. ");
INSERT INTO jni_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Sa a mara Bulus ma ceki a bini me. ");
INSERT INTO jni_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Aye wa kabi tize tasere wa tarsi me, gusi Diyonisiyas una aka tuma, Arasa nan ure une una niza ni Damarisa nan unu kasu. ");
INSERT INTO jni_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bulus ma dusa ceki Antaniya ma dusa Ukorintiyawa. ");
INSERT INTO jni_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A bi ne ani maa gurna nan ure u Yahudawa una niza ni Kila unu watu Fantasmani, sa ma hazi usuro Italiya nan une umeme Biriskala barki Kalaudiyas magu agi di a Yahudawa wa ceki u Roma wa dusa wa gurna nan Bulus. ");
INSERT INTO jni_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wa dusa wa cukuno wa uzi katuma nigo me barki katuma ka we me ka inde kani anu duza udanga. ");
INSERT INTO jni_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bulus ko uya uwui wa Asabar ma ke ma ka wuza matara nan a Yahudawa nan anu taa me utize ta Asere anyimo udenge Asere. ");
INSERT INTO jni_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas nan Timoti wa eh wa kem me usuro u Makidoniya, bibe bu Ugomo Asere bi dari Bulus ma buki a Yahudawa Yesu mani unu bura anu. ");
INSERT INTO jni_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Sa a Yahudawa a geme wa zogizi me, Bulus ma suso udibi u meme ma zarika we ni ma gu we makara ugogoni um anice nishi me adi iki maye ma shi me anice nishi me, ida zo mini ba, indi ceki aba me in dusa ahira an de sa wada rusa me Asere ba. ");
INSERT INTO jni_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ma dusa maka tuno a Titus Yusta de sa ma tarsi Ugomo Asere. Akura a meme ara upuru udenge uni gura na hanna Asere. ");
INSERT INTO jni_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Karibus unu dang u denge uni gura nan anu a kura a meme wa kabi Ugomo Asere. maro manu korintiyawa sa wa kunna Bulus wa hem nana Aserer adusa uzaro. ");
INSERT INTO jni_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ugomo Asere mawuza tize nan Bulus iniye anyimo atiroo ma gun me”kati ukunna biyau ba, buka we katu wuu tik ba. ");
INSERT INTO jni_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Barki in zi nu gome nan hu uye mabari ma kunna we iwono ba, inzin nan huu anyimo anipin nigeme. ");
INSERT INTO jni_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus ma cukuno abini me ma biki ni we ni inde nan ti peyu utasi unu bezizi we tize ta Aserer. ");
INSERT INTO jni_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sa Galiyo ma cukuno anu ukpanku unu dang Umanyaga mu Acaya, Ayahudawa wa dusa utonno Bulus ani ce, wa ziki me wa hanni aje ati Gomo. ");
INSERT INTO jni_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wa gu unu ugeme me zini hungo umu ruba ma nu wa re Asere sas sa wada rusa me ba. ");
INSERT INTO jni_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Sa bulus ma hira u buka utize Galiyo ma dusa ma poki anyo magu shi a Yahudawa in daki ma wuza iri imum i zenzen nan imum sa idi rizi nu ba, i da pirkem ba. ");
INSERT INTO jni_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Imum me ya cukuno a banga u inko ace ani gura nan nniza, hana i ka barkani ace a shi me. i da nyara in cukuno unu barka abanga atize ti geme ba. ");
INSERT INTO jni_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiyo ma gidi we ceki ahira ati Gomo me. ");
INSERT INTO jni_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wa dusa wa meki Sastanisu, nun dang anyimo udenge unigura wa tiri aje ugomo Galiyo ma gume u, inko iriba iwe me ahira inde. ");
INSERT INTO jni_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Sa Bulus ma wuna tiye gwardan ahira me ma ceki ni henu me abini mewa dusa u zirigi umei nan Briskila wan Akila uhana u siriya ma tu u Kankiriya anikira nu raba u dand ma wuzi utanu bati ma myinca tize me sa ma mu inko. ");
INSERT INTO jni_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sa wa aye u Afisawa, ma ceki Briskila abini me, ma ha udenge uni gura wa hana Asere unu igizo utize ta sere me nan a Yahudawa. ");
INSERT INTO jni_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wa dusa wa iki Bulus ma kinki tiye, ba ma game. ");
INSERT INTO jni_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma gu we inga Asere a hem in di kuri inze abame, madiku dusa. ");
INSERT INTO jni_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sa bulus ma biki u Kaseriya ma biki iso anu tarsa Asere a Urushalima ma aki u hana u Antakiya. ");
INSERT INTO jni_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Sa bulus ma zika tiye abini me ma dusa ma meki una uhana u Galantiyawa nan u Farija ma nya anu tarsa u Yesu ni kara ni ria. ");
INSERT INTO jni_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","U re u Yahudawa una niza Apolos sa ma ra u Iskandariya ma eh u Afisa. unu mani ma rusa tize nan tize tu Ugomo Aser. ");
INSERT INTO jni_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolos sa ma kem urusa a nyimo tize ti Ugomo Asere, mazi unu nyara uni ce, unu beizi utize ta Asere, imum me sa ma teki unu rusa ine ini abanga u zorso u yohana ");
INSERT INTO jni_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26",". A polos ma tubi u bezizi Ugomo Asere ini riba ihu, sa Briskila nan Akila wa kunna mee, wa dusa wa cukuno aroni, wa bezi tize ta Asere me meru. ");
INSERT INTO jni_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sa ma barka u dusa ma aki u Akaya ni henu nuru ni dusa ni nyitike u takarda uhana a hira anu tarsa Asere, a dusa a kabi in tari ti re. ");
INSERT INTO jni_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos ma dusa ma bezi Ayahudawa ni kara nan nu rusa u meme gusi tize ta Asere ta buki, Yesu mani unu dang. ");
INSERT INTO jni_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sa Afolos ma raa anyimo ukurinti, Bulus ma kase ani pin zalang uhana ani oin nu Afisa, abibime ma kem aye anu tarsa ume. ");
INSERT INTO jni_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Bukus magun we, ''nani ya kaba bi be biriri uganiya sa nya kadure?'' wa kabirka, ''da tamu kunna abanga abi be biriri ba.'' ");
INSERT INTO jni_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulus magun, ''nya uzurro uni awuzi shi?'' wagun me, ''uzuro uyahaya'' ");
INSERT INTO jni_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus ma kabrki magu, ''yahaya ma zurso anu in na banga u kaba Asere, magu wa nya mu ribe desa madi ē aduumo am, desa agusa me Yeso.'' ");
INSERT INTO jni_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sa anu wa kunna anime, adusa azurso we anyimo aniza ni Yeso. ");
INSERT INTO jni_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Uganiya sa Bulus ma tara we tari, bi be biriri bi tu awe wa boo tizze ina nymiran asessas nan uboo imum besa i eze aje. ");
INSERT INTO jni_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wazi anu ukirau in ware. ");
INSERT INTO jni_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus ma ribe udenge Asere unu dungara anu sarki biyau uhana ti pe ti taru, mazi utarsa ina anu sa wadi tinka me wa nya mu riba ini mum besa izi ati gomo ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Barki mare mayahudawa sa zi gbas, wa gawe u tarsa utizi me, wa tubi ucara uti naa ti Yeso aje anu. Barki anime bulus ma hunguko nice nume nan andesa wa zi nan me anu uhem. Ma tupi udungara a makaranta ma tiranus. ");
INSERT INTO jni_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mari aje anime uhana atiwe tire vat adesa wa ciki anyimo Asiya wa kunna tizze ta Asere, ma yahudawa nan mahelenawa. ");
INSERT INTO jni_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Asere ma wuzi timum ti ririn ti unya biyau a tarti bulus. ");
INSERT INTO jni_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Anu ti koni wa hunza, agbergene wa susi anyimo anu, uganiya sa wa kabsi mu tira nan ma gbeptu ahira a bulus. ");
INSERT INTO jni_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mare mayahudawa wa rani a bare wa tarsi matara, wa ziki ace aweme agi uwadi wuzi katuma in niza ni Yeso, ''wagu ta gunan shi a nyimo niza ni bukus sa madungara tini, surono.'' ");
INSERT INTO jni_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","An desa wa wuzi anime anu usunare wani ahana unu udang ukatuma ka asere uyahudawa na zame siba. ");
INSERT INTO jni_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bibe bizenzen sa ma kabirka magu, in rusa Yeso, in rusa bulus, shi aka veni?'' ");
INSERT INTO jni_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ba bebi bizenzen sa bi raa anyimo unu me bi garte abe reme ma teki nikara nuwe ma tire we. Wa aki unu sum wa suri udenge nuwe yeyen peren unu sara ati hi hira. ");
INSERT INTO jni_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Anu tarsa gbardang, wa e wa boo timumum ti buri sa wa wuzi. ");
INSERT INTO jni_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Abere wa ezin matagarda maweme wa punzi aje anu, abasa imum be sa wazini ya biki ma dubu akuri ucibi nan azumo a walwal. ");
INSERT INTO jni_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tize ta Asere ta samirka in ni kara ati naa gbardang. ");
INSERT INTO jni_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sa bulus ma maraa katuma ku wuzi tize ta Asere u afisa, bibe bi tarsi in me uhana umaki doniya nan akiya unaa uhana a urushalima tace, ''ingi ma hana abini me, indi haa uroma.'' ");
INSERT INTO jni_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bukus matumi anu tarsa umeme ana ware timoti nan irastus uhana umaki doniya, adesa wa benki me. Me ince nume ma be a Asita uhana aku ganiya cin. ");
INSERT INTO jni_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Uganiya uginome awuzi uhirza iriba idanga afisa barki unaa uginome. ");
INSERT INTO jni_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uye unu zunzume ni zame Damatrayus desa ma zumo makiri ma zumo abalbal ma dayana, desa katuma ka gino me ini ikirfi gbardang. ");
INSERT INTO jni_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ma urso anu zunzume magun we, ''irusa unu unaa ugino uni kenzi ikirfi gbardang . ");
INSERT INTO jni_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ya ira ya kunna agi, dasi u afisawa cas ba, vat u pash unipin ni asiya bulus ugeme ma ranga we. Ma gusa we agi ada barame Asere in tari ba. ");
INSERT INTO jni_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Katuma tari aru cas kadi ziti ba, nan udenge Asere aruma danyana udang madi cukuno sarki katuma. A'anime madi diri ni kara numeme, me nan vat nipin ni asiya sa une u wuza me ninonza. ");
INSERT INTO jni_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sa wa kunna anime wa kunna iriba, wa titi ini kara wagu, ''une udang mani Dayana u afisa.'' ");
INSERT INTO jni_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nioin ni curnome, anu wa hiri debe uhana ahira ani ori. Uganiya ugino me, wa mu miki aroni atanu ti bulus, wato Gayus nan Aristakus adesa wa ē usuru u makidoniya. ");
INSERT INTO jni_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus ma nya nice ma ribi anyimo anigura me, anu utara umeme wa karti me. ");
INSERT INTO jni_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ane ani cangi are aroni a Bulus sa wazi anu adang ati kira ta anu asiya wa tuni me uni iko unio kara kati ma ribe anyimo ani ori me ba. ");
INSERT INTO jni_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Are anu wa zinu tira igiri ahira ire imum, sas barki mu riba ma anu mu hirsa. Gbardang anyimo aweme da wa rusi wa ornu barki nyanini ba. ");
INSERT INTO jni_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mayahudawa wa turi iskandari aje ani gora na anu, iskandari ma witi tari tume aseseri barki ma buki nigora tizze. ");
INSERT INTO jni_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Sa wa tinka me uyahudawa mani, vat uwe wa wu uhunu uhana uma awe ma ree, ''unu dang mani dayana u afisa.'' ");
INSERT INTO jni_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Sa unu yettike unipin ma gbarikawe ma si nice nuwe, magu, ''shi anu afisa, aveni mada rusa me nipin nu afisa nini ni ubu na Asere nan dayana, unu udang nan u hurtu ugebesa sa wa rizi usuro aseseri? ");
INSERT INTO jni_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Da aguna imum igino me macico mani ba, ingara ni tik kati iwuzi ire imum yak-yak. ");
INSERT INTO jni_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ya aye ni anu aginome, anyimo udenge u weki utize da agi we akeri udenge Asere wani ba nani adesa wa buka aburi ahira Asere aru ba. ");
INSERT INTO jni_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Barki anime ingi Damatrayus nan unu uzunzume sa wa zina nan barki tire tizze ahira uye, ti denge ti wasi utizze ti zi fong anu wesi utizze wa rani. Na wa han we inace awe. ");
INSERT INTO jni_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ingi tizze ti ugunkuno ti rani, adi barka we ani gora nuru uganiya-uganiya. ");
INSERT INTO jni_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Barki ti raa anyimo ana ye ma bit barki uhirza umu riba mu kani me. Tizo duru ini mum me sa ya hirza mu riba ma anu ti kuri ti zon duru ini mumu ibuka aseseri imum ba. ");
INSERT INTO jni_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sa ma buka anime, ma samirka nigora me. ");
INSERT INTO jni_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Sa ahira atoto, bulus ma tumi aka titi anu tarsa umeme, ma nyizi we tize madu wu we usa mura, ma hiri madi dusa umakidoniya. ");
INSERT INTO jni_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Sa ma wata ati hi hira mazunu wuza anu tarsa tize kang, manno ma eh anipin na telenawa. ");
INSERT INTO jni_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sa ma wuna tipe ti taru ahira me, ayahudawa wanno wa wuzi me malin, uganiya sa ma nyari unyene uzirgi uhana usuriya, manno ma saki ugunku ma kuri umakidoniya. ");
INSERT INTO jni_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Anu uka tibi ubulus uhana amanyanga mu asiya wa zina sabatarus vana uburu usuru u biriya, Gayus una nu derbe; Timoti na aristakus nan sakundus, vat uwe anu tarsa Asere wani anipin tasalonika, nan tikkus nan trofimus anipin nu asiya. ");
INSERT INTO jni_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Barki anime aye wa agizan duru, wa ka benduru utaruwasa. ");
INSERT INTO jni_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sa ta ribe uzirigi usuro ufilibi tiye ti tu biredi uzatu imumu buzo, tiye ti nu cibi ta aki tiduku biki we utaruwasa, tiye turu usunare ahira me. ");
INSERT INTO jni_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Uwui utuba atiye usunare, sa ta orno barki upura ubiredi. Bulus ma bezi anu tarsa Asere tize, barki ma nyara ma dusa unu sana hira; tize tumeme ta biki ati aniye. ");
INSERT INTO jni_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Uzunu me sa wa orno ni ma pitila ma ran gbardang. ");
INSERT INTO jni_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mare ma nyani niza numeme aftikos ma ciki aseseri utaga, moro ma ziki me; barki sa bulus ma witi tize tumeme joko, ma nyani me sa moro ma ziki me pitii manno ma rize aseseri uzunu uku taru aziki. ");
INSERT INTO jni_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bulus manno ma tu asesere ameme awitino ma orime maduku gu, ''kati ikunna ma aye ba, barki ma zin nivai da ma wono ba.'' ");
INSERT INTO jni_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Manno ma nyene asesere uzunu me ri ubiredi me nan we, ma boo tize na we uhana usana hira maduku ceki we. ");
INSERT INTO jni_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Waduku eh in ma nyani me ini vai, wa kem tiyom azo cin ba. ");
INSERT INTO jni_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Barki haru sa ta agiza bulus uhana ahira uzirgi me, ta diku ribi uahana u asos, ta bari ti ziki bulus uzirgi me barki me ma inki iriba madi haki inti buna. ");
INSERT INTO jni_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Sa ta gurna u asos, ta zika me uzirgi umei uhana mitilitus. ");
INSERT INTO jni_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sa ta hira abirko me, ahira asani ti eh utsibirin kiyos, ahira akura asana ti e anipin nu militus. ");
INSERT INTO jni_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Barki anime bulus ma inki iriba madi aki u afisa uzirigi me, barki kat ma dii u asiya, barki ma muntuno inka ya wuna uri uwui unigora ni tanda uweme uke urushalima. ");
INSERT INTO jni_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","U militus ma tumi atiti me ananu anu tarsa Asere u afisa, usanda uti cukum sa wuzi nan nu gurna uru nigome. ");
INSERT INTO jni_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Sa wa eh ahira ameme ma buku we, ace ashime e rusa in nu wui utuba sa man inki tibuna u asiya. ");
INSERT INTO jni_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ma tarsi Asere ini ribe ishew nan maje, nan nuzito sa ma ziti barki malin ma yahudawa. ");
INSERT INTO jni_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Irusa da ma kunna ugitak ubezi ushi konde tiya timumu tika tuma ba, ma tarsa shi tikura tikura in zinu bezizi ushi timumu amasaa. ");
INSERT INTO jni_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Irusa usanda ubara ayahudawa nan a Hellenawa abanga barka ahira Asere nan nu nya iriba ahira ugomo Asere Yeso. ");
INSERT INTO jni_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ana me aye, idi dusa urushalima, bibe bi lau ba bezum amasaa gwas inha, in tamu imu besa idika kem abirko ba. ");
INSERT INTO jni_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bibe bi lau ba bezum akodi niya nipin unu guna, inyang na nu zito wa nyargam. ");
INSERT INTO jni_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Barki anime da ma zika ivai im izi imumu ihuma ahira am ba, barki in myinca magasiya na katuma sa ma kaba ahira ugomo Asere Yeso, ubezi utize turunta Asere. ");
INSERT INTO jni_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ana me, ira inrusa shi vat, andesa ma wuza we tize ta kura Asere, ida kuri irim ba. ");
INSERT INTO jni_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Barka anime ma buka shi uwui ugino me, in zom unu gogoni umaye ma konde uya unu ba. ");
INSERT INTO jni_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Barki anime da ma kunna ugitak ubuka ushi vat imumu iriba ya Asere ahira ashi ba. ");
INSERT INTO jni_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Barki anime hira ace ashi me, nan nanu tarsa in bibe bi lau na zauka shi anu tarsa inanu hira iwuzi nibe nanu tarsa Asere, sa ma kwa in maye mame. ");
INSERT INTO jni_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","In rusa unuguna uganiya sa ma dusa, makinkaru ma pazaza madi ribi anyimo ashi me, mada wuna anu tarsa Asere kugbara ba. ");
INSERT INTO jni_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","In rusa anyimo are ahana aruma wadi eh wa boo tize tizenzen, barki wa hunguko ahana akatumu uhana ahira aweme. ");
INSERT INTO jni_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Barki anime hira ni ringini unuguna tiwe ti taru da ma ceki uniza ukonde avi ushi tize in maje uwui nan niye ba. ");
INSERT INTO jni_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ana me izinu wito ushi ahira Asere, in tize turunta umeme, tige sa tizinu bari ubenki ushi ti kuri ti nya shi utanda nan vat andesa wa ra anyimo anu zawa wa Asere. ");
INSERT INTO jni_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Da ma wuza uhem wa zumo abalabal, nani azumo awalwal nani tirunga ti uye ba. ");
INSERT INTO jni_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Shi inace ashi irusa ma waza katuma in tari tum, ma bisa nice num imumu nyara nan andesa wa zi nan mi. ");
INSERT INTO jni_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ma cukuno shi bezi atina sasas sa idi benki anati una ahira akatuma, nan in kuri iringi in tize ta tu ugomo Asere Yeso, tize me sa me inice nume magu, ''unyiza uteki ukaba unu gbardang.'' ");
INSERT INTO jni_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","uganiya sa ma buki anime, ma tunno ma wu biringara nan we vat. ");
INSERT INTO jni_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Vat uwe wa shi kang, wa kuri wa gendirko me wa nyunkuno me. ");
INSERT INTO jni_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Wa wuzi iriba ibiti barki imum besa ma buku we, ida kuri irim ba. Vat uwe wa ka tibi me uhana ahira uzirgi umei. ");
INSERT INTO jni_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sa taa harzina nan we, ti dusa ti ribe ujirgi umei ti meki nibeba uhana ani pin ni kos, sa ahira asana ti dusa uhana urodusa, ti dusa uhana ani pin ni Batara. ");
INSERT INTO jni_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Sata kem ujirgi sa waa hazi ukafa uhana u Fonisiya ti dusa ti ribe. ");
INSERT INTO jni_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","4","SA ta gunkuno, ti iri nizabu ni kubrus ni gunki ti ceki nini ani kira ni tari tina gure turu ti witino uhana u suriya, ti dusa tu ani pin nu taya abine ani ujirgi umei anu tarsa u Yeso ti cukuno abini me ti wu tiye tinu sunare. Anu kati ma ha urushalima ba. ");
INSERT INTO jni_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Sa tiye cigiling ta aka ti dusa tiri aje in tanu turu vat uwe nan ane wan ahana aweme waka tibin duru aka maru kani pin, Ti dusa ti tunguno ani kira ni uraba ti wu biringira ti dusa ti wu sa mura. ");
INSERT INTO jni_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ti dusa ti ribe uzirgi umei, we dusa wa kuri uhana akura. ");
INSERT INTO jni_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sa ta mara tanu tiru u Taya ti biki u Talamayas, abini me ani taa gurna nan ni henu ti isi we, taa muri ka'inde nigoo me nan we. ");
INSERT INTO jni_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Sa ahira asana ti dusa uhana u kaisariya. Ti ribe akura a Filibus, anu boo tize Asere, unu inde unu inde anyimo usunare wagino me, ti cukuno nan me. ");
INSERT INTO jni_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Anu uge me mazin in na hana wa nazi a'e, mabura anu kurzuzo utize ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sa ta cukuno abine anyimo atiye cingiling, ure unu kurzuzo tize ta Asere ma e uyahudawa una niza Agabus. ");
INSERT INTO jni_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Maa e ahura aru ma ziki uzu u Bulus ma tiri ubuna umeme nan tari ti me me magu, ''bibe bi biriri ba guna, ane ani mahudawa madi tiri unu zuu ugeme me, wadi gaa me atari tanu zatu tarsa Asere.'' ");
INSERT INTO jni_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sa ta kunna kadura kagene me abibi vat uru nan andesa wa ciki abini me ti tiri Bulus tari kati ma ha a urshalima ba. ");
INSERT INTO jni_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bulus ma kabirka magu, ''nyanini izi nu wuza me, izin tiso iri nu huza um iriba? ida turum barki utira cas ba nan iwono cangi urushalima, barki niza ni Yeso.'' ");
INSERT INTO jni_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","SA rusa Bulus ma da nyara akarti me ba, ti dusa ti kini aso me ti gu, ''ca imum be sa ugomo Asere ma hem icukuno.'' ");
INSERT INTO jni_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Sa tiye ti gino me ta aka ti dusa ti ziki maburga ti dusa uhana u urushalima. ");
INSERT INTO jni_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Are anu wa tarsa u Yeso sa waa suri u kaisariya wa tarsin duru. Wa ē nigo me na uri unu desa a tisa me manason, unu u kuburus desa ma tubi ukaba tize ta Asere, desa tidi cukuno nigo me nan me. ");
INSERT INTO jni_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Sa ma eh ujerusalem, anu wa kabi we wuzi apuru arum. ");
INSERT INTO jni_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Sa ahira a sana Bulus ma dusa nigo nan haru uhana ahura a Bitrus, vat ananu wa rani. ");
INSERT INTO jni_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Sa ma mara u'iso uwe, ma ribe ubezizi uwe vat timum be sa ugomo Asere maa wuzi anyimo anu zatu tarsa Asere barki katuma kameme. ");
INSERT INTO jni_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sa wa kunna anime, wa nonzuko ugomo Asere wa gun me, ''ira, uhenu mayahudawa gbardang wa kaba Asere wa wito ace awe wa hem wa zin ini riba u'inko utize.'' ");
INSERT INTO jni_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Akuri abuki we tize anice ni weme agi, u dungura mayahudawa sa wa ciki nan anu zatu tarsa Asere wa game u kunna tize ti Musa. U dungura we kati tasi utanda u kuzu ba. ");
INSERT INTO jni_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nyanini ya wuna uri ti wuzi, kadure me wadi kunna wa aye. ");
INSERT INTO jni_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Barki anime wuza imum be sa ta di buki we ana me. Ti zin in nanu wa nazi sa wa wito ace. ");
INSERT INTO jni_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Zika anu anu agino me ika kpico ace ashi me nan we, u kuri u bi imum be sa wa huna, bati wa ta ace aweme. Bati konde avi madi rusi timum me sa abuu anice ni we me macico mani, wadi rusi hu cangi u'inso tize. ");
INSERT INTO jni_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Barki an desa ta me Asere ba sa wa hem, ta nyettike ti gbarika ti gu ca wa hunguko ace aweme ahira atimim sa adi nya makiri mani, ma yee, nan ure imum be sa daki a weki ba, nan madini mu tarsa ahana eh. ");
INSERT INTO jni_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Unu uwui ukure Bulus ma ziki anu agino me wa ka kpico ace aweme nigo me, wa dusa uhana udenge Asere, bati ma buki abanga usana uweme, adusa a nya u sadiga barki konde uya unu anyimo aweme. ");
INSERT INTO jni_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sas ti ye tini usanare ta aye mamu umyinca, mare mayahudawa mu Asiya sa wa ira Bulus anyimo udenge Asere wa dusa wa turuka nigo na nabu wa meki me. ");
INSERT INTO jni_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Wa meki ti hunu unu gusa, ''anu israila benkin duru, unu ugeme me mani mazinu dungura anu timum me sa ti da rizi me ba ahira anu, unu cara u'inko utize, nan ahira ageme, ban anime ma ayen in nanu amadini anyimo udenge wa Asere ma cara ahira alau.'' ");
INSERT INTO jni_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Barki wa mu ira me nan Tarofimas unu Afisus anyimo anipin, wa gusi Bulus maa en udenge we Asere me ini. ");
INSERT INTO jni_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Vat nipin me ni dusa ni gumurka, anu wa dusa orno wa meki Bulus. Wa hunguko me wa suso me anyimo udenge Asere wa dusa korso tina tukum me. ");
INSERT INTO jni_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sa wa zinu ubara abanga uguna wadi hu me, abanga me abiki ahira unu ydang uni kono agi urushalima wa shagilan. ");
INSERT INTO jni_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ma dusa ma ziki ma soja nan anu ani kono adang, wa dusa uhana ahira anigo na nabu me, sa anabu wa ira ma soja nan unudang me, wa ceki utira u Bulus. ");
INSERT INTO jni_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Unu dang me uni kono ma ha mamu ma meki Bulus magu atiri me ini nyang ini re, madu ku a iki nani me aveni nan imum besa ma wuna. ");
INSERT INTO jni_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aye anyimo anu me in ti hunu, aye wagu ana aya wagu ana, barki ugbardang uti hunu daki ma guna ire imu ba, ba magu a han me ahira amasoja. ");
INSERT INTO jni_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Sa ma aye ahira u nyeze (utarsa uti buna) me, masoja me wa dusa wa yeze barki ushigilina wa anabu. ");
INSERT INTO jni_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Barki nigo na anabu wa maki utarsa me in ti hunu unu gusa, ''dusa ni in me.'' ");
INSERT INTO jni_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Abiki uriben in Bulus ahira amasoja, ba gun imu unu dang amasoja me, ''nani udi hem in buki we ire imum? ba unu dang me ma iki'' urusa u boo uti Helenici tini. ");
INSERT INTO jni_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Daki hamani unu masar uginome sa tiwe ta dumo desa ma hirza ijuguta igino ma ziki anu madubu ma nazi, huza anabu uribe ani ja. ");
INSERT INTO jni_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus ma kabirka ma gu, ''mi uyahudawa mani ma suro uTarsus anyimo a manyanga mu kilikiya, anipin me sa arusan in nini, in zinu tira uwe tari kinin in buki anabu tize.'' ");
INSERT INTO jni_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Sa unu dang uma soja me nya me uganiya, Bulus ma dusa ma tonno ahira upatala me, sa ayeze we tari, wa dusa wa cukunno tik, ma buu we tize in nilem ni yahudawa, magu. ");
INSERT INTO jni_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Anu henu nan ankaco, rikani ti toi ikunna ubura um u aye a hira a shime aname. ");
INSERT INTO jni_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Sa ni ori na nabo wakunna tize ti bulus ini hem na ibraniyawa wadusa watatonno tek, magu. ");
INSERT INTO jni_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Me ubayahude mani uwatu usamirika anabo ini ikiliya, anyimo amanyanga mu gamaliyal a pokum aje ni, a kuri abezizi abinime kang inu gunno itarsi una u inko utize ta cokoro aro, izin nu inko iriba atize ta Asere kasi shime sa izin tini. ");
INSERT INTO jni_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ma mensi anabo in husi ma kuri in tirzi ahana aruma nan na a ēh in han we ati gomo a tuburko we udenge unirere. ");
INSERT INTO jni_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Anime ani unu udang ukayuma ka Asere na nu wadi nya u inpo amaro inu guna ma kabi nikara nitize tu inko u watu ushi barki ni henu sa wa rani damascu, barki idusa abirko, katuma kam kani i tarsi adesa wa tarsa una ugino me, i en we anyimo urshalima barki a tarsi we. ");
INSERT INTO jni_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Uganiya mara anyimo atanu, inkuri in ha ma mu nan damascu, inu wui ace uganiya u inde masaa madangdang usuro Asere u pokino ma ketum. ");
INSERT INTO jni_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","In rizi adizii uganiya madusa ma kunna ni gmyirang ni gusa me, 'shawulu, shawulu, barki nyanini yawuna uzin nu kunna um iwono?' ");
INSERT INTO jni_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","In babirikame, 'aveni hu ugomo Asere?' magun me, 'immani Yeso ubanazarat unigesa uzin nu nya ume uzito ugino me.' ");
INSERT INTO jni_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Anuge besa wazi nigo nan me wa iri masaa me, idaki warosi niggmyirang na veni mazin tize me ba. ");
INSERT INTO jni_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ma gu, 'nyanini indi wuzi hu ugomo Asere?' Ugomo Asere magume, 'magu me ihire idusa anyimo damascu, abini me ani adi boki we imum ikadure sa udi wuzi. ");
INSERT INTO jni_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Idaki iri ahira me ba barki umilme u masa, idusa anyimo damascu u watu u tarsa andebesa wazi ni go nan me. ");
INSERT INTO jni_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Abirko me ani ma kem uye unaniz ni ananiya, una biyyau ba Asere ahira u inko utize, tini kobbo nanni zani rere aje ayahudawa as wa ciki abirko me. ");
INSERT INTO jni_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ma eh ahira am magu, ni henu shawulu, kaba uhira unipen, rep na nu ganiya ginu me iri me. ");
INSERT INTO jni_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Uganiya magu, 'Asere aka co uro sa mazauka we inu gunna urosi imumbe sa me ma nyara wa ira unu iriba ishew iginome, kunna tize tige besa ti suso anyo ameme. ");
INSERT INTO jni_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Udi cukuno unu impo amaru ame barki timumum sa wa ira nan ti gebe sa wa kunna tini. ");
INSERT INTO jni_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Aname nyanini uzin nu nyargame? hira azoro we akuri akpici we madini ma we me, unu tisa anyimo aniza nu meme. ");
INSERT INTO jni_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Uganiya sa ma kuri urushalima uganiya mazin im birigara anyimo udenge me ina makabi tiro. ");
INSERT INTO jni_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ma irime magun me, 'wuza dibe-dibe u ceki urushalima a-a na me, barki wada kaba me u impo amaru imumbe sa udi boki ini ahira am ba. ");
INSERT INTO jni_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Uganiya sa azin nu kponko umaye munu impo amaru aweme istifanus, maturi izin nu impo amaru, in kuri in hiri tironga ta desa wa hume. ");
INSERT INTO jni_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Magu, 'ugomo Asere, we ina ce awe warusa uwuna sa ma wuweni udenge uni rere in kuri intiri aye desa wa nya muruba muwe sa wa kabi we atidenge ti biringara. ");
INSERT INTO jni_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Manno magu me, 'dusa, barki idi tumu we abirko ahira anu amaree. ");
INSERT INTO jni_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Anabu wa ceki me ma wuzi tize nan nu hana uganiya, barki anime wa dusa wa yeze agmyinrang wazi nu gusa na kari kunu kuginu me, anyimo unee, daki ya wuna urii acekime makese ba. ");
INSERT INTO jni_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Uganiya sa wazin nu yeze agmyinrang wa vingizi tironga tu we wa hirziza usuru u pebu. ");
INSERT INTO jni_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Unu udandang uma soja ma nya nikara ahamme in bulus ahira sa ma cikin, madusa ma nya magu a ikime a gunguzunu me in ni sisari barki wa rosi imum sa ya wuna izin me iti hunu ishina. ");
INSERT INTO jni_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Uganiya sa w tirzi me ini sere, bulus magu ana dandang me sa wazi mamu nan me, ''nani ya wuna anime e wuna inko utize awu u barome a wuzi me tize tu inko a hume sarki ucoboo?'' ");
INSERT INTO jni_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sa una je ma kunna anime ma ha ahira unu udandang nyanini n nyara u wuzi, ''unu uginu me una nu roma mani.'' ");
INSERT INTO jni_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Unu udandang uma soja ma ē magu me, ''bukam hu una nu roma mani?'' bulus magu, ''anime ani.'' ");
INSERT INTO jni_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Unu udandang uma soja makabrika me, ''adi kpi ucukuno vana umanyanga ini ikirfi igbardang.'' ine ini bulus magu, ''aymo uma manyanga mu roma.'' ");
INSERT INTO jni_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Aye wa ē ugizo ume wa dusa wa ceki me daki wade ba, unu udandang uma soja ma kunna biyyau sa ma tinka unu gunna bulus u yoo wanu roma uni, sa mamu tirza me. ");
INSERT INTO jni_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Sa ahira asana, unu dandang uma soja me ma nyari marusi kadure kimum be sa ya wu awuzi anime ayahudawa wa wuzi anice ni bulus. Ma dusa ma soppi me anyimo tisere me, ma kuri ma nya unu dandang ukatuma kadandang ka Asere nan na nu ira wa gurna ma dusa ma en bulus atii aweme. ");
INSERT INTO jni_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus ma gunkuno ni ori na nu me magu ni hanu ma wuzi katuma ka Asere ini ruba iriri u aye uwuyi u kani me. ");
INSERT INTO jni_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hananiya unu dang ukatuma ka Asere Hananiya magu wa turi upuri agi wa vovi Bulus anyo. ");
INSERT INTO jni_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ba Bulus ma gun Ugomo Asere madi vovi we hu una katuma ka zenze. u ciki unyarum unu rizo uni, sa udi gu avovi um, barki ma rizo? ");
INSERT INTO jni_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","An desa wa turi upuru u Bulus wa aiki me nyanini ya wuna wa zogouna katuma ku Ugomo Asere udang? ");
INSERT INTO jni_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulus ma kabirka magu ida rusa ba nihenu me una katuma ka Ugomo Asere anyertike uda buka we tize tize tizenze ani ce ni Ugomo wa nun ba. ");
INSERT INTO jni_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Sa Bulus ma iri ni kira ni inde a Sadukiyawa wani, ba ma yeze ni myira aniyimo ahira ati cukum me, magu ni henu mi uFarisiyawa maru, usam wa Farisiyawa. ");
INSERT INTO jni_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Sa ma buka ani me matara madusa mahiri ani ce na sadukiyawa nan aFarisiyawa, wa dusa wa harzina. ");
INSERT INTO jni_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","A Sadukiyawa wagu desa ma wono mada kuri ma hiri ba roni u aye Asere, bibe biriri bi rani ba aFarisiyawa ani kira ni weme wa hem ti mum ti gino me ti rani. ");
INSERT INTO jni_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Imum me ikinki ushagilna are anu nyerte wa Farisiyawa wa hiri wa tonno wa wu matara wagu “daki ta kem unu ugemw in ure usiziki ma ba”. ");
INSERT INTO jni_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Sa matara me ma kinki uzenze unu dang wa soja ma kunna biyau kati a jazari Bulus, ma tumi ahana aka tuma kame me waka ziki me kara wakame ahira ameme. ");
INSERT INTO jni_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Anyimo nikure Ugomo Asere ma e ahira ameme magu, kati u kunna biyau ba, gusi sa daki wa kunna biyau utita unizaa nim a Urishalima ba udi kuri u bezi u Romawa. ");
INSERT INTO jni_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Sa ahira asana are ayahu awa wa dusa wa toniko wagu wada ree me imum yare nani wa si iri mum ba, wadi huu Bulus. ");
INSERT INTO jni_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Anu me sa wa barka u huna u Bulus me wa akuri anazi. ");
INSERT INTO jni_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Wa dusa wa haa ahira una katuma ka dang akatuma ka Asere nan ana nanu wa gu wa mu toniko wada re me imum yare nani wa si iri mum basa ww huna Bulus. ");
INSERT INTO jni_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ca nigori na anu adang wa buki u soja udang ma en me a hira ashi me anu adang i bezi me ma wuza ugbas, haru ta mu wuna amuruba inguna tidi hu me. ");
INSERT INTO jni_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Usam uhenu u Bulus u e madusa kunna wa gunna anibaba wazini be u Bulus, ma ribe ma buki me. ");
INSERT INTO jni_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulus matiti uye desa ma mazin in katuma akura akura u soja madu me “zika manyani ma ge me u hani a hira una kura me, mazin ini mum besa madi buki me.” ");
INSERT INTO jni_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Anu udang unikono me ma dusa ma ziki manyani me ma han me ahira unu udang unikono me, magu ''Bulus mani unu iyang ma guna i en manyani ma geme ahira aweme. Mazin ini imum besa madi buki we'' ");
INSERT INTO jni_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Unu udang me ma dusa ma han me are ahira ani hunzi, ma iki me, ''Nyanini u nyara u bukum?” ");
INSERT INTO jni_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ba manyani me magu, “Ayahudadawa wa barkaa uguna wadi gun in hu u en Bulus nisizo a hira awe me gusi wadi iki me ire abanga atize time me. ");
INSERT INTO jni_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kati u hem ba, barki anu sa wa biki akuri anazi wamu toniko wada re me imum yare, nani wa si ire imum ba se wa huna Bulus.” ");
INSERT INTO jni_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Unu udang anu anikono ma ceki manyani me ma dusa, magun me, “Kati u buki uye wa bukam abanga age me ba.” ");
INSERT INTO jni_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ma titi anu adang anikono ware magu, ''zauka nin anu adang anikono a ino ukirau kani kare (200), anu barka a'ino usunare, anu cira atigbina a ino ukirau kani kare (200) wa dusa Ukaisariya azumo ataru in niye.'' ");
INSERT INTO jni_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ma inki inama igeme sa Bulus madi nyene sa idi ham me merum ahira Filikus unu kpanku udang (Ugomna). ");
INSERT INTO jni_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ba ma nyettike kadura gusi ana. ");
INSERT INTO jni_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Kadura kani isi hana ahira kuludiyas lisiyas uhana ahira unu udang Filikus. ");
INSERT INTO jni_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mayahudawa wa meki unu ugeme unu nyara u huna ume, ma nyene we in anu adang anikono num, sa kunna me unu Roma mani. ");
INSERT INTO jni_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ma nyara in kunna imum be sa ya wuna wa zini ucara utize anice nimeme ine ini ma hanan in me aje atigomo. ");
INSERT INTO jni_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ma rusa azini ucara abanga ani ni meme ahira u'igizo utize ahira u'inko utize ti meme, daki ma ira ure ucara abanga sa wa bari utira nani iwono ba. ");
INSERT INTO jni_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Sa a kurzom ubara imum iburi igeme, ine ini ya wuna ma tuburko me ahira awe me, sarki ucara uganiya, ma wuna anu cara abanga anice nimeme wa eni ahira aweme. Cukuno merum ");
INSERT INTO jni_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Abini me anu adang anikono me wa kunna imum besa abuka wa; wa dusa ziki Bulus wa en me in niye ahira Antibatris. ");
INSERT INTO jni_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sa ahira asana, anu barka wa dusa nigo me nan me ukasu anu adang anikono wa kuri udenge uni kubu me. ");
INSERT INTO jni_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Sa ibarka me ya biki ukaisariya wa dusa wa witi kadura sa a nyettike ahira unu kpanku adang gomna, wa kuri wa witi Bulus atari timeme. ");
INSERT INTO jni_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Sa unu kpanku udang ma hira ihori me, ma aiki we Bulus me ma suro maya ma nyanga mani. ");
INSERT INTO jni_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ba magu indi kunna we memerum uganiya sa anu cara abanga anice ni weme wa aye ma dusa ma atiri udenge utigomo ti Hiridus. ");
INSERT INTO jni_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sa tiye uchibi ta aka Hananiya una katima kadandang wan are ananu nan anu rusa utize tini kubu una niza Tartilus wa dusa abirko. Wa han Bulus aje ugumna. ");
INSERT INTO jni_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Uganiya me sa Bulus ma tonno aje ugumna, Tartilus ma tubi uniza ume tiyari magun unu gumna me. ''Barki hume ta kem ticukum tihuma, urasa uwe me wa barka manyanga maru. ");
INSERT INTO jni_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Barki anime vat imumme sa wa wuza takaba inna puru arum, hu unu dang Filikus. ");
INSERT INTO jni_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Barki kati imnyawe ijasi, inyara a gbarikam bati in buki tize cingilin. ");
INSERT INTO jni_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Akem unu ugeme unu caran sassas, mazin unu tura ayahudawa nan unee we nyari abanga. ");
INSERT INTO jni_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ma soki nice ucara udenga Asere, barki anime ca timeki me. (Tahem ti wekime tize rep nannu inko utize turu.) ");
INSERT INTO jni_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Anime Lisiyas unudang ma ē ma buri me ini kara atari turu. ");
INSERT INTO jni_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Inge igizo me timum tigeme udi kadundura me ahira ame. ");
INSERT INTO jni_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Vat ayahudawa wa boome Bulus unu guna, maguna timum tigeme kadundura kani. ");
INSERT INTO jni_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Sa ugumna me ma hem Bulus uguna ma buki tize magu, ''aname mahem uguna wa daddankino unti gomo tima nyanga ma geme, barki anime indi buki we tize ina puru arum. ");
INSERT INTO jni_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Udi hem unu guna daki ya biki tiye ukirau intire sa eze urushalima abiringara. ");
INSERT INTO jni_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Sa wa kem udenge Asere, daki ma hunguko nani ma hara anabu ba. ");
INSERT INTO jni_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Barki anime wazowen kadura kimumme sa wazin nubo anice num kane ba. ");
INSERT INTO jni_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ma buka we, barki una me sa tarsa anime ani min tarsa Asere acokoro aru. Ma wuza iririn utarsa unyettike u Musa nan ma takarda manu kurzuzo utize ta ASere. ");
INSERT INTO jni_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma inko iruba Asere, kasi inda be sa adi hirza anu wijo, anu iruba ubenki nan anu abur. ");
INSERT INTO jni_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Anime ani nyara in cukuno unu imum uzatu ubo ahira ASere nan anu anyimo uvat utimum. ");
INSERT INTO jni_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ma ē atiwe sa ta aki unu saddiga nan unya uhem iruba. ");
INSERT INTO jni_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Anyimo iruba uwana anime, are ayahudawa ama nyanga mu Asiya wa kem anyimo ati na tuisa udenge Asere, inzo inni ori nani unu bukurko ahira ba. ");
INSERT INTO jni_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Irizi anu agino me ē ahira aweme kanime, ingi wazin ini mum ubo anice. ");
INSERT INTO jni_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ingi inzo anime ba ca anu ageme wa buki nani wamu kem ini mum ibur uganiya sa ma hana aje anu ira wa yahudawa; ");
INSERT INTO jni_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Senke nani imu inde sa ma buki ini myirang nidandang uganiya sa ma tonno aje awe, abanga uhira anu wijo sa anyara uweki um tizen kani me. ");
INSERT INTO jni_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filikus ma zin nurusa ukang una me, ine ini ma yeze tize ma gunan we, ''vat uganiya sa Lisiyas unya utize ma ē usuro urushalima, indi weki tize.'' ");
INSERT INTO jni_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ma wu anani kara wa hiri Bulus, ma kaska, kati ma karti aroni uhana ahira ame nani ubenki ume. ");
INSERT INTO jni_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sa tire tiye ta aka, Filikus nan une me Druskila, uca wa yahudawa mani, ma tumi atiti Bulus ma kunna uhem ume anyimo vana Asere Yeso. ");
INSERT INTO jni_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Uganiya sa Bulus ma buka abanga iruba ubenki, umeki unice nan imumme sa ize idi kem we, Filikus ma kunna biyau magu, ''Ana me dusa ingi makem masa indi kuri inyari we.'' ");
INSERT INTO jni_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Uganiya ma inki iruba Bulus madi nya me ikirfi, ma nyari me karere bati ma buki tize nan me. ");
INSERT INTO jni_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Sa awuna tiwe tire Borkiyas Festas ma cukuno ugumna sa Filikus ma tuno, barki unyara ukaba ahira ayahudawa mari aje unu UBulus akura anirere. ");
INSERT INTO jni_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ana sa, Festus ma eh anyimo una uribe uni pin me sa na ra atari timeme, sa tiye ti taru ta aki, ma dusa uKaseriya uka aka Urishalima. ");
INSERT INTO jni_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Unu dang uka tuma udenge Asere nan a re anu anyimo ayahudawa wa eh in bi bukum bi Bulus ahira a Festus ");
INSERT INTO jni_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3",". A gi ma gu, Bulus ma eh a Urishalima bati wa kem unaa u huna ume. ");
INSERT INTO jni_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ba Festus kabirka we magu a impi Bulus u Kasariya, me in haza ukuro abini ne a, ana me. ");
INSERT INTO jni_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Barki ani me, an desa wa daki,”wa gu,”wa tarsa duru. Ingi ya ira iri mum i buri ahira unu me, idiku wuzi ni eru nishi me. t ");
INSERT INTO jni_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ma ciki abini me tiye uwititari uhana tiye ukirau, ma kuri uhana Ukasariya. ");
INSERT INTO jni_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Sa ma biki, a Yahudawa u Urishalima wa tonno mamu nan me, wa ezin in bibukum gwardan bige sa da ba zin ma saa ba. ");
INSERT INTO jni_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ba Bulus ma buki tize ti bura uni ce nume, da ma ira imum ibur ya Yahudawa ba, da ma ira imum iburu anyimo udenge Asere ba, daki ma kuru ma ira imum iburu ahira Kayisar ba, nyanini ma wuza. ");
INSERT INTO jni_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus ma nyari u tarsa ta Yahudawa, ma kabirka Bulus magu me, unyara tarsum uhan Urushalima me inka boo tize tuwe me bini me ");
INSERT INTO jni_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10",". Ba Bulus ma gu,”ma tonno aje ukponku uti Gomo ti Kyisar abuu tize me da akem ma wuna a Yahudawa mum ba hume urusa. ");
INSERT INTO jni_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bulus magu, ingi ma wuza ire mum ibur nani ma wuza imun gebe sa ya bari iwono, in da gam in wee ba. ingi bibukum bu we bini ahira hura ani, da ma ira de sa madi nyawe mi, ma tita anyimo ani za ni kayisar. ");
INSERT INTO jni_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ba festus ma buu tize nan ana katuma ka meme, magu, ma tita anyimo niza ni kayisar, madi ha ahira a kayisar. ");
INSERT INTO jni_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tiye cingilinti aki, Ogmo Agripa wan Bernice wa eh Ukaseriya ahira u orno uwe me uFestus. ");
INSERT INTO jni_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bulus ma ra abini me inti ye gwardan, Festus ma en Bulus ahira aroni me, magu we Felix ma ceki unu ugeme abame anyimo Ukorso. ");
INSERT INTO jni_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Uganiya mara aUrishalima, un dandang ukatuma udenge Asere wan anu tarsa umeme anyimo a Yahudawa wa eh imalin mu nu geme ahira am, wa iki una uhuna u me. ");
INSERT INTO jni_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ba ma gun we, a utanda wa yahudawa uni a nya unu ani me, barki ani me adi muti de sa a zin malin mame nan an de sa wa aye in malin me nani ma kyem ma buki tize tu bura uni ce nu meme. ");
INSERT INTO jni_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Barki ani me, sa wa orno ahira am sarki ucara uganiya, ni ye ni kure in cukuno ukponku uti gomho in wu a en in nu nume anyimo. ");
INSERT INTO jni_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Sa ana bibukum wa hiri wa buu bibukum me, in gusi nani wa zin in tize ti ka dure kani ahira unu me. ");
INSERT INTO jni_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","A, anime in iri tize tuwe me ta zome in ma saa ba, agi ma buu tizee ti bur asesere a uwe utanda me nan abanga iwono i Yesu sa Bulus ma inki iribani. ");
INSERT INTO jni_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Madiri imum i buka utize me ban, gume nani madi ha Urushalima waka buu tizee meni. ");
INSERT INTO jni_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ba a titi Bulus aka impo kasi ubuka me unu dang mi ingu me hana uka uwui ge sa ma tuburko we ahira kayisar. ");
INSERT INTO jni_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa ma gu, in festus, indi nyari u kuna utize ti nume,“Nisizo,”festus magu,”uda kunname,”. ");
INSERT INTO jni_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Sa, ahira sani, Agrippa wan Bernice wa eh nan nanu gwardan, wa eh anyimo anikubu ni tize me wanu unu cati uni pin udang nan nanu adang anipin me. Sa Festus ma guna a eh me, aka heze Bulus. ");
INSERT INTO jni_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus magu Ogomo Agrippa, wan vat adesa wa zi na haru abame, ya irani unu ugeme, vat anu Uyahudawa wa han me a Urishalima nan a ba me, ba wa yeze a nyiran wagu nun ugeme ca a huu me. ");
INSERT INTO jni_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ba ma iri da ma wuna imum sa ya bari u huu na ba, barki sa anu dang ma titi me. Barki barki ani me aka aye me ahira Ogomo Agrippa. Barki in kem imum sa adi nyetike anyimo atize me. ");
INSERT INTO jni_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Me da ma ira ma saa ba in tuburko unu wa ka kurso sarki u ira, azenzeng amem. ");
INSERT INTO jni_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Barki u ira um i babana ini a tumum ahira avana Ugomo azo u ira imum be sa ma wuna ba. ");
INSERT INTO jni_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa ma gun Bulus buu tize ini ce ni we me. Ba Bulus ma witino ma tubi boo tize uni ce ni meme. ");
INSERT INTO jni_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","In zini uruba irum in ni ce num, ugomo Agippa, in e in tize tum nan na Ayudawa ageme in malim mam. ");
INSERT INTO jni_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Barki urusa imum me sa u wuza anyimo Ayahudawa nan nu utanda uweme, ane ani in igizo me u kunam seke. ");
INSERT INTO jni_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kadure kani va Ayahudawa wa rusa ta hana dati ani pin num uhana Ushalima. ");
INSERT INTO jni_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wa rusa utuba um mi unanu Farisawa mani anyimo ati gomo ti dang tiru. ");
INSERT INTO jni_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ana me in the aje ashime azini u igizo um tizee, barki sa a nyara in myinca imum sa Asere ugomo ma wu ak coo aru. ");
INSERT INTO jni_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Barki anime in turi tilem ukirau inti re sa wa tarsa Asere niye nan uwui, ta wuna ire ubuka imum me sa ira iruba iru. Barki ane ani Ayahudawa wuzum malim, ugomo. ");
INSERT INTO jni_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nyanini u ira uwee me ingi Asere ahira de be sa maa wono. ");
INSERT INTO jni_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Uganiya u inde in gun nice num indi wuzi imum gbardang ahira ani za ni Yesu unu Nazaret. ");
INSERT INTO jni_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma wuzi anime Aurshalima, inkurzuzo anu aka tuma kasere anyimo udenge ukorsuzo wanu, ma wuzi anime in nikara ahira unu adngdang aka tuma uenge Asere nan aye ma sa ma huzi we me bezi nice num inda nyara ura uwenba. ");
INSERT INTO jni_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ma wuzi we imum iburi inyizi uzatu ukadure inkunzina iruba in we, ine ini ya wu wa ziti atari tum. ");
INSERT INTO jni_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Sa ma zin uni wuza anime, indusa Udimaska in nikara sa ma kem ahira unu dang. ");
INSERT INTO jni_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Una um uhana me in nati ana ti uwui, in iri masaa sa ma teki uwui haru nan an desa tazin nigo me. ");
INSERT INTO jni_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ti rizi vat uru adizi, ba in dusa in kunna ni myira ni gusam in ni lem na Ibraniyawa, shawulu, shawulu nyanini ya wuna uwuzam ani me, ya wuna ani me? ");
INSERT INTO jni_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ba in iki ingu hu aveni ugomo Asere? Ba ugomo Asere ma kabirka, imani Yesu sa gaa me. ");
INSERT INTO jni_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ma dusa ma gun me hira tonno in ti buna ti we me, barki ma bezi mu henu mum ahira aweme, ma zauka we a nyimo akatuma kam u buu imum me sa u rusa ani ce num nan ige sa indi buki we. ");
INSERT INTO jni_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","In di zi nigome nan huu barki an desa wada rusa mi ba an desa indi tumi we ahira awe. ");
INSERT INTO jni_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Uka poko aje ugamirka we usuro umaree uhana amasaa nan ni kara, nan ni kara ni nu uburi uhana ni kara na Asere. Barki wa kabi ukpico uma dini maweme wan unu kaba sa indi kabi we barki uhem iruba im. ");
INSERT INTO jni_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Barki ani me, ugomo Agrippa, daki ma game imum me sa ya su ri aseser ba. ");
INSERT INTO jni_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Andesa wa e Udimaska unu tuba, atarsi una Urishalima wan vat nipin nu Judiya wan an desa wa tawe Asere ba, ma buu we tize ta Asere inu guna wa suri amaree uhana amsaa, wa ceki uwuza imum ibur wa tarsi Asere. ");
INSERT INTO jni_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ine ini ya wuu Ayahudawa wa mekum anyimo udengenAsere wa nyari uhuna um. ");
INSERT INTO jni_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Asere a benkum u aye ukani me, in turi unu boo anu acinci wan na dandang. ");
INSERT INTO jni_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Unu bura uru uginome madi si nirere, memani madi zi unu tuba uhira anyimo ani wono mabezi masaa ahira Ayahudawa wan na nu uzatu rusa ta Asere. ");
INSERT INTO jni_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bulus ma mari ubura uni ce ni meme, Festus magu inimyira aseser Bulus uzin nice ba urusa uwe me wa wuna iranzaa. ");
INSERT INTO jni_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ba Bulus magun me in zini iranza ba unudang Festus sede in buu tize tikadure anyimo ni za ni desa in tarsa me. ");
INSERT INTO jni_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ugomo cangi ma rusa ini mum me, barki ane ani indi buu tize in ni kara sarki biyau, mi in rusa ada hunzize me imum ba, daki amu wuna ani ba vat . ");
INSERT INTO jni_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wa hem unu nu kurzuzo tize, ugomo Agrippa? “In rusa wa hem”. ");
INSERT INTO jni_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa magun in Bulus” anyimo aku ganiya kucin u nyara ukurzom unu tarsa Asere.” ");
INSERT INTO jni_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus magu “maringirka ani me anyimo ani za na Asere anyimo kuganiya kuci nan ujoko, da huucasba, nan an desa wa kunnam kani me, wadi cukuno kasi mi, we wada sa me nirere ba. “ ");
INSERT INTO jni_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Sa wa kunna ani me, Ugomo ma hiri ma tonno wan desa a zauka me ani pin me, nan andesa wa raa ahira me cangi. ");
INSERT INTO jni_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Sa wa suri ani kubu me, wa gamirka acece aweme wagu”unu ugeme daki ma wuna imum me sa adi hu me ba nani atirzi me”. ");
INSERT INTO jni_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa magu in Festus, “Ada ceki me unu geme ba in daki ma yeze tize me uhana uwatu kaisar ba “. ");
INSERT INTO jni_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sa ta hem tidi dusa u italiya, wa witi duru Bulus nan aye adesa a kurso we nan Bulus atari ti urunu udang nizame agi juliyas, unu ubataliya Agustas. ");
INSERT INTO jni_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ti ribe uzirigi ume, adramatiya, uge sa wazi uguna udi hiri uhana upuru uraba udang wa Asiya. Ti haa uraba udang. Aristakus unanu Tasalonika amakiduniya ma dusa nan haru. ");
INSERT INTO jni_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Sa ahira asana ti tu anipin nu sidom, ahira gebasa Juliyas ma bezi Bulus uhem ni ma kuri ma hem aroni ameme wa tasi me barki wa hiri me. ");
INSERT INTO jni_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ahira me, ta tarsi uraba udang ti dusa uhana u kuburus, barki upebu udandang sa wa raa aje aru. ");
INSERT INTO jni_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sata kafa amei uhana uwatu ukilikiya Bampaliya, ti ē umira anipin nu lisiya. ");
INSERT INTO jni_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Abibi me, unu udang me ma kem uzirigi umei u Iskanriya ugesa uhaza italiya, ma wuna duru anyimo me. ");
INSERT INTO jni_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Niye nan tiye ti zi ni tanu seke u hana adumo tanu me ti cukuno duru dusi iwono ti ka tino upuru u sini dus upebu u karti duru tanu, ti wata u karita, upuru salmina. ");
INSERT INTO jni_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","In nirere ta tarsi u makurda ini ijasi at ē are ahira sa agusan ani ahira ugua uhuma a rā mamu nan nipin nu lasiya. ");
INSERT INTO jni_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","A'ane me ta zika uganiya ujoko, uganya uzatu are imumare ima yahudawa wa aka, tanu tiru ta de anyimo ijasi. Bulus ma nyinzi we tize. ");
INSERT INTO jni_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Magu, anabu tanu tiru me tidi cukuno duru in ti cari nan udira abanga gbanrdang, da si ahira ucira uzirgi cas ba nan ace aru me. ");
INSERT INTO jni_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Unu udang mateki unu kunna unaje ameme nan unu zirgi umei me, pit nan imum me sa Bulus ma buki. ");
INSERT INTO jni_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Barki ahira me ada runta ticukum ba. Maro gbardang wa gamirka agi aceki ahira me, ingi idi wu ti biki nipin ni Finikiya, barki ti venke abini me. Ufinikiya ahira uribize amazirigi ma mei ukarita, u hira u arewa uhana anaza nan ukudu uhana anaza. ");
INSERT INTO jni_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sa upebu wa hira usuro ukudu wa hure sekr, wa gusi agi imum me ya wuna. Ba wa hunugko nizin nu zirigi umei me wa tarsi ukarita upuru upingaru. ");
INSERT INTO jni_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Sa ku ganiya ka aka akem unani kara ni gino me sa agusan me kurokilidon, ma tuba utira uru u zalang. ");
INSERT INTO jni_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Sa uzirigi umei da wa sisizikime uhira upebu me, ti tarsi uwatu me sa upebu me u hazani. ");
INSERT INTO jni_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ba ti tarsi ahira me sa tidi kem ubenki ni upru ure uzalang sa agusan in uni ukauda; In nirere ta tiri uzirigi ku cin me anipu nudan me. ");
INSERT INTO jni_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sa wa nyeze uni, wa wuzi katuma inti zin wa tiri uzirigi meni barki usum kati urizi aseseri ubikiki bu sirtis, wa ceki uziirigi me unu gido uwe. ");
INSERT INTO jni_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ta wuzi nirere inti wiri da cin ba, sa ahira asana runga ti uzirigi me. ");
INSERT INTO jni_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Uwui utaru, ana katuma ku uzirigi wa vengizi ti runga sa ta rā uzirigi tari tuwe. ");
INSERT INTO jni_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tiye gbardang da ta ira masaa mu uwui nan mi iwiran aseseri aru. ni wiri ni dandang mini cas na zinu nu tira uru, vat ta kari mu riba tidi kafa. ");
INSERT INTO jni_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Sa wa dondokino da wa rē imumare ba, ba Bulus ma hiri aje ana katuma ku zirigi magu, anabu, sa ikunani mi, data hiri ukarita ba, sa tidi iri ti cari ti geme nan udira. ");
INSERT INTO jni_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aname in nasa shi mu riba wuzani iriba ihu, barki ba desa madi diri nice numeme anyimo ashi, uzirigi uni cas adi diri. ");
INSERT INTO jni_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Barki niye sa na aki bi be bi kadura ka Asere desa mi ume mani, desa in zin inirere barki me-bi be bikadura ma tunnu upuru um. ");
INSERT INTO jni_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Magu, ''kati u kunna biyau ba, ulus, udi udi tunno aje akaisara ahu anime, ukuri u iri, Asere anyimo ugogoni umeme ma nyawe vat imum sa i haka nan hu. ");
INSERT INTO jni_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Barki ani anadu, wuzani iriba ihu, barki ma hem in Asere, kasi sa abukum ane ani imumme idi cukuno. ");
INSERT INTO jni_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Adi vingi duru a ure uzalang aharu anime. ");
INSERT INTO jni_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","In niye nu kirau in ka nazi nza aye, azisi un tuburo uru aba nan abini anyimo uraba udang u Adriyat, ina ti aniye, ana katuma ku zirigi wa gusi agi wa aye mamu nan nire nipin. ");
INSERT INTO jni_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Sa wa batan duru wa kem ta biku anu akura are, sa kuganiya ka aka cin wa kuri wa batin duru wakem haru ukurau in nanu ucibi. ");
INSERT INTO jni_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Biyau bi meki we nan adi vengi duru aseseri apo, ba wa ningi nizin nu nazi adumo uzirigi me. ");
INSERT INTO jni_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ana katuma ku zirigi une, umei me wa zin unu, nyara una wadi ceki uzirige me wa kuri wa vingi sa wadi me anyimo uraba udang. Wa ku gusi wadi reki tire tizin in na aje uzirigi me. ");
INSERT INTO jni_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ba Bulus magu unani kara nini kono, ''ingi anu ageme wada tunno me anyimo uzirigi me ba ida kafa shi ba.'' ");
INSERT INTO jni_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Anu udang ati kara wa tassi nizin nu zirigime umei me wa ceki uni urizi. ");
INSERT INTO jni_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sa ahira atuba ussana, Bulus ma riki we vat wa donkino ke mumare, magu, ''kani tiye ukerau ni ti nazi da ta rē imumare ba. ");
INSERT INTO jni_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Barkianime magu nan shi re ni imumare, wani me barki nihuma nishenini, nice ni inde nishi me ida niniba. ");
INSERT INTO jni_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sa ma buka anime maziki ugurasa me magu Asere jankai aje akonda vi, bama posi ugurasa me ma tuba arame. ");
INSERT INTO jni_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Vat uwe wa kunna shew amuriba muweme wa tunguno are imumare. ");
INSERT INTO jni_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Haru anu akuri are in nanu akuri usunare inutasi (276) sa ta zi anyimo uzirigime. ");
INSERT INTO jni_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Sa wa rē wa tiyu, wa kpunko i alkama me anyimo uraba udang barki wa kaska ugitak uzirigime. ");
INSERT INTO jni_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sa ahira asana, wa tinka nipin me ba, wa iri ure ugbikubigaru, wa gamirka tizze ace aweme nani wa tuburko uzirigime uhana upingaru ugbik me. ");
INSERT INTO jni_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ba wa tazi tizin me wa ceki tini anyimo uraba udang me. Anyimo uganiya u inde wa sopisi tizin sa ti gamara uzirigime, ceki mabeze ma bi tini uzirigi me madusa uhana upingaro u raba udang. ");
INSERT INTO jni_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Sa wa biki ahira sa mei kare magurnani, ba u zirigi me u tunno adizi. Anaje uzirigime aribe abi jamarki abini me, usezirke uka zome ba, azumo umesi azumome atubi upusa barki iranza i'barka i mei. ");
INSERT INTO jni_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ana nikara niti kara ti mayanga wanu barka agi wadi huzi adesa a impoo we barki kati wa kafa wa sumi. ");
INSERT INTO jni_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Me unu udang me ma nyari ma buri Bulus, ba turi imum be sa wanu barka, ma nya tize magu, vat desa ma rusa mei ca ma hinna ma kafa uhana upingaru. ");
INSERT INTO jni_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ahana aruma wadi ku tarsi in nadumo, aye aseseri a makatako anyimo uzirigi me. Ane ani vat uru ta kafa anyimo upingaru. ");
INSERT INTO jni_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Sata tino umerum, bati kunna agi wa ra usibiri umalita. ");
INSERT INTO jni_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ana nipin me wabe zin duru imumu iriri kan wa huren duru ura tikun na udimdim, barki nan tiwui sa azin nu wuza me. ");
INSERT INTO jni_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ba sa bulus ma oro muri mumu titi barki ma hure urani, ba akem biwa barki ubambam ura, bisuri bi gbinciko tari tume. ");
INSERT INTO jni_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Sa ana ticukum tini pin me sawa ira biwa ba gbincirko tari tume, bawa gun na ce-ce, ''tabas unugeme unu huzanu mani, konu innu guna suburka usuro uraba udang, uweki utize tini kubu udida cekime me mavengize ba.'' ");
INSERT INTO jni_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bama zarika biwame anyimo ura daki innu guna ba kunna me iwono ba. ");
INSERT INTO jni_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Watonno daan wa iri nani bidi bo bi rizi ikizi a sawabe uhana uganiya cin da wa ira ire imum yakemba bawa cori ubasa abanga awe wagu me are asere ani. ");
INSERT INTO jni_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Amamu nan na hira agino me tire tiru tunu udang ahira agino, unaniza Babiliyas. Makaban duru manyan duru imum be sa ti nyara uhana atiye ti taru. ");
INSERT INTO jni_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Arani asenke unu yo u Babiliyas mazin nu zito innu tuma uni pum nan nu tiza umaye. Bulus maribe mawume biringara ma tarime, mahuma. ");
INSERT INTO jni_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sa anime yakem, ukasu anu zatu ni huma sawa ra ahira agino me wa e wakem ni huma. ");
INSERT INTO jni_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Anume wa wuna duru gonogon. Satizinnu bara apum atanu wa nyan duru vat imumbe sati nyara. ");
INSERT INTO jni_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Adumo ati petitaru, tiribe uzirgi u iskandariya ugesa dati innu puturu wara ahira agino me inni hori inde kasi ibara ahana aruma. ");
INSERT INTO jni_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sata tino ani pinnu sarakus, tiwu tiye ti taru ahirame. ");
INSERT INTO jni_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Abinime ti dusa, ti'e anipinnu Rigiyum. U aka uniye ni inde upebu uni kara uhiri usuro ukudu, anyimo atiye tire tibiki ubatiyoli. ");
INSERT INTO jni_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Abirkome tikem are anu henu wa ikinduru ti cukuno nigome nanwe uhana utiye usunare. Una uginome uni ta'e u Roma. ");
INSERT INTO jni_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Abirko sa anu henu wa kunna abanga aru, wa suri barki wagurin duru usuro ukasuwa u Abiyas in madangga mataru. Sa Bulus ma irawe, mawuzi Asere an koi makuri makem ushew. ");
INSERT INTO jni_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Abinime tiribe u Roma, ahenmin Bulus macukuno isisi me nigome nan anani kara nini koni sa wa zinnu be ume. ");
INSERT INTO jni_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Sa tiye ti taru ta aka, Bulus ma titi anu aje amayahudawa. Sa wa orno, bama gunew, ''anu henu daki ma wuza uye ti cari ba nani ma hribe utanda an ka co uruba, vat in anime anyare mi in tirza usuro a urshalima uhana atari tanu Roma. ");
INSERT INTO jni_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Sawa igizom, wanyari uceki um, barki sadaki macara abanga sa adakr awum iwono ba. ");
INSERT INTO jni_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Sa ayahudawa walonno anyimo u' uri iriba iwe, i cukuno gbas in ziki time uhana akaisar, daki in nu guna in zin binyo bu zika utize tanu am ani ba. ");
INSERT INTO jni_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Barki anime ani ma mara u'ira u shi in buki tize nan shi. Barki u inko iruba sa a isaraila wazin nui wawuna in tiri inyan iginome. ");
INSERT INTO jni_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Sa wa gunme, ''daki takaba unyettike usuro uyahudawa abanga aweba, daki uye anyimo ani henu desa ma ayen duru inna banga nani tire tize anice unwe. ");
INSERT INTO jni_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","A anime ti nyara ti kuuna ahu imum be sawa basa wakuru wa ira ahira anu darika, iye tisa rusa azinnu nonsi u uni koba.'' ");
INSERT INTO jni_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Sa wa inko me ueui, ma zin nu anu gbardang wakem me haira me sama tunno ni. Ma bezi timumum me ahira awe, ma zin nu inso u ira uti gomo ta Asre. Anime manyari u hunguko uwe abanga a Yeso, uzika atara a musa uhana uma anabawa, ma igi me usuro insiszo uhana awunjoro. ");
INSERT INTO jni_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Aye wakari ma'aye imumbe sa abuka, a anime aye daki wa hemba. ");
INSERT INTO jni_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Barki sa daki wa hem inna ce aweme ba wa dusa uhana umar imumbe sa bulus ma buka ni gurran ni inde, ''bibe bilau babu ka tize usuro anyo Ishaya unu kurzuzo utize ni uhana acokoro ashime. ");
INSERT INTO jni_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Magu, 'hana ahira anu zatu urusa utize ta Asere aginome agu, anyimo u kunna idi kunna in anime idi da tin shiba; Idi iri anime idida rusa shiba.'' ");
INSERT INTO jni_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Anime ani muraba manu aginome mawuna makotoras, titui tuwe ta kunna inni jasi, wakorso aje awe; Barki kati wa iri wa rusi, wakuri wakuuna inti tuituwe me, nani watinka in mu ruba muwe, barki wa gamirka mi'in human we. ");
INSERT INTO jni_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Barki anime, rusani ubara ugino me wa Asere atuman uni ahira anu zatu rusa utize ta Asere, wadi kunna. ");
INSERT INTO jni_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Sa ma buka tize tiginome, mayahudawa wa dusa wakuri, wa meki matara inna ce-ce awe). ");
INSERT INTO jni_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bnulus macukuno tiwe tire anyimo akura sa meki ma nyinza ikirfi imeni, mazinnu wuza vat anu mahabi sawa aye ahira ame. ");
INSERT INTO jni_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ma zin tize titi gomo ta Asere, mazi innu dungara abanga ugomo Yeso kiristi sarki ma aye. Daki uye karti me ba. ");
INSERT INTO jni_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","A hira Bulus urere ukaba Asere vana umeme Yesu una kadura ka vana be Asere ma muru ma cukuno unu bezi tize ta Asere ahira an back de sa wa kaba me but ba. ");
INSERT INTO jni_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Aye kuna tize ta ASere ti be runta ahira a vana uka dura ka meme anu nyitike ihori me kasi anu nyetike me ahira Asere aru. ");
INSERT INTO jni_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tige tize me ta suro ahira avana uka dura ka Asere uwatu una kara Dauda mani. ");
INSERT INTO jni_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Barki tize tu meme tini nilem nurunta alem ahira Ogomo Asere uboo anu sa wa ra ahira a meme wa kuna urunta. ");
INSERT INTO jni_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ahira aniza ni vana uwe Yesu wa zauka me nan Bulus wazin ka dura kawe me anyimo aniza nuwe me Ogomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","A nyimo une ugeme, atiti shi i cukuno ahana a Yesu. ");
INSERT INTO jni_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Utakarda ugeme ushi uni sa vat ushi anyimo Roma, ahana Asere, an de sa wa zi lau, ca ti gomo ti cukuno ti shi usuro ahira a Asere aco nan Yesu. ");
INSERT INTO jni_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","In di tubi unu guna izin na puru arum barki imum sa Ugomo Asere ma tuburko vana umeme ma eh duru intize ta Asere une me. ");
INSERT INTO jni_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ugomo Asere sa ma kabi tize tuwe me inzinu wuza ukatuma kageme ini riba lau, ubezizi uti mumum sa ti ribze apuru awe me ayen ina na katuma kawe me inringi shi nyani aye wa wuna. ");
INSERT INTO jni_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Vat uganiya sa inzin biringara ingu, na akini Ugomo Asere ma kunna iriba em barki katuma ka meme, bati ma nyam nikara nu wuza me. ");
INSERT INTO jni_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","In nyara u ira u shi barki inya shi tire tize turunta sa ta wuna, sa ti di kinki shi nikara. ");
INSERT INTO jni_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Unyara um uni ti benki acece aru intize ta Asere barki kati tiperke me inimum sa ma buki duru ti wuzi ini. ");
INSERT INTO jni_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ni henu ida nyaran shi irusi ba, agi in nyara in ezizi ahira a shime, daki ma kem ba u aye ba se aname. In nyara ani me barki in kem re iburi ahira ashi me nan ahira a Yahudawa. ");
INSERT INTO jni_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Me una matara mani vat anikira Yahudawa nan agenu, vat anu urusa nan ababana. ");
INSERT INTO jni_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Barki ani me, ahira am, ma nya nice num ibuki tize ta Asere cagi ahira ashime sa ira uRomawa. ");
INSERT INTO jni_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","I da kuna mu e mu buka ushi tize ta Asere ba, barki ahira ame ani inkezin tere timumu ti riri hira Asere, ya cukuno ka dure kani inbezizi shi nan ande sa wazowe a Yahudawa ba. ");
INSERT INTO jni_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ahira ukuna utize turunta ine ini ya wuna inkenzi nikara. ");
INSERT INTO jni_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A zinu kurzizo iriba ibur ya Sere usuro asesere ahira uzatu tarsa Asere, nan katuma ka bur ka nabu sa wada bowe kadure ba, barki katuma ka bur kawe me. ");
INSERT INTO jni_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Barki imum sa adi rusi barki Asere ada hunzize inini ba ahira aweme, barki Asere ani abezizi we. ");
INSERT INTO jni_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Dati utuba une ti mumum ta Asere ada hira tini ba, ti gomo timeme tizatu mara uni wa hem in timumum sa ma bari arusan tini, barki anime anu wz gawe umuntuno. ");
INSERT INTO jni_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Barki anime anu wa rusan na Asere wa da nonza me ba agi me Asere ani ba, wa da gusa me tanonzo ba, wa nyarama kari muriba mu zatu urusa mu wu maree. ");
INSERT INTO jni_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wazinu gusa we anu rusa wani, wa cukuno ababana ");
INSERT INTO jni_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23",". Wa gamirka urusa wa Asere uzatu wono wa cukuno kasi nipum nu nubo sama di wi, nan inyin, a inama ini ja, nan anu wungo aburu adizi. ");
INSERT INTO jni_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Barki ani not me Asere akurzo ana madini anu woza itimum ti bur, wa cara apum aweni acece awe me. ");
INSERT INTO jni_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Barki ani me wa curo urusa wa Asere nan uzato urusa, wa cara urus Asere ni wa ribi utarsa ane, wa gawe uwuza Asere ninonzo. ");
INSERT INTO jni_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Barki ani me Asere anya we atari ta nu abur, wano wa cari apum aweni inti mumu ti zezen, wa gamari ane aweme wa cukuno ti mumum ti bur. ");
INSERT INTO jni_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","A hana ruma wa ceki umusa nan ane, wa kuri umusa nan ahana aruma, ane nan ahana aruma wa wuzi imum idira umu eh, wa hunguko ace aweme uceki una uhuma. ");
INSERT INTO jni_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Wa ga wa hem wa ruse Asere, Asere aceki we wa wuzi imumu ibur wa wuzi imumu imu eh. ");
INSERT INTO jni_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","We anu zatu uwuza imumu iriri, nan nu wuza imumu izezen, nan nutarsa imumu une, nan nanu uhuza anu, iwa imu cini ini. ");
INSERT INTO jni_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Anu wesi anu nan anu gasime Asere, anu uriza inama acece nan nanu yeze ace, nan nanu zatu tarsa anka aco. ");
INSERT INTO jni_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nan nanu zatu urusa, nan nanu zatu usu unihenu. ");
INSERT INTO jni_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Anu wuza utimumu tiginome umaza une uwe me iwono, azo uwuza utimumu tigino tini cas ba, wa imbizo timaru tanu uwuza me. ");
INSERT INTO jni_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","uhari nicha nu wame gusi ozowa unu umadani, hume unu umadani mani. ");
INSERT INTO jni_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Rosa ingi ugomo Asere machabu unu ahira atimum ma wuza mamarom. ");
INSERT INTO jni_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Hu unubu kati ucari abaga, unize hu hira kusi unda kim ucharin ba. ");
INSERT INTO jni_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kusa wa iza imumba sa ma waza izi gbardang igi ize cin wadi gi ini a nini ina cin me? ");
INSERT INTO jni_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kuse usisikima iriba utarsa ogomo Asere uze ini baba nu za kaba uma. Kati ukara ogomo Asere ukiwa utirze utize ta sere. ");
INSERT INTO jni_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ugomo Asere mamani madi kuro zo kwadi vi imim ba sa wazi inie. ");
INSERT INTO jni_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Andi sa wa nyara aziwa ga tize ta Asere andi zewa uhana iriba imeme. ");
INSERT INTO jni_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Andi sa waze inu him ba, nan disa nyari me, wadi sa wanyari wa ukaba ma wadi gorna unu ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Vat andi sa waze ini mumu izinze, wadi gorona inijisi wa iimumu iboro. ");
INSERT INTO jni_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ugomo Asere madi yaze nu wa cukuno gongo ga inji ma yahudawa ahana malumma. ");
INSERT INTO jni_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","To ugomo Asere madi nyari sime muta achaba. ");
INSERT INTO jni_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Andi sa wa waze imumu unu tama, adi meki wa wa charin gusa ga tize ta Asere adi huki me yadi sa abuka. ");
INSERT INTO jni_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Unu madi suborka ahari imumu izizen sa ma waze ba, saidi ma subarja hara imumu iriri ga uboka ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Inge anu zatu tarsa tize ta Asere wisa da wazin inu weke utize ba, wazin unu weke u tize anyimo aweme ba. ");
INSERT INTO jni_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Imumum sa wa zen inu wazime, izoma imum sa anyitteki ini na anumu amuruba muma, imuma sa wa wazen ira anumu amu roba muwa ma. ");
INSERT INTO jni_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ugomo Asere madi eh ma wazen taze unuweh adumu ani ani izen iti zetigime, tu Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ige hu mayahudawa me, inugona watonu atize ta Asere har uze unu baze unu bora initine ugomo Asere. Urusa imumum sa mahim, inine ugomo Asere sata cikonu inume. ");
INSERT INTO jni_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","urosa imumum sa mahim inine marosa ugamara mame, wanu garimaka me. ");
INSERT INTO jni_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nan nu guna inne kara nu meme unu benki in nanu sa wara anyimo amari mani. ");
INSERT INTO jni_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Mazi unu bara anu, anu rosa a baga, mazin unu bazize we ti na tihuma. Barki wareje kati ire imum iri we aje. ");
INSERT INTO jni_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Hu debe sa bezizi anu ya cukuno uzowe inu bezizi unice nuwe ba? Inu sa ubeziziz tize ta Asere me aki kati awozi nikari hu uda huda wuza nikari me ba? ");
INSERT INTO jni_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Hu debe sa waguna kati a tazi nan uneh besa māzo awe ba hu udawaza weba? hu debe sa utarsa makiri, da wuza we nikari udenge umakiri me ba? ");
INSERT INTO jni_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Hu debe sa utira bigiri unu inko utize abana me daki wa ira ugongo u inko utize ti gomo Asere ba? ");
INSERT INTO jni_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kasi anime sa anyettike unu guna, usoro ushi me anu uzatu urosa Asere wa cami niza na Asere. ");
INSERT INTO jni_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ni rizi, inki utarsa u inko utize. Abanna me inki hu unu u hankirka u inko utize tini, nigbari nizo anyo ire imum ini ba. ");
INSERT INTO jni_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","A unu zati unigbari ma tarsa u inko utize ti Asere, antani, azo adi bassa uzati nigbari ni meme anice nini gbari me ba? ");
INSERT INTO jni_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","debe sa uzati unu gbari utanda ume uni, ayene, matarsa u inko utize tini kuba rep, azo ma huna we ba, hu sa uzin nu inko utize tini kubu me nu nyettike nan nigbari, abanna me u hangara u inko utize me! ");
INSERT INTO jni_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","De be sa mazi uyahudawa utuba azo unu be uyahudawa unu pum a massa ba, nigbari ni tuba nizo nigbari ni uwaa unipum ba. ");
INSERT INTO jni_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","De be sa mazi uyahudawa iriba mani mazi uyahudawa nigbari ni tuba ni raa anyimo iriba ini, in nu guna unu ugunu me utarsa wa Asere ameme wa suro ahira Asere ani. ");
INSERT INTO jni_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Barki ani me nyanini ureh aje a Yahudawa, wan nyanini ukem uwe me ahira ani gbarii. ");
INSERT INTO jni_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Imumu idang ini ko di uya unaa, Utuba me vat, wa hem unu gamirka wa Asere. ");
INSERT INTO jni_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nyanini idi kem a Yahudawa age be sa da wa inko iriba ba, uzatu uhem uwe me udi wuu u inko iriba, i iriba ahira Asere udi cukuno sarki katuma. ");
INSERT INTO jni_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ahira agino Azoni, barki ani me, ca Asere a cukuno duru kadure, ingi unu ma de una umacico, kasi sa anyetirke,”Agu anyimo atize tu meme udi boo kadure, barki uda ken we ma aye ahira atigomo. ");
INSERT INTO jni_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","A, ani me uzatu me ulau urum me wa bezi uzatu ulau wa Asere, Aneni ti di gu anime. Asere azome unu zatu ulau ba, ma da garziz imum ba, nani ma wuza ani me in gusauboo ushe uni wanu. ");
INSERT INTO jni_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kati i cukuno ane ba, ingi ya cukuno ani me aneni Asere adi iri uneeh. ");
INSERT INTO jni_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Barki ani me ingi ma wu macico barki in nonzo Asere ani, a ani me nyanini ya wuna ahiram una ma dinii. ");
INSERT INTO jni_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yani ya karti tigu, kasi macico sa ti boo, aye aw turi agi ta guna -“ca ti wuzini imum ibur, barki iriri eh; i, ya ini iteki duru. ");
INSERT INTO jni_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ti guni, ti suso ace aru a macico mani, tamu guna a Yahudawa nan anu zatu kaba utize ta Asere agi ana madini. ");
INSERT INTO jni_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kasi sa anyetirke, vat unu lau marani ba ko unu inde. ");
INSERT INTO jni_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ba desa ma tinka, ba desa ma nyara Asere. Vat wa gamirka nigura na chmuno sarki katuma. ");
INSERT INTO jni_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ba desa mawuza riri, vat unu gbardan uwe me daki akem unu inde ba. ");
INSERT INTO jni_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","A kwicau awe me a pokino kasi mucau, Alem awe me a boo nacico, Ti kono ti iwa ti ra ama waa ma nyo awe me. ");
INSERT INTO jni_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ti nyo tuwe me ta myinca inti tize ti bur nan tize ti gwangwan. ");
INSERT INTO jni_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ti buna ti weme tizi dibe dibe uhana ahira uka kwanko uma yee. ");
INSERT INTO jni_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Uhuza anu wan uzito une uni katuma kawe me. ");
INSERT INTO jni_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Wa da rusa unah uvenke ba. ");
INSERT INTO jni_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Wa da kunna biyau ba Asere aje awe me ba. ");
INSERT INTO jni_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","A, ana me ti rusa nyanini tize ta Asere ta guna, ta guna vat ande sa wa ra anyimo me, ca wa impi ti nyo tuwe me, vat uneh udi eh atari ta Asere. ");
INSERT INTO jni_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Da a ira desa madi suburka Asere badki utarsa utanda, ahira utarsa utanda aka kem urusa imum imadini. ");
INSERT INTO jni_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","A, ana me barki utanda ugino uni akem una urusa Asere, Anu kurzizo tize ta Asere wan agomo utanda wa ziki ani me. ");
INSERT INTO jni_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ubenki wa Asere ugino me sa akenzi ahira u inko iriba ahira a Yesu barki vat ande sa wa hem ubezi usassas uzoni. ");
INSERT INTO jni_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Vat anu wa rizi, wa siziki we ahira Asere. ");
INSERT INTO jni_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Barki ugogoni wa Sere ma cekin duru usuro u vana umeme Yesu. ");
INSERT INTO jni_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Asere a wu Yesu ma cukuno una ti cukun ti runta barki unya iriba in mayeh ma Yesu sa ma igizo, ma wuzi ani me barki ma bezin duru ubari umeme, barki iriba ishew imeme ma vete vat imum me sa awuzi adumo. ");
INSERT INTO jni_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Barki ma bezi ubari umeme atiye ti kani, abezi me ni ceh nu meme mabari, unu bura u vat ande sa ma kaba makuru ma hem in Yesu. ");
INSERT INTO jni_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","U bezi uru me uraa, imumu iziba, A hira anyanii, katuma, kodi, sede ahira u inko iriba. ");
INSERT INTO jni_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ta mara unu guna, unu ma bari u ira Asere barki katuma kame se unu inko iriba ahi ra Asere. ");
INSERT INTO jni_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Nani Asere me Asere a Yahudawa ani cas, Da Asere an desa da wa mu kaba tize ta Asere: Ane ani, Asere anu zatu kaba Asere ani cangi. ");
INSERT INTO jni_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ta buna utanda ugino me barki be u inko iriba me? kati icukuno ani ba, barki anime ta hem unu tanda me. ");
INSERT INTO jni_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Igusa agi u inko utize me ura anyimo ukadure kani? ida cukuno agi wa canti u inko utize ba. ");
INSERT INTO jni_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Nyanini tidi gu ahira ucokoro acokoro aru Ibrahim. ");
INSERT INTO jni_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Agi Ibrahim ma suburka barki katuma kame kani mada zome ini mum ubezi ubari, ani me ahira Asere. ");
INSERT INTO jni_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nyanini tize be ta Asere ta guna, Ibrahim ma hem ina Asere, abati me unu hem in tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","De sa ma zin jatuma ka geme ahira anu nyanki be e imum, imum sa adi nyanki me ane ani barki katuma kame kani sz ma wuza. ");
INSERT INTO jni_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","De sa ma da wuza katuma barki anya me iri imum ma hibina ahira Asere, de sa ma sobiso ande sa wa wuza imumu iburi, aka bura me nyimo anu inko utize ta Asere iriba. ");
INSERT INTO jni_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ane ani Dauda ma buki ani ceh ni desa Asere abati me anyimo anu iso utize tume a mu riba mu we me barki ada nya we iri mum ba. ");
INSERT INTO jni_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Sa ma gu, anu inko tize ta Asere amu riba mu we madini mawe me aveteni, akuri avisa vat madini ma we me. ");
INSERT INTO jni_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Imum irum irunta ihuma ande sa Asere mada bata me anyimo ana madini. Adi basa ti mum tihuma ahira adesa da Asere akem me in madini ba. ");
INSERT INTO jni_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","A wuza imumu iriri ahira ande sa wa kaba tize ta Asere ba nani vat nan andesa wa kaba ba, imum be sati boo, abata imumu ihuma ahira Ibrahim barki uhem wa Asere ame ani. ");
INSERT INTO jni_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Uya una uni abati me nii, sa amu zina agbara me nani daki a u gbara me ba, nani da amu wuza me ba. Da amu wuza ba. ");
INSERT INTO jni_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ni gbari sa awuzi me barki a bezi kadure kameme kani, barki unya iriba imeme uganiya sa da amu wuza me nigbari me, Aani me barki ma cukuno acoh anu nya iriba, barki ma basa we anyimo anu unasa ace, ba sede awuza nigbari me. ");
INSERT INTO jni_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","A ani me ma cukuno acoh ana nigbari, ande sa da sa nigbari nini wazini cas ba, wa tarsa una ukadure cangi ku cokoro uru ugino me Ibrahim, sa da azi amu wuza ni gbari me ba. ");
INSERT INTO jni_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Imumu igino sa awu Ibrahim iriba, agi madi kem uneh azo se a iso me tize barki sa ma nya iriba, ine ini Asere akabi me. ");
INSERT INTO jni_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ingi anu tarsa u iso utize wadi cukuno ahuma, ani ya cukuno uwuna iriba uzome in katuma in tize ti gino me ta cukuno uzatu katuma. ");
INSERT INTO jni_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Barki u iso utize ti gino me ti hirziza Asere iriba ahira me sa u iso utize uzoni, imumu iburi izoni. ");
INSERT INTO jni_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ani me ani u inko iriba wa hibinani, ani me barki abezi uhem wa Asere, barki arusi unu nya iriba Ibeahim da agi ande sa wa ra una udungara u musa cas, nan ande sa wa inko mu riba ugusa Ibrahim ma wuu. Ibrahim ugino me memani ucokoro uru va. ");
INSERT INTO jni_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kasi sa anyetirke agi, ma wu a we ucukuno acoh ati lem vat, Amyinca tize ti gino me Ibrahim ucokoro uru mani ahira Asere de sa ma nya iriba ahira ame, me mani unu bari ma titi timum sa ti zo ba nan tige sa ti zii. ");
INSERT INTO jni_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Uwuna iriba Ibrahim izi gusi izome in katuma ba, vat ani me ma ri aje unu wuzi riba ni, ma isi iriba ni manno ma cukuno acoh ati lem gbardan, a anime barki sa awuzi me tize ta bangame,”ane ani bi sana buwe me bidi cukuno. ");
INSERT INTO jni_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Uganiya me Ibrahim ma zin ti weh ni ino (100) da ma wuna seke anyimo u iso utize ta Asere iribame, barki ma hira mazin ni kara ani pum numeme vat unu guna ma mu unah, wannu guna Saraya uneh umeme mamu aka uganiya u yoh. ");
INSERT INTO jni_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Da ma kem mare ma aye ba ubuka Asere abezi uzatu u inko iriba, ba ma kinki nikara anyimo u iso iriba sa abuki me agi,”Ane ani bisana bi we me bidi cukuno. ");
INSERT INTO jni_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ma hem anyimo iriba meme vat i um sa Asere ma buki ani ceh numeme idi cukuno ani me. ");
INSERT INTO jni_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ani me vat ya cukuno me imumu u iso iriba. ");
INSERT INTO jni_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Vat ani me sa anyetirke da anyetirke barki Ibrahim mani cas. ");
INSERT INTO jni_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wan haru cangi haru ande sa ta hem u u hirza u Yesu anyimo iwono. ");
INSERT INTO jni_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yessu, desa anya me barki madini maru, akuri ahirza me barki ti kem u biki ahira Asere. ");
INSERT INTO jni_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","A zorson duru in kadura, ta cukuno man nan Ugomo Asere nan niza ni vana Asere Yesu unu kaba uru. ");
INSERT INTO jni_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Usuro ume uni ta kem ka dura ku runta sa ti turuni. Ti zini riba irum, barki imum be sati bee mazu ma Asere. ");
INSERT INTO jni_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Azigino cas, ti kuna urunta ijasi me but sa ti zin. ");
INSERT INTO jni_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","U inko iriba u eze unu re aje, u re aje uze ini riba irum imum be sa udu wuzi. ");
INSERT INTO jni_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","U inko iriba uda wuza unu urii, barki u inta Asere be sa mara iruba iru me anyimo abi be biriri bi ge sa anyan duru. ");
INSERT INTO jni_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Uganuya sa ta ra amare a uganiya be uni unu kaba uru ma wi, barki ande sa wa ra amare. ");
INSERT INTO jni_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Idi cukuno ijasi ini ingi uye ma wi barki unu be sa ma tame tize ta Asere. in hira uye mada wono barki unu uriri mani. ");
INSERT INTO jni_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ine ini Asere abezi ukaba urume, sa ta zi anu cara abanga, unu kaba uru mano ma wi barki haru. ");
INSERT INTO jni_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Imum idang me, akaban duru anyimo amaye mame, ine ini idi wu ti kem uribi ahira Asere. ");
INSERT INTO jni_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sa ta zi anu ishina tino ta barka nan Ugomo Asere ahira iwono i vana umeme. ");
INSERT INTO jni_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Azo agino ani cas ba, tizi ini iriba urum ahira Ugomo Asere uru Yesu unu kaba uru. ");
INSERT INTO jni_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Sa unu inde mani ma cari abanga age besa aribe uneh, abine ani iwono ya ribe ucara abanga iwano ya ribe anu vat, ahira ande sa wa cari tize vat. ");
INSERT INTO jni_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","U inko utize wazi, ucara utize wa rani, ucara utize uzoni inki daki u inko utize uzoni. ");
INSERT INTO jni_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Sa azi anime, iwono ya ra anice na Adamu, Musa mada sarki u aye. Ta ra ani ace nan debe sa daki wa cari abanga gusi Adamu me sa wuzi udirz u i ceh, ahira u u ge sa mara una u aye. ");
INSERT INTO jni_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Sa izi ani me, u nya imum ini riba ka inde, azo ucara utize tini tizi ba, ingi ucara utize idi hunguko anu gbardang iwono ya cukuno uguna, urunta Ugomo Asere nan imum be sa ya nya we mazu mu runta unu inde, Yesu Asere, ma cukuno pash Asesere anu gbardang ikuri i iki ani me ");
INSERT INTO jni_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","U nya imum igino me izome gusi ti mumu tanu cara abanga, iri guna ani me, uweki utize, wa aye ahira anu cara utize ahira unu inde. U ira uguna wa rusa, imun ukem unu ugino uni wa wu tikem usuro atar ta Asere. ");
INSERT INTO jni_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ingi ucara utize tinu inde tini ya wuna iwono ya kem ahira ati cukum, ana ge be sa wa kem mazu me, nan imum igino me sa unu inde ugino ma kem ini anyi o aniza ni Yesu unu kaba uru. ");
INSERT INTO jni_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Sa, ucara utize tinu inde ugino mani wa wu aweki tize, ahira unu ugino wa wu anu wa kem una u venke. ");
INSERT INTO jni_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Gusi unu inde ugino sa ma wuzi udira unice, anu gbardang wa cari tize meni ahira unu inde ugino me wadi kem uribe Asere. ");
INSERT INTO jni_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A soki u igizo utize ti gino me barki ucara utize uwu gbardang, ahiran me sa ucara utize urani, ahira me ani tize ti riri ta tekin ungbardang. ");
INSERT INTO jni_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Gusi ucara utize wa cukuno iwono, ane ani Asere ma tarsan haru uhana uvenke uzatu umara anyimo Asere unu kaba uru. ");
INSERT INTO jni_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ani ti gu ani, tidi re aje unu cara abanga me ni, tize ta Asere ti en duru. ");
INSERT INTO jni_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kati i cukuno ani me, haru sata mu wono a yimo ucara abanga tidi kuri ti cukuno anyimo mee. ");
INSERT INTO jni_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ita shi guna anu gbardang azoro we anyimo aniza ni Yesu Ugomo Asere, azoro we barki iwono ime ini. ");
INSERT INTO jni_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","A vete duru nan me ahira uzoro iwono imeme ini, sa ma hiri icau, barki ni kara na co, ine ini ya wuna ti haka anyimo atanu tiso. ");
INSERT INTO jni_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Inki ti haka nigo me nanme ahira iwono imeme ine ini tidi cukuno a inde nan me barki uhira umeme. ");
INSERT INTO jni_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Sa ti urusa anu me, abaki ucara abanga anipum niru me nigo nan me, barki asopi abanga ubura apum arume, awu ani me kati ti cukuno arere. ");
INSERT INTO jni_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Inki unu ma wono makem nikara asesere ucara abanga. ");
INSERT INTO jni_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","In ki ta wono nigo nan me unu bura uru tidi cukuno nan me. ");
INSERT INTO jni_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ti rusa, ahirza Yesu anyimo icau, mada kuri ma wii, barki iwono izo me inikara asesere ame ba. ");
INSERT INTO jni_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Sa ma wii, ma wii ka inde kani cas sarki ukinkini, ana me maciki ti cukum ta Asere tini. ");
INSERT INTO jni_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ane ani shi me idi ziki ace ashime gusi mu kizi muni ahira ani kara nu cara abanga, shi be anu vingizi wani ahira Asere unu kaba sa Yesu. ");
INSERT INTO jni_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kati ikabi ucara abanga ucukuno shi apum sa idi wiji, kati itarsi myai maje imu be sa idi hunguko muriba mushi me. ");
INSERT INTO jni_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kati iziki ti hihira tishi me iwuzi katuma ki mumu izenzen, agino me nya na ace ashi me ahira Asere, ya wuna reb unu kara me atari ti iwono uhana ukem uvengize, ikuri iwiti tihihira tishi me ahira Asere barki katuma ka huma. ");
INSERT INTO jni_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ucara abanga uda cukuno me ace ashi me, sa ida rashi anyimo ubezizi utize ti Musa ba, irani anyimo urunta Asere. ");
INSERT INTO jni_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Nyanini ani me, barki ya cukuno ti cari abanga ni barki ubezizi utize uzome ini kara ace aru me ba, barki urunta Asere? Azo me ani ba. ");
INSERT INTO jni_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ita shi uguna inki ya nya ace shi me ahira uye idi cukuno arere unugino me, nani icukuno arere ucara utize, imum sa idi han shi iwono, nani icukuno arere Asere sa madi han shi iwuzi imumu iriri. ");
INSERT INTO jni_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Barki ani me, ninonzo na cukuno ahira Ugomo Asere, sa yazi anu cara abanga wani, ana me izinu tarsa vat iriba shi me usasa na ubezizi imum be sa irani anyimo ini. ");
INSERT INTO jni_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Azauka shi anyimo ucara abanga, ya cukuno arere urunta. ");
INSERT INTO jni_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Inki inboo shi tize tigeme gusi unubu mani, barki ani me usiziki me ushi me unipum u i gusi uzina sa yazi iwiro ti hihira ta pum ashi me ahira unya ace imum izenzen nan nu wuza imum ibur ige be sa ikingizi, ane ani idi witi tihihira ti shi me, ahira u nya ace urunta barki icukuno ande be sa wazi lau ahira Asere. ");
INSERT INTO jni_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Uganiya sa yazi arere ucara abanga, yazo shi myai in katuma kurunta. ");
INSERT INTO jni_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Nyanini ya kem ahira imum be sa be ya cukuno imum mu eh, u maza imum igino me iwono ini. ");
INSERT INTO jni_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ana me azauka shi usuro ucara abanga, ya cukuno arere Asere imum sa ya kem ine ini ya hanan shi ati cuku m ti lau, tige be sa ta nya shi ti cukum ti zatu marsa. ");
INSERT INTO jni_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Imum sa udi hiri ucara abanga iwo o ini, imum be sa Asere anyawe, ine ini ti cukum ti zatu marsa ahira unu kaba uru Yesu Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Shi ni henu, ita shi inzin tize nan ande sa wa rusa u'inko utize vat unu un uvengize u'inko utize wa cukuno imum iwuza. ");
INSERT INTO jni_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kasi vanaa u'e wa anya, ubara utize wa tirza me ahira uruma umeme inki mavengize. Inki uruma umeme ma wono, ma suro ani zin na nya. ");
INSERT INTO jni_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","A, anime, inki uruma me ma vengize ma wuza anya nan uye atiti me une utarsa ahanaa aruma. Inki uruma me ma wono, ma suro ani zin na nya mada ke ma wuzi are anya. ");
INSERT INTO jni_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","A, ani me nihenu, ya cukuno anu wujo anyimo ubara utize ani pum ni ugomo asere. Barki ani me ya cukuno apum a'inde nan desa ahirza me iwono, barki ti nya ugomo Asere imum ihuma. ");
INSERT INTO jni_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Uganiya sa ta rani anyimo anipum abanga ati mumum tu unee areki acece aru anyimo me, i ne ini yaa hunguko duru iwono. ");
INSERT INTO jni_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ani me asuzon duru anyimo u'inko utize. Ta wi aseser imum me sa ya tiri duru. Barki ti nonzo Asere anyimo abi be biriri bi soo daki u'inko utize tikuzu sa anyertike ba. ");
INSERT INTO jni_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Nyanini ti di buki nani u'inko utize me imum ima dini mani? Ane ani, i da cukuno inda rusa me imum be sa izi ima dini sarki u'inko utize ba. Inda taa me ni'eru, sarki u'inko utize ba, u'inko utize wa gu kati ti wuzi ni'eru ba. ");
INSERT INTO jni_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Barki anime madini ma kem ana tukum ahira u'inko utizee ine ini ya ayen unu rizo ahira am. Gusi sarki u'inko utize ba madini mada cukuno iwono ini. ");
INSERT INTO jni_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ure uganiya sa mazi unu uhuma mani sarki urusa u'ingizo utize, sa ma rusa uwuza imum iriri, madini ma cukuno ma huma mi induku wi. ");
INSERT INTO jni_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Kadura ka Asere sa kazi kadi nyam uvengize ka cukuno iwono ahira am. ");
INSERT INTO jni_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Madini ma kem ana tukum usuro u'inko utize, ma dusa ma ragizum. Usuro u'inko utize wa bezum iwono im. ");
INSERT INTO jni_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ani me, u, inko utize urizi lau, nan unu inko utize me uzi lau, rep nan unu rii. ");
INSERT INTO jni_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Uwuza imum ihuma, idi hungukom iwono? Kati i cukuno ani me, madini mane mani ma cukuno imum izenze madi bezi nice ni mani a hira uwuza imum me sa irizi, ya ayen ini wono ani ce num usuro u'inko utize, madini madi cukuno izeze sarki imum ubata. ");
INSERT INTO jni_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ti sa rusa u'inko utize imum ibibe ba Asere ini, mi in ra ani pum, m a ziza nice num anirere ni madini. ");
INSERT INTO jni_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Daki ma rusa imum be sa inzini wuza me ba, barki sa daki imum be sa ma inko iriba ini inzini uwuza me ba. ");
INSERT INTO jni_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Inki imum be sa inda nyaram ini, ine ini inwuza, ma hem innu inko utize imum ini iriri. ");
INSERT INTO jni_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ana me, daki mi mani in wuza ba, madini mani sa ma ra anyimo am. In rusa daa imumu ihuma ya cukuno ani pum nim ba. ");
INSERT INTO jni_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","In nyara in wuzi imum ihuma. Daki ma ken ace uwuza me ba. ");
INSERT INTO jni_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Imumu ihuma me sa ma inko iriba in wuzi, daki ma wuza ba, imum izenze me ini sa inda nyara in wuzi ba ine ini in zini wuza me. ");
INSERT INTO jni_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ana me ingi ma wuna imum be sa daki ma nyara in wu ini, ya cukuno daki mi mani ma wuna ini ba. Madini mani sa ma raa anyimo am. ");
INSERT INTO jni_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","In ke basa anyimo iriba im in guna in wu imum iriri, ikem izenze ini ma wuna. ");
INSERT INTO jni_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","In kunna urunta utize ta Asere nan unuu me sa ma raa iriba im. ");
INSERT INTO jni_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ma ira tire ti mumum anyimo am sa ti zin in nikono nan ti mumum ti riri anyimo iriba im. Yaduku sokum anyimo ani rere imum imadini sa ira ani pum num. ");
INSERT INTO jni_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mi unu mani sa inda zom iri imum ba. Barki ani me aveni madi benkum ma karti iwono ini pum ni geme? ");
INSERT INTO jni_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ma wuna iriba irum unu ugomo Asere usuro UYesu barki ani me indi tarsi tize ta Asere anyimo iriba im. Anyimo ani pum in tarsa timumum ti madini. ");
INSERT INTO jni_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Barki anime ukasu aka rizo urani ba, ahira andesa wa tarsa bibe Asere Yeso. ");
INSERT INTO jni_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Barki u hani ubibe bu vengize anyimo abibe Asere Yeso ma kurzo, duru tize andesa a susuwe anyimo amadini ahira amadini nan ni wono. ");
INSERT INTO jni_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Anime imum besa tize tini kabbo daki tize tihuna tini inko ba barki usisi kirme anyimo ani pum, Asere atumi vana ume in mu hinu mani pum ni madini barki ma nya nice nume barki madini ma wozi Asere anya imadini anyimo anipum. ");
INSERT INTO jni_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ma wo anime barki imum sa nayar ini atize tini ku boo ti kem umyinca anyimo aru, haru sa ti haka idaki ani pum ba, anyimo abibe bi ririn ba Asere. ");
INSERT INTO jni_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Anime sa wa ciki anyimo apum wonno wa hiri timumu ti nipum wa wuzizi ki ziziki itini, ani gisa wa haki ahira abibe biririwa kurzo mu reba muwe me ahira abibe bi riri. ");
INSERT INTO jni_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Desa ma inko iriba anipum unu wuna ma ni inko iriba abibe ba Asere uvenke nan ni iriba ishew. ");
INSERT INTO jni_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Anime ani desa ma inko iriba annipum ishina ini mazin nan na Asere, mada tarsa me u inko utize ta Asere, nani marusi. ");
INSERT INTO jni_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Adesa warani anipum wada rumza ugomo Asere iriba ba. ");
INSERT INTO jni_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Vat anime, izoshi anyimo anipum ba irani anyimo abibe, inki kadura kani, bibe ba ASere bi ciki anyimo ashime. Anyimo asime desa mazo me be bibe ba Asere ba me azo ume mani ba. ");
INSERT INTO jni_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Inki ugomo Asere mara anyimo aweme ni pum nuwe ni iririni ahira madini, abibe kizi ahira uni riba iriri. ");
INSERT INTO jni_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Inki bibe bi gisa hirza Yeso anyimo a mu cau bi kizi anyimo ashime, me desa ma hirze Yeso madi nya uvenke anipum ashime ani wuno usuro ubibeu, sa ma kizi anyimo shi me. ");
INSERT INTO jni_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ni henu inzi ni mum ibuka in daki anyimo a pum ba, sa indi wuzi anyimo utarsa u ni pum. ");
INSERT INTO jni_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Inki ya wuza ti cukum ahira ani pum, in we anime, inki ahira abibe ihuza bi wuza-wuza bini nipum, indi vengize. ");
INSERT INTO jni_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Vat andesa bibe ba Asere bi tarsan in we vat wuza bini nipum, indi vengize. ");
INSERT INTO jni_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Indaki yakaba bibe beni nonzo sabi bi biyyau ba. Barki anime, yakabi bibe icukuno ana indai, ahira ameme ani ti yeze agmirang ti tisa inni kara, ''hu aco uro.'' ");
INSERT INTO jni_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Wa wuna manya u impo amaru nigo nan bibe innu guna haru hana Asere wani. ");
INSERT INTO jni_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Inka haru ahana Asere wani, haru anu kaba wanni, anu kaba Asere. Haru me anu kaba wani nigo nan nu ugomo Asere, anime ani ikatasa nirere nigo nan me ade kure a nonzoko duru nigo nan me. ");
INSERT INTO jni_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ma wuze ugun guna kasi inu guna uzatu ti we tigeme indaki wa bare abati uni nan ni nan sade be zen duru. ");
INSERT INTO jni_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Barki bibara ba Asere bizi nu nyara bi iri uboka ahana Asere. ");
INSERT INTO jni_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Atuzu ugungu ubi bara bara ba Asere, asume ini reba ime ba, ani anime desa matuzu ugungui me, marani ahira anu tarza utize. ");
INSERT INTO jni_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","In nu guna ubarka uni me ini ce nume wade kem usuro anyimo ani nunzu niwe chi, ade eye iwe inu nonzoko ugungui wahana Asee. ");
INSERT INTO jni_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ti rusa ubarka wa Asere uni uni vat uni u erino wanu pazeza uya ingo nan uhana ukani me. ");
INSERT INTO jni_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Indaki anime casi ba, nan ni haro me ace aro me, sa tizi uhina waje ubibe haro ace aro me tizizn inu ezu anyimo aro, ti zin inu be ukaba uro me, uni uni uvike wa pum aro me anime. ");
INSERT INTO jni_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ahira u nya ace aro a nyanduru u vigi uro me, ana me inmum bisa tizen in nu hira kasi ide wu indaki ta mu ira eniba barki u eye mani maka insu aje innu guna ma ire kadure ka ini in hira. ");
INSERT INTO jni_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Inka tizin kadura ki mum sa daki ta ira eni ba, kini ti nyargi ini inireba ishew. ");
INSERT INTO jni_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Anime ani, bibe bezin innu benki uru u nisi ziki me niru me, ana me ti data duru ane ani ti di wu biringara ba, ane ani bibe me inice nume mazin innu tira utari barki haru me nan nu ezu nan nu ezu sa adaki abuki u gbardang uni ba. ");
INSERT INTO jni_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Me sa ma nyara iriba marusa ini ireba ibibe ba Asere, barki mazin innu tira utari barki anu utize ti kadura ahira ubasa umeme. Ugomo Asere me. ");
INSERT INTO jni_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ti ruzan innu guna anigebe wazin in mu ruba ma gbindriko uni henu ugono Asere, maka wuzi tire timumum barki weme, uhana ukem imum iriri u hana vat andesa adi titi we barki ubasa umeme. Vat u timum tini bati cukuno imum iriri. ");
INSERT INTO jni_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Barki anime ani andesa marusi ubasa u muruba mu we ma wu wa cukuno ini mum kang unu henu nu vana ume, barki ma cukuno vana u tuba anyimo ani henu ni gbardang. ");
INSERT INTO jni_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","We sa ma ziti inu titi we, ana gesa ma titi we, ma gminca we, ana gesa ma gminca we. We wani ma wu we gongon. ");
INSERT INTO jni_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Nyanini tidi gu ini nan ni mum igino me. Inka Asere azi nigo nan haru aveni madi wuzi ishina nan haru? ");
INSERT INTO jni_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Me sa daki ma kartin vana ume ba, ma nya me barki haru vati, nyanini idi karti u nya uro timumum boo nigo nan me? ");
INSERT INTO jni_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Aveni madi en in tire tize tu ja ginka abanga ahira ahana Asere, ugomo Asere mani ma gmyinca ahana ame. ");
INSERT INTO jni_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Aveni madi ma tirizi unu? ugomo Asere sa ma wii barki haru ma wuzi ama aki anime mi unu ge besa ma hirsa me, mazi iti gomo nigo nan Asere ahira a gongon. Me mani mazin nu tira utari barki haru me. ");
INSERT INTO jni_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Aveni madi harim duru nan ni riba ishew ya Asere? uzatu uganiya ucukuno me iriba, uzito nan nu kunna apum nani udira imum, ubebeti a uvira? ");
INSERT INTO jni_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kasi inda be sa anyettike, ''barki hamani azin unu huza uru vat ani hiri a kurson duru kaniya itam azinnu wesi me?'' ");
INSERT INTO jni_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","U vat u timumum ti geme ti tekin ini kara agu haru ta kem maroo ahira ameme sa matarsa haru in ni riba ishew. ");
INSERT INTO jni_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","In anime ma ira kadura in nu guna nani iwe ini nani uvigizi nani uhana akatuma ka meme nani tigomo, nani timumum ti ana me, nani timumum tige be sa ti eze nani ni kara. ");
INSERT INTO jni_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Mani ujuko, nani uconcong unice nani iri imum ubari umeme daki wa bari wa harin duru wanu tarsa iriba ishew ugomo Asere, sa mara anyimo ugomo Asere Yeso ugomo uru ba. ");
INSERT INTO jni_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ma buka shi kadundure anyimo ani za ni kiristi, inda boom macico ba, iriba im ibezizim imum ibibe biriri. ");
INSERT INTO jni_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ami, inzin ina puru abit wan unu pazaza iriba izatu umarsa ");
INSERT INTO jni_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Barki mi, unyara um acari mini sarki. Yesu nan anu henu um an desa wazi am, anyimo amagasiya mani pum. ");
INSERT INTO jni_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Wee wani A'israila wa hem unu rii nan innu u'inko utize wan unu nyanki ubara utize nan ninonzo ni ugomo Asere kasi inda sa ma ziki. ");
INSERT INTO jni_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ani lem niwe nini Yesu ma suri nin, ugomo Asere maa wu we ni lem ni riri. I cukuno ani me. ");
INSERT INTO jni_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Barki ani me ida zoo gu tize ti ugomo Asere ta rizo ba. Daki vat desa ma raa a usraila ma cukuno u'israila ba. ");
INSERT INTO jni_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ane ani daki vat bisana bi Ibrahim wa cukuno ahana ame ba. Usuro u Ishaka adi ku guna bisana bi shi me ba tubusa ni. ");
INSERT INTO jni_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ane ani ahanaa ani pum wa d a zo we ahanaa Asere ba. Ahanaa ubarka utize we wa cukuno bisana bi meme. ");
INSERT INTO jni_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ane ani ubarka utize me wa cukuno. Uganiya ugeme indi e in nya Saraya vanaa uruma ");
INSERT INTO jni_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Daki ane ani cas ba Saratu ma wuu apuru nan ure unu sa ma cukuno acoo aru me mani Ishaku. ");
INSERT INTO jni_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Daki amu yoo ahana me ba nani agu wamu wuza imum iriri nani izenze, bati unyara ugomo Asere udi cukuno abizauka, daki ahira akatu ma ba, idi cukuno ahira adesa ma tita duru. ");
INSERT INTO jni_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Agun me unanu me madi wuzi unu uneze umeme ni rere. ");
INSERT INTO jni_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ane ani anyerttike, “ma hem in Yakubu ma nyaru in Isuwa”. ");
INSERT INTO jni_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Haru tiku gu nyani ni? Ure usizikime ahira Ugomo Asere urani, ka iwu ani me ba haa. ");
INSERT INTO jni_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ma gun in Musa “indi kunna desa indi kunna me, indi ori desa in kunna urunta ume.” ");
INSERT INTO jni_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ane ani, daki barki unyara ume ba, nani usum ume ba, barki Ugomo Asere desa mabezi usheu. ");
INSERT INTO jni_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Tize ti Ugomo Asere ta gun in Fir'auna, barki imum igeme ma yeze we bati in bezi nikara ahira awe me, bati niza num nikuri, ni ribe anyimo une vat. ");
INSERT INTO jni_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ane ani Ugomo Asere ma kunna ugogoni udebe sa ma zauka, uye wu me ma cukuno gbas. ");
INSERT INTO jni_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Idi iki ni mi igu, “nyanini ya wuna ugomo Asere ma nyara ukem usiziki anice na nu?”, aveni ma dake ma ri nikara ni ruba imeme? ");
INSERT INTO jni_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","A ure uhira, hu aveni sa wa bari uvovi bigiri nan Ugomo Asere? Adake akem imum sa uye ma bara i gun desa ma bara ini “nyanini ya wuna wa barkam ani me?” ");
INSERT INTO jni_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Nani unu bara umuharu muti nyanga mada zoo me in nikara inguna ma wuzi katuma ku ira iriba imeme ba. Mada ke ma barka imum iriri nan izenze. ");
INSERT INTO jni_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nyanini idi cukuno, inki me ugomo desa ma nyara ma bezi ucornome iriba imeme ma bezi ubari umeme amasaa. ");
INSERT INTO jni_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Anyimo ani me make ma natti iriba kang ahira ubezi ucorno me iriba sa i bee uhuza anu ahuma? nyanini idi cukuno, inki ma wuza imum igeme bati ma bezi ninonzo ni meme anice ni iriba ineze imeme ahira ani nonzo ni meme. ");
INSERT INTO jni_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Nyanini, inki ma wuza imum igeme barki haru, de sa ma titin duru haru sa tida zo me Ayahudawa, haru andesa wazi ana madini. ");
INSERT INTO jni_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kasi inda be sa ma buka anyimo unyertike uHosiya unu guna “An de sa wa zowe am wa cukuno am, anu me sa ma gam we in gu ma hem in we”. ");
INSERT INTO jni_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Rep, ahira me sa aguna wa zoo we am, abini me adi gun we ahana Asere. ");
INSERT INTO jni_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ishaya maa poki anyo abanga anu U'israila ma gu, “inki anu u'israila wa cukuno gbardang kasi bikiki bi uraba udang, ukasu uni adi buri we”. ");
INSERT INTO jni_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Sarki udondonkino Ugmo Asere madi wuzi katuma ka meme anyimo unee vat ma mari. ");
INSERT INTO jni_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ishaya ma kuri ma buki “sarki Ugomo Asere unu bari ma ceki bisana adumo barki haru ba, tida cukuno gusi Usodom tida zina kasi Ugomora.'' ");
INSERT INTO jni_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tiduku guna nyanini? ana madini me sa daki lau ba, waye wa sana, ukem ulau barki uhem wasere. ");
INSERT INTO jni_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","A Israilawa sa wa wuzi morso mu nyara tarsa una uriri wasere, daki wa kem ba. ");
INSERT INTO jni_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nyanini ya ayen ani me? barki daki wa nyari ini iriba i inde ba, yaa cukuno ahira atuma kani. we wonno wa pilliko ani poo nu wuza upillizino. ");
INSERT INTO jni_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kasi unyertike utize tu ugomo Asere ta buka “mi be ma nukka nipoo Usihiyona, nipoo nupilko sa nidi wuu anu wa rizi. Vat desa ma hem mada kunna me mu'ii ba.'' ");
INSERT INTO jni_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Anu henu um, unyara iruba in nan bi ringara bum Asere barkiwe ine ini barki wakem ubura. ");
INSERT INTO jni_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Barki manya tize awe agi wazin nu inko iruba Asere, anime daki u rusa ba. ");
INSERT INTO jni_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Wazo me in nu rusa imumu ihuma ya Asere wa inko ace imumu ihuma iwe. Dakawa nya ace awe imumu ihuma ya Asere ba. ");
INSERT INTO jni_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Abine me Yeso me mani umyinca imum iriri uhana andesa wa hem. ");
INSERT INTO jni_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa ma nyettike ahira imumu ihuma sama kem uweki utize tini kubu, ''unube sa ma wuza imum ihuma uweki utize tini kubu, madi huma ahira imum ihum.'' ");
INSERT INTO jni_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Anime imum ihuma ya ē ahira u hem uni, ''kati igu amu ruba mu shi, aveni madi nyene uhana asesere?'' (Barki ma tuzo Yeso adizi). ");
INSERT INTO jni_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Kati igu, ''aveni madi tu uhana adizi?'' (Aveni madi surni Yeso iwono). ");
INSERT INTO jni_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Anime nyani magusa? ''Nigura me nizi mamu nan hu anyimo anyo aweme nan ni rubu iweme.'' Nigura nu hem, nigebe sa tiboni. ");
INSERT INTO jni_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Barki inki wabuk inna nyo aweme, Yeso ugomo mani, wa hem iruba iweme agi Asere a hirzam anyimo iwono, udi kem ubura. ");
INSERT INTO jni_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Barki in ni ruba unu ma henzi uhana imumu ihuma, in na nyo ani unu ma boo uhana ubura. ");
INSERT INTO jni_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Barki tize ta Asere taguna, ''vat desa ma hem ni madi da kunname mu i ba.'' ");
INSERT INTO jni_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Abanna me usassas urani atii uyahawa nan unu zatu tarsa Asere. Abana me vat uwe ugomo Asere u inde mani awe, me unu kem mani uhana adesa vat matita me. ");
INSERT INTO jni_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Vat desa ma tita ni za nu gomo Asere madi kem ubura. ");
INSERT INTO jni_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Aneni wadi titi deba sa daki wa hemin mw ba? ire wadi wu ane ni wahem in desa daki wamu kunna iri mum ame ba? ");
INSERT INTO jni_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Aneni wadi wuzi tize me, inki daki atuma we ni ba? kasi sa a nyettike agi, ''aneni idi cukuno anu aye intize me!'' ");
INSERT INTO jni_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Anime daki vatti ni wakaba tize maba. Ishaya cangi magu, ''ugomo Asere aveni ma hem in tize tiru?'' ");
INSERT INTO jni_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","A anime uhem u eze ahira ukunna ukunna me usuro utize ti Yeso. ");
INSERT INTO jni_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Anime ingu, ''nani daki wa kunna ini ba? ē, rep'' ni myiran nu we nasa mirka unee vat, aguran awe abiki uhana ubinani unee.'' ");
INSERT INTO jni_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Kani maguna, ''nani isaraila watawe niba?'' u tuba musa magu, ''indi wushi i wu iruba nan ni eru nan ni mumbe sa daki anabu ba. I mumbe sanbasa a banna me ine ini anabu sa wa zome innu rusaba, indi wuzi katuman we in hirza shi muruba.'' ");
INSERT INTO jni_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ishaya in ni ruba ihu magu, ''andesa daki wa nyaramba wayen ne wa kem. Ma aye ahira andesa daki wanyaran ba. ");
INSERT INTO jni_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","A isaraila maguna, ''mawito tari tum ahira anu anu zatu ukunna vat uhana u ka rizo wui, barki we anu wani gbas.'' ");
INSERT INTO jni_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Indi iki, nani Asere anyarizi me anu ameme? Idake icukono ani ba. Mi unu Uisraila mani bisana bi Ibrahim, ani lem ni Biliyaminu. ");
INSERT INTO jni_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ugomo mada nyari me anu ameme sa ma rusi we dati utuba ba. Ida rusa unyertike utize ta Asere taa buki ahira aIliya, sa maa riki Ugomo Asere tari anice anu Israila? ");
INSERT INTO jni_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Ugomo Asere ahuzi anu ubezizi utize ti we me. Wa kure wa pusi ubagadi uwe me. Mi mani cas ma dee, wa nyara wa huum. ");
INSERT INTO jni_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ugomo Asere maa kabirka ma gu me nyanini? Ma kabirka ma gu “ma inko any a'ino usanare an desa daki tunguno makiri ba'al ba.” ");
INSERT INTO jni_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Vatin ani me, ana me ukasu urani sa a zauka we barki iriba isheu. ");
INSERT INTO jni_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Inki ya cukuno barki iriba isheu ini, daki ya cukuno barki katuma ku unu ba. Daki ya cukuno iriba sheu ida daza me iriba isheu ba. ");
INSERT INTO jni_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Nyanini idi ku zi? imum be sa A, Israilawa wa zi unu nyara me, daki wa du ku kem ba, iye ya cukuno an desa azauka we kem ukasu wa cukuno gbas. ");
INSERT INTO jni_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ya cukuno gusi sa anyertike “Ugomo Asere maa nya we bi be bi ugbas nan ituri, a je sa wada hira me ahira ni ba, ti tui sa wadi da kunna me tize ni ba, a nyimo uwui ugeme.'' ");
INSERT INTO jni_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dauda ma guna “caa utebur uweme ucukuno gusi imum i mensi icere, imum imensi inama, nipoo ni upilizino nan nugarza imum be sa wa wuza. ");
INSERT INTO jni_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ca aje aweme acukuno bibit bati kati wa hiri ahira ba. Amaru aweme adi tunguron sarki umarsa.'' ");
INSERT INTO jni_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Har kanime izin unu iko, “nani upilliko me udi biki uguna wa rizi?” Asere awu kati icukuno ani me ba. Barki usiziki uweme anu amadini wa kem masaa, bati wa kunna ishina. ");
INSERT INTO jni_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Inki usiziki uwe me wa cukuno ukem une uni, u dira uwe me ukem wa na amadini uni, nyinini uwa uvu uweme udi bezi? ");
INSERT INTO jni_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ana me izin tize nan shi ana madini, mi sa inzi unu dungura ahira ashi ana madini in kunna in katuma kam. ");
INSERT INTO jni_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Inhira indi dari mu riba ma desa tizi a'inde nan we. In hira ti di benki aye awe me. ");
INSERT INTO jni_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Inki ya cukuno unyare uwe me udi cukuno abarka une uni, ukaba uweme udi cukuno ukem uvegize uni usuro iwono? ");
INSERT INTO jni_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","inki a barka bisana bituba uhina, ane ani nitini me. Inki abarka niji ni bisana me, ane ani irii me. ");
INSERT INTO jni_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ana me ingi amu pusa ire iri, ingi hu iri utiti uni jaa, apata nan we, inki iciki nigoo me ati jii ti utiti u'olive. ");
INSERT INTO jni_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","kati uwuzi irii me uwetere ba. Inki wa wetere ma, daki ha mani u'inta tiji me ba, tiji me tini ti inta we. ");
INSERT INTO jni_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Idi ku gunna, iri me ya pusa bati mi in kem ahirabumeki. ");
INSERT INTO jni_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Kadure kani, barki uzatu unya ace awe ani ine ini ya wu wa pusa, tonno nin ini kara barki uhem ushi me. Kati i yeze ace ashi ba, k unna nin biyau ba Asere. ");
INSERT INTO jni_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Sarki Ugomo Asere ma tarsin iri ituba shi ma mada tarsan inshi ba. ");
INSERT INTO jni_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Duku ira nin, abaga upazaza Ugomo Asere. Nire nikira, u pazaza wa e anice na Ayahudawa sa wa rizi. Nire nikira usheu Ugomo Asere wa e ace ashi me, inki ya re aje anyimo usheu umeme. Nani shi ma adi koruko shi ma avete nin. ");
INSERT INTO jni_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Sarki daki wa ri aje unu zati unya ace, a da meki we a zeni. Ugomo Asere mada ke ma kuri ma zen we. ");
INSERT INTO jni_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Inki akoruko anyimo utiti usas, nan unu wuna Asere ma inki shi anyimo utiti uriri. Aneni abanga Ayahudawa, sa we wani iri me Asere abarka anyimo utiti ulive uwe me? ");
INSERT INTO jni_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Inda nyaram shi icukuno sarki urusa imum ini hunzi ni geme ba nihenu, kati icuno sarki ubasa ti memeru. Imum ini hunzi ni geme ya in ni jas cingili ahira Ayahudawa, u duku hana anice ana madini. ");
INSERT INTO jni_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Vat in ani me, gusi ubuka anyimo unyettike me Aisraila wadi kafa vat uwe. “unu benki me madi suri Usihiyona. Madi suso anu zatu unya ace anyimo a Yakubu. ");
INSERT INTO jni_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Udi cukuno une uni barka utize tum nan we, uganiya sa indi kpici madini ma we me.” ");
INSERT INTO jni_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Abanga atize ta Asere, a game we barki shi. Nire nikira barki uzau ka Ugomo Asere, a nyara we barki anu tuba aweme ani. ");
INSERT INTO jni_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Unyanki imum i ugomo Asere mada gamara me ba. ");
INSERT INTO jni_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Azi anu uzatu ukunna utize ta Asere ani unu tuba, shi be ya kem uvenke, barki uzatu ukunna utize ti we. ");
INSERT INTO jni_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ine ini ya cukuno barki ukem uvenke ushi me, we ma wa dake wa kem uvenke. ");
INSERT INTO jni_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Barki Ugomo Asere ma korso uzatu ukunna utize, bati ma bezi iriba ish eu imeme anice nanu vat. ");
INSERT INTO jni_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Wuyi!, uconco urusa nan ugbardang Ugomo Asere uda zo me ini imum bata ba. Adi wuu aneni abati u'inko utize timeme, ada ke arusi nibaba ni meme ba. ");
INSERT INTO jni_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Aveni mada ke ma rusi iriba i Ugomo Asere? Nani aveni ma bari ma cukuno unu gamara ume tize? ");
INSERT INTO jni_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Aveni ma tuba unya Ugomo Asere ire imum, sa di kurzo me ini? ");
INSERT INTO jni_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Barki me mani, usuro ume uni nan ahira ame ani vat akenzi timumum nin. Caa tinonzuko niza ni meme sarki umara, na icuno ani me. ");
INSERT INTO jni_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","In anime ni henu in zinu iko ushi barki ubardang immum iriri ya sere, wito ine ace ashime udenge wa sere barki ine ini biyau bihuma. ");
INSERT INTO jni_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kati itarsi uganiya ugeme su zi ichiki iriba icukuno wasi isan zi muruba mu shine vat, vat barki ibezi imum be sa Asere anyara, imum iriri sa madi kabi. ");
INSERT INTO jni_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Usuro imumu iriri sa awuzani ni in nya vat uru tise, kati ma ziki ni ce nume uzina sa in zi, cah marusi in nice nume, ubinani uhem sa Asere anyame. ");
INSERT INTO jni_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kasi tihihira gbardang tigati ani pum ni indai, tihihira tiginome katuma ka indaime kani. ");
INSERT INTO jni_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Ane ani haru me, ko sa ti ori, ni pum ni gafi nan vana Asere, vat uru tihihira ta ce-ce tini. ");
INSERT INTO jni_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Vat uru mazin ni imube sa Asere anyame inki sere a nyarawe in nu buka u ni ca ubuki ini kara nuwe sa wa hem ni. ");
INSERT INTO jni_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Inki utarsa in nanu, utarsi meme rum, unu dungara utize ta Sere tini a ma dungara. ");
INSERT INTO jni_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Unu bura umuruba ma cukuno ahira ubara umuruba mume, unu bengizi amanyaga tap, unu tarsa ina nu ama tarsi unu rusa abanga una katuma ku gugguni amawuzi ini iruba irum. ");
INSERT INTO jni_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Caa uhem in nacece ucukuno sarki uhira acece. Kati iwuzi imum iburi ba, inko ni muriba ihra imum be sa irizi. ");
INSERT INTO jni_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Abanga uhem uni henu, hem ini cece kang, inya acece tinanu. ");
INSERT INTO jni_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","I cukuno anu umokoro, kati i cukuno cancan ba. Abanga abibe biriri soki ni nice nin. Nonzo nin ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Wuza nin iriba irum barki nikara niriba sa izini abanga aje ashi me. Natta nin muriba mushi ahira ijasi me izini usiza me. Cukuno nin ana biringira sarki umarsa. ");
INSERT INTO jni_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Benki nin nihenubanyimo ijasi nacece. Kaba nin nihenu. ");
INSERT INTO jni_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Rigirka nin andesa wa yomo shi, kati iwu we, wuza ni we biringira bati Asere ma kpici we. ");
INSERT INTO jni_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Wuza nin iriba iru nan andesa wa zin iniriba irum, ikuri iwuzi iriba ibit nan andesa wazin imuriba mubit. ");
INSERT INTO jni_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","I cukuno ni huma nan nihenu. Kati ibezi ace ashi me anu rusa wani. ");
INSERT INTO jni_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kati igarza imum iburi nan imum iburi, Wuza imum me sa anabu wadibwadi iri tinanu tishi me. ");
INSERT INTO jni_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Wuza nin imum me sa idi wu icukuno merum nan nihenu. ");
INSERT INTO jni_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Kati igarza imum iburi ahira imum iburi ba, wuza nin ticukum kati irizi anyimo iriba izenze yasere, amu nyertike aguna “ugarsa imum iburi ura atari ti ugomo Asere tini.” ");
INSERT INTO jni_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Barki ani me, inki aroni ishina iweme ma kunna ikomo, nya we imum ya re, inki wa kunna niwe ni mei nya we mei wa si. Inki wa wuza ani, uzini urso uwe a'ne ura ani ce ani. ");
INSERT INTO jni_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kati iceki iwuza imum iburi ihunguko muriba mushi me, barki ca iwuza imum iriri icukuno amuriba mushi me. ");
INSERT INTO jni_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ceki konda avi ma heze tigomo barki azo me in tire tigomo se ti gesa ta aye ahira Asere; ana katuma kati gomo sa wa rani usuro Asere ani. ");
INSERT INTO jni_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Barki ani me vat desa ma hunguko nan ti gomo ma hunguko ubaka wa Asere, vat andesa wa game ti gomo wadisi ni rere. ");
INSERT INTO jni_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Barki anu wesi, tize ti ti gomo azo imum ibiyau bini ahira ana kadure ba, barki anu wuza imum izenzeng. Inyara icukuno anu zatu ubiyau biti gomo? Wuza ni imum ikadure, idi kem ni nonzo ahira uza anime. ");
INSERT INTO jni_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Barki me urere Asere mani ahira ashime barki kadure. Barki inka ya wuza imumu izenzeng, wuza ni biyau barki ma da canti me urere Asere mani unu kurzo unu wuzo imumu izenzeng ini riba ibit. ");
INSERT INTO jni_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Barki anime udoli uni heze, azo barki iriba ibit ba, barki ubasa. ");
INSERT INTO jni_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Barki agino ani ibisa ugandu. Barki ana katuma arere Asere wani, andesa wa wuza ani me konde uye uwui. ");
INSERT INTO jni_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Nyani konde avi imum ime; uandu ahira unu ugandu, ikirfi ivai ahira unu ivai; biyau ahira andesa ma bari biyau, ninonzo ahira andesa ma bari anyame ninonzo. ");
INSERT INTO jni_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","kati i canti ureme uye ba, se ihem ina ce ashi, barki vat desa ma hem unu henu ume ma myinca ubuka uni pin. ");
INSERT INTO jni_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Kati imusi nan na neh ba, kati ihuzi anu ba, kati iwuzi ni kari ba, kati iwuzi ni ero ba, inka ure ubuka urani, abata uni nan timu ti geme; ''Hem unu henu uwe me kasi nice nuwe me,'' ");
INSERT INTO jni_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Uhem uda riza me inama ironi utura ba, barki anime, uhem wa gu umyinca utize tini kubu. ");
INSERT INTO jni_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Barki agino me, irusa uganiya wa wuna, zuma amoro, barki ubara uru wa aye mamu uteki ubasa urusa ti basa. ");
INSERT INTO jni_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ni yē na wuna bitii, ahira aye mamu usana. Barki anime, ca ti ceki timumu tima reu, ti su timumu ti masaa. ");
INSERT INTO jni_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ca ti wuzi tanu tige sata wuna urii, kasi unu wui, azo anyimo udira unice ba nani ubidi bidi ba. Kati ti kuri ti wuzi tanu anyimo amadani na mei maje ba, azo anyimo uhirza iriba nani ni ero ba. ");
INSERT INTO jni_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Zaki ugomo Asere Yeso unu bura, kati inyari imumu ini pum ba, barki utarsa unee zenzeng umei maje. ");
INSERT INTO jni_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kabani vat desa uhem umeme uzinni karaba, daki nan nu jottiko umeba. ");
INSERT INTO jni_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Uye ma zinnu hem mari kodi nyani, uye desa mazi seke make mari mavamani cas. ");
INSERT INTO jni_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Kati desa mare imum ma izi debe sa mada reme koya imumba. Nani kati debe sa mada reme ko iya imum mairi aburu andesa ware ba. Barki sa Asere. ");
INSERT INTO jni_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Hu aveni, sa udi iri aburu urere u ye? uturi ume nani urizo ume ura ahira una kura umeme ani, ugomo Asere ma zin nu bari uturi ini. ");
INSERT INTO jni_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Uye make ma iri urumi uteki ure anyimo ati eui me. A uye me macira ti wui me rep. Kovi macukuno anyimo u turi iriba ime. ");
INSERT INTO jni_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Me debe sa ma igi zon in uru wui, ma igi zon uni barki ugomo Asere. Anime ani desa mare, mare ni barki ugomo Asere, barki mawuza ugomo Asere anko. Me desa daki mareba, magame ani barki ugomo Asere. Mema mazinnu wuza ugomo Asere ankoi. ");
INSERT INTO jni_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Barki bade sa mavengize barki nice nume anyimo aru, anime ani uni wono mazoni barki nice nume. ");
INSERT INTO jni_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Barki inki tivengize, tivengize barki ugomo ini barki ugomo Asere. Anime koti vengize, ko awijo haru ugomo Asere wani. ");
INSERT INTO jni_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Barki bigino binyome yeso ma wi makuri mahirri, barki ma cukuno ugomo Asere anu wijo nan vengize. ");
INSERT INTO jni_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Anime nyani ni ya wuna izin nu boo uni henu tize? hu cangi nyani yawuna uzin nu iziza uhenu uwe? vattu ru tidi tonno aje aweki utize tugomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Barki anyittike, ''matoniko, ''ubuka ugomo Asere,'' koniya niru nidi tungunom, koniya nilem nidi nonzo Asere.'' ");
INSERT INTO jni_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Barki kodevi uru madi buki imumbe sa ma wuza innanyo ame aje Asere. ");
INSERT INTO jni_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","A anime zikani u inko iruba, barki katti uye macukuno binyo bu pilliko nani urizo u henu ume. ");
INSERT INTO jni_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","In rusa cip ane ani ani nan ugomo Yeso, daki ire imum uzatu lau u inko uni. Senke ade sama zika ini innu zatu lau, madi cukuno innu zatu lau. ");
INSERT INTO jni_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Inki imumare iweme icara uhenu uwome ni, uda hakawe anyimo usu ba. Kati u cari desa Yeso ma wono barki me in nimumare iweme. ");
INSERT INTO jni_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Barki anime, kati ti mummum sa a zika ti ririn ti cukuno imum ibi bobo aaye. ");
INSERT INTO jni_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Barki tigomo ta Asere daki abaga are ani nannu saba, anime ahira imummu i huma ini, urunta, iruba irum anyimo abibe bilau. ");
INSERT INTO jni_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Barki desa ma nonzo Yeso una uginome, ukaba uni ahira Asere, anime anu wa hem ni. ");
INSERT INTO jni_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Barki anime, aca ti nyari imummu urunta nan timummube satidi benki acece. ");
INSERT INTO jni_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Kati ucari katuma ka Asere ni barki imummure. Kodi nyani izi lau, huwono a huwono sisi anime unume sa mare imumbe sa idi wume marizi. ");
INSERT INTO jni_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ida rizime ari inan nai asi mei mu wango, nani vat imum sa idi hunguko urizo. ");
INSERT INTO jni_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ugino hemme sa izini, barkani uni atii ashi nan Asere. Unu ringirka mani desa iruba ime daki ya nyame mani desa iruba imumbe sa iruba ime ya ira yawuna rep. ");
INSERT INTO jni_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Desa mazin ma aye, maare, marusa macara abagani, barki sa daki innu hem ani mare ba. Vat imu sa daki innu hem in iziba madini mani. ");
INSERT INTO jni_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Horosa ti ture ina kara keni tibeke anigibesa wazuwe na karaba anye utarsa utize utize tasire me bakesa wa sisikuwe, tibewe moro ba mo chichim kati tiyare aci aruba. ");
INSERT INTO jni_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Chiki ayemo aro tibeki ni hinu bati vigizi mero bake tihirza we wa anyimo atize tasire me. ");
INSERT INTO jni_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kome ugomo Asire me idaka wosoci ba baki ani ani izi anyimo uyetike me unuguna na zu gu nanatizugu wazugu ugomo Asere aka di me wadizi acinum. ");
INSERT INTO jni_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Vati imobesa ayetike ni dati atiye tadumu ira ahira uyetike ahira tize tasire tini ayetike bagi anu ubezeze anu wachukunu inurasa uti amureba maweme sa ugomo Asere mayewe. ");
INSERT INTO jni_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ciki ugomo Asere unu naze ireba issu kegi shini karani barki ukaba utize tume, yare yadasa idi woze moroba mushu ina nuhinu ushime barki ticuku ti hira idi mabuki ogomo Asere. ");
INSERT INTO jni_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Barki ni ani idi woze ogomo Asere ni nuzu ayo ashi wedi tize tize tishi tidi ina ini nuzuko Asere me, aco aro urome naka chu urome avana Asere me. ");
INSERT INTO jni_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Itani acici itare tirere kasi yada sa ogomo Asere mabuke inuguna maka shi itare tirere bake iyesi tize ta Asere nin nuzu. ");
INSERT INTO jni_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Aye abusa shi inu guna uwatu iwono ivana Asere, macuku unu woza ukatuma ahira ayahudawa baki tisire tisire ti myinca nani gbora na sere akure icuku kadure barki veko utize sa awo anacici. ");
INSERT INTO jni_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Barki ani gibesa waze yahudawa ba barki wa wozi ugomo Asere ninonzo wakure wa nonzo kome barki iriba ishu kasi ayettike inugu barki ani ani ugomo Asere idi wosi we ni nuzu inkure ibusi tire timowo tini nuzu in zanu weme. ");
INSERT INTO jni_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Uyettike utize ta sere waaka uze inugu iraba shi sa izushi ayahudawa wosani tiboro tirom ni gome na nanu tarsa utize ta Asere ");
INSERT INTO jni_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Makigi ubuka inu guna wasa ni ugomo Asere ni nuzu shi sa ize ayahudawa ba, vati wasini me ninonzo vat anabu unee. ");
INSERT INTO jni_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ishaya magu ure udanga atini yesse ba de yeh madi soso nici ma hire ma wasi ma tigomo anigi sa wazu we ayahudawa ba. ");
INSERT INTO jni_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ciki Asere unanu ma wo wa iki moroban makure maya shi mareba shiu na benki anu uganiya sa waze inu iko umore ba, ahira ameme macu kunnu bunu iko umore ba, watu uya uci atize tisere me. ");
INSERT INTO jni_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Anu henu irosa ingu izin nuka ahira kan izin kuma, nurosa utimumum kan, har mayabare i bezeze aci ashime. ");
INSERT INTO jni_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Anyimo uyettike ugime sa wasi tize amasa, azeszere atire timumum barki ireki shi tini shi ini barki ariki shi imomo irere sa Asere mawo shi ini. ");
INSERT INTO jni_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Desa ma wona katuma inku una katuma ka Asere vana wa Asere me, memeni Yeso unige sa ma yahudawa matume vana ukadure kam maka wosa katuma sa maze so iwosime kani ubagadi wa Asere anyimo aza ni vana umeme ulau. ");
INSERT INTO jni_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Barki anime daki patilika ini kana barki ize katuma vana Asere barki ani ani awona ize inu pugizu ubegire bum Asere ashime me? ");
INSERT INTO jni_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Idaki iwosi tize ahira tire timumum ba, sai imum sa vana Asere maguna iwozi imomo ine ine adibesa ahiguko wazuwe ayahudawa ahira uzeti tasa imumbe sa ugomo Asere maguna wa woze katuma. ");
INSERT INTO jni_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Ahira ani kara Asere wa timumum tine za ubeyau vat tisoso abibeu ba Asere beni uhana urshalima ma keti har uhana jerusalem, marebe mabezezez we Asere vat katuma sawa ugu. ");
INSERT INTO jni_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Amu iriba kode uya uganiya ize nuso idigi ubezeze anabu tize ta Asere, barki idayam iwosi, nani ibarka udigi azesere ayeba, katuma sa, izin nu woza me kabebe ba Asere beni ba. ");
INSERT INTO jni_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ine ini a yettike inu guna adisa daki watuba uguna ba wadi ire, adi kuma sawa tuba uguna ba wadi kuna. ");
INSERT INTO jni_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Imumum igino ini yawuna akartime u eye ahira ashime? ");
INSERT INTO jni_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Anani me mamu mara katuma karu ahira ashime, daki iti we sata aka gbardang ma wozi ugudiye ire shi idaki makim ba? ");
INSERT INTO jni_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ma barka tannu inu guna ide aki inu ze shi ni isi barki ticukum tiririn sata woze nan shi, idiku aki uhana atanutum, nanu benki ushime? ");
INSERT INTO jni_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Anime fa ihaze urushalima ikabe giwe ana mureba mu lau sa wara ahira ame. ");
INSERT INTO jni_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Anabu anu tarsa Asere sa wa rani a makidoniya anigi sa wara, achaia, wa kunna uronta sarki uyaki ire mu barki ubenke wa debe ade sa wara urushalima. ");
INSERT INTO jni_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Wa kunna uronta ulau eni ikadure kani kaze koda ya wa kunna we kam chubu ugomo Asere ani uze. Aci baki anigibe sa wazu me ayahudawa ba wa kimo uwe urabo waze barki wa be ubuka wa yahudawa. ");
INSERT INTO jni_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Ika kondavi ma mara katuma kameme maguna idi ibukuwe barki idi maki una uhana u sifeni ikure i han ika asowe uganiya sa ide aki. ");
INSERT INTO jni_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Izin nu buka shi kadure kani inu guna ashi ahira ashime sa idi eye i eye ni riba irom sa vana Asere mayam. ");
INSERT INTO jni_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Anu henu anyimo aza na co uro ugomo Asere vana ume yeso unu bebiu be home ize inu tarsa ushi tare ibekum anyimo upana sa izin ni wuza me. ");
INSERT INTO jni_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Wanani me, biringara barki ivinki a tare da disa wa zuwe Asere ba amanga ma yahudawa barki ani ani izin inu gusa ibenkin i hani urushalima, sa wa cukunu imum kaba irere ahira aweme. ");
INSERT INTO jni_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Barki igusa igi ugomo Asere ma tuwe ko bebeu bumeme be riri sabe rebem e ikem u venki ni gome na shi, timumum ti riri tumeme cukunu ashi kinin icukuno anime. ");
INSERT INTO jni_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ca Asere iruba irum macukunu nan shi vat, icukunu anime. ");
INSERT INTO jni_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ma muta shi nan Fibi uhenu uru me una katuma kam kani anyimo udenge unigura ukankiriya. ");
INSERT INTO jni_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Kaba ni me in tari tirere barki Asere. Una anu tarsa Asere, benki ni me vat anyimo imum me sa ma nyara ahira ashi. Barki me ma benki anu gbardang upata umime. ");
INSERT INTO jni_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Iso nin Briskila wan Akila, aroni akatuma kam anyimo Ayesu unu bura uru. ");
INSERT INTO jni_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Andesa wa nya iriba iweme barki mi daki mi mani cas, in gusa ankoi. Iso vat anu tarsa Asere. ");
INSERT INTO jni_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Iso anu tarsa Asere atikura ti we me, iso ni Abainitas, desa me mani ma tubi utarsa Asere anyimo ani pin nu Asiya. ");
INSERT INTO jni_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Iso ni Maryamu, desa ma wuzi shi katuma in iriba ka inde. ");
INSERT INTO jni_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Iso nin Andaranikas nan Yuniyas, anuhenu um aroni sa atirin duru, andesa wa raa anyimo ani dura ni Yesu, har ma wu agizam ukaba Asere. ");
INSERT INTO jni_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Iso ni Amfiliyas, unu usum anyimo utarsa Asere. ");
INSERT INTO jni_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Isoni Urbanus uroni ukatuma anyimo utarsa Asere, nan unu su um Istakis. ");
INSERT INTO jni_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Iso ni Abalis, desa ma hem ime anyimo utarsa Asere, iso ni anu Aristobulus. ");
INSERT INTO jni_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Iso ni uhenu um Harudiyan, iso ni andesa wa tarsa Asere anyimo Narkisas. ");
INSERT INTO jni_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Iso ni Tarafina nan Tarafusa, ana akatuma kasere, iso ni Barsisa unu uso, desa ma wuzi katuma in kadure. ");
INSERT INTO jni_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Iso ni Rufus, desa ma suso nice anyimo utarsa Asere, nan ka a'ino ameme cangi. ");
INSERT INTO jni_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Iso ni Asinkiitas, nan Filiguna, nan Hamisa, nan Baturobas, nan Hamasa, nan nihenu sa wazi nan we. ");
INSERT INTO jni_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Iso ni Fililigusa, nan Yuliya, nan Niriyas, nan kuhenu me, nan Ulumfas, vat anu utarsa Asere an desa wazi nan we. ");
INSERT INTO jni_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Iso ni acece ashi in ni isi nihuma, vat anu tarsa Asere wa iso shi. ");
INSERT INTO jni_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Nihenu, ana me inzi unu igizo ushi, tarsa ni seke nan an desa wa hari shi ahira imum me sa ida dungura shi, w adi wu shi i pilliko. Wuna ni piit nan we. ");
INSERT INTO jni_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Barki usasana anu agino me wada tarsa Asere in kadure ba, wa tarsa imum me sa wadi ati puru tiwe tini. Unu kunna tize tima cico ti we me bati wa gamirka ana muriba muhuma. ");
INSERT INTO jni_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Abanga usheu ushi me, amara kode aba, i ne ini izin ina puru arum barki shi, in nyara shi iwu imumu ihuma iriba ishi me, i cukuno mei mashi ma da zoni anyimo imumu iburi. ");
INSERT INTO jni_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Asere unu nyiza iriba irum madi patilka unu buri ugino me anyimo ati buna tishi me. Asere iriba isheu ma cukuno anyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti uroni ukatuma kam, ma iso shi, ane ani Lukiyas nan Yason, nan Susibataras anu henu um. ");
INSERT INTO jni_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Mi Tarfiyas unu nyettike ihori ige me, in iso shi barki Asere. ");
INSERT INTO jni_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus una kura am, nan vat anu tarsa Asere, wa iso shi, Arastas unu inso uturunga ti ni pin, nan nuhenu uru Kawartas wa iso shi. ");
INSERT INTO jni_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Asere iriba isheu ma cukuno ahira ashi me vat. Icukuno ani me. ");
INSERT INTO jni_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Ana me ahira adesa ma bari ma wu shi itonno barki katuma ku boo tize tu Ugomo Asere sa izini, usuro ushe uni abuki imum me sa ya impi datti utuba. ");
INSERT INTO jni_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ana me sa a poko ta cukuno arusa tini, adi buu tini ahira anu zatu tarsa Asere, barki unyetike sa wa wuzi wanu dungurka wa Asere unu uzatu ibinani, barki anu zatu tarsa Aserebwa tarsi. ");
INSERT INTO jni_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ninonzo ni cukuno ahira Asere sarki ibinani, i cukuno ani me. ");
INSERT INTO jni_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Usuro me Bulus unige sa Ugomo Asere matiti me barki macukuno vana ukatuma ka Yeso bibe ba Asere nan ni kena uru satanis. ");
INSERT INTO jni_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Uhana anabu anu tarsa Asere sa warani, u korinti, we am de be saa inko we anyimo Yeso Ugomo Asere, anu zatu umadini nande be sa a titawe, vati nande be sa waraa ati hihira wazin biringara anyimo ani za nu Yeso Ugomo Asere uro Ugomo Asere uwe me, Ugomo Asere uro vat. ");
INSERT INTO jni_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Imum irere nan iruba isheu ya sere ugomo uro Ugomo Asere Yeso bibe bi rere bi cukuno nigo nan shi. ");
INSERT INTO jni_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","In zin shi in ni ruba irom, barki imum irere be sa ma nya shi usuro Ugomo Asere Yeso. ");
INSERT INTO jni_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ani mani atina sasas mawuna shi ukem watu uti ze nanu rusa vat. ");
INSERT INTO jni_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Kasi, sa abezi urusa uru amasaa abanga Ugomo Asere anyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Baki ane ani daki yadiri ukem iri mum a hira Ugomo Asere irereba, uganiya sa i inso ajeh izinu ni nyarga nu ze u Yeso Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ugomo Asere madi kuri manya shiui nikan nu uhana umazame, barki icukuno anuzati una dini aronome sa Ugomo Asere urome Yeso bibe bi rere sa madi zeh. ");
INSERT INTO jni_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Asere unu myinca, memani matiti shi inatta acce nan vanah umeme nan vana umeme Yeso. ");
INSERT INTO jni_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Inzinu tire ushi tari nihenu barki rizani Ugomo Asere Yeso magu, cu tize shi me ti cukuno ti inde, kati iharzino ace-cecce, cu i ori acce ashi me ahira a ide, iruba ishi me inde ugamara utize tishi me u inde. ");
INSERT INTO jni_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Barki anime nihenu, anakura a Kuluwi wabukum inuguna iziti kara acece ashi me. ");
INSERT INTO jni_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Imum besa ya wuna mabukashi ini me barki, a yeh ashime wazitize sasas unu gusa me ubulus mani, uye unu gusa wa Afollos mani, uye ma gusa me ukefas mani masi uye magusi me ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Antani a hara Ugomo Asere sasas nii? Bulus mani ma weé a kotiko me utiti barki shi? Nya azoro shi ini zan ni Bulus mani. ");
INSERT INTO jni_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ma wuna Ugomo Asere aburu arom barki daki ma soro uye anyimo ashi me, kiribus wan Gayus mani ma zoro ces. ");
INSERT INTO jni_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Barki ani mani uye madaki magu a azoro me in nizan num. ");
INSERT INTO jni_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Maringi inu guna ana kura Istifanus ma zoro uce, daki makuri in zoro aye ba. ");
INSERT INTO jni_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Daki Yeso ma tumum guna agi in zorso anu ba magu in wuzi katuma kubezizi anabu tize to ronta indaki inu rosa unububa barki kati adiri urusa ugongo iwono u Yeso sa a kotiko azezere utiti. ");
INSERT INTO jni_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kadura ku venke tize ti zenze tini ahiran de sa meki unaa iwono, ahira aru haru ande sa aburum duru usuro unaa uzenzeng, niguran ni rere ni bura uni. ");
INSERT INTO jni_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Barki anyetike anyimo atize ta sere in di curi nigura na de sa wabezi urosa, indi kurzo ana jinjing ula a babba na. ");
INSERT INTO jni_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Anu urusa wara abani? anu bezi utize ti Musa wara bani? an de sa wa bassa uca rusa kodi nyani nan wa ra aba? Ugomo Asere ma bezi urusa wanu rusa ibabbana iniba? ");
INSERT INTO jni_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Usuro urusa Ugomo Asere anu uneē wa tāme Ugomo Asere anyimo uzati urusa uwome, usuro ani me, Asere mā zauka makuri ma buri an de sa wa kabi tize ti kudura a hira ameme usuro uguna utize ti me me ti ronta ti ge be sa ahiraa kasi ibabbana ini ");
INSERT INTO jni_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","A Yahudawa wa nyari wa iri iremum a helenawa wakure wa nyari urosa. ");
INSERT INTO jni_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Haru be tizinu bezezi tize ti Ugomo Asere sa ma wee a zesere utiti imum be sa imumu upulko ahira ma Yahudawa mumu ibabbana ini adebesa wa zo we ma yahudawa ba. ");
INSERT INTO jni_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Me Ugomo Asere una nikara mani wunu urusa abanga ameme ahira ande sa a titi we, nani we Ayahudawa wani? ");
INSERT INTO jni_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Barki sa Hira imum be sa Ugomo Asere ma wuza gusi ibabba ini, iyenne iteki urosa unobu, imumbesa a bassa nisizziki me nini na sere iteki vat nikara nu nubo. ");
INSERT INTO jni_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Nihenu rigin uganiya sa matiti shi angilin ini anyimo ashi me, anu wa cing wani wa inta makpanku ma dandang anyimo ashime anyimo awe me cingilin ini wazi ahana ara a dandang. ");
INSERT INTO jni_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ineni Ugomo Asere maka ma zanka imumbe sa anabu waka wahiri ini kasi ibabba na ini, barki manya anu urusa mu eh Asere ma zawa imum be anu une a wahiri kasi masiziki me ini, barki ma nya una nikara mu eh. ");
INSERT INTO jni_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Imumbesa unu wa cira izome imum irere ba nani izome ikatuma ba nyani izome iri mumbe sa izo me ikatuma nyani izo me imum izati u ira ine ini Asere ma hira ini irere ini ma busi imum besa wa hiri itekin unu gangang. ");
INSERT INTO jni_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Asere awozi anime barki unobu mani kati magu matiki nikara na sere. ");
INSERT INTO jni_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Asere ani awu acukumo Ugomo Asere Yeso, Asere a wu bibe basere bicukuno duru unu rusa ahira ameme ani ta kem ukaba wanu ukpijo nan nu bura. ");
INSERT INTO jni_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Barki ani me vat de be sa tira bigiri ini za nu Ugomo Asere, imum be sa izi cas. ");
INSERT INTO jni_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Nihenu ma aye iboki shi ire mum sa izi iri sa Ugomo Asere mabuki, daki mabukashi kadura indaki a hira urosa utize nani urosa ire mum ba. ");
INSERT INTO jni_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ma wuzi ugungunu anyimo iriba uganiyasa indi cukunu nan shi sa indaki bezizishi tire timumun in daki tize ta sere nine be rere memani agankirka me utiti. ");
INSERT INTO jni_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Utuba u aye um a hire ashime mazin ini kara ba makiri barki biyayau. ");
INSERT INTO jni_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Tize tum nan nu bezizi utize ta sere daki wa tun no uguna atarsi seke nyani urosa ya cukuno imum be sa tize ti bibe birere aza agi. ");
INSERT INTO jni_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Barki kati urosa ushi ucukuno wanabu, ceki ucukuno wa sere. ");
INSERT INTO jni_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Vat ani me tizin tize ahira anu urosa adesa wa una anyimo a tize ti kadura ka we me azo uguna urosa wa nu uganiya ugime daki wanu ganiya ugime sa udi mara ba. ");
INSERT INTO jni_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ane ani tizin tize tu rosa a sere tigeba satize nihuzi, urosa sa wazi datti ni hunzi, unu uni urosa wa sere sama barka uni datti barki ninonzo niru. ");
INSERT INTO jni_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Anyimo ana ti gomo ti aname unu urosa igino me mazoni, barki gusi wa rosiwa da gankirka me Ugomo Asere utiti me ba. ");
INSERT INTO jni_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Kasi unyetike me sawazi “Vati imum be sa yazi a hira a sere ma barka anu tarsa umeme unu urosa mazoni daki uye mamu kunna ba, nyani uye mā mu cukuno ma iri”. ");
INSERT INTO jni_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ine ini Asere abezizi duru ti mummu, usoro abibe, timummu ta sere tu zatu urosa u ira. ");
INSERT INTO jni_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Aveni madaki ma rosi imumu sa iraa anyimo iruba i uyeh, indaki bibe bi meme? ane ani izi, unu urosa ubassa ababga Asere mazoni bibe basere bini bizicas. ");
INSERT INTO jni_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Harume inzo bibe bunee bini tizin inu kaba me ba, indaki bibe begibesa bira a hira Asere, barki tirose tire timumun sa Ugomo asere ma nyan duru in ni ruba inde. ");
INSERT INTO jni_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Tizin inu bo ushi timumu, azo agburang sa azi nu bezi usuro urosa unu booba indaki ubibe, ahira ubezi imum be sa an de sa wazin bibiu. ");
INSERT INTO jni_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Uni gebe sa bibe ba sere bitarsa imeba ma daki makabi tize tibibe ba sere, ahira ameme imummu ibabba na ini madaki ire ini ba, usuro ahira abibe ba sere bini aka rosi. ");
INSERT INTO jni_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Unubesa bibee be tarsan me, madaki ma mansa kondi nyani, unu mansa ume marani ba. ");
INSERT INTO jni_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Aveni ma daki marose iruba Ugomo Asere harsa madaki bizizi me? haro me mure bamurome mu muraa ahira Asere ani. ");
INSERT INTO jni_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Abanname, anu henu in dake in buki tize nan shi gusi am de sa warosa tize ta sere, azo gusi ande sa wa raa anyimo apum, kasi a hana aneze anyimo Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ma hamza shi in mahene mani azo me ini inama, kasi aige be sa ularaa ni anyimo apum kusi ahana a neze anyimo Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Kasi aname iraa ni anyimo a nipum, inki matara marani a nyimo ashi me nan nu hungu ko ati ashi me, azo shi ana pum wani ba, ikuri ita shi ugurna i haka aje ana bu? ");
INSERT INTO jni_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Barki inki uye maguna, “In raa amaru a Bulus” uye maguna “In raa amaru Afollos” azo me ticukum tini pum tini in zini ba? ");
INSERT INTO jni_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Abanna me aveni mazi wa Apollos me? aveni makuri mazi ya nya kadura ahira awe me, vat uwe Asere a nyawe timumu tu wuza. ");
INSERT INTO jni_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Mi ma wuza ti bira, Afollos ma wuza ugmei nin, Ugomo Asere ma wuna ini ya una. ");
INSERT INTO jni_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Barki ani me una tibira nan unu wuza ugmei mani ma zo me imum ba, Ugomo Asere ma uzan ini. ");
INSERT INTO jni_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Una tibira wanu unu uwaza ugmei vat katuma ka weme ka inde kani, abanna me vat uweme wadi kem uribe ukalim, rep nan katuma ka meme. ");
INSERT INTO jni_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Haru ahira ageme aroni akatuma wani ku Ugomo Asere, shi urung Ugomo Asere, ubarka Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Usuro uroma iriba be sa Asere anyam ucukuno una je uhira, ma tuba ni tin me uye mazinu tara asso azesere me, ca koya unu ma wuzi mahaki ma hiri asso me sa tara azesere me. ");
INSERT INTO jni_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Abanna, daki uye marani sa madi wuzi katuma kage be sa kadi aki ka ge sa amu nuka, memami Yeso Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Aname inki uye matara asso azesere anitin na zumo kyel. Kyel, nyani azumo arere nyani apo ani zaa, nyani utiti nyani nyani ukpe nyani uwai. ");
INSERT INTO jni_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Katuma ka meme kati pokino uni roni uwui ugino sa u eze, adi guti nikara ni katuma sa ya wuzan kani. ");
INSERT INTO jni_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Vat de ba sa katuma ka meme ka tonno madi re ukalum. ");
INSERT INTO jni_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","De be sa katuma kameme uraa wa re kani madi cukunon in tari ti hura me cangi madi suri in matum anyimo atii uraa. ");
INSERT INTO jni_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ani iteshi uguna shi me udange Ugomo Asere uni uzi, abanna me bibe bu Ugomo Asere biraa a nyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Inki uye ma cara udenge Asere, Asere adi cari men, abanna me udange uca sere uzatu umadini uni, animani shi izi. ");
INSERT INTO jni_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Kati irangi acce ashi me, inki uye ushi me ma hira marusa abanga uganiya ugeme, cati ma cukuno unu urosa abanga. ");
INSERT INTO jni_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Wa ira urosa abanga unee ugeme ibabbana ini ahira Asere, sa nyetike “Ma mensi anu urosa abanga anyimo amalim mawe me.” ");
INSERT INTO jni_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","“U aye ana me, Ugomo Asere mā rosa ubassa abanga wanu urosa imum ishalala ini. ");
INSERT INTO jni_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ane ani ukasu utira ubigiri uzoni ahira anu! barki vat imumu ishe ini. ");
INSERT INTO jni_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Nyani Bulus, nyani Afollos, nyani kefas nyani unee, nyani uvenke, nyani iwono nyari ti mum mu tikanime, nya timum mu tige sa ti eze vat tishe tini. ");
INSERT INTO jni_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","A yenni ini imum Ugomo Asere ini, Ugomo Asere wa sere mani. ");
INSERT INTO jni_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Idi zikin duru ama, hani, gusi arere Ugomo Asere wanu anu inta utize tini hunzi ta sere. ");
INSERT INTO jni_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Wannu agino me anyara ana kadura ka meme wa cukuno anu zatu amadini. ");
INSERT INTO jni_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Abanna me ahira am, imum icingili ini iwuzam tize timi kobbo, nyani a nire ni kobbo nidang, abanna mi indake in wuzi nicce num tize tini kobbo. ");
INSERT INTO jni_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Intam nyani abusa tire tize a nicce num, unu guna inzom in madini, Ugomo Asere maniunu wuza um tize tini kobbo. ");
INSERT INTO jni_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Barki ani me, kati i weki tize tini kobbo uganiya udaa, Ugomo Asere Unu aye, indi pogizo vat tirorunga sa ti raa a mariu. Ma kuri burko utirze uti mum mu a muruba, abine ani madi kem ununziko ahira ahira Asere. ");
INSERT INTO jni_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Anu henu, inki ma inko iruba in nan ka pollos barki shime, gusi ahira aru me ani idi manza tizen, tize me unu guna ana “kati e akki imum be sa anyetike”. Ya cukuno uguna kati uye anyimo ashi me mapoh ma bezi uguna mateki uye anyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Abanna me aveni ma ira usas ushi me naa ayee? Nyanini izini ige be sa daki anyanki shi ini ba? Inki anyanki shi ini nyanini ya wuna izina tire igiri kasi daki anya shi inii? ");
INSERT INTO jni_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ya mu kem nononzo vat tironga aige be sa inyara! Ya mu cukuno anu kem! Ya mu tuba bezi tigomo-abanna sarki nigoo nan haru! Ane ani, unyara iruba in, barki ti wuzi ti Gomo nigoo nan shi. ");
INSERT INTO jni_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Ubassa um haru a hana akadura, Ugomo Asere saokin duru ani goo na dumo kasi anabu sa ameki we tize ani kobbo tu huna. Ta cukuno imum uhira aje unee, a hana akatuma ka Asere, uhana anabu. ");
INSERT INTO jni_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Ta cukuno anu zatu urosa imum barki Ugomo Asere, abanna me shi anu urose wani anyimo Ugomo Asere, haru anu sisikime uni, a shi ana nikara wani, azome nu hira uru anyo iri mum, a shi benne anu a dandang. ");
INSERT INTO jni_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Uye uge uganiya me, tizin nu wuza awe ikomo nan ni weh ni gmei, anu uzenzeng, takuri ta cukuno ta dira tukura. ");
INSERT INTO jni_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ta wuza matum kang, tizim in katuma in tari tiru uganiya sa a jorkon duru, ti wuza biringara bi rere, uganiya sa ti zin nu kunna apum ti ke ti tiri iruba. ");
INSERT INTO jni_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Uganiya sa a zogizon duru tibo tize anyino unyinza utize ta cukuno, ahira agina a zikan tironronga tire-re sa tizi zenze ti madini. ");
INSERT INTO jni_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Daki ma nyetike ti mum mu tige me barki in nya shi mu me, ane ani barki be sa wa raa uruba im. ");
INSERT INTO jni_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Inka izi nanu inta anu akure ukiran anyimo Asere, izo shi aka acco gbardang, abanna mi ma cukuno Yeso Ugomo Asere unu bezi utize ta sere. ");
INSERT INTO jni_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Barki ani me in tisa shi icukuno gusi mime. ");
INSERT INTO jni_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ine ini ma tuma Timoti a hira ashi me, unu hem ina nu, unu kaba anu anyimo Ugomo Asere, in ringi shi tinaa me anyimo Ugomo Asere, Kusi abezi utize sa in bezizi anyimo tidenge. ");
INSERT INTO jni_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Ana me aye a shi me wa cukuno unu tiri igiri wa wuza gusi in da hanan ahira a wa me. ");
INSERT INTO jni_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Indi e ahira ashi me azo unu daddankino, in ki Ugomo Asere ma hem, abini me ani indi rosi tize tanu tiri ubigiri, indi kuri in iri nikara niwome. ");
INSERT INTO jni_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Abanna me, tigomo tasere azo tize tini cas tizi abanna me ta cukuno in nikara. ");
INSERT INTO jni_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Nyani I nyara? in e ahira a shi me unu impo amaru nyani unu hem nyani in bibe bitize bi ruba isheu. ");
INSERT INTO jni_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Ta kuna unu guna madini mara anyimo ashime, usanda umadi sa da a hem imani anyimo anu zatu urusa Asere ba. Kadura sa ma kem ine ini, uye anyimo ashime ma Musa nan unee aco umeme. ");
INSERT INTO jni_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","In kuri izuna nonzo kan! Azo iriba ibit ini idi wuzi ba? Me desa ma wuza ani me, ca a suso me anyimo ashime. ");
INSERT INTO jni_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Sa acukuno ani me in zom nan shi anyimo abibe, mamu cobo de sa ma wuza ani me, ane ani irani ahira me. ");
INSERT INTO jni_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Uganiya sa ya orno anyimo a niza ni ugomo Asere, bibe bizi nan shi anyimo urusa Ugomo Asere, mamu cobo unu ugino me. ");
INSERT INTO jni_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Ma wuna ani me barki iwiti unu ugino me ahira bibe bibur bati be huu nipum me, barki bibe bu meme bekem ukaba uwui Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","U vavi igiri ishime da wa wuna urii ba. Ida rusa shi imumu wuza imum iboo kuzi cin kudi wu imum idan iwuu gbardang? ");
INSERT INTO jni_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Kpicuni ace ashi ahira imumu ikuzu ibozu ibozo barki icukuno ni gura ni soo, imimare izatu imumu ubozo. ya cukuno awito vana Asere, vana ubi tam bi wito. ");
INSERT INTO jni_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Barki ani me, ca ti wuzi ni ori nuru sarki imum buzo imimare ikuzu, imum ibuzo imumare izenzen nan icara abanga. ");
INSERT INTO jni_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ma nyete shine anyimo aka idura unu guna kati i wuzi tanu nani ori na nabu ba. ");
INSERT INTO jni_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Azo izinu boo ni ori na nabu nu nee nini ba, nani anu inta pash, nani akari, nani anu tarsa ima kiri, ya cukuno, ingi idi harzina se ya ceki unee ugeme. ");
INSERT INTO jni_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ana me izinu nyete ushine unu gunu kati iwuzi tanu vat desa agusa me uhenu inka ma ciki anyimo amadi, nani u inta pash, nani utarsa umakiri, na inka me unu boo ivai mani, nani unu bi siza siza, nani ukari. kati iri imimare nanu sanda unu ugino ba. ");
INSERT INTO jni_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Barki ada ke awu aneni ainki tize tini kubu nan andesa wa zi anu udenge Asere ba? In ani me, azo she wani idi wuzi u inko utize tini kubu tan de sa wa rai udenge Asere? ");
INSERT INTO jni_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","In ani me Asere ani awesi u inko utize tini kubu tan desa wa ra a matara. “Susoni unu imumu iriba a nyimo ashi me. ");
INSERT INTO jni_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Inka uye anyimo ashi me mazin imma tara nan uye, ca madusa ani kubu ahira unu inko itize tini kubu tu zatu kadure, sa unu guna a hana ahira anu tarsa Asere? ");
INSERT INTO jni_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Shi ida rusa shiba, anu tarsa Asere wani wadi wuzi unee u inko u tize? Inka she wani idi wuzi unee u inko itize, se ibuki kadure ka uni izatu iriri? ");
INSERT INTO jni_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ida ta shiba haru wani tidi wuzi ibe ya Asere u inko utize tini kubu? Nani u inko utize tini kubu katuma ki ivai? ");
INSERT INTO jni_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Inka iwuza u iso utize tini kubu katuma ka kani nan ko di uya uwui, nyani ni ya wuna ko di uya uwui, nyani ni ya wuna ihazan unu sanda ubasa utize tigino aje ande sa wa zome anu udenge Asere ba? ");
INSERT INTO jni_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Ma buka ani me bati in kunna me eh. Uye mazo me unu rusa abanga a nyimo ashime sa mada ki ma barka tize anyimo ani henu? ");
INSERT INTO jni_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Kasi ane ani izi, unu tarsa Asere ma ha unu nu tarsa Asere ani kubu, aje adesa mazo me unu tarsa Asere ba! ");
INSERT INTO jni_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ti cukum tu zatu urunta anyimo anu tarsa Asere ya bezi uguna ya mu sizike shi. Nyani ya wuna uda nata we utame uwe ba? Nyani ya wuna udi hem ateki we ba? ");
INSERT INTO jni_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ana me ya wuza aye imumu izenzen ya kuru ya yomko we, we wana henu ushi wani! ");
INSERT INTO jni_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Itashi ba anu zatu kadure wa wada kem uribe Asesere ba? Kati ihem ina na mocoba. Nan anu madini, nan anu zatu tarsa Asere, nan ana madini, nan anu tarsa ahana eh, namu cara a hana aruma. ");
INSERT INTO jni_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","Nan akari, nan anu inta pash nan ana bi siza nan anu tizogo, nan akari - uye anyimo awe me mada ribe anyimo Asesera ba. ");
INSERT INTO jni_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Ane ani aye anyimo ashi me wa zi, anu a kpico we, awito shi ahira Asere, a kurzo uturi ishi me reb aje Asere anyimo aniza ni Ugomo Asere Yeso unu bura, a hira abibe ba Asere aru. ");
INSERT INTO jni_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Vat timumu tum tini, “Azo kondi ayani ini ika tuma ba. Vat timumu tum tini” Ada hem me iri imum iteki nikara num ba. ");
INSERT INTO jni_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Imimare barki apuru ani, apuru barki imimare ini” barki ani Asere adi kari we vat. Barki ani me una madini ma zinu wuza umadini ini ero nan nipum numeme. Da awuna ni pum barki madini ba barki ani me, ni pum barki Asere ani, Asere adi wuzi nipum timum. ");
INSERT INTO jni_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Asere a hira ugomo Asere, madi hirzan duru unikara numeme. ");
INSERT INTO jni_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Ita shiba apum ashi me ti hihira ta Asere tini? Ida ke Iziki ta hihira ta Asere in pati na unee umadi? Uwuza ufai! ");
INSERT INTO jni_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Nani itashi ba vat desa ma toozo na uneh umadi, ma cukuno nipum ni inde nan me? ");
INSERT INTO jni_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ane ani tize ka Asere ta buka, “We wa re me wa cukuno bi nama bi inde”. Barki ani me desa a pati nan Ugomo Asere ma cukuno bibe bi inde na me. ");
INSERT INTO jni_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Suma ni madini! Kondi ya imum imadini sa unu ma wuza amatara ini pum nini, barki ani me una madini ma zinu wuza umadini ini ero nan nipum numeme. ");
INSERT INTO jni_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ita shi ba apum ashi me udenge u bibe bi riri, bi ge sa bi ciki anyimo ashime, be sa ya kem ahira Asere? Ita shi unu guna shi azo ace ashi ani ba? ");
INSERT INTO jni_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","A kwa shi ini kirfi gbardang barka ani me, nonzo ni Asere in napum ashi me. ");
INSERT INTO jni_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Barki timumu sa anyetike, “Ya wuna uree unubu kati ma dari uneh ba.” ");
INSERT INTO jni_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Barki timumu ti madini sa ta wuna gbardang, ya wuna uri kondi uya yana uruma macukono nan uneh ume kondi uya uneh macukuno nan uruma ume. ");
INSERT INTO jni_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Kondi uya unakuru ma nya uneh umeme Imum be sa ma nyara, kondi uya uneh ma nya uruma, umeme Imum inyra inipum. ");
INSERT INTO jni_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Uneh mazo inu bezi ini pum nume ba urama mani inipum nu neh um, ane ani, uruma mazo unu bezi ini pum nume ba uneh me mani. ");
INSERT INTO jni_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Kati in Karti ace ashi inapum ashe ba, se inka konde avi ma hem, wuza ani me barki ibenki ance in biringara iduku saku ugur na, barki kati bibe bi buru bi rangi shi barki uzatu meki ace ashi me. ");
INSERT INTO jni_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","In boshi anime barki kati imum me icorno me, azo ma wuna shi ba. ");
INSERT INTO jni_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Ma nyara ko da vi macukuno kasi mi, barki ani me koda vi mazi nu aye urizo ume, uye mazi nu sanda urizo uge uye ugino. ");
INSERT INTO jni_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Ahira anu zatu anyah nan anu zatu anu ruma, ya wuna uree wa cukuno sarrki anyah, kasi uzina um. ");
INSERT INTO jni_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Barki anime inka wada ke wa meki ace awa ba, ya wuna uree wa wuzi anyah, Iteki uni ree wa wuza anyah inu guna wa ceki gmei ma aje. ");
INSERT INTO jni_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ahira ana tinyah, in nyiza ti tize ti ge me - azo me ba, ugomo Asere mani “Kati uneh ma ceki uruma ume ba”. ");
INSERT INTO jni_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","In ka ma ceki uruma umeme, ca ma cukuno sarki anyah nyami ma barka nan uruma umeme, ane ani kati uruma, “ma ceki u me ba. ");
INSERT INTO jni_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ahira ukasu anu in gusa azo Asere ba inka ure uhena mazin uneh azo unu tarsa Asere ba, Inka ma hem ma cukuno nan me kati ma ceki me ba. ");
INSERT INTO jni_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Inka uneh mazin unu ruma unu zatu tarsa Asere, In ka ma hem ma cukuno nan me, kati ma game uwuza anya nan me ba. ");
INSERT INTO jni_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Uruma unu zatu ukuba Asere ma cukuno a inko sas barki uneh ume me, uneh uzatu ukabe Asere ma cukuno a inko barki uruma umeme unu kaba Asere barki ane ba ahana ashime wa cukuno ana madini, barki anime we anu inko wani. ");
INSERT INTO jni_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Barki ani inka uroni unu zatu tarsa Asere ma suro, ca a ceki me ma suri, usanda imum igino me, uhenu uruma nan uhenu u eh azo atiri ziza we ini unu mko utize tuwe ba, Asere a titan duru ti cukuno anyimo a masaa. ");
INSERT INTO jni_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ane ni urusa awu uneh, ma madi buri uruma uwe me? Nani aneni huu uruma udi buri uneh uweme? ");
INSERT INTO jni_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ca konda avi ma wuzi Imum besa ugomo Asere a inko me, ane ani Asere atita me, Ine ni ubuka a ko di uya udenge Asere. ");
INSERT INTO jni_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Unu mazin nigbari uganiya sa a titi me ukaba Asere? Kati ma wuzi dibe ukunna utize, unu mazo me ini gbari uganiya a titi me ukaba utize? Kati ma nyari nigbari. ");
INSERT INTO jni_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Nigbari nan uzatu unigbari azo ine ini anyara ba, Imum Idang me ine ukunna utize nan u inko utize ta Asere. ");
INSERT INTO jni_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Konde avi ma tunno anyimo utita sa Asere atitime uganiya sa ma kabi tize ta Asere. ");
INSERT INTO jni_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Huu urere mani uganiya sa Asere a titi we? Kati u inki iriba in aneba, inka uzin unu ira upitii kati uwuzi ane ba. ");
INSERT INTO jni_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Barki desa Asere atiti me uganiya sa mazi urere, ma buru we Asere ane ani desa abura me uhana ukaba Asere, urere Asere mani akwa shi ini kirfi idang barki kati icukuno arere anabu. ");
INSERT INTO jni_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","A kpi shi in nu kalu kati icukuno arere anuba. ");
INSERT INTO jni_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Anu henu ukodi ya uganiya sa ko da avi uru ma ra anyimo a titi duru uhana kaba utize ta Asere, ca ti cukono anime. ");
INSERT INTO jni_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Andesa da wamu wuza anyah ba, inzom un ure ubuku ba in ani me ingusa desa a hira anipum na Asere, icukuno ani me. ");
INSERT INTO jni_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Barki ani me in hira barki tize ti buru sa ti hana azo inu dadon kino ba, ya wuna uri inu ma cukuno anime. ");
INSERT INTO jni_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Wa tira vanu eh? Kati unyari ubuka ahira ameme, Da wa tira vanu eh? Kati unyari anya nan vanu eh. ");
INSERT INTO jni_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Barki anime inka wa wuza anya da wa wuza inium imadini ba, in ka vanu eh unu zata anya ma wuza anya, da ma wuza madini ba, in ka vanu eh unu zata anya ma wuza anya, da ma wuza madini ba, se andesa wa wuza anya wadi ziti sasas uganiya sa wa zin ini vai, in kuri inyari uhara uwe. ");
INSERT INTO jni_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Barki in boo uhenu uganiya wa aka: ca ande sa wa zin ina neh wazi ticukum kas ande sa wa zin we ba. ");
INSERT INTO jni_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Ana aso wa cukuno kasi anu zatu aso, anu apuru arum kasi anu zatu apuru arum, anu kpija itimumu kasi anu zatu imum. ");
INSERT INTO jni_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Ande sa wa wuza tanu nan unee kasi ande sa wa ha nan uni ba, barki tamu tu nee ta aye ubinani umara. ");
INSERT INTO jni_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","In nyara in suri anyimo uba bgardang, unu zatu anyai mazi nu basa abanga Asere, ane ni madi kabi me. ");
INSERT INTO jni_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Una nya ma basa abanga a timumu tunee, aneni madi hem uneh ume. ");
INSERT INTO jni_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Iriba imeme ya harzina. Uneh unu zatu anya mazinu basa u timumun ti ugomo Asere, ane ani madi inki nice nume in bibe ba Asere. Uneh una nya mazinu basa abanga unee, aneni madi hem unu ruma umeme. ");
INSERT INTO jni_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","In boshi anime barki ubasa ushi uni, azo barki in gbari shi ba. Ma buka ani barki imum besa izi anime, kasi usanda utarsa Asere sa muriba mushi ma harzina ba. ");
INSERT INTO jni_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Inka uye ma basa unuguna imum be sa ya kem kubura kumeme - Inka ma aka tiwe ta nya, ani me ya cukuna - ma wuzi imum be sa ma nyara. Azo madini mani mazinu wuza ba. Ca wa wuzi anya. ");
INSERT INTO jni_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Barki anime inka ma tonno ini kara iribe, imeme, inka mada siza me ubusara ba, mada kem ma inta nice numeme memmerun, ma kuri ma tira iriba imeme ma wuzi ani me, ma rusi utarsa in kubura kumeme ya wuna uri. ");
INSERT INTO jni_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Barki anime, sede sa ma wuza anya nan kubura kumeme ya wuna uri, me desa ma zauka uwuza anya ma wuza memmerun. ");
INSERT INTO jni_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","A tiriza uneh barki uruma, u vat ticukum tumeme. Barki anime inka uruma ma wono, ma da ke ma wuzi anya nan desa sa hem nan me, ca ma wuzi anyimo Asere. ");
INSERT INTO jni_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","U ira um, madi teki ini riba irum. In kuri in basa izin in bibe ba Asere. ");
INSERT INTO jni_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Usuro imumare Sa a wiro makiri: Tirusa uguna, “vat uru tizin nu rusa.” Urusa ukeuē Jezze Uni boroo, U hemu wuza a soo. ");
INSERT INTO jni_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Inki uye mabasa marusa ire mun, unu ugi nome mamu rusa imumbe sa yawuna urii marusi ba. ");
INSERT INTO jni_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Inki uyd mazinnu hem inna Asere, masa rusa innu nugeno me. ");
INSERT INTO jni_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Usuro abanga imuma re sa a wiroo makiri: Ti rusa u guna, “makiri uneēge me daki iri mum inibi, “ukuru buka” Are Asere azoni senke a inde.” ");
INSERT INTO jni_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Inki aguna aginome sa atisa makiri marāni, nani anyimo Azesere nani u neē. Kasi gusi sa aye warani agussanwe, “makiri sas, sas, uneē nani Azesere.” Kāsi gusi besa “makiri marāni nan ana ti kura” gbardang. ");
INSERT INTO jni_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Anime ahira aru, asere a inde ani, a coo uneē vat, usuro u me uni a bara vat timumum barkim e, ti vengize, Ugomo Asere U inde mani, dēsa usurou me uni kodi nyani ya cukuno, hartu me cangi, usuro ume uni tirāni.” ");
INSERT INTO jni_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","A' anime daki kōvima mazin nu rusa ugimo me ba. Ine ini yawuna dāti u tuba, aye wa nanzo makiri, wa kuri ware iginome kasi igebesa, awuza makiri. Iriba iwe ya counome barki uzattu ini kara nutonmo. ");
INSERT INTO jni_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Daki imummare ini inyinza unu ukaba uruba, kogussi daki ta tā kin ki ukaba uruba, kogussi daki ta reba ida kassika me ukaba uru ba. ");
INSERT INTO jni_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","A name wuza seēke kati uturi u wome u cukuno binyo bu pilliko u'uye unu zatu ni kara ni kadure. ");
INSERT INTO jni_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ubata uyerine, inki uye unu zatu ini kara nuturi iriba ma irawe hu unu rusa, u zinna re imumāre sa awito ma kiri, dakki wa nyame ni kara narū in guna mari imumare imakiri me ba? ");
INSERT INTO jni_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Barki urusa uwe azesere uzina u makiri, u henu unu zattu mikara nu tonno iriba, dēsa yeso ma wi barki me' a humee. ");
INSERT INTO jni_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Barki anime, inki wa cara aye anu hanu anu zatu nikara nuturi iriba, wawuza ni hara ni madini aje Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Inki imumure idi wu uhanu ma pilliko, indi venke are irama, barki kati in hungu ko anu henu um urizo. ");
INSERT INTO jni_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Mi da anu zatu uganiya uni? Da ma ira Asere am Yeso ba? Da she wani katuma katari tume anyimo Asere ba? ");
INSERT INTO jni_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Da mi una kadura ka aye wani ba, kadure mi una kadura kani ahira ashi. Shawani anu inko Urusa uka dura kammeanyimo Asere ");
INSERT INTO jni_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Utunu um uye ahira adesa wa boo anice num; ");
INSERT INTO jni_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Ti zo duru unugamiya are nani usa ba? ");
INSERT INTO jni_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Ti da ke ti ziki unē anyimo anu uhem kasi sa ta ta ziki amutarsa Asere nan kefas ni henu anyimo Asere? ");
INSERT INTO jni_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Nani Barnaba mani nan mi tidi wuzi katuma. ");
INSERT INTO jni_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Aveni madi wuzi katuma ka Unani kara nika tuma ka ma nyanga ini kirfi ime? Aveni madi wuzi ti bira sarki are imum me sa ma bira? Nani Aveni madi canti itam mada sa mahenu mawe ba? ");
INSERT INTO jni_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","In boo ani me in nikara nu, unu nini? U inko utize da wa buki anime ba? ");
INSERT INTO jni_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Ayettirke anyimo U inko utize ti Musa agi, ku barka ku katarek ingi kuzinu batalla idawa kati i wu kuni ni zin ba. Ine ini Asere aboni? ");
INSERT INTO jni_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Da barkiharu wani maboniba, A yettirke barki haru wani. Barki desa ma wuza a vara, ma wuzi katuma unu iso iriba. Unu upatalla ubi sana ma wuzi unu inko iriba ukem. ");
INSERT INTO jni_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","In gi ta wuza tibira ti huma anyimo ashime, ti da ziton duru ti kem tirunga ta a pum ashime? ");
INSERT INTO jni_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Inge aye wa wuza katuma unu'ira ugenome, tida teke awe unu ira ba? Vat anime da ta wuza katuma uni ira me ba, A, anime, Na ti ti iri ni iriba imum me sa idi kartin duru katuma ka Yeso. ");
INSERT INTO jni_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Ida rusa shi ba ane ani arere anyimo udenge Asere wa kenzi imumare iwe me abini ani? Ida rusa shi ba anu aka tuma ahira utunzino ana dang udenge Asere, wa kenzi imumare iwe ahira imumare sa a ezeni abini me. ");
INSERT INTO jni_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Ane ani Asere agu ana ka tuma ka Asere wadi ri imumare iweme una ukatuma kawe me. ");
INSERT INTO jni_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Dama wuza katuma unu ubuka ugino me ba, da a yetteke shine barki awuzum ire imum inini ba, ma hem in wi barki unu gona uye ma kartum uvavi ubigiri. ");
INSERT INTO jni_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","In ma boo tize ta Asere, daya cukunom imum i vavi u bigiri barki ya cukunom iriri in wuzi kani. ");
INSERT INTO jni_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Im ma wuza katuma kagino me uni hem, in zin iri imum unya in daki uni hem iriba in ba, in zirimum u nya. ");
INSERT INTO jni_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Yanim imum me sa adi nyam? Ine ini ni wuzi katuma ka Asere sarki imum unya, a, anime inda wuzam katuma uni'ira anyimo katumaba. ");
INSERT INTO jni_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Me mani u'ira u vat, ma kurzo nice num urere u kunde avi barki in kem anu gbardang. ");
INSERT INTO jni_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","A mayuhuma, ma cukuno uyahudawa, barki in kem ayahudawa gwardan, ahira adesa wa tarsa udungara Umusa, ma kurzo nice num kasi we, barki in kem asesa sa wa tarsa udungara Umusa. Ma wuzi ani da agi in raa anyimo udungara Umusa uni ba. ");
INSERT INTO jni_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","An desa wada raa udungara Umusa ba, ma kurzo nice num kasi we, A'anime dama ceki udungara Asere ba. In raa U inko tize ta Asere. Ma wuza anime barki in buri adesa wa tarsa udungura Umusa. ");
INSERT INTO jni_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","U watu anu zatu unikara, ma kurzo nice num kashi we, barki in buri anu zatu nikara. Ma kurzo nice num vat imum barki vat anu barki in kem una ubura aye uhana ukem ubura. ");
INSERT INTO jni_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","In wuza vat imum barki katuma ka Asere, barki in kem ure aje anyimo katuma ka Asere. ");
INSERT INTO jni_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Ida rusa shi ba anu gbardan, wa ribize a magasiya unu u inde mani cas madi agiza ma kabi ukalun me, barki anime wuzani magasiya barki i kem ukalum. ");
INSERT INTO jni_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Unu biranza madi tirzi nipum nume gangang barki makem ukalum ugebe sa udi cueme, haru tizin magasiya barkin ti kem ukalum ugebesa uda curzino me ba. ");
INSERT INTO jni_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Barki ani me inda wuzam magasiya nani in boo anime kasi unu tira upebu. ");
INSERT INTO jni_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","In zinu upatizi uni pum numin kurzo nini urere, kati ingi ma wuza ayi tize ta Asere a kuri asusum. ");
INSERT INTO jni_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Innyara irusa, ni henu, aka coo uru wara ana dizi Uganjimari wa kuri wa tarsa anyumo uraba udandang. ");
INSERT INTO jni_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Vat uwe awuza we ubaptisma angumo ama ganjimari nan uraba udandang. ");
INSERT INTO jni_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Vat uwe waree imum yarce ibibe biririn usandu inde. ");
INSERT INTO jni_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Vat uwe wa si imum usa ibibe biririn usandu inde. Barki sa wa si ahira ani poo nibibe biririn sa na tarsi we, nipoo me ninee nini vana Asere. ");
INSERT INTO jni_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Daki Ugomo Asere maa kunna urunta uma roo mawe ba, mukizi muwe me mu samirka anija. ");
INSERT INTO jni_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Ana me timum tigeme imum ubatta ini ahira aruu, kati ti inki timum tibur amuruba kasi wenne ba. ");
INSERT INTO jni_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Kati icukuno anu tarsa umakiri kasi āye sa waa wuzi. Kasi unyertike sa āwuzi, “Anu waka vukuno wa ri wa si wa kuri wahirri wawuzi biranza.” ");
INSERT INTO jni_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Kati timussi wana nee naa anu ruma mabura nan inyani sa inzo aru wani ba, kasi maroo mawe me, roni inde anuu a ino ukiran kana kuru are inkani kataru (23,000) wa wee. ");
INSERT INTO jni_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Kati timansa vana Asere kasi sa maroo mawe mawuzi, iwa ihuzzi we. ");
INSERT INTO jni_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Kati ticukuno anu humoro kasi weme, wa wiji atari tibibe bika dura ka Asere biwono. ");
INSERT INTO jni_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Timum tigeme takem we bati icuunon duru imum ubatta. A nyertike icukuno imum ikubum, haru ande sa umara unee wa aye ace aruu. ");
INSERT INTO jni_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Barki anime, ca komdevi magamari memmerum, ma wuzi merum kati marizi. ");
INSERT INTO jni_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Umansa uda ayeshi, uge sa wamu aye anyumo uvat anuu ba. Anyo, Asere ahuma ani. Madā cekime amansa shi unu mansa sa udi aki nikara nishi ba. Madi nya shi unaa uroo anyumo ubata me sa adi wuzi shi. ");
INSERT INTO jni_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Barki anime shi ande sa mahemshi cekini utarsa umakiri. ");
INSERT INTO jni_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Inzi tize nan shi kasi anuu bassa ukang, bati I batti imum sa inboo shi. ");
INSERT INTO jni_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kusso kuringirka kuge sa tizin unu tingirka me, inzo nigome nine anyumo amaye ma vana Asere? Ubiredi me sa tizin upozo me, inzo nigome nine anyume vana Asere? ");
INSERT INTO jni_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Barki ubiredi u'inde uni, haru gbardan ani pum ni'inde. Vat uruu tidi rii ubiredi u'inde nigome. ");
INSERT INTO jni_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Irani anuu Isaraila; ida rusa shi ba ana katuma udenge Asere wakenzi imum yaree abinime ani ba? ");
INSERT INTO jni_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Nyani ni in gusan shi ani me? Makiri imum ini? Nani imumare sa anyinza makiri, ire imum ini? ");
INSERT INTO jni_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Mi inzin tize atimum sa anu zatu tarse Asere wa ninza, wa ninza agberge ne wani inzo asere ba. Inda nyaram Iwuzi tanu nan agbergene ba. ");
INSERT INTO jni_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ida saa shi aku soo ku Ugomo Asere ikuri isii ka gbergene ba, ida ree shi imum yaree Ugomo Asere ikuri iree ya gbergene ba. ");
INSERT INTO jni_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Nani tinyara tiwu Ugomo Asere ni'eru? Titeki me nikara? ");
INSERT INTO jni_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“Kondi nyani izi rep,” Inzo kondi nyani izin katuma ba, “Kondi nyani izi rep” inzo kondi nyanini I'eze unure aje anu ba. ");
INSERT INTO jni_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Kati uye ma nyari ubura unicee nume ba, anime manyari ubura uhenu. ");
INSERT INTO jni_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Udake uree vat imum me sa azin unu ziza me ukasuwa, sārki ubasa utize. ");
INSERT INTO jni_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Barki “unee nan vat timum me sa tira anyumo me I Ugomo Asere ini.” ");
INSERT INTO jni_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Ingi unu zatu uhem in na Asere ma titawe agi irii imum yaree, ahun ini ruba yaree me uree vat imum me sa anya we sārki uhara Iruba. ");
INSERT INTO jni_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ingi uye magunan hu, “Imum yaree ima kiri mani” kati uree ba. Udi wuu anime barki de sa mabuka we, nan bassa. ");
INSERT INTO jni_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","In boo Ubassa ude sa mabuka we inzo ubassa uwe ba. Barki nyanini adi ziki ucara uye acani mi? ");
INSERT INTO jni_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Ingi ma guna ankoi barki imum yarce sa maree nyanini idi wu azogun barki sa maguna ankoi? ");
INSERT INTO jni_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Barki anime, ingi uzin naree nan usaa, wuza vat barki unonzo asere. ");
INSERT INTO jni_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Kati ucukuno unaa upilko, wa yanhudawa, nan Aheliniyawa nan anuu Asere ba. ");
INSERT INTO jni_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Ma wuza morso bati in rumi vati anuu muruba vat atimun. Inzo barki nicee num ba, barki konderi: Ma wuza anime bati wa kem ubara. ");
INSERT INTO jni_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Zikane umanza ahira am, kasi mi sa in manza ahira Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Aname inzen ninonso nesh nene, barki izen nu rengeze nan mi animo kode yani, inzen ninonzo nish ahira utarsa anabo rep sama naya shi. ");
INSERT INTO jni_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Mi manayara irusi, unaje anabo Ugomo Asere mani, una je. U vanu e unubo mani una je u vana Asere mani. ");
INSERT INTO jni_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Vat desa ma una birengara nani mabuki ure ubeze nichi ne meme innu impo, macara ireba una kura ame ane. ");
INSERT INTO jni_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Vat vanue e sa mauna birengara nichi numeme innu pako nani ma buki ure ubize sarki impo uni chi, ma cara ireba una kara ame ani ma ze rep nan desa ma kara techi tumeme. ");
INSERT INTO jni_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Vanau e sa madi da nichi ba, nani makare tichi ti cukuno magetu imum imu e mune vanau e makare tichi tumeme, caki ma inpe nichi numeme. ");
INSERT INTO jni_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Daki yauna ure vana uruma ma impo nichi mumeme ba, baki me abarka me kasi Asere nannu gongo wa Asere vanau e ugogon unubo mane. ");
INSERT INTO jni_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Barki vanau ruma ma suro nipom ni vanau e mani ba. ");
INSERT INTO jni_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Daki abarka vanau ruma barki vanau e ba, barki aneme, abarka vanu e barki vanu ruma. ");
INSERT INTO jni_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ine ini yauna vanau e made beze ubare, kasi bibeu ba Asere. ");
INSERT INTO jni_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Vat anime, ahira uruma umeme, daki aharawe ba, ane ani daki aharawe nan nuru mame ba. ");
INSERT INTO jni_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Kasi vanau e mani ahira a vanau ruma, ane ani vanau rume kasi uyo uvanau e mani, vat timumme tsuro ahira Asere. ");
INSERT INTO jni_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Wekine inna chi asheme, memmiru ine vanau e mau birenga sarki impo une chi? ");
INSERT INTO jni_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Nani utanda, wabezeshi imum imu eh ine vana uruma machiki tich tumeme sarki ukarsa? ");
INSERT INTO jni_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Ingusa utanda wabezeshi age vanau e mazen tich kan, ninonzo neme nen ba? Barki ma inpe nech nine. ");
INSERT INTO jni_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Inka uye manayara mauze matara barki tize tigenome, haru tizen ure utanda, ati denge ta Asere ba. ");
INSERT INTO jni_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Ubukame sa uhaka daki manon zeko shi ba, nigura nishme nireren nene ba nu zatu kadure kani. ");
INSERT INTO jni_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Innu tuba me, uganeya sa yazen negura nu dege wa Asere, makunna age uhar zena urani animo ashi me, matubu hem in tize me. ");
INSERT INTO jni_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Gai ine akim ana matara animo ashime, barki arusi anu kunna utize animo ashe me! ");
INSERT INTO jni_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Barki - kaya gurna ahira indaye, avo imumare Ugomo Asere ine izen nareme ba! ");
INSERT INTO jni_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Uganiya me sa izen nare imumare, kodave mazenna re imumare ime ine kasi ukasu uye makunna ikomo, uye mazen nareme har mau hem. ");
INSERT INTO jni_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Izen tikura me sa idare nane ise, izennu iza udenge wa Asere, nane izen nu yammuko andesa wazen nurusa ba? Naye nene inde buki shi? Inde nonzeko she ine? Inda nonzeko she ine? Inde nonzeko sheba ahira imum igenome. ");
INSERT INTO jni_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Imum be sa makabe ahira Ugomo Asere ineini ma nayash age Yeso vana Ugomo Asere, aniyeme sa azezeme, manno ma ze ki imumare. ");
INSERT INTO jni_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Sa mabize apuru arum ameme, ma puse magu “kabane ina ma ine pom num nene masa nirere bar ki shi, uzane iregeze barki me.” ");
INSERT INTO jni_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Samabuka ani me, mazeki bitome me, “Magunwe sane uganiya sa izen tiyom tum usuro ani me kodave ma nayare imumbe sa ideuze uroni uture umeme katuma. ");
INSERT INTO jni_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Udaki ure imumbe sa uzenu zeza me ahira ati jamane, kati u ikiba. “Mabuka shu ne nan nemumbe. ");
INSERT INTO jni_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Sa irane anemo une Ugomo Asere ine.” ");
INSERT INTO jni_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Inka unu zatu kadure ma titawe age ikare imumare, udake uha, ukare vat imumbe sa ma ayewe azomin nuguno wa iko ba. ");
INSERT INTO jni_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Inka uye mabuka we, “Imumare igenome asera ine barki ma kire manu” kati ure ine, ude u aneme barki desa mabuka we, nannu ira uweme (vat une nan nemumbe sa irani uneme Ugomo Asere ine). ");
INSERT INTO jni_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Barki vira uweba, vira udesa mabu kawe nayane ideu anoki are aje am barkii uye? ");
INSERT INTO jni_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Inka mare imumare inne reba irum barki nayeze ade zogum age makaba inne reba irum? ");
INSERT INTO jni_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Barki ani me inka ude re nane ude-se-u-uzo ani me barki ninonzo ni Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Kati cukuno bidunta bupelko uye ba nane ayahudawa nane ahelenawa, nane utanda Ugomo Asere. ");
INSERT INTO jni_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ma uze innekara num barki inrume anabu mureba animo atimumu, avo-men-nu nayar azeser ba, ma una ani me barki ikim ubura. ");
INSERT INTO jni_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ahira timumu tige sa anya bibe bi lau nihenu, inda nyara icukuno anyimo uta me. ");
INSERT INTO jni_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","I rusa uguna uganiya sa tazi anu tame utize ta Asere arangi shi na Asere uzatu utize a tina sa sas tizatu acce. ");
INSERT INTO jni_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Barki anime in nyara i rusi uye mazo ni sa madaki nan bibe ba Asere ba Asere madā guna Yeso unu u shalala mani, daki uye mabari Yeso ugomo-Asere mani senki ahira abibe birere. ");
INSERT INTO jni_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Timummu tira sa-sas abannna me bibe bi inde bini. ");
INSERT INTO jni_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Katuma karani sa-sas abanna ugomo-Asere u inde mani. ");
INSERT INTO jni_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Katuma sa-sas abanna me Asere a inde ani abezizi anabu u wuza ukani sa madi inta. ");
INSERT INTO jni_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Ahira konde avi anya me nikara nu be akatuma kameme ahira abibe a masaa barki konde avi a iri ure u ini. ");
INSERT INTO jni_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Uye ahira abibe bi rere anya ma urusa, abanna me uye agburang ane me urusa ahira abibe bibe bi inde. ");
INSERT INTO jni_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Uye anya me ibibe bi kadure ahira abibe bigino me, uye a nyame u humza ahira abigino bibe me. ");
INSERT INTO jni_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Uye uwuza ati hara tu aye u rizo, uye unu ubuka tu aye, uye any me urusa ibe uye urusa utilem sa-sas, uye ubezizi utilem sa-sas. ");
INSERT INTO jni_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Vat ibe igino me i inde ini i turawe ma kuri mahara ibe sa-sas kobiya birani ana ubini ubuka ugino me uda hara me unu guna me are ahira ani anipum. ");
INSERT INTO jni_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Gusi sa nipum ni inde ni ni in ti hi-hira gbardang vat ti hi-hira nipum ni inde nini animani ugomo-Asere mazi. ");
INSERT INTO jni_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Ahira abibe bi inde azoro konde avi anyimo anibu ni inde nya ayahudawa nyani unu tane utize ta sere ta sere, nyani arere nyani ahana, vat uru a hanzi duru abibe bi inde. ");
INSERT INTO jni_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Abanna me nipum nizo me ni inde nini sundulum, abanna me ti hi-hira tini gbardang. ");
INSERT INTO jni_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Inki tibuna ta guna, “sa azo me dari tini abanna me in zom u na katuma ka nipum kani ba?” igino me daki ya kaska me iri imum anipumnumeme ba. ");
INSERT INTO jni_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Inki utoi udi gu, “sa daki mi nije nini ba abanna inzom ire imum ninpum ba,” ");
INSERT INTO jni_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Inki vat nipum na cukuno nije nini adi katuma in nyanini? inka nipum na guna uni utoi uni adi nyunguzunu in nyanini? ");
INSERT INTO jni_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Abanna me ugomo-Asere mā barki tihi hira anipum, usuro ira umeme. ");
INSERT INTO jni_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Abanna me sa agi anu mi nipum ni inde nini mi inda cukuno nipum me. ");
INSERT INTO jni_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ayenna ti hi-hira tirani gbardand, ani me nipum ni inde nini. ");
INSERT INTO jni_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Nije ni daki nibuki tari, “in da zom gmei nan huu ba, nyanu nicce gerte ati buna, inda nyaram shi ba.” ");
INSERT INTO jni_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Abanna me, ti hi-hira tini pum me sa ahira kasi ta sisiki me tine tini ti huma anipum me, ti hi-hira tini nipum me sa ahira kasi ta sisiki me ugongo tiki teki unu nya uwe ninonzo. ");
INSERT INTO jni_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","In anime ti hi-hira tiru ti zatu uree ira aka ken ki u ira ure u tini. Ti hi-hira tiru tizunu uree u ira azo a wuza tini uzoo. ");
INSERT INTO jni_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Abanna me Asere ani a barka nipum mā teki unu nyanza uwe ugongo uni nonzo ahira sa azinu sisiki me. ");
INSERT INTO jni_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Ma wuna anime kati a kem uharzina acce anyimo nipum, abanna me tihi-hira ti rusi ina cece aweme unu hira memeru. ");
INSERT INTO jni_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Inki ahira a inde azi ini jansi, vat tihi-hira me tidi wuzi ijasi nigo me, nyani inki anonziko nire kira vat nyani tirza utize sa a heni in tini nan maye mum, wuna ni anime isizi barki iringizi me. ");
INSERT INTO jni_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Abanna me shi wani nipum ni Yeso ugomo Asere, ukasz me ti hi-hira me. ");
INSERT INTO jni_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Unu tuba mā zauka ahana a katuma anyimo udenge utize tu ugomo-Asere i kure anabawa utaru anu bezizi utize nan anu u wuza imum ibiyau, aye anu hunza anu bengizi anu, aye ana katuma ku dungara anu, nan de sa wa tize in are alem. ");
INSERT INTO jni_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Vat uwe ahana akadure? ");
INSERT INTO jni_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Vat uwe wani wani wazin in bibe bu hunza me? Vat uwe wanii wa boo tize titi lem? vat uwe wani wa kamara tize titi lem me? ");
INSERT INTO jni_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Anu nyara wa nyara a nyinzi we timumum ti daddang. Ana me indinbe shi una urere. ");
INSERT INTO jni_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Sa ya cukuno inzin intize ina lem anabu, nan alem ibe ya Asere, in ani me inzom unu su, ma cukuno ni gareren na so akan nani biruma ba su akan. ");
INSERT INTO jni_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ko sa ya cukuno inzin in bibe biriri bi busa utize makuri ma tinka kadure ka anyimo sa ka gunne, inu rusa um nani inzin unu nya iriba, in daki mi azo iri iumum ini ba. ");
INSERT INTO jni_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Ko sa a cukuno ma nya timumu tum vat barki anyizi anu diri, ikuri in witi nipum num barki a punsi. Inka inzom unu su, daki ma kem iri imum ba. (Ma nya unu nipum num barki inbezi ubari uni). ");
INSERT INTO jni_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Usu um nanu tiriba nan iriba ishew im usu uda wuza ni ero nan ubezi ubari ba, usu uda wuza u yeze unice ba. ");
INSERT INTO jni_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Udira umu eh. Uda nonzo nice nume ba. Uzo unu debe uhirza iriba ba, uda basa me timum tizenzen. ");
INSERT INTO jni_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Uda wuza apuru arum un boo tize ba, in anime uwuza apuru arum in kadure. ");
INSERT INTO jni_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Usu utiri zaza, iriba anyimo timum vat, uyeze, in ti timum vat u kabisa timum vat, u nyiza iriba in timum vat, ukuri ukabisa timumvat. ");
INSERT INTO jni_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Usu uda marsaba, inka u iso imum in cukuno anime irani, idi aki. Inka tilem tirani, curno me inka urusa urani, udi aki. ");
INSERT INTO jni_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Barki tizinu urusa cin-cin, ti kuri tizinu boosa cin-cin. ");
INSERT INTO jni_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Uganiya sa unu rusa udang ma aye, se unu cin ma aki. ");
INSERT INTO jni_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Uganiya sa ma zi vana, ma busi tize ti hana, ma basa tize ti hana, idi nyizi tize ti hana. Sa ma una ma bari unu ma ceki timum ti hana. ");
INSERT INTO jni_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Ana me ti hira cin-cin kasi u hira umangani, roni um henu nan mu henu, aneme in rusa cin-cin, uganiya idi kem urasu dan, kasi sa awuzum urusa udang. ");
INSERT INTO jni_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Ana me timumti taru tigino me ta cukuno anime; U iko iriba eze, nan usu se imum idang anyimo aweme ine ini usu. ");
INSERT INTO jni_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Miki ni ace ikuri inya mu riba barki u ye urizo ubibe, barki in boosa tize be sa ti eze. ");
INSERT INTO jni_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Barki de be sa ma boo, tize in nilem azo ma nan na nabu wani ba nan Asere, barki azo unu kunna ume barki sa mazin ina banga timum tini hunzi anyimo abibe. ");
INSERT INTO jni_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Barki wani ma boo barki nan anabu wani ma boo barki ma barki we, ma kuri ma tarisin we, makuri ma benkiwe tiymo. ");
INSERT INTO jni_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Desa ma boo tize in nire nilem, nice tize tu udenge Asere uni ma bara. ");
INSERT INTO jni_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ubasa um agu vat ushi iboo tize ina lem, barki iteki anime ubasa, um iboo tize desa ma boo tize ma teki unu boo tize ina lem (se inka uye ma bezi barki udenge Asere utunno). ");
INSERT INTO jni_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Barki ana me, anu, henu inka ma yae ahira ashi me in boo tize in nalem, idi wu aneni inkinki ahira am? inda wuna uri ba, se inka ma buka shi tize in ti roo, nani urusa, nani rusa u tize, nani ubezi. ");
INSERT INTO jni_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Inka adado utira uzatu ivei wa suzo amyira kasi bi shiya nan ni gaita-da wa suso amyira sasas ba, aneni uye madi rusi usandu ugumu zo ubi shiriya nan nigaita sa azinu tira me? ");
INSERT INTO jni_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Barki inka ahure ni hure nan adadu uhurse uzatu nice, aneni unu madi rusi uganiya sa madi barki nipumuhana ani kono? ane ani barki shi. ");
INSERT INTO jni_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Inka unu ma buka tize ti, atu unce, aneni unu madi rusa imum be sa ya buka? idi busi tize, azo de sa madi rusi imum be sa boo. ");
INSERT INTO jni_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Kadure kani tilem sasas tira unee, azo nige be sa zo inice ba. ");
INSERT INTO jni_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Inka in tamu nice ni nire nilem ba, idi cukuno uvari ahira una tize me, una tize me madi cukuno uvari ahira am. ");
INSERT INTO jni_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Ane ani ahira ashime. Barki sa in zinu barka ba aje anabu aye bezi ubibe, tunno ni ini kara i bari udenge Asere. ");
INSERT INTO jni_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Desa ma boo tize inilem ma wuzi biringara barki sa marusa uboo me. ");
INSERT INTO jni_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Barki inka ma wuna biringara ini lem, bibe bum ba wuna biringara urusa um wa kinkin ba. ");
INSERT INTO jni_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Aneni indi wu? indi wu biringara in bibe bum, ba wuna Aneni indi wu?, indi wu biringara in bibe bum, in kuri wuzi biringara unu rusa um, idi wuzi ire nan bibe bum, in kuri wuzi ire unu rusa um. ");
INSERT INTO jni_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Inka azo ane ba, inka wa nonzo Asere in bibe bi hem, aneni desa mara amatara magu, “icukuno anime” asesere iriba irum sa uzi nu wuza me, inka mada rusa imumbe sa u zinu boo me ba? ");
INSERT INTO jni_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Kadure kani awuzi iriba irum kan, barki uye mada una ba. ");
INSERT INTO jni_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Ma wuza iriba irum nan na Asere barki in boo tize in nelem inteki shi vat. ");
INSERT INTO jni_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Vat in anime ani ori nu denge Asere in teke un su in boo tize ina guran anu chibi anyimo urusa barki in bari aye ateke a ino ukirau kanu kirau in nilem. ");
INSERT INTO jni_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Anu henu um, kati icukuno ahana anyimo ubasa abanga, se ahira akatuma ka bur, wuza in katuma ki hana, barki anyimo ubasa ushime i uuh. ");
INSERT INTO jni_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","A nyetike ane zni a tize tini kubu aguna, “indi buki tize nan anu ageme ahira anu atinyo ta lem, nan ma wa nyo. Vat in anime wada kunna me ba,”uguna Asere. ");
INSERT INTO jni_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Barki tilem ti gino me utuba ubezi uni, ahira anu nya iriba, azo se anu zatu nya iriba ba. Ubezi utize utuba uni ahira anu nya iriba, azo anu zatu nya iriba ba. ");
INSERT INTO jni_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Barki ani inka anu denge Asere wa orno, koda vi mazin in tize in nire nilem, aye wa ra a matara nan nanu zatu inko iriba wa ribe, azo, se wa guna ya wuna iran, a ba? ");
INSERT INTO jni_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Inka koda avi ma wuza u inko u tize, uye unu zatu nya iriba nani uye amatara ma ribe, tize me tidi suki me, adi kuri a weki me u inko utize. ");
INSERT INTO jni_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Tize ta apuru ameme tidi pokino, barki ani ca ma rizi ma nonzo Asere, madi buki unu guna Asere azi nigo na haru. ");
INSERT INTO jni_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Se nyani anu'”henu” um? inka ya orzino uye mazin unu zabura, udungara, tiro, nilem, nani uboo. wuza kondi nyani barki ubara udenge Asere. ");
INSERT INTO jni_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Inka uye ma buka tize in nilem akem ana ware nani wa taru ugbardan uwe me, se ca konda avi ma buki in inde. Uye madi ku buki imum be sa wa boo. ");
INSERT INTO jni_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Inka azon desa madi buki imumbe sa wa boo, ca vat uwe wa ingara tik anyimo undenge Asere me. Ca konde avi ma boo tize me akura ame me isisi me nan Asere. ");
INSERT INTO jni_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Na a anabawa wa re nani wa taru wa buki tize, na ukasu me wa kunna wa kuri wa gamirka imum be sa boo. ");
INSERT INTO jni_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Inka anya urusa dese ma ciki ahira nonozo Asere, ca desa ma zinu boo tize aname ma ingara. ");
INSERT INTO jni_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Vat ushi idake iwuzi tize tu eze ti niinde, barki konda avi ma maza, ma kurima kyem utunno in kara. ");
INSERT INTO jni_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Barki ibe ya anabawa ira adize. ");
INSERT INTO jni_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Barki Asere azo Asere uranga ba, Asere utoto iriba ini, ane ani izi vat ati denge ta Asere anu na iruba. ");
INSERT INTO jni_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Anee wunani tik udenge Asere. Asere da anya we uganiya ubuka utize ba, ba in ani me ca wa cukuno anu nata ace, kasi u inko utize wa buka. ");
INSERT INTO jni_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Inka wa manza iri mum, ca wa igizo anu ruma uwe ma akura. Barki imum imu eh muni anee wa boo tize aje ahana aruma awe me udenge Asere. ");
INSERT INTO jni_vpl VALUES ("C114_36","076_