﻿USE sofia;
DROP TABLE IF EXISTS sofia.jivNT_vpl;
CREATE TABLE jivNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jivNT_vpl WRITE;
INSERT INTO jivNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesukrístu we̱a̱trí̱ ju̱ áiniawai. Tura ashí naṉkaamas ti uunt we̱a̱t Tawitcha Apraámsha áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apraáma uchirí̱ Isak. Tura Isaka uchirí̱ Jakup. Jakupa uchirí̱sha Jutá ni yachi̱ji̱a̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tura Jutá uchiri̱n Páresan tura Sarancha Tamar jurermiayi. Páresa uchirí̱sha Esrum, nuna uchirí̱sha Aram. ");
INSERT INTO jivNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nuna uchirí̱sha Aminiatáp. Nuna uchirí̱sha Nasuṉ. Nuna uchirí̱sha Sarmuṉ. ");
INSERT INTO jivNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarmuṉka uchirí̱ncha Púusan Raap jurermiayi. Puusa uchirí̱n Uwitian Ruut jurermiayi. Uwitia uchirí̱sha Isaí. ");
INSERT INTO jivNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nuna uchirí̱sha uunt akupin Tawit. Uunt akupin Tawitia uchirí̱ncha Sarumúṉkan Patsepa jurermiayi. Patsepasha emka Uríasa nuwe̱e̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sarumúṉka uchirí̱ Rupuam. Nuna uchirí̱sha Apías. Nuna uchirí̱sha Asa. ");
INSERT INTO jivNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa uchirí̱sha Jusapát. Nuna uchirí̱sha Juram. Nuna uchirí̱ Usías. ");
INSERT INTO jivNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usíasa uchirí̱ Jutam. Nuna uchirí̱ Akas. Nuna uchirí̱ Esekías. ");
INSERT INTO jivNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekíasa uchirí̱ Manasés. Nuna uchirí̱ Amuṉ. Nuna uchirí̱ Jusías. ");
INSERT INTO jivNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jusíasa uchirí̱ Jekunías ni yachi̱ armia nu̱ja̱i̱. Nui̱ Papirúnianmaya̱ shuar Israer shuaran mesetja̱i̱ nupetkar Papirúnia nuṉkanam achirar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nu ukunmaṉka Jekuníasa uchirí̱ Saratiár akiiniamiayi. Tura nuna uchirí̱ Surupapír. ");
INSERT INTO jivNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Surupapíra uchirí̱ Awiut. Nuna uchirí̱ Iriakím. Nuna uchirí̱ Asur. ");
INSERT INTO jivNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asura uchirí̱ Satuk. Nuna uchirí̱ Akim. Nuna uchirí̱ Eriut. ");
INSERT INTO jivNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriuta uchirí̱ Ereasár. Nuna uchirí̱ Mataṉ. Nuna uchirí̱ Jakup. ");
INSERT INTO jivNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakupa uchirí̱ Jusé Marí áishri̱ya nu. Marisha Jesusan jurermiayi. Nu Jesuska shuáran uwemtikiartin asa Kristu tu anaikiamuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tuma asamtai Apraámnumia̱ Tawitnium Jesusa we̱a̱trí̱ katurse (14) áiniawai. Tawitniumia̱sha Papirúnianam jukimiunma nui̱sha katurse we̱a̱t áiniawai. Papirúnianam jukimiunmaya̱sha Krístunam ataksha katurse áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesukrístu akiiniamu jú̱nis ámiayi. Ni nukurí̱ Marí Juseja̱i̱ anajmanairuyayi. Tura tsaníatsa̱i̱ṉ Yusa Wakaní̱ ajaprumtikiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ajaprukmataisha Jusé Marin iniatsa̱a̱tsuk nin ajapatniun enentáimpramiayi. Tura ti péṉker asa aya iniaisatniun wakerimiayi aents nékainiatsa̱i̱ṉ. ");
INSERT INTO jivNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuna tu enentáimia pujái̱, mesekranam Yusa suntari̱ tarí chicharuk tímiayi “Juséá, ame we̱a̱trum Tawitchakait. Tuma asam Mariji̱a̱i̱ nuatnaikiatin ashamkaip. Uchin jurertatna nuka Yusa Wakaní̱niuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uchin áishmaṉkan takustatui tura nuna naari̱ JESUS anaikiattame. Ashí ni shuári̱n ni tunaari̱ya̱ uwemtikkiartin asa Jesus anaikiatniuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yus ni etserniuri̱ji̱a̱i̱ yaunchu timia nu uminkiati tusa nu túrunamiayi. Ju̱na áamtikramiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nuwa̱ natsa ajapruktatui tura uchin takustatui. Nuna náari̱sha Emanuér anainiaktatui.” Tu áarmaiti. Emanuérsha nu chichamnum “Yus iiji̱a̱i̱ pujuwiti” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jusesha mesekranmaya̱ shintiar Yusa suntari̱ timia núnisaṉ Marin nuatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tura uchin júreatsa̱i̱ṉ tsaniṉchamiayi. Tura jurermatai uchin Jesus anaikiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jutía nuṉkanam Piriṉ pépru ana nui̱ Jesus akiiniamiayi. Nui̱sha nú nuṉka akupniuri̱ Irutisauyayi. Akiiniamtai ti neka apach nantu tátainmaaniya̱ Jerusaréṉ péprunam táarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Taar inintruiniak “¿Israer shuara úunt akupniuri̱ tui̱ akiiniait? tiarmiayi. Nantu tátainmaani pujaati ni yaari̱ wáinkiamji. Tura tikishmatratai tusar winiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Irutis nuna antuk nusháa enentáimpramiayi. Tuma asamtai ashí Jerusaréṉnumia̱ shuarsha antukar nusháa enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Irutis nuikia ashí Israer-patri uuntri̱ncha tura yaunchu akupkamun jintinniuncha untsukarmiayi. Tura Kristu akiiniatniuri̱n inintrusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tutai chichainiak “Jutía nuṉkanam Piriṉ pepru ana nui̱ akiiniatniuiti, tiarmiayi. Yaunchu Yúsnan etserin tu áaruiti: ");
INSERT INTO jivNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Jutía nuṉkanam, Piriṉ pepru, ishitiápchich ana nuyá nekas uunt akupin winittiawai. Nii ashí Israer shuaran, Wíi shuar ásarmatai, péṉker wáinkiattawai,” tawai Yus.” Tu tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nuna tuíniakui Irutis ti neka apachin ú̱u̱saṉ, urutía yaa emka wáinkiamarum tusa aniasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nuyá Piriṉnum akupeak “Nui̱ werum uchi péṉker inintrusrum wáinkiatarum. Tura wáinkiarum ujatkatarum. Wisha werin tikishmátuutaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tutai ti neka apach wearmiayi. Tura yaa, yajaya̱ wáinkiarmiania nu, tuke eem wémiayi. Tura yaan wáinkiar ti wararsarmiayi. Tura nú yaa uchi pujumia nui̱ ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Je̱á waya̱war uchincha ni nukurí̱ Mariji̱a̱i̱ wáinkiarmiayi. Tura uchin tikishmatrarmiayi. Nuyá ni kajuntrí̱ya̱n kurincha, mirá kuṉkuinniasha, chíkich kuṉkuinniasha súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nuyá mesekranam Yus “Irutisa̱i̱ni weerap” tutai chíkich jintianam waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ti neka apach waketramtai Yusa suntari̱ mesekranam Jusen ujakmiayi. “Nantakim uchi ni nukurí̱ji̱a̱i̱ Ejiptu nuṉkanam jukim nui̱ pujustá. Irutis uchin máataj tusa e̱a̱ktatui. Tura ukunam aṉkant ajasmatai ujaktajme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tutai Jusé kurat shintiar nú káshik uchincha nukurí̱ji̱a̱i̱ Ejiptunam jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Irutis jáatsa̱i̱ṉ nui̱ pujusarmiayi. Ejiptunam pujusmatai Yus yaunchu timia nu uminkiamiayi. Iis, Yúsnan etserin aak tímiayi: “Ejiptunmaya̱n winia Uchirun untsukmajai.” Tu áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Irutissha ti neka apach nin anaṉka yajá waketran nekáa ti kajekmiayi. Ti kajek ashí áishmaṉchin Piriṉnumsha tura yantamach pujuarmia nunasha maawaarat tusa akupkamiayi. Ti neka apach ujakmia nuna enentáimias ashí jimiará uwin takakun tura nú uchichin máawarat tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nuka Yusnan etserin Jeremías aarmia nu uminkiamiayi. Juna áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá nuṉkanam ti úutainiak uur ajainiawai. Raker ti uutu asa atsaṉkrachminiaiti ni uchirí̱ jákarmatai.” Tu áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tura Irutis jakamtai Yusa suntari̱ mesekranam Jusen ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Uchin máataj tiarmia nuka jákarai. Yamaikia ataksha uchi ni nukurí̱ji̱a̱i̱ jukim Israer nuṉkanam waketkitia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tutai Jusé nantaki uchincha nukurí̱ji̱a̱i̱ jukin Ejiptunmaya̱ Israer nuṉkanam waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Túrasha Irutisa uchirí̱ Arkiráu Jutía nuṉkanam uunt akupin ajasun nekáa nui̱ wétinian aránkámiayi. Mesekranmasha ujakma asa nui̱ pujutsuk Kariréa nuṉkanam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nui̱ jeá Nasarét péprunam pujusmiayi. “Nasarétnumia̱ átatui” Yusnan etserin yaunchu tu etserkamu nuja̱i̱ uminkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nuyá imiakratin Juaṉ Jutía nuṉkanam aents atsamunam etserki támiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Enentáim yapaji̱átarum. Tsawant ishichik ajasai Yus jui̱ akupin ajastin.” Tu etserkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nú Juaṉkan yaunchu Yúsnan etserin Isayas ju̱na áarmiayi: “Shuar atsamunam aents untsumui. Untsumuk “Atumí enentái̱ Uunta jinti̱ iwiarturtarum tura naka awajsatarum” tawai.” Tu áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nu Juaṉsha kamiyu ure najantramun entsauyayi. Emenmamkesha nuapeyayi. Tura yutai-títikriátsnasha chiniji̱a̱i̱ yúuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tura Jerusaréṉ péprunmaya̱ shuarsha tura ashí Jutía nuṉkanmaya̱ shuarsha Jurtaṉ entsanam matsamiarmia nú shuarsha mash Juáṉkan tariarmiayi ni chichame̱n anturkatai tusar. ");
INSERT INTO jivNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tura ni tunaari̱n paant etserkarmatai Juaṉ Jurtaṉ entsanam imiainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juaṉsha Pariséuncha Satuséuncha imiatti tusa wininian wáiniak tímiayi “Napia áaniutirmincha, ¿ya atumniasha ti asutniátniunmaya̱ uwempratniuncha ujatmakmarum? tímiayi. Asutiátin tsawant ishichik ajasai. ");
INSERT INTO jivNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tuma asamtai enentáim yapaji̱ámuitkiuiṉkia péṉker wekaamurmi̱ji̱a̱i̱ paant iniakmastarum. ");
INSERT INTO jivNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Atumsha “Iikia Apraám weeaitji” tu enentáimtumasairap. Nuja̱i̱ uwemprashtatrume. Yus wakerakka ju̱ kayan Apraáman tiraṉki najankainti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Numi ajaktinia áintsaṉ kampuwári̱n jacha atuttsamuiti. Tura numi péṉker nereatsna nuka tsupikia jinium apeamu ártatui. ");
INSERT INTO jivNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wikia aya entsaja̱i̱ṉ imiajrume atumi enentái̱ yapaji̱áwakrumin. Antsu winia ukurui̱ winiana nuka péṉker awajtamsataj tusa imiantinia áanis tura jía áanis Yusa Wakanin eṉketramprattarme. Wiji̱a̱i̱ naṉkaamantu asamtai wikia tsuntsumpruan ni sapatrí̱nkisha atitrachminiaitjai. ");
INSERT INTO jivNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aruusa nereja̱i̱ túruinia áintsaṉ átatui. Awa̱jtiutairi̱n achikiuiti tura nuja̱i̱ saepe̱n awa̱jtittiawai. Tura nere̱n péṉker ikiustatui, antsu saepe̱nka jinium apeattawai. Nu jisha tuke kajinchaiti.” Tu tímiayi Juaṉ. ");
INSERT INTO jivNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nuyá Jesus Kariréa nuṉkanmaya̱ winis Jurtaṉ entsanam támiayi Juaṉ imiatti tusa. ");
INSERT INTO jivNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juaṉsha emka nakitiak Jesusan tímiayi “Ame winia imiatminiaitme. Túrutamniaitiatmesha ¿urukamtai winia tarutnium?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tura Jesus tímiayi “Ántsaṉ asati yamaikia. Núnisrik ashí Yus akupkamu umirkatniuitji.” Tutai Juaṉ iniaisamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tura Jesus imiani entsaya̱ jíinkímtai nayaimpⁱ uranmiayi. Tura Yusa Wakaní̱ yámpitsa áintsaṉ Jesusan tarimiayi. Niisha wáinkiámiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Túramtai nayaimpinmaya̱ Yus chichaak “Ju̱ka winia Uchiruiti. Ti aneamuiti. Ti shiir enentáimtajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nu túrunamtai Yusa Wakaní̱ Jesusan iwianchja̱i̱ nekapmamtiksattsa aents atsamunam jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nui̱ kuarenta (40) tsawant, káshisha tsawai̱sha yurumtsuk pujak tsukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nui̱ uunt iwianch Jesusan nekapsataj tusa tarí tímiayi “Nekas Yusa Uchiri̱nkiumka ju̱ kaya apatuk najanata.” ");
INSERT INTO jivNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tutai Jesus tímiayi “Yus-Papinium áarmaiti: “Aents aya apatkuja̱i̱ṉ iwiaaku pujuschamniaiti. Antsu Yus táman enentáimtuiniak nekas iwiaaku pujusartatui” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tutai uunt iwianch Jerusaréṉ péprunam jukí Yusa Uunt Je̱e̱ cháiki̱n iwiak ");
INSERT INTO jivNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tímiayi “Nekas Yusa Uchirí̱nkiumka ju̱ya̱ akaikim iniaata. Kame Yus-Papinium áarmaiti: “Yus ni suntari̱n akatar akúptúrmaktatui. Nawemin kayanam ajiintsumniṉ weṉkurmaktatui” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tutai Jesus tímiayi “Núnisaṉ Yus-Papinium áarmaiti: “Ame Úuntrum Yus “Nekapsataj” tiip” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ataksha uunt iwianch naint yakí wájakmanum iwiakmiayi tura nuyá ashí nuṉkanmaya̱ péprun shiira nuna iniaktusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tura tímiayi “Winia tikishmatrurakminkia ju̱na mash amastatjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tutai Jesus tímiayi “Werumta, uunt iwianchi. Yus-Papinium aarma awai: “Ame Úuntrum Yúsak tikishmatrata tura Niṉki shiir awajsata” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tutai uunt iwianch Jesusan ikiuak wémiayi. Túramtai Yusa suntari̱ tariar atsumamuri̱n súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juaṉ sepunam eṉketui taman antuk Jesus Kariréa nuṉkanam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tura Nasarét péprunam pujutsuk Kapernáum péprunam we pujusmiayi. Kapernáumsha Kariréa antumiaṉka kánmatkari̱i̱n pujumiayi. Ti yaunchusha Jakupu uchiri̱ Sapurúṉsha tura Niptarísha nu nuṉkanak nui̱ pujustaitsar achikiaruyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesus nuna túramtai yaunchu Yúsnan etserin Isayas aarmia nu uminkiamiayi. Ju̱na áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sapurúṉsha Niptarísha nayaantsanam tíjiu̱ch Jurtaṉ entsa amainini nuṉkan achikiarmiayi. Nuka Kariréaiti Israer-shuarcha matsatainia nui̱. ");
INSERT INTO jivNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nu aents kiritniunam pujuiniayataṉ ti tsáapninian wáinkiarmiayi. Jákatniunam pujuiniai̱ tsáapin tsáapnirmiayi.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nuyá Jesus étseruk tímiayi “Tunaarum enentáimturum enentáim yapaji̱átarum. Ju̱ nuṉkanam Yus akupkatin tsawant ishichik ajasai.” ");
INSERT INTO jivNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus Kariréa antumiaṉka kánmatkari̱n wesa jimiará áentsun nuámtak yáchinniun wáinkiámiayi. Chikichik Antresauyayi, chikichcha Semuṉkauyayi. Nu Semuṉ núnisaṉ Pitru náartiniuyayi. Namakan achin ásar namakan nekaja̱i̱ naṉkíak yujaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nuna Jesus wáinkiar tiarmiayi “Nemartustarum. Túrakrumin shuarsha Yusna arti tusan yamái namak achíarmena núnisaṉ shuaran-e̱a̱u awajsatjarme.” ");
INSERT INTO jivNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tutai ni nekari̱n ikiukiar Nin nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nuyá ishichik wésaṉ ataksha nuámtak yachinniun wáinkiámiayi. Jakupu Juaṉja̱i̱ mai Sepetéu uchirí̱ ármiayi. Niisha kanunam eṉkemsar ni nekari̱n ni aparí̱ji̱a̱i̱ iwiarainiak pujuriarmiayi. Tura Jesus “Nemartusta” tutai ");
INSERT INTO jivNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nu chichamaik kanuncha tura aparí̱ncha ikiukiar Jesusan nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ashí Kariréa nuṉkanam Jesus Israer-shuar iruntainiam etserki wémiayi. Yus ju̱ nuṉkanam akupkatin chichaman etserkamiayi. Tura untsurí̱ suṉkurja̱i̱ jáinian ashí tsuármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ashí Siria nuṉkanam Jesus tsuákratman nekaawar ashí náṉkamas suṉkurja̱i̱ wáitin armia nuna Jesusan tsuarti tusa itiariarmiayi. Ashí jaancha, najaimiancha, yajauch wakantrukuncha, wáuruncha, tampemaruncha Jesus tsuármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tura untsurí̱ shuar Jesusan nemariarmiayi. Kariréa nuṉkanmaya̱sha, Tekapurisnumia̱sha, Jerusaréṉ péprunmaya̱sha, Jutía nuṉkanmaya̱sha, Jurtaṉ entsa amainiya̱sha Jesusan nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus untsurí̱ shuar káunkarun wáiniak náinnium waka nui̱ pujusmiayi. Tura ni unuiniamuri̱sha taar pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nuyá Jesus jú̱nis unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ame wakanim atsumamu nekamarum kakaram ajasrum warastarum. Tuma asarum Yus akupeamunam pachiinniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kúntuts pujarum nu warastarum. Yus atsaṉtamprattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Péejchach enentáimtumarmena nu warastarum. Yus ashí nuṉkan amastatrume. ");
INSERT INTO jivNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Eseer wekasataj tusa aya kitiamarum nu warastarum. Yus imiktamprattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Waitneṉkratniutiram warastarum. Yus waitnentramprattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Péṉker enentáimniutiram warastarum. Yus wáinkiáttarme. ");
INSERT INTO jivNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Chicham iwiarin árum nu warastarum. Yusa uchiri̱ turamartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Péṉker túrakrumin yajauch awajtamainiakui warastarum. Yus akupeamunam pachiiniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wíi shuar asakrumin katsekramainiakuisha, itit awajtamainiakuisha, tura ashí tsanumprutmainiakuisha warastarum. ");
INSERT INTO jivNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Núnisaṉ yaunchu Yúsnan etserin armia nunasha túrawarmiayi. Túramtai shiir enentáimkiuram warastarum. Nayaimpiniam ti péṉker akinkiattarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Átumka ju̱ nuṉkanam wee ana áintsaṉketrume. Tura wéeaitiat jeakchaitkiuṉka míchuiti. ¿Nusha itiur yuámniak ati? Antsu ántraiti. Tuma asamtai a̱a̱ najatai tepet tusar ajapashtinkiait’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Átumka ju̱ nuṉkanam shiripkia áintsaṉketrume. Náinniumka pepru ú̱u̱mkachminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Núnisaṉ shiripik ekeemakam kajuṉnum eṉkeatsme. Antsu yakí sukúatsmek ashí je̱a̱nam ana nu paant atí tusam. ");
INSERT INTO jivNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Núnisaṉ atumsha Yusja̱i̱ péṉker túramu paant atí. Tura ashí aents nuna iisar niisha Yus Apan shiir awajsartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Muisais akupkamuncha tura yaunchu Yúsnan etserin etserkarmia nuna ántar awajsattawai” turutiirap. Antsu nuna Wikia umiktaj tusan táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nekasan tájarme. Ashí túrunatniua nu amúatsa̱i̱ṉ nu akupkamu ishichkisha yapajniáshtatui. Nayaimpisha tura nuṉkasha tuke amúatsa̱i̱ṉ nu akupkamusha amuukashtatui. ");
INSERT INTO jivNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nu asamtai shuar chikichik akupkamun, yúpichuch ana nunaksha, umirchakka tura chíkich shuaran umirkashtinian unuiniakka Yus nekas akupin paant ajastatna nui̱ nú shuar uunt áchattawai. Antsu ashí shuar akupkamun umíana nu tura chíkich shuaran umirkatniun unuiniana nusha Yus nekas akupin paant ajastatna nui̱, nu shuarka uunt átatui. ");
INSERT INTO jivNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tuma asamtai Yus akupeamunam pachiinkiataj tákumka Pariséuja̱i̱ naṉkaamas tura akupkamu jintinniuja̱i̱ naṉkaamas eseera wekasatniuitrume’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Yaunchu tiniu armia nu ántichukaitrum: “Maṉkartuawairap. Maṉkartana nuka asutniátniuiti” tiniu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tura Wisha tájarme: Shuar ni yachi̱n aya kajerakka nusha asutniátniuiti. Ni yachi̱n kátsekea nuka akupniunam ju̱naktiniaiti. Tura ni yachi̱n “netsé” tákuṉka jinium akupnakminiaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Tuma asamtai Yus susataj tusam wakerakum tura ame yatsum ámin itit enentáimturman enentáimpramka, ");
INSERT INTO jivNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","suamu nui̱ ikiuakum emka ame yatsum werim niiji̱a̱i̱ iwiarata. Turam waketkim Yus suam nu susata.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Shuar úuntnum júramkuiṉkia jintiaṉ wesam niiji̱a̱i̱ iwiarata úuntnum ejetamtsa̱i̱ṉ. Túrachakminkia úuntnum surutmaktatui tura niisha suntarnum surutmaktatui tura sepunam eṉketmattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tura nekas tajai, nui̱ eṉkemamka ashí rearchisha akikmachkumka jíinkishtatme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Yaunchu tiniu armia nu ántichukaitrum: “Tsanirmawaip.” ");
INSERT INTO jivNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tura Wisha tájarme: Shuar nuwa̱n tsanirmataj tu iiska nui̱kia ni enentái̱n tsanirmayi.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‘Tuma asamtai ame ji̱i̱mi tunaanum yajauch awajtamkuiṉkia ukuiṉkiam yajá ajapata. Ashí ame aya̱shim jinium esaatsa̱i̱ṉ aya chikichik aya̱shmi muchitmari̱ emesratin péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ame ewejmesha untsuurmetiat tunaanum ajunmakuiṉkia tsupikiam yajá ajapata. Ashí ame aya̱shim jinium esaatsa̱i̱ṉ aya chikichik ayashmi muchitmari̱ emesratin péṉkeraiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Núnisaṉ yaunchu tiniu ármiayi: “Shuar ni nua̱ri̱n ajapatniun wakera nuka papí najana susati.” ");
INSERT INTO jivNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tura Wisha tájarme: Shuar ni nua̱ri̱n tsanirmachun ájapeakka nuwa̱n tsanirmamtikiaiti. Tura ajapamuja̱i̱ nuatnaiyakka nuka tsanirmaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Núnisaṉ yaunchu tiniu ármiayi: “Yusa naari̱ pachisan turattajai” tákumka nekas takamtsuk umiktiniaitme.” ");
INSERT INTO jivNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Tura Wisha tájarme: Áyatik “Ee” tákumka tura “Atsá” tákumka wáitrutsuk nuke titiá. Támena nu nekas umiktaj takum ame nú arant pachistiniaitkiumka nuka yajauchiiti, iwianchnumia̱iti. Ti nekas tajai tusam nayaim pachischatniuitme. Nuka Uunt Yus pujutainti. Nuṉkasha pachischatniuiti Yusa tarimtairi̱ asamtai. Jerusareṉ péprusha pachischatniuiti Uunt Akupin pujutai nui̱ asamtai. Múukmesha pachischatniuitme. Chikichik intiashkesha pújusha mukusasha awajsachminiaitme. Áyatik nekasa nu páchitsuk titiá.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Yaunchu tiniu armia nu ántichukaitrum: “Shuar máanikiar ji̱i̱ apujtukka niisha apujtuktiniaiti. Tura nai̱ akarkasha ni nai̱sha akarkatniuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tura Wisha tájarme: Yajauch shuar taritrairap. Antsu ame yapimin ijiutmamtai áatú yapimsha tsaṉkatkata. ");
INSERT INTO jivNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tura pushirmin jurutramkitiaj tákuisha sakurmesha susata. ");
INSERT INTO jivNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tura káarkancha chikichik kirumitruk jurutkitia túramkui ámeka jimiará kirumitru ejeeta. ");
INSERT INTO jivNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Seatmana nu susata. Ikiatmakuisha páchitsuk ikiasta.’ ");
INSERT INTO jivNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Núnisaṉ tiniu armia nu ántichukaitrum: “Ame shuarum aneeta tura nemasrumka kajerkata.” ");
INSERT INTO jivNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tura Wisha tájarme: Nemasrum aneetarum. Yajauch chichartamna nusha shiir awajsata. Nakitramana nusha nawamkata. Tura katsekramainiana nu tura yajauch awajtamainiana nusha Yus áujtusarta. ");
INSERT INTO jivNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Atumsha nu túrakrum atumí Apari̱ nayaimpiniam pujana nu túrana áitkiasrumek túrarme. Iista, Yus yajauch shuarnumsha péṉker shuarnumsha tsáapin awajmatkiatsuk. Núnisaṉ yumincha yajauch shuar pujuiniamunmasha péṉker shuar pujuiniamunmasha yútumtiktsuk. ");
INSERT INTO jivNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aya atumin anenmainia nuke aneakmesha ¿yaki akirmakat? Yajauch shuarsha nuna túrin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aya ame yatsumek shiir chichaakmeka ¿warí péṉkerak túram? Yus-shuarchasha nuna túrin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nu asamtai atumí Aparí̱ Yus nayaimpiniam pujana nuja̱i̱ métek ti péṉker átiniaitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘Ashí íimiainiai̱ṉ aya shuar iirsarti tusarum Yusna nu takasairap. Tu takaakrumniṉkia Yus Apa nayaimpiniam pujana nu peṉké akirmakchattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nu asamtai shuar atsuma nu yaiya̱kmeka ashí shuar ujakairap. Anaṉkartin ainia nuka iruntainmasha tura pepru jintí wekasasha ashí íimiainiai̱ṉ shiir túrajai tusar nuna túrin áiniawai. Ju̱nasha “péṉker túrawai” tu enentáimturarti tiniu ásar Yus akíatsa̱i̱ṉ aya tu enentáimturmaja̱i̱ṉ akinkiaruiti, nekas tajai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Antsu átumka atsumainia nu yaiya̱kmeka peṉké ú̱u̱kam túrata. Chikichkisha nu yáiṉman nekaashti. ");
INSERT INTO jivNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ú̱u̱kam túrakminkia ame Apa Yus u̱u̱kman wainia nu, nuna akirmaktatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Atumsha Yus áujeakrumsha ántar chichamtin ainia núnis áujsairap. Nu shuarka iruntainmasha tura pepru jintí̱sha shuar iirsarti tusa wajakiar Yúsan áujin áiniawai. Nekasan tájarme, Yus akíatsa̱i̱ṉ aya nu iismaja̱i̱ṉ akinkiaruiti. ");
INSERT INTO jivNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tura ame Yus áujeakmeka ame kuárturmin waya̱m waiti epenim nui̱ amek ame Apa Yus áujsata. Nuna ame Apa Yus u̱u̱ka túramu waitma asa akirmaktatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Yus áujeakmesha ántram esaram áujsaip. Yúsan nékainiatsna nuka “Esaram áujeakuinkia Yus anturtuktatui” tu enentáimainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niiji̱a̱i̱ métek ajasairap. Átumka seatsrumniṉ Yus Apa átum atsumamun nékawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nu asamtai Yus áujkuram jú̱nis títiniaitrume: ‘Aparu Yus, nayaimpiniam pujamna nu, ii Aparí̱nme. Ame náarmincha shuar ántar pachischarti. ");
INSERT INTO jivNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ashí áentsnum ame akupkatin tsawantrum wari jeati. Ame wakeramuram nayaimpiniam umikma ana núnisaṉ ju̱ nuṉkanmasha uminkiatí. ");
INSERT INTO jivNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aparu, ii yurumkari̱ ashí tsawant amasta. ");
INSERT INTO jivNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tura winia nemasrun tsaṉkurajna núnismek, Aparu, winia tunaaru tumashri̱sha tsaṉkurturta. ");
INSERT INTO jivNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tunáa wakeruktin tsaṉkatrukaip. Antsu ashí tunaanumia̱ uwemtikrurta. Tuke ashí aents akupkamniaitme. Núnisam Amesha tuke ti kakarmaitme. Tura ti shíiraitme. Tuma asakmin seajme. Nuke atí.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Amesha chíkich shuar yajauch awajtamka nu tsaṉkureakminkia Yus Apa nayaimpiniam pujana nu amincha tsaṉkurtamprattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tura chíkich tsaṉkureachkumniṉkia Yus Apasha ame tunaarmincha tsaṉkurtamprashtatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Ijiarmarum Yus áujkurmesha wake mesekrum susuntrairap. Anaṉkartin shuar chíkich shuar “ijiarmaiti” tu enentáimtursarti tusa tuma áiniawai. Nekasan tájame, Yúska akíatsa̱i̱ṉ aya nuja̱i̱ akikma áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Antsu ámeka ijiarmamsha péṉker temashmaram péṉker jaupmitia. ");
INSERT INTO jivNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Shuar ijiarmaiti tu enentáimturmasara̱i̱ṉ. Aya Yus Apak nekaattawai. Tura asa akirmaktatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","‘Ju̱ nuṉkanmaya̱ kuit ikiauṉkatniuja̱i̱ naṉkaamas nayaimpiniam kuit ikiauṉkata. Jui̱ṉkia kaya̱a̱ yúchakait tura mash meseatsuk. Tura kasasha wayá kasamtsuk. Antsu nayaimpinmaṉka kaya̱a̱sha yuatsui tura mash meseatsui tura kasasha wayá kasamtsui. ");
INSERT INTO jivNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kuítrum ana nui̱ enentáimtustatme. Tuma asam nayaimpiniam ikiauṉkata.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Ame jí̱miji̱a̱i̱ tsáapin ami̱i̱n waya̱mniaiti. Tuma asamtai ame ji̱i̱mi péṉkeraitkiuiṉkia ami̱i̱n tsáapin wayá tuke tsáapniiti. ");
INSERT INTO jivNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Antsu ame ji̱i̱mi yajauchitkiuiṉkia tsáapin ami̱i̱n waya̱chmin asamtai tuke kiritin átatui. Núnisaṉ yajauchia nu wakerakmeka péṉkera nu ame enentáimi̱i̱n waya̱chmin asamtai tuke kirit ajastatui. Nu kiritcha imiá yajauchiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Shuar jimiará úuntri̱n umirkatniun tujintiawai. Chikichan wakerak chikichnaka nakitrattawai. Chikichan umiruk chikichnaka umirkashtatui. Núnisaṉ átumka Yussha kuitcha máimtek enentáimtustin tujinkiattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Tuma asamtai tájarme: Wariniak yuataj wariniak umartaj tura wariniak entsartaj tusarum nuke enentáimsairap. Yus iwiaaku átinian amasu asa yurumkancha amaschamniakait. Tura ju̱ aya̱shniasha najana asa entsataincha amaschamniakait. ");
INSERT INTO jivNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chiṉkisha enentáimpratarum. Yakí nanamainiak yurumkan arakmainiatsui. Tura juuk yurumkan ikiuiniatsui. Tuma aiṉ Yus Apa nayaimpiniam pujana nú Yusak áyureatsuk. Atumsha chiṉkia nú naṉkaamaschakaitrum. ");
INSERT INTO jivNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nu arantcha ti enentáimkiumsha ¿nuja̱i̱ tsakartatmek?’ ");
INSERT INTO jivNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘Nuikia ¿urukamtai entsartincha timiá enentáimprum? Iistá, kuku̱jsha takachuitiat tura najanchaitiat ");
INSERT INTO jivNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ti shíirmach áiniawai. Yaunchu uunt akupin Sarumúṉ ti shiir iwiarmamniuitiat kuku̱jia tímianchauyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iis, nupa yamái tsakaawai tura kashin aents tsupikiar jinium epeenawai. Tuma aiṉ Yus ti shiir áentseatsuk. Nuna tura asa atumniasha nú péṉker waitmakchattawak. ¿Urukamtai Yus nekas enentáimtatsrum? ");
INSERT INTO jivNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Ju̱ nuṉkanam ana nu pachikiairap. Chíkich shuar, Yúsan nékainiatsna nu, wariṉ yuattajⁱ wariṉ umartatajⁱ wariṉ entsartatajⁱ nuna ti pachiiniawai. Tura atumsha tu enentáimsarum weerap. Ame Apa nayaimpiniam pujana nu ame atsumamurmin nékawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tuma asamtai Yusja̱i̱ shiir wekasatin tura Yus akupkamu ana nu umiktin emka enentáimsatarum. Túrakrumniṉkia atsumamurmin Yus suramsattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kashin átatna nuja̱i̱ itiurchat enentáimsairap. Kashinkia nusháa itiurchatri̱ji̱a̱i̱ tsawa̱rchattawak. Yamái tsawanta ju̱ja̱i̱ máakchakait.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Chikicha tunaari̱ ti enentáimtusairap. Núnisaṉ Yus atumí tunaari̱ iirtamsashtatui. ");
INSERT INTO jivNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chíkich wárik sumamtikiatin enentáimkiumniṉkia Yus núnisaṉ sumamtikramattawai. Tura ame chikicha túramuri̱ nekapmarmena nú nekapkaja̱i̱ṉ amincha nekapmarmattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tuma asamtai ¿itiurtsuk atumi ji̱i̱n numi eṉketna auk íitskesha atumi yachí ji̱i̱n tsuat eṉketusha iyarum? ");
INSERT INTO jivNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ame ji̱i̱mi̱i̱n numi tuke eṉketai̱sha ¿itiurtsuk ame yatsumi ji̱i̱ya̱ tsuátan jurustajme tame? ");
INSERT INTO jivNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ántar shuará, ame yáiṉtaj tákumka emka ame ji̱i̱mi̱i̱n numi eṉketna nu jusata. Nuyá paant iistatme yatsumi ji̱i̱n tsuat eṉketna nu jurustin.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Ti shiira nuka yawá súsashtiniaiti. Nuna nakitrar amincha esatmichartimpiash. Kuítrumsha kuchi súsashtiniaiti. Aya najatrachartatuak.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Yus seakrumin suramsattawai. E̱a̱krumka wainkiattarme. “Winiajai” tákurmin awa̱intiamattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Seana núnaka suíniawai. E̱a̱na nuka wáiniui. “Winiajai” tuinia núnaka awa̱iniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Ame uchiram apatkun seatmakui ¿kayaash súsaintiam? ");
INSERT INTO jivNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tura namakan seatmakui ¿napíash súsaintiam? ");
INSERT INTO jivNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nuikia átum yajauchitirmesha atumi uchirí̱ péṉker ana nu tuke súuchakaitrum. Nuna naṉkaamas nuikia seakrumniṉkia atumi Aparí̱ nayaimpiniam pujana nu péṉker ana nuna suramsashtatuak.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Jú̱naka Muisaissha Yúsnan etserniusha akupenawai: “Chíkich ámin túrutatí tusa wakerakmeka amesha núnismek túratá.” Tu akupenawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","‘Waṉkaram jintia awai. Waya̱tniusha yúpichuchiiti. Nui̱sha untsurí̱ wáiniawai. Tura nusha meṉkakatniunam jeawai. Túrasha chíkich jintia awai. Nusha yupikiach asa itiurchataiti. Waya̱tniuri̱sha yupikchiiti. Nui̱ ishichik wáiniawai. Tura nusha iwiaaku pujustinnium jeawai. Tuma asamtai tuke iwiaaku pujustaj tákurmeka yupipitin jintia achiktarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Aneartarum. Wáitruiniak “Wi Yúsnan étserjai” tuinia nu írunui. Pátatek murikiua áinis yúpichuch áiniawai tura ni enentái̱n nekas úunt-yawa̱ áinis áiniawai. Pátatek shiir chichainiawai tura ni enentái̱n yajauch piakuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Atumsha túramuja̱i̱ nin nekaatniuitrume. Naranmaya̱ shui̱ya júukchamniaiti. ¿Tsachiksha kushiṉkiapen nerektatuak? ");
INSERT INTO jivNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Núnisaṉ péṉker numia nu tuke péṉkeran nereatsuk. Tura yajauch numia nu yajauchin nereatsuk. ");
INSERT INTO jivNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Péṉker numi yajauchin nereatsui. Núnisaṉ yajauch numi péṉkeran nereatsui. ");
INSERT INTO jivNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yajauch numi ajakar tsupirar jinium apeashtinkiait. ");
INSERT INTO jivNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tuma asamtai wáitrin ainia nuka túramuja̱i̱ nekanattawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Aya winia Apar nayaimpiniam pujana nuna wakeramuri̱n umirin ainia nuke Yus akupeamunam pachiinkiartatui. Chíkichka “Uuntá, Uuntá” turutainiayat nayaimpiniam jeachartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amuukatin tsawant jeamtai untsurí̱ turutiartatui “Uuntá, Uuntá, ame náaram pachisar ashí nuṉkanam etserkachmakajⁱ. Ame náarmesha pachisar yajauch wakancha ji̱i̱ki akupkamji. Tura ame náaram pachisar aentsti tujintiamu túramji” turutiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nui̱ chichainiakui “Werumtarum. Peṉke nékachuitjiarme. Aya yajauchitrume” títiatjai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Shuar winia chichamprun antuk umirkaṉka nu shuar ti péṉker enentáimniuiti. Niisha ju̱ shuarja̱i̱ métekete. Je̱a̱ jeamuk kayanam ukurmai. ");
INSERT INTO jivNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tura yumi ti yutuk entsa nujaṉkruamai tura nase ti kakaram umpuimiai. Túmaiṉ pukukachmai ni ukurmari̱ kayanam ukuamu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tura shuar winia chichamprun antuk umirtukchaṉka ju̱ shuara núnisaṉ enentáimchaiti. Je̱a̱ jeamuk náikminiam ukurmai. ");
INSERT INTO jivNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tura yumi yutuk entsa nujaṉkruamai tura nase ti kakaram umpuimiai. Túmakui je̱a̱ mash saanaki iniaamai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus nuna tinia amukmatai ashí shuar ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Yusa kakarmari̱ji̱a̱i̱ unuitiamtsujik. Israer-shuara jintinniuri̱nkia núnis unuiniainiatsui” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus muraya̱ támatai untsurí̱ shuar Nin nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nui̱ shuar tunamaru Jesusan jearin tikishmatramiayi. Tura tímiayi “Uuntá, wakerakmeka tsuáramniaitme.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tutai Jesus uwejé̱ja̱i̱ antiṉ “Wakerajai. Péṉker ajasta” tímiayi. Tutai tunamaru ni tunamarmari̱ péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tura Jesus tímiayi “Pai, peṉké etserkaip. Áyatik Israer-patri̱ iniakmamsam Muisais timia nu susata ashí shuar nekaawarti tusam.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Kapernáum péprunam waya̱mtai apachi suntara kapitiántri̱ Nin tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Uuntá, tímiayi. Winia uchir tampemaru je̱á tepes ti wait ajáa tepawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesussha “Ayu, winin tsuartajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tutai kapitián tímiayi “Uuntá, Ame ti naṉkaamaku asam winia je̱a̱ruí̱ waya̱chminiaitme. Áyatik “Péṉker ajástí” tákumin winia uchir péṉker ajatrustatui. ");
INSERT INTO jivNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iista, winiasha akuptuiniatsuk tura wisha suntaran akupenatsjak. Ju̱na “Wetá” takui wéawai. Tura chikichnasha “Winitiá” tutai winiawai. Tura takartinian “Ju̱ túratá” tutai umíawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kapitián nuna tutai Jesus ti enentáimiuk Nin nemarainian tímiayi “Nekasan tájarme, Israer-shuar Yúsan tímiatrus enentáimtin atsawai. ");
INSERT INTO jivNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Maa, yajaya̱ untsurí̱ shuar Yus akupeana nui̱ jeawar Apraámja̱i̱sha Isakja̱i̱sha Jakupja̱i̱sha iruntrar yurumáwartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tura Israer-shuar Yúsnum jeamnia áiniayat a̱a̱ kiritniunam ajapnawartatui. Nui̱ ti úutin tura ti wáitsatin átatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nuyá Jesus kapitiánin chicharuk “Je̱e̱mi̱i̱n waketkitia. Nekas enentáimtusu asakmin uchiram péṉker ajatramsattawai” tímiayi. Túramtai ni uchirí̱ nu chichamtaik péṉker ajatsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus Pitru je̱e̱n we Pitru tsatsari̱n tsuemuja̱i̱ jaa tepan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tura ni uwejé̱n antiṉmatai tsuemun michatramiayi. Tura nuwa̱ nantakin ashí ajamsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kashi ajasmatai yajauch wakantrukarun Jesusan itiariarmiayi. Tura nu yajauch wakanin chikichík chichamja̱i̱ chicharas ji̱i̱ki akupiarmiayi. Ashí jáiniancha tsuárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yúsnan etserin Isayas “Ii pimpirmari̱ncha ii suṉkuri̱ncha jurutramkimiaji” yaunchu timia nu uminkiati tusa nu túrunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Shuar untsurí̱ Jesusan káutkarmatai “Entsa amain katiṉtai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nui̱ Israer-shuara jintinniuri̱ Jesusan tarí tímiayi “Uuntá, Ámin páchitsuk nemarsatniun wakerajme.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tutai Jesus tímiayi “Kujanchmasha ni wa̱a̱ri̱n takaktsuk. Chiṉkisha pasuṉke̱n takaktsuk. Tura Wi Yúsnumia̱itiatan tepestiniur atsawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nin nemarniusha tímiayi “Uunta, emka winia aparun iwiarsan ikiuuttajai.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tura Jesus “Nemartusta, tímiayi. Wakannium jaka ainia nu jakan iwiarsarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nuyá Jesus ni unuiniamuri̱ji̱a̱i̱ uunt kanunam eṉkemámiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nui̱ nase̱ ti kakaram umpuimtai antumiaṉ ti tamparintin ajasmiayi. Tura entsa kanunam yaráná piákmiayi. Tuma aiṉ Jesus kanunam kanar tepemiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nuyá ni unuiniamuri̱ ku̱rashim Jesusan ishintiarar tiarmiayi “Uuntá, waya̱ji. Kakaram ajachkumniṉkia jakattaji.” ");
INSERT INTO jivNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus tímiayi “¿Urukamtai timiá ashamarum, Yus enentáimtutskesha?” Nuyá wajaki nase̱ncha entsancha chicharkamiayi. Tutai mash miaaku ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nuna íisar ni unuiniamuri̱ ti enentáimsarmiayi. Tura tiarmiayi “Ju̱sha ¿warí áentsuit? Nase̱sha entsasha Nin umirainiatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nuyá Jesus entsá amaini katiṉ Jatara nuṉkanam jeamiayi. Nui̱ jimiará shuar yajauch wakantruku tuke iwiartainium pujú Jesusan tariarmiayi. Mai yajauch wakantruku ásar ti kajen ármiayi. Tuma asamtai shuar nu jintianam naṉkaamachu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Niisha Jesusan wáinkiar kakantar tiarmiayi “¿Warí pujuram iiji̱a̱i̱, Jesusá, Yusa Uchirí̱a. Tsawant jeatsa̱i̱ṉ in amukratkataj tusamek taum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nui̱ arant kuchi untsurí shushuṉmak yujaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yajauch wakancha Jesusan seainiak “Ji̱i̱ki akupkartakmeka kuchíniam waya̱tin tsaṉkatkartukta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tutai Jesus “Pai, wetarum’ tímiayi. Yajauch wakancha shuara enentái̱ya̱ jíinkiar kuchiniam eṉkemáwarmiayi. Túramtai kuchi wáurkiar arau̱ utsanamiayi. Nuyá entsá iniaṉkar jakerarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kuchí wáinniusha nuna ashamkar péprunam tseke̱ wéarmiayi. Nui̱ jeawar ashí túrunamun etserkarmiayi. Yajauch wakantrukun péṉker ajasmancha etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nuyá ashí nú peprunmaya̱ shuar Jesusan iṉkiuṉtai tusar ashinkiarmiayi. Tura iṉkiuṉkar ni nuṉke̱ya̱ waketkiti tusar seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nuyá Jesus kanunam eṉkemar antumiaṉ amaini katiṉmiayi. Tura nui̱ ni pépruri̱n Kapernáumnum jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nui̱ jeamtai shuar emearu jaan patak yanakin ejeetiarmiayi. “Tsuártatui” nekas tu enentáimtuinia ásarmatai Jesus jaan tímiayi “Uchirú, kakaram ajasta. Ashí ame tunaarum tsaṉkuramuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Takui Israer-shuara jintinniuri̱ yajauch enentáimprar “Ju̱ka Yúsan ti yajauch chicharui” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tu enentáimainian Jesus nekáa tiarmiayi “¿Urukamtai imiá yajauch enentáimprum. ");
INSERT INTO jivNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tua imiá yúpichuchit. Shuara tunaari̱n tsaṉkuratin yúpichuchikiait. Tura emearun “Nantakim wekasata” títin yúpichuchikiait? ");
INSERT INTO jivNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wi Aents Ajasua núchakaitiaj. Ju̱ nuṉkanam Wi tunaan asakátratniuitjai. Wátsek, nu nekaatarum tusan ju̱na iniakmastatjai.” Nuna tinia emearun “Wajaktia, tepetairam jukim je̱e̱mi̱i̱n wetá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tutai emearu tsuámar nantaki ni je̱e̱n wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tura nuna ashí aents wáinkiar Yus kakarman shuáran susa asamtai ashamkar Yúsan shiir enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nuyá Jesus wémiayi. Nui̱ wesa Mateun kuit júutainium pujan wáiniak “Nemartusta” tímiayi. Tutai Mateu nuna ikiuak Jesusan nemarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nú ukunmasha Mateu je̱e̱n yurumuk puja̱i̱ yajauch armia nu Israer-shuar untsurí̱ káunkar Jesusa unuiniamuri̱ji̱a̱i̱ irunar yurumiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pariséusha nuna íisar Jesusa unuiniamuri̱n aniasarmiayi “¿Urukamtia atumí Uuntri̱ kuitia achinja̱i̱sha tunaarinniuja̱i̱sha irunar yuruma?” ");
INSERT INTO jivNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tura Jesus nuna antuk tímiayi “Péṉker ainia nuka tsuákratniun atsumainiatsui. Antsu jainia nu tsuákratniun atsumainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Werum ju̱ aarma unuimiutarum: “Murik maam Winia surusum nuja̱i̱ “máakete” tátsujai. Antsu waitneṉkartutain wakerajai,” Yus-Papinium tu áarmaiti. Wikia “péṉkeraitjai” tuínian untsuktaj tusan táchaitjai. Antsu tunáa shuar ni enentái̱n yapaji̱áwarat tusan táwitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nuyá imiakratin Juaṉka unuiniamuri̱ Jesusan tariar aniasarmiayi. “¿Urukamtai iikia tura Pariséusha ijiarmajⁱ tura ame unuiniamurmeka ijiarmainiatsu?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus aya̱k tímiayi “Nuatma nampernum ipiaamu ainia nu ¿ajakra uutu waya̱mniakait? Yamái-nuatu pujakui úutchamin áiniawai. Núnisaṉ Wi pujakui ijiarmashtin áiniawai. Tura tsawant jeattawai nuatua áintsan Wi junaktatjai. Antsu nui̱kia ijiarmawartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Mamuru pushí jaanakmatai yamaram tarach anujtukchatniuiti. Túramka nijiam yamaram tarach sumpeak mamushan chiṉkiá nuna naṉkaamas ja̱a̱ktatui. ");
INSERT INTO jivNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nijiamanch yamái nawar nuap najanamu arutnum yaraachminiaiti. Túramka karíak nuap najanamun ijiakratniuiti, nijiamchisha ukaratniuiti, tura nuap najanamusha yajauch ajastiniaiti. Antsu yamaram nijiamanch yamaram nuap najanamunam yaraatniuiti. Nu túramka nijiamchisha nuap najanamusha mai péṉker ártatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus nuna ta̱i̱ Israer-shuara uuntri̱ Jesusan tarí tikishmatar tímiayi “Winia nawantur jarutkayi, tura Ame winim ewejmiji̱a̱i̱ antintrukakminkia ataksha nantaktiatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tutai Jesus ni unuiniamuri̱ji̱a̱i̱ wajakiar niiji̱a̱i̱ wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tura jintiá weenai̱ nuwa̱ tuse (12) uwitin numpá ájapeak wáitias pujú asa Jesusa ukurini̱ amainiaṉ ni pushiri̱n antiṉmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Áyatik ni pushiri̱n antiṉnaka péṉker ajastatjai” tu enentaimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nuna nekáa Jesus ayantar nuwa̱n tímiayi “Shiir enentáimprata, nawantru. Yus shiir enentáimtusu asam péṉker ajasume.” Nu chichamtaik ni jáamuri̱ péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nuyá Jesus uunta je̱e̱n jeamiayi. Tura nui̱ charaatum ajainiancha tura jakan iwiarsatai tusar péeman umpuiniancha wáiniak ");
INSERT INTO jivNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tímiayi “A̱a̱ jíintratarum. Nuwa̱chikia jákachai antsu aya kanarai.” Peṉké jakan nékayat túratta nuna neka asa “aya kanarai” tímiayi. Takui aents Nin wishikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tura nuna ashí ji̱i̱r Jesus je̱á wayá nuwa̱chin uwejnum achik iniantkimiayi. Túram nantakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nu túramu ashí nu nuṉkanam etsernarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nuyá Jesus wéakui jimiará shuar ji̱i̱ kusuru untsumki weriarmiayi. “Uuntá, ii Uuntri̱ Tawit ame weatrum asamtai in waitneṉkarturta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus je̱á waya̱mtai ji̱i̱ kusuru tariarmiayi. Tura Jesus aniasar “¿Ju̱na túramniaiti túrutrumek?” tímiayi. Niisha “Ee, Uunta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tuíniakui Jesus ni ji̱i̱n antinkiar tímiayi “Átum nekas enentáimtarmena núnisaṉ túrunati.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nuja̱i̱ ji̱i̱ péṉker ajasarmiayi. Nuyá Jesus “Etserkairap. Shuar peṉké nekáwara̱i̱ṉ” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Támaitiat jíinkiar Jesus túramun ashí nu nuṉkanam etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nuyá wenai̱ shuar yajauch wakantruku chichachun Jesusan itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tura Jesus yajauch wakanin ji̱i̱ki awemamtai nu chichachu chichakmiayi. Ashí nuna íisar ti enentáimprarmiayi. Tura tiarmiayi “Yáunchusha Israer nuṉkanam ju̱ja̱i̱ métek túramu peṉké atsuwiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Antsu Pariséuka yajauch enentáimtuiniak tiarmiayi “Nu shuar iwianchi uuntri̱ kakarmari̱ji̱a̱i̱ yajauch wakanin ji̱i̱ki akupeawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus ashí péprunam we ni iruntairi̱n wayá “Yus akupeana nui̱ eṉkemátarum” tu etsermiayi. Tura ashí náṉkamas suṉkurja̱i̱ jáiniancha tsuármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Shuaran íisar murik wáinchatia núnis pimpikiar tura kúntuts pujuinia asamtai waitnentrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Nuyá ni unuiniamuri̱n tímiayi “Ju̱ aents Yus-Chicham ujaktiniaitji Yus-shuar ajasarat tusar. Nu takat ti núkap awai tura takarin ishichik áiniawai. Nu takatka júuktinia áintsaṉkete. Júuktin tsawant jeamtai takau táasmatai takamtikin ujaktin átsuk takaun akupkat tusa. Atumsha núnisrumek Yus seatarum ni shuari̱n akupak áentsun júukarat tusarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nuyá Jesus tuse (12) unuiniamuri̱n achik Yusa kakarmari̱n súsarmiayi yajauch wakanin shuara enentái̱ya̱ ji̱i̱ki akupkatniun. Núnisaṉ ashí suṉkurja̱i̱ jáinian tsuárartinian susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ju̱ áiniawai Jesus tuse (12) unuiniamuri̱n achikiarmia nu: Emka Semuṉ núnisaṉ Pitru náartiniuyayi. Nuyá ni yachi̱ Antres. Nuyá nuámtak yáchintin Jakupusha Juaṉsha, Sepetéu uchirí̱ armia nu. ");
INSERT INTO jivNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nuyá Jiripi, Parturumí, Tumas, Mateu. Mateusha kuítian achiniuyayi. Arpeu uchirí̱ Jakupusha. Ripíu núnisaṉ Tateu náartiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ásumpⁱ Semuṉsha nuyá Jútas Iskariúti Jesusan ukunam surukmia nu. Nu tuse (12) achikma ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nu tuse (12) unuiniamuri̱n Jesus jú̱nis chicharak akupkarmiayi. “Israer-shuarcha matsatmanum weerap. Samaria nuṉkanam péprunam weerap. ");
INSERT INTO jivNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Antsu Israer-shuar murikiua áinis Yusai̱ya̱ wáakaru ainia nu weritiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Tsawant ishichik ajasai Yus jú̱ nuṉkanam akupin ajastin” tu etserki wetarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tunamarusha chíkich suṉkurja̱i̱ jainia nusha tsuartarum. Jakasha iniantkitiarum. Yajauch wakancha shuara enentái̱ya̱ ji̱i̱ki awematarum. Nu túratin kuítchaja̱i̱ kakaram susamuitrume, tuma asamtai atumsha ashí ántrarmek túratarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Kurisha ashí kuitcha jukiirap. ");
INSERT INTO jivNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","U̱yuncha jukiirap. Sapatcha tura ushukrustincha jukiirap. Antsu chikichik pushí jukitiarum. Takau asakrumin yurumkan ajampramsartin áiniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Péprunam jearmesha péṉker shuar wáinkiarum nui̱ waya̱rum tuke nuiṉ pujustarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu je̱a̱nam waya̱msha “Ju̱ je̱a̱ shiir atí” titiá. ");
INSERT INTO jivNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nekas péṉker shuaraitkiuṉka shiir ajasarti. Antsu nu shuar péṉker itiarmachkuṉka shiir ajascharti. ");
INSERT INTO jivNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tura náṉkamsaṉ atumin awa̱intiamainiachkuiṉkia anturtamainiachkuiṉkia nuyá jíinkitiarum. Nu shuar yajauch ásarmatai jíinkirum atumí nawe̱ya̱ nuṉka japimiarum ikiuktiarum. Ni tunaari̱ aents nekaawarat tusarum túratarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nu shuaran nekapsatin tsawant jeamtai Yus asutiáshtatuak. Sutum péprunmaya̱ shuara naṉkaamas Kumura péprunmaya̱ shuarnasha naṉkaamas Yus asutiáttawai nu shuaran’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Aneartarum. Wisha murik yawa̱num akupkatniua áintsanak akupeajrume. Tuma asamtai shiir nawamkartin áyatrum aneartarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yajauch shuarja̱i̱ aneartarum. Akupniunam juramkiartatui. Israer-shuar iruntainiam asutiamawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wíi shuar asakrumin uuntnumsha tura nuyá akupniunmasha juramkiartatui. Núnisrum akupniuncha tura Israer-shuarchancha winia chichamur ujaktatrume. ");
INSERT INTO jivNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tura akupniunam surutmakakrumnisha wariniak títiaj tu enentáimprairap. Nui̱ uuntja̱i̱ chichaakrumin Yus títinian jintintramattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nuiṉkia átum enentáimmiaja̱i̱ chichaschattarme antsu atumí Apari̱ Yusa Wakaní̱ atumin chichamtikramsattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Shuar ni yachi̱ncha máawarti tusa suruktatui. Apasha ni uchirí̱n surukartatui. Uchisha ni aparí̱n máawarti tusa surukartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tura Wíi shuar asakrumin mash muíjramkartatui. Tura tuke katsuntea nu uwemprattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chikichik péprunam yajauch awajtamainiakui chíkich péprunam pisartarum. Wi Aents Ajasuitjai. Tuma asan nekasan tájarme, átum Israer-shuar mashi ujatsrumniṉ wantinkiattajai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Unuiniamuka nin unuiniana nuna naṉkaamaschaiti. Takarniusha ni uuntri̱ naṉkaamaschaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Unuiniamuka nin unuinia nuja̱i̱ métek ajaska maak. Takarniusha ni úuntri̱ji̱a̱i̱ métek ajaska maak. Wátsek, Winia atumí úuntri̱n “Iwianchi uuntri̱” túrutainiakui atumniasha nuna naṉkaamas yajauch turamtatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Tuma asamtai aentska ashamkairap. Ashí u̱u̱kma nu paant nekanattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ishishmasan kiritniunam ujaajrumna nu, tsawái̱ kakantrarum etserkatarum. ");
INSERT INTO jivNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aya aya̱shin main ainia nu ashamkairap. Wakanin máachmin áiniawai. Antsu wakanniasha aya̱shniasha mai jinium emesramnia asamtai Yus ashamkatarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘Jimiará chiṉki peṉké ishichik kuitja̱i̱ surukmin áiniawai. Túmaitiat Yus tsaṉkateachkuiṉkia nuṉká jaka iniainiatsui. ");
INSERT INTO jivNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ame intiashmisha mash nekapmarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nu asamtai jákatin ashamkairap. Yusja̱i̱ átumka ti untsurí̱ chiṉkiji̱a̱i̱ naṉkaamas péṉkerchakaitrum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Ashí shuar ashí íimiainiaiṉ Winia natsantruiniatsna núnaka Winia Apar yakí nayaimpiniam pujana nui̱ natsantrashtatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Antsu shuar íimiainiai̱ṉ Winia natsantra núnaka Wisha yakí nayaimpiniam winia Apar pujana nui̱ natsantrattajai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Ashí shuar nawamnaikiar shiir pujusarat tusan ju̱ nuṉkanam táchaitjai. Nuna túrat tusarum enentáimturairap. Antsu wi tamaaja̱i̱ shuar péṉker ajasarmatai yajauch shuar nin nakitrartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Shuar ni aparí̱n nakitrattawai. Nuwa̱sha nukurí̱n nakitrattawai. Najatí̱sha tsatsarí̱n nakitrattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tuma asa shuar ni shuari̱ji̱a̱i̱ nemasrintin ártatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Shuar ni aparí̱ncha nukurí̱ncha Wiji̱a̱i̱ naṉkaamas aneakka Wíi shuar áchamniaiti. Núnisaṉ ni uchirí̱ncha nawantri̱ncha naṉkaamas aneakka Wíi shuar áchamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tura ashí wáitsatniun surimiatsuk ni krúsri̱n yanaki jukí nemartachkuṉka Wíi shuar áchamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aya jú̱ nuṉkanam péṉker pujustaj tana nu ni iwiaakmari̱n emesrattawai. Tura Winia anentu asa ju̱ nuṉkanam péṉker pujustinian páchiatsna nu tuke shiir pujustatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Atumin itiaarma nuka Winia itiaarui. Tura itiaarea nuka Winia akuptukmia nunasha itiaawai. ");
INSERT INTO jivNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yúsnan etserniuncha Yúsnumia̱ winiá asamtai itiaakka etserin akínkiáttana nuja̱i̱ métek akínkiáttawai. Péṉker shuárnasha péṉker asamtai itiaakka péṉker shuar akínkiáttana nuja̱i̱ métek akínkiáttawai niisha. ");
INSERT INTO jivNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Uchincha Wíi shuar asamtai entsá michan shikirak súsaṉka imiá nekas nusha akínkiáttawai.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tura tuse (12) unuiniamuri̱n Jesus tinia akupkar Niisha nú nuṉka péprunam we Yus-Chichaman jintíak etserkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tura Juaṉ sepunam eṉkemas Kristu túramun antukmiayi. Antuk ni unuiniamuri̱n jímiaran Jesusai̱ akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tura Jesusan aniasarmiayi “¿Nekas ame Kristu Yus akupkamu tátinia nukaitiam. Kame chikichak nákastatajⁱ?” ");
INSERT INTO jivNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tutai Jesus tímiayi “Waketkirum ashí ántarmena nusha wáintrumna nusha Juaṉ ujaktarum. ");
INSERT INTO jivNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kusurusha wáinmainiawai. Shutuapsha wekainiawai. Tunamarusha péṉker ajainiawai. Empekarusha ántuiniawai. Jákarusha nantainiawai. Tura kuítrinchanmasha uwempratin chicham ujakmaiti. Nu ujaktarum. ");
INSERT INTO jivNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Túrasha yawe̱tsuk Winia tuke shiir enentáimturna nú shuar shiir átatui.” Jesus nuna tutai waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waketkiarmatai shuar káunkarun Jesus Juáṉkan pachis áujmatmiayi. “Shuar atsamunmasha ¿warí werimiarum? Pintiu nase umpúam atúu we ju̱ní we ajana nuka ¿íistai tusarumek wémarum? Kame Juaṉkka nú shuarchaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nuikia ¿warí werimiarum. Shuar péṉker iwiarmampra íistai tusarmek wémarum? Warí, péṉker iwiarmampraka uunta je̱e̱n pujuiniatsuk. ");
INSERT INTO jivNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nuikia ¿warí werimiarum. Yúsnan etserniuk werimiarum? Maa, túrachmashiuram. Túrasha Juaṉkka yaunchu etserniu naṉkaamas enentáimtustiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yaunchu Yus-Papinium áarmaiti: “Winia akatramurun amii̱ni emka akupeajai ame jintimin iwiarat tusa.” Juaṉ nu akatramuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nekasan tájarme, shuar imiakratin Juaṉja̱i̱ naṉkaamas uunt atsuwiti. Tuma aiṉ Yus akupeamunam pachiinia nu shuarnaka, nekasmianchancha, Juaṉja̱i̱ naṉkaamas shiir enentáimtustiniaiti. Tuma asamtai nui̱ pachiinkiatin enentáimpratarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Kakaram shuarka imiakratin Juaṉ támia nú tsawantnumia̱ Yus akupeamunam ti pachiinkiatniun wakeruiniak kakarmaja̱i̱ pachiinkiatniun enentáimiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juaṉ pujumia nú yaunchu ashí Yúsnan etserin armia nusha tura Muisais akupkamusha Yus akupin ajastinian etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yaunchu Yúsnan etserin “Kristu táatsa̱i̱ṉ Erías tátiniaiti” tímiayi. Tura nekaatin wakerakrumka Juaṉ nu Eríasaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Antuktin jeakrumka nekaatarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Ju̱ áentsnasha ¿wariji̱a̱i̱ métek nakumkataj? Uchiji̱a̱i̱ métek áiniawai. Ni ai̱ji̱a̱i̱ iruntrar nakurustaj táyataṉ tuíniawai ");
INSERT INTO jivNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Námpera áinis nakurustaitsar peem umpuarji túrasha jantsemáchurme. Nuyá iwiarsatniua áinis nakurustaitsar íwiareakur kantamtai kantamáji túrasha átum úutcharme.” ");
INSERT INTO jivNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Atumsha núnisaitrume. Kame Juaṉ núkap yurumtsuk nijiamchincha úmutsuk wekaimiayi. Túmakui átumka “Yajauch wakantrukuiti” tímiarme. ");
INSERT INTO jivNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nuyá Wisha Aents Ajasu támajai. Tura yurumeakui tura úmakui “Ti yurumin ti nampenaiti. Ashí yajauch shuaran amikrinti” túrutrume. Wátsek, wi túramuja̱i̱ Yus nekas nékamu nekanattawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nuyá tujintiamun túramiania nú peprunmaya̱ shuaran pachis Jesus chicharkamiayi. Tuma aiṉ nuyá shuar ni enentái̱n yapaji̱ácharu asamtai ju̱na chicharkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wáinkiatá, Kurasín péprunmaya̱tiram, Petsaitia péprunmaya̱tirmesha. Nui̱ aents tujintiamun ti túraitjai. Tiru péprunmasha Setuṉ péprunmasha nu tujintiamu túramuitkiuiṉkia yaunchu ni enentái̱n yapaji̱áwara̱a̱yi. Túrawar kúntuts pujutai pushín entsarar yuṉkunim ajakiara̱a̱yi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tura Wisha tájarme, nekapsatin tsawant jeamtai Yus atumin tí asuttiamattarme. Tirunmaya̱ shuaran naṉkaamas tura Setuṉnumia̱ shuaran naṉkaamas asuttiamattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","‘Tura atumsha Kapernáum péprunmaya̱tirmesha, ashí naṉkaamas naṉkaamantu ajastin enentáimtumarme. Antsu ashí emestamprartatui. Atumi̱i̱n aents tujintiamun ti túraitjai. Sutuma péprunam nu tujintiamu túramuitkiuiṉkia nu pepru yamaisha tuke a̱a̱yi. ");
INSERT INTO jivNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tura Wisha tájarme, nekapsatin tsawant jeamtai Yus Sutumanmaya̱ shuar naṉkaamas atumin asuttiamattarme.” ");
INSERT INTO jivNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nuyá Jesus tímiayi “Shiir enentáimtajme, Aparu, ashí nayaimpisha nuṉkasha Úuntrinme. Tuma asam Ame túram nu ti unuimiaru enentáimtumainia nuyá ú̱u̱kuitme antsu uchichia áinis naṉkaamantu enentáimtumainiatsna nú shuar paant awajtusuitme. ");
INSERT INTO jivNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ame, Aparu, nú̱nis wakera asam túraitme.’ ");
INSERT INTO jivNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‘Winia Apar ashí surusuiti. Wisha ni Uchirí̱ asamtai Winia nékarui. Tura chíkich Winia nekas nekarainiatsui. Yus Apancha Wiki nékajai. Tura Wi wakeraj nú shuaran winia Aparun paant awajtajai. Nu shuarsha winia Aparun nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ashí pimpikniutirmesha itiurchat pujarmena nusha Winí winitiarum. Túrakrumniṉkia ayamtikrattajrume. ");
INSERT INTO jivNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wi kajechu asan tura péejchach enentáimin asamtai Winí winirum unuimiartarum. Winia chichamur ántakrum umíakrumniṉka atumí wakaní ayamprattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Atumin akuptaj nú túratin yúpichuchiiti. Káarkasha Wi súajrumna nu wampuchiiti” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nuyá Jesus ayampratin tsawantai̱ ajanmaṉ ajapeniṉ naṉkaamamiayi. Ni unuiniamuri̱sha tsukarar trikiu neren maju̱sar yukí wekasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pariséu shuarsha nuna wáinkiar Jesusan aniasarmiayi “Iista, ame unuiniamuram ayampratin tsawantai̱ túratin surimkiamua nuna túruiniawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tutai Jesus tímiayi “Yaunchu uunt akupin Tawitcha tura nemarniusha tsukamainiak túrawarmia nu ántichukaitrum. ");
INSERT INTO jivNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yusa Uunt Je̱e̱n wayá Yus iniaktusma tantan yuámiayi. Nu tantasha aya Israer-patrik yúatin asamtai Tawitniasha tura ni nemari̱n ana nunasha suritkiamuyayi. Túmaiṉ yúawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Muisais akupkamunam aarma nu áujsachukaitrum. Israer-patrikia ayampratin tsawantai̱ takainiayataṉ nusha tunaachuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nekas tájarme, yamái Yusa Je̱e̱n enentáimtustinia nuna naṉkaamas Wíniaka Aents Ajasuitjiana nu, nekas enentáimtursatniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yus-Papinium tawai: “Murik maam Winia surusum nuja̱i̱ “maakete” tátsujai. Antsu waitneṉkartutain wakerajai.” Nu chicham nekas nékaitkiurmeka yamái túrarmena núnisrum tunáa túrachu ántrarum súmamtikiachaintrume. ");
INSERT INTO jivNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wi Aents Ajasu asan ayampratin tsawantan Úuntri̱ntjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus nuyá wé Israer-shuar iruntainiam waya̱miayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nui̱ shuar ámiayi ni uwejé̱ jaka. Tura Jesusan ántar nekapsatai tusa wakeruinia ásar aniiniak “¿Ayampratin tsawantai̱ jaa shuar tsuarminkiait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tutai Jesus tímiayi “Atumsha atumí murikrí̱ ayampratin tsawantai̱ wa̱a̱nam akaiki iniamtai jusatai tusarum wéchaintrupash. ");
INSERT INTO jivNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Antsu shuarka murikja̱i̱ naṉkaamaschakait. Tuma asamtai ayampratin tsawantai̱sha péṉker ana nu túramniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tinia iniais áishmaṉkan uwejé̱ jakan tímiayi “Uwejé̱m takuitia.” Tutai uwejé̱ takuí̱ chíkich uwejé̱ja̱i̱ métek péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nuna túramtai Pariséu shuarsha a̱a̱ jíinkiar Jesus itiurak máawaintiajⁱ tusar chichaman najatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus nin máatniun nekaama nuyá jíinkimiayi tura wéakui untsurí̱ shuar nemariarmiayi. Untsurí̱ jáiniancha tsuámiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsuar “etserkairap” tinia akupiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yaunchu Yúsnan etserin Isayas tímia nu uminkiati tusa túrunamiayi. Niisha ju̱na áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jú̱iti Wi achikmaj nu. Niisha Wi tájana nuna umin asamtai ti aneakun Niiji̱a̱i̱ waraajai. Winia Wakantru kakarmari̱n takamtsuk susattajai. Túramtai winia uwempratin chichamprun ashí Israercha nuṉkanmasha etserkattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jiakchattawai tura kakaram chichaschattawai. Winia anturtukarat tusa péprunam weak untsukchartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Akupin ajatsuk shuar pintiu punua núnis pimpiru ainia nuna kúpitsuk yáiṉtatui. Núnisaṉ shuar ji yama ikiapámu áinis kakarmachu ainia nuna ikiajniatsuk ikiakártatui. Tura ashí nupetak ti péṉker kakaram akupin ajastatui. ");
INSERT INTO jivNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tura Israer-shuarchasha Nin nekas enentáimtusartatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nuyá Jesusan shuar yajauch wakantrukun itiariarmiayi. Nu shuar ji̱i̱ kusurusha chichachusha ámiayi. Tura Jesus tsuármatai paant íimsamiayi tura chichakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nuna wáinkiar shuar shiir enentáimprar tiarmiayi “¿Tawitia uchirí̱ pampaṉku iniaṉnamu uwemtikkiartin tátinia nuáshit?” ");
INSERT INTO jivNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tura Pariséu shuarsha nuna antukar yajauch enentáimtuiniak tiarmiayi “Ju̱ka iwianchi kapitiántri̱n Pirsepún umirniuiti. Tuma asa nuna kakarmari̱ji̱a̱i̱ yajauch wakanin ji̱i̱ki akupeawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus tu enentáimainian neka asa tímiayi “Nú nuṉkanmaya̱ shuar nuamtak kajernaiyakuiṉkia nú nuṉka wari meserchattawak. Núnisaṉ nuamtak shuar ní shuarja̱i̱ mánainiakka amunaikchartatuak. ");
INSERT INTO jivNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Núnisaṉ íwianch nuamtak ji̱i̱ki akupnainiakka máanaikiar wárik amuukashtatuak. ");
INSERT INTO jivNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kame Wi Pirsepú iwianchi kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki akupeakuiṉkia atumí uchirí̱sha ¿yana kakarmari̱ji̱a̱i̱ṉ ji̱i̱ki akupena? Ni túramuri̱ji̱a̱i̱ átum awajirma nekamatarum. ");
INSERT INTO jivNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wi Yusa Wakaní kakarmari̱ji̱a̱i̱ yajauch wakanin ji̱i̱ki akupea asamtai atumsha Yusa akupeamuri̱ atumi̱i̱n jeartamarmena nu nekaatniuitrume.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Iista. Shuar kakaram shuara kuítri̱n kasarkatin wakerakka emka kakarman jiṉkiá aya túraṉ ni je̱e̱n wayá kasarkamniaiti. Wi iwianchin jí̱i̱kmiaja̱i̱ uunt iwianch nupetkamua nu nekaamniaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Wiji̱a̱i̱ tsaniṉ pujatsna nuka winia nemasruiti. Núnisaṉ Winia yáintsuna nu aya itiurchat nájateawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‘Tuma asamtai tájarme, Ashí shuar tunáa túruinia nusha yajauch chichainia nusha tsaṉkuratin awai. Antsu Yusa Wakani̱n yajauch chicharin ainia nuka tsaṉkurashtiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Winiasha Aents Ajasuitjiana nuna yajauch chichartuinia nú shuarsha tsaṉkuramniaiti. Tura Yusa Wakani̱n yajauch áujmatainia nuka peṉké tsaṉkurachminiaiti. Ju̱ nuṉkanmasha tura ukunmasha tsaṉkurnarchattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Yutai numi péṉkeran nereawai. Tseas numisha yajauchin nereawai. Ni nereja̱i̱ numi nekaamniaiti. Núniskete atumja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tseas wenunniutirmesha, ¿atumsha itiurak imiá yajauchitirmesha péṉker chichamsha chichastarum? Shuar ni enentái̱n enentáimna nuna chichaawiti. ");
INSERT INTO jivNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Péṉker shuar péṉker enentáimiu asa shiir chichaawiti. Tura yajauch shuar yajauch enentáimiu asa yajauch chichaawiti. ");
INSERT INTO jivNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tura Wisha tájarme, nekapsatin tsawant jeamtai ashí enentáimtsuk chichakma nuna Yúsan paant ujakartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iis, ame chichammiji̱a̱i̱ nekanattarme. Péṉker chichakuitkiumka sumamashtatme. Tura péṉker chichakchaitkiumka sumamattame.” ");
INSERT INTO jivNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pariséu shuarsha Israer-shuara jintinniuri̱sha Jesusan chicharuk “Uuntá, ame Yúsaiya̱itjai tusam nayaimpinmaya̱ kakarmaja̱i̱ iniakmamu túrata, iisha wáinkiatai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tutai Jesus tímiayi “Shuar yajauch tura Yúsan enentáimtachu ásar nayaimpinmaya̱ iniakmamun seainiawai. Tuma asamtai, áyatik yaunchu Junas túrunamu iniakmastiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Junas menaintiu kashi menaintiu tsawantcha namaka ampuje̱n eṉkemsamiayi. Núnisnak Wi, Aents Ajasu asan, menaintiu kashi menaintiu tsawantcha nuṉká jakan tepestatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Junás Níniwi péprunmaya̱ shuaran Yus-Chichaman etserkamtai nu shuar ni tunaari̱n enentáimtusar ni enentái̱n yapaji̱áwarmiayi. Tura ju̱i̱ yamái Junasa naṉkaamas etserin pujawai. Wiitjai nusha, tura anturkachuitrume. Tuma asamtai nekapsatin tsawant jeamtai Níniwinmaya̱ shuar ju̱yá shuaran súmamtikiawartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","‘Yaunchu nuwa̱ yajaya̱ shuaran úunt akupniuri̱yayi. Nu nuwa̱ Sarumúṉ ti neka asamtai nin anturkataj tusa tarimiayi. Tura ju̱i̱ yamái Sarumúṉja̱i̱ naṉkaamas anturkamnia pujawai. Nusha Wiitjai. Tuma asamtai nekapsatin tsawant jeamtai nu nuwa̱ ju̱yá shuaran súmamtikiawartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Shuara enentáiya̱ yajauch wakan jíinkin yumi peṉké yútatsna nui̱ wéawai. Tura nui̱ péṉker pujustinian wáinkiach ataksha waketkitniun enentáimiui. ");
INSERT INTO jivNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Wi jíinkimiaj nui̱ waketkittiajai” tawai. Tura waketki shuara enentái̱n péṉker iwiaramu tura aṉkantan wáiniak ");
INSERT INTO jivNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ni ai̱n siati (7) iwianchin niiji̱a̱i̱ naṉkaamas yajauchin itiá shuara enentái̱n eṉkemáwartatui. Túrunamtai nu shuar nuiki núna naṉkaamas yajauch ajastatui. Núnisaṉ ju̱yá shuar túrunawartatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus nu shuarja̱i̱ tuke chichaak pujai̱ ni nukurí̱sha ni yachí̱sha tariarmiayi. Tura a̱a̱ wajasar Niiji̱a̱i̱ chichastaj tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Túramtai Jesusan ujakar “Ame nukusha yatsumsha a̱a̱ wajasar chichastaj turamainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chichaman ujakmia nuna Jesus tímiayi “¿Ya ainia winia nukursha winia yatsursha?” ");
INSERT INTO jivNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nuyá ni unuiniamuri̱n iniakmas tímiayi “Ju̱ áiniawai winia nukur tura winia yatsursha. ");
INSERT INTO jivNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ashí shuar winia Apar nayaimpiniam pujana nu wakeramun umiiniana nu winia yatsur winia umar winia nukur áiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nu tsawantai̱ Jesus ni je̱e̱ya̱ jíinkin antumiaṉka kánmatkari̱n pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tura ti untsurí̱ shuar káunkarmatai kanunam eṉkemar nui̱ pujusmiayi. Shuarsha antumiaṉka kánmatkari̱n pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Túrunawarmatai untsurí̱ métek-taku chichamja̱i̱ unuiniamiayi. “Atsaamin atsaamprataj tusa jíinkimiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Atsaamki wesa arakri̱ jintia písunmasha iniaarmai. Tura chiṉki tariar yuawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chikichcha kaya írunmanum iniaarmai. Nuṉka ishichik asamtai wárik tsapainiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tura nantu etsantramtai péṉker kaṉkáprúrcharu asa sukuam káararmai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chikichcha jaṉkí nupanam iniaarmai. Tura jaṉki wárik tsakar nupetak ajakramai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Chikichcha péṉker nuṉkanam iniaarmai. Nusha péṉker nerekar chíkich siaṉsha (100) nerekarmai. Tura chikichcha sesenta (60) nerekarmai. Tura chikichcha trainta (30) nerekarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kuishim ákuiṉkia antuktarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nuyá ni unuiniamuri̱n Jesusan taruntar aniiniak “¿Urukamtai aya métek-taku chichamja̱i̱ ju̱ shuar unuiniam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tutai Jesus tímiayi “Urukuk ju̱ nuṉkanam Yus akupin ati, nuka yaunchu nekanachmiayi. Tura yamaikia Yus ashí nuna atumin paant iniakturmawai. Antsu chíkich nuna nekaachmin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kame núkap takakna nu shuar nú nukap patatnaktatui tura ti núkap takustatui. Antsu ishichik takakna nuka ishichik takakuk juruktiniaiti. Núnisaṉ Yusna ti nekarum nú núkapka yúpichuch nekaattarme. Tura ishichik nékarum wárik kajinmatkittiarme. ");
INSERT INTO jivNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tuma asamtai aya métek-taku chichamja̱i̱ unuiniajai. Nú shuarka íiniayataṉ wáiniáiniatsui. Ántuiniayataṉ ántachua núnis nékainiatsui. Túmainiak Winia nekarainiatsui. ");
INSERT INTO jivNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nuja̱i̱ yaunchu Yúsnan etserin Isayas timia nu uminkiaiti. Ju̱na tímiayi: “Ti ántayatrum anturkashtatrume. Wáiniatrumsha nekaashtatrume. ");
INSERT INTO jivNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ju̱ shuara enentái̱ kátsuram ásar péṉkera nuna nakitiainiawai. Nu asamtai péṉker ántuiniatsui, ji̱i̱sha pusá áinis áiniawai. Túrachkuṉka paant nekaawarainti, tura nekas antukarainti, tura enentái̱ji̱a̱i̱ enentáimias Winia tsuarat tusa tarutiarainti.” ");
INSERT INTO jivNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tura átumka paant wainkia asarum péṉker anta asarum shíiraitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nekasan tájarme, untsurí̱ Yúsnan etserniusha tura péṉker shuarsha átum yamái wáintrum nuna wáinkiatniun wakeruiniayataṉ wáinkiacharmiayi. Tura átum yamái ántarme nuna antuktinian wakeruiniayataṉ antukcharmiayi’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Ayu, antuktarum. Atsaampramu chichaman paant jintintiatjarme. ");
INSERT INTO jivNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Árak jintia písunam iniaararma nuka shuar Yus-Chichaman ántayataṉ ni enentái̱n ikiuiniatsna núiti. Tura íwianch nu Yus-Chicham ni enentáin atsaampramu áinis antukman kajinmatkiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Árak kaya írunmanum iniaarma nuka shuar Yus-Chichaman antuk waras umirainia núiti. ");
INSERT INTO jivNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tura núkap kaṉkaprurcharu ásar katsuiniatsui. Antsu itiurchatan íṉkiuiniak tura Yus-Chichaman wakeruinia ásarmatai chíkich yajauch áujmatam wárik iniaisar ikiuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Árak jaṉkí nupanam iniaarma nuka shuar Yus-Chichaman antuk emka umirniua núiti. Tura ju̱ nuṉkanam írunna nuna tuke páchiniak ni kuítri̱ncha ti enentáimtuinia ásarmatai ashí Yus-Chichaman enentáimtamun núpeteawai. Tuma asamtai nu áentsnum Yus-Chicham atsaampramu nereatsui. Yus-Chicham ni enentái̱n takasma atsawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tura árak péṉker nuṉkanam iniaarma nuka shuar Yus-Chichaman antuk péṉker umirainia núiti. Tura péṉker nerenawai. Chíkich siaṉ (100) nerekarma núnis chikichcha sesenta (60) nerekarma núnis chikichcha trainta (30) nerekarma núnis áiniawai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus ataksha ju̱ métek-taku chichaman áujmatsamiayi. “Shuar Yus akupeamunam pachiinkiartin jú̱nisaiti. Shuar péṉker arakan, tríkiun ni nuṉken araamai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tura ashí kanararmatai nemasri̱ kashi taa trikiu arakmanum yajauch nupa̱n aratak ikiukmiai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trikiu tsapakar nereakui nuyá yajauch nupa̱sha nusháa nereku asa ti paant ajasmai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nuna íisar takainia nu ni úuntri̱n werí tiarmai “Uunta, ¿péṉker arak araachmakam. Itiura ju̱sha yajauch nupa̱sha tsapakuit?”’ ");
INSERT INTO jivNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Tutai nérentin timiai “Winia nemasur arakuiti.”’ ‘Takui ni takarniuri̱ tiarmai “¿Yajauch nupa̱n uwerat tusam wakeramek?”’ ");
INSERT INTO jivNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Tutai timiai “Atsá, uwerairap. Yajauch nupa̱ uweaj tukamarum trikiu uweniirum. ");
INSERT INTO jivNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iniaisatarum. Antsu métek tsakakti. Júuktin tsawant jeamtai winia takartinian emka yajauch nupa̱n uwer irumar jinkiawarat tusan akupkartatjai. Tura áesawartatui. Tura trikiu nere̱n júukar péṉker ikiusarat tusan akupkartatjai” timiai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus ataksha métek-taku chichaman áujmatsamiayi. “Shuar Yus akupeamunam pachiinkiartin mustasa jiṉkiaiya áintsaṉkete. Shuar péṉker nuṉke̱n araamai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mustasa jiṉkiáikia imiá uchichiitiat tsapái tsakaakka ashí numichiji̱a̱i̱ naṉkaamas uunt ajawai. Ti uunt asamtai chiṉki ni kanawen pasuṉmainiawai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Núnisaṉ chíkich métek-taku chichaman áujmatsamiayi. “Shuar Yus akupeamunam pachiinkiartin karinia áintsaṉkete. Nuwa̱ nijiamchiniam karinia eṉkea mashi páchimiawai. Tura nu mash karimtikiawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Ashí nuna Jesus métek-taku chichamja̱i̱ áujmatsamiayi. Yaunchu Yúsnan etserin timia nu uminkiati tusa túramiayi. Etserin ju̱na áarmiayi: “Métek-taku chichamja̱i̱ áujmattiatjai. Yámankamtaiknumia̱ nékashtain etserkattajai” tu áarmiayi. Nu asamtai aya métek-taku chichamja̱i̱ṉ áujmatmiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nuyá shuaran ikiukin Jesus je̱á támiayi. Túramtai ni unuiniamuri̱ tariar “Yajauch nupa̱ áujmatmena nu paant awajsata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tutai Jesus tímiayi “Wi Aents Ajasuitjai. Wi péṉker arakan atsaamkaitjai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ashí nuṉka aja áintsaiti. Péṉker jiṉkiái Yus-shua̱ran Yus akupea nuna nakumeawai. Yajauch nupa̱ iwianchna ainia nuna nakumeawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tura íwianch ii nemasri̱ asa yajauch nupa̱n arakuiti. Tura nuṉka amúamunam Yusa suntari̱ arakan júuktinia áintsaṉ shuaran yaruaktatui. ");
INSERT INTO jivNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yajauch nupa̱ irur jinium áesatniua áanis nuṉka amúamunam túrunattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Nui̱ Wi Aents Ajasu asan winia suntarun akupkattajai. Tura ashí tunaan túruinia nunasha tura chikichan tunaanum útsuinia nunasha mash irurar jinium apeawartatui. Nui̱sha ti úutin ti wáitsatniusha átatui. ");
INSERT INTO jivNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Antsu péṉker túruinia nuka ti shiir wincha ajasar ni Aparí̱ akupeana nui̱ etsa núnis tsáapnin ajasartatui. Wats, kuishim átsuk. Antukta.’ ");
INSERT INTO jivNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Shuar Yus akupeamunam pachiinkiatin kuit nuṉká u̱u̱kma áintsaṉkete. Shuar nu kuítian wáiniak nuiṉ ataksha u̱u̱kmai. Tura ti waras waketki nu kuit niiniu atí tusa ashí ni takakman suruk nu nuṉkan sumakmai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Shuar Yus akupeamunam pachiinkiatin jú̱nisaiti. Shuar kayachin ti shíirman e̱a̱k wekaana áintsaṉkete. ");
INSERT INTO jivNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tura kayan ashí naṉkaamas kuit jeean wáiniak waketki ashí takakna nuna suruk nu kayan niiniu atí tusa súmawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Shuar Yus akupeamunam pachiinkiartin jú̱nisaiti. Shuar nekaja̱i̱ namakan achía áintsaṉkete. Nekan nayaantsanam ajuntak niisháa namakaim achíawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tura nekanam nemarmatai kukar ji̱i̱ki, nui̱ péṉker namaknasha chaṉkinnium chumpiniawai. Tura yajauch namaknaka ajapenawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Núnisaṉ átatui nuṉka amúamunam. Yusa suntari̱ taar Yus-shuaran tura íwianch shuaran akantrattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tura íwianch shuarnaka uunt jinium apeattawai. Nui̱sha ti úutin ti wáitsatin átatui.” Nuna ashí ni unuiniamuri̱ji̱a̱i̱ áujmatsamiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus nuna tinia amuk “¿Ju̱ mash antukurmek?’ tímiayi. Tutai ni unuiniamuri̱ “Ee, Uunta, ashí antukji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tuiniakui Jesus tímiayi “Shuar ashí Yúsnan péṉker unuimiaruka aents kuítriniua áintsaṉkete. Ni ikiutairi̱ya̱ yamarmancha yaunchu sumakmancha jusamniaiti. Núnisaṉ nu shuar yamái nékamuja̱i̱sha tura yaunchu nékamuja̱i̱sha Yus-shuaran yáiṉtiniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus nu métek-taku chichaman áujmatas amuk nuyá wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tura ni pépruri̱n Nasarétnum jeá Israer-shuar iruntainiam wayá unuiniamiayi. Tura nuyá shuar antukar tí enentaimprarmiayi. Tura “¿Ju̱sha tui̱ imiá unuimiaruit, tiarmiayi. Itiurak aents tujintiamun túramniait? ");
INSERT INTO jivNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Juka karpintíru uchirinchukait. Nukurí̱sha Marichukait. Tura ni yachi̱sha Jakupu, Jusé, Semuṉ, Jútas áiniatsuk. ");
INSERT INTO jivNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tura ni umai̱sha iiji̱a̱i̱ írutra pujuiniatsuk. ¿Nuikia itiura mash neka?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Túrawar Jesusan itiurchat enentáimturarmiayi. Túramtai Jesus chicharuk “Yúsnan etserniun ashí shuar péṉker anturainiawai, antsu aya nuna nuṉkeya̱ṉka ni shuari̱ṉkia nin anturainiatsui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tura nú shuar Jesusan enentáimtuiniachu asamtai aentsti tujintiamun aya ishichik túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kariréa nuṉkanam Erutis akupniuyayi. Tura Jesus túramuncha antukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tura ni írutramuri̱n tímiayi “Nuka imiakratin Juaṉ jakamunmaya̱ nantaki túrawai auka. Tuma asa aents tujintiamun túrawai” tímiayi. Kame Erutis Juaṉkan maa asa tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Akupin Erutis ni yachí̱ Jiripi nuwe̱n Jirutíasan akintrukmatai Juaṉ Erutisan “Ame yatsumi nuwé̱ akintrukchatniuitme” tímiayi. Tutai Erutis Juaṉkan achik jiruja̱i̱ jiṉkiá sepunam eṉkeatarum tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Niisha Juaṉkan máataj tukamá aentsun ashamiarmiayi. Ashí aents “Juaṉ Yúsnan etserniuiti” enentáimtuiniakui ashammiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tura akupin Erutis akiiniamu tsawantri̱ jeamtai nú námpertin Jirutíasa nawantri̱ ashí ipiaamu pujuiniamunam jantsemamiayi. Túramtai Erutis shiir enentáimtak ");
INSERT INTO jivNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Ame ashí wakeram nu seattia, tímiayi. Nekasan amastatjai, Yussha iirui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tutai nu nuwa̱ch emka ni nukuri̱ akatramu asa Erutisan chicharuk “Imiakratin Juaṉka muuké̱ tsupikiam amamkunam eṉkeram surústá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tutai Erutis wake mesekmiayi. Túrasha “nekas Yus iirui” tiniu asa tura ni amikri̱sha antukaru asamtai umikmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ni suntari̱n sepunmaya̱n Juaṉka muuke̱n tsupik itiarti tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tura amamkunam itiar nuwa̱chin súsarmiayi. Tura niisha ni nukurí̱ susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nuyá Juaṉka írutramuri̱ tariar aya̱shí̱ jukiar iwiarsarmiayi. Túrawar Jesusan ujauwearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus nuna antuk Niṉki ni unuiniamuri̱ji̱a̱i̱ṉ kanunam eṉkemar arant aents atsamunam wémiayi. Túrasha nuna aents nekaawar kukarak weriarmiayi Jesusan. ");
INSERT INTO jivNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kanunmaya̱ jíiniaj tukamá untsurí̱ áentsun wáinkiamiayi. Tura wáiniak waitnentrarmiayi. Tura jáiniancha tsuárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kí̱akui ni unuiniamuri̱ Nin tariar tiarmiayi “Kí̱awai, Uunta. Tura shuar tíjiu̱ch pujaaka atsawai. Ju̱ aents akupkarta. Péprunam wear sumak yuuwearti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tutai Jesus tímiayi “¿Urukamtaik wearat? Antsu atumek ayuratarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tutai tiarmiayi “Iikia takaktsuji. Aya seṉku (5) tantachik jimiarchik namakchiji̱a̱i̱ṉ takakji.” ");
INSERT INTO jivNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tuíniakui Jesus “Wats, nu itiartitiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tinia aents chírichriniam pujusarti tusa akupkamiayi. Nuyá seṉku (5) tantancha jímiar namaknasha achik nayaimpiniam íimias Yúsan yumiṉsamiayi. Tura puur ni unuiniamuri̱n aents ayuratarum tusa súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ashí yurumáwar jémararmiayi. Tura nuya̱sha puunaruka tuse (12) chaṉkin tiármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nui̱ yurumáwarmia nusha nuwa̱sha uchisha nekapmatsuk seṉku mir (5000) aya áishmaṉ ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nuyá Jesus ni unuiniamuri̱n kanunam eṉkemprarum amain émaa ajatarum tusa akupkarmiayi. Niisha áentsun akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Akupkarsha naint waka Yúsan áujumiayi. Káshisha nui̱ Niṉki tuke pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tura antumiaṉ tí waṉkaram asamtai kanu ajapén ajasmatai nase tukumma entsa tamparukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsawaana ai̱ nii tuke wenai̱ Jesus entsá pátatek wekas pujuiniamunam jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tura ni unuiniamuri̱ entsá pátatek wekaan wáinkiar ti sapijmiakarmiayi. Tura ashamainiak “wakanchashit” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tuíniakui Jesus tiarmiayi “Kakaram ajastarum. Wiitjai. Ashamprukairap.” ");
INSERT INTO jivNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Takui Pítiur chicharuk tímiayi “Uunta, Ámetkumka nui̱ wekasa jeatin untsurkata.” ");
INSERT INTO jivNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Takui Jesus tímiayi “Wats, winitiá.” Tutai Pítiur kanunmaya̱ akaikin Jesus wajana nui̱ jeataj tusa entsá pátatek wekasamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tura ti nasen násentun nekáa ashamkamiayi. Ashama asa entsá waya̱miayi. Tura “Uuntá, achirkata” tu untsummiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nu chichamtaik Jesus uwejnum achik júak “Maa, Yus imiá ishichik enentáimtuschamek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tura kanunam eṉkemáwarmatai nasesha meṉkakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Túramtai kanunam eṉkemarmia nusha Jesusan tikishmatar chicharuk “Nekas ame Yusa Uchirí̱nme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tura amaini̱ katiṉkiar Jinisarít nuṉkanam jearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tura nuyá aents Jesusan nekaawar nu nuṉkanam ashí ujanairarmiayi. Túrawar jaancha ni pujamunam itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ni pushiri̱nkisha antiṉtai tusar seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nuyá Jerusaréṉ péprunmaya̱ Pariséusha yaunchu akupkamu jintinniuri̱sha Jesusan tariar aniasarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Urukamtai ame unuiniamuram ii uuntri̱ yaunchu jintintrarmia nuna uminiatsu? Iis, ikijmiatskesha yurumáiniawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tuíniakui Jesus aniasarmiayi “¿Urukamtai atumsha Yus akupkamu umirtsuk aya aents akupkamu umiirum? ");
INSERT INTO jivNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iis, Yus tíchamkia: “Ame apa, nukusha shiir enentáimtustarum.” Tura “Shuarsha ni aparí̱ncha nukurí̱ncha katsekka nu shuar jakati” tíchamkia. ");
INSERT INTO jivNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Antsu átumka tárume “Shuar ashí niiniu írunna nuna mash “Yúsnaiti” takui nuikia nuja̱i̱ ni aparí̱ncha nukurí̱ncha yáiṉchamniaiti, tárume. Nin yáiṉtinian nakitiak ayatik “Ashí winia áiniana nu Yusna asamtai yáiṉchamniaitjame” títiniaiti” tárume. Núnisrum tákuram Yus akupkamu iniaisarum aya aents akupkamu umiirume, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Antra chichamtiniaitrume. Yúsnan etserin Isayas yaunchu nekas atumin áartampramiayi ju̱na: ");
INSERT INTO jivNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ju̱ aents ni wene̱ja̱i̱ shiir awajtuiniawai, tura ni enentái̱ jeachat pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tura tukeneasaṉ shiir awajtuiniawai. Aentsu chichame̱n jintintiainiayat “Yusa chichame̱nte” tuiniawai.” Tu áarmiayi” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tinia shuaran untsuk tiarmiayi “Ju̱ antukrum péṉker nekaatarum. ");
INSERT INTO jivNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aents yúana nuka shuáran yajauch awajsashtatui. Antsu wenunmaya̱ jiinia nuka shuáran yajauch awajeawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nuyá ni unuiniamuri̱ Jesusan tariar “Maa, Pariséu ame chichammin antukar ti itiurchat enentáimprarai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Tuíniakui Jesus tímiayi “Ikiuktiarum. Kusuru áintsaṉ áiniawai. Tura kusuruncha jintintiainiawai. Mai kusuru ásar mai wáa̱nam akaiki iniaawartatui. Wats, ajanam nupá áintsaṉ ainiawai. Tura ashí winia Apar nayaimpiniam pujana nu araachmaka takamtsuk uwé ajapamu átatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Takui Pítiur Jesusan tímiayi “Nu métek-taku chicham paant awajsata.” ");
INSERT INTO jivNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tutai Jesus tímiayi “¿Atumsha nekaachurmek. ");
INSERT INTO jivNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Enentáimprachurmek? Ashí wenunam waya̱a̱na nu wakenam wéatsuk. Tura nuyá iniaṉkastiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Antsu wenunmaya̱ jiinia nu enentáinmaya̱ jiiniu asa áentsun yajauch awajeawai. ");
INSERT INTO jivNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Enentáinmaya̱ ashí yajauch enentáimsatin jíiniainiawai. Maṉkartuatniusha, chikicha nuwé̱ kasamkatniusha, tsanirmatniusha, kasamkatniusha, wáitruatniusha, yajauch áujmatsatniusha ");
INSERT INTO jivNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ashí nu áiniawai nekaska shuáran yajauch awajeana nu. Tura ikijmiatsuk yurumátniuka shuáran ni enentái̱n yajauch awajeatsui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus nuyá jiinki Tiru péprunmasha Sitiuṉ péprunmasha wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tura nu nuṉkanmaya̱ nuwa̱ Jesusan tarí tímiayi “Uunta, uunt akupin Tawit ame we̱a̱trum asamtai winia waitnentrurta. Nawantur yajauch wakantruku asa ti wáitrutawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tura Jesus ái̱kchamiayi. Tura ni unuiniamuri̱ tariar “Awemata, tiarmiayi. Tuke untsumki apapétmaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nuyá Jesus tímiayi “Aya Israer-shuarnum meṉkakaru áinia nuna e̱a̱ktinian Yus akuptukuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Túrasha nuwa̱ tikishmatar tímiayi “Uunta, waitnentrurta.” ");
INSERT INTO jivNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tutai Jesus tímiayi “¿Uchí apatkuri̱ jurukir yawá susamniakait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tutai nuwa̱ tímiayi “Nekas, Uunta, tame. Tura yawa̱sha ni aentsri̱ yurumainiakui nuṉká iniaarun yuíniatsuk.” ");
INSERT INTO jivNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Takui Jesus tímiayi “Maku, nekas Winia enentáimtursaitme. Ame wakeram núnisaṉ atí” tímiayi. Tura nu chichamaik ni nawantri̱ péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus nuyá jiinki Kariréa antumiaṉka káanmatkari̱n waketkimiayi. Tura naint waka nui̱ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nui̱ untsurí̱ aents Nin tariar shutuapnasha kusuruncha chichachuncha tsupirkamuncha chíkich jáiniancha itiariarmiayi. Túrawar nawenam aeprusarmiayi. Túram tsuararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nuna íisar chichachusha chichainiakui, tsupirkamusha péṉker ajainiakui, shutuapsha péṉker wekainiakui, kusurusha wáinmainiakui, ti shiir enentáimprarmiayi. Yus ni áentsri̱n Israeran yáiṉmatai shiir yumiṉsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nuyá Jesus ni unuiniamuri̱n untsukar tiarmiayi “Ju̱ aentsun waitnentainiajai. Warí, menaintiu tsawant Wiji̱a̱i̱ yurumtsuk yujainiatsuk. Ayurtsuk ni je̱e̱n akupkachminiaitjai. Jintiá pimpiki wáitsartatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ni unuiniamuri̱ tiarmiayi “Túrasha, Uunta, ¿shuar atsaasha tuyaṉ yurumak imiá sumaktajⁱ ju̱ aents ayurawartincha?” ");
INSERT INTO jivNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus aniasarmiayi “¿Urutma tanta takakrum?” Tutai niisha “Siati (7) tanta nuyá ishichik namak takakji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nuyá aents nuṉká pujusarti tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tura siati tantan achik namaknasha achik nuyá Yúsan yumiṉsamiayi. Tura puur aents ayuratarum tusa ni unuiniamuri̱n susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ashí yurumáwar jémararmiayi. Tura puunaru siati chaṉkin tiármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tura nui̱ yurumáwaruka nuwa̱sha uchisha nekapmatsuk aya áishmaṉkak kuatru mir (4000) ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nuyá Jesus áentsun akupak kanunam eṉkemar Maktara nuṉkanam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pariséusha tura Satuséusha Jesusan nekapsatai tusar tariarmiayi. Túrawar “Ame Yúsai̱ya̱itkiumka kakarmarmiji̱a̱i̱ nayaimpinnmaya̱ iniakmasta, iisha wáinkiatai,” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tutai Jesus tímiayi “Átumka “Kapa̱a̱ku péetar kíntiamkui kashin esatrurtatui” tíniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Túrasha “Te ajas kapa̱a̱ku péetar tsawa̱akui yumi yajauch átatui” tíniuitrume. Tura nekasaiti. Maa, átumka nayaim íisrum ju̱ nuṉkanam túrunattana nu nékarme. Antsu Yus yamái jú̱ nuṉkanam tura nuka nékatsrume. Ántraitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aents yajauch ásar tura Yusan enentáimtachu ásar kakarmaja̱i̱ iniakmamun wakeruiniawai. Túrasha áyatik Junas túrunamia nuke iniakmastiniaiti” tímiayi. Tinia ikiuak wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tura entsá amaini katiṉkiar ni unuiniamuri̱ tantan júkitniun kajinmatkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nuyá Jesus tímiayi “Wáinkiatarum, Pariséusha Satuséusha wakaprutai takakainia núja̱i̱sha aneartarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tutai ni unuiniamuri̱ tiarmiayi “Ii tanta itiachakrin tátsuk.” ");
INSERT INTO jivNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus nuna antuk tímiayi “¿Urukamtai tanta itiachji tunaiyarum. Yusa kakarmari̱ kajinmatkintrumek. ");
INSERT INTO jivNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Seṉku tantaja̱i̱ túramiaj nu kajinmatkintrumek. Seṉku mir (5000) áishmaṉkan ayuramtai untsurí̱ chaṉkin tiármia nu enentáimtsurmek. ");
INSERT INTO jivNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tura siati tantaja̱i̱ kuatru mir (4000) áishmaṉkan ayuramtai nuna ishichik chaṉkin tiármia nu kajinmatkintrumek. ");
INSERT INTO jivNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Itiurak imiá nékatsrum? Wi Pariséu wakaprutairi̱sha Satuséu wakaprutairi̱sha aneartarum tákun peṉké tantan tátsujai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nuna Jesus takui ni unuiniamuri̱sha nekaawarmiayi. Peṉké tantaa wakaprutairi̱n tíchamiayi antsu Pariséusha Satuséusha unuiniatairi̱n tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tura Sesaria-jiripiunam jeawar Jesus ni unuiniamuri̱n aniasarmiayi “Aents Ajasuitjiana ju̱na ¿yaiti turutainiawa Winia?” ");
INSERT INTO jivNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Niisha aya̱k tiarmiayi “Chíkich, imiakratin Juáṉkaiti turamainiawai. Chíkichka, Eríasaiti turamainiawai. Chikichcha Jeremíasaiti, chikichcha chíkich aents Yúsnan etserniuiti turamainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tutai nincha aniiniak “¿Atumsha yaiti túrutrum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Semuṉ Pítrusha “Ámetme Kristu, Yus Anaikiamu. Nekas iwiaaku Yusa Uchirínme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tutai Jesus tímiayi “Shiiraitme Junasa uchirí̱ Semuṉka. Núnaka aents ujatmakchaiti antsu winia Apar nayaimpiniam pujana nu ujatmakmatai nekaam tame. ");
INSERT INTO jivNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tura Wisha tájame, ame Pítruitme, kayach tútaim. Nu kayanam je̱a̱ jeamtinia áintsan Yus-shuaran ekenin tsakatmartatjai. Túramtai jákatniusha tura Yusa nemasri̱sha nu jeamman pukukchattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yus akupeamu yawincha amastatjai. Ju̱ nuṉkanam jiṉkiatniusha atíatniusha amasmaiti. Tuma asamtai ame ju̱ nuṉkanam suritiam nu nayaimpinmasha suritniaktatui. Tura ju̱ nuṉkanam tsaṉkateam nu nayaimpinmasha tsaṉkatnaktatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nuna tinia Jesus ni unuiniamuri̱n Krístuitiaj nu etserkairap tinia akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nuyá Jesus ju̱na unuiniataṉ naṉkammiayi. “Wi Jerusaréṉnum wétiniaitjai. Nui̱ Israer-shuara úuntri̱sha, Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha ti wáitkiarsartatui. Nuyá mantuawartatui túrasha menaintiú tsawantai̱ nantaktiatjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Takui Pítiur arantach jukí chicharuk tímiayi “Uunta, nuka peṉké áchatniuiti. Áminkia túrutmacharminiaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus ayanmatar Pítrun tímiayi “Werumta, Satanása. Yajauch awajtame. Ámeka Yus wakeramu enentáimtsume. Antsu jú̱ nuṉkanam enentáimainia áinis enentáimme.” ");
INSERT INTO jivNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuyá Jesus ashí ni unuiniamuri̱n tímiayi “Shuar Winia nemartustaj tusa wakerakka ni wakeramuri̱n iniais ni krusi̱ yanaki Winia nemartusti. ");
INSERT INTO jivNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Shuar áyatik péṉker pujustaj tákuṉka nu shuar uwemtsuk jakattawai. Antsu jákatniuitkuisha péṉker pujustinian enentáimtsuna nú shuar nekas iwiaakman wainkiattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wats, shuar ashí jú̱ nuṉkanam írunna nuna sumakka tura nuja̱i̱ ni wakani̱ émeseak ¿itiurak péṉker pujustiṉ? Shuara wakaní̱ emesramu ¿ashí jú̱ nuṉkanam írunna nuja̱i̱ iwiaramniakait? ");
INSERT INTO jivNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wi Aents Ajasu asan, winia Aparu kakarmari̱ji̱a̱i̱ tura ni suntari̱ji̱a̱i̱ tana ashí shuáran ni takasmaja̱i̱ métek akiktatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Paant tájarme, shuar ju̱i̱ wajainia ju̱ játsuk Wi akupin ajasmatai wáitkiartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nuyá sais (6) tsawant naṉkaamasar Pítruncha, Jakupuncha, tura ni yachi̱ Juaṉnasha níniak júkiar Jesus náinnium yakí wakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nui̱ Jesus nusháa iira ajattsarmiayi. Ni yapisha etsaya̱ áinis wincha ajasmiayi. Ni pushiri̱sha ti puju jiitsumir ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nui̱sha Muisaisnasha Eríasnasha Jesusja̱i̱ chichainian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nuyá Pítiur Jesusan tímiayi “Uunta, ti shiir pujaji ju̱i̱. Wakerakminkia menaint áakmaktai, Áminiu chikichik tura chíkich Muisaisnasha, tura chikichcha Eríasna.” ");
INSERT INTO jivNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tura Pítiur tu auju wajái yuraṉkim ti puju amu̱a̱miayi. Tura nu yuraṉminmaya̱ chichaman antukarmiayi. “Ju̱ka winia aneamu Uchiruiti, tímiayi. Nin ti shiir enentáimtajai. Nii péṉker anturkatarum” tímiayi. Tu chichasmiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nuna ni unuiniamuri̱ antukar ti ashamkar pákea ajakiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Túrunawarmatai Jesus táriar antiṉ “Ashamkairap, nantaktiarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tura paṉkainiar íimiaj tukamá aya Jesusan wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nuyá náinniumia̱ akainiak Jesus tiarmiayi “Átum íisurmena nu peṉké etserkairap. Wi Aents Ajasu asan jakamunmaya̱ nantaatsa̱i̱ṉ etserkairap’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nuyá ni unuiniamuri̱ Jesusan aniiniak “¿Urukamtai in jintintramin “Kristu táatsa̱i̱ṉ Erías emka tátiniaiti” tuinia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tuíniakui Jesus ái̱kmiayi “Nekas Erías tátiniaiti. Tura nii mash iwiarattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kame nekas Erías táwiti tura nin nekaacharmai. Antsu aents wakeriarmia nuna túrawar yajauch awajsarmiayi. Núnisaṉ Winiasha, Aents Ajasu aiṉ, wáitkiarsartatui.” ");
INSERT INTO jivNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nuna takui ni unuiniamuri̱ imiakratin Juáṉkan áujmatui, tu enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ataksha aents matsatmanum jeawarmatai shuar Jesusan tarí tikishmatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tura tímiayi “Uuntá, winia uchir waitnentrutrata. Wainchi tukum ti wáitniuiti. Jiniumsha patamniuiti. Entsasha iniainaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ame unuiniamurmi̱ncha itiarjiai túrasha tujinkiarai.” ");
INSERT INTO jivNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Takui Jesus ashí tímiayi “Maa, Yus peṉké enentáimtichuitrume. Imiá úmichuitrume. ¿Wi atumin katsuntu ajatniukaitjiarum? Wats, uchi itiartitiarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Itiarim Jesus yajauch wakanin ji̱i̱ki akupkamiayi uchí aya̱shí̱nia̱. Túramtai nu chichamaik péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nuyá urum ni unuiniamuri̱ Jesusja̱i̱ niṉki pujusar áujmatainiak “¿Urukamtai yajauch wakan jí̱i̱ktin iikia tujinkiamajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tuíniakui Jesus tiarmiayi “Yus nekas enentáimtachu asarum tujinkiarme. Túmaitiat nekasaiti mustasa jiṉkiái timiá uchichitiat ti uunt tsakaatsuk. Núnisaṉ Yus ishichkisha enentáimtakrumka nu naint ékemkata tutai nu naint túrunattawai. Peṉké tujinkiashtatrume Yus nekas enentáimtakrumka. ");
INSERT INTO jivNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kame nu yajauch wakan ji̱i̱ki akupkatniuka ijiarmam Yus áujsatniuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesus ni unuiniamuri̱ji̱a̱i̱ Kariréa nuṉkanam wekas ju̱na ujakarmiayi. “Wi Aents Ajasu asan, aentsnum surunkattajai tura mantamnattajai. ");
INSERT INTO jivNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Túrutawarmatai menaintiú tsawantai̱ nantaktiatjai.” Tura ni unuiniamuri̱ nuna antukar ti kúntuts enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus ni unuiniamuri̱ji̱a̱i̱ Kapernáum péprunam jeawarmiayi. Tura kuítian achin Pítrun tariar aniasarmiayi “¿Atumi uuntri̱ Israer-patrin akiktinia nuna akínkiait?” ");
INSERT INTO jivNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tutai Pítiur “Ee” tímiayi. Tura Pítiur je̱á wayá chichaatsa̱i̱ṉ Jesus emka tímiayi “Chíkich nuṉkanmaya̱ akupin ¿yana kuítri̱ji̱a̱i̱ṉ takainia. Ni shuári̱niunkek atantainia. Antsu yaja̱ya̱ shuárnan atantainiatsuk. Nekaschak, Semuṉká?” ");
INSERT INTO jivNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tutai Pítiur “Nekas yaja̱ya̱ shuárnan atantainiawai” tímiayi. Jesus tímiayi “Nuikia ni shuari̱ aṉkant áiniawai. Iisha núnisrik nu akiktin aṉkantaitji. ");
INSERT INTO jivNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Túrasha itiurchat enentáimprara̱i̱ṉ tusar akiktai. Ame tsau jukim entsá wetá. Túram emka namak japikim iwiaṉkam nui̱ kuit wáinkiattame. Nu jukim Wíniasha áminiusha akikmakta.” ");
INSERT INTO jivNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nu tsawantai̱ ni unuiniamuri̱ tariar Jesusan aniasarmiayi “Yus akupeamunam pachiinia nu ¿ya imiá naṉkaamantu áminiait?” ");
INSERT INTO jivNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nuna tuíniakui Jesus uchin untsuk ajapen awajtusar ");
INSERT INTO jivNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tímiayi “Tí nekasan tájarme, atumí enentáimtairi̱ yapaji̱arum uchia áinis ajachkurmeka Yus akupeamunam pachiinkiachminiaitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nu asamtai ju̱ uchia áinis péejchach enentáimtumana nuka Yus akupeana nui̱ nekas naṉkaamantu ajasminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nú arantcha Winia anentuk uchin itiaana nú shuar Winiasha itiaareawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Shuar ju̱ uchin Winia umirtana nuna tunaanum ajuarmataiṉkia nuna túratsa̱i̱ṉ niisha kuntujén kayaja̱i̱ jiṉkiar nayaantsanam ajapen kunanam ajunmaitkiuṉka maak ainti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ju̱ nuṉkanam tunáa iniaatai írunuk tuke itiurchataiti. Antsu shuar chikichan tunaanum aju̱arka ti itiurchatan iṉkiuṉtatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Nu asamtai ame uwejem tura nawem tunaanum ajunmatniuitkiuiṉkia tsupikiam ajapata. Kame muntuch pujustin tura ukunam nayaimpiniam wétin péṉkeraiti. Antsu kajinkiashtin jinium takamtsuk jeatniuka imiá yajauchiiti. ");
INSERT INTO jivNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Núnisaṉ ame ji̱i̱mi tunaanum ajunmatniuitkiuiṉkia ukuinkiam ajapata. Kame chikichik ji̱i̱ji̱a̱i̱ pujusam nayaimpiniam wétin péṉkeraiti. Antsu jinium mai jí̱i̱ntiuk wétin imiá yajauchiiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Uchi ainia nu nakitrairap. Yusa suntari̱ nin wáinkiatniua nu winia Aparui̱ tíji̱uch pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kame wi Aents Ajasu asan, meṉkaakarun e̱a̱ktajtsan táwitjai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘Enentáimpratarum. Shuar siaṉ (100) murikiun takakuitiat chikichik meṉkakamtai untsurí̱ meṉkakacharun náinnium matsaakᵤ meṉkakan e̱a̱ushtatuak. ");
INSERT INTO jivNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wáinkiasha untsurí̱ meṉkakacharua nuja̱i̱ naṉkaamas waraschattawak. ");
INSERT INTO jivNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Núnisaṉ atumi Aparí̱ nayaimpiniam pujana nu, nu uchi chikichkisha meṉkakacharti tawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Chikich Yus-shuar ámin yajauch túrutmakuiṉkia nii werim áujsata. Tura ámechik werim ame yatsumja̱i̱ chichasta. Anturtamkuiṉkia ame yátsum yáiṉkiume. ");
INSERT INTO jivNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tura anturtamchakuiṉkia nuyá chikichik shuar jimiará shuarsha jukim ataksha weritia. Túram ataksha áujnaisatarum, niisha paant nekaawarat tusam. ");
INSERT INTO jivNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Túrasha yatsum tuke ántachkuiṉkia Yus-shuar iruntainiam iwiainiakta. Túrasha yatsum tuke ántachkuiṉkia Yus-shuarcha núnisaṉ enentáimtusta nu shuar.’ ");
INSERT INTO jivNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Nekasan tájarme, ju̱ nuṉkanam suritiam nu nayaimpinmasha suritniaktatui. Tura ju̱ nuṉkanam tsaṉkateam nu nayaimpinmasha tsaṉkatnaktatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Núnisnak tájarme, ju̱ nuṉkanam pujusrum jimiará Yus-shuartiram métek enentáimprarum winia Apar nayaimpiniam pujana nu seakrumniṉkia wakerarmena nuna suramsattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jímiar menaintiusha Yus-shuar Winia enentáimturuk iruntrarmatai Wisha nui̱ niiji̱a̱i̱ pujajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Takui Pítiur werí Jesusan aniasmiayi “Uuntá, winia yatsur yajauch awajtakui ¿urutma tsaṉkuratniuitiaj. Siátikik tsaṉkuratniuitiaj?” ");
INSERT INTO jivNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus aiya̱k “Siátik tátsujme, antsu iniaṉnatsuk tsaṉkuratniuitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tuma asa Jesus Yus akupeamunam pachiinkiaru tsaṉkurnairartiniaiti tusa ju̱ métek-taku chichaman áujmatuk tímiayi, “Uunt akupin takari̱n tumashin akirkarat tusa untsukarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yama náṉkamuk tí nukap tumashmakua nuna untsukmai. Akikmakchamnia ti tumashmakuyi. ");
INSERT INTO jivNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tura nu takakmau kuitri̱ atsakui uunt akupin “Yajasma áitkiasrum nua̱rtiuk uchirtiuk ashí waririntiuk suruktarum, timiai. Nu kuitja̱i̱ akirkati” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tutai nu takakmau uunt akupniun tikishmatar seak timiai “Uunta, waitneasam nákarsatá. Auka, mash akiktatjame.” ");
INSERT INTO jivNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Uunt akupin waitnentar mash tsaṉkur aṉkant akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tura nú chichamaik nú takakmau jiinki ni ai̱n iṉkiuṉmai. Nú ai̱sha nin ishichik tumashiiyi. Tura tsékeṉki suwe̱nam achik chicharuk timiai “Wari akirkata tumashitmena nu.” ");
INSERT INTO jivNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tura ni ai̱ nin tikishmatar timiai “Waitneasam nákarsatá. Auka, mash akiktatjame” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Túrasha nakitramai. Antsu tsaṉkurtsuk sepunam eṉkeamai ashí akírkatí tusa. ");
INSERT INTO jivNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chíkich takakmau nuna wáinkiar ti kúntuts enentáimtuiniak uunt akupniun ashí etsertukarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nuna antuk uunt akupin untsuk itiá timiai “Yajauchiitme. ¿Winia “waitnentrurta” túrutkumin tsaṉkurachmakjam? ");
INSERT INTO jivNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Amesha núnismek ame ai̱m tsaṉkuratniuitme” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tinia uunt akupin kajekmai. Tura ashí tumashin akikmatsuk asutniati tusa suntarnum surukmai.” ");
INSERT INTO jivNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesus nuna áujmatas amúak tímiayi “Núnisaṉ winia Apar nayaimpiniam pujana nu atumin túrutmattarme atumi yachi̱ nekas enentáiji̱a̱i̱ tsaṉkureachkurminkia.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus nuna tinia ikiuak Kariréa nuṉkanmaya̱ wémiayi. Tura Jurtaṉ entsa amain Jutía nuṉkanam jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Untsurí̱ aents nemariarmiayi tura jáiniancha péṉker awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nui̱ Pariséu Jesusan nekapsataj tusar aniasarmiayi “¿Shuar ni nuwe̱n itiurchat akui ajapamniakait?” ");
INSERT INTO jivNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tutai Jesus tímiayi “¿Átumka Yus-Papí áujsachukaitrum? Yámankamtaik Yuska shuáran áishmaṉkan nuwa̱ncha najanamiayi tawai. ");
INSERT INTO jivNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tuma asamtai áishmaṉ ni aparí̱n ni nukurí̱n ikiuki ni nuwe̱ja̱i̱ tsaniṉ chikichik aya̱shtinia áinis ajasartatui, tu áarmaiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tuma asa jímiarcha antsu chikichik aya̱sh áiniawai. Tuma asamtai shuar Yus apatkamia nuna, aents akankashtiniaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Takui tiarmiayi “Nuikia ¿urukamtai papí áarar nuwa̱ ajapatniun Muisais tsaṉkatkamia?” ");
INSERT INTO jivNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tutai Jesus tiarmiayi “Timiá ántichu asakrumin nuwa̱ ajapatniun tsaṉkatkamiayi. Túrasha émkaka núnischauyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wi tájarme, shuar ni nuwe̱n chíkichja̱i̱ pujuschan ajapeakka tura chikichan nuatkuṉka tsanirmayi. Chíkich áishmaṉsha nuwa̱ ajapamun nuátkaṉka nusha tsanirmayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Takui ni unuiniamuri̱ tiarmiayi “Nuikia áishmaṉ ni nuwé̱ peṉké ikiukchamniaitkiuiṉkia nuátkachminiaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus tiarmiayi “Nu chichamnaka mash antukchamin áiniawai. Antsu Yus nuna umiktin susamua nuke antukmin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chíkich chíkich nuatkachmin áiniawai. Chíkich nuátkachmin akiiniawaru áiniawai. Chikichcha aentsja̱i̱ nuátkachmin najanaru áiniawai. Chikichcha nuátainiatsui Yus akupeamu takatan takastinian. Ju̱na antuktinian jeáka antukti.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nuyá Jesusan uchin itiariarmiayi. Nin antiṉ Yúsan áujtusarat tusar wakeriarmiayi. Túruiniakui ni unuiniamuri̱ chicharkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Túruiniakui Jesus tímiayi “Uchi Winí winitin tsaṉkatkatarum. Suritkiairap. Kame ju̱ uchia áintsaṉ péejchach áinian nunak Yus akupkamniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tinia uchin miniakas nuyá wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Shuar natsa Jesusan tarin aniasmiayi “Uuntá, péṉkeraitme. Tuma asam turuttia ¿warinia túrakna tuke iwiaaku átataj?’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tutai Jesus nin enentáimtikrataj tusa tímiayi “¿Urukamtai péṉkeraitme túrutam. Shuar péṉkerka atsatsuk. Aya Yúskechukait? Wats, tuke iwiaaku pujustaj tákumka akupkamu umírkartá.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tutai shuar “¿Tuna nekas umirkatniuitiaj?’ tímiayi. Takui Jesus tímiayi “Maṉkartuawaip, tsanirmawaip, kasámkáip, chíkich shuar tsanumpruraip, ");
INSERT INTO jivNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ame apa nukusha umírkatá, ame shuárum ame aya̱shim aneamna nútiksamek aneeta.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tutai natsa tímiayi “Núnaka úchichik mash umiki tsakaruitjai. Nuya̱sha ¿warí táatrusa?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Takui Jesus tímiayi “Nekas péṉker átaj tákumka, weme ame kuítrum kuítrincha ainia nu súsartá. Tura nayaimpiniam kuítrintin ajastatme. Nuyá Winia nemártústá” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tura natsa nuna antuk kúntuts wémiayi ti kuítrintin asa. ");
INSERT INTO jivNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nuyá Jesus ni unuiniamuri̱n tiarmiayi “Nekasan tájarme, kuítrintin Yus akupeamunam pachiinkiatin ti itiurchataiti. ");
INSERT INTO jivNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ataksha tájarme, kamiriuka kawái naṉkaamas uunt asa auja ji̱i̱n waya̱chminiaiti. Núnisaṉ kuítrintin Yus akupeamunam pachiinkiatin ti itiurchataiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ni unuiniamuri̱ nuna antukar antúu ajarmiayi. Túrawar aniniainiarmiayi “¿Nuikia yaki uwempramniait?” ");
INSERT INTO jivNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tuíniakui Jesus ashí íisar tímiayi “Aents uwempratniun nekas tujintiainiawai antsu Yuska ashí tujintiatsui.” ");
INSERT INTO jivNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nuyá Pítiur tímiayi “Uuntá, iikia ashí ikiukchajik Ámin nemarsatai tusar. ¿Wariṉ wáinkiattajⁱ iisha?” ");
INSERT INTO jivNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus tímiayi “Nekasan tájame, ukunmaṉka ju̱ nuṉka yamaram ajastatui. Aents Ajasu asan, Wisha nui̱, uunt akupin ajastatjai tura atumsha winia nemartusutirmeka Wiji̱a̱i̱ métek akupin ajastatrume ashí Israer-shuar akupkatin. ");
INSERT INTO jivNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tura shuar ni je̱e̱ncha, yachi̱ncha, umai̱ncha, aparí̱ncha, nukurí̱ncha, nuarí̱ncha, uchirí̱ncha, tura nuṉke̱ncha Winia anentu asa ikiukin wekaakka, nu shuar nii ikiukmia núnisaṉ yamaisha ti untsurí̱ wáinkiattawai tura ukunmasha tuke shiir pujustatui Yusja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Untsurí̱ yamái peṉkeri̱ áiniana nu ukunam ukunmaani pujusartatui, tura yapaji̱áwar yamái ukunmaya̱ áiniana nu ukunam emka pujusartatui’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Yus akupeamunam pachiinkiatin jú̱nisaiti. Nuṉka nérentin ni araamuri̱n júuktaj tusa káshik iniartaj tusa jí̱inkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chikichík tenariu kuit jean tsawant takamtsuk akiktajrume tusa chichas ni araamun júuktinian akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nantu takuntai̱sha ataksha jiinki shuar yujan wáiniak ");
INSERT INTO jivNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","timiai “Atumsha winia arakur júuktin yáintkiatarum. Shiir akiktajrume.” Tutai wearmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ataksha tutupin ai̱ nuyá áaṉkúsha jiinki, núnisaṉ tinia akupkarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ataksha nantu patamsai̱ jíinkimiai. Tura shuaran yujan wáiniak “¿Urukamtai takakmatskesha áani pujarum?” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Warí, iincha iniatmainiatsji” tiarmai.’ ‘Tuíniakui timiai “Atumsha winia nuṉkarui̱ takautarum. Péṉker akiktajrume.” ");
INSERT INTO jivNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Kirit ajátekiái̱ takatri̱n wáinniun timiai “Takatan takasaru untsukam akikiarta. Kíarai̱ naṉkamawaru emka akikiarta. Túram káshik naṉkamawaruja̱i̱ amuktá” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Takui nantu patamsa ai̱ naṉkamawaru waya̱warmatai chikichík tenariu kuit jean ashí akikiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mash umintramtai nuyá emka naṉkamawaru waya̱war “nuna naṉkaamas achikchatjiash” tu enentáimsarmai. Tura chikichík tenariu kuit jean achikiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Achikiar nérenniun itiurchat enentáimturarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tura tiarmai “Iikia ashí tsawant nantuja̱i̱ wáitsachjik. Ju̱ shuarsha nantu patamsa ai̱ naṉkamawaruka peṉké ishichik takasarai. Túrasha iiji̱a̱i̱ métek akikiarume” tiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tutai nérentin chikichkiniak iniakmas timiai “Umpá, peṉké kasartsujme. Káshik chikichík tenariu kuit jeá chichasar iiji̱a̱i̱ iwiarachjik, timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pai, ame kuítrum achikiume. Nantu patamsai̱ takasuncha amiji̱a̱i̱ métek akiktinian wakerajai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Warí, winia kuítruja̱i̱ wi wakeramun túrachminkaitiaj. Antsu wi tsaṉka asamtai ¿yajauch enentáimturmek?” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‘Núnisaiti Yus-shuarnum. Émkaru áinia nu uku ártatui. Tura ukuya̱ áiniana nu, emka ártatui. Untsurí̱ ipiaamu áiniawai tura ishichik achikma áiniawai.” Tu áujmatsamiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus Jerusaréṉnum jintiá wesa ni unuiniamuri̱n akankin tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Iistarum, Jerusaréṉnum wéaji. Nui̱sha Israer-patri úuntri̱n tura ni jintinniuri̱ncha Winia surutkartatui. Nui̱sha, wi Aents Ajasu ai̱ṉ, “mantamnati” túrutiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tura apachnium surutkartatui. Nui̱ katsekrukar, awattiar krúsnum máawarti tusar túrutawartatui. Túrasha jakayatan menaintiú tsawantai̱ nantaktiatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nuyá Jakupusha Juaṉsha, mai Sepetéu uchirí̱, nukurí̱ji̱a̱i̱ tariar Jesusan tikishmatrarmiayi. Tura nukurí̱ Jesusan waitnentrutrarat tusa seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“¿Warí wakeram?” tímiayi Jesus. Tutai nuwa̱ tímiayi “Ame uunt akupin ajastatmena nui̱ winia uchir chikichik untsuurnumaani chikichcha menaanmaani akupkarti tusam apujsarta.” ");
INSERT INTO jivNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Takui Jesus tiarmiayi “Atum seatrumna nu nékatsrume. ¿Wi wáitsattajna nuja̱i̱ métek túramniakaitrum? Wi wáitsatniun yapá umartinia áinis umartiniaitjai. Núnisaṉ wáitsatniuja̱i̱ imiaitniua áintsan imiantiniaitjai. ¿Nú piniṉnumia̱ umarminkiaitrum. Núnisaṉ imianminkiaitrum?” Tutai “Páchitskea” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tuíniakui Jesus tímiayi “Ayu. Winia piniṉkrui̱ya̱ umartatrume. Wi imiantiatjana nuja̱i̱ imiantiatrume. Antsu Wiji̱a̱i̱ tsaniṉkia pujustinniaka Wikia íischatniuitjai, antsu winia Apar iwiarturu áinia nuna nui̱ apujsattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chíkich tias (10) unuiniamuri̱ nuna antukar nu jímiaran kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Túmainiakui Jesus untsukar tiarmiayi “Ju̱ nékarme, apachniumka kapitián ajasar ni shuari̱n nérenniua áinis ti akupenawai. Ni úuntri̱sha waantu enentáimsar “wíitjai akupniun” tu enentáimtikiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Antsu atumja̱i̱ṉkia núnis áchatniuiti. Naṉkaamaku ajastaj tákuṉka chikicha yaintri̱ átiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ame kapitiántrum ajastaj tákuṉka ashí shuara yaintri̱ ajástí. ");
INSERT INTO jivNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wisha Aents Ajasuitiatan, Winia yáintkiarat tusan táchaitjai antsu shuáran yáiṉtaj tusan táwitjai. Untsurí̱ shuaran tunáa tumashri̱n akikmatkataj tusan jákatniuitjai. Nuna tarimjai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jirikiú péprunmaya̱ wénakui untsurí̱ aents Nin nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nui̱ jintiá yantam jímiar ji̱i̱ kusuru pujuarmiayi. Jesus wéawai taman antukar kakantar untsukarmiayi. “Uuntá, uunt akupin Tawitia Uchirí̱nchukaitiam. Waitnentrurta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tuíniakui “Takamatsatarum” tiarmiayi. Tútaisha nú naṉkaamas untsumkarmiayi. “Uuntá, Tawitia Uchiriá, waitnentrurta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tuíniakui Jesus wajas ji̱i̱ kusurun untsukar aniasarmiayi “¿Warí itiurtukat tusarum wakerutarum?” ");
INSERT INTO jivNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Uuntá, iimtiai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tuíniakui Jesus nin waitnentrar ni ji̱i̱n antiṉkiarmiayi. Nu chichamaik íimiar niisha Jesusan nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusaréṉnum nuntumsar Petpajái péprunam jeawarmiayi. Nusha Uriwiu náinnium ayamchiiyayi. Nui̱ jeawar Jesus ni unuiniamuri̱n jímiaran akupeak tímiayi ");
INSERT INTO jivNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Tíji̱uch péprunam wérum umpuuru umpuuruchiji̱a̱i̱ jiṉkiamu wáinkiattarme. Nu atiarum itartitiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tura aents “Urukamtai áitkiarum” túramkurminkia “Uunt wakerawai, tura wárik awaiṉkittiawai” titiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tura nusha yaunchu Yúsnan etserin aarmia nu umínkiatí tusa tímiayi. Jú̱nis áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ashí Israer-shuarnum ju̱ etserkatarum: “Iistarum, atumi Akupniuri̱, péejchach ajas umpuuruchiniam ekeemak winitramprume. Péejchach asa káarak áintstai umpuuru uchiri̱n ekeemak winitrámtatrume,” titiarum.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tutai nu jímiar unuiniamuri̱ wear Jesus timia núnisaṉ túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Umpuuruchin nukurtiuk itiarmiayi. Tura ni pushiri̱n áitkiaram Jesus entsamkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Shuar untsurí̱ ásar ni wéamunam pushiri̱n áitkiarmiayi. Chikichcha nuká jurukar ni wéamunam áeprurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Shuar untsurí̱ eem wearmia nusha tura uku winiarmia nusha kakantar untsumiarmiayi. “Ju̱na we̱a̱tri̱ uunt akupin Tawit asamtai naṉkaamakuiti. Yusa náari̱i̱n winiana ju̱ ii Uuntri̱nti. Shiir atí. Nayaimpinmasha Yus shiir awajsatai.” Tu untsumiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus Jerusaréṉnum waya̱mtai ashí shuar ti enentáimainiak “¿Ju̱sha yait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chikichcha “Yúsnan etserin Jesusaiti, tiarmiayi. Nasarét pepru Kariréa nuṉkanmaya̱iti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nuyá Jesus Yusa Uunt Je̱e̱n wayá kuítian súruiniak tura súmainiak pujan akúprámiayi. Kuítian yapaji̱nia misari̱ncha ayanturmiayi tura yampitsa súruinia kutaṉkri̱ncha núnisaṉ ayanturmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nuyá tímiayi “Yus-Papinium áarchamukait, “Yusa Je̱e̱nka Yus aujtai jé̱a̱iti.” Antsu átumka kasa matsamtai̱ya nútikiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nui̱ Yusa Je̱e̱n ji̱i̱ kusurarusha shutuapsha Jesusan tariarmiayi. Túramtai tsuárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tura Israer-shuar pátrisha tura Israer-shuara jintinniuri̱sha aents tujintiamun Jesus túrakui íisar kajerkarmiayi. Nu arantcha uchi Yusa Je̱e̱n “Ju̱na we̱a̱tri̱ uunt akupin Tawit asamtai naṉkaamakuiti” untsumainiakui Jesusan ti kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tura tiarmiayi “¿Ju̱ uchi tuinia nu ántamek?” Tutai Jesus “Ee, ántajai, tímiayi. Átumka Yus-Papí ju̱na tana ju̱ka áujsachukaitrum. Jú̱nis tawai, “Uchisha kuírchisha Yusa náari̱n imiá shiir awajtusarat tusa Yus tsaṉkatkaiti.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nuna tinia ikiuiniak Jerusaréṉnumia̱ jiinki Petania péprunam we nui̱ kanarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kashin tsawa̱a̱r Jerusaréṉnum waketas Jesus tsukaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iikiu numi jintiá yantam wajan wáiniak akaktajtsa werimiayi. Tura werí aya núminiak wáinkiamiayi. Túra numin tímiayi “Atakka nerekchattame.” Takui nu chichamaik káarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nuna wáiniak ni unuiniamuri̱ ti enentáimprar aniasarmiayi “¿Urukaku imiá wárik jaka?” ");
INSERT INTO jivNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tuíniakui Jesus tiarmiayi “Nekasan tájarme, Yus nekas enentáimtakrumka, “nekaspash túrat” táchakrum iikiun túrajna nusha túramniaitrume. Tura nu arantcha nu naint “Ékemtam nayaantsanam iniaṉta” tutai túrunattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ashí Yus áujeakum seamna nu, Yus nekas enentáimtakum seakmeka, wáinkiáttame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yusa Uunt Je̱e̱n Jesus wayá unuiniamiayi. Turai̱ Israer-patri uuntri̱ tura Israer-shuara úuntri̱sha Jesusan tariar aniasarmiayi “¿Yana chichame̱ja̱i̱ ju̱ túram. Ya ju̱ túratniuncha akuptamkait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tutai Jesus tiarmiayi “Wisha aniastaj tusan wakerajrume. Ju̱ ái̱rkakrumniṉkia Wisha yana chichame̱ja̱i̱ túraj nuna ujaktatjarme. ");
INSERT INTO jivNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wats, ¿ya imiakratin Juaṉkan akupkamia. Yusak, aentsuk, ya akupkamia?” Tutai nuámtak tunainiarmiayi. “Yus akupkamiayi” tákurniṉkia “¿urukamtai enentáimtichuitrum?” túramtatji. ");
INSERT INTO jivNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kame “shuar akupkaiti” tákurnisha ashí aents mantamattaji. Warí, ashí niisha Juaṉ Yúsnan etserniuyi tuíniatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nuyá Jesusan “Nékatsji” tiarmiayi. Tutai Jesussha aí̱i̱niak “Wátsek, Wisha núnisnak akuptukua nuna ujakchattajrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus unuiniak tiarmiayi “Enentáimpratarum. Shuar uchin jímiaran takakuuyi. Nuna chikichkin chicharuk timiai “Uchirú, arakur júuktin yamái wetá.” ");
INSERT INTO jivNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Tutai uchi “Atsá, nakitiajai” timiai. Tayat urum enentáimiar takaumai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‘Nuyá aparí̱ chikichnasha werí núnisaṉ timiai.’ ‘Tutai uchi “Apawa, páchitsuk wetajai” timiai, túrasha wéchamai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‘¿Túa ni aparí̱ wakeramun umirkama?” tímiayi Jesus. Tutai “Emkaa nu” tiarmiayi. Tuíniakui Jesus tímiayi “Nekasan tájarme, yajauch shuar ainia nu tura tsanirma ainia nusha átumka pachiintsrumniṉ nii emka Yus akupeamunam pachiinkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iis, imiakratin Juaṉ péṉker wekasatniun etserkamiayi, túrasha antukchamarme. Antsu yajauch shuar ainia nu tura tsanirma ainia nu umirkarmiayi. Nusha wáinkiaitiatrum atumi tunaari̱ enentáimturchamarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Ju̱ chíkich áujmatmasha antuktarum. Nuṉká nérentin uwa ajan ajammai. Tura wenuimiai. Uwa neketaincha najanamai. Kumpin je̱a̱ncha najanamai. Tura mash péṉker iwiar shuar wáitrukarti tusa apujkimiai. Tura niṉkia yajá nuṉkanam wemai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tura júuktin tsawant jeamtai juuk nakak akúptúrkartí tusa chíkich takarniuri̱ akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tura nui̱ pujuinia nu, akupkamun achikiar chikichnaka katsumkar, chikichnasha máawar, chikichnasha kayaja̱i̱ tukurar máawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Túrawarmatai nérentin takarniun nuna naṉkaamas akupramai. Ataksha nui̱ pujuarmia nu núnisaṉ túrawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Amúamunam ni uchirí̱n akupeak “Winia uchir asamtai umirkachartimpiash” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Túrasha nu takau nérenniu uchirí̱n wáinkiar “Nuna aparí̱ jakamtai ju̱na mashi júkishtatuak, tiarmai. Maatai, túrar ii nérentin ajastai” tiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tiar achikiar arant júkiar nui̱ máawarmai.” ");
INSERT INTO jivNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tinia Jesus aniasarmiayi “Nuṉká nérenniuri̱ taa nu takaun ¿itiurkatiṉ?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tutai tiarmiayi “Nu shuar ti yajauch ásarmatai waitnentsuk máawartatui. Tura nu ajan chíkich takaun neren akanak nin susamnia nuna apujsattawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tuíniakui Jesus tímiayi “Átumka Yus-Papikia ¿peṉkek áujchaitrum? Jú̱nis áarmaiti: “Je̱a̱ jeamin utsaṉkarmia nú kaya ashí kayaja̱i̱ naṉkaamas apujsamuiti. Núnaka ii Uuntri̱ Yus túraiti. Iisha íisar ti enentáimtaji.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tuma asamtai tájarme, Yusna írunna nu wáinkiatárum tusa suramsamuitiat atumíya̱ junas chíkich aents súnastatui. Niisha awaṉtukiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tura shuar nu kayan tukumainia nuka kupintrartatui. Tura nu kaya shuarnum iniarka tsai tsai awajsattawai auka” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Israer-patri uuntri̱sha Pariséusha Jesus áujmatman antukar “in túramji” tusar achiktaj tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tura ashí aents “Jesus Yúsnan étserui” tuinia ásarmatai nin ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus ataksha áujmatuk ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yus akupeamunam pachiinkiartin jú̱nis enentáimpramniaiti. Uunt akupin ni uchirí̱ nuáteakui nampermamai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Túrak ni takarniuri̱n ipiaamautarum tusa akupkarmai. Tura ipiaamusha nakitrarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ataksha chíkich takarniuncha ipiaamakrum ju̱ titiarum tusa akupkarmai. ““Mash yurumkan iwiarajai, tawai, titiarum, timiai. “Waakasha máatarum tusan akupkarjai, tawai. Ajaermancha máatarum tusan akupkajai, tawai. Ashí nuatnaiyamunam winiarti,” tawai” titiarum” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Támaitiat nú ipiaamusha nakitrarmai. Chikichik ni nuṉken wemai. Chikichcha kuítian suruktinian wemai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chikichcha ipiaakratniun achikiar yajauch awajsarmai, tura chikichnaka máawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Túramtai uunt akupin ti kajek, ni suntari̱ mash máatarum túrarum ni je̱e̱ mash ekeemáktárum tusa akupkarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nuyá ataksha ni takarniuri̱n akupkamai. “Nuatnaikiatin jísat mash iwiaramuiti, timiai. Tura nu ipiaamu winichmin armai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tuma asamtai pepru jintí werum ashí shuar náṉkamas wáintrum nu ipiaatarum” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Takui takarniuri̱ jíinkiar pepru jinti̱n wajainian, yajauch shuarnasha péṉker shuarnasha, ashí ipiaawarmai. Túramtai je̱a̱ piákmai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Nuyá uunt akupin ipiaamun íisartaj tusa waya̱mai. Nui̱ shuaran péṉker iwiarmamprachun wáinkiamai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tura timiai “Umpá, ¿urukamtai nuatnaiyamunam entsatai pushí entsatsuk waya̱m?” Tutai nu áishmaṉ tákamtak pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nuyá uunt akupin yurumka ajaaman timiai “Achikrum nawenmasha uwejnumsha jiṉkiarum a̱a̱ jí̱i̱krum kiritniunam ajapatarum. Nui̱sha ti úutin ti wáitsatin átatui” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kame untsurí̱ ipiaamu áiniawai antsu ishichik achikma áiniawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nuyá Pariséu chichaman najatawar uyu̱mtikiatai tusar tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Túrawar ni shuari̱ncha tura akupin Erutisa nemarniuri̱sha Jesusan akuptukarmiayi. Kame akupin Erutis uunt akupin Sésara kuitri̱ wáinin asamtai nu apachniasha akupkarmiayi. Niisha jeariar Jesusan tiarmiayi “Uuntá, amesha nekas chicham chichaame. Nu nékaji. Chíkich shuar tuinia nu ántutsuk nekasam Yus-Chicham jintíame. Shuar shiir enentáimturarat tusam jintíatsme, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tuma asamtai ju̱ nekaatai tusar wakeraji. ¿Uunt akupin Sésar akikminkiait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus ni yajauch enentáiji̱a̱i̱ aníam nekáa tiarmiayi “Aya shiir chichamtiniaitrume. ¿Urukamtai uyu̱matkiarkatin wakerutarum? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wats, Sésar akiktinia nú kuit itiartitiarum.” Takui chikichik kuítian itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nuna iis Jesus aniasarmiayi “¿Ju̱i̱ yana yapimpiait tura yana naari̱ áarmait?” ");
INSERT INTO jivNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tutai “Uunt Sésarna” tiarmiayi. Tuiniakui Jesus chicharuk tiarmiayi “Nuikia uunt Sésarna nu, Sésar susatarum. Tura Yusna nusha Yus susatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tura nuna antukar ti enentáimprarmiayi. Tura ikiuiniak wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nu tsawantai̱k Satuséusha Jesusan tariarmiayi. Satuséuka jakamunmaya̱ nantakchatniuiti tuíniawai. Nuna tiniu ásar ju̱na Jesusja̱i̱ áujmatsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Uuntá, Muisais ju̱na áartampramiaji, “áishmaṉ uchin yajutmatsuk jakamtaiṉkia ni yachi̱ nu nuwa̱n nuatak ni yachin yajútmátrati,” tu áarmiayi, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ayu, íi shuarnum siati (7) yáchintin ármiayi. Iwiai̱ri nuatak uchin yajutmatsuk jakamiayi. Tura waje̱n ni yachin ikiurkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tura niisha nuatak uchin yajutmatsuk jakamiayi. Tura chikichcha núnisaṉ jakamiayi. Tura chikichcha siati armia nu ashí nuatkar jákarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nuyá nuwa̱sha jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jakamunmaya̱ nantakiar ¿yaki nekas ni aishri̱ ati? Ashí nin nuatkacharmakia” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tuíniakui Jesus tímiayi “Yus-Chichamsha nékachkuram tura Yusa kakarmari̱sha nékachkuram nantaktin atsawai tákuram ti awajiarme. ");
INSERT INTO jivNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nekaatarum. Jakamunmaya̱ nantakiaruka nuatkachartatui. Antsu Yusa suntari̱ nayaimpiniam pujuinia núnisar nuartichu pujusartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Túrasha jakamunmaya̱ nantakiartatna nu nekaatajtsa wakerakrumka ju̱ enentáimsatarum. Muisais aarma nu áujsachukaitrum. Jú̱nisaṉ áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Wiitjai Apraáma Yúsrintjai, Isaka Yúsrintjai, Jakupu Yúsrintjai.” Tu áarmiayi. Watsek, Yuska jaká Yúsri̱nchuiti. Antsu iwiaaku ana nuna Yúsri̱nti, tímiayi. Iis, nu shuar imiá yaunchu jákaruitiat Yusja̱i̱ iwiaaku pujuiniak nantakmin áiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ashí aents nuna antukar nu jintintiam ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Satuséu Jesusan ai̱ktinian tujinkiarmatai Pariséu nuna antukar iruntrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tura chikichik Pariséu jintintin asa Jesusan uyu̱mtikiataj tusa aniasmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Uuntá, ¿túa Yus akupkamu imiá naṉkaamas enentáimtustiniait?” ");
INSERT INTO jivNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tutai Jesus tímiayi “Jú̱iti: “Ame Yúsrum ashí enentáimja̱i̱ aneeta. Ashí ame wakanmiji̱a̱i̱sha tura tuke enentáimtusam aneeta.” Tu áarmaiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Núiti emka ashí akupkamu naṉkaamas enentáimtustinia nu. ");
INSERT INTO jivNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chikichcha ju̱ja̱i̱ métek-taku awai. Nusha tawai: “Ame írutramuram ame aya̱shim aneamna nútiksamek aneata.” ");
INSERT INTO jivNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nu jímiar akupkamu umirkam ashí Muisais akupkamia nusha tura ashí Yúsnan etserin unuiniararmia nusha umirkattame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tura Pariséu tuke irunar pujuiniakui ");
INSERT INTO jivNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesussha aniasarmiayi “Kristu tutai ¿ya weeá átiniait. Warí enentáimtarum atumsha?” Takui “Tawit weeá átiniaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tuíniakui Jesus tiarmiayi “Nuikia ¿urukamtai Tawit, Yusa Wakaní “titia” tutai, Krístun “winia Úuntur” tímia? Iis, Tawit ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Uunt Yus winia Úuntrun ju̱na tímiayi: “Akupin pujutainium, winia untsuuruini̱, pujusam nákarsata. Ashí ame nemasrumin nupetkan Ámin umirtamkarti tusan amastatjai” tímiayi Yus.” Tu tímiayi Tawit. ");
INSERT INTO jivNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Watsek, Tawit Krístun “winia Úuntur” tai̱sha ¿itiurak ni pampaṉmari̱ áti?” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nuna takui peṉkesha ái̱kcharmiayi. Túrawar atakka uyu̱mamtikiatai tusar aniascharmiayi Jesusan. ");
INSERT INTO jivNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesus ni unuiniamuri̱ncha tura ashí shuárnasha tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Israer-shuara jintinniuri̱sha tura Pariséusha Muisais akupkamun paant ujatmainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tuma asamtai tuinia nu umirkatarum. Túrasha ni túruinia nu jumamkiirap. Nu shuar shiir chichainiayat nusháa túrin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ti itiurchat ana nuna akupeenak ti emeram entsaktinia áintsaṉ áentsun apujtuiniawai. Túrasha chikichik uwe̱jé̱ja̱i̱sha ishichkisha takuitniun nakitiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aya shuar íirsarti tusar ashí túruiniawai. Ashí shuar péṉker enentáimturarti tusar Yus-Papin nijiai̱ncha tura kunturi̱ncha ti waṉkaram awajsar anujak yujainiawai. Tura nu arantcha pushiri̱ sasariarman ashí shuarja̱i̱ naṉkaamas esaram awajas wekainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nampernumsha péṉker iwiaramunam pujustinian wakeruiniawai. Iruntainmasha naṉkaamantu ajasa pujustinian wakeruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jintiá wekainiaksha ashí aents áujtuiniak “Jintínkiartiniá” turutiarti tusa wakeruiniawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Túrasha átumka ashí shuar “Jintínkiartiniá” turutiarti tusa enentáimsashtiniaitrume. Átumka nuámtak yáchintrume. Átumka chikichik jintinkiartin ni naari̱ Kristu takakrume. Nu asamtai “Jintínkiartiniá” túramcharmin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ju̱ nuṉkanmasha shuar “Aparú” tiirap. Chikichik nayaimpiniam pujana nu atumí Aparí̱nti. ");
INSERT INTO jivNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atumi uuntri̱ aya Krístuk asamtai “Uuntrú” túramcharmin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Antsu átum írutkamunmaya̱ uunta nuka peejchach átiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Shuar naṉkaamantu ajastaj tákuiṉkia Yus nin péejchach awajsattawai. Antsu péejchach ana nuna Yus nin naṉkaamaku awajsattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Maa wáinkiatárum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Yus akupeamunam waya̱tin waiti epenniuitrume. Atumsha waya̱tsuk chikichcha waya̱taj tuinia nusha suritniuitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘Maa wáinkiatárum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Wajé̱ je̱e̱ atankiirum aents enentáimturara̱i̱ṉ tusarum ti esaram Yus áujtiniaitrume. Túrin asarum átum ti asutniátniuitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘Maa wáinkiatárum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Nuṉkanmasha nayaantsanmasha yajá wekainiuitrume chikichík shuar winí nemartusat tusarum. Tura atumi nemari̱ ajasmatai atumja̱i̱ naṉkaamas tunáa sumamamnia awajearme.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Wáinkiatárum átumka. Jintinkiartiniaitiatrum nékachu asarum kusurua áiniuitrume. Ju̱ jintíarme: “Shuar nekasan tajai tusa Yusa Je̱e̱n páchiakka nii tana nuna umitsuk ikiukminiaiti. Antsu nekasan tajai tusa Yusa Je̱e̱n kuri ana nuna páchiakka ti nekas umiktiniaiti” tíniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nétsetrume. Yúsja̱i̱ṉkia ashí kuri ántrachukait. Antsu Yusa Je̱e̱n írunna nuka aya nuiṉ ikiusma asa Yusna ajasuiti. Tuma asamtai kuriji̱a̱i̱ naṉkaamas Yusa Je̱e̱ enentáimtustiniaiti. Enentáimcha asarum kusurua áinin wáakuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nu arantcha tíniuitrume: “Shuar nekasan tajai tusa namaṉ-maar-Yus-sútain páchiakka nii tana nuna umitsuk ikiukminiaiti. Antsu Yús-sutainiam namaṉ patasman páchiakka ti nekas umiktiniaiti” tíniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nétsetrume. Peṉké namaṉ Yusja̱i̱ ántrachukait. Aya Yús-sutainiam patasma asa nu namaṉ enentáimtuschatniukait. Enentáimcha asarum kusurua áinin wáakuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Enentáimpratarum. Shuar nekasan tajai tusa Yús-sutain páchiakka aya sútainiak páchiatsui antsu sutaincha tura nui̱ patasmancha mái-metek páchiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Núnisaṉ shuar Yusa Je̱e̱n páchiakka aya nunak páchiatsui antsu Yus nu je̱a̱nam pujú asamtai nunasha páchiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Núnisaṉ shuar nayaimpin páchiakka Yus pujutainchsetrume. Peṉké namaṉ Yusja̱i̱ ántrachukait. Aya Yúa tura Yus nui̱ pujana nunasha páchiawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Maa wáinkiatarum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Kumintsu nuke̱sha, anisa nuke̱sha, menta nuke̱sha tias (10) akantram chikichik akankamu Yus súwitrume. Nuka péṉkeraiti, ikiukchatniuiti. Túramaitiat nekas péṉker túratniua nu túrutsuk ikiuwitrume. Yus nekas enentáimtustincha, waitnentáimturtincha tura tuke péṉker túratniusha enentáimtsuk ikiuwitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Átumka jintinkiartiniaitiatrum nékachu asarum kusuru áiniuitrume. Kutanam yajasmach eṉketu wáinkiurmeka júwitrume. Túrayatrum kamiriu wáinkiurmeka kawai naṉkaamas úunt aiṉ takamtsuk kú̱jawitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Maa wáinkiatarum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Átumka tsapasha piniṉsha initiaani̱ nijiatsuk aya pátatek nijiawitrume. Núnisrum pátatek shiir awajmamniuitrume tura enentáiminkia kasamkatniusha tura chíkichna wakeruktincha nuja̱i̱ piákuitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kusuru áiniuitrume, Pariséutirmeá. Antsu emka initiaani̱ tsapasha piniṉsha nijiaktarum. Túrakrumniṉkia pátatkesha mai péṉker átatui. Núnisrum atumsha atumi enentái̱n ana nu shiir awajsarum pátatkesha shiir átatrume.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘Maa wáinkiatarum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Iwiarsamu pújuja̱i̱ yakarar shiir awajsamua áiniuitrume. Aani̱ shiir áiniawai. Tura initkia jaká ukunchi̱ji̱a̱i̱ piákuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Núnisaitrume atumsha. Chíkich shuar íismaka ti shiira áiniuitrume. Túrasha atumi enentái̱nkia ashí mui̱jmiai piákuiti.’ ");
INSERT INTO jivNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Maa wáinkiatarum jintinniutirmesha, Pariséutirmesha. Ántrarum shiir chichamtiniaitrume. Yaunchu Yúsnan etserin iwiarsamunam átumka shiir enentáimtakrum je̱a̱ jeamkaitrume. Tura péṉker shuar yaunchu jákarusha shiir enentáimturtaj tusarum ni iwiarsamu shiir awajearme. ");
INSERT INTO jivNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Túrakrum ju̱ tíniuitrume: “Iikia yaunchu ii we̱a̱tri̱ji̱a̱i̱ pujaitkiurkia Yúsnan etserin máatin yáimkiacha̱a̱ji.” ");
INSERT INTO jivNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nuja̱i̱ ti paant chichaarme atumsha. “Ii we̱a̱tri̱ Yúsnan etserniun máawar tunáa túrin ármiayi” tárume. Tura “Yáimkiacha̱a̱ji” táyatrum, atumsha métek túrin asarum “Niiji̱a̱i̱ méteketji” tárume. ");
INSERT INTO jivNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wats, atumi we̱a̱tri̱ naṉkamawarmia nu átum amuktatrume’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Napia áiniuitrume. Shuar aya yajauch awajniuitrume. Túmatirmesha Yus tunáa shuaran jinium akupkartatna nuya̱ ¿itiurak uwempratarum? ");
INSERT INTO jivNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Untsurí̱ shuaran akuptuktatjarme. Yúsnan etserniuncha, ti nekancha, jintinkiartinniasha akuptuktatjarme. Tura atumsha chíkich máattarme, chikichcha krúsnum ajintruarum máattarme, chikichcha iruntai je̱a̱nam asutiáttarme, tura chikichcha ashí nuṉkanam áintrattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nu tura asarum péṉker shuara numpé̱ puarma nuja̱i̱ átum sumamattarme. Yámankamtaik Apir ti peṉker shuáraitiat máamuyayi. Tura ukunam Perekíasa uchirí̱ Sakarías atumi uuntri̱ Yusa Je̱e̱ ámanum namaṉ-maar-Yús-sutai ajapén aténkamunam máawarmiayi. Wats, Apir máamunmaya̱ Sakarías máamunam ashí péṉker shuar ti untsurí̱ máamuja̱i̱ sumamattarme. ");
INSERT INTO jivNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nekasan tájarme, yamái pujuinia nú shuar ashí nuja̱i̱ sumamawartatui’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘Jerusaréṉnumia̱tirmeá, Yúsnan etserin máiniaitrume. Yus akatar akupturmakmasha kayaja̱i̱ tukuram máiniaitrume. Túrin árumniṉ waitnentajrume. Atash ni uchiri̱n weaana áitkiasnak weartinian wakerimjarme, tura nakitramarme. ");
INSERT INTO jivNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iistarum. Ame pépruram ajapamuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tura “Yusa náari̱i̱n winiana nu, shiir atí” títiatrumna nu tsawant jeatsa̱i̱ṉ peṉké wáitkiashtatrume. Nuna tájarme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus Yusa Uunt Je̱e̱nia̱ jiinki weai̱ ni unuiniamuri̱ nin tariar Je̱a̱n iniaktusar áujmatsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tura Jesus tiarmiayi “Nu mash yamái wáintrume. Tura nekasan tájarme ukunmaṉka mash saanaktiatui. Chikichík kayaksha ekentramuri̱ atsuttawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nuyá Uriwiu náinnium wear niṉki nui̱ pujusar ni unuiniamuri̱ Jesusan aniasarmiayi “¿Nusha urutaik túrunatⁱ. Tura ame tátincha tura nuṉka amuukatin tsawant jeakuisha wariji̱a̱i̱ṉ nekaattajⁱ? Nu ujatkata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tuíniakui Jesus tímiayi “Aneartarum, anaṉkramawairap. ");
INSERT INTO jivNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Untsurí̱ shuar winia náarun pachisar “wi Krístuitjai” tiar untsurí̱ shuaran anaṉkawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti untsurí̱ meset chicham antuktatrume túrasha sapijmiakairap. Núnisaṉ átiniaiti nuṉka amúatsa̱i̱ṉ. ");
INSERT INTO jivNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Apachcha chíkich nuṉkanmaya̱ apachja̱i̱ máaniawartatui. Tura ti tsukasha átatui. Suṉkursha ti pampartatui. U̱u̱sha ti u̱u̱rkartatui. Nuka untsurí̱ nuṉkanam ashí túrunawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nuja̱i̱ ti wáitsatin aya yama naṉkamui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Nuyá atumniasha yajauch awajsarti tusa surutmakartatui. Tura mantamawartatui. Tura winia naar pachia asakrumin ashí shuar muíjramkartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nu tsawantai̱ untsurí̱ shuar Yúsan iniaisartatui. Túrawar nuamtak muíjniainiak surunairartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Untsurí̱ shuar wáitruiniak “wi Yúsnan etserniuitjai” tiartatui. Túrawar untsurí̱ shuáran nusháa enentáimtikrartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tura tunáa ti ákui nuamtak anenaichartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tura shuar ashí nuna tuke katsuntra nu uwemprattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ashí aents nekaawarat tusa Yus-Chicham ashí nuṉkanam etsernaktatui. Túramtai amuukatin tsawant jeattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Shuar ju̱na áujea nu enentáimprati. Kame Jesus tímiayi “Yúsnan etserin Taniar muijmiamtik tuke emesratin ana nuna yaunchu aar etserkamiayi. Nuka Yusa Je̱e̱n wantinkiamtai ");
INSERT INTO jivNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ashí shuar Jutía nuṉkanam írunna nu, muranam pisararti. ");
INSERT INTO jivNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","18","Ti wárik pisartin asamtai shuar je̱a̱ yakí pujaksha tura shuar ajanam wekaakusha je̱á waketki wariri̱ jukitiaj tíchati. Antsu nuya̱ṉ wárik pisarti. ");
INSERT INTO jivNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nu tsawantai̱ nuwa̱ ajamtincha tura kuírchin takaku ainia nusha ti wáitsartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ayampratin tsawantai̱sha tura michá nántutincha nu pisartin tsawant áchati tusarum Yus seatarum. ");
INSERT INTO jivNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maa, nu tsawantai̱ ti wáitsatin átatui. Ti yáunchusha núnisaṉ wáitsatin atsuuyayi. Ukunmasha atsuttawai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nu wáitsatin ti esarmaitkiuiṉkia chikichkísha uwemprachainti. Tura Yus nu wáitsatniun wárik amumtikiattawai. Shuar Niiniu ajasarat tusa achikma ainia nu uwemprarat tusa wárik amumtikiattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Tura atumin “Jú̱iti Kristu,” tuíniakuisha tura “Nui̱ pujawai” tuíniakuisha anturkairap. ");
INSERT INTO jivNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Untsurí̱ shuar Krístuitjai tusar wantinkiartatui. Untsurí̱sha “Yúsnan etserniuitjai” tiartatui. Tura shuáran anaṉkataj tusar aents tujintiamun iniakmasartatui. Tura ti kakarman túruiniak Yús-shuarnasha anaṉkamin áiniakuiṉkia anaṉkawarainti. ");
INSERT INTO jivNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Túrunatsa̱i̱ṉ nuna emka ujaajrume. ");
INSERT INTO jivNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tuma asamtai “Iis, Kristu nui̱ aents atsamunam pujawai” túramainiakuisha nui̱ wéerap. “Ju̱i̱ ú̱u̱mak pujawai” tuíniakuisha anturkairap. ");
INSERT INTO jivNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Núnisaṉ ú̱u̱mkan táchattajai. Pe̱e̱m pé̱e̱tuk ti wárik ashí nuṉkanam wáinkiachminkiait. Núnisnak wi Aents Ajasuka winiakun paant wantinkiattajai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wats, jaka tepaana nui̱ chuaṉ káutkachartatuak’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Ti wáitsatin naṉkaamasmatai ti wárik tsawái̱ nantu kajinkiattawai. Tura kashí nantusha etsantrashtatui. Yaasha ashí muchitrattawai. Nayaimpiniam kakaram ainia nusha peantrartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nui̱kia Wi Aents Ajasuka, tátiniur paant átatui. Tura ashí nuṉkanmaya̱ aents Wi winiái̱ wáitkiar asuttiamattaji tusar úutiartatui. Wisha ti kakaram tura Yusa winchari̱ji̱a̱i̱ yuraṉminiam winiái̱ wáitkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yusa suntari̱n kachu kakaram umpuartarum tinia akupkamtai nu suntar ashí nuṉkanmaya̱ ashí Yús-shuaran, Yus achikma ásarmatai, irurartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Iikiu numiri̱ nakumea nu nekaatarum. Ni nuke̱n eteakui “esat nantu jeatemayi” tátsurmek. ");
INSERT INTO jivNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Núnisaṉ ashí ju̱ wáinkiurmeka “amuukatin tsawant nekas jeatemayi” títiniaitrume. ");
INSERT INTO jivNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nekasan tájarme, yamái aents pujuinia nu amúatsa̱i̱ṉ ashí túrunattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nuṉkasha nayaimpisha amuukartatui antsu winia chichamur amuukashtatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Tura nu túrunatin tsawant nekanachminiaiti. Yusa suntari̱sha nékainiatsui. Wisha Yusa Uchirí̱ntiatnak nékatsjai. Antsu aya winia Aparuk nékawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Wi tátiniur jeamtai yaunchu Nuai pujumia nú tsawantin túrunamia núnisaṉ átatui. ");
INSERT INTO jivNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nu tsawantin, tuke amaartsa̱i̱ṉ, aya jú̱nisaṉ aa asamtai yurumuk umarar pujuarmiayi. Nuatnainiarmiayi. Ni nawantri̱ncha nuatmamtikiarmiayi. Tura tumá pujuiniai̱ Nuai uunt kanunam eṉkemamtai ");
INSERT INTO jivNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nu aents tuke nékainiatsa̱i̱ṉ ama amaarak mash amuukarmiayi. Núnisaṉ átatui Wi tátin jeamtai̱. ");
INSERT INTO jivNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nu tswantai̱k jimiará shuar ajanam pujuttawai. Chikichik junaktiatui tura chíkichkia ikiunkittiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Núnisaṉ jimiará nuwa̱ shana neke̱ak pujuttawai. Chikichik junaktiatui chikichcha ikiunkittiawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Nu asamtai atumsha iwiarnarum pujustarum. Nekaachminiaiti uruk ái̱ntsuk taritjiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","44","Tuma asamtai aneara pujustarum. Wi nekaachmanum tátin jú̱nisaṉ enentáimpramniaiti. Shuar ju̱ kashi kasa tátinian nekaaṉka kánutsuk kasa táawai̱ tusa iwiarnar nákasainti. Núnisrum aneara pujutarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Shuar péṉker uminian tura péṉker enentáimniun áujmatsattajai. Nuna uuntri̱ yajá irauweak “Yurumátin jeamtai winia takartin ayuratarum” tíchanpiash. ");
INSERT INTO jivNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nu takamtikniuncha ni uuntri̱ taa takatri̱n tímiatrusaṉ túran tariṉkia shiir enentáimtusainti. ");
INSERT INTO jivNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nekasan tájame, umin asamtai ni uuntri̱ ashí ni wariri̱n wáitrúkat tusa takatan susattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Antsu úuntur wau táchattawai tusa takamtikin ni uuntri̱ yáintri̱n yajauch awajeak tura takatsuk aya yurumátniun tura nampektinian wararkuṉka nu takamtikin yajauchiiti. ");
INSERT INTO jivNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Turai̱ ni uuntri̱ aya aneachma taa nu takamtikniun, yajauch asamtai, ");
INSERT INTO jivNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ti kakaram asutiattawai. Yajauch shuar pujuinia nui̱ akupkattawai. Nui̱sha ti wáitiak ti úuttiatui’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Yus akupeamunam pachiinkiatin jú̱nis átatui. Nuatnaikiatin jísat akui tias nuwa̱ natsa kantiran akaawar nuátkattana nu áishmaṉkan iṉkiuṉ je̱á itiatai tusar wearmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Seṉku nuwa̱ enentáimcha armai. Tura chíkich seṉku nuwa̱ enentáimin armai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Enentáimcha arma nú nuwa̱ aya akaamunak juíniak amuukamtai yaraatniun asuitin júkicharmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Antsu chíkich seṉku núwa̱ka akaamuncha juíniak tura ataksha amuukamtai yaraatniun asuitin júkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tura jíinkiarmatai nuatkatin áishmaṉ wari taachkui kari̱ pujakui kanararmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nuyá kashi ajapéṉ shuar untsumuk “Pai nuatkatin winiawai. Werirum iṉkiuṉtarum” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tu untsumun antukar nantakiar kantiran akaatai tusar pujursarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nuyá seṉku nuwa̱ enentáimcha arma nu, chíkich nuwa̱ enentáimniun tiarmai “Incha atumi asuitiri̱ ishichik ajamprusaitia. Ii kantiri̱sha kajiniawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Tutai chíkich seṉku nuwa̱ tiarmai “Atsá, warí íncha jeartamchattaji. Tura atumnia peṉké jeashtatui. Nekaska surutainium werum sumaka utumtarum” tiarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Tura nuyá seṉku nuwa̱ enentáimcha arma nu, asuitian sumak utitiai tusar wéarai̱ ukunam nuatkatin áishmaṉ tamai. Túramtai enentáimin nuwa̱ arma nuka nuatnaikiatin námpernam nuatkatniuja̱i̱ waya̱warmai. Túramtai wáitin epeniarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tura epeniarai̱ enentáimcha nu táarmai. Tura tiarmai “Úuntá, waiti uratritia.” ");
INSERT INTO jivNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Tu untsumainiakui nu uunt kajerak chichak “Cha, ¿yátsukaitrum? Peṉké nékatsjarme” tiarmai.” ");
INSERT INTO jivNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesus nuna áujmatas umik tímiayi “Aents Ajasuitjai tura tátin tsawantrusha tura uruk aiṉ tátaj nusha nékatsrume. Tuma asarum tuke iwiarnarum pujustarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Núnisan Wi tátin jú̱nisaiti. Shuar chíkich nuṉkanam wéakᵤ ni takarniuri̱n untsukar ni kuítri̱n akanak súsarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chikichkiniak seṉku mir (5.000) kuítian susamai. Chikichnasha jimiará mir (2.000) kuítian susamai. Tura chikichnasha chikichik mir (1.000) kuítian susamai. Nii takastin jearma nuja̱i̱ métek súsarmai. Tura ikiuak yajá wemai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Takari̱n seṉku mir kuítian achikmia nuja̱i̱ takakmas ataksha seṉku mir kuítian patakmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chikichcha núnisaṉ jimiará míran achikmia nu̱ja̱i̱ takakmas ataksha jimiará míran patakmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tura chíkich shuar ni uuntrí̱ kuítri̱n chikichik míran achikmia nuna wa̱a̱ taur ú̱u̱kmai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Nuyá ukunam nu shuara uuntri̱ támai. Tura kuítian súkiarma nuja̱i̱ itiurkarmakit tusa untsukarmai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Emka seṉku mir kuítian achikmia nu tamai. Nuyá ni úuntri̱n chíkich seṉku mir patakman suak timiai “Uuntá, seṉku mir kuit surusmame. Pai, atak seṉku míran patasmajai.” ");
INSERT INTO jivNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Takui ni uuntri̱ timiai “Ti péṉker takakmauwitme. Nekas uminiaitme. Ishichkiji̱a̱i̱sha ti péṉker takakma asakmin ti núkap yamaikia amastatjai. Winí waya̱m wiji̱a̱i̱ ti shiir warasta” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘Nuyá chíkich shuar jimiará míran achikmia nu tarí timiai “Uuntá, jimiará mir surusmame. Pai, ataksha jimiará míran patasmajai.” ");
INSERT INTO jivNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Takui ni uuntri̱ timiai “Ti pe̱ṉker takakmauwitme. Nekas uminiaitme. Ishichkiji̱a̱i̱sha ti péṉker takakma asakmin ti núkap yamaikia amastatjai. Winí waya̱m wiji̱a̱i̱ ti shiir warasta” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘Nuyá chíkich shuar chikichik míran achikmia nu tarí timiai “Uuntá, ti kajen asakmin tura araachiatam tura atsaamprachiatam júurtuktarum tiniu asakmin ");
INSERT INTO jivNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","sapijmiakun ame kuítrumniaka nuṉká táutran ú̱u̱kmajai. Pai, ju̱í̱iti ame surukmiam nu” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Takui ni uuntri̱ timiai “Ámeka yajauchiitme. Aya nákiitme. Wi araachiatan tura atsaamprachiatan júurtuktarum tíniuitme túrutsumek. ");
INSERT INTO jivNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tu enentáimkiumka ¿urukamtai kuit-iruntainiam ikiurtuschamam? Nuikia wi táakun patasan achikiáa̱jai” timiai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nuna tinia nui̱ wajainian tiarmai “Ju̱ shuar chikichík mir kuit atankirum tias mir kuítian takaka nu susatarum. ");
INSERT INTO jivNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kame núkap takakna nú shuar ataksha patatnastatui tura ampiniartatui. Antsu ishichik takakna nusha ishichik takakuitiat jurunkittiawai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ju̱ umichu shuarsha a̱a̱ kiritniunam ajapatarum. Nui̱ ti wáitiak ti úuttiatui” timiai”. Tu áujmatsamiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus áujmatuk tímiayi ‘Aents Ajasuitjiana nu ashí akupin ajasan Yusa suntari̱ éṉkekma winittiajai. Tura Uunt Akupin asan shiir pujutairui̱ pujustatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Túramtai ashí nuṉkanmaya̱ aents Winia irunturartatui. Túrunawarmatai akantrartatjai. Murikiu wáinin kachurtinian tura kachurtichuja̱i̱ akanea nútisanak shuáran akantrattajai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tura kachurtichunka, péṉkera nuna, untsuuruini̱ awajsartatjai. Tura kachurtinniaka, yajauchia nuna, menaaruini̱ awajsartatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Túran nekas Uunt Akupin asan untsuuruini̱ wajainian títiatjai “Atumniaka winia Apar shiir awajtamsaitrume. Wi akupeajna nui̱ winitiarum. Yus nuṉkan najanamia tímianaik átum nui̱ warastinian tsaṉkatramkamiarme. ");
INSERT INTO jivNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kame Wi tsukamá wekai̱ ayurtuamiarme. Kitiama wekai̱sha umartin surusmiarme. Wait ajá wekai̱sha itiaararum ajamprusmiarme. ");
INSERT INTO jivNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Pushir atsai̱sha átumka surusmiarme. Jaa tepai̱sha íiráimiarme. Sepunam eṉketai̱sha tarum íiráimiarme” títiatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tutai untsuuruini̱ wajainia turutiartatui “Uuntá, ¿urutia tsukamá wekaamnisha ayuramajⁱ. Urutiá iisha kitiama wekáa wainkiarsha umartincha amasmajⁱ. ");
INSERT INTO jivNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tura urutia wait ajá wekaamnisha tura pushiram mamurmataisha iisha amasmajⁱ. ");
INSERT INTO jivNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Urutia iisha jaa tepamin tura sepunam eṉketmin wainkiarsha winitir íimiajⁱ?” turutiartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Turutainiakui Wi Uunt Akupin asan tiartatjai “Nekasan tájarme, ashí ju̱ wíi shuar péejchachisha waitnentramarum nu Winia anentakum túraitrume” tiartatjai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Wi Uunt Akupin asan menaaruini̱ wajainian tiartatjai “Atumsha yajá wetarum. Yajauchiji̱a̱i̱ yumiṉkramuitrume. Yus uunt iwianchi ni suntari̱ji̱a̱i̱ tuke kajinkiashtin jinium apeatniua nui̱ wétatrume atumsha. ");
INSERT INTO jivNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Átumka Wi tsukamai̱ ayurtuachmarme. Kitiamai̱sha umartin suruschamarme. ");
INSERT INTO jivNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wait ajá wekai̱sha ikiatrachmarme. Pushirun imiamprai̱sha entsartin suruschamarme. Jaa tepai̱sha tura sepunam eṉketai̱sha íiraichmarme” tiartatjai.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Tutai niisha turutiartatui “¿Urutia, Uuntá, tsukamakmesha, kitiamakmesha, wait ajaknísha, pushiram imiampramsha, jáakmesha, tura sepunam wait ajá pujamnisha íisha winitir yáiṉchamajⁱ?” turutiartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Wi Uunt Akupin asan tiartatjai “Nekasan tájarme, Ashí Wíi shuar, péejchachisha waitnentrachmarum nui̱ Winiasha túrutachuitrume” tiartatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nu shuarka tuke wáitsatniunam weartatui. Tura Yus achikma ainia nusha tuke iwiaaku Yusja̱i̱ pujustinnium weartatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus ashí nuna tinia umik ni unuiniamuri̱n tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Atumsha nékarme, Paskua jisat jeatin jimiarchik tsawant ajasai. Nui̱ Wi Aents Ajasu asamtai krúsnum máawarti tusar surutkartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nuyá Israer-patri uuntri̱sha Israer-shuara jintinniuri̱sha Israer-shuara úuntri̱sha Kaipiasa je̱e̱n áa̱rin iruntrarmiayi. Kaipiassha Israer-patri uuntri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nui̱ anaṉkatin chichamja̱i̱ Jesus achikiar maatai tusar chichaman jurusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tura tiarmiayi “Jístatin túrachminiaiti aents téetet ajara̱i̱ṉ tusar.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus Petania péprunam pujus tunamaru Semuṉka je̱e̱n pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nui̱ pujai̱ nuwa̱ ti kuit jeá kuṉkuinian arapástru tutai kaya najanamunam piakun itiamiayi. Tura Jesus misanam yurumátaj tusa pujan tarí nu kuṉkuinian ukatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Túramtai ni unuiniamuri̱ nuna íisar kajerkar tiarmiayi “¿Urukamtai au kuṉkuin imiá kuítniasha áantrasha wasurea? ");
INSERT INTO jivNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Antsu ti kuitja̱i̱ suruk shuar kuítrincha ainia nuna yái̱tskesha” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus tuinian anturak tiarmiayi “¿Urukamtai ju̱ nuwa̱ yajauch enentáimtarum? Túrutana ju̱ ti péṉkeran túrayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kuítrincha tuke atumja̱i̱ pujushtatuak. Antsu Wikia atumja̱i̱ tuke pujushtatjai. ");
INSERT INTO jivNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ju̱ nuwa̱ kuṉkuinja̱i̱ ukatrurai̱ ju̱ka, Wi iwiarnastin asamtai áitkiarayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nekasan tájarme, ashí nuṉkanam uwempratin chicham etsernakui tuke ju̱ nuwa̱ pachinias etsernaktatui. Túramtai ni túramuri̱ kajinmankishtatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nuyá Jesus tuse (12) unuiniamunmaya̱ chikichik ni naari̱ Jútas Iskariúti Jesusan suruktaj tusa Israer-patri uuntri̱i̱n wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tura jeari tímiayi “Jesusan achikia amakui ¿urutmá akirkaintrum?” Takui trainta (30) kuítian akikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nu akikiam Jútas itiurak Jesusan súsaraintiaj tu enentáimias wekaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wakapruachu tantan yurumáinia nú námper yama naṉkamkui Jesusa unuiniamuri̱ tariar aniasarmiayi “¿Tui̱ paskua námper iwiaarakrin yurumáttam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tuíniakui Jesus tímiayi “Péprunam wetarum. Nui̱ chikichík shuara je̱e̱n jearum titiarum “Uunta chichaak “Winia tsawantur ishichik ajasai. Tuma asan paskua namperan winia unuiniamurja̱i̱ ame je̱e̱mi̱i̱n yurumátjai” tawai” titiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tutai ni unuiniamuri̱ wear Jesus timia nuna umikiar paskua nampertin yurumátniun iwiararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tura kashi ajasái̱ Jesus ni tuse (12) unuiniamuri̱ji̱a̱i̱ misanam yurumuk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nui̱ yurumáiniai̱ Jesus tiarmiayi “Nekasan tájarme, átum pujarmena ju̱yá chikichik Winia surutkattawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nuna takui ti kúntuts enentáimprar mai aní awajiarmiayi “Uuntá, ¿wiáshitiaj?” ");
INSERT INTO jivNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mai tu awajenam Jesus tiarmiayi “Wi nú piniṉnumaṉ jimiartukan yuajna ju̱ Winia surutkattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wi Aents Ajasu asan Yus Chicham tana nuja̱i̱ métek túrunattajai. Túrasha shuar Winia surutkattana nuka ti asutniátin asa akiinmainchu ajakuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nuyá Jútas suruktaj tana nu Nin tímiayi “Uuntá nuikia ¿wiáshitiaj?” Takui Jesus tímiayi “Ee, nekas ámetme.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tura yurumuk pujuiniai̱ Jesus yurumkan achik Yúsan yumiṉsamiayi. Tura puur ni unuiniamuri̱n suiniak tímiayi “Ju̱ yuatarum. Ju̱ka winia aya̱shruiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nuyá piniṉkian achik Yúsan yumiṉsamiayi. Tura suiniak tiarmiayi “Ju̱sha ashí umartarum. ");
INSERT INTO jivNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ju̱ka winia numparuiti. Tura winia numpar puármatai, yamaram chicham nekas uminkiattawai tawai. Tura puármatai untsurí̱ shuara tunaari̱n tsaṉkurattawai. ");
INSERT INTO jivNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tura ataksha átum Yus akupea nui̱ jeatsrumniṉ ju̱ uwa yumiri̱n umarchattajai. Tura tsawant jeamtai atumja̱i̱ Yus akupeana nui̱ yamarman umartatjai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yús-kantan kantamáwar umikiar Uriwiu náinnium wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nui̱ Jesus tímiayi “Ju̱ kashi átum Winia ashí natsantrurtatrume. Kame Yus-Papinium áarmaiti “Murikiu wáinniun mantuattajai túram murik pisarartatui.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tura nantakin Kariréa nuṉkanam Wi émkattajai átum wéatsrumin.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Takui Pítiur tímiayi “Chíkich natsantramainakuisha wikia túrashtatjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tutai Jesus tímiayi “Nekasan tájame, ju̱ kashi atash shiniatsa̱i̱ṉ menaintiú natsantrurtatme.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pítiur tímiayi “Maa, Ámiji̱a̱i̱ métek mántuiniakuisha peṉkesha natsantrashtatjame.” Ashí ni unuiniamuri̱ núnisaṉ tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nuyá Jesus ni unuiniamuri̱ji̱a̱i̱ Jitsemaní náartin ajanam jeá tímiayi “Ju̱í̱ pujusrum nákarsatarum. Aranta ai̱ wena Yúsan áujsatjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tinia Pítruncha tura mai Sepetéu uchirí̱ jukí wémiayi. Nui̱sha ti kúntuts enentáimiuk wake mesekmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nuyá Jesus tímiayi “Ti kúntuts jakamnia enentáimjai. Atumsha ju̱i̱ pujusrum Wiji̱a̱i̱ métek iwiáa pujutarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tinia Jesus arantach we nui̱ tikishmar tsuntsuma Yúsan áujeak tímiayi “Winia Aparú, Wi túrunatniua nu nusháa iwiaramniaitkiuiṉkia ju̱ wáitsatniua nu tsaṉkatrukaip. Tura Wi wakeraj núniska áchati antsu Ame wakeram núnis atí” áujuk tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nuyá ni menaintiu unuiniamuri̱ pujuiniamunam waketki kanúu pujuinian jeariar Pítrun tímiayi “Átumka chikichik úraksha Wiji̱a̱i̱ iwiáa pujutin ¿tujinkiarmek? ");
INSERT INTO jivNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Iwiáa pujusrum Yus áujsatarum. Tunáa nupettamkairap. Enentái̱min ti wakeriniaitrume túrasha aya̱shim pimpiruiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tinia ataksha we Yúsan áujeak tímiayi “Winia Aparú, Wi imiá nekasan wáitsatniuitkiuiṉkia nui̱kia Ame wakeramna nu atí.” Tu áujsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nuyá ataksha taa ni menaintiu unuiniamuri̱ tarimiayi. Tura kari̱ ti nupeteam ataksha kanúu pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Túmainiakui nin ikiukin ataksha áujmia núnisaṉ Yúsan áujsataj tusa waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Áujas umik ni unuiniamuri̱ pujamunmaṉ wémiayi. Tura tiarmiayi “Antsu yamaikia kanarum ayampratarum. Ura jeayi. Wi Aents Ajasu aiṉ, tunaarintin shuarnum surunkatin jeayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wari nantaktiarum. Wéartai. Súrutna nu winiawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus tu chichai̱ Jútas támiayi. Nusha ni unuiniamuri̱yayi. Nuja̱i̱sha untsurí̱ shuar puniaja̱i̱sha tura numiji̱a̱i̱sha winiarmiayi. Nu shuaran Israer-patri uuntri̱sha Israer-shuara úuntri̱sha akupka ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jútas, Jesusan sura, tuke Jesusai̱ jeatsuk nu shuaran tiarmiayi “Wi miniakkan mukunattajna núiti. Nu achiktarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nu asamtai Jesusan tarí “Winiajai Uuntá” tinia mukunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Takui Jesus tímiayi “Amikrú, ¿warí winitiam?” Nuyá achikiar Jesusan júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nui̱ chikichik Jesusa tsaníakmari̱ ni puniari̱n ukuiniak shuara kuishi̱n tsupirkamiayi. Nu shuarsha Israer-patri uuntri̱ takarniuri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Túramtai Jesus tímiayi “Puniarum eṉkeata. Ashí puniaja̱i̱ máanainia nusha puniaja̱i̱ mantamnashtatuak. ");
INSERT INTO jivNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wi wakeraknaka winia Aparun timiá untsurí̱ suntari̱n seakui páchitsuk akupturkainti. ¿Nu nékatsmek? ");
INSERT INTO jivNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tura nuna túramtaiṉkia Yus-Chichamnum tana nu uminkiachainti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nuna tinia Jesus nu shuaran tiarmiayi “Átum kasá achiktaj tawa nútiksarum puniaja̱i̱sha numiji̱a̱i̱sha tarutniurme. Kame ashí tsawantai̱ Yusa Je̱e̱n atumja̱i̱ pujusan Yus-Chichaman etsermiajai. Nui̱sha achirkachmarme. ");
INSERT INTO jivNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Antsu yamaikia yaunchu Yúsnan etserin áararmia nu umínkiatí tusarum jútikrarme.” Tu tímiayi Jesus. Nuyá ni unuiniamuri̱ Jesusan Níniak ikiuiniak pisararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Shuar Jesusan achikiarmia nusha Kaipiasai̱ júkiarmiayi. Nusha Israer-patri uuntrí̱yayi. Nui̱sha Israer-shuara jintinniuri̱sha Israer-shuara uuntri̱ armia nusha irunar matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tura Pítiur árantak Jesusan nemarkin uuntri̱ je̱e̱n a̱a̱ri jeamiayi. Tura suntarja̱i̱ tsaniṉ pujusmiayi Jesusan itiurkartiṉ tusa. ");
INSERT INTO jivNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tura Israer-patri úuntri̱sha Israer-shuara úuntri̱sha tura ashí naamka uunt armia nusha Jesusan wait-chichamja̱i̱ súmamtikiatai tusar áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Untsurí̱ shuar ántar tsanumpruiniakuisha máatin chichaman nekaracharmiayi. Nuyá jimiará shuar tsanumpruiniak ");
INSERT INTO jivNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tiarmiayi “Ju̱ áishmaṉ chichaak “Yusa Uunt Je̱e̱n yumpuaran ataksha menaintiú tsawantin jeamminiaitjai,” tu chichamai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nuyá Israer-patri uuntri̱ wajaki Jesusan tímiayi “¿Áimtsumek. Turamainia nusha anturmammek?” ");
INSERT INTO jivNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Túrasha Jesus tuke áimchamiayi. Túmakui Israer-patri uuntri̱ chicharuk “Nekas iwiaaku Yusa náari̱i̱n tájame nekasa nu táchakminkia Yus íirmastatui. ¿Ame Krístukaitiam. Yusa Uchirí̱ṉkaitiam? Paant etsérkatá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tutai Jesus tímiayi “Ee, ame támena núitjai. Tura ataksha atumin tájarme, wi Aents Ajasu asan ti kakaram Yusa untsuurini̱ pujai̱ wáitkiáttarme. Tura yuraṉminiam winiai̱sha wáitkiáttarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nuyá Patri uuntri̱ nuna antuk ti kajek ni pushiri̱ ja̱a̱k tímiayi “Ju̱ áishmaṉ ni chichame̱ja̱i̱ Yúsan nekas yajauch chicharniuiti. Nuyásha ¿warí atsumajⁱ? Atumsha Yúsan yajauch chicharu antukcharumek. ");
INSERT INTO jivNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Waritia enentáimprum?” Tutai “Sumamayi. Mantamnati” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tiar usukiawarmiayi yapiniam. Tura awattiarmiayi. Chikichcha yapiniam awati wishikiainiak tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ame Krístuchukaitiam. ¿Ya awattama? Íitsuk nekaata.” Tu chichariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nu túmaiṉ Pítiur a̱a̱ pujai̱ nuwa̱ chikichik jeari tímiayi “Amesha ju̱ Kariréanmaya̱ Jesus tutai̱ji̱a̱i̱ wekaichamkam.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tutai Pítiur ashí ántuiniamunam tímiayi “Nékatsjai. ¿Warittsuk chichaam?” ");
INSERT INTO jivNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nuna tinia jíinkitiaj tusa wéai̱ chíkich shuar wáiniak nui̱ pujuinian tiarmiayi “Au áishmaṉsha Nasarétnumia̱ Jesusja̱i̱ wekainiuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tutai Pítiur ataksha tímiayi “Nekasan tájarme, ju̱ áishmaṉkan peṉké nékatsjai.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Árusaṉ nui̱ pujuarmia nu Pítrun tariar tiarmiayi “Nekas amesha auja̱i̱ wekaimiame. Warí, chichammiji̱a̱i̱ páantaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tutai Pítiur “nekas Yus íirui” taku tímiayi “Nu̱ áishmaṉkan peṉké nékatsjai.” Nuna tai̱ atash shiniukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Túramtai Pítiur Jesus nuik tímia nuna enentáimpramiayi. “Atash shiniatsa̱i̱ṉ menaintiú natsantrurtatme” tímiayi Jesus. Pítiur nuna enentáimiar jiinki we ti úutmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kashin tsawarmatai Israer-patri uuntri̱sha Israer-shuara úuntri̱sha Jesus maatai tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tiar Jesusan jiṉkiawar apachi uuntri̱n Punsiu Piratui̱ júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jútas Jesusan suruk tura máatai tuínian antuk enentáimiar trainta kuítian Israer-patri uuntri̱ncha Israer-shuara úuntri̱ncha awaṉtukiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tura tímiayi “Nu áishmaṉ tunaarinchan máatarum tusan surukan wi sumamajai.” Takui tiarmiayi “Nusha íiji̱a̱i̱sha warí urukatiṉ. Nuka amek íischatniukaitiam.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tinia Jútas nui̱ Yusa Uunt Je̱e̱ kuítian utsaṉ ikiuak nuyá we kajempramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nuyá Israer-patri uuntri̱ nu kuítian júukar tiarmiayi “Ju̱ kuit shuar sumakma asamtai Yusa kuítri̱ji̱a̱i̱ irurchamniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tura nuamtak áujmatsar “nuṉka sumaktai” tiar Nuwe Najantai nuṉkan sumakarmiayi yajaya̱ shuar nui̱ iwiarsatniun. ");
INSERT INTO jivNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Shuar sumakma kuitja̱i̱ sumakma asamtai yamaisha Numpá Nuṉka tuke tuíniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Nuja̱i̱ yaunchu Yúsnan etserin Jeremías timia nu uminkiamiayi: “Uunt Yus turutmia núnisaṉ túrawarmiayi. Israer-shuar trainta kuítian seawarmatai nuna akantrar nuja̱i̱ Nuwe Najantai nuṉkan sumakarmiayi.” Tu áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesusan apachi úuntri̱i̱n ejeniarmatai nii aniasmiayi “¿Nekasmek Israer-shuara uunt akupniurí̱ntiam?” Tutai Jesus “Ame támena núitjai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nuyá Israer-patri úuntri̱sha Israer-shuara úuntri̱sha súmamtikia Jesus pachischamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nuyá Piratu tímiayi “Ashí yajauch chichartamainia nu ¿anturmammek?” ");
INSERT INTO jivNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tútaisha Jesus peṉké áimkiachmiayi. Túmakui akupin ti enentáimiar títinian nekaachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jísat tsawantin apachi uuntri̱ Israer-shuar shiir enentáimprarat tusa sepunam eṉketun shuar wakeramun ji̱i̱ki aṉkant akupniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nui̱ sepunam tunáa shuar Parapás náartin pujumiayi. Ashí shuar nékarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tuma asamtai Piratu Israer-shuar iruntrarun aniasmiayi “¿Yana aṉkant akupkat tusarum wakerarum. Parapásnak akupkattaj; Kristu tutai Jesusnak akupkattaj?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kame Israer-shuar ántar kajerainiak ni itiarmian nekaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tura Piratu nuna inintrak puja̱i̱ ni nua̱rí̱ chichaman akuptukmiayi. “Ju̱ péṉker áishmaṉ súmamtikiatniuja̱i̱ pachiinkiaip. Mesekranam nii áitkiatniun nekaan wáitsan tsawa̱rjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Túrasha Israer-patri úuntri̱sha Israer-shuara úuntri̱sha “Parapás aṉkant wetí, tura Jesus mantamnati” titiarum tusar shuáran akatrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Apachi akupniuri̱ ataksha aniasarmiayi “Ju̱ jimiará áentsun ¿yana aṉkant akupkat tusarum wakerarum?” Tutai “Parapás” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tutai aniasarmiayi “Jesusnasha. Yusa Anaikiamuri̱ Kristu tuinia nunasha, ¿itiúrkáttaja?” Tutai ashí “Krúsnum máatá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tuíniakui Piratu tiarmiayi “¿Warí yajauchinia túrait?” Tutai kakantar untsumuk “Krúsnum máatá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tura Piratu Jesus uwemtikrachminiaitkiui antsu ashí shuar charaatum ajainiakui entsa uturtitiarum tusa seamiayi. Tura ashí íimiainiai̱ṉ ikijmiak tímiayi “Ju̱ péṉker áishmaṉ máatniunam wikia pachiintsujai. Antsu atumek íistarum.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tutai ashí shuar tiarmiayi “Iik ii shuari̱ji̱a̱i̱ ju̱ áishmaṉ máatin íistaji.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nuyá Piratu Parapásan aṉkant akupkamiayi. Tura Jesus asutiárum krúsnum máatárum tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nuyá akupin pujutai je̱a̱nam akupniu suntari̱ Jesusan júkiar ashí suntaraim irunturarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tura pushiri̱ áitkiar akupin entsatain kapa̱a̱ku pushin áentsrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Múuknúmsha tawaspan jaṉki najanamun etsemtikiarmiayi. Tura karisun akupniu numiri̱a áaniun untsuurí̱ni̱ ataksarmiayi. Túrawar wishikiainiak tikishmatrar tiarmiayi “Israer-shuara uunt akupniuri̱nme.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tiar usukiarmiayi. Tura karisun jurukiar múuknum awatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tura núkap wishikrar kapa̱a̱ku pushin áitkiar ni pushiri̱n áentsrarmiayi. Nuyá krúsnum maatai tusar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesusan jukí wésar Serini nuṉkanmaya̱ shuaran, ni naari̱ Semuṉ, Jesusa krúsri̱n jurukit tusar achikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nuyá Kúrkutanam ejeniarmiayi. Kúrkutaka, shuar chichamja̱i̱ṉkia, muuka ukunch tútainti. ");
INSERT INTO jivNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nui̱ Jesusan umutai yapája̱i̱ pachimpra najanamun áartaj tusar súsarmiayi. Tura Jesus apas iis umarchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Krúsnum ajintrurar suntar yáki Jesusa pushiri̱n jukit tusar nakurusar awakmakua nuna súsarmiayi. Núja̱i̱ṉkia yaunchu Yúsnan etserin áarmia nu uminkiamiayi: “Winia entsarmarun akantrarmiayi tura nakurusar awakmakua nuna winia pushirun súsarmiayi.” Tu áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nuyá wáinkiatai tusar pujursarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tura urukamtai máamuit ashí aents nekaawarti tusa áarman muuknumaani anujtukarmiayi. JU̱ITI JESUS, ISRAERA UUNT AKUPNIURI̱ Tu áarmauyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Núnisaṉ Niiji̱a̱i̱ métek jimiará kasa chikichkin untsuurnumani̱ tura chikichnasha menaanmani̱ krúsnum máawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Shuar nui̱ naṉkaamainiak muuke pe̱a̱tar wishikiainiak ");
INSERT INTO jivNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tiarmiayi “Ame Yusa Uunt Je̱e̱ sáa̱kim menaintiú tsawantin jeamtatjai tíchakaitiam. Nekas Yusa Uchirí̱nkiumka krúsnumia̱ akaikim uwemprata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Núnisaṉ Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha, Pariséusha, Israer-shuara úuntri̱sha, Jesusan wishikiainiak nuamtak tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Chikichnaka uwemtikraiti tura Níṉkikia uwemtsui. Israera Uunt Akupniurí̱ntkiuṉka krúsnumia̱ akaikimtai nekas enentáimtustatji. ");
INSERT INTO jivNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Yúsan nekas enentáimtiniaitjai” tawai. Wátsek, Yus nekas Nin aneakka uwemtikrati. “Wi Yusa Uchirí̱ntjai” turamchamkajⁱ” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kasá shuarsha Niiji̱a̱i̱ ajintruamu armia nusha Nin wishikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nuyá tutupin a̱i̱ tee ajasmiayi. Túrunayat ataksha a̱a̱ṉku tsáapin ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nuni a̱i̱ Jesus kakantar untsumkamiayi. “Erí, Erí, rama sapaktani’ tímiayi. Nusha shuar chichamja̱i̱ṉkia “Yusrú, Yusrú, ¿urukamtai ajapa ikiurkiniam?” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Shuar nui̱ wajarmia nusha nuna enentáimtsuk antukar tiarmiayi “Yaunchu Yúsnan etserniun Eríasan untsuawai.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tura chikichik tsékeṉki we uruchin itiamiayi. Tura churuinian ajamper sapapja̱i̱ ijiú mukunati tusa susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tura chikichcha wíshikeak tiarmiayi “Iniáisatá, Erías tarí uwemtikratpiash.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus ataksha kakantar untsumak nuyá jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nu chichamaik Yusa Uunt Je̱e̱ tarach ajamu yakiiniya̱ achik nuṉkaani tse̱u̱ jaanakmiayi. Nuṉkasha ú̱u̱rkamiayi. Kayasha jakukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Núnisaṉ iwiarsamusha uraniarmatai untsurí̱ Yus-shuar jákarusha nantakiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nusha emka Jesus nantakmiatai niisha nantakiar iwiarsamun ikiukiar Yusa pépruri̱n Jerusaréṉnum waya̱warmatai untsurí̱ shuar wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nuyá suntar Jesusan wáinkiarmia nusha tura ni kapitiántri̱sha nuṉka ú̱u̱rkamtai nuyá chikichcha ashammai ajasmatai ti sapijmiakarmiayi. Tura tiarmiayi “Ju̱ áishmaṉ nekas Yusa Uchirí̱nti.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nui̱sha nuwa̱ Jesusan nemariarmia nu, arant wajasar, ii wajaarmiayi. Nusha Kariréanmaya̱ pataatukiar Jesusan yaiṉki ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nuja̱i̱ Máktaranmaya̱ Marisha, Sepetéu nuwé̱sha, tura chíkich Marisha ármiayi. Chíkich Marikia Jakupuncha tura Jusencha nukurí̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kiarai̱ shuar ti kuítrintin Arimatéu péprunmaya̱ ni naari̱ Jusé támiayi. Nusha Jesusan enentáimtiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nii Piratui̱ we Jesusa aya̱shin seamiayi. Nin súsarat tusa Piratu akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Túram Jusé Jesusa aya̱shin krusnumia̱ jusa ti péṉker tarachja̱i̱ penuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tura kaya wa̱a̱ táurmanum yamaram amia nui̱ iwiarsamiayi. Ni iwiarsatin táumtikramunam Jusé iwiarsamiayi. Iwiaras kaya uuntja̱i̱ etektuk ikiuak wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nui̱sha Máktaranmaya̱ Marísha tura chíkich Marísha iwiarsamunam naka ii pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nú kíara̱i̱ṉ ayampratin tsawantna mash iwiarnakui Israer-patri úuntri̱sha Pariséusha Piratui̱ wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tura tiarmiayi “Uuntá, nu wáitrin áishmaṉ iwiaaku pujus “Menaintiú tsawant jakan nantaktiatjai” tíniuyi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nu asamtai iwiarsamunam menaintiu tsawant suntar wáinkiarat tusa akuptukta. Ni unuiniamuri̱ kashi tariar tura ni aya̱shin kasamkar “Pai, nantakni” shuáran tiara̱i̱ṉ. Ju̱ja̱i̱ṉkia nuna naṉkaamas shuáran anaṉkawarainti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tutai Piratu tiarmiayi “Nui̱ suntar takakrume. Werum iwiarsamu urakchamnia péṉker wáinkiatárum.” ");
INSERT INTO jivNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tutai wear iwiarsamun urankashti tusar etektukma iṉkiuṉmanum seraja̱i̱ yakarar ni áarmari̱n anujtukarmiayi. Tura suntarnasha awajtukiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayampratin tsawant naṉkaamasmatai tumiṉtin yama tsawaana a̱i̱ Máktaranmaya̱ Marisha chíkich Mariji̱a̱i̱ iwiarsamu iyutai tusar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tumai̱ Yusa suntari̱ nayaimpinmaya̱ iwiarsamun tarí kaya atutkamun urak nui̱ pujusmiayi. Túmakui nuṉka ti ú̱u̱rkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yusa suntari̱sha pe̱e̱mia tímiatrus wínchauyayi. Pushiri̱sha ti puju áuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tura iwiarsamun wáiniarmia nú suntarsha nuna wáinkiar ashamainiak ti kuraṉkarmiayi. Jaká áinis ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nuyá nayaimpinmaya̱ suntar nuwa̱n tímiayi “Ashamkairap. Jesus krúsnum máawarmia nu e̱a̱tsrumek. ");
INSERT INTO jivNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ju̱i̱ṉkia pujatsui. Nii timia núnisaṉ nantakniuiti. Pai, áepsarma nu íitiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wárik wérum ni unuiniamuri̱ “Jesus jakamunmaya̱ nantakni tura wari Kariréanam wétatui. Nui̱ werirum wáinkiáttarme” titiarum. Wats, nunak tájai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tutai nu nuwa̱ iwiarsamunmaya̱ wárik jíinkiar ashamainiayat ti warasar tseke̱ waketkiarmiayi ni unuiniamuri̱n ujaktai tusar. ");
INSERT INTO jivNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tumai̱ Jesus wantintiukarmiayi. Tura “pujarmek” takui Jesusan tariar tikishmatrar nawencha miniakrusar shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Túram Jesus tiarmiayi “Ashamprukairap. Werum winia yatsur ujatruktarum. Kariréanam weartí. Nui̱ wear wáitkiartatui. Tu ujaktarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nuwa̱ wéarmatai iwiarsamu wáinin suntarsha péprunam wéar Israer-patri úuntri̱n ashí túrunamun ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Niisha nuna antukar Israer-shuara úuntri̱ji̱a̱i̱ áujmatsatai tusar wearmiayi. Áujmatsar suntaran ti kuít akikiar ");
INSERT INTO jivNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tiarmiayi “Atumsha étserkuram “Kashi kanararin ni unuiniamuri̱ taar Jesusa aya̱shin kasamkarmai” titiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tura akupin átum kanarman nekamtaisha niiji̱a̱i̱ ii iwiarattaji atumin yajauch awajtamsa̱i̱ṉ tusar” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nuyá suntarsha kuítian achikiar tiarmia nuna tímiatrusaṉ titiái tusar wéarmiayi. Tura tuke yamaisha Israer-shuar tu túrunaiti tuíniawai. ");
INSERT INTO jivNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nuyá ni auntse (11) unuiniamuri̱ Kariréanam wéarmiayi. Tura Jesus timia nú nainnium jeawar ");
INSERT INTO jivNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","nui̱ Jesusan wáinkiar tikishmatrarmiayi. Kame chíkichka Jesusashit tuíniayat Nin wáinkiar tikishmatrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nuyá Jesus tíjiu̱ch tantá tímiayi “Ashí nayaimpinmasha nuṉkasha akupkatniun kakarman surusuiti. ");
INSERT INTO jivNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tuma asamtai ashí nuṉkanam werum ashí shuar jintintiarum Wíi shuar awajsatarum. Túrarum Yus Apa náari̱ji̱a̱i̱, Yus Uchi náari̱ji̱a̱i̱, tura Yus Wakani̱ náari̱ji̱a̱i̱ imiaitiarum. ");
INSERT INTO jivNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ashí atumin Wi akatramajrum nu nútiksarmek umiktin unuiniartarum. Tura ju̱ nekaatarum: Tuke tsawantai̱ ikiutsuk atumja̱i̱ pujuttajai” tímiayi Jesus.");
INSERT INTO jivNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jui̱ Jesukrístunu shiir chicham náṉkameawai. Jesukrístu Yusa Uchirí̱nti. ");
INSERT INTO jivNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yuska imiakratin Juaṉkan pachis ni etserniuri̱n Isayasan ti yaunchu ni Papiri̱i̱n ju̱na áamtikramiayi: “Iisiana, ame wéamurmi̱n emka wetí tusan winia akatramurun akupeajai. Niisha ame jintimin iwiarattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Niisha aents atsamunam untsumuk ju̱na títiatui: “Uunta jinti̱ iwiarturtarum; naka awajsatarum.” Nuke áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wats, aents atsamunam imiakratin Juaṉ imiaittsa pujus étseruk, ““tunaarun Yus asakatrurat” tusarum, enentáim yapaji̱árum imiantiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Anturkatai tusar ashí Jutía nuṉkanmaya̱ shuar tura Jerusarén peprunmaya̱ shuarsha Ni̱i̱n tariarmiayi. Taar, ni tunaari̱n ujakarmatai, Juaṉ Jurtaṉ entsanam imiainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juaṉsha kamiriu ure̱ najantramun entsauyayi. Emenmamkesha nuapeyayi. Tura chiniji̱a̱i̱ yutai-títikriatsnasha yuuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Niisha áentsun ujaak tímiayi “Wíji̱a̱i̱nkia naṉkaamas ana nu winia ukurui̱ winittiawai. Niisha nekas ii Uuntri̱ asamtai, wikia tsuntsumpruan ni sapatri̱ jiṉkiamuri̱nkisha atitrachminiaitjai. ");
INSERT INTO jivNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wikia entsaja̱i̱ṉ aya a̱ya̱shmin imiaajrume, antsu Niṉkia imiantinia áanis Yusa Wakani̱ atumi̱ enentái̱n eṉketramprattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juaṉ áentsun imiak pujurainiai̱, Jesuska Nasarét pepru Kariréa nuṉkanam ana nuyá jiinki Juaṉkan tarimiayi. Tura Juaṉ Jurtaṉ entsanam Jesusan imiaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nuiṉ, Jesus entsaya̱ jiiniuk, nayaimpin uranniun wáinkiamiayi. Tura Yusa Wakaní̱n yámpitsa núnin najanar Ni̱i̱n taarun wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tura nayaimpinmaya̱ chichaamun ju̱na antukmiayi, “Ámeka winia aneamu Uchiruitme. Ámin shiir enentáimtajme.” ");
INSERT INTO jivNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nuyá wárik Yusa Wakaní̱ Jesusan atsamunam jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tura nui̱, yajasma yujamunam, kuarenta tsawant pujumiayi. Nui̱ pujai̱ uunt iwianch Satanás naartin Jesusan nekapsataj tusa pujurmiayi. Túramtai Jesusan wáinkiatai tusar nayaimpinmaya̱ suntar tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ukunam, Juaṉkan sepunam enkeawarmatai, Jesuska Kariréa nuṉkanam Yusa akupeamuri̱n pachis shiir chichaman etserki támiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Tsawant jeayi. Shuarnum Yusa akupeamuri̱ jeatemai. Tuma asamtai, yaunchu enentáimsamuram yapaji̱árum, Uwempratin Chicham umirkatarum” tu etserkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus Kariréa antumiaṉka kánmatkari̱i̱n wekas, namakan achinian Semuṉnasha ni yachi̱ Antresnasha nekan ajuntuk pujuinian wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wáiniak “Nemartustarum, tímiayi. Namak achiarmena nútiksanak áentsun-e̱a̱u Yusna arti tusan awajsatjarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tura nuyaṉka ni nekari̱n ajapa ikiuiniak Jesusan nemarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nuya̱sha Jesus ishichik arantach wesa, Sepetéu uchirí̱n Jakupun ni yachi̱n Juáṉnasha kanunam ni nekari̱n apáa pujuinian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wáiniak, nemartusta tusa untsukarmiayi. Tutai ni aparí̱ncha, ni apari̱ takarniuri̱ncha kanunam ikiuiniak Jesusan nemarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nuyá Kapernáum péprunam jeawarmiayi. Nui̱ Israer-shuara ayampratin tsawantri̱ jeakui Jesus Israer-shuar iruntainiam wayá Yus-Chichaman unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tura ni jintinniuri̱ jintintiarmia nuna iniaṉkas uunt chichamja̱i̱ Jesus jintíakui ni chichame̱n anturkar ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nui̱sha nu iruntainiam áishmaṉ iwianchruku ámiayi. Niisha untsumuk ");
INSERT INTO jivNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¿Warí itiurtamkattsamea incha taum, Nasarétnumia̱ Jesusa? Wikia nékajme. Ámetme Tunaartichu Yúsai̱ya̱ winiamna nu. In emestamprataj tusam táchamek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tutai, Jesus kakantar chicharuk “Takamátsatá. Ni enentái̱ya̱ jíinkitia, tájame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tutai íwianch áishmaṉkan ukurak ajakniṉkiar untsumak kaka̱a̱r a̱a̱ jíinkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nuna wáinkiar, ashamkar nuámtak aniniaisarmiayi. “¿Ausha warinkit. Yamaram chicham warí chichamait? Ju̱ Jesuska timiá kakaram asa ímia iwianchin akupeatsuk. Iisiana umirainiatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tura ti wárik nu túrunamu ashí Kariréa nuṉkanam antunkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nuyá Israer-shuara iruntai je̱e̱nia̱ jiinki Jesuska Jakupuja̱i̱ Juaṉja̱i̱sha we, Semuṉ ni yachi̱ Antresja̱i̱ pujuarmia nui̱ jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Semuṉka tsatsari̱ tsue̱r peaknum jaa tepemiayi. Núnaka wárik Jesusan ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nuiṉkia Jesus werí uwejnum achik iniantkimiayi. Tura nu chichamaik michatramiayi. Michatar, péṉker ajas, Jesusnasha ni nemarniuri̱ncha ayurawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nu tsawantai̱ ki̱arai̱, ashí jáinian, iwianchrukuncha Jesusan itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tura ashí nú péprunmaya̱ shuar taar wáitiniam Jesusan káutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Untsurí̱ shuáran chíkich suṉkuraim jáinian Jesus tsuararmiayi. Tura iwianchruku armia nuna enentáiya̱n iwianchin jí̱i̱rkiarmiayi. Jesuska íwianch nékamu asa, winia náarun ántar pachisarai̱ṉ tusa suritkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nuyá kashin káshik tsawa̱a̱tsa̱i̱ṉ Jesus nantaki Yúsan áujsataj tusa jiinki atsamunam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tura Semuṉ ni amikri̱ji̱a̱i̱ Jesus wemaanum wéarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nin wáinkiar “Ashi shuar Ámin e̱a̱tmainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tutai Jesus chichaak “Chíkich péprunmasha arantach wetai. Nui̱ Yusa chichame̱ etserkatai; nuna túrattsan táwitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nuna ti̱ ashí Kariréa nuṉkanam Israer-shuar iruntai je̱a̱nam etseras wekaimiayi; tura núnisaṉ iwianchniasha ji̱i̱ki akupkini wekaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Túramtai, ti tunamaru shuar Jesusan seatajtsa tarimiayi. Taa tikishmatar tímiayi “Wakerutakmeka tsuaratin tujintratsme.” ");
INSERT INTO jivNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus nin waitnentak uweje̱ja̱i̱ antiṉmiayi. Antiṉ “Wakerajme. Péṉker ajasta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nu chichamaik, Jesus chichakmatai, ni suṉkuri̱ meṉkakamiayi. Tura péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Túrunamtai Jesus kakantar chicharuk ");
INSERT INTO jivNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","akupeak “Wáinkiatá, náṉkamsam etseraip, tímiayi. Antsu weme, Israer-patrirmin iniakmamsata. Túram ashí aents ame péṉker ajasmarumin nekaawarat tusam, Muisais aar akupkamiania nu umikiam súsatin ana nu susata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tura etserkaip támaitiat, jiinki ni túrunamuri̱n mash etseramiayi. Tura nuna etserka asamtai, péprunam, aents írunmanum wétinian Jesus nakitramiayi, antsu a̱a̱ atsamunam pujumiayi. Tura ashí nuṉkanmaya̱ Jesusan tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kapernáum péprunam Jesus ukunam ataksha wémiayi. Jeamtai, ni je̱e̱n pujan nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tuma asamtai shuar wárik ti untsurí̱ káutkarmiayi. Ti untsurí̱ asamtai, je̱a̱ piakmiayi; wáitinmasha ankantchauyayi. Jesuska Yus-Chichaman nu aentsun ujaak pujurmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nuiṉkia ni amikri̱n emearun kuatru shuar tampumpruawar júkiar Jesusan itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tura jeawar, untsurí̱ shuar írunu ásamtai je̱á waya̱tniun tujinkiarmiayi. Tuma ásar, yakinini̱ wakar je̱a̱ urakar, áaṉkawar, tampunam ni amikri̱n Jesus pujamunam awaintiuawar itiararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tura niisha Jesus nekas tsuártatui tu enentáimmiari̱n Jesus nekáa emearun chicharuk, “Uchirú, ame tunaarumka tsaṉkuramuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Israer-shuara jintinniuri̱sha nuna antúu pujuarmiayi. Tura ni enentái̱ji̱a̱i̱ enentáimsar, ");
INSERT INTO jivNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ju̱sha urukamtai emearun tu chichara? Yúsan imiá yajauch chicharui. Warí, yaki tunaan asakarminiait; aya Yúsak tunaan asakarchamniakait” tu enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska ni enentáimmiari̱n nekarawar “¿Urukamtia átum tu enentáimprum? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Emearu, tunaarum tsaṉkuramuiti títinja̱i̱, emearu, wajakim tampuram entsakim wekasata títinja̱i̱ ¿tuá imiá yúpichuchit? ");
INSERT INTO jivNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wats wi, Aents Ajasu asan Yusa kakarmari̱ji̱a̱i̱ shuara tunaari̱ tsaṉkuramniaitjiana nuna paant iwiaintiuktajrume” tímiayi. Nuna tinia emearun chicharuk ");
INSERT INTO jivNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wajaktia, tájame; túram tampuram jukim jé̱e̱mi̱i̱n wetá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nu chichamaik emearu wajaki, tampuri̱n jukí, ashí íimiainiai̱ṉ jíinkimiayi. Nuna túrunamtai ashí ashamkarmiayi. Tura “jútikiamu peṉké wáinchaitji” tiar Yusa náari̱n uunt awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nuyá ukunam Jesus antumiaṉnum waketkimiayi. Tura ashí shuar káunkarmatai jintintiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tura jintintiawar amuk, akupin akitiai je̱a̱nam naṉkaamak, Arpeu uchiri̱n Riwin pujan wáinkiamiayi. Wáiniak “Nemartusta” tímiayi. Tutai Riwí wajaki Jesusan nemarsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chíkich tsawant, Riwisha Jesusan ni je̱e̱n itiaamiayi. Tura untsurí̱ kuítian-juu shuarsha, yajauch shuarsha Jesusja̱i̱ ni unuiniamuri̱ji̱a̱i̱sha ashi̱ nuim misanam pujuarmiai. ");
INSERT INTO jivNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tura kuítian-juu shuarsha yajauch shuarsha Jesusja̱i̱ irunar yurumáinian wáinkiar, Pariséu jintinniuri̱sha Israer-shuara jintinniuri̱sha Jesusa unuiniamuri̱n aniasarmiayi. “¿Urukamtai ame úuntrum Jesus, kuítian-juu shuarja̱i̱ tura yajauch shuarja̱i̱sha yuruma?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus nuna antuk tímiayi “Jaachu shuar tsuákratniun atsumainiatsui. Antsu jaa ana nu tsuákratniun atsumainiawai. Wats, “péṉkeraitjai” tuinia nú shuaran untsuktajtsan táchaitjai; antsu “tunaitjai” tuinia nú shuaran Winia ajasat tusan untsuktajtsan táwitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juaṉka unuiniamuri̱sha Pariséu unuiniamuri̱sha yurumtsuk Yúsan áujiarmiayi. Túmakui chíkich shuar Jesusan tariar chicharainiak, “Juaṉka unuiniamuri̱sha, Pariséu unuiniamuri̱sha yurumtsuk Yúsan áujainiatsuk; ¿ame unuiniamurmeka urukamtai yurumtsuk áujainiatsu?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tutai Jesus chichaak, “¿Nuatma nampernum ipiaamu ainia nu ijiarmawartiniak ainia? Yama nuatu pujakui ni amikri̱ warainiak ijiarmachartin ainiawai. Núnisaṉ winia unuiniamur, Wi pujakui, warainiak yurumtsuk pujuschartin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tura tsawant jeattawai, Winia jurukiartin. Nuiṉkia winia unuiniamur ijiarmawartatui’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tura nuyá ju̱na tímiayi ‘Mamuru pushí jaanakmatai yamaram tarach anujtukchatniuiti. Túramka nijiam yamaram tarach sumpeak mamushan chiṉkiá nuna naṉkaamas jáa̱ktatui. ");
INSERT INTO jivNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nijiamanch yamái nawar nuap najanamu arutnum yaraachminiaiti. Túramka wakaprua karíak nuap najanamu ijiakratniuiti. Tura nijiamanch ukarattawai. Nuap najanamu yajauch ajastatui. Antsu yamaram nijiamanch yamaram nuap najanamunam yaraatniuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chíkich ayampratin tsawantai̱ Jesus ajanmaṉ ajapén naṉkaamarmiayi. Tura ni unuiniamuri̱ trikiu nere̱n maju̱kiar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nuna wáinkiar Pariséu Jesusan chicharainiak “¿Warí, urukamtai ame unuiniamuram ayampratin tsawant takastin surimkiamu ai̱sha takainia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tutai Jesus tímiayi “Ii uuntri̱ Tawitia túramuri̱ Yús-Papinium áujsachukaitrum. Niisha ni nemarniuri̱sha tsukamainiak, ni yurumkari̱ atsakui, túrawarmia nu áujsachukaitrum. ");
INSERT INTO jivNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apiatár Yusnan pujurniu uuntri̱ pujai̱ Uunt Tawit Yusa Je̱e̱n waya̱miayi. Tura Tawitkia, patri naṉkaamas uunt asa, pátrichuitiat, iniaktusma tantan, aya patri yútainiak, yuamiayi; tura ni nemarniuri̱ncha ajamsamiayi. Nu áujsachukaitrum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ayampratin tsawantai̱ túrashtinian umirkashtimpiash tusa Yuska aentsun najanachmiayi. Antsu aents ayamprarat tusa Yus ayampratin tsawantan tesamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wisha, Aents Ajasu asan imia ayampratin tsawantan Nerenniuri̱ntjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ataksha chíkich tsawantai̱ Israer-shuar iruntainiam Jesus waya̱miayi. Nui̱ shuar ámiayi, ni uweje̱ jaka. ");
INSERT INTO jivNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tura tunáan túrayi titiai tusar wakeruiniak “ayampratin tsawantai̱ tsuártimpiash” tusar, Pariséu shuarsha Jesusan ii pujuriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nuiṉkia Jesus uweje̱ jaka shuaran chicharuk “Ajapén wajasta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nuiṉkia mamikmaun chicharuk “¿Ayampratin tsawantai̱ péṉker túratin yajauch túratniuja̱i̱ tuá imiá péṉkerait. Shuar uwemtikratin máatniuja̱i̱ tuá imiá péṉkerait?” tímiayi. Nuna takui niisha pachischarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tura Jesus kajek nin íiyarmiayi; tura ni enentái̱n kátsuram ásarmatai kúntuts enentáimsamiayi. Tura shuáran chicharuk “Uwejem iniakmasta” tímiayi. Iniakmasmatai ni uweje̱ jaruku ataksha péṉker ajatsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nuyá Pariséu shuar jíinkiar, Jesus maami tusar Erutis shuarja̱i̱ áujmatsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nuyá Jesus ni unuiniamuri̱ji̱a̱i̱ antumiaṉnum wémiayi. Kariréa nuṉkanmaya̱ untsurí̱ shuarsha Jesusan nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Untsurí̱ nuṉkanmaya̱sha káunkarmiayi. Jutía nuṉkanmaya̱sha, Jerusarén péprunmaya̱sha, Itiumía nuṉkanmaya̱sha, Jurtaṉ entsa amainia̱sha, Tiru tura Setuṉ pepru pujuinia nú nuṉkanmaya̱sha, untsurí̱ shuar ni túramuri̱n nekaawar, Jesusan káutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Untsurí̱ káunkar chanuntawara̱i̱ṉ tusa Jesus ni unuiniamuri̱n kanuram inianáastarum tusa seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kame untsurí̱ shuaran Jesus nuik tsuaru asamtai, jaa shuar nui̱ káunkarmiania nu Jesusan antiṉtaj tusar shitianainiakui nuna seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tura iwianchrukusha Jesusan wáinkiar tikishmatrarmiayi. Untsumainiak “Ame nekas Yusa Uchirí̱nme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tura nuna etserkairap tusa Jesuska kakantramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nuyá Jesus náinnium wakamiayi. Tura anaikiatniun wakerimia nú shuaran untsukmiayi. Tura niisha Jesusan weriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tura Niiji̱a̱i̱ wekasar Yus-Chichaman unuiniartinian tuse shuáran anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tura suṉkur tsuártinian, iwianchcha ji̱i̱ki akupkatniun ni kakarmari̱n súsarmiayi nú shuaran. ");
INSERT INTO jivNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ju̱ shuáran anaikiamu ármiayi: Semuṉ, Jesus chíkich naarin Pítiur apujtusmiania nu; ");
INSERT INTO jivNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sepetéu uchiri̱ Jakupu, ni patai Juáṉsha; ipiamtaja̱i̱ métek kakaram ásarmatai nuna mai “Puanérjis” naari̱ susamiayi. Nusha shuar chichamja̱i̱ṉkia “ipiamta nuke” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nuyá Antressha, Jiripi, Parturumí, Mateu, Tumas, Arpeu uchirí̱ Jakupu, Tateu, ásump Semuṉ, ");
INSERT INTO jivNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jútas Iskariúti. Jesusan ukunam surukmia nú Jútasauyayi. Anaik amukmatai je̱á waketrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Waketkiarmatai, ti untsurí̱ shuar taarmatai takatri̱ ti akui, yurumátniun jeacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesusa shuári̱sha nuna nekaawar Jesus ti itiurchat pujus wáurtsuash tu enentáimsar jukitiai tusar nu je̱a̱nam jeariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nuyá Israer-shuara jintinniuri̱ Jerusaréṉnumia̱ táarmiania nu, Jesusan áujmatainiak “Pirsepú eṉkea asa iwianchrukuiti. Tuma asa uunt iwianchi kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki akupeawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tutai Jesus winitiarum tusa nin untsukmiayi. Tura enentáimtikrataj tusa ju̱na tímiayi: “¿Iwianch Satanáskesha itiur ajapmamatiṉ? ");
INSERT INTO jivNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chikichik nú nuṉkanmaya̱ shuar nuámtak kajernaiyakuiṉkia, nu nuṉka wari meserchattawak. ");
INSERT INTO jivNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nuámtak shuar ni shuari̱ji̱a̱i̱ kajernaiyakuiṉkia nu shuarsha amunaikchartatuak. ");
INSERT INTO jivNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Núnisaṉ ¿Satanáskesha ni suntari̱ji̱a̱i̱ máaniakka itiurak tuke pujusarat? Amunaikiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Náṉkamas shuar kakaram shuara je̱e̱n wayá, nérenniun jiṉkiatsuk ni kuítri̱n kasarkachminiaiti. Antsu nérenniun jiṉkiá ni kuítri̱n kasarkamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nekas tájarme, shuar tunáa ashí túruiniana nuka tsaṉkuramniaiti. Winiasha winia Aparnasha yajauch áujmatusha tsaṉkuramniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Antsu Yusa Wakaní̱n yajauch áujmatna nuka tsaṉkurachminiaiti; antsu nu shuar niṉki tuke sumamattawai.” ");
INSERT INTO jivNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Jesuska iwianchrukuiti” tuíniakui Jesus nuní tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nuyá ni yachi̱ ni nukurí̱ji̱a̱i̱ taar a̱a̱ wajasar, Jesusan untsukat tusa akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Shuar Jesusan téntak pujuarmia nu tiarmiayi “Iis, nukusha, yatsumsha a̱a̱ wajasar untsurmainiawai.” ");
INSERT INTO jivNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tutai Jesus chichaak “Ya ainia winia nukursha yatsursha” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nin téntakar pujuarmia nuna iis “Jú̱iti winia nukurka, yatsurka, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Shuar Yusa wakeramuri̱n uminiana nu winia yatsuruiti, winia umaruiti, winia nukuruiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nuyá jiinki antumiaṉka yantame̱n Jesus ataksha unuiniartinian juarkimiayi. Tura untsurí̱ shuar iruntrarmatai, kanunam eṉkempramiayi. Shuarsha antumiaṉka káanmatkari̱n pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesuska métek-taku chichamja̱i̱ ti jintintiármiayi. Jintintiuk ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Antuktarum. Atsaamin atsaamprataj tusa jíinkimiai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Atsaamkui ni arakri̱ jintiá iniararmai. Chiṉki yakiya̱ káutkar yuawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chikichcha kaya írunmanum iniararmai, nuṉka ishichik ámanum. Tura nuṉka ishichik asamtai wárik tsapainiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tura etsa etsantar sukuám kaṉkape̱ atsá asamtai káararmai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chikichcha jaṉkí nupanam iniararmai. Jaṉkisha tsapainiar kaṉkar ajakrarmai; túram nerekcharmai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Chikichcha péṉker nuṉkanam iniararmai. Tura tsapainiar nerekarmai, chíkich trainta, chíkich sesenta, chíkich siaṉ nerekarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kuíshim ákuiṉkia antuktarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Untsurí̱ wearmatai, ishichik Niiji̱a̱i̱ juakarmiania nu, ni tuse unuiniamuri̱ji̱a̱i̱ aniasarmiayi “¿Ame jintintiamna nusha warimpiait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tutai Jesus chichaak “Yuska ni akupeamuri̱n atumin paant nekamtikramattsa wakerutmarme. Antsu chíkich shuarka aya métek-taku chichamja̱i̱ jintintiáwartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Íiniayataṉ wáinkiacharat tusa, antukarsha nekaacharat tusa, umirtsuk ni tunaari̱ tsaṉkurnacharat tusa túrattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tura tímiayi ‘Wi jintintiajrumna nú métek-taku chicham nekaachurmek. Nu nékachkurmeka ¿itiurak chíkich métek-taku chichamsha nekaatarum? ");
INSERT INTO jivNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Atsaamniua nuka Yus-Chichaman étserna nuna nakumui. ");
INSERT INTO jivNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jiṉkiái jintiá iniaarua nuna chíkich shuar ántuiniamun nakumui. Nu shuar chichaman ántuiniawai. Tura antukarmatai Satanás wárik tarí ni enentái̱n atsaampramun jurawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chíkich shuar ántuiniamu kayanam atsaampramua núniskete. Niisha chichaman antukar wárik warainiak umiktasa wakeruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tura ni kaṉkape̱ atsakui, aya ishichik katsuiniawai. Tura ukunam, Yus-Chichaman wakeruiniakui shuar kajeram tura chíkich itiurchatan wáinkiar Yúsai̱ya̱ kanainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Chíkich ántuiniamuka jaṉkí nupanam atsaampramua núniskete. Nu shuar Yus-Chichaman ántuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ántuiniayat ju̱ nuṉkanam ana nuna ti páchiniawai. Tuma ásar kuítian tura shiirmachin ti takustinian wakeruiniawai. Nú wakeramu ni enentái̱n Yus-Chicham ana nuna kaṉkar emeṉkatui. Tuma asamtai nerektinian tujintiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tura chíkich ántuiniamusha péṉker núṉkanam atsaampramua núniskete. Nú shuarsha Yus-Chichaman antukar umiiniawai. Tura nerenawai, chíkich shuar trainta, chíkich shuar sesenta chíkich shuar siaṉsha nerenawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nuyá Jesus ju̱na tímiayi ‘¿Shuar shiripkin ekeemak itiá pitiaknum eṉkeattawak. Peaknum wakenam ikiustatuak? Atsá. Antsu misanam ekentsashtinkiait. ");
INSERT INTO jivNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Núnisaṉ ashí u̱u̱kma ana nu ukunam paant nekanattawai. Tura núnisaṉ yamái ishishmasa chichasmasha ukunam paant nekanattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kuíshim ákuiṉkia antuktarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tura nuyá tímiayi ‘Ántarmena nu esetrarum enentáimsarum antuktarum. Urutá péṉkerak enentáimsatarum, núnisaṉ Yuska ámin nekaatniun suramsattarme, tura nú núkap patatramsattarme. ");
INSERT INTO jivNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tuma asamtai shuar núkap takakna nu patatnastatui. Antsu chíkich shuar ishichik takakuk jurunkittiawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nuyá Jesus chichaak ju̱na tímiayi ‘Yusa akupeamuri̱ jú̱nisaiti. Shuar jiṉkiain atsaampratniua núniskete. ");
INSERT INTO jivNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jiṉkiáin atsaamar, untsurí̱ kanar, tsawa̱r, uruksanpi tusa nákawai. Tura itiura tsapainia núnaka nékatsui. ");
INSERT INTO jivNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kame jiṉkiái nuṉkanam init aku niṉki tsapaatsuk; emka nukareawai, nuyá tuyu̱reawai tura nujamar katsua̱wai. ");
INSERT INTO jivNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Túruna káakmatai júuktin tsawant jeayi tusar juíniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ataksha Jesus tímiayi ‘¿Yusa akupeamuri̱ wariji̱a̱i̱ṉkⁱ nakumkataj. Wariji̱a̱i̱ṉkⁱ métek-takuit? ");
INSERT INTO jivNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mustasa jiṉkiaí araamua nuja̱i̱ métek-takuiti. Nu jiṉkiaisha ashí naṉkaamas ishitiupchichiti. ");
INSERT INTO jivNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tura araam tsapái̱ ashí naṉkaamas uunt ajawai; tura tseṉkeakmari̱sha kámpuram asamtai nui̱ mikintranam chiṉkisha shiir ayamainiawai.” ");
INSERT INTO jivNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Núnisaṉ Jesus untsurí̱ métek-taku chichamja̱i̱ Yus-Chichaman ujaamiayi. Nii nekaatniun jearmia nunak ujaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chíkich shuaran aya métek-taku chichamja̱i̱ ujaamiayi; antsu ni unuiniamuri̱ji̱a̱i̱ Niṉki pujus ashí paant jintintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nu tsawantai̱ etsa akaikimtai Jesus ni unuiniamuri̱n chicharainiak “Entsa amain katiṉtai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tutai kanunam eṉkemprarmiayi. Chíkich shuarnaka káanmatkanam ikiukiar Jesusan kanunam pujan júkiarmiayi. Chíkich kanunmaya̱sha atampriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tura nase̱sha ti nasenkatasa naṉkammiayi; chíchimi kanunam yaráná piáktasa ajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuska kanú seṉkari̱n atamprus kanúu tepemiayi. Tura, ni unuiniamuri̱ Jesusan ishintiak chicharuk “Uunta ii waya̱jnia ju̱ka pachitmatsmek” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tutai Jesus nantaki nase̱n kakantramiayi. Entsancha chicharuk “Takamatsata. Miaku ajasta” tímiayi. Tutai nase̱sha meṉkakamiayi, entsasha miaaku ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Túrunamtai Jesus ni unuiniamuri̱n chicharainiak “¿Urukamtai ashamarum? Itiura Yus nekas enentáimtatsrum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tura imiá ashamainiak “¿Maa ju̱sha yait? Nasesha entsasha nin umirainiatsuk” tunaiyarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nuyá antumiaṉ amaini Jatara nuṉkanam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus kanunmaya̱ jiinkimtai áishmaṉ iwianchruku, shuar jakáa iwiartainiumia̱ wárik taa Jesusan iṉkiuṉmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nu shuar iwiartainium tuke pujuyayi. Tura jiruja̱i̱nkia nin jinkiaatniun tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jiruja̱i̱ nawenmasha, uwejnumsha tuke jiṉkiau ármiayi. Túramaitiat jinkiaarman tsuriar tepet-tepet awajmiayi. Tura ti kakaram asamtai nin nupetkachminiuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tuke tsawai̱sha káshisha, iwiartainiumsha murasha kayaja̱i̱ ijiumak untsumuu wekainiuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tura yajaya̱ṉ wáiniak Jesusan tseke̱ tarimiayi; tura tikishmatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Túrunamtai Jesus chicharuk “Iwianchiá, ni enentáiya̱ jiinkitia, tájame” tímiayi. Takui íwianch kakantar chichaak “¿Winiasha urukamtai tarutnium, Uunt Naṉkaamaku Yusa Uchiri̱ Jesusá? Yus iirmanum wáitkiarsaip, tájame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Takui Jesus tímiayi “¿Ame náarmesha yait?” Tutai niisha aya̱k “Untsurí̱ ásar wikia Untsurí̱-suntar tu anaikiamuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nuna ti̱ amik, nu nuṉkanmaya̱ akuptuka̱i̱ṉ tusa Jesusan ti seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nui̱sha nainnium nuntumas untsurí̱ kuchi shushuṉmak matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuma asamtai, kuchiniam eṉkemátin tsaṉkatrukta tusar Jesusan seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tuiniakui Jesus “ayu” tímiayi. Takui íwianch áishmaṉkai̱nia̱ jíinkiar kuchiniam eṉkemáwarmiayi. Kuchisha ti untsurí̱, jimiará mir (2.000) áchiawash. Ashí mash nánatanam iniaawar antumiaṉnum iniaṉkarmiayi. Nui̱sha entsá ki̱akar jakerarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Túrunamtai kuchin wáinin pisarar péprunmasha shuarnumsha nuna etserarmiayi. Tuma asamtai iyutai tusar ashintiukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Túrawar Jesusa̱i̱ jeawarmiayi. Jeawar áishmaṉ yaunchu iwianchrukun yamaikia péṉker ajasun pushiri̱n entsar pujan wáinkiarmiayi. Wáinkiar ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tura waketkiar kuchi túrunamuncha iwianchruku péṉker ajasmancha mash etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tuma asamtai ni nuṉke̱ya̱ jiinki wetá tusa seawarmiayi. Jesus kanunam eṉkemamtai áishmaṉ nuik iwianchruku amia nu Jesusan chicharuk ");
INSERT INTO jivNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","“Wi Ámiji̱a̱i̱ tuke tsaniṉkian wekasatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tura núnaka Jesus suritkiamiayi. “Antsu ame je̱e̱mi̱i̱n, áminiurmi̱i̱n weme, ashí Uunt Yus túrutma nu tura waitnentrampra nusha ujakarta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tutai áishmaṉsha wémiayi. Tura antsu Tekapuris nuṉkanam Jesus nin péṉker awajsamia nuna ashí shuaran ujakmiayi. Nu nuṉkanmaya̱ shuarka nuna antukar ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ataksha Jesus kanuja̱i̱ katiṉmatai, aents untsurí̱ Nin irunturarmiayi. Jesuska antumiaṉka káanmatkari̱ wajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tura Israer-shuar iruntai̱ je̱a̱ náampruku, ni naari̱ Jairu, támiayi. Taa, Jesusan wáiniak, piniakum tepersamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Piniakumar ti seak, “Winia nawantur jarutui. Winitiá, túram péṉker ajasat tusam uwejmi̱ji̱a̱i̱ antintrukta. Nuiṉkia jarutkashtatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tu tímiatai Jesus niiji̱a̱i̱ wémiayi. Tura untsurí̱ shuar wena ásar Nin chánuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nui̱ pachitkia nuwa̱ ti jaa wémiayi. Niisha tuse uwí numpan ajapeak wáitias pujuyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ti untsurí̱ tsuakratin nincha iisu armiayi. Tura iyamsha ti wáitias pujuyayi. Tura ni kuítri̱ncha ashí ajapaitiat tsuámarchauyayi; antsu tsuamsha nu arant ajauyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nu nuwa̱sha, Jesus túramun antuku asa, ni ukuurini̱ amainia̱ṉ ni pushiri̱n antiṉmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Wi aya ni pushiri̱n antiṉnaka péṉkerapi ajasaintjia” tu enentáimiar túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tura Jesusa pushiri̱n antiṉ nú chichamaik numpa ájapman meṉkakamiayi. Péṉker ajasman aya̱shi̱i̱n nekapramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tura nuiṉ Jesuska, ni kakarmari̱ji̱a̱i̱ tsuarman nekapmampramiayi. Tura nuna nekáa, ayantar chichaak “¿Yaki winia pushirun antintruka?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tutai ni unuiniamuri̱ tiarmiayi, “Untsurí̱ Ámin antinmainiasha ¿urukamtai “yaki winia antintkia” tame?” ");
INSERT INTO jivNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tura Jesus, yaki túruta tusa ashi íimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nuiṉkia nuwa̱sha, ni aya̱shin túruna nuna nekáa, ti ashamak kuraimiayi. Tura Jesusan jeari̱ tikishmatramiayi. Tura ni túrunamuri̱n ashí paant ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Takui Jesus nin chicharuk “Nawantru, Winia nekas enentáimtursa asakmin, péṉker awajtamsaitme. Shiir wetá, tura tuke péṉker pujusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tura Jesus nuna tuke chichas pujai̱, iruntai je̱a̱ uuntri̱ je̱e̱nia̱ tariarmiayi. Tariar chicharainiak “Ame nawantrum jakayi. ¿Urukamtai Unuikiartin tuke itit awajsatam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tura Jesuska, nii tiarmia nuna ántayat, núnaka pachitsuk, iruntai je̱a̱ uuntri̱n chicharuk “Ashamkaip; áyatik nekas enentáimtursata’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tura Niiji̱a̱i̱ wétinian aya Pítruncha, Jakupuncha ni yachi̱ Juaṉja̱i̱ tsaṉkatkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iruntai je̱a̱ uuntri̱ je̱e̱n jeawar, áentsun charaatum ajainian, úutainian untsumuk ajainiancha Jesus wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tura nuwa̱ch peṉké jakan nékayat, wayá nin chicharuk “¿Urukamtai timiá úutrum, tura wa wa ajarum? Nuwa̱ch jákachai, antsu kanarai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nuna takui wishikrarmiayi. Tura Jesus ashí ji̱i̱r akupkarmiayi. Áyatik nuwa̱chi̱ aparí̱n, nukurí̱ncha tura Niiji̱a̱i̱ táaruncha nuwa̱chi̱ tepamuri̱n jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tura waya̱war Jesuska nuwa̱chi̱ uweje̱n achik tímiayi “Taritia kumi.” Nusha shuar chichamja̱i̱nkia “nawantrú nantáktiá” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nuwa̱ch tuse uwí takakuya nu, nú chichamaik nantaki wekasamiayi. Túramtai nui̱ pujuarmiania nu ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuska chichaak “Atumsha peṉké etserkairap’ tímiayi. Tura “nuwa̱ch ayuratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus nuyá jiiṉki ni nuṉke̱n waketkimiayi. Ni unuiniamuri̱sha nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nui̱sha ayampratin tsawant jeamtai Israer-shuar iruntainiam wayá unuiniamiayi. Tura Jesusan anturkarmiania nu ti enentáimsarmiayi. “¿Ju̱sha tui̱ unuimiaruit. Ni nekaatniuri̱ncha yaki susait. Tura aentsti tujintiajnia nuna Niisha itiurak tura? ");
INSERT INTO jivNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ju̱sha karpintíruchukait; Maríi uchirí̱nchukait. Ni yachi̱sha Jakupusha, Jusesha, Jútassha, Semuṉsha nékatsjik. Tura ni umai̱sha ju̱i̱ iiji̱a̱i̱ pujuiniatsuk” tiarmiayi. Túrawar Nin nekas enentáimtustinian tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Túrasha Jesus nin chicharuk “Yúsnan etserniun chíkich nuṉkanmaya̱ṉka shiir anturainiawai. Antsu ní nuṉkeya̱ṉka, ní shuarsha anturainiatsui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tura nui̱sha, ni nuṉke̱nkikia aentsti tujintiamun túratniun tujinkiamiayi. Antsu jaancha aya ishichik ni uwe̱je̱ja̱i̱ antiṉ tsuármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tura nekas enentáimtacham “¿urukamtai nusha?” tu enentáimsamiayi. Nuya̱sha chíkich péprunam wayá, chíkich péprunam wayá Yus-Chichaman unuíniakní wekaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tuse unuiniamuri̱n untsuk jímiarchik jímiarchik werum Yus-Chicham etserkatarum tusa akupkarmiayi. Tura iwianchin nupetkarat tusa ni kakarmari̱n súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tura chicharuk “Jintiá yurumátniusha jukiirap, uyu̱ntrumi̱i̱ncha kuitcha eṉkearum jukiirap. Antsu aya áanik mashtuṉ jukiirum wetarum. ");
INSERT INTO jivNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapat uwekatarum, tura entsartincha jímiar jukiirap, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tura je̱a̱ waya̱rmena nui̱ṉ pujustarum; pujá-pujakuarum nuyá chíkich peprunmasha wetarum. ");
INSERT INTO jivNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tura náṉkamas aents atumin awaintiamainiachkuisha, anturtamainiachkuisha, nuyá jíinkirum, nu shuar yajauch áiniawai tusarum, atumí nawe̱ nuṉka akakekrum ikiuktiarum. Kame Yus áentsun nekapsattana nú tsawant jeamtai, nu shuarnaka asutiattawai. Sutuma péprunmaya̱ shuarja̱i̱ tura Kumura péprunmaya̱ shuarja̱i̱ naṉkaamas nin asutiattawai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nuyá Jesusa unuiniamuri̱ jíinkiar enentái yapaji̱ar Yúsai̱ enentáimtumartinian etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tura iwianchruku enentái̱ya̱ iwianchin ji̱i̱rki akupkarmiayi, tura asuitiji̱a̱i̱ yakarar untsurí̱ jáinian tsuararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesusa náari̱n tura ni túramuri̱n ashí aents áujmatin ásarmatai, uunt akupin Erutis nuna antukmiayi. Erutiska “Imiakratin Juaṉ jakamunmaya̱ nantakni. Tuma asa ti kakaram takaawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tura chíkich shuar “Eríasaiti” tiarmiayi. Chikichcha “Yúsnan etserniuiti, yaunchu etserniuya núkete” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erutis nuna antuk “Nekas Juáṉkaiti. Ni muuke̱n tsupiktinian akupkamiaj nu, jakamunmaya̱ nantakniuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Kame Uunt akupin Erutis, ni yachi̱ Jiripi nua̱ri̱n nuatkamiayi. Nu nuwa̱ naari̱ Jirutíasaiti. Juaṉsha uunt akupniun Erutisan chicharuk “Yatsumi nua̱rí̱ akintrukchatniuitme’ tímiayi. Tutai nuwa̱ Jirutías Juáṉkan ti kajerkamiayi. Tura Juáṉkan máataj tusa wakerimiayi. Túrasha uunt akupin Erutis nuna surimkiamiayi. Antsu Juaṉ achikrum sepunam eṉkeatarum tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juaṉsha tuke enentáiji̱a̱i̱ Yusa jinti̱n wekainiuyayi. Erutis, ni esetar enentáimniun neka asa Juáṉkan ashamak Jirutías wakeramuri̱n túrawa̱i̱ṉ tusa suritkiamiayi. Kame Erutis Juaṉ étserman nékachuitiat antuktinian wakerimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jirutías, itiurak máawaj tu puja̱i̱, uunt akupin Erutis, ni akiiniamu tsawantri̱ jeamtai, ni suntari̱ncha, Kariréa nuṉkanmaya̱ úuntri̱ncha, kuítrintin armia nunasha untsukar, namperan najanamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nui̱sha Jirutíasa nawantri̱ wayá jantsemámtai Erutis tura niiji̱a̱i̱ nampernum matsamarmia nusha shiir enentáimsarmiayi. Túramtai uunt akupin nuwa̱chin chicharuk “Ame wakeram nu seattia. Wi amastatjai. ");
INSERT INTO jivNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nekas tájame, ashí ame seatmena núnaka amastatjai. Wats, seatkumniṉkia takakjana nuna jímiapetek nakakan, amastatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tutai nuwa̱ch jiinki ni nukurí̱n Jirutíasan chicharuk “¿Wariniak seattaj?” tímiayi. Tutai “Imiakratin Juaṉka muuke̱ seata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nu chichamaik nuwa̱ch wari wayá Erutisan chicharuk “Yamaikia uunt amamkunam Juaṉka muuke̱n wakerajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nuna takui uunt akupin ti kuntuts enentáimpramiayi. Tura nii tiniu asa ni amikri̱ matsatainia nu antukaru ásarmatai surimkiatniun tujinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tuma asa uunt akupin Juaṉka muuke̱ itiata tusa ni suntari̱n wárikmas akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Túramtai suntar wari we, sepunam Juaṉka muuke̱n tsupikmiayi. Tsupik, amamkunam itiá, nuwa̱n susamiayi. Túram achik ni nukurí̱n susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juaṉ maamun antukar ni unuiniamuri̱ ni aya̱shi̱n iwiarsatai tusar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tura Jesusa unuiniamuri̱ Nii akupkarma nu, ataksha waketki káunak irunturarmiayi. Ashí nii túrawarmia nuna, unuiniararmia nunasha ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tura untsurí̱ shuar táiniakui, niisha ankant ajastinniasha yurumátniuncha tujinkiarmiayi. Tuma asamtai Jesus chichaak “Iiji̱a̱i̱ wemí aents atsuiniamunam; nui̱ ishichik ayamprarmi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nuyá Jesus ni unuiniamuri̱ji̱a̱i̱ kanunam eṉkemprar, aents atsuiniamunam jeatai tusar jíinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Túrasha shuar ni wéenan wáinkiarmiayi. Tura “Jesusaiti” tiarmiayi. Tuma ásar ashí péprunmaya̱ untsurí̱ shuar tseke̱ ashintiukar, ni jeatniunam nákakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus kanunmaya̱ jiinki ti untsurí̱ aents iruntrar matsatun wáinkiamiayi. Murik péṉker wáinchatai̱ya núnisaṉ matsatu ásarmatai Jesus nin wáitnentrarmiayi. Tura núkap unuiniararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nuyá ki̱akui ni unuiniamuri̱ Jesusan tariar chicharainiak “Atsamunam pujatsjik; tura yamái kí̱atsuk. ");
INSERT INTO jivNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Shuar wari akupkarta. Tíjiu̱ch péprunmasha, shuarnumsha wearti, ni yurumkari̱ sumarmakaratⁱ” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tutai Jesus chichaak “Atumek ayuratarum” tímiayi. Tutai “Iisha ju̱ shuar ayuratai tusar, ¿jimiará siaṉ kuitja̱i̱ yurumak sumaktai tusar wétinkiaitiajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tura Jesus ni unuiniamuri̱n chicharainiak “Tanta takakrum nu iistarum ¿urutmak aa?” tímiayi. Tutai nekapmarar chichainiak “Tántaka séṉkuchikiiti, tura namaksha jímiarchikiiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tutai Jesus tímiayi “Ju̱ shuar chírichriniam pujusarti tusar akupkatarum.” ");
INSERT INTO jivNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aṉkant aṉkant siaṉ siaṉsha, seṉkuenta seṉkuenta iruntrar matsamsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesuska seṉku tantancha, jímiar namaknasha jusa, yakí nayaimpinmaani̱ íimias Yúsan yumiṉsamiayi. Tura yurumkan púurmiayi. Puur ni unuiniamuri̱n súsarmiayi. Namaknasha puur súsarmiayi, ashí shuáran ajamsarat tusa. ");
INSERT INTO jivNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ashí yurumáwar ejemararmatai, ");
INSERT INTO jivNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","puunaruncha, namak ampirmancha achikiar, tuse chaṉkinian áimkiar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nu yurumkan ti untsurí̱ yurumáwarmiayi. Aya áishmaṉkak seṉku mir (5.000) ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nuyá Jesus ni unuiniamuri̱n chicharainiak “Kanunam eṉkemprarum, katiṉkrum amain émaa ajatarum, Petsaitia péprunam. Wisha ju̱ shuaran áujsan ikiuktiatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Shuáran áujas ikiuki Yusja̱i̱ chichastaj tusa náinnium wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tura kirit ajasmanum kánuka antumiaṉnum ajapén nanammiayi. Jesuska niṉki juakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesusa unuiniamuri̱sha wia-wiantainiakua ti pimpikiarmiayi, nase̱ tukumma ásar. Nuna Jesus wáiniak tsawa̱rtin ishichik ajasmatai entsá pátatek wekas nin jeariarmiayi. Tura naṉkaamaktiasa wea núnisaṉ wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesus entsá wekaan ni unuiniamuri̱ wáinkiar, wakanchashit, tu enentáimprarmiayi. Túrawar ti untsumkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ashí wáinkiar ti ashamkarmiayi. Tura Jesus wárik nin chicharuk “Kakaram ajastarum, wíitjai Jesus; ashamprukairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Nuiṉkia entsaya̱ kanunam waka eṉkempramiayi. Túramtai nase̱sha majaantmiayi. Ni unuiniamuri̱nkia enentái̱ kiritia áintsaṉ ásarmatai Jesus yurumkan núkap awajsamia nuna paant nekaatniun tuke tujinkiarmiayi. Tuma ásar yamái túrunamu itiurak aankia tusar ti enentáimprar sapijmiakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nuyaṉka kati̱ṉkiar, Jinisarít núṉkanam jeawarmiayi. Jeawar kanun ajui̱niarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanunmaya̱ jíintrarmatai, nu nuṉkanmaya̱ shuar Jesusan nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tura “Jesus pujawai” táman antukar, ashí je̱a̱nmaya̱ jaan ni peakrintiuk Jesus pujamunam itiaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tura Jesus wekaak wémia nui̱sha, péprunmasha, shuar matsatmanumsha, ishichik matsatkamunmasha jaan itiariar jintiá áeprusarmiayi. Túmainiak Jesusan pushirmin antiṉtaj tusar seawarmiayi. Tura ashí antiṉkiarmia nuka péṉker ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pariséusha, Israer-shuara jintinniuri̱sha Jerusaréṉnumia̱ Jesusan tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tura Jesusa unuiniamuri̱n ikijmiatsuk yurumun wáinkiar “Israer-shuara túrutairi̱n túruiniatsui” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kame Pariséusha, tura ashí Israer-shuarsha, ni uuntri̱ jintintiamuri̱n umikiar ti núkap ikijmiarar yurumin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Péprunmaya̱ tari “ikijmiatsuk yurumáshtiniaiti” tiniu ármiayi. Tura ti untsurí̱ ni uuntri̱ túrutairi̱ núnisaṉ ármiayi. “Tsapancha, ichiṉnasha, jiruncha, peaknasha nijiakartiniaiti” tiniu ármiayi.) ");
INSERT INTO jivNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tuma asamtai Pariséusha, Israer-shuara jintinniuri̱sha Jesusan chicharainiak “¿Urukamtai ame unuiniamuram ii uuntri̱ jintintramniuitiaj nuna túruiniatsu. Urukamtai ikijmiatskesha yurumáinia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tutai Jesus tímiayi “Ántar chichamtiniaitrume. Isayas yaunchu nekas atumin áartampramiayi ju̱na: Ju̱ aents ni wene̱ja̱i̱ Winia “ti pénkeraiti” turutainiawai, tímiayi Yus, tura ni enentái̱nkia jeachat pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tura tukeneas Winia shiir awajtuiniawai. Aentsu chichame̱ jintiainiayat, “Yus-Chichamaiti” tuíniawai.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tura átum Yusa chichame̱ iniaisarum, aentsu jintintiamuri̱ umirkarum, ichiṉnasha, tsapancha nijiaktin, tura chíkich túrutaisha áintsarmek untsurí̱ túrarme. ");
INSERT INTO jivNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Túrákrum Yus-Chichamka tsukintiaani ikiusurme atumí uuntri̱ chichame̱ umirkatai tusarum. ");
INSERT INTO jivNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kame Muisais yaunchu aar ju̱na tíchamka: Ame apa nukusha shiir enentáimtustarum. Tura ataksha áarmiayi: Shuarsha ni aparí̱n, nukurí̱ncha yajauch chichareakka, nu shuar jákatniuiti. ");
INSERT INTO jivNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Túrasha átumka Pariséutirmeka, antsu ju̱ tárume: “Shuar ni aparí̱n ni nukurí̱n chicharuk “Wi yáiṉtinian takakjana nu Kurpanaiti” takuiṉkia, atumsha péṉkeraiti, apari̱ncha nukuri̱ncha yáiṉchatí” tarume. (Kurpan tana nuka, Yus susamu, tawai.) ");
INSERT INTO jivNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nekaatarum, Pariséutiram. “Ií yaunchu uuntri̱ chichame̱ tuke umiki wétiniaitji” tákurum, Yus-Chicham peṉké ántar chichama núnin awajearme. Núnisrumek chikichcha untsurí̱ túrarme.” Tu timiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nuyá ataksha Jesus ashí shuáran untsukar “Mash anturtuktarum, ashí nekaatarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","A̱a̱ya̱ aya̱shnium waya̱a̱na nu, shuáran yajauch awajsachminiaiti; tura antsu ni enentái̱nia̱ jiinia nu, yajauch awajsattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Shuar nuna ántakka enentáimprati” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nuyá áentsun ikuiak, je̱a̱ waya̱mtai, ni unuiniamuri̱ aniasarmiayi “¿Nu métek-taku chicham warintiua?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tutai Jesus tímiayi “Atumsha nékatsrumek. Páantchakait; yurumak yúajnia nu, enentáiniam waya̱chu asa, shuáran yajauch awajsachminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Antsu wakenam wayá, naṉkaamas meṉkaatsuk” tímiayi. Nuna taku, ashí yurumak páchitsuk yuamniaiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nuyá tímiayi “Shuara enentái̱nia̱ jiinia nu, yajauch awajsamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Shuara enentái̱nia̱, initia̱, yajauch enentáimsatniusha, tsanirmatniusha, natsa tsanirmatniusha, shuar máatniusha, ");
INSERT INTO jivNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kasamkatniusha, chikichna wakeruktincha, péṉkercha túratniusha, anaṉkatniusha, natsantain átincha, yajauch enentáimtustincha, tsanumpratniusha, waantu enentáimtumastincha, netse túratniusha, ashí nuka initia̱ wininiatsuk. ");
INSERT INTO jivNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ashí nu tunáa ainia nu, shuara enentái̱nia̱ jíiniu asa, shuáran yajauch awajainiawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tiru pepru, Setúṉ péprusha Serupinísia nuṉkanam ámiayi. Nuka Israer-shuara nuṉke̱nchauyayi. Nu nuṉkanam Jesus wémiayi. Tura jeá, je̱á wayáa̱ pujusmiayi. Tura nui̱ pujamun nu nuṉkanmaya̱ shuar nekarawara̱i̱ṉ tusa nakitmiayi; túrasha u̱u̱mkatniun tujinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wárik nu nuṉkanmaya̱ nuwa̱ Jesus pujan nekaamiayi. Nu núwa̱ka nawantri̱ iwianchrukuyayi. Tuma asa Jesusan tarí ni nawe̱n piniakum tepersamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nu nuwa̱ Israer-shuarcha, Serupinísianmaya̱uyayi. Túmaitiat, nawantru enentáiya̱ iwianchin ji̱i̱rturkitia tusa Jesusan seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tutai Jesus nuwa̱n chicharuk “Uchi emka ejemarartí. Uchi apatkuri̱ atankir yawa̱ch súsatin péṉkerchaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tutai nuwa̱ ayak “Nekas, Uunta, tame. Tura yawa̱chisha misanam wakenam pujuinia nu, uchi apatkun yurumuk juyumak kákeamun yuíniatsuk” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tutai Jesus tímiayi “Péṉker tame. Tuma asam, shiir wetá; ame nawantrumi̱ enentái̱ya̱ iwianch jíinkiyi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Takui niisha wémiayi. Tura ni je̱e̱n jeá, ni nawantri̱n íwianch jíinkimtai péṉker ajas peaknum tepan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus Tirunmaya̱ jiinki Setúṉ péprunam naṉkaamarkutak, Tekapuris nuṉkanmaani naṉkaamaki, Kariréa antumiaṉnum ataksha jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nui̱ chichachu ámiayi, kuishi̱n empeku. Nu shuáran Jesusan itiariar, ni uweje̱ja̱i̱ antiṉkiat tusar seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Shuar matsatmanumia̱ Jesus nin akanki jukí kuishi̱n tsara uweje̱ja̱i̱ tsutsukruamiayi. Tura usukia, nu shuara iniai̱n antintkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tura nayaimpinmaani̱ íimias súkaska mayati “Epata” tímiayi. Nuka, shuar chichamnumka “chinkiatí” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nu chichamaik ni kuishi̱sha chiṉkiamiayi, iniai̱sha séermiayi. Tura paant chichasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tura Jesus chicharainiak “Peṉké etserkairap” tímiayi. Jesuska surí-suritiamaitiat, nu naṉkaamas etseriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tura ti enentáimprarmiayi. Enentáimprar, “Ju̱ Jesus aya péṉkeran túrawai. Empekuncha ántumtikniaiti, tura chichachun chichamtikniaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nu tsawantái̱ shuar timiá untsurí̱ iruntrarmiayi. Yurumkari̱ atsakui Jesus ni unuiniamuri̱n untsukar ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ju̱ shuáran waitnentajai. Menaintiú tsawant Wiji̱a̱i̱ pujuinia ásarmatai ni yurumkari̱ amuukachaik. ");
INSERT INTO jivNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tura ni je̱e̱n ayurtsuk akupeamka, tsukari̱i̱n jintiá pimpikiartatui, yajaya̱ káunkaru ásar” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tutai ni unuiniamuri̱ chichainiak “Túrasha ju̱i̱ atsamunam, ju̱ aents ejemararat tusar ¿tuyá yurumkak wáinkiattajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tutai Jesus nin aniasmiayi “¿Urutmá tanta aa?” Tutai “siati awai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nuiṉkia ashí áentsun “nuṉká pujustarum” tiarmiayi. Tura tantan achik, Yúsan yumiṉsamiayi. Tura puuk, áentsun ajamsatarum tusa ni unuiniamuri̱n susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tura uchich namaksha ishichik aan achik, Yúsan yumiṉkias, ni unuiniamuri̱n chicharuk “Ju̱sha shuar ajamsatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Turam ashí yurumáwar ejemararmiayi. Ampirma púunaruncha siati chaṉkinnium áimkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kuatru mir (4.000) shuar yurumáwarmiayi. Yurumáwar amikiarmatai, Jesus nin áujas akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tura ni unuiniamuri̱ji̱a̱i̱ kanunam eṉkemprar Tarmanúta nuṉkanam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pariséu Jesusja̱i̱ áujmatsatai tusar tariarmiayi. Nekapsatai tusar wakeruiniak Nin chicharuk “Nayaimpinmaya̱ kakaram iniakmasta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tuíniakui Jesus kúntuts enentáimias, súkaska mayati “¿Urukamtai, yamaiya̱ aentstiram, nayaimpinmaya̱ kakarman iniakmasat tusarum wakerarum? Nuka peṉké sunaschattarme, paant tájarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nuyá nin ikiukiar ataksha kanunam eṉkemar amain katiṉmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tura ni unuiniamuri̱ yurumak jukitiai tukamá kajinmatkiarmiayi. Kanunmaṉka aya chikichik tantanak takaku ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesussha ni unuiniamuri̱n enentáimtikiuk tímiayi “Wáinkiatarum; Pariséusha Erutissha wakaprutain takakainia núja̱i̱sha aneartarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tutai ni unuiniamuri̱sha tunaiyarmiayi “Tanta kajinmatkin asakrin nuna túramtsujiash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tura Jesus nuna nekáa chichaak “¿Urukamtai aya yurumkak enentáimtarum? Tuke nékatsrumek. Peṉké enentáimtsurmek. Atumí enentái̱ tuke kiritkiait? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jimi ai̱sha itiura wáintsurmea. Kuíshim ai̱sha itiura ántatsrum. Ashí kajinmatkintrumek. ");
INSERT INTO jivNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nekaatarum, nuik, seṉku tantan púuran seṉku mir áishmaṉkan ayurachmakaj. ¿Tura ampirma urutmá chaṉkinnium chumpiamarum?” tímiayi. Niisha tiarmiayi “Tuse chaṉkinnium chumpiamji.” ");
INSERT INTO jivNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ataksha Jesus tímiayi “Tura siati tantaja̱i̱ kuatru mir shuaran ayuramtai, ¿ampirmasha urutmá chaṉkinnium chumpiamarum?” Niisha “siati” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tuma asamtai Jesus tímiayi “¿Itiura imiá nékatsrum?” ");
INSERT INTO jivNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nuyá Petsaitia péprunam jeawarmiayi. Jeawarmatai, áishmaṉ ji̱i̱ kusurun Jesusan itiariarmiayi. Túrawar antiṉta tusar seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tuma asamtai Jesus uwejnum achik péprunam a̱a̱ni eṉkeki jukí ji̱i̱n usuki̱ji̱a̱i̱ kuérmiayi. Tura uwejé̱ja̱i̱ antiṉ “¿íimmek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tutai kusuru íimi tímiayi “Aentsun iiyajai, túrasha paantcha. Numi wekainian áaniun iiyajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nuyá ataksha Jesus ni uwejé̱ja̱i̱ kusuru ji̱i̱n antiṉmiayi. Tura kusurusha úmamkes iis, péṉker ajas, ashí paant íimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus chichaak “Je̱e̱mi̱i̱n weakum péprunam waya̱waip tura shuar ujakaip” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus ni unuiniamuri̱ji̱a̱i̱ uunt pepru Sesaria-jiripiunam jeatsuk, tíji̱uch uchich péprunam irasarmiayi. Jintiá wésar Jesus ni unuiniamuri̱n chicharainiak, “¿Yaiti turutainiawa Winia?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tutai niisha áimkiarmiayi “Chíkich chichainiak, imiakratin Juaṉkaiti, turamainiawai. Chíkichcha, Eríasaiti, tura chíkichkia, yaunchu Yúsnan etserin nantakniua núiti, turamainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tutai Jesus tímiayi “Atumsha, ¿waritrume. Yáitiaj?” tímiayi. Tutai Pítiur tímiayi “Ámeka Krístuitme; Yúsaiya̱ akupkamuitme.” ");
INSERT INTO jivNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tutai Jesus chichaak “Peṉké etserkairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Unuiniak: “Wi Aents Ajasuitjiana ju̱ ti wáitsatniuitjai. Israer-shuarti ii uuntri̱sha, Patri úuntri̱sha, ii jintinniuri̱sha Winia nakitrurar mantuawartatui. Túrasha menaintiu tsawant naṉkaamasmatai nantaktiniaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nunasha paant ujakmiayi. Tura Pítrusha Jesusan arantach jukí kakantramiayi. “Tu chichasaip” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tutai Jesus ayantmatar, ni unuiniamurí̱n iis, Pítrun kakantar chicharuk “Satanása, werumta. Ámeka Yusna ana nu enentáimtatsme, antsu aya áentsnak enentáimtame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nuna tuasua amik tura nui̱ matsamarmia nunasha, ni unuiniamuri̱ncha untsuk tímiayi, “Shuar Winia nekas nemartustasa wakerakka ni wakeramuri̱nkia iniaisati; tura ni krusri̱ yanaki̱ nemartustí. ");
INSERT INTO jivNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kame shuar ju̱ nuṉkanam aya niṉki anenmamkuṉka nu shuar ni iwiaakmari̱n emeṉkaktatui. Antsu Winia anentu asa tura winia chichamprun anea asa, shuar aya péṉker pujustinniak enentáimtsuna nu, nekas iwiaakman wáinkiattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nekaata, shuar ashí ju̱ nuṉkanam írunna nuna sumaksha túrasha ni wakani̱ jinium wéakuisha, ¿itiurak péṉker pujusaint? ");
INSERT INTO jivNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Shuarka wakani̱n uwemtikrataj tusa wakerak ¿urutmak akikmakaint? ");
INSERT INTO jivNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Antuktarum. Yamaiya̱ aents Yúsan nakitiar ajapawaru yajauch ainia nu íimiainiamunam shuar Winia natsantrakuiṉkia tura winia chichampruncha natsantakuiṉkia, wi, Aents Ajasuitjiana ju̱, winia Aparu kakarmari̱ji̱a̱i̱ tura nayaimpinmaya̱ péṉker suntarja̱i̱ atak taakun, nú shuaran natsantrattajai Wisha.’ Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ataksha Jesus nin chicharuk, ‘Nekas tájarme, shuar játsuk Yus ni kakarmari̱ji̱a̱i̱ aentsu enentái̱n akupkattana nú tsawantan wáinkiartatna nu ju̱i̱ iiji̱a̱i̱ pujuiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nuyá sais tsawant naṉkaamasmatai, Jesus Pítruncha, Jakupuncha, Juáṉnasha uunt náinnium júkiarmiayi. Nui̱sha Jesus nushá iira ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ni pushiri̱sha ti puju jíitsumir ajattsarmiayi. Nuja̱i̱ métek puju awajsatin ju̱ nuṉkanam atsawai. ");
INSERT INTO jivNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Túruna nui̱ Erías, Muisaisja̱i̱ wantinkiar Jesusja̱i̱ chichainian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nuya̱sha Pítiur Jesusan chicharuk “Uuntá, ii ju̱i̱ pujustin ti péṉkeraiti. Menaintiú áakmaktai, Áminiu chikichik, Muisaisna chikichik, Eríasnasha chikichik” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesusa unuiniamuri̱ sapijmainiak, Pítiur wariniak titi nekaachmiayi. Nékachu asa nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tura yuraṉkim tara mikintiu awajsamiayi. Yuraṉminmaya̱ chichaak “Jú̱iti winia aneamu Uchir. Nii anturkatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nuyaṉka ni unuiniamuri̱ ayantmar iiyaj tukamar aya Jesusnak wáinkiarmiayi. Chíkichkia atsuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nuyá náinniumia̱ akainiak Jesus nin chicharuk “Wáinkiarumna nu etserkairap. Wi, Aents Ajasuitjiana ju̱ jakamunmaya̱ nantaatsa̱i̱ṉ nu etserkairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tutai ni tímian ímiatrusaṉ ú̱u̱karmiayi. Tura “jakamunmaya̱ nantaatsa̱i̱ṉ tana nu, ¿wariniak ta?” nuamtak tunainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tura Jesusan aniasarmiayi “¿Urukamtai Israerti ii jintinniuri̱sha, Erías emka tátiniaiti, tuinia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tutai Jesus tímiayi “Nekas Erías ashí iwiarattsa emka tátiniaiti. ¿Tura Aents Ajasunun Yus-Papinium warintiua? “Ti wáitsattawai; Nin nakitrartatui.” Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wi tájarme, Erías nekas táwiti. Támatai, shuar ashí ni wakeriarmia nuna nin túrawarmiayi. Yusa Papiri̱i̱n Eríasa túrunatniuri̱ aarma amia tímiatrusaṉ túrawarmiayi” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tura ni unuiniamuri̱ matsatmanum atak wáketuk, ti untsurí̱ aents káutkar Israer-shuara jintinniuri̱sha niiji̱a̱i̱ tunai pujuinian wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tura aencha, Jesusan wáinkiar warainiak, tséke̱ṉki weriar, áujsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Túrunawarmatai, Jesus chicharainiak, “Warí tunaiyarum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tutai chikichik aya̱k “Uuntá, winia uchirun Ámin itiarjame. Iwianchruku asa chichachuiti. ");
INSERT INTO jivNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Túmakui íwianch eṉkemtakuṉ paat ajiar áepeawai; túram uchisha saun kaput apak nai̱n kátetete awajeawai. Túram kakaakcha ame unuiniamurmin seamjai, jí̱i̱rtukti tusan, túrasha tujintrutkarai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tutai Jesus tímiayi “Yúsan enentáimtichutirmea urutmá tsawantak pujustaj atumja̱i̱. Urutmá katsuntrataj! Uchi itiatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Takui uchin Jesusan itiariarmiayi. Tura íwianch uchin eṉkemta Jesusan wáiniak uchin ajakramiayi. Uchisha chichiptur nuṉká iniaan péper-péper ajakin wenunam saun apakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Túrunamtai Jesus ni aparí̱n aniasmiayi “¿Urutá yaunchu áinkiait?” Tutai ni apari̱ tímiayi “Úchichik áinkiaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tuma asa tuke jutikiú pujurniuiti; jiniumsha apeawai, entsá maataj tusa aju̱aawai. Yaintrukminiaitkiumka waitneasam yaintrukta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tutai Jesus chicharuk “¿Urukamtai, yaintrukminiaitkiumka, tame? Nekaata, shuar Winia nekas enentáimturna nu ashí túramniaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tutai uchi apari̱ kakantar chichaak, “Uuntá, nekas enentáimtajme. Nekas enentáimtustinian táasjana nu yáintkiata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tura shuar untsurí̱ káunainian Jesus wáiniak kakantuk “Empeku chichachu awajin iwianchi jíinkitia, tájame. Jíinkim ataksha waya̱waipia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tura íwianch jiiniuk untsumak uchin we-werkasa ajakar chichichiptu áepkimiayi. Túram uchi jaka ímianis tepemiayi. Túrunamtai untsurí̱ shuar “jakayi” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Támanak Jesus uweje̱n achik awajkimiayi, tura uchi nantaki wajakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tura Jesus je̱á waya̱mtai, niṉki pujusar, ni unuiniamuri̱ aniasar “¿Urukamtai iisha jí̱i̱ktin tujinkiamajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tutai Jesus tímiayi “Ju̱ iwianchkia ijiarmar Yus áujkur ji̱i̱kminiaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nuyá jíinkiar Kariréa nuṉkanmaani naṉkaamakarmiayi. Ni unuiniamuri̱n unuinia asa nu naṉkaamamun nekaawara̱i̱ṉ tusa Jesus nakitmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Unuiniak juna tímiayi: “Wi Aents Ajasuitiaj ju̱na mantamnati tusar achirkar surutkartatui. Tura máamuitiatnak, iwiarsamunmaya̱n menaintiú tsawantai̱ nantaktiatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tura nu chichaman nekaacharmiayi. Nékainiachiat, anintrustinian arantukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nuyá Kapernáum péprunam jeawarmiayi. Tura Jesus je̱á pujus ni unuiniamuri̱n aniniak, “¿Atumsha jintiá winisrum warí áujmatmiarum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tura natsa̱rar pachischarmiayi. Kame jintiá wésar “iiji̱a̱i̱ ¿yaki imiá naṉkaamantu ajasat?” tunainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ni unuiniamuri̱ pachischarmatai, Jesus pujus ashí tuse unuiniamuri̱n irur chichaak “Shuar nekas naṉkaamantu ajastajtsa wakerakka, peejchachia nuke enentáimtumar shuara yáintri̱ atí” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tura uchin itiáa miniakas chichaak: ");
INSERT INTO jivNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Shuar uchin winia naarui̱ shiir awajeakka Winia shiir awajtawai. Tura Winia akuptukua nunasha shiir awajeawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nuyá Juaṉ Jesusan chicharuk “Uuntá, shuar ame náarmin pachis iwianchin akupea wainkiamji. Tura iiji̱a̱i̱ írutkachu asamtai nu túratin suritkiamji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tutai Jesus tímiayi “Antsu suritkiairap. Shuar winia náarun pachis tujinkiamun túrakka, nu shuar wari tsanumprutratniun tujinkiattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Shuar in nakitramachkuṉka, in páchitkiawai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Winia nemarka asakrumin shuar yumiichinkesha ajampramkuka ántar túratsui; akikma átatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Tura shuar ju̱ uchin Winia umirtuinia nuna yajauchin túrumtikiamtaiṉkia, ti asutniattawai. Tuma asamtai uchin yajauchin túrumtiktsa̱i̱ṉ kuntuje̱n kayaja̱i̱ jiṉkiar nayaantsanam ajunmaka maak ainti. ");
INSERT INTO jivNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ame uwejmek yajauchin túrumtikkramamniaitkuiṉkia tsupikta. Mai uwejtuk wáitsatniunam jeatniuja̱i̱ṉkia chikichík uwejja̱i̱ ju̱ nuṉkanam pujusar tuke iwiaaku pujustinnium jeatin ti shiiraiti. Warí, wáitsatniunmaṉka ji kajinkiashtin awai, ");
INSERT INTO jivNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","jákaru akari̱sha jáiniatsui tura jisha tuke kapa̱a̱wai. ");
INSERT INTO jivNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nawe̱msha yajauchin túrumtikkramamniaitkuiṉkia nusha tsupikta. Mai nawentuk wáitsatniunam jeatniuja̱i̱ṉkia chikichík naweja̱i̱ ju̱ nuṉkanam pujusar tuke iwiaaku pujustinnium jeatin ti shiiraiti. Wáitsatniunmaṉka ji kajinkiashtin awai, ");
INSERT INTO jivNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","jákaru akari̱sha jáiniatsui tura jisha tuke kapa̱a̱wai. ");
INSERT INTO jivNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ji̱misha yajauchin túrumtikkramamniaitkuiṉkia ukuinkiata. Mai ji̱i̱ntiuk wáitsatniunam jeatniuja̱i̱ṉkia chikichík ji̱i̱ji̱a̱i̱ ju̱ nuṉkanam pujusar Yus akupeana nui̱ jeatin ti shiiraiti; ");
INSERT INTO jivNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wáitsatniunmaṉka jákaru akari̱sha jáiniatsui tura jisha tuke kapa̱a̱wai. ");
INSERT INTO jivNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Namaṉ Yus susamu weaktinia áintsaṉ aentstirmesha jiji̱a̱i̱ nekapnastatrume. ");
INSERT INTO jivNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Weesha ti peṉkeraitiat michumarka, ¿itiurak jea-jeat átinkⁱ? Wats, wee jeakua áintsarmek atumek shiir enentáimtunaistarum” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus Kapernáumnumia̱ jiinki, Jutía nuṉkanam naṉkaamaki, Jurtaṉ entsa amain jeamiayi. Nui̱ pujai̱, aents ataksha Nin irunturarmiayi. Iruntrarmatai tuke túrin asa ataksha unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tura Pariséu Jesusan nekapsatai tusar wakeruiniak, Nin chicharainiak “¿Áishmaṉ ni nua̱rí̱ ajapatin tsaṉkamkamukait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tutai Jesus tímiayi “¿Muisais wariniak timia?” ");
INSERT INTO jivNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tutai “Papíji̱a̱i̱ in ajapatniun tsaṉkatramkamiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tutai Jesus tímiayi “Atumí enenta̱i̱ kátsuram asamtai nu chichaman atumin tsaṉkatramkamiarme. ");
INSERT INTO jivNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tura Yus yámankamtaik ashí najanamia nui̱, áishmaṉnasha nuwa̱ncha najanamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tuma asamtai áishmaṉ ni aparí̱ncha nukurí̱ncha kanaki ikiuki, ni nua̱ri̱ja̱i̱ tsaniṉtiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Warí, áishmaṉ nua̱ri̱ji̱a̱i̱ jímiaraitiat chikichik ajasartatui. Tuma asamtai yamái jímiarchaiti, antsu chikichik ajasuiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tuma asa, Yus atsaṉkiania nuna, aents akankashtiniaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tura urum je̱á waya̱war, Jesusa unuiniamuri̱ nu chichaman ataksha aniasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tuiniakui Jesus tímiayi “Shuar ni nua̱ri̱n ajapa ikiuak chikichan nuátkaṉka, emka nua̱ri̱n yajauch awajas, ikiuak, tsanirmayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nuwa̱sha ni áishri̱ ajapa ikiuak, chikichja̱i̱ niiniurtukka, niisha tsanirmayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Antiṉkiarat tusar uchin Jesusan itiariarmiayi. Túruiniakui Jesusa unuiniamuri̱ “itiairap” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tura Jesus nuna wáiniak, kajek ju̱na tímiayi “Uchi Winí winitin tsaṉkatruktarum. Suritkiairap. Iis, shuar ju̱ uchia núnisaṉ peejchach enentáimtumainia nu Yusa akupeamuri̱n pachiinkiamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nuní asamtai tájarme, uchi umiana núnisaṉ Yusa akupkamuri̱n shuar umíachkuṉka nuna pachiinkiachminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nuyá uchin miniakas, “Yus yáinmakarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ukunam, Jesus nuyá weai̱, shuar tseke̱ Nin tarimiayi. Tarí tikishmatar chicharuk “¿Uuntá, Amesha ti péṉkeraitme. Tuma asam, turuttia, ¿warinia túrakna tuke iwiaaku átataj?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tutai Jesus tímiayi, “¿Urukamtai Winia, péṉkeraitme, túrutam? Shuarka chikichkisha péṉkerka atsawai. Aya Yúsak péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yus akupkamu nékatsmek. Ju̱ áiniawai: tsanirmawairap, maṉkartuawairap, kasamkairap, chíkich shuar tsanumprurairap, anaṉkartuawairap, apasha nukusha umirkatarum. Nu áiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tutai kuítrintin chichaak “Uunta, núnaka úchichik mash umiki tsakaruitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tutai Jesus iis waitnenmai tímiayi “Chikichik táasume. Weme ashí áminiu ana nu surukta. Túram nu kuit kuítrincha susarta. Túrakum nayaimpiniam kuítrum ikiauṉkattme. Túram winitia, krus yanaktinia áintsamek itiurchatrum ai̱ṉ nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tura kuítrintin nu chichaman antuk, wake mesek, kúntuts enentáimiar wémiayi, ti kuitrintin asa. ");
INSERT INTO jivNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nii wématai, Jesus ashí ni téntakmari̱n iis, ni unuiniamuri̱n chicharuk, “Kuítrintin ainia nu Yusa akupeamuri̱n pachiinkiatin ti itiurchaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Takui ni unuiniamuri̱ nuna antukar niisháa enentáimprarmiayi. Túramtai Jesus tímiayi “Uchiru antuktarum. Shuar kuítri̱niak enentáimtuinia nuka, Yusa akupeamuri̱n pachiinkiatin peṉké itiurchataiti. ");
INSERT INTO jivNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Uunt kamiriu auja ji̱i̱n waya̱tin ana nú naṉkaamas, kuítrintin Yusa akupeamuri̱n pachiinkiatin itiurchataiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nuna antukar nú arant niisháa enentáimprarmiayi. “¿Nuiṉkia yaki uwempramniait?” tunaiyarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tura Jesus nin iisar chichainiak “Aents niṉki túrachminiaiti, antsu Yus túramniaiti. Yuska ashí túramniaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nuyá Pítiur Nin chicharuk “Iis, iikia ashí ikiukir némartsujik” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tutai Jesussha tímiayi, “Nekas tájarme, shuar Winia nemartak Yus-Chichamnasha ipiampartasa wakerak ni je̱e̱ncha, yachi̱ncha, umai̱ncha, aparí̱ncha, nukurí̱ncha, nua̱ri̱ncha, uchirí̱ncha, nuṉke̱ncha uyumatsuk ikiuakka, ");
INSERT INTO jivNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nu shuar ju̱ nuṉkanam siaṉ patatnas je̱e̱ncha, yachi̱ncha, umai̱ncha, nukurí̱ncha, uchirí̱ncha, nuṉke̱ncha, ju̱ nuṉkanam wáitiayat sunastatui. Tura ukunam, nuṉka amuukamtai, nu shuarsha jáchatainium tuke péṉker pujustatui. ");
INSERT INTO jivNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tura untsurí̱ shuar yamái peṉkeri̱ ainia nu, ukunam ukunmaani̱ pujusartatui, tura íiksaṉ untsurí̱ shuar yamái ukunmaya̱ ainia nu, ukunam eem pujusartatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nuyá arak Jerusaréṉnum wéenak, jintiak wearmiayi. Jesuska émak wémiayi. Ni unuiniamuri̱sha niisháa enentáimprarmiayi. Ashamainiayataṉ Jesusan nemarsarmiayi. Túmainiai̱ atak ni nekas unuiniamuri̱n akankiar, ni túrunatniuri̱n ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ujaak tímiayi “Antuktarum, arak Jerusaréṉnum wéaji. Nui̱ Winia, Aents Ajasuitjiana ju̱na, Patri̱ uuntri̱i̱ncha, jintinniunmasha surutkartatui. Niisha apachnium mantamnati tusar surutkartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nusha Winia wishikrurar, katsumprukar, usukruawar mantuawartatui. Túramaitiatnak menaintiú tsawantai̱ nantaktiatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetéu uchirí̱ Jakupusha Juaṉsha Jesusan taruntarmiayi. Taruntar “Uuntá, ii seattajnia nu túrak tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tutai Jesus tímiayi “¿Warí itiurtukat tusam wakerutam?” ");
INSERT INTO jivNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tutai “Ame nupetmaktin tsawantrum jeamtai, iisha Ámiji̱a̱i̱ pujustaitsar wakeraji, wi untsuurumini̱, winia yatsursha menaarmini̱. Nu tsaṉkatrukta” tíarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tura Jesus tímiayi “Átum seatrumna nu nékatsrume. Wi umartatjana nu umarminkaitrum. Tura Wi imiantiatjana núnisrum imianminkaitrum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Niisha tiarmiayi, “Túramniaitji, páchitskea.” Tuí̱niakui Jesus tímiayi “Wats, Wi umartatjana nu umartatrume, tura Wi imiantiatjana núnisrumek imiantiatrume. ");
INSERT INTO jivNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Túrasha winia untsuuruini̱, menaruini̱sha átum pujustinian Wikia súsashtiniaitjarme, antsu Yus wakerana nu nuiṉ apujsattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tura chíkich tias unuiniamuri̱ nuna anturkar Jakupuncha, Juáṉnasha ti kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tura Jesus ni unuiniamuri̱n irur tímiayi “Ju̱ nékarme; Yus-shuarchanum akupniuitjai tuinia nu, waantu enentáimtumas, ni shuári̱n ti akupeawai; tura uunt ainia nusha ashí shuar ti takamtikiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Antsu atumja̱i̱ núnisaṉ atsutniuiti. Átumka, wi unuiniamutiram, uunt ajastaj tusarum wakerakrumka, ashí yáimin ajastiniaitrume. ");
INSERT INTO jivNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Shuar atumí peṉkeri̱ ajastajtsa wakerakka, takarniua nuke ajas, umirtamkatí. ");
INSERT INTO jivNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wisha, Aents Ajasuitjiana ju̱, shuar takartusarat tusan táchamjai, antsu ashí shuáran yáiṉtaj tusan táwitjai. Wisha jarukan shuáran uwemtikratajtsan táwitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus ni unuiniamuri̱ji̱a̱i̱, tura chíkich untsurí̱ aentsja̱i̱ Jirikiú péprunam jeawarmiayi. Nuyá Jirikiúnmaya̱sha jíinkiar weenai̱, Timiasa uchirí̱ Partimiás, kusuru amia nu, jintiá yantam kuítian seamu pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Niisha, Nasarétnumia̱ Jesusaiti táman antuk, untsumuk “Uunt Jesusa, amesha Uunt Akupin Tawit weeachukaitiam, Yus anaikiachmakaitiam. Winiaja waitnentrurta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tura untsurí̱ nui̱ matsamarmia nu nin chicharainiak “Takamatsata” tiarmiayi. Niisha nú naṉkaamas untsummiayi “Tawit weeá Jesusá, winia waitnentrurta.” ");
INSERT INTO jivNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nuna antuk Jesus wajatas, chichaak “Untsuktarum” tímiayi. Takui shuar kusurun untsuiniak “Kakaram ajasta. Wajaktia; untsurmawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tuiniakui niisha esekmatairi̱n ajapa ikiuak wajaki Jesusan tseke̱ tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tura Jesus nin chicharuk “¿Winia itiurtukat tusamea wakerutam?” tímiayi. Tutai kusuru chicharuk “Uunta, íimtiasan wakerajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tutai Jesus chichaak “Shiir wetá. Winia nekas enentáimtursa asam péṉker ajasume” tímiayi. Tura nu chichamaik íimpramiayi. Tura Jesusan nemarki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wésar Jerusaréṉnum tura Petpajái péprusha Petania péprusha Uriwiu naint íṉkiuasmak ámanum jeawar, Jesus jimiará unuiniamuri̱n ujuikimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ujuiak tímiayi “Aatunini̱ pépruchiniam werum nuiṉ umpuuru uchich jiṉkiamu wáinkiattarme. Nu umpuuruka tuke entsamprukchamuiti. Nu atiarum utitiarum. ");
INSERT INTO jivNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tura “¿Urukamtia áitkiarum?” turamainiakuisha, “ii Uuntri̱ wakerawai” titiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tutai wearmiayi. Tura umpuurun wáitiniam aani jiṉkiamun, jintiá yantamnum wajan wáinkiar atiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nui̱ pujuarmia nu “¿Warí áitkiarum. Urukamtai umpuuru atíarum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Takui, niisha Jesus timia nu ujakam suritkiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tura umpuurun Jesusan itiariar pushiri̱n umpuurunam awantkarmiayi. Túram Jesus entsamkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tura untsurí̱ shuarsha pushiri̱n jintianam ayapar áinkiarmiayi. Chíkichcha jintiá yantamnumia̱n nukan juuk jintianam áintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eem wearmia nusha, uku winiarmia nusha warainiak “Jusanna” untsumkarmiayi. “Yusa náarí̱i̱n winiana nu imiá péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ii uuntri̱ Tawitia akupeamuri̱ tátatna nu imiá peṉker atí. Ii Yusri̱ naari̱ shiir ati.” Tu untsumki wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tura Jesus Jerusaréṉnum jeamiayi. Jeá, Yusa Uunt Je̱e̱n waya̱miayi. Tura ashí iiyasua amik, kintiampra̱i̱j tusa ni tuse unuiniamuri̱ji̱a̱i̱ tíjiu̱ch Petania péprunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kashin tsawa̱r, Petanianmaya̱ jintia wesa, Jesus tsukammiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tura arant wajan iikiu numiri̱n núkenniun wáiniak, nereatsuash tusa iyumiayi. Tura nereshtairi̱n asamtai neren peṉké wáinkiachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nuyá iikiu numin yumiṉkeak: “Ame nere̱m peṉké yunaashti” tímiayi. Ni unuiniamuri̱sha nuna táman antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nuyá atak Jerusaréṉnum jeawarmiayi. Nui̱ Jesus Yusa Uunt Je̱e̱n wayá suruktai tusar pujuarmia nuna ji̱i̱ki akupkatasa naṉkammiayi. Kuítian yapaji̱n armia nuna misari̱n tura yampitsan súrin armia nuna kutaṉkri̱ncha ayanturmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tura káarak entsaki Yusa Uunt Je̱e̱n naṉkaamaktinian suritkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nuyá “Yus áujsatai tusar ashí shuar Yusa je̱e̱n waya̱mnia átatui” tú aarchamukait Yusa Papiri̱i̱n. Antsu átumka Yusa je̱e̱ kasa matsamtaiya nútikiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aents nui̱ matsamarmia nu Jesusa chichame̱n antukar ti enentáimprarmiayi. Tuma asamtai Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha, nuna nekaawar, Jesusan ashamainiak mantamnati tusar chichaman jurusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nuyá kia̱kui Jesus Jerusaréṉnumia̱ jiinkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kashin káshik naṉkaamainiak iikiu numin kaṉkaptuk jaka wajan wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tura Pítiur enentáimias Jesusan tímiayi “Uunta, iista, iikiu Ame yumiṉkramam nu kaṉkaptuk káarchaik.” ");
INSERT INTO jivNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tutai Jesus tímiayi “Yus nekas enentáimtustarum. ");
INSERT INTO jivNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iis, nekas tátsujrumek, shuar “Yus nekas túratpiash” tútsuk, tura “wi tájana nuna Yus nekas túrattawai” tu enentáimsar, ju̱ náintian “jiinki nayaantsanam iniáṉtí” tákuiṉkia, páchitsuk iniaṉtatui, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tuma asamtai tájarme, ashí Yus áujkuram searmena nuna suramsattarme. “Wi seajna nuna yamái takakjai” tu enentáimkiurmeka, wáinkiáttarme. ");
INSERT INTO jivNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tura Yus áujkuram pujarmena nu, kajernaiyamuram ákuiṉkia tsaṉkurnáiratarum. Atumí Aparí̱ nayaimpiniam pujana nu atumí tunaari̱n tsaṉkurturti tusarum túratarum. ");
INSERT INTO jivNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Atumsha tsaṉkurnáiyachkurminkia, núnisaṉ atumí Aparí̱ nayaimpiniam pujana nu atumí tunaari̱n tsaṉkurtámprashtatrume” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ataksha Jerusaréṉnum waketkiarmiayi. Jesus Yusa Uunt Je̱e̱n wekai̱, Israer-patri̱ úuntri̱sha, Israer-shuara jintinniuri̱sha, Israer-shuara iruntai-je̱e̱ úuntri̱sha Nin káutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Káutkar Jesusan tiarmiayi “¿Yana kakarmari̱ji̱a̱i̱ ju̱ túram. Ame túramna nuna ya tsaṉkatrama?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tuiniakui Jesus tímiayi, “Chikichkiniak aniastatjarme. Áirkatarum. Túrakrumniṉkia Wisha winia takastinian tsaṉkatrukmia nuna ujaktatjarme. ");
INSERT INTO jivNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wats, turutiarum, ¿ya Juaṉ imiaitniun tsaṉkatkama? ¿Shuar tsaṉkatkamka? ¿Yus tsaṉkatkamka? Áirkatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tura niisha enentáimprar “Yus akupkaiti” tákurninkia, “¿urukamtia umirkachuram?” turamchattajik. ");
INSERT INTO jivNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Antsu “shuar tsaṉkatkaiti” tákurkia, ashí shuar ashamaji” tunainiarmiayi. Ashí aents Juaṉ nekas Yúsnan etserniuiti, tu enentáimainiakui ashammiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nuyá Jesusan tiarmiayi “Iikia nékatsji.” Tutai Jesus tímiayi “Wisha núnisnak yana kakarmari̱ji̱a̱i̱ takaaj nuna ujakchattajrume.” ");
INSERT INTO jivNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus ju̱ métek-taku chichaman unuiniamiayi: “Shuar uwa ajan ajam wenuimiai. Nuyá uwa nekeetain najanamai. Tura kumpin je̱a̱n najanamai. Najana takartusti tusa shuáran ikiuak niṉkia jeachat wémai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Neretai tsawant jeamtai, ni takarniuri̱n júukman akankat tusa akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tura ajanam takau arma nu, nu takarniun achik, katsumkar, áyatik awaiṉkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ataksha chíkich takarniun akupkamai, tura nunasha kayaja̱i̱ tukurar, múuknum katsumkar, katsekar awaiṉkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuma aiṉ ataksha chíkichan akupkamai, tura nunasha máawarmai. Ti untsurí̱n akupramai. Chikichnasha katsumkarmai, chikichan máawarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tura niiji̱a̱i̱ chikichik tuke ámiayi, nuka ni aneamu uchiri̱. Nu uchincha ukunam akupkamai. Akupeak “Winia uchirnaka shiir awajsartatui” tímiai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tura ni uchiri̱ winian wáinkiar, takau shuar nuámtak chichainiak “Ju̱ka ajá nérenniu uchirí̱nti. Wátsek, maatai; túramka ájaka iiniu átatui” tiarmai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Túsar achikiar máawarmai. Aya̱shincha ajanmaya̱ ajapawarmai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tura nuyá aniasmiayi, “¿Wats, warí enentáimsarum; ajá nérenniuri̱ itiurkattawa? Jeashtanmayá taa, ajá takainia nú shuaran amuktatui. Ni ajarí̱ncha chikichan ikiastatui. ");
INSERT INTO jivNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ju̱, Yus-Papinium aarma ana nu áujsachukaitrum: Kaya péṉkernak, jeammin “yajauchiiti” tusar ajapawarmia nu ashí kayaja̱i̱ naṉkaamas péṉker apujsamuiti. ");
INSERT INTO jivNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nusha Yus túramuiti. Iisha íisar ti enentáimtaji. Nuke áarmaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tura nú metek-taku chichamja̱i̱ nin áujmatma asa achiktai tusar chichaman jurusarmiayi. Túmainiayat shuáran ashamainiak Jesusan ikiuiniak wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tura wear, imiaamtikiar yajá chichakmatai núja̱i̱ yajauch títiai tusar Pariséu shuarnasha, Erutisa nemari̱n shuarnasha akatar Jesusan akuptukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Túram Nin jeariar chicharainiak: “Uuntá, aents nakitiainiai̱ṉ tuke nekas chicham páchitsuk chichaame, nu nékaji. Aents pátatek iiyatsme, antsu nekas Yusa jinti̱ unuiniame. ¿Waritia enentáimiam, ii kuitri̱ uunt Sesar súsatin péṉkerkait. Susattajik. Suritkiattajik? Nu nekaatai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tura Jesus ni yajauch enentáimmiari̱n nekara “¿Urukamtai Winia yajauch titi tusarum wakerutarum? Kuit itiatarum, Wi íistaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tutai kuítian itiariarmiayi. Jesus nuna iis tímiayi, “¿Jui̱sha yana yapi̱ tura yana naari̱ áarmait?” tímiayi. Tutai “Uunt Sésarna” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nuyá Jesus tímiayi “Uunt Sésarna ana nu susatarum; túrarum Yúsnaka Yus susatarum” tímiayi. Tura ni áimkiamuri̱n antukar ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nui̱sha Satuséu aents, jakamunmaya̱ nantaktin peṉké atsawai tiniu armia nu, Jesusan tariarmiayi. Taar Jesusan chicharainiak: ");
INSERT INTO jivNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Uuntá, Muisais ju̱na áatrampramiaji: “Áishmaṉ ni nua̱ri̱ júreatsa̱i̱ṉ jakamtaiṉkia, yachin yajutmatrattsa, ni yachi̱ nu waje̱n nuátkatniuiti.” ");
INSERT INTO jivNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wats, siati yachi ármiayi. Iwiairi̱ nuwa̱n nuatak yajutmatsuk jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ni yachi̱ waje̱n akinkiamiayi. Nusha núnisaṉ yajutmatsuk jakamiayi. Nuna yachi̱sha núnisaṉ tura nuna yachi̱sha núnisaṉ túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tura ashí siati patai̱nmaṉ, patai̱nmaṉ nu nuwa̱n nuátkarmiayi. Yajutmatsuk, yajutmatsuk jíiniawarmiayi. Tura ukunam nuwa̱sha jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nuiṉkia nantaktin tsawantai̱, nantakiarmatai, ¿yana nua̱ri̱ṉ ati? Ashí siati nuátkacharmaka” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tutai Jesus tímiayi ““Jakamunmaya̱ nantaktin atsawai” tátsurmek. Yusa chichame̱ tura Yusa kakarmari̱ nékachu asarum awajiarme, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iimiatarum, aents jakamunmaya̱ nantakiarmatai, nuatnaikiatin atsuttawai, antsu nayaimpinmaya̱ suntara núnisaraṉ pujusartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tura jakamunmaya̱ nantaktiniapitia tusarum nu nekaatin nekas wakerakrumka Muisais aarmia nu enentáimtustarum. Yuska numichinmaya̱ Muisaisan chicharuk “Wikia Apraáma Isaaka tura Jakupu Yúsri̱ntjai” Yus tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaunchu jákaru aiṉ, Yus nuna taku, aya̱shnium jakayat iwiaaku pujuinia nuna Yusri̱ntjai, tawai. Nekas jaka ainia nuna Yusri̱nchuiti. Nantaktin atsawai tau asarum awajirurme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesussha Satuséusha áujmatnainian Israer-shuara jintinniuri̱ taa anturkamiayi. Anturak, Jesus ti peṉker áimkiui, niisha Jesusan ju̱na aniasmiayi: “¿Yus akupkamu tuá imiá péṉkerait?’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tutai Jesus tímiayi “Jú̱iti Yus akupkamu imiá péṉker: Antukta Israer shuará. Ii Yusri̱ úuntaiti, tura Niṉki nekas Yúsaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tuma asamtai, tuke enentáimja̱i̱ ti enentáimsam Uunt Yus aneeta. Túram ame iwiaakmarmesha, kakarmarmesha Yus íiktusta. Núiti nekas péṉker akupkamu, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nuya̱sha chikichcha awai, “ame aya̱shim aneamna tímiatrusmek ame írutramurmesha aneeta.” Chíkich nu naṉkaamas péṉker akupkamu atsawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tutai jintintin tímiayi “Ee, péṉkeraiti, Uunta. Nékasmek tame. Chikichík Yus awai, chíkichkia atsawai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tura tuke enentáiji̱a̱i̱ ti enentáimsar, ii kakarmari̱sha Yus íiktusar Nin aneakrikia, ii aya̱shi̱ aneajnia núnik ii írutramuri̱sha aneatniuitji. Nusha ashí Yus sutai ana nuja̱i̱ naṉkaamas péṉkeraiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nuna tiniu asamtai Jesus ni péṉker áimkian nekáa “Ameja Yus akupeamunam pachiinkiatin ishichik táasume” tímiayi. Tura nuyá chíkich shuar Jesusan aniastinian arantukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus Yusa Uunt Je̱e̱n unuiniak pujumiayi. Tura chichaak “¿Urukamtai ii jintinniuri̱ “Yus anaikiamu Krístun Tawitia shuari̱” tuinia?” ");
INSERT INTO jivNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tawit, antsu, Yusa Wakaní aarta tutai, Yus-Papinium ju̱na áarmiayi: Uunt winia Úuntrun tímiayi “Ame nemasrumin nupetkatin amuatsa̱i̱ṉ winia untsuuruini̱ni̱ pujusta”. ");
INSERT INTO jivNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kame Tawitkia, Krístun áujmatuk, “winia Uuntru” taisha, ¿itiura ní shuari̱sha átiṉkⁱ?” tímiayi Jesus. Tuma asamtai untsurí̱ shuar nui̱ matsamarmia nu ti shiir antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus unuiniak tímiayi, “Israer-shuara jintinniuri̱ ainia nuja̱i̱ aneartarum. Niisha waantu enentáimtumasar, esaram pushin entsarar wekasatajtsar wakeruiniawai. Péprunmasha shuar shiir áujtusarat tusa wakeruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Israer-shuar iruntainiam peṉkeri̱ pujutainium pujustinian wakeruiniawai. Nampernumsha peṉkeri̱ pujutainium pujustinniasha wakeruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tura wajé̱ je̱e̱ncha atantainiawai. Túrawar aents nekaracharat tusar ti esaram chichamja̱i̱ Yúsan áujainiawai. Nincha chikichja̱i̱ naṉkaamas Yus asutiawartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus Yusa Uunt Je̱e̱n kuit eṉketainiam naka pujus áents kuítri̱n chumpian wáinkiamiayi. Untsurí̱ kúitrintin núkap eṉkeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nuyá wa̱je̱ kuítrincha taa jimiará uchich kuítian, reara áantsaṉ, eṉkeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesuska unuiniamuri̱n untsuk “Nekas tájarme, ju̱ waje̱ kuítrinchaitiat, ashí eṉkeena nú naṉkaamas núkap eṉkeayi. ");
INSERT INTO jivNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iis, kuítrinniusha nii ampirma nuna eṉkeenawai, tura antsu ju̱ nuwa̱ kuítrinchaitiat, ampirmatsuk ni yurumatniuri̱n takurmakman ashí eṉkeayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yusa Uunt Je̱e̱nia̱ Jesus jiinkimtai, unuiniamuri̱ Nin tímiayi “Iisia, Uunta, kayasha ti shiir áiniawai. Je̱a̱sha imiá úuntchakait.” ");
INSERT INTO jivNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tutai Jesus tímiayi “Ju̱ imiá uunt je̱a̱ wáinmek. Kaya ekentramu au ashí mash yumpuntrartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nuyá Uriwiu náinnium wakar, Yusa Uunt Je̱e̱ naka pujusar, Pítrusha, Jakupusha, Juaṉsha, Antressha, níṉkimias Jesusan aniiniak ");
INSERT INTO jivNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Uuntá, tímiam nu, ¿urutiá túrunatta. Nu túrunatin jeakuisha itiura nekaattajia? Paant ujatmakta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tutai Jesus tímiayi “Aneartarum, anaṉkramawairap. ");
INSERT INTO jivNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nekaatarum, untsurí̱ winia naarun pachisar winiartatui. Chíkich chíkich “Wiitjai Kristu” taku, untsurí̱n anaṉkawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tura meset chicham ántakrumka, yajaya̱ meset chicham ántakrumsha sapijmiakairap. Nekas túrunashtinkiait. Nuja̱i̱sha amuukatin tsawantka tuke jeatsui, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shuar chíkich shuarja̱i̱ mesetan najanawartatui; apachcha chíkich apachja̱i̱ núnisaraṉ mesetan najanawartatui. Untsurí̱ nuṉkanam ú̱u̱rkattawai. Tsukasha ártatui, charaatum ajamusha núnisaṉ átatui. Tura nuja̱i̱ itiurchatka aya yama naṉkamui.’ ");
INSERT INTO jivNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Túmaitkui atumsha aneartarum. Akupin iruntainiumsha surutmakartatrume, tura íi shuar iruntainmasha katsumpramkartatrume. Wíi shuar asakrumin, kapitiánnium, akupniunmasha juramkittiarme. Nui̱ jearum, Winia chichastatrume. ");
INSERT INTO jivNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nu túruntsa̱i̱ṉ ashí áentsnum Yus-Chicham etsernaktiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atumin surutmaktasar juramainiakuisha, warintiajak tusarum ti enentáimsairap. Chichastin jeamtai, Yusa Wakaní̱ jintintramattarmena nu titiarum. Iis, atumí enentái̱ji̱a̱i̱ tíchattarme, antsu Yusa Wakaní̱ jintintiam títiatrume. ");
INSERT INTO jivNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nu tsawantin shuarsha ni yachi̱n mantamnati tusa suruktatui. Apasha ni uchirí̱n suruktatui. Uchisha aparí̱ncha nukurí̱ncha kajerak, jakati tusa suruktatui. Núnisaṉ untsurí̱ shuar túrawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nuiṉkia Wíi shuar asakrumin ashí nakitramprartatui. Tura shuar yawe̱tsuk katsuntraṉka uwemprattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nuyá Jesus tímiayi “Shuar ju̱na áujeana nu nekaati. Yúsnan etserin, ni naari̱ Taniar, ti yajauch tuke emesin ana nuna yaunchu aar etserkamiayi. Nuka pujushtainiam pujan wáinkiurmesha, ashí Jutía nuṉkanam pujarmena nu, náinnium pisartarum. ");
INSERT INTO jivNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Je̱a̱ yakiini̱ pujana nu akaiki wariri achiktajtsa, je̱e̱n waya̱shti. ");
INSERT INTO jivNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ajanam pujana nusha ni pushiri̱n jukitiajtsa waketkishti. ");
INSERT INTO jivNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tura ajamtin áiniana nusha, kuírchin umuntsainia nusha, nu tsawantin timiá itiurchatan wáinkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tuma asamtai átum pisaarmena nui̱ yumitin achati tusarum Yus seatarum. ");
INSERT INTO jivNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nu tsawantinkia ti wáitsatin átatui. Yama naṉkamtaik Yus nuṉkan najanama nui̱sha, yamaisha ukunmasha timiu wáitsatin peṉké atsuttawai. ");
INSERT INTO jivNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tura Uunt Yus wáitsatin tsawantan ishichik awajsattajai tíchaitkuiṉkia, uwempratin peṉké atsuinti. Tura ni shuari̱n anaikiamia nuna yáiṉtajtsa wakerak, nu tsawantan ishichik awajsattawai. ");
INSERT INTO jivNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nu tsawantai̱ “jú̱iti Kristu” túramkuiṉkia anturkairap. ");
INSERT INTO jivNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kame “Krístuitjai” ántar tuinia nu, tura “Yúsnan etserniuitjai” ántar tuinia nusha wantinkiartatui. Wantinkiar Yus anaikiamu shuárnasha anaṉkatai tusar wakeruiniak, ni kakarmari̱n iniakmainiak aentsti tujintiamun túrartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tura átum aneartarum. Aetak, túruntsa̱i̱ṉ ujakchajrumek’ tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesus tuke unuiniak ju̱na tímiayi: ‘Tura nu wáitsatin naṉkaamasmatai, etsaasha nantusha etsantrashtatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yaasha nayaimpinmaya̱ kakekartatui, tura nayaimpiniam kakaram ainia nu muchitrartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nuya̱sha ashí aents Winia wáitkiartatui. Wi, Aents Ajasuitjiana ju̱, ti kakaran, ti wincha ajasan, yuraṉminiam winiái̱ wáitkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nui̱ nayaimpinmaya̱ suntarun akupkattajai, Wíi shuaran ashí nuṉkanmaya̱n irurarat tusan. Arakaani̱ya̱, nuṉkaani̱ya̱, ashí nuṉka náṉkatkamunmaya̱n Wíi shuaran irurartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Iikiu numi nakumea nu nekaatarum. Ni chiṉkimpri̱ puṉkak nuke̱ jeakui̱, “ju̱ nuṉkanam esat jeatemai” tátsurmek. ");
INSERT INTO jivNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Núnisrumek Wi tájarmena nu wáinkiurmeka, ni tatintri̱ jeatemai tu nekaattarme. ");
INSERT INTO jivNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nekas tájarme, yamaí aents pujuinia nu kajiṉ amuiniatsa̱i̱ṉ, ashí Wi tájana nu túrunatniuiti. ");
INSERT INTO jivNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nayaimpisha nuṉkasha amuukatniuiti. Tura winia chichampruka amuukashtiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tura tsawantcha nekanachminiaiti. Nayaimpinmaya̱ suntarsha nékainiatsui; Wisha Yusa Uchirí̱ntiatan nékatsjai. Aya winia Aparuk nékawai. ");
INSERT INTO jivNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Atumsha anearum enentáimprarum Yus aujsa pujustarum, tsawant nékachu asarum.’ ");
INSERT INTO jivNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","‘Tura Wikia ju̱ shuarja̱i̱ méteketjai. Ju̱ shuarsha jeachat weak, ni je̱e̱n ikiuawai. Ikiuak ni shuari̱n wáitrukartí tusa apujas ikiuak ashí shuaran takatri̱n súawai. Tura wáitin wáinniun, “ameja péṉker wáinkiata” tímiai. ");
INSERT INTO jivNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wikia nu je̱a̱ nérenniua núnisnak, urutai tátataj nékachu asarum anearum pujustarum. Kí̱araimpiash, tura ajapkeash, atash shiniukaimpiash, káshikiash tátatjai. ");
INSERT INTO jivNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nérentin aya aneachmak taa, kanúu tepai̱ wáitkia̱i̱ tusarum aneartarum. ");
INSERT INTO jivNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wi atumin tájana nu, ashí shuáran tajai, anearum pujustarum” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jímiarchikí tsawant ajasmiayi paskua tutai námper jeatin. Paskua námpertincha wakapruachu tantan yuatin námpernasha métek najanin ármiayi. Israer-patri uuntri̱sha, Israer-shuara jintinniuri̱sha Jesusan anaṉkar achikiar maatai tusar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Túrasha “Jista tsawantin túrachmi, aents charaatum ajara̱i̱ṉ tusar” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesussha Petania péprunam tunamaru Semuṉka je̱e̱n misanam pujan, nuwa̱ tarimiayi. Nartu kuṉkuinian arapástru tutai kaya najanamunam piakun itiamiayi. Nu kuṉkuin ti kuitiaiti. Mutí chuchuke̱ kupik Jesusa muuke̱n kuṉkuinian ukatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tura nui̱ pujuarmia nu, kajerar tunaiyarmiayi “¿Urukamtai ju̱ kuṉkuinian ántar wasurea? ");
INSERT INTO jivNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ju̱nasha súrakka, menaintiú siaṉ kuítnium surukminiuyi. Nu kuitcha kuítrinchan súsaṉka maak” tiarmiayi. Tusa nuwa̱n kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Antsu Jesus chicharainiak “Iniaisatarum. ¿Urukamtai au kajerarum? Winia shiir túrutayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kuítrincha atumja̱i̱ tuke íruntsuk. Wakerakrumka tuke péṉker awajsatniuitrume. Antsu Wikia atumja̱i̱ tuke pujushtatjai. ");
INSERT INTO jivNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ju̱ nuwa̱ ashí nii túramnia núnaka umikiai. Wi jákatin jeatsa̱i̱ṉ, iwiarsatin kuṉkuinian shiir ukatrurai. ");
INSERT INTO jivNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nekas tájarme, ashí nuṉkanam Yus-Chicham etsernaktatna nui̱, ju̱ nuwa̱ túramuri̱sha etsernaktatui, nin kajinmatkiara̱i̱ṉ tusa” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nuyá Jútas Iskariúti, Jesusa unuiniamuri̱ntiat, Israer-patri uuntri̱n werimiayi, Jesusan suruktaj tusa. ");
INSERT INTO jivNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Niisha nuna antukar, warasar “Kuit amastatji” tiarmiayi. Jútassha Jesusan itiurak yúpichuch tsaṉkamkattaj tusa enentáimias wekaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wakapruachu tantan yuatin jísat naṉkama tsawant tsawa̱rmatai, paskua námpertin yúatin murik máatin jeamtai, Jesusa unuiniamuri̱ iniasarmiayi “Paskuatin murikiu yúatin iwiaratai tusar ¿tui̱ wétatajⁱ. Tui̱ yurumattam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tutai Niisha jimiará unuiniamuri̱n akatar akupeak “Péprunam wetarum. Nui̱ áishmaṉ yumin jukí wéa wáinkiattarme. Nu áishmaṉ nemarsatarum. ");
INSERT INTO jivNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Waya̱na nui̱ je̱á nérenniuri̱ títiarum “Uunt túramui, ¿wisha, unuiniamurja̱i̱ tui̱ yurumáttaj?” ");
INSERT INTO jivNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nu nérentin, yakí písunam uunt tesamunam ashí iwiaramun iniakturmastatrume. Nui̱ jísat ii najanatin iwiaratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ni unuiniamuri̱ wear, péprunam jeawar, Jesus timia núnisaṉ wáinkiarmiayi. Tuma ásar paskua námperan iwiararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nuyá kí̱akui Jesus ni tuse unuiniamuri̱ji̱a̱i̱ waya̱warmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Niisha misanam pekaamak, yurumáiniak pujusar, Jesus tímiayi. “Nekas tájarme, chikichík shuar Wiji̱a̱i̱ yurumna nu, surutkattawai.” ");
INSERT INTO jivNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nuja̱i̱ kúntuts enentáimprarmiayi. Chíkich chíkich Jesusan aniasar “wíashitiaj” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus tímiayi “Ju̱ misanam tuse irunar yurumprum nu, chikichik surutkattawai. Wiji̱a̱i̱ piniṉnum yurumkan ayak yuana núiti. ");
INSERT INTO jivNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nekas Wi, Aents Ajasuitjiana ju̱, jákatniunam wéajai, áarturma áintsanak. Tura áishmaṉ súrutna nu ti wáitsattawai. Niisha akiinmainchu ajakuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yurumainiak Jesus Yúsan yuminkias, yurumkan achik, puuk, chicharainiak “Achiktarum, ju̱sha winia aya̱shruiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Piniṉnasha achik, Yúsan yumiṉkias, ni unuiniamuri̱n súsarmiayi. Ashí umararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Umararmatai Jesus tímiayi “Jú̱iti winia numpar, untsurí̱n yáiṉtajtsa puártinia nu. Nuja̱i̱ Yamaram Chichaman Yus najanaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nekas tájarme, uwa yumiri̱ ataksha ju̱i̱ umarchattajai. Tura tsawant jeamtai, ukunmasha, Yus akupeana nui̱ yamarman umartatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yus-kantan kantámawar, jíinkiar, Uriwiu náinnium wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nuiṉkia Jesus nin tíarmiayi “Ju̱ kashi átum natsantrurtatrume. “Murikiu wáinniun máattajai, túramtai murik tsakiṉmakartatui” tu aarchamukait. ");
INSERT INTO jivNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tura ukunam Wi nantakin atumin Kariréanam émtuktiajrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tutai Pítiur chicharuk “Ámin ashí natsantramainiakuisha, wikia natsantrashtatjame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tutai Jesus tímiayi “Nekas tájame, ju̱ kashi atash jimiará shiniatsa̱i̱ṉ, natsantrurtatme. “Núnaka nékatsjai” menaintiú turuttiatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tutai Pítiur kakaram chichaak “Ámiji̱a̱i̱ métek máantuiniakuisha, núnaka peṉké tíchattajai” tímiayi. Ashí ni unuiniamuri̱ núnisaṉ tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nuyá Jitsemaní ajanam wearmiayi. Jeawar Jesus ni unuiniamuri̱n tímiayi “Ju̱i̱ pujustarum, Yúsan áujsatasa pujai̱”. ");
INSERT INTO jivNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pítrun, Jakupuncha, Juáṉnasha jukimiayi. Tura Jesuska ti kuntuts enentáimiar wake mesek nekapsatasa naṉkammiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tura nin chicharuk “Wi ti kuntuts enentáimjai, tura jakamnia nekapeajai. Ju̱i̱ iimia pujutarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesussha ishichik arantach we, nuṉká piniakumar tepes Yúsan aujmiayi. “Ju̱ wáitsatin átatna nu, túrutatniuitkuiṉkia iniaitiusta” tu seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tuke áujuk tímiayi “Apawá, ashí tujinchaitme. Piniṉnumia̱ ashí umartinia áantsaṉ ti nekapsatajna nú wáitsatniun, jurutkitia. Antsu Wi wakeraj nucha, ame wakeramuram túrunati.” ");
INSERT INTO jivNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tura ni unuiniamuri̱n tarin, kanúu tepenan wáinkiamiayi. Pítrun tímiayi “¿Semuṉka kánamek. Kanutsuk ishichkisha iimia pujustin tujinkiamek? ");
INSERT INTO jivNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Anearum Yus áujsatarum, tunaanum iniaara̱i̱j tusarum. Atumí wakani̱i̱n kakarmaitrume, antsu atumí aya̱shi̱i̱n kakarmachuitrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ataksha we, nuik Yúsan áujsama núnisaṉ áujsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ataksha waketruki, ni unuiniamuri̱n kanúu tepenan tarimiayi. Kari̱ ti pujá asamtai, Jesusan áujsatniun tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesus ataksha we, tarí tímiayi “Kanarum ayampratarum. Máakete. Jeayi. Wi, Aents Ajasuitjiana ju̱, tunáa shuarnum surukmaitjai. ");
INSERT INTO jivNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nantáktiárum, wemí. Iis, Winia súrutna nu nuntumsai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus nuna chicháa pujá unuiniamuri̱ Jútas tarimiayi. Niiji̱a̱i̱ untsurí̱ aents puniá takaku, tura numincha takaku káutarmiayi. Israer-patri uuntri̱, Israer-shuara jintinniuri̱, tura Israer-shuara úuntri̱ akupkarma asa káutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Káuntsa̱i̱ṉ Jútas chicharainiak, “Wi mukunattaj áujkin núiti Jesus. Achiirum, péṉker emetarum jukitiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tura Jesusan tarí, mukunuk áujas “Uuntá, Uuntá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Túramtai aencha Jesusan achikiar emetawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Túruiniakui nui̱ wajatusha puniari̱ úkuitsaṉ, patri uuntri̱ takarniuri̱n awati ni kuishi̱n tsupirkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Túram Jesus áentsun tímiayi “Kasakaitiaj. Puniaja̱i̱ numiji̱a̱i̱, kasá nútiksarmek achirkatai tusarum tarutniurme. ");
INSERT INTO jivNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ashí tsawant atumja̱i̱ Yusa Uunt Je̱e̱n waya̱n unuiniakun pujuchmakaj. Túmai̱ nui̱ achirkachmarme. Tura Yus timia nu uminkiat tusa ju̱ túrunayi.” ");
INSERT INTO jivNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nuiṉkia ni unuiniamuri̱ Niniak ikiuiniak pisararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tura áishmaṉ nátsaach aya tarachin penumas Jesusan atamprimiayi. Tura natsaach suntar achikiam ");
INSERT INTO jivNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tarachri̱n ajapa ikiuak misú tsékeṉkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Patri uuntri̱iṉ Jesusan ejeniarmiayi. Nui̱ Patri uuntri̱sha, Israer-shuara jintinniuri̱sha, Israer-shuara uuntri̱sha irunturarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tura Pítiur íikiaṉ nemarki Patri je̱e̱n a̱a̱ch jeá, Patri suntari̱ji̱a̱i̱ jinia anamuk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Patri uuntri̱ ashí naamka uunt armia nuja̱i̱ iruntrar maatai tusar wakeruiniak shuar Jesusan tsanumprurat tusar e̱a̱tkarmiayi. Nu chichamja̱i̱ mantamnati, tiarmiayi. Túrasha wáinkiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Túrasha untsurí̱ shuar Jesusan tsanumpruiniayataṉ yapaji̱á yapaji̱á chichainia ásarmatai wáinkiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nuyá chíkich wajakiar wáitruiniak ju̱na tiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yusa Uunt Je̱e̱n, aents jeamarmia nuna yumpuṉtiatjai. Túran menaintiú tsawantai̱, chikichan, aents jeamchamun jeamtatjai” tau antukmaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tura tuke yapaji̱áwar tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nui̱sha Patri uuntri̱ ajapén wajaki Jesusan chicharuk “¿Áimsatin peṉké tujintiamek. Warinia turamainia?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tura Jesus takamtak áimtsuk pujumiayi. Patri uuntri̱ atak chicharuk “¿Ame nekas Yusa Anaikiamuri̱nkaitiam. Ii Yusri̱ Uunt tajinia nuna Uchiri̱nkaitiam?” ");
INSERT INTO jivNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tutai Jesus tímiayi “Ee, núitjai. Winia, Aents Ajasu tutaintiajna nu Kakaram Yusa untsuuri̱ni̱ pujai̱ wáitkiattarme. Tura nayaimpinmaya̱ yuraṉminiam winiai̱ wáitkiattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tutai Patri uuntri̱ kajek, ni pushiri̱n ja̱a̱k tímiayi “¿Chíkich títincha warí atsumajⁱ? ");
INSERT INTO jivNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nii tana nuja̱i̱ Yúsan kátsekeamu antukurme. ¿Warintia enentáimprum?” tímiayi. Takui “jakamniaiti” ashí tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chíkich chíkich Jesusan usukiáwarmiayi. Ji̱i̱n epetkar awatiar “¿Ya áitkiarma? etserkata” tiarmiayi. Patri suntari̱sha yapiniam awatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Núnaka túruiniai̱ Pítru nuṉká, je̱a̱ a̱a̱ni pujan, nuwa̱ Patri uuntri̱ takarniuri̱ya nu tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Niisha Pitrun jinia anamu pujan wáinkiamiayi. Wáiniak, “Amesha Nasaretnumia̱ Jesusja̱i̱ wekaichukaitiam” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tutai Pítiur chicharuk, “Nékatsjai. Ame támena nuna nékatsjai” tímiayi. Tura a̱a̱ wáitiainiam jiinkimiayi. Tumai atash shiniukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nu núwa̱sha Pitrun ataksha wáiniak, shuáran nui̱ pujuinian tímiayi “Jú̱iti ni shuari̱.” ");
INSERT INTO jivNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tura ataksha “atsá” tímiayi. Ishichik árusaṉ, shuar nui̱ pujuarmia nu ataksha Pitrun chicharuk “Nekas ni shuarinme. Kariréanmaya̱ shuárchakaitiam. Auya̱ shuara nuní chichaame” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tutai Pítrusha kakantar chichaak, “Ju̱ áishmaṉnaka átum tárumna núnaka nékatsjai. Wáitrakuiṉkia Yus íirsati” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nuya̱ ataksha atash shiniukmiayi. Pítrusha, Jesus nuik timian enentáimmiayi. Iis, Jesus nuik tíchamka “Atash jimiar shiniatsa̱i̱ṉ, ame, núnaka nékatsjai, menaintiu turuttiatme” tíchamka. Pítru nuna enentáimias ti úutmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tura kashin káshik Patri uuntri̱, Israer-shuara úuntri̱ji̱a̱i̱, Israer-shuara jintinniuri̱ji̱a̱i̱, ashí naamka armia nuja̱i̱ irunturar, chichaman jurusarmiayi. Túrawar Jesusan jiṉkiamun apach kapitián Piratui̱i̱n ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ejeniarmatai Piratu aniasmiayi “¿Amesha Israer-shuara Uuntri̱nkáitiam?” Tutai Jesussha “Amek tame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nuyá Patri uuntri̱ ti tsanumprurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ataksha Piratu aniasmiayi “¿Áimsatin peṉké tujintiamek? Ti untsurí̱ etserturmainiatsuk.” ");
INSERT INTO jivNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tura Jesus nunasha áikchamiayi. Túmakui Piratu ti enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Shuar ámiayi, ni naari̱ Parapás. Niisha ni shuari̱ji̱a̱i̱ meset ámanum, shuaran maa asamtai sepunam eṉkeamuyayi. Tura námper tsawantai̱ Piratu sepunmaya̱ chikichík shuarnak jí̱i̱ki akupniuyayi, aents seawarmia nuna. ");
INSERT INTO jivNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nui̱sha untsurí̱ shuar Piratun káutkar tiarmiayi “Ame ju̱ námpertin tuke túramna nu túratá. ");
INSERT INTO jivNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Patri uuntri̱ Jesusan kajeraru ásar surukarmiayi. Piratusha, nuna nekáa chicharainiak “Israer-shuartiram ¿atumí akupniuri̱n ji̱i̱ki akupkattajak? ¿Nu wakerarmek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tutai Patri uuntri̱ áentsun chichainiak ““Antsu Parapás jí̱i̱kim akúpkatá” titiarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tutai Parapásan seawarmatai Piratu ataksha chicharainiak “Jesusnasha, átum ii akupniuri̱ tarumna nuna, ¿itiurkattaja?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ataksha ni kakantar tiarmiayi “Krúsnum mantamnati.” ");
INSERT INTO jivNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piratusha nin tiarmiayi “¿Warí tunaana túriniait?” tímiayi. Takui niisha nú naṉkaamas kakantar tíarmiayi “Krúsnum mantamnati.” ");
INSERT INTO jivNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tuma asamtai, aents shiir enentáimprartí tusa, Piratu tunáa shuaran, Parapásan ji̱i̱ki akupkamiayi. Tura Jesusnasha katsumkarum krusnum ajintrurtarum tusa suntaran tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tiniu asamtai suntar Jesusan jukiar, kapitiáni je̱e̱n awaya̱warmiayi. Nu je̱a̱ naari̱ Piritiúriuiti. Túrawar untsurí̱ suntaran untsukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ashí káunkar, pushin kapa̱a̱nniun Jesusan áentsrarmiayi. Tawasap jaṉki najanamun etseṉkrumtikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nui̱sha Jesusan áujsar “Shíiraitme, Jesusá, Israer-shuara akupniuri̱ya” wishikiainiak tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Muuknumsha sapapja̱i̱ awatiarmiayi; nuyá usukiawarmiayi, túrawar ántar tikishmatrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tura Jesusan wishikrar amukar, kapa̱a̱ntin pushin áitkiar, ni pushiri̱n áentsrarmiayi. Túrawar krúsnum ajintrurtai tusar jí̱i̱kiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Semuṉ Serini núṉkanmaya̱ shuárauyayi. Arijantruncha, Rupuncha aparí̱yayi. Semuṉkan takatnumia̱ winian suntar emetawarmiayi, Jesusa krusri̱n yanaki jukiti tusar. ");
INSERT INTO jivNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesusnasha Kúrkuta náinnium júkiarmiayi. Kúrkuta, shuar chichamja̱i̱nkia, muuka ukunch naint, tutainti. ");
INSERT INTO jivNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jeawarmatai, karía, mira kuṉkuinja̱i̱ pachimprar áartaj tusa susarmiayi Jesusan. Túrasha umarchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Nantu yakí jatemsamtai krúsnum ayapar ajintrurar ikiusarmiayi. Túrawar suntar yaki jukit tusar nakurutaiji̱a̱i̱ nakurusar Jesusa pushiri̱n yaruakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Urukamtai máamuit, ashí aents nuna nekaawarat tusa, ni krúsri̱n ju̱ aarmauyayi: ISRAER SHUARA AKUPNIURI̱ ");
INSERT INTO jivNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nu náinnium jimiará kasa shuaran Niiji̱a̱i̱ máawarmiayi. Chikichik Jesusa untsuuri̱ni̱ krúsnum, chikichik ni menaari̱ni̱ krúsnum máawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yus-Papinium aarma ana nuja̱i̱ uminkiauyayi. Nui̱ “tunáa shuarja̱i̱ nekapmarmauyayi” tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Shuar naṉkaamainiak, muuke̱ pearar, Jesusan katsekainiak tiarmiayi “Iisia, amesha, “Yusa Uunt Je̱e̱n yumpuṉtiatjai, tura menaintiú tsawantai̱ ataksha jeamkattajai” tíchakaitiam, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Amek krúsnumia̱ akaikim uwemprata.” ");
INSERT INTO jivNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Núnisaṉ Patri uuntri̱sha, Israer-shuara jintinniuri̱sha Jesusan wishikrar chicharnaisarmiayi “Chikichan uwemtikraitiat, Niṉki uwempratniun tujintiawai. ");
INSERT INTO jivNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yusa anaikiamuri̱ Krístuashit, ii akupniuri̱niashit, tiarmiayi. Wats, yamái krúsnumia̱ akáikití, iisha nu íisar Yus-shuar ajastai” wishikiainiak ántar nuna tiarmiayi. Jesusja̱i̱ krúsnum ajintruamusha Nin wishikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tutupin jeamtai ti kiritin ajasmiayi ashí nuṉkanam. Tura, nantu nuṉkaach ajasmatai ataksha tsaapnirmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nuiṉ Jesus kakantar untsumuk tímiayi “Iruí, Iruí, rama sapaktani.” Nuka shuar chichamja̱i̱ṉkia, “Yusrú, Yusrú, ¿urukamtai ajapa ikiurkiniam?” tawai. ");
INSERT INTO jivNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Shuar nui̱ pujuarmia nu, nu chichaman nékachu ásar, nuna antukar “Eríasan untsúawai” tíarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chikichik shuar churuinian uruchja̱i̱ ajamper, sapapja̱i̱ ijiú mukunati tusa susamiayi. Tura tímiayi “Wajastarum, Erías Nin jukitiaj tusa winishtimpiash. Iistai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nuiṉkia Jesus kakaram untsumak jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Túramtai Yusa Uunt Je̱e̱n ejamu niṉki ja̱a̱nakmiayi, yakíya̱ nuṉká. ");
INSERT INTO jivNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Suntara kapitiántri̱sha Jesusan ayamtus wajamia nu, Jesus kakaram untsumak jaamun iis tímiayi “Nuka ti nekas Yusa Uchiri̱yayi.” ");
INSERT INTO jivNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nuwa̱sha arant ii pujuarmiayi. Nu nuwa̱ja̱i̱ Máktara péprunmaya̱ Marí, chíkich Marisha, Sarumáisha pujuarmiayi. Chíkich Marisha uchich Jakupuncha Jusencha nukurí̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu núwa̱ka, Kariréa nuṉkanam Jesus wekaimia nui̱, Nin nemarsar yáiṉtaitsar wekasarmiayi. Untsurí̱ chíkich nuwa̱sha Jesusja̱i̱ Jerusaréṉnum wear, nu nuwa̱ja̱i̱ arant ii pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ki̱atemamtai, ayampratin tsawant jeatsa̱i̱ṉ, námper iwiaratin tsawant asamtai, ");
INSERT INTO jivNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimiatíanmaya̱ Jusé arantutsuk, kakaram ajas, Piratuí jeá Jesusa aya̱shi̱n seatajtsa utuamiayi. Nu Jusencha ashí irunin ainia nu anturin ármiayi. Niisha Yus ju̱ nuṉkanam akupin ajasat tusa nákasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tura Jesusa aya̱shi̱n seam, Piratusha “wárik jaka” tímiayi. Tuma asa suntara kapitiántri̱n untsurak “¿Nekas jakayik?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tutai kapitián “Ee” takui, Jesusa aya̱shi̱n Jusen tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jusesha puju tarachin péṉkeran sumarak, Jesusa aya̱shi̱n itiar áepas penuarmiayi. Tura yamaram kaya táurmanum ikiusmiayi. Ikius wáitiniam kayan átutmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tura Máktaranmaya̱ Marí, Jusé nukurí̱ Mariji̱a̱i̱ ni ikiuamun ii wajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tura ayampratin tsawant naṉkaamasmatai, Máktaranmaya̱ Marisha, Jakupu nukurí̱ Marisha, Sarumáisha, kuṉkuinian Jesusa aya̱shi̱n kuertai tusar sumakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tura kashin Tumiṉtin, ti káshik, nantu yáma jiiniai, iwiarsamunam jeariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wésar chichainiak “Iwiarsamu wáitiri̱ kayancha ¿yaki akaṉketramkattajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jear uunt kaya akaṉkekman wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iwiarsamunam waya̱war, natsan esaram puju pushin entsar, untsuurnumaani̱ pujan wáinkiar ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Túmainiakui natsa tímiayi “Ashamkairap. Nasarétnumia̱ Jesus krúsnum jakama nu é̱a̱rme. Iniantkimiuiti. Jui̱ pujatsui. Wátsek, ju̱ ikiusmanum íistarum. ");
INSERT INTO jivNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Túrarum werum Pítrusha, chíkich unuiniamuri̱sha ju̱ ujaktarum. Kariréanam atumin émkiyi. Turammarumna núnisaṉ túruna wáinkiattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Niisha ti ashamainiak purushniarar iwiarsamunmaya̱ tseke̱ wearmiayi. Ti ashamainia ásar, chikichkinkesha ujakcharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Émkaka Tumiṉtin ti káshik Jesus nantaki, Máktaranmaya̱ Marin wantintiúkmiayi. Nu María enentái̱ya̱ siati iwianchin Jesus yaunchu ajapruyayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Marisha Jesusa nemari̱ kúntuts uutu matsatainian werí, “Jesus iwiaakui, imia wi wainkiajai” tímiayi. Támaitiat anturkacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tura urum jimiara shuar Jerusarénnumia̱ tsaniṉ weenan, Jesus nusháa iira ajas tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Niisha Jesusan wáinkiar waketkiar, unuiniamuri̱n ujakarmiayi, tura ni chichame̱ncha anturkacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nuya̱sha Jesusa auntse unuiniamuri̱ misanam pekaamkar pujuinian Jesus tarimiayi. “¿Atumí enentái̱ urukamtai kátsuram ainia, urukamtai Winia nekas enentáimtursachuram?” tímiayi. Ni nantakmiari̱n wáinkiaru chichame̱n anturkacharu ásarmatai kakantramiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nuyá chichaak “Ashí nuṉkanam wetarum. Túrarum ashí shuarnum Yusa shiir chichame̱ etserkatarum. ");
INSERT INTO jivNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Shuar anturak imiani uwemprartatui. Shuar antukcharka, tuke sumamawartatui. ");
INSERT INTO jivNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Shuar winia náarun pachis, Yúsan nekas enentáimtakka, ju̱na túrawartatui, Yusa kakarmari̱n iniakmastaj tusa: iwianchin ji̱i̱ki akupkartatui; chíkich chichamja̱i̱ chichasarukamtai Winia nekas enentáimturtatui; ");
INSERT INTO jivNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","napincha achiksha, tseasnasha úmaksha, jaa ajaschartatui. Jaa shuaran ni uweje̱ja̱i̱ antiṉ, nu shuaran péṉker awajsartatui.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus chichas amukmatai, Yus nayaimpiniam jukimiayi. Túruna Yusa untsuuri̱ni̱ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ni unuiniamuri̱sha jíinkiar, ashí nuṉkanam Yus-Chichaman etserkarmiayi. Tura Uunt Yus nin yáiṉmiayi. Tura etserainiakui, ashí aents ni kakarmari̱n nekaawarat tusa, aentsti tujintiamun túratniun susamiayi. Nuke atí.");
INSERT INTO jivNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nekas iiní̱ Jesus túramia nuna “ímiatrusaṉ áartajai” untsurí̱ aents tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yámankamtaikniumia̱ṉ íisarmia nú shuar, tura Yus-Chichaman etserkatniun yáinkiarmia nusha in unuitiamprarmia nútiksaraṉ áartinian wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wisha núnisnak esetsaran enentáimsan, yámankamtaikniumia̱ nuna nekaamjai. Tuma asan túrunamia nuna ímiatrusnak amincha áatratajtsan wakerimjiame, winia úuntur Tiupiru. ");
INSERT INTO jivNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jintintramawarma nú naṉkaamas nekaata tusan wakerakun áatjame. ");
INSERT INTO jivNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jutía nuṉkanam uunt akupin Erutis akupkamia nú tsawantin Israer-shuar Yúsnan pujurin ámiayi, ni naari̱ Sakarías. Niisha Aptías weeauyayi. Ni nuwe̱sha Irisapít Aruṉ weeauyayi. Irisapítia úuntri̱sha Israer-shuar Yúsnan pujurin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yúsja̱i̱sha Sakaríassha Irisapítcha mái-metek péṉker ármiayi. Yus akupkamia nunasha umirin ármiayi. Tuma asamtai peṉkesha chíkich nin yajauch chicharkatin atsuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yusja̱i̱ péṉker wekainiayat Irisapít júrechuyayi. Túrasha mai úuntach ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Israer-shuar Yúsnan pujurin chíkich weeanmaya̱ nuyá chíkich weeanam, aṉkant aṉkant Yusa je̱e̱n takáu ármiayi. Chíkich tsawant, Sakarías weeá takastin amia nui̱, Sakaríaska kuṉkuinian ekeemaktaj tusa init waya̱tniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Init kuṉkuinian ekeemai̱ untsurí̱ aents aani matsamsar Yúsan áujtak pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakarías init pujai̱ kuṉkuin ekeematainiam untsuurnumaani̱ aya aneachma nayaimpinmaya̱ suntar wajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nuna wajan wáiniak Sakaríaska purushnairmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Túrasha nayaimpinmaya̱ suntar chicharuk tímiayi “Sapijmiakaip Sakaríasa. Nekaata. Ame seamna nuna Yus anturtamkayi. Tura ame nuwe̱m Irisapít uchin takustatui. Nii akiiniamtai, “Juaṉ” anaikiata. ");
INSERT INTO jivNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Ame uchiram akiiniattana nuka Yusja̱i̱sha naṉkaamantu átatui. Tuma asamtai akiiniamtai, amesha shiir enentáimsam warastatme. Tura chíkich aents untsurí̱ warasartatui. Ame uchirmesha karía ainia nuna umarchattawai. Tura áetak akiinchanak Yusa Wakaní̱ pimiutkattawai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tura ni shuari̱n Israer-shuar áiniana nuna, ii Uuntri̱ Yusja̱i̱ ataksha nawamtikiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uunt Yúsai̱ya̱ akatramu átatui. Yaunchu Yúsnan etserin Erías kakaram etserkamia núnisaṉ niisha etserkattawai. Nuja̱i̱ shuaran ni uchirí̱ji̱a̱i̱ nawamtikiartatui. Tura umichu áinia nuna eseer enentáimtikrartatui. Ni Uuntri̱ taakui ni enentái̱ iwiaramu arti tusa etserkattawai” tímiayi nayaimpinmaya̱ suntar. ");
INSERT INTO jivNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nuna takui Sakarías nayaimpinmaya̱ suntaran tímiayi “¿Nunasha wariji̱a̱i̱ṉ paant nekaataj? Wisha nua̱rja̱i̱ mái-metek ti úuntchichukaitiaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tutai nayaimpinmaya̱ suntar tímiayi “Wikia Kapriiraitjai, Yusa suntari̱ntjai. Nii akatturmatai chichastájam tusan tura nu shiir chichaman ujaktájam tusan tarijme, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Túrasha wi tájamna nu “nekasaiti” tu enentáimprachume. Tura asam uchiram akiintsa̱i̱ṉ muut ajastatme. Chichastin peṉké tujinkiattame. Tura wi tajana nu, tsawant jeamtai túrunattawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nuna tumai̱ Yusa je̱e̱n aani pujusar, Sakaríasan nákas pujuarmiayi. “¿Urukamtaik init we imiá meṉkaka?” tu enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nuyá Sakarías jiinkimtai, áujsartaj tukamá tujinkiarmiayi. Sakaríaska, muut ajasu asa, aya úwijmiasaṉ chichamiayi. Túmakui, Sakarías init pujus Yúsai̱ wáimiakun nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yusa je̱e̱n takastin tsawantri̱ amuukamtai Sakaríaska ni je̱e̱n waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nuyá ukunam ni nua̱ri̱ Irisapít ajaprukmiayi. Tura seṉku nantutin aya je̱a̱ṉ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Je̱á pujus, “Aents wishikruiniakui natsantan jurutkitiaj tusa uchi takustinian Yus tsaṉkatrukai” tu enentáimpramiayi Irisapít. ");
INSERT INTO jivNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nu seṉku nantu naṉkaamasmatai Yus ni suntari̱n Kapriiran Nasarét péprunam akupkamiayi. Nu pepru Kariréa nuṉkanam pujawai. ");
INSERT INTO jivNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nasarétnumia̱ nuwa̱n, naari̱ Marí, iyutí tusa akuptukmiayi. Nu núwa̱ka áishmaṉja̱i̱ pujuchuyayi. Niisha Juseja̱i̱ nuatnaikiatsa anajmanair pujumiayi. Juseka uunt Tawit weeauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wats, nayaimpinmaya̱ suntar Marí pujamunam wayá tímiayi “Yus péṉker enentáimturma asamtai, ámin winitjiame, Mariya. Yuska ámin nemartamuk ashí nuwa̱ naṉkaamas péṉker awajtamui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tura Marisha nayaimpinmaya̱ suntaran wáiniak, chichaamun nékatsuk “Urukamtaik tu chicháa” tu enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nuyá nayaimpinmaya̱ suntar chicharuk tímiayi “Mariya, sapijmiakaip. Yus shiir enentáimturmawai. ");
INSERT INTO jivNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Antukta. Amesha ajapruktatme. Túram Uchi takustatme. Nusha “Jesus” anaikiata. ");
INSERT INTO jivNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Niisha uunt átatui. Nincha “Uunt Naṉkaamaku Yusa Uchiri̱” tiartatui. Tura Uunt Yuska yaunchu Tawitian uunt akupniuri̱ awajsamia núnisaṉ ame Uchirmin ame shuárumin Israer tutain Uunt akupin awajsattawai. Ni akupeamuri̱sha Yus susamu asa peṉké amuukashtiniaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nayaimpinmaya̱ suntar nuna tutai Marí tímiayi “Nusha winia áishur atsai̱sha, ¿itiurak túrunataj?” ");
INSERT INTO jivNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tutai nayaimpinmaya̱ suntar Marín tímiayi “Yusa Wakaní̱ tarutramtatui. Tura yuraṉmia núnisaṉ Uunt Yusa kakarmari̱ ijirmattawai. Nu tuma asamtai Uchi akiiniattana nu Yúsai̱ya̱ asamtai, “Yusa Uchirí̱nti” tiartatui, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tura Irisapít ame kaná kaimia nusha núnisaṉ weamtanam ajaprukai. Iis, “júrechuiti” tiarmia nu, yamaikia sais nantu pujawai ajamtin. ");
INSERT INTO jivNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yúsja̱i̱ṉkia itiurchatka peṉké atsawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tutai Marí tímiayi “Yus wakeramun túriniaitjai wikia. Ame tame nuna Yus wakerana nuna túrutati, tajai” tímiayi. Nuna tímiatai nayaimpinmaya̱ suntarka wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Nu tsawant Marí wárikmas muranam Jutía nuṉkanam ni kaná kai̱n Irisapítian iyutaj tusa wémiayi. Sakaríasai̱ jeá, ni je̱e̱n wayá, Irisapítian áujsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Marí áujeamun antukmatai Irisapítia ampujé̱n uchiri̱ muchitkiamiayi. Tumai̱ Yusa Wakaní̱ ni enentái̱n pimiutkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nuiṉkia kakantar chichaak Marin tímiayi “Yus amincha ti shiir awajtamsaiti. Tura Uchiram akiiniattana nusha Yus shiir awajsamuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kai̱rua, ame winia Uuntru nukurí̱ áminiṉ, Yus winia ti waitnentra asa, áujsata tusa ámin akuptamkachaik, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Warí, wisha ame áujtamna nuna ántakui ampujrui̱ uchi waras muchitrutkayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amesha Yus turámiania nu umikiu asam shiir pujame. Yus tímia nu túrunattawai auka” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nuna tinia iniaisamtai Marí ju̱na tímiayi: “Wikia tuke enentairja̱i̱ “Yus timiá úuntaiti” tajai. ");
INSERT INTO jivNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tura Uunt Yuska winia Uwemtikruru asamtai ti waraajai. ");
INSERT INTO jivNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Wisha péejchach aiṉ ni wakeramuri̱n umiktajtsan wakerakui winia enentáimturayi. Tuma asamtai ashí aents, “Marincha Yus shiir awajsaiti” tuke turutiartatui. Yuska imiá peṉker tura imiá kakaram ana nu winia ti uuntan túrutaiti. Tuma asamtai ashí aents “Marincha Yus shiir awajsaiti” turutiartatui. Núnaka yamái naṉkamamunak tuke turutú ajartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tura Nin umirkatniun wakerana nunasha Yus tuke waitnentrartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti itiurchatan páchitsuk túraiti Nii. “Naṉkaamantuitjai” tu enentáimtumainia nuna nupetkaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ashí akupin ainia nuna awakkaruiti. Tura íksaṉ péejchach ainia nuna uunt awajsaruiti. ");
INSERT INTO jivNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Péṉker ana nuna kitiamainiakui Yus péṉkeran súsaruiti. Tura antsu “ashí takakjai” tuinia nuna aya jú̱nik awajsaruiti. ");
INSERT INTO jivNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israer-shuar Niiniu ájinia núnaka waitnentratniun kajinmattsuk yáinmákuitji. ");
INSERT INTO jivNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yaunchu ii Uuntri̱ Apraáman tura ní shuarnasha “túrattajai” timia nuna ímiatrusaṉ tuke túraiti.” Nuní tímiayi Marí. ");
INSERT INTO jivNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marikia Irisapítja̱i̱ menaintiú nantu pujus ni je̱e̱n waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nuya̱sha ni jurertin tsawantri̱ jeamtai Irisapítcha uchin áishmaṉkan takusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tura ni shuari̱sha, ni írutramuri̱sha “Irisapítian Yus ti shiir yáiṉmiayi” tuíniak, nin iyuwearmiayi. Tura mái-metek warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Israer-shuar túrutai jú̱nisaiti: uchi akiiniamuri̱ uchu tsawant jeamtai, shunichiri̱ nuape̱n tsupiktin awai, sirkunsisiún tutai. Yus nuna tú tiniu asamtai tuke túrin ármiayi. Wats, Irisapítia uchiri̱ akiiniamuri̱nia̱ uchu tsawant jeamtai tsupirkatai tusar ni je̱e̱n jearmiayi. Nuiṉkia ni apari̱ naari̱ Sakarías anaikiataitsar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tura ni nukurí̱ tímiayi “Atsá. Antsu ni naari̱ Juaṉ átatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tutai tiarmiayi “¿Nusha urukamtia? Amée shuarumsha nu náartincha áwak’ tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nuiṉkia uchi aparí̱n “¿Warí anaikiatajtsam wakeram?” tusar aya úweje̱ja̱i̱ṉ iniasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tutai uchí aparí̱sha “Nakash surusta; áartaj tusan wakerajai” tusa aya úweje̱ja̱i̱ṉ iniakmamiayi. Takui nakash susam, ni naari̱ Juáṉkaiti, tu áarmiayi. Nuna wáinkiar “Ayawa̱ urukakuṉ ta” tu enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nú chichamaik Sakarías chichatsuk pujamun chichakmiayi. Tura nuiṉ Yusa náari̱ncha shiir awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nuiṉkia ni írutramuri̱sha ashamkarmiayi; tura ashí Jutía nuṉka murá amia nui̱ nu túrunamun ujakam ashí nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nu túrunamun antukar ti enentáimsarmiayi. Tura “ju̱ uchin Yus nekas pujurtsuk. Tuma asamtai uunt ajas ¿urukuk ati?” tu enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Uchí aparí̱ Sakarías, Yusa Wakaní pimiutkam tura Yus jintintiam, ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israer-shuartí ii Yusri̱ naari̱ shiir awajsatniuitji. Ii Yúsri̱sha tarutmaitji. Tura uwemtikrampraitji. ");
INSERT INTO jivNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yaunchu ii uuntri̱ Tawit Yusa wakeramuri̱ji̱a̱i̱ uunt akupin áchamkia. Tura ni ukuri̱n ti kakaram Uwemtikkiartinian suramsaitji. ");
INSERT INTO jivNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","72","Yuska ii nemasri̱ya̱ tura in nakitramainiajnia nuyá uwemtikrampratniun enentáimsamia nuna, yaunchu ni etserniuri̱n péṉker armia nuna ujakmiayi. “Winia ti peṉker chichamprun tájana nuna yapaji̱tsuk umirkan tuke wáitnentratajrume” yaunchu ii úuntri̱n tímiania nunasha ni etserniuri̱n ujakarmiayi. Yaunchu nu ujakma yamái iisha wainji. ");
INSERT INTO jivNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Nu ujakman Yuska yámankamtaik imiá yaunchu ii uuntri̱ Apraáman tíchamkia. Apraáman ujakmia nu jú̱iti: “Wi wakeraj nútiksaran, Winia umirtukar péṉker wekainia nuna ni nemasri̱ya̱ uwemtikrattajai. Sapijmiatsuk winia tuke takartusarat tusan túrattajai” Yus tímiayi Apraáman. Iisha ni shuari̱ asakrin, nuna taku incha túramaji. ");
INSERT INTO jivNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tura amincha, uchiru, “Uunt Yusna etserniuiti” turamartatui. Amesha ni tátintri̱ iwiarataj tusam Uuntai̱ émkim wétatme. ");
INSERT INTO jivNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni shuari̱, ni tunaari̱ tsaṉkurnar uwemprarat tusam túrattame. ");
INSERT INTO jivNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Yuska ashí shuaran anea asa, incha wáitnentramak ni pujamunmaya̱ ni tsáapnintri̱n suramsaitji. Ni enentái̱n kiritniunam wekainia nuna, mesertinnium jeatemá ásarmatai, ni tsáapnintri̱ jeatⁱ tusa túraiti. Tura ashí incha ii enentái̱n imiatkinchanum wekasarmí tusa túraiti.” Nuní tímiayi Sakarías. ");
INSERT INTO jivNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uchisha tsakarmiayi. Tura Yúsan nekaki-nekaki wémiayi. Israer shuarnum etserkatin tsawantri̱ jeatsa̱i̱ṉkia atsamunam pujuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wats, Juaṉ akiiniamia nú uwitin uunt akupin Akustu ashí nuṉkanam áentsun nekapmarartí tu chichakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nu nekapmartinian yaunchu túrushtain yamái túriarmiayi. Siria nuṉkanam Seriniu akupin pujái̱ túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ni naari̱ áartaj tusa ashí shuar ni nuṉke̱niṉ wétin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tuma asamtai Jusé Nasarét péprunmaya̱ Kariréa nuṉkanam amia nuyá jiinki Piriṉ péprunam Jutía nuṉkanam amia nui̱ wémiayi. Juseka Tawit weeanam akiinia asa, ni nekas nuṉke̱ṉka Piriṉkauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nu asamtai, ni náari̱n áartaj tusa Jusé wémiayi Mariji̱a̱i̱. Marisha Jusé núwe̱yayi. Tura tsaniṉcharuyayi. Túmaitiat Marisha Yusa Wakaní̱ kakarmari̱ji̱a̱i̱ ajamtiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tura nui̱ Piriṉnum pujuiniai̱ Marí takustintri̱ jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nui̱ iwia̱i̱ri̱n uchin áishmaṉkan takusmiayi. Tura uchi penutaiji̱a̱i̱ penuar, waaka yurumtainiam áepsamiayi. Írar kanutainiam pujustin aṉkant atsá asamtai túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tura Piriṉnum tíjiu̱ch murikiun wáinin kashi murikri̱n wáiniuk pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Túmainiai̱ nayaimpinmaya̱ suntar murikiun wáinin matsatainian wantintiukmiayi. Tura Yúsnumia̱ tsáapnin ni matsatainiamunam etsantramiayi. Túrunamtai murikiun wáinniuka ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Túrasha nayaimpinmaya̱ suntar tímiayi “Ashamprukairap. Ashí áentsnum ti warastin atí tusan ti peṉker chichaman itiarjiarme. ");
INSERT INTO jivNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jú̱iti: yamái tsawantai̱ uunt Tawitia pépruri̱n Piriṉnum yaunchu Yus anaikiamu KRISTU tutai, uwemtikramprataj tusa akiintiurmarme. Nu Uchisha ashí áentsun akupniuiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tura ju̱ja̱i̱ nekaattarme: uchi penutaiji̱a̱i̱ penuarma waaka yurumtainiam tepá wáinkiattarme. Nu wáinkiarum nekas jú̱iti, tu nekaattarme.” ");
INSERT INTO jivNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nu chichamaik nayaimpinmaya̱ suntar ti untsurí̱, nayaimpinmaya̱ káunkarmiayi. Túrawar Yusa naari̱n shiir awajainiak ju̱na tiarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nayaimpinmasha Yus naṉkaamantuiti tu enentáimtusarti. Tura ju̱ nuṉkanmasha Yusja̱i̱ nawamnaikiaru ainia nu imiatkinchanum pujusarti.” Tu tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tura Yusa suntari̱ nayaimpiniam waketkiarmatai murikiun wáinin tiarmiayi “Wats, Piriṉnum wárik wetái. Nu túrunamu Yus turamajnia nu iyumi” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nuna tiar wárik wearmiayi. Tura Marincha Jusencha wáinkiarmiayi. Tura uchincha waaka yurumtainiam tepan wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wear nuna wáinkiar, nayaimpinmaya̱ suntar uchi túrunamuri̱n timia nuna etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tura murikiun wáinin tiarmia nuna antukaruka ti enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Túrasha Marikia ashí túrunamia nuna ni enentái̱ji̱a̱i̱ṉkia enentáimtu pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tura murikiun wáinniuka antukarmia nuna enentáimtusar, tura íisarmia nunasha enentáimtusar “Nayaimpinmaya̱ suntar ujatmakmajnia tímiatrusaṉ túrunayi” tiarmiayi. Tuma ásar Yusa náari̱n shiir awajsar kantampruawar waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tura uchi akiiniamu uchu tsawant jeamtai, ni túrutairi̱n túrin ásar, ni shunichiri̱ nuapen tsupirkarmiayi. Túrawar Marí ajapratsa̱i̱ṉ nayaimpinmaya̱ suntar tímia nútiksaṉ “Jesus” anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tura Muisais akiiniatniunam akupkamia núnisaṉ, tsawantri̱ jeamtai, Yusa Uunt Je̱e̱n Jerusarénnum uchin Yus iiktustai tusar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kame Yus-Papinium ju̱ aarma awai: “Ashí uchi iwia̱i̱ri̱ áishmaṉ akiinkiuṉka Yusna átatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tuma asamtai, Marí Yusa Uunt Je̱e̱n wái̱tsuk pujamu waya̱tniuri̱ jeamtai, uchin Yus iistí tusa Yusa Uunt Je̱e̱n Jerusaréṉnum pujana nui̱ itiarmiayi. Tura yampitsan jímiaran súsarmiayi. Muisáis akupkamun umiiniak nuna túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nu túmai̱ Semeúṉ naartin áishmaṉ Jerusaréṉnum pujumiayi. Semeúṉsha Yusa Wakaní̱ pujurma asa péṉker áishmaṉkauyayi. Yúsan nekas enentáimtiniuyayi. Yusa anaikiamuri̱ji̱a̱i̱ Israer-shuar aṉkant ajastin jeati tusa nákauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“Winia anaikiamur KRISTU tutai wáintsuk jákashtatme” uunt Yusa Wakaní̱ tu jintintiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nú Semeúṉ Yusa Wakani “wetá” tutai, Yusa Uunt Je̱e̱n wémiayi. Tura nú tsawantai̱ Muisáis tímia núnisaṉ umirkatai tusar Marisha Jusesha uchin Jesusan Yusa Uunt Je̱e̱n itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Itiariarmatai Semeúṉ uchin jusa miniakas Yúsan áujuk ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yamaikia, Uunta, Ami̱i̱n wi jeatin aṉkant atí. Turutmiamna nu ímiatrusmek umikiume. ");
INSERT INTO jivNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ju̱ Uchi ashí aents uwemtikrartá tusam susamna nuna yamái imia winia ji̱i̱ruja̱i̱ wáinkiajai. ");
INSERT INTO jivNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Israer-shuarcha ainia nu tsáapninium wekasarat tusa akuptukmaiti ju̱ Uchi. Tura Israer-shuar Áminiuram ájinia nuna ashí aents shiir enentáimtikrartí tusam ju̱ Uchi akuptukmaitji. Nuna wáinkian shiir enentáimsan jákatniuitjai.” ");
INSERT INTO jivNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tura Semeúṉ Uchiniun tu chicharkui Jusesha Jesusa nukurí̱sha ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Semeúṉsha chichaak “Yus shiir enentáimturmasartí” nin tímiayi. Nuya̱sha Marin chicharuk tímiayi “Nekaata. Ju̱ Uchin Israer-shuartisha untsurí̱ nakitrar iniarartatji. Tura chíkich Israer-shuartikia ju̱ Uchin shiir enentáimtusar ti wararsartatji. Tura Uchiram Yusa kakarmari̱n ti paant iniakmastatui. Tuma aiṉ untsurí̱ Aun yajauch chichariartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nuja̱i̱ shuar ni enentái̱n warinia enentáimia nu, paant átatui. Maaj, ashí nu túmakui, ijiumua núnismek ame enentáimin ti wáitsattame, Mariya.” Tu chichasmiayi Semeúṉ. ");
INSERT INTO jivNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nuwa̱sha Ana naartin nui̱ Yusa Uunt Je̱e̱n pujumiayi. Niisha Yúsnan etserniuyayi. Ni aparí̱sha Panuíruyayi tura Aser shuarauyayi nu nuwa̱. Niisha ti úuntchiyayi. Niisha yama nuatnaikiamuja̱i̱ siati uwi ni áishri̱ji̱a̱i̱ tsaniṉ pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tura waje̱mamiayi. Tura uchenta kuatru uwi takakuyayi. Tura niṉkia Yusa Uunt Je̱e̱nia̱ jíintsuk káshisha tsawai̱sha tuke Yúsan áujniuyayi. Tura yurumtsuk Yúsan áujniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Semeúṉ tuasua amikmatai Anasha taa, Uchin wáiniak Yúsan yumiṉsamiayi. Tura Jerusaréṉnum Yus uwemtikrampratai tusa nákarmia nuna áujkuṉka uchin áujmat wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nuyá Yus tímia nuna ashí túrawar amikiar Kariréa nuṉkanam, kame nii pujumia nú peprunam Nasarétnum Jusesha Marisha Uchisha waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uchi Jesus tsakaki, kakaram ajaki tura nú naṉkaamas nekaki wémiayi. Tura Yus Nin ti shiir awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jusesha, Jesusa nukurí̱sha tuke uwitin paskua námper jeakui Jerusaréṉnum weu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ni túrutairi̱ túruiniak, Jerusaréṉnum weak Jesusan tuse uwí jeamtai júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Námper amuukamtai ni nukurí̱sha Jusesha nékachmanum Jesuska Jerusaréṉnum juákmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Marisha Jusesha “wíi shuarja̱i̱ winiawai” tusa, núnaka e̱a̱tsuk chikichík tsawant wekasarmiayi. Nuyá wáinkiataj tukamá, ni shuari̱i̱n tura ni nékamunam e̱a̱karsha, ");
INSERT INTO jivNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","wáinkiacharmiayi. Nuiṉkia Jerusaréṉnum ataksha waketrukiarmiayi, e̱a̱ktai tusar. ");
INSERT INTO jivNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tura menaintiú tsawant e̱a̱kar Yusa Uunt Je̱e̱n Yus akupkamun jintinnian anturak anintrú pujan wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tura nui̱ ashí Jesusan anturkarmiania nu, niisha ti nékakui tura áimtanash ti péṉker áimkiui, ti enentáimturarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ni aparí̱sha nukurí̱sha tumáa pujan wáinkiar, ti enentáimprarmiayi. Tura ni nukuri̱ chichaak tímiayi “Uchiru, ¿ausha urukamtai itiurchat enentáimtikrurmam? Ame apasha wisha urukayik tusar ti e̱a̱kjame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tutai Jesus tímiayi “¿Urukamtai e̱a̱trum? Winia Aparnan túratniuitjiana nuka nékatsrumek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tura timia núnaka peṉké nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nuyá Jesus niiji̱a̱i̱ Nasarétnum waketkimiayi. Ninkia tuke umiriarmiayi. Ashí nu túrunamun Marikia tuke enentáimtu pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuska tsakaki, tura nekaki wémiayi. Yussha tura aencha Nin shiir enentáimtiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tipiriu uunt akupin pujamu kiṉse uwí jeamtai, Jutía nuṉkanam Punseu Piratu akupin pujumiayi. Tura Kariréa nuṉkanam Erutis akupin pujumiayi. Itiurea nuṉkanmasha Trakuniti nuṉkanmasha ni yachi̱ Jiripi akupin pujumiayi. Tura Apirinia nuṉkanam Risanias akupin pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tura nu uwitin Anassha Kaipiássha Israer-patri uuntri̱ pujuarmiayi. Nu uwitin Sakaríasa uchirí̱ Juaṉ atsamunam pujan Yúsai̱ya̱ chichaman antukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nuyá Jurtaṉ entsanam supichik matsamarma nuna Juaṉ wekaatusar ju̱na tímiayi “Winia tunaarun Yus tsankurturat tusarum, enentai yapaji̱árum imiantiarum.” Tu ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nu ujakman Isayas yaunchu ju̱na áarmiayi: Atsamunam wekaana nu untsumun ántuiniawai. Nii untsumuk ju̱na tawai: Atumí enentái̱ Uunta jinti̱ iwiarturtarum; naka awajsatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jápaaka ainia nusha áimkiamu arti. Naint ainia nusha paka awajsamu arti. Jintia apijiaru ainia nusha naka jiikmia arti. Tura pujutrin ainia nusha métekrak paka awajsamu arti. ");
INSERT INTO jivNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Túrunamtai ashí nuṉkanmaya̱ aents Yúsai̱ya̱ uwempratin aan nekaawartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Untsurí̱ aents imiatit tusar tariarmia nuna Juaṉ chicharainiak tímiayi “Napia áaniutirmincha, ti asutniátin jeatemáttana nuyá uwempratarum tusa ¿ya ujatmakuram? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Iikia Apraám weeaitji, tuma asakrin Yus shiir enentáimturmaji” tu enentáimtumasairap. Antsu enentáim yapaji̱ámuitkiuiṉkia péṉker wekaamurmi̱ji̱a̱i̱ paant iniakmastarum. Warí, Yus wakerakka, ju̱ kayan Apraáma shuari̱n páchitsuk najankainti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aneartarum. Numi ajaktinian kampuwári̱n jacha atuttsamuiti. Numi péṉker nereatsna nuka ajakar jinium apeamu ártatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tutai aentska enentáimprar “¿Nuiṉkia itiurkatjik?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tutai Juaṉ tímiayi “Jimiará pushin takakna nu, takaktsuna nuna chikichan súsatniuiti. Yurumkan takakna nusha takaktsuna nuna ajamsatniuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Uunt akupniu kuítri̱n juu armia nú shuar imiantiaj tusar Juáṉkan weriar aniasarmiayi. “Uunta, ¿iisha warí itiurkatjik?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tutai Juaṉ tímiayi “Kuit uunt akupin tana nu iniaṉkasrum achikiairap.” ");
INSERT INTO jivNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suntarsha aniasarmiayi “Uunta, ¿iisha warí itiurkatjik?” Juaṉsha tímiayi “Ame kakarmarmi̱ji̱a̱i̱ chikichna jurukip. Tura nin tsanumpruraip. Tura uunt akupin akirmana núja̱i̱ṉ warasta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","“Ju̱ Juaṉ Yusa anaikiamuri̱nchuashit” tu enentáimsar paant nekaataitsar nákarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tumai̱ Juaṉ tímiayi “Wikia aya aya̱shmin entsanam imiajrume. Tura wiji̱a̱i̱ naṉkaamas ana nu tátatui. Ni sapatri̱ jiṉkiamuri̱nkisha atitrachminiaitjai. Niisha taa, imiantinia áanis tura jíiya áanis Yusa Wakani̱n eṉketramprattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Shuar aruusan awa̱jtia núnisaṉ, nusha yajauch ana nuna ajapa aya péṉkernak júuktatui. Neren ikiustatui tura yajauchinkia ji tuke kajinchatainiam apeattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juaṉ nu arant shiir chichaman áentsun ti núkap ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tura nuya̱sha akupin Erutisan chicharkamiayi. Ni yachi̱ Jiripi nua̱ri̱n Jirutíasan kasarak nuatkui tura chíkich yajauchincha túrakui chicharkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tura Erutis núnaka ántutsuk chíkich yajauchin túramiayi. Juáṉkan achik sepunam eṉkeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nu túruntsa̱i̱ṉ, Juaṉsha ashí nú nuṉkanmaya̱ áentsun imiak pujurainai̱ Jesussha imianmiayi. Niisha Yúsan áujuk pujai̱ nayaimpisha uranmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tura Yusa Wakaní̱ yámpits najanar paant tarurmiayi. Tura Yus nayaimpinmaya̱ chicharuk “Amek winia aneamur Uchiruitme; Ámin ti wararjame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus trainta (30) uwí takaku asa ni takatri̱n naṉkamamiayi. “Jusé uchirí̱nti” tiniu armiayi. Jusésha Iría uchirí̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Irísha Matata uchirí̱yayi; Matat Riwí uchirí̱yayi; Riwí Mirkía uchirí̱yayi; Mirki Jana uchirí̱yayi. Jana Jusé uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jusé Matatíasa uchirí̱yayi; Matatías Amusa uchirí̱yayi; Amus Najuma uchirí̱yayi; Najum Esrí uchirí̱yayi; Esri Nakaia uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai Maata uchirí̱yayi; Maat Matatíasa uchirí̱yayi; Matatías Semái uchirí̱yayi; Semái Jusé uchirí̱yayi; Jusé Jutáa uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jutá Juana uchirí̱yayi; Juana Resa uchirí̱yayi; Resa Surupapira uchirí̱yayi; Surupapir Saratiira uchirí̱yayi; Saratiir Nerí uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Mirkí uchirí̱yayi; Mirki Atí uchirí̱yayi; Atí Kusama uchirí̱yayi; Kusam Irmutama uchirí̱yayi; Irmutam Ira uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ir Jusué uchirí̱yayi; Jusué Irieséra uchirí̱yayi; Iriesér Jurema uchirí̱yayi; Jurem Matata uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Riwi uchiri̱yayi; Riwí Semeúṉka uchirí̱yayi; Semeúṉ Jutáa uchirí̱yayi; Jutá Jusé uchirí̱yayi; Jusé Junaṉka uchirí̱yayi; Junaṉ Iriakímia uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iriakím Mirea uchirí̱yayi; Mirea Mainiáṉka uchirí̱yayi; Mainiáṉ Matata uchirí̱yayi; Matata Nataṉka uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nataṉ Tawitia uchirí̱yayi; Tawit Isaí uchirí̱yayi; Isaí Upitia uchirí̱yayi; Upit Puusa uchirí̱yayi; Puus Saramúṉka uchirí̱yayi; Saramúṉ Naasuṉka uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasuṉ Aminiatapa uchirí̱yayi; Aminiatap Arama uchirí̱yayi; Aram Esruma uchirí̱yayi; Esrum Paresa uchirí̱yayi; Páres Jutáa uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jutá Jakupa uchirí̱yayi; Jakup Isaka uchirí̱yayi; Isak Apraáma uchirí̱yayi; Apraám Tarea uchirí̱yayi; Taré Nakura uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakur Seruka uchirí̱yayi; Seruk Rakaua uchirí̱yayi; Rakau Pirikia uchirí̱yayi; Pirik Epera uchirí̱yayi; Eper Sará uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sara Kainiáṉka uchirí̱yayi; Kainián Arpaksata uchirí̱yayi; Arpaksat Sema uchirí̱yayi; Sem Nuaia uchirí̱yayi; Nuai Ramikia uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramik Matusaríṉkia uchirí̱yayi; Matusaríṉ Enuka uchirí̱yayi; Enuk Jaritia uchirí̱yayi; Jarit Maararíira uchirí̱yayi; Maararíir Kainiaṉka uchirí̱yayi; ");
INSERT INTO jivNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainiaṉ Enusa uchirí̱yayi; Enus Seta uchirí̱yayi; Set Ataṉka uchirí̱yayi; tura Ataṉ Yus najanamuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesusa enentái̱n Yusa Wakaní̱ pimiutkamiayi. Jesussha Jurtaṉ entsanmaya̱ waketkimtai Yusa Wakaní̱ aents atsamunam jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tura nui̱sha kuarenta tsawant pujusmiayi. Tura íwianch Nin tunaanum aju̱araintiajtai tusa pujurmiayi. Nu kuarenta tsawantin Jesus yurumtsuk pujá asa ti tsukammiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nuiṉkia íwianch chicharuk “Amesha nekas Yusa Uchirí̱ntkiumka ju̱ kaya apatuk najanata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tutai Jesus tímiayi “Yus-Papí tawai: “Aya apatkuja̱i̱ṉ shuar iwiaaku pujuschamniaiti. Antsu ashí Yus-Chicham tana nuja̱i̱ nekas iwiaaku pujusminiaiti,” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tura nuyá íwianch naint yakí wájakmanum jukí, ashí nuṉka ainia nuna ju̱ chichamaik iniaktusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Tura chicharuk tímiayi “Ashí ju̱ nuṉka wáinmena nu wíniaiti. Tura wi wakerajna nú shuaran súsatniuitjai. Tuma asamtai tikishmatrurakminkia ju̱ nuṉkanam ashí akupkatniun susattajme. Tura nui̱ ni wariri̱ ainia nusha áminiu átatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tutai Jesus tímiayi “Yus-Papí tawai: “Aya Niṉki Yus ame Úuntrum tikishmatram enentáimtustiniaitme.” Tau asamtai, werumta, iwianchi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ataksha íwianch Jesusan Jerusaréṉ péprunam jukimiayi. Tura Yusa Uunt Je̱e̱ yakiini iwiak tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Yus-Papí tatsuk: “Yuska ni suntari̱n wáinkiatá tusa akupturmaktatui. ");
INSERT INTO jivNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kayanam ajintra̱i̱ṉ tusa weṉkurmaktatui.” Tuma asamtai nekas Yusa Uchiri̱nkiumka ju̱yá akaikim iniaata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tutai Jesus áimiuk tímiayi “Yus-Papí ju̱nasha tawai: Yus ame Úuntrum nekapsataj tiip.” ");
INSERT INTO jivNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tuma asamtai íwianch peṉké tujintiak ishichik tsawant Jesusan iniaisamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus ni enentái̱n Yusa Wakaní̱ kakarmari̱ pimiutkamu ajas Kariréa nuṉkanam waketkimiayi. Nu nuṉkanam naṉkaamantu túramuri̱n áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nu nuṉkanam ashí péprunam Israer-shuar iruntai je̱a̱ armia nui̱ unuiniarmiayi. Tura anturkarmia nuka ni náari̱n shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ni tsakarmari̱i̱n Nasarétnum Jesus wémiayi. Tura Israer-shuar ayampratin tsawantin iruntai je̱a̱nam waya̱miayi, tuke turin asa. Tura wayá Yus-Papin áujsataj tusa wajakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nui̱ṉkia Yúsnan etserin Isayasa áarmari̱n súsarmiayi. Nuna urak, nui̱ ju̱na áarman wáinkiamiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yusa Wakaní̱ winí pujurtawai. Shuar warainiachun shiir chichaman ujaktinian anaitiukuiti. Kúntuts enentáimiar wake mesek pujuinian tsuártinian akuptukuiti. Tura ji̱i̱ kusuruncha íimtiktinian, tura yajauch awajsamu ainia nuna péṉker awajsatniuncha, ");
INSERT INTO jivNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tura Uunt Yus, shuáran yaiṉtin tsawantri̱ jeán etserkatniuncha akuptukuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nu áarman aujsua amik papin nukukmiayi. Tura iruntai je̱a̱nam yáimin pujan susa iniais Niṉkia etserkataj tusa pujusmiayi. Tura ashí shuar pujuarmia nu émamkes ii pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesussha chicharuk tímiayi “Yus-Chicham yamái antukurmena nu yamái tsawantin túrunayi.” ");
INSERT INTO jivNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesusan ashí péṉker áujmatiarmiayi. Tura Jesus ti shiir chichaakui ti enentáimprar “Juka Jusé uchirí̱nchukait” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tu enentáimiainiakui, Jesus chicharuk “Atumsha shuar tuke tuinia núnisrumek, “tsuákratniuitkiumka amek tsuámarta,” turuttiatrume. Kapernáum péprunam aentsti túrachmin túramamna núnismek ju̱i̱sha túrata tusarum nu turuttiatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Túrasha nekas tájarme, Yúsnan etserniun ni nuṉke̱nkikia nii tana nuna anturainiatsui. ");
INSERT INTO jivNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nuya̱sha tájarme, Irías pujumia nú tsawantin, menaintiú uwí naṉkaamas yumi yutukcha asamtai ashí Israer núṉkanam ti tsuka amia nui̱ ti untsurí̱ waje̱ irunmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tuma aiṉ nu waje̱n yaiṉti tusa Yus Iríasan akuptukchamiayi. Antsu chíkich nuṉkanmaya̱ waje̱n Sarepta péprunam pujumia nuna yaiṉti tusa akuptukmiayi. Sarepta pepru Sitiún péprunam tíjiu̱ch pujawai. ");
INSERT INTO jivNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Núnisaṉ ii nuṉke̱sha Iriséu pujumia nu tsawantin ti untsurí̱ tunamaru iruniarmiayi. Tura núnaka tsuárcharmiayi. Antsu chíkich nuṉka, Sírianmaya̱ Naamaṉkan tsuármiayi” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Israer-shuarsha iruntai je̱e̱n pujuarmia nu, nuna antukar ti kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tura wajatkiar Jesusan ji̱i̱ki péprunmaya̱ akupkarmiayi. Tura pepru amia nui̱ naint yakí náṉkatkamunam, nuyá akaki aju̱atai tusar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Túrasha Jesuska irunar matsatainiamunmaṉ etempraktak jiinki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nuyá Jesus Kariréa nuṉkanam Kapernáum pepru amia nui̱ wémiayi. Tura Israer-shuara ayampratin tsawantri̱i̱n tuke etserki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yusa kakarmari̱n takaku asa nuja̱i̱ etserkamiayi. Tuma asamtai “Yusa kakarmari̱ji̱a̱i̱ unuitiamtsujik” tiar ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chíkich tsawantai̱ áishmaṉ iwianchruku Israer-shuar iruntai je̱a̱nam pujumia nu untsumuk tímiayi, ");
INSERT INTO jivNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Inikiartusta. Iikia Áminkia pachistin nakitiaji. ¿Warí, incha amukratkataj tusam táchamek? Wikia nékajme. Ámeka ti peṉker Tunaarincha núitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tutai Jesus iwianchin kakantar chicharuk “Takamatsata. Ju̱ áishmaṉ ikiuktia” tímiayi. Tutai nu chichamaik íwianch áishmaṉnumia̱ jiinki weak nuṉká aju̱ant ikiukmiayi. Túrasha nekas yajauch awajtsuk ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ashí pujuarmiania nu ti enentáimiar mai tunai ajarmiayi. “¿Ju̱sha warí chichamait? Ju̱ áishmaṉ Yusa kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki awematsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tura ashí nú nuṉkanam Jesusa túramuri̱n áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesussha Israer-shuara iruntai je̱e̱nia̱ jiinki Semuṉka je̱e̱n wémiayi. Semuṉka tsatsari̱ tsue̱r ti jáamiayi. Ti jaakui Jesusan “tsuárturtá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesussha jaa tepan tsuntsumprua tsue̱mun “michatrata” tímiayi. Tutai nú chichamaik nuwa̱sha michatramiayi. Nú chichamaik nantaki nincha ayurawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Etsa akaikin ai̱ ni shuari̱ náṉkamas sunkurja̱i̱ jaarmia nuna Jesusan ikiaatkarmiayi. Jesussha jáinian chikichkiniak chikichkiniak uwejé̱ja̱i̱ antiṉkiar tsuárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ti untsurí̱ iwianchruku armia nunasha iwianchri̱n jí̱i̱rkiarmiayi. Jíinkiar íwianchkia untsumainiak “Ámeka Yusa Uchirí̱nme” Jesusan tiarmiayi. Tura niisha “Jesuska Yusa anaikiamuri̱nti” tu nékainiakui Jesus kakantar chicharak itiatmamtikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kashin káshik tsawa̱a̱k Jesus péprunmaya̱ jiinki atsamunam Niṉki wémiayi. Tura shuarsha e̱a̱kiar ni pujamunam jeariarmiayi. Tura iiji̱a̱i̱ tuke pujusat tusar emetataitsar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Túmaiṉ Jesus tímiayi “Yus ii enentái̱n akupkatajtsa wakera nú shiir chichaman chíkich péprunam matsatainia nunasha ujaktiniaitjai. Nu túrata tusa akupkamuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tuma asamtai Kariréa nuṉkanam Israer-shuar iruntai je̱a̱nam Jesus tuke etserki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Chíkich tsawantai̱ Jesus Jinisarít antumiaṉka tutainium káanmatkari̱ pujai̱ ti untsurí̱ shuar, Yusa chichame̱n antuktai tusar wakeruiniak Jesusai̱ káunkarmiayi. Antuktai tusar wakeruiniak kae̱ ajattsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tura jimiará kanun antumiaṉkan káanmatkari̱i̱n tepan wáinkiarmiayi. Ni nérenniuri̱ṉkia jíinkiar ni nekari̱n nijiá pujuinia asamtai kánuka aṉkant ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tuma asamtai Jesus Semuṉka kanurí̱i̱n enkempramiayi. Tura Semuṉkan chicharuk “Ishichik ajapén juruktía” tímiayi. Nuiṉkia kanunam eṉkemas áentsun káanmatkanam pujuinian unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Unuiniasua amik Semuṉkan chicharuk “Kanu kunanam jukim neka ai̱ aju̱nkatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tutai Semuṉ tímiayi “Túrasha, Uuntá, káshisha tuke aju̱-ju̱nkuar tsawa̱rji. Túrasha peṉké achikchaji. Kame áankisha Ame támaja̱i̱ aju̱nkatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tura aju̱nkar namakan ti untsurí̱n achikiarmiayi. Túram nekasha jaanaki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tuma asamtai ni írutkamuri̱n chíkich kanunam pujuinian uwejé̱ja̱i̱ “winitia, yáintkiamniuram” tusar untsukarmiayi. Niisha táarmiayi. Túrawar jimiará kanunam métej awajsarmiayi. Tura kanusha init waya̱statuk ajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nuna túramtai Semuṉ Pítiur Jesusan tikishmatar tímiayi “Uuntá, wikia ti tunaitjai. ¿Wíji̱a̱i̱sha itiurak pujustam?” ");
INSERT INTO jivNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Semuṉsha ni írutkamuri̱ji̱a̱i̱ namakan timiá untsurí̱n wáinkiar ashamkarmiayi. Tuma asa Semuṉsha nuní tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tura Sepetéu uchiri̱ Jakupusha Juaṉsha Semuṉja̱i̱ pujuarmia nusha ashamkarmiayi. Tura Jesus Semuṉkan tímiayi “Ashamkaip. Yamaikia namaka-achinia áintsamek aents-e̱a̱u ajastatme.” ");
INSERT INTO jivNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nuya̱sha kanuri̱n kukar júkiar, ashí takakmari̱ncha ikiukiar Jesusan nemarki wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ukunam Jesus chíkich péprunam pujai̱ tunamaru áishmaṉ taa Jesusan wáiniak tikishmatar nuṉká shushuma pankái Jesusan tímiayi “Uuntá, wakerutakmeka páchitsuk tsuáramniaitme.” ");
INSERT INTO jivNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nuna tutai Jesus antiṉ tímiayi “Wakerajai. Tsuaajme.” Tura nú chichamaik tunamarusha péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Túrasha Jesus chicharuk “Ámeka nu etserkaip, tímiayi. Antsu Israer-shuar Patrii̱ werim ame péṉker ajasmanum Muisáis akupkamia núnismek susata. Nuja̱i̱ ashí shuar ame péṉker ajasmarmin nekaawartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tura Jesusa túramuri̱ ti etsernamiayi. Túmakui untsurí̱ aents anturkataj tusar káutkarmiayi. Tura ni suṉkuri̱ncha tsuámartaj tusar káutiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Núnisaṉ Jesuska aents atsuiniamunam we ni Apari̱n áujmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Chíkich tsawantai̱ Jesus unuiniak pujai̱ Pariséu aents tura Israer-shuara jintinniuri̱sha Kariréa péprunmaya̱sha, Jutía péprunmaya̱sha tura Jerusaréṉnumia̱sha káunkarmia nu antúu pujuarmiayi. Jaa tsuártinian Yusa kakarmari̱n takakuyayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nuiṉkia eme̱a̱run tampumprua kuatru shuar itiariarmiayi. Jesus pujamunam init awaya̱ttsar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tura shuar ti untsurí̱ piaku asamtai waya̱mnia atsumiayi. Túmaitkui yakiini̱ wear je̱a̱n urakar, aents kae̱ ajas matsatmanum Jesus pujamunam eme̱arun tampunam nená itiararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nin itiarmiania nu, Jesus Yusa kakarmari̱n takakui, tú enentáimtamun Jesus nekáa eme̱arun tímiayi “Ame tunaarum tsaṉkuramuitme.” ");
INSERT INTO jivNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nuiṉkia Israer-shuara jintinniuri̱sha, Pariséusha ni enentái̱n enentáimsar “¿Ju̱sha yait Yúsa náari̱n yajauch awajtin? Warí, aya Yúsak tunaan tsaṉkurachminkiait” tu enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tura Jesus ni enentáimsamuri̱n nekáa tímiayi “¿Urukamtai tú enentáimprarum átum? ");
INSERT INTO jivNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nuiṉkia ¿warí imiá yúpichuchit, tsuártiniak, ni tunaari̱ tsaṉkuratniuk? ");
INSERT INTO jivNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wats, Aents Ajasu tutai Wisha tunaan tsaṉkuratniun Yusa kakarmari̱n takakjai. Ju̱ja̱i̱ nekaatarum tusan wats itiurchat tárumna nuna túrattajai.” Nuyá eme̱a̱run chicharuk tímiayi “Amesha wajakim, tampuram achikiam ame je̱e̱mi̱i̱n wetá.” ");
INSERT INTO jivNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nú chichamaik eme̱a̱ru niisha íimiainiamunmaṉ tampuri̱n achik wajaki ni je̱e̱n Yúsan wararki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Túmakui ashí shuar ti enentáimprar Yusa náari̱n shiir awajsarmiayi. Tura ashamainiak “aentsti tujinkiamu yamái wáinkiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ukunam Jesus wekas akupniu kuítri̱n-juu, naari̱ Riwí, ni chíkich naari̱ Mateu, akupin akitiai je̱a̱nam pujan wáinkiamiayi. Wáiniak “nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tutai Riwí wajaki takakmari̱nkia ikiuak Jesusan nemarsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nuyá ukunam Riwí namperan Jesusan najatamiayi. Tura untsurí̱ akupniu kuítri̱n-juu tura chíkich shuarsha káunkar misanam pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tura Pariséusha Israer-shuara jintinniuri̱sha Jesusan tsanumpruiniak Jesusa unuiniamuri̱n tiarmiayi “¿Maaj, urukamtai atumsha akupniu kuítri̱n-juu ainia núja̱i̱sha tura chíkich yajauch shuarja̱i̱sha iruntrarum yurumprum?” ");
INSERT INTO jivNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tutai Jesus áimkiamiayi “Shuar jaachu péṉker ainiana nu ¿tsuákratniun atsumainiawak? Antsu jaa ainia nu tsuákratniun atsumainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Wikia péṉkeraitjai” tuinia nuna untsuktajtsan táchaitjai. Antsu yajauch shuar ni enentái̱n yapaji̱á Winia ajasat tusan untsuajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nuyá Jesusan aníak tiarmiayi “Juaṉka unuiniamuri̱sha, Pariséu unuiniamuri̱sha yurumtsuk Yúsan áujainiatsuk. Tura ame unuiniamurmeka ¿urukamtai ijiarma Yúsan áujainiatsu?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tutai Jesus tímiayi “Nuatma nampernum, ¿ipiaamu ainia nu ijiarmamniakait, yamái-nuatu pujai̱? ");
INSERT INTO jivNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Atsá. Wats Wisha ukunam junaktiatjai; nuiṉkia ijiarmatin átatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tura ju̱nasha nuja̱i̱ métek-taku unuiniamiayi: “¿Yamaram pushí tsupikiar nuja̱i̱ arut pushiniam anujtukminkiait? Nu túramka yamaram pushí yajauch ajasaintiui; túrasha shiir anujkamu arut pushiji̱a̱i̱ mai metek yamaram wáinkiachminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Núnisaṉ nijiamanch yamái nawamu nuap najanamu arutnum yaraachminiaiti. Túramka nijiamanch karíak ijiakratniuiti; túmak nijiamchisha nuap najanamusha mai metek meṉkainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tuma asamtai nijiamanch yamái nawamu yamaram nuap najanamunam yaraatniuiti. Nu túramka mai metek péṉker átiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yaunchu nawamu úmana nuka yamarman nakitrattui. “Yaunchu nawamu imiá peṉkeraiti” tiártatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayampratin tsawantai̱ Jesussha unuiniamuri̱ji̱a̱i̱ araamunam wekasar, unuiniamuri̱sha trikiu neren maju̱rkutak wekainiarmiayi; tura tishisar neren yuawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nuna túruiniakui Pariséu tiarmiayi “Maaj, atumsha ayampratin tsawantai̱ takaschatniua nui̱, ¿urukamtai takaarum?” ");
INSERT INTO jivNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Takui Jesus aya̱k tímiayi “Yaunchu uunt akupin Tawitcha tura nemarniusha tsukamainiak túrawarmia nu ántichukaitrum. ");
INSERT INTO jivNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tawit Yusa Je̱e̱n wayá, Yus iniaktusma tantan yuámiayi; tura nemarniuncha ajamsamiayi. Tura nu tantancha aya Israer-shuara Pátriri̱ yúatin ármiayi. Tuma aiṉ Tawitcha yajauchin túrutsuk achikmiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wisha Aents Ajasuitkiun ayampratin tsawantan Nérenniuri̱ntjai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chíkich ayampratin tsawantai̱ Israer-shuar iruntai je̱a̱nam Jesus wayá unuiniartasa naṉkamamiayi. Nui̱ shuar uweje̱ untsuuri̱a nu jakaa pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tura Israer-shuara jintinniuri̱sha, Pariséusha Jesusan “yajauch túrayi” titiai tusar wakeruiniak, “ju̱ ayampratin tsawantai̱ nu shuaran tsuartimpiash” tusar ii pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Túrasha Jesuska ni enentáimmiari̱n nekariarmiayi. Túmayat uweje̱ jakaan chicharuk “Jui̱ ajapén wajasta” tímiayi. Tutai áishmaṉ ajapén wajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nuiṉkia iruniarmiania nuna Jesus tímiayi “Enentáimpratarum. Ayampratin tsawantai̱ yajauch túratin, péṉker túratniuja̱i̱ ¿tuá péṉkerait? ¿Uwemtikratin, máatniuja̱i̱sha tuá péṉkerait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nuyá téntakarmia nuna iis áishmaṉkan tímiayi “Uwejem takuitia.” Áishmaṉsha uwején takuimtai nú chichamaik péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tura chíkichkia ti kajerkarmiayi. Túrawar “Jesus warí itiurkamniakit” tusar aniniaisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nuyá Jesus Yúsan áujsataj tusa náinnium wakamiayi. Tura nu kashi Yúsan au-aujkua tsawa̱rmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsawa̱rmatai unuiniamuri̱n ikiankar tuse anaikiamiayi. “Winia akatramuruitrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ju̱ ármiayi: Emka, Semuṉ chíkich naari̱ Pítiur apujtusmia nu; tura nuyá ni yachi̱ Antres, Jakupusha, Juaṉsha, Jiripisha, Parturumísha, ");
INSERT INTO jivNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateusha, Tumassha, Arpeu uchiri̱ Jakupusha, Ásump Semuṉsha, ");
INSERT INTO jivNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jakupu yachi̱ Jútassha, tura Jútas Iskariúti Jesusan ukunam surukmia nu. Nu tuse achikma ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Niiji̱a̱i̱ Jesus náinniumia̱ pakanam taawarmiayi. Nui̱ pujusarmiayi. Nui̱sha untsurí̱ unuiniamuri̱sha, tura Jutía nuṉkanmaya̱, tura Jerusaréṉnumia̱ tura nayaantsanam aya̱mach Tiru, tura Setuṉ péprunmaya̱ ti untsurí̱ aents antuktaitsar pujuarmiayi. Jesus tsuarati tusar káunkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwianchrukusha tsuámararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesus tsuártinian tujinkiachu asamtai ashi shuar antiṉtaj tusar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ni unuiniamuri̱n Jesus iis ju̱na tímiayi: ““Yusan atsumajai” tárumna nu, Yus akupeamunam páchitkiaitrume; tuma asamtai warasminiaitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‘Yamái tsukamarmena nu ukunam ejemartatrume. Tuma asamtai warasminiaitrume. Yamái úutrumna nu, ukunmaṉka wishirtatrume. Tuma asamtai warasminiaitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Atumin nakitramprarmatai, ajapramawarmataisha, tura Winia Aents Ajasu tutaiya nú shuar ajasuiti tusar tsanumprutmak katsekkramkarmataisha warasminiaitrume.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","‘Túramtai nayaimpiniam ti shiir ana nu núkap sunastin átatui tu enentáimsarum ti warastarum. Warí, ju̱ shuara uuntri̱ yaunchu Yúsnan etserniun nútiksaraṉ yajauch awajsacharmakia.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Tura kuítrinniutiram atumsha atumí waratairi̱ aya yamaik waintrume. Ukunmaṉka waraschattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‘Atsumatsjai, tu enentáimprumna nu, ukunmaṉka atsumattarme. Nuiṉkia waraschattarme. Yamái wishíarmena nu, ukunmaṉka wáitiakrum úuttiatrume. Nuiṉkia waraschattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Ashí aents atumin shiir awajtamkurmin aneartarum. Nuja̱i̱ waraschatniuitrume. Warí nuna uuntri̱ ántar-yusnan etseri̱n armia nuna nútiksaraṉ yaunchu shiir awajsarmiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Winia anturtarmena nuna ju̱na tájarme: Ame nemasrum aneata, nakitramainia nusha shiir awajsata; ");
INSERT INTO jivNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yajauch chichartamainia nusha shiir enentáimtusarta; katsekramainia nusha Yus áujtusarta. ");
INSERT INTO jivNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ame yapimin ijiutmamtai áatú yapirui̱sha ijiuti tusam iniaktusta; ame pushirmin jurutramkitiaj tuíniakuisha sákurmencha jukiti tusam iniaisata. ");
INSERT INTO jivNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Seatmana nu susata, tura áminiun jurutramainiakuisha ataksha awaṉturkitia tiip. ");
INSERT INTO jivNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chíkich winia túrutati tusam wakeramna nútiksamek chikichcha túrata.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Iista, aya atumin anenmainia nuke aneakmesha, ¿nusha warí péṉkera túrarum? Yajauch shuarsha nuna túrin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tura atumniasha péṉker awajtamainia nuke péṉker awajkurmesha ¿nusha warí péṉkera túrarum? Yajauch shuarsha nuna túrin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Awaṉturkimniaiti tu enentáimtarum nuke íkiakrumsha ¿nusha warí péṉkera túrarum? Yajauch shuar nuamtak yajauch shuarja̱i̱ awaṉturkimniaiti tu enentáimsar ikianainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tura atumsha nemasrum aneatniuitrume, tura péṉker túratniuitrume, tura awaṉturkittiawai tu enentáimtsuk ikiastiniaitrume. Túrakrumniṉkia Uunt Yus péṉker akirmaktatrume; tura ni uchirí̱ntjai tu iniakmastatrume. Yuska, “yumiṉsajme” ticha nunasha tura yajauch shuarnasha shiir awajeawai. ");
INSERT INTO jivNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ii Aparí̱ waitnentramniua nútiksarmek atumsha waitnentratarum.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Chikicha túramuri̱ ti enentáimtusairap. Núnisaṉ Yuska atumí tunaari̱n iirtamsashtatui. Chikicha tunaari̱n “nuke asutniatniuiti” tiirap. Núnisaṉ Yus atumin sumamtikramashtatrume. Tsaṉkurnairatarum. Núnisaṉ Yus tsaṉkurtamprattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chikichcha susata. Núnisaṉ Yus atumin suramsattarme. Niisha péṉker nekapma, tura núkap ati tusa teeka awajas tura patas núkap enkea emetsai̱ amastatui. Atum chíkich túrarmena nútiksaṉ atumniasha túrutmattarme.” ");
INSERT INTO jivNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tura nuya̱sha ju̱na métek-taku chichaman ujakarmiayi: “Ji̱i̱ kusurusha ¿itiurak chíkich kusuruncha jukimniait. Mai metek wa̱a̱nam iniaashtatuak? ");
INSERT INTO jivNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Unuiniamua nu unuiniana nuna naṉkaamas áchatniuiti. Túrasha niisha ti unuimiatar unuiniana nuja̱i̱ métek nekaamniaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘¿Itiurtsuk atumi ji̱i̱n numi eṉketna auk íitskesha atumí̱ yachí̱ ji̱i̱n tsuat eṉketusha iiyarum? ");
INSERT INTO jivNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ame ji̱i̱mi̱i̱n numi tuke eṉketaisha ¿itiurtsuk ame yatsumi ji̱i̱ya̱ tsuátan jurustajme tame? ¡Ántraitrume! Emka ame ji̱i̱mi̱i̱n numi eṉketna nu jusata. Nuiṉkia paant wáinkiattame yatsumi ji̱i̱n tsuat eṉketna nu jurustin.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Péṉker numi yajauchin nereatsui; tura yajauch numi péṉkeran nereatsui. ");
INSERT INTO jivNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Numisha ni nere̱n nékanui. Tsachikniumia̱sha kushiṉkiap júukchamniaiti. Tura naranmaya̱ shuinia júukchamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Núnisaṉ péṉker shuar ni enentái̱ péṉker asamtai péṉkeran chichaawai; tura yajauch shuar, enentái̱ yajauch asamtai yajauchin chichaawai. Páantchakait. Enentáin pimiutkamu ana nuyaṉ ni wene̱ja̱i̱ chichaawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Wi tájana nu túrachiatrumsha ¿urukamtai Winia, Uunta, túrutrum? ");
INSERT INTO jivNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Shuar winia chichamprun ántuinia nu je̱a̱ jeammaja̱i̱ métekete. Winia anturtuk umíana nu ju̱ja̱i̱ métekete: ");
INSERT INTO jivNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Shuar je̱a̱n jeamuk emka init taur kayanam ukurmai. Tura yumi ti yutuk, entsa nujaṉkrua tukummaitiat pukukachmai kayanam ukuamu asa. ");
INSERT INTO jivNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Antsu Winia anturtukiat umiatsna nuka ju̱ja̱i̱ métekete: Shuar je̱a̱n jeamuk aya naikminiam jeammai. Tura entsa nujaṉkrua tukumpram nu je̱a̱ka pukukamai. Tura mash sáantramai.” Tu unuiniamiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus áentsun unuiniasua amik Kapernáum péprunam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nui̱ Rúmanmaya̱ suntara kapitiántri̱ pujumiayi. Nu kapitiáni̱ takarniuri̱, ti aneamuri̱, jakamnia jaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tura Jesusan pachis áujmatainian antuk, ame shuarum Jesusan itiartiti tura winia takarniun tsuárturti tusa Israer-shuara úuntri̱n akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Niisha Jesusan weriar, umirtukat tusa ti seainiak tiarmiayi “Ju̱ kapitián nekas yáiṉtin péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Niisha yajaya̱ apachitiat in shiir enentáimturmaji. Tura iruntai je̱a̱n jeamtinniasha niṉki chicharkaiti, tura ya̱ya̱wai.” ");
INSERT INTO jivNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nuyá Jesus niiji̱a̱i̱ wémiayi. Tura ni je̱e̱n jeastatuk jatemsamtai kapitiáncha ni amikri̱n akatar ju̱ titiarum tusa Jesusan akuptukarmiayi. Niisha Jesusan chicharuk ju̱na tiarmiayi “Uuntá, ántram waya̱taj tu enentáimsaip. Ame ti naṉkaamaku asam winia je̱a̱rui̱ waya̱chminiaitme. ");
INSERT INTO jivNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tuma asakmin imia wiki Ami̱i̱n jeatniun arantukjame. Ayatik “péṉker ajastí” tákumin winia takarniusha péṉker ajatrustatui. ");
INSERT INTO jivNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wi nékajai. Winia úuntur winia akuptuiniawai. Tura wisha suntaran akupenajai. Nunasha wi “wetá” takui wéawai. Tura chikichnasha “winitiá” tutai winiawai. Tura winia takartinian “ju̱ túratá” tutai umíawai.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus nuna antuk ti enentáimias ni nemarainian tímiayi “Nekas tájarme Israer-shuar Yúsan tímiatrus enentáimtinian wáinchaitjai.” ");
INSERT INTO jivNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tura kapitiani̱ akatramuri̱ je̱á waketkiar, takarniuri̱ péṉker ajasun wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nuyá ukunam chíkich pepru Naín tutainium ni unuiniamuri̱ji̱a̱i̱ tura chíkich untsurí̱ aentsja̱i̱ Jesus wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tura péprunam nuntumas jakaan iwiarsatai tusar juínian wáinkiamiayi. Jakáa nukuri̱ wáje̱yayi, tura uchiri̱ jakamia núchikiiyayi. Tura ti untsurí̱ nu peprunmaya̱ nin nemarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus nu wajen wáiniak tura waitnentar “úutip” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nuiṉkia Jesus jakaa eṉkerman tarunt antiṉmiayi; nuna juíniasha wajasarmiayi. Nuiṉkia Jesus jakaan chicharuk “Umpa nantaktia, tájame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tutai niisha nantaki pujus chichaamiayi. Tura Jesus ni nukuri̱n “Ju̱jú̱ uchiram” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tura matsamiarmia nu, nuna wáinkiar ashamkarmiayi. Tura Yusa náari̱n shiir awajsarmiayi. Tura chichainiak, “Yúsnan etserniuchukait Niisha. Ataksha Yúsnan etserin uunt ana nu tarutramji” tiarmiayi. Tura “Israer-shuarti Niiniu ájinia nuna yáinmaktai tusa Yus tarutramji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tura ashí Jutía nuṉkanmaya̱sha tura ni írutkamu nuṉka ármia nuya̱sha Jesus túramia nuna nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juaṉ ni írutkamuri̱ ujakam Jesus túramun nekaamiayi. Nekáa ni írutkamurí̱n jímiaran untsukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tura Jesusai̱ akupkarmiayi. “Atumsha Jesus aniastarum. ¿Amesha nekas Kristu Yus akupkamu tátinia núkaitiam. Kame chikichak nákastatajⁱ? titiarum. Nu nekáa ikiuutarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tutai niisha Jesusan werí jeariar tiarmiayi “Incha imiakratin Juaṉ akatar akuptamkaji. ¿Amesha nekas tátinia núkaitiam. Chikichak nákastatajⁱ? Nu nekaatai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wats, nii jeawarmia nui̱ Jesus untsurí̱ jaan tsuártasa pujurmiayi. Iwianchrukuncha iwianchri̱n ji̱i̱rki akupkatasa pujurmiayi. Tura kusuruncha íimtikmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tuma asa Jesus akatramun ju̱na tímiayi: “Waketkirum ashí átum antukurmena nusha, wáinkiarumna nusha ujaktarum. Kusurusha wáinmainiawai; shutuap ainia nu péṉker wekainiawai; tunamarusha tsuámainiawai; empekusha ántuiniawai; jakaasha atak iwiaaku ajainiawai; tura kuítrinchanumsha uwempratin chicham ujakmaiti. Juaṉ nu ujaktarum. ");
INSERT INTO jivNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yawe̱tsuk Winia tuke shiir enentáimturna nú shuar shiir átatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waketkiarmatai Jesus Juáṉkan pachis áujmatman antuk shuar matsamarmia nui̱ ju̱na tímiayi: “Shuar atsamunmasha ¿warí werimiarum. Pintiu nase umpúam atúu we ju̱ní we ajana nu iistai tusarmek wémarum? Juaṉ núnischaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nuikia ¿warí werimiarum. Shuar péṉker iwiarmampra íistai tusarmek wémarum? Warí, péṉker iwiarmampraka uunt akupniu je̱e̱n pujuiniatsuk. ");
INSERT INTO jivNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nuiṉkia ¿warí werimiarum. Yúsnan etserniuk werimiarum? Maa, nú naṉkaamas wáinkiarme. ");
INSERT INTO jivNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yaunchu Yus-Chichamnum ju̱ áarmaiti: “Winia akatramurun ami̱i̱ni emka akupeajai ame jintimin iwiarat tusan.” Juaṉ nu akatramuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nekasan tájarme, Yúsnan etserin imiakratin Juaṉja̱i̱ naṉkaamas uunt atsuwiti. Túmaitiat Yus akupeamunam páchinia nu shuarka nekas imianchaitiat, Juaṉja̱i̱ naṉkaamas átatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Peṉké shuarsha, kuítian-juusha, Juaṉ imiaimiuja̱i̱ imianiarmia nu, Jesus timian antukar Yusa náari̱n shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Túrasha Pariséusha Israer-shuara jintinniuri̱sha Yus yáiṉtaj támaitiat Juaṉ imiaamuja̱i̱ imiancha ásar nakitrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nuiṉkia Uunt Jesus tímiayi “Yamaiya̱ áentstiram, wariji̱a̱i̱ṉ métek árum nuna paant títiatjarme. ");
INSERT INTO jivNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Uchiji̱a̱i̱ métek árume. Ni ai̱ji̱a̱i̱ iruntrar nakurustaj tukamá tuíniawai “Námpera áinis nakurustaitsar peem umpuarji, túrasha jantsemáchurme. Nuyá iwiarsatniua áinis nakurustaitsar íwiareakur kantamtai kantamáaji, túrasha átum úutcharme.” Tu tuíniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Atumsha núnisaitrume. Kame Juaṉ núkap yurumtsuk úmutsuk wekaimiayi. Túmakui átumka “iwianchrukuiti” tímiarme. ");
INSERT INTO jivNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nuyá Wisha Aents Ajasan támajai. Tura yurumá úmakuisha “ti yurumin tura ti nampenaiti; kame ashí yajauch shuaran tura kuítian-juu amikrinti” túrutrume. ");
INSERT INTO jivNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wats, nekas neka ainia nu, Yusa nekatairi̱n iniakmainiawai.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","“Winí yurumáitia” tusa Pariséu Jesusan ipiaamiayi. Tutai Jesus ni je̱e̱n werí misanam pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nuiṉkia nu péprunmaya̱ yajauch nuwa̱, Jesus Pariséu je̱e̱n yurumáttsa weyi táman antuk, kayá mutinium kunkuin asuiti áimkiamun takukí jearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tura úutki Jesusa nawen pujuras ne̱ajki̱ji̱a̱i̱ niji̱armiayi. Tura intiashi̱ji̱a̱i̱ japirmiayi; nuyá nawenam mukuta kuṉkuinian ni nawe̱n ukatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pariséu Jesusan ipiaamia nu, nuna wáiniak ju̱na enentáimsamiayi: “Ju̱ nekas Yúsnan etserniuitkiuṉka, ju̱ yajauch nuwa̱ ántiana nuna nekaawainti. Warí, niisha netse nuwa̱chukait” tu enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nuiṉkia Jesus Pariséun chicharuk tímiayi “Semuṉká, ámin titiaj tusan wakerajai.” Tutai Pariséu chichaak “Turuttiá, Uuntá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tutai Jesus tímiayi “Kuítian ikiamniun jimiará áishmaṉ tumashmakarmiayi. Chíkich kiniantus (500) tura chíkichka aya seṉkuentak tumashmakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akiktin tsawant jeamtai mái-metek takakcha ármiayi. Tuma asamtai kuítian ikiamin ni tumashri̱n mái-metek asakátrarmiayi. Wats, turuttiá ¿tú áishmaṉka ikiamniun nekas aneamia?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tutai Semuṉ tímiayi “Enta, núkap tumashri̱n tsaṉkuramia nu.” ");
INSERT INTO jivNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tutai Jesus tímiayi “Nekas tame.” Nuiṉkia nu nuwa̱n iis Semuṉkan tímiayi “Ju̱ nuwa̱ wáintsumek. Ame je̱e̱mi̱i̱n waya̱mtai winia nawer nijiartin entsa suruschamame; antsu ju̱ nuwa̱ka nawerun neajki̱ji̱a̱i̱ nijiarturai, tura intiashi̱ji̱a̱i̱ japirturai. ");
INSERT INTO jivNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mukutam áujtuschamame; antsu niṉkia nawerun tuke mukutui. ");
INSERT INTO jivNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Winia muukarui̱sha asuiti ikiurtuschamame; antsu niṉkia nawerui̱ kuṉkuin asuitin ukatrurai. ");
INSERT INTO jivNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nu tuma asamtai tájame, niisha Winia ti anentu asamtai ni tunaari̱ untsurí̱ ana nu tsaṉkuramuiti. Tura tunaar ishichik awai tau tsaṉkuramu ana nuka ishichik aneṉkratniuiti.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nuiṉkia nuwa̱n tímiayi “Ame tunaarum tsaṉkuramuitme.” ");
INSERT INTO jivNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tura chíkich ipiaamu Jesusja̱i̱ misanam pujuarmiania nu “¿Ju̱sha ya asaṉ tunaancha tsaṉkurea?” nuamtak tunainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tura Jesus nuwa̱n chicharuk ““Uwemtikiartiniaiti” tu enentáimturu asam uwempraitme. Shiir wetá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nuyá untsurí̱ péprunam Jesus wekaráktak Yus akupeana nuna shiir chichaman etserkini wekaimiayi. Tura ni unuiniamuri̱ tuse ármia nu nemarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yaunchu untsurí̱ nuwa̱ jaa armia nuna tura iwianchruku armia nunasha Jesus tsuárarmiayi. Nu nuwa̱sha Nin nemarsarmiayi. Nusha ju̱ ármiayi: Maktaranmaya̱ Marí, siati íwianch jí̱i̱rkimiuya̱nia nusha ");
INSERT INTO jivNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tura uunt akupin Erutisa takarniuri̱ Chusa nuwé̱ Juancha, tura Susancha; tura chíkich untsurí̱ ni takakmari̱n súsar Jesusan yáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Untsurí̱ péprunmaya̱ Jesusan iistai tusar jíinkiarmiayi. Tura untsurí̱ káunkarmatai ju̱ métek-taku chichaman Jesus unuiniamiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Atsaamin atsaamprataj tusa jíinkimiayi. Atsaamki wesa jinkiái jintiá iniaararmiayi. Túrunamtai weenak najakarmiayi. Nuyá chiṉki tariar yuawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chíkich jinkiái kaya írunmanum iniaararmiayi. Nu jinkiái tsapainiar, wárik nantu sukuam kárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Chíkich jinkiái jaṉkiniam iniaararmiayi. Tura jaṉkisha jinkiáisha mái-metek tsapainiar, jaṉki kaṉkar ajakramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tura chíkich jinkiáisha péṉker nuṉkanam iniaararmiayi. Tura tsapainiar, péṉker nerekar chíkichkia siaṉsha (100) nerekarmiayi.” Tuasua amik kakantar chichaak Jesus tímiayi “Kuishim ákuiṉkia antuktarum.” ");
INSERT INTO jivNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nuyá ni unuiniamuri̱ Jesusan aniak tiarmiayi “Ju̱ métek-taku chicham tamena nu ¿warintkume̱a tame?” ");
INSERT INTO jivNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tutai Jesus tímiayi “Atumnia Yus ni akuptairi̱n nekaachma ana nuna nekamtikramprume. Tura chikichnaka, wáiniainiayat kusurua núnin ártí tusan, tura ántuiniayat nekaacharat tusan aya métek-taku chichamja̱i̱ jintintiatjai,” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Wats, ju̱ nekaatarum, tímiayi. Jinkiáisha Yusa chichame̱n nakumui. ");
INSERT INTO jivNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jintiá iniaaru tana nuka shuar aya ántana nuna nakumui. Yúsan nekas enentáimtus uwempracharti tusa íwianch wárik taa nu chichaman ni enentái̱ya̱n júawai. ");
INSERT INTO jivNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kayanam iniaaru tana nuka shuar antuk waras umiana nuna nakumui. Tura nú shuar kaṉkape̱ atsá asamtai, ishichik tsawantiniṉ umikiar itiurchatan wáinkiar wárik kanainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jaṉkiniam iniaaru tana nuka tuke enentáiji̱a̱i̱ umíatsna nuna nakumui. Nu shuarsha ántuiniawai, túrasha ni wakeramuri̱ji̱a̱i̱ wekainiawai. Ju̱ nuṉkanmaṉ ana nuna ti páchiniakui, tura kuítian ti wakeruiniakui, warastinniak enentáimtuiniakui, Yus-Chicham ni enentái̱n takaatsui. Nuja̱i̱ kaṉkarma ásar nerektinian tujintiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tura jinkiái péṉker nuṉkanam iniaaru tana nuka shuar antuk umiinia nuna nakumui. Niisha antukarmia nuna péṉker enentáimtusar, yawe̱tsuk umirkar ti péṉker nerenawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","‘¿Shiripkin ekeemak nukuktinkiait? Peaknum waaptak ikiuschatniuiti. Antsu je̱a̱nam wáiniana nu paant wáinkiarat tusa yakí ekentsatniuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Núnisaṉ ashí nekaachma ana nu paant átatui. Tura ú̱u̱kma ana nu nekanattawai. Tura iwiainiakma átatui. ");
INSERT INTO jivNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tuma asamtai anearum péṉker antuktarum. Shuar takakna nu patatsamnia átatui. Túrasha takaktsuna nu, takakjai tu enentáimtumana nuka jurunkíttiawai.” Tu timiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus pujamunam nukurí̱ ni yachi̱sha tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Turamtai Jesusan tiarmiayi “Ame nukusha yatsumsha a̱a̱ wajasar untsurmainiawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tutai Jesus tímiayi “Ee, nukuruiti, yatsuruiti, tura Yus tana nuna antuk umíana nusha winia nukuruiti, winia yatsuruiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chíkich tsawantai Jesus ni unuiniamuri̱ji̱a̱i̱ kanunam eṉkemprar “Antumiaṉ amaini wetai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Entsanam wesar Jesus kanarmiayi. Tura aya aneachma nase ti kakaram násentkui chíchimi tampá tukumar kanun init awaya̱statuk awajmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Túram nuiṉkia Jesusan ishintiainiak “Uuntá, iisha entsá waya̱a̱ji” tiarmiayi. Nuiṉkia Jesus nantaki nasencha entsancha chicharkamiayi. Nú chichamaik nasesha meṉkakamiayi, tura entsasha miaaku ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nuyá ni unuiniamuri̱n chicharuk “¿Urukamtai Winia enentáimtursachuram?” tímiayi. Tura niisha ashamainiak, ti enentáimprar “¿Ausha warí áishmaṉkait? Nasesha entsasha Nii chicharkam umirainiatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kariréa nuṉka amaini Jatara nuṉkanam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kanunmaya̱ Jesus jiinkimtai nu péprunmaya̱ áishmaṉ Nin taruntamiayi. Nu áishmaṉsha yaunchu iwianchrukuyayi. Misú wekas, je̱á pujutsuk aents iwiarsamunam pujuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Íwianchkia nu aishmaṉkan ti kakaram nupet wémiayi. Tura emetatai tusar uweje̱ncha nawe̱ncha jiruja̱i̱ jinkiá wearmiayi. Túrasha tujinkiarmiayi. Niisha jiruncha tsurí wémiayi. Tura íwianch aents atsamunam útsuk awemamiayi. Nu aishmaṉ Jesusan wáiniak tikishmatar kakantar chicharuk “¿Urukamtai winiisha tarutnium, Uunt Naṉkaamaku Yusa Uchiri̱ Jesusa? Winia wáitkiarsaip tusan seajme” tímiayi. Íwianch ni̱i̱n pujurun Jesus ji̱i̱ki akupeam tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus nu áishmaṉkan anias “¿yáitiam?” tímiayi. Tútai nii chichaak “Wikia Untsurí̱ntjai” tímiayi. Untsurí̱ íwianch ni̱i̱n pujurma asa nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","“In uunt wáa̱nam ii jiinkimiaj nuiṉ akuptukam amutkaip” íwianch seawarmiayi Jesusan. ");
INSERT INTO jivNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nui̱ ishichik arantach náinnium untsurí̱ kuchi shushuṉmak yujaarmiayi. Tura íwianch chichainiak, “Antsu kuchiniam waya̱tin tsankatrukta” tiarmiayi. Tutai Jesuska “Ayu, wetarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nuna takui íwianch áishmaṉnumia̱ jíinkiar kuchiniam waya̱warmiayi. Túram kuchisha nánatanam akaiki iniaawar entsanam utsanawarmiayi. Túrunawar jakekarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kuchin wáinniusha túrunan wáinkiar, ashamkar, péprunmasha tura arantcha etserkatai tusar tseke wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Etserkarmatai, iyutai tusar untsurí̱ shuar wearmiayi. Tura Jesus pujamunam jeawar, íwianch jíintiukiarmia nú áishmaṉkan péṉker ajas pushí entsar Jesusa nawe̱n pujan wáinkiarmiayi. Tura ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iwianchruku áishmaṉ tsuárman wáinkiarmia nu yama taan ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tura ti ashamainiak Jatara nuṉkanmaya̱ aents ashí Jesusan “Wetá” tiarmiayi. Tutai Jesus kanunam eṉkemar wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Íwianch jíintiukiarmia nú áishmaṉ Jesusan, wisha ame wéamunam winitiaj tusa seamiayi. Tutai Jesus nuna suritiak, ");
INSERT INTO jivNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Antsu ame je̱e̱mi̱i̱n weme Yus ámin túrutma nu ashí etserkata” tímiayi. Tutai áishmaṉ we Jesus nin túramia nuna ashí nu péprunam etserkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tura Jesus katiṉki Kariréanam tatí tusar nákas pujuarmiayi. Tuma ásar Nii waketki katiṉki támatai nu aencha warasar áujsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tumai̱ Israer-shuara iruntai je̱á uuntri̱ Jairu naartin támiayi. Nii taa, Jesusa nawe̱n tikishmatar “Winia jearui̱ waitneasam winítrítiá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ni nawantri̱ chikichik amia nu, tuse uwí takaku, jakatasa pujakui nuna tímiayi. Jesus “ayu” tinia weakui ti untsurí̱ aents nemariarmiayi. Tura untsurí̱ shuar kae̱ ajas weena ásar chanuawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nui̱ nuwa̱ páchitkia wémiayi. Niisha tuse uwí numpa ajapeak wáitias pujuyayi. Tsuákratniua nui̱sha ni kuítri̱n ashí ajapaitiat tsuámarchauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesusa úkuriini̱ winiá weantuk ni pushirí̱ náṉkatramuri̱n antiṉmiayi. Nuna tura nú chichamaik numpé̱ ájapeamuncha péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nuiṉkia Jesus chichaak “¿Ya Winia antintkia?” tímiayi. Tura “peṉkesha antiṉchajme” tuíniakui Pítiur ni tsaniakmari̱ji̱a̱i̱ Jesusan chicharuk “Uuntá, ti untsurí̱ antiṉmasha, tura ti untsurí̱ chanunmainiasha ¿itiura “ya Winia antintkia” tame?” tíarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tútaisha Jesus tímiayi “Nekas Winia antintkiayi. Winia kakarmarja̱i̱ tsuárajna nuna nékajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nuyá nu nuwa̱sha, nekarayapi tusa kuraṉki taa Jesusa nawe̱n tikishmatramiayi. Tura ashí aents ántuiniamunam urukaku antiṉkia tura itiura wárik péṉker ajasmia nuna ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nui̱ṉkia Jesus nuwa̱n tímiayi “Nawantrú, shiir wetá. Winia nekas enentáimtursa asam péṉker ajasume.” ");
INSERT INTO jivNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus tuke chichas pujai̱ uunt Jairu je̱a̱, ti untsurí̱ antiṉmasha, turenia̱ taa, Jáirun tímiayi “Ame nawantrum jakayi. Unuikiartin tuke itit awajipia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tura Jesus nuna antuk tímiayi “Ashamkaip. Áyatik Winia nekas enentáimtursata. Túrakmin nawantrum péṉker ajastatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Je̱á jeawar Jesussha Niiji̱a̱i̱ untsurí̱ waya̱tniun surimkiamiayi. Antsu aya Pítrun, Jakupun, Juáṉnasha tura nuwa̱chi aparí̱n nukurí̱ncha waya̱tniun tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ashí úutainiak atakka wáinkiashtatjapi tu úutiarmiayi. Túmainiakui Jesus peṉké jakaan nékayat tímiayi “Úutirpa. Nuwa̱chkia jákachai, antsu kanarai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jakaancha urukaku ta tusar wishikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nuyá Jesus nuwa̱chi uwejé̱n achik, kákantar chicharuk “Nawantru nantaktia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Túram niisha jakayat atak iwiaaku ajasmiayi. Tura nú chichamaik nantakmiayi; túrunamtai Jesus “ayuratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nuwa̱chi aparí̱ nukurí̱sha ti enentáimprarmiayi. Tura Jesus “Ju̱ túramu peṉké etserkairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ni tuse unuiniamuri̱n ikiaanak ni chichame̱ja̱i̱ iwianchrukun enentái̱ya̱n iwianchin ji̱i̱rki akupkatniun tura suṉkurja̱i̱ jaa tsuártinniasha ni kakarmari̱n súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","“Yus akupin ajastin ujaktarum, tura jaa tsuártarum” tinia akupkarmiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nuyá tímiayi “Wéakrum áyatik wetarum. Ushukrustincha, uyuncha, yurumkasha, kuitcha peṉké jukiirap. Aya chikichík pushí jukitiarum. ");
INSERT INTO jivNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Náṉkamas je̱a̱nam jearum waya̱rmeka nuiṉ pujustarum. Nuiṉ pujusrumek chíkich péprunam wéakrum jíinkitiarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tura atumin awa̱intiamatniun nakitiana nú péprunmaya̱ jiinkirum nawemi̱ya̱ nuṉka akakekrum ikiuktiarum. Awa̱intiamachma paant ati tusarum nu túratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nuyá jíinkiar ashí péprunam uwempratin chichaman ujakiar wearmiayi; tura ashí péprunam jáiniancha tsuákiar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Uunt akupin Erutis Jesus túramun antukmiayi. Nu túramun chíkich shuarka “Juaṉ jakamunmaya̱ nantaki túrawai” tu wearmiayi. Chíkichkia, “yaunchu Yúsnan etserin E̱rías wantiniak túrawai” tu wearmiayi. Chíkichkia, “chíkich yaunchu etserin nantaki túrawai” tiarmiayi. Tuma asamtai Erutis peṉké nekaachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tura tímiayi “Wiki, Juaṉka muuke tsupirkatarum, tíchamkaj. Tuma ai̱sha, ¿ju̱ shuar, ni túramuri̱ ashí shuar chichainia nusha yátsukait?” Tu enentáimiuk “iistaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Atak Jesusa akatramuri̱ waketki taar ni túramuri̱n Jesusan ujakarmiayi. Nui̱ṉkia aents atsamunam Petsaitia péprunam tíjiu̱ch weak nui̱ júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tura peṉké shuar nuna nekaawar nemariarmiayi. Túram Jesus nin shiir áujsamiayi. Tura Yusa akuptairi̱ pachis unuiniamiayi. Tura jaa armia nuna tsuárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tura kí̱akui, tuse unuiniamu Jesusan wériar tiarmiayi “Uuntá, shuar akupkachminiashit. Tíjiu̱ch péprunmasha, shúarnumkesha wear ni yurumátniuri̱n sumarmakarti, tura kanartintri̱n wáinkiarti. Ju̱i̱ pujajnia ju̱i̱ṉkia peṉké atsawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tutai Jesus tímiayi “Atumsha ayuratarum.” Tutai chichainiak “Iisha aya seṉku tanta tura namaksha jímiarchik takakji. Ju̱ shuar ayuratin sumaktai tusar wétiniaitji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Áishmaṉsha ti untsurí̱ seṉku mir (5000) jeeá ámiayi. Tura Jesus ni unuiniamuri̱n chicharainak ““seṉkuenta seṉkuenta kanaarum aṉkant aṉkant pujustarum,” titiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Túrawarmatai ashí pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nuyá seṉku tantan tura jimiará namaknasha Jesus achik, yakiini̱ íimias Yúsan yumiṉsamiayi. Nuyá ajamsarat tusa ni unuiniamuri̱n súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ashí yurumáwar ejemararmiayi. Tura ampirman tuse chaṉkinnium áimkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesus ni unuiniamuri̱ji̱a̱i̱ áentsnumia̱ kanaki pujuarmiayi. Jesus Yúsan aujsua umik ni unuiniamuri̱n tiarmiayi “¿Yáiti turutainia Winia?” ");
INSERT INTO jivNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Niisha áimkiarmiayi, “Chíkich “Imiakratin Juáṉkaiti” turamainiawai; chikichcha “Iríasaiti” tura chíkichkia “yaunchu Yúsnan etserin nantakniua núiti” turamainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tutai “Tura atumsha ¿yáiti túrutrum?” tiarmiayi. Takui Pítiur chichaak “Ámeka Yusa Anaikiamuri̱, Kristu tutai, núitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tutai Jesus “Peṉké etserkairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nuyá Jesus tímiayi “Wi Aents Ajasuitjiana ju̱ ti waitsatniuitjai. Wíi shuara uuntri̱, tura ni Pátriri̱ úuntri̱sha tura ni jintinniuri̱sha nakitrurar maantuáwartatui. Túrasha iwiartusarmatai menaintiu tsawant jeamtai nantaktiatjai.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nuyá ashí áentsun chicharuk ju̱na tímiayi “Shuar Winia nekas nemartustajtsa wakerakka ni wakeramuriṉkia iniaisati. Tuke tsawant ni krusri̱ yanaki nemartusti. ");
INSERT INTO jivNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kame shuar ju̱ nuṉkanam aya péṉker pujustaj tákuṉka nu shuar uwemtsuk jakattawai. Antsu Winia anentu asa péṉker pujustinniak enentáimtsuna nú shuarka nekas iwiaakman wáinkiattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iimiata, shuar ashí ju̱ nuṉkanam ana nuna súmakui tura jinium wétin ákuisha ¿itiurak péṉker pujusat? ");
INSERT INTO jivNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wi Aents Ajasuitjiana ju̱ Winiasha tura winia chichampruncha shuar natsantraitkuiṉkia, winia wincharuja̱i̱, winia Aparu winchari̱ji̱a̱i̱ tura nayaimpinmaya̱ péṉker suntara winchari̱ji̱a̱i̱ atak táakun shuar natsantrurmia nuna natsantrattajai Wi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tura shuar Yusa akuptairi̱n wáintsuk jákachartatna nu jui̱ pujuiniawai. Nuna nekas tájarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nuna tuasua amik nuyá chíkich semanatin Yúsan áujsataj tusa Jesus náinnium wakamiayi. Pítiur, Jakupu, Juaṉja̱i̱ nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesus auju pujus nusháa iira ajattsarmiayi. Ni pushiri̱sha ti puju jíitsumir ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nui̱ṉkia jimiará áishmaṉ Niiji̱a̱i̱ chicháa wajarmiayi. Nuka Muisáis Eríasja̱i̱ ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ní̱i̱ncha wincha jíitsumir téntakarmiayi. Tura Jesus wáitias Jerusaréṉnum jákatniuri̱n amia nuna áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pítiur ni tsaniakmari̱ji̱a̱i̱ kari̱ ti pujainiai̱ṉ iwiáa pujuarmiayi. Tuma ásar Jesusan tura jimiará áishmaṉja̱i̱ jíitsumir ajas wajainian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tura nu áishmaṉ Jesusan ikiuki weenai̱ Pítiur Jesusan chicharuk “Uuntá, iisha ti shiir pujatsjik. Menaintiu áakmaktai, Áminiusha, Muisaisnasha, Eríasnasha áakmaktai” tímiayi. Tura Pítrusha enentáimtsuk nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nuna chicháa pujai̱ yuraṉkim tarí kaput amu̱awarmiayi. Tura yuraṉkim amu̱am ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nuiṉkia yuraṉminmaya̱ ju̱ chichaamun antukarmiayi: “Ju̱ka winia aneamu Uchiruiti. Nii anturkatarum.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chichaamun antasua amikiar Jesus niṉki wajan wáinkiarmiayi. Nuiṉkia takamtak pujuarmiayi. Tura wáinkiarmia nuna peṉké etserkacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kashin tsawantai̱, náinniumia̱ táarmatai, ti untsurí̱ shuar Jesus iṉkiuṉtai tusar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nu shuarnumia̱ chikichik áishmaṉ Jesusan untsuak tímiayi “Uuntá, waitneasam uchir íirtústá. Uchirsha jú̱chikiiti. ");
INSERT INTO jivNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Íwianch achik núpeteam niisha náṉkamas untsumui. Tura chichichiptu ajas wenunmasha saun kaput apaawai. Íwianch nin tuke yajauch awajas aṉkant awajsatniun nakitiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Túmakui ame unuiniamurmin iwianchin jí̱i̱rtukit tusan seamjai. Túrasha tujinkiarmai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tutai Jesus tímiayi “Yus enentáimtichutirmin, tutupnik wekaichatirmin ¿urutmá tsawanttsuk atumja̱i̱ pujustaj. Urutmá katsuntratjatsuk? Uchiram ju̱i̱ itiata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tura uchi winiai̱ íwianch nuṉká aju̱ant chichichiptu áepsamiayi. Tura Jesus iwianchin kakantar chicharkamiayi. Tura uchin péṉker awajas ni apari̱n awaṉtuki susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tura ashí pujuarmia nu ti enentáimprar “Yuska imiá úuntchakait” tiarmiayi. Jesus túramun ti enentáimtu pujuiniai̱ Jesus ni unuiniamuri̱n tímiayi ");
INSERT INTO jivNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Wi tájarmena ju̱ péṉker antuktarum. Winia Aents Ajasu tútain surutkartatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tura Nii timia nuna unuiniamuri̱ nekaacharmiayi. Nekaawara̱i̱ṉ tusa paantcha awajsamuyayi. Tura wariṉkit tusa anintrustinniasha arantukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nuyá ni unuiniamuri̱, yaki imiá naṉkaamaku ati tusa, nuamtak mai tunai ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tura ni enentáimsamuri̱n Jesus nekaamiayi. Tuma asa uchin achik ni pujamunam itiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Itiá tímiayi “Winia anentuk ju̱ uchin shiir awajeana nuka Winiasha shiir awajtawai. Tura Winia shiir awajtana nuka Winia akuptana nunasha shiir awajeawai. Kame átum naṉkaamantuchu tárumna nu ti nekas naṉkaamantuiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nuyá Juaṉ tímiayi “Uuntá, shuar ame náarmin pachis iwianchin ji̱i̱ki akupea nu wáinkiámji. Tura in páchitkiachu asamtai nuka suritkiamji.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tutai Jesus tímiayi “Antsu suritkiairap. Shuar in nakitramachkuṉka in páchitkiawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus, nayaimpiniam waketkitniuri̱ jeatemamtai, enentáimmia ímiatrusaṉ Jerusaréṉnum we-wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wesa, kanartinian wáinkiarat tusa akatar émtikiarmiayi. Tura niisha Samaria péprunam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tura Samarianmaya̱ aentska, Jerusaréṉnum wéenan nekaawaru ásar itiaatniun nakitrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesusa unuiniamuri̱ Jakupusha Juaṉsha nuna nekaawar, Jesusan tiarmiayi “¿Uuntá, Erías yaunchu túramia núnisrik iisha túrat tusam wakeramek. Nayaimpinmaya̱ ji tara Samarianmaya̱ aentsun amukarti, títiatjik?” ");
INSERT INTO jivNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tutai Jesus nin íisar kakantar chicharuk tímiayi “Atumsha atumi enentái̱ urukukit nuka nekamatsrume. ");
INSERT INTO jivNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wi Aents Ajasu áentsun emesrattsan táchaitjai. Antsu uwemtikratajtsan táwitjai” tímiayi. Nuyá chíkich péprunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jintiá weenai̱, chíkich áishmaṉ Jesusan chicharuk “Uuntá, tuí̱ wétatam nui̱sha nemarsatjame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tutai Jesus tímiayi “Kujanchmasha ni wáa̱ri̱n takaktsuk. Chiṉkisha pasuṉken takaktsuk. Tura Wi Yusa Uchirí̱ntiatan tepesan ayampratniur atsawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chíkich áishmaṉkan Jesus “Nemartusta” tímiayi. Tutai nii chichaak “Antsu, Uuntá, winia apar jakamtai, iwiarsa ikiuakun nemarsatjame. Nu tsaṉkátrúktá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tutai Jesus tímiayi “Jakaa ainia nu ni shuari̱n iwiarsatniunka enentáimtusarti. Tura ámeka weme Yus-shuar átin urukukit nu etserkata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nuyá chíkich tímiayi “Uuntá, nemarsataj tusan wakerajme. Túrasha wíi shuaran emka áujsan ikiuweartaj tsaṉkátrúktá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tutai Jesus tímiayi “Shuar arayat ukunmaani̱ apa̱jas iimna nu, Yus akupeana nui̱ takaschamniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nuyá ukunam chíkich unuiniamuri̱n setenta anaikiarmiayi Jesus. Tura jímiar jímiaran apatak émkitiarum tusa ashí péprunam ashí nuṉkanam ni wétin amia nui̱ akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akupeak tímiayi “Nekas tájarme, Yus-Chicham étserkum, júuktinia núnisaṉ, aents Yus-shuar awajsatin ti awai. Tura ¿yaki júukat, aya ishichik takainiasha? Tuma asamtai ni takarniuri̱ akupkat tusarum Nerentin seatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wetarum. Átumka murikiua núninaitrume. Uunt yawa̱ yujamua núninnium tsuumai ámunam akupeajrume. ");
INSERT INTO jivNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yurumkasha, kuitcha, sapatcha júkiirap; shuarja̱i̱ jintiá áujmamsatai tusarum wajasairap. ");
INSERT INTO jivNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Je̱a̱ waya̱krum emka ju̱ titiarum: “Ju̱ je̱a̱nam pujuinia nuna Yus shiir awajsarti.” ");
INSERT INTO jivNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nérentin “Ee, nuna wakerajai” tákuiṉkia túrunattawai. Tura “Atsá, wakeratsjai” tákuiṉkia, “nuiṉkia túrunashti” titiarum. ");
INSERT INTO jivNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Je̱á waya̱ttarmena nú je̱a̱nmaṉ pujustarum. Tura ajampramsattarmena nu yuatarum. Warí, takaana nu akinkiashtinkiait. Chíkich je̱a̱nam nui̱ werum nui̱ werum ajairap. ");
INSERT INTO jivNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Awa̱intiamawartatna nú peprunam jearmeka ajampramsartatna nu yuatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jaa ainia nu tsuártarum. Túrarum “Yus ju̱ nuṉkanam akupin ajastin ishichik ajatemsai” nu peprunmaya̱ shuar titiarum. ");
INSERT INTO jivNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Íksarmek itiaarmachartatna nú peprunam jearum, jintiá wajasrum ju̱ titiarum, ");
INSERT INTO jivNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Yusna nakitra asakrumin, atumi péprurinia̱ nuṉka ii nawe̱n peema japirar akakekji. Túrasha ju̱ paant nekaatarum: Yus ju̱ nuṉkanam akupkatin ishichik ajatemsai.” ");
INSERT INTO jivNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yusa nekapsatin tsawantri̱ jeamtai nu peprunmaya̱ shuaran ti asutiáttawai. Yaunchu Sutumanmaya̱ shuaran asutiámia nuja̱i̱ naṉkaamas asutiáttawai. Núnaka paant tájarme tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘Wáinkiatá, Kurasín péprunmaya̱tiram. Wáinkiatá Petsaitia péprunmaya̱tirmesha. Atumí pépruri̱i̱n aents tujintiamun ti túraitjai. Warí, yaunchu Tiru péprunmasha, Setuṉ péprunmasha nu tujintiamu túramuitkuiṉkia yaunchu ni enentái̱n yapaji̱áwara̱a̱yi. Túrawar kúntuts pujutai pushin entsarar yuṉkunim ajakiara̱a̱yi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tura atumsha aents tujintiamu túramu wáiniatrum yapaji̱achu asakrumin Tirunmaya̱ tura Setuṉnumia̱ aentsja̱i̱ naṉkaamas asutniáttarme. ");
INSERT INTO jivNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tura atumsha Kapernáumnumia̱tirmesha, “ti naṉkaamantu ajasar nayaimpiniam jeattaji” tu enentáimtsurmek. Maaj, antsu jaka matsamtainium jeattarme, auka” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tura Jesus ni unuiniamuri̱n ju̱nasha tímiayi: “Atumin anturtamainiakka Winiasha anturtuiniawai; atumin nakitramainiakka Winiasha nakitruiniawai; tura nú arant, Winia nakitrakka Winia akuptukua nunasha nakitiawai.” Tú áujas Jesus nin akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ukunam nu setenta unuiniamu warasar waketki táarmiayi. Tura chichainiak “Uuntá, ame náarmi̱i̱n íwianch ji̱i̱ki akupeam umirtamkamji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tutai Jesus tímiayi “Ee, Wisha nayaimpinmaya̱ peem peetna núnisaṉ, uunt iwianch Satanásan akaiki iniaan wáinkiamjai. ");
INSERT INTO jivNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Atumniaka winia kakarmarun susamjarme, napi najarmasha titiṉ najarmasha yajauch awajtamsa̱i̱rum tusan; tura ii nemasri̱ kakarmari̱ nupetkatniuncha susamjarme. ");
INSERT INTO jivNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Túrasha íwianch umirtamkui nu enentáimsam warasairap. Antsu atumí naari̱ nayaimpiniam aarma aa asamtai warastarum” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nuiṉkia ni enentái̱n Yusa Wakaní̱ waramtiksam Jesus ju̱na tímiayi: “Aparú, ashí nayaimpiji̱a̱i̱ nuṉka Úuntrinme; tuma asam ju̱ túrunamu ti unuimiaru enentáimtumainia nuyá ú̱u̱kuitme; antsu uchichia núnis naṉkaamantuchu enentáimtumainia nú shuar paant awajtusuitme. Ee, Aparú, núnik wakerichmakum. Tuma asamtai shiir enentáimtajme, Aparú” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Winia Apar ashí surusuiti. Wisha ni Uchiri̱ asamtai Winia nékarui. Tura chíkich Winia nekas nekarainiatsui. Yus Apancha Wiki nékajai. Tura Wi wakeraj nú shuaran winia Aparun paant awajtajai. Nú shuarsha winia Aparun nékainiawai.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Nuyá ni unuiniamuri̱n iis tímiayi “Wi tájarme, untsurí̱ Yúsnan etserniusha tura uunt akupniusha átum yamái wáintrum nuna wáinkiatniun wakeruiniayataṉ wáinkiacharmiayi. Tura átum yamái ántarme nuna antuktinian wakeruiniayataṉ antukcharmiayi. Tura Yus achirmaku asakrumin, wáintrumna nu ti péṉkeraiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nuyá akupkamun jintinkiartin Jesus warintiak chichakat tusa wajatki werimiayi. Werí iniimiayi “Uuntá, wi tuke iwiaaku átaj takun ¿warinia túratniuitiaj?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tutai Jesus aya̱k “¿Yús-Papinium Muisáis áarmanum waritia áarmait. Waritia enentáimiam?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akupkamun jintinkiartin aya̱k tímiayi “Ju̱na tawai: Ti enentáimsam, tuke enentáimja̱i̱ Uunt Yus aneeta. Ame kakarmaram, iwiaakmarmesha Yus íiktusta. Tura ame aya̱shim aneamna núnismek ame írutramurmesha aneeta. Núchakait” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tutai Jesus tímiayi “Péṉker áimsame. Nu túrakmeka tuke iwiaaku átatme.” ");
INSERT INTO jivNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tutai akupkamun jintinkiartin ni anintramun kíishtumaktajtsa wakerak “Winia írutramursha ¿ya ainia?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Takui Jesus tímiayi “Jerusaréṉnumia̱ jintia Jirikiú péprunam jeana nú jintianam áishmaṉ wean, kasa áishmaṉ tariar ni wariri̱n, pushiri̱ncha kasarkarmiayi. Tura katsumkar mayái̱ ashirak aju̱antar ikiukiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tura Israer-shuar Patri ukunmaṉ winis nu áishmaṉkan wáiniak aya íikiaṉ iis ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nuyá ukunam Patri yáintri̱sha nu jintianam wesa, nu áishmaṉkan wáiniak, áyatik iis ikiuak wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tura nuyá Samaria nuṉkanmaya̱ áishmaṉsha nu jintianmaṉ wesa, nu áishmaṉkan wáiniak ní shuárinchunak wáitnéntramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nuyá nu áishmaṉkan weantuk ni numpamnamuri̱n asuitiji̱a̱i̱ tura wíniuja̱i̱ tsuar jaanchji̱a̱i̱ penuarmiayi. Tura ni kawairi̱i̱n ekenak jukimiayi. Tura írar kanutainiam jukí ejé nu áishmaṉkan péṉker wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tura kashin tsawa̱rmatai Samarianmaya̱ áishmaṉ weak jimiará kuítian jusa je̱á nérenniuri̱n susamiayi. Susa tímiayi “Ju̱ áishmaṉ péṉker wáitrukta. Tura wi amaajna ju̱ táasmataisha wi wáketkun akiktajme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ayu, ámiji̱a̱i̱sha, nu menaintiu áiniana nu, ¿tuá imiá nekas katsumkamun waitnentramia?” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Takui akupkamun jintinkiartin chichaak “Entá, katsumkamun wáitnentramia núa” tímiayi. Tutai Jesus tímiayi “Amesha weme núnismek túrata.” ");
INSERT INTO jivNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nuyá Jesus jintiá wesa chíkich péprunam jeamiayi. Nu péprunmaya̱ nuwa̱ naari̱ Marta ni je̱e̱n itiaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta kai̱ ámiayi ni naari̱ Marí. Marisha unuiniamun anturkataj tusa Jesusa nawe̱n pujursamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tura Mártaka ni takatri̱n ti enentáimtak Jesusan weantuk tímiayi “Uuntá Jesusá, ¿winia kai̱r takatan winiak íiktursainia nuka enentáimtsumek? Winia yáiṉtá turuttia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tutai Jesus tímiayi “Maaj Martá, untsurí̱ túratin ana nu ti enentáimsam itit awajtamui. ");
INSERT INTO jivNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tura aya chikichik nekas túratniuiti. Marikia nekas péṉker ana nuna achikiai. Nusha peṉké jurunkishtatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Chíkich tsawantai̱ Jesus Yúsan áujsataj tusa atsamunam pujumiayi. Áujsua amikmatai ni unuiniamuri̱ chikichik Nin tímiayi “Uuntá, imiakratin Juaṉ ni unuiniamuri̱n unuiniamia núnismek Yus áujsatin unuitiurta.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tutai Jesus tímiayi “Yus áujkuram ju̱ titiarum: Aparu Yus, nayaimpiniam pujamna nu, ii Aparí̱nme. Ame náarmincha shuar ántar pachischarti. Ashí áentsnum ame akupkatin tsawantrum wari jeati. Ame wakeramuram nayaimpiniam umikma ana núnisaṉ ju̱ nuṉkanmasha uminkiatí. ");
INSERT INTO jivNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aparú, ii yurumkari̱ ashí tsawant amasta. ");
INSERT INTO jivNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tura winia nemasrun tsaṉkurajna núnismek, Aparú, winia tunaaru tumashri̱sha tsaṉkurturta. Tunáa wakeruktin tsaṉkatrukaip. Antsu ashí tunaanumia̱ uwemtikrurta.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Nuyá Jesus ju̱na tímiayi. “Wats, ju̱ titiái. Kashi ajapéṉ amikrum werishtameash. Tura “Winia amikiur yajaya̱ winia je̱a̱rui̱ yama tayi. Tura ajamsatniun peṉké takaktsujai. Tuma asamtai amikru, menaintiu apatuk ajamprustá” tíchatameash. ");
INSERT INTO jivNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tura nii init pujusaṉ chichaak “Warí, wáitisha epenmiaiti, tura winia uchirsha wiji̱a̱i̱ ashí tepeenawai. Itiur nantakniak amastaj. Itit awajtipia” turamchanpiash. ");
INSERT INTO jivNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wats, paant tájarme, niisha amikrum asa, nantaki ikiatmastinian nakitiayat, itit awajtiṉ tusa nantaki ashí wakeramna nuna suramsattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tuma asamtai tájarme: Yus seatarum; túrakrumin suramsattarme. E̱a̱krumka wáinkiattarme. “Winiajai” tákurmin awa̱intiamattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Seana núnaka suíniatsuk. E̱a̱na nuka wáintsuk. “Winiajai” tuinia núnaka awa̱iniatsuk.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Wats, átum uchirtintiram, ame uchiram apatkun seatmakui ¿kayaash súsaintiam? Namakan seatmakui ¿napíash súsaintiam? ");
INSERT INTO jivNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nujintian seatmakuisha ¿titiṉkiash súsaintiam? ");
INSERT INTO jivNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Warí, átum imiá yajauchitirmesha atumí uchiri̱ péṉker ana nu tuke súchakaitrum. Atumí Apari̱ nayaimpiniam pujana nu, seakrumniṉkia nú naṉkaamas ni Wakani̱n suramsattawai.” Tu unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Shuar iwianchruku asa chichachu ámiayi. Nuna enentái̱yan nu iwianchin Jesus ji̱i̱ki akupkamiayi. Íwianch jiinkimtai chichachu chichasmiayi. Túramtai shuar nui̱ pujuarmia nu ti enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tura chíkich tiarmiayi “Ju̱ka iwianchi̱ kapitiántri̱ Satanásan, ni chíkich naari̱ Pirsepún umirniuiti. Tuma asa nuna kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki akupeawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tura chíkichkia, nekas Yúsnumia̱ taawashit tusar “Nayaimpinmaya̱ kakaram ana nu iniakmasam aents tujintiamu túrata” Jesusan tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tura Jesus tu enentáimiainian neka asa tímiayi “Núu nuṉkanmaya̱n shuar nuamtak kajernaiyakuiṉkia nú nuṉka wárik meserchattawak; nuamtak shuarsha ni shuari̱ji̱a̱i̱ kajernaiyaksha amunaikchartatuak. ");
INSERT INTO jivNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wíniaka “Pirsepú iwianchi kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki akupeawai” túruttsurmek. Tuma asamtai tájarme, uunt iwianch Satanás naartin, ni suntari̱ji̱a̱i̱ kajernaiyaksha ¿itiur tuke kakaram átinkⁱ? ");
INSERT INTO jivNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tura Wi Pirsepú kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱ki akupeakuiṉkia, atumi shuari̱sha ¿yana kakarmariji̱a̱i̱ṉ iwianchin ji̱i̱ki akupena? Niisha “iwianchi kakarmari̱ji̱a̱i̱ túrichuitji” tuiniai̱sha ¿itiura Winiasha, “iwianchi kakarmari̱ji̱a̱i̱ túraiti” turutminiaitrum? ");
INSERT INTO jivNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wikia Yusa kakarmari̱ji̱a̱i̱ iwianchin ji̱i̱kin akupeajai. Nu nekaarum Yus atumi̱ enentái̱n akupin ajasuana nu nékarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Kakaram áishmaṉ kíishtumaktajtsa iwiarnar wajas je̱e̱n wáinkiui, ni wariri̱ init ana nusha tímiatrusaṉ áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Antsu niiji̱a̱i̱ naṉkaamas kakaram ana nu winiakka nupetkashtatuak. Tura kíishtumaktinian iwiar takakman jurawai. Tura kasamkámun ni amikri̱n súawai. Kakaram áishmaṉ iwianchin nakumeawai. Tura nuja̱i̱ naṉkaamas kakaram áishmaṉ Winia nakumprawai. ");
INSERT INTO jivNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iista. Winia nemartatsna nu winia nemasruiti. Núnisaṉ Winia yáintsuna nuka aya itiurchat nájateawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nuyá Jesus ju̱na tímiayi: ‘Shuara enentáiya̱ íwianch jiinki ayamprataj tusa yumi peṉké yútatsna nui̱ wéawai. Tura ayampratniun wáincha asa ataksha waketkitniun enentáimui. “Wi jíinkimiaj nui̱ṉ waketkitjai” tawai. ");
INSERT INTO jivNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tura waketki péṉker iwiaramun tura aṉkant aan wáiniui. ");
INSERT INTO jivNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nuna wáiniak, ni a̱in siati iwianchin niiji̱a̱i̱ naṉkaamas yajaunchin itiá eṉkemáwartatui. Túrunamtai nu shuar nuiki nuna naṉkaamas yajauch ajastatui.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Shuar iruniarmia nui̱ Jesus nuna chichaa pujai̱, nuwa̱ untsumuk “Ame nukun Yus ti yáiṉkiai. Ni ampujé̱n ame pujuschamkam. Ámin amuntstamachmakam” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tutai Jesus tímiayi “Antsu ni chichame̱n antukar umirainia nuna, nukurja̱i̱ naṉkaamas Yus ti yáiṉkiaru áiniawai, tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Shuar untsurí̱ Ni̱i̱n káunkarmatai Jesus tímiayi “Yamaiya̱ shuarka yajauch áiniawai. Yajauch ásar, chichartuiniak “Nekas Yúsnumia̱itkiumka aents tujintiamua nu túram Yusa kakarmari̱ iniakmasta” turutainiawai. Túrasha áyatik yaunchu Junas túrunamuja̱i̱ iniakmasmia nuja̱i̱ṉ nekaatin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kame Junas túrunamuja̱i̱ Níniwi péprunmaya̱ shuaran yaunchu Yus ni kakarmari̱n iniakmasmia núnisaṉ yamaisha Aents Ajasu tutainjiana nu Wi túrunamuja̱i̱ Yuska ni kakarmari̱n iniakturmastatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yaunchu Sarumún uunt akupin pujai̱ Sepa núṉkanmaya̱ nuwa̱ akupin Sarumuṉka chichame̱n nekaataj tusa ti jeashtanmaya̱ támiayi. Tura yamaikia Sarumuṉja̱i̱ naṉkaamas pujai̱ átumka anturtatsrume. Tuma asamtai Wi tájarme, Yus ashí shuaran nekapsattana nu tsawant jeamtai nu nuwa̱, akupniun péṉker anturka asamtai, Yus íimianum péṉker átatui. Antsu atumsha Winia anturtukcha asakrumin Yus íimianum yajauch átatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tura Yúsnan etserin Junas Níniwi péprunmaya̱ shuarnum Yus Chichaman etserkamtai nu shuar ni tunaari̱n enentáimtusar enentái̱n yapaji̱áwarmiayi. Tura ju̱i̱ yamái Junasja̱i̱ naṉkaamas etserin pujajai. ¡Tuma asamtai nekapsatin tsawant jeamtai Níniwinmaya̱ shuar yamaiya̱ shuar árumna nuna sumamtikramattarme!’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘¿Shirikip ekeemakar ú̱u̱ktinkiait? Pitiaknumsha eṉkeashtiniaiti. Antsu shuar je̱á waya̱na nu paant íimsat tusar yakí ekensatniuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ame jí̱i̱miji̱a̱i̱ wáinkiam nuja̱i̱ wekasatin nekaattame. Tuma asamtai ame ji̱i̱miji̱a̱i̱ péṉker ana nu wáinkiumka péṉker wekasattame; antsu ame ji̱i̱miji̱a̱i̱ yajauch ana nu wáinkiumka, kiritniunam wekasatniua núnisaṉ yajauchiniam wekasattame. ");
INSERT INTO jivNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Anearta. Enentáimin tsáapin ana nu kiritin ajaschati tusam anearam wekasata. ");
INSERT INTO jivNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ame aya̱shmi̱i̱n kirit ajatsuk aya tsáapniniaitkiuiṉkia, shirikip paant awajea núnisaṉ ashí paant wáinkiattame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus chichasua amikmatai Pariséu shuar, winia jearui̱ yurumáitia tusa untsukmiayi. Tutai Jesus wa̱yá misanam pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tura Israer-shuar ikijmiartin ana nuna túrutsuk aya pujakui Pariséusha nuna wáiniak “maa ¿urukamtia tura?” tu enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tura Uunt Jesus tímiayi “Pariséutirmeka atumí yurumtairi̱ aya pátatek nijiaktin ti wakeriniaitrume. Atumsha nu yurumtaiji̱a̱i̱ méteketrume. Pátatek péṉker túrarme. Tura atumí enentái̱nkia kasamkatniusha tura yajauchia nusha piakuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Enentáimcha! Warí, ashí pátatek wáiniajⁱ nuna Yus najanachmakia; tura init paantcha ana nunasha Yúsak najanachmakia. ");
INSERT INTO jivNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","42","Aneartarum, Pariséutirmesha. Aya nuka méntasha, anissha tura aya apatkusha Yus súsatin ti enentáimprume. Nukasha tsuriasrum apatkusha tias ana nuyá chikichik achikrum, Yúsnaiti tátsurmek. Tura antsu nu túratin iniaitsuk péṉker wekasatniusha, Yus anenmarmena nusha péṉker enentáimsatniuitrume. Wats init, enentáimin ana nútiksarmek jusam susarta. Nuiṉkia ashí chamir átatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Tura aneartarum Pariséutirmesha. Yus áujtai je̱a̱nam peṉkeri̱ pujutainium pujustin wakerarme. Tura jintiá aents íimiainiamunam ti shiir áujtusarat tusarum wakerarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Jintinniutirmesha, Pariséutirmesha mái-metek aneartarum. ¡Antar shiir chichamtinia! Iwiarsamu paantcha núniniaitrume. Shuar nu naṉkaamaksha nájamiat nékatsui. Núnisaṉ shuar atumi̱ chichame̱ antukar yajauchia nuna nekartamtsurme.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nuikia Israer-shuara jintinniuri̱ chikichik Jesusan chicharuk tímiayi “Uuntá, nu tákum incha yajauch chichareame.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tutai Jesus tímiayi “Atumsha jintinniutiram aneartarum. Atumi̱ akupkamuri̱ji̱a̱i̱ káarak ti kijin entsakchamnia súarme. Tura átumka yáiṉtaj tusarum atumí uweje̱ja̱i̱sha peṉké ántiatsrume.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘Aneartarum tájarme. Yaunchu atumí uuntri̱ Yúsnan étserniun máawarmia nuna iwiarsamuri̱ átum jeamniuitrume nu etserin ti péṉker ásarmatai kajinmatkishtin. ");
INSERT INTO jivNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nu túrakrum atumí uuntri̱ túrawarmia nu, “yajauchichuiti” tarume. Warí, niisha máawarmiayi, tura atumsha máawarai táyatrum niiji̱a̱i̱ méteketrume. Warí, Yúsnan etserniu iwiarsamuri̱n jeamkuram atumek sumamarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Atumí túramuri̱n nekáa Yus ju̱na yaunchu tímiayi: “Winia etserturniun tura winia akatramurnasha ni̱i̱n akuptukartatjai. Túramtai chikichnaka máawartatui, tura chikichnaka pataatukartatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tuma asamtai ashí ni etserniuri̱n maamu ainia nuna, yamaiya̱ áentstirmin Yus sumamtikramattarme. Nuṉka najanamunmaya̱ jukí ");
INSERT INTO jivNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","yamái ímiajai̱ maamu ainia nuna, kame Apir maamunmaya̱ jukí yamái Sakarías maamua tímiajai̱ anintrustatui. Namaṉ maar Yus sutai ámanum tura Yus-je̱a̱ ámanum ajapén atenkamunam máawarmia nú Sakaríasan tajai. Nu tuma asamtai tájarme, ni etserniuri̱ maantamnawarmia nuna yamái matsatrumna nútirmin aninmasartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Jintinniutiram aneartarum. Waiti asakatniua núnisrumek nekas nekaatin surimiarme. Atumkesha nékatsrume. Tura nekaataj tana nusha suritiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesus nuna takui Pariséusha, jintinniusha ti kajerkarmiayi. Tura nii tana nuja̱i̱ “yajauch túrame” titiai tusar wakeruiniak untsurí̱ anintriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nu tumai̱ shuar ti untsurí̱ káunkarmiayi. Ti kaunka ásar nawe̱n mai-najatnai ajarmiayi. Tura Jesus ni unuiniamuri̱n tútan juarkimiayi. “Pariséu ántar chichamtin áiniawai. Nuka wakaprutaiya núnisaiti. Wakaprutaikia nijiamanch yumirnium yama eṉkeam páantchaiti. Tura ukunam nekaamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Núnisaṉ ashí paantcha ana nu iwiainiakma átatui. U̱u̱kma ana nusha nekaamu átatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nu tuma asamtai, kiritniunam tímiarmena nusha tsawái tsáapin ajasmanum antunkattawai. Tura je̱a̱ init pujusrum ishishmasrum tímiarmena nusha áa̱ ti paant etsernaktatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Amikrutiram, aya aya̱shmin main ainia nu ashamkairap, tájarme. Aya̱shmin maa nú arantka máashtatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tura ya nekas ashamkatniuitrum, nuna paant jintintiattajrume. Ame aya̱shmi̱ maa, nuyá ámin jinium akuptamkatniun tujintiatsna nu ashamkatarum. Ee, Yus ashamkatarum, tájarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Jimiará chiṉki ishitiúpchich ishichik kuitja̱i̱ surukchatniukait. Túrasha Yussha nu chiṉkin peṉké kajinmatkishtatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wats, ashamkairap. Untsurí̱ chiṉkiji̱a̱i̱ naṉkaamas Yuska atumin enentáimturmarme. Warí, ame intiashmin mash Yus nekapmaruiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Ashí shuar ashí íimiainiamunam Winia Aents Ajasu tutain, Winia natsantruiniatsna núnaka, Wisha Yusa suntari̱ íimiainiamunam natsantrashtatjai; ");
INSERT INTO jivNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","antsu shuar íimiainiamunam Winia natsantrana núnaka Wisha Yusa suntari̱ íimiainiamunam natsantrattajai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Winia, Aents Ajasu tutain, shuar yajauch chichartakuiṉkia nusha tsaṉkuramniaiti, tura Yusa Wakaní̱ncha yajauch chicharkuiṉkia nuka peṉké tsaṉkurachminiaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Wats, Israer-shuar iruntai je̱a̱nmasha, tura Israer-shuar kapitiánniumsha, uuntnumsha juramainiakui, aninmainiakuisha warintiajak tusam ti enentáimsáip. ");
INSERT INTO jivNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ame áimkiatin jeamtai, Yusa Wakani̱ ame títiatmena nuna jintintramattawai,” tu timiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chíkich áishmaṉ Jesusan tímiayi “Uuntá, ii aparí̱ ikiurtamkimiaj nuna yatsur winiasha nakak surustí, titia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tutai Jesus tímiayi “Áishmaṉka, atumin nu túratin anaikiamukaitiaj.” ");
INSERT INTO jivNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nuyá tímiayi “Péṉker enentáimsatarum. Nii takakna núja̱i̱ṉ shuar iwiaaku, áchatniuiti. Tuma asamtai kuítrintin ajastin aya nuke enentáimsaip.” ");
INSERT INTO jivNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nuyá ju̱na métek-taku chichaman unuiniak tímiayi: “Kuítrintin áishmaṉ ni ajari̱ya̱n arakan ti nukap juukmai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tura “¿Ti nukap asamtai tuiṉ ikiustaj. Itiurkatjak?” tu enentáimsamiai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wats, wi nékajai. Winia ikiutái-je̱a̱run ashiran nú naṉkaamas úuntan najanatjai. Tura nui̱ ashí ikiustajai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nuiṉkia untsurí̱ uwitin shiir pujustinian ikiusman takustatjai. Tuma asamtai, ayampran, yurumán, umaran shiir pujustatjai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Tura Yus nin chicharuk timiai “Netse. Yamái kashi jakattame. Nuiṉkia imiá núkap ikiusumna nusha ¿yana átata?” timiai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nuyá Jesus tímiayi “Shuar niṉki kuítri̱n ikiauntumna nu, núnisaiti. Túrasha Yusja̱i̱ íismaka kuítrinchaiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nuyá ni unuiniamuri̱n Jesus ju̱na tímiayi: “Warí yuarik pujustajⁱ tura wariṉ entsartajⁱ tusarum nuke ti enentáimsairap. ");
INSERT INTO jivNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yus iwiaaku átinian amasu asa yurumkancha amastatui. Tura ju̱ aya̱shniasha najana asa entsataincha amastatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chiṉkisha enentáimsatarum. Niisha arakmainiatsui. Juuk yurumkan ikiuiniatsui. Tuma aiṉ Yuska ni yurumátniuri̱n tuke súawai. Atumsha chiṉkia nú naṉkaamaschakaitrum. ");
INSERT INTO jivNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tura ya shuarak, ti enentáimtana nuja̱i̱ nú naya ajasminiait. ");
INSERT INTO jivNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kame yúpichuch ana nusha túrachminiaitiatrumsha, ¿urukamtai chíkich ainia nusha ti enentáimtarum?’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Íistá, kukujsha takaachitiat tura nájanchitiat ti shíirmach áiniawai. Yaunchu akupin Sarumúṉ ti shiir iwiarmamniuitiat kukujia tímianchauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iis, nupa yamái tsakaawai tura kashin aents tsupikiar jinium apeánáwai. Tuma aiṉ Yus ti shiir awajeatsuk. Nuna tura asa atumniasha nú péṉker wáitmakchattawak. ¿Urukamtai Yus nekas enentáimtatsrum? ");
INSERT INTO jivNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Ju̱ nuṉkanam ana nu ti pachiirap. Chíkich shuar, Yúsan nékainiatsna nu, wariṉ yuatajⁱ, wariṉ umartajⁱ nuna ti pachiiniawai. Tura atumsha tu enentáimsairap. Urukatjak, tiirap. Ame Apa nayaimpiniam pujana nu, ashí atsumarmena nuna nékawai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Antsu emka Yusna nu enentáimtustarum. Túrakrumniṉkia atsumamna nuna Yus suramsattawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Winia murikrutiram ashamkairap. Untsurí̱chuitrume. Túrasha atumí Apari̱ ni akuptairi̱i̱n pachitmaktasa ti wakerutmarme. ");
INSERT INTO jivNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Kuítrum tui̱ aa, nui̱ tuke enentáimtittiarme. Tume asamtai takakrumna nu surukrum atsumainia nu susatarum. Nuka eṉketai arut ajatsna nui̱ eṉkeatniua núniskete. Túrakrum nayaimpinmaya̱ kuit amuatsna nu íkia̱u̱wearme. Nui̱sha kasa nu kuitian kasamkataj tusa waya̱chminiaiti, tura kaya̱a̱sha nu kuitian yúatniun tujintiawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","‘Ju̱ enentáimsatarum. Ni uuntri̱ nuatnaikiatin námpernumia̱ taa, “uraitia” takui, takarni̱uri̱ jinia ekeemakar wárik urattiai tusar nakáa pujuiniawai. Atumsha núnisrumek Wi atumi̱ Uuntri̱ támatai, shiir itiaatai tusarum anearum wekasatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ni uuntri̱ taak iwiáa pujuinian wáinkiarai nuka shiir pujuiniawai. Nu úuntak iwiar, “misanam pujustarum” ni takarni̱uri̱n títiatui tura yurumkan súsartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kashi ajapéṉ taaksha tura tsawa̱a̱na ai̱ taaksha ni takarni̱uri̱n iwiáa pujuinian wáinkiuiṉka, nu takari̱n shiir pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tura ju̱sha nekaatarum. Je̱e̱nniua nu, kasa tátinian nékaitkiuṉka, iwiáa pujusa̱a̱yi. Kasa wayá kasamkatniun suritkia̱a̱yi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Atumsha núnisrumek, anearum pujustarum. Wi Aents Ajasu tutai aya aneachmanum tátatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nuyá Pítiur aniasmiayi “¿Aya ínkik unuiniartaj tusam nu métek-taku chicham támek. Kame ashí nekaawarat tusamek tame?’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tutai Jesus tímiayi “Atumsha péṉker takatan wáinniua núnisketrume. Takatan wáinin ni uuntri̱ takatri̱n takainia nuna, yurumátin jeamtai, ayurkamna núiti ni úuntri̱n shiir umirna nu, tura péṉker enentáimtana nu. ");
INSERT INTO jivNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ni uuntri̱ taa, takatri̱n tímiatrusaṉ túran wáinkiuiṉkia nu wáinniusha shiir enentáimsamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Umirin asamtai, ni uuntri̱ ashí ni wariri̱n wáitrukat tusa apujsattawai. Nuna paant tájarme. ");
INSERT INTO jivNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tura nu takatan wáinniusha “úuntur wau táchattawai” tu enentáimias, ni uuntri̱ takarniuri̱n yajauch awajeakuiṉkia tura niṉki ti yurumá, ti umar nampeakuiṉkia, ");
INSERT INTO jivNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nuiṉkia ni uuntri̱ ni nákachmanum aya aneachma taa ti asutiáttawai. Umichu pujuinia nui̱ akupkattawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Takarin ni uuntri̱ wakera nuna nékayat, iwiartsuk umitsuk pujakka ti awatramu átatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Túrasha takarin nékachu asa, asutniámnia túrakka, ishichik awatnartatui. Núkap susamu ana núnaka núkap seawartatui. Núkap ataksamu ana núnaka núnisaṉ naṉkaamas seawartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Jiji̱a̱i̱ nekapsatniua nútiksanak nuṉkanam jinia ikiapartaj tusan tamajai. Tura túrunat tusan ti wakerajai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Imiantinia núnisan itiurchat ukatruktatui. Nusha wárik amuukat tusan ti wakerajai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ashí shuar shiir pujusarat tusa táwiti” tu enentáimturumek. Núchaiti. Antsu shuar tesanairat tusan táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yamái jukimiutak chikichík shuarnum seṉku ainia nu akannakartatui; menaintiu shuar ni shuari̱n jímiaran nakitrartatui. Jímiarsha ni shuari̱n menaintiun nakitrartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apasha ni uchirí̱n nakitrattawai. Núnisaṉ uchisha ni aparí̱n nakitrattawai. Nukusha ni nawantri̱n nakitrattawai, nawantri̱sha nukurí̱n nakitrattawai. Tsatsari̱sha ni najati̱n nakitrattawai; najati̱sha tsatsari̱n nakitrattawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus áentsun chicharuk ju̱nasha tímiayi “Atumsha nantu akaatainmaani ki̱armatai “yutuktatui” tátsurmek. Nusha nekas tárume. ");
INSERT INTO jivNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tura anaarania̱ nase násenkamtai “séeji̱k átatui” tárume. Tura nekas tárume. ");
INSERT INTO jivNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yuraṉminmasha nuṉkanmasha túruna nu nékarme. Túmaitiatrumsha ju̱ tsawantai̱ túrunattana nusha ¿itiura nékatsrum? ¡Maaj, ántraitrume!” ");
INSERT INTO jivNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘Túrasha péṉker ana nusha ¿urukamtai atumek enentáimsarum wáintsuram? ");
INSERT INTO jivNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Irutramuram úuntnum júramkuiṉkia jintia wésamek “nuamtak iwiarartai” titiá. Túrachkumniṉkia akupniunam juramkittiame. Tura niisha suntarnum akuptamkattame. Tura niisha sepunam eṉketmattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tura nekas tajai, nui̱ eṉkemamka ashí rearchisha akikmachkumka jíinkishtatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nu tsawantin chícham ujaktai tusar Jesusan tariarmiayi. Kariréa nuṉkanam Israer-shuar ni waakari̱n máawar Yus susatai tusar pujuiniai̱, Piratu nin maa, nuna numpe̱n waaka numpe̱ja̱i̱ pachimpramun ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tura Jesus tímiayi “¿Warí enentáimsarum? Kariréanmaya̱ áishmaṉ tárumna nu, chíkich Kariréanmaya̱ áishmaṉja̱i̱ naṉkaamas yajauch ásar túrunawarai ¿tu enentáimprumek? ");
INSERT INTO jivNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Atsá; atumí enentái̱ yapaji̱áchkurmeka núnisrumek atumsha jakattarme. Nuna paant tájarme, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tura tiasiúchu áishmaṉ yakí je̱a̱ Seruí kupiniak iniaak nekeṉkarmiania nu, ¿warí enentáimtarum? Chíkich Jerusaréṉnumia̱ shuarja̱i̱ naṉkaamas tunáa ásar túrunawarai ¿tu enentáimprumek? ");
INSERT INTO jivNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Atsá, tájarme. Atumí enentái̱ yapaji̱áchkurmeka núnisrumek atumsha jakattarme.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ju̱nasha Jesus métek-taku chichaman tímiauyi. Jú̱iti: Shuar ni ajari̱in íikiu numin araamun takakuyi. Nerekchiash tusa iyumai. Túrasha nere atsumai. ");
INSERT INTO jivNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nuiṉkia ni ajari̱n wáinniun timiai “Antukta, menaintiú uwitin ju̱na nere átai tusan waketrú pujajai; túrasha peṉké wáinkiachjai. Ajakta. ¿Urukamtai ántrash wajastata?” ");
INSERT INTO jivNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tutai ajá wáinin timiai “Atsá, uuntá; ju̱ uwitin wajastí. Wajamuri̱n takarsatjai tura péṉker nuṉkan matsatkatjai. ");
INSERT INTO jivNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nuja̱i̱ nerekchampiash. Tura tuke nereachkuiṉkia nuiṉkia ajakta” timiai”, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ayampratin tsawantai̱ Israer-shuar iruntai je̱a̱nam Jesus unuiniak pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nui̱sha nuwa̱ pujumiayi. Nu nuwa̱sha tiasiúchu uwitin tuke jaa pujumiayi. Íwianch nin yajauch awajas apuna tuke ikiaramiayi. Túramu asa paṉkái nakuenkataj tukamá peṉké tujinmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus nuna wáiniak, chicharuk “Nawantrú, ame jaamurmiya̱ ankant ajasume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nuna tinia ni uweje̱ja̱i̱ antiṉmiayi. Tura nú chichamaik nuwa̱sha paṉkái nakuenkamiayi. Tura Yusa náari̱n uunt awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tura Jesus ayampratin tsawantai̱ tsuaru asamtai, iruntai je̱a̱ uuntri̱ kajek iruntrarmia nuna tímiayi “Sais tsawantin takaschatniukait; ayampratin tsawantai̱ tsuámartaj tusarum táchatniuitrume. Sais tsawant ana nui̱ tátiniaitrume.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tura Jesus tímiayi, “¡Ántar chichamtinia! ¿atumi̱ waakari̱sha atumi̱ umpuururi̱sha yumi aartai tusarum ayampratin tsawantin atíarum júatsrumek? ");
INSERT INTO jivNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tura ju̱ nuwa̱sha, atumi̱ shuari̱ Apraám shuarnumia̱ akiiniaiti. Nii tiasiúchu uwí Satanás yajauch awajsamuja̱i̱ jinkiamuyayi. Nincha ayampratin tsawant aiṉ yajauch awajsamunmaya̱ atíachminkiait” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesus nuna takui ni nemasri̱sha natsa̱a̱rarmiayi. Tura peṉké shuar ni péṉker túramuri̱n wáinkiar warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nuyá Jesus tímiayi “¿Yusa akupeamuri̱ wariji̱a̱i̱n métek-takuit? ");
INSERT INTO jivNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mustasa jinkiáiji̱a̱i̱ métek-takuiti. Mustasa jinkiaincha shuar ni ajari̱i̱n araamiayi. Tsapái, tsakaak, uunt numi ajasmiayi. Ti uunt asamtai chiṉki ni kanawe̱n pasuṉmarmiayi.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tura ju̱nasha tímiayi: “¿Yusa akupeamuri̱ wariji̱a̱i̱ṉ métek-takuit? ");
INSERT INTO jivNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tanta wakaprutaia métek-takuiti. Arinia núkap ana nui̱ nuwa̱ wakaprutain ishichik eṉkeámiayi. Túram ashí wakapruamiayi.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerusaréṉnum jeattsa weak untsurí peprunam wayá unuiniarkutak wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wea̱i̱ chíkich shuar aniasmiayi “Uuntá, ¿uwemainia nu ishichkikiait?” ");
INSERT INTO jivNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tutai Jesus tímiayi “Yupikiach wáitiniam waya̱taj tusam ti wakeritiarum. Kame untsurí̱ waya̱taj tusar wakeriartatui, túrasha tujinkiartatui, tájarme. ");
INSERT INTO jivNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Je̱á nérenniuri̱ wáitin epenmiatai, atumsha a̱a̱ wajarum nu, wáitiniam wajasrum untsúakrum “Uuntá, uratritia” títiatrume. Túrasha “Nékatsjarme. ¿Tuya̱ntskaitrum?” turamtatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nuyá átum títiatrume “Túrasha, uuntá, iisha ámiji̱a̱i̱ yurumámji, ámiji̱a̱i̱ umarmaji. Tura ii pépruri̱ncha unuiniamame.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Túrasha nii títiatui “Tuya̱ntskaitrum, nékatsjarme, tátsujrumek. Yajauch túrintirmeka winiyaṉka kanaktiarum.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Nuyá Apraámsha, Isaksha, Jakupsha tura ashí Yúsnan etserin Yus akupeana nui̱ waya̱waru wáinkiarum tura a̱a̱ ajapam pujusrum ti úutkuram naim tásarara ajattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tura Yus akupeana nui̱, nantu tatainmaaniya̱sha nantu akaatainmaaniya̱sha, arakia̱sha, nuṉkaania̱sha taar, imia Israer-shuarchaitiat yurumátai tusar pujusartatui. Tura atumsha, “Apraám shuáraitjai” táyatrum, waya̱shtatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nui̱sha yamái ukunmaani ainia nusha emka ártatui; tura yamái emka ainia nusha nui̱sha ukunmaani̱ ártatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nu tsawantai̱ Pariséu aents Jesusan tariar tiarmiayi “Erutis mantamattsa wakerutmawai. Tuma asamtai ju̱ya̱ṉka wetá.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tutai Jesus tímiayi “Werum nu kujancham ju̱ titiarum: “Íistá. Yamaisha ishichik tsawant iwianchin jí̱i̱kin akupkartajai; túran jaancha tsuárartajai. Tura ukunam amuktatjai.” ");
INSERT INTO jivNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tura Jerusaréṉnumaani̱ ishichik tsawant tuke wétiniaitjai. Yúsnan etserin aya Jerusaréṉnumaṉ jákatniuiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘¡Jerusaréṉnumia̱tiram, Yúsnan etserin máiniaitrume; tura Yus akatar akupturmakmania nusha kayaja̱i̱ tukurum máiniaitrume! Tuma a̱i̱ṉ atash ni shiampri̱n etektana núnisnak Wisha weaktasan wakerimjiarme, túrasha nakitramarme. ");
INSERT INTO jivNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iistarum. Atumniasha Yus ajapramaitrume. Tura “Yusa náari̱i̱n winiana nu, shiir atí” títiatrumna nú tsawant jeatsa̱i̱ṉ peṉké wáitkiashtatrume. Nuna tájarme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ayampratin tsawantai̱ Pariséu uuntri̱ je̱e̱n Jesus yurumáttsa wémiayi. Tura chíkich Pariséu wariniak túrat tusar ii pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nui̱ áishmaṉ eaak-jaa Jesus pujamunam naka pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jintinniuncha Pariséuncha Jesus aniasmiayi “¿Warí tárum? ¿Ayampratin tsawantai̱ jaa tsuárminkiait. Tsuárchamniakait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tura niisha áimtsuk pujuarmiayi. Nuiṉkia jaan antiṉ tsuármiayi. Tura “shiir wetá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nuyá Pariséun chicharuk, “Atumí umpuurari̱sha, waakari̱sha wa̱a̱ táurmanum akaiki iniamtai, ayampratin tsawant aiṉ nu chichamaik júatsrumek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Takui áimkiatniun peṉké tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ipiaamusha peṉkeri̱ pujutainium pujustaitsar ti wakeruiniakui, Jesus nuna wáiniak ju̱na jintintramiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nuátnaikiatin nampernum peṉkeri̱ pujutainium pujusaip. Nui̱ pujakminkia, chíkich ámiji̱a̱i̱ naṉkaamas peṉkéri̱ táchatpiash.’ ");
INSERT INTO jivNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‘Tura ipiatmania nu chichartamuk “Chikich iiktusta” turamchatpiash. Nui̱ṉkia chíkich náṉkatkamu pujutainium wéakum natsa̱rtatme. ");
INSERT INTO jivNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Antsu ipiatmakmin, náṉkatkamu pujutainium pujustá. Nuiṉkia ipiatmamnia nu chichartamuk “Amikru, ámeka ju̱i̱ peṉkeri̱ pujutainium pujustá” turamtatui. Nuja̱i̱ chíkich ipiaamu ainia nu, “nekas peṉkerinti” turamartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iimiata, “peṉkerintjai” tu enentáimtuma nuka péejchach awajnastatui. Tura ímianchach enentáimtúmana nuka waantu ajastiniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nuyá Nin ipiaamua nuna chicharuk tímiayi “Amesha yurumáití tusam untsuktajtsam wakerakmeka, ame amikrumsha, yatsumsha, ame shuarumsha, írutramuram kuítrintin ainia nusha ipiaawaip. Nii ipiaamka, ataksha íksaṉ ámin ipiatmashtatuak. Nuja̱i̱ akikma átatme. ");
INSERT INTO jivNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Antsu yurumáití tusam untsuktajtsam wakerakmeka, kuítrincha, wekaicha, shutuapsha, kusurusha ipiaawarta. ");
INSERT INTO jivNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Niisha akirmaktinian tujintiainiawai. Péṉker shuar nantakiartatna nui̱ akinkiattame. Nu tuma asamtai warastatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nu misanam pujuarmia nuya̱, chikichik Jesus chichaamun antuk, Jesusan tímiayi “Yus akupeamunam pachiiniak, yurumkuṉka ti shiir ainti.” ");
INSERT INTO jivNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nuna takui Jesus ju̱na jintintiamiayi: “Áishmaṉ namperan nájanuk, untsurí̱ shuaran taartí tusa akatar akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yurumátin jeamtai “Winitiarum, yurumátin jeayi” tu tiarta tusa ni takarniuri̱n akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tura winichminiaitji tusar ashí ujakarmai. Chíkich timiai “Nuṉkan yamái sumarmakjai. Iyutaj tusa wéakun winishtatjai. Tsaṉkurturti” timiai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tura chíkich chichaak “Wisha tias waakan sumarmakjai. Nekapsatsan wakerajai. Tuma asan winishtatjai. Tsaṉkurturti” timiai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tura chíkich chichaak “Yamái nuatnaikiajai. Tuma asan winishtatjai” timiai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Takarin waketki ni úuntri̱n ashí nuna ujakmai. Nuna antuk niisha kajekmiayi. Tura ni takarniuri̱n timiai “Ju̱ péprunam péṉker jintianmasha tura uchich jintiachinmasha weme, kuítrincha tura wekaichasha, shutuapsha, kusurusha itiaarta.” ");
INSERT INTO jivNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nuyá ukunam ni takarniuri̱ taa chicharuk “Uuntá, ame turutmiamna nútiksanak túramjai; túrasha tuke aṉkant awai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Tutai ni uuntri̱ chichaak “Jintianam weme, chíkich jintiachiniam weme, wáinmena nu ashí awaya̱warta. Winia jearui̱ piakat tusan wakerajai. ");
INSERT INTO jivNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Emka ipiaawarmajnia nuka peṉké chikichkíksha winiṉkia yurumáchartatui, tajarme’ tímiayi.” ");
INSERT INTO jivNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Untsurí̱ aents Jesusja̱i̱ irunki wearmiayi. Niisha nuna apaja̱s iis ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Shuar ni aparí̱ncha, ni nukurí̱ncha, nua̱rí̱ncha uchirí̱ncha, yachi̱ncha, umai̱ncha Wiji̱a̱i̱ naṉkaamas enentáimtakka, tura shiir pujustinian wakerak Winí winitniun nakitiakka winia unuiniamur ajaschamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ni wakeramuri̱n ajakeak ni krusri̱ yanaki̱ nemartatsna nu winia unuiniamur ajaschamniaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‘Je̱a̱ yakí jeamtaj tusam wakerakmeka, kuítian urutmak ajapawaintiaj tusam tura urutmaja̱i̱ṉkⁱ amukaintiaj tusam emka enentáimsashtatmek. ");
INSERT INTO jivNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Túrutsuk aya ukura iniaisam amuktin tujinkiakmiṉkia, nuna wáiniainia nu, wishikiainiak ju̱na tiartatui: ");
INSERT INTO jivNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Iiskua. Nu shuar jeamtinian naṉkamamiayi. Túrasha amuktinian tujinkiamiayi.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Tura uunt kapitián chíkich kapitiánja̱i̱ mesetan najanatin áchatpiash. Emka, niisha pujus, tias mir (10.000) suntarja̱i̱ painti mir (20.000) suntar winiana nuna nupetkaintjash tusa enentáimsashtatuak. ");
INSERT INTO jivNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tujintiakka, chíkich kapitián jeachat pujaanak, nawamnaikiatai tusa akatar akupkashtatuak. ");
INSERT INTO jivNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wats, “Kristu unuiniamuri̱ ajastinja̱i̱, wi takakjana ju̱na warí winia itiurtawa” tu enentáimsatniuitrume. Túrachkurmeka winia unuiniamur ajastin tujinkiarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Weeka jeaku péṉkeraiti. Tura michumarka ¿itiurak atak péṉker ati? ");
INSERT INTO jivNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wee michumarka araakmatniunmasha yaya̱a̱tsui. Tura tsuatnum ikiusmasha ántraiti. Aya ajapatniukete. Kuishim ákuiṉkia antuktarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Akupniu kuítri̱n-juu tura yajauch shuarsha Jesusan anturkatai tusar tarú wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tuma asamtai Pariséusha, Israer-shuara jintinniuri̱sha Jesusan áujmatainiak “Ju̱sha tunáa shuaran itiaawai tura niiji̱a̱i̱ yurumáiniawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nuna tuiniakui Jesus ju̱ métek-taku chichaman jintintiawarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Shuar siaṉ (100) murikiun takuschampiash. Nu siánnumia̱ chikichik meṉkakamtai nuwintia nuíwinkia ni matsatmari̱i̱n ikiuak, meṉkaka nuna ti e̱a̱kchattawak. Wáintsuk iniaisashtatui. ");
INSERT INTO jivNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tura wáiniak yakainium awaṉkek waras je̱e̱n wáketui. ");
INSERT INTO jivNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tura je̱e̱n jeá ni amikri̱n, írutramuri̱ncha ikiaanak “Wiji̱a̱i̱ warastarum. Murikiur meṉkaka nuna wáinkiajai” tawai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wats, nuwintia nuiwi péṉker shuar akui nayaimpiniam warastin awai. Tura antsu chikichík yajauch shuar ni enentái̱n yapaji̱ámtaiṉkia, nú naṉkaamas warastin átatui, tájarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘Nuyá chíkich enentáimsatai. Nuwa̱ tias kuítian takakna nuna chikichik meṉkakamtai, wáinkiataj tusa jinia ekeemak, je̱a̱n japimiak émamkes e̱a̱kchattawak. ");
INSERT INTO jivNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tura wáiniak ni amikri̱n, írutramuri̱ncha ikiaanak, “Wiji̱a̱i̱ warastarum. Kuit meṉkakamia nuna wáinkiajai” tawai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Núnisaṉ yajauch shuar ni enentái̱n yapaji̱ámtai, Yusa suntari̱ matsatmanum ti warastin awai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nuyá Jesus ju̱na unuiniamiayi: “Áishmaṉ jimiará uchin takakuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tura pátatka uchi ni aparí̱n timiai “Apawá, surustiniaitmena nu yamái surusta.” ‘Tutai ni aparí̱ ni kuítri̱n jímiapetek nakak mai uchin susamai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ishichik tsawant naṉkaamasa̱i̱ pátatka uchi ni wariri̱n irur jukí jeachat chíkich núṉkanam wémai. Nui̱sha náṉkamas yajauchin túrak kuítri̱n ashí ajapamai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ni kuitri̱ ashí amuuka ai̱ṉ nu nuṉkanam ti tsuka ámai. Niisha núnisaṉ tsukari̱i̱n wáitsamai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Túmak takatan e̱a̱ktajtsa nu nuṉkanmaya̱ apachi̱i̱n werimiai. Nu áishmaṉsha kuchiri̱n wáitrukta tusa akupkamai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uchi ti tsukamak kuchi ukatramun niisha yuátajtsa ti wakerimiai. Túrasha peṉké súcharmai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tumáa pujus nuiṉkia enentáimpramai. “Winia aparuí̱ takau shuar péṉkeran ti yurumáiniawai. Tura wikia ju̱i̱ tsukarui̱ wáitiajai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wats, aparuí̱ waketkitjai. Tura aparun chicharkun “Apawá Yúsja̱i̱sha ámiji̱a̱i̱sha tunaan túrajai, titiajai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ame uchiram áchamniaitjai yamaikia. Ame takarniurmea áantsanak átaj tusan wakerajai” titiajai” tu enentáimsamai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tura wajaki ni apari̱i̱n waketkimiai’ tímiayi. ‘Tura ni aparí̱sha jeachat winian wáiniak waitnentramai. Aparí̱ tsékeṉki iṉkiuṉ miniakak mukunámai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nuiṉkia uchirí̱sha timiai “Apawá, Yúsja̱i̱sha ámiji̱a̱i̱sha tunáan túrajai. Ame uchiram áchamniaitjai.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Túrasha ni aparí̱nkia ni takarniuri̱n chicharuk “Ti peṉker pushí itiarum áentsratarum, timiai. Tura uwejnum aweetaisha aweemtikiatarum. Tura sapatcha aweemtikiatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Túrarum waaka nueram ana nu maatarum. Námper nájankur shiir enentáimsar yurumámi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Warí, ju̱ winia uchir jakaapitia tu enentáimsamjai. Túrasha iwiaakui. Meṉkakama nuna wáinkiajai.” Nuiṉkia ti warasarmai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Tumai̱ iwiái̱ úchikia takatnum pujumai. Tura wáketuk, je̱á nuntumas jantsemáiniak túntuiyamun antukmai. ");
INSERT INTO jivNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nuiṉkia yaintri̱ matsatun chikichkiniak untsuk “¿Warimpait?” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Tura nii chichaak “Ame yátsum tayi. Túramtai ame apa waaka nueram maatai tawai, ame yatsum péṉker tau asamtai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‘Tura iwia̱i̱ uchi kajek waya̱tniun nakitramai.’ ‘Tuma asamtai ni aparí̱ jiintiuki “waya̱ta” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","‘Tura uchisha aparí̱n chicharuk “Wisha ámin umirkun untsurí̱ uwitin ame takatrumin túraitjai. Nu nékame. Túrasha winia amikruja̱i̱ námper najanatin chiipiuksha peṉké surichuitme. ");
INSERT INTO jivNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tura ju̱ ame uchiram nuwa̱ja̱i̱ yajauchin túrak ame kuítrumin wasurkania nu támatai, waaka nueram máachumek” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Takui aparí̱ chicharuk “Uchirú, ámeka wiji̱a̱i̱ tuke pujame. Tura wi takakjana nusha ashí áminuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tura ame yatsum jákaiti tu enentáimsamiaj nu iwiaakuiti. Meṉkaka nu yamaikia wáinkiaji. Tuma asamtai námper najanar waraschatniukaitiajⁱ” timiai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ju̱ métek-taku chichamnasha Jesus ni unuiniamu7 ‘Tura nii chichaak “Ame yátsri̱n unuiniamiayi. “Kuítrintin áishmaṉka takatri̱n wáinniuri̱ ámai. Tura nérenniun ujainiak “Ame wáinniuram ame kuítrumin náṉkamas ajapeawai” tiarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","‘Nuna antuk ni wáinniuri̱n untsuk “¿Warinia ju̱sha turamainia? timiai. Yamaikia winia wáinniur áchattame. Tuma asamtai winia kuítruja̱i̱ itiurkamea nu iniaktursata” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‘Tutai takatan wáinin enentáimsamai. “Maaj, wisha itiurkatjak, timiai. Nuṉka táurtinniasha jeatsjai. “Kuit surusta” títinniasha natsa̱majai. ");
INSERT INTO jivNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Winia takatur atsakui yurumkan ajamprusarat tusan túratajna nuna nekajai” tu enentáimsamai. ");
INSERT INTO jivNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nuyá nérenniun tumashmaku armia nuna aṉkant aṉkant untsukarmai. Emka tamia nuna chicharuk “¿Winia úuntur urutma tumashmakuitiam?” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Niisha áimiuk “Asuitin siaṉ taru tumashiitjai” timiai.’ ‘Tutai takata wáinin chicharuk “Pai. Papinium tumashrum ana nu ju̱á: wárikmasmek pujusam, nu papí ja̱a̱kam, chíkich papinium aya seṉkuentachik aarta” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‘Nuyá chíkich tumashmaku támatai “¿Amesha urutmá tumashiitiam?” timiai.’ ‘Tutai nii chichaak “Shana siaṉ taru tumashiitjai” timiai.’ ‘Tutai “Pai. Papinium tumashrum ana nu jú̱iti. Chíkich papinium aya uchentak aarta” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","‘Nuyá takata wáinniu uuntri̱ nuna nekáa “Nii yajauch túriniaitiat imiá enentáimniuiti” timiai’ tímiayi. Nuyá Jesus tímiayi ‘Yus-shuarja̱i̱ naṉkaamas Yus-shuarcha ai̱ji̱a̱i̱ ni túratniuriniak takainiak imiá enentáimkia áiniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‘Ju̱ nuṉkanam anaṉkatin átsuk. Tura kuitsha aya ju̱ nuṉkanmaya̱ṉkete. Tuma asamtai atumsha kuitrumja̱i̱ “shuaran yaiṉtaj” tu enentáimsatarum. Kuitja̱i̱ yaiṉtin amuukamtai atumsha amuicha je̱a̱nam ipiaamu átaj tusarum túratarum.” ");
INSERT INTO jivNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Shuar ishichik takakna nuja̱i̱ péṉker túrakka, núkap takakna nuja̱i̱sha péṉker túrattawai. Tura ishichik takakna nuja̱i̱ péṉker túrachkuṉka, núkap takakna nuja̱i̱sha péṉker túrashtatui. ");
INSERT INTO jivNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tuma asamtai ju̱ nuṉkanmaya̱ anaṉkartin kuitja̱i̱ péṉker túrachkurmeka, tuke átin ana nuja̱i̱ takastincha ¿itiur takastarumek? ");
INSERT INTO jivNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Takakme nuna Yus ikiatmasuiti. Nuja̱i̱ péṉker túrachkurminkia, atumnia átinia nuna ¿itiurak suramsatⁱ?’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Takarniuri̱ jimiará úuntrintin ajastinian tujintiawai. Warí, chikichnaka aneak chikichnaka nakitrashta túrattawai. Turya seṉkuentachik aarta” timiaituak. Chikichan umiruk chikichnaka umirkashtatui. Yussha kuitcha mái-metek enentáimtuschamniaitrume” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pariséusha kuítian anen armia nu, ashí ni táman antukar Jesusan wishikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Túmakui Jesus nin tímiayi “Atumsha aents íimmianum péṉker awajmamprume. Túrasha atumí enentái̱ncha Yus péṉker nékawai. Kame winia “naṉkaamantuiti” turutit tusa wakera nuna Yuska nakitiawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Juaṉ étsertsai̱ṉ Muisáis aar akupkamia nunasha tura Yúsnan etserin unuiniarmia nunasha antuktin ármiayi. Tura yamaisha tímianiai̱ ti shiir chicham awai. Yus akupeana nui̱ urukukit nuka paant etserkamuiti. Tura ashí shuar nui̱ pachiinkiataj tusar ni kakarmari̱ji̱a̱i̱ṉ ti takainiawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","‘Túrasha yaunchu akupkamu ashí chicham uminkiatniuiti. Nu chicham uminkiashtinkia nayaimpisha nuṉkasha amukatniuja̱i̱ naṉkaamas itiurchataiti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Áishmaṉ nua̱ri̱n ajapa chikichan nuátkuṉka tsanirmawai. Tura nuwa̱ ajapamu niiniurtakka nusha núnisaṉ tsanirmawai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","‘Áishmaṉ kuítrintin ámai. Niisha imiá shiir pushin ti kuit ainia nuja̱i̱ iwiarmamniuyi. Tura tuke tsawant yurumak ti kuit amia nuja̱i̱ namperan najanniuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tura kuítrincha ámai ni naari̱ Rásaru. Niisha kuchapruku tunamaruyi. Tuke tsawant kuítrinniu wáitiri̱i̱n pujuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti tsukamak kuítrinniu misarinia̱ kakekan yuattsa wakerimiai. Tura yawa̱sha ni kuchapri̱n nukatiarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kuítrincha jakamai. Jakamtai jaka shiir pujutainium, Apraám pujumia nui̱ nayaimpinmaya̱ suntar júkiarmai. Kuítrinniusha jakamai. Jakamtai iwiarsarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jaka pujutainium wáitias pujus, paṉkái íimias, Rásarun Apraámja̱i̱ pujuinian wáinkiamai. ");
INSERT INTO jivNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wáiniak untsumuk “Apawá Apraamá wáitnentrurta, timiai. Rásaruka tsara uweje̱ja̱i̱ entsan uchupir winia iniairun imichturat akupturkata. Wisha ju̱i̱ jinium pujusan ti waitiajai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Tutai Apraám timiai “Uchirú enentáimpratá. Ame nuṉká iwiaaku pujusam ti shiir pujumame. Antsu Rásaruka nui̱ ti yajauch pujumai. Tura niisha yamaikia ju̱i̱ áyamui tura ámeka wáitiame. ");
INSERT INTO jivNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tura nú arant nánata ti uunt awai. Tuma asamtai ju̱yá ai̱ wétinian wakeruiniayat tujintiainiawai. Tura ai̱ya̱ ju̱i̱ tátinian wakeruinia nusha tujintiainiawai.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘Nuiṉkia kuítrintin timiai “Nuiṉkia apawá Apraamá, ju̱na seajme. Winia aparu je̱e̱n Rasaru akupturkata. ");
INSERT INTO jivNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nui̱sha winia yatsur seṉku matsatainiawai. Niisha ju̱ wáitsatniunam tácharat tusa ujákartí, tájame” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‘Tutai Apraám timiai “Muisáis áarman tura Yúsnan etserin áarman takakainiawai. Nuna umikiarti.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Tutai kuítrintin áimkiamai “Túrasha apawa Apraamá, antsu jakamunmaya̱ nantaki, shuar we ujakam enentái̱n yapaji̱áwarainti.”’ ");
INSERT INTO jivNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Tura Apraám timiai “Muisáis áarman tura Yúsnan etserin áarman anturainiachkuṉka jaka nantaki we ujakmasha antukchartatui” timiai.” Tu áujmatsamiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus ni unuiniamuri̱n ju̱na tímiayi, “Aentsun yajauchin túrumtikiattana nu tuke átatui. Tura shuar ni a̱i̱n tunaan wakerumtikna nu aneartí. ");
INSERT INTO jivNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ju̱ shuar uchich ainia nuna yajauchinium túrumtikna nuna Yus imiá asutiáttawai. Tuma asamtai nuna túratsa̱i̱ṉ uunt kayaja̱i̱ kuntujnum jiṉkiá nayaantsanam ajunkam maak ainti. ");
INSERT INTO jivNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Túrasha atumek íimiastarum. Ame yatsum ámin tunáa túrutmamtaiṉkia chicharkata; tura niisha “tsaṉkurturta” túramkuiṉkia tsaṉkurata. ");
INSERT INTO jivNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chikichík tsawantiniṉ siati túrutmamtai, tura “tsaṉkurturta, atakka túrashtatjai,” siati túramkuiṉkia, tuke tsaṉkurata.” ");
INSERT INTO jivNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesusa unuiniamuri̱ Nin chicharuk “Yus enentáimtajnia nú naṉkaamas enentáimtustin yáinmaktá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tutai Jesus tímiayi “Mustasa jinkiái ti ishitiúpchich ana núnisaṉ ishichkisha Yus enentáimtaitkiurmeka, sikiumuru numi wajana nu, “Wajamurmi̱yaṉka ukuiniakam nayaantsanam wajasta” tákurmin nú numi umirtamkainti.’ ");
INSERT INTO jivNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Atumí takarniuri̱ arakmasua amik, waakancha iis támatai, ¿nú chichamaik amesha, “Winitiá, yurumáitiá” tíintmek? ");
INSERT INTO jivNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Atsá. Antsu, “yurumak iwiarturata. Wi yurumátin tura umartincha surusminiam iwiarnarta. Nuyá ame yurumátá.” Nu tíchaintmek. ");
INSERT INTO jivNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nii túratin ana nunak túratsuk. Tuma asamtai yumiṉsashtatme. ");
INSERT INTO jivNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Atumsha núnisrumek Yus túramna nu ashí umikiam “ti peṉker túraitjai” tíchatniuitme. Antsu “aya ii túratniuri̱ ana nuke tura asar iikia ántraitji” títiniaitme.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus Jerusaréṉnum wesa Kariréa nuṉka ikiuki Samaria nuṉkanam naṉkaamakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tura péprunam jeamtai, tias áishmaṉ ripra suṉkurja̱i̱ tunamaru armia nu, arant wajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tura untsumainiak “Uunt Jesusá, waitnentrurta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus nin wáiniak, “Pátrii̱ werirum iniaktumastarum” tímiayi. Tura wésar péṉker ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nuyá chikichik ni tsuamarman nekáa kakantar chichaki Yusa náari̱n uunt awajki waketki Jesusan tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yumiṉsataj tusa Jesusan tikishmatar piniakumar tepesmiayi. Nu áishmaṉka Samarianmaya̱uyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nuna wáiniak Jesus tímiayi “Tsuámaru tiáschakait. ¿Chíkich nuiwisha tui pujuinia? ");
INSERT INTO jivNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ju̱ yajaya̱ áishmaṉ níṉkik Yusa naari̱ uunt awajsataj tusa waketki tai?” ");
INSERT INTO jivNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nuyá áishmaṉkan tímiayi, “Winia nekas enentáimtursa asam péṉker ajasume. Wajakim shiir weta” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pariséu aents Jesusan aníak “¿Yusa akupeamuri̱ urutaik ati?” tiarmiayi. Tutai Jesus tímiayi, “Yusa akupeamuri̱ paant wáinkiachminiaiti. “Yamaí naṉkamnayi” tichamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Ju̱i̱ awai, nui̱sha awai” tíchamniaiti. Warí, Yusa akupeamuri̱nkia atumi̱i̱n pujawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nuyá ni unuiniamuri̱n chicharuk ju̱na tímiayi: “Tsawant jeattawai atumsha Winia Aents Ajasu tutain “aya chikichík tsawantkesha Nii wáinkiarkia mak” turuttiatrume. Túrasha tujinkiattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aents Ajasu tutai “ju̱i̱ pujawai, nui̱sha pujawai” tuíniakui weriirap. Tana nu nemariirap. ");
INSERT INTO jivNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wi, Aents Ajasuitjiana nu tátinian tsawantur jeamtai paant wáitkiattarme. Peem péetuk ashí nayaimpin tsáapnin awajna núnisaṉ wi taamu paant átatui. ");
INSERT INTO jivNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tura nu túruntsa̱i̱ṉ yamai pujuinia nu Winia nakitruiniakui ti wáitsatniuitjai. ");
INSERT INTO jivNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Winia atak tátiniur jeamtai, yaunchu Nuái pujumia nú tsawantin túrunamia núnisaṉ túrunattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yurumáwarmiayi, umararmiayi, nuatnaikiarmiayi, ni nawantri̱ nuatnakat tusa surukarmiayi. Tumáa pujuinia̱i̱ Nuái uunt kanunam eṉkempramtai, amaarak nu aentsnasha mash amuukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tura Sutuma péprunmasha Rauta írutramuri̱sha núnisaraṉ Yusa asutiátniuri̱ enentáimtutsuk pujuarmiayi. Yurumáwarmiayi, umararmiayi, sumakarmiayi, surukarmiayi, ajancha ajamarmiayi, je̱a̱ncha jeammarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tura Raut Sutuma péprunmaya̱ jiinkimtai asupri tutai kaya keek yútana áintsaṉ nayaimpinmaya̱ kakeetuk nu áentsun mash máawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Núnisaṉ winia atak tátiniur jeamtai enentáimtsuk pujusartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Nu tsawant jeamtai je̱a̱ yakiini̱ pujana nú shuar ni wariri̱n achiktaj tusa akaikishti. Je̱á waya̱shti. Tura kampunniunam wekaana nú shuar ni je̱e̱n waketkishti. ");
INSERT INTO jivNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rauta nua̱rí̱ túrunamu enentáimpratarum. ");
INSERT INTO jivNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aya ju̱ nuṉkanmaya̱ṉ enentáimias “iwiaaku átaj” tana nu ni iwiaakmari̱n emeṉkáktatui. Tura ju̱ nuṉkanam ni iwiaakmari̱n emeṉkana nu nekas iwiaakma ana nuna wáinkiáttawai. ");
INSERT INTO jivNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Paant tájarme. Nú káshitin jimiará áishmaṉ nuu peaknumaṉ kanúu tepeartatui. Chikichik junaktiatui, chíkichkia ikiunkittiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jimiará nuwa̱ mái-metek nekée pujuartatui. Chikichik junaktiatui, chíkichkia ikiunkittiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jimiará áishmaṉ kampuniunam wekainiartatui. Chikichik junaktiatui, chíkichkia ikiunkittiawai.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nuna antukar “Uunta ¿tui̱ túrunatta?” tiarmiayi. Tutai ni chichaak “Jaka tepana nui̱ chuaṉ káutkartatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Shuar yawe̱tsuk Yúsan tuke áujsatniua nuna unuiniartaj tusa Jesus ju̱ métek-taku chichaman tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Chíkich péprunam shuaran akupin amai. Nú áishmaṉ Yúsnasha ashamchauyi; shuárnasha péṉker enentáimtichuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tura nú péprunam waje̱ amai. Niisha shuáran akupniun chicharuk “Áishmaṉ winia yajauch awajtusmania nu íirtusta” tusa tuke waketrú pujuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yámankamtaikkia nin anturkatniun nakitmiai. Tura ukunam enentáimias “Wisha Yúsan ashamachiatnak shuárnasha péṉker enentáimtichuitiatnak ju̱ waje̱ tana nuna túrattajai. ");
INSERT INTO jivNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Warí niisha tuke taa itit awajtatsuk. Tuma asamtai nin kajerka̱i̱j tusan wárik túrattajai” timiai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nuyá uunt Jesus tímiayi “Shuaran akupin yajauchiitiat nuna timiai. ");
INSERT INTO jivNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tura Yus ti péṉker asa, ni achikmarin tsawai̱sha, káshisha untsuamka nú naṉkaamas anturkashtatuak. ¿Ya̱i̱tsuk meṉkakatuak? ");
INSERT INTO jivNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Atsá, wárik yáinkiartatui, tájarme. Tura Wi Aents Ajasuitjiana ju̱ atak támatai, ¿shuaran tuke Winia nekas enentáimturainia nuna wáinkiatjash?” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","“Péṉkeraitjai” tu enentáimtumainiak chikichnaka yajauch enentáimtiarmia nuna Jesus nekapmá chichasmiayi. Ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Jimiará áishmaṉ Yusa Uunt Je̱e̱n Yus áujsatai tusar wearmai. Chíkichkia Pariséuuyi, chíkichkia kuítian-juuyi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pariséusha wajaki Yúsan áujuk jú̱nis tímiayi: “Yusrú, chíkich áishmaṉ kasa, yajauch, tsanirmau ainia nuja̱i̱ métekcha asan yumiṉsajme. Tura ju̱ kuítian-juu wajana jú̱ja̱i̱sha métekchaitjai. ");
INSERT INTO jivNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Warí, Ame akupkamna nuna iniaṉkasan wisha chikichík semanatiniṉ jimiará tsawant ijiarman áujeajai; tura wi achiajna nuna tiásnumia̱ chikichkiniak Yúsnaiti tusan akankan súajai.” Tu tímiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","‘Tura kuítian-juusha arant wajas, nayaimpinmaani̱ pankái̱ íimsatniunkesha natsa̱a̱mak, tsuntsuma, ni netsepen awatí “Yusá, ti tunaitjai. Waitnéntrurtá” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","‘Wats tájarme, nu kuítian-juu shuar Yus íimmianum ni enentái̱ péṉker awajnas ni je̱e̱n waketkimiai. Tura Pariséuka tamia núnisaṉ waketkimiai. Nekaatarum. Shuar naṉkaamantu enentáimtumana nuka péejchach awajnastatui. Tura antsu péejchach enentáimtumana nu, naṉkaamantu awajnastatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesus antiṉkiarat tusar uchin itiariarmiayi. Tura Jesusa unuiniamuri̱sha nuna wáinkiar suritkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tura Jesus nin untsukar tímiayi “Uchi Winí winitin tsaṉkamkatarum, surimkiairap. Enentáimsatarum. Uchichia áintsaṉ enentáimtumana nú shuárak Yus ni enentáin akupin ajasminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Uchi ni úuntri̱n umira núnisaṉ shuar Yúsan umíachkunka Yus ni enentái̱n akupin ajaschamniaiti.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Shuara uuntri̱ Jesusan tarí áujsamiayi. “Uuntá, amesha péṉkeraitme. Tuma asam, turuttia, ¿warinia túrakna tuke iwiaaku átataj?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tutai Jesus, “¿Urukamtia Winia, péṉkeraitme, túrutam? Aents péṉkerka atsawai. Aya Yusak péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tura Yus akupkamu ana nu péṉker nékame. Tsanirmawairap, mankartuawairap, kasamkairap, tsanumprurairap, ame apasha, nukusha shiir enentáimtustarum. Nusha nékame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tutai áishmaṉ tímiayi “Uuntá, úchichik mash umiki tsakaruitjai.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus nuna antuk “Chikichik taatramsai, tímiayi. Ame takakmena nu ashí surukam kuítrincha ainia nu susarta. Nuiṉkia nayaimpiniam kuítrum átatui. Túram nemartustaj tusam winitia.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tura nuna antuk, nu áishmaṉ ti kuítrintin asa ti kuntuts enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tura kúntuts enentáimpramtai Jesus nuna nekáa “Kuítrintin ainia nu Yus akupeamunam pachiinkiatin ti iturchataiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamiriuka, uunt ana nu, auja ji̱i̱n waya̱tin itiurchataiti. Tura shuar kuítri̱n ti enentáimtana nu Yus akupeamunam pachiinkiatin nú naṉkaamas itiurchataiti.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tura nuna antukarmia nu tiarmiayi “¿Nuiṉkia yaki uwempramniait?” ");
INSERT INTO jivNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tutai Jesus tímiayi “Aents tujintiainia nuna Yuska páchitsuk túramniaiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nuyá Pítiur Nin chicharuk tímiayi “Uuntá, iikia Ámin nemarsataj tusar ii takakmaaka ikiukji.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Tutai Jesus tímiayi “Shuar Yus akupeana nuna túrataj tusa ni je̱e̱n ikiuakka tura núnisaṉ ni aparí̱ncha, nukurí̱ncha, yachi̱nkisha, nuwe̱nkesha, uchirí̱nkisha ikiuakka ju̱ nuṉkanmasha núkap wáinkiattawai nu shuar. Tura tuke iwiaaku pujustinniasha wáinkiattawai.” ");
INSERT INTO jivNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus ni tuse unuiniamuri̱n akanki ikiaanak ju̱na tímiayi: “Jerusaréṉnum jeatemaji. Ju̱i̱sha Jerusaréṉnum Winia, Aents Ajasu tutain, túrunatniurun Yúsnan etserin yaunchu áatrurarmia nu uminkiattawai. ");
INSERT INTO jivNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Apachnium surutkartatui. Túrawar wishikrurar, katsekrukar usukruawartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Awatiar mantuáwartatui. Túramaitiatnak menaintiú tsawa̱ntai̱ nantaktiatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tura Nii tímiania nuna nekas túrunattawai, tícharmiayi. Wariniak ta tusar nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus Jirikiú péprunam nuntumsai̱, nui̱ áishmaṉ ji̱i̱ kusuru, kuítian surusarat tusa jintiá pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Untsurí̱ aents naṉkaamainian antuk “¿wariṉkit?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tutai, “Nasarétnumia̱ Jesus naṉkaamawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kusurusha nuna antuk untsumuk “Jesusá, Uunt Kapitián Tawit weeachukaitiam. Tátiniuya núchakaitiam. Winiaja waitnentrurta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eemak wearmiania nu chicharainiak “takamatsata” tiarmiayi. Tutaisha nú arant untsumuk “Tawit weeachukaitiam; winiaja waitnentrurta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nuiṉkia Jesus wajas “itiatarum” tímiayi. Tura nii támatai, ");
INSERT INTO jivNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Warí itiurtukat tusamea wakerutam?” tímiayi. Tutai kusuru áimiuk “Uuntá, íimtiasan wakerajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tutai Jesus chichaak “Iimtia. Winia nekas enentáimtursa asam péṉker ajasume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nu chichamaik kusuru íimmiayi. Tura Yusa naari̱ uunt awajki Jesusan nemarmiayi. Tura ashí aents nuna wáinkiarmia nusha Yusa náari̱n uunt awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nuyá Jirikiú péprunam wayá nui̱ wekaikini ajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nui̱ kuítrintin áishmaṉ ni naari̱ Sakíu pujumiayi. Nu Sakíu kuítian-juu úuntri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aents ti káunkámtai, Sakíu ti sútarach asa, Jesusan íistaj tukamá tujinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tuma asa Jesus nuke naṉkaamaktin asamtai, eemki tsékiṉki sikiumuru numi wajamunam wakamiayi iistaj tusa. ");
INSERT INTO jivNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus nui̱ naṉkaamak paṉkái̱ íimias chicharuk “Sakíu wárik akáikitiá. Ame je̱e̱mi̱i̱n yamái kanartiniaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tutai Sakíusha wárik akaiki, shiir enentáimias Jesusan itiaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ashí aents nuna wáinkiar “Maaj, Jesus tunáa áishmaṉka je̱e̱n pujawai” tusa mai tunaim ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nuyá Sakíu wajaki Jesusan chicharuk “Íistá Uuntá, wi takakjana ju̱na jímiapetek nakakan kuítrincha ainia nuna susartatjai. Tura wáitruan chikichan kasarkaitkiuncha menaintiu patatsan awaiṉkittiajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tutai Jesus tímiayi “Ju̱ áishmaṉ Apraáma shuárintiat yamái niisha níiniuja̱i̱ uwempra asa nekas Apraáma shuari̱ ajasuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wisha Aents Ajasu asan meṉkakaru ainia nuna e̱a̱kan uwemtikrartaj tusan táwitjai.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nu aents Jesusan anturkarmia nu “Jerusaréṉnum jeawakrin Nii, Yus anaikiamu asa, wárik akupin ajastatui” tu enentáimsarmiayi. Tuma asamtai wésar Jerusaréṉnum nuntumsarai̱, nuna enentáimsarái̱ṉ tusa Jesus ju̱na métek-takun chichasmiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Áishmaṉ peṉkeri̱ amai. Nu áishmaṉsha jeachat chíkich núṉkanam kapitián náamkan tátaj tusa wemai. ");
INSERT INTO jivNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tura wétsuk ni takarniuri̱n tias armia nuna untsukarmai. Tura aṉkant aṉkant kuit kuriji̱a̱i̱ naṉkaamas péṉker armia nuna suíniak “Ju̱ kuitja̱i̱ wi táatsa̱i̱ṉ takakmá ajatarum” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","‘Tura ni nuṉké̱nia̱ shuarka nakitiarmai. Túmainiak “nu áishmaṉ ii kapitiántri̱ ajasa̱i̱ṉ tusar nakitiaji” nu titiá tusar áishmaṉkan akatrar akuptukarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‘Tuma ai̱ṉ kapitián náamak ni nuṉké̱n waketki tamai. Taa “winia kuítruja̱i̱ warí túrarum” títiaj tusa ni takarniuri̱n kuitia súsarmia nuna untsukarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‘Ni takarniuri̱ emka chikichik taa “ame kuítrumja̱i̱ takakmasan tias patasan achikmajai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Tutai kapitián chichaak “Péṉker túrame. Ishichik susamjamna núja̱i̱ṉkⁱ wi tímiajna tímiatrusmek túrame. Tuma asakmin tias péprun akupin awajsattajme” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Chíkich taa “Íistá Uuntá, ame kuítrumja̱i̱ takakmasan seṉku patasan achikjai” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Nunasha chicharuk “Amincha seṉku péprun akupin awajsattajme” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Nuyá chíkich taa “Uuntá, ame kuítrumin paniiji̱a̱i̱ ijian ikiusmajai. ");
INSERT INTO jivNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Amesha kakaram chichau asakmin, ikiuschiatam achin asakmin tura arakmachiatam juu asakmin ashamkamjame” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Tutai kapitián timiai “Maaj, amesha ti yajauchiitme. Ame támena nuke makurmawai. Wi kakaram chichau ai̱sha, ikiuschiatan achin ai̱sha tura araknasha arakmachiatan juu ai̱sha, ");
INSERT INTO jivNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","nuiṉkia ¿urukamtia kuit-ikiutainiam ikiuschamam? Nuiṉkia wi atak táakun patasan achikia̱a̱jna” timiai. ");
INSERT INTO jivNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tura nui̱ wajarmia nuna chicharuk “Kuítian takakmari̱ juruktiarum; túrarum tias takakna nú shuar susatarum” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Tura niisha chichainiak “túrasha Uuntá, tias takakja” tiarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Tutai kapitián chichaak “Takakna nuja̱i̱ takaakuiṉkia patatnastatui tájarme. Tura takakna nuja̱i̱ takaachkuiṉkia ishichik takakkuisha jurunkittiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tura winia nemasur kapitián ajasa̱i̱ṉ tusar nakitrurarmania nu itiatarum. Tura wisha íimiaiṉ máatárum” timiai.” Tu tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nuna tuasua amik Jesus Jerusaréṉnumaani̱ wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Petpajái pepru tura Petania péprusha Uriwiu náinnium tíjiuchiyi; nui̱ jeastatuk ajatemas ni unuiniamuri̱n jímiaran chicharuk, ");
INSERT INTO jivNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Tíjiu̱ch péprunam wetarum. Túrarum nui̱ umpuuruch ekemtukchamu jiṉkiamu wajá wáinkiattarme. Nu atíarum itiatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tura “¿urukamtai atíarum?” turamainiakuisha, “ii uuntri̱ wakerawai” títiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tutai unuiniamuri̱ wear, Jesus timia ímiatrusaṉ wáinkiarmiayi ");
INSERT INTO jivNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tura umpuuruchin atíakui nérentin chichainiak “¿Urukamtai umpuuruchsha atíarum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tutai unuiniamusha “Ii uuntri̱ wakerawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tura umpuuruchin Jesusan itiariarmiayi. Túrawar ni pushiri̱n umpuuruchiniam awantkar Jesusan ekenkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tura Jesus wétinnium ni pushiri̱n jintianam ayapa̱rar áintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tura Uriwiu naint awaṉkénamunam tíjiu̱ch ajasarmatai untsurí̱ aents Jesusan nemariarmia nu warainiak kakantar untsumainiak aents tujintiamun untsurí̱ túran wáinkiaru ásar Yusa náari̱n uunt awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Yusa náarí̱i̱n winiana ju̱ ii uunt Akupniuiti. Nincha Yus shiir awajsati. Nayaimpiniam pujuinia nu shiir enentáimsar Yusa náari̱n uunt awajsarti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tura Pariséu aents nui̱ páchitra pujuarmia nu Jesusan chicharainiak “Uuntá, nemartamainia nu “takamatsata” tiarta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tutai Jesus tímiayi “Nuiṉkia ju̱ takamatsarmataiṉkia, kayasha untsumkarainti. Nuna paant tájarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusaréṉnum tíjiu̱ch ajatemas péprun wáiniak úutuk jú̱nis tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Jerusaréṉnumia̱ shuártiram, ju̱ tsawantinkesha shiir pujustintrum nekaarmeka maak. Túrasha yamaikia nekaatin naṉkaamasai. ");
INSERT INTO jivNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kame ti itiurchat tsawant jeartamtatrume. Atumí nemasri̱ nuṉkaja̱i̱ aa-tanishan tanishmarar téntatramkattarme. Mesetan najatramattarme, tura áatusha ju̱nisha mash árenmaktatrume. ");
INSERT INTO jivNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Túrutma nuṉká ajuṉmartatrume. Tura atumi̱i̱n pujuinia nuna máawartatui. Tura ashí emesrarmatai ishichkisha kaya irumpramusha peṉké atsuttawai. Wi Yusa anaikiamuri̱n tarijrumna nu nekaachu asakrumin túrutmattarme.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nuyá Jesus Yusa Uunt Je̱e̱n wayá suruktasa pujuarmia nuna sumaktasa pujuarmia nunasha ji̱i̱ki awemarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Túrak ju̱na tímiayi: “Yús-Papinium yaunchu aarma awai: “Winia je̱a̱rka Yus áujsatin je̱a̱iti” tu áarmaiti. Túrasha átumka kasáa matsamtaiya nútikiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tuke tsawantin Yusa Uunt Je̱e̱n Jesus uwempratin chichaman unuiniak pujai̱ Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha, tura pepru úuntri̱sha, itiur máamniakit tusar ti enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Túrasha ashí aents émamkes anturainiakui máatniun tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yusa Uunt Je̱e̱n Jesus uwempratin chichaman unuiniak pujai̱ Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha, Israer-shuara úuntri̱sha táarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Taar Jesusan chicharainiak “¿Yana chichame̱ja̱i̱ ju̱ túram? ¿Ya ju̱ túratniuncha akuptamkait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tutai Jesus tímiayi “Wisha aniastajrum tusan wakerajrume. ");
INSERT INTO jivNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ya Juáṉnasha imiakrattia tusa akupkamia? ¿Yusak? ¿Aentsuk? Turuttiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tútaisha niisha nuamtak warintiajik mai tunai ajarmiayi. ““Yus akupkaiti” tákurniṉkia, “¿urukamtai enentáimtuscharum?” turamtatji. ");
INSERT INTO jivNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Túrasha “aents akupkaiti” tákurnisha ashí aents kayaja̱i̱ tukurmar mantamattaji. Warí “Juaṉ Yúsnan etserniuiti” tuíniatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nuiṉkia Jesusan áiniak “Iisha nékatsji, Juaṉ imiakratinniasha yátsuk akupkamia” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tutai Jesus tímiayi “Wisha núnisnak winia akuptukua nuna tíchattajrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nuyá Jesus ju̱ métek-taku chichamja̱i̱ aentsun jintintiamiayi: “Áishmaṉ ni ajari̱i̱n uwa araa amuk, shuaran takartusti tusa ikiukmiai. Tura niṉkia wau táchataj tusa jeachat wémai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tura júuktin tsawant jeamtai juukman akanak jurumkit tusa takarniuri̱n takau shuari̱i̱n akuptukmai. Tura takarniuri̱ncha katsumkar áyatik awaiṉkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nuyá nérentin chíkich takarniuri̱n akupkamai; tura nunasha núnisaṉ katsekkar, awatiar, sútsuk akupkarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nuyá ataksha chikichan akupkamai. Tura nunasha takau shuar katsumkar akupkarmai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Nuyá ukunam ajá nérenniuri̱ “Itiurkatjak, timiai. Winia aneamu uchirun akupkattajai. Nin wáinkiar shiir enentáimtuschartimpiash” timiai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‘Túrasha takau shuar nuna wáinkiar, nuamtak chichainiak “Ju̱ka ajá nérenniuri̱ ajastatui. Maatai. Nuikia aja iiniu átatui” tiarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nuna tuíniak ajanmaya̱ ji̱i̱ki máawarmai.’ Nuyá Jesus aniasmiayi ‘Wats ¿warí enentáimsarum, ajá nérenniuri̱ itiurkattawa? ");
INSERT INTO jivNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Niisha taa, nu takau shuáran máawartatui. Tura núṉkanka chikichan susattawai” tímiayi. Nuna anturkar “Yus núnaka tsaṉkatkashti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tura Jesus nin émamkes íisar tímiayi “¿Nuikia Yus-Papinium áarma nu warintiua? Ju̱ áarmaiti: Kayan péṉkernak je̱a̱ jeamin “yajauchiiti” tusar ajapawarmia nu ashí kayaja̱i̱ naṉkaamas péṉker apujsamuiti. ");
INSERT INTO jivNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nu kayan tukumainia nuka kupintrattawai. Tura nu kaya shuarnum iniarka nu shuaran tsai tsai awajsattawai. Tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Israer-patri uuntri̱ tura Israer-shuara jintinniuri̱sha “nu métek-taku chichamja̱i̱ in túramji” tu nekaawar nuikⁱ Jesusan achikiar emetatai tusar wakeriarmiayi. Tura untsurí̱ shuar Jesusan wakeruiniakui, ashamainiak túracharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tura Kapitiánnium suruktai tusar wakeruiniak mamikmau shuaran Jesusan akuptukarmiayi. Nu shuar péṉker shuara núnisaṉ jeariar, Jesus nékatsuk yajauch chichakat tusar, aniastaj tusar wearmiayi. Ni chichakmari̱ji̱a̱i̱ uuntnum suruktai tusar túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tu enentáimsar tíarmiayi “Uuntá, ame tuke nekas chicham chichaame, nu nékaji. Aents pátatek íiyatsme, antsu nekas Yusa jinti̱ jintintiame. ");
INSERT INTO jivNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wats turuttia, ¿Rúmanmaya̱ uunt akupin ii kuitri̱ akiktin péṉkerkait? ¿Akiktinkiait? ¿Suritkiatniukait? Nu nekaatai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tura Jesuska ni yajauch enentáimsamuri̱n nekáa chicharainiak, ");
INSERT INTO jivNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kuit itiatarum. ¿Yana yapi tura yana naari̱ ju̱i̱ áarmait?” tímiayi. Tutai nii tiarmiayi “uunt akupniunu.” ");
INSERT INTO jivNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tutai Jesus tímiayi “uunt akupniunu átinia nu uunt akupin susatarum. Tura Yusna átinia nu, Yus susatarum.” ");
INSERT INTO jivNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aents ántamunam ni chichakmari̱ji̱a̱i̱ achiktinian peṉké tujinkiarmiayi. Antsu aya íimprarmiayi tura takamtak pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nuyá Satuséu “jakamunmaya̱ peṉké nantakchamniaiti” tuinia nu, Jesusan aniastai tusar tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aniiniak tiarmiayi “Uuntá, Muisáis ju̱na áartampramiaji: “Áishmaṉ ni nua̱rí̱ júreatsa̱i̱ṉ jakamtaiṉkia ni yachi̱ nu waje̱n nuátkatí, yachi̱n yajutmatratsa.” Tu áarmaiti, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wats, siati yachi ármai, tiarmiayi. Iwiai̱ri nuwa̱n nuatak yajutmatsuk jakamai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni yachi̱ waje̱n akintiak, nuátak, niisha yajutmatsuk jakamai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nuna yachi̱sha núnisaṉ nu waje̱n nuátkamai; tura núnisaṉ ashí siati nuna patai̱ṉkⁱ nuátkarmai. Yajutmatsuk yajutmatsuk kajiṉkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tura ukunam nuwa̱sha jakamai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nantaktin tsawanta̱i̱, nantakiarmatai, ¿yana nua̱ri̱ṉ ati? Ashí siati nuátkacharmaka” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tutai Jesus tímiayi “Ju̱ nuṉkanmaṉ nuatnaikiatin awai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tura nantakiar atak iwiaaku ámin ainia nuka nuatnaikiachartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Warí, jákashtin áiniatsuk. Nayaimpinmaya̱ suntara áintsaṉ ajasartatui. Tura nantakiaru ásar Yusa uchiri̱ ajasartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tura jákaru nantakiartin ainia nuna imia Muisáis jintíamiayi. Warí, numichiniam ji wajái keamunan Yus niiji̱a̱i̱ chichaamun, Yus-Papinium Muisaiska áarmiayi. Nú áarmanum Uunt Yus Apraáma, Isaka tura Jakupu Yúsri̱nti, tímiayi. Nú áishmaṉ yaunchu jákaru aiṉ “ni Yúsri̱nti” tímiayi. Nuna taku nantaktin awai tu jintíamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kame jaka meṉkakatniunam pujuinia nuna Yúsri̱nchuiti. Tuma asamtai jakáa Yúsri̱nti tíchamniaiti. Antsu iwiaaku ainia nuna Yúsri̱nti. Ashi Niiniun iwiaarkainiawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nuna antukar Israer-shuara jintinniuri̱ “péṉker tame, Uuntá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tura nuyánka aniastinian arantukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nuyá Jesus tímiayi “Yus anaikiamu Kristu tutaisha, ¿itiura “Aya Tawit weeaiti” tárum? ");
INSERT INTO jivNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Warí, Sarmu papinium Tawit niṉki ju̱na tátsuk: “Uunt winia Úuntrun “Akupin pujutainium Winia untsuuruini̱ pujustá, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ame nemasrumin núpeteatsa̱i̱ṉ nui̱ pujustá” tímiayi.” Tú áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kame Tawitkia, Krístun chicharuk, “winia Úuntur” ta̱i̱sha, ¿itiurak Kristu tutai Tawitia pampaṉmarí̱ átiṉkⁱ?” Tú tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ashí aents Nin anturkatasa pujuiniai̱ ni unuiniamuri̱n Jesus ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Israer-shuaran jintintin ainia nuyá aneartarum. Niisha esaram pushin entsarar wekasataitsar wakeruiniawai. Tura jintiá ti shiir áujtusarat tusar wakeruiniawai; tura iruntai je̱a̱nam peṉkeri̱ pujutainium pujustinian wakeruiniawai. Tura nampernumsha uunt pujutainium pujustaj tusa wakeruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Túrasha wajé̱ je̱e̱ncha atantainiawai. Túrawar aents nekaracharat tusar ti esaram chichamja̱i̱ Yúsan áujainiawai. Nincha chíkichja̱i̱ naṉkaamas Yus asutiáwartatui.” ");
INSERT INTO jivNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yusa Uunt Je̱e̱n kuítrintin kuit enketainiam kuítian eṉkeenan Jesus wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tura waje̱ kuítri̱ncha jimiará uchich kuítian, reara áaniun, eṉkean wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wáiniak tímiayi “Nekas tájarme, ju̱ waje̱ kuítrinchaitiat, ashí eṉkeena nú naṉkaamas núkap eṉkeayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Warí, chikichcha ampirma nuna eṉkeenawai. Tura niisha aya núchiniak takurmakman ampirmatsuk ashí eṉkeayi.” ");
INSERT INTO jivNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yusa Uunt Je̱e̱n kaya shíirmach armia nuna tura chíkich shíirmach susamu armia nunasha chíkich shuar áujmatuk pujuarmiayi. Nuyá Jesus tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Átum yamái shiir wáintrumna nu ashí emesnartatui. Kaya ekentramusha mash yumpuuntrartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nuyá Jesusan chicharainiak “Uuntá, nusha ¿urutaik túrunatⁱ? ¿Kame ju̱ túrunatin jeatemamtaisha wariji̱a̱i̱ṉ nekaattajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tutai Jesus tímiayi “Aneartarum; anaṉnawairap. Nekaatarum. Winia náarun pachisar, “wi Krístuitjai” tau ti untsurí̱ jíintrartatui. “Nuṉka amuukatin jeayi” tu etserkartatui. Tuíniakui anturkarum nemariirap. ");
INSERT INTO jivNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tura meset chichamsha, kapitián mesetan nájanmasha antukrum sapijmiakairap. Nusha emka túrunatniuiti. Túrasha nú chichamaik amuukatin tsawant jeashtatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nuyá tuke chicharuk tímiayi ‘Shuar chíkich nu̱ṉkanmaya̱ shuarja̱i̱ mesetnum ti nekas maaniawartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ti u̱u̱rkattawai; untsurí̱ nuṉkanam tsukasha, suṉkursha ti átatui. Nayaimpinmasha ti ashammai náṉkamas túrunattawai. Nuja̱i̱ Yus ni kakarmari̱n iniakmastatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Tura ju̱ túruntsa̱i̱ṉ atumin pataaturmakar achirmakartatui. Iruntai je̱a̱nmasha makurmartai tusar juramkiartatui. Sepunmasha eṉketmattarme. Tura winia naar páchia asakrumin, akupniunmasha, úuntnumsha juramkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nuiṉkia atumin túrutmakrumin wi túramu etserkatin arutmattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Tura atumi̱ nemasri̱ nakitramainiak “wáitiaiti” ti̱tinian tujinkiarat tusan, winia nekatairja̱i̱ chichastinian amastatjarme. Tuma asamtai “Jurakuisha warinia tiniak kíishtumaktaj tusan áetak enentáimsashtatjai” titiarum.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","‘Tura imia atumí apari̱sha surutmakartatui. Atumí yachi̱sha, atumí shuari̱sha amikrumsha núnisaraṉ surutmakartatui. Tura máamunka máawartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tura Winia ajasaru asakrumin ashí aents nakitramprartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tura peṉké ishichkisha yajauch awajtamsachartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Katsuntrarmeka iwiaaku átin wáinkiattarme.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Ju̱ pepru Jerusaréṉka a̱a̱ tanishri̱i̱n suntar téntakar matsatu wáinkiurmeka, emesratin jeá nekaattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nuikia ju̱i̱ Jutía nuṉkanam pujuinia nu, náinnium pisartin áiniawai; tura ju̱i̱ Jerusaréṉnum pujuinia nusha ju̱ya̱ṉka jiinki wétin ainiawai. Tura ajanam pujuinia nusha, péprunam waketkishtin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nu tsawantincha Yus asutiámun wáinkiartatui. Yús-Papinium nu túrunatin yaunchu aarma nu uminkiattawai nu tsawantin. ");
INSERT INTO jivNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nuṉkanam ti wáitsatin átatui. Tura ju̱ aents ti asutniawartatui. Tuma asamtai nuwa̱ ajamtin ainia nusha, tura uchi kuírchin takakainia nusha imiá itiurchatan wáinkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tura ju̱yá aents mesetnum jákartatui. Tura chikichnaka ashí nuṉkanam misaawar júkiartatui; tura yajaya̱ apach, Yúsnan enentáimtuiniatsna nu, ju̱i̱ Jerusaréṉnum waya̱war najakartatui. Nu túratniunka Yus tsaṉkatkana nui̱ṉ túrawartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Nuiṉkia etsanmasha, nantunmasha, yáanmasha Yuska ni kakarmari̱n iniakmak nusháa túrattawai. Nuṉkanmasha ashí aents páchim enentáimprartatui. Tura nayaantsanam chíchimi ti aku tantáa ajakui ti ashamkartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tura túrunatin ana nuna enentáimsar ma̱yái̱ ashinkiartatui. Warí, nayaimpiniam kakaram ainia nusha peantrartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nuyá Winia, Aents Ajasu tutain, yuraṉminiam ti shiir ajasan winiai̱ wáitkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu túrunatin náṉkamkui uwempratin jeatemayi tusarum kaka̱a̱rum shiir enentáimsatarum.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tura ju̱ chichamnasha nekapmamiayi. ‘Ikiu numi tura náṉkamas numisha enentáimsatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ju̱ nuṉkanam ni nuké̱ yama puṉkakmatai “esat jeatemayi” tátsurmek. ");
INSERT INTO jivNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Núnisaṉ Wi tájana nu wáinkiurmeka, Wi ju̱ nuṉkanam akupin ajastin jeatema nu nekaatarum.’ ");
INSERT INTO jivNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‘Tura aents yamaí pujuinia nu jáatsa̱i̱ṉ nusha ashí túrunattawai. Núnaka paant tájarme. ");
INSERT INTO jivNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nayaimpisha nuṉkasha amuukartatui. Tura winia chichampruka amuukachminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Nu tsawant aya aneachma jeattawai. Ashí aents ju̱ nuṉkanam pujuinia nu, nuna enentáimtsuk pujuiniai̱ jeattawai. Tuma asamtai atumsha anearum wekasatarum. Yajauchiniam emetnarum, aya yurumátniuk, aya umartiniak enentáimtusrum, ju̱ nuṉkanam ana nu ti wakerakrumniṉkia péṉker enentáimsatin tujinkiattarme. Nu atsutí tusarum tura nu tsawant aya áwaktamka̱i̱j tusarum péṉker wekasatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anearum wekasatarum. Túrunattana nui̱ katsuntrataj tusarum Yus aujsa pujustarum. Túrarum Aents Ajasu tutai íimmianum péṉker átaj tusarum túratarum.” ");
INSERT INTO jivNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tuke tsawant tsawai̱sha Yusa Uunt Je̱e̱n Jesus unuiniamiayi. Tura káshikia Uriwiu náinnium we-wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tura tuke tsawant Yusa Uunt Je̱e̱n Jesus chichaamun anturkatai tusar káshik tariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wakaprutai eṉketaachma tanta yuatin námper, paskua tutai, jeatemamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Israer-shuara Pátriri̱sha Israer-shuara jintinniuri̱sha áentsun ashamainia ásar, itiurak máawaintiajⁱ tusar ti enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nuiṉkia Iskariúti Jútasan enentái̱n íwianch wáintiamiayi. Nú Jútaska Jesusa unuiniamuri̱i̱n páchitkiauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Israer-patri úuntri̱n tura Yusa Uunt Je̱e̱ kapitián pujuarmia nuna werimiayi. Tura Jesusan tu surukminiaiti tusa niiji̱a̱i̱ chichasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Niisha nuna antukar warasar “kuit amastatji” Jútasan tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Niisha “ayu” tinia, aents nékachmanum suruktaj tu enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wats, wakaprutai eṉketaachma tanta yúatin námper jeamiayi. Paskua tutainium murikchin máatin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tura Jesus Pitruncha, Juáṉnasha akupeak “Paskua tutai námper iwiaratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tutai niisha chichainiak “¿Tuí̱ iwiarat tusamea wakeram?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tutai Jesus ju̱na tímiayi “Péprunam wetarum. Jearum áishmaṉ yumin takaku wekáa wáinkiattarme. Nú áishmaṉ nemarsatarum. Tura je̱á waya̱a̱kui, ");
INSERT INTO jivNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nú je̱a̱ nérenniuri̱ chichareakrum “Uunt chichartamuk unuiniamurja̱i̱ paskua yurumátin ¿tui̱ aa? turamui” titiarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tákurmin nu nérentin yakí písunam uunt kuártun ashí iwiaramun iniakturmastatrume. Nui̱ ii yurumátin iwiaratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tutai niisha wear Jesus tímiania tímiatrusaṉ wáinkiarmiayi. Tura paskua namperan nui̱ iwiararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yurumátin jeamtai ni unuiniamuri̱ji̱a̱i̱ Jesus misanam pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pujusarmatai, Jesus chichaak “Wisha játsuk atumja̱i̱ ju̱ paskua najanatniun ti wakerimjai, ");
INSERT INTO jivNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","atakka ju̱ nuṉkanam atumja̱i̱ najanashtin asan. Tura antsu Yus akupeana nui̱ jear atak najanattaji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nuyá piniṉkian achik, Yúsan yumiṉkias, ni unuiniamuri̱n tímiayi “Ju̱ piniṉ achikrum sunaisatarum. ");
INSERT INTO jivNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Atakka ju̱ nuṉkanam uwa yumiri̱n atumja̱i̱ umarchattajai, tajarme. Tura antsu Yus akupin ajastin jeamtai atak iiji̱a̱i̱ umartatji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nuya̱sha yurumkan achik, Yúsan yumiṉkias puuk susarmiayi. Tura chicharainiak “Ju̱ka winia aya̱shruiti. Winia aya̱shur atum péṉker pujustinnium surunkattana núiti. Winia enentáimtursarum yuatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tura yurumsua amikiarmatai piniṉkian achik, “Ju̱ piniṉ winia numparun nakumea asa uwempratin yamaram chicham najanamun nakumeawai. Winia numpar atumnian puartamprattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‘Túrasha winia surutkattana nu Wiji̱a̱i̱ métek ju̱ misanam pujawai. ");
INSERT INTO jivNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kame Wi, Aents Ajasuitjiana ju̱, Yus iwiaramua nútiksanak jakattajai. Túrasha Winia surutkana nu nekaatí. Ti asutniattawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nuna antukar “Wíashitiaj, yákit” tunaim ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","“¿Iiji̱a̱i̱ yaki imiá naṉkaamantu aint?” tunaim ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tura Jesus tímiayi “Ju̱ nuṉkanam akupin ainia nu, waantu enentáimtumasar akupenawai. Tura akupenakui “péṉker túrin áiniawai” tuíniawai. ");
INSERT INTO jivNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tura atumja̱i̱nkia nuka atsutí. Antsu naṉkaamantu ana nu, uchichia núnik ajastiniaiti; akupeana nusha takarniua núnik ajastiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Enentáimsatarum. Misanam pujus yurumna nu, yurumkan ajamana nuja̱i̱ ¿tuá imiá nekas naṉkaamantuit? ¿Yurumna nu nekas naṉkaamantuchukait? Tura Wisha atumin yurumkan ajamna núnisnak pujajai.’ ");
INSERT INTO jivNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Winia itiurchatrun wáinmiaj nui̱ atumsha Wiji̱a̱i̱ tuke pujumarme. ");
INSERT INTO jivNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tuma asakrumin akupin ajastinian winia Apar surusu asamtai Wisha nútiksanak akupkatniun súajrume. Wi akupkatjana nui̱ atumsha Wiji̱a̱i̱ yurumáttarme, tura Wiji̱a̱i̱ umartatrume, tájarme. ");
INSERT INTO jivNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tura akupin pujutainium pujusrum, Israer-shuar tuse írutkamu akupkattarme tajai.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nuyá Uunt Jesus tímiayi, “Nekaatá, Semuṉká. Trikiu neré̱ tsatsamátniua áintsaṉ Satanás atumi enentái̱n páchim enentáimtikramprataj tusa seayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tuma aiṉ Yus enentáimtustinian kajinmatkiiṉ tusan Wisha Yúsan seamjai. Tura Yúsnum waketkim ame yatsum ikiakárarta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tutai Semuṉ tímiayi “Uuntá, sepunam eṉketmainiakuisha wisha nemarsatajme. Tura mantamainiakuisha métek jakatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tutai Jesus tímiayi “Pitrú, nekas tájame, yamaik atash shiniatsai̱ṉ ame menaintiú natsantrurtatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nuyá Jesus tímiayi “Wisha yurumkaja̱i̱nchu, kuítja̱i̱nchu, sapatja̱i̱nchu akupkamjarmena nui̱ ¿táatramsamkarum?” Niisha “Atsá peṉké táatramsachmaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tutai Nii tímiayi “Antsu yamaikia yurumkan takakkuṉka takustí, kuítniasha núnisaṉ; tura puniancha takakchakka ni pushiri̱n suruk punian sumakti. ");
INSERT INTO jivNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nekaatarum. Yus-Papinium yaunchu aarma ana nu wi túrunamuja̱i̱ uminkiattawai. Ju̱iti aarma: Yajauch shuarnum pachikiarmiayi. Warí, Yus-Papinium ashí Winia aarma ana nu uminkiatniuiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tutai ni unuiniamuri̱ tiarmiayi “Uuntá, ju̱i̱ jimiará puniá awai.” Tutai Niisha “Asati” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nuyá Jesus jíinkimiayi. Tura tuke túrin asa Uriwiu náinnium wémiayi. Ni unuiniamuri̱sha nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ai̱ jeá nin chicharuk “Itiurchat winiakui iniara̱i̱j tusarum Yus áujsatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tuasua amik arantach, kaya nankimiam jeana núnik Jesus wémiayi. Tura Yúsan áujsataj tusa tikishmarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tikishmar ju̱na tímiayi “Apawá, piniṉnum yapá umartinia ántsaṉ Wi wáitsattajna nu wakerakmeka jurutkitia. Tura Wi wakerajna nucha antsu Ame wakeramna nu atí, tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nuyá, ikiakártaj tusa Yusa suntari̱ nayaimpinmaya̱ tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tura Jesus imiá wáitias pujak nú kakaram Yúsan áujsamiayi. Tura ni se̱a̱rmari̱sha numpá ántsaṉ nuṉká kitiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yúsan aujsua amik wajaki ni unuiniamuri̱n werimiayi. Tura kúntuts enentáimmiari̱ji̱a̱i̱ ti pimpiki kanúu tepenan tarimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nuiṉkia chicharainiak “¿Urukamtai kanúu teparum? Itiurchat winiakui iniara̱i̱j tusarum nantakrum Yus áujsatarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus tuke chichaa pujai̱, untsurí̱ shuar táarmiayi. Tura nuní eemka Jesusa unuiniamuri̱ Jútas naartin winimiayi. Tura Jesusan mukunatajtsa tarunmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Támatai Jesus chicharuk “Jútasá, ¿Aents Ajasu tutai mukunamek surutkattam?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesusja̱i̱ pujuarmia nu, túmamun wáinkiar “¿Uunt puniaja̱i̱ íjiuartatjik?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tura chikichik Patri uuntri̱ takarniurí̱ kuishi̱n untsuuri̱n tsupirkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tura Jesus tímiayi “Iniaisatarum.” Nuna tinia ni kuishi̱n antiṉ tsuármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nuyá Israer-patri úuntri̱n, Yus-je̱a̱ úuntri̱ncha, tura pepru úuntri̱ncha, Nin achiktaj tusa tariarmia nuna chicharuk “¿Wisha kasakaitiaj. Urukamtai puniaja̱i̱sha numiji̱a̱i̱sha tarutniuram? ");
INSERT INTO jivNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nuik Yusa Uunt Je̱e̱n tuke tsawant atumja̱i̱ pujumaj nui̱ achirkachmarme. Túrasha átum kiritniumia̱ kakarmaja̱i̱ nupetkatin yamái tsawantin tsaṉkatkamuitrume” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nuiṉkia Jesusan achikiar emetawar Israer-patri uuntri̱ je̱e̱n júkiarmiayi. Tura Pítrusha íkiaṉ nemarki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tura a̱a̱ch jinia ikiapárarmiayi. Túrawar anamuk pujuarmiayi. Pítrusha niiji̱a̱i̱ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tura nuwa̱, Patri̱ takarniuri̱ amia nu, Pítiur jinia anamuk pujan wáiniak “Ju̱ áishmaṉsha Niiji̱a̱i̱ pujumiayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tutai Pítiur chichaak “Nuwá, Nin nékatsjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tura árusaṉ chíkich nin wáiniak “Amesha Ni̱i̱n páchitkiaitme” tímiayi. Tutai Pítiur tímiayi “Atsá. Wikia áiṉkia páchitkiatsjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chikichik ura naṉkaamasmatai chíkich apach chichaak “Nekas ju̱ áishmaṉsha Niiji̱a̱i̱ pujumiayi. Warí, niisha Kariréanmaya̱ṉchakait” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tutai Pítiur chichaak “Ame támena núnaka nékatsjai” tímiayi. Nú chichamaik Pítiur chicháa pujai̱ṉkⁱ atash shiniukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tura nuiṉkia Uunt Jesus Pítrun apa̱jas íismiayi. Túra “atash shiniatsa̱i̱ṉ ame menaintiu natsantrurtatme” Uunt Jesus timia nuna enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nuyá Pítiur jiinki ti úutmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Áishmaṉ Jesusan wáiniarmiania nu ti wishikiainiak awattiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ji̱i̱n epetkar yapiniam awattiar chicharainiak “Nekamata, ya awatama” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tura katsekainiak ti untsurí̱ chikichnasha náṉkamas tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsawa̱rmatai, Israer-shuara úuntri̱sha, Israer-patri úuntri̱sha, Israer-shuara jintinniuri̱sha iruntrar ni iruntairi̱i̱n ejeniarmiayi. Nui̱ chicharainiak ");
INSERT INTO jivNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Paant titiá. ¿Yus anaikiamu Kristu tutaia núkaitiam?” tiarmiayi. Tutai Jesus tímiayi “Wi “ee” tákuisha, “nekasaiti” tíchattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tura Wi aníamsha áirkashtatrume, túrasha akuptukchattarme. ");
INSERT INTO jivNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tura wárik Wisha Aents Ajasuitjiana nu, ashí naṉkaamaku ajasan, Yusa untsuuri̱ni̱ pujustatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tutai niisha tiarmiayi “¿Nuiṉkia amesha Yusa Uchirí̱ṉkaitiam?” Tutai Jesus tímiayi “Ee, Wíitjai, átum Winia túrutrum núnisnak.” ");
INSERT INTO jivNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tutai niisha tiarmiayi “Warí, ¿iisha chíkich ujatkat tusar atsumajik? Imia niṉki chichaamu antukchajik” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nuyá ashí Uunt iruntrarmia nu wajatkiar Rúmanmaya̱ akupin Piratuí̱ Jesusan júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nui̱ jeawar, Piratun chicharainiak “Ju̱ áishmaṉ íi shuaran awajimtikiar enentáimtikiainia nu nekaamji. Rúmanmaya̱ uunt akupin Sésaran kuit akiktinian suritramaji. Tura nu arant Niṉki, akupin Kristu tutaintjai, tawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tutai Piratu Jesusan chicharuk “¿Ame Israer-shuara akupniuri̱ṉkáitiam?” tímiayi. Tutai Jesus tímiayi “Ee, núitjai, ame támena núnisnak.” ");
INSERT INTO jivNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nuyá Israer-patri úuntri̱ncha tura aents nui̱ iruntrarmia nunasha Piratu chicharainiak “Ju̱ áishmaṉ tunaan túran peṉké wáinkiachuitjai, tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Túrasha niisha nú kakantar chicharainiak “Antsu nekas ashí Jutía nuṉkanmaya̱ aentsun ni unuiniana nuja̱i̱ akajenawai. Kariréa nuṉkanmaya̱ naṉkaamas ímiajai̱sha tayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piratusha nuna antuk “Nu áishmaṉ ¿Kariréanmaya̱ṉkáit?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ee” tuiniakui, Erutisan akuptukarmiayi. Erutiska Kariréanmaya̱ aentsun akupniuyayi. Túmaitiat nu tsawantin Jerusaréṉnum ishichik tsawant pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erutiska Jesusan íistaj tusa ti wakerimiayi. Jesusa túramuri̱n áujmatman ti antukmiayi. Tuma asa, “Wi íimiai̱ aents tujintiamun túrashtimpiash” tusa Jesusan wáiniak warasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesusan ti nukap aniasmiayi; túramsha peṉké áimkiachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nui̱sha Israer-patri úuntri̱sha, tura Israer-shuara jintinniuri̱sha yajauchiiti tusar charaatum awajiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tura Erutissha ni suntari̱ji̱a̱i̱ Jesusan yajauch enentáimtuiniak Nin wishikiainiak ti peṉker pushin, akupniu entsatairi̱ya ánniun, áentsrarmiayi. Nuya̱sha Erutis ataksha Piratuíi̱n akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Túram nu tsawant Piratu Erutisja̱i̱ nawamnaikiarmiayi. Kame yáunchuka nemasnaikiau ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nuyá Israer-patri úuntri̱n aentsu úuntri̱ji̱a̱i̱ tura peṉké aentsja̱i̱ Piratu ikiaanak tímiayi ");
INSERT INTO jivNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ju̱ áishmaṉ aentsu awajimtikiui tusarum itiartintrume. Túrasha átum íimprumniṉ anintrusan yajauch átum tárumna nuna peṉké nekarachjai. ");
INSERT INTO jivNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erutissha núnisaṉ yajauchin nekaachai. Warí, ju̱i̱ awaiṉkichmaka. Nuikia páantchakait jú̱ aishmaṉ jakamnia tunaanka túrichuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Túraitiat tuke túrutai asamtai, jísat jeakui sepunmaya̱ chikichík áishmaṉkan Piratu aṉkant akupkatin ámiayi. Tuma asamtai, nii chichaak “ju̱na asutián awematjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tura aencha iruntrar ti untsumainiak “Atsá; ju̱cha. Ju̱ nakitiaji. Antsu Parapás akupkata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nu Parapássha akupniun nakitiak mesetan najana asa tura maṉkartin asa sepunam eṉkeamuyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratuka Jesusan akupkattsa wakerak ataksha aentsun áujsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Túrasha nú arant untsumainiak “Atsá. Krúsnum mantamnati” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tura ataksha Piratu chicharainiak “¿Urukamtai. Warí tunaan túrait? Jakamnia tunaan túrachiash tusan, aniasan peṉké nekarachjai. Asutián akupkatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tura niisha kakaram untsumainiak “Jesus mantamnati” tiarmiayi. Kame aencha tura Patri úuntri̱sha ti untsumaina ásarmatai ni wakeramuri̱ tsaṉkatnakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nii wakeriarmia nuna Piratu “túrattajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tuma asa Parapásan, mesetan najanin tura maṉkartin amia nuna akupkamiayi. Tura Jesusnaka ni wakeramun túrawarti tusa íiktusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusan jukitiasa pujuiniai̱ Serini nuṉkanmaya̱ Semuṉ ni pépruri̱ya̱ Jerusarénnum yama jeamiayi. Nin achikiar, Jesusa krusri̱ ayantkar “ni ukuri̱ wetá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Untsurí̱ aents Jesusan nemariarmiayi. Tura untsurí̱ nuwa̱sha ti kuntuts enentáimiainiak úutkiar tura wa-wa ajakiar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Túmainiakui Jesus nin iis, “Jerusaréṉnumia̱ nuwa̱tiram Winia enentáimtursarum úuttiirap. Antsu atumniak tura atumi̱ uchiri̱ enentáimtusrum úuttiarum. ");
INSERT INTO jivNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Warí, ti iturchat tsawant jeawartatui. Tuma asamtai “Uchirtichu ainia nu, ajaprukchana nu tura amuntsachu ainia nu, chíkich aentsja̱i̱ naṉkaamas péṉker pujuiniawai” tiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nu tsawantai̱ aents chicharainiak “Náint in nekentmak yuturmaartai” tiartatui. ");
INSERT INTO jivNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Warí, numi sameka áinis yajauch aya náṉkamna ai̱ṉsha ju̱ itiurchat átsuk. Tura numi kukaru ainkiamtai itiurak nú yajauch túrunachatⁱ.” Tu timiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tura Jesusja̱i̱ krúsnum maatai tusar jímiar yajauch áishmaṉkan júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Karawír nain tutainium jeawar Jesusan krúsnum ajintrurarmiayi. Tura Jesusa untsuuri̱ni̱ chikichík yajauch áishmaṉkan tura ni menaarini̱ chíkich yajauch áishmaṉkan núnisaṉ krúsnum ajintrurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tura Jesus krúsnum ajintraku pujuram, chichaak “Apawá, tsaṉkurarta. Nii áitkiainia nuna nékainiatsui” tímiayi. Tura suntar pujuarmiania nu, yaki Jesusa pushiri̱ jukit tusar nakurusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Péprunmaya̱ aents ii wajatiarmiayi. Tura uunt armia nusha Nin wishikiainiak “Chikichnaka uwemtikniuiti. Wats, yamái nekas Yusa anaikiamuri̱ Kristu tútainkiuṉka imia Niṉki uwémpratí” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suntarsha Nin wishikrarmiayi. Tariar churuínian aartai tusar awajiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tura chicharainiak “Amesha nekas Israer-shuara uunt akupniuri̱nkiumka amek uwemprata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tura muuknumaani, Kriaku chichamja̱i̱, Rúmanmaya̱ apach chichamja̱i̱sha tura Israer chichamja̱i̱sha ju̱ áarar anujkamu ámiayi: JÚ̱ITI ISRAER-SHUARA UUNT AKUPIN ");
INSERT INTO jivNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chikichík yajauch áishmaṉ nui̱ ajintruamu amia nu kátsekeak chicharuk “Amesha nekas Yusa anaikiamuri̱ntkiumka amek uwemprata tura incha uwemtikramprata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tura chíkich ni tsaniakmari̱n kakantar chicharuk “¿Amesha Niiji̱a̱i̱ métek asutniátasa pujayatam, Yus ashamatsmek? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iikia yajauch asar wáitsatniuitji; ii tunaari̱ akikmakur wáitiaji. Antsu ju̱ áishmaṉka yajauchin túrichuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nuyá Jesusan chicharuk “Amesha akupin ajasam winiasha enentáimtursata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tutai Jesus chicharuk “Nekas tájame, jakar shiir pujutainium yamái tsawant Wiji̱a̱i̱ pujustatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tutupin ai̱ ashí nuṉkanam ti kirit ajasmiayi. Tura menaintiú ura naṉkaamasu aiṉ, nantu nuṉkaach ajassha tuke kirit ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tsawái nantusha mushatmarmiayi. Tura Jerusaréṉnum Yusa Uunt Je̱e̱ncha tarach ajamu aa jímiapetek nakaakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nuyá Jesus untsumuk “Apawá, winia wakantrun Ami̱i̱n ikiuajai” tímiayi. Nuna tinia jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Suntara kapitiántri̱ nu túrunamun wáiniak, Yusa náari̱n shiir awajeak “Ju̱sha imiá nekas péṉker áishmaṉkuyi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tura untsurí̱ aents pujuarmia nu, nu túrunamun wáinkiar ti kuntuts enentáimiainiak ni netsepe̱n paat awatiar waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tura Jesusa amikri̱sha tura nuwa̱ Kariréanmaya̱ Nin nemariarmia nusha íkiaṉ wajasar ii wajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Naka enentáimin péṉker áishmaṉ ámiayi ni naari̱ Jusé. Arimatéa pepru Jutía núṉkanam ana nuya̱uyayi. Israer-shuara Uunt Iruntairi̱n páchitkiauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yus ju̱ nuṉkanam akupin ajasat tusa Jusé nakas pujumiayi. Tuma asa Uunt Iruntainium Jesusan túrawarmia nuna nakitmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tuma asamtai Piratui̱ we Jesusa aya̱shin seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Piratu “ayu” takui, Jesusa aya̱shin krúsnumia̱ jusa tarachja̱i̱ penuar kaya táurmanum iwiarsamiayi. Nu táurmanum chíkich iwiarsachmauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iwiaratin tsawantai̱, ayampratin tsawant tsawa̱statuk ajasmatai túrunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tura nuwa̱ Kariréanmaya̱ jukiniutak Jesusan nemarsarmia nusha iwiarsamunam weriar, Jesusa aya̱shi̱ itiur ikiusmait nuna iisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Iisar ikiuak ni je̱e̱n waketkiarmiayi. Tura Jesusa aya̱shi̱ mejeeniṉ tusar kuṉkuinian iwiararmiayi. Tura ayampratin tsawantai̱, Israer-shuar akupkamun umikiar ayamprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tumiṉtin káshik kuṉkuinian iwiaramun júkiar nu nuwa̱ Jesus iwiarsamunam weriarmiayi. Tura chíkich nuwa̱sha atampriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tura iwiarsamu kaya atutkamu urani aan wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tura waya̱war uunt Jesusa aya̱shin wáinkiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wáinkiachu ásar ashamkarmiayi. Tura “itiurkatjik” tiarmiayi. Tumai̱ jimiará áishmaṉkan pushin wincharpatniun entsaru nin aya̱a̱mach wajainian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nuna wáinkiar ti sapijmiainiak tsuntsumawarmiayi. Túmakui nu áishmaṉ chicharainiak “¿Iwiaakusha urukamtai jakaanumsha e̱a̱rum? tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ju̱i̱ pujatsui. Antsu nantakni. Nékatsrumek. Niisha Kariréanam tuke pujus ");
INSERT INTO jivNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Wi, Aents Ajasuitjiana nu, yajauch aentsnum surunkattajai. Túran krúsnum mantamnattajai. Tura menaintiú tsawantai̱ nantaktiatjai” turamchamkarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nuna takui Jesus timian enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tura iwiarsamunmaya̱ waketki taar, Jesusa unuiniamuri̱n auntse armia nuna tura chikichnasha ashí nu túrunamun ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jesusa unuiniamuri̱n ujakarmia nu ju̱ áiniawai: Maktaranmaya̱ Marí, Juánasha, Jakupu nukurí̱ Marisha, tura chíkich nuwa̱ja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tura Jesusa unuiniamuri̱sha nuwa̱ tuíniakuisha nekasaiti tu enentáimtsuk “wáuruk tuíniawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Túrasha Pítrusha jiinki Jesus iwiarsamunam tsékeṉki werimiayi. Jeá, init iis, aya tárachik tepenan wáinkiamiayi. Tura túrunamia nuna ti enentáimiar ni je̱e̱n waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nu tsawantai̱k Jesusa nemarniuri̱ jímiar Emaús péprunam wéarmiayi. Emaúska Jerusaréṉnumia̱ auntse kirumitru jeá pujawai. ");
INSERT INTO jivNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Túrunamia nuna chichaki wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","“Itiurkit” tu aujmatki weenai̱ imia Jesus taa nui̱ páchiniak niiji̱a̱i̱ wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tura wáinkiariat nekaashtin asamtai yait nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","We-wénakua Jesus chicharainiak “Jintiasha ¿warí áujmatkirum wéarum? ¿Urukamtai kúntuts enentáimprum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chikichik, Kreupas náartin chicharuk “Jerusaréṉnum túruna nuna ashí nékainiawai. ¿Ámeka amekek túrunamia nu nékachu páchitkiam?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tutai Jesus tímiayi “¿Warí urukait?” Tutai tiarmiayi “Entá, Nasarétnumia̱ Jesusa túrunamuri̱ taji. Niisha Yúsnan etserin asa Yusa kakarmari̱ji̱a̱i̱ chichasmiayi tura nuna kakarmari̱ji̱a̱i̱ takasmiayi. Núnaka ashí aents nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tura ii Pátriri̱ uuntri̱ tura ii pépruri̱ uuntri̱ “tunáa jakamnia túrayi” tusar “krúsnum mantamnati” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tura ii Israer-aentstin uwemtikrampratin tu enentáimsamji. Tura ni maamusha menaintiú tsawant naṉkaamasai. ");
INSERT INTO jivNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Túrasha ii nuwa̱ ni iwiarsamunam yamaí káshik weriar ni aya̱shin wáinkiacharmai. Tura “Yusa suntari̱ wáinkiaji tura “Jesus iwiaakuiti” túramji” tiarmai. Nuna tu ujatmakakrin ti enentáimpraji. ");
INSERT INTO jivNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nuyá íi shuar iwiarsamun weriar, nuwa̱ tiarmia tímiatrusaṉ wáinkiarmiayi. Tura Jesusnaka wáinkiacharmai.” Tu ujakarmai Jesusan. ");
INSERT INTO jivNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nuyá Jesus nin chicharainiak “Enentáimchaitrume. Ashí Yúsnan etserin tiarmia nu wau enentáimtatsrume. ");
INSERT INTO jivNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Yusa anaikiamuri̱, Kristu tutai, shiir awajnatsuk ti wáitsashtinkiait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tura nuyá Yus-Papinium Muisáis aarmia nuyá jukin ashí Yúsnan etserin ni túrunatniuri̱n áararmia nuna jintintiatasa naṉkamamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ayu, nii wearmia nú peprunam jeawarmiayi. Tura Jesuska nui̱ naṉkaamaki wétaj tau ajamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tura niisha chicharainiak “Weep. Iiji̱a̱i̱ pujustá. Warí, nantu akaikiyi, kirit ajatemsai” tiarmiayi. Tutai Jesus niiji̱a̱i̱ pujustaj tusa waya̱miayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tura niiji̱a̱i̱ irunar misanam pujus, yurumkan achik, Yúsan yuminkias nincha puuk súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nu chichamaik, ni ji̱i̱ uranniua núnikiarmatai Jesusan nekaawarmiayi. Tura Niisha nú chichamaik meṉkakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tura nu shuarsha mai tunai ajainiak “Jintia winis Niisha Yus-Papin jintintramuk nekas ii enentái̱n shiir enentáimtikramprachmakajⁱ” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nuyá, Emaúsnumia̱ wárik jíinkiar Jerusaréṉnum waketkiarmiayi. Nui̱ Jesusa unuiniamuri̱n auntse armia nuna tura chíkich shuar Jesusan nemariarmia nunasha iruntrar pujuinian wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Auntse armia nusha tiarmiayi “Uunt Jesus nekas nantakni. Semuṉ Nin wáinkiaiti.” ");
INSERT INTO jivNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tutai niisha jintiá túrunamun ujakarmiayi. “Jesus yurumkan ajaamakui nui̱ nekaamji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nuna áujmatuk pujuiniai̱ Jesus aya aneachma ajapén wajas “Shiir enentáimsatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nuna antukar, ti sapijmiakar, wakanchashit, enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tura Jesus chicharainiak “¿Urukamtai sapijmiakrum wakanchashit, tu enentáimsarum? ");
INSERT INTO jivNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Winia uwejrusha, nawersha íirtustarum. Wíkiitjai. Takarsa íirsatarum. Warí, wakancha aya̱shtinkiait, ukunchtinkiait” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nuna tinia ni uwejé̱ncha nawe̱ncha iniaktusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Warainiayat sapijmiainia ásar, Niimpiashit tu enentáimtusarmiayi. Tuma asamtai, nin chicharainiak “¿yurumak takakrumek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Takui, namaknasha, míshkincha súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tura Jesus nuna achik niisha íimiainiamunmaṉ yuamiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tura nin tiarmiayi “Winia túrutawarma nuna, Wi atumja̱i̱ nuik pujusan tímiajrume. Nekas uminkiatniuyayi. Iis, wi túrunatniurun Muisáis aarmia nusha, Yúsnan etserin aarmia nusha, tura Sarmu papinium aarma ana nusha ashí uminkiatniuyayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nuyá Yus-Papinium aarman jintintiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jintintiuk ju̱na tímiayi: “Yusa anaikiamuri̱ Kristu tutai jaka menaintiú tsawantai̱ jakamunmaya̱ nantaktinia nu yáunchuk áarmauyayi. Tura Wi nú Krístuchukaitiaj. ");
INSERT INTO jivNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Winia náarun pachisar, Jerusaréṉnumia̱ naṉkama ashí nuṉkanam nu chicham etsernaktinia nu áarmauyayi. Shuar ni tunaari̱ tsaṉkurnarat tusar enentái̱n yapaji̱átniuiti. Tura tu etserkatniua nusha yaunchu áarmauyayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tura wi túrunamu neka asarum etserkatniuitrume, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tura winia Apar, winia Wakantrun susartatjai, turammarumna nuna akuptuktatjarme. Tura nayaimpinmaya̱ táatsa̱i̱ṉ ju̱i̱ Jerusaréṉ péprunam pujústárum. Taa ni kakarmari̱n suramsattarme.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nuyá Jesus Jerusaréṉ péprunmaya̱ júkiar Petania péprunam ejeniarmiayi. Tura nui̱ ni uweje̱ takuí, “Yus yáinmakarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nuna tu pujus, nii̱ya̱ kanakmiayi. Tura nayaimpiniam junakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ni unuiniamuri̱sha Nin imiá shiir enentáimtusarmiayi. Tura nuyá ti warasar Jerusaréṉnum waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tura Yusa Uunt Je̱e̱n pujusar Yusa náari̱n shiir awajú pujuarmiayi. Áukete.");
INSERT INTO jivNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ashí naṉkamamia nú yaunchu Yusa Uchirí̱ tuke pujuyayi. Niisha Yúsan ti paant awajeakui, Chícham tíminiaiti. Chichamsha Yusja̱i̱ pujuyayi. Chichamsha Yúsauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yámaṉkamtaik Niisha pujuyayi Yusja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ashí najanamu ainia nu Niiji̱a̱i̱ najanamuiti. Nii najanachmaka peṉké atsawai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Niisha iwiaaku átinia nérenniuti. Nu iwiaaku atincha tsáapninia áinis Yusna ana nuna ashí shuaran paant nekamtikiamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nu tsáapnin kiritniunam tsáapniawai. Tura kiritniusha tsáapninian ikiajniaktinian tujinkiaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Áishmaṉ ámiayi, Yus akupkamu, ni naari̱ Juaṉ. ");
INSERT INTO jivNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Niisha tsáapnin chichaman etserkatajtsa támiayi. Nuna étseruk ashí umirkarat tusa támiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juaṉsha nu tsáapninchauyayi. Áyatik akupkamuyayi tsáapnin chichaman etserkat tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nu tsáapninkia nekas tsaapniniaiti. Ju̱ nuṉkanam taa ashí shuaran enentái̱n tsáapniartiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chichamsha taramiayi ju̱ nuṉkanam. Tura nuṉkasha ni najanamu aiṉ, nuṉkaya̱ aents Nin nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Támiayi ni nuṉké̱n tura ni shuarsha ni enentái̱n itiaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tuma aiṉ chíkich shuar Nin enentáimtuiniak ni enentái̱n itiaawarua nuna Yusa uchirí̱ ajastinian Yus tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Niisha Yusa uchirí̱ ajasar ataksha númpentin aya̱shímkiacharmai. Áentsnúmia̱ akiiniachu áiniawai niisha. Áishmaṉ wakeramuja̱i̱sha akiiniacharmai. Antsu Yúsnumia̱ akiiniawaru ásar Yusa uchirí̱ áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nú Chichamsha a̱ya̱shtin ajas iiji̱a̱i̱ núkap tsawant pujumiayi. Yusa aneṉkratairi̱ji̱a̱i̱ piakuyi. Aya nekasa nunak chichaamiayi. Núnisaṉ ni péṉkeri̱n, aya Yusa Uchiri̱ chikichkia nu takusminia nuna iniakmamiayi. Nusha iisha paant wáinkiaitji. ");
INSERT INTO jivNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juaṉsha Nin neka asa, étseruk tímiayi “Jú̱iti wi tímiaj nu: “Winia ukuruini̱ winittiana nu wíji̱a̱i̱ṉkia émkaiti. Maa, wi atsa̱i̱sha tuke pujuyayi” tiniujai.” Tu etserkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chichamsha ti aneṉkartin asa ashí péṉker ana nuna iniaitsuk súramji. ");
INSERT INTO jivNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yusa akupeamuri̱n Muisais yaunchu jintintraiti, antsu aneatniuncha tura ashí nekas ana nunasha Jesukrístu jintintraiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Chikichkisha Yúsan peṉké wáinkiachuiti. Tura ni Uchirí̱ chikichkia nu tuke Niiji̱a̱i̱ tsaníaku asa Yúsan paant awajturmasuitji. ");
INSERT INTO jivNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusaréṉnumia̱ Israer-shuar ni Pátriri̱ncha Riwí-shuarja̱i̱ Juaṉkai̱ akupkarmiayi yákit tusar. ");
INSERT INTO jivNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Inintruiniakui paant ujakmiayi. “Wikia Krístuchuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Takui ataksha aniasarmiayi “¿Nuikia yáitiam. Yúsnan etserin yaunchu amia nú Eríaskaitiam?” tiarmiayi. Juaṉsha “Atsá, núchaitjai” tímiayi. Nuyá ataksha aniasarmiayi “Nuikia ¿Yúsnan etserin tátinia núkáitiam?” tiarmiayi. Niisha “Atsá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Takui “¿Nu arantcha yáitiam. In akuptamkajnia nusha warí títiatajⁱ. Warintia enentáimiam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juaṉsha tímiayi “Yúsnan etserin Isayas yaunchu timia núitjai. Niisha áarmiayi “Aents atsamu nuṉkanam shuar untsumui “Ii uuntri̱ jintí naka awajsatarum,” tu untsumui.” Núnaka Isayas áaruiti. Tura wikia untsumna nú shuaraitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juaṉja̱i̱ chichainiakka Pariséu akupkarma ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Niisha tiarmiayi “Nuikia Krístuchuitiatmesha, Eríaschaitiatmesha, Yúsnan etserin tátinia núchaitiatmesha ¿urukamtai imiakratam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juaṉsha tímiayi “Wikia entsaja̱i̱ṉ imiakratjai. Tura átum írutramunam shuar átum nékatsrumna nu wajaawai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Niisha winia ukurui̱ni̱ winiayat wíji̱a̱i̱ṉkia ti naṉkaamantuiti. Nii ti péṉker asamtai wisha ni sapatri̱ jiṉkiamuri̱ncha atitrachminiaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nuka Petapara peprunam túrunamiayi. Petaparasha Juaṉ imiakratmia nui̱ Jurtaṉ entsa amain amai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nuyá kashin Juaṉ Jesusan winian wáiniak tímiayi “Iistarum. Núiti Yusa Murikri̱ ashí aentsu tunaari̱n júana nu. ");
INSERT INTO jivNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Núiti wi timiaj nu, “Winia ukurui̱ winiana nu wíji̱a̱i̱ṉkia naṉkaamantuiti. Tura wi atsa̱i̱sha tuke pujuyayi” tímiajai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wisha Nin nekaachmajai. Tura ashí Israer-shuar Nin nekaawarat tusan imiakin támajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nuyá tímiayi “Yusa Wakanin yámpitsa núnin nayaimpinmaya̱n táarun wáinkiámjai. Tura ekemsamai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nu túruntsa̱i̱ṉ tuke Nin nekaachmajai. Tura Yuska winia imiakrattinian akuptak turutmiai “Chikichik shuarnum Yusa Wakaní̱ tara ekemsa wáinkiam, nuja̱i̱ nekaattame. Yusa Péṉker Wakaní̱ji̱a̱i̱ imiakratniua núiti” túrutmiayi. Tura nuja̱i̱ Nin nekaamjai. ");
INSERT INTO jivNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yamaikia wainkia asan ti paant nékajai tí nekas Yusa Uchirí̱nti” tímiayi Juaṉ. ");
INSERT INTO jivNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kashincha ataksha Juaṉ nui̱ wajasmiayi ni unuiniamuri̱ jímiarja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesussha nui̱ naṉkaamakui Juaṉ tímiayi “Iistarum, Yusa Muri̱krí̱ áuwiti.” ");
INSERT INTO jivNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juaṉka unuiniamuri̱ nuna antukar mai Jesusan pataatukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesussha úkumur íimias nu jímiaran wininian wáinkiámiayi. Tura tímiayi “¿Ya e̱a̱rum?” Niisha “Uuntá, ¿tui̱ pujam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesussha tímiayi “Wats, iitiarum.” Niisha wear ni pujutairi̱n wáinkiarmiayi. Tura áaṉkú ajasmatai nu tsawantai̱ nui̱ kintiamprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juaṉka chichame̱n antukar Jesusan pataatukaruka jímiar ármiayi. Chikichik Antresauyayi. Niisha Semuṉ Pitru yachi̱i̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Antressha wárik ni yachi̱ Semuṉkan e̱a̱ktajtsa wémiayi. Tura wáiniak “Misías wáinkiaji” tímiayi. Misíaska ni chichame̱n “Kristu” tawai. Krístuka Israer-shuaran yaiṉkiarat tusa Yus anaikiamuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nuyá Antres ni yachi̱ Semuṉkan Jesus pujamunam jukimiayi. Jesussha wáiniak tímiayi “Ámetme Semuṉ, Junasa uchirí̱. Túrasha Sépas átatme.” Sépaska Israer-shuar chichamnum kaya tawai. Tura Kriaku chichamnum nuka Pítruiti. ");
INSERT INTO jivNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kashincha Jesus Kariréa nuṉkanam wétajtsa pujumiayi. Tura Jiripin wáiniak “Nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jiripisha Petsaitia péprunmaya̱uyayi. Antressha Pítrusha nu péprunmaya̱uyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nuyá Jiripi Natanaéran e̱a̱kmiayi. Tura wáiniak tímiayi “Muisais Yus akupkamu papinium “Anaikiamu tátatui” tu áarchamkia. Yaunchu Yúsnan etserniusha ujakcharmakia. Nu shuar wáinkiaji. Jesusaiti, Jusé uchirí̱. Nasarét péprunmaya̱iti.” ");
INSERT INTO jivNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaérsha tímiayi “¿Nasarétnumia̱ péṉker shuar áminkiait?” Jiripisha “Winim íitiá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesussha Natanaéran tíjiu̱ch winian wáiniak tímiayi “Ju̱ shuar iistarum. Ti péṉker Israer-shuaraiti. Peṉké anaṉkartichuiti.” ");
INSERT INTO jivNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaérsha tímiayi “¿Itiur nékaram?” Jesussha tímiayi “Jiripi tuke untsurmatsa̱i̱ṉ wáinkiájme ikiu numiri̱n ejamkam wajamin.” ");
INSERT INTO jivNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaér nuikia tímiayi, “Uunta, nekas Yusa Uchirí̱nme. Israer-shuar akupniuitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tura Jesus tímiayi “¿Aya wi “Ikiu numiri̱n ajamkam wajamin wáinkiájme” takui Winia enentáimturamek? Antsu nuna naṉkaamas nekaachmin ana nusha wáinkiáttame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nuya̱sha Jesus tímiayi “Wi nekas tájarme, Aents Ajasu asan atumsha nayaim uranmianum Yusa suntari̱ Winin tara waka ajainia wáinkiáttarme.” Tu tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Menaintiu tsawant naṉkaamasmatai nuatnaikiatin jísat Kaná péprunam ámiayi. Kaná péprusha Kariréa nuṉkanmauyayi. Jesusa nukurí̱sha nui̱ pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesussha ni unuiniamuri̱sha nu nuatnaiyamunam ipiaamu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Umutai amuukamtai Jesusa nukurí̱ tímiayi “Umutai amuukai. Peṉké takakainiatsui.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tura Jesus tímiayi “Nukuá, ¿urukamtai Winia túrutam? Iniáitiústá. Winia kakarmar iniakmastin jeaatsui.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nuyá umutain wáinmainia nuna ni nukurí̱ tímiayi “Ashí ni tana nu umiktárum.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nui̱ kayaja̱i̱ najanamu yumi-yaraatai sais (6) ámiayi. Nu yaraatainmaya̱ Israer-shuar ni ewejé̱ncha ni nawe̱ncha nijiamau ármiayi Yus shiir enentáimtursatí tusar. Chíkich chíkich yaraatainium uchenta (80) rítrusha, siaṉ (100) rítrusha yumi waya̱mniauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nuyá Jesus umutain wáinmaun “Ju̱ yaraatai áimpratarum” tímiayi. Takui mete áimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Áimprarmatai Jesus tímiayi “Pai, ishichik shikikrum námper chicharu suutarum.” Tutai nútiksaṉ túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jista chicharusha nu umutai ajasun nekáprámiayi. Yaraatainmaya̱ yumi jusamun nekaachmai niisha tura umutai ajamau jusaru ásar nékarmai. Jista chicharusha nuwa̱tun untsuk ");
INSERT INTO jivNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tímiayi “Jístanmaṉka péṉker umutain emka suíniatsuk. Tura jémararmataiṉkia tímianchan suiniatsuk. Túrasha ámeka péṉker umutai ikiusam yamái jí̱i̱kchamek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus túramu Kananum Kariréa nuṉkanam túrunamiayi. Nú̱ja̱i̱ṉkia Jesus emka ni kakarmari̱n paant iniaktusmiayi. Nuna íisar ni unuiniamuri̱sha Nin enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nuyá Kapernáum péprunam wémiayi. Ni nukurí̱sha ni yachi̱sha ni unuiniamuri̱sha nemariarmiayi. Nui̱sha untsurí̱ tsawant pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israer-shuara namperi̱, paskua tutai, ishichik ajasmatai Jesus Jerusaréṉnum wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nui̱ jeá Yusa Uunt Je̱e̱n súruinian wáinkiámiayi. Turuncha murikniasha yampitsnasha súrin ármiayi. Chikichcha ni misari̱n pujusar kuítian yapají̱niancha wáinkiámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nuna wáiniak yaraṉken chapikmar asutkiartutain najana nuja̱i̱ ashí waakartiuk murikrintiuk a̱a̱ jíi̱rmiayi. Kuítian yapajniu misari̱ncha ayantar ni kuítrin nuṉká utsaṉkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yampitsan súrinniasha tímiayi “Nuka ju̱yá jí̱i̱tiarum. Winia Aparu Je̱e̱n surutai je̱a̱ najanawairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nuna íisar ni unuiniamuri̱ yaunchu Yus-Papinium áarman enentáimprarmiayi. Ju̱ áarmaiti: “Ame Je̱e̱m shiir atí tusan ti wakerukuitjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nuikia Israer-shuara uuntri̱ Jesusan aniasarmiayi “Ju̱na túramniaitjai tusam ¿warí kakarmak iniakmastatam?” ");
INSERT INTO jivNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesussha tímiayi “Ju̱ Je̱a̱ sáa̱kiakrumin menaintiú tsawantaí̱ iniantaittiajai Wikia.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Israer-shuarsha tiarmiayi “Kuarentisáis (46) uwitin ju̱na jeamtinian pujursarmiayi. Amesha menaintiú tsawantai jeamtámeash.” ");
INSERT INTO jivNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kame Jesus “Je̱a̱” chichayat ni aya̱shi̱n tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tuma asamtai Jesus ukunam jakamunmaya̱ nantakmiatai ni unuiniamuri̱ ni timian enentáimprar ni chichame̱ncha tura yaunchu Yus-Papinium áarmancha “Nekasaiti” tu enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paskua námpertin ti untsurí̱ Jerusaréṉnum pujuarmia nu, Jesus aents tujintiamun túramtai, nuna wáinkiar Nin nekas enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tuma aiṉ Jesus ashí neka asa ninkia enentáimtuscharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Niṉki ashí shuara enentái̱n neka asa chíkich ujatkat tusa atsumchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Shuar ámiayi ni naari̱ Nikiutému. Niisha Pariséu asa nii tuinia áintsaṉ Yúsnan takauyayi. Niisha Israer-shuara uuntri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Niisha kashi Jesusa̱i̱ irastajtsa wé tímiayi “Uuntá, shuáran unuiniarat tusa Yus akúptámkaiti. Nu paant nékaji. Yúsai̱ya̱nchuitkiumka aentsti tujintiamu túramna nu tujinkiaintme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesussha tímiayi “Tí nekas tájame. Atak yamaram akiiniachuka Yus akupeamunam pachiinkiashtatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tutai Nikiutému aniasmiayi “¿Itiurak shuar uunta nu ataksha akiiniat. Ataksha ni nukurí̱ ampujé̱n eṉkempramniakait atak akiiniatniuna?” ");
INSERT INTO jivNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ataksha Jesus tímiayi “Ti nekas tájame. Shuar entsaya̱sha tura Wakanniumia̱sha akiiniachuka Yus akupeamunam peṉké pachiinkiashtatui. ");
INSERT INTO jivNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aya̱shniumia̱ akiinia nuka a̱ya̱shchakait. Núnisaṉ Wakanniúmia̱ akiinia nuka wakanchakait. ");
INSERT INTO jivNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wi “atak yamaram akiiniatniuiti” takui itiurchat enentáimpraip. ");
INSERT INTO jivNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nase enentáimpratá. Nase náṉkamsaṉ umpúawai. Amesha ántame tura tuya̱ṉ winiá túrasha tuiṉ weti nékatsme. Núniskete ashí Wakanniúmia̱ akiinia nu.” ");
INSERT INTO jivNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tuma asamtai Nikiutémusha atak anias “¿Ju̱sha itiurak áminiait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus áikmiayi “Ame Israer-shuara jintinniuri̱ntiatmesha ¿itiura nékatsmea? ");
INSERT INTO jivNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ti nekasan tájame. Nekas nékakur chichaaji. Íismajnia nusha ujaaji. Tuma aiṉ ii chichame̱ ántatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aya ju̱ nuṉkanmaya̱ túramu ujaam ántachkurmeka ¿itiurak nayaimpinmaya̱ túramusha antuktarum?’ ");
INSERT INTO jivNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‘Shuar chikichkisha nayaimpiniam waka atsawai. Aya Wiki, nayaimpinmaya̱ taran Aents Ajasu asan, túraitjai. Tura Wikia nayaimpinmaya̱itjai. ");
INSERT INTO jivNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tura Winiasha, Aents Ajasu aiṉ, mantuawartatui. Iis, yaunchu Israer-shuar atsamunam wekainiak napiji̱a̱i̱ ti jáiniakui tuke tsuamarti tusa Muisais napin jirú najana yakí numiniam awajaimiayi. Núnisnak Wisha awajnitniuitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Núja̱i̱ṉkia ashí Winia enentáimturna nuka jinium wétsuk Yusa̱i̱ tuke iwiaaku pujustatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yuska ashí shuaran ti anea asa, ni Uchiri̱n chikichik ana nuna shuáran uwemtikrarat tusa tsaṉkatkamiayi. Ashí shuar Nin enentáimtana nu, jinium wécharat tusa, antsu Yúsnum tuke iwiaaku pujusarat tusa ni Uchirí̱n akúpturmakmiaji. ");
INSERT INTO jivNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yus áentsun kajerak jinium surukat tusa ni Uchirí̱n akupkachmiayi. Antsu uwemtikrarat tusa akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yusa Uchirí̱n enentáimtana nuka jinium peṉké surunkashtiniaiti. Tura Nin enentáimtatsna nuka, Yusa Uchirí̱n chikichik ana nuna enentáimtachu asa, páchitsuk jinium surukmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yusa Uchiri̱ tsáapninia áintsaṉ ii tunaari̱ paant awajturmaji. Nu tsáapnisha ju̱ nuṉkanam táraiti. Shuar tunáa ti tura ásar tsáapninian nakitrar kiritniun wakeriarmai. Nuna tura ásar jinium surunkaruiti. ");
INSERT INTO jivNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ashí tunaan túruinia nuka tsáapninian muíjiainiawai. Túrawar yupitiainiawai ni tunáa túramu paant ajasa̱i̱ tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Antsu ashí nekas túratniun umiiniana nuka tsáapninian weantainiawai. Yus ni enentái̱ pujuram tsáapninium takainiawai. Nuka ti paantaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nuyá Jesussha ni unuiniamuri̱ji̱a̱i̱sha Jutía nuṉkanam wear nui̱ pujusar imiakratiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juaṉsha Enuṉ nuṉkanam, Sarim tíjiu̱chia nui̱, imiakratuk pujumiayi entsa nui̱ núkap aa asamtai. Tura aents táarmatai imiainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nu̱sha Juáṉkan sepunam eṉkenatsa̱i̱ṉ túrunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tura Juaṉka unuiniamuri̱ Israer-shuarja̱i̱ jianaiktinian naṉkamawarmiayi. “¿Ya imiakratma imiá péṉkerait?” tusar áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juáṉkai̱ inintrustai tusar wéarmiayi. “Uunta, ame nuik Jurtaṉ entsa amain pujakum shuar nui̱ pujá “nú̱iti Yusa Murikri̱” tíchamkum. Yamaikia imiakratui tura ashí shuar Nin nemarainiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tutai Juaṉ tímiayi “Ashí kakarmaka aya Yúsai̱ya̱ṉchakait. ");
INSERT INTO jivNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wisha paant tímiajai “Wikia Krístuchuitjai antsu ni jinti̱n iwiarat tusan emka akupkamuitjai.” Nusha antukmarme. ");
INSERT INTO jivNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kame shuar nuwa̱n nuatna nuna áishrinti. Nuatnaiyak áishmaṉ nuwe̱ja̱i̱ áujnainiakui, ni amikri̱sha nuna antuk ti waraatsuk. Wisha núnisnak aents Jesusai̱ wénakui ti waraajai. ");
INSERT INTO jivNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Niisha tuke naṉkaamaku uunt ajastiniaiti antsu wikia tuke tímiancha ajastiniaitjai.” Juaṉ tu chichasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nayaimpinmaya̱ tara nuka ashí naṉkaamakuiti. Nuṉkaya̱ nuka, nuṉkaya̱ asa jú̱ nuṉkanmaya̱nak áujmatui. Nayaimpinmaya̱ tara nuka ashí naṉkaamakuiti ");
INSERT INTO jivNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","tura nui̱ antukmancha íismancha áujmatui. Túrasha ni chichame̱n ántuiniatsui. ");
INSERT INTO jivNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Antsu ni chichame̱n ántana nuka “Yusa chichame̱ imiá nekasaiti” tawai. ");
INSERT INTO jivNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yus akupkamuka Yusa chichame̱n étserui. Yuska ni Wakaní̱n ementutsuk susa asamtai tu étserui. ");
INSERT INTO jivNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yus Apa ni Uchirí̱n anea asa ashí ana nuna iistí tusa ataksaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Shuar Yusa Uchirí̱n enentáimta nuka yamaram iwiaakmanum akiinia asa tuke Yusai̱ shiir pujustiniaiti. Antsu Yusa Uchirí̱n enentáimtatsna nuka nu iwiaakmanum akiiniachuiti antsu Yus tuke nin kajerkaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","“Jesus untsurí̱ shuaran ni nemarin awajeawai; kame Juaṉja̱i̱ naṉkaamas untsurí̱ imiaawai” taman Pariseu shuar antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nekaska Jesus imiakratchamiayi, antsu ni unuiniamuri̱ túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pariséu nu chichaman antukarman Jesussha nekáa Jutía nuṉkanmaya̱ jiinki Kariréa nuṉkanam waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wáketuk Samaria nuṉkanmaani̱ naṉkaamaktiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria nuṉkanam wéak Sekar péprunam jeamiayi. Nu pepru jeastatuk Jakupa nuṉke̱ ámiayi. Jakupsha nu nuṉkan ni uchirí̱n Jusen tí yaunchu susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nui̱sha yumirmat ámiayi. Jakup taurma asamtai “Jakupa yumirmatri̱” tiarmiayi. Tutupin jeamtai Jesussha pimpiki winis yumirmat ayamach pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nui̱ pujai̱ Samarianmaya̱ nuwa̱ yumí shikiktajtsa támiayi. Tura Jesus “Entsa surusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jesusa unuiniamuri̱sha yurumkan péprunam sumaktajtsa wéaru asamtai aya Jesusak pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samarianmaya̱ nuwa̱ Jesusan tímiayi “¿Itiura Israer-shuaraitiatmesha Samarianmaya̱ nuwa̱ a̱i̱sha entsa seatam?” Kame Israer-shuar Samarianmaya̱ shuarja̱i̱ṉkia peṉké chichachu ásar nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesussha tímiayi “Yus súamu nékakmeka tura entsa surusta tájam nusha nékakmeka ame antsu seattínme tura Wikia iwiaaku entsan amasaintjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nuwa̱sha tímiayi “Uunta, entsasha ti initiaiti tura shikiktincha takaktsume. ¿Tuyaṉ iwiaaku entsasha surustam? ");
INSERT INTO jivNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ii uuntri̱ Jakup ju̱ yumirmatan taur ju̱ya̱nak niisha ni uchirí̱sha ni waakarí̱sha umararmiayi. Nuyá ikiurtamkimiaji. ¿Amesha Jakupja̱i̱ naṉkaamas kakarmakaitiam?” ");
INSERT INTO jivNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesussha tímiayi “Ashí shuar ju̱ entsan umarka ataksha kitiamtiatui. ");
INSERT INTO jivNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Antsu Wi súajna nú entsan umarka peṉké kitiamchattawai. Antsu nu entsa Wi susamuka ni enentái̱n púkunia áintsaṉ tuke pajamtiatui nuja̱i̱ tuke iwaaku pujustí tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tutai nuwa̱ tímiayi “Uuntá, winiasha nu entsa surusta. Wisha kitiamcha átaj. Tura ju̱ entsancha shikiktinian táchataj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nuya̱sha Jesus tímiayi “Áishrum untsukam utitia, turam ju̱i̱ tatá.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nuwa̱sha “Winia áishur atsawai” tímiayi. Tutai Jesus tímiayi “Maa, nekas tame. Áishrum atsawai. ");
INSERT INTO jivNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kame ame áishrum seṉku (5) takusuitme. Yamái takakmena nusha ame áishrumchaiti. Nekas tame.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nu̱na antuk nuwa̱sha tímiayi “Uunta, ame Yúsnan etserniuchukaitiam. ");
INSERT INTO jivNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ii úuntri̱ṉkia tuke Samarianam pujuarmia nu jú̱ nainnium Yúsan tikishmatrarmiayi. Antsu átum Israer-shuar árumna nu aya Jerusaréṉnum Yus tikíshmátratniuiti tárume.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus tímiayi “Nuwá, enentáimsata. Tsawant jeattawai átum jú̱ náinniumsha tátsuk tura Jerusaréṉnumsha wétsuk Yus Apa tikishmatratin. ");
INSERT INTO jivNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Átum tikishmatrum nuka nékatsrume. Iikia tikishmatrajnia nu nékaji. Israer-shuarnumia̱ Uwemtikkiartin winiakui nékaji. ");
INSERT INTO jivNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tsawant winittiana nu yamái jeayi. Ashí shuar Yus Apan nekas tikishmatainiakka tuke wakanja̱i̱ tuke enentáiji̱a̱i̱sha awajitsuk tikishmatrartatui. Núnisaṉ tikishmatrurat tusa wakerawai Yus Apa. ");
INSERT INTO jivNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yuska Wakaniiti tura ashí Nin tikishmatainia nuka tuke wakaní̱ji̱a̱i̱ tura tuke enentái̱ji̱a̱i̱ awajitsuk tikishmatratin áiniawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nuwa̱sha tímiayi “Anaikiamua nu tátiniaiti. Nusha Krístuiti. Niisha taa ashí jintintramattaji.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus tímiayi “Wiitjai. Ámin chichaajmena nú Kristuitjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nuiṉ ni unuiniamuri̱ táarmiayi tura nuwa̱ja̱i̱ chichaa pujan wáinkiar ti enentáimprurarmiayi. Tumaitiat “¿Warí wakerakmea nuwa̱ja̱i̱ chichaam?” títinian arantukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nuya̱ṉka nuwa̱ ni yumiri̱n ikiuki péprunam we ashí áentsun tímiayi ");
INSERT INTO jivNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Winiirum íitiarum, shuar ashí wi túramun túruta nu. ¿Juka Krístuittiya?” ");
INSERT INTO jivNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tutai péprunmaya̱ jíinkiar Jesus pujamunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jeainiatsa̱i̱ṉ ni unuiniamuri̱ seak tiarmiayi “Uunta, yurumáta.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tura Jesus tímiayi “Wi yúatniunka takakjai átum nékachman.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ni uniuniamuri̱sha nuámtak anniasarmiayi “¿Chíkich shuar yurumak itiarím tátsuash?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tura Jesus tímiayi “Winia akuptukua nuna wakeramuri̱ túrakun tura ni takatri̱n takaakun Wíji̱a̱i̱ṉkia yurumátniua áintsaṉ ikiakáatui. ");
INSERT INTO jivNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Átumka “Tuke kuatru nantu árak júuktin taasai” tátsurmek. Túrasha Wi tájarme, shuar wininia nu iistarum. Yus-Chicham ni enentái̱n araamuiti. Tura júuktin tsawant jeayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Arakan júaka akinkiatniuiti. Júukmataisha nu shuar uwemprar tuke iwiaaku pujusartatui. Núnisaṉ arakan araana nusha júana nusha mai metek warasartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tiniu armia nuka nekasaiti: “Chikichik araawai chíkichcha júawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iis, chíkich araakmamu júuktinian akupkaitjarme. Átum araachiatrumek chíkich takasmanum atumsha pachiintiukuitrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tura núwa̱ka péprunam jeá “Ashí wi túramun ujatkayi” takui untsurí̱ shuar Jesusan ti shiir enentáimtusarmiayi. Niisha Samarianmaya̱ shuar ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nu asamtai ashí Jesusa̱i̱ taar niiji̱a̱i̱ pujusát tusa seawarmiayi. Tutai Jesus jimiará tsawant nui̱ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nú shuar untsurí̱ ni chichame̱n antukar Jesusan ti shiir enentáimturarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nuyá nuwa̱n tiarmiayi “Yamaikia aya ame chichammiji̱a̱i̱ṉ Jesus enentáimtatsji antsu imia iisha ni chichame̱n anturkaji. Tura nékaji nekas Krístuiti, ashí shuaran Uwemtikin.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jimiará tsawant naṉkaamasmatai Jesus Samaria nuṉkanmaya̱ jiinki Kariréa nuṉkanam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kariréasha Jesusa nuṉke̱ asamtai, ai̱ṉsha Jesus timia áintsaṉ ámiayi: “Yúsnan etserniun ashí shuar péṉker anturainiawai antsu nuna nuṉke̱ya̱ṉka nin anturainiatsui.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tuma aiṉ Kariréa nuṉkanam jeamtai auya̱ shuarsha Jerusaréṉnum paskua námpernum wearu ásar tura ashí ni túramun nui̱ wainkia ásar ti shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nuyá Jesus Kaná péprunam atak támiayi. Nu péprunmasha nuik Jesus yumin umutai awajsamiayi. Jesussha nui̱ pujai̱ yajá péprunam Kapernáumnum akupniu takari̱n ámiayi. Ni uchirí̱sha jaa tepemiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Niisha Jesus Jutíanmaya̱ Kariréa nuṉkanam taman antuk Jesusa̱i̱ wémiayi. Tura ni uchirí̱ jákatin tepakui ni je̱e̱n we ni uchirí̱n tsuarat tusa Jesusan seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesussha tímiayi “Aya aents túrachminian túrakui íisrum aya nú̱ja̱i̱ṉ Winia enentáimtarme.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tura takari̱n tímiayi “Uunta, winia uchir jáatsa̱i̱ṉ wari winitia.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nuiṉkia Jesus tímiayi “Je̱e̱mi̱i̱n waketkitia. Yamaikia ame uchiram péṉker ajasai.” Tutai nú aishmaṉ Jesus táman antuk wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ni je̱e̱n jeátemámtai ni takarniuri̱ iṉkiuṉ tiarmiayi “Yamaikia uchiram péṉker ajasai.” ");
INSERT INTO jivNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Apasha inintrusmiayi nantu urukaim péṉker ajasma. Niisha tiarmiayi “Yau, nantu pukuntamtai, tsuemun michatramai” tiarmiayi. Nuna antuk uchí aparí̱sha enentáimsamai. ");
INSERT INTO jivNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nantu pukunta a̱i̱ Jesus “Ame uchiram péṉker ajasai” timia nuní ai̱ṉ michatraiti. Tuma asamtai niisha ashí ni shuari̱sha Jesusan nekas enentáimturarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus nu̱ túramuja̱i̱ ni kakarmari̱n jimiará iniakmasmiayi. Nunasha Jutíanmaya̱ jiinki Kariréa nuṉkanam jeá túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nu naṉkaamasmatai, Israer-shuar namperan najanainiakui Jesus ataksha Jerusaréṉnum waketkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusarén yama wa̱ya̱munam murik wa̱ya̱tin waiti tíjiu̱ch amia nui̱ entsa pajamtai jeammauyayi. Nu pajamtain Petesta tiarmiayi. Nuna wáitiri̱sha seṉku (5) ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nui̱ untsurí̱ jáiniak nuṉkanam tepearmiayi. Kusurusha shutuapsha tampemakusha tepesar entsa miartukat tusa nákasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kame ni tátaj taku Yusa suntari̱ táuyayi entsan umuchkiattsa. Nuya̱ṉka emka shuar entsá wayá nu ni jáamuri̱ya̱ tsuámarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Áishmaṉ traintiúchu (38) uwi jaa tepá nui̱ ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesussha nu shuaran nui̱ tepan wáinkiámiayi. Tura untsurí̱ uwitin jaa tepan nekáa aniasmiayi “¿Shiir ajastiniak wakeram?” ");
INSERT INTO jivNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tutai jaasha tímiayi “Uunta, entsa muchitkiui ¿winia yaki eṉkétát? Kame wi eṉkemátaj tai chíkich emka eṉkemáiniawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nuyá Jesus tímiayi “Nantaktia. Ame peakrum jukim wetá.” ");
INSERT INTO jivNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nu chichamtaik áishmaṉ shiir ajasmiayi. Tura ni peakri̱n jukí wémiayi. Nusha ayampratin tsawantai̱ túrunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tuma asamtai Israer-shuar shiir ajasun tiarmiayi “Yamái ayampratin tsawantaiti. Peakrum júkishtiniaitme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Áishmaṉsha tímiayi “Winia tsuara nu “Peakrum jukim wetá” turutni” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nuiṉkia aniasarmiayi “¿Ya “Peakrum jukim wetá” túramam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tura áishmaṉsha Nin tsuárun nékachmiayi. Untsurí̱ shuar nui̱ aa asamtai tura Jesus weu asamtai nin nekaachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Atak Jesus Yusa Uunt Je̱e̱n áishmaṉkan wáiniak tímiayi “Antukta. Yamaikia shiir ajasume. Atak tunáa túrawaip; nu arant ajasáim” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nuiṉkia áishmaṉ Jesus nin tsuárman nekáa Israer-shuaran ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tuma asamtai ayampratin tsawantai̱ túramtai Israer-shuar Jesusan maatai tusar áintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tura Jesus tímiayi “Wina Apar tuke yamaisha takawiti. Núnisnak Wisha takaajai.” ");
INSERT INTO jivNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tutai Israer-shuar nuna naṉkaamas maatai tusa wakeriarmiayi. Ayampratin tsawantai̱ takaakui kajerkarmiayi. Tura nu arantcha “Yus winia Aparuiti” takui Yusja̱i̱ métek enentáimtumawai tusar nu arant kajerkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nuyá Jesus tímiayi “Ti nekas tájarme, Yusa Uchirí̱ṉkia ni enentái̱ji̱a̱i̱ṉ takaatsui. Antsu aya winia Apar takaana nuna íisan métek takaajai. Ashí winia Apar túramun Wisha ni Uchirí̱ asan métek takaajai. ");
INSERT INTO jivNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni Uchirí̱ asamtai winia Apar anentui tura ashí tura nuna iniakturui. Tura nuna naṉkaamas tujinkiamnian iniaktursattawai Wisha túratniun. Tura nuna túrakui ashamkattarme. ");
INSERT INTO jivNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Winia Apar jakamunmaya̱n iwiaaku ajasat tusa Ni wakerana nuna inianteatsuk. Núnisnak, ni Uchirí̱ asan, Wi wakeraj nuna iwiaaku awájsámniaitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Winia Aparka súmamtiktsui antsu shuar súmamtikiatniun ni Uchirí̱n súsaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tuma asamtai ashí shuar Yus Apan shiir awajainia áintsaṉ ni Uchirí̱ncha métek shiir awajsatin áiniawai. Yus Apa ni Uchirí̱n akupka asamtai, Uchin shiir awajeatsna nuka Yus Apancha shiir awajeatsui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Ti nekasaiti. Winia chichamprun ántana nú shuarka Winia Akuptukun enentáimtak ni iwiaakmari̱n tuke amuukashtinian takakui. Nu shuarsha aya̱shí̱ iwiaakuitiat jákauyi antsu yamái nekas iwiaakuiti. Tuma asa sumamashtatui. ");
INSERT INTO jivNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ti nekasaiti. Tsawant winittiana nu jeayi. Nu tsawant jaka ainia nu Wi untsumman antukar umirkarka iwiaaku ajasartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iis, winia Apar iwiaaku awajsatniun takakui. Tura Winiasha, ni Uchirí̱ asamtai, iwiaaku awajsatniun surusuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nu arantcha wi Aents Ajasu asamtai, shuaran súmamtikiatniun surusuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ju̱ chicham itiurchataiti” enentáimprairap. Atak tsawantai̱ wi untsumman ashí jákaru ainia nu antukartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tura ashí iwiarsamunmaya̱ jíinkiartatui. Péṉker túrawarusha nantakiar tuke iwiaaku pujusartatui. Antsu tunáa túrawarusha nantakiar jinium surunkartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‘Imia Wíki takaatsjai. Antsu Yus tana núnisnak súmamtikeajai. Wi wakeraj nuna enentáimtsuk antsu winia Apar wakera nuna wakerukan, Nii akupta asamtai, awajitsuk súmamtikjai. ");
INSERT INTO jivNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Aya Wiki “Yúsai̱ya̱itjai” tákunka winia chichamur ántar ainti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Chikichcha awai. Niisha “Yúsai̱ya̱iti” túrutui. Ni chichame̱sha imiá nekasaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Atumsha Juaṉkai̱ wi túramu inintrusmarme tura nii timia nu nekasaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tuma aiṉ aents táman atsumatsjai. Antsu Juaṉka chichame̱ enentáimkiuram uwempratarum tusan tájarme. ");
INSERT INTO jivNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juaṉsha jiya núnis keemai. Atumsha ishichik tsawantin nú tsáapninnium warastin enentáimpramarme. ");
INSERT INTO jivNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tura Winia “Yúsai̱ya̱iti” túrutna nu, Juaṉja̱i̱ naṉkaamas péṉkeran takakjai. Wi takasma núiti. Winia Apar takastinian surusma nuna takaakun nuja̱i̱ páantaiti Yus Apa akupkamuitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Winia Aparsha, akuptuku asa, ayamprutui. Túrasha átumka ni chichame̱sha antukchaitrume tura wáintiash wáinkiachuitrume. ");
INSERT INTO jivNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yus Apa akuptukuiti. Tuma asamtai Winia enentáimturchakrum winia Aparu chichame̱sha atumi enentái̱n waya̱chuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Átumka Yus-Chicham yaunchu aarma nui̱ iwiaaku átinian wáinkiataj tusarum ti unuimiaruitrume. Nu chichamsha Wínian áujmatui. ");
INSERT INTO jivNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tuma aiṉ nekas iwiaaku átaj tusarum Winí tátin nakitiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Shuar Winia “shíiraiti” túrutainiakuisha nuna páchiatsjai. ");
INSERT INTO jivNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Maa, Wi nékajrume. Átumka Yus aneatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Winia Apar akuptukmatai táwitjai túrasha nakitrarme. Antsu chíkichka ní enentái̱ji̱a̱i̱ṉ jeartamkuiṉkia nuka átum wakerarme. ");
INSERT INTO jivNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Átumka nuámtak “Shiir enentáimtursatí” tu enentáimtunaiyarme. Tura Yus enentáimturma nuka páchiatsrume. Nú̱ja̱i̱ṉkia ¿itiurak Yus enentáimtustam? ");
INSERT INTO jivNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ii tunaari̱n Yusai̱ etserturmaktatji” turutiirap. “Muisais akupkamun umirkan uwemprattajai” tátsurmek. Antsu Muisais aarma nuja̱i̱ atumí tunaari̱ etsernaktatui. ");
INSERT INTO jivNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Iis, Muisais Winia áatrurmiayi. Atumsha ni timia enentáimtakrumka Winiasha enentáimturaintrume. ");
INSERT INTO jivNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tura ni aarma enentáimtachkurmeka ¿itiurak wi tama enentáimtustarum?” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nu naṉkaamasmatai Jesus Kariréa antumiaṉnum amain katiṉmiayi. Nu antumiaṉsha Tipirias antumiaṉ tuiniawai. Jimiará náartiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Untsurí̱ shuar Jesus ti jáinian timiá wárik tsuan wáinkiaru ásar Nin nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Israer-shuara paskuanamperi̱ ishichik ajasmatai Jesussha ni unuiniamuri̱ji̱a̱i̱ náinnium waka nui̱ pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesussha untsurí̱ aents wininian wáiniak Jiripin tímiayi “Timiá untsurí̱ shuar ayuratniusha ¿tuyaṉ yurumak sumaktajⁱ?’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kame Jesuska Nii túrattana nuna neka asa Jiripi warittiṉ tusa tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jiripisha nuyá tímiayi “Timiá nukap kuitja̱i̱ tanta sumakmesha ashí ishichik susamsha jeachaintjia̱” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nuyá chíkich unuiniamuri̱ Antres, Pitru yachi̱, tímiayi ");
INSERT INTO jivNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Uchi ju̱i̱ seṉku (5) tantan jimiará namakja̱i̱ takakui. Ausha timiá untsurí̱nmasha jeatpiash” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nuya̱ṉka ““Ashí pujustarum” titiarum” tímiayi Jesus. Áishmaṉsha nuwa̱sha uchisha irunmiayi. Tura chírichri núkap aa asamtai nui̱sha seṉku mir (5.000) áishmaṉ pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesussha nu tantan achik Yúsan yumiṉkias ni unuiniamuri̱n susamiayi. Niisha ashí nui̱ pujuinian súsarmiayi. Namaknasha núnisaṉ ashí ni wakeriarmiania nuna súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jémararmataisha Jesus ni unuiniamuri̱n tímiayi “Ampirma júukrum chaṉkinnium chumpiatarum. Wasúrnáka̱i̱ṉ.” ");
INSERT INTO jivNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Niisha seṉku (5) tantanmaya̱ ampirman júukar tuse (12) chaṉkinnium áimkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nu shuarsha Jesus túramun íisar tiarmiayi “Ju̱ nekas Yúsnan etserin tátinia núchakait.” ");
INSERT INTO jivNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Shuar Jesusan uunt akupin awajsataj tutai Jesus nekáa Niṉki náinnium wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kí̱akui Jesusa unuiniamuri̱ antumiaṉnum wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Káshisha Jesus tuke táchamtai uunt kanunam eṉkemáwar Kapernáum péprunam wéenak jíinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tura nase ti umpúakui chíchimi ti wajaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ajapén ajasar Jesus entsá pátatek nanamas tíjiu̱ch winian wáinkiar ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tura Jesus “Wiitjai. Ashamprukairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Núja̱i̱ṉkia ti shiir warasar kanunam itiaawarmiayi. Tura nu chichamtaik ni wéamunam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kashincha chíkich shuar amain ayuramunam kanararu nekaawarmai. Jesusa unuiniamuri̱ Jesusja̱i̱nchu chikichik kanu amia nuja̱i̱ wéarun nekaawarmai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nui̱ chichak matsata̱i̱ Tipirias péprunmaya̱ chíkich kanu táarmiayi. Yau Jesus Yúsan yumiṉkias tantan ayuramunam tíjiu̱ch táarmatai ");
INSERT INTO jivNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","nu shuar, Jesussha ni unuiniamuri̱sha nui̱ atsuiniakui, nu kanunam eṉkemáwar Kapernáum péprunam Jesusan e̱áktajtsa wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Entsa amain Jesusan wáinkiar aniasarmiayi “Uunta, ¿urutía jui̱sha támam?” ");
INSERT INTO jivNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesussha tímiayi “Ti nekas tájarme. Aents tujintiamu nekáa asarum é̱a̱tsurme. Antsu tanta yuarum jémaru asarum é̱a̱trume. ");
INSERT INTO jivNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ju̱yá yurumak amuukatin asamtai ti pachisairap. Antsu amuukashtin yurumak tuke iwiaaku pujustinian amaana nu takarsatniuiti. Nú yurumkanka Wi, Aents Ajasu asan, susattajrume. Yus Apa nuna túratniun surus “Ju̱ka shuáran Yáiṉkiartiniaiti” túrutui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tutai inintrusarmiayi “¿Warí túratniuitiajⁱ Yus wakerana nu umiktin?” ");
INSERT INTO jivNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesussha tímiayi “Yus akupta asa Winia enentáimtursarat tusa wakerawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tutai aniasarmiayi “¿Aentsti tujintiamuka warí túrattam ii íisar Ámin nekas enentáimtustin? Chikichcha túratá. ");
INSERT INTO jivNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yaunchu ii uuntri̱ aents atsamunam maná yurumkan nayaimpinmaya̱ susamun yurumáwarmiayi. Yus-Chichamnum núnik áarmaiti: “Nayaimpinmaya̱ yurumkan Yus susamiayi.” Tu áarmaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesussha tímiayi “Wi tájana nu nekasaiti. Muisais atumí úuntri̱n nayaimpinmaya̱ yurumkan súsachmiayi. Antsu winia Apar yamái nekas apatkun nayaimpinmaya̱ súramui. ");
INSERT INTO jivNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Iis, Yusai̱ya̱ apatkunka, nayaimpinmaya̱ tára nu súramui tura nekas apatuk asa ashí shuaran nekas iwiaakman súawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tutai “Uunta, nu apatuk tuke amasta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tura Jesussha tímiayi “Wiitjai nu apatuk nekas iwiaakman súana nu. Winí winiana nú shuar peṉké tsukamashtatui, tura Winia enentáimturna nusha tuke kitiaarchattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Túrasha wi túramu wáinkiurmesha winia chichamur enentáimtatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ashí shuaran winia Apar tsaṉkatrukarmiania nu, Wíi shuar ajasartatui. Winin winiana núnaka peṉké nakitrashtatjai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wi wakeraj nuna túratniun táchaitjai antsu Winia akuptukmia nuna umirkatniun táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Winia Apar akuptukuiti tura ju̱na wakerawai. Ashí winia tsaṉkatrukman emeṉkátsuk amuukatin tsawantai̱ iniantkiarat tusa wakerawai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yus Apa wakerana nu jú̱iti. Ashí shuar Winia “Yusa Uchiri̱nti” tu enentáimturkui yamaram iwiaakman tuke takusat tusa wakerawai. Nú shuarnaka amuukatin tsawantai̱ iniantkittiajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tura Jesus “Wiitjai, nayaimpinmaya̱ apatuk akupkamu” takui Israer-shuar Jesusan áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tura tiarmiayi “Ju̱ Jesuschakait, Jusé uchirí̱ya nu. Iikia ni aparí̱sha nukurí̱sha nékatsjik. ¿Itiurak “Nayaimpinmaya̱ táraitjai” ta?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesussha tímiayi “Tu áujmatrukairap. ");
INSERT INTO jivNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Shuáran winia Apar akúpturkachuitkiuiṉkia peṉké weanturkachainti. Tura Winia akupturna nuna amuukatin tsawantai̱ iniántkíttiajai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yúsnan etserniu áarmari̱n tawai “Ashí Yus jintintiamu ártatui”. Núnisaṉ ashí Yusa chichame̱n antukar unuimiatainiakka Winí táiniawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‘Aya Wiki Yúsai̱ya̱ tau asan Yúsan wáinkiaitjai. Chíkichka peṉké wáinkiachuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ti nekas tájarme. Winia enentáimturna nú shuarka yamaram iwiaakman amuukashtinian takakui. ");
INSERT INTO jivNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wikia iwiaakman súana nú apatkuitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Iis, atumí uuntri̱ aents atsamunam maná yurumkan yúawariatcha ashí jákarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Antsu Wi tájana nú apatkun shuar yúakka jákachartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wikia nayaimpinmaya̱ iwiaaku apatkuitjai. Nu̱ apatkun shuar yuakka tuke iwiaaku átiniaiti. Nu apatkun Wi susattaj nusha winia a̱ya̱shruiti. Ashí shuar Yusai̱ iwiaaku pujusarti tusan winia a̱ya̱shrun susattajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nuyá nuámtak áujmattsar tiarmiayi “¿Itiurak ni a̱ya̱shi̱nkesha ayurtamattajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesussha tímiayi “Ti nekas tájarme, Wi Aents Ajasu asamtai winia a̱ya̱shur yúatniuitrume. Winia a̱ya̱shur yúachmeka tura winia numpar umarchamka nekas iwiaaku pujatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Winia aya̱shrun yúana nuka tura winia numparun úmakka yamaram iwiaakman amuukashtinian takakui. Tura nu shuaran amuukatin tsawantai̱ iniántkíttiajai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Winia a̱ya̱shruka nekas yurumkaiti tura winia numparsha nekas umutainti. ");
INSERT INTO jivNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Winia a̱ya̱shruncha yúaka tura winia numparnasha úmaka Wiji̱a̱i̱ tsaniṉ pujawai tura Wisha nu shuarja̱i̱ tsaniṉkian pujajai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yus Apa, Winia akuptukuka, nu iwiaakma nérenniuiti. Tuma asamtai ni iwiaakmari̱i̱n iwiaaku pujajai. Núnisaṉ Winia yurakka winia iwiaakmarui̱ iwiaaku pujustatui. ");
INSERT INTO jivNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nayaimpinmaya̱ apatkun tajai. Ju̱ apatuk maná yurumka áintsachuiti. Atumí uuntri̱ maná yurumkan yuawarsha ashí jákarmiayi. Antsu ju̱ apatkun shuar yúakka tuke iwiaaku pujustatui” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Núnaka Jesus Israer-shuar iruntainiam unuiniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nu̱ chichaman antukar Jesusa unuiniamuri̱ chicharainiak “Nii tana nu ti itiurchat asamtai ¿yaki antukminiait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesussha ni áujmatman nekáa tímiayi “Átum “ju̱ chicham itiurchataiti” tárumek. ");
INSERT INTO jivNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wátsek, Wi nayaimpiniam pujumiaj nui̱ waketkimtaisha ¿urukawaintrumek? ");
INSERT INTO jivNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Warí, aya wakanik iwiaakman súwaiti. Aya̱shkia peṉké áantraiti nekas iwiaaku awajsatniun. Wi tájana nuja̱i̱ imiá nekas wakankia iwiaaku awajsamniaiti” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tura Jesus Nin enentáimtachun tura Nin suruktatna nunasha yaunchu neka asa ni unuiniamuri̱n tímiayi “Atumí̱i̱ncha winia chichamprun enentáimtachu tuke awai. ");
INSERT INTO jivNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nu asamtai tímiajrume “Shuáran winia Apar akupturkachmaitkiuiṉkia peṉké weanturkachainti” tímiajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nuya̱sha ni nemarniuri̱ untsurí̱ armia nu Jesusan ikiukiar atakka Niiji̱a̱i̱ wekasacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nuyá Jesus ni tuse (12) unuiniamuri̱n chicharainiak “¿Atumsha wétin wakerarmek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Semuṉ Pítrusha ái̱kmiayi “Uunta, ¿yáiniṉ wetajⁱ? Ame chichammiji̱a̱i̱ṉ nekas iwiaaku áminiaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ame Kristu asam nekas iwiaaku Yusa Uchirí̱nme. Nuka enentáimtusar ti paant nékaji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesussha tímiayi “Ashí tuse (12) árumna nu achikiuitjiarme nekas Wíi shuar ajastin. Tuma aiṉ atumí̱i̱n chikichik iwianchiiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nuna taku Jútas Iskariútin, Semuṉka uchirí̱n, enentáimtus tímiayi. Jútassha ni unuiniamuri̱ntiat Jesusan ukunam surukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nu naṉkaamasmatai Jesus Kariréa nuṉkanam wekaimiayi. Jutía nuṉkanam wéchamiayi Israer-shuara uuntri̱ nui̱ máataj tutai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tura Israer-shuar aak aakmatai namperi̱ jeatemamtai ");
INSERT INTO jivNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesusa yachi̱ wishikiainiak tiarmiayi “¿Urukamtai ju̱i̱sha pujam? Jutía nuṉkanam wetá, a̱i̱sha ame unuiniamuram túram nuna íisarat. ");
INSERT INTO jivNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ashí shuar nekaawarat tákumka ú̱u̱kam túrawaip. Ti tujintiamu túriniaitkiumka ashí shuar íimmianum túratá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ni yachi̱sha ishichkisha Nin enentáimtachu ásar tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tura Jesus tímiayi “Winia tsawantur nampernum wétin jeatsui. Atumja̱i̱ṉkia náṉkamas tsawant wétin péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ju̱ nuṉkanmaya̱ aents atumniaka kajertamatsrume. Antsu ni tunaari̱n etsertin asamtai Wíniaka kajertuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Átumka nampernum wetarum. Wikia tsawantur jeachkui wéatsjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ju̱na tinia Jesuska Kariréa nuṉkanam juákmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ni yachi̱ wearmatai Jesussha nampernum wémiayi. Tura nekarawara̱i̱ṉ tusa ú̱u̱mak wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israer-shuara úuntri̱sha námper irunturmanum e̱a̱kar “Nu aishmaṉsha ¿tuiṉ pujá?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ashí shuarsha Nin áujmatiarmiayi. Chíkich “péṉkeraiti” tiarmiayi. Tura chikichcha “Péṉkerchaiti. Aya anaṉkartawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tura Israer-shuara úuntri̱n ashamainiak u̱u̱k áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nampersha ajapén ajasmatai Jesus Yusa Uunt Je̱e̱n wayá shuáran unuiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israer-shuara úuntri̱sha nuna íisar ti enentáimsar chichaak “Ju̱sha unuimiátrachiatcha ¿itiurak imiá neka?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesussha tímiayi “Wi unuiniajna nu winia chichampruchuiti antsu Winia akuptukua Núnan unuiniajai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yus wakerana nuna shuar nekas umiktinian wakerakka winia chichamprun nekaattawai. Nekas Yúsnaitkiuiṉkia, nuna nekaattawai. Aya wi enentáimmiaja̱i̱ṉ chichaakuisha, nuna nekaattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ni enentáimmiaja̱i̱ chichaana nuka ashí shiir enentáimtursarti tusa chichaawai. Antsu nin akupka nuna shiir awajsarti tusa wakerak, nekas wáitratsuk tawai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muisais Yusa akupkamuri̱n atumí uuntri̱n amaschamka. Tuma aiṉ nu umitsuk mantuatin wakerutarme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nu shuarsha tiarmiayi “Wáurtsumek. ¿Ya mantamataj tusa wakera?” ");
INSERT INTO jivNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesussha tímiayi “Ayampratin tsawantai̱ chikichkí túramtai ti enentáimtsurmek. ");
INSERT INTO jivNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muisais ashí tsupirnaktinian akupkachmiayi. Antsu ni uuntri̱ṉkia nuna akupka áiniawai. Tuma ai̱ṉ átumka Muisais akupkamu umiktai tusarum ayampratin tsawantai̱sha uchi áishmaṉ tsúpirnaitrume. ");
INSERT INTO jivNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wátsek, Muisais akupkamu uminkiati tusarum ayampratin tsawantai̱sha uchi áishmaṉ tsúpirkurmekaka ¿urukamtai Wi ayampratin tsawantai̱ áishmaṉka aya̱shí̱ takamtsuk tsuármatai kajertarum? ");
INSERT INTO jivNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Shuar túrana nu íisam wárik súmamtikiawaip. Antsu inintrúsam paant nekaam, nekasa nu enentáimtusta” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nuyá Jerusaréṉnumia̱ shuar tiarmiayi “Maatai tuinia núchakait. ");
INSERT INTO jivNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tura nui̱ ashí ántamunam étserui tura suntar páchiniatsui. ¿Ii uuntri̱sha “Nekas Krístuiti” tu enentáimtuiniawash? ");
INSERT INTO jivNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Antsu nekas Kristu taa tuyaṉ winiá nekanashtatui tura ju̱ pujamuka ashí nékaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus nuna antuk, Yusa Uunt Je̱e̱n wajá kakaram chichaak tímiayi “Winia nekararum tuyá winiaj nu nékarme. Kame núnisrum enentáimprume. Tura winia enentáirja̱i̱ táchaitjai antsu winia Apar akuptukuiti. Niisha ti nekas akupniusha átumka nékatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Antsu Winia akuptukuitkiui a̱i̱ya̱ tau asan Wikia nékajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nuyá sepunam eṉkeataj táyat achikcharmiayi ni tsawantri̱ jeachu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tura untsurí̱ shuar Nin enentáimtusar “Kristu ta ¿nuna naṉkaamas aentsti tujintiamun túratpiash?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pariséusha Israer-patri úuntri̱sha Jesusnan timian antukar suntaran akupkarmiayi Jesusan achikiar sepunam eṉkeawarat tusar. ");
INSERT INTO jivNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nuyá Jesussha tímiayi “Aya ishichik tsawant atumja̱i̱ pujustatjai. Nuyá ataksha Winia akuptuku pujana nui̱ waketkittiajai. ");
INSERT INTO jivNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Átumka e̱átkáttarme tura Wi wéajna nui̱ wéchamniaitkiuram wáitkiashtatrume.” ");
INSERT INTO jivNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Israer-shuarsha nuamtak aniniaisarmiayi “¿Ju̱sha tui̱ wéakuiṉ iisha wáinkiashtatajⁱ. Israer-shuar apachnium pujuinia nui̱ we apachin unuiniartatuak. ");
INSERT INTO jivNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nii timia nu itiurkit. “Átumka e̱átkáttarme tura Wi wéajna nui̱ wéchamniaitkiuram wáitkiashtatrume” tana nu itiurkit?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jista amúamunam ti shiir najanawarmia nu tsawantai̱ Jesus wajaki kakaram chichaak tímiayi “Shuar ni enentái̱n kitiamakka Winin taa umar kitiaké̱n imíkráti. ");
INSERT INTO jivNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Winia enentáimturna nuka ni enentái̱ya̱ entsa wa áintsaṉ yamaram iwiaakman súana nú entsa jiinkittiawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nuna taku Jesus “Ashí Yúsan enentáimtusarun Yusa Shiir Wakaní̱ súsatniuiti” tímiayi. Tura núnisaṉ Yus-Papiniumsha áarmaiti. Antsu Jesus tuke nayaimpiniam wéatsa̱i̱ṉ Yusa Wakaní̱ shuar súsachmauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chíkich shuarsha nuna antukar “Ju̱ nekas Yúsnan etserin tátinia núiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Chikichcha “Ju̱ka nekas Krístuiti” tiarmiayi. Tura chíkichkia Jesus Kariréanmaya̱iti tu enentáimiainiak tiarmiayi “Warí, ¿Kariréa nuṉkanmaya̱ Kristu áminkiait? ");
INSERT INTO jivNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yus-Papinium paant tawai “Krístuka yaunchu uunt akupin Tawit weeanmaya̱ akiiniatniuiti, tawai. Tura Tawitia pépruri̱ya̱ Piriṉnumia̱ átiniaiti” tawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tuma asamtai shuar niisháa niisháa enentáimprar kanakiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chíkich a̱i̱ya̱ nuka “sepunam eṉkeatai” tiarmiayi túrasha túracharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Suntarsha waketkiarmiayi. Tura Pariséusha Israer-patri uuntri̱sha “¿Urukamtai itiachuram?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Suntarsha tiarmiayi “Chikichkisha ju̱ áishmaṉ chichaa áanis chichaschaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nuyá Pariséu tiarmiayi “Atumsha anaṉnarume. ");
INSERT INTO jivNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pariséutisha uuntcha nuna enentáimtuiniawash. ");
INSERT INTO jivNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Peṉké shuarka yaunchu akupkamun nékachua nuka yajauchiniam yumiṉkramu áiniawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikiutémusha, kashi Jesusan tarimia nu, Pariséuitiat tímiayi ");
INSERT INTO jivNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ii shuartikia, shuar ni túramun etserkamu ántutsuk súmamtikiachminiaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nuiṉkia niisha tiarmiayi “Wats, amesha Kariréanmaya̱nchuashitiam. Yus-Chicham áujsam nekaattame. Kariréanmaya̱ Yúsnan etserin peṉké táiniatsui” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nuyá ashí ni je̱e̱n waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tura Jesuska Uriwiu náinnium wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tura kashin tsawar Yusa Uunt Je̱e̱n atak támatai ashí shuar Nin káutkarmiayi. Túrawarmatai Jesus pujus unuiniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nuyá Israer-shuara jintinniuri̱sha Pariséusha nuwa̱n wáinmakman Jesusan itiariarmiayi. Tura ashí iruntramunam ajapén awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tura Jesusan tiarmiayi “Uunta, ju̱ nuwa̱ tsanirma pujá achinkiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muisais akupkamunmasha nuna túraka “kayaja̱i̱ tukurar máatniuiti” tawai. ¿Amesha warintmea?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aya mamikmar nekapsatai tusar tiarmiayi. Nin sumamtikiatniun wakeriarmiayi. Nuyá Jesus tsuntsumá ni uwejé̱ja̱i̱ nuṉká áarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tura tuke iníam wajaki tímiayi “Ayu, atumi̱i̱ya̱ tunáa túrichu ákuṉka kayan achik nin emka tukuti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tura nuna ti̱, ataksha tsuntsumá nuṉká áimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tura ni chichame̱n antukar ni enentái̱n sumamawar úuntnumia̱ jukí chikichik chikichik jiinki wéarmiayi. Ashí wéarmatai Jesus Niṉki nuwája̱i̱ juákmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesussha wajaki aya nuwa̱nak wáiniak tímiayi “¿Ámin súmamtikramainia nusha tuiṉ pujuinia. Chikichkisha áwak?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Niisha “Atsá, Uunta. Chikichkisha atsawai” tímiayi. Nuyá Jesus tímiayi. “Ayu. Wisha súmamtikiatsjame. Yamaikia weme atakka tunáa túrawaip” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ataksha Jesus Yusa Uunt Je̱e̱n iruntrarun tímiayi “Ju̱ nuṉkanam Wi tsáapninia áintsan shuara enentái̱n tsáapniajai. Ashí Wiji̱a̱i̱ tsaniṉ wekaana nú shuar ni enentái̱n kiritniunam wekasashtatui antsu tsáapnin yamaram iwiaakman súana nuja̱i̱ wekasattawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pariséu nuikia tiarmiayi “Ame péṉkerum tau asam támena nu áantraiti.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus tímiayi “Tuyá winiaj tura tui weaj nu nékatsrume, tura Wikia nékajai. Tuma asan winia péṉkerun táyatnak tájana nu péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ju̱ nuṉkanmaya̱ aents enentáimmiaja̱i̱ enentáimtakrum ti súmamtikrume. Tura Wikia chikichkinkesha súmamtiktsujai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tura súmamtikkiunka awajitsuk túrajai. Iis, Wiki shuar túramun péṉkerashit tusan enentáimtsujai antsu winia Apar Winia akuptukua nusha Wiji̱a̱i̱ métek shuar túramun nékawai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Atumí akupkamuri̱i̱n áarmaiti: “Jimiará shuar mai nú chichamnak tákuiṉkia nu chicham nekasaiti.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wátsek Wisha winia Aparsha mai métek taji. Winia Aparsha akuptukuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tutai “¿Ame apasha tui̱ pujá?” tiarmiayi. Jesussha tímiayi “Átumka Winiasha winia Aparsha nékatsrume. Winia nékarkurmeka winia Aparsha nekaawaintrume.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nuna Yusa Uunt Je̱e̱n Yusa kuítri̱n suinia nui̱ tímiayi. Tuma aiṉ sepunam eṉkeatniun achikcharmiayi ni tsawantri̱ jeachu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus ataksha tímiayi “Wikia wéajai. Atumsha e̱átkáttarme tura wi wéamunam wéchamniaitkiuram atumí tunaari̱ji̱a̱i̱ṉ jakattarme.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Israer-shuarsha tiarmiayi “Wi wéamunam wéchamniaitrume” tutai, nuiṉkia máamatpiash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nuiṉkia Jesus tímiayi “Átumka nuṉkaya̱itrume antsu Wikia nayaimpinmaya̱itjai. Ju̱ nuṉkaya̱itrume tura Wikia ju̱ya̱nchuitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tuma asamtai tájarme “Atumi tunaari̱ji̱a̱i̱ jakattarme.” Nekas Wi tájana núitjai. Tura nu enentáimtachkurmeka atumi tunaari̱ji̱a̱i̱ jakattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Niisha aniasarmiayi “¿Amesha yáitiam?” Jesussha tímiayi “Yaunchu tájarme. ");
INSERT INTO jivNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu arantcha atumin súmamtikiatjarum tusan ti tíminiaitjai. Winia Apar akuptukua nuka tuke nekasa nuna tawai. Tura aya ni taman antukan ashí shuaran nunak tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tuma aiṉ ni Apari̱n áujmatman peṉké nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tuma asamtai tímiayi “Aents Ajasuitjiana ju̱, numiniam ajintruarum yakí takuriakrumin núja̱i̱ṉkia nekarattarme. Wi tájana núitjai tura winia enentáirja̱i̱ṉ takatsuk aya winia Apar unuitiurmanak tájai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Winia akuptukua nuka tuke Wíji̱a̱i̱ṉ pujawai. Winia Apar wakeramun tuke shiir túrakui ikiurkichuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tutai untsurí̱ shuar Nin nekas enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Israer-shuaran Nin shiir enentáimtusarmia nuna Jesus tímiayi “Wi tájarmena nu yawe̱tsuk túrakrumka nekas winia unuiniamur átatrume. ");
INSERT INTO jivNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Núja̱i̱sha timiá nekas ana nu nekaattarme tura nekas aṉkant ajastatrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Niisha tiarmiayi “Iisha Apraám weeaitji. Chikicha takarniur átai tusar peṉké emetachmaitji. ¿Urukamtai “Aṉkant ajastatrume” tame?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus tímiayi “Timiá nekasaiti, ashí shuar tunaan túruinia nuka nu tunaaja̱i̱ emetamuiti. Tuma asa takarniua núnisaṉ ajasuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Takarniusha ajapnamnia asamtai Yus atumin ajapramamniaitrume. Tura Akupniu Uchirí̱ṉkia ni Aparí̱ji̱a̱i̱ tuke pujawai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tuma asamtai Akupniu Uchirí̱ aṉkant awajtamsamtaiṉkia imiá nekas aṉkant pujustatrume. ");
INSERT INTO jivNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Átum Apraám weeaitrume nékajai. Túmaitiatrum winia chichamur ántachu asarum mantuataj tárume. ");
INSERT INTO jivNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Winia Apar iniaktursamun áujmatjai. Átumka atumí uuntri̱ timia túrarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tutai niisha tiarmiayi “Iikia Israer-shuar asakrin ii úuntri̱ṉkia Apraámaiti” tiarmiayi. Tura Jesus tímiayi “Nekas enentáimin Apraám weeaitkiurmeka níiya núnis túrawaintrume. ");
INSERT INTO jivNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nekas ana nuna Yus iniaktursamtai nuna ujakjarme, tuma ai̱ṉ mantuataj tarume. Apraámka nuní túrachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Antsu atumí uuntri̱ túrana áintsarum túrarme” tímiayi. Tutai niisha tiarmiayi “Warí, tsanirnumia̱ akiiniachuitji. Ii uuntri̱ Yúskete. Niisha ii Aparí̱nti.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tura Jesus tímiayi “Yus nekas atumi Aparí̱ntkiuiṉkia Winiasha anentíntrume Yúsnumia̱ tau asamtai. Wisha winia enentáimmiarja̱i̱ ju̱i̱ táchaitjai antsu Yus akuptukuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Urukamtai Wi tájana nu imiá nékatsrum? Wi tájana nu nakitia asarum winia chichamur ántatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Atumí aparí̱ṉkia úunt iwianchiiti. Tura niiniu asarum nii wakera nu túrarme. Yámankamtaiksha úunt iwianchkia tuke maṉkartiniaiti. Nekas ana nunasha nakitiawai tuke wáitrin asa. Wáitraksha níiniunak chichaawai. Iis, waitia uuntri̱ asa tuke wáitriniaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tura Wikia nekas takui átum enentáimturtsurme. ");
INSERT INTO jivNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Yaki chikichkí tunaaja̱i̱ súmamtikruamniait? Nuikia Wi nekasa nuna tau a̱i̱sha ¿urukamtai enentáimturtsuram? ");
INSERT INTO jivNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yús-shuarka Yus timian ántawai tura átum Yúsnachu asarum Wi tájana nu nakitiarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nuikia Israer-shuar tiarmiayi “Maa, ti nekas tátsujik “Ame Samarianmaya̱ shuáraitme. Tuke yajauch áiniawai nusha. Nu arantcha iwianchrukuitme amesha” nekas taji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesussha tímiayi “Iwianchrukchaitjai. Áyatik winia Aparun shiir enentáimtikiajai. Tura átumka yajauch chichartarme. ");
INSERT INTO jivNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wikia “shiir enentáimturarti” tátsujai túrasha Yuska ashí shuar Winia shiir enentáimturat tusa wakerawai. Niisha Yus asa ashí shuar túramun péṉkerashit tusa nekaattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ti nekasaiti. Wi tájana nuna enentáimta nú shuarka peṉké jákashtiniaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nuiṉkia Israer-shuar tiarmiayi “Pai, yamaikia ti paant íwianch takakme. Apraámsha ashí Yúsnan etserniusha jákaruiti tura Ame “Wi tájana nuna enentáimtaka peṉké jákashtiniaiti” tátsumek tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nuiṉkia ii uuntri̱ Apraám naṉkaamaskaitiam. Niisha tura Yúsnan etserniusha jákacharuk áinia. Itiurak imiá naṉkaamantu enentáimtumam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesussha tímiayi “Wiki shiir enentáimtumaknaka peṉké áantraiti. Antsu Winia shiir enentáimturna nu winia Aparuiti. Nusha átumka “winia Yúsruiti” tárumna núiti. ");
INSERT INTO jivNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nusha táyatrum Nin nékatsrume. Wikia Nin nékajai. “Nin nékatsjai” tákunka atumja̱i̱ métek wáitrin áintjai. Tura Nin neka asan Nii tana nuna tuke túriniaitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Apraámka, atumí uuntri̱, imiá yaunchu jákaitiat Wi ju̱ nuṉkanam tátinian wararas nákasmiayi. Tura wáitiak ti shiir warartusmiayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nuyá Israer-shuar Jesusan tiarmiayi “Warí, seṉkuenta (50) uwí takaktsume túmaitiatam Apraáman wáinkiámjai tame.” ");
INSERT INTO jivNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesussha tímiayi “Ti nekas tájarme, Apraámka pujatsa̱i̱ṉ Wikia pujajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nuna takui kayan achikiar “Jesusan tukutai” tiarmiayi. Tura Jesus ú̱u̱mak ni matsatmanum ajapéniṉ weak Yusa Uunt Je̱e̱nia̱ jiinki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus ni unuiniamuri̱ji̱a̱i̱ wesa áishmaṉkan kusuru akiinian wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ni unuiniamuri̱sha aniasarmiayi “Uunta, ju̱sha ¿urukamtai kusuru akiiniawit. Yana tunaari̱ji̱a̱i̱ṉ kusuru akiiniait. Niiniuja̱i̱mpiash, aparí̱niuja̱i̱mpiash túrunawit?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus tímiayi “Ni tunaari̱ji̱a̱i̱nchusha ni aparí̱niuja̱i̱nchusha túrunaiti. Antsu Yus ni aya̱shí̱n túratniua nu paant atí tusa túrunaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsawa̱i̱kia takastiniaiti. Yamaikia Winia akuptukua nuna takatrí̱n túratniuitjai. Kashi ajasmatai takastin atsuttawai. ");
INSERT INTO jivNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jú̱ nuṉkanam pujakun shuara enentái̱n tsáapnimtikratniuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nuna chichas nuṉká usukmi nuṉkaja̱i̱ pachimiar kusuru ji̱i̱n yakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nuyá chichaak “Siruí pajamtai entsanam nijiamauta” tímiayi. Siruísha nu chichamnum “akupkamu” tawai. Kusurusha we nijiamar péṉker íimiar támiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nuyá ni írutkamuri̱sha nuik wáinin ármia nusha tiarmiayi “Ju̱ka pujus tuke kuítian seamniuya núchakait.” ");
INSERT INTO jivNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Chíkich “Ee, núkete” tiarmiayi. Chikichcha “Atsá, núchaiti; kame nuash tumainti” tiarmiayi. Tura niṉki “Ee, wiitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tutai aniiniak “¿Itiurak yamaikia íimiam?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Niisha tímiayi “Áishmaṉ Jesusa nu tsakusan jí̱i̱run yakartur “Siruí pajamtai entsanam nijiamauta” turutmiai. Takui wena nijiamaran paant iimpramjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tutai “Nu áishmaṉsha tuiṉ pujá” tiarmiayi. Niisha “Cha, nékatsjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nuyá kusuru tsuárman Pariséunam júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kame Jesus kusurun tsuarmia nui̱ ayampratin tsawantauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tuma asamtai Pariséusha itiurak íimnium tusar aniasarmiayi. Niisha tímiayi “Ji̱i̱ruin tsakusan yakaarámtai, nijiamaran paant iimjiai.” ");
INSERT INTO jivNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nuyá chíkich Pariséu shuarnumia̱ nuamtak tunaiyar “Ju̱na tsuáruka Yúsai̱ya̱nchuiti. Kame ayampratin tsawantai̱ túraiti” tiarmiayi. Tura chikichcha “Tunáa shuaraitkiuiṉkia jú̱nisaṉ túratniun tujinkia̱a̱yi” tiarmiayi. Nuja̱i̱ akannaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsuármancha ataksha aniasarmiayi “Ámin tsuármarua nu ¿warí enentáimtam?” tiarmiayi. Tutai “Wikia “Yúsnan etserniuiti” tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tura Israer-shuar nekas kusuruitiat yamái íimiui tu enentáimtuscharmiayi Pariseu. Tuma ásar ni aparí̱ncha untsukar ");
INSERT INTO jivNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","inintrusarmiayi “¿Ame uchiram kusuru akiinia tárumna nukait. Itiurak yamaikia iimia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ni aparí̱sha tiarmiayi “Ii uchiríṉkia kusuru akiiniama nu nékaji. ");
INSERT INTO jivNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tura iisha nékatsji itiurak yamaikia iimia. ¿Yátsuk péṉker tsuáruit? Niisha úuntchakait, nii aniastarum. Niṉki ujatmakarti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sapijmiak tiarmiayi. Israer-shuara úuntri̱ṉkia “Jesus Yus akupkamu asa nekas Krístuiti” tuinia núnaka Israer-shuara iruntainmaya̱ ji̱i̱ki̱ akupnakti tiniu ásarmatai tsuarma aparí̱ ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nu asamtai ni aparí̱ “Niisha úuntchakait, nii aniastarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nuiṉkia Israer-shuara uuntri̱ kusuru tsuárman ataksha untsuk tiarmiayi “Yus íimmianum nekasa nu titiá, ju̱ áishmaṉkka tunaarinniuiti nékaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tutai tímiayi “Kame tunaarinchashit. Nékatsjai. Antsu ju̱nak nékajai. Yaunchu kusuruitiatan yamaikia íimjiai.” ");
INSERT INTO jivNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ataksha aniiniak “¿Itiurtámkama. Itiur íimtikrammia?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Niisha tímiayi “Yaunchu tájarme tura anturtatsrume. ¿Urukamtai ataksha titi tusa wakerarum. Niiniu ajastin enentáimprurmek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nuiṉkia katsekkar “Ámeka ní shuari̱nme. Tura iikia Muisaisa shuári̱ntji, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yus Muisaisan akupkaiti iikia nékaji antsu nu áishmaṉ nékatsji. ¿Tuya̱ntskait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Áishmaṉ tsuarma tímiayi “¿A̱usha itiurtsuk áminiait? Winia íimtikrurma nu átumka nékatsrume tuya̱ṉkit. ");
INSERT INTO jivNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Paant nékaji tunaarinniun Yus anturtsui. Tikishmatar ni wakeramun túruinia nunak anturui. ");
INSERT INTO jivNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yáunchusha kusuru akiinian tsuáruka tuke atsuwaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ju̱ áishmaṉ Yúsai̱ya̱nchuitkiuṉka peṉké túracha̱a̱yi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nui̱ṉkia tiarmiayi “Ámeka tunaarintin akiiniaitiatmesha ¿in jintintin átaj tamek?” Nuna tiar ji̱i̱ki̱ awemarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kusuru tsuárman ji̱i̱ki̱ awemarma nuna Jesus nekaamiayi. Tura wáiniak “Yusa Uchirí̱a nu enentáimtamek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tsuarma tímiayi “Uunta, turuttia wisha nekaan enentáimtustaj.” ");
INSERT INTO jivNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesussha tímiayi “Wainme. Wiitjai ámiji̱a̱i̱ chichaajna nu.” ");
INSERT INTO jivNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tutai, tikishmatar “Uunta, enentáimtajme” Jesusan tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nuyá Jesus tímiayi “Shuara enentái̱n nekaan, akantratajtsan táwitjai. Ni enentái̱n kusuru ai̱ṉ iimtiktinian tura anaṉmamuk “Yusnan nekaan paant iimjiai” tana nuna ukusturtinian táwitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tutai Pariséu shuar nui̱ pujuarmia nu nuna antukar “¿Nuiṉkia iikia kusurukaitiajⁱ?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesussha tímiayi “Átum kusuruitkiurmeka atumí tunaari̱ wáinchakrum sumamachu áintrume. Tura “paant iimjiai” tau asarum sumamaitrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus tímiayi “Wi tájana nu ti nekasaiti. Shuar murikiun takakna nu ni murikri̱n wenuimiunam kashi ikiuawai. Tura murik wenuimiunam pujuiniakui yajauch shuar murikiun kasamkatniun wakerakka wáitiniam waya̱chmin asa tanishnum waruk yajá waya̱wainti. ");
INSERT INTO jivNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Antsu murikiu wáinniuka wáitiniam waya̱awai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Waiti wáinniuka nekas murikiun wáinniun wáitin uratui. Muriksha ni wáinniuri̱ chichame̱n nékainiawai. Niisha ashí ni murikri̱n chikichik chikichik náari̱n anaitius untsúawai. Tura tsawa̱i̱kia ni murikri̱n ji̱i̱ki ayurtainiam yarumui. ");
INSERT INTO jivNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tura ashí ni murikri̱n ji̱i̱r émtuki wéawai. Muriksha ni chichame̱n ántuiniak untsuam nemarainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Chíkich shuárnaka nékachu ásar nemarainiatsui. Antsu ni chichame̱n nékainiachu ásar pisainiawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nu métek-taku chichamnaka Jesus áujmatsamiayi tura shuar antukar nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nuyá Jesus tímiayi “Ti nekasan tájarme. Wenuimiu wáitiri̱ murik wainia nuka Wiitjai. Shuarsha murikiu áintsar Winí waya̱min áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wi táatsa̱i̱ṉ ashí táaruka kasa áiniak winia shuarun kasamkatai tusa wakeriarmiayi. Tura winia murikiur Wíi shuar áiniak nu shuaran anturkacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wikia wáititjai. Ashí Winin waya̱a̱ka uwemprattawai. Tura murikiua áintsaṉ wenuimiunmaya̱ jiinki péṉker yurumáttawai tura atak wayá ayamprattawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‘Kásaka aya kasamkatniuncha máatniuncha emesratniuncha wakerawai. Antsu Wikia yamaram iwiaakman tuke shiir atsumtsuk takusarti tusan táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Wikia péṉker wáinniuitjai. Péṉker wáinniuka ni murikri̱n uwemtikrartaj tusa jakattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Antsu aya kuitja̱i̱ takauka ni murikri̱chu áiniakui tura nekas wáinniuchu asa péṉker wáintsui. Kame uunt yawá winiakui murikiun ikiuki pisaawai. Uunt yawa̱sha murikiun achik tsakiṉmawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu shuarsha akikiam takáa asa murikiun enentáimtatsui. Nu asamtai aya pisaawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","‘Wikia péṉker wáinniuitjai. Winia Aparsha nékarui. Wisha Aparun nékajai. Núnisnak murikrun nékajai tura winia murikrusha nékarui. Wisha murikiun uwemtikrataj tusan jakattajai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chíkich muriknasha takakjai. Nusha ju̱ wenuimiunmaya̱nchu áiniawai. Nunasha itiattajai. Nu muriksha Winia umirtukar ashí métek matsamsar chikichík wenuimiunmaya̱ ajasartatui tura chikichik wáinin átatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Winia murikrun uwemtikrataj tusan jakattajai turan atak nantaktiatjai. Nu asamtai winia Apar anentui. ");
INSERT INTO jivNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wi wakerakun jakattajai. Wi wakerachkuiṉkia chíkichkia mantuachminiaiti. Jákatniuncha tura nantaktinniasha winia Apar surusuiti” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Israer-shuarsha nuna antukar niisháa enentáimprar kanakiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Untsurí tiarmiayi “¿Urukamtai ántarum wáuruk tausha. Yajauch wakanin takaktsuk?” ");
INSERT INTO jivNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tura chikichcha tiarmiayi “¿Yajauch wakantrinniusha núnisaṉ chichasminkiait. Yajauch wakantrinniusha kusurun íimtikramniashit?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Micha nantutin Israer-shuar Jerusaréṉnum namperan najanainiawai. Nu nampernumsha Yusa Uunt Je̱e̱ atak jeamman enentáimtuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesussha Yusa Uunt Je̱e̱ áa̱chiniam wekasamiayi Sarumúṉka wáitiri̱a nui̱. ");
INSERT INTO jivNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Israer-shuarsha Nin téntakar tiarmiayi “¿Ame nekas Krístukaitiam? Ju̱ chichamaik etserkata. ¿Urukamtia nekas paant tátsum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tutai Jesus tímiayi “Yaunchu tiniu ai̱ṉ enentáimturachmarme. Winia Apar akupkamun takaajna nu ti paant awajtawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tura átumka winia murikruchu asarum enentáimturtsurme. ");
INSERT INTO jivNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wisha winia murikrun untsuam anturtuiniak nemartuiniawai. Wisha wínianak mash nékajai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tura yamaram iwiaakman tuke jákashtinian súajai. Nu asamtai niisha meṉkakachartatui antsu Wi wainkia asamtai ¿yaki jurutkit? ");
INSERT INTO jivNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Winia Apar murikiun surusuiti. Niisha ashí naṉkaamas kakaram asamtai ¿yaki uwe̱jé̱ya̱n atankit? ");
INSERT INTO jivNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wisha winia Aparja̱i̱ iisha aya chikichkiitji” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tutai Israer-shuarsha atak kayan achikiar tukutaj tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesussha tímiayi “Winia Aparu kakarmari̱ji̱a̱i̱ ti untsuri̱ péṉkera nuna takasuitjai. ¿Túja̱i̱mpia mantuattarum?” ");
INSERT INTO jivNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Israer-shuarsha Nin tiarmiayi “Péṉker túra asakmin máataj tátsuji antsu Yus yajauch chicharkumin túrattaji. Ámeka shuáraitiatam Yusa nuke enentáimtumame” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nuyá Jesussha tímiayi “Atumí akupeamuri̱i̱n Yus timia nu áarmaiti: “Átum yúsaitrume” tawai. ");
INSERT INTO jivNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kame Yus-Papinium aarma nu tuke nekaschakait. Tuma asamtai ni chichame̱n antukarun Yuska “yúsaitrume” takui nuikia ti nekaschakait. ");
INSERT INTO jivNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Niisha yúsaitkiuiṉkia nuikia Yus Apa anaikia ju̱ nuṉkanam akupkamu asan ti nekas Yúschakaitiaj. Núja̱i̱ṉkia wi “Yusa Uchirí̱ntjai” takui ¿itiurak “Yusan yajauch chicharui” túrutrum? ");
INSERT INTO jivNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Winia Apar túramu túrachkuiṉkia enentáimtursairap. ");
INSERT INTO jivNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tura nekas túrakuiṉkia enentáimtursatarum. Tura Winia nakitrakrumsha nuikia wi túramu enentáimtustarum. Nuja̱i̱ṉkia winia Apar Winin pujamu ashí nekaattarme. Núnisnak Wisha Ni̱i̱n pujajai. Iisha chikichkiitji.” ");
INSERT INTO jivNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tutai ataksha sepunam eṉkeatai tiarmiayi. Túrasha Jesus uwempramiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nuyá Jesus Jurtaṉ entsa amain wé yaunchu Juaṉ imiakrattainium pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ti untsurí̱ shuar iyuwar tiarmiayi “Nekas Juaṉka aentsti tujintiamun túrachiat ashí Jesusnan tímia nu nekasaiti” tu tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nui̱sha untsurí̱ Jesusan enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Petania péprunam áishmaṉ, ni naari̱ Rásaru, jaa pujumiayi. Nu péprunam Marí ni ka̱i̱ji̱a̱i̱ Mártaja̱i̱ pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Niisha Rásaru umai ármiayi. Nu Marisha ukunmaṉka kuṉkuinian sumak Jesusan kuer ni intiashí̱ji̱a̱i̱ japirmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tura Rásaru jaakui ni umai̱ Jesusan chichaman akuptuiniak tiarmiayi “Uunta, ame amikrum jaawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesussha nuna antuk tímiayi “Tuke jakataj tusa jaatsui. Antsu Yusa kakarmari̱sha tura ni Uchirí̱ kakarmari̱sha jú̱ suṉkur tsuármanum paant atí tusa jaawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus Mártancha ni ka̱i̱ncha tura ni umai̱ Rásaruncha nekas aneemiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Túmaitiat Rásaru jaawai taman antukiat ni pujamunam jimiará tsawant pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nuyá ni unuiniamuri̱n “Ataksha Jutía nuṉkanam wetái” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tura ni unuiniamuri̱sha tiarmiayi “Uunta, nuiksha Israer-shuar kayaja̱i̱ tukurmar mantamatai tícharmaka. ¿Nui̱ ataksha wétai támek?” ");
INSERT INTO jivNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesussha ju̱ métek-taku chichaman tímiayi “Tsawa̱i̱kia páantchakait. Tsawa̱i̱ wekaana nu paant asamtai tukumkashtatui. ");
INSERT INTO jivNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tura kashi wekaana nusha kirit asamtai tukumkáttawai. Núnisaṉ Wíi tuke pujakun winia takatrun takastiniaitjai. Túraknasha itiurchatan wáinkiashtatjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nuyásha Jesus atak tímiayi “Ii amikri̱ Rásaru kanarai. Wi ishintiartatjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tutai ni unuiniamuri̱ tiarmiayi “Uunta, aya kanarka nui̱ṉkia péṉker ajastatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuska Rásaru jakamu nékayat “kanarai” tímiayi. Tura ni unuiniamuri̱ Rásaru kajinmakua áintsaṉ kanarai enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesus nuikia ti paant tímiayi “Rásaru yamaikia jakayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tura nui̱ pujuscha asan kúntuts pujatsjai. Jean túrattajna nu íisrum ti nekas enentáimtursattarme. Nuna nekaan shiir enentáimjai. Wátsek, iyutai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nuyá Jimiampramu Tumas chíkich unuiniamuri̱ nui̱ armia nuna “Iisha weri Niiji̱a̱i̱ métek jakatai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nui̱ taa, Rásarun kuatru tsawant ikiusman wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petania pépruka Jerusaréṉnumia̱ menaintiú kirumitru áinis tíjiu̱chiiti. ");
INSERT INTO jivNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tuma asamtai untsuri̱ Israer-shuar Mártasha Marísha, ni umai̱ jakamtai uutkui atsaṉkrataj tusa weriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mártasha Jesus tíjiu̱ch ajasun nekáa iṉkiuṉtajtsa wémiayi. Antsu Marikia je̱á pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tura Marta Jesusan iṉkiuṉ tímiayi “Uunta, Ame pujakminkia winia umar jákacha̱a̱yi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tura tuke nékajai ashí Yus seamna nuna súramui.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesussha tímiayi “Ame umaimisha nantaktiatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mártasha tímiayi “Nekas, ashí amuamunam jákaru nantaktin tsawantai̱ nantaktiatui. Nuna nékajai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nuyá Jesus tímiayi “Iwiaaku átinia nérentin asan Wikia iniantkartiniaitjai. Winia enentáimturna nuka jakasha nantaktiatui. ");
INSERT INTO jivNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tura ashí iwiaaku pujana nusha Winia enentáimturaka peṉke jákashtatui. ¿Nu nekasaiti tu enentáimtamek?” ");
INSERT INTO jivNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Niisha “Ee, Uunta, ame Yusa Uchirí̱nme. Krístuitme, uwemtikkiartin jú̱ nuṉkanam tátinia nu” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mártasha nuna ti̱, ni ka̱i̱ Marin untsuk ú̱u̱kaṉ tímiayi “Uunt ju̱i̱ taa untsurmawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Marisha nuna antuk wárik wajaki Jesusa iyuttsa wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesussha péprunam jeatsuk Marta iṉkiuṉmanum pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Marí wari wajaki wématai Israer-shuar nu je̱a̱nam atsaṉkrattsa pujuiniasha nuna íisar weriarmiayi. Iwiarsamunam úuttiasa wéatsuash tusa weriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Marisha Jesus pujamunam jeá tikishmatar tímiayi “Uunta, Ame pujakminkia winia umar jákacha̱a̱yi.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesussha Marincha tura niiji̱a̱i̱ úutuncha wáiniak wáitnentaimta asa ti kúntuts pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tura “Tui̱ iwiarsamarum” tímiayi. Niisha “Uunta, iitia” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesussha úutmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Israer-shuarsha “Ti aneatsuk” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tura chíkich “Kusuru tsuáruchukait. Nii pujakuisha Rásaru jáka̱a̱mpiash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesussha ti kuntuts enentáimiar iwiarsamunam weankámiayi. Náinnium asa paka taurma áuyayi. Tura kaya atutkamuyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tura Jesus “Kaya jurustarum” tímiayi. Rásaru umai̱ Marta tímiayi “Uunta, kuatru tsawant jákaiti. Mejeatsuk’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tura Jesus tímiayi “Yus enentáimtakmeka Yusa kakarmari̱ wáinkiattame tíchamkajam.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nuikia kayari̱n uratiarmatai Jesus nayaimpin iis tímiayi “Aparu, Winia anturtakmin yumiṉsajme. ");
INSERT INTO jivNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Winiasha tuke anturtame tura ju̱ shuaran péṉker enentáimtikrataj tusan tajai. Ame akuptukuitmena nuna nekarmawarti.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nuna tinia kakaram untsuak “Rásaru jíinkitia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nuja̱i̱ṉkia penuarmartiuk jiinkimiayi. Yapinmasha ja̱a̱nchji̱a̱i̱ ijiamuyayi. Tura Jesus “Atirtarum. Wéti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Untsurí̱ Israer-shuar Marin nemariaru Jesus túramun íisar enentáimtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tura chíkichkia Pariséunam wear Jesus túramun ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nuna antukar Pariséusha Israer-patri úuntri̱sha ashí naamka uunt armia nuja̱i̱ iruntrar tiarmiayi “¿Warí itiurkamniait? Nu shuarka aentsti tujintiamun ti túratsuk. ");
INSERT INTO jivNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aya jú̱nik iniaiyakrinkia ashí shuar Nin enentáimtuschartatuak. Nuyá Rúmanmaya̱ apach taar mesetan najanawartatui tura in amutmakar Yusa Uunt Je̱e̱ncha emesrartatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nu uwitin Kaipias Israer-patri uuntri̱yayi. Niisha tímiayi “Átumka nékatsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ashí Israer-shuar mesertin péṉkerkait. Antsu aya chikichik shuar jákatin péṉkerchakait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaipiaska aya ni enentáimmiaja̱i̱ṉ tíchamiayi. Antsu nu uwitin Israer-patri uuntri̱ asamtai Yus nuna enentáimtikramiayi. Núja̱i̱ṉkia Israer-shuar Jesus jaruktinian ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tura aya Israer-shuarnakcha antsu niiji̱a̱i̱sha ashí nuṉkanam Yus-shuar ajasarun irurtajtsa jákatniuyi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tuma asamtai nu tsawantiniṉ Israer-shuara uuntri̱ Jesus máatai tusar áujmatsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nu asamtai Jesus paant wantiniak Israer-shuarnum wekaichmiayi. Antsu Jutía nuṉkanmaya̱ jiinki atsamu nuṉkanam Eprain pepru tíjiu̱ch wémiayi. Tura nui̱ pujusmiayi ni unuiniamuri̱ji̱a̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israer-shuara namperi̱ paskua ishichik jatemsamtai untsurí̱ shuar yajá péprunmaya̱ Jerusaréṉnum káunkarmiayi. Kame paskua jeatsa̱i̱ṉ Muisais timia núnisaṉ ni a̱ya̱shí̱sha enentái̱sha iwiarnarat tusa wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesusnasha e̱a̱k yujarmiayi. Tura Yusa Uunt Je̱e̱n pujusar nuamtak aniniaisar “¿Warí enentáimiam. Jístanam tatimpiash?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pariséusha Israer-patri uuntri̱sha akupainiak “Jesus pujá nekaamka ujatkata” tiarmiayi. Jesusan sepunam eṉkeatai tusar tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paskua jísat jeatin sais tsawant ajasmatai Jesus Petania péprunam wémiayi. Jesus jakamunmaya̱ iniantkimia nú Rásaru nuiṉ pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesus jeamtai ayurawarmiayi. Rásarusha niiji̱a̱i̱ yurumámiayi. Mártasha yurumkan iwiasmakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tura Marikia kuṉkuinian ti kuitja̱i̱ ritru ajapén sumak itiamiayi. Tura Jesusa nawe̱n kuer ni intiashi̱ji̱a̱i̱ japirmiayi. Je̱a̱sha nu kuṉkuinja̱i̱ ti shiir kuṉkuṉmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jútas Iskariúti, Semuṉka uchirí̱, nui̱ pujumiayi. Niisha Jesusa unuiniamuri̱ntiat ukunam Jesusan surukmiayi máawarat tusa. Niisha tímiayi ");
INSERT INTO jivNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Urukamtai nu kuṉkuinian ti kuitja̱i̱ surukchama kuítrinchan súsatniun?” ");
INSERT INTO jivNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kame kuítrinchan enentáimtak tíchamiayi. Antsu unuiniamu kuítri̱n wainkia asa yúpichuch kasamkamniuyayi. Tuma asa nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tura Jesus tímiayi “Iniaisata. Wi iwiarnakui kuératniun sumak ikiurtusuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kuítrincha tuke atumja̱i̱ íruntsuk. Antsu Wikia atumja̱i̱ tuke pujuschattajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Israer-shuarsha Jesus Petania péprunam pujan antukar Jesus íistaitsar weriarmiayi. Rásaruncha Jesus jakamunmaya̱ iniantkimiua nusha iyutai tusar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Túramtai Israer-patri uuntri̱ṉkia chichaman jurusarmiayi Rásaru maatai tusar. ");
INSERT INTO jivNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Untsurí̱ Israer-shuar Rásaru iniantkimiun nekaawar Israer-patrin ikiukiar Jesusan enentáimtusarmiayi. Túrawarmatai Rásaruncha máatniun wakerukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Paskua namperan pachiintiuktajtsa ti untsurí̱ shuar Jerusaréṉnum wearmiayi. Kashin tsawa̱r Jesus nú peprunam tátinian nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Niisha tintiuki nuké̱ áinis nukan júurar Jesusan iṉkiuṉtai tusar jíinkiarmiayi. Túrawar untsumainiak “Shiir tati, tiarmiayi. Yusa kakarmari̱ji̱a̱i̱ winiana nu tí péṉkeraiti. Israer-shuara uuntri̱ asa shiir atí” tu untsumiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesussha umpuurun wáiniak entsamkamai. Núnisaṉ áarmaiti Yus-Chichamnum: ");
INSERT INTO jivNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Seuṉ péprunmaya̱ shuara, ashamkairap. Atumí Akupniuri̱ umpuurunam entsamak winiawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nu chichamaik Jesusa unuiniamuri̱ nu túrunamun nekaacharmiayi. Tura ukunam Jesus nayaimpiniam shiir waketkimtai enentáimprarmiayi. Ashí Jesusna aarma núnisaṉ túrunamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesus Rásarun iwiarsamunmaya̱ iniantkimiun wáinkiarua nú shuar nuna áujmatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tuma asamtai shuar Jesus nu tujintiamun túramtai nekaawar Jesusan iṉkiuṉktaj tusar jíinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tura Pariséusha nuamtak tiarmiayi “Iis, peṉké tujinkiaji. Maa iista, ashí shuar Nin nemarainiatsuk.” ");
INSERT INTO jivNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Paskua nampernum Yus shiir awajsatniun Jerusaréṉnum weriaruka untsurí̱ nuṉkanmaya̱ shuar ármiayi. Kriaku apachcha ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Niisha Jiripin weantukarmiayi. Kame nu Jiripi Petsaitia péprunmaya̱uyayi. Petsaitia péprusha Kariréa nuṉkanam awai. Nincha Kriaku apach seainiak “Uunta, Jesusja̱i̱ chichastaitsar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jiripisha Antresan werí ujakmiayi. Nuyá niiji̱a̱i̱ métek tsaniṉkiar Jesusan weriar ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesussha tímiayi “Wi Aents Ajasuitjiana ju̱ tsawantur jeayi. Túramtai shiir awájnástatjai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wi tájana nu ti nekasaiti. Jiṉkiaia ántsaṉketjai. Araachmaka niṉki pujatsuk. Antsu araamka tsapain jinkiaichiri̱ kaushmariat nerek ti untsurí̱ ajatsuk. Núnisnak Wi jakamtai ti untsurí̱ shuar yamaram iwiaakman takusartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Shuarsha jinkiaia nuke aya ju̱ nuṉkanam péṉker pujustinian enentáimkiuṉka ántar pujak nekas iwiaakmari̱n emeṉkaktatui. Tura ju̱ nuṉkanam péṉker pujustinian enentáimtsuk jákatniuncha ashamchaa nú shuarka nekas iwiaakman wáiniak tuke iwiaaku átatui. ");
INSERT INTO jivNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Shuar winia átaj takuṉka nemartusti. Túraṉka Wi pujajna nui̱ Wíi shuar tuke átatui. Núnisaṉ Wíi shuar winia takatrun takáa nuna winia Aparsha shiir enentáimtustatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Yamaikia enentáirui̱ ti itiurchat pujajai. ¿Warittiajak. “Aparu, ju̱ túrunatniunmaya̱ uwemtikrurta” titiajash? Antsu jú̱ túrunatniun táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aparu, wi túramuja̱i̱ ashí shuar ame náarmin shiir enentáimturarti” tímiayi Jesus. Tutai nayaimpinmaya̱ chichaman antukarmiayi. “Winia náarun shiir awajsaitjai tura ataksha shiir awajsattajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Shuarsha nui pujuinia “ipiamtachuashit” tiarmiayi. Tura chikichcha “Nayaimpinmaya̱ suntar Nin chichasai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesussha tímiayi “Wi antuktinian chichaschayi antsu átum nekaatarum tusa chichasai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yamaikia nuṉkanam makumatin jeayi. Tura íwianch ju̱ nuṉkanam akupniua nu nupetnak ajapnattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tura numiniam awajnaintai ashí nuṉkanmaya̱ṉka shuar enentáimturartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ju̱na taku krúsnum jákatniun ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Shuarsha awajirar tiarmiayi “Yaunchu Yus akupkamu papiniumia̱ áujsar nékaji. Kristu tutai tuke jáatsuk iwiaaku pujustiniaiti. ¿Itiurak nuikia “Aents Ajasu numiniam awajnaitniuiti” tame? Aents Ajasuka Krístuchukait, Yus anaikiamu. Núchaitkiuiṉkia Aents Ajasuka yait?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nuiṉkia Jesus tímiayi “Wi tsáapninia áintsaṉketjai. Tsáapnisha atumí̱i̱n aya ishichik tsawantin tsáapniartatui. Tsáapin ana ju̱i̱k wekasatarum kirit ajatsa̱i̱ṉ. Kame kiritniunam wekaana nusha nékatsui itiuranimpia wea. ");
INSERT INTO jivNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tsáapnin wáinkiuram nin enentáimtustarum. Túrakrum winia tsáapnintrui̱ wekasattarme.” Jesussha nuna ti̱ wémiayi u̱u̱mak pujustaj tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus aentsti tujintiamun ti untsurí̱ túramtaisha Nin enentáimtuscharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yúsnan etserin Isayas yaunchu aarma uminkiatniuyi: “Uunta, ¿ya ii ujam antukuit. Yusa kakarmari̱sha yana iniaktusuit?” tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nuna uminiak Jesusan enentáimtuscharmiayi. Tura nu arantcha Isayas áarmiayi: ");
INSERT INTO jivNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yus nin kusuru awajsaiti tura ni enentái̱ncha kátsuram awajsaiti. Ni ji̱i̱ji̱a̱i̱ íimsa̱i̱ṉ tusa tura ni enentái̱ji̱a̱i̱ nekaawa̱i̱ṉ tusa túraiti. Kame ni tunaari̱ iisar enentáimtuiniakui Yus nin tsuárainti” tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayas yaunchu Jesusan nayaimpiniam ti shiir pujan wáiniak nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tuma ai̱ṉ untsurí̱ Israer-shuarsha tura ni uuntri̱nmaya̱sha Jesusan nekas enentáimtusarmiayi. Tura niisha Pariséun ashamainiak paant tícharmiayi. Israer-shuara iruntairi̱ya̱ ji̱i̱ki awetama̱i̱j tusa ashammiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yus shiir enentáimtursati tutsuk antsu shuar shiir enentáimtursati tusar túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus kakantar untsumuk tímiayi “Winia enentáimturuk aya Winiak enentáimturtsui antsu winia Aparun Winia akuptukua nunasha enentáimtawai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Winia wáitkiusha Winia Aparnasha wáinui. ");
INSERT INTO jivNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wikia tsáapnin asan Winia enentáimturainia nuka kiritniunam wekasa̱i̱ṉ tusan ju̱ nuṉkanam táwitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Shuáran sumamtikiatniun táchaitjai antsu uwemtikratniun táwitjai. Tuma asamtai shuar winia chichamprun antuk umíachkuṉka sumamaiti. Tura Wikia sumamtikiachuitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Winia nakitrur chichampruncha enentáimtachuka sumamtikiamuiti. Wi timiaj nuka amuukatin tsawantai̱ nin sumamtikiattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wi enentáimmiaja̱i̱ṉ chichaatsjai. Winia Apar akattur akuptukuiti. Tura chichastinia nuna surusuiti. ");
INSERT INTO jivNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wisha nékajai, ashí winia Apar akupeamuka yamaram iwiaakman tuke amuukashtinian súawai. Tuma asamtai winia Apar túrutmia núnisnak tajai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskua jísat jeatin chikichík tsawant ajasmatai Jesusa tsawantri̱ jeatemayi. Túramtai ju̱ nuṉkan ikiuki ni Aparí̱i̱n wétiniuyi. Jesussha nuna nekaamiayi. Ashí Níiniun ju̱ nuṉkanam pujuinian tuke anea asa amúamunmasha yapaji̱tsuk tuke aneemiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nu tsawantai̱sha murikiun yúatin ármiayi. Tura yurumátin jeatsa̱i̱ṉ, uunt iwianch Semuṉka uchirí̱ Jútas Iskariúti enentái̱n Jesusan surukat tusa enentáimtikramiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tura Jesus Yusai̱ya̱ tau asa waketkitniuyi. Tura Yus Apa ashí mash susamiayi akupin atí tusa. Jesussha nuna nekáa ");
INSERT INTO jivNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","chíkich yurumuk pujuiniai̱ wajakmiayi. Tura pushiri̱n áimiak awaṉkéman emenmamamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nuyá nijiaamatainium entsan yará ni unuiniamuri̱ nawe̱n nijiatramiayi. Tura awaṉkémja̱i̱ japirmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Semuṉ Pítrunam jeamtai Pítiur tímiayi “Uunta, ¿Winia nawer nijiartaj tamek?” ");
INSERT INTO jivNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesussha tímiayi “Wi túrajna nu yamái nékatsme tura ukunam nekaattame.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tura Pítiur tímiayi “Peṉké winia nawer nijiarchattame.” Jesussha tímiayi “Wi nijiaachkuiṉkia Wiji̱a̱i̱ tsaniṉkia pujuschamniaitme.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tutai Semuṉ Pítiur tímiayi “Nuiṉkia, Uunta, aya nawerkechu antsu uwejrusha tura muukarsha nijiatrurta.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tura Jesus tímiayi “Yamái mainkia aya̱shí̱ shiir asamtai aya nawe̱niṉ nijiamártiniaiti. Atumí enentái̱n ashí péṉkeraitrume. Túrasha ashí shuarcha” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kame Jútas Nin suruktinian nekáa “ashí shuarcha” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesussha nijiar umik ni pushiri̱n entsarmiayi. Tura atak pujus tímiayi “¿Atumsha Wi túrajna nu nekaarmek? ");
INSERT INTO jivNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wi atumí Uuntri̱ asamtai nekas “Uunta” túrutrume. Nusha péṉkeraiti. ");
INSERT INTO jivNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tura Jintinniuitiatan tura Úuntaitiatan atumí nawe̱n nijiarchajak. Atumsha núnisrumek nuamtak náwem nijiatnairatarum. ");
INSERT INTO jivNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Atumin nekapruatsan túramjai. Atumsha núnisrumek túratarum. ");
INSERT INTO jivNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ti nekasan tajai. Takarniuka ni uuntri̱ naṉkaamaschaiti. Akupkamusha akupea nuna naṉkaamaschaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nu nekaarum túrakrumka shiir átatrume.’ ");
INSERT INTO jivNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Tura tájana nuna ashí tátsujrume. Anaikiaitiaj núnaka Wi nékajai. Tura Yus-Chicham uminkiatniuiti, nékajai. Ju aarmaiti: “Wiji̱a̱i̱ yurumna nu winia nemasur ajasai.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nuka túmatsa̱i̱ṉ ujaajrume. Nuyá túrunamtai Yusa Uchirí̱ntjai nusha paant nekaattarme. ");
INSERT INTO jivNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wi tájana nu nekasaiti. Shuar Wi akupeaj nuna shiir itiaakka Winiasha shiir itiaarui. Tura Winia shiir itiaarna nusha Winia Akuptukuncha itiaawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nuna ti̱, Jesus ni enentái̱n ti itiurchat enentáimpramiayi. Tura paant tímiayi “Nekas tajai, chikichik jui̱ atumja̱i̱ pujana nu Winia surutkattawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tutai ni unuiniamuri̱ nuamtak íiniaisar “¿Yanak ta?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chikichík unuiniamuri̱, Jesus ti aneamu, Niiji̱a̱i̱ tsaniṉ yurumuk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tuma asamtai Semuṉ Pítiur ni uwejé̱ja̱i̱ iniakmas “Aniasta, ¿yanak áujmata?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tutai Jesusan áyanmatsan aniasmiayi. “¿Yait, Uunta?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesussha a̱ya̱k “Tantan túumnium ajuṉkan susattaj núiti” tímiayi. Núja̱i̱ṉ tantan túumnium ajuṉ Semuṉka uchirí̱n Jútas Iskariútin susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tura wárik Jútas tantan achikmatai íwianch ni enentái̱n waya̱miayi. Nuyá Jesus tímiayi “Túrattamna nu wárik túrata.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tura ashí nui̱ yurumainiak pujuarmia nusha wariniak ta tusa nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","“Kuítrincha kuit súsarta” tátsuash tu enentáimprarmiayi. Tura chikichcha “nampernum yurumátin atsumajnia nu sumakta” tátsuash, tu enentáimprarmiayi. Jútas kuítian wáinin asamtai tu enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jútas tantan yua kashi ajasmanum jíinkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jútas jíinkimtai Jesus tímiayi “Wi Aents Ajasu asamtai winia kakarmar yamaikia paant átatui. Tura wi túramuja̱i̱ Yusa kakarmari̱sha ti paant átatui. ");
INSERT INTO jivNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wi Yusa kakarmari̱n paant awajeakui Wisha ni Uchirí̱ asamtai winia kakarmarnasha Yuska wárik paant awajsattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Uchichiru, atumja̱i̱ ti untsurí̱ tsawant pujuschattajai yamaikia. Wi Israer-shuaran tímiaj nútiksanak atumin tájarme. Atumsha Winia e̱átkáttarme tura wi wéamunam winishtatrume. ");
INSERT INTO jivNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ju̱ yamaram akupeamun amaajai nuamtak mai anenai ajatarum tusan. Wi atumin aneajrumna núnisrumek atumsha nuamtak mai anenai ajatniuitrume. ");
INSERT INTO jivNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Anenaiyakrumniṉkia nuja̱i̱ ashí shuar “Kristu unuiniamuri̱ áiniawai” túramartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Semuṉ Pítiur Jesusan aniasmiayi “Uunta, ¿tua wéam?” Jesussha tímiayi “Wi wéajna nui̱ yamaikia winichminiaitrume. Tura ukunam winittiarme.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nuyá Pítiur tímiayi “Uunta, ¿urukamtai yamaikia winichminiaitiaj? Ámin yáiṉtajtsan jakataj tajai.” ");
INSERT INTO jivNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesussha tímiayi “¿Nekasmek táme? Ti nekas tájame, atash shiniatsa̱i̱ṉ Winia menáintiú natsantrurtatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kúntuts pujusairap. Yus enentáimtustarum, Winiasha enentáimtursatarum. ");
INSERT INTO jivNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Winia Aparuí̱ átum pujustin ti aṉkant awai. Tura nuna iwiarataj tusan Aparuí̱ wéajai, nekasaiti. Nekaschaitkiuiṉkia ¿itiurak ujaka̱a̱jrum? ");
INSERT INTO jivNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tura iwiaaran amukan ataksha tátatjai. Tura tana yaruaktatjarme, wi pujamunam atumsha pujusúk tusan. ");
INSERT INTO jivNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wi wéaj nu nékarme tura jintiasha nékarme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tumas tímiayi “Uunta, Ame weam nu nékatsji. ¿Jintiasha itiurak nekaattajⁱ?” ");
INSERT INTO jivNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesussha tímiayi “Wi nekas jíntiaitjai. Wíji̱a̱i̱nchu wekaana nuka winia Aparuí̱ jeatniun peṉké tujintiawai. Tura Wisha tuke nekas tiniu asan nekas ana nuna shuáran nékamtikiajai. Wisha shuáran yamaram iwiaakman tuke amuukashtinian súwitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Winia nékarkurmeka winia Aparsha nekaawaintrume. Yamaisha Nii wáinkia asarum nékarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nuiṉkia Jiripisha tímiayi “Uunta, Apasha wáinkiarka maak.” ");
INSERT INTO jivNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesussha tímiayi “Jiripi, atumja̱i̱ ti pujusu a̱i̱sha ¿tuke nékartsumek? Winia wáitkia nuka Winia Aparnasha wáinkiaiti. ¿Itiurak, nuikia, “Apasha wáinkiarka maak” tame? ");
INSERT INTO jivNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Winia Aparja̱i̱ tsaniṉkian pujakun tura winia Aparsha Wiji̱a̱i̱ pujakui tuke chikichkiitji. ¿Nu nékatsrumek? Wi tájarmena nu Winia chichampruchuiti. Yus Apa Winí pujak ni wakeramun takaawai. ");
INSERT INTO jivNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nekaatarum. Wisha winia Aparja̱i̱ tsaniṉkia pujakur nekas chikichkiitji. “Nu chicham itiurchataiti” enentáimkiurmeka wi túramu nuikia enentáimpratarum. Wi túramuja̱i̱ chikichik ájinia nu páantchakait. ");
INSERT INTO jivNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wi tájarmena nu ti nekasaiti. Winia enentáimturna nu Wi túrajna nuna túrattawai. Tura winia Aparuí̱ wéakui nuna naṉkaamas tujintiamun túrattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ashí Winia enentáimtursarum seatrumna nuna amastatjai. Núja̱i̱ṉkia winia Apar shiir awajnastatui. ");
INSERT INTO jivNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Winia enentáimtursarum seakrumniṉkia ashí túrattajai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‘Atumsha anentkurmeka winia chichamur umiktarum. ");
INSERT INTO jivNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tura wéakun winia Aparun chikichan akupturmakti tusan seattajai. Niisha atumja̱i̱ tuke pujak atsaṉtamprartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nusha Yusa Wakaní̱inti. Yus-shuarcha Nin nekaachmin áiniawai. Tuma asamtai ni enentái̱n waya̱chminiaiti. Antsu átumka atumi enentái̱n pujakui Nii nékarme. Niisha atumí enentái̱n tuke pujustatui. ");
INSERT INTO jivNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mitiaikia áitkiasnak ikiukchattajrume. Atumí̱i̱n atak tátatjai. ");
INSERT INTO jivNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ishichik tsawant naṉkaamasmatai chíkich shuar irunna nu wáitkiachartatui. Tura Wi iwiaaku asamtai átumka nu iwiaakmaja̱i̱ pujustatrume. Tuma asarum wáitkiattarme. ");
INSERT INTO jivNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tura nu tsawantai̱ ju̱ nekaattarme. Wisha winia Aparja̱i̱ tsaniṉkia pujakur chikichkiitji. Núnisnak Wisha atumja̱i̱ tsaniṉkian pujajai. Tura atumsha Wiji̱a̱i̱ tsaniṉkia pujarme. ");
INSERT INTO jivNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Shuar Winia anentuka wi akupkamun nekáa umíawai. Nú shuarnaka winia Aparsha aneawai. Wisha nin aneajai tura nekarati tusan iniaktustatjai.” Jesus nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chíkich Jútas, Iskariútichu, tímiayi “Uunta, ¿urukamtai ashí shuarnum iniaktutskesha aya in iniaktustatam?” ");
INSERT INTO jivNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus tímiayi “Winia anentuka tájana nuna enentáimtawai. Winia Aparsha nu shuaran aneattawai. Tura Wisha winia Aparnum nu shuarja̱i̱ tsaniṉkia pujustatji. ");
INSERT INTO jivNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Antsu Winia anentchaka tájana nuna enentáimtatsui. Átum ántarmena nú chichamka wíniachuiti, antsu Yus Apa Winia akuptukua Núnaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Atumja̱i̱ tuke pujakun nuna tájarme. ");
INSERT INTO jivNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yus Apa ni Shiir Wakani̱n atumin yáinmak atsaṉtamprarat tusa akupturmaktatrume. Wi seam túrattawai. Nu Wakancha ashí Wi ujakjarmena nuna atak enentáimtikramprar ashí unuitiamprartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‘Imiatkinchanum pujustarum. Imiatkinchanum pujajna núnisrumek pujustarum tusan amaajai. Jú̱ nuṉkanmaṉka warastin wáinkiashtatrume. Antsu itiurchatnum pujayatrumkesha Wiji̱a̱i̱ imiatkinchanum pujustatrume. Ashamtsuk pujustarum. Itiurchat enentáimprairap. ");
INSERT INTO jivNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nuik timiaj nu antukmarme. Aparuí̱ wena atak atumi̱í̱n tátatjai. Winia Aparka Wiji̱a̱i̱ naṉkaamas úuntaiti. Tuma asamtai ti nekas anentkurmeka “Aparuí̱ wéajai” takui ashí warasa̱a̱rme. ");
INSERT INTO jivNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nuka túmatsa̱i̱ṉ ujaajrume. Túrunamtai nuyá Winia enentáimtursattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‘Jú̱ nuṉkanmaya̱n akupin winiakui atumja̱i̱ núkap chichaschattajai yamaikia. Wíniaka nupettukchamniaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tura Wikia winia Aparun aneajai tura Nii akupturkama nuna tuke túrajai. Ashí shuar nuna nekaawarti tusa ashí túrunatniuiti. Wajaktiarum. Ju̱yá wetái’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","‘Winia iwiaakmarun amaakun numi arakma áintsaṉketjai. Wikia kampuintjai atumsha kanawentrume. Winia Aparsha arakan wáiniua núnisaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Winia kanawernasha nereatsna núnaka tsupik ájapeawai. Tura nereana núnaka púruawai nú nukap nerekat tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wi ujakjarmena nuja̱i̱ puruarmaitrume. ");
INSERT INTO jivNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Numí kanawe̱sha kampuin áchitkiachkuṉka niṉki nerekchamniaiti. Núnisrumek atumsha Winí áchitkiachkurmeka nerekchamniaitrume. Wi atumja̱i̱ áchitkiaj núnisrumek atumsha Winí tuke áchitkia atarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Wikia kampuintjai atumsha kanawentrume. Kampuiṉkia kanawe̱n áchitkia núnisnak achiakjarme. Tura kanawe ni kampuiniṉ áchitkia núnisrum Winí áchitkia atarum. Túrakrumka núkap nerektatrume. Antsu Wíji̱a̱i̱nchuka péṉker túratin peṉké tujintiarme. ");
INSERT INTO jivNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Winí áchitkiachuka ajapam kukartatui. Kanawesha kukarmatai shuar irumkar áesawartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‘Tuke Winí áchitkiaitkiurmeka tura winia chichamprusha kajinmattsuk emetarmeka átum wakerarmena nu seakrumin amastatjai. ");
INSERT INTO jivNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Átum núkap nereakrumniṉkia ashí shuar “Nekas Jesusa unuiniamuri̱nti” túramartatui tura winia Aparnasha shiir awajsartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Winia Apar anenna nútiksanak Wisha atumin aneajrume. Winia aneamur tuke atarum. ");
INSERT INTO jivNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Winia Aparu akupkamuri̱n umiakun tuke ni aneamuri̱ntjai. Núnisrumek winia akupkamur umiakrumka tuke winia aneamur átatrume’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘Wi waraajna áintsarmek warastarum tusan nuna tájarme. Tura ti shiir warastatrume. ");
INSERT INTO jivNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wi akupkamu jú̱iti: “Wi aneajrumna nútiksarmek ashí anenaitiarum.” ");
INSERT INTO jivNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Shuar ni amikri̱n yáiṉtaj tusa jakaṉka ti aneṉkartichukait. ");
INSERT INTO jivNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wi akupeamu takaakrumka atumsha winia amikruitrume. ");
INSERT INTO jivNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Takarniuka ni uuntri̱ takaana nuna nékatsui. Tuma asamtai “winia takarniuruitrume” tátsujrume. Antsu ashí winia Apar táman ujaku asan “winia amikruitrume” tájarme. ");
INSERT INTO jivNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aya atumí enentáimsamuri̱ji̱a̱i̱ṉ Wíi shuar ajaschamarme. Antsu akatramur ajastarum tusan atumniaka achikjarme Wi. Winia takatur takastiniaitrume. Túrarum péṉker túratniuitrume nerektinia áintsarmek. Tura nu nere amuutsuk tuke átiniaiti. Tuma asamtai winia Apar searmena nuna amastatui. ");
INSERT INTO jivNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jú̱naka akupeajrume: Nuamtak mai anenai ajatarum’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‘Ju̱ nuṉkanmaya̱ shuar Winia emka nakitrurar atumniasha nakitramarme. ");
INSERT INTO jivNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Atumsha ju̱ nuṉkanmaya̱ shuaraitkiurminkia niiniua nútiksaṉ anenmaintrume. Antsu Wíi shuar ajastarum tusan ju̱ nuṉkanmaya̱ achikmajrume. Túramtai nekas ju̱ nuṉkanmaya̱nchuitrume yamaikia. Nu asamtai nu shuar nakitramainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Takarniuka ni uuntri̱ naṉkaamaschaiti” tíchamkajrum. Shuar Winia yajauch awajtusaru ásar atumniasha yajauch awajtamsartatui. Chikichcha umirtukaru ásar atumniasha umirtamkartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Winia Akuptukun nékachu ásar Winia enentáimturkurmin yajauch awajtamsartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‘Wi tana Yus-Chichaman nin ujakchamtaiṉkia tunaanum sumamachara̱a̱yi. Antsu ujakma ásar “Nékachkun túraitjai” tíchamin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Winia nakitruinia nuka winia Aparnasha nakitiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aents peṉké túrachman túrachuitkiuiṉkia tunaanum sumamacharainti. Antsu wi túramun wáinkiaru áiniayat Winiasha tura winia Aparnasha nakitiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yaunchu Yus akupkamunam áarmaiti: “Peṉké ántar nakitrurarmai.” Nu chicham uminkiati tusa túrunaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Tura atsaṉtamprattsa yáinmana nuna winia Aparui̱ya̱ akuptuktatjarme. Niisha tuke nekas tiniu Wakaniiti. Niisha Yusai̱ya̱ taa atumin nekamtikramprattarme. ");
INSERT INTO jivNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Atumsha yaunchu Wiji̱a̱i̱ pujusu asarum nekamtikiattarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Átum kanartuka̱i̱rum tusan jú̱naka tájarme. ");
INSERT INTO jivNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Israer-shuar iruntainiumia̱ ji̱i̱ki akuptamkattarme. Nu arantcha mantamainiaksha “Yúsan shiir awajsattsan túrajai” tiártatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nu shuar Winiasha tura winia Aparnasha nékachu ásar túrutmawartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Núnaka yamái tájame. Tura túrunamtai “núnisaṉ átiniaiti” timiaj nu nekaarum itiurchat enentáimprairap’ tímiayi. ‘Atumja̱i̱ tuke pujá asan núnaka yaunchu ujakchamajrume. ");
INSERT INTO jivNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Antsu yamaikia wáketjai winia Akuptukmia nuja̱i̱ pujustaj tusan. Tuma ái̱ṉ wéajna nu inintratsrume. ");
INSERT INTO jivNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Antsu nuna takui ti kuntuts enentáimprarme. ");
INSERT INTO jivNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tura Wi wématai atumja̱i̱ṉkia nuna naṉkaamas péṉker átatui. Iis, Wi wéaknaka atumin yainmaktinia nuna akupkattajai tura wéachkuiṉkia táchattawai. Nuka ti nekasaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yusa Wakaní̱ taa ashí jú̱ nuṉkanmaya̱ aentsun ju̱ menaintiun nekamtikiattawai. Ni tunaari̱ aan nekamtikiattawai. Péṉker tunaaja̱i̱nchu wekasamniana nunasha nekamtikiattawai. Tura Yus tunaanum súmamtikiamniana nunasha nekamtikiattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Winia enentáimturainiachu tunáarintin áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Winia Aparuí̱ wáketkui wáitkiashtatrume. Tuma asamtai ashí shuar wi péṉker tunaaja̱i̱nchu wekaamun nekaawartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tura ju̱ nuṉkanam akupniunka Yus tunaanum súmamtikia asa shuarnasha súmamtikiamniaiti. Nuna paant nekaawartatui’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Nu arantcha núkap tíintjiarme túrasha átumka nekaachaintrume. ");
INSERT INTO jivNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yusa Wakaní̱ ashí nekas tiniu asa ashí nekasa nuna unuitiamprattarme. Ni enentáimmiaja̱i̱ tíchattawai antsu winia Aparuí̱ antukma nuna ujatmaktatui. Ukunam átatna nunasha ujatmaktatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ashí Wínian ujatmak Winia shiir awajtustatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ashí winia Apar takakna nusha Wíniaiti. Nu asamtai “ashí Wínian ujatmaktatui” tajai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‘Ishichik pujusrum Winia wáitkiashtatrume. Nuyá ataksha ishichik pujusrum ataksha wáitkiattarme. Wisha winia Aparuí̱ wéajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nuyá ni unuiniamuri̱ nuamtak aniniaisarmiayi “¿Jú̱ chichamsha warimpait? “Ishichik pujusrum wáitkiashtatrume tura ataksha ishichik pujusrum wáitkiattarme tura Aparuí̱ wéajai” tátsuk. ");
INSERT INTO jivNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ishichik pujusrum” tana nusha ¿warimpait? Nii tana nu ántatsji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesussha nin aniastai táman nekáa tímiayi “Ishichik pujusrum wáitkiashtatrume nuyá ataksha ishichik pujusrum wáitkiattarme” tímiajai. ¿Núchakait átum inintrustin wakerarmena nu? ");
INSERT INTO jivNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ti nekas tájarme: Átumka kúntuts pujusrum úuttiatrume tura Yus-shuarcha warásártatui. Tuma ai̱ṉkⁱ átum kúntuts pujayatrumek ukunam warastatrume. ");
INSERT INTO jivNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iis, nuwa̱sha jurertin tsawant jeamtai najaimiak wáitiatsuk. Tura uchin jurerka ti waraak wáitsamunka enentáimtsui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Atumsha núnisrumek yamaik kúntuts pujarme. Tura atak íitjiarum tusan winiakui ti shiir atumí enentái̱n warastatrume. Nu warastinian jurutramkichminia áiniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‘Nu tsawantinkia peṉké ininsashtatrume. Ti nekas tájarme Winia enentáimtursarum winia Apar searum nuna ashí amastatui. ");
INSERT INTO jivNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yamaisha Winia enentáimtursarum winia Apar seachurme. Seakrumniṉkia amastatui ti shiir warasaruk tusa’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Métek-taku chichamja̱i̱ nakumkan nuna tímiajai. Tura ukunmaṉka nuja̱i̱ chichatsuk winia Aparnan paant ujaktatjarme. ");
INSERT INTO jivNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Nu tsawantai̱ átumka Winia enentáimtursarum winia Apar seattarme. Winia Aparsha atumin anea asamtai Wi Nin áujsatin atsumashtatrume. Winia anentu asarum tura winia Aparuí̱ya̱ taman enentáimtakrumin Niisha anenmawai. ");
INSERT INTO jivNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Winia Aparuí̱ya̱ jíinkin jú̱ nuṉkanam táwitjai. Yamaikia jú̱ nuṉkanmaya̱ jíinkin ataksha Aparuí̱ wáketjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nuyá ni unuiniamuri̱ tiarmiayi “Yamaikia métek-taku chichamja̱i̱nchu chichaame. ");
INSERT INTO jivNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mash nékaitme. Shuar Ámin ininmatsa̱i̱ṉ péṉker áimkiatin nékame. Nu nekaar Ame nekas Yúsnumia̱itme tu enentáimtaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tura Jesus tímiayi “¿Nekasash enentáimtarum? ");
INSERT INTO jivNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ti warik átumka ashamkarum niisháa tsakiṉmaktatrume tura Winiak ikiurkittiarme. Antsu winia Apar pujakui Wiki pujatsjai. ");
INSERT INTO jivNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Winia enentáimturkuram imiatkinchanum pujusarat tusan tájarme. Jú̱ nuṉkanam ti wáitsattarme. Tura Wi jú̱ nuṉkanmaya̱n nupetka asamtai warastarum” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nuna ti̱ Jesus nayaimpinmaani̱ íimias tímiayi “Aparu, yamái jeayi ame Uchiram shiir awajsatin. Núnisaṉ ame Uchirmisha péṉker awajtamsattawai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ashí shuara Akupniuri̱ najataitme. Nuja̱i̱ṉkia Winia surusumna nú shuaran yamaram iwiaakman tuke amuukashtinian súsaitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aparu, chíkich atsawai. Amek nekas Yúsaitme. Wisha Jesuskrístuitjai Ame akuptukmamna nu. Nu asamtai ashí shuar nuna enentáimtak yamaram iwiaakman tuke amuukashtinian takakui.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‘Ashí túratniun akuptukmamna nuna amukuitjai. Túran ju̱ nuṉkanam shiir awajsaitjame. ");
INSERT INTO jivNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nuna túramtai, Aparu, ti yaunchu jú̱ nuṉka atsa̱i̱sha Ámiji̱a̱i̱ pujakui shiir awajtusmamna núnismek yamaisha shiir awajtusta.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Ashí jú̱ nuṉkanmaya̱ surusmamna nú shuaran Ámin nekamtikiamjai. Áminiu áiniakui surusmame. Niisha ame chichammin umirtámkaruiti. ");
INSERT INTO jivNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ashí Wi takaajna nu Amek surusuitme. Niisha nuna nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ame chichamem surusmam nuna ujakam niisha umirtámkaruiti. Ame akuptukakmin Ami̱i̱níya̱ táwitjai. Nu nekasaiti tu enentáimtuiniawai.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Nin yaiṉkiarta tusan seajme. Jú̱ nuṉkanmaya̱ shuaran Ámin enentáimturmainiatsna nuna seattsujai. Antsu Ame surusmam nuna, Áminiu ajasarmatai, yáiṉkiarta tusan seajme. ");
INSERT INTO jivNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ashí Winia ainia nuka Áminiuiti. Tura ashí Áminiu ainia nuka Winia áiniawai. Winia péṉkerusha ni túramunam paant awajsaiti.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‘Wikia yamaikia jú̱ nuṉkanam pujuschattajai. Tura nu shuarka jui̱ pujuartatui. Antsu Ámiji̱a̱i̱ pujustajtsan winiakui ashí surusumna nuka, Aparu, ti shiir asam ame kakarmarmi̱ji̱a̱i̱ wáinkiata. Wisha Ámiji̱a̱i̱ chikichik ájinia núnisaṉ niisha ashí iruntrar chikichik ajasarti. ");
INSERT INTO jivNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jui̱ niiji̱a̱i̱ pujakun ame kakarmarmi̱ji̱a̱i̱ ti péṉker wáinkiamjai. Antsu Yus-Chichamnum aarma uminkiati tusa aya chikichik meṉkakaiti. Niisha tuke emesnartinia núiti.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Yamaikia Amii̱ni winiajai. Tura jui̱ tuke pujakun ju̱na tájame. Niisha Wi waraajna núnisar ti shiir warasarat tusan tajai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Wi jú̱ nuṉkanmaya̱nchuitjai. Niisha núnisaṉ jú̱ nuṉkanmaya̱nchu áiniawai. Tuma asamtai ame chichammin Wi susamtai jú̱ nuṉkanmaya̱ shuarka nin nakitiainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jú̱ nuṉkanmaya̱ jí̱i̱ki̱ tusan seatsjame. Antsu íwianch nin nupetka̱i̱ṉ tusan seajme. ");
INSERT INTO jivNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wi ju̱ya̱nchuitiaj áintsaṉ niisha ju̱ya̱nchu áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ame chichammin ti nekasa nuna ántuiniakui péṉker awajsata. ");
INSERT INTO jivNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ju̱ya̱ shuarnum akuptukmam áintsan Wisha nin chíkich shuarnum akupeajai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aya Áminiunak takastaj tusan enentáimtimjai. Túra asamtai niisha aya Áminiunak takastinian enentáimpratin áiniawai’ áujtak tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Aya níiniunkeka seatsjame antsu ashí ni chichame̱n antukar Winia enentáimtursartatna nusha ame yáiṉkiarta tusan seajme. ");
INSERT INTO jivNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ashí niisha chikichkiniak enentáimtusarti tusan seajme. Wisha Amesha, Aparu, chikichik ájinia núnisaṉ niisha Iiji̱a̱i̱ iruntrar chikichik ajastai tusar seajme. Wíi shuar chikichik najanata tusan seajme. Nuyá ju̱ nuṉkanmaya̱ shuar akuptukuitmena nuna nekaawartatui. ");
INSERT INTO jivNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ame shiir awajtursamna núnisnak Wisha nin shiir awajsaitjai. Iikia chikichik ájinia núnisaṉ niisha chikichik ajasarti tusan túraitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wi ni enentái̱n pujakui Amesha Winin pujakmin peṉké chikichik ajasarti. Túramtai ashí shuar ju̱na nekaawartatui: Ame akuptukuitme, tura Winia anenmena áintsam nu shuarsha aneame. Wíi shuar chikichik ajasmaja̱i̱ ashí shuar nuna nekaawartatui.’ ");
INSERT INTO jivNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Aparu, shuar surusmam nu, Wi pujustatjana nui̱ pujusarti tusan seajme. Tura ti shiir awajtusmamna nuna íisarti tusan nuna seajme. Ju̱ nuṉka najanchamunmaṉ tuke anentin asam ti shiir awajtusuitme. ");
INSERT INTO jivNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aparu, ti péṉker áminiṉ ju̱ nuṉkanmaya̱ shuar nekarmainiatsui. Antsu Wi nékajme. Ju̱ shuarsha ame akuptukman nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nú shuaran Ámin nekarmawarti tusan jintintiaitjai. Tura nu arantcha jintintiattajai. Núja̱i̱ṉkia Wisha ni enentái̱n pujurkui Winia anenmena áintsaṉ niisha aneṉkratin ajasartatui” áujtak tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesussha nuna tinia amuk ni unuiniamuri̱ji̱a̱i̱ Setruṉ entsá katiṉ numi arakmanum wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jútassha Nin suruktajtsa pujumia nuka nu ajan nekaamiayi. Untsurí̱ tsawant Jesus ni unuiniamuri̱ji̱a̱i̱ nui̱ iruntramtai Jútas Jesusan nui̱ wáinkiatniun enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tura untsurí̱ suntarja̱i̱sha Jesusan tariarmiayi. Pariséusha Israer-shuar Patri uuntri̱sha suntarnasha Yusa Je̱e̱n wáiniuncha Jesusan achikiarat tusa akupkarmiayi. Niisha machitniasha naṉkincha rámparancha jiniasha júkiar weriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesussha ashí átinia nuna neka asa jiintiuki “¿Ya e̱a̱a̱rum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Niisha “Nasarétnumia̱ Jesus” tiarmiayi. Jesussha “Wiitjai” tímiayi. Jútassha Jesusan surukua nu niiji̱a̱i̱ pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tura Jesus “Wiitjai” takui ti ashamkar úkumur waketainiak iniaararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ataksha Jesus “¿Ya e̱a̱a̱rum?” tímiayi. Niisha “Nasarétnumia̱ Jesus” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nuiṉkia Jesus tímiayi “Wiitjai, tájarme. Winia e̱a̱tkurmeka Wíi shuar ainia ju̱ka waketkiarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus nuik aujuk “Winia Apar surusma nu meṉkakacharai” timia nu uminkiati tusa Jesus “waketkiarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nuyá Semuṉ Pítiur machitian jusa Marku kuíshi̱n untsuurnumaani̱ tsupirkamiayi. Markusha Israer-patri uuntrí̱ takarniuri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Túramtai Jesus Pítrun tímiayi “Machitrumka awaiṉki ikiusta. Winia Apar wáitsatniun surakuiṉkia ¿wáitsashtinkaitiaj?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nuiṉkia apach suntarsha ni kapitiántri̱sha Yusa Je̱e̱n wainniusha Jesusan achikiar jiṉkiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nuyá Anasa je̱e̱n júkiarmiayi. Anassha Kaipiasa wea̱rí̱yayi. Tura Kaipias nu uwitin Israer-patri uuntri̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaipiaska nuik “¿Ashí Israer-shuar mesertin péṉkerkait. Antsu aya chikichik shuar jákatin péṉkerchakait?” timia núiti. ");
INSERT INTO jivNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Semuṉ Pítiur chíkich unuiniamuja̱i̱ Jesusa uku weriarmiayi. Israer-patri uuntri̱ nú unuiniamunka nékauyayi. Tuma asamtai ni je̱e̱n jeawar, suntar Jesusja̱i̱ a̱a̱ tanishnum wáiniakui niisha waya̱miayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tura Pítiur a̱a̱ wáitiniam wajaamiayi. Túramtai chíkich unuiniamu jiinki wáitin wáinia nú nuwa̱ja̱i̱ chichas Pítrun awayámiayi. Nui̱ nékanu asa yúpichuch awayámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Waiti wáinniusha Pítrun aniasmiayi “¿Amesha nuna unuiniamuri̱nchukaitiam?” Pítrusha “Atsá, núchaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsetsek asamtai suntarsha tura nui̱ takarniusha jinia ikiapárar ni nawe̱n anaak pujuarmiayi. Pítrusha nui̱ pachiiniak anamuk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Israer-patri uuntri̱ Jesusan aniasmiayi “Ame unuiniamurmesha ¿ya ainia. Tura warí nin jintintiaitiam?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesussha tímiayi “Ashí íimiainiai̱ṉ tuke etserniuitjai. Israer-shuar iruntainmasha Yusa Uunt Je̱e̱ncha Israer-shuar irunainia nui̱ arantutsuk tuke etserkaitjai. ");
INSERT INTO jivNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Urukamtai Winia inintiam? Winia chichamprun antukua nu aniastarum. Wi timian nii ujatmakarti. Wi timiancha niisha nékainiatsuk.” ");
INSERT INTO jivNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus nuna takui Yusa Je̱e̱n wáiniua nu nui̱ pujá Jesusan yapiniam awati tímiayi “¿Núnisaṉ nekas úuntnum chichastinkait?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesussha tímiayi “¿Warinmampa yajauch aa? Turuttia. Tura tájana nu péṉkeraitkiuiṉkia ¿urukamtai awattiniam?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nuyá Anas Jesusan jinkiá Kaipias takaamunam akupkamiayi Kaipias Patri uuntri̱ asamtai. ");
INSERT INTO jivNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tuke Anasa je̱e̱n chichainiai̱ Pítiur jinia anamuk pujáṉ shuar aniak “¿Amesha Jesusa unuiniamuri̱nchukaitiam?” tiarmiayi. Pítrusha “Atsá, wíchaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chíkich takarin, Marku shuari̱, nui̱ pujumiayi. Pítiur Marku kuíshi̱n tsupirkamia nuna shuari̱ asa tímiayi “¿Ajanam Jesusja̱i̱ wekaamin wáinkiachmakajam?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pítrusha ataksha “atsá” taiṉ atash shiniukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nuyá Kaipiasai̱ya̱ Jesusan júkiar tsawant tsawa̱a̱munam apach kapitián Piratu takatai je̱a̱nam ejeniarmiayi. Israer-shuarsha ni uuntri̱ akupkamia nunisar wapik ajasa̱i̱j tusar nu je̱a̱nam waya̱charmiayi. Waya̱warka paskua nampernum yurumáchmin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nu asamtai Piratu niiji̱a̱i̱ chichastaj tusa jíinki tímiayi “¿Jú̱ áishmaṉsha warí tunáa túrait?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niisha “Tunaarinchaitkiuiṉkia ami̱i̱ni itiacha̱a̱ji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tutai Piratu tímiayi “Atumek júkirum atumí akuptammariji̱a̱i̱ ni tunaari̱ nekaatarum.” Israer-shuarsha tiarmiayi “Antsu iikia Israer-shuartikia tunáa shuarsha máachminiaitji.” ");
INSERT INTO jivNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yaunchu Jesus ni jákatniuri̱n enentáimtus “Wi awajnaitniuitjai” tímiayi. Niisha krúsnum awajnain asamtai apach máataiji̱a̱i̱ Nii timia nu uminkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Piratusha atak je̱á wayá Jesusan untsuk “¿Ámeka Israera Uunt Akupniuri̱ṉkaitiam?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesussha tímiayi “¿Amekek nu inintram. Kame chíkich túramainiatsuash?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piratusha tímiayi “¿Wi Israer-shuarkaitiaj? Amee shuarak Israer-patri uuntri̱ji̱a̱i̱ winin itiarmarai. ¿Warí tunáa túraitiam?” ");
INSERT INTO jivNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nuiṉkia Jesus tímiayi “Wi jú̱ nuṉkanam akupniuchuitjai. Ju̱ya̱itkiuiṉkia Winia nemartuiniana nu máanaikiara̱a̱yi. Túrawarmatai Israer-shuarnum surutkachara̱a̱yi. Antsu ju̱ya̱n akupniuchuitjai.” ");
INSERT INTO jivNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piratusha “¿Nuikia ame nekas uunt akupniukaitiam?” tímiayi. Jesussha tímiayi “Ee, ame támena nu nekasaiti. Jú̱ nuṉkanam akiinian ashí shuaran nekas ana nuna ujaktinian táwitjai. Ashí shuar nekas ana nuna umirniuka Wi táman ántawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tura Piratu “¿Nekasa nusha warimpiait?” tímiayi. Piratusha nuna ti̱, atak Israer-shuarja̱i̱ chichastajtsa jiinki tímiayi “Jú̱ aishmaṉka tunaari̱n peṉké wáittsujai. ");
INSERT INTO jivNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tura ashí uwitin paskua nampernum sepunmaya̱ shuar aṉkant akupkatniuiti. Núnisrum tuke searme. Tuma asamtai, ¿yamaikia Israera Uunt Akupniuri̱n aṉkant akupkattajak?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nuiṉkia ashí kakantar untsumainiak “Ju̱ akupkaip; antsu Parapás akupkatá” tiarmiayi. Nu Parapássha kásauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nuyá Piratu suntaran akupkamiayi Jesusan asutiáwarat tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Suntarsha Jesusan wishikrar tawasap jaṉki najanamun etseṉkrumtikiarmiayi. Yamakai pushincha uunt akupniua áintsaṉ áentsrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nuyá “Israera Uuntri̱a, kakaram ajasta” tiar yapiniam awatiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nuyá Piratu atak jiinki tímiayi “Átum wáinkiarum nekaatarum tusan Jesusan jí̱i̱ktiatjai. Wikia tunaari̱nkia peṉké wáittsujai.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tímiatai Jesussha jaṉkin etseṉkruku tura pushin yamakairman entsaru jíinkimiayi. Tura Piratu nui̱ káunkarun tiarmiayi “Pai ju̱iti, íistarum.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Israer-patri uuntri̱sha suntarsha Jesusan íisar ataksha ataksha kakantar untsumainiak “Krúsnum jakati” tiarmiayi. Piratusha “Átum júkiirum máatarum. Ni tunaari̱n peṉké wáittsujai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tura Israer-shuar tiarmiayi “Nu shuar “Yusa Uchirí̱ntjai” takui jákatniuiti. Iiniu akupeamu aarma nui̱ núniskete” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nuna antuk Piratusha nu naṉkaamas ashamkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ataksha init wayá Jesusan aniasmiayi “¿Tuya̱mpaitiam?” Tura Jesussha peṉké ái̱kchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nuyá Piratu tímiayi “¿Urukamtia winia a̱i̱rtsum. Wi jeajna nu nékatsmek? Wakeraknaka krúsnum máatniuncha tura aṉkant akupkatniuncha jeajai.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tutai Jesussha tímiayi “Yus nuna amaschaitkiuiṉkia peṉké tujinkiaintme. Nu asamtai ami̱i̱n surutka nu ámin naṉkaamas tunaarinniuiti.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Piratusha nú chichamtaik Jesusan aṉkant akupkattsa wakerimiayi. Antsu Israer-shuar untsumainiak tiarmiayi “Ju̱ aṉkant iníakmeka ame úunt akupniu amikri̱nchuitme. Ju̱ka “úunt akupniuitjai” taku atumí uunt akupníuri̱ nemasrinti” tu untsumkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Piratusha taman antuk akupin pujutainium pujus Jesusan untsukmiayi. Nui̱ kaya ukatkamu asamtai Israer-shuara chichame̱n Kapata anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paskua jisat jeatsa̱i̱ṉ nantu tutupin ajatsa̱i̱ṉ Piratu Israer-shuaran tímiayi “Uunt akupniuram íistarum.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tura ashí “Jakati, jakati, krúsnum máatá” tu untsumkarmiayi. Tura Piratu “¿Atumí uunt akupniuri̱n krúsnum máattajak?” tímiayi. Tura Israer-patri uuntri̱ tiarmiayi “Atumí uunt kapitiántrumek in akuptamji. Chíkichka atsawai.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tutai Piratu Jesusan krusnum mantamnati tusa tsankatkarmiayi. Tutai niisha Jesusan júkiar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesussha ni krusri̱ yanaki Kúrkuta náinnium wémiayi. Kúrkuta naari̱sha Israer-shuara chichame̱n “muuka ukunch” tawai. ");
INSERT INTO jivNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nui̱ krúsnum ajintrurar awajainiarmiayi. Tura mai pae̱ jimiará shuaran chikichik chikichik awajainiarmiayi. Tura Jesus ajapén ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piratusha Jesusa krúsri̱n uunt áarman anujkamiayi. NASARETNUMIA̱ JESUS, ISRAERA UUNT AKUPNIURI̱ Tu áarmauyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Israer chichamja̱i̱sha Kriaku chichamja̱i̱sha Rúmanmaya̱ chichamja̱i̱sha áarmauyayi. Menaintiu chichamnum aarma asamtai tura Jesusaréṉ pepru tíjiu̱ch asamtai Israer-shuar ti untsurí̱ áujiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nu asamtai Israer-patri uuntri̱ Piratun jeariar “Israera Uunt Akupniuri̱” áaraip. Antsu “Israera Uunt Akupniuri̱ntjai tawai” tu aarta” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tura Piratu nincha ái̱kiar “Wi áaraj nuke átatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Suntarsha Jesusan krúsnum awajainiar ni entsarmari̱n kuátru akankar aṉkant aṉkant júkiarmiayi. Tura ni pushiri̱n apatsuk najanamu asamtai jáa̱ktinian nakitrarmiayi. Kame yakí̱ya̱ nuṉkaani̱ apaiyia̱chma takamtsukuyi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tuma asamtai suntar tiarmiayi “Ju̱ka jáa̱kchatai. Antsu nakurakrin yának ati nu jukiti.” Núja̱i̱ṉkia yaunchu Yus-Chichamnum aarma nu uminkiamiayi: “Winia entsarmarun akantrarmiayi tura nakurusar awakmakua nuna winia pushirun súsarmiayi” áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Krúsnumsha Jesusa nukurí̱sha Kriúpasa nua̱rí̱ Marisha tura Máktaranmaya̱ Marisha wajaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus ni nukurí̱ncha tura ni ti aneamu unuiniamuri̱ncha nui̱ wajan wáiniak ni nukurí̱n tímiayi “Nukuru, ju̱ ame uchirmea áintsaṉ atí.” ");
INSERT INTO jivNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nuyá ni unuiniamuri̱ncha tímiayi “Ju̱ ame nukua áintsaṉ atí.” Nu tsawantaik nu unuiniamuri̱ ni je̱e̱n jukí awayámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nuyá ashí uminkiamtai Jesus nuna nekáa yaunchu Yus-Papinium aarma uminkiati tusa “kitiamajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nui̱sha piniṉnum churuín ámiayi. Tura shuar nuna uruchja̱i̱ ejampar sapapja̱i̱ ijiu mukunaati tusa susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesussha churuínian naje̱kaa “ashí túrunatniua nu mash uminkiai” tímiayi. Nuna ti̱, muuken nená jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nu tsawantai̱, kashinkia paskua námper uunt tsawantri̱ asamtai tura ayampratin tsawant aa asamtai, Israer-shuar jaka aya̱shí̱ nui̱ paant ai̱ṉ tusa nakitrarmiayi. Nu asamtai Piratun seainiak “Krúsnum ajintrurma ainia nuna kaṉkajin suntar kupirkarti. Nuyá wari jákarmatai krúsnumia̱ júkiarti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nuyá suntarsha weriar emka krúsnum amia nuna kaṉkaji̱n kupirkarmiayi. Nuyá chikichnasha Jesusja̱i̱ atsankiar ajintrurma nuna kaṉkaji̱ncha kupirkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tura Jesusan weantuk yaunchu jákaiti tusa kaṉkaji̱n kupirtsuk ");
INSERT INTO jivNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","suntar aya paenam ijiumiayi. Ijiumtaisha nu chichamtaik numpa yumiji̱a̱i̱ puarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wi, Juaṉ, nuna wainkia asan nekas tajai. Atumsha Yus enentáimtustarum tusan tí nekas tajai. Wi áarajna nu nekasaiti nékajai. ");
INSERT INTO jivNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yaunchu Yus-Chichamnum aarma uminkiati tusa túrunaiti: “Ni ukunchi̱n kupirkachartatui” tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tura chikichcha: “Ijiuarmiania nuna wáinkiartatui” tu áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nuyá Arimatéanmaya̱ Jusé Jesusa aya̱shí̱n jukitiaj tusa Piratun seamiayi. Nu Jusé Jesusan enentáimtaitiat Israer-shuara úuntri̱n ashamak paant nemarsachmiayi. Niisha seamtai Piratu “Jukitia” tímiayi. Tutai Jusé Jesusa aya̱shí̱n jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikiutémusha Jesusja̱i̱ chichastaj tusa kashi tarimia nu jimiará kuṉkuin pachimpramun ti nukap sumak itiamiayi. Mira kuṉkuinniasha aruí kuṉkuinniasha sumakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nuyá Jusé Nikiutémuja̱i̱ Jesusa aya̱shí̱n júkiar kuṉkuinian kuérar jaanch esarmaja̱i̱ penuararmiayi. Israer-shuar tuke nunisar ikiúu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesus krúsnum maamua nui̱ aja tíjiu̱ch ámiayi. Nu ajanmasha wa̱a̱ náinnium paka taurma ámiayi. Nusha yama taurma asamtai jaka nui̱ ikiuschamuyayi. ");
INSERT INTO jivNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nu wa̱a̱sha tíjiu̱ch asamtai tura Israer-shuara ayampratin tsawantri̱ jeatemamtai Jesusa aya̱shí̱n nui̱ iwiarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tumiṉtincha káshik kirit ai̱ṉ Máktaranmaya̱ Marí Jesus iwiarsamunam íistajtsa wémiayi. Jesusan iwiarsar kaya uuntja̱i̱ wa̱a̱n atutkarmiayi. Tura Marí nui̱ jeá nu kaya uraimiun wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nuna wáiniak Semuṉ Pítiur pujamunam tsékeṉki wémiayi. Chíkich unuiniamuri̱ Jesus ti anemia nusha nui̱sha pujumiayi. Tura Marí tímiayi “Iwiarsamunmaya̱ ii Úuntri̱n júkiarai. Tura ¿tuíntsuk ikiusara?” ");
INSERT INTO jivNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pítrusha chíkich unuiniamuri̱ji̱a̱i̱ jíinkiar iwiarsamunam iyuwarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mai métek tsékeṉkiar Pítiur jeatsa̱i̱ṉ chíkich unuiniamuri̱ iwiarsamunam emka jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Niisha waya̱tsuk tsuntsumá iis penuarmari̱ṉkia nui̱ tepan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nuyá Semuṉ Pítiur ukunam jeá iwiarsamunam wayá penuarmari̱ nui̱ tepan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chíkich jaanchcha Jesusa muuke̱n penuarma nusha nanerma niisháa tepan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nuyá chíkich unuiniamuri̱ emka tamia nusha iwiarsamunam waya̱miayi. Niisha túruna wáiniak “Jesus nekas nantakni” tu enentáimpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nuna wáintsuk Yus-Chichamnum “Jesus jakamunmaya̱ nantaktiniaiti” áarman áujsariat nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nuyá mai ni je̱e̱n waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tura Marikia iwiarsamunam juak úutu pujumiayi. Niisha úutiataṉ tsuntsumá iwiarsamunam íimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tura Jesusa aya̱shí̱ nuik tepesmanum nayaimpinmaya̱ suntar puju entsaru jímiar pujan wáinkiamiayi. Chikichik múuknumaani̱ tura chíkichka nawe̱nmaani̱ pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nayaimpinmaya̱ suntarsha “¿Urukamtai úutam?” tiarmiayi. Marísha tímiayi “Winia Úuntrun jurutkiarai tura ¿tuintsuk ikiusara?” ");
INSERT INTO jivNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nuna ti̱ ayanmar Jesusan wáiniak Nin nekaachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus aniak “¿Urukamtai úutam. Ya e̱a̱a̱m?” tímiayi. Marisha ajan wáinniua nuiti tusa tímiayi “Uunta, ame ni aya̱shi̱ jukimkia, tui ikiusmam ujatkata wi jurumkitiaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nuyá Jesus “Mariya” tímiayi. Tutai niisha ayanmar “Rapuni” tímiayi. Nusha Israer-chichamnum “Uuntá” tawai. ");
INSERT INTO jivNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesussha tímiayi “Emetruawaip. Winia Aparui̱ wáatsjai. Antsu weme Wíi shuar titiá “Winia Aparuí̱ nayaimpiniam wéajai. Niisha atumí Aparí̱nti. Winia Yúsruiti tura atumí Yúsrinti” tawai titiá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nuyá Máktaranmaya̱ Marisha Jesusa unuiniamuri̱n wáiniak “Wi Úuntan wáinkiajai, tímiayi. Niisha ju̱na mash túrutui” tu ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nu tsawantai̱, tumiṉtin, ni unuiniamuri̱ Israer-shuara úuntrin ashamainiak kashi iruntrar waiti epeni pujuarmiayi. Túrasha Jesus áyatik waya̱miayi. Tura ajapén wajas “shiir pujustarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nuna ti̱, nuyá ni uweje̱n ajintruamuncha ni pae̱n ijiumuncha iniakmasmiayi. Ni unuiniamuri̱sha Úuntri̱n wáinkiar shiir warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ataksha Jesus “Shiir pujustarum, tímiayi. Winia Apar akatar akuptukma núnisnak Wisha akatran akupeajrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nuyá ni matsatmanumaani̱ umpuí tímiayi “Yusa Shiir Wakaní̱ atumí enentái̱n waya̱ti. ");
INSERT INTO jivNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Shuara tunaari̱ṉkia átum “asakártí” tákurminkia tsaṉkurnartatui. Tura nu shuar “sumamati” tákurminkia tuke sumama pujawai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tura chikichik unuiniamu, Jímiampramu Tumas, Jesus tamia nui̱ pujuchmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tura ukunam chikich unuiniamuri̱ ujainiak “Ii Uuntri̱ wáinkiaji” tiarmiayi. Tura Tumas tímiayi “Ajintruamuri̱ wáinkian uwe̱jrun awa̱intiuatniuitjai. Tura paenumsha awa̱intiuatniuitjai. Peṉké jaka asamtai aya nuja̱i̱ iniantkimiun enentáimtustatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chíkich tumiṉtin ataksha Jesusa unuiniamuri̱ iruntrarmiayi. Nuiṉkia Tumassha niiji̱a̱i̱ pujuarmiayi. Tura waiti epenmianumaṉ Jesus wayá ajapén wajas “Shiir pujustarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nuyá Tumasan tímiayi “Winia uwe̱jur íisam ame uwe̱je̱m awa̱intiuata. Núnismek winia paerui̱ uweje̱m awa̱intiuam íistá. Tura arantutsuk nekas enentáimtursata.” ");
INSERT INTO jivNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nuyá Tumas “Winia Úuntrua, nekas winia Yúsruitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesussha tímiayi “Winia wáitkiam nuiṉ enentáimtursame. Antsu Winia wáittsuk enentáimturaru nekas shiir áiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aentsti tujintiamuncha Jesus túramu ti untsurí̱ ju̱ papinium áarchamu áiniawai. Tura ni unuiniamuri̱ mash wáinkiarmai. ");
INSERT INTO jivNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Antsu Jesuska Kristu asa Yusa Uchirí̱nti tu enentáimtustarum tusan jú̱naka áarmajai. Tura enentáimtakmin Jesus ni iwiaakmari̱n yamarma nuna amastatui. ");
INSERT INTO jivNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tipirias antumiaṉka káanmatkari̱i̱n Jesus ni unuiniamurí̱n wantintiukmiayi. Jú̱nisaṉ ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Semuṉ Pítrusha Jímiampramu Tumassha Kananmaya̱ Natanaérsha Sepetéu uchirí̱sha tura chíkich jímiar unuiniamuri̱sha métek iruntrar pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Semuṉ Pítrusha “Namakan nekaja̱i̱ naṉkiattsan wéajai” tímiayi. Chíkich mash “Iisha winittiaji” tiarmiayi. Wéar uunt kanunam eṉkemprar nu kashi achitsuk tsawa̱rarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Káshik ai̱ṉ Jesus entsá káanmatkarí̱i̱n wantinkiamiayi tura ni unuiniamuri̱sha Jesusan nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesussha tímiayi “Uchiru, ¿namak achikiurmek?” Niisha “Atsá” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tutai Jesus tímiayi “Neka untsuurnumaani̱ ajunkatarum. Nui̱ achiktatrume.” Nii timia núnisaṉ túrawar namakan ti achikiar nekan júsatniun tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Núja̱i̱ṉkia Jesusa unuiniamuri̱ Jesus ti aneemia nu Pítrun tímiayi “Ii Úuntri̱nti.” Takui Pítrusha áimiaku asa ni pushiri̱n entsar entsá iniaṉmiayi yukuak jeataj tusa. ");
INSERT INTO jivNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chíkich unuiniamuri̱sha jeachat pujuiniachuk nekan japiki kanuja̱i̱ káanmatkanam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Káanmatkanam jeawar ji kai̱i̱r ámanum namakan jiámun wáinkiarmiayi. Tantancha wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesussha “Átum achikiurmena nuyá jiátin itiatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tutai Semuṉ Pítiur kanunam we nekan nekartiuk káanmatak japiki itiamiayi. Itiar namaknasha siaṉtu seṉkuenta nuyá tres (153) nekapmararmiayi. Ti untsurí̱ áyat nekasha jáankachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nuyá Jesussha “Yurumáitiarum” tímiayi. Ni unuiniamuri̱sha “aya ii Uuntri̱ áminiaiti” tusar inintrustinian natsantiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nuyá Jesus wajaki tantan jukí súsarmiayi. Núnisaṉ namaknasha súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus jakamunmaya̱ nantaki ju̱ja̱i̱ menaintiu ni unuiniamuri̱n wantintiukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nuyá yurumáwar Jesus Semuṉ Pítrun aniasmiayi “Junasa uchirí̱ Semuṉka, ¿ju̱ shuar naṉkaamas anentmek?” Pítrusha tímiayi “Ee, Uunta, wi wakerajam nu Ame nékame.” Jesussha “Nuiṉkia winia murikiur ayuratniua áintsam Winia enentáimturainia nu yaiṉtá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ataksha aniasmiayi “Junasa uchirí̱ Semuṉka, ¿Winia anentmek?” Pítrusha “Ee, Uunta, wi wakerajam nu Ame nékame” tímiayi. Jesussha “Winia murikiur wáinkiatá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nú ataksha aniasmiayi “Junasa uchirí̱ Semuṉka, ¿winia wakerutamek?” Pítrusha menaintiu iníam kúntuts enentáimiar tímiayi “Uunta, ashí nékame. Wi wakerajam nu Ame nékame.” Jesussha tímiayi “Winia murikiur ayurata. ");
INSERT INTO jivNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Maa, nekas tájame. Natsa asamka iwiarmampram ame wakeramunam wéuyame. Tura úuntach ajasmeka ame kunturam ayaparakmin chíkich aentstamprattawai tura ame wétin nakitiam nui̱ juramkiartatui.” ");
INSERT INTO jivNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus núja̱i̱ṉkia Pítiur máatniun ujakmiayi. Tura núnisaṉ jakamtai shuar Yúsan shiir awajsatniun ujakmiayi. Nuyá Pítrun “Nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pítrusha ayanmar chíkich unuiniamuri̱n Jesus ti anea nuna némarun wáinkiamiayi. Kame nu unuiniamuka nuik Jesus jáatsa̱i̱ṉ yurumáiniakui “Uunta, ¿ya surutmaktata?” timia núiti. ");
INSERT INTO jivNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nincha Pítiur wáiniak Jesusan aniasmiayi “Uunta, ¿ju̱sha warí urukatniuit?” ");
INSERT INTO jivNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesussha a̱ya̱k “Wi wakeraknaka iwiaaku pujai̱ṉ tátatjai tíminiaitjai. Nuna tákuisha ¿warí itiurtama? Ámeka nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Núja̱i̱ṉkia “Nu unuiniamurí̱ jákashtatui’ tusa Yus-shuarnum áujmatiarmiayi. Túrasha Jesus “jákashtatui’ tíchamiayi antsu áyatik “Wi wakeraknaka iwiaaku pujai̱ṉ tátatjai takuisha ¿warí itiurtama?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wikia nú unuiniamuri̱ntjai. Ju̱ papincha aaru asan “mash nekasaiti’ tajai. Ashí shuarsha núnisaraṉ tuíniawai. ");
INSERT INTO jivNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nu arantcha ju̱i̱ áarchamusha ti awai. Kame ashí áamka ti untsurí̱ papí asa ashí nuṉkanam ikiuschamnia ainti. Nuke atí.");
INSERT INTO jivNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Amikiur Tiúpiru: Nuik akupkamiaj nú papinium ashí Jesus túramia nuna áatramiajme. Tura unuitiampramiaj nunasha áatramiajme. Yámankamtaiknumia̱, ");
INSERT INTO jivNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nayaimpiniam wétsuk, ashí Nii túramia nuna tímiajme. Jesuska, nayaimpiniam wakettsuk Yusa Wakaní̱ kakarmari̱ji̱a̱i̱ túratniua nuna ni akatramuri̱n jintintiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tura jaka nantaki, Jesus tímiaja̱i̱k wantintiukmiayi ni akatramuri̱n. Tura kuarenta (40) tsawant nin wantintiukarmiayi. Nuna tura nekas iwiaakjai tusa iniakmasmiayi, nekaawarat tusa. Tura Yusa akupeamuri̱ urukukit nuna mash ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesuska ni akatramuri̱ji̱a̱i̱ tuke pujus, nin chicharuk “Jerusaréṉnumia̱ wéerap, tímiayi. Winia Apar “amastatjai” tímia nuna, paant ujakchamkajrum. Nu túrunat tusarum Jerusaréṉnum nákastarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tuke enentáimsatarum. Juaṉ entsaja̱i̱ atumí aya̱shi̱n imiatmimiarme. Túrasha wárik Yusa Wakaní̱sha atumniasha tarutmar, atumí enentái̱n eṉkemprutmattarme. Nusha enentái̱ imiantin áintsaṉkete” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tura Jesusja̱i̱ irunar matsamas anintriarmiayi “Uunta, Israer-shuar ájinia nu, aṉkant ajasakrin iiniuk Akupin atak naamkatin yamaí jeayash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus áimiuk tímiayi “Winia Apar túrattana nu warí tsawantinik túrunatí nu nekaatniusha atumniachuiti. Apar Niṉki neka asa ni kakarmari̱ji̱a̱i̱ṉ túrattawai. ");
INSERT INTO jivNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tura atumsha Yusa Wakaní̱ kakarmari̱n sunastatrume. Nii taa eṉkemprutmamtai kakaram ajasrum, Wíi túramu etserkattarme. Emka ju̱i̱ Jerusaréṉ péprunam etserkattarme. Nuyá ashí Jutía núṉkanam, tura arant Samaria nuṉkanmasha, tura nú arant ashí núṉkanam werum, Wíi túramu etserkattarme” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nuyá chichas amir, ashí ni akatramuri̱ ii wajainia̱i̱, Jesus nayaimpinmaani̱ junakmiayi. Wéa-wéakui yurankim mash Nin amu̱ámiayi. Tuma asamtai ni akatramuri̱ Nin wáinkiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tura Jesus waakkui ni akatramuri̱sha yakí ii wajainia̱i̱, jimiará áishmaṉ puju entsaru nui̱ wantintiukarmiayi. Tura aya̱mach wajattsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nu áishmaṉsha Jesusa akatramuri̱n tiarmiayi “Kariréanmaya̱ áishmaṉka, ¿urukamtai nayaimpinmaani̱ imiá íimprum? Ju̱ Jesusak atumíya̱ nayaimpiniam wea wáinkiarumna núnisaṉ ataksha winittiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tuasua amikmatai Jesusa akatramuri̱ Uriwiu náinniumia̱ akaikiar Jerusaréṉnum waketkiarmiayi. Uriwiu naincha Jerusaréṉnumsha tíjiu̱chiiti, chikichík kirumitrua núnisaṉ. ");
INSERT INTO jivNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tura Jerusaréṉnum jeawarmiayi. Nu̱i̱ jeawar, je̱á waya̱war yakí̱ wákararmiayi. Nui̱ Pítrusha, Jakupusha, Juaṉsha, Antressha, Jiripisha, Tumassha, Parturumísha, Mateusha, tura Arpeu uchirí̱ Jakupusha, nuyá ásump Semuṉsha, Jakupu yachi̱ Jútassha, tímian waya̱warmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ju̱sha mash tuke iruniarmiayi Jesusa yachi̱ji̱a̱i̱. Tura Jesusa nukurí̱ Mariji̱a̱i̱, nuyá chíkich nuwa̱ja̱i̱sha tuke iruniarmiayi, Yus áujsatai tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nui̱ siáṉtu painti (120) aents iruntrarmia nui̱ Pítiur chichastaj tusa wajakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pítiur ju̱na tímiayi “Yatsurtírmesha, umarutírmesha antuktarum. Yuska yaunchu ni Papiri̱i̱n Jutasnan áamtikramiayi. Jútas akiintsa̱i̱ṉ Tawitkia, Yusa Wakani̱ jintintiam Jutasnan áarmiayi. Jesusan achik surukarmia nú shuaran nekapruamia núiti. Kame Tawitia áarmari̱ Yus-Chicham asa tímianak uminkiatniuyi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nú Jutaska ii írutramuitiat, ii takaamuri̱n páchitkiaitiat, ");
INSERT INTO jivNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tunáa tura nuja̱i̱ kuítian achik nuṉkan sumakmiayi. Tura piniakum iniaaṉ tantane̱ páttimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tuma asamtai ashí Jerusaréṉnum pujuarmia nu, nuna nekaawar nú nuṉkan “Numpa Nuṉka” anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kame Sarmu papinium Tawitkia ju̱na áarchamkia: “Ni je̱e̱sha itiarak atí. Nu je̱a̱nmaṉka peṉké pujuschartí.” Tura “Ni takatri̱ chíkich atankiti.” Tu aarmaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","‘Tuma asamtai yamaikia chíkich anaikiatniuitji. Tura náṉkamas achikchatniuitji. Antsu ii nemartamkau atí. Uunt Jesus iiji̱a̱i̱ pujumia nui̱ tuke Nin nemarsamia nu atí. ");
INSERT INTO jivNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juaṉ Jesusan imiaimiania nú tsawantnumia̱ jukí, Jesus nayaimpiniam wémiania nú tsawantan tímianu ejé tuke Niiji̱a̱i̱ wekaimia nu atí. Nu shuar enentáimtusar, chikichik achiktai. Iisha iruntrar Jesusa nantakmiari̱ etserkamí tusar túramí” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tura nuyá jimiará shuaran anaikiarmiayi. Matíasan anaikiarmiayi. Tura chikichnasha Jusen, ni chíkich naari̱ Parsapas, tura apach náariṉkia Justu, nunasha anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tura nuyá Yus-shuar Yúsan áujainiak ju̱na tiarmiayi “Ii Uuntri̱, Amesha ashí shuara enentái̱ nékame. Ju̱i̱ awai jimiará áishmaṉ. Jútas tunáa túrak jákatniunam wéak akatramu takatan ikiukmiayi. Yamaikia Jútasa takatri̱ achikiat tusam, ¿tuá achikium, Uunta? Paant iniakmasta.” Tu aujsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tura Israer-shuara túrutairi̱ núnisaṉ, wats yaki nupetmakat tusar túrawarmiayi. Tura Matías nupetmakmiayi. Túrunamtai Matíasnak pachikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pintikiustís náartin jísat jeamtai, chikichík je̱a̱nmaṉ nuiṉ Yus-shuar tu̱akarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tuma̱i̱ aya aneachma nayaimpinmaya̱ nasea áintsaṉ téter ajaki winian antukarmiayi. Ashí mash je̱á pujuarmia nuka antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tura nui̱ pujuinia̱i̱ ji wajai̱ kea áaniun wáinkiarmiayi. Túruna aṉkant aṉkant puunak tarurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tuma asamtai Yusa Wakaní̱ ashí ni enentái̱n pimiutkarmiayi. Túram chichasarat tusa Yusa Wakaní̱ ni nekatairi̱ súsarmiayi. Tuma asamtai nuja̱i̱ niisha chíkich chichaman chichasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nui̱ Jerusaréṉnum Yus táman umirin Israer-aents ármiayi. Ashí nuṉkanmaya̱ Jerusaréṉnum taar matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tura túrunamia nuna antukar káunkarmiayi. Tura ashí shuar ni chichame̱ja̱i̱ṉ chichaamun antukarmiayi. Tuma ásar, warinkit, tu enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nekaachar ashamkarmiayi. “Wariṉkit, tunaim ajarmiayi. Ju̱ aents chíkich chíkich chichaman chichainia nu, ashí Kariréanmaya̱nchukait, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tura iisha aṉkant aṉkant ii chichame̱ṉka ántatsjik. Ausha urukainiakua, nunak chichainiawa, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ju̱i̱ ashí nuṉkanmaya̱ aents pujuiniatsjik. Partianmaya̱, Eramnumia̱sha, Misiuputámianmaya̱sha, Puntanmaya̱sha, tura Asia nuṉkanmaya̱sha, ");
INSERT INTO jivNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Príjianmaya̱sha, Pampirianmaya̱sha, Ejiptunmaya̱ tura Áprikianmaya̱ Serinia nú naṉkaamasnumia̱sha pujuiniatsjik, tiarmiayi. Nuya̱sha ii shuarsha Ruma péprunmaya̱ yaunchu taar ju̱i̱ matsatainiawai. Chikichcha tuke Israer-shuar áiniawai. Tura chikichcha Israer-shuar ajastaj tusa Israer túrutairi̱n mash túruiniawai. ");
INSERT INTO jivNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kritianmaya̱sha Arapianmaya̱ pujuiniaji. Tura ashí mash ii chichame̱ja̱i̱sha Yusa péṉker túramuri̱ ántaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ashí aents nuna nékachu ásar ashamkarmiayi. Tura nuámtak aniniaisarmiayi “¿Warinminiait ju̱?” ");
INSERT INTO jivNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tura chikichcha wishikiarmiayi. “Nampeku áiniatsuash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nuiṉkia Pítiur, chíkich áuntse Jesusa akatramuri̱ji̱a̱i̱ wajaki, kakantar chichasmiayi. Chichaak tímiayi “Jutíanmaya̱ shuartiram, Jerusaréṉnumia̱tirmesha antuktarum. Wi títiatjana nu antukrum péṉker enentáimpratarum. ");
INSERT INTO jivNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ju̱ áishmaṉ, nampekarai, tárumna nu, nampekcharai. Warí, nantu imiá ishichik takuni. ¿A̱i̱sha itiurak? ");
INSERT INTO jivNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Antsu Yúsnan etserin, ni naari̱ Juér, yaunchu áarmia nu, yamái túrunayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ju̱na áarmiayi: “Yus tawai “Jú̱ nuṉka amuukatin jeatemamtai, winia Wakantrun ashí áentsnum akupkattajai, yumi yaraanua áintsaṉ. Atumí uchiri̱, atumí nawantri̱sha Yusa chichame̱n áujmatiartatui. Tura nátsaka íimiarartatui. Tura uuntka mesekramiartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tura áishmaṉsha nuwa̱sha winia takartin ainia núnaka winia Wakantrun akuptukartatjai. Túram niisha Wíi túramun áujmatiartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yakí nayaimpiniam, aents túrachminian iniakmastatjai. Tura nuṉkanmasha winia kakarmarun iniakmastaj tusan numpancha, jiniasha, mukuintiuncha yuraṉmia áintsaṉ akupkattajai. ");
INSERT INTO jivNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tura tsawái nantusha kajinkiattawai. Tura nantusha mushatmar numpa núniktatui. Uunt tsawant achikmiajna nu jeatsa̱i̱ṉ, túrunattawai. Nú tsawantcha imiá nekas uunt átatui. ");
INSERT INTO jivNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nuiṉkia ashí shuar nekas winia kakarmarun seana nuka uwemprartatui” tímiayi Yus.” Núnis Juér áarmiayi’ tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tuke chichaak: ‘Israernumia̱ shuartiram, wi títiatjana nu antuktarum. Nasarétnumia̱ Jesusnan tajai. Nú Jesusan Yus shiir enentáimtawai. Yuska, átum ti enentáimprarum ni kakarmari̱n paant nekaatarum tusa, nú Jesusan ti ikiakármiayi. Tura Jesusja̱i̱ aentsti túrachminian Yuska túramiayi, átum íimmianum. Nuka ti paant nékarme, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tura Jesus surunkamia nuna Yuska yaunchu, túruntsa̱i̱ṉ, paant nekaamiayi. Túrasha Yus enentáimmia nuja̱i̱ métek túrawarmiayi. Tura atumek emetarum Jesus jukimiarme. Nú arant, krúsnum máatarum, tunáa shuar tímiarme. ");
INSERT INTO jivNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Túramunak Yus Jesusan jákatniun nupetmamtik iniantkimiayi, tuke jákachmin asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iimiata, ii uuntri̱ Tawit Jesusnan kantamprua ju̱na áarmiayi: Úuntan tuke pujurtan wáinmiajai. Winia pujurtakui awajkamu áchattajai. ");
INSERT INTO jivNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tuma asamtai winia enentáirja̱i̱sha Nin shiir enentáimtusmiajai. Tura wenurja̱i̱sha shiir chichaman chichamiajai. Jáaknasha shiir enentáimsan jakattajai, aneantiniapitjia tusan. ");
INSERT INTO jivNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Winia wakaniur, Yusru, jákatniunam ikiurtuschattame. Wi ame Uchirmetjai, Tunaarincha. Túmaitkui anentu asam aya̱shur káurtin tsankatrukchattame. ");
INSERT INTO jivNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tura iwiaaku átin jintia jintintrutamame. Tura tuke pujurtakum waramtikrustatme. Tu áarmiayi Tawit’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pítiur tuke chichaak: ‘Páantchakait. Ii uuntri̱ Tawit yaunchu jákaiti. Tura iwiarsamuiti. Ni iwiarsamuri̱ iini̱ pujatsuk. ");
INSERT INTO jivNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Túrasha Tawitkia Yúsnan etserniuyayi. Tuma asa Yus tímia nuna nekaamiayi. Yus Tawitian chicharuk tímiayi “Ame akupniuitme. Nekas tájame, ukunam ame iniaṉnamurminian Kristu akiiniattawai. Niisha Akupin anainiaktatui, amea áintsaṉ.” Nuna Yus táman Tawit nekaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Neka asa, túruntsa̱i̱ṉ Tawit, wainkia nútiksaṉ, Kristu nantaktintri̱n áarmiayi. Kristu túrunatniuri̱n chicharuk tímiayi “ni wakaní̱ncha jákatniunam ikiukchatniuyi. Aya̱shí̱ncha káurtinian tsaṉkatkashtiniuyi.” ");
INSERT INTO jivNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Au Krístun tímia nu Jesusaiti. Nu Jesusnak Yus iniantkimiayi. Nuka iisha neka asar étsereaji. ");
INSERT INTO jivNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yuska, Jesus naṉkaamantuiti tusa ni untsuuri̱ni̱ apujsaiti. Tura ni Wakaní̱n Jesusan súsaiti, Nii yaunchu tímia nútiksaṉ. Tuma asamtai ju̱sha átum antukurmena nuna, tura íisurmena nunasha Yus suramsaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tawitkia aya̱shtiuk nayaimpiniam wákachmiayi. Tura nú Tawitiak ju̱na áarmiayi: “Uunt Yus winia Úuntrun tímiayi “akupin pujutainium, winia untsuurui̱ni̱ pujustá. ");
INSERT INTO jivNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ame nemasrumin nupetkattajai. Nu túruntsa̱i̱ṉ ju̱i̱ pujustá’ tímiayi.” Nuní áarmaiti Jesusnan, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tura ii, Israer áentsti, Jesus krúsnum maaitji, tímiayi. Jú̱ Jesus máamjinia nuna Yuska Uunt Akupin anaikiamiayi. Túrasha Jesussha in uwemtikkiartin Krístuiti. Ashí áentstíram nu péṉker nekaatarum” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nuna antukar wake mesekarmiayi. Tura Pitruncha chíkich akatramuncha aniasarmiayi “Yatsuru, ¿nuiṉkia itiurkatjik?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tutai Pítrusha chichaak “Atumí tunaari̱ ikiuktiaj tusarum Yus nekas enentáimtustarum. Tura ashí shuartiram Jesukrístu naari̱ pachisrum imiantiarum. Nuiṉkia atumí tunaari̱n Yus tsaṉkurtamprattarme. Túrunawakrumin Yuska ni Wakani̱n suramsattarme, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yus tímia nuka atumin túramprume. Atumí uchirí̱ncha tura ashí arant matsatainia nunasha tawai. Kame ii Yusri̱ áentsun untsuktaj tusa wakerana nuna tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nú chichamja̱i̱ tura nuya̱sha Pítiur tuke jintintiuk tímiayi “Yajauch shuara asutiátniuri̱ átatna nuyá uwempratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tuma asamtai nuna antukarmia nuka imianiarmiayi. Nú tsawantai̱ menaintiú mir (3000) aents Yus-shuar ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ashí nu shuar Jesusa akatramuri̱ jintintiarmia nuna tímiatrusaṉ antukarmiayi. Tura irunar shiir enentáimtunaisar yurumin ármiayi. Túrawar, Kristu enentáimtustin namperi̱n najanin ármiayi. Túrawar Yúsan áujiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tura Yuska aentsti túrachminian Jesusa akatramuri̱ji̱a̱i̱ túramiayi ni kakarmari̱n iniakmastaj tusa. Tuma asamtai ashí aents nuna wáinkiar ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yúsan umirkaruka ashí métekrak pujuarmiayi. Tura ashí niiniu armia nuna sunaisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ni nuṉke̱n surukar, ni takakmari̱ncha surukar, atsumainia nuna súarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tuke tsawantak Yusa Uunt Je̱e̱n káuniarmiayi. Tura ni je̱e̱ncha iruntrar warainiak Kristu enentáimtustin námper najanin ármiayi. Tura naṉkaamantu enentáimtumatsuk, yurumkan ajamnainiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Túrawar, Yuska ti úuntaiti, tu wearmiayi. Tura ashí aents nin shiir enentáimtiarmiayi. Tura Uunt Yus tuke tsawant shuaran uwemtikiar Yus-shuar írunmanum íkiauṉki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Chíkich tsawantai̱, nantu nuṉkaach ajasmatai, Pítiur Juaṉja̱i̱, Yusa Uunt Je̱e̱n Yus áujsatai tusar wearmiayi, Israer-shuar tuke turin armia nútiksaraṉ. ");
INSERT INTO jivNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tura áishmaṉ, ni akiiniamuri̱nia̱ wekaicha amia nu, nui̱ a̱a̱ wáitiniam tuke tsawant pujumiayi. Nu áishmaṉnasha ni shuari̱ entsakí júkiar nú wáitiniam apujin ármiayi, nui̱ shuar waya̱n kuítian seat tusar. Nú wáitisha, Shiir Waiti, tutai̱yayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tura nú shutuapsha Pitrun Juaṉja̱i̱ waya̱n wáinkiamiayi. Wáiniak kuítian seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tura Pítiur Juaṉja̱i̱ apa̱jas íisarmiayi. Tura nú áishmaṉnasha chicharuk “Iirsata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aishmaṉsha, surustatuapi, tu enentáimias, íimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nuyá Pítiur chichaak “Kuítrusha atsawai, tímiayi. Kurisha atsawai. Antsu kuítja̱i̱ naṉkaamas takakjana nuna amastajai. Wats, Nasarétnumia̱ Jesukrístu kakarmari̱ji̱a̱i̱ wajakim wekasata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tinia iniais, Pítiur ni untsuuri̱ni̱ achik awajkimiayi. Túram ni nawe̱sha, wanuse̱sha kakaram ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tura niisha wajaki nantent ajakmiayi. Nuya̱sha wekasamiayi. Tura Pítruja̱i̱sha Juáṉja̱i̱sha Yusa Uunt Je̱e̱n waya̱warmiayi. Nuik shutuapka wayá nantent nantent ajak Yusa náari̱n shiir pachimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ashí aents pujuarmia nu, nin wekaan wáinkiarmiayi. Tura ni chichame̱n anturkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tura chichainiak “Nuik Yusa Uunt Je̱e̱n wáitiri̱n, Shiir Waiti tutainium, nu áishmaṉ tuke pujuuya núchakait” tiarmiayi. Tura ni túrunamuri̱n nekaawar, ti ashamkar nusháa enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Shutuapka péṉker ajasu asa Pítruja̱i̱ Juáṉja̱i̱sha peṉké tsurachmiayi. Tura aents nui̱ pujuarmia nu, warinkit tusar, je̱áshkiri̱ tsékeṉki wearmiayi. Nuka Sarumúṉna tiniu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aents káunkarun Pítiur wáiniak, chicharuk “Israer-shuartiram, ¿urukamtai winiasha imiá íirum? tiarmiayi. ¿Iisha péṉker asarikⁱ tsuarmajⁱ? ¿Ii kakarmari̱ji̱a̱i̱ṉkikⁱ ewekamsamajⁱ? ");
INSERT INTO jivNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Atsá. Antsu Yuska ni Uchiri̱n Jesusan ashí naṉkaamantu awajsaiti. Ii uuntri̱ Apraamsha, Isaksha tura Jakupsha enentáimtin armia nú Yusan tajai. Átumka Jesus nakitrarum kapitián Piratuí surukmarme. Tura Piratu akupkataj tau atumsha suritkiamarme. ");
INSERT INTO jivNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesus péṉker nákak enentáimniuyana nu “akupnakchati” tímiarme. Antsu shuáran main akupnakat tusarum wakerimiarme. ");
INSERT INTO jivNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Túrarum iwiaaku átinian Amaana nu maamarme. Tuma aiṉ Yuska Nin jakamunmaya̱ iniantkimiayi. Nuka iisha neka asar étsereaji. ");
INSERT INTO jivNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tura ju̱ aishmaṉ jui̱ wajaana ju̱ tura nékarmena ju̱, Yusa Uchiri̱ naari̱ enentáimta asa kakaram ajasuiti. Jesus enentáimtusu asa nekas péṉker ajasuiti. Nusha wáinniu asarum nékarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Wats, yatsurtiram, wi nékajai. Atumsha atumí úuntri̱ji̱a̱i̱ Jesusan túramarmena nu nékatsuk túramarme. ");
INSERT INTO jivNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tura nu túramurmi̱ji̱a̱i̱ Yus yaunchu tímia nu tímianak umikiurme. Ni Krísturi̱ wáitsatniuya nuna Yuska ashí ni etserniuri̱n áamtikramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Wats, yamaikia tunaaruminia̱ kanaktiarum. Túrarum Yúsnumaani̱ ayantártarum, tunaarun asakárat tusarum. Túrunawakrumniṉkia, atumin uwemtikramprarat tusa Yus yaunchu anaikiamia nuna akupturmaktatrume. Nusha Jesukristuiti. Tura Niiji̱a̱i̱ enentáimin ayampratin átatui. ");
INSERT INTO jivNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tura yamaikia Jesukrístu nayaimpiniam pujustiniaiti, ashí iwiarnatsa̱i̱ṉ. Yuska ukunam ataksha nuṉkan shiir awajsattawai. Nuna ni etserniuri̱n tsáapin enentái takaku armia nuna yaunchu áamtikramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tuma asa Muisais ii apari̱n tímiayi: “Atumi Uunt Yusri̱ ukunam etserniun akupturmaktatrume, winia akuptukmia núnisaṉ. Nuámtaktirminia̱ achik akupturmaktatrume. Tura nii títiatna nu umirkatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Náṉkamas aents nu etserniun chichame̱n umíachkuṉka emesnartatui. Tura Israer-shuarnum páchitkia áchattawai. Núnisaṉ áarmiayi Muisaissha’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pítiur tuke chichaak ‘Iimiata, Yúsnan etserin Samuer ju̱ tsawantin túratniuri̱ etserkamiayi. Nuyá ashí Yúsnan etserniusha tuke nuna etseriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Etseriarmia nuka atumin túramprume. Tuma asa átum péṉker pujustinian Yuska ii uuntri̱ Apraáman ju̱ chichaman susamiayi. “Nekas tájame, ame shuarum akiiniattana nuja̱i̱ ashí áentsnasha shiir awajsattajai’ tímiayi. Tura ii úuntri̱n tímia núnaka incha túramji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iimiata, Yus ni Uchirí̱n iniantkimia nui̱, atumin emka akupturmakmiarme. Atumsha, atumí tunaari̱ya̱ kanaktiarum tusa, tura atumin shiir awajtamsatniun wakerak túramiayi.” Nunak tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pítrusha Juaṉja̱i̱ Yusa chichame̱n áentsun jintintiainiak pujuarmiayi. Jesus nantakin asamtai aencha nantaktin áiniawai, tiarmiayi. Tura chichaak pujuiniai̱ Israer-patri táarmiayi. Tura Yusa Uunt Je̱e̱n wainniu úuntri̱sha Satuséu aentcha táarmiayi. Taar Pitruncha Juáṉnasha kajerkarmiayi, niisha Jesusa nantakmiari̱ chichaman jintintinia asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yamaikia kí̱awai, kashin iismí tusar achik sepunam eṉkea iniaisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tura Pitrun nuik anturkarmia nú aents untsurí̱ Yus-shuar ajasarmiayi. Nuik Yus-shuaraim tura yamaiyaim iruram ti untsurí̱ ajasarmiayi. Aya áishmaṉkak, seṉku mir (5000) aents ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kashin tsawa̱rmatai Israer-shuara akupniuri̱, ni úuntri̱sha, tura ni jintinniuri̱sha Jerusaréṉnum iruntrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nui̱sha Anassha, Israer-patri uuntri̱ anaikiamu amia nu, tura Kaipiassha, Juaṉsha, Arejantrusha, tura Israer-patri kapitiántri̱ shuari̱sha tímian iruntrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Iruntrar Pitruncha Juáṉnasha utitiarum tusar akupkarmiayi. Tura itiarmatai, ajapén awajsarmiayi. Tura aniasarmiayi “Kame ¿yana kakarmari̱ji̱a̱i̱, yana chichame̱ja̱i̱ túrarum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tutai nuyá Pítiur, ni enentáin Yusa Wakaní̱ pimiutkamu asa tímiayi “Akupniutiram, tura úuntirmesha antuktarum. ");
INSERT INTO jivNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ju̱ áishmaṉ nuik shutuap amia nu péṉker ajasmari̱ anintrarme. Kame itiurak péṉker ajasuit tátsurmek. ");
INSERT INTO jivNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Urukamtia ú̱u̱ktataj. Anintrakrumin iisha paant títiatji, Israernumia̱ shuar ashí nekaawarat tusar. Ju̱ áishmaṉ Jesukrístu kakarmari̱ji̱a̱i̱ péṉker ajasuiti. Nasarétnumia̱ Jesukrístun, átum máamurmena nuna, tura Yus jakamunmaya̱ iniantkimiania nuna tajai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nú Jesuska kayaa áintsaṉkete. Atumsha jeamniutiram, nú kaya yajauchiiti, tímiarme Jesusna. Túrasha túramaitiataṉ Niisha je̱a̱nam emka apujsamua núnisaṉ ajasuiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tura chíkichja̱i̱ uwempratin peṉké atsawai. Ju̱ nuṉkanam ii chikicha naari̱ pachisar uwempratin atsaji. Jesuskete ii uwemtikrampratniun Yus suramsamiaj nu” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pítrusha Juaṉsha náṉkamas shuara áintsaṉ ármiayi. Núkap unuimiarcharu ármiayi. Tura unuimiarchaitiat, arantutsuk etseriarmiayi. Aentsu uuntri̱ núnaka nekaawar “Nékachuitiat, itiura sapijmiatskesha chichainia” tiarmiayi. Tura, ju̱sha Jesusa nemarin ármia núiti tiar nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nuya̱sha áishmaṉ péṉker ajasmia nu niiji̱a̱i̱ nui̱ wajamiayi. Tuma asamtai, niisha a̱i̱ wajakui, Israer-shuara úuntri̱ṉkia, péṉker ajaschaiti títiai tukamá tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tuma ásar, iik nuamtak áujmatsatai tusar, Pítrusha Juaṉsha shutuapsha a̱a̱ awemartai, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tura áujmatainiak tiarmiayi “Ju̱ Pítrusha ju̱ Juaṉsha itiurkatjik. Ju̱ uunt túrunamun Jerusaréṉnum matsatainia nu ashí nékainiatsuk. Wáitiaiti titin tujintiaji, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tura, ashí aents nekaawara̱i̱ṉ tusar yamaik jiaktai. “Ju̱ Jesusa naari̱ pachisrum peṉké jintintiawarairap,” titiai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tura árusaṉ Pitruncha Juáṉnasha shutuapnasha ataksha untsukarmiayi. Tura chicharkarmiayi. “Jesusa naari̱ peṉké áujmatsairap. Tura Jesusa túramuri̱ peṉké jintintiairap” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tutai Pítiur Juaṉja̱i̱ áimkiarmiayi “Enentáimpratarum. ¿Yus warinia wakera? ¿Iikia Yus umirtsuk atumí chichame̱ṉ umirkatniukaitiajⁱ? tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nekaatarum. Iisha íisjinia nu, tura antukjinia nusha ii etsertsuk pujustin tujintiaji.” Tu áimkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Shutuáp péṉker ajasmia nu kuarenta (40) uwí naṉkaamas takakuyayi. Ni péṉker ajasmari̱n aents nekaawar, “ju̱ka aentsti túrachminiaitji” tusar Yusa naari̱n uunt awajsarmiayi. Tuma asamtai aentsu uuntri̱ Pitruncha, Juaṉnasha asutiátai tukamá aentsun ashamainiak áyatik chicharkar iniaisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pítiur Juaṉja̱i̱ aṉkant ajasar ni írutramuri̱i̱n waketkiarmiayi. Tura jeawar Israer-patri uuntri̱ tura aentsu úuntri̱sha nin tiarmia nuna mash etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nu ujakam antukar métekrak Yúsan áujuk tiarmiayi “Winia Uunt Yusru, Amesha nayaimpisha nuṉkasha najanaitme. Nayaantsasha tura ju̱i̱ írunna nusha najanamiame, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tura Tawit ámin umirtamin amia nu ju̱ áamtikramiame: “¿Urukamtai ashí nuṉkanmaya̱ aents charaatum ajainia? ¿Tura Israer-shuarsha urukamtai ántar chichaman enentáimiainia? ");
INSERT INTO jivNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uunt kapitián ármia nuka chichaman jurusarmiayi Uunt Yúsan. Tura pepru úuntri̱sha iruntrar Uunt Yúsan kajerkarmiayi. Ni anaikiamuri̱n Krístun nútiksaṉ kajerkarmiayi.” ");
INSERT INTO jivNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tu áarmaiti, Uunta, tura nekasaiti. Erutis apachi kapitiántri̱ Punsiu Piratuja̱i̱ jú̱ péprunam iruntrarmiayi. Niisha yajaya̱ shuarja̱i̱ tura Israernumia̱ shuaraim nuim iruntrarmiayi. Ame Uchirmin Jesusan tunaarinchan kajerkarmiayi. Jesuska Ame anaikiamiame, winia takatrun túrat tusam. ");
INSERT INTO jivNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tura ame enentáimja̱i̱ iwiaramamna nu uminkiatniuiti. Tura apachcha Jesusan kajerainia ásar, Ame iwiaramamna tímianak umikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Uunta, iisia kajertamainiaj nu. Jes, Áminiu asakrin áujmatramtsujik. Túmaitkuisha ame chichame̱m ii ashamtsuk etserkatin ame kakarmaram amasta. ");
INSERT INTO jivNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tura ame kakarmarmiji̱a̱i̱ jaasha tsuártin amasta. Ame Uchiram Jesus tunaarincha nuja̱i̱ ii aentsti túrachmin túratniusha amasta. Aents Yusa kakarmari̱n nekaawarat tusam túrata” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tura Yúsan tú áujas umikmatai nuiṉ irunar pujuiniai̱ṉ ú̱u̱rkamiayi. Túrunamtai ashí shuara enentái̱n Yusa Wakaní̱ pimiutkarmiayi. Túmaitkiui ashamtsuk Yusa chichame̱n etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yus-shuar ajasarmia nu, ti untsuritiat, ashí chikichík enentainiak enentáimainiak, ni takaku armia nuna, aya wíniakete tútsuk, ju̱sha ashí iiniu ainiawai, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tura Jesusa akatramuri̱sha, Yus ti yayamu ásar, Yusa kakarmari̱ji̱a̱i̱ Uunt Jesusa nantakmiari̱n tuke etseras pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tura ashí Yus-shuarka nuṉkan takakusha je̱a̱n takaku armia nusha, núnaka surukar kuítian itiariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tura itiaar Jesusa akatramuri̱n súarmiayi. Akatramusha susam, niisha atsumainia nuna súarmiayi. Tuma asamtai shuar atsumaka peṉké atsuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chikichík shuar, ni naari̱ Jusé, nuṉkan takakuyayi. Jesusa akatramuri̱sha Jusen chíkich náari̱n apujtusarmiayi, Pirnapín. Nu náari̱sha, shiir enentáimtikkiartin tawai. Tura Pirnapísha Riwí áentsuyayi. Tura ni akiiniamuri̱ núṉkenka Chípriiyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Niisha ni nuṉke̱n surukmiayi. Tura nu kuítian itiá Jesusa akatramuri̱n súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tura chíkich áishmaṉ, ni naari̱ Ananías, ni nuwe̱ Sapirja̱i̱ ni nuṉke̱n surukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Niisha nuṉkan suruk kuítian emeenak akanak jukí Jesusa akatramuri̱n werí takamtsukea nútikias susamiayi. Ni nuwe̱sha, Sapir, nuna túran nekaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Túramtai Pítiur chichaak “Ananíasa, ¿urukamtai uunt iwianch enentáimin eṉkemturmatai, Yusa Wakaní̱n anaṉkataj tusam nuṉka surukam kuit achikiumna nu akankam ikiurmasam? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Entá, nuiṉkia nuṉka áminiuchukait. Surukumna nu kuitcha áminiuchukait. Nusha, ¿urukataj tusamea tu enentaímpram? Amesha aya áentsnum wáitruachume. Antsu Yusnumsha wáitruame” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tutai Ananías nuna antuk nú chichamaik jakamiayi. Tura ashí shuar nuna antuk nekaawar ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nú turunamtai áishmaṉ tariar Ananías jakan penuararmiayi. Túrawar iwiarsatai tusar júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tura Ananíasa nuwe̱ arur, menaintiú ura naṉkaamasa̱i̱ támiayi. Túrasha ni áishri̱ jakanka nekaachmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Támatai Pítiur nuwa̱n tímiayi “Turuttia. Átum nuṉka surukurmena nui̱, ¿kuit itiarumna núnikik surukuram?” tímiayi. Tutai nuwa̱ tímiayi “Ee, núnik surukji.” ");
INSERT INTO jivNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tutai Pítiur tímiayi “¿Urukamtai atumsha Uunt Yusa Wakaní̱ nekapkamsatai tusarum imiá enentáimprarum? Pai, iisiá. Ame áishrumin iwiarsatai tusar júkiaria nu wininiawai. Tura yamaikia amincha juramkiartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tutai nu chichamaik niisha imia Pitru wajamunam jaka iniaantmiayi. Aishmaṉ waya̱j tukamá jaka tepan wáinkiarmiayi. Túramtai júkiar ni áishri̱niṉ aya̱mach iwiarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tura ashí Yus-shuar armia nu tura ashí aencha nuna antukarmia nu ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Tura ashí Yus-shuar Yusa Uunt Je̱e̱n shikiri̱i̱n irunin ármiayi. Nu shikiri̱sha, Sarumúṉna, tu anaikiamuiti. Tura chíkichmamtinkia nuim iruntratniun ashamiarmiayi. Túmainiayataṉ, ti péṉker áiniawai, tu wearmiayi. Tura Yus-shuar Yusa kakarmari̱n iniakmasarmiayi. Túra asamtai imiá untsurí̱ aents Yus-shuar ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tura chíkich aents ni shuari̱ jainia nuna jintiá amamtikiarmiayi. Peakja̱i̱ júkiar, tampunmasha eṉkeawar júkiar jintiá aya̱mach áepsarmiayi. Pítiur naṉkaamak ni wakaní̱ṉsha eṉkemprutmawainti tusar nu shuar túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Núnisaṉ arantia̱ shuarsha ti untsurí̱ ni shuari̱ jáinian tura iwianchrukuncha nui̱ Jerusaréṉnum itiarmiayi. Tura ashí nui̱ táaruka tsuámararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Israer-patri uuntri̱, tura Satuséu aencha niiji̱a̱i̱ pujuarmia nu suiir iiniak ");
INSERT INTO jivNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jesusa akatramuri̱n achikiar eṉkeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Túrasha kashi Uunt Yusa suntari̱ nayaimpinmaya̱ tara sepú wáitiri̱n uraimiayi. Tura Jesusa akatramuri̱n a̱a̱ jí̱i̱kiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Tura tímiayi “Wetarum. Tura Yusa Uunt Je̱e̱n wajasrum Yusja̱i̱ tuke iwiaaku átinia nu etserkatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nuna antukar kashin tsawar káshik Yusa Uunt Je̱e̱n waya̱war jintintiawarmiayi. Nu túmainia̱i̱ Israer-patri uuntri̱, tura niiji̱a̱i̱ pujuarmia nusha iruntrarmiayi. Tura Israer-shuara uuntri̱, naamka armia nuna iruntrami tusa untsukarmiayi. Ashí iruntrar akatar akupkarmiayi, Jesusa akatramuri̱ sepunmaya̱ itiatarum tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tura suntarsha sepunam jeariar Jesusa akatramuri̱n wáinkiacharmiayi. Atsawai tukam táarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Taar chichainiak “Sepú waiti asakamua tímianisaṉ aa wáinkiaji, tiarmiayi. Tura suntar wáitin iimpru wajainia wáinkiaji. Tura waiti urair waya̱jⁱ tukamar atsá wáinkiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Israer-patri uuntri̱, tura Yusa Uunt Je̱e̱n wainniu úuntri̱sha, nu chichaman antukar, “tsej ausha ¿urutiak nunasha iniaisarat?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nu chichamaik áishmaṉ taa tímiayi “Aishmaṉ átum sepunam eṉkeamarmena nu, Yusa Uunt Je̱e̱n wajasar áentsun jintintiuk pujuiniawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Túrunamtai Yusa Uunt Je̱e̱n wainniu uuntri̱ ni suntari̱ji̱a̱i̱ wear achik itiarmiayi. Túrasha peṉké aents kayaja̱i̱ tukurmara̱i̱j tusar, yajauch awajtsuk itiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tura achik itiaar Israer-shuar naamka pujamunam naka awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tura Israer-patri uuntri̱ tímiayi “Iisha atumin chicháa chicharu awajsar, Jesusa naari̱ pachisrum etserkairap tusar akupkachmakajrum. Túrasha, ¿antukurmek? Atsá. Mash Jerusaréṉnum átum etserkamu pampaṉkai. Jes, átum, Jesusan máawarai, in tátsurmek. Nusha in makuutai tusarum tárume” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nuyá tutai Pítiur chíkich Jesusa akatramuri̱ji̱a̱i̱ chichainiak “Iikia aentsja̱i̱nkia iniaṉkasar Yus emka umirkatniuitji, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesus atumek krúsnum máamurmena nuna ii iwiaaku Yusri̱ Nin iniantkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yus ni kakarmari̱ji̱a̱i̱ Nin naṉkaamantu awajsamiayi. Tura nekas Akupniuiti tusa ni untsuuri̱ni̱ apujsamiayi. Tura áentsun Uwemtikniuiti. Israer-shuar enentái yapaji̱áwar tunaari̱nia̱ uwemprarat tusa Yus túraiti. ");
INSERT INTO jivNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nu tuma asamtai iisha nu nekaar étsereaji. Tura Yusa Wakaní̱sha nuna étsereawai. Túrasha aya Yusa umirkarua nunak ni Wakaní̱n súsaruiti” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tutai nuna antukar ti kajerkarmiayi. Túrawar, maatai tusar wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tura nui̱ Israer-shuara uuntri̱ pujumiayi, ni naari̱ Kamarír. Niisha Pariséunam páchitkiauyayi. Tura akupeamun jintinniuri̱yayi. Túmakui ashí aents nin shiir enentáimtin ármiayi. Tura niisha wajaki tímiayi “Ju̱ áishmaṉ a̱a̱ ishichik wajasarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nuyásha irunar matsamarmia nuna chicharuk “Israer shuartiram, ju̱ áishmaṉ tú túratai tu enentáimsarumna nu aneartarum. ");
INSERT INTO jivNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Enentáimsatarum. Nuik áishmaṉ Tiútas wantinkiachmakia. Niisha kapitiániitjai takui, kuatru siáṉtu (400) shuar nemarkarmiayi. Tura ukunam nin maawarmatai, ni némarkamuri̱sha pisararmiayi. Túrunawar nuní amuukamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ukunmasha, iruntrar nekapmartin tsawantincha Kariréanmaya̱ Jútas wantinkiachmaka. Tura nincha nútiksaṉ ti untsurí̱ nemarkarmiayi. Túman máawarmiayi. Nu túrunamtai nútiksaṉ ni némarkamuri̱sha pisararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jes, tuma asamtai nu áishmaṉ a̱a̱ wajainia nu iniaisatarum. Auka pachisairap. Au tumainia nu aya áentsnaketkuiṉkia amuukattawai. ");
INSERT INTO jivNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tura antsu Yúsnaitkuiṉkia atumsha amuktai tukamarum tujinkiattarme. Aneartarum. Iniaiyachkurmeka nu tumá pujusrum Yusja̱i̱ máanikchattarmeash” tímiayi Kamarír. ");
INSERT INTO jivNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tú tutai tímianak umikiarmiayi. Túrasha Jesusa akatramuri̱n untsukar asutiáwarmiayi. Tura chicharuk “Jesusa naari̱ pachisrum peṉké ishichkisha etserkairap” tiarmiayi. Tú tiar akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesusa akatramuri̱sha Israer-shuara uuntri̱ pujamunmaya̱ jíinkiarmiayi. Tura wáitsamniaitrume tusa Yuska Jesusa naari̱ pachia asakrin ii natsantin wáitsatniun tsaṉkatramkaitji tusar ti shiir enentáimsar wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tura Jesukrístunun áujmatsatniun peṉké iniaisacharmiayi. Antsu tuke tsawant Yusa Uunt Je̱e̱ncha tura chíkich je̱a̱nmasha páchitsuk etseriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nú tsawantin Yusan umirkaru ti kaweṉkar ármiayi. Tura tuke tsawant yurumak súsatin ámiayi. Túmakui Yus-shuar Kriaku chichaman chicharmia nu, Israer-shuaran kajeriarmiayi. “Tuke tsawantin yurumak súarmena nui̱ atumí waje̱ ti nukap súarme. Tura íiniuka ishichik súarme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Túruinia Jesusa tuse akatramuri̱ ashí Yus-shuaran irurar tiarmiayi “Iisha Yus-Chicham etserkatin iniaisar yurumak súsachminiaitji. ");
INSERT INTO jivNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tuma asamtai yatsurtiram, atumí̱i̱nia̱ siati áishmaṉ e̱áktárum yurumkan súsarat tusarum. Péṉker wekainia nu, tura neka shuar, Yusa Wakaní̱ pimiutkamu ainia nu achiktarum. ");
INSERT INTO jivNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iikia antsu Yus áujkir unuiniakratkir Yusa chichame̱ etserkir wétatji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Akatramu tiarmia nuna ashí aents enentáimsar pujuarmiayi. Túmainiak Estepaṉkan anaikiarmiayi. Estepaṉsha Yúsan tuke enentáimtiniuyayi. Tura Yusa Wakaní̱sha pimiutkamuyayi. Chíkich áishmaṉkan anaikiarmiayi, niisha Jiripi, tura nuyá Purukuru, Nikianúrsha, nuyá Temuṉ, Parmenassha, Nikiurássha. Nikiurássha Antiukía nuṉkanmaya̱itiat Israernancha ashí umirniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tura nu siati áishmaṉkan Jesusa akatramuri̱n itiariarmiayi. Táarmatai, akatramusha, Yus áujtusar, anaikiaji tusar múuknumsha ni uweje̱n awantsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Túrasha Yusa chichame̱nka tuke pampaṉki̱ wémiayi. Nui̱ Jerusaréṉnumsha Yus-shuar ti kaweṉkarmiayi. Tura imia Israer-patrisha untsurí̱ Yus-Chichaman umiriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estepaṉsha Yusa waitnenkartutairi̱ pimiutkamuyayi. Tura Yusa kakarmari̱sha pimiutkamuyayi. Tuma asa aentsti túrachminian shuar írunmanum túramiayi. Nu shuar Yusa kakarmari̱n nekaawarat tusa túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Israer-shuar iruntai je̱a̱, ni naari̱ Aṉkantin, ámiayi. Nuyá áishmaṉsha tura Serini nuṉkanmaya̱ áishmaṉsha, tura chíkich nuṉka Arijiantri̱anmaya̱sha, Serisianmaya̱sha, Ásianmaya̱sha, tímian Estepaṉja̱i̱ áujmatsatai tusar káutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Estepaṉ Yusa Wakaní̱ nekatairi̱ji̱a̱i̱ tímianak chicháa asamtai, nu áishmaṉ Estepaṉja̱i̱ iṉkiunaikiar nupetkataj tukamá tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tuma asamtai suiir enentáimtuiniak chíkich áentsun Estepaṉkan tsanumprurarat tusar e̱ákarmiayi. Estepaṉ Muisaisnasha Yúsnasha yajauch áujmatui, titiarum tusar akikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Peṉké áentsun, tura uunt ainia nunasha, jintintin ármia nuja̱i̱sha chichaman júsar yajauch enentáimtikrarmiayi. Tura Estepaṉkan jintiá akirtuawar achikiarmiayi. Túrawar Israer-shuar naamka matsamarmia nui̱ júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tura wait chichamtinian itiarmiayi. Niisha taar chicharainiak “Yusa Uunt Je̱e̱n ti péṉker ana nu, tura Yusa akupkamuri̱ncha ju̱ Estepaṉ tuke yajauch chicharui, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nú arantcha ju̱ Estepaṉ tímia nu antukji, tiarmiayi. Estepaṉ chichaak “Nasarétnumia̱ Jesuska Yusa Uunt Je̱e̱n sáa̱ktiatui, tura nuyá Muisais in ikiurtamkimiaj nunasha yapaji̱áttawai” tímiayi. Nusha Estepaṉ tímia nu antukji” tiarmiayi. Tura nunasha peṉké ántar tsanumprurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nuya̱sha ashí Israer-shuar naamka iruntramunam pujuarmia nu Estepaṉkan iiyaj tukamá ni yapin nayaimpinmaya̱ suntara yapiya nuní íiran wáinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tuma wáiniak Israer-patri uuntri̱ Estepaṉkan aniasmiayi “¿Ju̱ tuinia nu nekaskait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tutai niisha áimkiamiayi “Winia úuntrutirmesha, yatsurtirmesha anturtuktarum. Ii Waantu Yusri̱ ii úuntrí̱n Apraáman wantintiukmiayi. Apraámka Misiuputámia-Kartea nuṉkanam puja̱i̱, Aran nuṉkanam wéatsa̱i̱ṉ, nui̱ wantintiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tura wantintiuk tímiayi “Ame nuṉkemsha áminiurmesha ikiukim nuṉka Wi iniaktustatjamena nui̱ wetá” tímiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tutai Apraám Misiuputámia-Kartea nuṉkan ikiuki Aran nuṉkanam pujustaj tusa wémiayi. Nuyá ni aparí̱ jakamtai “Arant wetá” tímiayi Yus. Nuna taku ju̱ nuṉkan ii pujajnia ju̱i pujsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Túrayat nuṉkan ishichkisha súsachmiayi ju̱ nuṉkanam. Antsu “Ukunam amastatjai. Ame jakakmin ame uchirmin susattajai” tímiayi. Tura Apraama uchirí̱ peṉké atsan nuní tímiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nuya̱sha Yus tímiayi “Ame uchirmesha írara núnisaraṉ chíkich nuṉkanam pujusartatui. Nui̱sha emetamu itit awajtai pujuartatui. Kuatru siáṉtu (400) uwí, tímianu uwí wáitsartatui, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Túrasha, Wi asutiáttajai ame shuárumin wáitkia núnaka, tímiayi. Túram nuyá nú nuṉkanmaya̱ shiákartatui. Tura Winia enentáimtursartatui jú̱ nuṉkanam’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yus tuke Apraámnasha chicharuk ‘Yamaikia Wíi-shuar asarum tsupirnaktiniaitrume. Tuma asam amesha uchiram áishmaṉkach akiiniamtai, Wi tímiajna núnismek, sirkunsisiúṉ tutai, shunichiri̱ nuape̱ tsupirkata, tímiayi. Tura chícham Wi yamaikia ámiji̱a̱i̱ najanaj nu nekas uminkatniuiti tusam nusha túrata” tímiayi Yus. Tuma asamtai ni uchirí̱ Isak akiiniamtai, uchu tsawant naṉkaamasmatai, Apraám nin tsupirkamiayi. Tura Isaksha ukunam ni tuse (12) uchiri̱n ii uuntri̱ armia nunasha nútiksaṉ túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Tura niisha ni yachi̱n Jusen suiir íiyarmiayi. Túmainiak Ejiptu nuṉkanam júkiarat tusar surukarmiayi. Túrasha Yus némarkauyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tuma asa, ashí ni itiurchatri̱i̱nia̱ uwemtikramiayi. Tura waitnenkartutairi̱ncha nekatairi̱ncha susamiayi. Tuma asamtai Ejiptunam uunt akupin Paraún Ejiptu nuṉkaa akupniuri̱ ajasat tura ni je̱e̱n wáinniuri̱ ajasat tusa anaikiamiayi.” ");
INSERT INTO jivNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Tímiatam tsuka tura itiurchatcha ámiayi Ejiptu núṉkanam. Tura ju̱i̱ Kanaaṉ nuṉkanmasha núnisaṉ ámiayi. Tuma asamtai ii uuntri̱ yurumkan peṉké wáincharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tura Jakup, Ejiptunam yurumak ikiusma awai taman antuk ni uchirí̱n akupkarmiayi. Túrasha wekaicha wearmiayi. Wats, ii úuntri̱niun ujaajrume. ");
INSERT INTO jivNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tura ii uuntri̱ atak Ejiptunam wéenak Jusesha, wíitjai takui ni yachi̱ Jusen nekaawarmiayi. Tura Jusé “Yatsur áiniawai” takui Parauṉ, antuk “au shuarapitia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nuya̱ṉka Jusé ni yachi̱n chicharuk “Apar itiatarum uchirtuk” tímiayi. Nu shuarsha untsurí̱, setenta seṉku (75) matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nuní tutai Jakupsha ni shuari̱ji̱a̱i̱ Ejiptunam pujustai tusar wearmiayi. Tura ukunam nú nuṉkanmaṉ jakamiayi. Tura ni uchiri̱sha ii uuntri̱ ainia nu, núnisaraṉ nú nuṉkanmaṉ jákarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tura atak ukunam ni shuari̱ Sikiam nuṉkanam ni ukunchi̱n júkiar iwiarsarmiayi. Kame Sikiam nuṉkanam Apraámka yaunchu játsuk Amura uchirí̱ nuṉke̱n sumakmiayi. Túramtai nui̱ iwiarsarmiayi’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Yus, Apraáman chicharuk “Nekas wi susattajme” tímiania nú tsawant jeatemamtai, Ejiptu nuṉkanam Israer-aents pampaṉki ti kaweṉkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nu tsawantincha Ejiptunam chíkich akupin naamka ámiayi, tura Jusen nekaachmiayi nii. ");
INSERT INTO jivNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nu akupin ii yaunchu úuntri̱n anaṉkawar yajauch awajiarmiayi. “Atumí uchirí̱ kuírchich ana nu ajapa ikiuktiarum” tu wémiayi. Pampaṉkara̱i̱ṉ tusa tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tiri iniaisamunam Muisais akiiniamiayi. Muisaisnaka Yus shiir enentáimtimiai. Tura ni nukurí̱ menaintiu nantu takusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tura nuyá ajapa ikiuktin jeamtai entsá apujsamiayi. Uunt Parauṉka nawantri̱ Muisaisan wainiak jukimiayi. Achik, ni uchiri̱nia tímiatrusaṉ jukí tsakatmarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tuma asa Muisais unuimiátrauyayi ashí Ejiptu aents nékarmia nuna. Túramuri̱sha chichame̱sha kakarmauyayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Estepaṉ tuke étseruk juna tímiayi: ‘Nuyá Muisais kuarenta (40) uwí takaku asa Israer áentsun iyutaj tusa wakerimiayi, ni shuari̱ asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nuyá we Ejiptunmaya̱ áishmaṉ ni shuari̱n máatasa pujurun wáinkiamiayi. Tura Muisais ni shuari̱n ayamprak Ejiptunmaya̱ áishmaṉkan máamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wíi turamuja̱i̱ Yuska Israer-aentsun uwemtikrattawai, tu nekaamiayi Muisais, Yus timia asamtai. Tura Israer-aencha áintsaraṉ nékainiawai tu enentáimsamiayi. Túrasha niṉkia nekaacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kashin tsawa̱r Muisais ni shuari̱ jímiar maani pujuinian wáinkiamiayi. Tura nawamnaikiarat tusa “¿Urukamtai nuamtak yatsumja̱i̱sha yajauch awajniarum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tutai emka naṉkaama nu Muisaisan kárut shitiá “¿Ya amincha ii akuptamin tura ii chichartamin anaitiamkamam? ");
INSERT INTO jivNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Winiasha maantuátaj tusam wakeramek, ya̱u̱ Ejiptunmaya̱ áishmaṉ máamamna nútiksamkea?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nuna antuk Muisaiska Matiaṉ nuṉkanam pisar, nú nuṉkanam kuarenta (40) uwí yajaya̱ áintsaṉ pujumiayi. Nú nuṉkanam pujus, nuatak, jimiará uchin yajutmarmiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Kuarenta uwí naṉkaamas, nu atsamu nuṉkanam Senai náinnium tíji̱u̱ch Yusa suntari̱ nayaimpinmaya̱ taa Muisaisan wantintiukmiayi. Numi uchich ukat-ukatin keamunam wantinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muisais, nuna kean wainiak ashamkamiayi. Tura weantuk iistaj tukamá Uunt Yusa chichame̱n antukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Yus tímiayi “Wiitjai Yus. Ame úuntrumi̱ Apraáma Isaka, Jakupa Yúsri̱ntjai” tímiayi. Tutai antuk Muisaiska ti kuraimiayi sapijin. Tura íistinian tujinmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nuyá Uunt Yus tímiayi “Úuntrun shiir awajsataj tusam, ame sapatrum ukuiṉkiam ikiuktia, wajamna nui̱ Wi pujakui. ");
INSERT INTO jivNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nuyá nekaata, tímiayi. Wíi-aents Ejiptunam wáitias pujuinia nuna wáinkiajai. Tura úutainia nunasha antukjai. Tuma asamtai uwemtikrataj tusan tarajai. Wats, akupkatjame ámin. Ejiptunam waketkitia” Yus tímiayi Muisaisan.’ ");
INSERT INTO jivNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Estepaṉ tuke étseruk: ‘Ju̱ Muisaisan ni shuari̱ “¿Ya amincha ii akuptamin tura ii chichartamin átinniasha anaitiamkamam?” tiarmia nuna Yuska akupniun anaik uwemtikrarat tusa awaiṉki akupkamiayi. Numiniam ni suntari̱ wantintiukmia nuna chichame̱ja̱i̱ Yuska Muisaisan akupkamiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Muisaisaiti Israer-aentsun Ejiptunmaya̱n uwemtikramia nu. Yusa kakarmari̱n nekaawarat tusa, aentsti túrachminian untsurí̱n túramiayi Ejiptu nuṉkanam. Nuyá Kapa̱a̱ntin Nayaantsanmasha, tura nuyá kuarenta (40) uwitin atsamunam pujuiniai̱sha ti kakarman iniaktusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jú̱ Muisaisak Israer-shuaran chicharuk “Atumí̱i̱nia̱nak etserniun Yus ukunam anaikiattawai, winia anaitiukma áintsaṉ. Tuma asamtai nu shuarsha umirkamniuram” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jú̱ Muisais Israer-aentsja̱i̱ atsamunam pujumiayi. Senái nainnium Yusa suntari̱ níiji̱a̱i̱sha pujumiayi. Tura Muisaiska ii úuntri̱ji̱a̱i̱ pujumiayi. Níiyaiti iwiaaku pujustin chichaman sunasmia nu. In ujatmaktinian sunasmiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Túrasha ii yaunchu uuntri̱ Muisaisan umirkatniun nakitiarmiayi. Áaniuk imiá umirtaint tusar Ejiptunam waketkitniun wakeriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Túmainiak Muisais Yusja̱i̱ chichastajtsa murá wématai nu shuar Muisaisa yachi̱n Aruṉkan tiarmiayi “Ii yusri̱ najanatá, ii nemarsatin. Áaniusha Muisaissha Ejiptunmaya̱ in juramkiyatcha tútsuk weruma” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nuyá wáakachia áaniun najanawarmiayi. Túrawar, jú̱iti ii yusri̱ tusar, kuntinian maantuawarmiayi, nu susatai tusar. Tura ni uweje̱ja̱i̱ najanamun íisar ti wararsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nuna túruinian wáiniak Yus, iniaisajai taku, niiya̱ kanakmiayi. Nii wakerak yaan tikishmatrarti, tímiayi. Tuma asamtai, yaunchu Yusa etserniuri̱ ju̱ní áarmiayi: ““Israer-aentsu, kuarenta (40) uwitin atsamunam wekaimiarmena nu̱i̱, ¿Winiak kuntin maanturtuamarum? Winia surustai tusarum peṉké túrachurme, tímiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Antsu, Muruk naartin ántar-yusa pujamuri̱n jukimiarme. Tura chíkich ántar-yussha, ni naari̱ Rempaṉ, yaa áanin najanarum nusha jukimiarme. Júkin asakrumin atumí nuṉke̱ya̱ jukin, tímia̱i̱ Papirúnia nuṉkan naṉkaiki akupkatjarme” tímiayi Yus.” Nuní áarmaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Estepaṉ tuke étseruk: ‘Yus Muisaisan tímiayi “Wi akupeamu chicham ikiunsatin je̱á áaniun Wi iniaktusjamna tímiatrusmek atsamunam najánatá” tímiayi. Tutai Muisais Yus tímianak umikmiayi. Nu je̱a̱n ii uuntri̱ yaunchu takaku ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nu je̱a̱n ni uchiri̱ akintkiar akintkiar wearmiayi. Ukunam, jú̱ nuṉka achiktin jeamtai, Yuska kapitián Jusueja̱i̱ jú̱ nuṉkanmaya̱ aentsun ji̱i̱ki akupkarmiayi. Tura ii uuntri̱ kapitián Jusueja̱i̱ winiarmia nu, nu je̱a̱ncha jú̱ nuṉkanam itiarmiayi. Tura Tawit uunt akupin náamtsa̱i̱ṉ, ii úuntri̱sha nu je̱a̱n takaku ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kame Yus Tawitian yájau enentáimtichmiayi. Tuma asamtai Tawit Yus shiir pujustinian je̱a̱n jeamtinian seamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Túrasha antsu Tawitia uchirí̱ Sarumúṉ Yusa je̱e̱n jeammiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Túrasha aents jeammanumaṉ Uunt Yus pujuschamniaiti. Jes, yaunchu Yusa etserniuri̱ Yus tímia nuna áarchamkia. ");
INSERT INTO jivNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ju̱na áarmiayi: “Nayaimpikia winia pujutairuiti. Nuṉkanmasha nawer tarimiui. ¿Warí je̱a̱ najatruatai tusarmea tarum? tímiayi Uunt Yus. Tura Wi ayampratniusha, ¿tui̱ aa? ");
INSERT INTO jivNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wiki winia uwejruja̱i̱ṉ ashí najanachmakiaj” tímiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Estepaṉ tuke étseruk: ‘Tura átumka Israer-shuartirmeka atumí enentái̱ji̱a̱i̱ tuke umichuitrume. Atumí kuishi̱sha weaktsui tura Yus nékachua núniniaitrume. Yusa Wakaní̱ji̱a̱i̱sha tuke nemasnaikiaitrume. Tura atumí yaunchu úuntri̱ji̱a̱i̱ métek túrarme’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","‘Iisia, atumí úuntri̱sha Yusa etserniuri̱n tuke kajerin ármiayi, tímiayi. Tura nú arant atumí úuntri̱sha Tunaarincha tátatui tu etseru wekaan, máacharmakia. Jes, nútiksarmek yamaisha, Tunaarincha támania nusha atumek anaṉkarum máachmakuram, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tura Yusa suntari̱ nayaimpinmaya̱ Yusa chichame̱n susamuitiatrum atumsha peṉké umikchamarme” tímiayi Estepaṉ. ");
INSERT INTO jivNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Israer-aencha Estepaṉ tu chichaamu antukar imiá kajerkar nain kátetete awajiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tura Estepaṉsha imiá Yusa Wakaní̱ pimiutkamuyayi. Tuma asa nayaimpinmaani íimias, Yusa winchari̱n, tura Yusa untsuuri̱ni̱ni̱ Jesusan wajan wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tumá wáiniak Israer-áentsun tímiayi “Núá íiskua, nayaimp uranniun wáinjai. Tura Jesusan, Aents Ajasu tutaiya nuna Yusa untsuuri̱ni̱ni̱ wajan wáinjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Támaitiat niisha kuishi̱n akiriarmiayi, tura achiktai tusar charáa tiar ashí wajatkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Túrawar, péprunmaya̱ arant júkiarmiayi. Tura antuk etserkarmia nu pushiri̱n áikiar, natsa Sauru wajamunam au iisti tusar áeprusarmiayi. Tura máawartai tusar kayaja̱i̱ tukurarmiayi Estepaṉkan. ");
INSERT INTO jivNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tura Estepaṉka tukamaitiat Yúsan áujsamiayi. Tura áujuk “Uuntru Jesusá, winia wakantrusha jurutkitia” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tura tikishmar aujuk “Uunta, ju̱ winia túrutainiana ju̱ makuip” tímiayi. Tura nuna ti̱ iniais, jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Estepaṉkan máawarmatai Sauru, péṉkeraiti, tímiayi. Tura áishmaṉ Yúsan péṉker enentáimta armiania nu, Estepaṉka a̱ya̱shi̱ncha iwiarsarmiayi, tura aneenak ti uutiarmiayi. Tura nú tsawantai̱ Yus-shuaran Jerusaréṉnum pujuarmia nuna ti kajerkatin naṉkamnamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sáuruka Yus-shuaran kajerak ti pataat wémiayi. Túmak nui̱ je̱á wayá, nui̱ wayá áishmaṉnasha nuwa̱ncha wáinkiaṉka japiki jukí sepunam eṉkeataj tusa túrimiayi. Tumakui Yus-shuar Jerusaréṉnumia̱ pisarar Jutía nuṉkanam, tura Samaria nuṉkanmasha jeawarmiayi. Jesusa akatramuri̱ṉkia antsu Jerusaréṉnumaṉ juakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Túrasha Jerusaréṉnumia̱ aents pisararmia nu, arant wénaksha tuke Yusa chichame̱n etserkini yujarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tura Jiripi Jerusaréṉnumia̱ we tura chíkich péprunam Samaria núṉkanam ámiania nui̱ jeá, chichaak “Yus anaikiamu ana nu Jesusaiti” tu etsermiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Túrakui aents iruntrar chikichík enentáiji̱a̱i̱ Jiripi étsereamun titiú pujusar antukarmiayi. Yusa kakarmari̱n nekaawarat tusa aentsti túrachminian túrimia nunasha wáiniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ti untsurí̱ aents iwianchruku ármia nuna Jiripi nu iwianchin ji̱i̱rki akuptiarmiayi. Tura íwianch jíiniainiak kakantar charáa tiar jíiniarmiayi. Tura ti untsurí̱ emearusha shutuapsha péṉker ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tuma asamtai nú péprunmaya̱ṉka ashí shuar ti warasar pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tura nú nuṉkanam uwishin Semuṉ pujumiayi. Nuikkia wi ímianaitjai tusa Samarianmaya̱ aentsun anaṉniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tuma asamtai ashí aents úmamkesar uchichisha, uuntcha, nin anturiarmiayi. Tura tiarmiayi “Ju̱ Semuṉsha Yusa kakarmari̱ji̱a̱i̱ áitkiawai.” ");
INSERT INTO jivNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tura ti untsurí̱ uwí wawekratmari̱ji̱a̱i̱ anaṉkarta asamtai, umirkarmiayi nu aents. ");
INSERT INTO jivNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Túrasha Jiripi Yusa akupeamuri̱n, tura Jesukrístununcha shiir chichaman etserkamiayi. Tura, nuna antukar nuwa̱sha áishmaṉsha umikiar imian wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Semuṉsha imia uwishniuitiat Yus-Chichaman enentáimtus imianmiayi. Tura Jiripiji̱a̱i̱ tsaniṉ wekaimiayi. Yusa kakarmari̱n shuar nekaawarat tusa Jiripikia aentsti túrachminian túrimiayi. Nuna wáiniak Semuṉ ti enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tura Jesusa akatramuri̱sha Jerusaréṉnum pujuarmia nui̱ Samarianmaya̱ aents Yusa chichame̱n umirainiawai taman nekaawarmiayi. Tuma asamtai Pitruncha Juáṉnasha nekáa ikiuutarum tusa akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tura Samarianmaya̱ Yus-shuarsha aya Uunt Jesusa náari̱i̱n imianiarmiayi. Yusa Wakaní̱ṉkia tárachmiayi. Tuma asamtai Pítrusha Juaṉja̱i̱ nui̱ jeawar Samarianmaya̱ Yus-shuara enentái̱n Yusa Wakaní̱ pimiutkarat tusan Yusan áujtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tura áujsua umikiar Pítiur Juaṉja̱i̱ ni uwejé̱n nú Yus-shuaran awantsarmiayi. Nuiṉkia Yusa Wakaní̱ taramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jesusa akatramuri̱ uweje̱ awa̱smanum Yusa Wakaní̱ taramtai, Semuṉsha nuna wáiniak, kuitja̱i̱ nu kakarman sumaktaj, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tura Jesusa akatramuri̱n chicharuk tímiayi “Winiasha kuitja̱i̱ surustarum nu kakaram. Wisha nútiksanak náṉkamas aentsnum winia uwejur awantsam Yusa Wakaní̱ tarurat tusan tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tutai Pítiur tímiayi Semuṉkan “Ámeka kuítrumja̱i̱ métek meṉkakatniuitme. Warí, Yus amaana nu ¿kuitja̱i̱ sumaktinkiait? ");
INSERT INTO jivNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yus esetram enentáimtachu asam nu túramu pachistincha peṉké tujinkiame, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Enentáimprata. Túram Yus seata. Enentáimtamna nuna Yus tsaṉkurtamprashtimpiash. ");
INSERT INTO jivNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nékajme, tsaaṉkea áintsaṉ yapá enentáimin pimiutramkaiti. Tura tunaarmi̱i̱n jinkiámua núniniaitme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tutai Semuṉ áimkiamiayi “Uunt Yus aujtursatarum. Túrutrumna nuna túrunawa̱i̱j tusan tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nuya̱sha Jesusa akatramuri̱ Jesusa túramuri̱n nú áentsun ujakarmiayi. Tura wésar Samaria nuṉkanam pepru ámunmaṉka Yus-Chichaman nui̱ etserkiar, nui̱ etserkiar Jerusaréṉnum waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tura Yus ni suntari̱n nayaimpinmaya̱n Jiripincha akuptukmiayi. Niisha chicharuk tímiayi “Wátskea. Juya̱ jiinkim Jerusaréṉnumia̱ jintia Eṉkasa péprunam wea nuní weme, anaraani̱ wetá. Nú jíntiaka atsamu nuṉkanam naṉkaamawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tutai Jiripisha wémiayi. Jintiá wesa Itiupianmaya̱ áishmaṉkan wáinkiamiayi. Nú áishmaṉsha Itiupia nuṉka akupniuri̱n, ni naari̱ Kantasen takarniuyayi. Kantaseka núwa̱uyayi. Tura nu áishmaṉ ti neka asa nuna kuítri̱n íirniuyayi. Nú áishmaṉsha Yúsan áujsataj tusa Jerusaréṉnum wéu wáketmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Karetanam eṉkemar wesa, Yusa etserniuri̱ Isayas aarmia nuna aujki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wats, Jiripi nú jintianam wéakui, Yusa Wakaní̱ nin tímiayi “Nú kareta amayáṉta.” ");
INSERT INTO jivNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tura Jiripisha amayáṉ, Yusa etserniuri̱ Isayasa áarmari̱n áujun antuk, chicharuk “¿Aujeamna nu nékamek?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tutai nú áishmaṉ tímiayi “¿Itiurak nekaataj? ¿Yaki jintintruat?” tímiayi. Tura antsu iiji̱a̱i̱ wetái tusa, Jiripincha eṉker jukimiayi karetanam. ");
INSERT INTO jivNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nu papí áarman áujmia nu jú̱uyayi: “Murikiua áitkiasaṉ jákatniunam júkiarmiayi. Tura uchich murik, ure̱ tsúpiram chichaatsna núnisaṉ niisha chichakchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nincha iniatsárarmiayi. Túrasha peṉké chichamnaka tútsuk tsaṉkamakmiayi. Niisha nuṉkanam iwiaaku pujá maamu asamtai, ¿yaki nuna áujmatkatⁱ?” Nuní aarma ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kantase takarniuri̱ Jiripin aniasmiayi “Waitneasam turuttia, tu aarma nusha, ¿yana ta? ¿Yusa etserniuri̱ níṉkik túmama? ¿Chikichnash ta?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nuyá Jiripi nu aarman áujtus “Ju̱ka Jesusnan tawai” tímiayi. Tura nú arantcha Yus-Chichaman ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nuyá entsa ámanum naṉkaamak áishmaṉ Jiripin chicharuk “Jui̱ entsá jeaji. Wikia ju̱i̱ imianchamniakaitiaj” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tutai Jiripisha tímiayi “Tuke enentáimja̱i̱ Jesus nekas enentáimtakminkia túramniaitjame.” Tutai áishmaṉ chichaak “Ee nekasaiti, Jesukrístuka Yusa Uchirí̱nti tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tura, karetan awajas mai jíinkiar entsá wearmiayi. Nu̱i̱ Jiripikia Kantase takarniuri̱n imiaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tura kukar jíinkiarmatai Uunt Yusa Wakaní̱ Jiripinkia jukimiayi. Tuma asamtai Kantase takarniuri̱sha Jiripin wáinkiachmiayi. Túrasha niṉkia waras wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jiripisha jeachat Asutu péprunam wantinkiamiayi. Tura nuyá jiinki péprunam nuí̱ wayá, nuí̱ wayá Yus-Chichaman etserki we, Sesaria peprunam jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nuna tuma̱i̱, Jerusaréṉnum Uunt Jesusan umirkarmia nuna máataj tusa áujmattan Sáuruka peṉké iniaichamiayi. Tuma asa Israer-patri uuntri̱ iyutaj tusa werimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tura jeari tímiayi “Papí ame naarmi̱ji̱a̱i̱ áaram surusta. Wi nuna papí jukin timiai̱ Tamasku péprunam jean, Israer-shuar iruntainiam waya̱ttajai. Túran nú papiji̱a̱i̱ Jesusan umirkaru ainia nuna, náṉkamsan achikiartatjai. Túran áishmaṉnasha nuwa̱ncha achikian jinkian, jui̱ Jerusaréṉnum eṉkeataj tusan ikiaankattajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tura papí susam Sauru jintiá wéai̱, Tamasku péprunam nuntumsa̱i̱ nui̱ aya aneachma nayaimpinmaya̱ tsáapin jiitsumir téntakmiayi nin. ");
INSERT INTO jivNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Túrunamtai Sauru nuṉká iniaarmiayi. Tura nayaimpinmaya̱ chichaamun antukmiayi. “Sauru, Sauru, ¿Urukamtai yajauch awajtustaj tusam imiá pataaturam?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Táman antuk “¿Amesha, yáitiam, uunta?” tímiayi Sauru. Tutai ataksha áimkiamiayi “Wikia Jesusaitjai. Ame pataaturmena núitjai, tímiayi. Wíi aents pataatamna nui̱, amek enentáimin yajauch awajmamsame, waaka saṉkanmiak numin ijiuma núnismek” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nuyaṉka Sauru sapijin kuraṉki tímiayi “Nuiṉkia Uunta, ¿wi warinia itiurkat tusamea wakeram?” tímiayi. Tutai Uunt chichaak “Wajakim weme péprunam waya̱tá, tímiayi. Nu̱i̱ jeawakmin ame túratamna nuna turamiartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tura Sáuruja̱i̱ irunar wearmia nu, chichaamun antukarmiayi. Tura áentsnaka peṉké wáinkiacharmiayi. Tuma ásar ti ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nuyá Sauru nuṉká tepá nantakmiayi. Tura wáinmaktaj tukamá wáinmakchamiayi. Tuma asamtai chíkich shuar uwejnum eṉkekiar júkiarmiayi Tamaskunam. ");
INSERT INTO jivNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nui̱ jeá menaintiu tsawant íimtsuk tura yurumtsuk peṉké úmutsuk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nui̱ Tamaskunam Yus-shuar Ananías ámiayi. Nin mesekranam Uunt Jesus tímiayi “Ananíasa.” Tutai “¿Warí wakeram, Uunta?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nuyá Uunt Jesus tímiayi “Wajakim jintia, Naka tutaiya nui̱ wetá. Nui̱sha Jutasa je̱e̱n jeam, Társunmaya̱ Sáurun e̱a̱ktaj tusan winijiai, titiá, tímiayi. Niisha Yúsan áujuk pujawai. ");
INSERT INTO jivNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tura ju̱na mesekranam ipiatkamjai Sáurun. Aishmaṉ wayá ni uwejé̱ja̱i̱ ántiawai, ataksha íimit tusa. Nú áishmaṉka ámetme, Ananíasa” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Táman antuk Ananías chichaak “Túrasha Uunta, ju̱ áishmaṉ ame áentsrumin Jerusaréṉnum ti yajauch awajchakait. Ni yajauch túramurí̱n ti untsurí̱ aents ujatainiawai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tura yamaisha Israer-patri chicharniun papirí̱n takakui. Tura nuja̱i̱ ame náarmin páchiaj nuna achik jukitiaj tusa tímiajai̱sha tarutramji” tímiayi Ananías. ");
INSERT INTO jivNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tutai Uunt Jesus tímiayi “Áankisha wetá. Ju̱ áishmaṉkan winia etserniur atí tusan achikjai Wi. Niisha Israer-shuarchancha tura kapitiánniasha tura Israer-shuarnasha wínian etserin átatui, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tura Sauru winia náarun páchia asa ti wáitsattana núnaka nin iniaktustatjai” tímiayi Jesus. ");
INSERT INTO jivNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tura Jesus táman umirak Ananías Sauru pujamunam wémiayi. Tura jeari wayá uwejé̱n awantas tímiayi “Yatsuru Sauru, Uunt Jesus jintiá wantintiurmakmamna nusha ame ataksha íimiat tusa, tura Yusa Wakaní̱sha enentáimin pimiutramkat tusa winia akuptukai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nu chichamaik ni ji̱i̱ya̱ namaká saepe̱ya áanin iniaarmiayi. Túrunamtai ataksha íimmiayi. Túruna wajaki we imianmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nuya̱sha yurumámiayi. Tura yurumásha kakaram ajasmiayi. Tura Yus-shuarja̱i̱ Tamaskunam wárumchik tsawant pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nuya̱ṉka Sauru Israer-shuara iruntairi̱n wayá Jesusa túramuri̱n etserkamiayi. Etseruk tímiayi “Nekasaiti, ju̱ Jesus Yusa Uchirí̱nti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nuna ashí anturú pujuiniaka “¿Ausha urukakua aania? tiarmiayi. Entá ju̱ áishmaṉsha Jerusaréṉnum Jesusan enentáimtuinian ti pataatimia núchakait. Tura tímiajai̱sha nuna achik Israer-patri akupniuri̱i̱n jukitiaj tusa tamia núchakait” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tura Sáurusha sapijmiatsuk etsermiayi. “Ju̱ Jesus nekas áentsun Uwemtikniuiti” tu etsermiayi. Tura ti paant étserkui, Tamaskunmaya̱ Israer-aents, nekaschaiti titiaj tukamá tujinkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tura ukunam, Israer-aents Sáurun maatai tusar chichaman jurusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tura Sáurusha nu chicham jurusman nekamamiayi. Israer-aents pepru jíinmanum tuke tsawa̱i̱sha, káshisha achikiar maatai tusar jintian akirtiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nuna antukar Yus-shuar Sáurun chiiknium kashi eṉkeawar itiararmiayi. Pepru tanishnum itiarar awemarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tura Sauru Jerusaréṉnum jeá Yus-shuarja̱i̱ iruntrattsa wakerimiayi túrasha niṉkia ashamiarmiayi. Sáurusha nekas Yus-shuar ajaschaiti tusar ashamiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Túmainiai̱ṉ Pirnapí Jesusa akatramuri̱ matsatmanum jukimiayi Sáurun. Tura nui̱ ejé tímiayi “Ju̱ Sauru jintiá wesa Uunt Jesusan wáinkiaiti. Tura Yus chicharkaiti. Tuma asa Sauru Tamaskunam sapijmiatsuk Jesusa náari̱n etserkaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tura Sauru Jerusaréṉnum juákmiayi. Tura Yus-shuarja̱i̱ irunar pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nuya̱sha Yus, etserkata tutai, sapijmiatsuk Jesusa túramuri̱n etsermiayi. Tura Israer-shuar Kriaku chichaman chichau ármia nu, nui̱ pujuarmiayi. Sáurusha nu shuarja̱i̱ áujmatsarmiayi. Túrasha nu shuar Sáurun itiur máatjik tusar chichaman juriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tura Yusai̱ yachi ármia nu, chicham jurusman nekaawarmiayi. Neka ásar Sáurun Sesaria peprunam júkiarmiayi. Tura nuya̱sha Tarsu péprunam akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tura Jutíanmaya̱, Kariréanmaya̱sha, Samarianmaya̱sha Yus-shuar shiir tímiajnisaṉ ajasar kakaram ajasarmiayi. Yúsan ashamainia ásar, tura Yusa Wakaní̱ yayamu ásar kaweṉki kaweṉki wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tura Pítiur Yusai̱ yachi armiania nui̱ iráa wekaimiayi. Wekaak Yus-shuar Rítianam matsamarmia nui̱sha iraumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nui̱sha Rítianam jeá áishmaṉkan Eneas náartinian wáinkiamiayi. Niisha emearu asa wekaicha uchu uwí aya tépenuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tura Pítiur chicharuk “Eneasa, Jesukrístu tsuármawai. Nantaktia. Tura esekmatairam iwiarata” tímiayi. Tutai Eneas nu chichamaik nantakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nuna túman wáinkiar Rítianmaya̱ aents tura Saruṉmaya̱ aencha enentáimprar Uunt Yusan nemarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Túrasha Jupe péprunam nuwa̱ Yus-shuar pujuyayi, ni naari̱ Tapitia. Tura nusha Kriaku chichamja̱i̱ṉkia Túrkas tuiniawai. Nu nuwa̱sha nui̱ pujus tuke péṉker túriniuyayi. Tura niisha nútiksaṉ ya̱i̱ wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nu tsawantinik Túrkas suṉkuran jateemak jakamiayi. Túrunamtai aya̱shin nijiarar yakí tesaamunam áepsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jupe péprusha Rítianmaya̱ tíji̱u̱ch ámiayi. Júpenmaya̱ Yus-shuar Rítianam Pítiur pujan nekaawar jimiará áishmaṉkan akatrar akupkarmiayi, Júpenam wari winití tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nui̱ tutai Pítiur niiji̱a̱i̱ wémiayi. Tura támatai jaka tepemia nui̱ awayáwarmiayi. Nui̱ waya̱mtai waje̱ pujuarmia nu úutkiar Pítrun téntakarmiayi. Túrawar pushiri̱n, Túrkas iwiaaku pujus najankamia nuna iniaktusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nuyaṉka Pítiur a̱a̱ akupkarmiayi ashí. Tura niisha niṉki tikishmar Yúsan áujsamiayi. Nuya̱sha nuwa̱n jaka tepaan iis tímiayi “Tapitia nantaktia.” Tutai niisha íimi Pítiur wajaan wáiniak nantaki pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tura Pítrusha nuwa̱n uwejnum achik awajkimiayi. Tura iniais Yus-shuar ármia nuna tura wajencha untsukar Túrkas iwiaaku ajasun iniaktusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu túrunamun ashí aents Jupe péprunmaya̱ nekaawarmiayi. Túrawar untsurí̱ aents Uunt Jesusan umirkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tura Pítruka Jupe péprunam untsurí̱ tsawant nuapen-iwiarin Semuṉka je̱e̱n pujusmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesaria péprunam Kurniriu naartin suntara kapitiántri̱ pujumiayi. Ni suntari̱ Itiaria nuṉkanmaya̱ ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nu kapitián Kurniriu ni shuari̱ji̱a̱i̱, Yuska naṉkaamantuiti, tu enentáimtiarmiayi. Tuma ásar Yúsan enentáimtin ármiayi. Tura nútiksaṉ kuítniasha takakchan yáiṉtaj tusa Israer-shuaran súuyayi. Tura tuke tsawant Yúsan áujtiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chíkich tsawanta̱i̱, nantu aaṉku ajasa̱i̱ Kurniriu íimiarmiayi. Yusa suntari̱ Yus nayaimpinmaya̱ akupkamu, ni pujamunam utuá “Kurniriuá” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kurniriuá tutai, Yusa suntari̱n ashamak íimia pujumiayi. Tura “¿Warimpiait, Uunta?” tímiayi. Tutai Yusa suntari̱ tímiayi “Ame seamun Yus anturtamkai. Tura atsumainia nu yayakmin Yus shiir enentáimturmawai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tura Yusa suntari̱ Kurniriun tuke chicharuk “Wats, áminiuram Júpenam akupkata. Semuṉ, chíkich naari̱ Pítiur, tatí tusam akuptukta, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nu Semuṉsha chíkich Semuṉja̱i̱ pujawai. Nuka nuapen-iwiarin Semuṉkaiti. Tura ni je̱e̱sha nayaantsanam ayaamach pujawai, tímiayi. Nu̱i̱ jeawakmin, ame túratamna nuna Semuṉ Pítiur turamtatui” tinia ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tura Yusa suntari̱ waketkimtai, Kurniriuka ni takarniuri̱n jímiaran itiamiayi. Tura suntaran chikichkiniak nemarsat tusa itiamiayi. Nu suntar ni írutramuri̱yayi. Tura Yúsan enentáimtiniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kurniriusha ni túrunamuri̱n ashí ujáa-já awajas Jupe péprunam akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kashin tsawantai̱ Kurniriu suntari̱ Júpenam nuntumsara̱i̱, tutupin a̱i̱ Pítiur je̱a̱ yakí wáakunam Yúsan áujsatajtsa wakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pítrusha ti tsukamak yurumátaj tusa wakerimiayi. Túrasha yurumkan iniarainia̱i̱ Pítiur íkiajtiusmak, ");
INSERT INTO jivNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","nayaimp uranmianum waṉkaram tarachia áanin tura nuna tsakari̱n jiṉkiakman tárun wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nu tarachnium yajasma irunmiayi. Wekainiusha, nanamtincha, tura napisha eṉkemiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tuma̱i̱ Yus Pitrun chicharuk “Pitru, wajakim maam yuata” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tutai Pítiur tímiayi “Atsá Uunta. Ii Israer-shuartikia yajauch yajasma áinia nu tura yúatin surimkiamu ana nuka peṉké yúchaitji. Tuma asamtai jú̱naka wikia yuashtatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Túrasha Pitrun atak Yus chicharuk “Wi, péṉkeraiti, tájana nu, yajauchiiti, tiip” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nuka menaintiú túrunamiayi. Tura nuya̱sha tarach ataksha nayaimpiniam wakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nuna túrunan wáiniak Pitiur wariniak áaniuncha wáinkiaj tusa enentáimia puja̱i̱ kapitián Kurniriu aya̱kma armia nu, anintruiniak jeawariayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tura jeawar kakantar untsummiar “¿Semuṉ, Pítiur, ju̱i̱ṉ pujá?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tura Pítruka íimiarmari̱n tuke enentáimia pujai̱ Yusa Wakaní̱ chichaak “Menaintiu áishmaṉ untsurmainiawai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wajakim akaikim arantutsuk au nemariarta, Wi akupkamu asamtai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nuna antuk Pítiur taramiayi. Tura áishmaṉkan Kurniriu akupkamia nuna wajainian wáiniak “Wiitjai Pítiur. Átum e̱a̱trumna núitjai. ¿Warí tarintrum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tutai niisha tiarmiayi “Iisha kapitián Kurniriu akupkamu taji. Kurniriuka áishmaṉ péṉkeraiti. Yúsan enentáimtiniaiti. Tura Israer-aencha nin shiir enentáimtuiniawai. Ní̱i̱ya̱ winiaji, tiarmiayi. Kame nuik, Yusa suntari̱, nayaimpinmaya̱ akupkamu, ii kapitiántri̱n tímiayi “Pitrun untsukát akupkata. Nii tatí. Tura nii títiatna nu péṉker anturkata” tímiayi. Nuna ii kapitiántri̱n takui iisha winiji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tutai Pítiur je̱á awayá̱miayi. Tura nu kashi nui̱ kanararmiayi. Kashin tsawa̱rar Pítiur niiji̱a̱i̱ wearmiayi. Túrasha Júpenmaya̱ Yus-shuarsha nin nemariarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nuyá tsawa̱rar Sesaria péprunam, Kurniriu nákamun jeariarmiayi. Kurniriuka ni shuari̱n tura ni nekas amikri̱n, nekaatarum tusa untsuk ikiaankamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tura Pítrusha jeamtai Kurniriu a̱a̱ jiintiuki Pitrun tikishmatramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Túrasha Pítiur awajki tímiayi “Wajaktia. Wisha aya áentsketjai. Ámea núnisketjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tura chichasar je̱á waya̱warmiayi. Tura wayá, untsurí̱ aents matsatun wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nuyá Pítiur chichaak tímiayi “Amikrua, atumsha nékarme. In Israer áentstinkia, chíkich áentsja̱i̱ pachiniarchatniuitrume, tura ni je̱e̱ncha wa̱ya̱shtiniaitrume in jintintramin turamainiaji, tímiayi. Túrasha Yuska ni enentáimsamuri̱n wíniaka paant iniaktursayi. Túmaitkiui wikia náṉkamas áentsun yajauchiiti, tura auka wapikiaiti, tíchamniaitjai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tuma asamtai, untsurkurmin, páchitsuk winimjai. Túmaitkiui nekaataj tusan wakerajai. ¿Urukamtai untsurkamarum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tutai Kurniriu tímiayi “Kuatru tsawa̱nt naṉkaamasa̱i̱ tura nantusha ju̱ni a̱i̱, wikia yurumtsuk Yúsan áujsamjai, ki̱arai̱ áujsatin ana nuna. Túran chichai̱, áishmaṉ, ni entsatairi̱ wincharpatniun, naka wajatran wáinkiamjai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Niisha chichartak turutmiayi “Kurniriu, Yus ame áujman anturtamkayi. Tura shuar atsumainia yáiṉmamna nunasha nekarmayi, turutmiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuma asamtai, Jupe péprunam akatramuram akupkata. Semuṉ Pítrun itiatí. Nu Semuṉ Pítrusha, chíkich Semuṉja̱i̱ pujawai. Nuapen-iwiarin Semuṉkaiti nuka. Tura ni je̱e̱sha nayaantsanam aya̱mach pujawai. Niisha taa ámin chichartamkattawai” turutmiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Túrutkui, wi umikian áentsun wárikmasan ámin akuptukjame utitia tusan. Tura nékaseṉ taume. Tuma asamtai iisha ju̱i̱ Yus íimmianum pujuiniaji. Tuma asamtai, ashí Uunt Yus ámin au ujakarta túramna nu, iisha antuktai tusar pujaji” tímiayi Kurniriu. ");
INSERT INTO jivNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nuyá Pítiur chichaak “Ayu. Yus íimmianum ashí aents métekrak áiniawai nekas nékajai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Antsu ashí nuṉkanam náṉkamas aents Yúsan umirak péṉker tura nuna, Yus nú aentsun shiir enentáimtawai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yuska shiir chichaman Israer-aentsun akuptukmiayi. Nui̱ chichaak “shuar Jesukrístu naari̱n páchiakka, Yusja̱i̱ nawamnaikiatin átiniaiti, tímiayi. Nú Jesukristu ashí shuara Úuntri̱nti’ tímiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Túrasha Kariréa nuṉkanam naṉkamak ashí Israer nuṉkanam túrunamia nu paant nékarme. Imiakratin Juaṉ imiaak etserak amukmia nú tsawantin naṉkamamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tura ju̱sha nékatsrumek, tímiayi. Nasarétnumia̱ Jesus, Yus Anaikiamu asa, Yusa Wakaní̱ kakarmari̱ji̱a̱i̱ péṉker túriniuyayi. Iwianchruku wáitias pujuarmia nuna péṉker awajsamiayi. Yus Ni̱i̱n pujurma asa ashí nuna túriniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tura Israer-aents matsatkamunam tura imia Jerusaréṉ péprunmasha Jesus túramia nu, iisu asar, iisha étsereaji. Tura ayu, Nin achikiar krúsnum máacharmakia, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tura menainti tsawant jeamtai Yus Nin iniantkimiayi. Tura ataksha iwiaintiurtamkachmakajⁱ, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ashí áentsnumka wantinkiachmiayi. Antsu íniak nuik, etserin atarum tusa Yus achirmakmiaj nú áentstiniak wantintiurmakmiaji, tímiayi. Au nekas jakamunmaya̱ nantakmiatai iisha Niiji̱a̱i̱ tsaniṉkiar yurumámji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tura Jesussha in akuptamkaitji. Jesuska “Wiitjai Yus Anaikiamun, tímiayi. Ashí áentsun, ju̱ka makuumawai, túrasha ju̱ka makuumatsui, Wiki títiniaitjai. Kame ashí áentsun, jaka áinia nuna tura iwiaaku áinia nunasha, Wíkiitjai nuna títinian” tímiayi Jesus. Nusha átum werum ujatruktarum, Jesus turammaji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ya shuarak Jesusa náari̱n pachia nú shuarnaka tunaari̱n tsaṉkurattawai, nuna ashí Yúsnan etserniusha yaunchu etseriarmiayi” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tura Pítiur tuke chichaak puja̱i̱, tura chikichcha antúu pujuinia̱i̱ Yusa Wakaní̱ tarurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tuma ásar aṉkant aṉkant chíkich chichamja̱i̱ chichasarmiayi. Túmainiak, Yus ti péṉkeraiti, tiarmiayi. Tura Israer-shuar, Yus-shuar armia nuka Pítruja̱i̱ táarmia nu, nuna antukar ti enentáimsarmiayi. Maa, Yusa Wakaní̱sha Israer-shuarcha ainia nunasha tarurcharaik, tu enentáimsarmiayi ");
INSERT INTO jivNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Túmakui Pítiur chichaak “¿Yaki surimkiat ju̱ aents imiantinian? Warí nincha ínia áintsaṉ Yusa Wakaní̱ tarurcharaik” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nuyá Pítiur, Jesukrístu náari̱i̱n imiantiarum tusa akupkarmiayi. Tura nuya̱sha Pitrunka, niiji̱a̱i̱ ishichik tsawant pujustinian seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Israer-shuarchasha Yusa chichame̱n umirkarai táman Jesusa akatramuri̱sha tura Jutíanmaya̱ Yus-shuarsha antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Túmainiak Pítiur Jerusaréṉnum jeamtai, Israer-shuar Yus-shuar ármia nu chichainiak ");
INSERT INTO jivNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“¿Urukamtia Israer-aents áiniachusha iyumam? ¿Tura auja̱i̱ tsaniṉkiam urukamtai yurumámum?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tutai Pítiur ashí yámankamtaiknumia̱ túrunamun ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Chichaak tímiayi “Wikia Jupe péprunam pujumjai. Tura nui̱ Yusan auju pujusan íimiarmajai. Tura waṉkaram tarachia áanin kuatru tsakari̱n jiṉkiakma, nayaimpinmaya̱ táarun wáinkiamjai. Tura wi pujamunam jeartimiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tura nui̱ iiyaj tukaman init yajasman, napincha, nanamtinniasha eṉketainian wáinkiamjai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tura chichaman antukmajai “Pitru wajakim maam yuata” túrutun antukmajai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Túrutkui “Atsá, Uunta, áanin wapiknaka, Israer-aents yuatin surimkiamu ana núnaka tuke yúchaitjai” tímiajai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Atak nuyá túrutuk “Wi, péṉkeraiti, tájana nu, ámeka, yajauchiiti, tiip” turutmiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nunasha menaintiú túrunan wáinkiamjai. Túruna nayaimpiniam mash waketkimiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nui̱ túruna puja̱i̱ menaintiú áishmaṉ Sesarianmaya̱ akupkamu, winia e̱a̱tainiak wi pujamunam tarutiarmiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tura nui̱ Yusa Wakaní̱ chichartak “Arantutsuk auja̱i̱ wetá” túrutkui, wémajai. Tura ju̱ sais Yus-shuarja̱i̱ wi wémajai. Túrunar ashiṉkiar Kurniriu je̱e̱n waya̱mji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Niisha chichaak “Je̱a̱ru̱i̱ Yusa suntari̱ nayaimpinmaya̱ taa wajan wáinkiamjai, tímiayi. Tura niisha chichartak “Jupe péprunam Semuṉ Pítiur tatí tusam áishmaṉ akatram akupkata. ");
INSERT INTO jivNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pítrusha taa, itiura amesha tura áminiurmesha tunaarminia̱ uwemprattam nuna turamtatui.” Yusa suntari̱ nuní turutmiayi” tu ujatkamiayi Kurniriu’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","‘Wi chichastasan júara̱i̱, Yusa Wakaní̱ tarurarmiayi, yámankamtaik in tarutrampramiaj nútiksaṉ, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nuiṉkia Uunt Jesus timian enentáimpramjai. Niisha tíchamka “Juaṉ entsaja̱i̱ṉ imiakratmiayi. Tura antsu Yusa Wakaní̱nkia imiantinia áintsaṉ atumí enentái̱n eṉkemprutmattarme.” Nu timian enentáimpramjai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Atumsha enentáimpratarum. Uunt Jesukrístu umirkamiaj nui̱, incha Yuska ni Wakaní̱n suramsamiaji. Tura in suramsamiaj núnisaṉ Yus nincha ni Wakaní̱n súsarmiayi. Nuna tura asamtai, wikia, túrashtiniaiti, Yúsan títinkiaitiaj” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tura Pítiur taman antukar mitiat wáinkiar “Nekasaiti, Israer-shuarchancha ni enentáin yapaji̱áwarmatai tuke iwiaaku átinian Yuska nin súsaruiti” tiarmiayi. Tusar Yusa náari̱n ti shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estepaṉkan máawarmia nu̱i̱, chíkich Yus-shuarnasha maatai tusar pataatiarmiayi. Túram chíkichkia pisarar Pinisia nuṉkanam, Chipri nuṉkanmasha, tura Antiukía péprunmasha wearmiayi. Tura nui̱ jeawar Yus-Chichaman chikichnaka ujatsuk aya Israer-aentsnak ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tura niiji̱a̱i̱ Chipri nuṉkanmaya̱ pisararmia nu Serini nuṉkanmaya̱sha Yus-shuar ármiayi. Nuka Antiukíanam jeawar Israer-shuarchan Uunt Jesusa túramuri̱n ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tura Uunt Jesus ikiakárma ásar, nú nuṉkanmaya̱ aents ti untsurí̱ yaunchu túrutairi̱n iniaisar Jesusan enentáimtuiniak Yus-shuar ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tura nu chichaman antukar, Jerusaréṉnumia̱ Yus-shuar, ame iyutá tusar, Pirnapín Antiukíanam akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Pirnapísha jeá, Yus nú shuaran uwemtikrarma nuna wáiniak warasmiayi. Pirnapísha péṉker áishmaṉkauyayi. Yusa Wakaní̱sha pimiutkamuyayi. Tura Yúsan nekas umirkauyayi. Tuma asamtai nu shuaran mash jintintiainiak chicharuk “Tuke enentáimja̱i̱ umirkarum Yus nemarsatarum.” Tu chicharak ikiukmiayi. Tura nui̱sha nú arant untsurí̱ aents Yusai̱ kaweṉkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nuna turasua amik Pirnapí Tarsu péprunam wémiayi Sáurun wáinkiataj tusa. Tura wáiniak Antiukía péprunam jukimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tura nui̱ jeawar, nú péprunmaya̱ Yus-shuarja̱i̱ iruntrar chikichík uwí pujusarmiayi. Yus-Chichaman untsurí̱ shuáran ujaak pujuarmiayi. Tura nui̱ Antiukía péprunmaṉka Yus-shuaran émkaka, Kristu shuari̱, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nuyá Yusnan etserin Jerusaréṉnumia̱ táarmiayi Antiukíanam. ");
INSERT INTO jivNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Túmainiai̱ chikichík etserin, ni naari̱ Akaapu, Yus-shuar matsatmanum ajapén wajaki chichasmiayi. Tura Yusa Wakaní̱ nekatairi̱ji̱a̱i̱ chichaak “Ti tsuka ashí núṉkanam átatui” tímiayi. Tuma asamtai Antiukíanmaya̱ Yus-shuar chichainiak “Jutía nuṉkanmaya̱ Yus-shuar ainia nu yáiṉtai” tiarmiayi. Aṉkant aṉkant ni wakeriarmia núnik súsarmiayi. Tura nú kuítniasha Jutíanmaya̱ Yus-shuara úuntri̱n akuptukarmiayi. Pirnapísha Sáurusha nú kuítian júkiarmiayi. Tura Akaapu tímia núnisaṉ túrunamiayi, akupin Krautiu puja̱i̱. ");
INSERT INTO jivNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nu tsawanta̱i̱ akupin Erutis Yus-shuaran máataj tusa chichaman jurus áentsri̱n ishiakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tura Juaṉka yachi̱n Jakupun sue̱n tsupirkar máawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nuna tura máawarmatai Israer-aents wáinkiar “ju̱ka péṉkeraiti” tiarmiayi. Erutissha nuna antuk, Pítrusha achikrum itiatarum tusa akupkarmiayi. Núnaka wakapruachu tanta yuatin nampertin túrawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pítruncha achik itiarmatai, Erutis sepunam eṉkeata tusa akupkamiayi. Tura sepunam suntarsha aṉkant aṉkant, kuatru kuatru, ashikia tiasisáis (16) irunar Pitrun téntakarmiayi. Tura, ju̱ jísat naṉkaamasmatai, mantamnatí tusan ji̱i̱ktiatjai aents iruntramunam, tu enentáimsamiayi Erutis. ");
INSERT INTO jivNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Túramu asa Pítruka sepunam pujumiayi. Tura suntarsha miji̱atrutsuk iiyarmiayi. Túramunak Yus-shuarka, Pitrun yáiṉkiat tusar iniaitsuk Yúsan ti áujiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wats, Erutis, kashin jí̱i̱ktiajai takui, nú kashi Pítruka jimiará suntar wajamunam etema tepes kanarmiayi. Tura jimiará jiruja̱i̱ jiṉkiamuyayi. Tura chíkich suntarka jíinmanum ii wajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tuma̱i̱ aya aneachma Yusa suntari̱ nayaimpinmaya̱ taa ajapén wajasmiayi. Túrunamtai je̱a̱nmaṉka tsáapin ajasmiayi. Tura Yusa suntari̱sha Pitrun páenum antiṉ ishintiarmiayi. Tura jirusha Pitru uwejé̱ya̱ saya̱t atiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tura Yusa suntari̱ tímiayi “Kaki emenmamata. Túram sapatrumsha aweekata” tímiayi. Tutai Pítiur túramiayi. Nuyá chichaak “Pushiram entsarta. Túram nemartusta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tutai Pítiur nemarsamiayi. Túrasha Pítruka, mesekranmaapi jú̱niaja, tu enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Túrasha emka suntar íimia wajan naṉkaikiarmiayi. Tura nuya̱sha chíkich suntar íimia wajan nunasha naṉkaikiarmiayi. Tura nuya̱sha jíintiainium jiru waiti ámanum jeawarmatai, nú wáitisha ímia-niṉki kua̱t uranmiayi. Túrunamtai jíinkiarmiayi. Tura jintiá ishichik wésaṉ, Yusa suntari̱ Pitrun níiniak ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Túram Pítiur enentáimiar tímiayi “Yamaikia nékajai. Mesekranmachuiti. Antsu Uunt Yus ni suntari̱n nekas akupturkayi. Erutis mantuataj tusan pujurtana nuyá Yusa suntari̱ winia uwemtikrurai. Tura Israer-aents túrutatajtsa wakeriarmia nuya̱sha uwemtikrurai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nuna tu enentáimias nekáa, Marí je̱e̱n wémiayi. Nú Marisha Juaṉ Márkusan nukurí̱yayi. Nú je̱a̱nam untsurí̱ aents irunar Yúsan auju matsatainia̱i̱ Pítiur jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tura jeá a̱a̱ wáitin tuntuimiayi, waya̱taj tusa. Túmakui nuwa̱ uchich, ni naari̱ Ruti, yákit tusa iyumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tura jeari, Pitru chichame̱n anturak ti shiir enentáimsamiayi. Túmak wáitin urattsuk ikiuki, init matsatainian werí “Pítiur taa wáitiniam wajaawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tutai “Wáurtsumek” tiarmiayi. Tútaisha núwa̱ka “Atsá nekasaiti” tímiayi. Tútaisha nú arant “Níichuiti. Antsu ni wakaní̱ túratsuash” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tu chichainiai̱ṉ Pítruka tuke tuntuí wajamiayi. Tura wáitin uraj tukamá Pitrun wáinkiar ashamkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ashamak chichainiakui Pítiur, uweje̱ takuí itiatmamtikiarmiayi. Tura nuyá Uunt Yus sepunmaya̱n uwemtikramun ujakmiayi. Tura “Ju̱ chicham Jakupu tura chíkich Yus-shuarsha ujaktarum” tímiayi. Nuna ti̱ iniais jiinki arant wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kashin tsawa̱r suntarsha Pitrun atsá wáinkiar “Chuwa urukakua meṉkaka. Áya̱wa̱ urukattajia” tiarmiayi. Pítiur túrunamun nékachu ásar nuna tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","20","Túrunamtai Erutis chichaak Pítiur e̱a̱ktarum tusa akupkarmiayi, túrasha wáinkiacharmiayi. Túrunamtai Erutis suntaran untsukar, Pítrun íisarmia nuna aniasarmiayi “¿Pítiur itiura meṉkakama?” tímiayi. Niisha áimiainiachkui, nu suntaran mantámnatí tusa akupkamiayi. Erutissha Tirunmaya̱ tura Setúnmaya̱ áentsja̱i̱sha nemasnaikiarmiayi. Túmayataṉ Jutía nuṉkan ikiuki Sesaria péprunam pujustaj tusa Erutis wémiayi. Sesaria péprusha Tiru péprunam tíjiu̱chiiti. Setúnmaya̱ aents Tirunmaya̱ áentsja̱i̱ Erutisa nuṉke̱yan yurumkan súmainia ásar, Erutisja̱i̱ nawamnaikiatniun wakeriarmiayi. Tuma asamtai métekrak enentáimsar, Erutisa takarniuri̱ peṉkeri̱, ni naari̱ Parastu, niiji̱a̱i̱ emka amikmawar nuyá Erutisan weriar shiir matsamsatniun seawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tuma asamtai tsawant jeamtai Erutissha akupin entsatai pushin entsarmiayi. Tura akupin pujutainium pujus áentsun ikiaanak áujmatmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nui̱ pujus chichaakui aents untsumainiak tiarmiayi “Ju̱ chichaa pujana ju̱ka áenchaiti. Antsu nekaska yúsaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tuma̱i̱ nuyai̱k Yusa suntari̱ nayaimpinmaya̱ tarí Erutisan jaa awajsamiayi. Tuma asamtai nusha aka yuam jakamiayi. Erutissha Yusan waantu awajtsuk niṉki waantu enentáimtuma asa túruna jakamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Túrunamtaisha Yusa chichame̱nka nú arant pampaṉki wémiayi. Túmaki̱ ashí núṉkanam anturamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tura Pirnapísha Sáurusha ni takatri̱n amukar Jerusaréṉnumia̱ Antiukíanam waketainiak Juaṉ Márkusan júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiukíanmaya̱ Yus-shuarnum Yusnan etserin páchitra ármiayi. Nútiksaṉ Yus-Chichaman jintinniuri̱sha ármiayi. Pirnapísha tura Mukusa Semuṉsha, nuyá chíkich, Serinianmaya̱ Rúsiusha tura akupin Erutisa tsakatke̱sha, ni naari̱ Manaen, Sáurusha tímianu ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tura chíkich tsawanta̱i̱ niisha yurumtsuk Yúsan áujeak pujuinia̱i̱ Yusa Wakaní̱ tímiayi “Pirnapísha, Sáurusha akanturkitiarum, tímiayi. Wi takatan súsaitjiana nuna takasarat tusarum túratarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tutai ijiarma Yusan aujsua amikiar, shiir wetarum tusar ni uwejé̱n Sáurun Pirnapíncha awantkarmiayi. Túrawar Antiukíanmaya̱ akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tura nuyaṉka Yusa Wakaní̱ akupkam Pirnapísha Sáurusha jíinkiar Serusia péprunam jeawarmiayi. Tura nuyá uunt kanunam eṉkemprar Chipri nuṉkanam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Juaṉsha yáiṉtaj tusa némarkauyayi. Nui̱ Saraminia péprunam jeawar Israer-shuar iruntai je̱a̱nam waya̱war Yus-Chichaman etseriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tura Chipri nuṉkanam pepru ainia nui̱ wái̱rkutak Papus péprunam jeawarmiayi. Nui̱ jeawar Israer-aents uwishin ni naari̱ Parjesúsan wáinkiarmiayi. Ni chíkich náariṉkia Erimiasauyayi. Niisha uwishniuitiat, Yúsnan étsereajai, tíniuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Akupin Serjiu Páuruja̱i̱ pujuyayi. Nu akupniusha ti péṉker enentáimniuyayi. Tura Pirnapín Sáuruncha chichaman akuptukmiayi, taarti tusa. Kame Yus-Chichaman antuktaj tusa wakerak untsukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tura uwishin Erimias nuna nakitiak “Auka péṉkerchaiti” tímiayi. Akupniusha Yúsan umirka̱i̱ṉ tusa nuna tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nuyaṉka Sauru, ni chíkich naari̱ Papru, Yusa Wakaní̱ pimiutkamu asa, nu uwishniun úmamkemas iis tímiayi ");
INSERT INTO jivNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ámeka wáitiaitme. Anaṉkartiniaitme. Yajauchiitme. Maaj, iwianchiitme. Tura ashí péṉker ana nuka imiá nakitniuitme. Tsej, ¿urukamtai Yusa jinti̱ naka ana nu emeskim weam? ");
INSERT INTO jivNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Paij, yamaikia Uunt Yus asutiámattawai. Yamaikia amesha ji̱i̱mi kusurmatai untsurí̱ tsawant tsáapnin peṉké íischattame” tímiayi. Tura nú chichamaik ji̱i̱ kusurmatai kirit íimiuk chikichan e̱a̱miayi eṉkeki jurukit tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nu túrunamtai akupin nuna wáinak, ti enentáimpramiayi. Túruna Uunt Yusa chichame̱n enentáimtur umikmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nuyá Juaṉ waketki Jerusaréṉnum wémiayi. Tura antsu Pápruka ni tsaniakmari̱ji̱a̱i̱ kanunam eṉkemprar Pápus péprunka ikiukiar Pirji péprunam jeawarmiayi. Nusha amaini Pampiria nuṉkanam pujawai. ");
INSERT INTO jivNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nuyá Pirji péprun naṉkaikiar Antiukía péprunam jeawarmiayi. Nú Antiukíasha Pisitia nuṉkanam pujawai. Nui̱ jeawar Israer-shuar ayampratin tsawantin, nuka sáwartin, Israer-shuar iruntai je̱a̱nam waya̱war pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tura nui̱ Yus-Papinium yaunchu áarman áujas aminkiamtai, Israer-shuar iruntai je̱a̱nam íirniuri̱ Páprun tiarmiayi “Yatsuru, jintíatin chicham takakkurmeka yamaik titiarum. Antukarmí” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tutai Papru wajaki uweje̱ takuimiayi. Tura chichaak “Israer-shuartiram, tura Yúsan umirkataj tusa wakerarmena nu antuktarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ii Yusri̱ ii yaunchu uuntri̱n Israer-shuartin achikmiayi. Tura niisha írara núnik Ejiptunam matsatainiai̱ Yuska nin páchiniak uunt awajsarmiayi. Yus ni kakarmari̱ji̱a̱i̱ nú nuṉkanmaya̱ ii yaunchu uuntri̱n uwemtikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Túrasha atsamu nuṉkanam ii uuntri̱n kuarenta (40) uwitin Yuska aya kátsuntramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tura nuya̱ṉka siati áentsun mátsatkainian, Kanaan nuṉkanam matsamarmia nuna amukarmiayi. Nú nuṉkan ii yaunchu úuntri̱n susataj tusa Yus túramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nuyaṉka ii uuntri̱ akupniuri̱n, juís tútain, anaikiamiayi. Tura chikichan ukunam anaiki anaiki wémiayi. Nuna tura túraakua kuatru siáṉtu seṉkuenta (450) uwí ejemiayi. Samuersha Yúsnan etserin náamtsái̱ṉ nuna túrimiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tura nuyaṉka áencha juísan nakitiainiak, uunt akupin náamkat tusar Yúsan seawarmiayi. Tuíniakui Yuska Sesa uchirí̱n Saúran anaikiamiayi. Nú Saúra úuntri̱ṉkia Piṉjamíṉkiauyayi. Tura Saúrsha kuarenta (40) uwí nú áentsun akupkat tusa Yus tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tura Saúr náamkan ataksha Yus awaiṉkimiayi. Tura nuyá iiksaṉ nú nuṉkanam uunt akupin atí tusa Tawitian anaikiamiayi. Tura Yuska ju̱na Tawitnian tímiayi “Isaí uchirí̱n Tawitian winia enentáir jeamtai achirmakjai. Tura Winia umirtin átatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wats, Tawit weeanmaya̱ Jesusaiti. Tura Yuska Israer-aentsun Uwemtikrartinian Jesusan anaitiukmiayi, yaunchu timiari̱n uminkiát tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesuska táatsa̱i̱ṉ Juaṉ ashí Israer-shuaran tunaari̱nia̱ enentáimtumar imiantinian ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tura Juaṉsha ni jákatniuri̱ jeatemamtai, chichaak “Átum enentáimtarmena núchaitjai. Wikia Yusa anaikiamuri̱, Kristu tutai, nákarmena núchaitjai. Antsu Niṉkia winia ukunmarui̱ winittiawai. Tura Niisha wíji̱a̱i̱ṉkia ti naṉkaamantu asamtai wikia sapatri̱ncha atitrataj tíchamniaitjai” tímiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Pai, yatsurtiram, Apraám weeatiram, tura ashí Yus ashamkarum umirkaitrumna nu, antuktarum. Ju̱ uwempratin chichamka íiniuiti, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iis, Jesusa túrunatniuri̱n Yuska yaunchu ni etserniuri̱n áamtikrachmakia. Tura ukunam Jerusaréṉnumia̱ shuar ni akupniuri̱ji̱a̱i̱ tuke sáwartin nuna áujeatskesha peṉké nekaacharmiayi. Tuma ásar Jesuska Yusa Uchiri̱nti tícharmiayi. Tura, jakatí, tiarmia nui̱, Jesusa túrunatniuri̱n, Yus yaunchu chichakmia nuna, tímiatrusaraṉ umikiarmiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesuska peṉké tunaamkachunak yamaikia mantamnatí tusar Piratun seawarmiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tura Yusa Papiri̱in ashí Jesusnan tímia nuna tímiannak umikiarmiayi. Tura nuyá krúsnumia̱ itiarar iwiarsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Túramunak Yus jakamunmaya̱n iniantkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesuska jakamunmaya̱ nantaki, yaunchu Kariréanmaya̱ Jerusaréṉnum Niiji̱a̱i̱ irutka wéarmia nuna núkap tsawantin pujus wantintiukmiayi. Nú shuaraiti yamaikia Jesusa túrunamuri̱n etserainia nu’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Iisha núnisrik shiir chichaman Yus yaunchu ii apachri̱n tiarmia nu étsereaji. ");
INSERT INTO jivNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Iisha Israer-weeá asakrin, Yuska Jesusan iniantkimia nuja̱i̱ ii apachri̱n anajmatramia nuna yamái uminkiaiti. Kame Sarmu Jímiar papinium ju̱ áarmaiti: “Ámeka winia Uchiruitme. Túmaitkiui yamaikia winia iwiaakmar susamuitme.” ");
INSERT INTO jivNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tura Yuska Jesusa nantakmiari̱n jintintiak, tura ni a̱ya̱shi̱ káurchatniun jintintiak, chíkich Sarmu papinium ju̱na áamtikramiayi: “Nekas péṉkeran Tawitian anajmatramaj nuna atumin amastatjai.” ");
INSERT INTO jivNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tura nú arant, nú paant atí tusa, chíkich Sarmu papinium ju̱ aarma awai: “Yusa, ame Uchiram aneamna nuna a̱ya̱shi̱ káurtincha tsankatkashtatme.” ");
INSERT INTO jivNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","‘Nekaatarum, yatsurtiram, Yuska Tawitia aya̱shi̱n tíchamiayi nuna. Tawitkia Yus tímian amuk jakamiayi. Túrasha ni aya̱shiṉkia káurmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tura antsu Yus iniantkimia nuna aya̱shiṉkia peṉké káurchamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tuma asamtai, yatsurtiram nekaatarum. Jesusja̱i̱ṉkete tunáa asakártin. ");
INSERT INTO jivNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tura Muisais yaunchu akupkamia nuja̱i̱ tunáa tsaṉkurnarchamnia nu, yamaikia Jesusja̱i̱ tsaṉkurnartiniaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Yúsnan etserin ju̱na áarmiayi: “Enentáimpratarum wishikkiartintiram. Ashamkatarum. Túrarum meṉkatumpratarum. Wi Yus asan, átum pujarmena nui̱, aents túrachminian túratajna nusha peṉkesh nekaashtatrume, chíkich ujatmainiakuisha.” Tu áarmaiti. Tuma asamtai yatsurtiram, aneartarum atumin nuna túrutmawa̱i̱rum, Yusnan etserin aarma tana nútiksaṉ.” Nuna chichaak amukmiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tura nuyá Papru Pirnapíji̱a̱i̱ jiinki wéenakui aents chichainiak “Chíkich sáwartincha jútiksarmek etserkatarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tura nuyá iruntsua tseṉkeenak Israer-shuarsha, tura chíkichkia Israer ajasarusha, Yúsan umirkatajtsa wakeriarmia nuka, Páprun Pirnapíncha nemarsarmiayi. Niisha nu áentsun chicharuk “Yusa aneṉkrattairi̱ enentáimtusrum kaka̱rtarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tura chíkich sáwartinkia nu péprunmaya̱ ti untsurí̱ aents Yus-Chicham antuktai tusar tu̱akarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tura Israer-shuarka ti untsurí̱ áentsun tu̱akarun wáinkiar, suir iiniak, ti kajerkarmiayi. Tuma asamtai Páprun katsekkar “Ju̱ chichaana ju̱ka ántar tawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Támaitiat Pápruka Pirnapíji̱a̱i̱ arantutsuk chichainiak tiarmiayi “Israer-aentstirmin, atumin emka Yus-Chicham ujaktiniuji. Túrasha átum támaitiatrum nakitramarme. Tura atumsha nakitia asarum, Yúsnum tuke iwiaaku pujuschamnia ajasurme, tímiayi. Tuma asamtai iikia yamaikia Israer-aencha ujaktai tusar weraji, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nu túratarum tusa, Uunt Yus akuptamtsujik. Jes, ni Papiri̱i̱n ju̱na tawai: “Israer-shuarcha Winia nekarawarat tusan anaitiukjame. Tura ashí nuṉkanmaya̱ aents uwemprarat tusan akuptajme.” Tu áarmaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nú chichaman antukar Israer-shuarcha ti wararsar “Uunt Yus tana nuka imiá péṉkeraiti” tiarmiayi. Tura, tuke iwiaaku pujusmin armia nu Yus-shuar ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tú tumaki̱ Yus-Chicham nú nuṉkanam ashí jamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Túrasha nuwa̱n, Yúsan péṉker enentáimtuinian tura péṉker wekainian, Israer-shuarka yajauch enentáimtikrarmiayi. Áishmaṉ peṉkeri̱ ármia nunasha, yajauch enentáimtikrarmiayi. Túram Páprun Pirnapíncha katsekkar, chichaman irunturar najatawarmiayi. Tú-turukiar ni nuṉke̱ya̱ ji̱i̱ki awemarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Túram Papru Pirnapíji̱a̱i̱, ju̱ aentska yajauchiiti tusar, wéenak nawe̱yan nuṉkan akakekiar ikiukiarmiayi. Túrawar Ikiuniu péprunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yusa Wakaní̱sha pimiútkamu ásar Yus-shuarka ti warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikiuniu péprunam Papru Pirnapíji̱a̱i̱ jeawar Israer-shuar iruntai je̱a̱nam waya̱warmiayi. Túrunawar Yus-Chichaman etserkarmiayi. Túram ti untsurí̱ Israer-shuar ármia nu, Israer-shuarcha ármia nusha Yúsan umirkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tura chíkich Israer-shuar, Yúsan umirkacharu ármia nu, Yus-shuaran kajerkarat tusar Israer-shuarchan yajauch enentáimtikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tuma asamtai Papru Pirnapíji̱a̱i̱ nú núṉkanam ti nukap tsawant pujusarmiayi. Tura Uunt Yúsan enentáimtuinia ásar, arantutsuk Yusa waitneṉkratairi̱n etserkarmiayi. Tura, etserinia nu winia kakarmarja̱i̱nti tusa, Yuska aents túrachminian najanmamtikiawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tura Ikiuniunmaya̱ aentska jímiar kanakarmiayi. Chíkichkia Israer-shuar tuinia nu nekasaiti, tiarmiayi tura chíkichkia Jesusa akatramuri̱ tuinia nu nekasaiti, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tura nuyá Israer-shuarchaja̱i̱ Israer-shuarka chichasar pepru uuntri̱ji̱a̱i̱ chichasarmiayi. Tura Papru Pirnapíji̱a̱i̱ katsekkar tura kayaja̱i̱ tukurar, yajauch awajsatniun naṉkamawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Túrasha Papru Pirnapíji̱a̱i̱ nuna anturmamkar, Ristra péprunam wearmiayi. Nuya̱sha Tirpi péprunam wearmiayi. Nu péprusha mai Rikiaunia nuṉkanam pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tura Yus-Chichaman etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ristra péprunam tunamaru áishmaṉ pujumiayi. Ni akiiniamuri̱ya̱ tuke wekaichauyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nú áishmaṉ Papru chichaamun antúu pujumiayi. Túman Papru úmamkemas nin íismiayi. Niisha, Yusa kakarmari̱ji̱a̱i̱ tsuamartatjai, tu enentáimiun Papru nekaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tura Pápruka kakantar chicharuk “Wajakim wewe ajasam wajasta” tímiayi. Tutai áishmaṉ wiut kutsua̱r wajaki wekaimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Papru túramia nuna aents wáinkiar Rikiaunia chichamja̱i̱ untsumainiak “Yuska áishmaṉka áanin ajasaru in tarutramarji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pirnapínkia, Júpitir náartin yúsaiti, tiarmiayi. Tura Páprunka, Mirkiuriu náartin yúsaiti, tiarmiayi. Pápruka chichau asamtai tu anaikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nú pepru jeamunam Júpitir náartin yusa je̱e̱n pujumiayi. Tura Júpitir náartin yusa pátriri̱ kukuji̱n iwiarkamun, wáakaja̱i̱ itiamiayi. Tura niisha ni áentsri̱ji̱a̱i̱ wáakan maatai tusar pujuarmiayi. Tura tikishmatrar ajamsatai, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tura Jesusa akatramuri̱ Pirnapísha Páprusha nuna nekaawar, auka nakitiaji tusar, ni pushiri̱n ja̱a̱rarmiayi. Túrawar aents írunmanum pachiniawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tura tiarmiayi “Shuara, ¿urukamtai áitkiarum? Iisha yúschaitji. Atumea áankiitji, tiarmiayi. Peṉké ántrarum túrarmena nu ikiukrum, nekas Yus nemarsatarum tusar iisha taji. Nekas Yuska nayaimpincha, nuṉkancha, nayaantsancha, tura ashí nui̱ írunna nunasha najanaiti, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jes, aents ni enentáimmiari̱ji̱a̱i̱ṉ wekasarat tusa Yuska yaunchu tsaṉkatkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tuma aiṉ shuaran péṉker awajsamuja̱i̱ Wiitjai Nekas Yus tusa paant awajmamsamiayi. Kame yumi yutuktinian nayaimpinmaya̱ akupturmaji. Tura ejemarar warasarmí tusa yurumak nerektinniasha súramji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Túrasha Pápruka tímianu támaitiat, nuna anturtsuk wáakan maawar nin tikishmatrar ajamsataitsa wakeriarma nuna suritkiachminiak suritkiarmiayi nu áentsun. ");
INSERT INTO jivNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tura nuyá Antiukíanmaya̱ Ikiuniunmaya̱sha Israer-shuar táarmiayi. Taar nuyá áentsun Páprun yajauch awajsatniun enentáimtikrarmiayi. Tú tutai Páprun kayaja̱i̱ tukurarmiayi. Tura jakayi tiar péprunmaya̱ japiki júkiar arant áepsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Túrasha Yus-shuar Páprun tariar téntakarmiayi. Túram nuiṉkia Papru wajaki wé ataksha péprunam waya̱miayi. Tura kashin tsawa̱rar Papru Pirnapíji̱a̱i̱ Tirpi péprunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tírpinium pujusar uwempratin chichaman etserkarmatai untsurí shuar Yúsan umirkarmiayi. Nú shuaran Yus-Chichaman jintintia amuukar Rístranam, Ikiuniunam, Antiukíanmasha waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Waketainiak “ashí Yus tana nu tímiatrusrumek tuke umirkatarum” tuíniak Yus-shuaran ikiakárarmiayi. Tura nin tiarmiayi, “Yusa akupeamuri̱i̱n pachiinkiataj tákurkia ti wáitsatniuitji.” ");
INSERT INTO jivNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tura Yus-shuar írunmanum Yus-shuaran wáinniun anaikiarmiayi. Yurumtsuk Yúsan áujsar chicharainiak, “umirkarumna nú Yus iirmasarti” tiar ikiukiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nuyá Pisitia nuṉkanam naṉkaamakiar Pampiria nuṉkanam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nui̱ jeawar Pirji péprunam Yus-Chichaman etserkar nuyá Ataria péprunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nu̱i̱ kanunam eṉkemprar, yaunchu jíinkiarmia nú Antiukía péprunam waketkiarmiayi. Páprusha Pirnapísha tuke jíintsa̱i̱ṉ nú Antiukíanmaya̱ Yus-shuar chichainiak, Yusa takatri̱ túrattarmena nuna Yus waitnentramak yáinmakarti, tiar akupkarmiayi nuikⁱ. ");
INSERT INTO jivNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nú Antiukíanam jeawar, Yus-shuaran irurar, ashí Yus nin yáiṉkiarmia nuna ujakarmiayi. Tura nútiksaṉ Israer-shuarchan Uunt Yus uwemtikrataj tusa untsukmia nunasha ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tura nuyá Yus-shuarja̱i̱ Papru Pirnapíji̱a̱i̱ núkap tsawant pujusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nu tsawantin áishmaṉ Israer nuṉkanmaya̱ wear, Antiukíanam jeawar Yus-shuaran jintintiainiak “Muisais tímia nútiksarmek tsupirnaktin ana nu túrachkurmeka uwemprashtatrume” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tuma asamtai Papru Pirnapíji̱a̱i̱, núchaiti tusar, nú áishmaṉja̱i̱ ti kakaram chicharnaikiarmiayi. Túrasha nuu enentáiniak enentáimsatniun tujinkiarmiayi. Tuma asamtai Antiukíanmaya̱ Yus-shuar Páprun Pirnapíncha, atumsha chíkich áentsja̱i̱ Jerusaréṉnum wétarum tusar akupkarmiayi. “Tura nui̱ Jesusa akatramuri̱sha Yus-shuaran wáinniusha iniasrum itiurmainkit tusarum péṉker nekaatarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Papru Pirnapísha akupkamu ásar wéenak Pinisia nuṉkanam, Samaria nuṉkanmasha naṉkaamainiak Israer-shuarcha Yus-shuar ajasman Yus-shuaran ujakarmiayi. Tura Yus-shuarsha nuna antukar ti warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tura Páprusha Pirnapísha Jerusaréṉnum jeawarmatai Jesusa akatramuri̱sha Yus-shuara wáinniuri̱sha tura peṉké Yus-shuarsha itiawarmiayi. Tura niisha túrunamia nuna mash etserkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Túrasha Pariséu aencha, Yus-shuar ajasarmiania nu, wajakiar chichainiak “Muisais tsupirnaktinian akupkamia nuna tura nú arant ashí Muisais tímia nunasha Israer-shuarchasha umirkatin áiniawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nuya̱sha Jesusa akatramuri̱sha Yus-shuaran wáinniusha nu chichaman nekaatai tusar iruntrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chichasua umikiarmatai Pítiur wajaki tímiayi, “Yatsurtiram, Yus nuik winia chichartak “Israer-shuarchasha winia chichamprun antukar umikiarat ujakarta” tu anaitiukmia nu nékarme. ");
INSERT INTO jivNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tura Yus Niṉki ashí aentsu enentái̱n neka asa, Wíi shuar ajasmin áiniawai tusa, ni Wakani̱n Israer-shuarchancha susamiayi, in suramsamiaj nútiksaṉ. ");
INSERT INTO jivNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yus incha aushatka awajtamsachmaji, tímiayi. Antsu métekraketji. Tuma asamtai niisha Yúsan enentáimtuiniakui, Yuska enentái̱ya̱n ni tunaari̱n japirarmai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","11","Tura iikia nékaji niiya áantsarik Jesukrístu waitnenkartutairi̱ji̱a̱i̱ uwempraitji. Nuiṉkia ¿urukamtia Yus uwempraru áiniawai tai̱sha, átum Muisais yaunchu akupkamia nu umikiarat tusarum wakerarum? Nu túrakrumka Yus túrana nu jeatsui tarume. Tura nuka kaarka áintsaṉchakait. Warí, ii úuntri̱sha tura iisha ashí Muisais tímia nu umiktin tujinkiamji. Tuma asamtai, ¿urukamtai nú káarkasha Israer-shuarchasha áentskatin wakerarum?” tímiayi Pítiur. ");
INSERT INTO jivNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pítiur nuna tutai Pirnapísha Páprusha chichainiak, “Israer-shuarchasha ni kakarmari̱n nekaawarat tusa aentsti túrachminian túratniun Yuska ti yáinmakmaji” tú ujuam mitiat wáinkiar antúu pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nuna ujasua amikmatai, Jakupusha tímiayi “Yatsurú, antuktarum. ");
INSERT INTO jivNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nuik túrachman Yus túramia nuna ii yachi Semuṉ Pítiur ujatmakji. Jú̱iti: Yuska Israer-shuarcha waitnentak Winia ajasarat tusa chikishtarchiniak achikiuiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ju̱sha Yúsnan etserin yaunchu áarmia nu tímiatrusaṉ túrunayi. Jú̱iti aarma: ");
INSERT INTO jivNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Israer-aents meserar, je̱a̱ sáanakniua áintsaṉ áiniawai. Tura ukunam ataksha tana, Tawitia je̱e̱n sáanaki ana nuna, ataksha najanattajai. Juakai nuna achikian ataksha awajrattajai. ");
INSERT INTO jivNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ashí nuṉkanmaya̱ aents, Israer-shuarcha ainia nu, winia náarun pachinia nu, Winia e̱a̱tkarat tusan túrattajai. ");
INSERT INTO jivNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Uunt Yus nuna yaunchu ujakmiayi.” Tu áarmaiti’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Tuma asamtai, yatsurtiram, wi tájarme: Israer-shuarcha Yus-shuar ajasaru áiniana nu, imiatik awajsachmi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Iimiatarum, ashí péprunam Israer-shuar iruntainiam yáunchuya̱n tuke sáwartin Muisaisa áarmari̱n jintintiainiatsuk. Tuma asamtai, áyatik áatratai ju̱ “Ántar-yus susamu ana nu iniaisatarum. Ántar-yusan susamu asamtai yajauchiiti. Tura tsanirmawairap. Tura kajemtikramua nu yuawairap. Tura numpasha umarairap.” Tu áatratai’ tímiayi Jakupu. ");
INSERT INTO jivNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nuyá Jesusa akatramuri̱sha Yus-shuaran wáinniusha nuyá ashí Yus-shuaraim enentáimsarmiayi. “Papru Pirnapíji̱a̱i̱ wéakui, shuar niiji̱a̱i̱ nenakar Antiukíanam akupkatai” tiarmiayi. Tuma ásar Jútas Parsapasan, Sérasnasha anaikiarmiayi. Niisha mai uunt Yus-shuar ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tura niiji̱a̱i̱ ju̱ papin áarman akupkarmiayi: “Iisha Jesusa akatramuri̱ tura Yus-shuara wainniuri̱ tura ashí Yus-shuaraitjinia nu, atumin Israer-shuarcha árumna nu, Antiukíanam, Sírianam, tura Sirisianmasha, ju̱ papí akupeaji. ");
INSERT INTO jivNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Juyá aents ii chichame̱ja̱i̱nchu atumi̱i̱n jeartamarai. Túrawar, tsupirnaktin ana nu, tura ashí Muisais akupkamia nu túratarum, turammiarme. Nunasha ni chichame̱ja̱i̱ṉ turamarmayi. Nu chicham atumsha antukrum nushá enentáimprarum “entá nuya̱ṉka itiurkatjik” tárume. ");
INSERT INTO jivNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tuma asamtai nu nekaar, iisha métekrak enentáimsar, jimiará áishmaṉ akupkatin anaikiamji. Ju̱ áishmaṉ ii aneamu yachi̱ Pápruja̱i̱ Pirnapíji̱a̱i̱sha atumin íirmasarat tusar akupeaji. ");
INSERT INTO jivNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Papru tura Pirnapísha ii Uuntri̱ Jesukrístunam surumakarmiayi, ni takatri̱sha tsuumai aiṉ túrami tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Niiji̱a̱i̱ Jútassha tura Sérassha akupeaji. Ii chichaajnia nuna niisha ni wene̱ja̱i̱ atumin ujatmakartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Kame túratin asamtai iisha Yusa Wakaní̱ji̱a̱i̱ ju̱ áartin enentáimsaji. Namaṉ ántar-yus susamu ana nu yuawairap. Tura numpasha umarairap. Kajemtikramu ana nusha yuawairap. Tura peṉké tsanirmawairap. Nuya̱sha chíkichkia nú naṉkaamas tíchattaji. Tura antsu nu iniaisarmeka, péṉker átatrume. Ayu, Yus wáitmakarti.” Tu áarman akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tura Antiukíanam akupkam wearmiayi. Nu̱i̱ jeawar Yus-shuaran irurar, papin súsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tura Antiukíanmaya̱ Yus-shuarsha nu papin áujsar, péṉker jintíamu chichaman áarman wáinkiar, ti shiir enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tura Jútassha, Sérassha, ímia niisha Yus-Chichaman etserin ásar, Yus-Chichaman núkap jintintiawar, Yus-shuaran ikiakárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tura nui̱ ishichik tsawant pujusarmatai, Yus-shuarka, péṉker waketkitiarum, tiar akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tura Séras juáktinian wakerukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Páprusha Pirnapíji̱a̱i̱ juakarmiayi Antiukíanam. Niisha chíkich aentsja̱i̱ Yus-Chichaman étseruk pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nuyá ukunam Papru tímiayi Pirnapín “Ashí péprunam iisha Yus-Chicham etserkamaj nui̱ Yusa̱i̱ ii yachi̱ ainia nusha urukák pujuinia iyutai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pirnapíkia Juaṉ Márkusan iiji̱a̱i̱ winiti tusa wakerimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tura Pampiria nuṉkanam Juaṉ Márkussha niisháa weu asamtai tura Yusa takatri̱n iniaisa asamtai, Pápruka aya̱tniun nakitramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Papru Pirnapíji̱a̱i̱ ti kakannairar kanakarmiayi. Tura Pirnapíkia Márkusan aya̱ki Chípriniam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pápruka Sérasan aya̱ki wéakui Yús-shuar Yus yáinmakarti tinia akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tura Siria nuṉkanmaani wekaráktak, Yus-shuaran ikiakárkutak Sirisianam jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Papru Sérasja̱i̱ Tirpi pepru íirkutak Ristra péprunam jeawarmiayi. Tura nui̱ Rístranam Yus-shuaran wáinkiarmiayi, ni naari̱ Timiutéu. Ni nukurí̱ṉkia Israer-shuar Yus-shuarauyayi. Tura ni aparí̱ṉkia Kriaku áentsuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tura Ristra péprunmaya̱ Ikiuniu péprunmayasha Yus-shuar ármia nu, Timiutéu péṉker wekaawai, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Kame Pápruka Timiutéun uyuuntusat tusa wakera asa, Timiutéu apari̱ Kriaku-apachin nekaawarmatai Israer-shuar nui̱ pujuarmia nu yajauch enentáimprara̱i̱ṉ tusa tsupirmamtikiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tura nuyá Papru Timiutéuja̱i̱ ashí péprunam nui̱ sétur nui̱ sétur wéenak Jesusa akatramuri̱sha Yus-shuaran wáinniusha Jerusaréṉnum nuik jintintian umiktarum tusa ujarkutak wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tu ujamu ásar Yus-shuar nú arant Yúsan enentáimturar kakararmiayi. Tura ashí tsawant kaweṉki wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tura Yusa Wakaní̱kia Páprun Yus-Chichaman Asia nuṉkanam ujaktinian tsaṉkatkachmiayi. Tuma asamtai Pirijia nuṉkanam tura Karasea nuṉkanam ai̱rkutak, ");
INSERT INTO jivNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia nuṉka jeatniunam jeawarmiayi. Túrunawar “Pitinia nuṉkanam wetai” tiarmiayi. Túrasha Yusa Wakaní̱ nui̱sha wétinian suritkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tuma asamtai Misia nuṉkanam menantki Truas péprunam pachiniawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nui̱ jeawar Papru kashi iimiarmiayi. Masetúnia nuṉkanmaya̱ áishmaṉkan wajan wáinmiayi. Nu áishmaṉ Páprun chicharuk “Winitritia. Yáiṉtkiamnium” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nuya̱ṉka tu iimiarmatai, wisha Pápruja̱i̱ wetai tusar iwiarnarmiaji. Tura Yus incha nú nuṉkanam ni chichame̱ etserkat tusa ti nekas untsurmakrin wéaji, tímiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tura nuyaṉka kanunam eṉkemprar Truas péprunmaya̱ jíinkir Samutrásia nuṉkanam jeamiaji. Tura kashin tsawa̱r nuya̱ṉka kati̱arar Niápuris péprunam jeamiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tura Niápurisnumia̱ náwek Jiripiusnum jeamiaji. Nui̱ Jiripius péprunmanka Rúmanmaya̱ aents matsamsa ármiayi. Tura nú péprusha Masetúnia nuṉkanam nekas uunt pepruyayi. Tura nui̱sha seturmaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nuyá sáwartin tsawa̱rmatai pepru ikiukir entsá supichik wémiaji. Yus áujsatniun iruntrarmia nui̱ pujusar, nuwa̱ iruntrarmia nu Yus-Chicham ujakarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nui̱ Tiatira péprunmaya̱ nuwa̱, ni naari̱ Ritia wáinkiamiaji. Niisha tarach yamakain péṉkeran súriniuyayi. Yúsnasha shiir awajniuyayi. Yus-Chichaman Papru etserkamia nuna niisha péṉker anturkamiayi. Túman, Uunt Yus Papru chichaamun umirkat tusa ni enentái̱n takasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Túruna nú nuwa̱ níiniuri̱ji̱a̱i̱ imianmiayi. Tura nuya̱sha chichaak “Yus-shuar nekas ajasai túrutkurmeka winia je̱a̱rui̱ winitiarum” tímiayi. Tura nui̱ jeawakrin setumtikrampramiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tura nuyá ukunam Yus aujsatai tusar wekaamar nuwa̱ch nekaamin-iwianch eṉkemtuamu iṉkiunmakmiaji. Nu nuwa̱chikia misatkauyayi. Niisha nékamkui nérenniuri̱sha ti kuitriniawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tura nú nuwa̱ch incha Pápruncha pataaturmamiaji. Tura kakantar untsumuk “Ju̱ áishmaṉsha nekas Uunt Yúsan umirkaru áiniawai. Tuma asa niisha atumin uwempratin chichaman ujatmarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tura nú nuwa̱chisha ti núkap tsawant tu wekaimiayi. Titmakui, Papru ayanmar iwianchin chicharuk “Jesukristu naari̱ji̱a̱i̱ tájame: jíinkitiá ni enentái̱ya̱” tímiayi. Tutai íwianchkia nú chichamaik jiinkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tura nuwa̱chi nérenniuri̱sha, íwianch ji̱i̱ki awematniun nekaawar, Páprun Sérasnasha kajerak achikiar pepru uuntri̱ íisarat tusar ajapén júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tura pepru úuntri̱i̱n ejeniar tiarmiayi “Ju̱ áishmaṉ Israer-shuar áiniawai. Tura in páchim enentáimtikramainiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tura iisha Rúmanmaya̱ aents árin, ii túrachminian, iikia asumprachman jintintramainiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tura nuya̱ṉka ashí aents Páprun Sérasnasha kajerkarmiayi. Túramtai pepru uuntri̱ chichainiak “Pushiri̱ áitkiarum numiji̱a̱i̱ asutiátarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tura nuyá ti asutsua amikiar sepunam eṉkeawarmiayi. Tura sepú-iinian chicharuk “Ti péṉker iistá pisarara̱i̱ṉ” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nu chichaman antuk, sepú-iin ti init awayámiayi, tura nawe̱n numi najanamuja̱i̱ tee chanuntamiayi. Tú tura ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tura kashi ajapéṉ Papru Sérasja̱i̱ Yusan áujainiak kantampriarmiayi. Tura chíkich eṉkeamusha nuna antúu pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tu pujuinia̱i̱ aya aneachma ti kakantar u̱u̱rkamiayi. Tura sepusha muchitramiayi. Túrunamtai sepú wáitiri̱sha ashí urantrarmiayi. Tura aents jiruja̱i̱ eṉkekar jiṉkiamusha mash atiniakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Túrunamtai sepú-iin shintiarmiayi. Tura wáitisha mash uranar aan wáiniak, eṉkeamusha jiiniar shiákchariash tusa ni puniariniak ukuiniak máamattsa pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tura Papru untsuak “Amek yajauch awajmamsaip. Ashí pujuiniaji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tutai sepú-iincha jinia ekeemak tsékeṉki waya̱miayi. Tura Papru Sérasja̱i̱ pujamunam kuraṉki jearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tura a̱a̱ ji̱i̱ki aniasmiayi “Uunta, ¿warí itiurkattaj uwemprataj tusana?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tutai niisha tiarmiayi “Uunt Jesukrístu nekas enentáimtustá. Túrakmeka amesha, tura áminiurmesha uwemprattarme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tura nuyá ashí ni je̱e̱n pujuarmia nunasha Yus-Chichaman ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tura tsawant iraṉka̱i̱ sepú-iincha Páprun Sérasja̱i̱ numpamnamuri̱n nijiararmiayi. Túramtai nuya̱sha sepú-iincha nua̱ri̱ji̱a̱i̱ uchiri̱ji̱a̱i̱ imianiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Túramtai nuya̱sha ni je̱e̱n júkiarmiayi. Tura nui̱sha ayurawarmiayi. Tura sepú-iincha niiniuri̱ji̱a̱i̱ Yus-shuar ajasu ásar ti shiir warasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kashin tsawa̱r pepru uuntri̱, Páprun Sérasja̱i̱ akupkata tusar suntaran sepú-iinian akuptukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tura nuya̱ṉka sepú-iin Páprun tímiayi “Yamaikia pepru uuntri̱ chichaman akupturmakai, átum wétinian. Tuma asamtai yamaikia péṉkerak jíinkitiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Túrasha Papru suntaran chicharuk tímiayi “Warí, iisha Ruma aents áriniṉ, niisha chichaman iwiartsuk ashí shuar íimiainiai̱ṉ asutiámamji. Túrawar sepunam eṉketmamji. Tura ¿urukamtai yamaikia u̱u̱k akuptamkataj tusa wakeruinia? Atsá. Antsu uuntcha niṉki taar ji̱i̱rmaktiai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tutai suntarsha waketkiar nuna ujakarmiayi pepru úuntri̱n. Tutai niisha ti ashamkarmiayi Ruma aentsun nekaawar. ");
INSERT INTO jivNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Túmak ashamainiak Páprun Sérasan weriarmiayi tsaṉkurturtarum titiai tusar. Nuya̱sha sepunmaya̱ jí̱i̱kiar “Yamaikia wáitneasrum wetarum” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Papru Sérasja̱i̱ nuyá jíinkiar Ritia je̱e̱n wearmiayi. Tura Yus-shuaran ikiakárar ikiukiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Papru Sérassha wéenak Ampipuris péprunam Apurunia péprunmasha naṉkaamakutak Tisarúnikia péprunam jeawarmiayi. Nui̱ Israer-shuara iruntai je̱e̱ ámiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tura Pápruka nuna tuke túrin asa nu je̱a̱nam wémiayi. Tura nui̱sha menaintiu sáwartin Yus-Chichaman paant etsermiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tura Páprusha Yus-Chicham tana tímiatrusaṉ jintintiarmiayi. Tura Krístusha wáitias jákatniuyi, tura nuya̱sha jakayat nantaktiniuyi, tímiayi. Tura nuya̱sha chicharuk “Wi Jesusnan atumin ujaajrumna nusha Yusa anaikiamuri̱n Kristu tútain tájarme” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nuna takui Israer-aents chikishtarchik umikiarmiayi. Túrawar Papruja̱i̱ Sérasja̱i̱sha tsaniṉkiarmiayi. Tura Kriaku aencha ti untsurí̱ Yúsan umirkarmiayi. Tura nuwa̱ peṉkeri̱ armia nusha nútiksaraṉ umikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tura Israer-shuarka Yus-shuar ajascharmia nu, Páprun Sérasnasha suiir íisarmiayi. Túrawar chíkich yajauch áishmaṉ naki yujáu armia nuja̱i̱ chichasar nu peprunam charáa charáa ajarmiayi. Tura Páprun Sérasnasha achikiar aentsu úuntri̱n suruktai tusar Jasuṉka je̱e̱n árenkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Túrasha Páprun Sérasnasha awetrar, Jasuṉkan tura chíkich Yus-shuarnasha achikiar japirkutak júkiarmiayi. Tura pepru úuntri̱i̱n juíniak tiarmiayi “Ju̱ áishmaṉsha ashí nuṉkanam charaatum ajá wekarmia nu yamaikia tímiajai̱ tarutramarji. ");
INSERT INTO jivNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Tura ju̱ Jasuṉ ni je̱e̱n itiaarmiayi. Tura niisha ashí mash Rúmanmaya̱ uunt akupniu chichame̱n nakitiainiawai, tiarmiayi. Tura jes, chíkich akupin awai, tuiniawai. Niisha Jesusaiti, turamainiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu chichaman antukar, aents nui̱ pujuarmia nu, úuntri̱miak charaatum ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tura Jasuṉ chíkich Yus-shuarja̱i̱ Papru nekas awemattaji tusar, paij, kuit ikiuaji, tiarmiayi. Nuna takui pepru uuntri̱ nin akupkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nuiṉkia nú kashi Yus-shuar Páprun Sérasnasha Pirí̱a péprunam akupkarmiayi. Tura nui̱ jeawar Israer-shuar iruntai je̱a̱nam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Piríanmaya̱ aentska Tisarúnikianmaya̱ áentsja̱i̱ṉkia naṉkaamas péṉker enentáimkia ármiayi. Tuke enentáiji̱a̱i̱ Yus-Chichaman ántiarmiayi. Túrawar tuke tsawant imia niṉkisha Papru tana nuna nekasashit tusar Yusa papiri̱n ii wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tuma ásar untsurí̱ shuar Yus-shuar ajasarmiayi. Tura Kriaku aents nuwa̱ peṉkeri̱ armia nusha áishmaṉsha umikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Túrasha Tisarúnikianmaya̱ Israer-shuarka Papru Yus-Chichaman Piría péprunam étserun antukar nui̱ weriar charaatum awajiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Túmainiakui Yus-shuar Páprun árutsuk nayaantsanam akupkarmiayi. Tura Séraska Timiutéuja̱i̱ nuiṉ Piríanam juakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tura Páprun nemariarmia nu Atenas péprunam nin ejeyarmiayi. Tura niisha waketainiakui, Papru chichaman akatar akupkamiayi, Sérassha Timiutéusha wárik winiartí tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Tura Papru Atenas péprunam pujus Sérasnasha Timiutéuncha nákamiayi. Nu̱i̱ nú péprunam ántar-yus ti írunkui Páprusha kúntuts enentáimmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tuma asa Israer-shuar iruntai je̱a̱nam Israer-shuarja̱i̱ tura chíkich aents Yúsan enentáimtiarmia nuja̱i̱ chichasmiayi. Tura tuke tsawant pepru ajapén aentsja̱i̱ iṉkiunaikiar chichasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nuyá chichaman jintin chíkich naari̱, ipikiuriu, armia nu, tura chikichcha, ni naari̱, estuikiu, armia nusha Páprun áujmatsarmiayi. Chikichcha tiarmiayi “Imiá chichamtincha ju̱sha waritramtajik.” Tura chikichcha tiarmiayi “Yajaya̱ yusnan etserniuchuashit.” Páprusha Jesusa túrunamuri̱n tura aents jakamunmaya̱ nantaktinian étserkui nuna tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nuyaṉka aents iruntainiam, naari̱ Ariupaku támanum Páprun júkiarmiayi. Nui̱sha tuke irunin ármiayi. Nui̱ Páprun aniasarmiayi “Iisha ame yamaram támena nu nekaatai tusar wakeraji, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Amesha nusháa chicham jintiniaitme. Túmaitkiui ju̱ chichamsha warintiuak tusar nekaatai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atenasnumia̱ aencha tura chíkich nuṉkanmaya̱ shuar nui̱ pujuarmia nusha aya yamaram chicham amia nunak ántiarmiayi. Tura aya nunak áujmatiarmiayi.) ");
INSERT INTO jivNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nuya̱ṉka Papru Ariupakunam ajapén wajaki tímiayi “Atenasnumia̱ áishmaṉtiram, wi nékajai, atumsha atumi yusri̱ ainia nuyá tsurakchamniaitrume, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kame wi nuik atumí yusri̱ enentáimtutainiam íistaj tukaman nui̱ je̱a̱chin iwiaramun, JU̱ NEKAACHMA YUSNAITI, tu áarman wáinkiamjai. Wátsek, ju̱ Yus átum nékachiatrum tikishmatrumna nuna ujaktajrume’ tímiai. ");
INSERT INTO jivNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Nekaatarum, nu Uunt Yuska ashí nuṉkan tura nui̱ írunna nuna najanaiti. Tura Niisha nayaimpin nuṉkancha nérenniurinti. Tura aents najanamu je̱a̱nam nú Yuska pujuchuiti. ");
INSERT INTO jivNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Niisha aents yáinkiat tusa atsumatsui. Warí, imia-niṉki Niisha ii iwiaakmari̱n, ii maya̱ttairi̱ncha tura ashí írunna nunasha súramtsujik, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nekaatarum. Nuu numpanmaya̱nak ashí áentsun najanamiayi ashí nuṉkanam matsamsarat tusa. Tura Yuska ii tsawantri̱n nekapmaiti; ii pujustinniasha nútiksaṉ nakakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Winia e̱átkar wáitkiarat tusa Yus nuna túrayi. Túrasha Yus jeashtaka pujurtamtsuji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jes, iisha Yusja̱i̱ iwiaakji. Yusja̱i̱ muchitiaji. Tura Yusja̱i̱ ii kakarmari̱ takakji. Nútiksaṉ atumí papí-aintri̱ tíchamka “Ashí incha Yus najatmaitji.” ");
INSERT INTO jivNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tura iisha Yus najatma asakrin kuri najanamusha, yúsaiti, tu enentáimsashtiniaitji, tímiayi. Tura kuit-yussha, kaya-yussha aents enentáimsar najanamuka, yúsaiti tu enentáimsashtiniaitji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aents Yúsan nékainiachuk túrawarmiania nuna Yuska yáunchuka pachischamiayi. Túrasha yamaikia Yus ashí aentsun chicharuk “Tunaaruminia̱ enentáimpratarum” túramji, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yuska áishmaṉkan anaikiaiti. Nú áishmaṉ ashí aentsti, yáki péṉkeran túriniait, yáki yajauchin túriniait núnaka nekarmattaji. Nú áishmaṉ Yus akupkamun tuke enentáimtakui Yus nin anaikiaiti. Tura tsawant nú túrunatin átatna nuna Yus Niṉki achikiuiti. Túrasha nekas anaikiajai tusa, tura ashí áentstiram nekaatarum tusa nú áishmaṉkan jakamunmaya̱ iniantkimiayi” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tura nuna jakamunmaya̱ nantaktinian áujmatun antukar chikichcha wishikiarmiayi. Tura chíkich “Yamaikia máakete. Antsu chíkich tsawantin antukmí” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tutai Papru iniaisamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tura chíkich aentska Papru táman umikiar nin nemarsarmiayi. Nui̱sha Tiuníseu páchitkiauyayi. Niisha Ariupaku áentsuyayi. Tura nuya̱sha nuwa̱, ni naari̱ Támaris, tura chíkich aencha nútiksaraṉ nemariarmiayi Páprun. ");
INSERT INTO jivNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nuyaṉka Papru Atenas péprun ikiuki Kurintiu péprunam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tura nui̱ Israer-shuaran ni naari̱ Akiran wáinkiamiayi. Akiraka Puntu nuṉkanam akiiniauyayi. Tura ukunam Itiaria nuṉkanam puja̱i̱ uunt akupin Krautiu ashí Israer-shuaran Ruma péprunmaya̱ awemarmiayi. Rúmaka Itiaria nuṉkanmaiti. Nui̱ awemamu ásar Akira Kurintiunam nuik támiayi nuwe̱ Pirisíraja̱i̱. Tura Pápruka Akiran chichastaj tusa werimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akirasha Páprusha mai ju̱na takau ármiayi, tarach ti núparman je̱a̱ najantain najanin ármiayi. Tuma asamtai Papru Akirai̱ seturmiayi nu takat túrawartai tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tura tuke sáwartin Papru Israer-shuar iruntai je̱a̱n wéuyayi. Nui̱sha Israer-aentsun Kriaku-aentsnasha nútiksaraṉ Yus-Chichaman ujakar enentáimtikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tura nuyá Séras Timiutéuja̱i̱ Masetúnianmaya̱ táarmatai Pápruka miji̱atrutsuk Yus-Chichaman étseruk “Yusa anaikiamuri̱ Kristu, atum nákarmena nu Jesusaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tura támaitiat nú chichaman nakitiarmiayi. Túmainiak Páprun katsekkarmiayi. Tuma asamtai Papru, nuiṉkia ikiuajrume tusa, ni pushiri̱n pe̱ar tímiayi “Atumek makuumarme. Tura wikia Yusa̱i̱ makuumatsjai. Yamaikia Israer-shuarcha ainia nuna Yus-Chichaman ujakartaj tusan werajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tura nuyaṉka Israer-shuar iruntai je̱a̱nmaya̱ jiinki, Yúsan enentáimtin áishmaṉ Justu je̱e̱n wémiayi. Ni je̱e̱nka Israer-shuara iruntai je̱e̱n aya̱mach pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Israer-shuar iruntai je̱a̱ chicharniuri̱, Krispu, Uunt Jesusan nekas enentáimturmiayi. Túruna nua̱ri̱ji̱a̱i̱ uchiri̱ji̱a̱i̱sha Yúsan umirkamiayi. Tura chíkich aencha Kurintiunmaya̱ armia nu nútiksaraṉ Yus-Chichaman antukar, Jesusan enentáimtusar imianiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Nuyá Uunt Yus Páprun mesekran ipiatkamiayi. Chicharuk “Peṉké ímiatik awajtamsachartatui Wi ámiji̱a̱i̱ pujakui. Ju̱ péprunmasha untsurí̱ aents Winia ajasartin írunui. Tuma asamtai ashamtsuk winia chichamur tuke etserkata” tímiayi Yus. ");
INSERT INTO jivNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tura nui̱ Kurintiu peprunam jimiará uwí ejesattuk Yus-Chichaman étseruk pujumiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tura Kariuṉ, Akaya nuṉka akupniuri̱ anaikiamu a̱i̱, Israer-aents Páprun kajerkarmiayi. Tura kajerainiak akupniunam irunturarmiayi. Túrawar Páprun júkiar ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tu túrawar akupniun chicharainiak “Ju̱ áishmaṉ Yúsan umirkatniun Muisais akupkamia núnaka íikias ausháa jintíawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tura Páprusha chichastaj táunak, Kariuṉka Israer-shuaran tímiayi “Ju̱sha nekas tunáa túrakuiṉkia, tura akupniun umirchakuiṉkia, tárumna nuna anturkaintjarme. ");
INSERT INTO jivNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Túrasha aya chichamnak tura aya náari̱niak atumí uuntri̱ akupkamia nunak tau asamtai, atumek nuámtak íistarum tájarme. Wikia nu chichamnum pachinkiatniun nakitiajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Taku a̱a̱ jí̱i̱kmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tura nuya̱ṉka Kriaku aents Israer-shuar iruntai je̱a̱ úuntri̱n Sústinisian achikiar awatiarmiayi akupniusha íimmianumaṉ. Túrasha akupin Kariuṉka túranak peṉké pachischamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Tura ni je̱e̱n waketkiarmatai, Papru nu péprunam untsurí̱ tsawant pujusmiayi. Tura nuya̱sha ukunam Yusa̱i̱ yachi ármiania nuna áujas ikiuak Pirisíraja̱i̱ ni aishri̱ Akiraja̱i̱ Senkrea péprunam wearmiayi. Nui̱ Israer-shuar túrutain umíak Papru ni intiashin awampramiayi, nuik Yúsan tímiaj nuna yamái umíajai tusa. Nui̱ṉkia kanunam eṉkemprarmiayi Siria nuṉkanam waketkitiai tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tura nuyá Ipisiu péprunam jeawar Pápruka Pirisíran tura Akiran ikiukmiayi. Tura Israer-shuar iruntai je̱a̱nam wayá Israer-shuar irunar pujuarmia nuja̱i̱ chichasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tura niisha Páprun ju̱i̱ṉ pujustá tusar seawarmiayi. Túrasha támaitiat, tujintiajai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nuya̱ṉka áujas ikiuak “Wisha Jerusaréṉnum námper átatna nuna pachiintiuktiniaitjai. Tura Yus akuptakuiṉkia atak tatajai atumin íistaj tusan” tímiayi. Tura kanunam eṉkemar Ipisiunmaya̱ jíinkimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nuyá Pápruka Sesaria péprunam jeá, nuya̱ṉka Jerusaréṉnum wémiayi, Yus-shuaran nui̱ áujsataj tusa. Tura nuyá Antiukíanam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tura Antiukíanam ishichik pujus ataksha weak Karasea nuṉkanam tura Pirijia nuṉkanmaani wekaráktak wémiayi. Tura weak Yus-shuar matsamarmia nuna chicharak ikiakárarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tumáa pujai̱ Arijiántria péprunmaya̱ Israer-aents Apurus Ipisiu péprunam jeamiayi. Niisha Yusa yaunchu papiri̱n ti péṉker nekaamiayi. Etserkatniuncha ti nékauyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Uunt Yus tímia nunasha unuimiátrauyayi. Tura tuke enentáiji̱a̱i̱ chichasmiayi. Jesusa túramuri̱n péṉker jintinniuyayi. Túrasha aya Juaṉ imiakratmanak nekaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ju̱ Apurus arantutsuk Israer-shuar iruntai je̱a̱nam chichamiayi. Tura Pirisíra Akiraja̱i̱ ni étserman anturkar, nincha akanki júkiar Yusa chichame̱n ni nekaachmia nuna núkap jintintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nuyá ukunam Apurus, Akaya nuṉkanam wétaj takui, Ipisiunmaya̱ Yus-shuar yáiṉkiar papí áarar atakas akupkarmiayi. Nú áentsnum péṉkerak jeat tusar túrawarmiayi. Tura Akayanam jeá, nú áentsun Yusa waitnenkratairi̱ji̱a̱i̱ uwempraru ármia nuna ti yáiṉkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tura Apurus Israer-aentsja̱i̱ paant chichasmiayi. Túrasha Yusa Papiri̱ji̱a̱i̱, Jesussha nekas Yusa anaikiamuri̱nti tusa paant jintíak nincha nupetkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tura Apuruska Kurintiunam pujái̱ Pápruka náinniumaani̱ wekaráktak, Ipisiunam jeamiayi. Tura nui̱sha Yus-shuaran wáinkiamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tura aniasmiayi “Atumsha Yus-shuar ajasmarmena nui̱, ¿Yusa Wakaní̱ atumí enentái̱n eṉkemturmakaitrum?” Tutai niisha tiarmiayi “Atsá. Iikia nuka peṉke áyatkisha ántichuitji Yusa Wakaní̱ awai támaka” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tutai Papru aniasmiayi “Entá, ¿nuikia atumsha warí enentáimsarmea imianmiarum?” tímiayi. Tutai niisha tiarmiayi “Juaṉ jintintramamiaj nu iisha enentáimsar imianmiaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tutai Papru tímiayi “Juaṉsha, tunaarminia̱ enentáimprarum imiantiarum, tíchamka. Nuyá tíchamka, winia ukuru̱i̱ winittiana nu nekas enentáimtustarum. Niisha Jesus Yusa anaikiamuri̱nti, tu ujatmakchamka” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nuna antukar niisha Uunt Jesusa náari̱n enentáimtusar ataksháa imianiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tura Papru ni uweje̱ja̱i̱ nin antiṉmatai Yusa Wakaní̱ tarurarmiayi. Túram chíkich chichamja̱i̱ chichasarmiayi. Túrunawar Yus-Chichaman etseriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nusha tuse (12) áishmaṉ ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tura nui̱sha menaintiu nantutin Papru Israer-shuar iruntai je̱a̱nam werí Yusa akupeamuri̱n pachis arantutsuk etsermiayi. Túrak nú áentsun ujaak Yúsnan nekasaiti tu enentáimtikrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tura chíkichka ni enentái̱n ti ikiatsu̱árarmiayi. Túrunawar umiktinian peṉké nakitiainia ásar aents ántamunam Yusa jinti̱n peṉké yajauch chicharkarmiayi. Tuma asamtai Papru Yus-shuarnaka akanki yaruak Tiranu iskuirari̱i̱n tuke tsawant Yus-Chichaman ujaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nuna túruki jimiará uwí etserkamiayi. Túramu asamtai ashí Asia nuṉkanmaya̱ aents Israer-shuar tura Israer-shuarcha Uunt Jesusa túramuri̱n antukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tura aentsti túrachminian túrat tusa Yuska ni kakarmari̱n Páprun susamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Jáanchniasha pushincha Papru antiṉman júkiar, náṉkamas jaa shuaran ejetim, nú jaa shuarsha nuna antiṉkiar péṉker ajaarmiayi. Iwianchrukusha nuna antiṉkiar, íwianch jíinkimtai aṉkant ajaarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tura chíkich Israer-aents uwishin ármiayi. Tura niisha chíkich chíkich péprunam wear iwianchrukun iwianchri̱n ji̱i̱rki akuptin ármiayi. Tuma asa niisha Jesusa náari̱ji̱a̱i̱ iwianchin ji̱i̱ktiai tusar, iwianchin chichartuiniak “Nu Jesus Papru ujaana nuna náari̱ji̱a̱i̱ jíinkitiarum tájarme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tura Israer Patri uuntri̱ Esewia náartin, siati uchiri̱ ármia nu, nuna túriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Túrasha Jesusa náari̱ji̱a̱i̱ jíinkitia, tuiniakui, iwianchcha tímiayi “Jesusnaka nékajai. Tura Pápruncha nékajai. Tura atumsha, ¿yátsukaitrum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nuna tinia iwianchruku áishmaṉ tsékeṉki nú áishmaṉkan kakaram katsumak nupetkarmiayi. Túram ti katsumam niisha misú tura numpamnawar jíinkiar pisararmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nusha Ipisiu péprunam túrunamiayi. Túrunamtai Ipisiu péprunmaya̱ Israer-shuarsha tura Israer-shuarchasha nuna túrunamun nekaawar ti ashamkarmiayi. Tura Uunt Jesusa náari̱n shiir awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Túmainiai untsurí̱ shuar Yúsan umirkaru Yus-shuar ajatsuk tunáa túrawarmia nuna paant ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tura untsurí̱ uwishniumawarmia nu, wawekratai papí ármia nuna itiarmiayi. Itiar, ju̱ka iniaiyaji tusar, ashí íimiainiai̱ṉ áesawarmiayi. Nú papí áesawarmia nuna kuítri̱sha senkuenta mir (50.000) naṉkaamasauyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tu túrunamtai Uunt Yusa chichame̱ pampaṉki tura nupetmaki wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tuma asamtai nuya̱sha Pápruka Masetúnia nuṉkanam Akaya nuṉkanmasha irautjai tu enentáimsamiayi. Tura nuya̱sha Jerusaréṉnum waketkitjai, tímiayi. Tura nuyá ukunam Ruma péprunmasha wetajai, tu enentáimsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Masetúnia wétin asa Papru ni tsaniakmari̱n Masetúnia nuṉkanam emka akupkamiayi. Timiutéun Erastuja̱i̱ akupkarmiayi. Tura niṉkia Asia nuṉkanam seturmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pápruka tuke Ipisiunam pujái̱, nuyá aents Yus-Chichaman nakitiainiak charaatum ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iis, nui̱ Ipisiunam kaya-yusa je̱e̱ ámiayi. Nu yus núwa̱uyayi, Tiana naartin. Tura áishmaṉ, Timitriu naartin, nú je̱a̱n nakumak uchichin najanniuyayi kuitja̱i̱. Tura niisha nú takatja̱i̱ ti kuítrintin ajasmiayi. Tura chíkich áishmaṉ nú takatan takarmia nunasha ti kuítri̱ntin awajsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Timitriusha niiji̱a̱i̱ takarmia nuna ikiaanak, chikichnasha niiji̱a̱i̱ métek-taku takarmia nunasha ikiaanak niiji̱a̱i̱ charaatum ajarmiayi. Timitriusha tímiayi “Winia írutramutiram antuktarum. Iisha ju̱ takat takaajnia ju̱ja̱i̱ ti kuit achíatsjik. ");
INSERT INTO jivNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tura atumsha ju̱ Papru wáintrumna nu tura ántarmena nu chichaak “Ashí aents najanamu yuska ántar áiniawai” tatsuk. Nuna tau asa, ju̱i̱ Ipisiunam, tura arant ashí Asia nuṉkanam, ni yúsri̱n iniaisarat tusa enentáimtikrarai. Tuma asamtai untsurí̱ aents, ii yusri̱ Tiánan ikiuiniak, Papru tana nuna umirainiatsuk. ");
INSERT INTO jivNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Papru tu étserkui, iisha itiurchat pujuschattajik. Kuit ii achiaj nuka meṉkakashtatuak. Tura nú arantcha ii yusri̱ Tiana je̱e̱n shuar iniaisachartatuak. Tura nuyá Asia nuṉkanmaya̱sha tura ashí nuṉkanmaya̱ aencha, ii yusri̱ Tiana shiir awajainia nuna yapaji̱áwar aun nakitrachartatuak” tímiayi Timitriu. ");
INSERT INTO jivNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nuna antukar aencha ti kajekar charaatum ajarmiayi. Túmainiak “Ipisiu shuartikia, aya Tianak wakeraji” tu untsummiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nuiṉkia aents páchim enentáimprarmiayi. Túmainiak Masetúnianmaya̱ Kayuncha Aristárkuncha Páprun nemari̱n ármia nuna achikiar japirkutak iruntai je̱a̱nam júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tura Pápruka iruntai je̱a̱nam wayá chichastaj taun, nuyá Yus-shuar ármia nu, nuna suritkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tura Asia nuṉkanmaya̱ uuntri̱, Páprun amikri̱ ásar, ai̱ṉkia waya̱wa̱i̱ṉ tusar chichaman akuptukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Túrasha irunar pujuarmia nu, páchim enentáimprar, chíkichka nusháa untsummiarmiayi. Tura chikichcha nútiksaraṉ ausháa untsummiarmiayi. Tura chíkichka ti untsurí̱, nekaachar “wariniak irunturara” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Chíkich nui̱ wajarmia nu charaatum amia nuna Israer-shuaran Arejántrun jintintrar eem shitiawarmiayi. Arejántrusha Kayun tura Aristárkuncha ayampruktinian wakerak takamatsatarum tusa uwejé̱n takuimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Túrasha aents iruntrarmia nu, ju̱ka Israer-shuaraiti tusa nekaawar, nú arant charaatum ajainiak “Ipisiu shuartikia aya Tianak wakeraji” ímia-imiatainiakua tí nukap pujursarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ipisiu pepru papí-aintri̱sha áentsun itiatmamtik tímiayi “Ipisiu shuártiram antuktarum. Ii uunt yusri̱ Tiana je̱e̱ íistinia íichukaitiajⁱ. Tura ni nakumkamuri̱sha nayaimpinmaya̱ iniarmiania nusha íischatniukaitiajⁱ. Tura nunasha ashí aents paant nékainiatsuk, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Warí, núnaka ashí aents nékainia asamtai atumsha itiatkatarum. Túrarum enentáimtsuk yajauch túrawairap, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Íimiatarum. Ju̱ áishmaṉ átum itiarumna nu, ii yúsri̱n yajauch chicharkacharai. Tura ni je̱e̱n yajauch awajsacharai. ");
INSERT INTO jivNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Wats, Timitriu tura niiji̱a̱i̱ takainiana nu tunáa túramun ujaktai tusar wakeruiniakka pepru peṉkeri̱n werishtinkiait. Nuiṉkia máimtek iwiainiakartí. ");
INSERT INTO jivNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tura chíkich chicham ákuiṉkia péṉker iruntrarum iwiaratarum. ");
INSERT INTO jivNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kame ju̱ yamái túrunamun nekaawar Rúmanmaya̱ kapitián “Ii uunt kapitiántri̱ yajauch awajsatai tusarum túrachurmeash” turamchatjiash. Warí, niisha “¿Urukamtai charaatum ajarum?” takuisha, áimkiatin peṉké tujinkiattaji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tura papí-aint nuna tuasua amik “Áukete. Wétarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Charaatum ajasua amikiarmatai Papru Yus-shuaran untsuk Yusnan jintintrataj tusa ikiaankarmiayi. Tura áujas ikiuki Masetúnianam wémiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nú nuṉkanam wekaráktak, Yus-shuaran jintintrar ikiakárarmiayi. Tura nuya̱sha Krisia nuṉkanam jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nui̱ menaintiu nántuk pujusmiayi. Tura nuya̱ṉka kanuja̱i̱ Siria nuṉkanam wétasa pujus Israer-shuar chícham jurusman anturmamak “antsu nuṉkaṉ Masetúnianmaani̱ wetajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tura Piríanmaya̱ áishmaṉ Súpater naartin Páprun atamprimiayi. Tura Tisarúnikianmaya̱ Aristárkusha Sekuntusha Tírpinmaya̱ Kayusha Timiutéusha Asianmaya̱ Tíkikiusha, Trújimiusha ashí nu shuar Jiripius peprunam Páprun atampriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Túrawar niisha emki wear Trúas péprunam jeawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tura iisha wakapruachu tanta yutai jisat amuukamtai, iisha Jiripius péprunmaya̱ jíinkir, kanunam eṉkemprar Masetúnia nuṉkanmaya̱ jíinkimji. Tura seṉku tsawant naṉkaamasmanum emki wearmia nu amaiyaṉkarmiaji Trúasnum. Tura nui̱sha siati tsawant pujusarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tura tumiṉtin kí̱arai Jesukrístu enentáimtusar yurumátai tusar iruntrarmiaji. Tura Papru Yus-shuaran jintintramiayi. Kame Pápruka kashinkia wétin asa chichaa-chichaakua kashi ajapéṉ ejemiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tura yakí menaintiu pátaranam, tesaamu ámia nui̱ iruntrarmiaji. Nui̱sha ji ekemarma untsurí̱ irunmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tura nui̱sha natsa Eutikiu, áaṉkamunam aya̱mas pujusmiayi. Tura Papru ti esaram chichaakui nu nátsasha kari̱ pujumiayi. Tumáa pujus kanaki yakí pátanmaya̱ akaiki iniaamiayi. Tura peṉké jakan júsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tura Papru akaatuki tsuntsumprua miniakkamiayi. Tura Yus-shuaran chicharainiak “Ashamkairap. Ataksha iwiaakui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nuyá ataksha Papru wakamiayi. Tura taṉtan puukar yurumáwarmatai, tuke chichaa-chichaakua tsawantmarmiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eutikiuncha iwiaakun ni je̱e̱n júkiarmiayi. Tura ashí aents shiir enentáimsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wats, Papru Asuṉ péprunam nuṉkaṉ we jeatajtsa wakerimiayi. Tura incha, átumka kanunam wétarum, turamkurin, iikia emkir wémaji Asuṉnum. ");
INSERT INTO jivNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nui̱ Asuṉnum iṉkiunaikiar, Páprusha kanunam eṉkempramtai, Mitiríniniam jeamji. ");
INSERT INTO jivNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tura nuyá jíinkir, kashin tsawa̱rar Sámus péprunam jeamji. Tura nuya̱ṉka Trujiriunam jear ayampramji. Nuya̱sha kashin tsawa̱rar Miritiunam jeamji. ");
INSERT INTO jivNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pápruka Jerusaréṉnum wari wétajtsa wakerimiayi, pintikiustís naartin jístatin pachiinkiataj tusa. Tuma asamtai, Asia nuṉkanam ti núkap pujustinian nakitiak “Ipisiunam wéchattajai” tímaiyi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Túrasha Papru tuke Miritiunam pujus, Ipisiunmaya̱ Yus-shuara úuntri̱n winitiarum tusa untsukarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ni taarmatai Papru tímiayi “Atumsha wi Asia nuṉkanam pujusan itiura túraj nu nékarme. ");
INSERT INTO jivNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Atumja̱i̱ tuke tsawant pujumaj nui̱, naṉkaamantuchu enentáimtumasan, úutchim winia Úuntrun takatri̱n takasmiajai. Tura Israer-shuar yajauch awajtustinian wakerutainiai̱ṉ tuke takasmiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ashí péṉker ana nu nekaatarum tusan miji̱atrutsuk jintintiamjarme. Iruntramarmena nui̱ tura aṉkant aṉkant atumí je̱e̱n pujumarmena nui̱sha Yus-Chichaman ujakmajrume, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Tura Israer-shuarnasha Israer-shuarchancha nútiksanak, enentai yapaji̱árum Uunt Jesukrístu umirkatarum, tímiajrume. ");
INSERT INTO jivNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Tura yamái Jerusaréṉnum wéajai, Yusa Wakaní̱ túrutkui. Nui̱sha túrunatana nunasha nekamatsuk wéajai. ");
INSERT INTO jivNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tura Yusa Wakaní̱ iniakturkui ju̱na nékajai, ashí pepru wi jeattajna nui̱ eṉketátai tusar nákarainiawai. Tura ti wáitsatniun nekapsattajai. ");
INSERT INTO jivNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kame wikia jákashtajash. Túrasha warí winia itiurtawa. Wikia Yusa jinti̱i̱n warasan wekasataj tusan wakerajai. Yusa̱i̱ wea-wéakuan jáakun iniaisataj tajai. Tura nuyá takatan Uunt Jesus surusmia nuna péṉker amuktaj tusan wakerajai. Jes, Jesus chichartak “Yus wáitnenkartana nú chicham etserkata” turutchamka’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‘Tura, yatsurtiram, ashí Yúsnan atumin paant ujakjarme. Yamaikia wíniaka atakka wáitkiashtatrume. ");
INSERT INTO jivNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Nekaatarum, ashí Yusa wakeramuri̱n wisha peṉké ú̱u̱rtsuk ujakjarme. Tuma asamtai atumin títiajtsan wakerajrume, chikichík shuara wakaní̱ jinium wéakuisha wikia peṉké makuumashtatjai. ");
INSERT INTO jivNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tuma asamtai emka atumek íimiastarum. Túrarum nuyá chíkich Yus-shuar íistarum. Yus-shuaran wáinin ajastarum tusa, Yusa Wakaní̱ achirmakurme. Yus-shuar ainia núnaka ni numpe̱ja̱i̱ṉ Uunt Jesus sumakchakait. ");
INSERT INTO jivNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kame wi wématai, chíkich táartatui. Núnaka nékajai. Tura niisha, Yus-shuaran amukartajtsa wakeriartatui, uunt ya̱wa̱sha murikiun amuinia áintsaṉ. ");
INSERT INTO jivNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Túrasha nemartusarat tusar wakeruiniak atumi̱i̱nia̱ṉ wait chichaman unuikiartin wantinkiartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tuma asamtai yatsurtiram, aneartarum. Wisha menaintiú uwitin tsawa̱i̱sha káshisha úutchim aṉkant aṉkant unuiniamajrumna nu kajinmatkiirap’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","‘Pai, yamaikia, yatsuru, Yus yáinmakarti. Yusa aneṉkrattairi̱ nékaitrumna nú chichamsha kakarmaiti. Nú chicham átum katsua̱rar kakaram wekasatniun yainmakarti. Kame nú chicham atumi̱ enentáin pujakui, Yus ni shuarin matsamsatniun anajmatramia nui̱ pachiinkiattarme. ");
INSERT INTO jivNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Wats, wisha chikichkí shuara kuítri̱n wariri̱ncha wakerutkachuitjai. ");
INSERT INTO jivNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Antsu winia uwejruja̱i̱ takasan wi atsummiaj nuna sumarmakmajai. Tura winia írutkamuru atsumamuri̱ncha wiki sumakmiajai. Nuka paant nékarme. ");
INSERT INTO jivNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kame átum takasrum, atsumainia nusha yáiṉtarum tusan jintintiajrume. Wats, Uunt Jesusa chichame̱ enentáimsami. “Achíana nuja̱i̱ṉkia naṉkaamas, súana nuka shiir waraawai” tíchamka” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nuna tuasua amik Papru tikishmarmiayi. Tura ashí niiji̱a̱i̱ iruntrarmia nú shuar Yúsan áujsarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Tura Papru nuik chichaak “Atakka wáitkiashtatrume” tiniu asamtai, ti kúntuts pujuiniak, úutchim Páprun miniaksarmiayi. Túrawar kanunam ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tura nuyá Yus-shuar aujsa ikiukir kanunam eṉkempramji. Tura íṉkiuasmak Kus péprunam jeamji. Tura kashin tsawa̱rar Rútas péprunam jeamji. Tura nuya̱ṉka Patara péprunam jeamji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tura nui̱ Pataranam pujusar, chíkich kanu Pinisia péprunam wea wáinkiamji. Túmakui nui̱ eṉkemprar wémaji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nui̱ wésar Chipri nuṉkaka wáinkiamji. Chíprikia menanmaani̱ aa ikiuakur Sírianam jeamji. Kánuka Tiru péprunam jeá pujustiniuyi, káarak núkap ikiuktin akui. Tuma asamtai iisha Tírunam jear kanunmaya̱ jíinkir péprunam waya̱mji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nui̱ Yus-shuar wáinkiar nuiṉ siati tsawant pujusmaji. Tura Yus-shuaran Yusa Wakaní̱ ujakam Páprun chicharainiak “Jerusaréṉnumka wéchatniuitme” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tura siati tsawant naṉkaamasmatai jíinkimji. Ashí Yus-shuar ármia nu núwentuk uchirtiuk nemartamkamji, péprunam iniaṉkatmaktiai tusar. Káanmatkanam jear tikishmarar Yus áujsamji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tura nu amikiar nuiṉkia áujnaisar ikiukiarmaji. Tura iikia kanunam eṉkemprakrin niṉkia ni je̱e̱n waketkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Iisha Tirunmaya̱ entsak wea-wéakuar Turumáitianam nui̱ṉ jíintramji. Tura nui̱ jearsha Yusa̱i̱ yachi̱ ármia nu chichasar nui̱ṉ chikichkí tsawant pujusmaji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kashin tsawa̱rar nuyá jíinkir nuṉkaṉ weri Sesaria péprunam jeamji. Nui̱ Jiripi je̱e̱n jear pujusmaji. Jiripikia Yus-Chichaman etserniuyayi. Nuik Jerusaréṉnum siati áishmaṉkan Yusa takatri̱n wáinkiarat tusar anaikiarmia nú Jiripiiti. ");
INSERT INTO jivNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jiripisha kuatru nawantri̱n yarumkauyayi nuatnakchan. Niisha Yusa chichame̱n etserin ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tura iisha Jiripi je̱e̱n wárum tsawantak pujarin Jutía nuṉkanmaya̱ aents Yusa etserniuri̱, Akapu náartin támiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Niisha taa Papru emenmamkari̱n achikmiayi. Tura achik niṉki ni nawe̱n tura uwejé̱ncha jiṉkiamamiayi. Nuna tura tímiayi “Yusa Wakaní̱ tawai, ju̱na emenmamka nérenniuri̱n Israer-aents jútikia jiṉkiáwar Israer-shuarchanum surukartatui, tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Iisha nu antukar Papru tímiaji “Jerusaréṉnumka weep.” Sesarianmaya̱ Yus-shuarsha núnisaṉ Páprun tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tutai Papru tímiayi “¿Urukamtai úutkuram winia enentáirui̱ kúntuts awajtarum? tímiayi. Wi Jesusna asamtai Jerusaréṉnum jiṉkiatainiakuisha mántuiniakuisha ashamatsjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tura iisha Papru emetatai tukamar tujinkiar “wats, nuiṉkia Uunt Yus wakera nu tímianak atí” tiarmaji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nu tiri iniaisar iwiarnarar Jerusaréṉnum wémaji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Chíprinmaya̱ yaunchu Yus-shuar Manasuṉ ni je̱e̱n Jerusaréṉnum takakuya nuna ikiatmastinian wakerimiayi. Tuma asamtai Sesarianmaya̱ ishichik Yus-shuar nemartamainiak Manasuṉnasha júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tura iisha Jerusaréṉnum jeawakrin, nui̱ warasar Yus-shuar ti shiir áujtamsarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tura kashin tsawa̱r Papru íimiak Jakupu je̱e̱n wémiaji. Nui̱sha Yus-shuara uuntri̱ matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Páprusha áujas amik, Israer-shuarchanum ni étsermaja̱i̱ Yus túramia nuna yámankamtaikniumia̱ jukí chikichkimias ujakar ujakar awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Papru taman antukar “Yus ti péṉkerchakait” tiarmiayi. Tura Páprun ju̱ chichaman tiarmiayi “Támena nu péṉkeraiti, yatsurú, túrasha Israer-shuar timiá untsurí̱ Yus-shuar ajasu áiniayat, “ashí Muisais akupkamia nu umiktiniaitji” tuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nú arant yajaya̱ aents taar, chichartamainiak “Pápruka nusháa jintintiui, turamainiawai. Israer-shuar chíkich nuṉkanam pujuinia nuna Muisaisa akupkamuri̱ umirkashtin Pápruka jintintiui, turamainiawai. Israer-shuarti tsupirnaktin ana nu túrashtinian tura ashí Israer-shuar túrutai iniaisatniun Papru imia Israer-shuaran jintintui, turamainiawai.” ");
INSERT INTO jivNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Wátsek, yatsuru, nuiṉkia itiurmaiṉkit. Ame tátintrumin aents nekaawarka ju̱i̱ kajertamainiak káutramkachartatuak. ");
INSERT INTO jivNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Wats, antsu nuiṉkia, ju̱ túrata yatsuru. Ju̱i̱ kuatru áishmaṉ Yúsan yaunchu tiarmia nuna umiktasa pujuiniawai. ");
INSERT INTO jivNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nii júkiarta. Túram niisha Muisais akupkamia nuna umikiar nijiaamainiakui, amesha nijiaamarta. Núnismek kuítniasha ni susatin ana nu amesha akikmatkarta. Niisha ashí umikiarmatai, ni intiashi̱n awampratin áchattawak. Nu áishmaṉka intiashi̱n awampran Israer-aents wáinkiar, anturtamkarainia nu, nekaschaiti, turamartatui. Antsu, Pápruka Muisais akupkamia tímianak túrawai, turamartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Túrasha yatsuru, nekaata, Israer-shuarcha Yus-shuarka papí yaunchu akuptukmiaji. Israer-shuarti túratin ana nu ashí mash túratarum tátsuji, tu áatramji. Tura antsu namaṉken máawar ántar-yusan susamu yúashtiniaitrume, tímiaji. Tura numpasha umarchatniuitrume, kajemtikramusha yúashtiniaitrume. Tura tsanirmashtiniaitrume. Tu áatramji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nuyá tiniu asamtai Papru nú kuatru áishmaṉkan júkiarmiayi. Tura kashin tsawa̱rar níimiak nijiaamararmiayi, Muisais timia nútiksaraṉ. Tura Yúsan tiarmia nuna wárik umiktinian tura Muisais timia nuna Yus súsatniun ujaktajtsa Papru Yusa Uunt Je̱e̱n waya̱miayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Túrasha nu siati tsawant amusattuk ajatemsa̱i̱, Ásianmaya̱ Israer-aents Paprun Yusa Uunt Je̱e̱n pujan wáinkiarmiayi. Túrawar charaatum ajakiar Páprun achikiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Achikiar untsumainiak “Israer-shuártiram in yáinmaktarum. Ashí nuṉkanam Muisais akupkamuri̱ncha Israer-shuarti túrutairi̱ncha, ju̱ Yusa Uunt Je̱e̱ncha yajauch chicharea nu achikji, tiarmiayi. Warí, Kriaku áentsun awayáshtinia nuna awayá nuja̱i̱ yamái ju̱ Je̱a̱ncha yajauch awajturmaji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Jes, nuik Ipisiunmaya̱ Trúpimiu Pápruja̱i̱ péprunam wekaan wáinkiaruyi. Wáinkiaru ásar, Yusa Uunt Je̱e̱n waya̱yi, tu enentáimsar tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tuiniakui aents ashí mash charaatum ajakiar tseke táarmiayi. Túrawar Páprun achikiar japirkutak Yusa Uunt Je̱e̱ya̱ jí̱i̱kiarmiayi. Túrawar wáitincha nú chichamaik epentrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tura maatai tusar matsamtuinia̱i̱ suntara kapitiántri̱ Jerusaréṉnumia̱ aents ashí charaatum ajainian antukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kapitiáncha ni suntari̱n tura sarjentuncha irur tseke weriarmiayi aents pujuarmia nui̱. Aencha suntaran tura kapitiánin wáinkiar, Páprun asutíniayat iniaisarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kapitiánka Páprun jeari achikmiayi. Tura jimiará jiruja̱i̱ jiṉkiamiayi. Nuya̱sha aniasmiayi “¿Niisha yait? ¿Warinia túrait?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Túrasha aencha untsurí̱ chichaman untsummiarmiayi. Túmainiakui kapitiáncha peṉké nekaachmiayi. Tuma asamtai Páprunka suntar pujamunam júkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tura suntar pujamunam wáitiniam jeawar Páprun entsaki júkiarmiayi aents imiá kajerainia asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tura aencha ukunmaani̱ pataakar, mantamnatí, tu untsummiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tura Papru suntarnum awayám, Páprusha kapitiánin Kriaku chichamja̱i̱ chichaak “Wi ishichik chichasaintjame” tímiayi. Tutai kapitián chichaak “Warí, ¿amesha Kriaku chicham chichastin nékamek? tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nuiṉkia amesha ¿Ejiptunmaya̱ shuárchakaitiam? ¿Nuik kuatru mir (4000) aents, maṉkartin tutai atsamunam yaruakchamkam? ¿Kapitiánja̱i̱ meset najanataj tusa túrachmakum?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tutai Papru tímiayi “Núchaitjai. Antsu wikia Israer áentsuitjai. Sirisia nuṉkanam uunt pepru Tarsu náartin ana nui̱ akiiniaitjai. Tura waitneasam ju̱ aents chichastin tsaṉkatrukta” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tura kapitián, ayu, tutai, Papru watainium wajas, mitiat pujustarum tusa uwejé̱n takuimiayi. Tura aents itiatkarmatai Israer-chichamja̱i̱ chichasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Papru chichaak ju̱na tímiayi: “Yatsurtiram, tura úuntur árumna nu antuktarum. Wikia Pápruitjai. Kíishtumaktaj tusan títiatjana nu waitneasrum anturtuktarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tura Papru Israer chichaman chichaakui, aents nuna antukar nú naṉkaamas itiatkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Nui̱ Papru chichaak “Wikia Israer-shuaraitjai. Tarsu pepru Sirisia nuṉkanam ana nui̱ akiiniaitjai. Túmaitiatnak ju̱i̱ Jerusaréṉnum tsakaruitjai. Tura unuikiartin Kamaríran chichame̱n unuimiaruitjai. Tuma asan ii uuntri̱ akupkarmia nuna ashí umirkaitjai. Tura átum yamái túrarmena nuna wisha nútiksanak Yusna ana nuna tuke enentáiji̱a̱i̱ wakerukuitjai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tura Jesusan umirkaru ármia nuna máataj tusan pataatukni wekaimiajai. Túran áishmaṉkan nuwa̱ncha achikian sepunam eṉkeataj tusan túrimiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Israer-patri uuntri̱sha Israer-shuara uuntri̱sha Tamaskunam íi-shuar susatá tusar papin ataktusar akuptukarmia nuna niṉkia nékainiawai. Jesusan umirkarun achikia ikiaankan jui̱ Jerusaréṉnum asutniáwarat tusan werimjai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‘Tura wi jintiá wéai̱ Tamaskunam jeastatuk ajasa̱i̱ nantu tutupin a̱i̱ aya aneachma nayaimpinmaya̱ newaat wajantruntmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Túrunamtai wisha nuṉká iniaarmajai. Nuyaṉka chichaamun antukmajai. Chichartak “Sauru, Sauru, ¿urukamtia imiá pataaturam?” turutmiai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Takui wi aniasmajai “¿Amesha yáitiam, Uunta?” Tutai “Wikia Nasarétnumia̱ Jesusaitjai. Ame pataaturmena núitjai” turutmiai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wiji̱a̱i̱ pujuarmia nu, newaat wajantun wáinkiar ti ashamkarmai. Túrasha niṉkia túrutun antukcharmai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tura wi tímiajai “¿Nuiṉkia, Uunta, warí itiurkattaj?” tímiajai. Tutai Uunt chichartak “Wajakim Tamaskunam wetá. Nui̱sha ame túrattamna nuna ujatmakartatui” turutmiai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kame wikia nú newaat ajakun íisan ji̱i̱ru kusurmai. Tuma asamtai winia tsaniakmar eṉkeki jurukiar Tamaskunam ejetiarmai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Papru tuke aujmatki wéawai. ‘Tura nui̱ Tamaskunam áishmaṉ Ananías pujumai. Niisha Yúsan aneak, Muisais akupkamia nuna umirkauyi. Tura nú péprunmaya̱ Israer-shuar ármia nu nin péṉker enentáimtiarmiai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nú Ananías winia íirsataj tusa támai. Taa turutmai “Yatsuru Sauru, péṉker iimtia.” Túrutkui nú chichamaik péṉker íimmiajai. Túrunan Ananíasnasha wáinkiamjai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tura Ananías chichaak “Iwiaaku Yus, winia wakeramurun nekartuat tusa winia Uchirnasha, tunaarinchaa nuna, íisat tusa, winia chichampruncha antukat tusa ámin yaunchu Yus anaitiamkaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Amesha Papru, Yusna ana nu íisumna nusha antukumna nusha ashí aents ujakartatme. ");
INSERT INTO jivNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tuma asamtai yamaisha ¿warí nákam? Tunaarun asakátrurat tusam Uunt Jesus enentáimtusam weme ni náari̱ pachisam imiantia” turutmai.’ ");
INSERT INTO jivNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‘Tura Jerusaréṉnum waketkin Yusa Uunt Je̱e̱n wémajai Yúsan áujsataj tusan. Nui̱ íimiarmajai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nui̱ Jesus chichartak “Jui̱ Jesusaréṉnum Wíi túramur etserkattamna nuna antukchartatui. Tuma asamtai wari jíinkim wetá” turutmiai.’ ");
INSERT INTO jivNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Túrutkui wi tímiajai “Túrasha Uunta, ju̱yá aents wi Israer-shuara iruntai je̱e̱n waya̱n Ámin umirtamkarmia nuna nui̱ matsatun achikian awatin sepunam eṉkeawarmia nuna nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tura nuyá Áminiu etserniun Estepaṉkan máiniakuisha wisha wajamjai. Túruiniakui, “péṉkeraiti” tímiajai. Nú arantcha ni pushiri̱n íirsamjai” tímiajai.’ ");
INSERT INTO jivNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","‘Túrasha Uunt Jesus winia turutmai “Wetá. Israer-shuarcha matsatainia nui̱ akupkatjame” turutmai” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nu̱i̱ matsamarmia nu, núnaka antukarka untsumtan juáriarmiayi. “Ju̱ka mantamnatí. ¿Urukamtaik iwiaakusha pujusat?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tura aentska Paprun kajerainiak, ti untsumainiak pushiri̱n tujaat ajapawar nuṉkancha naṉkimkiamaikia ajarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tura kapitián nuna wáiniak Páprun suntar pujamunam awayámiayi. Tura suntaran chicharuk “Átum asutiárum áimtikiatarum. ¿Urukamtaik aents nin kajerainiak imiá untsumainia? Nekaatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tura Páprun asutiátai tusar jiṉkiárar awajsam Pápruka kapitiánin chicharuk “¿Rúmanmaya̱ aents áyatik asutiámniakait, ni túramuri̱ nekartsuk?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nuna táman antuk kapitiáncha uunt kapitiánin ujaktaj tusa werí chichaak “Maaj, túrataj tamena nu anearta. Ju̱ áishmaṉ Rúmanam pachitkaiti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nuna antuk uunt kapitián Páprun werí aniasmiayi “¿Amesha nekasmek Rumanam pachitkaitiam?” tímiayi. Tutai Papru “Ee” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tutai “Wikia ti kuítian akikmakmiajai Rúmanam pachiinkiatniun” uunt kapitián tímiayi. Tutai Papru tímiayi “Túrasha winia aparka Rúmanam pachitkia asamtai, wisha Rúmanam pachiinkian akiiniaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nuna takui Páprun asutiátaj tiarmia nuna wárik iniaisar jíiniar wearmiayi. Tura imia uunt kapitiáncha Rúmanam pachitkian jiṉkiá asa ashamkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tuma asa kashin tsawa̱r uunt kapitián, urukamtaik Páprun imiá kajerainia, nekaataj tusa wakerak Paprun werí jiṉkiámun atirmiayi. Tura Israer-patri̱ uuntri̱n chíkich naamka armia núja̱i̱sha ikiaankamiayi. Tura nuiṉkia ni matsatmanum Páprun itiar ajapén awajsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Papru Israer-patri̱ naamkari̱n úmamkes iis “Wíi shuartiram antuktarum. Úchichik tuke yamaisha Yus íimmianum péṉker wekainuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Papru nuna takui Israer-patri uuntri̱ Ananías, ni suntari̱n Paprui̱ aya̱mas pujuarmia nuna “Wenunam awatiarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tutai Papru tímiayi “Tsej, jimiará chichamtinia íimiatá, Yus amincha asutiámattawai. Muisais akupeana nuna umiatsui tusam yajauch turutattsam pujame. Entá, ¿nuiṉkia urukamtia Muisais tímia nuka iniaisam ame suntarum winia asutiátarum tame?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tura nuna takui nui̱ wajarmia nu Páprun tiarmiayi “¿Maaj, amesha Patri uuntri̱ imiá yajauchisha chichaream?” ");
INSERT INTO jivNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tutai Papru tímiayi “Yatsuru, wisha Patri uuntri̱ áutskaitia tíchamjai. Nékaitkiunka núnaka tícha̱a̱jai. Kame wisha nékajai, Yus-Chichamnum tawai “Atumí uuntri̱ yajauch chicharkairap” tawai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Israer-aentsu úuntri̱ya jimiará írutka ármiayi. Satuséu aents tura nuyá Pariséu aents nusháa írutkan Pápruka nekaamiayi. Kame Satuséu aentska, jakamunmaya̱ nantaktincha Yusa suntari̱sha aentsu wakaní̱sha tura iwianchcha atsawai, tiniu ármiayi. Antsu Pariséu aentska, nuka ashí awai, tiniu ármiayi. Nuna nekáa Papru kakantar chichaak “Wikia Pariséu áentsuitjai. Wíi shuarsha Pariséu áiniawai. Wikia ashí shuar jakamunmaya̱ ukunam nantaktin átatui tu jintiamun, nekaatai tusar itiariarmiayi” tímiayi. Tura Papru nuna takui Pariséu aents tura Satuséu aencha nuámtak kajernaikiarmiayi. Túrunawar kánasaraṉ nusháa nusháa enentáimprarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nuiṉkia ashí aents charaatum ajarmiayi. Tura Israer-shuara jintinniuri̱ Pariséunam írutka armia nu wajakiar tiarmiayi “Ju̱ áishmaṉ tunaan peṉké túrichuiti. Yusa suntari̱ chíkich wakancha nin nekas chichaschamashi. ¿Ya neka?” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ti charaatum ajainiakui suntara kapitiántri̱ Páprun achia̱rchartimpiash tusa suntaran untsuk, “Ji̱i̱ktiarum, túrarum suntar pujamunam awayátarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nuyá kashi Papru Uuntri̱ mesekra ipiatuk “Kakaram ajasta, Papru. Ju̱i̱ Jerusaréṉnum winia ujakarumna núnismek Rúmanmasha ujaktatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nuyá kashin tsawa̱rmatai Israer-aents Páprun maatai tusar chichaman jurusarmiayi. “Papru máachkurkia yurumtsuk tura peṉké úmutsuk matsamsattaji. Máachrikia yajauchiniam yumiṉkramu atai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nuna tiarmia nuka kuarenta (40) naṉkaamas ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tura Israer-patri úuntri̱n tura Israer-aentsu úuntri̱ncha weriar “Papru máachkurkia peṉké yurumtsuk pujustatji. Máachrikia yajauchiniam yumiṉkramu atai” taji. ");
INSERT INTO jivNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tuma asamtai ashí Israer-patri̱ naamkari̱ji̱a̱i̱ suntara kapitiántri̱ seatarum, Papru tatí tusarum. “Kashin Papru itiata, titiarum. Papru tana nu iisha nekas nekaatai tusar wakeraji” titiarum. Túrawakrumin iisha maatai tusar niṉkia táatsa̱i̱ṉ nákaktatji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tura Papru awe̱ nú chichaman antuk suntar pujamunam taa Páprun ujakmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tuma asamtai Pápruka suntara kapitiántri̱n untsuk “Ju̱ uchi uunt kapitiánnium jukitia. Niisha chichaman takakui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kapitiáncha uchin uunt kapitiánnium ejé tímiayi “Papru eṉkeamu pujana nu winia untsurak “Ju̱ uchi uunt kapitiánnium jukitia. Chichaman takakui” túrutui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Uunt kapitiáncha nú uchin eṉkeki arantach jukí chicharuk “¿Warí turuttiaj tame?” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tutai uchi tímiayi “Israer-aents Páprun chichaman jurusarai. “Papru túramuri̱ ti paant nekaatai tusar kashin Israer-shuara uuntri̱i̱n ejetarum” turamartatui. ");
INSERT INTO jivNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Tura amesha nuna takui anturkaip. Kuarenta (40) naṉkaamas jintiá akirtua pujurainiawai. Tura “Papru máachkurkia yurumtsuk tura úmutsuk matsamsattaji” tuiniawai. Tuma asamtai yamaisha ámin tití tusa nákarmainiawai” tímiayi uchi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tura uunt kapitiáncha uchin chicharuk “Ame túrutmena nu chíkich aents peṉké ujakaraip’ tímiayi. Nuna ti̱, uchin akupkamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nuyaṉka uunt kapitiáncha chíkich kapitiánin jímiaran itiá chichaak “Urum, kashi ajapéṉ ajastatuk ai̱, untsurí̱ suntar ikiaankarta. Jimiará siáṉ (200) aya náwek, setenta (70) kawainium eketka, nuyá chíkich jimiará siáṉ (200) náṉkiji̱a̱i̱ṉ Sesaria nuṉkanam wétin iwiarata. ");
INSERT INTO jivNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Páprusha kawainium ekemkatin iwiarturta. Túrarum péṉkerak ejetarum akupin Piriksai̱” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tura niiji̱a̱i̱ ju̱ chichaman áatrar akuptukmiayi: ");
INSERT INTO jivNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ti péṉker akupin Píriks, wikia Krautiu Rísias ju̱ papin áatjame. ");
INSERT INTO jivNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Israer-aents ju̱ áishmaṉkan maatai tusar wakeruiniak achikiarmiayi. Tura niisha Rúmanmaya̱ áentsuitkui wikia nuna nekaan suntarja̱i̱ werin jukimjai. ");
INSERT INTO jivNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Wikia ¿urukamtaik achikiaruit? tusan Israer-patri naamkari̱n jukimjai nin. ");
INSERT INTO jivNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Páprunka ii uuntri̱ akupkamuri̱n umiatsui tusar nin kajeriarmiayi. Pápruka yajauch túrachu asa mantamnachminiuyayi. Sepunmasha eṉkemachminiuyayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Tura wisha Israer-aents nin máatniun chichaman jurusman nekaan ami̱i̱n akuptajme. Nuya̱sha nin kajerainia nunasha tajai “Atumsha Piriksai̱ werum átum warinma kajerarum nu títiarum” tajai. Ayu. Jú̱chiniak tájame.” Nuna tu áatar akuptukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tura suntarsha ni uunt kapitiántri̱ tímia nútiksaraṉ Páprun kashi júkiarmiayi Antipatris péprunam. ");
INSERT INTO jivNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kashin tsawa̱rar suntar aya náwek wearmia nuka waketrarmiayi. Tura kawainium eketrainiaka Pápruja̱i̱ wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Sesaria péprunam jeawar papin Piriksan súsarmiayi. Tura Pápruncha nui̱ ejeniarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Akupniusha papí aujsua amik Páprun aniasmiayi “Amesha, ¿tuí̱ akiiniaitiam?” Tutai “Sirisia nuṉkanmaya̱itjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nuna takui akupin tímiayi “Wátskea kajertamainia nu taar turamainiakui anturkatjame” tímiayi. Tura nuya̱ṉka uunt akupin Erutisa je̱e̱n awayá apujsamiayi, suntar íisarat tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tura seṉku tsawant naṉkaamasa̱i̱ Israer-patri uuntri̱, ni naari̱ Ananías, Sesarianam támiayi. Tura Israer-aentsu uuntri̱ tura ti unuimiaru chichamtincha, ni naari̱ Térturu nuja̱i̱ táarmiayi. Ju̱ aents Páprun kajerainia ásar akupniunam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nui̱ Páprun itiarmatai Térturu chichatan juármiayi. “Uunt akupin Píriks, amesha yaimiu asakmin iisha shiir matsatainiaji. Tura imiá neka asakmin ashí aents tímiatrusrik matsatainiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tuma asakmin iisha ashí matsatmanum tuke tsawant ti shiir yumiṉsamajme, uunta. ");
INSERT INTO jivNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tura amesha ti núkap chicham antuktin nakitiatspash. Tuma asamtai antsu ishichik waitneasam anturtukta, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ju̱ áishmaṉ Papru, suṉkura utsukratniua núniniaiti. Niisha ashí nuṉkanam mesetan najanatniun Israer áentsun ikiakáiniaiti. Tura Jesusa aentsri̱, Nasarénu tuinia nuna úuntri̱nti. ");
INSERT INTO jivNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nú arantcha Yusa Uunt Je̱e̱n yajauch awajsataj tusa pujuru wáinkiar achikmaji. Ii uuntri̱ tana nuja̱i̱ métek asutiátai tusar wakerimji. ");
INSERT INTO jivNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Túrarin nuya̱ṉka kapitián Rísias taa tapit achik jurutramkimiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Tura atumek akupin Piriksa̱i̱ werum nui̱ aujmatkatarum, turamaji, tímiayi. Tuma asamtai amesha Píriks, Papru aniasta. Nuiṉkia ii tájinia nu nekasaiti, nu nekaattame” tímiayi Térturu. ");
INSERT INTO jivNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tura Israer-aents pujuarmia nu “Nekasaiti ashí ni tana nu” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nuyá Píriks, uweje̱ja̱i̱, Papru chichasat tusa iniaktusmiayi. Túram Papru tímiayi “Amesha uunta, ju̱ aentsu akupniuri̱ ti untsurí̱ uwitin pujusuitme. Tuma asamtai nuikia shiir enentáimsan páchitsuk chichastatjai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wats, wi túramur nekartuata. Yúsan áujsataj tusan Jerusaréṉnum wi wémajna nu tuse (12) tsawant naṉkaamasai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nui̱sha yajauch áujmatki weai̱ wáitkiacharmai. Yusa Uunt Je̱e̱ncha tura Israer-shuara aujtai je̱e̱ncha tura pepru jíntianmasha áentsnum charáa charáa ajá wekaai̱ peṉké wáitkiacharmai, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ju̱ aents ju̱i̱ matsatainia nu wíniaka peṉké turutchamnia áiniawai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Túrasha ju̱na paant ujaajme. Jesus yamarman jintíana nuna umíajai. Kame Israer-aentska wáitiaiti tuinia nuna wikia umíajai. Túrasha nuna túran ii uuntri̱ Yusri̱ akupkamia nunak umiktasan pujajai. Jes, ashí Muisais aar akupkamia nuna tura ashí Yúsnan yaunchu etserin aar akupkarmia nunasha uminiaitjai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tura jakaasha nantaktin átatui, tajai. Warí, péṉker aents nútiksaṉ yajauch aencha nantakiartatui imia Israer-shuar tuiniatsuk. Tura wisha nútiksanak túrunatniuiti tajai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tura wisha tiniu asan, wikia winia enentáirui̱ Yus íimmianum makuumatsuk wekasataj tajai. Tura áentsnumsha nútiksanak peṉké makuumatsuk wekaajai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","‘Tura, uunta, untsurí̱ uwitin chíkich chíkich nuṉkanam wekaasuan amikian winia shuarui̱ támajai. Kuítrinchan kuítian susataj tusan tura Yusa kuítri̱ncha nin susataj tusan támajai. ");
INSERT INTO jivNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Túran wisha, Muisais jintinmia nútiksanak nijiaamaran, Yusa Uunt Je̱e̱n pujumiajai. Untsurí̱ aents charaatum ajainiasha atsumiayi. Nui̱ wiki pujái̱ Ásianmaya̱ Israer-aents wáitkiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tura wi yajauch túraitkuiṉkia winia wáitkiarainia nu táchatniukait ámin ujatmaktasa. ");
INSERT INTO jivNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Túrachkuiṉkia jui̱ pujuinia nu, Israer-patri̱ naamkari̱ matsatmanum wi pujumajna nui̱ yajauch túramun nékainiakka turutiarti. ");
INSERT INTO jivNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kame, ““jakamunmaya̱ nantakminiaiti” tau asamtai makuurtiajtsarum pujarme” matsatmanum tímiaj nuja̱i̱ turutchartimpiash. Nú arantka yajauch túramun peṉké nekartuacharmai” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Táman antuk Píriks, Kristu shuari̱ túramun paant nekáa, áanik iniaisamiayi. “Antsu kapitián Risias támatai nuiṉkia nu chichaman nekaatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tura nuyá suntara kapitiántri̱n chichaak “Ju̱ Pápruka tuke emetnati. Tura ishichkikia aṉkant apujsatarum. Tura nuyá ni amikri̱ taa yáiṉtaj takui suritkiairap” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Tura nuyá chíkich tsawantai̱ ataksha Píriks ni nuwe̱ja̱i̱ Tursiraja̱i̱ támiayi. Núwe̱nka Israer-shuarauyayi. Pírikska “Papru itiatarum’ tímiayi. Papru Jesukrístunun étserkui antimiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Tura Pápruka yajauchiniam wekasashtincha naka wekasatniuncha, tura ukunam Yus tunáa áentsnaka asutiátniuiti takui Piríkska ashamak tímiayi “Antsu yamaikia máakete. Tura ataksha wi aṉkant pujakun untsukmijiam” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tura, aṉkant ajastaj tusa Papru kuítian akirkashtimpiash, tu enentáimias, Píriks tuke untsúu wémiayi, chichastai tusa. ");
INSERT INTO jivNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Tura nuya̱ṉka jimiará uwí naṉkaamasmatai Píriks akupin náamkamu ajapnamiayi. Tura chíkich aents, ni naari̱ Pursiu Jistu akupin náamkamiayi. Tura Pírikska, Israer-aents péṉker enentáimtursarat tusa wakerak, Páprun sepunam tuke ikiukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Jístusha akupkatin takatan naṉkaamataj tusa Sesaria péprunam támiayi. Tura menaintiú tsawant naṉkaamasmatai nuyá we Jerusaréṉnum jeamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nui̱sha Israer-patri uuntri̱ tura Israer-aentsu peṉkeri̱sha Páprun tsanumprurtai tusar Jístun weriarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Tura tiarmiayi “Waitneasam Páprusha Jerusaréṉnum akupkata” tiarmiayi. Jintiá maatai tusar wakeruiniak nuna tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Tutai Jistu tímiayi “Atsá. Páprusha Sesaria péprunam sepunam eṉkeamu pujawai. Tura wikia nui̱ wárik waketkittiajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nuyá nin tímiayi “Atumsha peṉkeri̱ árumna nu, wiji̱a̱i̱ Sesarianam wétiniaitrume. Tura nú áishmaṉka tunaari̱ ákuiṉkia nui̱sha títiniaitrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jístuka Jerusaréṉnum ishichik tsawant pujusmiayi. Kame uchu tsawant tura tias tsawantcha pujuschiawash. Nuyá ataksha Sesarianam waketkimiayi. Tura nui̱ jeá kashin tsawa̱r, akupin pujutainium pujus “Papru itiatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tura Papru waya̱mtai, Israer-aents Jerusaréṉnumia̱ taarmia nu káunkarmiayi. Túrawar ti nukap chichainiak “Tunáa túraiti Pápruka” tu tiarmiayi. Túrasha peṉké uyumamtikiacharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pápruka chichamprumak tímiayi “Wisha tunaan peṉké túrachuitjai. Israera uuntri̱ áarmari̱ncha umirkaruitjai. Tura Yusa Uunt Je̱e̱ncha yajauch awajsachuitjai. Tura uunt kapitiánniasha yajauch peṉké chicharkachuitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Jístuka Israer-aents péṉker enentáimtursarat tusa wakerak, Páprun tímiayi “Wakerakmiṉkia Jerusaréṉnum wemí. Wisha nui̱ ame túramurmin nekaatjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Tutai Papru tímiayi “Amesha paant nékame, Israer-áentsnum tunaan peṉké túrachjai. Tuma asamtai Rúmanmaya̱ uunt akupniun wisha winia túramurun ujaktiniaitjai, nekartuati tusan. ");
INSERT INTO jivNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Wisha jakamnia tímianu tunáa túranka, jákatniuncha ashamatsjai. Tura antsu turutainia nu nekaschaitkiuiṉkia wíniaka Israer-shuarnum surunkachminiaitjai tajai. Tuma asamtai seajme, wíi túramun uunt akupin Sésar nekartuati” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tutai, nuyá ni írutramuri̱ji̱a̱i̱ chichasua amik, Jistu Páprun tímiayi “Uunt akupniui̱ wétaj tusam seame. Tuma asamtai nui̱ wétatme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tura ishichik tsawant naṉkaamasmatai akupin Akripia ni nuwe̱ja̱i̱ Piriníseja̱i̱ Jístun áujsataj tusa Sesarianam wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tura untsuri̱ tsawant pujusarmiayi. Tura nui̱ pujuiniai̱ Jístuka Papru túrunamun akupniun ujaak tímiayi “Ju̱i̱ áishmaṉ pujawai. Píriks nin achik eṉkea ikiukmiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kame wikia Jerusaréṉnum pujái̱ Israer-patri uuntri̱ tura Israer-aentsu úuntri̱sha, Papru yajauchin túraiti tusar káutrukarmiayi, tímiayi. Mantamnati tusam akupkata, tu seattiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Takui wi tímiajai “Iisha Rúmanmaya̱ áentstikia chícham nékatsuk, mantamnati tusar akupeatsji. Tsanumpruinia nu, emka táartin áiniawai. Tura nuyá chichamprumatsa̱i̱ṉ mantamnati tusar akupeatsji iisha” tímiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tiniu asan, táarmatai, wikia nákatsuk kashin tsawa̱ran akupin pujutainium pujusan, Papru itiatarum tusan akupkamjai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tura Páprun tsanumprurtai tusar taar chichainiaksha, wi enentáimmiajna núnaka tícharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Antsu áyatik Yus umirkar túmatairi̱n Papru nuna túrachai, tiarmiayi. Tura nuya̱sha áishmaṉ Jesus naartin nantaki iwiaakui tawai Pápruka, tiarmiayi. Nunak tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tura wikia nú chichaman túratniun nékachu asan, Páprun aniasmajai “¿Amesha Jerusaréṉnum wétaj tusam wakeramek? Nui̱ nu chichaman nekartamawarti” tímiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Túrasha “Atsá. Ju̱i̱ṉ pujustajai. Rúmanmaya̱ uunt akupin Akustu Sésar nekartuati” tímiayi Papru. Takui, “nuiṉkia tuke sepunam pujustá. Tura wi ukunam uunt akupniun akuptuktatjame” tímiajai” tímiayi Jistu. ");
INSERT INTO jivNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nuyá Akripia chichaak “Wisha itiursanak nu áishmaṉ chichaamun anturkaj” tímiayi. Tutai Jistu tímiayi “Amesha kashinkia anturkattame”. ");
INSERT INTO jivNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tura kashin tsawa̱r Akripia Piriníseja̱i̱ taar, iwiaa-iwiarmamu ajas waya̱warmiayi. Suntara úuntri̱ji̱a̱i̱ tura nú péprunmaya̱ úuntri̱ji̱a̱i̱ waya̱warmiayi. Tura nui̱ Jistu, “Papru itiatarum” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tura Papru támatai Jistu tímiayi “Uunt Akripia, tura ashí áentstiram matsatrumna nu, pai, ju̱ áishmaṉ íistarum. Ti untsurí̱ Israer-aents Jerusaréṉnumsha tura ju̱i̱ Sesarianmasha ju̱ áishmaṉkan Páprun kajerainiak yajauch chichartuiniawai. Tura tuke iniaitsuk, mantamnatniuiti, turutainiawai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Túrasha wíji̱a̱i̱ṉkia tunáa jakamnianka túrachuiti. Kame niisha “uunt akupin Akustu Sésar nekartuati” takui, wisha nin akupkataj tusan wakerajai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tura wariniak uunt akupniun áatrataj nuna nékachu asan, Páprun atumin itiarjarme. Tura nekaska, Akripia, ame iniasta tusan itiarjame. Túrawakmin wi wariniak áartaj nuna nekaatjai. ");
INSERT INTO jivNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Warí wisha, ni yajauch túramuri̱n áattsuk, uunt akupniunam akupkashtiniaitjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Jistu nuna tutai Akripia Páprun tímiayi “Wats, amesha tu timi chichamprumakta” tímiayi. Tutai Papru uweje̱ takuí chichatan juarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","Chichaak tímiayi “Uunt Akripia, ii Israer-shuarti túrutai ainia nu amesha nékame. Tura ashí ii chicharnaiyajnia nusha nékame. Tuma asamtai yamái wisha ámin chichamprumaktaj tau asan shiir enentáimjai. Israer-aents turutainia nuna mash ujaktatjame. Waitneasam péṉker anturtukta’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","‘Wi úchichik winia nuṉkarui̱ tura Jerusaréṉnumsha pujusan wi túramajna nuna ashí wíi aents Israer ainia nu nékainiawai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Pariséu ajasan, ni akupeamuri̱n itiurchat ai̱ṉ ashí takamtsuk tuke umirniuitjai. Nunasha nékainiawai tura wakeruiniakka etserkamnia aintui. ");
INSERT INTO jivNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Túrasha wikia, jakamunmaya̱ nantaktin átatui, tiniu asamtai wíniaka emetruawar itiariarmiayi. Túrasha núnaka Yuska ii úuntri̱n yaunchu tímiayi. Yus tímia nuna túrunattawai wisha tiniu asamtai itiariarmiayi, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tura ashí mash Israer-shuarti, tuse (12) aents matsatka ájinia nu, ju̱ nantaktin chichaman Yus tímia nuna túrunati tusar nákainiaji. Tuma asar Yus áujkurⁱ, tsawa̱i̱sha káshisha nú enentáimtuiniaji. Tura wisha nú chichamnak enentáimta asamtai wíniaka kajertuiniawai, uunt Akripia. ");
INSERT INTO jivNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Warí, atumsha “Yus jakancha iniantkimniaiti” tátsurmek’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","‘Tura wisha yáunchuka Nasarétnumia̱ Jesusnan umirkaruka kajerkatniuiti, tu enentáimniuyajai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Tura Jerusaréṉnum Yus-shuar ármia nuna kajerkarmiajai. Israer-patri uuntri̱ chichame̱ja̱i̱ untsurí̱ áentsun Jesusnan umirkarmia nuna sepunam eṉkeamiajai. Tura nú shuaran máiniakuisha wikia péṉkeraiti tu wémiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tura Israer-shuara iruntai je̱e̱n waya̱n ti asutiármiajai, Jesusnan umirkatniun iniaisarat tusan. Tura imiá kajerkaran chíkich nuṉkanmasha pataatu wearmiajai achiktaj tusan’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","‘Tura Israer-patri uuntri̱ tsaṉkatrukmatai, papin ni surusarmia nuja̱i̱, Tamasku péprunam wétaj tusan jíinkimiajai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tura, uunta, nantu tutupin a̱i̱, jintiá wéai̱ newaat ajaki ti tsáapin, tsawái nantuja̱i̱ naṉkaamas etsantrutramiayi. Tura wiji̱a̱i̱ wearmia nunasha núnisaraṉ etsantrurarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tura túrunamtai ashí nuṉká tepetar wáinkiarmiaji. Wiki Israer-chichamja̱i̱ túrutun antukmajai “Sauru, Sauru, ¿urukamtai imiá pataaturam? Amek enentáimin yajauch awajmamsame, wáaka saṉkanmiak numin ijiuma núnismek. Wíi aents kajera asam túruname” turutmai.’ ");
INSERT INTO jivNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Túrutkui wisha “¿Amesha yáitiam, Uunta?” tímiajai. Tutai Uunt turutmai “Wisha Jesusaitjai, ame pataatamna núitjai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Tura nantakim wajaktia. Winia takartusminiam tusan wantintiukjame. Tura ame wáinkiamna nusha etserkattame. Tura ukunam wantintiuktatjame. Wáinkiatamna nusha etserkamnium, turutmai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Tura nuya̱sha turutmai, Wats yamaisha Israer-shuarchanum akupkatjame. Tura Israer-shuar kajertamainiakuisha, tura chíkich aents kajertamainiakuisha ayampruktatjame, turutmai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Péṉker jintintiata tusan akupeajme. Kame aencha kiritniumia̱ jíinkiar tsáapninium wekasarat tusan, tura iwianchin umirtsuk Yúsan umirkarat tusan akupeajme. Tura Winia enentáimtursarmatai Wisha ni tunaari̱n tsankurattajai. Nuna túran Yusna ajasaru áiniana nuja̱i̱ apujsattajai.” Nuna Jesus turutmai’ tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","‘Tuma asamtai, uunt Akripia, Uunt Jesus nayaimpinmaya̱ wantintiurak turutmia nuna umirkataj tusan pujajai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Enentai yapaji̱áwar Yus-shuar ajastinian, emka Tamaskunam pujuarmia nuna ujakarmiajai. Tura nuya̱sha Jerusaréṉnumia̱n, Jutía nuṉkanmaya̱ncha tura nútiksanak Israer-shuarchancha nuna ujakarmiajai. Tura ujainiakun “Yus-shuar ajasmarum paant ajasat tusarum, péṉker túratarum” tímiajai ashí shuaran. ");
INSERT INTO jivNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Tura wi Yusa Uunt Jee̱n pujái̱, Israer-shuar achirkar emetruawar mántuatai tukamá tujintrukarmiayi, Yus winia yaintiu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Yus winia yaintiu asamtai, iniaitsuk tuke Yus-Chichaman ujainiajai. Uunt ainia nunasha, tura péejchach ainia nunasha ujainiajai. Tura Muisaissha, Yúsnan etserniusha tiarmia nunak étsereajai. Nú arantka tátsujai. ");
INSERT INTO jivNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Krístuka wáitsatniuyayi, tura jakasha émak nantaktiniuyayi, ii uuntri̱ tiniu ármiayi. Tura Krístuka nantaki Yusa chichame̱n íi áentsun tura Israer-shuarchancha nútiksaṉ ujaktiniuyayi. Nuna tu tiarmiayi. Tura núnaka wisha tu ujainiajai” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Tura nuna takui Jistu kakantar tímiayi “Maaj, Papru, wáurme. Imiá unuimiatu asam wáurkame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Tutai Papru tímiayi “Atsá uunt Jistu, wáurtsujai. Antsu wi tájana nuka ti nekasaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wi tájana nuna, uunt Akripia ju̱i̱ pujana nuka nékawai. Tuma asamtai arantutsuk nin chichareajai. Kame ju̱ túrunamu ti paant asamtai niisha nékawai, tajai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nuyá Akripian chicharuk “Yaunchu Yúsnan etserin áarmari̱, nekasapitia tátsumek, uunt Akripia. Wikia nékajme. Nekasaiti, tame” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Takui Akripia chichaak “Maaj, ishichik awajtame Papru, Yus-shuar ajastin” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Tutai Papru tímiayi “Tura ishichík chichamja̱i̱sha untsurí̱ chichamja̱i̱sha, amesha uunt Akripia, tura ashí winia anturtukurmena nu, wiji̱a̱i̱ métek ajasúk tusan wakerajai. Tura antsu wia núnisaṉ jiṉkiámua núnaka wakeratsjai” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Papru nuna tuasua amikmatai akupniusha, uunt kapitiáncha, Pirinísesha, tura nui̱ ashí pujuarmia nu wajakiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Tura arant wear, túrunamun chichasarmiayi. Tura tiarmiayi “Ju̱ áishmaṉ mantamnamnian tunaamkachuiti tura peṉkesha sepunmasha eṉkeachminiaiti” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tura Akripia Jístun tímiayi “Ju̱ áishmaṉ “uunt akupin nekarati” tíchaitkuiṉkia akupmai makuitji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tura Páprun Ruma péprunam akupkatniun enentáimsarmiayi. Rúmaka tímiai̱, Itiaria nuṉkanam pujawai. Wisha Pápruja̱i̱ wémiajai. Pápruncha tura chikichnasha achikma ármia nunasha Akustunu tutai suntara kapitiántri̱ji̱a̱i̱ nenakar akupkarmiayi. Nú kapitiáni naari̱ Júriuiti. ");
INSERT INTO jivNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tura Atramitiunmaya̱ kanu Asia nuṉkanam pepru ármia nui̱ wétasa pujumia nu eṉkemprarmiaji. Tura Tisarúnikianmaya̱ áishmaṉ, ni naari̱ Aristárku, in páchitkiauyayi. Tisarúnikiasha Masetúnia nuṉkanmaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nui̱ eṉkemprar kashin tsawa̱rar Sitiuṉ péprunam jeamiaji. Nui̱ jeawakrin kapitián Juriu, Páprun waitnentak tímiayi “Ame amikrumi̱i̱n wetá. Au íirmasarti” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tura Sitiuṉnumia̱ jíinkir, kanuja̱i̱ wesar nase tukumpramprakrin Chipri núṉkaka menanmaani aa ikiukmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tura nayaantsanam wesar Sirisia tura Pampiria nuṉkanam aya̱mchik naṉkamakir Mira péprunam jeamiaji. Nuka Risia nuṉkanmaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nui̱ jear nú kanu ikiukmiaji tura chíkich kanu Arijiántrianmaya̱ taa Itiaria nuṉkanam wétasa pujumiayi. Nú kanunam suntara kapitiántri̱, eṉkempratarum, turammiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tura untsurí̱ tsawant yáitmataik we-wémiaji tura ti wiántkar Nítiunam jeastatuk ajasmiaji. Tura nui̱sha nase tuke tukumkarta asamtai Sarmuṉ nuṉkanam aya̱mchik naṉkaamakir, Kritia nuṉkanam áa̱winini aya̱mchik wémiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tura Kritia nuṉkanam aya̱mchik wesar itiurchat akui wáitsar wea-wéakuar “Shiir Pujutai” tutainium jeamiaji. Nusha Rasea péprunam tíjiuchiiti. ");
INSERT INTO jivNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yáitmataik wea asar ti táasmaji. Tura yumi yututai jeatema asa ti tsúumainiuyayi nayaantsanam wétin. ");
INSERT INTO jivNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Tura Papru chicharuk “Amikru antuktarum. Wi nékajai, yamaí wéakrikia ti tsúumainti. Kanusha tura káarak kanunam eṉketainia nusha meṉkarattawai. Tura iisha núnisrik kajiṉchatjiash” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Suntara kapitiántriṉkia Páprunka anturtsuk, kanú wianniuri̱n kapitiántri̱ncha tura kanú kapitiántri̱ncha chichame̱n anturkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tura nui̱ Shiir Pujutai tutainium yumitin pujustin péṉkerchaitkui “Nuiṉkia ju̱ya̱ṉka wéartai. Pinise péprunam jeamainchuashit” ashí tiarmiayi. Nú péprusha Kritia nuṉkanam nayaants aya̱mach pujawai. Nú péprunam yumitin pujustinian wakeriarmiayi, arakia nuṉkaani kakaram nase nú péprunam jeachu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tuma asamtai ukunam nase nuṉkaania̱ tápiriri ajakui, ii wétin yamaikia péṉkeraiti, tu enentáimsarmiayi. Túmakui kanu emetai jiru júusar jíinkir Krítianam aya̱mchik wearmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Túrasha árusaṉ arakia̱ kakaram nase, Nuristi tuinia nu tukumpramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nase kanun tukumpra asamtai iisha atsantratin peṉké tujinkiamiaji. Túmakui, áankisha juramkitiai tusar iniaisamiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tura Kritia nuṉkanam áa̱winini naṉkaamakur nuiṉkia nase ishichik mijiantmatai, uchich kanu japikir wémiaj nu ti takasar uunt kanunam eṉkermiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Tura eṉkerar chapikja̱i̱ uunt kanun jiṉkiárarmiayi wewe najanatai tusar. Tura náikim mukutniunam, Serti tutainium nase juramkishtajiash tusar, kanunam yakí tarach aan itiararmiayi. Nu tarach nase útsuktin tusar nenarma ármiayi. Túrawar áyatik nase juramkitiai, tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tura kashin tsawa̱rmatai nasesha chíchimisha tímiatrusaṉ kakaram aa asamtai kanunmaya̱n káarak irunmia nuna nayaantsanam ajapawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Menaintiú tsawant naṉkaamasmatai iisha ii uwejé̱ja̱i̱ṉ kanunam kárak iruniarmia nusha entsá utsaṉkarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tura untsurí̱ tsawant tsawa̱i̱sha etsantrachmiayi tura káshisha yaasha tsaparcharmiayi. Tura nasesha ti kakantar tukumpramkurin “Yamaikia uwempratin atsawai” tiarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tura iisha ti untsurí̱ tsawant yurumtsuk matsatu asakrin, Papru ajapén wajaki tímiayi “Amikru winia nuik Krítianmaya̱ṉka jíintsuk anturtukuitkiurmiṉkia yamái ju̱ itiurchatnum pujutsuk tura emeṉkatmatsuk pujua̱a̱ji’ tímiayi.’ ");
INSERT INTO jivNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","24","‘Yamái kashi winia Yusru suntari̱ nayaimpinmaya̱ wantintiurkayi. Nú Yúsan umirkaitjiana nu akupturkayi. Tura nu taruti “Ashamkaipia Papru, turutui. Amesha Ruma péprunam uunt akupniunam jeattame. Tura chikichnasha ámiji̱a̱i̱ kanunam eṉketainia ásarmatai uwempratniun Yus tsaṉkatkarai” turutui. Tuma asamtai, amikru, shiir enentáimsatarum. Atumsha mash uwemprattarme. Túrasha kánuka mesertatui. ");
INSERT INTO jivNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Wisha winia Yúsrun nekas enentáimtajai. Yusa suntari̱ turutainia nuna nekas tu túrunattawai, tajai. Tuma asamtai kaka̱rtarum. ");
INSERT INTO jivNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tura chíchimisha nuṉka uchich pújakmanum nui̱ patatmittiaji” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ayu, katurse (14) tsawant naṉkaamasmatai nú kashi Atria nayaantsanam jeamiaji. Nui̱ nase náṉkamas juram wémiaji. Nuya̱ṉka kashi ajapéṉ wiantin armia nu nuṉka ámunam jeateman nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Tura urutmá kúnakit tusa nekapmamiayi. Túram tráinta sais (36) mítruuyayi. Nuya̱sha ékemsaṉ ataksha nekapmamiayi. Nuiṉkia painti siati (27) mítru nekapmamiayi. Tuma asa nuṉká anumsatuk ajasun nekaawarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tura kayanam ijiuka̱i̱ tusar ashamainiak kuatru jirun kijinian chapikja̱i̱ kanú seṉkarin jiṉkiáwar entsá ajuṉkarmiayi. Kijin asamtai, init tepeámtai nase juramkichmi tusar túrawarmiayi. Tura wake mesekar, tsawa̱rti tusar matsamarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tura matsatainiai̱ wiantin armia nu, iikia uchich kanunam eṉkemprar pisarchatjiash tu enentáimsarmiayi. Túmainiak kanú nujinia chíkich jirun ajuṉtai tawa nútiksaraṉ uchich kanun ajuṉtai tusar pujuarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Tura tuma wáiniak Papru suntara kapitiántri̱n tura ni suntari̱ncha ujakmiayi. “Ausha uunt kanunmaṉ eṉketainiachkuiṉkia atumsha uwemprashtatrume” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tutai suntarsha uchich kanú chapikri̱n tsupirkar entsá ajuṉkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Tura kashin káshik Papru ikiakártasa wakerak tímiayi “Ishichkisha yurumátarum. Atumsha katurse (14) tsawant kánutsuk yurumtsuk pujarme. ");
INSERT INTO jivNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Seajrume, ishichkisha yurumárum kakaram ajastarum, uwemprataj tusarum. Iimiata, nekaatarum, imiatkisha túmatsuk péemkattarme” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nuna tuasua amik Papru apatkun achik Yúsan yumiṉsamiayi ashí íimmianumaṉ. Tura puuk yuamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tura apatkun yuan wáinkiar, ashí aents shiir enentáimsar yurumáwarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nusha ashí aents irurmaka jimiará siáṉ nuyá ataksha setenta sais (276) ármiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yurumáwar ejemakar, yurumkanka entsá utsaṉkarmiayi, uunt kanu wampú ajasat tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Tura tsawa̱rmatai wiantin armia nu, nuṉkan nekaacharmiayi. Túrasha éṉkentamunam káanmatak aan wáinkiar “A̱i̱ kanu anuṉtai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nuyá jiru entsá ajuṉman chapikri̱n tsupirkar entsá ikiukiarmiayi. Tura kanait jiṉkiárma ármia nuna chapikri̱n tsupirkarmiayi. Tura tarach kanú nuji̱i̱n amia nuna nenakarmiayi. Túram kanu káanmatkanam anumsatuk ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Tura wainchi jímiar ámunam jeá kanu entsá wayá tepeamiayi. Tura kanú seṉkariṉkia chíchimi yakí takuir ajíamu asa kupintramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Suntarsha, achik júamu armia nú shuaran máataj tusa wakeriarmiayi, yukuak pisarara̱i̱ṉ tusar. ");
INSERT INTO jivNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tura kapitiáncha Páprun uwemtikrataj tau asa nuna túratniun tsaṉkatkachmiayi. Antsu chichaak “Emka yukuaktin nékarmena nu yukuakrum péemkatarum, tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nuyá chíkichkia kanunmaya̱ numi, kame náṉkamas numi achikrum awamkarum péemkatarum” tímiayi. Tu túrawar ashí iwiaakuk jíintrarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tura ashí iwiaakuk jíintrar, nu nuṉka Marta naartin nekaamiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tura nui̱ matsamin armia nu, shiir awajtamsarmiaji. Tuma asamtai iisha tsetsema asakrin, tura yumisha yútakui, uunt jinia ikiapárarmiayi. Tura “anamaitiarum” turammaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pápruka jinia kukarun ikiaanak jinium pataamiayi. Túmawai̱ napi tsuéran ashamak jiinki, Papru uwejé̱n nemaramiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tura nú nuṉkanmaya̱ aents, Papru uwejé̱n napi nemaran wáinkiar “Ju̱ áishmaṉsha shuáran mai̱chuashit, tiarmiayi. Nayaantsanmaya̱ uwempraitiataṉ ni yusri̱ iwiaaku átinian suritiawai” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Páprusha ni uwejé̱n pe̱ar napin jinium awaṉmiayi. Tura peṉkesha yajauch ajaschamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tura niisha eárchatpiash tusar ii pujuarmiayi. “Túmatskesha jaka inianchatpiash” tiarmiayi. Túrasha ti núkap pujussha peṉké najawe̱achmiayi. Túrunamtai, nuiṉkia nusháa enentáimprar “Pápruka yúschashit” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nú nuṉkanam aentsu peṉkeri̱ ámiayi ni naari̱ Pupriu. Nú Pupriu ni je̱e̱n in itiaarmamiaji. Tura menaintiú tsawant yurumkancha suramsarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tura nui̱ pujarin Pupriu apari̱ tsue̱r, numpaja̱i̱ ijiarki jáamiayi. Túmakui Papru werí iyumiayi. Tura Yúsan áujtus amik uwejé̱n nin awantkamiayi. Túram péṉker ajasmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nu túramun nekaawar, nú nuṉkanmaya̱ aents jaa armia nu tariar, niisha péṉker ajasarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Túram incha ti shiir enentáimturmasar núkap ajampramsamiaji. Túram ukunam ii wétin jeamtai ashí ii atsumamun suramsarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ii wétsuk nú nuṉkanam menaintiú nantu pujusmiaji. Tura nuyá chíkich kanunam eṉkempramiaji. Nu kanusha Arijiántrianmaya̱ yaunchu tau menaintiú nantu yumi yútakui nui̱ pujumiayi. Nú kanu nuji̱i̱n numi-yus najankamu jímiar ekemiarmiayi, ni náariṉkia Kástur tura Púruks. ");
INSERT INTO jivNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Iisha nui̱ eṉkemprar weri Serakúsa péprunam jeamiaji. Nui̱ menaintiú tsawant pujusarmiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tura jíinkir nuya̱ṉka nayaantsa aya̱mach weri Rijiu péprunam jeamiaji. Nui̱ kanarmiaji. Tura kashin anaria̱ nase suut umpuunti támiayi. Tuma asamtai nú kashinkia Putiuri péprunam jeamiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nui̱ jeawakrin Yus-shuar pujuarmia nu, ni je̱e̱n juramkimiaji. Tuma asamtai nui̱ṉ chikichkí tumiṉ pujusmiaji. Tura nuya̱ṉka nuṉkaṉ Rúmanmaani wémiaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tura Rúmanmaya̱ Yus-shuar, ii jeatniuri̱n neka ásar jintiá iṉkiunmaktai tusar winiarmiayi. Chíkichkia Apiu pepru támanum táarmiayi, tura chíkichkia, Menaintiu Je̱a̱ tutainium táarmiayi. Nuna káunkan wáiniak Papru shiir enentáimias Yúsan yumiṉsamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tura ii Rúmanam jeawakrin kapitián Juriu achikia yarumman Rúmanmaya̱ uunt kapitiánin ejetimiayi. Túrasha, Pápruka je̱a̱ ikiamas niisháa pujustí, tiarmiayi. Tura Páprun íisat tusa chikichík suntarnak ni je̱e̱n apujtusarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nuyá menaintiú tsawant naṉkaamasmatai Pápruka Rúmanmaya̱ Israer-aentsu peṉkeri̱n untsuk ikiaanak “Yatsurtiram antuktarum. Wisha Israer-áentsun yajauchin peṉké túrachmiajai. Tura ii uuntri̱ akupkarmia nunasha yajauch chicharkachmiajai. Tuma aiṉ Jerusaréṉnum winia achirkar Rúmanmaya̱ áentsnum surutkarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tura nu aencha winia anintsar, akupkatai, turutiarmiayi, wisha peṉké yajauchin, mantamnamnia tímianu túrachu asamtai. ");
INSERT INTO jivNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Túrasha Israer-shuarka “Atsá, akupkairap” turutiarmiayi. Nu tuma asamtai, “antsu uunt akupin nekarati” tímiajai. Wikia wíi shuara tunaari̱n kapitiánin ujaktinian táchaitjai. ");
INSERT INTO jivNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Tuma asamtai, yatsurtirmin, atumin untsukjarme chichastaj tusan. Yusa anaikiamuri̱, Israer-shuarti nákajnia nu táwiti wi tu étserkui, ju̱i̱ achikiar jiṉkiámu pujajai” tímiayi Papru. ");
INSERT INTO jivNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Tutai niisha tiarmiayi “Iisha Jutía nuṉkanmaya̱ aentsti, ame yajauch túramu papí peṉké wáinkiachuitji. Tura ii shuar nuyá táarainia nusha “au yajauch túraiti” tu ujatmakcharmaji. ");
INSERT INTO jivNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Túrasha ashí nuṉkanam yamaram chichaman jintinian yajauch chicharainiawai tama antukji. Tuma asamtai amesha nu warintia enentáimtam nekaatai tusar wakeraji” tiarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nú tsawantai̱ iruntrami tiarmia nú tsawant jeamtai, ti untsuri̱ aents Papru pujamunam iruntrarmiayi. Papru jintintiainiak Muisais yaunchu aar akupkamia nuja̱i̱ tura chíkich Yúsnan etserniu aarmari̱ji̱a̱i̱sha, Jesus nekas Yusa Anaikiamuri̱nti tusa paant jintintiawarmiayi. Nuna tura káshik naṉkaama Yus akupeamunam pachiinkiatniun étse-étserkua ki̱arai̱ iniaisamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Tura Papru táman antukarmia nu, chíkichkia, nekasaiti tusar umikiarmiayi. Tura antsu chíkichkia, nekaschaiti tusar umikcharmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Chikichkí enentaikⁱ enentáimsatin atsá asamtai, jiinki weartasa pujuarmiayi. Túmainiakui Papru chichaak “Nékaseṉ Yusa Wakaní̱ yaunchu Yúsnan etserniu, Isayas naartin áarmari̱ji̱a̱i̱ ii úuntri̱n chicharuk ju̱na tímiayi: ");
INSERT INTO jivNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Ame weme au aents ju̱ titia: “Ántutka ántakrumsha nekaashtatrume, Íitkia iyakrumsha wáinkiashtatrume. ");
INSERT INTO jivNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Warí, au shuara enentái̱ katsua̱rai; Kuishi̱ji̱a̱i̱ ántaksha ántichua núnin áiniawai, Ji̱isha epetkamua áanin áiniawai, Iyaksha wáinkia̱i̱ṉ tusa, ántaksha antuka̱i̱ṉ tusa Enentáimkiusha nekaawa̱i̱ṉ tusa, Winí uwempra̱i̱ṉ tusa, tura Winí tsuamara̱i̱ṉ tusa túrunayi”. Nuní áarmaiti. ");
INSERT INTO jivNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Tuma asamtai, nekaatarum. Yamaikia Yusai̱ uwempratin ana nuna Israer-shuarsha susamuiti. Tura niṉkia nekas umikiartatui” tímiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Tura Papru nuna ti̱ iniaisamtai Israer-shuar nuamtak núkap chicharnaiyasua wearmiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Tura Pápruka nui̱ṉ je̱a̱ ikiamsamunam jimiará uwí pujusmiayi. Tura ashí aents nin iyutaj tusa wearmia nuna ni je̱e̱n itiaamiayi. ");
INSERT INTO jivNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tuma asamtai Papru arantutsuk urukuk Yus akupeamunam ati, Uunt Jesukrístu túramuri̱ncha ashí etserkamiayi. Nútiksaṉ etserkatniuncha Páprun peṉké suritkiacharmiayi.");
INSERT INTO jivNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Wi Papru Jesukrístu takarniuitjai. Núnisaṉ Yus achirak ni Shiir Chichame̱n etserkat tusa akatar akuptukmiayi. ");
INSERT INTO jivNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nu Chichamun Yus yaunchu “akupkattajai” tímiayi. Núnaka Yúsnan etserin Yus-Papinium paant ujakarmiayi. ");
INSERT INTO jivNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Nu Chichamnum Yus ni Uchiri̱n áujmatui. Aya̱shi̱ji̱a̱i̱ṉkia Tawit weeanum akiiniamiayi. ");
INSERT INTO jivNT_vpl VALUES ("RM1_4","075_1_