﻿USE sofia;
DROP TABLE IF EXISTS sofia.jid_vpl;
CREATE TABLE jid_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jid_vpl WRITE;
INSERT INTO jid_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Vuvu u Yesu Kristi ivren Dauda, ivren u Ibrahim. ");
INSERT INTO jid_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim a ngrji Ishaku, Ishaku ka ngrji Yakubu, u Yakubu a ngrji Yahuda ni ba mrli vayi ma. ");
INSERT INTO jid_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda a ngrji Perez mba Zerah ngrji u Tamar, Perez ngrji Hezron, u Hezron ngrji Ram. ");
INSERT INTO jid_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ngrji Amminadah, Amminadah ngrji Nahshon, u Nahshon ngrji Salmon. ");
INSERT INTO jid_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ngrji Boaz ngrji Rahab, Baoz ngrji Obadiya ngrji u Rautha, Obadiya ngrji Jesse. ");
INSERT INTO jid_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","U Jesse ngrji ichu Dauda. Ichu Dauda ngrji Suleman wa iyima ana wa Uraya ");
INSERT INTO jid_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleman a nu ngrji Rehoboam, Rehoboam a ngrji Abijah u Abijah ngrji Asa. ");
INSERT INTO jid_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngrji Jehoshafat, Jehoshafat ngrji Joram, Joram ngrji Uzziya. ");
INSERT INTO jid_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziya ngrji Jotham, Jotham ngrji Ahaz u Ahaz ngrji Hezekaya. ");
INSERT INTO jid_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hazekaya a ngrji Manaseh, Manaseh a ngrji Amon u Amon ngrji Yosiya. ");
INSERT INTO jid_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya ngrji Yekoniya ni mrli vayi ma wiere me ni nton wa ba vu ba hi ni Babila. ");
INSERT INTO jid_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","U wa ba nji ye Babila, Yekoniya ngrji Shealtiel u Shealtiel ngrji Yerubabel. ");
INSERT INTO jid_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Yerubabel ngrji Abuid, Abuid ngrji Eliakim, u Eliakim ngrji Azor. ");
INSERT INTO jid_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ngrji Zadok, Zadok ngrji Achim u Achim ngrji Eliud. ");
INSERT INTO jid_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ngrji Eleazer, Eleazer ");
INSERT INTO jid_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ngrji Matthan, u Matthan ngrji Yakubu. U Yakubu ngrji Yusufu illon Maryamu wa a ngrji Yesu wa ba yo'u din Kristi. ");
INSERT INTO jid_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","To inzan ba wawu rji ni Ibrahim hi Dauda ba wlon don zia, rji ni Dauda hi ntton wa ba vu hi ni Babila bahi izan zia, u rji ni ni ntton u wa bahe ni Babila hi ni ye Kristi ba nzan wlon don zia. ");
INSERT INTO jid_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ingrji Yesu Kristi ahe towa: wa ba nna yima Maryamu ni Yusufu gben ntton wa baka gran kpa, u nne Ruhu tsatsar ye riwu. ");
INSERT INTO jid_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","U Yusufu illon ma indi u klu Rji, nda na son nno shan na, a cu sron ma rju ni gran nda kama ni wu niyay'bi (aboye) ");
INSERT INTO jid_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amma, asi tamre towa, u malaika Baci ka ye niwu ni rah nda tre, “Yusufu, ivren Dauda, na klu sisri ban wame Maryamu na, don ikpie a wrji anne ma, a u Ruhu tsatsar. ");
INSERT INTO jid_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ani ngrji vrenlon wa u yowu ndi Yesu, don ani kpa ndi ma cuwo ni gbugbu latre mba. ");
INSERT INTO jid_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","To, ahe to yi don ndu tre Baci he na wa a hla din. ");
INSERT INTO jid_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“To mba, vivren wa ri wa ana to lillona ani ye he nne nda ngrji vrenlon wa ba yo wa ndi Imanuwal” wa hi riri ni “Irji he nita” ");
INSERT INTO jid_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","U Yusufu, gbla sh'me ni nah tie ikpie wa Malaika hla niwu nda hi ka ban wa-a hi ni kpama. ");
INSERT INTO jid_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ana rlihe toh wa-a sai wa a ngrji vren ma u mumla. Ayo nde ma di Yesu. ");
INSERT INTO jid_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Da ba ngrji Yesu ni Betalahim u Yahudiya ni ntton wu chu Fero, indi bi toh bari baa ye rji ni Urushalima, ");
INSERT INTO jid_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ba tre ichu Yahudawa wa ba ngrji wu'a he mame? Kie toh Tsitsen ma ni ko Nzan u kie ye chi. ");
INSERT INTO jid_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Niwo tre yi, Fero ka katie gbododo (wieme) me ni indi bi Urushalima wawu mba wu. ");
INSERT INTO jid_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Da ayo firist bi ni nkon ni bi nha u ndi mba a mye ba ka bandi toh wrji wa ba ngrji Kristi a? ");
INSERT INTO jid_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","U baka hla wu Ni Batakami u Yahudiya a na ki anabawa ba nha, ");
INSERT INTO jid_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Iwu me' Batalami, igbu Yahudiya ana hi wuyi u nkle ni mi ba chu bi gbu Yahuda na: to gona wa ani nji ndimu Israila ani rji niwu. ");
INSERT INTO jid_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hirudus ka yo shehuna ba ni yaybi nda mla wo inton wa to tsintsen'a. ");
INSERT INTO jid_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A tonba hi Baitalami nda tre, Hi yi', hu sren me di mla wo tre' u vrenyi, biti tou bika ye hlamu, ndu me ngame ye ciwu. ");
INSERT INTO jid_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Da ba wo tre chua kle, ba ka wlu hi nda to, tsitsen wa bana tou ni ki nzan, azren guci sihi ni ko shishi mba, nda zren hito ki me aka kukrli gyame ni bubu wa ivren he'a. ");
INSERT INTO jid_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Da ba to vren baka ngri nda briku. ");
INSERT INTO jid_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba ri nimi koha nda to kpran vrena mba yi ma Maryamu nda ti gbru kukru nda ciu nda bwu ikpi wa ba nji'a nda nno; Zinariya mba Lubban u jawul. ");
INSERT INTO jid_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","U Irji ka ti ba rah ndu bana lahi zu ni Hiridus ngana ba wlu zu nkon ri nka hi gbumba. ");
INSERT INTO jid_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Niwa ba wlu hu, u malaika Rji kaye ni Isuwu ni rah nda hla wu, “Wlu, ban vren'a mba yima, ndi tsutsu hi ni Masar, son niki me di la ka wo ni me rli: Hiridus niwa wu kpran vren'a. ");
INSERT INTO jid_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wa aye wlu'a a bari kpran vren'a ba yima ni cuu nda tsutsu hi ni Masar; ");
INSERT INTO jid_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nda he niki me ye mla niqu Hiridus: wa aku gyre me ni tre Baci wa a hla ni ngu Anabi, din nimi Masar mi yo' vren mu. ");
INSERT INTO jid_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hiridus a ye to di shehuna ba yau hlega ni tre ma, nda tie vrafu nda ndu ba wu mrli nlon bi Batalami, ni bi gbu wa ba he nha niwu'a bi wa ise mba a mla harli kima krji; bla rji ni nton wa a wo trea ni shehuna ba. ");
INSERT INTO jid_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rli kuko u ikpie wa ba hla ni nyu anabi Irimiya kaye ku tsra, ");
INSERT INTO jid_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ba wo lan nimi Rama, iyi mba jequ, Rahila aniyi ni tu mrli ma, nda na wo wiere na wa mrli ba ba qu'a ");
INSERT INTO jid_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hiridus ye qu u malaika Baci ka ye ni Isuwa ni rah ni mi Masar, nda hla, ");
INSERT INTO jid_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wu ban kpran vren'a mba yima di hi ni meme Israila: e bi wa bazi wa wu kpran vrenia ba qu ye. ");
INSERT INTO jid_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A ye wlu nda ba kpranvren'a ni yima nda ye ni mi meme Israila. ");
INSERT INTO jid_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wa'a wo ndi Arkilaus a kpa chu u tiema Hiridus nda nji Yahudiya a klu sisri uhi ni ki, u Rji ka tsro ni rah ndu vu y'ba hi ni meme Galili. ");
INSERT INTO jid_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aye nda ka son ni gburi wa ba yowu ndi Nazarat: ndu ikpie wa ba hla ni nyu anabawa ndu he me, ba yowu u-Nazarat. ");
INSERT INTO jid_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ni nton kima Yohana u tie Batisma a ye tren njo Rji ni miji u Yahudiya; ");
INSERT INTO jid_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nda ni wa, ka meme cuwo; mulki shulu a tiewiere. ");
INSERT INTO jid_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ahi wawuyi ba tre ni nyu anabi Ishaya nda hla. Ilan uyo rji ni miji mla nkon Baci tie mla zren mbi tie. ");
INSERT INTO jid_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana ata sru kpie u nfu laklumi nda lo ntan u birli me ana hi lagblan mba ton u miji. ");
INSERT INTO jid_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Indi bi Urushalima ni bi wa ba he kagon igbu bi urdu ba rju wawuu ye. ");
INSERT INTO jid_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A tie batisma ni bawu ni nne urdu u bata hla' la' tre mba. ");
INSERT INTO jid_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A to gbugbu Farisawa ni Saddukiyawa ba ye ndu tie batisma bawu a hla ni bawu biyi mrli grace, ahi nha hla yiwu ndu yi klu ifu wa asi ye'a? ");
INSERT INTO jid_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nji mrli wa ba tsar u mla latre mbatie'a ye: ");
INSERT INTO jid_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na tamre ndi bi hla ni kpa mbi ndi kie he ni tie mbu Ibrahim; to misi hla yiwu ni mi tita biyi Irji he gbengblen u ka mba tie imrli Ibrahim. ");
INSERT INTO jid_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Zizanyime bayo gla ni nci kukron ba: kukron wa ana tie klo didi mana ba tsenwu nda kasru ni lu: ");
INSERT INTO jid_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ime mi tie batisma yiwu ni maa u ka latre mbi cuwo amma uwa aniye kogon mua a' nna' me ni gbengblen mina mla u si rjirji lagban ma na: wawuyi ni tie batisma yiwu ni Brji tsatsar mba lu' ngame: ");
INSERT INTO jid_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mwu mwu ma he ni wo ma ani tsen alkama nda vu bi didi ba sru wruon, u nfon ma ani gonwu ni kpatren lu' wa ana y'bi na'. ");
INSERT INTO jid_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Rliko Yesu a wlu ni Galili hi ni urdu ni Yohana ni ndu tie batisma niwu. ");
INSERT INTO jid_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","U Yohana ka tie' san nda tre mi si son ndu tie batisma ni mu, i wu la' ye' ni me? ");
INSERT INTO jid_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu a kasa niwu nda tre uka y'me zizanyi: towa ahe tie nkon ni tawu ndu ta kle indu tsatsar wawuu Rliko Yohana ka y'me niwu. ");
INSERT INTO jid_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","U Yesu, wa ba tie batisma niwu'a ani rju ni maa me u shulu ba ka bwu niwu a to Ibriji Rji grji na ngwu ye ku son niwu ni tu. ");
INSERT INTO jid_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","U lan ka rji na shulu nda tre, Iwayi ahi kponji vrenmu idrimu ni ngri ni wu. ");
INSERT INTO jid_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nikiyi Ibrji ka nji Yesu hi ni kpatren miyi ni ndu shetan tsrawu. ");
INSERT INTO jid_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","U wa Yesu a vu nyu ivi ni cu ise zia u yon katiewu. ");
INSERT INTO jid_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","U wa ani tsar-a aye nda tre, uti ivren Rji uka hla tita biya ndu mba katie bredi. ");
INSERT INTO jid_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","U akasa niwu din Ba nha ana ni birli megyen mba ani ndu ndi son sisren na. ");
INSERT INTO jid_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","U shetan nji wu hi ni mi Urushalima igbu u tsartsar-nda njiwu hon hi ni ngbondo tu tra u Baci. ");
INSERT INTO jid_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A hla ni wu uta hi vren Rji uka grji joko kime: e ba nha di ani ton malaikuma ye wu ndu ba kon wu kpa ni wo mba ni ndu na k'bu za ni tita na. ");
INSERT INTO jid_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a saa' wu ba nha una tsra Baci Eji me to na. ");
INSERT INTO jid_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Garli shetan a jinwu hon hi ni tu ngbondo ngblu ri nda tsro wu ikpi bi ngbugblu ba wawuu ni bii mba. ");
INSERT INTO jid_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A hla wu ikpi biyi wawu mbawu mi nno mba ka uti kukru ndi gbyre me san. ");
INSERT INTO jid_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Niki Yesu saa' wu dinkon wa iwu shetan ba nha u gbyre Baci Rji me san wawu yi ni nklen ma u gbyre u san. ");
INSERT INTO jid_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nikiyi shetan ka hi kpama; malaiku baka ye zou. ");
INSERT INTO jid_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ba heme u Yesu awo din ba tro Yohana ni Galili, ");
INSERT INTO jid_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A wlu ni Nazarat nda hini mi Kafanahum, u nyu kiekle nne'a ni mi koton Zabulu mba Naftalim: ");
INSERT INTO jid_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Din ndu tre anabi Ishaya ku toar, towa. ");
INSERT INTO jid_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Meme Zabulun mba meme Naftalim ni nkon kiekle nne vu y'ba hi ni kogran urdu mba Galili u indi wa bana Yahudawa naa. ");
INSERT INTO jid_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Indi bi wa ba zia ki ni' bwu'a Ba to' kickle kpan, u' bi wa ba zia son ni mi qu mba ni mi yumu'a Ikpan wlu ye mba wu. ");
INSERT INTO jid_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Rji ni nton kima Yesu a wlu zi wa tre Baci di ka me'me' cuwo: mulki shulu a tiewiere. ");
INSERT INTO jid_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu si zren ni nyu kiekle nne Galili, a to ndi harli bari ba mrli vayi siman wa bata you ndi Bitru, u Andoro vayima bana bi vu lambe nda si sru rjiji u vu lambe ba. ");
INSERT INTO jid_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A tre ni ba hume yi ume mi kayi tie bi vu ndi. ");
INSERT INTO jid_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nikime ba kaa rjirji u vu lambe ba don nda huu. ");
INSERT INTO jid_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A wlu niki sihi nda ka to indi harli wa ba mrli vayi, Yakubu ivren Zabadi mba Yohana vayi ma; nimi jirgi bi nha ni tie mba Zabadi ba ki mla rjirji u vu lambe mba tie nda yo ba. ");
INSERT INTO jid_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ba ka jirgi'a don ni tie mba nda tie gbla hu. ");
INSERT INTO jid_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu a zren kagon Galili wawuu nda zi tsro ni tra Rji nda bla tre zizi u mulki nda den bi lilo wawuu ni san lilo wa ndi ba ba' lo'a. ");
INSERT INTO jid_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iddu ma ka shanshu ni suriya wawuui baka rji bi lilo wawuu ye wu ndi bi wa ba lo'a ko bi lilo rimie, ni bi wa ba ku gbingbi ni bi wa ba he ni meme brji'a ni bi sran ni bi wa ba qu kpa-a waka den ba wawuu. ");
INSERT INTO jid_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gbugbu ndi ba huu rji ni Galili ni Dakapolis ni Urushalima ni Yahudiya ni kogmn urdu. ");
INSERT INTO jid_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ni to gbugbu ndi ba, a hon hi ngblu ri ni kuson ma mrli koh ma baka ye ni wu. ");
INSERT INTO jid_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ka bwu nyu ma nda tsro ba nda tre: ");
INSERT INTO jid_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Lulu ahi u bi ya ni brji didi, ikoh shulu ahi u mba. ");
INSERT INTO jid_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lulu ahi u bi yiqu, e ba nno ba sisron. ");
INSERT INTO jid_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bi lulu ba bi wa bana nzu tu na, ba nji meme u ngbugblu. ");
INSERT INTO jid_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bi lulu ba bi tie yon nda tie hlama zizi, e ba wrji. ");
INSERT INTO jid_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bi lulu ba bi lo sron e ba kpa lo sron me. ");
INSERT INTO jid_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bi lulu babi wa isron mba a kheklan me e ba toh rji. ");
INSERT INTO jid_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bi lulu ba bi wa ba wa sonsi, e ba yo ba mrli Rji. ");
INSERT INTO jid_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bi lulu ba ba wa ba tie ba ya nitu zizi mba, e ikoh shulu ahi u mba. ");
INSERT INTO jid_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bi lulu a biyi wa bati mre yi nda tieyi ya, nda wa meme tre nicece wu yiwu ni tu mu, ");
INSERT INTO jid_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ngri di briku kpukpome, e bi he ni kickle dii ni shulu, e bati ni anabawa bi sen nakii. ");
INSERT INTO jid_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Bi mah u ngbungblu, u mah nita tie meme u ani la u tie gye garli? Ana la bi utie kpie na, ahi u ka hlega u ndi baka canwu niza. ");
INSERT INTO jid_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Bi kpan u ngbungbu. Igbu wa ba mewu ni tu ngblu'a ana riri na. ");
INSERT INTO jid_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","U bana yo lu ni fitila nda kayo ni sisen na di ba kauzi tsame nitu kukron ma wani nno kpan ni ndi bi koha wawuu. ");
INSERT INTO jid_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ndu kpan me shan tsro ndi, di ndu ba to ibi ndu me nda gbire tieme wa ahe ni shu'a san. ");
INSERT INTO jid_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na tamre di meye kpa nji tre anabawa ba tie meme na. Mi naye kpa tie meme na, mi ye tie wu tsra. ");
INSERT INTO jid_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Njanjimu, me hla yiwu, shulu mba ngbungblu ba tana kle na, ikpie riri me ni nji tre'a na joku megyen na, ba ku tsra. ");
INSERT INTO jid_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Indi wa a kunyre ni ri u nklekyen nji tre'a nda tsro ba ni ndi, ani vi nklekyen ma ni ikoh u shulu, u iwa ani hu nda tsro ba, ba yo ndi kiekle ni koh u shulu. ");
INSERT INTO jid_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","To mesi hla yiwu din, zizi me nita na nna' zizi bi nha ni Farisawa na bi na he nkon u ri ni koh u shulu na. ");
INSERT INTO jid_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Bi wo ndi ba tre ni ndi bi sen, 'Na wu na, u indi wa a wu-a, ahe ni nyu ya'u shariya. ");
INSERT INTO jid_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Me wa yiwu ndi iwa a tie nfu ni vayi ma hama ni kpie wa anno nfu'a a si gbyen shariya. U indi wa a hla ni vayi ma, 'Racah!' a si gbyen tre ni tuma. Iwa a hla ndi, 'Ruru' asi hi kpentren lu. ");
INSERT INTO jid_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Uti ye' nno kpie ni tra Rji, ndi taka vayi me ahe ni tre ni tu me'a, ");
INSERT INTO jid_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","U ka donme ni nno' kpie'a ni tra Rji, ndi hi mla kpambi tie mbi vayi me rli ndi ye nno' kpiea. ");
INSERT INTO jid_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mlatie kpa y'me ni ndi wa a nji wu hi ni bi bla tre gbagbla, Ka'bi he nkon sihi mbi wu ni bla tre'a, ni ndu bana lowu na. ");
INSERT INTO jid_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Njanjinmu, me hla yiwu, biti hanwu kle wawuu rliko ka kayi cuwo. ");
INSERT INTO jid_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Biwo' din ba hla ni bi sen, 'una tsi wa lilon ko wa mba tankpan na'. ");
INSERT INTO jid_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mi wa yiwu, indi wa ani kaya wa' ni mew u tohwu ka a kruu ye ni mi sron ma. ");
INSERT INTO jid_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Shishi ko rli anita ni ndu latre, uka krewu rju taga; a bi ndu nhama kpa ri ndu tiw meme niwa ikpa'a wawuu ndu tie memela. ");
INSERT INTO jid_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","U iwo me koeli nita ni ndu latre, uka sren wurju kpame; abi nna ndu nhama kpa ri ndu tie meme niwa ikpa'a wawuu ndu rii ni lu'. ");
INSERT INTO jid_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A kru hi me, ba hla di ndi wa a wuugran ni wama'a, ka nno imbe u wu gran a. ");
INSERT INTO jid_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","To, mi hla yiwu di indi wa wu gran wamaa, wana he ni tu tie tankpan na, to a yo wu ni latre tie tankpan, u ndi wa a gran wa bi wa ki a latre u kru tankpan. ");
INSERT INTO jid_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ganli, biwo ikpie wa ba hla ni ndi bi sen a, 'Bi na' shi' rji' uce na, ndu tre mbi ta he u Rji'. ");
INSERT INTO jid_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mi hla yiwu, na shi rji memle muna ko ni shulu iki ahi ruron (kpanci) u Rji; ");
INSERT INTO jid_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ko ni meme, iki ahe ni ndaza ma; ko ni Urushalima, wa ahi kiekle gbu u Ichu rligra. ");
INSERT INTO jid_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ko Bina shi'rji' ni tuh' mbi na, e na to tie nfu tuh mbi ndu kinklan ko shinji na. ");
INSERT INTO jid_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ndu 'e mbi ndu'e u a'an mbi ndu a'an ani ta zan towa, ka hi u brji. ");
INSERT INTO jid_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Bi wo wa ba hla shishi ni rjuhla shishi u ba rjula inyren ni nyren. ");
INSERT INTO jid_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","To, mi hla yiwu na gbi sron ni meme ndi na to ba tana wruu ni nhma korli, uka kma irima nno ngame. ");
INSERT INTO jid_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iri mbi ni ta ni son mrlen yi nda kpa klon mbi ri, mbi ka nno wu ri nhatia. ");
INSERT INTO jid_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","U indi wa a vuyi ndu yi zren mili rii mbi ka zren hu tie mir harli. ");
INSERT INTO jid_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nno biwa ba mye yia, u waa mye yi hlaa mbi ka na ka ngon tie wu na. ");
INSERT INTO jid_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Biwo wa ba' hla, 'U son vayi me ndi kame ni wa a kranwu'. ");
INSERT INTO jid_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","To me hla yiwu, son bi kran yi, tie lulu ni bi wa ba tie nyu yiwu a tie zizi ni bi wa ba fu' sron niyi a, din bre Rji ni bi wa ba tie yi meme ni ya'. ");
INSERT INTO jid_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Di ndu yi he mrli tie mbi wa he shu a: waa ani ndu rji ma kpan ni meme ndi mba indi didi, nda ndu ilu kuh ni ndi wa a to Rji ni wa ama to Rjia na. ");
INSERT INTO jid_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","To, uti son bi sonwu, a ngye didi utie? Bi kpa ban bana tie toki me na? ");
INSERT INTO jid_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","U bita ci mrli vayi mbi me gyen, u bi tie ngyeri wa a nna u ba ri a? Bi kpa ban bana tie toki me na? ");
INSERT INTO jid_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Naayi, bi he tsartsar me na tie mbi u shulu wa a tsartsar me a. ");
INSERT INTO jid_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wierli ni tie zizi mbi ni ndi, ndu ba na toh na. Kaa tie ni ndu tie mbi u shulu na nno yi idii ndu mbi na. ");
INSERT INTO jid_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tomba, bita tie zizi bi kana d'bbu ni ndi na, bi mrla ndi ba tie toki ni tra Rji mba ni tie nkon u migbu, ndu ndi gbre ba san Njanjimu, me hla yiwu, ba rliga kpa dii mba ye. ");
INSERT INTO jid_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bita ni tie kpie zizi, na ndu iwo ko'ta toh ikpie wa iwo rli si tie a na. ");
INSERT INTO jid_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","U ndu zizi mbi nihe rii'rii'; u itie mbi wa ani toh ni mbu'a ani hanyi dii mbi kima. ");
INSERT INTO jid_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","U bitani tie aduwa, na tie to bi mrla ndi na. Biki ba ngri tie aduwa ni zande ni tra Rji mba ni fron nkon bi mi gbu, adi ndu ndi ka don to mba. Njanjimu, me wa yiwu, ba kpa dii mba ye. ");
INSERT INTO jid_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","To biyi, bita ni tie aduwa, bika rii hi mi tra mbi, ndi tro' nkontra mbi, ndi tie aduwa hi ni tie mbi wa ahe rii'rii', u wawu tie mbi wa ani toh rii'rii', ani nnoyi dii mbi ni rira me. ");
INSERT INTO jid_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bita ni tie aduwa, bikana rju tre towa bi mrla ndi ba tie na. Ba'ki baya' di gbubu tre mba ni ndu ba wo ba. ");
INSERT INTO jid_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tomba bika na he to u mba na. 'E tiembi toh guci yiwu ikpie wa bi mye a. ");
INSERT INTO jid_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Bita' tie aduwa toyi; Tre: Iti mbu wa a he shulua, ndu san me tsratsra me, ");
INSERT INTO jid_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","mulki ndu ye, ikpie wa u son ndu ba tiewu ni ngbugblu'a nawa ba tiewu ni shulu'a. ");
INSERT INTO jid_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nnota rli u vi luwa. ");
INSERT INTO jid_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","U latre mbu uka uru hle tawu, towa kie uruhle ni bari'a. ");
INSERT INTO jid_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndi na nji ta hi wrji u tsra-toh na, jbu ta rjuni wo bi brji(meme). Mulki mba ngbengble, mba girma(babran) bahi ume kakle'. Ameh ");
INSERT INTO jid_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“E bita wru latre ndi hle bawu, itie mbi ni shulu ni wruhle yiwu ngame. ");
INSERT INTO jid_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","“Biti na wru latre ndi hle bawu na, u tie mbi na wruhle yiwu ngame na. ");
INSERT INTO jid_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ngarli, bita ni' vu nyu, na ya gbododo me' na bi mrla ndi ba tie na. 'E' ba trso shishi mba ni ndi toki ndu ba to di baki vu nyu. Njanjimu, me hla yiwu, ba rliga kpa dii mba ye. ");
INSERT INTO jid_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","To, biyi', bita si vu nyu, ngla shishi mbi di gban nye ni tu mbi. ");
INSERT INTO jid_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ndu ndi na toh di bi ki vu nyu na; u tie mbi wa a he rii'rii' 'a, nda ni toh ni rii'rii' 'a ani hanyi dii mbi. ");
INSERT INTO jid_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na rii kpi zi ni ngbungblu yi na, iwrji wa imra ni rli ba ko wa ba kuklu nda tie meme ko bi y'bi ba y'ra bubuwa na y'bi ba; ");
INSERT INTO jid_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","zi kpi mbi ni shuhe, ni bubu wa imra, ko kuklu' na kpa tie meme na ni wrji wa bi y'bi bana y'ra rii mi nda y'bi bana. ");
INSERT INTO jid_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“E iwrji wa ikpie mbi he'a, niki ki isron mbi ni he ngame. ");
INSERT INTO jid_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ikpan u kpa ahi shishi. Shishi mbi nita bii, u kpa' mbi wawuu ani shu ni kpan. ");
INSERT INTO jid_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","U shishi mbi nita tie me'me', ikpa mbi wawuu ni kpukpa bwu yi. U ani ta ndi ikpan wa ahe ni mi mbi ahi bwu, to ibran bwu kimaa ni he bitan! ");
INSERT INTO jid_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Indi ri na'toh nji tikoh harli na, 'e' ani son ri mba nda kran rimaa, ko ka' y'me ni ri nda kama ni rimaa. Bina' mrli koh Rji mba u mammon na. ");
INSERT INTO jid_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","To, mi hla yiwu, na tamne ni tu son ngbunblu mbi na, illa wa bi rli ko ikpie wa bi so, ko ni kpa'mbi, inklon wabi sru'a na. He ni sisren na zan birli na, ka ikpa mbi na zan ikpi na? ");
INSERT INTO jid_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“To cincen' bi bwua, bana cu ko can ko zi kpie ni wron na, naki me itiembi ni shulu ni nno mba rli. Bina nna ba na? ");
INSERT INTO jid_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Ahi nha mbi ni tu tamre ma ani to nzu gbron ma ko tsame? ");
INSERT INTO jid_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“U bi ta'mre ngye ni tie ikpie bi sru? To kunkron bi miji wa ba'gbron hama ni ron ko ni ta' rjurju. ");
INSERT INTO jid_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Me hla yiwu sulema me ni gbugbu kpi ma mba he wo ma me na bii mla ni ri biyi na. ");
INSERT INTO jid_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Zizanyi, u Rji wa a tie giga bi miji ni nkpon bii wa, luwa ba he u mble ba mmo hi ni ba, a na sru kpi kayi zan ba na, ha'yi biyi bi tsitsa sron. ");
INSERT INTO jid_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tomba bika na tamre di tre, 'Ayi ngye mi rli' ka ahi ngye mi so na? 'Ka 'ahi ngye me sru ka' kpa'?' ");
INSERT INTO jid_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“E a bi wa bana toh Rji mba ba wa bi kpi biyi. E itie mbi u shulu toh di bi wa ikpi biyi. ");
INSERT INTO jid_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wa mulki Rji ni mumla mba inkon matsratsra rli u mbru kpi biyi ba nno nha yiwu. ");
INSERT INTO jid_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tomba, na ta'mre ni tu mble na, imble he ni kpima u wa bi tamrea. iya' u vi ri mlau. ");
INSERT INTO jid_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na nha ndio na, u bana nhayi na. Ikpie wa bi nha bari, nikii ba nhayi me. ");
INSERT INTO jid_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kongo wa bi tsra niwua, nikii ba bantsra yiwu. ");
INSERT INTO jid_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","U tie he ndi ni ya mbwu' wa a he ni shishi vayi me a di na toh gbolo kunkron u mi shishi me na? ");
INSERT INTO jid_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka u tie ni he rli di hla vayi me, ndu mi cu imbwu u mi shishi me, u gbolo kunkron he ni mi shishi me? ");
INSERT INTO jid_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","U meme ndi. Cu gbolo wa ahe shishi me guci rli ndi ndu shishi me krjirji me wa u toh cu mbwu u shishi vayi me a. ");
INSERT INTO jid_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Na nno yawhu ikpie wa tsratsra na. Na nno lede ikpie didi ma na. Ba' canwu ni za nda la ye tanyi ");
INSERT INTO jid_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bre, u ba nno yi. Waa' u bi fe. Wru nkon, u ba bwuu yiwu. ");
INSERT INTO jid_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","E iwa a bre, ani kpa, u wa a waa' ani fe, u wa a wru nkon a ba bwuu ni wu. ");
INSERT INTO jid_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka ahi nha mbi wa vren ma ni mye bredi wa ka nno tita? ");
INSERT INTO jid_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ka a mye Lambe wa kanno iwan? ");
INSERT INTO jid_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","To, biyi bi meme dri me bi toh nno mrli mbi ikpie ndindi u bi yah itie mbi u shulu na nno ikpie ndindi ma ni bi wa ba mye bi zan na? ");
INSERT INTO jid_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tomba, ikpie wa bi yo suron ndu ndi tie yiwu a, bika tie bawu game, ahe tu nkon wa anabawa ba hlaa. ");
INSERT INTO jid_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ri'zu nkontra wa a wiere me a. Nkontra wa a bwua ni nji ndi hi wu, inkon ki na tie yah zuna' bi rizu kima ba gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Inkon wahi wiere me'a ni nji ndi hi nno vrli, a nkon u yah ma, bi wa ba fewu a ba fyime yi. ");
INSERT INTO jid_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Con ni anabawa bi ce' wa ba ye ni yi ni ntan t'ma u'ni nkponji ba hi wuon. ");
INSERT INTO jid_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bi'toh ba ni bii'klo' mba. Indi ba kyen klo ncu ni nci ncon, ka klo bua ni nci nt'me? ");
INSERT INTO jid_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ahi to kii u kukron ndindi ma ba klo ndindi ma, na wa meme kukron ni klo meme a. ");
INSERT INTO jid_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kukron ndindi ma niti bre klo meme, u kukron meme na klo ndindi na. ");
INSERT INTO jid_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kukron wa ana klo bii ns, ba tsenwu sru ni lu. ");
INSERT INTO jid_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ni tu ki, ba'toh ba ni bii' klo mba. ");
INSERT INTO jid_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ana bi wa ba yome, 'Baci Baci', mba ba rii ni shulu na, ahi wa ani tie kpie wa tiemu ni shulu a y'mme niwu. ");
INSERT INTO jid_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ni vi kima, indi gbugbuwu baye nda hla nimu, Baci, Baci, ana ni ndeme mba ki hla tre wa ba tie niko shishi na, ndi zu brji meme rju ni kpa ndi ni nde me, u kina tie gbugbu ndu bi rligra ma ni nde me na? ");
INSERT INTO jid_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","U mi hla ni bawu! Kadi nkonmu, biyi bi tie meme ndu! ");
INSERT INTO jid_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nakii, indi wa ani wo tre mu nda ni tie ndu ni tie ndu ni wua, ani he na indi u wiere wa a mme koh ma ni tu tita. ");
INSERT INTO jid_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","U kpaca, lu ye u kiekle ngwugwu ye wru koh'a, u koh'a na joku na ni wa ba mme wu ni tu tita ");
INSERT INTO jid_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","U iwa ani wo tre muyi nda na tie wu na ahe na ruru ndi wa a mme koh ma titu nhanhimu'a. ");
INSERT INTO jid_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kpaca lu a ye u kiekle ngwugwu ye nda wru koh'a. U wa azi hlega kpukpru me”. ");
INSERT INTO jid_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wa yesu a tre kle'a u gbugbu ndi mba baka tie sisri ni bii tsroma, ");
INSERT INTO jid_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ni wa a tsro mba ni ngbengle wa ana bii wa bi nha ba tie'a na. ");
INSERT INTO jid_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wa yesu a krji rji ni ngblu a, indi gbugbuhu ba huu. ");
INSERT INTO jid_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","U indi ri u lilo nkpurju ye ku kru niwu nda tre, “Baci, uta ny'me uka mla me tie tsratsra me. ");
INSERT INTO jid_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu a rima wo hi ka kpre nda tre, “mi nyme. Katie tsratsra” Nikiyi me, wa aka fe den u lilo ka kle ");
INSERT INTO jid_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu a hla wu, na tre u hla kpie ri ni ndio na. Hi kpame, ndi hi tsro tume ni Firist, ndi nno kpie wa Musa tre'a ndu hi ngban ni bawu. ");
INSERT INTO jid_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Asi hi nimi kapanahum u jirmi ri ye niwu nda bre wu, nda tre, ");
INSERT INTO jid_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Baci, igranmu a qukpa kru si tie ya ni koh mu. ");
INSERT INTO jid_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","U yesu hla wu, “mihi denwu” ");
INSERT INTO jid_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","U jirni a kasawu nda tre, “Baci, mi na mla wa u ye ni koh muna. Hla trea' megyen din ndu granmu fe den. ");
INSERT INTO jid_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","E ime ngame mihe ni wo ndi ri, me he ni soja bi ti ndu ni' womu. Mi hla ni ri, hi, waka yi uni ri mi hla wie, 'ye' waka ye, ndi hla ni granmu, tie kpieyi, waka tiewu. ");
INSERT INTO jid_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wa yesu a wowuu, a hla ni bi hu'a, “Njanjimu me hla yiwu, mina to ndi u bii sron towa ni Israila na. ");
INSERT INTO jid_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi hla yiwu, indi gbugbu bu baye rji ni ko yalu nda rli biri ni ba Ibrahim mba Ishaku, ni Yakubu ni mulki shulu. ");
INSERT INTO jid_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","U mrli wa ba u mulkia, ba vuba tasru nimi kplakpa bwuu. Nikii ba yii nda tan nyinyren” ");
INSERT INTO jid_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu a hla ni jirmia, “Hi, ndu he niwu towa u yo sron a” ni nton ki me, igran ma a fe sikpa. ");
INSERT INTO jid_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wa yesu a ri ni koh Bitrua, a toh yi' Bitrua kru kpa. ");
INSERT INTO jid_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu a kpyre wo' ma u lokpa ka kle waka wlunde nda tie ndu niwu. ");
INSERT INTO jid_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wa yalu tie a ba nji gbugbu ndi be he ni brji ye ni Yesu. Ni tre megyen a ju brji rju ni ndi ba nda den bi lilo ba wawuu. ");
INSERT INTO jid_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Toyii itre anabi Ishaya ye ku ngyre me wa a hla, “Wawu yi vu krukpa mbu nda den mba lilo mbu ba. ");
INSERT INTO jid_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Niwa Yesu a toh gbugbu ndi baa gaklen ma, a hla ni bawu ndu ba ru mah Galilia hi gran korima. ");
INSERT INTO jid_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","U ndi u nha ri ye hla wu, “Mala, mi huu hi ko mame (ko ni ntsenyi)” ");
INSERT INTO jid_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu a saa niwu, “Itsi' bahe ni juju mba cincen bahe ni koh mba, U ivren ndi yi na he ni bubu u yo tu'mana. ");
INSERT INTO jid_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ivren koh ma ri a hla wu, “Baci ndu mi hi rju' tieme rli. ");
INSERT INTO jid_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","U Yesu hla ni wu, “Hu me, don k'bon ba ndu ba rju k'bon mba”. ");
INSERT INTO jid_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wa Yesu ri nimi jirgi (ghuu) a, mrli koh ma baka ri huu. ");
INSERT INTO jid_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","U kikle nghunghu ri ka wlu fu nitu kikle maa, inda shi dakpyren kah ghuu a. Yesu si kruna kpye ma. ");
INSERT INTO jid_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","U mrli koh ma bahi ka sh'me u, nda tre, “kpata cuwo, Baci, kie qua! ");
INSERT INTO jid_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu a hla bawu, “Bi kpon sisri ngye towa biyi bi tsitsa sron? “A wlunde nda yra ha ni a wlunde nda kpa nha ni nghunghu a mba kikle maa. U bubua katie wieri me. ");
INSERT INTO jid_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Indi ba ba mhanji ma wakran nda tre,” ahi ndi bitan toyi, wa nghunghu me ni wowuu a?” ");
INSERT INTO jid_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wa Yesu aye rji ni nhma ko rima u meme Garasinawa, indi harli bari bi meme brji ba rju ye niwu. Bata rju rji ni bubu be ba nda ta vravu kpukpome u indi bana ta zu nkan kima ngana. ");
INSERT INTO jid_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba yragro na tre, “kie he ngye utie niwu, iwu vren Irji? Inton na tie me rlina u uye tie ta yah ni wa? ");
INSERT INTO jid_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gbugbu lede bari sia rli wiewiere ni ba nikii. ");
INSERT INTO jid_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","U meme brji ba si bre Yesu nda tre uti zuta rjuu, uka truta ri ni mi gbugbu lede biyi. ");
INSERT INTO jid_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ahla ni bawu, “Hi!” Ibrji ba barju nda ri nimi lede ba; u mle, gbugbu lede ba ba sra tsugrji ngblu'a nda ka kuhle nimi kickle ma nda quu wawuu bawu. ");
INSERT INTO jid_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Indi bi kma lede ba, ba tsutsu hi ni migbu nda ka blatre a wawuu ni bawu u njima, ikpie wa atie bi meme brji ba. ");
INSERT INTO jid_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","U ndi bi gbuba baka rju wawu mba wu nda ye ni Yesu. Nitowu, ba brewu ndu hi don meme mba ni bawu ");
INSERT INTO jid_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu a ri ni ghuu nda rugran hi ni gbu ma. ");
INSERT INTO jid_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mena, ba nji indi ri wa a soo kpa'a nda kru ni tabli. Wa Yesu atoh kiekle yo suron mba, a tre ni ndi u soo kpa'a, “Vuvren ngri. ba wru latre me hlega niwu”. ");
INSERT INTO jid_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","U bi nha bari ba tre ni kpamba, “Iguyi ni latre” ");
INSERT INTO jid_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","U Yesu wa a toh imre sron mbaa' a tre “Bi ta' meme mre ngye nimi sron mbi? ");
INSERT INTO jid_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Arime na he ni dii na ndu ba hla Ba wru latre me hlega 'Ka ndu bahla' wlunde ndi zren? ");
INSERT INTO jid_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","To ni ndu yi toh ndi ivren indi a he ni ngbengble u wru latre u ngbugblu hle, A tre ni indi u soo kpaa', Wlunde ndi ban bubu u kru me ndi hi koh ");
INSERT INTO jid_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","India ka wlunde nda hi ni koh. ");
INSERT INTO jid_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wa gbugbu ndi ba toh a he toyi, ma manji ma wakran, nda gbyre Irji san wa anno indi bii ngbengblen yi. ");
INSERT INTO jid_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu sihi nda ka toh ndi ri ni ko shishi wa ba yowu ndi Matiwu a son nitra u kpa ban. A hla wu, “Hume” A wlu huu. ");
INSERT INTO jid_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu a kuson nda si'rli birli u bi kpa ban nibi latre gbugbu mbawu baye kuson nda rli bi' ni ba Yesu ni bi hu'a. ");
INSERT INTO jid_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wa Farisawa ba ba toh nayi, ba mye bihua, “Ani tu' ngye mba tiekoh mbi si rli ni bi kpa ban u bi latre? ");
INSERT INTO jid_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ka wo ba' nda tre, “e bi sikpa bana wa bi den na, ahi bi lilo mu. ");
INSERT INTO jid_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","To bika mla toh nayi rli, 'Ime mi wa wruhle ana indu ni mu na. Mina ye ni tu bi he tsra tsra ana miye ni tu bi latre. ");
INSERT INTO jid_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","U bi hu Yahaya baye niwu nda tre kieta ni ba Farisawa kie vu nyu u bi hua ba ba taka ngye rli nda na tie na? ");
INSERT INTO jid_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu a hla bawu, “Bi tie ndu nitra u logran baki ni kuklu nyu u indi u gran rli he ni ba? E, inton niye wa ba ban indi u logran niba. Nikiyi mba ba vunyu. ");
INSERT INTO jid_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Indi wa ani fon pli sama kanha ni cice nklon na tie to kie ni yba nklon zan u mumla ");
INSERT INTO jid_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Indi bana sru imma sa u inabi nimi mbu ntan kmo mana. Bata tie toki, intan aniyra tie meme nda ju'mma hlega. Toyi, ba sru mma sa' u inabi nimi mbuntan sa may tie towa na ndu ba yra tu hamba wuna” ");
INSERT INTO jid_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu si tre ni ba u ndi ri wa ani mnkon ndi ba aye kuqu niwu. A tre, “Vrenwamu quu zazanyi, yeme ndi sawo wu ni ndu wlunde”. ");
INSERT INTO jid_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","U Yesu Wlunde hu hi ni mrli koh ma ba ngame. ");
INSERT INTO jid_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uwa ri ingarli wa azi juju tie se wlon don ha, a bleye konkon Yesu, nda kpyre nyu nklonma. ");
INSERT INTO jid_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“ A tre ni sronma, Mita kpyre nklon ma mi fe si. ");
INSERT INTO jid_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu a k'maya nda toh wu nda tre, “Vrenwa mu, vu sron. Kikle yo sron me nnowu si”. Ni nton kima me afe si. ");
INSERT INTO jid_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wa Yesu ari ni koh ninkon ndi mba, nda toh bi vrli ngba ni j'bu ndi baki hanton. ");
INSERT INTO jid_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A tre “Hiyi, e vrenwa na quu na, asi kru na “ U baka zanwu u kpa tsri. ");
INSERT INTO jid_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa ba ndu ndi barjuhi raa', a rihi mitraa nda vu wo vren wa nji, u vrenwa wlunde. ");
INSERT INTO jid_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Itre yi ka yan shu ni nh'ma kokii. ");
INSERT INTO jid_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu rji ki zren y'ba sihi, u bi fyen harli bari baka hu, nda kla nglo nyu nda nitre,”Ivren Doda, to yah mbu ndi zota”. ");
INSERT INTO jid_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu a ri hi ni koh rie u bi fyen ba baka wawu hi. Yesu hla bamu, “Bi kpay'me ndi mihe ngbengble utie tomba?” U baka kpay'me, 'e' Baci”. ");
INSERT INTO jid_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","U Yesu ka kpyre shishi mba nda tre, “Ndu he yiwu na wa bi yo sron mbi a. ");
INSERT INTO jid_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","U shishi mba baka bwu'. Yesu a mha ba nda tre, “Na ndu ndio wowa na.” ");
INSERT INTO jid_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma'memu, bahi nda ka bla tre kangon nklan kima. ");
INSERT INTO jid_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wa bi fyen ba ba hia, baka nji indi u con l'me u me'me' brji yeni Yesu. ");
INSERT INTO jid_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wa a cu me'me' brji rju ni niwu a, indi u con l'mea katre. J'bu ndii baka manji ma wakran, ndatre, “kae, bii kpye yi bana toh wu ni Israila na!” ");
INSERT INTO jid_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","U fansawa ba baka tre, “E a ni rju me'me' brji ba ni ngbenglen u chu bi brjii.” ");
INSERT INTO jid_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu a zren kagon gbu bi rlig ra ni bi tsitsa ba wawuu. Azi tsro tre Rji ni tra Rji, nda zi bla lan zizi u mwkai nda den bi kru kpa ni lilo bla wo. ");
INSERT INTO jid_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wa a toh kpentren ndii ba, a ka tie wie me ni tie yah' ni qungble mba. Bana he na nta'ma wa ba hama ni ndii u k'maba. ");
INSERT INTO jid_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A hla ni mrli koh ma, birli hi gbugbu, wa, u bi ndu ba ba fyi meyi. ");
INSERT INTO jid_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ahe nayi bika bre Baci u birli gbagbla me ni ndu tru bindu ba hi. ");
INSERT INTO jid_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ayo Mrli koh ma wlon don harli a nda nno ba ngbengblen u ju me'me brji, ni u den lilo ba blawowu. ");
INSERT INTO jid_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Zizanyi ngye nde mrli koh ma bahe toyi. U mumla, Sima, wa ba yowu ndi Bitru, u vayi ma Andoro, u Yakubu ivren Zabadi, mba vayima Yahaya, ");
INSERT INTO jid_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, u Bartalamawus, u Toma, ni Matiwu wa ata kpa ban a u Yakubu ivren Halfa, u Taddawus; ");
INSERT INTO jid_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sima indi u suron, u Yahuda Iskarioti wa a le ni Yesu'a. ");
INSERT INTO jid_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ahi wlo don ha biyi mba Yesu a ton ba nda hla ni bawu, “Nahi nibiwa bana Israilawa na ni gbu bi Samariyawa na. ");
INSERT INTO jid_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hi ni nt'ma u koh Israila wa ba kado'a megyen. ");
INSERT INTO jid_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bita zren sihi bika ta hla tre Rji, ndi tre, 'mulki shulu tie wiewiere.' ");
INSERT INTO jid_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Den bi lilo, ta' k'mo shine, bi kpurju, mla batie tsratsra ndi ju me'me' brji rju. Bi kpa magyen, biyi me bika nno megyen. ");
INSERT INTO jid_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na nji ba' zinariya, azurfa, u dra nimi kpo mbi na. ");
INSERT INTO jid_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na nji mbu u zren na ka inklon ha' ka lagbom ka kpa'la' na, e' indi u ndu ahe nkon u la'ma. ");
INSERT INTO jid_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Igbu wa bi ria, rligra ma ka tsitsima, bika wa indi u totie ndi son kima mla nton wa bi wlua. ");
INSERT INTO jid_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bita' ni' ri ni koh bika ciu. ");
INSERT INTO jid_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ikoh'a nita ikoh waani son sia, isi mbi ni hu ba. Ani ta ha'ma, isi mbi ni k'ma ye yiwu. ");
INSERT INTO jid_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Biwa ba'ta kamba ni kpayi ka ni woyi, bita ni don gbu'a ka koh'a, bika kpon wru u za'mbi hle bawu. ");
INSERT INTO jid_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Njanjimu, me hla yiwu, ni vi u Rji, ba sutie ni ndi bi Sodom mba Gomora zan gbu biki. ");
INSERT INTO jid_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tomba, mi tonyi ni hi na ntama ni tsutsu tsi,' nayi, bika wierli too won ndi na bi tie me'me' na too nghu. ");
INSERT INTO jid_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tie srensren ni ndi! Ba njiyi hi bi ninkon u tra Rji u ba tsiyi ni gbugban. ");
INSERT INTO jid_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba njiyi hi ba gona ni ba chu ni tu mu ni ndu ba ni biwa ba Israilawa na toh me. ");
INSERT INTO jid_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bati vuyi nno ba, bikana tamre ndi ahi ngye ka anihe mi tre na. Ba nno kpu'a u tre'a ni nton kima. ");
INSERT INTO jid_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ana hiwu ba u tre na, ahi Brji u tieme mba nitre rju zu nyu mbi. ");
INSERT INTO jid_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Vayi ni nno vayima wu', atie ivren ma ngame. Imrli ba wlu tie meme ni batie mba nda ndu ba wu ba. ");
INSERT INTO jid_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Konha ni kranyi nitu ndemu. U wa avu sron hi kle nton'a, ani gbujbu. ");
INSERT INTO jid_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bata tieyi dii ni mi gbu, tsutsu hi niwa a wie niwu'a. Njanjimu me hle yiwu, bina zren hle gbu Israila na rli ivren ndi kaye. ");
INSERT INTO jid_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mrli koh bana nna' tie koh mba na, vigran na zan bacima na. ");
INSERT INTO jid_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A mla ndu vren koh ndu he na tiekoh ma u gran kahe to bacima. U bati yoh indi u koh nda hi Ba'alzabu, kaba kpande bi koh ki tie me'me' ndandime! ");
INSERT INTO jid_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tokiyi bikana tie sisri mba na, e ikpie'a ba kawu a ba bwuu, u wa ahe riirii'a ba hla wu rju rah. ");
INSERT INTO jid_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ikpiea me hla yiwu ni bwua, hla wu ni kplende rji, u kpie wa ba tre yiwu ni ton'a, d'buu ni tutra. ");
INSERT INTO jid_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na klu sisri bi wu kpandi na, wa bana toh wu dri na. Klu wa ani toh wa kpa'a nda tru dri'a yo ni kpaca lu. ");
INSERT INTO jid_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bana le mrli cincen harli nitu vi kubuna? Iri mba mitie bre joku hama ni y'me tie mbi. ");
INSERT INTO jid_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'E' futu mbi me a toh blawo. ");
INSERT INTO jid_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Na klu sisri na. Itimbi nna u cincen gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ahe nakiyi ndi ko nha wa a ny'me nime ni k'bu ndai, me y'me niwu ni k'bu tie mu wa ahe shulu'a. ");
INSERT INTO jid_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama iwaa ana nyme ni me ni shishi ndina me ngame mina nyme ni wu ni shishi timu wa a he ni shulu na ");
INSERT INTO jid_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Na yamba ndi mi nji si ye ngbungblu yina. Mina nji si ye nno na ahi takobi. ");
INSERT INTO jid_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Meye vu tu ndi wru ni tiema, u vrenwa ni yima, u wa ni yima. ");
INSERT INTO jid_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bi kran ndi bahe bi koma. ");
INSERT INTO jid_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Twa a son tiema ka yima nna me'a, ana mla wa ani umuna. U wa a son vren ma ka vrenwa ma nna me, ana mla wa ani umu'a na. ");
INSERT INTO jid_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wa ana ban gran kukron ma nda hume na, ana mla wa ani umu na. ");
INSERT INTO jid_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","I wa ani hra tuma'a ani nado, uwa ani nno tuma, ani fe wu. ");
INSERT INTO jid_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wa a kpayia, a kpame ngame. ");
INSERT INTO jid_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wa a kpame a, akpa wa a ton me'a. Wa akpa anebi a, ani kpa dii u anebi. U wa akpa u tie zizia ni tu wa ahi indi u zizi, ani kpa diima na ndi u zizi me. ");
INSERT INTO jid_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wa a nno ri ni mi mrli bi tsitsa biyi, ka a ndi mma ni vi kofi me, nituwa vren kohmu'a, nkponjimu, me hla yiwa ana hon dii mana”. ");
INSERT INTO jid_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wa Yesu a nno ba tre kle'a, a wlu don bubukii nda hi tsro nda bla tre Rji ni mi gbu ba. ");
INSERT INTO jid_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wa Yahaya u tie batisma awo rji koh wa batroa, bi' ndu wa Yesu zi tie, a ton mrli koh ma hi niwu.' ");
INSERT INTO jid_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A hla niwu, “Ahi wuyi u ye'a”? Ka kie yo shishi ni ndi ri mu. ");
INSERT INTO jid_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu a sa'a nda hla bawu, “Hi ndi hi hla ni Yahaya ikpye wa bi to mba ikpye wa bi wo'a. ");
INSERT INTO jid_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bi fyen ba fe toh, bi glogo za ba zren, bi kpurju ba katie tsratsra me, mangbi ba wo tre ngame u biwa ba qu'a, ba ta'ba sh'me, bi wa ngame ba nno ba tre Rji. ");
INSERT INTO jid_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Indi u lulu ahi wa ana k'bu za' ni tumu na'a. ");
INSERT INTO jid_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wa ndiba ba vu nkon mba hia, Yesu ka wlu tre ni j'bu ndi ba ni tu Yahaya; “Bahi wa ngye ni ji'-ahi giga' wa nghunghu ni fu'a? ");
INSERT INTO jid_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Uahi ngye bihiwa niji'-indi wa a sru kpyi bi rjien me? Njanjimu, bi sru kpyi wa ba rjien me ba son ni koh bichu. ");
INSERT INTO jid_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","U bihi ndi hitoh ngye, anebi? Njanjimu me hla yiwu, a na'a anebi. ");
INSERT INTO jid_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wawuyi wa ba nha nitumaa, 'tomba, misi tru u tonmu'a sihi ko shishi me, wa ani mla nkon wa u zu'a tie.' ");
INSERT INTO jid_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mi hla nkpon nji tre yiwu, ni'mi' ndi wawuu wa imba ba ngrji ba, iri mba tie bre nna Yahaya u tie batisma. ");
INSERT INTO jid_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Rji' ni' nton Yahaya u batisma ye zizanyi, mulki shulu ngrji zi toh yra tu' u ndi bi nno yra tua ba kpa gbujbu ni ngbenglen. ");
INSERT INTO jid_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","E anabawa ba wawuu mba shariya bazi hla ye ye nton Yahaya. ");
INSERT INTO jid_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","U bita ni kpa, ahi wawuyi Iliya wa ani yea. ");
INSERT INTO jid_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wa ahe ni ton u wo'a ka wo. ");
INSERT INTO jid_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ni Ngye mba me tsra nzanyi niwu? Ahe na mrli bi ro ni cucu, nda si ro nda ni yoh kpa mba. ");
INSERT INTO jid_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nda ni tre, kie vrli ngba' yiwu u bina nglu nzan na, kie ban jequu u bi yii na. ");
INSERT INTO jid_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E Yahaya ye nda na rli birli nda na so rooh na, u batre Ahe ni brji shango. ");
INSERT INTO jid_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ivren ndi ye nda ni rli nda ni so u ba'tre, to mbarli, ani rli nda ni so wu' rji ikpan bi kpa ban' ni u bi latre. E bato wrli ni bii ndu ma. ");
INSERT INTO jid_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nikiyi Yesu ka wlu nda jutre ni gbu' wa a tie gbugbu kpyi bi sisri a u ba kana mla son mba tie na. ");
INSERT INTO jid_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iyah me Korazin'! Iyah me Batsaida! E ikpyi bi sisri wa ba tie yiwu, bana tie ba ni taya mba sidon, ba ndi na sru ngbanjan nklon mba nda ngbam m'brji nda bre ndu wru latre mba hlega sari mu. ");
INSERT INTO jid_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E ni cacu u bla lantre'a ba fon tie ni ba taya mba sidon zanyi. ");
INSERT INTO jid_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iwu Kafarnahum, uya ndi ba gbrye wu san towa me hi shulu me? A ahn' ba njiwu rji ye ni hades. E ikpyi bi sisri wa ba tie ni wua ba na tie bani sodom, ");
INSERT INTO jid_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","andi na rli he zizanyi mi wa yiwu ba fon tie ni sodom ni vi u bla latre zan yi. ");
INSERT INTO jid_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ni nton ki u Yesu katre, “Mi gbyre u san tietie, Baci u shulu mba u meme nituwa u rii' kpyi biyi ni biwa ba toh'a ndi tsro mrli biyi wa bana toh na. ");
INSERT INTO jid_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, tietie iwayi a bi ni shishi me. ");
INSERT INTO jid_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ikpyi ba wawu mbawu banno rji ni tietie, indio ri na toh vren'a na, ahi tie'a kanklen ma, u ndio ri na toh tie'a na ahi vivren nkaklen ma ni ndi wa vivren son tsro'a ");
INSERT INTO jid_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ye nime wawu mbi wu, biyi bi tie yah nda he ni kpyi bi ron ma, mi ndi nno yi sii. ");
INSERT INTO jid_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bon kpyi mu ni kpa mbi ndi tii bii u mu'a e mi na nzutuna u sroomu ahi, u bi fe si ni mi dri mbi. ");
INSERT INTO jid_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","E ikpyi mu bana tie dii na nda fafa mr ");
INSERT INTO jid_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ni nton kima Yesu a zren zu ni'rju kpu ni vi u sabat. Iyon tie mrli koh ma u baka won tu kpu'a tan'. ");
INSERT INTO jid_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","U Farisawa baka toh nda tre ni Yesu, toh mrli kol me ba ki tie kpye wa ana he ni tu nkon na ni vi u sabat. ");
INSERT INTO jid_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","U Yesu ka hla bawu, “Bina kra na ikpye wa Dawuda a tie ka' yon tie wu, wawu ni lilon wa bana he niwu'a? ");
INSERT INTO jid_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Niwa ari ni tra Rji nda tan bredi wa doka ana y'me ndu wawuma ni lilon ba tan na nituwa bi ki kima, Furist, mrgyen doka a y'me ni bawu ndu tan? ");
INSERT INTO jid_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bina kra ni mi doka wa a tre, ni vi bi sabat, Firist wa ba tie ndu ni tra Rjia ba tie ndu mba me u bana latre na? ");
INSERT INTO jid_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","U me wa yiwu, indi wa anna tra Rji a he'wa. ");
INSERT INTO jid_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bina he ni toh ka wahi ngye, 'Mi wa yah wruhle zan ndu; bi din na nha' bi tie zizi ni latre na. ");
INSERT INTO jid_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","E ivren ndi a Baci u sabat. ");
INSERT INTO jid_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","U Yesu wlu ni wrji kima nda hi ni tra Rji mba. ");
INSERT INTO jid_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","U ndi ni wa wo ma a soo'a ahe nikiyi, Farisawa baka myen Yesu nda tre, “A he tuh nkon ndu ba den lilo ni vi sabat? “Ni ndu ba rewu nya nda a latre. ");
INSERT INTO jid_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu a hla ni bawu “Ahi nha rimbi wa ahe ni ngble ntma ririyi, u nt'ma kima joku na vron juju ni vi sabat wa ana cuwu rju na? ");
INSERT INTO jid_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ba tie nihe rli nda tsra daraya ndi ni ntma! Anita he toyi ka wa bi ndu ba tie zizi nivi sabat. ");
INSERT INTO jid_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","U Yesu ka hla ni ndi'a “N'ma wo me” A n'ma wo ma, u wo'a katie dindi towa wa bana ngrjia. ");
INSERT INTO jid_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","U ba Farisawa ba rju hi ra' nda ka nzon nyu ni tu ma. Nda wa nkon wa ba wuua. ");
INSERT INTO jid_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu a tsen toh nda wlu don wrji kima. Indi gbugbu wu baka hu, u wa a den ba wawu-u. ");
INSERT INTO jid_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A 'mha ba din' ndu bana ndu ndi toh wawu na, ");
INSERT INTO jid_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ni ndu tre'a he towa a rju ni nyu anebi Ishaya wa atre din, ");
INSERT INTO jid_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","To granmu wa mi cuwu'a ivren wami son wu'a, wa idrimu ni ngri niwua. Mi yoh, Brji mu ni tuma ani hla nkponji ni bi l'me baria ");
INSERT INTO jid_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana gbisron nda kla ngble nyu na u ndio nawo lanma ni nkon bi mi gbu na. ");
INSERT INTO jid_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ana nzizi ngba kpu wo'a ndju'a na ana y'bi (fitila) wa tie wiewiere vkwu na ani he tohkime ni ndu nji nkponji (hi kle) (ngyren me). ");
INSERT INTO jid_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","U ni nde ma bi l'me barima bayo suron niwu. ");
INSERT INTO jid_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","U nilime, ba nji ndi ri u fyen wa a con l'me nda he ni brji meme ye ni Yesu. A clen wu kpacuwo mla wa indi u con l'me ka tre u shishi ma kafe toh. ");
INSERT INTO jid_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","U kpentren nili ba wawu mbawu baka manji ma wakran nda tre “Ka ani wayi' yi ni vren Dawuda? ");
INSERT INTO jid_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","U wa Farisawa ba ba' wo kpye u sisri yin ba' tre. “Iguyi ani ju brji meme ba ni Bahalzabul ichu bi brji”. ");
INSERT INTO jid_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","U Yesu a toh mre mba nda tre, Mulkiwa a gah kpama ana krli na, u igbu ka ikoh wa a gah tie nka'a, ana krli na ani zi hlega. ");
INSERT INTO jid_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","U shetan nita ju shetan rju ka' a gah kpama uni he rli mulki ma ni krli. ");
INSERT INTO jid_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","U mitani ju brji meme rju ni ngbengblen Bahalzabul, u mrli mbi ba ju bi u mba rju ni ngye? Ni tu treyi ahi baba yi mba tie shiriyayiw. ");
INSERT INTO jid_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","U mitie zu brji meme rju ni Brji u Rji to ka mulki Rji aye niyi. ");
INSERT INTO jid_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","U ba tie he rli indi ni ri ni koh ndi u ngbengblen nda y'bi kpyi ma hamma ni vu ndi u ngbengblen lo guci rli na. Nikiyi a y'bi ikpyi ma ni koh'a. ");
INSERT INTO jid_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iwa ana he ni me na anatie fu ni me, u iwa ana hume vu zia na, ani vu vra hlega. ");
INSERT INTO jid_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Towaa mi hla yiwu, ni latre ri uni kpa nde ri tie meme wa ndi ba tuwu a ba wru hle bawu, ani ta hi kpa nde Brji zizi tie meme bana wru hle na. ");
INSERT INTO jid_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Indi wa atre meme ni tu vren ndi ba wru kima hlega wu u anita meme tre ni tu Ibrji tsratsra kima bana wruhle niwu ni ngbungblu yi na mba ni uwa ani ye'a. ");
INSERT INTO jid_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sen kunkron dindi ma ndu klo dindi me, ka uka sen meme konkron ndu klo meme ma e ba'toh kunkron ni bii klo ma. ");
INSERT INTO jid_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Biyi mrli wan wa bi meme a, bi tie ni herli ndi hla kpye dindi? E ani kpye wa a shu ni mi sron mba inyu ni tre wu. ");
INSERT INTO jid_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Indi dindi ani tie zizi rji nimi dindi from ma u meme ndi ani tie meme rji ni meme sron me ");
INSERT INTO jid_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi hla yiwa ni vi ubla latrea, indi ba bla meme tre mba wa ba hlaa. ");
INSERT INTO jid_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","E a ni tre u nyume mba u gbuj'bu u ni tre nyu meyi ba lowu. ");
INSERT INTO jid_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ni nton kima bi nha bari ni Farisawa ba saa' ni' Yesu na tre “Mala kie son kie din toh ngban ri gi niwu” ");
INSERT INTO jid_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","U Yesu a ka saa' bawu nda tre, “Izan bi meme ni kba bi tie ntran yi ba wa ngban. Igban n nahe wa ba nno ba na zan igban u anebi Yunana. ");
INSERT INTO jid_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E na wa Yunana a tie ri tra ni cu' tra ni mi nne kiekle lambe a tokime ivren ndi ni tie vi tra ni cu tra ni mi sron meme. ");
INSERT INTO jid_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Indi bi nine va ba' wlu klri ni vi u bla latre ni ndi bi nzan biyi nda hla meme tie mba ni bawu. ");
INSERT INTO jid_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Saro niya u kogbo ani wlu klri ni ndi bi nzan bayi nivi u bla latre nda hla meme mba ni bawu. Aye rji ni nci ngbungblu nda ye wo bii wierli u Sulema, u toh, indi wa azan Sulema ahe niwa. ");
INSERT INTO jid_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Meme brji nita rju nimi ndi ani y'ba zu ni buba wa imma na hena nda wa wrji wa ani son a nda na toh na. ");
INSERT INTO jid_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ani tre mi kinahi ni kohmu wa mi rjia to nda kina hi nda toh koh'a ba mla vuwu nda mlau tie. ");
INSERT INTO jid_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ni nton kima ani hi nji ibrji tangban bari wa trieme ba zan u ma nda ye son ni kiyi. U' yah ndi kima ni meme zan u mumla. Ani he to kima ni bi nzanyi” ");
INSERT INTO jid_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu a rli si tre ni kpantren ndi ba me u yima ni ba mrli vayi ma ba klri ni kora nda ni wa tre niwu. ");
INSERT INTO jid_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Indi a hla wu, Tomba iyime ni ba mrli vayime ba klri ni kora nda ni wa tre niwu” ");
INSERT INTO jid_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","U wa a saa' niwu nda tre ni ndi wa a hla wua, I nhamba hi yimu u ba nha mba ba mrli vayimu?” ");
INSERT INTO jid_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nikiyime a nina woma tsro hi ni mrli koh ma ba nda tre, “To ba yimu ni mrli vayi mu bayi! ");
INSERT INTO jid_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","E indi wa ani tie kpyi bi tiemu wa ahe ni mi shulu a indi kimayi hi vayimu vrenlon ni vayimu vrenwa ni yimu” ");
INSERT INTO jid_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nivi kima Yesu a rju ni koha hi ka son ni nyu kiekle nne'a. ");
INSERT INTO jid_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kpontren ndi baka hu kagon ma wa ka wlu ri ni mi ghu nda kuson nimi ma u j'bu ndi ba wawu mba wu baka kli ni korah nju kiekle nne'a. ");
INSERT INTO jid_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ni nton Yesu a hla kpi gbugbu wu ni bawu ni (misali) {lan bininkon} A tre Indi ri u ron (cu) ahi nda ka cu. ");
INSERT INTO jid_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A cu'a u ibii bari ba kuhle ni nkon u cincen baka ye vurli. ");
INSERT INTO jid_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ibii bari baka kuhle ni meme wahe ni tslatsa tita (dancon?) Bati gbla rju ni tuwa meme a he bran na. ");
INSERT INTO jid_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","U irji a rjunda whu' u baka quu ngblanme. ");
INSERT INTO jid_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ibii bari ba kuhle ni mi kunkron bi ncon u kunkron ncon ba gbron na nyi ba. ");
INSERT INTO jid_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ibii bari ba kuhle ni meme dindi ma na rju bi nda tie bii, bari ibii darli ni tu wa a cu'a bari ibii ise ton u bari ibii ise tra hamma ni tane. ");
INSERT INTO jid_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iwa ahe ni ton u wo'a kawo” ");
INSERT INTO jid_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","U bi hua baye nda tre ni Yesu “Ani tu ngye mba u tre ni j'bu ndi ni (lan bi ninkon?) “misali?” ");
INSERT INTO jid_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu a saa' bawu nda tre, “Ba nnoyi nkon u toh kpye u mulki shulu wa ba rli ni bawu a. ");
INSERT INTO jid_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","E wa ahe niwu'a ba nno nhatia, u ani he wu babran. U indi wa ana hewu na' ikpye wa ahe wu'a ba kpawu. ");
INSERT INTO jid_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngye kpye wa ani ndu me tre ni ba ni lan bi ninkon a yi: ko wa ba' yah bano toh na u ko wa wa'a bana wo na nda name' toh tuma zuna. ");
INSERT INTO jid_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ni' bawuyi itre Isheya a ye tsra, wa a tre din, Ni wo biwo ndi tie bre toh njima uni' yah bi toh indi na toh tuma zuna. ");
INSERT INTO jid_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","E isron ndi mbayi aka tie bwu' nda sen gbirhi rhi me nda na wo na nda gru shishi mba ni ndu ba - ba na toh ni shishi mba na, ka ndu ba na woni ton mba na, ka nda toh njima ni sron mba ni ndu ba kmaye ndu me den ba. ");
INSERT INTO jid_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","U shishi mbi ba'bi lulu niwa ba toh a, u ton mbi ngame wa ba wo a. ");
INSERT INTO jid_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Njinyimu mi hla yiwu anabawa ni ba ndi bi tie ngyrengre gbugbu wu ba yo suron u toh ikpye wa biki toh a u bana tsh na. ba wa ba wo ikpye wa biki yoha nda na wo bana. ");
INSERT INTO jid_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sren ton ndi wo misali u ndi u ron wa a cu bii a. ");
INSERT INTO jid_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","U ndi wa awo lan u mulki a nda na toh njima na, ibrji meme ani ye sranwu kpa ikpye wa ba cu ni mi sron ma. Iwayi ahi bii wa ba cuwu ni nyu nkon a. ");
INSERT INTO jid_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wawu ma wa ba cuwu ni meme u tslatsa tita a, ahi ndi wa a wo' lan'a nda kpawu gblame ni briku. ");
INSERT INTO jid_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wa ana sen ngble wa ani klri bran ton nan. To iya ye ka meme tie ye ni tie lan'a, ani gbla joku ");
INSERT INTO jid_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","U wa ba cuwu ni mi kukron bi ncona, ahi ndi wa awo lan'a u hu ngbungbungblu ni gyru u kpji ngbungblu ba mha tre a wa kana klo na. ");
INSERT INTO jid_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wawuma wa ba cuwu ni meme ndindi ma kimaa' ahi iwa awo lan nda toh njimaa ani klo nda nno bii wa bari mla dari u bari ise ton u ri uma ni se tra hama ni tanne zan wa ba cu'a ");
INSERT INTO jid_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ala nno ba misali ri. A tre, “mulki u shulu he na indi ri wa acu bii ndindi ma ni rju ma. ");
INSERT INTO jid_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","U wa ndi basi kruna, u kranwu ri ka ye nda ka cu meme bii ni mi bii ndindi a nda hi kpama. ");
INSERT INTO jid_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Niwa ingban alkama a tubo nda tie tu'o ni nton kima meme giga ngame ka tsro. ");
INSERT INTO jid_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Igran bi ndi u rju'a baka ye hla niwu tiekoh mbu ana bii ndindi ma ba ucu ni mi rju me ana? Nihe mu aka tie meme giga? ");
INSERT INTO jid_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A hla ni bawu, ahi wa ayame ni ko shishia mba tie ndu mba. Igram ma ba ba ka tre kie hi gbi ba hle rju ");
INSERT INTO jid_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Indi u rju katre, A'an Bita ni to kima, biye gbi bii ndindi nha ni meme giga a. ");
INSERT INTO jid_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ndu mba gbron bi me gbyen fyi u han ma. Ninton kimayi mi hla ni bi han ba, guci gbi meme giga ba ndi lo ba ni nkpi ma zi wa baka gon ba; u alkama mba bi vu hi sru nimi wron mu. ");
INSERT INTO jid_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","U Yesu ala tre ni mba ni misali garti, nda hla “Ba ban mulki shulu na wlo bii mustad wa indi ka cu ni rjuma. ");
INSERT INTO jid_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iwlo yi ahi fyime yi ni mi bii a wawuu. u aye gbron nda tie vuvu zan imbru bari ma ni rjua. A katie kukron wa cicen bakaye tie koh mba ni ba lan ma. ");
INSERT INTO jid_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ala hla misali ri ni bawu, mulki shulu ahe to yist wa iwa ni ban wu tsi ni mwu mwu kango tra waka kpawu whu ");
INSERT INTO jid_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ikpyi biyi wawu mbawu Yesu a tre ba ni misali ana tre kpye ri hama ni misali na. ");
INSERT INTO jid_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ahe towa ni ndu ikpye wa ba tre ni nyu anebi a ndu njanji, wa'a hla, “ mi bwuu nyumu ni misali. Mi hla ikpyi wa ba he rii'rii' rji ni tie ngbungbu'a”. ");
INSERT INTO jid_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","U Yesu ka' ka j'bu ndi ba don nda rihi ni mi koh. Mrli koh ma baka ye niwu nda tre, Hla ni tawu misali ni tu meme gigah u rjua” ");
INSERT INTO jid_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu a saa' nda tre wawu wa a cu bii ndindia ahi vren ndi. ");
INSERT INTO jid_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Irju'a mba hi ngbungblu; u bii ndindia bahi mrli bi mulki. Gigah ba ba mrli u meme a. ");
INSERT INTO jid_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","U ni tie shishi wa a chu ba ahi shetan. Iham ahi ikle ngbungblu u bi han bahi malaiku ");
INSERT INTO jid_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nawa ba vu gigah ba ka gon ni lu'a ani he tokime ni kle ngbungblu. ");
INSERT INTO jid_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ivren ndi ni ton malaika ma, uba hivu kpi biwa ba nji latre mba tie meme rju ni mulki ma. ");
INSERT INTO jid_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ba' ta' ba sru nimi kpentren lu, ni kima bayi nda tan nyiyren. ");
INSERT INTO jid_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nikiyi me ndi bi tie njanyi ba kpan to rji ni mulki tie mba. Ndu wa ahe ton u wo a, ndu wo. ");
INSERT INTO jid_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mulki shulu ahe to (arziki) wa ba rii wu ni mi rju. Indi ri ka toh nda rii'u. Ahi ni ngri nda ka vu ikpyi wa ahe ba le'nda hi ka le rjua. ");
INSERT INTO jid_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ngarli mulki shulu he to ndi u woh waa ani wa shishan tita. ");
INSERT INTO jid_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wa aye fe shishan u nkpon bi ri, a vu kpyi u wo'ma le'rju nda le wu. ");
INSERT INTO jid_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ngarli mulki shulu ahe na rjirji u vu lambe wa ba ka ta yo ni mi kie kleme nda vu kpyi gbugbu wu ni san mba. ");
INSERT INTO jid_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wa rjirji'a shu'a bi vu lambe ba baka gbi wu rju ye ni rah. Ba kuson nda hla bi ndindia sru nimi gbokrju mba u bi meme ba' ba vu ba ta'hlega. ");
INSERT INTO jid_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ani he towayi ni kle u ngbongblu'a. ");
INSERT INTO jid_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Malaika baye nda ga bi meme rju ru bi tie zizi ba sruni kpentren lu nikiyi bayi nda tan nyiyren ");
INSERT INTO jid_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bi toh tu kpyi mba yi wawu wu? Mrli koh ma baka tre “E” ");
INSERT INTO jid_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu a hla bawo, Ahe to kima na wa u riha ri wa ani ta katie vren koh u mulki shulu'a ani he to ndi wa ahe ni koh'a wa a ju kpyi bi ciceme ni bi sisama rju nimi kpyi ma wa ahe ba. ");
INSERT INTO jid_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Niwayi, wa Yesu a tre ni misali ni bawu kle'a a wluhi don bubu kima. ");
INSERT INTO jid_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yesu ahi ni ko nklan u gbu ma nda kari ni tra Rji nda tsro indi mba. Ba wo tsro ma nda manji ma wakran (lie sisri) nda tre ndi “ Iguyi afe toh tsro yi ni ngbengble u tie kpyi bi sisri yi rji mame? ");
INSERT INTO jid_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Indiyi ana vren guh u han kunkron a na? Wa ana yima yi ba yowu ndi Maryamu na? u' ana ba Yakubu ni Isuwu mba sima u Yahuza ba mrli vayi ma na? ");
INSERT INTO jid_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ana mrli vayi ba mrli mba wa ba he nita na? Wa afe kpyi biyi wawu rji mame” ");
INSERT INTO jid_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Baka tie nfu ni wu. Yesu a tre din “E ba tsri anabi ni urji ri na anigbu ma ni koh mayi ba kpau tsri. ");
INSERT INTO jid_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ana tie kpyi bi manji ma gbugbu wu ni kima na ni tu ka kpayme mba ni tre Rji. ");
INSERT INTO jid_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ni nton Kimayi Hiridus ana chu nda wo ikpye wa ba'tre ni tu Yesu a. ");
INSERT INTO jid_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ahla ni ba gran ma “Iwayi ahi Yohana u tie batisma; a tashme. A to kima mba wa he ni ngbengblen u tie bi ndu bayi. ");
INSERT INTO jid_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ana Hiridus yi vu Yohana tro ni tu Hirudiya iwa vayi ma Filibo. ");
INSERT INTO jid_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Niwa ahla niwu “ Anabi ndu ban wa tie wame na” ");
INSERT INTO jid_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus ana wuu wa a klu sisri ndi wa mba kpawu nyme ndahi anebi. ");
INSERT INTO jid_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Niwa ivi wa ba ngrji Hiridus a tie a, ivrenwa Hiruduja a to nglu nzan wa abi kpukpome ni Hiridus. ");
INSERT INTO jid_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A hla niwu nda shirji nha tia ndi ani mye wu ko ngyeri, ani nnowu ");
INSERT INTO jid_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wa awo ni yima ikpye wa ani myea a tre, “Ne niwa itu Yohana u tie batisma nimi tere” ");
INSERT INTO jid_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ichu a tie nfu ni mye maa, uni tu wa ana shirji niwu ye nha bi ni indi wa baye rli niwu'a a yo ba ndu ba tie tokima. ");
INSERT INTO jid_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A ton mba ka cu toh Yohana ni mi koh u troa. ");
INSERT INTO jid_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nikiyi, ba nji tohma ye nno vrenwa ni mi tere a wa a kpa nji hi ka nno yima. ");
INSERT INTO jid_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nikiyi mrli koma baka ye ban ikmo karju bahi ka hla Yesu. ");
INSERT INTO jid_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wa Yesu awo towa a wlu niki ndra (tuka) ni ghwu hi wrji ri ni kankle ma. Wa jbu ndi ba ba wo towa baka zren rji ni mi gbu ba ni za huhi. ");
INSERT INTO jid_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nikiyi Yesu aye ni shishi mba nda to jbu ndi mba. Isronma ka tie wie ni ba nda den indi mba bi lilo ");
INSERT INTO jid_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wa yalu ye tie a mrli koh ma baye niwu nda tre “Bubuyi ahi miji u iton a gbronhiye. Cu ndi mba cuwo ndu bahi ni mrli gbu nda le birli rli” ");
INSERT INTO jid_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","U Yesu hla bawu, “Ihi mba megyen na bi na nno ba ikpye wa ba rlia” ");
INSERT INTO jid_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ba hla niwu,”kie he ni gble bredi ton u lambe harli” ");
INSERT INTO jid_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ka tre, “Nji ba yene” ");
INSERT INTO jid_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nikiyi Yesu a hla ni j'bu ndi ba ndu ba kuson ni tu giga. A vu ngble bredi ton ba u lambe harli ba nji. A nzu ya shulu, nda tie lulu bawu nda nfu bredi ka nno mrli koh ma u ba kpa nno j'bu ndi ba. ");
INSERT INTO jid_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ba ton nda hwrji. U kpunkpu bredi mba lambe wa a don a bavu shu nimi sisen tso. ");
INSERT INTO jid_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","U biwa ba tan-a, lilon dubu ton mu, imba na mrli bana blayona. ");
INSERT INTO jid_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A tiegbla ndu mrli koh ma rini mi ghwu nda dran ru' hi gran rima guciwu, wawu a krli gbyen j'bu ndi ba nda kaye cu ba cuwo. ");
INSERT INTO jid_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Niwa a ndu j'bu ndi ba hia, a hon hi ngblu nda ka tie a duwa. Yalu yetie wa ahe ni nklen ma. ");
INSERT INTO jid_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ni ntonyi ighu'a he ni mi tsutsu maa u dakpyren maa u kiekle nghu nghu ba wru ka'da tie dii u dran wu. ");
INSERT INTO jid_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ni bwuh mble (krifi tra u mble), Yesu ka zren ni tu maa siye ni ba. ");
INSERT INTO jid_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wa mrli ko ma to si zren ni tu maa, ba ka tie sisri nda tre “Iwayi hi brji”, nda yragro ni sisri. ");
INSERT INTO jid_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu ka gble tre ni ba nda hla, “Vu sron! ahi me! Na klu sisri na”. ");
INSERT INTO jid_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitru a saa niwu nda tre, “Baci ani ta hiwu, yome ndu me ye niwu” ");
INSERT INTO jid_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu a tre, “Ye” u Bitru ka rju ni ghua nda zren ni tuma sihi ni Yesu. ");
INSERT INTO jid_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ni' wa Bitru to sen nghunghua, a tie sisri. Wa a gle sihi ni mi maa, a kpagro nda tre, “ Baci kpame cuwo!” ");
INSERT INTO jid_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu katie gbla rima wo ma vu Bitru nda hla ni wu, “Iwu u tsitsa suron, ahi ngye yo ni kay'me?” ");
INSERT INTO jid_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Niwa Yesu mba Bitru ba ri ni mi ghu'a nghunghua kukli nda na la fu na. ");
INSERT INTO jid_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nikiyi mrli koh ma ni mi ghua baka ku khu niwu nda tre, “Njanjimu u vren Rji”. ");
INSERT INTO jid_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wa ba rugran, bahi ni gbu Janisarata. ");
INSERT INTO jid_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wa indi bi wrji kima bato Yesu, ba tru cu ma hi ni ba nklan bi bubu ki, nda nji bi lilo bla san ye niwu. ");
INSERT INTO jid_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba breu ndi ndu ba' kpre nyu nklon ma, u biwa ba kpreu a ba fe den. ");
INSERT INTO jid_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","U Farisawa ni anabawa bari barji ni Urushalima yeni Yesu. Ba tre. ");
INSERT INTO jid_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“A ngye tie rli u mir koh me ba wru ikpi ba tie hlega? Bana ngla wo mba rli na nda rli birli na” ");
INSERT INTO jid_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu a saa bawu nda tre, “U ni tungye mba bi wru tre Rji hle ndi hu tre ba tie mbi? ");
INSERT INTO jid_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E Irji hla, 'ku khwu ni tieme ni yime, mba Indi wa tre meme ni tieme kani yimaa, gbigbi ani khwu. ");
INSERT INTO jid_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","U bi hla ndi, Indi wa a hla ni tiema ka ni yima, Bi zo wa u fe rji ni mea, zizanyi ahi nno uka nno Rji” ");
INSERT INTO jid_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Indi kima na sison tie zizi ni tiema na. Ni nkonyi mba bi ya tre Rji hlega ni tu ikpi u ba baci mbi. ");
INSERT INTO jid_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Biyi bi brji! a tsra ni tre Ishaya ni wa a tre ni tu mbi a, ");
INSERT INTO jid_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Indi birji ba gbre mi san ni l'me mba, u dri mba he gbugban mu ni me. ");
INSERT INTO jid_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba kukhwu ni mu megyen don ba tsro na ikpi u ba baci mba ni ndi”. ");
INSERT INTO jid_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wa ayo j'bu ndi ye ni kpama nda hla bawu, “Srenton ndi tozu-” ");
INSERT INTO jid_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ana kpye wa ari nyua mba ni ka indi tie rji na. Ahi kpye wa a rju rji ni mi nyua, kimayi ni kpa indi tie rji”. ");
INSERT INTO jid_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","U mrli koh ma baka ye nda hla wu din “u to' ndi Farisawa ba ba tie nfu ni wa ba wo tre mea?” ");
INSERT INTO jid_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu a saa bawu nda tre, “ Iwu wa ana tiemu u shulu cuna, ba gbi u rju. ");
INSERT INTO jid_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Don ba me, ba bi fyen bi tsro nkon. U ndi u fyen ni ta tsro indin u fyen ri nkon hamba wu ba kuhle ni mi nkpenrlen. ");
INSERT INTO jid_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitru a saa ni Yesu, “Hla misalia ni tawu,” ");
INSERT INTO jid_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu a hla, “Biyi me bina to zu ngame rlina? ");
INSERT INTO jid_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bina to na din ikpye wa ari ni nyu ani grji tsihi ni mi ne nda rju hle hi ni juju utra nye? ");
INSERT INTO jid_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","U ikpye wa ani rju rji ni nyua ba rju rji ni mi dri. Bi kimayi ba kpa ndi tie rji. ");
INSERT INTO jid_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A ni mi dri mba meme mre ba rju wuu ndi wa mba kplakpa zren iybi hu gonce, ni ba mre. ");
INSERT INTO jid_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Biyi yi ba kpi wa ba kpa ndi tie rjia. Rli ni wo wa bana ngla a na-na kpa ndi tie rji (meme) na. ");
INSERT INTO jid_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu a wlu ni kiyi hi ni ko kiekle gbu bi taya mba sidon ");
INSERT INTO jid_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","U'wa u ka'ana ri aye rji ni nklan kokima a kla gble nyu nda tre, “Wo yi mu, Baci, Ivren Doda! Ivrenwa mu si ti kponya ni meme brji. ");
INSERT INTO jid_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","U Yesu kana saa kpyeri niwu na. Mrli koh ma baye nda brewu, nda tre, “Zuu don hi kpama, ahu ta nda ni han ta ton”. ");
INSERT INTO jid_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","U Yesu kana saa ni bawu nda tre, Bana ton me hi ni ndio na, atutu ntma Israila wa ba kadoa. ");
INSERT INTO jid_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aye nda kukhwu ni ko shishima, nda tre “Baci zome”. ");
INSERT INTO jid_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A saa niwu nda tre, “A na he tu nkon na ni ndu ba ban bredi mrli tayo ni mrli yawhu na. ");
INSERT INTO jid_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A tre, “E, Baci imrli yawhu ba rli rjurju wa ani kuhle ni tebru indi u koha. ");
INSERT INTO jid_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","U Yesu saa niwu, “Iwa ikponji me babran ndu he niwu towa u son a” Ivrenwa ma a fe si ni nton kima. ");
INSERT INTO jid_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu a don wrji kima nda hi ni ne Galili a hon hi ni ngblu nda ka kuson ni kima. ");
INSERT INTO jid_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kpentren ndi baye niwu. Ba nji bi conrju, bifyen bi nkpran, bi cbiza ni ndi bi kuyren ni gbugbuwu ndi bari bi lilo ye niwu. Ba nji ba ye ni kbu ma wa a den ba. ");
INSERT INTO jid_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","U j'bu ndi ba baka manji ma wakran ni wa ba to bi tie nkpan ba tre, bi c'bi za ba fe den, ubi conrju ba zren ni bi fyen ba to. ba gbyre Rji Israila san. ");
INSERT INTO jid_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu a yo mrli koh ma ye ni kpama nda tre,”Ijbu ndi ba ba' lome sron niwa ba he nime vi tra ye nda nafe kpye rli na. mina son tru bahi hama ni rli na, ni ndu ba na kukmo ni nkon na. ");
INSERT INTO jid_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mrli koh ma ba tre, “Ani ntsen yi kie fe gble bredi wa ani mla ijbu ndi bayi? ");
INSERT INTO jid_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu a tre ni ba, “Bi he ni gble bredi bren?” Ba tre, “Itangban, ni mrli lambe tsame” ");
INSERT INTO jid_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U Yesu a yo ba ndu ba kuki ni meme. ");
INSERT INTO jid_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A vu gble bredi tangban ba u lambe'a a ngyri, nda mre gble bredi ba kanno mrli koh ma. Mrli koh maa ba kpa nno jbu ndi ba. ");
INSERT INTO jid_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Indi ba ba tan wawu mba wu nda whrjia. Ba vu rjurju wa ba tan don mbru ma tie sisen tangban. ");
INSERT INTO jid_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Biwa ba tan a, ba lilon dubu zya, imba ni mrli bana bla ba yo na. ");
INSERT INTO jid_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu a ndu j'bu ndi ba hi kpa mba nda ri ni ghwu hi nklan Magadan. ");
INSERT INTO jid_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ba Farisawa ni Sadukiyawa baye tsra wu nda ni mye u ndu tsro ba ingban ri rji ni shu. ");
INSERT INTO jid_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A saa ni bawu nda tre, “To yalu tie, bi tre, ani kpan megyen, ishua a hre me. ");
INSERT INTO jid_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","To ahi mble, bi tre, luwa na kli megyen na, shulua klo kpalu kle gbua. Bi to hla kpan u shulu ndi na to hla ingban u ba nton na. ");
INSERT INTO jid_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ahi nza bi meme ni bi tie ntra mba ba wa ngban, e bana tsroyi ingban ri nkan na hama ingban u Yunana” Nikiyi Yesu a wlu hi kpama don ba. ");
INSERT INTO jid_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mrli koh ma ba ru nne hi kosan korima nda tie rlisu ni nji bredi. ");
INSERT INTO jid_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu a hla bawu, “Tie sesren me ndi mla ya Yisti u Farisawa ni Sadukiyawa ba” ");
INSERT INTO jid_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","U mrli koh ma baka tre ni kpamba, Ahe wa kie na nji bredi a na. ");
INSERT INTO jid_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu a to nakima nda tre, Biyi bi tsitsa nkponji biki tre ngye ni kpambi ndi bi na nji bredi na? ");
INSERT INTO jid_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bi rlihe to ka taka nitu ngble bredi ton wa indi dubu ton ba tana, u sisen bren bika vu shua na? ");
INSERT INTO jid_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ka igble bredi tangban ni ndi dubu nzia, i sisen bren bi vu shu na? ");
INSERT INTO jid_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ani he rli u bi honto ndi mina si tre ni tu bredi na? “Tie sesren ndi mla ya yisti u Farisawa ni Sadukiyawa. ");
INSERT INTO jid_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nikimayi baka to nda nasi hla ni bawu ndu na tie sesren ni yisti u mi bredi na, ahi ndu ba tie sesren ni tsro u Farisawa ni Sadukiyawa ba. ");
INSERT INTO jid_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ni nton wa Yesu aye ni ko nklan u Kaisariya Filip, a mye mrli ko ma nda tre, “Indi ba hla ndi Ivren Indi hi nha?” ");
INSERT INTO jid_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba tre, Bari ba hla Yohana u tie batisma, bari Iliya u bari, Rimiya, ka iri ni mi anabawa. ");
INSERT INTO jid_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A hla bawu, “U biyi bi tre me nha?” ");
INSERT INTO jid_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","U sima Bitru a saa niwu nda hla, “Iwu yi u Kristi, Ivren Rji u sisren a” ");
INSERT INTO jid_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu a saa nda hla niwu, “Ba tie lulu niwu, Sima ivren Yunana, don ana rima mba yi ba nghran wayi niwa na ayi itie mu wa ahe ni shulu a. ");
INSERT INTO jid_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mila ni hla niwu ndi iwuyi u Bitru, ni tu tita yi mi me iklisiya mu. Ba nkon tra u Hades bana kpawu ka na. ");
INSERT INTO jid_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi nno wu ba hra u bwu mulki shulu. Ko ahi ngyeri wa wu lo ni ngbungblu a, ba lowu ni shulu, u ko gyeri wawu si ni ngbungblu a, ahe ni si ni shulu” ");
INSERT INTO jid_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nikiyi Yesu a mha mrli koh ma ba ndi ndu bana hla ni ndiori ndi ahi Kristina. ");
INSERT INTO jid_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rji ni nton kima Yesu azi hla ni mrli koh ma ba ndi ahi gbigbi ndu wawu hi ni Urushalima nda hi tie ya ni tu ikpi gbugbu wu ni wo bi cice, ni Firist bi ninkon ni ba mala u atawura, u ba wuu, ka tash'me ni vi utra. ");
INSERT INTO jid_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","U Bitru ka nji wu hi ni kosan nda pua wu tre nda tre, “Ndu kpiyi na tie whiewhiereni wu na, Baci, ikpye yi na tiewu na”. ");
INSERT INTO jid_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","U Yesu a kima nda hla ni Bitru, K'ma hi ko gon mu, shetan! U nkon u k'bu za nimu don una yo sron ni kpi bi wu Rji na se kpi bi u ndi” ");
INSERT INTO jid_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ni kiyi Yesu a hlani mrli koh ma ba, “Du' wa ani son hu mea, ahi gbigbi ndu kama ni tuma, nda bhan nghran kunkron ma, nda hu me. ");
INSERT INTO jid_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","E i wa ani wa' kpa tuma j'bu a, ani wau hama, u i wa a nno tuma ni nyu mu a afe wu. ");
INSERT INTO jid_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ahi ngye u zizi ma ndu ndi fe ngbungblua wawuu nda khwu? Ani ngye ri indi ni kawu sran nituma? ");
INSERT INTO jid_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ivren ndi niye nimi gbarji kpan u tiema ni Maleku ma. Ni nton kima, ani nno ko nha dii ma u ndu wa a tie a. ");
INSERT INTO jid_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Njanyimu mi hla yiwu, bari mbi wa bi krli niwa bana la khwu tona se ba to Ivren ndi ye ni mi mulki ma” ");
INSERT INTO jid_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Niwa ba tie vi tanne a, Yesu ka nji Bitru u Yakubu, U Yohana vayi ma, hi ni kiekle ngbluri baba kimba. ");
INSERT INTO jid_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iheme a kasran ni shishimba. Shishima ka shan na rji u ikpi wa a sru'a baka kpan njlan (lulu) me. ");
INSERT INTO jid_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","U ba krli to Musa mba Iliya ba ki tre ni wu. ");
INSERT INTO jid_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitru a saa nda hla ni Yesu, “Baci a bi ni tawu wa kie he niwa. U tie kpa yime mi tie bru tra-iri ni wu u ri ni Musa, uri ni Iliya. ");
INSERT INTO jid_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ahe ni mi si tre me u kpalu u kpan ma aye ka ba gbrjime krjutie u lan ri ye rji ni kpaa nda tre, “I wayi ahi vrenmu wa mison wu kpukpo me, ndi ni ngri ni wua. Wawu yi”. ");
INSERT INTO jid_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wa Mrli koh ma ba wo trea ba kpon sisri naa kukru ni shishi ni meme. ");
INSERT INTO jid_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","U Yesu a ye nda kpyre mba nda tre “Wlu nde din na tie sisri na” ");
INSERT INTO jid_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","U ba nzuya nda na to ndio ri na se wawu Yesu yi megyen ");
INSERT INTO jid_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba si grji ni ngblu a u Yesu ka mha ba nda tre “Na hla nhranyi ni ndio ri na se Ivren ndi tashme ni mbe” ");
INSERT INTO jid_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mrli koh maa ba mye, “Wa ni tu ngye mba mala bi atawura ba tre nda hi gbigbi ndu Iliya ye ni mumla?” ");
INSERT INTO jid_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu a saa nda tre “Iliya nige njanji nda nji ikpyi ba k'maye wawuu. ");
INSERT INTO jid_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","U mi hla yiwu, Iliya a ye' ye. U bana towu na. Niva ani he to kia, ba' tie kpye wa sron mba son a. Ani he ni nkon bi kimayi Ivren Ndi ngame ni tie ya ni wo mba. ");
INSERT INTO jid_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ni kiyi mrli koh maa baka to nda si tre ni tu' Yohana u tie batisma. ");
INSERT INTO jid_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wa baye ri ni bubu u shubia, indi ri kaye niwu, a kukhwu ni shishima nda tre, ");
INSERT INTO jid_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Baci, wo yimu ni tu vrenmu vrenlon, ani ku nkpyinkpi nda ni tie ya kpukpome. E azi ku ni lu ni ma. ");
INSERT INTO jid_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi nji wu ye ni mrli koh me, u bana toh den wu na” ");
INSERT INTO jid_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu saa nda tre, “Bi hamma ni nkponji u ni bi nzan wa ba k'ma kpyi sran a mi zi he niyi hi ni tanyi? Mi zi vu sron niyi hi ni tonyi? Nji wu yemu wa. ");
INSERT INTO jid_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu a kpa nha ni brji shango a wa ka rju donwu u vren kafe si ni nton kima. ");
INSERT INTO jid_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","U mrli koh maa ba ye ni Yesu ni yoybi nda tre, “Ahi ngye mba tie u kiena toh zu brji a na? ");
INSERT INTO jid_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu a hla ni bawu, “Ahe ni tu tsitsa sron mbi. E mi hla yiwu njanjimu ndi, bitie he ni kponji sron wa andi tsa (fyi) meyi to wlo su' bi hla ni ngblu yi, 'cbi rju (di) wa hi ni wamu, u ani c'bi hi u ikpye riri me na nnayi wo na. ");
INSERT INTO jid_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","U bi brji yi na rju na hamma ni vu nyu mba tie aduwa. ");
INSERT INTO jid_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ba he ni Galili u Yesu a hla ni mrli koh maa, “Ba ka Ivren Ndi nno ni wo' ndi. ");
INSERT INTO jid_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","U ba wuu, u nivi u tra ani tashme” mrli koh maa ba ka'tie whie me. ");
INSERT INTO jid_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wa baye ri ni Kapanahum a, bi kpa bhan inghama shekel baye ni Bitru nda tre, “Mala (Baci) bi a ni han bhan ignhama shekel a?” ");
INSERT INTO jid_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A tre “e” U wa Bitrus a ye ni koh a, Yesu a tre niwa nda hla ndi, “A ngye mba hi mre me sima? Bi chu ngbungblu ba kpa bhan mba ni ba nha? Rji ni mrli mba kaa rji ni ba ri? ");
INSERT INTO jid_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bitru a saa wu “ Rji ni bari” Yesu ka tre, “Ka mrli ba bana han bhan na” ");
INSERT INTO jid_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","U ni ndu ta na yo bi kpa bhan ba tie latre na, hi ni nne, ndi ta ngron ri yomi ndi gbi lambe wa ngron vu ni mumla rju. U ti bwu nyu ma u toh shekel ri. Cuu ka nno bi kpa bhan ba u nyu mu ni wu” ");
INSERT INTO jid_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ni nton kima mrli koh ba baye ni Yesu nda tre, “Ahi nha mba nna wawuu ni mulki shulu?” ");
INSERT INTO jid_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu ayo vi kapran vren ri ye zi ni mba. ");
INSERT INTO jid_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nda tre, “Njanjimu mi hla yiwu bi tie na katie to kpran mrli na, bi tie bre ri mulki shulu. ");
INSERT INTO jid_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nawa, i waa aka tu ma grji to kpran vrenyi a ahi wawuyi nna wawuu ni mulki shulu. ");
INSERT INTO jid_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iwa a kpa kpran vren to wayi a nimi nde mu, a kpa me. ");
INSERT INTO jid_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","U i wa ayo ri nimikpran mrli bayi wa ba nyme ni me a ndu joku a ndi na bi zan niwu ndu ba bhan tita nra lo ka klo niwu ni to denyo ni mi honlon nne. ");
INSERT INTO jid_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Iya ngbungblu yi ni tu inton wu k'bu za! ahi gbigbi ndu tita bi kbu za ba ndu ba ye iya ndi kima wa ani ndu tita biki ye rji ni wua! ");
INSERT INTO jid_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","U iwo me ka iza me nita ndu ni joku gyen u ka taga. A bi zan ndu ri ni koh Rji ni kpunkpu za kani kpunkpu wo niwa u ri ni mi lu ni wo me harli kani za me harli. ");
INSERT INTO jid_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","U shishi me nita yo ndu joku kirewu cu taga abi zan ndu ri nimi koh Rji ni shishi ri niwa u ri ni mi lu ni shishi ba hamba wu. ");
INSERT INTO jid_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Na ti bre renyu ni ri ni mi mrli bayi na. Mi hla yiwu maleku mba ba si ya shishi tiemu wa ahe ni shulua. ");
INSERT INTO jid_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","E ivren ndi aye bubu kpa kpye wa akado a cuwo. ");
INSERT INTO jid_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bi tamre ni he? U indi ri nita he ni ntma darli ri, u ri ni mi mba zren hi kado ana ka mbru se tia don tia zi ni nei ngblu na hi wa iri ma wa aka doa na? ");
INSERT INTO jid_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wani ta towu, njanjimu mi hla ni yiwu ani ngyri ni tu riri kima zan imbru setia don tiawa bana kado naa. ");
INSERT INTO jid_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ni nkon kima me, itie mbi ni shulu na son ndu iri nimi kpran mrli bayi yra tu na. ");
INSERT INTO jid_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","U vayi me nita latre niwu uka hi fe wu ni kankrji ma ndi mla tie biyi hambi wu. Ani ta wowu, ka wu nji vayi me kimaye. ");
INSERT INTO jid_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","U ani tana wowu na, nji ndi ri ka iha ndu ba huhi ni ndu inyu indi ha ka tra tre nda hla ikpye wa ba toa. ");
INSERT INTO jid_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa nita kama ni mba hla trea ni coci. Wani ta la kama ni wo coci a, cuwo ndu he na indi wa ana toh Rji a na ni na bi kpa bhan. ");
INSERT INTO jid_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Njanjimu mi hla yiwu, ikpye wa bi lo ni ngbungblu a ba lowu ni shulu, u ikpye wa bi si u ni ngbungblua, ani si ni shulu. ");
INSERT INTO jid_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ngarli mi hla yiwu, biyi ndi harli ni ngbu ngblu bita kpanyme ni tu kpyeri wa bi myea itie mu wa ahe ni shulua ni tie ni bawu. ");
INSERT INTO jid_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bubu wa indi ha ka tra ba shubi nimi nde mu mi he ni mba”. ");
INSERT INTO jid_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bitru aye nda ye tre ni Yesu, “Baci vayimu ni tie latre ni mu mla inkpu bren rli mika wruhle niwu? Tona mla ikpu tangban?” ");
INSERT INTO jid_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu a saa nda hla wu, “Mina hla niwu ndi inkpu tangban na, ndu tangban tie nkpu se tangban. ");
INSERT INTO jid_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","To kima me mulki shulu he to ichu ri wa a son bla ikpi ma niwo granma ba. ");
INSERT INTO jid_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Asi bla rji nigranma u mumla wa ata hu talent dubu setra. ");
INSERT INTO jid_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ana ye ni nkon u hanwu na u tie koh ma ka yo ba' ndu ba' vuu ni wama u mrli ma na ikpyi ma wawuu le nda han. ");
INSERT INTO jid_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","U granma ka kujoku ni meme nda kukhwu nda tre, 'Tie koh mu, vu gble ni mu, mi hanwu wawuu'. ");
INSERT INTO jid_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A lo tiekoh gran kima sron wa ka cuu cuwo nda wru ihla hle ni wu. ");
INSERT INTO jid_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","U gran kima a rju nda ka to gran ri ikpan u ndu ma wa ata hu hla dinari se wlon. A krjuu vu nda mawu toh nda tre han me hla wa mi hua. ");
INSERT INTO jid_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","U ikpan ndu ma igran a brewu vu gble nimu mi hanwu ikpye wa mi kpaa wawuu? ");
INSERT INTO jid_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","U gran u mumla ka kama. A tie sron nda nji wu ka tro zi inton wa ani hanwua. ");
INSERT INTO jid_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wa imbru gran barima ba toh kpye a towa isron mba ka tie meme. Bahi ka hla tre a wawuu ni tiekoh mba. ");
INSERT INTO jid_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","U tiekoh gran mua ka yowu nda tre, “Iwu meme gran” mi wru hla me hle niwu wawuu ni tu wa u bre me a. ");
INSERT INTO jid_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Iwu una wruhle ni nkpan ndu me nawa mi wruhle ni wu ana? ");
INSERT INTO jid_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tiekoh ma a tie nfu ni wu nda kawu nno bi tie ndi ya ni ndu han hla wawuu rli baka cuu cuwo. ");
INSERT INTO jid_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A nakima itie mu wa ahe ni shulu a ni tie ni yiwu bi wa bata na wruhle ni mrli vayi mba rji ni mi drii na. ");
INSERT INTO jid_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ahe ni wa Yesu a hla tre biyi kle a, wa a wlu ni Galili hi nklan u Yuhudiya ni ko gran inne urdu. ");
INSERT INTO jid_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gbugbu ndi baka hu, u wa a den ba. ");
INSERT INTO jid_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisawa baye tsrawu nda mye wu, A he tu nkon ndu lilon ga gran ni wa ma ni tu kpye? ");
INSERT INTO jid_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu a saa nda tre din “Bani kra ndi wawu wa atie ba rji ni mumla a tie ba lilon mba wa na? ");
INSERT INTO jid_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wawu wa atie mba a tre ngame din 'A nitu tre yi mba lilon ni kaa tiema ni yima don nda kabi ni wama u baba harli ba ba kati kpa ri. ");
INSERT INTO jid_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bana la harli ngana bahi kpa ririi. Tikima ikpye wa Rji kau kabia ndu ndjio ri gawu tie nkan na. ");
INSERT INTO jid_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","U baka hla niwu, U ni tu ngye mba Musa a hla ridu ta nno imbe u gagran ndi la zu wa? ");
INSERT INTO jid_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A hla ni bawu, “Ahe ni tu gbegbe sron mbi mba Musa a ndu yi zu mbambi, rji ni mumla ana he tokima na. ");
INSERT INTO jid_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mi hla yiwu, indi wa a zu wamaa, u wama he nitu wa lilon na, nda hi kagran ndji ri a tielatre u tie kan. ");
INSERT INTO jid_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mrli koh ba baka hla ni Yesu din “Ani ta he towa ni tu lilon mba wama, ka anabi ndu ndji gran na” ");
INSERT INTO jid_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","U Yesu ka hla bawu, “Ana ndji wawuu ba kpa tre yi na, se biwa ba kpa nyme ni bawu ndu ba kpa. ");
INSERT INTO jid_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bari ba he wa ba ngrji hama ni krju'a u indji bari ba ka kpamba tie bi krju'a kimba ni tu mulki u shulu. I wa ani to kpa itsro yi a. ");
INSERT INTO jid_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nikima baka nji kpran mrli bari ye ndu sawo nda tie aduwa ni bawu u mrli kolo maa baka zu ba. ");
INSERT INTO jid_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu a hla, “Don kpran mrli ba ndi ni zu ba ni ye ni mena, e mulki u shulu ahi u bibi mba yi” ");
INSERT INTO jid_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A kawo ma sa ni tu mba nda wlu ni kima hi kpama. ");
INSERT INTO jid_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","U indji ri aye ni Yesu nda tre, “Mala ayi ngye zizi wa ahi gbigbi ndu mi tiewu ni kpa son u kasese? ");
INSERT INTO jid_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu a tre din, “A ni tu ngye rli u mye me ikpye u zizi? Ahi ririyi megyen ahi zizi u ani ta ndi wu wa uri ni son kase, uka hu doka ba” ");
INSERT INTO jid_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Igua ka hla wu “ Doka bari me?” Yesu hla wu na y'ba wo na tie kan na, na y'bi na, na klri ni gon ndji nice na. ");
INSERT INTO jid_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wo tieme mba yime ndi son vayi me towa u son kpame a ");
INSERT INTO jid_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","U vrenze a hla niwu “Ikpyi bayi mi tie ba wawuu ye. Ahi ngye rli don mu?” ");
INSERT INTO jid_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu a hiawu, U tina son ku nyren na uka hi vu kpyi me le ndi kpa klen a nnobi ya tokima u he ni kpyi ni shulu. ");
INSERT INTO jid_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","U wa vrenze'a wo kpye wa Yesu trea a k'ma hi kpama gbo dodo me ni tu wa ahe ni kpyi gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ka treni mrli koh ma ba “Njanjimu mi hla ni yiwu ahe ni dii ndu ndji u wo ndu ri ni igbu chu u shulu. ");
INSERT INTO jid_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi hla yiwa ngarli, Ani he dii ni ndji u wo ndu ri ni gbu u chu shulu zan wa lakrumi ka ri ni ndo nnro” ");
INSERT INTO jid_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niwa mrli kohma ba wo tokima baka manji ma wakran nda tre “Wa nha mba ni j'bu?” ");
INSERT INTO jid_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu aya ba nda tre, “Ni ndji ana ti tu u ni Rji ikpi wawu mba wu ba tie tu” ");
INSERT INTO jid_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nikiyi Bitru ka saa nda tre niwu “To kie ka ko ngyeri don ndi huu. A ngyeri mba ki he wu?” ");
INSERT INTO jid_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu a tre ni mba “Njanjimu mi hla yiwu ni ngyrji u saa ni nton wa Ivren Ndji ni son ni ruron ma u chua biyi wa bi hume a bi son ni ruron chu tso ndi tron igrji tso u Israila. ");
INSERT INTO jid_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iwa aka ba koh, mrli vayi lilon, vayi mrli mba, itie, iyi, imrli, ka ba rju ni tu nde mu, ani kpa mla nkpu se wlon nda son kasese. ");
INSERT INTO jid_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","U gbugbu wu wa ba bi u mumla ba k'ma tie bi klekle u bi klekle a ba katiebi mumla. ");
INSERT INTO jid_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Igbu chu u shulu ahe too ndji wa ahe ni rju'a nda wlu ni bwubwu mble ka vu lebra wa ba tie ndu ni rjumaa. ");
INSERT INTO jid_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Niwa ba kpa nyme ni han ba dinari ri nivi waka tru ba hi ni rjumaa. ");
INSERT INTO jid_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ala rju ngarli ni wru nton u traa nda to lebra bari baki megyen ni bubu cucu. ");
INSERT INTO jid_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A hla bawu biyi me hi ndi hi tie ndu nimu ni rjua, u ikpye wa a vua mi hanyi. U ba hi ka tie ndua. ");
INSERT INTO jid_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ala rju ngarli ni wru nton u tanne mba ni wru nton u tia nda tie to u mumla. ");
INSERT INTO jid_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngarli ni nton u puo a rju hi nda ka toh bari ba krli megyen. A hla bawu 'Bi tie he ndi krli wuu via kle megyen?' ");
INSERT INTO jid_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","U baka hla niwu, E indjio na nnota ndu na mba u kie ki towa. Wa a hla bawu, 'Biyi me hi ni rjua. ");
INSERT INTO jid_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wa yalu a tie a indji u rjua ka hla ni manaja ma, Yo bi ndu ba ndi han ba dii mba, U han rji ni bi wa ba ye ni klekle hi ni bi mumlaa. ");
INSERT INTO jid_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Niwa bi vu ndu ni yalu ba yea ba han ba tsra ni han u bi tie ndu viri. ");
INSERT INTO jid_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Niwa bi vu ndu rji ni mble kurji ba ye a, ba yo sron ndi ba han ba zan bi wa baye ni ko gon a, u ba han ba dinari yiyri. ");
INSERT INTO jid_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa ba kpa dii mba baka c'ba tre nitu indji u rjua. ");
INSERT INTO jid_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ba tre “Biyi wa ye klekle a, i wru nton ririyi megyen ba tie ndua, u hanba tsra ni u mbu wa kie tie ya ni mi rjia. ");
INSERT INTO jid_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","U indji u rjua a saa ni ri mba nda tre Ikpan mu mi na tie meme ni yiwu na. E kie y'me ndi mi han yi ni ndu u vi, ka ana to kima na? ");
INSERT INTO jid_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kpa kpye wa u bi ya ndi hi kpa mbi. Ahi son sron mu ndu mi nno wa ba ye klekle tsra ni han mbia. ");
INSERT INTO jid_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ana bi ndu me tie kpye wa mi son ni kpi mu na? Ka bi ki tie nghu mu ni zizi wa mi tie a? ");
INSERT INTO jid_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ahe to kima yi, bi klekle ba katie bi mumla u bi mumla ba k'ma tie be klekle” ");
INSERT INTO jid_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu si hi ni Urushalima, a nji tso ba hi ni nhma kori u ni gon a hla bawu. ");
INSERT INTO jid_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","To mba kie si ni Urushalima u ba vu vren Ndji ka nno Firist bi ninkon ni bi nha. Ba hi lowu ni tre u wuu. ");
INSERT INTO jid_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nda vuu no gbu ndji ndu ba chau ya'ya' nda tsi wu nda kpanwu ni gran nhma kukton u ni vi u tra ba nzu wu wlunde”. ");
INSERT INTO jid_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nikiyi iyi myrli Zabadi a nji myrli ma myli ilonye ni Yesu. A kukhwu ni k'bu ma nda ni mye wu kpye. ");
INSERT INTO jid_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu a mye wu, “U wa mi tie ngye niwu?” A hla niwu, “Mison ndu nyme ni myrli mu ndu son ni gbuchu u me, iri ni wo rli me u rima ni wo ta' u me. ");
INSERT INTO jid_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","U Yesu ka saa niwu nda tre, “Bina toh kpye wa bi ki bre a na. Ni to so ni mi gbanju wa me tie whiewhiere u so a?” U baka hla niwu, “E kie toh so” ");
INSERT INTO jid_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A hla ni bawu “Anita ni gbanju wa mi so, bi soo. U son ni woo rli mu mba wo kota mu ana mayi mi nno na ahi u bi wa Itu mu tie zi ni bawu a”. ");
INSERT INTO jid_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Niwa imbru myrli koh ma wlon ba ye wo towa bala vra nfu ni myrli vayi harli ba. ");
INSERT INTO jid_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","U Yesu ka yo ba ye ni kpama nda tre “ Bi toh bi chu u line barima ba tsro ba ndi ba chu bi ninkon bi gbu a ba tsro ba ndi ba chu bi ninkon bi gbua ba tsro ba gbengblen. ");
INSERT INTO jid_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ana to kima bi tie na. Indi wa anison he ninkon nimi mbi gbigbi ka katie vrenko mbi, ");
INSERT INTO jid_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","u indi u wa he u mumla nimi mbi ka katie vren koh mbi, ");
INSERT INTO jid_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","na u Ivren Ndji iye ma na u wa ba tie ndu niwu ana a wa aye tie ndu nda nno tuma ndu ndji gbugbuwu jubu.” ");
INSERT INTO jid_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wa ba rju rji ni Yariko a kpentren ndji baka huu. ");
INSERT INTO jid_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba to bi fyen harli ba ki ni nyu nkon wa bi fyen ba ba' wo ndi Yesu mba ka si hi, u baka kla gblo nyu nda ni tre. “Baci Ivren Doda, woyi mbu”. ");
INSERT INTO jid_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","U ndji baka kpa nha ni ba nda hla ndu ki ni ngbangbi. U ni nakime, bi fyen ba la kla gblo nyu zan u mumla nda tre, “Baci Ivren Doda, wo yi mbu” ");
INSERT INTO jid_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nikima, Yesu ka kukri kpyen me nda yo mba nda tre, “ Bi wa ndu me tie ngyeri ni yiwu?” ");
INSERT INTO jid_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baka hla niwu, “Baci, i wa ndu shishi mbu bwu” ");
INSERT INTO jid_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","U wa alo Yesu sron ka kpyre shishi mba. U ni kiyime shishi ba tie gbla bwu' u baka toh kpan nda huu. ");
INSERT INTO jid_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wa Yesu ni mrli koh ma ba hi ka tie whiewhiere ni Urushalima nda hi ni ngblu u Zaitun u Betafaji, u Yesu ka ton mrli koh ma ha bari, ");
INSERT INTO jid_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nda hla ni bawu, “Hi ni vi gbu u whiewhiere yi u bi toh ba lo nankpron mba vren nankpron bari zi. Si ba ndi nji ba ye nimu. ");
INSERT INTO jid_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Indrjori nita mye yi kpye, bika hla ndi, 'Bachi ni tie ndu niwu,' u ndji kima ni gbla nno yi ni mba.” ");
INSERT INTO jid_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bati wayi ni ndu ku gyren me ni tre wa ba hlawu ni nyu anabia. A tre ndi, ");
INSERT INTO jid_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hla ni vrenwa u Sihiyona, 'Toh yi, Ichu mbi si ye ni yi,' U katu grji nda hon ni nankpron wa ahi vren maa.'” ");
INSERT INTO jid_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","U mrli koh ma ba hi nda ka tie towa Yesu a hla ni bawu'a. ");
INSERT INTO jid_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba ka nji nankpron a mba vren maa ye, nda vu ba nklon ba sa nitu mba, u Yesu ka hon son ni tu kpi mba. ");
INSERT INTO jid_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Imbru gbugbu ndji ba ba ka ba nklon mba l'ba ni wu nitu nkon, u bari baka tsen vunvu kunkron sru ni nkon a. ");
INSERT INTO jid_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","U ijbu ndji biwa ba he ni ko shishi ma, ni biwa ba he ko gon maa, baka kla ngblo nyu nda ni hla ndi, “Hosanna ni vren Doda! Wawu wa a si ye nimi ndi Bachi, ahe ni lulu! Hosanna hi ni shu babran!” ");
INSERT INTO jid_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Niwa Yesu a ri ni Urushalima u muu ma ka suni gbua u ba tre ndi, “Ihi nha mu yi?” ");
INSERT INTO jid_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","U ijbu ndji ba ba saa ndi, “Iwayi hi Yesu anabi wa a rji ni Galilia.” ");
INSERT INTO jid_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","U Yesu ka ri ni Hekali. A zu bi le ni bi le ni rju nda tru ba tebru u bi sran nklen ni u bi le tatabara (nghwu) ");
INSERT INTO jid_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A hla bawu, “Ba nha ndi, 'Ikoh mu ba yowu nda hi koh u aduwa.' u bi kawu tie fron u bi ybi.” ");
INSERT INTO jid_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","U bi fyen ni bi c'bi za baka ye niwu ni Hekalia wa'a den ba. ");
INSERT INTO jid_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Niwa Prist bi ninkon ba ni bi tsro ataura ba toh ba kpyi wa a tie u ba manji mba wakran nda lawo mrli ba bubu kla ngblo nyu nimi Hekali nda ni tre, “Hosanna ni vren Doda,” u baka vra nfu. ");
INSERT INTO jid_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Baka hla niwu, “U si wo kpye wa ndji biyi ba ki trea?” Yesu a hla bawu, “Ee! U bina kra na ndi, 'Rji ni nyu kpran mrli ni bi ma sisan u yo gbyre san?” ");
INSERT INTO jid_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","U Yesu ka kab don nda rju hi ni kiekle gbu Betani nda kru ni kima. ");
INSERT INTO jid_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ni mble a kma si ye ni gbua, u iyon ka tiwu. ");
INSERT INTO jid_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A to nci mbua ni nyu nkon, nda hi ni kima nda hi ni nci ma nda ka toh a hi kpukpa vunvu yi hama ni klo. A hla niwu, “Na la klo ngana sese kase,” u mbua tsi klu ");
INSERT INTO jid_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Niwa mrli koh ma ba toh a, ba manji ma wakran nda tre, “Anihe mu rli imbua tsi klu?” ");
INSERT INTO jid_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu a saa nda hla bawu, “Njanji mu mi hla yiwu, bita he ni nkpon nji ndi na rju ni sron na, bina tie kpye wa ba tie ni mbua yi a megyen, bi hla ni ngblu yi, “Chu hi ku ni mma, u wani he tokima. ");
INSERT INTO jid_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ikpye wa bi mye ni aduwa ndi nyme, bi kpa.” ");
INSERT INTO jid_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Niwa Yesu ari ni hekalia, u Prist bi ninkon ni cice ba ye niwu kasia tsro nda tre, “Ani ngbengblen rime u tie kpyi biyi, wa hi nha nno wu gbengblen yi? ");
INSERT INTO jid_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu a saa nda hla ni bawu, “I me ngame mi mye yi imye ri. Bita hla mu ime me mi hla ni yiwu ka ni ngbengblen rime mi tie kpyi biyi. ");
INSERT INTO jid_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Batisma u Yohana - a rji ni mma meyi? A rji ni shulu ka a rji ni ba ndji? U baka sron mu ni kpa mba, nda tre, “Kita tre ndi, a rji ni shulu, ani hla tawu, wa ngye tie bina kpau nyme na? ");
INSERT INTO jid_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","U kie ta hla, 'a rji ni ndji,' kie klu sissri ndji, wa ba toh Yohana ahi anabi.” ");
INSERT INTO jid_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","U baka saa ni Yesu na hla, “Kie na toh na.” Wawu ngame hla ni bawu ndi, “Ime me mina hla yiwu ka ni ngbengblen rime mi tie kpi biyi na. ");
INSERT INTO jid_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","U biki ta mre nihe? Indji a he ni mri lon ha. Ahi ni u mumla nda tre, 'vrenmu, hi tie ndu ni rju luwa.' ");
INSERT INTO jid_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ivren a ka saa nda tre, Mi na hina aye tamre ni ko gon nda ye hi. ");
INSERT INTO jid_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","U igua hi ni vren u ha nda hla wu toh u rima. Ivren yi a saa nda hla, 'Mi hi, Tietie, nda na ye hi na. ");
INSERT INTO jid_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A hi rime nimi mri ha ba a tie kpye wa tie mba a son a?” Baka hla, “U mumlaa.” Yesu ka hla ni bawu, “Njanji mu mi hla ni yiwu, bi kpa ban ni bi tie ntran ba ri ni gbu u chu Rji guchi ni yiwu. ");
INSERT INTO jid_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohana a ye niyi ni ngon u ndindi, u bika na nyme niwu na, u bi kpa' ban ni bi tie ntran baka nyme niwu. U biyi wa bi toh towa, bi na yo ru ru ndi nyme ni wu na. ");
INSERT INTO jid_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","La wo njo ri ngari. Indji ri ahe ni rju. A sen kpyi ni mima, nda hrawu kagon ma, nda shi juju u shbi ma klo inabi ni rjua, nda la mme koh ri guglo ma nda nno rjua ni wo bi ron bari. Nda hi ni gbu ri. ");
INSERT INTO jid_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wa nton u shbi inabi a tie whiewhiere, a ton gran ma bari hi ndu ba kpa klo ma nji wu. ");
INSERT INTO jid_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","U bi ya rju'a baka vu gran ma ba nda tsi ri mba, nda wuu ri nda ta rima ni tita. ");
INSERT INTO jid_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","U ndji u rju'a ala ton gran ma bari wa ba nna bi mumla, u bi ron rju'a baka tie ni bawu towa ba tie ni bi mumla'a. ");
INSERT INTO jid_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Indji u rju'a a ye ton vren ma hi ni ko gon bi mu ba, nda tre, ba wo vren mu'a. ");
INSERT INTO jid_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","U wa bi ron ba ba toh vren'a, ba tre ni kpamba, Iwayi yi hi wa ani son nyu ma, ye, kie wuu ndi kpa rju'a. ");
INSERT INTO jid_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","U baka vu rju ni rju'a taga nda wuu. ");
INSERT INTO jid_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","U indji u rju'a nita ye, ani tie bi ron ba ni he? ");
INSERT INTO jid_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","U ba hla wu, “Ani wuu meme bi ron ba ni kpukpo ya,' nda ka rju'a nno bi ron bari wa ba ka hanwu ni nton wa inebi tie a. ");
INSERT INTO jid_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu a hla ni bwu, “Bi na kra ni tre Irji na, 'Tita wa bi mme ba kamba niwu a ka tie tita u nfron ma. Iwa yi ahi tie u Irji nda bi ni shishi mbu? ");
INSERT INTO jid_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nitu kimayi me hla yiwu, ba kpa gbu u chu Irji niyi nda ka nno u ko ra ri wa ani ti ndindia. ");
INSERT INTO jid_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","U wa a rjoku nitu tita yia, ani chon tie rjuru me. U nitu ndji wa ku'a ani Myrian wu.” ");
INSERT INTO jid_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wa Prist bi ninkon ba ni ba Farisawa ba wo njo maa, baka toh nda asi tre nitu mba. ");
INSERT INTO jid_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba wa nkon u vu nda klu sissri jbu ndji ba, nitu wa indji ba ban wu nda a hi anabi. ");
INSERT INTO jid_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu a tre ni ba ngari ni misali a ndi, ");
INSERT INTO jid_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Igbu u chu ngbungblu'a he na ichu ri wa si tie gran ni vren ma. ");
INSERT INTO jid_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atru ba gran ma ndu ba hi yo bi wa bana hla bawu ndu ba ye ni lo gran, u bana ye na. ");
INSERT INTO jid_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","U chua ala ton gran ma bari nda tre, 'Hla ni biwa mi yo ba, Tomba, mi kle biri u gran ye. Mi han kiekle lando lilon, ni ba mri nze lando ni mbrukpi ba mi tie ba wawuu ye ni bubu gran.' ");
INSERT INTO jid_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","U ndi bi kima ba kana nyme ni yo'a na nda hi kpa mla Iri hi rju, u ri bubu u lema. ");
INSERT INTO jid_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Imbru mba baka vu ba gran chu'a nno ba nkpon ya, nda wuu ba.' ");
INSERT INTO jid_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","U ichu'a ka tie nfu, nda ton ba soja ma hi ka suu tu biwa ba wuugran ba nda gon gbu mba. ");
INSERT INTO jid_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nikima, a hla ni ba gran ma ba, 'Ba kle ndu u gran a ye u bi wa bayo ba'a bana mlau ye na. ");
INSERT INTO jid_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nitu kimayi bika hi ni nyu nkon ndi yo gbugbu ndji wa bi toh a ndu ba ye ni gran'a. ");
INSERT INTO jid_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Igran ba baka hi ni nkon nda ka gbu ndji wa ba toh a ye, ni bi bima niwa bana bina. U tra u gran ka su pui me ni bi tsri. ");
INSERT INTO jid_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","U chu'a ye nda ni toh bi tsri ba, nda toh indji ri wa ana sru kpi u gran na. ");
INSERT INTO jid_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","U chua mye, 'Ikpan mu, u tie ni he ndi ri ye wa hama ni kpi u gran?' Igua ka wa ikpye u trea hama. ");
INSERT INTO jid_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","U chua hla ni gran ma ba, 'Vu ghuyi lo' woni za, ndi kau taga ni mi bwu,' iwrji wa ani yi nda tan nyinyiere na. ");
INSERT INTO jid_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ahi ndi gbugbu wa ba yo, u fyi me yi ba chu ba.'” ");
INSERT INTO jid_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","U Farisawa ba baka hi nda ka sron mu u nkon wa la vu ni tre ma'a. ");
INSERT INTO jid_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Baka tru mri koh ba ni Hirudiyawa hi ni wu. Baka tre na Yesu, “Mala, kie toh wu u indji u hla tre njanji, ndi ni tsro nkon Bachi njanji me. U na ya kri ni tre ndi na ndji na tsro son tu ni ndji na. ");
INSERT INTO jid_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hla tawu, ahi ngye hi mre me? A he tu nkon ndu ba han ban ni Kaisar ka a'an?” ");
INSERT INTO jid_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","U Yesu a toh meme mba nda tre, “Anitu ngye mba bi tsra me, biyi bi tie brji? ");
INSERT INTO jid_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tsro me nklen u bana. “Niki yi baka nji dinari ri ye nno. ");
INSERT INTO jid_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu a tre ni ba, “Ahi yu nha ni nde nha mba he ni wayi? ");
INSERT INTO jid_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","U ba hla wu, “Ahi u Kaisar.” U Yesu ka hla bawu, “To kima, nno Kaisar ikpyi bi Kaisar, u ni Irji ikpi bi Irji. ");
INSERT INTO jid_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wa ba wo toyi, baka manji ma wakran. Ba donwu me nda hi kpa mba. ");
INSERT INTO jid_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ni vi kima Sadukiyawa bari, wa ba hla ndi tash'me na he na, ba ye niwu. Ba mye wu, ");
INSERT INTO jid_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ndi, “Mala, Musa a hla, 'Indji wa a khwu nda na he ni mri naa, a gbigbi ndu vayi ma ndu gran wama nda ngrji mri ni vayi ma. ");
INSERT INTO jid_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Imri vayi bari tangban ba na he. U mumla a gran nda kwu. Nitu wa ana ka mri don na, a ka wama don ni vayi maa. ");
INSERT INTO jid_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","U vayi ma u haa ngame ala tie tokima me, u'u traa me, hi niwu tangban a. ");
INSERT INTO jid_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iwa ngame ye khwu hu ba tangban mbawu. ");
INSERT INTO jid_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","U ni vi u tash'me, iwaa ni u nha nime tangban ba? Niwa wawu mbawu ba gran wu. ");
INSERT INTO jid_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu a saa nda hla bawu, “Bi kadu, niwa bi na toh embe ba na ni ngbengblen Irji na. ");
INSERT INTO jid_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ni tash'me a, bana gran na nda na nno gran na. Ana he tokima na, ba he tu Malaiku bi shulu. ");
INSERT INTO jid_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","U nitu tash'me bi khwu, bina kra kpye wa Rji hla yiwu, nda tre, ");
INSERT INTO jid_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Mi hi Rji u Ibrahim, ni Irji u Ishaku, u ni Irji u Yakubu?' Irji na Irji u wa ba khwu'a na, ahi wu wa ba he ni sisren.” ");
INSERT INTO jid_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wa jbu ndji ba ba wo wayi, baka manji tsro maa wakran. ");
INSERT INTO jid_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","U wa Farisawa ba wo ndi Yesu a kanyu Sadusiyawa ba, baka yo kpamba shu tie. ");
INSERT INTO jid_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iri mba, wa a kpa ka ni duu a, a myewu, nda ni tsra wu - ");
INSERT INTO jid_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mala, ni mi duu'a a riame mba nna wawuu?” ");
INSERT INTO jid_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu a hla niwu, “'Son Bachi Irji me ni sron me wawuu, ni dri me wawuu, u ni mre me wawuu.' ");
INSERT INTO jid_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I wayi hi kikle ni duu u mumla. ");
INSERT INTO jid_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","U uhamaa he to kima - 'Son mri vayi me na tume.' ");
INSERT INTO jid_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nitu duu hari biyi mba, inkpyi duu a ni anebi baba nji wu.” ");
INSERT INTO jid_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Niwa Farisawa ba ba kisi shu kpamba tiea, Yesu a nno mba mye ri. ");
INSERT INTO jid_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","A tre ndi, “Ahi ngye ri hi mre mbi ni tu Kristi? A hi vren nha?” Ba hla wu, “Ivren Doda.” ");
INSERT INTO jid_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu a hla baawu, “U ni he ri Doda a yo wu ni mi brji'a ndi Bachi, nda tre, ");
INSERT INTO jid_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Bachi hla ni Bachimu, “ Kuson ni wo korhi mu, se mi ka bi yowu ko shishi zi ni nda za me?'” ");
INSERT INTO jid_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","U Doda ani ta yo wawu wahi Kristi ndi 'Bachi,' u nihe ahi vren Doda?” ");
INSERT INTO jid_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Indrjo ri ana he nyu u saa kpe ri ni wu na, u indrjo ri na la mye wu kpe ri rji ni vi kima ngana. ");
INSERT INTO jid_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","U Yesu a tre ni jbu ndji u ni mri koh Ma. ");
INSERT INTO jid_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","A hla, “Bi nha ni ba Farisawa ba son ni ruron Musa. ");
INSERT INTO jid_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nakima, ikpye wa bi yoyi tie'a, tie ba ndi hu nji ba. Na hu ndu mba na, nitu wa ba kpi wa ba hla, bana tie ba na. ");
INSERT INTO jid_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","E, ba vu kpyi bi ron ma wa ba tie di lu'a ka saa ni ndji ni ngban. U ba ba kimba bana nzu vren wo ri nda ban ba na. ");
INSERT INTO jid_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba tie ndu ba u ndu ndji toh. Ba wran kpo u embe mba bwu na bwu nyu wo ba nklon ba tie pli me. ");
INSERT INTO jid_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ba son ta ki ni bubu bi ninkon ni wrji bi tie gan mba bubu ninkon ni mi Sinagog, ");
INSERT INTO jid_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ni bi chi kanmu, ni ndu ndji yo ba, 'Mala.' ");
INSERT INTO jid_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","U bi na ndu ba yoyi ndi 'Mala' na, niwa bi he ni mala rirrii, u bi mri vayi wawu mbi wu. ");
INSERT INTO jid_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ndi na yo ndrjo ni ngbungblua ndi Tie me na, niwa wu he ni Tie ririi u wa he ni shulu. ");
INSERT INTO jid_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndu ba na yoyi ndi 'Mala' na, niwa bi he ni Mala ririi, wawu yi Kristi. ");
INSERT INTO jid_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","U wa ahi ninkon mbi a ni katie vren koh mbi. ");
INSERT INTO jid_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Indji wa a nzu tuma, ba kau grji, u wa a katu ma grji, ba nzuu. ");
INSERT INTO jid_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iya mbi bi nha ni Farisawa, bi brji! Bi hra ndji nkon u ri ni gbu u chu shulu. Biyi bina rina, ndi na nyme bi son ria ndu ba ri na. ");
INSERT INTO jid_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Iya mbi, bi nha ni FArisawa, bi brji! Wa bi kpa mba bi kbo ni tie meme, ndi ni tsro ndi bi toh tie aduwa ngbondon ma. U nitu kima bi kpa ya gra zan. ");
INSERT INTO jid_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iya mbi bi nha ni Farisawa, bi brji! Bi ru gran ba nne ndi hi ba gbu ni hi wa indji ririi u to a huyi, bi kau tie meme nna vren u koh lu mla kpu hato biyi. ");
INSERT INTO jid_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iya mbi, bi tsro nkon ni fyifyen, biyi wa bi trea, 'Indji wa a shi rji ni hekali, ana kpye ri na. U ndi ndji wa a shirji ni dran u mi hekalia, shirji ma ni vuu.' ");
INSERT INTO jid_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Biyi ruru bi nfyen! Ahi rime bran zan, idran ka hekali wa a kpa dran tie tsratsra? ");
INSERT INTO jid_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","U, 'Iwa a shirji ni tu'u hekali a, ana kpye ri na. U wa a shirji ni kpyi wa ba tsi mba ni kima, shirji ma ni vu. ");
INSERT INTO jid_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Biyi bi nfyen! A riame bran zan, ikpi mba ka tu hekali a waa ka kpyi ba tie tsratsra? ");
INSERT INTO jid_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nakima yi, i wa a shirji ni tu hekali a, a shirji niwu mba ni ba kpi u mima. ");
INSERT INTO jid_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wa a shirji ni hekali a, a shirji niwu uni ndji wa ani son ni mi ma. ");
INSERT INTO jid_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","U iwa a shirji ni shulu a, a shirji ni kpanci Rji mba ni ndji wa a son tuma. ");
INSERT INTO jid_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iya mbi, bi nha ni Farisawa, bi brji! Bi nno iri nimi wlon u yan, ni nji ni ndi ka kpi bi duu birigra ba don ni zizi, ni kponji. A biyi yi ba mla ndu yi tie a, ana wa bina ka ba don na. ");
INSERT INTO jid_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Biyi bi tsro nkon ni fyifyen, biyi wa bi sh'bi ngblungbu rju ndi myriyen laklumi! ");
INSERT INTO jid_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Iya mbi, bi nha ni Farisawa, bi brji! Bi ngla kogon gbanju u gbakli kongo, u ni mi ba shu ni tie shishi ni myriyen ndji. ");
INSERT INTO jid_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ahi indji Farisi u nfyen! Guchi ngla mi gbanju a mba gbakli (kongo) a ni ndu ko ra'a tie tsratsra. ");
INSERT INTO jid_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Iya mbi, bi nha ni Farisawa, bi brji! Bi he too babe wa ba gban meme kinklan ni bawu'a, u ko ra mba ni bi ya, uni mii kwukwu kmo ni ba kpi bi rji ba shu ni wu. ");
INSERT INTO jid_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ahi tokima bi he ni shishi ndji wa ba toh yi tsratsra me ni kora u mi mbi shuni tie brji ni meme tie. ");
INSERT INTO jid_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iya mbi, bi nha ni Farisawa, Bi me ba be u ba anabi ndi mla be u bi ndji tsratsra tie. ");
INSERT INTO jid_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bi tre ndi, 'Ki na he ni nzan u ba tie mbu, ki ndi na yowo ni ba ndi ka yi hle ba anabi ba hle na.' ");
INSERT INTO jid_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nakima, biyi kimbi bi tron ndi bi mri u bi wa ba wuu ba anabi ba. ");
INSERT INTO jid_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","U biyi me bi ye shu kongo u tsra u ba tie mbi'a. ");
INSERT INTO jid_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Biyi wan, imri grache, bi tie ni he ba ndi nawo ni tron u gbarji lu u kasese? ");
INSERT INTO jid_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tokima, to yi, misi ton ba anabi ni bi he toh ni bi nha ye ni yi. Bari mba bi wuu ba ndi kpan ba ni nh'ma kunkron, u bari bi tsi ba ni sinagog mbi ndi zu mba hu ba gbu ba. ");
INSERT INTO jid_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ikle mani he wa ni tu mbi mba iyi u bi tsratsra hle ni ngbungblua, rji ni yi Habila tsratsra hi ni yi zakariya ivren Barakiya, bi wuu gan ni hekalia nitu hekalia. ");
INSERT INTO jid_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Njanjimu mi hla, ikpyi biyi baye ni tu mbi ni nzan yi. ");
INSERT INTO jid_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Urushalima, Urushalima, uwu wa u wuu anabi ba ndi ta wa ba ton ba yeni wua ni tita! Inkpu bren mba mi son mi vruyi shutie towa kuko ni vu mri ma shu ka ni ngban ma, a bi kambi! ");
INSERT INTO jid_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","To, ba ka koh me don na k'bo. ");
INSERT INTO jid_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","U mi hla yiwu, bi na la toh me rji zizan yi se bi tre, 'Lulu he nitu ndji wa a ye ni ndi Bachi'a.'” ");
INSERT INTO jid_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu a rju ni mi hekali nda vu nkon ma hi. Mri koh ma baka ye nda ni trso wu ime hekali. ");
INSERT INTO jid_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","U wa a saa ni bawu, “Bi to ikpi biyi wawuu? Mi mla yiwu njanjimu, ba na don tita riri me zi nitu ri na. ");
INSERT INTO jid_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Niwa a kuson ni ngblu Zaitun a, mri koh ma to ye niwu ni ya y'bi nda tre, “Hla tawu, ani tanyi mba ikpi biyi ba tie? Ahi ngye ri ni hi ingban u ye me ni inton u kle a?” ");
INSERT INTO jid_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu a saa nda tre ni mba, “Tie sisren ndi ndu ndrjo ri na kayi rji na. ");
INSERT INTO jid_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bari baye gbugbu mbawu ni nde mu. Ba tre ndi, 'Ime yi mi Kristi'a,' nda ka ndji gbugbuu rji. ");
INSERT INTO jid_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bi wo ba ku ni dbu ba ku. Ki kpyen ndi na tie sissri na, ahi gbigbi waa ikpi biyi ba tie a rliko inton ka kle. ");
INSERT INTO jid_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Meme ni wanyu ni meme, u igu u chu ri ni wanyu ni gbu u chu bari. Ba tie yon mba cu meme ni bubu nkankan. ");
INSERT INTO jid_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Biyi bahi kpi bi mumla towa ilo ngrji. ");
INSERT INTO jid_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hu gon niwa, ba vu yi nno tie ya nda wuu yi. Bi hra wawuu ba kran yi nitu nde mu. ");
INSERT INTO jid_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Rji ni wa, indji gbugbuwu ba rjoku nda le ni kpamba nda kran kpamba. ");
INSERT INTO jid_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anabi bi che gbugbuwu ba rju nda ka gbugbuwu rji. ");
INSERT INTO jid_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Niwa ison vlala ni babran, ison ndji gbugbu wu ni k'ma si. ");
INSERT INTO jid_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","U i wa a vusron hi kle'a, ani gbujbu. ");
INSERT INTO jid_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Itre ndindi yi u gbuchu ba d'bu ni ngbungblua wawuu nda hi shaida ni meme ba wawuu. Rji ni wayi inton u klea niye. ");
INSERT INTO jid_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nitu kima, biti toh kpe meme ma u cii, wa Daniya anabi hla'a, a kri ni zande ni bubu tsratsra” (ndu wa a si kra mla toh), ");
INSERT INTO jid_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ndu wa bahe ni Yahudawa tsutsu hi ni ba ngblu, ");
INSERT INTO jid_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“ndu wa ahe ni tunkan na grji hi ban kpe ni mi koh mana, ");
INSERT INTO jid_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","u ndu wa ahe ni rju na k'ma ye ban nklon ma na. ");
INSERT INTO jid_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Iya ni bi he nne ni bi mri nhanha ni vi bi kima! ");
INSERT INTO jid_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tie aduwa ndu vi tsutsu bi a he ni nton u wru ka Sabat na. ");
INSERT INTO jid_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kpukpo ya ni he biwa bana tie toh'a na rji ni mumla ngbungblu'a hi ye zizan yi, u, bana la tie'u ngana. ");
INSERT INTO jid_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A ndi na wa ba fon vi mba rju'a na, ikpe ri u tankpa ni tie bre nawo. Uni tu bi wa ba chuba'a ba gron vi mba. ");
INSERT INTO jid_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","U ndrjo nita hla yiwu, 'To, ngye Kristi'a yi!' ka, 'Kristi'a he mu!' na kpanyime na. ");
INSERT INTO jid_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kristi biche ni anabi biche ba wlu nda tie nban ni kagrji nda ka gbugbuwu rji, u nkon ni tie he, nhambi ni wa ba chuu baa. ");
INSERT INTO jid_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tomba, Mi myren hla yiwu guchi ni nton'a. ");
INSERT INTO jid_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tokima, ba ti hla ni yiwu, 'To, ahe ni miji,' na hi ni miji'a na. Ka, 'To, ahe ni mitra,' na kpanyime na. ");
INSERT INTO jid_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Towaa ani rhinzan kpan rji niko nzan hi ko yalu'a, ani he tokima me ni ye vren ndji. ");
INSERT INTO jid_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Iwrji wa k'mo nma he'a, nyulu ba shuki. ");
INSERT INTO jid_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ni kle nton u meme yaa, ni vi biki ikpan-rji ni katie bwu, u wha na nno kpan ma na, ba ntsintsen ba rjoku rji ni shu, u ba ngbengblen bi ba shulu ba ba grju. ");
INSERT INTO jid_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uni kiyi igban Vren Ndji ni tsro ni kplende su, u il'be bi ngbungblu'a wawu mbawu ba tie ruu. Ba toh Vren Ndji si ye nimi kpalu ni ngbengblen mba kiekle he ma u kpan ma. ");
INSERT INTO jid_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A ton Malaiku ma ni kiekle yi u njon, u ba vu biwa ba chu mba rji ni fron nzya ba, rji ni nchi shulu ri hi korima. ");
INSERT INTO jid_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ya ndi toh kpyeri mba ni kunkron bua. Nginga ma ba ta si t'bo nda ni tie nvunvu, bi to ndi isu tie whewhre. ");
INSERT INTO jid_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","U ngame, biti toh ba kpi biyi wawuu, bika toh ndi a tie whewhre, ni ba nkon tra ba. ");
INSERT INTO jid_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Njanjimu mi hla yiwu, inzan yi na y'ba hi na se ikpi bayi ba tie. ");
INSERT INTO jid_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Shulu mba meme ba y'ba hi, u ba tremu'a bana y'ba hi na ");
INSERT INTO jid_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","U ni tu vi mba nton kima, indrjo na toh na, hu ni Malaiku bi shulu, ka Ivren'a, se Wawu Tie'a megyen. ");
INSERT INTO jid_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na wa ahe ni nton u Nuhu, tokima me ani he ni ye u Vren Ndji. ");
INSERT INTO jid_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na ni nton u wa mma k'mo na ye rhina, bata rhi nda ta so, nda ta kpa gran nda nno gran, hi mla vi wa Nuhu a ri nimi ghwu'a, ");
INSERT INTO jid_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nda na toh kpe na ka mla wa imma k'mo'a ye kprume ni wawu mbawu - ahi naki iye u Vren Ndji nihe. ");
INSERT INTO jid_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","U indji lilon hari bahe ni rju - ba ban ri, nda don rima. ");
INSERT INTO jid_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Imba hari basi kon ni nnra - ba ban ri nda don rima. ");
INSERT INTO jid_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tokima, bika ki ni gben, niwa bina toh ka ni vi rhime Bachi ni ye na. ");
INSERT INTO jid_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","To wayi mbayi, Indji u koh andi toh ka ni nton rhime indji u y'bi ni ye ni chuu, a ndi son gben nda na ndu yra koh ma na. ");
INSERT INTO jid_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tokima, bika mla gben, niwa Ivren Ndji ni ye ni nton wa bina yo sron na. ");
INSERT INTO jid_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ahi nha hi vren koh u kponji nda he toh wa tiekoh ma a ka bi kohma don ni woma ndu ta nno ba birhi tsra ni nton rhi? ");
INSERT INTO jid_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ivren koh u lulu ahi waa tiekoh ma niye tooh asi tie kima ni k'ma ye ma. ");
INSERT INTO jid_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Njanji mu mi hla yiwu, tie koh maa ni yo kpi ma wawuu ni wo ma. ");
INSERT INTO jid_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","U meme vren-koh tre ni mi sron ma, 'Tie-koh mu a rhihe rhi,' ");
INSERT INTO jid_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nda ni tsi kpukpanma imbru mri-koh ba, nda rhi nda so ni bi wu'a, ");
INSERT INTO jid_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","u tie-koh u vren-koh kima niye ni vi wa vren-koh kima na yo sron na ni nton wa ana toh naa. ");
INSERT INTO jid_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tie-koh maa ni hanwu tie tsitsa-tsitsa me nda nno wu bubu ni bibrji, wa ni kima ani zia yi nda tan nyinyren. ");
INSERT INTO jid_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Igbuchu shulu ani he to mrli mba wlon wa ba vu ba fitila mba nda hi kpa ilon wa sa. ");
INSERT INTO jid_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Iton ni mi mba ba he toh, u ton ba na ruru. ");
INSERT INTO jid_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Niwa ruru mrli mbaa ba vu ba fitila mba nda na nji babran na. ");
INSERT INTO jid_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","U mrli mba bi hr to ha baka nji nye u ba fitila mba mla. ");
INSERT INTO jid_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ilon wasa ana ciciye na u baka ri druna hi mla ka kurna. ");
INSERT INTO jid_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","U ni tsutsu cuu baka dbu 'Lilon wasa ye'ye! Rju hi kpau. ");
INSERT INTO jid_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","U mrli mba wa wumba wu baka wlunde nda mla ba fitila mbo tie. ");
INSERT INTO jid_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bi ruru ba ba hla ni bi he to ha tie nye mbia nno ndu ba fitila mbu na khwu na. ");
INSERT INTO jid_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Bi he to h'a ba saa ni bawu inye a natsra tawu yayi na bika hi ni bi lenye'a ndi le u mbi. ");
INSERT INTO jid_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Waa ba hi le'nye'a, u ilon wasaa ri ubiwa bana mla ki gben'a ba rihu hi ni bubu lo gran u baka tro nkon traa. ");
INSERT INTO jid_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Imrli mba ba rima baka ye ni kogon nda tre Tiekoh, tiekoh, bwu nkon'a ni tawu! ");
INSERT INTO jid_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A saa ni bawu, 'Njanjimu mi hla yiwu mina toh yi na. ");
INSERT INTO jid_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","To kima bika mla ki ni tu wa bina toh vi ka nton'a na. ");
INSERT INTO jid_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ahe towa indji ri ta hi ni meme ri. A yo ba mrli koh ma nda nno ba kpyi ma. ");
INSERT INTO jid_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A nno ri mba talenti ton nda nno iha nda la nno ri ngame talenti iri. ");
INSERT INTO jid_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iwaa a kpa talenti ton a agbla hi nda ka tie ndu ni mba nda fe talenti ton bari ni tuma. ");
INSERT INTO jid_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","U wa a kpa harli'a a tie tokima me nda fe ha bari nha. ");
INSERT INTO jid_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Se waa a kpa talenti ri'a hi kpama nda shi juju ni meme nda ri nklen tie koh ma. ");
INSERT INTO jid_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tie koh mba aka son ban nton babran rlikoh nda k'ma ye ndu mrli koh maa ndu bla nklen ba nno. ");
INSERT INTO jid_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ivren koh wa akpa talenti ton'a a nji u ma ni talenti ton wa a hon'a nhaa nda tre, Tiekah mu, u ne talenti ton to yi mi fe talenti ton bari nhaa' ");
INSERT INTO jid_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Tiekoh ma a hlawu, u toh tie, vrenkoh ndindi ni u kponji! U tie njanji ni kpyi fyi me, mi yowu nji ikpyi gbugbuwu. Rihi ni takpe u tiekoh me'. ");
INSERT INTO jid_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ivren koh wa' a kpa talenti ha'a ye nda tre 'Tiekoh, u'ne talenti ha, Toyi, mi fe talenti ha bari nhaa'. ");
INSERT INTO jid_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tiekohma a hla wu, “u toh tie, vrenkoh ndindi ni u kponji! U tie njanji ni kpyi fyi me. mi yo wu ndu nji ikpyi gbugbuwu. Ri ni mi takpye tiekoh me. ");
INSERT INTO jid_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","U vrenkoh waa kpa talenti ri'a ye nda tre, Tiekoh, mitoh ndi u ndi wa ana tie ro na. U can ni wrji wa una cu'a na ndi ni vu ni wrji wa una hii na. ");
INSERT INTO jid_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mi klu sisri ndi nji talenti mea ka ri ni mi meme. Toyi kpa kpye wa u mea. ");
INSERT INTO jid_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","U tie koh ma ka saa niwu nda tre, u vrenkoh u' ridrii wa ani tie sankon'a, u toh ndi mi can ni ivrji wa mina cu'a na ndi ni vu ni wrji wa mina hii na. ");
INSERT INTO jid_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Una ka nklen mu'a nno banki to mina kmaye nii ka kpa kpye mu nha' ni wa a hon'a. ");
INSERT INTO jid_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ni tu kima, vu kpa talenti u wo ma ka nno u talenti wlon'a. ");
INSERT INTO jid_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ahi wa ahe wu'a bala nno nhaa gbugbuwu kahewu vlalala me. U wa nda na he ni kpye na ikpye wa umaa ba vu kpa. ");
INSERT INTO jid_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Vu vrenkoh u ridri yi wa ana hi ndu kpyeri tayo ni wrji u kplakpakpa bwu wa ani yi nda tan nyinyren'a. ");
INSERT INTO jid_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Niwa Ivren Ndji ni ye ni mi (he ma u kpan) ni malaiku ba wawuu, ani son ni kpancima u (daraja). ");
INSERT INTO jid_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ba vu bi kohra ba wawuu ziwu k'bu ma wani ga ndi ni yiyri towa ani ho n'ma bi koh ni ga nt'matie kan ni ba yawo. ");
INSERT INTO jid_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ani zi ntma ba ni wo korli na u yawo ba ni woma ko'ta. ");
INSERT INTO jid_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","U chu'a ni hla ni bi wo korli ma 'Ye biyi wa Tiemu tie luluni yiwu'a rini gbuchu wa be tie zi yiwu guci ni tie ngbungblua. ");
INSERT INTO jid_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iyon a tie me u bika ne rli hlan ma atie me u bika ne ma miso; mi ye tsri u bika kpame ri kohmbi, ");
INSERT INTO jid_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I he gbyre u bika sru nklon nimu milo u bika toh tie mu; mi he tro u bika zren yi ni me. ");
INSERT INTO jid_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","U bi tsratsra ba saa nda tre, 'Baci ani tanyi ki toh wu si tie yon ndi nno wu rli? Ka tie hlan ma ndi nno wu so? ");
INSERT INTO jid_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni tanyi ki toh wu ndji u tsri ndi kpau? Ka ni gbyre ndi nnowu nklon? ");
INSERT INTO jid_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nitanyi ki toh wu si lo ka nitro ndi ye niwu? ");
INSERT INTO jid_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","U chua ni saa nda tre Njanjimu mi hla yiwu ikpye'a bi tie ni ri wa zan tsi tsa me ni mi mrli vayi mu biyi a, bi tie nimu. ");
INSERT INTO jid_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Wa ni hla ni bi wo kota ma, Cbi dinkon mu wayi, biyi wa ba lanyu yiwu'a, hiri ni ilu u kakle wa ba tie ni brji ni malaiku ma. ");
INSERT INTO jid_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ni tu wa iyon a tie me u bika na rlina hlan ma tie ma bika na ne so na. ");
INSERT INTO jid_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi ye tsri u bika na kpame na mi he gbyre bika na ne nklon sru na ndi lo ndi he tro u bina tie kpye muna. ");
INSERT INTO jid_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","U ba saa ngame nda tre, Baci ani tanyi kie toh ni yon ka hlan ma ka ndji u tsri ka ni gbyre ka ni lilo, ka ni tro, u kie kana tie kpye wu na? ");
INSERT INTO jid_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","U ani saa ni bawu nda tre Njanjimu mi hla yiwu, ikpye wa bi na tie ni ri wa a zan fyime u mrli vayi mu na bina tie nimu na. ");
INSERT INTO jid_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Biyi bahi kpamba nimi ya'u kakle u bi tsratsra a nimi rai sese kase” ");
INSERT INTO jid_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Niwa Yesu a tre ni tu kpyi biyi kle wawuua, a hla ni mrli koh ma ba, ");
INSERT INTO jid_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Bi toh ndi ivi ha bati vu y'ba u vi u gan Rugran niye u ba vu Ivren Ndji nno ba kpan ni tu gran nhma kukron a” ");
INSERT INTO jid_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ba firist bi ninkon ba ni bi ninkon ndji ba, ba shubi ni koh chu firist wa ba yo wu ndi Kaifas. ");
INSERT INTO jid_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba sronmu ni yay'bi ni nkon wa ba vu yesu wuu'a. ");
INSERT INTO jid_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","U ba tre ndi, “Ana ni nton gan Rugran na ni ndu tsi na ka wlu na” ");
INSERT INTO jid_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ni nton wa Yesu he ni Betani ni koh Sima u kpurua, ");
INSERT INTO jid_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a si rli birli, u wari ka rihi ni kpala ba nye u tie le nda kasru ni tuma. ");
INSERT INTO jid_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","U wa mrli koh ma ba toh'a, ba vra nfu nda tre, “Ani tu ngye mba a nji nye yi si tie meme. ");
INSERT INTO jid_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ba ndi na le niwu nda kpa gbugbu nkle nno bi ya”. ");
INSERT INTO jid_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","U Yesu wa a toh mre mba a tre ni ba “Ni tu ngye bi yan wayi kpa? E a tie kpye ndindima ni mu. ");
INSERT INTO jid_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bizi he ni bi ya cacuwu u me bina zi he ni me na. ");
INSERT INTO jid_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wa a sru nyeyi ni kpamila a tie u rjumu. ");
INSERT INTO jid_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Njanjimu mi hla yiwu ni wrji wa ba d'bu itre zizi yi'a ni ngbungblua wawuu ba hla kpye wa iwa tie nda taka ma” ");
INSERT INTO jid_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","U ri nimi tso ba wa ba yowu ndi Yahuda Iskaroti kayi ni bi ninkon firist ba ");
INSERT INTO jid_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nda tre, “Bi ne ngye mindi vuu nno yi?” Ba tsra shekels u dran se'tra nnowu. ");
INSERT INTO jid_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Rji ni nton kima azi wa nkon wa ani vu nno ba' ");
INSERT INTO jid_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ni vi u mumla u gan rugran mrli koh ba ba' yeni Yesu nda tre, “Ni mameyi mba u son ki mla rli u gan rugran tie?” ");
INSERT INTO jid_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A hla “Hi ni ndji ri ni mi gbu ndi hla wu, mala tre “Inton tie whiewhiere. Mi tie gan rugran ni koh me ni mrli koh mu”. ");
INSERT INTO jid_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mrli koh ba ba' tie towa Yesu a hla bawu'a nda mla rli Rugran tie. ");
INSERT INTO jid_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wa yalu tie a, a son nda rli ni mrli koh ma tso'a. ");
INSERT INTO jid_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wa ba ki rli'a, a tre “Njanjimu me hla ni yi wu iri mbi ni le'nime” ");
INSERT INTO jid_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ba'ka yi ni sron, nda ni mye wuni yiyri, “Ani tie bre meyi ba' Baci?” ");
INSERT INTO jid_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A saa “Wawu wa ayo woma si rli ni me ni kongo'a ahi wawuu yi ni le ni me. ");
INSERT INTO jid_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ivren Ndji ni hi towa ba nha ni tuma. Iya ndji wani woma ba le ni Vren Ndji'a! A ndi na bi ndu bana ngrji wuna” ");
INSERT INTO jid_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda, wa ani le ni wu'a tre, “A hi me?” A hla niwu, “U hla ki me”. ");
INSERT INTO jid_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba si rli, Yesu ka ban bredi nda tie lulu nda mrewu. Aka nno mrli koh ba nda tre ka tan. Iwayi hi kpamu” ");
INSERT INTO jid_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A ban kofi'a nda ngri nda ko nno ba nda tre, so wawu mbi wu. ");
INSERT INTO jid_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iwayi hi yimu u shirji wa ba kau hlega ndu ba wru latre gbugbu ndji hle. ");
INSERT INTO jid_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi hla yiwu mina la'so ma (inabi) yi ngana se viwa mi sowu sisa niyi ni ngbuchu u tie mu” ");
INSERT INTO jid_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","W ba yo se'a ba rju hi ni ngblu u ze tun. ");
INSERT INTO jid_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","U Yesu hla bawu, “Wawu mbi wu bi joku ni tu mu ni cuyi, niwa ba nha 'Mi wru wa ani nji gran ba, u nt'ma bi gran ba shangblan. ");
INSERT INTO jid_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","U mi ta ye wlunde mi hi Galili guci yiwu” ");
INSERT INTO jid_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","U Bitru hla wu “U bata ni joku wawumba wu ni tie me, ime de mi tie bre joku” ");
INSERT INTO jid_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu hla wu, “Njanjimu mi hla wu, ni mi cuyi u kpatron tie kputra ndi wu toh me rli u gba ka tubu. ");
INSERT INTO jid_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitru a hla ni wu, “ Ani ta wa mi khwu ni wu'a mi na kpau tron” Ba mbru mrli koh ba ba tre kpye rirji me. ");
INSERT INTO jid_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ni nton kima, Yesu ahi bi ni ba ni wrji wa ba yowu ndi Getsemani nda hla ni mrli koh maa “Kuson wa u me mi ni wa mu' ndi tie aduwa” ");
INSERT INTO jid_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A nji Bitru ni mrli nlon Zabadi harli niwu nda si yi ni sron. ");
INSERT INTO jid_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A hla bawu, “Idri mu ni lome kpukpo me to mi khwu. Ki wa ndi gben ni me” ");
INSERT INTO jid_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A c'bi hi tsame, nda ku ni shishi nda tie aduwa. A tre, “Itie mu ani ta tie tu, ndu kofi yi y'ba me yo. Nakima ana mre muna nduhi mre me. ");
INSERT INTO jid_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A ye ni mrli koh ba nda toh basi kruna, nda hla ni Bitru, “A ngye, bina gben ni me u wru nton ri me na? ");
INSERT INTO jid_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gben ndi tie aduwa ndu yi na joku ni tsra na Isron'a ni son u kpa tie whie me” ");
INSERT INTO jid_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A hi kpama kpu uha nda tie aduwa. a tre, “ Itie mu iwa ni ta na y'ba hi na ndi gbigbi mi so wu mre me'a ka tie” ");
INSERT INTO jid_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A ye ngarli nda toh basi kruna, u shishi mba ba ron. ");
INSERT INTO jid_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ala ka ba don ngarli nda hi ka tie aduwa inkpu u tra nda la tre to wa a tre'a. ");
INSERT INTO jid_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","U Yesu a ye ni mrli koh ba nda tre ni bawu, “B i rli kruna, ndi ki kpami mengyen? To inton tie whiewhiere u ba le ni Vren Ndji ni wo bi latre. ");
INSERT INTO jid_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wlu, kie ndi hi. To, waa ani le' ni me'a ahe whiewhiere ni me” ");
INSERT INTO jid_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A he si tre, Yahuda iri nimi tsoba kaye Ijbu ndji ba hu rji ni ba'cu firist ni bininkon u ndjiba. Ba nji ba njingban ni ba kpala (ngbonhon). ");
INSERT INTO jid_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Indji wa ni le ni Yesu'a a tsro ba ngban nda hla “Indji wa me nha gboble ni wu'a, a wawuyi” Bika vuu. ");
INSERT INTO jid_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A gbla hi ni Yesu nda tre “Mi ci, mala!” nda nha gboble ni wu. ");
INSERT INTO jid_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu a hla niwu “Kpanmu, tie kpye wa u ye tie'a” U ba ye sawo mba ni tu Yesu nda vuu. ");
INSERT INTO jid_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","U ri wa ana he ni Yesu'a ka n'ma woma rju, nda cu inji ngban nda sren ton vrenkoh u chu firist cuu taga. ");
INSERT INTO jid_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","U Yesu hla wu, “Ka njingban me yo ni hra ma, e bi wa ba nzu ngban ani nji ngban ba khwu. ");
INSERT INTO jid_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka u ya mina toh yo tie mu ndu ton malaiku zan j'bu tso. ");
INSERT INTO jid_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","U ba tie ni he ndu tre u embe ba ndu tsra din a gbigbi ndu wa tie toyi. ");
INSERT INTO jid_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ni nton yi Yesu a hla ni j'bu ndji ba “Bi ye vu me ni nji ngban ni ngbonhon na mi ndji y'bi? cacuwu mi son ndi tsro ni hekali u bi na vu me na. ");
INSERT INTO jid_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ikpyi bayi wawuu ba tie ndu nha bi Totsu'a ye tsra” Nikima, mrli koh ba ba'ka tsutsu kau don. ");
INSERT INTO jid_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Biwa ba vu Yesu'a ba njiwu hi ni kaifas ninkon firist, u bi nha ni bi ninkon ba kia. ");
INSERT INTO jid_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","U Bitru kasi hu gbugbanmu hi ni koh ninkon u firist ba. A ri hi mi nda ka kuson ni bi gbyen ba nda ikpye'a ba ti'a. ");
INSERT INTO jid_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ninkon u firist ba ni (majalisa) basi wa kpye u ce wa ba hla ni tu Yesu nda vu wuu. ");
INSERT INTO jid_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bana vu ni kpyeri na, ko ni wa indji gbugbuwu ba rju nda tie ce. U indji harli bari ba rju ");
INSERT INTO jid_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nda tre, “Indji yi tre mi toh zi hekali Rji yi ndi mewu ni vi tra” ");
INSERT INTO jid_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ninkon u firist ba ka wlunde nda tre ni wu, “U na he kpye wa u saa na? Ahi ngye mba basi tre ni tu me?” ");
INSERT INTO jid_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","U Yesu ka krli ni ngbangbi. Injii ninkon u firist a tre, “ mi yo wu ni nde Rji u (sisren) hla ni tawu ka wuyi u Kristi Ivren Rji.” ");
INSERT INTO jid_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu saa ni wu, “U hla kime ye. U mi hla wu, rji zizanyi u toh Vren Ndji a son ni wo rli u ngbengblen nasi ye ni tu kpa u shulu” ");
INSERT INTO jid_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ninton kima injii ninkon u firist a y'ba ba nklon ma nda tre, “A tre latre!” u kie wa ngye ngarli? Tomba zizanyi kie wo latre'a. ");
INSERT INTO jid_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ahi ngye imre mbi? Ba saa nda tre “A mla u khwu” ");
INSERT INTO jid_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ninton kima, baka sru nten sruu ni shishi nda tsiwu nda kpan wu ni kprji wo mba, ");
INSERT INTO jid_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nda tre, hla tsu na tawu, uwu Kristi. Ahi nha mba Kpanwu?” ");
INSERT INTO jid_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bitru a son ni korah bubu u bla tre a, u vrenwa ri, igran kaye ni wu nda tre, “Iwu ngame u he ni Yesu ni Galili”. ");
INSERT INTO jid_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A kpatron ni shishi mba wawuu nda tre, “mina toh kpye wa u si tr'a na” ");
INSERT INTO jid_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niwa a rju hi ni nyu nkontra, ivren wa ri, igran a toh nda tre ni wa ba he ni kima, “Iguyi ana he ni Yesu u Nazaret”. ");
INSERT INTO jid_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wa'ka' kpatron nikima ngarli, nda shirji tia, a tre, “Mina toh Indji mba na!” ");
INSERT INTO jid_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Inton'a y'ba tsame u waa ba klri-krli a baka ye ni Bitru nda hla niwu, “cucu uri mba ngame, ilme a mba nhrawu. ");
INSERT INTO jid_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wa a ri la'nyu nda ni shirji nda ni tre, “Mina toh Indji mba na” U gba a ti gbla tubu. ");
INSERT INTO jid_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitru ka taka itre wa Yesu a hlaa, “U tie san mu ikpu tra rli u'gba ka tubu” A rju hi ni kahlan nda kayoi kpukpo me” ");
INSERT INTO jid_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wa' ble ye kpan ba firist bi ninkon ba ni bi ninkon u ndi ba ba' ka suron mu tie nkon u wuu. ");
INSERT INTO jid_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba lowu, nda njiwu hi ka nno Bilatus gona. ");
INSERT INTO jid_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","U Yahuda wa a le ni wu'a toh ndi ba wuu Yesu, awa' (sran mre ma) nda nji idran shekel setra'a ye ni' bi ninkon firist ba ni bi ninkon ndji ba, ");
INSERT INTO jid_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nda tre, “mi latre wa mi myren ndi wa ana tie latre naa” U ba tre, “Kima hi ngyeri tawu? To kpye wa u tie kime” ");
INSERT INTO jid_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A ka mrli dran ba ta hle ni mi hekali, nda rju hi ka ba don da ka klo kpame rjirji. ");
INSERT INTO jid_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ninkon u firist ba vu mrli dran ba nda tre, “Ana he ni nkon u duu'a ndu wayi ri ni (wron) na niwa a hi nklen yi” ");
INSERT INTO jid_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Baka tre ni kpamba nda ban nklen le rju u ri' wa baka ta rjuu bi tsri. ");
INSERT INTO jid_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nitu kimayi ba yo wrji kii ndi, “Bubu yi” ye' luwayi. ");
INSERT INTO jid_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A ye tsra ni kpye wa Rimiya u Totsu'a tre din, “Ba vu dran setra ba inklen wa imrli Israila bayo ni tuma, ");
INSERT INTO jid_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nda nno ni tu bubu ri, nawa Baci a yo ba tie'a. ");
INSERT INTO jid_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu a wlu ni shishi go naa, u gona kamye wu, “U chu Yahudawa?” Yesu a saa wu, “U hla me” ");
INSERT INTO jid_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","U wa bi ninkon u firist ba ni bi ninkon ndji ba ba' nhawu, ana tre kpye na. ");
INSERT INTO jid_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","U Bilatus tre ni wu, “Una wo ikpyi ba wawu mbawu wa ba nhawu na?” ");
INSERT INTO jid_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","U ana saa ikpye riri mena, waa a ndu gona (manji ma wakran). ");
INSERT INTO jid_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ninton u gan'u Rugran bata ndu gona cu ri nimi bi he tro'a wa ndji ba kpa y'me a cuwo. ");
INSERT INTO jid_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ninton kima, ba he ni indji ri ni tro wa a sentu'a u nde Barabas. ");
INSERT INTO jid_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wa baye kpan shuki a, bilatus ka tre ni ba, “Ahi nha mba bi son ndu mi cu cuwo ni yiwu? Barabas, ka Yesu wa ba yo wu Kristi? ");
INSERT INTO jid_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A toh ndi ba vu Yesu nno wawu nitu wa ba tie shishi ma. ");
INSERT INTO jid_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wa arli son tu kwancima ucu'a iwa a tru (ton) yewu nda hla, “ Rju ninkon ndji yi wa ana latre na. Mi tieya kpukpo me nicu luwa ni hra nituma” ");
INSERT INTO jid_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ni ntonyi firist bi ninkon ba ni bi ninkon indji ba, baka con j'bu ndji ba ndu ba cu Barabas cuwo na wuu Yesu. ");
INSERT INTO jid_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gona a mye ba “Ahi nha bi son mi cucuwo yi wu ni mi ndji ha bayi? Ba tre “Barabas” ");
INSERT INTO jid_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bitalus a tre ni ba “Mi tie he ni Yesu waba yo wu Kristi'a?” U ba saa wawu mbawu “Kpanwu ni gran nhama krukron” ");
INSERT INTO jid_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A tre “Nitu ngye, a tie nfye meme?” U ba saa wu wawumbawu ngbangbanme, kpanwu ni gran nh'ma kukron'a. ");
INSERT INTO jid_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Niwa Bilatus toh ndi wawu na toh tie kpyeri na u ndu tsi kana ye wluna a ban ma nglawoma ni shishi ndji ba ndatre, “Mi na he latre ni yi indji yi wa ana latre na” Tie kpye wa bi son” ");
INSERT INTO jid_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","U ndji ba wawuu baka tre “Ndu yima he ni tumbu ni mrli mbu”. ");
INSERT INTO jid_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wa a cu Barabas cuwo bawu nda tsi Yesu ni gbungban nda kau nno mba kpahi kpan. ");
INSERT INTO jid_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","U ba soja u gona baka ban Yesu hi ni hra u bubu bla trea nda nji jbu soja ye kima. ");
INSERT INTO jid_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba siwu nda lo pli samba niwu. ");
INSERT INTO jid_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ba tie roni ncon nda kason wu ni tu nda nno kpala ni worli ma. Ba kukhwu ngbarju nda cawu yaya nda tre “Ndu Rji ziwu ichu Yahudawa!” ");
INSERT INTO jid_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba sru nten sruu nda ban kpalaa kpan wu mituma bru-bru. ");
INSERT INTO jid_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wa ba cawu yayaa bacu plima rju nda sru kpyi ma niwu, nda nji wu hi kpan. ");
INSERT INTO jid_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wa ba rju'a ba toh Bakurame u nde Sima nda vu ni ngbengblen nda ndu ban gran nhma kukron'a. ");
INSERT INTO jid_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba ka ri ni bubu wa ba yo ndi Golgotta wa ahi “Bubu khwukhwu tu”. ");
INSERT INTO jid_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Banno ima enabi wa basru nha ni kpyeri wa a rii'. A la'toh nda kama ni so. ");
INSERT INTO jid_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wa ba kpan wu a ba vu nklonma ni nra nda ga kpamba, ");
INSERT INTO jid_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","nda ki si gbyen wu. ");
INSERT INTO jid_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ni ko tuh ma ba yo kpye wa ba nhawu'a wa a, “Iwayi a Yesu, ichu Yahudawa”. ");
INSERT INTO jid_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba kpan bi yi harli nha bi ni wu, iri ni korli ma, u rima ni wo ko ta ma. ");
INSERT INTO jid_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bi zren zu ni ko kima ba hlo tre ni wu nda ta whu tu mba, ");
INSERT INTO jid_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nda tre, “Iwu wa u na zi hekali ndi mewu ni vi tra, j'bu kpame! U'ta Vren Rji uka grji ni gran kukron ye meme”. ");
INSERT INTO jid_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Firist bi ninkon ba ngame ba' caa yaya ni bi nha u ni bi ninkon ndji ba ndo tre, ");
INSERT INTO jid_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","A kpa bari gbujbu wa ana gbujbu ni tu ma na. Ahi chu Israila. Ndu rji ni gran kukrona, u nikiyi kie kpaymeni wu. ");
INSERT INTO jid_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A' yo sron ni Rji Ndu Rji kpa juwo zizanyi Nda hi wawu yi tre “Mi VrenRji” ");
INSERT INTO jid_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bi ybi wa ba kpan ba ni wu ba tre to kima ngame. Ba mrewu. ");
INSERT INTO jid_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rji ni wru nton u tanne ibwu kaye kasu meme a wawuu hi ni wru nton u tra u yalu. ");
INSERT INTO jid_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Whiewhiere ni wru nton u tia, Yesu ka yra gro ngbangbani me nda tra, “Eli, Eli, lama sabaktani?” waa ahi, “Irji mu, Irji mu, u kame don ni ngye?” ");
INSERT INTO jid_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wa bi k'rli ni kima ba wotoyi, baka tre “A si yo Iliya” ");
INSERT INTO jid_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iri mba ka gbla tsutsu hi ka ban rlikpanma son ni ma enabi u tsi nton nda kason ni kpala nda nzu hi niwu ndu so. ");
INSERT INTO jid_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","U mbru mba bakatre, “Donwume kie'toh ka Iliya niye kpau cuwo” ");
INSERT INTO jid_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","U Yesu ala' yra gro ngbangban me ngarli nda ka vrli (brji) ma cuwo. ");
INSERT INTO jid_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U pli wa ba yo hra kotu hekali'a ka y'ba yra ti ha rji tu'mu' grji ye ncima, u meme ka grju u tita ba ka yra tie nkan. ");
INSERT INTO jid_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ba' be' baka bwu' bi tsratsra wa bana khwu'a ba' tash'me. ");
INSERT INTO jid_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ba rju ni mi ba' be' mba wa ba ni wa atashme, nda ri ni mi gbu u tsratsra nda tsro tumba ni ndji gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wa hafsan soja ni indji wa basi Yesu'a ba toh grju meme ni ba kpyi wa ba tie'a ba' ka tie sisri nda tre, “Njanjimu ana hi Vren Rji” ");
INSERT INTO jid_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gbugbu mba wa bazihu Yesu rji ni Galili nda zowuu bana he ni kima nda si ya ni gbugban mu. ");
INSERT INTO jid_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ni mi mba ba'na Maryamu Magadaliya, Maryamu iyi Yesu mba Isuwu ni yi mrli Zabadi. ");
INSERT INTO jid_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wa yalu tie'a indji ri u wo' wa a rji ni Armatiya, unde Isuwu, nda na Vren Koh Yesu. ");
INSERT INTO jid_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A hi ni Bilatus nda ka mye wu ikpa Yesu. U Bilatus ka ndu ba nno wuu. ");
INSERT INTO jid_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Isuwu a ban k'mo nyi ni pli wa arju'a, ");
INSERT INTO jid_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nda kau yo ni mi be' ma sisa wa ana tsen han mla tie a. A nyi kiekle tita hi nyu b e'a nda hi. ");
INSERT INTO jid_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Madagaliya mba Maryamu rima bana hi ki ma nda son ni shishi b e'a. ");
INSERT INTO jid_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni vi u haa ivi u kogon vi u mla tie, bininkon ba firist ba ni ba Farisawa baka shubi ni Bilatus. ");
INSERT INTO jid_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Batre, “Tiekoh, kie taka ni nton wa u gyrundji mu a he ni sisren'a tre, “Vitra niti y'ba mi tashme”. ");
INSERT INTO jid_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nitu kima (nno oda) yo ba ndu ba gben be'a tie vitra kieta na tie tokima na bi huwa (mrlikohma) ba ble ye y'bi-wu nda hlani ndji “A tashme” U gyru u klekle ani zan u mumla ni meme. ");
INSERT INTO jid_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus a hla bawu, “vu bi gben. Gben ni ngbengblen mbi wa bi he wu'a” ");
INSERT INTO jid_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","U baka hi nda kagben hra b e'a nda hrawu ni tita nda sru bi gben. ");
INSERT INTO jid_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ni cuu cacu asabaci ni bwu ble ni vi u mumla, Maryamu Magadaliya mba Maryamu rima baye ni be'a. ");
INSERT INTO jid_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","U meme ka grji kpukpame don malaika Baci a grji rji ni shulu ye nyi tita'a nda hon son wuu. ");
INSERT INTO jid_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nda kpan na rli nzan u nklon ma ka kienkla me to suna (tita lu?). ");
INSERT INTO jid_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bi gben ba wrli kpa nda tie sisri nda katie na ba k'ma. ");
INSERT INTO jid_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaika tre ni mba ba andi “Na tie sisri na yi mi toh ndi biye wa yesu wa bana kpanwu'a. ");
INSERT INTO jid_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ana he wa na a tash'me towa ana tre'a. Ye toh bubu wa ba ka Baci yo'a. ");
INSERT INTO jid_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hi gbagbla ndi hla ni mrlikohma ba (bi hu'a) A tash me ni khwu. To, a guci yiwu sihi ni Galili Nikii bi toh wu, To mi hla yiwu ye”. ");
INSERT INTO jid_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Imbaa ba gbla wlu don be'a ni sisri ni briku nda zuzu sihi hla ni mrlikoh ma ba. ");
INSERT INTO jid_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","U Yesu aka nzu tu ni mba nda tre, “mi ciyi!” Imbaa baka vu za ma nda kukhu ni wu. ");
INSERT INTO jid_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","U Yesu ahlani bawu, “Natie sisri na. Hi hla ni ba mrli vayi mu ba ndu wlu hi ni Galili Nikima ba tome” ");
INSERT INTO jid_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wa mba ba ba'si hia, bi gben bari baka hi nimi gbua nda hla ni ninkon u firist ba ikpi wa ba tie a. ");
INSERT INTO jid_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wa ninkon u firist ba ba' shubi ni ninkon bi ndji ba sron mu ni tu tre ni ba, ba nnoba gbugbu nklen nji ni soja ba, ");
INSERT INTO jid_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nda hla bawu, “ hla ni mbru ndji 'mrlikoh Yesu baye ni cuu nda y'bi k'mo ma u kie si kruna' ");
INSERT INTO jid_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Itre yi nita ri ni gong kie brewu ndi whriewu ndi kpayi cuwo ni ya wa bina tie'a. ");
INSERT INTO jid_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","U soja ba ba'ka kpa nklen nda tie towa ba hla ni bawua Itre yi ka vra shu nimi Yahudawa nda he me ye zizanyi. ");
INSERT INTO jid_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","U mrlikohma wlo don ri ba ba' hi ni Galili ni gblu wa Yesu ana hla bawu ye. ");
INSERT INTO jid_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wa ba toh'a ba kukhwu niwu, u bari mba baka tie (shaka?). ");
INSERT INTO jid_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu a hi ka tre ni ba nda hla “Ba ne ngbengblen wawuu ni shulu u ni meme. ");
INSERT INTO jid_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bika hi ndi ka indji bi gbu ba ba wawuu tie mrli koh mu (bihume). Tie batisma bawu nimi nde u tie, ni u vren ni u Tsratsra Brji. ");
INSERT INTO jid_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsro ba ndu ba hu ikpyi ba wawuu wa mi yoo yi'a. To, mi he ni cacuwu hi ni kle u nzan'a” ");
INSERT INTO jid_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wayi hi Lauren wu mumlan ni tu tsartsar tre wu Yesu Kristi, vre Irji. ");
INSERT INTO jid_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anabi Ishaya, a ya koshishi datre ndi ye mi tru indi wu ton di mu, niyi ani mlanko niwu. ");
INSERT INTO jid_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ilan wandi a si kpagro si yo ni tsutsu miji, mlan icontih ni Back mbu, do not ma hi nyeyre. ");
INSERT INTO jid_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana a ye, da tsoro bi wandi ba ye ni wu nko wu wru latre mba hlega, da vu ba sukpa ni ma du Irji wru latre be hlega. ");
INSERT INTO jid_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wawu u indi bi gbu Judea mba urishilima ba luni ka kpa sukpa wu ma da ni nhran latre mba do Irji wru ba hle. ");
INSERT INTO jid_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana a ta sur nklon nta rakumi de to lo rjirji ni tri wu nta da ta rli langblan ba iton. ");
INSERT INTO jid_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A dubub di “Iri ni ye ni kogonmu wandi a zan gbengle mu, wandi mina malan wa mi chu langban wu zama na. ");
INSERT INTO jid_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi sukpa yiwu Nima ana wawu ni sukpa yiwu ni rubu Mai Tsraki. ");
INSERT INTO jid_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Avi baki, yes a ye rji ni Nazareth wu Galilee e Yohana a sukpa ni wu ni nei Jordan. ");
INSERT INTO jid_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Da Yesu a nzutu ni ma wu ne wandi ba sukpa niwu, ato shulu a bwu u wa atoh Ruhu Irji a girji kuson ni u ni tu. “Irji ni shulu a trendi. ");
INSERT INTO jid_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","“Wayi wu vren wu surom mu, wandi a ni du surom mu see. ");
INSERT INTO jid_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ruhu Irji a Chon hi ni tsutsu miji. Wu vi arbai (40), ");
INSERT INTO jid_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ba ba nma miji mba birji (Satan) wandi a ka tsra. Irji a du maleka ma do ba tindu (hidima) niwu. ");
INSERT INTO jid_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Niwa bana vu Yohana tro Yes ye ni Galilee da bla tre rji andi ko Irji no shulu a grji ye weiweire ko nhá do ");
INSERT INTO jid_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ica me me drive chuwo da kpa wu wu. ");
INSERT INTO jid_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A si izren ni kpa kikle nei Galilee da to Siman ba Andru, mri vayi Simon, basi yo ngrow nima bana bi Vu lambe. ");
INSERT INTO jid_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu yo ba du ba hu a ni tsron. ");
INSERT INTO jid_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ba vu idi to ba lambe lude hu gbagbla. ");
INSERT INTO jid_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A la fon zre da to James (Yakubu), ba siya inla rjirji wu vu lambe ba ti ");
INSERT INTO jid_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ba wo yo a da lu don think a Zabadi mba mri ko ma da hu. ");
INSERT INTO jid_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ba ye ni Capernaum chachu sati, u yes hi ni tra irji ba (synagogue). ");
INSERT INTO jid_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Da ka tsro ba itre irji zan khikle bi nha mba ");
INSERT INTO jid_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ni nto kima, i gu ri wandi a he ni meme ibrji a lu yrayi ni Yesu da mye, ");
INSERT INTO jid_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wu ye tingye ni ta, Yesu ba Nazareth? Wu ye wuta mu? Mi to ko wu nha, wu tsatsra wu irji. ");
INSERT INTO jid_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu yra to ni wu da hla ni ibrji wandi a siya tree ni mi songbagbi. ");
INSERT INTO jid_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ibriji rhju ni gbengle da ni kpagro. ");
INSERT INTO jid_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Indi ba wandi ba hei ni kea ba bwu nyu yo ni wuo da miye kpamba, I wayi nghe, itsro sad gbengle ani you doka ni bring meme u ba wou. ");
INSERT INTO jid_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Injo nitu ma a zre yi ni clan Galilee. ");
INSERT INTO jid_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A rju ni tra irji da tsi you ni ko ba Siman ba Andrew, ba ba Yakubu mba Yohanna. ");
INSERT INTO jid_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ni ri nikoa, a to yi wa Siman si lo kpa. ");
INSERT INTO jid_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Da ba hla niwu, a hi da ka thi wo nzu. Lol kpa a kri bre wu, wa kri lunde da nuba rhi. ");
INSERT INTO jid_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ni yalu, be gbu wawu ba shubi ni nkotra. ");
INSERT INTO jid_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ba nji bi lilo kpa ye ni wu, ");
INSERT INTO jid_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","wa ka nuba si kpa da zu meme brji rju ni kpa wandi a hei ba wu ni kpa. A na nu ibrji ba nyu wu tre na - ni tu ba to. Ko wawu hi nha. ");
INSERT INTO jid_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ni bwu mble a lunde da hi ni wutrji wandi ndi bana hei na daka bre irji. ");
INSERT INTO jid_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kpúkpan zren ma Siman ");
INSERT INTO jid_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ba bru mba ba wawu ka to da lila wu di indi basi waawu. ");
INSERT INTO jid_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A sa ba wu, khi hi ni wudji rhi, ni gbu ri kan. Nitu hla tre irji ni bawu shi need me ye. ");
INSERT INTO jid_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A zren kaāgo inkla gbu Galilee, ni tra irji mba (synagogue) da tsro ba jiji tre irji da zu meme ibrji rltju ni bi wandi ibrji lo ba nju da kpabachuwo. ");
INSERT INTO jid_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ndi ri wandi a hei ni lilo eshi a ye da kugu gbarhu ma da bre u andi. ");
INSERT INTO jid_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wuta kpa nyme wu ka chu lilo yo wrjhu ni mu. A ló suron ni wu da ka wo ni wu da tre di, “mi kpa nyme lilo ka wu chuwo! ");
INSERT INTO jid_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lilo ezhie a rhu hari kpama a kma ti sa. ");
INSERT INTO jid_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu a mmba, u a du na hla ni tro na. ");
INSERT INTO jid_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Du gri kpa ma hi stro priest ya da a samu si see kpa ma du hei na wa Musa a ti gbuchu ni tu man. ");
INSERT INTO jid_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Da gua rhu ni Yesu a tsi ka dubu kpe wa Yesu ti ni wu'a. Ni tu kima Yesu ana iya are ni mi gbu du ba to na. A nap zi are zu ni kosan gbu. Duk na ki ndi ba ba zi hu ko ni tse Wanda a hi. ");
INSERT INTO jid_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Da a kumaye ni Capernaum ni mi vi fie mee, ndi ba woh da hei niko. ");
INSERT INTO jid_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gbugbu ndi ba tsutsu da shuni bubua, ikon 'u” zu no ri koha ana heina, Yes sibla tre nibawu. ");
INSERT INTO jid_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Indi nzah ba jin vayi mba wa a chronchu ye ni Yesu. ");
INSERT INTO jid_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bana to ikoh “u” ri hi ni Yesu na, ba hon zu ni tukan, da ghlen tukan, da ban ndi “u” chronchu rini Yesu. ");
INSERT INTO jid_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu toh gbegble suron ba da tre ivre ba wur lahtre me hle ni wu. ");
INSERT INTO jid_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Se bibla vuvu wa ba sun ni ki, ba si rimre nisuron ba di Yesu lahtre, ");
INSERT INTO jid_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ba indi da ani wur lahtre ndi hlega, sai Irji nikankrima ni wur lahtre ndi hlega ");
INSERT INTO jid_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu toh misuron ba da miyen ba agye nji meme mmre ba ye ni yi wu? ");
INSERT INTO jid_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Niwa ba kpa lahtre wurhle ni ba wu, ni wa ba hla ban blame ni hi kpame, a time agan? ");
INSERT INTO jid_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yesu a toh di vre Irji a hei ni gbengbenlen “u” wur lahtre hle ga, da hla ni ndi wu chronchu, ");
INSERT INTO jid_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","mi hla “u” lude di ban blame di hi koh. ");
INSERT INTO jid_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Indi wu chronchu a lude ban blama da hi kpa ma, Indi ba buh iyuen yo woh da tre, kina taba toh Bibi kpei nayi na. ");
INSERT INTO jid_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu rhu hi ni kosan nei, ndi gbugbu ba hu hi ni neila, wa ka si bla tre ni bawu. ");
INSERT INTO jid_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Da asi zre da toh Levi ivre Alphaeus a kuson ni bi kpa ban. Yesu du hu wawu, wa lude hu Yesu. ");
INSERT INTO jid_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu si rhi lah mi koh Levi, in bi kpa ban gbugbu, baba bi lahtre wasi rhi no “u” baba mrikon, ndi gbugbu ba hu. ");
INSERT INTO jid_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farisawa bibla vuvu, ba toh Yesu si ri biri nikoh Levi da miyen mri koh ma a gye sa ti kohbi si ribiri ni bi lahtre? ");
INSERT INTO jid_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu woh ba da tre indi wa ahei ni gbengbenlen ana wa den na, see ndi “u” lilo niwa den. Mi na ye nitu bi woh tre mu na, mi ye ni tubi lahtre. ");
INSERT INTO jid_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mrikoh Yohana baba Farisawa bata son ni hlama, indi baye da tre ahigye sa mrikoh Yesu bana vu hlana na? ");
INSERT INTO jid_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ka hla ni bawu, ayiwu kpukpan ango ba ka son ni hlama ");
INSERT INTO jid_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Se chachu wa ba ban ango rhu, “u” ba son ni hla ma. ");
INSERT INTO jid_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ba ndi a niwar klon sisama nitu chiche ma, don ani ya yabba sisama game. ");
INSERT INTO jid_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ba ndi wa ani ban hi sama sur ni chiche ri, don ani fu hle ga, se ba ka sur sama ni miri sama. ");
INSERT INTO jid_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ni chachu sati Yesu si zre zu ni mi rhu, mrikohma ba zi gbusu tan. ");
INSERT INTO jid_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisawa baka tre ni Yesu du toh ikpie a di mrikoh me ba si ti kpie wa dana bina ni chachu sati. ");
INSERT INTO jid_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A miye ba, bina toh ikpie wa Dauda baba ndima ba ti na? iyoun ti ba, ");
INSERT INTO jid_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","baka hini Abitha ndi wu ton du Irji, waka noba breadi chachu sati, “u” ba ka tan ");
INSERT INTO jid_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu tre ba ti chachu sati ni idi, bana ti indi ni chachu sati na. ");
INSERT INTO jid_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni tu ki Ivre Indi a hi “u” Bachi “u” chachu sati. ");
INSERT INTO jid_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bachi a ri no mitra u pre da same ni Indi wu lullo wu so wo. ");
INSERT INTO jid_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Indi ba sure shishi niwu ko ani wurka ni wu cacu asabar don da ka to ni la ter. ");
INSERT INTO jid_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu hla nindi wu lullo wo, rhu kli ni tsutsu Indi ba, Yesu a miye ndi ba. ");
INSERT INTO jid_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abi duba tie zizi nive asabar d kpa ndi cuwo ka ndu tie meme indu Indi ba que? Indi ba ba son ng bage. ");
INSERT INTO jid_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu a kma ya ndi ba nifu done touri dir mba da hla ni gu n ma wo me? igu n ma wo ma u won bi. ");
INSERT INTO jid_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisawa banu gla me da hadatu niti rudiyawo di ba wo Yesu. ");
INSERT INTO jid_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ni mini koma ba hi nen wu Indi gbugbu ba hu bari ba ni ni Galilee ba ri bani Judia ");
INSERT INTO jid_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Urshalima, indumi ya bari me gaba ni Jordan, Tyre har ni Sidon. Daba wo gbi a si ti Indi gbugbu u bayi niwu. ");
INSERT INTO jid_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A hla ni miniko ma duba samu ni igu tsitsima ni wawu don into du ba na matse bi was wu na. ");
INSERT INTO jid_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A warka indi gbugbu u bi lullo ba turn kpamba ni baba sawo niwu da fe se. Bachi a kpa bari just ni lullon. ");
INSERT INTO jid_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ko nitan bi ruhu brji bajoku ni koshishi da Yar go da ter wu vir irji. ");
INSERT INTO jid_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A kpa nha ni ba duba dubu nde ma na ");
INSERT INTO jid_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A ho he ni gbulu da yo biwa a ni son u ba ye same ni wu. ");
INSERT INTO jid_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A ju ndi woto dan ha wa yo ba di (apostles) do duba he ni wa, ");
INSERT INTO jid_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","wa turba du ba hla ter wada he ni glegle wu zu bryi. ");
INSERT INTO jid_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mazani wolo dan ha wanda ju ba na he nayi Simon wanda a non dema Bitrus. ");
INSERT INTO jid_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakub very Zabadi, Yohana vayi Yakub Wanda a nu de Banergas wato minizan ");
INSERT INTO jid_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","wu Adarawas u Fibus, Bar ta Lamawas, Matiwu, Tomas, Yakub very Haifa u Yahuza, Thaddaeus, Simon Bakan ane ");
INSERT INTO jid_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","wu Yahuza Iskanyoti Wanda ya bashe shi. ");
INSERT INTO jid_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A kma he ko, wu kpetren indi bakaba da iya ri bin na. ");
INSERT INTO jid_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Da bikoma ba won naki da he niwu da ter, imiri ma na he na he ni wu na. ");
INSERT INTO jid_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bi nha wa ba ni Urishalima ba ter di, a he ni ruhu Beelzebul, “mba meme brji”. ");
INSERT INTO jid_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu yo ba da ter ba yi-yi, ibrji ani ti ni he da zu ibrji? ");
INSERT INTO jid_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Idam mulki gu kpama te kam-kan mulki ba na to kle gbangba na. ");
INSERT INTO jid_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Idam iko ga kpema komba ana kle gbangba na idan b ");
INSERT INTO jid_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","a tayar ni nituma da ga gba ana he niglegle-glegle na anijoku. ");
INSERT INTO jid_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Idi na ya da ri ko idi u gle-gle da yi bi kpe ma na ha ma ni vu indi glegle u ko. ");
INSERT INTO jid_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jaji mu me hla you la tre we me wa wa Indi ba ti iha wur la bawu. ");
INSERT INTO jid_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A ma wa ba ti ni Ruhu tsatsra ba na wur le meml mu, dona la tre u ka kle. ");
INSERT INTO jid_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu tree ni tu wa ha tre, ahei brji ");
INSERT INTO jid_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","I yima ni mir vayi ba ye kril ko ra. Ba to ba ka yo'u ye gba nmba. ");
INSERT INTO jid_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kpetren ndi ba ki kagon ma da me yer, I yi me ni mir vayi me ba hei ko ra da ki wa u ");
INSERT INTO jid_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A sa ni ba'u, ba nha ba mir vayi mu? ");
INSERT INTO jid_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A ka ya ndi wa ba ki gon kla ma da tre, “To ibiyi yi bi mir vayi mu! ");
INSERT INTO jid_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Duk ndi wa ni ti kpe wa rji tre a wa u yi hi yimu da hi mir vayi mu. ");
INSERT INTO jid_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ni mu mummlan a hla tre ma ni gbugbu ndi waba shuti ni Yun nei. A lude ri ni mi gyue ni mi-nei. ");
INSERT INTO jid_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A lla tre ma u-jaji gbugbu da ka yiyi ani. ");
INSERT INTO jid_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Wo-me, idi uron a ban ibi hichu ni rjumaa ");
INSERT INTO jid_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","a chu bari ba kuhle ni kon u chichen ba tanri ");
INSERT INTO jid_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","bari ba khule ni tu han iwa ama hei mi meme gbugbun a warju. ");
INSERT INTO jid_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Irji rju hongan wa kue niwa in-jah ma na gburonkonna. ");
INSERT INTO jid_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bari ba kuhle ni zahchon, I Chon ba gburon ti rigra da k tiwu wa ti me me. ");
INSERT INTO jid_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bari kuma ku “lle ni “llar meme didima da gburon na ni sho bari, I wulon iknutra (30), bari I wulon ikpu tanne (60), bari I wulon kpu wulon (100). ");
INSERT INTO jid_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu tre indi wa a hei ton u wo kawo ");
INSERT INTO jid_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wa Yesu a ye he ni kriji ma bi wa ba hei niki ni mimriko ma wulon don ha, ba miyen tu tree ka yiyi a. ");
INSERT INTO jid_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A biyi yi ba “llar you wawu multi Irji wa, a ririn, mibiwa ba he nira ba tree ni ka yiyin me. ");
INSERT INTO jid_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ni duba ye ama da na toh na ni duba wo “llan da na toh “llan na I ba wo na kame ye Irji ni wuru “lle ni bwu. ");
INSERT INTO jid_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A miyen ba bina to tu itre u ka you na? ");
INSERT INTO jid_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bi ya di bi to wawu u? ");
INSERT INTO jid_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Idi ichu a ni chu tre. ");
INSERT INTO jid_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ni tu kon ba a bubu wa ba chutre iba wo meme brji a ye, wa vuba kpa tre wa ba chusa. ");
INSERT INTO jid_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bana he ni ja na ni mi bana. Ama ba vu sunron mu ni mi iton fie me, na joku ni ton uya. ");
INSERT INTO jid_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bi wa ba kpa tre na kalle ni ");
INSERT INTO jid_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tu gbi gbugbulu yo khlen, iko bari kpii bari naki, iri mba ba chu wa a khule ni chon. ");
INSERT INTO jid_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bi wa ba kpatre rji da vusuron na ni ji ndi ye nitre rji baba yi ba ichu wa kulle ni meme didi wa a ni klo 30-30 60-60 100-100 ");
INSERT INTO jid_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A miyen ba, Indi ba zi fitila ni mi sisen ko ba zi ni zah tebru? Ba zi nitu tebur, di du kpan ni Indi bi koh. ");
INSERT INTO jid_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ikperi na riri na, see ka he ni rira ni ndi ba ka to na hlar. ");
INSERT INTO jid_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Indi wa ahei niton u wo ka wo. ");
INSERT INTO jid_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A hla bawa, srenton ni wo kpie wa bi wo. Kongo wa wu tsar niwu, ni ki ba tsar niwu. ");
INSERT INTO jid_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Indi wa a heiwu, ba ka fon surwu Indi wa ana hei niwuna, baka vukpa fie wa a hei niwua. ");
INSERT INTO jid_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A tree, mulki Irji a hei nawa indi ani ban bikpie hichu nimeme. ");
INSERT INTO jid_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Indi ni kruna, na shime ni rji, biri nirju na gbrun, wana tohna. ");
INSERT INTO jid_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Menme nina biri kima ani yarbe ku nira, ngwugwu ka fu wa ka gbrun nikle ma da ti wolo. ");
INSERT INTO jid_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","I dan biri a weri u ba cham. ");
INSERT INTO jid_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ki ya tree mulki rji ahe naki kā ki tsar ba bawu? ");
INSERT INTO jid_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ga aheifieme na wolo mustard wa i dan u chu ani rju da gburon. ");
INSERT INTO jid_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Har chinchen baka son ni wuma. ");
INSERT INTO jid_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Naki tre mba ni kayiyi ni kon gbubu'u. ");
INSERT INTO jid_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni kogie a tre ni ba wu ni ka yiyi duba tohtre a. ");
INSERT INTO jid_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ni yalu chachuki a tree diba zah gran hi komu. ");
INSERT INTO jid_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I ba lude niwume a ni mique na ka ndiba don. ");
INSERT INTO jid_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Se ihen lude ni gbegbelen na wuru man sur ni mi guea ta shu. ");
INSERT INTO jid_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wa si kurna ni kogon mi gue iba shemme u du lude na ya duna kur kpahlena ndi ba ba kuhlema. ");
INSERT INTO jid_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iwa lude da yarhan ni kikle gwugwu mba ima duba son nigbagbi shishiman ba chu ");
INSERT INTO jid_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A miyen ba, age nuyi sisiri? Har zizan bina hei ni bangaiskiya na? ");
INSERT INTO jid_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iba tie sisiri, adi a indi birimen nayi a tre ni gwugwu ba I ma u ba wo niwu. ");
INSERT INTO jid_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Baye ni gran nei u gbu garasinawa. ");
INSERT INTO jid_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Niwa, a ye rju ni mi jirgi. Hi hari baye zon tu ba igu ri u meme ruhu asi rju nimi hbei. ");
INSERT INTO jid_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bubu son ma a hei ni bbei ba ndi wa ani ya ló koni sarka. ");
INSERT INTO jid_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ni-ingu gbugbu ball ni sarka ba ma ruruwa asu sarka ba rji rji maruruwa. Ba Indi wa ani ya vu aba. ");
INSERT INTO jid_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chachu, chachu ni ble mba ni yalu ani yargro na ni yar kpunma ni tita ni mi hbe ba ni kpah tita. ");
INSERT INTO jid_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A chu shishi to Yesu ni gbugbama na tsutsu ye kuque gbarju ruwa na nikon ma. ");
INSERT INTO jid_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A lu tre gban gban niwu; u mu get niwu? Yesu u vre rji u wawu? me pre ni de rji na tie me yahna. ");
INSERT INTO jid_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","U wa hla niwu's rju ni kpah ma I wu meme ruhu. ");
INSERT INTO jid_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Amyen bayo nde me ni nha? Wa hla niwu nde ma tuli ama a ki hei gbugbu'u. ");
INSERT INTO jid_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Abra Yesu dina zu wau ni gbuyina ");
INSERT INTO jid_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","(not included) ");
INSERT INTO jid_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ba bra datre zutarhi need lecleba beri kiri niba. ");
INSERT INTO jid_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Abri ba meme ruhu ba rju dari ni licleba ba tsutsu gerji ni tie gbuw hau ni mi nei bakede bakai dubuha ba que ni nei. ");
INSERT INTO jid_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Biwa basi kurju ledeba ba tsutsu tu da la ikpe da tsir. ");
INSERT INTO jid_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baye ni irvriji Yesu tre da tah iguh u meme want nibawu tuh ");
INSERT INTO jid_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Biwa sahe niki da toh kpe da sitsir ni igu meme ruhu, da la nibawu didime na ta bawu tre leeleba. ");
INSERT INTO jid_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba sawume tsu bre du biri gbua. ");
INSERT INTO jid_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Asi sou ri ni jirgi iguh meme ruhu bra diwau hu. ");
INSERT INTO jid_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yesu na kpagmena ama da la ni niwuhi Kon me ni ndi me di la bawu ikpe rji teh u; yada as mashishime. ");
INSERT INTO jid_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ahi kpa ma da so ma si la kpi bi keklema wa Yesu teh ni wu ni dikatolis. Kowa ni ndi sisri. ");
INSERT INTO jid_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nlina Yesu, a rungra ni jirgin. Ri gbala ko rima ndi gbugu Baye gyekle ki niwu. ");
INSERT INTO jid_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bi ni Kon ri church wa bayo Jairus ye du joku ni zama. ");
INSERT INTO jid_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Asake bra ngari du tree di verwa tsitsa te wiewier que mi bra ye di sawai niwu di sama sikpa nda son divine. ");
INSERT INTO jid_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bahi bawu; ndi gbugbu bawu nda ni hau nikpa ");
INSERT INTO jid_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iwari beki wa the ni lol nkayinle is wulon nduha. ");
INSERT INTO jid_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A shaya brabra ni wa bi nu mua gbugbu it ase kpama peh-phe wu nda ya di sikpa nihe ama lol ka kle. ");
INSERT INTO jid_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Awo kpi Yesu the. nda ye mi kuganma ni mi gbugbu ndi nda tuka ingloma ");
INSERT INTO jid_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A tie nda mi taba igloma mike mi samu sikpa. ");
INSERT INTO jid_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Niwa ataba wu; it kukri, ato ni kpa wawu samu sikpa ni lehenma ");
INSERT INTO jid_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu toh nikpa gbegble rju mikpa. A gbaya ni mi bdiba nda tree, aha taba glomu? ");
INSERT INTO jid_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I miri konma batre u to gbugbu ndiyi tree ndi tre iha tabawu. ");
INSERT INTO jid_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu ni son ya nda to aha taba wu. ");
INSERT INTO jid_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","I wa to kpe asame wu sisitsir vu. Aye ndu joku ni gbui ma nda la wu gerger me. ");
INSERT INTO jid_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ala wu, iuerwa, isorun didime asa u samu sikpame. ");
INSERT INTO jid_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Asi tre; ndi bari ba rji ni nikon ie Church nda la, Iverwa me kwi na dane tiche kanam ");
INSERT INTO jid_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu wo kpe ba si tre, nda ua ni Kon ni church a na te sisri na khir behan gbagba. ");
INSERT INTO jid_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ana bri druwo diwuna imba Bitrus, Yakubu mba Yohana vayi Yakubu. ");
INSERT INTO jid_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Baye ni koh was ani anikon church a ato ndi ba si tre gbaba me, basi tsra gre gbagbame. ");
INSERT INTO jid_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ni rhi ma ni Kon ala bawu agesa bisi lo isoran ndi si gbagro? iverna, na gwuna, asigruna. ");
INSERT INTO jid_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba zahe. A zuba just pepeme ni ra nda mba iteh uer mba yinma ndi babe niwu, nda rhi hi ni iwirji iver ha. ");
INSERT INTO jid_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Avu iwo very nda la wu, Talita kumi wa ala iverwa tsitsa mi la ni wu lude. Ba wuton iver nda tsir (the nise well doha) ");
INSERT INTO jid_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba ter sisri pepeme nisorun dedeme. ");
INSERT INTO jid_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ala bawu ndi ba na la nidruna. Nda la bawu mu lla rhi. ");
INSERT INTO jid_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A rju ni ki hi ki gbuma ba ba mriko ma but húa. ");
INSERT INTO jid_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Da vi a sabat ye wa ahi ka tsuro tre ni tra rji. Gbugbu nai wa ba wowua ba yo mamaki nda tre akpa toh tsuro yi rjime? A bi wrji time ba nno? A bi ngye towa wa ani tie wa ba zan kagrji? ");
INSERT INTO jid_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ana vren kafinta muyi na, ivren mariya mu ni vayi ba Yakubu, Yosi, Yahuza u Siman Nan? ");
INSERT INTO jid_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","U Yesu ka hla bawu din, Anabi bana nyime niwu ni gbu ma mba bi koh Mana. ");
INSERT INTO jid_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ana to tie kpie rligrama ni gbuma na, a sáwo ni ndi fyime yi u baka fe si. ");
INSERT INTO jid_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A yi mamaki ni ka nyime ndi ma ni ndu rji. A ye who hi ni mrli gbu bi wiewiere ni ba nda ka bla tre rji ba wu. ");
INSERT INTO jid_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A yo mrli koh ma wlon don haá ndá tton ba rju ni hiha ndá nno ba gbengble ni tu bi brji meme, ");
INSERT INTO jid_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ndá hle bawu ndu ba na nji kpie u hi ni ziren a na ba nji kpala ni kpo mba na, ");
INSERT INTO jid_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","bá son lahgban ndá sur nklon ririyi. ");
INSERT INTO jid_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A hla bawu ikoh wa bi ti ria bi ka ki ni ki me hi ntton wa bi wlua. ");
INSERT INTO jid_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Igbu wa ba na kpayi ko woyi na, bika kpun me-meh u za mbi hle ni bawu ndu kafa shaida ni tu mba. ");
INSERT INTO jid_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ba rju hi ndá ka tree ni ndi ba ndu ba tuba. ");
INSERT INTO jid_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba zu meme brji rju ni mi ndi gbugbu wu nda nyiu nye ni tu bi lilo u ba kafe si kpa. ");
INSERT INTO jid_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ichu fero a wo in I wa ba ki tie'a don inde Yesu a Shan shu u gbua. Ba ri ba tre Yohana u Batisma ta shine ndá ni tie kpie wa yi wa ba zan kagrjiá! ");
INSERT INTO jid_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bari ba tre “ a hi Iliya Bari me a ndá hi Anebi na Anebi bi Sen'a” ");
INSERT INTO jid_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Amma fero ni wo nayi ka tre ndi Yohana wa me chu tu ma ua ta Shime. ");
INSERT INTO jid_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Fero ana ton ba ndu ba vu Yohanna tro ni tre Herodiya (I wa vayi ma Filibus) don a grand ni gbengble. ");
INSERT INTO jid_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana ana hla ni Fero a hi yours tsu ndu Vu vayi me kpa wa ma. ");
INSERT INTO jid_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wawu Herodiya ka nji fu Yohana ndá wa kon u wuu hama. ");
INSERT INTO jid_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Don Fero ata klu Yohana niwa ana ndi u klu rji nda zi Yohana ni tro Amma ndá na tie wu ya na. Wo tre ma ta nno fu kpukpo me Kuma ndá giri ni wu'u. ");
INSERT INTO jid_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","I vi wa a zi gbien ni tu Yohana ye ki tsar-a ni vi u taka ngrji Fero ni wa a yo Indi bi nikon bi ti ndu niwu ni khi kle komanda ba u bi nikon bi Galili rli birli ni wu. ");
INSERT INTO jid_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ivren wa u Heridiya a ye nga me nda nglu nzan ni ba wu; wa suron Fero bi ni wu ni mbier bi tsri ba. I chuia ka hla ni vren wa, mye kpie wa u wa ni me u me no wu. ");
INSERT INTO jid_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A shi rji ni vren wa nda hla, ko a hi ngye u mye me me nnou, ko ani ta me ga mulki mua ti ha ");
INSERT INTO jid_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","me. A tsutsu rju hi ni yi ma nda myen, me myen tiemu ngye ri? A hla wu, Itu Yohana u tie Batisma. ");
INSERT INTO jid_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A tsutsu gbla me hi ni chuia nda tre me son ndu ne zizan yi, Itu Yohana u tie Batisma ni mi gbugba. ");
INSERT INTO jid_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ikpie kpa suron chua tie wie me amma ana wa ani kama na ni wa a shirji wua ua u taka vi grji ma. ");
INSERT INTO jid_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ichua to me nda yo soja ma ndu ba ka chutu Yohana. Soja wa a ra gbien chua hi ni itra wa ba tro Yohanna nda chu tu ma. ");
INSERT INTO jid_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A nji tu Yohanaye ni mi gbugba kukron nda ka nno vren wā-a u vren wā-a ka nji ka nno yima. ");
INSERT INTO jid_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mru ko ma ha wo nda hi ka ban jiji kpa ma ka rju ni be. ");
INSERT INTO jid_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manzani ba ba ye ni Yesu nda vu ikpie wa ba tie'a bla wa wawu-u. ");
INSERT INTO jid_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A hla bawu “Rju hi ni wi gi wa bi he kimbi'a ndi kusi tsame. Don indi gbugbu wu ba ta ye nda hi ni ba u ba ka na he nton u rli ua mena. ");
INSERT INTO jid_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","U Manzani ba ba ka rju dran gwu hi wrji wa indi ba na he'a na. ");
INSERT INTO jid_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma indi ba ba to ba nda to rju mba nda tsutsu ni za rju ni mi gbuba wawu-u nda ka ri ni bubu'a guci ni bawu. ");
INSERT INTO jid_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Da ba-a rugran ne'a nda ka to kpentren ndi wa ba ki gben ba'-a, wa a lo'u suron don bana rhi kpe me na intamma wa ba na he ni ndi ma na. a krli ri ni tsuro ba' ikpi gbugbu-u. ");
INSERT INTO jid_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ba he me u icha ye tie u mali ko ma baka tre wu ndu. ");
INSERT INTO jid_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hla ndu ba hi ni mi gbu bi wie wiere na le birli da di don iwrji wa ba he'a bran inkon ni gbu. ");
INSERT INTO jid_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wa' a kasa ba wu din, nno ba ikpie wa ba rlia. Ba mye, ki hi le bredi u denari derli harli ye nno ba? ");
INSERT INTO jid_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wa mye ba “bi he ni gble bredi bren? Hi ndi hi ya' to”. Da ba ka to, ba hla wu din, Igble nton ni lambe hari. ");
INSERT INTO jid_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A ndu ba kusun ni giga'a ni nklan ma. ");
INSERT INTO jid_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba kuson ini nklan deri-deri mba se'titon. ");
INSERT INTO jid_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A vu bredi ton ba ni lambe ha ba nda nzu ya shulu nda ti lulu ni tu mba nda myre bredi ka nno manzani ma ndu ba ga ndin ba. A la vu lambe ba nda fan ba ti tsitsa ma da ga ba. ");
INSERT INTO jid_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Baka ntan da wrji sa'sa'me don mbuerma. ");
INSERT INTO jid_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ba vu shu ni sisen wlon don harli. ");
INSERT INTO jid_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bi wa ba tan bredia u lambe-a ba lilon dubu ton. ");
INSERT INTO jid_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A ni kle tre's da ndu manzani ba ri ni nhamma gwu'a nda hi guci wu ni Besaida nda ndu kpentren ndi ba hi kpamba. ");
INSERT INTO jid_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Da indi ba ba hi wawu-u wa ka hon hi ngblu nda'yi addua. ");
INSERT INTO jid_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yalu a tie u Jirgi'a ka ri tsutsu ma-a ye u Yesu na rli he ni meme ni nkrji ma. ");
INSERT INTO jid_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A to ba ni mi Jirgia ni tsi kpa wa ba ki tie ni shishi ngwungwu'a nda ta son vu ba yiba. ");
INSERT INTO jid_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amma da ba to u si zren ni tu ma-a baka ya nda ahi ibrji, ");
INSERT INTO jid_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sisri ti ba u baka yira yi! Gbagblame, a tre ni ba nda hla bamu vu suron! A hi me! Na klu sisri na! ");
INSERT INTO jid_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A ri mi Jirgi'a ni ba' u ngwu ngwu'a ka ku kli nda na la fu na. Ikpie a nno ba mre kpukpome. ");
INSERT INTO jid_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Don ba na rli rehe to njima ni kpie wa a tie ni bredi ba me' isuron ba ana kpan kpa. ");
INSERT INTO jid_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Niwa ba ru kikle (kpace) ma-a, ba ye ni gbu Gennesarit nda llo' Jirgia zi ki. ");
INSERT INTO jid_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Niwa ba rju ni Jirgi'a indi ba ba tsi to-o, ");
INSERT INTO jid_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","nda tsutsu ka nji bi lillo ni ba tabli mba rji ba'u nklan mba hi ni wrji wa ba wo nda a hea. ");
INSERT INTO jid_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Duk wrji wa a ri ni gbu, ko rligra ma ko tsitsa ma ko ni meme ndi bari ani to ba zi bi lillo ni bubu wa ba zu hi kasuwa. Ba breu ndu don ba me' ndu ba kpire nyiu nklon ma, gbugbu u wa ba kpire a ba kpa si kpamba ");
INSERT INTO jid_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisawa ni mbur bi nha ba yerji urushalima ba ye gyenklan kagon Yesu ");
INSERT INTO jid_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nda to imrlikoma bari basi rli birli hamma ni ngla wo. ");
INSERT INTO jid_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisawa ni yahudawa wawu mba ba na rli birli na sai ba nglawo, don ahi alada mba. ");
INSERT INTO jid_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Inde farisawa ba ye rji cucu, bana rli birli na sai ba Sukpa; ni imbru kpi bari wa ba hua na ba ngla vuva nho uri kongo ni kpi ndu la wawu. ");
INSERT INTO jid_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisawa ni bi nha mba mye Yesu “Ahi ngyesa imrli ko me mba na Ziren ni nkon u bi nikon amma di ni rli birli ni worji?” ");
INSERT INTO jid_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ama a ua ni bawu, “Ishaya tre tsar ni tu mbi bi gyru ndi. Ba nha din, Ndi biyi ba hume ni vre nyu amma isuron he gbagbanwu ni me. ");
INSERT INTO jid_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba wu me u ce, nda ni tsuro ikpi bi u ndi wa ahi u mba. ");
INSERT INTO jid_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bi ka doka rji don di nji u di mu gbangban me. ");
INSERT INTO jid_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A la wa bawu, A bi yiwu wa bi ka doka Rji don ndu yi nji ala'ada u mbi. ");
INSERT INTO jid_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa a tre, 'Wo tre tieme ni yime', u iwa a tre meme ni tiema ko yima, gbigbi ani qu'. “Amma bi hla, 'Indiwa a hla ni tiema ko yima ");
INSERT INTO jid_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Izo ko birime wa una kpa ni me a hi Corban “(wa wu tre, nno ni Rji) ");
INSERT INTO jid_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Una la ny'me ni wu ndu tie kpie ni tiema ko iyi ma na. ");
INSERT INTO jid_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bi kpa tre Rji ni tie meme ni al'ada mbi wa bi ndi nji wu ngbangban me. Ni gbugbu kpie wa bi muba wa bi tie'a. ");
INSERT INTO jid_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A yo kpentren ndi ba ngarli nda tre wo me wawu mbi wu ndi to. ");
INSERT INTO jid_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ikpie ri u kora na he na wa ani ba ndi tie meme”. A hi kpie wa a rju rji ni mi ndi, ikiyi ni kpa ndi tie meme” ");
INSERT INTO jid_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Indi wa a he ntlon wo'a ka wo. ");
INSERT INTO jid_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","To, Yesu a ka kpentre ndi ba don nda ri mikoh, mrli ko ma ba mye itre misali. ");
INSERT INTO jid_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu tre bi yi me itu mbi rli he bwu? Bi na to ndi ko ngyeri wa a ri ni ndi rji kora an a kpau tie meme, ");
INSERT INTO jid_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","don ana he nkon u ri ni suron ma na, amma ani hi mi nne ma nda rju hlega hi tra u hi mha?” Nitreyi Yesu a d'bu birli ba bi wawu. ");
INSERT INTO jid_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A tre, “Ahi kpie wa rju rji ni mi ndi mba ni kpau tie meme. ");
INSERT INTO jid_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Don rji ni mi ndi, rju ni mi suron ba' meme mre: gru tangban ni ndi, iy'bi, wundi, ");
INSERT INTO jid_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ikan, ingu, meme dri, gyru ndi, bison biye, bi shishi meme, bi kpa ndi tie meme, nzutu, bi mrlian ndi. ");
INSERT INTO jid_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Biyi wawu mba wu ba meme wa ba rji ni mi, bi ki ba kpa ndi tie meme ");
INSERT INTO jid_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A wlunde ni ki nda hi kpama ni iklan u Taya ni sidon. Niki a ri koh nda na son ndu ba to wrji wa a he'a na, amma ana ya' nda ri kpama ni ndi na. ");
INSERT INTO jid_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amma ni wo a he, iwa ri wa kpura vren wa ma a he ni brji a ye nda nda ka ku joku niwu za. ");
INSERT INTO jid_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","To, iwa ana ndi u Helleni, u l'me Surofinishan. A bre wu to ju brjia rju ni vrenwa ma. ");
INSERT INTO jid_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A wa wu, ndu ba guci nno mrli rli. Ana he tu nkon na, ndu ba ban birli u mrli tayo yawhu na.” ");
INSERT INTO jid_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Amma iwa kasa wu nda hla” Njanji, Baci, e yawhu wa ba kru za tebru'a barli bu mbru (rjurju) u mrli ba. ");
INSERT INTO jid_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A hla ni wa, ni tu kpie wa u tre, u ka hi. Ibrji a rju ni kpa vrenwa me ye'. ");
INSERT INTO jid_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A k'ma hi koh ma nda ka to vrenwa kru ni tu kru u ibrji rliga rju ni kpa vrenwa ye” ");
INSERT INTO jid_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A la rju ni nklan u Taya, nda hi ni sidon ni teka halili rji hi ni inklan u Dikafolis. ");
INSERT INTO jid_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ba nji ndi ri ye wu wa ana mangbi nda ta to tre na, nda bre wu sawo wu. ");
INSERT INTO jid_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A nji'u hi kosan ni bubu wa ndi bana he na, a sur mri wo ni mi ton ma nda ti ntan ka kpre l'me ma. ");
INSERT INTO jid_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A nzu ya shulu, nda cu vrli, nda wa wu, “Iffatha” wa ahi “Bwu!” ");
INSERT INTO jid_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hari itton ba, baka bwu, u l'me ma wa ana llo ngbangban, ka si nda tsi ni tre didi me. ");
INSERT INTO jid_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu m'ha ba ndu bana wa dio na. Amma to a m'ha ba ndu ba na hla dio na, wa katie na a con ba ndu ba d'bu ni ndi. ");
INSERT INTO jid_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ba tie sisri kpukpo me, nda tre, “ A tie kpi ba wawu-u didi me. ");
INSERT INTO jid_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Niton mu a indi gbugbuwu ba hei ba wa bari. Yesu yo miri koma da tre bawu di ");
INSERT INTO jid_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“idi ba ba lo me suron, ba he mi me har vi tra (3) ye da na hei ni kpe wa ba rhi na.” ");
INSERT INTO jid_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me ta turba duba he kpamba ni komba dana rina ba ki kobo ni ko bari ba ji ni gbugbamu.” ");
INSERT INTO jid_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mini koma ba mye “kife birdi nitsen-e ni wa, da ni mal ni di ba yi?” ");
INSERT INTO jid_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A miba bi hei ni gble bredi ibve wa miye ba “ a hi bredi bren ba bi he niwu? uba hla a ndi tangban. Ba lla ni wu'u “tan gban” ");
INSERT INTO jid_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A tre du gbugbu di ku ba son ni meme da ba bredi tangpa da bre da non mini ko ma du ba ga ni bawu u ba ka ga ni di ba. ");
INSERT INTO jid_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba hei ni lambe game time ni womba baya wa a bre Irji, da la yo mir koma da nuba duba nu ndi ba du ba tan. ");
INSERT INTO jid_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Da ba ta ba wrji da vu imbru ma sisen tangpebi rigarma. ");
INSERT INTO jid_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Indi ba bakai dubu iziya (4000). Ba ya ki a yo ba ninko duba hi kpamba. ");
INSERT INTO jid_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","A ti-gbla ri ni jirgima baba mininkoma da ri nklan Dalmanuta. ");
INSERT INTO jid_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bi mrlian ndi ba ba ye da faragbi sur ni wu'u. Ba son ba to alama wa rju ni shullu, ba son ba tser u ton. ");
INSERT INTO jid_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A tan fuon ni mi suron da tre “a gye sa indi bi meyi ba son ba to alama na? Janji mi la yi wu idi bi meyi ba na to alama na”. ");
INSERT INTO jid_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wa kaba don dala ri ni jirgi da hi gar korima ");
INSERT INTO jid_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Miri ko bi ti ndu ma ba kparisu da na ba vredi gri na. A don riri ni mi jrigia. ");
INSERT INTO jid_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A hla ni bawu, son ni wuri ti ta yo shi-shi na kpa risu ni yistin Farisawa na niwu Hirudus na” ");
INSERT INTO jid_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mini koma bi tindu, ba kpaye ni kpamba da tre a he wa bredi na he na. ");
INSERT INTO jid_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu to kpe wa ba si ri mire ni dir mba, da tre. A gye sa, bi ri mre ter bredi ni suron bi? har zizan bi na tuna? Bi na ganina? Isuron mbi ba k'ma di bwu mu? ");
INSERT INTO jid_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bi hei ni shi shi bi na to na? Bi hei ni ton bi na wo na? Bi na tuna na? ");
INSERT INTO jid_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ni wa mi zie bredi ton (5) mba gah ni di dubu ton a (5000) bi vu kpu kpu bredi shu sisen bre?” Ba la wu di wlo don har (12)” ");
INSERT INTO jid_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ni wa me zi bredi tankpan ni di dubu zi'a (4000) bi vu kpu kpu bredi ti sisen bre?” Ba hla u di “tangban” (7). ");
INSERT INTO jid_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A mie ba, har ziza'a bi na gani na?” ");
INSERT INTO jid_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Da ba ye ni Bethsaida. Idi ba ni ki ba grji di u fei ye da bre Yesu di du sa wo ni wu. ");
INSERT INTO jid_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu a vu indi wu fie'a niwo dakji wu hi ni mi gbu. D a' a junte sur niwu nishishi da sa wo mani wu, a mei, “wu to kpe?” ");
INSERT INTO jid_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A zuya da tre, me to indi bi ya na kukro ba si zre. ");
INSERT INTO jid_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A la kawo ma sa niwu nishishi maki shishi ya ka bun to u zizan abi zan wumumla wa to ko ge tsartzar me. ");
INSERT INTO jid_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu hla wu ziza'a wu he ni kome nu, na rizu ni mi gbu ga na.” ");
INSERT INTO jid_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ba mini koma bindu ma zu ni ikoyuka wu Naesarea Filippi. A me mir ma ba nikon, “Bi ya ndi ba, mie di me nha'an?” ");
INSERT INTO jid_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mini koma ba la niwu wu yohana wu Baptisma, 'U' bari ba tre wu Iliya bari batre wumba kan-kan wuri nimiyi anabawa. ");
INSERT INTO jid_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A mie ba u biyi na bi tre me nha? Bitrus tre “Wu yi wu Kristi.” ");
INSERT INTO jid_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu mam ba du ba na hla ni dro na ni tumu na. ");
INSERT INTO jid_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Da soma bla bawu di vre di ni sha ya ni kpe gbugbu 'U' ba kamba ni u idi bi ninko ni bi chu ni Priestoci, ni bi nha vuvu, ba wu'u, ivi tre (3) ni ta ti ti tashem. ");
INSERT INTO jid_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A hla terki tsrame. Naki Bitrus kma he ni kosan da tre da gbiton ni wu. ");
INSERT INTO jid_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu kma ya miniko ma ba, da tre Bitrus ni tu “Kma tsi dimu,” Kma hi ni ko gomu wu brji wunayoshishi me ni kpe u Baci na se kpe wondi wu idi” ");
INSERT INTO jid_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A yo ndi baba mir koma ba ni buburi da tre ni bawu. Indi a ni iya da wume ka kparisu ni kpama da ba gieiye mu da hu me” ");
INSERT INTO jid_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Du indi wa tre wa wu nikpa tuma ani qu, uwada kri ni suroma ma don demu ni tre Rji ani kpa tuma cuwo. ");
INSERT INTO jid_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A gye ni zo idi ni gbuglu yi wanda ia zan rai ma? ");
INSERT INTO jid_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A gye wa indi ni ser kpama da fe sur ma? ");
INSERT INTO jid_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Indi wa klusha mu mba tre mu ni meme ugbugblu yi u la tre e iverindi ni klushama indan a ni ye ni dau kaka tima ba ba maleku ma bi ruhu tsatsra. ");
INSERT INTO jid_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","a hla ni ba wu ndi janji mi hlahni yiwu ba ri ni minbi bana to iqu rhi nda to ye iko irji ni gbengle ma na ");
INSERT INTO jid_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","da vi tane a kle yesu a vu Bitrus mba yakubu u Yohanna nda ngrji ba ka hon ni khikle gblu ri ni nkle ba hama ni ko ni doir ni ba niki ikpama a kma sraro ");
INSERT INTO jid_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","e nklon ma a kma zan kinkla rais zan ibluch wandi ba tindu ni wu da chu itsro wandi a centu ni mi ikpi wu gla ");
INSERT INTO jid_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ba kri toh Elijah mba Musa ni mi mba ba si tre ni yesu Bitrus lukri da ");
INSERT INTO jid_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","kpanyem ni yesu rabbi ani bi du ta khi ki niwayi wu ta kpanyem wu ka duta sro ibru itra niayi iri wu me iri wu Musa e iri wu Elijah ");
INSERT INTO jid_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","shishi ma a fontsii nda du lu tre to ki ");
INSERT INTO jid_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ikpa lu a lu kri kaba pyenpeme e ba lu wo lantre ni mi kpaa an di ");
INSERT INTO jid_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","uwayi hi vren wu sron mu wo tre ma yi ba kma ya bana la to ndior na sai yesu ");
INSERT INTO jid_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ni andi ba kma si grjhi rjhi ni tu gblua a mhmba du ba na hla ni ndoir ikpi wandi ba to ni tu ngblua na sei vren ndi ta shimen ni qu ");
INSERT INTO jid_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ba kpa tre a grji sron da ki tre ndi tashen yi ni qu a gye? ");
INSERT INTO jid_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ba lu mye ni dongye nikon bi nha vunvu ba tre ndi Elijahni guci ye ");
INSERT INTO jid_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","a kma hla bawu andi elijah ni ye guci da ye mla kpi ti amain gye sa ba rhe ndi vren ndi ni guci ti ya kpukpome u ba kpa a tsiri ");
INSERT INTO jid_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","mi lha niyiwu Elijah a yeye u ndi ba thi ekpi wandi ba son ti niwua tsra ni kpi ani ba hla ni tuma ");
INSERT INTO jid_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","da ba ye zon tu ni nbru mri ko bi huzama ba ye to ndi gbugbuwu ba bi niko bi nha vuvu ba si sen nyu ni ba ");
INSERT INTO jid_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","da ba to yesu ipentren di ba ghir nda tisutsu ye cie ");
INSERT INTO jid_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","a mye mri ko ma bi huzama di bisi senyu qyemu ni ba? ");
INSERT INTO jid_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","indi ihii ni mi gbugbu ndi ba sa wu da tre ndi ndi wu tsoro mi nji vren mu ye ni wu a hei ni suron ibrji wandi ani zu bubu tre ");
INSERT INTO jid_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","a nita lu niwu a ni ban u whurtaga da du ta zran da fu nfom ni nyu da tan nyere du kma kru kpen me mi mye mri ko me do ba zu mcmebrji rju u ba ti wa kran ");
INSERT INTO jid_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","a si tre ni bawu ndi kba bi hon kpanye ni son ni yi tsar ni tan? mi vu sron ni yi hi ni tanmu? njivren ye nimu ");
INSERT INTO jid_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ba nji vivren ye niwu ni tu yesu meme brji a kri tru ku kma vivren a rjoku da zran da ni kran nfo ni nyu ");
INSERT INTO jid_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","yesu a mye thima azi he toyi rji ni tan? ti ma a halawu ndi rhi ni tistea ");
INSERT INTO jid_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","a nita lu nivu ani ban wu taga ni lu ani bawu yo ni ma kama ani wuuu wuta ni ti kpe ni tu ma wuka ya ta ni lo suron ni sikpa ");
INSERT INTO jid_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","yesu a myee wuta ni to ti ko nge na zan gbenglen na ni indi wandi a kpanyema ");
INSERT INTO jid_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","hari iti vren a dbu da tre ndi mi kpanyme zo khanyme mu ");
INSERT INTO jid_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","da yesu a to ikpa ndi ba tsutsu si ye ni ba a kri nacho ni meme ibrji nda tre di wu brji manbi ba nkpram me nacho ni wu rhu ni kpa ma dina la kma ri na ");
INSERT INTO jid_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","a kpagro da ru do vivren joku ku kpin kpiri nda rhu ni kpama vivren a kru naa que u gra ndi ba tre di a qui ");
INSERT INTO jid_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","aman yesu a zu wama hon u vivren a lu de kirkir ");
INSERT INTO jid_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","da yesu a kmaye ni ko mri koma ba mye ni kosan angye zuta bubu zu rhu? ");
INSERT INTO jid_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","a lha ba wu ndi bibiyi ba na zu ba rhu megen na sai de ni bre irji ");
INSERT INTO jid_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ba rhu niki nda zren zu ni Galilee ana son do ndi du ba toh wrji wandi ba hye na ");
INSERT INTO jid_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","a sira tsro mri ko bi hua da ila bawu ndi vivren ndi ni ku ni woh mri ndi ba wuu u ni vi u tra ani tashmem da lunde ngari ");
INSERT INTO jid_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","bana to tu tre a na siri zuba bubu myea ");
INSERT INTO jid_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","mle bari ni capernaum da ba rhi niko a mye ba ndi bisiyatre ni tu gye niko? ");
INSERT INTO jid_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ba kma khi ni gbangbi ba siya sen nhu ni kpamba ni tu nha zan mbrumba ");
INSERT INTO jid_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","a kuson da yo mri ko ma itso ba nda bha bawu ndi wa nison hye mu mlan ka kma tuma yo kogon da tindu ni mbru ba ");
INSERT INTO jid_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","a ban vivren tsitsa nda kau zi ni tsutsu mba nda baun nji ni ngban ma nda tre ndi ");
INSERT INTO jid_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ko nha wandi a kpa vivren tsitsa yi ni ndemu a kpa me ndi wa a kpa me ana me megen a kpa na a kpa ndi wa ton me ");
INSERT INTO jid_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana hla ni wu di tico u khi to ndi rhi si zu brji ni rhu ni kpa ndi ni ndeme khi zuu ndi a ana huta na ");
INSERT INTO jid_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","yesu asa niwu da tre ndi na zuu na ndi wandi a ni ti khikle kpe ni ndemu ana kman tre kpe meme ni tu muna ");
INSERT INTO jid_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ndi wandi ana komani ta na a wubu ");
INSERT INTO jid_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ko nha wandi anuyi kofima u so ni ndemu nitu bi hye wu kristi mi lha tre janji ni yiwu ana hon kpa lidima na ");
INSERT INTO jid_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","indi wandi a do iri tsitsa biyi biwandi ba kpa nyme ni me ba kubuza ani zan do ba nkpi tita glo ni toh ma nda tru yo ni lon ma ");
INSERT INTO jid_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","e wome nita do kbuza ha taga ani zan wuka ri ni ko rji ni kpurhuwo ni do riko lu wandi ana kle na ni wome bambawu ");
INSERT INTO jid_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","chiche vunvu mumla bi bana hye nitre aya 44 hi ni 46 na bubu wandi intso bi andi ba he nike bana kwu na e lu na ybe na ");
INSERT INTO jid_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","iza me nita du kbu za han ihu ani bi zandu ri ni ko irji hama ni za ni du he ni za me hamba e baka truyo ni mi lu ");
INSERT INTO jid_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","chiche vunvu bi sen wa ba bizen bana he ni nha 44 mba 46 na wa ntson mba bana kwuna e bana ybi lu ma na ");
INSERT INTO jid_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","shishi me nita du kbu 39 chuu rhu ani bi zan wuke ri ni ko irji ni shishi ri ni du hye ni shishi ha ni do ba truu yo ni lu ");
INSERT INTO jid_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wandi ba tson niki bana kwu na ilua na ybi na ");
INSERT INTO jid_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ba hii ko nha ni ma wu ba gon toni ma ");
INSERT INTO jid_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ima bi anita chu ro ma ru wu kmaahi ro ngari? he nii ro ma ni kpambi ni du sisuron hei ni minbi ");
INSERT INTO jid_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","a luye ni migbu yahuda u kle kle ni gran gbu urdu indi gbugbuu bla ye niwu wa soma bla tre rji ni bawu nawa a ni ti chachia ");
INSERT INTO jid_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisawa baluye niwu na miyen a hi hlatre ndu lilon zuwama basun wokpie wa anitre ");
INSERT INTO jid_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","wa miye ba ani musa a hla ni yiwu nige? ");
INSERT INTO jid_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","u ba tre ani musa kparyemen nduba nhan takada u ga gram na kachuwo ");
INSERT INTO jid_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","yes bawa ani kawo tre biyi atre ndu ba nhan ");
INSERT INTO jid_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","rji mummla irji tie lilon ba iwa ");
INSERT INTO jid_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ni tukima lilon ni ka itie ma ba yima don da shi sun hamba ");
INSERT INTO jid_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ha mbaa ba zama inaman kpa riri anaki bana harina ni koshishi ama inaman riri ");
INSERT INTO jid_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ipie wa irji tie di diori naga tie hari na ");
INSERT INTO jid_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ni mikoma almagerema ba hla miyen itre kima ");
INSERT INTO jid_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","wa hla nibawu du indi wa a zu wama na kpari a si yi zina ");
INSERT INTO jid_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","naki ni iwa wa a kama ni lonma na gran irir wawume a si yi zina ");
INSERT INTO jid_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","baka ji miri bi zizah ma ye niwu ni ndu bre wo niba almajere ba zuba ");
INSERT INTO jid_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yesu toh naki isuron lude nivu wa hla bawu diba bre mirizizah di ye mime na zuba na na iriba mulki rji ahae ");
INSERT INTO jid_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","njaji tre mi hla yiwu indi wa ana kpa mulki rji na vieveren tsitsana ana rimulki na ");
INSERT INTO jid_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","a vuba na brewoba ba na tie lulu yo bawu ");
INSERT INTO jid_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","da alude hi ni tukon iguri a lutsuts ye ni shishima na kuquegbarju na miyen mala u ndi ndi mi tiege nife mulkime? ");
INSERT INTO jid_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","yesu miyen age sa u yome mala u ndi ndi? irji kagrjima ani tie ndi ndi ");
INSERT INTO jid_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","u toh dokoki u na hla di na u na yi zina na u na mimre diona na kpa tieme ba yime tsiri na ");
INSERT INTO jid_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","wa hla niwu mala nima tie bi bana tun mi hie ni verenze ");
INSERT INTO jid_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","yesu kahya na gir ni suronma ni kpie wa atiea wa hla niwu ikpie riri a ridonhi ko ni vugbime wawu lea ni kah nkle ga bi tie ya ");
INSERT INTO jid_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ama isurinma joku nitu tre ki wa hi nifu ni suron ma nitu wa a hi ndi u wo ");
INSERT INTO jid_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","yesu kahya kagon ni almajere ma da tre adi a he niyah ndu indi u wo du ri ni tarji ");
INSERT INTO jid_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Almajere ma ba hanyue ni wotre ki i yesu lar tre burbru adi a hei niyah do ndi u wo du ri tar rji ");
INSERT INTO jid_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","lakurimi niri ni ndo noron gbalame niwa indi u wo ni ri nitarji ");
INSERT INTO jid_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","u ba hahyue da miyen a nhan ni nawo ke na? ");
INSERT INTO jid_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","yesu kahyaba da tre ni ndi kpic na yina ammma ni rji koge ni yiu ");
INSERT INTO jid_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus luwulde nitre ndi ga ki kah koge don ndi ni hu ");
INSERT INTO jid_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","yesu tre adi njaji tre ba indi wa ani kah iko don ko imimre vayi ma imimre lon ko mimremba ko iyi ko itie ko irjun ko imimrema don ni tumun ba itre mu ");
INSERT INTO jid_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wa a na kpa dima wulon okpu wulon na ni zami yina ");
INSERT INTO jid_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","gbugbuu wa ba hei ni koshi ba kama ye kogon u bi kogon ba kama ye koshishi ");
INSERT INTO jid_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ba lu hon sihi ni urushelima u yesu guchi ni bawu ni koshishi u ba hannyiu bi wa ba si huba ni kogon kura ba tie sisir wa ala vu iseri a na sibla ni wu iri kpie wa ba toh a ni ye ");
INSERT INTO jid_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","a latre ige ki sihiyi ni urishelima ba kah vren ndi no firist ni ba nha ba ndu ba wuu na tieu ya nshishi meme ndi ");
INSERT INTO jid_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ba weyen niwu na juten sur na tsi ni gbugban na wuu ni vi utra a lude ni rei ");
INSERT INTO jid_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakubu ba yohona mri zabadi ba chibye niwu na tre a ndi ndu tie koge ni tawu wa ki preu ");
INSERT INTO jid_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","wa tre bi son me tiege yiwu? ");
INSERT INTO jid_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","iba hla niwu ba son iri mba disun ni wo kori u ri ni wo kotah ni mi darajame ");
INSERT INTO jid_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","yesu hla bawu bina toh kpie wa bisi pre ana bi iya so koko wa ime mi soa? ko ndu ba tie batisma ni batisma yiwu na wa ba yi ni mura? ");
INSERT INTO jid_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","u ba kpayeme di ba iya u yes tre koko wa wawu ni soa ndu ba so nibatisma wa ba yi nimua niki ndu ba yi niyiwu ");
INSERT INTO jid_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ama son niwo kori ko wo kotah na u muna niwa minoyi a hi u biwa ba chii ba ");
INSERT INTO jid_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","i wa iwulo ba bawo isuron ba a lude tie meme u ba tie fu ni tu ba Yakubu ba Yohana ");
INSERT INTO jid_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","yesu yo ba na hla bawu bi kah toh ndi be wa kah indi bi gbugbulun no ba ni woba ba nji ba u zizan ");
INSERT INTO jid_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ama a hei naki ni mi bina se de wawuu indi u wa ani zama nigon wa wuyi ni zama gran ");
INSERT INTO jid_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","iwa ni zama mumlan ni mibi ni zama gran ");
INSERT INTO jid_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ni u njaji vren ndi na ye nduba tie yah nitu ma na ama wawu ni tie ya nitu bari da kpa que nitu bari gbugbuu bi latre ndu ba nawo ");
INSERT INTO jid_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","u ba ye ni jeriko wa ye rju ni mi jeriko ba ba almajere ma ni gbugbu ndi u indi ufyen ba yo niBartimawus vren Timawus a son ni yiu gon ");
INSERT INTO jid_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","da a toh adi a yesu ba nazaratna kpa gro ni yon yesu vren doda ya me ni shishi losuron ni zo me ");
INSERT INTO jid_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","indi gbugbu ba yarhan ni wu adi ndu son nigbagbi wa kama na ni yo yesu vren doda yame ni shishi losoron nizome ");
INSERT INTO jid_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","yesu kukre da nduba yo uba indi uyen na hla ni wu ndu gir na tie kinkle soron ni lude ");
INSERT INTO jid_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","wa wume a kah nklon ma taga na dolude hi ni yesu ");
INSERT INTO jid_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","yesu kpa nyimeniwu na myen u son mi tiege niwu? ");
INSERT INTO jid_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","yesu hla wu lude hi kpa me bangaiskiya a den u wa tsi toh kpan na hu ni tugon ");
INSERT INTO jid_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","da baye ni urshalima baye wiewiere ni bethphage mba Bethany ni gbuku olives u yesu ton mrikoh ma hari ");
INSERT INTO jid_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","da hla ni hawu hi ni vi gbumu wakisiya biti rhi bi toh ba lo vre wadi idro na honni wu to na siwu ngrji mu ");
INSERT INTO jid_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","idan itro miyei yi di bichninu nha tre bachi hu niwa ida akle ki ji kamye hari ");
INSERT INTO jid_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","se ha rhi ni vi gbua da ba to vre ");
INSERT INTO jid_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","da si ndi bari ba mie ba bisi tigye? ");
INSERT INTO jid_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","u ba hla bawu bachi ni wa indi ba bana tre kpe na ");
INSERT INTO jid_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ba ji vre ye no yesu da ju nklon ba sur niwu du kusun ni tuma ");
INSERT INTO jid_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","gbugbu ndi bari ba ju nklon ba sur ni wu du nzere zu nituma bari ba wa vuvu sur niwu du nzre zunituma ");
INSERT INTO jid_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","biwa bana huba ba ya sei da guluzan da nitre hosanna lulu hei nitu ndia wadi a niye ni mi de bachi ");
INSERT INTO jid_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ite bu Dauda akpa lulu ni mulkima Hossana nimi shulu ");
INSERT INTO jid_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","da yesu rhi nimi urushalima da hi nitra irji da ya konitsen da yaluti wa ka rhu hi ni Bethany baba mrikohma ulon don ha ");
INSERT INTO jid_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ni vi uha ni bethanu u iyoun tiu ");
INSERT INTO jid_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","wa toh chi kukro ri ni gbugba n mu da hi ko ani fe iwo kukro a ni to ma da ahi dana toh kpei na sei vuvu migye ana hei niton u klomana ");
INSERT INTO jid_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","wa ka tre indio na ka ri klo mana u mri koh ma baka woh ");
INSERT INTO jid_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","da baye ni urushalima da ri hi ni tra irji da zu bi le kpei nitra irji da zu ruron ba hle ga ni bi sran klen nibi le gu ");
INSERT INTO jid_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ana kpanyeim duba ji kpei ule rinikina ");
INSERT INTO jid_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","q hlatre rbawu bana han na ba you ikoh mu di ikoh u bre ni gbugbuku bi kan iko bi yib ");
INSERT INTO jid_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","binna baba bi ti du irji ba wa nkon u wuu amma ba klu ndi ba, Gbugbu ndi ba wohtrea ");
INSERT INTO jid_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","niwa yalu a tin a rhu don gbua ");
INSERT INTO jid_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","da ba zu da toh kunkro wadi yesu lau a klu rhini njama ba bwu nyu yo ni woho daya ");
INSERT INTO jid_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bitrus a rimre da tre malla wu toh kukro wawu lau? a kuq wawu ");
INSERT INTO jid_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","yesu ka sa u you suron irji ");
INSERT INTO jid_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","jaji me hla yuwu ndi wa a you suron ni irji da hla ni ghu gbulu du grji joku ani joku ");
INSERT INTO jid_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","naki mi hla yuu di ikpei wa bi mie di kpa gyeim bikpa ana kam ti u me ");
INSERT INTO jid_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","da u kri di bre wuka kpayiem di wur hle duka ndia da lah u don du iti bi u shulu ni wur latre me hle niwu game ");
INSERT INTO jid_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ihan Mark ana hla duta wur hle na ");
INSERT INTO jid_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","baye ni urushalima gari yesu si nzre ni mikoh irji ");
INSERT INTO jid_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bi han ibe ni bi bla be ni baba bini koh baye niu da mie ni gbrgbrnlen han wu si ti kpe bi yi ahan nuu gbegbeblen u tiba ");
INSERT INTO jid_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","yesu ka sa du tre mime yi kpe ri bi ti ne tre a i mi hla u koni gbegbenlen nhami si ti kpi biyi ");
INSERT INTO jid_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","sukpa Yohana agri ri nishu ko ani ni meme ");
INSERT INTO jid_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","baka san iyue ni kpaba da tre kita tre a irji ni shulu wa ani tre ngye sa kina kpa jiem ni u na ");
INSERT INTO jid_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ama kika tre arji ni ndi ba klu sisir wa di batre si yohana ana ndi u ton du irji u ba hla ni yesu bana toh na ");
INSERT INTO jid_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","yesu ka tre meme mina hla ni yiwu ko ni gbengbenlen nha misi ti kpi bi yi ");
INSERT INTO jid_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","yesu wu vu tsuro ba ni misali a tre wa ro wa indi ri a sen kukron ni rju a rhau kagon nda shi juju wa a ni ka ta shibi ima klo ma a me ko u gbien gugloma nda ban nno jingina ni bi ron bi kukron ki a kle nda ye wlu hi ziren ");
INSERT INTO jid_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ni tsar mton u klo kukron ka ton igran ma ndu hi kpa iklo kukron bari wa ba tiea ni bi sen kukron a ");
INSERT INTO jid_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","amma baka vu u nda tsie nda zu kamma hi ni wo kuklu ");
INSERT INTO jid_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","a la tru dran ma ri hi u ba ka ruu tu nda nnu shan ");
INSERT INTO jid_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","nga rli a tru ri u ba ka wu kimaa ba tie ri ndi gbugbu wu na ki ba tsi bari nda wu bari ");
INSERT INTO jid_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","a don indin ma ri u wa ani tona ivren ba wa anni san a tru wa wu ma hi u kle klea a tre ba to vren mu ni fu tu ");
INSERT INTO jid_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ma me bi ron kukron ba bitre din a wa ti mba ni ri gadoa ye ki wu ndi ka rli gadoa ");
INSERT INTO jid_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ba vu wu nda kau taga ni mi rjua ");
INSERT INTO jid_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","to waa u ndi u rju ni he? a ni ye nda wu bi ndu sen kukron ba nda nno bari nkan nu irjua ");
INSERT INTO jid_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","bina kra kpie wa beblu tre a na? tita wa bi me ba ka mba ni wua a katie wa ba you ni vrun tra ");
INSERT INTO jid_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","i wa yi a hi tie u rji nda bi ya tawu ");
INSERT INTO jid_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ikpie wa a ye ko gona bi ninkon yahudawa ba wa nkon wa ba ba vu yesu don ba to din a tre misalia ni tu mba yi amma ba klu sisri ikpe ndi mba ni tu ki ba ka donwume nda hi kpa mba ");
INSERT INTO jid_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ba son nda la ka tru bi ninkon yahudawa bari ni hirodiyawa hi wu don ndu mba trene ni tre ");
INSERT INTO jid_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","da ba ye batre ni wu tica ki to wu na hu tre ndi na una tsuro son tu din na u tsuro jiji inkon rji han ban ni kaisar heitu nkon kanihe? ki han ka ni he? ");
INSERT INTO jid_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","amma u yesu to mliya nye ba nda tre di bi tsar me ni ngye? ne denarius ri me ndi ya to ");
INSERT INTO jid_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ba nji ri ye ni yesu a tre ndi a hi yu nha ba nde nha mba he yi? ba tre u kaisar ");
INSERT INTO jid_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","yesu tre din nno kaisar ikpie u kaisar din nno rji ikpie wa u rjia a nno ba mamaki ");
INSERT INTO jid_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","me na a sadukiyawa wa ba tre ndi tashmen na heina ba ye ni wu ba mye nda tre din ");
INSERT INTO jid_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","tica musa a nla tawu idan indi wa vayi ma qu nda da hama ni vren da kawa don inda ka ban wa vayi ma tie wa ma nda zi bi ni vayi maa ");
INSERT INTO jid_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","mri vayi bari tangban bana he u mumla a gra wa nda ye qu hamma ni vren ");
INSERT INTO jid_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","u haa ka ban wa nda qu game hamma ni vren u traa ngame a la he na u mbru na ba ");
INSERT INTO jid_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","tangban mba u ba na fe bi na iwaa me ye qu hu ba ");
INSERT INTO jid_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ni shulu iwa a ni u rime ba tie tashme ngarli? hon mri vayi tangban ba ba gran a tie wa mba ");
INSERT INTO jid_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","yesu ka tre a na ni ki bi yiba shishi na? don bina tre rji na ndi na to gbengle rji na ");
INSERT INTO jid_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","don bata tashme ba na gran ko ba gran ba na ba he na malaiku ");
INSERT INTO jid_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","amma ni tu bi wa qu nda tashmela bi na kara ta ni taka da Musa na ni waa irji tre wu ni tsutsu miji naa tre din me hi rji u Ibrahim ni rji u Ishaku u ni rji u Yakubu? ");
INSERT INTO jid_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ana irji kmo na ammma u bi sisren ");
INSERT INTO jid_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","iri ni grji bi nha ye nda wo kpe wa ki trea ni to sa tre yesua a myee a hi doka ria me bran zaaan wawuu? ");
INSERT INTO jid_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","yesu kaa sa wa a zan a hi wo Israila baci rji mbu bacia a riri ");
INSERT INTO jid_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","gbigbi u ka kpanyem ni baci rji ni suron me wawuu ni mre me wawuu ni dri me wawuu ni gble gble me wawuu ");
INSERT INTO jid_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","doka u ha a heito yi gbigbu u ka son makobci me na tu me doka ri na la he waa bran zan bi yi na ");
INSERT INTO jid_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","u bi nha ba tre din abi tica u tre njaji ndi irji a riri u ni wa wuyi a rji ni nklema ");
INSERT INTO jid_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","nduu son wu ni suron me wawuu u ni to me wawuu mba ni gbengble me wawuu ndi son vayi u ndio na tu me a zan hadaya wa ba gon ni lua ");
INSERT INTO jid_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","da yesu to ndaa hla tre u bi a hla wu di wu na bran kon ni mulki rjiwamba a kle tre a itre na la mere tre na kpena ");
INSERT INTO jid_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","yesu sita ru tra rji tre din ni he mba ni nha hla din kristi a hi vren Dauda? ");
INSERT INTO jid_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauda tu na ni mi ruhu tsartsar tre din baci a tre ni baci mu ku son ni wo ru mu se me ka bi kran wu tie kpe wa wu chan ni za ");
INSERT INTO jid_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda tu ma ne you ndi baci u ni he rli kristi ka vren Daua? nkpentren ndi ba ba ngri ni wo tre ma ");
INSERT INTO jid_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ni tsuro ma yesu tre tie wrli ni bi nha ba wa ba son zren ni guglo nklon da ni wa ci ni kasuwa ");
INSERT INTO jid_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nda son ni ruron u bi nikon ni tra rji ni wrji bi gan ");
INSERT INTO jid_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ba mrien imba bi kobo nda bre rji bran nkon ndu duba to ba indi bi ki ba kpa lukunci rligrama ");
INSERT INTO jid_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","yesu kuson ni gbala kori ni mi tra rji nda si ya ndi bubu ya nkle mba ni kaji gbugbu ndin bi nkle ba sur nkle babran ");
INSERT INTO jid_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","uwa u kmbo a ye nda sur nini ha rli wa a tsar ni kuburi ");
INSERT INTO jid_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","a yo mrli ko ma da hla ba wu njajimu me hla yiwu iwa u kmbo yi sur nkle zan ndi ba wawuv wa ba sur nkle ni kajia ");
INSERT INTO jid_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","bi mu ba nno rji gbugbu wu ni mi gbubgu wu wa ba hei va ama iwa kobo yi a no zan du di biwo ba yo kl ni kajia duka idi ba sur kle gbugbu wu wa ba hei va ama iwakobo yo kpe wa a hei ni mi ya ma da ni rli a ");
INSERT INTO jid_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","da yesu si zren rhe ni haikali iri ni mri ko ma bi huzama a tre ndi teacha ya tita ba baiko biyi ba biya ");
INSERT INTO jid_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","a hla ni wu wuto khikle mme biyi? ko tita rina kri ni tu kpanma hama ni zile na ");
INSERT INTO jid_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","da a son ni tu gbku olive wandi niya haikali a Bitrus, Yakubu, Yohana e Andrawus ba mye ni yib ");
INSERT INTO jid_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","hlani tawu nita mba ikpi bi yi ba faru? age ba ni tsoro ta ndi kpe biyi ba ti wiewere wu whursu ");
INSERT INTO jid_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yesu a lu kri si bla ni bawu mla ya nin du dior gyuryi na ");
INSERT INTO jid_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","gbugbwu ba ye ni ndume nda tre mi wawu yi nda gyur gbugbwu hi hle ");
INSERT INTO jid_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","bita wo kuu ko tre huu na ti sisiri na kpi bimba ba ye ama ekli rhi hye ri ");
INSERT INTO jid_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","gbumgblu ba lu wa nhu ni gbungblu u bi chu ba kamba kpamba bi wo jub meme ni bubu kankan ni yon me ni hei be ba yi farlio yi nei na kri lega na ba vu yi hi lo da tsiyi ni tra wu bre irji mbi ");
INSERT INTO jid_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ba gbronyihi duyi kri ni gaba gononi ba ba bi tuchu ni tu nde mu a duyi tsoro ba ikpe wandi me ti ni yiwua ");
INSERT INTO jid_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ama itre rji ni kuci hi kago ba ti vu yi hi lo bi kana ti sisir na tu kpe a di bi tre a na ");
INSERT INTO jid_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","niton ki ba na ye ikpe wa bi tre a ana bi yi bi tre na ruhu maitsarki ba ni tre ");
INSERT INTO jid_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","vayi ni lani vayi du wuu haka e ti ni tre ma mri ba lu kri ni tu ba yimba ni ba timba du ba luu ba ");
INSERT INTO jid_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ndi ba karnwu ni tu nde mu ama ndi wa a kri gbangban yi ni kle ani gbujbwu ");
INSERT INTO jid_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","bi ta to meme gunki ba ni kri ni bubwu ana kamata na indi wandi asi bla vunvu yi ka mal ya da rimere be wandi ba he ni gran judea duba tsutsu hi ni tu ba gblu ba ");
INSERT INTO jid_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wandi a he ni yu tra du na grji ri niko diwawu ni ban kperi na ");
INSERT INTO jid_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","e wandi a he ni rhua do na kma ye ban nglo ma ni ko na ");
INSERT INTO jid_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","imba bi mri ni nei ni biwa ba hei mir bi masisi ba hei ya ni vi ba ki ");
INSERT INTO jid_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","bre trji du na hye ni ton sai na ");
INSERT INTO jid_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","vi baki baa ton wu khikle dan ton u ya wandi kina taba toh rji mumla wa irji a ti gbungblu wawuu ye zizan e khina la toh na ");
INSERT INTO jid_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","irjhi nita na mer viba ruh na ba nma wandi ani nawo ni ta bi wa ana ju ba ye a do vi ba do ba na bra na ");
INSERT INTO jid_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ko nha nita llha ni wu ndi ngye kristi he yi ko ngye a he mu na kpanyme na ");
INSERT INTO jid_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","krista bi che baba anabawa bi che ba ye ni alamu gbugbuwu da gyur ndi ko ni bi wandi irji chuba ye ");
INSERT INTO jid_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","mla kri mi hla kpi bi yi ni yiwu du yi guci ni ye mba ");
INSERT INTO jid_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","baya ya wu ton kima irji na wu na ani ti buh iwua na kpana ");
INSERT INTO jid_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tsitse ba rhu rjoku rhi ni shulu u iko u shulu ni cu mle ba to ");
INSERT INTO jid_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","vren ndi ni ye ni mi kpalu ni gbengble ni daraja ");
INSERT INTO jid_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ani ton malaiku hi ni nfro nza bi gbungblu meme wu shulu do ba yoh bi ma wandi ana chuba ye ");
INSERT INTO jid_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","to kpe wu mla ya to ni kunkro fig nto wandi vunvu ma ju wu to ndi esu ti weiweire ye ");
INSERT INTO jid_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","na ki me wuta to kpi biyi ba si zren to ye ma a weiweire ni nkontra ");
INSERT INTO jid_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","janji mi hla yiwu bi zan yi bana kle hamma ni to kpi biyi na ");
INSERT INTO jid_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","shulu ba meme ba kle ama lantre mu na kle na ");
INSERT INTO jid_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","nitu via ko ntoma ndoir ko maleka ni shulu ko vren bana to ha iti mehe a to ");
INSERT INTO jid_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","kri ni wri ni mla ya nitu wuna to iton a na chiche vu vu bi Greek bari ba yo tre toyi kri ni wri mla ya ni bre ");
INSERT INTO jid_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","na ndi wa a hi zren a don koma nda don mri ko ma ta ya ko ko nha ni ndu mada mha bi ya ba a duba khi ni wri ");
INSERT INTO jid_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ni tu kima wu na to ka tiko ni kma ye ni ton rime na ka ni yallu tsutsu chu koka ni gbatup wu bwhumble ke ni mble ");
INSERT INTO jid_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","anita ye niko gbru me na ye too wa si krunana ");
INSERT INTO jid_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","kpe andi mi lha ni wua mi hla ni ko nha mla ya mal kli ");
INSERT INTO jid_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","a don viha duba ti ngan u passover idi mba ngan u bredi wa asa binikoh bi ton du irji baba bi han ibe ba sun diba yib yesu da wuu ");
INSERT INTO jid_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ba tre ana hei nitoh gan nadutsi kanalude ni tsutsu ndi na ");
INSERT INTO jid_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","da yesu a hei nikoh siman u lo shia basi rhi biri u wa hri a riye niwu da ji kpalaba alabaster u klen ma wa ba you di nard ayar kpalaba da kayen a sur nitu yesu ");
INSERT INTO jid_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ndi bari ha hei niki da tifu ni kpaba da tre ai higye kpei wa iwa yi tidu migye ");
INSERT INTO jid_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","smsl du bs ban tutate a le ru kle wa ani kai deri tra wa ba zo biti ya ba tre a ");
INSERT INTO jid_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","yesu ka tre ahi kpei didima ati nimu ");
INSERT INTO jid_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","bihei nibi yaba chachuu wadi ko ni tan biya zoba ama bina hei ni me chachuu na ");
INSERT INTO jid_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","iwayi ti kpe wa a iya ti a asur turare don chachu rhumu ");
INSERT INTO jid_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","misi hla tre jaji niyuu konitsen ba hla tre irji nimi gbugbulu sei ba hla ikpie wadi wayi ti ko ni kogon kuq ");
INSERT INTO jid_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","sei vre koh ma rhi wa ba you di Yohuda iskarioti ruhu hini bi ton du irji don du vuu noba ");
INSERT INTO jid_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","da bi toh du irji ba woh da ngri kpukpome niwu da you iyei ba no kle wa sima ni wa koh wa di aru vu yesu noba ");
INSERT INTO jid_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","niyi u mumla u berdi wa ana saana waba nha yi krju ton ngla lah tre ntoh u inga ni sei nisei u mrikohma ba miyei anitse ki hi mla bubu u ri biria? ");
INSERT INTO jid_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","atohmrikohma hari da hla bawu duba hi mi gbu ndiri hluiri u fo ma bi aka hu hi ");
INSERT INTO jid_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ahi ta rhi nikoh bi ka hu idia hla u di la di ukoa malla tre ikoh mu wa mirhi biri baba mrikohmu? ");
INSERT INTO jid_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","anitsro yi kikla mikoh wu koshu waba mlati bikah mla ti ni tawu ");
INSERT INTO jid_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","mrikoh ma ba hi ni mi gbua da ka toh inpie da a tre hei nakima da ti birhi ketarewa ");
INSERT INTO jid_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","da yalu ti wa ji mrikohma tsoh hi ");
INSERT INTO jid_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","da ba kru da si rhibiri nitu tabur yesu katre jaji mi si hla niyi wu iri nimi bi nivu me noba ");
INSERT INTO jid_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","bayi ni suron ba da nimiyei ahime? ");
INSERT INTO jid_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","yesu kasa nibawu wa da si you woh ni me ni gbugban ");
INSERT INTO jid_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ivrendi nihi na a han niyuma iya ndikima wadi ani vu yesu noba abi di na grhi ndi kimana ");
INSERT INTO jid_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","bashei ninu rhi biri yesu ban bresdis da ti lulu you nibredia da mere ga niba wu datre wayi hi nma kpamu ");
INSERT INTO jid_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","a bangbaju datre ");
INSERT INTO jid_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","wayi a hu yimu wa mi sur iyieu ni yuwu wa ani kahle nigbubuu baka so wawu bauu ");
INSERT INTO jid_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","me hla tre jaji mina la somi klo kukru gana sei ivi wa mi so ni mikoh irji ");
INSERT INTO jid_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","bayou sei da rhu hini gbulu olives ");
INSERT INTO jid_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","yesu hla ni bawu wawubi bi joku yada ba han iq mi vu ndiu krhutimaa iq u itima bavra ni kagakaga ");
INSERT INTO jid_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","bata zume lude in mi hi Galilee guchi niyuu ");
INSERT INTO jid_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bitrus kahla ru yesu ko ba hi kpamba wawuu ine mina hina ");
INSERT INTO jid_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","yesu ka hla u nichu luwa du gba du tub tup kpu u kpa tron di u una tohme na in kpu tra ");
INSERT INTO jid_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bitrus tre ko mi qu bu wu mina tre dimina toh una baka you inveu ni yesu wawuba wu ");
INSERT INTO jid_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ba ye ni bubu ri you di Gethsemane yesu ka hla ni mrikoma kuson wayi ime me hi bre ");
INSERT INTO jid_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","a banBitrus Yakub u Yohana ni kpama a rimer da ni damu ");
INSERT INTO jid_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ahla bawu isuromu ni lome har na u qu ki mai di ta gbe har hi ni kuqu ");
INSERT INTO jid_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","yesu for zre fime da ku joku ni meme da bre inde aru bie ka wur ton a hle niwawu ");
INSERT INTO jid_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","datre abba ti bu ikpi ba yereyere niwu wuka cu gbaju yi ru ni mu aman ana ti muna ahi wume ");
INSERT INTO jid_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","aka kam ye da yetoh ba basi kruna da miye Bitrus sima bi si kruna? koh niton riri me bi na iya gben na? ");
INSERT INTO jid_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","gbien di bre don di na joku nimi lah tre na isuron a nyme ama ika a si ");
INSERT INTO jid_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","a la hi da tretre wu mumla gari ");
INSERT INTO jid_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","da aka kam ye da toh basi kruna na u mumla shishi ba a ron u bana toh kpie wa ba hla wuna ");
INSERT INTO jid_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","akma ye kpututra da miye ba bu risi kurnari di ni siri? atsra no toh a yeye to bavu vre ndi you ni woh bi latre ");
INSERT INTO jid_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","lude kinihi to idi wa a vu me ni noba a he weiweire ");
INSERT INTO jid_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","a sihei nimi tre a u Yahuda iri ni mi a aye ni gbugbu idi ni ba ijin gban nibi toh du irji ni bi han be ni bi nikoh ");
INSERT INTO jid_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","indi wa a vu haba a guci tsro ba woh ni wuye Biti toh diwa mi sumbace u wa wu yi bika vu di griwu di hi ba ba bi gadi ");
INSERT INTO jid_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","da Yahuda ye ahi ni yesu gbla me da you ");
INSERT INTO jid_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","di ranni da rhugume ni u indi ba kavu na ki u ri ni ciki mba waa kli niba kia ");
INSERT INTO jid_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","chu inji gbama da chu vuvu to diri ni mi biwu niko pristoci ba ");
INSERT INTO jid_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","yesu a mieye ba bi ye vu me na diwu yib ni ji gban ni kpe iku ");
INSERT INTO jid_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","mitahei niyi chachuu dita bla tre irji ni yiu nitra rji bi na vu me na a hei na ki don du tre rji cika ");
INSERT INTO jid_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","duka bi wa ba na hei ni yesu ba tsutsu da kaa don niu ba tsutsu hi kpaba ");
INSERT INTO jid_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","vivren nze ri wa alo vi gbajanklo u kaakpa megen a sia hu e mri nzeba ba yo wo vuu ");
INSERT INTO jid_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a ka gbanjanklo chuwo ni bawu nda tsutsu ru ni ngbre ");
INSERT INTO jid_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","niki ba nki yesu hini ninko prist nikima ba kikle prists ba ni chiche mba bi nha ba zontu kii nha niwu ");
INSERT INTO jid_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","e Bitrus a nha huba kari ni tra nkon wu nikon prist a ndaka kuson ni ba mriko nduba nda sia mu kpama ni lu ");
INSERT INTO jid_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","nikon prist baba bison nda bla tre ni trankon a ba wa biwa ba njitre kpewa bato nitu yesu ni duba wuu nda wa hama ");
INSERT INTO jid_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","gbugbu mbawu ba sia blatre che nituma e nyu bitre ba ti nkankan ndana hu nyu ri na ");
INSERT INTO jid_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","niki bari ba la lu kri nda bla tre che nituma ndi ");
INSERT INTO jid_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ki wowu a sia bla ndi wawu ni zii hekali wa ba me ni wondi nda ni mi vi tra la me ri hama ni tindu ni wondi ");
INSERT INTO jid_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","nikima ngame bi tre ba nyumba ana hu nkon riri na ");
INSERT INTO jid_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ninkon prist a lu kri nimimba nda yesu ndi wuna he ni kpe wu sa bawu na? ni tutre wa bi nu shaida biyi basi bla nitume a? ");
INSERT INTO jid_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","nikima a kri gbangbi ndana sa na ninkon prist a la myeu ndi wuyi wu kristi vren u wa ba ti lulu zanzan niwua? ");
INSERT INTO jid_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","yesu a trendi ahi me ngame bi to vreninji si son ni wo korhi u gbengble nda si ye nimi klalu wu shulu ");
INSERT INTO jid_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","niki ninkon prist a yba nklon kpama nda tre ndi kila wa saidu u ngye gari? ");
INSERT INTO jid_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","bi wo tre wu kpande irji timeme kimbi bi to ni he? wawumba ba nyme ndi latrema a tsra du ba wuu ");
INSERT INTO jid_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","bari ba lu si junte ni vra nituma nda ni ka shishima ndani tsiwu nda hlawu ndi du nran tre e mrikondumba ba tsi ni ndawomba ");
INSERT INTO jid_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","niwa Bitrus a son ni meme ni ra koa ninrenwa ri wu tindu niko ninkon prist ");
INSERT INTO jid_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a to Bitrus si son si si zu isi ni yesu u Nazarat ");
INSERT INTO jid_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","a kpa tre ndi mina to na nina to tu kpewa wu tre a na wa a rhu hi ni kalhan e igbaa a tbu ");
INSERT INTO jid_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","vrenwa wu ndu ri a too ngari nda lu si bla ni biwa ba ki whi niki ndi iwayi hi rimba ");
INSERT INTO jid_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","a la kpa tron ngari nton fiime ka huki biwa ba ki nhan niki ba la tre ni Bitrus ndi ahi janji wu ri mba nitu wu ndi u Galilee e lpn nyu me kpanyeme nikima ");
INSERT INTO jid_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","niki a lusi yoban ndani shirhi ni kpama ndi mina to iguyi wa bisi tre nituma na ");
INSERT INTO jid_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","igba a la tbu nkpu u ha rhi du igba tbu nkpu ha wu shirhi kpatron ni me nkpu tra niwa a rhimren ni kima a ybo yi ");
INSERT INTO jid_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ni bwu ble frist bi nikon ba shubi ni bi nikon gbua u bi nha u tra rji ni yahudawa wa babi suronmua ba vu yesu lo nda njiu nda hi ba kau nno Bilatus ");
INSERT INTO jid_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus myeu awu yi u ehu Yahudawa? a sa ni wu andi u tre toki ");
INSERT INTO jid_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","frist bi nikon ba nhau ni kpi gbugbu wu ");
INSERT INTO jid_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatus a la mye u na hla na ka nche? to gbugbu tre wa ba ki nha wu ni tu mba ");
INSERT INTO jid_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","yesu ana la sa ni Bilatus ngana wa anno mamaki ");
INSERT INTO jid_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","to ni ntto u gan Bilatus a ta chi ndi bi la tre ri wa he troa chuwa indi wa ba kabre ni tu ma ");
INSERT INTO jid_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","u igu ni mbru bi la tre ba latre u wu ndi ");
INSERT INTO jid_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ijubu ndi ba ye niye Bilatus ndu tie ikpie waazi tie rji mu ");
INSERT INTO jid_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus ka sa bawu bi nyem ndu me kah chu yahudawa chuwo? ");
INSERT INTO jid_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","a to nda ni tu ngu mba baka vu yesu njiwu ");
INSERT INTO jid_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","amma nji frist ba ba con jbu ndi ba ndu ba yar gro ndu ba ka Barabbas mba cuwo ");
INSERT INTO jid_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatus a la mye mba ngarli a hi ngye mba tie ni chu Yahudawa? ");
INSERT INTO jid_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ba la gro ngali klowu ");
INSERT INTO jid_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatus mye ba a latre ngye a tie? u ba tutu yar gre clou ");
INSERT INTO jid_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus a son tie kpie a ba wa nda ka Barabbas cuwo ni ba wu a pua yesu tre rli nda kau nno ba kpa klo ");
INSERT INTO jid_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","soja ba bu nji nda hi ni tra u bla tre nda u yo soja ba wawuu kabi ");
INSERT INTO jid_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ba lo tuma ni pli u ma klo ntme wiwrli nda con con lo nha ");
INSERT INTO jid_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ba wlu nda ciu ndatre ndu rji ziu iclu yahudawa ");
INSERT INTO jid_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ba grji tsiu ni tu ni gbugban u con ma nda ju nte ta sur ba kuqu gbarju nda kudran ni kbu ma ");
INSERT INTO jid_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","sa ba chauya ba chu pii u tuma rju hi ni wrji wa ba hi kpam wua ");
INSERT INTO jid_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","indi ri siman u gbu siren sia ye rji gburi ba vu ni gbengble to ban kukron krossa ");
INSERT INTO jid_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","soja ba nji yesu hi ni wrji wa ba yo ndi golgota ");
INSERT INTO jid_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ba nno ma kabi ba mur wa a kama nda na soh na ");
INSERT INTO jid_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ba kpan wu nda vu klon ma rli nra ni kpa mba ");
INSERT INTO jid_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ba kpan u ni tu kukron ni ntton u tra ");
INSERT INTO jid_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ba nha ni ple kukron ni ikpie a ba nhaua ichu yaluda ");
INSERT INTO jid_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ba kpanwu ni bi ybi harli iri ni wo rli u ri ni wo kota ");
INSERT INTO jid_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","i wa yi ye tsar ni tre rji wa a hla ba bla kabi ni bi latre ");
INSERT INTO jid_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","biwa ba ka ki hia ba zren da ni whu tu nda ni tre yowa iwuwa u zii tra rji ni meu ni mi vi tra nra kpame ndi grji ni kakrona ");
INSERT INTO jid_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nji frist ni bi nha ba ba chauyaya ngame ni kpa mba da tre ");
INSERT INTO jid_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","a ndi a kpa bai cuwo amma nda na to kpa kpama cuwo na ");
INSERT INTO jid_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ndu kristi ichu israilawa ba grji ni gran kukron a ye meme zizanyi ndu ki to ndi kpa nyme ni wu bi wa ba kpan ba ni yesu ba hlo tre ni me ");
INSERT INTO jid_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ni ntton u tane ibwu ye kah gbu wawuu hi ni ntton u tia ");
INSERT INTO jid_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ni ntton u tia yesu ka yar yi gbagban me eloi eloi lama sabachthani? wa hi irji mu irji mu u tie he rli kame don? ");
INSERT INTO jid_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","bi wa ba kli wi riha kia ba wo lan tre ma nda tre din to ba a si Iliya ");
INSERT INTO jid_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","indi ri tsutsu ka yo rlikpanma ni ma waasa nda kason ni gbondo kpala nda kanno ndu soh igua tre din ki to ka Iliya ni ye njiu grji ");
INSERT INTO jid_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ni ki yesu ka yar yi gbangban me nda qu ");
INSERT INTO jid_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ipli u tra rjia ka yra tie harli rji ni tu mu grji hi kogboma ");
INSERT INTO jid_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","40","da jirmi wa kli nda si ya yesu a to ndi yesu qu ye to wa a tre din njanjimu igu yi ana vren rji imba bari ngame baki gbigbanmu nda kia yah vimi mba ana ba maryamu ba mag daliya maryamu u salomi ");
INSERT INTO jid_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","wa a he ni Galili ba hu nda ta tie ndu wu imba gbugbu u ngame ba huhi ni urshalima ");
INSERT INTO jid_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","wa yalu tiea don he u mlaki ivi wa baka rjo ri ni sabath ");
INSERT INTO jid_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu indi u Arimathiya ye ni ki ana ri ri bi lo chu ndi wa bata nno grima nda sia gben mulki rji avu sran nda shi ni Bilatus nda mye kmo yesu ");
INSERT INTO jid_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus tie sisri ndi yesu qu ayo jirme a nda wo ka yesu qu ");
INSERT INTO jid_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","da Bilatus a wo ni nyu jirmea ndi yesu qu ye a nno kmboa ni Yusufu ");
INSERT INTO jid_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu ana le plia ye a grji kumo ni grani kukrona nda lou ni pli nda nji he ka yo ni beh wa ana tita wa ba tsen mlatie a tru tita hra beh a ka nyu beha ");
INSERT INTO jid_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","maryamu ba mag daliya ni Maryamu iyi yosi ba to bubu wa ba rju yesu ");
INSERT INTO jid_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","niwa i vi u asabarchi a wuce Maryamu ba magadaliya mba salome ba ka nji izyi kpa ye nde ba gban ni yesu nikpa ");
INSERT INTO jid_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ni bwubwu ble ni vi mule u satia u ba hi ni beh ni nza hongan ");
INSERT INTO jid_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","u ba myen kpamba a di a nhan ni nyiu tita rju ni tawu ni yiu beh hia? ");
INSERT INTO jid_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","u ba nzu shishi ya na toh ba nyiu tita rju ye tita a ki kle ma gbenme ");
INSERT INTO jid_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","u ba luri ni mi na toh vren nze ri sur nklo kinkle son ni wo kori uba bwu yiu ");
INSERT INTO jid_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","wa hla ni bawu na bwu yiu na bi si wa yesu ba nazaraten wa ba giciye niwu alude n a na hei na ya ige bubu wa ba kah yo yi ");
INSERT INTO jid_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ama bika hi kpambi ni ha ni almajere ma nie Bitrus a hei koshishi si hi ni galilis ni mun bi toh nawa a hla ni yiua ");
INSERT INTO jid_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","u ba dorju ni mi beh ni wi likpa ni bwuyiu bana ya tre kpieri me ni kpambana nitu sisir ");
INSERT INTO jid_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","nta shime ni bwumble ni vi u mumlan u satia da guchi ye rju ni mary magadaliya na ju meme ibrji tar gban rju niwu ");
INSERT INTO jid_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","wa hi na kah bla nibi wa ba hei ni wua da katsira ba si ta mre da ni yi ");
INSERT INTO jid_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","i ba wo da hei ni rei u wawu toh ni shishima ama u bana kpa nyeme na ");
INSERT INTO jid_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","wa rju ni babwu ha mba ni kon rimu kan yada ba rju nigbua zren sihi kpamba ");
INSERT INTO jid_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ni ko ngo ki yesu lu rju ni wolon don ri uba si rila ni tu tebru wa pwa ba tre nitu wa bana kpanyemena da nsei tu da na kpanyemen ni biwa da toh shishi nishishi na hla ba hi wu a ndi alude na ");
INSERT INTO jid_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","a hla bawu ndu ba hi na hla tre ma ni ndi bi rgbungbulu ba kagon wawusu ");
INSERT INTO jid_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","indi wa a kpa nyeme na ndu ba yi batisma niwua ani nawo indi wa ana kpa nyemen na ani rilu ");
INSERT INTO jid_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ba toh tie bi yii ni biwa ba kpatre rji ba zu brji ni nde mu ba tre lme sama ");
INSERT INTO jid_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ba ya vuwam ni wo ana tie ba kpie na ko ba so meme gbugbulu ana tie ba kpie na ");
INSERT INTO jid_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","yesu tre kle ni ba wu uba ban hi ni shulu waka son ni wo ko ri irji ");
INSERT INTO jid_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","u baluri blatre rji kango gbungbulu a irji ni zo ba na kpanyeme ni tre mba nikpii wa a tre ba tie baa ");
INSERT INTO jid_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ndji gbubgu bana gucci tie ndu yongyegyere kpi bi andi a ye rju kri ndende ni mi mbu'a. ");
INSERT INTO jid_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Na-wa ba ka ba sru ni wo-mbu'a, rji ni biandi bana to ni shishi mba baba bi tindu lan tre-a. ");
INSERT INTO jid_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mi toh abi nimu nitu mi ban ikpi ba shle ya toh rji ni mumla, mba ni ni nha nitu mba gyegyere niwu Uchu Tiyofilos. ");
INSERT INTO jid_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ni dun toh, hamma ni sron ha ikpi andi bana tsro ye. ");
INSERT INTO jid_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ni vi khikle u-chu Herod, Ichu wu Judea, ni ntoh ima, Zakariya wu nhma ko Abijah ana Prist mba. U-wa ma eh'pu Haruna. ");
INSERT INTO jid_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hambawu bana bi tie sissri Irji ie suron mba ni zren mba abhi ni shishi ma. Bata hu lantre Bachi nda ni hu ikpi bi wandi a nha dun ba ti'a. ");
INSERT INTO jid_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bana he ni vivren wu ngrji mba na, Alisabatu anani ngrji na, u ba che hamba mba lonma. ");
INSERT INTO jid_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Inton Zakariya a ye ni dun kri ni shishi Irjin nda tie ndu Prist wa ndi chuu wu nclan ngrji ma a ku ni tu ma. ");
INSERT INTO jid_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ba hu njo ni chu Prist wandi a ni tie ndu ni mi-tra u Bachimbu, nda gon ton nitu mbru mba. ");
INSERT INTO jid_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ni-andi ahe ni mi, mbru ndiba ba ki ni rah nda si bre Irji mla ni nton wandi ton a si gon. ");
INSERT INTO jid_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A kri toh Maleka Irji rju kri ni wo mla wu bubu gon ton-a. ");
INSERT INTO jid_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ni-andi Zakariya ku shishi niwu, a kma tie lo'me i sissri a vuu. ");
INSERT INTO jid_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","I Maleka a hla niwu ndi, “Na klu sissri na, Zakariya, nitu ibre me a rhi ton. Iwame Alisabatu ni ngrji ivren'llon niwu. Wu yo ndema ndi Yohana. ");
INSERT INTO jid_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Isuron me ni si i wu ngyiri, u gbugbu ndi ba ngyiri ni ngrji ma'a. ");
INSERT INTO jid_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A nii khikle ndji ni shishi Bachi. Ana so ihi mba mma wandi a sen na ihi na, Ruhu tsartsar wu Irji ni he ni wu rji ni mi nne yima. ");
INSERT INTO jid_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gra ndji bi Israila ba kma hi ni Bachi Irji mba. ");
INSERT INTO jid_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ani hi ni shishi Bachi ni ruhu mba gbenbgle Elijah. Ani tie ki nda kma suron ba-tti hi nitu mmri mba, don bi ka-wo baka zren nimi to u bi zren bi - nda mla nkon tie ni Bachi, ndji wa ba mla zi niwu'a ");
INSERT INTO jid_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya a hla ni Maleka ndi, “Mi tie ni he ni toh kpe yi? Mi chiche ndi i se wamu ba bran gbagbanmu ye.” ");
INSERT INTO jid_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maleka kma sa wu da tre ndi, “ahi me Gabriel wandi ani kri ni fron Irji. A ton me du mi ye tre niwu, ndi mi nji lantre ndindi nji wu. ");
INSERT INTO jid_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mla wo! Wu son ni ngbangbi, wuna la tre na, se kpe wa mi hla niwu a wri. Ani toki nitu wuna kpa nyime ni lantre wandi mi hla wu na, ikpe wandi a ni wri ni tsra ni nton ma ");
INSERT INTO jid_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndji ba basiya gben Zakariya ndana rju na. Ba tie mamaki ni wu ton me nimi koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wa a rju ye niba, a tre wakran. Ba kri rhimmre ndi a to kpe ni mi koh Irji. A si tindu tsoro ba niwo, ama ndana tre na. ");
INSERT INTO jid_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ni-andi nton wu tindu ma a kle, a kma hi ni Kohma ");
INSERT INTO jid_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ni vi ba kii, iwama Alisabatu a hwrji-nne wu wha ton ndana du ndji du ba toh na. A tre ndi, ");
INSERT INTO jid_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ngye kpe wandi Bachi mu tie ni mu nda yame ni lo suron nda chu shan rju ni mu ni shishi ndji. ");
INSERT INTO jid_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ni wha wu tanne, Irji a ton Maleka Gabriel hi ni gbu Galilee wandi ba yo ndi Nazareth, ");
INSERT INTO jid_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","du hi ni Maryamu, ih'pu Dawuda, wandi ba na haa zi ni ndi ri ni nde Yusufu. Maryamu ana rhi he toh lilon ni son ma. ");
INSERT INTO jid_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A ye tre ni wu ndi, “Mi chiwu, wu wandi ba kpa nyime ni wu gra, Bachi he ni wu. ");
INSERT INTO jid_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Itre a kpau tsi shishi, wa kma rhimmre nitu bibi ichi wandi a chiwu'a ");
INSERT INTO jid_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maleka a hla ni wu “Na tie sissri na, Maryamu, Irji a kma yawu ni lo suron. ");
INSERT INTO jid_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ya yi, wu hwrji-nne ni ngrji vren. Wu yo ndema ndi Yesu. ");
INSERT INTO jid_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ani khikle ndji, ba yo vren khikle'a Bachi u shulu. Bachi Irji ni nuu tu chu bachi ma Dawuda. ");
INSERT INTO jid_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ani tie mulki wandi a na kle na nitu koh Yakubu, i ngbungblu wandi ani son nitu mba bana kle na. ");
INSERT INTO jid_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu a hla ni Maleka, ikpe yi ni tie ni he nda wrhu to tre me. Ime mi rhihe wu toh lilon ni son mu. ");
INSERT INTO jid_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maleka a sa niwu ndi, “ Ruhu Tsatsra ni ku ni tume i gbengble Irji wu shulu ni kasuu. Vren Tsatsra wandi wu ngrji ba yow ndi Vivren Irji. ");
INSERT INTO jid_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Toh, imlame Alisabatu a he ni nne vivren lilon ngame ni chichema. U wha ma wu tanne yi - wawu wandi bana tre ndi ana ngrji na. ");
INSERT INTO jid_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ekpe na ne wandi Irji na toh tie na.” ");
INSERT INTO jid_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu a tre ndi, “toh, Bachi mu, mi vren wa wu ndume. Tie ni mu tsra ni kpeu wu hla'a.” Maleka a lu hi kpama nda don me. ");
INSERT INTO jid_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maryamu a lu lunde ni vi baki nda sima hi ni gbu bi ko tu-ngblu ba, ni gbu wu Judea. ");
INSERT INTO jid_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A ka rhi ni koh Zakariya nda chi Alisabatu. ");
INSERT INTO jid_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ni wandi Alisabatu wo chi wu Maryamu'a, kpran vren wandi a he ni nnema a luza i Ruhu Tsatsra a lu rhi ni Alisabatu ");
INSERT INTO jid_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A lu ni khikle lan nda tre gbangban ndi “lulu he nitu me, ni mi mba, mba ni ibi wu mi nne me. ");
INSERT INTO jid_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nge tie ndu dun bachi mu dun ye ni me? ");
INSERT INTO jid_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ni wandi lan tre chi me a rhi ni nton mu, vi kpran vren wandi a he nimi nnemu a lu zah wu ngyiri. ");
INSERT INTO jid_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A tie lulu ni wu wandi a kpanyme ndi ikpi biwandi Bachi Irji a dun be blah niwu ba wrhu to ki. ");
INSERT INTO jid_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu a tre ndi “suron mu ni ngyiri ni Irji Bachi.” ");
INSERT INTO jid_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ie drimu ni ngyiri kpukpome ni Irji wandi a kpame chuwo. ");
INSERT INTO jid_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A kma iyanchi vivren wa wu tindu ma. Ya, Irji zizan ikba ndi kankan ba tie lulu nimu. ");
INSERT INTO jid_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wawuyi a tie khikle ndu nimu, indu ma hi tsatsra. ");
INSERT INTO jid_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lo suron ni wruhle ma ni ha ikba hi ni ikba wu bi andi ba klu sissri ma'a. ");
INSERT INTO jid_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A chu ngbengble ni ngba woma tsro, nda vra bi nzutu ni tu mre wu suron mba. ");
INSERT INTO jid_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A gbran mri bi tu chu grji ni bubu son mba, nda nzu biwandi bana he nitu kpe na lu. ");
INSERT INTO jid_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A juu bi iyon ni ikpi bi ndindi nda zu bi iwu du ba hi hamani kpe. ");
INSERT INTO jid_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A zo Israila, mri u ndu ma, ni duba rhimre nda wruhle ");
INSERT INTO jid_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(na wandi a tre niba timba) ni Ibrahim baba ih'pu ma kase kase. ");
INSERT INTO jid_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu ason mla u wha tra ni Alisabatu rhi nda kma hi ni koma. ");
INSERT INTO jid_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nton ngrji Alisabatu a tie, waa a ngrji vren ma, vren lon. ");
INSERT INTO jid_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","kpukpan son ma baba mlah ma ba wo khikle kpe ndi Bachi Irji tie, ni lo suron ma niwu, nda ngrji ni wu. ");
INSERT INTO jid_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A he niki, ni viwu tandra, ba ye bubu gyen mbru ni vivren'a. Ba ta zinde tima Zakariya niwu. ");
INSERT INTO jid_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Iyhima a sa bawu ndi, “Aian, nde ma nih Yohana.” ");
INSERT INTO jid_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba hla niwu ndi “bi na he ni mla mbi rhi ni nde mba na.” ");
INSERT INTO jid_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba tre ni wo ni tima ndi do hla nde wa ba yo vren'a. ");
INSERT INTO jid_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tima a mye duba nu igble wu nha, wa nha ndi, “ndema hi Yohana.” Ndji ba wawu mba ba tie sissri (mamaki). ");
INSERT INTO jid_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nhuma a kri bwu hari (immediately) i nl'pma a si, wa a tre nda ngyiri ni Irji. ");
INSERT INTO jid_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sissri a vu ndji bi wandi bana hye ba ba. Ba vu tre kpi bi yi zren ka gon ngblu ngbugblu Judea. ");
INSERT INTO jid_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wawu ndji biya ba wo'a, ba yo zi ni suron nda tre “i vren yi ni hye ni he?” Nitu woh Irji a he niwu. ");
INSERT INTO jid_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tima Zakariya, shu ni Ruhu tsatsra, hla ikpe andi ni he'a ");
INSERT INTO jid_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“nda tre ndi gbresan ni Bachi, Irji wu Israila, wawu yi a ye zo nda khle ndu kpa-chuwo ni ndji ma. ");
INSERT INTO jid_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A nzu njon kpata chuwo ni tawu ni koh ndji wu nduma Dawuda, ");
INSERT INTO jid_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","me andi a tre ni nhyu tsatsra anabi rhi ni sen. ");
INSERT INTO jid_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kpatachuwo rju ni wo bi yota ni shishi mba ni wo bi-andi ba kamba nita. ");
INSERT INTO jid_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ani tie toki nitu do tsro ta lo suron ma mba timbu, niki rhimre ni tsatsra yo nhyu, ");
INSERT INTO jid_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ni shirji ni trema ni Ibrahim, bachi mbu. ");
INSERT INTO jid_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A shirji ndi a ni nuta biwandi a chuta chuwo ni bi kamba nita, ikini tindu niwu hama ni sissri, ");
INSERT INTO jid_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ni tsatsra ti bi, ni shishima wawu ni vrevre mbu. ");
INSERT INTO jid_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A wu vivren ba yo'u ndi anabi wu Bachi Khikle ni shulu, wuhi kri ni shishi Bachi ni mla nkoma ti nda mla ndji tie ni ye ma, ");
INSERT INTO jid_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","nda nu ta to kpe wu kpachuwo ni ndji ma, ni kpa wruhle lahtre mba. ");
INSERT INTO jid_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ikpe ani he toki ni lo suron Irji mba, nitu kima nza Irji rji ni shulu ani ye zota, ");
INSERT INTO jid_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","do kpan ni bi wandi ba he ni bwu mba iwhu i qu. Ani tie kima nda yota ni nkon wu si. ");
INSERT INTO jid_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Vivren a lu gbron nda he ni sen kpa dri, ndaka son ni tsutsu miji gben vi wandi a rju kri ndende ni Israila. ");
INSERT INTO jid_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ni nton ri ni sen, Kaisar Agustus a yo doka ndu ba bla ndji bi gbungblu ba wawu. ");
INSERT INTO jid_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wa a mumlan bla kena, u kiri niyus na Gona umeme suriya. ");
INSERT INTO jid_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","U ko ba nha ba lu hi ni gbumba na ka nha inde ba. ");
INSERT INTO jid_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isuwu, me a lunde hi ni Galili; Ibgu Nazarat hi ni gbu Yahudiya, Igbu Dawuda, ni wa ba yo ni Batalami, nitu wa a rji ni koh nan hi mlan Dawuda. ");
INSERT INTO jid_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ahi nha nde ma ba Maryamu wa a nna'u wa ahe nne. ");
INSERT INTO jid_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","U ba rhi he niki ri u inton ngrji vren ma ye. ");
INSERT INTO jid_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","waa ngrji vren llon, nna nye'u ni guglo ngbanja nklon na nban ka ka wu yo ni mi nju yawo, nitu wa mikoh ana he wa ba ka yo na, ba bi tsri mu ni gbu'a. ");
INSERT INTO jid_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bi krju ntma bi wa ba son in klan kima na ni ya ba ni chu ba he. ");
INSERT INTO jid_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","U Maleka Irji a rju ni bawu u kpan u rji ka grji kah ba, u ba ka nkbo sissri ");
INSERT INTO jid_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","U Maleka kah hla ni bawu, “ndu ba na tie sissrina, a ndi wawu nji tre ndindi ma ye wa ni yo ndi wawu ndu ba ngyiri. ");
INSERT INTO jid_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Luwa ba ngrji Macheto ni gbu Dauda, Inde Kristi Bachi! ");
INSERT INTO jid_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bi yi ba alama wa ba tsro yi'a: Bi toh kpran vren ba yo'u nimi ikpi a kakru ni nju yawo.” ");
INSERT INTO jid_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ni yiu riro me, gbugbu ndji ni shulu ni Maleku ba gbre Irji san na ni tre andi, ");
INSERT INTO jid_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Khikle ruron hi u Irji ni shulu, u dun si he ni ngbungblu ni ba ndji wa suron Irji ku si ni ba.” ");
INSERT INTO jid_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","U Maleka ba kma hi kpamba ni shulu, u bi krju ntma ba tre ni kpamba ndi, “ki hi zizan ni Batalami ndi toh ikpe yi wa a tie'a, wa Irji dun ta ki toh.” ");
INSERT INTO jid_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","U ba zren gbagbla me hi na ka toh Maryamu mba Isuwu ni vuvren wa ba ka yo ni nju'a ");
INSERT INTO jid_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","U wa ba toh'u a, ba bla hla kpie wa ba wo nitu vren'a. ");
INSERT INTO jid_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wawu mba wu biwa ba wo tre Maleka ba tie sissri. ");
INSERT INTO jid_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryamu son si rhimre itre wa a wo ba wawu na nji ni suron ma. ");
INSERT INTO jid_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","I gu u krju ntma kma hi na ni ngyiri na ni gbre shi san ni kpie wa ba wo na ka toh na wa ba hla ni bawu'a. ");
INSERT INTO jid_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ni klekle ivi u tandra ba gen mbru niwu, na zi nde ma ni Yesu, inde wa Maleka zi niwu wa ri he ni mi nne yima'a ri ba ka ngrji'u. ");
INSERT INTO jid_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Uvi tsrakake mba a ke ni doka Musa, Isuwu mba Maryamu ba nji'u hi ni koh Irji ni Urushelima ndu ba nji'u hi ni shishi Bachi. ");
INSERT INTO jid_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ni wa ba nha nha ni doka Irji ye'a, Ivren lon wa ba ngrji'a ba nji'u hi no Irji. ");
INSERT INTO jid_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","U ba no hadaya u Ingyu hari ko Tatabara hari, ni ya nda doka Irji a hla. ");
INSERT INTO jid_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ni Wurishelima, igu ri a he niki ba yo'wu Simion, wa nda a he khriki nani tie ndindi me. Na ni yo shishi u lo suron ni ndji bi Isrela, u Ruhu Irji he ni wu. ");
INSERT INTO jid_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","U nda hla niwu ye nda a na qu na, ama se a ni toh Bachi Kristi. ");
INSERT INTO jid_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ruhu Irji a nji'u Simion hi ni tra u bre Bachi, wa ba tie vuvren nhan nhan'n mba Yesu, ni ndu ba tie kpe wa doka tre Irji hla. ");
INSERT INTO jid_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","U Simion a krju nba rji na ngyiri ni Irji na tre. ");
INSERT INTO jid_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","I wu wa uhe ni ko ge u ka ndu gran mehi piyan me ni kpe wa wu tre. ");
INSERT INTO jid_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ni kpa chu wa me klan mi toh njanji tre, ");
INSERT INTO jid_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ni wa u mlan tie ni ngbugbu lu ba wawu. ");
INSERT INTO jid_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I nkpa wa ani tro ba inko mea ni kuma no ni nko Isrela. ");
INSERT INTO jid_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ba iyima mba ittima ba tie sissri (mamaki) ikpe wa ba wo ba tre nitu ma. ");
INSERT INTO jid_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","U Simion a tie lulu yo ni bawu nda hla ni Maryamu iyima ndi, “U to, Vivren yi, wawu yi ni dun bari dun ba joku, bari gbugbu ba lunde ni mi Isrela, wa ani tsro gban u wa indji ba kamba - ");
INSERT INTO jid_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ni dun iwen ndu kpireu dri na no mre ndu wa ani nharan mi suron ndji wawu. ");
INSERT INTO jid_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","U Anabi rhi, ahi iwa, ba yo'u ni Hanatu. Ahi vren Fanuwel rji nimi L'be u Asha. Wa a che kpokpome. A sohn ni lon ma ise tangban niwa a gran ni vren wa, ");
INSERT INTO jid_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","u lon ma a qu wa ka son ni kbo ise wulon inkyu tandra ni nza (84). Ani hi ni nko bre Irji chachu chachu ni chu mba ni mble ani bre Irji ni vu hlan ma. ");
INSERT INTO jid_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ni ki me, a ngyiri ni Irji, na tetra vren ni ndi ba wa wu bi wa ba si gben kpachuwo (fansar) Wurishelima. ");
INSERT INTO jid_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ni wa ndji ba kle ko nge wawu na wa ndi bla tre Irji hla'a, u ba ka kma hi ni Galili ni gbumba Nazaret. ");
INSERT INTO jid_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ivren sen ni tie ninkon u mre ma ndindi ni babran kpukpome, ndindi (Alheri) u Irji he ni wu. ");
INSERT INTO jid_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ba tie ma ba hi Wurishelima ko wa ni ise ni ngan (Idin Ketarewa). ");
INSERT INTO jid_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wa-a tie si wulon don ha, u ba rji hi ya da ba hi ni Idin. ");
INSERT INTO jid_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka ba kle tie ro'a na kma si hi, u vren'a Yesu, wa zu kukri ni kogon ri ni mi Wurishelima a na ni toh ba iyima na. ");
INSERT INTO jid_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba zren ya ndi a he nimi ba ndji wa ba si hi baba'a, u ba zren u vi rhi (1). Nda lu ni wa'u nimi ba mlan mba ni kpukpan mba. ");
INSERT INTO jid_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","U wa ba na to'u na, ba kma hi si wa'u ni Wurishelima. ");
INSERT INTO jid_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","U ni vi u tra mba, ba to'u nimi koh Irji, a son ni tsutsu ba bi tsro, asi sren ton si wo ba nda si mye ba. ");
INSERT INTO jid_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Biwa basi wo wu wawumba ba tie sissri (mamaki) ni toh tre wa ahe niwu. ");
INSERT INTO jid_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","U ba ka toh, na tie sissri iyima myen inge ba sa u tie nna ki ni ta wu bu tie me, kisi wa wu, ni suron nfu. ");
INSERT INTO jid_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A mye ba, “bi si wa me ni nge, bina toh ndi abi dun mi son ni koh tti mu na?” ");
INSERT INTO jid_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","U bana toh tu tre wa a tre ni ba na, ");
INSERT INTO jid_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wa kma huba hi ni koh ni Nazarat na ni wo tre mba. U iyi ma a nji kpe wa atie gbangba nimi suron ma wawu. ");
INSERT INTO jid_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","U Yesu gburon ni hon ni tiya ni toh tre ni tagoma, Irji mba ni ndji me. ");
INSERT INTO jid_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ni mi ise u tso don tra wa Tiberia Caesar - Chu, u, Pontiyus Bilatus ana gomna Judiya, Hiridus ka Chu ni Galili, vayima Filibus ka chu ni Ituriyada Tarakunitas, mba Lasaniyas ana Chu ni Abaliya. ");
INSERT INTO jid_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ni nton wa Hanana ba kayafa bana bi ninkoh bitun tre Irji kaye ni Yahaya vren Zakariya ni miji. ");
INSERT INTO jid_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sei ka zren kagon gbugbulu mi yie'u nei u urdu, dani hla tre Irji ni bawu, a yo'u ba duba ye kpa Irji nda dun ba sukpa ni ba wu, duba wru lah tre mba hle ni bawu. ");
INSERT INTO jid_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na wa ba na nha nvunvu u tre Anabi Ishaya ndi llan di ri si yo ni miji, mlan koh Bachi tie dun koh ma hi yreyre. ");
INSERT INTO jid_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ko san ngbulu ba shu, u ngbulu ba ba gble tita ba kma ti fime, u nkoh bi tie memme ba kma bi ba ba shu, ni ngbulu baba tita ba ba yra ba nda kma me nkoh ni bubu biwa be gblegble me'a. ");
INSERT INTO jid_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","U bi he nimi kpa ba to Ceto u Irji. ");
INSERT INTO jid_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sai Yohana a hla ni gbugbu ndji wa ba si ye dun sukpa bawu'a. Yohana yo ba ndi “biyi mri iwan, anha hla ni yiwu dun yi tsutsu ni nfu wa ani ye ni yiwu'a?” ");
INSERT INTO jid_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nitu kii, kma tie klo kunkro wa ndi ba bre dun ba wru lla tre hle bawu dana ta tre ni kpamba ndi ki he ni Ibrahim wa a iti mbu, mi hla niwu Irji hei ni gbengble wa ani zu titi biyi kma tie mri ni Ibrahim rji ni tita bi yi. ");
INSERT INTO jid_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ko zizan ba mlan gla tie nitu nja bi ba kunkro. U wawu kunkro bi wandi bana klo bi na ba gen ba nda vu ba sru ni lu.” ");
INSERT INTO jid_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","U gbugbu ndji baki mye'u ndi, “Zizan ki tie ni he?” ");
INSERT INTO jid_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A kasa nda tre “Indji wandi a he ni nklon ha, ka ban rhi ni ndji wandi ana he ni rhi na, u ndji wa ahe ni lah ka tie naki ngame. ");
INSERT INTO jid_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bi kpa ban ba ye du ba sukpa ni bawu, nda tre, “Ndji-u-tsro, ki tie ni he?” ");
INSERT INTO jid_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A hla ni bawu ndi, “Nata kpa inklen zan kpe wandi ba tre dun yi kpa na.” ");
INSERT INTO jid_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sojoji bari ngame ba mye, ndi, “U kita na? Ki tie ni he?” A bla hla ni bawu, “Na kpa nkleh niwo njo ni gbengble na, ndi na tie ce ti ndrjo na. Nji kpe-andi bi u mbi dun mla yi.” ");
INSERT INTO jid_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Zizan wa ba ndji ba si ya nkoh ye u Kristi'a, wawu mba ba si rhimre ni suron mba nitu Yohana, ko wawu mba hi Kristi'a. ");
INSERT INTO jid_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana a kasa ni bawu nda tre ndi, “Ime mi si sukpa ni yiwu ni mma, u ndji waa si ye ni koshi mu, a zan me ni gbengble, u mina tsra wa mi sie rjirji lagban u zama na. Wawu ni sukpa ni yiwu ni Ruhu Tsratsra ni lu. ");
INSERT INTO jid_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ahei ni mumu ni wo ma wandi ani tie ndu niwu nda zen memme bie nda ka waa bi zi nimi iwron. U ani gon biwa ba tie meme'a ni lu wa ana y'bi na.” ");
INSERT INTO jid_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ni mi tsro mba Yohana a hla tre ndindi ni ndji ba. ");
INSERT INTO jid_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hiridus wa ana Chu, a son gran wa vayi ma Hiridiya, ni mbru meme kpie wa Hiridus azi tie'a, ");
INSERT INTO jid_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","a ka biyi suru nhaa, ndi a ka Yohana tro ni brusuna. ");
INSERT INTO jid_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Inton wa ba sukpa ba ndji wawu, Yesu me ba sukpa'a niwu ngame, wa asi he ni mi bre wa ka toh shulu bu'u, ");
INSERT INTO jid_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","wa toh Ruhu Tsatsar ka grji ye son nitu ma na ngyu, wa ka wo lan Irji ni shu, “Iwu yi wu vren mu wandi isuron mu a kpa wu. Suron mu ku si ni wu.” ");
INSERT INTO jid_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ahe ni sei wlon nkpu tra (30) nda vu tie ndu Irji. Nimi kpa, Yesu hi vren Isuwu wa ba yo tima ndi Heli, ");
INSERT INTO jid_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ivren Matat, ivren u Levi, ivren u Melki, ivren u janai, ivrn u Isuwu. ");
INSERT INTO jid_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isuwu ana vren Mattatiyas, ivren Amos, Ivren Nahum, ivren Esli, ivren Naggai, ");
INSERT INTO jid_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ivren u Maat, ivren u Mattatiyas, ivren u Semein, ivren u Josech, ivren u Joda. ");
INSERT INTO jid_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ana vren u Jowanan, ivren u Resa, ivren u Zerubabel, ivren u Salatiyel, ivren u Neri, ");
INSERT INTO jid_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ivren u Melki, ivren u Addi, ivren u Cosam, ivren u Elmadam, ivren u Er, ");
INSERT INTO jid_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ivren u Joshuwa, ivren u Eliyeza, ivren u Jorim, ivren u Mattat, ivren u Levi. ");
INSERT INTO jid_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ana vren Simiyon, ivren Judah, ivren Isuwu, ivren Jonam, ivren Eliakim, ");
INSERT INTO jid_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ivren Meliya, ivren Menna, ivren Mattata, ivren Natan, ivren Dawuda, ");
INSERT INTO jid_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ivren Jessi, ivren Obed, ivren Bowaz, ivren Salmon, ivren Nahshon. ");
INSERT INTO jid_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon ana vren Amminadab, ivren Admin, ivren Arni, ivren Hezron, ivren Perez, ivren Judah, ");
INSERT INTO jid_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ivren Yakubu, ivren Isuwa, ivren Ibrahim, ivren Terah, ivren Nahor, ");
INSERT INTO jid_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ivren Serug, ivren Riyu, ivren Peleg, ivren Eba, ivren Shelah. ");
INSERT INTO jid_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah ana vren Cayinan, ivren Arfakza, ivren Shem, ivren Noah, ivren Lamech, ");
INSERT INTO jid_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ivren Metuselah, ivren Enok, ivren Jared ivren Mahalaleel, ivren Cainan, ");
INSERT INTO jid_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ivren Enos, ivren Seit, ivren Damu, Ivren Irji. ");
INSERT INTO jid_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","U Yesu he shu ni Ruhu tsatsar, a kma ye rji ni nne Urdu'a, Ruhu nji wu hi ni miji ");
INSERT INTO jid_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","niki a tie vi wlon nkpu nza ka meme brji ka tsra wu. Ni nton ki ana rhi kpe na, u ni klekle'a iyon vu babran. ");
INSERT INTO jid_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibrji a to naki nda mye “wuta tre wu vren Irji, kma tita yi tie bredi.” ");
INSERT INTO jid_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu a sa niwu ndi, “itre Irji a hla ndi, ndji na rhi bredi mba nda son na.” ");
INSERT INTO jid_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ibrji toh naki nda nji Yesu hi ni tu ngblu nda tsro wu wawu ngbungblu'a nimi fime nton'a. ");
INSERT INTO jid_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wu brji hla ni wu ndi, “Mi nowu Chu ni konge bi ndindi, don ba ka ba ne, u mi ya ka no ndji wa mi son'a. ");
INSERT INTO jid_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wu ta kuqu mgbarju ndi gbre san mu, ba kma tie u me.” ");
INSERT INTO jid_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","U Yesu kpa sa'wu nda hla ndi, “Itre Irji hla ndi, 'Wu gbre san Bachi me kankrji ma, ndi hu wawu yi.'” ");
INSERT INTO jid_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibrji a nji Yesu hi nimi Wurishelima nda yo'wu ni tu nkan u koh Irji'a, nda hla niwu ndi, “Wuti hi vren Irji'a, za grji rji ni wayi'a. ");
INSERT INTO jid_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Itre Irji hla ndi, 'Irji ni dun Maleku ma njiwu, na dun ba hra'wu, ");
INSERT INTO jid_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","U, 'Ba nzu wu nji rji ni wo mba, don dun wu na wru za ni tita na.'” ");
INSERT INTO jid_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a hla wu “Wuna tsra Irji Bachi me to na.” ");
INSERT INTO jid_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibrji a tsra Yesu nda don wu me sai ton ri, nda hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Naki, Yesu a kma hi ni Galili nizo 'Ruhu Maitsarki.' Itre ma a zren ni gbungblu kagon ni wre ki. ");
INSERT INTO jid_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nikglaki Yesu fara tsro ba terma. ni tra ma u ndi wawu mba ka gbre san. ");
INSERT INTO jid_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A wru niki nda ye ni Nazarat, ni wrji wa ba raya ni wu yada Asaba ri ni tra u beri ni viwu wu bre, nda wlunde ni bla nvunvu u tre ma. ");
INSERT INTO jid_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nvunvu wa bi tie ndu Irji wu Annebi Ishaya. Abwu nda bla nvunvu a nda to bubu ba nha tre'a, ");
INSERT INTO jid_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ruhu Irji he niwu me, wawugblegben mu a ton me ndi me hi hla tre ndindi ni bi ya.”A ton me nda ne gbengble ma dun mi hi tre ni biwa ba hei ni lo ndi cu ba cuwo, di bwu shishi ni bi fei, ndi kpa bi wa ba myen ba, ");
INSERT INTO jid_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dun mi hi hla 'nton' wa Bachi kpa ny'em nita.” ");
INSERT INTO jid_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A ka nvunvu ka no ndi wa ani gri ni wu'a nda kuson. Shishi ko nha ni tra Irji'a kma hi ni wu. ");
INSERT INTO jid_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A wlunde bubbu terniba wu, “Luwa itre Bachi, ri gregreme ni nton mbi.” ");
INSERT INTO jid_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko nha niki tretre wubi ma niwu nda tie sissri domin kikle tre wa to rju ni nu ma u ba mie. “Wayi ana viri Isuwu nan?” ");
INSERT INTO jid_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A tre ni bawu, “a njanji bi tre ni shap-shap nimu, 'bi no mwu, bana si no kpa mbi si ki. Kpe wa wu tie ni Kapanawun, tie naki ni gbume.'” ");
INSERT INTO jid_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ama a tre ni bawu, “Njanji mu me hla ni yiwu, ba ndji wa ani tie ndu Irji u baka kpa'wu ni gbuma. ");
INSERT INTO jid_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Njanji mu mi hla ni yiwu, mba bi ya ba ba ni Israila ni nton Ilisha, ni nton wa shulu a kaka ni bwu, hra sei trani wha tanne, meme yon a ye ni gbu wawu. ");
INSERT INTO jid_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bana ton Elia hi ni gburi na Zarephat ni Sidon wa iwa ri wu kpla ni son ki. ");
INSERT INTO jid_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wu bi chong-rju bahe ni Isrela suse ni me Elisha Annebi du ba wa kpari cuwo se Naaman wu he Syria. ");
INSERT INTO jid_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Du indji ba ni mi tra wu Irji ba tie nfu ni ba wo'a. ");
INSERT INTO jid_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba wlu ni nfu nda gbi nda ni mi gbuu nda kji he ni tu ngblu ri wa ba meh Komba ni tu ma, ba son ba tru taga rhi ni tu ngblu'a. ");
INSERT INTO jid_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","A ri zu ni tsutsu mba bana tona wa a hi ni buburi. ");
INSERT INTO jid_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ziza'a ni gbuyi a grji hi ni Kapanawum ni gburi, ni Galili ndani tsro ba ni vi wu cacu wa (asabat) bana tindu na. ");
INSERT INTO jid_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ba tie nfu niwu ni tre wani tre nibawu, u yi sa. ");
INSERT INTO jid_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nimi tra wu bre Irji indiri he ni meme ruhu ibrji, ayi gbangban me, ");
INSERT INTO jid_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A nge hada wu ni ta Yesu u Nazarat wu ye wuta mu? Me to kowu nha, vren Irji wu tie zren geger.” ");
INSERT INTO jid_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu bwu shishi ni meme ruhu nda tre, “Na bu nyu ndi tre na! rju ni kpama” Meme brji a riga da ban taga ni memeye ndatsutsu ndi ba meme ruhu brji a rju ni kpama, dana tie kpe na. ");
INSERT INTO jid_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naki indi batoh kpe wu mamaki nda kamba nda ni tre nituma, ko nha ni kpama, “Nda tre a wani iri tre mu naki? A gbi ton ni meme ruhu'a dun rju nda kagu'a cuwo, wa he toki. ");
INSERT INTO jid_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Itre ma atsra ni ko ni ntseyi ni klamba. ");
INSERT INTO jid_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","NambaYesu a bri tra wu bre niki nda hi nikoh Bitrus, ni nton ki iyi wama ana he ni sikpa nadon zazabi a vu, indi ba bre dun zoba ni nde mako ani wlunde. ");
INSERT INTO jid_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu aki ni kotuma nda gboshishi ni meme brji nda zu zazabi du bri niwu; ba wu ton wa he naki niwu ana wu nton a dalu fara sru biri ni wuh. ");
INSERT INTO jid_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Inton wa Irji nihe qu, indi gbugbu wu ba mmri vayi mba niye ni Yesu dun noba sikpa ni lulo iri-iri. Bari a sawo ni kpamba megyen baka fe sikpamba. ");
INSERT INTO jid_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Meme ruhu gbugbuu ba rju ni kpamba, bari bayi nda tre “Wu vren Irji” Yesu a gbonshishi ni meme ruhu ba nda zu ba dubana tre na don ba to ndi wawuyi Kristi ");
INSERT INTO jid_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ka mble kpan, waa rju hi bubu wa ba indji gbugbuu ba wawuyi nda to ni bubuki. Bana kpa nhime du kaba don na. ");
INSERT INTO jid_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","An hla ni bawu ndi wawu nison da cigaba ni bla tre Irji ni gbu bari, domin a hi kpa wa ba ton me ye ni wayi'a. ");
INSERT INTO jid_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naki nda cigaba ni noba tre Irji ni du Irji koni ntseyi ni kla Judia. ");
INSERT INTO jid_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ba he u gbugbu ndji ba ye ka Yesu ndi ba wo tre Irji, u wa k'li ni nyu kikle ma teku Janisaret. ");
INSERT INTO jid_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A toh mmri jirgi harhi bari ba zi ba ni nyu ma. Bi vu lambe'a ba rju kaki ngla rjirji u vu lambe'a. ");
INSERT INTO jid_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ari mi jirgi ri wa a u Siman nda hla wu ndu tru rju ma ye gban me ni kora. A kuson nimi nda tsro ndji ba tre Irji ni jirgi'a. ");
INSERT INTO jid_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Da a hla kle bawu a tre ni Siman, “Nji jirgi'a hi mima ndi kata hi ni honlon ma.” ");
INSERT INTO jid_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Siman kasa wu nda tre, “Tie koh mu, ki tie ya kle cu'a ndi na vu ko pke na, amma ni wa u tre'a mi kayo.” ");
INSERT INTO jid_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Da ba tie to wa a hla, ba vu lambebabran u rjirji u vu lambe'a ti su. ");
INSERT INTO jid_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mlen baka tie wo ni mbru mba nimi jirgi rima ndu ba ye zo ba. Ba ye nda vu lambe shu ni jirgi harli ba u jirgi ba bata grji hi nci ma. ");
INSERT INTO jid_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Amma Siman Bitrus, da'a to a he toyi, wa gbru ku ni Yesu ngbarju, nda tre hi don me, Bachi, me ndji u la tre. ");
INSERT INTO jid_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A tie sissri, wawu ni biwa bana he niwu, don gbugbu lambe wa ba vu'a. ");
INSERT INTO jid_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ba Yakubu mba Yohana imri Zabadi, bana kpukpan Siman. Yesu a hla ni Siman, na klu sissri na, don rji ni zizanyi hi ko shishi, u ta vu ndji. ");
INSERT INTO jid_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Da ba nji jirgi ba ye ni ra, ba ka kpi mba don wawu nda huu. ");
INSERT INTO jid_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ba zihe u wa he ni gburi, indji ri u lilo kpurju a he ni ki. Da a toh Yesu, a tie gbru kugru ni shishi nda bre Yesu nda tre “Bachi, u tie kpanyime u toh kpa me tie ndindi. ");
INSERT INTO jid_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu n'me wo ma ka gbire nda tre, “Mi nhime. Kpa den.” Gbla me lilo ka rju donwu. ");
INSERT INTO jid_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Amma ndu na hla dio ti na nda hla wu, “Hi kpame ndi hi tsro tume ni Pirist ndi nno hadaya u wa ba tsarkake wu'a na wa dokaMusa tre, ndu sheda bawu.” ");
INSERT INTO jid_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amma itre ma vra shu hi gbugbanmu u gbugbu ndji baka nji kamba ye wo'u babu tsuro nda den bi lilo. ");
INSERT INTO jid_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amma ana k'ma hi miji nda bre Irji. ");
INSERT INTO jid_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aye ni viri aka si tsro, u farisawa ni bi tsro Ataurat ba ye rji ni mmri gbu bi Galili ni Yahudiya u Wurishelima ba ki ni kii. Ngbengble Bachi ndu den a he ni wu. ");
INSERT INTO jid_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Indji bari baka ban indji wa a qu kpa ni ta ba nda ye, ba wa nkoh u nji rihi hama wa ba nji hi zi ni k'bu Yesu. ");
INSERT INTO jid_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Don ikpe ndi wa ba he'a, ba to me nda hon ni tu tra nda grji wu hi ni meme zu ni ndo a ri ni tsutsu ndji ni ko shishi Yesu. ");
INSERT INTO jid_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ni toh bangaskiya mba, Yesu tre, “Iwu ndji, ba wru la tre me hlega wu.” ");
INSERT INTO jid_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bi nha ni Farisawa baka wlu mye nd tre, “Ahi nha mu si tre la tre ba? Ahi nha ni wru latre ndji hle wu hamma ni Irji kima. ");
INSERT INTO jid_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amma Yesu a toh mre dri mba nda sa bawu, “A ngyeri ti rhi u bi mye kpame kpe yi ni suron? ");
INSERT INTO jid_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A rime na ti di tre'u na? 'Ba wru latre me hle' 'wu ka wlunde ndi zren?' ");
INSERT INTO jid_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amma ndu yi to ndi vivren ndjiahe ni gbengble ni ngbungblu u wru latre hle, a hla ni ndji u qu kpa- me hla wu wlunde, ban tabli me ndi hi koh.'” ");
INSERT INTO jid_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A ti wru wlunde ni shishi mba nda ban tabli wa ana kru ni tuma. A vu gon hi kpama ni koh ma, nda ni gbre Irji san. ");
INSERT INTO jid_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko nha a tie sissri nda gbre Irji San. Sissri shu bawu suron u ba tre, “Ki toh ikpi wa ba nna gbengble tre. ");
INSERT INTO jid_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ni wa a kle'a, Yesu a rju niki naka toh indji u kpa haraji wa indema hi Lawi, son ni mi bru u kpa haraji. A tre ni wu, “Hu me.” ");
INSERT INTO jid_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi a wlu nda hu nda ka kpi ma wawuu don. ");
INSERT INTO jid_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi hi ka tie ngan ni Yesu ni koh ma. Bi kpa haraji ba ka gbugbu niki ni ndi bari wa ba ka rhi biri ni tebru riri ni Yesu. ");
INSERT INTO jid_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amma Farisawa ni bi nha ba renyu ni mri koh ma nda, Ingye sa bi ki rhi ndi ni so ni bi kpa haraji ni bi latre bayi? ");
INSERT INTO jid_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu sa bawu, “Indji wa ba he piyan me bana du'u den na, sai bi wa ba lo'a. ");
INSERT INTO jid_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi na ye yo bi ndindi na amma mi ye ni bi latre ndu kpa tre Irji. ");
INSERT INTO jid_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ba tre wu, mri ko Yohana ba zan son hlan ma ni bre Irji, u mri koh Farisawa ngame. Amma mri koh me ba rhi nda ni so.” ");
INSERT INTO jid_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu aka tre ni ba, “Ahi ndji rime ni yo kpukpan iwa sa vu nyu u iwasa rhi he ni ba rhi? ");
INSERT INTO jid_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amma ivi ni ye wa ba ban iwasa'a hi nda ka ba don u ni nton ki ba vu nyu. ");
INSERT INTO jid_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu a tre mba ngaoli ni misali. “Bana nha pli sama ka mla wran k'mo mana. Ani ta tie toki, ani y'ba pli sa, u plisa na k'li niwu k'mo'a na. ");
INSERT INTO jid_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ba ndi wa ani wine sama ni mi cice imbu - ntan. Ini ta tie toki u wine sa ani yra mbu'a u wine ka kuhle, u imbu - ntan ni tie me. ");
INSERT INTO jid_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amma wine sama ba suru ni mi mbu-ntan sama. ");
INSERT INTO jid_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Indji wa'a so wine rji mi cice imbu-ntan ani son so don ani tre wine k'mo'a abi zan. ");
INSERT INTO jid_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A he ni vi u Sabat u Yesu si zu ni rju kpu u mrli ko ma baka wro wlo kpu'a won ni wo mba, nda tan. ");
INSERT INTO jid_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amma Farisawa ba ri ba tre, “Ani tu ngye rli bi ki tie kpie'a bana nyme ndu ba tie'u ni Sabat na?” ");
INSERT INTO jid_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu, ni tre ma, a kasa bawu, “Bi na kra kpie'a Dauda ni lilon bi wa ba he ni wu ba tie'a na? ");
INSERT INTO jid_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A ri ni tra Irji nda ban bredi wa ba ka zi, tan nda nno ndji wa ba he ni wu'a tan ngame, wandi a na he ni tu nkon na, don ana Prist nkankle ba tan.” ");
INSERT INTO jid_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Niki a hla bawu, “Vuvren ndi a baci u Sabat.” ");
INSERT INTO jid_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ba he u Sabat ri la ye, Yesu ka hi tsro ba ni tra Irji. Indi ri he ki nda so wo. ");
INSERT INTO jid_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bi nha ni Farisawa ba yo shishi nda to ka ani den dio ni vi u sabat, don ndu ba renyu niwu. ");
INSERT INTO jid_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amma wa'a to dri mba nda tre ni indi u son wo'a, “Wlunde ye kukru ni tsutsu ndi ni wa.” Igu u soh wo a wlu hi ka kri ni ki. ");
INSERT INTO jid_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu tre ni ba, “Mi mye yi, Ahe tu nkon ndu ba tie zizi ka meme ni Sabat, ndu ba n'ra rai kpa ka ndu ba kpa tie meme?” ");
INSERT INTO jid_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Niki yi, a ya ba kagon wawu'u nda hla ni guwa, “N'me wo me rju ra.” A tie toki u wo'a ka tie ndindi. ");
INSERT INTO jid_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amma ba vra nfu nda tre ni kpamba ko ba tie Yesu ni he. ");
INSERT INTO jid_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ba zi he wa ka ye hon hi ngblu nda ka bre Irji. A ban Chu'a wawu-u bre Irji. ");
INSERT INTO jid_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wa imble nhra, a yo mri koh ma hi kpama nda ju wlon don ha rji mi mba, a yo ba ndi Mazani. ");
INSERT INTO jid_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ba nde Mazani ana ba Siman ( wa a hi Bitrus ngame'a) u vayi ma Andarawus, Yakubu, Yohana, Filibus, Batalomiyu, ");
INSERT INTO jid_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Toma, Yakubu ivren Alfaus, Siman wa ba yo Zilot, ");
INSERT INTO jid_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuda ivren Yakubu ni Yahuda Iskaroti, wa a ye le wu'a. ");
INSERT INTO jid_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu a grji ngblu'a baba hi ka kri ni meme ni kpentren ndi wa ba mri koh ma u ni gbugbu ndji wa ba rji ni Yahudiya ni Wurushelima ni bi nyu kikle nne u Taya mba Sidon. ");
INSERT INTO jid_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba ye ndi wa wo Yesu nda ndu den lilo mba ngame. Indji wa ba zi tiya ni wo brji'a ba kpa den. ");
INSERT INTO jid_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ko nha ni j'bu ndi ba n'ra kon u kpre don gbengblen u den si'a rju rji ni wu, u wa a den ndji mba wawu'u. ");
INSERT INTO jid_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A kaya mri koh ma ba nda tre, “Bi hi bi lulu, biyi bi ya, don mulki Irji a hi u mbi. ");
INSERT INTO jid_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bi hi bi lulu biyi bi tie yon zizan'a, don bi wrji. Bi hi bi lulu biyi wa bi yi zizan'a, don bi nza. ");
INSERT INTO jid_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bi hi bi lulu niwa indji bata kran yi, u idan ba ba ya'yi hlega nda mre yi nda kamba ni nde mbi a nda u brji, nitu Ivren Irji. ");
INSERT INTO jid_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ngyri ni vi ki ndi briku don ba han ye kikle di ni shulu, e ba Bachi mba ba tie bi kpie ki ni Anabawa ba. ");
INSERT INTO jid_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amma iya mbi bi woh, biyi wa bi kpa si mbi ye. ");
INSERT INTO jid_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iya mbi bi hi wa bi wrji zizan, iyon ni ye tie yi ni ko shishi. ");
INSERT INTO jid_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iya mbi biyi wa ba tre ndindi ni tu mbi'a, a he toki ba bachi mba batie ni Anabawa bi ce. ");
INSERT INTO jid_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Amma mi hla yiwu wa bi ki sren ton, son bi kamba yi din tie zizi ni bi kran yi. ");
INSERT INTO jid_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tie lulu ni bi mre yi ndi bre Irji ni bi ka to tie yiwu. ");
INSERT INTO jid_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Niu wa nita wru ni ngbala nh'ma kori, uka nno rima, u wanda ban klon me ri, uka nno ri tiya. ");
INSERT INTO jid_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nno indji wa a mye u. Idio nita ban kpie me, na mye ndu ka nno wu ngana. ");
INSERT INTO jid_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","To wa u son don ndji tie wu tie ki bawu me. ");
INSERT INTO jid_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","U ta son ndji wa ba son wu, wa hi ngyeri ndindi niwu? I bi latre ba tie toki me. ");
INSERT INTO jid_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","U ta tie ndindi ni biwa ba tie ndindi wu'a, a ngye u bi ma niwu. E indji bi latre ba tie toki me. ");
INSERT INTO jid_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","U tie nno hla nklen ni ndji wa u to ani ye han wu, wahi kpiew ngye ndindi ni wu? U bi latre'a ba nno hla ni bi latre nda kpa ikpie'a ba na nno. ");
INSERT INTO jid_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amma son biwa bana nyme ni wuna ndi tie zizi bawu. Nno hla, hamma ni yo suron ula kpa kpie tuma, u di me ni babran, u bi he mri Madaukaki, wandi wawu me ani toh tie ni bi wa ba ka ngyri nda meme ndji. ");
INSERT INTO jid_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","He ni dri ndindi na tie mbi. ");
INSERT INTO jid_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na han tre tu rina, u bana han tre nitu me nan. Na kpa ri tie meme na, u bana kpau tie meme na. Wruhle ni bari, u ba wruhle niwu. ");
INSERT INTO jid_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nno, u ba nno yi. Nene rhigra ma, uwa ba den nda grju mudu'a, ka shukuhle ni gban mbi. Ani mudu wawu tsra niwu, a ni kii ba tsra ni wu.” ");
INSERT INTO jid_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A hla misali ri ni bawu, “Indji u nfyen ni tsro ndji u nfyen ri nkon? To a tie naki, ba bi ku ni juju, ka bana kuna? ");
INSERT INTO jid_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ivren wa ani kpa tsro na zan asi tsro wu'a na, amma dun ndji wa ba tsro wu kle'a ani he na indji waa tsro'a. ");
INSERT INTO jid_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bi tie he mu ndi ni ya vi bi giga wa ahe ni shishi vayi me, ndina toh kikle nkpon wandi ahe ni shishi me'a na? ");
INSERT INTO jid_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","U tie he ndi hla vayi me, 'Vayi, dume cu vi bi giga u shishi me,' i wu tume una to gbongbon u shishi me na? Iwu ndji u karji. Guci cu gbogbon u shishi me rju rhi ndi mla ya u wa ahi ni shishi vayi me. ");
INSERT INTO jid_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","E bana tie nkunkro ndindi mawa iklo ma ba gigla ma na, u gigla nkunkron na nno klo ndindi ma na. ");
INSERT INTO jid_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","E ba to nkunkron ni klo ma. E indji bana kyen klo ncu ni nci ncoh na, ume bana kyen klo grapes rji ni miji braya na. ");
INSERT INTO jid_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Indji ndindi rji ni suron ma ndindi ani tie kpi bi ndindima, u meme ndji rji ni meme suron ma ni tie meme kpi. Don rji ni gbugbu kpie bi mi suron inyu ma ni hla. ");
INSERT INTO jid_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nitu ngye bi yome, 'Bachi, Bachi,' u bina tie kpie'a wame tre na? ");
INSERT INTO jid_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Indji wa aye nime nda wo lan tre mu nda tie kpe wa mi tre'a, Mi hla ni yiwu ka ahi nha. ");
INSERT INTO jid_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ahe na ndi wasi meh koh nda shi juju u nci tra ri meme nda meh nci tra ni tu inha. Toh ima aye babran nda ri ni nci tra, u ana tie'u kpe na, nitu ba meh wu bi. ");
INSERT INTO jid_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amma indji wa ani wo tre mu nda na tie bana, ahe na ndji wa a meh tra ni tu meme hamma ni zi nci tra. Ima aye babran nda ri ni nci tra'a, u koh'a tie gbla zi hle kpukpru wu. ");
INSERT INTO jid_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ni wa Yesu kle trema wa tre shishi ndji nda hi ni Kapanawum. ");
INSERT INTO jid_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akwe soja ri wa he ki ahi ni ner kon ma wa mi som tsutse, a buma si kpama nda yiza que. ");
INSERT INTO jid_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soja wo labari Yesu nda dru ndji bi ninkon bi Yahudawa, hla dun Irji ye nda warka ni vren koh ma. ");
INSERT INTO jid_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Baya wa bu ye ni Yesu ndu bra tsutsi na tre ayi tsa du tie wayi ni wu. ");
INSERT INTO jid_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ani son gbugbo, wawu yi men Choch nita wu. ");
INSERT INTO jid_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu chi ka ni wuba. U wa ana zren bran nkon rji ni koh rina, soja tru kpukpan ma duba hla ni wu, “Bachi, na tie kpa me ya na, wu toh mina tsra dun-wu ye ri ni koh mu na. ");
INSERT INTO jid_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Domin wuyi mi na ban ndi mi tsra dun mi ye ni wu na, u wuti hla tre riri mi toh ivren koh mu ni fie sikpa. ");
INSERT INTO jid_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Me ngame mi he ndji ninkon, mi he ni Sojoji wa ba he ni wo'mu. Mi ti hla ni rhi ndi 'hi,' wa ka hi, miti hla ni rhi ngari ndi 'Ye,' wa ka ye, u ni vren ndu koh mu'a, tie nayi, wa ka tie.” ");
INSERT INTO jid_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wa Yesu wo naki, ayi mamaki nda gbaya ndji ba ba ta wu nda tre, Mi hla yiwu, ni gbu Israila mina toh ndji iri gin gbagba nayina. ");
INSERT INTO jid_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Biwa ba ton ndu ba gbaye ni kon nda ton vren koh ma aha sikpa. ");
INSERT INTO jid_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ni veh ri, Yesu tsi hi ni gburi wa bayo ndi Nain. Mri kohma bahe niwu, ndji gbugbu u. ");
INSERT INTO jid_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A yi kritsa ni gbu, bu ban gburi awuri ri iyinma grji wawu na tsrina, ndji gbugbu ni gbu ba he niwu. ");
INSERT INTO jid_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ni toh, Irji alika ni tausayi ma, nda tre niwu ni yi na. ");
INSERT INTO jid_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aye nda akwati bi ba akwati ba kukri nda la ivren tsey mi la niwu lunde. ");
INSERT INTO jid_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ikmo lunde nda sorma tre Yesu ka nu no iyima. ");
INSERT INTO jid_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","I sissri vu ba wawu mba, ba omangyiri ni Irji, nda la ba chu annabi ri kikle ma ni mi mbu, i Irji jan ndi ma. ");
INSERT INTO jid_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Itre Yesu hi kon ni ntsen ni gbu Yahudiya ni gbungblu ba kagon ni wu'a. ");
INSERT INTO jid_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mri koh Yohana ba la niwu gbegbeme ikpiyi. ");
INSERT INTO jid_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yohana yo mri koh mah ha nda ton ba ndu hi ni ndji Yesu. Ba miye u ye? kon akwai ri ki ya konri ye ");
INSERT INTO jid_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baye wiewiere ni ndji ba tre, Yohana wuyi Batisma, aton ta, diki mbye wuyi u ye'a, ko akwai ndji ri wakiyi yakon yema? ");
INSERT INTO jid_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ni nton ki ndji gbugbu wu ba samu sikpa, iyamba kle, meme ruhu bri ba. ");
INSERT INTO jid_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu amsa nda hla bawa, hi ndi hla ni Yohana kpe bi wo, ni kpe bi toh ni hishi mbi. Bi ra shishi baya, bi nkpurju za ba lunde zren, bi kuturu ba kpa ngla kpa, mangbi ton ba wo-tre, biwa ba kyu ba kma lunde ni vri, u biwa ba he nimi wa ba wo tre ndindima. ");
INSERT INTO jid_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Indji wa ana ka wo tre mu na nitu bi zren mu a kpa lulu. ");
INSERT INTO jid_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","U wa mri koh Yohana ba rju ni hi kpamba, Yesu kma ni hla ni gbugbu ndji ba nitu Yohana, “Ahi ngye bi rju hi ni miji si wa bi toh? Indji biwa vi ngyungyu ni fu yi hlega? ");
INSERT INTO jid_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","U bi rju hi ni wa bi toh ngye yi? Indji wa a sru nklon bi ndindi ma? Yayi, biwa ba sru kpi bi tie nklen u nda ni son ni mi iro ba he ni mi koh ba chu. ");
INSERT INTO jid_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","U bina rju hi ni ra ni wa bi toh ngye? Anabi? E, Mi hla ni yiwu, zan u anabi'a. ");
INSERT INTO jid_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wayi a wawu wa ba nha ngame ni wuh. yra mitub manzo gaba niyin, wa shi mle kon teh niyi. ");
INSERT INTO jid_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mi hla yiwu, ndi wa mba bagrji, ba wa nda zah Yohana. ");
INSERT INTO jid_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Baya ndji gbugbu bawo niki, ni bi kpa nklen gandu ba ya ba kpa Irji a ndindima. Ba biwa Yohana yi Batisma bawu. ");
INSERT INTO jid_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisawa ni wa ba ton tre zru Yahudawa bawa, ana Yohana yi Batisma ni bawu na, ba na ya nda ni tre lan na. ");
INSERT INTO jid_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu hla ni ge mi hada ndji bi tsara yi? Ba he hi he? ");
INSERT INTO jid_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba he na mri ba tsi ron ni kasuwa, nda ni tre ni kpamba, “Ki nvri injon ni yiwu, u bina nglu na. ki ban je kyu, u bina yi na. ");
INSERT INTO jid_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nakiyi Yohana aye, na ri hla, ana son mah na bi tre ahe ni brji. ");
INSERT INTO jid_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ivren Ndji ye nda ri nda ni so ibi tre yah, ndji branda so, a kpa bi kpa nklen gandu ni bi lahtre. ");
INSERT INTO jid_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Imri ma wawu ba he ni wayu. ");
INSERT INTO jid_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ni viri Bafarisen, ri bre Yesu ye ni koh ma bawu ri. Wa Yesu ri ni koh Bafarisen, a kuson ni tebru nda ri lla. ");
INSERT INTO jid_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iwa ri lah tre, a rju rji ni mi gbu nda wo Yesu he ni koh Bafarisen, nda ri lla. Nda ye ni ri iyema ni alabasta iyi ri wuwi ma. ");
INSERT INTO jid_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nda ye kluwei na Yesu nda tsi yi nda jum nza ma ni ma shishi ma nda sezah ma ni nfutu ma a tre kauna ma nimu zah gban zah mu ni turare. ");
INSERT INTO jid_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bafarisen yo Yesu bi ninkon ma, ato naki nda tre ni suron ma nda ndji yi ana anabi njanji yi ani toh ndi wayi meme iwa, wa si tawu ndji wu lahtre. ");
INSERT INTO jid_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kpa nyime nda hla ni wu Siman, mi son hla niwu ikperi, wa tre, hla Malam. ");
INSERT INTO jid_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu hla ndji ri inu hla niwu ndji ha bari lah kudi niwu, ndji rima sule deri, irima ani hu rima sule hamsi. ");
INSERT INTO jid_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bana he kudi baya hana igu wruhle bawu, hari mba, iri me nimi mba ani fi son igu? ");
INSERT INTO jid_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siman hla mi ya wa kudi ma bran, Yesu hla niwu, wu hla ndindi. ");
INSERT INTO jid_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu kma hi ni wa'a nda hla ni Siman wu toh wayi, mi ye ni koh me, wu na ne mma wu ngla zah muna, wawu ne, ni mashishi ma a ngla zah mu niwu, nda se zah mu ni nfutu ma. ");
INSERT INTO jid_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iwu u na tsro son nimu na i wawu tie tu wa mi ye ni wa, ana bri mena. ");
INSERT INTO jid_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iwu wu na gban nye ni tumu na, a gban izah mu ni nye ni nfutu ma. ");
INSERT INTO jid_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A he na kiyi wa i lutre ma a bran anu kpa awa bran, nda tsro son wu brama. Wa ba wruhle ni vi fime a suron vi fime kame. ");
INSERT INTO jid_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Baya wayi ala niwu, ba wru la tre me hle niwu. ");
INSERT INTO jid_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wa ba son niki, ba son tre kpa-mba, wayi anha wa ani wru lahtre hle?” ");
INSERT INTO jid_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu hla niwu, isuron ndindima anu ceto me, hi ni si kpa. ");
INSERT INTO jid_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yesu ni mri koh ma wlon don ha, ba zren kagon mi gbu ba, ni'g'rji, ni'g'rji kan kan, ba bla tr Irji na nio hla tre ndindi ma nitu koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Imba gbugbu'u wa Yesu a ju brji rju ni bawu ni kankan rju ni ba wu, ba bi zren baba Yesu, Maryamu wa ba yo Magdali, w a ju brji tangban rju niwu'a. ");
INSERT INTO jid_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ni Yuwana, Iwa Kuza, indji u ndu Hiridus, ni Suzana; ni mba gbugbuwu, ni kpi wu yo'u ba wa ba no ba. ");
INSERT INTO jid_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vi ri ba yo jubu ndji kabi ni k'lanri, ni tu wa indji gbugbu ba rji ni mi gbu gbugbuwu si ye toh Yesu, A tre ni bawu ni misali. ");
INSERT INTO jid_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Indji ri a hi hi bi, bari ba kuhle ni nkon indji ba chan u chinchen ba tan kle. ");
INSERT INTO jid_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bari ba kuhle ni tita bubuwa meme na he ni bran na u ba rju nda lu ni gbron, ba k'ma kyu, nitu bi'a na fie meme na. ");
INSERT INTO jid_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bari ba ku'hle nimi nchon, i nchon ba ba rju gbron nda zan gbengble ibi'a nda wu bi'a. ");
INSERT INTO jid_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ibi ba ri ba kuhle ni meme ndindima nda rju gbron bi, na shobi babran, u bari ba sho gbala deri. Wa Yesu tre kle naki nda yo ba, indji wa a he ni ton u wo dun wo. ");
INSERT INTO jid_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Imri koh Yesu ba myen i ndu hla tu tre'a. ");
INSERT INTO jid_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A hlabawu, biyi ba no yi duyi ton kpi ba rir, u koh Irji, ni brou di mi ngla ba vu ni misali, ko bani toh bana toh kpi ngana, ba wo tre u nda na toh ba tre nge na. ");
INSERT INTO jid_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","To naki kpie wa Irji a tre yi: ibi'a a tre Irji. ");
INSERT INTO jid_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ibi wa ba kuhle ni tu nkon a iri bi wa ba kpa tre Irji u brji ba suron mba hdu ba kahle ga da na yo suron na. ");
INSERT INTO jid_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Naki, bi wa ba chuku ni tita ba ndji wa ba wo tre Irji nda kpa'u ni ngyiri, u ba na he ni njan na, ba kpa tre'a ni nton tsaa me u ni nton wa ibrji tsra ba, ba kuhle. ");
INSERT INTO jid_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ibi wa ba joku ni mi inchon, baba yi ba ndji bi wa ba wo tre Irji, da ba bu koh gbungblu zan gbengble mba, naki, bana no mri bi bi mana. ");
INSERT INTO jid_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ibi wa ba joku ni meme ndindima, a hi ndji bi wa ba wo tre, nda kpa ni suron ri, nda ji gbagba da vu suron. ");
INSERT INTO jid_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ba ndi ani yo lu nda ka'u ni gbugban, ko ba ka zi ni zah bubu kru, sei baka ka zi ni bubu ma don ndi bata ri baka toh kpan ma. ");
INSERT INTO jid_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ba kpe wa a hei riri ma, wa bana shele ana ko kpe u riri wanda na rju ni ra na. ");
INSERT INTO jid_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yo tu mbi wa bisi woh, du ndji wa ahe ni kpa ba sru tia ni'u u wandi ahe fime, wa ndi asi ri mre, ba vu kpa. ");
INSERT INTO jid_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","U yi Yesu, baba mri vayi ma, ba ye niwu, bana iya ye whewhre ni wu na, ndji ba he gbugbu. ");
INSERT INTO jid_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Indji ri hla niwu ngye Iyi Me ni mri vayi Me ba he ni ra, ba son toh'u. ");
INSERT INTO jid_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","U Yesu ka kasa da tre iyimu baba mri vayi mu, ahi baba iba woh tre Irji nda kpa'u tie. ");
INSERT INTO jid_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ni vi ri Yesu ari ni jirgi ma, baba mri kohma, wa tre ndi wa wu ni son duba hi ni granmu, ba wlunde zren ni hi ni granmu'a. ");
INSERT INTO jid_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Da ba si hi, sei Yesu ka kruna, u guigui ri u gbengblen ma a lunde ni ma, naki u ma lu ni shu ni mi jirgi'a ba he ni mi ya. ");
INSERT INTO jid_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","U mri koh Yesu ba ka sh'me wu ni nna, nda tre, “Ninkon mbu, Ninkon mbu! ki si tewhre qu,” wa lunde nda yra nha ni gyungyu'a ni mma wa si shi'a, ka kukri tsit. ");
INSERT INTO jid_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ni ki wa tre ni bawu, i yo suron mbi'a ahe ni ntsen? Sissri tie mri koh ma, ba wri kpa, ikpe wa ba toh ni ki, u ba tre ni kpamba, “Ahi nha yi wayi, wa ani tre hra gyungyu mba mma u nne baka wo'wu?” ");
INSERT INTO jid_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba ye ni ngbala Gerasines, wa hi whewhre ni gran nne rji ni Galili. ");
INSERT INTO jid_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Da Yesu a grji ye meme, u a toh ndji ri ni ngbala koki wa a he ni brji ni kpama. Indji'a ban ton nda na sru nklon na, ana son ni koh na, naka ni son bubu be. ");
INSERT INTO jid_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Da a toh Yesu, wa kpagro nda kurjoku ni shishi Yesu nda tre ni gbangba ndi, Wu ye tie ngye ni me, Yesu, Ivren Irji ni shulu? Mi bre'wu, na ne yah na. ");
INSERT INTO jid_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu a tredun brji duba rju don wu, ni nton gbugbuwu ibrji ba ba huu, ko ba tya lo ni sraka ani su sraka, meme ibrji ba zu hi ni miji. ");
INSERT INTO jid_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","U Yesu ka mye ndji'a, ba yo'u ndi nha? Wa ka tre ndi inde mu a “gbugbu'u,” Yesu tre ndi iki a brji ba gbugbu wa ba ri ni ndji'a. ");
INSERT INTO jid_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ibrji ba bre Yesu du na duba ri ni mi juju na. ");
INSERT INTO jid_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gran dushu u koh bana he gbugbu'u whewhre niki, ibrji ba bre Yesu du duba hi ri ni mi dushu ba, Yesu ka kpa nyime ni bawu. ");
INSERT INTO jid_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ibrji ba ba don ndji'a nda ri nimi dushu ba, u grake dushu ba ba ka tsutsu ka ri ni nne, u mma nne'a ka vu ba hi. ");
INSERT INTO jid_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Inton wa ndji bi ho dushu ba toh kpe wa a tie'a, baka tsutsu nda ka hla kpe wa a tie'a nimi gbu ni kosan gbu'a. ");
INSERT INTO jid_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Da ndji bawo kpe a tie'a, nda ni ye toh, ba ye gbugbuwu, Yesu he ni ndji'a ndi brji ba rju ni kpama, ba toh a sru nklon nda kri, nda he ni mre ma, u sissri ka tie ba. ");
INSERT INTO jid_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Indji ba toh kpe 'a ada tie'a, ba hla yada Yesu chu brji'a rju ni ndji'a. ");
INSERT INTO jid_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Du ndji wa ba he ni ngbala Gerasines ni bi wa ba he ni kosangbu'a ba bre Yesu du rju ni gbu mba, don ba klu sissri niki Yesu ni mri koh ma ba ri ni mi jrigi nda hi kpamba. ");
INSERT INTO jid_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ndi waibrjibarju ni kpama, a bre Yesu du du wawu hu, Yesu yo inkoh nda tre, ");
INSERT INTO jid_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","K'ma hi ni koh mbi, ndi hla ni ndji ikpe wa Irji tie ni wu. Ni ki ndji'a a hi nda ni hla ndji ikpe Yesu tie ni wu. ");
INSERT INTO jid_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Da Yesu k'ma ye ndji basi gben'wu. ");
INSERT INTO jid_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Indji wa inde ma Yayirus, iri ni mi mba bi tre Irji, aye nda kukug ngbarju ni Yesu ni meme, da bre du ye ni koh ma. ");
INSERT INTO jid_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Vivren ma a hama ni si kpa, u sei tso, asi hi bubu ku, a hi wa wu yi vivren wa ni nklen ma, da asi hi indji gbugbu'u basi hu. ");
INSERT INTO jid_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wa ri ni gbu'a ata ju jin sie tso, a wu kle ma wa wu ni bi no imum di ba no sie, ba ndji'a iya no sie na. ");
INSERT INTO jid_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wa zu ni kogon Yesu nda taba nklon ma, ni ki iyin a kukrie. ");
INSERT INTO jid_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu tre ahin nha anha ni kpa mu? Bari wa ba he whewhre ni wu ba tre ndi bana taba wuna, Bitrus tre ndi, indji gbugbuwu ba si ma'wu. ");
INSERT INTO jid_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ni kima Yesu ka tre mi toh indrjo a taba nime, gbengblen a rju ni kpamu. ");
INSERT INTO jid_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Da iwa a toh wawu na ya ri ngana, nda ye nda ni klu sissri nda kukyu ngbarju ni shishi Yesu nda hla ni kpa di ba di kpe waa sa du wawu taba ni Yesu, u iyi'a ka kukri. ");
INSERT INTO jid_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sei wa hla ni wu vre yo'u suron me a du lilo'a kle, hi kpa me ni si suron. ");
INSERT INTO jid_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A mi tre se ndji ri ka rji ni koh tra Irji aye nda tre, vivren wa me'a a kyu ye, na yo'u mala ya na. ");
INSERT INTO jid_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Da Yesu woh naki a sa ni Jariyus, nda tre na klu sissri na, yo suron, ani lunde. ");
INSERT INTO jid_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wa ye ni koh, ana du ndrjo huri ni mi koh'a na, se Bitrus, Yohana u Yakubu ni tie vrenwa'a mba iyi ma. ");
INSERT INTO jid_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Indji gbugbuu niki ba si yi gbagba me, don vivrenwa'a a kyu. Yesu ka tre du ba ka chuwo ni yi, ana qu na, asi krunna migyen. ");
INSERT INTO jid_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ndji ba ba zah u kpa tsri, don ba toh ndi vrenwa'a a qu. ");
INSERT INTO jid_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A vu ni woh nda si yo nde vivren wa da tre du lunde. ");
INSERT INTO jid_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ni ki ivren ma ka k'ma ye ni mi kpama wa a lunde, wa a tre du ba no kpe dun rhi. ");
INSERT INTO jid_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ba tie ma mba yi ma, ba bu iyie'u yo nitu da ya, Yesu a hla ni ba wu du ba na hla ni ndrjo kpe wa a tie na. ");
INSERT INTO jid_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A'yo wulon don ha (12) ba ye bubu ri na nno ba gbengble ni ikoh u wa ba zu brji, na chu lilo rju ni bi lilo. ");
INSERT INTO jid_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na ton ba hi ndu ba hi na hi bla tre Irji, na chu lilo rju ni bi lilo. ");
INSERT INTO jid_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nna hla bawu, nadi ndu ba na ban ikpe rirme nji u bi hi ni zren na; na ban kpalah na, na ban gopelena, na ban bi rina, na nji inklen na, ni na nji inkolom ri u siran na. ");
INSERT INTO jid_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ko ni ko irime bi ri ni mi bika son zu nikima ni ka lu zu niki hi kpambi. ");
INSERT INTO jid_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bubu wa ba na kpa yina, u bika lunde ni gbu ki, ni k'bon wru zah mbi hle ni bawu ndu k'ri gban (Alama) ni bawa ni kah wo'a. ");
INSERT INTO jid_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","U ba lunde shan ni nkanka hi ni gbu'gbu na ni bla tre Irji na ni ju lilo ni rju. ");
INSERT INTO jid_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","U ba he u Hiridus, Ichu, a wo kpe wa a si zren wawu'a. Wa ti sissri ni wa a wo bari ba si tre andi Yahaya wa ani tie Batisma a la ye ni rema. ");
INSERT INTO jid_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ba ri ba tre nda ahi Anabi Iliya, ba rju ye ni re u ba ri ba tre nda ahi iri nimi Anabawa bi sen ba a la rju ye ni re. ");
INSERT INTO jid_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridus tre andi ana Yahaya ne, don wawu nna chutu ma ye, u zizan ahi nha mba mi si wo bibi tre yi nitu ma? Rji niki wa soma wa nkon wa ani toh Yesu. ");
INSERT INTO jid_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","U bi hla tre Irji ba rji ni zren mba ye na ye hla ni Yesu ikpe wa ba ka ti'a wawu. Niki u wa vuba u ba hi ni mi gbu Betsaida. ");
INSERT INTO jid_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Da jubu ndji'a ba wo wu rji wa Yesu hi, na hu zah ma hi niki wa kpa ba na hla tre Bachi ni tre u son nkon Irji ni klekle'a na no bi wa ba si wa sikpa'a si. ");
INSERT INTO jid_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","U Almajere ba ba toh yalu ni tie nan myen ndi ko ani kpanyeme ni ndu ndji bi wa ba ye ndu ba lu ri mi gbu wa ba he ni hwehwre ni rju yi na fe bubu kru ni kpe wa ba rhi. Don kina he hwehwre ni gbu na. ");
INSERT INTO jid_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","I wa hla, ni bawu ndu ba no ba kpe-wa ba rhi. U ba tre andi ki he ni gble bredi iton (5) migyen ni lambe hari (2) se de ki ka hi le biri ye ni bawa wa bari'a. ");
INSERT INTO jid_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(U ba kei indji dubu ton.) Wa ndu Almajere (mri koh ma) ndu ba hla ni bawu ni ndu ba kuson ni wuwlon k'bu-titton (50) ni k'klen wawu. ");
INSERT INTO jid_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","U ba ti tohki, u indji ba kuson. ");
INSERT INTO jid_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","U wa ban bredi'a ni lambe hari'a na nzuttu hi ni shulu, na ti lulu yo bawu na genba ti zizah, na ka no mri koh ma (Almajere) ni ndu ba gaba. ");
INSERT INTO jid_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","U ba ri wrji wa wu mba wu na ni mbru ma, u mri koh ma (Almajere) ba vu mbru ma shuti shu ni sisen Ise-ri (12). ");
INSERT INTO jid_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ni viri Yesu si bre Bachi ni kankrji ma, u mri koh ma (Almajere) ba ye niwu, wa myen ba, “A hi nha indji ba yo me?” ");
INSERT INTO jid_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","U ba hla niwu, “Bari ba tre, Yahaya wa ani tie batisma, bari kuma ba tre ndi Anebi Iliya, hra bari ba tre ndi ahi ri ni mi Anabawa bi sisen mu wa iri mba aka k'ma ye ni re.” ");
INSERT INTO jid_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa mye ba, “U bi yi na, bi yo me ndi nha?” Bitrus sa niwu ndi, “U Almisihu wa u rji ni Bachi Irji. ");
INSERT INTO jid_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu hron ba suse ni ndu ba na jla ni ndrjo naki rina. ");
INSERT INTO jid_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na hla ni bawu, A gbigbi ivren ndji ni sha ya nitu kpie gbugbu; bi ninkon ba kamba niwu ni Piristoci, ni bi nhan, nda la wuu, nivi u tra ba ta'wu shme. ");
INSERT INTO jid_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na hla ni bawu wawu mba, nli indi wa ani son hu me gbigbi me ndu kama ni tuma, na ban nkunkron u wa ba kagran ni viri san ma (Giciye) na hume ko ni nton rime. ");
INSERT INTO jid_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Indji wa a tre ndi wawu ni kpa tuma chuwo'a, ana nawo na, ama indji wa a ka tuma no nitu mu'a, ani kpa tuma chuwo kima. ");
INSERT INTO jid_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lada indji a hi nge, wa ani fe gbungblu'a wawa, da na fe re na? ");
INSERT INTO jid_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Indji wa ni ti shan hla tre mu, Ivren ndji me ni tie shan ma ni nton wa ani k'ma ye ni k'bu Ma ni k'bu Itti ma ni u Maleku njanji. ");
INSERT INTO jid_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Misi hla ni yiwu iwa yi a gbigbi, nimi mbi wa bi klewa bari mbi bana qu na, se ba toh Irji (Mulki). ");
INSERT INTO jid_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu tre klama bi yi, na ban Bitrus mba Yahaya ni Yakubu, na hon hi nitu ngbulu ni hi bre Bachi ni mu. ");
INSERT INTO jid_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wa ahe ni mi si bre, u shishima ka siran, U inklon ma a kpan tie kink'lan re me na zan ni ri. ");
INSERT INTO jid_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hihari me indji hari, ba si tre ni Yesu, ba Musa mba Iliya. ");
INSERT INTO jid_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","U ba rju kagon mba ni nikon u Bachi. U ba tre ni Yesu ni tu hi kpama wa a te whre u ye tsar ni Wurushelima. ");
INSERT INTO jid_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus ni Almajire wa ba he baba ba kle si kru nna na k'mo, da ba lunde, nan ba toh ikpan ma ni ndji hari ba kri niwu. ");
INSERT INTO jid_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wa ba lu ni bri Yesu na hi kpa-mba, Bitrus tre andi ttie ko mu, abi ni tawu wa ki he niwa, ani bi ndu ta me-tra tie tra; iri ni wu, iri ni Musa u iri ni Iliya. (Ana toh kpe wa a si tre'a na. ");
INSERT INTO jid_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wa he nimi tre, u kpalu a lu ka ba, u ba tie sissri ni wa ba lu ri ni kpa lu'a. ");
INSERT INTO jid_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","U ba wo lantre rji ni kpalu'a, ni tre ndi, iwa yi mba ahi vren Mu wa me chu'a wo wu. ");
INSERT INTO jid_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","U lantre ban chuwo tre ni kpalu'a, Yesu he ni kankrji ma. U ba son ni ngbangbi ba na hla kperi ni ndrjo ni vi bi kii wa ba toh na. ");
INSERT INTO jid_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ni vi rima wa ba grji rji ni ngbulu ye, u gbugbu indji ba ye niwu. ");
INSERT INTO jid_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hihari me, U ri ni mi indji ba a tre ngban me, Mala bubo me, k'ma ya vren mu, ahi vren mu iriri mi gen. ");
INSERT INTO jid_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Meme brji ni hon ni wu tu na yo ku-k'mo, na jijiga niwu na gben glele na yo futen shu yiu. Ni ker ri a ban chuwo ani timba ana fie fie mana idan a ban chuwo. ");
INSERT INTO jid_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi bre mi ri koh me (Almajere) ni dun ba zu meme brji rju ni wu ni kpa, u bana ya na ");
INSERT INTO jid_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu tre andi biyi bi tsren g'gran ni ka kpa nyeme ni k'ma bi ni tan mi ua vu suron ni son ni yi? “Nji vren me ye wa yi.” ");
INSERT INTO jid_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","U vren lu ni hi meme brji wru yo k'bon ni menme u Yesu zu meme brji na chu lilo rju niwu na ka no tie ma ");
INSERT INTO jid_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","U ba tie sissriwawu mba, wa ba toh gbengble u Irji wa a tie na hla ni Almajere ma, ");
INSERT INTO jid_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bi ka ndu tre yi ri ni yiwu ni ton su se: Ivren Indji mba ka no ba ni wo indji.” ");
INSERT INTO jid_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","U bana toh itu tre na, a ri ni bawu, ni ndu ba toh tu kpi a si tre na, naki me ba tie sissri nda miyen itu tre me na. ");
INSERT INTO jid_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ba lu ni gbi suron ni kpa mba, andi a nhan zan ma ninkon'a. ");
INSERT INTO jid_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu toh kpe wa a he ni suron mba, na ban kpran vren ye tsi ni kpa ma ko san. ");
INSERT INTO jid_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na hla bawu, ndu ndji wa a kpa vren klenken yi, ni mi inde mu'a a kpame, indji wa a kpame, a kpa indji wa a ton me. Indji wa a vi zizanma ni yi'a a wa wuyi a ninkon ni mi mbi. ");
INSERT INTO jid_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahaya yo a ndi ninkon mbu, ki toh indji ri niwa mu si ju brji ni ndji ni nde me wana nihu ta ni mi mbu na. ");
INSERT INTO jid_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu tre na zuuna, indji wa ana yo ko shi na ahi u me. ");
INSERT INTO jid_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","U vi chibi ye whiwhre wa ba ban hon hi ni shu, wa yo suron ma ndi wa wu ni hi Wurushelima. ");
INSERT INTO jid_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wa ton Manzani duba guchi hi niwu, u ba ka ri ni gbu Samariya wa be m'lan ko nge tie niwu ki. ");
INSERT INTO jid_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","U indji ba niki bana kpa ni wo ha na, don ba toh a yo suron u hi ni Wurishelima. ");
INSERT INTO jid_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wa Imri koh ma (Almajire) Yakubu mba Yohana ba toh naki, nda tre, “Bachi, U son ndu ta ton ilu rji ni shulu dun gon ba?” ");
INSERT INTO jid_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wa k'ma ya ba nda zuba. ");
INSERT INTO jid_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","U ba tsi ka hi ni gbu ri kan. ");
INSERT INTO jid_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wa ba he ni mi si hi ni gon, u ndrjo a tre niwu, “Mi huwu hi ni wawu wrji wa usi hi.” ");
INSERT INTO jid_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu hla ni wu andi, n'nma bi miji ba he ni juju wa ba ri ni mi, u nchinchen ni shu ba he ni koh mba, u Me Vren Ndji mina he ni wrji u ka tu yo na. ");
INSERT INTO jid_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wa a hla yo ri andi “Hu me.” U ndji'a hla ndi, “Bachi, Mi bre'u dun mi guchi hi rju itti mu ri.” ");
INSERT INTO jid_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","U wa hla niwu, “Bri k'mo ndu ba rju k'mo ba kimba. Ama niwu hi gbugban mu ni hi hla tre Irji kagon gbungblu. ");
INSERT INTO jid_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","U indji mu kan tre mi hu, Bachi, a ma ndu mi hi hla ndji mi hi ni bawu ni koh mu. ");
INSERT INTO jid_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu hla niwu, “Andi Indji wa a kawo vu zan ni soma yarrhan da hla ka ya gon indji mba ku nyre wa ani toh koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ni kle kima, Bachi a chu ndji tangba nda ton ba ni hi ha duba hi ni gbu ni gbu wa ndi wawu me ni hi niki. ");
INSERT INTO jid_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wa a hla ni bawu, ichan a gbugbu'u, in bi tie du'a ba fi me, bre Irji ndi dubi tie ndu'a ye. ");
INSERT INTO jid_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mi toh yi, hi na mri krju ni mi meme in'ma miji. ");
INSERT INTO jid_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na ban nbu nklen na, ko mbu nklonna, ko lagban zan na, na chi ndrjo ni nkon na. ");
INSERT INTO jid_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Du ikoh wa bi ri'a, bika guci tre du si suron du he ni koh yi! ");
INSERT INTO jid_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Idan ni koh yi, inde ndji “U sun si suron a he ni mi, si suron ka son ni nituma. Idan ana he si suron bi ka huye ye kpambi. ");
INSERT INTO jid_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bi son ni koh wa ba kpa yi, bi rie ndi so kpe wa ba no yi'a, don ndji wu titu ani kpa ya ma, Na hu ni koh ni koh na. ");
INSERT INTO jid_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Du gbu wa bi ri, ide ba kpa yi, bi ri ndi sokpe wa ba no yi, ");
INSERT INTO jid_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Be no bi lilo si. Di hla ni bawu ndi, ivi u ye Irji a tie whewhre. ");
INSERT INTO jid_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Du gbu wa bi ri, u bana kpa yi na, bi ka rju hi ni nkon, ");
INSERT INTO jid_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Di tre ko wru zah mbi, ki se sruni yuu. Bi ka toh ndi iye Irji tie whewhre. ");
INSERT INTO jid_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi hla ni yiwu ni vi kima u ye, ani he ni ya ni gbu kima zan Sodom. ");
INSERT INTO jid_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iyame Korazin, iya me Betseida, da iri kikle du a ba tie ni Tyre mba Sidon, bana kpa Irji ni sen mu, da ta sru gbanjan nklon nda son nitoh lu. ");
INSERT INTO jid_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chachu bla tre ani bini Sidon mbaTyre. ");
INSERT INTO jid_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","U kapanawum, u ya ndi wu, u rhi ni shulu? ba nji grjiye yo ni Hades. ");
INSERT INTO jid_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Indji wa awo yi, a wohme kena, indji wa a kama ni yi'a, a kama ni me wa mi ton yi. ");
INSERT INTO jid_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wlon nkpu tangba ba k'ma ye ni kinkla suron, nda ni tre Bachi, Ibrji me ba kujoku nitawu nimi nde me. ");
INSERT INTO jid_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu ka tre mi si ya Ibrji a joku rji ni shu na kpan. ");
INSERT INTO jid_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Toh mi no yi gbengblen du yi chan iwan baba ilan, nitu bi gbengblen bi kra ta. ");
INSERT INTO jid_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na ngyiri ndi ibrji ba joku ni yiwu na, ngyiri ndi ba nha inde mbi ni shulu. ");
INSERT INTO jid_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ni nton kima'a a grji ni Ruhu ndindi, nda tre, Me zu inde me Timbu Bachi ni shu, ni u gbungblu, don u wru kpi bi hle ni bi wandi ba bu shishi nda to ndi, di tsro bi wa bana hla ni bawu na, na mri bi klekle, abi ni shishi tie mu. ");
INSERT INTO jid_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tie mu a vu kpi ba wawu sru mu niwoh, ba ndji wa a toh Vren'a, se Iti ma, ba ndji wa a toh Iti'a se Vren'a, wandi Ivren a kpanyime nda ni tsro Ti'a. ");
INSERT INTO jid_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A kma hi ni mri koma ni ka grji ba, nda tre bi wa ba tie lulu yo ni bawu'a nda toh kpe wa bisi tie'a. ");
INSERT INTO jid_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bi tie ndu Irji baba bi chu gbugbu ba ndi ba toh kpe wa ndi bi si toh, “u” bana toh na. Ba ndi ba woh kpe wandi bisi woh, bana woh na. ");
INSERT INTO jid_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Se mala ri u bla tre ni Yahudawa kaye tsra u, nda tre mala, me tie ngye miti mi ni kpa re u tuntrun? ");
INSERT INTO jid_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wa a kasa nda tre gbigbi wuka sun Bachi Irji ni suron me wawu, ni drime, ni gbengblen me wawuu, ni mre me wawu, wuka son indji u kutra ka hlan me na time. ");
INSERT INTO jid_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ka hla inde wu tie naki, u tie njanji u wuna kyu na. ");
INSERT INTO jid_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mala ani sun si tuma cuwo nda tre Yesu, Ahi nha hi indji u ka hlan mu? ");
INSERT INTO jid_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wa a tre ndi a rji ni Wurushelima nda ni hi Yariko. Da ka ku ni wo bi y'bi, u ba kpa wawu kpie wa ndi a nji'a, nda tsi'u, wa tie whre u kyu baka don wu. ");
INSERT INTO jid_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Se ga bi ton du Irji ye toh nda zuni kosan nda hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Se ga balawi aye nda toh nda gon zu ni kosan nda hi kpama ngame. ");
INSERT INTO jid_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Se ga Basamariye aye nda kukri nda ya indji'a a loh suron. ");
INSERT INTO jid_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aye nda ngla kpa niwu, nda gban nye niwu, nda loh kpa niwu, nda ban sa ni nhma ma, nda nji u ni bubu u kru. ");
INSERT INTO jid_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","U mble kpan no nkle, wandi bata ya indji wu lilo'a nda tre, to nklen'a a kleh, mi ye nowu mbru ma. ");
INSERT INTO jid_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ni mi ndji tra biyi, ahi nha hi ndji u kutra kalah ma? ");
INSERT INTO jid_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Se mala ka tre indji wa tsro loh suron, I Yesu ka tre hi ndi tie naki. ");
INSERT INTO jid_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Da ba si he nimi zren nda ye rini mi vi gburi, u wari bo yo'u ndi Mata a kpa'u ni koh ma ni woh ha. ");
INSERT INTO jid_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ahe ni vayi ma, bata yo'u ndi Maryamu, wa ndi a son ni zah Bachi nda si woh kpe wa ndi asi tre'a. ");
INSERT INTO jid_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata si sron biri, “u” wawu Mata a ye ni Yesu nda tre Bachi wu na toh yada vayi mu a kame don misi tie ndu'a kanklen mu na? Hla niwu du ye zo me. ");
INSERT INTO jid_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bachi ka tre Mata, Mata wu yo kpi gbugbu'u ni ko shishi me, ");
INSERT INTO jid_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ama kpe riri Maryamu a chu kpe ndindi ma, ba ndji'a wa ani sran wu kpa. ");
INSERT INTO jid_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naki Yesu a si'a bre Irji ni bubu ri, ni-andi a kle bre'a, iri ni mri koh ma bi hu'a a tre ni wu ndi, “Bachi, tsro ta kini toh bre bib-andi Yohana a tsro mri koh bi hu'a. ");
INSERT INTO jid_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu a hla bawu ndi, “Bita bre, bika tre ndi, 'Iti mbu, du ndeme ndu kpa ninkon. Du ikoh Irji ni shulu du ye. ");
INSERT INTO jid_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nu ta biri mbu wu vi chachu. ");
INSERT INTO jid_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wru latre mbu hlega, toh-andi ki wru hle ni ko nha wandi a rhi ihla mbu. Na duta rjoku ni tsra na.'” ");
INSERT INTO jid_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu a hla ni bawu ndi, nnha mbi ani he ni kpan wandi ani hi niwu ni tsutsu chu ndahi bre ndi “Ikpanmu, nne ihla bredi tra, ");
INSERT INTO jid_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nitu ikpanma ri a ye wru sru zizan rji ni zren, i mina he ni ikpe wandi minu ri na. ");
INSERT INTO jid_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wawu wandi a he ni miko ma a sa niwu nda tre ndi, na nne yratu na. Mi tronkon mu ye, i mri mu ni me ki ri kruna ye. Mina la lunde ni nu bredi na.” ");
INSERT INTO jid_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mi hla ni yiwu, anita na lunde nda nu bredi nitu wu kpanma na, nitu kri nhatu myeme, ani lunde nda nhu gbugbu bredi wandi wu wa'a. ");
INSERT INTO jid_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mi la hla ni yiwu, mye ba nuhi, wa i bi to, wru nkon, i ba bwu ni yiwu. ");
INSERT INTO jid_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ndji wandi ani mye, ni waa anito, i ndji a wru ba bwu niwu. ");
INSERT INTO jid_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Iti nha ni mi mbi, vren ma nita mye ni du nu lambe ani ban iwan nu nitu lambe? Chiche nvunvu bi sen bari nha ba hi nkpurju, i bari wu mba gbron, toh ikpe wandi ba nha ni Matta 7:9. Iti rime ni mi mbi wa ivren nita mye bredi waka ban tita nu? Ka anita mye lambe ka ban iwan nu? ");
INSERT INTO jid_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ka anita mye inchen'ko waka ban illan nu? ");
INSERT INTO jid_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ni kima, biyi bi meme dri bita toh nu mri mbi ikpi bi ndindi, nitu ngye Itimbi ni shulu na nuyi Ruhu Tsatsra ma ni ko nha wandi a mye na?” ");
INSERT INTO jid_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu asi'azu brji mamgbi ri ni rju brji ni kpa ma, Igu'a ani mamgbi a lu kri tre, i kpa ndji biwa ba he niki ba bwu nyu yo ra ni sissri. ");
INSERT INTO jid_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","I ndji bari nimi mba ba tre ndi Beelzebul, ninkon brji ba si zu brji mba ni rju ");
INSERT INTO jid_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bari ba tsra ni du ba toh alama rji ni shulu. ");
INSERT INTO jid_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu a toh kpe-andi a si zren ni suron mba nda tre ndi, “Khikle Koh andi a yra kpama ni kpama, ani yra kado, i ikoh wandi a yra tuma ni tuma ani zii rjoku. ");
INSERT INTO jid_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Shetan nita ga kpama ni kpama, hikle koma tie he nda kri? Bita toh ndi mi zu brji rju ni Beelzebul. ");
INSERT INTO jid_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mita zu brji rju ni Beelzebul, i bi wa ba huyi ba zu ba ni nha? Nitu wayi, baba yi ba ga tre ni yiwu. ");
INSERT INTO jid_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mita zu brji ni rju ni vren-wo Irji, nikima, kikle koh Irji ni grji ye ni yi. ");
INSERT INTO jid_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ndji wu gbengblen wandi a kri ni sro ni koh ma, ikpe koh ma ba nawo. ");
INSERT INTO jid_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ndji ri wandi a zan ni gbengbeln anita ye suu, wandi azan gbengble ani vu kpe wu sro ma wa ana yo suron niba nda vu kpi wu koh nda hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wandi ana he nime na ana nyime nime na. I wa'a ana vu shubi ni me na, ni vre hle. ");
INSERT INTO jid_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Meme ibrji nita wru ni kpa ndji, a ni zren zu ni kuklu bubu nda wa bubu kuson. Anita na toh na, ani hlandi “Mi k'ma hi ni ko wandi mina he'a.” ");
INSERT INTO jid_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aniti k'ma ye nda toh ba se ikoh pempeme nda mla wu tie. ");
INSERT INTO jid_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ani k'ma hi yo brji tangba bari du ba hu ye son ni ko'a. I isran gu ni zan wandi a he ni mumla'a. ");
INSERT INTO jid_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A he me, niwa a tre kpi biyi, iwa ri a d'bu hla nimi kpa'a ndji ba nda hla wu ndi, “Lulu ku ni nne wandi a ngrji wu, mba sisan wandi wu ma.” ");
INSERT INTO jid_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wa a sa ni wu ndi, “Ni kima du lulu son nitu bi wandi ba wo tre Irji nda tie ndu (ziwu) ni wu.” ");
INSERT INTO jid_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wa ndji ba basi bran nha, Yesu a lu si wa ndji, “Ik'ba biyi ba meme ik'ba. Ba wa ingba, i bana nuba ingba na - se ingba wu Jonah. ");
INSERT INTO jid_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ni-andi Jonah ana ingba ni mi bi Ninevit, toki me, vren Ndji ani ingba ni k'ba yi. ");
INSERT INTO jid_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ichu-mba wu kogon ani lunde ni bla tre ni lilon wu k'ba yi nda lo ba, nitu a ye rhi ni gbagban meme, du ye wo wrji nyu Solomon, nda toh ndji wa a zan Solomon he niayi. ");
INSERT INTO jid_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndji bi Nineve ba kri ni bla han tre ni k'ba ndji biyi, nda lo ba, nitu ba kpa tre Irji nda tan ntsan niwa ba wo tre Irji ni nyu Jonah, bi ka toh Ndji wa azan Jonah he ni yi. ");
INSERT INTO jid_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A nha ni yo lu ni glogo nda ban ri ni sisen ndana ka sa ni tu kpe tsame na ni du bi ri miko du ba toh kpan lu. ");
INSERT INTO jid_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Shishi meyi hi glogo wu kpa me wawu. Shishi me nita bi, wawu kpame ni shu ni kpan-lu. U Shishi me nita na bi na, ikpa me wawu ni tie bwu. ");
INSERT INTO jid_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nikima, bi ka mla zren ni du ikpan mbi du na k'ma tie bwu na. ");
INSERT INTO jid_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ikpa mbi wawu niti na shu ni kpan-lu, ni hamma ngbala ri ni bwu, niki, kpa mbi wawu ani kpan toh glogo ni kpan-lu ma niwu. ");
INSERT INTO jid_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ni wa a kle tre'a, Farasi ri a mye'u du hu hi rhi biri ni koma, Yesu a kpa nyime nda hu'u. ");
INSERT INTO jid_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farasi a yi mamaki ni toh ndi Yesu ana ngla kpama ri nda son ni ba ni bubu rhi biri'a na. ");
INSERT INTO jid_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","I Bachi a hla ni wu ndi, “Zizan, biyi Farasi bi ngla kogon vuvanho mba gbugba'a (kungo) nda don mima shu ni sontu ba meme kpi. ");
INSERT INTO jid_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biyi ndji bi kha toh, Ana wandi a tie kogon a tie mima ngame na? ");
INSERT INTO jid_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nu kpi wandi ba he ni mi tu beko, i kpiba wawu ba rju pyempyen me niwu. ");
INSERT INTO jid_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Iya mbi biyi Farasi, nitu bi nu zaka wlon mint mba rue, i mri vunvu bi koh p'ma, nina k'magon nu ti bi mba son Irji. Ani bi du yi zren bi ni son Irji, hamma ni mbru kpi ba ngame. ");
INSERT INTO jid_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Iya mbi Farisawa, bi son bubu u son bi ko shishi ni sinagog mba kpa ichi bi nzu lu ni chuchu. ");
INSERT INTO jid_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iya mbi, bi he toh ibe wandi bana chu tsro nkana, ndji ba hon zu ndana toh na. ");
INSERT INTO jid_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iri nimi bi ninkon ni tre doka'a hla wu ndi, “Ticha, ikpi wandi wu tre a kpata tsri ngame.” ");
INSERT INTO jid_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu a tre ndi, “Iya-mbi, Tichas bi doka! Bi yo kikle kpi ni ndji wandi ani tiba ya nji, ama ni na yo wo kpre ni vren wo mbi riri na. ");
INSERT INTO jid_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iya-mbi, bi meh ibe ni anabawa, wa ba bachi-mbi ba wuba. ");
INSERT INTO jid_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Niki biti shaida ni kpanyime ni ndu ba bachi-mbi'a, Baba yi ba wuba i biyi bi meh ibe mba. ");
INSERT INTO jid_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ni tu kima'a, wri Irji a tre ndi, 'Mi ton anabawa mba manzani ye ni ba, i ba tiba ya nda wu bari mba. ");
INSERT INTO jid_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ik'ba biyi ye mi vu ba nitu iyi ba anabawa wandi ba ka hle rji ni mumla, ");
INSERT INTO jid_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","rji ni iyi Habila, ye ni iyi Zakariya, wandi ba wu ba ni kpa bubu ton ba koh Irji. E, mi hla niwu, mi vu ik'ba yi ni tumba. ");
INSERT INTO jid_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Iya-mbi bi zan toh tre Irji, bi ban ih'ra wu toh, nina ri ngame na, ni zu bi wandi bason ri'a. ");
INSERT INTO jid_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ni wandi Yesu a bri bubu kima, marubuchi, baba Farisawa ba kri nda sen nyu ni wu nitu kpi gbugbuwu, nda son, ");
INSERT INTO jid_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","si gben'u du ba vu ni tre nyu ma. ");
INSERT INTO jid_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ni nton kima, indji dubu gbugbuwu ba rju ye shubi nitu bran mba ba hon ta chan kpamba. Alu kri tre ni guchi ni mri ko ma ndi, “Mla ya yist wu Farisawa, wandi ahi gyuru ndji nitu zren mba ");
INSERT INTO jid_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ba kpe wa ba kawu wandi ana rju kri ndende ni ra na, ba kpe wa ba kari wandi bana toh na. ");
INSERT INTO jid_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nitu kima, ikpi wa wu tre ni bwu ba wo ni kpan, i wuta tre kpe ni riri ni ton, nimi tra, ba dbu hla ni tu nkan. ");
INSERT INTO jid_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mi hla ni yiwu, kpukpanmu, na tie sissri bi wa ba wu ikpa megyen, dana he ni kpe wa ba la tie na. ");
INSERT INTO jid_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama, mi gbron ton mbi nitu wa be klu'u klu wandi anita wu, a he ni gbengble wu ta u yo ni lu shetan. Ee, Mi hla ni yiwu, klu'u. ");
INSERT INTO jid_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bana leni chinche sparo ton nitu wlo bubo tra na? Ni kima me, Irji na kparisu ni iri mba na. ");
INSERT INTO jid_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Infutu wu tume me a bla ba pempe. Natie sissri na. Wu he ni ndu zan chinchen sparo gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mi hla ni yiwu ndji wa a kri nda tre ni tu mu ni shishi ndji, Vren Ndji ngame ni tre ni tuma ni shishi Maleku Irji, ");
INSERT INTO jid_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Anita kama ni me ni shishi ndji, ba kama niwu ni shishi Maleku Irji. ");
INSERT INTO jid_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ko nha wa a tre lan tre meme nitu Vren Ndji, bakpa wru hle niwu, ama wuta tra valala wu gbron gbrongrji, nitu Ruhu Tsatsra, bana wru hle niwu na. ");
INSERT INTO jid_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bati ngrji wu ye ni shishi kikle bi mitra Sinagog, bi tie chu baba bi ninkon gbu, na du suron mbi rjoku nitu kpe wandi bi tre wa ani kpauyi chuwo na. ");
INSERT INTO jid_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ruhu Tsatsra ni tsro yi ni nton kima, ikpe wa bi tre'a. ");
INSERT INTO jid_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ndji rinimi ikpan ndji ba a tre niwu ndi, Ticha, hla ni vayi mu ni du ga gado mbu ni me. ");
INSERT INTO jid_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu a hla wu ndi Ndji, anha yo me mi ga tre koh du mi ri nimi tre mbi? ");
INSERT INTO jid_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A tre ni ba andi, mla toh ni na du son tu do honyi na, nitu mlason ndji ni vrhi ana nitu kri ni gbugbu ikpi wa a he ni wuna. ");
INSERT INTO jid_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nikima, Yesu a tre parabul ni bawu ndi, “Irju ndji wu wo ri nu birhi gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A son nda mla ya ni kpama nda tre ndi, 'Mi tie ni he, nitu mina he ni bubu wa mi zi biri wu wru mu na?' ");
INSERT INTO jid_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A tre ndi, ngye kpe wa mi ti a yi. Mi zi ba wronmu ni mme bi rigrama, nike mi zi biri wu wrhu mu mba mbru ikpi mu wawu. ");
INSERT INTO jid_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi hla ni suron mu, “Suron, wu he ni kpi gbugbuwu wa wu mla zi wu ise gbugbu ni ko shishi. Kuson si rhi ni so, son piyame.'” ");
INSERT INTO jid_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ee, Irji hla wu ndi, 'Ruhu ndji, ni chu wu luwa, ba kpa vrhi suron meluwa, i ikpi ba wu mla zi ba, wu don ni nha?' ");
INSERT INTO jid_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kima he na bibi ndji bari, ba vu kpi si mla zi ni tu mba, nda k'ma tie bi kpla ni Irji. ");
INSERT INTO jid_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu a hla ni mri koh ma ndi, Mi hla yiwu, na dame ni tu me na, ikpe wa wuri, ko ni kpame, ikpe wa wu sru. ");
INSERT INTO jid_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vri son a zan biri i kpa zan nklon wu sru. ");
INSERT INTO jid_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ya kikle chinche ravins, bana chu ndana han na. Ba na he ni tra wu zi kpi ko wron na, ama Irji ni nuba irhi-mba. Wu na zan chinche ba ni anfani ni shishi Irji na? ");
INSERT INTO jid_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Inha nimi-mbi, nitu son rhimre nitu kpe, ani du vi wu vri ma hon zan cubit? ");
INSERT INTO jid_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wuta na toh tie mri kpi toh wayi na, nitu ngye wu du suron me du na kuson si na? ");
INSERT INTO jid_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ya mri vunvu bi kpan mbi ni shishi to lilies, ni lu gbron mbu, bana tiya na, bana k'ma ya bubu na, ee, Solomon me ni nzu hon ma ana sru ikpi wu bi toh iri-mba na. ");
INSERT INTO jid_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Irji nita nu ghiga wu wrhu, wandi luwa ahe, i mble ba kau taga ni lu, ani tie he ndana nu nklon wu sru na? Wu ndji wu kpanyime ni wu fime. ");
INSERT INTO jid_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na yo shishi ni kpe wa wu rhi ndi sona, na du suron me hamma ni kukru na. ");
INSERT INTO jid_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gbungblu wawu ba yo suron wa ikpi biki, i Timbi toh wu son kpi baki ngame ");
INSERT INTO jid_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wuka yo suron meni iko mulki Irji guchi, i ba vu kpibiyi nha niwu tuma. ");
INSERT INTO jid_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Na tie sissri na, ikran mri nitu Iti-mbu toh a bi ni du nuta ri ko mulki ma. ");
INSERT INTO jid_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Le ni ikpi me ni nu sadaka. Wran ngomble ni kpa-mbi wa ana y'ba na - ikpe ndindi ni shulu wandi ana kle na, i ndji wu y'bi na ye whiewhiere na, i imra na kpa timeme na. ");
INSERT INTO jid_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bubu wa ikpe ndindi me he'a, suron me ni he ngame. ");
INSERT INTO jid_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lo kpa mla tie ni rjirji ni nchi, ni du ilu me si kpan, ");
INSERT INTO jid_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nna ndji biwa basi gben ti-kohmba du k'ma rjini ko gran, anita ye wrunko, baka bwu niwu gbagbla. ");
INSERT INTO jid_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Lulu he ni tu igran biwa tikomba niye to ba si gben yemma. Njanji, mi hla yiwu, ani mla kpama tie wu tindu nda du ba son nitu tabur, wa a ni lu tindu bawu. ");
INSERT INTO jid_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tikoh anita ye ni nh'ma wu ha ko nh'ma wu tra nda ye toh bi ki ni sisren si gben i lulu ni tu igran baki. ");
INSERT INTO jid_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ama bika toh, tikoh nita toh nton wa ndji wu y'bi ni ye'a, ana du rhi ni ko'a na. ");
INSERT INTO jid_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Son ni sro, wuna toh nton wa vren ndji ni yena. ");
INSERT INTO jid_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitrus a tre, “Bachi wusi hla tre yi ni tawu megyen ka ni konha?” ");
INSERT INTO jid_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bachi a sa ndi, “A hi nha ndji ndindi wa tikoma ni nu ndu ya mbru igran ma, ani mla ta nuba biri mba ni ntonma? ");
INSERT INTO jid_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lulu he ni tu igran wa tikoh niye toh si ti ndu wa bana nu anita k'ma ye. ");
INSERT INTO jid_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Njanji mi hla yiwu, ani yo ni tu ikpi koh ma wau. ");
INSERT INTO jid_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Igran a nita tre ni suron ma ndi, “Bachi mu ani ti grji ni ye, nda lu si tsi igran lilon baba mba biwa ba he ni wo ma, nda rhi nda so nda wha, ");
INSERT INTO jid_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bachi igran niye ni ivi wa ana tie mre na mba nton wa ana to na, anic'ba tie tsitsa nda ban yo ni bubu bi ka toti ndindi. ");
INSERT INTO jid_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Igran kima, nitu ana toh suron bachima ye, ama dana mla son nda tie kpi wa ani son na, ba tsiwu branbran. ");
INSERT INTO jid_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","I waa ana toh na ama nda tie ikpe wa du ba tsiwu a, ba tsiwu ifimeyi. Ndi wa banu ikpi bran bran, ni wo ma, ba kpa branbran. Wandi ba zi kpi gbugbuwu ni woma, ba mye ikpi wa azan kima. ");
INSERT INTO jid_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mi ye nitu ye yo lu ni gbungblu mem, i mi son ndi ilu anina nu ye. ");
INSERT INTO jid_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ama mi he ni baptisma wa batie nimu'a, suron mu ni lo nitu du ba kle kima. ");
INSERT INTO jid_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bi ya mi ye nji isi ye ni gbungblu meme? Ana toki na, mi hla yiwu, ahi iga. ");
INSERT INTO jid_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rji ni zizan, hini shishi, ndi ton ba he niko, iga ni ri, ndi tra nitu ndi ha, i iha nitu tra. ");
INSERT INTO jid_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baga ni kpamba, iti mba vren wa ni ihi ma. Ihi wa vren ma mba iwa vren ma, i wa vren ni ihi lonma. ");
INSERT INTO jid_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu asia hla ni kpa ndi ba, ngame ndi, “Bita toh kpa lu ni lunde rhi ni yalu, bika gbla tre ndji, tenlu ni ye wa ani he toki. ");
INSERT INTO jid_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gyungwu nita ni fu ni rji ni kogbo, bi tre ndi, gbaji wu hwuma ni ye, wa ani ye toki. ");
INSERT INTO jid_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bi gyru tu-mbi, bi to sran, tsro kpa ikpi nimemembani shulu, i ti tie nihe nina toh sran ikpi wa si zren zizan na. ");
INSERT INTO jid_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bi ti he mu nina gatre ni kpame na? ");
INSERT INTO jid_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wuta hi niwandia no son na, ni shishi ndji wu ga tre, bita rhi he ni nko, bika mla ti ni kpambi, nitu du na njiwu hi lo, ni du ndji wu ga tre kana vu nuwa ani, njiwu hi tro na. ");
INSERT INTO jid_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi hla niwu, wuna to wru na, se wu han kubu wa ba han pempyeme ");
INSERT INTO jid_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ni ntor ki indi bari ba ye ki nda wa wu itre indi bi Galili wa Bilatus ta kayi mba kai bi nda tie ha daya. ");
INSERT INTO jid_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu a kasa bawu biya di indi bi Galili yi ba latre nna mbur bi Galili ba don ba tie yah towa? ");
INSERT INTO jid_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A' an, me hla giu amma idan bina bre wruhle na wawu mbi wu bi tie meme na u mba. ");
INSERT INTO jid_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Indi wlan don tandara ni siloam wa guglo koh a grji can be wu'a bi ya di ba latre mba a meme na' u indi bari ni urushalima? ");
INSERT INTO jid_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A'an me hla yiwu amma bi tana bre wruhle na wawu mbiwu bi kle ");
INSERT INTO jid_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu a hla misali yi “Indi ri ahe ni rju wa a sen kukron nda ye kyen klo ma amma nda na vriri mena. ");
INSERT INTO jid_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Indi u rju'a hla ni wa ani ya rju'a niwu. To yi, ise tra mezi ye di me kyen klo kukron yi, u me na fe ko riri mena. Tsen'e taga u don zi nigye ndu hra bubu? ");
INSERT INTO jid_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","U indi u ya rju ni wu'a ka tre, tie koh mu don wu zi ise ri rli ndu me mlau tie ndi sraru taki. ");
INSERT INTO jid_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ani ta klo ni semu abi amma ini ta ka klo uka tsen taga ");
INSERT INTO jid_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu asi tsuro ni mi tra Rji cacu a sabath. ");
INSERT INTO jid_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iwa ri ahe ki nda lo tie se wlon don tadra. Avu ndiu nda na to nza kli zande trii mena. ");
INSERT INTO jid_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Da Yesu a to-o a yowu nda tre iwa u jibu ni lilo me yi. ");
INSERT INTO jid_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aka wo ma sa ni wa hari me ka nime trii ma katie didi wa a gri nda gbre Rji san. ");
INSERT INTO jid_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ichu u ya tra Rji'a ka tie fu andi a den lilo cocu sabath. Ichu a tre nda hla ni j'bu ndi ba, Ivi tanne bahi u ndu ye kpa den mbi ni vi biki, ana cacu sabath na ");
INSERT INTO jid_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Baci a kasa niwu nda tre bi mirlya ndi, Ahi rime mbi na sii lando ma ka nakpron ma hi so ma cacu sabath na? ");
INSERT INTO jid_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Toki iwayi ahi vrenwa Ibrahim wa shetan lowu zi tie se' wlon don tandra u bana siiwu cuwo ni vi sabath na? ");
INSERT INTO jid_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Da a hla tre ba ishan a tie indi bi'a ba tisan niwu amma ekpe ndi ba ba ngrji ngri ni kpi wa a tie'a ");
INSERT INTO jid_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","U Yesu tre mulki Rji abi rime u me tsarwu to ni ngye. ");
INSERT INTO jid_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ahe na iwlo mustad wa indi ri ban katayo mimi rju a gbron tie kikle kukron, u ciceri bi shu baka ti koh mba ni lari ma. ");
INSERT INTO jid_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A latre ni ngye me tsar mulki Rji? ");
INSERT INTO jid_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A he na yeast wa u ban tsui ni mwumwu kongo tra u mba kabi wawu-u ");
INSERT INTO jid_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nikiyi Yesu ka ziren hi ni gbu'ni mrli gbu u nkon urushalima nda zi bla tre Rji. ");
INSERT INTO jid_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Indi ri tre niwu, Baci ahi ndi tsameyi ba nawo? wa hla niwu, ");
INSERT INTO jid_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nra nkon u ri wa ahi wre me don me hla wu gbugbu ndi bawa nkon iri wakran. ");
INSERT INTO jid_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Indi u koh'a nita wlu nda tro nkon tra ye to ka u kli ni ra ndi wuru nkon ndi tre, Baci, Baci bwa nkon'a tawu. Ani sayiwu, mena toyi na koiwrji wa bi rji na. ");
INSERT INTO jid_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","U bi tre, ki rli ndi soh ni shishi me di bla tre Rji ni nkon bi mi gbumbu. ");
INSERT INTO jid_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amma ana akasa, me hla yiwu, me na toh wrji ba bi rji'a na. K'ma dimu biyi bi wa bi tie latre'a ");
INSERT INTO jid_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Iyi mba tan nyinyren kabi to Ibrahim, Ishaku, Yakubu ni anabawa ba wawuu ni mi mulki Rji amma ba truyi hle ra. ");
INSERT INTO jid_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Baye rji ko Nzan, Yalu, Koshu mba ni kogbo nda son ni tebru u mulki Rji. ");
INSERT INTO jid_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","To mba biwa ba yaba hlega babi mumla, u bi wa ba yaba ti ndi'a ba kati u klekle. ");
INSERT INTO jid_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ni mi nton kime farisawa ban baka ye u nda tre, hi di don bubuyi don Fero niwa wuu. ");
INSERT INTO jid_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu tre, hi ndi hi hla ni tsi mba to mba me zu brji di ni denbi lilo luwa mba mble uni vi u tra me kle kpie wa me yo suron'a. ");
INSERT INTO jid_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko anita he ni he me, ahi gbigbi nimu ndu me si tindu rji luwa, imble ni vrli ni tu wa bana nime ndu ba wuu anabi ni wrji ri na sai urushalima. ");
INSERT INTO jid_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Urushalima, Urushalima a nha wuu anabawa ba nda ta bi wa ba ye ni yi ni tita? Abi yo sron bita mena hewu ndu me vu mrli mbi hra nawa yi kuko ni vu mrli hra krju tie ni ngbam ma na, amma bi na son to ki na. ");
INSERT INTO jid_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Toyi, iko mbi kli hlega. Me hla yiwu, bina toh mena sai bi tre, lulu ahi, indi wa aye ni nde u Baci. ");
INSERT INTO jid_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ni vi u chachu sati ri, wa a ri ni koh bi ninkon Farisawa ri du rhi biri, ndji ba sru shishi ni wu. ");
INSERT INTO jid_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","se ga ndi “U” lilo huk kpa. ");
INSERT INTO jid_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ya da mye bihan vuvu baba Farisawa, abi du ba chu lilo rju ni chachu sati ko an an? ");
INSERT INTO jid_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","U ba sun ngbangbi, Yesu ka vu ni wo lunde da chu lilo rju niwu, da du hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesu mye ba, ahi nha ni mi-mbi, inde vren ma, ko napron ma aku ni juju ni chachu sati, wa ana chu na? ");
INSERT INTO jid_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bana kasa niwu na. ");
INSERT INTO jid_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Da Yesu si ya ba da toh bi wa ba you ba ye, ba wa bubu sun bi ni koh, watre kayiyi, nda tre. ");
INSERT INTO jid_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Inde ba you hi ni bubu gan u gran na kuson ni bubu bi ninkon na, ani yiwu ba you ndi wa a zawu. ");
INSERT INTO jid_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Inde ndji wa a you yi ha bi, aye, a ni tre no bubu sun me, “u shan ni ti'u, u” wu kma hi ni bubu bi kalachu. ");
INSERT INTO jid_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Inde ndji wa a you, a tre kpamu hon ye ni wayi, nakima, u ndji ba, ba no ninkoh, bana kpa wu tsri na. biwa bi son baba ni tebru'a. ");
INSERT INTO jid_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Indji wa a nzu tuma, baka ka tuma grji, wu wa u katu me grji, ba nzutu me hi shu. ");
INSERT INTO jid_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu hla ni ndji wa you ye, inde wu ta ni yo ndji ye ri biri, ko ni gan, u ka na yo kpukpan me na, ko mri vary me na, ko malan me na, ko bi kutra kahlan mena bi nklen na, baba me ba you ngame, wandi ba njiye niwu. ");
INSERT INTO jid_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ba tie lulu yo don bana ban ni wu na, ");
INSERT INTO jid_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","inde wu yo ndji ye ni gan me, u ka yo bi kalanchu, ni bi wa bana he ni gbengblen na, ni bi kple zah, ni bi fie, ba tie lulu you don bana he ni kpe wa ba han wu na. Don ba tie lulu yo ni chachu wu lunde bi kinklan suron. ");
INSERT INTO jid_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Da indji ri wa a son ni tie bru ni Yesu awoh tre a, nda tre, ba tie lulu yo ni ndji wa ani rhi biri ni koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu woh da tre ndi ndji ri atie gan rigra ma nda yo ndji gbugbu-u. ");
INSERT INTO jid_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Da inton wu gan a tie, wa a ton ivren koh ma du hi hla ni bawu du ba ye, biri a we ye. ");
INSERT INTO jid_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wa wu bawu, bana yena, u mumla a tre ndi wawu le rju, wawu ni bi toh wru hle ni mu. ");
INSERT INTO jid_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","U na tre wawu le lando bi zran ton, mi yi tsra ba toh, mi bre wu, du wru hle ni mu. ");
INSERT INTO jid_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","U tra a tre ndi wawu gran wa, naki mina ye na. ");
INSERT INTO jid_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Da vren koh aye hla ni ti-koh ma ikpe biyi, u ti koh ma ka tie nfu, nda hla ni vren koh ma du hi gbagbla ninkon bi gbu i, ni kosan gbu, nda yo biwa bana he ni gbengblen na, ni bi chiche, ni bi fie baba bi kple zah. ");
INSERT INTO jid_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Vren koh a tre, iti koh, ikpie wa u tre a kle hra zizan bubu a na shu na. ");
INSERT INTO jid_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Se ndji u koh ka hla ni vre koh ma hi nikoh ni kosan gbu ndi yo gbugbu ndji du ba ye du koh mu shu. ");
INSERT INTO jid_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mi hla ni yiwu, biwa mi you ba ni mumla ba na ye kpe ni iye u muna ");
INSERT INTO jid_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Basi zren ndji gbugbu basi hu, wa hla ni bawu, ");
INSERT INTO jid_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Du ndji wa ani ye nime, ndana kama ni tima na, mba iyima, ni iwa ma na, ni mri ma, ni mri vayi ma, mri lon baba mri mba ba, hra ni dri ma na, ana ya zama vren koh muna. ");
INSERT INTO jid_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Indji wa ana he ni suron u ban giciye nda ye hu me na, ana ya son u vren koh mu na. ");
INSERT INTO jid_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ahi nha nimi mbi wa ani son be koh wu shu, nda na bla inklen wa ahe ni wu, ko ani tsra u, u me koh, ko ana tsra na. ");
INSERT INTO jid_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inde a zi nchi koh'a, kana kle meh na, u biwa ba meh baba ba ka nza'u, ");
INSERT INTO jid_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ba ta tre toh ndji ani son meh koh, ana ya meh kle na. ");
INSERT INTO jid_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A chu rime ani hi taku ni chu ri nda na son nda bla bi taku ma toh ni mumla, ko soja ma bi gbengblen ba kai dubu wulon wa ani ya kbu tu ni chu rima mu wa a he ni bi gbengblen dubu shirin. ");
INSERT INTO jid_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","To inde an ya na, ka wa sun si ni chu rima. ");
INSERT INTO jid_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Naki ba ndi wa ni mibi wandi ana ka kpe wa a he ni chu wo na, da ani ya k'ma tie vren koh mu. ");
INSERT INTO jid_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ima a kpie ndindima, inde imma a sa ba mla tie ni ni ngyen? ");
INSERT INTO jid_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ana labi gana, sei baka ka hlega, ka kma tie toki ni meme, ndji wa ahe ni ton ka wo. ");
INSERT INTO jid_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ni bi kpa ban ni bi lah tre ba wa Yesu ye nasi wo wu. ");
INSERT INTO jid_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisawa ni bi nha wawu mba u baluni chi ba gurgu ni kpa mba ndi, “I gu yi ani kpa bi lahtre nani ri la me niba.” ");
INSERT INTO jid_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu tre ka yiyi ni ba wu na yi. ");
INSERT INTO jid_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","A nha nimi mbi, nita he ni nt'ma deri, u iri kado, “wa ana ka teseyi don tiya don (99) na hi wa iriri njiye na? ");
INSERT INTO jid_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","I dan a ka toh wu, ani ban sah kan to na ngyiri. ");
INSERT INTO jid_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Inde a k'maye ko, ani yo kpukpan ma, ni mri vayi bi yiu nkon kahlan ma kabi, “Ye ki ngyiri mi ka toh nt'ma mu'a wa a kado a. ");
INSERT INTO jid_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi hla ni yiwu, ahe naki me ni shu me, ba ngyiri nitu indji iriri u lahtre wa a tuba'a zan indji teseyin don chiya (99) bi wa bana lahtre na. ");
INSERT INTO jid_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ka ana he na iwa wa ahe ni glegbe nklen a zurfa wulon, u glegbe ri ni mi ma a nawo chuku miko kado, ana mbru lu yo ni fitila ma vu kagon sran ma na wa glegbe inklen, wa a nawo kado na? ");
INSERT INTO jid_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Inde a toh, “ani yo kpukpan ma ni mri vayi bi yiu kon kahlan ma wawu ye, na hla ni bawu,” ki ngyiri, mi toh glegbe iklen azurfa mu wa a kado'a ye. ");
INSERT INTO jid_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ko na ki me, “Igir he ni shishi maleku Irji ni tu indji riri u lahtre wa a kpa tre Irji sisah, a (tuba). ");
INSERT INTO jid_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","U Yesu tre a ndi indji ri he ni mri hari, ");
INSERT INTO jid_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ivren tsitsa, yo tima, “Iti mu, “ne” ikpi wa a ni u mu ni mi wa (dukiya) mewa u he ni wu'a “ u timba a vu ikpi bi wo ma ga ni bawu hamba. ");
INSERT INTO jid_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wa a na gbron knkon na, u vren tsitsa a kblu kpi wa ba ga ba wa'a ye sru ba ni wrji ri, na vuba, ri hi ni migu gbugban mu, hi zren ma ni gbungblu, “naka ri uma kle. ");
INSERT INTO jid_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","U iyon nri ni gbu'a kagon wawu'u meme da ndi me. “I wa lu ni wa kpi u ri (iya vu). ");
INSERT INTO jid_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wa hi na ka wa ndu niti ni guri ni mi gbu'a, “Wa, ton hi ni rju mari ni ndu ta no lede ma biri. ");
INSERT INTO jid_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wa tie tilan u ri gbala biri wa lede ba ri don mbru'a. ");
INSERT INTO jid_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","U, imeme ma ye niwu nikpa ma, “Wa tre, A hi gran bre Itie mu vu ba ndu na ni nhan ba, u ba rila ma lan tu ba u mi son ni tiya ni yon. ");
INSERT INTO jid_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi lunde, ni wa yi hi ni itie mu, “ni bre wu, “Itie mu, mi lahtre ni shulu mba ni wu. ");
INSERT INTO jid_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na ban me ti vren me na, “Ban me tie na iri ni mi gran me wa ba tie ndu niwu. ");
INSERT INTO jid_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","U vren tsitsa lunde k'ma ye ni itie ma, wa aa ri he gbron kon ria u itie'a toh, na ya lo suron, na tsutsu ka kriu wu na ma wu yiu. ");
INSERT INTO jid_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","U vren tre, Itie mu, mi lahtre ni shulu ni lah tre ni wu, mi na la son ndu yo me tie vren me na. ");
INSERT INTO jid_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","U itie ma hla ni gran ma ri ni ndu hi ya inkon lon ndindima iri na ban ye, sru niwu na ban zobe ye yo niwu ni wo ni lagban ye son ni niwu ni zah. ");
INSERT INTO jid_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ni hi vu Ikrju u gon gon ma ye han wa niki ti gan. ");
INSERT INTO jid_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ivren mu ana kyu, zizan a he ni re ");
INSERT INTO jid_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","U vren ni kon'a, a na he ni rju. Wa ye whibuhir ni ko na wo ba tsi kangan na ni yo se na ni nglu. ");
INSERT INTO jid_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wa yo iri ni mi igran ba, na miyen a ndi a hi nge itu kpi yi. ");
INSERT INTO jid_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","U igran hla ni wu, anitu wa tsitsa me a kma ye koh, u tie mendu ba nhan kikle krju u gon gon ma ni tu wa a kma ye ko pyan me. ");
INSERT INTO jid_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","U ninkon ma tie nfu na kama ri koh, u itie mba a rju ye bre wu. ");
INSERT INTO jid_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Vren ninkon lu miyen itie, “Ya Ise gbugbu wa mi tiya niwu, mina kamu ni wo tre mena, i wu na taba ne vren yawo ri ni ndu me kpa han tan ni kpukpan mu na, ni toh ro mana. ");
INSERT INTO jid_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","U vren me mba ye, iwa aka yan wo me kle ni bi ti ntran, “U ye nhan kikle ikrju niwu. ");
INSERT INTO jid_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itie ma yo, Ivren mu, u he ni me koko ni tana Ikoh nge wa mi he ni wu'a a hi u me. ");
INSERT INTO jid_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mi toh abi ni tawu ndu ki ta tie gan, ni ta ngyiri, ama vayi me yi na kyu, “I wa he ni re zizan, ana kado, u ki la toh. ");
INSERT INTO jid_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu hlani mri koh ma, (Almajirama) “A ndi igu ri he niwo (arziki) na he ni indji wa ani ya bi ndu ni wu'a, U ba ye hla ni wu indji iwo, andi igu ya bi ndu ma a ri woma ni hi kle. ");
INSERT INTO jid_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Indji iwo'a a yo na miyen ahi nge mba mi wo? Ne lisafi ikpe wa u tie ni ya ndu'a u na la tie ndu, u ya indji ngana. ");
INSERT INTO jid_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Igu u ya indji ba (wakili) a ta mre, “Ahi nge mi ti, tun nde itie koh mu a vu me kpa ndu u ya? Mina he ni gbengble wami ya ron na, Ishan ni ti me mi na ya bre na. ");
INSERT INTO jid_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mi toh kpe u wa mi tie'a inde ba zu me ni ndu u ya indji (wakili), indji ba ka kpa me hi ni koh mba. ");
INSERT INTO jid_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ayo bi wa itie koh ma ni huba ihlah, a miyen u mumlan, 'Ahi bren itie koh mu ni hu?' ");
INSERT INTO jid_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Andi uma a Garuwa Iyen Deri. Wa hla ni wu, kpa nvunvu u nha me, gbagbla nha hamsi (50) nihi kuson kpa me ni ka don. ");
INSERT INTO jid_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wa hla miyen ri, ibren ba hu? Wa tre, buhu alkama dari wa hla niwu, kpa nvunvu yi, ni nha tan mani ");
INSERT INTO jid_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","U tie koh ma kber igu lah tre san nitu wa a tie whiri, imlen imri bi, zizanyi ni indji mba, ba whiri zan imri bi kpan. ");
INSERT INTO jid_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mijhla ni yiwu tie kpan nitu he niwo wa ana bie na. Wa ye nna wo kle, u ba ka kpa yi hi ni koh wa bi son hi ni tuntur. ");
INSERT INTO jid_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Indji wa ni tie njanji ni kpi tsitsa ma, A ni ti njanji ni rhi grama, u indji wa ana tie njanji ni kpi vi tsitsa mana, ana tie njanji ni kpi rigra ma na. ");
INSERT INTO jid_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Inde u na tie bi ni wo wa ana u njanji na, u nhan ni kpa nyewme ni wu ni wo u njanji? ");
INSERT INTO jid_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Toh wu na ni tie njanji ni nji kpi u bari na, anha ni no wu inkleh u me? ");
INSERT INTO jid_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ba indji wa ani ya biu tie ko hari, ni mi nton riri, se ka kpa ri na kari don, koh ka kpari tsri na kpari nyime. U na ya hu Irji mba inklen na. ");
INSERT INTO jid_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisawa bi wa ba son inklen kpukpome'a ba wo tre naki wawu na nzah. ");
INSERT INTO jid_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wa hla bawu, 'Biyi bi ban tu mbi ni shishi ndi ni kperi, ama Irji toh mi suron mbi. Ikpi wa ndi ba kpanyime niwu wawu, ahi kpi u shan ni Irji. ");
INSERT INTO jid_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Attaura ni Litafi Anabawa ba he si ye ni ye Yohana rji ni nton ki ye zizan yi, ba tsikpa bubu bla tre Irji, indji wa wu ba ri ti tu ni gbengblen ni yo tu mba niwu. ");
INSERT INTO jid_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A hi fie me ni shulu mba ni meme ndu ba su e tu ni wa, iten riri u Attaura ndi joku migen. ");
INSERT INTO jid_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Indji wa a ga gran ma ni Iwa-ma na kpa iwa ri a zina a si tie, ni nidji wa a kpa iwa wailon ma zu a hi zina a si ti. ");
INSERT INTO jid_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Indji iwo ri a shur kpimabi tie le nani zren zren ma ko ni nton ri meh. ");
INSERT INTO jid_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","U indji u bre ri ba yo ni Lazaru ba nji ye ka yo ni nkotra koh ma, ni kpukpa inkpa-n ni kpa, ");
INSERT INTO jid_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wa ni son rhi birhi wa a kuble ni tu tebru, u yawu ba ye nle kpa-n. ");
INSERT INTO jid_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wa ye tsra ni nton wa indji u bre a ye kyu, u Maleku ba ye ban hi ni nhma ko wa Ibrahim he. U ndji u wo'a (arziki) a kyu u ba ban ka rju. ");
INSERT INTO jid_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","wa ka ri ni koh lu, wa zun shishi hi ni shu, na toh Ibrahim gbugban mu ba sun mba Lazarus ni ngbala ko wa Ibrahim he. ");
INSERT INTO jid_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wa yra yi yo, Itie mu Ibrahim, toh me ni lo suron ni ton Lazarus, ndu ka vren wo ma son ni mma, na chu kpi yo ni mu ni lbe ndu jubu gbugbran mu. ");
INSERT INTO jid_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ibrahim tre vuvren, Rimre ni sun me ni gbungblu, u rhi ro wo me ni kpa kpi bi bie ma, u Lazarus si tiya, u zizan mba ba ndu si toh roma ni wa, Iwu mba u si tiya. ");
INSERT INTO jid_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","U naki me ba shi juju ni tsitsu bi vron me, ni ndu bi wa ba sun zagran ye niyi ba ka na yana, kuma biwa ba he ni yi ko mba ba ka na zagran ye nita na. ");
INSERT INTO jid_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","U indji i wo tre, mi bre wu, Itie mu Ibrahim, u ka ton hi ni koh itie mu, u ngrji'a - ");
INSERT INTO jid_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mi he ni mri vayi mri-lon iton, ndu hi hron ba ni ndu ba na ye ni bubu yi na. ");
INSERT INTO jid_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibrahim hla niwu, ba he ni Musa ni anabawa, ndu ba wo ba. ");
INSERT INTO jid_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","U indji i wo, a sa niwu andi, A'a Itie mu Ibrahim, indrjo ri ni ta rji ni mi bi kyu ka hla ni bawa, ba k'ma suron mba no Irji. ");
INSERT INTO jid_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","U Ibrahim hla niwu, inde bana wo Musa ni anabawa bana, ko indji wa a kyu lunde na ka hla ni ba wu bana wo wu na. ");
INSERT INTO jid_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu hla ni imri koh ma, A lele ndi ba kbu za ni tita iya mbi wa wu sa ahe ni krigin. ");
INSERT INTO jid_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ana bi bana klo tita wu ni toh ma nda kayo nimi nne fi niwa ni tsa iri ni mi imri bi tsitsa yi diba kbu za. ");
INSERT INTO jid_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ya kpambi, wa vayi ma lahtre, bwu shishi niwu, nda a kpa nuyime wruhle niwu. ");
INSERT INTO jid_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nda kpalla niwu inkpu tangban ni vi ri, nda k'ma ye niwu inkpu tangban nda tre, mi brewu, abi du wruhle niwu. ");
INSERT INTO jid_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bi ninkon ba hla ni tie kon mba, nzu yo suron buu. ");
INSERT INTO jid_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Irji hla ndu bi he ni bangaskiya kama wlo mustard, bi iya hla niku kro du rumin chu di tsen nimi nei, A kpa nyime niwu. ");
INSERT INTO jid_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A nha nimi mbi, ahe ni vren koh wa ni rho ko krju int'ma rhi rji mi ji ye, ani lla niwu tsima ye ndi ri lah. ");
INSERT INTO jid_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ana hla ni wuna, wa kpe mi ri, ndi khi di tie ndu bar mi ri ndi tso. U me wru ndi tsro na? ");
INSERT INTO jid_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ana gir ni wer kon du a tie ikpa wawu la una a tie? ");
INSERT INTO jid_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iwu me naki yi nda u tie kpe wa ba hla niwu, u ya tre, kbi na khai mri koh ..... ma. Kbi tie ikpe wa kbi na tie. ");
INSERT INTO jid_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A bi fin ri atsi tie ni Wurishelima, abu kusa nei gbu Samariya ni Galili. ");
INSERT INTO jid_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wa ari ni gbu ri, ndji wlon bi lilon gben ba izun ni wu. Ba klir gbugbanmu niwu. ");
INSERT INTO jid_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ba bwu ba ni fu ba, nda tre, Yesu nikon wo iyi mbu. ");
INSERT INTO jid_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wa ato ba, ahla ni bawu, hi ndi tsro tumbi ni Firistoci. Wa ba tsi bi, ba kpa sikpa. ");
INSERT INTO jid_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iri nimi ba wa a to wawu samu sikpa, a kmaye, nda ngyiri ni Ijri ni la ndindima. ");
INSERT INTO jid_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A joku ni kbu Yesu, nda ngyiri niwu gbugbome wawu a ndji igbu Samariya. ");
INSERT INTO jid_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu la bana ndji wlo na wa samu sikpa na, itiya ba bahe ni ntsen? ");
INSERT INTO jid_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba bari wa ba kmaye nda ngyiri ni Irji, tse ndji tsri yi? ");
INSERT INTO jid_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A hla niwu, lunde ndi he ni suron ndindime anu sikpa ma. ");
INSERT INTO jid_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisawa ba mye Irji ni ye ni ntan, Yesu hlani bawu ndi Irji ana ye iri iya ndi na. ");
INSERT INTO jid_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ko ba la yah, ahe iyi koh ahe wamu. Bi ka yah iye Irji ahe aniwu. ");
INSERT INTO jid_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A hla ni imri koh ma, i vin tse ye wa bi son toh ivi wa ivren ndji niye, bi na tona. ");
INSERT INTO jid_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba hla niwu, yah, ni wamu, yah niwa hi na rju na, na bu ba na. ");
INSERT INTO jid_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ya nda izren ni whri nda kma tsutsa wa ni whri gbagbla shu yi ni gbagblamu, ani he nikiyi ivren ndji ni vin ma. ");
INSERT INTO jid_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","A ni sha yah gbugbu kri gbugblu bakaba wu. ");
INSERT INTO jid_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","A ni he nawa ahe ni nton Nuhu, ani he nakiyi ivi u ivren ndji. ");
INSERT INTO jid_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ba nri, ba tso ba grah nde ninu grah har hi tub wa Nuhu anri ni Jirgi imah tubana ayeh, nda wu ba penpeme. ");
INSERT INTO jid_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A he na kiyi ni tan lutu bata nri, bata tso bata lbe nda lebie bata shu bata meh ba koh. ");
INSERT INTO jid_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ivin wa lutu rju ni Saduma, ba tsra lu kwekwema rji ni shu bawu ba u ahuwu. ");
INSERT INTO jid_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ani he na kiyi wa ba ton vren ndji. ");
INSERT INTO jid_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ni vi khi yi, indji he ni tun khan du ma ngrji da ni vu kpima ni kon na, wa ahi ni rju du na kma ye na. ");
INSERT INTO jid_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rhi mre iwa Lutu. ");
INSERT INTO jid_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wa ni son tuma, ani rasa niwu, wa k tuma nu, ani tsira niwu. ");
INSERT INTO jid_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi hla niwu, ni chu kiyi ndi ha ni tub blah riri, baba ri nda ton ri. ");
INSERT INTO jid_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Imba ha ba si kon kpu ba ka ban ri, nda bri rima. ");
INSERT INTO jid_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ndji lulo bari ba hi ni rju, ba ban ri nda bri ri. ");
INSERT INTO jid_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ba mye, ni ntsen Tie koh? A hla bawu iwirji igbokpa ahe, ni kiyi bi ton ugulu. ");
INSERT INTO jid_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A lu tre ni tre ni bawu nitu duba ta bre Irji chachu nda na tie suu na. ");
INSERT INTO jid_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A hla ndi “Ni gbu ri, ndji wu han tre njanji ri a he wandi ana tie sissri Irji na, dana toh ndji ngame ni nfutu na. ");
INSERT INTO jid_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Niki, iwari wu s'ro ri ason ni gbu'a ngame. A ta hi ni ndji wu han tre njanji chachu nda bre ndi, “Zome kpa ikrji mu niwo bi yo me ni shishi. ");
INSERT INTO jid_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A ban nton gbaa me ndana son zo na. A son ni vi ntor ri nda rhimre kikima, nda hla ni tuma ndi, “Mina ti sissri Irji na, nina ya ndji ni nfutu ngame na. ");
INSERT INTO jid_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nitu du iwayi na nne iya ni ye bre ma chachu na, Mi zo u kpa njanji ikrji ma nduna lo me kpa ni yema na. ");
INSERT INTO jid_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","I Bachi a tre ndi “wo tre andi ndji wa ana han tre njanji na a hla. ");
INSERT INTO jid_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Zizan Irji ngame na nji njanji ye ni bi wa a chu ba, ndani yi yo'u chachu ni Irji mba ni chu na? Ani tie sesren ye gbagbla ni ba? ");
INSERT INTO jid_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi hla yiwu ndi, ani ye ni njanji ni bawu gbagbla. Nikima vren ndji nita ye, ani ye toh nime ni gbungblu meme? ");
INSERT INTO jid_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Me a lu tre toh choloncho ni bari wandi ba yo suron ni gbengblen mba, ndi ba zren tsatsra ndani ya bari grji tu, ");
INSERT INTO jid_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ndji ha ba hon hi ni tra Irji nda hi bre, iri ana Farasi, i rhima bi kpa iban. ");
INSERT INTO jid_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasi a lu kri ni zande nda bre ni tuma ndi, 'Irji, mi ngyiri nitu mina he to ndji bari na - bi y'bi, bi lahtre, bi humba, ba bi kpa ban too ndi yi. ");
INSERT INTO jid_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mi zu kpa mu rhi biri nkpu ha ni sati. Mi nu zakka (iri nimi wlon) nitu wawu kpi ndi a ri nime.' ");
INSERT INTO jid_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ndji wu kpa ban'a a kri gbagban nda na nzu shishi hi ni shu mena, wru wo ni san nda tre ndi, “Irji, ya me ni lo suron, ndji wu lahtre.” ");
INSERT INTO jid_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mi hla yiwu, igu hi a kma hi kpama ni si suron zan ndi rima'a, nitu ndji wandi a nzu tuma hi shu, ba gbron grji, i wandi a ban tuma grji (nitu ana kpe na) ba nzu hi shu.” ");
INSERT INTO jid_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ndji ba basi'a nji mri tsitsa ni du sa wo ni tu mba, i mri koh bi nduma ba to ba nda puaha tre. ");
INSERT INTO jid_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","I Yesu a yo ba ye ni kpama nda tre ndi, “Du mri bi tsitsa ba ye nime, na zu ba na. Ikoh Irji ni shulu a wu biwa ba he to mba. ");
INSERT INTO jid_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tre njanji, ndji wa na kpa ikoh Irji to mri bi tsitsa na, ana ri mi na. ");
INSERT INTO jid_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","I chu mba ri a mye ndi, “Ticha ndindi, mi tie ngye ri ni kpa ko Irji?” ");
INSERT INTO jid_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu a hal wu ndi, “Nitu ngye wu yome ndji ndindi? Ndrjo na ndindi na se Irji kankle ma. ");
INSERT INTO jid_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bi toh doka Irji na tie nka na, na wu ndji na, na y'bi na, na nu sheda che na, wo tre time mba yime.” ");
INSERT INTO jid_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ichu a tre ndi “Mi zi hu kpi bi mba wawuu rhi ni nzemu.” ");
INSERT INTO jid_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu a woo nda tre ndi ikpe riri rhi don, hi le ni kpi wandi wu he niwu ni gah ni bi ya, i wu he ni lada ni shulu, ni ye huma.” ");
INSERT INTO jid_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ni wa ichu a wo tre, a loh suron kpukpome, nitu ana ndji wu wo. ");
INSERT INTO jid_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ni wa Yesu a toh kma ti gbon me ni lo suron (gbugbu chiche tre vunvu ni Greek ba sa tu tre ndi a kma ta lo suron/ama gbugbu bari bana he ni lan kima na), a tre ndi, “Ani he ni du du ndi wu wo du rhi ni koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A he ni du ni ndi wu wo du ri ni koh Irji, zan du ra kumi ri zu ni shishi n'ro.” ");
INSERT INTO jid_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bi wa basi'a wa'a ba tre ndji. “I nha ni nawo?” ");
INSERT INTO jid_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu a sa ndi “Ikpi wa ba he ni iya tie ni ndji bana he ni iya ni Irji na.” ");
INSERT INTO jid_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bitrus ngame a tre ndi, “Toh, ki bri wawu kpi mbu ndi hu.” ");
INSERT INTO jid_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu a kma tre ni ba ndi “Njanji, mi hla yiwu, ba ndji wa a don ikoh ma, ko wama, ko mri vayi ma, ko ba ti ma, ko ni mri ma nitu ikoh Irji, ");
INSERT INTO jid_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wandi ana kpa zan zizan na, ni vi ye, i vri rji wu sisenise.” ");
INSERT INTO jid_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A yo ndji wlon-don-ha ba ye ni kpama nda hla bawu ndi, “Toh, ki si yi ni Wurushelima, i wawu kpi wa anabawa ba tere nitu Vren Ndji'a ba tie toki. ");
INSERT INTO jid_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba banwu nu biwa bana mri Israila na, ba nzau, nda nu shan nda ju nte sru niwu. ");
INSERT INTO jid_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba ti tsiwu, ba wuu, i ni vi wu tra ani lunde.” ");
INSERT INTO jid_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ba na mla to ikpi biyi na, i lan tre ana ri nibawu, niki bana mla toh ikpi wa a tre na. ");
INSERT INTO jid_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Niwa Yesu a ye wiewire ni Yeriko ndji wu infyen ri a son si bre ni nyu nkon, ");
INSERT INTO jid_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ni wo kpaa ndji basi zren ni zu whiwhre niwu, a mye ka ngye si zren. ");
INSERT INTO jid_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ba hla wu ndi Yesu wu Nazarat-akasi hi. ");
INSERT INTO jid_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ndji wu infyen a yra gro nda hla ndi, “Yesu Vren Dawuda, ya me ni lo suron.” ");
INSERT INTO jid_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bi wa bisi'a zren ni ko shishi ba puatre ni ndji wu infyen nda hla niwu du son gbangbi. A kama nda si kpa gro ndi, “Vren Dawuda, ya me ni lo suron.” ");
INSERT INTO jid_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu a kri kpenme nda nu tre du ba ji igu'a ye niwu. Niwa ndji wu infyen a ye whiwhre, Yesu a mye ndi, ");
INSERT INTO jid_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wu son du mi ti ngye ni wu?” A tre ndi, “Bachi, mi son toh ni shishi mu.” ");
INSERT INTO jid_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu a hla niwu ndi, “Kpa toh ni shishi me, kpanyime me a nu si kpa. ");
INSERT INTO jid_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hari, a toh ni shishima nda hu si yo ise ni nzu nde Irji. ");
INSERT INTO jid_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ari si zu ni Yeriko. ");
INSERT INTO jid_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","U ndji ri he ni ki ni nde Zakka. Ana ndji u kpa haraji nda he wo. ");
INSERT INTO jid_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A wa nkon wa ani to ka nha hi Yesu amma nda mha njima wokran don gbugbu ndji ba u don aku nkpurju. ");
INSERT INTO jid_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A tsutsu guchi ni ndji ba hi ko shishi nda ka hon kunkro (Sycamore - durumi) nda ka don towu; don Yesu a tie whiwhre u zu nkon kima. ");
INSERT INTO jid_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Da Yesu ye ni bubu'a, a nzuya shu nda hla wu, “Zakka, grji ue gbagbla, don luwa gbigbi me son koh me.” ");
INSERT INTO jid_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","U wa grji nitsu me nda ye kpa ni ngyiri. ");
INSERT INTO jid_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Da ko nha a toh, baka na son na wawu mbawu, nda tre, “A ye hi ziri ni koh ndji u lahtre.” ");
INSERT INTO jid_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka kri nda hla ni Bachi, “Toh mba Bachi, nh'ma ha u kpie me he wu'a me nno bi ya, mba u mita mla ndrjo kpieri, me nno nkpu nza rjula.” ");
INSERT INTO jid_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu hla niwu, “Luwa cheto aye ni koh yi don wawu me ahi Vren Ibrahim. ");
INSERT INTO jid_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","E, Ivren Ndji a ye wah nda kpa bi wa ba kado'a chuwo.” ");
INSERT INTO jid_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Da ba wo tre ba, a trenda hla misali ri ni bawu, ka ahe whiwhre ni Wurushelima, u ba ban koh mulki Irji tiewhre u ye. ");
INSERT INTO jid_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A tre towa, “Indji ri wa ani to tie a hi ni gburi gbugbanmu nda hi kpa chu nda kma ye. ");
INSERT INTO jid_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A yo mri koh ma wlon nda nno ba pa wlon, nda hla bawu, 'Hi kasran niwu gbien kma yemu.' ");
INSERT INTO jid_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amma indji ma ba kranwu nda nton ndji mba bari hu gonma nda hla, 'Kie na kpanyime ndi ndu ndi yi ndu chu mbu na.' ");
INSERT INTO jid_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ba he wa aka kpa chu nda kma ye, a ndu ba yo gran ma ba wa anno ba inklen nda to riba wa ba tie. ");
INSERT INTO jid_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","U mumla a ye niwu nda tre, 'Bachi mu, pa me'a wa une'a a nji pa wlon ye nha.' ");
INSERT INTO jid_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ichu'a hla wu, u toh tie, u gran ndindi, Ni wa u toh tie ni kpie tsitsa ma, u he ni igbu zan wlon wa wu nji mba.' ");
INSERT INTO jid_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","U ha ye nda tre, pa me Bachi, a nji pa ton bari ye.' ");
INSERT INTO jid_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ichu'a hla wu, 'U kpa gbu ton wa wu nji'a. ");
INSERT INTO jid_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Iri ye nda tre, Bachi, ngye pa me'a yi, mi ka ri mlazi ni mi kpi, ");
INSERT INTO jid_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","don mi klu sissri me, don u ndji u nno ya. U ban ni bubu wa una zi'a na. ");
INSERT INTO jid_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","U chu'a hla wu, 'Ni tre u nyu me ba me han tre'a nitu me, wu meme gran. Wu toh ndi mi ndji wa mi wa bran, ni ban ikpi wa mi na kazi'a na, u me hi vu ikpie'a mi na chuna. ");
INSERT INTO jid_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Don ngye una yo nklen ni banki toh mi na kma ye mika kpa nha ni a hon tuma (riba) na? ");
INSERT INTO jid_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ichu'a hla bawu wa ba kri wu'a, 'kpa pa wa ahe ni wu'a, ndi ka nno u pa wlon'a.' ");
INSERT INTO jid_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba hla wu, Bachi, a he ni pa wlon.' ");
INSERT INTO jid_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mi hla yiwu, indji wa a he wu'a, ba nno tia, amma uwa a hama wu'a, ba kpa mbru wa ahe niwu. ");
INSERT INTO jid_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amma biyi, bi yo shishi nime, bi wa bana nyime ndu me chu mba na, nji ba ye wayi ndi wu ba ni shishi mu.'” ");
INSERT INTO jid_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Da a hla tre bi yi, a vu gon ma hi Wurushelima ");
INSERT INTO jid_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba he me wa a ye whiwhre ni Baitfaji mba Baitanya, nitu ngblu wa ba yo ndi Zaitun, wa ka ton mri koh ma harhi, ");
INSERT INTO jid_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ndi, “Hi nimi vi gbu wa ahe ni ko shishi mbi'a. Bita ta ri, bi toh vren nakpron wa bana honwu to na. Siwu ndi njiwu yemu. ");
INSERT INTO jid_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Indrjo nita mye yi, 'Bi siwu ni ngye?' Bika hla, Bachi mba ni son.'” ");
INSERT INTO jid_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Biwa ba ton ba, bahi nda kato vren na pron'a towa Yesu a hla bawu'a. ");
INSERT INTO jid_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Baka ki si vren nagro, kikima baka mye ba, “Bi si vren nakpron ni ngye?” ");
INSERT INTO jid_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","U ba tre, “Bachi ni son.” ");
INSERT INTO jid_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba nji ye ni Yesu, nda lba ba kpi mba ni tu vren nakpron nda ban Yesu sa tuma. ");
INSERT INTO jid_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Da si zren, baka lba ikpi bi sru kpa mba ni tu nkon. ");
INSERT INTO jid_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A tie whiwhre ni blaba ngblu Zaitun, u gbuj'bu mri koh ma baka ku'u ngyiri nda ni gbre Irji san ni ngyiri kpukpo me nitu wa ba toh ikpie wa atie'a wa nno ba sissri, ");
INSERT INTO jid_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","nda tre, “ Lulu a hi'u chu wa asi ye nimi nde TieTie! Salama ni shulu daraja wa a zan dauka!” ");
INSERT INTO jid_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisawa bari nimi jbu hla wu, “Ticha yra nha ba” ");
INSERT INTO jid_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu a sa bawu, Mi hla yiwu njanjimu, biyi bata ki ngbangbi, tita ba yra gro.” ");
INSERT INTO jid_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wa Yesu tie whiwhre ni gbu'a, ayi nitu ma, ");
INSERT INTO jid_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nda tre, Bina toh wiyi, ko bina toh ikpi wa ba nji salama ye yiwu! Amma zizan ba riba ni shishi mbi. ");
INSERT INTO jid_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ivi ni ye niwu wa bi kamba niwu ba me gle kagon me, nda mau krju tie. ");
INSERT INTO jid_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba tsenu hlega meme ni mri me. Ba don tita ri nitu ri na, don una toh inton wa Irji sison zo nda kpa'u chuwo.” ");
INSERT INTO jid_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu a ri ni tra Irji nda tsihi ka zu bi le ");
INSERT INTO jid_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nda hla bawu, “Ba nha zi, Ikoh yi ani koh u aduwa amma u bi ka tie iwru bi y'bi.” ");
INSERT INTO jid_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu ahe nda zi tsun ni tra Irji cacuwu, Amma, Firist bi ninkon ba ni nha ni bi ninkon u nda ba, ba wa nkon u wu-u, ");
INSERT INTO jid_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","amma bana toh nkon na, don indji ba siya wowu. ");
INSERT INTO jid_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Baya viri wa Yesu ata bla tre ma ni Urushelima, indji biwa ba he nimiyi, wu Firistoci wu malamai Attaura wu shugabanni ba cimiye niwu. ");
INSERT INTO jid_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ba tre niwu, “Hla nitwu ni kpekpele nha wuse tindu ba, wu a nha mba ano kpekplemba.” ");
INSERT INTO jid_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A kpa ye nibawu nda tre, “Imeme miyi tre yi bika kpayi ni mu. ");
INSERT INTO jid_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Isukpa nima Yohana, ani yi nishu ko ni ndji?” ");
INSERT INTO jid_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Indji ba ba mla ya ni kpamba nda tre, “Kie ta tre Ani shu, ani tre, Naki ingye sa bina kpa ye niwu na? ");
INSERT INTO jid_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","U kita tre anin ni ndi du indji ba ba ta tro wu ni tita don ba kpaye Yohana ana annabi.” ");
INSERT INTO jid_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A naki ba kpa nyime kina to wu ni wayi na. ");
INSERT INTO jid_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu tre ni bawu, imeme mina hla ni yiwu na ko ni wani gbengblen a tie ndu biyi na.” ");
INSERT INTO jid_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A tre ni bawu ni misali, “Indji ri a rhon ni irju ma da ba no baya da he ni gbu ri wubar ko ");
INSERT INTO jid_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Intoyi wu ndi wu irju kmaye, daye ton indjiri ciki minikoma ni bi tindu ni Irji, du ba nonik'lo kunkro wa ahe ni irju. Ba tru du k'ma hi kpama dana no kpi na da zi da tru du hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A lla tru indji ri hi ni indji bi tie ndu ni Irji du ba ba no glo kukar kni niwu, bakalatsi na wu mumla, da na no kpi na. ");
INSERT INTO jid_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A lla ton indji ri wutar ma, balaji ciwo ni wu, da tur du hi kpama. ");
INSERT INTO jid_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Indji wu irju tre, me tie ni he? Metur vri mu wa me kpaye niwu, koba kpaye niwu, dano kpaye niwu. ");
INSERT INTO jid_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bi tie ndu ni irju bato da tre, ni kpamba, da tre, wayi yi a vri wu magijin ma, kpi wa ki ti kiwu, ni ki ni ban malaka ma du zama wu mbu. ");
INSERT INTO jid_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naki ba tru nu ni miyi irju da wu. Angye indji wu irju ani tie ni ba? ");
INSERT INTO jid_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ani ye da wu ba wawu'u bi duba, da ban irju no barimu.” Da ba wo toki, ba tre, “Du na he naki na.” ");
INSERT INTO jid_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Da Yesu yaba toki, da tre, “Wuyigye bi yi nufin bi wa ba nha-nha zi, 'Tita wa bi mme ba kamba niwu, wawuyi ni zama mafinficin tita?' ");
INSERT INTO jid_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Indji wa rjoku ni tu tita ani tzi kpama ti ziza ziza, wu indji wa rjoku ani cowawu'u. ");
INSERT INTO jid_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naki wu malaman Attaura wu Firistoci ba wanko wa woh mba ni sa ni kpama ni tonki, da tre ni misalin yi ni tumba, ama dani klu sissri indji ba. ");
INSERT INTO jid_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ba mla kiya gyegyer me, da ton bi sru klu bu'u, baya ni baba ba bi adalci niwwan kowa samu da vu nitre wa tre, niki ba son da tru ni doka ni tre gona. ");
INSERT INTO jid_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","U ba miyi da tre Ticha, kito wu tre ni tzro wu bi ma, wunati kpi meme ma na wu tie kpi wu bio ma ninkon wu Irji. ");
INSERT INTO jid_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ani kpi wu bima duki han ban ni Kaisar ko ana naki na? ");
INSERT INTO jid_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu tokpi wa bason ba tie da kma ni da tre ni bawu, ");
INSERT INTO jid_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tsro me dinari, a iwu nha ni inde ba nha ni kogon ma? Ba tre, “Kaisar.” ");
INSERT INTO jid_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A hla bawu ikpi wa, “Kpiwa wu Kaisar, non Kaisar, u kpiwa wu Irji a wu Irji. ");
INSERT INTO jid_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bana iya davu ni lah tre na, amsar tre ba wanuba anoba mamaki, naki bana biyu nyu na. ");
INSERT INTO jid_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wu Sadukiyawa bari baye niwu da tre niw biwa ba tre bahu wlunde ni vu wu kle, ");
INSERT INTO jid_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wu ba miyi da tre, “Ticha, Musa nha nitawu, da tre idan wa vayi ma agu da he ni wa, dana he ni vri na, indji ka bawa vayi ma, da te viri ni vayima. ");
INSERT INTO jid_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","U akwai mri vayi Tangba-wu mumla garwa da gu ba vri, ");
INSERT INTO jid_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","du ni u ha naki. ");
INSERT INTO jid_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Indji wu tra bawa naki da ye niwu Tankpan ba viri da que. ");
INSERT INTO jid_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Naki, wu wa ngame ye que. ");
INSERT INTO jid_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ni vi wu kle, anha ni son zama ilon ma? Don indji ba gran wa tangba ba wu. ");
INSERT INTO jid_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu hla ni bawu, “indji bi meyi, ba gran dani no kpamba ni gran. ");
INSERT INTO jid_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","U biwa ba ya ani babayi bari ni son ninton biwa ba que ye bana gran koba sa ta gran na. ");
INSERT INTO jid_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bana que ngana ba tsra baba Malaiku da zama mini Irji da mini bi sake wu u kle. ");
INSERT INTO jid_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Naki biwa ba que ye ba wlunde na Musa tsro ni bubu wa shafe miji, wa yo Irji ndi Bachi, Ibrahim ni Irji u Irji wu Ishaku wu Irji Yakubu. ");
INSERT INTO jid_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Zizan ana Irji u kyu na, Ahi Irji u ivri, nitu wawu ndji bi he ni vre niwu. ");
INSERT INTO jid_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Imbru malaman Attaura ba kpa nyime nda tre, “Ticha, wu riga ni kpa nyime bi ye.” ");
INSERT INTO jid_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bana kara mye kpi ngana. ");
INSERT INTO jid_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu tre nibawu, “Ba ti nihe ni tre Irji Vvren Dauda?” ");
INSERT INTO jid_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dauda me kima tre ni nvunvu Zabura, Irji tre ni Irji, kuson ni wo kori mu, ");
INSERT INTO jid_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Wa me dubi yo ni koshi meduba kma ti bubu son me. ");
INSERT INTO jid_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dauda me ayo Kristi, Irji, ani tini he wani tie ni he da tre a vren Dauda?” ");
INSERT INTO jid_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","U wa a kle wo ba ndji ba wawu A hla ni mri koh ma ndi, ");
INSERT INTO jid_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mla zren ni malaman Attaura ba son zren ni glu bi gran ni kpamba, da son indji duba yaba, da no ba bubu son rigrama ni shishi ndji ni tre wu bra ni bubu son buki. ");
INSERT INTO jid_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Da chakpo mba biwu balonmba ba que, da babi bre Irji gburko, naki indji biki ba kpa meme la tre ma.” ");
INSERT INTO jid_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu zu ya da toh indji bi nklen ba si sru baiko ba, ");
INSERT INTO jid_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wa a toh iwa u kbo ani tiya kpukpu me, wa ji bubu ba ye ka you ni kagi. ");
INSERT INTO jid_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A tre njanji mi hla yu'u, iwa u koh a zan yi. ");
INSERT INTO jid_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","indji biyi ba yo ni mi gbugbu u ba. Naki iwa u koh ni miyah ma ayo wawu ikpe di a he niwu. ");
INSERT INTO jid_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bari ba tre ni tu tra Irji, yada ba mla tie bi ni tita ni baiko, A tre. ");
INSERT INTO jid_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ikpi bi yi wa bi si toh, ivi ri ni ye wa tita ri na sun nitu ri na ba na grji ye ni meme'a na. ");
INSERT INTO jid_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba mye, mala, kpi biyi ba ye ni tan? A ngye ni tsro ta inton wa kpi'a ba ti'a? ");
INSERT INTO jid_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ka hla ni bawu, mla ya, na du indrjo ye gyru yi na, gbugbu ba ye ninde mu, da tre ndi ame yi me wawu, u inton a tie whewhre, na hu ba na. ");
INSERT INTO jid_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Inde bi woh ba taku da ni tsi bi kana klu sissri na, ni mumla se kpi bi yi ba ye, u kle, gbugblu na ye zizan na. ");
INSERT INTO jid_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wa a hla ni bawu, gbugblu ni lu ni tu gbugblu, mulki ni lu nitu mulki. ");
INSERT INTO jid_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Meme u gbugblu yi ani grju kagon, iyon ni tie ni gbugblu wawu, lilo ni ka gbugblu'a wawu. Ikpi bari ba grji rji shu da no sissri. ");
INSERT INTO jid_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Naki kpi biyi du ba ye, ba tsi yi da ti meme kpe ni yiwu, da zu yi ni tra Irji, ba vu yi sru ni brusuna, ba gbi yi hi ni ba chu, baba ngona, nitu inde mu. ");
INSERT INTO jid_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ani he ijou tre. ");
INSERT INTO jid_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na ri mre kpi wa bi tre ni koshi na, ");
INSERT INTO jid_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Me mi no yi trre wa bi tre, di no imrre ndindi wa bi kra yi banaya krie ni yi na. ");
INSERT INTO jid_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ba ti bi, mri vayi, mla bi baba kpukpa bi ba tiyi yah da wu bari bi. ");
INSERT INTO jid_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndji ba wawu bbawu ba kran yi ni tu inde mu. ");
INSERT INTO jid_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naki ko futu riri ni tubi na joku na. ");
INSERT INTO jid_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ni mi vu suron bi bi kpa re bi. ");
INSERT INTO jid_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","I hi toh soja ba kru wurushelima you ni tsutsu, bika toh ndi joku ma tie whewhre. ");
INSERT INTO jid_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Biwa ba he ni Judiya du ba tsutsu hi ni gblu u bi wa ba he ni mi gbu ba ka don gbu'a u bi wa ba he ni ko rah gbu'a baka ba ri nimi gbu'a na. ");
INSERT INTO jid_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bi yi ba vi u rju hla, du kpe wa ba han duba kle. ");
INSERT INTO jid_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Iyah ba bi wa ba hei ne, ni bi no mri sisan ni toh kima, iya nihe ni gbu'a ni nfu ni tu ndji ba. ");
INSERT INTO jid_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Inji gban ni kaba hle, ba vu ba kma tie gran ni gbungblu, biwa bana toh Irji na ba chan Wurushelima ni zah, se ivi u bi wa bana toh Irji na nikle ");
INSERT INTO jid_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Igban ni tsro ni Irji, ni wha kpan baba tsitsen, ni meme. Iya ni shu ni gbungblu, ni wrji kpukpa don yi man ni ne. ");
INSERT INTO jid_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Indji ba tie sissri da ta kukmo da ni gbie kpe wa basi ye ni gbungblu, gbengblen bi shu ba ta chu. ");
INSERT INTO jid_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","U ba toh vren ndji ni ye ni mi kpalu ni gbengblen ni kikle daukaka ma. ");
INSERT INTO jid_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inde kpi bi yi basi ye, lunde krikrie ni nzu tumbi. Du ndji wa ni ye kpa yi chuwo a ye whewhre. ");
INSERT INTO jid_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu tre nda ka yiyi ni bawu, yah kunkro indhu baba mbru kunkro ba. ");
INSERT INTO jid_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Biyi ni tu bi bika toh ndi iga ati whewhre. ");
INSERT INTO jid_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Inde bi toh kpe biyi ba he na yi bi toh ndi iye Irji a tie whiwhre. ");
INSERT INTO jid_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Njanji mi hla ni yiwu, i zan bi bana kle na se kpi bi yi ba ye. ");
INSERT INTO jid_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Shulu ni meme ba kle, ama itre ma na kle na. ");
INSERT INTO jid_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sun ni ya cheme, na du suron mbi ni titan hi na so di wah du na he ni mre u tu mbina kana ye ka yi na troko na. ");
INSERT INTO jid_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","A ni ye ni tu ndji bi gbungblu wawu ");
INSERT INTO jid_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sun ni wri di ta bre chachu du yi he ni gbengblen ndi nawo ni kpi bi wa ba ye'a, wa bi kri ni kbu Vren Indji ");
INSERT INTO jid_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ni nton kima, a si hla tre ni bawu ni tra Irji, ka rju nichu da ka sun ni bubu ri wa ba you ndi Olivet. ");
INSERT INTO jid_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Indji ba rju gbugbun ni bubu ble ye ni woh wu ni tra Irji. ");
INSERT INTO jid_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ba he inton u bredi wa ana sa na, a ti whewhre, wa ba you ndi ngan u za. ");
INSERT INTO jid_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bi ninkon bi tu du Irji, baba bi han be, ba susun da tre nitu bawu Yesu, ni ki basi klu sissri ba ndji. ");
INSERT INTO jid_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ibrji a ri ni Yahuza Iskariyoti, iri ni mi mri koh ma tso. ");
INSERT INTO jid_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuda a hi ninkon bi toh ndu Irji, biwa ba yah ndji kpatsri, wawu ni vu Yesu no ba. ");
INSERT INTO jid_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","U ba ngyiri ni wu, nda no nklen ");
INSERT INTO jid_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wa kpa nyime, da wa nkon wa ani vu noba ni nton wa indji bana he na. ");
INSERT INTO jid_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ivi u gah u za, naki ba ti gan u hay ikru wu ton yin. ");
INSERT INTO jid_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu a ton Bitrus mba Yohana, da tre, Hi ndi mla bubu biri u ton yin, du ta ri. ");
INSERT INTO jid_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba mye, ni nsten wu son ki hi mla bubu ati? ");
INSERT INTO jid_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A ka sah ni bawu, inde bi ri nimi gbu'a, bi tsra nio ndji a nji iriman. Hu hi ri nimi koh wa ani ri. ");
INSERT INTO jid_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hla ni ndji u koh, ndi mala, tre mikoh bi tsri he ni ntsen, wa mi ribi ri ni mri koh mu? ");
INSERT INTO jid_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ani tsro yi kikle ko u koshu, wa ba mla ti ye bika mla ti ni mun. ");
INSERT INTO jid_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","U ba hi da toh ikpe a he naki. Baka mla bubu u tan bredi wa ana sa na. ");
INSERT INTO jid_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Da inton ati wa ka sun ni mri koh ma. ");
INSERT INTO jid_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wa a hla ni bawu, mi you suron ndi mi tan bredi wa ana sa na ni yi, ri ni yah. ");
INSERT INTO jid_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Naki mi hla yiwu, mi na la tan bredi ni yi na, se ba mla wu ti ni koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu ban gbaju'a da ngyiri nda tre kpa wayi, gaa ni kpambi. ");
INSERT INTO jid_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Naki mi si hla yiwu mi na la so mma klo kunkro na, se koh Irji ye. ");
INSERT INTO jid_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A ban bredi'a nda ngyiri, nda mere no ba nda tre wayi yi nma kpa mu, wa ba no don biyi, bita ti nayi ndi ta ri mre mu. ");
INSERT INTO jid_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","A ban gbaju'a ni kogon bredi, iwa yi a si sa tre'a, a yi mu wa ba kahle don biyi. ");
INSERT INTO jid_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bi ka mla yah indji wa ani vu noba, a he nime ni tu tebru. ");
INSERT INTO jid_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naki Ivren Ndji hi gbigbi na ba tre, Iyah ndi kima wa ani vu noba. ");
INSERT INTO jid_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Baka lunde nda ni mye kpa mba, ahi nha ni mi mbu wa ani tie kpe mba. ");
INSERT INTO jid_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ba lu si sen nyu ni kpa mba, nitu ninkon u shu. ");
INSERT INTO jid_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A hla ni bawu, bi tu chu baba ndji biwa bana toh Irji na, ba tsro gbengblen mba, bari ba he ni gbengblen nitu mba, ba you ba ndi bi mulki ni daraja. ");
INSERT INTO jid_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Du na he naki ni yi na, naki du ndji wa a ninkonni yi du he na vivren tsitsa, indji wa a zan yi ka he na u tindu. ");
INSERT INTO jid_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A hi nha a hi ninkon, wa a sun ni tebru, ko a wa a si tie ndu'a? Ana wa a sun nitu tebru na? Naki me na ndji u tie ndu ni mi mbi. ");
INSERT INTO jid_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Naki biyi bi he ni mie ni mi tsra ");
INSERT INTO jid_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mi no yi mulki na wa Tie mu a ne. ");
INSERT INTO jid_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bi ri ndi so ni tebru u mulki, bi sun ni koh mu, ndi ta blatre ni lbe tso u Israila. ");
INSERT INTO jid_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siman, Siman, mla zren me tie, ibrji a wa inton wa ani yre u na alkama. ");
INSERT INTO jid_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Naki ba si bre ni wu, du you suron me du na joku na, inde wu kma ye wu ka tre trre ndindi ma wa ani no mri vayi me gbengblen. ");
INSERT INTO jid_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus a hla wu Bachi mi he ni mereu hu hi ni brusuna mba kyu. ");
INSERT INTO jid_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ka sa ni wu ni hla wu Bitrus, kafi du gba tbu luwa nkpu tra u kpatron ndi wu na toh me na. ");
INSERT INTO jid_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu ka hla ni bawu, inton wa mi ton yi hama ni bu ko go ple, ko lagban zah, ibi ka wa kpie hama? U baka trre ndi a'a. ");
INSERT INTO jid_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ama zizan'a, i wa a he ni mbu ka ban ni igople. Ndji wa ana he ni inji ngban na, ka ban klon ma le nd le ri. ");
INSERT INTO jid_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naki mi hla yiwu, ikpie wa ba nha nitu mu ani he naki, ba bla you na bi la tre, ikpei wa ba tre ni tumu a he naki. ");
INSERT INTO jid_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","U ba tre, “Bachi, iyah, ngye inji ngban hari, wa a tre da tsra nu ");
INSERT INTO jid_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Da ba ri la u yalu kle, Yesu a hi na ani tie chachuu hi ni ngbulu Zaitun, se mri koh ma ba hu. ");
INSERT INTO jid_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Da baka kai niki, waka hla bawu, ta bre Irji don du yi ri ni mi lah tre na. ");
INSERT INTO jid_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A kaba don da ch'bi, nda kukyu ngbarju nda bre, ");
INSERT INTO jid_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nda tre, Bachi, inde wu kpa nyime wu ka ban gbarju i rju ni mu. ");
INSERT INTO jid_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Se Maleka ni shu ye niwu nda no gbengblen suron. ");
INSERT INTO jid_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ahe nimi iyah kpukpo me, a you ni bre, hra ikrji ma ni grji na gble yi. ");
INSERT INTO jid_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A lunde ni bre ma, da ye ni mri koh, da ye toh ba basi kruna don ani lo ba suron. ");
INSERT INTO jid_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wa a mye ba a ngye sa bi si kruna? Lunde ndi bre du yina ri ni yah na. ");
INSERT INTO jid_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A he ni mi tre, se ga gbugbu ndji ba ye baba Yahuda iri ni mi mri koh ma tso'a, nda ye whewhrre ni Yesu nda hlan vu. ");
INSERT INTO jid_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ni ki Yesu ka tre, Yahuda, wu ban Vren Ndji no ni hlan vu? ");
INSERT INTO jid_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","U biwa ba krju Yesu you ni tsutsu, ba toh ikpie wa si zren, nda tre, Bachi ki tsen ni inji ngba? ");
INSERT INTO jid_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iri ni mi mri koh ma a chu nji nda yba iton ninkon bi nha be u woh ko ri. ");
INSERT INTO jid_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","U Yesu ka tre, a tsra naki da taba iton nda wakar ni wu.” ");
INSERT INTO jid_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu tre ni tie ndu ni koh Irji, ni bi gben ni koh Irji baba chiche ndji ba, wa ba you ni koh shishi bi rju na bi ye vu ndji u ybi, ni ba nji ngban ni kpala? ");
INSERT INTO jid_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ni wa mi na he ni yi ni tra Irji, bina vu me na, zizan a nton mbi ni gbengblen u bu. ");
INSERT INTO jid_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba vu nda nji nda hi, ba nji hi ni koh ba, u Bitrus ka ta hu ni gbugban mu. ");
INSERT INTO jid_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Niki baka muh lu ni tsutsu ra, nda ku sun niki wawu mbawu, Bitrus a sun ni tsutsu mba. ");
INSERT INTO jid_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sei wa ri a toh a sun ni kpan lu'a, nda you shishi ni wu, nda tre ndji yi ba he mbawu.” ");
INSERT INTO jid_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","U Bitrus a kpa tron, nda tre iwa mi na toh na.” ");
INSERT INTO jid_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Vi toh fi me yi, u ndji ri ka toh nda tre, wu mewu he ni mi mba. Bitrus tre ndi, “Ana me na.” ");
INSERT INTO jid_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Intonri hi, i ndji ri a kama nda la tre, njanji ndji yi ahe ni wu, a vren Galili. ");
INSERT INTO jid_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bitrus a tre, ndi mi na toh kpie wa asi tre na, nda asi he ni mi tre u gbah lu tbi. ");
INSERT INTO jid_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A kma u Bachi ka yah Bitrus. Se Bitrus ka ri mre ikpie wa Bachi tre'a, se a hla niwu, kafi du gbah du tbi luwa, u kpa tron nkpu tra ndi wu wu na toh me na. ");
INSERT INTO jid_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Da Bitrus rju nda yi u'lo suron. ");
INSERT INTO jid_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Se ndji bi wa ba troh baba Yesu ba ka zah wu da tsi me. ");
INSERT INTO jid_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Da baka kawu shishi, nda mye hla tawu a nha wru'u? ");
INSERT INTO jid_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba ka tre trre u nanye, ni meme tre ni Yesu. ");
INSERT INTO jid_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Da imble kpan u chiche ndji baka ka bi baba bi toh ndu Irji, baba bi nha lbe se da nji'u hi ni bi tuchu, baba bi ninkon bari. ");
INSERT INTO jid_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Da tre hla ni tawu a wuyi wu Almasihu'a” wa a hla ni bawu ko mi hla yiwu, bina kpanyime na, ");
INSERT INTO jid_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Inde mi ye yi, bi na kasa ni muh na. ");
INSERT INTO jid_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aman ni ko shishi, Ivren Indji ni sun ni woh ko ri u gbengblen Irji. ");
INSERT INTO jid_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba ka tre, u u” Vren Irji? Se Yesu ka kasa ni bawu ikpie wa bi tre a me yi. ");
INSERT INTO jid_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba tre don ngye ki si wa shaida? Kita ni tu mbu ki woh ni nyu ma.” ");
INSERT INTO jid_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Indji ba wawu mba, ba lunji Yesu ye ni koshi Bilatus. ");
INSERT INTO jid_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na lu ni nhanwu andi, ba ka toh asi kpa indji si ti meme na ni tonba ni timeme, ndu ba na kpanyime na nhan iban hi no Kaisar na, na ni yo tuma Almasihu, Ichu.” ");
INSERT INTO jid_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatus Myen, Ahi wuyi Ichu Yahudawa? U Yesu kpanyime niwu, “Anaki wu tre.” ");
INSERT INTO jid_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","U Bilatus hla ni Firistocin bi ninkon ba ni jubu indji ba, “Mi na vu ni lah tre riri me na.” ");
INSERT INTO jid_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","U ba luni tre, andi, “A kpa suron indji ni tie meme na ni hla tre ma ni Yahudiya, a so ma rji ni Galili ye ni wayi.” ");
INSERT INTO jid_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Niwa Bilatus a woki ma, na miyen indji bi Galili'a wawu ");
INSERT INTO jid_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wa ye toh ni mre ma andi a he ni zah (kalkashi) pkancin Hiridus, natru Yesu hi ni Hiridus, wa a he nitu ma Wurushelima ni vi bi ton ki. ");
INSERT INTO jid_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ni wa Hiridus a ku shishi ni wu u ngyiri shu niwu ni suron su se'a ni tu wa azi wau tu lalon mu ni sun toh wu. Wa a wo tre tuma, waa dede ni yoshishi ni sun toh iri kpii wa a ni tie bi so sissri wa a ni tie'a. ");
INSERT INTO jid_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hiridus a miyen Yesu ni mi tre bi gbugbu, u Yesu na sa kpe riri ni wu na. ");
INSERT INTO jid_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Firistocin bi ninkon ba ni biwa ba nhan, lunde kri, ni nha nu ");
INSERT INTO jid_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hiridus ni sojoji ma ba lu ni nhanu, nani whiyen ni wu, u ba sru nkulon bi ndindi ma niwu, na kma tru Yesu hi ni Bilatus. ");
INSERT INTO jid_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ba Hiridus mba Bilatus ba tie kpan ni kpamba chachuki (ba na ta yo kpamba ni ko shishi). ");
INSERT INTO jid_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus yo Firistocin ni bi chu ni jubu ndji ba, ");
INSERT INTO jid_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na hla ni bawu, wa hla ni bawu, bi ka nji igu yi ye na indji wa ani ton ndji timeme, bi yi me bi toh, mi, miye ni shishi, mina vu lahtre riri me na wa bi ki nhanwu na. ");
INSERT INTO jid_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ba kpe, Hiridus me, ala ka tru kma ye ni tawu, bi toh, igu yi na tie ikpe wa ba wu'a na ");
INSERT INTO jid_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ni tu ki mi gbi ton niwu ni kachuwo. ");
INSERT INTO jid_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wa hi gbigbi ni Bilatus ndu chu indji u y'bi iri no ba ni Idin) ");
INSERT INTO jid_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wawu mba wu ba lu tre vovome, ndu ba, “Nji gu mba hi, na nji Barabas grji!” ");
INSERT INTO jid_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas a guri wa ba yo ni mitra u lo ndji bi latra, nitu wa aka kpa suron tie meme ni bawu ni gbu na wu ndji. ");
INSERT INTO jid_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus ala tre, asun ka Yesu chuwo. ");
INSERT INTO jid_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ba la tre vovome, ni, “Giciye wu, giciye wu.” ");
INSERT INTO jid_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A hla ni bawu nkpu u tra, “Nitu ngye, a ngye yi indji yi tie wa a meme? Mi na toh kpe wa a tie wa bi wah bi wu'u ni tu ma na. Ni naki to bi kle nu'u yah, me ka'u chuwo.” ");
INSERT INTO jid_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ba kri titu, na tre gbangban me, ndi ba sun ndu ba giciye wu, u tre mba ka mren Bilatus saran. ");
INSERT INTO jid_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","U Bilatus a kpanyime ni bawu ni kpi wa ba sun. ");
INSERT INTO jid_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wa ba miyen a nji grji ni bawu na no ba i wa ba yo ni tra u lo ndji'a nitu wa a kpa suron tie meme nda wu ndji, na no Yesu ni kpi wa son. ");
INSERT INTO jid_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ba nji hi, na zu vu guri inde ma Siman Bakurane, a rji ni gbu siye, u ba ban giciyen gran ni wu gba, ndu nji hu Yesu. ");
INSERT INTO jid_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chubu nji ni mba ba lo suron na ni yi nitu ma, na ni hu. ");
INSERT INTO jid_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Wa kma yaba, Yesu tre, “Bi mri mba Urushalima, na yi nitu mu na, bi ka yi ni tu-mbi ni mri-mbi. ");
INSERT INTO jid_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bi toh, ivi ni ye wa ba tre, lulu a biwa ba son ni krju ni bi wa bana ngrji na, ni sisan wa bana mma na.” ");
INSERT INTO jid_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","U ba fare tre ndu tita, “Ku chan ta, ni Igbulume, Bika kata. ");
INSERT INTO jid_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ba ni na tie kpi biyi u kunkron a ri he ni shushu, ahi ngeri ani tie u kunkro klu ye? ");
INSERT INTO jid_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","U ba nji indji hari biwa ba lah-tre, hi niwu baba Yesu. ");
INSERT INTO jid_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wa ba ka ri ni bubu wa ba yo, “kyukyu” niki ba ka kpan ba ni kunkron'a (giciye) ni bi y'bi hari, u ri ni wo kori, u ri ni ko ta. ");
INSERT INTO jid_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu tre “Itie, kpa wruhle ni bawu, don bana toh kpe wa ba tie na.” Ba lu ni ta chacha, na yaba inklon ga. ");
INSERT INTO jid_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Indji ba lu niya bi nji ndji (mulki) ba wa ba ye si tsawu andi, “A kpa bari chuwo. Dun kpa tuma chuwo ki, toh wawu yi hi Almasihu u Irji, wa ba chu'a.” ");
INSERT INTO jid_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bi lokpa me ba tsawu, na wa niye, nda ni dren iman wa'a sa. ");
INSERT INTO jid_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nani tre, “U ta hi chu Yahudawa, U ka kpa tume chuwo.” ");
INSERT INTO jid_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","U gban ri he niwu tu, “I wa yii a chu Yahudawa.” ");
INSERT INTO jid_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iri ni mi bi y'bi hari ba wa ba kpan ba, a mre'u andi, “A na wuyi Almasihu na? ka tu me chuwo ni kita me. ");
INSERT INTO jid_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","U ri ma sah, wa ya losuron, “U na tie sissri Irji na, nitu wa ba wuta baba? ");
INSERT INTO jid_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","U mbu ba tie tsra, ki kpa mbu nitu kpe wa ki tie, Igu yi ana tie kperi memema na.” ");
INSERT INTO jid_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nna la tre, “Yesu na kparisu ni me na, uta ri ni ko Itie me.” ");
INSERT INTO jid_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu hla ni wu, “Njanji tre misi hla niwu, luwa u he nime ni Firdausi.” ");
INSERT INTO jid_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","U ba he niki ni krafi tanne, u bubu ka tie bwu kagon gbu'a wawu, hi ni krafi tiya. ");
INSERT INTO jid_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","U rji grji ka ku. U bre gontra tra u tre ni Irji a yar tie hari ni tsutsuma ye ni meme. ");
INSERT INTO jid_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ni yar yi ni lan gbangban me, Yesu tre, “Itie, mi ka Ruhu Mu no niwo me.” wa tre naki, na que. ");
INSERT INTO jid_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","U Jirimia a toh kpi wa a tie, na gbire Irji san, “Gbigbi iguyi a hi indji ndindi.” ");
INSERT INTO jid_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","U Ijubu indji ba wawu, wa ba hu ba ye ndu ba ye toh ikpi wa a tie ni shishi mba, ba kma ni wru wo ni san mba. ");
INSERT INTO jid_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bi wa ba toh wawu mba'wu, ni imba bi wa ba hu ba rji ni Galili, u ba ka kri ni gbugbanmu, na si ya kpe wa a si zren ");
INSERT INTO jid_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","U indji ri ba yowu Yusufu, ahi vren u majalisan ni ugbu na indji ndindi. ");
INSERT INTO jid_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wa na kpa nyime ni kpi wa ba tre ni kpi wa ba tie na, rji ni Arimatiya ni meme Yahudiya, i wa a si kben hi koh Irji. ");
INSERT INTO jid_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Igu ki, ahi ni Bilatus, na miyen wu a ndu ban ikpon Yesu no wawu. ");
INSERT INTO jid_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wa nji grji ye meme, na nyewu ni pri ndindi, na kayo ni mi bbe wa ba shime ni kpa tita, ni bubu wa ba na rju ndrjo toh na. ");
INSERT INTO jid_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ivi ri ri ni vi, u Asabaci te whiwhre. ");
INSERT INTO jid_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ba imba biwa ba ye baba Yesu rji ni Galili, ba hu nda toh wrji wa ibbe'a a he nda toh ka ba yo nkpon ma'a. ");
INSERT INTO jid_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","U ba kma hi, u ba wa inye u gban ni turare. U ba kusi ni ivi Asabaci, nidu. ");
INSERT INTO jid_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni bwu mble, ni vi mumla wu Sati'a, ba ye ni bubu ibe'a nda nji nnye wu bwa ni kmo, wandi bana ti'a. ");
INSERT INTO jid_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba to ndi ba nyi kikle tita wa ka nyu ibe rju. ");
INSERT INTO jid_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba ri nimi nda toh ndi k'mo Bachi Yesu na he na. ");
INSERT INTO jid_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A hye niki, ba ri he ni tsishishi ni tu kpe yi, ndji ha ba rju kri ni ba ni inklon wa zan pri me. ");
INSERT INTO jid_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Niki mba-ba ba ti sissri nda kukru ni shishi mba ni meme, i ba tre ni mba-ba ndi, “Ngye du yi ni wa ndji wu vrhi nimi biwa ba qu ye'a?” ");
INSERT INTO jid_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ana he ni wayi na, ba nzu lunde ye. Rhimre ni tre ma niwa a rhi he ni Galili, ");
INSERT INTO jid_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ndi ba guchi vu Vren Ndji nu ndji bi lah tre, ba gran ni kunkro, ni vi wu tra ani la lunde. ");
INSERT INTO jid_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Imba ba ba tika itre ma, ");
INSERT INTO jid_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nda kma don bubu ibe'a nda bla ni wlon don ri'a baba mbru ndji bari, wawu ikpi biyi ba ");
INSERT INTO jid_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Niki, Maryamu Magdalin, Joanna, Maryamu iyi Yakubu, ni mba ba rima, mle, baka vu bla ni manzani ba. ");
INSERT INTO jid_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama itre wa a bla bawu a rju choloncho ni manzani ba, i bana kpanyime ni mba-ba na. ");
INSERT INTO jid_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","I Bitrus a lu kri vu tsu hi ni bubu be'a, nda ku dran nda ya mima. A to ba pri nklon wu kpa ma ba shii zini kosan. Bitrus a kma hi ni koh ma, nda ni rhimre ikpi wa ba he'a ");
INSERT INTO jid_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ni vi baki, ndji ha ni mimba ba vu nko tayi ni vi gbu Emmawus, wandi a mili ttamgba ni mbru rji ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba si tre ni kpamba nitu ikpi biwa ba si zren'a. ");
INSERT INTO jid_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Niwa basi tre nda ni mye kpamba, Yesu kima a ye nda si zren ni ba. ");
INSERT INTO jid_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Shishi mba ana bwu du ba mla toh ka ahi nha na. ");
INSERT INTO jid_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu a hla bawu ndi, Bi ki zren nini tre nitu ngye, hambiwu ni ton nkoh? Ba kma kuki nda kri ngbonme. ");
INSERT INTO jid_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iri mba, ni nde Cleopas a sa niwu ndi, “Wu nklen me yi ni gbu Urushelima wuna toh ikpi wa basi zren ni vivi yi na? ");
INSERT INTO jid_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu a mye ba ndi, “ikpi bi rime?” Ba sa wu ndi, “Ikpi nitu Yesu wu Nazarat wandi ana Anabi kikle ni ndu, mba lan tre ni shishi Irji mba ni ndji wawu'u, ");
INSERT INTO jid_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wawu yi kikle Prist, baba bi ninkon wu gbu'a ba vu nu du ba lo u wu qu nda klo ni giciye. ");
INSERT INTO jid_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kina yo suron ndi wawu yi ni ye kpa Israila chuwo. E, nha ni kima, a vi tra zizan wa ikpi biyi ba he. ");
INSERT INTO jid_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ngari, mba bari, nimi mbu ba rju ni tre wa anuta sissri, nitu hi mba ni bubu ibe ni bwubwu mble. ");
INSERT INTO jid_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ba hi ka toh ndi kmo ma na he na, nda kma ye si tre baka toh Maleka wa a hla bawu ndi a he ni sissren. ");
INSERT INTO jid_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndji mbu bari ba hi ni bubu ibe nda ka to tsra ni kpe wa mbaba ba hla'a. Ama bana to'o na. ");
INSERT INTO jid_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu a hla bawu ndi, “Bi ruru ndji, bi si sron kpanyime ni kpe wa anabawa ba tre! ");
INSERT INTO jid_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ana bi zan du Kristi sha ya ikpe biyi rhi nda ri ni nzuhon ma na?” ");
INSERT INTO jid_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niki rji ni Musa, zu ni anabawa wawu, Yesu a mla bla ni bawu ikpi nitu kpama nimi nvunvu tre Irji. ");
INSERT INTO jid_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ni ba tie whiwhre ni vi gbu wa bata hi niwu'a, Yesu a ti to ani zren hi guchi. ");
INSERT INTO jid_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mle ba bre u ndi, “Son nita, yalu si tie, i ivi'a ti wiewiere wu kle ye. Mle Yesu a kpanyime nda ka son niba. ");
INSERT INTO jid_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Niwa a kuson nda ni rhi niba, a ban bredi'a, yo lulu niwu, nda nziga nu ba. ");
INSERT INTO jid_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Shishi mba a kri bwu i baka mla toh wu, wa kri kado ni shishi mba. ");
INSERT INTO jid_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba hla ni kpamba, “Suron mbu ana si'a gon ni mi-mbu niwa a si tre ni nkon, nda tsro ta nimi nvunvu tre Irji na?” ");
INSERT INTO jid_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba kri lunde ni ton kima nda vu nkon kma hi ni Urushelima. Ba ka ri ni wlon don ri ba, nda toh ba baba bi wa bana he ni ba'a, ");
INSERT INTO jid_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","nda hla ndi “A njanji, Bachi mbu lunde, nda tsro tuma ni Siman,” ");
INSERT INTO jid_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niki ba vu kpi wa ba toh ninkon mba wa ba mla toh Yesu ni andi a ban bredi si ga nuba a. ");
INSERT INTO jid_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Niwa basi tre kpi biyi, Yesu kima, a rju kri ni mimba nda tre ndi, “Si suron son niyi.” ");
INSERT INTO jid_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ba ti gbri me i sissri a vu ba. Ba ban ndi ba toh ibrji ma mu. ");
INSERT INTO jid_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu a hla bawu ndi, “A ngye du yi ni tie sissri? A hi ngye ni lo yi ni suron? ");
INSERT INTO jid_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Toh iwo mba iza mu. A hi me kimu. Sa wo nitu mu ni toh. Ibrji na he ni nma kpa mba ququ na wandi bisi to mi he niwu na.” ");
INSERT INTO jid_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Niwa a kle tre toyi a tsro ba iwo mba iza ma. ");
INSERT INTO jid_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Niki me, bana kpanyime na, nitu ngyiri ni sissri. Yesu a mye ba ndi, “Bi he ni ikpe wu rhi?” ");
INSERT INTO jid_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba nu vi lambe wa ba sron'a. ");
INSERT INTO jid_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Akpa nda rhi ni shishi mba. ");
INSERT INTO jid_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A hla bawu ndi, “Biyi yi ba lan tre mu, wandi mi hla ni yiwu niwa mi he ni yi, ndi ikpi wa ba nha ba ni nvunvu doka Musa baba anabawa ni Zabura ba wrhu he toki. ");
INSERT INTO jid_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Alu bwu mre suron mba du ba mla to nvunvu tre Irji. ");
INSERT INTO jid_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A hla bawu ndi, toki ba nha ndi Kristi ni shaya nda lunde rji ni qu ni vi wu tra. ");
INSERT INTO jid_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kma suron wrhu ni la tre ni kpa wrehle lah tre ma. Hi bla ni ndi kagon ngbungblu rhi ni Urushelima, ni ndema. ");
INSERT INTO jid_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bi toh ikpi biyi ni shishi-mbi. ");
INSERT INTO jid_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ya, mi si ton yi nitu ikpe wa Timu a rhentse ni tuma. Bi gben ni mi gbuyi nitu ba kayi ni nklon gbengblen rji ni shulu ri. ");
INSERT INTO jid_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Niki Yesu a wrhu ni ba nda hi wiewiere ni Betani, nda nzu wo ma nda yo lulu ni bawu. ");
INSERT INTO jid_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ni wa a ta yo lulu ni bawu, ba kri ban'u hi ni shulu. ");
INSERT INTO jid_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mle ba ku nzu ndema, nda k'ma yi ni Urushelima kikle ngyiri. ");
INSERT INTO jid_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba si'a ki chachu ni tra Irji nda ni tie lulu niwu. ");
INSERT INTO jid_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ni mumla itre a he u tre he ni ba chi u tre a hi bachi ");
INSERT INTO jid_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","iwayi a he rji ni mumla ni bachi ");
INSERT INTO jid_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","koge ba tie ni wa wuti ba na tie kpe ri na sei ni wawuyi ");
INSERT INTO jid_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ni uahi nou ivri he u viri a ka tie ipan ni indi wawu ");
INSERT INTO jid_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ipan a lan ni mi bwu i bwu na ka ipan na ");
INSERT INTO jid_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","indi ri he wa bachi ton ndu wa ba yo di yahaya ");
INSERT INTO jid_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","aye toh na hla tre ikpan ni ndu indi wawu kpa yenme ni tu ma ");
INSERT INTO jid_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","a na yahaya ahi kpan na ama ndu ye toh kpan na hla ");
INSERT INTO jid_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ikpan i njanji wa a no kpan ni indi wawu ani ye ni gbungbula ");
INSERT INTO jid_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","a he ni gbungbulu yi ba mei gbungbulu ni tuma indi bi gbungbulu bana toh na ");
INSERT INTO jid_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","aye ni bama u bima bana kpaa na ");
INSERT INTO jid_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","abi wa ba kpa na kpayenme ni indi ma abiki migen ano ba ikon ndu ba yo ba tie imiri rji ");
INSERT INTO jid_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","wa ba na grji ni kon irji u yina ana nitie u kpa na ana tie u ndi na a hi tie rji ");
INSERT INTO jid_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ilan tre ka tie nma kpa na son mi mi buu wa aye rji ni irji na sh ni iko ni njaji ");
INSERT INTO jid_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","yahaya a hla ni tu ma da ni yo indi kpan kpan me nanihla ahe wayi i mi tre indi wa ani ye ni kogon mu a za me a he ri mi ka ye ");
INSERT INTO jid_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ni tsara ma yi kikpa alheri ni tu alheri ");
INSERT INTO jid_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","doka tre yi ye rji ni musa alheri ni njaji baye rji nikonyesu Amasihu ");
INSERT INTO jid_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ba iton wa idiori taba sa shishi ni irji indi wa ahi wawu yi kangrjima a hi nji iwa a kuyer ni kbu bachi rji wawuyi tsro u ");
INSERT INTO jid_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","yahudawa ba lude ton ba ni firistici ni lawiyawa he niwu ni ni tu ba son miyen ahi wu nhan? ");
INSERT INTO jid_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","wa nhla ni bawu gerger ana kpa tron na wa si sa bawu adie ana imeyi me Almasihu na ");
INSERT INTO jid_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","u ba miyen a hi wu nahn? ahi wu yi iliya? iwa tisan ana mena u tra ahi wuyi wu anabi? wa ti san aa ");
INSERT INTO jid_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ba miyenu a hi wu nha ki son ki hi hla ni biwa ba ton ta? u hla ta wu di geri ni tu me? ");
INSERT INTO jid_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","wa hla mi lantre wa a bi tie ni kon irji nawa wandi anabi ishaya hla a ");
INSERT INTO jid_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","bandi waba ton ba rji tarisawa ba he niba u ba miyen andi ");
INSERT INTO jid_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","u ge mba sa u yin btsima ise una Almasihuna u na iliyana ko annabin? ");
INSERT INTO jid_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","yahaya se tre a bawu andi mi yi batsima ni ma indi ri k rli ni mibi wa bina toh na ");
INSERT INTO jid_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","wawu yi ni ye ni kogon wa rjirji lagban ma nii kuyiron wa mi siwua ");
INSERT INTO jid_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","kpi biyi ni Bethany u ngbala rima u Jordan wa Yahaya a sia ti batisma mble ");
INSERT INTO jid_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ni bele ni virima yahaya toh yesu niwa natre yamba ige vreb nkrju irji iwa aban lah tre gbungbulua ");
INSERT INTO jid_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","iwayi ahi iwa mi bla ni yiwu ndi ndi wa asiye a zanme ahe guci nimu ");
INSERT INTO jid_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","mina toh na ama bana hla tsre ilawa ye miye ni yi batisma ni ma ");
INSERT INTO jid_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","yahaya shedai andi mi toh ruhu asi grji na ingyu da ye niwu nituma ");
INSERT INTO jid_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","mina gani niwu na indi wa a tih me miyi batsima ni mima a hla nimu ko ahi nhan u toh ruhu a grji kuson niwu nituma ahi wawu yi a yin batisna ni ruhu u nja ji ");
INSERT INTO jid_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","mitoh ni sheda ahi wawuyi vrena rji ");
INSERT INTO jid_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","kan vi nibela u ha ma u yahaya a kri ni hari ni mi almajeran ma ");
INSERT INTO jid_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","u ba toh yesu a ka vuyaba ni hi u yahaya atre toh ba inge vren krju irji ");
INSERT INTO jid_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","u almajeran ma hari bawo naki da luwu yesu ");
INSERT INTO jid_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","u yesu kban ya da toh basiwu u wa a miye a ge bi son? u ba yo rabbi andi lu soro ni tseyi ");
INSERT INTO jid_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","a hla bawu ye ni ye toh ubaye na ye toh bubu wa ani son u ba ka kuson niwu che chuku ni karfi wollon ");
INSERT INTO jid_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","iri ni miba biwa ba wo tre yahaya hi androwus vayi siman Bitrus ");
INSERT INTO jid_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","a lude da wa vayi ma simanna hla niwu ki ka toh Almasihu ");
INSERT INTO jid_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","a nji ye ni yesu yesu ya da tre ahi wuyi u siman ivren yahaya? ba yo di kefas ");
INSERT INTO jid_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ni vikima wa yesu luni shirin u kugon hi nigalili u waka toh filibus da hla niwu luhume ");
INSERT INTO jid_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus ivren i jiji baitsida gbu ba andrawus ni bitrus ");
INSERT INTO jid_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","filibus ka same ni nata na ilu da hla niwu ki same niwu wa musa a nhan yo nimi attaura ni annabawa yesu ivren yusufu ba nazarat ");
INSERT INTO jid_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","natan ilu a hla niwu ba ya na fe kperi u ndi ndi ma ni Nazarat? filibus tre ye ni ye toh ");
INSERT INTO jid_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","u yesu a toh matana ilu si ye niwa u wa tre tre nituma toh ba isra ilyi wa ana mirtan indi na he niwuana ");
INSERT INTO jid_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","natana u lu miyen u tie ni he mba ni toh me? u yesu a hla niwu mi toh ri u filibus yo u niwa a son ni chin mbuwa ");
INSERT INTO jid_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","natana ilu yo ni rabbi u vren irji u chu israila ko ");
INSERT INTO jid_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","yesu tre ni wa ni hla ndi me toh u ni chin mbuwa a kpayenme? u toh kpii wa ba nawayi babran ");
INSERT INTO jid_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","na hla njajimu njaji misi hla niwu utoh shulu bwu kri wuho malaku irjii ba si hon nani grji nitu vren indi ");
INSERT INTO jid_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","nivi u tra wa a wuce igran iri a heni cana u Galili u yi yesu a hei niki ");
INSERT INTO jid_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ba hla ni yesu di almajeranma ndu ba hi ni igan ugran ");
INSERT INTO jid_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","u lman inabin a kle u yi yesu hla ni wu iba na he ni iman inabin na ");
INSERT INTO jid_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","yesu hla niwu iwa ahi ge ka krji u ye nime? iton mu na tsra rina ");
INSERT INTO jid_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","iyima a hla ni miri bi nduma ko a hla ni nduyi tie gen bika tie u ndu bari ba he niki ni tita tan ne ");
INSERT INTO jid_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","iwa yahudawa ba tie ndu niwa ni igan ba u tsarka ke ko rime ni mi mba ni ban durom iri ");
INSERT INTO jid_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","iwa hla ni bawu suru man shu ni indun ba uba suruman shu mba pleleme ");
INSERT INTO jid_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","iwa hla ni bi ndu ba tie ni mima hi no nikon ugan u ba tie nakima ");
INSERT INTO jid_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nikon u igan a vu ma hla toh wa a katie ima ina bin wana toh iwurji wa a rji a na iwa to ");
INSERT INTO jid_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na hla niwu ko nha niga ma inabin ndi ndi ni mumla nduba so kle rikiko ba nji iwa a lolomey ye ni kokon iwu u ma ndindi zi sei zizan ");
INSERT INTO jid_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","iwayi a hi gban u mumlan wa yesu tie ni cana galili na tsoro dauka ka ma amajeran ma ba kpayenme ni tiea ");
INSERT INTO jid_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ni kle ki yesu ni yinman ni miri vayima ni almajeran ma ba hi kafarnahum na ka sori niki tie vi bari ");
INSERT INTO jid_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","igan u zagran idina tie whire u yesu a hon hi ni uri shaliman ");
INSERT INTO jid_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","a ka toh bi le ni lando ni ik rju ni tantabaru ni bi siran iklen ba son niki ");
INSERT INTO jid_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","iwa tie gbugban ni rjirji na zuba rju wawu ni mitara u rji ni nitman ni lando na vu glengbe in klen vara hlega ni bi saran klen na kpa tabru a zie lega ");
INSERT INTO jid_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","a hla nibi le ni tan tabara vu kpie bi yi rju niwa yi bi kako itiemu tie chuchuu lea ni kpie ");
INSERT INTO jid_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","u alma jeran ma ba tika andi ba nha nhan zindi to iko me ni irime kle ");
INSERT INTO jid_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","binikon ni yahudawa ba batre niwu a a hi gban geri u ya tsoro ta ni tu ikpe wa u si tie mba ");
INSERT INTO jid_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","yesu sa nibawu zie tra rji yi mi merie ni mi ivi tra ");
INSERT INTO jid_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ubi mikon yahudawa ba tre ba tie ise arabayin don tannen riko na nme trarsi a kle u ri ban ivi tra yin ni nme koa? ");
INSERT INTO jid_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ama asita tra itra u kpa ma mu ");
INSERT INTO jid_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","nikogon wa a ta shimen ni beh almajeran ma ba lu tika ndi ana hla naki uba kpayemen ni nasi ni lantre wa yesu a hla ");
INSERT INTO jid_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ngari aheni urushelima ni idi gbugbuu ba kpayemen ni iden ma ni wa ba igban wa a tie ");
INSERT INTO jid_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","yesu na kpayeme ni bana atoh bawauu ");
INSERT INTO jid_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ana son ndu dio shaida ma ni tu indi na nitu wa a toh kpe wa a he mi ndi ");
INSERT INTO jid_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","igu ri ahi bafarise ba yomi niko dimu a hi tuzan ni mi yahudawa ");
INSERT INTO jid_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","igua lu wa yesu ye ni chu na yo Rabbi ki tohwu u malami wawu tsi ni rji ki toh idiori na toh tie kpe wa wu si tie yinna se orji he niwu ");
INSERT INTO jid_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","yesu sa niwu njanji njanji indi wa ba na la ngriji a na ana toh iko irjina ");
INSERT INTO jid_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","nikodemu a miyen bati ni heri na la ngrji indi iwa a ce ye? ana ya kban hi ri ni minen yima ba ka la ngrjina ani iya? ");
INSERT INTO jid_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yesu tre anjaji anjaji indi wa bana la ngrji ni ma mba ruhu na ana ya hiri nitra rjina ");
INSERT INTO jid_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ikpe wa ba ngrji ni konkbon kpa ahi kobonkpa iwa ba ngrji ni kon ruhu ahi u ruhu ");
INSERT INTO jid_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","na tie sisir na ni tu wa me hla ni wu a hi gbigbi ndu ba la ngri wu ");
INSERT INTO jid_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ngyugyu ni fuw hi ni werji a wa a ni son a u ya wo chu ma iwu na toh ka a rjini tsen ka ni hi ni tsen na anaki indi waba ngrji u ni ruhu a ");
INSERT INTO jid_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","nikodi mu miyen batie ki ma ni he naki? ");
INSERT INTO jid_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yesu u miyen i wu u malami ni israila u na toh iri kpe yi na? ");
INSERT INTO jid_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","njaji njaji mi si hla ni wu kisi tre kpr wa ki toh ni shaida ni yiwu na ki me bina kpa shaida buna ");
INSERT INTO jid_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","mi tie hla niwu ikpe wa ahe ni gbungbolo yi i wuna kpayemen na u tie ni heni kpayemen ni tre wa mi hla niwu u shulu ");
INSERT INTO jid_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","idiori na hon hi ni shu toh na se wawu wa a grji rji ni shu yea sei vren indi ");
INSERT INTO jid_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","na wa musa a zu wan hi ni shu ni miji na ki me gbigbi ba zu ivren ndi hi shu ");
INSERT INTO jid_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nitu biwa ba no suron ba na kpayememe ni wu ba kana tie memenana son tuntur ");
INSERT INTO jid_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","niwa irji a lo suron ni gbungbulua kpukpome na ban ivren ma riri no wa a ka suron ma no wa ka que na kason ni viri hi ni tuntur ");
INSERT INTO jid_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","irji bachi ana ton verri ye ni ndu ye ka gbungbulu a suto na amma ni ndu kpa ba chuwo ");
INSERT INTO jid_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","indi wa ayo suron ma niwu kana tie meme na u indi wa ana yo suron ma niwuna atie meme ye ni tu wa ana yo suron ma ni mi nde ivren ciriti na ");
INSERT INTO jid_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","a ni tu kima ibla tre he ni tu wa ikpan ye ni gbungbulua u ndi ba son bwu zankpan ni tu meme tie mba ");
INSERT INTO jid_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","wawuu indi wa ani tie meme kpe a ni kama ni kpan nda na ni hi ni kpan na don ndu bana toh meme tie mana ");
INSERT INTO jid_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","sei indi wa ani tie njanji ani ye ni kpan nitu tie ma wa ba toh ni rira me a ndi da ni tie niwu rji ");
INSERT INTO jid_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ni kogon kima yesu ni almajeran ma ba lu hi yanki igbu judea ni ki ason hi ni ton ri niba natie batisma ");
INSERT INTO jid_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","yahaya me ni tie batisma ni aino whiwhire ni salim nitu ima he ni ki babran indi baye niwu wani ti batisma ");
INSERT INTO jid_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ba na rigen yo yahaya ni mi tra u tro na ");
INSERT INTO jid_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","u kbonronkpa lude ni mi almajeran yahaya ni indi u yahuda nitu al adun tsarka kewa ");
INSERT INTO jid_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ba luhi ni yahaya na tre Rabbi indi wa a he niwu ni gran ne urdun wa u shaidu wu toh asi tie batisma indi wawu ba si hi niwu ");
INSERT INTO jid_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","yahaya sa ni bawu idiori na ya fe kperina sei ba no rji ni shulu ");
INSERT INTO jid_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","biyi ni tubi bi to mi hla ni a na imeyin me Almasihuna ba ton me ye guci niwu ");
INSERT INTO jid_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","iwa sah ahi u lon ma ikpan glon zizan ikpana kri siwowu a si ngir ni wa asi wo lan likona ingir mu a shu mala ");
INSERT INTO jid_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","a hi gbibbi ni ndu shu babran u me grji ye meme ");
INSERT INTO jid_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","wawu iwa a rji ni shu a zan indi wawu ");
INSERT INTO jid_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","a shaida ikpu iwa awo na toh idiori me tie bre kpa shaida ma ");
INSERT INTO jid_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","indi iwa akpa shaida ma a kpayemmen gbigbi irji a njaji ");
INSERT INTO jid_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","indi wa irji ton a ani tre ni lan u rji ana no ruhu a ni tsara tsara na ");
INSERT INTO jid_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","itie kpayemen nl vrena na ka koggen no nriwoma ");
INSERT INTO jid_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","indi wa a kpayenmen ni vren a he ni viri son hi ni tuntur indi wa akama ni ivren ana virina ifun irji a he ni tunna ");
INSERT INTO jid_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yesu toh ndi farisawa ba wo andi almasenanma ba ye ni barbran wa ni tie batsima nizan Yahaya ");
INSERT INTO jid_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","lana yesu ni tie tuma nitie batisma na ahi almajeran mu ba sita tie batisma ");
INSERT INTO jid_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","a ka yahudiya don na kma hi ni galili ");
INSERT INTO jid_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","wa ahi gbigbi niwu ni ndu lu zu niko samariya ");
INSERT INTO jid_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","aye ni mi gbu samariya wa ba yo ni sika fwe nhan ni bubu wa yakubu a no ivren ma yusufu ");
INSERT INTO jid_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","juju ma u ykuba a he niki yesu zren nhla za na ye kuson ni yue juju a karfi wolon don hari u rji ");
INSERT INTO jid_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","iwari u sa mariya aye funma se yesu hla niwu ne ma miso ");
INSERT INTO jid_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","u almajeran ma ba lu ri hi ni migbu ni he leh biri ");
INSERT INTO jid_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","iwa u samariya niyen a ni he iwu ba yahude u miyen ma ima uso ime wa mi vren wa u mariyg? nitu yahudawa bana kabi ni samariya wana ");
INSERT INTO jid_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","yesu sa niwu una tohno miyen u rji ni indi wa a si tre ne ma uso una bre ni ndu no uima u tviri ");
INSERT INTO jid_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","iwa hla niwu mallam ga u na he ni guga u juju a naman yue grji hi kogbo ani tsen u fe ima u viri? ");
INSERT INTO jid_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","u na zari itie mbu yakubu na ka wu zari wawu wa ano la juju a wa wawume a so ni mina ni mire ma ni lado ma? ");
INSERT INTO jid_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","yesu hla niwu du indi iwa aso ni mi ma ki nhlan ma ni la yi u ");
INSERT INTO jid_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","indi wa ani so ima wa mi no nhlan ma na la tieu na ni siran kima lma wa mino a ani ka tie izin ma ni mi ma iwa ani ta gubon ta hi ni viri ma u kase se kase se ");
INSERT INTO jid_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","iwa hla niwu mallam ne ima mba wa nhlan ma na la tie me na u mi na la ye niwayi ndi tan ma na ");
INSERT INTO jid_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","yesu hla niwu hi yo ilon me di biye biwa ");
INSERT INTO jid_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","iwa hla niwu mi na he ni lilon na ");
INSERT INTO jid_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","nitu wa u gran lilon tie ton iwa uhe niwu zizan ana lon mena ikpe wawu tre a a njanji ");
INSERT INTO jid_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","iwa tre ndi mallam mi toh u annabi ");
INSERT INTO jid_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ba tie mbu ba ta tre ni rji ni tugbulu yi u bi tre urushali ma yi a bubu wa indi ba tre ni rjiia ");
INSERT INTO jid_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yesu hla niwu iwa kpayenme ni me ni suron me ndi bi na la tre ni rji ko ni tu gbulu ko ni uri shalima na ");
INSERT INTO jid_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","bi si yi sujada ni ndi wa ki tohua kpa chuwo a he ni yahuda wayi ");
INSERT INTO jid_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","mitoh iton niye natsara wandi bi hu rji ujanji ba tre ni tre mbu ni mi ruhu ni njanji ni tu indi bibi kima irji ni wa ba ni ndu ba tre niwu ");
INSERT INTO jid_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","irji a hi ruhu indi wa ani tre niwu a hi gbigbi ni ndu ba tre ni mi ruhu ni njanji ");
INSERT INTO jid_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","iwa hla niwu mi toh Almasihu ni ye ani taye ani hla koge ni tawu ");
INSERT INTO jid_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","yesu hla niwu imeyi mi wawu iwa ndi asi tre ni u ");
INSERT INTO jid_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ni mi ton ki almajeran ma ba kbanye u ba kban ni tie sisir ikpe wa yo ani tre ni wa u iri mba a miyen u son geri? ka ahigeri yo u si tre niwu? ");
INSERT INTO jid_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","iwa kagbazima don na he ni mi gbu na hla ni indiba ");
INSERT INTO jid_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ye toh iguri iwa a hla koge wa mi tiea ana wa wuyi almasihu na ka ani nha ");
INSERT INTO jid_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ba lu bri ni gbu a da hi niwu ");
INSERT INTO jid_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ni ton kima almajerana ma luni bre wu andi mallam rhi ");
INSERT INTO jid_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","i wa hla ni bawu andi mi he biri iwa bina toh kpe ri ni tumana ");
INSERT INTO jid_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","almajeran ba tre ni kpa mba ko idioiri me nji niwuna ka idioiri nji ye? ");
INSERT INTO jid_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yesu hla bawa biri mu a hi ndi mi tie ikpe wandi wa la ton me ye ni du me kle ndu ma ");
INSERT INTO jid_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","nda bi tre dia don iwuya nzah ni du ba yi gri bi? mi hla niyiwu ni woloshi bi ya irjuba ba makan u chan ");
INSERT INTO jid_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","indi wa asi chan ani kpa die na shu biri u rju kabi na nji hi viri utuntur ni naki indi u chu ni indi chan ba gir ha mba ");
INSERT INTO jid_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","nitre yi iri ni chu batre di iri ni chan ajanji ");
INSERT INTO jid_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","i me ton u ndu u hi chan ikpe iwa wu na tie ndu ma na a bari mu ba tieye u luri ni mi ndu mba ");
INSERT INTO jid_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","igra samariyawa ba he ni gbu a ba kpayemen niwu niyu kpe wa iwa a tre ni tuma a a hla kle pyen pyenme ikpei waatatia ");
INSERT INTO jid_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","u samariyawa ba ye niwu na bre ni ndu ye son niba waye son niba tic vi hari ");
INSERT INTO jid_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","gbugbumba ba kanhan hi biwa ba kpanyme nitu lantre ma ");
INSERT INTO jid_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ba tre ni iwa ndi kpanyme mbu ana nitu kpewa wu hla na a nitu wa kita kikimbu ki wowu nito ndi janji iwayi yi u kpa gbungbl chuwo ");
INSERT INTO jid_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","niwa vi ha baki baka hi a rhu don bubuki nda ku nko Galilee ");
INSERT INTO jid_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","yesu kima ana bla ndi bana ya anabi ni nfutu ni gbumeme ma na ");
INSERT INTO jid_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","niwa aka ri nimi Galilee bi Galilee bu ba kpaa ni woha bana to wawu kpi wa ana ti ni igan u urushelima nitu baba me bana hi ni igan a ");
INSERT INTO jid_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","zizan ala ye ni cana bubu wa a kma ma ti ihia kikle nikon ri u bi tu chu wandi ivren ma ana kru lo kpa ");
INSERT INTO jid_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ni wo ndi yesu ye wruwru ni judiya rhini Galilee a hini yesu nda ka myeu du huu grji hi nda hi chulilo rhu ni vren ma wa ana ti weweire u kwu ");
INSERT INTO jid_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","mle yesu a kri tre niwu ndi hama bi to kpe u chu tsro nda nu sisri bina kpanyme na ");
INSERT INTO jid_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ninkon gua a hla wu ndi mi niu ninkon me grjiye ri du vren mu kwu ");
INSERT INTO jid_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yesu a lhawu ndi hi vren me he ni sisren tgua a kpanyme ni lantre wa yesu a tre niwu nda hi kpama ");
INSERT INTO jid_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","niwa a sia grji hia mriko nduma ba zontu niwu nda ni hla ndi vren ma he ni sisren ma ");
INSERT INTO jid_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","niki a mye ba nton wa ikpa a lu si sia ba sa wu lanren ni nton u tangban lilo kpa a akawu chuwo ");
INSERT INTO jid_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","nikima itia a tika ndi ana ni nton kimayi yesu a tre ni wu ndi vrenme he ni sisren niki wawu nikima mba wawu bikoma ba kpanyme ");
INSERT INTO jid_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","iwayi ana kpe itsro u ha wa yesu a ti niwa aye ni Judiya rhini Galilee ");
INSERT INTO jid_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ikype waa a hu gon wa, igan u Yahudawa a he, u Yesu alu hi ni Urushalima. ");
INSERT INTO jid_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nimi Urushalima whie ni nkontra nt'ma u yii maa he kima wa ba yo ndi Baitasda ni lme Larabawa waa a he ni nkontra bi nzre. ");
INSERT INTO jid_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gbugbu ndji bi lilo, bi fyen, bi cbi, bi khwu kpa, ba gru ni maa. ");
INSERT INTO jid_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","U maleku Bachi ata grji hi nda hi cu maa ni nton bari, u ndji wa a guci sa za ni maa ni nton wa maa si cu'a, ani fe don ni ko bi lilo riame wa ata lo'a. ");
INSERT INTO jid_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","U ndji ri ahe kima wa'azi lo tie ise tra don tandra. ");
INSERT INTO jid_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wa Yesu a to ndi a kakru ni ki, u wa a kma toh ndi ndji a kru ni kii gbaa me nda hla niwu, “Wu son wu kpa sikpa? ");
INSERT INTO jid_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yonde Mallam, mina he ni dio rina iwa ani ban me yo ni mi takpo ma wa ba chuwu ana mita lu ndi mi ri hi ni mi u ndiri ka tie gbla ri Kuchi mu. ");
INSERT INTO jid_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu hla niwu, lunde, ban bubu kuru ni zren” ");
INSERT INTO jid_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hihari Igu fe si, na ban bubu kuru ma na hi kpama. Nivi u Asabar ma. ");
INSERT INTO jid_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yahudawa ba miyen Igu iwa ba chu lilo rju niwu, “Luwa a Asabar, ana bi ni ndu ban bubu kuru me na.” ");
INSERT INTO jid_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“I wa hla ni bawu ahi ndi wa a chu lilo rju ni mu'a, 'A tre ban bubu kuru me ni lu zren.'” ");
INSERT INTO jid_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","U ba miyen, Ahi nahn hla tre ki wu, ban ni lu zren? ");
INSERT INTO jid_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wawu indji wa ba chu lili niwu'a, ana toh indji iwa a chu lilo rju ni wu na, Yesu lunde hi kpama ni yayinbi nitu jumbu indji gyen klan ki niki. ");
INSERT INTO jid_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ni kogon niki, Yesu ka fe ni mi korji, na tre, toh mba, U fe si, nan lah tatre gan na, ni ndu meme ikperi iwa a lah zan iwayi ndu lah vu na.” ");
INSERT INTO jid_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Igu luhi na ka hla ni anabawa ba andi ahi Yesu mba a chu lilo rju ni wawu. ");
INSERT INTO jid_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nitu ki, anabawa ba lu ni ti Yesu kyalala me nitu ti kpe ke ni vi u Asabar. ");
INSERT INTO jid_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu sa ni bawu, “Itei mu asi tie ndu ye zizan, Imeme mi tie ndu'a.” ");
INSERT INTO jid_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nitu ki, Yahudawa ndi ba wu'u ana nitu iwa a ka hu doka u Asabar, kan grjin na, ala yo Irji tie Itie ma, na ban tu ni zrazra ni Irji. ");
INSERT INTO jid_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ka sa ni bawu, “A njanji, anjanji, Ivren na ya tie ni ngrji ma na, se a toh Itie bubu tie, ikpe iwa Itie ni tie ivren anki me ivren ni tie. ");
INSERT INTO jid_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Niwa Itie'a ani son Ivren na zro ko ge wawu'u wandi ani tie, ani zro igbi bi rigran ma iwa ba zan wa yi'a ni ndu yi tie sisir. ");
INSERT INTO jid_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Na iwa itie ta bi que shimen na no re iviri ana ki me Ivren ani no iviri ni ko nhan iwa ani son'a. ");
INSERT INTO jid_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Itie chi idio-ri ban na, na ka chuban no vivren. ");
INSERT INTO jid_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ni ndu indi wawu ndu ba ni funtu ina iwa ba toh Itie'a ni funtu'a me. Indji wa ana toh Ivren ni funtu na ana toh Itie me ni funtu na iwa ton ye na. ");
INSERT INTO jid_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A njanji, anjanji, Indji wa a wo tre mu'a na kpa yenme ni Indji wa a ton me ye'a ahe ni viri hi ni tuntur kuma ana tie meme na ani vuque yaba hi ni viri. ");
INSERT INTO jid_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A njani, a njanji, mi hla ni yiwu iton ni ye, har me a yeye iwa ik'bon me ba ba wo lan tra Ivren Irji, bi wa ba wo ba nawo. ");
INSERT INTO jid_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ni wa Itie a he ni viri ni wu a, ana ki me ano Ivren Iviri mi ma u tuma kima. ");
INSERT INTO jid_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Itie a no Ivren son, tuma i wa ani ya ga tre (chu ban), nitu ahi wawuyi a Vren Ndji. ");
INSERT INTO jid_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na tie sisir na yi, iton ni ye iwa biwa ba he ni mebeh wawu ba wo lan tre ma ");
INSERT INTO jid_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na rju yei biwa ba tie ndindi ba lunde hi ni viri (re) biwa ba tie meme ba luhi ni fu ton (que). ");
INSERT INTO jid_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mi na ya tie kperi ni tu muna. Na wa mi wo'a, ana ki mi futon, futon mu a u adalci, ana ni son u tumu na, a tu Indji iwa a ton ye. ");
INSERT INTO jid_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mi tie shaida ni tumu kimu, shaida na hi u njanji na. ");
INSERT INTO jid_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","indji ri he iwa asi no shaida ni tumu, mi toh shaida iwa asi no ni tumu, ahi shaida u njanji. ");
INSERT INTO jid_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bika ton ba hi ni Yahaya, ani no shaida u njanji. ");
INSERT INTO jid_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Na kima, shaida iwa mi kpa ana shaida u indji na, mi hla biyi ni yiwu ni ndu jubu hi viri. ");
INSERT INTO jid_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya a hi fitila u ri, u kpan me bika kpayenmen ni yo si sonron ni kpan mani ton zah me. ");
INSERT INTO jid_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","U shaida wa mi he niwu a zan u Yahaya ni gbengbenle ni ndu wa Itie ni ndi mi tie'a, wato jiji bibiri indu bi wa mi si tie, biki ba si shaida mu andi, ahi Itie a ton me. ");
INSERT INTO jid_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Itie wa a ton me, wawu ui a shaida me. Bina tie bre wo lan toh ni na toh a he ni he nako quen ri. ");
INSERT INTO jid_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Itra ana son ni yiwu ni mi dri bina, ni tu wa bi na kpayenmen ni Indji wa a ton Me yena. ");
INSERT INTO jid_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Biki kra viwu bla tra Rji ni ya bi ndi niki bi fe iviri u son tuntur, iwawu vuvu kima a shaida ni me, ");
INSERT INTO jid_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","bina yo sonron me u ye ni mena wa bi fe viri na. ");
INSERT INTO jid_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi na kpa gber san ni ndji na ");
INSERT INTO jid_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mi toh bina he ni son Rji ni mi idri mbi na. ");
INSERT INTO jid_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi ye ni mi nde Itie Mu, u bina kpa Me na. U to iri ni ta lu ye ni mi nde ma, bi kpa wu. ");
INSERT INTO jid_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A ni he mba bi kpa yenmen ni yo sonron, biyi wa bi kpa gber san ni kpa mbi, ni na kpa yenmen ni wa gber san iwa a rji ni Irji na? ");
INSERT INTO jid_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na yo imeren ni sonron mbi andi Mi tre yi koshishi na. Indji wa a tre yi a Musa, iwa bi yo sonron mbi niwu. ");
INSERT INTO jid_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bina kpayenmen ni Musa, bina kpayenmen ni me, nitu wa a nhan me nitu mu. ");
INSERT INTO jid_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bitana kpayenmen ni nhan ma na, bi ti ni he ba ni kpayenmen ni lan tre mu? ");
INSERT INTO jid_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ni kogon biyi, Yesu rugran ba-ne Galili iwa ba yo ndji mba-ne Tibaniya. ");
INSERT INTO jid_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gbirjubu ndji gbugbuu ba lu ni hu ni kpe wa asi tie'a ni bi lilo ba. ");
INSERT INTO jid_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu lu hon hi ka son ni tu ngbulu ba-ba almajeran ma. ");
INSERT INTO jid_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Gan ri igan idin u za gran igan Yahudawa a te whir). ");
INSERT INTO jid_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu zun tu hon na toh gbugbu ndji ba gyen klan si ye niwu na hla ni filibu, “ni tsen ki fe bredi, wa ki no indji biyi?” ");
INSERT INTO jid_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(A tre naki na tsar to ni tu iwa wawu me a toh ikpe iwa ani tie.) ");
INSERT INTO jid_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibu ka ha sa niwu “bredi dena rii deri hari me ana zrani ndji fie fie me na.” ");
INSERT INTO jid_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iri ni mi Almajere ma Andarawus, vayi siman Bitrus, hla ni Yesu, ");
INSERT INTO jid_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ige Ivren ri a nji igbele ton u shai'ir ni lambe hari. a geri iwa yi ni tie ni gbugbu indji bi yi?” ");
INSERT INTO jid_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu tre ndu indji kuson.” (Bubu'a me a tie gega.) U lilon ba ba kusun, tsra indji dubu ton. ");
INSERT INTO jid_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","U Yesu a ban bredi ni kogon wa, a gira na ga bi wa ba kusun meme na la ga lambe naki, na wa ba ba son. ");
INSERT INTO jid_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Niwa indji ba-ba whurji wa hla ni almajere ma, “ni ndu ba vu gburugbuma iwa a don ba shutie, ni ndu na tie meme na (asara na).” ");
INSERT INTO jid_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","U ba vu shu ni sisen wulon don hari gburugbu bredi u sisen iton wa ba don mbru ma, ni kogon wa bari whrji. ");
INSERT INTO jid_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","U indji ba toh gban iwa a tie, u ba tre, “A njanji iwa yi ahi anabin iwa ani ye ni gbungbunluyi.” ");
INSERT INTO jid_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","U Yesu toh ndi ba lu ni ye ban wuni gbengbenle na nye-wu tie Ichu, na lu k'ban hi ni tu gbulu kima. ");
INSERT INTO jid_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","U yalu tie almajere ma ba lu grji hi ni teku. ");
INSERT INTO jid_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na ri ni mi ghu, na rugran hi ni Kafarnahum, (ni ton wa ibwu tie ye, Yesu na ye ni ba rina.) ");
INSERT INTO jid_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gyugyu ri u gbengbenle ma u njanji ni rhi, teku ni lu ni kinkir. ");
INSERT INTO jid_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nikogon wa ba dran ghu hi na mil ashiri don ton ko talatin, u ba kushi ni Yesu a zren nitu teku siye na te whiwhir ni jirgi'a, u ba ti sisir. ");
INSERT INTO jid_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iwa hla ni ba wu, ahi me, na tisisir na.” ");
INSERT INTO jid_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Niki u ba kpayenmen na kpa ni jirgi'a, hihari me jirgi ka ri ni gacci (bubu u jundi zi'a). ");
INSERT INTO jid_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ni ivi u ha ibrun klan ndi wa ba krhi ni gran teku ni korima ba tra andi jirgi ri na la don gan na niki se iri, iwa ndi Yesu na ri hu almajeran ma na u ba luhi ni grji ba. ");
INSERT INTO jid_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Se jirgi bari wa ba rji ni Tibariya whiewhir ni bubu wa indi ba son na tan gurasa ni kogon wa Yesu a ngiri'a. ");
INSERT INTO jid_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Niwa indji ba ye toh andi Yesu ni almajaren ma ba he ni ba niki na, ni tie tu mba ba lu ri ni mi jirgi ba na hi ni Kafarnahum ni wa Yesu. ");
INSERT INTO jid_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na ka toh ni gran teku'a, na miyen “Mallam, anitan mba u ye ni wayi?” ");
INSERT INTO jid_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu a sa ni bawu andi, “Njanji, bi si wame yi, ana ni tu wa bi toh igban ikpe wa mi tie'a ni ye na, a nitu wa bi tan gurasar ni wherji. ");
INSERT INTO jid_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ban chuwo ni tie kpabi ya ni bubu wa biri wa ani tie meme na, se bi ka wa biri iwa ani son kubon na nji yi hi ni viri (re) u tunturu iwa vren ndi ni no yin'a. ");
INSERT INTO jid_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bika miyen, “ahi geri ki tie iwa ani hu son u Rji'a? ");
INSERT INTO jid_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu sa ni bawu, “iwa yi a hi ndu Rji, ni ndu yi kpayenmen ni indi iwa a ton'a. ");
INSERT INTO jid_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","U ba miyen, “ahi nkpan geri u tie, ni ndu ta toh, u ni kpayenmen ni wu'a? ");
INSERT INTO jid_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ahi geri u tie? Ba tietie-mbu ba tan manna ni miji nawa ba nhan, “Iwa no ba gurasar rji ni shu ni ndu ba tan.'” ");
INSERT INTO jid_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu hla ni bawu, “Njanji, mi si hla ni yiwu, ana Musa yi noyi gurasar rji ni shuna ahi Itie mu mba a no yi gurasar u njanji rji ni shulu. ");
INSERT INTO jid_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gurasar u Rji ani krji rji ni shu na no iviri ni gbungbulu'a.” ");
INSERT INTO jid_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","U ba hla niwu, “mallam, ta nota gurasar bi kima ko ni ton rime.” ");
INSERT INTO jid_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu hla ni bawu, ahi meyi mi gurasar iwa ani ano iviri (re) indji wa a ye ni me iyon na tiwu na, indji wa a kpa yenmen ni me hlan ma nala tie wu gana. ");
INSERT INTO jid_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ndi mi hla ni yiwu, njanji bi toh me, naki me bina kpayenmen na. ");
INSERT INTO jid_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Indji wa Itie a ne niwu'a ani ye nime, iwa a ye nimea mina zu menmelen mu na. ");
INSERT INTO jid_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mina grji rji ni shu ye, nitu mi tie ikpe iwa me son ki mu na, se de ikpe u son Indji iwa a ton Me. ");
INSERT INTO jid_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A hi wa yiyi ikpe u son indji wa a ton me, ni ndu mina wa kperi hanma ni mi biyina niwa ani se mika taba shimen ni vi u klakla'a. ");
INSERT INTO jid_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ahi wayi, i ahi son Itiemu, ndi indji iwa a toh vren na kpayenmen wu ani fe viri u son kuk'bon. Ime ni tashimen ni vi u klakla'a. ");
INSERT INTO jid_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yahudawa balu ni chaba gburgbu ni tuma, nitu iwa atra, “Ahi meyi mi Gurasar iwa grji ni shu'a. ");
INSERT INTO jid_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba tre ana wayi, i ahi Yesu Ivren Yusufu, iwa Itima ni Iyima wa ki toh ba na? A ni he ri zizan ani tre andi mi grji rji ni shu? ");
INSERT INTO jid_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu hla ni bawu, “Ba chuwo ni chaba mlama ni kpabi. ");
INSERT INTO jid_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ba iri iwa ani ya ye ni me, se Iti mu wa a ton me ye a njiwu ye, mit tawu shimechachu u kekle. ");
INSERT INTO jid_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ba nha nyi nha zi ni mi littatafe ana bawa andi, wawu mbawu Irji Bachi ni tsoro ba, u indji wa a wo ni tie, ani ye ni me. ");
INSERT INTO jid_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Niwa idiori ti bre to ni tie'ana, se wawu iwa a rji ni Bachi - a to Bachi. ");
INSERT INTO jid_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Njanji, njanji, indji wa a kpawu nyeme ahe ni iviri u tuntru. ");
INSERT INTO jid_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ihe me nyi mi bredi u viri. ");
INSERT INTO jid_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ba ti bi ba ri mana ni miji, na kwu. ");
INSERT INTO jid_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","I wa nyi ahi bredi u wa a grji rji ni shu ndi indji wa a ri ngbala ma wa ka na kwu na. ");
INSERT INTO jid_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ime nyi mi gurasa u re (iviri) wa a grji rji ni shu. Indji iwa a ri ni mi gurasa, ani son hi tuntru gurasa yi wa mi no ahi kpamu nitu kpa gbungbulu chu wo.” ");
INSERT INTO jid_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yahudawa ba tifu nimi mba na ni sen nyu ni kpamba'a andi ani he iguyi ani ya nota inan ma kpama ki tan? ");
INSERT INTO jid_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","U Yesu hla bawu, “Njanji, njanji, bita na tan inanma kpa ivren indji na ni nan so iyin mana, bi na fe iviri ni mi bina. ");
INSERT INTO jid_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Indji iwa a tan nanma mu na so inyi mu ani Iviri tuntru, mila zun lude ni ivi u kekle. ");
INSERT INTO jid_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A hla bawu, “Ikisa mi nhla ni yiwu. Nitu inanma mu ahi biri u njanji, iyi mu me ahi ikpe u so u njanji. ");
INSERT INTO jid_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Indji iwa a tan nanma mu, na so iyi mu a son ni mi mu, imeme mi son niwu. ");
INSERT INTO jid_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na wa itimbu u iviri a ton me, naki mi zren na ti'a, ana ki indji iwa a tan nmma mu, ani son nitu mu. ");
INSERT INTO jid_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iwa yi ahi gurasa iwa a grji rji ni shulu, ana iri u ba tibi wa ba tan na kwu na, indji iwa a tan gurasa ani son tuntru.” ");
INSERT INTO jid_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu hla kpi biyi ni mi ma, njamiya niwa a si tsoro ba ni Kafarnahum. ");
INSERT INTO jid_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ni wo naki, gbugbuwu ni mi almajaranma ba tre, itre yi a hi ni krifi, i he nha ani ya wo wu?” ");
INSERT INTO jid_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu ato ni mi soron ma andi almajereanma, basi chabangbu ru ngbu kima, na miyen ba, “Iwa yi kati lahtre? ");
INSERT INTO jid_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ani he nihe bi ti to ivren indji ni hon ni hi ni bubuma u sen na? ");
INSERT INTO jid_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhu ni iviri, ikpa na ti kperi na. Ahi tre wa mi tre ni yiwu hi Ruhu, u ba ivri. ");
INSERT INTO jid_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ni naki bari mbi ni wayi bana kpa nyime na.” U Yesu toh rji ni mumla'a wawu biwa bana kpa nyime na nda toh ndji wa ani ka'u no dun ba wu'u. ");
INSERT INTO jid_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A hla ndi, “A nitu kii mba mi hla ni yiwu ndi ndrjo ri na ye nime na se to Bachi mu no'u nkon dun ye nime.” ");
INSERT INTO jid_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ni kogon kima, gbugbuu ba k'ban hi ni kogon nimi almajanre ma, bati bre hla zren ni wu ngana. ");
INSERT INTO jid_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu minye wulon don hari ba, biyi bi na son hi na, ka nan nakina? ");
INSERT INTO jid_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bitrus a sa niwu, iwu timbu, ni nha ki hi niwu? Iwu nyi u he ni itre re (ivir) son hi tuntru. ");
INSERT INTO jid_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kita ki to ni kpanyeme iwu yi u tsatsra ichu u Rji.” ");
INSERT INTO jid_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu hla bawu, “Ana me mi chu yi na, biyi wulon don hari na, iri ni mi bi ani ahi ibirji?” ");
INSERT INTO jid_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Asi tre ni Yahuda vivren Siman Iskariyoti, a hi ri ni mi wulon don hari ba, iwa ani ka yesu noba'a. ");
INSERT INTO jid_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ni kogon kpi biyi Yesu zren kagon mi gbu Galili, ni tu wa ana son ri ni mi ingbu Yahudiya nitu Yahudawa ba mla ki si gben ndi ba wu'u. ");
INSERT INTO jid_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","U igan idin u Yahudawa tewhire. ");
INSERT INTO jid_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","U miri vayi ma ba hla niwu, “Lunde hi ni Yahudiya ni ndu almajeran me ndu ba to ikpi wa u si tre ba'a. ");
INSERT INTO jid_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Idiori, nati kperi ririna inde ani son ndu indji ndu ba to wawuu, nitu wa u tie ikpi biyi u tsoro tume ni rira ni ngbungbulu'a ");
INSERT INTO jid_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nitu wa imri vayi ma me bana kpanyime niwu na. ");
INSERT INTO jid_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu hla ni bawu, iton mu na tsira rina, ka iton bi ni he ni tan. ");
INSERT INTO jid_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gbungbulu'a ba na ya kamba niyi na, a kama ni me nitu wa mi hla ni bawu andi indu a hi memme. ");
INSERT INTO jid_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bika lunde hi ni idin, ime mi na hi na iton mu tsira rina. ");
INSERT INTO jid_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ni kogon iwa a hla ikpi biyi, a kuk'ri ni Galili. ");
INSERT INTO jid_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ni kogon wa imiri vayi ma ba hi ni rira na. ");
INSERT INTO jid_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nitu iwa Yahudawa ba si wa'u ni bubu indji'a, nani minye, a he ni ntsen? ");
INSERT INTO jid_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Rju, rju itre ba he nituma gbugbu'u nimi kuson'a, bari mba tre a hi Indji ndindi, “Ahi Ndji u toh ti.” Bari mba ba tisan, andi an, an aye kpa soron ndji ni kasran. ");
INSERT INTO jid_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ni naki me idiori na tre ni rira ni tumana nitu sisir Yahudawa. ");
INSERT INTO jid_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Niwa ba ri igan indji ka ri ni zuzma, u Yesu lu ri ye hekali na (fara) ni tsroroba. ");
INSERT INTO jid_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudawa ba luni ti sisir na ni tre, “Ani he iguyi he ni bibi kpran gbugbu'u na yi? Iwa na hi ni magrata na. ");
INSERT INTO jid_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kasa ni bawu, “Itsroro mu'a ana umu na, a u Indji wa a ton me ye'a.” ");
INSERT INTO jid_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Indji wa ani son ti kpi iwa ani son'a ani ya to tsoro mu'a ko a rji ni Irji, ko mi tre u mu kimu. ");
INSERT INTO jid_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko inha wa ani tre u tuma, ani wa kpandema mu, ko ahi nha iwa awa kpande Indji iwa a ton me, Indji ki a wu njanji, ikpiri meme ma na he niwu na. ");
INSERT INTO jid_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa na nuyi ndu na? Ni naki iriri ni mi mbi ana hu ndu'a na. U ahi geri mba ni yoyui ni ndu yi wu me? ");
INSERT INTO jid_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ison indji ba hla niwu, “U he ni brji. Ahi nha mba ni son wu'u?” ");
INSERT INTO jid_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu hla bawu, mi ti indu iriri migen, u bi ti sisir wawu mbi. ");
INSERT INTO jid_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa noyi ji (ana ri ni Musa na, a rji ni ba Ti-Iti, Tima), ni ivi u Asabar bi no indji iji. ");
INSERT INTO jid_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Indji nita kpa ji, ni ivi u asabar nitu, nduba na lahtre ni du Musa na, ahi ngeri mba noyi infu ni wa ndi mi chu lilo wawu rju ni indji wa a hi lo'a ni ivi asabar? ");
INSERT INTO jid_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na tron ni ya shishi na, tron ni u njanji.” ");
INSERT INTO jid_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bari mba rji ni Urushelima ba tre, “Iwa ana indji iwa ki si wa ndi ki wu ana? ");
INSERT INTO jid_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","To, a tre dedeme, u ba na tre kperi meniwu na. Ana bi na ni ndu bi chu ndi ba to a ndi i wayi a hi Kristi na, ka ana naki na? ");
INSERT INTO jid_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Naki, kito i wurji iwa a rji. Ni ton iwa Kristi ni ye, idiori ana to iwurji wa ani rji'a na.” ");
INSERT INTO jid_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu tre ngbngban me ni mi heke li'a na ni tsoro ba na ni tre, “Bi to me ni to i wurji iwa mi rji. Mina ye ni tu muna, mi ye nitu indji wa a ton ye a hi njanji biyi bina to wu na. ");
INSERT INTO jid_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ime mi to mi rji ni wawuyi, a wawuyi ton me.” ");
INSERT INTO jid_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Balu ni son vu u diori na ya bre wo niwu na iton na tsira rina. ");
INSERT INTO jid_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Indji gbugbu ni mi mba ba kpa nyeme niwu, u ba tre, “Yesu ni ta ye, ani ti zan wayi wa ndi ati ba yi? ");
INSERT INTO jid_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisawa ba wo indji ba tre toto nitu Yesu, Malami bi nikon ni Farisawa ba ton bi gben ndu ba hi vu. ");
INSERT INTO jid_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu tre, “Miri he ni yi za mi ni vi ton ni k'ban hi ni Indji wa a ton Me. ");
INSERT INTO jid_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bi wa me bi na to mena, bubu iwa mi hi'a, bina ya hina. ");
INSERT INTO jid_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudawa ba lu ni miyen kpamba, ani tsen iguyi ni hi wa kina ya hi to'a na? Ko ani hi ni Helinawa ba si yar ani hi tsoro Helinawa? ");
INSERT INTO jid_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A hi lan birime a ni tre naki, bi wa me u bina to me na, iwurji me hi'a na, bina ya hi na?” ");
INSERT INTO jid_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ni vi u kekle'a, ki kle ivi u idin, Yesu lu kri kri na yar yin gbangban, na hla, “Indji wa lan ma nita ni tiwu wa ka ye nime na so. ");
INSERT INTO jid_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Indji wa a kpayenme ni me, ina wa itre Irji'a a la, ni mi ma iba u re (iviri) ba gukbon ni mi ne ma.” ");
INSERT INTO jid_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A tre naki nitu Ruhu (Ibrji ndindi), ni biwa ba kpa yeme niwu'a iki ba kpa, bana nu Ruhu (ibrji) rina, nitu wa bana gbre Yesu san rina. ");
INSERT INTO jid_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bari ni mi son'a ba lan tre ba naki, na tre, gbigbi iwa yin a hi ana ebi yi.” ");
INSERT INTO jid_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bari ba tre, iwayi a hi Almasihu.” U bari ba tre, “Almasihu ni rji ni Galili? ");
INSERT INTO jid_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nda tre Irji hla Almasihu ni rji ni mi mla Dauda ni Batalami na, rji ni mi vi gbu wa Dauda rji? ");
INSERT INTO jid_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","U ba ga kpa ni mi son nitu ma. ");
INSERT INTO jid_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wa bari mba ba vu, idiori na yowo na. ");
INSERT INTO jid_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Niki bi gben'a ba kaban ye ni Firistoci bi nonkon'a ni Farisawa biwa ba tre, “Ahi ngyeri sa bina njiwu ye na? ");
INSERT INTO jid_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bi gben ba tre, ko diori na ti bre tre nayi. ");
INSERT INTO jid_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisawa ba sa ni bawa, “Ba kpayi kasran? ");
INSERT INTO jid_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ka iri ni mi chuba a kpanyeme niwu, ka ni mi Farisawa? ");
INSERT INTO jid_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Indji bi son yi ba na to tron na, ba ti meme ye. ");
INSERT INTO jid_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus hla ni bawu, wawu wa a ye ni Yesu, ni ri ni mi Farisawa, ");
INSERT INTO jid_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Indu mbu tre ni ndu fu ton nidi ndi ri ni wo ikpe iwa a ti'a? ");
INSERT INTO jid_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","U ba minye, iwume u rji ni Galili? ban ya ni hla anibi wa ani ya rji Galili'a. ");
INSERT INTO jid_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Niki indji wawu ba lu shan hi ni ko'mba. ");
INSERT INTO jid_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu hi ni gbunlu Zaitun. ");
INSERT INTO jid_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ni mbubele a ka ban ye ni hekeli, indji wawu'u ba kaban ye niwu, aye kuson na si tsoro ba. ");
INSERT INTO jid_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Se bi nha ni Farisawa ba nji Iwa wandi ba vu asi tie ngyungyu, u ba yo ni tsutsu mba. ");
INSERT INTO jid_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","U ba tre niwu, Malan, Iwa yi ba vu ahe ni mi si ti ngyungyu. ");
INSERT INTO jid_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ni du Musa, a tre ki ta bi indji bi ki, Iwu u tre nigen ni tuma?” ");
INSERT INTO jid_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","U ba tre naki ni ndu sa tre ni ndu ba fe ni ikpe wa ani kpa ndema tie meme (Ko latre), u Yesu sontu grji na si nha ni menme ni vren wo. ");
INSERT INTO jid_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","U ba kamba na kri ti tutu bubu miyen, wa lukri ni ndide na hla bawu, “Indji ri ni mi biwa ato ana latre na, ka guci ta. ");
INSERT INTO jid_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A la sontu grji na nha ni vren woma. ");
INSERT INTO jid_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba wo naki na lu shan rju ni yi yir ri ni ninkon, na ka Yesu don ni grjima, mba Iwa wa ba na yo ni tsutsu mba. ");
INSERT INTO jid_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu lu kir dinde na miyen, “Iwa, bi wa ba nha wu ba he ni tse? Idiori na nhau na? ");
INSERT INTO jid_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wa hla ba diori, (Ubangiji), “Yesu tre, imeme mina nhawu na, hi na la latre ganna. ");
INSERT INTO jid_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu tre niba ganri, andi, “I hi me yi mi kpan u gbungbulu, Indji iwa a hume ana tre ni bwuh na ama ani he ni kpan u re (iviri).” ");
INSERT INTO jid_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisawa ba tre niwu, “U zi tre nitu ikpe wa wuto'a nmitu tume, ana njanji na. ");
INSERT INTO jid_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu sa nibawu na hla, mi ti sheda tu mu me, ahi njanji, mi to iwurji wa mi rji ni wa mi hi'a, biyi kuko bina to wurji wa mi rji'a na, bina to wurji wa mi hi'a na. ");
INSERT INTO jid_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bi tron u son tu, ime na tron to ni diori na. ");
INSERT INTO jid_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko mina tron ni diori me, itron mu mu'a a u njani nitu ana me kankrji mu na, ki he mbu Iti mu wa a ton me. ");
INSERT INTO jid_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ee, Ana ki ni du wa ba nha mi tre bitsi, andi sheda indji hari a njanji. ");
INSERT INTO jid_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ahi me yi mi sheda itu mu, u Itimu iwa a ton me a sheda mu.” ");
INSERT INTO jid_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba miyen, “Iti me ahe ni tsen?” Yesu hla ni bawu bina tome na, me bika tre Itimu, bina to me, bina to Iti mu'a me. ");
INSERT INTO jid_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A hla tre biyi whirewhir ni bubu wa ba zi kpi wa si tsoro ba tre Rji ni mi hekeli, idiori na vu na nitu iton ma na tsira rina. ");
INSERT INTO jid_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na hla bawu bru, mi hi biwa bina to me na, bi kwu ni mi latre bi. bubu wa misi hi'a, bina ya hi na. ");
INSERT INTO jid_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudawa ba tre, ani wutuma mu, na ni tre iwurji wa mi hi'a bina ya hi na?” ");
INSERT INTO jid_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu hla bawu biyi bi rji ni meme, u me mi rji ni shu. Bi he ni gbungbulu yi, ime mina rji ni yi ni gbungbulu yi na. ");
INSERT INTO jid_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iki sa mi hla niyu bi kwu ni mi latre bi. Bitana kpayemmen ni soron bi andi a hi me na, bi kwu ni mi latre bi. ");
INSERT INTO jid_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","U ba tre niwu, awu nha? “Yesu hla ba wu, ikpe mi hla rji ni mumla. ");
INSERT INTO jid_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi he ni kpi gbugbuwu wa mi hla ni yiwu, ni gbi ton ni yiwu ni tuma. Naki me, indji wa a ton ndu, andi u njanji, ikpi wa mi wo niwu'a a baki mi si hla ni gbungbulu ba.” ");
INSERT INTO jid_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bana tona ndi asi tre nitu Iti'a. ");
INSERT INTO jid_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu tre, bita zu Vren Ndji hi ni shu ri bi to ndi a hi me, ndi mi ti kpi ri ni tumu na. Na wa Iti tsoro me, naki mi si ikpi ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wawu wa a ton me ndu'a, ana ka me don kan grji mu na, ahe ni me nitu kpi wawu wa me ti'a ani kpa soron ma si.” ");
INSERT INTO jid_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wa Yesu si hla bi mba, indji gbugbu'u ba kpa yemme ni wu. ");
INSERT INTO jid_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu hla biyi ni Yahudawa biwa ba wo na kpayenmen niwu, “Bi ta kli ni mi tre mu ni njanji, bi almajere mu bi nanji. ");
INSERT INTO jid_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bi to njanji, u njanji ni kpayi chuwo.” ");
INSERT INTO jid_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","U ba sa niwu, “Ki mir bi grji ba Ibrahim wa kina ti bre hu diori kan na, iwa tre ni genri, ba kpatachuwo?” ");
INSERT INTO jid_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu hla bawu, “Njani, njanji, mi hla ni yiwu, indji wa ani latre, ahi gran latre. ");
INSERT INTO jid_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Igran, na son ni ko se ka se na, ata son se ka se. ");
INSERT INTO jid_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Naki, ivren nita kpa yi chuwo, u bi nawo wawu. ");
INSERT INTO jid_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi to bi, bi igrji Ibrahim, bi son bi wuma, nitu wa lan tre mu na he ni bubu son ni mi bina. ");
INSERT INTO jid_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi hla ikpe wa mi to ni Ti mu, biyi bi ti ikpe wa bi wo ni ba ti bi'a. ");
INSERT INTO jid_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","U ba sa niwu, “Ibrahim mba a timbu, Yesu hla bawu, “Bina mir Ibrahim bina ti ikpe wa Ibrahim a ti'a. ");
INSERT INTO jid_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","U, zizan bi son wume, indji wa a hla njani ni yiwu wa a wo rji ni Rji. Ibrahim na ti naki na. ");
INSERT INTO jid_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bi ti na Iti mbi, u ba hla niwu, “Bana grji ta ni mi gyugyu na, ki he ni Iti riri, Irji.” ");
INSERT INTO jid_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu hla bawu, “Irji ana Iti bi bi na son me, u mi rji ni Irji i mi he ni yi zizan, ana ni tumu mi ye na, a wawu yi ton me. ");
INSERT INTO jid_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ahi genri sa bina ya to wo tre mu na? e bina wo tre mu na. ");
INSERT INTO jid_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bi u Ti bi, Ibrji, bi son bi hu iza ma Iti bi, ani wu ndi rji ni mumla mu ana kri ni njanji na he ni wuna, anita ni hla ice, asi hla Iti ma (isoron ma) rji ni mu a indji u ce na Iti u ce ngari. ");
INSERT INTO jid_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wa mi si hla njanji ni yiwu u bi na kpa yenme ni kpe wa mi si hla na. ");
INSERT INTO jid_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ahi nha ni ri mbi a vu me ni latre? Mi ta hla njanji u bi ka na kpayemme na? ");
INSERT INTO jid_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Indji wa a u Rji ani wo tre Rji, biyi bina wo tre Irji na, nitu wa bina u Rji na. ");
INSERT INTO jid_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudawa ba sa niwu, natre, “Kina hla njanji na nitu wa ki hla andi u indji u Samariya ni he ni meme brji?” ");
INSERT INTO jid_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu sa bawu, “ime mi na he ni Ibrji na, mi to ninkon u Timu, biyi bina to ninkon mu na.” ");
INSERT INTO jid_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mina wa to tu mu ti kperi u tu mu na, Indji ri he wa ani wa na ni gbi ton. ");
INSERT INTO jid_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Njanji, njanji, mi hla ni yiwu, indji wa a hu tre mu, ana to kwu na.” ");
INSERT INTO jid_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","U Yahudawa ba tre, zizan yi ki to u he ni brji. Ibrahim ni ana bawa ba kwu, iwu u tre, indji wa a hu tre me ana to kwu na.' ");
INSERT INTO jid_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ee, u na zan Iti mbu Ibrahim ni ninkon na wa kwu, ka u zan? anabawa me ba kwu, u ban tu ndi u nha?” ");
INSERT INTO jid_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu sa, “Mita ban tumu ti kperi u tu mu, ani u migyen, ahi Iti mu mba ban ti kperi iwa bi tre ahi wawuyi a Irji bi. ");
INSERT INTO jid_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bi mebina tou na, ime mi tou, mi ta tre mina tou na, ka mi kati iriri ni yi me, indji u ce, se me, mi to ni ni hu tre ma. ");
INSERT INTO jid_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Iti bi Ibrahim a gir ni to ivi mu, a tou na gir.” ");
INSERT INTO jid_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahudawa ba hla niwu, “Una ti hamsi (50) rina, una to Ibrahim?” ");
INSERT INTO jid_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu hla bawu, “Njanji, njanji, mi si hla ni yiwu, mi heri, ban grji Ibrahim. ");
INSERT INTO jid_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","U ba vu tita ndi ba tau, u Yesu ri tuma, na rju ni mi hekeli'a. ");
INSERT INTO jid_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","U Yesu ka si hi, nato iguri u fyen wa ndi a yar shishi tu rji ni wa ba ngrji'a. ");
INSERT INTO jid_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","U almajere ma ba miyen wu, “Mala, ahi nha mba latre, ahi gu'a ka a ba Itma ba Iyimma, wa ba ngrji ti fyen naki?” ");
INSERT INTO jid_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu hla ni bawu, ana igu'a na a na, Itima bi Iyima na wa ba la tre na, ani ndu iIti Irji tsira. ");
INSERT INTO jid_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A gbigbi ndu ta ki ti ndu wa a ton me rji ni mumla. Ichu ni ye iwa idiori na tindu na. ");
INSERT INTO jid_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ni wa mi he ni gbungbulu'a ime yi mi ikpan u gbungbulu'a. ");
INSERT INTO jid_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ni kogon wa Yesu hla ikpi biyi a ti ten yo meme, na tsie iten ni meme'a, na vu gban ni shishi gu'a. ");
INSERT INTO jid_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na hla niwu hi, ni hi ngla ni takpo ma u Siloan (wa ani hla ndi mi ton).” Igu'a luhi na ka ngla, a kaban ye na ni to. ");
INSERT INTO jid_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","U indji bi igon kanhlan mba ni bi wa ba zi to rji ni sisenmu'a ani bre, u ba tre, “ana igu yi'i wa ani son na ni bre'a na?” ");
INSERT INTO jid_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bari ba tre, a wawuyi, bari ba tisan, 'A'a, a rju wawu yi,' iwawu tre, ahime wawuyi.” ");
INSERT INTO jid_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","U ba tre niwu, ba bu'u shishi'a ni he? ");
INSERT INTO jid_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I wa sa ni bawu, iguri wa ba yo ni Yesu a hu meme na gban ni mu shishi na hla nimu, hi ni ne Siluwan ni ngla u mi hi ka ngla, u shishi lu ni to. ");
INSERT INTO jid_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","U ba miyen, “Ahe ni tsen?” wa hla, mina to na.” ");
INSERT INTO jid_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","U ba nji igu hi iwa ana indji u fyen ni Farisawa. ");
INSERT INTO jid_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ahe ni ivi u asabar wa Yesu a hu meme na bu'u shishi niwu. ");
INSERT INTO jid_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","U Farisawa ba la miyen ngari ya da a fe nito bubu, a hla bawu, a yo meme ni mu shishi u mi nglau zizan ni to.” ");
INSERT INTO jid_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ba ni mi Farisawa ba tre, iguyi a indji Rji na, ana ni to ivi u asabar na.” U bari ba tre, “Indji u latre ni ti ni heri na to ti gban biki?” ba ga kpa ti hari. ");
INSERT INTO jid_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","U ba la miyen indji u fyen ngari, “U tre ni ngeri ni tuma'a tu rji chachu iwa a bu'u shishi me?” Indji nfyen tre, ahi Anebi.” ");
INSERT INTO jid_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ye zizan me Farisawa ba me ba na kpa yeme nda ahi wawuyi indji u nfyen na wa ba bu'u shishima na se wa ba yo ba Time ni ba Iyi ma iwa a shishima bu'a. ");
INSERT INTO jid_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","U ba miyen ba Tima ni Yima, iwa yi ahi vren bi wa bi tre bi ngrji ni fifyen? Ani he mba ani to zizan?” ");
INSERT INTO jid_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","U ba Tima ba hla, “Ki to iwa yi a vren mbu wa ki ngrji ni fyen. ");
INSERT INTO jid_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ati ni nani ya, kina to na, miyen a sen ndi, ani ya tre kima.” ");
INSERT INTO jid_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ba tima ba tre biyi, nitu wa ba si tie sisir Yahudawa. Yahudawa ba ba riga zi indji iwa a tre ikpe wa ani hu gon ma andi ahi Kristi, ba ban ta yo ni mi ta kpoma. ");
INSERT INTO jid_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nitu kima, ba itima ba tre, “A sen ndi ye, miyen.” ");
INSERT INTO jid_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngari ba la yo u gyu u ha ba la yo igu fyen na hla niwu, “No Rji ni kon. Ki to igu yi a ndi u latre.” ");
INSERT INTO jid_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","I gu ki hla bawu, mina to na ka a hi ndji u latre na. Ikpe riri mi to na'a mina ndji u fyen, u zizan mi to.” ");
INSERT INTO jid_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","U ba tre ahi geri a ti niwu?” ani he a bu'u shishi niwu? ");
INSERT INTO jid_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wa hla, “Mi hla ni yiwu ye, bina wo na ahi geri bi son bi wo ngari? ");
INSERT INTO jid_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","U ba mren na hla, u almajerema, ki ta ki almare u Musa. ");
INSERT INTO jid_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ki to Irji a tre ni mu, ki na to i wurji wa iwayi a rji'a na.” ");
INSERT INTO jid_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Igu'a sa bawu na tre, iwayi a kpe u shan (mamaki), iwa bina to iwurji iwa a rji'a na, me a bu'u shishi mu. ");
INSERT INTO jid_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ki to Irji na wo indji bi latre na, indji wa anita no tuma na ni tie ikpe wa ani son, ani wo wu. ");
INSERT INTO jid_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Rji ni tuntru mu ni gbugbulu'a ki ti bre wo ndi idiori bu'u shishi ni indji wa ba ngrji ni fyen na. ");
INSERT INTO jid_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ide indji'a ana rji ni Rji na, ana ya ti kperi na.” ");
INSERT INTO jid_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","U ba sa niwu nha hla niwu, wawu'u ba ngrji ni latre, i u la si tsoro ta? U ba ban ta rju ra. ");
INSERT INTO jid_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu a wo andi ba zu rju nimi hekeli'a a wau na tre, u kpayenme ni Vren Ndji? ");
INSERT INTO jid_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wa sa na tre, “Ahi nha, Bachi, wa mi kpayenme niwu?” ");
INSERT INTO jid_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu hla niwu, “U to, ahi wawuyi wa a si tre niwu.” ");
INSERT INTO jid_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Igu'a tre, Bachi, mi kpayenme, wa no ninkon ma (kwu gbarju niwu). ");
INSERT INTO jid_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu tre, “A tron miye, miye ni gbungbulu yi ni ndu biwa ba na to na ndu ba to, U bi wa ba ta to ndu ba yarshi (tifyen).” ");
INSERT INTO jid_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bari ni Farisawa ba, wa ba heni wu'a ba wo wayi, na miye, “Ki me ki yarshi?” ");
INSERT INTO jid_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu hla bawu, bina yarshi, bina to na, zizan bi tre, kito, naki latre bi riheri. ");
INSERT INTO jid_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Njanji, njanji, mi hla yiwu, indji wa ana ri zu ni gontra hi ni gran tan ba ba na, na hon hu igon ri, indji mba a ndji u yibi na ni kri ni kon. ");
INSERT INTO jid_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Indji wa ari zu ko gon tra ahi indji u krju tanba. ");
INSERT INTO jid_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Indji u gben a bu'u gon tra niwu. Itanba ba ba wo tre ma, ani yo tanba ba ni nde mba, na nji ba hi kora. ");
INSERT INTO jid_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ani ta nji ba hi kora, ani guci u tanba ba ba hu nitu wa ba to tre ma. ");
INSERT INTO jid_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bana hu indji u tsri na, se ba kulu ni wa bana to itre ma na.” ");
INSERT INTO jid_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu tre bawu ni misali yi, u ba na to tu tre wa asi hla ni bawu na. ");
INSERT INTO jid_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu hla bawu ngari ndi, njanji, njanji, mi hla yiwu, ahi meyi mi inkon tra tanba ba. ");
INSERT INTO jid_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Biwa ba ye guci ni mu'a wawu mba wu ba bi yibi ni bi kri ni nokn, u itanba ba bana wo bana. ");
INSERT INTO jid_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ime yi mi gon tra, indji wa ari zu niki ni nkon mu, ani nawo, ani hi na rju na fe bubu u ri. ");
INSERT INTO jid_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Indji u yibi na ya yena nitu wa a yibi, a wu na su indji tu. Mi ye ni ndu ba fe re (iviri) na fe re (iviri) u babran. ");
INSERT INTO jid_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ime yi mi indji u krju ndindima. Indji u krju ndindi ma ani ka re (iviri) ma no nitu tanba ma. ");
INSERT INTO jid_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Indji wa ahi vren u ton ndu'a, ana indji u krju na, wa na indji u tanba ba na, ani ta to ya niye, ani kaba chuwo na tsutsu, u iya ka vu ba na vraba ti nkankan. ");
INSERT INTO jid_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A tsutsu nitu wa ahi indji u tie ndu u kenle mba wana ri niwu ni sonron na. ");
INSERT INTO jid_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","A me hi me yi mi indji u krju ndindi ma, mi toh bimu, bimu ba toh me. ");
INSERT INTO jid_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Iti'a ato Me, Ime mi toh Iti'a, mi ka re (iviri) mu no nitu tanba ba. ");
INSERT INTO jid_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Me he ni tanba bari wa bana u gran yi na. Dole dun mi nji ba ye ngame, u ba wo lan mu u ntma ba ba he ni bubu rhirhi nda he ni ndji u krju ba rhirhi. ");
INSERT INTO jid_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ni tu kima, Iti'a ni son me, mi no re mu (iviri) ni ndu mi la ffe ngari. ");
INSERT INTO jid_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Idiori na ya ban ni me na, ime mi no ni tumu, mi he ni gbengbenle u no, ni he ni gbengbenle u bawu ngari. Mi kpa umurni rji ni Timu.” ");
INSERT INTO jid_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ga kpa la lunde ni mi tsutsu Yahudawa nitu lan biyi. ");
INSERT INTO jid_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gbugbu'u ni mi mba ba tre, aheni brji, ahi indji u siran ngari ani tunge bisi wowu?” ");
INSERT INTO jid_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bari ba tre, biyi bana lan tre biwa ba he ni brji na. Ka indji u brji ni ya bu'u shishi indji u fyen? ");
INSERT INTO jid_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","U ton igan Tsakakewa (Tsiratsira) ni Urushelima a ye tsira'a. ");
INSERT INTO jid_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ana iton u ma lu, u Yesu zren si hi ni mi hekeli Suleimanu, wa ba me mu me ziye'a. ");
INSERT INTO jid_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","U yahudawa ba lu hrawu kagon na miyen, “Ani tan mba u chuta chuwo ni mi mire. ");
INSERT INTO jid_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu hla bawu, “Mi hla ni yiwu, u bina kpa yenmen na, indu wa mi si tie ni mi nde Bachi, ba tsoro igban mu. ");
INSERT INTO jid_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Naki bina kpayenme na nitu wa bina tamba mu na. ");
INSERT INTO jid_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Itanba mu ba wo me, mi to ba, ba hu me. ");
INSERT INTO jid_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi noba re (iviri) u tuntur, ba na to h ikwu na, idiori na ya kpa niwu mu na. ");
INSERT INTO jid_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iti mu, iwa Ane ba, a zan ndji nikon wawu, idiori na ya u kpa ni wo Ti'a na. ");
INSERT INTO jid_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ime ni Iti'a ki riri me.” ");
INSERT INTO jid_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","U Yahudawa ba la vu tita ndi ba ta. ");
INSERT INTO jid_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu sa bawu, “Mi tsoro yi indu bi babran ma rji ni Ti'a. Nitu iri ni mi indu'a bi ki tame?” ");
INSERT INTO jid_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","U Yahudawa ba sa niwu, “Ana nitu indu iri u ndindi ma mba ki si ta na. Ani tu kpande ti meme nitu. u indji ni kaban ni ban tume na Rji. ");
INSERT INTO jid_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu sa ni bawu, bana nha nha zi ni du itron bina, mitre, “Bi rji bi ka viri?” ");
INSERT INTO jid_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ani ta yo ba Irji biwa itre Rji ye ni ba (bana ya karya na si na,) ");
INSERT INTO jid_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bi si hla ni indji wa Iti a zi na ton ndu ni gbungbulu'a, u se latre, (kpa nde tie meme) nitu wa mi tre, Ime mi Vren Rji'a? ");
INSERT INTO jid_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mi ta na si tie indu u Timu na, bi ka na kpayenme ni me na. ");
INSERT INTO jid_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ide mi siti bika, u bi na kpa yenme me na, kpa yenme ni ndu ni to ni ndi Iti he ni me i mi he ni Ti. ");
INSERT INTO jid_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","U ba tsi kpukpa ndi ba la vu ngari, iwa na bawo rju kado ni wo mba. ");
INSERT INTO jid_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wa hi kpama ni koshishi ni inne Urdun hi ni bubu wa Yahaya ta ti batisma ni sen'a. na ka son ni ki. ");
INSERT INTO jid_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Indji gbugbuwu ba ye niwu, “Njanji Yahaya na ti ba gban kperina (alamu) wawu ikpe wa Yahaya ta tre nitu gu yi'a ba njanji. ");
INSERT INTO jid_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Indji gbugbuwu ba kpanynme niwu ni ki. ");
INSERT INTO jid_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","U igun wa ba yo ni Lazaru, a lo'a hi indji u Baitanya, ni gbu ba Mariyamu ni vayi ma Marta. ");
INSERT INTO jid_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyamu wa gban yen ni Bachi na se za ma ni futu ma, wa vayi Lazaru si lo'a. ");
INSERT INTO jid_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Imri vayi maba ton ba adu hi ni Yesu, andi, “Bachi, ya, indji wa'u son si to.” ");
INSERT INTO jid_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wawo, na tre, “Lilo mba ni nji hi kwu na nitu gbere san rji ni ndu vren Rji ndu fe gbere san ni tu ma.” ");
INSERT INTO jid_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ni son Marta, ni vayi ma vren wa ni Lazaru. ");
INSERT INTO jid_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wa a wo ndi Lazaru silo'a, na kri ti ivi hari ni bubu wa ahe. ");
INSERT INTO jid_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ni kogon ki, wa hla, ni almajere ma, “Biri ki hi ni Yahudiya ngari.” ");
INSERT INTO jid_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","U almajere ba hla niwu, “Mala, Yahudawa bari si wa ndi ba ta ni tita, u la ni son k'ma hi ni ki? ");
INSERT INTO jid_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu tre niba, andi inton u kpan rji ana awa wulon don ha na? Indji wa a zren ni ri, ana kubu zana, ni wa asi to kpan u gbungbulu yi. ");
INSERT INTO jid_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Indji wa ni zren ni chu, ani kubu za nitu wa ikpan na he na. ");
INSERT INTO jid_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A tre kpe biyi ni kogon biyi, a hla ni bawu, “Ikpan mbu Lazaru a si kru nna, mi si hi bubu shime lunde ni na. ");
INSERT INTO jid_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","U almajere ba hla niwu, “Bachi, ani ta si kruna, e ani shime ni nna'a.” ");
INSERT INTO jid_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu si tre ni tu kwu Lazaru u ba si nda asi tre nitu kruna u kusimu. ");
INSERT INTO jid_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","U Yesu a mamla hla ni bawu ndi, “Lazaru kwu. ");
INSERT INTO jid_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mi ngyiri ni tubi, niwa mina he na ni ndu kpanyeme. Biri ki hi niwu.” ");
INSERT INTO jid_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma, wa ba yo ndi vren u hlen hen, a hla ni mburualmajere ba ndu baba hi ngame na hi kwu ni Yesu.” ");
INSERT INTO jid_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wa Yesu aye, u wa ye to Lazaru ati za'a ni be ye. ");
INSERT INTO jid_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Baitanya ahe whewhre ni Urushalima, avi zren fifie me ni tsutsu mba. ");
INSERT INTO jid_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahudawa gbugbuwu ba ye ni ye chiMaryamu mba Marta ni kwu Lazaru. ");
INSERT INTO jid_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wa Marta wo andi Yesu ni ye, na luhi ni ndu wawu hi same wu'a u Maryamu a son zu ni miko. ");
INSERT INTO jid_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta hla ni Yesu, “Bachi, una he nita ni lalon mu, vayi mu ana kwu na.” ");
INSERT INTO jid_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Zizan me mi to ikpe wa u bre Rji ani no'u.” ");
INSERT INTO jid_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu hla niwu, vayi me ni ta shime. ");
INSERT INTO jid_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","U Marta hla niwu, “Mi to ani ta shime chachu klekle.” ");
INSERT INTO jid_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu hla niwu, “Ime yi mi ta shime u klekle, Ime yi mi re (iviri), indji wa a kpanyeme ni me, ani ta kwu, ani ta shime; ");
INSERT INTO jid_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ni indji wa ahe ni re (iviri), na kpanyeme ni me, ana kwu na; u kpanyeme ni wa?” ");
INSERT INTO jid_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","U wa hla niwu, “E, Bachi, mi kpanyeme andi iwuyi u Almasihu, Vren Rji, iwa ani ye ni gbungbulu'a. ");
INSERT INTO jid_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ni wa a hla naki, na kma hi ni vayi ma Maryamu, na yo ti gigran, na hla, “Mala ye ri ye, na ni yo.” ");
INSERT INTO jid_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wa a wo naki, wa lunde gbagbla hi niwu. ");
INSERT INTO jid_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu na ri ni vi gbu'a rina, ahe ni bubu wa Iwa ka same ni wu'a. ");
INSERT INTO jid_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ni Yahudawa wa ba he baba Maryamu biwa ba ye chi ba ni kwu'a, bato lu rju ni miko gbagbla me, u ba lu hu, ni ban andi a rju ni bubu yi ni nyu be. ");
INSERT INTO jid_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wa a ka ri ni bubu wa Yesu he'a na ka Joku niwu ni za ma, na hla, “Bachi, una he nita, vayimuy ana kwu na.” ");
INSERT INTO jid_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wa Yesu ato'u si yi, ni Yahudawa biwa ba hu'a, i wa kpere ni Ruhu na lo ni suron; ");
INSERT INTO jid_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","iwa tre, bika yo ni ntsen? “U ba hla niwu, “Bachi, ye to.” ");
INSERT INTO jid_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu yi. ");
INSERT INTO jid_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","U Yahudawa ba ba hla ndi, “toh yanda ani son Lazaru!” ");
INSERT INTO jid_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ba mba ba tre, “Wawu igu yi wa a ya no indji u fyen to bubu'a, ani na ya u gu hi bubu kwu na? ");
INSERT INTO jid_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu he ni mi si lo suron ni tu ma, na hi ni be'a. Ibe'a a he ni ko fron tita u ba ka he ni tita. ");
INSERT INTO jid_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","U Yesu tre, “Ban tita yi rju.” Marta vayi Lazaru wa a kwu a, a hla ni Yesu, “Bachi, zizan ikon kmo a gla ye niwa a ti ivi nzah ni kwu. ");
INSERT INTO jid_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu hla niwu, mina hla niwu ikpe wa u kpanyeme u to nikon u Rji'a na? ");
INSERT INTO jid_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","U ba ban tita rju, Yesu zun shishi na tre, “Iti, mi ngyiri niwu niwa u wo me.” ");
INSERT INTO jid_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi to wa u wo me ni ton wawu, nitu son yi wa gyen klan kagon mu yi mi tre wa, ni ndu ba kpanyeme andi ahi wuyi u ton me.” ");
INSERT INTO jid_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ni wa a tre kle, na tre gbame, Lazaru rju” ");
INSERT INTO jid_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","U ndji wa a kwu'a a lu rju, u za ma ni wo ma ba he ni lilo'o ni pri, shishima he ni kika ni gbanjan nklon. Yesu hla bawu, “Bika siwu, ndu hi.” ");
INSERT INTO jid_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gbugbuwu ni mi Yahudawa wa ba ye ni Maryamu ba to ikpe wa Yesu ti'a u ba kpanyeme niwu. ");
INSERT INTO jid_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","U bari ba kma hi naka hla ni Farisawa ikpe wa Yesu a ti'a. ");
INSERT INTO jid_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","U Firistoci bi nigon,'a ni Farisawa ba yo indji bi kpanchi'a shuti buburi, u ba tre, ageri kita?” igu yi ani ti gban bi babran. ");
INSERT INTO jid_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ki ta kadon naki, indji ba kpa'u nyeme, Romawa ba ye kpa bubu mbu, ni ndji mbu. ");
INSERT INTO jid_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Naki, iri ni mi mba kayatas kena wa ndi ahi kikle Firist ni se kima, a hla bawu, “Bi na to kpe na. ");
INSERT INTO jid_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bi na mla ya a bi zan ni ndu indji riri kwu ni tu indji, ni wa indji wawu ba sutuna.” ");
INSERT INTO jid_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A hla ki, ana nitu ma kankrji ma na, ani tu iwa a hi kikle Firist, a to tsu ndi Yesu ni yi ni kwu ni tu ndji; ");
INSERT INTO jid_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ana nitu indji kankrji na, anitu ndu ba shi imri Irji ti ni buburi biwa ba lu vra kagon. ");
INSERT INTO jid_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Rji ni chachu ki na lu ni tsikpa bubu wa ndu ba wu Yesu. ");
INSERT INTO jid_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rji ni ki Yesu na la ni zren ni rira ni mi Yahudawa na. Wa ala kma hi ni kalan ri whiwhre ni miji ni gburi wa ba yo Ifraimu. Ni mu a son ni almajere ma. ");
INSERT INTO jid_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Igan u ru gran (indji ketarewa) u Yahudawa a tewhre, gbugbu ba hi Urushalima rji ni klan meme'a hi ri ndu ivi idiri ni ndu ba kati tsatsra. ");
INSERT INTO jid_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","U lu ri wa Yesu, na ni tre ni kpa mba niwa ba kri ni ni hekeli andi, “Angye bi ki rhimre? Ana ye ni idin na? ");
INSERT INTO jid_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kikle Firist ni Farisawa ba yo du andi ko ni zen wa ba to Yesu ba ka ye hla ni ndu ba vu. ");
INSERT INTO jid_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ivi tanne hi ni vi u gan rugran'a (Idin ketere) Yesu ye ni Baitaya ni bubu wa Lazarus ahe'a, uwa Yesu a tawu shime rju ni be. ");
INSERT INTO jid_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","U ba tie birli wu ni ki u Marta ahe ni ndasi nno ba birli, u Lazarus ahe ni ba nda kakru ni tebur u rli ni Yesu. ");
INSERT INTO jid_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","U Maryamu ka ban turare nard, nda nyuu za Yesu niwu nda se za Yesu ni nfutu ma. U turare ka vra whi shu ni koh'a wawu. ");
INSERT INTO jid_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yahuda Iskariyoti, iri nimi almajere ma, wa ani kawu le, a tre, ");
INSERT INTO jid_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ahi ngyeri mba sa ba na le ni tulare dinari dari tra na ka ga bi na?” ");
INSERT INTO jid_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A tre naki ana ndi ahe niwu mi sron ma na, a wa'a ndahi ndji u yibi. A wawuyi ni zi imbu nklen'a, nda ni son ybi ni mi. ");
INSERT INTO jid_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu tre, bika chowo ni ndu ka kpye wa ahe wu'a zi ni fi wa baka rju me'a. ");
INSERT INTO jid_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Biya ba he ni yi ko ni tanyi u me mi na he niyi chachuwu na. ");
INSERT INTO jid_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","U gbugbu Yahudawa ba wo andi Yesu a he ni kii u ba ye, ana nitu Yesu ni nkrji megyen na, baye son to Lazarus ngame wa Yesu tawu shime ni khwu'a. ");
INSERT INTO jid_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","U Firistoci bi ni kon, baka ka'nyu kabi nda wa nkon u wu'u Lazarus ngame. ");
INSERT INTO jid_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nitu ma yi wa Yahudawa gbugbuwu ba ka kpa nyeme ni Yesu. ");
INSERT INTO jid_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ni vi rima indji gbugbuwu ba ye ni gan. Ni wa ba wo ndi Yesu ni ye ni Urushalima, ");
INSERT INTO jid_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","u ba vu ihran dabino nda rju ni gbu nda hi kpawu nda ni yo gbangban me nda ni tre, “Hosanna! Lulu ahi wu Indji wa ani ye ni mi nde Bachi, Ichu Israila. ");
INSERT INTO jid_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu a ka fe ivren jaki (Aholaki), nda hon nitu ma, towa ba ngha'a, ");
INSERT INTO jid_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Na ti sissri na, Ivrenwa Sihiyona, yayi, ngye Ichu ni ye, a son nitu vren jaki.” ");
INSERT INTO jid_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Almajere ma bana to tu mana ni mumla, ni kogon wa ba gbyre Yesu san, baka tika, andi ba nha nda ni he to kima, u ba ti ba ni wu na kima. ");
INSERT INTO jid_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ij'bu ndji ba a hla ndi bana he niwu niwa a yo Lazarus rju ni mi be nda tawu shime ni khwu na. ");
INSERT INTO jid_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nitu kima, gbugbu indji ba ye ni ndu ba same niwu nitu wa ati gban (alama) yi. ");
INSERT INTO jid_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ni naki, se Farisawa bari bubu tre ni kpa mba andi, “Yayi, bi heni kpe u tina bi to, gbugbulu,'a ba hu wawu ye. ");
INSERT INTO jid_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Indji bi Helinawa bari ni mi bi wa ba hi ni sujada u idin. ");
INSERT INTO jid_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba ki ba hi ni Filibu, igu u betsa ida wa ahe ni Galili, u ba tre niwu, “Mala, ki sun to Yesu. ");
INSERT INTO jid_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibu ahi na ka hla ni Andarawus, u Andarawus ba hi mba Filibu, u ba hla ni Yesu. ");
INSERT INTO jid_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu hla bawu, “Inton tsra ye wa ba shu ngbarju ni Vren Ndji. ");
INSERT INTO jid_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Njanji, njanji, mi si hla yiwu, iwolo alkama ni ta na joku ni meme na kwu na, ani he ni ngrjima, u ani ta kwu, ani ti wolo gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Indji wa ani son ivri ma, ani wa wu hama, u indji wa ana son ivri ma na ni ngbungblu yi ani kiyaye wu nitu ivri ma u tuntru. ");
INSERT INTO jid_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Indrjori nita ni shu ngbarju nimu, wa ka hume, ko ni ntsen wa mi he'a, ni mu igran ni sun. Indji wa a shu ngbarju nimu, Iti ni no ninkon. ");
INSERT INTO jid_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zizan isron mu he ni mi mmren, u mi tre ngye? Iti u kpa me chuwo ni ton yi? Ani to kima yi me ye ni ton yi. ");
INSERT INTO jid_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Iti, shu ngburju ni tume.” U lantre ri ni tre, “Me shu ngbarju niwu, mila shu ngbarju niwu ngari. ");
INSERT INTO jid_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","U indji biwa ba ki na kima bawo lantre, na tre ahi zan bari ba ri ba tre ahi “Maleka mba tre niwu.” ");
INSERT INTO jid_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu tre, “Andi lan tre yi na ye nitu mu na, a nitu mbi.” ");
INSERT INTO jid_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Zizan ba tron ni gbungblu'a: zizan ba zu Indji wa ani nji gbunglu'a. ");
INSERT INTO jid_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","U me, ba ta ba me lu ni gbunbglu'a, Mi gbron indji wawu ye ni kpamu.” ");
INSERT INTO jid_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A hla wayi ni tu iri kwu wa ani kwu'a. ");
INSERT INTO jid_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ijubu indji ba lu tre, “Ki wo ni mi tronandi Almasihu ni son hi ni tuntru. A nihe u tre, ba zun Vren Indji? Ahi nha mba hi Vren Ndji'a?” ");
INSERT INTO jid_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu hla bawu, “Zizan ni vi ton tsa me bi son ni ikpan. Bika zren ni kpan tu ka ari he ni yi ri, na ndu bu'u dun mren yi na. Indji wa ani zren ni mi bu'u'a ana to wurji u hi na. ");
INSERT INTO jid_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bi kpa nyeme ni kpan tu wa ri he ni yi ri ni ndu kati imri ikpan.” Yesu hla tre biyi ri na ri tuma ni bawu. ");
INSERT INTO jid_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko naki me Yesu ti gban bi babran ni shishi mba, ni naki me bana kpa nyeme niwu na. ");
INSERT INTO jid_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nitu itre Anabi Ishaya a a shu, wa a hla, “Bachi, ahi nha a kpa nyeme ni tre mbu? Ani nha iwo Bachi a hla tu ma?” ");
INSERT INTO jid_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nitu kima ba na kpa nyeme na, ni wa Ishaya ala tre andi, ");
INSERT INTO jid_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A ka ba tibi fyen, na lo sron gbangban me, ni ndu bana to ni shishi mba na. Naki nato toma ni mi sron mba, na k'ma ye ni me ni ndu mi den ba. ");
INSERT INTO jid_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya hla kpi biyi ni wa a to ko shishi u shu ngbarju ni Yesu. ");
INSERT INTO jid_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ni naki me, gbugbuwu bakpa nyeme ni Yesu ni mi bi ninkon'a. U nitu Farisawa, bana ya hla wu rju ni rira na, ni ndu ba na zu ba rju ni mi Majamiya na. ");
INSERT INTO jid_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba son gbre san u indji zan gbre san wa ani rji ni Rji. ");
INSERT INTO jid_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu tre gban gban me, na hla, indji wa a kpa nyeme ni me, ana me yi a kpa nyeme ni me kankle mu na, a kpa nyeme ni indji wa a ton me'a. ");
INSERT INTO jid_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ngari indji wa asi to me, asi to Indji wa a ton me. ");
INSERT INTO jid_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ime mi ye nitu ikpan ni gbungblu'a, ni indji wa a kpa nyeme ni me a na zren ni mi bu'u na. ");
INSERT INTO jid_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Indji wa awo tre mu nda na kpa nyeme na, mina hukunta ni wu na. Mina ye nitu hukunta indji na; ni ndu me kpa gbungblu'a chuwo. ");
INSERT INTO jid_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Indji wa a kama ni me, na kama kpa tre mu, indji ri he wa ni hukunta niwu ilan wa mi tre ni hukunta niwu ni chachu kekle. ");
INSERT INTO jid_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mi na tutu mu na, a Ti'a wa a ton Me, wa a yo Me ni ndu mi hla ni tre. ");
INSERT INTO jid_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mi to yo me u ma ahi re (iviri) u son tuntur, ni ndu ikpi wa mi tre, na wa Iti'a a ton Me naki mi tre.” ");
INSERT INTO jid_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Igan idin tsatsra rigyen u ye, u Yesu to andi inton tsra wa a lu ni gbungblu hi ni Ti'a. Niwa ani son bi ma wa ba he ni gbungblu, a son ba ye ni kekle. ");
INSERT INTO jid_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ibrji yo ni sron Yahuda Iskariyoti ivren Saminu, aka Yesu le. ");
INSERT INTO jid_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ato ndi Iti a ka kongeri no ni woma, na rji ni Rji, ani la kma hi ni Rji. ");
INSERT INTO jid_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A lunde ni bubu ri biri, na ju kpima, na ban inklon u se ma kpa na ka kpa ma niwu. ");
INSERT INTO jid_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Wa sur ima ni konko na si ngla za ni almajere ma ba na se za ba wu ni inklon u se kpa wa a ka kpama niwu'a. ");
INSERT INTO jid_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na ye ni Siman Bitrus, u Bitrus tre niwu, “Bachi, u ngla za mu me?” ");
INSERT INTO jid_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu sa niwu na tre, “Ikpe wa mi si ti'a una to na zizan? U to ni ton u ye (ajima). ");
INSERT INTO jid_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitrus hla niwu, una ti bre ngla za mu.” Yesu hla niwu, “Mita ngla niwu na, una he ni san me ni me na.” ");
INSERT INTO jid_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Siman Bitrus hla niwu, “Bachi, na ngla zamu migyen na, ngla womu ni tu mu.” ");
INSERT INTO jid_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu hla niwu, “Indji wa a sukpa'a ana wa sukpa na, se ka ngla za, wa ahi tsatsra ndji wawu bi tsatsra, ama ani wawu mbi na. ");
INSERT INTO jid_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesu a to indji wa ani kawu le, kima sa wa tre naki, ana wawu mbi bi tsatsra na). ");
INSERT INTO jid_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ni kokon wa Yesu ngla za bawu, a ban konlon ma na kuson ngari, na hlabawu, “Bito kpe wa mi ti ni yiwu'a? ");
INSERT INTO jid_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bi yo me ni 'Mala' ni 'Bachi,' u bi yo me tsra, a naki mi he. ");
INSERT INTO jid_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","U to Me wa mi Bachi ni Mala, u mi ngla za mbi, biyi ngame bika ngla za ni kpambi. ");
INSERT INTO jid_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","U mi tsro yi misali, ni ndu ti na wa mi tie ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gbigbi njanji mi si hla ni yiwu, igran na zan tiko ma ni ninkon na, ivren u ton ndu ana zan indji wa ton'u ndu ninkon na. ");
INSERT INTO jid_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bita to kpi biyi, bi-bi lulu ni nde bi ti ba. ");
INSERT INTO jid_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mi na si tre yi wawu na; Mi to biwa mi chu ba'a - nitu ndi nassi tsra indji wa a tan bredi a tayar nimu. ");
INSERT INTO jid_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi si hla wa yi ni yiwu zizan ri ni ndu ka ti naki ni ndu yi ka kpa-nyeme ni me ni nton wa ani ti naki'a. ");
INSERT INTO jid_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Njanji, njanji, mi si hla ni yiwu, indji wa a kpa ndi wa mi ton'wu, ahi Me a kpa, indji wa a kpa Me, a kpa Indji wa a ton Me. ");
INSERT INTO jid_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ni kogon wa Yesu tre naki, na lo sron ni (Ruhu), na ti gban (shada) andi, gbigbi njanji, mi si hla ni yieu ndi iri ni mibi ani le ni me.” ");
INSERT INTO jid_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Almajire ba ba kma ya kpa mba, na ni tamre, ka ahi nha ni mi mba a si tre ni tu ma. ");
INSERT INTO jid_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iri nimi almajire ma, wa Yesu ni son, ahe ni tebru, na kunyre ni san Yesu. ");
INSERT INTO jid_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siman Bitrus hla ni almajire bika minye, “Ndu hla tawu a hi nha a si tre ni tu ma.” ");
INSERT INTO jid_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wa hla bru kunyre ni san Yesu, na tre niwu, Bachi, ahi nha? ");
INSERT INTO jid_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","U Yesu hla niwu, a wawu yi wa mi ka cichon bredi sun ni kano. Naki ri na ka bredi sun, na ka no Yahuda ivren Siman Iskariyoti. ");
INSERT INTO jid_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ni kogon bredi'a u ibrji a ri ni wu, u Yesu hla niwu, “Ikpe wa u son ti'a, uka ti gbagbla.” ");
INSERT INTO jid_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Indrjori na la he ni tebru na, wa ani to ikpe wa yo'a hla niwu naki'a. ");
INSERT INTO jid_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bari mba ba ya ndi, a Yahuda yi ni nji imbu nklen Yesu hla niwa, “Le ikpe wa ki son ti ndu niwu ni idin,” ko ka no ikpe ni bi wa ba kunyre'a. ");
INSERT INTO jid_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ni kogon wa Yahuda a kpa bredi'a, wa rju gbagbla gbagbla me ni chu me. ");
INSERT INTO jid_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ni kogon wa Yahuda hi'a, Yesu tre, zizan ba no Vren Indji ni kon, ngari ba no Irji ninkon ni mi ma. ");
INSERT INTO jid_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Irji ni no ninkon ni mi ma, ani no ninkon zizan zizan. ");
INSERT INTO jid_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Imri bi tsitsa mi he ni yi ni vi ton tsa me, biwa me na wa mi hla Yahudawa, bubu wa me mi hi bi na ya hi na. Zizan mi hla wa yi ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi si no yi indu ri sama, son kpa mbi, na wa mi son yi, na bi ka son kpambi. ");
INSERT INTO jid_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na ko nha ni to yi ndi bi almajire mu, inde bi son kpambi.” ");
INSERT INTO jid_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siman Bitrus tre niwu, Bachi, u hi ni ntsen?” Yesu hla ni wu, bubu wa mi si hi'a, una ya hina me zizan hi na, u wuka ye hu me ni kogon.” ");
INSERT INTO jid_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus hla niwu, “Bachi, a ngyeri mba sa mi na hu zizan na? Mi no re (ivri) mu ni tu me.” ");
INSERT INTO jid_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu hla niwu, u ka re (ivri) me no ni tu mu? Gbigbi njanji, mi si hla niwu, u kame ni me ni kpatron ingyu tra ri ndu mble ndu kpan ");
INSERT INTO jid_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na ndu sron mbi tie meme na, bi kpa nyeme ni Rji, kpa nyeme ngame ni Me. ");
INSERT INTO jid_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ni ko ti mu ahe niko gbugbuwu ani na nakina, mi hla ni yiwu mi hi mla bubu'a tie ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mi ta hi ni mla bubu'a tie ni yiowu, mi kma ye ni ye ngari ni ye vu yi hi ni kpa mu, ni ndu iwurji wa mi he'a bi ka he niki me. ");
INSERT INTO jid_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bi to gon uhi bubu wa me he'a.” ");
INSERT INTO jid_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma hla ni Yesu, Bachi, kina to bubu wa u si hi'a na, kiti niheri ni to nkon'a? ");
INSERT INTO jid_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu hla niwu, Ime yi mi nkon ni njanji ni re (ivri), Indrjori na ya hi ni Timu'a na se ka hu ni me. ");
INSERT INTO jid_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","U na to me u na to Timu me, rjizizan hi u to ni shishi me ni to.” ");
INSERT INTO jid_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibu tre ni Yesu ndi, “Bachi tsro ta Iti'a, ni ndu tsra tawu naki.” ");
INSERT INTO jid_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu hla niwu, “Mi he ni yi rji lalon mu u bi na to me na Filibu? Indji wa a to me'a a to Iti'a. U tie ni he ri, ni hla ndi, mi tsro yi Iti'a? ");
INSERT INTO jid_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","U na kpa nyeme na ndi mi he ni Ti'a u Iti'a he ni me na? Ilan tre bi wa mi si tre ni yi'a mi na si tre ni gbengblen mu na, ahi Iti mu wa ahe ni mi mu'a si tie ndu yi. ");
INSERT INTO jid_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kpa nyenme ndi mi he ni Ti'a, u Iti'a ahe ni me, ko u ka kpanyeme ni indu bimba me. ");
INSERT INTO jid_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Njanji, njanji, Mi hla ni yiwu, indji wa a kpanyeme ni me ani tie ndu wa Mi tie'a na tie ndu bi rigrama zan bi yi niwa Mi si hi ni Ti Mu. ");
INSERT INTO jid_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ko ngyeri wa minye ni mi nde mu, mi ti niwu ni ndu Ti'a ndu kpa ninkon ni Vren'a. ");
INSERT INTO jid_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","U wu ta minye me ko san ngyeri ni mi nde Mu, Mi tie wu. ");
INSERT INTO jid_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","U wu ta ni son me, wu hu indu mu, ");
INSERT INTO jid_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","u Mi bre ni Ti'a, mi la no yi si sron ri wa ani son niyi hi tuntru - ");
INSERT INTO jid_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","u Ibrji Tsatsra (Ruhu) u njanji gbungblu'a ana ya kpa na nitu wa a to na, iwu u to, ani son niwu ani he niwu. ");
INSERT INTO jid_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi na ka yi don ni kankrji mbi na, Mi kma ye ni yi. ");
INSERT INTO jid_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A don tsa me yi, ni ndu gbungblu yi na la tie bre to mena, bi yi bi la to me don me mi he, biyi me bi son. ");
INSERT INTO jid_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chachu ki bi to andi Mi he ni Timu, andi bi he ni me, u me mi he ni yi. ");
INSERT INTO jid_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Indji wa a wo du mu, na hu ba ahi indji wa ani son me, u indji wa ani son me, Iti mu ni son'u ngame, u Me Mi son'u ni tsro tu mu niwu.” ");
INSERT INTO jid_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuda (ana Iskariyoti na) a tre Yesu, “Bachi, ahi ngyeri sa u tsro ta tu me, ana ni gbungblu'a na?” ");
INSERT INTO jid_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu sa na hla niwu, indji wa ani son me'a ani hu lantre mu. Iti mu ni son u ki ye niwu ni son baba me. ");
INSERT INTO jid_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Indji wa ana son me na, ana hu tre mu na, itre wa bi wo bana rji-ni me na, ba rji ni Ti wa a ton me'a. ");
INSERT INTO jid_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mi hla ikpi biyi ni yiwu ni wa Mi he ni gbungblu'a, niwa Mi he niyi. ");
INSERT INTO jid_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Se, u si sron ibrji tsatsra (Ruhu) wa Itimu ni ton ye ni mi nde Mu ani tsro yi ko ngyeri na tie ka ko ngyeri ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi bri yi ni si sron, ni no yi si sron, Mi na no nawa gbungblu'a ni no'a na, na kpa sron u bi tie meme na, nda na tie sissri na. ");
INSERT INTO jid_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bi wo Mi hla ni yiwu, Mi hi kpa Mu, ndi Mi la kma ye niyiwu. Inde bi son Me, bi ka ngyiri don Mi hi ni Ti'a, Iti'a a zan na wa Mi he'a. ");
INSERT INTO jid_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Zizan Mi hla ni yiwu ri ni ndu ka ye he (ti) nda ana ye he (ti) u bi ka kpa nyeme. ");
INSERT INTO jid_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi na la tre babran ni yi na, Ichu wa ani nji gbungblu'a ani ye ana he ni gbengblen ni tu mu na. ");
INSERT INTO jid_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ni ndu gbungblu'a ndu ba to andi Mi son Ti'a, Mi ti na wa Iti'a a yo Me, ki lunde bri bubu yi. ");
INSERT INTO jid_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ime yi Mi nchi kunkro u njanji, u Ti mu ahi Indji u rju'a. ");
INSERT INTO jid_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ani gyen ko ilan rime rju ni kpa Mu wa ana klo'a na, iwaani klo'a ani mla'u tie ni ndu la klo babran me. ");
INSERT INTO jid_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bi kpa tsatsra me ye, nitu wa Mi hla tre Mu ni yiwu ye. ");
INSERT INTO jid_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bi ka son nimi Mu, ima Mi ka son ni mi mbi ngame, na wa ilan kunkro na ya klo kima na se ahe ni nchi konkro'a, na ni me bi na ya na se bi son ni mi Mu. ");
INSERT INTO jid_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi nchi kunkron u bi lan ma, indji wa a son ni Me'a Mi he niwu, ani klo gbugbuwu, inda u ta na he ni Me na, bina ya tie kperi na. ");
INSERT INTO jid_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Indji wa ana son ni Me na, ba kawu taga na ilan kunkro wa ka klu baka kpulu ba sru na yo lu, baka gon tie nton. ");
INSERT INTO jid_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","U ta son ni Me, u lantre Mu son niwu, minye me ko ngyeri wa u son'a u Mi tie ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni naki, inde Timu ni fe gbre san; ni ndu yi klo babran, ni bi almajere Mu. ");
INSERT INTO jid_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na wa Iti Mu ni son Me, anaki Ime me mi son yi. Bika son ni mi son Mu. ");
INSERT INTO jid_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","U ta hu du mu, u sun ni mi son Mu nawa Mi hu du Iti Mu ni sun ni mi son ma. ");
INSERT INTO jid_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi tre kpe biyi ni yiwu ni ndu si sron Mu nda he ni yi, na ndu si sron a shu. ");
INSERT INTO jid_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iwa yi a hi ndu Mu, ni ndu yi son kpa mbi na wa Mi son yi'a. ");
INSERT INTO jid_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Indrjori na he ni son ri zan wayi na - wa iri ni re (ivri) ma no ni tu kpukpan ma. ");
INSERT INTO jid_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bi kpukpan Mu inde bi tie kpe wa Mi hla ni yiwu dun yi tiewu. ");
INSERT INTO jid_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi na la yo yi tie igran ngana; igran na to kpe wa Iti koh ma ni tie'a na. Mi yo yi kpukpan Mu, ni kpe wa Mi wo ni Timu wawu, wu Mi dun yi to. ");
INSERT INTO jid_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ana biyi bi chu Me na, a Me mi chu yi ni ton yi ni dun yi hi ni klo ni ndu klo mbi ndu ba toh naki iwa yi ni he naki, ni tu ko ngyeri bi minye Ti Mu ni mi nde Mu, ani no yi. ");
INSERT INTO jid_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mi yo yi ni ndu yi kpa nyeme ni kpa mbi. ");
INSERT INTO jid_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","I gbungblu'a nita kama ni yi, bi ka to ndi a kama ni Me ri na kama ni yi. ");
INSERT INTO jid_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bini na u gbungblu'a, gbungblu'a ba ni son yi nawu mba. Ni wa bina u gbungblu; a na, Mi la juyi ni mi gbungblu'a, nitu ki gbungblu'a ni kama niyi. ");
INSERT INTO jid_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bi ka rimren ikpe wa Mi na hla ni yiwu'a, “Igran na zan tiko ma ni ninkon na.” Inde ba ti me di, biyi me ba tiyi di'a, inde ba hu tre mu, ba hu tre mbi ngame. ");
INSERT INTO jid_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba ti bibi kpe mba ni yiwu wawu ni tu inde Mu, niwa ba na toh indji wa a ton me na. ");
INSERT INTO jid_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mi na ye tre ni ba na, ba na he ni lahtre na, u zizan, ba na he ni kpe u gbisron tu lahtre mba na. ");
INSERT INTO jid_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Indji wa a kama ni Me, a kama ni Ti Mu. ");
INSERT INTO jid_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi na ye ti ndu kpe wa ko indrjori na ti bre ti na ni mi mba na, bana heni lahtre na, u zizan ba to ye, ba ka mba ni Me ni Ti Mu wawu. ");
INSERT INTO jid_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba ti ngari ni ndu itre wa ba nha zi ni tron'a, 'Ba kamba ni Me migyen. ");
INSERT INTO jid_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Indji u no si sron ni ta ye - wa Mi ton ye yiwu rji ni ti'a, ahi Ibrji u njanji (Ruhu Gaskiya), iwa a rju rji ni Ti'a aye, ani no gban (shaida) nitu Mu. ");
INSERT INTO jid_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bi no gban nitu wa bi he yayi tun rji ni mumla. ");
INSERT INTO jid_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mi hla wayi ni yiwu ni ndu yi na kubu za na. ");
INSERT INTO jid_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba ju yi rju ni majanmiyan u iton ni ye, niwa indji ni ta hola yi vu ni to'o (wuya), ani ya ndi wawu si tie ndu Rji. ");
INSERT INTO jid_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba ti naki niwa ba na toh Ti'a ko Me na. ");
INSERT INTO jid_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi si hla biyi ni yiwu, inde iton nita ye, waba ti'a, bika ri mren Mi na hla ni yiwu,” Mi na hla kpe biyi ni yiwu ri na rji ni mumla, niwa Mi he niyi. ");
INSERT INTO jid_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Zizan yi Mi si hi ni Indji wa a ton me'a, naki me ni mi mbi, ba wa a minye Me, u hi ntsen? ");
INSERT INTO jid_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ni wa Mi hla ikpi biyi ni yiwu, damuwa shu ni yiwu ni sron. ");
INSERT INTO jid_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ime mi si hla njanji mu ni yiwu, abi ni yiwu ni ndu Mi hi kpamu, u Mi ta na hi kpamu na, wawu indji u sisron ana ye ni yi na, u Mi ta hi, u Mi ton ye niyi. ");
INSERT INTO jid_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ani ta ye, wawu Indji u nji si sron ye ani tsro gbungblu'a meme ti lahtre'a, nitu njanji ni tron me - ");
INSERT INTO jid_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","nitu lahtre, nitu wa bana kpa nyeme ni Me na; ");
INSERT INTO jid_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","nitu tsatsra, Mi hi ni Ti'a, u bina la tie bre to mena; ");
INSERT INTO jid_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nitu hukunci me niwa ba han hukunci ni ndji u nji gbungblu'a hukunci. ");
INSERT INTO jid_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ikpi gbugbuwu ba he wa Mi hla ni yiwu'a, u bina ya to zizan na. ");
INSERT INTO jid_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nitu ki, u Ibrji tsatsra u njanji aye'a, ani nji ni mi njanji wawu, niwa ana tre u tuma kankrji ma na, se ikpe wa awo, ani hla ki, ani hla ni yiwu ikpe wa ani tie. ");
INSERT INTO jid_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ani gbre Me san, nitu wa ani ban ikpi wa a u mu na hla ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ikpe iwa Iti'a ahe ni wu ahi u mu. Nitu ki, Mi hla da ani ban kpi wa a hu mu na hla ni yiwu. ");
INSERT INTO jid_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ni kogon vi ton, bina tie bre la to Me na, ni kogon vi nton fime ngari, bi la toh me. ");
INSERT INTO jid_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","U bari ni mi almajere Ma, ba tre ndi, “Ahi ngyeyi mba Igu yi ni son hla nitawu, 'Ni vi nkpurju nton bina la toh Me na, u ni vi nkpurju nton ngari bi la toh me,' u, 'Nitu wa Mi hi ni Ti'a?'” ");
INSERT INTO jid_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nitu ki ba tre ndi, “Ahi ngyeri wa asi tre'a, 'Ni vi nkpurju nton'a?' Kina to kpw wa asi tre nitu ma na.” ");
INSERT INTO jid_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu to ba si son Mye wu, na hla ni bawu ndi, “U bi kma ni mye kpa mbi Mu ikpe wa Mi si son hla andi, “Ni kogon vi nton fime u bina to me na, u ngari ni kogon vi nton fime bi la to Me?' ");
INSERT INTO jid_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Njanji, njanji, Mi hla ni yiwu, bi yi ni mren, u gbungblu ni ngyiri, imre mbi ni shu ni yi nyu ni sron, u imre u yi mbi ani ka tie u ngyiri. ");
INSERT INTO jid_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iwa ni to lo ngrji, ni nton wa a si yi nne nitu wa inton u ngrji ye. Inde a ngri vren yo ye, ana la bre rimren ilon Ma ngana, nitu wa a si ngyiri wa ba ngrji indji ni gbungblu'a. ");
INSERT INTO jid_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Zizan mba bi ri mre, Mi la to yi, u sron mbi ni ngyiri, u indrjori na ya ban ngyiri mbi'a rji ni yi na. ");
INSERT INTO jid_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chachu ki, bina mye Me kperi na. Njanji, njanji, Mi si hla ni yiwu, ko ngyeri bi bre ni mi Nde Ti'a ni mi Nde Mu ani no yi. ");
INSERT INTO jid_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ye zizan me bi na bre kperi nimi nde Mu na. Bika bre, u bi kpa, niwa ingyiri mbi a shu. ");
INSERT INTO jid_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mi hla kpi biyi ni yiwu ni mi karin magana, inton ni ye wa Mina la hla kperi ni yiwu na ni mi karin magana na, Mi sran hla ni yiwu ni rira, nitu Ti'a wa ani karin magana. ");
INSERT INTO jid_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ni chahu ki, bu tre ni mi nde Mu u Mina hla yiwu ndi Mi tre ni Ti; a nitu mbi na. ");
INSERT INTO jid_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Niwa Iti ni son yi kima, niwa bu'a bi son Me, u bi kpa nyeme ndi Mi rji ni Ti'a. ");
INSERT INTO jid_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi rji ni Ti'a, ni ri ni gbungblu'a, ye zizan, ngari, Mi bri ni gbungblu'a ni kma ni hi ni Ti.” ");
INSERT INTO jid_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Almajere Ma ba tre ndi, “To mba, zizan u si tre kpe wheme mba, una ka yiyi na. ");
INSERT INTO jid_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Zizan ki to u to ko ngyeri, ana wa ndrjori ni la mye na. Ni nakima, ki kpanyeme ndi u rju rji ni Irji. ");
INSERT INTO jid_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu a ka sa ni bawu ndi, “Bi kpa nyeme zizan? ");
INSERT INTO jid_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bika to, inton ni ye, ee, inton ye wa ba vra yi ti nkankan, ko nha ni kma hi ni ko ma, bi ka me don ni grji Mu. Ko nakime Mi na he ni nkrji Mu na, Iti Mu ahe ni Me. ");
INSERT INTO jid_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi hla wayi ni yiwu ndi bi he ni me Mu ni fe si sron. Ni gbungblu'a ba ki ti yi je, bika kri gbangban, Mi kpaka ni gbungblu'a. ");
INSERT INTO jid_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ni kogon wa Yesu tre yi, a nzu shishi hi ni shulu na tre, “Iti, inton yeye, no Vren Me ninkonni ndu Vren Me ndu no'u ninkon - ");
INSERT INTO jid_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ni wa u no gbengblen nitu bi nama kpa wawu ni ndu no re (ivri) u son hi ni tuntur ko indji ri me wa wu no'a. ");
INSERT INTO jid_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iwa ahi re (ivri) u tuntur, wa ba to, ba to wuyi nkrji Me Wu Irji, niwa u ton Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi no ninkon me ni meme, Mi kle indu wa u ne ndi Mi tiwu'a. ");
INSERT INTO jid_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Zizan, “Bachi ne ninkon wa me he niwu rji niwu ri ni ndu ba me gbungblu'a. ");
INSERT INTO jid_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi ye yar inde rju ni ndi biwa u ne ba ni gbungblu'a. Bana bi Me u wu ne ba, u ba nji tre me. ");
INSERT INTO jid_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Zizan, ba to ndi ikpe wa u ne wawu ba rji ni wu yi, ");
INSERT INTO jid_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mi no ba wawu lan tre Me wa wu ne. Ba kpa ba na to nda a njanji Mi rji ni Wu, na kpa nyeme ndi a wu u ton me. ");
INSERT INTO jid_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi tre niwu bawu (addu'a), Mi tre niwu ni bi gbungblu'a na, se ni bi wa u ne ni ba, biki babi Me. ");
INSERT INTO jid_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ikpe wawu wa ahi u Mu'a, a hi u Me. U Me ahi u Mu. Mi kpa ninkon ni ba. ");
INSERT INTO jid_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi na la u gbungblu'a ngana, u ba ndji biyi ba he ni gbungblu'a, u Mi si yi niwu. Tsatsra Ti, zi ba ni mi nde Me wa u ne ni ndu ba riri, nawa kita me ki riri. ");
INSERT INTO jid_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Niwa mina he ni ba, Mi ziba pyan me ni mi nde Me, ni wa u ne, Mi ka ba, u riri ni mi mbu ana yra tu na, se mri bi zyi bubu'a, ni ndu lantre'a shu. ");
INSERT INTO jid_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Zizan Mi si ye niwu, Mi si tre kpi biyi ni gbungblu'a ni ndu ingyiri Mu ndu shu ni ba. ");
INSERT INTO jid_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi no ba lan tre Me'a, u gbungblu'a kama ni ba nitu wa ba u lantre na, na wa Mi na u gbungblu'a na. ");
INSERT INTO jid_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi tre ni ndu vu ba rju ni gbungblu'a na ni ndu zi ba zizyime ni mi bi meme ba. ");
INSERT INTO jid_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba na bi gbungblu'a na, na wa mina u gbungblu'a na. ");
INSERT INTO jid_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Zi ba nkan nitu Me u njanji lantre Me a njanji. ");
INSERT INTO jid_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na niwa u ton Me ni gbungblu'a, naki Mi ton ba hi ni gbungblu'a. ");
INSERT INTO jid_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi mla tu Mu zi niwu nitu mba, ni ndu ba mla tu-mba zi me niwu ni mi njanji. ");
INSERT INTO jid_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mina tre niwu nitu iwa kankrji ma na, ani biwa ba kpa nyeme ni Me nitu tre mba'a ");
INSERT INTO jid_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ni ndu ba wawu mba hi ririi, nawu, Bachi, Wu he nimi Mu, u Ime nimi Me. Mi bre ni ndu ba he nimi Mbu, ni ndu gbungblu'a kpa nyeme ndi u ton Me. ");
INSERT INTO jid_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ninkon wa U ne'a, Ime me Mi ka no ba, ni ndu ba hi ririi, nawa kita me ki riri'a: ");
INSERT INTO jid_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ime nimi mba, u Wu nimi Mu - ndi dun ba nji tu-mba ye katu bi, ni ndi dun gbungblu'a ni to ndi u ton Me, andi U son ba na wa U son Me. ");
INSERT INTO jid_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Iti, Mi son biwa U kaba ne ndu ba he ni Me ni wurji wa Mi he yi, na to ninkon Mu, ninkon wa U Ne u nitu U son Me ri kuko ndi zi nchi gbungblu'a. ");
INSERT INTO jid_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tsatsra Ti, gbungblu'a na to Wu na, Ime Mi to'u, u ba ton nda ahi Wu yi U ton Me. ");
INSERT INTO jid_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi hla bawu inde Me, Mi la hla ni bawu nitu son Me wa U ndu he ni Me ni mi mba. ");
INSERT INTO jid_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ni kogon tre biyi wa Yesu tre ba, a rju ni almajere ma hi ni gran ko rima, ni kpa ngblu, ni bubu wa irju he'a u ba zu ri hi baba almajere Ma. ");
INSERT INTO jid_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda me wa ani kawu le'a a to bubu'a, nitu wa Yesu a zi hi ye ni almajere Ma. ");
INSERT INTO jid_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuda me, ka nji soja rji ni Firistoci bi ninkon, ni Farisawa, ni bi majelisa, u ba ye ni bubu'a, ba nji ba llu fitila ni ba tochi, ni ba kpi u ta ku. ");
INSERT INTO jid_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","U Yesu to kpye wa asi zren'a nitu ma wawuu, ahi ko shishi na mye ba, “Bi wa nha?” ");
INSERT INTO jid_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","U ba tre, “Yesu u Nazaret.” Yesu ka hla ni bawu, “Ame yi.” Yahuda ngame wa a le niwu'a, a kri ni sojoji ba. ");
INSERT INTO jid_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ni wa a hla bawu, “Ame,” u ba kma hi ni gon, na ka rjoku meme. ");
INSERT INTO jid_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ala mye ba ngari, “Bi wa nha?” u ba hla ngari ndi, “Yesu u Nazaret.” ");
INSERT INTO jid_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu hla bawu, e, Mi hla ni yiwu ndi, ahi me. Anita Ime yi bi si wa, bi ka ka biyi don ndu ba hi kpa-mba. ");
INSERT INTO jid_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kima ni ndu itre wa a hla ndu tsra, “Ni mi bi wa U Ne ba, ko riri me na kado na. ");
INSERT INTO jid_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Siman Bitrus me, nitu wu ahe ni inji gbeni, na k'ri fya chu ka tsen vren ko kikle Prist, na chu nvunvu ton ma kori, inde vren ko ma'a hi Malkus. ");
INSERT INTO jid_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu hla ni Bitrus, ka nji ngban yo ni hra ma ni bubun, Mi na so kokon wa Iti ane na? ");
INSERT INTO jid_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","U soja ba ni bi ninkon mba, ni majalisa Yahudawa, ba ka vu Yesu, na lo'wu. ");
INSERT INTO jid_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ni mumla ba nji hi ni Annas, nitu wa a hi iyi kayafas, wa ahi wawuyi kikle Prist ni se kima. ");
INSERT INTO jid_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas mba ana no ba Yahudawa mre, andi ani fi bi dun indji riri ndu kwu ni tu ba indji. ");
INSERT INTO jid_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siman Bitrus a hu kogon Yesu, na kime almajiri ri la ti ngame. I zizan almajiri ki me a shishi to ni kikle Prist'a, na ri hi ni kikle hra u kikle Prist me mba Yesu; ");
INSERT INTO jid_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","U Bitrus a k'ri ni nyu gon tre ni nkohtra, naki me almajiri rima ti, u almajiri wa ahi shishi to ni kikle Prist a rju, na tre ni wa - wa ani gben ni gontra, na lu ri hi ni Bitrus. ");
INSERT INTO jid_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","U vren wa wa ani gben ni gontra aminye Bitrus, “Iwu me una he ni mi almajire gu yi na?” wa tre, “Mi na he ni mi na.” ");
INSERT INTO jid_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","U bi ti ndu ni doka rji u hekali'a ba kri ni ki, u ba mu lu ni kla-mbrji, na son kosan ma si wo gba-ji, ni nton ki bubu ni si. Bitrus k'ri ni ba na si wo gbaji'a. ");
INSERT INTO jid_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kikle Prist a minye Yesu nitu almajere ma ni tsro ma me. ");
INSERT INTO jid_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ka sa niwu, e, Mi hla ni gbungblu'a ni hla tuma. Mi hla bawu nitu nitu ni majamiyan, ni hekeli ni bubu wa Yahudawa me ba ye gyen klan ki'a. Mi na hla kpyeri ni ri mbi na. ");
INSERT INTO jid_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","U ngye ri mba sa u minye me? Minye biwa ba sren ton na wo ikpe wa mi tre'a, E, ba to ikpe Mi tre. ");
INSERT INTO jid_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ni wa Yeswu hla biyi, u ri ni mi biya ba wa kukri niki'a a wru Yesu nda tre ndi, “U sa ni kikle Prist tre naki?” ");
INSERT INTO jid_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu tre niwu, Mi ta hla meme kpe to, u ka hu gon ma naki'a ta njanji Mi hla, to, u ngyeri ni sa u ka wru me?” ");
INSERT INTO jid_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","U Annas a ton ba ndu ba nji Yesu hi lowu ni Kayafas, kikle Prist. ");
INSERT INTO jid_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","U Siman Bitrus a kri si wo gbaji lu. U ndji ba ba tre niwu, “Ana iwu me u na he ni mi almajere ma na?” Wa kpa tron na tre, “A'a, mi na he mina.” ");
INSERT INTO jid_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","U ri nimi gran kikle Prist, vayi iwa Bitrus a fu nvunvu ton'a, ahla, O'oo, mina to niwu ni rju na? ");
INSERT INTO jid_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus la kpa-tron, hihari me igba lu t'bu. ");
INSERT INTO jid_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nikima Kayafas ba nji Yesu hi ni kogon'a, ni buu buu mble me, baba ni titu mba me bana ni kogon'a na, andi ndu baba n ata tre na kunyre bubu ri jibi u za gran na. ");
INSERT INTO jid_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","U Bilatus me a rju ye ni ba, na tre, “Anitu ngyeri bi nha gu yi? ");
INSERT INTO jid_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","U ba sa niwu, “Igu yi ani na ti meme kpe na, angyeri me ni sa ki ka nji wu ye tro niwu.” ");
INSERT INTO jid_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatus hla bawu, “Mji wu hi ni tutu mbi ni hi Furewu ni bi tron mbi!” U Yahudawa ba hla niwu,” E, kina he ni gbengblen u yo tron u wu ndji ni tu mbu na.” ");
INSERT INTO jid_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ba hla kima ni ndu itre Yesu tsra, ni biwa a tsra bibi kwu wa ani kwu'a. ");
INSERT INTO jid_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","U Bilatus la ri ni mi tra gon gona, na yo Yesu na minye, “Iwuyi U Chu Yahudawa ba? ");
INSERT INTO jid_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu sa niwu, “Ahi wu u hla, ka ba ndrjori mu ba yo Me naki niwu? ");
INSERT INTO jid_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus sa niwu, “Ime mina indji u Yahuda na, ka ani he?” E, ahi ndji Me ni Pristoci bi kikle ba ba nji wu ye le ni mu. “U tie ngye?” ");
INSERT INTO jid_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu sa, “Mulki Mu ana u gbungblu yi na, Mulki ana u gbungblu yi u mri ko Mu bana tiku ni ndu bana ka Me le ni Yahudawa na, Mulki Mu ana he ni wayi na.” ");
INSERT INTO jid_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","U Bilatus minye, “Ashe, anaki, U Chu?” Yesu sa niwu, “Anaki u hla ndi Mi Chu. Nitu ki ba ngrji Me, nitu ki mi ye ni gbungblu yi, ni ndu mi no gban ni tu njanji. Ko nha wa ani son njanji'a ani sren ton na wo lan tre Mu.” ");
INSERT INTO jid_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatus sa niwu, “Ahi ngye njanji?” Ni kogon wa a hla naki, ala rju ni Yahudawa, na hla, “Ime de mina to guyi ni latre na. ");
INSERT INTO jid_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bi to bi he ni igan ri, u idin za gran a tsra, ni chu indji ri no yi bi son mi no yi Ichu Yahudawa?” ");
INSERT INTO jid_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","U ba kpa-gro, kpan, kpan me na tre, “A'a, a wawu yi na, se Barabas.” Barabas'a me ahi indji yibi. ");
INSERT INTO jid_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","U Bilatus tsi Yesu ni panlan. ");
INSERT INTO jid_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soja ba chan inchon tie na u bi ta chu. Ba ban son ni Yesu nitu nda sru nklon u bi chu niwu. ");
INSERT INTO jid_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba wlu ye niwu, nda tre, “Ndu Irji ziwu gbron nkon, Ichu Yahudawa!” nda wru'u. ");
INSERT INTO jid_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","U Bilatus la kma rju ye ra nda hla, “To mba, mi nji wu ni ye ni yiwu ni ra ndu yi toh ndi mi na vu ni lahtre na.” ");
INSERT INTO jid_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","U Yesu a rju hi ni ra ni nchon tu chu'a ni tuma. Bilatus a tre, “Toyi, ngye ndji'a yi.” ");
INSERT INTO jid_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ni Pristoci bi ninkon-ninkon ma ni bi no chu'a mren ba to Yesu, u ba lu ni tre gbangban me, u du ba giciye wu, ndu ba giciye wu.” U Bilatus hla bawu, “Ban hi giciye, ime me mina to ni lahtre ni kpeti na.” ");
INSERT INTO jid_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","U Yahudawa ba hla niwu, “Ai ki he ni tron, ni du tron abi ni ndu kwu ni tu wa ka tuma tie Vren Irji.” ");
INSERT INTO jid_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wa Bilatus a wo naki na tie sissri kpukpome. ");
INSERT INTO jid_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wa la lu ri hi ni trangon, u gona minye Yesu, “U rji ni ntsen?” u Yesu na la sa niwu ngana. ");
INSERT INTO jid_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","U Bilatus tre ni wu, u na sa nimu na? Una to ndi me he ni gbengblen wa mi kpa'u chuwo a na, ni la giciye niwu na? ");
INSERT INTO jid_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu hla niwu, “Ai u na he ni gbengble na se ka ba no gbengble rji ni shu. Niti ki, indji wa a ka nowu a zan ni lahtre.” ");
INSERT INTO jid_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Niwo wu naki, u Bilatus ni wa gon wa ani chuwu chuwo, u Yahudawa ba ba lu tre ngban me andi, “U ta ka guyi chuwo, una ikpan Kaisar na, indji wa a ka tuma tie chu, a kpa Kaisar tsri.” ");
INSERT INTO jid_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ni wa Bilatus a wo bi tre mba wa ba si tre'a, na nji Yesu rju ni hra na kuson ni riron ma ni bubu wa ba yo ndi, tragon u bla tre ni Yahudawa ba yo, “Gabbata.” ");
INSERT INTO jid_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","U ni vi kima ba mla ki ti ni gben idin u za gran, ni nton krifi tanne mba ni gbengbe rji. Bilatus hla ni Yahudawa “yayi, ingye Ichu mbi!” ");
INSERT INTO jid_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","U ba lu yra gro, ndu ba njiwu hi, ndu ba njiwu hi, ndu ba giciye niwu, Bilatus minye ba, “Mi giciye ni Chu mbi?” Pristoci bi ninkon ba tre, “Kina he ni ichu rina se Kaisar.” ");
INSERT INTO jid_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","U Bilatus a ka Yesu chuwo ni bawu ni ndu ba hi giciye wu. ");
INSERT INTO jid_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","U ba nji Yesu na hi, na ban giciye'a kima, ni hi ni bubu wa ba yo, “Bubu kwukwu ni Yahudawa mba (Golgota).” ");
INSERT INTO jid_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","U ba giciye niki, ni indji hari bari, iri ni ko ni nhama ko rime, Yesu mba he ni tsutsu. ");
INSERT INTO jid_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus mba nha yo gban nitu giciye. Niki ba nha ndi: “YESU U NAZARET, ICHU YAHUDAWA. ");
INSERT INTO jid_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudawa gbugbuwu ba krawu igban nitu bubu wa giciye Yesu i whewhre ni mi gbu. Yo gban a he ni l'be Yahudawa, ni Romawa, ni Helenawa. ");
INSERT INTO jid_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","U Pristoci bi ninkon bi Yahudawa ba ndi, ndu na nha ndi Ichu Yahudawa na, u tre, 'Iwa yi tre ndi, “Ime yi Mi Chu Yahudawa.'”” ");
INSERT INTO jid_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus tre, “Ikpe wa mi nha mi nha naki.” ");
INSERT INTO jid_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ni kogon wa soja ba giciye Yesu, u ba ban nklon ma, nda y'ba ga'u tie nhama nzah, ko nha niwu ma, ngbala, u nklon ba na wran na ba ka klo ki klo ni shu ye ni meme. ");
INSERT INTO jid_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","U ba hla ni kpamba, kina y'ba nklon na, ye ki ta chacha ni tuma ni to indji wa ani ban wu. Ba tie naki ni ndu lan tre Irji ndu shu wa a tre ndi, “Ba ga nklon Mu ni kpamba, na ta chacha nitu nklon Mu.” Wayi a kpe wa Sojoji ba tie. ");
INSERT INTO jid_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iyii Yesu, u vayi yima vren wa, Maryamu iwa Klofas, ni Maryamu Magdaliya ba kri whi ni giciye u Yesu'a. ");
INSERT INTO jid_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Niwa Yesu a toh yima ni vren koh ma wa ani son'a, ba kri whewhre, a hla ni Yi Ma, “Iwa, toh Vren me!” ");
INSERT INTO jid_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nda hla ni almajiri, “To, Iyi me!” Rji ni nton kima ivren koh ma a njiwu nda hi ni koh ma. ");
INSERT INTO jid_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ni kogon kima, ni toh ndi ko ngyeri a tie kleye, u ni ndu lantre Irji'a he towa ba hla, Yesu a tre ndi, “Hlan mma ni tie Me.” ");
INSERT INTO jid_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ni ngbala ko mba imma inabi a he ngbala shu ni gbu lan nda sa yra, u ba ka soso sun ni mi imma inabi wa'a sayra na lowu ni kpala na zu ka sun ni wu ni nyu. ");
INSERT INTO jid_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Niwa Yesu mah imma wa a sayra, na tre, “A kle.” Na ka tu ma ti grji na chu vri ma. ");
INSERT INTO jid_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","U Yahudawa, ba to a hi vi u mlati mati, bana son ni ndu kpon'a kru ni giciye'a na, ni nton u idin na (idin'a a vi u ndindima) (special), u ba bre Bilatus ni ndu nzi za mba ni grji ba zi. ");
INSERT INTO jid_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","U soja ba ye nzi za indji u mumla na nzi wu ha waba giciye ba baba Yesu. ");
INSERT INTO jid_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","U ba ye nitu Yesu na to nda a kwu ye, u bana nzi za mana. ");
INSERT INTO jid_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Naki me, iri ni mi soja ba, akama na tu bu ni mashi ni san, hihari me iyi mba mma ba rju. ");
INSERT INTO jid_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Indji wa to iki'a, wawu yi shaida, shaida ma a u njanji. A to ndi ikpe wa a tre a njanji ni ndu yi me kpa nyeme. ");
INSERT INTO jid_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ba ti naki ni ndu lantre ma, ndi shu, “kwukwu ma riri me bana mre na.” ");
INSERT INTO jid_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","U lan tre ri tre, “Ba ya indji wa ba t'bu'a.” ");
INSERT INTO jid_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ni kogon biyi, Yusufu igu u Arimatiya, wa ahi almajiri Yesu (A riri, nitu sissri Yahudawa) a bre Bilatus ndu wawu gon ndu wawu ban k'mo Yesu. Bilatus no gon, u Yusufu ye ban ik'mo'a. ");
INSERT INTO jid_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimus ngame aye, wa ni mumla a ye ni Yesu ni chu. A nji turare u myrrh mba aloes, a tiewhre lita deri ni ron ma. ");
INSERT INTO jid_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","U ba ban kmo Yesu na nyewu, ni pri ni kpi be nyen whi riro, ni ndu ba rju na wa du Yahudawa he. ");
INSERT INTO jid_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ni bubu wa ba giciye niwu la bu ri he niki, ni mi labu'a ibe ri a he ni ki wa bana rju ndrjori to na. ");
INSERT INTO jid_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nitu wa a hi vi u mlati-mlati u Yahudawa, ibe'a he whewhre, u ba ka Yesu yo ni mi. ");
INSERT INTO jid_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ni bu'u bu'u mble ni vi u mumla, ni mi sati'a u bubu ri tie bu'u ri, Maryamu Magdaliya aye ni nyu be, aye to ba ban tita wa ahe ni ny be rju ye. ");
INSERT INTO jid_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nda kma tsutsu hi ni ba Siman Bitrus mba almajere mba wa Yesu ni son'a, na hla bawu, “Ba ban Bachi ni mi be, ki na to bubu wa ba ka yo'a na.” ");
INSERT INTO jid_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","U ba Bitrus ni almajere mba ba rju na hi ni be'a. ");
INSERT INTO jid_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wawu mba wu ba tsutsu me, u almajiri ri ma a kari guchi ni Bitrus ni be'a. ");
INSERT INTO jid_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wa kudran na kloto ya, na to ipri nkinkla re me ni bubu'a, nda na ri hi ni mi na. ");
INSERT INTO jid_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","U Siman Bitrus a ye ri ni kogon na ri hi ni mi be'a, na to ipri nkinklan re me a kri ");
INSERT INTO jid_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni vi pre wa a he ni tuma. Ani he ni bubu riri ni pre na, na ch'bi kpama kuru kan. ");
INSERT INTO jid_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","U almajiri wa a guchi hi ni nyu be'a ngame, lu ri hi ni mi be'a na ka to, na kpanyeme. ");
INSERT INTO jid_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hra ye ni nton kime, bana ya to tre Irji wa a hla, ani la ta sh'me ni kwu. ");
INSERT INTO jid_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","U almajere ba ba kma hi koh ngari. ");
INSERT INTO jid_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","U Maryamu kri nyu be na siyi. Niwa a siyi, na kudran ya mi be'a. ");
INSERT INTO jid_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iwa to Maleku hari ba son ni nklon nkinklan, iri kotu u iri ni ko za ni bubu wa ba ka Yesu yo. ");
INSERT INTO jid_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","U ba hla niwu, “Iwa ni nko u yi ni tu ngye? Wa hla, nitu wa ba ban Bachi mu, mina to bubu wa ba ka zi'a na. ");
INSERT INTO jid_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A tre kle, nikogon ki, na k'ma ya na to Yesu kri niki, nda na to ndi a Yesu na. ");
INSERT INTO jid_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu tre niwu, “Iwa u yi ngye? Wu si wa nha yi?” A ban andi ahi indji wa ani tie ndu ni rju'a, (labu). U wa hla niwu, “Iti ko u tie ban wu, u ka hla wurji wa u ka zi'a, ni ndu mi ban wu.” ");
INSERT INTO jid_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu hla niwu, “Maryamu.” Wa kma ya, na hla niwu ni Armaniyanci, “Rabboni” andi mala. ");
INSERT INTO jid_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu hla niwu, na bre wo ni me na, mi na hon hi ni Ti'a rina, hi ni mri vayi Mu ni hla bawu, mi hi ni Timu ni Timbi, Irji mu ni Irji mbi. ");
INSERT INTO jid_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu Magadaliya ahi na ka hla almaere “Mi ka to Bachi” na hla andi a hla wawu ikpe biyi. ");
INSERT INTO jid_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ni yalu chachuki ni vi u mumla u sati'a almajere ba tro kpamba krju ti ni miko nitu sissri Yahudawa, Yesu ye kukri ni mi tsutsu mba, na tre, “Isi suron ni yi.” ");
INSERT INTO jid_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ni kogon wa a hla naki, na ka wo ma tsro ba ni ko san, u almajere ba ngyiri ni wa ba to Bachi'a ");
INSERT INTO jid_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu la hla bawu ngari, “Isi sron niyi, na wa Iti'a a ton me, Ime me mi ton yi.” ");
INSERT INTO jid_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wa Yesu tre naki, na fu vri ma sru ni bawu, na hla bawu kpa Brji Tsatsra (Ruhu) Maitsarki. ");
INSERT INTO jid_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Indji wa bi kpa latre wru hle niwu, ba kpa wru hle niwu indji wa bi nji latrema ba nji latre'a. ");
INSERT INTO jid_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, iri ni mi wlon don ha, wa ba yo ni vren hlan hen'a, ahe ni bana ninton wa Yesu ye rju ni tuma ni bawu'a na. ");
INSERT INTO jid_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Imbru almajere ba hla niwu, “ki to Bachi.” A hla ni bawu, “Se mi toh wrji wa ba kpan ni wo ma ri, ni ka vren wo mu yo nitu wrji'a ri mika kpa nyeme.” ");
INSERT INTO jid_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Niwa a tie vi tandra, mri koh ma ba he nimi ngari, u Toma ahe ni ba. Yesu ka ye ka ba tro ba nkon ba, na kri ni mi mba, nda hla ndi, “Si sron ni yiwu.” ");
INSERT INTO jid_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","U nda hla ni Toma, “Ka vren wo me yo niwayi ndi to wo Mu'a. Ka wo me yo ni wayi ni yo'u ni kosan Mu. Na ka kpa nyeme na, ndi kpa nyeme. ");
INSERT INTO jid_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma ka kpa sa na hla niwu ndi, “Bachi mu ni Irji mu.” ");
INSERT INTO jid_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu ka hla ni wu ndi, “Nitu wa wu to Me ri, ndi kpa nyeme. Lulu ni ba ndji biwa bana to na, nda kpa nyeme.” ");
INSERT INTO jid_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zizan Yesu tie gbugbu gban bari ni shishi mri koh Ma, gban wa bana nha ba sru ni mi nvunvu yi na, ");
INSERT INTO jid_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ama biyi ba nha ba zi nitu dun yi kpa nyeme ndi Yesu yi a Kristi'a, Ivren Irji, nitu kpa nyeme mbi, bi kpa ivri ni mi nde Ma. ");
INSERT INTO jid_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ni kogon bi kima, Yesu hla ka tsro Itu Ma ni almajere ma ni nyu nne Tiberiyas. Gen ya nda a tsro tuma: ");
INSERT INTO jid_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siman Bitrus he mba Toma wa ba yo ni dan tagwai, ni Nataniyel, ni Kana u Galili, ni mri Zabadi, ni almajere Yesu hari bari ngari. ");
INSERT INTO jid_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siman Bitrus hla bawu, “mi hi vu lambe.” U ba tre, “Kita me, ki huwu hi me.” U ba lu rju hi naka ri ni mi ingyu'a, ni chu chachuki bana vu kperi na. ");
INSERT INTO jid_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Se imble ni kpan, u Yesu kri ki ni nye nne, u almajere bana to me nda a Yesu na. ");
INSERT INTO jid_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","U Yesu tre ni ba, “Mri nze, bi he ni kpe wa bi ri'a?” U ba ti san na tre, “A'a.” ");
INSERT INTO jid_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A hla ni bawu, “ta walawa u bu lambe hi ni wo kori ni gyu'a, bi vu bari.” U ba ta walawa mba, yo ni mma, na chu wo kran nitu wa lambe ba ku babran. ");
INSERT INTO jid_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","U almajere ma wa Yesu ni son zan ba hla ni Bitrus, “Ahi Bachi.” U Siman Bitrus a wo naki Ashe ahi Irji, na lu sru kpi ma u ko tu'a (ana son ni kpa kuklu), na ton ku ni mi nne. ");
INSERT INTO jid_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Imbru almajere ba ba ye ni mi gyu vi tsitsa, (nitu wa bana gbonron gon ni bubu'a na, ina kamu deri ha hi ni ko tu), wa chu walawa shu ni lambe rju ni mi mma. ");
INSERT INTO jid_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ni ka walawa yo kora ni lambe'a, u ba to kla nu ni lambe ni tuma ni bredi. ");
INSERT INTO jid_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu bla nji bari ye ni mi lambe'a niwa bi vu zizan.” ");
INSERT INTO jid_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","U Siman Bitrus a hon, na gbi walawa shu ni lambe deri ni hamsi don tra (153). Ni bran mba me, walwa na ya ba na. ");
INSERT INTO jid_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","U Yesu hla ni bawu, ye ni ye kle ye.” U riri me ni mi almajere ma me na ya miyen na, “A wu nha?” Ba to nda Yesu. ");
INSERT INTO jid_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu ye, na ban bredi'a, na ga ba, nilambe me. ");
INSERT INTO jid_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iki a hi gyu u tra mba Yesu ni tsro tu ma ni almajere ma ni kogon wa a lunde ni be. ");
INSERT INTO jid_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ni kogon wa ba kle ya, Yesu hla ni Siman Bitrus, Bitrus vren Yohana, u son me zan biyie?” Bitrus hla niwu, “Ee Bachi, U to ndi mi son wu.” Yesu hla niwu ndi, “No ntma mu ba biri.” ");
INSERT INTO jid_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ala tre niwu ngari ni nkpu u ha, Siman ivren Yohana, U son me? Bitrus hla niwu, “E, ana Bachi, U to ndi mi son wu.” Yesu hla niwu, “krju ntma mu.” ");
INSERT INTO jid_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ala tre niwu u gyu u tra, “Siman ivren Yohana, u son Me?” U Bitrus a ku niri mre nitu wa Yesu a hla tre niwu u gyu tra, “U son Me?” A hla niwu “Bachi, U to wawu kpi, U to ndi mi son wu.” Yesu hla niwu, “No ntma mu biri. ");
INSERT INTO jid_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Njanji, njanji, Mi hla ni yiwu, ni wa u na he ni nze me, U ta zon kpame, ni hi wurji iwa u son'a, u ta cheye, u nme wo ba me son, u ndji ri mu ni zon kpa ni wu na ban wu hi ni wurji wa u na son hi'a na. ");
INSERT INTO jid_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu hla naki nitu bibi ikwu wa Bitrus ni kwu'a ni ndu Irji kpa gbre san, ni kogon wa a hla naki, na ni Bitrus, hu me. ");
INSERT INTO jid_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus ka ban ya na to almajiri wa Yesu ni son asi hu ba, ni wa a ku yeren ni san Yesu ni ton wa ba si ta ri jibi wa tre, “Bachi, a nha mba ni ka wu le'a?” ");
INSERT INTO jid_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wa Bitrus a to'a na tre Yesu, “Bachi, ahi ngye igu mu ni ti?” ");
INSERT INTO jid_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","U Yesu tre, “Mi ti ni son ni ndu son gben Me niwayi hi ni nton wa Mi kma ye, ume hi ngye? Ye hu Me.” ");
INSERT INTO jid_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Itre ki yra shu ni mi Yahudawa andi, almajiri ki na kwu na. U wana naki na Yesu hla ni Bitrus na, almajiri mba ana kwu na, a tre Mita ni son ndu san, u ime ahi ngye?” ");
INSERT INTO jid_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A wawu yi almajere wa asi sheda ikpi biyi, iwa a nha ba, u ki to gbigbi sheda ma njanji. ");
INSERT INTO jid_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","U mbrun ikpi bari gbugbuwu wa Yesu atie, u ba ni nha ba ni yiyri, mi hla ni yiwu, gbungblu wawu ani na ya ban nvunvu wa ba nha ni ba na. ");
INSERT INTO jid_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ikpi biwa mina hla niwu'a, Theophilus, a ne nitu ndu u tsro wa Yesu a ti rhi ni mumla. ");
INSERT INTO jid_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ahe ni iri wa ba bariu hi ni shu, nikima wa a 'mmha manzani wa ana chuba'a ni ruhu tsatsra, a. ");
INSERT INTO jid_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Niwa baya wa ba tiu ya a stro tuma ni sisren ni bawu ni nkon kankan ni du ba na kpatron ni lunde ni be mana A tsro tuma nibawu wu vi tsotra don za nda tre ni ba nitu koson (shulu) Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Niwa a kri ni shubimba ni wu, a'mmha ba du bana don Urishilima na, du ba gben shirjhi wu tima, wa a lha ndi, “Bi wo ni nyumu. ");
INSERT INTO jid_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ndi a hi janji, Yohanna a ti batisma ni yiwu ni ma, ama ni vi yi, bi kpa batisma wu Ruhu Tsatsra.” ");
INSERT INTO jid_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Niwa ba shu ki, ba miye ndi baci, “zizanyi ahi ton yiyi u kma tuchu gbungblua ye ni Israila? ");
INSERT INTO jid_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A lha bawu ndi “Ana wumbi du yi to nton ko vi waa timu a yo ni gbengble ma na.” ");
INSERT INTO jid_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama bi kpa gbengble wa Ruhu Tsatsra ni ku yiwu, niki bi bla ni tumu, rhi ni Urishilima baba Judiya wawu mba Samaria, ni ka ri ni klekle gbungblu meme. ");
INSERT INTO jid_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A kle tre kpi bi yi nu, niwa ba ki si ya shulu, ba ban'u lu hon, e clalu a kawu u shishi mba ka la tou na. ");
INSERT INTO jid_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Niwa ba rhisi yo shishi ni ya hon ma hi shulu'a, ndhi ha ni nkon kinkla ba krirhu kri ni mimba. ");
INSERT INTO jid_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ba tre ndi, “Biyi ndhi bi Galilee, “bi ki ya gye ni shulu? Yesu yi, wa ba banwu hi ni shulu, ni kima ye bibi wa bito ba ban u hi ni shulu'a” ");
INSERT INTO jid_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mle ba k'ma grhi rhi ni ngblu wa ba yo ndi Olivet, wandi a wiewiera ni Urishilima, hi ni mi gbu Urishislima, ezren vi chanchu sati. ");
INSERT INTO jid_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Niwa ba ye ri, ba tsi hunhi tra u koshu, wa bah kini mia. Bana ba Yohana, yakubu, andarawus, Filibus, Toma, barthelomen, Matiu, Yakubu Ivren Alphanso Siman wa ini wu ngyegere me, Mba Juda Ivren Yakubu. ");
INSERT INTO jid_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wawu mba ba zontu ki ni bubu riri nda sia bre Rji, baba Mba ba, ni Maryamu ehi Yesu, baba mri vayi ma. ");
INSERT INTO jid_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Niri baki, Bitrus a lu kri ni mi mri vayiba, bana tsra ndhi 120, nda tre ndi. ");
INSERT INTO jid_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mri vayi, a he nitu du tre wu vunvu tre baci du rhu tsra, nawa Ruhu Tsatsra ana lha ni nyu Dawuda ni tu Juda, wa a tsro biwa baye vu Yesu nkon. ");
INSERT INTO jid_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ana irimbu wa a kpa ndu wandi anuta ngame.” ");
INSERT INTO jid_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Zizan ndhi yi a ka le irhu ni nkle wu meme dri wandi a kpa'a, nda ka rhoku nitu u Kpama ka yrahle, ni irhenma ba ka vrale ni meme. ");
INSERT INTO jid_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wawu ndhi bi ki ni gbu Urishilima ba wo kpe wa a zren kima ba yonde irhu kima ni lan gbu mba ndi. “Akeldama”, wandi a tsra ni nde “Irhu u yi.”) ");
INSERT INTO jid_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ba tre ni tuma ni vunvu tre zabura, ndi, “Du ba du irhukima du kri ton kpo, e du ko ndior na kruko ni kimana ");
INSERT INTO jid_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ani bi du lilon ri wa azi wuta rhini nton wa baci Yesu a zren ri nda rhu ni mi mbu, ");
INSERT INTO jid_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Rjhini baptisma wu Yohana, ye ni vi wa ba ban'wu hon ni shishi mbu, nda toh tash'men rhi ni qu ngame. ");
INSERT INTO jid_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ba ju nji ha zi, Yusufu wandi ba yondi Barsabbas, wandi bata yondi Justus ngame, mba Matayas. ");
INSERT INTO jid_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba bre ndi “Baci, wuhi wu toh suron ndhi ko nha, tsro ta ka ahi nya nimi ndi bihi wa wu chu ");
INSERT INTO jid_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ni du ban bubu son manzani wu bla kpe wa ato, nitu tash'm ma ni mimbu, wandi Juda a k'ma gon tiwu nda hi kpama.” ");
INSERT INTO jid_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba yo kuriya nitu mba, wa a ku nitu Matayas, e ba bla a yo ni manzani wlo don iri ba. ");
INSERT INTO jid_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Niwa ivi pentacos a ye, bana ki ni bubu riri wawumbawu. ");
INSERT INTO jid_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mle, kikle gyungyu ri, rhi ni shulu, a lu fu grji ye ka ko wa bana ki nima'a. ");
INSERT INTO jid_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Elem to ilu kri ku gason nitu mba ni yiyri. ");
INSERT INTO jid_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ruhu Tsatsra a ri shu ku ni ko aha mba, e ba lu kri ku tre ni leme kankan, wa ruhu a tsro ba. ");
INSERT INTO jid_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ni kima, Yahudawa bi hu nkon Irjhi, rhi ni gbu gbungblu kankan ni meme, bana he ni Urishilima. ");
INSERT INTO jid_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Niwa baa wo langyungyua, akpa ba rhikice u ba ye bubu riri ikpea a kpa ba tsi shishi, nitu ko nha asi wo ba ni lan tre gbumma ");
INSERT INTO jid_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kpe a k'ma nuba sisiri ni mre; i ba tre ndi, “E biyi wawumba, bi si trea, bana ndhi bi Galilee na? ");
INSERT INTO jid_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A ngye ti du ta niwo ba ni lan tre gbunbu, lan wa ba grjita niwa a? ");
INSERT INTO jid_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthians mba medes mba Elamites mba biwa ba ki ni mesopotamia, ni Judea mba Cappodia, wu Pontus mba Asia. ");
INSERT INTO jid_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia mba Pamphylia, ni Egypt mba mbru bubu bi Libya hi ni Cyrene, mba Bitsri wa ba rhi ni Rome. ");
INSERT INTO jid_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yahudawa baba biwa ba kpa hu irjhi wu Yaudawa ba, Cretans baba larabawa, ki wo ba si tre ni lan mbu nitu kikle ndu Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A nuba rhimre ni sisiri i ba tre ni kpa mba ndi, “A hi ngye to yi?” ");
INSERT INTO jid_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bari banza ba nda tre ndi, “Basi huwa hi sa.” ");
INSERT INTO jid_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","E bitrus a lu kri nimi wlon donri mba, nda nzu lan nda tre gbangban me niba ndi, ndhi lilon be gbu Judea, baba ndhi wawu'u biwa, bi ki ni Urishilima, sren to ni lan tre mu nidu yi mlaa toh. ");
INSERT INTO jid_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ndhi biyi bana si hwu na wa bi ban na, zizan ni ton wu tra wu hwumble genri. ");
INSERT INTO jid_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kpe yi a tsra ni tre anabi Joel; ");
INSERT INTO jid_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ani he vi bi kle kle, Irjhi a tre, “Mi vra ruhumu nitu rima ndhi wawu. Mri mbi lilon baba mrimba ba rira ikpi bi ye ni ko shishi mri nzembi ba to ko waayi e bi chiche mbi hra ra nitu ra. ");
INSERT INTO jid_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jaji bi ndu mu, lilon baba mba, mi buwa ba ni ruhu mu u ba nra kpi biye ni ko shishi. ");
INSERT INTO jid_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi tsro kikle ndu mu ni shu shulu, mba ni alamu mu ni meme (gbugblu), iyi ilu mba ntse Ikpan irjhi ni k'ma ti bwu, ");
INSERT INTO jid_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kpan iwha ni k'ma ti iyi, ri du kikle vi wu Baci ni ye, vi wa ko nha ni to nda rhimre nitu ma. ");
INSERT INTO jid_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ani to ki, ndhi wa a yo nde Bacia ani nawo ");
INSERT INTO jid_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ndhi bi Israila, wo lan tre biyi, Yeshu wu Nazarat ana ndhi wa Irjhi a nzu hon ni shishi mbi, ni kikle ndu ni kpi bi du ndhi bwunyu yo hyo ni wuo Irjhi ati ni woma ni mimbi, me wa biyi me bito. ");
INSERT INTO jid_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ndi yi wa ba vuu nu tsra ni kpe wa Irjhi ana mla zi nda to; ni wo meme; ndhi wa bana zren ni tu nkon na ba wuu ni kpan u ni kunkro (kros). ");
INSERT INTO jid_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama Irjhi a nzu lu, nda chuchuwo ni ya wu qu, nitu iqu na he ni gbengble wu vu u nji na ");
INSERT INTO jid_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ni kima Dawuda a tre ni tuma ndi “me to Baci chachu ni shishi mu; ngye a he ni kosan worhimu di du mina c'bi rhuna. ");
INSERT INTO jid_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nitu ki, mi ngri ni suron mu e line mu a takpe. N'makpa mu ngame ni son ni yo suron. ");
INSERT INTO jid_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wu na kamedon ni meme ko iu na ni na du Tsatra me du gla na. ");
INSERT INTO jid_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wu bwu nkon wu rai ni mu du mi mla to, wu du me ngri kpukpo me ni shishi me ");
INSERT INTO jid_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mri vayi, ani bi numu dumi tre ni yi ni suron wu kpanyme, (hamma ni sisiri), nitu chiche baci. Dawuda, ndi a qu e ba rhuwu, e ibe ma he ni ta ya ni vi wu luwa. ");
INSERT INTO jid_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nitu kima ana anabi wa a toh ndi Irjhi a shirhi ni ban niwu ndi eh'pu wu nchinema ni hon son nitu tuchuma. ");
INSERT INTO jid_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A to kpe wa ani ye he ni shishia ndda tre ni tu lu tashme Kristi, ndi bana kawdon ni ko qu na; e n'mama na gla na. ");
INSERT INTO jid_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu yiwa Irjhi a nzu lunde, e kita wawumbu, ki bla ikpe wa kito di wo nitu ma'a. ");
INSERT INTO jid_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nitu ki, niwa ba nzu hon hi wo ko rhi wu Irjhi, nda kpa Ruhu Tsatsra wa titi baci a shirhi niwu, a vu vra grhi, ikpi wa bisi to nini wo'a. ");
INSERT INTO jid_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda ana hon hi ni shuluna, ama nda tre ndi “Baci a lha ni Bacimu,” ku son ni wo rhimu. ");
INSERT INTO jid_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Di gben dumi k'ma bi kamba (yo shishi) niwu ti ruron wu sa za me.” ");
INSERT INTO jid_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Niki ma, du ko Israila wawu mla toh ndi janji, Irjhi du he Baci mba Kristi, Yesu yi wa bi Kpanwu nitu kros'a. ");
INSERT INTO jid_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Niwa ba wo tre yi a yra ba suron, e ba lha ni Bitrus baba mbru manzani ba, ndi “Mri vayi, ki ti nihe?” ");
INSERT INTO jid_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitrus lha bawu di k'ma gon nu latre, ni kpa baptisma, ko nha bi ni nde Yesu kristi, ni wru latre bi ni Irjhi hlega, ndi kpa Ruhu Tsatsra wa ani nu hamma ni du ui han kpe. ");
INSERT INTO jid_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Shirhi'a ahi wumbi, baba mrimbi, niwa ba he gbagban me ngame; wawundhi wa Baci Irjhi mbu ni yo ba'a” ");
INSERT INTO jid_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ni lan tre gbugbuwu, a tre ni tu kima'a nda nrooba ndi.” Nhawo rhu ni k'ba bi kawatre yi. ");
INSERT INTO jid_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mle ba kpa tre ma e ba ti baptisma ni bawu, ndhi dubu tra (3,000) ka ru nha ni ba. ");
INSERT INTO jid_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba ye suron mba ni bubu riri ni kpa Isro manzani mba zumunta, nda ni ga bredi wu jibi, mba bre Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sisiri a vu ko nha e anabawa'a ba ti ndu gbugbu baba ekpi bi tsro (sisir) ya. ");
INSERT INTO jid_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Biwa ba kpanyme ba ki ni bubu rii nda ti ko ngye to u ndi riri, hamma ni chuti nkan, ");
INSERT INTO jid_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba vu ba kpimba le nda ga ni ko nba nmba tsra ni kpe wa ko nha ni son. ");
INSERT INTO jid_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nivi hi nivi, ba yo tu mba ni suron riri ni ko Irjhi, ");
INSERT INTO jid_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba ga bredi niko rikomba, nda ga birhi ni nroo kpamba hamma ni nzutu, ndani gbre nde Irjhi ndi ba ba kpanyme ni ba e chachu, Baci a si gbron ndhi wa basi nhawo ni ye niba nda du gbrumba a si hon ");
INSERT INTO jid_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Niki Bitrus mba yohanna basiya hon ni hi ni tra Rji ninton wu bre, mton wu tiya. ");
INSERT INTO jid_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ba zontu ni ndhi ri, wa a chon kple rhini nine yimma, ba banu bibanmu ye zi ni kikle nkontra hekali wa ba yondi, “wu bi”. Ba ta kau zi niki chachu ni du ta bre biwa ba si rinimi hekalia. ");
INSERT INTO jid_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Niwa a to Bitrus mba Yohana Basia rini hi nimi hekalia a bre ba du ba nuu kpe. ");
INSERT INTO jid_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bitrus a yo shishi nda gba a me mba Yohana niki, nda tre ndi, “ya ta”. ");
INSERT INTO jid_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ndi wa chon kple'a nzu shishi nda yaba ni yo suron da ni kpakpe ni womba. ");
INSERT INTO jid_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ama Bitrus tre ndi “mina he ni silva mba Zinariya na, ikpe wa mihe niwu, mi nu. Ni nde Yesu Kristi wu Nazarat, lu zren” ");
INSERT INTO jid_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bitrus a tiwo vu u ni woma wu ko rhi da nzu u lunde, mle iza mba toza ma ba sen ququ. ");
INSERT INTO jid_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Gurugu mba a duo lunde kri nda ni zren; nda rhi hu ba Bitrus mba Yohana hinimi haikalia, ni zren da za ndani yose wu gbre Irjhi san ");
INSERT INTO jid_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndhi ba wawumbawu ba too si zren ndani yose u gbre Rji san. ");
INSERT INTO jid_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba ya nda to ahi gu wa atason ndani bre nkle ni kikle nkontra haikali wa ba yondi nkontra wu bi a sisiri ni mre a shubawu ni suron nitu kpe wa ba to ni igu'a. ");
INSERT INTO jid_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Niwa a si hu za Bitrus mba Yohana, ndhi ba ba tsutsu hi riba ni nkalhang nyunko wa ba yo hihiwu Sulemanu a ndani bwu nyu yo ni wuo nitu kikle kpe wa a he nitu ma'a. ");
INSERT INTO jid_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Niwa Bitrus a to toki, a sa ni ndhi ba ndi. “Biyi Ndi lilon bi Israila, a ngye du yi ni bwunyu ni yo ni wuho? Nitu nagye bi sru shishi nita, rhuto kitaayi ki du gua lu zren ni gbengblen mbu koka ni gbugblu mbu ");
INSERT INTO jid_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Irjhi wu Ibrahim, mba wu Ishaku, ni wu Yakubu, Irjhi wu ba timbu, wawuyi a gbre veren ma Yesu san. Wa wuyi bina vuu lo di kaambi ni wu ni shishi Pilate, wa a ta son shu chuwo'a. ");
INSERT INTO jid_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bi kanmbi ni Tsatra mba wa a hamma ni atre, ni mye du ba chundhi wa a wuu ndi mu chuwo niyiwu. ");
INSERT INTO jid_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bi wuu wa ivri rhurhi niwu, wandi jrjhi a nzu lunde baya qu-e kita ki bi wa kito ni shishimbu. ");
INSERT INTO jid_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nitu kpanyme ni suron riri ni ndema; ndema a du guyi, wa bisi ya ni to ou, a lu kri ni gbengblen ma. kpanyme ma ni Yesu a nu si kpa ni shishi mbi wawu. ");
INSERT INTO jid_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Zizan, mir vayi mi to ndi, bi na tona biyi baba bininko mbi, ekpe wa bi tio. ");
INSERT INTO jid_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ama kpe wa Irjhi ana lhazi ni nyu anabawama, ndi kristi ni ti ya, kima a ye ku tou ki. ");
INSERT INTO jid_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kima gon nu latre di du ba wru latre mbe hlega. ");
INSERT INTO jid_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Niton wa bi he tare ni Baci wa a ni ton kristi wa a mla yo ni yiwu Yesu. ");
INSERT INTO jid_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wa wuyi shulu ni kpa har hi ni nton wa kpi ba k'ma ye ti ndidi Irjhi a tre nisen, ni nyu tsatra anabawa ma'a. ");
INSERT INTO jid_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa a hla ndi. “Baci Irjhi ni nzu anabi grji kama too me nimi mir vayimbi. Bi woowu ni kpi wa ani tre yiwu nitu mba. ");
INSERT INTO jid_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Andi ko nah wa a kama bubu wotre anabi kima, ba gbron ba lhe penpenme ni mi mbru ndhi ");
INSERT INTO jid_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A toki, anabawa ba wawu rhi ni samuila nibi ye ni kogonba, ba tre nda d'bu lha vi biyi. ");
INSERT INTO jid_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bi mi anabawa mba ni shirjhi wa Irjhi a tiniba bacimbi, niwa a lha ni Ibrahim ndi, “Ni zuriya me nnedhi ni gbungblu wawu ba kpa lulu.” ");
INSERT INTO jid_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ni wa Irjhi a nzu ndi wunduma a tonye niyi guci, nitu du yo lulu niyiwu, ni du konhambi k'ma gon nu meme drimbi. ");
INSERT INTO jid_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Niwa ba Bitrus mba Yohana ba kia tre ni ndhi ba, ba prist ni kaptin bi yatsro ni haikalia ni ba saducis ba wru sru niha. ");
INSERT INTO jid_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sisiri ni nfu a vu ba nitu tsro wa ba Bitrus mba Yohana baa kia dibu ni bla nitu Yesu ni lundema rhi ni que. ");
INSERT INTO jid_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba vu ba nda njiba ka tro zi nrable ka tu yalu a tiye. ");
INSERT INTO jid_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ndhi gbugbuwu nimi biwa bawo tu tre, ba kpanyme, ndhi lilon wa ba kpatre chachu ki bana mla dubu ton. ");
INSERT INTO jid_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ni ble ma, bi ninkon wu gbu baba datibe ni kikle bi nha ba yo kpambe nde ye kuson ni Urishilima. ");
INSERT INTO jid_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas nkon prist wawu a he niki, mba Caiaphas u Yohana ni Alexandar niba mla nikon prist'a. ");
INSERT INTO jid_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba yo Bitrus mba Yohana ye zini tsutsumba nda mye ba ndi, “Ni gbengble koka ni nde nhamba bi ti kpeyi?” ");
INSERT INTO jid_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter a lu kri, shuni Ruhu tsatsra nda tre ni ndi ba. “Biyi bininko ya gbu baba datibe, ");
INSERT INTO jid_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","idan ki si bla tre ndi ni han tre ni tu kpe ndi ndi wa w ti ni ndhi wu lilo, mba kawa igua tinche ri nda kpa si kpama? ");
INSERT INTO jid_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Be ka mla to, wawu bi, ni ndi Israila wawu idu yi wa kri ni shishinbe risi kpa a nitu nde Yesu Kristi ba Nazarat, wandi bi gran wu har wowu ama Irjhi a nzu lunde baya wa a qu. ");
INSERT INTO jid_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu Kristi wa wuyi a bi tita wa bi kambi ni wu wa k'ma ti tita wu zontu mme'a. ");
INSERT INTO jid_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kpachuwo na la he ni nde ndiori nga nitu nde ri na la he ni gbugdu ko ni shulu wa ba no ndhi ri wandi a ni kpa ndi chuwo'a na. ");
INSERT INTO jid_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Niwa ba to tre u gbengblem suron Bitrus mba Yohana, mba nda mla to ndi bana bla tsro yi gbagban mu na kpe a nuba mamki, nitu ndi Bitrus mba Yohana ba mirko Yesu. ");
INSERT INTO jid_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nitu ba to igu wa a kpa si kpama a kri ni mimba, bana la he ni kpewa ba tre ba tre ngana. ");
INSERT INTO jid_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ba zu manzaniba du ba rhu dinko bawu ni meetiy nda k'ma ki tre ni kpamba. ");
INSERT INTO jid_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba tre ndi “Khi ti ndi biyi ne he?” ni kikle kpe yi wa ba ti, a kri ndendeme ni ko nha wa ani son ni Urishilima du to, kina kpatron na. ");
INSERT INTO jid_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama don du tre a na hi gbagbanmu du ndhi wo na, ki feba ton ni du bana la tre nda tsro ndhi ni ndeyi ngana.” ");
INSERT INTO jid_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mle ba yo ba ri nda mam ba ndu ba na tre ko tsro ndi memlemu ni nde Yesu na. ");
INSERT INTO jid_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","U ba Bitrus mba Yohana ba sa bawu ndi, “ka ani bi ni shishi Irjhi du ta hu tre mbi ko ka ko hu wu ma. ");
INSERT INTO jid_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","biyi kimbi, ga trea. “Kita kina donme ni bla kpe wa ki to ni shishi mbu, ni wo ni ton mbu na.” ");
INSERT INTO jid_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Niwwa ba mam ba Bitrus mba Yohana, ba chuba chuwo du ba hi kpamba. Ba wa kpewa ba vu ba lo han ma, domin ndhi ba wawu ba sita gbre Rji san nitu kpe, wa a ti'a. ");
INSERT INTO jid_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Igu wa a kpa si kpama ana zan ise arbain ni ngrhi. ");
INSERT INTO jid_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Niwa ba chuba chuwoa, Bitrus mba Yohana ba hi ndhi mba, nda ka bla kpe wa bi Ninkon prist baba datibe wawu ba lha ba wua. ");
INSERT INTO jid_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba wo naki da nzu lan mba nitu kpe riri ni Irjhi nda tre ndi, Baci, wu ti gbungblu shulu mba meme, mba teju ni kpi wa ba he ni mimba. ");
INSERT INTO jid_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wu tre ni Ruhu Tsatsra ni nyu vreko ndu me, timbu Dauda, 'A hi ngye du gbungblu bi ko ra ba gbra nfu u ndhi ba ba rhimre kpi wa bana he nituna?' ");
INSERT INTO jid_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wu tre ndi, “Bi chu wu gbungblu meme ba bitu mba ni buburiri, bi ninkon gbu agame ba zon tu mba nitu Baci, mba nitu kiristi ma ");
INSERT INTO jid_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Toki Hiridus mba Bilatus ba zontu baba ndhi bi kora ni ndhi bi Israila ni mi gbuyi, nitu tsatsra wunduma Yesu, wa wu sawo wu ni tuma. ");
INSERT INTO jid_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba zontu ni buburiri ni duba ti kpi wa a wume mba wa wu mla yo zi ndi du ka ye he toki ni shishi. ");
INSERT INTO jid_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Zizan, Baci, ya ni meme shirjhi mba ndi zo mirko ndume duba lha lantre me ni gbengble suron. ");
INSERT INTO jid_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nina wo me du no si kpanda tsro kpi wa bana zi he na ni nde tsatsra wundu me Yesu. ");
INSERT INTO jid_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Niwa ba kle bre'a bubu wa ba ki wawumbawu a lu grjhu u. Ruhu Tsatsra a ri ni kowani rimba, mle ba lu si tre lan tre Irjhi ni gbengblen suron. ");
INSERT INTO jid_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ikpa'a ndhi biwa ba kpanyme nda yo suron mba ni dri mba riri. ndio na tre ndi ikpe wa wu he niwu a hi wu ma ni nklemana, ba nji ko ngye ye bubu riri nda tindu niwu toki. ");
INSERT INTO jid_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ni kikle gbengblen manzaniba ba ki d'bu nda bla ikpiwa ba to nitu tas'me Baci Yesu, ni kikle k'ma sran wu son nitu mba wawu. ");
INSERT INTO jid_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ba ndhi ri nimimba wa a wakpe wandi a ni son'a hama, nitu biwa bana he ni ba Ithu ko ni ba ko ba vuba le nda nji nkle ye sru ni bubu riri, ");
INSERT INTO jid_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ni za manzaniba ndi duba ga ni ko nha tsra ni kpe wa ani son'a. ");
INSERT INTO jid_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu wa manzaniba bata you ndi Barnabas wandi bati k'ma sran ani vren wu igrhi Levi, ndhi wu Cyprus. ");
INSERT INTO jid_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a ban ngbran meme le nda nji nkle ye sa ni za manzaniba. ");
INSERT INTO jid_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ndhiri bayo ndi Ananias mba wama safira ba ban bubumba ri le. ");
INSERT INTO jid_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nda zi mbru nkle wa ba kpa`a (uwama ngame a to), nda nji mbru nkle ka zi ni za manzaniba. ");
INSERT INTO jid_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bitrus a tre ndi, “Ananias wu ti he ni du brij shusron me nda du, u tiche ni Ruhi Tsatsra ni kma mbru nkle bubua'a zi ni tume? ");
INSERT INTO jid_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Niwa wuna rhihe u banle'a ana wumena, u niwa wu banle ana rhihe ni wome na? A nha yo kpeyi ni suron me? wuna tiche ni ndhi na, ama ni irjhi”. ");
INSERT INTO jid_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Niwo tre`a Ananias a ku rhoku u veri ma ka klekle, u biwa ba wo kpe yi ba ti sisiri kpukopme. ");
INSERT INTO jid_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mri rize ba balu banwu cibi nda lo u nda ba u rhu ka rhu. ");
INSERT INTO jid_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Niwa nton tra (3) ati, uwama a riye, ana to ka ngye si grensi zren na. ");
INSERT INTO jid_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bitrus a tre niwu ndi, “Hla nitawu bi le ni bubumbi mba nitu kpe to yi?” A tre ndi “Ehh, nitu toki.” ");
INSERT INTO jid_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mle Bitrus alha niwu ndi, “Ahi ngyeti du yi zontu ni kpambi ndi tsra Ruhu Baci? , ya, za ndhi wa baka rhu lon me ba he ni kontra, ba banwu hi rhu.” ");
INSERT INTO jid_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A kri ku rhoku ni za ma nda gbron vri ma wu kle. Niwa mir nzeba ba ri ye nimi ba to a que nda banwu rhu ka rhu ni kosan bei lonma. ");
INSERT INTO jid_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","sisir rigra ma a ti eklisiya wawu ni biwa bawo kpi biyi”a. ");
INSERT INTO jid_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ikpi gbugbuwu wa bana taba to ni son ba na ni chu tro nkankan ba kiya faru ni cikin ndi tawuri mazani ba. Ba ki wawumba ni trankon solomon. ");
INSERT INTO jid_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mbru ndhi ba bana hini gbengble suron u huba hikina ama ndhiba ba to ba ni nfutu. ");
INSERT INTO jid_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nikima, ndhi ba ta ye nda ni kpa Bau; ndi lilon baba mba gbugbuwu. ");
INSERT INTO jid_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nda duba vu bi lilo thuka zi nitu nkon tu bubu kru ko ni bla krumba, ndi i dan Bitrus si zren zu, iwhi ma ni ku nitu bari mba. ");
INSERT INTO jid_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kpandhi ngame ba ye rhi ni gbu biwa ba ne we were ni urishilima, ni bi lilo baba biwa meme brjhi loba, ba kpa si kpa mba ");
INSERT INTO jid_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nikima, niko firist alu kri, ni wawu biwa ba heniwu'a (biwa ba he ni derika sadukiawa); ba shuni ngu, ");
INSERT INTO jid_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","nda yo wo vu manzani ba ka tro ni buba tro. “ ");
INSERT INTO jid_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nikimame, niwa chu ati malaika u Baci a bwunko wu bubu tro'a nda njiba rhu ra, nda tha bawu ndi ");
INSERT INTO jid_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Hi, kri nimi Haikali ni tre ndi ndhiba wawu nitu lantre wu nu vriji”. ");
INSERT INTO jid_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Niwa ba wo tre yi a, ba ri hi ni haikalia tsra ni bwunble nda tsroba. I a ninkon firt a ye baba biwa baheni wu'a nda yo son shubi bi ninkon gbu baba datibai ndhi bi Israila wawumba, nda tonba hi ni ko tre duba hi nii manzani ba ye. ");
INSERT INTO jid_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ofisa wa ba tonbarba hi ka waba hamani ko tro'a nda kima ye lha bawu. ");
INSERT INTO jid_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kika to nkotraba baki ni tro vrenme, ni bi ki gben ba ni kontra. Ama niwa ki bwu ni ri, kina to ndior nimi na. ");
INSERT INTO jid_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ni wo tre yi, captin wu haikalia mba ninko first wawu, ba ku sisiri nitu mba, don kpe wa ni wu gon ma. ");
INSERT INTO jid_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mle ndhiri a ye nda ye lha bawu ndi, “Ndhi wa bi vu sru ni ko tro ba kri si tero ndhi ni mi haikali.” ");
INSERT INTO jid_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kaptin babamir binduma ba wru hi nda ka vu ba ye, hama ni gbiba ni gbeneblen, nitu ba ti sisiri ko ndhi ba ta ba ni tita. ");
INSERT INTO jid_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Niwa ba njiba ye'a ba zi ba shishi bi ninkon'a, ");
INSERT INTO jid_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nikon first a tsra ba ni mye ndi, “ we mha yi ndife yi ton du yi na tsro ni nde yi na, ama bi ka gbu urishilima ni tsro mbi ndi nison nji yi guyi ye sa nitumbu.” ");
INSERT INTO jid_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bitrus baba manzaniba ba sa ndi, kita ki hu tre irjhi zan tre ndhi. ");
INSERT INTO jid_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Irjhi ba timbu a nzu Yesu hi, wandi bi klo wuu ni kunkro. ");
INSERT INTO jid_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Irjhi a nzu u hon hi ni woko ko rhima na uren u tuchu mba wu kpachuwo, don du buw kon tuba ni mir Israila, nda wru latre mba lhe. ");
INSERT INTO jid_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","kita ki biwa ki to kpibiyi, ni ruhu tsatsra ngame, wandi Irjhi a nu bi wa ba hu tre ma'a. ");
INSERT INTO jid_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Niwa, bi ninko wa ba son'a da trea nfu a toba, u bata son wuu manzani ba. ");
INSERT INTO jid_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama igu pharisawa ri wu nde ma hi Gamalial ndhi wu tsro doka, wandi ndhi wawu ba kpanyme ni wu'a, a lu kri ni minba nda ti gbuchu du manzani ba rhu dinko ni bawu wu ton fime ri. ");
INSERT INTO jid_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wa alu kri lha ni son ndi, “ndhi Israila, mal ya kpe wa bi tre bi ti ni ndhi biyi. ");
INSERT INTO jid_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kafi du vi biyi ye, Theudus a lu wru nda gbresan ndi wawu hi ndior, u ndhi bari, ba derinzia ba zontu hu. Ba wuu, duka biwa bata hu'a ba vra hi kankan ni zremba ngame a na ti tu na. ");
INSERT INTO jid_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bay ki ma u, Juda wu Galile a lu kri ni vi wa ba bla ndhi nda gbron bari baka hu. wawu ngame a que kado u biwa bata hu'a ba vera hi kan kan. ");
INSERT INTO jid_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Zizan mi lhayiwu, rhu ni nkon ndhi biyi di don ba toome, idan shiri yo ko ndu yi, hi wundi ana kri gban me na nda vralhe. ");
INSERT INTO jid_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Anita ndu Irjhi, bina iya yi nasara ni ba na bi klna to bisi tsi ni Irjhimu.” Toki ba kpanyme ni tre ma. ");
INSERT INTO jid_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mle ba yo manzaniba ri ni son nda lhobatsi nda hla ndi du ba na tre ni nde Yesu na, nda du ba hi kpamba. ");
INSERT INTO jid_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ba rhu rhi ni son bi ninko'a ni takpe don ba he ni mi biwa ba mla duba ti ba ya nitu ndema. ");
INSERT INTO jid_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hu kima, chachu, ni mi haikali mba ni ko hi ni ko, ba zi tsro ndani d'bu ni lha njo ndi Yesu wawuyi hi Kristi. ");
INSERT INTO jid_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Zizan ni vi biyi, wa mir ko bi hua, ba si ye ni bran Yahuda wa bi wo helenanci bi nji yiye nitu bi Ibrini yawaba, ahdi bana mla niya mmba be k'po ni zo wa ba yi bawu chachuna. ");
INSERT INTO jid_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","don ha'a ba yo kpaa mir ko ba nda tre ndi “Ana bi du ta ka tsro lan tre Irjhi chuwo ni k'ma ki ta ga biri na. ");
INSERT INTO jid_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nitu kima, bika chu, ndi tamgban (7) ni mimbi, indhi wa ndi ba kpanyme ni ba u ba he ni rhuhu mba mre wuto ndindi, ni chuba yo ni ndu yi. ");
INSERT INTO jid_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Anita um mbu, ki kri nitu bre mba ndu tsro lan tre Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","I tre mba a bi wo ni kpaandhi ba wawu. Niki ba chu Istifanus, ndhi wa a shu ni suron gbangban ni nkon Rjhi, mba ni Ruhu Tsatra, u Filibus, Prochorus, Nicanor, Timon, Pamenas, mba Nicolaus ndhi wu Antioch, wa a kpanyme n'dani hu Rjhi bibi wu Yahudawaba. ");
INSERT INTO jid_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bi wa ba kpanyme niwu'a ba nji ndhi biyi ye ni shishi ba manzaniba, u ba bre Rjhi nibawu nda sa wo ni tu mba. ");
INSERT INTO jid_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Niki u tre Rjhi a si bwu kagon U mir ko ni Urishilima ba si bran kpukpome. U Prist gbugbuu ba kpa trea nda hu ni gbengble suron. ");
INSERT INTO jid_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Zizan, Istifanus wa alheni mba gbengble ahe wu suron a si ti kikle kpi ni shishi ndhi ba. ");
INSERT INTO jid_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama Ndhi bari ba rhuki rhi ni haikali'a wa ba yo ndi Haikali wu bi wa ba chubachuwo, rhi ni Cyrenians mba Alexandrians, ni basi rhi ni Cilicia mba Asia. Ndhi biyi ba si a sen nyk ni Istifanus ");
INSERT INTO jid_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama bana to kri nda ti kpe zan iri hikima mba iri ruhu wa Istifanus tre'a na. Mle ba lunde le nyu bari ni du ba tre ndi. ");
INSERT INTO jid_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ki wo Istifanus a sia tre lan wu mmre Musa mba Rjhi”. ");
INSERT INTO jid_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba chon ndhiba, ni datibe, bahabi nha (Scribes) mle ba wa Istifanus hi nda jiwu ye ni bi niko ni tra sonmba. ");
INSERT INTO jid_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba nji bi che du ba lha ndi ba wa to ni shishinda wa ni tonmba kpiwa ba bla sa niwu'a. Ba tre ndi iguyi na donme ni tre lan meme nitu tsatsra bubuyi mba doka Rjhi na. ");
INSERT INTO jid_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nikima, ki wo-u a tre ndi Yesu wu Na'zarat yi, ani zi bubuyi, nda k'ma njo Musa wa a yo nda ka nuta duta ki hu'a sran. ");
INSERT INTO jid_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ko nha wa a son ni tra son bi ninko a sru shishi ni wu nda to shishima a k'ma rhu wu malaika. ");
INSERT INTO jid_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ninko Prist a tre ndi, “ikpi biyi ba janji?” ");
INSERT INTO jid_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanus a tre ndi “mir ya ni bati, wo me'. Irjhi wu shulu a tsro kpama ni timbu Ibrahim, niwa ana he ni Mesopotamia, ri nda ka son ni Haran; ");
INSERT INTO jid_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A lha wu ndi “Don ngbran meme me baba mir vayime, ni rhu hini ngbran meme wandi mi tsro wu. ");
INSERT INTO jid_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mle, a lu don ngran meme Chaldeans nda ka kru ni Haran, rhi niki, ni wa tima a qu'a, Irjh i a njiwu ye ni ngbran meme yi, wa bi ki nituma'a. ");
INSERT INTO jid_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ana fon nklan bubu nu du kpa zi ni h'pu mana, a'an, ko wa ani kaza satuma me. Ama, a shirhi, ko da shike Ibrahim ana he ni vivren rhina-andi ani nu bubu ti uma du mba h'puma du k'ma tiwumba kasai-kasai. ");
INSERT INTO jid_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Irjhi a si a tre niwu tyi, andi h'puma ba son ki ni gbu ndi bari u ndhi bi bgukima ba vu ba ti grand nda du ba tiya wu se derinzia (400). ");
INSERT INTO jid_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama mi sharanta ni dhi bi wa ba tindu gran nibawua, kpe wa irji tre'a hu gon kima, ba rhu don bubuki nda ye kuqungba rhu nda gbresan ni mu ni bubu yi. ");
INSERT INTO jid_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Niki Irji a nu Ibrahim shirhi wu hanbru ni duta tika, rhini kima, Ibrahim a ngrjhi Ishaku nda hanbru ma ni riwu tandra baya ngrjhi. Ishaku ngame a ngrjhi Yakubu, u Yakubu a ye ngrjhi bacimbu Wlondoha ba. ");
INSERT INTO jid_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bacimbu ba ti ngu ni Yusufu, ba banwu le hi ni masar ama Irjhi a he ni wu. ");
INSERT INTO jid_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nda kpa' chuwo ni ya wa a hon tuma'a. A kpayem ni Yusufu mba mren wu tondindi ni shishi kikle Ichu Firona wu Masar wa a ban wu sa ni ruron gomna wu Masar mba nitu koma wawu. ");
INSERT INTO jid_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ni ntukima, meme iyon a ri kagon Masar mba Canaan, ni meme ya wa a du ba timbu ba wa biri hamma. ");
INSERT INTO jid_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Niwa Yakubu a wo ndi wlo biri he ni Masar a ton ba timbu hi ni zrenmba wu mumla. ");
INSERT INTO jid_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ni zren wu ha, Yusufu a tsro tuma ni ba mirvayima, u firona a mla to mmla Yusufu nikima. ");
INSERT INTO jid_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu a ton mir vayima du ba k'ma hi hla ni timba du vu mmla wawu, ndhi saba'in don ton mba, nda ye ni Masar. ");
INSERT INTO jid_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nituki, Yakubu a grjhi hi ni Masar nda ka que niki, ni wawu ba timbu ngame. ");
INSERT INTO jid_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba vu ba hi ni Shekem, nda ka rhu'ba ni ibe wa titi Ibrahim a le nitu nkle silva ni wo mir Hamor wu Shekem. ");
INSERT INTO jid_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Niwa nton wa shirhi a ye weiweire, shirhi wa Irjhi a ti ni Ibrahim. Indhi ba ba ki bran gbugbuwu ni masar. ");
INSERT INTO jid_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Da a tsra wa kikle chu ri a hon ni ruron wu masar wa ana to njo nitu Yusufu na. ");
INSERT INTO jid_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A kyurh ndhimbu nda yo ba ni gbengble du ba rhuni mir nhanha lilon mbu ni duba que. ");
INSERT INTO jid_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ni nton kima ba ngrhi Musa, wa ka bi kpokpome ni Rji ba lura ti wua tra (3) ni ko tima. ");
INSERT INTO jid_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Niwa ba banwu ka zi ni ra, vrenwa Firona a ban'u ti wuma nda njiwu ti vren ma. ");
INSERT INTO jid_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba yo Musa ni bubu tsro mba, niki a mla to tsro ndindi nitu kpi kankan wu bi U bi masarawa ba, ndu ni he ma ba bi hikima. ");
INSERT INTO jid_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Niwa isema wu ngrjhi ba ti weiweire ni tso-tra-don nza (arbain), a kpre suron du zren hi ni mir vayi ma, ih'pu Isra'ila. ");
INSERT INTO jid_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A krito basi ndhi Israila ri ya'. Musa alu kpa nyu ni ndhi wa basia tiwu ya'a nda wru gu masar wuh. ");
INSERT INTO jid_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A yotrendi vayima ba mla to ndhi a hi Irjhimba ni tindu ni wu du ba bguc'bu ni womba, ama ba ka'a na mla to na. ");
INSERT INTO jid_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nivi wuhama, a to ndhi harhi ba si tsi, wa ay'e gaba nda tre ndhi, 'Lilon, be mir vayi; a hi ngye du yi ni tsi kpambi? ");
INSERT INTO jid_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Irimba wandi wa wuhi a kpa la ni kpanma'a, a tru yo kosan nda tre ndi “A nha banwu sa nitumbu ichu, wu ga tre nitawu? ");
INSERT INTO jid_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wu son wu U me to wandi wu wuu gu masra laren'a? ");
INSERT INTO jid_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Niwa Musa a tre yi'a, a vu tsu wru nda ka son tindi u tsir ni kasa Midian, niki a ka ngrjhi mri lon ha. ");
INSERT INTO jid_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Niwa ise tso-tsra-don-nzang ati ka hi, U malaika a tsro tuma niwu ni ngbranmiji ni kikle ngblu Sinai, ni lu ni miji. ");
INSERT INTO jid_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Niwa Musa a to ilu'a, a ti sisir kpe wa a to ni shishima, nda lu si zren hi weiweire du ni mla ya, a kri wo ilan Baci ni tre ndi, ");
INSERT INTO jid_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Mmyi mi Irjhi wu ba timbi, Irjhi wu Ibrahim, mba Ishaku, mba wu Yakubu” Musa kri si tsenzankpa nda na la vu suron nda ya ngana. ");
INSERT INTO jid_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Baci a lhawu ndi, jhu lagban wa ahe ni za me rhu domin bubu wa wu kri mba ahi tsatra bubu. ");
INSERT INTO jid_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi to iyawa basi nu ndhimu ni masra mi wo gran yimba, m'ba mi grjhiye ye chubachuwo. ye zizan, mi ton hi ni masra. ");
INSERT INTO jid_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa yi, wa bana kamba niwu, niwa bana tre ndi, “a nha yo tituchu mba wu ga'atre nitawu'a?” a hi wawuyi wa Irjhi a ton du hi ti chu mba wu chubachuwo. Irjhi a ton wu hi zuni wo malaika wa a tsro tuma ni Musa ni miji'a. ");
INSERT INTO jid_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa njiba rhuni masra, kima a hu gon ti kpi bi wa ndhi ba kaahon to tuma, baba bi tron yani masra mba kikle ma wu Reeds, mba ni tsutsu miji niwa ba ti se tsro-tra-don-nza (arbain). ");
INSERT INTO jid_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ahi Musa kima wa a lhani ndhi bi Israila ndi, “Irjhi ni nzu anabi ri hon yiwu rhinimi vahimbi, anabi ton me”. ");
INSERT INTO jid_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ndhi yi yi a he niba ni tsutsu miji mba malaika wa atre niwu nitu kikle ngblu Sinai, wa ahe niba timbu, mba wa a kpa lantre wu sisren ye nota. ");
INSERT INTO jid_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ama ba timbu ba kamba ni hutrema, ba tru lhega wru ni kpamba, du ni misuron mba k'ma hi ni masra. ");
INSERT INTO jid_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ni nton kima ba lha ni Hasuna, “La' mir rjhi ni tawu wa a ni njita zren hi. Musa yi, a njita wru rhini meme masra, kina toh ikpe wa a ka tiwu a na ");
INSERT INTO jid_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Niki ba la' vrenlando ni ri baki nda nji ba hadaya (ton?) ni gunki waba la'a, nda ngiri nitu ndu wu womba. ");
INSERT INTO jid_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Irjhi a kaba chuwo du ba boata ni tsitse ni shulu, tohwa bana nha ni mi vunvu wu ba anabawaba. “Bi gon nimu nma miji mba haday ni ise tso-tsra-don-nza wa bi na he ni tsutsu miji'a ko mri Isra'ila? ");
INSERT INTO jid_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bi kpa ka'che' molech mba ntse wu vi irjhi Rephan, mba whi ki ba biti ni du yi kugungbarhu ni nzub hon. Nikima, mi vu yi vra zan gbran Babylon. ");
INSERT INTO jid_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ba timbu bana he ni ka'che' wu kpewa ba to ni shishimba ni tsutsumiji, me wa Irjhi a noba niwa a tre ni Musa'a, andi du ti tsra ni wa a toa. ");
INSERT INTO jid_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hu kima, ba timbu ni wo Joshua ana njiba to ninkomba, ba kpa ka'achea nda njiwu hu kpamba niwa ba vu meme a kpa. Irjhi a kpa meme ni wo gbungblu bi bubuki nda zu ba wru ni shishi ba timbu. kaachea a son ni meme'a ye ni nton Dawuda. ");
INSERT INTO jid_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wa Irjhi a kpanyme ni wu nda lhawu ni du wa bubu son ni ko Yakubu. ");
INSERT INTO jid_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ana Suleimanu mba amme ko ni Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ama kitoh ndi kikle wushu na son ni ko wa wondhi mme na, toh wa anabawaba ba tre. ");
INSERT INTO jid_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Shulu mbahi bubu son tu chu mu, u meme mba hi kpran roro saza mu. A bibi ko rime wa bi mme ni mu inj Baci, ka a ngye bubu u kusi mu? ");
INSERT INTO jid_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ana womu mba ti kpi biyi wawu na? ");
INSERT INTO jid_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Biyi bi sen tu, biwa bana he kacia surona mba iton mba na, chachu bi kan bi ruhu tsatsra, bi ti to ba tumbi bana ti. ");
INSERT INTO jid_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ahi anabi rime wa ba timbu bana tibayana. Ba wuh anabawa wa ba wru guci ni ye ndi wa ba yo wu di 'Analatre na', u zizan biyiyi bibi le ni wu dini wu'u ngame. ");
INSERT INTO jid_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Biyi wa bi kpa doka wa malaika mba ba mla yowozi, ama bina kpa ti dun na. ");
INSERT INTO jid_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Niwa bi niko bawo kpi biyi wa ka ri ba ni suron baka tan nyren ni Istifanus. ");
INSERT INTO jid_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Don a shu ni Ruhu tsatsra, a nzu ya shulu nda toh dokaka Rji, nda to Yesu kri ni wo korhi wu Irjhi. ");
INSERT INTO jid_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanus a tre ndi. “Toh, mi si to ni shishimu, shulu bwu, U vren Ndhi a kri ni worhi wu Irjhi ");
INSERT INTO jid_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nitu ki, biwaba son ni tra son bi ninkoa ba ka tonmba, nda yo gro ni kikle lan, nda lu honwu nitu kpe riri. ");
INSERT INTO jid_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ba gbi'e wru ni mi gbu'a, nda ni ta ni tita. Bi wa ba toh zren kpeyi ba ju nklonba wu kora nda kazi ni za vrenze ri wa ndema a hi shawulu. ");
INSERT INTO jid_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Niwa basia ta Istifanus ni tita, a sia yo baci nda ni tre ndi “Baci Yesu, kpa viri mu. ");
INSERT INTO jid_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A kuqungbarhu nda yo ni kikle lan Baci, na vule nitu latre wa ba ti yi na” Niwa a tre kle, a ku rhoku kruna ");
INSERT INTO jid_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu a nyme ngame ni kwu ma, nitu ki nivi baki, kikle watu ni ya a vu Ekklisiya wa a he ni Urishilima, u biwa ba kpatre Rji nda nyme niwu, ba vra ga ni gbungblu wu Judea mba Samaria, nda don manzaniba meyen. ");
INSERT INTO jid_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ndhi bi hu ngyengre me ba ban Istifanus ka rhu nda son ndayi kpukpeme. ");
INSERT INTO jid_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama Shawulu a kri gbangban nda ni so kpa Ikklisiya meme. Ata ri ni ko niko nda gbi lilon baba mmba, nda tru ba sru niko u tro. ");
INSERT INTO jid_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na kima me biwa ba kpa nyeme nda vera hi kankan ba zren zita bla lan trea. ");
INSERT INTO jid_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus a grjhi hi ni kikle gbu wu Samaria ndaka d'bu bla nibawu nitu kristi. ");
INSERT INTO jid_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kpaandhi ba ki si sren ton ni tre wa Filibus a si bla'a, ni yo sron ni bubu riri, ba wowu nda toh kpi bi tsro-ya wa'a ti'a. ");
INSERT INTO jid_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Meme brji ba rhurhi ni mi ndhi gbugbuu wa ana hon son ni mimba, nda ni yi ni kri gro nikle lan, ndhi bi lilo chon gble, ndana zrenna ba kpa si kpamba. ");
INSERT INTO jid_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nituki ndhi bi gbuu'a ba ngri kpukpome. ");
INSERT INTO jid_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ni gbukima, ndhiri a he wandi ba yo ndema ndiSiman, wa ata tsro ka, nda ni kandhi tsi shishi nda gyur. Bi Samaria du ba baniwu ti ndriori ninkon. ");
INSERT INTO jid_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wawu ndhi bi Samaria, rhini bi tsitsa hi ni bi ninkon mba, bata sren ton niwu ndatre ndi “Gu yi a gbengblen irjhi wa ba yo Azangbengble” ");
INSERT INTO jid_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ba yo ton ni trema nitu wa rhi ni dedewa azi tsibashishi nidu ka'a wa a ta tsro ba. ");
INSERT INTO jid_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama niwa ba kpa tre wa Filibus a sia d'bu lha nitu tre ndindi wu Irji mba nde Yesu. Kristi, ba vu ba ti baptisma, lilon baba mmba wawumbawu. ");
INSERT INTO jid_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Siman ngame a kpanyme. Hu gon baptisma ma, a kha ta son zuni Filibus mu. Niwa a toh kpi bi tsro-ya baba kikle ndu wa a si'ahe, a bwu nguyo ni w'ho. ");
INSERT INTO jid_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Niwa manzani ba ni Urishilima ba wo ndi Samaria ba kpa lantre Irji, ba ton Bitrus mba Yonana hi ni ba. ");
INSERT INTO jid_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Niwa ba grjhiye, ba bre Rji ni bawu, ndi du ba kpa Ruhu Tsatsra. ");
INSERT INTO jid_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nitu, ye niton kima, Ruhu tsatsra na ri he wu grjhiri ni ba, bana kpa baptisma ni nde Bachi Yesu megen. ");
INSERT INTO jid_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mle Bitrus mba Yohana ba sa wo nitumba, U ba kpa ruhu tsatsra'a. ");
INSERT INTO jid_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Niwa Siman a to ndi ba nu Ruhu Tsatsra niwa ba manzani ba ba sawo nitumba, a chu nkle ni nuba. ");
INSERT INTO jid_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A tre ndi “Ne gbengle kima ngame, wandi mita sawo nitu ko nha, wa ka kpa Ruhu Tsatsra” ");
INSERT INTO jid_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama Bitrus a lha niwu ndi “Du nkle silva me qu timeme ni wu, nitu wu ya ndi wu iya kpa Kyauta Irji ni nklen. ");
INSERT INTO jid_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wuna he ni rabo ni kpeyina, don suron me na he bi ni irji na. ");
INSERT INTO jid_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nitu kima, U ka don meme dri me ndi bre Baci, nidu anita kpayeme ani wrulhe, meme kpe wa wuna yo suron ni wu'a. ");
INSERT INTO jid_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mi to ndi wu he ni mi ntson lo suron mba ni nkon meme. ");
INSERT INTO jid_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Siman k'ma sawu ndi “bre Bachi nimu, du ko kpe riri wa wu tre na hon nitumuna. ");
INSERT INTO jid_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Niwa ba bla kpe wa ba to'a nda tre lantre Bacia, Bitrus mba Yohanna ba k'ma ni hi Urishilima, nda zi bla trendindi ni kauyuka gbu bi Samaria. ");
INSERT INTO jid_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Zizan, malaika Baci a tre ni Filibus ndi “Lunde ndi hu nkon wa grjhi hi kogbo, wa a kru grjhi rhini Urishilima hi ni Gaza (Nkon yi hi ni hammada). ");
INSERT INTO jid_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A lunde nda ku nko hi. Nikima aka zontu ni guri, wa a rhini Ethiopia, dandandu wa wu kikle ma'aji u Candace Samariya wu Ethiopia. Wawu yi kpi bi yo suron wa'a bana he ni woma. Ana ye ni Urishilima nda ni ye hi sujada. ");
INSERT INTO jid_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A k'ma tahi nda son ni ng'ma wu hon ma nda sia karanta tre anabi Ishaya. ");
INSERT INTO jid_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ruhu Rji a lha ni Filibus ndi “hi ni bubu wa a hea, ni hi kri nha ni ng'ma hu henma”. ");
INSERT INTO jid_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Niki filibus a tsutsu hi niwa, nda wo a sia bla tre anabi Ishaya, nda mye “ka U mla to kpewa u si bla'a?”. ");
INSERT INTO jid_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wa a kri sa wu ndi, “Mi tihe hama ni du ndior ye tsro me?” A yo Filibus du hon hi ni wu niti ng'ma, nda hi kuson nha niwu. ");
INSERT INTO jid_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Zizan bubu vunvu wu lantre wa lgu Ethiopia a sia bla ana to yi, “Ba vu gbron si hi to nt'ma wa ba jiwu hi han, mba toh vivre nt'ma wa a kri ni gbamgbi ni mi biwa ba si le niwu'a niki ana bwu nyuma. ");
INSERT INTO jid_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ni mi yama, gatre wu janji ama iba ban meme no nha ni to bla nitu biwa baka rhurhini wu, hpu ma. Ba ban vrima rhurini meme. ");
INSERT INTO jid_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wame Dandaudu a mye Filibus ndi, “mi bre'u, hla mu, anabi si tre nitu nha? nitu kpamamu ka nitu ndiori kan? ");
INSERT INTO jid_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filibus a lu si tre, rhi ni lantre yi wu vunvu tre Rji nda bla ndidi tre nitu Yesu niwu. ");
INSERT INTO jid_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Niwa ba kihi ni nkon, ba ye tsra ni bubu ma ri'u Dandaudu a tre ndi “Toh, imma he yi, naye ni zuudu ti baptisma nimu na? ");
INSERT INTO jid_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Chiche vunvu bi sen wu bi ma, bana he ni ndan na. Filibus a tre ndi, “wuta kpanyeme ni suron me ki ti baptisma niwu “Dandaudu a k'ma sawu ndi mi kpanyme ndi Yesu Kristi a hi vren irji. ");
INSERT INTO jid_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Niki, dandaudu a du ngma kukri. Ba grjhi hi ni mi mma. Filibus mba dandauda, U Filibus a ti baptisma niwu. ");
INSERT INTO jid_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Niwa ba hon wru rhi ni mi mma'a, ruhu Rji a nzu Filibis hi kado, u dandaudu ana la too ngana, ama a vu nkoma si hi nda ngiri. ");
INSERT INTO jid_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus aka rhu kri ni azotus, nda zren zu ni gbungblu ki, nda ni d'bu bla tre ndidi ni gbu biki, har nda ka kri ni caesaria. ");
INSERT INTO jid_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ama shawulu, wa a si gbre que ni mri ko bi hu bacia, hi ni nikon firist ");
INSERT INTO jid_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nda ka mye'e du nhavunvu ni du njihi ni tra u bre ni Damascus, don anita katon biwa babi nko a, ni lilon ko mmba, ka vu ba lo njiye ni Urishilima. ");
INSERT INTO jid_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Niwa a si zren nihi, a ye weiweire ni Damascus ilu kpan a kri bwu kpan kawu, ilua rhi ni shului; ");
INSERT INTO jid_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","wa akurhoku hi meme nda wo ilan ni tre niwu ndi “Shawubu, shawulu, a ngye sa wu tsra me ni ya?” ");
INSERT INTO jid_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu, a sa ndi “wu nha, Baci?” U Baci a tre ndi “A hi me Yesu, wa wusi tsra me ni ya; ");
INSERT INTO jid_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ama lunde, ri hi ni mi gbu'a ba lha kpewa wutia niwu.” ");
INSERT INTO jid_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndhi wa basia zren ni shawulu, ba k'ma ki whie me, nda wo lan tre a, ama nda na toh ndioria. ");
INSERT INTO jid_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawulu alu ni meme'a nda niwa u shishi'a ti buwu ana toh kpe na, mle ba vuu njiriwo ri ni Damascus. ");
INSERT INTO jid_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A ti ri tra hamm'a ni to kpan, nda na rhi na nda na so na. ");
INSERT INTO jid_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nikima, nimi Damascus, vrekoma ri a he, wa ndema hi Ananiya. Baci a hlawu ni ra ndi “Ananiya”, A tre ndi “Igy mi he yi Bachi” ");
INSERT INTO jid_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Baci a lhawu ndi, “Lunde, nid hi ni kon wa ba yo ndi kritrime, ni ko Yahuda, myeba ndhi wu Tarsus ri wa ndema hi Shawulu, a si bre Rji. ");
INSERT INTO jid_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A toh ni ra' andi ndi ri nde Ananiya a si ye nda si sa wo ni wau ni tu don du to bubu ngari” ");
INSERT INTO jid_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ama Ananiya a sawu ndi “Baci, mi wo ni nyu ndhi gbugbu'u nitu gu yi, iri kpatimeme wa a ti tsatsra ndhime ni Urishilima. ");
INSERT INTO jid_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aye ni hugon wu niko firist du ye vu ko nha ni wayi wa ani yo ndeme'a lo”. ");
INSERT INTO jid_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama Baci a lhawu di “Hi, mi chuti kpewundu mi, ni du nji ndemu hi ni biwabana to me na, nibi niko tuchi, baba mir Israila. ");
INSERT INTO jid_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi tsro u du toh bibi ya wa aniti nitu ndema”. ");
INSERT INTO jid_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya a lu vunkon nda ka ri ni ko'a. Ni sawo nituma, a tre ndi “Vayi Shawulu, Bachi yesu, wa a tsro tuma niwu ni kon niwa wu sia ye'a, a tonme du kpa kpan yame mba ruhu tsratsra duri niwu”. ");
INSERT INTO jid_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Harime, ukperi to kpakpla ikle ba rhukulhe rhi ni shishi Shawulu, wa a kri kpa to Bulus a lu duba ti baptisma niwu. ");
INSERT INTO jid_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wa ari biri u gbegblenma a k'ma ye ni wu A son niba mirko bi hu'a ni Damascus wu bran vi. ");
INSERT INTO jid_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Rhiniki a lu si d'bu ni bla tre yesu nimi tra wu bre Baci, nda ni lha nd wawuyi a vren Rji. ");
INSERT INTO jid_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Biwa ba woowua ba bwunyu yo who nda tre ndi “Ana guyi wa vu biwa ba yo ndeyi ni Urushilima na? A ye ni wa vu balo njini nu nikon Firist. ");
INSERT INTO jid_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Gbegblen Shawulu asi bran nitu nitu nda kpa Yahudawa bi son ni Damascus k'ma chon nitu wa a du ndhi mla toh ndi Yesu a wawuyi hi Kristi ");
INSERT INTO jid_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Niwa ba kai vi gbugbu'u, yahudawa ba zontu ni wa nkon wa ba zu nda wuu'a. ");
INSERT INTO jid_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Shawulu a toh kpewa ba si son ti niwu. Ba ki si gben kikle nkontra gbua, ni rhi mba ni chun don duba wuu. ");
INSERT INTO jid_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amm Mirko bi hu'a ba ban'u ni chu, nda ka yo grji zu ni kpagonka gbu'a, ni mi sisen. ");
INSERT INTO jid_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Niwa a ye ri ni Urishilima, Shawulu anata ri nha ni mirko bi hu'a, ama wawu mba ba kluu, nda na kpanyme ndi wawu ngame a vrenko wuhu na. ");
INSERT INTO jid_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Amma Barnaba a ban u njihi ni manzaniba, nda lha bawu ndi Shawulu a to Bachi ni nkon u Baci a tre niwu. mba wa hi ni damascu, Shawulu a tre hamma ni sisiri ni nde Yesu. ");
INSERT INTO jid_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A he ni ba ri bi rhu kagon Urishilima. A sia tre ni gbegblen suron (Hamma ni sisiri) ni nde Baci yesu. ");
INSERT INTO jid_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nda sisenyu ni Yahudawa bi helenenci ama ba kia wa nko u wuu. ");
INSERT INTO jid_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Niwa mir vayiba ba mla wo kima, ba njiwu grhiye ni Kaisariya nda ka tru hi ni Tarsus. ");
INSERT INTO jid_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Niki, ikilisiya kagon wu Judiya, galili mba Samaria ba kpa sii nda si guci ni ndu mba ni mi zren u sisiri. baci, mba wu son piame wu ruhu tsatsra, Ikilisiya asi bran ni blamba. ");
INSERT INTO jid_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Naki, Bitrus a zrenzuni gbungblu kima wami a grjika ri ni tsatsra ndi bi Rji wa ba ki ni gbu Lidda. ");
INSERT INTO jid_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Niki a to guri wa bayo ndema ndi Iniyasu wandi azi kru nitu bla ma ti se tandra (8) nitu a heni lilo chan ngble. ");
INSERT INTO jid_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitrus a tre nimu ndi Iniyasu, yesu Kristi a chu lilo wru ni wu. Lukri ndi mla bla me ti” mle a lukri ni zande, ");
INSERT INTO jid_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","wawu ndhi bi son ni Lidda mba sorona ba toh yu'a nda k'ma ye ni Baci. ");
INSERT INTO jid_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ni gbu Ayafa vrenko wuhuri, wandi ndema hi Tabitha (wandi ba k'ma sran ndi Dorcas)” Iwayi a ta ti kpi bi ndidi nda ta zo bi ya' gbugbuu. ");
INSERT INTO jid_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A he ni vi baki, a ku kru kpa nda que niwa ba ngla kpama, ba ban'u ka yo ni tra wu koshu. ");
INSERT INTO jid_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda a he weiweire ni yafa mir ko ba bana wo nda Bitrus he niki, ba ton ndhi ha ni wu, nda ni breu “ ye nita gbagbla. ");
INSERT INTO jid_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bitrus alunde huba. Niwa a ye ri'a ba njiwu hi ni tra wu koshu'a, u mmba be k'bo ba baki whi niwu nda si yi, nda ni tsro gbawrunklon baba zeni wa Dorcas a wran bawu niwa a he niba'a. ");
INSERT INTO jid_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus a dubarhu dinko ni tra'a, nda kuqugbarhu nda bre, nda k'ma ya ikmoa nda tre ndi, “Tabitha, Lunde” wa kri bwu shshi nda to Bitrus, nda luson. ");
INSERT INTO jid_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus a n'me wo nuu nda azu hon zi zande, nda niwa a yo tsatsra ndhi bi Rjiba ye baba mmba bi k'bea, a kau naba ni sisren. ");
INSERT INTO jid_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kagon yafa ikpe yi a zren kagon, ndahi gbugbuu ba kpanyme ni Baci. ");
INSERT INTO jid_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nituki Bitrus a son vi gbugbuu ni yafa, ni gu ri wa ba yo nde ma ndi Siman, wu tindu ntani. ");
INSERT INTO jid_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nikima, ndji ri a he nimi gbu Kaisairiya, wa nde ma hi Koneliyus, ana ninkon soja derhi ri, wa ba ta yo ndi Regiment wu Italiya. ");
INSERT INTO jid_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ana ndji wa towu, wa ata klu sissri Irji baba bi ko ma wawu, nda ta nu ndji biya zaka ma, nda ni bre Iri chachu. ");
INSERT INTO jid_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mla ni nton wu tya wu irhi, a mla to ni ra Maleka Irji si'a grji si ye niwu. Maleka a hla niwu ndi, “Cornelius!” ");
INSERT INTO jid_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius a nzu ya Maleka u sissri a vu wa a lu tre ndi, “Wayi hi ngye, ninkon mu?” Maleka a hlawu ndi, “Bre me mba zaka me ba hon hi ni ton mren ndindi ni shishi Irji. ");
INSERT INTO jid_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Zizan ton ndji me bari hi ni gbu Joppa du ba hi yo ndji wa ba yo ndema ndi Bitrus, du wuba ye niwa. ");
INSERT INTO jid_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ani son ni ndji wu tindu ntan wa ba yo ndi Siman, wa ikoma he ni nyu kpama teku'a ");
INSERT INTO jid_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Niwa Maleka wa tre niwu a hi kpama, Cornelius a yo mri ko ma harhi mba soja ri wa ani toh wo tre ma'a. ");
INSERT INTO jid_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelius a hla bawu wawu kpewa a si zren niwu'a nda ton ba hi ni Joppa. ");
INSERT INTO jid_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Zizan ni nton wu tanne wa ahuri kima, ba sia zren ni ti weiwiere ni mi gbu, Bitrus a hon hi kasi bre ni ko tu nka. ");
INSERT INTO jid_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","E iyon a vu wa aluta wa ikpe wu rhi, ama niwa ndji ba basia sron biri, a si toh tsro too ra, ");
INSERT INTO jid_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","wa atoh shulu bwu, nda toh nklan kpe si grji, ikpe a rju ngma ibla wa asi grji ni ye ni meme, wa ba vuu nji ni ton nza ma nda siwu si grji. ");
INSERT INTO jid_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ni mi ma innma kanka wu mriza nza baba biwa ba nnha ni meme, baba chinche bi bwa ni shulu. ");
INSERT INTO jid_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","E lan ri a tre niwu ndi, “Lukri Bitrus, wuu ni tan.” ");
INSERT INTO jid_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bitrus a tre ndi “Ana to ki na, Bachi; Rjhimu, mina tan kpe wa a he ni rjhina nda na kpanya ni shishi Irji na. ");
INSERT INTO jid_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ama ilan ala kma tre niwu nkpuwu ha ngari ndi “Kpe wa Irji ngla ti sa'a, na yo ndi a he ni Irji na.” ");
INSERT INTO jid_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Niwa kpeyi ari si kpa Bitrus tsi shishi nitu ko ka a hi ngye tu kpe wa a toh nimi ra ma, niki, har hi, ndji wa Cornelius a ton ba'a ba ye ki ni nyu kikle nkontra nitu bana mye u ba tsro ba nkon wa ba hu zu ye ni ko'a. ");
INSERT INTO jid_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba d'bu yo nda mye ka Siman, wa ba yo ndi Bitrus ngame, ni son niki. ");
INSERT INTO jid_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Niwa Bitrus a rhisi rhimren nitu ra wa ato'a, Ruhu a hlawu ndi, “Toomba, ndji tra asi waw/chiche nha nvunvu bi sen bari ba nha andi/ndji haarhi basi waw. ");
INSERT INTO jid_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lu grji huba hi, na ti ngri ni huba na, nitu a hi me mi tonba.” ");
INSERT INTO jid_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nikima, Bitrus a grji hi ni ndji ba nda tre ndi, “A hi meyi wa bisi wa'a. A ngye njiyi ye?” ");
INSERT INTO jid_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba tre ndi, kikle soja wu ya ndji derhi ri (100) wa ba yo ndema ndi Cornelius, ndji wu tsatsra zren, nda ni ti sissri Irji, wa ndji Yahudawa ni gbungblu wawu ba tre ndindi nitu ma, Maleka Irji a nji tre rhi ni Irji niwu ndi du ton ba hi yoo hi ni koma, nitu du wo tre wa a toon niwu. ");
INSERT INTO jid_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Niki Bitrus a yoba ri ye niwu. Niwa ble nhran, a lu huba, baba mri vayi bari wa ba ka ngo ni bawu hi ni Joppa. ");
INSERT INTO jid_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nivi wa a hukima, ba ye ri ni Caesarea. Cornelius a sia gbanba, ana yo mlama baba kpukpan bi weiweire du ba ye zon tu ki. ");
INSERT INTO jid_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A he niwa Bitrus a ri'a, Cornelius a rju ye too nda kri kukru ni gbarhu ma ni meme nda ni nzuhon. ");
INSERT INTO jid_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Bitrus a tiwo nzu lu nda tre ndi, “Lunde kri! Mi ndji too wu.” ");
INSERT INTO jid_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Niwa Bitrus si tre niwu, a ri hi ka to ndji gbugbuwu ba zontu ki si gben. ");
INSERT INTO jid_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A tre niba ndi, “Biyi me bita ndi ana he nitu nkon du ndji wu Yahudawa du zontu nitu kpe mba du zren tsri hini bi kora na. Ama Irji tsro me ndi du mina yo ndrjo ndi a vu meme rjhi wa a kpaa ti meme wawu na. ");
INSERT INTO jid_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kimayi sa dume grji ye hamma ni sen nyu, niwa wu ton ba ye yome'a, zizan mi myeu, a ngye du wu yome?” ");
INSERT INTO jid_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius a tre ndi, ivi nza wa ki kaba yo gon ye ni ton towa, mi sia bre Irji ni nton wu tiya (9) ni komu, mle mi toh ndji ri a wrhu kri ni shishi mu, ni nklon ma wa asia zan. ");
INSERT INTO jid_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","A hla nimu ndi, Cornelius, Irji wo bre me, e sadaka me a du Rji tika niwuu. ");
INSERT INTO jid_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nikima, ton ndji ri hi ni Joppa, nda hi yo ndji wa ba yo ndema ndi Sima, wa ba yoo Bitrus. A ni son ni ko ndji wu tindu ntan wa ba yondi Siman, weiweire ni kpa teku'a. / Chiche vunvu bi sen bari ba sa nha ndi / Anita ye, a ni tre niwu./ ");
INSERT INTO jid_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mle, hama ni ti ngri, mi ton ba ka yo. Abi wa wuye'a zizan, wawu umbu khiki ni shishi Irji ni duta wo wawu kpe wa Bachi ton du ye hla tawu'a,” /Hamma ni tre ndi / Bachi a tru du ye tre / chiche vunvu bi sen bari ba yondi / Irji a tru du ye hla ndi /. ");
INSERT INTO jid_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Niki Bitrus a bwu nyu ma nda tre ndi, Njanji, miti too ndi Irji na chutinkan na. ");
INSERT INTO jid_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nitu ki, ni gbungblu wa konha rhi, ndji wa ani ti sissri ma nda ni hu nkon tsatsra ndindi, ani kpaw. ");
INSERT INTO jid_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bi to tre ma wa a ton hi ni ndji bi Israila, niwa a bwu hla ndindi tre nitu son pian wa a ye zu ni Yesu Kristi, wandi wawu yi hi Bachi nitu ko nha - ");
INSERT INTO jid_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","biyi kimbi bi toh kpi wa ba zren kagon Judiya wawu, rhi ni Galili wa a hu gon batisma wa Yohana a guchi bwu tsro; ");
INSERT INTO jid_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ikpe wa a zren nitu Yesu ba Nazaret, niwa Irji a chu tinka ni lulu Ruhu Tsatsra mba gbengble. A zren si ti kpi bi ndindi nda ni nu sikpa ni biwa brjhi a vu ba lo'a, nitu Irji a he niwu. ");
INSERT INTO jid_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ki biwa ki to zren kpi biyi ni shishi mbu, kpi wa Yesu ati, ni gbungblu Yahudawa mba ni Urushelima. Ba klo wuu ni tu kunkro, ");
INSERT INTO jid_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ama Irji a nzulu ni vi wu tra nda du ba toou, ");
INSERT INTO jid_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ana ndji wawu na, ama ni biwa Irji ana mla guchi chu ni mi biwa bana toh ni shishi mba, ni mi mbu wa ki ri ni so niwu, hu lunde ni qu. ");
INSERT INTO jid_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A yo tre gbangban ni tawu ni du ta dbu hla ni ndji ni mla hla ndi wawuyi Irji chuu du ga tre ni bi vri mba biwa ba qu ye. ");
INSERT INTO jid_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ahi ni wawuhi, anabi wawu ba vu bla, ni du ko nha wa a kpanyeme niwu ani kpa wruhle latre ma ni nde Ma.” ");
INSERT INTO jid_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Niwa Bitrus a risi tre kpi biyi, Ruhu Tsatsra a ku nhi tu wawumba, wa basia sren ton ni tre ma. ");
INSERT INTO jid_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ndji biwa bana he ni igrjhi bi hanbru ni mi bi wa kpanyme, wawu ndji wa ba hu gon Bitrus ye'a, ba bwu nyu yo hwo, nitu wa ruhu Tsatsra a ku kra nitu bi kora ngame. ");
INSERT INTO jid_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ba wo bi kora ba basia tre ni lmen kanka nda ni nzu nde Irji hon. Niki, Bitrus a kma sa ndi, ");
INSERT INTO jid_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“A nha ni zu du ndji biyi du ba kpa batisma wu ma, ndji biyi wa ba kpa Ruhu Tsatsra ye too kita ngame'a? ");
INSERT INTO jid_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mle a yo tre ni gbangban nitu duba ti batisma ni bawu ni nde Yesu Kristi. Hu kima, ba bre du son wu vi fon bran ni ba. ");
INSERT INTO jid_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Zizan manzani ba, baba mri vayi wa bana he Yahudiya ba wo ndi bi kora ba ngame ba kpa lantre Rji. ");
INSERT INTO jid_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Niwa Bitrus a hon ye rhi ni Urushelima, biwa ba he ni grjhi bi hanbru'a ba tre ba; ");
INSERT INTO jid_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nda tre ndi, wuka zontu ni biwa bana hanbru na, ndi rhi ni ba! ");
INSERT INTO jid_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ama Bitrus alu kri mla bla kpi ba ni bawu ndi, ");
INSERT INTO jid_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Mi sia bre ni mi gbu Joppa, u Mi kri hra too ra, toh ekpe si grjhi ye, a rjuto kikle nk'ma bla wa basii chuwo si grji rji ni shulu, ba vuu nji ni nton nza ma. A grji ye ni me. ");
INSERT INTO jid_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi ya'u nzrime ni rhimre nitu ma, Mi toh n'ma rju bi gbungblu meme, bi zren ni za nza, meme bi ki ni tsutsu miji, bi nha ni meme baba nchinche bi shulu. ");
INSERT INTO jid_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mle mi wo lan tre nda hla nimu ndi, “Lu kri, Bitrus, wuu ndi tan!” ");
INSERT INTO jid_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mi tre ndi, “Ana toki na, Bachi, nitu ni son mu, meme kpe wu kpa ti meme na ri ninyumu na.” ");
INSERT INTO jid_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ama ilan a k'ma sa nimu rji ni shulu ndi, 'Ekpe wa Irji k'ma ti sa'a, wuna yo ndi a ti rji na. ");
INSERT INTO jid_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ikpe yi a zren ti nkpu tra, mle ba gbron k'ma hon hi ni shulu. ");
INSERT INTO jid_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bika mla toh, niki, ndji tra ba kri wruki ni kontra ko wa kina he nimi'a; ba ton ba ye nime rji ni Caesarea. ");
INSERT INTO jid_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruhu a tre gbangban nime du mi huba hi, ni du mi na yaba ti nkan na. Mri vayi tanne biyi ba hume, u ki rihi nimiko igu'a. ");
INSERT INTO jid_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A vu bla ni tawu nitu wa a toh Maleka a kri ni koma nda hla wu ndi, “Ton ndji me hi ni Joppa du ba hi nji Siman ye, wa ba yo ndi Bitrus. ");
INSERT INTO jid_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ani tre niyi nitu lan tre wa ani kpayi chuwo, iwu baba bi kome! ");
INSERT INTO jid_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Niwa mi guchi si tre ni ba, Ruhu Tsatsra a kuni tumba, tsra ni wa a ku nita ni mumla'a. ");
INSERT INTO jid_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mi tika ni lan tre Bachi, niwa a tre ndi “Yohana a tie batisma ni mma, ama biyi bi kpa batisma wu Ruhu Tsatsra.” ");
INSERT INTO jid_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Niki, Irji nita nuba kpe tsra niwa a nuta hamma ni du ta han, niwa ki kpanyme ni Bachi Yesu Kristi, me mi nha, wa mi kri sen nyu ni Irji? ");
INSERT INTO jid_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Niwa ba wo kpi biyi, bana sa tre ni tuma ngana, ama nda nzu nde Irji hon nda tre ndi, “Irji niu kma sron sran vri ni biwa ba bi kora'a ngame.” ");
INSERT INTO jid_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Zizan, biwa bana vra nitu iya wa a rirhi ni tu Istifanus, ba zren gbangban ka ri ni Phoenicia, Cyprus mba Antioch, ndani bla lan tre ni Yahudawa ba megen. ");
INSERT INTO jid_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama bari mba, ndji bi Cyprus mba Cyrene ba ye ni Antioch nda bla ni biwa ba Greek ngame, ndani d'bu ni bau, tre ndindi nitu Bachi Yesu. ");
INSERT INTO jid_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Iwo Bachi a he niba, gbugbu ndji ba kpanyme nda k'ma ye ni Bachi. ");
INSERT INTO jid_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Itre ni tu mba aka ku ni ton ekklisiya ni Urushelima, u baka ton Barnabas du rju zren gbagban mu ka ri ni Antioch. ");
INSERT INTO jid_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Niwa a ye nda toh ti ndindi wu Irji, a ngri nda nronba duba kri ngbangba ni Bachi ni suron mba riri. ");
INSERT INTO jid_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nitu ana ndji wu ndindi suron, shuni Ruhu Tsatsra mba suron kri ngbangban, u ndji gbugbu ba ka nhani Bachi. ");
INSERT INTO jid_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas alu wruhi Tarsus nitu hi wa to Shawulu. ");
INSERT INTO jid_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Niwa a too'a, a njiwu ye ni Antioch, Aye heme ndi ba ki ni ekklisiya wu seri wawu, nda du ba gbrontu yo bubu riri nda zita tsro ndji gbugbu'u. A he ni Antioch mba ba guchi yo mri ko bi hu; a ndi Krista. ");
INSERT INTO jid_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Zizan ni vi biyi, anabawa bari ba grji ye ni Antioch, rji ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iri mba, ni nde Agabus, a lu kri, ni chon Ruhu Tsatsra, nda tre ndi mem yon ni ye ku ni ngbran meme wawu. Ekpe a ye he toki ni ba vi wu Claudius. ");
INSERT INTO jid_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nikima, mri ko bi hu'a, tsra ni gbengblen ma, ba zontu nda tru izo mba hi ni mri vayi wa ba he ni Judiya. ");
INSERT INTO jid_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba tie kpeyi, nda tru nklen hi ni bi ninkon'a zu jni wo Barnabas mba Shawulu. ");
INSERT INTO jid_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Zizan, wieiweire ni nton wa Herod, kikle chu'a a saa wo nitu biwa ba bi ikklissiya ba, nitu du vu ba tiiya. ");
INSERT INTO jid_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A wuu Yakubu vayi Yohana ni Takobi. ");
INSERT INTO jid_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hu gon wa ato ndi kima a biya ni Yahudawa ba, a hon hi ka vu Bitrus ngame. Kima a he ni ba vi wu bredi wandi ba klan hamma ni du sa nda en na. ");
INSERT INTO jid_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Niwa a vuulo'a, a njiwu ka tro ni kotro, ni wo sojoji nklan nza du ba mla ya; a ta son ndji wa ani njiwu rjuye nu ndji hu kle igan-u nigra. ");
INSERT INTO jid_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Toki, ba tro Bitrus zi ni tra tro, ama biwa ba bi ekklisiya ba kri gbangban ni bre Irji ni tu ma. ");
INSERT INTO jid_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nichu wa mble ka nhran hu'a, Herod anata chu rjuye duba bla tre nituma, Bitrus a sia kruna ni tsutsu sojoji harhi, nimi lo ni sraka harhi, ni bi gben ni nyu nkontra ni duba mla ta ya nkontra'a. ");
INSERT INTO jid_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mle, Maleka Bachi a lu kri tanwrhu, ikpan lu ri nda kri bwu tra wu ko tro'a, ndu ku wrhu Bitrus ni kosan nda ta'u sh'me ni nna'a nda hlawu ndi, “Lukri gbagbla,” u sraka'a ba ju kuhle rjini woma. ");
INSERT INTO jid_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Maleka a hlawu ndi, “Lo kpame ni vu lagban wu zame sru.” Bitrus a tie toki. Maleka a hlawu ndi “Vu nklon me wu kora'a sru ni hume.” ");
INSERT INTO jid_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Niki, Bitrus a hu Maleka zren rju. Ana to ndi kpe wa Maleka a tia a hi njanji na. A tre ndi a si toh ni raa mu. ");
INSERT INTO jid_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Niwa ba zren ka vu y'ba bi gben bi mumla, mba wu ha, nda ye ni kikle nkon karfe wu ri ni gbu'a, a bwu kikima ni bawu. Ba rju grji hu nkon wu mi gbu'a, u Maleka a kri kaado. ");
INSERT INTO jid_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Niwa mren Bitrus a k'ma ye niwu, a tre ndi, “Zizan, mi mla toh wu njanji ndi Bachi yi a ton Maleka ni du ye kpame chuwo ni wo Hiridus, mba wawu kpi wa Yahudawa ba bata yo shishi ndi ba toh.” ");
INSERT INTO jid_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ni mla to toki, a zren hi ni ko Maryamu iyi Yohana, wa ba yo ndi Markus ngame, niki ndji gbugbuwu bana zontu ki si bre Irji. ");
INSERT INTO jid_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Niwa a wrunkon wu kikle nkotra u ri ni ko'a, vivren wa wu ndu ni ko'a, wa ndema hi Ruda a ye nitu du ye kpa yo'a. ");
INSERT INTO jid_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Niwa a wo lan Bitrus nda to ndi a yi wawuyi, nitu ngyiri ana bwu nkon a na nda tsutsu ri hi nimi ko'a, nda ka hla bawu ndi Bitrus kri ni nyu nkontra wu kora. ");
INSERT INTO jid_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba kri hlawu ndi, “Wu sran.” Ama a kri gbangban nitu a hi njanji. Ba tre ndi, “A hi ibrji ma. ");
INSERT INTO jid_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ama Bitrus ana donme ni wrunko'a na, ni bwu nko mba, ba too nda kri bwunyu yo ni h'yo. ");
INSERT INTO jid_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitrus a ti ba niwo duba son gbangbi, nda bla bawu nitu wa Bachi a njiwu rju ni kotro. A tre ndi, ton ba hi ni Yakubu baba mbru mri vayi ba nitu kpeyi. Mle a lu don ba nda zren hi ni buburi nkan. ");
INSERT INTO jid_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Niwa mble a nhra, ana tsitu fime wa a ri ni mi sojoji ba na nitu ka ahi ngye ti Bitrus. ");
INSERT INTO jid_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hu wa Hiridus a wa nda na too na, a mye bi gben ba nda yo ba ni duba wu ba. Hu ki, a grji rji ni Judiya hi ni Caesarea nda ka son niki. ");
INSERT INTO jid_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Zizan Hiridus a shu ni nfu ni ndji bi Tyre mba Sidon. Ba hi niwu nitu kpe riri, nda weire Blastus, wa ani zo ninkon chu'a ndu, andi du yo nyu zoba, ba mye ndi duba ki ni sikpe ni gbungblu meme wu nikon chu'a. ");
INSERT INTO jid_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ni vi wa ba yo'a, Hiridus a sru nklon ma u bi chu nda son ni ruron wu tu chuma, nda lu tre ni ba. ");
INSERT INTO jid_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ndji ba ba kpagro ndi, “Wayi hi lan Irji ana wu ndji na!” ");
INSERT INTO jid_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hari me, Maleka Bachi a kri yo wru, nitu ana nu Irji ninkon na; ntson mra ba kri rhiwu wuu. ");
INSERT INTO jid_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ama lantre Irji a si bwu bran ndani krigbu. ");
INSERT INTO jid_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Niki, niwa Barnabas mba Shawulu ba kle ndu zren mba, ba k'ma zren rji ni Urishelima, nda nji nha niba Yohana, wa ba yo ndi Markus ");
INSERT INTO jid_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Zizan ni Ekklisiya wu Antioch, Anabawa baba bi tsro bari bana he. Bana ba BArnabas, Siman (wa ba yondi Niger), Lucius wu Cyrene, Manaen (vayi Herod wu retrarch wa bana kpa'u nji toh wu ngrji hi mba), mba Shawulu. ");
INSERT INTO jid_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Niwa basia bre ni kaa rhi kpe nda ni nzu Bachi hon, Ruhu Tsatsra a tre ndi, “Chuu ba Barnabas mba Shawulu zi tinkan nimu, ni duba ti ndu wa mi yoba duba ti.” ");
INSERT INTO jid_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hu bre ni kaarhibiri, mba yo woh ni tumba, ba tru ba yo ni duba hi. ");
INSERT INTO jid_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kima, Barnaba mba Shawulu, niwa Ruhu Tsatsra a ton ba rjuhi'a, ba grji hi Seleucia; rhiniki ba wu jrigi mma hini Cyprus. ");
INSERT INTO jid_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Niwa ba he ni gbu Salamis, ba d'bu bla lantre Irji nimi ko Synagogues wu Yahudawa. Yohana ngame a he niba toh wu zoba. ");
INSERT INTO jid_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Niwa ba zren kaagon nclan meme gbungblu kima hi ni Paphos, ba ka tsra ni ndji wu katibrji ri ndi Yahudi wa ana anabi wu che, wa ndema ana Bar Yesu. ");
INSERT INTO jid_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ndji wu katibrji ana ta zren zontu ni kikle ndji wu gaatre, Sergius Paulus, wa aheni mre toh kpe kpukpome. Igu yi a yoye ni kpama, ba Barnabas mba Shawulu, nitu a nison wo lantre Irji. ");
INSERT INTO jid_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama Elymas “Wu katibrji” (toki ba k'ma ndema sran) a lu kri sen nyu wu ka kpanyme niba; a ta son k'ma kikle Iguwu gaatre rju ni nkon kpanyme'a. ");
INSERT INTO jid_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Niki Shawulu, wandi bata yondi Bulus ngame, shuni Ruhu Tsatsra, a yo shishi yau gbahme ");
INSERT INTO jid_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nda tre ndi, Iwu vren brji, wu shuni kpi kankan wu gyru mba meme dri. Wu kame ni ko ngye wa a he ni nkon tsatsra'a. Wuna don me ni k'ma sran nkon triime wu Bachi, ka ana naki na? ");
INSERT INTO jid_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Zizan ya, Iwoh Bachi a he ni tume, wu k'mati ndji wu mfyen. Wuna toh kpanrhi wu nton bari na.” Hihari niki, ikpe too iwru mba bwu a ku nitu Elymas; wa dusi zren ni kaagon siwa nji duba vu ni wo tsro nkon. ");
INSERT INTO jid_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Huwa kikle wu gaatre a toh kpewa a zren'a, a kpanyme, nitu tre wu Bachi wa a wo'a, a nuu rhimre ni sissri. ");
INSERT INTO jid_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Zizan Bulus baba kpukpan ma ba ba wru zren hu ni nokn maa rjini Paphos nda ka rini Perga wu Pamphylia. Ama Yohana a kaba don nda k'ma hi ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bulus baba kpukpan ma ba zren rhi ni Perga nda ka rini Antioch wu Pisidia. Niki bahi ka rini Synagogue chachu Sati nda ka kuson. ");
INSERT INTO jid_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hu, vu bla nha wu doka mba wu ba anabawa ba, bi ninkon wu Synagogue ba ton ba ni tre ndi, “Mri vayi, bita he ni tre wu nron ni ndji biyi, bika hla.” ");
INSERT INTO jid_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Niki Bulus a lu kri nda nzuwo tibawu nda tre ndi, “Ndji bi Israila baba biyi wa bi klu Irji, woo yi. ");
INSERT INTO jid_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Irji wu ndji bi Israila yi a chu ba bachimbu nda du ndji ba bran ti gbu, niwa bana ki meme Egypt, mba ni woma waa nzu hon, a nji ba rju nikima. ");
INSERT INTO jid_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ni nton mla ise tso-tra-don-nza (40) a tiya nji ba nimi gbungblu tsutsu miji. / Vunvu nha bi sen bari ba yo ndi / Wu ise mla tso-tra-don-nza asi mlabaya nji ni gbungblu tsutsu miji. / ");
INSERT INTO jid_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Hu gon wa a yra gbungblu ndji tangban wa bana he ni meme Canaan'a, a ban meme mba nu ndji mbu ni du k'ma ti umba. ");
INSERT INTO jid_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ikpe biyi ba rhuhe toki zan se 450 wa baka hi ye. Hu gon kpi biyi, Irji a nuba bi gaatre ka tsra ni nton anabi Samuel. ");
INSERT INTO jid_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mle ndji ba ba mye ndi du nuba chu, u Irji a nuba Shawulu vren Kish, ndji wu grijhi Benjamin, ni du hon ti chu nitumba wu se tso-tra-don-nza. ");
INSERT INTO jid_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hu kima, Irji a churhu ni tuchu'a, nda nzu Dauda hon ni du k'ma he chumba. Ana Dauda yi wa Irji a hla tre ni tuma ndi, “Ngye mi ye toh Dauda vren Jesse a hi ndji wa ani hu sron mu, wa ani ti wawu kpiwa Mison ni du ti. ");
INSERT INTO jid_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Rhini h'pu iguhi Irji njiye ni Israila ndji wu kpachuwo, Yesu wa ana shirji ni tu a ni ti toki. ");
INSERT INTO jid_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Niwa Yesu a rhihe ye, Yohana a d'bu batisma wu k'ma sron sran ni ndji bi Israila wawu. ");
INSERT INTO jid_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Niwa a ta kle ndu ma, a tre ndi 'Bi rhimre ndi me mi nha?' Me, Mina wawuyi na. Ama srenton, iri ni ye hu gon mu, lagban za ma me mina mlakri wa mi siwuna. ");
INSERT INTO jid_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mri vayi, mri wu iyi Ibrahim, baba biwa ba he nimi mbi wa ba klu Irji, ahi ni tawuyi mba ba ton tre wu kpachuwu yi ye. ");
INSERT INTO jid_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ni ndji biwa ba ki ni Urushelima, baba bi tuchu mba, bana mla too na nda du lantre ba anabawa wa ba ta bla chachu ni vi wu Sati'a, a hon tumba niwa ba kaamba niwu. ");
INSERT INTO jid_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Niwa ba wa ndana toh kpe wu lowu wu qu na, ba yo Pilate ndi du wuu. ");
INSERT INTO jid_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Niwa ba kle wawu kpi wa bana nha nituma'a, ba banwu grji rhini kunkron'a nda kawu yo kru nimi ibe. ");
INSERT INTO jid_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Irji a nzuulu rjini qu. ");
INSERT INTO jid_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wu vi gbugbuwu ndji waba hu rji ni Galili ye Urushelima basi too. Ahi ndji biyi yi basi bla kpi wa bato nituma ni ndji ba. ");
INSERT INTO jid_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Niki ki hla yiwu tre ndindi, shirji wa a ye niba bachimbu ");
INSERT INTO jid_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","a du ba ye he toki nitawu, mri mba, nitu wa a nzu Yesu lu. Na wa ba nha ni Zabura wu ha: “Wu hi wu vren mu, luwa mi k'ma ti time,/ ");
INSERT INTO jid_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nituwa a nzuu lu rji ni qu nitu du na la ka k'ma ye na, Irji a tre toyi: / Mie nu tsatsra mbalulu wa mi shirji ni Dauda. ");
INSERT INTO jid_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nitu ki ala tre ni Zabura ri ngari ndi “Wuna du tsatsra me du toh gla na.' ");
INSERT INTO jid_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Niwa Dauda a kle ndu wa Irji a son niwu'a ni k'ba bi ngrjima, a ku kruna, e ba karhuu baba ba bachima, e k'ma ma a toh gla. ");
INSERT INTO jid_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama wawu wa Irji a nzu lu'a ana toh gla na. ");
INSERT INTO jid_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Niki bika toh, mri vayi, ndi, zu ni wo guyi, ba d'bu nihiwu, kpawruhle lahtre. ");
INSERT INTO jid_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Zuni wu, ko nha wa a kpanyme ani kpa yandindi nitu wawu kpi wa doka Musa ana toh ya ndindi niwu na. ");
INSERT INTO jid_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nikima, mla zren nitu kpi wa anabawa ba tre nituma duna hon nitu mbi na: ");
INSERT INTO jid_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Mla ya, biyi bi kpa wruhle, ni ya ni nyu ni w'ho, mle ni qu kado; Toh, mi nji ndu niye nimi vi mbi biyi, Ndu wa bina kpanyme niwu na, ko ndrjo ri nita d'bu bla yiwu.'” ");
INSERT INTO jid_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Niwa Bulus mba BArnaba ba lusi hi, ndji ba ba breba ni duba la tre lan tre ba ngari ni chachu Sati wu hu kima. ");
INSERT INTO jid_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Niwa ku son mba wu Synagogue a ye kle'a, yahudawa gbugbumba baba biwa ba kpanyme nda k'ma ni hu Irji mba ba hu Bulus mba Barnaba, e ba tre niba nda nron ba ndi duba kri gbangban ni nkon ndindi wu Irji. ");
INSERT INTO jid_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nivi Sati wa aka hu kima, igbua wawu ba ye zontu ki nitu duba wo lantre wu Bachi. ");
INSERT INTO jid_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Niwa Yahudawa ba ba toh kpaandi ba, ngu a shu ni sron mba, nda duba tre meme nitu kpi wa Bulus a tre'a, nda si mren'u. ");
INSERT INTO jid_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ama Bulus mba Barnaba ba tre rju ni gbengble sron ndi “Abi wa du yi guchi wo bla lantre Irji. Ni toyi bi tru hle rjuni kpa mbi, ni ban kpambi ti wa bina mla wu kpa vri wa ana kle na, tooyi, ki k'ma hi nibi wa ba bi kora. ");
INSERT INTO jid_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Toki Bachi a mmhata gbangban ni tre ndi, 'Mi yoyi nji kpachuwo hi ni gbungblu nkankan wu meme wawuu.'” ");
INSERT INTO jid_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Niwa bi kora'a ba wo tre yi, ba ngyiri nda nzu hon lantre wu Bachi. Wawu biwa a yoba yo ni duba kpa ivri wa ana kle na, ba kpanyme niwu. ");
INSERT INTO jid_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lantre Bachi a zren hi ni ngbran kima wawu. ");
INSERT INTO jid_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama Yahudawa ba ba chon mmba bi ninkon ndani kri gbangban ni hu'a, baba lilon bi tsro nkon wu hu ni gbu'a. Ba chon iya yo nitu Bulus mba BArnaba nda duba zuba vrarju ni ngbran kima. ");
INSERT INTO jid_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ama Bulus mba Barnaba ba kpon meme zamba rju du hon tumba. Mle ba hi ni gbu Iconium. ");
INSERT INTO jid_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","E mri ko bi hu ba ba shuni ngyiri mba ni Ruhu Tsatsra. ");
INSERT INTO jid_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aye he toki ni Iconium, wa Bulus mba Barnaba ba ri hi nimi Synagogue wu bi Yahudawa ba, nda ka tre hu ninkon wa kpaandi, ba Yahudawa baba Greeks ba kpanyeme. ");
INSERT INTO jid_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama Yahudawa wa ba kamba ni zren huba'a, ba chon dri bi kora ba nda duba ti nfu ni mri vayi mba. ");
INSERT INTO jid_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nitu ki, ba ki niki gbron nton, ndani bla gbangban me ni gbengblen Bachi, ndani tsro ba du ba toh tre wa a ton ba wu ya ndindi. A ti toki niwa a tsro kpanyeme wa ndji ba toh ni kikle kpi waasi ti ni shishi mba, zu ni wo bulus mba Barnaba. ");
INSERT INTO jid_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ama ndji bi gbu'a ba gaanyu, bari ba kri ni ngbala Yahudawa, i bari ni manzani ba. ");
INSERT INTO jid_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wawu mba, bi kora mba Yahudawa (baba bi ninkon mba) ba wa nkon wu vu ba yo ya nda ta ba Bulus mba Barnaba ni tita, ");
INSERT INTO jid_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ama niwa ba ble wo toki, ba tsutsu hi ni igbu bi Lycaonia, wu Lystra mba Derbe baba kaagon gran bi koki, ");
INSERT INTO jid_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","niki ba si zren ni d'bu tre ndindi'a. ");
INSERT INTO jid_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ni Lystra, iguri a son, hamma ni gbengblen ni zama, chon kple rhi ni nne yimma, wa ana zren to ni son ma na. ");
INSERT INTO jid_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Iguyi a wo bulus si tre. Bulus a yo shishi ma niwu nda toh ndi a he ni sron kpanyeme nitu kpa sii kpama. ");
INSERT INTO jid_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Niki a tre niwu ni kikle lan ndi, “Lu kri ni za me.” Mleigu'a a lu za kri nda zren kaagon. ");
INSERT INTO jid_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Niwa kpaandi ba bato kpewa Bulus a ti'a, ba nzu lan ba ndani tre ni el'pa Lycaonia, “Ba rji ba ba k'ma rhu too ndji nda grji ye nita.” ");
INSERT INTO jid_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba yo Barnaba ndi “Zeus,” mba Bulus, “Hermes,” nitu wawuyi ana ninkon wu lantre'a. ");
INSERT INTO jid_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Priest wu irji zeus, wa koobre ma ahe ni kogon kikle gbu'a, anji kikle lando wa ba yra ni loh bre ye ni kikle nkontra gbu'a, wawu mba gbugbu ndji ba, nitu duba ye gon nton nibawu. ");
INSERT INTO jid_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Niwa manzani ba, Bulus mba Barnaba ba wo toki, ba y'ba nklon mba nda tsutsu hi nda ka kuuyi ni mi ndji ba ");
INSERT INTO jid_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nda ni hla ndi, “Indji-lon, nitu ngye bi ti kpi biyi? Kita ngame ki ndji, ni kpa too wumbi. Kisi bla tre ndindi ni yiwu nitu duyi k'ma gon don meme kpi ndi ye ni Irji wu sissren, wa a ti shulu, ni memee ni kpaama teku, mba wawu kpi wa bahe ni mi mba. ");
INSERT INTO jid_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","NI k'ba wa baka hiye, a du gbungblu du ba zren ni nkon kankan wu mba. ");
INSERT INTO jid_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ni kima me, ana hamma ni don wa ba bla kpewa ba to nituma na, niwa a ti kpiwu bi nda nuba mma-lu rhini shulu mba ntonlu wa niye nuyi klo biri bran; shuuni sron mba ni biri mba ngyiri kpukpome. ");
INSERT INTO jid_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ni lantre bihi me, Bulus mba Barnaba ba mla zu ndji ba megen bubu gon nton ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ama Yahudawa bari wa ba rhini Antioch mba Iconium, ba ye kma tu ndji ba sran ni gyru bre. Ba taa Bulus ni tita nda ngbiwu rju hi ni kogon gbu'a, nda ban ni mren mba ndi a qu ye. ");
INSERT INTO jid_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ni kime, niwa mriko ba ka kri kaagon nitu ma, alu kri nda zren ri ni mi gbu'a. Ni vi wa a hu kima, a hi ni Derbe wawu'u mba Barnaba. ");
INSERT INTO jid_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hu gon wa baka d'bu bla tre ndindi nitu ma, ni mi gbu'a nda mriko gbugbu, ba k'ma ye ni Lystra, ni Iconium mba ni Antioch. ");
INSERT INTO jid_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba si nron mriko ba duba kri ni sron gbangban nda yo ni bawu du ba na k'ma ya gon ni kpa nyme mba ndani tre ndi, “Abi toki duta ri ni ko Irji hu ni nkon iya ");
INSERT INTO jid_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Niwa ba yo bi ninkon nitu mba, ni ekklisiya ba, nda bre Irji hamma ni rhikpe, ba kaba yo ni wo Bachi wa nituma yi ba kpa nyeme. ");
INSERT INTO jid_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mle ba zrenzu ni Pisidia nda ye ri ni Pamphylia. ");
INSERT INTO jid_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Niwa ba kle bla lantre'a ni Perga, ba grji hi ni Attalia. ");
INSERT INTO jid_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Rhi niki ba zren zu nitu mma ka rini Antioch, ni bubu wa bana nzuba yo ni toh ti Irji wu ndu wa baka kle'u zizan. ");
INSERT INTO jid_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Niwa ba ye ri nimi Antioch, ba yo ekklisiya zi ni bubu riri, nda vubla bawu wawu kpiwa Irji a ka ti niba, mba nitu wa a bwunko wu kpa gbangban ni biwa babi kora'a. ");
INSERT INTO jid_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ba kii wu gbron nton ni ba mriko ba, ");
INSERT INTO jid_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Indji bari ba grji rji ni Judiya ye ni Antioch nda ye bla tsro ni mri vayi ba ndi, “Bi tina duba han mbru ni yiwu hu njo tre Musa na, bina kpa chuchuwo na. ");
INSERT INTO jid_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kpeyi a vu tu Bulus mba Barnaba zon ti nkan nda duba kri senyu ni ba. Niki, Bulus mba Barnaba, baba bari ni mi mba, ba chuba ndi duba hon hi ni Urushelima nda yi son ni ba manzani baba bi ninkon ba nitu duba tu tre'a. ");
INSERT INTO jid_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nitu ki, niwa ekklisiya a ton ba'a, ba zren zu ni Phoenicia mba Samaria, nda si bwu bla sran sron wa bi kora'a ba kpa'a. Ba nji ngyiri kpukpome ye ni mri vayi ba. ");
INSERT INTO jid_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Niwa ba ye rini Urushelima, ekklisiya mba manzaniba baba bi ninkon ba ba kpaba ni wo ha, i baka vu kpi wa Irji a ti bawu'a bla ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama ndji bari, ni mi biwa ba kpanyeme'a, wa bahe ni mi grji bi Pharisee, ba lu kri nda tre ndi, “Ani kpe wuti ni duba vu ba han mbru nda yo tre gbangban ni bawu duba hu tre doka Musa.” ");
INSERT INTO jid_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Niki manzaniba baba bi ninkon ba ba zontu ki nitu duba mla kpeyi yato. ");
INSERT INTO jid_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hu gon sen nyu ni kpamba, Bitrus a lu kri nda tre niba ndi, mri vayi, bito ndi, ni nton ndindi wa aka hi ye'a, Irji a chu ni mi mbi, nitu ni nyu mu, Bi kora ba duba wo lantre wu tre ndindi'a, nda kpanyeme. ");
INSERT INTO jid_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Irji, wa ato dri'a a mla bla ni bawu niwa a nuba Ruhu Tsatsra, toh waa ati nitawu; ");
INSERT INTO jid_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ndana chuta ti nkan ni ba na, niwa a vu sron mba se ni toh kri gbangban. ");
INSERT INTO jid_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Zizan nitu ki, ahi ngye duyi ni tsra Irji, niwa bi klo ilo wu ya nitu nkanto wu bi hu'a wa ba timbu, ni kita kina mla to ba nji na'a? ");
INSERT INTO jid_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ama ki kpanyeme ndi ki kpachuwo nitu ya ndindi wu Bachi Yesu, na baba me.” ");
INSERT INTO jid_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kpaandji ba wawu ba ki ni gbangbi niwa ba si sren ton ni ndu wu bwu ya mba wu kanyu yo ni w'ho wa Barnaba mba Bulus ba vu si bla nitu wa Irji a ti ndu ni mi Bi kora'a, zuni wo mba. ");
INSERT INTO jid_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hu gon wa ba tre kle'a, Yakubu a saa nda ni tre ndi, “Mri vayi, yo ton ndi wome. ");
INSERT INTO jid_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siman a hla yiwu niwa Irji ni ya ndindi ma ni mumla azo bi kora'a nitu du ban rhi ni ba, ndji wu ndema. ");
INSERT INTO jid_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lantre ba anabawa a kpanyme ni kii, na wa ba nha'a. ");
INSERT INTO jid_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Hu gon kpi biyi, mi k'ma ye, mba miye mme ngari, ko wu zontu ni Irji wu Dauda, wa a zilhe ye; Mi nzu sazi, ni du wron meme ma du k'ma ye to ana he, ");
INSERT INTO jid_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ni du mbru ndji wa ba don'a, duba wato Bachi, baba wawu bi kora wa ba yo ba ni ndemu.' ");
INSERT INTO jid_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ikpe yi yi Bachi a tre ndi, A nhati kpi biyi wa bato rhi ni sen'a? / Nk'ma vunvu wu Greek bi sen wa ba he ni tu tre wandi a nkan / Ikpe yiyi wa Bachi a tre, ni tuma yi, ba toh wawu kpi wa ba ti nisen. ");
INSERT INTO jid_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nitu kima, mi ban zi ndi kina ti ba ya na, baba bi kora wa ba k'ma ye ni Irji. ");
INSERT INTO jid_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama ki nhahi ni bawu ndi a tre wa s tsra, duba chukpa mba ti nkan ni kpa ti meme gunki, wrhuni hu mba mba ni nn'ma wa ba wuu ba ndwuto, mba rhini iyi. ");
INSERT INTO jid_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nitu Musa, ba d'buhla ni gbu nkankan, rhini k'ba bi sen, a ye ni zizan wa basi bla nimi Synagogue chachu ni vi Sabbath.” ");
INSERT INTO jid_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Niki a bi ya ni manzaniba baba bi ninkon ba, mba ekklisiya wawu, duba chu Juda wa ba yo ndi Barsabbas, mba Sila, wa bana bi ninkon wu bi vayi ba, nda ton ba hi ni Antioch baba Bulus mba BArnaba. ");
INSERT INTO jid_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nha zuni wo mba, “Rhini manzani baba bi ninkon ba, mri vayi mbi, hini mri vayi bi kora nimi Antioch, Syria mba Cilicia ki chi yi! ");
INSERT INTO jid_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nitu ki wo ndi ndji bari ba rhunita hama ni kpanyime mbu, nda ka si chonyi ni lan tre wa a kpa sron mbi ti meme'a. ");
INSERT INTO jid_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","A bi ya nitawu, wa ki k'ma sron mbu yo ni bubu riri, ndi chu ndji biyi wa ki tonba ye ni yi baba mri vayi bi mlason mbu, Barnaba mba Bulus, ");
INSERT INTO jid_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ndji biwa ba ban tu yo ni nkon qu nitu nde wu Bachi Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nitu ki, ki ton Juda mba Sila, Wa ba vu bla ni yiwu, kpi biyi ngame ni lantre mba. ");
INSERT INTO jid_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nitu a ya bi ni Ruhu Tsatsra mba ni tawu, du kina la ban ndu ya sa nha nitu mbi zan wa a he toki ye: ");
INSERT INTO jid_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ndi du yi chuwo rjuni kpi wa ba ton ni brji, ni iyi, kpi wa ba wuu ni ndwu to, mba rhini latre wamba ko lilon. Bita chu kpambi wru ni kpi biyi, zren ni bi yiwu. gbuchu. ");
INSERT INTO jid_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Niki, niwa ba kle nda yo ba ninkon, ba zren grji hi ni Antioch, hu gon wa ba vu gbu ndji ba zontu zi bubu riri, ba ka vunvu wa ba nha bawu nuba. ");
INSERT INTO jid_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Niwa ba bwu bla, ba ta kpe nitu nron tre wa ba kpa'a. ");
INSERT INTO jid_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda mba Sila, wa bana anabawa ngame, nronba mri vayi ba ni lan tre gbugbuwu nda zoba kri gbangban. ");
INSERT INTO jid_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hu gon wa ba fon ki niki, ba tru ba hi ni si sran rhini mri vayi ba hi ni biwa bana ton ba'a. ");
INSERT INTO jid_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Vunvu wu bi zan, bi son bana he ni nklan 34 na (Ya Ndu Man.15:40). Ama a toh bi du Sila du k'ma son niki. ");
INSERT INTO jid_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ama Bulus mba Barnaba ba kii ni Antioch ndani tsro nda ni bla (baba gbugbu bari) lan tre wu Bachi. ");
INSERT INTO jid_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hu gon vi bari, Bulus a hla ni Barnaba, “Ki k'ma hi zizan ni ki hi tsri ni mri vayi bi gbu wa kina ka d'bu hla lantre Bachi, niki toh ka ba heni ha.” ");
INSERT INTO jid_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba a son ban Yohana wa ba yondi Markus, nji nha. ");
INSERT INTO jid_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Bulus a rhimren ndi ana bi du ba ban Markus na, waa ana kaa ba don ni Pamphylia nda na la huba ni ndu'a na. ");
INSERT INTO jid_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Niki, kikle sen nyu a gaaba nda du ba hu nkon nkankan ni kpamba, i Barnaba a ban Markus hu ni kpama, nda dran rju hi ni Cyprus. ");
INSERT INTO jid_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ama Bulus a chu Sila nda rju kunkon hi, hu wa mri vayi ba ba vu ba sru ni nji ndindi wu Bachi. ");
INSERT INTO jid_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mle a zren zu ni Syria mba Cilicia ndani gbre kri gbangban ni ekklisiya ba. ");
INSERT INTO jid_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus ngame aye ni Derbe mba ni Lystra, niki vrenko wu huuri wa ndema hi Timotia he, vren wa Yahudawa ri, wa a kpanyime niwu, ama tima ana ndji Greek. ");
INSERT INTO jid_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mri vayi wa bana he ni Lystra mba Iconium bata tre ndindi ni tuma. ");
INSERT INTO jid_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ata son du zren huu ni tuki, a bau njinda gen-mbru niwu, ni du Yahudawa wa ba he ni bubu baki du ba toh, nitu bana toh ndi tima ana Greek. ");
INSERT INTO jid_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Niwa ba hu nkon si hi zu nimi gba ba, basia zren nihu nkon tsatsra wa manzani ba mba bi ninkon biwa ba he ni Urushelima ba m'ha yo duba hu. ");
INSERT INTO jid_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Niki ekklisiya ba ba kpa ti ngbengblen ni kri gbangban nitu hu nkon'a nda du kri mbru mba a si hon chachu. ");
INSERT INTO jid_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus mba bi zren niwu ba zren zu ni ngbran Phrygia mba Galatia, nitu Ruhu Tsatsra ana ti gbuchu ndi du ba na d'bu lan tre'a ni ngbran Asia na. ");
INSERT INTO jid_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Niwa ba zren ye ti weiweire ni Mysia, ba yo sron zuni Bithynia, ama Ruhu Yesu a zuba. ");
INSERT INTO jid_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Niki ba vu Mysia y'ba nda grjiye ni gbu Troas. ");
INSERT INTO jid_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bulus a toh ni mira ni chu; ndji ri wu Macedonia a kri ki nda si bre'u nda ni tre ndi, “Ye nita ni Macedonia ni ye zota.” ");
INSERT INTO jid_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Niwa wa Bulus a hrara toki, ki krilu si wa nkon wuhi ni Macedonia, nitu ki ban ndi Irji mba yo ta du ta ki hi bla tre ndindi ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ki kuu zren hu ni nkon ma rhini Troas, ki hu trime nkon wa ani njita zu ni Samothrace, nda duta ka rhini Neapolis ni mbewa aka wu vi kima. ");
INSERT INTO jid_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Rhiniki, ki hi ni Philippi, wandi ana kikle gbu wu Macedonia, gbu wa a zan bi ni ndu wu ngbran kima mba wa aheni wo bi tuchu wu Romawa; ki ki niki wu vi wa a fon bran. ");
INSERT INTO jid_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ni vi Sabbath (Chachu Sati), ki zren rhu ni kikle nkontra gbu'a wa a he ni kosan ba'a, bubu wa ki ban ndi ani bi wu bre. Ki kukhi ni tre ni mmba wa ba ye zontu ki'a. ");
INSERT INTO jid_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iwari wu nde Lydia, wa a ta le ni ikpi nklon sru, rhi ni gbu Thyatira, wa ata hu nkon Irji, a yo ton si wota. Bachi a bwu sron ma ni du mla wo kpe wa Bulus asia tre'a. ");
INSERT INTO jid_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Niwawu mba bi koma, ba kpa batisma, nda bre ta ndi, “Bita kpanyme ni me ndi mi kri gbangban ni hu nkon Bachi, bi ka ye ni komu.” Nikima a weireta du ta kpanyme. ");
INSERT INTO jid_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Niwa ki sia hi bubu bre, vrenwa ri wa ana gran, nda he ni brji wu toh kpe nda nran, a ye zontu nita. A ta nji nklen gbugbuwu ye ni ti ko ma nitu ndu nran wa ata ti'a. ");
INSERT INTO jid_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Iwa yi a zren si huba Bulus nda d'bu si hla ndi, “Biyi bi mri koh wu Irji wa a zan nzu hon. Ba ki bla nkon wu kpachuwo ni yiwu.” ");
INSERT INTO jid_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Asi ti toyi wu vi gbugbuwu. Ama Bulus, nitu vrenwa a yo nfu branbran, a k'ma nda hla ni brji'a ndi, “Mi mmha'u ni nde Yesu Kristi, rju ni kpa ma.” Mle a rju ni nton kima. ");
INSERT INTO jid_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Niwa bi ti koma ba toh ndi nkon kubu mba a kle, ba vu Bulus mba Sila nda gbi ba hi ni tsutsu bubu wa ba le ni kpi, niwa bi ninkon gbu ba ki'a. ");
INSERT INTO jid_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Niwa ba nji ba ye nu bi blatre (Alkali), ba tre ndi ndji biyi ba nji iya rini kikle gbumbu. Ba Yahudawa. ");
INSERT INTO jid_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba bla tre njo wa ana he nitu nkon wa Romawa ba kpanyme duta hu na. ");
INSERT INTO jid_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Niki kpaandji ba lu hon wawu mba, nitu Bulus mba Sila; Alkali ba ba y'ba ba nklon mba ju nda mmha duba hloba ni kunkron j'bo. ");
INSERT INTO jid_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Niwa ba hloba ni wo gbugbu nitu mba, ba tru ba sru ni ko wu tru nda mmha ndji wu tro'a du mla yo shishi nda na du ba gbuj'bu na. ");
INSERT INTO jid_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Hu gon kpa mmha yi, ndji wu tro'a, a tru ba sru ni tra wu komi nda vu ba za mba lo nha ni kunkron gbangban. ");
INSERT INTO jid_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mla tsutsu chu, Bulus mba Sila ba sia bre Irji nda ni yo se wu nzu Irji hon, i mbru biwa ba tro ba ngame'a ba sia sren ton niba. ");
INSERT INTO jid_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Niki, kikle grju meme a lu ti, nda du nchimeme wu ko tro a grju, mlee nkon ba wawu ba bwu yo hwo, mba ba sraka wa ba lo ba niwu'a ba si hle. ");
INSERT INTO jid_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Igu wu troba'a a lu sh'me ni nna nda toh nkontra kotro ba ba bwu kri ni hwo, a gbron guglo Inji wu nduma ndani wuutuma, nitu a ban ndi biwa ba troba ba rju nawo ye. ");
INSERT INTO jid_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bulus a yo gro ni kikle lan nda tre ndi, “Na ti kpame kpe na, nitu wawu mbu ki he ni wayi.” ");
INSERT INTO jid_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Igu wu troba a yo duba nji ilu kpan njiwu, nda tsutsu ri ni tsenza kpa mba sissri nda ka kukru ni shishi Bulus mba Sila. ");
INSERT INTO jid_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nda nji ba rju nda tre ndi, “Mi nuyi ninkon, mi ti ngye ni dumi kpa tumu chuwo?” ");
INSERT INTO jid_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba tre ndi, “kpanyme ni Bachi Yesu, niki wu kpa kpachuwo, ni wu baba biwa ba he ni ko me.” ");
INSERT INTO jid_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ba hla lan tre wu Bachi niwu, baba ni ko nha ni mi koma. ");
INSERT INTO jid_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Niki, igu wu tro'a a vu ba ni nton kima wu chu'a, nda ka ngla mkpan mba, niki wawu mba bi koma wawu ba ti batisma ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Niwa a nji ba Bulus mba Sila hon hi ni koma nda ka nuba biri, a ta kpe kpukpome, ni ndji biwa ba he ni koma'a, nitu a kpanyme ni Irji. ");
INSERT INTO jid_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Zizan, niwa mble a nhran, alkali ba ba ton du hi ni bi gben'a, ndi “Du ndji bi mba hi kpamba.” ");
INSERT INTO jid_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Igu wu tro a vu lan tre ba bla ni Bulus mba Sila andi, “Alkali baba ton lan tre ye ni me ndi du mi du yi hi. Zizan nikima, ye rju hi yi ni si sron.” ");
INSERT INTO jid_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama Bulus a hla bawu ndi, “Ba vuta hlo tsi ni shishi ndji, hamma ni tsra ta toh, niwa me ki mri son meme Roma, nda tru ta sru ni kotro, zizan ba son juta rju ni rhiri? A'a! Du ba ye kimba nda ye njita rju.” ");
INSERT INTO jid_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bi gben ba baka vu tre biyi bla ni ba alkali ba, niwa ba wo ndi Bulus mba Sila ba mri gbungblu Roma, ikpe'a anuba sissri. ");
INSERT INTO jid_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Alkali ba ba ye bre ba nda nji ba rju, nda bre du ba rju ni gbu'a hi kpamba. ");
INSERT INTO jid_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Niki, Bulus mba Sila ba rju ni ko tro'a nda ye ni ko Lydia. Niwa ba Bulus mba Sila ba to mri vayi ba, ba nhronba duba ki gbangban, nda mle, rju hi kpamba rji ni gbu'a. ");
INSERT INTO jid_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Zizan, niwa ba zren zu ni igbu bi Amphipolis mba Apoloniya, ba ye ri ni kikle gbu Tesalonika, bubu wa synagogue wu Yahudawa a he. ");
INSERT INTO jid_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus, toh wa a ta tia, hi ni ba, nda ban vi Sati tra si vu mla ya ni mi nha tre BAchi niba. ");
INSERT INTO jid_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","A sia bwu tre Bachi nda ni mla bla ndi a tsra kri ni du Kristi du ti ya nda la lu rhini kwu. A hla ndi “Yesu yi, wa mi d'bu bla ni yiwu a wawuyi hi Kristi.” ");
INSERT INTO jid_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yahudawa bari ba kpanyme nda zontu ni Bulus mba Sila, baba gbugbu ndji bi Greek wa ba kri gbangban ni hu, mba imba bi ninkon, wa bana fii me ngame na. ");
INSERT INTO jid_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","I Yahudawa wa bana kpanyime na, nitu ba shu ni ngu, ba vu ndji bari bi meme dri rji ni bubu-leni-kpi wu gbu'a, nda kplu kpaandji ye zontu nda chon gbu'a duba yra gro ni nfu. Ba ri ni nfu kima ni ko Jason, ndi ba wa vu Bulus mba Sila nu ndji ba. ");
INSERT INTO jid_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Niwa bana to bana, ba gbi Jason baba mri vayi bari ye ni bi ninkon u gbu'a nda ni yii, “Ndji biyi wa ba k'ma gbungblu wawu sran hon grji ba ye ni wayi ngame. ");
INSERT INTO jid_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ndji biyi wa Jason a kpa ba; a; zren mba ni hu nkon nkan ni gbren tre wa Siza a yo'a, ba bla ndi niko chu ri nkan he wa ba yondi Yesu. ");
INSERT INTO jid_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ba kpa suron kpaa ndji ba baba bi ninkon gbu'a ti meme ni kpi biyi wa ba wo'a. ");
INSERT INTO jid_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hu gon wa ba chu Jason baba mbru mba ru ni wo bi lo ba, ba chuba chuwo duba hi. ");
INSERT INTO jid_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ni chu kima, mri vayi ba ba tru Bulus mba Sila hi ni Beriya. Niwa ba ri niki, ba ri hi ni mi sinagog wu Yahudawa ba. ");
INSERT INTO jid_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Zizan ndji biyi bana he nitu mla to zan bi wa ba he ni Tasalonika, ba kpa lan tre'a ni sron ndindi, nda bwu lan nha chachu nda shle si ya nitu duba to ka kpi ba ba tokii. ");
INSERT INTO jid_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nitu kima, gbugbu mba ba kpanyime, hu ni mba Greek bari wa ba yaba ni nfutu, baba gbugbu lilon bari. ");
INSERT INTO jid_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Niwa Yahudawa bi Tasalonika ba wo ndi Bulus a sia d'bu ni bla lan tre Irji ni Bariya, ba hi niki nda ka chon kpaa ndji ba hwu dri. ");
INSERT INTO jid_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mle, mri vayi ba ba tru Bulus du hi hu nkon wu tu kpaa ma, i Sila mba Timoti ba ki niki. ");
INSERT INTO jid_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Biwa ba sia tsro Bulus nkon a ba njiwu aren gbron ka tsra ni kikle gbu wu Athens. Niwa ba don Bulus niki, ba kpa tre nitu kpe wuti rji niwu hi ni ba Sila mba Timoti, ndi duba sima ye niwu. ");
INSERT INTO jid_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Zizan wa Bulus a sia gben ye mba ni Athens, langbiri sron ma a si chon niwa a to gunki ba shu ni kikle gbu'a. ");
INSERT INTO jid_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Niki a si bla ndani k'ma sran ya chachu ni mi sinagog baba Yahudawa baba bari wa babi hu nkon Irji, mba nimi bubu wu leni kpi baba biwa ba heni ki. ");
INSERT INTO jid_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Niki ngame bari bi to rhimren gban, wa babi Epikurean mba Stoic, ba zontu wu sen nyu niwu. Bari ba tre ndi, “A ngye wa ndi wu gbla nyu treyi si son hla?” Bari ba tre “A rju ndji biwa ba yo ndi du ba ye hu mri Irji wa bana to tumana,” nitu a sia dbu bla tre ndindi nitu Yesu mba ta sh'me ni kwu ma. ");
INSERT INTO jid_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ba ban Bulus hi ni Areopagus, nda ni bla ndi, “Wu la mla bla nitu tsro isa yi wa wu sia bla?” ");
INSERT INTO jid_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nitu wu nji kpi wa kina to tuma na ye ni ton mbu. Nikima, kisonb mla to tumba.” ");
INSERT INTO jid_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Zizan bi Athens ba wawumba baba bi tsri wa ba kru nha niba'a, ba sia wu nton mba ni kpe na, hama ni ndu bla mba srenton nitu ikpi isa wa ba rini gbu). ");
INSERT INTO jid_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Niki Bulus a lu kri ni tsutsu Ariopagus nda tre ndi, “Biyi ndji Athens, mi to ndi bi bi hu nkon bre irji ni za nkankan. ");
INSERT INTO jid_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Niwa mi zren zu si hi, mi mla ya nito kpe wa bi nzu hon ni bre mbi. Mi to iko bre ri wa bi nha “Ni Irji wa bina to na,” Ikpe wa bi nzu hon ni bre nina too na, wawuyi mi bwu bla ni yiwu. ");
INSERT INTO jid_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Irji wa a ti gbungblu wawu mba kpi wa ba he nimi ma, nitu wawuyi hi Bachi wu shulu mba meme, ana son ni ko bre wa ba me ni wo na. ");
INSERT INTO jid_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ana wo ndji mba ni tindu niwu na, ana ndi ani wa kpe ni wo ndji na, nitu a hi wawu kima mba ni nu ndji vrison sisren mba gbron vri ni kpi wawu. ");
INSERT INTO jid_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Rhi ni ndji ri, a ti gbungblu ndi ni duba ki ni tu gbungblu meme, nda tsra nton mba nyu dren bubu ki mba, ");
INSERT INTO jid_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","nitu duba wa Irji ka ba ma nk'mo nkon hi nda hi to wu. Kima me, ana gbangban ni ko nha mbu na. ");
INSERT INTO jid_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ni wawuyi ki son nda zren nda he ni kpa ndi too wa ndi mbi ri wu to tre a hla ndi 'kita ngame ki hpu ma.' ");
INSERT INTO jid_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nikima, nituwa ki hpu Irji, kina ba ndi nkon wubi wu irji ana to zinariya ko azurfa ko tita iwa kpiwa mren ndi mba ba la ba rhu na. ");
INSERT INTO jid_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nitu ki, Irji wruhle kpi wa kiti ni bwu tu, nda mha yo zi ndi du ndji kagon duba k'ma sron sran. ");
INSERT INTO jid_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A he toki nitu a yo vi wa ani gaatre ni gbungblu wawu ni nkon tsatsra zu ni wo ndji wa a chu zi ye. Irji guchi nu kpe wu tsro to nitu ndji yi ni ko nha wa a nzu lu ri ni kwu'a. ");
INSERT INTO jid_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Niwa ndji bi Athens ba wo nitu tsame ri ni kwu, bari mba ban za Bulus, e bari ba tre ndi, “Ki la sreton ngari ni wo nitu kpeyi.” ");
INSERT INTO jid_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hu gon ki, Bulus rju donba. ");
INSERT INTO jid_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","E ndi bari ba hu ka zontu niwu nda kpanyime, nimi mba Dionysius wu Areopagus, wari wa ndema hi Damaris, baba bari wa ba he ni ba. ");
INSERT INTO jid_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hu gon kpi biyi, Bulus a rju rji ni Athens nda hi ni Corinth. ");
INSERT INTO jid_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Niki a ka zontu ni ndji Yahudawa ri wa ba yo ndi Akwila, ndi wu ngrji Pontus, wa la ren mayi a ye rhini Itali mba wama Pricila, nitu Claudius a yo doka du Yahudawa du ba rju ni Rome. Bulus a hi niba, ");
INSERT INTO jid_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","nitu wa bata ti bibi ndu son ni gbungblu riri niwu, a son niba nda sia ti ndu'a, bana bi tsro bru ni tent. ");
INSERT INTO jid_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Niki Bulus a son zi shle bla ni sinagog chachu ni vi Sati (Sabbath), nda ni gbron mren Yahudawa baba Greek ba. ");
INSERT INTO jid_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Zizan niwa Sila mba Timoti ba grji ye ni Macedonia, Bulus a ka yo sron ma yo ngbangban ni lan tre'a, nda ni bwu hla ni Yahudawa ba ndi Yesu yi hi Kristi. ");
INSERT INTO jid_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Niki wa Yahudawa ba ba lu hon wu nda mren u, Bulus a kpon nklon kpama ni bawu nda hla bawu ndi, “Du iyi mbi he ni tu mbi, mi ngla wo mu rju, rji zizan mi hini bi kora'a.” ");
INSERT INTO jid_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mle arju don bubuki nda hi ni ko Titiyus Justus, ndi wa a ta hu nkon bre Irji. Ikoma a na he hu nha ni sinagog. ");
INSERT INTO jid_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, ninkon Sinagog a, kpanyime ni Bachi, ni bi koma wawu mba, baba gbugbu ndji bi Korintiya wa ba wo nda kpanyime, ba ti batisma ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bachi a hla ni Bulus ni chu nimi ra, “Na ti sissri na, si tre rju nina son gbangbi na. ");
INSERT INTO jid_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nitu mi he ni wu, ndrori na wa ti kpe meme ni wu na. mi he ni gbugbuwu ndji ni mi kikle gbu yi.” ");
INSERT INTO jid_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus a son niki ti ise ri ni wha tanne, nda ni tsro lan tre Irji ni mimba. ");
INSERT INTO jid_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Niki wa Gallio a hon son ni ruron gomna wu Achaya, Yahudawa ba ba lu ni mren sron ri wu kiamba ni Bulus, nda vuu ye shishi bi gaa tre; ");
INSERT INTO jid_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ba tre ndi, “Igu yi kma sron ndji ba duba hu nkon bre Irji nkan ni wa doka hla.” ");
INSERT INTO jid_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kima me, niwa Bulus a taa bwu tre ma, Gallio a tre ni Yahudawa ba ndi, “Biyi Yahudawa, a nita nitu meme ko gbirjerje la tre, ani he nitu nkon mi wo yi. ");
INSERT INTO jid_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nitu wa a he nitu lan tre baba ba nde ni doka mbi, hi ki ni mla kpa mbi ti kimbi. Mina son ri ni gaa tre ikpi biyii na.” ");
INSERT INTO jid_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gallio a duba rju dinkon ni ruron gaatre'a. ");
INSERT INTO jid_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Niki ba lu vu sosthenes, ninkon sinagog nda hlo tsi ni shishi ruron wu gaatre'a. E Gallio ana yo sron ni kpe wa ba tia na. ");
INSERT INTO jid_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus, hu gon son niki wu vi gbugbu bari, a lu don mri vayi ba nda dran hi ni Syria baba Priscilla mba Akwila. Niwa a rhihe kunkon rhini bubu ri ni jirgi ma wu Cenchrea, a duba kron nfutu ma rju mpempen nitu shirji wa a baan. ");
INSERT INTO jid_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Niwa ba ye ri ni Ephesus, Bulus a kaaba Priscilla mba Aquila don niki, e wawu kima a ri hi ni mi sinagog nda ka si shleniya baba Yahudawa ba. ");
INSERT INTO jid_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Niwa ba mye Bulus du son gbaa nha, a kama. ");
INSERT INTO jid_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ni lu bre nda ni donba, a tre ndi, “Mila kma ye ngari, Irji nita kpanyime.” A dran nitu jirgi mma rhiki hi ni Ephesus. ");
INSERT INTO jid_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Niwa Bulus a ye grji ni Caesarea, a hon hi ka chi ekklisiya wu Urushelima nda grji hi ni Antioch. ");
INSERT INTO jid_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Hu gon fon son niki, Bulus rju kuunkon zren zu ni gbungblu Galatia mba Phrygia, nda ni nhron mri ko ba du ba kri gbangban. ");
INSERT INTO jid_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Niki, Yahudawa ri ni nde Apollos, wa ba ngrjiwu ni Alexandria, a ye ni Ehpesus. A he ni lantre ndindi wu tre nda ni mla toh vunvu tre Irji. ");
INSERT INTO jid_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apollos ana kpa tsro ndindi ni tsro tre Bachi, nitu wa a ta kri gbangban ni dri, a tre nda tsro ni nkon tsatsra kpi nitu Yesu, e nda to nitu batisma wu Yohana megen. ");
INSERT INTO jid_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apollos a lu kri si tre ni gbengblen sron ni mi sinagog. Niwa Priscilla mba Aquila ba woowu, ba yo ye ni kosan nda mla bla niwu, nkon wu Irji. ");
INSERT INTO jid_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Niwa a ta son vu yba hi ni Achaia, mri vayi ba ba nhron nda nha vunvu ni mriko bi Achaia ndi du ba kpaa ni wo ha. Niwa a ka riki, a zo ni nkon gbugbuwu biwa ba kpanyime, nita a kpaba hamma ni duba ti kpe. ");
INSERT INTO jid_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apollos a kri gbangban ni sen nyu ni Yahudawa ba nda tsro ba rhi ni vunvu Irji ndi Yesu yi hi Kristi. ");
INSERT INTO jid_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aye he niwa Apollos a he ni Corith, Bulus a zren zu ni kotu gbungblu'a nda ye ri ni kikle gbuwu Ephesus, nda ye toh ba mri ko bari niki. ");
INSERT INTO jid_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Bulus a hla bawu ndi, “Bi kpa Ruhu tsatsra niwa bi kpanyime a?” Ba sa niwu ndi, “aan, kina wo nitu Ruhu Tsatsra mena. ");
INSERT INTO jid_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulus a tre ndi, “Nimi ngye wa ba ti batisma ni yiwu?” Ba tre ndi, “Ni baptisma wu Yohana.” ");
INSERT INTO jid_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Niki Bulus a sa ndi, “Yohana a ti batisma wu k'ma sron sran. A hla ni ndji ba ndi du ba kpanyime ni wa ani ye ka huu, wa a hi Yesu.” ");
INSERT INTO jid_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Niwa ndji ba ba wo toki, ba kpa batisma ni nde Bachi Yesu. ");
INSERT INTO jid_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Niki, wa Bulus a sawo nitu mba, Ruhu Tsatsra a ku nitu mba, nda duba tre ni lan bari nda bwu tre wu ko shishi si bla. ");
INSERT INTO jid_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wawu mba bana mla tsra ndji wlon don ha (tso). ");
INSERT INTO jid_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus a ri hi ni sinagog nda ka tre ni gbengblen sron, wu wha tra, shle vu si ya nda nhron ba nitu ngbran ko Irji. ");
INSERT INTO jid_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","E niwa Yahudawa bari ba lo sron zi gbangban nda kamba ni shishi kpaa ndji ba. Niki Bulus a kaa ba don nda chu mriko bari hu nji ni kpama, nda ka vu bla siya ba baa ni ba ni tra wu zontu bi u Tyrannus. ");
INSERT INTO jid_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","A si he toki ka tsra se ha, nitu ki wawu mba wa ba kii ni Asia, ba wo lan tre Bachi, ni Yahudawa baba Greek ba. ");
INSERT INTO jid_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Irji a sia ti kikle kpi wa bana ri he wu toh ni son mba, ni wo Bulus. ");
INSERT INTO jid_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nitu kii, ngbanjan nklon wu wo mba nklon wu kaa nne wa ana sa wo ni wu ba ban ba ka nubi lilo, i lilo mba a bwa hi don ba e brji ba ba rju don kpamba. ");
INSERT INTO jid_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","E Yahudawa bi zu brji rju ni kpa ndji bari ba sia zren zu ni ngbran kima. Ba yo nde BAchi Yesu ni du nuba gbengblen nitu meme brji niwa ba tre ndi, “Ni nde Yesu wa Bulus a dbu hla, mi mha yiyo, rju yi.” ");
INSERT INTO jid_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ninkon Prist wu Yahudawa, wa ndema ana Sceva, a he ni mri tangban wa basia ti toyi. ");
INSERT INTO jid_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Meme brji a sa bawu ndi, “Yesu mi to, mba Bulus mi to, i wu hi nha?” ");
INSERT INTO jid_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Meme brji ni mi igu; a a doo lu hon nitu bi zu brji rju'a nda zan ba ni gbengble, nda hloba tsi. Mle ba yotsu rju ni ko'a ni ngbre mba ni nkpan kpa. ");
INSERT INTO jid_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ikpe yi a ri ton ndji wawu, Yahudawa baba Greeks, wa ba ki ni Ephesus. Sissri a vu ba, u nde Bachi Yesu a nzu hon. ");
INSERT INTO jid_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Niki ngame, gbugbu biwa ba kpanyime'a, ba rju ye nran nda vu bla meme kpi wa bana ti yea. ");
INSERT INTO jid_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Gbugbu biwa bata ti gbugblu ba ni vunvu mba rju ye sru ni buburi nda goon ba ni shishi ko nha. Niwa ba bla nklen kpi ba, ana dubu se ton wu whlo azurfa. ");
INSERT INTO jid_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Niki lan tre wu Bachi a zren kagon gbagban ni gbengblen. ");
INSERT INTO jid_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Zizan, hu gon wa Bulus a kle ndu ma ni Ephesus, a yo sron, hu ni gbron Ruhu, nda zren zu ni Macedonia mba Achaia ni nkon ma wu hi ni Urushelima; a tre nde, “Mita ka ri niki, mi hi to Rome ngame.” ");
INSERT INTO jid_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bulus a ton hi ni Macedonia, ha nimi biwa ba ti ndu niwu, Timoti mba Erastus. E wawu kima a son zu wu ton fii ni Asia. ");
INSERT INTO jid_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mla tsra ni ton kima, iya wa ana fiime na a lu ni Ephesus nitu nko'a. ");
INSERT INTO jid_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ndji wu la azurfa ri ni nde Demetius, wa ata la gunki u Artemis ni azurfa, nda ta nji ndu nklen gbugbu ye ni bi laaba. ");
INSERT INTO jid_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Niki a yo bi ndu kima zi nda tre ndi, “Indji mbu, bito ndi ninkon du mbuyi, nklen ni ri bran. ");
INSERT INTO jid_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bi to ndi ni wo ndi, ana ni Ephesus megen na, hu mla ngban gbungblu Asia wawu, Bulus yi, a kma sron ndji gbugbu sran. Ani bla ndi mri irji wa iwo ndji ba laa ba na Irji na. ");
INSERT INTO jid_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ana nitu andi kikle iya wa a ni du ndu mbu kle na, iko kikle irji wu artemis me ni rjoku ni nzohonma ngame. Niki, gbengblen Artemis ani grji, wawu wa Asia mba gbungblu meme wawu ba kukru ni nzuhon.” ");
INSERT INTO jid_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Niwa ba wo toki, ndu a shu sron mba, eba kpa gro ndani tre ndi, “Kikle Artemis wu Ephesus.” ");
INSERT INTO jid_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kikle gbu'a wawu a tsi shishi, e ndji ba wawu ba vra tsu ni sron ri hi ni ko wu son mba (theatre). Bana vu kpukpan bi zren Bulus ye, Gaius mba Aristarchus, wa ba ye rhini Macedonia. ");
INSERT INTO jid_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus a ta son ri nimi kpaa ndji ba, e mri ko ba ba zuu. ");
INSERT INTO jid_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ngame, bari wa bana bi ninkon du ni ngrji Asia, wa bana kpanma, ba tondu hi wu ni bre ni duna ri ni tra son (theatre) na. ");
INSERT INTO jid_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ndji bari ba sia ti gro kperi, e bari ikpe nkan, nitu tsi shishi a vu kpaa ndji ba. Gbugbu mba bana to ka a hi ngye si zren nda duba ye zontu ki na. ");
INSERT INTO jid_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bari ni kpaa mba ba nron Alexanda, wa Yahudawa ba ba tru yo ni shishi, niki Alexanda a ti ba niwo, nitu a ta son yo tre wu ya ni soon mba. ");
INSERT INTO jid_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Niwa ba mla to ndi a hi ndji Yahudawa, ba lu yra gro wu ton mla bla ha ni lan riri, ndani hla ndi, “KikleArtemis wu Ephesus.” ");
INSERT INTO jid_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Niwa ndji wu nha (town clerk) wu gbu'a a du kpaa ndji ba kma ti gbangbi, a tre ndji, “Biyi ndji bi Ephesus, ahi ndji nha wa ana to ndi kikle gbu wu Ephesus yi hi bubu ko wu son wu kikle Artemis, mba iwhiwa grji ku rji ni shulu na? ");
INSERT INTO jid_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bita to ndi kpi biyi bana wu kpa tron na, bika ti wiime ni na kpati vravra mena. ");
INSERT INTO jid_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nitu bi nji ndji biyi ye ni shishi ko gaa tre, ana ndji ba bi y'bi iko bre mbi ka bi kpa nde mri Irji mbi ti meme na. ");
INSERT INTO jid_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nitu ki, Dimetrius baba bi ndu la wa ba he niwu'a ba he ni tre wu lo nitu ndrjo, tra wu gaa tre a he ni who mba bi wa bawoba nda gaatre'a. Du ba tsra kpa mba. ");
INSERT INTO jid_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bita ni wato kpe nkan, kima ki vu ya ni son yi ni mla ti. ");
INSERT INTO jid_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A hi njanji ki he ni ya wu lo bata vuta nitu kma gbu srantu wu vi luwa. Kina he ni kpe wu kaatu nitu kpa gbu tsi wu luwa na, e kina to nkon wu chutu rju na.” ");
INSERT INTO jid_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Niwa a kle tre toyi, a kaa son a nda du ndji ba shan hi. ");
INSERT INTO jid_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Niwa gro wu a kle'a, Bulus a ton ba ka yo mri ko bi hu'a nda nron ba du ba ki gbangban, nda tre ndi duba mla ki nda kuunko hi ni Macedonia. ");
INSERT INTO jid_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Niwa a zren zu ni gbungblu bi koki nda gbre ba ni lantre gbugbuwu, a ye rini Greece. ");
INSERT INTO jid_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Hu gon kima a son ti wha tre niki. Yahudawa ba ba mla nkon meme ti nitu ma, niwa a ta dran hun koma hi ni Syria; nitu ki a kma sran ka zu ni Macedonia. ");
INSERT INTO jid_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kpan zren ma ba wa baka rini Asia, bana sopater ivren Pyrrhus wa a rhini Berea, Aristakus mba Sekondus, hamba bana bi Tasalonika wa ba kpanyime, Gaius wu Derbe, Timoti, mba Tychicus mba Trophimus wa a rhi ni Asia. ");
INSERT INTO jid_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ndji biyi bana guchi hi nitawu nda ka sia gbenta ni Troas. ");
INSERT INTO jid_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ki dran rhuni Philippi niwa ivi bi bredi wa ana fuulu, a kle, mba ni vi u ton ki ye tsra niba ni Troas. Niki ki son u vi tangban. ");
INSERT INTO jid_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ni vi mumla u Sati ki, niwa kina zontu niki nzi bredi, Bulus a tre ni biwa ba kpanyime'a. A ta son don ba ni viwu hu kima, nitu ki a tre gbron nkon hi ni tsutsuchu. ");
INSERT INTO jid_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ilu fitila gbugbuu bana he ni tra u koshu, bubu wa kina zontu ki. ");
INSERT INTO jid_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ni windo'a, vren nze ri ni nde Eutychus a son, e inna a kri koonvu. Niwa bulus a tre la gbron nkon nha, vren nze yi, wa a risi kruna, a kurjoku rjini tuko u tra i baka baun kmomu. ");
INSERT INTO jid_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bulus a grji hi, kukru tsra kpama nituma nda maanji ye ni kpama. Mle nda tre, “Du sron mbi na ti meme zan toyi na, a he ni sisren.” ");
INSERT INTO jid_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Niki a kma hon hi ni tra u koshu'a nda ka nzi bredi tan. Hu gon wa ala si tre ni ba wu gbro nton ka tsra ni bwu mble, a rju kaba don. ");
INSERT INTO jid_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ba nji vren nze'a kma ye ni sisren ma e sron mba a kusi. ");
INSERT INTO jid_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kita ngame ki zren guchi ni Bulus nitu jirgi ma, ki dran hi ni Assos, bubu wa kina banzi ki ban Bulus yonji nita. Ana toki me wawu kima ana son ti, nitu ana ya ndi ani hu nkon u meme hi. ");
INSERT INTO jid_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Niwa a zontu nita ni Assos, ki baun yo ni mi jirgi'a ni hi ni Mitylene. ");
INSERT INTO jid_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Niki ki dran rhini kima ka ri ni vi wa aka hua, ni bubu wa ata ya nklan meme wu Chios. Ni vi wa ala hu'a, kika yo za ni nklan meme wu Samos, e vi wa aka hu kima, ki ye ri ni kikle gbu Miletus. ");
INSERT INTO jid_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nitu Bulus ana banzi ndi ani dran vu Ephesus yba, nitu du wawu na wo nton ni Asia na; a ta sima hi ri ni Urushelima nitu hi tsra ni vi Pentecost, anita bi tiwu toki. ");
INSERT INTO jid_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Rjini Miletus a ton ndji hi ni Ephesus duba ka yo bi ninkon ekklisiya ye wu. ");
INSERT INTO jid_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Niwa ba ye'a, a hla bawu ndi, “Bi yi kimbi bito, rhini vi mumla wa mi yo za ni Asia, niwa chachu mi zi wunton niyi. ");
INSERT INTO jid_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi zi ti ndu Bachi hama ni nzutu mba ni Mashishi, mba ni tsra iya wa ye ni me nitu zon nyu meme wu Yahudawa ba. ");
INSERT INTO jid_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bito nitu wa mi na kamu ni dbu bla ni yiwu ko ngye wa ani zoyi na, mba wa mi tsro yi ni shishi ndji wawu mba huyi niko niko, ");
INSERT INTO jid_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ni ni vu ni nran ni Yahudawa baba bi Greek nitu kma sron hi ni Irji mba kri ni gbangban sron ni Bachi mbu Yesu. ");
INSERT INTO jid_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Zizan ya, mi si hi ni Urushelima, ni gbron Ruhu, nina to kpe wa ani ti nimu niki na, ");
INSERT INTO jid_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","hamma wa Ruhu Tsatsra a bwu bla nimu ndi ni gbu kankan wa mi ria, wlo cbo wu lo mba iya ni gben me. ");
INSERT INTO jid_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","E me mina ban kpa ivri sisren mu to hi kpe wu tumu na, nitu du mi kle itsu mba ndu wa mi kpa rjini Bachi Yesu, ni du mi bwu nran tre ndindi wa Irji nme wo kpata hama duta ki han kpe. ");
INSERT INTO jid_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Zizan ya, Mito ndi wawu mbi, wa nimi mbi mi zren si dbu hla nitu ikoson Irji, bina la to shishi mu na. ");
INSERT INTO jid_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nitu kima, mi bwu ni bla yiwu vi wu luwa iyi ndrjo na he ni tumu na. ");
INSERT INTO jid_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nitu mina ka kpe don ni dbu bla wawu kpe wa Irji ni son niyi na. ");
INSERT INTO jid_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nitu kima, bika mla zren ni kpambi, mba ni ba wawu ntma wa Ruhu Tsatsra a yoyi du yi yaba niwu'a. Mla zren ni krju ekklisiya Irji, wa a le ba ni iyi ma. / Nitu du he ndi / ni iyi ma / nha vunvu bi sen bari ba yo ndi / ni iyi wu vren ma ");
INSERT INTO jid_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mi toh ndi, mita hi kpamu, meme yawhu bari ni mi mbi ba ye nda na kpa ntma ba chuwo na. ");
INSERT INTO jid_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mi to ndi nimi mbi me, ndji bari ba nzulu nda tre kpe bi gbran rhen nitu du ba gbron mriko bihu bari hi ni kpan mba. ");
INSERT INTO jid_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nitu ki bika mla kri. Bika ti mren ndi wu se tra mina don me ni nron yi yiyyri mbi ni mashishi ni chu mba ni irhi. ");
INSERT INTO jid_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Zizan mi yoyi ni wo Irji mba ni lan tre u wa a kpata, wandi ani to me yi nda nuyi gado nimi biwa ba ngla ba ti tsatsra'a. ");
INSERT INTO jid_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mina ti ngu yo sron nitu azurfa, zinariya ko nklon ndrjo na. ");
INSERT INTO jid_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Biyi me bi to ndi iwo mu biyi ba tindu ne kpiwa mi son mba kpison wu bi wa ba he ni me'a. ");
INSERT INTO jid_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ni kpi wawuu, mi bwu nkon tsro yi nitu wa bi zo bi wa bana he ni gbengblen na, ni tindu, mba niwa bi timre ni lantre Bachi Yesu, lan tre wa wawu kima a tre: A zan bi lulu du hu nu ni du hu kpa,” ");
INSERT INTO jid_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hu gon tre ma ni nkon yi, a kukwu mgbarju nda bre Irji ni ba wawu mba. ");
INSERT INTO jid_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ba kuuyi bran nda mankpa Bulus nji nda chiwu bi bi wu sron nyime. ");
INSERT INTO jid_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sron mba a ti meme zan nitu wa a tre ndi bana la to shishima ngana. Mle ba huu ka yo ni nkon ni jirgi ma'a. ");
INSERT INTO jid_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Niwa ki hi don ba ni vu zren hu nkon mma, ki hu tri me hi ni gbu Cos, e ni bi wa aka hua ni gbu Rhodes, mba rhini ki hi ni gbu patra. ");
INSERT INTO jid_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Niwa ki to jirgima wa a ta ru hini Funisiya, ki ri huba dran hi. ");
INSERT INTO jid_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Hu wa ki nzu shishi to Cyprus, ki kawdon ni wo mrha wu kpran jirgia, ki dran hi ni Syria, ndi ka kukri ni Tyre, bubu wa kikle jirgi a ta ju kpi wa anjia. ");
INSERT INTO jid_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Hu wa ki to mri ko bihuba, ki kii ni ki wu vi tangban. Hu kpere sron brji, basi yo tre ni Bulus du na hi Urushelima na. ");
INSERT INTO jid_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Niwa ivimbu niki a kle, ki donba ni kunkon mbu, i wawumbu, baba mbamba ni mri mba ba huta zren rjuni gbu'a. Niki ki kukwu ngbarju ni nyu kpe tre ma'a ni bre Irji, ");
INSERT INTO jid_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ni tre ndi se vi ri niki ki rini jirgi'a, i ba kma hi komba. ");
INSERT INTO jid_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Niwa ki kle zren mbu rji ni Tyre, ki ye ni Ptolemais. Niki chi mri vayi ba ni son niba wu vi ri. ");
INSERT INTO jid_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nivi wa a hu kima ki hi ni Kaisariya. Ki ri ni ko Filibus, ndji wu zren ni bla tre Irji, wa ana iri nimi tangban ba, ndi ka son niwu. ");
INSERT INTO jid_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Inji yi a he ni mri mba nza wa bana to lilon na, i bata nran kpi bi ye ni ko shishi. ");
INSERT INTO jid_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Niwa ki kii niki wu vi fon bran, indji ri wa ri to koshishi, ni nde Agabus, grji ye rhi ni Judiya. ");
INSERT INTO jid_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A ye nita nda ban rjirji trii Bulus. Niki a lo za mba woma ni rjirji trii'a nda tre ndi, “Ikpe wa Brji Tsatsra ni tre'a, toki Yahudawa bi Urushelima ba lo indji wu rjirji trii yi, i ba vuu yo ni wo Bikora.” ");
INSERT INTO jid_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Niwa ki wo kpi biyi, kita baba indji wa ba ki ni ki, ki krubre Bulus ni du na hi ni Urushelima na. ");
INSERT INTO jid_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Niki Bulus a sa bawu ndi, “Bisi ti ngye, kpa gro nini yra me sron? Mi kpanyime ndi du ba na lo me negen na, mba du me kwu ngame ni Urushelima nitu nde Bachi Yesu.” ");
INSERT INTO jid_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nitu wa Bulus na kma sron ni bre mba na, ki son ngbangbi ni lu tre ndi, “Du kpe wa Irji kpanyime niwu du he toki.” ");
INSERT INTO jid_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Hu vi biyi, ki vu ba mbu zren mbu ni hi ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mri ko bi hu bari wa ba rhini Kasariya ba huta ngame. Ba nji indji ri wu nde Mnason, indji wu Cyprus, nha ni kpamba, wa ana he ni mi bi mri ko bi hu, wa ki hi ki niwu. ");
INSERT INTO jid_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Niwa ki ye ri ni Urushelima, mri vayi ba ba kpata ni wo ha ni ngyiri. ");
INSERT INTO jid_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nivi wa a ka hu ki, Bulus a njita hi ni ko Yakubu, i bi chiche ba bana he niki. ");
INSERT INTO jid_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Niwa a chi ba, a vu bla ni yiyri kpi wa Irji a ti nimi Bikora ni nkon ndu wa a ti'a. ");
INSERT INTO jid_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Niwa bawo kima ba gbre san ni Irji, nda hlawu ndi, “Wu to, vayi, ka indji dubu bren ni mi Yahudawa ba ba kpanyime. Ba yo sron kri gbangban ndi ba hu du a. ");
INSERT INTO jid_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba hla bawu nitu me, ndi wu tsro Yahudawa wa baki nimi Bikora'a du ba ka Musa don, mba ndi wu hla bawu dubu na yoyi ni mri mba, mba du bana zren nitu nkon ba tii na. ");
INSERT INTO jid_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ki ti ni he? Njanji ba wo ndi wu ye. ");
INSERT INTO jid_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nitu ki, wuka ti kpe wa ki hla niwu. Ki he ni indji nza wa ba chu nyu. ");
INSERT INTO jid_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vuu indji ba ni ngla kpame niba, ni han nklen ni tumba, ni du ba kron nfutu mba. Ko nha ni to ndi kpe wa ba bla nitu me a hi che. Ba to ndi iwu ngame wu son tsra, nini hu du'a. ");
INSERT INTO jid_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","I nitu Bikora wa ba kpanyime'a, ki nha nitu krimbu ndi duba chu kpamba ti nkan ni kpi wa ba ton ni kpi bi brji, ni iyi, ni kpe ba wuu ni nkon nduto, mba ni ti fa'a.” ");
INSERT INTO jid_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Niki Bulus a vuu indji ba, i ni vi wa aka hu'a, a ngla kpama bi ni babaa. Niki ba ri hi ni mi hekali, yo tre ni zi ndi vi wu nglakpa ani ye he toki, i ba nu beko nitu yiyri mba. ");
INSERT INTO jid_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Niwa vi tangban ba ba ye kle, Yahudawa bari rhini Asiya, ni ku shishi ni bulus ni mi hekalia, chon kpaandji ba nfu, nda yo wo nitu ma. ");
INSERT INTO jid_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ba sia kpa gro ndi, “Indji bi Israila, zo ta. Indji yi yi ni tsro ndji wawu kagon, kpi wa ahi nkan ni kri mba, ni dua, mba ni bubu yi. Hama kima me, a nji indji bi Greek bari ye ni mi hekali nda kpa bubu tsatsra yi ti meme.” ");
INSERT INTO jid_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Nitu bana to Trofimus, gu wu Afisus niwu nimi gbua, nda yo ndi Bulus a nji ba ri ni mi hekali. ");
INSERT INTO jid_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Igbu'a wawu a chu nzan, i indji ba ba yo tsu ka vu Bulus. Ba gbiwu rju ni hekalia, nda kaa nkon ba gbagbla. ");
INSERT INTO jid_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Niwa ba ta son wuu, tu tre a ye ri ni ton kapti wu bi gben ndji Urushelima wawu ni kri gro tsishishi. ");
INSERT INTO jid_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Niki a tsi kri vu bi lokpa baba bi ya ndji deri ri, nda tsutsu grji nimi jbu indji ba. Niwa indji ba ba to ninkon kaptin mba bi lokpa ba, ba donme ni tsi Bulus. ");
INSERT INTO jid_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Niki ninkon kapti a zren hi ka vu Bulus, nda mmha yo ndi du ba lowu ni sraka ha. Niki a mye ka a hi nha mba a hi ngye wa a tia. ");
INSERT INTO jid_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bari nimi jbu indji ba ba kpagro kperi i bari kpe nkan. Niwa kaptia ana mla to tu tre'a na, nitu hanton mba, a yo ba du ba nji Bulus hi ni bubu wa ba mla ziri. ");
INSERT INTO jid_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Niwa a zren ye ni bubu ban za grji'a, bi lokpa a ba banwu nitu nfu jbu indji ba. ");
INSERT INTO jid_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nitu jbu indji ba ba sia huba nda ni kpagro ndi, “Niwu hi.” ");
INSERT INTO jid_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Niwa bataa nji Bulus ye ni bubu wu mlazia, a tre ni ninkon kaptia, ndi “Wu kpanyime ni du mi hla kpe niwu?” Kaptia a tre ndi, “Wu tre lan Greek? ");
INSERT INTO jid_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ana wuyi igu masra wa alu kpagbu tsi nda gbron indji dubu nza u bi wuundi rju hi ni miji'a na?” ");
INSERT INTO jid_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus a tre ndi, Mi ndi Yahudawa, rji ni gbu Tarsus ni Cilicia. Mina vren meme wu gbu wa a hi fii me na. Mi bre, du me tre ni indji ba. ");
INSERT INTO jid_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Niwa kaptin a nu kpanyime'a, Bulus a lu kri ni bubu ban zaa nda ti wo ni indji ba. Niwa bubua a ti gbi me, a tre niba ni lan Ibraniyawa ba. A tre nde, ");
INSERT INTO jid_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mri vayi baba bati, sren ton ni vri kpachuwo mu, wa mi ti yiwu.” ");
INSERT INTO jid_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Niwa jbu indji ba ba wo Bulus si tre niba ni lan Ibraniyawa, ba ti whime, A tre ndi, ");
INSERT INTO jid_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Me mi nji Yahudawa, ngrji wu Tarsus ni Cilicia, mi kpa tsro mu ni kikle gbu yi ni za Gamaliel. Mi kpa tsro nitu nkon tsatsra wu du ba ti ti mbu. Mi hu nkon Irji ngyengyere, to wa biyi wawu mbi bi he luwa. ");
INSERT INTO jid_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Miyo bi hu nkon'a iya ka tsra ni kwu, vu ba lo ndi tru ba sru ni kotro, lilon baba mmba, ");
INSERT INTO jid_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","me wa kikle Prist baba bi chiche wawu ba vu bla nituma. Mi kpa nha vunvu rhi ni ba hi ni mri vayi wa ba he ni Damascus, I mi hiki nitu hi vuba lo nji ye ni Urushelima ni duba fubaton. ");
INSERT INTO jid_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","A he niki mba niwa mi zren ti weiweire ni Damascus, mla tsutsu irji, mle kikle kpan rji ni shulu a lu kri kpan kagon mu. ");
INSERT INTO jid_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi kurjoku ni meme ndi wo ilan a tre ni me, 'Shawulu, Shawulu, nitu ngye wu si time ya?' ");
INSERT INTO jid_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mi sa ndi, 'Wu nha, Bachi?' A hla mu ndi, 'Mi Yesu wu Nazaret, wa wu si tiwu ya.' ");
INSERT INTO jid_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Biwa bana heni me bato bwu kpan, ndana to tutre lan wa a tre nime na. ");
INSERT INTO jid_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mi tre ndi, 'Mi ti ngye zizan Bachi?' Bachi a hla mu, lunde ni rhihi nimi Damascus. Niki wu wo kpe wa mi chuwu du wuti. ");
INSERT INTO jid_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mina lani to bubuna nitu kpanlua, i indji wa ba he ni me'a ba vume zrenji ni wo ye nimi Damascus. ");
INSERT INTO jid_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Niki mi zontu ni indji ri wu nde Ananiyas, indji wu kri gbangban ni hu nkon du, mba wa Yahudawa ba pempe wa ba ki niki ba tre ndindi ni tuma. ");
INSERT INTO jid_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A ye ni me, nda ye kri whi nime, nda tre ndi, 'Vayi Shawulu, kpa to bubu me.' Ni nton kima, mi towu. ");
INSERT INTO jid_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wa a tre ndi, Irji wu ba titimbu a chu du wu to sron ma, du wu to Tsatsra wu Ma, mba ndi du wo ilan wa rju rju ni nyuma. ");
INSERT INTO jid_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nitu wu ta bla nituma ni indji wawu, kpe wa wu to ni shishime mba ni woa. ");
INSERT INTO jid_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Zizan wu si gben ngye? lu kri, kpa batisma, ndi gla tre me hi, nisi yo ni ndema. ");
INSERT INTO jid_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Niwa mika kma ye ni Urushelima, nda sia bre ni mi hekali, a he niwa mi kpa to nimi ra. ");
INSERT INTO jid_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mi ton sia hlamu, 'Sima ni lunde don Urushelima gbagbla, nitu bana kpa bla tre nitumu na.' ");
INSERT INTO jid_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mi tre ndi, 'Bachi, baba kimba ba to ndi mi vu bi wa ba kpanyimea tro nda tsi ba ni sinagog kagon. ");
INSERT INTO jid_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Niwa ba ka iyi Istifanus wa ata bla nitu me hle, mi sia kri ni hugon, ndani kri ya nklon biwa ba wuu a. ");
INSERT INTO jid_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","I a hlamu ndi, 'Hi, nitu mi ton hi gbagban mu ni bi kora'a.'” ");
INSERT INTO jid_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ba srenton niwu ka tsra niwa a tre kima. Mle ba nzu gro kpa nda tre ndi, “njii bibi kima rhuni gbungblu meme, nitu a na bi du he ni sisren na.” ");
INSERT INTO jid_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Niwa ba sia kpa gro nda ju nklon mba ni the, nda ni vra iwru, ");
INSERT INTO jid_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","kikle kaptin a duba nji Bulus rihi ni bubu wu mla ri. A nu nyu tre nda du ba shle myeu tre no tiwu ya, nitu du wawume du to ka a hi ngye duba ni kpagro nituma toki. ");
INSERT INTO jid_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Niwa ba loo ni rjirji ntan, Bulus a tre ni ninkon wu ndji ya bi lokpa deri ri, wa a kri nha niki, “A tsra ni du yi ti indji Roma ya biyi, hama ni yo ni tsra? ");
INSERT INTO jid_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Niwa Centurion a wo toki, a hi ni ninkon kaptin a nda ka hlawu ndi, “A hi ngye wu si son ti? Indji yi hi vren meme Roma.” ");
INSERT INTO jid_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kikle kaptin a ye tre niwu ndi, “Hlamu, wu vren meme Roma? Bulus a tre ndi, “Ee.” ");
INSERT INTO jid_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kikle kaptin a sa ndi, “Ana ni gbugbu nklen mba mi kpanyime son vren meme.”I Bulus a tre ndi, “Ba ngrji me vren me Roma.” ");
INSERT INTO jid_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Niki indji wa bata hi shle miu trea ba kawu don hari. Kikle kaptin a ti sissri, niwa a wo ndi Bulus hi ndji meme Roma, nitu wa a vuu lo. ");
INSERT INTO jid_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ni vi wa ahu kia, kikle kpatin a ta son to tukpe wa Yahudawa ba bahe niwu nitu Bulus. Niki a duba si chuwo ni lo nda du kikle Prist baba bi son nitra bi ninkon gbua kuson. Niki, ba nji Bulus grji ye zi ni mi mba. ");
INSERT INTO jid_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus sru shishi ya bi ninkon wa ba kia nda tre ndi, “Mri vayi, mi son ni shishi Irji ni sron ndindi ye ni vi wu luwa.” ");
INSERT INTO jid_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kikle Prist Ananiyas a yo tre gbangban ni biwa ba kri whi niwu du ba wru ni nyu. ");
INSERT INTO jid_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Niki, Bulus a hla wu ndi, “Irji ni yowru, iwu wa wu kpagonkan wa ba ngal ni kinklan penti. Wu son nitu ruron gaatre nimu nitu du, i wuuyi wu du ba yome wru, nkan ni tre du a?” ");
INSERT INTO jid_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Biwa ba ki whi niwu ba tre ndi, “A hi toki mba wu mre ninkon Prist wu Rji?” ");
INSERT INTO jid_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulus hla ndi, “Ime mina toh na, mri vayi, ndi ahi kikle Prist. U ba nha kazi, Wu ka na tre meme tre nitu bi ninkon ba ndji mbi.” ");
INSERT INTO jid_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Niwa Bulus a to ndi ngbala ri bana Sadusii i bari ba Farasii, a tre gbangban me ni son ba'a, a he ni tu mi he ni yo sron tashme ni kwu nikima yi basi tsra lome.” ");
INSERT INTO jid_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Niwa a tre toyi, sen nyu a lu nimi Farasii mba Sadusii, i jbu indi ba ba gaatu. ");
INSERT INTO jid_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bi Sadusii ba tre ndi tashme na hena, Maleku bana hena, mba ibrji bana hena; i Farisii ba kpanyme ndi wawu mba ba he. ");
INSERT INTO jid_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Niki ti gro wu nzu sron a lu, i bi nha bari wa ba he ni ngbala bi Farisii ba ba lu kri nda sen nyu ni tre ndi, 'Kina to kpe meme ni indji yi na. Anita ibrji koka Maleka mba a tre niwu na?” ");
INSERT INTO jid_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Niwa kikle sen nyu a lu, kikle kaptin a ti sissri ndi ba yba Bulus ti gbanjan, niki a yo tre gbangban ni bi lokpa ba du ba grji hi banw ni gbengblen rhini mi son bi ninkon, nda nji wu ye ni bubu mla zi gbangban. ");
INSERT INTO jid_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ni chu wa a ka hua kima, Bachi a kri nha niwu nda tre ndi, “Vu sron ni kri gbangban, too wa wu bwu bla nitu mu ni Urushelima, kima me wu bwu bla ni Roma ngame. ");
INSERT INTO jid_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Niwa mble a nhran, Yahudawa bari ba zontu wu ti meme, nda tan mbre, ndi bana rhi mba so kpe na se ba wuu Bulus ri. ");
INSERT INTO jid_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bana zan indji Arbain (ise tra don nza) wa ba rini zontu meme'a. ");
INSERT INTO jid_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ba hi ni ninkon Prist mba nibi chiche ba nda katre ndi, ki ton ni kikle tan bre ndi kina rhi koka so kpena se ki wuu Bulus. ");
INSERT INTO jid_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Zizan, nitu kii, du son bi ninkon du banzi nda mye ninkon kaptin ndi du njiwu ye nu yi, ni du ya ndi bi son ban tre ma mla ya. Anita kita, ki son ni gben ni duta wuu ri du ye rhini wa.” ");
INSERT INTO jid_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","I vren wu vayi Bulus vrenwa a wo ndi ba ki kru gben ni nkon, niki, a hi ka ri ni bubu ngbangban wa ba mla Bulus zia nda ka hla wu. ");
INSERT INTO jid_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulus a yo ri nimi bi ya bi lokpa deria nda tre ndi, “Ban vren nze yi hi ni kikle kaptin, nitu a he ni kpe wa ani vu bla niwu'a. ");
INSERT INTO jid_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Niki, indji wu lokpa a ban vrenze a nda njiwu ye ni kikle kaptin nda tre ndi, “Bulus indji wa a kri troa a yo me hi ni kpama, nda du me nji vrenze yi ye niwu. A he ni kpe wa ani hla niwu.” ");
INSERT INTO jid_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ninkon kaptin a ban u niwo hi ni kosan nda ka mye'u, “A ngye wa gbigbi se wu vu bla mu?” ");
INSERT INTO jid_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Vrenze a tre ndi, “Yahudawa ba kpanyime ndi duba mye u du nji Bulus grji ye ni bi son ninkon, rjuto ndi ba hi mla mye nitu tre ma. ");
INSERT INTO jid_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Na gle rini wo mba na, nitu indji zan arbain bari ba kru nkon si gben u. Ba tan bre wa bana rji ko nda so kpena se ba wuu ri. Zizan me, ba ki si gben yowo nyime me.” ");
INSERT INTO jid_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Niki, kikle kaptin a a du vrenze a hi, hu gon yo tre niwu ndi, “Na hla ni ndrjo kpe wa wu vu bla nimu na.” ");
INSERT INTO jid_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Niki a yo ye ni kpama, bi lokpa Roma ha, nda tre, “Vu Soja deri ha nda du ba mla ki wu hi gban tsra ni Kasariya, baba bi hon nkma Sabain (Seventy) ngame mba indji deri ha bi ta wyen. Bi lu ku nkon ni nton wu tra ni chu luwa.” ");
INSERT INTO jid_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A yo tre bawu ngame duba nu nma wu zren wa Bulus ni hon nda njiwu hama ni ya hi nu Gona Felix. ");
INSERT INTO jid_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Niki a nha ni vunvu to yi: ");
INSERT INTO jid_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Claudius Lysias hi ni wa azan Gomna Felix, mi chiwu. ");
INSERT INTO jid_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yahudawa bana vu iguyi lo nda ta wuu kimba ri mi wru sru ni sojoji ndi ka kpaachuwo, nitu mi wo ndi a hi indjui wu meme Roma. ");
INSERT INTO jid_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mita son to kaa a hi ngye ba heni wu nituma, niki mi banw grji ka nu bison bi ninkon. ");
INSERT INTO jid_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mi ye wo ndi basi tsrau nitu du mba, i ndana he ni kpe wa ba vuu nu bi lo, duba wuu ko ka yoo ni kotro na. ");
INSERT INTO jid_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Niki ba ye bwu bla nimu ndi ba zontu wu ti meme nitu igu'a, niki hari mi tru ye niwu ndi yo tre ni biwa ba heni kpe nituma duba nji kpe wu lo a ye ni shishi me. Son pian me.” ");
INSERT INTO jid_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sojoji ba ba ba hu tre gbangban wa ba yo bawua. Ba ban Bulus nda niwu ni chua hi ni Anti patris. ");
INSERT INTO jid_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ni vi waaka hua, gbugbu sojoji babadon bi hon nkma ba duba niwu hi, i baba ba kma hi ni bubu mla bi son gbangban. ");
INSERT INTO jid_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Niwa bi hon nkma baka ri ni Kasariya nda ka nu vunvua ni gomn, ba ka Bulus nuu ngame. ");
INSERT INTO jid_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Niwa Gomna a bla vunvua, a mye ka Bulus rhini grji rime. Niwa a wo ndi a rhi ni Cilicia, ");
INSERT INTO jid_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","a tre ndi, “Bi tsro wo nitu me bata ye niwa, mi mla wowu, “Niki a yo tre zi gbangban ndi du ba hi ziu ni ko gomnati wu Herod. ");
INSERT INTO jid_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Niwa ivi ton aka hia, ninkon Prist Ananiyas, ni bi chiche, mba indji wu to tre ri, ni nde Tatulus, ba hi niki. Indji biyi ba nji kpe wa ba vu Bulus ni latre ye ni shishi gomna. ");
INSERT INTO jid_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Niwa Bulus a lu kri ni shishi gomna, Tatulus a lu si nhau nda tre ni gomna ndi, “Nitume ki he ni kikle sisron, mba to ko shishi me ani nji mla ti ndindi ni ye ni gbungblu mbu. ");
INSERT INTO jid_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nitu ki, ni shuni ngyiri ki kpa wawu kpiwa wuti, kikle wa a bizan wawu, Felix. ");
INSERT INTO jid_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nitu du mina ziu son gbame na, mi bre lo sron me ni du wo me wu nton fiime. ");
INSERT INTO jid_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kiye to ndi indji yi he to nhran mba wa ani du Yahudawa wawuu kagon gbungblu meme duba ni lukri nitu bi koshishi mba. Ahi ninkon wu biwa ba rjuki nkan nda yo kpamba ndi Nazarin. ");
INSERT INTO jid_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A ta son kpa hekalia ti rji, kima a duta vuu lo zi. / Nha vunvu bi sen bari ba kanha ndi, / Kita son ki gaatre nituma hu kpewa du mbu hla'a / ");
INSERT INTO jid_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nha bisen bari ba he ni nklan 7 mba mumla wu nklan 8, / 7 I Lysias, Ofisa, a ye ban u ni gbengble rju ni wo mbu, 8 nda yobi nha wu a duba ye ni wu. / ");
INSERT INTO jid_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Niwa wuta mye Bulus nitu tutre biyi, wu mla to kime nitu kpi biyi wa ki si nhanwu a. ");
INSERT INTO jid_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahudawa ba ngame ba zontu ni nhaw, ndani kpanyime ndi kpewa ba nhanu nituma ba njanji. ");
INSERT INTO jid_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","I niwa gomna a tini wo du Bulus tre, Bulus a saa ndi, “Mi mla to ndi wu zi gaatre ni meme mbu wu se gbugbuwu, nitu ki mi ngyiri niwa mi ngla tumu niwu. ");
INSERT INTO jid_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wu to kime ndi ana zan vi wlon don ha na rji niwa mi hon hi bre mba nzu Irji hon ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Niwa ba to me nimi hekali, mina sen nyu ni ndrjo na ndina kpa jbu ndji tsitu na, sinagog mba koka ni mi gbua na. ");
INSERT INTO jid_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bana mla tsro ndi ahi njanji kpe wa ba nhan me zizan nituma na. ");
INSERT INTO jid_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","I me bwu nhran niwu ndi, nitu nkon wabayo ndi bi rhuki nkan, ni nkon kima yi mi hu Irji wu ba titi mbu, mi kpanyime ni kpi wawu ni kpi wa a kri tsra ni du mba wa ba anabawa ba nhaa. ");
INSERT INTO jid_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi he ni yo sron riri ni Rji to indji biyi, ndi tashme he, ni bi kri nkon ndindi mba ni bi meme sron. ");
INSERT INTO jid_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Niki mi nwo nyu ni na he ni meme mren ni shishi Irji mba Indji na. ");
INSERT INTO jid_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Zizan, niwa se gbugbuwu ba ka hi, mi ye nu zaka mba ton ni meme mu. ");
INSERT INTO jid_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Niwa mi ti toki, Yahudawa bari, wa ba rhini Asiya, ba ye tome ni bubu ti gan wu ngla ni mi hekali, ana ni jbu indji ko ka ni mi kpagro wu tsitu na. ");
INSERT INTO jid_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ani na zan du indji biyi duba he ni shishi me zizan nda nha me, bati na he ni kperi. ");
INSERT INTO jid_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kaandi, du indji biyi me du ba hla kpe meme wa ba ye to nime, niwa mi kri ni shishi son bi ninkon Yahudawa, ");
INSERT INTO jid_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","hama nitu kpe ririyi, wa mi kpagro hla niwa mi kri nimi mba, “A he nitu tashme rjini kwu wa mi kri ni tsra nituki ni shishime luwa.” ");
INSERT INTO jid_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Niki Felix, waana to bi nitu nkon'a, a nzu wo trea hi ko shishi. A tre ndi, “Lysias Komanda, anita grji ye rjini Urushelima, mi ya tre me toh.” ");
INSERT INTO jid_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Niki a mmha sojoi (Centurion) ndi duba nji Bulus hi ri zi, nda duuta fon fu ngyngyu, nda na nzu kpukpan ma du ba ye zoo ni kpi wa ani son na . ");
INSERT INTO jid_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hu gon vi bari, Felix a kma ye mba iwama Drusilla, wa ana bi Yahudawa, nda ton ba ka yo Bulus, i ba wo rhinuwu nitu kri gbangban sron ni Kristi Yesu. ");
INSERT INTO jid_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","I niwa Bulus shlesiya niwu nitu Krista tsra, mla kpa nji, mba gaatre wu ye, Felix a ku ti sissri nda tre ndi, “Hi kpame zizan, Mita he ni nton ni ko shishi mi ton ba hi yowu.” ");
INSERT INTO jid_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ni nton kima me ata yo sron ka Bulus ni nu nklen, niki a ta gbla you nda ye tre niwu. ");
INSERT INTO jid_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Niwa ise ha baka hi, Porcius Festus a hon ni ruron gomna hugon Felix, i Felix a ta son kpa ya nyime ni Yahudawa ba, niki a don Bulus ni lo. ");
INSERT INTO jid_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Zizan Festus a rini Lardia, i vi tra a ka hi, a zren rji ni Kasariya nda ka ri ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kikle Prist baba bi ninkon kri nimi Yahudawa, ba nji tre wu wa tro nitu Bulus, nda mye Festus ");
INSERT INTO jid_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ni bre ndi du ya ba ni lo sron nitu Bulus, - ndi du yo ye ni Urushelima, nitu ba sia wan nkon wa ba wuu ni ya ybi ni nkon ye. ");
INSERT INTO jid_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus a sa bawu ndi ba vu Bulus lo zi ni Kasariya, i wawu me ana ni gbron nkon na, ani hiniki. ");
INSERT INTO jid_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Nitu ki, biwa ba he ni nkon hi,” a tre, “baka huta hiki. Ikpe memenita he nitu iguyi, bika ye nhawu.” ");
INSERT INTO jid_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus a sonwu vi tandra hi wlon nda lu grji hi ni Kasariya, i ni vi wu huki, a kuson ni ruron gaatre nda nduba yo Bulus nji wu ye niwu. ");
INSERT INTO jid_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Niwa a ye'a, Yahudawa rjini Urushelima ba ki whi niki, nda nji gbugbu kpi bi gbengblen ye nhawu ndana to nkon u low ni bana. ");
INSERT INTO jid_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulus a ngla kpama nda tre ndi, “Mina ti kpe wu latre nitu iduu wu Yahudawa, ko ka ni hekali na, mba ka ni siza na.” ");
INSERT INTO jid_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","U Festus a ta son kpa nyime ni Yahudawa, kimayi ndu Bulus tre ndi, “Wu son hon hi ni Urushelima du mi hi gaatre ni tu kpi biyi niki?” ");
INSERT INTO jid_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulus a tre ndi, “Mi kri ni shishi ruron gaatre Siza, ni bubu wa ani wo tre mu.” Mina ti kpe meme ni Yahudawa na, me wa wume wu to. ");
INSERT INTO jid_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mita na ti kpe meme mba mita ti kpe wa a tsra dumi kwu, mina kamu ni kwu na. I nha mba na kpe na, du ndrjo na kame chuwo ni bawu na. Mi bre kri ni shishi Siza.” ");
INSERT INTO jid_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hu gon wa Festus ba tre baba bi son bi ninkon ba, a sa niwu ndi, “Wu bre ndi wu son kri ni shishi Siza, Ni shishi Siza mba wu hi!” ");
INSERT INTO jid_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Zizan, hu vi bari, Ichu agrippa mba Bernice ba ye ri ni Kasariya, nitu ye zren ya ndu wu Festus. ");
INSERT INTO jid_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Niwa ba heniki wu bi gbugbuwu, Festus a nji tre Bulus ye ni Ichua; a tre ndi, “Felix a ka igu ri don nigon nimi kotro. ");
INSERT INTO jid_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Niwa mina hi ni Urushelima, ninkon Prists baba bi chiche Yahudawa ba nji tre ye nha nitu igu yi nimu, nda wa dumi lo wu kwu ni bawu. ");
INSERT INTO jid_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mi sa bawu ndi a na he ni nkon wu hu bi Roma du ba ka ndrjo nu hama ni indji wa ba nhawu ka kri bla ni shishi biwa ba nhau a, nitu du to ngla tuma ni kpi wa ba nhau ni wua. ");
INSERT INTO jid_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nituki, niwa ba ye wawumba ni wayi, mina gben na, nivi wu hukima, mi son ni ruron gaatrea ni ton du ba nji igua ye. ");
INSERT INTO jid_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Niwa bi nhanwuba ba lu kri, bana nhawu ni kpe wa mi ban ndi a hi meme dri na. ");
INSERT INTO jid_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Hama ki, ba sia hlo nyu ni wu nitu nkon hu Irji mba mba nitu indji ri Yesu wa a kwu ye, wa Bulus ni ban di a he ni sisren. ");
INSERT INTO jid_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mina to nkon wu hu ri shle tu tre yi na, niki mi myeu ka anison hi ni Urushelima, nda hi ngla tuma ni nha tre biyi. ");
INSERT INTO jid_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","I wa Bulus a bre ndi ki don zi ni bubu tro, nitu du gben kpe wa kikle ninkon wawu ani ban ni tuma. Mi du ba ziu ni tro ni du mi ka tru hi ni Kaisar.” ");
INSERT INTO jid_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa a tre ni Festus, “Mi son wo igu'a ngame.” “Imble,” Festus a hla, “wu woo wu.” ");
INSERT INTO jid_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Niki ni vi wu hua, Agrippa mba Bernice ba ye ni kikle gan; nda ye ri ni mi ko sona ni ninkon sojoji baba kikle indji bi gbua. Niwa Festus a lu tre du ba hi njiwu ye, baka nji Bulus ye. ");
INSERT INTO jid_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus a tre ndi, “Ichu Agrippa, ni ba ndji me wawuu wa ba he niwa nitaa, wuto indji yi, ni Urushelima mba ni wayi ngame, i ba kpagro ndi du na la son ni sisren na. ");
INSERT INTO jid_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mi ya nito ndi anati kpe wa a tsra wu kwu na, i nitu wa a bre ndi du wawu hi ni shishi emperor wawu, mi ban zi ndi mi tru hi niwu. ");
INSERT INTO jid_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Niki mina he ni kpe tsatsra wa mi nha ni Bachi mu na. Nitu ki, mi njiwu ye ni wu, iwu Ichu Agrippa, nitu du mi kpa kpe wa mi nha nitu trea. ");
INSERT INTO jid_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A rjuto ana he nituma du me tru indji wa a he ni lo hama ni hla ngame nhan wa a heni tumaa.” ");
INSERT INTO jid_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Niki Agrippa a tre ni Bulus, “Wu ka tre kime.” Nikima Bulus a nmerju ni woma nda lu tre wu kpa tuma chuwo. ");
INSERT INTO jid_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mi ban ndi mi ngyiri ni kpamu, Ichu Agrippa, ni wa mi nji tre mu niye ni shishime luwa, nitu wawu kpi meme wa Yahudawa ba nji ye nha nimu niwuu; ");
INSERT INTO jid_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","kima me nitu wu to zan tu ni tu nkon zren Yahudawa rhini sen. Niki, mi bre du u wome ni kru sron. ");
INSERT INTO jid_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Njanji, Yahudawa wawu ba to zren son mu rhini wa mi vren nze ni meme mu mba ni Urushelima. ");
INSERT INTO jid_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ba to nitumu rhini ni mumla, batini son nyme niki, nitu mison na Farasii, grji bi kri gbangban ni nkon hu Irji mbu. ");
INSERT INTO jid_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Zizan mi kri ni wayi du ba gaatre nimu nitu yo sron mu ni yo sron kpe ni shishi wa Irji a ti ni ba titi mbu. ");
INSERT INTO jid_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","A he nitu yo sron kpe ni shishi wa ba grji wlon don ha ba ba yo sron wu kpa niwa ba nzu nde Irji hon ni chu mba ni virhi. Wa a he nitu yo sron a, Ichu Yahudawa ba ban nha me. ");
INSERT INTO jid_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A ngye nizu du mla ya ni kpanyme ndi Irji ni nzu indji lu rjini kwu? ");
INSERT INTO jid_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Zizan, a toki, Ime me mina ta mren ndi mi ti kpi gbugbuwu nitu ka nde Yesu wu Nazarat su. ");
INSERT INTO jid_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mi ti kpi biyi ni Urushelima, Mi vu loyo ni mi tratro gbugbu indji tsatsra wu Irji, ni vunvu kpanyme wa mi kpa rhini ninkon Prist, mba niwa ba sia wuuba, mi yo wo nyime mu nitu kima. ");
INSERT INTO jid_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi ti ba ya, nton gbugbuwu ni mi Sinagog, mba ni ta tsra yoba ni gbengblen du ba tre meme ntiu Irji. Mi ta vra ni nfu nitumba, mba nini tiba ya ka rhini igbu wu meme bari. ");
INSERT INTO jid_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Niwa mi sia ti toyi, mi hini Damaskus ni yawo kpanyme mba nu nkon rhini kikle Prist; ");
INSERT INTO jid_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","mba ni nkon, hiki, ni tsutsu irji, ichu, mi to kpan lu rjini shulu wa a kpan zan irji, nda bwu kpan kagon me baba indji biwa bana si zren hume. ");
INSERT INTO jid_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Niwa wawumbu ki kurjoku ni meme mi wo ilan ni tre ni me ni ilbe Ibraniyawa ndi Shawulu, Shawulu, u i tie me ya nitu ngye? A ni he ni ya ni du chuza too kpe wu ntsen nyu. ");
INSERT INTO jid_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Niki mi tre ndi, “Wu nha, Bachi?” I Bachi a sa mu ndi, 'A hi me Yesu wa wu si tiwu ya. ");
INSERT INTO jid_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Zizan lu kri ni zande; anitu ndu yi mi tsro kpamu niwu, nitu youyo ni tindu vrenko, mba wa wu vu bla nitu kpi wa wuto nitumu zizan mba kpi wa mi tsro ni ko shishi; ");
INSERT INTO jid_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","i mi kpau chuwo rhini wo indji ba mba rjini Bikora wa mi si ton ni hi niba, ");
INSERT INTO jid_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ni du hi bwu shishi mba, ndi kma ba sran rjini bwu hini kpan mba rjini son niwobrji shango hini Irji, ni du ba kpa rjini Irji, kpa wru latre mba (gado) wa mi nu ibiwa ba kri bi nitu kpanyme ni me. ");
INSERT INTO jid_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ni tu kima, Ichu Agrippa, mina kamu ni hutre ira wa a rjini shulu na; ");
INSERT INTO jid_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mi hi ni bi Damaskus guchi, nda ka ri ni Urushelima, nda ka kagon gbungblu Judiya, mba ni bikora ngame, mi nu ba tondua, nitu du ba kma sran nda kma ye ni Irji, nda ti ndu wa a bi tsra ni kma sran sron mba. ");
INSERT INTO jid_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nitu kima Yahudawa ba vu me lo nimi hekali nda ta son wuu me. ");
INSERT INTO jid_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ni kima, me kpa zo wa a ye rji ni Irji, ye ni vi wu luwa, ndi ni kri ni nran hla ni bi tsitsa baba bi kikle ana kpe nkan na, hama niwa anabawa mba Musa ba tre ndi naiye he toki - ");
INSERT INTO jid_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ndi Kristi niye ti ya, nitu wawuyi ni guchi tashme rjini kwu, ndani bwuhla ikpan ni indji mbu mba ni bi kora.” ");
INSERT INTO jid_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Niwa Bulus akle ngla kpama a, Festus a tre ni kikle lan, “Bulus, wu sran; to gbugbu tsro me du ni sran.” ");
INSERT INTO jid_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","I Bulus a tre ndi, “Mina sran na, wa azan bi Festus, mi si dbu bla lan tre wu njanji mba wu gaatre ndindi. ");
INSERT INTO jid_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nitu Ichu to kpi biyi; niki mi tre ni gbengblen sron niwu, nitu mi nyme pempe ndi kpi biyi bana he ni bwu ni wu na, nitu ikpe biyi bana tiba ni kosan na. ");
INSERT INTO jid_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wu kpanyme ni anabawa ba, Ichu Agrippa? Mi to ndi wu kpanyme.” ");
INSERT INTO jid_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa hla ni Bulus nid, ni nton fiime toyi, wu son gbronmeyo dumi kma ti Krista?” ");
INSERT INTO jid_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus tre ndi, “Mi bre Irji ndi, anita nton fiime ka wu gbron me ana wu megen na, mba wawu biwa ba wo me luwa, du ba he too me, hama ni rjiri ij'bo wu ko tro yi.” ");
INSERT INTO jid_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Niki Ichua lunde kri, i gomna mba Bernice ngame, baba biwa bana ki niba. ");
INSERT INTO jid_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Niwa ba rju don kikle tra u son mba, ba si tre ni kpamba ndi, “Igu yi na ti kpe wa ani tsra u kwu ko ka u lo zi na.” ");
INSERT INTO jid_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa a tre ni Festus ndi, kinina chu Iguyi chuwo hama wa ana bre hi to Kaisar.” ");
INSERT INTO jid_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Niwa ba ban zi ndi duta zren hi ni Itali, ba vu ba Bulus baba bi son nitro bari yo ni wo soja wani nji deri ri, wa ndema hi Julius, wu ngbran soja u kikle chu. ");
INSERT INTO jid_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ki ri nimi Jirgima rjini Adramyttium wa a ta dran zu ni nyu meme wu Asiya. Niki ki ka hon tuma. Aristarkus wa a rjini Tesalonika wu Macedonia a zren huta. ");
INSERT INTO jid_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ni vi wu huki, ki kukri ni kikle gbu u Sidon, niwa Julius a mla Bulus nji nda duu hi ka to kpukpan ma nda kpa zo ni wo mba. ");
INSERT INTO jid_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Rji niki, ki hon tu ma ndi zren ni suka wu Cyprus, whewhire ni nklan memea, nitu kikle ngyungyu ata gbita. ");
INSERT INTO jid_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Niwa ki zren ka rugran kpatema'a, ki vu Silisia mba Pamphylia yba, ndi ka kukri ni Myra, kikle gbu u Lycia. ");
INSERT INTO jid_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Niki, soja wu yaba, a to jirgi wa a rji ni Alexandria nda ni dran hini Itali. A vuta sru nimi. ");
INSERT INTO jid_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Niwa sren me wu vi gbugbuwu ndi ka ri ni ya ni klekle whewhire ni Cnidus, mba wa ngyungyu'a ana nuba nkon zu niki ngana ki dran zu ni suuka u Crete, wa ata ya Salmone. ");
INSERT INTO jid_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ki dran zu ni nyu kpatre ma'a nimi ya, rhini ka ye tra ni buburi wa ba yo ndi Fair Havens (bubu u kurhi) wandi a he hwehwire ni kikle gbu u Lasea. ");
INSERT INTO jid_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kina ban nton wa a fon bran ye, nton wu ka rhikpe Yahudawa aka hiye wa a he ni di duta si dran hi. Niki, Bulus a gbiton ni bawu, ");
INSERT INTO jid_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","nda tre ndi, “Indji, Mi si to ndi zren dran wa ki son luku zizan anihe ni yra tu mba-kurjoku gbugbuwu ni tawu, ana ni kpi bi mi jirgi mba jirgi'a megen na, i mba vri son kpambu ngame.” ");
INSERT INTO jid_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","I Centurion a yo ton ni tiko mba indji wu jirgia zan kpi wa Bulus a hla a. ");
INSERT INTO jid_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nitu bubu mla kri jirgia ana he ni idi duba ki ti iga niki, gbugbu bi tru (tindu) jirgia ba nron ndi du ba dran rju niki, mba ndi nkon nita he duba hi ri ni gbu Phoenix, nda hi son kle ga niki. Phoenix hi hloma wu ri jirgia wa a he ni Crete, ndani ya kogbo ni yalu mba koshu ni yalu. ");
INSERT INTO jid_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Niwa ngyungyu ri ni kogbo a lu si fu sesren, bi ndu jirgia ba ban ndi ba he wa ba waa. U baka si nkan u jirgia nda dran hi ni Crete hwehwire ni meme u nyu maa. ");
INSERT INTO jid_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Niwa nton fyi aka hi kikle ngyungyu wu gbengblen, wa ba yondi koshu kahi ni nzu Irji, a lu si tsi ni grji rjini nklan memea. ");
INSERT INTO jid_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Niwa jirgia a rini nkon ngyungyua, nda na la to nkon wu zuhi na, kitome ni nu ngyungyua nkon, wa a gbita si hi. ");
INSERT INTO jid_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ki dran hu ni bubu ri wu vi nklan meme wa ba yondi Cauda, mba ni vi ya, ki vu ghwu wu kpachuwo mla lo zi. ");
INSERT INTO jid_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Niwa ba nzu ghwua hon, ba tindu ni rjirjima nda lo kikle jirgia. Ba ti sissri nitu bama hi dran hi vu nhan kmu wu Syrtis; niki ba fon gri ni l'pn (anchor) jirgia nda si hu zren maa. ");
INSERT INTO jid_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kikle ngyungyu a tsi ta tiya nda duta nivi huka hua, ki ri vuu kpi nimi jirgia ni sru nimi mma. ");
INSERT INTO jid_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nivi u tra bi tindu mi jirgi ba vu kpi ndu mba vra hle nimi mma ni womba. ");
INSERT INTO jid_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Niwa Irji mba tsintse bana kpan nitawu wu vi gbugbuwu, mba wa kikle ngyungyu a ri si fu ta, yo sron ndi ki nawo a kado. ");
INSERT INTO jid_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Niwa ba hi hama ni biri wu nton bran, niki Bulus a lu kri nimi bi tindu ba nda tre ndi, “Indji, binina wo me, nina kuu dran rjini Crete na, nitu du yi na kpa nkpan mba kahle yina. ");
INSERT INTO jid_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Zizan mi nron yi nitu du yi he ni gbengblen sron, ndrjo na ka he ni vri mana, i jirgia megen ki hon u. ");
INSERT INTO jid_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ni chu la rhen Maleka u Irji wa me mi u ma, wa mi nzu hon ni bre - Maleka ma a whi nime ");
INSERT INTO jid_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nda tre ndi, “Na ti sissri na, Bulus. Wu hi kri ni shishi Caesar, ni to indji ni lo sron ma a nu wawu indji wa ba si dran ni wu.” ");
INSERT INTO jid_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nitu ki, vu sron, indji, nitu mi nyme ni Irji ndi a niye he to wa ba hla mua. ");
INSERT INTO jid_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","I ki zi hle ni nklan meme ri.” ");
INSERT INTO jid_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ni chu wu vi wu wlon don nza a yea, niwa a sia gbita hi ni wa mba nia mu ni kpatrema wu Adriatic, ni tsutsu chu bi ndu jirgima ba ban ya ndi ba sia ye hwehwire ni meme. ");
INSERT INTO jid_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ba ban ya ni ikpi ndu mba nda to ndi a don tsra za tso don tandra (20), i hu nton fii ba la tsra nda to ndi a hi za wlon don ton. ");
INSERT INTO jid_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ba tie sissri ndi ki ye kurjoku nzi kpa ni tita, niki ba si nkan nzia wu jirgi rjini tu ma nda bre ndi du mble kpan gbagbla. ");
INSERT INTO jid_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bi tindu nimi jirgi ba sia ya nkon u ka jirgia don nda si vi tsitsa irgi'a chuwo grji ri nimi kpan tren maa nda ta gyru ndi basi ta nkan ghu'a ri ni ko shishi ma (ghu'a). ");
INSERT INTO jid_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","I Bulus a tre ni chubiku baba sojoji ba, “Indji biyi batina kinimi jirgia na, ba na nawo na.” ");
INSERT INTO jid_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Niki sojoji ba ba sren rjiri wu tsitsa jirgia nda duu zren hi. ");
INSERT INTO jid_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Niwa mble asi kpan niye, Bulus a nronba wawumba ndi duba rhi biri. A tre ndi, luwa hi vi wu wlon don nza wa bi zi kri gben hama ni rhi biri - bina rhi kpe na. ");
INSERT INTO jid_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Niki mi yoyi ni du yi ga vi biri, kima yi ni kpayi chuwo. Nitu indji ri me nimimbi na wa wlo nfutu ma ri hama nituma na.” ");
INSERT INTO jid_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Niwa a tre toyi kle, a ban bredi nda ngyiri ni Irji ni shishi mba. Niki a nzi bredia nda lu si tan (rhi). ");
INSERT INTO jid_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Niki wawumba ba kri ti gbengblen sron nda ban biri rhi ngame. ");
INSERT INTO jid_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kina vri indji 276 (deri ha ni sabain don tanne) ni mi jirgia. ");
INSERT INTO jid_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Niwa ba rhi wrji, ba ju alkama vra hle ni kpan trema nitu du jirgi na ron bran na. ");
INSERT INTO jid_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Niwa mble a nhra, bana mla to memea na, i ba to kofron ri ni meme nyu ma, nda sronmu ndi koka duba tru jirgia hi niki. ");
INSERT INTO jid_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Niki ba han rjirji nkan ba rju nda kaba don ni kpantre ma'a. Ni nton kima ngame ba si rjirji wa ba kma jirgia niwu, nda nzu nkanwu ko shishi jirgia hon his shu, niki ba yo tu hi ni bubu zontu kpantre maa. ");
INSERT INTO jid_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","I jirgia a ka son chi ni meme nda kukri nkpan jirgia a vu meme kri nda na chu zren na i kurar jirgi a nzi nitu gbengblen ngyungyu wa a hea. ");
INSERT INTO jid_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sojoi ba ba wa nkon wu wuu bi mitro ba nitu du rimba na dran hi nda nawo na. ");
INSERT INTO jid_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","I Chu bi kua ata son kpa Bulus chuwo, niki a zuba ni nkon kima, nda du biwa ba to dran du ba za guchi nda hi ni bubu meme. ");
INSERT INTO jid_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","I imbru indji ba baka hugon, bari nitu ngma bla kunkron, i bari nitu kpi bari rjini jirgia. Ni nkon yi a he ndi wawu mbu kika ri ni tu meme piame. ");
INSERT INTO jid_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Niwa ba nji ta ye ri pian me, ki wo ndi ba yo nklan meme ki ndi Malta. ");
INSERT INTO jid_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Indji bi son niki ba kpata nisron ndindi nda mulu nitawu duta mbru kpa nitu ilu chachu mba isi wa a he niki. ");
INSERT INTO jid_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Niwa Bulus a vu fla kunkron zontu zi nda vu sa nitu lua, iwan a rju nitu gbaji lua nda ye nye wu ni wo. ");
INSERT INTO jid_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Niwa indji bi bubuki ba to nma si klo ni woma, ba tre ni kpamba, “Indji yi, wu njanji, ani wuu ndji niwa a nawo rjini kpan trema, i gaatre na kpanyme ndi du son ni sisren na.” ");
INSERT INTO jid_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","I niki a kpon nma yo nimi lu'a hama ni du kpe tiwu. ");
INSERT INTO jid_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ba sia gben ndi ani hwukpa ni lilo ko ka lu kurjoku khwu. U niwa ba ki si yau wu gbron nton nda to ndi ikpe meme na ti'una, ba kma sron mba sran nda tre ndi a hi Irji. ");
INSERT INTO jid_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Zizan, whiniki, bubu meme bari a he wa bana bi chu wu nklan memeki, igu wa ba yondi Publius. A kpa ta bi ni wo ha, nda nuba kpi wa ba son wu vi tra. ");
INSERT INTO jid_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A he niki, iti Publius a kru lilo lokpa mba atini. Niwa Bulus a hi niwu, a bre, yowo ma nitu ma, nda nuu si kpama. ");
INSERT INTO jid_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hu kpe yi wa a ye he a, mbru indji bi nklan meme ki ba wa basia lo, ba ngame nda ye kpa sikpa mba. ");
INSERT INTO jid_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Indji ba ngame ba nzu hon gbugbuwu. Niwa kita mla ku nkon dran, ba nuta kpi wa ki son a. ");
INSERT INTO jid_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Niwa wha tre a ka hi, ki dran ni jirgi mma wa a kru ga ni nklan meme ki, jirgi mma wu Alexandria, ni nha to “hlan-ha irji” ni kbu shishima. ");
INSERT INTO jid_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ka huki, ki ye grji ki ni gbu Sirakus, ki kii niki wu vi tra. ");
INSERT INTO jid_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Rji niki ki dran ka ri ni mi gbu u Rhegium. Ivi rhi ka hi kikle ngyungyu a rju rji ni kosan, u ni mi vi hari ki ye rhi ni mi gbu u Puteoli. ");
INSERT INTO jid_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Niki, ki to mri vayi bari i ba yo ta duta ye son niba wu vi tangban. Ni nkon kii ki ye ri ni Roma. ");
INSERT INTO jid_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rji niki, wa mri vayi ba ba wo tre nitu mbu, baye zontu nita gbagban mu to rhini cucu Abiyas mba iti tra bru tra. Niwa Bulus a to mri vayi ba, a ngyiri ni Irji nda ti gbengblen. ");
INSERT INTO jid_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Niwa ki rini mi Roma, ba kpanyme ni Bulus du son ni nklenma mba soja wa ata kri yau. ");
INSERT INTO jid_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Niki a ye he wa ivi tra aka hi, Bulus a yo indji wa bana bi ninkon Yahudawa zi. Niwa ba ye zontu ki, a tre niba ndi “Mri vayi, hama ndi mina ti kpe meme nitu indji ko ka nkon son ba titimbu, ba vu me lo nu ba tro rjini Urushelima ye ri ni wo bi Roma. ");
INSERT INTO jid_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Hugon myeme tre, ba ta son chume chuwo, nitu bana to kpe wa ba han hukunchi kwu ni tu tre mu. ");
INSERT INTO jid_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","I niwa Yahudawa ba tre hu nkon wa bana ta son na, a du me bre to Kaisar, ana nitu mi sia nji nhakpe nitu bi meme mu na. ");
INSERT INTO jid_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nitu kima yi, mi wa tou ni tre niwu, nitu yo sron wa Israila ba he niwu'a du me he nimi lo sarka hi.” ");
INSERT INTO jid_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mle, ba tre niwu ndi, 'Kina kpa vunvu nha rjini Judiya nitume na, i vayi ri mena ye njitre, koka trekpe meme nitume na. ");
INSERT INTO jid_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama kison wo rjini wu mren me nitu igrji yi, nitu ki to ndi ba tre meme kaagon nitu ma.” ");
INSERT INTO jid_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Niwa ba yo vi niwu, indji gbugbuwu bari ba ye niwu, ni bubu son ma. A bhwu hla tu trea ni bawu, nda ni vubla nitu ikoson Irji. A ta son gbron sron mba yo rjini du Musa mba rjini anabawa ba, rjini mble kari ni yalu. ");
INSERT INTO jid_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bari ba kpanyme ni kpiwa ki tre ni tumba, i bari bana kpanyme na. ");
INSERT INTO jid_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Niwa bana kpany'me ni kpamba na, ba hi kpamba hu wa Bulus a tre lan tre riri yi. “Ibrji Tsatsra a tre bi, zuni nyu anabawa baba manzani ba hi ni ba titimbi. ");
INSERT INTO jid_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","A tre ndi, hi ni indji biyi ndi hi hla ndi, “Ni si wo, bi wo, i bina to tuma na; mba nisi to bi to, i bina to nkon ma na. ");
INSERT INTO jid_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nitu dri indji biyi a ti bwu, mba ni iton mba, bana mla wo na, mba ba kaa shishi mba hama ki ba ma to ni shishi mba, nda wo ni iton mba, nda to tuma ni dri mba nda kma sran ngari, i mi nuba sikpa.'” ");
INSERT INTO jid_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Nitu kima, bika to ndi kpachuwo Irji yi, ba truu hini bikora ba, i ba wo'u.” ");
INSERT INTO jid_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ndu Manzani, 28:29 - tre vunvu bari wu sen ba heni nklan 29: / Niwa a tre kpi biyi, Yahudawa ba ba hi kpamba. Ba sia he ni kikle sen nyu ni kpamba. / ");
INSERT INTO jid_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus a son wu se ha wawu ni kowa a han nklen ki kima, nda ta kpa ni wo ha, biwa ba ye niwu'a. ");
INSERT INTO jid_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A sia dbu bla nitu ikoson Irji nda ta tsro ikpi nitu Bachi Yesu Kristi ni gbengblen sron hama ni ndrjo ata zuu. ");
INSERT INTO jid_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bulus vren koh Yesu Almasihu, wa ba you aye, kma tie ndji u toh ndu, wa ba chu zi kan nitu tre Irji. ");
INSERT INTO jid_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Wa i hi tre wa a chu nyu ni sen mu ni bi toh ndu ma ni tsatsraka ibe ma. ");
INSERT INTO jid_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ahe ni tu vren ma, wa ba ngrji'u ni kutra kahlan Dauda ni kpa. ");
INSERT INTO jid_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ni Brji ndindima u suron ndindi, wa a lunde ni mi be bak tsro da Vren Irji ni gbengblen Ibrji ndindi u bi wa ba he kiklan suron u Yesu Almasihu Bachi mbu ");
INSERT INTO jid_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ni tuma ki kpa ndindi ni toh ndu nitu kpa nyime u ndindi nimi bi korah wawu'u, nitu inde ma u ndindi. ");
INSERT INTO jid_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ni mi bi kora kwa, bi yi me ba you yi hi ni Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Lbe i ahi u bi wawu'u bi wa bi he ni mi Roman, wa Irji ni son ba, wa ba you ndji mba ndi tsarkaku. Du ndindi ni sun si rji ni Irji Bachi Iti mbu, ni Bachi Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ikpe u mumla misi ngyiri ni Irji mu ni tu Yesu Almasihu nitu bi wawu'u, don naki basi tre nitu njanji bi ni gbungblu wawu'u. ");
INSERT INTO jid_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Don Irji wawu yi toh me, wa misi tie ndu ma ni mi Ruhu mu ni tre Vren Ma, wa mi you nde bi chachu'u. ");
INSERT INTO jid_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mi nji yi mu ni bre chachu'u du me toh koh wa mi ye u Hellinawa. ");
INSERT INTO jid_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nakima Irji na hi u tara na. ");
INSERT INTO jid_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ni biwa ba lah tre ni tron na, ba kwu ba tare da tron na, ni bi wa ba lah tre ni mi tron, ba hukunta ba nitu tron. ");
INSERT INTO jid_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Naki ma ana biwa ba wo tron, ana baba bi ndindi u Irji na, naki bi ti, ba kpa ba chuwo. ");
INSERT INTO jid_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Bi kora wa bana toh tron na, nitu da bia bati kpi wa ahi u tron. ");
INSERT INTO jid_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nakima ba tsro ndi idu ni tron ani wa han ni suron ba, imre ba ni bla, ri mre ba ni chan ba ko ani ka'aba. Nakima ni Irji wa i ni ti ni vie wa Irji ni bla asiri wa he riri u bi he ni mi Roma ");
INSERT INTO jid_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nakima isha na time na, dume hla tre na, don kima hi gbengblen Irji don kpachuwo wa bi wa ba kpa nyime, bi mumla Yahudawa u Halleniyawa. ");
INSERT INTO jid_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Naki nimi ma ndindi Irji ka tsro u njanji hi ni njanji, na ba nha zi, ndji u ndindi ani sun nitu njanji. ");
INSERT INTO jid_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nakima infu Irji a tsro rji ni shu nitu bi wa bana hu nkon ni ndindi u mri Adamu bi wa ba chan njanji nitu njanji na he ni bana. ");
INSERT INTO jid_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nakima, ikpe wa a mla duba toh ni Irji ahe ni rira me nitu mba Naki ma Irji a tsro ba wawu hi zahiri. ");
INSERT INTO jid_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nakima idu ma wa bana ya toh na a ni rira ba he tu ni nton wa ati gbungblu'a. Ba ya toh ba nitu ikpi bi wa ati'a. Ikpi bi yi baba ba ikoma u kakle ni Allahtakarsa. Nakima indji bi bana he ni sen nyu na. ");
INSERT INTO jid_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nakima ba ndji ba toh Irji, aman bana no ninkon u matsayi Irji na, ko duba tsro ingyiri. Nakima ba kma ti ruru ni mi mre mba. Imre u suron mba hi u bu. ");
INSERT INTO jid_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba ban tumba na bi wa ba toh, aman se ba kma tie ruru. ");
INSERT INTO jid_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ba sran ninkon Irji u kakle ni kpi wa bana kakle ana na indji, cicen ni na nma bi zizia ni biwa ba nha ni ne. ");
INSERT INTO jid_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nakima Irji ka ban no sha'awa pipi suron mba ba ti kpa yah. ");
INSERT INTO jid_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Baba yi ba sran njanji Irji ni che, ba si tie sujada ni bauta ni kpe wa ba tie ba ni wo, maimako wa ati ta, wa a mla zu nde kakle. ");
INSERT INTO jid_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nakima Irji ban ba no sha'awoyi u ti fa ba iyah har mbah ba kasran kaida jima hi mbah ni mbah. ");
INSERT INTO jid_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Lilon ba bame ba sran kaida jimai u lilon ni mbah hi ni lilon ni lilon ba si tie ndu fa. Lilon ba kru ni lilon nda ni tie kpi u chi basi chan sakamako indu mba u chi. ");
INSERT INTO jid_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nakima bana kpa nyime ni Irji na ni mi duba, Irji ban ba no ni kpa risu ni mre mba, basi tie meme kpi biyi. ");
INSERT INTO jid_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ba shu ni rashi ndindi, meme kyashi, keta, tigu, wudi, wa-nyu, makirci, ni meme mre. ");
INSERT INTO jid_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bi ti pre, kage, bi wa bana son Irji na. Bi wa bana son sun si na, bi santu, ni bi gla, bi ha meme che, ni bi wa bana hu/wo ba ti/yi mba. ");
INSERT INTO jid_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Biwa isuron mba tsro pipi me, biri amana biwa bana he ni son na, bi wa bana he ni lo suron na. ");
INSERT INTO jid_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ba toh tsari Irji tre bi wa bati ikpi baki, ba mla kwu, ana ti kpi ni kangrji na, hra ba hu gon biwa bati ba. ");
INSERT INTO jid_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nakima u na he ni sen nyu wu ndji u sharantawa, Nakima ikpi wa u si sharantawa nitu bari, u wuu tume ni tume. Nakima u sharantawa u si tie kpi bi yi ngame. ");
INSERT INTO jid_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Naki ki toh ndji i tron Irji a njanji ani ye joku ni biwa ba ti kpie baki. ");
INSERT INTO jid_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nakima ka toh wayi wu indji u sharanta ni biwa ti kpii, wume wu si ti me. Wu yah ndi wu gbujbu ni nfu Irji? ");
INSERT INTO jid_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ko wu kpa ndindima tsri wa infu ma ni vu suron ana ye gbagbla na? Wuna toh ndji ndindima musama du nji wu hi ni ti njanji? ");
INSERT INTO jid_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Aman sabo ni son tume ni suron me wa ana tie njanji na, wu si vu'u nfu ni sru ni tume ni vie u nfu, wato ivie u ye tron njanji u Irji. ");
INSERT INTO jid_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Mi no ko nha ndi dede du ma wa ati'a. ");
INSERT INTO jid_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ni bi wa ba you suron ni tie ndindi chachu'u ba wa nitu zu wo daraja ni drie u kakle. ");
INSERT INTO jid_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Naki bi wa ba son tu, ni bi wa ba kamba ni njanji, ba ti biyaya ni rashi njanji, infu ni nfu rigra ni grji ni bawu. ");
INSERT INTO jid_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Irji ni grji ni iya meme ni shinji ne bi vri wawu wa bati meme, ni Yahudawa ni muimla ni Hellinawa. ");
INSERT INTO jid_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nakima zuwo ni daraja ni sun si ba he ni bi wa basi ti ndu ndindi wa wu bawu, ni Yahudawa ni mumla, ni yi ni kpa nyime Irji. ");
INSERT INTO jid_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Mi ti titan toh yi, don mini noyi baiwa ri u ruhaniya mi ni noyi gbengblen. ");
INSERT INTO jid_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wato misi ngyiri mi ni kpa gbengblen ni mi bi u njanji mbu wato u mu, u bi. ");
INSERT INTO jid_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ziza'a fa mina son du yi ka toh mri ya kpo gbugbu'u mi you suron ndi mi ye ni yi, naki har zizan'a koh na he na. Mi son ndi miti nakima, don mi ni samu mri u Ruhu ndindi ni mi mbi, na ahe ni mbru bi kora. ");
INSERT INTO jid_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mi ban yah Helinawa ni baba u mbru ndji bi toh ni bi wa bana toh na. ");
INSERT INTO jid_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ni naki tie mba rju he ni kora ndi tron'a he nimi suron mba. U mi dri mba ngame ahi sheda ni bawu, u tunani mba ko ka vu ba ni meme ko ka kri ngba ni bawu ");
INSERT INTO jid_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","u ni Irji ngame. Ani he naki ni vi wa Irji ni rju ni mi dri ba ndji wawu'u ni kora, ni tu nkon u tre Ma, ni Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nakima wu si you tume ndi wu uhi Bayahude, wu sun ni tu tron, ndi ni wru wo ni san ni mi Irji. ");
INSERT INTO jid_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Wu toh mre ma, ndi toh kpi wa ba he ni nkanka naki, kuma u kpa bla ni mi tron. ");
INSERT INTO jid_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Naki wu he ni gabagadi nitu ndi wu u vu wo ni bi fie, ndi kpah ni bi wa ba he ni mi bu'u. ");
INSERT INTO jid_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Gbi ton ni wa ana he ni toh na, u tsro ni mri bi tsitsa, u andi ni mi tron wu he ni kpi wa a shafi toh ni kuma njanji, u nihe ikpe yi ahe ni mi son me? ");
INSERT INTO jid_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Bi yi wa tsro bari, bina tsro tumbi na? Bi wa bi tre na tie y'bi na, bina y'bi? ");
INSERT INTO jid_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Biyi wa bi tre duba na tie ntran na, bina ni tie ntran na? Biyi bi tre duba na ti gumaka na, bina tie gumaka na? Biyi wa bi tre duba na tie y'bi na, bina y'bi sessren me na? ");
INSERT INTO jid_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Biyi wa bi ngyiri nimi tron, bina kpa Irji tsri ni mi lah tree u wa ba hu tron na? ");
INSERT INTO jid_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Naki ba kpa nde Irji tie meme ni mi bi kora nitu mbi. ");
INSERT INTO jid_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Gbi gbi you grji ana he ni mah ma ni yi. Inde bi kiyaye doka, aman inde bi yi wa bina hu doka na, you grji bi akam ti na ana you grji na. ");
INSERT INTO jid_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nakima inde ndji wa bana you grji ni u na, ani kiyaye bukatu tron wawu'u bana iya ban wa bana you grji ni wu ni matsayi wa ba you grji niwu? ");
INSERT INTO jid_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nakima inde ndji wa ba you grji ni wu na u yi ani kiyaye dokoki ba wawu, ana yah sharanta yi bi you grji u tron na? Naki a he inde bi hei ni tron ba nha, aman ana hu tron na. ");
INSERT INTO jid_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Naki wawu na hi Bayahude ni ra na, ana wa ba you grji nda han tan na ");
INSERT INTO jid_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Naki a Bayahude u mi, naki me ba yo grji u suron mba Ruhu ndindi ana ibe na, bibi ndji kima ana ndji ni zu wo ni u na, se Irji. ");
INSERT INTO jid_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ahi ngye ha fifikon wa Bayahude he niwu? Naki ahi ngye hi mah yo gji? ");
INSERT INTO jid_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Akwai muhimanci ba ninkon bari. Ni mumla de ana Yahudawa irji bu tre ni bawu. ");
INSERT INTO jid_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Inde mbru Yahudawa bana kpanyime ni njanji na fa? Wa ba na kpa njani na ani zu ndindi ndu Irji? ");
INSERT INTO jid_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ana he naki ma na, maimako naki, Irji ka kma ti u njanji, na ndji ba wawu ba bi tiche, na ndji ba han hla don duba tsro ndi wu u ndindi ni mi tre me la wu kpaka ni toh wa banji u hi ni shishi tron. ");
INSERT INTO jid_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ama inde meme bu a tsro ndindi Irji, naki ki tre ngye? ki ya tre ndi Irji hi meme nda nji nfu ma ni tu mbu? (Misi ti ni sen nyu u ndji). ");
INSERT INTO jid_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ana taba he naki na. Naki Irji ni tron gbugbu'a ni he? ");
INSERT INTO jid_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Inde njanji u Irji ni ti gbugbu ce mu ani kara ninkon ni nyu'u, angye sa mi hai ni tron na'u lah tre? ");
INSERT INTO jid_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Angye sa kina tre, ki yba shishi, ndi tre, bari ba krie nda tre, du ta tie meme, ndi du ndindi ye? Hukunci ba a ndindima. ");
INSERT INTO jid_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Angye naki, ki no tumbu sen nyu'u? Ana he naki na don ki guchi tre Yahuda baba Hllinawa ye ndi tre ndi wawu mbawu ba he ni mi lahtre. ");
INSERT INTO jid_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Na ba nha, ba ndji u njanji, iriri na he na. ");
INSERT INTO jid_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ba ndji wa a toh kpie, ba wa'a ni wa Irji. ");
INSERT INTO jid_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wawu mbawu ba kankon don, wawu mbawu ba kma tibi wa bana he ni anfani na. Ba wa ani tie ndu ndindima, a'an iriri na he na. ");
INSERT INTO jid_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Gbugbran mba he ni ho na be, Ilbe mba a ban lilo, Itso wan a he ni mi lbe mba. ");
INSERT INTO jid_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Inyu mba a shu ni la'ah ni ri gberjerje me. ");
INSERT INTO jid_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Izah mba ni tsutsu gbagbla ni ka yi hle ");
INSERT INTO jid_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Inkon mba ahi yah ni tie meme. ");
INSERT INTO jid_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ndji biyi bana toh nkon sun u si na. ");
INSERT INTO jid_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bana he ni klu sissri Irji ni shishi mba na. ");
INSERT INTO jid_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Naki ki toh ndi du kpie wa itron a tre, itro ani tre ni bawu wa ba he ni mi ma, don duba ka iyu mba wawu, naki gbungblu a wawu'u ka no amsa ni shishi Irji. ");
INSERT INTO jid_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Naki ni shishi ba ndji wa ba kpa chuwo ni tu ndu tron. Nitu tron, toh lah tre aye. ");
INSERT INTO jid_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Naki zizan'a nitu tron ba tsro toh njanji Irji wa itron ni annabawa basi hla. ");
INSERT INTO jid_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Naki ndindi Irji ahi njanji nimi Yesu Almasihu hi ni biwa ba kpa nyime ni njanji. Naki, kakan na he na. ");
INSERT INTO jid_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Naki, wawu'u mbawu ba lah tre, bana ya ka hi ni daraja Irji, ");
INSERT INTO jid_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ni ndindima ba kpa ta chuwo ni tu kpachuwo wa'a he ni mi Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Aman Irji a ban Yesu Almasihu no wa ahi hadaya u kpachuwo u njanji nimi iyi ma. A ban Almasihu na nimatsayi tabbacin hukunci ma, nitu ketarewa lah tre mbu wu kogon'a. ");
INSERT INTO jid_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Nimi vu suron ma, naki i wa yi ati ndu tsro ndindima nimi toh i du kpanyime ni tuma u hukunci, nda tsro wawu hi u kpa konha chuwo saboda, njanji wa ahe nimi Yesu. ");
INSERT INTO jid_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","To, i wru wo ni san he ni ntsen? Ba chu'u rju. Nitu ngye? Nitu ndu? Aman nitu ndu? Ama nitu njanji. ");
INSERT INTO jid_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nakima kikle tre a ndi ba kpa ndji chuwo, ana he nitu ndu tron na. ");
INSERT INTO jid_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ko naki Irji ahi Irji Yahudawa ni kankrji? Ana Irji bi kora ngame na? i ahi bi kora ngame. ");
INSERT INTO jid_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Nakima inde gbigbi ahi Irji riri, ani kpa biwa ba yo nji ni bawu chuwo nitu njani. ");
INSERT INTO jid_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ki ka tron hlega nitu njanji? Ana taba he nakima na, nakima kisi hu gon tro kena. ");
INSERT INTO jid_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ki tre ndi ngye nitu Ibrahim Bachi mbu u kpa afe? ");
INSERT INTO jid_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ibrahim andi fe kpa chuwo nitu nduma, andi na wruwo ni san, wruwo ni san ma ndina he ni shishi Irji na. ");
INSERT INTO jid_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ahi ngye nassi hla? Ibrahim a kpanyime ni Irji, u baka bla yo niwu ndi ahi ndi tsratsra. ");
INSERT INTO jid_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Zizan wawu wa a tie ndu'a, bana bla lulu ma yo ni mi tsratsra na, bayo ni kpe wa a he u ma. ");
INSERT INTO jid_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Wawu wa ana he ni ndu na, a kpa nyime niwa ani wruhle nibi lahtre'a ba bla yo suron ma ni son tsratsra. ");
INSERT INTO jid_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dauda a tre tre lulu nitu nji wa Irji bla yo nimi tsratsra hama ni ndu'a ");
INSERT INTO jid_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","A tre ndi, “Lulu he nitu biwa ba wru lah tre mba hle'a ni biwa ba ka lah tre mba kaka ni bawu'a. ");
INSERT INTO jid_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Lulu he nitu nji wa Irji na bla lah tre ma memle'e mu na'a.” ");
INSERT INTO jid_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","U lulu yi he nitu biwa ba yonji ni bawu ka gji, ka nitu biwa bana yonji ni bawu ngame'a na? ");
INSERT INTO jid_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ba bla yo niwu nihe? Ahe ni nton wa ba yonji ni Ibrahim ka ni nton wa ba na rhi he yo nji niwu'a? Ana he ni nton wa ba yo nji niwu'a na, a heni nto wa bana yo nji niwu'a na. ");
INSERT INTO jid_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibrahim kpa ngban u yo nji'a. Wawu yi a he hatimi (seal) u yo suron wa a he niwu rhi ni nton wa ana yo nji rhi na. A tie wayi ndu ka tie tie bi wa ba yo suron'a, amma bana yo nji ni bawu rhi na, ndi duba blaba yo nimi bi wa ba tsratsra me'a. ");
INSERT INTO jid_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ahi tie biwa ba yo nji ni bawu'a, ana wa ba yo nji migyen na, bi wa ba zren ni nkon ndindi wa Ibrahim a hu rhi nda fe yo nji'a. ");
INSERT INTO jid_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Alkawali wa bana tie ni Ibrahim ni hama ndi ani gaje (heir) mgbumgblu'a ana doka na a rhi ni tsratsra u yo suron. ");
INSERT INTO jid_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Biwa bana son nitu doka ba ni gaji koh Irji'a, iyo suron ani migyen (empty), u alikawali a ndi na kpe na. ");
INSERT INTO jid_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Doka ni nji nfu ye, doka nita hama lah tre hamma. ");
INSERT INTO jid_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ani tu tre yiyi ani kponji, ni ndu nno nyu mba ndu si nitu zizi nda bwu (nno) nkon ni grji Ibrahim. ");
INSERT INTO jid_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Na wa ba nha, “Mi chu ndu he tie u mgbumgblu gbugbu'u” Ibrahim ahe ni shishi ndji wa a kpau nyime'a, wato Irji wa ani nu vri (life) ni biwa ba gyu nda ndu kpe biwa bana he na ndu ba he. ");
INSERT INTO jid_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibrahim a kpa nyime ni Irji nitu kpe wa ba he ni ko shishi'a. Na kati tie ni mgbumgblu gbugbuwu, ni tu kpe wa ba hla niwu'a, igrji me ba he naki. ");
INSERT INTO jid_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ana khwumgble ni yo suron mana, a kpa nyime ndi wawu ceye, don ana tie whewhre ni se dari, a kpa nyime ndi ikrju (Womb) Saratu na nji vren ngana. ");
INSERT INTO jid_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nitu Alkawali Irji, Ibrahim ana senyu (hesitate) nitu ka kpa nyime mana, a fe mgbemgblen nitu son suron ma, nda gbre Irji San. ");
INSERT INTO jid_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","A kpa nyime gbigbi ni kpe wa Irji hla ani tieu. ");
INSERT INTO jid_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","U ba bla kma yo niwu ndi ahi tsratsra ndji. ");
INSERT INTO jid_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Bana nha ndi ndu zo nika khji ma na. ");
INSERT INTO jid_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ba nha ni tawu ngame, ba bla ni tawu biwa ki yo suron niwu wa a ton Yesu Almasihu shime ni khyu'a. ");
INSERT INTO jid_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ahi wa ndi ba kamba niwu nitu lah tre mbu'a nda tashime nitu kpata chuwo'a. ");
INSERT INTO jid_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ni wa ki fe Barata, ki fe si ni Irji ni nkon Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ki fe nkon ni kpanyime mu nimi tie ndindi wa ki kri, ki ngyiri ni yo suron mbu ni Irji ni kpe wa ani tie ni tawu'a. ");
INSERT INTO jid_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ana kima migyen na kiga mgban ngame ni ba yambu. Ki toh ndi yah ni nu vu suron. ");
INSERT INTO jid_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","U vu suron nino mgbemgble suron, u mgbemgblen suron ni nno yo suron, ");
INSERT INTO jid_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","u yo suron ana nno shan na nitu waa ba ka ison Irji sru tawu ni mi suron Irji ni tsratsra Ruhu, wa ba nnota wu'a ");
INSERT INTO jid_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Wa kina he bi kunyire'a ri, u Kristi ka Khwu ni bi lah tre tsra ni nton ndindi. ");
INSERT INTO jid_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","A he ni dii ndu ri khwu nitu ndji tsratsra, u mi ya indrjo ni ma khwu ni ndji ndindi. ");
INSERT INTO jid_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bachi a tsro son ma ni tawu, wa kina rhi he bi lahtre rhi'a, Kristi khwu nitu mbu. ");
INSERT INTO jid_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Zan zizan wa a ngla ta ni yi ma, ani kpata chuwo ni nfu u Irji. ");
INSERT INTO jid_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kina he bi ka wo tre, ba kata kabi ni Irji nitu khwu vrenma, zizan wa ki fe katu kabi'a, ba kpata chuwo nitu vrhi ma. ");
INSERT INTO jid_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","A na naki megyen na, ki ngyiri ni Irji nitu Bachi mbu Yesu Kristi, wa nitu ma yi ki kabi yi'a. ");
INSERT INTO jid_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ni nkon ndji riri lah tre ari ni mgbumbglu, ni nkon kima ikhwu'a ri ni nkon lahtre'a. U khwu rhi ni ndji wawu'u, don ba lahtre wawu mbawuu. ");
INSERT INTO jid_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ni nton wa bana tie sharia na, lahtre ana he ni mgbumgblu, bana ta tre tre lahtre na ninton wa sharia ana hama'a. ");
INSERT INTO jid_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ikhwu a he rji ni nton u Adamu ye ri ni nton Musa, nda he nitu bi wa bana lahtre bibi u Adamu'a na, ahi kpe wa a kati u seka se'a. ");
INSERT INTO jid_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kyauta na he na lahtre na, a nita he nitu lahtre ndji riri yi'a, ndji gbugbu ba khwu, naki mame, ito tie ma nitu ndji riri ngama Yesu Almasihu, he nitu ndji gbugbuu. ");
INSERT INTO jid_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Innoa na he na lahtre ndji riri na. Itron'a hu lahtre ndji riri, nda nji hukunci, inno hu lahtre gbugbuu nda nji kpa chuwo ye. ");
INSERT INTO jid_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A nita he nitu lahtre ndji riri ikhwu ri, naki ma me bi wa ba kpa to tie gbugbuu ni nno vrhi ndindi ni mi wawu riri, Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nawa lahtre ndji riri nji hukunci ye nitu ndji wawuu, na kimame itie ndindi ndji riri nji wruhle ni vrhi ye ni ndji gbugbuu. ");
INSERT INTO jid_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na kima me, wa nitu lahtre ndji riri a ndu ndji gbugbuu kati be lahtre'a, na kima me nitu ndji riri ndji gbugbuu ba fe kpa chuwo. ");
INSERT INTO jid_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Wa sharia ye'a, a ndu lahtre babran, ni wa lahtre babran, liheri he gbugbuu ngame. ");
INSERT INTO jid_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","A tie nayi'a, nawa lahtre a mreh (mallaka) hi ni khwu, na kima me, i tie ndindi mreh suron ni vrhi nitu Yesu Almasihu Bachi mbu. ");
INSERT INTO jid_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Zizan ki tre ngye? Kita lah tre chachuu ni du ndindi kagon? ");
INSERT INTO jid_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ana taba ti naki na. Ba ti ni he da tre ndi kita wa ki kwu nimi lah tre, kita cigaba sun nimi ma? ");
INSERT INTO jid_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Bina toh ndi bi wa ba ngla ba nimi Almasihu Yesu ba ngla ba hra nimi kwu ma na? ");
INSERT INTO jid_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ba rju ta ni'u, na ngla nimi kwu ma. Nakima ahe na Almasihu a lunde ni be nimi ninkon Iti Ma. Nakima i kita me ki zren nimi rayuwa i sa'a ma. ");
INSERT INTO jid_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Naki inde ki si he ni'u nimi kamani ikwu ma, i ki sun ni'u har ni kamani lunde ma. ");
INSERT INTO jid_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Naki a ki toh ndi ba kpa u ni kunkro, ichiche ndji u mbu i ni'u ma don duba wu kpa u lahtre. Wa i ahe don kina ta hi nimi bautar lahtre. ");
INSERT INTO jid_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Duk wa a kwu ba you ni matayin nitu ndindi nitu lahtre. ");
INSERT INTO jid_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Naki ki kwu ni Almasihu ndi kpa njanji, iki sun ni wu ");
INSERT INTO jid_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ki he ni toh ndi ba nzu Almasihu rju ni be, nakima ana lah ikub ngana, ikwu na he ni gbengblen nitu na. ");
INSERT INTO jid_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Na ikwu wa a ti ni lahtre, ati kpu riri nitu wawuu. Nzren wa asi zren, asi zren niIrji. ");
INSERT INTO jid_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nakima bi yi me, bika bah tumbi ni matsayin bi kwu ni lahtre, aman bi wa ba he vri ni Irji ni mi Almasihu Yesu. ");
INSERT INTO jid_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Naki bika na no lahtre gbengblen ni mi kpambi na har ndi woh tre ni sun kpa. ");
INSERT INTO jid_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Na vu gham kpa mbi no lahtre nitu ikpi u du wa njanji na he na. Naki bika no Irji tumbi ni vri ni kwu. Bika vu ngham kpambi no Irji nitu ikpi du u njanji. ");
INSERT INTO jid_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Na no lahtre nkon ni tumbi na, bina he nimi doka na, naki nimi ndindi bi he. ");
INSERT INTO jid_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To se ngyeh kika ti lahtre don kina he nimi doka na, ama ni ndindi, ana taba he naki na. ");
INSERT INTO jid_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Bina toh ndi bi ban tumbi no nitu igran, ni wu bi gran? Wa i ahi najinji, inde bi gran ni lahtre, wa ani nji yi hi ni kwu, ko naki igran ni wo tre ni nji hi ni ndindi. ");
INSERT INTO jid_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Naki ma ingyiri a he ni Irji, don ni sen bina gran lahtre, ama bi yi biyaya nimi suron mbi irin koh koyarwa wa ba noyi. ");
INSERT INTO jid_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ba kpa yi chuwo ni mi bautar lahtre, nda kma yi ti gran bi ndindi. ");
INSERT INTO jid_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Misi tre ni yi na ndji wa a ku nyere ni nanma kpa ni yin. Na yadda bika ban nghan kpambi ga ti rji na bi meme du, nakima zizan bika ban ngham kpambi ni tu gran ndindi. ");
INSERT INTO jid_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Naki ma itoh wa bi hi gran lahtre, bi yi wa ba kpa yi chuwo ni ndindi. ");
INSERT INTO jid_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ni toh kima ahi amfani ngye bi samu nitu ndu wa zizan'a bi si klu shan ba? Nakima sakamaki bi ya indu hi kwu. ");
INSERT INTO jid_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Naki zizan wa ba kpa yi chuwo ni lahtre, nda kma yi ti gran Irji, amfani ma, wawu hi tsarkakewar mbi. Sakamanko ki hi ivri u se kakle. ");
INSERT INTO jid_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nakima sakamako lahtre hi kwu, ama kyauta Irji ahi ivri u se kakle nimi Almasihu Yesu. ");
INSERT INTO jid_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Immriya, bi na toh na (me tere ni tu be wa mba toh turon) a ndi ituron a he ni son siseri ma? ");
INSERT INTO jid_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nitu turon imba be gran mba he nimi lo. wa mba lon mba ba he ni sissri, wa a lu ka son ni idiri, ");
INSERT INTO jid_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","mba yo de tarawa. U lon mani te quu, “a djur nimi turon ani ta hi gran idi ri ana hi ntara na. ");
INSERT INTO jid_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nakima, imri ya mu, mba du yi quu ni mi turo u mi kpa Almasihu, nakima. Ba du yi gran idiri wa mba ta shibe ni kubbu, de khi gdi imiri ni Irji. ");
INSERT INTO jid_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Naki khi he ni mi kpa. Ison u kpa a ni chonta yo ni turon u khi gdi imiri ni mi khwu. Nakima ziza mba chuta djur ni mi turonye. Khi khwu nimi ikpi wa mba lota. ");
INSERT INTO jid_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Zizah mba kpata chuwo ni turon. Khi na khwu nimi kpe a na lota a he nakhi du khi zere ni nkon sisama ni Ibrji. Ana he ni mi ha cice turo'a gana. ");
INSERT INTO jid_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ziza khi tere de geh? wawu turon tuma a hi illa tere? Ana he naki na, nakima, anita na he ni tu turon na khina toh na ituron a hla mba ime mide na gaire ikpi idi na. ");
INSERT INTO jid_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","E, lahtere a dhi ni mi dokoki da ji son kpa ye wa a he ni mi kpamu. bubu wa turon na he na latere a kubuma. ");
INSERT INTO jid_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ni nton ri me he ni siseri u turon ana he na u imbe a ye. i lahtre a tashbe. u mika khu. ");
INSERT INTO jid_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Imbe wa mla du nji siseire ye. U mi toh a he khubuma. ");
INSERT INTO jid_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Naki latere, a samu kon ni tu imbe, a nji son kpa wa a gurume. U ni tu imbe a wuma. ");
INSERT INTO jid_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nakima, ituron a he tsr-tsara, u mlati mba ndendema. ");
INSERT INTO jid_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","E, u ikpi dedema ni mu a hi khuu naki? a he naki nitu imbe lahtere a he latere. ");
INSERT INTO jid_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","U khi toh ituron u ibrji u me mihe ni mi kpa mbana ka me le ti gran ni latere ");
INSERT INTO jid_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ni kpi wa meti me na mla toh na ikpi wa mina son ti me na ti na u kpi wa mina son na. Me kpa wa me kamu niwu mi tie u. ");
INSERT INTO jid_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","U me ta ti ikpi wa mena sona tina, mi kpa nyeme ni turon de ituron a bi. ");
INSERT INTO jid_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ziza yi ana la he na kina. Ime wa mi ta tikima, u latere wa a he nime. ");
INSERT INTO jid_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mi toh deni mi kpamu mina ti ikpi dedema nitu imere u ti kpi dedema a he ni me u mina ya ti u na. ");
INSERT INTO jid_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ni tu ikpi dedema wa mi son ti wu mina ya tiwu na, u meme tie wa mina sona, wa we yi me ti. ");
INSERT INTO jid_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","U mita ti ikpi wa mi nason ti'a na. Ee, ana he imeyi mi si tiu na a hi memeti wa a he ni me'a. ");
INSERT INTO jid_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","N tu ki u me toh, ituron. Me ta ni son ti kpi dedema, u meme a he hwehwere ni me. ");
INSERT INTO jid_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Me giri ni turon u Irji ni mi sonromu. ");
INSERT INTO jid_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","U me toh ituron ni kankan nimi kpamu, mba ti ku ni turon sama wa a he nimi imere mu da ni yome ti gra ni tu turon latere wa a he ni kwma kpamu. ");
INSERT INTO jid_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mi idi u ya yi! A gha ni kpame chuwo nimi kpa u ahu? ");
INSERT INTO jid_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","U me giri ni Irji ni tu Yesu Almasihu itibu. na ki ime ni tumu mi hu ituron u Irji ni sonron mu ko ni he, ni mi kpa me hu turo u latere. ");
INSERT INTO jid_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nakima, ba kayarwa ziza'an ni biwa ba hei nimi Almasihu Yesu. ");
INSERT INTO jid_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Na ka'adar Ibrji u vri nimi Almasihu Yesu a kam tati bi kpa chuwo ni kaidar lahtre ni kwu. ");
INSERT INTO jid_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nakima ikpie wa itro na iya ti u na, don kuyer u kpa. Irji ati. A toh vren ma ni kamani kpa u lahtre don a kam ti hadaya, don lahtre, sei wa ati Allah wadai ni lahtre ni mi kpa. ");
INSERT INTO jid_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ati naki du bukatar tron da kpa shu ni mi bu. Kita wa ki si zren ni gwargwadon kpa na, naki u gwagwardon ruhaniya. ");
INSERT INTO jid_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Biwa ba si zren ni gwagwardon kpa, baka to ndu u kpa, naki biwa basi zren ni gwargwadon Ibrji didi, baka you suron ni du u Ibrji didi. ");
INSERT INTO jid_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Wallafa ivri ni kpa ahi kwu, aman wallafa ivri ni Ibrji didi ivri u sun si. ");
INSERT INTO jid_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ahei naki nitu wallafa ivri ni kpa, ani yi gaba ni Rji, naki ana ti biyaya ni tron Rji na, balle ma ka yah. ");
INSERT INTO jid_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Biwa ba hei ni mi kpa bana no Rji kikla suron na. ");
INSERT INTO jid_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Naki bi na hei nimi kpa na, aman ndi wa ana hei ni Ibrji u Almasihu, ndi kima na hi u ma na. ");
INSERT INTO jid_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","In Almasihu hei ni mime, ikpa me hi kub ni lahtre, aman Ibrji didi si zren nitu didi. ");
INSERT INTO jid_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Inde Ibrji didi wa a zu Yesu ni be, ahei ni vri ni mi ku, wa wu wa a zu Almasihu ni be, ani no ivri ni kpabi, wa ba kpa risu ni Ibrji ma, wa asi zren nimi bi. ");
INSERT INTO jid_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","To mri yah ki hei ni hakki, aman ana hei nitu kpa na, wa ki zren nitu tabiar kpa. ");
INSERT INTO jid_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Nakima inde bisi zren gwargwado kpa bi kwu nakima, ama inde ni Ibrji didi, bi ka wuu idu wu kpa, i bi rayu. ");
INSERT INTO jid_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nakima biwa ba Ibrji Rji hei nituba, ba mri Rji. ");
INSERT INTO jid_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nakima bina kpa Ibrji gran wa ani yo sisira na. nakima i bi kpa Ibrji tsartsra u diyanci nitu kiman i ki, kie zu lan di ni you Abba iti! ");
INSERT INTO jid_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Nituma ani hla niu Ibrji tsatsra bu di kita ki mri Rji. ");
INSERT INTO jid_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Inde ki mri Rji, ai ki mri bi gadoma kena, bi gado Rji. Nakima inde ki ti yah ni wu, i ba nota niko ni wu game. ");
INSERT INTO jid_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nakima mi toh di iyah bi itoh yi ana tsra waba no nikoh wa ba tsro ta na. ");
INSERT INTO jid_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Nakima na halitta niti titan ye mri Rji. ");
INSERT INTO jid_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Nakima ba ya halitta hle ga migye, ana hei ni mere mri na, na wawu wa aya hle ga megyen. Ahei ni mi yo yu'u u njaji. ");
INSERT INTO jid_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Tre di halitta ni tuma ba kpa chuwo ni gran u gla. naki ba jin u ye nimi kpa chuwo u gbre san u nikoh mri Rji. ");
INSERT INTO jid_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Naki ki toh i halitta wawu'u ahi u kpa chuchu ni yi ne har ye ziza'a. ");
INSERT INTO jid_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ana hei naki ni kankrji na, ko kita ni tubu wa ki wir u mumla u Ibrji Tsatsra kita ni tubu ki, kie kpa chuchu ni mi ne bu, hi kie gbe diyancin bu, wato kpa chuwo u kpa bu. ");
INSERT INTO jid_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nakima i wayi gbigbi ba kpa ta chuwo. Naki inde ikpi wa ki kpa yeme di ba tiu kina toh rina. Naki a ghan wa asi you suron njaji ikpi asi toh? ");
INSERT INTO jid_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Naki inde ki hei ni kpah yeme ikpi wa ki ri he u toh u, kika gbe ni vu suron. ");
INSERT INTO jid_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nakima Ibrji Tsatsra si zo kuyere bu. Naki kina hei ni toh yadda ki bre aman Ibrji tsatsrani tuma ni bre ni tu hu ni kpa chuchu wa bana yah tre ana. ");
INSERT INTO jid_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Wawu wa ani wa suron, asi toh mere Ibrji Tsatsra, don asi bre ni tu biwa ba kpa njaji nitu imere Rji. ");
INSERT INTO jid_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ki toh di biwa ba son Rji, ani ti ikpi ba wawu du ba hi ni didi, hi ni bi wa ba you ba wawu nitu mere ma. Ikpi ba wawu ba kma tie didima. ");
INSERT INTO jid_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Naki ma bi wa a toh ba ni sen mu, baba i a kardara ba kma ti kamani ivre ma, don a kma ti vre ma u mumla ni mi mri ya gbugbuu. ");
INSERT INTO jid_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Biwa a kardara, a you ba, baba i a you ba, a kpa ba chuwo, baba biwa a kpa ba chuwo, baba i a zu ba. ");
INSERT INTO jid_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ki tre nitu kpi bi yi inde Rji hei ta, ahi nghan ni you ti ni shishi? ");
INSERT INTO jid_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Wawu wa ana ka vre ma yun tana da ban nota wawu bu'u agye ni zu duna nota kpi ba wawu na ni wu ngame? ");
INSERT INTO jid_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","A ghan ni tsro wo ni biwa Rji a chuba? Irji wawu hi u kpachuwo. ");
INSERT INTO jid_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ahi ghan ni hukunta? Almasihu kwu nitu bu har zan naki, wawu wa ba, asi ti mulki ni Rji ni bubu u daukaka, wawu i si bre nitu bu. ");
INSERT INTO jid_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","A gha ni gata ni son u Rji? iya, ko kpa suron time, ko tsanani ko iyuo, ko zre ni gbere, ko kpalu, ko nji gban? ");
INSERT INTO jid_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Na di ba han, nitume ba wu ta ni kurji, ba kma ta ti itama bi han. ");
INSERT INTO jid_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ni kpi ba wawu ki zan gbengblen duba tre di kita ki bi kpaka, ni tu ma wa ani son ta. ");
INSERT INTO jid_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Naki mi kpa nyeme di ko kwu, ko ivri, ko malaiku, ko mulkoki ko ikpi bi ye, ko gbengblen. ");
INSERT INTO jid_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Ko gbron, ko juju, ko irin halitta rime bana iya gah ta ni son wu Rji na, wa ahei ni mi Almasihu Yesu Bachi ba na. ");
INSERT INTO jid_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mi hla njanji ni Kristi, mina si tie chena, imre mu si tsro me ni mi Brji Tsratsra, ");
INSERT INTO jid_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ndi mi he ni kpon yi ni low sron u kakle ni sronmu. ");
INSERT INTO jid_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ba ndi na tre ndi ba tie nyu nimu nda cume ni kan ni Yesu ni tu mri vayi mu, ni ba mla mu u kpa. ");
INSERT INTO jid_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ahi baba yi ba Israilawa, ba fe kpanyme, ni gbire san, ni yo nyun mbe dede, ni toh turon, da gbire Irji san ni tara kuma, ni yo nyu ma. ");
INSERT INTO jid_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Mba tiba mba ndi nimi Almasihu u no niko u kpa wawu wa a hi Irji u koge, du mba gbirasa u saika sai sai du he naki. ");
INSERT INTO jid_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","U ana nitu itere Irji wa a joku na, ana hi kohan ni Israilawa a hi Israilawa u njanji na. ");
INSERT INTO jid_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Nakima ana duka grji Ibrahim mba hi iriri Ibrahim na. “Mba yo mba be grji Ishaku.” ");
INSERT INTO jid_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Mba ki mba he imiri be kpa mba na imiri be he imiri be Irji na. Mba imiri be yo nyu wa mba bla ba suru ni grji ba. ");
INSERT INTO jid_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","U wayi hi itere u yo nyu a “nzizayi me ye de ye no Saraya ivire. ");
INSERT INTO jid_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ana he iwayi me ngana, niwaa Rifkatu a ban nne ni lonma itimbu Ishaku. ");
INSERT INTO jid_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ba rihe ngrji myri ba u mbana ti kpi dede ma ko meme ma na. Ni tu naki Irji a chu ana bi ni kpi wa mba ti ana amma nitu idi wa a yo. ");
INSERT INTO jid_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","U mba hla ni wa “Nikon ani kwba ti gra ni tsitsama.” A na kima mba tere. ");
INSERT INTO jid_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Naki mba han zi “Me son Yakubu de kamu ni Isuwa.” ");
INSERT INTO jid_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","U khi tere de naki? Irji na ti bina naki? Ah ah. ");
INSERT INTO jid_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","U a hla ni Musa me lo sonro niwa mi losonro, mi losonron ni wa nimi no si sonro ni wa ani si sonron a. ");
INSERT INTO jid_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ni tu na ki ana he ni tu idi wa a yo sonron. Ko kuma ni idi wa ani ri shishi, na a he ni nitu Irji wa ani losonro ni ta. ");
INSERT INTO jid_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","U lan tre Baci'a hla ni Firauna, “Ani tu wayi yi me nzuu lunde ni ndu me tsoro ngbengblen mu ni mi me ni ndu b d'bu nde mu ni ngbungblu'a wawuu.” ");
INSERT INTO jid_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Naki, Irji ni tsro low sron ni wa a son'a nda tie wa a son sen tu. ");
INSERT INTO jid_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Khita mla ya u khi tere ade ni tuge ani son toh joku? Ahi ihan yi ni ya kukri ni gbegble u tuma. ");
INSERT INTO jid_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Khi ta ya i u idi u hi han wa u san yun ni Irji? Ko idi u me a ani ya miye idi u me de ge sa a me wawu naki? ");
INSERT INTO jid_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","U idi u me iri ana he ni gbegbegle ni tu itama iri wa ani meri iri u dedema iriri a hi u daraja, iriri a hi u tidu mege? ");
INSERT INTO jid_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","U ida Irji ani so tsoro ifu ma ni gbegble mba toh, ssai a vu sonron gbugbuu ni mba iri u fu wa mlati is gbi sutu mba. ");
INSERT INTO jid_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","E ati naki da tsoro gbira san ma gbugbu wa a he nimi dede u ma, wa a mla ti du mba gbirasan? ");
INSERT INTO jid_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Amma tie wa ni tu mbuyi ita wa aye ta'a, ana Yahudawa ni nklen mba megyen na u ni bi kohra ngame. ");
INSERT INTO jid_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Towa a tre ni mi nvunvu u Yunusa a, “Ani yo ndji wa bana bimu na ndi ndji mu, ni biwa ana son ba naa, biwa mi son ba.” ");
INSERT INTO jid_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ani he naki wa mba na tre “ndi ba hi indi mana, u mba yo mba imiri Irji be sisairi.” ");
INSERT INTO jid_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ishaya a yi kpokpo djur rah nitu Israila. “Mba ta ni tere a de imiri Israila mba bra na kpabru u kosan ba u mbari mba ba nawo. ");
INSERT INTO jid_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","U Irji a toh a de wawu a ni kle nyun ma ni gbugbugblu pyipyi me bani wuton mba. ");
INSERT INTO jid_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Na wa Ishaya a han ni sei u Irji a de na ka grji do ni ta wu na khi de na he na Sadumawa u khi dena kwma ti na Gomarata. ");
INSERT INTO jid_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","U ziza khi tere a de ge? U be kora, be wa bana son tsa-tsara na mba kpa dede ni dedema u kpa kyem. ");
INSERT INTO jid_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","U Israila be wa mba na wa ituron u tsa-tsara na u mba na he ni mi turon na. ");
INSERT INTO jid_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nitu ge? ni tu mba na wa ni njanji na. u a he nitu idu na. Mba za ni tu tita wa ni du yi za ni kbu za. ");
INSERT INTO jid_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Towa ba nhaa, “To Mi ka tita u kbu za sizi ni mi Sihiyona mba ni haan u latre. U wa a kpanyme ni wu'a ana tie shan na. ");
INSERT INTO jid_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Mrli vayi, yo sron mu ni bre Bachi, aa ndu ba gbujbu. ");
INSERT INTO jid_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Me to ndi bahe ni yo sron ni Rji, ana ndi ba to kpe na. ");
INSERT INTO jid_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Bana to kpe nitu tie ndindi u Rji na, ba wa ndi ba tie ndindi u tu mba, bana nno tumba ni tie ndindi u Rji na. ");
INSERT INTO jid_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ahi Kristi hi duu u tie ndindi hi ni bi wa ba kpa y'me'a ");
INSERT INTO jid_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa a nghan nitu ndindi wa'a rji ni ndji, ndji wa a tie ndindi u duu ani son nitu du'a. ");
INSERT INTO jid_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","U ndindi waa rji ni yo sron a te ndi, na tre ni sron me ndi, a ngha ni hon hi ni mi shu? (Nda ji Yesu Kristi grji ye ni meme). ");
INSERT INTO jid_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Na tre ndi a ghan ni grji ye ni meme? Ahi ngha ni ji Yesu Kristi rji ni khyu). ");
INSERT INTO jid_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Amma asi tre ndi ge? iji trea he hyehyre ni wu ni mi nyu me ni mi sron me ");
INSERT INTO jid_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","U ta hla ni nyu me ndi Yesu hi Bachi, ndi kpa y'me ni sron me ndi Rji zuu wlude ni be u gbujbu. ");
INSERT INTO jid_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ni sron'a idji kpa y'me nda fe kiklan sron ni nyu ndi bre nda gbujbu. ");
INSERT INTO jid_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Imbe Rji tre ndi, biwa ba kpa y'me'a ishan na tie ba na. ");
INSERT INTO jid_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Don Jew baba Greek bana heni kankan na, don Bachi ba'a he riri. ");
INSERT INTO jid_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Idji wa a yo nde Rji ani fe sii. ");
INSERT INTO jid_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ba tie niheri nda yo nde Idji wa bana kpau y'me na? Ba tie nihe rli nda kpa y'me ni wa bana taba wo duu ma na? ");
INSERT INTO jid_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ba tie nihe rli nda wo ba tina tre tre Rji ni bawu na? Ba ti ni he rli nda tre tre Rji, idan bana ton bana? To wa ba nghan, “Iza biwa ba ji tre ndindi he bi bange. ");
INSERT INTO jid_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Bana wo tre Rjia wawuu mba wu na. Ishaya a m'ye “Bachi, a hi nghan kpa y'me ni ton ndu'a? ");
INSERT INTO jid_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Yo sron nihe nitu wo, wo rli ni tre Rji. ");
INSERT INTO jid_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","U me m'ye, “Ba na wo na?” E” gbigbi ilan mba he ni mgbumgblu, itre mba hi ni mgbumgblu wawuu. ");
INSERT INTO jid_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Luwa, mi tre, Israila ban to mu naa? “Musa a tre ndi” Mi ndu yi tie ngu nitu mgbumgblu wa bana to kpe na mi tie ndu ni ba ni ndu sron mbi tie meme. ");
INSERT INTO jid_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ishaya a vusron nda tre ndi, biwa bana wame na'a ba fe me. Mi tsro tu mu ni biwa bana m'ye me na'a. ");
INSERT INTO jid_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","A tre ni Israila ndi, mi n'ma wo mu hi ni ndji bi kawo trre ni hanton. ");
INSERT INTO jid_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Mi tre ndi Rji kama ni ndji mu? Ani to bre tie to kima. Ime mi ndji u Israila, ih'bu Ibrahim u grji Banyomi. ");
INSERT INTO jid_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Irji na kama ni ndji ma waa he ni guci toh mba na. Ka bi toh kpye a lan tre'a hla nitu Iliya, wa a nji (kara) Israila hi ni Rji'a? ");
INSERT INTO jid_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","A tre di Bachi, ba wu annabawa me, da zi koh me me, Ahi me ni kankrji mu mi don. Naki basi wa ba wuh me. ");
INSERT INTO jid_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Naki u Rji ka kasa u da tre gye? A tre di mi hei ni di dubu tagban wa mi zi ba nitu mu. Wa bana kudran ni Ba'al na. ");
INSERT INTO jid_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ko naki me ni toh i ibru bari ba he ni ndindi. ");
INSERT INTO jid_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","U ani taa ni zizi, wa'a ana la ni ndu na. Ani tana tokima, u zizi nala hi zizina. ");
INSERT INTO jid_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Wa hi ngye? Ikpye wa Israila ba wa bana fe na, u bi a ba chu ba'a ba fe, imbru ba ba sen tu. ");
INSERT INTO jid_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Na ba han Rji no ba ibrji u meme wa bana toh shishi hei, aman bana toh na, iton hei aman bana wo na har ye ni vi kima. ");
INSERT INTO jid_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dauda a tre di du teburin ba du kam ti rjirji u vu labe, ba troko, du kam ti tita u kub za ni kpye u rju hla ni ba. ");
INSERT INTO jid_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Du shishi ba ti bwu duba na toh na, du gon ba ta dran chuchu. ");
INSERT INTO jid_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Mi tre ndu ba k'bu za da joku? Ndu kpye nakima la tie na. Nakima k'ma hi ni gon mba yi a ndu gbujbu ye ni bi ko hra ni ndu yo ba tie ngu. ");
INSERT INTO jid_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Inde zizaa wa ba kam hi ni kogon, aji klen ye ni bi kora, ni hei kwatancin nikon ma ani hei, inde ba ye ni klekle? ");
INSERT INTO jid_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ziza'a mi si tre ni yi, biyi wa bi kora, naki ime i mi hiu ton du hi ni kora, misi wurwo ni mi du mu. ");
INSERT INTO jid_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ani bi dume you mri yah bi hwu, duta kpa bari ba chuwo. ");
INSERT INTO jid_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Inde kaba, ani ji shu tu bi ni gbugbulu in kpa ba ani hei ni hei? Ani kamti vri ni mi kwu? ");
INSERT INTO jid_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","U klo bi mumla bata bi mumu'uma wa ba nymo tie gble ma ni bi ngame. U inja kukron bata tsratsra me, ba ilan ma ba ba he tokima. ");
INSERT INTO jid_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","U ilan bari u kukron bana nzi hlega, u biyi mba bina kukron Zaitun, wa ba fe nimi mba, u bina he ni gado bii ni ba, u bi ye ni mi nja zaitun a, ");
INSERT INTO jid_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","to, bika na gangban ni tu lan ba na. Bita gangban, ana bi yi mba ti njinja na, wa hi nja'a mba nji yi. ");
INSERT INTO jid_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","U bi tre din “Ba nzi lan ba ni ndu ba fe me ni mima. ");
INSERT INTO jid_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Wa i a njanji, naki wa njanji ba na hei na, i ki sa i baka zi ba ni mi wo, bika kri gbagban ni mi njanji bi. Na ban tubi zan na ahei na, aman bika klu sissri. ");
INSERT INTO jid_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Naki inde Rji na don wo u njanji na, to ana don yi na. ");
INSERT INTO jid_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Bika toh iri du bi tsanani u Rji. Niwo ri tsanani ni ye ni Yahudawa biwa ba joku. U ndindi u Rji ye ni yu'u, inde bi si zre nimi didima ba na zu yi na, aman inde bi kabi ba zu yi. ");
INSERT INTO jid_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Nakima inde ba na guci ni mi njanji bana, ba vu ba sur ni mi kukron nakima Rji na iya la vu ba. ");
INSERT INTO jid_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Inde ba chu u rhu nimi kokron zaitun mi ji, har wa bi du ba ka'u kabi nimi kukron zaitun u wu'u wo u njanji. ");
INSERT INTO jid_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Mri yah mi ni son du yi ji hei ni mi bwu na, game ni gbugbulu i du yi na hei ni toh ni mi mre bi, gbugbulu hi sen tu ni Israila, har bi korta ba ri ni me. ");
INSERT INTO jid_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ahei naki Israila ba wawu bau ba gbujub, nadi ba han. Ni mi Sihiyona wa ani kpa chuwo ani rjhu. Ani wur iri hle ni mi Yakubu, ");
INSERT INTO jid_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Wa i ni kam ti chunyu mu ni ba, na di mi wur mi wur lahtre ba hle ga. ");
INSERT INTO jid_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ni nhma bari ni tu bishara, ba bi kran ni bi, nitu kon ri, ni tu chu u Rji ba bi son ni tu bati. ");
INSERT INTO jid_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Na baye-baye ni you u Rji hana ya ka ba sran na. ");
INSERT INTO jid_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Biyi me ni sen bina ta hu tre Rji na, naki ziza'a bi kpa didi nitu lahtre ba. ");
INSERT INTO jid_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ni koh kima Yahudawa biyi ba kam ti bi sen tu, ni tu didi wa ba tsro ta, baba me ba kpa didi ziza'a. ");
INSERT INTO jid_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Naki Rji ka ko ngham nitu sen tu, don du tsro didi ni ko nghan. ");
INSERT INTO jid_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ina misali juju ikle ni toh, ni toh iri u Rji. Hukunche-hukunche ma ba zan guci bichika, ikoh ma ba zan guci toh. ");
INSERT INTO jid_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Nakima, ahi nghan ni no Bachi i mre? a nghan ni ni tre? ");
INSERT INTO jid_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Naki a nghan guci no Rji kpie du han wu? ");
INSERT INTO jid_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Rji ni wa wu i, ni wawu i, hi ni u ikpie ba wawu. Niko ahi u ma isei ka kle. Ami. ");
INSERT INTO jid_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Mi bre yi mri yah, nitu gbugbu zizi u Rhi, ndi nno kpambi hadaya u ka khwu u tsratsra, ikpye u kpah ni Rji. Iwayi mba hi jiji ndume. ");
INSERT INTO jid_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Na yo tu ni kpye u ngbungblu yina, kami ndri mbi sran ni mi son sa'a mbi, Tima kima ndi toh ikpye wa a ndindi ma, u'kpaa nda hi ngre me nimyren Rji. ");
INSERT INTO jid_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Nakima mi si tre nitu didi wa ba ne, du ri nimi bi, ka na zu tuma zan uwirji wa Rji zi a na. Nakima bika hei ni toh, gwargwadon wa Rji no ko nghan njanji. ");
INSERT INTO jid_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nakima ki hei ni ngma kpa gbugbu'u nimi kpa riri, ana wawu ba, ba ti iri du riri na. ");
INSERT INTO jid_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Ahei naki ni kita, na diki gbugbuu, naki ni mi kpa u Almasihu, wawu bu'u ki ngma kpa, kpabu. ");
INSERT INTO jid_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ki hei ni ba nno nikankan ni tu ndindi wa ba no ti tawu. Inde baiwa indio hi toh ko shishi, ka ti nitu njanji ma. ");
INSERT INTO jid_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Inde wa ahei ni baiwa u du, sei ka ti du ma. Inde ndi ri hei ni baiwa u tsro, wa ka tsro. ");
INSERT INTO jid_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Inde iri ahei ni baiwa u chon ka chon. Inde ndi ri ahei ni baiwa u no, ka no ni bwu wo, inde iri hei u jin ndi, ka ti ni toh, inde iri baiwa a lo suron, ka ti ni si suron. ");
INSERT INTO jid_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Bika tsro son, aman na ni riya na. Ka bi ni ikpi wa a meme, di ti kpie wa a didima. ");
INSERT INTO jid_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Nitu son mri vayi, bi ka son kpabi na abi. Nitu no nikon, bika no tubi nikon. ");
INSERT INTO jid_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ni ti, na sina, ni tu Ibrji Tsatsra, bika ti gbengbenlen Nitu Bachi game, bika ti du ni u. ");
INSERT INTO jid_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Nitu tre kpeshe, bika ti niki kla suron. Nitu sun si na hei na, bika vu suron, nitu bre, bika bre ni you suron. ");
INSERT INTO jid_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ki ta zo bi tsatsra, di ta kpa bi tsri ni ba koh bu. ");
INSERT INTO jid_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ti lulu yo ni bi wa ba wanyu ni yi, bi kana tinyu ni bawu na. ");
INSERT INTO jid_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bika za'a ni biwa basi za'a, bika yi mashi ni biwa basi yi mashi. ");
INSERT INTO jid_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Imere bi ka kamti riri, na du mere bi kam ti u wur wo ni san na, naki bika ti kpan ni bi tiya. du iri ni mi ka ri mere di wawu a zan iri na. ");
INSERT INTO jid_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Na rjhu hla meme ni meme na, ti ndu didi ni shishi ko nghan. ");
INSERT INTO jid_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Bika ti kpie wa bi ya bi ya ti, don du yi si ni ko naghan. ");
INSERT INTO jid_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Mri yah na rjhu hla na, du Rji rjhu hla niyu'u, na di ba nha. Rjhuhla ahi u mu, mi yoh ni ko nghan, inji Bachi bu. ");
INSERT INTO jid_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Nakima, iyon nita tie ndi wa ani kra u wuka nno barli, inde hlan ma niti u wuka no man so. inde bisi ti nakima, bi si vu kla lu si sur ni tu bi kran yi. ");
INSERT INTO jid_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Na du meme gyuru yi na, bi yi bika gyuru meme niti didi. ");
INSERT INTO jid_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ko ko ghan du ka tu ghji ni be chu nitu be ichu mba dji ni Irji ituron wa a he ziza a dji ni Irji. ");
INSERT INTO jid_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ziza yi be wa bana hu ikpe wa ituron u Irji a hla na be wa mba kaba mba kpa ide u meme ti mba. ");
INSERT INTO jid_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Mbe chu mbana kpe u ti sissri na, ni idi be ti dedena u mba he ni tu idi be ti meme ti yi u na son ti sissri be chu na? Ti kpe wa a he dedema, u be gbirasa. ");
INSERT INTO jid_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Wawu a hi ivre ko Irji u dedema. U tana ti kpi wa hi memema u kati sisiri i be turon wawu ana ba ta wa ana he ni tu ikona. A hi vre ko Irji ni tu dedema. U mbe ta ti kpi wa a memema. mbe ka ti sisiri, wa wu na taba ban ta mege na wa wu a hi ivrenko Irji ani tifu ni idi u ti memeti. ");
INSERT INTO jid_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Gbigbi be ka hi be hu ana he ni tu ifu na. U a he nitu isonrome. ");
INSERT INTO jid_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Nitu ki, ki han gadu, nitu ki ma be kpa gadu mba hi igra Irji, be wa mba tina ki chachu'a. ");
INSERT INTO jid_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Be ka no ko ghanide ma, gadu ni be gadu, kudi fito ga tito, klusisiri ni be wa mba'a klusisiri'a, no nikon ni be wa mba mla kpaniko'a. ");
INSERT INTO jid_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Na ji kpiri u idi na, u be ka son kpabi. Wawu wa a son vayi ma a kle toron wawu kina. ");
INSERT INTO jid_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","U, “Be kana yi zina na, be kana wu idi na, be kana yibbi na, be kana ti guna, u doka iri ni ta he gari. Be ka ban u chudu ni wayi.” Son vayi me na wa u son tuma a.” ");
INSERT INTO jid_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ison ana mynien vayi me na a ha naki kauna ta cika shari'a. ");
INSERT INTO jid_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ni tu naki be ka toh ndi iton a kleyye u be ka lude ni kruna'a. Nitu kpachuwo bu'a a he hwehwere. Ana gburukon nawa khi si ya na. ");
INSERT INTO jid_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ichuu a kleye u ible a ti hwehwere u kpaye be ka du ki ka idu u bu'a don; de sur u ikpi u kpama. ");
INSERT INTO jid_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ki mla zren naki si zren ni Rji, na ahei ni mi ti fa na, na bi hwa na. Kina zren ni mi ti gwugwu ni meme sha'awa, kakima mi wa nyu, hwu. ");
INSERT INTO jid_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Naki bi ban Bachi Yesu sur ni Almasihu, bika nati meme halin u kpa na, don meme sha'awa sa. ");
INSERT INTO jid_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kpa biwa njanji ba a kuyere, di na no tron nitu sen nyuna. ");
INSERT INTO jid_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Wa ahei ni njanji ka ri ko gyen, aman wa ahei ni gbengblen ka ri vuvu migyen. ");
INSERT INTO jid_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Wa ani ri kogyen kana kpa wa a na ri na tsir na. Indji wa ana ri kogyen na, kana yoh tron ni bi wa ba ri kogyen na. ");
INSERT INTO jid_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Wu u nghan wa wu si to lahtre igran ndi ri? Kri ni zade ma, ni jokuma a die u ndi wu koh ma, aman Bachi ahei gbengblen du kri. ");
INSERT INTO jid_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Indji ri ni gbere san ni vi bari zan bru bari nakima indi ani gbere san ni viba wa wu'u du ko nghab sun ni mi hakakewa nitu imere ma. ");
INSERT INTO jid_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Indi wa ni yah ivi, ani yah don Bachi, wa ani ri, ani ri ni Bachi, don ani gri ni Rji, wawu wa ana ri na, a kah ma bubu ri, a kah ma ni Bachi, wawu me si gri ni Rji. ");
INSERT INTO jid_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ba ndi wa ani sun nituma ni mi bu, nakima ba ndi wa ani kwu ni tuma. ");
INSERT INTO jid_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Naki inde ki si vri, ki si vri ni Bachi, inde ki kwu, ki kwu ni Rji, nakima, inde ki si vri, ko ki kwu, ki bi wu Bachi. ");
INSERT INTO jid_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Nitu nakima Almasihu a kwu da luda, du kama ti Bachi u bi kwu baba bi vri. ");
INSERT INTO jid_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Nakima agye bi si tron mri vayi bi? Iwu me don gyen wu si kpa va yi me tsir? Wawu bu wu'u ki kri ni kub tron Rji. ");
INSERT INTO jid_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Don ba nhan zi. Mi shi rji nji Bachi, gbarju ba wawu'u ba kudren ni mu. Ileme ba wawu'u ba gber ni mu. ");
INSERT INTO jid_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Nakima wawu buwu'u ko nghan iri bu ni hla ikpie wa wawu ti ni nyu ma ni kub Rji. ");
INSERT INTO jid_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nakima kika na tron mri vayi bu na. Nakima kina na tron kpabu na, kika na yo tita u kub zah ni mri vayi bu na, ko kika du vayi bu joku na. ");
INSERT INTO jid_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Mi toh di kpa yeme di ni tsutsu ni Bachi Yesu, ba ikpie wa ana hi tsatsra na sei de indji wa a ban da hi tsatsra na. ");
INSERT INTO jid_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Inde bi ri me ani mrey vayi me, wu na si zre ni mi so na. Na kpa wa Yesu a kwu nitu ma ti meme ni biri me na. ");
INSERT INTO jid_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Nakima na ban ikpie biwa ba bi duba kam ti ikpi biwa ba jin mer ye ni bari na. ");
INSERT INTO jid_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Nakima, ni mi koh Rji ana tre ri ba sou na, aman nitu didi ni sun si, ni ki klan suron ni mi Ibrji u Tsatsra. ");
INSERT INTO jid_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Nakima, wa ba gran Almasihu ni koh kima, ahiu kpa ni Rji, naki u gbu di ba ka kpa yeme niwu. ");
INSERT INTO jid_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nakima kika wa kpie biwa ba hiu sun si, ni kpie biwa ba me ta. ");
INSERT INTO jid_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Na kpa i du Rji ti meme nitu kpie u ri na. Iya di wa ani ri kpie wa a du ri joku. ");
INSERT INTO jid_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ana bi du ba tan nanma ko sou imah inabi, ko ni kpie wa ani jin joku ye ni vayi ma. ");
INSERT INTO jid_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Nakima njanji waki hei niwu, bika mla zi ni tsutsu bi ni Rji. Wu u lulu wa isuron ma ana lahtre nitu ikpie wa hankali ma a toh a dede. ");
INSERT INTO jid_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Naki wa ani ti shakka aman da ri, ka toh da lahtre, dona na hei ni njanji na, a lahtre. ");
INSERT INTO jid_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Kita wa kihe ni ngbengblen'a kika vu suron ni biwa bana he ni ngbengblen na. ");
INSERT INTO jid_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ki tie kpe wa ani kpa sron vayi mbu si'a, ndi ndu kpau sen ngbengblen. ");
INSERT INTO jid_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristi me ana tie kpe u son tuma na, na wa ba nha. “Imre biwa ba mre'a a k'ma hi ni tumba.” ");
INSERT INTO jid_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ikpe wa ba nha ni kogon'a, ba nha nda nno ta tre, nitu vusron ni nno ngbengble u litattafai ki he ni yosron. ");
INSERT INTO jid_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Zizan Irji u losron ni nno ngbengble ndu nno yi sron riri u son ni kpambi, nitu son Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","A tie wayi ni sron ri ndi ndu yi gbre Rji ni Tie Bachi mbu Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nitu kima, kpa kpambi to wa Yesu Kristi ngame a kpa yi'a ndu nde Yesu kpa gbre san. ");
INSERT INTO jid_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Mi tre ndi Kristi a ka tie gran u yoji nitu ndindi u Rji, a tie wayi ni ndu ba tabatar ni alkawarai wa banno ba tie sesekasea. ");
INSERT INTO jid_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ni ndu Bira gbre Rji san nitu losron ma. To wa ba nha, “Mi gbre yi san nimi Bira, ndi yose u gbre san nimi nde mbi.” ");
INSERT INTO jid_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ngarli, Ngyri, biyi bitsri, ni ndji ma. ");
INSERT INTO jid_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Gbre Bachi san ngarli, biyi bitsri wawu'u. Ndu ndji wawu'u gbre wu san. ");
INSERT INTO jid_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ishaya a tre ndi, Ba fe iha Jessi, wa ani wlunde nda tie cuu nitu bitsri, bitsri ba fe ngbengble sron ni mi ma. ");
INSERT INTO jid_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Irji wa ki yo sron niwu'a, nno yi ngyri ni sii ni kpa y'me, ni ndu ngbengble Brji tsratsra nno yi sron. ");
INSERT INTO jid_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ime nitu mu mi kpayi y'me, mrli vayi. Mi kpa y'me ndi biyi ni tumbi bi tie ndindi, ndi he ni to wawuu. Mikpa y'me ndi bi fe kon ndi nno kpambi tre. ");
INSERT INTO jid_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Mi nha ni yiwu ni ngbengble sron nitu kpe bari, ndi ndu nno yi myrien, nitu nno wa ba ne rji ni Rji'a. ");
INSERT INTO jid_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Innoa ndume ka tie gran Kristi Yesu wa ba tonu ni bi kora, limami u tre Rji mi tie nayi ndi ndu nno bikora, ndu he kpe u kpa, ni kebbabe u Rji. ");
INSERT INTO jid_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Mi wruwo ni san nitu ndu wa mi tie ni Rji'a. ");
INSERT INTO jid_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Mina he kpe wa mi trea na, sai kpe wa Yesu tie ndu ni mea, ndi ndu bikora hu tre nda tie ndu. ");
INSERT INTO jid_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Nitu mgban, ni al'jibai, ni ngbengble brji tsratsra rji ni Urushalima, kagun hi ni llirikum, ndi ji bishara Kristi ni ngbungblu wawu'u. ");
INSERT INTO jid_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ni konyi imyrien mu a he u tretre Rji, ni whrji wa bana to Yesu ni mi nde mua na, ndi ndu me na me nitu ndu ndjiori na. ");
INSERT INTO jid_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Towa ba nha, Bi wa bana taba hla tre ma ni bawu'a na, ndu ba to. Biwa ba na taba wo du mana ndu ba to (fahimta). ");
INSERT INTO jid_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ba zu me bubu ye niyi ni ton gbugbuu. ");
INSERT INTO jid_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Zizan mina he ni mbru bubu ni mi gbuyi ni mi se gbugbuu mi zi yosron u ye niyi. ");
INSERT INTO jid_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Iton wa mi he ni Asbaniya mi yo sron ndi mi zu niyi, mita tie mrli vii niyi bika hu me hi ni kima. ");
INSERT INTO jid_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Zizan mihi ni Urushalima, don tie ndu ni bi hi Rji tsratsra. ");
INSERT INTO jid_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ahi kpe u ngyri ni ndji bi Makidoniya ni Akaya ndu ba nno kpe ni bi kungyre (poor) nimi idji bi hu Rji biwa ba he ni Jerusalem. ");
INSERT INTO jid_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ba ngyri don a he na hla ni tumba. Don bikora ba kawo kabi niba ni mi kon Rji a kati hla ni bawu ndi du ba zoba ngame. ");
INSERT INTO jid_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nakima, mita nno ba kpe wa miji ni ba wua, nini hi ni spain (Asbaniya) mika zuye niyi. ");
INSERT INTO jid_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Mito ndi iton wa miye ni yia, miye ni lulu Kristi gbugbuu. ");
INSERT INTO jid_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Zizan mi breyi, mrli vayi, nitu Bachi mbu Yesu Kristi, ni son u Brji tsratsra, ta tie ndu bre Rji ni mu ni mi bre mbi. ");
INSERT INTO jid_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Bre ndi ndu me gbujubu ni wo biwa bana kpay'me ni Rji ni Yahudiya na, ni ndu indu wa mi tie ni Urushalima ndu hi kpe wa idji bi hu Brji tsratsra. ");
INSERT INTO jid_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Bre ndi ndu me ye niyi ni ngyri nitu kpa y'me Rji, ndi ta yayi fe sii. ");
INSERT INTO jid_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ndu Rji u nno sii hu niyii. Amin. ");
INSERT INTO jid_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Mi si tsro yi Fibi wa ani tindu ni ikillisiya wa ahe ni kankiriya. ");
INSERT INTO jid_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Bika kpaa ni mi Bachi, nitu iko wa ahi ni biwa ba kpa njanji, kri wu ni mi iya ma. Nakima wawu ni tuma, a ta zo di gbugbuu, ni me game. ");
INSERT INTO jid_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Chi Bilkisu mba Akila, kpukpan bi du ni mi Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Nakima, nitu mu bari ba ka dri mba grji, mi singiri ni bawu, ana me nikankrji muna, aman ni ikillisiyoyi ba wawu'u, ni bi kora ba. ");
INSERT INTO jid_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Chi ikillisiya wa ahei ni koh mba. Chi Abainitas u son me, wa a guci kpah Kristi ni Asiya. ");
INSERT INTO jid_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Bika chi Maryamu wa ati ndu ni yu'u gbugbu'u. ");
INSERT INTO jid_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Bika chi Andaranikas mba Yuniyas, mri yah baba kpukpan bi son kotro. Ba toh nimi hi toh du, biwa ba hei ni mi Kristi guci ni mu. ");
INSERT INTO jid_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Bika chi Amfiliyas u son ni mi Bachi. ");
INSERT INTO jid_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Bika chi Urbanas ikpan u tindu mbu nimi Kristi mba Istakis u son mu. ");
INSERT INTO jid_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Bika chi Abalis wa mi kpa nyme niwu ni mi Kristi. Chi biwa ba hei ni ko Aristobulus. ");
INSERT INTO jid_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Bika chi Hirudiya vayi mu ni biwa ba hei ni koh Narkissa, bi wa ba hei ni mi Bachi. ");
INSERT INTO jid_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Bika chi Tarafina mba Tarafusa biwa ba si ti ndu Bachi. Bika chi Basisa u son wa a ti ndu Bachi gbugbu'u. ");
INSERT INTO jid_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Bika chi Rufus u chu'u ni mi Bachi mba iyi ma ni me. ");
INSERT INTO jid_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Bika chi Asinkiritas mba Filiguna mba Hamis mba Baturobas, mba Hamisu baba mri yah wa ba hei baba. ");
INSERT INTO jid_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Bika chi Filolugus mba Yuliya, mba Niriyas baba mri vayi ma, ni Ulumfas ni bi wa ba tsatsra wa ba hei baba. ");
INSERT INTO jid_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Bika chi kpa hi ni bi tsatsra ni sumba. Ikillisiyoyi Almasihu wawu basi chi yi. ");
INSERT INTO jid_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ziza'a misi bre yi mri yah, bi ka rhi mren fa nitu biwa jin gakpa ni kub zah. Bina si hu itsro, bika hi gbugban bu. ");
INSERT INTO jid_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Nakima iri ndi bi yi ba na bi gran Bachi Yesu sei ni mi ne ba. Ni roh yun ba, basi gyuru isuro wa ana lahtre na. ");
INSERT INTO jid_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Nakima nzren bi u bi hu, a zren hi ni ton ndi ba wawu'u isuron mu ti kikla rei me ni yi, aman me so du yi hei ni toh nitu ikpie wa a didima, i bi na hei ni lahtre na nitu ikpie wa a meme ma. ");
INSERT INTO jid_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Irji u sun si ani du yi chan ibrji ni inda zah bi. Zizi u Bachi bu Yesu Almasihu du sun ni yi. ");
INSERT INTO jid_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timothy ikpan u du mu, ani chi yi, nakima Lukiyas ba Yason ba Susibataras ni mri vayi mu. ");
INSERT INTO jid_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Me Tartiyas wa ba nha ibe, ki chi yi ni mi Bachi. ");
INSERT INTO jid_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus wa ani kpa me ni ikillisiya wawu'u basi chi yi. Arastas u zi klen u gbu ani chi yi ni kwartus vayi mu. ");
INSERT INTO jid_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Zizi u Bachi bu Yesu Almasihu du sun ni yi wawu bi. Amin. ");
INSERT INTO jid_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Ziza'an wa ahei ni gbengbenlen u karfafa yi nitu tre ni wa'azi Yesu Almasihu wa nitu ma ba tsro ikpie biwa ba hei ni bu ni sen mu. ");
INSERT INTO jid_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Nakima ziza'a ba toh ba nitu ibe, u bi Annabawa nitu umarni Rji u tutrun, don hu njanji ni mi bi kora wawu'u. ");
INSERT INTO jid_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Irji ni ka nkrji a toh nitu Yesu Kristi gbere san a tabata sesei ni sei (tutrun). Amin. ");
INSERT INTO jid_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Yesu Kristi ni kpayem lrji ayo Bulus du ri nimi bi wa wa tindu niwu ni kpayem Bachi ni wawu vayimbu sastanisu. ");
INSERT INTO jid_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Ni biwa bahe ni tra wubre irji ni Korinti nbi wa ba ke be ni ba. ninde irji da yo ba nisan ninde waba glaba niyi Yesu ni bi waba he ko nintse da kpayem ninde irji wumba ni wumbu. ");
INSERT INTO jid_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Du alheri ma nison wubima du hei niyi wanda ni Rji Bachi Timbu wa wawu Yesu Kristi ");
INSERT INTO jid_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Me kiri ni irji mu cacu ni tu mbi don alheri wa Bachi Kristi Yesu ni noyia. ");
INSERT INTO jid_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Anoyi gbugbu u nitre du ni ilimi. ");
INSERT INTO jid_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Na wa janji tre irji hla ni yiwu wawumbia. ");
INSERT INTO jid_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Naki bina wa kpi u ruhu hama na wandi bi gbenbayani u Rji Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Da du yi kpayemen didi ine har hi kle du ba na ka tou yi ni latre ni ye Yesu Kristi na. ");
INSERT INTO jid_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Irji wawuyi wu amina wayata yoni mi bi zumata bi waba yi biyaya ninde vrema Yesu Kristi Bachi mbu ");
INSERT INTO jid_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Zi za'a me bre yi mir vayi ninde Yesu Kristi na gatumbi tie kankana ni son kanka nikpambi na me bre yi katumbi si son ni suron bi riri ni manufa riri. ");
INSERT INTO jid_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Me woh son bi mir vayi miniko kuluwi ba la ni mu andi meme son a he ni yi. ");
INSERT INTO jid_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","A bari ba tre “Me he ni kogon Bulus” ko me he ni kogon Afolos ko “Me he ni kogon Kefas” ko “Me he ni kogon Yesu Almasihu”. ");
INSERT INTO jid_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasihu agakpama tin kankan? Ba klo Bulus don biyi? Bayi Batisma yiwu ninde Bulus? ");
INSERT INTO jid_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mekiri ni Rji mena yi baptisma niri mbinas me to Kiristus wu Gayus me yi nihawu. ");
INSERT INTO jid_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Na ki ba wanda ni tre bayi baptisma niwu ninde mu. ");
INSERT INTO jid_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Ime metou me yi Baptisma ni ndi biko Sitifanus, Bayaki me na tou ko meyi Baptisma ni nro na) ");
INSERT INTO jid_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Meto irji ana ton me du me ye yi Baptisma na, ama don meye hla tre ma bani wani tre wu wayo ba yada di iko Baci na zama ni kaskanci na ");
INSERT INTO jid_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Naki u tre gicciye na he ma'na nishishi bi wa ba si halakaa na. Ama bi wa ba fe son kasai kasai a hi iko Rji. ");
INSERT INTO jid_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Ihlan tre ma ahla “me kpa tre hi tice ni ba to zan ko nha me kpa du ichemba timeme. Wa batre ba to zan ko nha. ");
INSERT INTO jid_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Wu to zan ko nha ahe nintse? Ina ndi wa tre wawu masani? Ina indi watre niwawu tokpe zan ko nha ni gbugbu'u? Irji na hla wawu kma indi wuce kma zama wawu na. ");
INSERT INTO jid_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Du gbugbu ni wur wah ni drima anato Irji na wu Irji a sisuron ni biwa da a kpaba u ba kpayem niw-u ninko wotamba wa bla wa'azi ");
INSERT INTO jid_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","U yawudawa ba tre baha ba bida ni alajibai wu helinawa nibaba ba bida ni hikima. ");
INSERT INTO jid_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Du naki kita khla tre Rji ni gicciyaye tita wu kubza yahudawa ni iri wauta wu helinawa. ");
INSERT INTO jid_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Naki biwa irji rhiga yo ba ni yahudawa ni helinawa kyi hla tre irji na yadda a zama gbi gle ma ni hikima Rji. ");
INSERT INTO jid_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Wauta u Rji a zan hikima wundi wureshi gbe-glen Rji a zan wundi ");
INSERT INTO jid_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Toh yombi mir ya. Ana gbugbuwubi ba he ni hikima ni shishi indi na. Ana wa wumbi bi he ni gbe-gble na. Anha wawumbi bi fe gni yi ni ko bi cu na. ");
INSERT INTO jid_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Irji a cu kpi bi meme ma ni gbu-gbu wa ni nondi bi hikima shan. Irji cu kpi bi hama ni gbegble du ba no kpi bi gbegble shan. ");
INSERT INTO jid_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Irji ni ju kpi wa bana he ni daraja ni ya lega ni gbu-gbu. Aniya da jwu kpi wa ba hamanifani du ba me ni kpe ufani zama banza. ");
INSERT INTO jid_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","A tei naki du dyo duna ya di wawu hi kpe ni shishi ma na. ");
INSERT INTO jid_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Domin kpe wa Rji a tei zizan bi he miyi ninde Rji wandi a he ni hikima ni tawu riji ni Rji. Ahenhaki adalcin mbu wu Tsarlu mbu ni fansarmbu. ");
INSERT INTO jid_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Du naki yada ba nha naki, indi wu wurwo ni san du yi fahariya ni ninde Irji. ");
INSERT INTO jid_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ninton wo me ye niyi mir vayi mena ye ni gwa ninta ko ni hi kima na nitre irji, ni bunko kpi bi biwa ba rhiba gamee ni tre Rji wa me kpayem ni wu. ");
INSERT INTO jid_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ninto wa mw yo suron mena takpe na nintu, me na he niyi na, sai de Yesu kristi, wa bi kle ni gicciye ni. ");
INSERT INTO jid_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Me he niyi ni mi ya ni sisir ni wer Kpa gbugbu'u. ");
INSERT INTO jid_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Nitre mu, ni dubu mu banahe gur hankali wukpi wa he nimi hiki ma na iye ni zho Ruhu mai-sarki ni iko. ");
INSERT INTO jid_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ana niyo suron mbi tu kpe wu biki ma ndi du hei wu Rji. ");
INSERT INTO jid_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Zizan ki tre wu hikima ni biwa kuson kpan kpan ahna biwa boo he ni biki ma gbu-gbu'u ko hi son ni mulki wu ton yi wukle yi wa ba ki wace. ");
INSERT INTO jid_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Naki ki tre nitu hikima wu Rji wa a riri da wu jaji wa bariyi ni hikima wu Rji wahe riri tun niton dau kako ima. ");
INSERT INTO jid_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Dubircu bi zizan ha na tou ki na, ba di na to niton mu ba di na kpayem do glo Yesu zu dakaka na. ");
INSERT INTO jid_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Wunaki nitrema, Rashishi wato, u ba ton awo ba suron ndi wa taba rhimere kpi biwa Irji a tiba nibawu ba wa ba kpayeme niwu. ");
INSERT INTO jid_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ama ikpi biyi Irji a tsor ta ni zo Ruhu. Nakiyi Ruhu niya kpi biwa bahe ni zurfi wu Rji. ");
INSERT INTO jid_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Anha to mi suron ndi, naki se de ruhu wa a he nindi? naki ba indi wato du kpi bi zurfi wu Rji saide Ruhu Rji ");
INSERT INTO jid_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Naki kina kpa ruhu wu gbungbu'u na, a Ruhu wa ahi kina kpa ruhu wu Rji kima wakya nito kpi ni shishi wa Rji a nota. ");
INSERT INTO jid_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ki tre ni tu kpi biyi ba ni klama wa ndi ba tsro ta ni hikima ndi ba ama ni Ruhu wa w tsou kpi bi ruhu ni ndi bi ruhu. ");
INSERT INTO jid_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Wa ana he ni Ruhu na ana kpa kpi bi Ruhu Rji na, ba zama kpi bi wauta niwu. Ana iya datoba na, don ba kpi bi ruhu. ");
INSERT INTO jid_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Wa he ni Ruhaniya ani shari anta kpi ba na duki naki ama bari ba na sharanta u na. ");
INSERT INTO jid_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“A nha iya tou suron Rji wa ni iya do tre wawu ni tsro wu?” Duk naki kita kihe ni suron u vera Rji. ");
INSERT INTO jid_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Ime miri vayi, me na tre niyi ni na ndi bi ruhu na ama nadi bi nema kpain bi mir ziza ni de kristi. ");
INSERT INTO jid_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Me noyi mada ra ana hla wu sain mana, bina iri na kio zizan mal rina ");
INSERT INTO jid_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Du zizan 'a bibi n'ma kpa, wa ingu ni do shishi he ni mi suron bi. Du naki bina to bina bi n'ma kpa na? Zirmbi wa indi ba tsra yi to? ");
INSERT INTO jid_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Din iridi wa tre wawu “ni wu Bulus wawu ni kongon Afollos” naki bina ndi nlege na? ");
INSERT INTO jid_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Me miya a nah Afollos? Anha Bulus? ana bi waba kuyir ni son mba, wabi kpaye ni ba nawa Irji noba du' na. ");
INSERT INTO jid_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ime me chu, u Apollos mba a bwa m'maa wu Rji a du ba Rju. ");
INSERT INTO jid_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Naki iwa achu, ke niwa bwa m'ma ba na kpe na. Ama a hi Rji mba ni du gbro. ");
INSERT INTO jid_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Wa achu niwa a bwa m'ma ba riri, u ko nha ani kpa knima tsra ni du wa a tei. ");
INSERT INTO jid_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Naki wawu mbu k'mir Rji kpukpambi duma wa ki zama ijhuma a tie ta. ");
INSERT INTO jid_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Ni alherin Rji wa ba ne, cikake wu meh wa meh zinci harsashi, uri ani meh ni whu me, du naki kowane indi aniya yada imeh ma ni he gyagyer. ");
INSERT INTO jid_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Ba indi wa ni zinci harsashinma kan niwa ba riga da ziye wato Yesu Almasihu ");
INSERT INTO jid_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Zizan'a indi wa meh nitu har sashi rhi kan, wu zina riya ni wu ozurfa, koni wu titta bi daraja ni kukor, ni ciyawa ni tattaka. ");
INSERT INTO jid_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","du induma ni mlaye wa vyi wu mlaya ni he. Ani wu mlaya ni luwu. iluwu ni shell wu bima wa konha a teir. ");
INSERT INTO jid_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Wu indiri wa duma abi, anika zizima. ");
INSERT INTO jid_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Toki wu indi wa induma a gonlu wawu aniyi da shaya asara u wawu ni tu ma ani nawo ama da kir. ");
INSERT INTO jid_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Binato di bi hai kadi u Rji u Ruhu Rji ani son ni kpambi na? ");
INSERT INTO jid_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Indi wa akpa haikali Rji u Ruhu Rji ti meme Irji game ni kpa ti meme. haikali Rji awu tsraki wukitaa me anaki. ");
INSERT INTO jid_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Du ndio duna gur tuma n, idi wa aya tuma ani wawu kpe, ni son bi wawu, waniya ni wawu a zan konha, di wawu a he ni hikima niton mbu wu zizan du k'ma ti wawu don da zama u hikima. ");
INSERT INTO jid_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","U hikima wu gbugbu'u yi kalacu mu ni Rji naki itre ma ba hna da tre “ani vuu bi hikima ni makircin mba.” ");
INSERT INTO jid_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Har luwa 'Irji to mer bi hikima a wu megye”. ");
INSERT INTO jid_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Tok ni meryi du ndio du na wur who ni indi na duka koge hi wume. ");
INSERT INTO jid_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Ni Bulus u Apollos, U kefas, u gbu-gblu u rai, u que u kpi wu zizan, u kpi bi ye no ko shishi, wawu ba wu mbi. ");
INSERT INTO jid_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","U biyi biwu kristi, u kristi hi wu Rji ");
INSERT INTO jid_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Wayi akon wa indi nito ta di ki mirko kristi wa ki tidun mai janji u Rji. ");
INSERT INTO jid_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ni tu ki bason biwa ha he ni kpayeme ba ba ka yemen ni suron mba riri. ");
INSERT INTO jid_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Nime ana hi wani kpe du ba tre di bi sharan ta ni me ko bubu bla tre u ndi na Ime me mina sharanta ni tumu na. ");
INSERT INTO jid_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Mena to hla tre wa'a he ni tumu na kuma ana wa me tre mena bla tre na, u wa anito lha tre mu ahi Rji. ");
INSERT INTO jid_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Naki na sharanta ni tu kperi kafi tan, kafi ye Rji. Ani lha du kpi niwa ba he riri ni mi bwuh da tsro manifa mba u mi suron. Naki ke nha ni kpa zizima ni wo Rji ");
INSERT INTO jid_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Mir vayi me tre tre nimer mu niwu Afollos don biyi, bi iya to manufa tre wa ba tre adi, “Nati zan kpi wa ba nhann.” Naki, don du ndi ri ban tuma ani wa wu zan ndi rira. ");
INSERT INTO jid_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Anha a to kan kanmbi ni bari? Bi he nigye wa bana nayi negye na, idan megge bi kpa, wu gye sa bi wurwi nikpambi na bi na kpa na. ");
INSERT INTO jid_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Naki bina wa kpe hama na! bi riga he nikpi gbugbu'u wa biwa u bi riga sur cumbi me ba tere nita na. Naki me bi di na ti ndu tuchu'a ni tawu di du kita game ki he ni yi. ");
INSERT INTO jid_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Nimer mu kipayeme Irji a yota manzani kiman ki koga wawu na wu ique ni hi ni tumba don ki zama kpe wu tsro ni gbugblu baba mauaiku duk baba ndi wawu. ");
INSERT INTO jid_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Ki he na biwa bana tokpe na sabo ni kristi wu bi he ni hikima ni nde kristi, ki hama ni gbegble na wu biyi bi he ni gbegble ba toyi ni daraja u ba na ta ni daraja na. ");
INSERT INTO jid_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Yeh ninton yi zizan iyaniti ta u nhama, wo bi sur me bana bina, batsita ba koh wu son. ");
INSERT INTO jid_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ki farma nidu ni wombu. wuba mer ta me, ki ti lulu yo ba wu, ko ba tsan ata tawu ki vu suron. ");
INSERT INTO jid_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Du wa ba mer ta ki tre ni ba ni si suron ki he na bubu wu ka tsu le ni gbugblu, na kpi wa ba na bi ya na. ");
INSERT INTO jid_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Me na nha kpi biyi don me noyi sha na anibi du me mla tre didi ni yiwu ni wa me kpayem ni yi na bi mir mu. ");
INSERT INTO jid_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Wuhini he nibiwa lura ni yi du bu wula ni nde Rji, bi na he ni ba timbi gbugbumbi na. imeyi me yi me k'ma timbi ni cikin kristi Yesu domin Bishara. ");
INSERT INTO jid_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Anaki me yo yi du yi ti na wa mi ti'a. ");
INSERT INTO jid_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","A he na ki u me ton Timoti ni yi wa me kpayem ni wu kpukpome ni u Rji. Ani la hla yiwu jkon mu ni kristi na wa me tsro ba ko ni tsei, ni kowani tra Rji. ");
INSERT INTO jid_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Bari min mbi ba zu tu tsa na di me ta ye ni yi na. ");
INSERT INTO jid_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Wume mi ye niyi bawuntoba idon Riji kpayem. Ni ki mi to bi wurwa ni suron baba biwa ba tre bato zan konha. Mi kuma to gblgble suron mba. ");
INSERT INTO jid_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Mulki Rji a na tre mege ni sai ni gbl-gble tou yeyer. ");
INSERT INTO jid_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Biwagye? me ye niyi ni kpalla koni ruhu Irji. ");
INSERT INTO jid_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Khiwo kpi da ni ze niyi, meme tre wa da nabi woma nitumbi ni biwa bana to Rji na. Bari ba kur ni mba ba timba. ");
INSERT INTO jid_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Wa naki bi wur woh ni suron. Bina yani yi na niya indi wa asi tindu banza mba, anibi bka zu'u du na son niyi na. ");
INSERT INTO jid_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ime mina hei niyi shishi na mi hei niyi ni ruhu. Me kuma mi riga nino tre ni tu ndi wa la tre iri meme ki, a hei na me hei niyi shishi ni shi. ");
INSERT INTO jid_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Du shubi mbi wa biyi ni nde Rji, Yesu ruhu mu a hei niyi ninde Rji u iko Rji mbu Yesu a hei ni ki. ");
INSERT INTO jid_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Ka ndi kima cuwo ni meme birij dukpa kpama ti meme du ruhu ma du fr rini vi wa irji niye. ");
INSERT INTO jid_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Wurwo mbi ni suron anabina, bi to ni yisti a vikpe vyivyi ma ani kpa dunkle bread ti meme? ");
INSERT INTO jid_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Mbla son bi wu zizan ti, na son na cice yisti wu kogo na, di son na gurasa wu zizan nawa ana hei ni yisti na. ba riga da yi hadaya Alamsihu kre kujru mbu wu di. ");
INSERT INTO jid_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","A naki bari ki kiyi hifinma waana cice yisti ma na a yisti iri wu rashin son mu meme son niwu meme suron. ");
INSERT INTO jid_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Me nha tre yi niyiwu duyi na k'ma tumbi bi nibiwa babi wamba ko bi wa lilo na. ");
INSERT INTO jid_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Mena yemen ni bi rayuwa banza u gbugbu yi na ni bi son tumba nibi hugumaks zhni nibiwa ba na whu Rji na, du idan wu cutume ru ni ba cutu me ru ni ba sai u ka ru ni gbugbuyi. ");
INSERT INTO jid_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Zizan wa me si nha niyi wu na katumbi ni bana wa a tre di wawu vayime wu son ma a wu fasikanci, niwa ni tei ghye ni wa ni who tre wu meme bniyi ni wu ashar ne ni ndi wuso niwa ni cuce nindi. Nakpaye me di ri biri biwuna. ");
INSERT INTO jid_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Naki me ti nitei di tre ni biwa ba kamba nikpa tre Riji. Wu naki wu na tre bi wa ba kpa tre Rji na? ");
INSERT INTO jid_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Ama Irji ne sharanta bi wa ba he ni korah “cu ndi wu meme dir thu ni kpambi.” ");
INSERT INTO jid_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Anibi niyiwu indi wa a hei ni tre wugbi suron ni vayi ma waka grji u he nibiwa bana to iter Rji na? Ana zan wa ani grji u he nihiwa bato ter Rji ni suron mba na. ");
INSERT INTO jid_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Kinatona indi biwa babi whu Rji gyegyer babayi ba bla lhater ni gbu-gbu yi. wa anitahe naki bina to din iri tre bi zizan a bayi bi na shutei ga son wubi mana? ");
INSERT INTO jid_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Binato de kitayi kiyi shari ani malaiku Rji na? wani hei kinaya nimla son mbu tei na? ");
INSERT INTO jid_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Wu nisonbi biyi sha na lhuwa ba mble, wa gye sa wubi na tre yiriki nihe ko shishi biwa bana bana bi whu Rji na. ");
INSERT INTO jid_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Me lha ter yi niyiwu ni shan nishishi. Ba indiri niyi waheni hikima wu bima wa ani mla gbi suron mba ni kpabi na mir vayi. ");
INSERT INTO jid_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Li vayi ni vayi bi bwu Rji hahe kotu ni blater sharia baba biwa bana to Rji na. ");
INSERT INTO jid_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ni tre wu janji mbi ba tre sharia yoh ni suron mbi wa hei niwa bi riga ni nyoku. Agye nisa tiyabi niwu megye? Agye ni zuyi ni kpabi du ba mye yi? ");
INSERT INTO jid_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","U biyime ni nikpa kori tim meme, bi cida, wa bi tiwayi ni kpambi mir vayi! ");
INSERT INTO jid_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Bito ni niwa bana he ni adalchi na bana rhi niko Rji na. Du ba na guru tumbi na nibi timdu fasikaci, ni bi wa ba whu ter irji, ni wamba ni lhu lu bi wa ba tindu mba ni bi wa ba hei ludu. ");
INSERT INTO jid_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","Bi yipyi bigye, bi sou bi mre bubu ni bi damfarar, koba tei nihe bana rini ko Rji na. ");
INSERT INTO jid_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Bari mbi bana hei toki. U zinza'a ba glayi, da bayi no Rji, da duyi hei na mir Rji ni de Bachi yesu Almasihu ni Ruhu Bachi mbu. ");
INSERT INTO jid_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Dui kpi wa bikito ba na meme ni mu na ama d na ko gye hei mu ni ndu na ko anfani na. Ko gye abi ni me ama ana kogye ni dame ni me na. ");
INSERT INTO jid_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Biri a wu gbwune, wu gbwu a wubiri” Irji ni ka ba le hamba wu. U kpambu ana hei wu fasikanci na. Ikpambu hi wu Rji, Rji ni tanada ni kpaa. ");
INSERT INTO jid_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Bachi yi ata Rji shipe, wa wuyi ani skae ta tashipe ni gbe gblen ma. ");
INSERT INTO jid_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Binato ndi kpambu ba gabu bu wet u Rji na? Me ya ni vu hgiga kpa Rji ni kpambu ni wu tar wa? Wana hei naki na! ");
INSERT INTO jid_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Binato ndi wa a ka kpama bi ni tar wa ba hei riri ni wu na? Na water Rji a hla Nitawu “Habawu ba nama kpa riri.” ");
INSERT INTO jid_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Indiwa a ka kpama no Rji ba rubu riri ba wu. ");
INSERT INTO jid_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Guje ni fasikanci du lha ter wa ndi tei a hei ni kora ni kpama ama ndi wu tei facikanci a ni tei lha ter ni kpa ma. ");
INSERT INTO jid_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Wuna to ndi kpa me a bubu son Ruhu mai isarki na? Wa a son ni wu wa wu kpa ni Rji? Wu to di wuna so tume na? ");
INSERT INTO jid_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Domin bale wu ni le wu tsada, naki u ka gbre Rji san ni kpame ni mi ruhu me. ");
INSERT INTO jid_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ni tu tre wa bi nha din. “Abi ndi du ndi duna hei ni wah na”. ");
INSERT INTO jid_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ni tuter kpa wa ani du ndi lha ter wu ti fasikanci wu bar ma, wabi ndi du son ni wah ma, u wah me ka son ni lhon ma. ");
INSERT INTO jid_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Du lilon coka alkawali u bayi bula kpa u wama wawu wah me ka no lho ma kpe wa hul ho ni bukata ni kpa ma a. ");
INSERT INTO jid_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Ana wah hei ni iko kpa mana a lho ma he ni ike kpawaha naki ilho me ana he ni iko wu ka kpama nyu wah na kpa ma me a wu wahma ");
INSERT INTO jid_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Na kpaye ni zukpani kakpahibi na, bita hei ni yarda kpambi u ton wa agamshe yia. Bitei na mba ndi du tunbi hi riri ni bre Rji. Ni lha gyi tumbi ye ni kubu Rji ni mla son hi, toki du meme briyi na kpayi ti meme na don bi na son ni gbegble na. ");
INSERT INTO jid_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Me bla ter bayi ni yiwu ba don me no yi doka ko me ka gbi yi suron ba. ");
INSERT INTO jid_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Ana bi du konha du he na mu yi. Konha he nikpe wa Rji no a. iri hei ni kpe mu, u wamu he ni kperi kan. ");
INSERT INTO jid_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Imba bi wa ba na gra na baba mba bi koh abi du ba na gra na wu mu'a. ");
INSERT INTO jid_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ama idan ba na iya vu tumba na ba ka gra. A fi duba gra ni du ba ri lu. ");
INSERT INTO jid_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Nibiyi wa bi son gra mi noyi mer ana me n, a wawu Rji ter tawu, iwah du na kama ni lon ma na. ");
INSERT INTO jid_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","(U wa u gra nita kalon ma don, wu kason hama ni gra gari, ko ka kmaye da mla son mba tie mba lon ma), wu wawu lulon me kana kpeyem da ka wah ma don na. ");
INSERT INTO jid_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Me tre niyiwu burbi, lme ana Rji na idan vayi ma don na. Me tre niyiwu burbi, lme ana Rji na idan vayi ma a he ni wah wa ana kpa Rji, n nda kpeyemni son ma niwu, wa kana kama ni son nawu na. ");
INSERT INTO jid_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","U wah wa ba gra da son ba lon ma u lilon ana kpaji na wu spom mba abi, wawu wah kana ka lon ma don na. ");
INSERT INTO jid_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","NI lulin wa ana to tre Rji na a ke babbe ni wah ma, u wah wa ana kpa Rji na a kebabbe ni lon ma, naki imba naki ba mir mba ba na hei ni suron wu kpanma na. Wu anihi Jaji wu son babi kpah wu son deidei ma. ");
INSERT INTO jid_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Wu wawu wa a son wu bima wu whu Irji a ter wa wawu ni nyu, waka nyu me hgei. Ni iriter biyi, vayi ni vayi virwa ana lau ni ninina, alkawarin ba na. Barchi a you ta wa kison nikpa mbu na mir vayi ni son wu sesor. ");
INSERT INTO jid_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Wu to kowuyi wah wu kpah lon me cuwo? wu lulon ko wume wukpah wah me cuwo? ");
INSERT INTO jid_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ahei naki Irji no konha kpe wa ani tei konha du zar ni kon wa Rji no duwa ki tei niwu wayi yi a ter mu wa me ter ni biwa ba wu ter mu. ");
INSERT INTO jid_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Bavonju nindi rhi wa kpayeme ni yoh Rji? Duna ya da ni kpayeme ni ter vonju ni wa wu kpe na. Wuna vonju rhi ni kpayeme ni bangkiya me? na du vonju me ba du kpe wu wurwa ni sor me na. ");
INSERT INTO jid_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Ko wu vonju ko wuna vonju na ana kpe wu meme ma na. ikpe wa a bi wu teitei khili ni kpayeme ni irji ni ter magbagban. ");
INSERT INTO jid_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ni wu indi wa wu kpayeme ni yoh Rji wu ka zre gyegyer ni kpaye me ni yoh me. ");
INSERT INTO jid_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Wuna gra niwa Rji yoh? Naban tume no yiri sorkina, wu wuhei ni sor wu tei kpe wu bi ma wu katei. ");
INSERT INTO jid_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Indi wa iyoh ma ana yoh u Rji yoh wa wuyi ni son na vir Rji ba seser. Naki ni knoki indi wa na son na ver wa Rji yoh du kpayeme ni son na ver Rji. ");
INSERT INTO jid_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ba leyi ni le wu barma, wanaki wu ka na son na wu gra ndi na ");
INSERT INTO jid_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Ni son bi mini vayi, ni kowane son bi ni yoh wa ba yoh yi, konha du son ni de Rji. ");
INSERT INTO jid_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Niter wu son ndi wa ana to wah ni wa ana to lulon na, mena to dauka wa Rji ni Rji na. Wume me gniyi mer muye na Rji a hei ni vusor waki kpaye me niwu. ");
INSERT INTO jid_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Wume meto naki me rhime iri meme kpe wa aniye ni koshishi, wa anibi wa indi du hei na ha ");
INSERT INTO jid_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ba loh zi ni kpah wah me? Naka wah me cuwo na. Wuta son ba wah, na yoh suron me niter wah gana. ");
INSERT INTO jid_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Wuta hei ni gra wuna hei ni la tre na, u wa ana to lulon na waye gra ana hei ni later na. Wu biwa ba hei niyra kpa wu yo suronsor nomer wa son ba na zoba na, me son me du yina ba mer bi hei ni ko kina. ");
INSERT INTO jid_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Naki mir vayi me nla yi wu, in ton ki fi me, ziza'a ni hi koshishi biwa ba hei ni mba ba son na hiwa bana hei ni gra na. ");
INSERT INTO jid_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Biyi biwa biyi na du yi hi nwu ni shishi na u biwa ba si gri baka na tsro na ba si gir na u biwa bale nda hei niwu bakana tsor ndi ba hei ni kpe na. ");
INSERT INTO jid_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Biyi bwa biya ni gbugbluyi a wubi bikaya binaya ni tziri ni wu di to tsirmawa wuna Nison gbugblu u ton yi a seye ni kle ma ziza'a. ");
INSERT INTO jid_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Me noyi tre wa aniza yi ko nha duson da kakpale na son wu sisir na uwa a na hei nigra na imer ma a hei ni kpe s Rji ni nondi wani giri niwu. ");
INSERT INTO jid_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","U wa a hei ni gra mer ma a'her ni kpi wu gbugbulu wani son wah ma du son wu nda girni gbugbulu. ");
INSERT INTO jid_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Aga kpama iwa anai hei ni gar na, ko wa ana to lulon na mer ma a hei ni kpi wa Rji bani no wa ani son ni mer da mla kpama ter ni de Ruhu. Wu woh wu gar isor ma ahei ni kpi bi gbugbulu wa anu lohma sisor megye. ");
INSERT INTO jid_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Me oha wayi ni du soi bi du son bi da mla yi tei mena wa me matsa niyiwu na me lah kpe wa a hei naki wa kiwu Rji, ana wa soi mbu niga kankana. ");
INSERT INTO jid_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","I wuri wu tato wuna tei kpa wubi ni kirwa wa son hema nito luloh na ni mla tei na wa zar ni sei wu gra wa naki yi, wa ka tei kpa ani son tei ana lha ter na u ba ka gra kpamba. ");
INSERT INTO jid_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ani ta hei toki wa vusor da kli gbagba wuba matsi wa niya da mla kpa ma tei da ba mer ni suron ma naki dazi tuma hama ni suron wu wamba wa ni tei kpe wu bima i wa a gra wa ana to luloh na a tei kpe wu bima ");
INSERT INTO jid_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Iwu wa wu batume de wuna gra na iwu me wu tei kpe wubima zan konha ");
INSERT INTO jid_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Iwah wu gra a hei ni son nide lohma du wa hei ni sisren. Ida gyu ba u iwah nita to ana iya da son hama ni gra na ani ni du gra ni kno wu hwu Rji. ");
INSERT INTO jid_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Niya mu ani son si nda gri idan a son naki son nigar. me ya i meme me hei ni Ruhun Rji. ");
INSERT INTO jid_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Nitre biri wa ba ti niwa ana hei nikon Rji na, wawu a hei nikon wu hadaya guma kai kito. “wuki hei nito kpiwa ba tsor” wu to bu din ani ya da gyi santu wu kpe wa zanki wa wuyi ki kpayi ni gbabu ni mla kpabu tei. ");
INSERT INTO jid_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Wu tater ni wu wundi wa wu to kpe wana takpe na, indi biki ana tokpe rhina ni mer ma. ");
INSERT INTO jid_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Du indi wa kpayeme ni irji, wu irji a to indi ki. ");
INSERT INTO jid_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ni ter biri wa ba ti ni guma kai hadaya, kito ni “Gunki ni gbugbulu ana kpe na”, wa hei naki, “Irji ri ana hei na Irji riri wa a tei ta. ");
INSERT INTO jid_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","U kita banya kiya rito iri mri Rji bi ziza wa ba yoh bani allo li ba hei ni shulu da hei ni gbugblu nawa irji “ gbugbulu ba hei ni” alloli ni iyayengiji. ");
INSERT INTO jid_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Du naki nikita, ki hei ni Rji rhiri wa wawu a tembu, wawuyi du kpi ni son bu ki hei ni who ma ni verma Yesu Krisiti Irji mbu ni wuyi ikpi bi gbugbluyi ba hei ta wawu kison ni wawuyi ");
INSERT INTO jid_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Du naki, ana ko nha a hei ni toyi naki na ko naki, ikpi biwa batei wa riga da wu ce na biwa ba bauta ni gunki wu ba rhibinyi wa ba tei ni gumalia, Wu mer mba a riga tei meme ye isor a riga da ti kpanye. ");
INSERT INTO jid_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Wu kpe wa kiri anawawu nisa kika to Rji na. Ana meme na wukina rina, wu na bina meha wuki ta ri. ");
INSERT INTO jid_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Wuka mlaya na du zre me du hei wa ni du rhi joku nikon Rji na waw hei ni rarraunar ban gaskiya. ");
INSERT INTO jid_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","U toki indi wa ato wu ndi u hei ni ilimi u si rhi ni ba ni kobi wu gunki. Toki wuna zo u yada a ni kri gbangban ni kon Rji na da njunkon wu rhi biri wa mlatei ni bi wu brji. ");
INSERT INTO jid_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Nitu to, me gre ni kpe wu bima ni wujaji, u to gumaka, iwa ana hei ni gbeigble na wa a vayi iwa kristi a kwiu ni tuma ni ti meme. ");
INSERT INTO jid_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Wuta lha ter ni mini vayi me, wi a kpa mer mba ti meme wu lhter ni Rji. ");
INSERT INTO jid_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Naki idan tre biri ni du vayi mu khubuza wu me mena tan n' ma gana don mena du vayi mu du jou na. ");
INSERT INTO jid_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ime mena son bi na? Ime mena wu whu Rji na? Ime mena to Yesu Irji mbu na? Ana biyi bi tindu ni me ni blater Rji na? ");
INSERT INTO jid_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Idan me na wu blater Rji nibari na u me bla niyiwu, Biyi bi Zame ndi kapyeme nime nitabatar ni ndumu ni bla ter Rji. ");
INSERT INTO jid_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Wayi yiter wa me Kle kpamu idan ndi ba tre nitu mu. ");
INSERT INTO jid_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Kina hei yanci wa kiri ndi sou na? ");
INSERT INTO jid_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Kina hei ni yanci wa ki ba vayi mbu iwah, na wa ibru bi tundu Baci, ni mir vayi ni ndu Rji naba Kefas na? ");
INSERT INTO jid_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Biya kome ni Barnabas megye ki na hei ni iko u kambu ni ndu? ");
INSERT INTO jid_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Anha ni ti ndu soja ni tuma ki mu? Anha ni ron biri ni woma da na rhi iya ma na? wu nha ni ho lando dana so u imasesan mba na? ");
INSERT INTO jid_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Biya me tre tre yi ni gbegble ter ndi mu? Bina to di doka me tre tokina? ");
INSERT INTO jid_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","U ni doka Musa a tre di na yau takunkumi ni wa ni mla biri tei na. A hi jiji lando wandi Irji ni kwa ha? ");
INSERT INTO jid_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ana si tre ni tumbu, indi na? ba han ta wu ndi indi u yoh sor, anife indi wa ase tat take hiri, wa wumw du tei ni suron riri anife. ");
INSERT INTO jid_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","U kita cu wu ru haniya ni yiwu ani kpe rigra ma duta girbi kpibi wu kpah ni yi? ");
INSERT INTO jid_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Indan bari ba te yana yi ni yi, kina zan ba na? Ama ki na miye yanci kina kita de ki vu suron ni koga don ki na kpa tre Bishara Kristi ti meme na zuta tendu Bishara Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Bina to biwa ba tindu ni mi tar Rji ba fe hla ni sau mba ni kiyi na? Biwa basi tindu ni tra Rji ba hai ni rabo mba ni kpi biwa ba rhi ni myi hai kalin. ");
INSERT INTO jid_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Ana kiwi Rji tre bi tendu ni terma Bishara bari da sau ni tunko bishara. ");
INSERT INTO jid_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ama ime mina miye yanci ri me na me na nah du ba ti kep ni muna; croma du me kwuu ni du indi hana ni me ni bubu grie ni tu kpe u bi yi. ");
INSERT INTO jid_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Indan me bla tre bishara me ha hei ni kpe wu wurwo ni suron na a hei nimu hello du me ti ndu ki. Ani meme ni idan me na bla tre Bishara ");
INSERT INTO jid_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Meta tei wayi ni suron mu riri, me kpa kpe wa Irji a zinimu u bima. Ama hle ta na ti ni suron riri na. u me rhi he ni nauwaya nitu mu. ");
INSERT INTO jid_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Wagye a rabo mu? U meta bla tre Rji me ya ni no Bishara nina kpa gbe wa a hi yancu mu ni ti bishara na. ");
INSERT INTO jid_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Ko da ike iwo mu na sa kpe na mi kati grah ni ndi don mi ndi gbron gbuglu wu ye ni Rji. ");
INSERT INTO jid_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Ni Yahudawa, me k'mati bayabude, don ndi gbi yahuda. Ni bi wa ba hei ni zha bi blah ter, do kpa me, mi hei ni mi mba meni gbi wa ba hei ni zha bi blah tre me ti na ki ko da shike mi na hei ni bi blah tre na. ");
INSERT INTO jid_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Bi wa bana hei ni karkashi sharia na ime me k'ma hei na bi wa ba na he ni shari'a na ko shike me na hamma ni shiriya u Rji na Du naki me hei karkashi doka Rji me ti naki me ndi kpadi bi wa ba na he mi sharia na. ");
INSERT INTO jid_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ni biwa bana hei ni gbegble na, me hei naki niba don me gbro bi hama ne gbengblen. ");
INSERT INTO jid_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Me tei kogye don bishara me ndi yoh woh ni min biwa ba kiti ndu don me ndi kpa albarka game. ");
INSERT INTO jid_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Bina to ndi indi gbugbu u bari ni gasa tsutsu, u bi waba tsutsu a, indi riri ni kpah sakamaka na? ");
INSERT INTO jid_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Indi u tsutsu ani mla kpama ti naki dafe gbegble kpama du hyi gyegyer. Ba tei naki du ba kpakpe wa ni ti meme wu bi gasa tsutsu bati nda kpa kpe wa ni kri ko'b ana wu te meme na. ");
INSERT INTO jid_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Anayi me tsutsu na me na he ni manufei na, yada me ti dambe an a kama me ndi da si tsi ni gwugwu na. ");
INSERT INTO jid_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Me mean ni kpa mu ti u yah, na mi gra don idan me bla tre Rji ni bari ime tumu mika na ti meme na. ");
INSERT INTO jid_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Me son duyi to mini vayi bs ti mbi wawumba ba hei ni kar kashin ikpalu nda zu ni myi neh. ");
INSERT INTO jid_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Wawu bawu bayi batisima u Musa ni ba wu ni kpalu mba ni neh. ");
INSERT INTO jid_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Wawumba ba ri biri wu ruhaniya. ");
INSERT INTO jid_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Wawu bawu ba sau kpe wa ba sau wu Ruhaniya. U ba sau ni tita u ruhaniya wa ahu ba, u tita ana Kristi. ");
INSERT INTO jid_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","U Rji ana hei ni se suron ni ya waci mba na k'mo mba ba var belele me ni miji'a. ");
INSERT INTO jid_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","I kpe wa ba nah bani tawu du zama kpe u bu shishi ni tawu duta na yo suron ni kpi u gbugblu na wa baba ba ti di na. ");
INSERT INTO jid_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Kina yah suron mbu ni bauta brij nawa nari bati na. Wa ba nha ni tawu “Indiba ba kuson bari da sau da wu ta rou.” ");
INSERT INTO jid_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Kina yah tumbu ni ter wah mba na ni faskanci na wa gre ba ti ni son mba na. Ni ui riri indi dubu Ashirin don tar ba kwiu ni tu ki. ");
INSERT INTO jid_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Kina ter diki zar Rji to na wa baribati naki u wah bako wuba. ");
INSERT INTO jid_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Na son na biwa ba son ni gbi suron nda tre gburugbu u gbugbu u ba ka kwu kuwu wa malia kai u ye wu ba ");
INSERT INTO jid_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ikpi biyi ba hei nayi don ki kiyah kpe wa hei matsayi mi soli ni tawu. ba han ba don nda tsro kita wa ki hei ni son wu karshen zamanai wa a ye zizan. ");
INSERT INTO jid_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Zi zan indi wa aniya tuma ndi wawu kiri gbangban ka mla ya kada ka ku roku. ");
INSERT INTO jid_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Ba tsra wa ni ye zan gbegblen me wa ana taba faru ni ndi u viri na. ");
INSERT INTO jid_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Wa hei naki mini vayi ru nikon wu bauta ni kpi ni briji. ");
INSERT INTO jid_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Me tre niyi wu na indi biwa ba hei ni to bi ban kpe wa me tre a ya. ");
INSERT INTO jid_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","U gbaju wu albarka wa ki yah albarka ana kiyi ki gah ni hyi Kristi na? Gurasa wa ki gah ana kpa Krisit ki gah na? ");
INSERT INTO jid_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Igble bredi a hi riri, u kita ki hei gbugbu'u hei ni kpa ndi rhiri ki ba gurasa rhiri wawu buwu. ");
INSERT INTO jid_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Mla ya Israilai ba he no kpa. Ana biwa ba ti ndu hadaya ni ba gadi a ba rhi na? ");
INSERT INTO jid_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Me si tre ndi gye kena? Ndi gumaka hi kperi? ko kwa biri wa ba mika hadaya ni gun ki hi kpe? ");
INSERT INTO jid_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","U me ter nitu kpe wa indi ba wa ba tei hadaya ba tei ni Iblis hadaya bana tei ni Rji na. Me her yi na tsontu ni bana ka ni brji na. ");
INSERT INTO jid_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Bina sau ni gbaju wu Rji de hla sau ni wu Aljanu na, bina ka kpambi ni ndi de rhi ni sauni teburin Rji ni wu Aljanu na. ");
INSERT INTO jid_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Kison du Rji tinfu? ki zan ni gblegblrn? ");
INSERT INTO jid_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“Ko gye he ni doka” U ana kingy he ni ri ba na. “Du kogye a gyegye, wana du kpe ni nu ndi kuci na. ");
INSERT INTO jid_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Du ko hna na wa kpe ndidi ni ma na, Naki, u konha kawa kpe wa ni zo vayi ma wata son mba wu a. ");
INSERT INTO jid_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Wuya ni rhi kpe waba si lle niwu ni kasuwa na mye na a hi a gye na. ");
INSERT INTO jid_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Du “gbugbu'u yi a wu Rji wu kpi wa ba shyu ni mi.” ");
INSERT INTO jid_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Indi wa ana kpaye n Rji na a yoh du yi he rhi biri, u wu kpaye ni wu wukana he ni suron bana, rhi kpe wa wuto ni tu tebur ni na mye na imer me ni lha niwu. ");
INSERT INTO jid_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Indi rhi nita hla u “ikpe hi ba ti hadaya ni gunki u kana kpa rhi na, sabo ni ni ndi wa a hla ni wuci, sabo ni mer han greek bi sen ba tre ndi” Meme ni hi wu Rji. Ama vuvu bi didi u greek ba na hei ni bi yi na. Bi blah gbugbu'u ba to wayi na u wa ba bla brubru indan ki ya ni aya. ");
INSERT INTO jid_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Wato lamiri indi rima mu a ba wu me ba. Agye ni sa u ndi ri mu ka hla mu kpe wa imere mu ni hei a? ");
INSERT INTO jid_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Wume to rhi biri ni sor mu ni ghiri wu ba tei ni hei da mer me ni kpe wa me ba ni ghir nituma? ");
INSERT INTO jid_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Wa naki wu ta se rhi ko sau ko u ti gye u ka ti don ndi gbre Baci san. ");
INSERT INTO jid_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Du son me he u bima tare ni yahudawa babu greek ni eklisiya Rji wu kubuza ni Yahudawa wu Helenawa ni ikili siyar Irji na. ");
INSERT INTO jid_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Akpe wa me yah sor mu dei me mla sor indi gbugbu'u tei ni son ba rji kpi wu son ba. Mena yoh sor de me wa kpe gbugbu'u tumu na, me wah ni ko nha me tei naki ni ba fe ceto. ");
INSERT INTO jid_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Hu zamu, towa mi huza Yesu. ");
INSERT INTO jid_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Zizanyi, mi gbreyi san niwa bi 'taka mu ni ko ngyeri. Mi gbreyi sar nitu wa bi rji njii tre ba ngbangban me towa mi nna yi'a. ");
INSERT INTO jid_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Zizanyi me son ndu yi toh ndi Kristi mba hi tu' u lilon, u lilon hi tu' u' wa, u ndi Irji hi tu' Kristi. ");
INSERT INTO jid_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","U lilon wa a tie aduwa ka a to' tsu ni tu' ma i kika', a tsri tu' ma. ");
INSERT INTO jid_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Twa' waa a tie aduwa ka a to tsuni tu' msa ni wuo'a tsri tu'ma. Ahe towa a ndi na kron tu'maa. ");
INSERT INTO jid_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","U iwa ni ta'na ka' tu'ma na, ka' kron nfu tu'a, tie kpunkpu. Wa' ani taa kpye u shan ndu wa kron ngbolo ka ndu kron tu'ma wa' ka kaa' tu'ma. ");
INSERT INTO jid_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Lilon na ka' tuma na, ni wa ahi yu' nda hi kpan kristi U wa ahi kpan u lilon. ");
INSERT INTO jid_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Bana ti lilon rji ni wa' na. Ahi wa. mba ba tie rji ni lilon. ");
INSERT INTO jid_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","U bana tie lilon ni wa' ni. Ahi wa' mba ba tie wu ni lilon. ");
INSERT INTO jid_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ani tu kimayi a mla ndu wa' he ni ngban u ngbengblen ni tuma, don malaiku. ");
INSERT INTO jid_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","U nakime ni Baci, iwa na' son tuma nkon ni lilon na, towaa lilon na' son tuma nkan ni wa na. ");
INSERT INTO jid_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Towaa i'wa' ye rji ni lilon, na kima me lilon ye rji ni wa'. U kpi wawuu ba rji ni Rji. ");
INSERT INTO jid_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Ban ya kimbi: a bi ndu wa' tie a duwa ni Rji ni tuma wuo? ");
INSERT INTO jid_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Yaa u Ndji me na tsroyi ndi lilon nita he ni ngbondo nfutu ahi kpatsri niwu na? ");
INSERT INTO jid_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Yaa u ndji me na tsro yi ndi wa' nita he ni ngbondo nufutu, ahi kpan ni wu na. nfutu ma a' nno ka'. ");
INSERT INTO jid_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","U indjio' nita son sen nyu ni waa, kie na he ni ikpyeri nkan wa ba tie 'a na, ko ni ba coci u Rji mba. ");
INSERT INTO jid_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","U ni tre biyi ba, mina gbre yi san na. Niwa bita ye kii kabi, ana u mla tie ndindi na, ani u kpa hlo tie meme. ");
INSERT INTO jid_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Uni u mumla, mi wo ndi bita ye kabi ni mi coci, bi gatu' kpambi, wa ni nkon ri mi kpany'me. ");
INSERT INTO jid_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","E ahi gbigbi ndu gatu ndu he ni mi mbi, n'du ba' toh wa' ba nyme ni ba' ni mi mbi. ");
INSERT INTO jid_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","E bi taye ki kambi, an'a jibi Baci mba bi rli na. ");
INSERT INTO jid_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Bita rli, ko' nha ni rli uma guci ni mbru ba. U yon ka tie ri, uri ka wua. ");
INSERT INTO jid_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Bi na he ba koh wa bi rli ndi so'a na? Bi kpa coci Rji tsri ndi ni tie wa bana he kpye'a ya? Mi tre ngye ni yiwu? Mi gbre yi san? Mina gbre yi san ni tu wa na. ");
INSERT INTO jid_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","E mi kpa kpye wa mi nno yyi ngme rji ni Rji, wa Baci mu Yesu, nivi wa ba le' ni wu'a a ban bredi. ");
INSERT INTO jid_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Niwa a ngyri ni tuma, a mre wu nda tre din, “Iwa yi hi kpamu, waa ahi 'u mbi'a Tie wayi ndi ka taka mu” ");
INSERT INTO jid_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Tokima me a ban kofi a' nda tre, “kofi yi ahi shirji sisa u mi yii mu. Tie wa brubru ni nton wa bi so' a, ndi taka mu. d'bu iki wu Baci hi nivi u k'ma ye ma. ");
INSERT INTO jid_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","U inton wa bi tan bredi yi'a ndi so ni kofi yia biki. ");
INSERT INTO jid_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","U waa a tsatsa tan ka nda so ni kofi u Baci ni nkon wa ana bi'a na ani latre ni kpa u ni yii u Baci. ");
INSERT INTO jid_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Ndu ndji tsra kpama rli nda tan bredi'a nda so ni kofi'a. ");
INSERT INTO jid_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","I waa a tan nda so hama ni tsra kpama, tan nda so tron ni tu'ma. ");
INSERT INTO jid_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Ahe nitu kima bari mbi gbugbu wuu ba grji ngble nda ni lo, u bari mbi na ku kurna ");
INSERT INTO jid_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","U kita tsra kpambu, itron navu tana. ");
INSERT INTO jid_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","U anita Baci mba ni tron ni tawu, u kie tie ndindi, ni ndu kie ka tie meme ni ngbungblu'a na. ");
INSERT INTO jid_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Tokima, imyri vayimu, biti ye ki kambi ndi ni tan, bika gben kpambi. ");
INSERT INTO jid_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Iwa iyon ni tie wu'a, ka rli ni koh, to bina ye ki kambi ana ni u tron na uni tu kpyi bari wa bi nha mita ye mu yoyi ni nkon. ");
INSERT INTO jid_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ni tu tre nno u Brji Tsratra, mina son ndu yi hama ni toh na. ");
INSERT INTO jid_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Bi toh ndi niwa bina rli he ni bwu'a ba kayi rji hu ba' kpyi u brji meme waa bana tre na, ni bi nkon wa bana nji yi'a. ");
INSERT INTO jid_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Tokimayi mison ndu yi toh ndi indji waa a tre ni Brji u Rjia ani hla, “Yesu a' wa ba tie nyie niwu'a.” Indjio nita bre hla ndi, “Yesu hi baci”, se ni Brji Tsratsra ");
INSERT INTO jid_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Inno ba'he' ni nkan kan u Brji'a ri rii. ");
INSERT INTO jid_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Iyo' ba ba he ni nkankanyi, u' Baci a hi ririi, ");
INSERT INTO jid_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","U ba' nduu' ba' he ninkan kanyi u' Rjia' hi ririi wa ani tie ba wawuu. ");
INSERT INTO jid_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Ba nno ko nhaa ikpyi u Brji Tsratsra wa ani tie rju hrass waa ni tie bi ni ndji wawuu. ");
INSERT INTO jid_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Ni' ri' ba nno rji ni Brji Tsratra ilan u' he toh, niri ilan u he kpran rji ni Brji ririi me. ");
INSERT INTO jid_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","U ri kponja ni Brji kima, uU ni ri ahi nno u den rji ni Brji ririi kima. ");
INSERT INTO jid_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Ni' ri ba nno wu tir kpyi u wa ba nna' u ndji'a, u ni ri ahi totsu. Ni ri ba nno wu he toh bi' brji ba, ni ri ahi ba l'me, uni ri toh hla ba l'me. ");
INSERT INTO jid_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Biyi wawu mbawuu bahi ndu u Brji ririi kima, waa ani nno ndji blawo towa a son'a. ");
INSERT INTO jid_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Uwa ikpa hi ririyi nda he ni nghma kpa gbubu u wawumbawu na nghma kpa u kpa' ririi, a he tokima me ni kristi. ");
INSERT INTO jid_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Ani Brji ririi ba tie batisma ni wawumbuwu ni mi kpa ririi, ko ndji u Yahudiya ka ahi u Grik, ka ahi gran ka ahi ni tu' maa, u ba ndu ba so ni Brji ririi wawumbawu. ");
INSERT INTO jid_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","E ikpa' nahi nghma' ririi na, nghma kpa ba gbugbu wu. ");
INSERT INTO jid_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","U za nita hla din, “Mina hi wo na, mina nghma kpana, wa to kima na ndu zuwu ndu he nghina kpana. ");
INSERT INTO jid_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","U iton nita hla, “niw mina shishi naa, mina nghma kpana, hla tokima na zu he nghma kpana. ");
INSERT INTO jid_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","U ikpaa wawuu ndi na shishi, wa'ni ngye ba ndi wa wo? U ikpaa wawuu a ndi na ton, wa ni ngye ba ndi tawo whi? ");
INSERT INTO jid_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","To, u Rji a tie nghma kpa ba ni nba ndu mba blawo so sron ma. ");
INSERT INTO jid_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Ukpa a ndi na nghma kpa ririi, u imbru kpa a ndi he mameyi? ");
INSERT INTO jid_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","U, to mba, nghma kpa ba gbugbuwu, u kpa ahi ririi. ");
INSERT INTO jid_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Shishi na he ni nkon u hla no wo, “Mina tie kpye ri niwu na.” Utu na wani za, mina he kpye u tie niwu na. ");
INSERT INTO jid_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Ana he tokima na, niwa nghma kpa wa ba ban ndi ba kuyren, bakims yi ba ngbengblen kpaa, ");
INSERT INTO jid_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","U nghma kpa wa ba ku yren'a bi kimayi ba yaba ni nfu tu'. ");
INSERT INTO jid_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Nghma kpamau bi bia bana wa ba tie kpyeri ni bawu'a na. U Rji a tie kpaa kabi nda nno bi wa ba yaba kpatsria ndu ndindi zan. ");
INSERT INTO jid_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","A tie toyi ni ndu son nkankan na he ni mi kpaa na, amma ni ndu nghma kpa ba ndu ba toh tie ni kpamba ni bi son ririi. ");
INSERT INTO jid_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","U nghma kpari ni tasi tie ya, nghma kpa ba wawuu ba tie ya, u bata to tie na nghma kpari u mbru ba baka ngri ngame. ");
INSERT INTO jid_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Tomba, bihi kpa kristi ndi nghma kpama. ");
INSERT INTO jid_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","U Rji a cuni mi coci ni mumla, bi ton ndu ba, u ha, bi totsu, utra bi tsro, uni bi tie kpyi wa ba nna' u ndji'a, niwa ba he nno u den, ni bi zo, u biwa ba nji he kali uni bi l'me. ");
INSERT INTO jid_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Ahi wawumbawu bahi bi ton? Bahi bi Totsu wawuu? Bahi bi tsro wawumbawu? Batie ndu wa banna' u ndji wawumbawuu? ");
INSERT INTO jid_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Ahi wawumbawu ba he ni nno u den? A wawumbawuu batoh shle l'ma hla? ");
INSERT INTO jid_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Yo sron mla wa nno bi rligra ma. U ime mi tsro iwa nna ba bi kpa cu'a. ");
INSERT INTO jid_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Bani ter me hebe indi, ni wu malaiku wu me tana hei ni katu wur bi na me hei na kpekle wu hanto megye, na kuge wu amo megye. ");
INSERT INTO jid_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Wu mena hei ni kpayeme ni annabci ni fabimici ni kpi biwa ba reba bi jaji ni bi wa ba hei nito, wu me hei jiji ni kpayeme, wu meta ya ni tur rita. wu me tana hei ni kpayeme nindi ni sur mu na, me nakpe na. ");
INSERT INTO jid_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Wume tano ikpe wa me hei niwu wawu du ba no indi bi tei ya, ni ka kpamu du gonlu. We me tana hei ni katu bi na mena hei ni, me na hei ni riha na. (Meka Kpa mu nodu son wu wurwo sur). ");
INSERT INTO jid_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Wu kpaye me ni kpamu a son wu vu sur ni kirki. Wu kauna and hei ni lo shishi ni wurwo ni sur na. Kauna ana wu tsu tuna ko fitsara. ");
INSERT INTO jid_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Ana no tuma sontu na. Ana tifu gbagbla na, ana zi sur ma nikpe wu bla later me na. ");
INSERT INTO jid_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Ana gir ni rashin adalci na, wu naki ani gir ni gaskiya. ");
INSERT INTO jid_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Kauna ani ghi kpi bi jurewa ni kpi waeu'u ani to kpi wawu'u ani kpaye nikpi wawu'u ani lokpi wawu'u. ");
INSERT INTO jid_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Kauna na gle na, wu akwai anunbce anahce bana son na. Wu hebe ha hei bave ni kpamba. We bi bla ba hei ani wuce. ");
INSERT INTO jid_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Ito bu a hei kan-kan wu ki tei anabci nitu nitu. ");
INSERT INTO jid_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Wuton wa cikakke a ye wu kpe wana kle na a wuce. ");
INSERT INTO jid_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Ni wa mena hei ni vur me ta tere na vur, wu mere mu a hei na vur, me wu mere mu a hei na vur. Wuton wa me zar nandi me ka kpi wu vur lega. ");
INSERT INTO jid_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Wu ziza'a me ya geger na ma dubi wu ni zhi me ya shishi ziza'a me to nibur, wu me to wawu'u na me to wawu'u. ");
INSERT INTO jid_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Wu kpi tar bayi ba kle naki ban gaskiya, wu gabagadi wu ye ni kauna, du wawu'u wu kpe wa a zan ba wawu'u a kauna. ");
INSERT INTO jid_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Kiwu za kauna ni himmatu ni baye wa' son' ndi yo sron ni ba nno u brjia, baye ruhaniya wa kiya ni tindu wu tutu ma inno u totsu anabci. ");
INSERT INTO jid_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Du indi wa ani tere ni lebe ana u wa ani tre ni l'me 'a ana tre ni ndji na, indi a se tere ni wuna, ni irji wa ityo ani tre ni Rji. na fahimtarma na wa hei wa ani tere kpi wa ba kaba su ni Ruhu. ");
INSERT INTO jid_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Wu indi wu anabci ani tere ni indi du ba mla kpamba tei da karfa fa ni kpa mba da ta'azantar ni ba. wu wa ani tere ni lebe ri, ase tere ni tuma, damba tuma ba se tei. ");
INSERT INTO jid_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Wuwa dani yi anabci ani mla church se tei. ");
INSERT INTO jid_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Me ya anabi bina tere ni harsuna, wu kpe wa a ka hu naki me na yo sur bina yi anabci. Wa ani tei anabci a zan wa ani tere ni harsuna (sai dai indi wa ani fassara ni ikilisiya du sobi). ");
INSERT INTO jid_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Mini vayi, me ta ye niye nitere ni harsuna, wa gye a riba bi ni me anabina sai metere niyi ni wahayi wu koni anabci ko tsoro ");
INSERT INTO jid_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Ko kpi bro wa bana hei ni bi ni shishi na du nhababi megye, ni sarewar ni algaitar ba kadawa? ");
INSERT INTO jid_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Wu bata fyi gbunu ni sauti wa ana hei ni bima na wuni hei iri ni to iton wa dede niwa ani mla tei ni ku? ");
INSERT INTO jid_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Wahei toki ikon ririniyi. Bita furta tere wa ana hei nitun kona, wu ni hei iri ni wo kpe wobi tere? Bise ter wu ba wu wo ani wo kpe wa biki tere? ");
INSERT INTO jid_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Ajaji lebe ba hei kan akn ni gbugbu'u wu du ba hei ni azanaci ba. ");
INSERT INTO jid_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Metana to azanci wu lebe na, me hei na indi wu zir niwa ase tere wuwawu bu'u niwa a se tere ki he na bi zir wawubu'u. ");
INSERT INTO jid_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Wa hei naki niwu. wu wuyo sur na gbma wu bayyanuwar Ruhu bi ka himmatu ni habaka ni mla ikilisiya tei. ");
INSERT INTO jid_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Wuwa ani tere ni lebe, wa ka bre irji du no fasara. ");
INSERT INTO jid_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Wu meta bre ni lebe, Ruhu mu bre wusur wu fahimtata ani hi ni ko shishi na. ");
INSERT INTO jid_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Ziza'a me tei ni hei? me bre du Ruhu mu, ni bre ni fahimtata. Me yo sai ni Ruhu mu ni Fahimtata. ");
INSERT INTO jid_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Wu inda ana hei naki na, wuta yi yabon Irji ni ruhu megye wuni hei indi a hei ko rama ani ter, “Anaki” ni giri ni kpe wawuse tei wana to kpe wa wu se tere na? ");
INSERT INTO jid_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Ana hei ni shakka na, wu ka giri gbugbu'u wu ri ana mla tuma tei na. ");
INSERT INTO jid_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Me gir ni irji mese terre ni lebe gbugbu'u zanyi wawu'u. ");
INSERT INTO jid_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Du naki de ni bubu shubi ikilisiya ani bi mu du me tere ni kalmomiton ni mi fahimta wu ingonta bari biwa ba zan dubu wu lon wu lebe ");
INSERT INTO jid_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Mini vayi nakama son na mini bi ziza'a na ni mere bina. Wu naki se de ni sau wu meme ma, ba surwu mini bi ziza'a, wu ni mere bi girma. ");
INSERT INTO jid_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Ba nha ni tere sharia da tere me tere ni indi wa ba hei ni meme lebe ni be bunanyuh. Du naki kwa bana wo ba na Irji tere. ");
INSERT INTO jid_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Wu lebe al amu ba ana bi wa ba hei ni ban gaskiya na, wani hei ni bi wa bana hei ni bangaskiya. Wu anabci ba a alama ba ni biwa ba wa hei ni gaskiya, wu ana wu biwa bana hei bangaskiya. ");
INSERT INTO jid_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Wu a hei naki, wu ikilisiya ba yi shubi wu ko nha ani tere ni lebe bari, bari bahi biwu konri bawa bana bi bangaskiya wa ba ri anaki base ba tere bi sar ba? ");
INSERT INTO jid_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Wuko nha ana wu anabci, ni wa ana hei ni bangasikiya na, wu wa ani ni kora wu tere ani no nassara ni kpe wa a wo. ba gbi ton ma ni kpe wa ba bla. ");
INSERT INTO jid_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Wukpe wu re ni mi sur ani nu nira wu kpe ani wu gonma ani joku ni shshi da yisujada da nla niyu ma Irji jaji wawu hei ni ba wawu'u. ");
INSERT INTO jid_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Mini vayi wa agye naki? wu bi ta kuson ni shubi bi, wu indi a hei ni zabura wutsor wahayi, lebe ni fassara. Bi ka tei kpe wa ni wu mla ikilisiya tei. ");
INSERT INTO jid_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Wu indi wa ni tere ni lebe ri bi ka wa indi ha ko tra ni bar ba wawu'u, wubaka tere yiyir-yiyir, wu ri ka yi fassara kpe wa ba tere. ");
INSERT INTO jid_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Wu indi wa ana yi fassara ana hei na baba wawumba wu ba son ni kpe kpe yini mi iklisiya. Wuka nha ka tere ni tuma ni kama ni Irji. ");
INSERT INTO jid_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Wu du anabawa itra duba tere wu bur baka son nikpa kpe ni bam bance ni kpe baki tere. ");
INSERT INTO jid_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Wuba ta no indi fahimta wa a son ni mi sujadar, du wa ani tere wa ziza'a wa ka son ni gbagbi ");
INSERT INTO jid_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Wawumbi wu bi yate ananbci ni in diri wu in diri du ko wannen bika to ni koya ni fe karfafawa. ");
INSERT INTO jid_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Wu ruhohin anabawa ba hei ni karkashin annabawa. ");
INSERT INTO jid_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Wu Irji ana Irji wukur na, a wu son se sur. Wa hei naki ni du iklisitya yi bi banagasikiya. ");
INSERT INTO jid_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","U'mba duba son ni kpa kpi ni du church, Bana kpa yeme du ba tere ni church na. Wa hei naki baka yi biyaya nawa dauka a tere. ");
INSERT INTO jid_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Wubata hei nikpe wa ba son ba koya, u baka miyi ba lon ba niko. Ani kpe wu shan du wa du tere ni mi church. ");
INSERT INTO jid_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Wu tere Irji ani niwu? A niwu ba ni kakle me ba aye ri niwu? ");
INSERT INTO jid_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Indi wa ani ya tuma na wawu a annabi ko wu ruhuniya wakato kpe wa ba nha niyiwu wa umamu wa ani ni Irji. ");
INSERT INTO jid_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Wu indi wa kama dana kpa yeme ni wa hei na, wa wume bakana to ni wa ba mla gani na. ");
INSERT INTO jid_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Naki mini vayi bika yo tu ni tei anabci kpan kpa me, nina zuntyo ni tere ni lebe na. ");
INSERT INTO jid_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Wu bi ka du ko kpe du zire gyegye re nikpe wa ba tere. ");
INSERT INTO jid_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Zizan, mri vayi, mi son duyi to itre ndindi wa mi d'bu bla ni yiwu'a, wandi bi kpa ndi kri ni tuma'a. ");
INSERT INTO jid_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","A nitu tre kii wa a kpayi ni chuwo, nitu bita vu lantre wa mi bla tsro yi nji gbangban, hamma ndi kpanyime mbi na u megen na. ");
INSERT INTO jid_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Nitu rji ni mumla ma, kpe wa mi kpa a, mi vu sa yiwu ni wo, andi Kristi a kwuu nitu latre mbu, toh wa nhatre Bachi yo zi'a, ");
INSERT INTO jid_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ndi ba ban'u rju, i ni vi u tra ba nzu'u lu, tsra ni wa ba nha zi'a. ");
INSERT INTO jid_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Kristi a rju tsro tuma ni Kefas, mba ni wlon donha ba; ");
INSERT INTO jid_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","niki ala rju tsro tuma ni mri vayi wa bazan derli ton ni nkpu riri. Gbugbumba barhi he ni sisren, i bari ba kukru nna ye. ");
INSERT INTO jid_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Ala tsro tuma ni Yakubu, mba ni manzani ba wawumba. ");
INSERT INTO jid_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Ni klekle, a tsro tuma nimu, too vren wa ba ngrji ni ndru ma. ");
INSERT INTO jid_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Nitu mi nkle ni manzani ba. Mina mla wa ba yome manzo na, nitu mi tiya ni Ekklisiya Irji. ");
INSERT INTO jid_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Hu kpa ndindi u Irji, mi kma ti ndji wa mi he zizan, i kpa ndindi ni tumu'a, ana u megen na. Nitu kima, mi tindu iya zan wawumbawu. Ana ndi ana me mena, ama ti ndindi u Irji nitu mu. ");
INSERT INTO jid_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Nitu kii, anita hi me, ka baba, toki ki tsro yi nitu ma, nitu kii bi kpanyime niwu. ");
INSERT INTO jid_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Zizan, bata vu bla nitu Kristi ndi ba nzuu lu rji ni kwu, wa ahi ngye ni du bari mbi duba ni tre ndi tash'me rji ni kwuu na he na? ");
INSERT INTO jid_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Ama tash'me rji ni kwuu nitina he na, niki Kristi ngame bana nzuu lu na; ");
INSERT INTO jid_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","anita he ndi bana nzuu Kristi lu na, niki vu bla nituma mbu a ndu megen, mba yo sron kri gbangban mbi a ndu megen ngame. ");
INSERT INTO jid_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Kita ngame ki k'ma ti bi bla kpi bi ce nitu Irji, nitu ki vu bla ndi Irji a nzuu Kristi lu rji ni kwuu. Ama ana nzuu lu na, anita njanji ndi bana nzuu biwa ba kwuu luna. ");
INSERT INTO jid_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Bata nzu biwa ba kwuu luna, Kristi ngame bana nzuu luna; ");
INSERT INTO jid_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","i batana nzuu Kristi luna, kri gbangban mbi a hi u megen, nitu bi rhihe ni mi latre mbi. ");
INSERT INTO jid_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Nikima, biwa ba ku kruna ni mi Kristi ba kwuu kado ngame. ");
INSERT INTO jid_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Anita nitu vri u zizan yi bi yo sron ni Kristi, ki kma ti wa indji wawu ba yaba ni lo sron. ");
INSERT INTO jid_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Ama zizan ba nzuu Kristi lu rji ni kwuu na mri klo kunkro u mumla wu biwa basi kruna. ");
INSERT INTO jid_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Nitu wa ikwuu ari ye zuni wa ndji ri, zu ni wo ndji ri ngame tash'ma u wa ba kwuu a. ");
INSERT INTO jid_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Niwa rji ni Adamu, wawu ba kwuu, nikima ngame, ni Kristi wawu ndji ba kpa vri u sisren. ");
INSERT INTO jid_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Ama ko nha ni gru nkonma: Kristi, wa a hi mri klo kunkro u mumla, mba ndaka hu biwa babi Kristi, ba kma ba yeni sisren ni ye ma. ");
INSERT INTO jid_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Niki klekle ni he, niwa ani ka ngbranko Irji sa ni Irji titi ni wo, nikima ani ju bi son ni tuchu u gbengblen rju ni ruron mba. ");
INSERT INTO jid_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Nitu a tsra wa ani ti mulki ka mla wa ani yo bi wa ba yo ni shishi nda kamba niwu ni ntan zama. Ikwuu yi ni u klekle nimi bi kamba ");
INSERT INTO jid_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ni wu wa ani chonba hle. ");
INSERT INTO jid_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Nitu “a yo ikpi wawu ni ntanza ma.” Ama bata tre andi, “a yo ikpi wawu,” a kri ni rira ndi ana nha ni wawu wa a yo ikpi wawu ni woma na ");
INSERT INTO jid_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Bata vu ikpi wawu yo ni woma, niki Vren a kima ni kma tuma yo ni wo wa ana yo ikpi wawu ni woma, nitu du Irji ka hon son nitu wawu. ");
INSERT INTO jid_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ka bi wa ba kpa batisma ni biwa ba kwuu a ba ti nihe? Batana nzuu biwa ba kwuu lu na, anitu ngye ba kpa batisma nitu mba? ");
INSERT INTO jid_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","A hi ngye duta ni yo tu-mbu ni ya nton chachu. ");
INSERT INTO jid_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Mi kwuu ni vi chachu! I wayi a njanji toh gbrensan mu ni tu-mbi, wandi mi he ni wu ni Kristi Yesu Bachimbu. ");
INSERT INTO jid_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","A hi ngye riba mu, mita ban ya ni nkon indji, niwa mi tsi ni nmarju ni Afisus, hama nitu ndi ba nzuu bi kwuu lu na? “Ki lu hi rhi ni so nitu mble kika kwuu.” ");
INSERT INTO jid_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Du ba na gyuru yina, “Meme kpukpan zren ba kpa zren ngyengyere me ti meme.” ");
INSERT INTO jid_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Du shishi me kpan! Mla son tsatsra me! Don-me ni zren ni lahtre. Nitu bari nimi mbi bana toh Irji na. Mi tre du ishan vu yi. ");
INSERT INTO jid_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","I iri ni tre ndi, “Ba nzuu bi wa ba kwuu lu nihe, mba ni ikpa birime ba ye ni wu?” ");
INSERT INTO jid_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Wu u nkpran! Ikpe wa wu chu ana kma ye ni sisren na, hama ni a kwuu. ");
INSERT INTO jid_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Ikpe wa wu chu'a ana kpa wa ni he na, ama wulo bi megen. Ani alkama ko kperi nkan. ");
INSERT INTO jid_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Irji mba ni nu ikpa wa a too bi niwu, wulo bi nkankan ni kpa mba. ");
INSERT INTO jid_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Nma ba he ni nkankan mba wandi ana riri na, nikima, nma indji he, mba nma u ba nma rju, mba nma u ba nchinchen, mba bari u lambe. ");
INSERT INTO jid_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Gbungblu shulu mba bi meme ngame ba he ni ba kpamba nkankan. Ama kpan kri u gbungblu bi shulu a hi nkan i kpan kri u gbungblu meme hi bibiri nkan. ");
INSERT INTO jid_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Ikpan u Irji he, mba ikpan ri nkan u uwha, i ikpan u ntsintsen. Nikima ntsintsen iri hi nkan ni ntsinsten ri ni ikpan ma. ");
INSERT INTO jid_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Toki ngame ni lu tash'me u bi kwuu. Ikpe wa ba chuu ani glahle, i ikpe wa ba nzuu lu ana gla na. ");
INSERT INTO jid_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Ba chuu ni bwu, nda nzuu lu ni kpan. Ba chuu ni chonkpa, nda nzuu lu ni gbengblen kpa. ");
INSERT INTO jid_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Ba chuu ni kpa ndji, nda nzuu lu ni kpa Ibrji. U toh nma kpa he, nma kpa nimi brji ni he ngame. ");
INSERT INTO jid_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Nikima ngame ba nha, “Indji u mumla Adamu a kma ti ndji u sron vri.” Adamu u klekle a kma ti ibrji u nu sron vri. ");
INSERT INTO jid_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Ama u ibrji'a ana ye guchi na, u meme rli, i u ibrji aka hu. ");
INSERT INTO jid_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Indi u mumla a hi u meme, wa ba tiu ni hron meme. Indji u ha a rji ni shulu. ");
INSERT INTO jid_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Too wa wandi ba tiu ni hron meme he, tooki ngame biwa ba tiba ni hron meme, mba too indji wa a rji ni shulu he, tooki ngame biwa babi shulu. ");
INSERT INTO jid_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Too wa ki ban iwhi u indji u hron meme, ki ban iwhi u indji u shulu ngame. ");
INSERT INTO jid_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Zizan mi tre wayi, mri vayi, andi nma mba iyi bana kpa gado ni Iko son Irji na. Nikima ngame ikpe u gla na kpa gado ikpe wa ana gla na. ");
INSERT INTO jid_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Ya! Mi hla kpe u katu tsi: Kina ku kruna wawumbu na, ama wawumbu ba kmata sran. ");
INSERT INTO jid_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Ba kma ta sran ni nton rir, ni tsi ngban shishi, ni fu njon u klekle. Nitu fu njon'a, biwa ba kwuu a ba nzuu lu ni kpa wa ana gla na, i wawumbu ki kma sran. ");
INSERT INTO jid_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Nitu kima ikpa yi wa ani gla ani sru kpe wa ana gla na, i ikpa wa ani kwuu yi, ani sru kpa wa ana kwuu na. ");
INSERT INTO jid_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ni nton wa ikpa u gla yi a ban wa ana gla na sru, mba niwa ikpa u kwuu yi ban wa ana kwuu na sru, niki itre ni ye wa ba nha zi, “Ba mryen ikwuu ni rhiku.” ");
INSERT INTO jid_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“Ikwuu, wu rhiku me ni ntsen? Ikwuu ingwu nchi u ta me he ni ntsen?” ");
INSERT INTO jid_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ingyu nchi u ta u kwuu yi hi latre, i gbengblen latre a hi doka. ");
INSERT INTO jid_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Ama ki ngyiri ni Irji wa a nuta rhiku ni nkon wo Bachi mbu Yesu Kristi. ");
INSERT INTO jid_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Nituki, mri vayi u mla son mu, kri gbangban ni na du ikpe grju yi hle na. Ta kri ni tindu Bachi chachu, nitu bito ndi indu mbi ni Bachi na hi megen na. ");
INSERT INTO jid_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Wu ziza'a nitu tere wu sere kpe wu zo bi hwu tere Rji wa me tere ni Ikilisiyoyi ni Galatiya, Anaki bi ti. ");
INSERT INTO jid_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Ni ve wu mumla wu sati, du bi ka kpe zi, ni zi nibubu wubi ma wagbeble bi ni kai. Bita tei naki iton wa metaye ana wa bila tere bi shu kpi ni tei na. ");
INSERT INTO jid_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Wuton wa me taye, me tindu ni du ni bi wa bi kpa ye ni ba nha ni bawu ni duba gni sakon bi hi ni Urushilima. ");
INSERT INTO jid_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Wu anita bi wu meme me he game, wu baka wu me. ");
INSERT INTO jid_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Wu me taye niyi me zu ni mece donia. Du naki me zu ni mace donia. ");
INSERT INTO jid_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Ani tabi me son niyi, me wuton wu suyi ni duyi zo me nit zeryi ni du wuzhi wa me zu. ");
INSERT INTO jid_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Wu me na son me to yi ziza'a na me ka si hi mu. me yo sur mena hei niton mekuson niyi. Irji ni ta kpa yeme. ");
INSERT INTO jid_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Me sar ku kri ni afisus nive wu fentikos. ");
INSERT INTO jid_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Ikon bwu ni mu bar wubilo shishi nime ba bar (bi karme bar). ");
INSERT INTO jid_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Wu ton wa Timoti ni taye bi ka du ka kpa le niyi indu Rji ani tei na wo ime me me se tei. ");
INSERT INTO jid_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Du ri na kpa a zir na. Za ni konmu wu bima ni se sur, wa har ka ye ni me. Du me son du bi tzir baba mir vayi ba. ");
INSERT INTO jid_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Wuni tu vayi mbu Afolos, me yo sur mu du ziyarce ni yi ni bru miri vayi, wu ana yo sur wuye ziza'a rina. u ton ni ta yi ani ye ");
INSERT INTO jid_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Mla ya ni son gbangban ni bangaskiya ni son, ison wu lulo, ni tsar gbengle suron. ");
INSERT INTO jid_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Du kpe wa bi tei, bi katei ni kpayembi. ");
INSERT INTO jid_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Wuni tere wu in ndi biko site fan as, baba yi ba kuci kpa Rji ni akaya, wuba yo tumba ni yi hidima ni biwa ba kpa Rji. Ziza'a me bre yi miri ya. ");
INSERT INTO jid_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Bika yi biyayya ni iri ndi biyi ni du biwa ba zo nimi ndu wani fama nita. ");
INSERT INTO jid_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Me gir ni ye sitefan as, ni furtunatas ni Akai kas, Bazo me ka wu na hei na. ");
INSERT INTO jid_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Wu baka wartsaka ni ruhu mu ni wubi wa naki bika mla inoli biki tei. ");
INSERT INTO jid_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Du ikilisiyoyi bi Asia ba turici ba niyiwu. Aquila mba Pricilla ba ciyi ni de Rji, ni ikilisiya wa ha hei niwu ni miko mba. ");
INSERT INTO jid_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Du mini vayi ba ciyi ci kpambi sumba maitsarki. ");
INSERT INTO jid_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Ime Bulus, me han wayi ni womu. ");
INSERT INTO jid_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Du ndi wa ana kpaye meni Rji na ani hei ndi La'anane. Du Rji mbu ye. ");
INSERT INTO jid_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Du Alheri Baci Yesu du son ni yi. ");
INSERT INTO jid_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Du kpayem mu du son ni yi wawu ni minde Baci Yesu Amin ");
INSERT INTO jid_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Bulus Manzo Almasihu Yesu ni bubu into Rji ni whu Timoti vernyinbu yeh ni kho Rji wa ba ha ni korantos tutun mrevayi bi ba ha ni kpala memen akaya. ");
INSERT INTO jid_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Tin dindi ti ziffin ni yin ni soun sin ni Rji Bacin bu ni ton titin Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Kidi gbre san Bachibu Kristi du ne sungregre ni Rji titi Bacinbu Yesu Almasihu. Ekin sa titinu whu wawu Kristi, wawui hi itiu jiyejiye kai di wawu iji din wha'a toh suron wawi ni Rji u sisuron nita. ");
INSERT INTO jid_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Rji ni nota si suron ni mi don kita, kika iya no bari souron ni mi wha ba ha ni, klikliyah. ki ta noba si sur ni bari ni bibi si sur din Rji wha a nota si sur. ");
INSERT INTO jid_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Ni tun iyah kiti wa Kristi ba kati gbugbu'u ni tu bu naki si suron ka hi kagon ni mi Kristi. ");
INSERT INTO jid_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Naki inde ki yah ni noyi si sur bini kpachuwo bin kita noyin si suri ni tun tsirbin. kin noyin si surbin ni tindun brabra yanda bi vun sisur ni bibin e yah wha ki he nemin diniton. ");
INSERT INTO jid_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Yo surbu ni tunbi ani zonta nikine kita ki toh na bi son ni mi naki me bin zren nita. ");
INSERT INTO jid_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Mri vayi kina son don yi hontoh ti yah wa ki ni Asiya. Bachanta zangbengblenbu, har di chu suron bu din kina gbujub na. ");
INSERT INTO jid_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Nakima ki wotre u kwu. aman ikpie atin duta na you nitu bu na, sei ni Rji wa ani bi ba ba kwu. wha a zun iji luden ne mein bei. ");
INSERT INTO jid_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Wha wuyi kpata cuwo ni memen en eghun kyu ani kpata cuwo kin yo surbu nituma ani kpata cuwo. ");
INSERT INTO jid_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","A ni tin whayi kita zonkpa bu ni braibu. ne whayi mire vayi ba ye brabranda giri don kita ne tun tagomashi didin wha ba tin ta'u ni bu bu bra Rji iji babra. ");
INSERT INTO jid_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Kin ghagbe na yin ni tingbe enmrebu ni tin dindinmre ni tinbi wha ne ye ne Rji kin zera ni sunbu ne gblugbu kin tin wha yi tuntuma ni bin yin sa ta bubu bimbi Rji. ");
INSERT INTO jid_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Kina ahan kpen ni yiu wha bina ya blamana ni ton na in somu dunyi to gregreme. ");
INSERT INTO jid_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Tun wha bin tonta fime ziza bin ghagbe nita ne ivin wu tibun Yesu, tutur wha kin ghaban ni yin. ");
INSERT INTO jid_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Don igabagadi wha me hei'u ni tunbi nahi ye neyin wu rini, donji ni tsonta kine zerakpabu khuha. ");
INSERT INTO jid_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Meha ni tannire ye ni yin ni ghomu hin ne makidoniya. tun ni bubuyin me remre toyin ni zera hi Makidoniya, bin tome ni konmu hi ni Yahudiya. ");
INSERT INTO jid_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Thun wha me tsi remre yi, in surmu na nena? me mlabubu bin yin zitin niton magwaji din ni thon a ne la i ne A a a a ne ton ririn. ");
INSERT INTO jid_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Thun wha Rji a ha ba la tra ki na ya lah ne i kon A' a ni ton irin ");
INSERT INTO jid_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Thun da Evivre Rji Yesu Almasihu wha Silbanus mba Silas ne me ki Shaida yi'u ba 'i' di “A' a ba pha kitreanahi Nhnaki “I' a hei khon wha ne ton. ");
INSERT INTO jid_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Uh yo uyo uh Rji whawhu ah 'E' ni'a'a ni uhn ne ta kon ma ki tre gbuchu ni gbre san Rji ");
INSERT INTO jid_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Zizan a Rji kpa mym nita ni biyin ne me Almasihu nanta (kebe) ");
INSERT INTO jid_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","A yo gban ma ni tunbu da nota Ruhu ne me surbu ne matsayin da tsrota kpe a ne tin nitau ni kogun. ");
INSERT INTO jid_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","A hei na kin a yonta ni Rji wha a krin ni'u ni kpen ririn me na yen ni korinti me ni kpa yin chuwo. ");
INSERT INTO jid_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Kina sun ki hei na Rji tun bi na ko nitun kpa myemebi. nita bubu yin ki whu bi tindun ni yin ni grin bi, na da bin krin ");
INSERT INTO jid_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","me ba emrenmu mena ye yin ne kpalabana mena yaye ne yin na ne to yah bi heime. ");
INSERT INTO jid_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Me ta kpa surbi tin meme nhan ne si yinsurmu in ba whame kpa surma ti me ba? ");
INSERT INTO jid_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Me nha ni yi'u yadenme tin mita ye niyin mena to kpa sur ti meme nibi ba mle tu ba noyin si sur mehei nigabagidi ni yin grin me hei un aki bi hei un aki be ahane'u whawu. ");
INSERT INTO jid_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Me nha ne yi'u ne me yahni kpasur timeme, ne yin ma shishi ubran me na so dun sur bi temenena. in naki zurfi son me hei ni yi'un ");
INSERT INTO jid_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Idin wha kbrin kpa sur ti meme ana me ghrinmu na ba nayi na har niyin wha'u. ");
INSERT INTO jid_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Tin yah wha galabinku biti ni din a mlan ne ba. ");
INSERT INTO jid_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","A hei naki ziza maimako yah ki kpa lahgani un bi ka ta'a zita un tin naki dun bakinciki bi dun brana. ");
INSERT INTO jid_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Ahei naki, ki nayi emre kpa lahga ni'u ni zra bi bin son bin he ni'u ni zra bi bin son bin he ni'u ahei ne ra. ");
INSERT INTO jid_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Ekpen wha asa me nha fufun, meni tsra yin to ko bi who tre ni kpenkitin. ");
INSERT INTO jid_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Din bi kpa wu ri lah ni'un me kpan wu rilah ni'un kpen me kpa wuri lah, meta kpa kperin wurileh don biyin ni shishi Almasihu. ");
INSERT INTO jid_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","A ha nakin kina dun memen shaidan gurta na don kina kato bibin chema. ");
INSERT INTO jid_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Me samu kutra wha abwu bra ni Bacibu den me rin me gbu Tarwasa, ni bla tra Rji naki. ");
INSERT INTO jid_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Dun ton yin, surmu na kha kruna mena to mre vayimu na Titus na muna, me brin ba nimu ni khme ye makidoniya. ");
INSERT INTO jid_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Me gren ni Rji, ni min Almasihu wha kai ga nasara ko wha ni ton ne who bu a sra whiwhi riro whu didima whu to ko ni tsen. ");
INSERT INTO jid_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Kin ta ki whowhi riromani Almasihu ni Rji ni tsutsu bi ivren ni bin bakpa kobin ba kaba sur tun ");
INSERT INTO jid_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Di bin ba kaba surtun whowhi netsutsun kyu hei ne kyu, ne bi ba kpaciwo ne whowhi ba heini vren hin nevren, a nha cancin ni bubu ba? ");
INSERT INTO jid_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Kina hei brun di ba leh ne tren Rji na kpa riba. aheinaki ne tsrakakiya mren ki tretre yin ne Almasihu yah de Rji tunta ki gre ne Rji. ");
INSERT INTO jid_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Ki soma yabo tutubu? kinasun nha funfun tingba niyio ko ye niyina, idin barin ana naki na? ");
INSERT INTO jid_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Bi yin tunbi bin funfun whu nha ta gbabi wha ba nhan ne me surnbu, wha idi ba ton whawhu da blan. ");
INSERT INTO jid_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Kin tsro tunbu ki hei funfu nha wha a nha Almasihu, wha kin isor. Ana bibin ki nha na amma a Ruhu Rji whu vre ne tun alluna tinta ba nha ba, amma nitun alluna sur di ");
INSERT INTO jid_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Un wha yi hei ni gabagadi wha ki hei niv nime Rji nita kho Almasihu. ");
INSERT INTO jid_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Kina nha ni gulanita tunbu wha ki yin takamar ni kpe wha nha nitaba nha naki gwanita ba hei ni wo Rji. ");
INSERT INTO jid_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Rji bata bi to tigran a yo yu, in yo yu ni whua a hei n whu ruhu in nha ni whu ruhu uvre a neta. ");
INSERT INTO jid_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Hidima wha haifar ni kyu a he nha nitun tita wha a ye ne irin daukaka emre tsraila ba na ya to shishi Musa na ni wha yi don daukaka wha a hei ne shishi ma whu sutu. ");
INSERT INTO jid_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Na misalin girma daukaka hidimar ruhu niti? ");
INSERT INTO jid_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Yah da hidimar kayarwa ani daukaka, misalin yalwata daukaka ni hidimar didi aniti. ");
INSERT INTO jid_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Na tamre in kpe ba ta un eki ba daukaka un ana hei ni brun daukaka a wanna fanni don bibin daukaka ta zarchi whu. ");
INSERT INTO jid_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Wha ba ka sutun a hei ni daukaka misali daukaka un kpe a hei dindindi ki kpa. ");
INSERT INTO jid_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Dashike ki hei ni tonba, kin hei ni gabagadi zizin. ");
INSERT INTO jid_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Kina hei na Musa na wha ki yo Ephilima nikha shi shima, na Emre Israila ba na ya yah clen daukaka whu sutun nitsande. ");
INSERT INTO jid_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","To tamreba a hei na khaka ye luwa Ephlina hei sa'anda ki blan nha whu tsoho yoyu. Bana buwna a hei ne me Almasihu kaida ba kawar ni un. ");
INSERT INTO jid_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Har luwa ko to rime ba blan Littafin Musa akwai Ephlin. ");
INSERT INTO jid_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Ama u nji kpa Almasihu ba kawu cuwo. ");
INSERT INTO jid_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Ton Bachi a ruhu. bubu ruhu bacibu hei akwai yanci. ");
INSERT INTO jid_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Kita ziza ni shishi wha na hei ni Emphlina ki ton daukaka Baci. ki to kbasar ye neme wanna daukaka, daga bubu baza wu daukaka ye bubu baza na a hei tibu, wha whu yin a ruhu ");
INSERT INTO jid_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","To nayin, kiti hidima wa bi kpa nita ikon jinka, kina bir yo surna. ");
INSERT INTO jid_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Maimako naki kpabu ni nko wha a hei ni shan whu kurin kina ti rayuwa makarci ki na tin tra Rji ni mure. ki tin dindi, ni nun tunbu ni sur ko ahei ni shishi Rji. ");
INSERT INTO jid_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Wu hla tra Rjibu anh kaika, anh nika ne bin ba kasurtun. ");
INSERT INTO jid_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Ni min surna iji wu gbugblu a mhrin fwen surba bi wa ba ha ma niti dindi. idima ba na ya ton kpeni tre Rji na bresa Almasihu nah wawu yi a surar Rji. ");
INSERT INTO jid_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Ta naki, ki ban tumbu hi ni kahlan aman Almasihu Yesu a matsayin Baci, ki granba nitun Yesu. ");
INSERT INTO jid_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Ga Rji wha a tre “Ikpan wa ni kpa wawu ni me bulu ani kpa ne min surbu da no kpa niton gbrenRji san. ne shishi Yesu Almasihu. ");
INSERT INTO jid_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Ki ha ni won ni min gbula, wa a ni hei a bayane wa afimeni meba ni tin Rji ba wu bunba. ");
INSERT INTO jid_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Anh ni shayah ni ko ta ingon reni, bana rinta na rebemi na ki karbi shishi, tun naki kinana chun ni sur buna ba nota yah aman a na sorta lebga na. ");
INSERT INTO jid_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Ba' nota yah, ama ba na ti meme na. ");
INSERT INTO jid_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Kita cacu ki ba kyu yesu ni kpanbu don di tsrota bayani rayuwa Yesu ni kpanbu. ");
INSERT INTO jid_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Bi bi yah ba hei sesar (ko ivren) cha chun ba mika ta ga kyu ni tun Yesu ni tren Yesu ahei ne kpa, bu wu kyu. ");
INSERT INTO jid_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","To wa yi sa ki kyu ni tin dun nikpanbu, naki ivre ni tindun ni kpanbu. ");
INSERT INTO jid_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Ki hei ni ruhu wu tin dindi na dan ba nhai min khanye ni wu ni furta 'kinto kin kbanye kin nzi lah naki. ");
INSERT INTO jid_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Kiton ndi wa zun Yesu titin ni men bu ani zun ta ni Yesu ken tan ana gabatar ni ta na ni biyin ni ko shishi. ");
INSERT INTO jid_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Kpen ati don bi yin ya dan ba baza alheri ni adi bi ba bran gren ni kara bran ni gbren Rji san. ");
INSERT INTO jid_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Kena fin ni surba na ko nita kina timeme na ki ta sarkpanbu chuchu. ");
INSERT INTO jid_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Wu to vin yah mu ni vin ma ani mlatati hi ga nanyi madawami gbren wa a wuce tsra ya. ");
INSERT INTO jid_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Kena yan kpe wa ki to ba ni kpe wa kina to bana ni kpen wa kin ya ton ba ni kpe ki ya to ba na dawamba kpe wa ki na ya to na dawamimi ne. ");
INSERT INTO jid_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Ken he ni iko waki sun ne me a zee ba kon riwa ba me ni woRji. A kon wa ba wo ndi ne bubu meikon wu komi ikon nishun. ");
INSERT INTO jid_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Ki he men kpawa ki grunoni ki gben suturta ni ta ni bubu sunbu ni shulu. ");
INSERT INTO jid_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Ki gben ni wa yinko bubu yin surkpi ni wu kina san ni gbrena. ");
INSERT INTO jid_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Ki na he ndi wa ki he ni me alfirwa; kiti gurnani a nota yah kena sun sina ahenaki kinsun dun ba suturta nita wu ne envre ni ki ne menlu kpe wa a kyu. ");
INSERT INTO jid_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Ndi wa ni sun mlan bubu yin ti wu gregre ma a Rji wa a nota Ruhun ni iko yo yu ni kpe neye. ");
INSERT INTO jid_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Iwa he naki he negabagidi ko nitan. Ken mlaya wa kin shagala ni me kpa ki sun gbro ni Baci. ");
INSERT INTO jid_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Ni tun kba yebu ki jir, a na to wu wal sh na. ");
INSERT INTO jid_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Ken he ni gabagadi ki brin kpa bu ni ku sun ni Baci. ");
INSERT INTO jid_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Ki ban ni burinbu, kon ki he ne minkpa ko gbro ne gamsh un. ");
INSERT INTO jid_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Tilas wawumbu ki halara ni koshishi kursiyin blatre Almasihu ko di an kpa dima ikpe wa wu tin ni mekpa dindima kha memema. ");
INSERT INTO jid_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","To ki a an ki klun sisir Baci di ne gurndi Rji ti tonta wa ki anh ne ra, me to naki a anh ine khalan ne Almasihu. ");
INSERT INTO jid_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Kina sun kigur yina ni dun yi tonta ni matsayi ndi biti dindina, maimako nayi ki noyin dalili gagba nita, du yi to amsar wa bi ni bi ba gbreson ni ye ba ana kpewa anh me sorbana. ");
INSERT INTO jid_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Kiti nahi ni mesurbu dunRji, in anaki ki anh nimesurbi. ");
INSERT INTO jid_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Sun wa Almasihu Elias an bu ki tabatar ni wu ndi rikyu ni tuni hu mi wa he naki ba kyu. ");
INSERT INTO jid_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Almasihu kyu nitu ka nhanidi wa ni vren ba ra yu ta tun ba, maimako na hin ki yin raguwa dan wawu. wa akyu da lunde. ");
INSERT INTO jid_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Ni bubu dalili, zizan khina khara blan lahtre ko, an bis bubu tsara (ko ma'um) ni yanadm, tun nahi ki ya kongun ni to Almasihu naki zizan ki brin sharanta ne haka. ");
INSERT INTO jid_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Dun ndi wa an me me Almasihu batitine. cinche al'amura ba shude den kati nsa. ");
INSERT INTO jid_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Ton kpe bin yin ba he ni Rji a shunta tin ni tun ma, nita wurin Almasihu a no ta hidima shutu. ");
INSERT INTO jid_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Ne me Almasihu, Rji shuta tin ne gbugble ye ni wu, a na ya blan la tre (zunubinsu) ni tun ba a nota tre shutu. ");
INSERT INTO jid_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Ba chunta ni matsayi bi lah tre Almasihu, Rji ni yo ta ni adi nita wobu ki, bra yin don Almasihu ki shukpa bu ti niwo Rji. ");
INSERT INTO jid_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Wa wu yin mi ni Almasihu a ka yima lehgadon ku sho ku bu. A an ti lantre nan. Atinayi niki sun bin ti dindi wa wu na ti latre na atin na yin ki ne sun ne adalci Rji ni me ma. ");
INSERT INTO jid_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Tun ki tidun yayi me bra yi na kpa hle ne dun Rji naRji. ");
INSERT INTO jid_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","A tre ni ton wu dun Rji kiwo yin a i fin kpata chuwo. Ziza yin a ton wuadun Rji ye ziza a fin kpata chuwo. ");
INSERT INTO jid_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Ki na yo grun wu ku sho kubina ni shishi bru bina ki na so dun Hidima bu ni nha dun megina. ");
INSERT INTO jid_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Sar he nayi kito tumbu naki ni bubu dunbu na ki gran Rji ki granma ni ta bubu vunson sar ije, tiwundi, iya. ");
INSERT INTO jid_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Zin, kotron, inku, nime dun wuyah ne me kruna ni chun ne mrevanyi. ");
INSERT INTO jid_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Ne me ba kiti kpe vusor, ti dindi ne min, Ruhu glansar isowu dindisur. ");
INSERT INTO jid_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","Ki grama ni mehlan dindi ni wo kori ne wo komre. ");
INSERT INTO jid_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Ki tin dun ne daraja ni meme daraja ni gbrasa ba mreta di ki gurba ko na yi ki bin lah dindi ma. ");
INSERT INTO jid_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Ki tin dun ni ba na to ta na, Ba ton ta gregreme ki tin dun na kin kyu ki he ni vren bu kin tin dun na bin na no ba yah a na yah wu wun ndi na. ");
INSERT INTO jid_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Ke tin dun na bin ba no ba ki tinfun, ko ne ta ki ti dun ne gresan. ki tin dun na bin bana he ne kpena ki azurta ndin ba bra. ki tin dun na kina he ni kpena, naki ken vun ko ge ni ghrin ");
INSERT INTO jid_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Ki lah dindi ma ni jiwu conrontiyawa mesor bu heni bwu. ");
INSERT INTO jid_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Kina kange serbina bi yi biti kange ni kpa bi. ");
INSERT INTO jid_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Ziza sanading me tren ni yin na mhyre bi bwu na surbi. ");
INSERT INTO jid_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Na chundun ni bin ba na tin bina. Aageh he ni tsutsu adalci ne Sharia? a ge he ni tsutsu kpa ni bwu? ");
INSERT INTO jid_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Wace yarjejeniya he ni tsutsu Almasihu ni ibrji? inge he ni tsustu bi tin ndindi ni bi tin dindina? ");
INSERT INTO jid_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","A shutu ge he nitsutsu kho Rji di kho kachein? (Ibrji)? kin ta ki kho Rji wa ni vren in Rji tre wa wu ri me bin na tzre nitsu tsu bi ani sun ni Rji ba, ba he ndima ");
INSERT INTO jid_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","A nahi bin rhun ni me ba, ni sun kebabbu inji Baci ni yowo kpen unmemema ne kpa yi. A he tinbi ni yin bin he mre lilun ni wha ni me. Titi Baci he iko. ");
INSERT INTO jid_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Bi sonta an na hi yoyu kini glatu bu wawu ni kpe wa ba kpa tsatsra ni me sisir Rji ");
INSERT INTO jid_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Nu ta ngon kina kpa sorbi ti meme na kina mytre ndoun ko ki myre yina. ");
INSERT INTO jid_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Ana wa me kpeyi ti meme na. me tren me riga lah ni yi wu hi he ne mesorbu ni kin, kyu yayi ni sun ni yin. ");
INSERT INTO jid_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Me he dindi ne gabagadi ne me bi me gbre yi san ne yoyi sor grenmu shun makil ne yah bu. ");
INSERT INTO jid_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Wa ki ye ne Makidoniya kpanbu na sun nsi na. naki rin ni matso loli ni kho wani ingon ni bubu kpan sur timeme ni zi ni sisir neme. ");
INSERT INTO jid_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Rji wa a ta'ata ne raunana a ta'azata nita ne taye Titus. ");
INSERT INTO jid_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","A na ye bakadai Rji yin cintaba ni ta bubu cin Titus me to ni yin a llah ta wu bin matsanaciya sunbi, kpa sor bu timeme (ko fun) ni zurfi mleyi ya kana. megren kpokpome. ");
INSERT INTO jid_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","An mu nita kpa surbi timeme, me lah mini to nakina da meto nha kpa sur bi timeme mi yin me ni to infu bi a wu ton finme in. ");
INSERT INTO jid_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ziza me he nigrin, ana dun fun bi na, in funbi ghreye dun yikpa Rji, fuskaci funbi ne bra Baci, to na yin bi na hama wu don me ba. ");
INSERT INTO jid_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Nfunbi wa a he Rji a khri yi hi tuba da kammala vren ba tse wu to ba nfun wu gbuglu grin yi ye ni kyu. ");
INSERT INTO jid_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ya dindi emre a he ne me nfun bi ni wo Rji a ghrini minebi ina misali son tu bi ba, a tsro yi ne bana kho ukun (laifi) ina misali son tun funbu, sisirbi ni ye sorbi himmar bi ni mar maribi ni ya niti adalci ne ko ge ni tsron tu bi bi na bi laifiba, nime al'amariba. ");
INSERT INTO jid_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Ko ahe me anh ni yi wu, ba anh niton bi laifiba ko wa ba te laifi me anh nito yo tunbi ni ta nito yi ni khushishi Rji. ");
INSERT INTO jid_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Dalili wa yi ki kpa ngurin (karfafa) baya kogun cin yin ki grendinding me sabo da ni grin Titus, ni ruhunsa a fei gbengbelen ni yi wawu'bi. ");
INSERT INTO jid_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Me ta gbresan ni yin nish'ma mena klu sha na ni bubu. koge me lah ni wu ni tu naki din ikpie ba wawu wa mihla. a jaji gresan bi ni tun Titus a tsorota jaji ");
INSERT INTO jid_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","In sunbi a he bran wa ani taka, wa wu trebe wa bi kpa a ni sisir kpa. ");
INSERT INTO jid_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Me gren mataukarkpo kpomu ne cikake gabagadi ni me bi ");
INSERT INTO jid_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Mini vayi ki sun duye to ndi alherin Rji wa bano ni Ikilisiyoyin ni Makidoniya. ");
INSERT INTO jid_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Ni ton kekle ya wa bi to ni se suron ni ya wabato, anoba gbugbu'u gri wa ba noni suron riri ");
INSERT INTO jid_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","U mi lha niyiwu bano bayasuwa mbo ni yo sur mba zan kpe wa ba hei ni wu. ni kpayeme ni sur mba. ");
INSERT INTO jid_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","U ni bre ta ni sur riri duba no ba ton waba ka mba ibi du ba yi tayarwa ini hidima ga bi hu Rji. ");
INSERT INTO jid_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","U wayi ana hei na waki yosuron u baguci no tumba ni Rji riko u nita ni kpayeme ni Rji ");
INSERT INTO jid_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","U ki bre Titus wa riga hei ni mi ndu yi ka kle ndu'a niyi. ");
INSERT INTO jid_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","U bi riga kri nimikpi wu ban gaskiya ndi tere, nito, ni mindu tukuru, nimi kpayeme ni ta. Ahei naki, bitabata ni habaka nimi duyi wu no (bayasuwa) ");
INSERT INTO jid_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Me tere naki ana hei neme tere niyiwu ni gbegblen na wa naki, me tere nime tsar sahihancin kpayeme ni kwantata ni himmar ibru ndi. ");
INSERT INTO jid_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","U bi to alheri Ubangijinku Yesu Almasihu, u naki me ahei ni arziki nda k'mati wu ya ni tumbi domin hi tu taulauci ma biyi bi ka k'ma ti bi arziki. ");
INSERT INTO jid_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Nitu alamariyi me noyi mer waanizoyi. Nisai wa kle binati kps megye na, ama bi yo surbi ni tei U. ");
INSERT INTO jid_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Bi kle u zizan'a. Na wa bina hei ni suron ni kwazo u ti naki niton ki, bikayo suron ndi tiye nikle ma dede ni gbegblen mbi. ");
INSERT INTO jid_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","U bi tayo suron ndi bi tie ndu yi wakpe wugir ni kpayeme ni ubi ani hei daidai kpe wa ndi ahei ni wu, ana kpe wa a hama ni wu'a na. ");
INSERT INTO jid_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Wayi ana wani kpe wa ba nawata ni yiu du bari fe sauki mana. U ani ta hei toki, wani bi duba fe daidai- tuwa. ");
INSERT INTO jid_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Ison bi gbugbu'u zizo'a ani noyi kpe wabason. Wa naki ni bar mba, ani yada na kpe wa bi son, wa ani zama kpe u biya bukata mba. ");
INSERT INTO jid_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Ahei na wa ba nha. “Eri wa hei ni kpewu bra na hei nikpe wa ani don burna, u wa ahei niwu fime ana wa hama na ");
INSERT INTO jid_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","U gyir ga Rji wa ayoni suron Titus imre u kula ni yi kama yadda mi hei wa ni tumbi. ");
INSERT INTO jid_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Ana bre mbu kadai akpana U ati ni kpeyeme suron ma naki. Aye ni yi ni kpayeme makima. ");
INSERT INTO jid_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","U ki ton wawu vayimbu wa ki kpayeme niwu ni du Ikilisiyoyi du ma ni bla tre Baci. ");
INSERT INTO jid_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Ana wayi nika kle na amma Ikilisiyoyi ba cu u du nu ta hi hidima u didin ma u alheri wayi domin gbrai Rji san ni niya mbu ");
INSERT INTO jid_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","U ki klu kina duba na to ta hla trena game ni alheri wa ki zre ni bla ni ndina. ");
INSERT INTO jid_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","A he ni suron mbu du tati kpe u bima ba ni shishi Rji ni kakle ba ni shishi indi me. ");
INSERT INTO jid_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Kiton vayimbu ri tare ni ba ki tsar u to nikon gbugbu'u, ki to wa hei ni himma ni indu. Wa a ba yondu gbugbuu wa ba yo du ti. Zizan me a kara ni himma sabo ni amincewa wa ahe niu game ni yi. ");
INSERT INTO jid_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Ni wawu Titus a kpan wu zre mu ni kpan wadunmu don biyi. Umir vayi mbu, ba ton ba yir ni Ikilisiyoyi babi hei ni daraja ga Almasihu. ");
INSERT INTO jid_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Naki bika kpayeme ni ba ni tsor ikilisiyoyi ba kpe u se suron tawu game ni yi. ");
INSERT INTO jid_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Game ni hidimar bi tsartsra a bin na anh ne bawu. ");
INSERT INTO jid_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Me to marmari bi wa me gbresan ni wu ni shishi ndi bi Makidonyah. Me lah ne bawu Akaya ba riga na mlan son tu senmu nhoyu bi sanbruandi ba ri dun ");
INSERT INTO jid_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Me to ba ni yi emre vayi na dun grea ni yin ka he wu lheya ma, ni yi son ne whre, na wa metre duniya ti. ");
INSERT INTO jid_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Idan ana nayina rin nime bi Makidoniyawa ba whume da na ye bi nahe shutina ki jin shan me na ha nikpe metra ni tu bina me khrin gabagadi ni tu bi. ");
INSERT INTO jid_vpl VALUES ("C29_5","077_9_5","2C