﻿USE sofia;
DROP TABLE IF EXISTS sofia.jicNT_vpl;
CREATE TABLE jicNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jicNT_vpl WRITE;
INSERT INTO jicNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dios jas tjejyama Jesucristo nosis nt'a jis capj la p'acj judiopan. Papel niná nin vele püna tapatja jis lá, Jesucristo ne yupj sin popa p'iyá, püs naya tüpü'ü jupj. David popa watsja jupj. Abraham popa watsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac popay waytsja. Isaac Jacob popay waytsja. Jacob Judá popay waytsja, Judá jüpülücpan jis popay watsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Fares popay waytsja, Zara popay watsja jupj. Tamar yupj sejamay waytsja. Fares Esrom popay waytsja. Esrom Aram popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab popay waytsja. Aminadab Naasón popay waytsja. Naasón Salmón popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz popay waytsja. Booz jamay Rahab lotsja. Booz Obed popay waytsja. Obed jamay Rut lotsja. Obed Isaí popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí David popay waytsja. David jépatsja jupj Israel mo'ó püná. David Salomón popay waytsja. Salomón jamay Urías jats'om waytsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboam popay waytsja. Roboam Abías popay waytsja. Abías Asa popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat popay waytsja. Josafat Joram popay waytsja. Joram Uzías popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam popay waytsja. Jotam Acaz popay waytsja. Acaz Ezequías popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés popay waytsja. Manasés Amón popay waytsja. Amón Josías popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconías popay waytsja, Jeconías jüpülücpan jis papay watsja jupj. Josías tüpü'ü na, Babilonia mo'o tapatja tjiquil, la tapalan yupj israelpan jis lal. Jis tsupapj, tjaman Babilonia nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonia nt'a tsupapj tjil na, p'a wa sin popa jis tepyala. Jeconías Salatiel popay waytsja. Salatiel Zorobabel popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiud popay waytsja. Abiud Eliaquim popay waytsja. Eliaquim Azor popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadoc popay waytsja. Sadoc Aquim popay waytsja. Aquim Eliud popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar popay waytsja. Eleazar Matán popay waytsja. Matán Jacob popay waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José popay waytsja. José niná María voyum waytsja. María Jesús jamaytsja. Jesús, Cristo ló wa jupj; Dios tjevele ca jas majamas jupj, gente jis capj la p'acj, mpes nin ló jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nin jis latsja püna tapatja, Jesucristo ne yupj sin popa p'iyá, püs naya tüpü'ü jupj. Pjü way jis lá sin pac na Abraham ló mpe David ló nt'a, catorce way yupj. Nin p'iyá, pjü way jis lá sin pac na David ló mpe israelpan Babilonia nt'a tsupapj tjil nas, catorce way yupj 'ots'ipj. Nin p'iyá, pjü way jis lá sin pac na yupj tjil na mpe Jesucristo ló nt'a, catorce wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo niná Yomen Dios jas tjejyamá qjuis capj la p'acj. Papel niná nin vele 'oyn nyuca tjemya'na Jesucristo nosis nt'a. Jamay María lotsja. Tsjücjüim na tjevéletsja José lal ca jupj lal mwayim. Custjay ma tjowaya p'in, way tsjicj já'asatsja jupj Dios Cjües mpes. P'a nequem jin tulucj tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José ma jus nléyatsja tsjan mpes María way tepyala. Malala la tjiji jupj, jólatsja José. Mpes quelel véletsja María lal ma mwayim jupj lal. Jupj lal p'in quelel véletsja. Ma quelel véletsja la p'a jis lal María malala la tjiji. José 'üsüstsja Dios lal, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nasa quelel véletsja na niná María lal, Dios ángel pjaní lay tepyala José nt'a. José tjejyá na tjinyuca jupj. Ángel tjevele José lal: “José, David püna tüpü'ü popa p'iyá jipj. Po ma lecj meyan mwayim María lal. Dios Cjües mpes p'in way tsjicj tepyala jupj. Ma malala la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yom tsjicj ca ma'nus jupj, María, ne jipj ca ló nt'an, Jesús ló nsem. Jesús mpes ca Dios perdonar lis mijis israelpan, malala nyuca la tjajay, ne ma ca jis capj ntülüs yupj. Nin mpes ca nin ló nsem jupj”, nin tjevele ángel José lal. ");
INSERT INTO jicNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nin tepyala ca pjü t'üc' mpalas Dios tjevele püná. Pajal püna Dios profeta pjaní tjevele ca nin mpalas. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tsjücjüim way tsjicj ma'ajam, ca yom tsjicj ma'nus. ‘Emanuel’ ló ca nsem jupj.” Jupj ló cupj qjuis tin “Dios Cupj Qjuis Lal” velecj cupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José jola tepyala na, nin la tjiji Dios ángel tjevele jinwá. Lal tjac' María jupj wo nt'a ne jupj jats'om tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Custjay ma ne'aj tjemya'na jupj, María tsjicj tjemya'na nas. José tsjicj ló t'ya Jesús ló nsem, ángel tjijyü'ta jin. ");
INSERT INTO jicNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús tjemya'na Belén nt'a, Judea mpe se jütütj nt'a. Herodes jépatsja ne'aj Jesús tjemya'na na. Jupj nt'a tjiquil niyom magopan nepenowá, Jerusalén nt'a. Niyom nenem tjiquil tsiquin mpe, pajal campa mpe tjiquil yupj, la tapal tsjicj way. ");
INSERT INTO jicNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Niyom tjowelepj jupj lal: —¿Ca'aj pü'ü tsjiquis, ca jepa püné nsem judiopan mpes? Ncupj nyucucj pjulacj pjaní jupj tjac' mpes. Nin mpes jus nlayecj tjemya'na quinam tsjiquis. Ne'aj tjinyucucj pjulacj, cupj pyatjaquecj nt'a, tsiquin mo'ó. Nin mpes tjiquilaca. Cupj quelel palá nipi'tjiquecj jupj wolap'a'á, qjuiyola jupj püné —nin tjowelepj niná noyomes. ");
INSERT INTO jicNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes tjapjácatsja na niná, pajal jola tepyala jupj. Pajal yola tepyala wa pjü way Jerusalén mo'o tapatjá. ");
INSERT INTO jicNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mpes Herodes pjü jis lal tjevele 'a jis mulus sacerdote noypan, 'a jis mulus wa niyom Moisés popel sin 'yüsa lajay, israelpan sin popé. Herodes jis la tji'yüya ca'aj ca ma'nus Jepa Püné Dios tjevele ca jas majamas jis capj la p'acj judiopan. ");
INSERT INTO jicNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yupj tjowelepj jupj lal: —Belén mo'o patja nt'a ca ma'nus jupj, Judea mpe se jütütj nt'a. Nin tepyaca profeta: ");
INSERT INTO jicNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belén nt'a, Judá püna tüpü'ü nt'a, pjaní way p'in patja ne'aj. Mop'in Belén pajal tsjicj way tulucj Judea mo'o se jütütj jis lal. Belén mpe jepa ca ncuwim. Ca jis majamas jupj israelpan, yupj niná napj jyütütj.’ Nin tepyaca profeta, Dios Yom ca jas majamas mpes —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nin tjowelepj Herodes lal, mpes seletsja Belén mo'o tjemya'na tsjiquis. Mpes Herodes tjevele ncul niyom tsiquin mpe tjiquil. Ma tjevele p'a lal nin la tjiji jupj. Herodes pajal jis la tji'yüya 'ona lay tepyala pjulacj, tsjicj mpes lay tepyala. ");
INSERT INTO jicNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yupj jupj wola tjowelepj na, jupj sin tjejyama yupj Belén mo'ó. Jis lal tjevele: —Lowa, pajal ca la mü'üyá tsjicj niná mpes. Jus tjunucú na, nawala tjowelé. Napj mis wa ca jupj nt'a, ca palá mpi'tjis jupj wolap'a'á —tjevele Herodes. Jupj li tsuwíletsja. Quelel 'yǘ'natsja tsjicj way. ");
INSERT INTO jicNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Noyomes tjil yupj Belén nt'a, Herodes tjevele mpes. Tjil na, pjulacj tjunuc niswá, 'in lacasana tjunuctsja p'in. Niswa lay tepyala tsjun popé. Nin p'iyatsja tsiquin mo'o tjunuc jin p'iyá. Pjulacj mwalá tjemeytsja yupj jis lal, nasa ne'as tjemey tsjicj tüpü'ü nt'a. Ne'aj tón̈catsja. ");
INSERT INTO jicNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Niná noyomes pajal 'ücj jisastsja pjulacj tjunuc mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne'as tjil tsjicj wo nt'a, jupj tüpü'ü nt'a. Wama tjil, wosis mo'ó. Jus tjunuc tsjiquis jamay lal. Jamay María lotsja. Tjunuctsja na, tsjicj wolap'a'a palá nipi'tjin̈. Tjowelepj jupj pajal püné. Locopyaya jun tjocjol yupj jis caja, pje'á la tocoy jis la 'ayas tsjicj mpes. Oro tja'ayapj. Ts'ülüc' 'üsüs cjumsu la 'üm tja'ayapj wa. Mirra perfume mpes tja'ayapj wa. ");
INSERT INTO jicNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tjunuc tsjicj way yupj, mop'in ma tjil Herodes nt'a niswá. Yupj tjijinan̈ na püste na, Dios yupj jis lal tjevele ma polel jiltsja Herodes nt'a. Nin mpes tjil p'a jümücj nt'a, püna tapatja po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Niyom tjil na, Dios ángel pjaní lay tepyala José nt'a, jupj tjejyá na. Ángel tjevele jupj lal: “Jin ni'isa nts'equenem Egipto mo'ó tsjicj lal, jamay lal. Ne'aj mpü'üm, napj tjevelé nas ca ncuwim. Herodes tsjicj ca la mpalas la 'ünan”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mpes José jas nisa, nin jawas püste p'iyá tjemey Egipto nt'a. Tjemey tsjicj lal, tsjicj jamay lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne'aj tüpǘ'ütsja Herodes tepe'e nas. Nin tepyala ca t'üc' mpalas qjuis Jepa Dios tjevelá püná. “Napj tjevelé natjam ca mim Egipto mpe”, tjevele Dios. Nin tjevele profeta jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Locopyaya Herodes jus nleya niyom tsiquin mpe ne'espan ma jiquiltsja. La tsawiltsja yupj. Pajal ts'i tji'ínatsja jupj. Mpes jis tjijyü'ta pjü jis la 'ünan niyom tsjictjacj Belén nt'a, Belén ne'aj p'in 'ots'ipj. Pjü niyom tsjictjacj año mat'e jis tjü'ünan. Más 'in tsjicj way pjü jis tjü'ünan wa yupj. Herodes jola tepyala tsjiquis año mat'e tya'a quinam, noyomes tsiquin mpe ne'espan tjowelepj mpes. Nin mpes nin la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nin mpes nin tepyala Jeremías tjevele püná. Ninana jupj tjevelá Dios mpes: ");
INSERT INTO jicNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tjepjyacan̈ la puyupj Ramá nt'a. Ne'aj pajal yümücj la tupuyupj. Raquel la tipiya watsja tsjictjacj mpes, locopyaya tapatjá. Jupj ma quelel jo' pé'etsja, tsjictjacj tecya'lin̈ mpes.” Nin tjevele Jeremías. ");
INSERT INTO jicNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes tepe'e na, Dios ángel niswa lay tepyala José lal, tjejyá na. José newa pǘ'ütsja Egipto mo'ó. Ángel tjevele jupj lal: ");
INSERT INTO jicNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Jutja niswá Israel nt'a. Nasa tecya'lin̈ tsjicj quelel ja'ünan witjacj.” ");
INSERT INTO jicNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mpes José jas nisa, tjemey niswá Israel mo'ó. Lal tjemey wa tsjiquis, tsjicj jamay lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Locopyaya José wola tjoweleptsja Herodes jatjam Arquelao jepa tjá'asa quinam Judea mo'ó, popay tepe'e mpes. José lecj jéyatsja jupj mpes, ne ma quelel jámatsja ne'aj, jupj tjijyü'ta nt'a. Locopyaya Dios José lal tjevele niswá, tjejyá na. Tjevele ca ma mim Judea nt'a. Mpes José más 'in campa tjemey Judea mpe. Galilea nt'a tjemey, nin p'iyá Israel mpetsja jupj, Galilea. ");
INSERT INTO jicNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea nt'a tjemey, pjaní way p'in patja nt'a, lo püt'üs ne'aj. Nazaret lotsja ne'aj tapatja nt'a. Mpes nin tepyala profetapan tjowelepj püná. Tjowelepj: “Yom Dios jas tjejyamá Nazaret mpe 'esepj nsem jupj”. ");
INSERT INTO jicNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús newa tüpü'ü Nazaret po'ó, Juan el Bautista mwalá way véletsja na Dios mpes. Pülücj jis walap'a'a tjevele jupj. Judea nt'a wínetsja, wa cjuwá nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jupj tjevéletsja: “'Aplijila t'as malala nyuca la tjüjí mpes. 'Üsüs la müjí quinam Dios jos jinwá. Quina ca nu müjü'tüs Dios”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pajal püna Isaías tjevele nin ca mveles jupj. Isaías profétatsja jupj püná. Ninana Isaías tjevele Juan po'ó: “Yom niná wa cjuwá nt'a ca mim. Pajal ca quelel mveles gente jilal. Mpes yümücj ca mveles: ‘Qjuis Jepa Dios ca ncuwim. Nujola t'as ca nin la müjí quinam jupj jos jin. Malala nujola nun, jümücj la lu'ulú jinwá. Po ma malala nujola t'as quinam. 'Üsüs nujola t'as qjuis Jepa Dios jos jinwá’ nin ca mveles jupj.” Isaías tjevele jupj ca nin mveles, ne t'üc' way Juan nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan jas quip camello ts'üilin waytsja jupj. Col tsyú'patsja pjoloc' mpes. Ts'elel lyájatsja. Ts'as qjuisiyas mo'o píjisa watsja. Lovin nin tüpü'ü. ");
INSERT INTO jicNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gente pajal pülücj tjiquil jupj nt'a jis la pjac jupj tjevelá. Jerusalén mpe tjiquil wa, judiopan pülücj patja mpe. Pjü Judea mpe tjiquil wa, ne'aj judiopan pjaní pjaní patja nt'a. Tjiquil wa 'üsǘ püné la nt'a patja mpe, niná 'üsǘ Jordán ló. ");
INSERT INTO jicNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yupj tjiquil, tjowelepj jupj lal malala nyuca la tjajay. Niná tjowelepj na, Juan bautizar lis tjiji 'üsǘ mo'ó, niná 'üsǘ Jordán ló. ");
INSERT INTO jicNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juan tjinyuca watsja fariseopan pülücj jiquiltsja, pülücj saduceopan tjiquil wa. Juan ma tepyónatsja yupj pajal 'aplijílatsja malala la tjajay mpes. Mpes jupj tjevele yupj jis lal: “Nun nin p'iyá latsj jinwá. Nun solejé Dios po ma jos gente malala lajay. Len̈ way ca jis capj ntülüs. Nin mpes tjuculá nun napj nt'a, napj ca bautizar la numejay. Nujola nin lojí mpes, jupj ma ca nucopj ntülüs. T'üc' tulucj. Dios selé nun newa ma quelel lojí jupj jos jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","T'üc' way 'aplijila catsja nun malala la tjüjí, 'üsüs la cüjí quinam Dios jos jin. Najas la müjí nun niná. ");
INSERT INTO jicNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Po ma nujola t'as nun pajal 'üsüs, nun judiopan mpes. Ma ca nujola nsem nun pajal 'üsüs way, nun Abraham püna tüpü'ü popa p'iyá mpes. T'üc' tulucj. Dios ca 'ücj la qjuijis niná pwen Abraham ts'uyupj ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dios pajal len̈ way ca jis capj ntülüs malala lajay. Yupj ma 'üsüs way lajay, jupj ca jis capj ntülüs yupj pjü way. Yom jupj sine ma vyala jinwá ca la mijis Dios. Jupj sine ma vyala, jyo'o, 'awa mo'o ts'iyá. Nin ca la mijis Dios malala lajay jis lal”, nin tjevele Juan fariseopan jis lal, saduceopan jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Juan tjevele wa: “Napj bautizar la nusejay 'üsǘ lal p'in. Napj nin lejay mpes, ca pjü jus nlayecj 'aplijila nun malala nyuca la tjüjí mpes. Jus nlayecj nasa quelel lojí Dios jos jinwá. P'a wa ca ncuwim más püné napj lal. Napj pajal tsjicj way jupj lal. Po 'üsüs napj lal napj tsji' lejay jupj mpes. Napj jupj caite jet' la p'in, 'ücj napj lal. Pajal 'üsüs ca la mijis jupj. Nun nepénowa quelel lojí Dios jos jinwá. Jupj ca nu ma'ayas Dios Cjües. Nun nepénowa newa ma quelel lojí Dios jos jinwá. Jupj ca nucopj ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Len̈ way ca nin la mijis. Ca 'üsüs la mijis jupj 'amá nt'a, ma ca malala witjacj mpatjam ne'aj. Ca ne'aj mo'onsos 'üsüs witjacj, ma ca malala jis mpalas. Pjü malala ca mü'ümüs. Jupj 'yüma na, len̈ pjacj se wat'ata jupj 'owus”, nin tjevele Juan el Bautista yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Locopyaya Jesús tjac' wa Juan nt'a. Jesús jostsja ca Juan bautizar la mijis jupj. Jesús tjac' Galilea mpe. Tjac' 'üsǘ nt'a, niná 'üsǘ Jordán ló, Juan tüpü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan ma quelel bautizar líjitsja jupj. Nin tjevele Jesús lal: —Más 'ücj jipj bautizar la nejay napj. Jipj más 'üsüs napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús tjevele Juan lal: —Najas ne jipj ca nin la mijin quinam. Más 'ücj pjü 'üsüs lijicj Dios jos jin. Mpes Juan tjevele 'ücj ca bautizar la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizar la tjiji na, Jesús tjemey 'üsǘ mpe. Tjemey na 'üsǘ mpe, len̈ way tsjun po'o tsjicj way la tücüeme, jun cjol tepyala. Jupj tjinyuca Dios Cjües palavin tjac'. Sipipj jinwá justa tjac' jupj Jesús nt'a. Jesús copá nt'a tjac'. Ma tjemey nepé. ");
INSERT INTO jicNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tsjun po'o nepé vele pjactsja: “Niná napj Natjam. Pajal quelel lejay jupj. Pajal 'üsüs najas jupj mpes.” ");
INSERT INTO jicNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesús bautizar tepyala na, campa 'in tjemey, wa cjuwá nt'a, jusapj p'in. Dios Cjües jostsja mpes tjemey jupj. Ne'aj jámatsja nt'a, diablo quelel malala véletsja jupj lal, la nuc ncu malala la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jaw cuarenta, püste cuarenta Jesús laja sectsja tjuwine ne'aj. Tecyawaja ts'ac' cuarenta na, vecj pé'etsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Diablo lovin jostsja Jesús malala la mijis. Diablo lovin malala vele gente jis lal, jos malala nyuca lajay. Jupj tjac' Jesús nt'a, tjevele: —Jipj Dios Jatjam p'iyá, 'ücj ca müjü'tün niná pe ca ve mpalas, ne nin ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús ma la tjiji diablo tjevele jin. Jesús Dios Popel velá tjevele p'in. —Dios Popel vele: ‘Gente ma ca mpatjam ve mpes p'in. Pjü way Dios tjevelá mpes ca mpatjam yupj’ —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Locopyaya diablo malala la tjiji, tjemyana Jesús Jerusalén mo'ó, Dios wo ton̈ca nt'a. Ne'aj Dios wo casapa tjijyünsa jupj. Pajal campányatsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Diablo tjevele Jesús lal: —Jipj Dios Jatjam p'in, palá ntolo quepé. Dios Popel vele: ‘Dios ca jis müjü'tüs jupj angelpan, ca mya jamacj jipj. Jis mas mpes ca mya ma'nucj, ne ca ma mpojom jipj, pe lal. Ma ca malala mya palas’ —nin tjevele diablú. ");
INSERT INTO jicNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús ma la tjiji diablo tjevele jin. Nin p'in tjevele jupj lal: —Dios Popel tjevele wa: ‘Jipj ma ca malala la mijin ma jola jinwá, la nuc ncu jipj Jepa Dios ca cyapj mp'a'sas’ —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Diablo niswa malala la tjiji Jesús lal. Lal tjemey joc' campanya nt'a. Ne'aj la tjiji Jesús 'ücj tjinyuca pjü nt'a nosis mo'ó. La tjiji tjinyuca wa pjü 'üsüs way jatatj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Diablo tjevele jupj lal: —Napj nawalap'a'a ca palá mpi'tjim, ca mvelen napj pajal püné. Niná la tjejay na, napj ca pjü niná mya 'a müjü'tün. ");
INSERT INTO jicNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús ma la tjiji jupj jostsja jinwá. Tjevele: —Satanás, jutja jipj. Dios Popel vele: ‘Dios jepa más püné pjü jilal. Nujola tapalas jupj p'in püné. Ma nin nujola nsem la p'a p'in püné Dios jinwá. Dios jos jin la müjí la p'in.’ ");
INSERT INTO jicNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesús nin tjevele na, diablo tjemey. Tjemey na, angelpan tjiquil, cus tjap'acj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús wola tjowelepj Juan ntji'lin̈, cawilta mo'o tjo'onsopj jupj, jepa tjevele mpes. Niná jus nleya na, Jesús tjemey Galilea mo'ó niswá, cámpatsja 'in. ");
INSERT INTO jicNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ne'as tjemey na, ma tüpü'ü Nazaret nt'a, püna tüpü'ü nt'a. Tjemey nepé quinam, Capernaum nt'a tjemey, pülücj patja nt'a. Ne'aj p'intsja 'üsǘ la nt'a, Zabulón lotsja ne'aj pajal püna. Neftalí ló watsja ne'aj pajal püna. ");
INSERT INTO jicNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesús tjemey ne'aj ca t'üc' cüpalas Isaías tjevele Dios mpes püná. Isaías profétatsja jupj. Ninana jupj tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pülücj patja ne'aj Zabulón nt'a. Pülücj patja wa Neftalí nt'a. Jümücj 'üsǘ püné nt'a, yupj patja nt'a culupwen nipj jama jümücj niná. 'Üsǘ la nt'a patja, niná 'üsǘ Jordán ló. Ne'aj Galilea ló, judiopan tulucj patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yupj ma sa nuctsja Dios. Quina pajal 'üsüs sin tji'yüsa Dios mpes. Tecya'lin̈ jinwatsja yupj yas nam, ma topon mpes. Malala lajaytsja. Quina 'ücj sin 'yüsa Dios tjevele jin.” Nin tjevele Isaías ca nin mpalas ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nin tepyala jupj tjevele jin. Jesús ne'as tjemey na Capernaum nt'a, jupj véletsja Dios po'ó pülücj jis walap'a'á, ne'aj tapatja sin popé. Véletsja: “'Aplijila t'as malala nyuca la tjüjí. 'Üsüs la müjí quinam Dios jos jinwá. 'Üsüs way quinam Dios ca müjü'tüs. Jepa jupj. Len̈ way ca müjü'tüs nosis nt'a”, nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús tjuwínetsja 'üsǘ la nt'a. Niná 'üsǘ Galilea lotsja. Ne'aj wínetsja na, niyom mat'e yus tjinyuca. Pjaní wa Simón lotsja. Jupj ló watsja Pedro. P'a wa Andrés lotsja. Jupj Simón tsüípetsja. Yupj jis ataraya la ts'i 'üsǘ mo'ó. Cjul pje'á la coytsja. Lovin nin lajaytsja, tapatja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús tjevele yupj jis lal: “Ncapj ncon̈có nun. Napj ca nusin 'yüsa la mejay 'ücj la veles p'a jilal Dios mpes. Nin mpes ca nepénowa cus ncon̈cocj wa jupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Len̈ way tüpüntüpj yupj jis ataraya, tjil Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsjicj way tjil na, Jesús tjinyuca la p'a wa niyom mat'e. Pjaní wa Jacobo lotsja. Ma'ajapj Juan lotsja. Juan Jacobo tsüípetsja. Zebedeo jatjampan waytsja yupj. Játjatsja yupj jis barco mo'ó, yupj jis papay lal. Jis ataraya 'ücj lajaytsja. Jesús jis la tjemyona ncul yupj, ca cus ncon̈cocj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Len̈ way tjil Jesús lal. Barco tüpüntüpj tjil. Tjil jis papay mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús tjuwínetsja jun ta'á Galilea mo'ó. Newa sin 'yüsa la síjitsja judiopan. Wosis judiopan 'a jis tjimyula nt'a sin tji'yüsa lis tjiji jupj lovin. Pülücj jis walap'a'a tjevele pajal 'üsüs tepyala Dios mpes. Tjevele quina ca müjü'tüs Dios yupj jis lal. Jupj jis tji'yü'sa la tjiji wa pjü malala jisas ne'aj. Jis tji'yü'sa la tjiji wa pajal sin napnapj witjacj. ");
INSERT INTO jicNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nin mpes yupj tjowelepj Jesús pajal 'üsüstsja. Campa nepé tapatja tjepjyacan̈ watsja Jesús po'ó. Pjü Siria mo'o tapatja pjyacan̈ watsja jupj po'ó. Mpes yupj jis tucuman wa malala jisas yupj sin popé Jesús nt'a. Nepénowa pasal nepé vyájatsja. Nepénowa lapanenpan jatjatsja yupj jisas mo'ó. Nepénowa yun jyu'ya jin lajaytsja. Nepénowa ma polel 'yutanan̈tsja. Pjü way Jesús jis tji'yü'sa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pajal pülücj tjiquil jupj nt'a. Cus tocon̈ wa jupj tjemey nt'a. Pülücj way tjiquil Galilea mpe, Decápolis mpe 'ots'ipj, Jerusalén mpe 'ots'ipj, Judea mpe 'ots'ipj. Tjiquil wa 'üsǘ na'aj po'ó patja mpe, 'üsǘ Jordán ló. ");
INSERT INTO jicNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús pje'á tón̈catsja. Jupj tjinyuca gente pajal pülücj tjiquil, 'a jis tjimyula jupj nt'a. Nin mpes tucuc' popa viyá tjemey, tsjicj way p'in. 'Etjele jupj, ca sin 'yüsa la mijis. Jupj nt'a tjiquil watsja jupj discipulopan. Quelel pjyacan̈tsja jupj tjevele mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nasa tjiquil na, jupj sin tji'yüsa lis tjiji. Nin tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nun po jisas ca Dios nucopj mp'a'sas, pajal 'ücj nujisas nsem nun. Dios nun jis Jepa quinam, niná nujostsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nun pajal 'aplijila jotjaqué, pajal 'ücj nujisas nsem wa nun. Dios ca 'ücj nujos la mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nun nujola nun tsjictjacj way p'in, pajal 'ücj nujisas nsem wa nun. Nosis nun nuts'a'á ca nsem, nin nujola mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nun pajal quelel 'üsüs lojí Dios jos jin, pajal 'ücj nujisas nsem wa nun. Dios ca nucopj mp'a'sas ca 'üsüs la müjí, nujisas jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nun quelel jis capj mp'a'sá la p'a wa, malala se palá na, pajal 'ücj nujisas nsem wa nun. Jupj ca nucopj mp'a'sas wa nun. ");
INSERT INTO jicNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nun nepénowa pjaní p'in quelel lojí. Nun quelel lojí Dios jos jin. Nin mpes ca 'ücj nujisas nsem nun. Nun ca jus nucú Dios. ");
INSERT INTO jicNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nun tsji' lojí, la p'a wa ca perdonar lis mijicj yupj yuwá, pajal 'ücj nujisas nsem wa nun. Dios ca mveles nun jupj jatjampan, jucucuspan. ");
INSERT INTO jicNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","La p'a wa malala lajay nun jilal, nun 'üsüs lojí mpes Dios jos jin, pajal 'ücj nujisas nsem wa nun. Dios nun jis Jepa quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”La p'a wa malala javelepj nun jis lal nun ncapj con̈có mpes, pajal 'ücj nujisas nsem. La p'a wa malala lajay nun jis lal, nun ncapj con̈có mpes, 'ücj nujisas nsem wa. La p'a wa la tsuwil nun po'ó ncapj con̈có mpes, 'ücj nujisas nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Ücj nujisas t'as nin tepyala mpes. Po 'üsüs ca nu ma'ayas Dios tsjun po'ó, 'üsüs la tjüjí mpes. T'üc' way niná. Nin p'iyá nu tepyala nun, profetapan püna tapatja jis tepyala jin p'iyá. Dios ma jisas malala la tjajay wa yupj jis lal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús tjevele wa yupj jis lal: “Nun sal jinwá nosis casá, nun ncapj con̈có mpes. Sal mpes ts'ucú pisis, ma malala mpalas, ma mojo jupj. Nin tulucj sal ma wüjü na. Sal ma wüjü na, ma polel wüjü lajay jupj. 'Üsüs tulucj jupj. Na'aj la ts'i p'in, ca casá majatsjacj gentas. Nin p'iyá nun jis lal, mpes sal 'üsüs jinwá t'as nun. ");
INSERT INTO jicNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Nun ncapj con̈có, nun jaw jinwá nosis casa'á. Nun mpes la p'a wa ca sin mü'üsüs Dios mpes. Pülücj patja tucuc' pacá nt'a, ma polel pjya'len̈. Yupj patja nt'a 'ücj la nuc. Nin p'iyá, la p'a wa januc wa nun lojí jin. ");
INSERT INTO jicNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Iyó su müjǘ na, ma jun t'o'nó quiliyú lal. 'Üsüs way nt'a p'in ca mpüntǘ, 'iyó jaw ca pjü nucucj jis wa nt'a. Nin p'iyá jaw jinwá ca nsem nun, nosis casá patja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nun jaw jinwá ncapj con̈có mpes. Nun lojí Dios jos jinwá, nun jaw jinwá la p'a jis lal. Nin la müjí Dios jos. Nin mpes ca la p'a wa nucucj nun 'üsüs lojí. Ca 'üsüs mvelecj Dios po'ó. Jupj nun jis Papay tsjun po'ó”, nin tjevele jupj, Jesucristá. ");
INSERT INTO jicNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Niná Jesús tjevele wa yupj jis lal, neven po'o 'a jis tjimyula na: “Pajal püna Moisés tjevele judiopan jis lal Dios tjijyü'tá. P'a wa profetapan tjowelepj wa Dios jostsja mpes. Newa nin ca nsem yupj tjowelepj jinwá. P'a casá velé tulucj. Nusin tjü'üsüs niná. Napj lejay pjü ca mpalas yupj tjowelepj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dios lovin ca müjü'tüs niná p'iyá, püna tjijyü'ta jin p'iyá. Nin ca nsem tsjun po'o jala p'in, nosis jala p'in. Pjü ca mpalas jupj tjijyü'ta jinwá. Niná t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","T'üc' tulucj 'ücj ma lojí pjü way Dios tjijyü'tá. Nun pjaní way p'in ma lojí Dios tjijyü'tá, malala nin. Nun la p'a wa sin 'yüsa lojí wa 'ücj ma lajay niná, malala pajal. Niná sin 'yüsa lajay tsjictjacj way p'in ca nsem yupj Dios jyü'ta nt'a. Nun pjü way lojí Dios tjijyü'ta jinwá, po 'üsüs way niná. Nun la p'a wa sin 'yüsa lojí ca pjü la mijicj Dios jyü'ta jin, 'üsüs way niná. Niná sin 'yüsa lajay, ca noypan nsem Dios jyü'ta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moisés popel sin 'yüsa lajay ma pjü way lajay Dios jos jinwá. Fariseopan ma pjü way lajay Dios jos jinwá. Ma yupj jinwá la müjí. 'Üsüs la müjí la p'in Dios jos jin. Nun yupj jinwá lojí, ma nun jis Jepa nsem Dios lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”Pajal püna Moisés tjijyü'ta: ‘Ca ma jis mü'ü'nacj la p'a’. Nun la p'a 'ü'ná, jepapan ca nucopj ntülücj, ca nu mü'ü'nacj ca nun. Püna tapatja salejeptsja niná Moisés tjijyü'tá. Nun solejé wa niná. ");
INSERT INTO jicNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mop'in napj najas más 'üsüs la müjí püna tapatja jis lal. Dios jos 'üsüs ca la müjí. Jos wa 'üsüs nujola nun. Mpes napj nin velé niná: nun ts'u 'inyá p'a jis lal, jepa 'ücj ca nucopj ntülüs. Nun welé wa p'a lal: ‘Jey c'a jipj’, judiopan jis jepapan 'ücj nucopj ntülücj nin tjowelé mpes. Nun welé p'a lal: ‘Malala jipj pajal’, Dios 'ücj ca nucopj ntülüs 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Nin mpes ma malala la müjí la p'a lal. Nun malala la tjüjí na p'a lal, la tjomoná jupj ca perdonar la numijis nun. Nun ma 'ücj la tjüjí na p'in, ma polel t'emel la 'ayas Dios mpes. Nasa quelel 'oyá Dios mpes ca nacj, Dios wo mo'ó. Quelel 'oyá na, nujola pyala nun malala la tjüjí p'a lal. ");
INSERT INTO jicNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ma ca ma'ayá Dios mpes quinam. Niná nujola tepyala na, lowa jupj nt'a, püna malala la tjüjí nt'a. Tjowelé nujisas jupj ca perdonar la numijis. Tjowelé nujisas nun jupj jomicapan ca nsem quinam. Niná la tjüjí na 'ücj lowú Dios wo nt'a, t'emel nu la 'ayas”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jesús sin tji'yüsa lis tjiji wa más 'ücj po 'in len̈ way ca nlaca ca la monacj ca p'a perdonar la qjuis mijis, ncupj malala la tjijicj. Ninana Jesús tjevelá: “Nun jis enemigo quelel t'ya mveles nun mpes lay nt'a ca nacj. Nin quelel liji jupj, len̈ way lowa jupj nt'a. La moná ca perdonar la numijis. Nun malala la tjüjí jupj juts'a'á, nun ca p'a wa seyasa ma'ayá jupj, malala la tjüjí mpes. Nun ma lojí niná, nun jis enemigo ca mim jepa já'asa nt'a, ca mveles nun malala la tjüjí. Nin mpes ca jepa nucopj ntülüs. Jepa ca mveles jupj auxiliar lal cawilta mo'o ca nu wama manus. ");
INSERT INTO jicNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jepa ma wa ca nusin majamas ma pjü way jaylacj la tjüjí jupj la tjemyona mpes. Pjü way jaylacj la müjí nun. Niná t'üc' way”, tjevele Jesús. Pjü way mpes sin tji'yüsa lis tjiji ca Dios qjuis capj ntülüs, ma le monacj la p'a ca perdonar la qjuis mijicj cupj malala lis tjijicj na. ");
INSERT INTO jicNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús tjevele wa niná: “Tsjay püna tjüjütütsja niyom ma ca ne'aj ma'nucj sejats'om tulucj. Tjüjütütj nequem ma ca mal jis voyum tulucj jis lal. Nun solejé niná. ");
INSERT INTO jicNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Napj najas más 'üsüs lojí püna la tjajay jis lal. Dios jos 'üsüs lojí. Jos wa 'üsüs way nujola nujos mo'ó. Yom quepj si nucú ne jos jupj, malala niná Dios lal. Jupj quelel malala líjitsja, malala wa, jupj niná t'üc' la tjiji jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","”Po ma malala la müjí nun. Nun nucú mpes p'in quelel malala lojí, po ma tjunucú niná. Nujun tulucj jinwá nujola t'as nun, nujun t'ü, na'aj la ts'i jinwá. Malala lajay ca mal 'awa püné nt'a, mpem ne'aj. Más 'ücj nujun tulucj, ne ma ca mpem nup'üy pjü 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nun quelel malala lojí nun numos li'inyampe mpes, ma la müjí. Nujola t'as numos cjuwá jinwá, numos t'ü, na'aj la ts'i jinwá. Malala lajay ca mal 'awa püné nt'a, mpem ne'aj. Más 'ücj numos cjuwá ne ma ca mpem nup'üy pjü 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Püna javeleptsja: ‘Yom quelel se jamá jats'om, ca papel ma'ayas jupj. Papel ca mveles niná jupj jats'om tulucj quinam.’ ");
INSERT INTO jicNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nin la tjajaytsja püná. Napj najas más 'üsüs lojí püna la tjajay lal. Ma najas nun sejats'om so jamá. Jets'om la p'a yom lal wine, nin mpes p'in 'ücj se jam jupj. Yom se jamá jats'om, jats'om la p'a lal ca mwayis ca nacj. Jupj la p'a voyum nta'as, mop'in nin, Dios ca ma voyum lal wine mveles jupj. Nin p'iyá yom lal. P'a yom jats'om lal woya, Dios ca ma jats'om ne'aj mya'na mveles jupj. Malala lajay p'in Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Nun solejé wa püna tjüjütütj püna tapatja jis lal ma la ntsawilicj. ‘T'üc' la müjí pjü way nun tjowelé Dios lal. Jupj nun jis Jepa Püné’, nin tjüjütütj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Napj najas más 'üsüs lojí püna la tjajay lal. T'üc' tjowelé lovin. Po ma jurar la müjí. Ma wa jurar la müjí tsjun po'ó mpes. 'Ücj tulucj lu tsuwilí niná welé mpes. Dios p'in jyü'ta tsjun po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma wa jurar la müjí nosis mpes. 'Ücj tulucj lu tsuwilí niná welé mpes. Dios jyü'ta wa nosis nt'a. Ma wa jurar la müjí Jerusalén mpes. Ne'aj pülücj patja nt'a Dios Jepa Püné. ");
INSERT INTO jicNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma wa jurar la müjí nun sey pjucj mpes. 'Ücj tulucj lu tsuwilí niná welé mpes. Nun ma ca polel la müjí nun jis ts'il pjaní pje, nun jis ts'il pjaní te. ");
INSERT INTO jicNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nin mpes ma ca jurar la müjí. T'üc' tjowelé la p'in. Gente jurar lajay na, diablo jos jin lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Püna javelepj watsja niná: la p'a malala la tjiji nun lal, 'ücj wa malala lojí jupj lal. ‘Malala liji jun la p'a lal, 'ücj wa malala la mijis wa jupj jun. La p'a wis 'yula, 'ücj wa lu 'ul jupj wis’, nin javeleptsja yupj püná. Nun solejé niná. ");
INSERT INTO jicNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mop'in napj najas más 'üsüs lojí püna la tjajay lal. Jis ma'ayá la p'a ca malala la mijicj nun jis lal. La p'a wa nupjocj po'o tyüla li'inyampe po'ó, nun ca ma'ayá nancupwepe tyüla wa. ");
INSERT INTO jicNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jipj enemigo quelel t'ya vele jipj mpes ca nacj. Jos wa jepa ca la monas jin quip wampa, jipj la tjejay mpes. Tje'yaya jipj enemigo jin quip wampa. Tje'yaya wa jin quip pje'apa. ");
INSERT INTO jicNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jepa jyü'ta nlawú jupj lal legua pjaní, lowa jupj lal. Ca nlawú wa p'a legua po'ó jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","La p'a wa nun lal la mon na, jis ma'ayá wa. La p'a wa jisas nun prestar lojí, ma ca mvelé ca ma ma'ayá. Ninana napj najas. ");
INSERT INTO jicNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”Püna javelepj watsja: ‘Jipj ca quelel lis mijin ne'aj patjá. Ma ca jyas nsem jipj enemigopan.’ Nun solejé wa niná tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mop'in napj najas más 'üsüs lojí püna la tjajay lal. Najas nun quelel lis müjí nun jis enemigopan. La p'a malala lajay na nun jis lal, Dios lal la tjomoná nun yupj mpes. La tjomoná jupj ca jis capj mp'a'sas. ");
INSERT INTO jicNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nun niná lojí na, Nupopay Dios jinwá lojí. Jupj jatjampan nun, jucucuspan nun. Jupj nun jis Papay tsjun po'ó. Jupj pajal 'üsüs liji pjü jis lal. Jupj liji jyawca lots'ac'. Jyawca wa malalapan mpes. Jyawca wa 'üsüspan mpes. Jüwǘ jive mpes se 'aya Dios 'üsüspan mpes, malalapan mpes wa se 'aya jüwüs. ");
INSERT INTO jicNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","La p'a quelel la nusejay nun, mpes nun quelel la sojí wa yupj. Yupj ma quelel la nusejay nun, nun ma wa quelel la sojí yupj. Dios ma ca mveles nun 'üsüs way lojí nun nin lojí mpes. Malala lajay ne nin p'iyá lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nun 'üsüs way welé nun sejamicapan jis lal ca nacj. Ma quelel 'üsüs welé p'a wa jis lal ca nacj. Nun nin p'iyá lojí, nun más 'üsüs tulucj p'a jis lal. Ne nin p'iyá lajay Dios ma japon. ");
INSERT INTO jicNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nin mpes najas pajal 'üsüs lojí nun, nun jis Papay Dios 'üsüs liji jinwá”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús tjevele wa yupj jis lal: “Nepénowa jisas la p'a wa yola yupj 'üsüs. Nin mpes 'üsüs lajay la p'a jis la nuc. 'In tjajama ma la müjí niná. Niná lojí na, nun Nupopay tsjun po'o ma ca mveles nun 'üsüs la tjüjí. ");
INSERT INTO jicNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nin mpes najas ma mvelé nun p'a lal nun t'emel 'oyá t'emel cjuwá. T'emel 'oyá na, lyájasa jinwá la müjí. Nepénowa jisas pjü way jus nlayecj yupj 'üsüs lajay, mpes pjü jis walap'a'á ja'ayapj, judiopan 'a si mulú nt'a, jümücj nt'a 'ots'ipj. Jisas la p'a wa ca mvelecj yupj 'üsüs. Yupj ma t'üc' way quelel lajay t'emel cjuwá. T'üc' way gente p'in javelepj yupj 'üsüs. Dios ma ca nin mveles. ");
INSERT INTO jicNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma ca nin la müjí nun. Nun 'oyá na cjuwá jilal, lyájasa jinwá ma'ayá. Ma pjaní lal tjowelé nun 'oyá. ");
INSERT INTO jicNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","La p'a wa ma ca jus nlayecj nun tja'ayá. Nupopay Dios p'in ca nucus. Jupj pjü way nyuca nun ma welé. Jupj ca mveles nun pajal 'üsüs way la tjüjí. ");
INSERT INTO jicNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Nepénowa javelepj Dios lal, newa nin ma lajay Dios jos jinwá. Jisas la p'a januc yupj Dios lal javelepj. Nin mpes jyünsünün̈ judiopan 'a si mulú nt'a, pülücj jil nt'a jyünsünün̈ wa, ne'aj javelepj Dios lal. Niná nin lajay, ma t'üc' way 'üsüs. Napj t'üc' way velé. Gente p'in ca mvelecj yupj 'üsüs. Dios lovin ma ca mveles yupj 'üsüs. Nun Dios lal welé na, ma ca la müjí yupj lajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nun Dios lal welé na, ma ca p'a lal mvelé jupj lal ca mvelé. Wama lowa nun jis wa mo'ó. Jun t'o'nó jun vilicj. Nun jis wa mo'ó ca mvelé Nupopay Dios lal, la p'a ma januc nt'a. Nupopay pjü nyuca nun pjü lojí la p'a wa ma januc nt'a. Jupj ca mveles nun pajal 'üsüs way la tjüjí nun. ");
INSERT INTO jicNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Judiopan tulucj ma sin 'yüsa Dios po'ó. Yupj javelepj Dios lal, ma 'üsüs way yola jinwá javelepj. Nin mpes nin p'iyá pajal pülücj javelepj Dios lal. Yupj yola pajal la pülücj javelepj mpes, Dios ca mpjacam. Po ma tjowelé yupj jinwá, nun Dios lal welé na. ");
INSERT INTO jicNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Po ma yupj jinwá la müjí nun. Nun la moná secj p'in, Nupopay Dios selé tsjan nujos. ");
INSERT INTO jicNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ninana jin p'iyá tjowelé nun: ‘Qjuis Papay, tsjun po'o püt'. Po qjuisas pjü ca mvelecj jipj pajal 'üsüs. Jipj p'in 'üsüs pjü jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Qjuisas len̈ way Jepa nsem jipj pjü jis lal. Tsjun po'o patja lajay jipj jyas jinwá. Qjuisas wa ca nin nsem nosis casá. ");
INSERT INTO jicNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Qjuisas wa qjuesé 'an qjuis la las yacjaj. ");
INSERT INTO jicNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Malala nyuca la tjijicj, qjuisas perdonar la qjuesejay. Nin p'iyá perdonar lis tjijicj la p'a, malala la qjuis tjajay cupj. ");
INSERT INTO jicNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Qjuis capj tjep'ya'sa wa ma ca quelel malala la mijicj. Qjuis capj tjep'ya'sa diablo ma ca malala la qjuis mijis. Jipj p'in Jepa. Jipj pajal püné. 'Üsüs way p'in la veles jipj 'üsüs. Nin ca nsem lovin. Qjuisas ca nin nsem.’ ” Nin tjevele Jesús, cupj ca nin mvelecj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jupj tjevele wa: “Nun ca perdonar la müjí la p'a, yupj malala la tjajay na nun jis lal. Nin mpes 'üsüs la veles niná Dios lal. Nun perdonar lojí yupj, Nupopay Dios ca perdonar la mijis wa nun malala la tjüjí. ");
INSERT INTO jicNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nun ma quelel perdonar lojí yupj, Nupopay Dios ma ca perdonar la nu mijis wa nun”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesús tjevele wa niná: “Nepénowa ma jalá neneyawá, Dios lal quelel javelepj mpes. Newa ma lajay Dios jos jinwá. Yupj jisas la p'a ca jus nlayecj yupj ma jalá. Jisas wa la p'a yola yupj 'üsüs, ma jalá mpes. Nin mpes ma 'yas'ün̈, ma wa sey jacjoy. Niná p'in lajay, ma 'üsüs way yupj. Napj t'üc' way velé. Gente p'in ca mvelecj yupj 'üsüs way. Dios lovin ma ca mveles yupj 'üsüs way. Po ma la müjí yupj lajay jinwá. Nun ma lojá na, po ma nuwola je nu tapalas nun. ");
INSERT INTO jicNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nun ma lojá na, ca nusey ncjoyé wa, ca nuwola mpa'í wa. ");
INSERT INTO jicNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","La p'a ma ca jus nlayecj nun ma lojá. Nupopay Dios p'in ca jus nlayes. Jupj pjü way nyuca la p'a ma januc. Jupj ca nucus nun nin la tjüjí lyájasa way jin, ca mveles nun pajal 'üsüs la tjüjí”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús tjevele wa niná yupj jis lal: “Ma nujisas nsem pülücj nta'á nosis casá. Nun to'á nosis casá calatsa nlajas ca nacj. 'Ücj wa la majas. Pequepan ca jun ncjoltsecj, ca wama mal la pecj ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nin mpes más 'ücj 'üsüs lojí nun jis t'emel lal, Dios jos jinwá. Niná lojí, ca pajal pülücj nta'á Dios pü'ü nt'a. Ne'aj ma jalá calatsas. Ne'aj ma ca majas. Ne'aj ma wama jil ne'aj la pecj. ");
INSERT INTO jicNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Más 'ücj pülücj to'á Dios pü'ü nt'a. Nun pülücj to'á nt'a, ne'aj pajal 'üsüs ca nsem nun jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Nun jis jun jaw jinwá nun jis p'üy mpes. Nun jis jun 'üsüs, jas tüpwes 'üsüs way nucú. Nin p'iyá nun nusin 'yüsa na Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nun jis jun malala, jas tüpwes ma nucú. Pajal te ton̈ca p'in, ma nucú mpes. Nin p'iyá nun ma nusin 'yüsa na Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Nun ma polel lojí Dios jyü'ta jinwá, nun pajal t'emel nujos. Nin p'iyá mozo ma polel tsji' liji niyom mat'e mpes nin jawas p'in. Mozo ma ca quelel t'üc' la mijis jupj patrón pjaní tjijyü'ta jinwá. Ma'ajapj tjijyü'ta jin ca quelel la mijis ca nacj. Nenéyawa ca cus ncon̈cos mwalá way p'in. Ma ca jos ma'ajapj. Nin p'iyá nun ma polel pajal nin nujola t'emel mpes, Dios mpes tsji' lojí na. ");
INSERT INTO jicNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Nin mpes nin velé, po ma pajal nin nujola t'as tsjan ca nlajá, tsjan ca müsiqué wa 'ücj la püt'üs. Po ma pajal nin nujola t'as tsjan nusin nqui'pá nun jis pülül, nusin 'yawa. Dios la tjiji nu la püt'üs. Jupj ca nu ma'ayas wa nu la las. Dios la tjiji nun jis p'üy. Jupj nu ma'ayas wa ca pülül. ");
INSERT INTO jicNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tjunucú tsipyaya. Yupj ma jasin. Velan̈ ma jacutj. Ma jat' ja'onsopj chiquero mo'ó. Dios se 'aya jis la las. Jupj Nupopay tsjun po'ó. Nin mpes solejé Dios ca nu ma'ayas wa nujos jin. Nun más 'üsüs way tsipyaya jilal. ");
INSERT INTO jicNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ncu nun más 'in püs ca mpatjaqué, nin nujola mpes p'in? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”¿Tsjan mpes pajal nujola nupülül mpes? Tjunucú wa ts'utus witjacj. 'Üsüs way yustapj lejen̈, si t'ünǘ wa. Yupj ma tsji' lajay. Ma wa sa lul. ");
INSERT INTO jicNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Newa nin, tsjutsj ts'ituju más 'üsüs yustapj Salomón jas quip lal. Salomón jepa püné waytsja. Jas quip pülücj jaylactsja. 'Üsüs justa jas tücüi'pe. ");
INSERT INTO jicNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dios liji pajal 'üsüs yustapj tsjutsjum. Tsjutsj lejen̈ ca nacj yacjaj. Ya pwe ca nacj. Nun más 'üsüs tsjutsjum jis lal. Nin mpes ca jus nlayé Dios ca nu ma'ayas wa nusin quip. Nun 'ots'ots' way p'in poné Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nin mpes nin velé, po ma nin nujola t'as. Ma ca mvelé: ¿Tsjan ca nlajacj? ¿Tsjan ca müsiquecj? ¿Tsjan mpes ca qjuisin nqui'pacj? ");
INSERT INTO jicNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dios ma jisas nin yola 'oyn nyuca cüta'acj pjü way yupj jisas. Po ma yupj jinwá nujos t'as. Nupopay Dios selé nujisas niná. ");
INSERT INTO jicNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ninana p'in nujos t'as: nujos t'as nun ca nin la müjí Dios jyü'tá. Nujos t'as ca pjü mponé jupj lal. Nujos t'as ca 'üsüs way la müjí jupj jos jin. Nin lojí, Dios ca nu ma'ayas wa pjü way nun nujos. ");
INSERT INTO jicNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nin mpes po ma nujola t'as tsjan ca mpalas yayá. Yaya tjejyawca na 'ücj ca nin jele. Yacjaj malala pyala mpes p'in ca nin jele yacjaj. Ma nujola nsem p'a jawasa pyalá”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús tjevele wa: “Po ma tjowelé la p'a malala. Nun welé wa la p'a malala, Dios ca mveles wa malala nun. ");
INSERT INTO jicNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nin ca nsem, nun la p'a po'o welé jinwá, nin jinwá ca mveles Dios nun po'ó. Nun nujola jin p'iyá, nin p'in ca mveles Dios nun jis lal ncu t'üc' la tjüjí niná. ");
INSERT INTO jicNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","”¿Tsjan pjucj jele jetjam malala liji, ma nin jele más malala lejay jipj jupj lal? Nin p'iyá niná tsjan tsjicj way jetjam junma tjeyaca nyuc; yo püné jipj jinma tjeyaca ma nyuc. ");
INSERT INTO jicNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jetjam lal velen: ‘Natjam, ca ma'ayan tsjan tsjicj way jinma tjeyaca pje'á li ts'i’. Jipj ma nyuc yo püné jipj jin mo'ó. Nin p'iyá lejay jipj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jipj pajal malala, niná nin lejay na. Jipj malala wa, la p'a malala jinwá. Mya 'üsüs ca jipj. Po ma malala la mijin quinam, püna la tjejay jinwá. Niná la tjejay na, ca jus nlayen 'oyn nyuca ca cus mp'a'san la p'a wa”, nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jesús tjevele nepénowa la pjüts'ünpan Dios lal. Tjevele cupj ma ca mvelecj yupj jis lal Dios tjevelá. Ma wa ca nin mvelecj ts'a 'inpan jis lal. Yupj tsjiyó jinwá, tjevele. Malana jinwá yupj, tjevele jupj. Nun 'üsüs welé na, la mpjüts'ünücj ca la p'in. Pajal ts'i mi'inacj ca nun tjowelé mpes, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús tjevele wa: “Newa la moná Dios lal nun, ne jupj ca nu ma'ayas nun la tjomoná. Ma len̈ way nusé 'aya, newa la moná, ne jupj ca nu ma'ayas nun la tjomoná. Nun nujos Dios ca nucopj mp'a'sas, newa la moná Dios lal. Newa lo moná na, jupj ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nun lo moná Dios lal, nin ca nt'anqué. Nun lovin p'in lo moná, jupj ca nu ma'ayas. Nun newa lo moná Dios ca nucopj mp'a'sas, jupj ca nin la mijis nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”Nun ca jus nlayé niná. Nun popa pjaní jupj popa tsjicj ve le moná na, ma pe ca ma'ayas jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Cjul le moná na, ma ca ma'ayas lotsjim. ");
INSERT INTO jicNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nunpan malalapan, mop'in solejé 'oyn nyuca 'üsüs jis ma'ayá nun sin popa tsjictjacj. Nun jis Papay tsjun po'ó, 'üsüs way jupj, malala tulucj. Nin mpes ca jus nlayé jupj ca ma'ayas 'üsüs p'in, jupj lal la mon mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Nujisas ca la p'a 'üsüs la mijicj nun mpes. Lovin niná p'iyá la müjí yupj mpes. Ninana Moisés püna tepyaca. Niná profetapan püna tapac wa ncupj ca nin la mijicj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesús tjevele wa yupj jis lal: “Nin p'in la müjí napj velé jinwá. Niná napj velé jun vilicj la'í way jinwá, 'ücj la winin la püt'üs Dios lal. Costa tulucj 'awa püné nt'a la winin. Jun vilicj la püné jinwá ne'aj la winin. Jümücj pajal la püné jinwá. Pülücj jil ne'aj, pajal malala se palá nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nin tulucj Dios lal patja mpes. Jun vilicj tsjicj way jinwá ne'aj la winin, Dios lal la püt'üs. Jümücj la'í way jinwá. Pjaní way p'in jus nlayecj 'oyn nyuca la mijicj, mpatjam Dios lal.” ");
INSERT INTO jicNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesús tjevele wa niná: “'In tjajama. Nepénowa la tsuwil. Yupj javelepj Dios mpes javelepj. Dios mpes javelepj tulucj nepenowá. 'Üsüs jin javelepj yupj ca nacj, Dios po'o japon jinwá. Malala p'in yupj. Nun nuts'a'á jisas la p'in. Ts'isin̈ yupj pajal, coyote jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nun 'ücj wa jus nlayé ncu t'üc' way javelepj Dios mpes. Yupj lajay mpes ca jus nlayé. Nun nucú na wolas velan̈, nun jus nlayé ncu 'ücj lo las jupj wolas. Nun solejé jül ma 'anpüpj vyala. Tunun mwicj ma higo vyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jupj wolas 'ücj lo las, lovin nin p'iyá 'üsüs jupj. Jupj wolas ma polel lo las, lovin nin p'iyá malala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jupj wolas 'ücj lo las, ma ca wolas malala mvalas. Jupj wolas malala, ma ca nepénowa 'ücj lo las mvalas jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wolas ma polel lo las, nt'üjǘ, ca 'awa mo'o la nts'iyá. Nin lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nin p'iyá niná noyomes jis lal. Nun 'ücj wa ca nucú, ca jus nlayé ncu t'üc' way javelepj Dios mpes. Yupj lajay mpes p'in ca jus nlayé. ");
INSERT INTO jicNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Javelepj mpes p'in ma solejé ncu 'üsüs yupj. Nepénowa javelepj napj yupj jis Jepa Püné —tjevele jupj—. Newa nin, Dios yupj jis Jepa tulucj. Dios jos jin lajay, yupj p'in Dios si jütüta popa se palá. Dios napj Mpapay tsjun po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ts'ac' p'a wa napj ca mvelé pjacj 'üsüs, ca mvelé wa pjacj malala. Nin jawas ca pülücj way mvelecj napj lal: ‘Jipj p'iyá cupj qjuis Jepa. Cupj jipj mpes tsji' la tjijicj. Tjevelecj Dios mpes jipj jyas jinwá. Tjijyü'tücj tjil lapanenpan gente jisas mpe. Pajal 'üsüs la tjijicj wa, gente p'in ma polel lajay jinwá. Ninana la tjijicj la p'a ca nucucj, ca sin mü'üsüs Dios pajal püné. Pjü way la tjijicj jipj mpes.’ Nin ca mvelecj nepenowá. Newa ma la tjajay Dios jos jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mpes nin javelepj na, napj tülü way ca mvelé yupj jis lal: ‘Nun lovin ma ncapj tocon̈có. Lowa napj mpe. Nun pjü way malala nyuca lojí.’ Nin ca mvelé yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”Nepénowa tjepjyacan̈ napj tjevelé, ne nin lajay napj tjevelé jin. Yom 'üsüs jas tjijyünsa wosis jin p'iyá yupj. 'Üsüs p'in jólatsja jupj. Pajal campwila tsjomis tyoca mwalá way p'in, pwen já'asa na tyoca nas. ");
INSERT INTO jicNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","T'üc' wo jas tjijyünsa na, pajal püné tjive. 'Üsǘ püné t'yüna wa. Pajal yümücj way jas tjelyapjünǘ lüpjǘ 'ots'ipj jupj wo nt'a. Newa ma tyüla wosis, tsjomis campwila ton̈ca mpes, pwen já'asa nas. Nin p'iyá napj jyütütj jinwá lajay jis lal. Newa ca 'ücj mpatjam yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nin tulucj la p'a jis lal. Yupj tjepjyacan̈ watsja napj tjevelé. Mop'in ma la tjajay napj tjevelé jin. P'a yom wo jas tjijyünsa jinwá yupj. Ma jola jintsja, mpes jupj ma tyoca tsjomis. 'Amá casá jas tjijyünsa jupj la p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","T'üc' wo jas tjijyünsa na, pajal yümücj tjive. 'Üsǘ t'yüna. Pajal lüpjǘ jas tjelyapjünǘ watsja ne'aj, jupj wo nt'a. Mpes tyüla wa wosis. Pajal yümücj pjac tyüla. Nin p'iyá ca malala jis mpalas yupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús tecyawaja tjevele quinam jupj quelel véletsja. Jupj tjevele tjepjyacan̈ yólatsja jupj pajal 'üsüs sin tji'yüsa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús Moisés popel sin 'yüsa lajay jin tuluctsja. 'Ücj jis la jütütj jinwá tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús tecyawaja sin 'yüsa lis tjiji na, tucuc' mpe palavin tjac'. Pajal pülücj jupj cjüil tjil. Quelel jiltsja Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yom pjaní Jesús nt'a tjac'. Tüic' jin tjá'asa Jesús wolap'a'á. Malala jostsja pajal. Jupj jüp'üy pajal tjamájatsja lovin. Palá tinca jüp'üy popé. Jupj tjevele Jesús lal: —Nejepa, jipj polel ni 'ü'sa lejay. Jipj jyas na ca nin nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mpes Jesús pjwel la tepyacta, po la tje'yot'a yom malala jos. Tjevele: —Najas. 'I tjü'ü'süs quinam. Ninana tjevele na, len̈ way tji'yü'sa niná yomen. Jüp'üy 'üsüs way tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yom tji'yü'sa na, Jesús tjevele jupj lal: —Po ma tjevele la p'a lal quinam jipj 'i tjü'ü'sa. Jutja sacerdote nt'a. Ca jis nucus. Jupj ca la mpalas ncu malala lo nuc p'yüy po'ó. Ca mveles 'üsüs quinam. Niná la tjejay na, Dios mpes ma'ayan, jipj 'i tjü'ü'sa mpes. Pajal püna Moisés tjijyü'ta tsjan ca ma'ayacj, jis p'üy jis tji'yü'sa na. Jupj tjijyü'ta jin ca la mijin. Pjü la tjejay na, la p'a ca jus nlayecj jipj t'üc' way 'i tjü'ü'sa quinam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum nt'a tjemey Jesús. Ne'as tjemey na, jepa militar tjac' jupj nt'a. Jepa militar israelpan popa tuluctsja. Militar romano waytsja. Jépatsja jupj niyom cien jis lal. Jupj tjac' na, la tjemyona Jesús lal jupj ca mü'ü'süs la mijis jupj jomozo. ");
INSERT INTO jicNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jupj tjevele: —Namozo pajal lapj jos. Pü'ü p'in, ma polel 'utaná. Pajal nepé vyaja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús tjevele jupj lal: —Napj p'iyá ca mis, mü'ü'süs la mejay jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jepa militar tjevele Jesús lal: —Pajal 'üsüs way jipj. Napj 'üsüs tulucj. Más 'ücj ma nawá mo'o cuy jipj. Más 'ücj jipj ca müjü'tün ca mü'ü'süs jupj la p'in. Napj selé jipj nin la tjejay na, ca mü'ü'süs jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Napj selé jipj 'ücj jyütütj. Nin p'iyá napj nejepa ni jütüta. Napj lejay jupj vele jin. Napj jyütütj wa niyom militar pajal pülücj. Pjaní lal velé jutja, mpes jama jupj. P'a lal velé was, mpes jac'. Namozo lal velé nin la mijis, mpes nin liji jupj —nin tjevele jepa militar. ");
INSERT INTO jicNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús nin tjapjaca na, jupj jólatsja pajal 'üsüs tjevele jepa militar. Mpes Jesús tjevele jupj cjüil tjil jis lal: —Pajal 'üsüs pyona jupj, jupj ne israelpan popa tulucj. Newa ma tjinyuc Israel mpe 'esepj pajal tepyona jupj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pülücj israelpan tulucj ca mpatjam wa Dios jyü'ta nt'a. Pjü jun ta'á mpe ca ncul. Ca majatjum, ca nlajacj Abraham lal, Isaac lal wa, Jacob lal wa. T'üc' way nin ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dios jostsja pjü israelpan ca ne'aj mpatjam jupj jyü'ta nt'a, mop'in ma ca ne'aj mpatjam nepenowá. Israelpan pülücj ca pje'á lis ncoyes pajal püste nt'a. Ne'aj ca pajal la mpuyucj. Jis wis ca jas nqui'licj pajal nepé vyaja mpes —nin tjevele Jesús israelpan mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jupj tjevele wa jepa militar lal: —'Ücj la winin quinam. Jipj tepyon jinwá ca nsem. Jesús nin tjevele na, tji'yǘ'satsja jepa militar jomozo. ");
INSERT INTO jicNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedro wo nt'a tjemey Jesús. Jesús wama tjemey jupj wo mo'ó, jus tjinyuca Pedro pwisam. Pǘ'ütsja jupj, malala jostsja mpes. Si 'áwatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús jupj mos po la tje'yot'a. Po la tje'yot'a na, tji'yü'sa jupj. Len̈ way jas tjijyünsa. Tje'yaya Jesús la las. 'Üsüs tji'yü'sa quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","T'yaja na, la p'a wa malala jisas tucuman Jesús nt'a. Lapanenpan pátjatsja yupj jisas mo'ó. Jupj pje'á sin tjejyama lapanenpan. Tjil yupj jupj tjevele mpes p'in. Pjü malala jisas jis tji'yü'sa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nin la tjiji mpes, t'üc' la tjiji Isaías tjevelá pajal püna. Isaías profétatsja jupj. Dios mpes tjevele. Niná Isaías tjevelá Jesús mpes: “Jupj qjuis tji'yü'sa la qjuis tjiji cupj, malala qjuisastsja mpes. Jupj p'iyá 'aplijílatsja cupj 'aplijílatsja mpes.” ");
INSERT INTO jicNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús yus tjinyuca pajal pülücj 'a jis tjimyula jupj nt'a. Mpes jupj discipulopan jis tjijyü'ta ca mal 'üsǘ na'aj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Custjay ma tjil na, yom p'a wa tjac' Jesús nt'a. Moisés popel sin 'yüsa lajay pópatsja jupj. Jupj tjevele Jesús lal: —Gente sin 'yüsa lejay jipj. Napj ca cyapj ncon̈ jun ta'á jipj quelel jay nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús tjevele costa way cus la con̈ jupj. Tjevele: —Gato selván yupj jis jomwen jul jinan̈, tsipyaya yupj jis tsintsil jatatj wa. Nin tulucj napj lal. Napj nawá cjuwá. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","P'a wa yom Jesús discípulo watsja. Jupj tjevele Jesús lal jupj quelel se cón̈catsja jupj p'a jyawca na. —Ntje'aya la nuc mpa'is mpapay p'in. Tepe'e na, ca cyapj ncon̈ —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús tjevele ma polel li nucú cus la con̈. Tjevele: —Ncapj tecyon̈ca quinam. La p'a wa 'ücj 'amá jis la toc jis pülücj tepe'e na. Yupj p'iyá tecya'lin̈ jinwá, yupj Dios lal ma japon mpes —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús barco mo'o wama tjemey. Jupj discipulopan wama tjil wa. 'Üsǘ na'aj po'o jil watsja yupj. Pajal la pünetsja 'üsǘ, pajal campwila watsja. ");
INSERT INTO jicNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Len̈ way pajal jas tjelyapjünǘ lüpjüs 'üsǘ püné nt'a. 'Üsǘ pajal la tjepjetpjets'é. 'Üsǘ barco wama tjemey, quelel pít'atsja barcas. Jesús nasa tjejyá. Newa tjejyatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mpes jupj discipulopan jupj nt'a tjil, jas tiquilquil, ne jola tepyala. Tjowelepj: —Qjuis capj tjep'ya'sa, qjuis Jepa. Qjuis qjues nt'ancam. ");
INSERT INTO jicNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús tjevele yupj jis lal: —'Ots'ots' way p'in poné nun napj lal. ¿Tsjan mpes locj jeyá? —tjevele. Jas nisa jupj. Cus tjeve'le lüpjǘ, cus tjeve'le wa 'üsǘ. Mpes lüpjǘ 'üt'ün nasa tepyala. 'Üsǘ 'üt'ün nasa wa. ");
INSERT INTO jicNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Niyom yólatsja jupj pajal 'üsüs la tjiji, pajal püné jupj. Yuwá tjowelepj: “¡T'üc' way yom niná pasal püné way! 'Ücj si jütüta lüpjǘ, 'üsǘ 'ots'ipj, ne nin lajay wa jupj jyü'ta jin.” ");
INSERT INTO jicNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ne'as tjemey 'üsǘ na'aj po'ó. Jesús tjemey nt'a Gadara lotsja. Ne'as tjemey na, niyom mat'e tjiquil la nyüjüsün̈ jupj. Panteón mpe tjiquil yupj ne'aj. Janucun waytsja yupj, nin p'in lapanenpan jisas mo'o tapatja yupj. Pajal ts'a 'intsja yupj, mpes la p'a wa ma polel jiltsja ne'aj, yupj tjelyawun̈ nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yupj Jesús jus tjunuc na, pajal yümücj la tupuyupj: —¿Tsjan mpes tjacuy quinam cupj nt'a? Jipj Dios Jatjam. ¿Ncu ca malala la qjuis mijin? Nin jawas jyawca tulucj nin la mijin mpes —nin tjowelepj yupj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ne'aj way p'in 'in malana pajal pülücj tjelyawun̈, jalatsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lapanenpan pajal la tjomon Jesús lal: —Jipj ca müjü'tün ca nlaca ncupj ca nacj. Qjuisas jyütütj ca nlaca malana jisas mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús tjevele lapanenpan jis lal: —Lowa nepé. Mpes pje'á tjil niyom jisas mpe. Malana jisas mo'o tjil. Jisas mo'o tjil na, malana pjü ts'equenen̈ neven palavin, 'üsǘ püné mo'o tjil yupj. Jis qjues t'anca, tecya'lin̈ pjü. ");
INSERT INTO jicNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Niyom malana jajamapj tjunuc nin tepyalá, ts'equenen̈ yupj pülücj patja nt'a. Pjü tjowelepj Jesús la tjijá. Niyom po'o tjowelepj wa, yupj ne lapanenpan jisas mo'o tapatja püna p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mpes pjü way tjiquil la nyüjüsün̈ Jesús. Pues pjü way pülücj patja mpe tjiquil. Jus tjunuc na, pajal la tjomon Jesús lal jupj ca mim yupj mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús niswa wama tjemey barco mo'ó. 'Üsǘ na'aj po'o tjemey jupj, püna tüpü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne'as tjemey na, niyom nepenowá tjiquil jupj nt'a. Malala jos tucuman hamaca lal. Malala jos ma polel 'utanatsja. Yupj topon Jesús 'ücj la qjuijis lo 'ü'süs jupj. Jesús jus nleya yupj topon, ne jupj tjevele malala jos lal: —Ma nin jele t'as. Jin tjiyocj wa ca nsem. Napj perdonar la 'ejay malala la tjejay Dios lal. Ma nin nola quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ne'aj játjatsja noyomes Moisés popel sin 'yüsa lajay. Yupj ma jisastsja Jesús tjevelá. Yupj yólatsja Jesús tjevele pajal malala. Dios p'in 'ücj nin vele, yólatsja. ");
INSERT INTO jicNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús seletsja nin yólatsja yupj. Jupj tjevele yupj jis lal: —¿Tsjan mpes pajal malala nyuca nujola nun? ");
INSERT INTO jicNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Napj 'ücj velé: ‘Napj perdonar la 'ejay jipj malala la tjejay Dios lal’. Napj 'ücj wa velé: ‘Jin tjijyünsa, mim’. ¿Cana más 'in costa la veles? ");
INSERT INTO jicNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nin p'iyá ca mvelé wa malala jos lal, mpes nun ca jus nlayé napj 'ücj perdonar lejay nosis nt'a. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. Jupj tjevele wa malala jos lal: —Jin tjijyünsa. Jipj hamaca nt'ya, nt'an. Ca mim wya nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Len̈ way jas nisa malala jos. 'Ücj jostsja quinam. Tjemey wo nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pülücj way tjunuc niná nin tepyalá. Tjunuc na pajal 'üsüs yola tepyala Jesús la tjiji mpes. Nin mpes 'üsüs tjowelepj Dios po'ó. Dios tje'yaya yom pjaní 'ücj la tjiji niná, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús tjemey nepé. Jupj jámatsja na, jupj tjinyuca yomen. Yom niná impuesto jaylacj t'e'éncatsja jepa mpes. Wa nt'a t'emel t'e'éncatsja nt'a já'asatsja jupj. Niná yom Mateo lotsja jupj. Jesús tjevele jupj lal: “Ncapj tecyon̈ca jipj. Najas ncapj cyon̈ lovin.” Len̈ way jas tjijyünsa Mateo, cus tecyon̈ca jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Locopyaya Jesús Mateo wo nt'a já'asatsja. Ne'aj lyájatsja t'awaná jupj discipulopan jis lal. Ne'aj tjiquil wa, tjalá watsja niyom pülücj. Nepénowa impuesto jata'epj tapatja Mateo jinwá. Yupj pequen̈tsja püna p'in. P'a witjacj ma t'üc' la tjajay Moisés popel tjijyü'ta jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseopan tjunuc Jesús já'asatsja yupj jis lal, lyaja watsja yupj jis lal. Mpes yupj jis la tjü'üy Jesús discipulopan jis lal: —¿Tsjan mpes lyaja nujepa impuesto jata'epj jis lal, malala lajay jis lal wa? ");
INSERT INTO jicNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús tjapjaca yupj jis la tjü'üy. Mpes jupj tjevele yupj jis lal jupj quelel se p'á'satsja malala lajay. Tjevele: —'Ücj jisas ma jisas la p'a si ts'ucú. Malala jisas p'in jisas niná. Napj si ts'uc jinwá lejay malala lajay jis lal, ne yupj ca cü'ü'süs quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nun ma nusin 'yüsa tsjan jos Dios. Dios tjevele jupj Popel mo'ó: ‘Napj najas la p'a quelel la sojí nun. Najas jis capj mp'a'sá la p'a wa. Niná lojí más 'üsüs Dios mpes 'oyá lal.’ Lowa nun, nusin tjü'üsüs tsjan mpes nin tjevele Dios. Napj niná nin lejay Dios jos jinwá. Napj tjacuwis la veles malala lajay jis lal. Napj velé yupj jis lal Dios jos yupj 'aplijila nsem malala nyuca la tjajay mpes. Dios jos 'üsüs la mijicj quinam jupj jos jinwá. La p'a wa 'üsüs lajay Dios jos jin. Niná napj ma velé yupj jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Locopyaya Juan discipulopan tjiquil Jesús nt'a. Juan bautizar liji watsja püná. Jupj discipulopan tjowelepj Jesús lal: —Nenéyawa ma lyajacj cupj, quelel velecj p'in Dios lal. Nin p'iyá fariseopan ma jalá wa neneyawá, quelel javelepj p'in Dios lal. ¿Tsjan mpes ma nin lajay jipj discipulopan, Dios lal la veles? ");
INSERT INTO jicNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús tjevele jupj discipulopan ma nin lajaytsja custjay. P'a jyawca na ca nin la mijicj. Ninana tjevelá: —Nin jawas yom judío woya na, jupj jomicapan jiquil wa cus la con̈ jupj. Pajal 'ücj jisas jatja; ma la puyupj yupj. Nin p'iyá napj discipulopan jis lal. Napj yupj jis lal 'os. 'Ücj javelepj napj lal. Nin mpes 'ücj jisas jatja yupj. 'Ücj yupj jalá. P'a jyawca na, p'a casá ca nsem. La p'a ca ncul, ca ma tjililin̈. Len̈ ca nsem napj. Nin tepyala na, napj discipulopan ma ca nlajacj neneyawá, ca mvelecj p'in Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jupj tjevele wa jupj lal japon ma polel nin p'iyá jis la jay püna tapatja la tjajay jinwá. —Nin p'iyá ma polel jul sa lul jis pülül pül pülül seyasa mpes —tjevele—. Nin lajay na, pülül seyasa la'í pyala. Mpes pülül pül way ca la ntsü'üm, ca püné way la jul nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nin p'iyá wa, judiopan uva 'üsǘ seyasa jatatj na. Uva 'üsǘ seyasa ma ca mo'o nt'ucj pjoloc' pül way mo'ó. Nin lajay niná, pjoloc' pül ca mpjoltem 'üsǘ myolca mpes. Tjopjolta na, uva 'üsǘ ca jus ncocom. Malala ca mpalas wa pjoloc'. Nin mpes ma lajay niná. Uva 'üsǘ seyasa jatatj na, pjoloc' seyasa mo'o ca nt'ucj. Nin mpes ma ca malala mpalas uva 'üsǘ, ma wa ca malala mpalas pjoloc' —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús newa véletsja na yupj jis lal, yom p'a wa tjac' yupj nt'a. Yom niná jepapan pópatsja judiopan 'a si mulú nt'a. Tjac' Jesús wolap'a'á, tüic' jin tón̈catsja. Yom niná tjevele: —Ncucus yas way tepe'e. Was nawá nt'a. Najas po la mo'ot'en ncucus, ca jupj mpü'üm. ");
INSERT INTO jicNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mpes Jesús tjemey jupj lal. Jesús discipulopan tjil wa Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jiltsja na, quepj pjaní Jesús cjüil tjac'. Quepj niná po la tje'yot'a Jesús jas quip, tsjan po velan̈ mpes. Malala jostsja, ne nin la tjiji jupj. Año dóceya newa 'os tepyálatsja, ma tji'yü'sa. ");
INSERT INTO jicNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jupj jólatsja: “Jesús jas quip po le 'otj p'in, ma 'ü'süs ca napj”. ");
INSERT INTO jicNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jupj po la tje'yot'a na, Jesús la nujuya, jus tjinyuca quepan. Tjevele jupj lal: —Ma nin jele t'as, Ncucus. Jipj tepyon napj polel 'i 'ü'sa lejay, nin mpes 'i tjü'ü'sa jipj. Jesús nin tjevele na, tji'yü'sa quepan. ");
INSERT INTO jicNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Locopyaya Jesús judiopan jis jepa wo nt'a tjemey, jupj jámatsja nt'a. Nasa pülücj 'a jis tjimyula jupj wo nt'a, jupj jucucus tepe'e mpes. Nepénowa jis flauta la tjupjus. Nepénowa pajal yümücj la tupuyupj. Jesús yus tjinyuca, ");
INSERT INTO jicNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tjevele: —Lowa, nun pjü way. Tsjicj tepe'e tulucj. Tjejyá p'in. Jesús seletsja jupj ca 'yü'sa la mijis, mpes nin tjevele. Yupj ma topon. Tjuwi'in̈ p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús pjü pje'á sin tjejyama. Tjil na, tsjicj tüpü'ü nt'a tjemey, mos ntjüi'le jupj. Nin la tjiji na, jas tjijyünsa tepe'á. Nyucunutsja jupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne'aj way tapatjá pjü jis wala tjowelepj ninana tepyalá. Mpes pjü ne'aj jus nlay Jesús la tjiji niná. ");
INSERT INTO jicNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús judiopan jis jepa wo mpe tjemey quinam. Tjemey na, niyom mat'e cjüil tjil wa. Manas yun tuluctsja yupj. Yupj la tupuyupj: —Qjuis capj tjep'ya'sa. Jipj niná Yomen Dios jas tjejyama qjuis capj la p'acj. Jipj David popa p'iyá, locopyaya tüpüt' —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús wama tjemey na, niyom yun tulucj wama tjil wa. Yupj tjiquil Jesús nt'a. Jupj jis la tji'yüya: —¿Ncu poné nun napj polel nu 'yü'sa lejay nuyun? —Nin pyonecj —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús jis yun po la tje'yot'a. Tjevele: —Nun poné jinwá nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Len̈ way 'ücj januctsja yupj, jis tji'yü'sa. Locopyaya Jesús tülü way jis tjijyü'ta ma nin mvelecj 'oyn nyuca jis tji'yü'sa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mop'in ma la tjajay Jesús tjevele jinwá. Tjil na, pjü jis lal tjowelepj niná Jesús la tjiji yupj mpes. Mpes pjü ne'aj way p'in tapatja, pjü tjepjyacan̈ niná tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Noyomes püna yun tuluctsja pje'á tjil na, la p'a wa noyomes tjiquil wa Jesús nt'a. Yom ma polel vele lal tjiquiltsja yupj. Lapanen pǘ'ütsja jupj jos mo'ó. Nin mpes ma polel véletsja. ");
INSERT INTO jicNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús pje'á jas tjejyama lapanen. Nin la tjiji na, 'ücj véletsja yomen. La p'a wa tjepjyacan̈ niná tepyalá. Tjepjyacan̈ na, yupj yólatsja Jesús pajal 'üsüs la tjiji. Tjowelepj: “Lovin ma tjinyucuctsja niná Israel mo'ó”. ");
INSERT INTO jicNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Newa fariseopan ma 'üsüs tjowelepj Jesús po'ó. Yupj javeleptsja: “Lapanenpan jis jepa se p'a'sa Jesús. Nin mpes 'ücj pje'á sin jyama lapanenpan.” ");
INSERT INTO jicNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús jun ta'á tjuwine Galilea mo'ó. Pjaní pjaní tjemey pülücj patja nt'a, pjaní way p'in patja nt'a 'ots'ipj. Jupj tjemey nt'a sin tji'yüsa lis tjiji lovin judiopan 'a jis tjimyula nt'a. Pjü jis wala tjevele pajal 'üsüs tepyala Dios mpes. Tjevele quina ca jis müjü'tüs Dios. La talata malala jos, jupj tji'yü'sa la tjiji wa. Pajal sin napnapj jin jisastsja jis tji'yü'sa lis tjiji wa pjü. ");
INSERT INTO jicNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jupj gente pülücj yus tjinyuca na, pajal jólatsja yupj mpes. Oveja yusapj jinwá yupj, jólatsja Jesús. Len̈tsja pjacj jis cüjamas. Lapj nyuca yólatsja yupj lovin. Ma polel jis capj tjep'ya'sa yupj p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mpes Jesús tjevele jupj discipulopan jis lal: “Pajal pülücj ma sa con̈ Dios custjay. 'Ücj wa Dios jatjampan jis la pal yupj. Pülücj velan̈ jinwá yupj napj lal. Mop'in namozopan pjaní way p'in, ca jis lal ncul pjü. ");
INSERT INTO jicNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mpes la tjomoná nun Dios lal mozopan pülücj ca sin majamas yupj nt'a. Jupj p'iyá jyü'ta jupj mozopan. La tjomoná pülücj jilal ca mvelecj yupj napj mpes. Nin mpes ca pülücj mponecj napj lal, ca Dios jatjampan jis mpalas”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús discipulopan dóceya jilal tjevele jis la cuwis. Jupj lis tjiji jupj apostolpan yupj. Tjevele ca p'a nt'a mal, ca tsji' la mijicj jupj mpes. Jupj jis tje'yaya 'ücj pje'á la nts'iyacj lapanenpan. Jis tje'yaya wa 'ücj jis mü'ü'süs la mijicj ca pjü malala jisas. Pjü sin napnapj witjacj, pjü 'ücj ca jis mü'ü'süs la mijicj wa. ");
INSERT INTO jicNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ninana apostolpan jis lá: mwalá way Simón lotsja. Pedro ló watsja jupj. Jupj tsüipe Andrés apóstol watsja. Jacobo pjaní watsja. Jupj tsüipe Juan pjaní watsja. Yupj ne Zebedeo jatjampan. ");
INSERT INTO jicNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe apóstol watsja, Bartolomé pjaní watsja; Tomás pjaní watsja jupj. Mateo pjaní wa. Jupj impuesto jaylacj t'e'enca watsja püna. Jacobo apóstol watsja jupj, jupj ne Alfeo jatjam. Tadeo pjaní watsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón p'a watsja. Simón le palánatsja jepa lal, jepa israelpan popa tulucj, ne nin. Nin mpes “Israel Mpes Jola” lotsja wa jupj. Judas Iscariote apóstol watsja. Jupj Jesús enemigo tepyala. Jis capj tjep'ya'sa Jesús enemigopan jis la tjilil jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús sin tjejyama niyom nenem, tsji' lajay jupj mpes. Jupj jis lal tjevele wa 'oyn nyuca la mijicj tjil na. Ninana Jesús tjevele yupj jis lal: “Po ma nlawú judiopan tulucj nt'a —tjevele jupj—. Ma wa nlawú Samaria mo'o patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cupj nepé nt'a nlawú p'in, israelpan nt'a p'in. Yupj ma sa con̈ Dios. Oveja len̈ jis tjevyala jinwá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","”Nun lowú na, pjü jis lal tjowelé Dios ca Jepa ma'ajam yupj nt'a quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Malala jisas jis mü'ü'süs lis müjí wa. Tecya'lin̈ sin müjünsǘ, ne yupj ca mpatjam. Jis mü'ü'süs lis müjí wa jis p'üy tjamaja. Pje'á sin majamá wa lapanenpan. Ma la moná nun lojí mpes. Nun ma jaylacj la tjüjí napj la tjejay nun mpes. Así 'üsüs la müjí wa la p'a mpes. Jaylacj tulucj 'ücj ca nsem.” ");
INSERT INTO jicNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jesús tjevele wa sin tjejyama jis lal: “Nun nasa lowú tsji' lojí napj mpes, ma ca nt'a nun p'a jawasa nujisas mpes. Ma t'emel t'o nun. ");
INSERT INTO jicNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Po ma ve t'o, yacjaya nu lo las. Ma ca mát'eya nusin nqui'pá nlawú. Ma ca p'a wa nt'a p'a wa caite. Ma wa ca nt'a tjacjaj. Nun lowú nt'a, ne'aj nun ca 'üsüs la müjí yupj mpes. Mpes más 'ücj yupj nu ma'ayacj nujisas. ");
INSERT INTO jicNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","”Nun pülücj patja nt'a ca nlawú neneyawá. Más 'in la' way patja nt'a ca nlawú neneyawá. Nun lowú nt'a, yom 'üsüs way ca la mpalá nun ne'aj. Jupj lal ca la moná ca jupj lal mpatjaqué. Ne'aj potjaqué na p'in pülücj way patja nt'a, lovin ca ne'aj mpatjaqué jupj wo nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nun wama lowú na, niná yom wo mo'ó, tjowelé nujisas jupj wo nt'a patja ma yola nsem pjü mpes Dios 'üsüs la siji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yupj 'üsüs jisas nsem nun napj mpes tsji' lojí ca nacj. Nin mpes nin ca nsem nun tjowelé jin p'iyá. Nepénowa nun lowú nt'a ma ca jisas nsem nun tsji' lojí napj mpes. Ma ca 'üsüs jis mpalas nun tjowelé mpes. Nun p'in 'üsüs mpatjaqué nun tjowelé jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nepénowa ma ca jisas nsem nun tjuculá. Ma ca jisas nsem nun welé napj mpes. Nenéyawa nin ca nsem wa pjaní nt'a. Nenéyawa nin ca nsem pülücj patja nt'a. Mpes lowa yupj mpe. Nun lowú na nepé, nun jis tsjom sin tjowowojó, ca palá ntüncüs pjüpjüs. Nin mpes ca sin 'yüsa lis müjí Dios ma japon jinwá yupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dios ca pajal jis capj ntülüs, malala lajay jis capj tyüla na. Más ca jis capj ntülüs yupj, Sodoma nt'a tapatja jis lal. Más ca jis capj ntülüs yupj, Gomorra nt'a tapatja jis lal. Nin ca la mijis Dios ne'aj patja jis lal, yupj ma quelel pjyacan̈tsja mpes. Niná t'üc' way”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús tjevele wa niná jupj sin tjejyama jis lal: “Napj p'iyá nusin jyam malala witjacj nt'a. Napj selé nun ma polel nucopj p'o'sá nun p'iyá, yupj malala lajay na nun jis lal. Nun oveja jinwá. Yupj pü'á jinwá. Pajal ts'a 'in yupj. Mpes 'üsüs tjajamá nun p'iyá latsj jinwá, mop'in nin, ca 'üsüs la müjí lovin sipipj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","'In tjajama gente jis lal. Nepénowa ca nu ntji'lin̈ nun. Ca nu manucj jepapan nt'a, nucopj la tül. Mo'o ca nsüpücj nun judiopan 'a si mulú nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jepapan nt'a ca nu manucj nun ncapj con̈có mpes. Ne'aj p'in se jütütj nt'a ca nu manucj. Jepa noypan nt'a ca nu manucj wa. Nin lajay na, nun ca 'ücj mvelé yupj jis lal 'onin ne 'ücj potjaqué Dios lal napj mpes. Nin ca mvelé wa judiopan tulucj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","T'üc' way ca nu ntji'lin̈, ca nu manucj jepapan nt'a. Nin lajay na, po ma malala nyuca nujola t'as tsjan ca mvelé nun yupj jis lal. Dios Cjües ca nusin mü'üsüs la mijis tsjan ca mvelé nin tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nun ma ca cüwelé nun nujola jin. Nun welé na, Dios Cjües jos jin ca mvelé. Mpes nun welé na, Dios Cjües p'iyá ca mveles yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Ne'aj patja nun jis enemigopan ca nsem neneyawá, nun ncapj con̈có mpes. Nepénowa malala ca mvelecj jis pülücpan sin po'ó, mpes jepapan ca jis mü'ü'nacj yupj jis pülücpan. Nepénowa ca malala mvelecj wa sejatjampan sin po'ó. Ca jisas wa nsem jis la 'ünan yupj. Nepénowa ca ts'i mi'inacj jis papay lal, sejamay lal wa. Ca malala mvelecj yupj sin po'ó jepapan jis lal. Mpes ca jis mü'ü'nacj jis papay, sejamay wa. Nin ca la mijicj ncapj jacon̈ jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pjü ma ca jisas nsem nun, nun napj nats'a'á mpes. Po ma nin nujola t'as. Nun poné napj mpes lovin, nun ca 'ücj mpatjaqué Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Malala la nusejay na jun pjaní nt'a, nun ca ts'üequenequé p'a nt'a. Nun ma ca jun ta'á tjalawú custjay israelpan patja nt'a, napj niswa tjacuwis na. Napj p'iyá niná Yomen Dios jas tjejyamá. Niná t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Malala la ntjajay wa napj, ca nin wa la mijicj nun jis lal. Nun nusin tji'yüsa napj lal. Jupj jas tji'yüsa püné tulucj sin 'yüsa la siji lal. Nun tsji' lojí napj mpes. Mozopan noypan tulucj yupj jis jepa lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mpes 'ücj nin la pal sin 'yüsa la siji lal, 'ücj wa nin p'iyá jis la pal sin 'yüsa jis lal. 'Ücj malala pyala jis jepa, 'ücj wa malala se palá jupj jomozopan. Malala tjowelepj napj nin po'ó. Tjowelepj napj p'iyá Beelzebú, jupj ne lapanenpan jis jepa. Nun napj mpülücpan. Mpes ca jus nlayé yupj más malala ca mvelecj nun po'ó napj lal tjowelepj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Nin mpes nin velé: po ma locj tjeyá malala lajay jis lal. Tsjan cus tüpwijitj, tjapjalen, cus ncjoltses ca. Püna tjapjalen la p'a ca jus nucucj. ");
INSERT INTO jicNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Napj velé nun jis lal la p'a wa ma pjyacan̈ nt'a. Ninana tjowelé pjü pjyacan̈ nt'a. Napj velé nun jis lal nusapj p'in. Ninana tjowelé pjü jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ca nacj nepena ca quelel nu mü'ü'nacj nun, napj mpes welé mpes. Po ma locj tjeyá yupj jis lal. Lovin ma polel nu mü'ü'nacj nun jis qjues. Pjaní lal p'in locj tjeyá. Locj tjeyá Dios lal. Jupj 'ücj jis capj tyüla malala lajay 'awa püné nt'a. Ne'aj pjü malala se palá jis p'üy, jis qjues malala se palá wa. ");
INSERT INTO jicNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”Po ma locj tjeyá p'a mpes. Dios nusé jamá. Dios se jamá tsipyaya tsjictjacj. Tsipyaya ma ca palá nyacas, mpa'is, Dios ma jos na p'in. Tsipyaya pajal tsjictjacj. Tsipyaya mat'e, centavo pjaní jaylacj. Dios Nupopay. Más quelel la nusiji nun tsipyaya jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dios selé nol jatja nuts'üil. Pajal 'üsüs nusé jamá nun. ");
INSERT INTO jicNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mpes po ma locj tjeyá. Nun más 'üsüs tsipyaya pülücj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”Nun welé la p'a jis lal nun ncapj con̈có, napj ca nin p'iyá mvelé wa Mpapay lal tsjun po'ó. Ca mvelé wa napj nucopj cyon̈. ");
INSERT INTO jicNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nun welé la p'a jis lal nun ma ncapj con̈có, napj ca nin p'iyá mvelé wa Mpapay lal tsjun po'ó. Ca mvelé wa napj ma nucopj cyon̈. Po ma locj tjeyá la p'a jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”¿Ncu nujola napj lejay pjü way nin p'iyá yola nosis nt'a? Nin tulucj. Ma ca nin p'iyá yola napj mpes. Ca la mpa'nacj napj mpes. Nin ca mpalas napj tjacuwis mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Niyom nepenowá ca ts'i mi'inacj jis papay lal, jis papay napj lal pyona mpes. Nequem nepenowá ca ts'i mi'inacj sejamay lal, sejamay napj lal pyona mpes. Nequem nepenowá ca ts'i mi'inacj jis pisam jis lal, jis pisam napj lal pyona mpes.’ Nin ca mpalas napj tjacuwis mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","‘Jis wa nt'a patja jis enemigopan ca nsem.’ Nin ca nsem napj lal japon jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","”Najas yupj más quelel la najay pjü jis lal. Pajal quelel lajay jis papay, sejamay, ne napj 'ots'ots' way p'in quelel la najay, ma polel ncapj jacon̈. Pajal quelel lajay sejatjampan, jis jucucuspan, napj 'ots'ots' way p'in quelel la najay, ma polel ncapj jacon̈. ");
INSERT INTO jicNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma jisas malala se palá, ma wa polel ncapj jacon̈ yupj. Najas yupj nin p'iyá lajay napj lejay jinwá. 'Ücj napj lal malala ne palá. 'Ücj napj lal ni pü'í cruz po'ó. Yupj ma quelel lajay napj lejay jinwá, ma polel ncapj jacon̈. ");
INSERT INTO jicNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pajal nin yólatsja 'onin ne 'ücj mpatjam nosis nt'a, ma ca mpatjam Dios lal. Yupj pjü jatja tjil Dios mpes, 'ücj mpatjam Dios lal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Niná Jesús tjevele wa sin tjejyama jis lal: “Nun ca nlawú quinam, ca mvelé napj mpes. Nun lowú nt'a, nepénowa 'ücj jisas nsem nun tjuculá mpes. 'Ücj jisas na nun tjuculá, t'üc' way 'ücj jisas wa napj mpes, napj p'iyá tjacuwis jinwá. 'Ücj jisas na napj mpes, t'üc' way 'ücj jisas wa nin tjejyama mpes, jupj p'iyá tjac' jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Üsüs lajay na nun jis lal, Dios ca 'üsüs la mijis yupj mpes, nin lajay mpes. Nepénowa 'ücj jisas profetapan jiquil. Quelel pjyacan̈ profetapan javelepj Dios mpes. Nin mpes Dios ca 'üsüs la mijis yupj mpes, profetapan mpes liji jin p'iyá. Nepénowa 'ücj jisas yom 'üsüs jac'. 'Ücj jisas jupj 'üsüs liji Dios jos jinwá. Nin mpes Dios ca 'üsüs la mijis yupj mpes, yom 'üsüs mpes liji jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nepénowa 'üsüs lajay napj lal pyona lal, jupj napj discípulo mpes. Tsjicj jupj ca nacj, discípulo niná. 'Üsǘ tsjojose p'in ja'ayapj lo müs ca nacj. Nin lajay p'in, Dios ca 'üsüs la mijis yupj jis lal nin la tjajay mpes. T'üc' way niná”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús t'üc' tjevele quinam discipulopan dóceya jis lal. Jupj sin 'yüsa la síjitsja 'oyn nyuca la mijicj. Jupj t'üc' tjevele na, tjil yupj. Jupj wine watsja jun ta'á Galilea mo'ó, pülücj 'a mulú patja nt'a. Jis walap'a'a tjevele Dios mpes, sin 'yüsa lis tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan tjá'asa cawilta mo'ó quinam. Jupj ne bautizar lis tjiji püná. Juan jas tji'yǘsatsja Jesucristo pajal 'üsüs way líjitsja. Mpes Juan sin tjejyama jupj discipulopan mát'eya Jesús nt'a, tjil la veles jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Niná la tjü'üy yupj: —¿Ncu jipj ninana Dios tjevele ca jas majamas cupj nt'a? ¿Ncu p'a wa la nucum? ");
INSERT INTO jicNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","(Yupj nasa tjunuc Jesús pajal 'üsüs la tjiji. Nasa tjepjyacan̈ Jesús tjevelá.) Nin mpes Jesús tjevele yupj jis lal: —Lowa, tjowelé Juan lal nun tjapja'aqué napj nt'a, tjowelé nun tjunucú wa. ");
INSERT INTO jicNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yun tulucj 'ücj januc quinam. Ma polel jiltsja 'ücj lyawun̈ quinam. Jis p'üy tjamaja jis tji'yü'sa wa quinam. Jis pjat la topj 'ücj pjyacan̈ quinam. Tecya'lin̈ nepenowá sin tjüjünsüpj wa 'ücj jis la püt'üs quinam. Napj velé t'emel cjuwá jis lal Dios 'üsüs la tjiji yupj mpes. Pjü nin lejay napj, Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tjowelé wa Juan lal: jupj newa pyona napj mpes, 'ücj jos nsem jupj pajal —nin tjevele Jesús Juan sin tjejyama jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tjil niyom nenem. Tjil na, Jesús tjevele Juan po'ó ne'aj tjatja jis lal. Tjevele pjacj ne jupj. Jesús jis la tji'yüya: “¿Tsjan mpes tjalawú nun Juan nt'a, jis wa cjuwá nt'a tüpü'ü na? ¿Tsjan mpes quelel su nucutsja jupj? ¿Ncu visyú si lapjüna jinwatsja jupj? ¿Ncu nenéyawa p'a casá jólatsja? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tsjan mpes tjalawú jupj nt'a? ¿Tsjan quelel su nucutsja? ¿Ncu 'üsüs sa capyatsja? Nin tulucj. Jepa noypan sin quip 'üsüs way yustapj. Jis wa 'üsüs yustapj nt'a patja yupj. Juan nin tuluctsja. ");
INSERT INTO jicNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tsjan mpes tjalawú Juan nt'a? ¿Tsjan quelel nucutsja? ¿Ncu profeta quelel nucutsja? Nin. T'üc' way profeta jupj. Más püné jupj p'a profetapan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dios Popel tjevele Juan po'ó pajal püna. Dios tjevele Juan jupj jomozo. Tjevele ca jas majamas jupj, ne ca 'ücj la mijis napj ca ncuwis mpes. Tjevele Juan ca mveles napj mpes, mpes la p'a ca nus nucucj napj tjacuwis na. Nin tjevele Dios Juan mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Juan más püné püna tapatja jis lal, quina patja jis lal wa. Nin p'in, Dios si jütüta sin popé más noypan yupj jupj lal. Nin p'iyá tsjictjacj Dios si jütüta sin popé: más noypan yupj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","”Juan el Bautista tjac', tjevele Dios mpes. Pajal pülücj way quelel pjyacan̈tsja jupj tjevelá. Po jisastsja Dios yupj jis Jepa nsem. Pajal la tjomon yupj ca 'ücj mpatjam jupj jyü'ta nt'a. Newa nin quinam. Nepénowa po jisas Dios yupj jis Jepa ca nsem, mpes nin ca nsem yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pjü profetapan tjowelepj Dios ca jis müjü'tüs pjü nosis casá patjá. Niná tapac Dios Popel mo'ó. Niná p'iyá tepyaca Moisés. Jupj tepyaca Dios tjijyü'ta püná. Juan locopyaya wa tjac'. ");
INSERT INTO jicNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Profetapan tjowelepj wa jupj ncuwim. Elías ca ncuwim niswá, tjowelepj yupj. Elías profétatsja püna tüpü'á. Juan el Bautista niná profeta Elías jinwá. Nin p'iyá liji jupj, Elías la tjiji jinwá. Nun ma quelel poné niná ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Najas pjü tjapja'aqué, pjü nusin mü'üsüs napj tjevelé”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jupj tjevele wa: “¿'Oyn nyuca lajay quina patjá? Tsjictjacj jinwá yupj, pülücj 'a si mulú nt'a. Tsjictjacj nenem ts'a 'in la p'a tsjictjacj jis lal, la p'a ma quelel pjelan̈ yupj jis lal. Mpes yümücj javelepj la p'a jis lal: ");
INSERT INTO jicNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nun ma quelel pjwelequé fiesta lijicj jinwá. Ma wa quelel pjwelequé tyoquecj jinwá. Cupj flauta la tjipjyusacj. ¿Tsjan mpes ma tjüpjwelequé, fiesta nt'a lajay jinwá? Locopyaya pajal tülü way tjenejets'equecj. Pajal 'aplijila jinwá la tjijicj. ¿Tsjan mpes ma la tupuyú, nun sejamica tepe'e jinwá?’ Nin javelepj tsjictjacj pjelan̈ na. ");
INSERT INTO jicNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nin p'iyá javelepj quina patjá Juan lal, napj lal 'ots'ipj. Yupj ma jisastsja Juan el Bautista la tjijá. Jupj la pülücj ve ma tjelyaja. Lovin ma tjümü'ü uva 'üsǘ. Mpes yupj tjowelepj lapanen pǘ'ütsja jupj jos mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Locopyaya napj tjacuwis. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ma lejay Juan liji jin. Ve lya napj. Uva 'üsǘ mü'üs napj. Newa nin, malala wa javelepj napj nin po'ó. Yupj javelepj pajal lya lovin. Javelepj 'üsǘ pajal mü'üs, ne maná. Javelepj impuesto jata'epj sejamica napj. Malala nyuca lajay sejamica napj, javelepj. Malala javelepj ncupj manas mpes. Yupj ma salejepj tsjan jisas yupj. Cupj cjay manas 'üsüs lijicj. 'Üsüs tepyala Juan la tjiji mpes. 'Üsüs wa tepyala napj la tjejay mpes. Nin mpes nun ca jus cülayé cupj qjuiyólatsja 'üsüs. Nin lovin 'üsüs lajay jis lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús nin tjevele na, tjevele wa malala la tjajay israelpan pülücj. Yupj patja nt'a pajal 'üsüs la tjiji jupj, yom p'in ma polel liji jinwá. Nin la tjiji sin la 'üsüs jis la jay Dios jas tjejyama jupj. Más pülücj 'üsüs la tjiji yupj nt'a la p'a nt'a jis lal. Newa 'aplijila tuluctsja yupj malala la tjajay mpes. Ma quelel 'üsüs lajaytsja Dios jos jin. Ninana Jesús véletsja yupj jis lal: ");
INSERT INTO jicNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Malala ca nu mpalas nun, Corazín mo'o potjaqué. Malala wa ca nu mpalas nun, Betsaida mo'o potjaqué. Pajal nola nun mpes. Napj pajal 'üsüs la tjejay nun nt'a, yom p'in ma polel liji jinwá. Nun nujola Tiro mo'o patja pajal malala yupj. Sidón mo'o patja pajal malala yupj, nujola nun. Nun p'in malala. Napj pajal 'üsüs la cüjaytsja yupj nt'a, nun nt'a la tjejay jinwá, yupj nasa ca 'aplijila cüpalastsja malala la tjajay mpes. Nasa ca sin 'ücüipaptsja pülül si tsutsca, nasa 'üpjǘ sin 'ücjololtsja wa 'aplijila mpes. Yupj nasa quelel la cüjaytsja Dios. ");
INSERT INTO jicNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dios pajal ca nucopj ntülüs p'a jawas, malala lajay jis capj tyüla na. Nin liji na, más malala ca nu mpalas Tiro mo'o patja jis lal. Más malala ca nu mpalas Sidón mo'o patja jis lal. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","”Nin p'iyá velé wa Capernaum nt'a patja jis lal. Nun ma ca nlawú Dios pü'ü nt'a. Tecya'lin̈ patja nt'a ca nlawú. Nun tjunucú 'üsüs la tjejay napj nun nt'a, yom p'in ma polel liji jinwá. Newa 'aplijila tulucj nun, malala la tjüjí mpes. Nun nujola Sodoma mo'o tapatjá pajal malala yupj. Nun p'in pajal malala. Napj püné la cüjaytsja yupj nt'a, nun nt'a la tjejay jinwá, nasa 'üsüs cüpalastsja yupj Dios lal. Ca Dios ma jis capj cütülüstsja yupj. Newa cüpatjam yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dios pajal ca nucopj ntülüs p'a jawas, malala lajay jis capj tyüla na. Nin liji na, más malala ca nsem nun jis lal Sodoma mo'o tapatja jis lal. T'üc' niná”, nin tjevele Jesús pülücj patja sin popé nepénowa mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Niná tjevele na, tjevele wa Dios lal: “Mpapay, Jepa pajal püné jipj tsjun po'ó, nosis casá nin wa. Nepénowa pajal pülücj salejepj jin yola. Pajal sin tji'yüsa jin yola. Jipj ma jis tje'yan yupj sin tji'yüsa niná jipj lejay. La p'a wa tsjictjacj jinwá yupj. Yusapj ma sin 'yüsa. Niná sin 'yüsa tulucj. Jipj sin 'yüsa lis tjejay la p'in, mpes nin salejepj niná jipj lejay. Jipj pajal 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jipj jyastsja mpes nin tepyala quinam. 'Üctsja jipj lal”, nin tjevele Jesús jupj Popay Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tjevele wa: “Mpapay pjü way ntje'aya. Pjü ma salejepj pjacj napj. Ma salejepj napj ne Dios Jatjam. Mpapay p'in selé. Ma wa salejepj pjacj napj Mpapay. Napj p'in selé. Napj quelel sin 'yüsa lejay wa nepenowá. Yupj p'in salejepj pjacj ne napj Mpapay. ");
INSERT INTO jicNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nun nepenowá quelel lojí Dios jyü'ta jinwá, newa ma polel nin lojí. Nun pajal nin nujola malala la tjüjí mpes. Najas mponé napj mpes nun. Ncapj ncon̈có. Napj ca nucopj mp'acj. Napj ca la mejay nun 'üsüs ca nsem Dios lal. Ma ca nin nujola nun malala la tjüjí mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ncapj ncon̈có. Cupj 'a mulú yugo qjuesé pü'ü jinwá ca nsem. Nusin mü'üsüs napj nusin 'yüsa lejay. Napj 'üsüs way lejay pjü jis lal. Napj tsjicj way jin p'in. Nun ncapj con̈có, 'ücj nujisas mpatjaqué. Nun ma ca nujola nsem püna la tjüjí mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Napj lal tsji' lojí na, 'a mulú yugo qjuesé pü'ü jinwá. Tsji' lijicj 'a mulú. Costa tulucj tsji' lojí napj mpes. Costa tulucj nun lojí napj jyütütj jinwá”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Locopyaya Jesús trigo sine lejen̈ culupwen nipj tjemey, jupj discipulopan jis lal. Sábado jawas waytsja, nin jawas judiopan ma tsji' lajay. Jupj discipulopan vecj tecya'lin̈tsja, mpes trigo nepenowá sey jat'anqueptsja. Tjalá yupj. ('Üctsja niná nin la tjajay yupj ne'aj. Jümücj nt'a jiltsja na, 'üctsja jis la las la p'a 'isin nt'a.) ");
INSERT INTO jicNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseopan tjunuc watsja Jesús discipulopan trigo nepenowá jat'anqueptsja. Tjunuc na, malala yólatsja yupj, nin la tjajay mpes. Tjowelepj Jesús lal: —Jipj discipulopan malala lajay. Dios Popel vele cupj ma polel tsji' lijicj sábado na. Yupj ma polel trigo jat'anquepj sábado na —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús jis wala tjevele: —Dios Popel vele David la tjijá pajal püna. ¿Ncu lovin ma mo'o tjowelé niná? (David israelpan jis jépatsja. 'Üsüstsja jupj Dios lal.) Ts'ac' pjaní jupj vecj pé'etsja. Noyomes jupj cus tocon̈ wa, vecj tecya'lin̈ wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mpes jupj wama tjemey Dios wo nt'a. Ne'aj pan nt'ya. Niná pan israelpan tja'ayapj Dios mpes. David tjelyaja pansas. Noyomes jupj cus tocon̈ tjalá wa yupj. Dios Popel tjevele sacerdotepan p'in 'ücj jalá pan niná. P'a wa ma polel jalá niná pansas. David sacerdote tuluctsja, mop'in nin Dios ma ts'i tji'ina jupj tjelyaja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moisés popel vele wa sacerdotepan 'ücj tsji' lajay Dios wo nt'a sábado na. Malala tulucj tsji' lajay yupj sábado na, nin jawas judiopan ma polel tsji' lajay. ¿Ncu lovin ma mo'o tjowelé nun niná? Napj discipulopan ma malala la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Napj más 'üsüs Dios wo lal. Niná t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nun ma nusin 'yüsa tsjan jos Dios. Dios Popel vele: ‘Napj najas la p'a quelel la sojí nun. Najas jis capj mp'a'sá. Niná lojí más 'ücj nun no 'oyá lal.’ Nun ma nusin tji'yüsa niná Dios tjevelá. Nusin cü'üsüstsja, ma ca cüweletsja napj discipulopan malala la tjajay. Yupj ma malala la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","La p'a wa velé wa. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj 'ücj wa jyütütj tsjan 'ücj jis la jay sábado na, ts'ac' ma tsji' lijicj na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Trigo sine lejen̈ mpe tjemey Jesús. Wama tjemey, judiopan 'a si mulú nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yom ne'aj tjá'asa wa mo'ó, mos c'atsja jupj. Ma polel le páctatsja jupj. Niyom p'a wa ne'aj jatja watsja. Yupj po jisastsja Jesús ca malala mveles, mpes ca 'ücj jat' mvelecj Jesús malala. Nin mpes la tjü'üy: —¿Ncu 'ücj wa Dios lal 'uts'ucucj ma'ayacj sábado na? ");
INSERT INTO jicNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús tjevele yupj jis lal: —Nun popa pjaní oveja tya'a, ca cus mp'a'sas wa oveja niná sábado na. Oveja jomwen jul campwila yaca na sábado na ¿ncu ma ca ntji'lim, ca pje'á la nts'iyas jupj sábado na? Nin ca la mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yom más 'üsüs oveja lal. Nin mpes nin velé, 'ücj wa Dios lal 'üsüs lijicj sábado na. ");
INSERT INTO jicNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús nin tjevele na, tjevele wa yom mos c'atsja lal: —Myas la tepyacta. Nin mpes yom mos la tepyacta quinam. Nasa tji'yü'sa. 'Ücj quinam, mos ma'ajapj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseopan ma polel malala jis la velestsja Jesús la tjijá. Tjil yupj. Yuwá tjowelepj 'oyn nyuca la 'ünan Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús seletsja yupj quelel ja'ünantsja jupj, mpes jupj tjemey nepé. Pülücj way cus tocon̈ jupj tjemey nt'a. Nepénowa malala jisastsja yupj, ne jupj jis tji'yü'sa lis tjiji pjü way. ");
INSERT INTO jicNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Newa jis tjijyü'ta ma jis la veles jupj ne Dios Jatjam. ");
INSERT INTO jicNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pajal püna Dios Popel tjevele ca nin la mijis jupj. Mpes nin la tjiji t'üc' la mijis Dios Popel tjevelá. Niná Dios Popel Isaías tepyacá. Profétatsja jupj, Isaías. Jupj tepyaca Dios tjevelá. Ninana Dios tjevele Jesucristo mpes: ");
INSERT INTO jicNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Niná napj namozo. Napj la t'ya jupj. Quelel lejay jupj. Pajal 'ücj najas jupj lal. Napj Neqjues ca ma'ayá jupj, la püt'üs jupj jos mo'ó. Mpes jupj ca mveles napj mpes judiopan tulucj jis lal. Ca nin mveles napj quelel perdonar lejay malala lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'Üsüs way jupj pajal. Jupj ma le velele. Ma yümücj vele. Ma nepé vele pjac jupj velá jümücj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jupj ma jis capj velele la puyupj na. Jupj ma ca pje'á la nts'iyas 'ots'ots' way p'in japon. Jis capj p'ya'sa jupj. Jupj ca t'üc' la mijis napj tjijyütütj. Nin mpes ca jis capj mp'a'sas malala lajay. Pjü ca la mijis jupj, mpes yupj 'üsüs way ca nsem napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jupj mpes judiopan tulucj ca jus nlayecj 'üsüs jis mpalas napj mpes.” Nin tjevele Dios Jesús mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","P'a wa yom tucuman Jesús nt'a. Lapanen pǘ'ütsja jupj jos mo'ó. Lapanen malala la tjiji mpes jun tuluctsja yomen. Mpes wa ma polel véletsja jupj. Jesús tji'yü'sa la tjiji jupj, mpes 'ücj tjinyuca tepyala, 'ücj wa vele tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pjü way yola jis tepyala Jesús pajal 'üsüs la tjiji. Tjowelepj: “¿Ncu Jesús niná Yomen Dios tjevele ca jas majamas cupj nt'a? Dios tjevele David püna tüpü'ü popa pjaní ncuwim, qjuis capj la p'acj.” ");
INSERT INTO jicNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseopan jus nlay watsja Jesús pje'á jas tjejyama lapanen. Newa ma quelel japontsja Jesús 'üsüs. Yupj tjowelepj: “Beelzebú se p'á'satsja Jesús. Nin mpes 'ücj pje'á jas tjejyama lapanen. Beelzebú jepa püné lapanenpan jis lal.” ");
INSERT INTO jicNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús seletsja yupj nin yólatsja. Mpes jupj sin tji'yüsa lis tjiji Dios mpes p'in 'üsüs la tjiji jupj. Jupj tjevele: “Yuwá nyucunun̈ jepa pjaní jyü'ta nt'a, ne'aj ca malala jis mpalas. Nin p'iyá wa pjaní nt'a patja jis lal. Yuwá nyucunun̈, jis enemigopan 'ücj ca malala lis mijicj yupj. Nin p'iyá ne'aj patja pülücj patja nt'a yuwá nyucunun̈, malala nin yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nin p'iyá Satanás lal. Satanás ma polel pje'á se jamá jupj p'iyá. Jupj nin wa la qjuijis, jupj nucunú ca nsem jupj mpes p'iyá. Ninana la qjuijis, jupj enemigopan 'ücj ca malala la qjuijicj jupj. Nin mpes ca jus cülayé Satanás ma polel ncapj p'ya'sa. ");
INSERT INTO jicNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mop'in nin welé nun. Nun welé wa Beelzebú ncapj p'ya'sa. Nun welé nin mpes 'ücj pje'á li ts'i lapanenpan. Nin tulucj. Nun popa nepenowá pje'á sin tjajam wa lapanenpan. ¿Pjacj jis capj p'ya'sa yupj? Yupj p'iyá ca mvelecj wa nun malala welé pajal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dios Cjües ncapj p'ya'sa. Nin mpes napj 'ücj jyütütj pje'á jil lapanenpan. Jupj ncapj p'ya'sa, nun 'ücj ca nusin la 'üsüs Dios quelel Jepa já'asa quinam nun nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","”Napj tsyupapj jupj, diablú. Nin mpes 'ücj lo 'ü'süs lejay jupj malala la tjijá. Diablú yom jas tjiyocj jinwá. P'a wa ma polel wama la winin la pecj yom jas tjiyocj wo nt'a. Mwalá way ca ntsu'pá yom jas tjiyocj. Locopyaya, nin la tjiji na, 'ücj lo tjilil yom jas tjiyocj juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”Nun ca nujola cüpalas diablú ncapj p'ya'sa tulucj. Jupj ma jos napj lejay, mpes napj ne'enemigo jupj. Jupj ma gente cyuna Dios nt'a, napj lejay jinwá. Jupj liji yupj ma jis la winin Dios nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","”Nin mpes nin velé Dios ma ca perdonar la numijis nun, nin tjowelé mpes. Pjü way malala lajay, pjü way 'ücj perdonar liji Dios. Pjü malala javelepj Dios po'ó, jupj 'ücj perdonar liji wa. Pjaní p'in ma perdonar liji. Malala javelepj Dios Cjües po'ó, Dios ma ca perdonar lis mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Javelepj napj malala, Dios 'ücj perdonar liji yupj. Napj p'iyá niná Yomen Dios jas tjejyamá. Malala javelepj Dios Cjües po'ó, Dios ma ca perdonar lis mijis quinam, cupj pyatjaquecj na p'in. Ma wa ca perdonar lis mijis p'a jawasa, nosis seyasa liji na. ");
INSERT INTO jicNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Nujola tapalas wolas vyala na, nin p'iyá vyala jupj lovin. Jupj wolas 'ücj lo las, lovin 'ücj lo las jupj. Jupj wolas ma polel lo las, lovin ma polel lo las jupj. Jupj wolas nucú na, nun solejé ncu 'ücj lo las jupj wolas. Nin p'iyá napj lal. Napj 'üsüs lejay, mpes ca jus nlayé napj 'üsüs way. ");
INSERT INTO jicNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nun latsj sin popa jinwá. Malala nun. Nin mpes ma polel welé tsjan 'üsüs way. Nun nujola, niná p'in welé. Nin p'iyá pjü way jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yom 'üsüs, 'üsüs wa jola jupj. Nin mpes vele wa 'üsüs way. Yom malala, malala jola jupj. Nin mpes jupj vele wa malala. ");
INSERT INTO jicNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nenéyawa ma jajamapj javelepj. Ma nin yola ncu t'üc' way javelepj. P'a jyawca na Dios ca mveles ncu t'üc' way malala la tjajay. Nin jawas jupj ca jis la mü'üyas tsjan mpes nin tjowelepj yupj niná. Ninana t'üc' way. Nin ca nsem nun jilal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nun 'üsüs way welé nosis casá, Dios ca mveles nun 'üsüs way. Nun malala welé nosis casá, Dios ca mveles nun malala”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Locopyaya niyom nepenowá tjowelepj Jesús lal, yupj fariseopan nepenowá, niyom Moisés popel sin 'yüsa lajaytsja nepenowá. Ninana tjowelepj: —Quelel nyucucj jipj pajal 'üsüs lejay, gente ma polel lajay jinwá. Qjuisin mü'üsüs la mijin jipj Dios mpes velen. ");
INSERT INTO jicNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús yupj jis lal tjevele: —Nun quina potjaqué malala pajal. Nun welé Dios jatjampan nun, mop'in nun ma quelel lojí jupj. Ma quelel lojí jupj jos jin. Nun lo moná napj 'üsüs lejay, gente p'in ma polel lajay jinwá. Nin mpes ca nusin mü'üsüs ncu Dios nin tjejyama napj, nin welé nun. Ma ca la mejay napj. Pjaní way p'in ca la mijis Dios, nun nucú mpes. Püna Jonás lal la tjiji jinwá, nin wa ca la mijis napj lal. Jonás profeta waytsja jupj püná. ");
INSERT INTO jicNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cjul püné jas tjevé Jonás. Jyawca cont'e, püste cont'e wa cjul col mo'o tjá'asa jupj. Nin wa ca nsem napj lal. Jyawca cont'e, püste cont'e wa napj ca mo'os tecya'lin̈ patja nt'a. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","P'a wa ca mvelecj wa nun malala. Nínive mo'o tapatja topon Jonás tjevelá. 'Aplijila jis tepyala malala la tjajay mpes. Yupj nasa quelel 'üsüs lajaytsja jupj tjevele mpes. Nin tulucj nun jis lal. Nun lal 'os quinam. Más püné napj Jonás lal. Newa nun ma poné napj velé. P'a jawas Dios ca mveles ncu t'üc' malala la tjajay pjü. Nin jawas tjejyawca na, Nínive mo'o tapatja ca nlüjün̈ nun jis lal Dios wolap'a'á, ca mvelecj nun malala. Nun ma poné, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","P'a wa ca mveles wa nun malala. Pajal püna quepj jepa já'asatsja campa nt'a, Sur mo'ó. Jupj p'iyá ca nin mveles. Pajal campa mpe tjac' jupj lo pjac Salomón tjevelá. Salomón jepa p'a watsja Israel mpe pajal püna. Salomón pajal selé waytsja Dios tjevelá. Nin mpes quepj quelel pjócatsja jupj tjevelá. Nin tulucj nun jis lal. Nun lal 'os quinam. Más püné napj Salomón lal. Newa nun ma quelel pjo'oqué napj velé. P'a jawas Dios ca mveles ncu t'üc' malala la tjajay pjü. Nin jawas tjejyawca na, quepj niná ca ntojom nun jis lal Dios wolap'a'á. Ca mveles nun malala. Nun ma quelel pjo'oqué, ne nin —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","P'a wa tjevele Jesús yupj jis lal. Tjevele Dios len̈ yupj jisas mo'ó, ca malala jis mpalas. Tjevele: —Lapanen yom jos mpe jama na, 'üsǘ pja nt'a jama, wine. Le palá ca'aj 'ücj la püt'üs. Lovin ma si nucú. ");
INSERT INTO jicNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mpes jupj vele: ‘Püna tüpü'üs nt'a ca mis niswá. Yom nt'a ca mis.’ Yom nt'a tjac' na, len̈ ne'aj yom jos mo'ó. Dios ma pü'ü jupj jos mo'ó. Wosis 'üsüs la tjajapjun jinwá yomen jupj lal. Wosis pajal 'ücj la tjajay jinwá jupj lapanen lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mpes jama lapanen. Lapanenpan p'a wa jilal jac'. Siéteya jilal jac' p'a wa. Más malala yupj mwalá way lal. Pjü yupj yom jos mo'o jil jis la püt'üs. Mpes locopyaya más malala tepyala yomen püna lal. Püna lapanen pjaní way p'in tüpü'ü jupj jos mo'ó. Nin p'iyá ca nsem judiopan quina patja jilal —tjevele Jesús—. Malala yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús newa véletsja yupj jis lal. Pülücj ne'aj tjatja tjepjyacan̈. Newa véletsja na, jupj jamay tjac' wa. Tjiquil wa Jesús jatjaypan. Pje'á lejen̈tsja. Quelel javeleptsja jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pjaní way ne'aj tjatja popé tjevele Jesús lal: —Jemay pje'á ton̈ca. Ne'aj lejen̈ wa jipj jetjaypan. Quelel javelepj jipj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús tjevele jupj lal: —¿Tsjan nujola nun? ¿Pjacj ne napj namay? ¿Pjacj ne napj mpülücpan? ");
INSERT INTO jicNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesús mos ne'aj tecyacaná jupj discipulopan nt'a. Tjevele: —Niná napj namay jin p'iyá napj lal. Niná napj mpülücpan jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dios napj Mpapay tsjun po'ó. Dios jos jin lajay, napj natjaypan jinwá yupj, napj nta'apan jinwá yupj, namay jinwá yupj napj lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nin jawas p'iyá Jesús tjemey wo nepé. 'Üsǘ la nt'a tjemey jupj. Pajal la pünetsja 'üsüs. Campwílatsja. 'Etjele jupj 'üsǘ la nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pajal pülücj 'a jis tjimyula jupj nt'a. Jupj quelel sin 'yüsa la síjitsja. Mpes barco wama tjemey, 'etjele jupj, más 'ücj la veles yupj jis walap'a'á. Pajal pülücj 'üsǘ la nt'a tjelejen̈ jis la pjac. ");
INSERT INTO jicNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pülücj sin tji'yüsa lis tjiji jupj. Lovin parábola tjevele jupj, sin la 'üsüs jis la jay. Ninana Jesús tjevelá: “Yom setel sine wínetsja. Na'aj li ts'iyá sínetsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mpes sine na, setel nepenowá palá tinca jümücj casá. Tsipyaya tjiquil, tjalá setel niná. ");
INSERT INTO jicNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Setel nepenowá pe casá palá tinca. 'Ots'ots' way 'amá 'alatsja ne'aj. Len̈ way tecyojo, 'amá tsjicj way p'in já'asatsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nin mpes malala tepyala jupj. Tjejyawca na ts'iquenan̈. Ts'iquenan̈tsja jis ts'il 'amá casá way ton̈ca mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Setel nepenowá jam nt'a palá tinca. Jam jis t'yüna watsja. Pajal qjuisiyama tepyala, mpes jupj sínetsja ma si t'ünǘ. ");
INSERT INTO jicNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Setel nepénowa 'amá 'üsüs casá palá tinca. 'Üsüs tjevelan̈ yupj. Setel pjaní popé cien tjevelan̈ nepenowá. La p'a wa sesenta tjevelan̈. P'a wa tréinteya tjevelan̈”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesús nasa t'üc' tjevele quinam parabolas. T'üc' tjevele na, tjevele wa: “Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj tjevelé”. ");
INSERT INTO jicNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Locopyaya Jesús discipulopan tjiquil jupj nt'a, la tjü'üy jupj lal: —¿Tsjan mpes jipj sin 'yüsa lejay parábola mpes p'in? ");
INSERT INTO jicNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jupj tjevele: —Dios ma se 'aya pjü sin 'yüsa 'oyn nyuca jyü'ta jupj. Jupj nu 'yaya nun ca nusin mü'üsüs niná. Ma se 'aya yupj ca sin mü'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nun quelel nusin 'yüsa, mpes Dios ca nusin mü'üsüs la mijis ne p'a wa ca nusin mü'üsüs. Pülücj ca nusin mü'üsüs nun. Nin p'iyá pjü jis lal. Dios jisas, mpes ca sin mü'üsüs. Nepénowa ma quelel sin 'yüsa. Pjyacan̈ p'in. Mpes ma ca polel sin mü'üsüs Dios mpes. Sey c'a ca la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nin mpes napj sin 'yüsa lejay parábola mpes. Yupj januc, newa ma yola se palá tsjan mpes januc niná. Yupj pjyacan̈, newa ma salejepj tsjan mpes pjyacan̈ niná. Ma sin 'yüsa. ");
INSERT INTO jicNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsjay püna Isaías tepyaca yupj ca nin la mijicj. Dios p'iyá nin tjevele yupj mpes. Isaías profétatsja jupj. Jupj tepyaca jinwá jis tepyala quinam. Jupj tepyaca: ‘Lovin ca mpja'aqué, newa ma ca nusin mü'üsüs. Lovin ca nucú, newa ma ca jus nlayé tsjan nucú nun. ");
INSERT INTO jicNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gente niná ma quelel sin 'yüsa Dios jos jin, nin jis tepyala yupj. Jis pjat la topj jinwá yupj quinam. Yun jatsicyacj jinwá yupj. Ma quelel salejepj tsjan niná yupj januc. Ma quelel sin 'yüsa pjyacan̈. Nin mpes ma sin 'yüsa tsjan niná yupj januc. Mpes wa ma jus nlay tsjan niná yupj pjyacan̈. Nin mpes ma t'üc' way sin 'yüsa yupj. Yupj newa ma quelel sa con̈ Dios, mpes napj ma polel lejay yupj ca 'üsüs jis mpalas Dios lal.’ Nin tepyaca Isaías yupj sin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”Dios pajal 'üsüs la tjiji nun mpes. Nun 'ücj nusin 'yüsa nun nucú. Nun 'ücj nusin 'yüsa nun pjo'oqué. ");
INSERT INTO jicNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Profetapan pülücj quelel januctsja nun nucú. Newa ma tjunuc yupj niná. Quelel pjyacan̈tsja nun pjo'oqué jinwá. Newa ma tjepjyacan̈ niná yupj. Nin p'iyatsja niyom 'üsüs Dios lal püna tapatjá. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”Tjapja'aqué nun. Napj ca mvelé tsjan po'o tjevelé parábola tjevelé na. Setel sine po'o tjevelé. ");
INSERT INTO jicNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pülücj way pjyacan̈ niná cupj velecj Dios jyü'ta po'ó. Nepénowa ma sin 'yüsa yupj pjyacan̈. Setel jümücj casá palá tinca jinwá yupj. Diablo jac' la ta'es yupj tjepjyacan̈. Mpes lovin ma lajay Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Gente nepénowa setel pe casá palá tinca jinwá. Yupj pjyacan̈ wa Dios tjevelá. Japon yupj. 'Üsüs jisas tjepjyacan̈ mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsjutsj jis ts'il 'amá casá way ton̈ca jinwá yupj. Tsjicj way p'in japon. Locopyaya malala se palá ca nacj. La p'a wa malala la sejay yupj napj lal japon mpes ca nacj. Nin tepyala na, len̈ way p'a casá yola se palá yupj. Ma quelel sa con̈ Dios quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Gente la p'a wa setel jam casá palá tinca jinwá. Pjyacan̈ wa Dios tjevelá. Japon wa yupj. Mop'in pajal nin yola nosis casá lajay mpes. T'emel pülücj jisas wa. Yola t'emel pajal 'üsüs. T'üc' tulucj. Nin mpes lovin ma lajay Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Gente la p'a wa setel 'amá 'üsüs casá palá tinca jinwá. Yupj pjyacan̈ Dios tjevelá. Sin 'yüsa yupj. Yupj nin lajay Dios tjevele jin. Yupj 'üsüs pajal; setel sine, cyojo, velan̈ jinwá yupj. Nepénowa cien velan̈ jinwá. Nepénowa sesénteya velan̈ jinwá. Nepénowa tréinteya velan̈ jinwá —nin tjevele Jesús Dios Popel pjyacan̈ mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","P'a parábola tjevele Jesús, sin la 'üsüs jis la jay. Sin tji'yüsa lis tjiji 'oyn nyuca liji Dios nosis casá. Jesús tjevele: “Ts'ac' pjaní yom setel 'üsüs sínetsja jupj moma nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Püste na pjü way tjijinan̈ yom wo nt'a. Tjijinan̈ na, jupj enemigo tjac'. Tsjutsj malala sínetsja jupj, yom trigo sine nt'a. Tsjutsj malala sine na, tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Locopyaya tecyojo wa trigas. Ts'ituju jupj. Tecyojo wa tsjutsj malala. ");
INSERT INTO jicNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yom jomozopan tjiquil jupj nt'a. Tjowelepj: ‘Jipj setel 'üsüs sin jipj myama nt'a. ¿Tsjan mpes tecyojo tsjutsj malala?’ ");
INSERT INTO jicNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Napj enemigo nin la tjiji ca nacj’, tjevele yomen. Jupj jomozopan la tjü'üy: ‘¿Ncu jyas pyoqjuecj tsjutsj malala?’ ");
INSERT INTO jicNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ma najas’, tjevele jupj. ‘Nun poqjué na tsjutsj malala, nun ca mpoqjué wa trigas ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Más 'ücj 'a mulú ca jis nt'ünüs quinam. Ne'aj velan̈ jacutj na, napj ca mvelé namozopan jis lal: Mwalá way ca mpoqjué tsjutsj malala. Pjü 'a mulú 'a mulú ntsu'pá mü'ümǘ. Locopyaya nca'á wa trigas. Chiquero mo'o mpa'tá’, nin tjevele niná yomen.” Jesús tjevele ca nin nsem wa gente jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús parábola p'a wa tjevele sin la 'üsüs jis la jay. Ninana tjevelá: “Napj ca mvelé tsjan ca mpalas Dios si jütüta jis lal. Mostaza setel jinwá ca nsem. Yom setel niná sine 'amá mo'ó, jupj sine nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostaza setel tsjicj way pajal. Más tsjicj way jupj la p'a setel jis lal. Locopyaya tecyojo, t'yüna jupj. Más püné tepyala jupj la p'a tsjutsj jis lal. Campanya ton̈ca tepyala jupj, mpes tsipyaya jiquil, tsintsil lajay mostaza pjwel nt'a. (Nin p'iyá ca nsem Dios si jütüta jis lal)”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús p'a wa parábola tjevele wa, sin la 'üsüs jis la jay. Ninana tjevelá: “Napj ca mvelé tsjan ca mpalas Dios si jütüta jis lal. Levadura jinwá ca nsem. Quepj levadura tyá'atsja. Harina medida cont'e lal la süpjütj la tjiji jupj, pan la tjiji. Levadura mpes pjü jis t'yüna harinas. Nin p'iyá ca nsem nosis Dios si jütüta jis lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Parábola p'in tjevele jupj, pülücj 'a jis tjimyula jis lal. Pues pjü sin 'yüsa lis tjiji, parábola mpes sin 'yüsa lis tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pajal püna profeta pjaní tjevele Jesús ca nin la mijis. Jupj tjevele: “Parábola mpes ca sin mü'üsüs lis mejay napj. Püna ma sin tji'yüsa, niná ca sin mü'üsüs lis mejay quinam. Dios nosis la tjiji na mpe, ma sin tji'yüsa niná.” Nin tepyaca jupj Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gente pülücj way pjyacan̈tsja Jesús tjevelá. Jupj sin tjejyama t'üc' tjevele na. Wa mo'ó tjemey. Jupj discipulopan tjiquil jupj nt'a. Tjowelepj: —Ma qjuisin tji'yüsa tsjan po'o tjevelen, parábola tsjutsj malala mpes tjevelen na. ¿Tsjan qjuisin 'yüsa lejay jipj parábola niná lal? ");
INSERT INTO jicNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús tjevele yupj jis lal: —Parábola tjevelé, napj mpes p'iyá tjevelé niná. Nosis casá patja mpes wa tjevelé. Napj setel sin jinwá lejay. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nosis napj namama jinwá. Dios jatjampan setel 'üsüs way jinwá. Diablo jos jinwá lajay, tsjutsj malala jinwá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Diablo napj ne'enemigo jupj. Jupj tsjutsj malala sine jinwá liji. Nasa quelel cyawaja na nosis, nasa vyala jinwá. Angelpan vyala jacutj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","”Parábola tjevelé na, tjeveletsja yupj japocj tsjutsj malala. Ja'üm, tjevelé napj. Nin p'iyá ca nsem nosis casá, nosis quelel cyawaja na. ");
INSERT INTO jicNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ca sin majam napj angelpan, ca tsji' la mijicj napj mpes. Yupj ca lis ncoyecj pjü malala lajay. Yupj malala lajay mpes, la p'a wa malala quelel lajay wa. Angelpan ca pjü lis ncoyecj yupj. Malala lajay ma ca mpatjam napj jyütütj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Angelpan ca na'aj la nts'iyacj yupj 'awa püné nt'a. Ne'aj pajal yümücj ca la mpuyucj. Jis wis ca jas nqui'licj, pajal nepé vyaja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Üsüs witjacj p'in 'üsüs ca mpatjam pajal. Sin majawaques yupj, lots'ac' jyawca jinwá jis Papay Dios jyü'ta nt'a. Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj tjevelé —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús p'a wa parábola tjevele wa yupj jis lal, sin la 'üsüs jis la jay. Ninana parabolas: —Yom pjaní t'emel pülücj yus tjinyuca 'amá 'alá. Jus tjinyuca na, niswa tyoca t'emel. Tjemey. Pjü vender la tjiji jupj tyá'atsja. Jupj pajal 'ücj jostsja nin la tjiji mpes. T'emel mpes jaylacj la tjiji jupj moma, t'emel já'asa nt'a. Nin p'iyá liji Dios jupj jatjampan jis lal —tjevele Jesús—. Pajal quelel la siji yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","P'a wa parábola nin p'iyá tjevele wa Jesús. Tjevele: —Yom pjaní tjemey, pe la tepyala, pe 'üsüs yustapj. Jupj pe 'üsüs yustapj vender liji, pǘ'ütsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pe pjaní pajal 'üsüs justa jus tjinyuca jupj. Pülücj jaylactsja pajal. Mpes yom wo nt'a tjemey. Jupj pjü way vender la tjiji jupj tyá'atsja. T'emel mpes jaylacj la tjiji niná pwen. Nin wa liji Dios jupj jatjampan jis lal —tjevele Jesús—. Pajal quelel la siji yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesús p'a wa parábola tjevele yupj jis lal, sin la 'üsüs jis la jay. Sin tji'yüsa lis tjiji pülücj 'a si mulú Dios jatjampan jis lal. Ma pjü ca mpatjam jupj lal. Jesús tjevele: —Niyom jis ataraya püné na'aj la ts'i 'üsǘ püné casá, cjul jis la tjilil. Yupj lajay jinwá liji Dios nosis casá. Niyom pülücj pje'á la coy cjulun. Cjul nepénowa 'üsüs, nepénowa malala. ");
INSERT INTO jicNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ataraya pit'a na, 'üsǘ la nt'a la locjocj. 'Atjalapj yupj. Cjul 'üsüs way japüntüpj quiliyú mo'ó. Malala witjacj na'aj la ts'i yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nin wa ca nsem nosis quelel cyawaja na —tjevele Jesús—. Malala lajay 'a mulú majatjum 'üsüs witjacj jis lal. Angelpan ca ncul. Ca pje'á la ncoyecj malala lajay 'üsüs witjacj mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'Awa püné mo'o ca la nts'iyacj malala witjacj. Ne'aj ca pajal la mpuyucj. Jis wis ca jas nqui'licj pajal nepé vyaja mpes —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús jis la tji'yüya yupj jis lal: —¿Ncu nusin tji'yüsa pjü? —Qjuisin tji'yüsa —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mpes Jesús tjevele yupj jis lal: —Nun nepenowá solejé Dios tjijyü'tá pajal püna. Nun nusin tji'yüsa wa napj nin po'ó quinam. Nasa nusin tji'yüsa 'onin nyuca liji Dios. Mpes 'ücj sin 'yüsa lojí manas. Yom pülücj tya'a jinwá nun. Yom tya'a pül way, seyasa way tya'a wa. Nin wa nun nepenowá. 'Ücj sin 'yüsa lojí püna tjowelepj. 'Ücj wa sin 'yüsa lojí niná napj velé —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Parábola niná pjü way t'üc' tjevele na, tjemey nepé Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Püna tüpü'ü nt'a tjemey. Sin tji'yüsa lis tjiji ne'aj tapatjá judiopan 'a si mulú nt'a. Yupj pajal yólatsja Jesús 'üsüs tjevele mpes. Yuwá jis la tjü'üy: —¿Tsjan mpes pajal selé yom niná? ¿'Oyn nyuca pajal 'üsüs liji, yom p'in ma polel liji jinwá? ");
INSERT INTO jicNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jupj popay silla líjitsja, cjan líjitsja la p'in. Jupj popay cupj popa p'iyá p'in. Jupj jamay María p'in. Jupj püné tulucj. Selecj wa jatjaypan jis lá. Pjaní wa Jacobo ló, p'a wa José ló, p'a wa Simón ló, p'a wa Judas ló. ");
INSERT INTO jicNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jesús to'opan qui'á patja wa cupj qjuis lal. ¿Tsjan mpes jupj pajal selé? —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nin mpes ma jisastsja Jesús. Ts'a tji'in jupj lal. Nin mpes Jesús tjevele yupj jis lal: —Nun ma nujisas napj velé, napj nun jis lal tüpü'üs mpes. Nin lovin profetapan jis lal. P'a nt'a patja jisas profeta vele Dios mpes. Jupj pü'ü nt'a p'in ma quelel japon jupj pajal 'üsüs. Nin p'iyá jupj wo nt'a —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yupj ma japontsja Dios jas tjejyama jupj. Mpes jupj ma pülücj 'üsüs la tjiji yupj nt'a. Pjaní way p'in 'üsüs la tjiji ne'aj, yom p'in ma polel lijá. ");
INSERT INTO jicNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jesús ne'aj já'asatsja na püna tüpü'ü nt'a, Herodes tjapjaca wa Jesús po'ó. Herodes jépatsja Galilea mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes tjevele jupj mozopan jis lal: “Jesús ne Juan el Bautista p'iyá. Napj nola Juan jas tjijyünsa, niswa la püt'üs. Nin ca nacj. Nin mpes 'ücj 'üsüs liji Jesús, yom p'in ma polel liji jinwá”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Püna Herodes tjijyü'ta jis la tjilil Juan. Tjijyü'ta la tsupapj, la 'onsos jupj cawilta mo'ó. Nin jostsja Herodías. Ts'i 'inyatsja pajal Juan lal. Nin mpes Herodes tjijyü'ta niná. Herodías Herodes vosastsja jupj. Herodes jatjay Felipe jats'om waytsja jupj, Herodías. ");
INSERT INTO jicNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Herodes ne'aj tjemya'na jupj. Mpes Juan lovin véletsja jupj lal: “Malala Dios lal jipj vyasas myanun”. ");
INSERT INTO jicNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes quelel 'yǘ'natsja Juan el Bautista, newa ma la tjiji. Lecj jéyatsja jupj la p'a wa judiopan jis lal. Judiopan topontsja Juan el Bautista profeta jupj. Herodes lecj jéyatsja ca yupj ts'i mi'inacj, jupj cü'ü'nas na. ");
INSERT INTO jicNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Locopyaya p'a año tepyala Herodes. Fiesta la tjiji jupj. Fiesta mpes Herodías jucucus bailar la tjiji yupj jis la nuc. Herodes 'ücj jostsja tsjücjüim bailar la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mpes Herodes tjevele jupj lal: —Jipj le mon, mya 'a ca. Dios pjoca napj velé. ");
INSERT INTO jicNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsjücjüim tjevele: —Nca'an ma 'en Juan el Bautista jay pjucj. Plato püné mo'o nca'an. Jamay tjevéletsja 'ücj le moná niná, mpes nin tjevele tsjücjüim. ");
INSERT INTO jicNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Aplijila tepyala Herodes. Ma quelel líjitsja niná; tsjücjüim la tjemyona mpes la tjiji la p'in. Jupj nasa tjevele jupj 'ücj la 'ayas jupj la tjemyoná. Tjevele wa Dios tjapjaca jupj tjevelá. Pülücj tjepjyacan̈ niná. Yupj nasa tjiquil watsja, Herodes pülücj jis la las la tjiji mpes. Nin mpes Herodes tjijyü'ta tsjücjüim jos jinwatsja ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tjijyü'ta mwen taná la jocj Juan el Bautista cawilta mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tucutj jupj jay pjucj plato püné mo'ó. Tucutj, tja'ayapj tsjücjüim. Tsjücjüim nt'ya, tje'yaya jamay. ");
INSERT INTO jicNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Locopyaya Juan discipulopan tjiquil, jis la t'as Juan jüp'üy. 'Amá jul tüpüntüpj jupj. Nin la tjajay na, tjil, tjowelepj Jesús lal niná tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús tjapjaca na niná Juan po'ó, jusapj tjemey jis wa cjuwá nt'a. Barco mpes tjemey jupj 'üsǘ na'aj po'ó. Pajal pülücj jus nlay jupj tjemey, mpes yupj patja mpe tjil Jesús quelel jámatsja nt'a. Jis tsjam mpes tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús ne'as tjemey na 'üsǘ la nt'a, tjinyuca pajal pülücj ne'aj játjatsja jus la nuc. Jesús pajal jólatsja yupj mpes. Po quelel jis capj p'yá'satsja jupj. Yupj nepenowá malala jisastsja. Jupj jis tji'yü'sa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","T'awaná Jesús discipulopan tjiquil jupj nt'a. Tjowelepj: —T'awaná quinam. Sin tjejyama yupj quinam, ne'aj ca mal jis wa nepénowa lejen̈ nt'a. Ca ve jaylacj la mijicj yupj, nlajacj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús tjevele yupj jis lal: —'Ücj wa jalá qui'á. Nun p'iyá jis ma'ayá nlajacj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Pansas cínquiya p'in tya'acj cupj. Cjul mat'e p'in tya'acj —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Nca'á ma 'e —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pjü jis tjijyü'ta jis la 'osos tsjutsj lejen̈ nt'a. Nasa 'atjalapj na, Jesús pan cínquiya nt'ya. Nt'ya wa cjul mat'eyá. Tjinyuca tsjun po'ó, tjevele Dios lal tjüwüi'i ve tje'yaya mpes. T'üc' tjevele na, la tjelepta taná pansas. Jis tje'yaya discipulopan. Yupj pjü jis tja'ayapj wa tsjutsj casá tjatjá. ");
INSERT INTO jicNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yupj pjü way t'üc' tjalá. Pjü jis col pit'a tepyala. Ma polel pjü tjalá yupj. Pjü way ma pjü tjalá, discipulopan quiliyú mo'o t'olon. Quiliyú dóceya tipit'a pan tsjictjacj lal, cjul tsjictjacj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jesús pajal 'üsüs la tjiji, mpes niyom cinco mil t'üc' tjalá jupj jis tje'yaya popé. Nequem tjalá wa, tsjictjacj tjalá wa. ");
INSERT INTO jicNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pjü t'üc' tjalá na, Jesús jis tjijyü'ta jupj discipulopan jis la winin yupj jis barco mo'ó. 'Üsǘ na'aj po'ó sin tjejyama, jupj quelel jámatsja nt'a. Jesús jostsja yupj mwalá ca mal jupj lal, jupj la p'a wa sin tjejyama nas. Mpes tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pjü sin tjejyama na, neven po'ó tjemey jupj jusapj, Dios lal la veles. Püste tepyala na, jusapj já'asatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jupj discipulopan pajal campa játjatsja 'üsǘ casa'á. Barco mo'o játjatsja yupj custjay. Malala jis tepyala, ne ma polel jiltsja yupj. 'Üsǘ pajal lo pjets'epjets'e. Pajal yümücj po yácatsja barco po'ó. Lüpjǘ püné jis wala séjetsja, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pǘstetsja custjay. Nasa quelel jyawca na, Jesús tjac' yupj nt'a. 'Üsǘ casá wínetsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Discipulopan jus tjunuc na, lacj tjeyapj pajal. Tjunuc 'üsǘ casá tjuwine p'in. Ma salejeptsja Jesús jupj. —Tepe'e cjües wine —tjowelepj yupj. La tupuyupj yupj, lacj tjeyapj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Len̈ way Jesús tjevele yupj jis lal: —'Ücj nujisas t'as. Napj ne p'in winis. Po ma locj tjeyá nun. ");
INSERT INTO jicNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro tjevele jupj lal: —Nejepa, ne jim p'iyá, tjevele napj ca mis 'üsǘ casá. ");
INSERT INTO jicNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Was jipj —tjevele Jesús. Mpes Pedro palá tjac' barco mpe. 'Üsüs casá wínetsja Jesús nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jupj sin nin lecj tjeyá jupj, Pedrú. Tjinyuca pajal yümücj jas tjelyapjünǘ lüpjüs, mpes lecj tjeyá jupj. Nasa 'üsǘ pwila quelel jámatsja. —Nejepa, ncapj tjep'ya'sa —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Len̈ way Jesús jupj mos ntjüi'le. Jas tjijyünsa. —Tsjicj way p'in pyon jipj napj lal —tjevele Jesús Pedro lal—. ¿Tsjan mpes ma pyon jipj napj 'ücj nin lejay jipj mpes? —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Manas wama tjil barco mo'ó. Barco wama tjil na, lüpjǘ 'üt'ün nasa tepyala. ");
INSERT INTO jicNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Barco mo'o tjatjá yólatsja pajal püné Jesús, jupj 'üsüs la tjiji mpes. Palá nipi'tjin̈ Jesús wolap'a'á. Tjowelepj: —T'üc' way jipj Dios Jatjam. ");
INSERT INTO jicNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Üsǘ na'aj po'ó ne'as tjil. Genesaret lotsja ne'aj, yupj tjil nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Niyom ne'aj tapatjá ne'as tjunuc Jesús. Mpes pjü jis wala tjowelepj ne'aj way p'in tapatjá. Tjowelepj Jesús tjac'. Mpes yupj tucuman pjü malala jisas ne'aj way p'in tapatja sin popé. ");
INSERT INTO jicNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Topon Jesús 'ücj si 'ü'sa liji. Pajal la tjomon Jesús lal jupj ca jis ma'ayas malala jisas po la 'otj jupj jas quip la nt'a. Quelel po la 'otsja jupj jas quip la nt'a la p'in, jis la 'ü'süs. Pjü way jas quip po la tjo'otj, pjü way jis tji'yü'sa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","P'a jyawca na niyom nepénowa tjiquil Jesús nt'a. Jerusalén mpe tjiquil yupj. Yupj nepénowa fariseopan, nepénowa Moisés popel sin 'yüsa lajaytsja. Yupj la tjü'üy Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tsjan mpes jipj discipulopan ma lajay judiopan püna tapatja tjüjütütj? Jipj discipulopan quelel jalá na, yupj ma jis mas japatsj judiopan lajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús ma jis wala tjevele yupj la tjü'üy mpes. Jupj niná jis lal tjevele: —Nun p'in ma lojí Dios jyü'ta jinwá. Nun quelel nin p'iyá lojí püna tapatja la tjajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios tjevele: ‘'Üsüs la müjí nun jis papay lal, nun sejamay lal wa. Nujola nsem noypan yupj nun jis lal.’ Dios tjevele wa: ‘Nun ma ca mvelé nujisas malala jis mpalas nupopay, nun sejamay. Nun popa nin vele, nun ca mü'ü'ná jupj, malala tjevele mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nun ma nin p'iyá jü'tǘ, Dios tjevele jin p'iyá. T'emel cjuwá nupopay, nun sejamay ca nacj. Nun cjuwá tulucj. Nun welé 'ücj ma 'oyá yupj jisas. Nun welé nun popa pjaní 'ücj vele yupj jis lal: ‘Ninana napj nats'a'á ma ca nu ma'ayá. Nasa tjeveletsja ninana ca ma'ayá Dios mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nun welé 'ücj ma 'üsüs liji jupj popay mpes, niná tjevele na. Nun niná welé na, ma nin nujola Dios tjijyü'tá. Nun quelel lojí judiopan püna tjüjütütj p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nun welé nun p'iyá 'üsüs lojí; mop'in nin, nun 'üsüs lojí tulucj. Isaías t'üc' way tjevele nun mpes pajal püna. Profétatsja jupj, Isaías. Dios mpes tjevele jupj. Jupj tjevele Dios tjevelá nun po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ninana tjevelá: ‘Gente niná 'üsüs javelepj napj nin po'ó, Newa ma quelel la najay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yupj javelepj napj püné, newa ma lajay napj najas jinwá. Yupj sin 'yüsa lajay gente jajütütj p'in, napj velé jin sin 'yüsa lajay tulucj.’ Nin tjevele Dios nun po'ó —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","P'a wa pajal pülücj játjatsja Jesús ne'aj p'in. Jupj tjevele ncul yupj. Tjiquil na, jupj tjevele yupj jis lal: —Tjapja'aqué napj velé. Nusin tjü'üsüs niná. ");
INSERT INTO jicNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yom ma malala nsem Dios lal ve lama 'yonsa mpes. Lampe pyacj mpes p'in, yom niná malala nsem Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Locopyaya Jesús discipulopan tjiquil jupj nt'a. Tjowelepj jupj lal: —Fariseopan ts'a 'in jipj lal, niná tjevelen mpes. ¿Ncu selen? ");
INSERT INTO jicNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús tjevele: —Yupj ma javelepj Mpapay Dios velá. Niná yupj javelepj lol jinwá Mpapay lal. Jupj ca mpoqjues lol niná. Nin liji pjü malala javelepj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma nin nujola t'as yupj javelepj mpes. Yupj ma polel sin 'yüsa lajay Dios mpes. Yun tulucj jinwá yupj. Yun tulucj ma polel jacacan p'a wa. Yom jun tulucj cyacaná yom p'a wa jun tulucj, manas ts'entuna mo'o palá jis ntüncüs ca —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro tjevele jupj lal: —Jipj tjevelen: lampe pyacj, malala. ¿Tsjan qjuisin 'yüsa lejay jipj parábola niná lal? ");
INSERT INTO jicNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús tjevele jupj lal: —¿Ncu ma wa nusin 'yüsa nun? ");
INSERT INTO jicNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ve jalá na, jis col mo'o jama p'in. Locopyaya na'aj la ts'i jis pwi mpe. Nin mpes nin velé nun malala tulucj Dios lal nun lojá mpes. ¿Ncu ma nusin 'yüsa niná? ");
INSERT INTO jicNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Malala nyuca javelepj, malala nyuca yola wa. Malala javelepj mpes, malala yupj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yupj malala yola, mpes nin p'in yola yupj. Malala yola, mpes wa sa 'ünan la p'a. Malala yola, mpes wa ne'aj jamanun sejats'om tulucj. Mpes wa nequem lyawun̈ jis vayum tulucj jis lal. Yupj malala yola, mpes nin. Nin mpes wa niyom ne'aj jamanun tsjücjüimpan, tjewyayin̈ tulucj. Nin mpes wa pequen̈. Nin mpes wa la tsuwil. Nin mpes wa pajal malala javelepj la p'a po'ó. Yupj malala yola, mpes nin lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Niná lajay na, te jinwá yupj Dios lal. Malala tulucj Dios lal yupj ma lajay judiopan lajay jinwá, jis mas japatsj na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús tjemey nepé. Campa way 'in tjemey judiopan patja mpe. Jupj tjemey nt'a Tiro po'o patja ne'aj p'intsja, Sidón po'o patja ne'aj p'intsja wa. ");
INSERT INTO jicNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne'as tjemey na, quepj tjac' la nüjüsü jupj. Judío tuluctsja jupj, quepan. Jupj Canaán mpe 'eseptsja. Judiopan tulucj patja mpe tjac', ne'aj p'in patja mpe. Niná quepj li piyutsja, tjevele Jesús lal: —Nejepa, jipj ne niná Yomen Dios tjevele ca jas majamas nosis nt'a. Jipj David püna tüpü'ü popa p'iyá. Malala ntepalá. Ncapj tjep'ya'sa. Lapanenpan patja napj ncucus jos mo'ó. Newa pajal malala lajay ncucus lal —nin tjevele quepan. ");
INSERT INTO jicNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús ma lal tjevele jupj lal. Nin mpes Jesús discipulopan tjiquil jupj nt'a, la tjomon jupj lal: —Tje'yaya jupj le moná. Jas tjejyama jupj. Newa la cjüipepé jac', newa li piyú. ");
INSERT INTO jicNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús tjevele yupj jis lal: —Mpapay Dios nin tjejyama judiopan nt'a p'in. Yupj ne len̈ jis tjevyala, oveja jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jesús nin tjevele na, quepj ninana p'iyá tjac' jupj nt'a. Palá nipi'tje Jesús wolap'a'á. Tjevele: —Nejepa, ncapj tjep'ya'sa. ");
INSERT INTO jicNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús tjevele quepj lal: —Judiopan Dios ts'uyupj. Napj 'üsüs lejay yupj mpes. Yupj yuts'a'á ma polel la 'ayas la p'a. Nin p'iyá tsjictjacj jis ve ma polel la 'ayas yupj jis tsjiyó —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Quepj tjevele jupj lal: —T'üc' tjevelen. Nin velé p'in, ve tsjictjacj nepenowá palá tinca wo juts'a'á lyaja mpe. Niná 'ücj wa jalá tsjiyó witjacj —tjevele jupj. (Jupj quelel véletsja Jesús 'ücj wa se p'a'sa jupj.) ");
INSERT INTO jicNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús jupj wola tjevele: —Jipj pajal pyon napj lal. Nin ca nsem jipj la tjemyon jinwá. Jesús nin tjevele na p'in, tji'yü'sa quepj jucucus. ");
INSERT INTO jicNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús tjemey nepé. 'Üsǘ püné la nipj tjemey, 'üsǘ niná Galilea ló. Locopyaya tucuc' popa viyá tjemey, tsjicj way p'in. Ne'aj 'etjele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne'aj tjá'asa na, pajal pülücj tjiquil jupj nt'a. 'A jis tjimyula jupj nt'a. Lal tjiquil wa ma polel jil nepenowá. Nepénowa yun tulucj jis lal tjiquil wa. Nepénowa jis mas cjuwá jis lal tjiquil wa. Jis tsjam cjuwá nepenowá jis lal tjiquil wa. Nepénowa ma polel javelepj jis lal tjiquil wa. La p'a wa pajal pülücj malala jisas jis lal tjiquil wa yupj. Tüpüntüpj yupj 'amá 'alá Jesús wolap'a'á; jupj jis tji'yü'sa la tjiji yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne'aj 'a jis tjimyula tjunuc nin tepyala. Tjunuc ma polel javelepj 'ücj javelepj jis tepyala. Tjunuc jis mas cjuwatsja, jis mas seyasa jis tepyala yupj. Tjunuc jis tsjam cjuwá, jis tsjam seyasa jis tepyala yupj. Ma polel jiltsja, 'ücj jis la winin jis tepyala. Yun tulucj 'ücj januc jis tepyala. Pjü jis tji'yü'sa mpes gente ne'aj tjatjá pajal nin yólatsja Jesús 'üsüs la tjiji mpes. Nin mpes 'üsüs pjac tjowelepj Dios po'ó, jupj ne israelpan jis Dios. ");
INSERT INTO jicNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Locopyaya Jesús tjevele ncul jupj discipulopan. Niná jupj tjevele yupj jis lal: —Nola napj yupj mpes. Ts'ac' cont'e nasa qui'á jatja napj lal. Tecyawaja nasa yupj jis ve. Napj ma quelel sin jyam yupj, laja secj custjay. Jis capj nt'ajas ca nacj jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jupj discipulopan tjowelepj: —Wa cjuwá qui'á. Cjuwá ca'aj mpe jis la t'as pansas yupj t'üc' jis la las mpes. Pajal pülücj way yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús jis la tji'yüya: —¿Nol to'á nun pansas? —Siete —tjowelepj yupj—. Cjul tsjictjacj pjaní way p'in tya'acj wa. ");
INSERT INTO jicNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús jis tjijyü'ta gente jis la 'osos 'amá 'alá. ");
INSERT INTO jicNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nin la tjajay na, jupj nt'ya wa pansas sieteyá, cjul nt'ya wa. Tjevele Dios lal tjüwüi'i jupj tje'yaya jis la las. T'üc' tjevele na, tjelepta pansas, la tücüeme wa cjulun. Niná jis tje'yaya jupj discipulopan jis la 'ayas ne'aj jatjá. Yupj pjü jis tja'ayapj pansas popé, cjulun popé wa. ");
INSERT INTO jicNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pjü yupj tjalá. Pjü jis col pit'a tepyala. T'üc' tjalá na, newa játjatsja pan popé, cjul popé wa. Mpes discipulopan quiliyú mo'o t'olon pan tsjictjacj, cjul tsjictjacj wa, ma pjü tjalá. Quiliyú noypan siéteya tipit'a la tjajay pan mpes, cjul mpes wa. ");
INSERT INTO jicNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nasa tjalá niyom pajal pülücj. Cuatro miltsja yupj. Nequem pülücj tjalá wa. Tsjictjacj pülücj tjalá wa discipulopan jis tja'ayapj popé. ");
INSERT INTO jicNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","T'üc' tjalá na, Jesús sin tjejyama yupj. Tjil na, barco wama tjemey. Magdalá po'o tjemey jupj, barco mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niyom tjiquil Jesús nt'a, nepénowa fariseopan, nepénowa saduceopan. Ma topon Dios mpe tjac' jupj, mpes la tjomon jupj ca 'üsüs la mijis, gente p'in ma polel lajay jinwá. Nin mpes ca sin mü'üsüs ncu Dios jas tjejyama jupj, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús tjevele yupj p'iyá 'ücj ca jus cülayecj pjacj ne jupj. Ninana tjevelá: “Nun quelel solejé ncu cus cjol nsem yayá, nun 'ücj lo palá nucú tsjun po'ó. Nenéyawa je way tsjun po'ó t'awaná. Mpes nun welé cus cjol nsem yayá. ");
INSERT INTO jicNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nenéyawa je way tsjun po'ó püstapj, te ton̈ca 'ots'ipj. Mpes nun welé majawus ca yacjaj. Nun 'ücj lo palá nucú tsjun po'ó. Niná 'ücj lojí la p'in. Nun welé nun quelel nusin 'yüsa Dios po'ó. T'üc' tulucj. Ma nusin 'yüsa tsjan mpes 'üsüs tepyala quinam nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nun quina potjaqué malala pajal. Nun welé Dios jatjampan nun, newa nun ma quelel lojí jupj. Nun ma quelel lojí Dios jos jin. Nun lo moná napj 'üsüs la mejay, gente p'in ma polel lajay jinwá. Nin mpes ca nusin mü'üsüs Dios nin tjejyama, welé nun. Ma ca la mejay napj. Pjaní way p'in ca la mijis Dios nun ca nucú. Püna Jonás lal la tjiji jinwá, nin wa ca la mijis napj lal. (Jonás profeta waytsja jupj püná)”, nin tjevele Jesús. Niná tjevele na, tjemey yupj mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús 'üsǘ na'aj po'ó tjemey jupj discipulopan jis lal. Pansas cjuwá tjil yupj, discipulopan. Yo' tepe'e jis la cutj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús tjevele yupj jis lal: —'In tjajama. Po ma jisas t'as fariseopan jis levadura. Ma wa jisas t'as saduceopan jis levadura. Yupj jis levadura malala pajal. ");
INSERT INTO jicNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jupj discipulopan ma sin tji'yüsa Jesús tjevelá. Yuwá p'in jis la tjü'üy tsjan mpes nin tjevele jupj. Tjowelepj: “Cupj ma teque'acj pansas. Nin mpes nin tjevele ca nacj.” ");
INSERT INTO jicNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús seletsja nin tjowelepj yuwá. Mpes jupj tjevele yupj jis lal: —Nun tsjicj way p'in poné napj lal. ¿Tsjan mpes nin nujola cjuwá pansas? ¿Tsjan mpes nin welé? ");
INSERT INTO jicNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ncu ma nusin 'yüsa napj 'ücj wa nu 'ya nun nujos? ¿Ncu ma nujola tepyala napj 'ücj jis tje'yá jis la las niyom cinco mil? Pansas cinco p'in tya'actsja; napj la tjejay t'üc' tjalá yupj pjü. ¿Ncu ma nujola tepyala yupj ma polel pjü tjalá? Nun quiliyú mo'o t'o'nó pan tsjictjacj yupj ma pjü tjalá. ¿Ncu nuyo' tepe'e nol quiliyú tipit'a pan tsjictjacj mpes? ");
INSERT INTO jicNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ncu ma nujola tepyala p'a jyawca na napj tje'yá jis la las niyom cuatro mil? Pansas siete p'in tya'actsja; napj la tjejay t'üc' tjalá yupj pjü. Niswa ma polel pjü tjalá yupj. Nun quiliyú mo'o t'o'nó pan tsjictjacj yupj ma pjü tjalá. ¿Ncu nuyo' tepe'e nol quiliyú tipit'a pan tsjictjacj mpes? ");
INSERT INTO jicNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Napj ma nin veletsja pansas po'ó. Ma nin nólatsja pansas mpes. ¿Tsjan mpes ma nusin 'yüsa niná? Napj nin tjevelé 'in tjajama. Po ma jisas t'as fariseopan jis levadura. Ma wa jisas t'as saduceopan jis levadura. Yupj jis levadura malala pajal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesús nin tjevele na, jupj discipulopan jus nlaytsja jupj ma véletsja levadura po'ó, yupj jis pansas lajay mpes. Jupj nin véletsja fariseopan sin 'yüsa lajaytsja mpes, saduceopan sin 'yüsa lajaytsja mpes wa. Yupj sin 'yüsa lajay levadura jinwá. Yupj 'ücj yus tsuwil la p'a wa. ");
INSERT INTO jicNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús ne'as tjemey Cesarea Filipo po'o patja nt'a. Ne'as tjemey na, jupj la tji'yüya jupj discipulopan jis lal: —¿Pjacj ne napj jin javelepj gentas? Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yupj tjowelepj: —Nepénowa javelepj jipj Juan el Bautista p'iyá. Nepénowa javelepj jipj Elías, püna tüpü'ü p'iyá. P'a wa javelepj jipj Jeremías, püna tüpü'ü wa. Nepénowa javelepj jipj p'a profeta püna tüpü'á. Püna 'i tipü'í, niswa püt', nin javelepj gentas. ");
INSERT INTO jicNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús nin p'iyá la tji'yüya wa discipulopan jis lal. —¿Ne nun? —la tji'yüya jupj—. ¿Pjacj ne napj jin welé nun? ");
INSERT INTO jicNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro jupj wola tjevele: —Cristo jipj. Jipj ne Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. Jipj mpes ca 'üsüs mpatjaquecj. Jipj ne Dios Jatjam, Dios ne pü'ü lovin —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús tjevele jupj lal: —Dios pajal 'üsüs la tjiji jipj mpes. Yom p'in ma jin tji'yüsa la tjiji niná. Napj Mpapay tsjun po'o pü'ü, jupj ne jin tji'yüsa la tjiji niná. Jipj Simón, Jonás jatjam jipj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","P'a wa lyá le t'a jipj mpes quinam. Pedro lyá nsem wa quinam. Pe jinwá jipj, mpes nin lyá jipj quinam. Napj 'os wa pe püné jinwá. Pülücj ca mponecj napj lal, ca mpatjam Dios lal. Napj nin lejay ca nin nsem. Diablo jas tjiyocj tulucj ca nsem yupj jis lal. Newa ca mpatjam yupj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Napj ca mya 'a jipj ca 'ücj mvelen p'a jis lal napj mpes. Jipj velen napj mpes llave jinwá ca nsem. Nepénowa ca mponecj jipj velen. Yupj ca 'ücj la winin Dios jyü'ta nt'a. Nepénowa ma ca mponecj. Mpes ma ca polel la winin Dios jyü'ta nt'a. Jipj ca 'ücj mvelen ncu malala la tjajay napj lal japon. Jipj nin velen nosis nt'a, Dios ca nin p'iyá mveles wa tsjun po'ó. Jipj ca 'ücj mvelen wa ncu malala la tjajay tulucj. Jipj nin velen nosis nt'a, Dios ca nin p'iyá mveles wa tsjun po'ó —nin tjevele Jesús Simón Pedro lal. ");
INSERT INTO jicNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","T'üc' tjevele na, Jesús jis tjijyü'ta jupj discipulopan ma jis la veles la p'a lal jupj niná Jepa Püné Dios tjevele ca jas majamas jis capj la p'acj judiopan. ");
INSERT INTO jicNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pedro nin tjevele Jesús niná Jepa Püné Dios tjevele ca jas majamas. Niná tjevele na, Jesús 'üsüs way tjevele jupj discipulopan jis lal tsjan ca mpalas jupj lal. Püna ma pjü tjevele. Quina 'üsüs way tjevele niná neneyawá. Tjevele Dios jostsja jupj ca mim Jerusalén nt'a, ca pajal malala mpalas jupj ne'aj. Tjevele niyom nepénowa ca malala la mijicj jupj lal ne'aj. Co'müypan ca nin la mijicj, sacerdote noypan 'ots'ipj, Moisés popel sin 'yüsa lajay 'ots'ipj. Tjevele yupj ca mü'ü'nacj jupj. Tjü'ünan na, ca jas müjünsüs ts'ac' cont'e tepyala na. Niswa ca mpü'üm, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro ma jostsja niná ca mpalas Jesús lal, mpes jas tjan tjemyana jupj, cus tjeve'le. Tjevele: —Ma ca nin mya palas jipj. Dios ca cyapj mp'a'sas. ");
INSERT INTO jicNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pedro nin tjevele na, Jesús la nujuya, jupj wola tjevele: —Jutja napj mpe. Satanás jinwá velen. Jipj jyas napj ca malala la mejay. Jipj ma jele Dios jola jinwá. Yom p'in jola jinwá jele jipj. ");
INSERT INTO jicNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Niná tjevele na, Jesús tjevele wa jupj discipulopan pjü way jis lal: —Nun popa quelel ncapj cyon̈ca, ma ca nin la mijis jupj p'iyá jos jinwá. Nin ca la mijis napj lejay jinwá. Napj cruz po'ó ca ma pats'. Malala ca mpalas wa jupj, ncapj cyon̈ca mpes. Jupj ca jas mü'üsüs napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nepénowa ca quelel jis capj mp'a'sacj yupj p'iyá. Ma ca jisas malala se palá, mpes ca mvelecj yupj japon tulucj napj lal. Yupj ma ca mpatjam Dios lal. Nepénowa nca'lin̈ napj lal japon mpes. Más 'üsüs ca jis mpalas yupj la p'a jis lal. Yupj lovin ca mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nepénowa pülücj jatatj nosis nt'a, mop'in ma polel patja Dios lal. Pjü way jatatj nosis nt'a ca nacj. Newa ma polel patja, mpes 'üsüs jis tepyala tulucj pülücj jatatj mpes. Ma polel jaylacj lajay mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ca niswa ncuwis p'a jawas. Tjacuwis na, pjü ca nucucj napj pajal püné, Mpapay jinwá. Napj angelpan ca ncapj ncon̈cocj. Tjacuwis na, napj ca jis ma'ayá pjü gente yupj la tjajay mpes. Nepénowa 'üsüs la tjajay, mpes napj ca jis ma'ayá tsjan 'üsüs way. Nepénowa malala la tjajay, mpes ca jis capj ntül. Mpes más 'ücj nin lajay Dios jos jin quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Napj p'iyá niná Yomen Dios jas tjejyamá. Nun popa nepenowá ca nucú napj cuwis Jepa la 'osos, nun ma taca'liqué na p'in. Newa potjaqué p'in, napj Jepa ca nsem. T'üc' niná —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ts'ac' séisiya tjejyawca na, Jesús tjemey Pedro lal, Jacobo lal wa, Juan lal wa. Juan niná Jacobo jüpülüctsja. Yupj jis lal tjemey joc' campanya ton̈ca nt'a, tucuc' pacá nt'a. Yupj yulupjana way p'in tjil. ");
INSERT INTO jicNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne'aj tjatja na, Jesús p'a casá justa tepyala tjunuc yupj. Jupj wola pajal jaw tepyala lots'ac' jinwá. Jupj jas quip pajal pje way tepyala wa. Jas quip jaw tepyala wa, pajal pje way mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nin tepyala na, nepé lay tepyala wa Moisés. Elías lay tepyala wa. Yupj manas profetapan püna tapatjá. Jesús lal javeleptsja. ");
INSERT INTO jicNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro tjevele Jesús lal: —Nejepa, po 'üsüs qui'á jyatjaquecj. ¿Ncu jyas ts'epjel cónt'eya sin müjünsǘ nun mpes? Pjaní way jipj mpes ca nsem, pjaní wa Moisés mpes ca nsem, pjaní wa Elías mpes ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro newa véletsja na, len̈ way mol palá tjac' wa yupj capá nt'a. T'asiyú tón̈catsja. Jas jawtsja molon. Nepé vele pjactsja mol mpe. “Niná napj Natjam —tjevele—. Quelel lejay jupj. Pajal 'ücj najas jupj lal. Tjapja'aqué jupj velá”, nin tjevele mol mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Niná tjepjyacan̈ na, discipulopan jis wala 'amá 'alá tjo'onsopj. Pajal lacj tjeyapj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nin la tjajay na, Jesús tjac' yupj nt'a. Po lis tje'yot'a jupj. —Nusin tjüjünsǘ —tjevele—. Po ma locj tjeyá. ");
INSERT INTO jicNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Viyá tjunuc na, len̈tsja la p'a. Jesús p'in jus tjunuc. ");
INSERT INTO jicNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yacjaya joc' mpe palavin tjiquil. Yupj palavin jiquiltsja na, Jesús tjevele yupj jis lal: —Ma ca mvelé p'a jis lal nun tjunucú quinam. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ca ma pats', locopyaya ca nin müjünsǘ la püt'üs. Niswa nin tjijyünsǘ na, 'ücj lo veles nun tjunucú joc' mo'ó —niná nin tjijyü'ta Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jupj discipulopan tjowelepj jupj lal: —Cupj pyonecj jipj niná Jepa Püné Dios tjevele ca jas majamas. ¿Tsjan mpes la p'a javelepj Elías mwalá way ca ncuwim niná Jepa Püné lal? Nin javelepj Moisés popel sin 'yüsa lajay —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—T'üc' way jupj mwalá way ncuwim Jepa Püné lal —tjevele Jesús—. Dios Popel tjevele jupj pjü ca 'ücj la mijis Jepa Püné jac' mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nasa tjac' jupj. Yupj ma sin tji'yüsa jupj ninana p'iyatsja Dios Popel tjevele ca ncuwim. Malala la tjajay jupj lal, yupj jisastsja jinwá. Nin p'iyá ca malala la mijicj napj lal, napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nin tjevele na, jupj discipulopan sin tji'yüsa jupj véletsja Juan el Bautista po'ó. Juan el Bautista p'iyatsja niná Dios tjevele ca mwalá ncuwim Jepa Püné lal. ");
INSERT INTO jicNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Joc' 'alá mpe tjiquil na, niswa tjiquil la p'a discipulopan tjatja nt'a. Ne'aj gente pajal pülücj lejen̈tsja wa yupj jis lal. Ne'as tjiquil na, yom pjaní tjac' Jesús nt'a. Tüic' jin tjá'asa Jesús wolap'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nejepa, cus tjep'ya'sa natjam —tjevele—. Pajal malala jos. Jun jyu'ya jin liji jupj lovin. Po 'in malala tepyala jupj. La pülücj 'awa mo'o tjeyaca jun jyu'ya mpes. 'Üsüma tjeyaca wa la pülücj. ");
INSERT INTO jicNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Napj jupj lal tjacuwis jipj discipulopan nt'a. Yupj ma polel 'yü'sa lajaytsja jupj —nin tjevele yomen Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús tjevele yupj jis lal: —Nun ma poné napj lal. Malala nujola pajal. Pajal püs way li nuc nun ca mponé napj lal. Püs way tüpü'üs nun lal quinam. Lowa, lal nculá jupj jatjam. ");
INSERT INTO jicNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tjac' na, Jesús cus tjeve'le lapanen, yom jatjam jos mo'o já'asatsja. Mpes pje'á tjac' tjamacjas jos mpe. Len̈ way 'ücj jos já'asatsja tjamacjas. ");
INSERT INTO jicNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yacjaya Jesús discipulopan tjiquil jupj nt'a, p'a len̈tsja na. La tjü'üy: —¿Tsjan mpes ma polel pje'á jas tjejyamacj lapanen niná? ");
INSERT INTO jicNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jupj jis wala tjevele: —Nun tsjicj way p'in poné napj lal. Nin mpes ma polel lojitsja nun. Tsjicj way p'in cüponé, mostaza setel tsjicj way jinwá, pjü way 'ücj la cüjí. 'Ücj cüwelé mim joc' 'alá. 'Ücj cüwelé: ‘Jutja p'a nt'a’. Ne nin ca nsem nun tjowelé jinwá. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nin p'in velé, lapanenpan nepenowá pajal costa way sin jam. Nintsja niná. Más 'ücj lo moná Dios lal ca 'ücj jas majamá. Ts'ac' pjaní ma ca nlajá, Dios lal ca mvelé p'in. Ma nin lojí, ma ca mim —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús newa wínetsja Galilea mo'ó jupj discipulopan jis lal. Jawas pjaní tjejyawca na, jupj tjevele yupj jis lal: “Napj p'iyá niná Yomen Dios jas tjejyamá. Dios ca ma'ayas niyom ca malala la mijicj napj lal yupj jisas jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ca ma 'ü'nacj, locopyaya ts'ac' cont'e na ca nin müjünsǘ la püt'üs niswá”, nin tjevele jupj. Nin tjevele na, pajal 'aplijila jis tepyala jupj discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús tjemey Capernaum nt'a jupj discipulopan jis lal. Ne'as tjemey na, niyom nepénowa tjiquil Pedro nt'a. Yupj niyom nenem impuesto jaylacj jata'epj Dios wo mpes. Yupj la tjü'üy Pedro lal: —¿Ncu ma impuesto jaylacj liji Jesús, jupj ne jin 'yüsa liji? ");
INSERT INTO jicNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Jaylacj liji jupj —tjevele Pedro. Pedro wo nt'a tjemey, yupj tapatja nt'a. Tjac' na, Jesús tjevele jupj lal, Pedro ma tjevele na p'in. Tjevele: —Jepapan nosis nt'a se jütütj impuesto jaylacj jata'epj gente jatatj mpes, yupj moma jatatj mpes wa —nin tjevele Jesús—. ¿Ncu jele jepapan sejatjampan p'iyá jaylacj lajay niná? ¿Ncu jele p'a wa p'in jaylacj lajay impuesto mpes? ¿'Oyn jele jipj? —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro jupj wola tjevele: —P'a wa p'in jaylacj lajay niná yupj jata'epj. —Nin —tjevele Jesús—. Jepapan sejatjampan ma jaylacj lajay impuesto. (Jupj quelel véletsja jupj 'ücj wa ma jaylacj líjitsja. Jupj Dios Jatjam, ne nin.) ");
INSERT INTO jicNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jupj tjevele: —Mop'in ca jaylacj la mijicj. Ma jaylacj lijicj, yupj ca yola nsem cupj ma qjuisas Dios wo. Jutja jipj 'üsǘ püné nt'a. Jipj anzuelo 'üsüma tjevyala. Ca nts'icjun cjulun. Mwalá way cjul ts'icjucj jipj, jupj lala ma'aptan. Lala mo'o ma'ajam ca t'emel c'a. Niná t'emel t'üc' nsem impuesto jaylacj mpes. Niná ca jis ma'ayan napj jaylacj lejay mpes, jipj jaylacj lejay mpes wa —nin tjevele Jesús Pedro lal. Ne nin la tjiji niná. ");
INSERT INTO jicNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yacjaya Jesús discipulopan tjiquil jupj nt'a. La tjü'üy pjacj yupj popa más püné ca nsem Dios jyü'ta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús tjevele ncuwim tsjicj way. Jupj discipulopan culupwen nt'a tjijyünsa jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nin la tjiji na, Jesús tjevele: —Nun ma 'üsüs way nujola. P'a casá nujola t'as, Dios jos jinwá. Tsjictjacj jinwá t'as nun. Nun ma lojí niná, nun Dios si jütüta popa nsem tulucj. T'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nun popa pjaní pajal tsjicj jin jola jupj p'iyá, tsjicj niná jinwá, jupj más püné ca nsem Dios jyü'ta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gente pülücj nin jinwá patja, yupj tsjicj niná jinwá. Najas nun ma nujola noypan nun p'iyá. Najas 'üsüs lojí yupj jilal napj mpes. 'Üsüs lojí na yupj jilal, t'üc' way 'üsüs lojí napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Malala lajay yupj jis lal, malala nin Dios lal. Tsjictjacj nepénowa japon napj lal. P'a wa nin liji ne tsjictjacj nenem malala nyuca lajay, malala pajal ca nsem jupj lal, nin la tjiji mpes. Más 'üsüs way nsem jupj mpes, la p'a pe püné 'utsu'pa mwen po'ó, ca 'üsǘ püné mo'o la nts'iyas jupj, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”T'üc' way nepénowa malala nyuca lajay. Yupj lajay mpes la p'a quelel malala nyuca lajay wa. Malala ca jis mpalas pajal, yupj nin lajay. Pajal malala ca mpalas wa nosis nt'a yupj malala lajay mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Po ma malala la müjí. Nun quelel malala lojí numos mpes, ma la müjí. Nujola t'as numos cjuwá jinwá. Numos t'ü, na'aj la tocoyé jinwá nujola t'as. Más 'ücj numos cjuwá, ne ca 'ücj mpatjaqué Dios lal. Más malala numos mat'e ca na'aj la nts'iyacj nun 'awa püné nt'a, nun malala la tjüjí mpes. Ne'aj pwe lovin. Nun quelel lowú, malala la müjí, ma la müjí. Nin p'iyá nujola t'as nutsjom cjuwá jinwá. Más 'ücj nutsjom cjuwá, ne ca 'ücj mpatjaqué Dios lal. Más malala nutsjom mat'e ca na'aj la nts'iyacj nun 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nun quelel malala lojí nun nucú mpes p'in, ma ca nucú niná. Nujun tulucj jinwá nujola t'as nun. Nujun t'ü, na'aj la tocoyé jinwá nujola t'as. Más 'ücj nujun pjaní cjuwá, ne ca 'ücj mpatjaqué Dios lal. Más malala nujun mat'e ca na'aj la nts'iyacj nun 'awa püné nt'a —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús tjevele wa: —Po ma nujola t'as tsjictjacj 'üsüs tulucj, yupj tsjicj way mpes. Dios sin jyama yupj jis angelpan, jis majamacj tsjictjacj. Niná angelpan Dios pü'ü nt'a patja. Januc Mpapay Dios lovin, jupj ne tsjun po'ó pü'ü. Mpes nun ca jus cülayé Dios quelel liji tsjictjacj.  ");
INSERT INTO jicNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma sa con̈ Dios, len̈ jinwá yupj Dios lal. Napj jis capj p'yacj mpes ca 'üsüs nsem yupj Dios lal ne ca mpatjam jupj lal. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesús sin tji'yüsa lis tjiji Dios quelel liji pjü gente. Ninana tjevelá: —Yom pjaní oveja ciéneya si manuna ca nacj, pajal pülücj. Oveja pjaní way tjemey, len̈ tjevyala. Mpes yom niná ca mim, ca la mpalas oveja len̈ tjevyalá. Oveja noventa y nuéveya ne'aj lyawun̈ ca nacj joc' 'ala'á, tsjutsj jalá nt'a. Pjü way lejen̈ mpe ca mim yomen. ¿Ncu ma t'üc' way ca nin la mijis niná? ");
INSERT INTO jicNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jupj jus tjinyuca na oveja len̈ tjevyalá, pajal 'ücj jos nsem jupj. T'üc' way niná. Más 'ücj jos nsem oveja niná mpes, la p'a noventa y nueve jis lal. Noventa y nuéveya ma len̈ jis tjevyala yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nin wa Nupopay tsjun po'o pü'ü lal. Jupj ma jos tsjicj pjaní len̈ mvalas. Ma jos malala mpalas. Jupj jos pjü way ca jupj lal mpatjam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesús tjevele wa jupj discipulopan jis lal: —Napj mpes japon nun jis pülücpan napj mpes. Jipj pyülücj pjaní malala liji jipj lal ca nacj. Malala la tjiji na, jutja jus nucun jisapj p'in. 'Üsüs way tjevele jupj lal tsjan niná jupj malala lijá. Nun p'in nuseya mat'e ca mvelé. Jupj ca jola mpalas jupj malala la tjiji ca nacj. 'Üsüs ca la mijis quinam, mpes nun nusey manas wa ca quelel la müjí niswá. ");
INSERT INTO jicNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jupj ma quelel pjoca jipj velen ca nacj, mpes jipj ca mim p'a wa lal jupj nt'a. 'Ücj wa mat'e jis lal mim jupj nt'a. Yupj ca mpjacan̈ jipj pyülücj velá. Yupj ca 'ücj mvelecj jipj t'üc' way velen. Dios ts'uyupan ma polel la pon pjaní p'in vele. ‘Mát'eya javelepj yupj tjepjyacan̈, 'ücj jis la pon. Cónt'eya 'ücj jis la pon wa. Manas jipj lal jil, yupj ca mvelecj wa malala la tjiji lal. Yupj ca mvelecj yupj jisas wa jupj ca 'ücj la mijis.’ ");
INSERT INTO jicNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jupj newa ma quelel pjoca nin la tjejay na, jipj ca mvelen niná Dios ts'uyupj jis lal. 'A jis tjimyula na mvelen ca. Yupj p'iyá ca mvelecj jipj pyülücj lal, jupj malala nyuca liji mpes. Jupj ma quelel pjoca yupj javelepj, Dios ts'uyupj ca mvelecj ma yupj popa jupj quinam. Ma pyona jinwá ca nsem jupj jipj lal. Jipj jele nsem jupj pecj jinwá, impuesto jaylacj jata'epj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nun 'ücj wa ca mvelé ncu malala nyuca la tjajay p'a wa. Nun nin welé nosis casá, nin p'iyá Dios ca mveles tsjun po'ó. Nun 'ücj wa ca mvelé ncu malala nyuca la tjajay tulucj. Nun nin welé nosis casá, nin p'iyá Dios ca mveles tsjun po'ó. T'üc'. ");
INSERT INTO jicNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nin p'iyá niná: nun p'in nuseya mat'e nujola pyala nin p'iyá lo moná Dios lal, jupj ca nu ma'ayas nun lo moná. Mpapay Dios tsjun po'o pü'ü ca nu ma'ayas nun lo moná nosis casá. ");
INSERT INTO jicNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mat'e, cont'e 'a si mulú napj mpes, napj 'os wa yupj jis lal. Nin mpes ca nt'anquecj Dios lal la mon —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yacjaya Pedro tjac' Jesús nt'a. Tjevele Jesús lal: —Nejepa, ¿la nol perdonar la mejay napj natjam, jupj malala la nijá? ¿Ncu la siéteya 'ücj perdonar la mejay jupj? ");
INSERT INTO jicNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús tjevele jupj lal: —La siéteya tulucj. Jipj lovin ca perdonar la mijin jipj jetjam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús parábola tjevele wa Pedro lal. Jas tji'yüsa la tjiji Dios jos ncupj lovin perdonar lijicj la p'a wa. Ninana nin tjevele: —Napj ca mvelé 'onin ne nin liji Dios jupj jyü'ta lal. Jepa püné po'ó ca mvelé napj. Dios liji wa jepa püné niná jinwá. Jepa püné quelel seletsja nol leveltsja jupj jomozopan jupj lal. Jostsja ca jaylacj la mijicj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nin mpes jupj vele watsja jomozopan jis lal. Nasa nin lajaytsja na, mozo pjaní lal jiquil watsja jupj nt'a. Mozo niná level pünetsja. Peso millón quínceya leveltsja jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mozo ma polel jaylacj la tjiji, ma tje'yaya. Nin mpes jepa tjijyü'ta jupj jomozopan ca vender la mijicj mozo niná. Esclavo ca nsem jupj. Tjevele ca vender la mijicj wa jupj jats'om, jupj juts'uyupj 'ots'ipj, pjü way jupj tya'a watsja 'ots'ipj. T'emel ca jaylacj mpalas level mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mozo pajal la tjemyona jepa ma ca nin la mijis. Tüic' jin tjá'asa jepa wolap'a'á. La tjemyona: ‘'In la ntjinucú. Tülü way ca jaylacj la mejay pjü.’ ");
INSERT INTO jicNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nin tjevele na, jupj jepa pajal jólatsja jupj mpes. Tjevele ca perdonar la mijis level mpes. Tjevele 'ücj la winin. ");
INSERT INTO jicNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”Mpes tjemey mozo niná. Tjemey na, mozo niná tjinyuca mozo p'a wa. Niná leveltsja mozo mwalá way lal. Jupj level pjaní waytsja p'in. Mozo mwalá ntjüi'le jupj mwen po'ó. Tjevele level lal: ‘Jaylacj la mijin jipj level napj lal’, ");
INSERT INTO jicNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jupj level tjevele: ‘'In la ntjinucú. Tülü way ca jaylacj la mejay’. ");
INSERT INTO jicNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mozo mwalá ma jostsja. Jepapan nt'a tjemey. T'ya tjevele la p'a ma jaylacj la tjiji level. Tjiquil, ntji'lin̈ level líjitsja mpes. Cawilta mo'o tjo'onsopj jupj. Tjowelepj ne'aj ca mpü'üm jupj, pjü way jaylacj la tjiji nas. ");
INSERT INTO jicNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","La p'a wa mozopan tjunuc nin tepyalá. Pajal 'aplijílatsja mozo mwalá ma perdonar la tjiji ma'ajapj. Tjil yupj jis jepa nt'a, pjü tjowelepj tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jepa püné tjevele ncuwim mozo mwalá. Tjevele jupj lal: ‘Malala jipj pajal. Jipj pajal la tjemyon napj lal, mpes tjevelé ca perdonar la mejay jipj level mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Tsjan mpes ma nin p'iyá la tjejay jipj, mozo la p'a wa lal? Napj nólatsja jipj mpes. ¿Tsjan pjucj ma jéletsja mozo p'a wa mpes?’ nin tjevele jepá. ");
INSERT INTO jicNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jepa ts'i 'inyatsja pajal. Tjevele ca cus ntülücj mozo niná. Tjevele lovin ca cus ntülücj, pjü jaylacj la tjiji nas. ");
INSERT INTO jicNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nun ma quelel perdonar lojí nun sejatjampan, Mpapay Dios ca nin p'iyá la mijis nun jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús tecyawaja tjevele jupj quelel véletsja. T'üc' tjevele na, tjemey jupj Galilea mpe. Niswa tjemey Judea nt'a. 'Üsǘ na'aj po'ó wínetsja. Niná 'üsǘ Jordán lotsja. ");
INSERT INTO jicNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gente pülücj 'a jis tjimyula jupj nt'a jümücj nt'a, cus la con̈. Nepénowa yupj malala jisastsja. Jesús jis tji'yü'sa lis tjiji ne'aj, jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseopan nepenowá tjiquil wa Jesús nt'a. Quelel la 'üytsja jupj lal. Yupj ma jisastsja Jesús. Yólatsja yupj la 'üytsja pajal costa nsem jis wala la veles. Yólatsja jupj mveles malala ca nsem judiopan jis lal. Yupj la tjü'üy: —¿Ncu 'ücj Dios lal yom se jamá jupj jats'om, jupj jos mpes p'in? Malala tulucj jupj jats'om ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús jis wala tjevele: —¿Ncu ma mo'o tjowelé Dios Popel nun? Jupj Popel nin vele Dios p'iyá la tjiji gentas. ‘La tjiji wa niyom, nequem, 'ücj ca mwayin̈ yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dios tjevele: ‘Yom ca mim popay mpe, jamay mpe, jats'om lal lo püt'üs. Ca quelel la mijis jupj. Manas ca jüp'üy pjaní jinwá nsem yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nin mpes yupj mat'e tulucj, tjewyayin̈ na. Pjaní p'in yupj Dios lal. Dios yugo sey pjucj po'ó tipyünta jinwá la tjiji. Dios p'iyá nin la tjiji na, gente ma polel sin tjan sin majamacj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseopan tjowelepj: —Moisés tjevele Dios tjijyü'ta püná. Jupj tjevele yom ca papel mpaques, jats'om pje'á li ts'iyá na. Papel ca mveles quepan jupj jats'om tulucj quinam. Moisés tjevele yom papel ca ma'ayas jupj, ca jas majamas jupj jats'om. ¿Tsjan mpes Moisés tjevele jupj ca 'ücj la mijis niná? ");
INSERT INTO jicNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús yupj jis wala tjevele: —Nun ma 'üsüs quelel lojitsja, Dios jos jin. Nin mpes Moisés nin tjevele 'ücj jas majamá nun sejats'ompan. Dios nosis la tjiji na, jupj ma jostsja yom nin la qjuijis. ");
INSERT INTO jicNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Napj najas más 'üsüs lojí püna la tjajay jis lal. Ma najas nun sejats'om so jamá. Yom se jamá jats'om, p'a lal woya ca nacj. P'a lal woya na, Dios ca jola nsem yom niná ma jats'om ne'aj mya'na. Malala lajay p'in Dios lal. Jets'om la p'a lal wine, nin mpes p'in 'ücj se jam mim —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jupj discipulopan tjowelepj jupj lal: —Po 'in costa way niná la mijicj jipj tjevelen jinwá. Jipj velen yom ma polel pje'á li ts'iyá jupj jats'om, jupj jos na. Más 'ücj ma ca mwayim ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús tjevele: —Costa way patja niyom sejats'om tulucj. Dios jis capj p'ya'sa niyom nepenowá. Yupj 'ücj wa patja sejats'om tulucj. La p'a wa ma polel jis la jay niná. ");
INSERT INTO jicNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Niyom nepenowá ma quelel wyayin̈. Lovin nintsja yupj. Nepénowa malala jis tepyala jis jüp'üy, la p'a wa malala lis tjajay mpes, nin mpes ma polel wyayin̈ nepenowá. Nepénowa yupj jinwá tulucj. Yupj 'ücj wyayin̈. Yupj sin nin ma wyayin̈, Dios mpes tsji' lajay mpes. Nepénowa 'ücj nin lajay napj velé jinwá. 'Ücj nin lajay, ca nin la mijicj ninam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nepénowa tjiquil Jesús nt'a tsjictjacj jis lal. Jisastsja tsjictjacj sey pjucj po'ó ca po la mo'ot'es Jesús. Jisastsja wa jupj Dios lal mveles tsjictjacj mpes. Jesús discipulopan jis capj tjowelel tsjictjacj jis lal tjiquil mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mop'in 'üctsja Jesús lal yupj tjiquil. Jupj tjevele: “Jis ma'ayá ca ncul tsjictjacj napj nt'a. Po ma jis müjü'tǘ ma ncul. Gente japon tsjictjacj japon jinwá, Dios 'ücj si jütüta yupj.” ");
INSERT INTO jicNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús nin tjevele na, tsjictjacj sey pjucj po la tje'yot'a. Nin la tjiji na, tjemey ne'aj patja mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yom pjaní tjac' Jesús nt'a. Tjevele jupj lal: —Jipj sin 'yüsa lejay Dios mpes. ¿Tsjan 'üsüs ca la mejay napj ne Dios ca ma'ayas napj ca 'ücj mpü'üs lovin jupj lal? ");
INSERT INTO jicNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús tjevele: —¿Tsjan mpes napj lal nla 'yüy tsjan ca la mijin pajal 'üsüs? Pjaní way p'in 'üsüs. Jipj jyas mpü'üm jupj lal, nin la mijin jupj jyü'tá. ");
INSERT INTO jicNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yom tjevele: —Jupj pülücj tjijyü'ta. ¿Cana ca la mejay jupj tjijyü'tá? Jesús tjevele jupj lal: —‘Ma ca mü'ü'nan la p'a. Niyom ma ca ne'aj manucj sejats'om tulucj. Nequem ma ca mal jis vayum tulucj jis lal. Ma ca mpequem. Ma la ntsawilin. ");
INSERT INTO jicNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ca 'üsüs la mijin pyapay lal, jemay lal, yupj noypan mpes jipj lal. Quelel lis mijin ne'aj patjá. Jipj p'iyá quelel la 'ejay jinwá, ca quelel lis mijin yupj’ —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tjamacjas niná tjevele Jesús lal: —Pjü way niná t'üc' la tjejay jipj tjevelen jinwá. ¿Ncu pjaní way ma lejay custjay? ");
INSERT INTO jicNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús tjevele jupj lal: —Pjaní way ma lejay custjay Dios jos jinwá. Jipj 'üsüs way quelel lejay Dios jos jin, jipj ca vender la mijin jipj jits'a'á pjü way. T'emel así way ca jis ma'ayan t'emel cjuwá. Jutja, ca nin la mijin. Mpes pülücj ca nt'an tsjun po'ó, Dios pü'ü nt'a. Nin la tjejay na, ncuwim napj nt'a, ca ncapj ncon̈con. Jipj ca jin mü'üsüs napj lal —nin tjevele Jesús jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tjamacjas tjapjaca na niná Jesús tjevelá, 'aplijila tepyala. Tjemey jupj Jesús mpe. Pülücj tyá'atsja, mpes ma quelel así 'yáyatsja jupj juts'a'á cjuwá jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tjamacjas tjemey na, Jesús tjevele jupj discipulopan jis lal: —Nin lovin, pülücj jatatj jis lal. Pajal costa way Dios si jütüta popa se palá yupj. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nin p'iyá nin velé. Pajal costa way camello jav jul casá jama. Camello ma polel nin liji niná. Más 'in costa way pülücj jatatj Dios si jütüta popa ca jis mpalas —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jupj discipulopan tjepjyacan̈ na niná, pajal yólatsja jupj tjevele mpes. Yupj tjowelepj: “Pajal costa way Dios si jütüta popa se palá yupj. Pjü way ma 'üsüs se palá Dios lal ca nacj, ma mpatjam Dios lal.” ");
INSERT INTO jicNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús yus tjinyuca, tjevele: —Gente yusapj p'in ma polel 'üsüs se palá Dios lal. Dios 'ücj nin liji pjü way niná yupj mpes —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro jola tepyala tjamacjas ma quelel jámatsja jupj juts'a'á mpe, 'ücj la püt'üs Dios lal. Mpes Pedro tjevele Jesús lal: —Ncupj cuts'a'á jatja tjeleque jipj lal. Tjeleque cyapj la con̈. ¿Tsjan ca nt'anquecj niná la tjijicj mpes? ");
INSERT INTO jicNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús tjevele jupj lal, la p'a wa discipulopan jis lal wa: —Napj p'iyá niná Yomen Dios jas tjejyamá. P'a jawasa Dios ca pjü seyasa la mijis nosis nt'a. Seyasa liji na, napj Jepa ca mo'os. Pajal püné ca nsem napj. Nun ncapj con̈có quinam, nun jepapan ca nsem 'ots'ipj, nin tepyala na. Nun jepapan dóceya nsem, israelpan jis tribu dóceya jis la jütütj. Nun ca mvelé israelpan jis lal ncu malala la tjajay nosis nt'a. Nin ca nsem nun ncapj tocon̈có mpes. T'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nin p'iyá 'üsüs lejay napj lovin ncapj tocon̈ jis lal. Nepénowa jil jis wa nepé ncapj jacon̈ mpes. Nepénowa jil jis pülücpan nepé. Jis papay, sejamay nepé jil nepenowá. Nepénowa jil jis ts'uyupan nepé. Nepénowa jil jis moma mpe, ncapj jacon̈ mpes. Napj pajal pülücj ca jis ma'ayá nin la tjajay mpes. Pjaní way p'in tjá'asa tjil ca nacj. Napj ciéneya ca jis ma'ayá yupj pjaní way tja'ayapj mpes. Lovin ca mpatjam Dios lal 'ots'ipj, nin ca la mejay napj yupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nepénowa püna p'in topon napj lal, yupj tsjictjacj ca nsem napj Jepa 'os na. Nepénowa p'a jawasa ca mponecj, noypan ca nsem yupj. Nin ca nsem pülücj jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús parábola tjevele wa sin la 'üsüs jis la jay. Sin tji'yüsa lis tjiji 'onin ca jis ma'ayas Dios Jesucristo cus tocon̈ jis lal. Ninana Jesús tjevelá: —Napj ca mvelé 'oyn nyuca liji Dios, jupj jyü'ta nt'a. Yom po'o ca mvelé. Yom niná 'amá püné tya'a, pülücj sine mpes. Dios liji yom niná liji jinwá. Niná yom mozopan jostsja jupj. Po 'in püstapj tjemey, la tepyala niyom nepenowá, jupj jomozopan nsem. Tjevele ca tsji' la mijicj jupj uva lejen̈ nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yupj tjowelepj 'ücj ca tsji' la mijicj ts'ac' pjaní t'emel mpes, ts'ac' pjaní tsji' lajay jaylacj mpes. 'Üctsja niná yom lal. Sin tjejyama tsji' la mijicj jupj uva lejen̈ nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yacjaya yom tjemey jis wa nepénowa lejen̈ nt'a. Las nueve ca nactsja. Yom yus tjinyuca niyom nepénowa yupj lejen̈ p'intsja, ma tsji' lajaytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yom tjevele yupj jis lal: ‘Nun p'iyá ca nlawú wa, ca tsji' la müjí napj uva lejen̈ nt'a. Napj t'üc' way ca jaylacj la mejay nun tsji' lojí mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mpes tjil yupj tsji' jis la jay. ”Yacjaya, culupwen nt'a tjá'asa na, yom tjemey wa niswá yupj jis wa lejen̈ nt'a. Nin p'iyá tjevele jupj niyom ma tsji' lajaytsja jis lal. Jupj nin p'iyá la tjiji wa las tres na, t'awaná. Sin tjejyama wa tsji' jis la jay ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yacjaya tjemey wa niswá yomen. Ne'aj já'asa las cinco pyala na quinam. Jupj p'a wa yus tjinyuca ma tsji' lajay. Mpes jupj jis la tji'yüya yupj jis lal: ‘¿Tsjan mpes nun p'in lüjüquetsja, tsji' liji secj ts'ac' pjaní?’ ");
INSERT INTO jicNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Len̈ pjacj mozo jostsja yacjaj’, nin tjowelepj yupj. Yom jis lal tjevele: ‘Lowa wa nun, ca tsji' la müjí napj uva lejen̈ nt'a’. ");
INSERT INTO jicNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Nasa t'yaja na, yom uva juts'a'á tjevele mozo pjaní lal. Mozo niná jépatsja la p'a wa mozopan jis lal. Yom tjevele jupj lal: ‘Tjevele ncul uva lejen̈ nt'a tsji' lajay. T'emel jis tje'yaya yupj, tsji' la tjajay jaylacj. Mwalá way ca t'emel jis ma'ayan locopyaya sin tjejyam jis lal. Jis tje'yan na, ca jis ma'ayan wa mwalá way sin tjejyam jis lal’, nin tjevele yom uva juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","”Niyom nepénowa t'awaná tjil, las cinco na, hora pjaní tsji' la tjajay. Mpes yupj mwalá way tjiquil, natj t'emel. Ts'ac' pjaní tsji' la tjajay jinwá natj yupj pjü. ");
INSERT INTO jicNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yacjaya niyom p'a wa tjiquil t'emel mpes. Niyom nenem mwalá way tsji' la tjajay tjil yupj, püstapj p'in. Ts'ac' pjaní tsji' la tjajay yupj, mpes yupj yólatsja yom uva juts'a'á más 'in pülücj way jaylacj la mijis yupj jis lal. Nin tuluctsja. T'emel ts'ac' pjaní tsji' lajay jaylacj natj wa yupj pjü. Nin p'iyá jaylactsja. ");
INSERT INTO jicNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mpes yupj jis t'emel natj na, malala po'o javeleptsja yom uva juts'a'á lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Jipj locopyaya sin tjejyam niná noyomes. Hora pjaní p'in tsji' la tjajay’, tjowelepj yupj. ‘Cupj ts'ac' pjaní tsji' la tjijicj cupj. Pajal vyaja pwetsja tsji' la tjijicj cupj. Mop'in jipj nin p'iyá jis tje'yan wa yupj ncupj qjuis tje'yan jin p'iyá. Malala nin’, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","”Uva juts'a'á tjevele yupj popa pjaní lal: ‘Najamica —tjevele jupj—, napj malala la tjejay tulucj nun jis lal. Jipj tjevelen 'ücj ca tsji' la mijin ts'ac' pjaní, ne napj jaylacj lejaytsja jipj ts'ac' pjaní tsji' la tjejay mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nt'ya jipj t'emel. Jutja quinam wya nt'a. Napj quelel jaylacj lejay watsja nin p'iyá locopyaya jas tjejyam lal; jipj lal jaylacj la tjejay jin p'iyá, nin p'iyá jaylacj lejay jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","T'emel niná napj nt'emel. Napj 'ücj 'ya napj nt'emel napj najas jinwá. ¿Ncu ts'üis jipj napj 'üsüs la tjejay mpes?’ nin la tji'yüya uva juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesús tecyawaja tjevele parábola quinam. Tjevele: —Nin jinwá liji Dios. Nepénowa locopyaya topon napj mpes, noypan ca nsem yupj ca nacj napj Jepa 'os na. Nepénowa püna p'in topon, tsjictjacj ca nsem napj Jepa 'os na. Dios véletsja pülücj jis lal ca yupj ncul jupj nt'a, mop'in ma jiquil nepenowá. Dios p'iyá lis t'ya pjacj mpatjam jupj lal. Pjaní way p'in lis t'ya —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús newa jámatsja Jerusalén nt'a. Jámatsja na jümücj nt'a, Jesús jas tjan tjemey jupj discipulopan dóceya jis lal p'in. Tjevele yupj jis lal: ");
INSERT INTO jicNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jerusalén nt'a leque quinam. Napj p'iyá niná Yomen Dios jas tjejyamá. Dios ca jis ma'ayas niyom nepenowá malala la mijicj napj lal; sacerdote noypan ca nin la mijicj, Moisés popel sin 'yüsa lajay ca nin la mijicj wa. Yupj ca mvelecj napj malala la tjejay. Ca mvelecj ca ncapj ntülücj, ma pats'. ");
INSERT INTO jicNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mpes ca ma manucj judiopan tulucj nt'a. Judiopan tulucj ca la mpjüts'ünücj, ca ma süpücj. Ca cruz po'o ca ma valacj napj, ma pats'. Ts'ac' cont'e na, ca nin müjünsǘ, mpü'üs niswá”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Locopyaya, Zebedeo jatjampan sejamay tjac' la veles Jesús lal. Jupj jatjampan tjiquil wa yupj sejamay lal. Sejamay tüic' jin tjá'asa Jesús wolap'a'á, la tjemyona Jesús ca 'üsüs la mijis jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Tsjan jyas? —la tji'yüya jupj. Yupj sejamay tjevele: —Najas natjampan jipj lal p'in majatjum, jipj Jepa jac' na. Najas pjaní wa jipj li'inyampe ma'ajam, ma'ajapj ma'ajam wa jipj nancupwepe najas. Nin la mijin, ma 'en —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús tjevele yupj jis lal: —Nun ma solejé tsjan niná nun lo moná. Malala ca ma palas napj. ¿Ncu 'ücj wa nun lal ca malala nu mpalas nun, napj malala ne palá jinwá? —'Ücj wa niná cupj qjuis lal —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús tjevele yupj jis lal: —Nin ca nsem nun lal. Ca malala nu mpalas, malala ne palá jinwá. Newa nin, napj ma polel velé nun ca majatjaqué napj lal, pjaní wa li'inyampe, pjaní wa nancupwepe. Mpapay nasa la t'ya pjacj ca majatjum ne'aj. 'Ücj la tjiji nasa yupj majatjum nt'a —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesús discipulopan p'a witjacj jus nlay niná la tjomon yupj. Jus nlay yupj la tjomon ca noypan nsem Jesús Jepa tepyala na. Mpes la p'a wa discipulopan diéziya ts'a tji'in discipulopan mat'e jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mpes Jesús nin tjevele ca pjü 'a jis mulus. Tjiquil na, tjevele yupj jis lal: —Judiopan tulucj jis jepapan jajütütj la p'a wa, yupj noypan mpes. Yupj jis auxiliarpan yümücj se jütütj wa ne'aj patjá. ");
INSERT INTO jicNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nin tulucj ca nsem nun jis lal. Nun p'in nujos noypan nsem nun, ca pajal 'üsüs la müjí la p'a mpes. Yupj jis mozo jinwá nsem nun. Nin lojí na, noypan nsem nun. ");
INSERT INTO jicNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nun nujos más 'üsüs ca nsem nun pjü jis lal, ca 'üsüs la müjí lovin la p'a jis lal. Yupj jis esclavo jinwá ca nsem nun. Nin lojí na, más 'üsüs nsem nun la p'a jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nin p'iyá lejay napj. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj tjacuwis jis capj la p'acj la p'a wa. Yupj ncapj jap'acj mpes tjacuwis tulucj. Malala jis tepyala nosis casá patja, malala la tjajay mpes. Napj ma pats' ca yupj mpes. Nin mpes yupj sin popa pülücj ca 'üsüs nsem Dios lal —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús ne'as tjemey watsja Jericó po'ó jupj discipulopan jis lal. Nasa jiltsja Jericó mpe. Gente pajal pülücj jupj lal jiltsja. Cus tocon̈ jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Niyom mat'e jümücj la nt'a játjatsja. Yun tuluctsja yupj manas. P'a wa jis wala tjowelepj Jesús ne'aj wa ca mim. Mpes niná manas yümücj tjowelepj: —Qjuis Jepa, qjuis capj tjep'ya'sa. Dios jin tjejyama nosis nt'a. Jipj David püna tüpü'ü popa p'iyá —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pülücj way Jesús cus tocon̈ sin popé jis capj tjowelel la tupuyupj mpes. —Lyájasa t'as —tjowelepj yupj. Más yümücj la tupuyupj: —Qjuis Jepa, qjuis capj tjep'ya'sa. Dios jin tjejyama nosis nt'a. Jipj David püna tüpü'ü popa p'iyá —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús tyantaná. Tjevele ncul yupj. La tji'yüya yupj jis lal: —¿Tsjan nujos napj la mejay nun mpes? ");
INSERT INTO jicNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Po quelel nyucucj —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús pajal jólatsja yupj mpes, malala jis tepyala mpes. Po la tje'yot'a yun po'ó. Yun po la tje'yot'a na, len̈ way 'ücj januc jis tepyala yupj. Yupj sa con̈ watsja Jesús quinam, sin la 'üsüs yupj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ne'aj way p'intsja quinam Jerusalén nt'a. Ne'as tjil Betfagé po'ó nepénowa tapatja nt'a. Jis wa ne'aj lejen̈tsja tucuc' po'ó, niná tucuc' Olivos ló. Ne'as tjil na Betfagé nt'a, Jesús mwalá sin tjejyama jupj discipulopan mát'eya. ");
INSERT INTO jicNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tjevele yupj jis lal: “Lowa yupj jis wa lejen̈ nt'a. Ne'as tjalawú na, nun ca nucú soysoy tsyu'pa ton̈ca. Soysoy tsjicj ne'aj ton̈ca jamay lal ca nucú wa. 'Osocté, ncumaná ma 'e manas. ");
INSERT INTO jicNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","P'a wa ca nu la mü'üyas tsjan mpes socté, monú soysoysos ca nacj. Nin vele niná, nun ca mvelé Nujepa jos yupj. Tjowelé na niná, jupj len̈ way ca mveles 'ücj monú soysoysos”, nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nin mpes nin tepyala profeta pjaní tjevele pajal püna. Ninana jupj tjevelá Dios mpes: ");
INSERT INTO jicNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tjowelé Jerusalén nt'a patja jis lal: ‘Tjunuca nun. Nun jis jepa jac' nun nt'a. 'Üsüs jupj. Lyájasa wine. Ma le palana. Soysoy casá já'asa jama. Soysoy tsjicj casá já'asa jupj.’ ” Nin tjevele profeta. Tjevele Jesús ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Discípulo manas tjil Jesús tjevele jinwá. Nin la tjajay Jesús tjijyü'ta jin. ");
INSERT INTO jicNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tucuman soysoy jamay soysoy tsjicj lal. Sin quip soysoy casá tjo'onsopj, casá lo 'osos Jesús. Casá já'asa tjemey Jerusalén nt'a, pülücj patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gente pülücj sa con̈tsja Jesús jümücj nt'a. Pülücj yupj sin popé jümücj po'o tapajatj yupj sin quip. Nepénowa manaca pjwel tapajatj jümücj po'ó. Nin la tjajay 'üsüs lo pal jümücj po'ó, Jesús jama nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gente pülücj mwalá tjil jümücj nt'a. Pülücj wa cjüil tjil. Pjü way yümücj la tupuyupj Jesús 'üsüs. Tjowelepj: “'Üsüs pjac tjowelé Jesús po'ó. Jupj niná Yomen Dios tjevele ca jas majamas. David püna tüpü'ü popa p'iyá jupj. Dios pajal 'üsüs ca la mijis jupj mpes. Dios mpes vele jupj, Dios ne cupj qjuis Jepa Püné. Tsjun po'o patja 'üsüs pjac ca mvelecj wa Jesús po'ó.” Nin tjowelepj yupj jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús ne'as tjemey Jerusalén nt'a. Ne'as tjemey na, pjü way Jerusalén mo'o patja javeleptsja Jesús nasa tjac'. Yupj jis la tjü'üy: —¿Pjacj niná, jepa püné jinwá tjac'? ");
INSERT INTO jicNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesús cus tocon̈ tjowelepj: —Ninana Jesús. Profeta jupj. Nazaret mpe 'esepj jupj, Galilea mpe se jütütj mpe —nin tjowelepj yupj la p'a jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús wama tjemey Dios wo nt'a Jerusalén po'ó. Vender lajaytsja ne'aj játjatsja. Jaylacj lajay ne'aj jatja watsja. Jesús pje'á sin tjejyama jis la winin pjü way. Ma jostsja nin lajay Dios wo nt'a. Nepénowa judiopan jis t'emel vender lajaytsja romanopan jis t'emel mpes. Judiopan jis t'emel mpes p'in 'ücj jaylacj lajaytsja ne'aj, Dios wo nt'a. Jesús yus ts'eptaná yupj jis mesa. Nepénowa sipipj vender lajaytsja. Jupj yus ts'eptaná wa yupj jis banco tsjictjacj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tjevele: “Dios Popel vele wa Dios tjevele jupj wo po'ó. ‘Ninana nawá mpe javelepj napj lal —tjevele—. Nin ca ló nsem wosis’, tjevele jupj. Nun ma nujos niná. Nun la tjüjí pwecapan 'a si mulú qui'á”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús Dios wo nt'a já'asatsja na, nepénowa yun tulucj tjiquil jupj nt'a. Nepénowa ma polel lyawun̈tsja tjiquil wa jupj nt'a. Jis tji'yü'sa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdote noypan tjunuc Jesús pajal 'üsüs la tjiji. Niyom Moisés popel sin 'yüsa lajay tjunuc wa. Tjepjyacan̈ wa tsjictjacj tjowelepj Jesús pajal 'üsüs. “Dios ca cus mp'a'sas Jesús —nin la tupuyupj tsjictjacj—. Jupj David püna tüpü'ü popa p'iyá”, tjowelepj yupj. Sacerdote noypan ts'a 'intsja tsjictjacj nin tjowelepj mpes. Nin p'iyá niyom Moisés popel sin 'yüsa lajay. Ts'a 'intsja wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yupj la tjü'üy Jesús lal: —¿Ncu tjapjac' tsjictjacj javelepj? —Tjapjacas —tjevele Jesús—. Dios Popel vele: ‘Dios la tjiji tsjictjacj 'ücj wa jis la veles Dios 'üsüs’. ¿Ncu lovin ma mo'o tjowelé niná? —nin la tji'yüya Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nin tjevele na, tjemey Jerusalén mpe. Betania mo'o tjemey ca majas püste mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Püstapj na niswa tjac' Jesús Jerusalén nt'a. Jümücj po'o jámatsja na, vecj pé'etsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Higuera tjinyuca jupj jümücj la nt'a. Higuera niná julupj 'üsüs lo pis. Jesús la tepyala julupj. Cjuwatsja jupj. Joló p'in tjinyuca. Mpes Jesús tjevele higuera lal: —Lovin ma ca mvalas jipj quinam. Niná tjevele na, len̈ way ts'üique higuera niná. ");
INSERT INTO jicNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jesús discipulopan tjunuc niná tepyalá. —Po 'in len̈ way ts'üique jupj, jipj tjevelen na —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús tjevele yupj jis lal: —Nun poné na Dios lal, 'ücj ca nin p'iyá la müjí, napj la tjejay jinwá. Nun newa poné ca nin mpalas nun welé jinwá, 'ücj wa ca nin la müjí higuera lal, napj la tjejay jinwá. 'Ücj wa ca mvelé joc' lal: ‘Jutja jipj 'üsüma ntolo 'üsǘ püné mo'ó’. Nun poné ca nin mpalas, ca nin mpalas. Ninana ne t'üc'. ");
INSERT INTO jicNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nun Dios lal poné na, Dios ca nin la mijis nun lo moná jupj lal. Pjü lo moná, pjü ca nu ma'ayas —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús niswa wama tjemey Dios wo mo'ó Jerusalén nt'a. Sin 'yüsa lis tjiji ne'aj 'a jis tjimyula jis lal. Newa sin 'yüsa líjitsja na, niyom nepénowa tjiquil jupj nt'a. Yupj nepénowa sacerdote noypan, nepénowa co'müypan judiopan jis lal. Yupj la tjü'üy Jesús lal: —¿Pjacj 'e tje'aya 'ücj nin lejay, jipj lejay jinwá? ¿Pjacj 'i tjüjütüta nin lejay jipj? —nin la tjü'üy Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús jis wala tjevele: —Napj ca nu la mü'üy 'ots'ipj. Pjaní way p'in nu la mü'üy. Nun nawala tjowelé na niná, napj ca mvelé wa nun lal pjacj ntjijütüta nin lejay. ");
INSERT INTO jicNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ninana nu la 'yüy: ¿Pjacj tje'yaya Juan el Bautista 'ücj bautizar la tjiji? ¿Ncu Dios p'in tjijyü'ta ca nin la mijis? ¿Ncu gente p'in jisastsja ca nin la mijis jupj? —nin jis la tji'yüya Jesús. Yuwá tjowelepj sacerdote noypan, co'müypan jis lal. Yuwá tjowelepj tsjan cüwelem jupj lal. Tjowelepj: “Cupj ma polel velecj Dios tjijyü'ta niná. Nin cüvelecj ca niná, Jesús ca qjuis la mü'üyas tsjan mpes ma tepyonecj Juan tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma wa polel velecj gente p'in jisastsja jin la tjiji Juan. Nin cüvelecj ca niná, la p'a wa judiopan ca ts'i mi'inacj cupj qjuilal. Ca malala la qjuis mijicj ca nacj. Yupj pjü way japon Juan el Bautista vele watsja Dios mpes”, niná tjowelepj yuwá. ");
INSERT INTO jicNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mpes yupj tjowelepj Jesús lal: —Cupj ma selecj pjacj tje'yaya Juan el Bautista jupj 'ücj bautizar la tjiji. Jesús tjevele yupj jis lal: —Nun ma nlal tjowelé, mpes napj ma wa ca mvelé nun nla tjü'üyá napj lal. Ma ca mvelé pjacj ntjijütüta napj nin lejay —nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús parábola tjevele wa sacerdote noypan jis lal, co'müypan jis lal wa. Jupj tjevele niná sin la 'üsüs jis la jay yupj ma lajaytsja Dios jos jinwá. Ninana tjevelá: —Yom pjaní jatjampan mát'etsja jupj. Nun ca mvelé pjacj manas popé 'üsüs la tjiji. Yupj jis papay tjemey jatjam mwalá way nt'a. Tjevele: ‘Jutja, ca tsji' la mijin uva lejen̈ nt'a yacjaj’. ");
INSERT INTO jicNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Ma najas’, tjevele jatjam. Yacjaya 'üsüs way jólatsja, mpes tjemey. Tsji' la tjiji popay tjevele jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Locopyaya popay tjemey jatjam ma'ajapj nt'a. Nin p'iyá tjevele jupj lal. Jatjam tjevele: ‘'Ücj napj jum tsji' lejay’. Newa ma tjemey jupj —nintsja parabolas. ");
INSERT INTO jicNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesús jis la tji'yüya sacerdote noypan jis lal, co'müypan jis lal wa: —¿Pjacj manas popé nin la tjiji popay jostsja jinwá? —Jupj jatjam mwalá way —tjowelepj yupj. Nin tjowelepj na, Jesús tjevele wa yupj jis lal: —Niyom impuesto jaylacj jata'epj malala yupj. Pwecapan yupj. Newa más 'üsüs se palá yupj nun jis lal. Dios si jütüta popa 'ücj se palá yupj. Mwalá way Dios si jütüta popa se palá yupj, nun jis lal. Nin p'iyá nequem malala lajay. Dios si jütüta popa 'ücj se palá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan el Bautista tjac' nun nt'a. 'Üsüs la tjiji jupj. Nusin 'yüsa la tjiji 'oyn nyuca 'üsüs way la cüjí Dios jos jinwá. Nun ma toponé jupj tjevelá. Impuesto jaylacj jata'epj 'ücj topon jupj tjevelá. Nequem malala lajay 'ücj topon wa. Nun tjunucú yupj 'üsüs la tjajay yupj topon na. Newa ma 'üsüs quelel lojitsja nun. Newa ma quelel ponetsja jupj tjevelá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús parábola p'a wa tjevele sacerdote noypan jis lal, co'müypan jis lal wa. Niswa sin tji'yüsa lis tjiji yupj malala la tjajay. Ninana Jesús tjevelá: —Tjapja'aqué p'a wa parabolas. Yom 'amá püné tyá'atsja. Uva pülücj sínetsja jupj. 'Ücj la tjiji wa uva sine nt'a. T'asiyú tjivyü'ü jupj. Pe jul püné tyoca, uva ca ne'aj jay majatsjacj, ca 'üsǘ mpalas. Ts'epjel jas tjijyünsa wa ne'aj, jomozopan ca majamacj uva sine nt'a. Nin la tjiji na, yom jis tje'yaya mo'o jasin p'a witjacj, 'ücj la mijicj lo valas. Yupj tjowelepj ca ma'ayacj jupj, tjevyala popé. Nin la tjiji na, tjemey yomen pajal campa. ");
INSERT INTO jicNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","P'a jawas uva tjevyala na, uva juts'a'á sin tjejyama jupj jomozopan uva lejen̈ nt'a. Sin tjejyama jis la ta'es tjevyala popé. ");
INSERT INTO jicNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Niyom ne'aj tsji' la tjajay ma quelel ja'ayaptsja tjevyala popé. Jis ntji'lin̈ jupj jomozopan. Pjaní way mo'o süp, jas tjajam jupj. Pjaní wa tjü'ünan. P'a wa pe mpes po'o la ts'i jupj, nasa tepe'e na. ");
INSERT INTO jicNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Locopyaya uva juts'a'á sin tjejyama p'a wa mozopan uva nt'a tsji' la tjajay nt'a. Pülücj sin tjejyama quinam. Niyom uva nt'a tsji' la tjajay malala lis tjajay wa yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","”Lovin ma tja'ayapj tjevyala popé, mpes jupj jas tjejyama wa jupj jatjam yupj nt'a. Jólatsja ca 'üsüs yola nsem jupj lal, jupj jatjam mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nin tuluctsja. Jatjam jus tjunuc na, yuwá tjowelepj: ‘Uva lejen̈ nt'a jupj popay juts'a'á. Jupj juts'a'á ca nsem, popay tepe'e na. Mas, mü'ünacj jupj, ne ma ca nta'es uva lejen̈ nt'a. Cupj p'iyá ca nt'anquecj momas’, tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mpes ntji'lin̈ wa jupj. Pje'á la ts'i jupj sin mpe. Tjü'ünan jupj —nintsja parabolas. ");
INSERT INTO jicNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesús tjevele ne'aj 'a jis tjimyula jis lal: —Uva juts'a'á ca mim sine lejen̈ nt'a. Ne'as tjemey na ¿ncu nujola tsjan ca la mijis jupj ne'aj tsji' lajay jis lal? ");
INSERT INTO jicNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Ca jis capj ntülüs ne'aj tsji' lajay. Ca jis mü'ü'nas niná niyom malala —nin tjowelepj 'a jis tjimyula popé—. Ca jis ma'ayas la p'a wa ca 'ücj la mijicj lo valas ne'aj. Yupj ca ma'ayacj tjevyala popé jupj juts'a'á mpes —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús tjevele sacerdote noypan jis lal, co'müypan jis lal wa: —Dios Popel tjevele ca nin nsem, parábola jinwá. ¿Ncu ma mo'o tjowelé niná? Nin tjevele jupj Popel: ‘Niyom nepénowa quelel jajünsüptsja wosis pe mpes. Pe pjaní ma jisastsja wosis la jünsüs. Pe niná t'üc' way 'üsüstsja. Mpes qjuis Jepa Dios jas tjijyünsa wosis. Jupj mwalá way tje'yonsa pe niná wosis si jünsa mpes. Pe niná más 'üsüs waytsja pjü pe witjacj jilal. Tsjomis pe niná casá tón̈catsja. Cupj selecj Dios p'iyá la tjiji niná. Jupj pajal 'üsüs way la tjiji.’ Nin vele Dios Popel. ");
INSERT INTO jicNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","”Dios pajal 'üsüs la tjiji nun mpes. Nu tje'yaya wa 'ücj tsji' la tjüjí jupj mpes. Newa nun malala la tjüjí Dios juts'a'á lal, uva lejen̈ nt'a tsji' la tjajay jinwá. Nin mpes Dios ma ca nu ma'ayas tsji' lojí jupj mpes quinam. La p'a wa ca tsji' la mijicj jupj mpes. Yupj ca 'üsüs la mijicj jupj jos jin. ");
INSERT INTO jicNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Napj niná pe 'üsüs jinwá, napj tjevelé jinwá. Nun wosis su jünsǘ jinwá. Yom pe niná casá yaca, jupj malala ca mpalas pajal. Pe niná yom casá yaca na, más malala ca mpalas jupj. 'Üpjǘ jinwá ca mpalas jupj. Ca nin nsem ma quelel la najay jis lal —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdote noypan tjepjyacan̈ parabolas Jesús tjevelá. Fariseopan tjepjyacan̈ wa. Yupj jus nlaytsja Jesús véletsja yupj sin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ma jisastsja Jesús tjevelá. Malala quelel lajaytsja Jesús lal. Ma la tjajay custjay. Lacj tjeyapj la p'a judiopan jis lal. La p'a judiopan yólatsja Jesús 'üsüs. Yupj yólatsja profétatsja jupj, Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús p'a wa parábola tjevele sacerdote noypan jis lal, fariseopan jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Sin 'yüsa la síjitsja pajal malala la tjajay yupj Dios lal. Ninana tjevelá: “Napj ca mvelé 'oyn nyuca liji Dios nosis casá. Jepa püné po'ó ca mvelé. Dios ca la mijis niná jepa püné liji jinwá. Niná jepa püné, jatjam quelel wóyatsja quinam. Popay jostsja pülücj ncul, ca cus ncon̈cocj jatjam, woya na. Lovin nin lajaytsja jis la wayis ne'aj. Mpes jepa püné pülücj la tjiji jis la las. ");
INSERT INTO jicNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pülücj jis lal tjevele ncul jis la las. Ve tjojon na, sin tjejyama jomozopan yupj nt'a. Tjowelepj ca 'ücj ncul quinam. Mop'in ma quelel jiquiltsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","”Mpes jepa sin tjejyama jupj jomozopan p'a wa yupj nt'a. Jepa tjevele ca nin mvelecj niná: ‘Nasa 'ücj la tjejay nu lo las. Nasa tjü'ünan vaca witjacj nu lo las. Tjü'ünan wa vaca t'ünt'ün witjacj. Pjü way 'ücj la tjejay quinam. Nculá, cus ncon̈có natjam, jupj woya na.’ ");
INSERT INTO jicNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mpes tjil jepa jomozopan. Yupj jis lal tjowelepj jepa tjevele jinwá. Mop'in gente niná ma quelel jiquiltsja jepa jatjam wóyatsja nt'a. Ma quelel pjyacan̈tsja jepa jomozopan tjowelepj. Tjil la p'in yupj quelel jiltsja nt'a. Pjaní wa jupj sine lejen̈ nt'a tjemey. P'a wa tjemey vender la mijis. ");
INSERT INTO jicNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","P'a witjacj jis ntji'lin̈ jepa jomozopan. Tjowelepj jepa jomozopan malala. Jis tjü'ünan yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jepa pajal ts'i tji'ina nin la tjajay mpes. Sin tjejyama jupj militarpan niná niyom nt'a. Jis tjü'ünan yupj, jepa jomozopan tjü'ünan mpes. Yupj jis wa tjü'üm wa. ");
INSERT INTO jicNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","”Locopyaya jepa tjevele ncul jomozopan p'a wa. Tjevele yupj jis lal: ‘Ve tjojon quinam, natjam woya mpes. Pülücj jis lal tjevelé ncul jis la las, mop'in ma quelel jiquiltsja. Malala yupj, mpes ma ca nlajacj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lowa nun jümücj la püné nt'a. Gente ca yus nucú jümücj nt'a. Pjü nucú, pjü jis lal ca mvelé ncul jis la las’, nin tjevele jepa püné. ");
INSERT INTO jicNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mpes jupj jomozopan tjil jümücj nt'a. Pülücj tjunuc ne'aj. Nepénowa 'üsüstsja, nepénowa malala. Pjü jis lal tjiquil jepa wo nt'a. Mpes pülücj wama tjil, cjuwá ca'aj cücj p'a wa jupj wo mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”Jepa tjac' yus la nuc. Yupj pjü sin quip 'üsüstsja, woya nt'a játjatsja mpes. Jepa p'iyá jis tje'yaya niná pülül 'üsüs. Yom pjaní p'in ma jas tücüi'pe pülül 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jepa tjevele jupj lal: ‘Najamica ¿'oyn nyuca wama tjacuy, cjuwá jin quip 'üsüs? Cjuwá niná, ma polel wama cuy qui'á.’ Myáycatsja yomen. Ma lal tjevele jepa lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","”Mpes jepa tjevele jomozopan jis lal: ‘'Utsu'pa mos, tsjom 'utsu'pa wa. Pje'á la nts'iyá jupj, pajal püste nt'a. Gente ne'aj jil pajal ca la mpuyucj. Yupj jis wis ca jas nqui'licj wa’, nin tjevele jepa. ");
INSERT INTO jicNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","”Nin p'iyá ca la mijis Dios, jepa püné la tjiji jinwá. Pülücj jis lal véletsja ca ncul jupj nt'a, mop'in ma jiquil pülücj. Dios p'iyá lis t'ya pjacj ca mpatjam jupj lal. Pjaní way p'in lis t'ya jupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús t'üc' tjevele na, tjil fariseopan. Ts'a 'intsja pajal Jesús lal. Yuwá p'in tjowelepj tsjan la mü'üyacj jupj lal, jupj ca malala cüveles yupj jis wala tjevele na. Jisastsja ca 'ücj la tjilil jupj, cus la tül. ");
INSERT INTO jicNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mpes yupj sin tjajam sejamicapan nepenowá Jesús nt'a. Sejamicapan nin p'iyá yólatsja yupj jin p'iyá. La p'a niyom jis lal tjil. La p'a wa niná 'ücj jisastsja Herodes jépatsja Israel mo'ó. 'Üctsja yupj jis lal romanopan mpes tsji' líjitsja jupj. Ne'as tjil na Jesús nt'a, fariseopan sejamicapan tjowelepj Jesús lal: —Cupj selecj jipj t'üc' way velen. Sin 'yüsa lejay Dios jyü'tá t'üc' way. Ma nin jele ncu jisas jipj velen. Nin p'iyá velen pjü jis lal, noypan jis lal, tsjictjacj jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mpes cupj quelel lya 'yüyacj ncu 'ücj Dios lal jaylacj lijicj impuesto jepa romano t'e'enca mpes. ¿Tsjan jele jipj? —nin la tjü'üy yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús jus nleya yupj quelel malala lajaytsja jupj lal. Jupj tjevele yupj jis lal: —Nun welé nun quelel lojí Dios jos jin. Nun lu tsuwilí. ¿Tsjan mpes nla 'üyá niná napj lal? Napj selé nun ma quelel jus nlayé nla tjü'üyá mpes. Nun nujos napj malala velé. ");
INSERT INTO jicNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nca'á nuc t'emel impuesto jaylacj —tjevele jupj. Mpes tucutj romano jis t'emel c'a. ");
INSERT INTO jicNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús la tji'yüya yupj jis lal: —¿Pjacj wola t'emel wola po'ó já'asa? ¿Tsjan ló t'emel po'ó tapac? —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Romanopan jis jepa jupj —tjowelepj yupj. Nin tjowelepj na, Jesús tjevele yupj jis lal: —Tja'ayá jepá jupj 'ücj le moná nun lal. Tja'ayá Dios jupj 'ücj le moná nun lal —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Niná tjevele tjepjyacan̈ na, pajal yólatsja Jesús pajal 'üsüs tjevele mpes. Jupj ma malala tjevele, yupj jisastsja jinwá. Mpes tjil quinam Jesús já'asa mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nin jawas p'iyá tjiquil wa saduceopan Jesús nt'a. Saduceopan japon tecya'lin̈ ma ca sin müjünsücj, ma ca mpatjam niswá. Yupj tjowelepj Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Püna Moisés tjevele tsjan niná Dios qjuisí jütüta. Tjevele yom pjaní popa tulucj pe'e, jupj jatjam mwayim ca, tepe'e jats'om lal. Ca popa jana nsem tepe'e jats'om lal. Tepe'e juts'uyupan jin p'iyá ca nsem yupj, nin tjevele Moisés. ");
INSERT INTO jicNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nin mpes cupj lya 'yüyacj. Püna niyom siéteya tapatja qui'á cupj qjuis lal. Pjü yupj jis sejatjampan yupj. Sejatjampan popa mwalá way tjowaya. Popa tulucj tepe'e jupj. Popa tuluctsja, mpes jupj tsüipe tjowaya tepe'e jats'om lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nin p'iyá tepyala jupj lal. Popa tulucj tepe'e wa jupj. Jupj tepe'e na, jupj jatjay tjowaya wa jatjam jats'om lal. Nin p'iyá popa tulucj tepe'e jupj. Nin p'iyá tepyala pjü sejatjampan jis lal. Pjü way tjewyayin̈ quepj niná lal. Pjü way siéteya sin popa tulucj tecya'lin̈ yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yupj pjü way tecya'lin̈ na, tepe'e wa quepan. Popa tuluctsja jupj lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Pjacj jats'om nsem jupj, tecya'lin̈ sin müjünsücj na jis la püt'üs niswá? Pjü way niyom siéteya tjewyayin̈ jupj lal, tapatja na p'in —nin tjowelepj yupj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús tjevele yupj jis lal: —Nun ma solejé Dios Popel tjevelá. Nin p'iyá ma solejé Dios pajal püné. Nin mpes ma nusin 'yüsa niná. ");
INSERT INTO jicNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tecya'lin̈ sin müjünsücj ca, ca mpatjam niswá. Sin tjüjünsüpj na, ma nin p'iyá lajay, püna la tjajay jinwá. Nequem, niyom niswa patja na, ma ca mwayin̈ yupj. Angelpan Dios pü'ü nt'a patja jinwá ca nsem yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","T'üc' way ca sin müjünsücj tecya'lin̈, ca mpatjam niswá. ¿Ncu ma mo'o tjowelé Dios tjevelá jupj Popel mo'ó? ");
INSERT INTO jicNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ninana Dios tjevelá: ‘Napj Dios Abraham lal, Isaac lal wa, Jacob lal wa’. Cupj selecj conas pajal püna tecya'lin̈. Selecj wa Dios tecya'lin̈ jis Dios tulucj. Patja jis Dios jupj. Nin mpes selecj yupj conas patja quinam —nin tjevele Jesús saduceopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pülücj way tjepjyacan̈ jupj tjevelá. Tjepjyacan̈ na, pajal yólatsja jupj pajal seletsja mpes. Pajal 'üsüs sin 'yüsa líjitsja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseopan tjepjyacan̈ wa Jesús pajal 'üsüs jis wala tjevele saduceopan. Saduceopan ma polel malala javeleptsja Jesús lal. Mpes fariseopan 'a jis tjimyula. ");
INSERT INTO jicNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Niswa quelel januctsja ncu malala mveles Jesús. Yupj popa pjaní pajal seletsja Moisés popel. Mpes jupj tjevele Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Dios pülücj way qjuis tjijyü'ta. ¿Cana más 'ücj jis la jay pjü Dios tjijyü'ta popé? ");
INSERT INTO jicNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús tjevele jupj lal: —‘Pajal ca quelel la mijin Dios, jipj Jepa Püné jupj. Pajal ca tsji' la mijin jupj mpes lovin. Lovin ca jele mpalas jupj pajal 'üsüs.’ ");
INSERT INTO jicNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ninana Dios qjuisí jütüta, po jos nin lijicj cupj. Ninana lijicj más 'ücj pjü way lijicj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dios jos p'a wa lijicj nin p'iyá. Tjevele: ‘Ca quelel lis mijin wa ne'aj patjá. Jipj quelel la 'ejay jinwá ca quelel lis mijin yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dios po jos manas lijicj. Nin mpes tjijyü'ta pjü way jupj tjijyü'tá Moisés popel mo'ó. Nin p'iyá tjowelepj wa profetapan, cupj ca nin la mijicj —ninana Jesús tjevele fariseo lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseopan 'a mulú tjátjatsja na, Jesús tjevele yupj jis lal. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Dios tjevele ca jas majamas yom pjaní jis capj la p'acj judiopan. ¿Ncu solejé Dios tjevelá yom niná mpes? ¿Pjacj jupj cocoytsja pajal püna tüpü'á? Fariseopan tjowelepj: —David ca jupj cocoy nsem, niná David jépatsja pajal püna. ");
INSERT INTO jicNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—T'üc' tjowelé —tjevele Jesús—. David jupj cocoy pajal püna tüpü'á. David tjevele wa ninana p'iyá jupj jépatsja. Nin tepyaca David Dios Popel mo'ó. Dios Cjües cus tjep'ya'sa t'üc' la veles Dios mpes. Ninana David tepyacá: ");
INSERT INTO jicNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Qjuis Jepa Dios tjevele Nejepa lal: “Nt'i'isa jipj napj li'inyampe. Jipj ca müjü'tün napj lal. Napj ca la mpalan jipj enemigopan jis lal. Napj ca la mejay jipj enemigopan tsjyam 'alá jatja jinwá. Nin ca la mejay jipj mpes, jipj napj lal jac' na.” ’ David tjevele niná Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dios nin tjevele David jepa lal. Cupj selecj Jepa niná Dios ca jas majamas p'iyá. ¿'Oyn nyuca nacj David popa nacj jupj? Niná Yomen Dios ca jas majamas, pajal püné jupj David lal —nin tjevele Jesús fariseopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yupj pjü way salejeptsja Jesús t'üc' tjevele. Ma polel la veleltsja jupj lal. Nin jawas mpe ma quelel la 'üytsja Jesús lal. Lacj tjeyaptsja Jesús pajal 'üsüs tjevele mpes yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús nasa tecyawaja tjevele fariseopan jis lal. La p'a wa pajal pülücj 'a jis tjimyúlatsja Jesús nt'a. Jupj tjevele yupj jis lal quinam. Jupj discipulopan jis lal tjevele wa jupj. Ninana tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ninana noyomes Moisés popel nusin 'yüsa lajay. Nu jajütütj tsjan la müjí, nin la müjí Dios jyü'ta jin. Fariseopan nu jajütütj wa yupj jinwá. Yupj yola 'ücj wa jajütütj la p'a wa Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pjü way la müjí nun yupj javelepj jinwá. Ma ca la müjí yupj lajay jinwá. Yupj p'iyá ma nin lajay yupj jajütütj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yupj jajütütj p'a wa pajal 'üsüs jis la jay. Pajal costa way nin lajay yupj jajütütj jinwá. Newa yupj p'iyá ma jis capj jap'acj ca nin la mijicj yupj jajütütj jinwá. Lovin ma yola p'a wa mpes. Nin fariseopan. Nin p'iyá Moisés popel sin 'yüsa lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","”Yupj 'üsüs jin lajay la p'a januc na. Yupj jisas p'in la p'a ca yola nsem Dios quelel lajay yupj. Nin mpes Dios Popel tsjictjacj ja'onsopj 'opopa tsjictjacj mo'ó. Jis wala po'ó jatsupapj 'opopa tsjictjacj neneyawá, nenéyawa jis pjel po'ó jatsupapj. Po jisas la p'a ca nucucj 'opopa tsjictjacj. Po jisas wa la p'a wa yola nsem yupj 'üsüs, mpes más 'in püné lajay 'opopa tsjictjacj. Nin p'iyá pajal campa lajay sin quip po'o velan̈. Jisas ca p'a wa ca nucucj, ca yola nsem yupj quelel lajay Dios. ");
INSERT INTO jicNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pülücj 'a si mulú na jis la las, yupj quelel jatja noypan jatja nt'a. Judiopan 'a si mulú nt'a, quelel jatja co'müypan jatja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pülücj lyawun̈ nt'a, po jisas la p'a wa 'üsüs javelepj yupj jis lal, 'üsüspan jis lal javelepj jinwá. ‘Rabbí’ javelepj jisas. Nin jisas fariseopan. Nin jisas wa Moisés popel sin 'yüsa lajay. ");
INSERT INTO jicNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","”Malala nin. Malala nin yupj jisas la p'a wa ca mvelecj ‘Rabbí’ yupj jilal. Dios ma jos la p'a wa ca mvelecj ‘Rabbí’ nun jilal. Pjaní p'in nusin 'yüsa liji, Dios jupj. Nun pjü way nun sejatjampan, nun jis to'opan. ");
INSERT INTO jicNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Po ma tjowelé yom nosis casá pü'ü nupopay jupj, jupj pajal püné mpes. Pjaní p'in Nupopay. Dios p'in. Tsjun po'o pü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dios ma jos p'a wa javelepj nun 'ücj sin 'yüsa lojí p'a wa. Pjaní p'in nusin 'yüsa liji. Jupj niná Dios tjevele ca jas majamas nucopj la p'acj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nun popa pajal püné, jupj mozo jinwá ca nsem p'a wa mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jupj püné jin jola jupj p'iyá, Dios ca tsjicj way la mijis jupj. Jupj tsjicj jin jola jupj p'iyá, Dios ca püné la mijis jupj”, nin tjevele Jesús 'a jis tjimyula jis lal, jupj discipulopan jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jupj tjevele wa: “Malala ca nu mpalas, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. P'a wa nepenowá jisas Dios yupj jis Jepa nsem. Jisas ca 'üsüs jis mpalas Dios lal. Nun ma nujos niná. Nun lojí pajal costa way cus la con̈ Dios. Nun p'iyá ma nujos 'üsüs nu pyala Dios lal. Nun lojí wa yupj ma wa polel 'üsüs se palá Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”Ca malala nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Nun pwe'qué nequem jis wa, nequem jis vayum tecya'lin̈. Newa nun nujos la p'a 'üsüs jin yola nun po'ó, mpes pülücj way welé Dios lal pülücj pjyacan̈ nt'a. Nun nin lojí mpes, Dios ca mveles nun más malala la tjüjí la p'a jilal. Más ca nucopj ntülüs pjü jilal. ");
INSERT INTO jicNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”Malala ca nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Nun po nujos judiopan tulucj fariseopan ca nsem wa, nun jinwá. Pajal tsji' lojí ca pjaní way fariseo mpalas. Pjaní way fariseo tepyala na, nun pülücj si 'üsǘ lojí jupj. Niná jas tji'yüsa na, pajal malala jupj. Malala jupj Dios lal, nun jinwá. Más malala pyala jupj nun jis lal. 'Awa püné nt'a ca mim, mpem, pajal malala mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”Malala ca nu mpalas nun. Nun ma polel sin 'yüsa lojí Dios mpes. Nun p'iyá ma nusin 'yüsa tsjan jos Dios. Nun nuyun tulucj jinwá. Nun welé gente Dios wo lal jurar lajay na, nun ma nin nujola ncu t'üc' javelepj yupj. Nin tulucj jurar lajay na oro lal, niná oro Dios wo nt'a ja'asá. Oro lal jurar lajay na, nun nujola más 'ücj t'üc' javelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nun ma nujola jinwá lojí. Nuyun tulucj jinwá nun. Dios wo más 'üsüs oro lal. Niná oro pajal 'üsüs Dios wo nt'a já'asa mpes p'in. Nin mpes 'ücj tulucj ma t'üc' javelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nun welé wa gente jurar lajay mesa lal, mesa niná Dios ja'ayapj nt'a, nun ma nin nujola ncu t'üc' javelepj yupj. Nin tulucj jurar lajay na mesa niná casá ja'ayapj lal. Dios ja'ayapj lal jurar lajay na, nun nujola más 'ücj t'üc' javelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nun ma nujola jinwá lojí. Nuyun tulucj jinwá nun. Mesa niná más 'üsüs mesa casá ja'ayapj lal. Mesa casá ja'ayapj pajal 'üsüs mesa niná casá já'asa mpes p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nin mpes jurar lajay mesa niná lal, nin p'iyá niná yupj jurar lajay wa pjü way mesa casá já'asa lal. ");
INSERT INTO jicNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nin p'iyá jurar lajay na Dios wo lal. Dios wo lal jurar lajay, nin p'iyá niná yupj jurar lajay wa Dios lal. Jupj pü'ü jupj wo mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nin p'iyá jurar lajay na tsjun po'ó lal. Tsjun po'o lal jurar lajay, nin p'iyá niná yupj jurar lajay Dios jyü'ta nt'a lal. Nin p'iyá niná yupj jurar lajay Dios lal. Jupj p'iyá já'asa jupj jyü'ta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”Malala ca nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Nun tsjicj way p'in lojí Dios jyü'ta jin. Nun tsjutsj tsjictjacj siná popé 'oyá Dios mpes. Pjü way diez to'á popé, pjaní way 'oyá Dios mpes. Tsjutsj cilantro jinwá 'oyá wa Dios mpes, ajo jinwá 'oyá wa, comino 'oyá wa. 'Ücj wa nin lojí. Malala p'a wa ma lojí. Dios jos nun ca 'üsüs la müjí la p'a wa jis lal. Jupj jos nun ca jis capj mp'a'sá malala jis tepyala na yupj. Jos wa nun ca t'üc' la müjí nun welé jinwá. Ninana jupj Popel mo'o tjijyü'ta, ma la tjüjí nun. Jupj jos nun ca nin la müjí. Niná lojí na, mop'in ca ma'ayá wa nun to'á popé Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nun ma polel sin 'yüsa lojí Dios mpes. Nun p'iyá ma nusin 'yüsa tsjan jos Dios. Nuyun tulucj jinwá nun. Niná nun lojí Dios mpes, tsjicj way p'in Dios lal. 'Ücj wa ma lojí niná. La p'a wa Dios tjijyü'ta jupj po jos nun ca la müjí niná. Ninana nun ma quelel lojí. ");
INSERT INTO jicNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”Malala ca nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala wa ca nu mpalas nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Nunpan pocillo te way jinwá. Pocillo pje'á p'in so pü'í jinwá lojí nun. Plato 'ala'á p'in so pü'í jinwá lojí. Wa mo'ó pajal te custjay. Nin p'iyá nun. Lovin 'üsüs lojí la p'a januc na. Newa malala nun t'üc' way. Nun ts'üisiqué pajal. Nun malala quelel lojí, ne nin lojí wa niná. ");
INSERT INTO jicNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nun fariseopan ma nusin 'yüsa tsjan jos Dios. Nuyun tulucj jinwá nun. Nujola t'as ma ca malala la müjí. Nujisas t'as ca 'üsüs la müjí Dios jos jinwá. Ninana la tjüjí na, t'üc' way ca 'üsüs nsem nun. La p'a wa ca nucucj nun 'üsüs lojí. ");
INSERT INTO jicNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”Malala ca nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Nun 'amá jatoc nt'a jinwá. 'Amá jatoc nt'a 'üsüs justa pje'á. Wa mo'ó 'üsüs tulucj. 'Amá 'ala'á ne'aj patja tepe'e cjüele. Jüp'üy tjamaja ne'aj pü'ü wa. 'Amá jatoc nt'a wine ma nyuca niná. ");
INSERT INTO jicNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nin p'iyá la p'a wa ma januc nun malala. Yupj januc nun 'üsüs lojí yupj nt'a. Yola nun 'üsüs Dios lal. Nin tulucj. Nun malala nujola pajal. Ma 'üsüs way lojí, nun welé jinwá. Nun ma 'üsüs way quelel lojí Dios jos jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”Malala ca nu mpalas nun, Moisés popel sin 'yüsa lojí. Malala ca mpalas wa nun fariseopan. Nun nujos la p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Wosis tsjicj way su jünsǘ profetapan püna tapatja mpes, toc patja casá. 'Ücj lojí wa püna toctsja nt'a, 'üsüs witjacj jis p'üy patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nun welé: ‘Judiopan püna tapatja tjü'ünan profetapan. Cupj yupj jinwá tulucj. Ncupj püna cüpatjaquectsja, ma ca cü'ü'nactsja profetapan’, nin welé nun. ");
INSERT INTO jicNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nun p'iyá welé nun yupj popa p'iyá. Yupj popa p'iyá nun, mpes nin p'iyá lojí, yupj la tjajay jinwá. Püna tapatja jis tjü'ünan profetapan. ");
INSERT INTO jicNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ma pjü jis tjü'ünan custjay. Mpes ncawajas la müjí nun quinam. Nun ncawajas la müjí püna tapatja malala nyuca lajaytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”Malala nun, latsj jinwá. Nun cascabel sin popa jinwá. Pajal lu tsuwilí. T'üc' way Dios ca mveles nun malala la tjüjí. Ca mveles nun ca nlawú 'awa püné nt'a, mpem, malala nyuca la tjüjí mpes. T'üc' way ca nin mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nin mpes napj profetapan p'a wa ca sin majam nun nt'a, ca mvelecj yupj napj mpes. Ca sin majam niyom nepenowá, yupj pajal sin 'yüsa Dios mpes. Ca sin majam wa niyom nepenowá, yupj 'ücj nusin 'yüsa lajay Dios mpes. Yupj 'üsüs ca nsem, mop'in nin, nun ma ca nujos nsem yupj. Nun ca jis mü'ü'ná yupj nepenowá, ca jis mvalá yupj cruz po'ó. Nun pajal ca mo'o nsüpǘ nepenowá. Judiopan 'a si mulú nt'a ca nin la müjí. Ca pje'á la nts'iyá yupj nun potjaqué mpe. P'a nt'a jil na, pje'á la nts'iyá wa yupj nepé. ");
INSERT INTO jicNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nin ca la müjí nun, mpes Dios pajal ca nucopj ntülüs. Püna tapatja malala la tjajay mpes wa ca nucopj ntülüs nun. Püna tapatja tjü'ünan 'üsüs witjacj, yupj 'üsüstsja Dios lal. Mwalá way Abel tjü'ünan. Jupj 'üsüs waytsja Dios lal. Locopyaya pülücj way jis tjü'ünan. Judiopan tjü'ünan wa Zacarías, Berequías jatjam. Nun tjü'ünan jupj Dios wo nt'a. Mesa Dios mpes ja'ayapj nt'a ne'aj p'in tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dios ca jis capj ntülüs judiopan quina patjá pjü niná mpes. Püna tapatja la tjajay mpes wa ca jis capj ntülüs quina patjá. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”Nun Jerusalén mo'o potjaqué, profetapan su 'ü'ná lovin. Pe lo ts'iyaná Dios sin tjejyama sin po'ó, su 'ü'ná yupj. La pülücj napj quelel lejaytsja ca nun 'a nusí mulus napj nt'a. Castlyaj jupj tsjictjacj se t'olona, nin p'iyá quelel lejaytsja nun jilal. Nun ma jisastsja lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nusin tjü'üsüs niná. Dios ma nucopj cyon̈ca quinam nun potjaqué nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Napj ca mis quinam nun mpe. Nun ma quelel la nojí naya p'in, ma ca nus nucú. P'a jawas p'a casá nujola ca nsem nun. Nun ca mvelé napj nin po'ó: ‘Dios pajal 'üsüs ca la mijis jipj mpes. Dios mpes velen jipj, Dios ne cupj qjuis Jepa Püné.’ Niná tjowelé na, ca niswa ncuwis nun nt'a. T'üc' way ca nin nsem”, nin tjevele Jesús Moisés popel sin 'yüsa lajay jis lal, fariseopan jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús tjemey quinam Dios wo mpe. Jámatsja na, jupj discipulopan tjiquil jupj nt'a. Jisastsja jupj ca nucus wosis nepenowá ne'aj. Dios wo pjaní waytsja, wosis nepénowa Dios wo t'asiyú tjelejen̈ 'ots'ipj. Pjü way Dios mpestsja. Pajal 'üsüs way yustaptsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús tjevele yupj jis lal: —Napj nyuc wosis witjacj 'üsüs way yustapj. Tjunuca wa nun. Pjü way niná ca malala mpalas. P'a jyawca na judiopan jis enemigopan ca ncul. Yupj ca sin mojoyecj pjü way niná wosis. Pjü pwen ca palá la ncoyecj, wo la tjajay mpes. Pjü ca na'aj la ncoyecj, mpes pe pjaní ma ca p'a casá ma'ajam nsem. Niná t'üc' way —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yacjaya Jesús tjemey joc' 'ala'á, tucuc' Olivos ló nt'a. Jupj 'etjele ne'aj. Ne'aj p'intsja Dios wo ton̈ca nt'a. Jupj ne'aj tjá'asa na, jupj discipulopan tjiquil jupj nt'a yusapj. La tjü'üy jupj lal: —¿'Ona ca nin mpalas Dios wo nt'a, jipj tjevelen jin? ¿Tsjan ca la mijis Dios qjuisin 'yüsa la mijis jipj len̈ way ncuwim niswá? ¿Tsjan ca la mijis Dios qjuisin 'yüsa la mijis len̈ way ncawajas nosis casá pyalá? ");
INSERT INTO jicNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús jis wala tjevele: —'In tjajama. Pülücj ca ncul, ca la ntsawilicj gente jis lal. Po ma toponé yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yupj pjaní pjaní ca mvelecj yupj p'iyá Jepa niná Dios tjevele ca jas majamas jis capj la p'acj judiopan. Pülücj ca mponecj yupj javelepj. Po ma toponé nun. ");
INSERT INTO jicNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nun ca jus nlayé wa militarpan pülücj la palan p'a nt'a. Ca jus nlayé wa quelel la palan p'a jyawca na. Po ma locj tjeyá niná tepyala na. T'üc' way ca malala mpalas nosis nt'a. Custjay ma pjü tecyawaja niná malala tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Napj quelel cuwis na, ca pülücj la mpa'nacj. Nepénowa patja nt'a la mpa'nacj ca p'a nt'a patja jis lal. Ca jis mü'ü'nacj. Jepapan ca sin majamacj jis militarpan jis la palan p'a jepapan jis militarpan jis lal. Nepénowa patja nt'a ca pjü cjuwá nsem jis la las 'ots'ipj. Pajal ca jus nquits'is nosis pülücj jun ta'á 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pjü niná ca nin mpalas napj quelel cuwis na. Más malala ca mpalas wa nosis casá, napj cuy secj na p'in. ");
INSERT INTO jicNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”Niná pyala na, Dios ma jisas ca nu ntji'lin̈ nun nepenowá, ca malala la numijicj. Ca nin la mijicj nun ncapj con̈có mpes. Ca mü'ü'nacj nun nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Niná pyala na, nepénowa napj lal japon ma ca quelel ncapj ncon̈cocj. Yuwá p'in pajal ts'a 'in ca nsem. Ca malala mvelecj yupj sejatjampan sin po'ó jepa wolap'a'á, mpes jepapan ca jis ntji'lin̈ napj lal japon nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","La tsuwilpan pülücj ca ncul nun nt'a 'ots'ipj. Ca mvelecj yupj javelepj napj velé, mop'in la tsuwil yupj. Pülücj ca mponecj yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mpes napj lal japon pülücj ca malala nyuca la mijicj. Más malala ca la mijicj püna lal. Nin mpes ma ca quelel la sajay yupj sejatjampan. Nin ca mpalas yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Newa ma pjü way nun sin popé ca malala la mijicj yupj lajay jinwá. Nun nepénowa ca ncapj ncon̈có custjay. Newa ncapj con̈có, Dios ca la mijis nun 'ücj ca mpatjaqué jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","P'a wa ca mpalas wa napj quelel cuwis na. Nepénowa ca mal jun ta'á nosis nt'a. Nin p'iyá ca mvelecj nun welé jinwá. Ca mvelecj pjü jis lal pajal 'üsüs tepyala Dios 'üsüs la tjiji mpes. Ca mvelecj Dios ca müjü'tüs quinam nosis nt'a. Jun ta'á way patjá ca jus nlayecj wa niná, yupj javelepj mpes. Niná tjowelepj na jun ta'á, ca pjü way ncawajas nosis nt'a pyalá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesús tjevele wa yupj jis lal: —Nun ca nucú pajal malala nyuca la mijicj Dios wo nt'a. Nin mpes Dios wo pajal te jinwá ca mpalas Dios lal, yupj malala la tjajay mpes. Yupj malala lajay mpes wa, len̈ ca nsem ne'aj Dios wo nt'a. Nin p'iyá ca mpalas Daniel tjevele jinwá pajal püna. Profétatsja jupj, Daniel. Nun mo'o welé na niná, nusin tjü'üsüs tsjan mpes napj nin velé niná. Niná tjunucú na ");
INSERT INTO jicNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","más 'ücj Judea mo'o patja ts'equenen̈, joc' mo'o ca mal. Pajal malala ca mpalas Judea nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Judío pjaní jupj wo jay ntojom ca nacj, niná pyala na Dios wo nt'a. Más 'ücj jupj len̈ way ts'üequené. Ma ca pje'á la nts'iyas jupj juts'a'á jupj wo nepé. ");
INSERT INTO jicNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jupj sine lejen̈ mo'o ntojom ca nacj niná pyala na Dios wo nt'a. Más 'ücj jupj len̈ way ts'üequené. Ma ca wo nt'a mim jas quip lo ta'es. ");
INSERT INTO jicNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","”Niná pyala na, pajal malala ca nsem nequem way jatja jis lal, nequem tsjictjacj jatatj jis lal 'ots'ipj. Pajal malala ca mpalas Judea mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","La tjomoná Dios lal ma ca nin mpalas jive na. Más costa ts'üequenequé jive na. La tjomoná wa ma ca nin mpalas sábado na. Judiopan ma tsji' lajay sábado na. Más costa nsem ts'üequenequé sábado na. ");
INSERT INTO jicNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pajal malala ca la mijicj judiopan jis lal. Más malala ca la mijicj püna la tjajay lal. Niná t'üc' la tjajay na, ma ca nin p'iyá la mijicj lovin. Judiopan pajal 'aplijila ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","”Mpes Dios la tjiji ma ca ts'ac' pülücj nsem niná. Jupj ma ca jis ma'ayas yupj pjü malala la mijicj, yupj jisas jinwá. Dios ma la qjuijistsja niná, pjü way 'aca'lin̈tsja nosis casá. Dios ma jos ca pjü nca'lin̈. Jupj la t'ya nepenowá, jupj lal ca mpatjam. Yupj mpes ma ca ma'ayas ts'ac' pülücj ca malala mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”Malala tepyala na Judea mo'ó, nepénowa ca mvelecj Cristo tjac' quinam. Ca mvelecj: ‘Tjunuca nun. Qui'á já'asa niná Yomen Dios jas tjejyama qjuis capj la p'acj.’ Nin ca mvelecj ca nacj. ‘No'ompe já'asa’, ca mvelecj ca nacj. Nin javelepj nun jis lal, po ma toponé yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","La tsuwilpan nepénowa ca ncul. Nepénowa ca mvelecj yupj p'iyá Cristo. Nepénowa ca mvelecj yupj javelepj Dios mpes. La tsuwil p'in yupj. Yupj ca quelel yus ntsawilicj pjü way. Ca quelel yus ntsawilicj wa Dios lis t'ya jis lal. Nin mpes p'a casá ca la mijicj yupj, gente p'in ma polel lajay jinwá. Jisas la p'a yola yupj noypan yupj nin lajay mpes. Dios lis t'ya ma ca mponecj yupj jilal. ");
INSERT INTO jicNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Napj nasa tjevelé ca nin mpalas. Mpes nujola tapalas niná. ");
INSERT INTO jicNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","”Ma toponé yupj javelepj. La p'a ca mveles Cristo ne'aj já'asa ca nacj, jis wa cjuwá nt'a. Po ma nlawú ne'aj. Ca mveles Cristo pjo'na pülücj patja nt'a ca nacj. Po ma toponé niná. ");
INSERT INTO jicNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Napj cuwis na ca pjü jus nlayecj. Menmené la mena nt'a pjü se jawca liji, tsiquin mo'ó 'ots'ipj, t'yaja mo'ó 'ots'ipj. Nin p'iyá ca nsem napj tjacuwis na. Ca pjü nucucj. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vaca tepe'e jüp'üy pü'ü nt'a, ne'aj 'a jis mulus montes. Nin p'iyá ca nsem napj quelel cuwis na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ninana Jesús tjevele wa jupj discipulopan jis lal: —Malala ca mpalas nosis nt'a napj tjevelé jinwá. Niná t'üc' tepyala na, ‘len̈ way lots'ac' püste ca mpalas. Mümüy püste ca mpalas wa. Pjulacj ca palá jis ntüncüs tsjun mpe. La p'a wa noypan tsjun po'ó ca jus nquits'is.’ ");
INSERT INTO jicNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","”Niná tepyala na, napj ca lay ma palas tsjun po'ó. Nin mpes ca sin mü'üsüs la mejay napj tjacuwis quinam. Napj p'iyá niná Yomen Dios jas tjejyamá. Pjü gente nosis casa'á pajal ca la mpuyucj. Ca nucucj napj tjacuwis mol casa'á. Cuwis na, 'ücj ca müjütütj napj. Nosis casá patja ca jus nlayecj napj pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Trompeta la mpjusá. Yümücj pjac nsem pajal, ca pjü ncul napj nt'a napj lal japon. Napj lis t'ya yupj, ca napj lal mpatjam. Napj ca sin majam napj angelpan yupj nt'a, pjü jis lal la cuwis. Pjü nosis mpe jis lal ncul yupj. Pajal campa patja jis lal ncul wa yupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesús sin tji'yüsa lis tjiji jupj jos jupj lal japon la nucucj jupj ncuwim. Ninana tjevelá: —Nusin tjü'üsüs parábola niná mpes. Nujola t'as ts'oway po'ó. Lo quelel cyojo na, pjwel 'u'u way jupj. Jis lo tecyojo na, nun solejé len̈ way quelel jive. ");
INSERT INTO jicNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nin p'iyá nun ca nucú malala ca mpalas nosis casá, napj tjevelé jinwá. Nun niná tjunucú na, nun ca jus nlayé len̈ way ca ncuwis napj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pjü niná napj tjevelé, pjü ca mpalas. Judiopan newa mpatjam pjü tepyala na. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tsjun po'ó ca ncawajas, nosis ca ncawajas wa. Napj velé jin ma ncawajas ca lovin. Pjü tjevelé, pjü ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Napj ma ca mvelé 'ona ca nin mpalas niná napj velé. Pjü ma salejepj tsjan jawas ca nsem. Ma wa salejepj angelpan tsjun po'ó. Ma wa selé napj. Napj ne Dios Jatjam. Mpapay p'in selé. ");
INSERT INTO jicNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ca ncuwis niswá. Napj quelel cuwis na, nosis casá patja ma ca la ma nucucj. Ma ca yola mpalas len̈ way ca jis capj ntül malala lajay. Nin p'iyatsja püná, Noé tüpü'ü na. Püna tapatja ma topon Dios ca jis capj ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Custjay ma nin pyálatsja p'in, yupj ma japontsja ca malala mpalas. Newa jalatsja, newa myü'ün̈tsja. Newa wyayin̈tsja yupj. Lovin nin p'iyá lajaytsja. Nin p'iyatsja Noé barco wama tjemey jawas. ");
INSERT INTO jicNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma jus nlaytsja ca len̈ way malala mpalas. Yacjaya pajal püné tjive. T'yüna 'üsǘ, jis tjyama pjü way. Tecya'lin̈. Nin p'iyá ca nsem napj cuwis na. Ma ca yola jis mpalas napj cuwis. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Napj cuwis na, napj ca jis man nepenowá napj nt'a. Nepénowa ma ca jis man. Niyom mat'e 'a mulú me'elecj yupj jasin nt'a ca nacj, napj cuwis na. Pjaní way ca man. Pjaní wa ca ne'aj ntojom. ");
INSERT INTO jicNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nequem mat'e jun pjaní nt'a ncjocjocj ca nacj, napj cuwis na. Pjaní way ca man napj. Pjaní wa ca ne'aj ntojom. ");
INSERT INTO jicNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”Lovin nujola tapalas napj ca ncuwis. Nun ma solejé tsjan jawas ncuwis. Napj nun jis Jepa. ");
INSERT INTO jicNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nin p'iyá jupj wo 'esepj ma seletsja tsjan hora jactsja pwequepj püste na. Mpes ma tjejyama jupj wo. Wo ma tjejyama mpes, pwequepj wama tjac', tüpweca. Jupj jus cülayes catsja 'ona jactsja pwequepj, jupj cüjamas catsja wosis. Ma ca wama cuytsja pwequepj. Nin p'iyá nun lal. Nujola tapalas nun ma solejé 'ona ncuwis. ");
INSERT INTO jicNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mpes lovin ca la ma nucú napj. Lovin la müjí napj nu tjijyütütj. Napj cuwis na, nun ma ca jus nlayé niná jawas jyawca na ncuwis. Nun ca nujola nsem napj ma ca ncuwis custjay —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús p'a parábola tjevele wa yupj jis lal. Sin tji'yüsa lis tjiji ca 'üsüs tsji' la mijicj jupj mpes jupj len̈ na. Ninana jupj tjevelá: —¿Ncu namozopan 'üsüs way nun? Napj ca mvelé mozo 'üsüs way po'ó. Niná mozo la tjiji jupj patrón tjijyü'tá. 'Üsüs way si 'üsütsja jupj. Mpes jupj patrón la tjiji mozo niná jepa tepyala la p'a mozopan jis lal. Tjevele ca jis ma'ayas jis ve yupj jalá na. ");
INSERT INTO jicNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jupj patrón len̈ na, jomozo niná newa 'üsüs liji. Jupj patrón wo nt'a tjac' na, ca nucus jupj jomozo pjü la tjiji jupj tjevelá. Nin mpes 'üsüs ca mpalas mozo niná. ");
INSERT INTO jicNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jupj patrón ca mveles mozo niná ca pjü majamas jupj juts'a'á popé. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","”Mozo niná malala la qjuijis, p'a casá ca nsem jupj lal. Jupj patrón püs way len̈ ca nacj. Mpes jupj mozo jola ca nacj: ‘Napj patrón ma 'ucuy quinam’. ");
INSERT INTO jicNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Malala liji jupj ca nacj. Si süpǘ mozopan p'a wa. Wine wa jis tjemyona jis lal. Pajal püné lyaja jupj yupj jis lal ca nacj. Myona wa yupj jis lal ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","P'a jawas ncuwim jupj patrón. Mozo ma li nucú na ca ncuwim. Ma ca jus nlayes jupj ca ncuwim quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jupj patrón pajal ca cus ntülüs jupj, malala la tjiji mpes. Ca cus ntülüs jupj, la p'a malalapan si tülǘ jinwá. La p'a malalapan jisastsja la p'a wa ca nin yola yupj 'üsüs, yupj lajay mpes. Newa 'üsüs tulucj yupj. Yupj jis lal mpü'üm mozo malala. Ne'aj pajal ca la mpuyucj. Jis wis ca jas nqui'licj. Nin p'iyá ca malala nu mpalas nun, nun malala la cüjí napj len̈ na —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús parábola p'a wa tjevele jupj discipulopan jis lal. Sin tji'yüsa lis tjiji yupj ca 'ücj la mijicj jupj jac' mpes. Ninana Jesús tjevelá: —Napj ca mvelé tsjan ca mpalas nosis casá napj quelel cuwis na. Nin ca nsem Dios jyü'ta mpes. Pülücj way quelel patja Dios lal. Yupj tsjücjüimpan diéziya jinwá. Tsjücjüimpan niná sejamica tjowaya. Yupj quelel jiltsja wa sejamica voyum wo nt'a, nlajacj yupj jis lal. Nin mpes tjil tsjücjüimpan jümücj nt'a la nyüjüsün̈ sejamica voyum. Quelel jiltsja jupj lal, jupj wo nt'a. Pǘstetsja. Candil jatatsja yupj, jis jaw jis la jay. ");
INSERT INTO jicNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tsjücjüimpan cínquiya ma yola jinwá lajaytsja yupj. Cínquiya 'üsüs way yólatsja. ");
INSERT INTO jicNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma yola witjacj candil jatatj watsja yupj. Mop'in ma tucutj aceite, candil pwe mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Üsüs yola witjacj jatatj watsja candil witjacj. Aceite tucutj wa jis botella mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sejamica voyum püs way len̈tsja. Mpes tsjücjüimpan pjü ja sívetsja. Pjü way tjijinan̈. ");
INSERT INTO jicNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","”Püste culupwen nt'a nepé vele pjactsja: ‘Qui'á jac' jupj, yomen. Nculá la müjüsüqué jupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mpes pjü way yola tepyala pjü tsjücjüimpan. 'Ücj la tjajay yupj jis candil witjacj mwalaquem mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma yola witjacj tjowelepj 'üsüs yola jis lal: ‘Aceite qjuis tja'ayá ncupj, nun to'á popé. Cupj qjuis candil cya'lin̈ quinam.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Üsüs yola witjacj tjowelepj: ‘Ma polel nu 'yayacj nun. Ma t'üc' way ton̈ca quinam nun mpes, ncupj mpes wa. Lowa nun aceite vender lajay nt'a. Ca jaylacj la müjí nun mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","”Mpes yupj tjil, aceite jaylacj la tjajay. Tjil na, ne'aj tjac' sejamica voyum. Tsjücjüimpan 'üsüs yola witjacj nasa jus tjümǘ yupj jis candil witjacj. La nuctsja jupj. Mpes yupj tjil sejamica voyum lal, jupj wo nt'a. Wama tjil jis la las tjewyayin̈ jis lal. Wama tjil na, jun t'yo'na jun vilicj. ");
INSERT INTO jicNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","”Yacjaya tjiquil wa tsjücjüimpan ma yola witjacj. Ne'aj lejen̈tsja pje'á. Tjowelepj: ‘Jun tjecjyoltse quinam. Nasa tjiquilaca ncupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sejamica voyum tjevele: ‘Napj ma nujus nyuc nun, pjacj cuscú. T'üc' way.’ Yupj ma polel wama jiltsja —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Nin p'iyá ca nsem napj cuwis na —tjevele—. Mpes lovin nujola tapalas napj ca ncuwis. 'Ücj la müjí ca 'üsüs nsem nun Dios lal, napj cuwis na. Nun ma solejé 'ona ncuwis —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús niswa tjevele jupj jostsja jupj discipulopan ca 'üsüs la mijicj jupj len̈ na. Tjevele: —Napj yom campa jama jinwá lejay. Niná yom tjevele ncul jupj jomozopan. Tjevele jupj jostsja jupj t'emel más pülücj way mpalas jupj len̈ na. Mpes pjü jis tje'yaya t'emel. Tjevele ca jaylacj la mijicj t'emel lal. Yupj jaylacj la tjajay ca vender la mijicj más 'in pülücj jaylacj. Mpes más pülücj mpalas t'emel. Pjü t'emel niná jis patrón juts'a'á nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yom niná seletsja mozo pjaní 'üsüs vender líjitsja. T'emel pülücj tje'yaya jupj. Seletsja la p'a wa 'ots'ots' way vender lajaytsja. T'emel más 'in pjaní way jis tje'yaya yupj. Mpes tje'yaya mozo pjaní peso cinco mil. Tje'yaya mozo p'a wa peso mil mat'e. Tje'yaya wa mozo p'a wa peso mil p'in. T'emel jis tje'yaya na, tjemey jupj quelel jámatsja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Len̈ way tjemey mozo mwalá way. Jaylacj la tjiji jupj patrón tjevele jinwá. Niná vender la tjiji. Nin mpes p'a wa peso cinco mil nt'ya, vender la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","P'a wa mozo peso mil mat'e tyá'atsja. Nin p'iyá la tjiji jupj, cinco mil tyá'atsja la tjiji jinwá. Nin mpes p'a wa peso mil mat'e nt'ya, vender la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mozo p'a wa peso mil p'in tyá'atsja. Jupj ma jaylacj la tjiji jupj patrón tjevele jinwá. Jusapj tjemey jupj. 'Amá tyoca, jul tjepjya'na jupj patrón t'emel. ");
INSERT INTO jicNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Locopyaya pajal püs tepyala na, mozopan jis patrón tjac' niswá. Jupj la tji'yüya jupj mozopan jis lal nol natj t'emel, jupj t'emel mpes, jupj jis tje'yaya mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mozo mwalá way tjac'. Teque'e niná peso cinco mil jupj patrón tje'yayá. Teque'e wa p'a wa cinco mil jupj nt'ya vender la tjiji mpes. Jupj tjevele jupj patrón lal: ‘Tjinyuca ma'a. P'a wa cinco mil netj napj jipj mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","”Jupj patrón 'ücj jostsja jupj lal. Tjevele: ‘Namozo 'üsüs way jipj. Napj tjevelé jinwá la tjejay jipj. Nin mpes ca 'üsüs la mejay napj jipj mpes. Más püné ca nsem jipj quinam. Jipj 'üsüs la tjejay t'emel tsjicj way lal. Pülücj way napj nats'a'á ca majaman jipj quinam. Was, 'ücj jyas nsem quinam napj lal’, nin tjevele jupj patrón. ");
INSERT INTO jicNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”Nin p'iyá tjac' wa mozo p'a wa, jupj ne peso mil mat'e tyá'atsja. Jupj tjevele jupj patrón lal: ‘Jipj ntje'an peso mil mat'e. Tjinyuca ma'a. P'a wa mil mat'e netj napj jipj mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","”Jupj patrón tjevele jupj lal: ‘Namozo 'üsüs way jipj. Napj tjevelé jinwá la tjejay jipj. Nin mpes ca 'üsüs la mejay napj jipj mpes. Más püné ca nsem jipj quinam. Jipj 'üsüs la tjejay t'emel tsjicj way lal. Pülücj way napj nats'a'á ca majaman jipj quinam. Was, 'ücj jyas nsem quinam napj lal’, nin tjevele jupj patrón. ");
INSERT INTO jicNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”Locopyaya p'a wa mozo tjac', jupj ne peso mil tyá'atsja. Jupj tjevele jupj patrón lal: ‘Napj seletsja ts'üis jipj. Tjevyala jequetj jipj ma jisin mpe. Wya nt'a 'yonson jipj ma tsji' la tjejay mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nin mpes napj lecj tjeyá jipj lal. Tjum, tjepjyalen jipj t'emel 'amá jul. Tjinyuca ma'a. Qui'á já'asa jipj t'emel.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","”Jupj patrón tjevele jupj mozo lal: ‘Malala nyuca jele jipj. Pajal 'e pjasá. Jipj tjevelen jipj selen ts'üisis napj. Jipj tjevelen napj tjevyala jequetj napj ma jisin mpe. Tjevelen napj nawá nt'a 'yonsó napj ma tsji' la tjejay mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jipj tjevelen selen niná. ¿Tsjan mpes ma prestar la tjejay nt'emel banco nt'a, más 'in pülücj mpalas t'emel? Jipj nin la cüjaytsja, napj cüt'anquetsja napj nt'emel napj tjacuwis na. Cüt'anqué watsja p'a wa t'emel, napj nt'emel prestar la tjejay mpes’, nin tjevele jupj patrón. ");
INSERT INTO jicNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","”Jupj patrón tjevele wa jomozopan p'a wa jis lal: ‘No'oté napj nt'emel jupj mpe. Tja'ayá t'emel niná namozo p'a, jupj ne peso cinco mil nt'ya. Jupj 'üsüs la tjiji mpes jupj peso cinco mil nenem diez mil tepyala quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Ücj wa p'a wa t'emel 'ya jupj. Nepénowa 'üsüs lajay napj jis tje'yá mpes. Mpes más pülücj ca jis ma'ayá yupj. Ca yupj pülücj way ca nta'acj. Nepénowa nin tulucj. Liji secj yupj napj jis tje'yá mpes. Mpes napj ca nt'anqué yupj jatatj. Püna pjaní way jatatsja, cjuwá ca nsem quinam.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jupj patrón tjevele wa jupj jomozopan jis lal: ‘Pje'á la nts'iyá nun niná mozo malala. Na'aj la nts'iyá jupj püste nt'a. Ne'aj gente ca la mpuyucj. Jis wis nqui'licj nepé vyaja mpes’, nin tjevele yupj jis patrón. Nin p'iyá ca nsem namozopan jis lal, jupj jomozopan jinwá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús tjevele wa tsjan ca mpalas gente jis lal, jupj nasa tjac' na. Ninana tjevelá: —Napj p'iyá niná Yomen Dios jas tjejyamá. Napj niswa ca ncuwis nosis nt'a. Napj nasa tjacuwis na, pajal püné nsem napj, Mpapay Dios jinwá. Pjü Dios angelpan ca ncapj ncon̈cocj. Tjacuwis na, Jepa Püné ca nsem napj. Ca mo'os, müjütütj. Pajal 'üsüs majawaques ne'aj Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pjü gente pjü jun ta'á patja mpe ca 'a jis mulus napj 'os nt'a. Oveja jyama liji jinwá ca la mejay napj yupj jis lal. Oveja jyama nyuca cabro lejen̈ wa oveja jis lal. Mpes sin tjan jyünsa oveja witjacj, sin tjan jyünsa wa cabrú. Nin p'iyá ca la mejay napj 'üsüs lajay jis lal. Sin tjan ca jis müjünsǘ yupj la p'a wa mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'Üsüs lajay ca jis müjünsǘ napj li'inyampe. Malala lajay ca jis müjünsǘ napj nancupwepe. ");
INSERT INTO jicNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”Napj Jepa Püné nsem pjü jis lal. Ca mvelé napj li'inyampe lejen̈ jis lal: ‘Nculá nun. Mpapay la tjiji pajal 'üsüs nu tepyala nun. Newa 'üsüs jotjaqué. Nun ca jepapan nsem, napj jinwá. Pajal püna Dios 'ücj la tjiji ca nin nu mpalas nun. Nosis la tjiji na, 'ücj la tjiji niná nun mpes. Nun jupj ts'uyupan, mpes nin la tjiji nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nun ca jus cülayé niná, nun 'üsüs la tjüjí mpes. Napj vecj ni pü'itsja na, nun nta'ayá tjelyá. Napj 'üsǘ nívetsja na, nun 'üsǘ toco'á tjümü'üs. Napj p'a nepé tjacuwis na, nun ntja'ayá la püt'üs la jas nun nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Napj pülül cjuwatsja na, nun nta'ayá pülül. Malala najastsja na, nun ntjajamá napj. Cawilta mo'o tjo'os na, nun tjuculá nus la nuc.’ Nin ca mvelé 'üsüs lajay jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”Niná tjevelé na, 'üsüs lajay ca nla mü'üyacj napj lal: ‘Qjuis Jepa, ¿'ona jis tjinyucucj vecj 'i pü'itsja? Ma selecj 'ona tje'yayacj tjelyan. ¿'Ona jis tjinyucucj 'üsǘ 'ívetsja? Ma selecj 'ona teque'acj tjümüs. ");
INSERT INTO jicNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿'Ona jis tjinyucucj jipj p'a nepé tjacuy? Ma selecj 'ona tje'yayacj la püt'üs la jas jipj. ¿'Ona jis tjinyucucj jipj pülül cjuwá? Ma selecj 'ona tje'yayacj pülül. ");
INSERT INTO jicNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿'Ona jis tjinyucucj malala jyastsja? ¿'Ona jis tjinyucucj jipj cawilta mo'o jactsja? ¿Ncu tjeleque jis la nuc niná tepyala na?’ 'Üsüs lajay nin ca nla mü'üyacj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”Napj Jepa Püné ca nsem pjü jis lal. Napj ca mvelé yupj jis lal: ‘Nun 'üsüs la tjüjí mpülücj pjaní lal, nin p'iyá niná nin la tjüjí wa napj lal. Mpülücj niná más 'in tsjicj waytsja pjü jis lal ca nacj. Nin p'iyá pajal 'üsüs napj lal nun 'üsüs la tjüjí jupj lal. T'üc' niná.’ ");
INSERT INTO jicNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”Nancupwepe lejen̈ jis lal ca mvelé wa. Ca mvelé: ‘Lowa napj mpe. Dios nasa tjevele ca nucopj ntülüs, malala la tjüjí mpes. 'Awa püné nt'a lowa, ne'aj ca mpem lovin. Ne'aj pwe quinam cus la tül diablú, jis capj la tül wa ángel malalapan. Yupj diablo jomozopan. ");
INSERT INTO jicNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","'Ücj napj nucopj tyül, nun malala la tjüjí mpes. Napj vecj ni pü'itsja na, nun ma nta'ayá tjelyá. Napj 'üsǘ nívetsja na, nun 'üsǘ ma toco'á la müs. ");
INSERT INTO jicNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Napj p'a mpe tjacuwis na, nun ma ntja'ayá la püt'üs la jas nun nt'a. Napj pülül cjuwatsja na, nun ma ntja'ayá pülül. Malala najastsja, cawilta mo'o tjo'os 'ots'ipj, mop'in ma quelel ntjajamá.’ Nin ca mvelé yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”Niná tjevelé na, ninana ca yupj mvelecj: ‘Qjuis Jepa, ¿'ona jis tjinyucucj jipj vecj 'i pü'itsja? ¿'Ona jis tjinyucucj jipj 'üsǘ 'ívetsja? ¿'Ona jis tjinyucucj p'a mpe tjacuy? ¿'Ona jis tjinyucucj jipj pülül cjuwatsja? ¿'Ona ma quelel 'e jamactsja, jipj malala jyastsja na, jipj cawilta mo'o jactsja wa na?’ Nin ca mvelecj yupj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”Napj ca mvelé yupj jis lal: ‘Nun ma 'üsüs la tjüjí mpülücj pjaní lal, nin p'iyá niná nun ma wa 'üsüs la tjüjí napj mpes. Mpülücj niná más 'in tsjicj waytsja pjü jis lal ca nacj. Nin p'iyá malala niná, nun ma 'üsüs la tjüjí jupj mpes. T'üc' way.’ Nin ca mvelé yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”Niná tjevelé na, yupj ca mal napj jis capj tyül nt'a. Yupj ne'aj mpatjam lovin. Nin tulucj 'üsüs witjacj jis lal. 'Üsüs Dios lal ne ca yupj mpatjam Dios lal lovin —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús tecyawaja tjevele quinam tsjan ca mpalas jupj niswa jac' na. Niná t'üc' tjevele na, tjevele wa jupj discipulopan jis lal: ");
INSERT INTO jicNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ts'ac' mat'e na fiesta ca nsem, niná fiesta ‘Dios Qjuis Capa Nipj Tjemey’ ló cupj qjuis lal. Nun solejé niná. Fiesta lajay na, yupj ca ma tjililin̈, ca ma manucj ma 'ünan nt'a. Cruz po'o ca ma valacj napj. Napj p'iyá niná Yomen Dios jas tjejyamá”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nasa jupj véletsja na niná, sacerdote noypan 'a jis tjimyula watsja Moisés popel sin 'yüsa lajay jis lal, co'müypan judiopan sin popé jis lal 'ots'ipj. Ne'aj 'a jis tjimyula sacerdote más püné wo nt'a. Niná sacerdote más püné Caifás lotsja. ");
INSERT INTO jicNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yuwá p'in tjowelepj 'onin ne 'ücj ntji'lin̈ Jesús, la p'a wa ma jus cülayecj. Yupj quelel tji'lin̈tsja jupj, la 'ünan. ");
INSERT INTO jicNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yupj tjowelepj: “Ma ntjiliquem ca jupj judiopan fiesta lajay na. Cupj niná la qjuijicj, yupj ts'i mi'inacj ca pajal. 'A jis mulus ca, la mpa'nacj ca cupj qjuis lal. Yupj po jisas Jesús”, nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania mo'o tjemey, ne'aj p'in Jerusalén nt'a. Simón wo nt'a tjemey. Niná Simón malala jostsja püná. Jupj poloc' mójotsja. Jesús Simón wo nt'a tjá'asa na, ");
INSERT INTO jicNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","quepj tjac' jupj nt'a 'üsüs lo jay jupj mpes. Botella pajal 'üsüs jústatsja teque'e jupj. Niná botella pe mpestsja, pe alabastro ló. Perfume botella jul tón̈catsja, perfume pülücj jaylactsja. Niná perfume Jesús jay pjucj po'ó t'yu. 'Üsüs cjúmsutsja. Jesús ne'aj já'asatsja na, lyájatsja na, nin la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jupj discipulopan tjunuc quepj nin la tjiji niná. Tjunuc na, ts'a tji'in yupj. —Malala nin —tjowelepj yupj—. Pjü way jay pjucj po'ó t'yu. Tjapjaja perfume. ");
INSERT INTO jicNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","'Ücj vender la qjuijis jupj. Ca pülücj jaylacj nactsja. T'emel 'ücj así cü'ayas t'emel cjuwá jis lal —nin tjowelepj discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús jus nleya yupj malala tjowelepj quepj la tjiji mpes. Jupj la tji'yüya jupj discipulopan jis lal: —¿Tsjan mpes so velelé quepan? Pajal 'üsüs la tjiji jupj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cjuwá jis lal mpatjaqué nun lovin. Napj ma ca mpü'üs nun jis lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma pats' ca napj. Nin mpes perfume t'yu jupj nay pjucj po'ó. 'Ücj la ntjiji yupj ca ntoquecj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Napj lal japon ca mal nosis jun ta'á. Ne'aj ca mvelecj la p'a jis walap'a'á Dios 'üsüs la tjiji gente mpes. Jun ta'á yupj jil nt'a, ca mvelecj wa quepj niná 'ücj la tjiji napj mpes. Ma ca yo' mpa'is. T'üc' way —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Locopyaya Judas Iscariote tjemey sacerdote noypan nt'a. Judas apostolpan dóceya sin pópatsja. ");
INSERT INTO jicNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jupj tjevele 'ücj wa jis lal ca mim la tjilil Jesús. —¿Nol ma'ayá nun, napj nin lejay mpes? —nin la tji'yüya jupj. Yupj tja'ayapj jupj t'emel c'a tréinteya, plata waytsja yupj, t'emel c'a. ");
INSERT INTO jicNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yupj jaylacj la tjajay na, tjemey. La nuctsja 'ona 'ücj jis lal la winin la tjilil Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ts'ac' mwalá way tjejyawca fiesta mpes. Niná fiesta lajay na, pan levadura cjuwá jalá. Fiesta “Dios Qjuis Capa Nipj Tjemey” lotsja. Nin jawas Jesús discipulopan tjiquil jupj nt'a. La tjü'üy: —¿Ca'aj jyas cupj 'ücj lijicj ca nlajan fiesta mpes? ");
INSERT INTO jicNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jupj tjevele: —Lowa pülücj patja nt'a. Yom napj velé nt'a ca nlawú. Nun ca mvelé: ‘Jesús tjevele len̈ way ca mpa'is. Jupj ca nlajas jipj wya nt'a jupj discipulopan jis lal fiesta mpes. Ca quiyola mpalas Dios jis capj tjep'ya'sa judiopan pajal püna.’ Nin ca mvelé nun jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mpes tjil discipulopan. Nin la tjajay Jesús tjevele jinwá. 'Ücj la tjajay jis la las fiesta mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Püste na Jesús já'asatsja, lyájatsja jupj discipulopan dóceya jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jalatsja na, jupj tjevele: —Nun popa pjaní malala nyuca la mijis napj lal. Jupj ca jis lal ncuwim napj enemigopan, ca yupj ma tjililin̈. T'üc' way ca nin mpalas —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mpes pajal 'aplijila jis tepyala. Pjaní pjaní tjowelepj: —Jipj napj Nejepa. ¿Ncu napj ca nin la cüjay? ");
INSERT INTO jicNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús tjevele: —Nun popa pjaní tjelyaja wa napj mplato mpe, la p'a wa jinwá, mop'in nin, jupj quelel malala liji napj lal. Jupj ca jis lal ncuwim napj enemigopan ma tjililin̈. ");
INSERT INTO jicNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Napj p'iyá niná Yomen Dios jas tjejyamá. Pajal püna profetapan tapac ca nin ma palas napj. Yupj tapac jin p'iyá ca nsem. Ma pats' ca napj, yupj tapac jinwá. Mop'in pajal malala nin, jupj ca jis lal ncuwim napj enemigopan, ca ma tjililin̈. Pajal malala ca mpalas jupj, jupj malala la niji mpes. Pajal malala ca mpalas jupj, mpes más 'ücj ca nactsja jupj lovin ma pǘ'ütsja —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas p'iyá nasa quelel jámatsja jis lal jac' Jesús enemigopan. Judas la tji'yüya wa quinam: —Rabbí, ¿ncu napj ca nin la cüjay? Jesús jupj wola tjevele: —Nin. ");
INSERT INTO jicNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yupj jalatsja na, Jesús nt'ya pan pjaní. Tjevele Dios lal tjüwüi'i pan tje'yaya mpes. Nin la tjiji na, vitvitj la tücüeme, jis tje'yaya discipulopan. Jis tje'yaya na, tjevele: —No'oté, nlajá. Niná pan napj mp'üy jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tjalá na, jupj nt'ya wa pocillo, uva 'üsǘ mo'o tón̈catsja. Tjevele Dios lal tjüwüi'i wa uva 'üsǘ tje'yaya mpes. Pocillo jis tje'yaya jupj discipulopan, vitvitj jis la müs pjü. —Tjümüsiqué napj pocillo mpe nun pjü way —tjevele jupj—. ");
INSERT INTO jicNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Niná uva 'üsǘ napj na'as jinwá. Ma pats' ca napj nun mpes, la p'a pülücj mpes wa. Napj ca 'as ma palas, mpes Dios ca perdonar lis mijis napj lal japon. Ma ca jola nsem yupj malala la tjajay. Mpapay tjevele t'üc' ca nin la mijis yupj mpes napj ntipü'í na. ");
INSERT INTO jicNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Napj lovin ma ca mü'üs uva 'üsǘ niswá quinam. P'a jawas cupj 'a mulú mpatjaquecj Mpapay jyü'ta nt'a. Nin jawas tjejyawca na, niswa ca mü'üs napj nun jis lal. T'üc' way —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yacjaya tjenejets'en̈ Dios po'ó. Lovin nin lajaytsja fiesta mpes. Tjenejets'en̈ na, tjil. Joc' Olivos ló nt'a tjil. ");
INSERT INTO jicNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tjil na, Jesús tjevele jupj discipulopan jis lal: —Püste na, nun pjü ca nts'equenequé, malala ne palá na. Nasapj mo'os. Pajal püna profeta tepyaca ca nin mpalas. Niná tepyacá: ‘Napj ca mü'ünan oveja jyama, mpes jupj oveja witjacj sin tjan ca mal’. Nin tjevele profeta ca nin mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Newa nin ca 'üsüs la mejay nun mpes. Napj ca nin müjünsǘ la püt'üs niswá. Niswa pü'üs na, ca mis Galilea nt'a. Napj mwalá way ca mis nun jis lal, cupj ca la müjüsüquecj ne'aj —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro jupj wola tjevele: —Pjü ca nts'equenen̈ ca nacj, malala 'e palá na. Napj ma nin la mejay. Lovin ma ca malala la mejay jipj lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús tjevele Pedro lal: —Yacjaj püste p'iyá la con ca mvelen ma nus nyuc. Castlyaj cocoy ma la tipiya p'in, ca nin la mijin jipj. T'üc' way niná —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro tjevele ma ca nin la mijis. —Napj 'ücj wa ni pü'í jipj lal —tjevele—. Lovin ma ca mvelé ma jis nyuc. Nin p'iyá tjowelepj wa pjü discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús pje'á tjemey jupj discipulopan jis lal sine lejen̈ nt'a. Getsemaní ló ne'aj. Ne'as tjemey na jupj tjevele yupj jis lal: “Ne'aj p'in ca mis, ca mvelé Mpapay Dios lal. Nínawa majatjaqué velé na jupj lal”, tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Discipulopan cont'e jis lal tjemey jupj jámatsja nt'a. Pedro pjaní watsja. Zebedeo jatjampan mát'eya tjil watsja. Pajal 'aplijila tepyala Jesús. Pajal jola tepyala malala ca mpalas mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tjevele yupj jis lal: “Nasa ni pü'í jin najas, pajal 'aplijila mpes. Qjuive la tjunucú. Po ma müjünaqué, ma nyucun nsem nasapj”, nin tjevele Jesús yupj conas lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jupj tsjicj way p'in mwalá tjemey jusapj. Palá nipi'tje 'amá 'alá. Tjevele Popay Dios lal: “Mpapay, ¿ncu 'ücj wa jipj lal napj ma ni pü'í? Jipj 'ücj polel lejay niná, najas ma ca nin ma palas. Newa najas ca jipj jyas jinwá nsem. Ma napj najas jinwá t'as”, nin tjevele Jesús jupj Popay lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","T'üc' tjevele na, tjemey niswá discipulopan cónt'eya tjatja nt'a. Tjinyuca tjijinan̈ yupj quinam. “¿Ncu nun ma polel nucunú napj lal hora pjaní way p'in? —nin tjevele Jesús yupj jis lal—. ");
INSERT INTO jicNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ma müjünaqué. La tjomoná Dios lal ma ca malala la müjí, nun quelel malala lojí na. Napj selé nun quelel lojí napj najas jinwá. Mop'in pajal costa nun jis lal, nun niyom p'in”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tjevele na, tjemey niswá. Tjevele Popay Dios lal: “Mpapay, 'ücj tulucj ma ni pü'í. Jipj jyas nin ne palá. Ntipü'í na p'in ca 'ücj nsem. Najas ca nin nsem, jipj jyas jinwá”, tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jupj niswa tjemey jupj discipulopan cónt'eya tapatja nt'a. Niswa yus tjinyuca tjijinan̈ yupj. Pajal ja sívetsja. ");
INSERT INTO jicNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mpes niswa tjemey la veles jupj Popay Dios lal. La con quinam tjevele Dios lal. Nin p'iyá tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","T'üc' tjevele na, tjemey niswá jupj discipulopan nt'a. La tji'yüya: “¿Ncu potjaqué, jünaqué custjay? Quina ca mpalas napj tjevelé jinwá. Najamica pjaní jis lal ncuwim napj enemigopan, ca ma tjililin̈. Malala lajay ca malala la ma jicj, yupj jisas jinwá. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nusin tjüjünsǘ. Mas quinam la müjüsüquecj yupj. Nasa jac' quinam yom malala la niji. Jis lal jac' napj enemigopan”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús niná véletsja na, ne'aj tjac' Judas. Jupj apostolpan dóceya popa watsja. Se cón̈catsja Jesús. Niyom pajal pülücj tjiquil Judas lal quinam. Pjü way polomay jatatsja, yo pjwel jatatj watsja mo'o la süp Jesús. Sacerdote noypan sin tjajam yupj la tjilil Jesús. Co'müypan judiopan sin popé sin tjajam wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas jis lal tjac' la tjilil Jesús. Jupj nasa tjevéletsja ca sin 'yüsa la mijis cana Jesús. Tjevele: “Pjaní lal ca la nlapan napj. Niná ne Jesús. Ntjüiliqué jupj.” ");
INSERT INTO jicNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mpes ne'aj tjemey Judas, Jesús nt'a p'in. Ne'as tjemey, 'üsüs tjevele jupj lal, quelel la tjiji jinwá. Tjevele: —Nejepa, tjacuwis quinam. ");
INSERT INTO jicNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús tjevele jupj lal: —Najamica, napj selé tsjan mpes tjacuy. Jesús nin tjevele na, p'a wa niyom ne'as tjiquil. Ntji'lin̈ Jesús, jis la man jupj jepapan nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nin la tjajay na, Jesús discípulo pjaní polomay nt'ya, syults'a jupj vaina mpe. Jay tjejyo'o yom pjaní. Yom niná mozo waytsja, sacerdote más püné mpes. Pjots' taná tjejyo'o jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús tjevele discípulo lal: —Vaina mo'o jas tjejyama jipj polomay. Polomay mpes la palan, cya'lin̈ wa polomay mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Napj ma ca la mpalan yupj jis lal. Napj 'ücj la cümon Mpapay ncapj la p'acj. Napj la cümon Mpapay lal, jupj ca ángel militarpan pülücj sin cüjamas napj nt'a, la cüpa'nactsja napj enemigopan jis lal. Más 'in pülücj yupj setenta mil lal. ¿Ncu ma jin 'yüsa niná? ");
INSERT INTO jicNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma ca nin la mejay. Niná la cüjay napj, ma ca cüpalas Dios Popel tjevele jinwá. Dios Popel tjevele yupj ca nin la mijicj napj lal —nin tjevele Jesús jupj discípulo lal. ");
INSERT INTO jicNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nin tjevele na, tjevele wa jupj ntji'lin̈ jis lal: —¿Tsjan mpes polomay t'o, yo pjwel t'o wa la tjilil napj? Niná lojí pwequepj la tjilil. Pjü jyawca Dios wo nt'a tjo'ostsja napj. Napj sin 'yüsa la tjejay ne'aj. Lovin ma ntjutjililiqué ne'aj tjo'os na. ");
INSERT INTO jicNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Niná pjü tepyala ca nin mpalas profetapan tapac pajal püna. Yupj tapac, Dios Popel jupj —tjevele Jesús. Nin tjevele na, pjü ts'equenen̈ jupj discipulopan. Jesús ne'aj tón̈catsja tjil. ");
INSERT INTO jicNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nasa ntji'lin̈ Jesús. Yupj tjaman jupj Caifás nt'a. Caifás sacerdote más pünetsja. Nasa 'a jis tjimyula ne'aj Moisés popel sin 'yüsa lajay. Co'müypan judiopan sin popé 'a jis tjimyula wa ne'aj, Caifás wo nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro Jesús cjüil tjemey campapé. Ne'as tjemey wa jupj sacerdote más püné wo nt'a. Tjüwücj jun vilicj po'ó tjac' Pedrú. Tjüwücj nt'a wama tjemey wa. 'Etjele jupj militarpan nepénowa jis lal. Quelel nyúcatsja tsjan ca mpalas Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne'aj jatja watsja sacerdote noypan. Ne'aj jatja watsja judiopan jis jepapan. Yupj 'a mulú jajütütj judiopan. Yupj pjü la tjü'üy tjunuc pjacj malala mveles Jesús po'ó. La tapal watsja pjacj ca la ntsawilis Jesús po'ó. Po quelel javeleptsja 'ücj cus la tül jupj. Quelel ja'ünantsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pülücj tjiquil yupj jis walap'a'á la tsuwil Jesús po'ó. Newa la tsuwilpan ma nin p'iyá javeleptsja. Mpes jepapan ma polel cus tül Jesús yupj tjowelepj mpes. Pjaní p'in t'ya tjevele mpes, ma polel cus tül jupj. Yacjaya niyom mat'e tjiquil yupj jis walap'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Niyom mat'e tjowelepj: —Yom niná tjevele jupj 'ücj malala liji Dios wo. Tjevele ts'ac' cont'e na t'üc' ca jas müjünsüs niswá. ");
INSERT INTO jicNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Niná tjowelepj na, sacerdote más püné jas tjijyünsa, tüwütüwǘ ton̈ca. La tji'yüya Jesús lal: —¿Ncu ma ca qjuis lal mvelen ncu t'üc' way nin tjevelen? Yupj javelepj yupj salejepj jipj malala tjevelen —nin tjevele sacerdote más püné. ");
INSERT INTO jicNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Newa lyájasa tón̈catsja Jesús. Sacerdote más püné tjevele jupj lal: —Napj 'i jütütj jipj ca t'üc' mvelen. Dios pjoca jipj velen. Jupj pü'ü lovin. Ca cyapj ntülüs jipj li tsuwil. Qjuis wala tjevele ncu jipj niná Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. ¿Ncu Dios Jatjam jipj? ");
INSERT INTO jicNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Nin —tjevele Jesús—. Napj niná p'iyá jipj velen jin. Pjü way nun jis lal velé wa, nun ca nucú napj t'üc' way velé. Napj p'iyá niná Yomen Dios jas tjejyamá. P'a jyawca na ca nus nucú napj ca mo'os Dios li'inyampe. Ne'aj ca mo'os, ncupj 'a mulú ca müjü'tücj. Jupj pajal jas tjiyocj pjü jis lal. Nun ca nucú wa napj ncuwis nosis nt'a mol mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jupj nin tjevele na, sacerdote más püné la tücüeme jupj jas quip p'iyá. Nin lajay judiopan, p'a wa malala vele na Dios po'ó. Jupj tjevele jepapan p'a wa jis lal: —Pajal malala tjevele Jesús Dios po'ó. Ma qjuisas la p'a wa mveles Jesús malala la tjiji. Nun p'iyá tjapja'aqué Jesús malala tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ncu pajal malala la tjiji Jesús? —Pajal malala la tjiji —tjowelepj—. Cupj ca cus ntülücj, mpa'is, jupj malala la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nin tjowelepj na, cus tjupjuts' Jesús, wola po'ó. Yupj jis mas jus tjolototj, po'o jatültsja jupj. P'a wa mos la pacatj mpes wola po'ó tül jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tjowelepj jupj lal: —Qjuis lal tjevele pjacj wyala po'ó tyüla. Dios ca jin 'yüsa la mijis. Jipj niná Yomen Dios jas tjejyama qjuis capj la p'acj —nin tjowelepj la tjüpjüts'ün jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Newa wosis t'asiyú tjüwücj mo'o já'asatsja Pedrú, sacerdote más püné wo nt'a. Ne'aj já'asatsja na, tsjücjüim tjac' jupj nt'a. Tsjücjüim niná mozo waytsja ne'aj. Jupj tjevele Pedro lal: —Jipj se con̈ watsja Jesús, jupj ne Galilea mpe 'eseptsja. ");
INSERT INTO jicNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro tsyüpünǘ pjü jis walap'a'á. —Ma nin 'yüsa tsjan mpes velen jipj —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro nin tjevele na, tjemey tjüwücj jun vilicj po'ó. Ne'aj ton̈ca na, tsjücjüim p'a wa jus tjinyuca. Niná tsjücjüim tjevele ne'aj lejen̈tsja jis lal: —Yom niná se cón̈catsja Jesús, Jesús Nazaret mpe 'eseptsja. ");
INSERT INTO jicNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro tsyüpünǘ niswá. Tjevele: —Dios pjoca napj velé. T'üc' way ma si nuc jupj —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Niyom p'a wa ne'aj tjelejen̈ custjay. Yacjaya yupj tjiquil Pedro nt'a. Tjowelepj: —T'üc' way jipj Jesús discipulopan popa. Jipj Galilea mpe 'esepj jin p'iyá velen. ");
INSERT INTO jicNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nin tjowelepj na, Pedro tjevele: —Dios 'ücj ca ncapj ntülüs napj li tsuwil. T'üc' way ma si nuc yom niná. Nin tjevele na, len̈ way la tipiya castlyaj cocoy. ");
INSERT INTO jicNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","La tipiya na, Pedro jola tepyala Jesús tjevelá. “La con ca mvelen ma nus nyuc. Castlyaj cocoy la puyú secj p'in, ca nin la mijin”, tjevele Jesús. Pedro jola tepyala na, tjemey wo nepé. Pajal la tipiya jupj. Pajal jólatsja malala la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Püstapj na sacerdote noypan 'a mulú játjatsja niswá co'müypan jis lal. Tjüjütütj ca mü'ü'nacj Jesús, püste na tjowelepj jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mpes Jesús mos tsupaptsja. Tjaman jupj Pilato nt'a, ca cus ntülüs jupj. Pilato jepa püné auxiliar waytsja jupj. Romano waytsja, judío tulucj. Israel mo'o patja jis tjijyü'ta jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas p'iyá jis lal tjac' Jesús enemigopan, jis la tjilil jupj. Locopyaya Judas jus nleya jepapan quelel ja'ünantsja Jesús. Ca cus ntülücj Jesús, jupj malala la tjiji mpes, tjowelepj. Niná jus nleya na, jupj jola tepyala pajal malala la tjiji Jesús lal. 'Aplijila tepyala pajal. Mpes jupj tjemey niswá sacerdote noypan nt'a, co'müypan nt'a wa. 'A mulú játjatsja yupj. Judas teque'e, tje'yaya niná t'emel c'a tréinteya, nawaja'a tja'ayapj. Ma jostsja quinam jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Malala nyuca la tjejay napj —tjevele jupj—. Napj nun jis lal tjum jupj nt'a, la tjilil jupj. Nun nasa quelel mü'ü'ná jupj. Jupj malala la tjiji tulucj, nujisas mpes p'in quelel 'ü'ná jupj —tjevele. Yupj jupj wola tjowelepj: —Jipj p'iyá nin la tjejay. Ma nin qjuiyola jipj la tjejay mpes —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mpes Judas 'amá 'alá la ts'iya niná t'emel Dios wo mo'ó. Tjemey jupj. Tjemey na, jupj p'iyá mwen tsyu'pa tjevyala, tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas tjemey na, sacerdote noypan tapay t'emel jupj na'aj la ts'iya. Yupj yuwá p'in tjowelepj: “Malala Dios lal 'yonsocj t'emel niná p'a wa t'emel lal Dios wo mo'ó. Niná t'emel mpes jaylacj la tjijicj yom mpa'is. Ma polel la ta'es niná”, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yuwá tjowelepj tsjan la qjuijicj t'emel mpes. Yólatsja 'ücj jaylacj jis la jay 'amá tsjo'oy ts'yawa juts'a'á. 'Amá niná panteón nsem p'a mpe ne'espan mpes. Mpes nin la tjajay t'emel lal. ");
INSERT INTO jicNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nin mpes 'amá niná “'Amá 'As” ló tepyala. Nin ló ne'aj custjay. ");
INSERT INTO jicNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nin tepyala na, t'üc' tepyala Jeremías tjevele pajal püna. Profétatsja jupj, Jeremías. Jupj tjevele: “Yupj natj t'emel c'a treinteyá. Pjaní waytsja yupj jis lal. Israelpan tjowelepj 'ücj jaylacj jis la jay niná jupj mpes, ne nin la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","T'emel mpes jaylacj la tjajay momas, tsjo'oy ts'yawa juts'a'á. Nejepa Dios ntjijütüta ca nin la mejay t'emel mpes.” Nin tjevele Jeremías pajal püna. ");
INSERT INTO jicNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nasa tjaman Jesús jepa romano nt'a, jupj ca mveles ncu ca cus ntülüs. Jepa niná la tji'yüya jupj lal: —¿Ncu judiopan jis jepa püné jipj? —Nin napj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdote noypan tjat' tjowelepj Jesús po'ó jepa romano wolap'a'á. Co'müypan tjat' tjowelepj wa. Newa ma tjevele Jesús ncu t'üc' tuluctsja. ");
INSERT INTO jicNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jepa romano Pilato lotsja. Jupj la tji'yüya Jesús lal: —¿Tsjan mpes ma qjuis wala velen ncu t'üc' malala la tjejay, yupj javelepj jinwá? ¿Ncu ma tjapjac' yupj tjowelepj jipj jin po'ó? Tjowelepj la pülücj malala la tjejay jipj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús newa ma lal tjevele jupj. Pues ma tjevele ncu t'üc' waytsja yupj tjowelepj. Pilato ma jas tji'yüsa tsjan mpes Jesús ma tjevele. Nin jólatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jepa romano janmacj jas tjejyama yom pjaní cawilta mpe fiesta niná tepyala na. Judiopan la t'aptsja pjacj pje'á nyacas cawilta mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nin jawas cawilta mo'o já'asatsja wa yom malala la tjijá. Barrabás lotsja jupj. Pjü salejeptsja jupj malala la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilato quelel se jamatsja Jesús. Mpes judiopan pülücj 'a jis tjimyula na, jupj la tji'yüya yupj jis lal. —¿Cana nujos napj ca jas majam cawilta mpe? —la tji'yüya jupj—. ¿Ncu nujos Barrabás ca mim? ¿Ncu nujos Jesús ca mim? Nepénowa javelepj jupj niná Yomen Dios jas tjejyama nucopj la p'acj —nin tjevele Pilato. ");
INSERT INTO jicNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jupj seletsja jyaman̈ waytsja judío noypan Jesús lal. Jupj seletsja nin mpes tjaman Jesús jupj nt'a, jupj ca cus ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato ne'aj tjá'asatsja jupj silla casá, niná casá tjá'asatsja la veles ncu cus lo tül. Ne'aj tjá'asatsja na, Pilato jats'om taná tjevele jupj lal: “Yom niná malala la tjiji tulucj. Po ma mvelen ca cus ntülücj jupj. Püste malala tjinyuc jupj mpes. Pajal lecj tjeyá malala tjinyuc mpes.” Nin tjevele Pilato jats'om. ");
INSERT INTO jicNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Judiopan p'a casá yólatsja. Sacerdote noypan nasa tjoweleptsja ne'aj 'a jis tjimyula jis lal. Co'müypan tjowelepj wa yupj jis lal. Topon yupj tjowelepj. Nin mpes yupj japontsja más 'ücj la mon ca cus ntülüs Jesús, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato la tji'yüya yupj jis lal: —¿Pjacj yupj popa ca jas majam nun nt'a? ¿Tsjan nujos nun? —Qjuisas ca jas majaman Barrabás —tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato la tji'yüya: —¿Tsjan ca la mejay Jesús lal, ne ma se jam? Nepénowa javelepj jupj niná Yomen Dios jas tjejyama nucopj la p'acj. Pjü yupj tjowelepj: —Cruz po'o tjevyala jupj, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Tsjan mpes ca müjütütj cruz po'o lo valas jupj? —tjevele Pilato—. Ma malala la tjiji jupj. Niná tjevele na, pajal yümücj la tupuyupj: —Cruz po'o mvalan jupj, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato jola tepyala yupj ma quelel pjyacan̈tsja jupj tjevelá. Mop'in jisastsja Jesús mpa'is. Pilato jus nleya wa ts'a 'intsja yupj, jupj ma la tjiji yupj la tjomon jinwá. Nasa quelel la palantsja yupj. Nin mpes 'üsǘ tepyula, mos tepe'e pjü jis walap'a'á. Pajal pülüctsja judiopan ne'aj. Pilato tjevele yupj jis lal: —Napj ma nin lejay mpa'is niná yomen. Nun p'in nujos mpes ca mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pjü way yupj jupj wola tjowelepj: —'Ücj ca qjuis capj ntülüs Dios, ncupj mü'ü'nacj Jesús. 'Ücj wa jis capj ntülüs cupj qjuis ts'uyupan —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Niná tjowelepj na, Pilato jas tjejyama Barrabás cawilta mpe, yupj jisastsja jinwá. Tjijyü'ta jupj militarpan mo'o nsüpücj Jesús. Tjijyü'ta ca cruz po'ó mvalacj jupj, la 'ünan. ");
INSERT INTO jicNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Niná tjijyü'ta na jepa romano, militarpan tjaman Jesús jepa romano wo mo'ó. Tjowelepj ncul wa la p'a wa militarpan jupj wo nt'a tsji' lajaytsja. Tjiquil, t'asiyú tjelejen̈ Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yümücj jas tjü'ipj jupj jas quip. Jas tjü'ipj na, jas tjüwü'ün militar jas quip je. Nin la tjajay la pjüts'ün Jesús mpes. Jepa jas quip jin justa la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yo pjwel jam jus tjulujupj jay pjucj po'ó la 'onsos. Jesús jay tjo'onsopj, corona jay já'asa jinwá. Visyú tja'ayapj jupj mos li'inyampe, jepa püné t'e'enca jinwá. Nin la tjajay na, pajal la tjüpjüts'ün jupj mpes. Jis tic' jin tjelejen̈ jupj wolap'a'á. Tjowelepj: —Qjuisas 'ücj jyas mpü'üm. Jipj jepa püné judiopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","La pülücj cus tjupjuts' Jesús. Natj wa visyú jupj mos mpe, mo'o süptsja jupj visyú mpes. Tsjay la pülücj süptsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","T'üc' la tjüpjüts'ün na, jas tjü'ipj jas quip je. Niswa jas tücüipap jupj jas quip. Nin la tjajay na, jupj lal tjil, cruz po'o jis la valas jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesús lal tjil na, militarpan tjunuc yom pjaní ne'aj jámatsja. Simón lotsja jupj, Cirene mpe 'eseptsja jupj. Tjüjütütj tjyama cruzus Jesús mpes, ne nin la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne'as tjil cruz po'o lo valas nt'a. Gólgota lotsja ne'aj. “Gólgota” mpes 'ücj la veles “Jay Pjucj Cjüele” cupj qjuis tin. ");
INSERT INTO jicNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uva 'üsǘ tja'ayapj Jesús lo müs. Uva 'üsǘ niná leméliyu la süpjütsja, pajal nepé vyaja lo ts'uc. Pajal 'ónatsja. Jesús tsjicj way tjümü'ü, tjinyuca. Jus nleya leméliyu la süpjütsja, ne ma tjümü'ü. ");
INSERT INTO jicNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cruz po'o tjovalapj jupj clavo mpes. Nin la tjajay na, Jesús jas quip jis tja'ayapj yuwá. Militarpan tjepjelan̈ tjunuc pjacj nta'es jupj jas quip. ");
INSERT INTO jicNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Atjalapj yupj ne'aj, tjajamapj Jesús, jupj jomicapan ma ca ncul, ma ca cus nts'optecj cruz mpe. ");
INSERT INTO jicNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nasa tüpüntüpj tabla tsjicj cruz po'ó Jesús jay nt'a. Tabla niná po'o tapac tsjan mpes cus tül Jesús. Ninana tapac: NINANA JESÚS, JEPA PÜNÉ JUDIOPAN JIS LAL. ");
INSERT INTO jicNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yupj tjovalapj wa pwecapan mat'e p'a wa cruzus po'ó. Pjaní wa tjovalapj Jesús li'inyampe. Pjaní wa tjovalapj Jesús nancupwepé. ");
INSERT INTO jicNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Judiopan nepénowa cruz ton̈ca jin tjil. Yupj sey pjucj la süpjüntsja jupj mpes. Ma topon 'üsüstsja jupj. Pajal malala po'o tjowelepj jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tjowelepj: —Jipj tjevelen jipj 'ücj malala la mijin Dios wo. Ts'ac' cont'e na niswa ca jas müjünsün, tjevelen jipj. Mpes 'ücj wa cyapj la p'acj jipj p'iyá. Jipj Dios Jatjam, 'ücj palá ncuwim cruz mpe —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdote noypan la tjüpjüts'ün wa Jesús, yupj jinwá. Nin p'iyá tjowelepj wa Moisés popel sin 'yüsa lajay. Nin p'iyá co'müypan. Niná tjowelepj: ");
INSERT INTO jicNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jupj jis capj tjep'ya'sa la p'a wa. Ma polel cus la p'acj jupj p'iyá. Jupj ne p'iyá Jepa Püné judiopan mpes, qjuisas ca palá ncuwim. Jupj nin la qjuijis, cupj cüponecj catsja jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jupj tepyona Dios ca 'üsüs la qjuijis jupj mpes. Dios quelel liji jupj, más 'ücj Dios ca cus mp'a'sas quinam. Jupj tjevele jupj p'iyá Dios Jatjam —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pwecapan cruz po'o tjelejen̈ Jesús lal, nin p'iyá tjowelepj yupj. Yupj pajal malala tjowelepj Jesús lal, la p'a jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lots'ac' culupwen nt'a tjá'asa na, püste tepyala pjü nosis casá. Hora cont'e te tón̈catsja. ");
INSERT INTO jicNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Las tres tepyala na, Jesús pajal yümücj la tipiya, tjevele Dios lal: —Elí, Elí, ¿lama sabactani? —tjevele jupj. (Ninana jupj tjevele 'ücj wa la veles: “Napj Ndios, napj Ndios, ¿tsjan mpes 'os tjay jipj?” Nin velecj niná cupj qjuis tin.) ");
INSERT INTO jicNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","P'a wa ne'aj p'in tjelejen̈, tjepjyacan̈ wa jupj tjevelá. Tjepjyacan̈ na, ma sin tji'yüsa tsjan mpes nin tjevele. Yupj tjowelepj: —Jupj Elías lal vele ncuwim. Jos ca cus mp'a'sas. Elías profeta püna tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jesús nin tjevele na, yupj popa pjaní len̈ way ts'üequené, esponja teque'e. Esponja uva 'üsǘ 'ona mo'o ts'yuca, tsyu'pa yo po'ó, mpe tecyacaná. Tje'yaya ca mü'üm Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pjü way la p'a wa tjowelepj: —Po ma ma'ayan mü'üm niná. Cupj quelel nyucucj ncu Elías ncuwim cus la p'acj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús yümücj tjevele niswá. Nin la tjiji na, tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pülül p'omp'om jálatsja Dios wo mo'ó, pülül niná wo t'em pjaní jinwatsja. Jesús tepe'e na, pülül niná nayapé palavin la tücüeme. Dios la tjiji la tücüeme. Nosis jus tiquits'e 'ots'ipj. Pe witjacj la tjeleptan 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jesús tepe'e na, pülücj janucun jis tepyala püna tecya'lin̈ sin popé. Dios sa con̈ witjactsja yupj. 'Amá toc tapatja nt'a la tjelepta. ");
INSERT INTO jicNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pje'á tjiquil toc pátjatsja mpe. Jesús jas tjijyünsa na la püt'üs niswa, yupj tjil wa Jerusalén mo'ó. Pülücj yus tjunuc yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jepa militar tjejyámatsja Jesús, jupj jomicapan ma ncul cus nts'optecj cruz mpe. P'a wa militarpan jupj lal lejen̈ watsja, militar püné lal. Tjunuc nosis jus tiquits'e. Tjunuc wa pjü niná tepyala Jesús tepe'e na. Niná tjunuc na, pajal lacj tjeyaptsja. Tjowelepj: —T'üc' way jupj Dios Jatjam waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nequem pülücj way ne'aj lejen̈tsja, campa way 'in cruz ton̈ca mpe. Tjunuc wa tepyalá. Jesús jomicapan waytsja yupj. Cus tocon̈ Jesús, Galilea mpe tjac' na. Tjojon jupj mpes, pjü 'ücj la tjajay wa jupj tüpü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yupj popa pjaní María lotsja. Magdalá mpe 'eseptsja jupj. P'a wa María ló watsja jupj. Jupj Jacobo jamaytsja, José jamaytsja. Quepj p'a wa Zebedeo jatjampan sejamay. ");
INSERT INTO jicNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nasa quelel t'yaja na, yom p'a wa tjac'. Yom niná pülücj tyá'atsja. Arimatea mpe 'eseptsja, judiopan patja nt'a. José lotsja. Jesús discípulo watsja. ");
INSERT INTO jicNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José tjemey Pilato nt'a. La tjemyona Jesús jüp'üy la toc. Pilato tjijyü'ta ca nin nsem. Tjijyü'ta militarpan ca ma'ayacj Jesús jüp'üy. ");
INSERT INTO jicNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mpes José palá nt'ya Jesús jüp'üy. Tjivyü'ünǘ pülül pje mpes. Salá waytsja pülül. ");
INSERT INTO jicNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tipyünta Jesús jüp'üy pe jul mo'ó, neven nt'a, tepe'e 'ücj la püntüs nt'a. Püna p'in tjijyü'ta la toc jomwen jul, jupj p'iyá tepe'e tulucj p'in. Nin lajaytsja judiopan. José jostsja jomwen jul toc ton̈ca jupj pe'e na. Tepe'e ne'aj tipyünta tulucj custjay. Jesús jüp'üy ne'aj tipyünta na, pe püné jas tentené jun la t'olon jomwen jul. Jun t'yo'na na, tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María newa ne'aj já'asatsja pe jul wolap'a'á. Niná María, Magdalá mpe 'eseptsja. P'a quepj tjá'asa watsja María lal. María ló watsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ya sacerdote noypan tjil Pilato nt'a. Fariseopan tjil wa yupj jis lal. Nin jawas ma polel tsji' lajaytsja; t'an̈ p'in 'ücj la tjajay ma ca tsji' la mijicj nin jawas ma tsji' lajay na. Tjil na, ");
INSERT INTO jicNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tjowelepj Pilato lal: —Cupj qjuiyola tepyala Jesús tjevelá. Tjevele jupj ca jas müjünsüs mpü'üm niswá ts'ac' cont'e tepyala na. Jupj la tsyawilitsja lovin. ");
INSERT INTO jicNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mpes cupj qjuisas jipj ca müjü'tün militarpan majamacj jomwen jul, Jesús jüp'üy pü'ü nt'a. Qjuisas newa majamacj ne'aj, ts'ac' cont'e tepyala nas. Militarpan len̈ ne'aj, jupj discipulopan 'ücj wa ncul, mpequen̈ jupj jüp'üy. Ca mvelecj jupj jas tjijyünsa. Nyucunú quinam, ca mvelecj. Ca yus ntsawilicj judiopan. Judiopan topontsja Jesús lal, jupj nyucunutsja na. T'üc' ca mponecj quinam, jupj jüp'üy len̈ cüvalas —nin tjowelepj yupj Pilato lal. ");
INSERT INTO jicNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato jis lal tjevele: —Mwü. Napj militarpan ca mal nun jis lal, ca majamacj nujisas jinwá. Nin la müjí Jesús jomicapan ma ca wama mal jomwen jul mo'ó. Pjü 'ücj polel lojí, pjü la müjí. ");
INSERT INTO jicNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mpes tjil yupj. 'Ücj la tjajay jomwen jul nt'a. Jun t'yó'natsja jomwen jul, pe püné mpes. Hilo tsjicj way po'o tüpüntüpj pe wolap'a'á 'ots'ipj, ca jus nlayecj ncu wama jil gentas. Militarpan jis tjüjünsüpj tjil, militarpan jis la jamas ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tecyawaja sábado quinam, nasa domingo tepyala. 'Ücj tsji' lajaytsja quinam. Tjejyawca na, tjil nequem jomwen jul la nuc, Jesús jüp'üy tüpüntüpj nt'a. Quepj pjaní María, Magdalá mpe 'esepj. Ma'ajapj María ló watsja. ");
INSERT INTO jicNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pajal jus tiquits'e nosis. Dios ángel pjaní tjac' tsjun mpe, nin mpes nin tepyala niná. Tjemey jupj jomwen jul nt'a. Jas tentené pe püné jun vilicj mpe. Jun cjol tepyala. 'Etjele ángel pe casa'á. ");
INSERT INTO jicNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pasal jas jawtsja jupj, menmené jinwá. Jas quip pje waytsja pajal, mol pje jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Militarpan tjelejen̈ ne'aj custjay. Tjajamapj jomwen jul nt'a. Ángel tjunuc na, ticyücüyün̈ yupj, lacj tjeyapj mpes. Jis capj t'yaja pjü. ");
INSERT INTO jicNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nequem ma sin tji'yüsa tsjan tepyalá. Mpes ángel tjevele yupj jis lal: —Po ma locj tjeyá quinam. Napj selé nun lo palá Jesús. Jupj ne cruz po'o tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Len̈ quinam jupj. Jas tjijyünsa. Nyucunú tepyala niswá, jupj tjevele jinwá. Nculá nun. Tjunuca jupj tüpü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nun tjunucú na, len̈ way lowa jupj discipulopan nt'a. Tjowelé yupj jis lal jupj jas tjijyünsa quinam. Nyucunú p'in quinam. Mwalá way jama nun jis lal Galilea nt'a. Galilea nt'a ca jus nucú jupj niswá. Nin ca mvelé nun yupj jis lal. T'üc' ca mpalas napj tjevelé jinwá —nin tjevele ángel yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mpes len̈ way tjil nequem jomwen jul mpe, ángel tjijyü'ta jinwá. Newa lacj jeyaptsja. Pajal 'ücj jisastsja wa. Ts'equenen̈ la veles discipulopan jis lal. Quelel javeleptsja ángel tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Newa ts'equenen̈ na, Jesús lay jis tepyala yupj jis lal. Tjac' la nüjüsü. —¿Min nucopj tjejyawca? —tjevele jupj. Nequem tjil jupj nt'a, palá nipi'tjin̈ jupj wolap'a'á. Ntji'lin̈ jupj tsjom. Yólatsja jupj pajal püné, mpes nin la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús tjevele yupj jis lal: —Po ma locj tjeyá quinam. Lowa, mvelé mpülücpan jis lal. Najas ca mal Galilea nt'a. Ne'aj ca nus nucucj. Nin ca mvelé yupj jis lal —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nequem nasa tjil jomwen jul mpe. Tjil na, militarpan ne'aj tjátjatsja custjay, yupj ne jajamaptsja jomwen jul. Yupj sin popa nepenowá tjil Jerusalén mo'ó. Tjowelepj sacerdote noypan jis lal. Pjü tjowelepj tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sacerdote noypan 'a jis tjimyula judío co'müypan jis lal. Ma jisastsja la p'a wa judiopan ca jus nlayecj Jesús jas tjijyünsa. Mpes yuwá p'in tjowelepj 'oyn nyuca la qjuijicj la p'a ma ca jus nlayecj. T'emel pülücj jis tja'ayapj militarpan niná la tsuwil mpes. ");
INSERT INTO jicNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ninana yupj tjowelepj militarpan jis lal: “Nun ca mvelé jupj discipulopan tjiquil püste na. Ca mvelé tepequen̈ jupj jüp'üy nun tjüjünaqué na. ");
INSERT INTO jicNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","P'a witjacj niná cüvelecj jepa romano lal, cupj 'ücj ca la mijicj ma nucopj tyüla jupj”, nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niná 'üctsja militarpan jis lal. Mpes natj t'emel. Yupj la tsawil, sacerdotepan tjüjütütj jinwá. Judiopan topon militarpan tjowelepj. Ninana tintsja yupj t'ya tjowelepj, newa javelepj niná Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús discipulopan 'ónceya tjil Galilea nt'a, jupj tjijyü'ta jinwá. Tjil joc' pjaní nt'a, jupj nasa tjevele yupj ca mal ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne'aj jus tjunuc Jesús. Salejeptsja jupj Dios Jatjam, mpes palá nipi'tjin̈ jupj wolap'a'á. Yupj sin popa nepenowá sey c'a jinwatsja custjay. 'Ots'ots' way p'in topon niná ne t'üc' way Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ne'as tjemey yupj nt'a. Tjevele yupj jis lal: —Napj 'ücj jyütütj pjü way tsjun po'ó. Pjü wa nosis casá 'ücj jyütütj wa. Mpapay ntje'aya ca nin nsem. ");
INSERT INTO jicNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mpes lowa nun pjü nosis casá. Pjü 'a mulú patja jis lal ca mvelé napj mpes. Sin 'yüsa lis müjí, mpes yupj napj discipulopan ca jis mpalas. Bautizar ca lis müjí Dios Mpapay mpes, Dios Jatjam mpes wa, Dios Cjües mpes wa. ");
INSERT INTO jicNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ca sin mü'üsüs la müjí ca nin la mijicj pjü way napj nu tjijyütütj. T'üc' way napj p'iyá ca nucopj ncon̈ lovin, nosis cyawaja nas —nin tjevele Jesús jupj discipulopan jis lal.");
INSERT INTO jicNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Po quina papel ca mpac Jesucristo po'ó, jupj ne Dios Jatjam. Papel niná ca mveles tsjan niná pajal 'üsüs tepyala jupj la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Püna Isaías la p'a jis lal tjevele Dios tjevelá. Profétatsja jupj püná. Jupj papel tepyaca Dios tjevelá Jatjam lal. Ninana tepyacá: “Napj yom pjaní jas majam ca. Jupj ca mim napj mpes. Jupj mveles ca napj mpes. Jupj mwalá way ca mim jipj lal. P'a jawas jipj ca mim. Yom niná ca mveles gente jilal. Mpes yupj ca jisas nsem jipj jay yupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yom niná wa cjuwá nt'a ca mim jupj. Pajal ca quelel mveles gente jilal napj mpes. Mpes yümücj ca mveles: ‘Qjuis Jepa Püné ca ncuwim. Nujola t'as ca nin la müjí quinam jupj jos jin. Malala nujola nun jümücj la lu'ulú jinwá. Po ma malala nujola t'as quinam. 'Üsüs nujola t'as, qjuis Jepa Püné jos jinwá’, nin ca mveles jupj.” Dios tjevele jupj ca nin mveles; Isaías tepyaca Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mpes p'a jawas yom ne'aj tjac' wa cjuwá nt'a. Juan el Bautista lotsja jupj. Gente jis walap'a'a tjevele más 'ücj 'aplijila nsem yupj, malala nyuca la tjajay mpes. Más 'ücj ca Dios jos jin la mijicj quinam. Juan tjevele jupj ca 'üsüma jis mpa'tas, mpes bautizar jis mpalas ca. Tjevele ca sin müjünsüs niswá. Mpes pjü ca jus nlayecj yupj quelel 'üsüs la mijicj quinam, Dios jos jinwá. Nin mpes Dios ca perdonar lis mijis malala nyuca la tjajay. Nin tjevele Juan yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pülücj way tjiquil jupj nt'a. Judea mpe tjiquil wa, ne'aj judiopan pjaní pjaní patja nt'a. Jerusalén mpe tjiquil wa, ne'aj pülücj patja judiopan. Yupj tjiquil, tjowelepj jupj lal malala nyuca la tjajay. Niná tjowelepj na, Juan bautizar lis tjiji 'üsǘ mo'ó. Jordán ló 'üsǘ ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan jas quip camello ts'üilin waytsja jupj. Col tsyú'patsja pjoloc' mpes. Ts'elel lyájatsja jupj. Ts'as joc' 'alape píjisa watsja. Lovin nin tüpü'ü. ");
INSERT INTO jicNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gente jilal tjevele: “P'a jawas p'a wa ncuwim. Más püné jupj napj lal. Napj pajal tsjicj jupj lal. Po 'üsüs napj lal tsji' lejay jupj mpes. Napj jupj caite syoc la p'in 'ücj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Napj bautizar la nusejay 'üsǘ mpes la p'in. Yom p'a wa niná más 'üsüs ca la mijis. Jupj ca nu ma'ayas Dios Cjües.” ");
INSERT INTO jicNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","P'a jawas Jesús Nazaret mpe tjac' jupj, Galilea se jütütj mpe. Juan el Bautista nt'a tjemey. Juan el Bautista bautizar la tjiji Jesús 'üsǘ püné mo'ó, niná 'üsǘ Jordán ló. ");
INSERT INTO jicNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús 'üsǘ mpe jas tjijyünsa na, jupj tjinyuca tsjun po'ó tsjicj way la tücüeme, jun cjol tepyala. Nepé palá tjac' Dios Cjües. Sipipj jinwá justa tjac' jupj Jesús nt'a. Niná tjinyuca Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tsjun po'o nepé vele pjactsja wa: “Jipj napj Natjam. Quelel la 'ejay pajal napj. Pajal 'ücj najas jipj lal.” ");
INSERT INTO jicNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dios Cjües jas tjejyama Jesús campa way 'in, wa cjuwá nt'a. Mpes tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ts'ac' cuarenta tüpü'ü ne'aj. Animal pülücj lyawun̈tsja la p'in ne'aj. Ne'aj tjac' Satanás Jesús nt'a. Malala tjevele Jesús lal. Jostsja ca Jesús malala nyuca la mijis. Ángel witjacj tjiquil Jesús nt'a, cus tjap'acj jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jepa cawilta mo'o tje'yonsa Juan el Bautista. Nin tepyala na, Galilea mo'o tjemey Jesús. Ne'aj pülücj jis walap'a'a tjevele Dios pajal 'üsüs la tjiji gente mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús tjevele: “Quina ca nin mpalas, Dios ca müjü'tüs nosis nt'a. Len̈ way ca nin nsem. 'Aplijila t'as malala nyuca la tjüjí. 'Üsüs la müjí quinam Dios jos jinwá. Mponé Dios tjevelá, jupj tjevele jupj pajal 'üsüs liji nun mpes.” ");
INSERT INTO jicNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús 'üsǘ püné la nt'a tjemey jupj. Galilea ló 'üsǘ niná. Yom mát'eya yus tjinyuca. Pjaní Simón lotsja jupj. Ma'ajapj Andrés lotsja jupj. Jupj Simón tsüípetsja. Po quina ataraya püné la ts'itsja 'üsǘ mo'ó. Lovin cjul pje'á la coytsja yupj, lovin nin la tjajaytsja, tapatja. ");
INSERT INTO jicNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús tjevele yupj jilal: “Ncapj ncon̈có nun. Napj ca nusin 'yüsa la mejay 'ücj la veles la p'a jilal Dios mpes. Nin mpes ca nepénowa cus ncon̈cocj wa jupj.” Nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Len̈ way tüpüntüpj yupj jis ataraya, tjil Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús tsjicj way tjemey na, la p'a wa yus tjinyuca jupj. Pjaní Jacobo lotsja jupj. P'a wa Juan lotsja jupj. Jupj Jacobo tsüípetsja. Yupj Zebedeo jatjampan waytsja. Barco wama tjátjatsja yupj jis papay lal, jupj jomozopan jis lal wa. Ataraya püné 'ücj la tjajaytsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús ma la tjinyuca. Jis lal tjevele ncul yupj, ca cus ncon̈cocj. Mpes tjil jis papay tjá'asa mpe, jupj jomozopan mpe wa. Tjil Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum nt'a tjil yupj, pülücj patja nt'a. Sábado na tjil judiopan 'a si mulú nt'a. Jesús sin 'yüsa la síjitsja yupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pajal nin yólatsja yupj Jesús tjevele mpes. Jesús Moisés popel sin 'yüsa lajay jin tuluctsja. 'Ücj jis la jütütj jinwá tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yom tjá'asa ne'aj, wosis nt'a judiopan 'a si mulú nt'a. Lapanen jupj jos mo'o tüpǘ'ütsja. Yom niná yümücj tjevele Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jipj Jesús Nazaret mpe 'esepj. ¿Tsjan pjucj tjacuy cupj nt'a? ¿Ncu pjü malala qjuis la jay tjacuy jipj? Napj selé pjacj ne jipj. Dios juts'a'á way jipj. Pajal 'üsüs way jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús yümücj tjevele lapanen lal: —¡Lyájasa t'as! ¡Jutja jupj jos mpe! —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yom pajal jun jyu'ya tepyala lapanen la tjiji. Lapanen yümücj la tipiya. Jupj jos mpe tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pjü way po yólatsja 'üsüs tepyala mpes. Mpes yuwá tjowelepj yupj: “¿'Oyn ne nin vele jupj? Seyasa way qjuisin 'yüsa liji Jesús. Jepa jinwá qjuisin 'yüsa la qjuisiji. Jyü'ta wa lapanenpan jilal, ne nin lajay jupj vele jin.” ");
INSERT INTO jicNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pjü jilal tjowelepj Jesús la tjijá. Mpes Galilea mo'ó len̈ way pjü tjepjyacan̈ Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Judiopan 'a si mulú nt'a, niná wo mpe tjemey quinam Jesús. Jacobo, Juan jilal tjemey jupj. Simón, Andrés jis wa nt'a tjil yupj. Wama tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ne'aj Simón pwisam pǘ'ütsja, malala jostsja jupj. Po 'in si 'áwatsja jupj. Ne'aj patja tjowelepj Jesús lal malala jostsja niná. ");
INSERT INTO jicNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús tjemey jupj nt'a. Mos ntjüi'le, jas tjijyünsa jupj. Mpes 'ücj já'asatsja jupj quinam. Si 'awa tji'yü'sa quinam. Len̈ way niná ve jis tje'yaya, tjalá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Püste tepyala na, la p'a wa tjiquil, jis tucuman pjü way malala jisas Jesús nt'a. Nepénowa lapanenpan yupj jisas mo'o pátjatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pjü way ne'aj p'in patja 'a jis tjimyula wo jun vilicj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pülücj malala jisas jis tji'yü'sa lis tjiji Jesús. Pje'á sin tjejyama lapanenpan pülücj. Mpes yupj tjil. Yupj salejeptsja pjacj ne jupj, Jesús. Mpes Jesús ma jis tje'yaya jis la veles. ");
INSERT INTO jicNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Püstapj tsyülümǘ Jesús, ma tjejyawca na p'in. Jas nisa jupj. Tjemey jusapj, pjü len̈ nt'a. Dios lal tjevele ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yacjaya Simón, jupj jomicapan jis lal la tapaltsja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jupj la nyüjüsün̈ na, tjowelepj jupj lal: —Pülücj la 'e pal jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús tjevele: —La p'a nt'a 'alas, ne'aj p'in nepénowa patja nt'a. Napj ca mvelé wa yupj jis walap'a'á Dios tjevelá. Napj tjacuwis lo veles Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pues jun ta'á tjemey Galilea mo'ó, Jesús. Wa witjacj judiopan 'a si mulú nt'a tjemey lovin. Pjü jis walap'a'a tjevele Dios tjevelá. Nepénowa lapanenpan pátjatsja yupj jisas mo'ó. Mpes Jesús pje'á lis tecyoye tjil lapanenpan. ");
INSERT INTO jicNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yom pjaní tjac' Jesús nt'a. Malala jostsja pajal. Jupj jüp'üy tjamaja lovin, palá tinca jupj jüp'üy popé. Jesús nt'a tjac' na, tüic' jin tjüjünsü jupj. La tjemyona: —Jipj polel ni 'ü'sa lejay. Jipj jyas na ca nin nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús pajal jólatsja jupj mpes. Mpes pjwel la tepyacta, po la tje'yot'a yom malala jos. Tjevele: —Najas. 'I tjü'ü'süs quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Len̈ way jüp'üy tji'yü'sa. ");
INSERT INTO jicNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tji'yü'sa na p'in, Jesús jas tjejyama jupj sacerdote nt'a. Tülü way tjijyü'ta ma ca nin mveles nin tepyalá. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Po ma mvelen la p'a lal quinam jipj 'i tjü'ü'sa. Jutja sacerdote nt'a. Jupj ca jis nucus. Ca la mpalas nucus ncu malala lo nuc jipj p'yüy po'ó. Ca mveles 'üsüs quinam. Niná la tjejay na, Dios mpes ma'ayan, jipj 'i tjü'ü'sa mpes. Pajal püna Moisés tjijyü'ta tsjan ca ma'ayacj, jis p'üy jis tji'yü'sa na. Jupj tjijyü'ta jin ca la mijin. Pjü la tjejay na, la p'a ca jus nlayecj jipj t'üc' way 'i tjü'ü'sa quinam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yom tjemey wa mpe. Ma la tjiji Jesús tjevele jin. Pjü way jilal tjevele Jesús tji'yü'sa la tjiji jupj. Pülücj way jilal tjevele jupj. Nin mpes Jesús ma polel jámatsja pülücj patja nt'a. Mpes gente len̈ nt'a tüpü'ü jupj. Mop'in pülücj tjiquil pülücj patja mpe Jesús nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","P'a jawas Jesús tjemey niswá Capernaum nt'a. Pjü way tjepjyacan̈ Jesús ne'aj tüpü'ü wa mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jupj lal pülücj 'a jis tjimyula wa mo'ó. P'a wa ma polel wama jiltsja yupj. Pülücj way lejen̈tsja jun vilicj nt'a 'ots'ipj. Jesús yupj jilal tjevele Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nin líjitsja na, niyom yulupjana tjiquil. Yom ma polel 'utaná tucuman hamaca lal. ");
INSERT INTO jicNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma polel wama tjil yupj malala jos lal, mpes wo jay tjujulul Jesús casa'á. Jul 'ücj la tjajay na, malala jos palá tüpüntüpj hamaca mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús jus nléyatsja yupj topon jupj polel 'yü'sa liji jupj. Nin mpes malala jos lal tjevele: —Napj perdonar la 'ejay malala nyuca la tjejay Dios lal. Ma nin nola quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Niyom Moisés popel sin 'yüsa lajay ne'aj tjatja, tjepjyacan̈ Jesús tjevelá. Malala jin yólatsja Jesús tjevelá. Yólatsja: ");
INSERT INTO jicNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tsjan pjucj niná nin vele? Jupj tjevelá malala Dios lal. Jupj ma polel perdonar liji malala nyuca liji. Dios p'in nin liji.” ");
INSERT INTO jicNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nin yólatsja na p'in, Jesús seletsja nin yólatsja yupj. Mpes Jesús tjevele yupj jilal: —¿Tsjan mpes nin nujola napj tjevelé malala Dios lal? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Napj 'ücj velé: ‘Napj perdonar la 'ejay malala la tjejay Dios lal’. Napj 'ücj wa velé: ‘Jin tjijyünsa, ca mim’. ¿Cana más 'in costa la veles? ");
INSERT INTO jicNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nin p'iyá ca mvelé wa malala jos lal, mpes nun ca jus nlayé napj 'ücj perdonar lejay nosis nt'a. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. Nin mpes Jesús tjevele malala jos lal: ");
INSERT INTO jicNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Jin tjijyünsa. Hamaca nt'ya, nt'an, jutja wya nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Len̈ way jas nisa jupj. Hamaca nt'ya. Tjemey quinam pje'á. Pjü way jus tjunuc. Pajal yólatsja yupj 'üsüs tepyala mpes. 'Üsüs tjowelepj Dios po'ó. Tjowelepj: —Lovin ma tjinyucuctsja cupj nin tepyalá. Yacjaj p'in tjinyucucj. ");
INSERT INTO jicNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","'Üsǘ püné la nt'a tjemey Jesús niswá. Pajal pülücj 'a jis tjimyula jupj nt'a, ne jupj sin tji'yüsa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yacjaya tjemey Jesús. Jámatsja na, Leví jus tjinyuca. Alfeo jatjam waytsja jupj, Leví. Impuesto jaylacj t'e'éncatsja jupj jepa mpes jümücj casá tjelyawun̈ jilal. Wa nt'a impuesto t'e'enca nt'a tjá'asa. Jesús tjevele jupj lal: “Ncapj tecyon̈ca jipj. Najas ncapj cyon̈ lovin.” Mpes jas nisa jupj, cus tecyon̈ca quinam jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Locopyaya Jesús Leví wo nt'a já'asatsja. Ne'aj tjelyaja jupj discipulopan jilal. Ne'aj tjiquil wa, tjalá watsja niyom pülücj. Nepénowa impuesto jata'epj tapatja, Leví jinwá. Yupj pequen̈tsja püna p'in. P'a witjacj ma t'üc' la tjajay Moisés popel tjijyü'tá. Yupj sin popa pülücj cus tocon̈ Jesús quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Niyom p'a wa tjunuc Jesús tjelyaja yupj jilal. Yupj ne Moisés popel sin 'yüsa lajaytsja. Fariseopan waytsja yupj. Niná tjunuc na, yupj jis la tjü'üy Jesús discipulopan jilal: —¿Tsjan mpes lyaja Jesús impuesto jat'anquepj jis lal, malala nyuca lajay jilal 'ots'ipj? ");
INSERT INTO jicNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús tjapjaca jis la tjü'üy jupj discipulopan jilal. Tjevele yupj jilal: —'Ücj jisas ma jisas doctor. Malala jisas p'in doctor jisas. Napj doctor jinwá malala lajay jis lal. Napj niná nin lejay Dios jos jinwá. Napj tjacuwis la veles malala lajay jis lal. Napj velé yupj jis lal Dios jos yupj 'aplijila nsem malala nyuca la tjajay mpes. Dios jos yupj 'üsüs la mijicj quinam jupj jos jinwá. Niná napj ma velé 'üsüs lajay jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan discipulopan ma jalatsja neneyawá; quelel javeleptsja p'in Dios lal. Nin lajay watsja fariseopan. Mpes nepénowa tjiquil Jesús nt'a, tjowelepj: —Juan discipulopan ma jalá neneyawá; quelel javelepj p'in Dios lal. Nin p'iyá lajay wa fariseopan jis discipulopan. ¿Tsjan mpes jipj discipulopan ma nin lajay? ");
INSERT INTO jicNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús jis wala tjevele: —Yom judío woya na, jupj jomicapan jiquil wa cus la con̈ jupj. Pasal 'ücj jisas, jalá jupj lal. Nin p'iyá napj discipulopan jis lal. Napj yupj jis lal 'os. 'Ücj javelepj napj lal. Nin mpes 'ücj jisas jatja yupj. 'Ücj yupj jalá. ");
INSERT INTO jicNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","P'a jyawca na, p'a casá ca nsem. La p'a ca ncul, ca ma tjililin̈. Len̈ ca nsem napj. Nin jawas tjejyawca na, napj discipulopan ma ca nlajacj neneyawá, ca mvelecj p'in Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jupj tjevele wa jupj lal japon ma polel nin p'iyá lajay püna tapatja la tjajay jinwá. —Nin p'iyá ma polel jul sa lul jis pülül pül pülül seyasa mpes —tjevele—. Nin lajay na, pülül seyasa la'í pyala tepe'e na. Mpes pülül pül way ca la ntsü'üm, ca püné way la jul nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nin p'iyá wa, judiopan uva 'üsǘ seyasa jatatj na. Uva 'üsǘ seyasa ma ca mo'o nt'ucj pjoloc' pül way mo'ó. Nin lajay niná, pjoloc' pül ca mpjoltem 'üsǘ myolca mpes. Tjopjolta na, uva 'üsǘ ca jus ncocom. Malala ca mpalas wa pjoloc'. Nin mpes ma lajay niná. Uva 'üsǘ seyasa jatatj na, pjoloc' seyasa mo'o ca nt'ucj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado pjaní Jesús trigo lejen̈ culupwen nipj tjemey. Sábado ts'ac' niná judiopan ma tsji' lajay. Jupj discipulopan tjil wa jupj lal. Jiltsja na, trigo nepénowa sey jat'anqueptsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseopan yólatsja malala niná yupj la tjajay. Mpes tjowelepj Jesús lal: —¿Tsjan pjucj nin lajay jipj discipulopan, trigo jat'anquepj? Dios Popel vele ma polel tsji' lijicj sábado na. ");
INSERT INTO jicNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús jis wala tjevele: —Dios Popel vele wa David la tjijá pajal püna. ¿Ncu lovin ma mo'o tjowelé niná? (David israelpan jis jepa waytsja püná. 'Üsüstsja jupj Dios lal.) Ts'ac' pjaní jupj vecj pé'etsja. Noyomes jupj cus tocon̈ wa, vecj tecya'lin̈ wa yupj. Ve cjuwatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mpes jupj wama tjemey Dios wo nt'a. Pan nt'ya, tjelyaja. Jis tje'yaya wa niyom cus tocon̈. Pan niná israelpan tja'ayapj Dios mpes. Dios Popel tjevele sacerdotepan p'in 'ücj jalá pan niná. P'a wa ma polel jalá yupj. David sacerdote tuluctsja, mop'in nin, Dios ma ts'i tji'ina jupj tjelyaja mpes. David nin la tjiji Abiatar sacerdote más pünetsja na. ");
INSERT INTO jicNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús tjevele wa: —Dios gente jis tje'yaya ma tsji' lajay sábado na. Niná jis tjijyü'ta 'üsüs jis la pal la p'in. Dios ma nin liji pajal costa nsem gente 'üsüs lajay sábado na. ");
INSERT INTO jicNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Napj p'iyá niná Yomen Dios jas tjejyamá. Napj 'ücj wa jyütütj tsjan 'ücj lajay sábado na, ts'ac' ma tsji' lijicj na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","P'a jyawca na Jesús wama tjemey judiopan 'a si mulú nt'a. Yom ne'aj tjá'asa wa mo'ó, mos c'a waytsja jupj. Ma polel le páctatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Niyom p'a wa ne'aj tjatja wa. Pajal jus tjunuc Jesús, quelel januctsja ncu 'yü'sa liji sábado na, ts'ac' niná ma tsji' lajay. Jisastsja Jesús ca malala la mijis, mpes 'ücj jat' mvelecj ca Jesús malala. ");
INSERT INTO jicNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús tjevele yom mos ma polel le pacta lal: —Jin tjijyünsa jipj. Yupj lejen̈ culupwen nt'a was jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tjevele wa niyom p'a wa jilal: —¿Cana más 'ücj lejay sábado na, ts'ac' ma tsji' lijicj na? ¿Ncu más 'ücj 'üsüs lejay, ncu más 'ücj malala lejay? ¿Ncu más 'ücj se p'acj 'ücj la püt'üs jupj, ncu más 'ücj 'yünan jupj? —nin tjevele Jesús. Lyájasa tjelejen̈tsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús po ma jostsja yupj malala yólatsja; yupj ma quelel sin 'yǘsatsja Dios jos jin. 'Aplijila tepyala Jesús yupj malala yólatsja mpes. Tjevele yom mos c'a lal: —Myas la tepyacta. La tepyacta jupj mos quinam. Tji'yü'sa jupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseopan tjil quinam yupj. Tjil Herodes jomicapan nt'a. Yuwá tjowelepj 'oyn nyuca la 'ünan Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Locopyaya Jesús tjemey 'üsǘ püné nt'a jupj discipulopan jilal. Pülücj way Galilea po'o patja witjacj tjil wa Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pajal pülücj jus nlay Jesús 'üsüs la tjíjitsja. Mpes tjiquil wa yupj jupj nt'a. Tjiquil Judea mpe, Jerusalén mpe wa, Idumea mpe wa, 'üsǘ püné na'aj po'ó mpe wa. (Jordán ló niná 'üsǘ püné.) Tiro ne'aj p'in mpe tjiquil wa nepenowá. Sidón ne'aj p'in mpe tjiquil wa nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Pülücj way jis tji'yü'sa lis tjiji Jesús. Mpes la p'a malala jisastsja pjü cus tjeletjatj jupj. Pülücj waytsja yupj. Nin mpes Jesús jupj discipulopan jilal tjevele: “Barco nca'á ma 'e nun. Pülücj ncapj jaletjatj yupj.” ");
INSERT INTO jicNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne'aj lapanenpan tapatja gente nepénowa jisas mo'ó. Jesús jus tjunuc na, palá nipi'tjin̈ yupj. Yümücj tjowelepj yupj: —Jipj Dios Jatjam. ");
INSERT INTO jicNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús jis tjijyü'ta: —Po ma tjowelé la p'a jilal pjacj ne napj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús neven popa viyavin tjemey. Ne'aj 'etjele na, niyom nepénowa lis t'ya jupj. Tjevele ncul yupj, mpes tjiquil. ");
INSERT INTO jicNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dóceya lis t'ya, tjevele jupj apostolpan ca nsem yupj. Tjevele ca jupj lal mpatjam, ne jupj ca sin majamas p'a nt'a. Ne'aj pülücj jis walap'a'a ca mvelecj Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tjevele 'ücj ca jis müjü'tücj lapanenpan, mpes ca mal gente jisas mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ninana niyom dóceya jis lá: Simón pjaní wa (Jesús p'a ló la t'ya Simón mpes. Pedro ló la t'ya wa.) ");
INSERT INTO jicNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo pjaní wa, jupj tsüipe Juan ló pjaní wa, yupj ne Zebedeo jatjampan (Jesús la p'a jis lá lis t'ya wa yupj. Yümücj tjowelepj lovin, mpes Boanerges jis lá tjevele Jesús. T'i'ila pjac jin javelepj velecj cupj, cupj qjuis tin.) ");
INSERT INTO jicNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés p'a wa, Felipe p'a wa, Bartolomé p'a wa, Mateo p'a wa, Tomás p'a wa, Jacobo p'a wa, jupj ne Alfeo jatjam; Tadeo p'a wa, Simón p'a wa (Simón le palánatsja jepa lal, jepa israelpan popa tulucj. Nin mpes “Israel Mpes Jola” lotsja wa jupj.) ");
INSERT INTO jicNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote p'a wa. P'a jawas Judas Iscariote Jesús enemigo tepyala. Jis capj tjep'ya'sa Jesús enemigopan jis la tjilil jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yacjaya Jesús wama tjemey wosis ne'aj ton̈ca mo'ó. Niswa pülücj tjiquil, 'a jis tjimyula jupj nt'a. Mpes Jesús ma polel lyájatsja, ma wa tjalá jupj discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","La p'a tjowelepj niná Jesús pülücpan jis lal, jupj jamay lal wa. Mpes tjil yupj, Jesús lal la cuwis. Yuwá javeleptsja: “Malala jola jin liji jupj”. ");
INSERT INTO jicNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Niyom Moisés popel sin 'yüsa lajay malala wa tjowelepj Jesús po'ó. Jerusalén mpe tjiquil yupj. Tjowelepj: “Beelzebú pü'ü jupj jos mo'ó, se p'a'sa jupj. Nin mpes 'ücj pje'á jas tjejyama lapanen. Beelzebú diablo p'in. Jepa püné jupj lapanenpan jis lal.” ");
INSERT INTO jicNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yupj nin tjowelepj mpes Jesús yupj jis lal tjevele ncul. Parábola tjevele jupj, sin 'yüsa lis tjiji mpes. Tjevele: “Satanás ma polel pje'á se jamá jupj p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yuwá nyucunun̈ jepa pjaní jyü'ta nt'a, jis enemigopan 'ücj ca malala lis mijicj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nin p'iyá wosis pjaní nt'a patja jis lal. Yuwá nyucunun̈, jis enemigopan 'ücj ca malala lis mijicj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nin wa Satanás lal. Jupj pje'á se jamá jupj si jütüta sin popé, jupj enemigopan 'ücj ca malala la mijicj jupj. Jupj nin la qjuijis, jupj nucunú watsja jupj mpes p'iyá. Nin la qjuijis, len̈ way ca polel malala mpalas jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”Napj tsyupapj jupj, diablú. Nin mpes 'ücj lo 'ü'süs lejay jupj malala la tjijá. Diablo yom jas tjiyocj jinwá. P'a wa ma polel wama la winin la pecj yom jas tjiyocj wo mo'ó. Mwalá way ca ntsu'pas yom jas tjiyocj. Locopyaya 'ücj lo tjilil yom jas tjiyocj juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”Nin mpes nin velé Dios ma ca perdonar la numijis nun, nin tjowelé mpes. T'üc' way velé napj. Pjü way malala nyuca lajay, pjü way 'ücj perdonar liji Dios. Pjü malala javelepj Dios po'ó, jupj 'ücj perdonar liji wa. ");
INSERT INTO jicNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pjaní p'in ma perdonar liji. Malala javelepj Dios Cjües po'ó, Dios ma perdonar lis mijis. Yupj lovin malala nsem Dios lal.” ");
INSERT INTO jicNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nin tjevele Jesús. Niyom nepénowa tjowelepj lapanen jupj jos mo'o pü'ü, mpes nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús jamay ne'aj tjac', jupj jüpülücpan tjiquil wa. Wama ma polel jiltsja yupj, mpes pje'á lejen̈tsja yupj. Quelel javeleptsja Jesús lal. Mpes ne'aj tjatja sin popa pjaní jas tjajam wa mo'ó, lal ncuwim Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gente pülücj Jesús t'asiyú játjatsja, tjowelepj Jesús lal: —Jemay tjac', pyülücpan tjiquil wa, pje'á jatja quinam. Quelel jis januc yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús jis wala tjevele: —¿'Oyn nujola nun? ¿Pjacj napj namay? ¿Pjacj napj mpülücpan? ");
INSERT INTO jicNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","T'asiyú jatja yus tjinyuca Jesús, tjevele: —Nun napj namay jin p'iyá napj lal. Nun napj mpülücpan jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dios jos jin lojí, nun napj natjaypan jinwá, napj nta'apan jinwá, napj namay jinwá nun napj lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús tjemey 'üsǘ püné la nt'a. Sin 'yüsa la síjitsja ne'aj. Pajal pülücj 'a jis tjimyula jupj nt'a. Mpes barco wama tjemey, 'etjele jupj, más 'ücj la veles yupj jis walap'a'á. Pajal pülücj 'üsǘ la nt'a lejen̈tsja jis la pjac. ");
INSERT INTO jicNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pajal pülücj sin tji'yüsa lis tjiji jupj. Lovin parábola tjevele jupj, sin la 'üsüs jis la jay. Niná Jesús tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tjapja'aqué nun. Yom setel sine wínetsja. Na'aj li ts'iyá sínetsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mpes sine na, setel nepénowa palá tinca jümücj casá. Tsipyaya tjiquil, tjalá setel niná. ");
INSERT INTO jicNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Setel nepenowá pe casá palá tinca. 'Ots'ots' way 'amá 'alatsja ne'aj. Len̈ way tecyojo, 'amá tsjicj way p'in já'asatsja, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nin mpes malala tepyala jupj. Tjejyawca na, ts'iquenan̈. Ts'iquenan̈tsja jis ts'il 'amá casá way ton̈ca mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Setel nepénowa jam nt'a palá tinca. Jam jis t'yüna watsja. Pajal qjuisiyama tepyala, mpes jupj sínetsja ma si t'ünǘ. Ma tjevyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Setel nepénowa 'amá 'üsüs casá palá tinca. Tecyojo, jis t'yüna. 'Üsüs tjevyala. Nepénowa setel tréinteya tjevelan̈, nepénowa sesenta, nepénowa cien”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tjevele wa: “Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj tjevelé”. ");
INSERT INTO jicNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pjü way tjil na, Jesús discipulopan dóceya jupj lal játjatsja custjay. La p'a nepenowá jupj lal játjatsja wa. La tjü'üy Jesús lal tsjan mpes parábola mpes sin tji'yüsa lis tjiji. Más 'in costa la 'üsüs niná. ");
INSERT INTO jicNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús tjevele: “Dios ma se 'aya pjü sin 'yüsa 'oyn nyuca jyü'ta jupj. Jupj nu 'yaya nun ca nusin mü'üsüs niná. Nin tulucj yupj jis lal. Dios si jütüta sin popa tulucj yupj. Parábola mpes p'in sin 'yüsa lejay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mpes t'üc' ca nsem niná Dios Popel tjevelá: ‘Lovin ca nucucj, newa ma ca jus nlayecj tsjan nucucj yupj. Lovin ca mpjacan̈, newa ma ca sin mü'üsüs. Yupj newa ma quelel sa con̈ Dios, mpes Dios ma polel perdonar la siji. Nin mpes ma se 'aya sin 'yüsa yupj.’ ” ");
INSERT INTO jicNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús tjevele wa: “¿Ncu ma nusin 'yüsa parábola niná? Ma nusin 'yüsa niná, p'a wa ma wa ca nusin mü'üsüs nun. ");
INSERT INTO jicNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yom setel la ts'iya, nin p'iyá niná jupj pülücj jis lal vele Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gente nepénowa setel jümücj casá palá tinca jinwá yupj. Yupj pjyacan̈ Dios tjevelá. Locopyaya Satanás jac' la ta'es yupj tjepjyacan̈. Nin mpes yo' pe'e Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gente la p'a, setel pe casá palá tinca jinwá yupj. Yupj pjyacan̈ Dios tjevelá. Japon yupj. 'Ücj jisas se palá tjepjyacan̈ mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tsjutsj jis ts'il 'amá casá way ton̈ca jinwá yupj. Tsjicj way p'in japon. Locopyaya malala se palá ca nacj. La p'a malala la sajay napj lal japon mpes ca nacj. Nin tepyala na, len̈ way p'a casá yola se palá yupj. Ma quelel sa con̈ quinam Dios. ");
INSERT INTO jicNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gente la p'a setel jam nt'a palá tinca jinwá yupj. Pjyacan̈ wa Dios tjevelá. Japon yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mop'in pajal nin yola nosis casá lajay mpes. T'emel pülücj jisas yupj. Yola t'emel pajal 'üsüs; t'üc' tulucj niná. Jisas ca pülücj nta'acj nosis casá. Mpes lovin ma lajay Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gente la p'a wa setel 'amá 'üsüs casá palá tinca jinwá yupj. Pjyacan̈ Dios tjevelá, jisas wa niná. Yupj nin lajay Dios tjevele jin. Yupj 'üsüs pajal; setel sine, cyojo, vyala jinwá yupj. Nepénowa treinta velan̈ jinwá yupj. Nepénowa sesenta velan̈ jinwá yupj. Nepénowa cien velan̈ jinwá yupj”, nin tjevele Jesús Dios Popel pjyacan̈ mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús tjevele yupj jilal: “Nenéyawa nun sin popa pjaní 'iyó je si müjü, que'e jupj. Nin liji na, ma tsjo'oy 'alá pyünta. Ma cjan 'alá pyünta. Campanya pyünta pjü 'ücj jis la nuc. ");
INSERT INTO jicNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nin p'iyá, Dios ma mpja'nes jupj quelel sin 'yüsa liji. Püna ma jis tje'yaya sin la 'üsüs, niná quelel sin mü'üsüs la mijis jupj. Püna ma sin tji'yüsa, niná ca jus nlayecj. Niná 'ücj ca jus nucucj nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj velé. ");
INSERT INTO jicNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","”Po nujola t'as pjo'oqué mpes. Nun quelel nin lojí Dios velá, jupj pülücj ca nusin 'yüsa la mijis. Más 'üsüs la mijis ca jupj nun la tjüjí lal. ");
INSERT INTO jicNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nun quelel nusin 'yüsa Dios velá, mpes más pülücj ca nusin 'yüsa la mijis Dios. Nin p'iyá pjü jis lal. Dios jisas, mpes ca sin mü'üsüs. Nepénowa ma quelel sin 'yüsa Dios velá. Pjyacan̈ p'in. Mpes ca ma polel sin 'yüsa Dios velá. Sey c'a ca la mijis jupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús tjevele wa: “Napj ca nusin mü'üsüs la mejay 'oyn nyuca liji Dios nosis casá. Yom setel sine jinwá liji. Yom setel witjacj la ts'iya. ");
INSERT INTO jicNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Setel cyojo, si t'ünǘ. Jaw na, püste na, newa si t'ünǘ. Yom jya na nin p'iyá, si jünsa na nin p'iyá. Yom niná ma selé 'onin ne nin lovin si t'ünǘ. ");
INSERT INTO jicNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jupj sin nin cyojo 'amá mpe, lejen̈ yupj. Mwalá way 'elyon pyala. 'Elyon tepyala na, ts'ituju. P'a jawas wolas velan̈. ");
INSERT INTO jicNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wolas ts'its'e na, 'ücj jat'anapj quinam. Mpes jat'anapj, jacutj yupj. Nin p'iyá ca nsem gente jis lal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús tjevele wa: “¿Tsjan ca mpalas Dios si jütüta jis lal? Parábola ca mvelé, mpes ca nusin 'yüsa la mejay tsjan ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza setel jinwá ca nsem. Mostaza setel más tsjicj way pjü setel jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sine na, t'yüna jupj. Más püné t'yüna la p'a tsjutsj jilal. Campanya ton̈ca. Jis pjel campa se palá. Mpes tsipyaya jiquil, 'ücj lejen̈ jupj pjwel casá, tsjojoca nt'a. Nin p'iyá ca nsem Dios si jütüta jis lal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","P'a wa parábola witjacj tjevele Jesús yupj jilal. Parábola mpes sin tji'yüsa la tjiji Dios tjevelá. 'Ücj sin 'yǘsatsja, nin p'in tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Parábola p'in tjevele jupj, pülücj 'a jis tjimyula jis lal. Jusapj tjá'asa na jupj discipulopan jis lal, sin tji'yüsa lis tjiji tsjan quelel véletsja parábola mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yacjaya, t'yaja na, Jesús tjevele jupj discipulopan jilal: —Mas 'üsǘ püné na'aj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mpes len̈ way tjil jupj lal. Tjil pülücj 'a jis tjimyula mpe. Así 'ücj liji secj tjemey Jesús. Barco la p'a wa tjil wa yupj jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pajal jas tjelyapjünǘ lüpjǘ 'üsǘ püné nt'a. 'Üsǘ la tjepjetpjets'é tepyala. 'Üsǘ wama tjemey barco mo'ó, ne quelel pít'atsja barcas. Campwila quelel jámatsja. ");
INSERT INTO jicNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús barco cjüip'a'a pǘ'ütsja, jyatsja. Pülül jay pálatsja jupj. Jupj discipulopan jas tiquilquil. Tjowelepj: —Qjuis Jepa, qjuis qjues nt'ancam, nca'lequecj ca ncupj. ¡Qjuiyola ma jele jipj! ");
INSERT INTO jicNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jas nisa Jesús. Cus tjeve'le lüpjǘ. Cus tjeve'le wa 'üsüs. Mpes lüpjǘ 'üt'ün nasa tepyala. 'Üsǘ 'üt'ün nasa wa. ");
INSERT INTO jicNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús jis la tji'yüya jupj discipulopan jilal: —¿Tsjan mpes locj jeyatsja nun? ¿Ncu ma poné custjay napj polel nucopj p'yacj? ");
INSERT INTO jicNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yupj pajal lacj tjeyaptsja. Yuwá tjowelepj: —¡T'üc' way yom niná pasal püné way! 'Ücj si jütüta lüpjǘ, 'üsǘ 'ots'ipj, ne nin lajay jupj jyü'ta jin. ");
INSERT INTO jicNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yupj tjil 'üsǘ püné na'aj po'ó. Gadara lotsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Barco mpe pje'á tjemey Jesús 'amá nt'a. Yom tjac' la nüjüsü jupj panteón mpe. Lapanenpan pülücj pátjatsja jupj jos mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yom niná lovin tüpǘ'ütsja panteón mo'ó. Pajal jas tjiyoctsja jupj. La p'a ma polel tsupaptsja jupj, 'üpǘ t'anca jupj lovin. Nin p'iyá cadena lal, t'anca wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","La pülücj jupj mos t'asiyú tsupaptsja, tsjom t'asiyú tsupaptsja wa acero mpes, cadena mpes wa. Lovin t'anca jupj cadenas. Lovin tji'yula aceras. Mpes lovin polel jámatsja la p'a tsupaptsja na. ");
INSERT INTO jicNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lovin tjuwine panteón nt'a, joc' mo'ó 'ots'ipj. Ne'aj tjuwine jaw na, püste na 'ots'ipj. Newa la tipiya, jupj jüp'üy newa t'yüjü wa jupj, pe mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jupj jus tjinyuca Jesús campa mpe, ne ts'üequené Jesús nt'a. Jesús wolap'a'a tüic' jin tjüjünsü jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yümücj la tipiya: —¿Tsjan mpes napj nt'a tjacuy? Jesús jipj. Dios Jatjam jipj, Dios ne más püné pjü jilal. Najas mvelen Dios lal ma ca malala la mijin napj lal —lapanen nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yom jactsja na p'in, Jesús tjevele nas yom lal: —Lapanen jipj. ¡Jutja jipj jupj jos mpe! ");
INSERT INTO jicNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús la tji'yüya: —¿Tsjan lyá jipj? Jupj tjevele: —Pülücj napj nlá. Cupj cjay pülücj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jupj pajal la tjemyona Jesús lal ma ca sin majamas lapanenpan quepem. ");
INSERT INTO jicNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne'aj neven nt'a malana pülücj tjelyawun̈tsja, tjalatsja. ");
INSERT INTO jicNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lapanenpan la tjomon Jesús lal: —Qjuis tjijyü'ta nlaca malana nt'a. Qjuis ma'ayan nlaca malana jisas mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús tjevele 'ücj jis la winin yupj nt'a. Mpes lapanenpan tjil yom jos mpe. Tjil malana jisas mo'ó. Jisas mo'o tjil na, malana ts'equenen̈ neven palavin. Mil mat'e waytsja yupj. 'Üsǘ püné mo'o tjil. Jis qjues t'anca yupj, tecya'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Malana jajamapj niná tjunuc na, ts'equenen̈ yupj. Pülücj patja nt'a tjowelepj nin tepyalá. Wa pjaní pjaní lejen̈ nt'a tjowelepj wa yupj. Mpes pülücj tjil jis la nuc niná tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús nt'a tjil na, jus tjunuc yomen lapanenpan pülücj pátjatsja jupj jos mo'ó püna p'in. Ne'aj tjá'asa. Sa capyatsja jupj, 'ücj jólatsja quinam. Lacj tjeyapj yupj nin tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","P'a witjacj tjunuctsja Jesús tji'yü'sa la tjiji yomen. Mpes yupj tjowelepj la p'a jis lal tsjan tepyala yom lal, lapanenpan jupj jos mo'o tapatja p'iyá. Tjowelepj wa tsjan tepyala malana jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nin mpes ne'aj tapatjá pajal la tjomon Jesús lal jupj ca mim yupj nepé. ");
INSERT INTO jicNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mpes Jesús barco wama tjemey. Custjay ma tjemey na p'in, niná yomen, lapanenpan jupj jos mpe tjil p'iyá, jupj tjevele Jesús lal. La tjemyona Jesús lal jupj ca ma'ayas jupj lal ca mim, cus la con̈. ");
INSERT INTO jicNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús ma tje'yaya tjemey jupj lal. Tjevele: —Jutja jipj wya nt'a. Wya nt'a patja jis lal mvelen jipj Jepa Dios pajal 'üsüs la tjiji jipj mpes. Mvelen ca jupj jólatsja malala 'e tepalá —nin tjevele Jesús jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mpes yom tjemey quinam. Decápolis nt'a pülücj jilal tjevele Jesús pajal 'üsüs way la tjiji jupj mpes. Yupj pjü way pajal yólatsja Jesús pajal 'üsüs la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús 'üsǘ na'aj po'ó tjemey niswá barco mpes. Ne'aj tjil na, barco mpe tjemey. Pülücj 'a jis tjimyula Jesús nt'a, 'üsǘ la nt'a tón̈catsja na. ");
INSERT INTO jicNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yom pjaní Jairo ló tjac' wa. Jupj jépatsja judiopan 'a jis tjimyula nt'a. Jus tjinyuca na Jesús, tüic' jin tjüjünsü jupj Jesús wolap'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pajal la tjemyona Jesús lal: —Ncucus tsjicj quelel pe'e. Was nawá nt'a. Najas po la mo'ot'en ncucus, ne mü'ü'süs ca jupj, ca jupj mpü'üm. ");
INSERT INTO jicNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mpes Jesús tjemey jupj lal. La p'a wa pülücj cjüil tjil. Cus tjeletjatj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Quepj malala jostsja ne'aj wínetsja. Año dóceya newa 'os tepyálatsja, ma tji'yü'sa jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lovin leméliyu jaylacj la tjíjitsja jupj doctor lal. Malala tepyala p'in leméliyu mpes. Pjü jupj t'emel tecyawaja. Lovin ma tji'yü'sa, más 'in malala jos tepyala p'in. ");
INSERT INTO jicNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jupj wola tjowelepj Jesús polel jis mü'ü'süs la mijis malala jisas. Mpes Jesús cjüil tjemey. Po la tje'yot'a Jesús jas quip. ");
INSERT INTO jicNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jupj jólatsja: “Jesús jas quip po le 'otj p'in, ma 'ü'süs ca napj”, nin jólatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Len̈ way tji'yü'sa jupj. 'Os tjapjaja quinam. Tji'yü'sa jin jostsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nin tepyala na, Jesús seletsja tji'yü'sa la tjiji jupj. Mpes la nujuya, jis la tji'yüya 'a jis tjimyula jis lal: —¿Pjacj po la tje'yot'a nin quip? ");
INSERT INTO jicNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jesús discipulopan tjowelepj Jesús lal: —Jipj selen pülücj t'asiyú lejen̈ jipj nt'a, cyapj jaletjatj. ¿Tsjan mpes jis la tji'yüy pjacj jin po la tje'yot'a? ");
INSERT INTO jicNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús yus nyúcatsja custjay. Quelel jus nléyatsja custjay pjacj po la tje'yot'a jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Quepj seletsja jupj tji'yü'sa quinam, mpes tjemey Jesús nt'a, tüic' jin tjüjünsü jupj Jesús wolap'a'á. Ticyücüyütsja, pajal lecj tjeyatsja mpes. Jesús lal tjevele pjü way jupj la tjijá. ");
INSERT INTO jicNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús tjevele: —Jipj tepyon napj polel 'i 'ü'sa lejay. Nin mpes 'i tjü'ü'sa jipj. 'Üsüs way mim quinam jipj. Lovin ca 'ücj winim quinam jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Newa jupj lal véletsja na, niyom nepenowá tjiquil Jairo wo mpe, jupj ne jépatsja judiopan 'a si mulú nt'a. Tjowelepj: —Jipj cyucus tepe'e. Más 'ücj ma le mon quinam qjuis Jepa lal. ");
INSERT INTO jicNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús tjapjaca jepa lal tjoweleptsja. Tjevele jepa lal: —Po ma lecj tjeyá. Tepyona p'in napj polel cyapj p'yacj. ");
INSERT INTO jicNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús jostsja la p'a ma ca mal quinam jupj lal. Nepénowa cus tocon̈ p'in. Pedro pjaní waytsja, Jacobo pjaní waytsja, Juan p'a watsja. Juan Jacobo tsüipe waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tjil na jepa wo nt'a, Jesús yus tjinyuca gente pülücj ne'aj, yümücj pjac la tjajaytsja. Yümücj la tupuyuptsja. ");
INSERT INTO jicNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús wama tjemey, jis la tji'yüya: —¿Tsjan mpes yümücj pjac lojí? ¿Tsjan mpes pajal lu puyú? Tsjicj tepe'e tulucj. Tjejyá p'in. ");
INSERT INTO jicNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yupj tjuwi'in̈ jupj tjevele mpes. Jesús pjü pje'á sin tjejyama. Tsjicj popay, jamay jis lal tjemey tsjicj pǘ'ütsja nt'a. Jupj discipulopan ne'aj cus tocon̈, yupj tsjicj pü'ü nt'a tjil wa. ");
INSERT INTO jicNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús ntjüi'le tsjicj mos. Tjevele tsjicj lal: —Talita, cumi. (Cupj velecj: “Tsjicj, jipj lal velé napj, jin tjijyünsa”.) ");
INSERT INTO jicNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Len̈ way jas tjijyünsa jupj. Tjuwine jupj quinam (Año doce tyá'atsja jupj.) Yupj ne'aj tjelejen̈ pajal yólatsja pajal 'üsüs tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús jis tjijyü'ta tsjicj popay lal, jamay lal wa, ma jis la veles la p'a jilal niná tepyalá. Jilal tjevele wa ma'ayacj la las tsjiquis. ");
INSERT INTO jicNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nepé tjemey quinam Jesús. Püna tüpü'ü nt'a tjemey jupj discipulopan jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado tjejyawca na, judiopan 'a si mulú nt'a tjemey. Sin tji'yüsa lis tjiji ne'aj. Tjepjyacan̈ sin popa pülücj pajal yólatsja jupj 'üsüs tjevele mpes. Tjowelepj yuwá: —¿Ca'aj tjemey yom niná jas la 'üsüs niná? ¿Tsjan mpes pajal selé jupj? ¿'Oyn nyuca pajal 'üsüs liji, yom p'in ma polel lijá? ");
INSERT INTO jicNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Silla líjitsja, cjan líjitsja pǘ'ütsja jupj. Jupj María jatjam p'in. Jupj püné tulucj. Selecj wa jupj jatjaypan jis lá: Jacobo pjaní wa, José p'a wa, Judas p'a wa, Simón p'a wa. Jupj to'opan qui'á patja wa cupj qjuis lal —nin tjowelepj yuwá. Mpes ma jisastsja Jesús. Ts'a tji'in jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nin mpes yupj jilal tjevele jupj: —Nun ma jisas napj velé, napj nun jis lal tüpü'üs mpes. Nin lovin profetapan jis lal. P'a nt'a patja jisas profeta vele Dios mpes. Jupj pü'ü nt'a p'in ma quelel japon jupj 'üsüs. Jupj jüpülücpan p'in ma yola jupj 'üsüs. Nin p'iyá jupj wo nt'a —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mpes Jesús ma polel 'üsüs la tjiji ne'aj, Dios p'in 'ücj liji jinwá. Yupj ma topon püné waytsja jupj, ne nin. Malala jisas nepenowá po la tje'yot'a la p'in. Jis tji'yü'sa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne'aj tapatja ma topon Jesús pajal 'üsüs líjitsja. Jesús jólatsja yupj pajal sey c'a, yupj ma topon mpes. Locopyaya p'a nt'a tjemey. 'A mulú patja nt'a wínetsja, sin 'yüsa la síjitsja. T'üc' sin 'yüsa lis tjiji na, p'a nt'a tjemey lovin. ");
INSERT INTO jicNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús discipulopan dóceya jilal tjevele jis la cuwis. Sin tjejyama, mat'e mat'e ca mal, ca tsji' la mijicj jupj mpes. Jis tje'yaya 'ücj pje'á la ts'i lapanenpan. ");
INSERT INTO jicNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yupj jis lal tjevele wa 'oyn nyuca la mijicj yupj, tjil na. Ninana Jesús tjevelá yupj jis lal: “Nun lowú na tsji' la müjí napj mpes, ma ca nt'a nun p'a jawasa nujisas mpes. Tjacjaj p'in 'ücj t'o nun, lowú na. Po ma ve t'o, yacjaya nu lo las. Ma tjamá 'opos. Po ma t'o t'emel. ");
INSERT INTO jicNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'Ücj caite nun jis tsjom pwi'tjí, nin p'in ma mát'eya nun sin quip nlawú. ");
INSERT INTO jicNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wa pjaní nt'a 'yaya nu la püt'üs nun, janmacj jupj wo nt'a tapatjaqué, yupj patja nepé lowú nas. ");
INSERT INTO jicNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nepénowa ma ca jisas nsem nun tjuculá yupj nt'a. Ma ca quelel mpjacan̈ nun welé napj mpes. Mpes yupj mpe lowa. Nun lowú na nepé, nun jis tsjam sin tjowowojó, ca palá jis ntüncüs pjüpjüs. Mpes ca sin mü'üsüs la müjí Dios ma japon jinwá yupj quinam. Dios ca pajal jis capj ntülüs, malala la tjajay jis capj tyüla na. Más ca jis capj ntülüs yupj, Sodoma nt'a tapatja jilal. Más ca jis capj ntülüs yupj, Gomorra nt'a tapatja jilal. T'üc' way niná”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mpes Jesús discipulopan dóceya tjil yupj. Tjowelepj pülücj jis walap'a'á más 'ücj yupj ca 'aplijila nsem malala nyuca la tjajay mpes. Tjowelepj más 'ücj ca 'üsüs la mijicj quinam Dios jos jin. ");
INSERT INTO jicNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lapanenpan jilal tjüjütütj wa jis la winin gente jisas mpe. Malala jisas aceite sey tjocjolol wa jis la 'ü'süs. ");
INSERT INTO jicNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes jepa pünetsja Galilea mo'ó. Jupj wola tjowelepj wa Jesús pajal 'üsüs la tjiji mpes. Pjü ne'aj tapatja jus nlaytsja Jesús po'ó, mpes nin. Yupj nepénowa javeleptsja: “Jesús Juan el Bautista p'iyá. Jas tjijyünsa, niswa la püt'üs jupj. Nin mpes 'ücj 'üsüs liji Jesús, yom p'in ma polel liji jinwá.” ");
INSERT INTO jicNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","La p'a wa tjowelepj: “Elías jupj”. P'a witjacj tjowelepj: “Profeta jupj, profetapan püna tapatja jinwá”. ");
INSERT INTO jicNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes wola tjowelepj na Jesús po'ó, jupj tjevele: “Jesús ne Juan el Bautista p'iyá. Napj tjijyütütj jupj mwen taná la jocj, tepe'e jupj. Quina jas tjijyünsa, pü'ü niswá”, nin tjevele Herodes. ");
INSERT INTO jicNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Püna tjijyü'ta jis la tjilil Juan, ne nin. Tjijyü'ta la tsupapj, la 'onsos jupj cawilta mo'ó. Nin la tjiji Herodías mpes. Herodías Herodes vosastsja. Herodes jatjay Felipe jats'om waytsja jupj, Herodías. Locopyaya Herodes tjowaya wa jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan lovin véletsja Herodes lal: “Malala Dios lal jipj vyasas myanun. Jetjay jats'om jupj.” ");
INSERT INTO jicNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nin mpes Herodías lovin ts'i 'inyatsja Juan el Bautista lal. Quelel 'yǘ'natsja jupj, newa ma polel líjitsja niná. ");
INSERT INTO jicNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes tjejyama Juan el Bautista, ne nin. Lecj tjeyatsja Juan el Bautista lal. Jupj seletsja Juan 'üsüs waytsja. Seletsja Juan 'üsüs waytsja Dios lal. Nenéyawa Juan tjevele Herodes lal. Herodes 'ücj jos tjapjaca Juan tjevelá, lovin ma jas tji'yüsa tjapjacá. ");
INSERT INTO jicNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","P'a jyawca na, Herodías 'ücj malala la tjiji. Herodes p'a año tepyala na, pülücj la tjiji jis la las. Jis lal tjevele ncul jupj auxiliar noypan, jepa militarpan 'ots'ipj, niyom noypan Galilea mpe ne'espan 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodías jucucus wama tjac', bailar la tjiji jis la nuc. Herodes pasal 'ücj jostsja tjinyuca mpes, la p'a 'ücj jisastsja wa. Mpes Herodes tjevele jupj lal: —La monan napj lal jipj jyas jin. Jipj le mon mya 'a ca. ");
INSERT INTO jicNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","T'üc' way velé napj, Dios pjoca. Jipj le mon, mya 'a. La mitad way nas napj jyütütj popé 'ücj 'e 'a —nin tjevele Herodes. ");
INSERT INTO jicNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pje'á tjemey jamay nt'a. Jupj lal la tji'yüya: —¿Namay, tsjan jyas napj le mon? Jamay tjevele: —Mvelen ca jipj jyas Juan el Bautista jay pjucj —nin tjevele jupj jamay. ");
INSERT INTO jicNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Len̈ way tjemey Herodes nt'a, tjevele: —Najas nca'an ma 'en Juan el Bautista jay pjucj plato püné mo'ó quinam —nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes pajal 'aplijila tepyala jupj tjevele mpes. Ma quelel líjitsja niná, tsjücjüim la tjemyona mpes la tjiji p'in. Jupj nasa tjevele jupj 'ücj la 'ayas jupj la tjemyoná. Tjevele wa Dios tjapjaca. Pjü ne'aj tjepjyacan̈ jupj tjevelá. Yupj nasa tjiquil watsja, Herodes pülücj jis la las la tjiji mpes. Nin mpes ma quelel véletsja ma ca ma'ayas niná. ");
INSERT INTO jicNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mpes len̈ way tjijyü'ta jomozo Juan el Bautista mwen taná la jocj, nca'as jay pjucj. Mpes jomozo tjemey cawilta nt'a. Juan el Bautista mwen taná tjejyo'o. ");
INSERT INTO jicNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jupj jay pjucj teque'e plato püné mo'ó, tje'yaya tsjücjüim. Tsjücjüim jupj jay pjucj tje'yaya jamay. ");
INSERT INTO jicNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan el Bautista discipulopan jus nlaytsja niná tepyalá, mpes tjiquil. Juan el Bautista jüp'üy tjajam, tüpüntüpj pe jul mo'ó, neven nt'a, tepe'e 'ücj la püntüs nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolpan tjiquil Jesús sin tjejyama mpe. Tjowelepj Jesús lal tsjan la tjajay yupj tjil nt'a. Tjowelepj wa tsjan sin tji'yüsa la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gente pülücj jiquiltsja Jesús nt'a. Newa tjiquil nepenowá, newa tjil nepenowá. Mpes ma polel jalatsja yupj. Jesús tjevele jupj apostolpan jilal: —Napj lal 'alas. Ca nlaca jis wa cjuwá nt'a, ne'aj tsjicj way ca mpatjaquecj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mpes yusapj tjil barco mpes, jis wa cjuwá nt'a tjil. ");
INSERT INTO jicNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pasal pülücj yus tjunuc tjil yupj. Ne'as jus tjunuc Jesús jupj discipulopan jilal. Mpes ts'equenen̈ 'üsǘ t'asiyú. Pasal pülücj nin la tjajay, tjil yupj tapatja mpe. Mwalá way ne'as tjil Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús ne'as tjemey na, gente pasal pülücj yus tjinyuca, játjatsja jus la nuc. Pajal jólatsja yupj mpes. Oveja yusapj jinwatsja yupj, len̈tsja pjacj jis cüjamas. Mpes pülücj sin tji'yüsa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pajal t'awaná nasa. Mpes Jesús discipulopan tjiquil jupj nt'a, tjowelepj: —T'awaná quinam. Wa cjuwá qui'á. ");
INSERT INTO jicNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mpes pjü sin tjejyama, ne'aj ca mal jis wa pjaní pjaní lejen̈ nt'a, jis wa nepénowa lejen̈ nt'a wa. Ca ve jaylacj la mijicj jis la las —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús jis wala tjevele: —Nun p'iyá jis tja'ayá, nlajacj yupj. Yupj tjowelepj: —¿'Oyn la qjuijicj la qjuijim nenem cupj? ¿Ncu jyas cupj ca nlaca ca pan jaylacj la mijicj? Yom pjaní mes ocho tsji' liji jaylacj nsem niná, ne pjü t'üc' nlajacj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús jis la tji'yüya: —¿Pan nol to'á? Lowa nucú —tjevele. Tjunuc na, tjowelepj: —Pan cinquiyá, cjul mát'eya tya'acj cupj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús tjevele yupj jilal jis müjü'tücj pjü way 'a mulú 'a mulú majatjum tsjutsj lejen̈ nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mpes pjü 'atjalapj yupj. Cien cien 'a mulú játjatsja nepenowá. Cincuenta cincuenta 'a mulú játjatsja nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús nt'ya pan cínquiya, nt'ya wa cjul mát'eya. Tjinyuca tsjun po'ó, tjevele Dios lal tjüwüi'i ve tje'yaya mpes. T'üc' tjevele na, la tjelepta taná pansas. Jis tje'yaya jupj discipulopan jis la 'ayas ne'aj tjatjá. Nin p'iyá la tjiji cjulun lal. ");
INSERT INTO jicNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yupj pjü t'üc' tjalá. Pjü jis col tipit'a tepyala. ");
INSERT INTO jicNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma polel pjü tjalá. Mpes discipulopan quiliyú noypan dóceya tipit'a la tjajay yupj pansas lal, cjulun lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jesús pajal 'üsüs la tjiji, mpes niyom cinco mil t'üc' tjalá jupj jis tje'yaya popé. ");
INSERT INTO jicNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pjü t'üc' tjalá na, Jesús jis tjijyü'ta jupj discipulopan barco mo'o jis la winin. Sin tjejyama 'üsǘ püné na'aj po'ó, Betsaida nt'a, jupj quelel jámatsja nt'a. Jesús jostsja yupj mwalá way ca mal jupj lal, jupj la p'a sin tjejyama nas. Mpes tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pjü sin tjejyama na, neven po'ó tjemey, Dios lal la veles. ");
INSERT INTO jicNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Püste tepyala na, jupj discipulopan barco mo'o játjatsja 'üsǘ püné culupwen nt'a. Jesús jusapj já'asatsja 'amá nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yus tjinyuca yupj pajal tsji' la tjajaytsja tjil. Lüpjǘ püné jis wala séjetsja, ne nin. Pǘstetsja custjay. Nasa quelel jyawca na, Jesús tjac' yupj nt'a. 'Üsǘ casá wínetsja jupj. Barco la quin quelel jámatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Discipulopan jus tjunuc, ma jus nlaytsja Jesustsja jupj. Tepe'e cjües wine p'in, nin yólatsja yupj. La tupuyupj ");
INSERT INTO jicNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","jus tjunuc na. Pasal lacj tjeyaptsja. Len̈ way Jesús tjevele: “'Ücj nujisas t'as. Napj ne p'in winis. Po ma locj tjeyá nun.” ");
INSERT INTO jicNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesús barco wama tjemey yupj tjatja nt'a. Wama tjemey na, lüpjǘ 'üt'ün tepyala. Jupj discipulopan pajal yólatsja 'üsüs tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","T'an̈ p'in tjunuc Jesús 'üsüs la tjiji pan lal. Newa ma sin tji'yüsa tsjan mpes 'ücj nin la tjiji jupj. Ma polel sin 'yǘsatsja Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","'Üsǘ na'aj po'ó ne'as tjil, Genesaret lotsja ne'aj. Barco tsupapj, ma la winin barcas. ");
INSERT INTO jicNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Barco pje'á tjil na p'in, gente pülücj jus tjunuc Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mpes jun ta'á ts'equenen̈ tjil yupj, malala jisas tucuman hamaca mpes Jesús nt'a. Jupj p'a nt'a tjemey na, la p'a wa jis wala tjowelepj ca'aj tjemey, ne malala jisas tjajam wa ne'aj jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lovin nintsja. Jupj tjemey nt'a, jis wa nepénowa lejen̈ nt'a, pülücj patja nt'a wa, jis wa pjaní pjaní lejen̈ nt'a wa, lovin tucuman malala jisas jupj nt'a. Pülücj 'a si mulú nt'a tüpüntüpj yupj. Pajal la tjomon Jesús lal jupj ca jis ma'ayas malala jisas po la 'otj jupj jas quip la nt'a. Quelel po la 'otsja jupj jas quip la nt'a la p'in, jis la 'ü'süs. Pjü way jas quip po la tjo'otj, pjü way jis tji'yü'sa yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Niyom nepénowa tjiquil Jerusalén mpe, 'a jis tjimyula Jesús nt'a. Nenem nepénowa fariseopan, nepénowa Moisés popel sin tji'yüsa lajaytsja la p'a jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yus tjunuc Jesús discipulopan nepenowá jalatsja na. Ma jis mas tapatsj, judiopan püna la tjajay jinwá. Yupj sin tjalá. Mpes niyom nenem yólatsja malálatsja discipulopan Dios lal. Yólatsja te jinwatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseopan quelel jalá na, yupj jis mas japatsj, ca jis mas 'üsüs nsem niswá Dios lal. Nin p'iyá lajaytsja pjü judiopan. Judiopan püna tapatja nin lajaytsja, mpes newa nin lajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ve jaylacj lajay na jis la las, niná jis wa nt'a jacutj. Quelel jalá na, jis mas japatsj mwalá way p'in. Ma jis mas japatsj, ma jalá. La p'a nin p'iyá lajay wa, püna tapatja nin la tjajay mpes. Pocillo japatsj wa püna tapatja la tjajay jinwá. Nin p'iyá jarro japatsj wa, tsjo'oy nin p'iyá, jalá nt'a nin p'iyá.) ");
INSERT INTO jicNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nin mpes Jesús lal tjowelepj fariseopan, Moisés popel sin 'yüsa lajay jupj lal tjowelepj wa. La tjü'üy: —¿Tsjan mpes jipj discipulopan ma lajay judiopan püna la tjajaytsja jinwá? Jipj discipulopan quelel jalá na, ma jis mas japatsj judiopan lajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús jis wala tjevele: —Nun welé nun p'iyá 'üsüs lojí, newa nun 'üsüs lojí tulucj. Püna Isaías t'üc' way tepyaca nun po'ó. Profétatsja jupj, Isaías. Dios mpes tjevele jupj. Tepyaca Dios tjevelá. Dios tjevele: ‘Gente niná 'üsüs javelepj napj nin po'ó, newa ma quelel la najay. ");
INSERT INTO jicNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yupj javelepj napj püné, newa ma lajay napj najas jinwá. Yupj sin 'yüsa lajay gente jajütütj p'in, napj velé jin sin 'yüsa lajay tulucj’, nin tjevele Dios nun po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","”Ma lojí quinam Dios tjijyü'ta jin. Nin lojí judiopan püna tapatja lajaytsja jinwá p'in. Nin lojí jarro po'í na. Nin p'iyá lojí pocillo lal. La p'a pülücj nin p'iyá lojí wa. ");
INSERT INTO jicNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma lojí Dios tjijyü'ta jin. Nin p'in lojí judiopan püna tapatja lajaytsja jinwá. Nun nujola pasal 'üsüs nin lojí. ");
INSERT INTO jicNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Püna Moisés tjevele: ‘'Üsüs la müjí nun jis papay lal, nun sejamay lal wa. Nujola nsem noypan yupj nun jis lal. Nun ma ca mvelé nujisas malala jis mpalas nun jis papay, nun sejamay. Nun popa nin cüweles, nun ca mü'ü'ná jupj, malala tjevele mpes’, Moisés nin tjevele püná. ");
INSERT INTO jicNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nun ma nin p'iyá jü'tǘ, Dios tjevele jin. T'emel cjuwá nun jis papay, nun sejamay ca nacj. Nun cjuwá tulucj. Nun welé 'ücj ma 'oyá yupj jisas. Nun welé nun popa pjaní 'ücj vele yupj jis lal: ‘Ninana napj nats'a'á ma ca nu ma'ayá. Nasa tjeveletsja ninana ca ma'ayá Dios mpes’, nin welé jupj 'ücj ca mveles. ");
INSERT INTO jicNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nujisas jupj ma 'üsüs la mijis popay mpes, jamay mpes wa. ");
INSERT INTO jicNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nun lojí judiopan püna la tjajay jinwá p'in. Mpes ma nin lojí Dios tjevele jinwá. La p'a pülücj nin p'iyá malala lojí —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pülücj way játjatsja Jesús ne'aj p'in. Niswa tjevele ncul yupj jupj nt'a. Tjiquil na, jupj tjevele yupj jis lal: —Pjü way tjapja'aqué. Nusin tjü'üsüs napj velé. ");
INSERT INTO jicNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nun lojá na, ma malala nsem nun Dios lal, niná tjalajá mpes. Lampe pyacj mpes p'in, malala nsem nun Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj tjevelé —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Locopyaya Jesús tjemey pülücj 'a jis tjimyula mpe. Wama tjemey jupj tüpü'ü nt'a. Jupj discipulopan tjowelepj jupj lal ma sin tji'yüsa parábola niná. ");
INSERT INTO jicNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús tjevele: —¿Ncu ma wa nusin 'yüsa nun? Nun lojá na, ma malala nsem nun Dios lal niná tjalajá mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ve tjalajá na, nucol mo'o jama p'in. Locopyaya na'aj lo ts'iyá nun jis p'üy mpe. Newa nin nujola nun, püna nujólatsja jinwá. (Mpes Jesús tjevéletsja pjü 'ücj la las, pjü 'ücj lyajacj. Ma ca malala nsem cupj Dios lal cupj lyajacj mpes.) ");
INSERT INTO jicNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tjevele: —Lampe pyacj mpes p'in, malala nsem nun Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nin lovin. Malala yola, malala lajay. Yupj p'iyá malala, ne nin. Malala yola, mpes nin p'in yola yupj. Nin mpes wa niyom jamanun tsjücjüimpan tjewyayin̈ tulucj. Nin mpes wa pequen̈. Nin mpes wa sa 'ünan la p'a. Malala yola, mpes wa ne'aj jamanun sejats'om tulucj. Mpes wa nequem lyawun̈ jis vayum tulucj jis lal. Yupj malala yola, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nin mpes wa ts'isin̈. Nin mpes wa jisas ca malala mpalas la p'a. Malala yupj, mpes nin. Nin mpes wa la tsuwil. Nin mpes wa yupj jisas jin lajay. Nin mpes wa ts'a 'in 'üsüs tepyala la p'a wa lal. Nin mpes wa pajal malala javelepj la p'a po'ó. Nin mpes wa yola yupj p'iyá pajal püné way. Nin mpes wa ma yola jin lajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Malala yola, mpes nin lajay. Malala yupj Dios lal nin lajay mpes p'in —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús nasa tjemey nepé. Campa 'in tjemey judiopan patja mpe. Jupj tjemey nt'a Tiro po'o patja ne'aj p'intsja, Sidón po'o patja ne'aj p'intsja wa. Wa pjaní wama tjemey. Jostsja gente ma ca jus nlayecj ne'aj já'asatsja. Newa nin, jus nlaytsja ne'aj tjac' jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Quepj pjaní jus nleya na Jesús po'ó, len̈ way tjac' jupj. Lapanen pǘ'ütsja quepj jucucus jos mo'ó. Mpes tjac' jupj Jesús nt'a, tüic' jin tjüjünsü Jesús wolap'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Griego waytsja quepan, judío tulucj. Sirofenicia mpe 'eseptsja. Pajal la tjemyona Jesús lal jupj ca pje'á jas majamas lapanen jupj jucucus jos mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús jupj wola tjevele: —Judiopan Dios ts'uyupj. Napj 'üsüs lejay yupj mpes. Yupj yuts'a'á ma polel la 'ayas la p'a. Nin p'iyá tsjictjacj jis ve ma polel la 'ayas yupj jis tsjiyó. Más 'ücj tsjictjacj jalá pjü jisas —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Quepj tjevele: —T'üc' tjevelen. Nin p'in velé, ve tsjictjacj nepenowá palá tinca tsjictjacj jalá mpe. Niná 'ücj wa jalá tsjiyó witjacj. (Jupj quelel véletsja Jesús 'ücj wa se p'a'sa jupj.) ");
INSERT INTO jicNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús tjevele jupj lal: —'Üsüs way tjevelen jipj. Mpes jutja jipj wya nt'a. Lapanen nasa tjemey cyucus jos mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mpes quepj tjemey quinam jupj wo nt'a. Jucucus jus tjinyuca cjan casá pǘ'ütsja. Len̈ quinam lapanen. ");
INSERT INTO jicNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro po'o patja nepé tjemey Jesús. Sidón culupwen nipj tjemey wa quinam. Tjemey 'üsǘ püné nt'a, niná 'üsǘ Galilea ló. Ne'as tjemey Decápolis po'o patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne'aj tüpü'ü na, jupj nt'a tucuman wa yomen pjots' la toptsja. Ma wa polel 'üsüs véletsja yomen. La tjomon Jesús lal jupj ca po la mo'ot'es yom niná, mü'ü'süs ca. ");
INSERT INTO jicNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús jas tjan tjemyana jupj. Mos ts'ipal pjots' jul la tje'yot'a jupj. Jupj mos ts'ipal p'iyá tipyuts'a wa, po la tje'yot'a yom pwelam. ");
INSERT INTO jicNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsjun po'ó tjinyuca. Yümücj tjeqjuesca. Tjevele: “¡Efata!” (Cupj velecj: “Tjapjaca”.) ");
INSERT INTO jicNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mpes yom 'ücj pjócatsja tepyala. 'Üsüs polel véletsja quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús jis tjijyü'ta pjü way jilal ma jis la veles la p'a jilal nin tepyalá. Mop'in nin tjowelepj. Newa jis tjijyü'ta ma lo veles, newa nin la pülücj nin tjowelepj la p'a jilal nin tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pasal yólatsja Jesús 'üsüs la tjiji mpes. Tjowelepj: “Pjü way 'üsüs la tjiji. Jis pjats' la topj, si 'ü'sa la siji, pjyacan̈ yupj. Maysa javelepj, si 'ü'sa la siji wa, ne 'ücj javelepj.” ");
INSERT INTO jicNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","P'a jawas pülücj 'a jis tjimyula niswá Jesús nt'a. Cjuwatsja tsjan ca nlajacj yupj. Mpes Jesús tjevele jupj discipulopan jilal jis la cuwis. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nola napj yupj mpes. Ts'ac' cont'e nasa qui'á jatja napj lal. Tecyawaja nasa yupj jis ve. ");
INSERT INTO jicNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma quelel sin jyam yupj, laja secj p'in. Nepénowa campa patja. Jil na, sin napnapj way ca nsem, jis capj nt'ajas —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jupj discipulopan wola tjowelepj: —Jipj selen jis wa cjuwá qui'á. Cjuwá ca'aj mpe jis la t'as pansas t'üc' jis la las yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús jis la tji'yüya yupj: —¿Nol to'á nun pansas? —Siete —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús jis tjijyü'ta gentas jis la 'osos 'amá 'alá. Nt'ya pansas sieteyá. Tjevele Dios lal tjüwüi'i pansas mpes. T'üc' tjevele na, tjelepta pansas. Niná jis tje'yaya jupj discipulopan jis la 'ayas ne'aj jatjá. Nin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Cjul tsjictjacj pjaní way p'in játjatsja wa yupj. Mpes Jesús tjevele wa Dios lal tjüwüi'i cjulun mpes. Jis tje'yaya discipulopan. Tjevele ca jis ma'ayacj gentas. ");
INSERT INTO jicNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nin la tjajay, mpes pjü way tjalá gentas. Pjü jis col tipit'a tepyala. T'üc' tjalá na, newa játjatsja pan popé, cjul popé wa. Mpes discipulopan quiliyú mo'o t'olon pan tsjictjacj, cjul tsjictjacj wa, yupj ma pjü tjalá. Quiliyú siéteya tipit'a la tjajay pan mpes, cjul mpes wa. ");
INSERT INTO jicNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nasa tjalá niyom cuatro mil, pajal pülücj. T'üc' tjalá na, Jesús sin tjejyama yupj, mpes tjil. ");
INSERT INTO jicNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesús barco wama tjemey jupj discipulopan jilal. Tjil Dalmanuta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseopan tjiquil Jesús nt'a quinam. La tjü'üy jupj lal tsjan mpes 'ücj la tjiji jupj la tjijá. Ma topon Dios mpe tjac', mpes la tjomon jupj ca 'üsüs la mijis, gente p'in ma polel lajay jinwá. Nin mpes ca sin mü'üsüs ncu Dios jas tjejyama jupj, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús yümücj tjeqjuesca, 'aplijílatsja yupj pajal sey c'atsja mpes. Tjevele: “Nun quina potjaqué, lo moná napj ca 'üsüs la mejay, gente p'in ma polel lajay jinwá. ¿Tsjan mpes lo moná nun niná? T'üc' way velé, ma ca nin la mejay.” ");
INSERT INTO jicNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús tjemey quinam yupj mpe. Barco wama tjemey niswá jupj discipulopan jilal, ne tjil. Quelel jiltsja 'üsǘ püné na'aj po'ó niswá. ");
INSERT INTO jicNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús discipulopan pan pülücj ma tucutj. Yo' tepe'e. Pan pjaní jatatsja p'in. ");
INSERT INTO jicNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús tjevele yupj jilal: —'In tjajama. Po ma nujos t'as fariseopan jis levadura. Ma wa nujos t'as Herodes levadura. Yupj jis levadura malala pajal. ");
INSERT INTO jicNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jupj discipulopan ma sin tji'yüsa Jesús tjevelá. Yuwá p'in jis la tjü'üy tsjan mpes nin tjevele jupj. Tjowelepj: “Pan cjuwá cupj, mpes nin tjevele niná”. ");
INSERT INTO jicNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús seletsja nin tjowelepj yuwá. Mpes jupj tjevele yupj jis lal: —¿Tsjan mpes nun weletsja cjuwá pansas? ¿Ncu ma nusin 'yüsa custjay? ¿Ncu ma polel nusin 'yüsa? ");
INSERT INTO jicNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nun jis jun janapj nun. ¿Ncu ma nusin 'yüsa tsjan nucú? Nun jis pjats' janapj nun. ¿Ncu ma sin 'yüsa pjo'oqué mpes? ¿Ncu ma nujola pyala napj la tjejay? ");
INSERT INTO jicNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pan cínquiya tjelepj napj, jis tje'yá niyom cinco mil tjalá. Nun quiliyú mo'o t'olonó pan tsjictjacj yupj ma pjü tjalá. ¿Ncu nujola tepyala nol quiliyú tipit'a la tjüjí pan tsjictjacj mpes? —Doce —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús tjevele: —P'a jyawca na pan siete tjelepj napj, jis tje'yá niyom cuatro mil tjalá. Nin p'iyá nun quiliyú mo'o t'olonó pan tsjictjacj yupj ma pjü tjalá. ¿Ncu nujola tepyala nol quiliyú tipit'a la tjüjí pan tsjictjacj mpes? —Siete —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mpes Jesús jis la tji'yüya: —¿Ncu ma nusin 'yüsa custjay, napj najas nusin mü'üsüs mpes? ");
INSERT INTO jicNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida nt'a tjil yupj. Ne'aj tjá'asa yom ma polel nyúcatsja; la p'a witjacj tucuman jupj Jesús nt'a. La tjomon Jesús lal po la mo'ot'es ma nyucá, mü'ü'süs ca jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mpes Jesús jupj mos ntjüi'le, lal tjemey campa 'in yupj jis wa lejen̈ mpe. Ma nyuca jun mo'o tipyuts'a Jesús, po la tje'yot'a jupj jun. La tji'yüya: —¿Ncu nyuc quinam? ");
INSERT INTO jicNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jupj jay pjucj jas tjijyünsa, tjinyuca, tjevele: —Napj nyuc gente lyawun̈. Newa yo jinwá yustapj jin nyuc. ");
INSERT INTO jicNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mpes Jesús jupj jun po la tje'yot'a niswá. Po la tje'yot'a na, yom 'ücj tjinyuca. Jun tji'yü'sa tepyala. Pjü way pasal 'üsüs nyúcatsja quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús jas tjejyama jupj wo nt'a. Tjijyü'ta: —Ma ca mim yupj jis wa lejen̈ nt'a. Ma ca mvelen yupj jilal niná tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús wínetsja jupj discipulopan jilal Cesarea Filipo ne'aj p'in tapatja nt'a. Ne'aj pjaní way patja nt'a jis wa tjelejen̈ Cesarea Filipo t'asiyú. Pülücj pátjatsja Cesarea Filipo nt'a. Jesús pjaní pjaní tjemeytsja la nuc pjaní way patja nt'a. Ne'aj tjelyawun̈ na, Jesús jis la tji'yüya jupj discipulopan jilal: —¿Pjacj ne napj jin javelepj gentas? ");
INSERT INTO jicNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wola tjowelepj: —Nepénowa javelepj jipj ne Juan el Bautista p'iyá. Nepénowa javelepj jipj Elías, püna tüpü'ü p'iyá. La p'a wa javelepj jipj p'a profeta püna tüpü'á. Püna 'i tipü'í, niswa püt', nin javelepj gentas. ");
INSERT INTO jicNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús nin p'iyá la tji'yüya discipulopan jis lal: —Ne nun, ¿pjacj ne napj jin welé nun? Pedro wola tjevele: —Cristo jipj. Jipj ne Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. Jipj mpes ca 'üsüs mpatjaquecj. ");
INSERT INTO jicNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús jis tjijyü'ta ma la veles niná la p'a jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús sin tji'yüsa la tjiji quinam jupj discipulopan. Tjevele jupj p'iyá niná Yomen Dios jas tjejyamá. Tjevele Dios jostsja ca pajal malala mpalas jupj. Tjevele co'müypan ma ca jisas nsem jupj. Nin p'iyá ca nsem sacerdote noypan, nin p'iyá Moisés popel sin 'yüsa lajay. Ma ca jisas nsem jupj, tjevele. Tjevele la p'a ca mü'ü'nacj jupj. Tjü'ünan na, ca jas müjünsüs ts'ac' cont'e na. Ca mpü'üm niswá, nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Üsüs way sin tji'yüsa la tjiji niná. Pedro ma jostsja niná ca mpalas Jesús lal, mpes jas tjan tjemyana jupj, cus tjeve'le. Tjevele: —Ma ca nin mya mpalas. Dios ca cyapj mp'a'sas. ");
INSERT INTO jicNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús la nujuya, yus tjinyuca discipulopan. Cus tjeve'le Pedrú, tjevele: —Jutja napj mpe. Satanás jinwá velen. Jipj ma jele Dios jola jinwá. Yom p'in jola jinwá jele jipj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús nin tjevele na, tjevele jis la cuwis pjü ne'aj tjelejen̈, tjevele yupj jilal, jupj discipulopan jilal tjevele wa: —Nun popa quelel ncapj cyon̈ca, ma ca nin la mijis jupj jos jinwá. Nin ca la mijis napj lejay jinwá. Napj cruz po'ó ca ma pats'. Malala ca mpalas wa jupj, ncapj cyon̈ca mpes. Jupj ca jas mü'üsüs napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nepénowa ca quelel jis capj mp'a'sacj yupj p'iyá. Ma ca jisas malala se palá, mpes ca mvelecj napj lal japon tulucj. Mop'in ma ca mpatjam Dios lal. P'a casá nsem nepénowa jis lal. Nepénowa nca'lin̈ napj lal japon mpes. Nca'lin̈ ca nacj napj mpes javelepj mpes. Nin mvelecj Dios 'üsüs liji gente jis lal napj mpes. Más 'üsüs ca jis mpalas yupj la p'a jis lal. Yupj lovin ca mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","”Nepénowa pülücj jatatj nosis casá, mop'in ma polel patja Dios lal. Pjü way jatatj nosis nt'a ca nacj. Newa 'üsüs way tulucj pjü niná, yupj ma polel patja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yupj ma polel jaylacj lajay mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","”Napj p'iyá niná Yomen Dios jas tjejyamá. Po ma nu tjemaycas napj mpes. Po ma nu tjemaycas napj velé mpes. Quina patja ma jisas Dios. Pajal malala nyuca lajay. Nun nu tjemaycas yupj ca jus nlayecj nun ncapj con̈có, ne mayca wa ca nsem napj nun mpes, niswa tjacuwis na. Niswa tjacuwis na, pjü ca nucucj pajal püné napj, Mpapay jinwá. Ncuwis Dios angelpan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús tjevele wa yupj jilal: —T'üc' way velé nun jilal. Nun nepénowa ca nucú Dios ca müjü'tüs nosis nt'a. Custjay ma taca'liqué na p'in, nun ca nucú niná. Newa potjaqué na p'in, pajal 'üsüs ca mpalas Dios pajal püné mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ts'ac' séisiya tjejyawca na, Jesús tjemey Pedro lal, Jacobo lal wa, Juan lal wa. Yupj jis lal tjemey joc' campanya ton̈ca nt'a, tucuc' pacá nt'a. Yupj yulupjana way p'in tjil. Ne'aj tjatja na, Jesús p'a casá justa tepyala tjunuc yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jupj jas quip pajal pje tepyala, jas jaw jinwá. Ma polel pülül la patsj ne pajal pje way cüpalas Jesús jas quip pje way tepyala jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nepé lay tepyala wa Elías. Moisés lay tepyala wa. Yupj manas profetapan püna tapatjá. Tjoweleptsja Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro tjevele Jesús lal: —Rabbí, po 'üsüs qui'á jyatjaquecj. Ts'epjel cónt'eya ca sin müjünsücj. Pjaní jipj mpes ca nsem, pjaní Moisés mpes ca nsem, pjaní Elías mpes ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma seletsja tsjan más 'ücj la veles, mpes niná tjevele. Pajal lacj jeyaptsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jupj nin tjevele na, mol lay tepyala, palá tjac' yupj jis capá nt'a. T'asiyú tón̈catsja. Nepé vele pjactsja: “Niná napj Natjam. Quelel lejay jupj. Tjapja'aqué jupj velá”, nin tjevele mol mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nin tjepjyacan̈ na p'in, t'asiyú tjunuc yupj. Jesús jusapj tón̈catsja. Len̈tsja Moisés, Elías len̈ wa. ");
INSERT INTO jicNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yacjaya joc' mpe palavin tjiquil. Palavin jiquiltsja na, Jesús jis tjijyü'ta ma jis la veles la p'a jilal tsjan tjunuc yupj. Tjevele jupj p'iyá niná Yomen Dios jas tjejyamá. Mpa'is ca, ca jas müjünsüs la püt'üs niswá, tjevele. Jas tjijyünsa na, 'ücj jis la veles tjunuc mpes joc' mo'ó; nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mpes ma tjowelepj niná la p'a jilal. Yuwá p'in jis la tjü'üy tsjan mpes Jesús tjevele mpa'is ca, jas müjünsüs la püt'üs niswá. ");
INSERT INTO jicNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tjowelepj Jesús lal: —Cupj pyonecj jipj niná Jepa Püné Dios tjevele ca jas majamas. ¿Tsjan mpes niyom nepénowa javelepj Elías mwalá way jac'? Nin javelepj Moisés popel sin 'yüsa lajay. ");
INSERT INTO jicNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús wola tjevele: —T'üc' way Elías mwalá way jac' Jepa Püné lal. Dios Popel vele jupj pjü 'ücj liji Jepa Püné jac' mpes. Mop'in nin, Dios Popel vele pasal malala ca ma palas. Nosis casá patja malala ca mvelecj napj nin po'ó. ¿Ncu solejé tsjan mpes Dios Popel nin vele? ");
INSERT INTO jicNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nasa tjac' Elías. Malala la tjajay jupj lal, yupj jisastsja jinwá. Dios Popel tjevele ca nin la mijicj jupj lal, ne nin la tjajay —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Joc' 'alá mpe tjiquil na, niswa tjil la p'a discipulopan nt'a. Tjunuc gente pülücj t'asiyú lejen̈tsja yupj jilal. Niyom nepénowa la veleltsja yupj jilal. Yupj ne Moisés popel sin 'yüsa lajay witjacj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pjü way ne'aj 'a jis tjimyula ma salejeptsja Jesús ncuwim quinam. Mpes tjac' na, po yólatsja jupj tjac' mpes. Ts'equenen̈ la tjalapan jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús jis la tji'yüya discipulopan: —¿Tsjan niná nun tjoweletsja niyom nenem jilal, lo velelé? ");
INSERT INTO jicNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yom p'a wa wola tjevele Jesús lal 'a jis tjimyula popé: —Natjam lal tjacuwis jipj nt'a. Lapanen pü'ü jupj jos mo'ó. Natjam ma polel vele liji jupj, lapanen. ");
INSERT INTO jicNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nenéyawa tjüi'le jupj. Ntjüi'le na, 'amá po'o tyüla liji jupj. Natjam lampe p'yoya, wüis si quilila. Pajal cyac'aja. Napj la tjemyon jipj discipulopan jilal yupj ca pje'á la ncoyecj lapanen. Ma polel nin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús tjevele yupj jilal: —Nun ma poné napj lal. Pajal püs way li nuctsja nun ca mponé napj lal. Püs way tüpü'üs nun lal quinam. Lowa, jupj jatjam lal nculá. ");
INSERT INTO jicNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nin la tjajay, lal tjiquil. Lapanen Jesús jus tjinyuca na, tjamacjas jun jyu'ya, ticyücüyǘ la tjiji jupj. Tyüla jupj, la ts'yüpjütǘ. Lampe p'yóyatsja. ");
INSERT INTO jicNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús la tji'yüya tjamacjas popay lal: —¿Ncu püs way nin pyálatsja? Jupj wola tjevele: —Mwalá way tepyala jupj tsjictsja na. ");
INSERT INTO jicNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","La pülücj jupj tyüla nas 'awa mo'ó, 'üsǘ mo'ó 'ots'ipj, lapanen nin liji. Quelel 'yü'na jupj. Jipj polel qjuis capj p'yacj ca nacj. Jele t'as malala qjuis tepyala mpes. Qjuis capj tjep'ya'sa. ");
INSERT INTO jicNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús tjevele: —¿Tsjan mpes velen napj polel nucopj p'yacj ca nacj? Jipj napj lal pyon, pjü 'ücj la pal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mpes len̈ way yümücj tjevele: —Napj pyon. ¡Ncapj tjep'ya'sa, más 'üsüs ca mpon! ");
INSERT INTO jicNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pülücj ts'equenen̈tsja yupj nt'a jis la nuc tepyalá. Mpes Jesús cus tjeve'le lapanen. Tjevele: —Tjamacjas niná ma pjoca, ma wa vele, jipj nin lejay. 'I jütütj, jutja jupj jos mpe. Lovin ma ca mim jupj jos mo'ó niswá —nin tjevele jupj lapanen lal. ");
INSERT INTO jicNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nin tjevele na, lapanen yümücj la tipiya. Tjamacjas jun jyu'ya, pajal ticyücüyǘ la tjiji jupj. Tjemey jupj. Tjamacjas tepe'e jinwá pǘ'ütsja jupj. Pülücj tjowelepj nasa tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tepe'e tulucj jupj. Jesús jupj mos mpes ntjüi'le, jas tjijyünsa. Tón̈catsja jupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yacjaya Jesús wama tjemey. Jupj discipulopan wama tjil wa, la tjü'üy jupj lal la p'a len̈tsja na: —¿Tsjan mpes ma polel pje'á jas tjejyamacj lapanen niná? ");
INSERT INTO jicNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jis wala tjevele: —Lapanenpan nepenowá pajal costa way sin jomá. Nintsja niná. Más 'ücj lo moná Dios lal ca 'ücj jas majamá; ts'ac' pjaní ma ca nlajá, Dios lal ca mvelé p'in. Ma nin lojí, ma ca mim —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Locopyaya tjemey Jesús, jupj discipulopan jis lal. Galilea culupwen nipj tjil yupj. Jesús jostsja la p'a ma ca jus nlayecj ne'aj lyawun̈tsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sin tji'yüsa la tjíjitsja jupj discipulopan, ne nin. Yupj jis lal tjevele: “Napj p'iyá niná Yomen Dios jas tjejyamá. Dios ca ma'ayas niyom ca malala la mijicj napj lal yupj jisas jinwá. Ca ma 'ü'nacj; locopyaya, ts'ac' cont'e na ca nin müjünsüs la püt'üs niswá”, nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yupj ma sin tji'yüsa jupj tjevelá. Lacj tjeyapj, mpes ma queleltsja la 'üy tsjan mpes nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne'as tjil quinam Capernaum nt'a, pülücj patja nt'a. Wama tjatja na Jesús la tji'yüya jupj discipulopan jilal: —¿Tsjan mpes lo veleletsja nunwa tjalawú na? ");
INSERT INTO jicNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lyájasa tjatja yupj. Jis tjemyácatsja yupj. Ma quelel javeleptsja tsjan tjowelepj yupj jümücj casá tjelyawun̈ na. Nin tjowelepj cana yupj popé más püné. Niná mpes la tjowelel discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús 'etjele quinam. Tjevele jis la cuwis jupj discipulopan. Tjevele: —Nujisas noypan ca nsem nun, más 'ücj po 'in tsjictjacj jin nujola t'as nun p'iyá. Nun pjü jis mozopan nu tepyala na, noypan ca nsem nun. ");
INSERT INTO jicNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jupj nin tjevele na, tsjicj tecyumaná, discipulopan culupwen nt'a tjijyünsa jupj. Col tjevyala tsjiquis. Jesús tjevele yupj jilal: ");
INSERT INTO jicNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Gente pülücj nin jinwá patja, yupj tsjicj niná jinwá. Najas nun ma nujola noypan way nun p'iyá. Najas 'üsüs lojí yupj jilal napj mpes. 'Üsüs lojí na yupj jilal, t'üc' way 'üsüs wa lojí napj lal. 'Üsüs lojí na napj lal, t'üc' way 'üsüs wa lojí Dios lal; jupj nin tjejyama qui'á. ");
INSERT INTO jicNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan tjevele Jesús lal: —Nejepa, jus tjinyucucj yom p'a wa lapanenpan pje'á li ts'iyatsja jupj. Jipj lyá tjevele mpes lapanenpan pje'á la ts'iya. Tjevelecj jupj lal ma nin ca la mijis jupj, ma ncuwa popa ne. ");
INSERT INTO jicNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús tjevele: —Po ma müjü'tǘ jupj ma ca nin la mijis. Jupj napj nlá vele 'üsüs la mijis, yom p'in ma polel liji jinwá. Yom nin lijá, ma malala mveles ca napj nin po'ó yacjaya. ");
INSERT INTO jicNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jupj p'a casá jola tulucj cupj qjuilal, qjuis capj p'ya'sa jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nepénowa ca nucopj mp'a'sacj ca nacj nun ncapj con̈có mpes. 'Üsǘ ca nu ma'ayacj müsiqué p'in ca nacj, 'üsǘ nu vya na. T'üc' way velé napj, Dios ca 'üsüs la mijis yupj jis lal nin la tjajay mpes p'in. ");
INSERT INTO jicNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”Tsjictjacj nepénowa japon napj lal. P'a wa nin la qjuijis ne tsjictjacj nenem malala nyuca la qjuijicj, malala pajal ca nsem jupj lal, nin la tjiji mpes. Más 'ücj nactsja la p'a wa pe püné ntsu'pacj jupj mwen po'ó, ca 'üsǘ püné mo'o la nts'iyacj, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","”Po ma malala la müjí. Nun quelel malala lojí nun jis mas mpes, ma la müjí. Nun jis mas cjuwá jinwá jin nujola t'as. Nun jis mas taná t'ü jinwá jin nujola t'as. Más 'ücj nun jis mas cjuwá, mpatjaqué Dios lal. Más malala nsem nun jis mas mat'e nlawú 'awa püné nt'a. Ne'aj len̈ pjacj se wat'ata 'owus. ");
INSERT INTO jicNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘Pajal malala ne'aj. Lotsjotsj lovin yupj jis p'üy jalá. 'Awa pwe lovin ne'aj.’ ");
INSERT INTO jicNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","”Nun quelel lowú, malala la müjí, ma la müjí. Nun jis tsjam cjuwá jinwá jin nujola t'as. Nun jis tsjam taná t'ü jinwá jin nujola t'as. Más 'ücj nun jis tsjam cjuwá, mpatjaqué Dios lal. Más malala nsem nun jis tsjam mat'e nlawú 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Pajal malala ne'aj. Lotsjotsj lovin yupj jis p'üy jalá. 'Awa pwe lovin ne'aj.’ ");
INSERT INTO jicNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","”Nun quelel malala lojí nun nucú mpes p'in, ma ca nucú niná. Nun jis jun tulucj jinwá jin nujola t'as. Nun jis jun pje'á la ts'i jinwá nujola t'as. Más 'ücj nun jun pjaní mpatjaqué Dios pü'ü nt'a. Más malala nsem nun jis jun mat'e nlawú 'awa püné nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Pajal malala ne'aj. Lotsjotsj lovin yupj jis p'üy jalá. 'Awa pwe lovin ne'aj.’ ");
INSERT INTO jicNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pjü ne'aj ca malala jis mpalas 'awa mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","”Sal 'üsüs way. (Sal mpes ts'yuca pwisis, ma malala mpalas, ma mojo jupj.) Nin tulucj sal ma wüjü na. Sal ma wüjü na, ma polel wüjü lajay jupj. Najas sal 'üsüs jinwá nsem nun nosis casá. 'Üsüs ca la müjí napj najas jin. Mpes ma ca pjü malala jis mpalas nosis casá patja. Po ma la tjowe'lé nunwá. Quelel lis müjí nun jis pülücpan. ");
INSERT INTO jicNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús tjemey quinam. Tjemey Judea nt'a. Tjemey 'üsǘ püné na'aj po'ó, 'üsǘ niná Jordán lotsja. Gente pülücj tjiquil niswá jupj nt'a. Sin tji'yüsa lis tjiji, jupj lovin nin la tjiji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseopan nepénowa tjiquil wa Jesús nt'a, la 'üytsja jupj lal. Ma jisastsja Jesús. Yólatsja costa way nsem jis wala la veles. Jisastsja jupj mveles malala ca nsem judiopan jis lal. La tjü'üy: —¿Ncu 'ücj Dios lal yom se jamá jupj jats'om, jats'om ma ncuwim niswá? ");
INSERT INTO jicNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús jis wala tjevele: —¿Ncu solejé tsjan tjijyü'ta Moisés püná? ");
INSERT INTO jicNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tjowelepj: —Jupj tjevele yom ma jos na jupj jats'om, 'ücj papel mpaques, ma'ayas jupj. Papel ca mveles quepj niná jupj jats'om tulucj quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús tjevele: —Nun ma quelel lojitsja Dios jos jin. Nin mpes Moisés tjevele yom ca nin la mijis jats'om se jamá na. ");
INSERT INTO jicNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","”Dios nosis la tjiji na, jupj ma jostsja yom nin liji. ‘La tjiji wa niyom, nequem, 'ücj ca mwayin̈ yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dios tjevele: ‘Yom ca mim popay mpe, jamay mpe, jats'om lal lo püt'üs. ");
INSERT INTO jicNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ca quelel la mijis jupj. Manas ca jüp'üy pjaní jinwá nsem yupj.’ Nin mpes yupj mat'e tulucj, tjewyayin̈ na. Yupj jüp'üy pjaní p'in nsem Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dios yugo sey pjucj po'o tipyünta jinwá la tjiji. Dios p'iyá nin la tjiji na, gente ma polel sin tjan sin majamacj —Jesús nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yacjaya Jesús discipulopan yusapj játjatsja wa mo'ó Jesús lal. Yupj jisastsja jupj ca 'üsüs mveles niná, tsjan mpes yom ma polel se jamá jats'om. ");
INSERT INTO jicNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús tjevele: —Yom se jamá jats'om, p'a lal woya ca nacj. P'a lal woya na, Dios ca mveles yom niná ca ma jats'om ne'aj mya'na jupj. P'a lal woya, malala liji jats'om mwalá way lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nenéyawa quepj jama voyum mpe. Niná quepan p'a yom lal woya. Jupj p'a voyum lal mpü'üm, mop'in Dios ca mveles quepj niná ma voyum lal wine. Malala lajay p'in Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nepénowa tucuman yupj jis tsjictjacj Jesús nt'a. Jisastsja Jesús tsjictjacj sey pjucj po la mo'ot'es, mveles ca 'üsüs jis mpalas tsjictjacj Dios mpes. Jesús discipulopan jis capj tjowelel yupj, tsjictjacj jis lal tjiquil mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús tjapjaca yupj tjowelepj. Po ma jostsja tjowelepj. Tjevele: “Jis ma'ayá ca ncul tsjictjacj napj nt'a. Po ma jis müjü'tǘ ma ncul. Gente japon tsjictjacj japon jinwá, Dios 'ücj si jütüta yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Ücj tsjictjacj jilal Dios si jütüta. Gente ma jisas Dios si jütüta yupj, tsjictjacj jinwá, ma ca Dios popa jis mpalas yupj. T'üc' niná”, Jesús nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsjictjacj pwena tje'yonsa jupj quinam. Sey pjucj po la tje'yot'a, tjevele 'üsüs jis mpalas Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús tjemey quinam. Jámatsja na yom ts'üequené, tjac', tüic' jin tjüjünsü Jesús wolap'a'á. Tjevele: —'Üsüs way jipj. 'Üsüs sin 'yüsa lejay. Najas mvelen napj lal tsjan más 'ücj la mejay napj ne ca Dios la mijis 'ücj mpü'üs lovin jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús jupj wola tjevele: —¿Tsjan mpes tjevelen napj 'üsüs way? Dios p'in 'üsüs way jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jipj selen Dios tjijyü'ta jupj Popel mo'ó. Tjijyü'ta ma mü'ü'nan la p'a. Tjijyü'ta niyom ma ca ne'aj jis manucj sejats'om tulucj. Tjijyü'ta nequem ma ca mal yupj jis vayum tulucj jilal. Ma mpequem. Ma la ntsawilin. Ma la ntsawilin la t'anques la p'a juts'a'á. 'Üsüs la mijin pyapay, jemay jilal. Jele nsem noypan way yupj jipj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ninana yomen wola tjevele: —Lovin la tjejay niná jupj tjijyü'tá. Napj tsjictsja na p'in lovin nin la tjejay. ");
INSERT INTO jicNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús jus tjinyuca jupj. Quelel la tjiji jupj, mpes tjevele: —Pjaní way ma la tjejay jipj custjay. Pjü way vender la mijin jipj jits'a'á. T'emel niná jis ma'ayan t'emel cjuwá mpes. Nin la tjejay na tsjay pülücj ca nta'an Dios pü'ü nt'a. Nin la tjejay na ncuwim. Nin ca la mijin napj lejay jinwá. Napj cruz po'ó ca ma pats'. Malala ca mya palas wa, ncapj cyon̈ mpes. Ca jin mü'üsüs napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yom niná tjapjaca na, pasal 'aplijila tepyala jupj. Tjemey. Pajal pülücj tyá'atsja, ne ma quelel líjitsja jupj Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mpes Jesús yus tjinyuca jupj discipulopan. Tjevele yupj jilal: —Pajal costa way pülücj jatatj Dios si jütüta popa se palá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jupj discipulopan pasal yólatsja niná tjevele mpes. Jupj niswa tjevele: —Gente nepénowa japon 'üsüs mpatjam yupj jatatj mpes; pülücj jatatj yupj. Costa way Dios si jütüta popa se palá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pasal costa way camello jav jul casá jama. Camello ma polel nin liji niná. Más 'in costa way pülücj jatatj Dios si jütüta popa se palá yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jupj discipulopan pajal nin yólatsja quinam niná tjevele mpes. Tjowelepj yuwá: “Pajal costa way Dios si jütüta popa se palá yupj. Pjü way ma 'üsüs se palá Dios lal ca nacj, ma mpatjam Dios lal.” ");
INSERT INTO jicNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús yus tjinyuca, tjevele: —Gente yusapj p'in ma polel 'üsüs se palá Dios lal. Dios 'ücj nin liji yupj mpes. Pjü way 'ücj liji Dios. ");
INSERT INTO jicNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro Jesús lal tjevele: —Cupj cuts'a'á jatja tjeleque jipj lal. Tjeleque cyapj la con̈. ");
INSERT INTO jicNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús tjevele: —Nun nuts'a'á jatja tjalawú napj lal, 'üsüs pajal napj lal. Po 'üsüs ca nsem nun mpes, nin la tjüjí mpes. Nepénowa quelel pjü lajay napj najas jinwá, quelel javelepj p'a jilal napj 'üsüs la tjejay gente mpes. Nin mpes jil nepenowá yupj jis wa mpe. Jil jis pülücpan mpe ca nacj. Nepénowa jil yupj jis papay mpe, sejamay mpe 'ots'ipj. Nepénowa jil yupj sin popa mpe. Nepénowa jil yupj jis mama mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","T'üc' way pasal pülücj ca jis ma'ayas Dios yupj nin la tjajay mpes. Nin ca jis ma'ayas nosis casá patja na. Ca jis ma'ayas jis wa pülücj. Ca jis ma'ayas jis pülücpan pülücj, sejamay pülücj 'ots'ipj, sin popa pülücj 'ots'ipj. Ca jis ma'ayas wa momas pülücj. Newa nin, gente la p'a malala nyuca lis mijicj, yupj ncapj jacon̈ mpes. Tsjicj way p'in malala se palá yupj. Niswa tjacuwis na, lovin ca mpatjam Dios lal, nin ca jis ma'ayas. ");
INSERT INTO jicNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nepénowa püna p'in topon napj lal, tsjictjacj ca nsem napj jepa 'os na. Nepénowa p'a jawasa ca mponecj, noypan ca nsem yupj. Nin ca nsem pülücj jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiltsja quinam Jerusalén nt'a. Jesús mwalá way jámatsja. Discipulopan ma sin 'yǘsatsja tsjan mpes jupj ne'aj jámatsja. La p'a wa yupj jis lal jiltsja, lacj jeyaptsja ca malala mpalas Jesús. Jupj discipulopan dóceya jis lal sin tjan tjemey niswá. Jilal tjevele tsjan ca mpalas jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tjevele: “Jerusalén nt'a leque quinam. Napj p'iyá niná Yomen Dios jas tjejyamá. Dios ca jis ma'ayas niyom nepénowa malala la mijicj napj lal; sacerdote noypan ca nin la mijicj, Moisés popel sin 'yüsa lajay ca nin la mijicj wa. Yupj ca mvelecj napj malala la tjejay. Ca mvelecj ca ncapj ntülücj, ma pats'. Mpes ca ma manucj judiopan tulucj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yupj ca la mpjüts'ünücj napj lal. Napj nin po'ó ca mputs'acj, ca ma süpücj wa. Ca ma 'ü'nacj. Ts'ac' cont'e tepyala na ca nin müjünsǘ, mpü'üs niswá”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Discipulopan mát'eya tjiquil Jesús nt'a; Jacobo pjaní, Juan pjaní wa, yupj Zebedeo jatjampan. Tjowelepj: —Jesús, qjuisas jipj ca nin la mijin cupj qjuisas. ");
INSERT INTO jicNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús jis la tji'yüya: —¿'Oyn jisas la mejay napj nun mpes? ");
INSERT INTO jicNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tjowelepj: —Jipj ca Jepa Püné nsem p'a jawasiyá. Cupj quelel jyatjaquecj jipj lal, pjaní jipj li'inyampe, pjaní wa jipj nancupwepe. ");
INSERT INTO jicNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús tjevele: —Nun ma solejé tsjan niná nun lo moná. Malala ca ma palas. ¿Ncu 'ücj wa nun jilal ca malala nu mpalas, malala ne palá jinwá? Malala ca nsem pajal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tjowelepj: —'Ücj wa niná cupj qjuilal. Jesús tjevele yupj jis lal: —Nin ca nsem nun lal. Ca malala nu mpalas, malala ne palá jinwá. Malala ca nsem pajal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Newa nin, napj ma polel velé nun ca majatjaqué napj lal, pjaní li'inyampe, pjaní wa nancupwepe. Dios la t'ya pjacj majatjum ca ne'aj. 'Ücj la tjiji nasa yupj mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","La p'a discipulopan diéziya tjepjyacan̈ yupj nin la tjomon Jesús lal. Mpes ts'a tji'in Jacobo lal, Juan lal wa. ");
INSERT INTO jicNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mpes Jesús tjevele ca pjü 'a jis mulus jupj nt'a. Tjevele: —Judiopan tulucj jis jepapan jajütütj la p'a wa, yupj noypan mpes. Yupj nin yola 'ücj nin lajay jepapan. Nin p'iyá yupj jis auxiliarpan yümücj se jütütj wa ne'aj patjá. ");
INSERT INTO jicNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nin tulucj ca nsem nun jis lal. Nun p'in nujos noypan nsem nun, ca pajal 'üsüs la müjí la p'a mpes. Yupj jis mozo jinwá nsem nun. Nin lojí na, noypan nsem nun. ");
INSERT INTO jicNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nujisas nun más 'üsüs way nsem pjü way jilal, ca 'üsüs la müjí lovin pjü way jis lal. Pjü jis esclavo jinwá ca nsem nun. Nin lojí na, más 'üsüs nsem nun la p'a jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nin lejay napj. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj tjacuwis jis capj la p'acj la p'a. Yupj ncapj jap'acj mpes tjacuwis tulucj. Malala jis tepyala nosis casá patjá, malala la tjajay mpes. Napj ma pats' ca yupj mpes. Nin mpes yupj popa pülücj ca 'üsüs nsem Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ne'as tjil Jericó nt'a, pülücj patja nt'a. Yacjaya Jesús tjemey jupj discipulopan jis lal Jericó mpe. Gente la p'a pülücj jis capj tocon̈ jümücj nt'a. Yom ma polel nyúcatsja ne'aj já'asatsja jümücj nt'a. Bartimeo lotsja. Timeo jatjam waytsja jupj. Lovin t'emel la tjemyónatsja. ");
INSERT INTO jicNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","La p'a wa jupj wola tjowelepj Jesús ne'aj jámatsja. Mpes pajal yümücj la tipiya: —Jesús, ncapj tjep'ya'sa. Dios jin tjejyama nosis nt'a. Jipj David püna tüpü'ü popa p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pülücj cus tjowelel jupj. Tjowelepj: —¡Lyájasa t'as! Más yümücj la tipiya: —Ncapj tjep'ya'sa. Dios jin tjejyama nosis nt'a. Jupj David püna tüpü'ü popa p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús tyantaná. Tjevele: —Mvelé ncuwim napj nt'a. Mpes tjowelepj ma nyuca lal: —'Ücj jyas t'as. Jin tjijyünsa. Jupj jos jipj jay jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mpes jupj cobija palá la ts'iya. Len̈ way jas tjijyünsa, tjemey Jesús nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús la tji'yüya: —¿Tsjan jyas napj lejay jipj mpes? Ma nyuca tjevele: —Nejepa, po quelel nyuc napj. ");
INSERT INTO jicNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús tjevele: —Jipj tepyon napj polel 'i 'ü'sa lejay mpes nasa 'i tjü'ü'sa jipj. 'Ücj mim quinam. Len̈ way 'ücj nyuca tepyala. Cus tecyon̈ca Jesús jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ne'aj way p'intsja quinam Jerusalén nt'a. Ne'as tjil Betfagé nt'a nepénowa tapatja nt'a, Betania nt'a wa nepénowa tapatja nt'a. Jis wa ne'aj lejen̈tsja tucuc' po'ó, niná tucuc' Olivos ló. Ne'aj tjil na Betfagé nt'a, Betania nt'a wa, Jesús discipulopan mát'eya sin tjejyama, ");
INSERT INTO jicNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tjevele: “Lowa yupj jis wa lejen̈ nt'a. Ne'as tjalawú na soysoy tsjicj ca nucú. Mwen tsyu'pa ton̈ca jupj. Casá 'osos secj jupj custjay. 'Osocté, ncumaná ma 'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","P'a wa ca nu la mü'üyas ca nacj tsjan mpes socté jupj. Wola mvelé Nujepa jos jupj. Len̈ way ca jas majamas, ca ncunucj jupj niswá, ca mvelé nun.” ");
INSERT INTO jicNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mpes tjil yupj. Jus tjunuc soysoy tsjicj, tsyu'pa tón̈catsja jümücj nt'a. Wa jun vilicj nt'a tón̈catsja jupj. Soc jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nepénowa lejen̈tsja ne'aj, mpes yupj soysoy soc na, la p'a jis la tjü'üy: “¿Tsjan mpes nin lojí? ¿Tsjan mpes socté soysoysos?” ");
INSERT INTO jicNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nin p'iyá jis wala tjowelepj Jesús tjevele jinwá. Mpes la p'a tjowelepj 'ücj jis la winin. ");
INSERT INTO jicNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tjaman soysoysos Jesús nt'a. Sin quip pje'apa la tsjinan soysoy lüicj casá. Jesús casá 'etjele quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gente pülücj yupj sin quip pje'apa tapajatj jümücj po'ó. La p'a wa manaca pjwel t'ü manaca lejen̈ nt'a. Tucutj, jis tapajatj jümücj po'ó. Nin la tjajay 'üsüs lo pal jümücj po'ó Jesús jama nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gente pülücj Jesús mwalá way jiltsja. Pülücj cjüil jiltsja wa. Yümücj tjowelepj: “'Üsüs pjac tjowelé Jesús po'ó. Dios pajal 'üsüs ca la mijis jupj mpes. Dios mpes vele jupj, Dios ne cupj qjuis Jepa Püné. ");
INSERT INTO jicNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pasal püna David israelpan jis jépatsja, cupj ne jupj popa p'iyá. Jesús ca müjü'tüs quinam, David tjijyü'ta jinwá. Tsjun po'o patja 'üsüs pjac ca mvelecj wa Jesús po'ó.” Nin tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús ne'as tjemey quinam Jerusalén nt'a. Dios wo nt'a tjemey. La tepyala tjinyuca jupj ncu 'üsüs lajaytsja ne'aj. T'awaná tepyala mpes tjemey niswá Betania nt'a, nepénowa patja nt'a. Jupj discipulopan dóceya jilal tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yaya tjil Betania mpe. Jesús vecj pé'etsja. ");
INSERT INTO jicNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Higuera tjinyuca jupj, campa way tón̈catsja 'in. Higuera niná julupj 'üsüs lo pistsja. Lo jánatsja. Mpes Jesús tjemey jupj nt'a. La tepyala julupj. Cjuwatsja jupj. Lo p'in tjinyuca. Ma ne'as custjay lo valas. ");
INSERT INTO jicNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mpes Jesús tjevele higuera lal jupj lovin ma ca mvalas niswá. Jupj discipulopan tjepjyacan̈ nin tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ne'as tjil na Jerusalén nt'a, Jesús tjemey Dios wo nt'a. Vender lajaytsja ne'aj, jaylacj lajaytsja wa ne'aj. Jesús pje'á sin tjejyama pjü way. Ma jostsja nin lajay Dios wo nt'a. Nepénowa judiopan jis t'emel vender lajaytsja romanopan jis t'emel mpes. Judiopan jis t'emel mpes p'in 'ücj jaylacj lajaytsja ne'aj, Dios wo nt'a. Jesús yus ts'eptaná yupj jis mesa. Nepénowa sipipj vender lajaytsja. Jupj yus ts'eptaná wa yupj jis banco tsjictjacj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma jis tje'yaya jis la winin ne'aj vender lajay tucutj na. ");
INSERT INTO jicNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nin la tjiji na, jupj sin tji'yüsa lis tjiji ne'aj. Tjevele: “Dios Popel vele Dios tjevelá jupj wo mpes. Vele: ‘Ninana nawá nt'a javelepj napj lal. Gente pjü way 'ücj javelepj napj lal ne'aj. Nin ca ló nsem wosis’, Dios Popel nin vele. Nun ma nujos niná. Nun la tjüjí pwecapan 'a si mulú qui'á.” ");
INSERT INTO jicNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdote noypan tjepjyacan̈ Jesús tjevelá, niyom Moisés popel sin 'yüsa lajay tjepjyacan̈ wa yupj. Jus nlaytsja gente pjü way ne'aj pajal yólatsja Jesús 'üsüs sin tji'yüsa lis tjiji mpes. Sacerdote noypan nin yólatsja gente lovin ca jisas nsem Jesús. Ma jisastsja. Nin p'iyá yola watsja Moisés popel sin 'yüsa lajay. Mpes yuwá tjowelepj 'oyn la qjuijicj cü'ü'nacj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","T'yaja na Jesús tjemey Jerusalén mpe jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yaya püstapj jiltsja na, higuera jus tjunuc niswá. Ts'üique tepyala, tepe'e jupj, tjunuc. ");
INSERT INTO jicNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro jola tepyala Jesús tjevelá higuera lal. Tjevele Jesús lal: —Rabbí, tjinyuca. T'an̈ tjevelen higuera lal lovin ma ca mvalas niswá. Nasa ts'üique jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús tjevele: —Najas mponé Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nun popa pyona Dios lal, 'ücj wa vele joc' niná lal: ‘Jutja. Ntolo 'üsǘ püné mo'ó.’ Jupj newa pyona ca nin mpalas jupj tjevele jinwá, nin ca nsem jupj tjevelá. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mpes nun jilal velé, lo moná na Dios lal, más 'ücj mponé jupj nasa nin la tjiji nun mpes. Nin toponé na, t'üc' way jupj ca la mijis nujisas. ");
INSERT INTO jicNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","”Dios nun jis Papay tsjun po'ó. Nun welé na jupj lal, nujola pyala ca nacj nun ts'u 'inyá p'a lal. Niná nujola tepyala na, perdonar la müjí jupj. Mpes Dios ca perdonar la numijis wa nun malala nyuca la tjüjí. ");
INSERT INTO jicNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nun ma quelel perdonar la sojí, nun jis Papay Dios ma wa ca perdonar la numijis. ");
INSERT INTO jicNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ne'as tjil niswá Jerusalén nt'a. Tjil Dios wo nt'a. Niyom nepénowa tjiquil Jesús nt'a, yupj nepénowa sacerdote noypan, nepénowa Moisés popel sin 'yüsa lajay, nepénowa co'müypan. ");
INSERT INTO jicNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesús lal tjowelepj: —¿Pjacj 'e tje'yaya 'ücj nin lejay, jipj lejay jinwá? ¿Pjacj 'i tjüjütüta nin lejay jipj? —nin la tjü'üy Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús tjevele: —Napj ca nu la mü'üy 'ots'ipj. Pjaní way p'in nu la mü'üy. Niná nawala tjowelé na, napj ca mvelé wa nun lal pjacj ntjijütüta nin lejay. ");
INSERT INTO jicNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juan el Bautista bautizar lis tjiji gentas. ¿Pjacj tje'yaya ne 'ücj nin la tjiji? ¿Ncu Dios p'in tjijyü'ta ca nin la mijis? ¿Ncu gente p'in jisastsja ca nin la mijis? Nawala mvelé nun. ");
INSERT INTO jicNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yuwá tjowelepj yupj tsjan cüwelem Jesús lal. Tjowelepj: “Ma polel mvelecj Dios tjijyü'ta niná. Nin cüvelecj niná, Jesús ca qjuis la mü'üyas tsjan mpes ma tepyonecj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma wa polel velecj gente p'in jisastsja nin la tjiji jupj.” (Yupj lacj jeyaptsja la p'a wa judiopan jilal. Pjü way yupj topon Juan el Bautista tjevele Dios tjevelá.) ");
INSERT INTO jicNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mpes tjowelepj Jesús lal: —Ma selecj pjacj tje'yaya Juan el Bautista 'ücj bautizar la tjiji. Jesús tjevele yupj jis lal: —Nun ma nlal tjowelé, mpes napj ma wa ca mvelé nun jis lal nun nla tjü'üyá napj lal. Ma ca mvelé pjacj ntjijütüta napj nin lejay. ");
INSERT INTO jicNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús p'a parábola tjevele yupj jilal. Sin 'yüsa lis tjiji malala pajal Dios lal judiopan ma jisastsja jupj Jatjam. Tjevele: “Yom pjaní uva pajal pülücj sine jupj. T'asiyú tjivyü'ü sine nt'a. Pe jul püné tyoca, ca ne'aj jay majatsjacj uvas, uva 'üsǘ mpalas ca. Ts'epjel jas tjijyünsa wa ne'aj, jomozopan ca ne'aj majatjum, majamacj, mpes la p'a ma mpequen̈ ne'aj. Yom tecyawaja la tjiji na, jis tje'yaya mo'o jasin p'a witjacj. Yupj 'ücj la mijicj lo valas, ca ma'ayacj jupj tjevyala popé. Nin la tjiji na, campa tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","”P'a jawasa uva tjevyala na, uva juts'a'á jas tjejyama jupj mozo uva lejen̈ nt'a. Jas tjejyama la ta'es tjevyala popé. ");
INSERT INTO jicNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ne'aj tsji' lajay ma quelel ja'ayaptsja tjevyala popé. Yupj ntji'lin̈ mozo niná, mo'o süp jupj. Jas tjajam, jas pjan tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Locopyaya uva juts'a'á jas tjejyama p'a mozo uva nt'a tsji' lajay nt'a. Yupj jay süp jupj jay pjucj, malala tjowelepj wa jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nin la tjajay na, uva juts'a'á jas tjejyama p'a wa mozo. Yupj tjü'ünan jupj. Yom uva juts'a'á la p'a pülücj sin tjejyama. Yupj süp nepenowá. Tjü'ünan nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”Yom uva juts'a'á ma jas tjejyama custjay jupj jatjam. Pajal quelel la tjiji jupj. Locopyaya jas tjejyama jupj. Yom jólatsja yupj ca püné jin yola jupj jatjam, 'üsüs la mijicj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nin tuluctsja. Niyom ne'aj la 'el yuwá tjowelepj: ‘Niná uva juts'a'á jatjam. Uva lejen̈ nt'a jupj juts'a'á ca nsem, popay tepe'e na. Mas, mü'ü'nacj ca jupj. Mpes uva lejen̈ nt'a cupj cuts'a'á nsem’, nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mpes ntji'lin̈ jupj. Tjü'ünan jupj. Pje'á la ts'i jupj uva sin mpe”, nintsja parabolas. ");
INSERT INTO jicNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús jis la tji'yüya: “¿Ncu solejé tsjan la mijis yom niná? Ca mim uva lejen̈ nt'a, mü'ü'nas ca ne'aj tsji' lajay. Uva sin lejen̈ ca jis ma'ayas la p'a 'ücj la mijicj lo valas. ");
INSERT INTO jicNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Dios Popel nin p'iyá vele. Napj selé nun mo'o tjowelé Dios Popel. Vele: ‘Niyom nepénowa quelel jajünsüptsja wosis pe mpes. Pe pjaní ma jisastsja wosis la jünsüs. Pe niná t'üc' way 'üsüstsja. Mpes qjuis Jepa Dios jas tjijyünsa wosis. Jupj mwalá way tje'yonsa pe niná wosis si jünsa mpes. Pe niná más 'üsüs waytsja pjü pe witjacj jilal. Tsjomis pe niná casá tón̈catsja. ");
INSERT INTO jicNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cupj selecj Dios p'iyá la tjiji niná. Jupj pajal 'üsüs way la tjiji.’ Dios Popel nin vele”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yupj salejeptsja Jesús nin tjevele parábola niná yupj sin po'ó. Mpes quelel tji'lin̈tsja Jesús. Ma nin la tjajay custjay. Lacj jeyaptsja la p'a wa judiopan jis lal. Mpes tjil p'in yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuwá tjowelepj tsjan más 'ücj ca la mü'üyacj Jesús lal, jupj ca malala jis wala cüveles. Jisastsja yupj 'ücj ca jat' mvelecj jupj po'ó. Nin mpes sin tjajam fariseopan nepenowá, niyom la p'a jis lal, la mü'üyacj Jesús lal. Niyom la p'a nenem 'ücj jisastsja Herodes jépatsja Israel mo'ó. Romanopan mpes tsji' líjitsja Herodes. ");
INSERT INTO jicNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yupj tjil Jesús nt'a. Tjowelepj: —Cupj selecj t'üc' way velen. Jipj ma nin jele ncu la p'a wa jisas jipj velen. Nin p'iyá velen pjü jilal, noypan jilal, tsjictjacj jilal wa. Sin 'yüsa lejay Dios jyü'tá t'üc' way. Nin mpes qjuisas mvelen ncu 'ücj Dios lal impuesto jaylacj lijicj jepa romano t'e'enca mpes. ¿Ncu 'ücj jaylacj lijicj? ¿Ncu 'ücj tulucj jaylacj lijicj? ");
INSERT INTO jicNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús seletsja yupj quelel malala lajaytsja jupj lal. Jis la tji'yüya: —¿Tsjan mpes nla 'üyá niná napj lal? Napj selé nun ma quelel jus nlayé nla tjü'üyá mpes. Nujisas napj malala mvelé. Lowa, t'emel c'a pjaní nca'á ma 'ayá la nuc. ");
INSERT INTO jicNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","T'emel c'a pjaní tucutj. Jesús jis la tji'yüya: —¿Pjacj wola t'emel wola po'ó já'asa? ¿Tsjan ló t'emel po'ó tapac? Wola tjowelepj: —Jepa romano jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús tjevele: —Tja'ayá jepá jupj 'ücj le moná nun lal. Tja'ayá Dios jupj 'ücj le moná nun lal. Yupj pajal yólatsja Jesús pajal 'üsüs tjevele mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niyom p'a wa tjiquil Jesús nt'a. Saduceopan waytsja yupj. Yupj javelepj tecya'lin̈ ma ca sin müjünsücj, ma ca mpatjam niswá. ");
INSERT INTO jicNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Saduceopan quelel jat' la velestsja wa Jesús po'ó, mpes tjowelepj jupj lal: —Püna Moisés papel tepyaca tsjan qjuisí jütüta Dios. Ninana pjaní way jupj tepyacá: yom pe'e jats'om popa tulucj, más 'ücj yom jüpülücj mwayis ca tepe'e jats'om lal. Ca popa jana nsem tepe'e jats'om lal. Tepe'e ts'uyupj jin p'iyá ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","”Nin mpes cupj lya 'yüyacj. Püna niyom siéteya tapatja, pjü yupj jis sejatjampan yupj. Mwalá way tjowaya, popa tulucj tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tepe'e na, jupj tsüipe tjowaya tepe'e jats'om lal. Nin p'iyá popa tulucj tepe'e jupj. Jupj tepe'e na, jupj jatjay tjowaya wa jüpülücj jats'om lal. Nin p'iyá tepyala jupj lal. Popa tulucj tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nin p'iyá jis tepyala yupj jis pülücpan pjü. Pjü tjewyayin̈ quepj niná lal. Pjü tecya'lin̈. Popa tuluctsja lovin. Pjü tecya'lin̈ na, quepj niná tepe'e wa. ");
INSERT INTO jicNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","”¿Pjacj jats'om nsem jupj, tecya'lin̈ sin müjünsücj na jis la püt'üs niswá? Pjü way niyom siéteya tjewyayin̈ jupj lal, tapatja na p'in —nin tjowelepj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús wola tjevele: —Nun ma nusin 'yüsa Dios Popel. Ma wa solejé Dios pasal püné way, pjü 'ücj liji jupj. Nin mpes ma nusin 'yüsa niná. ");
INSERT INTO jicNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tecya'lin̈ sin müjünsücj na jis la püt'üs, ma ca mwayin̈ yupj. Angelpan Dios pü'ü nt'a patja jinwá ca nsem yupj. Angelpan ma wyayin̈. ");
INSERT INTO jicNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","”T'üc' way tecya'lin̈ ca sin müjünsücj, mpatjam niswá. Napj selé nun mo'o tjowelé Moisés tepyacá. Tepyaca püna tepyalá, yo tsjicj pwetsja na, Dios ne'aj tjá'asa mpes. Tepyaca Dios jupj lal tjevelá. Dios tjevele: ‘Napj ne Dios Abraham lal, Isaac lal wa, Jacob lal wa’, nin tjevele Dios. ");
INSERT INTO jicNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios tecya'lin̈ jis Dios tulucj. Patja jis Dios jupj. T'üc' way ma solejé nun —Jesús nin tjevele saduceopan jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yom pjaní tjac', tjapjaca Jesús tjevéletsja saduceopan jilal. Yom niná Moisés popel sin 'yüsa lajay sin popa. Jus nléyatsja 'üsüs way jis wala tjevele Jesús. Mpes jupj tjevele Jesús lal: —Dios pülücj way qjuis tjijyü'ta. ¿Cana más 'ücj jis la jay pjü Dios tjijyü'tá popé? ");
INSERT INTO jicNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús wola tjevele: —Napj ca mvelé cana más 'ücj Dios lal ca cupj la mijicj. Jupj tjevele: ‘Nun israelpan, tjapja'aqué. Dios cupj qjuis Jepa Püné. Dios pjaní way jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pajal ca quelel la mijin qjuis Jepa Dios. Pajal ca tsji' la mijin jupj mpes lovin. Lovin ca jele mpalas jupj pajal 'üsüs. Ca jupj jos jin la mijin.’ ");
INSERT INTO jicNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","”P'a wa 'üsüs wa Dios lal ca cupj la mijicj. Jupj tjevele: ‘Ca quelel lis mijin wa ne'aj patjá. Jipj quelel la 'ejay jinwá ca quelel lis mijin yupj.’ Manas Dios qjuis tjijyü'ta jupj po jos nin lijicj. Ninana lijicj más 'üsüs jupj lal pjü way lijicj lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mpes yom niná tjevele: —'Üsüs tjevelen. T'üc' tjevelen Dios pjaní way jupj. Len̈ p'a wa Dios. ");
INSERT INTO jicNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'Üsüs way nin, cupj 'yayacj Dios mpes. 'Üsüs way animal 'yayacj Dios mpes, sacerdote sa 'üm. Mop'in más 'ücj Dios lal pajal quelel lijicj jupj. Más 'ücj lovin ca qjuiyola mpalas jupj pajal 'üsüs. Más 'ücj pajal tsji' la mijicj jupj mpes lovin. Más 'ücj ca jupj jos jin la mijicj. Más 'ücj nin p'iyá quelel la sijicj ne'aj patjá, cupj p'iyá quelel lijicj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yom niná 'üsüs way tjevele jin jólatsja Jesús. Mpes Jesús tjevele jupj lal: —Len̈ way Dios si jütüta popa nsem jipj —nin tjevele Jesús. Nin tjevele na, yupj jus nlaytsja Jesús lovin 'üsüs jis wala tjevele. Mpes lovin ma la tjü'üy Jesús lal niswá. Lacj jeyaptsja Jesús lovin 'üsüs tjevele mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús sin tji'yüsa lis tjíjitsja custjay Dios wo nt'a. Yupj jis lal tjevele: —Dios tjevele jupj ca jas majamas Jepa Püné jis capj la p'acj judiopan. Moisés popel sin 'yüsa lajay javelepj Jepa niná David popa jupj. ¿Tsjan mpes nin javelepj yupj? ");
INSERT INTO jicNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David p'iyá tjevele yom niná jupj Jépatsja. Dios Cjües cus tjep'ya'sa la veles niná. David nin tjevele: ‘Qjuis Jepa Dios tjevele Nejepa lal: “Nt'i'isa napj li'inyampe. Jipj ca müjü'tün napj lal. Napj ca la mpalan jipj enemigopan jis lal. Napj ca la mejay jipj enemigopan tsjyam 'alá jatja jinwá. Nin ca la mejay jipj mpes, jipj napj lal jac' na.” ’ David tjevele niná Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David tjevele niná yomen jupj Jepa wa jupj. Cupj selecj Jepa niná nin p'iyatsja Dios ca jas majamas p'iyá. ¿'Onin nacj ne David popa nacj jupj? —nin tjevele Jesús. Pülücj way tjepjyacan̈tsja Jesús tjevelá. 'Ücj jisastsja tjevele mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús sin tji'yüsa lis tjíjitsja custjay. Tjevele: “Moisés popel sin 'yüsa lajay malala yupj. Po ma nin p'iyá la müjí, yupj lajay jinwá. Yupj jisas la p'a yola noypan yupj, mpes sin quip campa sin quipe yupj. Pülücj lyawun̈ nt'a po jisas la p'a 'üsüs javelepj yupj jilal, 'üsüspan jilal javelepj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Judiopan 'a si mulú nt'a, silla más 'ücj nt'a la 'osos jisas, cocoypan p'in jatja nt'a. Pülücj 'a si mulú na jis la las, más 'üsüs nt'a quelel jatja lovin, noypan jatja nt'a. Nin lajay Moisés popel sin 'yüsa lajay. ");
INSERT INTO jicNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yupj pequen̈ nequem jis wa, nequem jis vayum tecya'lin̈. Newa jisas la p'a 'üsüs jin yola yupj. Mpes püs way javelepj Dios lal pülücj pjyacan̈ nt'a. Nin lajay Moisés popel sin 'yüsa lajay, mpes Dios ca mveles más malala la tjajay yupj la p'a jilal. Más ca jis capj ntülüs yupj pjü jilal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Caja nepénowa játjatsja Dios wo nt'a, t'emel mo'o la 'onsos Dios mpes. Jesús ne'aj p'in 'etjele, yus tjinyuca gente pülücj tjo'onsopj t'emel caja mo'ó. Pülücj jatatj pülücj tjiquil wa, t'emel pülücj tja'ayapj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tjinyuca wa quepj pjaní, t'emel c'a mát'eya p'in mo'o tje'yonsa jupj. Centavo pjaní jaylactsja p'in. Quepj niná voyum tepe'e jupj. Pjü cjuwatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús tjevele jupj discipulopan jilal jis la cuwis. Tjevele: “Quepj niná más pülücj mo'o tje'yonsa la p'a jilal. T'üc' niná. Voyum tepe'e jupj. Pjü cjuwá jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","La p'a pülücj jatatj popé tja'ayapj yupj. Quepj niná pjü cjuwá jupj. Pjü tyá'atsja mo'o tje'yonsa. Cjuwá quinam. Ma polel jaylacj liji la las quinam. Mpes t'üc' way pülücj mo'o tje'yonsa jupj la p'a jilal.” ");
INSERT INTO jicNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Dios wo mpe tjemeytsja na, jupj discípulo pjaní tjevele jupj lal: —Tjinyuca. Tsjay 'üsüs way wosis witjacj qui'á. Noypan yupj. Tsjay 'üsüs way pwen wosis jas tjüjünsüpj mpes, noypan yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús tjevele: —Napj nyuc wosis witjacj nenem. Tjunuca wa nun. Pasal 'üsüs way yupj. Pjü way niná ca malala mpalas. P'a jyawca na judiopan jis enemigopan ca ncul. Yupj ca sin mojoyecj pjü way niná wosis. Pjü pwen ca palá la ncoyecj, wa la tjajay mpes. Pjü ca na'aj la ncoyecj, mpes pe pjaní ma ca p'a casá ma'ajam nsem. Niná t'üc' way —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yacjaya Jesús tjemey joc' 'ala'á, tucuc' Olivos ló nt'a. Jupj 'etjele ne'aj. Ne'aj p'intsja Dios wo ton̈ca nt'a. Jupj ne'aj tjá'asa na, jupj discipulopan nepénowa tjiquil jupj nt'a yusapj. Yupj sin popa pjaní Pedro waytsja, Jacobo p'a wa, Juan p'a wa, Andrés p'a wa. Jupj lal tjowelepj: ");
INSERT INTO jicNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jipj tjevelen cupj qjuilal malala ca mpalas Dios wo. ¿'Ona ca nin mpalas? ¿Tsjan ca mpalas mwalá way p'in, ca jus nlayecj len̈ way malala mpalas ca Dios wo? ");
INSERT INTO jicNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús jis wala tjevele: —'In tjajama. Pülücj ca ncul, ca la ntsawilicj gente jis lal. Ma toponé yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yupj pjaní pjaní ca mvelecj yupj p'iyá Cristo. Ca mvelecj Dios sin tjejyama yupj. Pülücj ca mponecj yupj javelepj. Po ma toponé nun. ");
INSERT INTO jicNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Nun ca jus nlayé wa militarpan pülücj la palan p'a nt'a. Ca jus nlayé wa quelel la palan p'a jyawca na 'ots'ipj. Po ma locj tjeyá niná tepyala na. T'üc' way malala ca mpalas nosis nt'a. Custjay ma pjü tecyawaja niná malala tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ca pülücj la mpa'nacj. Nepénowa patja nt'a la mpa'nacj ca p'a nt'a patja jis lal. Ca jis mü'ü'nacj. Jepapan ca sin majamacj jis militarpan jis la palan la p'a jepapan militar jilal. 'Amá jus nquits'is pülücj jun ta'á. Nepénowa patja nt'a ca pjü cjuwá nsem jis la las 'ots'ipj. Pjü niná ca nin mpalas napj quelel cuwis na. Más malala ca mpalas nosis nt'a napj cuy secj na. ");
INSERT INTO jicNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”'In tjajama. La p'a ca nu ntji'lin̈ nun. Ca nu manucj jepapan nt'a, nucopj la tül. Judiopan 'a si mulú nt'a ca nu nsüpücj. Nun ncapj con̈có, mpes ca nlüjüqué jepapan jis walap'a'á, yupj nepenowá ne'aj p'in se jütütj, yupj nepenowá jepa noypan. Nun ca mvelé yupj jilal 'onin ne 'ücj potjaqué napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma tjacuwis na p'in, napj lal japon ca mvelecj la p'a jilal p'a nt'a. Ca mvelecj napj 'üsüs la tjejay gente mpes. Pjü nosis nt'a, pülücj se jütütj nt'a ca nin la mijicj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","”La p'a wa ca nu ntji'lin̈, ca nu manucj jepapan nt'a. Nin lajay na, ma ca nujola mwalá way p'in tsjan ca mvelé nun yupj jilal. Dios Cjües ca nusin mü'üsüs la mijis tsjan más 'ücj mvelé. Nun ma ca mvelé nun nujola jin. Nun welé na, Dios Cjües jos jin ca mvelé. Mpes nun welé na, Dios Cjües p'iyá ca mveles yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","”Ne'aj patja nun jis enemigopan ca nsem neneyawá, nun ncapj con̈có mpes. Nepénowa malala ca mvelecj jis pülücpan sin po'ó, mpes jepapan ca jis mü'ü'nacj yupj jis pülücpan. Nepénowa ca malala mvelecj wa sejatjampan sin po'ó. Ca jisas wa nsem jepapan jis mü'ü'nacj yupj. Nepénowa ca ts'i mi'inacj jis papay lal, sejamay lal wa. Ca malala mvelecj yupj sin po'ó jepapan jis lal. Mpes ca jis mü'ü'nacj jis papay, sejamay 'ots'ipj. Nin ca la mijicj ncapj jacon̈ jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pjü ma ca jisas nsem nun, nun ncapj con̈có mpes. Po ma nin nujola t'as. Nun poné napj mpes lovin, nun ca 'ücj mpatjaqué Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Ca nucú gente pasal malala la mijicj Dios wo mo'ó. Pasal malala Dios lal yupj ca nlüjün̈ ne'aj. Nin mpes Dios wo pajal te jinwá ca mpalas Dios lal, yupj malala la tjajay mpes. Nin mpes wa len̈ ca nsem ne'aj. Nin tepyala na, más 'ücj Judea mo'o patja nts'equenen̈, joc' mo'o ca mal. (Niná mo'o welé na, nusin tjü'üsüs tsjan mpes napj nin velé niná.) ");
INSERT INTO jicNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Judío pjaní jupj wo jay ton̈ca ca nacj niná pyala na Dios wo nt'a. Más 'ücj jupj len̈ way ts'üequené. Ma ca wo mo'ó mim la ta'es jupj juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jupj sine lejen̈ mo'o ton̈ca ca nacj, niná pyala na Dios wo mo'ó. Más 'ücj jupj len̈ way ts'üequené. Ma ca wo nt'a mim jas quip lo ta'es. ");
INSERT INTO jicNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Niná pyala na, pajal malala ca nsem nequem way jatja jis lal, nequem tsjictjacj jatatj jis lal 'ots'ipj. Pajal malala ca mpalas Judea mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","”La moná Dios lal ma nin ca mpalas jive na. Más costa way ts'üequenequé jive na. ");
INSERT INTO jicNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pajal malala ca la mijicj judiopan jis lal. Más malala ca la mijicj püna la tjajay lal. Niná t'üc' la tjajay na, ma ca nin p'iyá la mijicj lovin. Judiopan pajal 'aplijila ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mpes nun jis Jepa Dios la tjiji ma ca ts'ac' pülücj nsem niná. Püs way malala se palá, pjü nca'lin̈. Dios ma jos pjü nca'lin̈. Jupj lis t'ya nepénowa, yupj jupj lal ca mpatjam. Yupj mpes ma tje'yaya ts'ac' pülücj ca malala mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”Nin tepyala na Judea mo'ó, nepénowa ca mvelecj Cristo tjac' quinam. Ca mvelecj: ‘Tjunucú. Qui'á já'asa niná Jepa Püné Dios jas tjejyama qjuis capj la p'acj.’ Nin ca mvelecj ca nacj. ‘Tjunucú. No'ompe já'asa’, ca mvelecj ca nacj. Nin javelepj na nun jis lal, po ma toponé yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","La tsuwilpan nepénowa ca ncul. Nepénowa ca mvelecj yupj p'iyá Cristo. Nepénowa mvelecj ca yupj p'iyá javelepj Dios mpes. La tsuwil p'in yupj. Yupj ca quelel yus ntsawilicj pjü way. Ca quelel yus ntsawilicj wa Dios lis t'ya jis lal. Nin mpes p'a casá ca la mijicj yupj, gente p'in ma polel lajay jinwá. Jisas la p'a mponecj yupj t'üc' javelepj yupj, niná 'ücj lajay mpes. Dios lis t'ya ma ca mponecj yupj javelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mpes pasal 'in tjajama. Ma nin tepyala na p'in, nin tjevelé niná ca nin mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Malala ca mpalas nosis nt'a. Niná t'üc' tepyala na, lots'ac' püste ca mpalas. Mümüy püste ca mpalas wa. ");
INSERT INTO jicNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pjulacj ca palá jis ntüncüs tsjun mpe. La p'a wa noypan tsjun po'ó ca jus nquits'is. ");
INSERT INTO jicNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","”Niná tepyala na, gente ca nucucj napj cuwis mol mo'ó. Napj p'iyá niná Yomen Dios jas tjejyamá. Cuwis na, püné nsem napj pajal, pjü 'ücj la cüjay. Napj nt'a pajal majawaques ca Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Napj ca sin majam napj angelpan napj lal japon nt'a, pjü jis lal la cuwis. Napj lis t'ya yupj, ca napj lal mpatjam. Mpes angelpan jun ta'á ca mal nosis nt'a, tsjun po'ó 'ots'ipj. Pjü nosis mpe jis lal ncul yupj. Pajal campa patja jis lal ncul wa yupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—Nusin tjü'üsüs parábola niná mpes. Nujola t'as ts'oway po'ó. Lo quelel cyojo na, pjwel 'u'u way jupj. Jis lo tecyojo na, nun solejé len̈ way quelel jive. ");
INSERT INTO jicNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nin p'iyá, nun ca nucú malala ca mpalas nosis casá, napj tjevelé jinwá. Nun niná tjunucú na, nun ca jus nlayé len̈ way ncuwis napj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pjü niná napj tjevelé, pjü ca mpalas. Judiopan newa mpatjam pjü tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tsjun po'ó ca ncawajas, nosis ca ncawajas wa. Napj velé jin ma ncawajas ca la p'in. Pjü tjevelé pjü ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Napj ma ca mvelé 'ona ca nin mpalas niná napj velé. Pjü ma salejepj tsjan jawas ca nsem. Ma wa salejepj angelpan tsjun po'ó. Ma wa selé napj. Napj ne Dios Jatjam. Mpapay p'in selé. ");
INSERT INTO jicNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nujola t'as ca nin mpalas napj tjevelé jin. 'In tjajamá. Ma solejé tsjan jawas nin ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","”Napj nin p'iyá lejay yom campa jama jinwá. Mwalá way jupj vele jomozopan jilal tsjan la mijicj yupj, jupj len̈ na. Vele wa jun vilicj ton̈ca lal 'üsüs way 'in majamas wosis. T'üc' tjevele na, jama jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Más 'ücj yom jomozopan lovin 'üsüs lajay jupj tjevele jin. Yupj ma salejepj 'ona ncuwim. T'yaja na ncuwim ca nacj. Püste na ncuwim ca nacj. Castlyaj li piyú na ncuwim ca nacj. Quelel jyawca na ncuwim ca nacj. Len̈ way ncuwim ca nacj. Mpes más 'ücj lovin la nucucj. Napj yom niná jinwá. Nun napj nomozopan jinwá. Ma solejé 'ona ncuwis. Mpes lovin 'in tjajamá. Más 'ücj lovin ca la ma nucú. ");
INSERT INTO jicNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Niná nin velé nun mpes, nin velé wa pjü mpes. 'In tjajama. Más 'ücj lovin ca la ma nucú. ");
INSERT INTO jicNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ts'ac' mat'e na judiopan fiesta ca la mijictsja. Fiesta niná “Dios Qjuis Capa Nipj Tjemey” ló jupj. Pan levadura cjuwá jalá fiesta mpes. Sacerdote noypan 'a jis tjimyula Moisés popel sin 'yüsa lajay jis lal. Yuwá tjowelepj 'onin ne 'ücj ntji'lin̈ Jesús, la p'a wa ma jus cülayecj. Quelel tji'lin̈tsja jupj, la 'ünan. ");
INSERT INTO jicNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tjowelepj: “Ma ntjiliquem ca jupj judiopan fiesta lajay na. Cupj niná la qjuijicj, yupj ts'i mi'inacj ca pajal. 'A jis mulus ca, la mpa'nacj ca cupj qjuilal,” nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania nt'a tjemey wa. Ne'aj Simón wo wama tjá'asa la las. (Simón malala jostsja püná. Pjoloc' mójotsja jupj.) Ne'aj tjá'asa na, quepj tjac' Jesús nt'a 'üsüs lo jay jupj mpes. Botella pajal 'üsüs justa teque'e jupj. Niná botella pe mpestsja, pe alabastro ló. Nardo botella mo'o tón̈catsja. Perfúmetsja jupj, pülücj jaylacj. Botella jay tji'yula, perfume Jesús jay pjucj po'o t'yu jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nepénowa tjunuc quepj la tjijá. Tjunuc na, ts'a tji'in. Yuwá tjowelepj: —Malala la tjiji. Pjü way t'yu. Tjapjaja perfume. ");
INSERT INTO jicNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yom año pjaní tsji' liji jaylactsja. Más 'ücj vender la qjuijis, t'emel 'ücj así cü'ayas t'emel cjuwá mpes. Pajal cus tjowelel quepan nin la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús ma nin p'iyá jólatsja yupj jinwá. Jupj tjevele: —Po ma cus tjowe'lé jupj. ¿Tsjan mpes nin welé jupj lal? Pasal 'üsüs la tjiji jupj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cjuwá jis lal ca mpatjaqué nun lovin. Nujisas na, nun polel jis capj p'o'sá. Napj ma ca mpü'üs nun jilal lovin. ");
INSERT INTO jicNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Niná polel líjitsja napj mpes, mpes nin la tjiji jupj. P'a jawas ca ma pats'. Nin mpes perfume t'yu jupj nay pjucj po'ó. 'Ücj la ntjiji yupj ca ntoquecj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Napj lal japon ca mal nosis jas tüpwes. Ne'aj ca mvelecj la p'a jis walap'a'á napj 'üsüs la tjejay gente mpes. Jun ta'á yupj jil nt'a, ca mvelecj wa quepj niná 'üsüs la tjiji napj mpes. Ma ca yo' mpa'is. T'üc' way —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Locopyaya Judas Iscariote tjemey sacerdote noypan nt'a. Jesús discipulopan dóceya sin pópatsja jupj. Tjevele 'ücj ca jis lal mim la tjilil Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yupj 'ücj jisas tepyala. Tjowelepj t'emel ca ma'ayacj jupj nin liji na. Mpes Judas la nuctsja 'ona 'ücj jis lal la winin la tjilil Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ts'ac' mwalá way tjejyawca fiesta mpes. Niná fiesta lajay na, pan levadura cjuwá jalá. Fiesta niná “Dios Qjuis Capa Nipj Tjemey” nin ló. Nin jawas oveja tsjicj ja'ünan jis la las fiesta mpes. Jesús discipulopan la tjü'üy jupj lal: —¿Ca'aj jyas cupj ca nlaca 'ücj la mijicj ca nlajan fiesta mpes? ");
INSERT INTO jicNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Discipulopan mát'eya sin tjejyama 'ücj la mijicj. Yupj jilal tjevele: —Jerusalén nt'a nlawú. Ne'as tjalawú na, nun la müjüsüqué yomen jarro t'ya, 'üsǘ mo'o ton̈ca. Cjüil lowa. ");
INSERT INTO jicNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jupj jama nt'a wama mim. Ne'aj wo lal tjowelé: ‘Yom qjuisin 'yüsa liji qjuisin tjejyama jipj nt'a. Jupj tjevele cupj ca lya mü'üyacj ca'aj já'asa jupj ca nlajas nt'a. Jupj quelel lyaja ne'aj jupj discipulopan jilal fiesta mpes, fiesta “Dios Qjuis Capa Nipj Tjemey” ló.’ ");
INSERT INTO jicNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mpes ne'aj wo 'esepj nun jis lal ca mim cuarto püné nt'a, wo casá ton̈ca. Jupj nasa 'ücj la tjiji cuartas quinam. Pjü qjuisas ne'aj jatja cupj mpes. Ne'aj ca 'ücj la müjí cupj nlajacj mpes —Jesús nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mpes discipulopan mát'eya nenem tjil. Pjü Jesús tjevele jin tepyala. Mpes 'ücj la tjajay jis la las fiesta mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Püste tepyala na, Jesús tjemey cuarto niná nt'a jupj discipulopan dóceya jilal. ");
INSERT INTO jicNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ne'aj játjatsja, jalatsja. Jesús tjevele: —Nun popa pjaní malala nyuca la mijis napj lal. Quina lyaja napj lal. Jupj ca jis lal ncuwim napj enemigopan, ca yupj ma tjililin̈. T'üc' way nin ca ma palas —tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mpes yupj 'aplijila jis tepyala. Pjaní pjaní la tjü'üy: —¿Ncu napj ca nin la cüjay? ");
INSERT INTO jicNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús tjevele: —Jupj napj discipulopan dóceya popa pjaní. Jupj pan mo'o ts'yuca wa, lyaja wa napj mplato mpe, la p'a wa jinwá. Jupj ca jis lal ncuwim ma tjililin̈. ");
INSERT INTO jicNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Napj p'iyá niná Yomen Dios jas tjejyamá. Pajal püna profetapan tapac ca nin ma palas napj. Yupj tapac jin p'iyá ca nsem. Ma pats' ca napj, yupj tapac jinwá. Mop'in pajal malala nin, jupj ca jis lal ncuwim napj enemigopan, ca ma tjililin̈. Pasal malala ca mpalas jupj, jupj malala la niji mpes. Pajal malala ca mpalas jupj, mpes más 'ücj ca nactsja jupj lovin ma pǘ'ütsja —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yupj jalatsja na, Jesús nt'ya pan pjaní. Tjevele Dios lal tjüwüi'i pan tje'yaya mpes. Nin la tjiji na vitvitj la tücüeme, jis tje'yaya jupj discipulopan. Jis tje'yaya na, tjevele: —No'oté, nlajá. Niná pansas napj mp'üy jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tjalá na, jupj nt'ya wa pocillo, uva 'üsǘ mo'o tón̈catsja. Tjevele Dios lal tjüwüi'i uva 'üsǘ tje'yaya mpes. Pocillo jis tje'yaya jupj discipulopan. Pjü vitvitj tjimyü'ün̈. ");
INSERT INTO jicNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jis tje'yaya na, tjevele: —Niná uva 'üsǘ napj na'as jinwá. Ma pats' ca napj nun mpes, la p'a pülücj mpes wa. Napj ca 'as ma palas. Mpapay tjevele t'üc' ca perdonar lis mijis napj ntipü'í na. ");
INSERT INTO jicNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Napj lovin ma ca mü'üs uva 'üsǘ niswá quinam. P'a jawasa mpatjaquecj Dios jyü'ta nt'a. Nin jawas tjejyawca na, niswa ca mü'üs napj. T'üc' way velé —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yacjaya tjenejets'en̈ Dios po'ó. Lovin nin lajaytsja fiesta mpes. Tjenejets'en̈ na, tjil. Joc' Olivos ló nt'a tjil. ");
INSERT INTO jicNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús tjevele yupj jilal: —Nun pjü way ca nts'equenequé malala ne palá na. Nasapj mo'os. Püna profeta tepyaca ca nin mpalas. Tepyaca: ‘Napj ca mü'ünan oveja jyama, mpes jupj oveja witjacj sin tjan ca mal.’ ");
INSERT INTO jicNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Newa napj ca 'üsüs la mejay nun mpes. Napj ca niswa nin müjünsǘ la püt'üs. Niswa pü'üs na, ca mis Galilea nt'a. Napj mwalá way ca mis nun jis lal, cupj ca la müjüsüquecj ne'aj —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro tjevele: —Pjü ca nts'equenen̈ ca nacj. Napj lovin ma ca nin la mejay. ");
INSERT INTO jicNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús tjevele: —Yacjaya püste p'iyá jipj p'iyá ca mvelen ma nus nyuc. Castlyaj cocoy la pjaní p'in la tipiya na, jipj la con ca mvelen ma nus nyuc. ");
INSERT INTO jicNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro tjevele t'üc' way ma ca nin la mijis. —Napj 'ücj wa ni pü'í jipj lal. Lovin ma ca mvelé ma jis nyuc —nin tjevele Pedro. Nin p'iyá tjowelepj wa pjü discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Locopyaya yupj pje'á tjil. Sine lejen̈ nt'a tjil, Getsemaní ló ne'aj. Jesús tjevele jupj discipulopan jilal: “Mis mvelé Mpapay Dios lal. Nínawa majatjaqué velé na jupj lal.” ");
INSERT INTO jicNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jupj discipulopan cónt'eya jis lal tjemey ne'aj p'in. Pedro pjaní wa, Jacobo p'a wa, Juan p'a wa. Jesús pasal jólatsja, pasal 'aplijila tepyala. ");
INSERT INTO jicNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tjevele: “Nasa ni pü'í jin najas, pasal 'aplijila mpes. Quive la ntjunucú. Po ma müjünaqué, ma nyucun nsem nasapj.” ");
INSERT INTO jicNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jusapj tsjicj way p'in tjemey. Palá tipi'tje, tjevele Dios lal jupj jostsja ma ca malala la mijicj jupj. La tji'yüya ncu 'ücj ma ca nin mpalas. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Mpapay, pjü polel lejay jipj. Najas jipj la mijin ne yupj ma malala la ma jicj. Newa najas ca jipj jyas jinwá nsem. Ma napj najas jinwá t'as”, nin tjevele Jesús jupj Popay lal. ");
INSERT INTO jicNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","T'üc' tjevele na, Jesús tjac' jupj discipulopan nt'a. Yus tjinyuca tjijinan̈ yupj. Tjevele Pedro lal: “Simón, ¿ncu tjejyan? ¿Ncu ma polel nyucuntsja hora pjaní p'in? ");
INSERT INTO jicNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma müjünaqué. La moná Dios lal ma ca malala la müjí, nun quelel malala lojí na. Napj selé nun quelel lojí napj najas jinwá. Mop'in pajal costa nun jis lal, nun niyom p'in”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Niswa Jesús jusapj tjemey. Nin p'iyá nin tjevele Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jupj niswa tjac' jupj discipulopan cont'e tapatja nt'a. Niswa yus tjinyuca tjijinan̈ yupj. Pajal ja sívetsja. Jis tsyülümǘ na jis tjemyayca, mpes ma salejeptsja tsjan más 'ücj la veles jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesús tjemey niswá la veles Dios lal. Niswa tjac' na jupj discipulopan nt'a, jis la tji'yüya: “¿Ncu potjaqué jünaqué custjay? Nasa t'üc' tjüjünaqué. Po quina ca mpalas napj tjevelé jinwá. Napj p'iyá niná Yomen Dios jas tjejyamá. Najamica pjaní jis lal ncuwim napj ne'enemigopan, ca ma tjililin̈. Malala lajay ca malala la ma jicj, yupj jisas jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Nusin tjüjünsǘ! Mas quinam la müjüsüquecj yupj. Nasa jac' quinam yom malala la niji. Jis lal jac' napj ne'enemigopan”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jilal véletsja na, Judas ne'aj tjac'. Jupj Jesús apostolpan dóceya popa watsja. Püs way se cón̈catsja Jesús. Pülücj tjiquil jupj lal quinam. Polomay jatatsja, yo pjwel jatatj watsja mo'o la süp Jesús. Sacerdote noypan sin tjajam jis la tjilil Jesús. Moisés popel sin 'yüsa lajay sin tjajam wa. Co'müypan sin tjajam wa. ");
INSERT INTO jicNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas jis lal tjac' la tjilil Jesús. Jupj nasa tjevéletsja ca sin 'yüsa la mijis cana Jesús. Tjevele: “Pjaní lal ca la nlapan napj. Niná Jesús. Ntjüiliqué jupj. Tjamanú jupj. 'Üsüs tjajama ne ma mim.” ");
INSERT INTO jicNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mpes ne'aj tjemey Judas, Jesús nt'a p'in. Ne'as tjemey, 'üsüs tjevele jupj lal, quelel la tjiji jinwá. Tjevele: —Nejepa. ");
INSERT INTO jicNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Niyom la p'a ntji'lin̈ Jesús, jis la man jupj jepapan nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesús discípulo pjaní ne'aj p'in tón̈catsja. Jupj polomay syults'a. Jay tjejyo'o yom pjaní. Jupj pjots' taná tjejyo'o jupj. Yom niná mozo waytsja sacerdote más püné mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús tjevele pülücj tjiquil jis lal: —¿Tsjan mpes polomay t'o, yo pjwel t'o wa la tjilil napj? Niná lojí pwequepj la tjilil. ");
INSERT INTO jicNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pjü jyawca tjo'os napj nun jilal Dios wo nt'a. Ne'aj sin tji'yüsa la tjejay. Nun lovin ma ntjutjililiqué ne'aj. Niná tepyala ca t'üc' mpalas Dios Popel vele jin. ");
INSERT INTO jicNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nin tjevele na, Jesús discipulopan pjü way ts'equenen̈. Jesús ne'aj ton̈ca tjil. ");
INSERT INTO jicNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tjamacjas Jesús cjüil tjemeytsja. Jupj sa capyatsja jas quip pjyapja mpes la p'in. Yupj ntji'lin̈ wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jupj jas quip ntji'lin̈tsja p'in. Mpes ts'üequené jupj, jas pjütpjüt' way tjemey. ");
INSERT INTO jicNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yupj tjaman Jesús sacerdote más püné nt'a. Sacerdote noypan pjü way 'a jis tjimyula ne'aj. Co'müypan ne'aj tjatja wa, Moisés popel sin 'yüsa lajay ne'aj tjatja wa. ");
INSERT INTO jicNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro Jesús cjüil tjemey campapé. Ne'as tjemey wa jupj sacerdote más püné wo nt'a. Tjüwücj mo'o wama tjemey jupj. 'Etjele militarpan nepénowa jilal. 'Awa süísetsja. ");
INSERT INTO jicNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne'aj jatja watsja sacerdote noypan. Ne'aj jatja watsja judiopan jis jepapan. Yupj 'a mulú jajütütsja judiopan. Yupj pjü la tjü'üy tjunuc pjacj malala mveles Jesús po'ó. Po quelel javeleptsja 'ücj cus la tül jupj. Quelel ja'ünantsja jupj. Newa pjü tjunuc Jesús malala la tjiji tulucj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pülücj tjiquil la tsuwil Jesús po'ó. Tjowelepj Jesús malala la tjiji. Newa nin ma nin p'iyá tjowelepj. Mpes jepapan ma polel cus tül Jesús yupj tjowelepj mpes. Pjaní p'in t'ya tjevele mpes, ma polel cus tül jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Locopyaya la p'a tjiquil yupj jis walap'a'a la tsuwil Jesús po'ó. Tjowelepj: ");
INSERT INTO jicNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Cupj tjepjya'aquecj Jesús malala tjevele. Tjevele: ‘Gente p'in jas tjüjünsüpj Dios wo. Napj ca jas mojoy. Ts'ac' cont'e na, napj t'üc' ca jas müjünsǘ niswá. Gente tulucj ca jas müjünsücj’ —nin tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Newa nin ma nin p'iyá tjowelepj ninana tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Niná tjowelepj na, sacerdote más püné tüwütüwǘ ton̈ca. La tji'yüya Jesús lal: —¿Ncu ma ca qjuis lal mvelen ncu t'üc' way nin tjevelen? Yupj javelepj malala tjevelen jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ma wola tjevele. Lyájasa tón̈catsja. Sacerdote más püné la tji'yüya niswá: —¿Ncu jipj niná Yomen Dios tjevele ca jas majamas qjuis capj la p'acj? ¿Ncu Dios Jatjam jipj? Dios pasal 'üsüs way jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús wola tjevele: —Nin napj. Nun ca nucú napj t'üc' way velé. Napj p'iyá niná Yomen Dios jas tjejyamá. P'a jyawca na ca nus nucú napj ca mo'os Dios li'inyampe. Ne'aj ca mo'os, ncupj 'a mulú ca müjü'tücj. Dios pajal jas tjiyocj pjü jilal. Nun ca nucú napj ncuwis nosis nt'a mol mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jupj nin tjevele na, sacerdote más püné la tücüeme jupj jas quip. Judiopan nin lajay p'a wa malala vele na Dios po'ó. Tjevele: —¡Ma qjuisas la p'a mvelecj Jesús malala nyuca la tjiji! ¡Nasa t'üc'! ");
INSERT INTO jicNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nun tjapja'aqué pajal malala tjevele Jesús. ¿Ncu pajal malala la tjiji Jesús? Pjü way tjowelepj malala la tjiji. Tjowelepj más 'ücj mü'ü'nacj jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nin tjowelepj na, nepénowa cus tuputs' Jesús wola po'ó. Pülül mpes tsupapj Jesús jun. Yupj jis mas sa lototsja, jüp'üy po'o tül jupj. Tjowelepj: —Qjuis wala mvelen, ¿pjacj wyala po'ó tyüla? ¡Dios ca jin mü'üsüs la mijis! Malala tjowelepj, mpes la tjüpjüts'ün jupj lal. Sacerdote militarpan Jesús lal tjil, mo'o la süp. ");
INSERT INTO jicNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro já'asatsja custjay wosis t'asiyú tjüwücj mo'ó. Ne'aj tjá'asa na, tsjücjüim ne'aj tjac' wa. Sacerdote más püné jomózotsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro 'awa süísetsja custjay. Tsjücjüim niná jus tjinyuca jupj, püs way jus tjinyúcatsja. Tjevele: —Jipj cus tecyon̈tsja wa Jesús, Jesús Nazaret mpe 'esepj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro tsyüpünǘ. —Nin tulucj —tjevele—. Ma nin 'yüsa tsjan mpes nin velen jipj. Tjemey tjüwücj jun vilicj nt'a. Castlyaj cocoy la tipiya quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ne'aj ton̈ca na, tsjücjüim jus tjinyuca ne'aj. Tjevele yupj jilal ne'aj: —Niná Jesús discipulopan popa. ");
INSERT INTO jicNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro niswa tsyüpünǘ. Yacjaya ne'aj p'in lejen̈ tjowelepj: —T'üc' way jipj jupj discipulopan popa. Galilea mpe 'esepj wa jipj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro tjevele: —Dios 'ücj ca ncapj ntülüs napj li tsuwil. Yom niná ma si nuc. T'üc' way velé napj. ");
INSERT INTO jicNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nin tjevele na castlyaj cocoy la tipiya niswá, lama quinam. Mpes Pedro jola tepyala Jesús tjevelá: “Jipj p'iyá ca mvelen ma nus nyuc. Castlyaj cocoy la pjaní p'in la tipiya na, la con ca mvelen ma nus nyuc.” Mpes Pedro pasal la tipiya, pajal 'aplijílatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yaya pajal püstapj pjü way judiopan jis jepapan 'a jis tjimyula, yupj nepenowá sacerdote noypan, nepénowa co'müypan, nepénowa Moisés popel sin 'yüsa lajay, nepénowa p'a wa jepapan judiopan sin popé. Tjüjütütj tsjan ca la mijicj Jesús lal. Jupj mos tsupapj. Tjaman jupj Pilato nt'a. Pilato jepa püné auxiliar waytsja jupj. Románotsja jupj, judío tulucj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato la tji'yüya Jesús lal: —¿Ncu judiopan jis jepa püné jipj? Jesús wola tjevele: —Nin napj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdote noypan tjat' tjowelepj Jesús po'ó jepa romano wolap'a'á. Tjowelepj la pülücj malala la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mpes Pilato la tji'yüya Jesús lal: —¿Ncu ma quelel qjuis wala velen ncu t'üc' malala la tjejay, yupj javelepj jinwá? Javelepj jipj la pülücj malala la tjejay. ");
INSERT INTO jicNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús newa ma lal tjevele jupj. Pilato pasal nin jólatsja tsjan mpes Jesús ma tjevele. ");
INSERT INTO jicNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato janmacj jas tjejyama yom pjaní cawilta mpe fiesta niná tepyala na. Judiopan janmacj la t'apj pjacj pje'á nyacas cawilta mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cawilta mo'o já'asatsja yom malala la tjijá, Barrabás lotsja jupj. Jupj jepa püné lal la tapalan sin popa watsja. La tapalan na, jis tjü'ünan la p'a. Nin mpes játjatsja quinam cawilta mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Judiopan Pilato wo nt'a 'a jis tjimyula, tjil quinam Pilato nt'a, tjowelepj: —Janmacj se jam yom pjaní cawilta mpe fiesta tepyala na. Qjuisas nin lejay quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato jis la tji'yüya: —¿Ncu jisas se jam judiopan jis jepa? ");
INSERT INTO jicNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato seletsja sacerdote noypan tjejyaman̈tsja Jesús lal. Seletsja nin mpes tucuman jupj. Jisastsja Pilato ca cus ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sacerdote noypan nasa tjowelepj 'a jis tjimyula jis lal. Tjowelepj pajal malala Jesús. Más 'ücj la mon ca jas majamas Barrabás, tjowelepj. Mpes nin la tjomon. ");
INSERT INTO jicNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato tjevele: —¿Tsjan jyas napj lejay yom niná lal? Nun welé jupj p'iyá judiopan jis jepa püné. ");
INSERT INTO jicNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yümücj tjowelepj: —¡Cruz po'o tjevyala, mpa'is jupj! ");
INSERT INTO jicNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato jis la tji'yüya: —¿Tsjan mpes? Ma malala la tjiji. Más yümücj tjowelepj: —¡Cruz po'o tjevyala, mpa'is jupj! ");
INSERT INTO jicNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato jostsja yupj ma ca ts'i mi'inacj. Mpes jas tjejyama Barrabás cawilta mpe. Tjijyü'ta jupj militarpan jilal mo'o nsüpücj Jesús. Tjijyü'ta cruz po'o mvalacj, la 'ünan. ");
INSERT INTO jicNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Niná tjijyü'ta na, militarpan tjaman Jesús Pilato wo nt'a. Wama tjil. Pilato wo Pretorio lotsja. Pünetsja pajal. Tjowelepj jis la cuwis wa la p'a wa militarpan Pilato wo nt'a tsji' la tjajaytsja. ");
INSERT INTO jicNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jas tjüwü'ün Jesús militar jas quip je mpes. Nin la tjajay la pjüts'ün jupj mpes. Pülül je jepa jas quip jin jústatsja. Yo pjwel jam jus tjulujupj jay pjucj po'o la 'onsos. Jesús jay tjo'onsopj, corona jay tjá'asatsja jinwá. ");
INSERT INTO jicNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tjowelepj: —¡Qjuisas 'ücj jyas mpü'üm! ¡Jipj jepa püné judiopan jilal! Pajal la tjüpjüts'ün jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La pülücj Jesús jay süptsja tjacjaj mpes. La pülücj cus tuputs' Jesús wola po'ó. Yupj jis tic' mpes tjijyünsünün̈. Nin lajay jepapan jilal, mop'in ma topon jépatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","T'üc' la tjüpjüts'ün na, jas tjü'ipj pülül je. Jas tücüipap jupj jas quip mpes. Pje'á tjaman jupj la valas jupj cruz po'ó. ");
INSERT INTO jicNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jümücj nt'a jiltsja na, yom pjaní ntji'lin̈ yupj. Jupj nasa way jactsja Jerusalén nt'a jupj tüpü'ü mpe. Jis wa pjaní pjaní lejen̈ mpe tjac' jupj. Simón lotsja jupj. Cirene mpe 'eseptsja. Jupj ne Alejandro popay, Rufo popay wa jupj. Militarpan tjüjütütj Simón ntjamas cruzus. ");
INSERT INTO jicNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nin la tjajay na, tjaman Jesús Gólgota nt'a. “Gólgota” mpes 'ücj la veles “Jay Pjucj Cjüele” cupj qjuis tin. ");
INSERT INTO jicNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Uva 'üsǘ tja'ayapj Jesús lo müs. Uva 'üsǘ mirra la süpjütsja, pajal nepé vyaja lo ts'uc. Jesús jus nleya leméliyu la süpjütsja, ne ma tjümü'ü. ");
INSERT INTO jicNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cruz po'o tjovalapj jupj. Militarpan jisastsja Jesús jas quip. Mpes tjepjelan̈ tjunuc pjacj nta'es jupj jas quip. ");
INSERT INTO jicNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve na, püstapj, cruz po'o tjovalapj jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nasa tapac tsjan mpes cus tül Jesús. Tapac: ");
INSERT INTO jicNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yupj tjovalapj wa pequepan mát'eya p'a wa cruzus po'ó. Pjaní way tjovalapj Jesús li'inyampe. La p'a wa tjovalapj Jesús nancupwepe. ");
INSERT INTO jicNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dios Popel tjevele niná ca nin mpalas. Tjevele: “Yupj yólatsja jupj malálatsja, malala lajay jinwá”. Nin tepyala quinam. ");
INSERT INTO jicNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Judiopan nepénowa cruz ton̈ca jin tjil. Malala tjowelepj Jesús po'ó. Yupj sey pjucj la süpjüntsja jupj mpes. Ma topon 'üsüstsja jupj. Jupj lal tjowelepj: —Jipj tjevelen ca jas mojoyen Dios wo. Ts'ac' cont'e na ca jas müjünsün niswá, nin tjevelen. ");
INSERT INTO jicNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mpes, ¡palá was cruz mpe! ¡Cyapj tjep'ya'sa jipj p'iyá! ");
INSERT INTO jicNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdote noypan yuwá tjowelepj. La tjüpjüts'ün wa Jesús po'ó. Nin p'iyá la tjajay wa Moisés popel sin 'yüsa lajay. Tjowelepj: —Jis capj tjep'ya'sa la p'a wa. Ma polel cus la p'acj jupj p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jupj vele jupj p'iyá niná Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. Jupj vele Jepa jupj israelpan jilal. Qjuisas palá ncuwim cruz mpe, ca nucucj ncupj. Jupj nin la qjuijis, cupj cüponecj catsja jupj mpes —nin tjowelepj. Pequepan cruz po'o lejen̈tsja pasal malala tjowelepj wa Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lots'ac' culupwen nt'a tjá'asa na, püste tepyala pjü nosis nt'a. Hora cont'e mpes pǘstetsja. ");
INSERT INTO jicNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Las tres na Jesús yümücj tjevele: —Eloi, Eloi, ¿lama sabactani? (Cupj qjuis tin mpes velecj: “Napj Ndios, napj Ndios, ¿tsjan mpes 'os tjay jipj?”) ");
INSERT INTO jicNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","La p'a wa ne'aj p'in tjelejen̈tsja. Tjepjyacan̈ na jupj tjevelá, ma sin tji'yüsa jupj tjevelá. Nepénowa yupj sin popa tjowelepj: —Tjapja'aqué. Jupj jos Elías ncuwim cus la p'acj jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yom pjaní ts'üequené, esponja teque'e. Mo'o ts'yuca uva 'üsǘ 'ona mpes. Esponja yo jay tsyu'pa, viyá tecyacaná Jesús lo müs. Tjevele: —'Ücj quinam. Ma ca p'a la müjí. Ca nucucj ncu Elías jac' palá nt'anques jupj cruz mpe. ");
INSERT INTO jicNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús yümücj tjevele, tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pülül p'omp'om jálatsja Dios wo mo'ó, pülül niná wo t'em pjaní jinwatsja. Jesús tepe'e na, nayapé palavin la tücüeme. Jas tüpwes la tücüeme jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jepa militar tón̈catsja Jesús wolap'a'á. Jupj tjapjaca wa Jesús yümücj tjevele na. Tjinyuca 'oyn nyuca tepe'e jupj. Mpes tjevele: —T'üc' way yom niná Dios Jatjam waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nequem nepénowa campa way 'in lejen̈tsja, tjunuc tepyalá. Pjaní wa María lotsja, Magdalá mpe 'eseptsja. P'a wa María ló watsja. Jupj Jacobo jamaytsja, José jamay watsja. Jacobo niná “Jacobo pjyapja” tjowelepj yupj. Quepj p'a wa ne'aj Salomé lotsja. ");
INSERT INTO jicNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nequem nenem cus tocon̈tsja Jesús Galilea po'o tjuwine na. Yupj tjojon jupj mpes, 'ücj la tjajay wa jupj tüpü'ü nt'a. Nequem la p'a wa pülücj lejen̈tsja wa ne'aj. Nasa tjiquil wa Jesús lal Jerusalén nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nin jawas pjü 'ücj la tjajay ya mpes, ya ma ca tsji' la mijicj. Sábado nsem yayá. T'awaná tepyala quinam, ");
INSERT INTO jicNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mpes José tjac' quinam. Arimatea mpe 'eseptsja jupj. Jupj judiopan jis jepapan popa watsja. Püné waytsja yupj jis lal. Jostsja wa Dios len̈ way müjü'tüs ca nosis nt'a. Ma lecj tjeyatsja Pilato lal. Mpes tjemey Pilato nt'a, la tjemyona Jesús jüp'üy la toc. ");
INSERT INTO jicNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ma seletsja pasal len̈ way tepe'e Jesús. Mpes tjijyü'ta la cuwis jepa militar. La tji'yüya ncu nasa tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jepa militar tjevele nasa tepe'e. Mpes Pilato tjevele José 'ücj la ta'es Jesús jüp'üy. ");
INSERT INTO jicNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mpes José pülül pje jaylacj la tjiji. Palá t'e'enca Jesús jüp'üy, jas tjivyü'ünǘ. Tipyünta Jesús jüp'üy pe jul mo'ó, neven nt'a, tepe'e 'ücj la püntüs nt'a. Püna p'in tjijyü'ta la toc jomwen jul, tepe'e tulucj p'in. Nin lajaytsja judiopan. Jesús jüp'üy ne'aj tipyünta na, pe pones jas tentené, jun t'yo'na jomwen jul. ");
INSERT INTO jicNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nequem mát'eya tjunuc ca'aj tipyünta Jesús jüp'üy. Pjaní wa María, Magdalá mpe 'esepj. La p'a wa María ló watsja, José jamay. ");
INSERT INTO jicNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado tecyawaja na, nequem cónt'eya pjü 'ücj la tjajay. Lo pajal 'üsüs way cjumsu jaylacj la tjajay. Quelel sa cjololtsja Jesús jüp'üy 'üsüs la cjumsus. Pjaní wa María, Magdalá mpe 'eseptsja. La p'a wa María ló watsja, jupj Jacobo jamay. La p'a wa Salomé ló waytsja. ");
INSERT INTO jicNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo na tjil Jesús jüp'üy pǘ'ütsja nt'a. Pajal püstaptsja, tjejyawca na p'in tjil. ");
INSERT INTO jicNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yuwá jis la tjü'üy: “Jomwen jul nt'a, ¿pjacj ca jas ntentenes pe pones, 'ücj wama leque?” ");
INSERT INTO jicNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ne'as tjil na, tjunuc jun vilicj jun cjol quinam. Pe pajal pünetsja nasa t'üc' jas tentené tepyala. ");
INSERT INTO jicNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pe jul wama tjil na, jus tjunuc tjamacjas. Jupj jas quip pje waytsja, cámpatsja. Tjá'asa yupj li'inyampe. Pasal lacj jeyaptsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tjamacjas tjevele: —Po ma locj tjeyá. Napj selé nun lo palá Jesús jüp'üy, jupj ne Nazaret mpe 'eseptsja. Nasa tjovalapj jupj cruz po'ó, tepe'e. ¡Jas tjijyünsa, nyucunú tepyala niswá! Jupj len̈ qui'á. Tjunucú jupj tüpü'ü nt'a. Len̈. ");
INSERT INTO jicNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lowa Pedro nt'a, jupj discipulopan la p'a wa nt'a wa. Jilal mvelé: ‘Jesús mwalá way jama nun jilal Galilea nt'a. Ne'aj ca jus nucú. Niná nun jilal tjevele jupj nawaja'a.’ ");
INSERT INTO jicNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mpes nequem nenem len̈ way tjil pe jul mpe. Pasal ticyücüyün̈, lacj tjeyaptsja mpes. Tjil na, ma tjowelepj la p'a jilal lacj tjeyaptsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo na Jesús jas tjijyünsa, tüpü'ü niswá. Mwalá way lay tepyala María Magdalena lal. Püna lapanenpan siéteya tapatja jupj jos mo'ó. Jesús pje'á lis ts'iya yupj, mpes tji'yü'sa jupj. Nin tepyala püná. ");
INSERT INTO jicNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Quina María tjemey Jesús discipulopan nt'a. Yupj 'aplijila way tjátjatsja, la tupuyuptsja. María tjevele yupj jilal Jesús lay tepyala jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tjevele Jesús nyucunú niswá, nasa jus tjinyuca, tjevele. Yupj ma topon. ");
INSERT INTO jicNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yacjaya Jesús discipulopan mát'eya jilal lay tepyala wa. Yupj tjelyawun̈tsja jis wa pjaní pjaní lejen̈ nt'a. P'a casá jústatsja jupj, yupj jus tjunuc na. ");
INSERT INTO jicNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Discipulopan nenem tjil la p'a discipulopan nt'a. Tjowelepj yupj jilal Jesús lay jis tepyala. Ma wa topon yupj tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yacjaya Jesús lay jis tepyala jupj apostolpan once jilal. Yupj 'a mulú jalatsja jupj lay jis tepyala na. La p'a wa nasa tjowelepj yupj jilal yupj jus tjunuc Jesús. Nasa jas tjijyünsa, nyucunú niswá, tjowelepj. Newa ma topon. Mpes Jesús yupj jilal tjevele malálatsja ma nin topon yupj tjowelepj. Tjevele malálatsja ma wa quelel japontsja. ");
INSERT INTO jicNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tjevele yupj jilal: “Lowa nun pjü nosis casá. Tjowelé pjü jis walap'a'á Dios pajal 'üsüs la tjiji gente mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pülücj ca mponecj napj lal nun welé mpes. Napj lal japon ca bautizar jis mpalas. Nin lajay 'üsüs ca mpatjam Dios lal. Ma japon, Dios ca jis capj ntülüs malala lajay mpes. ");
INSERT INTO jicNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Napj lal japon ca 'üsüs la mijicj, gente p'in ma polel lajay jinwá. Mpes la p'a ca jus nlayecj Dios jis capj cyon̈ca. Ca 'ücj pje'á la nts'iyacj lapanenpan. Nin ca 'ücj la mijicj napj nlá ca mvelecj mpes. Ca polel mvelecj la p'a jis tin, yupj p'iyá ma sin 'yüsa la veles. ");
INSERT INTO jicNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ca polel nt'anquecj lotsjim. Veneno myü'ün̈ na, ma nca'lin̈ ca. Yupj po la mo'ot'ecj ca malala jisas sey pjucj, ca jis mü'ü'süs yupj. Niná pjü lajay mpes la p'a ca jus nlayecj Dios jis capj cyon̈ca.” ");
INSERT INTO jicNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Qjuis Jepa Jesús t'üc' jilal tjevele na, Dios jas tjemyana jupj tsjun po'ó. 'Etjele jupj Dios li'inyampe. ");
INSERT INTO jicNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jupj discipulopan tjil jun ta'á, la p'a jis walap'a'a tjowelepj Jesús 'üsüs la tjiji. Qjuis Jepa Jesús jis capj tjep'ya'sa. Mpes 'üsüs la tjajay, gente p'in ma polel lajay jinwá. Mpes la p'a jus nlay t'üc' way tjowelepj yupj Dios tjevelá.");
INSERT INTO jicNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Don Teófilo mpes: Qjuis catjampan nepénowa Jesucristo cus tocon̈, jupj nosis mo'o tjuwine na. Yupj tjunuc jupj la tjijá. Yupj tjepjyacan̈ jupj tjevelá. Jupj jomozopan waytsja yupj, ne p'a jilal tjowelepj Dios tjevelá. Locopyaya tjowelepj wa cupj qjuilal pjü tepyalá. Mpes cupj sin popa pülücj quelel japactsja Jesucristo la tjijá qjuis catjampan tjunuc. Napj nin p'iyá quelel pyactsja. Pajal püs way, tülü way la tji'yüy, nin tji'yüsa pjü tepyalá. Mpes quina 'ücj napj lal pjü pyac. Pjaní pjaní ca mpac, mpes ca jin mü'üsüs jipj. 'Üsüs way jipj pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","La p'a jin tji'yüsa la tjajay wa Jesucristo po'ó; napj pyac mpes jipj ca jus nlayen t'üc' way nin tepyala. ");
INSERT INTO jicNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Püna Herodes jepa más püné waytsja Judea nt'a. Jupj tüpü'ü na, yom Zacarías ló sacerdote waytsja Dios wo nt'a. Sacerdotepan pülücj tapatja. Lovin nepénowa yupj sin popé 'a mulú tsji' la tjajay, locopyaya p'a wa tsji' la tjajay. Newa nepénowa tsji' la tjajay lovin. Zacarías tsji' líjitsja jilal Abías lotsja, yupj 'a mulú tsji' la tjajay na. Zacarías jats'om Elisabet lotsja. Elisabet Aarón püna tüpü'ü popa p'iyatsja püs naya tüpü'ü jupj. (Aarón sacerdote waytsja 'ots'ipj. Sacerdote mwalá waytsja jupj.) ");
INSERT INTO jicNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías, Elisabet, manas 'üsüs waytsja Dios lal. Malala tulucj. Lovin pjü la tjajay yupj jis Jepa Dios tjijyü'tá jupj Popel mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Newa sin popa cjuwá yupj. Elisabet cjuwá tsjicj way lovin; manas co'müy waytsja yupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","P'a jyawca na, niyom Zacarías tsji' líjitsja jilal tsji' la tjajay Dios wo nt'a, ne Zacarías tsji' la tjiji wa yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sacerdotepan lovin papel la t'apj, niná papel mo'ó tjowelepj tsjan 'ücj la mijicj tsji' la tjajay na. Pjaní pjaní la t'apj yupj. Nin jawas nin la tjajay na, pjaní way la t'ya Zacarías. Jupj papel tjevele jupj Dios wo mo'ó ca mim, ts'ülüc' 'üsüs cjumsu ca mü'ümüs ne'aj. Lovin nin la tjajay Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías ts'ülüc' 'yǘmatsja na, gente pajal pülücj pje'á tjelejen̈ ne'aj. Dios lal la montsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wa mo'ó Zacarías ton̈ca nt'a ángel lay tepyala jupj nt'a. Dios jas tjejyama ángel niná la veles Zacarías lal. Mesa Zacarías 'yüma nt'a, li'inyampe ton̈ca ángel. ");
INSERT INTO jicNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías ma seletsja tsjan la qjuijis ángel tjinyuca na. Pajal lecj tjeyá jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mpes ángel tjevele jupj lal: —Po ma lecj tjeyá. Dios lal le montsja jupj ca mya 'as. Jets'om Elisabet yom tsjicj ca popa nsem. Tjac' na, Juan ló nt'as jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pajal ca 'ücj jyas nsem jipj; gente pülücj 'ücj jisas nsem wa jetjam tjac' mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cupj qjuis Jepa Dios ca mveles jupj püné. Lovin uva 'üsǘ ma ca mü'üm jupj, guaro ma wa ca mü'üm. Ma tjemya'na na custjay, Dios Cjües jupj jos mo'o ca mpü'üm. Dios Cjües jyü'ta jin ca la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nin mpes jetjam vele na Dios po'ó, israelpan pülücj po ca jisas nsem yupj jis Jepa Dios, ne ca cus ncon̈cocj jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ángel tjevele wa: —Jetjam ca mwalá mim qjuis Jepa Dios jama nt'a. 'Ücj ca 'üsüs la mijis Dios mpes, Elías jinwá. Püna Dios Cjües cus tjep'ya'sa Elías, mpes pajal 'üsüs la tjiji. Nin p'iyá ca nsem jetjam lal. Jetjam ca sin mü'üsüs lis mijis, mpes jis papay ca quelel lis mijicj sejatjampan niswá. Nin mpes wa malala lajay ca cü'ü'süs 'ots'ipj. Yupj ne ma lajaytsja Dios tjevelá püna p'in. 'Üsüs witjacj jinwá ca yola nsem yupj quinam. Jetjam ca nin la mijis. Mpes qjuis Jepa Dios jac' na, nepénowa 'ücj ca cus ncon̈cocj jupj —nin tjevele ángel Zacarías lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías tjevele ángel lal: —Pajal co'müy napj. Nats'om co'müy wa jupj. ¿'Onin ne ca jus nley napj ncu t'üc' velen jipj? ");
INSERT INTO jicNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángel wola tjevele: —Gabriel napj. Lovin Dios wolap'a'a jüs napj, nin mpes ca jus nlayen t'üc' velé napj. Jupj nin tjejyama jipj nt'a. Nin tjejyama la veles 'üsüs ca mya palas. ");
INSERT INTO jicNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Newa jipj ma tepyon napj tjevelé, mpes lyájasa ca nsem jipj quinam. Ma ca polel mvelen nsem jipj. Napj tjevelé jin tepyala na, niswa ca 'ücj mvelen nsem. Dios jos na ca pjü mpalas napj tjevelé jin —nin tjevele ángel jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La p'a witjacj pje'á la tjunuc Dios wo nt'a. La tjunuctsja Zacarías pje'á ncalas. Po yólatsja ma pje'á tjac' mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tjac' na, ma polel véletsja jupj. Nin mpes yupj jus nlaytsja Dios la tjiji Zacarías 'ücj tjinyuca Dios jas tji'yüsa la tjiji, Dios wo mo'ó tón̈catsja na. Jus nlaytsja nin mpes ma polel véletsja. Newa ma polel tjevele, mpes lovin la seña tjevele p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","P'a jawas Zacarías t'üc' tsji' la tjiji ne'aj. Wo nt'a tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","T'üc' tepyala ángel tjevelá. Jats'om jupj ts'uyupj jana tepyala jupj, mpes mes cínquiya wo nt'a tjá'asa. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nejepa Dios ncapj tjep'ya'sa. Malala ntepalá po jólatsja jupj. Püna la p'a wa yólatsja malala napj, tsjicj cjuwatsja mpes. Ma ca nin yola quinam.” ");
INSERT INTO jicNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet mes séisiya way tjá'asa na, Dios jas tjejyama jupj ángel Nazaret nt'a, Galilea mpe se jütütj nt'a. Ángel jupj p'iyatsja ni, Gabriel ló. ");
INSERT INTO jicNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios jas tjejyama jupj la veles tsjücjüim lal. Tsjücjüim María lotsja. Lovin ma yom lal tjuwine jupj. Ma tjowaya custjay. Tjevele p'a jawas José lal ca mwayim. José David popa p'iyá, püs naya tüpü'ü jupj. (David israelpan jis jépatsja pajal püna.) ");
INSERT INTO jicNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","María nt'a tjac' jupj, ángel. Tjevele: —¡'Ücj jyas t'as! Po 'üsüs la tjiji Dios jipj mpes, jupj ne jipj Jepa Püné. Cyapj cyon̈ca jupj. Más 'üsüs 'e tepalá pjü nequem jis tepyala lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ángel vele tjapjaca na, po lapj nyuca jólatsja María. Ma seletsja jupj tsjan mpes nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mpes ángel tjevele jupj lal: —¡Po ma lecj tjeyá! Dios po 'üsüs way liji jipj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Way tsjicj ca ma'ajam jipj. Yom tsjicj ca ma'nun. Jesús ló ca la nt'an jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Püné nsem jupj. Dios Jatjam ló nsem jupj. Jupj David popa p'iyá, püs naya mpü'üm. David tjijyü'ta nt'a ca müjü'tüs jupj. Qjuis Jepa Dios ca ma'ayas müjü'tüs. ");
INSERT INTO jicNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israelpan ca jis müjü'tüs lovin. Lovin ca Jepa nsem jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María tjevele ángel lal: —¿'Onin ne nin mpalas? Mvayum tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángel wola tjevele: —Dios Cjües ncuwim jipj nt'a, ca cyapj mp'a'sas. Dios más püné pjü jis lal. Jupj 'üsüs liji gente p'in ma polel lajay jin. P'a nequem jin tulucj ca nsem jipj lal. Jupj püné mpes ca nin nsem la p'in. Jipj lejay mpes tulucj ca nin nsem. Mpes jipj tsjicj Dios juts'a'á ca nsem. Dios Jatjam ló ca nsem jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","”Jemapj Elisabet yom tsjicj ca ma'nus wa jupj. Co'müy way jupj, mop'in nin. La p'a javeleptsja ma tsjicj way já'asa jupj lovin; nin tulucj jupj quinam. Mes séisiya nas tsjicj já'asa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cjuwá tsjan ma 'ücj la qjuijis Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María wola tjevele: —Mwü. Dios ni jütüta. Jipj tjevelen jin ca nsem napj lal. T'üc' tjevele na tjemey ángel jupj mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'Ístaway María 'ücj la tjiji quelel jámatsja mpes, ne len̈ way joc' mo'o tjemey pülücj patja nt'a, Judea mo'ó. María tjemey tjinyuca ncu t'üc' tjevele ángel jomapj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarías wo wama tjemey. Süs wa la tjiji jomapj Elisabet lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jupj María vele tjapjaca na, way tsjicj Elisabet col mo'o já'asa ntolo jupj. Dios Cjües tjac' wa Elisabet nt'a, cus tjep'ya'sa t'üc' la veles Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'Ücj jostsja mpes yümücj tjevele niná: —Dios más 'ücj jyas la tjiji pjü nequem jis lal. Jipj tsjicj way cyol mo'o já'asa 'ücj jos la tjiji wa Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pajal 'üsüs ntepalá, napj Nejepa jamay la nuc tjac' napj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nin mpes jipj napj lal tjevelen na, tsjicj ncol mo'o já'asa ntolo jupj, 'ücj jostsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jipj tepyon ángel tjevelá Dios mpes, jupj ne cupj qjuis Jepa Püné. Tepyon t'üc' ca mpalas jupj tjevelá, mpes 'ücj jyas la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María wola tjevele: “Napj nola pajal püné way napj Nejepa Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Po 'ücj najas Dios mpes. Jupj ca la mijis napj 'ücj ca mpü'üs jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jomozo way napj. Po jólatsja jupj pajal tsjicj way napj, püné tulucj. 'Üsüs la tjiji napj mpes. Nin mpes pjü way locopyaya patja ca mvelecj Dios 'ücj najas la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pajal jas tjiyocj Dios. Pajal 'üsüs la tjiji napj mpes, jupj pajal püné mpes. Ncapj tjep'ya'sa. Lovin ma malala nyuca liji jupj. Lovin 'üsüs way p'in liji. ");
INSERT INTO jicNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jupj quelel jis capj p'ya'sa jupj lal japon. Püna tapatja jilal nin p'iyá la tjiji, p'a jawas ca mpatjam jilal nin p'iyá ca la mijis. Yupj salejepj Dios ca jis capj ntülüs malala lajay. ");
INSERT INTO jicNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jupj pajal 'üsüs la tjiji, jupj pajal jas tjiyocj mpes. Na'aj la tecyoye püné jin yola witjacj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jepapan nepénowa tsjicj way yupj la tjiji jupj, mpes ma jajütütj jis tepyala. P'a witjacj tsjicj waytsja yupj yas nam, püné way yupj la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nepénowa vecj cya'lin̈, mpes Dios se 'aya tsjan 'üsüs. Jis col pit'a se palá yupj. P'a wa pülücj jatatj, mpes 'aya secj sin jyama. ");
INSERT INTO jicNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jis capj tjep'ya'sa israelpan, yupj ne jupj jomozopan. Lovin ma jo' pe'e jupj tjevelá yupj jis lal pajal püna. Tjevele ca jis capj mp'a'sas, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nin tjevele jupj püna tapatja jis lal, cupj ne yupj sin popa. Nin tjevele Abraham lal, jupj ts'uyupj sin popa locopyaya tapatja jis lal 'ots'ipj”, nin tjevele María. ");
INSERT INTO jicNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mes cont'e ne'aj tüpü'ü María Elisabet wo nt'a. Locopyaya jupj wo nt'a tjemey niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pülücj tjejyawca na Elisabet quelel myá'natsja tsjicj way, ne yom tsjicj tjemya'na jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne'aj patja 'ücj jisastsja pajal Elisabet 'ücj jostsja mpes. Nin p'iyá 'ücj jisastsja wa jupj jüpülücpan. Jus nlay Dios pajal cus tjep'ya'sa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tsjicj ts'ac' ocho tepyala na, tjiquil cus la con̈ yom tsjicj, pjoloc' tsjicj t'asiyú t'ü na. Dios Popel jis tjijyü'ta israelpan ca nin la mijicj niyom tsjictjacj jis lal ts'ac' ocho jis tepyala na, ne nin la tjajay lovin. Yupj quelel tsjicj ló la t'apj 'ots'ipj. Zacarías ló quelel la t'apj yupj tsjicj mpes, popay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jamay ma jostsja nin ló nsem. Jis wala tjevele: —Nin tulucj. Juan ló nsem jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yupj tjowelepj jupj lal: —¿Tsjan mpes nin? Nin jis lá tulucj jipj pyülücpan pjü, jipj vyasaspan ma nin jis lá way yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mpes la seña lal tjowelepj tsjicj popay lal. La tjü'üy 'oyn jostsja ló la t'apj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mpes tabla tsjicj la tjemyona la pac. Tepyaca: “Juan ló jupj”. Ma jus nlaytsja tsjan mpes nin la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarías nin la tjiji na, 'ücj vele tepyala jupj niswá, ne 'üsüs pjac tjevele jupj Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mpes pjü ne'aj patja pajal yólatsja Dios pajal 'üsüs la tjiji mpes; yupj yólatsja pajal püné Dios. Pjü niná tepyalá pjü yuwá tjowelepj joc' mo'ó Judea nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Niná tjepjyacan̈ na, po yólatsja tsjan mpes nin tepyala. Yupj tjowelepj: “Püné ca nsem jupj ca nacj. Pajal 'üsüs ca la mijis jupj ca nacj.” T'üc' way qjuis Jepa Dios yom tsjicj niná cus tecyon̈ca, cus tjep'ya'sa pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías lotsja tsjicj popay. Dios Cjües tjac' Zacarías nt'a, cus tjep'ya'sa t'üc' la veles Dios mpes. Mpes 'ücj Dios mpes tjevele jupj. Niná tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“'Üsüs pjac tjowelé qjuis Jepa Dios po'ó. Israelpan jis Dios jupj. Cupj ne jupj si jütüta sin popé. Malálatsja cupj püna p'in, jupj juts'a'á tuluctsja, malala la tjijicj mpes. Perdonar la qjuis tjiji quinam, ne ca 'üsüs nsem cupj jupj lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","David jupj jomozo waytsja püná. David ncupj qjuis jepa waytsja pajal püna. David popa pjaní qjuis tje'yaya Dios quinam. Pajal jas tjiyocj jupj. Jupj qjuis capj p'ya'sa, mpes 'ücj ca mpatjaquecj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pajal püna profetapan tjowelepj ca nin mpalas. Yupj Dios juts'a'atsja. Dios tjevele p'iyá tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tjowelepj jupj ca qjuis capj mp'a'sas, qjuis enemigopan ma malala la qjuis mijicj ncupj. P'a witjacj ma quelel la qjuesejay, ma wa ca polel malala la qjuis mijicj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Niná Dios tjevelá püna tapatja jis lal, cupj ne yupj sin popa p'iyá. Tjevele ca qjuis capj mp'a'sas, malala qjuesé palá na. Ma jo' tepe'e tjevelá. 'Üsüs way tjevelá, t'üc' way 'üsüs ca la mijis cupj mpes, jupj tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nin tjevele Abraham lal, jupj ne püna tüpü'á. T'üc' ca nin la mijis, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jupj ca qjuis manus qjuis enemigopan mpe, ma ca malala qjuis mpalas. Nin mpes 'ücj ca tsji' la mijicj cupj jupj mpes. Ma ca lecj meyacj. ");
INSERT INTO jicNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dios jos jin ca la mijicj cupj. Lovin 'üsüs ca la mijicj, pyatjaquecj na. Jupj qjuiyus nyuca lovin. Pjü niná 'üsüs way ca la mijis Dios, jupj quelel la qjuisiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Natjam tsjicj, Dios ca mveles jipj jupj profeta. Jipj ca mvelen jupj mpes. Pajal püné jupj pjü jis lal. Jupj wolap'a'a ca mim, 'ücj la mijin jupj ca mim nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jipj ca sin mü'üsüs la mijin israelpan 'onin ne 'ücj mpatjam Dios lal. Jupj ca perdonar lis mijis yupj malala nyuca la tjajay, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Qjuis Dios po jola cupj mpes, malala qjuesé palá mpes, ne pjaní ca jas majamas qjuis capj la p'acj. Lots'ac' jinwá jupj. Dios pü'ü mpe ca ncuwim cupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Gente te ton̈ca nt'a patja malala nyuca lajay mpes. Nca'lin̈ ca yupj, mpes lacj jeyapj. Yom niná Dios se jamá, jupj ca sin 'yüsa lis mijis yupj. Jis capj jyawca jinwá ca nsem yupj jis lal. Ca qjuisin 'yüsa la mijis 'onin ne 'üsüs la püt'üs Dios lal”, nin tjevele Zacarías. ");
INSERT INTO jicNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Püs tepyala na Zacarías jatjam t'yüna jupj, püné tepyala. Yom 'üsüs tepyala jupj. 'Üsüs jólatsja jupj Dios jos jinwá. Wa cjuwá nt'a pǘ'ütsja lovin, israelpan jis walap'a'a tjac' nas. ");
INSERT INTO jicNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jepa püné jis tjijyü'ta israelpan. Israelpan popa tuluctsja jupj. Augusto lotsja jupj. Tjijyü'ta pjü way jupj si jütüta sin popé ca mal jis lá jis la pac. ");
INSERT INTO jicNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lovin ma nin la tjajay yas nam ne'aj; mwalá way nin la tjajay quinam. (Nin la tjajay na, Cirenio jepa auxiliar waytsja Siria mo'ó.) ");
INSERT INTO jicNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mpes pjü tjil yupj jis papay, sejamay püna tapatja nt'a, jis lá jis la pac. ");
INSERT INTO jicNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José tjemey wa. Nazaret nepénowa patja mpe tjemey. Galilea mpe jis tjijyü'ta ne'aj Nazaret nt'a. Judea mo'o tjemey jupj, Belén nt'a tjemey, nepénowa patja nt'a. Belén nt'a tüpü'ü israelpan jis jepa David püná. José David popa p'iyatsja, püs naya tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María lal tjemey jis lá jis la pac ne'aj. María tjevele ca mwayim jupj lal p'a jawasa. Way tsjicj tjá'asa jupj, María, José popa tulucj. Dios Cjües 'üsüs la tjiji mpes way já'asatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ne'aj tapatja na, Belén nt'a, way tsjicj quelel myá'natsja María, ");
INSERT INTO jicNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ne jatjam mwalá tjemya'na jupj. Pülül mpes jas tjivyü'ünǘ tsjiquis, ne caja mo'o tje'yonsa jupj, caja niná tsjutsj mpestsja, vaca ne'aj jalatsja mpes. Pensión nt'a ma polel tjijinan̈ yupj, María, José, pajal pülücj tjiquil mpes. Nin mpes animal pülücj sa manun nt'a tjijinan̈ yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén ne'aj p'in tapatja wa niyom p'a wa. Oveja jajamaptsja tsjutsj lejen̈ nt'a, püste naya. ");
INSERT INTO jicNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Len̈ way ángel pjaní lay tepyala yupj nt'a. Qjuis Jepa Dios jomozo way jupj. Nin mpes yupj casá po 'üsüs way tjejyawca, Dios pajal jyawca mpes. Pajal lacj tjeyapj noyomes. ");
INSERT INTO jicNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mpes ángel jis wala tjevele: “Po ma locj tjeyá nun. Napj tjacuwis la veles pajal 'üsüs tepyala quinam. Gente pajal 'ücj jisas nsem napj velé mpes. Po 'üsüs ca nsem pjü israelpan mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tsjicj tjemya'na yacjaj, David püna tüpü'ü nt'a. Tsjicj niná ca la mijis nun 'ücj ca mpatjaqué Dios lal. Qjuis Jepa jupj. Cristo jupj. Jupj ne Jepa Püné Dios tjevele ca jas majamas nucopj lo p'acj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tsjan mpes nun ca jus nlayé napj t'üc' velé: tsjicj jas tjüwü'ün ca nucú caja mo'ó, vaca jalá nt'a.” ");
INSERT INTO jicNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Len̈ way pülücj lay jis tepyala ángel militarpan, nayapé tjiquil. Pajal pülücj waytsja yupj. Ángel mwalá lal tjelejen̈ yupj, tjowelepj pajal 'üsüs way Dios. Ninana tjowelepj: ");
INSERT INTO jicNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Qjuisas 'üsüs mvelecj Dios po'ó jupj pü'ü nt'a. Dios 'ücj jos gente nepénowa jis lal, mpes qjuisas wa yupj ma yola pjü mpes.” ");
INSERT INTO jicNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelpan pjü tsjun po'o tjil niswá. Tjil na, oveja jajamapj tjowelepj: “Mas Belén nt'a. Mas nucum tsjan tepyalá no'oj, tsjan niná Dios qjuisin tji'yüsa la tjiji angelpan popem, Dios ne cupj qjuis Jepa Püné.” ");
INSERT INTO jicNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mpes len̈ way tjil. Yus tjunuc María José lal. Tsjicj tjunuc wa, caja mo'o tüpü'ü, caja niná tsjutsj mpestsja, vaca ne'aj jalatsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yus tjunuc na, tjil, pjü jis lal tjowelepj angelpan tjowelepj tsjicj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pjü tjepjyacan̈ niyom nenem tjowelepj, pjü yólatsja yupj tjowelepj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María lovin ma jo' tepe'e pjü way niná. Lovin 'ücj jos jola tepyala jupj niná. ");
INSERT INTO jicNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oveja jajamapj tjil püna tjatja nt'a. Pjü tjepjyacan̈ mpes, pjü tjunuc mpes wa 'üsüs tjowelepj Dios po'ó. Tjowelepj pajal püné way Dios, pajal 'üsüs way jupj. Pjü tepyala ángel tjevele jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tsjicj ts'ac' ocho tepyala na, jupj pjoloc' tsjicj way t'asiyú t'ü yupj. Dios Popel jis tjijyü'ta israelpan nin la mijicj niyom tsjictjacj ts'ac' ocho se palá na, mpes nin la tjajay. Nin jawas Jesús ló la t'apj yupj, ángel tjevele jin. Tsjicj cjuwatsja na ángel tjevele ca nin ló la nt'acj jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","P'a jawas tjil yupj, María José lal. Tsjicj tucuman Jerusalén nt'a, Dios wolap'a'a la 'onsos Jesús. Püna Moisés tjijyü'ta quepj ts'ac' cuarenta ma polel jama Dios wo nt'a, tsjicj tjemya'na na. Ts'ac' cuarenta tepyala na, ca mim, ma'ayas Dios mpes. Nin la tjiji na, salá jinwá nsem quepan Dios lal. Mpes ts'ac' cuarenta t'üc' tepyala na, tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dios wo nt'a tucuman tsjiquis, Dios Popel tjevele mpes. Tjevele: “Mwalá popa yom way, Dios juts'a'á nsem jupj”. ");
INSERT INTO jicNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Animal quelel ja'ayaptsja Dios mpes. Dios Popel tjijyü'ta: “Sipipj, castucú tsjictjacj 'ücj wa ca ma'ayacj lo 'ünan Dios mpes”. Nin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ne'aj Jerusalén nt'a yom tüpü'ü Simeón ló. 'Üsüs waytsja jupj Dios lal, 'üsüs cus tecyon̈ca Dios. Po la tjinyuca Dios ca jas majamas Yom pjaní yupj nt'a jis capj la p'acj israelpan. Dios Cjües Simeón cus tecyon̈ca. ");
INSERT INTO jicNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Dios Cjües jas tji'yüsa la tjiji jupj la müjüsüm ca niná Jepa Püné Dios se jamatsja. Ma ca mpa'is jupj, ma jus tjinyuca na p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nin jawas Dios wo nt'a tjemey jupj; Dios Cjües tjijyü'ta ca nin la mijis. Ne'aj Jesús jamay, popay tucuman tsjiquis. Ne'aj tjil, Dios Popel tjijyü'ta jin la mijicj tsjicj mpes. Ne'aj tjatja na, ");
INSERT INTO jicNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón tsjicj tjemya'na. 'Üsüs tjevele Dios po'ó. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Napj Nejepa, napj jipj myozo, 'ücj jipj nt'a jum quinam. Jipj tjevelen jin la tjejay jipj, mpes ma nola quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nan mpes jus tjinyuc niná jipj jas tjejyam qjuis capj la p'acj, 'ücj qjuis la püt'üs jipj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pjü jis walap'a'a 'ücj la tjejay niná. ");
INSERT INTO jicNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jaw jinwá ca nsem jupj israelpan tulucj jilal. Sin mü'üsüs la mijis ca Dios po'ó. Más püné ca la mijis ncupj, israelpan, cupj ne jipj jits'a'á”, nin tjevele Simeón Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tsjicj popay, jamay yólatsja Simeón pajal 'üsüs tjevele mpes jupj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón Dios lal la tjemyona wa jupj ca 'üsüs lis mijis conas jis lal. Jamay lal tjevele wa: “Dios tjijyü'ta malala ca jis mpalas israelpan pülücj tsjicj niná mpes. Tjijyü'ta wa tsjicj niná ca jis capj mp'a'sas israelpan p'a wa, mpes pülücj ca cus ncon̈cocj Dios. Dios jas tjejyama tsjicj niná sin la 'üsüs lis mijis Dios jos. Mop'in nepénowa ca malala mvelecj jupj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nin mpes p'a witjacj ca jus nlayecj tsjan yola pülücj witjacj. Jipj 'aplijila ca nsem pajal, jyas mo'o tsjyaca jinwá. Nin ca mpalas tsjicj niná mpes”, nin tjevele Simeón Jesús jamay lal. ");
INSERT INTO jicNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ne'aj Dios wo nt'a quepj p'a wa tjá'asa, Ana ló jupj, Fanuel jucucus waytsja. Israelpan popa watsja jupj. Ana profétatsja jupj, Dios mpes tjevele. Pajal co'müytsja quinam. Tsjücjüim waytsja na, tjowaya jupj. Año siete tüpü'ü voyum lal, ");
INSERT INTO jicNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","locopyaya tepe'e voyum. Voyum tepe'e na, jusapj pǘ'ütsja jupj. Año ochenta y cuatro tyá'atsja jupj quinam. Lovin ma tjemey Dios wo mpe. Jólatsja Dios püné. Jaw na, püste na véletsja Dios lal. La pülücj laja secj la tjemyona Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana yupj nt'a tjac' quinam. Tjevele tjüwüi'i Dios lal, tsjicj jas tjejyama mpes. Locopyaya Ana p'a jis lal tjevele lovin, tsjicj po'ó. Tsjay püs way la tjunuc yom pjaní ncuwim Jerusalén mo'ó, ca jis capj mp'a'sas, yupj jis enemigopan ma ca jis müjü'tücj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Popay, jamay, pjü la tjajay Dios Popel tjijyü'ta jin. Pjü la tjajay na, niswa tjil yupj püna tapatja nt'a. Nazaret ló ne'aj, Galilea se jütütj mpe. Tsjicj lal tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","T'yüna jupj, tsjiquis. 'Üsüs jólatsja jupj Dios jos jinwá. Po 'üsüs jas tji'yüsa jupj. Dios pajal 'üsüs la tjiji jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pjü año Jerusalén nt'a tjil popay, jamay, fiesta mpes. “Dios Qjuis Capa Nipj Tjemey” lotsja fiesta niná. ");
INSERT INTO jicNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús año doce tyá'atsja na, tjil wa yupj Jerusalén nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiesta tecyawaja na, jamay, popay tjil jümücj po'ó, jis wa nt'a jiltsja niswá. Mop'in ne'aj tüpü'ü Jesús, ma tjemey. Jamay, popay, ma salejeptsja ma tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yupj yólatsja la p'a jis lal tjemey jupj. Pülücj 'a mulú jiltsja jis wa nt'a, mpes nin. Ts'ac' pjaní ma jus tjunuc jümücj nt'a, mpes la tapal jupj yupj sejamicapan tjatja nt'a, jis pülücpan tjatja nt'a wa. ");
INSERT INTO jicNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lovin ma jus tjunuc, mpes tjil niswá Jerusalén nt'a, newa la tapal jupj ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ts'ac' cont'e tepyala na, Dios wo nt'a la nyüjüsün̈. Sin 'yüsa lajay jilal tjá'asa. Tjapjaca tjowelepj, jis la tji'yüya 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tjepjyacan̈ na jupj tjevelá, pjü way yólatsja 'üsüs way jas tji'yüsa. Yólatsja wa 'üsüs jis wala tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Popay, jamay jus tjunuc na, ma salejeptsja tsjan mpes ne'aj tjá'asa jupj. Jamay tjevele jupj lal: —Natjam, po lecj tjeyacj jipj mpes, pajal la tepyalacj. ¿Tsjan mpes nin la tjejay cupj qjuis lal? ");
INSERT INTO jicNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús jis wala tjevele: —¿Tsjan mpes p'a nt'a la tapalá napj? Dios napj Mpapay. Jupj wo niná. ¿Ncu ma jus nlayé más 'ücj qui'á 'os napj? ");
INSERT INTO jicNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yupj ma sin tji'yüsa tsjan mpes nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nazaret nt'a tjemey Jesús niswá yupj jis lal. Pjü tjüjütütj la tjiji jupj. Jupj jamay jola tepyala pjü tepyalá. 'Ücj jos jola tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús más 'üsüs jas tji'yüsa lovin. T'yüna wa jupj. Dios más 'ücj jos tepyala jupj lal lovin. Nin p'iyá gente más 'ücj jisas jis tepyala wa jupj lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","(Locopyaya, Jesús püné tepyala na, gente sin 'yüsa la síjitsja Dios po'ó. Custjay ma nin la tjiji na p'in, Juan wínetsja, véletsja Dios mpes. Dios jas tji'yüsa la tjiji tsjan la veles. Juan niná Zacarías jatjam p'iyatsja jupj.) Juan wa cjuwá nt'a pǘ'ütsja. Jupj quelel véletsja na Dios mpes, jepa noypan israelpan tuluctsja. Tiberio jepa más püné waytsja ne'aj. Poncio Pilato jepa auxiliar waytsja Judea mo'ó. Herodes jepa waytsja Galilea mo'ó. Herodes jüpülücj Felipe jepa waytsja Iturea mo'ó, Traconite mo'ó 'ots'ipj. Lisanias jepa waytsja Abilinia mo'ó. Israelpan sin popa nepénowa jepa jatja watsja yupj. Anás, Caifás lal, sacerdotepan más püné witjacj waytsja yupj. Tiberio año quince nas tjijyü'ta jupj, Juan quelel véletsja na Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan jun ta'á tjemey 'üsǘ püné la nt'a. Jordán lotsja 'üsǘ püné ne'aj. Ne'aj gente jis walap'a'a tjevele más 'ücj 'aplijila nsem yupj, malala nyuca la tjajay mpes. Más 'ücj yupj ca Dios jos jin la mijicj quinam, tjevele. Juan tjevele jupj ca 'üsüma jis mpa'tas, mpes bautizar jis mpalas ca. Mpes pjü ca jus nlayecj yupj quelel 'üsüs la mijicj quinam, Dios jos jin. Nin mpes Dios ma ca jola nsem yupj püna malala nyuca la tjajay mpes. Nin tjevele Juan yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías Juan po'ó tepyaca püná. Profeta waytsja jupj, Isaías. Tepyaca popel mo'ó Dios tjevelá. Nin tepyaca jupj Juan po'ó: “Yom niná wa cjuwá nt'a ca mim. Pajal ca quelel mveles gente jilal napj mpes. Mpes yümücj ca mveles: ‘Qjuis Jepa Püné ca ncuwim. Nujola t'as ca nin la müjí quinam jupj jos jin. Malala nujola nun, jümücj la lu'ulú jinwá. Po ma malala nujola t'as quinam. 'Üsüs nujola t'as qjuis Jepa Püné jos jinwá’, nin ca mveles jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","‘Nujisas jümücj viyavin, palavin jinwá quinam Dios lal. Ts'entuna nt'a tipit'a la müjí quinam. Joc' witjacj, neven 'ots'ipj, yumal la müjí quinam. La lu'ulú nt'a la t'atsj la müjí. La toc nt'a jüljül la müjí. Ca jümücj 'üsüs nsem qjuis Jepa Püné mpes. Nin p'iyá la müjí nujisas mo'ó. Qjuis Jepa Püné len̈ way ncuwim. Ma malala nujola t'as. Dios jola jin nujola t'as. ");
INSERT INTO jicNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nin la tjüjí na, gente pjü way ca jus nlayecj Dios liji yupj 'ücj ca mpatjam jupj lal’ ”, nin tepyaca Isaías. ");
INSERT INTO jicNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gente pajal pülücj tjiquil Juan nt'a. Jisastsja jupj ca bautizar lis mijis. Jis wala tjevele: —Nun nin p'iyá latsj jinwá. Nun solejé Dios po ma jos gente malala lajay. Len̈ way ca jis capj ntülüs. Nin mpes tjuculá nun napj nt'a, napj ca bautizar la numejay. Nujola nun nin lojí mpes, jupj ma ca nucopj ntülüs. T'üc' tulucj. Dios selé nun newa ma quelel lojí jupj jos jin. ");
INSERT INTO jicNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","T'üc' way 'aplijila t'as nun, malala la tjüjí mpes, ne ca 'üsüs la müjí quinam Dios jos jin. Po ma nujola t'as nun pajal 'üsüs, nun judiopan mpes. Ma nujola t'as nun pajal 'üsüs, nun Abraham püna tüpü'ü popa mpes. T'üc' tulucj. Dios ca 'ücj la qjuijis niná pwen Abraham ts'uyupj ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios pajal len̈ way ca jis capj ntülüs malala lajay. Yupj ma 'üsüs lajay, jupj ca jis capj ntülüs yupj pjü way. Yom jupj sine ma vyala jinwá ca la mijis Dios. Jupj sine ma vyala, jyo'o, 'awa mo'o ts'iyá. Nin ca la mijis Dios malala lajay jis lal. —Nin tjevele Juan yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mpes yupj pajal pülücj la tjü'üy jupj lal: —¿Tsjan más 'ücj la qjuijicj cupj? ");
INSERT INTO jicNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan jis wala tjevele: —Po ma la müjí püna la tjüjí jin. Jipj jin quip mat'e tyatj, pjaní ca ma'ayan jas quip cjuwá. Ve tyatj na, nin p'iyá ca la mijin. ");
INSERT INTO jicNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nenéyawa niyom impuesto jat'anquepj tjiquil wa. Jisastsja Juan ca bautizar lis mijis. Juan lal tjowelepj: —Jipj qjuisin 'yüsa lejay Dios mpes. Qjuis wala mvelen tsjan jos Dios ca cupj la qjuijicj. ");
INSERT INTO jicNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jis wala tjevele: —Püna p'in t'emel más pülücj nt'a nun jepa tjijyü'ta lal, niná tüpwe'qué nun. Ninana ma ca la müjí quinam. Jepa tjijyü'ta jinwá p'in ca nta'é jupj mpes. Más pülücj ma ca nta'é. ");
INSERT INTO jicNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Militarpan nepenowá tjiquil wa, la tjü'üy wa: —¿Tsjan jos Dios la qjuijicj cupj? Juan jis wala tjevele: —Malala nyuca lojitsja püná, ma nin la müjí quinam. Po ma tüpwe'qué, la p'a lacj jeyapj mpes nun jilal. Po ma ca mvelé yupj malala la tjajay, yupj ma malala la tjajay nam. 'Ücj nujisas t'as t'emel tsji' lojí jaylacj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Judiopan la nuctsja Dios ca jas majamas Yom pjaní jis capj la p'acj. Püna Dios tjevele ca nin la mijis jupj. Ne'aj tapatja nin yólatsja Juan p'iyá niná Yomen Dios se jamá. ");
INSERT INTO jicNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mpes Juan jis wala tjevele pjü jis lal: —Nam 'a niná Yomen tulucj. Napj bautizar la nusejay 'üsǘ lal p'in. P'a wa ncuwim más püné napj lal. Nam 'a pajal tsjicj way jupj lal. Po 'üsüs napj lal jupj mpes tsji' lejay. Napj jupj caite syoc la p'in, 'ücj napj lal. Püné jupj pajal. Nun nepénowa nasa quelel lojí Dios jos jin. Jupj ca nu ma'ayas Dios Cjües. Nun nepénowa newa ma quelel lojí Dios jos jin. Jupj ca nucopj ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","”Len̈ way ca nin la mijis. Ca 'üsüs la mijis jupj 'amá nt'a, ma ca malala mpü'üm ne'aj. Ca ne'aj mo'onsos 'üsüs witjacj, ma ca malala jis mpalas. Pjü malala ca mü'ümüs; jupj 'yüma na, len̈ pjacj se wat'ata jupj 'owus —nin tjevele Juan yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan p'a wa nin p'iyá tjevele wa judiopan jis lal; pülücj tjevele. Jupj tjevele más 'ücj yupj más 'üsüs ca la mijicj quinam Dios jos jin. Jis walap'a'a tjevele Dios pajal 'üsüs la tjiji yupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan cus tjeve'le yupj jis jepa ne'aj, jepa niná Herodes ló. Cus tjeve'le vosas lal tjowaya mpes, vosas Herodías lotsja. Pjü way Herodes malala nyuca la tjiji mpes wa cus tjeve'le jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes ma jostsja Juan tjevelá. Nin mpes p'a wa malala la tjiji: cawilta mo'o tje'yonsa Juan. ");
INSERT INTO jicNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Custjay cawilta mo'o 'onsa secj p'in, Juan bautizar la tjiji Jesús. La p'a pülücj bautizar lis tjiji na, Juan bautizar la tjiji wa Jesús. Bautizar tepyala na, Jesús Dios lal tjevele. Dios lal tjevele na, tsjun po'o tsjicj way la tücüeme, jun cjol tepyala. ");
INSERT INTO jicNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nepé Dios Cjües palá tjac' Jesús jay nt'a la 'osos. Sipipj jinwá justa lay tepyala jupj. Tsjun po'o nepé vele pjactsja: “Jipj napj Natjam. Quelel la 'ejay pajal napj. Pajal 'üsüs najas jipj lal.” ");
INSERT INTO jicNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús quelel sin mü'üsüs la mijis na, nasa way año tréinteya tyá'atsja jupj. Gente yólatsja jupj ne José jatjam. José niná Elí jatjam waytsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat jatjam waytsja; Matat Leví jatjam waytsja; Leví Melqui jatjam waytsja; Melqui Jana jatjam waytsja; Jana José jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías jatjam waytsja; Matatías Amós jatjam waytsja; Amós Nahúm jatjam waytsja; Nahúm Esli jatjam waytsja; Esli Nagai jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat jatjam waytsja; Maat Matatías jatjam waytsja; Matatías Semei jatjam waytsja; Semei José jatjam waytsja; José Judá jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joan'an jatjam waytsja; Joan'an Resa jatjam waytsja; Resa Zorobabel jatjam waytsja; Zorobabel Salatiel jatjam waytsja; Salatiel Neri jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui jatjam waytsja; Melqui Adi jatjam waytsja; Adi Cosam jatjam waytsja; Cosam Elmodam jatjam waytsja; Elmodam Er jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué jatjam waytsja; Josué Eliezer jatjam waytsja; Eliezer Jorim jatjam waytsja; Jorim Matat jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví jatjam waytsja; Leví Simeón jatjam waytsja; Simeón Judá jatjam waytsja; Judá José jatjam waytsja; José Jonán jatjam waytsja; Jonán Eliaquim jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea jatjam waytsja; Melea Mainán jatjam waytsja; Mainán Matata jatjam waytsja; Matata Natán jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David jatjam waytsja; David Isaí jatjam waytsja; Isaí Obed jatjam waytsja; Obed Booz jatjam waytsja; Booz Salmón jatjam waytsja; Salmón Naasón jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab jatjam waytsja; Aminadab Aram jatjam waytsja; Aram Esrom jatjam waytsja; Esrom Fares jatjam waytsja; Fares Judá jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob jatjam waytsja; Jacob Isaac jatjam waytsja; Isaac Abraham jatjam waytsja; Abraham Taré jatjam waytsja; Taré Nacor jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug jatjam waytsja; Serug Ragau jatjam waytsja; Ragau Peleg jatjam waytsja; Peleg Heber jatjam waytsja; Heber Sala jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán jatjam waytsja; Cainán Arfaxad jatjam waytsja; Arfaxad Sem jatjam waytsja; Sem Noé jatjam waytsja; Noé Lamec jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén jatjam waytsja; Matusalén Enoc jatjam waytsja; Enoc Jared jatjam waytsja; Jared Mahalaleel jatjam waytsja; Mahalaleel Cainán jatjam waytsja; ");
INSERT INTO jicNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós jatjam waytsja; Enós Set jatjam waytsja; Set Adán jatjam waytsja, Dios p'iyá Adán la tjiji jupj. Nintsja püna tapatja jis lá, José ne yupj popa p'iyá, püs naya tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","'Üsǘ püné la nt'a tjá'asa Jesús. Niná 'üsǘ Jordán ló. Nepé tjemey quinam jupj. Pjü la tjiji Dios Cjües jostsja jinwá. Quina Dios Cjües tjijyü'ta Jesús lo winin campa way 'in, ");
INSERT INTO jicNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","pjü jis wa cjuwá nt'a. Mpes tjemey Jesús. Ts'ac' cuarenta ne'aj wínetsja jupj. Ne'aj tjá'asa na diablo tjac' jupj nt'a. Jostsja ca Jesús malala nyuca la mijis, mpes malala tjevele Jesús lal. Jesús ne'aj tjuwine na, ma tjelyaja jupj. Mpes t'üc' ts'ac' cuarenta na, pajal vecj pé'etsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ninana diablo tjevele jupj lal: —Jipj Dios Jatjam p'iyá, 'ücj ca müjü'tün niná pe ca ve mpalas, ne nin ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús ma la tjiji diablo tjevele jin. Jupj wola tjevele p'in: —Dios vele jupj Popel mo'ó: ‘Gente ma ca mpatjam ve mpes p'in. Pjü way Dios tjevele mpes ca mpatjam yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yacjaya diablo tjemyana Jesús campanya nt'a. Jupj la tjiji Jesús 'ücj nyúcatsja pjü patja nt'a nosis mo'ó. Len̈ way tjinyuca pjü. ");
INSERT INTO jicNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Diablo Jesús lal tjevele: —Napj ca mya 'a jipj ca müjü'tün pjü patja nt'a. Napj ca mya 'a pjü yupj jatatj 'üsüs yustapj. Püné nsem jipj yupj 'üsüs lajay mpes. Pjü niná napj nats'a'á quinam. Napj le t'a lal 'ücj 'ya napj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Najas jipj nawalap'a'a palá mpi'tjim. Najas jipj ca mvelen napj pajal püné. Nin la tjejay na, pjü way niná jipj jits'a'á nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús jupj wola tjevele ma ca nin la mijis. —Satanás jipj, jutja napj mpe —tjevele—. Dios Popel vele: ‘Dios Jepa más püné pjü jis lal. Nujola tapalas püné jupj p'in. Ma ca nin nujola nsem la p'a p'in püné Dios jinwá. Dios jos jin la müjí la p'in.’ ");
INSERT INTO jicNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Locopyaya diablo tjemyana Jesús Jerusalén nt'a. Ne'aj Dios wo casá pajal campanya nt'a tjijyünsa jupj. Tjevele Jesús lal: —Dios Jatjam jipj, 'ücj palá ntolo quepé. ");
INSERT INTO jicNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dios Popel vele: ‘Dios ca müjü'tüs jupj angelpan yupj ca mya jamacj jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jis mas mpes ca mya ma'nucj ne ma ca mpojom jipj pe lal. Ma ca malala mya palas’ —nin tjevele diablú. ");
INSERT INTO jicNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús ma la tjiji diablo tjevele jin. Nin p'in wola tjevele: —Dios Popel vele wa: ‘Ma ca malala nyuca la mijin ma jola jinwá, la nuc ncu jipj Jepa Dios ca cyapj mp'a'sas’. ");
INSERT INTO jicNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diablo po jostsja Jesús malala nyuca la mijis, mpes la pülücj malala tjevele jupj lal. Mop'in Jesús ma malala la tjiji. Mpes diablo pjü la tjiji na, tjemey, li nucutsja 'ona 'ücj la cuwis niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Locopyaya Jesús Galilea nt'a tjemey niswá. Dios Cjües cus tjep'ya'sa pjü 'ücj la mijis. Mpes Jesús pajal 'üsüs la tjiji. Pjü ne'aj tapatjá jas tjowelepj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jis wa judiopan 'a si mulú nt'a, sin tji'yüsa lis tjiji jupj lovin. Pjü 'üsüs tjowelepj Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nazaret nt'a tjemey Jesús, püna tüpü'ü nt'a tsjicj waytsja nam. Ne'aj judiopan 'a si mulú nt'a tjemey jupj, pjü sábado na la tjiji jinwá. Ne'aj jis walap'a'a ton̈ca, mo'o la veles jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tja'ayapj nt'ya jupj Dios Popel Isaías tepyaca püná. Isaías profeta waytsja jupj. Mpes Jesús la tyü'pa popel, la tepyala pjaní way Isaías tepyacá. Tjinyuca na, mo'o tjevele jupj. Nin tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dios la ntjet'á jis wala la veles cjuwá jis lal. Napj velé Dios ca 'üsüs la mijis yupj mpes quinam. Dios Cjües ncapj p'ya'sa nin la mejay. Dios nin tjejyama la veles ntji'lin̈ jis lal. Velé 'ücj jis la winin quinam. Velé yun cjuwá jis lal, 'ücj januc liji Dios. Nepénowa yupj jis enemigopan po malala nyuca lis tjajay. Dios nin tjejyama sin majam yupj, 'ücj ca mal jis enemigopan nepé. ");
INSERT INTO jicNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nin tjejyama la veles jupj quelel la siji, quelel jis capj p'ya'sa yupj. Nin liji jupj quinam, velé napj.” ");
INSERT INTO jicNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús t'üc' mo'o tjevele. Dios Popel jun t'yo'na, tje'yaya yom ne'aj tsji' liji. Tjá'asa Jesús, sin 'yüsa la mijis. Pjü wa mo'ó 'a jis tjimyula witjacj pajal jus tjunuc jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jupj yupj jis lal tjevele: “Püna tepyaca niná Dios Popel jupj. Niná jupj Popel tjevelá, t'üc' tepyala yacjaj. Jupj tepyaca napj nin po'ó”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pjü tjowelepj 'üsüs tjevele jupj. Po yólatsja 'onin ne pajal 'üsüs way tjevele. Jis la tjü'üy yuwá: “¿Tsjan mpes nin vele jupj p'iyá niná Yomen Dios se jamá? José jatjam p'in jupj.” ");
INSERT INTO jicNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yupj nin yólatsja mpes, Jesús tjevele: “Napj selé tsjan quelel welé nun napj lal. Niná nun welé lovin. Nun quelel welé: ‘Doctor jipj, mpes mya ts'ucun jipj p'iyá’. Nun quelel welé: ‘'Üsüs la mijin jipj qui'á, püna tüpüt' nt'a. Cupj tjepjya'aquecj pajal 'üsüs la tjejay Capernaum nt'a. Qjuisas nin p'iyá la mijin qui'á.’ ");
INSERT INTO jicNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","”Nin welé, mop'in ma quelel la nojí. Lovin nin profetapan jis lal. Püna tapatja nt'a, ma jisas yupj. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nin p'iyatsja Elías lal. Elías tüpü'ü na püná, año cont'e, mes séisiya ma tjive, mpes jun ta'á po cjuwatsja jis la las. Qui'á Israel nt'a nequem pülücj jis vayum tulucj tapatja. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dios ma jas tjejyama Elías yupj nt'a jis capj la p'acj. Quepj p'a nt'a tüpü'ü nt'a jas tjejyama jupj. Quepj niná Sarepta nt'a tüpü'ü jupj, Sidón mpe se jütütj nt'a. Israelpan popa tuluctsja jupj, quepan. ");
INSERT INTO jicNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","”Eliseo p'a profeta watsja. Jupj tüpü'ü na, pülücj malala jisastsja Israel mo'ó, jis pjoloc' tjamaja mpes. Jas tüpwes ma jis tji'yü'sa yupj. Pjaní way p'in tji'yü'sa, salá tepyala. Naamán lotsja jupj. Siria mpe 'eseptsja jupj, israelpan popa tuluctsja”, nin tjevele Jesús, Nazaret mo'o tapatja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jupj tjevele tjepjyacan̈ na ts'a tji'in pajal. Nin p'iyá pjü way wosis nt'a tjatja ts'a tji'in. (Israelpan waytsja yupj, mpes yólatsja Dios más 'üsüs jis capj tjep'ya'sa yupj la p'a jis lal. Nin mpes ma jisastsja Jesús tjevelá.) ");
INSERT INTO jicNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sin tjüjünsüpj, ntji'lin̈ jupj, pje'á la ts'i pülücj patja nepé. Quelel ja'ünantsja jupj. Tjaman jupj neven pacá nt'a, la pala'á la ts'i mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Newa ma la tjajay yupj quelel lajaytsja jinwá. Yupj culupwen nipj tjemey, tjuwine tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nazaret nepé palavin tjemey Capernaum nt'a. Pülücj patja ne'aj. Galilea mpe se jütütj. Sábado na sin tji'yüsa lis tjiji ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yupj pajal nin yólatsja jupj pajal 'üsüs sin tji'yüsa lis tjiji mpes. Jupj tjevele 'ücj lo jütütj jinwá, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne'aj, wosis mo'ó, judiopan 'a si mulú nt'a, yom tjá'asa, lapanen jupj jos mo'o tüpü'ü. Lapanen malala jos jin la tjiji yomen. Yümücj la tipiya: ");
INSERT INTO jicNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jipj Jesús Nazaret mpe 'esepj. ¡Ma qjuisas jipj! ¿Tsjan pjucj tjacuy cupj nt'a? ¿Ncu pjü malala qjuis lo jay tjacuy jipj? Napj selé pjacj ne jipj. Dios juts'a'á way jipj. Pajal 'üsüs way jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús yümücj tjevele lapanen lal: —¡Lyájasa t'as! ¡Jutja jupj jos mpe! —tjevele. Len̈ way lapanen yom palá ts'iya yupj jis walap'a'á. Yom nepé tjemey. Lapanen ma malala la tjiji quinam jupj lal, püna la tjiji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pjü way yólatsja 'üsüs tepyala mpes. Yuwá tjowelepj: “¿'Oyn ne nin vele jupj? Jepa jinwá jyü'ta lapanen. 'Ücj lo jütütj jinwá si jütüta yupj, ne pje'á jil, jupj jyü'ta jin.” ");
INSERT INTO jicNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pjü jis lal tjowelepj niná tepyalá, mpes pjü tjepjyacan̈ Jesús po'ó Capernaum mo'ó, Capernaum ne'aj p'in 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yacjaya Jesús tjemey wosis mpe, niná wosis judiopan 'a si mulú nt'a. Simón wo nt'a tjemey. Wama tjemey. Ne'aj Simón pwisam malala jostsja jupj, pajal si 'áwatsja jupj. Nin mpes wa nt'a tapatja la tjomon Jesús cü'ü'süs la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mpes Jesús tjac', ton̈ca malala jos nt'a. Cus tjeve'le 'owus, mpes tji'yü'sa quinam. Simón pwisam len̈ way jas tjijyünsa, jis tje'yaya jis la las. Nas tji'yü'sa quinam, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","T'yaja na, la p'a tjiquil Jesús nt'a. Pjü tucuman malala jisas yupj sin popé. Pjü p'a casá malala jisas tucuman yupj. Jesús po la tje'yot'a pjü witjacj, jis tji'yü'sa lis tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lapanenpan nepénowa jisas nepé tjil, pülücj nepé tjil. Tjil na, la tupuyupj, tjowelepj: “¡Dios Jatjam jipj!” Mpes Jesús jis capj tjeve'le lapanenpan. Yupj salejeptsja jupj niná Jepa Püné Dios tjevele ca jas majamas jis capj la p'acj judiopan. Nin mpes Jesús ma jis tje'yaya jis la veles yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tjejyawca na, pje'á tjemey Jesús jusapj, pjü len̈ nt'a. Mop'in gente la tapal jupj. Tjiquil jupj nt'a. Ma quelel jas tjajam jupj yupj mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mpes jupj yupj jis lal tjevele: “Dios jos p'a nt'a jum 'ots'ipj, nepénowa patja nt'a. Ca mvelé Dios pajal 'üsüs la tjiji yupj mpes. Jis walap'a'a ca mvelé Dios ca müjü'tüs nosis nt'a. Dios nin tjejyama nin la veles.” ");
INSERT INTO jicNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mpes newa jun ta'á jámatsja judiopan tapatja nt'a. Jis wa judiopan 'a si mulú nt'a tjevele Dios tjevelá yupj jis walap'a'á. Nin líjitsja lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","P'a jyawca na, Jesús 'üsǘ püné la nt'a ton̈ca. Genesaret lotsja 'üsǘ püné. (Pajal campwila waytsja, pajal la püné.) Ne'aj ton̈ca na, pülücj 'a jis tjimyula jupj nt'a. Jesús jis wala tjevele Dios tjevelá. Tjepjyacan̈, ne cus tjeletjatj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne'aj barco mat'e 'üsǘ püné la nt'a tsyu'pa tjatja tjinyuca. Len̈tsja barco wa mo'ó. Niyom cjul pje'á la coy, jis barco ne'aj tsupapj yas nam. Jis ataraya japatsj quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Barco pjaní wama tjemey Jesús. Simón juts'a'á waytsja barcas. Jesús Simón lal la tjemyona jupj ca nsoctes barcas, ca tsjicj way mim 'üsǘ la mpe. Jesús 'etjele barco mo'ó, nepé sin 'yüsa lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","T'üc' jis lal tjevele na, tjevele Simón lal: —'Üsǘ campwila nt'a tjemyana barcas. Nun jis ataraya mo'o la ts'iyá, cjul pje'á la coy. ");
INSERT INTO jicNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón jupj wola tjevele: —Nejepa, püste cus tüpwes quelel pje'á la tecyoyecj; lovin len̈. Jipj velen mpes p'in niswa ca mo'o la nts'i na'ataraya. ");
INSERT INTO jicNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nin la tjajay na, cjul pajal pülücj jis ntji'lin̈. Ataraya po tipit'a mpes, quelel lo comyatsja quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mpes Simón, jupj jomicapan jis lal wa, jis walap'a'a la tjamayapj niyom p'a barco mo'ó. Jisastsja ncul jis capj la p'acj. Tjiquil na, cjul pajal pülücj la tocoy wa, mpes barco manas tipit'a cjul lal. Pajal tü waytsja, mpes quelel pwila jama barcas. ");
INSERT INTO jicNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro niná tjinyuca na, tüic' jin tjüjünsü Jesús wolap'a'á. Palá nipi'tje jupj. Tjevele: —Nejepa, más 'ücj napj nepé ca mim jipj. Malala napj, jipj 'a 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pajal jólatsja pajal pülücj pje'á la tecyoye cjulun quinam. Püna ma polel pje'á la tecyoye. Seletsja pajal 'üsüs la tjiji Jesús, mpes nin tjevele jupj. Niyom p'a wa nin p'iyá yólatsja cjul pajal pülücj pje'á la tocoy mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nin p'iyá jólatsja wa Jacobo, Juan 'ots'ipj, yupj ne Zebedeo jatjampan. Simón lal 'a mulú tsji' lajaytsja lovin. Jesús tjevele Simón lal: —Po ma lecj tjeyá. Cjul pje'á le coytsja püna p'in. Quina p'a casá ca la mijin. Jipj ca mvelen la p'a jis lal Dios mpes, mpes yupj ca cus ncon̈cocj Dios —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nin mpes yupj jis barco 'üsǘ la nt'a tjaman. Tsupapj na, pjü jatja tjil. Yupj quelel sa con̈tsja Jesús lovin. (Quina ma cjul pje'á la coy pátjatsja; quina tsji' lajaytsja Jesús mpes.) ");
INSERT INTO jicNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús p'a nt'a pülücj patja nt'a tjá'asa na, yom tjac' jupj nt'a. Malala jostsja pajal. Jüp'üy tjamaja lovin, palá tinca jüp'üy popé. Jupj Jesús tjinyuca na, palá nipi'tje Jesús wolap'a'á. La tjemyona: —Nejepa, jipj polel ni 'ü'sa lejay. Jipj jyas na ca nin nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mpes Jesús pjwel la tepyacta, po la tje'yot'a. Tjevele: —Najas. 'I tjü'ü'süs quinam. Len̈ way tji'yü'sa, jüp'üy 'üsüs tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Locopyaya Jesús tjijyü'ta jupj: —Ma ca mvelen p'a lal nin tepyalá. Jutja sacerdote nt'a. Jupj ca jis nucus. Ca la mpalas ncu malala lo nuc p'yüy po'ó. Ca mveles 'üsüs quinam. Niná la tjejay na, jipj ca ma'ayan Dios mpes, jupj 'i tjü'ü'sa la tjiji mpes. Pajal püna Moisés tjijyü'ta tsjan ca ma'ayacj, jis p'üy jis tji'yü'sa na. Jupj tjijyü'ta jin ca la mijin. Pjü la tjejay na, la p'a ca jus nlayecj jipj t'üc' way 'i tjü'ü'sa quinam —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Newa pajal pülücj 'üsüs tjowelepj Jesús po'ó. Campa tapatja tjepjyacan̈ wa Jesús pajal 'üsüs la tjiji. Mpes pajal pülücj 'a jis tjimyula jupj nt'a jis la pjac jupj tjevelá, jis la 'ü'süs wa tjiquil, malala jisastsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mop'in Jesús la pülücj jusapj tjemey la veles jupj Popay Dios lal. Nin tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","P'a jyawca na Jesús sin 'yüsa líjitsja. Fariseopan nepénowa ne'aj tjatja wa jupj nt'a. Niyom Moisés popel sin 'yüsa lajay ne'aj tjatja wa. Pülücj waytsja yupj. Galilea nepé tjiquil nepenowá. Pjü nepénowa patja mpe tjiquil yupj. Judea nepé tjiquil wa nepenowá. Jerusalén nepé tjiquil wa nepenowá. Qjuis Jepa Dios cus tecyon̈ca Jesús, mpes 'ücj si 'ü'sa líjitsja malala jisas. ");
INSERT INTO jicNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wama tjá'asa Jesús yupj jis lal. Locopyaya niyom p'a wa tjiquil, yom ma polel 'utaná tucuman hamaca lal. Yupj quelel jamantsja malala jos wa mo'ó, Jesús nt'a, Jesús wolap'a'a la püntüs jupj. Mpes pajal la tapal yupj 'oyn ne 'ücj wama mal. ");
INSERT INTO jicNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cjuwatsja. Pülücj tjatja mpes ma tjunuc 'oyn ne wama la winin. Mpes wa casa'á tjil, wo jay tjujulul yupj. Nin la tjajay na, wo jay nepé palá tüpüntüpj malala jos hamaca lal. Jesús wolap'a'a tüpüntüpj pülücj tjatja culupwen nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús jus nleya yupj topon jupj polel cü'ü'süs la mijis. Jupj tjevele malala jos lal: —Natjam, napj perdonar la 'ejay malala nyuca la tjejay Dios lal. Ma nin nola quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niyom Moisés popel sin 'yüsa lajay malala jin yólatsja Jesús tjevelá. Nin p'iyá fariseopan. Yólatsja: “Jupj tjevelá malala Dios lal. Jupj ma polel perdonar liji malala nyuca la tjiji. Dios p'in nin liji.” ");
INSERT INTO jicNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús jus nleya yupj nin yólatsja, mpes jis wala tjevele: —¿Tsjan mpes nujola napj tjevelé malala Dios lal? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Napj 'ücj velé: ‘Napj perdonar la 'ejay malala nyuca la tjejay Dios lal’. Napj 'ücj wa velé: ‘Jin tjijyünsa, tjuwine jipj’. ¿Cana más costa la veles? ");
INSERT INTO jicNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nin p'iyá ca mvelé wa malala jos lal, mpes nun ca jus nlayé napj 'ücj perdonar lejay nosis nt'a. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús. Mpes jupj tjevele yom ma polel 'utanatsja lal: —Jin tjijyünsa, jipj hamaca nt'ya nt'an, jutja wya nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Len̈ way malala jos tji'yü'sa. Jas tjijyünsa yupj jis walap'a'á, hamaca jupj tüpü'ü casá nt'ya, tjemey wo nt'a. Po 'üsüs way tjevele Dios po'ó, 'üsüs tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pjü ne'aj tjatja pajal yólatsja pajal 'üsüs tepyala mpes, ne 'üsüs tjowelepj Dios po'ó. Yólatsja Jesús püné. Mpes tjowelepj: “Lovin ma nin tjinyucucj cupj yas nam”. ");
INSERT INTO jicNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Locopyaya pje'á tjemey Jesús. Yom tjinyuca, tsji' líjitsja jepa mpes. T'emel t'e'éncatsja lovin jepa mpes, impuesto jaylacj. Wa nt'a t'emel t'e'éncatsja nt'a tjá'asa. Yom niná Leví lotsja jupj. Jesús jupj lal tjevele: —Ncapj tecyon̈ca jipj. Najas ncapj cyon̈ lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mpes jas tjijyünsa, pjü jatja tjemey. Cus tecyon̈ca Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Locopyaya Leví pülücj la las la tjiji jupj wo nt'a Jesús mpes. Pülücj jis lal tjevele ncul jupj wo nt'a. Leví jostsja la p'a ca jus nlayecj püné Jesús jupj lal, mpes nin la tjiji. Pülücj tjiquil, yupj nepénowa niyom impuesto jaylacj jat'anqueptsja, Leví jinwá. Niyom p'a wa tjiquil wa. Yupj jis lal tjatja, tjalá. ");
INSERT INTO jicNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseopan ma jisastsja yupj nin la tjajay. Tjowelepj Jesús discipulopan jilal malala nin, yupj 'a mulú tjalá yupj jis lal. Nin p'iyá tjowelepj wa Moisés popel sin 'yüsa lajay. —¿Tsjan pjucj lojá impuesto jaylacj jat'anquepj jis lal, malala nyuca lajay jis lal wa? —nin la tjü'üy yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús jis wala tjevele: —'Ücj jisas ma jisas doctor. Malala jisas doctor jisas yupj. Napj doctor jinwá malala lajay jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Napj niná nin lejay Dios jos jinwá. Napj tjacuwis la veles malala lajay jis lal. Napj velé yupj jis lal Dios jos yupj 'aplijila nsem malala nyuca la tjajay mpes. Napj velé Dios jos yupj 'üsüs ca la mijicj quinam jupj jos jin. La p'a wa 'üsüs lajay quinam, napj ma nin velé yupj jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nin mpes yupj tjowelepj jupj lal, yupj fariseopan nepenowá, Moisés popel sin 'yüsa lajay nepenowá. Yupj tjowelepj: —Juan discipulopan la pülücj ma jalá, quelel javelepj p'in Dios lal. Nin p'iyá lajay fariseopan jis discipulopan. ¿Tsjan mpes jipj discipulopan lovin jalá, lovin myü'ün̈? ");
INSERT INTO jicNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús tjevele jupj discipulopan ma nin lajaytsja custjay. P'a jyawca na ca nin la mijicj. Ninana tjevelá: —Yom judío woya na, jupj jomicapan jiquil wa cus la con̈ jupj. Pajal 'ücj jisas jatja, jalá wa yupj. Nin p'iyá napj discipulopan jis lal. Napj yupj jis lal pü'üs quinam. 'Ücj javelepj napj lal, mpes 'ücj jalá. ");
INSERT INTO jicNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","P'a jyawca na, p'a casá ca nsem. La p'a ca ncul, ca ma tjililin̈. Len̈ ca nsem napj. Nin tepyala na, napj discipulopan ma ca nlajacj nenéyawa, ca mvelecj p'in Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Parábola tjevele Jesús sin la 'üsüs jis la jay. Sin tji'yüsa lis tjiji tsjan mpes jupj lal japon ma polel nin p'iyá lajay püna tapatja la tjajay jinwá. Ninana Jesús tjevelá: —Nin p'iyá nun nusin quip seyasa to'á na, nusin quip seyasa ma cüemá nusin quip pül way po pwi'tjí mpes. Nin lojí, malala se palá manas. Seyasa way la tücüeme nsem; ma'ajapj malala wa nsem. Pülül po pwi'tjí ma yuwal justa nsem pülül pül lal. ");
INSERT INTO jicNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nin p'iyá wa judiopan uva 'üsǘ seyasa jatatj na. Uva 'üsǘ seyasa ma ca mo'o nt'ucj pjoloc' pül mo'ó. Nin lajay, pjoloc' pül ca ma'apcas 'üsǘ myolca mpes. Tje'yapta na, uva 'üsǘ ca jus ncocom. Pjoloc' malala mpalas wa. ");
INSERT INTO jicNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Más 'ücj uva 'üsǘ seyasa pjoloc' seyasa mo'ó ca mo'o nt'ucj. ");
INSERT INTO jicNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nepénowa uva 'üsǘ pül tjimyü'ün̈ lovin. Seyasa ma jisas yupj. Nin lovin. Yupj javelepj pül way po 'üsüs —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado pjaní Jesús trigo lejen̈ culupwen nipj tjemey jupj discipulopan jis lal. Sábado ts'ac' niná judiopan ma tsji' lajay. Jesús discipulopan trigo nepénowa sey jat'anqueptsja, tjulujun, tjalá. ('Üctsja niná nin la tjajay yupj ne'aj. Jümücj tjelyawun̈ na, 'ücj p'a sine popé tjalá yupj.) ");
INSERT INTO jicNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mop'in fariseopan nepénowa ma jisastsja nin la tjajay sábado na. Tjowelepj: —¿Tsjan pjucj nin lojí? Dios Popel vele ma polel t'yanacj sábado na, ts'ac' niná ma tsji' lijicj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús jis wala tjevele: —Dios Popel vele David la tjijá pajal püna. ¿Ncu lovin ma mo'o tjowelé niná? (David israelpan jis jepa waytsja. 'Üsüstsja jupj Dios lal.) Ts'ac' pjaní jupj vecj pé'etsja. Noyomes jupj cus tocon̈ wa, vecj tecya'lin̈ wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mpes jupj wama tjemey Dios wo mo'ó; ne'aj pan nt'ya, tjelyaja. Jis tje'yaya wa niyom cus tocon̈. Pan niná israelpan tja'ayapj Dios mpes. Dios Popel tjevele sacerdotepan p'in 'ücj jalá pan niná. P'a witjacj ma polel jalá yupj. David sacerdote tuluctsja; newa nin Dios ma ts'i tji'ina jupj tjelyaja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús tjevele wa yupj jis lal: —Napj p'iyá niná Yomen Dios jas tjejyamá. Napj 'ücj jyütütj tsjan 'ücj jis la jay sábado na, ts'ac' ma tsji' lijicj na. ");
INSERT INTO jicNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","P'a sábado na, Jesús wama tjemey judiopan 'a si mulú nt'a. Sin tji'yüsa lis tjiji. Yom ne'aj tjá'asa wa mo'ó, mos li'inyampe c'a. Ma polel le páctatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Niyom p'a wa ne'aj tjatja wa, Moisés popel sin 'yüsa lajay nepenowá, fariseopan nepenowá. Pajal jus tjunuc Jesús, quelel januctsja ncu 'yü'sa la mijis sábado na, ts'ac' niná ma tsji' lajay yupj. Po jisastsja Jesús ca malala la mijis, mpes ca 'ücj jat' mvelecj Jesús malala. ");
INSERT INTO jicNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús seletsja nin yólatsja yupj. Jupj tjevele yom mos ma polel le pacta lal: —Jin tjijyünsa. Culupwen nt'a was jipj. Mpes yom jas tjijyünsa, culupwen nt'a tjac', ton̈ca jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús tjevele wa niyom ne'aj tjatja jis lal: —Napj nu la 'yüy cana más 'ücj lejay sábado na, ts'ac' niná ma tsji' lijicj. ¿Ncu más 'ücj 'üsüs lejay, ncu más 'ücj malala lejay? ¿Ncu más 'ücj se p'acj 'ücj la püt'üs jupj, ncu más 'ücj 'yünan jupj? ");
INSERT INTO jicNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús pjü yus tjinyuca na, mos ma polel le pacta lal tjevele: —Myas la tepyacta. Mpes mos la tepyacta quinam. Mos tji'yü'sa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Niyom ne'aj tjatjá pajal ts'a tji'in. Yuwá tjowelepj 'oyn nyuca malala la qjuijicj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","P'a jawas Jesús joc' mo'o tjemey la veles Dios lal. Newa püste cus tüpwes Dios lal tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tjejyawca na, jupj discipulopan jis lal tjevele ncul. Yupj sin popé dóceya lis t'ya jupj. Jupj apostolpan waytsja yupj; jupj sin tjejyama tsji' la mijicj jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jupj apostolpan popa pjaní Simón lotsja. Jesús p'a ló la t'ya jupj locopyaya. Pedro jupj ló la t'ya wa. P'a apóstol Andrés lotsja, Simón tsüipe jupj. Jacobo lotsja pjaní wa. Juan lotsja pjaní wa. Felipe pjaní wa, Bartolomé pjaní wa. ");
INSERT INTO jicNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo p'a wa, Tomás p'a wa, Jacobo p'a wa, jupj ne Alfeo jatjam. Simón p'a wa. Simón quelel le palánatsja jepa lal, jepa israelpan sin popa tulucj, ne nin. Nin mpes “Israel Mpes Jola” lotsja wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas p'a wa, jupj ne Jacobo jatjam. Judas Iscariote p'a wa. P'a jawas Judas Iscariote Jesús enemigo tepyala jupj. Jis capj tjep'ya'sa Jesús enemigopan jis la tjilil jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús jupj apostolpan lis t'ya na, palavin tjemey yupj jis lal. Yumal nt'a ton̈ca jupj. Ne'aj jupj discipulopan pajal pülücj tjatja. P'a wa pajal pülücj tjatja wa. Judea jun ta'á nepé tjiquil, nepénowa Jerusalén mpe tjiquil. P'a witjacj Tiro nepé tjiquil, pülücj patja mpe. P'a pülücj patja nepé tjiquil wa nepenowá, Sidón ló ne'aj. Tiro, Sidón, pajal cámpatsja. 'Üsǘ püné ne'aj p'in tapatja yupj. Pjü tjiquil jis la pjac Jesús tjevelá. Tjiquil wa Jesús ca cü'ü'süs lis mijis, yupj malala jisastsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yupj sin popa nepenowá lapanenpan malala lis tjajay lovin. Jesús jis tji'yü'sa lis tjiji wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesús po la tjo'otj na, jis tji'yü'sa yupj. Mpes pjü quelel po la 'otsja jupj, pülüctsja pajal. Pjü malala jisas pjü jis tji'yü'sa, Jesús po la tjo'otj na p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Locopyaya Jesús yus tjinyuca jupj discipulopan, tjevele: “Nun nepénowa pjü cjuwá, mpes pajal 'ücj nujisas nsem. Dios 'ücj nu jyü'ta cjuwá na. ");
INSERT INTO jicNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nun nepénowa vecj co'liqué, mpes pajal 'ücj nujisas nsem. 'Üsüs ca nu ma'ayas Dios. Nun lu puyú na, 'ücj nujisas nsem. Locopyaya mwi'iqué ca. (Nin ca la mijis Dios.) ");
INSERT INTO jicNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","P'a wa ma jisas nun, ncapj con̈có mpes, 'ücj nujisas nsem. Ma jisas nun culá yupj nt'a, nun ncapj con̈có mpes, 'ücj nin. Malala javelepj nun po'ó ncapj con̈có mpes, 'ücj nujisas nsem. Javelepj malala nun, nun ncapj con̈có mpes, 'ücj nujisas nsem. Napj ne niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","”Ninana lajay na nun jis lal, 'ücj nujisas t'as. Viyá lo tolonó 'ücj nujisas mpes. Po 'üsüs ca nu ma'ayas Dios tsjun po'ó 'üsüs la tjüjí mpes. T'üc' way niná. Nin p'iyá püna canapatjá yupj sin popa p'iyá malala lis tjajay wa profetapan. ");
INSERT INTO jicNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”Ma ca 'üsüs nsem nepénowa jis lal. Nun nepénowa pülücj to'á. Mpes malala ca nu mpalas. Po quina way p'in 'ücj nujisas nun. P'a wa ma ca nu ma'ayas Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Malala ca nu mpalas nun nepenowá. Pjü nujisas, pjü to'á quinam. P'a jawas cjuwá ca nsem. Malala ca nu mpalas nun nepénowa. Wüi'iqué quinam. P'a jawas 'aplijila ca nsem nun pajal. La mpuyucj ca. ");
INSERT INTO jicNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pjü 'üsüs nusin javelepj lovin, malala ca nu mpalas. Nin p'iyá püna canapatjá yupj sin popa p'iyá 'üsüs sin tjowelepj la tsuwilpan sin po'ó püná. Profetapan nenem ma t'üc' tjowelepj. Dios mpes tjowelepj tulucj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”Napj najas más 'üsüs la müjí nun yupj jis lal. Nun quelel pjo'oqué napj velé, nin velé napj nun jis lal: quelel lis müjí nun jis enemigopan. Nepénowa ma jisas nun, ma nin nujola t'as. Nun ca jis capj mp'a'sá newá. ");
INSERT INTO jicNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nepénowa malala javelepj nun sin po'ó ca nacj, yupj jisas ca malala nu mpalas. Nun ma ca nin p'iyá la müjí yupj jis lal. Nun ca mvelé nujisas 'üsüs ca jis mpalas yupj. Yupj javelepj nun malala, ma nin nujola t'as. La moná nun Dios lal jupj ca jis capj mp'a'sas. ");
INSERT INTO jicNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","”La p'a nupjocj pjaní tyüla na, nun ca ma'ayá ma'ajapj tyüla wa. Nusin quip pje'apa tjüi'le, t'ya, nusin quip wampa ca ma'ayá ntji'lim wa. ");
INSERT INTO jicNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","La p'a la mon na nun jis lal, nun ca jis ma'ayá yupj. Nin ca la müjí pjü jis lal. La p'a nun nuts'a'á nt'ya naya, ma ca la moná jupj ma'ayas niná. ");
INSERT INTO jicNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","”Tsjan niná nujisas la p'a lajay nun jis lal, nin p'iyá la müjí yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","La p'a quelel la nusejay nun ca nacj, mpes nun quelel la sojí wa yupj. Ma quelel la nusejay nun, nun ma wa quelel la sojí yupj ca nacj. Dios ma ca mwi'im nin lojí mpes. Malala lajay nin p'iyá lajay yupj. La p'a quelel la sajay yupj, yupj quelel la sajay wa yupj. Dios jos nun más 'üsüs la müjí yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","La p'a 'üsüs lajay nun mpes ca nacj, mpes nun 'üsüs lojí wa yupj mpes. Ma 'üsüs lajay nun mpes, nun ma wa 'üsüs lojí yupj mpes ca nacj. Dios ma ca mwi'im nin nin lojí mpes. Malala lajay nin p'iyá lajay yupj. Dios jos nun más 'üsüs la müjí yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","La p'a nun jis lal le moná ca nacj. Nun 'oyá jupj la tjemyona, newa nujola p'a jawasa jupj t'e'éncatsja ca nca'as, ma'ayas. Dios ma ca mwi'im nin lojí mpes. Malala lajay nin p'iyá lajay yupj. La p'a yupj jis lal le monana, yupj ja'ayapj wa. Yola p'a jawasa jupj t'e'éncatsja ca nca'as, ma'ayas jupj. Dios jos nun más 'üsüs lojí yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","”Quelel lis müjí nun jis enemigopan. Jis capj mp'a'sá p'a wa. La mon na, jis ma'ayá nun. Ma nujola t'as p'a jawasa yupj natj ca nca'acj, ma'ayacj. Nin lojí na, po 'üsüs ca nu ma'ayas Dios jupj pü'ü nt'a. Dios más püné pjü jis lal. Nin lojí na, Nupopay Dios jinwá lojí nun. Jupj jatjampan nun, jupj jucucuspan nun. Jupj 'üsüs la siji wa malala lajay. Nepénowa ma wi'in̈ jupj se 'aya mpes, newa 'üsüs la siji wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Malala se palá na, nun jis Papay Dios quelel jis capj p'ya'sa. Nin p'iyá 'üsüs la müjí nun. ");
INSERT INTO jicNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”Po ma tjowelé la p'a malala. Nun welé la p'a malala, Dios ca mveles nun p'in malala wa. Po ma tjowelé p'a po'ó más 'ücj Dios ca cus ntülüs. Nun nin welé, Dios ca mveles más 'ücj jupj ca nucopj ntülüs wa nun. Perdonar la müjí p'in la p'a malala nyuca la tjiji, ne Dios ca perdonar la numijis wa nun. ");
INSERT INTO jicNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","”Tja'ayá p'a wa jos, ne Dios ca nu ma'ayas. Yom 'üsüs 'yaya jinwá ca ma'ayas. Quiliyú pit'a. Tipit'a na, mo'o t'a liji. Nin la tjiji na, syolsol, niswa pit'a, palá soca nas. Nin jin ca nu ma'ayas Dios. Nun p'a wa 'oyá jinwá, nin jinwá ca nu ma'ayas Dios”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús parábola mpes sin 'yüsa lis tjiji niswá. Ninana tjevelá: “Yom jun tulucj ma polel cyacaná yom p'a jun tulucj wa. Nin la qjuijis, manas ts'entuna mo'o palá jis ntüncüs ca. Nin p'iyá nun jilal. ");
INSERT INTO jicNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Si 'üsǘ püné tulucj jupj jas tji'yüsa la tjiji lal. 'Üsüs jas tji'yüsa na, yuwal nsem jupj jas tji'yüsa la tjiji lal la p'in. Nin lovin”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jesús tjevele wa: “¿Tsjan pjucj jele jetjam malala liji, newa ma jele más malala lejay jipj jupj lal? Nin p'iyá niná, tsjan tsjicj way jetjam junma tjeyaca nyuc; yo püné jipj jinma tjeyaca ma nyuc. ");
INSERT INTO jicNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jetjam lal velen: ‘Natjam, najas jipj ca ma'ayan napj ca pje'á la nts'i tsjan tsjicj way jinma tjeyaca’. Jipj ma nyuc yo püné jipj jin mo'ó. Nin p'iyá lejay jipj. Jipj pajal malala, niná nin lejay mpes. Jipj malala wa, la p'a malala jinwá. Mya 'ü'süs ca jipj. Po ma malala la mijin quinam, püna la tjejay jinwá. Locopyaya ca jus nlayen 'onin ca cus mp'a'san p'a”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús p'a wa sin tji'yüsa lis tjiji. Tjevele: “Yo wolas 'ücj la las, ma ca wolas malala mvalas. Jupj wolas malala, ma ca nepénowa 'ücj la las mvalas jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nun nucú na wolas velan̈, nun jus nlayé ncu 'ücj la las jupj wolas. Nun solejé tunun mwicj ma higo vyala. Jül ma 'anpüpj vyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nin p'iyá gente jis lal. Yom 'üsüs, 'üsüs wa jola. Nin mpes vele wa 'üsüs way. Yom malala, malala jola jupj. Nin mpes jupj vele wa malala. Nun nujola, niná p'in welé. Nin p'iyá pjü way jis lal”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús tjevele wa yupj jis lal: “¿Tsjan mpes nun welé napj nun jis Jepa, mop'in ma lojí napj jyütütj? Napj jyütütj ma lojí, nun jis Jepa tulucj napj. ");
INSERT INTO jicNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nasa ca mvelé 'oyn nyuca liji napj jyütütj jin liji. Napj nt'a jac' jupj, pjoca napj velé. Pjoca na, nin liji napj vele. ");
INSERT INTO jicNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jupj yom wo 'üsüs jas tjijyünsa jinwá. Pajal campwila tsjomis tyoca mwalá way p'in, pwen já'asa nas tyoca jupj. Yo t'ol pe casá lejen̈ la tjiji. Locopyaya wosis tjecyawaja, 'ücj la tjiji. T'üc' la tjiji na, 'üsǘ püné t'yüna, pajal yümücj wo nt'a palá tjac' 'üsüs. Newa ma si cüts'itsja wosis, 'üsüs tón̈catsja mpes. Nin p'iyá 'üsüs pü'ü napj jyütütj jin liji. ");
INSERT INTO jicNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","”Yom p'a wa pjoca wa napj velé ca nacj, jupj ma liji napj jyütütj jin. P'a yom wo jas tjijyünsa jinwá jupj. Ma tsjomis tyoca. 'Amá casá jas tjijyünsa jupj la p'in. Locopyaya wosis tecyawaja. T'üc' la tjiji na, 'üsǘ püné t'yüna, pajal yümücj wo nt'a palá tjac' 'üsüs. Len̈ way tyüla wosis. Jas tüpwes malala tepyala wosis. Nin p'iyá malala pyala niná, jupj ma liji napj jyütütj jin.” ");
INSERT INTO jicNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús pjü tjevele yupj jis la pjac. T'üc' tjevele na, Capernaum nt'a tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ne'aj jepa militar tüpü'ü. Israelpan popa tuluctsja jupj. Romano militar waytsja jupj. Jépatsja jupj niyom cien jis lal. Jupj mozo malala jostsja pajal, nasa quelel pé'etsja jupj. Jepa militar pajal quelel líjitsja jupj jomozo. ");
INSERT INTO jicNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","La p'a wa jupj wola tjowelepj Jesús 'ücj 'yü'sa liji. Mpes jupj sin tjejyama niyom nepénowa Jesús nt'a. Niyom nenem israelpan noypan waytsja yupj. Jepa militar sin tjejyama yupj, jis la mon Jesús ncuwim, jupj jomozo 'yü'sa la mijis. ");
INSERT INTO jicNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne'as tjil na Jesús nt'a, pajal la tjomon Jesús lal, jupj ca cus mp'a'sas. Tjowelepj: —Jepa militar po 'üsüs jupj, mpes ca nin la mijin jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Israelpan popa tulucj jupj, mop'in po quelel la qjuisiji cupj. Qjuis wa 'a qjuisí mulú nt'a jas tjijyünsa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús tjemey yupj jis lal. Ne'aj way p'in tjemey na, jepa militar wo nt'a, jepa militar jomicapan p'a witjacj sin tjejyama Jesús nt'a. Jupj mpes tjowelepj: —Nejepa, ma najas pajal costa nsem jipj mpes. Pajal 'üsüs way jipj. Napj 'üsüs tulucj. Más 'ücj ma nawá mo'ó cuy jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nin mpes wa ma tjacuwis napj jipj nt'a. Napj nin nola 'üsüs tulucj napj. Najas jipj ca müjü'tün la 'ü'süs jupj la p'in, ne ca cü'ü'süs napj namozo. ");
INSERT INTO jicNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Napj selé jipj 'ücj jyütütj. Nin p'iyá napj nejepa ni jütüta. Napj lejay jupj vele jin. Napj jyütütj wa niyom militar nepénowa. Pjaní lal velé jutja, mpes jama. P'a lal velé was, mpes jac'. Namozo lal velé nin la mijis, mpes nin liji —nin tjevele jepa militar. ");
INSERT INTO jicNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús nin tjapjaca na, jupj jólatsja pajal 'üsüs tjevele jepa militar. Pajal pülücj cus tocon̈ jupj tjuwine nt'a. Jupj la nujuya, tjevele yupj jis lal: —Pajal 'üsüs pyona jupj, jupj ne israelpan popa tulucj. Lovin ma tjinyuc israelpan popa pjaní más 'üsüs way tepyona jupj lal. T'üc' way niná —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tjil niyom nenem jepa militar sin tjejyamá. Jepa militar wo mo'ó tjil na, jupj jomozo 'ücj já'asa jus tjunuc. Jesús tji'yü'sa la tjiji jupj campa mpe. Jupj tjijyü'ta mpes p'in tji'yü'sa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Locopyaya p'a nt'a pülücj patja nt'a tjemey Jesús. Naín ló ne'aj. Jupj discipulopan cus tocon̈, la p'a pajal pülücj cus tocon̈ wa. ");
INSERT INTO jicNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naín t'asiyú tjüwücj tón̈catsja. Ne'as tjil na, tjüwücj jun vilicj nt'a, yom tepe'e pje'á jacumantsja la toc tjinyuca Jesús. Yom tepe'á, jupj pjaní jamay jatjam waytsja. Jupj jamay voyum tepe'e wa jupj püna p'in, mpes malala tepyala quepan pajal. Pülücj cus tocon̈ jupj, ne'aj tapatjá sin popé. Jatoc nt'a tjil. ");
INSERT INTO jicNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Qjuis Jepa Jesús yom jamay jus tjinyuca na, pajal jólatsja malala tepyala mpes. Yom jamay lal tjevele: —Po ma la tipiya. (Jesús seletsja 'üsüs ca la mijis, mpes nin tjevele.) ");
INSERT INTO jicNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús cacaste nt'a tjac', cacaste po la tje'yot'a jupj. Niyom cacaste jacumantsja jis tyantaná. Nin la tjajay na, Jesús tjevele tepe'e lal: —Natjam, jin tjijyünsa. ");
INSERT INTO jicNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mpes yom tepe'á nyucunú tepyala. Jas tjijyünsa, tjá'asa quinam, jis wala tjevele wa. Jesús tjevele jamay lal: —Já'asa quinam jetjam. ");
INSERT INTO jicNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pjü way niná tjunuc pajal yólatsja Jesús pajal 'üsüs la tjiji, yólatsja jupj pajal püné. 'Üsüs tjowelepj Dios po'ó. Yuwá tjowelepj: “Profeta püné way jupj. Quina israelpan jis capj tjep'ya'sa Dios.” ");
INSERT INTO jicNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pjü way Judea mo'o tapatja, pjü sin tji'yüsa Jesús jas tjijyünsa tepe'á, niswa tüpü'ü. Judea ne'aj p'in tapatja, sin tji'yüsa wa niná. ");
INSERT INTO jicNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan jus nleya wa Jesús jas tjijyünsa tepe'á, niswa tüpü'ü. Juan bautizar líjitsja püna p'in. Jupj discipulopan tjowelepj jupj lal nin tepyalá. Tjowelepj wa jupj lal pjü way Jesús pajal 'üsüs líjitsja. ");
INSERT INTO jicNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Juan jupj discipulopan mát'eya jis lal tjevele jis la cuwis, sin tjejyama qjuis Jepa Jesucristo nt'a jis la veles jupj lal. Tjevele ca nin la veles: “¿Ncu jipj ninana Dios tjevele ca jas majamas cupj nt'a? ¿Ncu p'a wa la nucum?” ");
INSERT INTO jicNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mpes Juan discipulopan Jesús nt'a tjil. Ne'as tjil na, tjowelepj: —Juan el Bautista qjuisin tjejyama jipj nt'a. Tjevele ca nin mvelecj: ¿Ncu jipj ninana Dios tjevele ca jas majamas cupj nt'a? ¿Ncu p'a wa la nucum? ");
INSERT INTO jicNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yupj ne'aj tjatja na, pülücj malala jisas jis tji'yü'sa lis tjiji Jesús. Pajal si tsjunú, jis tji'yü'sa la tjiji wa. Lapanenpan malala lis tjajay yupj nepenowá. Jesús jis tji'yü'sa la tjiji wa yupj. Pülücj yun cjuwá 'üsüs januc la tjiji jupj. Juan discipulopan tjunuc Jesús la tjijá. ");
INSERT INTO jicNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mpes Jesús tjevele Juan sin tjejyama jis lal: —Lowa, tjowelé Juan lal nun tjapja'aqué napj nt'a, tjowelé nun tjunucú wa. Yun tulucj 'ücj januc quinam. Ma polel jiltsja 'ücj lyawun̈ quinam. Jis p'üy tjamaja jis tji'yü'sa wa quinam. Jis pjats' la topj 'ücj pjyacan̈ quinam. Tecya'lin̈ nepenowá sin tjüjünsüpj wa 'ücj jis la püt'üs quinam. Napj velé wa t'emel cjuwá jis lal Dios 'üsüs la tjiji yupj mpes. Pjü niná lejay napj, Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tjowelé wa Juan lal: jupj newa pyona napj mpes, 'ücj jos nsem jupj pajal —nin tjevele Jesús Juan sin tjejyama jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tjil niyom nenem. Tjil na, Jesús tjevele Juan po'ó ne'aj tjatja jis lal. “¿Tsjan mpes tjalawú nun Juan nt'a, jupj wa cjuwá nt'a tüpü'ü na? ¿Tsjan mpes quelel nucutsja jupj? ¿Ncu visyú si lapjüna jinwatsja jupj? ¿Ncu nenéyawa p'a casá jólatsja? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tsjan mpes tjalawú jupj nt'a? ¿Tsjan quelel nucutsja? ¿Ncu 'üsüs sa capyatsja? Nin tulucj. Niyom 'üsüs sin quípetsja pajal pülücj jatatj lovin. Jis wa po 'üsüs yustapj nt'a patja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tsjan mpes tjalawú Juan nt'a? ¿Tsjan quelel nucutsja? ¿Ncu profeta quelel nucutsja? Nin. T'üc' way profeta jupj. Más püné jupj p'a profetapan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dios Popel tjevele Juan po'ó pajal püna. Dios tjevele Juan jupj jomozo. Tjevele ca jas majamas jupj, ne ca 'ücj la mijis napj cuwistsja mpes. Tjevele Juan ca mveles napj mpes, mpes la p'a ca nus nucucj napj tjacuwis na. Ninana tjevelá: ‘Tjapjaca jipj. Namozo se jam, mwalá ca mim jipj lal. 'Ücj la mijis mpes, más 'üsüs ca nsem jipj jay na.’ ");
INSERT INTO jicNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juan más püné pjü püna tapatja jis lal, quina patja jis lal wa. Nin p'in, pjü way Dios si jütüta sin popé más noypan yupj jupj lal. Nin p'iyá tsjictjacj Dios si jütüta sin popé, más noypan yupj jupj lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Pjü tjepjyacan̈ Jesús tjevelá, pjü tjowelepj 'üsüstsja yupj jis lal Dios si jütütá. Nin p'iyá tjowelepj wa impuesto jat'anquepj. Juan bautizar lis tjiji yupj yas nam. ");
INSERT INTO jicNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mop'in fariseopan ma jisastsja Juan bautizar la siji, mpes ma bautizar lis tjiji. Niná Dios jostsja yupj la mijicj ma jisastsja yupj. Nin p'iyatsja Moisés popel sin 'yüsa lajay.) ");
INSERT INTO jicNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mpes Jesús tjevele: “¿'Oyn nyuca lajay quina patjá? ¿Pjacj jinwá yupj? ");
INSERT INTO jicNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tsjictjacj jinwá yupj, pülücj 'a si mulú nt'a. Tsjictjacj nenem ts'a 'in la p'a tsjictjacj jis lal, la p'a ma quelel pjelan̈ mpes. Mpes yümücj javelepj la p'a jis lal: ‘Nun ma quelel pjwelequé fiesta lijicj jinwá. Ma wa quelel pjwelequé tyoquecj jinwá. Cupj flauta la tjipjyusacj. ¿Tsjan mpes ma tjüpjwelequé, fiesta nt'a lajay jinwá? Locopyaya pajal tülü way tjenejets'equecj. Pajal 'aplijila jinwá la tjijicj. ¿Tsjan mpes ma la tupuyú, nujamica tepe'e jinwá?’ Nin javelepj tsjictjacj, pjelan̈ na. ");
INSERT INTO jicNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","”Nin p'iyá javelepj quina patjá Juan lal, napj lal 'ots'ipj. Juan el Bautista tjac' na, la pülücj ve ma tjelyaja. Uva 'üsǘ lovin ma tjümü'ü jupj. Mpes nun welé: ‘Lapanen jupj jos mo'o pü'ü. Nin mpes nin liji jupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Locopyaya napj tjacuwis. Napj p'iyá niná Yomen Dios jas tjejyamá. Napj ma lejay Juan liji jin. Ve lya napj. Uva 'üsǘ mü'üs napj. Newa nin malala wa welé napj nin po'ó. Nun welé napj pajal lya lovin. Welé 'üsǘ mü'üs, ne maná. Nun welé niyom impuesto jata'epj sejamica napj. Malala nyuca lajay sejamica napj, welé nun. Malala welé cupj cjay manas mpes. Nun ma solejé tsjan nujos nun. ");
INSERT INTO jicNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Cupj cjay manas 'üsüs lijicj. 'Üsüs tepyala Juan la tjiji mpes. 'Üsüs wa tepyala napj la tjejay mpes. Nin mpes ca jus cülayé cupj qjuiyólatsja 'üsüs. Nin lovin 'üsüs lajay jis lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yom pjaní Simón lotsja. Jupj fariseo watsja. Jupj tjevele Jesús lal jupj jostsja Jesús ncuwim, nlajas jupj lal. Mpes fariseo wo nt'a tjemey. Tjá'asa, tjelyaja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ne'aj p'in, pülücj patja nt'a, quepj tüpü'ü. Pjü salejeptsja malala nyuca la tjiji jupj yas nam. Niyom pülücj lal wínetsja jupj. Quepj jus nleya Jesús fariseo wo nt'a já'asatsja, lyájatsja jupj. Nin mpes ne'aj tjemey wa. Botella pajal 'üsüs justa teque'e jupj. Niná botella pe mpestsja, pe alabastro lotsja. Perfume botella jul tón̈catsja. ");
INSERT INTO jicNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesús cjüip'a'a tjemey, ton̈ca quepan, tsjom jyatsja nt'a. La tipiya jupj, quepan. Jesús tsjom jas tji'its'a jun la puyupj lal. Jay ts'üil lal tsjom tjicjyücja. Tsjom po la tje'yot'a jupj wola mpes. Perfume lal jas tjecjyo'la wa. Tjüwüi'i jupj Dios 'ücj perdonar liji malala nyuca lajay. Nin mpes tjac' jupj Jesús nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo tjinyuca wa quepj la tjijá. Fariseo p'iyá Jesús lal tjevele ncuwim, nlajas. Niná tjinyuca na, jólatsja: “Profeta tulucj yom niná. Profeta ca jus nlayes pjacj niná jupj po le 'et'é. Ca jus nlayes malala jupj. Malala nyuca liji quepj niná.” ");
INSERT INTO jicNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús seletsja nin jólatsja jupj, mpes jupj tjevele: —Simón, napj quelel velé jipj lal. Fariseo tjevele: —Mwü. ");
INSERT INTO jicNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mpes Jesús parábola tjevele jupj lal. Jas tji'yüsa la tjiji Dios nasa perdonar la tjiji quepan. Nin mpes quepj pajal quelel liji jupj. Ninana parabolas: —Yom pjaní t'emel prestar lis tjiji niyom mat'eyá, p'a jawas t'emel ca nca'actsja, jaylacj la mijictsja yupj. Pjaní way quinientos jaylacj ca la mijistsja, ma'ajapj cincuenta way p'in ca jaylacj la mijistsja. ");
INSERT INTO jicNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mop'in manas jis t'emel cjuwá. Ma polel jaylacj la tjajay. Nin mpes yom tjevele 'ücj lovin t'emel ma jaylacj lajay yupj. Jesús la tji'yüya fariseo lal: —¿Cana pajal quelel la mijis yomen? ");
INSERT INTO jicNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Más pülücj way leveltsja, más ca quelel la mijis jupj ca nacj —tjevele Simón. —T'üc' tjevelen jipj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús la nujuya, quepj tjinyuca, newa Simón lal tjevele. —Tjinyuca jipj quepj niná —tjevele jupj—. Jupj pajal quelel la niji. Nin tulucj jipj lal. Jipj ma quelel la nejay. Napj wya mo'ó tjacuwis na, 'üsǘ ntsjam la patsj ma ntje'an jipj. Quepj niná ntsjam tji'its'a jun la puyupj lal, jay ts'üil lal ntsjam tjicjyücja. ");
INSERT INTO jicNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jipj ma po la tje'yotj namas. Quepj niná janmacj ntsjam po la tje'yot'a jupj wola mpes nas tjacuwis na, pajal quelel la niji mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aceite pjaní jaylacj lal ma nay jas tjecjyolol nay pjucj. Perfume pülücj jaylacj lal ntsjam jas tjecjyo'la jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","T'üc' way malala nyuca la tjiji jupj yas nam, la pülücj malala nyuca la tjiji. Ma ca nin nola niswá. Pjü la tjiji, pjü perdonar la tjejay napj. Jupj pajal quelel la niji, mpes ca jus nlayen niná. P'a wa tsjicj way p'in quelel la niji. Nin mpes ca jus nlayen pjaní way p'in perdonar la tjejay jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús quepj lal tjevele wa: —Napj perdonar la 'ejay malala nyuca la tjejay. Ma nin nola quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","La p'a Jesús lal tjalá. Yupj yólatsja: “¿Tsjan mpes Jesús 'ücj perdonar liji quepj malala nyuca la tjiji?” ");
INSERT INTO jicNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús tjevele quepj lal: —Tepyon mpes 'i tjü'ü'sa, 'ücj ca cus ncon̈con Dios. 'Üsüs mim. ");
INSERT INTO jicNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Locopyaya Jesús tjuwine Galilea mo'ó la veles ne'aj tapatja jilal. Pülücj patja nt'a tjemey, más 'in la' way patja nt'a tjemey 'ots'ipj. Lovin p'a nt'a tjemey jis lal la veles Dios po'ó. Pjü jis walap'a'a tjevele tsjan 'üsüs tepyala quinam Dios 'üsüs la tjiji mpes. Tjevele Dios ca müjü'tüs nosis casá. Püna p'in Jesús niyom dóceya lis t'ya, ca yupj tsji' la mijicj jupj mpes. Yupj cus tocon̈ Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nequem nepenowá cus tocon̈ wa jupj. Jesús tji'yü'sa lis tjiji yupj yas nam malala jisastsja mpes. Lapanenpan nepénowa malala lis tjajay püná. Jis tji'yü'sa lis tjiji wa jupj. Quepj pjaní María lotsja. Magdalá mpe 'eseptsja jupj. Lapanenpan siéteya pje'á la ts'iya Jesús María jos mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Quepj p'a wa Juana lotsja. Chuza jats'om waytsja jupj. Chuza Herodes auxiliar waytsja jupj. Quepj p'a wa Susana lotsja. Cus tecyon̈ca wa. P'a wa nequem pülücj cus tocon̈ wa. Yupj yuts'a'á tja'ayapj 'ücj la püt'üs Jesús, 'ücj jis la patj wa Jesús apostolpan dóceya. ");
INSERT INTO jicNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pajal pülücj 'a jis tjimyula Jesús nt'a. Newa p'a mpe tjiquil p'a wa pülücj patja mpe. Pülücj 'a si mulutsja na, parábola tjevele Jesús, sin la 'üsüs jis la jay. Ninana Jesús tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yom setel sine wínetsja. Na'aj li ts'iyá sínetsja jupj. Mpes sine na, setel nepenowá palá tinca jümücj casá. Mpes palá ta'á tjajatsj setel. Tsipyaya tjalá wa setel niná. ");
INSERT INTO jicNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Setel nepenowá peme casá palá tinca. Tecyojo na, ts'its'e tepyala 'üsǘ pja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Setel nepenowá jam nt'a palá tinca. 'A mulú si t'ünǘ. Pajal qjuisiyama tepyala, mpes jupj sínetsja ma si t'ünǘ. ");
INSERT INTO jicNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Setel nepenowá 'amá 'üsüs casá palá tinca. Tecyojo, jis t'yüna. Pülücj tjevelan̈ yupj. Setel pjaní sine popé setel cien tjevelan̈”, tjevele Jesús. Parábola t'üc' tjevele na, yümücj tjevele: “Najas pjü tjapja'aqué, pjü nusin tjü'üsüs napj tjevelé”. ");
INSERT INTO jicNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Locopyaya jupj discipulopan la tjü'üy jupj lal tsjan sin 'yüsa lis tjiji parábola mpes. Yupj salejeptsja ma setel po'o tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús jis wala tjevele: “Dios ma se 'aya pjü gente sin 'yüsa 'oyn nyuca jyü'ta jupj. Jupj nu 'yaya nun ca nusin mü'üsüs niná. P'a jilal parábola mpes sin 'yüsa lejay la p'in. Mpes t'üc' ca nsem niná: ‘Yupj januc, newa ma yola se palá tsjan mpes januc niná. Yupj pjyacan̈, mop'in ma sin 'yüsa.’ ");
INSERT INTO jicNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”Ninana nusin 'yüsa lejay parábola mpes: setel Dios tjevelá jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Setel nepenowá jümücj casá palá tinca, nepénowa pjyacan̈ jinwá. Dios tjevele tjepjyacan̈ yupj. Locopyaya diablo jac', t'e'enca yupj tjepjyacan̈. Yo' pe'e liji jupj. Diablo ma jos yupj japon Dios tjevelá. Ma jos yupj ca 'ücj mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","”Setel peme casá palá tinca, nepénowa pjyacan̈ jinwá 'ots'ipj. Dios tjevelá pjyacan̈ na, po 'ücj jisas japon yupj. Mop'in ma lajay Dios jos jin. Tsjutsj ts'üil cjuwá jinwá yupj. Tsjicj way japon la p'in. Locopyaya diablo malala vele yupj jis lal, mpes yupj quelel malala nyuca lajay. Malala nyuca quelel lajay na, ma nin lajay Dios tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","”Setel nepenowá jam mo'o palá tinca, nepénowa pjyacan̈ jinwá 'ots'ipj. Dios tjevele tjepjyacan̈. Newa ma lajay Dios tjevele jin. Pajal nin yola malala pyala mpes. Po jisas t'emel. Po jisas yupj ca 'ücj jisas nsem nosis nt'a. Nin mpes ma 'üsüs lajay yupj, Dios jos jin. ");
INSERT INTO jicNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","”Setel p'a wa 'amá 'üsüs casá palá tinca, nepénowa pjyacan̈ jinwá yupj 'ots'ipj. Yupj pjyacan̈ Dios tjevelá. Ma yo' pe'e. Po 'üsüs witjacj yupj. Ma la tsuwil. Malala pyala na, newa 'üsüs lajay Dios jos jin. Nin mpes t'üc' lajay Dios tjevele jin”, nin tjevele Jesús Dios Popel pjyacan̈ mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús p'a parábola tjevele yupj jis lal. Ninana tjevelá: “Yom yo je si müjü na, ma tsjo'oy lal jun t'yo'na. Ma cjan 'alá 'yonsa jupj. Campanya si jünsa, mpes pjü wama jiquil pjü 'ücj januc jupj 'owus. ");
INSERT INTO jicNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nin p'iyá Dios ma pjo'na jupj quelel sin 'yüsa liji. Püna ma jis tje'yaya sin la 'üsüs, niná pjü way ca sin mü'üsüs la mijis. Püna ma sin tji'yüsa, niná ca jus nlayecj. Niná 'ücj ca jus nucucj nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mpes 'in tjajama 'üsüs tjapja'aqué Dios velá. Nun quelel nusin 'yüsa, p'a wa ca nusin mü'üsüs la mijis jupj. Nin p'iyá pjü jis lal. Dios jisas, mpes ca sin mü'üsüs. Nepénowa ma quelel sin 'yüsa. Pjyacan̈ p'in. Mpes ma ca polel sin 'yüsa Dios mpes. Sey c'a ca la mijis jupj. Yupj yola yupj sin 'yüsa Dios mpes, sin 'yüsa tulucj yupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús jamay tjac' jus la nuc, jüpülücpan tjiquil wa jupj nt'a. Mop'in ma polel ne'as tjil Jesús nt'a, pülücj tantan tjatja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nin mpes ne'aj tjatja sin popa pjaní tjevele jupj lal: —Jemay pje'á ton̈ca, pyülücpan pje'á lejen̈ wa yupj. Quelel jis januc yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús jupj wola tjevele: —La p'a wa namay jinwá yupj napj lal, mpülücpan jinwá yupj napj lal. Yupj pjyacan̈ Dios velá, lajay wa jupj vele jin —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","P'a jyawca na, barco wama tjemey Jesús jupj discipulopan jis lal. Tjevele yupj jis lal: —Mas 'üsǘ püné na'aj po'ó. Mpes tjil. Pajal la püné, pajal campwila waytsja 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tjil na 'üsǘ casá, tüpü'ü, tjejyá Jesús barco mo'ó. Tjejyá na, pajal jas tjelyapjünǘ lüpjüs 'üsǘ püné nt'a. 'Üsǘ la tjepjetpjets'é mpes 'üsǘ wama tjemey barco mo'ó, mo'o ca mpit'as. Nasa quelel pwila jama barcas. ");
INSERT INTO jicNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mpes jupj discipulopan jupj nt'a tjil, jas tiquilquil, tjowelepj: —Qjuis Jepa, qjuis Jepa, qjuis qjues nt'ancam. Jesús tsyülümǘ, jis capj tjeve'le lüpjǘ, 'üsǘ 'ots'ipj. Mpes lüpjǘ 'üt'ün nasa tepyala. Nin p'iyá 'üsǘ tji'yü'sa quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Discipulopan jis lal tjevele Jesús: —¿Tsjan mpes ma poné napj ca nucopj mp'acj? Lacj tjeyapj yupj. Pajal yólatsja Jesús la tjiji mpes. Yuwá tjowelepj: “T'üc' way yom niná pasal püné way. 'Ücj si jütüta lüpjǘ, 'üsǘ püné 'ots'ipj, ne nin lajay jupj jyü'ta jin.” ");
INSERT INTO jicNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Locopyaya 'üsǘ na'aj po'ó tjil, Gadara mo'ó. Gadara 'üsǘ na'aj po'ó Galilea lal. ");
INSERT INTO jicNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Barco mpe pje'á tjemey Jesús. 'Amá casá ton̈ca naya, yom tjac' pülücj patja nepé la nüjüsü Jesús. Lapanenpan tapatja yom jos mo'ó, tjüjütütj jupj. Püs way jas pjütpjüt' tüpü'ü jupj. Ma wo mo'ó tüpü'ü; panteón nt'a tüpü'ü. ");
INSERT INTO jicNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jupj Jesús jus tjinyuca na, yümücj la tipiya, tüic' jin tjüjünsü Jesús wolap'a'á. Yümücj tjevele: —¿Tsjan mpes napj nt'a tjacuy? Jesús jipj. Dios Jatjam jipj. Más püné way Dios pjü jis lal. La 'e mon ma malala la mijin napj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yom jactsja na, Jesús tjijyü'ta ca pje'á mim lapanen yom jos mpe, mpes nin tjevele yomen. Püna la pülücj lapanen pajal malala la tjiji jupj lal, mpes gente ne'aj patja tjajamapj jupj. Mos t'asiyú tsupaptsja, tsjom t'asiyú tsupaptsja wa cadena mpes, acero mpes wa. Mop'in tsjan mpes tsupaptsja t'anca jupj, ne lapanen tjemyana jupj wa cjuwá nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús la tji'yüya jupj lal: —¿Tsjan lyá jipj? Yom tjevele: —‘Pülücj’ napj nlá. Lapanenpan pülücj jos mo'o tapatja ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lapanenpan pajal la tjomon Jesús lal jupj ma ca jis müjü'tüs mal jul pajal campwila mo'ó, lapanenpan jis capj tyüla nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne'aj p'in yupj tjelejen̈ nt'a malana pülücj tjelyawun̈, tjalá yupj neven nt'a. Lapanenpan pajal la tjomon Jesús lal jupj ca jis ma'ayas mal malana jisas mo'ó. Jesús jis tje'yaya nin la mijicj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tjil yom jos mpe. Malana jisas mo'o tjil yupj. Nin la tjajay na, malana pjü ts'equenen̈ neven palavin; 'üsǘ püné mo'o tjil yupj. Jis qjues t'anca, tecya'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Malana jajamapj niná tjunuc na, ts'equenen̈ yupj. Pülücj patja nt'a tjowelepj nin tepyalá. Wa pjaní pjaní lejen̈ nt'a tjowelepj wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mpes pülücj tjil jis la nuc tepyalá. Jesús nt'a tjil. La nyüjüsün̈ yomen, 'in lacasana lapanenpan jupj jos mo'o tapatja. Jesús wolap'a'a tjá'asa. Sacapyá quinam jupj, 'ücj jólatsja quinam. Lacj tjeyapj yupj nin tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","P'a witjacj tjunuctsja Jesús tji'yü'sa la tjiji yomen. Mpes tjowelepj la p'a jis lal 'onin ne yom niná tji'yü'sa quinam. 'In lacasana lapanenpan jupj jos mo'o tapatja. ");
INSERT INTO jicNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nin mpes pjü Gadara mo'o tapatjá, pjü la tjomon Jesús ca mim yupj nepé. Pajal lacj tjeyapj, ne nin la tjomon yupj. Mpes barco wama tjemey Jesús, tjemey niswá Galilea nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Custjay ma tjemey na p'in, niná yomen, lapanenpan jupj jos mpe tjil p'iyá, tjevele Jesús lal. La tjemyona Jesús lal jupj ca ma'ayas jupj lal jama. Jesús ma jostsja jupj ca mim quinam. Jesús jupj wo nt'a jas tjejyama, tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Niswa wya nt'a jutja. La p'a jis lal ca mvelen pajal 'üsüs way la tjiji Dios jipj mpes. Mpes tjemey yomen, la tjiji Jesús tjevele jin. Pjü jis wala tjevele ne'aj pülücj patja nt'a. Tjevele pajal 'üsüs way la tjiji Jesús jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús 'üsǘ na'aj po'ó ne'as tjemey na, pülücj 'a jis tjimyula ne'aj. Po 'ücj jisastsja Jesús la nyüjüsün̈. Püs way la tjunuc jupj ncuwim. ");
INSERT INTO jicNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne'aj yom tjac' Jairo ló. Jepa waytsja jupj judiopan 'a si mulú nt'a. Jupj wola 'amá 'alá tje'yonsa Jesús wolap'a'á. Pajal la tjemyona Jesús lo cuwis jupj wo nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jupj jucucus nasa quelel pé'etsja ne nin. Jairo popa pjaní waytsja jupj, año dóceya tyá'atsja jupj quinam. Mpes tjemey Jesús. Tjemey na, pülücj jis capj tocon̈, cus tjeletjatj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ne'aj tjac' wa quepj malala jos. Año dóceya newa 'os tepyálatsja, ma tji'yü'sa. Pjü jupj t'emel jis tje'yaya doctor witjacj, leméliyu jaylacj. Pjü ma polel 'yü'sa la tjajay jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jupj Jesús cjüip'a'a tjac' quinam, jas quip po'o velan̈ po la tje'yot'a. Len̈ way tji'yü'sa jupj. 'Os tjapjaja. ");
INSERT INTO jicNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús jis la tji'yüya ne'aj lejen̈ jis lal: —¿Pjacj nin po la tje'yot'a? Pjü tjowelepj ma nin la tjajay yupj. Pedro tjevele: —Nejepa, pülücj tantan t'asiyú lejen̈ jipj nt'a, cyapj jaletjatj. Pülücj jin po la 'otj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Niswa tjevele Jesús: —T'üc' way pjaní way nin po la tje'yot'a. Pjaní tji'yü'sa la tjejay jin najastsja napj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Quepj jus nléyatsja ma polel pjo'na, ne tjac'. Ticyücüyǘ, pajal lecj tjeyá mpes. Jupj wola 'amá 'alá tje'yonsa Jesús wolap'a'á. Pjü jis walap'a'a tjevele tsjan mpes po la tje'yot'a Jesús. Tjevele len̈ way tji'yü'sa jupj, po la tje'yot'a na. ");
INSERT INTO jicNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús tjevele jupj lal: —Ncucus, jipj tepyon napj polel 'i 'ü'sa lejay, mpes 'i tjü'ü'sa jipj. Ma nin jele t'as. 'Üsüs mim quinam jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Newa quepj lal véletsja na, yom tjac' jepa wo mpe, tjevele jepa lal: —Tepe'e cyucus. Po ma pajal la tjemyona qjuis Jepa lal quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús nin tjapjaca na, Jairo lal tjevele: —Po ma lecj tjeyá. Mponen p'in napj polel cyapj p'yacj ne cü'ü'süs ca jupj. (Jupj seletsja jupj ca 'üsüs la mijis, mpes nin tjevele.) ");
INSERT INTO jicNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wo nt'a tjac' na, Jesús ma jis tje'yaya pjü way wama tjil, cus la con̈. Nepénowa cus tocon̈ p'in, Pedro pjaní way, Juan pjaní way, Jacobo p'a wa, tsjicj jamay p'a wa, popay p'a wa. ");
INSERT INTO jicNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","La p'a pülücj pajal yümücj la puyuptsja. 'Aplijílatsja tsjicj tepe'e mpes. Jesús tjevele yupj jis lal: —Po ma la tupuyú. Ma tepe'e, tjejyá p'in. (Jupj seletsja jupj ca 'üsüs la mijis, mpes nin tjevele.) ");
INSERT INTO jicNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yupj tjuwi'in̈, la tjüpjüts'ün Jesús. Salejeptsja t'üc' way tepe'e tsjiquis. ");
INSERT INTO jicNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús pjü sin tjejyama tjil yupj. Tsjicj tepe'á mos ntjüi'le, yümücj tjevele: —Tsjicj, jin tjijyünsa. ");
INSERT INTO jicNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mpes jupj cjües tjac' niswá quinam. Len̈ way jas tjijyünsa, nyucunú tepyala. Jesús jis tjijyü'ta lo 'ayas lo las tsjiquis. ");
INSERT INTO jicNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tsjicj jamay, popay po yólatsja Jesús 'üsüs la tjiji mpes, mop'in nin Jesús jis tjijyü'ta ma jis la veles p'a jis lal ninana tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús 'a jis tjimyula lis tjiji jupj discipulopan dóceya. Jis tje'yaya 'ücj pje'á la ts'i pjü lapanenpan. Jis tje'yaya wa 'ücj si 'ü'sa lis mijicj malala jisas. ");
INSERT INTO jicNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nin la tjiji na, sin tjejyama jis la veles pülücj jis walap'a'á Dios mpes. Jis tjijyü'ta ca nin mvelecj 'onin si jütüta Dios. Sin tjejyama malala jisas la 'ü'süs lis mijicj 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ninana Jesús tjevele yupj jis lal: “Nun nasa lowú tsji' lojí napj mpes, ma ca nt'a nun p'a jawasa nujos mpes. Po ma tjacjaj t'o, 'opopa ma t'o wa, ve ma t'o wa, t'emel ma t'o wa. Ma wa ca mát'eya nsem nusin quip. ");
INSERT INTO jicNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wa pjaní nt'a ja'ayapj nu la püt'üs nun, janmacj jupj wo nt'a mpatjaqué yupj patja nepé lowú nas. ");
INSERT INTO jicNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","”Nepénowa ma ca jisas nsem nun tjuculá. Ma ca jisas nsem nun welé napj mpes. Nenéyawa nin ca nsem pülücj patja nt'a. Mpes lowa yupj mpe. Lowú na, nun jis tsjam sin tjowowojó, ca palá ntüncüs pjüpjüs. Nin mpes ca sin mü'üsüs la müjí Dios ma japon jinwá yupj quinam”, nin tjevele Jesús niyom jupj sin tjejyama jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mpes tjil niyom dóceya. 'A mulú patja nt'a tjelyawun̈. T'üc' tjowelepj na, p'a nt'a tjil lovin. Newa pülücj jis walap'a'a tjowelepj tsjan 'üsüs tepyala quinam Dios la tjiji mpes. Malala jisas jis tji'yü'sa lis tjajay wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes tjapjaca wa Jesús la tjiji po'ó. Tjapjaca wa jupj apostolpan la tjajay po'ó. Herodes jepa waytsja Galilea nt'a. Pajal lapj jólatsja jupj tjapjaca mpes. Ma seletsja jupj pjacj ne Jesús. Nepénowa javeleptsja Jesús ne Juan el Bautista. Juan tepe'e püna p'in. Yupj tjowelepj Juan jas tjijyünsa, niswa pǘ'ütsja. ");
INSERT INTO jicNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nepénowa javeleptsja Jesús ne Elías. Elías profeta püné püna tüpü'ü jupj. Nepénowa javeleptsja p'a profeta Jesús. Tjowelepj jupj püna tepe'e, jas tjijyünsa, niswa pü'ü p'in jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes ma tepyona yupj tjowelepj. Tjevele: “Juan tulucj jupj. Juan mwen taná tjejyocj, tji'yünan jupj. ¿Pjacj niná? Jupj ne pajal 'üsüs liji mpes javelepj.” Herodes po quelel nyúcatsja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolpan tjiquil Jesús sin tjejyama mpe. Tjiquil na, Jesús lal tjowelepj tsjan la tjajay yupj. Püna p'in sin tjejyama tsji' la mijicj jupj mpes. Quina Jesús yupj jis lal tjemey Betsaida nt'a, pülücj patja nt'a. Yusapj tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mop'in yusapj tuluctsja. Pajal pülücj jus nlay jupj tjemey, mpes jupj nt'a tjil yupj. Jupj 'ücj jos la nüjüsü yupj. Tjevele wa yupj jis lal 'oyn nyuca jyü'ta Dios. Malala jisas jis tji'yü'sa lis tjiji 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","T'awaná tepyala, nasa quelel t'yaja. Mpes Jesús apostolpan dóceya tjiquil jupj nt'a, tjowelepj jupj lal: —Pjü sin tjejyama, ne'aj ca mal jis wa nepénowa lejen̈ nt'a, jis wa pjaní pjaní lejen̈ nt'a 'ots'ipj. Ca la mpalacj ca'aj 'ücj ca mpatjam, müjünan̈. Ve jaylacj ca la mijicj jis la las yupj. Cjuwá jis wa qui'á. ");
INSERT INTO jicNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús jis wala tjevele: —Nun p'iyá jis ma'ayá nlajacj. Niyom tjowelepj: —Pan cínquiya tya'acj p'in, cjul mát'eya tya'acj p'in. ¿Ncu jyas cupj ca nlaca ve jaylacj la mijicj pjü jis la las? ");
INSERT INTO jicNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Niyom pajal pülücj, sey cinco mil ne'aj tjatja ne nin. Más 'in pülücj waytsja ca nacj, más 'in la' way ca nacj. Pülücj pajal. Jesús tjevele jupj discipulopan jis lal: —Jis müjü'tǘ majatjum pjü. Cincuenta cincuenta 'a mulú ca majatjum yupj. 'Ücj nepénowa más 'in pülücj 'a mulú jatja, nepénowa más 'in la' way jatja yupj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Discipulopan nin la tjajay. Jis tjüjütütj pjü majatjum, mpes tjatja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús pan cínquiya nt'ya, nt'ya wa cjul mat'eyá. Tsjun po'o tjinyuca, tjevele Dios lal tjüwüi'i ve tje'yaya mpes. T'üc' tjevele na, la tjelepta taná pansas. Nin p'iyá cjul la tücüeme wa. Jis tje'yaya discipulopan jis la 'ayas ne'aj tjatjá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yupj pjü way t'üc' tjalá. Pjü jis col pit'a tepyala yupj. Ma polel pjü tjalá yupj. Yupj ma tjalá, quiliyú mo'o t'olon quinam discipulopan. Quiliyú dóceya tipit'a pan tsjictjacj lal, cjul tsjictjacj lal wa. ");
INSERT INTO jicNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","P'a jyawca na, Jesús jusapj Dios lal tjevele. Discipulopan ne'aj p'in tjatja jupj nt'a, ne jupj jis la tji'yüya: —¿Pjacj ne napj jin javelepj gentas? ");
INSERT INTO jicNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yupj jupj wola tjowelepj: —Nepénowa javelepj jipj Juan el Bautista p'iyá. Nepénowa javelepj jipj Elías, püna tüpü'ü p'iyá. P'a wa javelepj profeta p'a wa jipj. Püna 'i tipü'í, jin tjijyünsün, niswa püt', nin javelepj gentas. ");
INSERT INTO jicNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús nin p'iyá la tji'yüya discipulopan jilal: —Ne nun ¿pjacj ne napj jin nujola nun? Pedro wola tjevele: —Cristo jipj. Jipj ne Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. Jipj mpes ca 'üsüs mpatjaquecj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús pajal jis tjijyü'ta ma ca nin mvelecj p'a lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tjevele: —Napj p'iyá niná Yomen Dios jas tjejyamá. Dios jos pajal malala ca ma palas napj quinam. Co'müypan ma ca jisas nsem napj. Nin p'iyá sacerdote noypan. Nin p'iyá Moisés popel sin 'yüsa lajay. Ma ca jisas napj yupj. La p'a ca ma 'ü'nacj. Ntjü'ünan tyan, ts'ac' cont'e naya ca nin müjünsǘ. Ca mpü'üs niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesús tjevele wa pjü jupj discipulopan jis lal: —Nun popa quelel ncapj cyon̈ca, ma ca nin la mijis jupj jos jinwá. Nin ca la mijis napj lejay jinwá. Napj cruz po'ó ca ma pats'. Malala ca mpalas wa jupj, ncapj cyon̈ca mpes. Jupj ca jas mü'üsüs napj mpes. Pjü jyawca ca jola nsem 'ücj nsem jupj lal malala pyala jupj lal, ncapj cyon̈ca mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nepénowa ca quelel jis capj mp'a'sacj yupj p'iyá. Ma ca jisas malala se palá, mpes ca mvelecj napj lal japon tulucj. Yupj ma ca mpatjam Dios lal. Nepénowa nca'lin̈ napj lal japon mpes. Más 'üsüs ca jis mpalas yupj la p'a jis lal. Yupj lovin ca mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nepénowa pülücj jatatj nosis nt'a, mop'in ma polel patja Dios lal. Pjü way jatatj nosis nt'a ca nacj. Newa 'üsüs tulucj pjü niná, yupj ma polel patja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","”Napj p'iyá niná Yomen Dios jas tjejyamá. Nun nu tjemaycas napj mpes, ne mayca wa ca nsem napj nun mpes, niswa tjacuwis na. Nun nu tjemaycas napj velé mpes, ne mayca wa ca nsem napj nun mpes, niswa tjacuwis na. Niswa cuwis na, pjü ca nucucj pajal püné way napj, Mpapay jinwá. Ncuwis Dios angelpan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nepénowa nun popa ca nucú Dios ca müjü'tüs nosis nt'a. Custjay ma taca'liqué na p'in, nun ca nucú niná. T'üc' niná —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ts'ac' ocho tjejyawca na, más 'in pülücj ca nacj, más 'in la' way ca nacj, joc' mo'o tjemey Jesús la veles Dios lal. Pedro lal tjemey, Juan lal tjemey wa, Jacobo lal tjemey wa. ");
INSERT INTO jicNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús Dios lal véletsja na, jupj wola p'a casá justa tepyala. Jas quip pje tepyala, tjejyawca, menmené jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Len̈ way niyom mát'eya lay jis tepyala, Moisés pjaní way, Elías ma'ajapj, püna tapatja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jisas jaw yustapj lay jis tepyala yupj, Dios pü'ü nt'a yustapj jinwá. Jesús lal tjowelepj. Tjowelepj 'onin ca mpa'is jupj Jerusalén nt'a. Dios jostsja ca nin mpalas ne quina ca nsem, tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro po ja vyatsja. Nin p'iyá niyom p'a wa. Tjijinan̈ yupj. Jis tsyülümǘ na, tjunuc Jesús po 'üsüs jas jaw jústatsja. Tjunuc wa niyom mát'eya ne'aj lejen̈tsja jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Locopyaya niyom mát'eya quelel jiltsja Jesús nepé. Jiltsja na, Pedro Jesús lal tjevele: —Nejepa, po 'üsüs qui'á jyatjaquecj. Ts'epjel cónt'eya ca sin müjünsüm cupj. Pjaní way jipj mpes ca nsem, pjaní wa Moisés mpes ca nsem, pjaní wa Elías mpes ca nsem. Pedro molo tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nin véletsja na, mol lay tepyala, palá tjac' yupj jis capá nt'a. Mol t'asiyú ton̈ca, mpes discipulopan pajal lacj tjeyapj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mol nepé vele pjactsja. Tjevele: “Niná napj Natjam. Napj la t'ya jupj. Tjapja'aqué jupj velá.” ");
INSERT INTO jicNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","T'üc' tjevele na, Jesús jusapj ton̈ca tjunuc yupj. Nin tepyala na, discipulopan ma tjowelepj la p'a jis lal yupj tjunuc joc' mo'ó. Yuwá p'in tjowelepj niná. ");
INSERT INTO jicNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yaya joc' mpe palavin tjiquil. Palavin tjiquil na, pajal pülücj Jesús nt'a tjiquil la nyüjüsün̈. ");
INSERT INTO jicNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yom pjaní yupj sin popa yümücj tjevele: —Po najas jipj ca cus mp'a'san natjam. Napj mpopa pjaní way jupj. Jusapj way jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lapanen tjüi'le jupj neneyawá. Ntjüi'le na, len̈ way li piyú natjam. Jun jyu'ya, pajal cyücüyǘ wa, mpes lampe p'yoya. Lapanen malala liji jupj lovin. Ma quelel jama jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Napj la tjemyon jipj discipulopan jis lal yupj ca pje'á la nts'iyacj lapanen. Ma polel nin lajaytsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús jis wala tjevele: —Nun ma poné napj lal. Malala nujola pajal. Pajal püs li nuc nun ca mponé napj lal. Püs way tüpü'üs nun lal quinam. Tjevele wa yom lal: —Jetjam lal ncuwim napj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yom jatjam jactsja na, lapanen palá la ts'iya jupj. Jun jyu'ya, cyücüyǘ la tjiji. Jesús cus tjeve'le lapanen. Tji'yü'sa la tjiji yom jatjam, niswa tje'yaya popay. ");
INSERT INTO jicNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pjü ne'aj po yólatsja pajal 'üsüs la tjiji Jesús. Pajal püné Dios, yólatsja yupj. Newa nin yólatsja, Jesús pjü way 'üsüs la tjiji mpes. Mop'in nin, jupj tjevele jupj discipulopan jilal: ");
INSERT INTO jicNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Nusin tjü'üsüs niná napj ca mvelé. Napj p'iyá niná Yomen Dios jas tjejyamá. Dios ca ma'ayas niyom ca malala la ma jicj yupj jisas jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yupj ma sin tji'yüsa jupj tjevelá. Dios ma jis tje'yaya sin tji'yüsa, mpes nin. Yupj lacj tjeyapj mpes ma quelel la 'üytsja jupj tsjan mpes nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Discipulopan pajal nin yólatsja cana yupj popé más püné nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús jus nléyatsja nin yólatsja yupj, mpes tsjicj way tecyumaná, t'empe way tjijyünsa. ");
INSERT INTO jicNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tjevele yupj jis lal: —Najas nun ma nujola noypan nun p'iyá. Najas 'üsüs lojí la p'a jis lal napj mpes. 'Üsüs lojí na tsjicj niná lal, t'üc' way 'üsüs lojí wa napj lal. 'Üsüs lojí na napj lal, t'üc' way 'üsüs lojí wa Dios lal, jupj ne nin tjejyama qui'á. Nin mpes velé nun popé más 'in tsjicj way jin jola jupj p'iyá pjü way jis lal, más püné way jupj p'a lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan tjevele Jesús lal: —Nejepa, jus tjinyucucj yom p'a wa lapanenpan pje'á li ts'iyatsja jupj. Jipj lyá tjevele mpes lapanenpan pje'á la ts'iya. Tjevelecj jupj lal ma nin ca la mijis jupj, ma ncuwa popa ne. ");
INSERT INTO jicNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús tjevele jupj lal: —Po ma müjü'tǘ jupj ma ca nin la mijis. Jupj p'a casá jola nun lal tulucj, nucopj p'ya'sa p'in jupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Len̈ way Dios quelel myánatsja Jesús tsjun po'ó jupj pü'ü nt'a. Püna p'in Dios tjevele 'ona ca mpalas. Mpes Jesús po quelel jámatsja Jerusalén nt'a. Jostsja ca Dios jos jin mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús mwalá sin tjejyama niyom nepenowá Samaria nt'a, pülücj patja nt'a. Quelel 'ücj lajaytsja ne'aj way mpü'üm, majas Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma polel nin la tjajay yupj. Samaria mo'o tapatja ma jisastsja ne'aj ncuwim Jesús, Jerusalén nt'a quelel jámatsja mpes. (Samaria mo'o patja ma jisas Jerusalén mo'o patjá.) ");
INSERT INTO jicNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesús discipulopan mat'eyá, Jacobo pjaní way, Juan p'a wa, jus nlay yupj ma jisastsja Jesús ncuwim, mpes yupj tjowelepj Jesús lal: —Qjuis Jepa ¿ncu jyas ncupj jyü'tücj 'awa palá nyacas tsjun nepé, jis mü'ümüs yupj pjü? ");
INSERT INTO jicNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nin tjowelepj mpes Jesús la nujuya, yus tjinyuca, jis capj tjeve'le. Malálatsja jupj lal nin la mijicj yupj. Tjevele: —Nun ma solejé pajal malala welé, niná welé na. ");
INSERT INTO jicNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Napj niná Yomen Dios jas tjejyamá. Napj tjacuwis jis capj la p'acj nosis casá patjá, ca yupj mpatjam Dios lal. Ma najas malala se palá ne ca ma mpatjam Dios lal —nin tjevele Jesús. Nin tjevele na, p'a nt'a pülücj patja nt'a tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jümücj casá jiltsja na, yom pjaní tjevele Jesús lal: —Napj ca cyapj ncon̈ jun ta'á jipj quelel jay nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús tjevele costa way cus la con̈ jupj. Tjevele: —Gato selván yupj jis jomwen jul jinan̈, tsipyaya yupj jis tsintsil lajay. Nin tulucj napj lal; napj nawá 'a cjuwá. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús tjevele yom p'a wa lal: —Ncapj tecyon̈ca. Yom niná tjevele: —Ntje'aya la nuc mpa'is mpapay p'in. Tepe'e na ca cyapj ncon̈. ");
INSERT INTO jicNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús tjevele ma polel la nuc jupj cus la con̈. Tjevele: —La p'a wa 'ücj 'amá jis la toc jis pülücj tepe'e na. Yupj p'iyá tecya'lin̈ jinwá, yupj ma japon Dios lal. Jipj ca mim, mvelen pjü jis walap'a'á Dios mpes. Ca mvelen Dios ca yupj jis Jepa nsem quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yom p'a wa Jesús lal tjevele: —Nejepa jipj. Cyapj ncon̈ p'a jawas. Ntje'aya mis mvelé jum wa nepé mwalá way p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús tjevele jupj lal: —Püna la tjejay po jyas custjay, jipj ma polel lejay Dios 'i jütütá. Nin p'iyá jipj le ts'ec na ma cjüipe nyuc jipj. Cjüipe nyuc, jipj ma polel 'üsüs tsji' lejay. ");
INSERT INTO jicNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Locopyaya qjuis Jepa Jesucristo niyom p'a wa lis t'ya, tsji' la mijicj Dios mpes. Setenta lis t'ya jupj. Mwalá sin tjejyama yupj jupj quelel jámatsja nt'a. Mat'e mat'e sin tjejyama. Pülücj patja nt'a sin tjejyama. Pjaní pjaní patja nt'a sin tjejyama wa. Jun ta'á jupj quelel jámatsja nt'a sin tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Niyom setenta jis lal tjevele: “Pülücj 'ücj ca cus ncon̈cocj Dios, quina ma sa con̈ jupj custjay. Pülücj velan̈ jinwá yupj. Namozopan po pjaní way. Costa way pjü jilal la cuwis yupj. La moná Dios lal mozopan más pülücj ca sin majamas, más pülücj jilal ncul Dios nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","”Lowa quinam. Nusin tji'yüsa: napj p'iyá nusin jyam malala witjacj nt'a. Napj selé nun ma polel nucopj p'o'sá nun p'iyá. Oveja tsjictjacj jinwá nun. Coyote jinwá ts'a 'in yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lowú na, po ma t'emel t'o nun. Po ma ve t'o nun. 'Ücj jis la t'as caitas, mop'in caite p'a wa ma ca nt'a. Nujola t'as Dios mpes tsji' lojí. Po ma nu tyantaná nu la lapaná. ");
INSERT INTO jicNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”Wo pjaní wama lowú na, lovin mwalá way mvelé: ‘Dios pajal 'üsüs la siji wosis niná nt'a patja jilal, ne yupj ma ca malala nyuca yola ncu ca malala mpalas’. ");
INSERT INTO jicNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ca nacj wa nt'a pü'ü quelel 'üsüs pü'ü Dios lal, mpes jupj ca 'üsüs mpü'üm nun nin tjowelé mpes. Jupj ma quelel 'üsüs pü'ü Dios lal, ma ca nin cüpalas nun tjowelé. Nun p'in ca 'üsüs mpatjaqué custjay. Ma ca malala nyuca nujola nun pjü mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nun mwalá tjüjünaqué nt'a newa müjünaqué. Tjalajá, müsiqué wa yupj nu ja'ayapj. Pjaní tsji' liji na p'a wa mpes, p'a wa ca ma'ayas jupj, tsji' la tjiji jaylacj. Nun tsji' lojí napj mpes. Nin mpes 'ücj nu ja'ayapj yupj. Po ma wosis wosis nlawú la moná müjünaqué ne'aj. Po ma p'a la tjomoná, nasa to'á quinam 'ücj jünaque nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","”Ca nacj pülücj patja nt'a lowú na, yupj ca jisas tjuculá, ca jisas ca nacj nun welé yupj jis lal Dios po'ó. Nin tepyala na, lovin tjalajá yupj nu ja'ayapj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ne'aj way ninana ca la müjí Dios mpes tsji' lojí mpes. Malala jisas jis tjü'ü'süs lis tjüjí. Ne'aj patja jis lal tjowelé: ‘Dios jyü'ta. Quelel jyü'ta quinam nun nt'a.’ ");
INSERT INTO jicNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nenéyawa pülücj patja nt'a tjalawú na, yupj ma ca jisas nsem nun tjuculá, ma ca jisas nsem nun welé yupj jis lal Dios po'ó. Nin tepyala na, jis wa nepé jümücj campalanya lowa. Tjowelé: ");
INSERT INTO jicNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘'Üpjǘ qjuis tsjom pü'ü nun potjaqué popé se wowojocj. Nun ma jisastsja cupj tjevelecj Dios mpes, ne nin la tjijicj. Nusin tji'yüsa niná: Dios jyü'ta. Quelel nu jyǘ'tatsja wa nun, nin p'in ma nujostsja.’ Nin ca mvelé nun. ");
INSERT INTO jicNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","”Yupj ne'aj patja ma jisastsja nun tjowelé Dios mpes, Dios pajal ca jis capj ntülüs p'a jawas, malala lajay jis capj tyüla na. Nin liji na, más malala nsem yupj jis lal Sodoma mo'o tapatja jis lal. T'üc' niná”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tjevele wa pülücj patja nepénowa mpes: “Malala ca nu mpalas, Corazín mo'o potjaqué. Malala wa ca nu mpalas nun, Betsaida mo'o potjaqué. Pajal nola nun mpes. Napj namozopan pajal 'üsüs la tjajay nun nt'a, gente p'in ma polel lajay jinwá. Nun nujola Tiro mo'o patja pajal malala. Sidón mo'o patja pajal malala, nujola nun. Nun p'in malala. Napj namozopan pajal 'üsüs la cüjaytsja yupj nt'a, nun nt'a la tjajay jinwá, yupj püna ca 'aplijila cüpalastsja malala la tjajay mpes. Nasa ca sin 'ücüipaptsja pülül si tsutsca, nasa 'üpjǘ sin 'ücjololtsja wa 'aplijila mpes. Yupj nasa quelel la cüjaytsja Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dios pajal ca nucopj ntülüs p'a jawas, malala lajay jis capj tyüla na. Nin liji na, más malala nu mpalas Tiro mo'o patja jis lal. Más malala nu mpalas Sidón mo'o patja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nin p'iyá velé wa Capernaum nt'a patja jis lal. Nun ma ca nlawú Dios pü'ü nt'a. Tecya'lin̈ patja nt'a ca nlawú”, nin tjevele Jesús pülücj patja nepénowa mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tjevele wa jupj sin tjejyama jis lal: “Nun napj mpes welé. Mpes pjyacan̈ na nun welé, pjyacan̈ wa napj velé. Ma jisas nun, ma wa jisas napj. Ma jisas napj, ma wa jisas Dios. Jupj nin tjejyama”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tjil niyom setenta, Jesús sin tjejyama mpes. Niswá tjiquil na, po 'ücj jisastsja yupj. Tjowelepj: —Qjuis Jepa, pajal 'üsüs qjuis tepyala tjeleque na. Jipj lyá velecj na, 'üsüs polel lijicj. 'Ücj pje'á li ts'iyacj lapanenpan jipj lyá velecj na. ");
INSERT INTO jicNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús yupj jis lal tjevele: —Satanás jepa jupj lapanenpan jis lal. Nun tsji' la tjüjí na napj mpes, napj tjinyuc Satanás palá tjeyaca tsjun nepé. Menmené jinwá palá tjeyaca. Püné waytsja püná. Malala tepyala jupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","T'üc' way napj la tjejay más püné way nun diablo lal. Qjuis enemigo way jupj. Diablo latsj jinwá jupj, tsjev jinwá jupj. Quelel malala la siji gentas. Mop'in püné tulucj jupj nun jis lal. Napj la tjejay nun 'ücj malala lojí diablo, latsj jay jotsjá jinwá. Diablo polel malala liji, newa ma ca nin nujola t'as. Napj la tjejay nun 'ücj jü'tǘ ma nin la mijis jupj. Jupj ma polel malala la numijis. ");
INSERT INTO jicNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nun polel pje'á lo ts'iyá lapanenpan, mop'in nin, ma nin mpes 'ücj nujisas t'as. Nun lovin ca mpatjaqué Dios lal. Nin mpes Dios nun jis lá tepyaca tsjun po'ó. Nin tepyala mpes 'ücj nujisas t'as nun —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nin tjevele na, Jesús pajal 'ücj jos tepyala Dios Cjües la tjiji mpes. Jesús tjevele Dios lal: “Mpapay, Jepa pajal püné way jipj tsjun po'ó, nosis casá nin wa. Nepénowa pajal pülücj salejepj jin yola. Pajal sin 'yüsa jin yola. Niná sin 'yüsa tulucj. Jipj ma jis tje'yan sin tji'yüsa niná jipj lejay. La p'a wa tsjictjacj jinwá. Yusapj ma sin 'yüsa. Jipj sin tji'yüsa lis tjejay la p'in, mpes nin salejepj niná jipj lejay. Jipj pajal 'üsüs. Jipj jyastsja mpes nin quinam. 'Üctsja jipj lal”, nin tjevele Jesús jupj Popay Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jupj tjevele wa: “Mpapay pjü way ntje'aya. Len̈ pjacj ca jus cülayes pjacj ne napj. Ma salejepj napj ne Dios Jatjam. Mpapay p'in selé. Len̈ pjacj ca jus cülayes pjacj ne napj Mpapay. Napj p'in selé. Napj quelel sin 'yüsa lejay nepenowá. Yupj p'in salejepj pjacj ne napj Mpapay”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nin tjevele na, jupj taná tjinyuca, tjevele wa jupj discipulopan jis lal: “Nun nucú quinam, niná püna tjowelepj ca nin mpalas. Dios pajal 'üsüs la tjiji nun mpes nun nucú jupj lijá quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","T'üc' way profetapan pülücj püna tapatjá, po quelel januctsja nun nucú, lovin ma tjunuc yupj niná. Po quelel pjyacan̈tsja nun pjo'oqué, lovin ma tjepjyacan̈ yupj niná. Nin p'iyatsja jepa noypan pülücj jis lal.” Nin tjevele Jesús niyom setenta jis lal, yupj niswa tjiquil na. ");
INSERT INTO jicNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yom pjaní ne'aj ton̈ca, jupj seletsja Moisés popel. Quelel la 'yǘyatsja jupj Jesús lal, mpes ca jus nlayes ncu t'üc' vele Jesús Dios mpes. Yom tjevele Jesús lal: —¿Tsjan más 'ücj la mejay napj ne Dios la mijis 'ücj mpü'üs lovin jupj lal? ");
INSERT INTO jicNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús jupj wola tjevele: —¿Tsjan tepyaca Moisés püná, Dios qjuis tjijyü'tá? ¿Tsjan mo'o velen jipj Dios Popel mo'ó? ");
INSERT INTO jicNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yom Jesús wola tjevele: —Dios Popel vele jipj ‘pajal ca quelel la mijin Dios, jipj Jepa Püné. Pajal ca tsji' la mijin jupj mpes lovin. Ca jupj jos jin la mijin. Lovin ca jele mpalas jupj pajal 'üsüs. Jupj Popel vele wa jipj ca quelel lis mijin ne'aj patjá. Jipj p'iyá quelel la 'ejay jinwá ca quelel lis mijin yupj’ —nin tjevele yom niná Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús tjevele jupj lal: —T'üc' tjevelen jipj. Lovin nin la cüjay, 'üsüs ca mpü'üm lovin Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yom niná jostsja la p'a ca yola nsem jupj 'üsüs la tji'yüya, mpes tjevele wa Jesús lal: —Dios jos napj quelel lejay ne'aj patjá. ¿Pjacj ne'aj pü'ü napj lal? ");
INSERT INTO jicNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jupj nin la tji'yüya mpes, Jesús jas tji'yüsa la tjiji más 'ücj pjü way jupj wo jin popa jola t'as. Más 'ücj quelel la siji pjü. Ninana Jesús tjevelá: —Yom israelpan popa palavin tjemey Jericó nt'a. Jerusalén mpe tjemey jupj. Jümücj nt'a pwecapan ntji'lin̈ jupj. Pjü tepequen̈ jupj tya'atsjé, tjat' wa jas quip, jas pjütpjüt' tepyala. Mo'o süp jupj, ne tjil yupj. Nasa way pe'e naya, tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yacjaya nepé tjac' wa yom pjaní, sacerdote. Israelpan popa watsja jupj. Ne'aj way quelel jámatsja jupj la p'in. Yom pajal mo'o 'üsüp tjinyuca na, campapj way tjemey jümücj nt'a, tjemey. ");
INSERT INTO jicNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Locopyaya, p'a wa tjac', yom levita. Israelpan popa watsja jupj. Nenéyawa Dios wo nt'a tsji' la tjiji. Jus tjinyuca wa yom pajal mo'o 'üsüp, ne campapj way tjemey wa jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Locopyaya p'a wa nepé tjac', yom Samaria mpe 'esepj jupj, israelpan jis enemigo. Yom pajal mo'o 'üsüp nt'a tjac' jupj. Po jólatsja malala tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yom mo'o 'üsüp nt'a tjemey. 'At'anca mo'o ts'yuca aceite, vino 'ots'ipj, leméliyu mpes. 'At'anca nt'a tsyu'pa jupj. Soysoy casá tje'yonsa. Wa jinan̈ nt'a tjemyana jupj, tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ya quelel jámatsja jupj, yom Samaria mpe 'esepj. Mpes t'emel c'a mát'eya tje'yaya yomen wa juts'a'á. Pülücj jaylactsja yupj jis lal t'emel c'a. Tje'yaya na, tjevele: ‘'In tjejyama jupj. Más pülücj jaylacj pyala jupj jyaman, jaylacj ca la mejay napj, niswa tjacuwis na’ —nin tjevele jupj. Jesús t'üc' tjevele quinam niná tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jupj tjevele yom Moisés popel seletsja lal: —Niyom cónt'eya sin popé ¿cana quelel la tjiji yomen niná pwecapan ntji'lin̈? ¿Cana quelel la tjiji jupj, ne'aj way pü'ü jinwá? ¿'Oyn jele jipj? ");
INSERT INTO jicNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yom tjevele: —Yom cus tjep'ya'sa, niná quelel la tjiji jupj. Jesús tjevele: —Nin p'iyá la mijin jipj. Quelel lis mijin pjü, jipj enemigopan 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús newa jámatsja discipulopan jis lal. Pülücj patja nt'a tjemey jupj. Ne'aj quepj jostsja Jesús ncuwim jupj wo nt'a sin mü'üsüs lis mijis Dios mpes. Marta lotsja jupj, quepan. ");
INSERT INTO jicNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jupj t'olapj María lotsja. María Jesús jun 'asa'á tjá'asa, tjapjaca qjuis Jepa Jesús jas tji'yüsa la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ma nin la tjiji. Pajal pülücj líjitsja jupj. Ma polel pjü la qjuijis. Mpes tjemey Jesús nt'a, tjevele: —Nejepa ¿ncu ma jele nt'alapj ma tsji' liji napj lal? Tjijyü'ta ca ncapj mp'a'sas jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Qjuis Jepa Jesucristo tjevele jupj lal: —Marta, pajal nin jele jipj, 'aplijila jipj pülücj lejay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Más 'ücj pjaní ninam lejay. Tjapjaca napj velé, jin tjü'üsüs 'onin ne Dios jipj Jepa nsem. Jipj pyülücj niná nin liji. Más 'ücj jupj lal si 'üsǘ Dios vele jin, tsji' liji lal. Jupj jas tji'yüsa ma polel lo ta'es p'ampa. ");
INSERT INTO jicNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","P'a jyawca na, Jesús Dios lal véletsja. Tecyawaja tjevele na, jupj discípulo pjaní tjevele jupj lal: —Qjuis Jepa, qjuisin mü'üsüs la mijin la veles Dios lal. Juan el Bautista sin tji'yüsa lis tjiji jupj discipulopan la veles Dios lal. Qjuisas wa qjuisin 'yüsa la mijin wa ncupj. ");
INSERT INTO jicNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús tjevele yupj jis lal: —Dios lal welé na, nin p'iyá ca mvelé: ‘Qjuis Papay, tsjun po'o püt'. Po qjuisas pjü ca mvelecj jipj pajal 'üsüs. Jipj p'in 'üsüs pjü jis lal. Qjuisas len̈ way Jepa nsem jipj pjü jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Qjuisas wa qjuesé 'an qjuis la las pjü jyawca na. ");
INSERT INTO jicNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Malala nyuca la tjijicj, qjuisas perdonar la qjuesejay. La p'a malala la qjuisiji na, lovin perdonar lijicj jupj malala la qjuis tjiji. Qjuis capj tjep'ya'sa wa cupj ma ca quelel malala nyuca la mijicj’ —nin tjevele ca nin mvelecj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús sin 'yüsa lis tjiji wa Dios quelel 'yaya jupj ts'uyupj la mon. Tjevele: —Ca nacj nun popa pjaní ca mim püste mo'oya jupj jomica nt'a. Ca mveles jomica lal: ‘Najamica, pan cont'e ma 'en. ");
INSERT INTO jicNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Najamica p'a wa campa nepé tjac' quinam. Cjuwá napj tsjan cü'ayá, cülajas jupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","”Ca nacj jupj jomica ca mveles wa nepé: ‘Po ma la tjemyona quinam. Jun t'yolon jun vilicj quinam. Napj nts'uyupj napj lal patja ncjan nt'a. Ma polel nin jyünsǘ la 'ayas jipj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ca nacj jomica quelel liji mpes 'yaya tulucj. Jupj jomica newa le moná mpes p'in ca ma'ayas jupj. Nin mpes jupj ca jas müjünsüs, ma'ayas jupj. Pjü jos ca ma'ayas. ");
INSERT INTO jicNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mpes nin velé nun jis lal, newa la moná Dios lal nun, ne jupj ca nu ma'ayas nun la tjomoná. Ma len̈ way nu 'yaya, newa la moná, ne jupj ca nu ma'ayas nun la tjomoná. Nujisas Dios nucopj mp'a'sas, newa la moná niná Dios lal. Newa lo moná na, jupj ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nun lo moná Dios lal, nin ca nt'anqué. Nun lovin p'in lo moná, jupj ca nu ma'ayas. Nun newa lo moná Dios nucopj mp'a'sas, jupj ca nin la mijis nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”Nun ca jus nlayé niná. Nun popa pjaní jatjam tsjicj ve le moná na, ma ca pe ma'ayas jupj. Cjul le moná na, ma ca ma'ayas lotsjim. ");
INSERT INTO jicNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pejey le moná na, ma ca tsjev ma'ayas. ");
INSERT INTO jicNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nunpan malalapan, mop'in solejé 'oyn nyuca 'üsüs jis ma'ayá nun sin popa tsjictjacj. Nun jis Papay tsjun po'ó, 'üsüs way jupj, malala tulucj. Nin mpes nun ca jus nlayé jupj ca nu ma'ayas jupj Cjües, nun lo moná na —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús pje'á la ts'iya lapanen yom jos mpe. Yom jos mo'o tüpü'ü na, yom ma polel vele la tjiji. Lapanen pje'á tjemey na, yom 'ücj vele tepyala niswá. Pülücj tjunuc niná tepyalá. Yólatsja pajal 'üsüs Jesús nin la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nepénowa p'in malala tjowelepj: “Beelzebú se p'a'sa Jesús, mpes 'ücj pje'á li ts'iyá lapanenpan. Beelzebú jepa püné lapanenpan jis lal.” ");
INSERT INTO jicNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","P'a witjacj quelel salejeptsja ncu t'üc' way Dios mpe tjac' Jesús. Ma topon yupj. Mpes jisastsja Jesús ca pajal 'üsüs la mijis gente p'in ma polel lajay jinwá. Nin mpes quelel sin mü'üsüstsja ncu Dios jas tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús seletsja niná yólatsja yupj. Mpes jupj sin tji'yüsa lis tjiji Dios mpes p'in pajal 'üsüs la tjiji. Jupj tjevele yupj jis lal: “Yuwá nyucunun̈ jepa pjaní si jütüta nt'a, ne'aj malala ca mpalas pajal. Nin p'iyá wa pjaní nt'a. Yuwá nyucunun̈, ma polel 'üsüs patja yupj. Malala ca jis mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nin p'iyá Satanás lal. Jupj nucunú waytsja jupj mpes p'iyá, jupj enemigopan 'ücj ca malala la qjuijicj jupj. Nun welé Beelzebú ncapj p'ya'sa, ne nin mpes 'ücj pje'á lis ts'i lapanenpan. Ma quelel nin la qjuijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mop'in nin welé nun. Nun welé Beelzebú ncapj p'ya'sa. Nun welé nin mpes 'ücj pje'á li ts'i lapanenpan. Nin tulucj. Nun popa nepenowá pje'á la ts'i wa lapanenpan. ¿Pjacj jis capj p'ya'sa yupj? Yupj p'iyá ca mvelecj malala welé nun pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dios ncapj p'ya'sa. Nin mpes 'ücj jyütütj pje'á jil lapanenpan. Jupj ncapj p'ya'sa, nun 'ücj ca nusin la 'üsüs Dios quelel Jepa já'asa quinam nun nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”Diablo yom jas tjiyocj jinwá jupj. Jupj tya'a tsjan mpes 'ücj lo palan. Pajal mo'o li nucuna ncu jiquil enemigopan. Nin liji, jupj juts'a'á 'ücj jatja. P'a wa ma polel lo cuwis la ta'es jupj juts'a'am. ");
INSERT INTO jicNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nin p'in, napj más nin tjiyocj jupj lal, más 'ücj le palan napj jupj lal. T'e'é napj jupj tya'á tsjan mpes 'ücj lo palan, t'e'é wa jupj juts'a'á. Se 'a niyom napj lal tjiquil. Niná napj lejay diablo lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”Nun ca nujola cüpalas diablo ncapj p'ya'sa tulucj. Jupj ma jos napj lejay, mpes napj ne'enemigo jupj. Jupj ma gente cyuna Dios nt'a, napj lejay jinwá. Jupj liji yupj ma jis la winin Dios nt'a”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","P'a wa tjevele Jesús yupj jis lal. Tjevele Dios len̈ yupj jisas mo'ó, ca malala jis mpalas. Tjevele: “Lapanen yom jos mpe jama na, 'üsǘ pja nt'a jama wine. Le palá ca'aj 'ücj ca mpü'üm. Lovin ma si nucú, mpes vele: ‘Püna tüpü'üs nt'a ca mis niswá. Yom nt'a ca mis.’ ");
INSERT INTO jicNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yom nt'a tjemey na, wosis 'üsüs la tjajapjun jinwá yomen jupj lal. Len̈ ne'aj yom jos mo'ó. Dios ma pü'ü jupj jos mo'ó. Mpes wosis pajal 'ücj la tjajay jinwá jupj lapanen lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mpes jama lapanen. Lapanenpan p'a wa jis lal jac'. Siete jilal jac'. Más malala yupj mwalá way lal. Pjü yupj yom jos mo'o jil jis la püt'üs. Mpes locopyaya más malala pyala yomen püna lal. Püna lapanen pjaní way p'in jupj jos mo'o tüpü'ü”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús nin tjevele na, quepj pjaní yümücj tjevele Jesús lal 'in campapé. Pülücj ne'aj tjatja popa waytsja jupj. Jupj jólatsja Jesús tjevele pajal 'üsüs. Mpes tjevele: —Po 'ücj jos nsem jemay 'i tjimanunu mpes, 'e tje'aya tsots'. ");
INSERT INTO jicNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús jupj wola tjevele: —P'a casá velé napj. Gente Dios tjevelá pjyacan̈, jupj vele jin lajay wa, pajal 'ücj jisas nsem yupj pjü. ");
INSERT INTO jicNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Más pülücj jun 'asas tjiquil Jesús nt'a. Pülücj waytsja yupj pajal. 'A jis tjimyula ne'aj. Jesús tjevele yupj jis lal: “Nun quina potjaqué malala pajal. Nun lo moná napj 'üsüs la mejay gente p'in ma polel lajay jinwá. Nin mpes ca nusin mü'üsüs Dios nin tjejyama napj, nin welé nun. Ma ca nin la mejay napj. Pjaní way p'in ca la mijis Dios nun nucú mpes. Püna Jonás lal la tjiji jinwá, nin wa ca la mijis napj lal. Jonás profeta waytsja püná. ");
INSERT INTO jicNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Üsüs tepyala Jonás lal mpes Nínive nt'a tapatja salejeptsja Dios jas tjejyama jupj. Lovin ma nin pyala, Jonás lal tepyala jinwá. Nin p'iyá 'üsüs ca ma palas napj, mpes quina patjá ca jus nlayecj Dios nin tjejyama. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","”P'a wa ca mveles wa nun malala. Pajal püna quepj jepa já'asatsja Sur mo'ó Egipto nt'a. Jupj p'iyá ca nin mveles. Pajal campa mpe tjac' jupj lo pjac Salomón tjevelá. Salomón p'a wa jépatsja Israel mo'ó pajal püna. Salomón pajal selé waytsja Dios tjevelá. Nin mpes quepj quelel pjócatsja jupj tjevelá. Nin tulucj nun lal. Nun lal 'os quinam. Más püné napj Salomón lal. Newa nun ma quelel pjo'oqué napj velé. P'a jawas Dios ca mveles ncu t'üc' malala la tjajay pjü. Nin jawas tjejyawca na, quepj niná ca ntojom nun jis lal Dios wolap'a'á. Ca mveles nun malala. Nun ma quelel pjo'oqué, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","”P'a wa ca mvelecj wa nun malala. Nínive mo'o tapatja topon Jonás tjevelá. 'Aplijila jis tepyala malala la tjajay mpes. Yupj nasa quelel 'üsüs lajaytsja. Nin tulucj nun lal. Nun lal 'os quinam. Más püné napj Jonás lal. Newa nun ma poné napj velé. P'a jawas Dios ca mveles ncu t'üc' malala la tjajay pjü. Nin jawas tjejyawca na, Nínive mo'o tapatja ca nlüjün̈ nun jis lal Dios wolap'a'á, ca mvelecj nun malala. Nun ma poné, ne nin”, tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús sin tji'yüsa lis tjiji Dios jos yupj sin 'yüsa jupj velá. Tjevele: “Yo je si müjü, ma quiliyú lal jun t'yo'na. Ma 'amá jul mo'o 'yonsa jupj. Campanya si jünsa, mpes la p'a wama jiquil na, jupj 'owa pjü 'ücj jis la nuc. Nin p'iyá liji Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nin p'in, ma pjü sin 'yüsa Dios velá. Nun jis jun jaw jinwá nun jis p'üy mpes. Nun jis jun 'üsüs, jas tüpwes 'üsüs way nucú. Nin p'iyá niná nun 'üsüs nusin 'yüsa na Dios mpes. Nun jis jun malala, jas tüpwes ma nucú. Te ton̈ca p'in nucú. Nin p'iyá niná nun ma nusin 'yüsa na Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'In tjajama nun t'üc' way nusin 'yüsa Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nun t'üc' way nusin 'yüsa Dios po'ó, po 'üsüs. Pjü way ca nusin mü'üsüs. Lámpara mpes tjejyawca jinwá ca nsem nun lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús t'üc' tjevele na, fariseo pjaní Jesús lal tjevele lo winin lo las jupj wo nt'a, lots'ac' culupwen nt'a já'asa na. Mpes tjemey Jesús, 'etjele lo las. ");
INSERT INTO jicNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo tjinyuca Jesús ma mos tepe'e quelel lyájatsja na. Pajal püna Moisés tepyaca más 'ücj jis mas japatsj jalá. Mpes fariseo po jólatsja tsjan mpes ma nin la tjiji Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mpes qjuis Jepa Jesús tjevele jupj lal: —Nun fariseopan pülücj lojí la p'a jis la nuc. Nujisas yupj yola nun 'üsüs. Ma t'üc' way 'üsüs nun. Nunpan pocillo te way jinwá. Pocillo pje'á p'in so pü'í jinwá lojí nun. Plato 'ala'á p'in so pü'í jinwá lojí. Wa mo'ó pajal te custjay. Nin p'iyá nun. Lovin 'üsüs lojí la p'a januc na. Newa malala nun t'üc' way. Nun ts'üisiqué pajal. Po quelel malala lojí, ne nin lojí wa niná. ");
INSERT INTO jicNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ma yola jinwá lojí nun. Dios nun jis p'üy la tjiji. Nun jis qjues la tjiji 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jupj selé tsjan nujola nun. Jupj selé 'üsüs tulucj nun. Mpes 'üsüs nujola t'as nun Dios jos jin. 'Üsüs la müjí jupj jos jin. Jis tje'yayá jis t'emel cjuwá jisas. Nin lojí, pjü salá nsem nun Dios lal. 'Üsüs wa ca nsem nun nujolá. ");
INSERT INTO jicNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”Malala ca nu mpalas nun, fariseopan. Pjü diez popé nun nuts'a'á, pjaní 'oyá Dios mpes. Tsjutsj culantro jinwá 'oyá Dios mpes. P'a wa tsjutsj ajo jinwá 'oyá. P'a siná popé 'oyá wa Dios mpes. 'Ücj wa nin lojí. Malala p'a wa ma lojí. Dios jos 'üsüs lojí p'a jilal. Jos wa quelel lojí jupj. Ninana ma lojí nun. Jupj jos ca nin la müjí. Niná lojí na, mop'in ca ma'ayá wa nun to'á popé Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”Malala ca nu mpalas nun, fariseopan. Judiopan 'a si mulú nt'a po quelel jotjaqué noypan jatja nt'a. Pülücj lyawun̈ nt'a, nujisas la p'a wa 'üsüs javelepj nun lal, yom 'üsüs lal javelepj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”Malala ca nu mpalas, Moisés popel sin 'yüsa lojí. Malala ca nu mpalas wa nun fariseopan. Nun nujos p'a wa ca yola nsem nun 'üsüs, nun lojí mpes. Ma t'üc' way 'üsüs nun. Toc patja cruz cjuwá jinwá nun. Cruz cjuwá mpes nenéyawa ne'aj jil ma salejepj tsjan casá jil yupj. Nin p'iyá la p'a yola 'üsüs nun Dios lal. Ma salejepj pajal malala way nun —nin tjevele Jesús fariseopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yom pjaní ne'aj já'asatsja Moisés popel salejepj popa pjaní waytsja jupj. Jupj tjevele Jesús lal: —Nin velen na, qjuis capj velel wa ncupj. ");
INSERT INTO jicNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús jupj wola tjevele: —Nin. Malala ca nu mpalas wa nun, nun pülücj solejé Moisés popel po'ó. La p'a su jü'tǘ pülücj lajay. Pajal costa way nin lajay nun jü'tǘ. Nun p'iyá ma nin lojí nun su jü'tǘ. Jas tüpwes ma lojí nun. ");
INSERT INTO jicNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”Malala ca nu mpalas. Püna canapatjá nun popa p'iyá jis tjü'ünan profetapan püná. Quina nun 'ücj justa lojí yupj toc, profetapan patja nt'a. Nun nujola 'üsüs lojí, ma 'üsüs lojí nun. ");
INSERT INTO jicNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nun solejé malala la tjajay yupj, püna tapatjá. Yupj la tjajay 'ücj nun jilal. Yupj jis tjü'ünan profetapan. Nun t'üc' lojí yupj la tjajay. Nun 'ücj justa lojí yupj toc, profetapan patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”Dios pjü selé jupj. Nin mpes tjevele: ‘Profetapan sin majam ca napj yupj nt'a. Apostolpan sin majam wa napj yupj nt'a. Yupj ca la nts'iyacj yupj, yupj patja mpe. P'a nt'a jil na, pje'á la nts'iyacj wa yupj nepé.’ ");
INSERT INTO jicNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Püna tapatja nun popa p'iyá jis tjü'ünan profetapan. Yupj mwalá way nin la tjajay. Quina nun nin p'iyá lojí. Nin mpes Dios nucopj ntülüs ca nun pjü mpes, quina patja la tjajay mpes, püna tapatja la tjajay mpes 'ots'ipj. Pjü jis tjü'ünan mpes Dios ca nucopj ntülüs nun. ");
INSERT INTO jicNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mwalá way Abel tjü'ünan. Locopyaya pülücj jis tjü'ünan. Judiopan tjü'ünan wa Zacarías. Dios wo wama tepe'e jupj. Mesa Dios ja'ayapj nt'a ne'aj p'in tepe'e jupj. Dios ca jis capj ntülüs quina patjá pjü way mpes. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”Malala ca nu mpalas nun nepenowá, pülücj solejé Moisés popel. Dios jis tje'yaya la p'a 'ücj sin 'yüsa jupj po'ó. Jis tje'yaya 'onin ne ca sin mü'üsüs. Nun ma nujisastsja niná. Tjapja'né 'onin ne ca sin mü'üsüs yupj. Nun p'iyá ma nusin tji'yüsa Dios tjevelá, ma wa jis tja'ayá p'a wa sin 'yüsa yupj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nepé tjemey na Jesús, ts'a 'in waytsja pajal Moisés popel sin 'yüsa lajay, fariseopan 'ots'ipj. Po jisastsja Jesús malala cüveles, ne pülücj mpes la tjü'üy jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Po tjepjyacan̈ ncu malala nyuca tjevele jupj. Po jisastsja jupj malala nyuca cüveles, mpes ca 'ücj jat' mvelecj yupj. Ma quelel lajaytsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nin jawas pajal pülücj 'a jis tjimyula Jesús nt'a. Pajal pülücj mpes jis tsjom jay tjajatsj. Pajal pülücj 'a jis tjimyula na, Jesús tjevele discipulopan jis lal. Pjaní quelel véletsja mwalá way p'in. Po jostsja sin 'yǘsatsja niná. Ninana tjevelá: “Nujola t'as fariseopan 'üsüs lajay la p'a januc nt'a, mop'in ma t'üc' 'üsüs yupj. Yupj malala lajay ma si nuc, levadura ma si nuc jinwá. Levadura ma si nuc pan püm mo'ó. Yacjaya pansas t'yüna jupj, mpes 'ücj jus cülayes levadura mo'o pǘ'ütsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nin lovin. P'a jyawca la p'a ca jus nlayecj tsjan niná nun poné, ca jus nlayecj nun nujolá. Tsjan cus tüpwijitj, tjapjalen, cus ncjoltses ca. Püna tjapjalen, la p'a ca jus nucucj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Te ton̈ca nt'a tjevelen, tjejyawca na ca mpjacam p'a wa. Pjü len̈ nt'a la tjivisan, yümücj ca mvelecj pjü pjyacan̈ nt'a. Mpes ca mvelé nun p'a lal tsjan niná nun poné, mvelé nun nujolá. ");
INSERT INTO jicNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”Ca nacj nepena ca quelel jis mü'ü'nacj nun, napj mpes poné mpes. Najamicapan, po ma locj tjeyá yupj jis lal. Nu tjü'ünan na, ma polel p'a lajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Napj ca nusin 'yüsa la mejay pjacj ne 'ücj locj jeyá: locj tjeyá Dios lal. Jupj 'yü'na na, 'ücj wa na'aj li ts'iyá 'awa püné nt'a, malala lajay jis capj tyüla nt'a. ¡Locj tjeyá jupj! ");
INSERT INTO jicNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”Po ma locj tjeyá p'a mpes. Dios jyama nun. Jupj ma ca jo' mpa'is nun mpes. Dios ma jo' pe'e tsipyaya tsjictjacj. Tsipyaya cínquiya veinte centavos jaylacj. Yupj pajal tsjictjacj way nun lal. ");
INSERT INTO jicNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios selé nol jatja jits'il. Po ma lecj tjeyá. Más 'üsüs way jipj tsipyaya pajal pülücj jis lal. T'üc' way ma ca jo' mpa'is jipj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","”Napj velé t'üc'. Nun welé la p'a jis lal nun ncapj con̈có, Dios angelpan jis lal ca mvelé wa napj nucopj cyon̈ nun. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nun welé la p'a jis lal nun ma ncapj con̈có, Dios angelpan jis lal ca mvelé wa napj ma nucopj cyon̈ nun. ");
INSERT INTO jicNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”Napj p'iyá niná Yomen Dios jas tjejyamá. Malala javelepj napj nin po'ó, Dios 'ücj perdonar liji yupj. Malala javelepj Dios Cjües po'ó, Dios ma ca perdonar lis mijis yupj. Lovin ca jola nsem malala tjowelepj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”P'a jawas niyom ca ncul, ca nu ntji'lin̈. Nun lal ca mal wosis nt'a, judiopan 'a si mulú nt'a. Ne'aj jat' mvelecj ca nun po'ó, nun ncapj con̈có mpes. Jepapan jis walap'a'a ca jat' mvelecj nun po'ó neneyawá. Jepa auxiliar jis walap'a'a ca jat' mvelecj nun po'ó neneyawá. Nin lajay na, po ma nin nujola t'as nun tsjan ca mvelé yupj jis lal yupj malala tjowelepj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dios Cjües nusin mü'üsüs ca la mijis tsjan 'ücj jis wala ca mvelé. Mpes po ma locj tjeyá nun.” ");
INSERT INTO jicNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yom pjaní pülücj yuwá popa tjevele jupj lal: —Tjijyü'ta natjam la mitad ma 'es qjuis papay juts'a'á. Tepe'e qjuis papay. Jupj juts'a'á ncupj cuts'a'á quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús ma la tjiji jupj la tjemyoná. Jupj tjevele: —¿Tsjan pjucj jele napj jyütütj p'a wa la mitad liji jipj lal? Ma juez jinwá jyütütj napj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesús tjevele wa ne'aj tjatja jis lal: —'In tjajama. Po ma t'emel pülücj nujisas t'as. Po ma ts'üisiqué t'as nun. Gente ma nin mpes patja, pülücj jatatj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Parábola mpes sin 'yüsa lis tjiji quinam niná. Tjevele: —Yom pjaní t'emel pülücj tyá'atsja jupj. Jupj 'isine nt'a pülücj tjevyala pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mpes nin jólatsja: ‘¿Tsjan la cüjay? Pülücj tjevelan̈ mpes cjuwá ca'aj pyajatj tjevyalá.’ ");
INSERT INTO jicNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mpes jupj tjevele: ‘Nin ca la mejay: napj chiquero witjacj sin mojoy ca. Chiquero más noypan ca sin müjünsǘ. Noypan mo'o 'ücj ca mpajatj pjü tjevelan̈. Pjü napj nats'a'á 'ücj ca mpajatj ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ninana ca nola nsem napj: “Pajal pülücj tyatj napj. Año pülücj t'üc' la las nsem, pülücj ne'aj tepyajatj mpes. Ma ca tsji' la mejay quinam napj. Nla ca. Mü'üs ca. 'Ücj najas nsem.” ’ ");
INSERT INTO jicNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mop'in ma nin tepyala, jupj jólatsja jinwá. Dios tjevele jupj lal: ‘Ma jele jin lejay jipj. Yacjaj püste mya pats' ca jipj. Mpes pjü jipj tepyajatj p'a juts'a'á nsem.’ ");
INSERT INTO jicNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús tjevele: —Lovin nin ca nsem ninana lajay jis lal. Nosis nt'a pülücj jatatj la p'in. Cjuwá yupj lovin Dios lal, mpes pjü ca ncawajas, tecya'lin̈ na. ");
INSERT INTO jicNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús tjevele wa discipulopan jilal: —Nin mpes nin velé, po ma pajal nujola t'as tsjan ca nlajá 'ücj nu la püt'üs. Po ma pajal lapj nyuca nujola t'as tsjan nusin nqui'pá nun jis pülül, nusin 'yawa lowiqué. ");
INSERT INTO jicNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dios la tjiji nu la püt'üs. Jupj ca nu ma'ayas wa nu lo las. Dios la tjiji nun jis p'üy. Jupj nu ma'ayas wa ca pülül. ");
INSERT INTO jicNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nujola t'as sanata po'ó. Yupj ma jasin. Velan̈ ma jacutj. Cjuwá yupj ca'aj ca mo'onsocj yupj yuts'a'á. Dios se 'aya jis la las yupj. Nin mpes solejé jupj ca nu ma'ayas wa nun nujos. Nun más 'üsüs sanata jilal. Yupj pajal tsjictjacj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","”¿Ncu nun más 'in püs way ca mpatjaqué nun, pajal nin nujola mpes? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pajal tsjicj way niná Dios lal; nun p'in ma polel nin lojí lovin. ¿Tsjan mpes pajal nin nujola nun pjü nujisas mpes? ");
INSERT INTO jicNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nujola t'as tsjutsj ts'ituju po'ó. Ma tsji' lajay yupj. Ma wa sa lul. Newa nin, tsjutsj ts'ituju más 'üsüs yustapj Salomón jas quip lal. Salomón jepa püné waytsja jupj. Jas quip pülücj jaylactsja. 'Üsüs justa jas tücüi'pe. ");
INSERT INTO jicNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dios liji pajal 'üsüs yustapj tsjutsjum. Tsjutsj lejen̈ ca nacj yacjaj. Ya pwe ca nacj. Nun más 'üsüs tsjutsjum jis lal. Nin mpes ca jus nlayé Dios ca nu ma'ayas wa nusin quip. Nun 'ots'ots' way p'in poné Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","”Po ma pajal nujola t'as tsjan ca nlajá, tsjan ca müsiqué. Po ma lapj nyuca nujola t'as nun. ");
INSERT INTO jicNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dios ma jisas nin yola 'oyn nyuca cüta'acj pjü way yupj jisas. Po ma yupj jinwá nujos t'as. Nun jis Papay Dios selé nujos niná. ");
INSERT INTO jicNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lovin nujos t'as ca nin la müjí Dios jyü'tá. Nujos t'as pjü ca mponecj jupj lal. Nin lojí, Dios ca nu ma'ayas wa niná nujisas. ");
INSERT INTO jicNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús tjevele wa: —Po ma locj tjeyá. Nun pjaní way, mop'in no'oveja jinwá nun. Napj nu jyamá. Nun jis Papay Dios quelel nu 'yaya nun müjü'tǘ wa jupj lal. 'Ücj jupj lal nin nu 'yaya. ");
INSERT INTO jicNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mpes nun nuts'a'á vender la müjí, t'emel jis tja'ayá jis t'emel cjuwá mpes. Nosis nt'a ca jis ma'ayá nun jis t'emel Dios jos jin. Nin lojí, pülücj ca nta'á Dios pü'ü nt'a. Nun to'á Dios pü'ü nt'a lovin ma ncawajas ca. Ne'aj pwecapan ma pequen̈, ma wa jalá calatsas. ");
INSERT INTO jicNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Más 'ücj pülücj to'á Dios pü'ü nt'a. Nun pülücj to'á nt'a, ne'aj pajal 'üsüs ca nsem nun jis lal —nin tjevele Jesucristo. ");
INSERT INTO jicNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesucristo tjevele wa: —Napj ca mis nun mpe; p'a jawas ca ncuwis. Lovin la ma nucú niswa ca ncuwis. Lovin la müjí nu tjijyütütj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mozopan jis patrón la nuc jinwá t'as nun. Jis patrón tjemey, tjowaya jinwá napj. Mozopan jis patrón ncuwim, mpes la nuc. Jupj jac' na, ca mveles: ‘Jun tjecjyoltse jun vilicj’, ne len̈ way yupj ca jun ncjoltsecj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jis patrón tjac' na, mozopan po 'ücj jisas nsem la nuctsja yupj custjay. Po 'ücj jisas nsem yupj newa lajaytsja jupj tjijyü'tá. Nin jinwá la müjí nun. Nun jis patrón la p'a jis patrón jin tulucj. Jupj ca pasal 'üsüs la mijis jupj jomozopan mpes, yupj lajaytsja jupj tjijyü'tá. Jis patrón 'ücj ca la mijis jis ma'ayas jis la las. Jis müjü'tüs ca majatjum yupj. Ncuwim jupj, jis ma'ayas jis la las. Napj tjacuwis na, nin p'iyá ca la mejay napj nun mpes. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","”Nun napj namozopan. Ma solejé 'ona ncuwis napj. Püste culupwen nt'a ncuwis ca nacj. Nasa jyawca na ncuwis ca nacj. Nun newa la nu nucú napj cuwis na, po 'ücj nujisas nsem nun. ");
INSERT INTO jicNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nusin tji'yüsa niná: nun ma solejé 'ona ncuwis napj. Nin p'iyá yom ne'aj wo ma seletsja 'ona ncuwim pwequepj, mpes tjejyá, ma tjejyama jupj wo. Tjejyá na, pwequepj tjac', wama tjemey, tüpweca. Ma nin la müjí nun, yom tjejyá jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nun la ntjunucú, lovin la tjüjí napj nu tjijyütütj. Napj cuwis na, nun ma ca jus nlayé niná jawas jyawca na ncuwis. Nun ca nujola nsem napj ma ca ncuwis custjay —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro tjevele Jesús lal: —Nejepa ¿ncu ncupj p'in qjuisin 'yüsa lejay jipj, parábola niná mpes? ¿Ncu pjü sin 'yüsa lejay wa nin tjevelen mpes? ");
INSERT INTO jicNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Qjuis Jepa Jesús tjevele: —Niná velé pjü way nomozopan 'üsüs witjacj jis lal. P'a parábola tjevele wa jupj jupj jomozopan sin po'ó. (Sin tji'yüsa lis tjiji ca 'üsüs tsji' la mijicj jupj mpes, jupj len̈ na.) Ninana jupj tjevelá: —¿Ncu mozopan 'üsüs way nun? Napj ca mvelé mozo 'üsüs way po'ó. Niná mozo la tjiji jupj patrón tjijyü'tá. 'Üsüs way si 'üsütsja jupj. Mpes jupj patrón la tjiji mozo niná jepa tepyala la p'a mozopan jis lal. Tjevele ca jis ma'ayas jis ve yupj jalá na. ");
INSERT INTO jicNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jupj patrón len̈ na, jomozo niná newa 'üsüs liji. Jupj patrón wo nt'a tjac' na, ca nucus jupj jomozo pjü la tjiji jupj tjevelá. Nin mpes 'üsüs ca mpalas mozo niná. ");
INSERT INTO jicNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jupj patrón ca mveles mozo niná ca pjü majamas jupj juts'a'á popé. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","”Mozo ma 'üsüs liji, p'a casá ca nsem jupj lal. Jupj patrón püs way len̈ ca nacj. Mpes jupj mozo jola: ‘Napj patrón ma 'ucuy quinam’. Malala liji jupj ca nacj. Si süpǘ mozopan p'a witjacj, niyom nepenowá, nequem nepenowá. Pajal püné lyaja, pajal püné mü'ü 'ots'ipj. Myona jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","P'a jawas ncuwim jupj patrón. Mozo ma li nucú na ca ncuwim jupj. Ma ca jus nlayes jupj ca ncuwim quinam. Jupj patrón pajal ca cus ntülüs mozo niná, malala la tjiji mpes. Jupj patrón lovin nin liji mozopan malala jis lal, yupj ma la tjajay jupj tjijyü'tá. ");
INSERT INTO jicNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jupj mozo seletsja tsjan jostsja jupj patrón. Jupj sin nin ma nin la tjiji, mpes jupj patrón yümücj nsüpüs ca jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mozo p'a wa ma selé tsjan jos jupj patrón ca nacj. Malala liji wa jupj ca nacj. Malala la tjiji mpes jupj patrón tsjicj way p'in ca cus ntülüs jupj. Tsjicj way p'in ca nsüpüs jupj, ma seletsja mpes. Nin p'iyá Dios lal. Dios pülücj jas tji'yüsa la tjiji jomozá, jos wa jomozo niná pajal 'üsüs tsji' liji jupj mpes. Dios pajal cus tjep'ya'sa jomozo 'ücj tsji' la mijis jupj mpes, Dios jos mozo niná pajal 'üsüs ca tsji' la mijis jupj mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús tjevele wa: —Napj tjacuwis la veles pjacj t'üc' nin liji Mpapay Dios jos jin. Napj velé 'awa jinwá ca nsem. Pajal 'ücj najas nsem napj, t'üc' la tjejay nam. ");
INSERT INTO jicNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mpapay jos mwalá way malala ne palá, mpes po najas len̈ way ca nin ma palas, jupj jos jin. ");
INSERT INTO jicNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ncu nujola napj tjacuwis pjü nin p'iyá yola lis mejay nosis nt'a? Nin tulucj. Ca p'a casá yola nsem, napj tjacuwis mpes. (Nepénowa ca mponecj napj lal. Nepénowa ca ma mponecj.) ");
INSERT INTO jicNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jis wa pjaní nt'a, p'a casá yola nsem nepenowá p'a jilal. Jis wa nt'a cínquiya ne'aj patja, cont'e ca mponecj ca nacj; mat'e ma ca mponecj. Mpes mat'e ca p'a casá yola nsem cont'e jis lal. Nin ca nsem quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nenéyawa popay ma ca nin p'iyá jola jatjam lal; jupj jatjam ma ca nin p'iyá jola popay lal. Nenéyawa jamay ma ca nin p'iyá jola jucucus lal; jupj jucucus ma ca nin p'iyá jola jamay lal. Nenéyawa pwisam ma ca nin p'iyá jola jupj nuera lal; jupj nuera ma ca nin p'iyá jola pwisam lal. ");
INSERT INTO jicNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús tjevele wa pülücj 'a jis tjimyula jilal: —Mol tjac' na t'yaja mo'ó, nun len̈ way welé: ‘Nasa majawus ca’, ne nin pyala. ");
INSERT INTO jicNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nin p'iyá lüpjǘ jac' na sur mpe, nun welé: ‘Quina ca pajal ma'awus’, ne nin pyala. ");
INSERT INTO jicNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tsjun po'ó 'üsüs lo palá nucú, nosis 'üsüs lo palá nucú wa, mpes nusin 'yüsa tsjan ca mpalas. ¿Tsjan mpes ma 'üsüs lo palá nucú tsjan pyala quinam, mpes ca nusin mü'üsüs tsjan liji Dios? Nun welé nun quelel nusin 'yüsa Dios po'ó. T'üc' tulucj. Mpes ma nusin 'yüsa tsjan liji Dios quinam nun nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”Nujola t'as tsjan más 'ücj Dios lal ca nun la müjí quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Len̈ way la müjí niná. Ma nin lojí, malala ca nsem, niná napj velé jinwá ca nsem. La p'a quelel t'ya vele jipj po'ó jepa lal ca nacj. Nin jele t'as ca 'ücj la mijin jupj lal quinam, jupj ma nin tjevele na p'in. Ma nin lejay, jupj ca mim jipj lal juez wolap'a'á. Nin mpes ca cyapj ntülüs. Ca mveles jupj auxiliar ca mya manus cawilta mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Juez ma wa ca jin majamas ma pjü way jaylacj la tjejay nas, jupj la tjemyona jin p'iyá. Pjü way jaylacj la mijin. Niná t'üc' way —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Locopyaya nepénowa tjiquil Jesús nt'a, tjowelepj malala jis tepyala Galilea mo'o tapatja nepenowá. Dios wo nt'a tjil animal jis la 'ünan, jis la 'ayas Dios mpes. Nin lajaytsja na, Pilato tjac', jis tji'yü'na yupj, mpes jis 'as la tjiwyuca animal jis 'as lal. Nin tjowelepj yupj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús jis wala tjevele: “¿Ncu nujola más malala nyuca la tjajay yupj la p'a wa Galilea mo'o tapatja jilal, mpes malala jis tepyala yupj? ");
INSERT INTO jicNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nin tulucj. Pajal nujola t'as nun p'iyá malala nyuca la tjüjí wa. Dios jos jin la müjí quinam. Ma nin lojí, nca'liqué ca nun yupj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloé nt'a, wosis pajal campanya ton̈ca jis capaná tjeyaca niyom diez y ocho casa'á, mpes tecya'lin̈. ¿Ncu nujola más malala nyuca la tjajay yupj la p'a jilal, Jerusalén nt'a patja jilal? ");
INSERT INTO jicNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nin tulucj. Pajal nujola t'as nun p'iyá malala nyuca la tjüjí wa. Dios jos jin la müjí quinam. Ma nin lojí, nun nca'liqué wa ca, yupj jin p'iyá”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Parábola mpes sin tji'yüsa lis tjiji wa niná. Nin tjevele jupj: “Yom pjaní yo higuera sínetsja yo witjacj sine nt'a. (Higuera wolas 'ücj la pis.) Locopyaya yom niná tjac' jupj higuera nt'a, jupj wolas la tepyala. Cjuwá waytsja jupj. Lo valas po'ó, mop'in cjuwá. ");
INSERT INTO jicNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mpes jupj tjevele jomozo lal: ‘Año cont'e yo wolas la tjinyuctsja napj. Cjuwá. Mpes ca mojocj jupj. ¿Tsjan mpes jupj sin ntojom nínawa momas?’ ");
INSERT INTO jicNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jupj jomozo ma jostsja jupj ca nin la mijis. Mpes jupj wola tjevele: ‘Niswa 'in la 'unyuca así 'oton̈ yon año pjaní. Yon t'asiyú ca jay mojocj momas, lu'luy ca la mejay. Vaca pwiya'a ca t'asiyú mo'onsó más 'ücj mvalas. ");
INSERT INTO jicNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","P'a año tjejyawca na, pajal 'üsüs mvalas ca nacj. Ma velam, 'ücj le jocj.’ ” Nin tjevele Jesús. (Mpes sin tji'yüsa lis tjiji nin p'iyá ca nsem yupj jis lal. Ma 'üsüs lajay Dios jos jin, malala ca jis mpalas.) ");
INSERT INTO jicNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sábado pjaní, nin jawas judiopan ma tsji' lajay na, Jesús sin 'yüsa la síjitsja yupj. Wa nt'a, judiopan 'a si mulú nt'a, sin 'yüsa la síjitsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Quepj malala jos tjac' wa ne'aj. Palá palá pwi'tje jin wínetsja. Año diez y ocho nas ma polel se t'antsja jupj. Lapanen malala jos la tjiji, mpes nin tepyala. ");
INSERT INTO jicNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús jus tjinyuca na, la tjemyona tjac'. Tjevele jupj lal: —Jipj 'i tjü'ü'sa quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús po la tje'yot'a quepan, ne len̈ way tji'yü'sa. Jas t'yantsja tepyala quepan. Tjevele tjüwüi'i Dios lal, 'üsüs tjevele Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nin tepyala na, jepa pjaní wo nt'a ts'i tji'ina jupj. Jesús tji'yü'sa la tjiji sábado na, mpes ts'i tji'ina. Jupj jólatsja malala Jesús 'yü'sa liji sábado na, israelpan ma tsji' lajay jawas. Mpes jepa niná tjevele la p'a jilal ne'aj: —Jyawca séisiya 'ücj tsji' lijicj. Nin jawas nculá nu mü'ü'süs la mijis. Po ma nculá nu mü'ü'süs la mijis sábado na. ");
INSERT INTO jicNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jepa nin tjevele na, qjuis Jepa Jesús jupj wola tjevele: —Malala way nun. Nun welé napj malala, quepj pjaní cus tjep'yacj mpes sábado na. Nun lovin jis capj p'o'sá nun jis animalpan sábado na. 'Ücj nun lal nin lojí sábado na. Nun jis buey tsyu'pa ton̈ca lyaja na sábado na, nun pjü 'osocté, monú jupj 'üsǘ mo'ó, ca mü'üm jupj sábado na. Nin p'iyá lojí nun jis soysoy mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Quepj más 'üsüs vaca lal. Quepj niná Abraham püna tüpü'ü popa p'iyá jupj. Satanás tsyu'pa quepj niná, mpes malala jos tepyala. Año diez y ocho newa tsyú'patsja jupj. Mpes 'ücj la soc sábado na. ");
INSERT INTO jicNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús nin tjevele na, jupj enemigopan jis tjemyayca. Pjü ne'aj tjatja 'ücj jisastsja pajal, Jesús pajal 'üsüs la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mpes Jesús tjevele: —¿Tsjan ca mpalas Dios si jütüta jis lal? Parábola ca mvelé napj, nusin la 'üsüs la mejay tsjan ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza setel jinwá ca nsem. Yom mostaza sine 'amá mo'ó, jupj sine nt'a. Setel niná tsjicj way pajal. Locopyaya setel tecyojo, t'yüna, pajal püné tepyala. Yo püné tepyala jupj, setel tsjicj way. Püné na, tsipyaya tjiquil, jis tsintsil la tjajay yo jay nt'a. (Nin p'iyá ca nsem Dios si jütüta jis lal.) ");
INSERT INTO jicNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","P'a wa nin p'iyá tjevele Jesús: —¿Tsjan ca mpalas Dios si jütüta jis lal? P'a parábola ca mvelé napj, nusin la 'üsüs la mejay tsjan ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levadura jinwá ca nsem. Quepj levadura tyá'atsja. Harina medida cont'e lal la süpjütj la tjiji jupj, pan la tjiji. Levadura mpes pjü jis t'yüna harinas. Nin p'iyá ca nsem Dios si jütüta jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús newa jámatsja Jerusalén nt'a, mpes nepénowa patja jin jámatsja, jis wa pjaní pjaní lejen̈ jin jámatsja. Ne'aj ne'aj tjemey. Yupj tapatja nt'a lovin sin 'yüsa la síjitsja. ");
INSERT INTO jicNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ne'aj patja popa pjaní la tji'yüya jupj lal: —Nejepa ¿ncu pjaní way p'in ca Dios lal mpatjam, jupj perdonar lis tjiji mpes? Jesús tjevele yupj jilal ne'aj: ");
INSERT INTO jicNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—'In tjajama nin p'in la müjí napj velé jinwá. Niná napj velé jun vilicj la'í way jinwá, 'ücj la winin la püt'üs Dios lal. Pülücj ca quelel mpatjam Dios lal ne ma ca polel mpatjam jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dios wo jun vilicj jun cjol jinwá quinam. Ts'ac' p'a wa jun t'yolon ca nsem. Jupj jun t'yo'na na, nun ma ca polel ne'aj la winin la püt'üs jupj lal. Nun nepenowá ca quelel mpatjaqué jupj lal, ne ma ca polel la müjí. Nun nepenowá ca mvelé Dios lal: ‘Jipj cupj qjuis Jepa. Jun tjecjyoltse, 'ücj qjuis la winin.’ Pajal ca la moná, newa ma ca polel ne'aj la winin la püt'üs jupj lal. Jupj ca mveles nun lal: ‘Ma selé ca'aj mpe tjuculá nun. Nun ma ncapj con̈có.’ ");
INSERT INTO jicNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nin mpes nun ca mvelé: ‘Püna tjelyajacj jipj lal. Tjimyüsiquecj jipj lal. Jipj sin 'yüsa la tjejay cupj pyatjaquecj nt'a.’ ");
INSERT INTO jicNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Newa ca mveles jupj: ‘Ma selé ca'aj mpe tjuculá nun. Nun ma ncapj con̈có. Lowa napj mpe. Nun pjü way malala nyuca lojí.’ ");
INSERT INTO jicNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”Nun ca su nucú Abraham, Isaac 'ots'ipj, Jacob 'ots'ipj, pjü profetapan 'ots'ipj Dios jyü'ta nt'a. Yupj ne'aj ca majatjum. Nun ca pje'á lüjüqué, mpes nun lüjüqué nt'a yümücj ca la mpuyú. Nun ca wis jas nqui'lí, pajal ts'u 'inyá mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pülücj ca ncul p'a nepé, majatjum jis la las Dios jyü'ta nt'a. Tsiquin mpe ncul wa, t'yaja mpe ncul wa, norte mpe ncul wa, sur mpe ncul wa. ");
INSERT INTO jicNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nujola t'as: nepénowa más 'in malala lajaytsja más len̈ way 'üsüs ca jis mpalas Dios lal. Nepénowa más 'in 'üsüs lajaytsja más costa way nsem 'üsüs se palá yupj Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","T'üc' tjevele na, fariseopan nepénowa tjiquil, tjowelepj Jesús lal: —Jutja quiyam jipj quelel jaytsja nt'a. Herodes quelel 'i 'ünana. (Herodes jepa pünetsja Galilea mo'ó.) ");
INSERT INTO jicNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mpes Jesús yupj jis lal tjevele: —Herodes joyomac' jinwá jupj. 'Ücj jos li tsuwile. Lowa, nun ca mvelé jupj lal napj newa tsji' lejay. Yacjaj, ya 'ots'ipj ca pje'á la nts'i lapanenpan, ca jis mü'ü'süs lis mejay malala jisas. Yaya sipé len̈ way ca ncawajas tsji' lejay. ");
INSERT INTO jicNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Newa yacjaj, ya 'ots'ipj, yaya sipé 'ots'ipj ne'aj ca mis Jerusalén nt'a. P'a nt'a ma polel jis la ca'lin̈ profetapan. Nin mpes más 'ücj ma pats' napj Jerusalén mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”Nun Jerusalén nt'a potjaqué, profetapan su 'ü'ná lovin. Pe lo ts'iyaná Dios sin tjejyama jilal, su 'ü'ná yupj. La pülücj napj quelel 'a nusí mulutsja nun napj nt'a. Castlyaj jupj tsjictjacj se t'olona, nin p'iyá quelel lejaytsja nun jilal. Nun ma jisastsja lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nusin tjü'üsüs niná. Dios ma nucopj cyon̈ca quinam nun potjaqué nt'a. Napj ca mis quinam nun mpe. Nun ma quelel la nojí na, ma ca nus nucú. P'a jawas p'a casá nujola ca nsem nun. Nun ca mvelé napj nin po'ó: ‘Dios pajal 'üsüs ca la mijis jipj mpes. Dios mpes velen jipj, Dios ne cupj qjuis Jepa Püné.’ Nin tjowelé na, ca niswa ncuwis nun nt'a. T'üc' way ca nin nsem —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sábado pjaní Jesús tjemey fariseo wo nt'a lo las. Fariseo niná jepa waytsja fariseopan jilal. Fariseopan p'a wa nepenowá tjatja wa jupj wo nt'a. Pajal tjunuc yupj 'oyn nyuca la mijis Jesús; judiopan ma tsji' lajay sábado na. ");
INSERT INTO jicNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne'aj yom malala jos tjá'asa Jesús wolap'a'á. Pajal jas t'ünt'üntsja jupj, malala jostsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mpes Jesús tjevele niyom jilal, Moisés popel salejeptsja yupj nepenowá, fariseopan nepenowá: —Sábado jawas ma tsji' lijicj cupj. ¿Ncu Moisés popel vele 'ücj 'yü'sa lijicj sábado na? ¿Ncu malala nin lijicj? ");
INSERT INTO jicNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma lal tjowelepj yupj. Jesús ntjüi'le malala jos, tji'yü'sa la tjiji jupj. Tji'yü'sa na, Jesús jas tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tjemey na, Jesús tjevele niyom jilal: —Nun jis soysoy 'üsǘ campwila mo'ó tjeyaca na ¿ncu ma len̈ way pje'á la nts'iyá jupj sábado na 'ots'ipj? ¿Ncu ma nin lojí nun jis buey mpes wa? ");
INSERT INTO jicNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yupj ma salejeptsja tsjan wola cüvelecj Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús tjinyuca nepénowa más 'in 'üsüs nt'a lis t'apj la 'osos, noypan jatja nt'a. Yupj tjiquil wa jis la las fariseo wo nt'a. Mpes parábola tjevele Jesús; sin 'yüsa lis tjiji más 'ücj ma püné jin yola yupj p'iyá. Ninana tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ca nacj jemica pülücj way tya'a la las, ne jipj lal tjevele la cuwis la las. Nin liji na, po ma la nt'an jipj más 'in 'üsüs nt'a la 'osos, noypan jatja nt'a. Ca nacj p'a wa más püné jipj lal 'ucuy wa. Jemica jupj lal tjevele wa la cuwis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mpes jemica ncuwim jipj nt'a, ca mveles: ‘Jipj jac' nt'a ma'ayan ma'ajam niná yomen’. Mpes jipj ca mim, ma'ajam p'a nt'a. Más malala nt'a nsem pjü jilal jipj jac' nt'a. Mpes pjü ne'aj ca nucucj püné tulucj jipj, ne jipj ca pajal mya maycas. ");
INSERT INTO jicNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mpes p'a casá ca la mijin. Jemica jipj lal vele la cuwis la las, jipj ca mim, ma'ajam silla más malala nt'a ne'aj. Mpes jemica ca mveles jipj lal: ‘Najamica, was, nt'i'isa más 'ücj nt'a’. Mpes pjü ne'aj ca nucucj püné way jipj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nun popa pjaní püné jin jola jupj p'iyá, Dios ca tsjicj way la mijis jupj. Tsjicj jin jola jupj p'iyá, Dios más püné ca la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús tjevele wa yomen lal, yom niná jupj lal tjevele la cuwis. Tjevele: —Jipj pülücj lejay na pülücj jis la las, lots'ac' culupwen nt'a já'asa na ca nacj, püste na ca nacj, po ma lovin ca mvelen jis la cuwis jemicapan p'in. Ma lovin ca mvelen jis la cuwis pyülücpan p'in. Ma lovin ca mvelen jis la cuwis jepeypan p'in. Ma lovin ca mvelen jis la cuwis pülücj jatatj p'in, ne'aj patja sin popé. Yupj 'ücj mvelecj la cuwis wa jipj, yupj jis wa nt'a. Yupj polel 'üsüs lajay jipj lal, jipj 'üsüs lis tjejay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mpes po ma nin la mijin jipj. Pülücj lejay na pülücj jis la las, jipj ca mvelen jis la cuwis jis t'emel cjuwá. Ca mvelen jis la cuwis jis más tulucj, jis tecj tulucj. Ca mvelen jis la cuwis ma polel jil. Ca mvelen jis la cuwis yun tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Cjuwá yupj. Yupj ma polel 'üsüs la mijicj jipj lal, jipj 'üsüs lis tjejay mpes. Mpes Dios p'iyá ca 'üsüs la mijis jipj mpes. P'a jawas Dios ca sin müjünsüs 'üsüs witjacj, tecya'lin̈ sin popé. Lovin ca mpatjam Dios lal. Dios nin liji na, jupj ca 'üsüs la mijis jipj lal, jipj 'üsüs lis tjejay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesús lal tjalá popa pjaní tjapjaca wa Jesús tjevelá. Tjapjaca na, tjevele Jesús lal: —Dios ca pülücj jis la las la mijis jupj jyü'ta nt'a. Tsjay ca 'üsüs nsem ne'aj jalá jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jupj nin tjevele mpes, Jesús jas tji'yüsa la tjiji pjacj ca nlajas ne'aj. Parábola niná tjevele jupj: —Yom pjaní pajal pülücj la tjiji jis la las, pülücj jilal tjevele jis la cuwis. ");
INSERT INTO jicNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jupj quelel lyájatsja na, jomozo jas tjejyama la veles yupj jilal: ‘Nculá quinam. Nasa 'ücj la tjejay nu lo las.’ ");
INSERT INTO jicNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mpes jomozo yupj nt'a tjemey. Mop'in yupj pjü way nin p'iyá tjowelepj ma polel jiltsja. Mwalá way yupj sin popé tjevele: ‘'Amá jaylacj la tjejay napj. Quelel jum nyuc ca 'ücj nacj. Ma nin jele t'as ma jum.’ ");
INSERT INTO jicNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","P'a wa tjevele: ‘Buey diéziya jaylacj la tjejay. Mpes quina ca mis nyuc 'oyn nyuca lejen̈. Ma nin jele t'as ma jum.’ ");
INSERT INTO jicNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","P'a wa tjevele: ‘Tjawayis quinam, mpes ma polel jum’. ");
INSERT INTO jicNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mpes jomozo jupj patrón nt'a tjemey niswá. Tjevele patrón lal tsjan tjowelepj yupj. Mozo tjevele tjapjaca na, ts'i tji'ina jupj. Tjevele jomozo lal: ‘Len̈ way pülücj patja nt'a jutja. Ne'aj jümücj la püné nt'a, jümücj la'í nt'a wa, gente la mpalan jipj. Pülücj patja nepé jis lal ncuwim jis t'emel cjuwá jis lal, jis mas tulucj jis lal 'ots'ipj, jis tecj tulucj jis lal 'ots'ipj, yun tulucj jis lal 'ots'ipj, ma polel jil jis lal 'ots'ipj. Jis lal ncuwim pjü.’ ");
INSERT INTO jicNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","”Locopyaya jomozo tjac' niswá. Tjevele: ‘Napj la tjejay jipj ntjijütütj. Newa len̈ nepenowá mesa nt'a.’ ");
INSERT INTO jicNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mpes jupj patrón tjevele mozo lal: ‘La nt'a patja nt'a jutja. Ne'aj ca lis mpalan jümücj püné nt'a, jümücj la'í nt'a 'ots'ipj. Lis tjemyona ncul, pajal pülücj nlawun̈ nawá nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mwalá jilal tjevelé ma ca nlajacj napj la tjejay jis la las. T'üc' way.’ Nasa t'üc' tjevele parabolas Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","P'a jyawca na, pajal pülücj sa con̈tsja Jesús. Jupj la nujuya, jis wala tjinyuca, tjevele yupj jis lal: ");
INSERT INTO jicNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Najas napj lal japon más quelel la najay pjü jis lal. Ma ca nin yola nsem ncu 'ücj niná jis papay lal. Ma ca nin yola nsem ncu 'ücj niná sejamay lal. Ma ca nin yola nsem ncu 'ücj niná sejats'om lal. Ma ca nin yola nsem ncu 'ücj niná jis ts'uyupj jis lal. Ma wa ca nin yola nsem ncu 'ücj niná yupj jis pülücpan jis lal. Ma ca nin yola nsem ncu ca malala jis mpalas, nca'lin̈ ca nacj, yupj ncapj jacon̈ mpes. Yupj niná mpes nin yolá, ma polel napj discipulopan nsem yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma jisas malala se palá, napj discipulopan tulucj nsem yupj. Najas yupj nin p'iyá lajay, napj lejay jinwá. 'Ücj napj lal malala ne palá. 'Ücj napj lal ni pü'í cruz po'ó. Yupj ma quelel lajay napj lejay jinwá, napj discipulopan tulucj nsem yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nujola t'as costa way ncapj con̈có. Nujola t'as ncu t'üc' way quelel ncapj con̈có. Nun popa quelel si jünsa wosis pajal püné, mwalá way 'etjele, sin pyaca nol jaylacj si jünsa wosis. Jola ncu t'üc' t'emel la cawajas la jünsüs wosis. ");
INSERT INTO jicNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma nin liji, tyoca, si jünsa tsjomis la p'in ca nacj. Nin la tjiji na, ma polel cyawaja wosis ca nacj. Mpes pjü tjunuc nin la tjiji, pjü la mpjüts'ünücj ca jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ca mvelecj: ‘Jupj quelel jas tjijyünsa wosis, newa ma polel pjü tecyawaja jupj’. ");
INSERT INTO jicNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”Nin p'iyá jepa püné lal. Jupj quelel jama jupj militarpan jilal ca nacj. Quelel le palana p'a wa lal, jupj militarpan jilal. Wine secj p'in, 'etjele jupj, jola nsem ncu 'ücj le palana p'a jepa lal. Jola nsem militarpan diez mil si manuna ca nacj. Jepa p'a wa militarpan veinte mil si manuna, más pülücj witjacj yupj jupj militarpan jilal. ");
INSERT INTO jicNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jupj más püné tulucj, jupj ca sin majamas auxiliarpan nepenowá p'a jepa nt'a. Custjay pajal campa ton̈ca p'a, ca sin majamas, ca jupj lal la mü'üyacj 'onin ne 'ücj jis la püt'üs, ma la mpa'nacj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nin p'iyá nun jis lal. Nujola t'as costa way ncapj con̈có. Nun ma nin nujola pjü way nun nuts'a'á Dios juts'a'á, napj discipulopan tulucj nsem nun. ");
INSERT INTO jicNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”Sal 'üsüs way. (Sal mpes ts'yuca pwisis, ma malala mpalas, ma mojo jupj.) Nin tulucj sal ma wüjü na. Sal ma wüjü na, ma polel wüjü lajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma wa 'yü'sa liji momas abono jinwá. Ma wa 'yü'sa liji abono 'amá la ts'uc. Na'aj la ts'i p'in. Nin p'iyá nun jis lal. Sal 'üsüs jinwá t'as nun”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pülücj 'a jis tjimyula Jesús nt'a. Yupj nepenowá impuesto jaylacj jat'anquepj pátjatsja. Jupj nt'a tjiquil wa p'a witjacj malala nyuca lajay. Quelel pjyacan̈tsja Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nin mpes fariseopan tülü way tjowelepj Jesús malala. Nin p'iyá tjowelepj niyom p'a wa, Moisés popel sin 'yüsa lajay. Tjowelepj: “Yom niná 'ücj jos jiquil malala nyuca lajay. Lyaja wa jupj yupj jis lal.” ");
INSERT INTO jicNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yupj nin tjowelepj, mpes Jesús parábola tjevele yupj jis lal. Sin 'yüsa lis tjiji Dios jos pjü ca cus ncon̈cocj jupj. Ninana tjevelá: ");
INSERT INTO jicNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nun popa pjaní oveja cien tya'a jupj ca nacj, pajal pülücj. Pjü way jos jupj. Pjaní len̈ tjevyala na, jupj ca mim la mpalas jupj. Oveja noventa y nueve pjü lyawun̈ tsjutsj jalá nt'a. Pjü lejen̈ ca mim yomen. Oveja pjaní jus tjinyuca nas ca la mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jus tjinyuca nam, 'ücj jos nsem pajal. Oveja ca jüpjüs mpüntüs, ntjamas. Wo nt'a ca mim. ");
INSERT INTO jicNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jus tjevyanta na wo nt'a, ca 'a jis mulus jomicapan, la p'a wa ne'aj patja ca 'a jis mulus wa. Ca mveles yupj jilal: ‘'Ücj nujisas t'as napj lal. Napj oveja len̈tsja, jus tjinyuc quinam.’ ");
INSERT INTO jicNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","”Nin p'iyá Dios lal —tjevele Jesús—. Pülücj 'üsüs Dios lal ca nacj, noventa y nueve ca nacj. Yupj püna la tjajay 'ücj newa lajay yupj. Ca nacj yom pjaní way p'in malálatsja. Locopyaya jola tepyala malala nyuca la tjiji. Dios jos jinwá quelel liji quinam. Dios pü'ü nt'a más 'ücj jisas nsem jupj mpes, pülücj 'üsüs witjacj jilal.” ");
INSERT INTO jicNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús p'a parábola tjevele quinam. (Newa sin tji'yüsa lis tjiji Dios pajal quelel liji gentas.) Nin tjevele jupj: “Quepj t'emel c'a diéziya tya'a ca nacj. Pjaní palá yaca, ne ma si nuc ca nacj. Nin tepyala na, t'üc' way 'iyó si müjü, lepa jupj. Ca wa la majapjunus, ca la mpalas jupj t'emel. Jus tjinyuca nas ca la mpalas. Lovin nin lajay nequem. ");
INSERT INTO jicNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jus tjinyuca na, 'a jis mulus ca jupj jomicapan, la p'a wa ne'aj patja 'ots'ipj. Jupj ca mveles yupj jilal: ‘'Ücj nujisas t'as napj lal. Napj nt'emel palá tjeyaca, ma si nuctsja, nasa jus tjinyuc.’ Nin ca mveles jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nin p'iyá Dios angelpan 'ücj jisas yom pjaní way mpes, quepj pjaní way mpes. Malálatsja ca nacj jupj püná. Quina ma jos niná jupj malala la tjijá; 'üsüs quelel liji quinam Dios jos jinwá.” ");
INSERT INTO jicNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús p'a parábola tjevele quinam. (Newa quelel sin 'yüsa líjitsja Dios pjü quelel la siji.) Jesús tjevele: “Yom pjaní, mat'e jatjampan jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ts'ac' pjaní jatjam pjyapja tjevele popay lal: ‘Mpapay, jipj quelel ne 'antsja jipj jits'a'á popé, quina ma 'en’. Mpes jupj popay pjaní pjaní jis tje'yaya jatjampan manas pjü yupj yuts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","P'a jyawca na, jatjam pjyapja pjü vender la tjiji jupj popay tje'yayá. T'emel lal pajal campa tjemey popay mpe. Tjemey nt'a malala nyuca la tjiji. Pjü jis tje'yaya t'emel. Tecyawaja. ");
INSERT INTO jicNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","”Pjü jupj juts'a'á cjuwatsja na, pjü cjuwatsja wa jis la las jupj tüpü'ü nt'a. Pues pjü cjuwatsja jis la las ne'aj. Mpes cjuwatsja wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tjemey jupj, yom ne'aj tüpü'ü nt'a. Quelel tsji' líjitsja yom mpes. Yom niná jas tjejyama jupj malana lyawun̈ nt'a, jupj ca jis ma'ayas jis la las. ");
INSERT INTO jicNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pajal vecj pé'etsja jupj. Malana jalá po jostsja wa jupj. Pjü 'aya secj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Locopyaya 'üsüs jola tepyala jupj. Jupj jólatsja: ‘Mpapay jomozopan pülücj si manuna. Pülücj jatatj jis la las yupj pjü. Napj qui'á 'os, vecj ni pü'í. ");
INSERT INTO jicNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mpes ca nin müjünsǘ, ca mis quinam mpapay nt'a. Ca mvelé jupj lal: “Mpapay, malala nyuca la tjejay napj Dios lal, jipj lal 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jetjam tulucj jinwá napj quinam. 'Üsüs tulucj napj jipj lal. Nin nt'a ma 'en tsji' la mejay, Mpapay. Jipj myozo nsem napj.” ’ ");
INSERT INTO jicNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nin la tjiji jupj. Jas nisa, tjemey popay nt'a. ”Custjay campa wine p'in, jupj popay jus tjinyuca jupj. Popay po jólatsja malala tepyala jatjam. Ts'üequené tjemey la nüjüsü jupj. Col tjevyala jupj. Po 'ücj jostsja jatjam tjac'. ");
INSERT INTO jicNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","”Jupj jatjam tjevele popay lal: ‘Mpapay, malala nyuca la tjejay napj Dios lal, jipj lal 'ots'ipj. Jetjam tulucj jinwá napj quinam. 'Üsüs tulucj napj jipj lal.’ ");
INSERT INTO jicNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jupj popay ma nin jólatsja jupj. Tjevele jomozopan jilal: ‘Len̈ way nin quip más 'üsüs way nca'á ma 'e, jas nqui'pá natjam. Anillo nca'á ma 'e, mos tjo'onsó. Zapato nca'á ma 'e wa, tsjom tjo'onsó. ");
INSERT INTO jicNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Vaca tsjicj t'ünt'ün ncumaná mü'ü'ná 'ots'ipj. Nlajam ca, pajal 'ücj qjuisas nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Natjam tepe'e jin nólatsja, newa pü'ü. Jupj len̈tsja; jus tjinyuc quinam.’ Nin tjevele popay, mpes 'ücj jisastsja pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”Nin tepyala na, jatjam mwalá tsji' liji nt'a tjá'asa jupj. Yacjaya tjac' jupj wo nt'a. Ne'aj p'in tjac' na jupj wo nt'a, nepé jatül jin tjapjaca jupj. Ne'aj bailar lajay jin tjapjaca jupj 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","La tjemyona tjac' mozo pjaní, la tji'yüya tsjan tepyala quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mozo jupj wola tjevele: ‘Jitsipe tjac', mpes pyapay vaca tsjicj t'ünt'ün tji'yü'na jis la las. Jitsipe 'ücj pü'ü tjac' niswá pyapay nt'a, mpes nin la tjiji jupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”Mpes jatjam mwalá ts'i tji'ina. Ma quelel wama jámatsja. Yacjaya popay jus nleya pje'á tjá'asa jupj, mpes tjemey, tjinyuca jupj. ‘Wama was, Natjam’, tjevele. ");
INSERT INTO jicNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jatjam mwalá ma jostsja. Jupj tjevele popay lal: ‘Año pülücj lovin tsji' la tjejay napj jipj mpes. Lovin ntjijütütj la tjejay napj. Mop'in ma ntje'an cabro tsjicj la las, najamicapan jilal la las. ");
INSERT INTO jicNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Niná jetjam, malala nyuca la tjiji. Jipj jet'emel pjü jis tje'yaya nequem malala witjacj. Jupj tjac' na, tji'yünan vaca tsjicj t'ünt'ün jupj mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mpes jupj popay tjevele jupj lal: ‘Natjam, lovin napj lal püt' jipj. Pjü napj nats'a'á jipj jits'a'á wa. ");
INSERT INTO jicNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Najastsja 'ücj qjuisas nsem quinam jetjam niswá tjac' mpes p'in. Tepe'e jin nólatsja, newa pü'ü. Len̈tsja jupj, ne niswa jus tjinyucucj.’ ” (Parábola niná t'üc' tjevele quinam Jesús. Sin tji'yüsa lis tjiji Dios quelel liji wa malala witjacj.) ");
INSERT INTO jicNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús p'a parábola tjevele wa discipulopan jilal. Parábola mpes sin tji'yüsa lis tjiji más 'ücj 'üsüs lajay yupj jis t'emel lal Dios jos jin. Nin lajay, más 'ücj ca nsem yupj mpes, Dios nt'a jil na. Jesús tjevele: “Yom pjaní t'emel pülücj tyá'atsja, mozo tya'a watsja jupj, pjü jis lo jütütj jupj juts'a'á. Ts'ac' pjaní tjejyawca na, p'a wa tjat' tjowelepj mozo niná po'ó. Tjowelepj mozo niná malala nyuca la tjiji, pjü jis tje'yaya yom juts'a'á. ");
INSERT INTO jicNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mpes yom niná la tjemyona ncuwim jomozo, tjevele jupj lal: ‘¿Tsjan pjucj nin la tjejay jipj? Ca mvelen tsjan la tjejay napj nats'a'á jilal. Ca mvelen nol netj napj mpes, nol jis tje'yan napj mpes 'ots'ipj. Napj namozo tulucj ca nsem jipj quinam.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","”Mpes jomozo jólatsja: ‘¿Tsjan ca la mejay napj quepé tjum nam? Napj mpatrón nin jyama, mpes jupj jomozo tulucj ca nsem napj quinam. Ma polel tsji' lejay nampa yümücj. Niná ma lejay napj. Ma wa quelel mocj la cümon. Pajal ne mayca nin lejay. ");
INSERT INTO jicNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Selé quinam tsjan ca la mejay. Ninana lejay mpes, nepénowa 'ücj jisas nsem napj pü'üs yupj jilal, jupj nin tjejyama na.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”Mpes jomozo pjü lis tjemyona ncul level lajay, jupj patrón lal level la tjajay. Pjaní pjaní lis tjemyona ncul. Mwalá lal tjevele: ‘¿Nol level jipj napj mpatrón lal?’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Level liji tjevele: ‘Cien tina level napj aceitas’. Mpes mozo tjevele jupj lal: ‘Nca' pyapel, jipj cien level vele jupj. Nt'i'isa, pyapel seyasa tepyaca jipj, cincuenta ca level nsem jipj la p'in.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Locopyaya mozo tjevele p'a wa lal, level liji watsja jupj. Tjevele: ‘Ne jipj ¿nol level jipj?’ Level liji tjevele: ‘Cien carga level napj trigo’. Mpes mozo tjevele jupj lal: ‘Nca' jipj pyapel, jipj cien level vele jupj. Pyapel seyasa tepyaca jipj, ochenta ca level nsem jipj la p'in.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”Malala waytsja mozo nin la tjiji. 'Ücj tulucj jupj, mop'in jupj patrón 'üsüs pjac tjevele jupj po'ó, mozo 'üsüs nyuca jólatsja mpes. Dios ma jisas 'üsüs nyuca yola tsjan más 'ücj lajay yupj, p'a wa Dios ma jisas jilal. Dios ts'uyupj jaw nt'a patja jinwá yupj Dios mpes, newa ma pajal 'üsüs nyuca yola tsjan más 'ücj lajay yupj, p'a wa Dios ts'uyupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","”T'emel 'üsüs tulucj, mop'in más 'ücj 'üsüs la müjí nun jis t'emel lal, Dios jos jin. Nin lojí, 'üsüs ca nu mpalas. Dios lovin ma jo' mpa'is 'üsüs la tjüjí. Mpes co'liqué na, 'üsüs nsem. Potjaqué na Dios lal, Dios 'ücj jos nsem nun jilal 'üsüs la tjüjí mpes. Nin velé napj. ");
INSERT INTO jicNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”Nun popa Dios jyü'ta jin liji pjaní way lal, Dios jyü'ta jin ca la mijis wa pülücj lal. Ma Dios tjijyü'ta jin liji pjaní way lal, ma wa Dios jyü'ta jin ca la mijis pülücj lal. Nin lovin. ");
INSERT INTO jicNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","T'emel tsjicj way pajal Dios lal. 'Üsüs tulucj. Mpes nun ma Dios jyü'ta jin lojí t'emel lal, jupj ma ca nu ma'ayas jupj juts'a'á 'üsüs way, nun jis la jamas jupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nun ma jupj tjijyü'ta jin la tjüjí jupj juts'a'á lal, Dios ma ca nu ma'ayas tsjan nun nuts'a'á nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Nun ma polel lojí Dios jyü'ta jinwá, nun pajal t'emel nujos na. Nin p'iyá mozo ma polel tsji' liji niyom mat'e mpes nin jawas p'in. Mozo ma ca quelel t'üc' la mijis jupj patrón pjaní tjijyü'ta jinwá. Ma'ajapj tjijyü'ta jin ca quelel la mijis ca nacj. Nenéyawa ca cus ncon̈cos mwalá way p'in. Ma ca jos nsem ma'ajapj. Nin p'iyá nun ma polel pajal nin nujola t'emel mpes, Dios mpes tsji' lojí na”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseopan nin tjepjyacan̈ na Jesús tjevelá, pajal la tjüpjüts'ün. Yupj pajal jisastsja t'emel. ");
INSERT INTO jicNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús seletsja nin tjowelepj yupj, mpes jupj tjevele yupj jis lal: “Nun welé gente jis lal nun p'iyá 'üsüs; mop'in malala nun. Dios selé tsjan t'üc' way nujola. Gente p'in yola nun pajal 'üsüs. Niná nun lojí pajal malala Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”Juan el Bautista custjay ma tjac' na, Moisés popel to'atsja, profetapan tapac to'atsja wa. (Yupj pjü way tapac Dios mpes.) Po quina Juan el Bautista tjac' naya mpe, napj velé pülücj jis walap'a'á. Nin velé Dios ca müjü'tüs nosis nt'a. Pjü way po jisas ca Dios si jütüta popa jis mpalas yupj. Pjü polel lajay, pjü nin lajay, 'ücj jis la winin ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","”Newa ca nin mpalas Moisés popel vele jin, jupj niná tepyaca Dios tjijyü'tá. Dios lovin ma ca jo' mpa'is jupj tjijyü'tá. Tsjicj way p'in jo' pe'e tulucj. Tsjun po'ó ca ncawajas; mop'in ma ca jo' mpa'is Dios. Nosis ca ncawajas; mop'in ma ca jo' mpa'is Dios. ");
INSERT INTO jicNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”Yom se jamá mim jats'om, p'a lal woya jupj ca nacj. P'a lal woya na, Dios ca mveles ma jats'om ne'aj mya'na jupj. Nin p'iyá jats'om lal woya lal. P'a yom jats'om lal woya, Dios ca mveles ma jats'om ne'aj mya'na jupj. Malala lajay p'in Dios lal”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","(Jesús sin 'yüsa la síjitsja más 'ücj pyonecj Dios Popel tjevelá, ne nin ca la mijicj Dios tjevele jin.) Nin tjevele Jesús: “Yom tüpü'ü, t'emel pülücj tyá'atsja. Lovin jas tücüi'pe pülül je. Lovin pülül pülücj jaylacj, po 'üsüs yustapj jas tücüi'pe jupj. Pjü jyawca pülücj la las la tjiji, pülücj tjelyaja jomicapan jilal, mpes 'ücj jos tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ts'ac' pjaní p'a witjacj tjiquil jupj wo t'asiyú tjüwücj jun vilicj nt'a, yom tüpüntüpj, tjil. Pjü cjuwatsja yomen. Lázaro lotsja jupj. Jüp'üy jas tüpwes püts'ey. ");
INSERT INTO jicNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pajal vecj pé'etsja. Quelel lyájatsja na'aj la ts'iya popé, yom t'emel pülücj jupj ve palá tinca popé. Mop'in t'e'enca secj jupj. Más malala tepyala wa jupj. Tsjiyó witjacj tjiquil, jupj püts'ey tüpwis 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","”Locopyaya nin pues cjuwá tepe'e Lázaro. Angelpan tjaman jupj Dios pü'ü nt'a. Ne'aj Abraham pü'ü wa quinam. Yomen t'emel pülücj, tepe'e wa jupj, jupj 'a toctsja. ");
INSERT INTO jicNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Malala nt'a tjemey jupj, 'awa püné mo'o tjemey. Ne'aj pajal 'aplijila tjá'asa. Ne'aj tjá'asa nepé Abraham pajal campa ton̈ca tjinyuca. Jus tjinyuca wa Lázaro Abraham lal. ");
INSERT INTO jicNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jupj 'awa püné mpe yümücj tjevele: ‘Ncocoy Abraham, jele t'as malala ntepalá. Ncapj tjep'ya'sa. Jas tjejyama Lázaro napj nt'a, 'üsǘ mo'o le 'et'é, palá ts'yosa, ca mpelam po la mo'ot'es, más 'in tsjo ca ma palas. Pasal 'aplijila napj 'awa mo'o jüs, mpes le mon.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”Abraham jupj wola tjevele: ‘Natjam, jele t'as nosis nt'a tüpüt' na, pülücj netj jipj pajal 'üsüs. Lázaro nt'ya malala waytsja. Quina 'ücj jos tepyala Lázaro; jipj pajal li piyun. ");
INSERT INTO jicNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","P'a nin p'iyá velé wa: ne'aj ts'entuna pajal campwila 'i jipj 'i napj. Mpes quepé quelel jil nun nt'a, ma polel jil. Nin p'iyá jipj jac' nepé, pjü ma polel jiquil wa cupj nt'a. Yoquin cjuwá’, tjevele Abraham. ");
INSERT INTO jicNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","”Yom 'awa püné mo'ó, wola tjevele jupj: ‘Nin mpes la 'e mon, ncocoy, jas majaman Lázaro, müjü'tün jupj napj mpülücpan nt'a ca mim. ");
INSERT INTO jicNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cínquiya mpülücpan napj. Lázaro ca mveles yupj jilal ca malala jis mpalas yupj, yupj malala lajay, napj lejaytsja jinwá. Jupj ma jama yupj nt'a, ca ncul wa yupj qui'á, malala nt'a, ca nacj. Nt'a po malala ne palá napj lovin.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","”Abraham tjevele jupj lal: ‘Moisés tepyaca Dios tjijyü'tá. Jupj Popel jatatj yupj. Profetapan tapac püná Dios po'ó jatatj wa yupj. Más 'ücj yupj jis tjüjütütj jin la mijicj pyülücpan. Nin lajay, Dios ma ca jis capj ntülüs yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","”Yom 'awa püné mo'ó tjevele: ‘Nin tulucj, ncocoy Abraham. Tepe'e jama yupj nt'a, yupj ca yola mpalas malala nyuca la tjajay. Ma ca jisas nsem newa malala lajay yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”Abraham wola tjevele jupj: ‘Ma jisas Moisés tepyacá, ma jisas profetapan tapac, ma wa ca jisas nsem jupj velá, yom püna tepe'e jas nisa, pü'ü niswá. Newa ma ca mponecj jupj velá.’ ” Nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Locopyaya Jesús tjevele jupj discipulopan jilal: —T'üc' way nepénowa malala nyuca lajay mpes p'a witjacj malala quelel lajay wa. Malala ca jis mpalas pajal, niná lajay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más 'üsüs nsem yupj mpes la p'a pe püné jis men ntsu'pacj mvalacj, 'üsǘ püné mo'o ca la nts'iyacj, nca'lin̈. Más malala nsem yupj mpes yupj malala nyuca lajay ne ca tsjicj pjaní malala nyuca la mijis wa, yupj la tjajay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'In tjajama. ”Jetjam malala nyuca la 'iji na, cus tjeve'le. Jupj jola mpalas malala nyuca la tjiji ca nacj, ne ca 'üsüs la mijis quinam. Nin la tjiji na, jipj ca mya 'ü'süs jupj lal. Jipj ca perdonar la mijin jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","La siete malala nyuca la 'iji ts'ac' pjaní ca nacj. La siete jipj nt'a jac' wa, jupj vele jipj lal: ‘Malala la tjejay jipj lal. Ma ca nin la mejay quinam.’ Nin liji na, jipj ca mya 'ü'süs jupj lal niswá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolpan tjowelepj qjuis Jepa Jesús lal: —Qjuis capj tjep'ya'sa más 'ücj qjuis la pon jipj velen. ");
INSERT INTO jicNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jupj tjevele: —Tsjicj way p'in poné na, setel tsjicj way jinwá, 'ücj ca mvelé ts'oway lal: ‘Tepyocja, 'üsǘ püné mo'o 'isine jipj’. Ne nun welé jin ca la mijis jupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","(Jesús sin tji'yüsa lis tjiji 'ücj jajütütj Dios mpes, jupj lal japon na.) Ninana jupj tjevelá: —Nun popa pjaní jomozo tya'á ca nacj. Jomozo 'amá le tsjec ca nacj, oveja jyama ca nacj. Mozo tsji' liji mpe jac' na, ¿ncu nun popa ca mveles jomozo lal: ‘Len̈ way was. Nt'i'isa la las?’ ");
INSERT INTO jicNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma nin ca mveles jupj. Ca mveles jomozo lal: ‘'Ücj la tjiji napj nla. Jin quip 'ulupela la mijin. Pjü najas jipj ca ma 'en lya na, mü'üs na wa. Yacjaya jipj ca nlajan wa, ca mü'üm wa.’ ");
INSERT INTO jicNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jupj ma ca mveles jomozo pajal 'üsüs, jupj tjijyü'ta la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nin p'iyá nun jilal. Nun napj namozopan. Pjü la tjüjí na Dios nu jyü'ta, nun ca mvelé: ‘Mozopan 'üsüs tulucj cupj. Qjuis tjijyü'ta la tjijicj la p'in, pjü mozopan lajay jin’ (—nin tjevele Jesús ca nin mpalas cupj jyü'tücj na Dios mpes.) ");
INSERT INTO jicNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús newa jámatsja Jerusalén nt'a. Galilea la nipj tjemey, Samaria la nipj tjemey wa. ");
INSERT INTO jicNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nepénowa patja nt'a ne'aj p'in tjac' na, niyom diéziya la nyüjüsün̈ jupj. Malala jisastsja pajal, jis pjoloc' tjamaja mpes. Mpes sin tjan nyüjünsünün̈ yupj. Ma quelel jacutsja malala jisas sin popé. ");
INSERT INTO jicNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Campa mpe yümücj tjowelepj: —Jesús, qjuis Jepa jipj. Qjuis capj tjep'ya'sa, malala qjuis tepyala mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yus tjinyuca na, Jesús tjevele yupj jis lal: —Sacerdotepan nt'a lowa nun. Yupj ca nujus nucucj, nun jis p'üy ca la mpalacj ncu malala lo nuc —tjevele Jesús. Mpes tjil malala jisas. Custjay jiltsja na, jis tji'yü'sa yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jus nlay jis tji'yü'sa, ne pjaní way yupj sin popé tjac' niswá. Po 'üsüs pjac tjevele Dios po'ó. Yümücj tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Palá nipi'tje jupj Jesús wolap'a'á. Tjevele tjüwüi'i pajal Jesús lal, tji'yü'sa la tjiji mpes. Samaria mpe 'eseptsja jupj, judío tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús jupj wola tjevele: —Diez witjacj jis tji'yü'sa. Nueve len̈, ma niswa tjiquil yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pjaní way p'in niswa tjac' 'üsüs pjac la veles Dios po'ó. Niná judío tulucj, napj negente tulucj jupj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tjevele wa tji'yü'sa lal: —Jin ni'isa nucun, napj jin jyam quinam. Tepyon napj tjevelé, mpes 'i tjü'ü'sa —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseopan Jesús lal la tjü'üy 'ona Dios ca Jepa ma'ajam nosis casá. Jesús jis wala tjevele: —Dios Jepa já'asa na, cjuwá tsjan ca nucú, ca jus cülayé ca nin mpalas quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma ca mvelecj: ‘Qui'á nin pyala’. Ma ca mvelecj: ‘No'oj nin pyala’. Nusin tjü'üsüs nina: nasa jyü'ta jupj quinam, gente jisas mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús tjevele wa discipulopan jilal: —Napj p'iyá niná Yomen Dios jas tjejyamá. P'a jawas nun pajal ca nujos nsem napj mpü'üs nun jis lal niswá, quina nun lal pü'üs jinwá. Po ca nujos nsem ts'ac' pjaní way p'in niswa ca mpü'üs nun jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nepénowa ca mvelecj nun jilal: ‘Tjunuca. Qui'á já'asa jupj. Tjunuca. No'oj já'asa jupj.’ Ma lowa nun. Ma ca nlawú yupj jilal. ");
INSERT INTO jicNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Napj cuwis na, ca pjü jus nlayecj. Menmené la mena pjü jyawca liji; nin p'iyá ca nsem napj lay ne palá na. ");
INSERT INTO jicNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mwalá way p'in pajal malala ca ma palas; ma wa ca quelel la ma jicj quina patjá. ");
INSERT INTO jicNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”Napj quelel cuwis naya, nin p'iyá ca nsem Noé tüpü'ü na jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé tüpü'ü na, ma japontsja ca malala mpalas. Newa jalatsja, myü'ün̈tsja. Newa wyayin̈tsja yupj. Lovin nin p'iyá lajaytsja. Nin p'iyatsja Noé barco wama tjemey jawas. Yacjaya pajal püné tjive. T'yüna 'üsǘ, ne pjü sey jis la tjemey, tecya'lin̈. (Nin p'iyá ca nsem, napj quelel cuwis naya. Ma ca jus nlayecj len̈ way Dios ca jis capj ntülüs.) ");
INSERT INTO jicNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","”Nin p'iyatsja Lot tüpü'ü na püná. Ma yólatsja yupj. Newa jalatsja, newa myü'ün̈tsja yupj. Jaylacj lajaytsja 'ots'ipj, vender lajaytsja 'ots'ipj, jis wa sin jajünsüptsja 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pjü newa nin lajaytsja, Lot Sodoma nepé tjemey nas. (Nin jawas p'iyá Dios jis capj tyüla Sodoma nt'a tapatjá, malala nyuca la tjajay mpes.) 'Awa tjive, pe pwe tjive la tjiji Dios, mpes pjü jis tji'yü'na ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Napj lay ne palá na, nin p'iyá ca nsem. (Ma ca jus nlayecj tsjan ca mpalas.) ");
INSERT INTO jicNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”Dios nasa jis capj tyüla na, más 'ücj ts'üequenequé. Yom wo jay nt'a ntojom ca nacj, nin pyala na. Jupj juts'a'á wo mo'ó jatja. Más 'ücj len̈ way ts'üequené, ne ma pje'á le queyé jupj juts'a'á wo nepé. Jupj sine lejen̈ nt'a ton̈ca, más 'ücj ma jama lo ta'es jupj juts'a'á mpes. Más 'ücj len̈ way ts'üequené. ");
INSERT INTO jicNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nujola tapalas Lot jats'om. (Malala tepyala, tepe'e, ma quelel jámatsja mpes.) ");
INSERT INTO jicNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","(Nin lovin.) Nun pajal nin nujola 'onin ne 'ücj mpatjaqué nosis nt'a, ma ca mpatjaqué Dios lal. Nun pjü jatja lowú Dios mpes, 'ücj mpatjaqué Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","”Napj cuwis na, napj ca man nepénowa napj nt'a. Nepénowa ma ca jis man. Mát'eya ca cjan mpatjam püste na ca nacj, napj cuwis na. Pjaní way ca man. Pjaní wa ca ne'aj mpü'üm. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nequem mat'e jun pjaní nt'a ncjocjocj ca nacj, napj cuwis na. Pjaní way ca man napj. Pjaní wa ca ne'aj ntojom. ");
INSERT INTO jicNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Niyom mat'e 'a mulú me'elecj yupj jasin nt'a ca nacj, napj cuwis na. Pjaní way ca man napj. Pjaní wa ca ne'aj ntojom —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jupj discipulopan tjowelepj jupj lal: —¿Ca'aj ca nin mpalas niná pjü? Jis wala tjevele: —Tepe'e jüp'üy pü'ü nt'a, ne'aj 'a jis mulus montes. (Nin p'iyá gente pajal malala lajay nt'a, ne'aj ca ncuwis, jis capj la tül.) ");
INSERT INTO jicNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús parábola p'a wa tjevele yupj jilal. Parábola mpes sin 'yüsa lis tjiji más 'ücj lovin Dios lal la mon jis capj mp'a'sas. Ma jis capj tjep'ya'sa custjay, más 'ücj newa la nuc Dios ca jis capj mp'a'sas. T'üc' way jupj ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ninana parabolas Jesús tjevelá: “Yom püné tüpü'ü pülücj patja nt'a. Juez waytsja jupj. Ma lecj jéyatsja Dios ca cus ntülüs jupj. Ma wa jólatsja gente sin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Quepj, voyum tepe'e, ne'aj tüpü'ü wa jupj, pülücj patja nt'a. 'Üy'üy way jactsja jupj juez nt'a, véletsja: ‘Ncapj tjep'ya'sa ma malala la ma jis napj ne'enemigá.’ ");
INSERT INTO jicNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Püs way juez ma quelel se p'á'satsja jupj. Locopyaya jupj jólatsja: ‘T'üc' way napj ma lecj jeyá Dios lal. Ma wa nola gente sin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mop'in ca cus mp'acj jupj. Quepj niná newa pajal le moná napj lal, mpes cus mp'acj ca napj. Ma nin lejay, pajal ca nin tulum, lovin jac' mpes’, nin jólatsja juez.” ");
INSERT INTO jicNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Qjuis Jepa Jesús tjevele: “Nujola t'as juez malala po'ó. Nujola t'as jupj tjevelá, quepj lovin la tjemyona mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dios más 'üsüs juez lal. T'üc' way jupj ca jis capj mp'a'sas jupj ts'uyupj, yupj lovin la mon mpes, jaw na la mon wa, püste na la mon wa. Dios lis t'ya yupj. ¿Ncu pajal ca la nucus jis capj la p'acj? Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Len̈ way ca jis capj mp'a'sas, jis enemigopan ma malala lis mijicj. Nin velé napj nun jis lal. Napj p'iyá niná Yomen Dios jas tjejyama nun nt'a. Nosis nt'a cuwis na 'üsüs la jay ¿ncu nosis casá patja ca mponecj Dios quelel jis capj p'ya'sa yupj?” nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","P'a parábola tjevele wa Jesús nepénowa ne'aj tjatja jilal. Yupj p'iyá 'üsüs Dios lal jin yólatsja. Yupj yólatsja la p'a wa 'üsüs tulucj. Mpes Jesús sin tji'yüsa lis tjiji más 'ücj ma 'üsüs jin yola yupj p'iyá. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Niyom mat'e tjil Dios wo nt'a jis la veles Dios lal. Pjaní fariseo waytsja. (Ne'aj patja yólatsja jupj 'üsüs.) Ma'ajapj t'emel t'e'éncatsja jepa mpes. (Ne'aj patja yólatsja jupj malala.) ");
INSERT INTO jicNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo 'ücj jus la nuc nt'a ton̈ca jupj, tjevele Dios lal. (Pajal 'üsüs way jupj p'iyá, tjevele.) Nin tjevele: ‘Dios, la p'a witjacj malala yupj. Wüi'is yupj jin tulucj napj. Pwecapan yupj nepenowá. Malala nyuca lajay yupj nepenowá. Nepénowa ne'aj jamanun sejats'om tulucj. Yom qui ton̈ca jin tulucj wa napj. T'emel t'e'enca jupj jepa mpes. (Malala jupj pajal.) ");
INSERT INTO jicNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Napj 'üsüs lejay jipj mpes. Ts'ac' mat'e pjü semana ma lya, 'üsüs quelel lejay mpes. Pjü napj tyatj popé, pjü diez popé, pjaní 'e 'a 'ots'ipj.’ Nin tjevele fariseo. ");
INSERT INTO jicNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","”Yom ma'ajapj, t'emel t'e'éncatsja jepa mpes. Tsjicj way p'in wama tjemey Dios wo mo'ó. Ma jostsja la p'a jus la nuc. Ma tsjun po'o tjinyuca jupj. Mop'in jos suna tyüla 'aplijila mpes. Pajal nin jólatsja jupj malala nyuca la tjiji. Tjevele Dios lal: ‘Malala nyuca lejay napj lovin. Ninpe jele t'as. Ncapj tjep'ya'sa.’ ” ");
INSERT INTO jicNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesús tjevele: “Yom t'emel t'e'éncatsja 'üsüs tepyala Dios lal. Ma'ajapj malala waytsja custjay. Nin velé napj nun jis lal. Püné jin jola jupj p'iyá, Dios ca tsjicj way la mijis jupj. Nin lovin. Tsjicj jin jola jupj p'iyá, Dios más püné ca la mijis jupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nepénowa tjaman wa tsjictjacj Jesús nt'a. Jisastsja Jesús ca po la mo'ot'es tsjictjacj sey pjucj, mveles ca 'üsüs jis mpalas Dios mpes. Jesús discipulopan yus tjunuc tjiquil ne'aj, ne jis capj tjowelel tsjictjacj tucuman mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús ma jostsja discipulopan nin la tjajay. Tjevele ncul tsjictjacj. Tjevele wa discipulopan jis lal: “Jis ma'ayá ca ncul tsjictjacj napj nt'a. Po ma jis müjü'tǘ ma ncul. Gente japon tsjictjacj japon jinwá, Dios 'ücj si jütüta yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Ücj tsjictjacj jis lal Dios si jütüta. Gente ma jisas Dios si jütüta yupj, tsjictjacj si jütüta jinwá, ma ca Dios popa jis mpalas yupj. T'üc' niná”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Judiopan jis jepa pjaní tjevele Jesús lal: —'Üsüs way jipj. 'Üsüs sin 'yüsa lejay. Najas mvelen napj lal tsjan más 'ücj la mejay napj ne Dios ca ma'ayas napj ca 'ücj mpü'üs lovin jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús jupj wola tjevele: —¿Tsjan mpes tjevelen napj 'üsüs way? Dios p'in 'üsüs way jupj. (¿Ncu quelel velen napj p'iyá Dios?) ");
INSERT INTO jicNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jipj selen Dios tjijyü'tá jupj Popel mo'ó. Tjijyü'ta yom ma ca ne'aj ma'nus jats'om tulucj, quepj ma ca ne'aj mim voyum tulucj lal, ma ca mü'ü'nan p'a wa, ma ca mpequem, ma la ntsawilin. 'Üsüs la mijin pyapay lal, jemay lal wa. Jele nsem noypan yupj jipj lal. Niná Dios tjijyü'tá —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yom judiopan jis jepa tjevele: —Lovin nin la tjejay. Napj tsjicj waytsja na p'in lovin nin la tjejay. ");
INSERT INTO jicNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús tjapjaca na niná, tjevele jupj lal: —Pjaní ma la tjejay custjay. Pjü vender la mijin jipj jits'a'á. T'emel niná jis ma'ayan t'emel cjuwá. Nin la tjejay na tsjay pülücj ca nta'an Dios pü'ü nt'a. Nin la tjejay na ncuwim, ncapj ncon̈con. ");
INSERT INTO jicNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yomen tjapjaca na niná, 'aplijílatsja jupj pajal. Ma quelel líjitsja Jesús tjevelá. Pajal pülücj tyá'atsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús tjinyuca pajal 'aplijílatsja jupj. Tjevele: —Pajal costa way pülücj jatatj Dios si jütüta popa se palá. ");
INSERT INTO jicNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pajal costa way camello jav jul casá jama. Camello ma polel nin liji niná. Más 'in costa way pülücj jatatj Dios si jütüta popa se palá yupj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Niná tjepjyacan̈ tjowelepj: —Pajal costa way Dios si jütüta popa se palá yupj. Pjü way ma 'üsüs se palá Dios lal ca nacj, pjü ma mpatjam Dios lal ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mpes Jesús tjevele: —Niná gente ma polel lajay, 'ücj nin liji Dios. Dios 'ücj jis capj p'ya'sa 'ücj jis la püt'üs jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro tjevele Jesús lal: —Cupj cuts'a'á jatja tjeleque jipj lal, cyapj la con̈. ");
INSERT INTO jicNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mpes Jesús tjevele discipulopan jilal: —Nun nuts'a'á jatja tjalawú napj lal, 'üsüs pajal napj lal. Po 'üsüs ca nsem nun jis lal nin la tjüjí mpes. Nepénowa quelel lajay Dios jyü'tá, mpes jil jis wa nepé ca nacj, jil sejats'om mpe wa ca nacj. Nepénowa jil jis pülücpan nepé. Nepénowa jil sejamay nepé ca nacj. Jil wa jis papay nepé nepenowá. Nepénowa sin popa nepé jil. T'üc' way ");
INSERT INTO jicNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pajal pülücj ca jis ma'ayas Dios nosis nt'a patja na, nin la tjajay mpes. Más pülücj ca nt'anquecj jatja tjil jis lal. P'a wa ca jis ma'ayas wa. P'a jawas, napj niswa tjacuwis nam, lovin ca mpatjam yupj Dios lal —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Locopyaya sin tjan jis lal tjemey Jesús, discipulopan dóceya jis lal. Jupj tjevele yupj jis lal: “Jerusalén nt'a leque. Ne'aj pjü ca ma palas profetapan ninpe tapac püná. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ne'aj Jerusalén nt'a, Dios ca jis ma'ayas judiopan tulucj malala la ma jicj. Yupj la mpjüts'ünücj ca napj lal. Ca nin po'o mvelecj malala napj. Ca ncapj mputs'acj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ca ma süpücj, ma 'ü'nacj ca. Ntipü'í na, nin müjünsǘ, mpü'üs niswá ts'ac' cont'e tepyala na”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Niná jupj tjevelá ma sin tji'yüsa discipulopan. Ma polel sin tji'yüsa yupj. Ma jus nlaytsja tsjan po'o tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús newa jámatsja Jerusalén nt'a. Ne'aj p'in tjemey quinam Jericó nt'a, pülücj patja nt'a. Ne'aj tjá'asa yom jun tulucj jümücj la nt'a. T'emel la tjemyona ne'aj jiltsja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsjay pülücj ne'aj jil jin tjapjaca jupj, mpes jupj la tji'yüya tsjan mpes pülücj tjil. ");
INSERT INTO jicNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nepénowa tjowelepj jupj lal: —Jesús ne'aj wa jama. Nazaret mpe 'esepj jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Niná tjapjaca na, yom jun tulucj la tipiya: —Jesús, ncapj tjep'ya'sa. Dios jin tjejyama nosis nt'a. David püna tüpü'ü popa p'iyá jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mwalá tjil sin popé cus tjowelel yom jun tulucj. —Lyájasa t'as —tjowelepj jupj lal. Más yümücj la tipiya jupj: —Ncapj tjep'ya'sa. Dios jin tjejyama. David püna tüpü'ü popa p'iyá jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mpes Jesús tyantaná, tjevele ca yom jun tulucj lal ncul jupj nt'a. Yom jun tulucj tjac' na, Jesús la tji'yüya jupj lal: ");
INSERT INTO jicNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tsjan jyas napj lejay jipj mpes? Yom jun tulucj tjevele: —Nejepa, po quelel nyuc napj. ");
INSERT INTO jicNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús tjevele jupj lal: —'I tjü'ü'sa catsj quinam. Jipj tepyon napj polel 'i 'ü'sa lejay mpes 'ücj quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Len̈ way yom jun tulucj 'ücj nyuca tepyala jupj. Cus tecyon̈ca Jesús, 'üsüs pjac tjevele wa Dios po'ó 'üsüs tepyala mpes. Pjü ne'aj tjunuc tji'yü'sa la tjiji, 'üsüs pjac tjowelepj wa Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericó nt'a ne'as tjemey. Newa jámatsja Jerusalén nt'a. Culupwen nipj tjemey Jericó mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne'aj yom tüpü'ü Zaqueo ló. T'emel t'e'éncatsja jupj jepa mpes. Nin la tjiji, tüpü'ü jupj. Niyom p'a wa ne'aj natj wa t'emel jepa mpes. Zaqueo yupj jis jépatsja jupj. T'emel pülücj tyá'atsja jupj, Zaqueo. ");
INSERT INTO jicNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueo po quelel si nucutsja Jesús. Quelel nyúcatsja cana jupj. Ma polel si nucutsja pajal pülücj tantan tjelyawun̈ mpes. Zaqueo 'amá 'alá tón̈catsja, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nin mpes mwalá way ts'üequené jupj, ts'oway jay tjemey, Jesús quelel nyúcatsja mpes. Yon ton̈ca jin jámatsja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús yon ton̈ca nas tjemey, yon jay nt'a tjinyuca, Zaqueo ton̈ca nt'a. Tjevele jupj lal: —Zaqueo, len̈ way palá was. Mpapay Dios jos napj jum wya nt'a la püt'üs yacjam. ");
INSERT INTO jicNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mpes len̈ way palá tjac' Zaqueo. 'Üsüs jos la nüjüsü Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","La p'a wa ne'aj tjelejen̈, tjunuc Jesús tjemey Zaqueo lal, mpes pjü way tülü way tjowelepj malala la tjiji Jesús. Tjowelepj: “Yom malala lal tjemey, wo nt'a ca ma'ajam”. ");
INSERT INTO jicNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","T'üc' way ma sin 'yǘsatsja yupj. Zaqueo pjü jis walap'a'a tjevele qjuis Jepa Jesús lal: —Jipj napj Nejepa —tjevele—. Ma ca malala la cüjay quinam. Dios jos jin ca la mejay quinam. T'üc' way la mitad napj nats'a'á ca jis ma'ayá t'emel cjuwá quinam. La p'a jus tsyawil, tüpweques jupj t'emel püna p'in, niswa ca ma'ayá jupj t'emel. Pjaní tüpweques mpes, yulupjana ca ma'ayá —tjevele Zaqueo. ");
INSERT INTO jicNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús tjevele jupj lal: —Malálatsja jipj Dios lal. Yacjaj 'ücj 'e tepalá Dios lal, mpes ca mpü'üm Dios lal. Nin ca nsem jipj wya nt'a patja jilal. Pyon quinam jipj, Abraham tepyona jin p'iyá püná, mpes 'ücj 'e tepalá Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma sa con̈ Dios 'a malala yupj. Len̈ jinwá yupj Dios lal. Napj tjacuwis la pal len̈ jis tjevyala jis lal. Jis capj p'yacj mpes ca 'üsüs nsem yupj Dios lal ne ca 'ücj mpatjam yupj jupj lal. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ne'aj tjatja tjepjyacan̈ niná Jesús tjevelá Zaqueo lal. Parábola mpes sin tji'yüsa lis tjiji 'ots'ipj. Ne'aj way p'intsja Jerusalén nt'a, mpes yupj yólatsja quina ca Dios Jepa ma'ajam nosis nt'a. Pjü ca nucucj ca nin mpalas, yólatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ma nin pyálatsja, mpes Jesús sin tji'yüsa lis tjiji tsjan líjitsja Dios nosis nt'a. Ninana tjevelá: “Jepa jatjam quelel campa jámatsja. Quelel jámatsja nt'a jepa püné ca püné la mijis jupj, ca jepa mpalas jupj. Jepa tepyala na, quelel jactsja niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mpes wine secj p'in, jupj jomozopan diéziya jis lal tjevele ncul. Pjaní pjaní jis tje'yaya t'emel c'a pjaní pajal pülücj jaylacj. Tjevele yupj jis lal: ‘Napj len̈ na, najas t'emel más pülücj mpalas t'emel niná mpes. Jaylacj la müjí t'emel lal. Niná ca vender la müjí más 'in pülücj jaylacj. Mpes más pülücj mpalas t'emel.’ ");
INSERT INTO jicNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","”Ne'aj tapatjá ma jisastsja jepa jatjam. Mpes niyom nepénowa mwalá sin tjajam jepa püné nt'a, la veles jepa püné lal. Javeleptsja: ‘Ma qjuisas nina qjuisí jütütam ncupj’. ");
INSERT INTO jicNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jepa püné mop'in jepa la tjiji jupj. ”Nin tepyala na, jepa jatjam niswa tjac', jupj tjevele jin. Tjac' na, tjijyü'ta lal ca mvelecj ncul jomozopan diéziya, t'emel jis tje'yaya yas nam. Jupj quelel seletsja nol natj t'emel jupj tje'yaya lal. ");
INSERT INTO jicNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mozo mwalá way tjac', tjevele: ‘Nejepa, jipj t'emel c'a pjaní diéziya tepyala quinam’. ");
INSERT INTO jicNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mpes jupj jepa tjevele jupj lal: ‘'Üsüs la tjejay. Namozo 'üsüs jipj. Tsjan tsjicj way pajal 'üsüs la tjejay jipj, mpes ca jis müjü'tün pülücj patja nt'a, pülücj patja diéziya nt'a ca jis müjü'tün.’ ");
INSERT INTO jicNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","”Locopyaya mozo p'a wa tjac', tjevele: ‘Nejepa, jipj t'emel c'a pjaní cínquiya tepyala quinam’. ");
INSERT INTO jicNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jepa tjevele jupj lal: ‘Nin mpes jipj ca jis müjü'tün pülücj patja nt'a, pülücj patja cínquiya ca jis müjü'tün’. ");
INSERT INTO jicNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”Locopyaya mozo p'a wa tjac', tjevele: ‘Nejepa, qui'á já'asa jet'emel. Tjivyü'ün, tje'yonsó jet'emel. ");
INSERT INTO jicNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Lecj tjeyatsja jipj lal, mpes nin la tjejaytsja. Napj seletsja ts'üis jipj. Más pülücj t'e'en jipj püna tje'yan lal. Tjevyala jequetj jipj ma jisin mpe’, nin tjevele jomozo niná. ");
INSERT INTO jicNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nin mpes jepa tjevele mozo niná lal: ‘Mozo malala jipj. Pajal malala nyuca jele. Jipj tjevelen mpes napj selé malala la tjejay jipj. Jipj tjevelen jipj selen ts'üisis napj. Más pülücj netj napj püna tje'yá lal. Tjevelen napj tjevyala jequetj napj ma jisin mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jipj selen niná. ¿Tsjan mpes ma prestar la tjejay nt'emel banco nt'a, más 'in pülücj mpalas nt'emel? Jipj nin la cüjaytsja, napj cüt'anquetsja napj nt'emel napj tjacuwis na. Cüt'anqué watsja p'a wa t'emel, napj nt'emel prestar la tjejay mpes’, nin tjevele jepá. ");
INSERT INTO jicNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","”Jepa tjevele wa ne'aj tjelejen̈ jis lal: ‘No'oté napj nt'emel jupj mpe. Tja'ayá t'emel c'a niná namozo p'a, jupj ne diéziya tya'a.’ ");
INSERT INTO jicNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mpes yupj tjowelepj jupj lal: ‘Qjuis Jepa, diéziya tya'a jupj quinam’. ");
INSERT INTO jicNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jupj jis wala tjevele: ‘'Ücj wa p'a wa t'emel 'ya jupj. Nepénowa 'üsüs lajay napj jis tje'yá popé, mpes más pülücj ca jis ma'ayá yupj. Ca yupj pülücj way nta'acj. Nepénowa nin tulucj yupj. Liji secj yupj napj jis tje'yá mpes, ne p'a wa ca nt'anques yupj jatatj. Nin velé ca nin nsem.’ ");
INSERT INTO jicNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","”Jepa tjevele wa: ‘Napj ne'enemigopan ma jisastsja napj jis müjütütj, jis lal nculá, ma 'e. Nawalap'a'a jis tjü'ü'ná.’ ” Tecyawaja quinam parabolas. (Niná tjevelá mpes sin tji'yüsa lis tjiji tsjan ca jis mpalas jupj jomozopan jupj tjac' na, tsjan ca jis mpalas jupj enemigopan 'ots'ipj.) ");
INSERT INTO jicNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús nin tjevele na, tjemey niswá, Jerusalén mo'o jámatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tucuc' nt'a tjac', tucuc' niná Olivos ló, ne'aj way p'in Betfagé nt'a, Betania ne'aj p'in 'ots'ipj. Ne'aj tjac' na, jupj discipulopan mát'eya sin tjejyama, ");
INSERT INTO jicNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tjevele yupj jis lal: “Lowa yupj jis wa lejen̈ nt'a. Ne'as tjalawú na, soysoy tsjicj ca nucú. Mwen tsyu'pa ton̈ca jupj. Casá 'osos secj jupj custjay. 'Osocté ncumaná, ma 'e. ");
INSERT INTO jicNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","P'a wa ca nu la mü'üyas ca nacj tsjan nu lo jay socté soysoysos. Wola mvelé Nujepa jos jupj. Nin welé na, 'ücj ca nsem yupj jis lal.” ");
INSERT INTO jicNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mpes niyom jupj sin tjejyama tjil, Jesús tjevele jinwá tjunuc yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yupj soysoy jasoctsja na, jupj soysoy 'esepj tjowelepj yupj jis lal: —¿Tsjan nu lo jay socté soysoysos? ");
INSERT INTO jicNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yupj tjowelepj: —Qjuis Jepa jos jupj. Mpes 'üctsja quinam yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Soysoy Jesús nt'a tjaman quinam. Sin quip pje'apa soysoy lüicj casá la tsjinan ne Jesús soysoy casá tjo'onsopj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jupj soysoy casá tjá'asa tjemey na, gente p'a wa sin quip jümücj casá tapajatj, pülül casapa lo winin Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tucuc' palavin tjemey, tucuc' niná Olivos ló, ne'aj p'in quinam Jerusalén. Pjü ne'aj tjelyawun̈ 'ücj jisastsja, jupj discipulopan pajal pülücj, 'ücj jisastsja pajal. 'Üsüs pjac tjowelepj Dios po'ó, yümücj pjac tjowelepj yupj, Jesús pajal 'üsüs la tjiji mpes. La pülücj pajal 'üsüs la tjiji, yom p'in ma polel liji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tjowelepj: —Jepa ma'ajam Jesús. Dios pajal 'üsüs ca la mijis jupj mpes. Dios mpes vele jupj, Dios ne cupj qjuis Jepa Püné. Mpes tsjun po'o patja 'üsüs ca mpatjam. Cupj pajal 'üsüs ca mvelecj Dios po'ó. Dios tsjun po'o pü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseopan nepenowá Jesús lal jiltsja wa. Tjowelepj Jesús lal: —Jis capj tjeve'le jipj discipulopan, yupj javelepj mpes. Jis tjijyü'ta ma mvelecj niná, jipj pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús yupj jis wala tjevele: —Yupj lyájasa nacj, pwen witjacj ca nin p'iyá la mpuyucj wa. T'üc' velé napj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Más 'in ne'aj p'in tjac' quinam Jesús Jerusalén nt'a. Jerusalén tjinyuca na, pajal jólatsja Jerusalén mpes, ne la tipiya jupj. (Jupj seletsja jis wa Jerusalén mo'o lejen̈ pjü malala jis mpalas. Seletsja pasal malala ca jis mpalas ne'aj tapatjá.) ");
INSERT INTO jicNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Niná jupj tjevele Jerusalén nt'a patja mpes: —Po nola nun mpes, nun ma nusin tji'yüsa 'oyn ne 'üsüs nsem nun Dios lal. Yacjaj p'in 'ücj nin cüpalastsja. Quina ma polel nusin 'yüsa 'oyn ne 'üsüs nsem nun Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","P'a jyawca nun jis enemigopan ca ncul, 'amá ne'aj ca mpa'tacj potjaqué t'asiyú. Pues yupj ca t'asiyú mpatjam jun ta'á, nun ma polel nlawú. ");
INSERT INTO jicNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nun jis enemigopan ca pjü malala lis mijicj nun jis wa. Ca jis mü'ü'nacj ne'aj patjá. Pjü jis wa cjuwá ca nsem. Pe pjaní ma ca casá ma'ajam p'a lal, jis wa pópatsja jupj yas nam. Dios nin tjejyama na nucopj la p'acj, nun ma ponetsja Dios nin tjejyama, mpes nin ca nu mpalas —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús Jerusalén nt'a tjemey na, Dios wo nt'a tjemey. Jesús pje'á la tecyoye vender lajay ne'aj. Ma jostsja vender la tjajay Dios wo mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tjevele yupj jis lal: “Dios tjevele jupj Popel mo'ó: ‘Ninana nawá mpe javelepj napj lal’. Nun ma nujos niná. Nun la tjüjí pwecapan 'a si mulú qui'á”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pjü jyawca Jesús sin 'yüsa lis tjiji Dios wo nt'a. Newa sacerdote noypan po quelel ja'ünantsja jupj. Yólatsja 'oyn la qjuijim cü'ü'nam. Nin p'iyá yólatsja Moisés popel sin 'yüsa lajay, judío noypan 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pues ma salejeptsja 'onin ne 'ücj cü'ü'nacj Jesús. Yupj salejeptsja ne'aj patjá pajal ts'i mi'inacj yupj malala la cüjay Jesús lal. Pjü ne'aj tapatjá po quelel pjyacan̈tsja Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ts'ac' p'a wa tjejyawca na, Jesús sin 'yüsa lis tjiji ne'aj Dios wo mo'ó, Jerusalén nt'a. Jis wala tjevele tsjan niná Dios 'üsüs la tjiji gente mpes. Custjay véletsja na, niyom nepénowa tjiquil wa Jesús nt'a, sacerdote noypan nepenowá, Moisés popel sin 'yüsa lajay nepenowá, co'müypan nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tjowelepj jupj lal: —Qjuis wala tjevele pjacj tjevele 'ücj nin lejay, jipj lejay jinwá. ¿Pjacj 'i jütüta nin lejay jipj? ");
INSERT INTO jicNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jis wala tjevele Jesús: —Napj ca nu la mü'üy 'ots'ipj. Nawala tjowelé ");
INSERT INTO jicNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","tsjan mpes 'ücj bautizar lis tjiji Juan. ¿Ncu Dios tjijyü'ta nin la tjiji? ¿Ncu gente p'in jisastsja nin la tjiji? ");
INSERT INTO jicNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yupj yuwá tjowelepj tsjan cüwelem jupj lal. Yuwá tjowelepj: “Cupj ma polel velecj Dios tjijyü'ta niná. Nin cüvelecj ca niná, Jesús ca qjuis la mü'üyas tsjan mpes ma tepyonecj Juan tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Cupj ma wa polel velecj gente p'in jisastsja nin la tjiji. Nin cüvelecj ca niná, pjü pe ca qjuesé nts'iyacj, qjuis mü'ü'nacj. Pjü japon Juan Dios mpes tjevele.” ");
INSERT INTO jicNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mpes yupj tjowelepj Jesús lal: —Cupj ma selecj pjacj tje'yaya Juan el Bautista 'ücj bautizar lis tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús tjevele yupj jis lal: —Nun ma nlal tjowelé, mpes ma wa ca mvelé nun nla tjü'üyá napj lal. Ma ca mvelé pjacj ntjijütüta napj niná lejay. ");
INSERT INTO jicNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nin tjevele na, Jesús parábola tjevele wa Dios wo nt'a tjatja jis lal. Sin 'yüsa lis tjiji malala pajal Dios lal judiopan ma jisastsja jupj Jatjam. Ninana parabolas Jesús tjevelá: —Yom uva sine jupj. Locopyaya jupj sínetsja jis tje'yaya mo'o jasin p'a witjacj, 'ücj la mijicj lo valas. Yupj tjowelepj ca ma'ayacj jupj, tjevyala popé. Mo'o jasin jis tje'yaya naya, tjemey pajal campa nt'a. Ne'aj pajal püs tüpü'ü. ");
INSERT INTO jicNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva tjevyala po'ó, mozo jas tjejyama yupj nt'a, sine lejen̈ nt'a lo ta'es tjevyala popé, yom juts'a'á mpes. Niyom ne'aj mo'o jasin jas tüpwes ma tja'ayapj jomozo. Mozo süp, jas tjajam. Jas pjan tjemey. ");
INSERT INTO jicNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Locopyaya jupj mozo p'a wa jas tjejyama yupj nt'a. Pajal wa jasüp ni. Tsjicj jin yólatsja, malala tjowelepj jupj lal, ne jas pjan jas tjajam yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Locopyaya mozo p'a wa jas tjejyama yupj nt'a. Cont'e tepyala quinam. Jay tjojocj, na'aj la ts'i yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”Mpes uva juts'a'á tjevele: ‘¿'Oyn la mejay napj quinam? Natjam ca jas majam. Pajal quelel lejay natjam. Püné jupj ca yola nsem yupj.’ ");
INSERT INTO jicNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nin tuluctsja. Niyom ne'aj la 'el jus tjunuc na, yuwá tjowelepj: ‘Niná uva juts'a'á jatjam. Uva lejen̈ nt'a jupj juts'a'á nsem, popay tepe'e na. Mas, mü'ü'nacj ca jupj, mpes uva lejen̈ nt'a cupj cuts'a'á nsem.’ ");
INSERT INTO jicNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mpes yupj jupj jatjam la ts'i sin mpe, tjü'ünan. —Parábola t'üc' tjevele Jesús quinam. Tjevele wa: —Cupj selecj tsjan ca lis mijis yomen 'isin jis tje'yaya jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jupj ca mim yupj nt'a, sin lejen̈ nt'a. Jis mü'ü'nas ca niyom ne'aj tsji' la tjajay. Uva sin lejen̈ ca jis ma'ayas la p'a, yupj ca 'ücj la mijicj lo valas ne'aj —nin tjevele Jesús. Yupj tjepjyacan̈ na jupj tjevelá, yupj sin tji'yüsa judiopan sin po'ó tjevele jupj, mpes tjowelepj: —¡Ma ca nin cüpalas! ");
INSERT INTO jicNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Newa Jesús yus tjinyuca, tjevele yupj jis lal: —Dios Popel vele ca nin nsem. Niná velá: ‘Niyom nepénowa quelel jajünsüptsja wosis pe mpes. Pe pjaní ma jisastsja wosis la jünsüs. Pe niná t'üc' way 'üsüstsja. Mpes qjuis Jepa Dios jas tjijyünsa wosis. Jupj mwalá way tje'yonsa pe niná wosis si jünsa mpes. Pe niná más 'üsüs waytsja pjü pe witjacj lal. Tsjomis pe niná casá tón̈catsja.’ Nin vele Dios Popel. ");
INSERT INTO jicNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","”Napj niná pe 'üsüs jinwá, napj tjevelé jinwá. Nun wa su jünsǘ jinwá. Yom pe niná casá yaca, malala ca mpalas jupj pajal. Pe niná yom casá yaca na, más malala ca mpalas jupj. 'Üpjǘ ca mpalas jupj, yomen —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Moisés popel sin 'yüsa lajay quelel tji'lin̈tsja Jesús. Nin p'iyá sacerdote noypan. Yupj jus nlay Jesús parábola niná tjevele yupj sin po'ó. Ma polel tji'lin̈tsja jupj custjay. Lacj jeyaptsja la p'a judiopan ca pajal ts'i mi'inacj yupj jis lal, mpes ma nin la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yupj la tjunuc 'ona 'ücj la tjilil Jesús. Mpes niyom sin tjajam Jesús nt'a. Yupj quelel la 'üytsja jupj lal, jupj ca malala cüveles yupj jis lal yupj jis wala tjevele na. Yupj 'üsüs jin la tjajay, newa malala la tjajay. Yupj yólatsja ca ne'aj majatjum, mpjacan̈, mpes 'ücj ca jat' mvelecj jupj po'ó jepa romano auxiliar lal. Jepa romano auxiliar pünetsja jupj, mpes 'ücj ca cus ntülüs Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mpes yupj tjil Jesús nt'a, tjowelepj: —Cupj selecj jipj t'üc' velen. Jipj sin 'yüsa lejay 'üsüs. Nin p'iyá velen jipj pjü jilal. Sin 'yüsa lejay Dios jyü'tá t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nin mpes quelel lya 'yüyacj jipj lal. ¿Ncu 'ücj Dios lal cupj impuesto jaylacj lijicj, jepa romano t'emel t'e'enca mpes? ¿Ncu 'ücj tulucj nin lijicj? ");
INSERT INTO jicNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús jus nleya tsjan mpes nin la tjü'üy jupj lal. Seletsja yupj ma quelel jus nlaytsja la tjü'üy mpes. Seletsja yupj jisastsja jupj malala nyuca ca mveles. Mpes Jesús tjevele yupj jis lal: ");
INSERT INTO jicNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—T'emel c'a pjaní way nca'á ma 'e. ¿Pjacj wola t'emel wola po'ó já'asa? ¿Tsjan ló t'emel po'o tapac? —tjevele jupj. Yupj tjowelepj: —Jepa romano jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús tjevele yupj jis lal: —Mpes tja'ayá jepá jupj 'ücj le moná nun lal. Tja'ayá Dios jupj 'ücj le moná nun lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yupj ma polel malala tjowelepj Jesús po'om la p'a jis walap'a'á, jupj tjevele mpes. Po yólatsja Jesús 'üsüs jis wala tjevele mpes. 'Üsüs tjevele jupj pajal, mpes yupj lyájasatsja. ");
INSERT INTO jicNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Niyom p'a wa tjiquil wa Jesús nt'a. Saduceopan waytsja yupj. Yupj javelepj tecya'lin̈ ma ca sin müjünsücj, ma ca mpatjam niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Saduceopan quelel jat' la velestsja wa Jesús po'ó, mpes tjowelepj yupj jupj lal. Tjowelepj: —Püna Moisés popel tepyaca tsjan qjuisí jütüta Dios. Ninana pjaní way jupj tepyacá: yom pe'e jats'om popa tulucj, más 'ücj yom jüpülücj mwayis ca tepe'e jats'om lal. Ca popa jana nsem tepe'e jats'om lal. Tepe'e ts'uyupj jin p'iyá ca nsem. Moisés nin tepyaca. ");
INSERT INTO jicNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nin mpes cupj lya 'yüyacj. Püna niyom siéteya tapatja, pjü yupj jis sejatjampan yupj. Mwalá way tjowaya, popa tulucj tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tepe'e na, jupj tsüipe tjowaya tepe'e jats'om lal. Nin p'iyá popa tulucj tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jupj tepe'e na, jüpülücj locopyaya way tjowaya wa jüpülücj jats'om lal. Nin p'iyá popa tulucj tepe'e jupj. Nin p'iyá pjü jis pülücpan quepj pjaní lal tjewyayin̈. Pjü jis pülücpan sin popa tulucj tecya'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yupj pjü way tecya'lin̈ na, tepe'e wa quepan. Lovin popa tulucj jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Pjacj jats'om nsem jupj, tecya'lin̈ sin müjünsücj na jis la püt'üs niswá? Pjü way niyom siéteya tjewyayin̈ jupj lal, tapatja na p'in —nin tjowelepj saduceopan. ");
INSERT INTO jicNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús tjevele yupj jis lal: —Niyom, nequem quina patja pjü wyayin̈. ");
INSERT INTO jicNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dios lal patjam ma nin lajay. Dios vele yupj 'üsüs, ne yupj ca sin müjünsücj tecya'lin̈ sin popé, ca mpatjam Dios lal. Ne'aj ma mwayin̈ yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yupj ma polel cya'lin̈ niswá ne nin. Angelpan jinwá yupj, mpes ma cya'lin̈. Dios ts'uyupj way yupj. Yupj sin jajünsüpj jis la püt'üs lovin Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","T'üc' way tecya'lin̈ ca sin müjünsücj, ca mpatjam niswá. Selecj ca nin nsem Moisés tepyaca mpes 'ots'ipj. Tepyaca püna tepyalá, yo tsjicj pwetsja na, qjuis Jepa Dios ne'aj tjá'asa mpes. Jupj tjevele ‘qjuis Jepa Dios Dios jupj Abraham lal, Isaac lal 'ots'ipj, Jacob lal 'ots'ipj’. ");
INSERT INTO jicNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cupj selecj püna tecya'lin̈ conas. Selecj wa Dios tecya'lin̈ jis Dios tulucj. Patja jis Dios jupj. Nin mpes selecj patja yupj quinam. Dios selé newa patja pjü —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moisés popel sin 'yüsa lajay nepénowa jupj wola tjowelepj: —Po 'üsüs tjevelen jipj. ");
INSERT INTO jicNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lacj tjeyapj la p'a jis la 'üy. ");
INSERT INTO jicNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","(Jesús ma lecj tjeyá.) Jupj tjevele yupj jilal: —Dios tjevele jupj ca jas majamas Jepa Püné jis capj la p'acj judiopan. ¿Tsjan mpes javelepj yom niná David popa jupj? ");
INSERT INTO jicNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David p'iyá tjevele jupj po'ó Dios Popel mo'ó. Dios mpes nüejets'e tepyaca nt'a tjevele: ‘Nejepa Dios tjevele Nejepa Püné lal: “Nt'i'isa jipj napj li'inyampe. ");
INSERT INTO jicNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Jipj ca müjü'tün napj lal napj ca la mpalan naya jipj enemigopan jis lal. Napj ca la mejay tsjyam la p'a'á jatja jinwá yupj. Nin ca la mejay jipj mpes, jipj napj lal jac' na.” ’ David tjevele niná Dios tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jesús tjevele: —David tjevele yom niná jupj Jepa way jupj. ¿'Onin nacj ne David popa nacj jupj? ");
INSERT INTO jicNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesús tjevele jupj discipulopan jilal, pjü 'ücj jis la pjac: ");
INSERT INTO jicNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moisés popel sin 'yüsa lajay malala yupj. Po ma nin p'iyá la tjüjí, yupj lajay jinwá. Yupj jisas la p'a yola yupj noypan, mpes sin quip campa jisas. Pülücj lyawun̈ nt'a jil na, po jisas la p'a 'üsüs javelepj yupj jilal, 'üsüspan lal javelepj jinwá. Judiopan 'a si mulú nt'a jil na, silla más 'üsüs nt'a la 'osos jisas, cocoypan p'in jatja nt'a. Pülücj 'a si mulú nt'a jil na jis la las, más 'üsüs nt'a quelel jatja lovin, noypan jatja nt'a. Nin lajay Moisés popel sin 'yüsa lajay. ");
INSERT INTO jicNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yupj pequen̈ nequem jis wa, nequem jis vayum tecya'lin̈. Newa jisas la p'a 'üsüs jin yola yupj, mpes püs way javelepj Dios lal, pülücj pjyacan̈ nt'a. Nin lajay mpes Dios ca mveles más malala la tjajay yupj la p'a jilal. Más ca jis capj ntülüs yupj pjü jilal —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Caja nepenowá ne'aj tjatja Dios wo nt'a t'emel mo'o la 'onsos la 'ayas Dios mpes. Jesús jay jas tjijyünsa, tjinyuca gente pülücj jatatj jis t'emel tjo'onsopj ne'aj. Pülücj tjo'onsopj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tjinyuca wa quepj pjaní centavito mát'eya tje'yonsa wa jupj. Quepj niná voyum tepe'e jupj. Pjü cjuwatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tjinyuca na, Jesús tjevele jupj discipulopan jilal: —Quepj niná más pülücj tje'yonsa pjü jilal. Quepj niná voyum tepe'e jupj. Pjü cjuwá jupj, quepan. Pjaní way tje'yonsa, pülücj jin p'iyá napj lal. T'üc'. ");
INSERT INTO jicNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","La p'a wa pülücj jatatj popé tja'ayapj yupj. Quepj niná cjuwá jupj. T'emel pjaní way ve jaylacj liji popé tje'yaya jupj. Cjuwá jupj quinam —nin tjevele Jesús quepj tje'yaya po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Discipulopan nepénowa tjowelepj wa Dios wo po'ó. —Po 'üsüs way justa —tjowelepj—. Pe po 'üsüs yustapj lal 'üsüs justa la tjajay. Tsjan 'üsüs yustapj tja'ayapj popé 'üsüs justa la tjajay wa Dios wo. Jesús tjevele: ");
INSERT INTO jicNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Pjü ca malala mpalas niná nun nucú qui'á. P'a jawas judiopan jis enemigopan ca ncul. Yupj ca sin mojoyecj pjü way niná wosis. Pjü pwen ca palá la ncoyecj, wosis la tjajay sin popé. Pjü na'aj ca la ncoyecj, mpes pe pjaní ma ca p'a casá ma'ajam nsem —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jupj discipulopan la tjü'üy: —¿'Ona ca malala mpalas Dios wo? ¿Tsjan ca la mijis Dios mwalá way p'in, mpes ca jus nlayecj len̈ way ca nin mpalas? ");
INSERT INTO jicNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús jis wala tjevele: —'In tjajama. Pülücj ca ncul la ntsawilicj ca gente jis lal. Po ma toponé yupj javelepj. Yupj pjaní pjaní ca mvelecj yupj p'iyá Cristo. Ca mvelecj Dios sin tjejyama yupj. Ca mvelecj wa ca len̈ way ncawajas pjü. Ma ca nin la müjí yupj javelepj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nun ca jus nlayé wa militarpan pülücj la palan p'a nt'a. Ca jus nlayé wa yuwá p'iyá la palan wa. Niná pjo'oqué na, po ma pajal locj tjeyá. T'üc' way malala ca mpalas nosis nt'a. Ma len̈ way ncawajas ca pjü niná malala tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús tjevele wa yupj jis lal: —Nepénowa patja nt'a la mpa'nacj ca p'a nt'a patja jis lal. Ca jis mü'ü'nacj. Jepapan ca sin majamacj jis militarpan jis la palan p'a jepapan jis militarpan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pajal ca jus nquits'is nosis 'ots'ipj. Nepénowa patja nt'a cjuwá ca nsem jis la las 'ots'ipj. Nenéyawa pjü way nin p'iyá ca malala jisas yupj 'ots'ipj. Dios ca la mijis p'a casá ca mpalas tsjun po'ó, nosis casá patja jis la nuc. Nin mpes ca jus nlayecj Dios ca jis capj ntülüs malala lajay. Tjunuc na ca lacj meyacj pajal. ");
INSERT INTO jicNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Niná tepyala secj p'in, nepénowa ca nu ntji'lin̈. Ca malala la nu mijicj ncapj con̈có mpes. Ca nu manucj judiopan 'a si mulú nt'a, cawilta nt'a 'ots'ipj. Ne'aj ca jat' mvelecj nun sin po'ó. Ca nu manucj jepapan jis walap'a'á. Ne'aj p'in se jütütj nt'a ca nu manucj. Jepa noypan nt'a ca nu manucj wa. Yupj jis walap'a'a ca jat' mvelecj nun sin po'ó ncapj con̈có mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nin nu tepyala na, 'ücj ca mvelé nun yupj jis lal 'onin ne 'ücj potjaqué Dios lal napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mpes quina nujola t'as ma ca nin nujola mwalá way p'in tsjan ca jis wala cüwelé. ");
INSERT INTO jicNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nin pyala nam, napj ca nucopj mp'acj ne ca 'ücj mvelé nun. Nun ca jus nlayé t'üc' way. Nun ca pajal 'üsüs mvelé, mpes nun jis enemigopan pjü ca jus nlayecj t'üc' welé nun. Ma ca polel p'a casá mvelecj. ");
INSERT INTO jicNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","”Nenéyawa nun jis pülücpan p'iyá ca nu ntji'lin̈ wa nun, ca quelel jat' mvelecj nun sin po'ó nun ncapj con̈có mpes. Nenéyawa nin ca la mijicj wa nun sejamicapan. Ca nu mü'ü'nacj nun nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pjü gente ma ca jisas nsem nun, nun ncapj con̈có mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Newa 'üsüs ca mpatjaqué nun. Co'liqué naya, Dios newa ca nucopj ncon̈cos. Nun newa 'üsüs ca mpatjaqué Dios lal. Ma tecyawaja nun ts'üil popa pjaní jinwá ca nsem. ");
INSERT INTO jicNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nun newa ncapj con̈có malala pyala na, lovin ca mpatjaqué Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”Jerusalén ca pjü malala mpalas. Nun ca nucú Jerusalén t'asiyú lejen̈ militar pajal pülücj, 'ücj jis la palan ne'aj patja jis lal. Niná tjunucú na, nun ca jus nlayé len̈ way Jerusalén pjü malala ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nin quelel pyala na, más 'ücj Judea mo'o patja ts'equenen̈, joc' mo'o ca mal. Pajal malala ca mpalas Judea nt'a. Más 'ücj Jerusalén mo'o patja Jerusalén mpe ca mal. Más 'ücj jis wa pjaní pjaní lejen̈ nt'a patja ma ca mal Jerusalén mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dios ca jis capj ntülüs israelpan, malala la tjajay mpes. Püna tapac Dios Popel mo'ó Dios ca jis capj ntülüs, ne pjü ca mpalas quinam yupj tapac jin. Nin mpes ca pjü malala mpalas Jerusalén. ");
INSERT INTO jicNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","”Niná pyala na, pajal malala ca nsem nequem way jatja jis lal, nequem tsjictjacj sa manun jis lal 'ots'ipj. Pajal malala ca mpalas Judea mo'ó. Dios po quelel jis capj tyüla Judea mo'o patja, yupj malala la tjajay mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jis enemigopan ca sey mojo'ocj nepenowá polomay lal. Jis ntji'lin̈ nepenowá, p'a'á ca jis manucj. Jun ta'á ca jis manucj, sin tjan, sin tjan jis la püt'üs, judiopan tulucj patja nt'a. Año pülücj judiopan tulucj müjü'tücj ca Jerusalén nt'a. Nin ca nsem Dios Popel vele jin. Dios selé nol año müjü'tücj. Locopyaya, Dios jos na, judiopan juts'a'á ca nsem Jerusalén niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús tjevele wa: —Dios ca la mijis p'a casá justa ca mpalas lots'ac', mümüy 'ots'ipj, pjulacj 'ots'ipj, mpes nosis casá patja ca jus cülayecj quina ca nin mpalas napj velé jin. Nosis nt'a 'üsǘ püné pajal ca mpjac ca la mijis, pajal lo pjets'epjets'e ca mim. Mpes p'a nt'a patja pajal pülücj ca lapj nyuca yola yupj pajal. Ma ca jus nlayecj 'oyn la mijicj. ");
INSERT INTO jicNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pajal ca lacj meyacj, mpes ca nca'lin̈ nepenowá, pajal ca nin yola malala ca mpalas nosis. Noypan tsjun po'ó ca jus nquits'is, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nin tepyala na, ca nus nucucj, mol mo'o ca ncuwis. Pasal püné nsem napj, pjü 'ücj la cüjay. Napj nt'a pajal majawaques ca Mpapay Dios mpes. Napj p'iyá niná Yomen Dios jas tjejyamá —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","—Nepénowa nas tepyala na napj tjevelé jin, 'ücj jisas t'as nun. Po ma locj tjeyá la p'a wa jinwá. Nepénowa nas tepyala na napj tjevelé jin, nun ca jus nlayé len̈ way ca ncuwis nucopj la p'acj. Mpes la 'unucú Dios ca 'üsüs la numijis, ma ca malala nu mpalas —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús parábola tjevele wa yupj jis lal sin la 'üsüs jis la jay niná. Tjevele: —Nujola t'as ts'oway po'ó, pjü yo po'ó 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jis lo tecyala na, nun solejé len̈ way quelel jive. ");
INSERT INTO jicNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nin p'iyá nun ca nucú nepénowa nas tepyala napj tjevelé jin. Niná tjunucú na, nun jus nlayé wa len̈ way Dios müjü'tüs ca pjü nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”Pjü niná napj tjevelé, pjü ca mpalas. Judiopan newa ca mpatjam pjü tepyala na. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tsjun po'ó ca ncawajas, nosis ca ncawajas wa. Napj velé jin ma ncawajas ca lovin. Pjü tjevelé, pjü ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”'In tjajama nun p'iyá. Po ma lowa p'a nt'a malala nyuca la müjí. Po ma nun sey 'üts'a t'as nun. Po ma pajal nujola t'as 'oyn nyuca mpatjaqué nosis nt'a. Nin la cüjí, ma lu nucú naya ca nin mpalas napj tjevele jin. ");
INSERT INTO jicNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Animal walan 'ityüla len̈ way pe'e. Nin p'iyá pjü napj tjevelé len̈ way ca mpalas pjü nosis casá patja mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pajal 'in tjajamá. Lovin Dios lal la moná nun ca 'ücj la müjí Dios jos jin lovin. Mpes nosis nt'a malala tepyala na, ma ca malala nyuca la müjí wa nun, la p'a jinwá. Mpes napj velé na nun lal ncu 'ücj la tjüjí, 'ücj nsem nun napj lal. Ma ca nu maycas nun napj lal. Napj p'iyá niná Yomen Dios jas tjejyamá —nin tjevele Jesús jupj discipulopan jilal. ");
INSERT INTO jicNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús lovin sin 'yüsa la síjitsja Dios wo nt'a jaw na. Püste na pülücj patja mpe tjemey lovin. Joc' Olivos ló nt'a tjejyá. ");
INSERT INTO jicNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pajal püstapj sin tjüjünsüpj pjü, tjil Jesús nt'a Dios wo nt'a, jis la pjac jupj tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Len̈ way quelel pyálatsja fiesta, israelpan pan levadura cjuwá jalá na. Fiesta niná “Dios Qjuis Capa Nipj Tjemey” ló jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdote noypan yólatsja 'oyn la qjuijicj cü'ü'nacj Jesús. Nin p'iyá yólatsja wa Moisés popel sin 'yüsa lajay. Custjay ma malala la tjajay Jesús lal. Lacj tjeyapj ne'aj patja ca ts'i mi'inacj yupj jilal, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Locopyaya Satanás Judas jos mo'o tjemey. Niná Judas, “Iscariote” apellido waytsja jupj. Apostolpan dóceya pópatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jupj tjemey la veles jepapan jilal Dios wo nt'a, yupj sacerdote noypan nepenowá, militarpan nepenowá. Yuwá nin tjowelepj 'oyn ne Judas ca jis capj mp'a'sas 'ücj jis la tjilil Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Ücj jisastsja yupj. Tjowelepj Judas lal yupj ca jaylacj la mijicj Judas nin la mijis mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas tjevele nin ca la mijis jupj. Tjemey, la tjinyuca 'ona 'ücj jis lal ca mim la tjilil Jesús, ne'aj patja len̈ na p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Locopyaya ts'ac' mwalá way tjejyawca fiesta mpes, pan levadura cjuwá jalá na yupj. Fiesta niná “Dios Qjuis Capa Nipj Tjemey” lotsja. Nin jawas oveja tsjicj ja'ünan jis la las fiesta mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús sin tjejyama Pedro, Juan 'ots'ipj, 'ücj la mijicj fiesta mpes. Tjevele: —Lowa, 'ücj la müjí qjuis la las fiesta mpes lyajacj, “Dios Qjuis Capa Nipj Tjemey” mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yupj la tjü'üy: —¿Ca'aj jyas 'ücj la mijicj? ");
INSERT INTO jicNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús jis wala tjevele: —Jerusalén nt'a lowa. Ne'as tjalawú na, nun la müjüsüqué yom jarro t'ya, 'üsǘ mo'o ton̈ca. Cjüil lowa wama jama nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne'aj wo lal tjowelé: ‘Yom qjuisin 'yüsa liji qjuisin tjejyama jipj nt'a. Jupj tjevele cupj ca lya mü'üyacj ca'aj ton̈ca cuarto niná jupj ca nlajas nt'a. Ne'aj quelel lyaja jupj discipulopan jis lal fiesta mpes, fiesta “Dios Qjuis Capa Nipj Tjemey” ló.’ ");
INSERT INTO jicNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne'aj wo 'esepj nun jis lal ca mim cuarto püné nt'a, wo casá ton̈ca. Jupj nasa 'ücj la tjiji cuartas quinam. Ne'aj ca 'ücj la müjí cupj lyajacj mpes —nin tjevele Jesús Pedro lal, Juan lal wa. ");
INSERT INTO jicNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mpes tjil yupj. Pjü Jesús tjevele jin tepyala, ne 'ücj la tjajay yupj jis la las fiesta mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Quelel jalatsja na, Jesús tjá'asa mesa nt'a apostolpan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jupj tjevele yupj jis lal: —Custjay ma malala ntepalá p'in, po najastsja 'a mulú nlajacj niná fiesta na. ");
INSERT INTO jicNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Malala ntepalá na püs way ma ca nla napj fiesta niná mpes, fiesta ‘Dios Qjuis Capa Nipj Tjemey’ ló. Fiesta niná mpes qjuiyola pyala Dios 'üsüs la tjiji püná, ma malala jis mpalas judiopan. Po quina más 'üsüs ca la mijis püna la tjiji lal, mpes t'üc' way ca 'ücj mpatjam napj lal japon. Nin ca nsem Dios jyü'ta na nosis casá. Nin tepyala na, niswa ca nla niná fiesta mpes —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nt'ya jupj pocillo, uva 'üsǘ mo'o tón̈catsja. Tjevele Dios lal tjüwüi'i 'üsǘ tje'yaya mpes. Locopyaya tjevele niyom jis lal: —No'oté nun, vitvitj way pjü tjümüsiqué niná. ");
INSERT INTO jicNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma niswa ca mü'üs napj quinam uva 'üsǘ. Dios nosis nt'a jyü'ta na niswa ca mü'üs p'in. ");
INSERT INTO jicNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Locopyaya pan pjaní nt'ya, tjevele Dios lal tjüwüi'i pan tje'yaya mpes. Nin la tjiji na, vitvitj la tücüeme, jis tje'yaya pjü. Tjevele: —Pan niná napj mp'üy jinwá. Ma pats' ca napj, mpes Dios ma ca nin jola nsem nun malala la tjüjí. 'Ücj ca mpatjaqué nun Dios lal. Nenéyawa nin p'iyá pan 'alajá nun. Nujola tapalas nin la tjejay napj nun mpes —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nin p'iyá la tjiji pocillo lal. Pocillo nt'ya t'üc' tjalá na. Tjevele: —Uva 'üsǘ niná na'as jinwá. Ma pats' ca nun mpes. 'As ca ma palas napj, mpes Dios 'ücj ca perdonar la numijis. Jupj tjevele t'üc' nin ca la mijis nun mpes ntipü'í na. P'a casá ca la mijis quinam püna la tjiji lal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”Mop'in nin, nun popa pjaní quelel malala liji napj lal. Jupj ca jis lal ncuwim napj ne'enemigopan, ca ma tjililin̈. Qui'á já'asa wa, lyaja wa napj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Püna p'in Dios tjevele 'oyn la cüjay cüpats', ne nin ca nsem napj lal. Mop'in pajal malala nin, jupj ca jis lal ncuwim napj ne'enemigopan, ca ma tjililin̈. Ca malala mpalas jupj pajal, jupj malala la niji mpes. Napj p'iyá niná Yomen Dios jas tjejyamá —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jupj discipulopan jis la tjü'üy yuwá cana yupj popé Jesús enemigopan jis lal ncuwim. ");
INSERT INTO jicNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yuwá la tjowelel wa cana yupj popé más püné nsem la p'a jilal Dios jyü'ta nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","(Jesús ma jostsja nin yólatsja yupj.) Nin mpes jupj tjevele yupj jilal: —Judiopan tulucj jis jepapan jajütütj la p'a wa, yupj noypan mpes. 'Ücj sa jajütütj jin lajay ne'aj patja jis lal. Niná lajay jis capj la p'acj, javelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nin tulucj ca nsem nun jilal. Nun jilal más püné, pjyapja jinwá ca nsem jupj. Jepa ca mozo jinwá nsem jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yom jupj jomozopan tsji' lajay, más püné yom niná tsji' lajay jis lal. Nujola tapalas napj tsji' lejay nun mpes. Napj lejay jinwá la müjí nun. ");
INSERT INTO jicNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”Napj p'iyá ca nin la mejay nun más noypan ca nu mpalas. Nun ncapj tocon̈có lovin. Malala ntepalá na, newa ncapj tocon̈có. ");
INSERT INTO jicNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","(Nin mpes napj ca 'üsüs la numejay wa.) Mpapay ntje'aya la jütütj. Nin p'iyá napj nu 'ya wa ");
INSERT INTO jicNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'ücj nun ca müjü'tǘ wa. Nun ca nlajá, ca müsiqué wa napj lal napj jyütütj nt'a. Jepapan noypan nsem nun. Napj auxiliarpan nsem nun. Nun ca mvelé israelpan pjü jilal ncu t'üc' malala nyuca la tjajay yupj nosis nt'a. Nin ca nsem nun ncapj con̈có mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús tjevele wa Simón lal: —Simón, 'üsüs tjapjaca napj velé. Satanás la tjemyona Dios ca ma'ayas jupj ca pajal malala la numijis. Jupj ca nucus ncu t'üc' way quelel ncapj con̈có nun. Nin ca nsem jupj la tjemyona jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nin mpes napj Mpapay Dios lal la tjemyon wa nun mpes. La tjemyon jipj lovin ca mponen napj lal. (Napj selé jipj ca malala nyuca la mijin. Locopyaya jipj ca 'üsüs jele mpalas niswá. Niswa ncapj cyon̈ na, najas jipj ca jis capj mp'a'san pyülücpan más 'in 'ücj mponecj yupj napj mpes.) ");
INSERT INTO jicNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón tjevele Jesús lal: —Nejepa jipj. 'Ücj napj lal cawilta mo'o na 'onsopj napj jipj lal. Ma 'ü'nacj jipj lal 'ücj wa napj lal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús tjevele: —Pedro, yacjaj p'iyá la con ca mvelen ma nus nyuc. Castlyaj cocoy la puyú secj p'in, ca nin la mijin. ");
INSERT INTO jicNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús tjevele wa discipulopan pjü jis lal: —Nusin tjejyam nun jis t'emel cjuwá, nun jis ve cjuwá 'ots'ipj, nun jis caite pjaní p'in. ¿Ncu pjaní nujos cjuwatsja? Yupj tjowelepj: —Pjü qjuisastsja, pjü tya'actsja. ");
INSERT INTO jicNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús tjevele yupj jis lal: —Quina ma ca nlawú nusin pjan. Nun popé t'emel to'á, t'o wa nun lowú nt'a. Ve to'á, t'o wa nun lowú nt'a. Nun popé polomay cjuwá, más 'ücj jas quip pje'apa vender ca la mijis, t'emel mpes polomay ca jaylacj la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dios Popel vele: ‘La p'a ca yola nsem malala nyuca lajay jin p'iyá napj’. Dios jos nin ca nsem napj lal, Dios Popel nin vele mpes. Pjü tapac napj nin po'ó, quina ca nin mpalas pjü —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yupj tjowelepj: —Qjuis Jepa, 'unyuca. Polomay mát'eya tya'acj qui'á. Jesús tjevele: —Po ma p'a wa cüwelé quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús tjemey nepé yacjayam. Joc' Olivos ló nt'a tjemey, janmacj jin líjitsja jin. Jupj discipulopan cjüil tjil. ");
INSERT INTO jicNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne'as tjemey na, tjevele yupj jis lal: “Dios lal la tjomoná ma ca malala la müjí nun, nun quelel malala lojí na”. ");
INSERT INTO jicNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nin tjevele na, ne'aj p'in tjemey jusapj. Ne'aj tüic' jin tjüjünsü, tjevele Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nin tjevele jupj: “Mpapay, nin la mijin ma ca nin ma palas. Newa najas ca jipj jyas jinwá nsem. Ma napj najas jinwá t'as”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tjevele na, ángel tsjun mpe tjac', lay tepyala jupj nt'a, cus tjep'ya'sa. ");
INSERT INTO jicNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús 'aplijila waytsja pajal, ne pajal la tjemyona Dios lal. Pjü tji'yawa. Pajal noypan way ts'yósatsja 'ama'á, 'as jin jústatsja. ");
INSERT INTO jicNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","T'üc' tjevele na Dios lal, Jesús jas nisa, tjemey discipulopan nt'a. Yus tjinyuca pjü tjijinan̈. Yupj pajal 'aplijila waytsja, mpes ja sívetsja. ");
INSERT INTO jicNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús tjevele yupj jis lal: “¿Tsjan pjucj jünaqué nun? Nusin tjüjünsǘ, Dios lal la tjomoná ma ca malala la müjí nun quelel malala la müjí na.” ");
INSERT INTO jicNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús nin véletsja na, len̈ way niyom pülücj 'a mulú tjiquil. Yom pjaní jis lal tjac' Jesús ton̈ca nt'a. Yom niná Judas p'iyatsja. Jupj apostolpan dóceya pópatsja. Judas jun 'asas tjac' Jesús nt'a la tjelyapaná. ");
INSERT INTO jicNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús tjevele jupj lal: —Jipj nlal velen sin la 'üsüs jis la jay napj niná yomen yupj quelel tji'lin̈. Napj p'iyá niná Yomen Dios jas tjejyamá —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús discipulopan jus nlay yupj tjiquil jis la tjilil Jesús, mpes tjowelepj Jesús lal: —¿Ncu jyas sey mojo'ocj polomay lal? ");
INSERT INTO jicNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yupj popa pjaní polomay nt'ya, jay tjejyo'o yom pjaní. Pjots' li'inyampe taná tjejyo'o. Jupj ne mozo waytsja sacerdote más püné mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús ma jostsja pjots' tjejyo'o. —Po ma la tapa'ná nun —tjevele jupj. Jupj pjots' po la tje'yot'a, tji'yü'sa la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pülücj tjiquil jis la tjilil Jesús. Sacerdote noypan nepenowá, jepapan militar nepenowá Dios wo nt'a tsji' lajaytsja sin popé. Judío co'müypan nepenowá. Mpes Jesús yom pjots' tji'yü'sa la tjiji na, tjevele yupj jis lal: —¿Tsjan mpes polomay t'o, yo pjwel t'o wa la tjilil napj? Niná lojí pwequepj la tjilil. ");
INSERT INTO jicNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pjü jyawca Dios wo nt'a tjo'ostsja nun jilal. Lovin ma ntjutjililiqué ne'aj tjo'os na. Nun lojí diablo jos jin. Po quina way p'in Dios 'yaya jupj jyü'ta, mpes nun malala lojí quinam nujisas jinwá —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesús nin tjevele na, ntji'lin̈, lal tjil. Tjaman jupj sacerdote más püné wo nt'a. Pedro jupj cjüil tjemey, campapé. Sacerdote jis jepa wo nt'a tjemey wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wo nt'a niyom nepénowa 'awa jus t'ol wosis t'asiyú tjüwücj culupwen nt'a, 'a mulú 'atjalapj jis la sis. Pedro 'etjele wa yupj jilal. ");
INSERT INTO jicNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pedro ne'aj 'etjele na, tsjücjüim jus tjinyuca Pedrú, 'awa jyawca nt'a tjá'asa jupj, ne nin. Tsjücjüim niná mozo waytsja jupj ne'aj. Püs way jus tjinyuca na, tjevele: —Yom niná cus tecyon̈ca Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro tsyüpünǘ. —Nin tulucj. Ma si nuc —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Locopyaya yom pjaní ne'aj jus tjinyuca wa Pedro, mpes tjevele: —Jipj Jesús discipulopan popa wa. Pedro wola tjevele: —¡Nin tulucj! ");
INSERT INTO jicNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Locopyaya, hora pjaní tepyala na, más 'in püs ca nacj, más 'in len̈ way ca nacj, p'a wa ne'aj janmacj nin jólatsja Pedro po'ó, mpes tjevele: —T'üc' way yom niná cus tecyon̈ca wa Jesús. Jupj Galilea mpe 'esepj wa, Jesús jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro tjevele jupj lal: —Ma nin 'yüsa jipj velen. Pedro nin véletsja na, castlyaj cocoy nepé la tipiya. ");
INSERT INTO jicNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nepé la tipiya na, qjuis Jepa Jesús la nujuya, tjinyuca Pedrú. Mpes Pedro jola tepyala jupj tjevelá. Ninana jupj tjevelá: “Yacjaj p'iyá la con ca mvelen ma nus nyuc. Castlyaj cocoy la puyú secj p'in, ca nin la mijin.” ");
INSERT INTO jicNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro tjemey wo nepé. Pajal 'aplijila waytsja, pajal la tipiya wa. ");
INSERT INTO jicNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Niyom nepénowa jamanuntsja Jesús. La tjüpjüts'ün jupj mpes. Pajal mo'o süptsja wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jun tsupapj, tjowelepj: —Qjuis wala mvelen pjacj jey syüpa. Dios ca jin 'yüsa la mijis. ");
INSERT INTO jicNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","La p'a wa pajal pülücj malala tjowelepj Jesús po'ó, jupj pajal tsjicj way jin tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tjejyawca na, judiopan jis jepapan 'a jis tjimyula yupj, nepénowa sacerdote noypan, nepénowa Moisés popel sin 'yüsa lajay. Yupj lovin 'a jis tjimyula nt'a tjaman Jesús. Tjowelepj Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Dios tjevele jupj ca jas majamas Jepa Püné judiopan nt'a qjuis capj la p'acj. Qjuis wala mvelen ncu ninana yomen jipj. Jesús tjevele yupj jilal: —Napj nin cüvelé nun jis lal, ma ca mponé napj velé. ");
INSERT INTO jicNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Napj nu la 'yüy wa, nun ma ca nawala mvelé. ");
INSERT INTO jicNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Quina Dios li'inyampe ca mo'os lovin. 'A mulú ca müjü'tücj cupj. Pajal jas tjiyocj jupj. Napj p'iyá niná Yomen Dios jas tjejyamá —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yupj pjü way la tjü'üy Jesús lal: —¿Ncu Dios Jatjam jipj? Jesús tjevele yupj jis lal: —T'üc' tjowelé, Dios Jatjam napj. ");
INSERT INTO jicNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mpes yupj yuwá tjowelepj: —Quina ma qjuisas la p'a mvelecj tsjan niná yupj salejepj jupj po'ó. Tjepjya'aquecj jupj p'iyá tjevelá. Selecj malala la tjiji jupj; jupj tjevele yuwal jupj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Locopyaya yupj pjü sin tjüjünsüpj, tjaman Jesús Pilato nt'a. Pilato jepa püné auxiliar waytsja jupj. Romano waytsja jupj, judío tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne'aj tjat' tjowelepj Jesús po'ó. Tjowelepj: —Cupj tjinyucucj, tjepjya'aquecj wa yom niná judiopan sin 'yüsa lis tjiji jis la palan jepapan jilal. Qjuisí jütüta ma t'emel 'yayacj impuesto jaylacj, jepa püné jyü'ta jin. Jupj vele jupj jepa wa. Vele Dios jas tjejyama jupj jis capj la p'acj judiopan —nin tjowelepj co'müypan judiopan sin popé. ");
INSERT INTO jicNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mpes Pilato la tji'yüya Jesús lal: —¿Ncu judiopan jis jepa püné jipj? Jesús wola tjevele: —Nin napj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Locopyaya Pilato tjevele sacerdote noypan jilal, la p'a pajal pülücj ne'aj tjelejen̈tsja jilal 'ots'ipj. Tjevele: —Napj velé yom niná malala tulucj. Ma polel la veles jupj malala li jam. ");
INSERT INTO jicNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yupj newa malala tjowelepj Jesús po'ó. Po jisastsja Pilato ca cus ntülüs Jesús. Tjowelepj: —Jupj vele mpes judiopan ts'a 'in se palá jepa romanopan jilal, mpes quelel la palan nun jilal. Jun ta'á judiopan patja nt'a sin 'yüsa liji jupj. Galilea mo'ó sin tji'yüsa lis tjiji mwalá way p'in. Nepé qui'á tjac' Jerusalén nt'a. Nin p'iyá liji qui'á —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato tjapjaca Galilea nepé tjac' Jesús. Niná tjapjaca na, jis la tji'yüya Jesús po'ó: —Yom niná ¿ncu Galilea mpe tjac' jupj? ");
INSERT INTO jicNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yupj wola tjowelepj Galilea mpe tjac' Jesús. Pilato ma tjijyü'ta Galilea nt'a. Herodes jépatsja jupj Galilea nt'a, mpes 'ücj lo jütütj wa Jesús. Nin mpes Pilato jas tjejyama Jesús Herodes nt'a. Herodes la nuc wínetsja Jerusalén nt'a quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mpes tjaman Jesús Herodes nt'a. Herodes Jesús tjinyuca na, po 'ücj jostsja jupj. Püna tjapjaca jupj Jesús po'ó, mpes quelel si nucutsja jupj. Pajal püna quelel si nucutsja jupj. Herodes quelel nyúcatsja Jesús 'üsüs la mijis, yom p'in ma polel liji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mpes Herodes pajal püs way la tji'yüya Jesús lal. Mop'in Jesús ma lal tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ne'aj tjelejen̈ wa sacerdote noypan, Moisés popel sin 'yüsa lajay 'ots'ipj. Yupj newa pajal tjat' tjowelepj Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Locopyaya Herodes malala la tjiji Jesús lal. Nin p'iyá la tjajay wa jupj militarpan. Malala jin tjowelepj Jesús. La tjüpjüts'ün Jesús mpes. Locopyaya jas tücüipap jepa jas quip. Pajal 'üsüs way jústatsja niná jas quip. Locopyaya Herodes jas tjejyama Jesús Pilato nt'a niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nin jawas sejamicapan jis tepyala yupj, Herodes Pilato lal. Püna p'in enemigopan waytsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato 'a jis tjimyula sacerdote noypan, la p'a jepapan judiopan sin popé 'ots'ipj, la p'a judiopan 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tjevele yupj jis lal: —Nun tucumaná ntja'ayá niná yomen, jas la veles. Tjowelé jupj sin 'yüsa lis tjiji judiopan jis la palan jepa romanopan jis lal. Mpes napj la tji'yüy jupj nun nuwolap'a'á. Napj nin velé jupj ma nin la tjiji nun tjowelé jupj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes tjevele wa ma malala la tjiji jupj, mpes jas tjejyama Jesús cupj nt'a, ne niswa tjac'. T'üc' ma pajal malala la tjiji. Malala napj pajal si tül, 'yünampa, nujisas jin. ");
INSERT INTO jicNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Más 'ücj napj ca jay nsüp, locopyaya ca jas majam. ");
INSERT INTO jicNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato janmacj pjaní way jas tjejyama cawilta mpe fiesta niná lajaytsja na. Ne'aj tapatja nin jisastsja mpes nin la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilato quelel se jamatsja Jesús. Judiopan p'in ma jisastsja. Pjü 'a mulú la tupuyupj: —¡Tjü'ü'ná niná yomen! Barrabás se jam qjuisas. ");
INSERT INTO jicNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabás ma jostsja jepá, mpes la tepya'na 'ücj pje'á la nts'iyas jupj. La p'a tji'yü'na wa jupj, mpes cawilta mo'o tjo'onsopj jupj.) ");
INSERT INTO jicNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Niswa yupj jilal tjevele Pilato. Tjevele quelel se jamatsja Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Newa pajal la tupuyupj yupj: —Cruz po'o tjevyala jupj, mpa'is. Cruz po'o tjevyala jupj, mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Niswa jilal tjevele Pilato. La con nas tjevele jupj: —¿Tsjan pjucj cüvalá jupj cruz po'ó? ¿Tsjan malala la tjiji jupj? Napj selé ma pajal malala la tjiji. Malala napj pajal si tül, si jütütj ja'ünan Jesús. Napj ca jis müjütütj mo'o nsüpücj jupj; locopyaya ca jas majam —tjevele Pilato. ");
INSERT INTO jicNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Newa nin pajal yümücj tjowelepj, tjüjütütj cruz po'ó lo valas Jesús. Yupj pajal yümücj tjowelepj mpes, Pilato la tjiji yupj jisastsja jin. ");
INSERT INTO jicNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tjijyü'ta yupj tjüjütütj jin ca nsem, mpes ca cus ntülüs Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barrabás jas tjejyama jupj, yupj la tjomon mpes. Barrabás t'üc' way jepapan jilal quelel le palánatsja, yom tji'yü'na wa jupj, mpes cawilta mo'o tjo'onsopj jupj. Pilato jis tjijyü'ta jupj militarpan ca mal la 'ünan Jesús. Judiopan nin jisastsja, mpes nin la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Militarpan Jesús lal tjil cruz po'ó ca mvalacj nt'a. Jümücj nt'a jiltsja na, yom p'a wa ntji'lin̈ yupj. Simón lotsja jupj, Cirene mpe 'eseptsja. Jupj nasa way jactsja Jerusalén nt'a jupj tüpü'ü mpe. Jis wa pjaní pjaní lejen̈ mpe tjac' jupj. Cruz tja'ayapj tjyama jupj, ne Jesús cjüil tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pajal pülücj cjüil tjil Jesús. Yupj sin popé nequem nepénowa pajal 'aplijila waytsja malala tepyala Jesús. Pajal yümücj la tupuyupj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mpes Jesús cjüipe tjinyuca, tjevele yupj jis lal: —Po ma la tupuyú nun napj mpes. Nun p'iyá mpes la tupuyú, nuts'uyupj mpes la tupuyú. Nun p'in nequem Jerusalén mpe ne'espan. ");
INSERT INTO jicNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","P'a jyawca pajal 'aplijila ca nsem nun. Malala ca nu mpalas nun Jerusalén mo'o potjaqué. Mpes nun ca mvelé: ‘Más 'ücj jisas ts'uyupj cjuwá. Más 'ücj jisas lovin way tsjicj cjuwatsja. Más 'ücj jisas lovin ma tja'ayapj tsyo'o tsjicj way.’ T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Malala nyuca jis tepyala na, ca quelel ts'equenen̈, Dios ma jis capj la tül. Mop'in ma ca polel la mijicj. Ca quelel mvelecj joc' lal: ‘Jipj 'amá jus nts'eptam cupj capá nt'a’. Ca quelel mvelecj neven jilal: ‘Qjuis tjepjya'na jipj 'amá mpes’. ");
INSERT INTO jicNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","T'üc' way malala nyuca ca nu mpalas nun. Quina malala la najay, napj ne malala tulucj. Mpes solejé más malala ca la mijicj nun jis lal —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Militarpan jis tjaman wa pwecapan mát'eya cruz po'o la valas, jis la 'ünan Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tjil nt'a 'amá ne'aj Jay Pjucj Cjüele ló. Ne'as tjil na, ne'aj cruz po'o tjovalapj Jesús. Cruz po'o jis tjovalapj wa pwecapan, la p'a wa cruzus po'ó. Jesús culupwen tjovalapj yupj jilal. Pjaní way Jesús nancupwepe tjovalapj. Ma'ajapj jupj li'inyampe tjovalapj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús cruz po'o tjevyala na, jupj tjevele: —Mpapay, ma nin jele t'as yupj malala la ntjajay. Perdonar lis mijin. Ma sin 'yüsa tsjan lajay yupj. Militarpan ne'aj tjelejen̈ Jesús jas quip jisastsja. Tjepjelan̈ tjunuc pjacj nta'es jupj jas quip. ");
INSERT INTO jicNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Judiopan pülücj ne'aj tjelejen̈, Jesús jus tjunuc. Nin p'iyá la tjajay wa judiopan jis jepapan. La tjüpjüts'ün Jesús lal. Tjowelepj: —La p'a wa jis capj tjep'ya'sa. Dios jas tjejyama jupj jis capj la p'acj judiopan, más 'ücj jupj ca cus mp'a'sas jupj p'iyá. 'Ücj nin la qjuijis, Dios la t'ya jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Militarpan la tjüpjüts'ün wa Jesús lal. Jun 'asas tjiquil, uva 'üsǘ 'ona tja'ayapj lo müs Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tjowelepj jupj lal: —Jipj jepa püné judiopan jilal, cyapj tjep'ya'sa jipj p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nasa tabla tapac, tüpüntüpj Jesús jay nt'a. Tabla niná tapac tsjan mpes cus tül Jesús. Nin tjevele tablá: ");
INSERT INTO jicNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pecj pjaní Jesús lal ton̈ca p'a cruz po'ó, jupj malala nyuca tjevele wa Jesús lal. Tjevele: —Dios jin tjejyama jis capj la p'acj judiopan, cyapj tjep'ya'sa jipj p'iyá, qjuis capj tjep'ya'sa wa ncupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pecj ma'ajapj cus tjeve'le jupj, nin tjevele na. Tjevele: —¿Ncu ma lecj jeyan tsjan ca la mya jis Dios? Qjuis capj jatül wa ncupj yom niná lal. Qjuis tjovalapj wa ncupj cruz po'ó la mas. ");
INSERT INTO jicNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Ücj qjuis capj jatül ncupj. Malala nyuca la tjijicj, mpes 'ücj nin lajay. Yom niná ma malala nyuca la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pecj nin wa tjevele Jesús lal: —Jesús, ninpe jele tapalas cuy jyütütj na. ");
INSERT INTO jicNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús tjevele jupj lal: —T'üc' way yacjaj p'in ncapj ncon̈con Dios pü'ü nt'a. Pajal 'üsüs way ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesús nin tjevele na, lots'ac' culupwen nt'a tjá'asa quinam. Püste tepyala pjü nosis nt'a. Pǘstetsja hora cónt'eya. ");
INSERT INTO jicNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Lots'ac' ma tjejyawca la tjiji. Dios wo nt'a pülül p'omp'om jupj sin la tücüeme. Pülül niná wo t'em pjaní jinwatsja. Jas tüpwes la tücüeme, mat'e tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nin tepyala na, Jesús pajal yümücj tjevele Dios lal: —Mpapay, neqjues 'e 'a cyapj la con̈. Nin tjevele na, tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jepa militar tjinyuca pjü tepyalá Jesús tepe'e na. Tjinyuca na, 'üsüs tjevele Dios po'ó. Tjevele: —T'üc' way yom niná 'üsüs waytsja jupj, malala tulucj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nin nt'a pajal pülücj 'a si mulutsja nas, jis la nuc jis la 'ünan cruzus po'ó. Pjü tjunuc na, tjil jis wa nt'a. Jisas suna tül tjil. 'Aplijílatsja Jesús tjü'ünan mpes. Yupj jus nlay malala nyuca la tjajay. Lacj tjeyapj yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesús jomicapan custjay campa 'in tjelejen̈, tjunuc pjü tepyalá. Yupj nepénowa nequem. Yupj Jesús cus tocon̈, Galilea mpe tjac' na. ");
INSERT INTO jicNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Judío pjaní José lotsja. Arimatea mpe 'eseptsja jupj, judiopan patja nt'a. Jupj judiopan jis jepapan pópatsja. 'Üsüs líjitsja jupj. Dios lal 'üsüs waytsja 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José ma jostsja yupj tjowelepj ca cus ntülücj Jesús. Malálatsja jupj lal nin la jaympa. Ma jostsja tjü'ünan jupj. José jólatsja len̈ way Dios ca müjü'tüs nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesús tepe'e na, José tjemey Pilato nt'a. Jesús jüp'üy la tjemyona la toc la püntüs. 'Üctsja niná Pilato lal. ");
INSERT INTO jicNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mpes José Jesús jüp'üy palá nt'ya cruz mpe. Jas tjivyü'ünǘ pülül 'üsüs mpes. Pe jul nt'a tipyünta jupj, neven nt'a, tepe'e 'ücj la püntüs nt'a. Püna p'in tjijyü'ta la toc jomwen jul, tepe'e tulucj p'in. Nin lajaytsja judiopan. Mop'in ma tepe'e ne'aj tüpüntüpj custjay. ");
INSERT INTO jicNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesús tepe'e na, nin jawastsja pjü 'ücj lajay judiopan, ya ma ca tsji' la mijicj. Len̈ way ca sábado mpalas, yupj ma tsji' lajay na. Mpes len̈ way quelel líjitsja pjü. Ma polel pjü líjitsja Jesús jüp'üy mpes, jupj quelel líjitsja jin. ");
INSERT INTO jicNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nequem nepénowa cjüil tjil José, Jesús jüp'üy tipyünta nt'a. Yupj Galilea mpe tjiquil wa Jesús lal nawaja'a. Yupj quelel 'ücj lajaytsja Jesús jüp'üy, tepe'e mpes, lovin lajaytsja jin tecya'lin̈ jilal. Ma polel lajaytsja quinam, sábado pyala na. Mpes tjunuc yupj Jesús jüp'üy tüpüntüpj nt'a, tjunuc wa 'oyn nyuca tüpüntüpj jupj. Domingo na quelel jiquiltsja 'ücj la mijis jüp'üy. ");
INSERT INTO jicNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yacjaya jis wa nt'a tjil. Ne'aj 'ücj la tjajay Jesús jüp'üy jas la cjolol tepe'e mpes, lo 'üsüs cjumsu nepénowa, pomada 'üsüs cjumsu 'ots'ipj. Ya sábado waytsja, mpes ma tsji' la tjajay. Moisés popel nin tjevele püná. Dios jis tjijyü'ta ma ca tsji' la mijicj sábado na, mpes la nuctsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo tjejyawca na, nequem jomwen jul nt'a tjil, Jesús jüp'üy tüpüntüpj nt'a. Pajal püstapj tjil yupj. Yupj tjat' lo pajal 'üsüs cjumsu, tjat' wa pomada 'üsüs cjumsu, yupj 'ücj la tjajay t'an̈ yasapé. Pomada lal quelel sa cjololtsja Jesús jüp'üy, lovin lajaytsja jin tecya'lin̈ jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ne'as tjil na, jomwen jul nt'a, tjunuc pe püné jomwen jul jun tapá tjo'onsopj; jomwen jul jun cjol quinam. Nasa jas tentené tepyala pe püné quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nequem wama tjil jomwen jul mo'ó. Wama tjil na, Jesús jüp'üy ma tjunuc, jupj ne cupj qjuis Jepa. Len̈tsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nequem ne'aj tjelejen̈, pajal yólatsja tsjan mpes nin. Len̈ way niyom mat'e lay jis tepyala, ne'aj p'in lejen̈tsja nequem lejen̈tsja nt'a. Niyom sin quip sin jyáwcatsja. ");
INSERT INTO jicNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pajal lacj tjeyapj nequem, ne sey tococj yupj. Mpes niyom tjowelepj yupj jis lal: —¿Tsjan pjucj lo palá yom jun 'yüna tepe'e japüntüpj nt'a? ");
INSERT INTO jicNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Len̈ jupj qui'á. Jas tjijyünsa. Nyucunú tepyala niswá. Nujola tapalas jupj tjevele ca nin mpalas; newa Galilea mo'o tüpü'ü na tjevele niná. ");
INSERT INTO jicNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tjevele niyom malala nyuca lajay ca ntji'lin̈ jupj, yupj jisas jin ca mijicj jupj lal. Tjevele cruz po'o ca mvalacj jupj, mpes ca mpa'is. Tjevele locopyaya, ts'ac' cont'e tepyala na, ca jas müjünsüs, ca mpü'üm niswá. Jupj p'iyá niná Yomen Dios jas tjejyamá. Dios jostsja ca nin nsem —nin tjowelepj niyom mat'eyá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Locopyas yola tepyala Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pje'á tjiquil quinam yupj, jomwen jul mpe. Jesús discipulopan tapatja nt'a tjil yupj. Jesús apostolpan once jilal tjowelepj pjü tepyalá jomwen jul nt'a. P'a discipulopan jis lal 'ots'ipj, pjü jis lal tjowelepj pjü tepyalá jomwen jul nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nequem nenem María Magdalena lotsja pjaní wa, p'a wa Juana lotsja, María Jacobo jamaytsja pjaní wa. La p'a nequem jis lal tjiquil. ");
INSERT INTO jicNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Discipulopan ma topon nequem tjowelepj. Nequem ma yola javelepj yólatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Locopyaya Pedro jas nisa jupj tjá'asa mpe, ts'üequené pe jul mo'ó. Quelel nyúcatsja min t'üc' tjowelepj locopyas. Ne'aj jun vilicj nt'a palá nipi'tje, wama tjinyuca. Pülül jas tjüwü'üntsja jas tjan já'asa tjinyuca. Tjinyuca na, wo nt'a tjemey Pedrú. Pajal jólatsja, ma jas tji'yüsa tsjan mpes nin tepyala. ");
INSERT INTO jicNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nin jawas p'iyá discipulopan mát'eya tjil Emaús nt'a, nepénowa patja nt'a. Legua mát'etsja Emaús Jerusalén mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jümücj casá jiltsja, nin javeleptsja pjü tepyalá Jesús tepe'e mpes. ");
INSERT INTO jicNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yuwá p'in tjowelepj 'oyn nyuca tepyala pjü. Nin javeleptsja na p'iyá, Jesús p'iyá tjac' ne'aj, jis capj tecyon̈ca jümücj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma jus nlay pjacj niná. Dios ma jis tje'yaya ne'as tjunuc jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús tjevele yupj jis lal: —¿Tsjan welé lowú p'in? Jesús nin tjevele na, jis tyantaná yupj, pajal 'aplijila jin yus tjunuc yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pjaní way Cleofas lotsja. Jupj Jesús lal tjevele: —Jipj tjacuy wa la nuc Jerusalén nt'a, mpes ca jus nlayen Jerusalén nt'a tepyalá nawaja'a p'in. Pjü salejepj ne'aj tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús tjevele yupj jis lal: —¿Tsjan tepyala? Yupj Jesús lal tjowelepj: —Jesús lal tepyalá velecj cupj. Nazaret nepé 'eseptsja jupj. Profétatsja jupj. Pajal 'üsüs la tjiji, Dios p'in 'ücj liji jinwá. Pajal 'üsüs tjevele wa, 'ücj la jütütj jinwá. Dios selé. Pjü gente salejepj wa niná. ");
INSERT INTO jicNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jupj pajal 'üsüstsja, yupj sin nin tjü'ünan jupj. Qjuis jepapan Jesús ntji'lin̈, tjaman jupj Pilato nt'a. Nin la tjajay sacerdote noypan, la p'a jepapan 'ots'ipj. Pilato tjevele 'ücj cus la tül, la 'ünan Jesús. Cruz po'o tjovalapj mpes tepe'e jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pajal malálatsja niná cupj qjuilal. Cupj tepyonecj Dios jas tjejyama jupj judiopan jis capj la p'acj. Tepyonecj jupj ca 'ücj la mijis ma ca qjuis müjü'tücj romanopan quinam. P'a wa mpes qjuiyola: newa nin p'iyá; t'an̈ yasapé nin tepyala. Ts'ac' cont'e quinam. ");
INSERT INTO jicNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","”Pajal qjuiyola nequem nepénowa qjuis wala tjowelepj mpes. Discipulopan popa yupj, cupj jinwá. Pajal püstapj ne'as tjil jomwen jul nt'a, Jesús jüp'üy tüpüntüpj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ne'aj ma tjunuc jüp'üy. Niswa tjiquil, tjowelepj angelpan ne'aj lay jis tepyala yupj nt'a. Angelpan tjowelepj Jesús nyucunú niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mpes nepénowa ne'aj tjil cupj popé, jomwen jul nt'a tjil, Jesús jüp'üy tüpüntüpj nt'a. Nin p'iyá tjunuc yupj, nequem tjowelepj jin. Ma jus tjunuc Jesús lovin —nin tjowelepj discipulopan mát'eya. ");
INSERT INTO jicNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús tjevele yupj jis lal: —Nun ma nujola jinwá lojí. Nusey c'a pajal. Po ma quelel poné pjü way profetapan tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dios jas tjejyama jupj jis capj la p'acj judiopan. T'üc' way pjü nin tepyala, Dios jostsja jin tepyala jupj. Jostsja wa pajal püné ca nsem jupj pjü jis lal, pjü niná t'üc' tepyala na —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús jis wala tjevele Moisés tepyaca popé, locopyaya tjevele wa pjü profetapan tapac popé 'ots'ipj. Pjaní pjaní 'üsüs jis wala tjevele tsjan mpes pjü tapac jupj po'ó. Yupj tapac, Dios Popel niná. ");
INSERT INTO jicNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yacjaya ne'aj p'intsja quinam yupj quelel jiltsja nt'a, nepénowa patja nt'a. Jesús jümücj casá ca mim jinwá la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yupj ma jisastsja jupj ca mim. Pajal la tjomon ma lo winin quinam. Tjowelepj: —Qui'á mpü'üm, majan ncupj nt'a. Quina quelel t'yaja. Len̈ way ca ncawajas jaw na. Yupj tjowelepj mpes, jis lal tjemey mpü'üm, ca majas yupj patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wo nt'a wama tjemey. Yacjaya mesa nt'a tjá'asa yupj jis lal, quelel jalatsja na. Jesús pan nt'ya, tjevele tjüwüi'i Dios lal pansas tje'yaya mpes. La tjelepta, jis tje'yaya pansas. ");
INSERT INTO jicNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nin la tjiji na, jus nlay pjacj ne jupj. Yun la tapacj tjunuc jinwatsja yupj. Yupj jus nlay na Jesús jupj, len̈ tjevyala jupj, tjá'asa nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niyom tjowelepj yuwá: —Jesús p'iyatsja jupj. Nin mpes pajal 'ücj qjuisastsja qjuis lal tjevele na jümücj nt'a. Jupj 'üsüs qjuis wala tjevele tsjan mpes pjü nin tapac Dios Popel mo'ó, mpes pajal 'ücj qjuisastsja cupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Len̈ way tjil yupj tjatja mpe, discipulopan mat'eyá. Jerusalén nt'a tjil niswá. Ne'aj apostolpan 'ónceya 'a mulú tjatja tjunuc. La p'a wa 'a mulú tjatja wa yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Apostolpan javeleptsja: “T'üc' way jas tjijyünsa, pü'ü niswá qjuis Jepa Jesús. Lay tepyala jupj Simón nt'a.” ");
INSERT INTO jicNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Locopyaya niyom mat'e tjowelepj wa tsjan jis tepyala jümücj nt'a. Tjowelepj Jesús pan la tjelepta yupj jis wa nt'a. Nin la tjiji na, jus nlay jupj p'iyá ne Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yupj nin tjowelepj na, len̈ way Jesús lay jis tepyala, culupwen nt'a ton̈ca. Tjevele yupj jis lal: —'Üsüs mpatjaqué; ma nujola t'as. ");
INSERT INTO jicNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pajal tüpwectan̈, lacj jeyapj lejen̈tsja yupj. Cjües p'in tjunuc jin yólatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús tjevele yupj jis lal: —¿Tsjan mpes lapj nyuca nujola nun? ¿Tsjan mpes nusey c'a nun? Nun ma poné napj pü'üs niswá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Namas jus tjunucú, ntsjam jus tjunucú wa. Jus nlayé ca napj Jesús. Nin po la tjo'ot'é, nus 'unuca wa. Cjües p'in jüp'üy tulucj, cjüele tulucj wa. Nun nus nucú mp'üy jana wa, neqjuele jana wa —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nin tjevele na, jis tje'yaya tjunuc jupj mos, jupj tsjom, clavo mo'o tjil mpe. ");
INSERT INTO jicNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pajal 'ücj jisastsja yupj. Jesús jin yólatsja, newa Jesús tulucj jin yólatsja. Ma polel japontsja custjay, mpes jupj tjevele yupj jis lal: —¿Ncu to'á qui'á napj nla? ");
INSERT INTO jicNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mpes cjul tjü'üm tsjicj way tja'ayapj. Tsjiminicj ts'osis tja'ayapj wa jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jupj nt'ya, tjelyaja wa tjunuc yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Locopyaya yupj jis lal tjevele: —Niná nin ntepalá tjevelé nun jis lal nin ca ma palas. Newa nun lal tüpü'üs na tjevelé niná. Tjevelé pjü nin po'o tapac Dios Popel mo'ó, Dios jostsja pjü nin tapac jinwá tapalas pjü. Pjü Moisés nin po'o tepyaca, profetapan nin po'o tapac wa, nejets'en̈ tapac nin po'o tapac wa, jupj jostsja nin tapac jinwá tapalas pjü —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Locopyaya jis capj tjep'ya'sa sin la 'üsüs, mpes sin tji'yüsa Dios tjevelá jupj Popel mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tjevele yupj jis lal: —Püna tapac Dios ca nin majamas nosis nt'a jis capj la p'acj nosis casá patjá. Tapac pajal ca malala ma palas, ma pats' ca. Locopyaya ts'ac' cont'e tepyala na, ca nin müjünsǘ, mpü'üs niswá. Nin tapac yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Napj pjü la tjejay mpes, napj mpes japon p'a lal ca mvelecj nin po'ó. Pjü nosis nt'a ca mvelecj yupj. Ca mvelecj Dios jos pjü way 'aplijila nsem malala nyuca la tjajay mpes, ca 'üsüs la mijicj quinam Dios jos jinwá. Napj mpes topon na, Dios ma ca nin jola nsem yupj malala la tjajay. Mwalá way p'in Jerusalén nt'a jis wala ca mvelecj niná. Locopyaya jun ta'á ca mal, pjü p'a nt'a patja nt'a ca mvelecj napj la tjejay. ");
INSERT INTO jicNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","”Nun pjü tjunucú pjü tepyalá, mpes la p'a jis lal tjowelé tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nusin tjü'üsüs niná: napj Dios Cjües ca jas majam nun nt'a. Püna Mpapay tjevele ncuwim jupj. Mpes ma lowa quepem, Jerusalén mpe quinam. Jupj tjac' naya, 'ücj lowú. Tsjun popé jac' qui'á. Jupj tjac' na nun nt'a, jupj ca nucopj mp'a'sas 'ücj la müjí Dios jos jin. Nucopj mp'a'sas 'ücj tsji' la müjí Dios mpes —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Locopyaya Jesús tjemey yupj jis lal Jerusalén mpe. Betania ne'aj p'in nt'a tjemey yupj jis lal. Ne'aj mos sin tjijyünsa, la tjemyona jupj Popay lal jupj ca 'üsüs lis mijis yupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Newa véletsja na, jas tjan tjemey, ne Dios tsjun po'o jas tjemyana jupj. ");
INSERT INTO jicNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yupj ne'aj tjelejen̈ pajal 'üsüs pjac tjowelepj jupj po'ó. Pajal püné jupj jin yólatsja yupj. Pajal 'ücj jisastsja yupj niswa tjil na Jerusalén nt'a. ");
INSERT INTO jicNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne'aj lovin Dios wo nt'a tjátjatsja yupj, 'üsüs pjac tjowelepj Dios po'ó, tjowelepj tjuwi'in̈ Dios lal.");
INSERT INTO jicNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jesucristo vele cupj qjuis lal Dios po'ó. Jupj p'iyá liji mpes qjuisin 'yüsa Dios mpes. Jesucristo lovin pǘ'ütsja jupj. Pajal püna nosis cjuwatsja na, pues pjü cjuwatsja na, jupj newa tüpǘ'ütsja. Jupj lovin Dios lal tüpü'ü, ne jupj p'iyá Dios watsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jupj p'iyá Dios lal pǘ'ütsja nosis cjuwatsja na p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios pjü la tjiji jupj lal. Pues pjü way Dios la tjiji, Jesucristo lal la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesucristo mpes pátjatsja pjü. Jupj se 'aya 'ücj jis la püt'üs. Jupj pü'ü mpes, nosis casá patja 'ücj sin 'yüsa wa Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nosis püste jinwá malala nyuca lajay mpes. Jesucristo jaw jinwá nosis nt'a. Sin 'yüsa liji Dios po'ó. Gente malala lajay ma jisas jupj. Newa ma sin 'yüsa Jesucristo po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yom tjac' wa cupj nt'a. Juan lotsja jupj. Dios jas tjejyama tjac' jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan tjac' la veles jupj seletsja po'ó. Jupj tjevele yom pjaní jyawca jinwá ca nsem cupj qjuilal, qjuisin 'yüsa la mijis Dios mpes. Juan jostsja pjü ca mponecj yom niná po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jesucristo niná p'iyá, jyawca jinwatsja nosis nt'a. Juan p'a watsja. Jupj tjac' la veles Jesucristo po'ó, jupj seletsja mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Locopyaya Jesucristo nosis nt'a tjac' wa. T'üc' way jupj jyawca jinwatsja nosis nt'a. Jupj pjü gente sin 'yüsa liji. ");
INSERT INTO jicNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dios pjü la tjiji nosis nt'a jupj lal. Jupj tüpü'ü nosis nt'a, mop'in nosis casá patja ma salejeptsja pjacj cuscú jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jupj tjac' jupj jyü'ta nt'a; nin p'iyá jupj si jütüta sin popé ma jisastsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nepénowa jisastsja jupj. Yupj topon jupj mpes ca 'ücj mpatjam Dios lal. Nin mpes jupj jis tje'yaya 'ücj Dios ts'uyupj ca jis mpalas yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Dios p'iyá liji jupj ts'uyupj se palá yupj, mpes nin. Sejamay niswa se jamanun mpes tulucj. Jis papay, sejamay sin popa jisas mpes tulucj. Yom jos mpes tulucj; Dios p'iyá liji jupj ts'uyupj se palá Jesucristo lal japon. ");
INSERT INTO jicNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo liji mpes qjuisin 'yüsa Dios po'ó. Yom tepyala jupj püná. Jupj pǘ'ütsja ncupj pyatjaquecj nt'a wa. Tjinyucucj jupj pajal 'üsüs la tjiji, t'üc' way pünetsja jupj. Jupj Popay Dios pjaní way Popa, mpes 'üsüs jupj pajal. Qjuis Papay Dios mpe tjac'. Cupj 'üsüs tuluctsja, mop'in nin, jupj pajal 'üsüs la tjiji cupj mpes. Jupj t'üc' way qjuisin 'yüsa liji Dios po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan seletsja mpes 'üsüs tjevele Jesucristo po'ó. Ninana jupj velá Jesucristo po'ó, pjü 'ücj jis la pjac: “Jupj ne niná yomen napj tjevelé po'ó. Napj tjevelé napj mwalá way tjacuwis; tjevelé yom p'a wa ncuwim p'a jawas nun jis lal la veles Dios po'ó. Más püné tepyala jupj napj lal. Jupj pajal püna tüpü'ü, mpes más püné jupj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","”Jupj lovin pajal quelel la qjuisiji. Mpes jupj pajal 'üsüs la tjiji cupj mpes. Newa qjuesé 'aya, jupj quelel la qjuisiji mpes. Nin p'iyá pjü way ncupj qjuilal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés qjuis wala tjevele Dios tjijyü'tá, nin p'in. Jesucristo más 'üsüs Moisés lal. Jesucristo mpes Dios pajal 'üsüs la tjiji cupj mpes. Jesucristo mpes wa qjuisin 'yüsa liji t'üc' way jupj p'iyá po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gente lovin ma jus tjunuc Dios, yupj yun lal. Dios Popa pjaní qjuisin 'yüsa liji 'onin niná Dios. Dios Popa pjaní jupj, p'a cjuwá. Lovin se con̈ca Popay. Quelel liji jupj pajal”, nin tjevele Juan Jesucristo po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judiopan jis jepapan Jerusalén nt'a tapatja. Yupj sacerdotepan sin tjajam Juan nt'a jis la veles jupj lal. Auxiliarpan sin tjajam wa yupj jis lal. Sin tjajam la tjü'üy, tjunuc tsjan mpes 'ücj bautizar la tjiji. Juan seletsja mpes tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Niná pajal tülü way jis wala tjevele Juan: —Dios tjevele püná jupj ca jas majamas Jepa Püné judiopan nt'a, jis capj la p'acj. Nam 'a jupj tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yupj tjowelepj Juan lal: —Jipj velen ninana tulucj jipj. ¿Pjacj ne jipj? ¿Ncu Elías jipj, jupj ne pajal püna tüpü'ü? Juan jis wala tjevele: —Napj Elías tulucj. Yupj la tjü'üy: —¿Ncu jipj profeta niná Dios tjevele ca jas majamas cupj nt'a la veles jupj mpes? Juan jis wala tjevele: —Jupj tulucj napj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mpes jupj lal tjowelepj: —Qjuis wala mvelen pjacj jipj ne 'ücj nin la cüjay niná. Cupj quelel jis wala velecj ncupj qjuisin tjajam. ¿Tsjan velen jipj p'iyá po'ó? ");
INSERT INTO jicNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jupj tjevele: —Isaías Dios mpes tjevele pajal püna. La pjaní napj nin po'ó tjevele jupj. Tjevele: ‘Yom niná wa cjuwá nt'a ca mim. Pajal ca quelel mveles gente jilal napj mpes. Mpes yümücj ca mveles: “Malala nujola nun, jümücj la lu'ulú jinwá. Po ma malala nujola t'as quinam. 'Üsüs nujola t'as qjuis Jepa Püné jos jinwá.” ’ Nin tjevele Isaías ca nin mvelé napj —tjevele Juan. ");
INSERT INTO jicNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseopan nepenowá Juan lal tjowelepj wa. Jepapan sin tjajam wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yupj tjowelepj: —Jipj velen jipj Yom niná tulucj, Yom niná Dios tjevele ca jas majamas jis capj la p'acj judiopan. Jipj velen Elías tulucj jipj. Jipj velen jipj profeta niná tulucj, profeta niná Dios tjevele ca jas majamas la veles jupj mpes. ¿Tsjan pjucj bautizar la sejay jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan jis wala tjevele: —Napj bautizar la nusejay la p'in 'üsǘ mpes. Yom p'a wa wine nun potjaqué nt'a, nun ma solejé pjacj ne jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jupj jac' locopyaya napj lal, Dios Popel vele jin. Jupj ca mveles wa nun jis lal Dios mpes. Pajal püné jupj napj lal. Napj pajal tsjicj way jupj lal. Po 'üsüs napj lal tsji' lejay jupj mpes. Napj jupj caite syoc la p'in, 'ücj napj lal —nin tjevele Juan niyom jilal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nin tepyala Betania mo'ó 'üsǘ na'aj po'ó. Jordán lotsja 'üsǘ püné. Juan bautizar líjitsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","P'a jyawca Juan tjinyuca Jesús jactsja jupj nt'a. Mpes Juan tjevele ne'aj tjatja jis lal: “¡Tjunucú nun! Niná Dios jas tjejyama. Jupj ca mpa'is gente mpes. Jupj tepe'e na, Dios ca perdonar lis mijis malala nyuca la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","T'an̈ p'in jupj mpes tjevelé. ‘Yom pjaní jac' locopyaya napj lal —tjevelé—. Más püné way jupj napj lal. Mwalá way pǘ'ütsja napj lal, mpes más püné jupj napj lal’, nin tjevelé napj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Napj quelel sin 'yüsa lejaytsja israelpan pjacj ne jupj. Nin mpes tjacuwis, bautizar la sejay 'üsǘ lal. Püna p'in napj p'iyá ma seletsja pjacj ne jupj”, tjevele Juan. ");
INSERT INTO jicNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan p'a wa jis wala tjevele wa Jesucristo po'ó. Tjevele: “Napj tjinyuc Dios Cjües sipipj jinwá tjac', jay la p'a'ape tjac'. Nayapé palá tjac' Jesús nt'a, ne Jesús casá já'asatsja. ");
INSERT INTO jicNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Püna p'in napj p'iyá ma seletsja Jesús niná Dios jas tjejyama cupj nt'a. Dios nin tji'yüsa la tjiji niná. Jupj p'iyá nin tjejyama bautizar lis mejay napj. Jupj napj lal tjevele püna p'in: ‘Jipj ca nucun napj Neqjues palá ncuwim nayapé. Jupj yom pjaní nt'a ca mim lo püt'üs. Yom niná napj Neqjues se 'aya, gente jis lal la püt'üs, Dios Cjües ca jis capj ncon̈cos’, nin tjevele Dios napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jupj tjevele jin tjinyuc napj. Napj tjinyuc mpes nin tjevelé yomen niná 'a Dios Jatjam jupj”, nin tjevele Juan. ");
INSERT INTO jicNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yaya Juan tón̈catsja niswá jupj discipulopan mát'eya jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jupj Jesús jus tjinyuca ne'aj tjemey. Mpes Juan tjevele jupj discipulopan jis lal: —Tjunuca nun. Niná Dios jas tjejyamá. Jupj ca mpa'is nosis casá patja mpes, oveja tsjicj jinwá. Jupj ca mpa'is malala nyuca la tjajay mpes, ca yupj mpatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan discipulopan mát'eya sin tji'yüsa jupj tjevelá, mpes tjil cus la con̈ Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús la nujuya, yus tjinyuca cjüil jiquiltsja. Tjevele yupj jis lal: —¿Tsjan nujisas nun? Yupj tjowelepj jupj lal: —Cupj quelel selecj ca'aj püt' jipj. Rabbí jipj. (Rabbí tjowelepj yupj jis tin; “jipj sin 'yüsa lejay”, velecj cupj.) ");
INSERT INTO jicNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jupj tjevele yupj jis lal: —Nculá, nucú nun. Mpes tjil jupj lal. Tjunuc jupj tüpü'ü nt'a. Ts'ac' niná jupj lal tjatja yupj. Las cuatro t'yaja na tjil jis la nuc Jesús tüpü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mát'eya tjepjyacan̈ Juan tjevelá. Manas tjil cus la con̈ Jesús. Yupj popa pjaní Andrés lotsja. Andrés Simón Pedro tsüípetsja. ");
INSERT INTO jicNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés Jesús jus tjinyuca na, len̈ way tjemey la tepyala jupj tsüipe Simón. Jus tjinyuca, tjevele jupj lal: —Ncupj jus tjinyucucj Jepa niná Dios tjevele ca jas majamas cupj nt'a. Jupj ca qjuis capj mp'a'sas. ‘Cristo’ jupj velecj cupj. Nasa tjac' jupj —tjevele Andrés. ");
INSERT INTO jicNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés tsüipe lal tjac' Jesús nt'a. Jesús Andrés tsüipe jus tjinyuca, tjevele: —Simón jipj, Jonás jatjam jipj. P'a wa ca lyá nsem jipj quinam. Cefas lyá nsem jipj. (Cefas “Pedro” javelepj ts'ecj. “Pe püné” velecj cupj.) ");
INSERT INTO jicNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yaya Galilea nt'a quelel jámatsja Jesús. Mwalá way p'in, jupj Felipe jus tjinyuca, tjevele jupj lal: —Ncapj tecyon̈ca. Najas ncapj cyon̈ lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida mpe 'eseptsja jupj. Pülücj patja Betsaida nt'a. Andrés, Pedro 'ots'ipj, Betsaida mpe ne'espan watsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe Natanael la tepyala yacjaya. Jus tjinyuca na, jupj lal tjevele: —Moisés tjevele Dios ca jas majamas Yom pjaní cupj nt'a, jupj ca qjuis capj la p'acj. Nin tepyaca jupj popel mo'ó. Profetapan nin p'iyá tapac Dios mpes. Nas tjinyucucj yomen niná yupj tjowelepj po'ó. Jesús jupj, José jatjam jupj. Nazaret mpe 'esepj jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael Felipe lal tjevele: —Ma pyon Nazaret mpe 'esepj ca 'üsüs nacj jupj. Felipe wola tjevele: —Was, nucun jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Locopyaya Jesús Natanael jus tjinyuca, jactsja na. Jupj mpes tjevele: —Israelpan popa t'üc' way jupj. Jupj Dios jos. Ma li tsuwile. ");
INSERT INTO jicNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael tjevele jupj lal: —¿'Oyn ne selen nus nyuc? Jesús jupj wola tjevele: —Napj jis tjinyuc, ts'oway 'ala'á jactsja na. Napj jis tjinyuc Felipe custjay ma jipj lal tjevele na p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mpes Natanael Jesús wola tjevele: —Rabbí, jipj Dios Jatjam. Israelpan jis Jepa Püné jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús tjevele jupj lal: —Napj tjevelé jipj lal jis tjinyuc ts'oway 'ala'á, mpes jipj pyon napj Dios Jatjam. Jipj ca nucun wa napj más 'üsüs ca la mejay wa niná lal. ");
INSERT INTO jicNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús tjevele wa jupj lal: —Nun ca nucú tsjun po'ó jun cjol, Dios pü'ü nt'a. T'üc' way velé. Ca nucú wa Dios angelpan viyá ca mal napj mpe, ca palá ncul wa niswá napj nt'a. Napj p'iyá niná Yomen Dios jas tjejyama —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ts'ac' mat'e tepyala na, pülücj 'a jis tjimyula Caná nt'a, Galilea mpe se jütütj nt'a. Ne'aj yom pjaní tjowaya. Nin mpes jupj popay pülücj jis la las la tjiji jüpülücpan mpes, jomicapan mpes 'ots'ipj. Lovin nin la tjajay yupj, tjewyayin̈ jis lal. Jesús jamay ne'aj wa já'asatsja. ");
INSERT INTO jicNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tjowaya popay tjevele Jesús ncuwim nlajas wa. Jupj discipulopan jis lal tjevele ca ncul wa jis la las yupj, mpes tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne'aj uva 'üsǘ nasa quelel pjojo na, Jesús jamay tjevele jupj lal: —Tjapjaja quinam uva 'üsǘ jis la müs. ");
INSERT INTO jicNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús tjevele jamay lal: —Namay, ¿tsjan mpes velen niná napj lal? Quina 'a li nuc. Dios jos naya ca la mejay. ");
INSERT INTO jicNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesús jamay tjevele mozopan jis lal: —Jesús vele jin la müjí ca nun. ");
INSERT INTO jicNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne'aj tjelejen̈ jarro noypan séisiya, pe witjacj yupj. Judiopan jisastsja jarro nin jinwá, 'üsǘ jis la 'as'üs jis la pul. Judiopan jis popel tjijyü'ta 'onin ca 'üsüs ma'as'ün̈, ne ca salá jinwá nsem yupj Dios lal. Jarro pjü way veinte galón ca nacj, treinta galón ca nacj, noypan waytsja pajal. ");
INSERT INTO jicNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús tjevele mozopan jis lal: —'Üsǘ mo'o t'u jarras mo'ó, pues pjü way mo'o t'u, pit'a nas. Mpes tipit'a la tjajay quinam pjü way jarras. ");
INSERT INTO jicNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","T'üc' nin la tjajay na, Jesús tjevele yupj jis lal: —Mpulú quinam. Tja'ayá mü'üm auxiliar más püné, jupj pjü 'ücj liji pülücj jis la las mpes. Nin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Auxiliar más püné tsjicj way tjümü'ü, tjinyuca 'üsǘ 'oyn sya'ma. 'Üsǘ tuluctsja quinam. Uva 'üsǘ tepyala nas. Auxiliar ma seletsja ca'aj mpe tucutj nenem. Mozopan salejeptsja la p'in. Yupj 'üsǘ tupul ne nin. Mpes auxiliar tjevele yom tjowaya lal: —Was jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Auxiliar tjevele jupj lal: —Niyom p'a witjacj uva 'üsǘ pajal 'ücj sya'ma ja'ayapj jis la müs mwalá way p'in. Locopyaya, pajal tjimyü'ün̈ na, uva 'üsǘ pjaní way jaylacj ja'ayapj jis la müs. Jipj ma nin la tjejay. Uva 'üsǘ niná se 'an, pajal 'üsüs mwalá way tje'yan lal —nin tjevele auxiliar más püné. ");
INSERT INTO jicNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Niná Caná nt'a nin la tjiji Jesús, Galilea mpe se jütütj nt'a. Mwalá way nenem Jesús pajal 'üsüs la tjiji sin la 'üsüs jis la jay Dios jas tjejyama jupj. Nin mpes wa sin 'yüsa lis tjiji wa jupj p'iyá pajal 'üsüs, pajal püné jupj. Nin la tjiji na, jupj discipulopan topon t'üc' way jupj Yom niná Dios jas tjejyama jis capj la p'acj judiopan. ");
INSERT INTO jicNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Locopyaya palavin tjemey Jesús Capernaum nt'a. Tjemey jamay lal, jüpülücpan jis lal wa, jupj discipulopan jis lal wa. Ne'aj tsjicj way tapatja yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nasa quelel fiesta pyálatsja. “Dios Qjuis Capa Nipj Tjemey” nin lotsja fiesta niná. Jesús tjemey Jerusalén nt'a fiesta niná mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dios wo nt'a tjemey jupj. Ne'aj nepénowa jis tjinyuca vaca vender lajaytsja. Oveja vender wa lajaytsja, sipipj 'ots'ipj. Jis tjinyuca wa nepénowa judiopan jis t'emel vender lajaytsja romanopan jis t'emel mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús ma jostsja nin lajaytsja Dios wo nt'a. Mpes 'üpǘ tipi'ts'a jupj. 'Üpǘ lal mo'o la syüpjünǘ, pje'á sin tjejyama pjü way yupj Dios wo nepé, oveja 'ots'ipj, vaca 'ots'ipj. 'Amá 'alá la ts'iya wa yupj jis t'emel, t'emel vender la tjajay yuts'a'á. Jis mesa ts'eptaná wa. ");
INSERT INTO jicNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús tjevele sipipj vender lajay jis lal: —Pje'á la tocoyé nun jis caja quepé, sipipj jis wa. Mpapay wo niná. ¿Tsjan pjucj vender lojí nun qui'á? ");
INSERT INTO jicNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús discipulopan yola jis tepyala 'oyn tsji Dios Popel. Vele: “Dios wo mpes nin nola, mpes ca malala nyuca ma palas napj”. Nintsja Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesús pjü pje'á sin tjejyama mpes, judiopan jis jepapan nepenowá jupj wola tjowelepj: —¿Tsjan mpes 'ücj la cüjay niná jipj? Cupj qjuisas pajal 'üsüs la mijin, yom p'in ma polel liji jinwá, mpes ca jus nlayecj ncu Dios jin tjejyama jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús jis wala tjevele: —Nin ca la mejay napj: nun malala lojí na Dios wo, ts'ac' cont'e tepyala na napj ca t'üc' jas müjünsǘ niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mpes judiopan jis jepapan jupj wola tjowelepj: —Pajal püs way jas tjüjünsüpj Dios wo niná. Año cuarenta y seis mpes t'üc' jas tjüjünsüpj. ¿'Oyn jele ne 'ücj jas müjünsün ts'ac' cont'e p'in? ");
INSERT INTO jicNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Judiopan jis jepapan ma sin tji'yüsa Jesús tjevelá. Yólatsja wosis pe mpes ca jas müjünsüs. Nin tuluctsja. Jupj tjevele jupj jüp'üy po'ó. Jesús jüp'üy Dios wo wa. ");
INSERT INTO jicNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús tepe'e na, jas tjijyünsa niswá lo püt'üs. Nin tepyala na, jupj discipulopan yola jis tepyala nin tjevele Jesús. Nin mpes yupj topon Dios Popel tjevelá jupj po'ó. Topon wa Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ts'ac' nepenowá fiesta nt'a tüpü'ü Jesús, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. Ne'aj tjá'asa na, Jesús pajal 'üsüs líjitsja sin la 'üsüs jis la jay Dios jas tjejyama jupj. Pajal pülücj tjunuc jupj pajal 'üsüs líjitsja, mpes yupj popa pülücj topon jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Newa Jesús ma pjü tjevele yupj jis lal. Jupj seletsja yupj ma t'üc' way sa con̈tsja jupj. Jupj seletsja 'oyn nyuca yola pjü gente nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","La p'a jupj lal tjevele tulucj; jupj sin seletsja gente sin po'ó. Jupj p'iyá seletsja pjü yolá. ");
INSERT INTO jicNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nicodemo tüpü'ü wa Jerusalén nt'a, Jesús tjá'asa nt'a. Nicodemo jepa popa watsja judiopan jis lal. Fariseopan sin popa watsja jupj. Fariseopan jisastsja wa pjü lajay judiopan püna tapatja tjüjütütj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo Jesús nt'a tjac' püste na. Tjevele jupj lal: —Rabbí, cupj selecj Dios jin tjejyama qjuisin 'yüsa la mijin ncupj. Jipj pajal 'üsüs lejay, Dios liji jinwá lejay. Dios ma se con̈ca, ma polel lo jay pajal 'üsüsmpa jipj lejay jin. Mop'in ne nin p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús jupj wola tjevele: —Niswá jis tjamanun ca mpatjam Dios jyü'ta nt'a. Ma niswa jis tjamanun, ma polel jis la nuc Dios jyü'ta nt'a. T'üc' velé. ");
INSERT INTO jicNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo tjevele jupj lal: —Yom co'müy ma polel la 'osos jamay col mo'ó niswá, lo manun niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús jupj wola tjevele: —Pjü se jamanun la pjaní sejamay mpes. Dios jos ca jis ma'nucj niswá jupj Cjües mpes. Jupj Cjües liji ca Dios lal mpatjam. Nin mpes p'in 'ücj jis la winin jis la püt'üs Dios jyü'ta nt'a. T'üc' niná. ");
INSERT INTO jicNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Gente ts'uyupj gente p'in yupj. Ma polel patja Dios lal. Dios Cjües popa jis qjues wa yupj, jupj jinwá, mpes 'ücj mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","”Po ma nin jele t'as tsjan mpes nin velé Dios jos niswa 'i manunu jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dios Cjües nin liji. Jipj ma ca jus nucun Dios Cjües lijá. Ma ca jus nlayen jupj nin lijá. Nin p'in ca jus nucun 'üsüs tepyalá Dios Cjües la tjiji mpes. Nin lovin Dios ts'uyupj jis lal. Dios Cjües liji mpes yupj Dios ts'uyupj se palá. Dios Cjües ma si nuc, lüpjǘ jinwá. Lüpjǘ jun ta'á si lapjüna. 'Ücj pjoc', newa ma selen ca'ampe tjac' lüpjüs. Ma wa selen ca'aj jama. ");
INSERT INTO jicNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo tjevele jupj lal: —¿'Onin ca nin nacj, jipj velen jin? ");
INSERT INTO jicNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús la tji'yüya jupj lal: —¿Tsjan mpes ma jin 'yüsa napj velé? Israelpan sin 'yüsa lajay popa jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cupj way velecj, cupj selecj. T'üc' niná. Cupj velecj cupj tjinyucucj mpes. Newa nun ma quelel poné cupj tjevelecj. ");
INSERT INTO jicNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Napj tjeveletsja nosis nt'a pyalá, ne nun ma toponé. Napj cüvelé tsjun po'o pyalá, más ca costa way nsem cüponé nun. ");
INSERT INTO jicNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","”Len̈ pjacj ne'aj tjemey Dios pü'ü nt'a, 'ücj la veles nun lal 'oyn nyuca pyala ne'aj Dios pü'ü nt'a. Napj ne p'in tjacuwis nosis nt'a Dios pü'ü mpe. Napj p'iyá niná Yomen Dios jas tjejyamá. Mpes 'ücj velé 'oyn nyuca pyala Dios pü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","”Napj p'iyá niná Yomen Dios jas tjejyamá. Dios jos campanya ca nin müjünsücj, Moisés latsj jas tjijyünsa, tjevyala jinwá pajal püna. ");
INSERT INTO jicNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Napj lal japon lovin ca Dios lal mpatjam. Malala jis mpalas tulucj tecya'lin̈ na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tjevele wa: —Dios pajal quelel lis tjiji nosis casá patjá, mpes Jatjam jis tje'yaya. Dios pjaní Jatjam. P'a len̈. Mpes Dios Jatjam lal japon na, malala jis mpalas tulucj tecya'lin̈ na. Lovin ca mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nin mpes Dios jas tjejyama jupj Jatjam nosis nt'a. Dios jas tjejyama malala la tjajay la veles tulucj. Jas tjejyama jis capj la p'acj; jupj mpes 'ücj ca mpatjam Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","”Dios Jatjam lal japon, Dios ma nin vele jupj ca jis capj ntülüs yupj. Ma japon Dios Jatjam lal, nasa way Dios nin vele jupj ca jis capj ntülüs. Yupj ma topon Dios Jatjam 'ücj jis capj p'ya'sa, mpes nin. Dios Popa pjaní way jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","¿Ncu selen tsjan mpes Dios nin vele gente malala lajay? Napj jyawca jinwá nosis nt'a. Napj sin 'yüsa lejay t'üc' way Dios po'ó. Newa nin, yupj ma jisastsja napj. Yupj p'iyá malala nyuca yólatsja, ninana jisastsja yupj. Lovin malala nyuca lajaytsja, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Malala nyuca lajay ma jisas jyawca. Nin mpes yupj ma quelel japon napj lal. Ma quelel jus nlayecj yupj malala nyuca lajay. ");
INSERT INTO jicNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nin tulucj Dios vele jin lajay jis lal. Dios vele t'üc' way. Yupj japon napj lal. Yupj jisas la p'a ca sin mü'üsüs yupj la tjajay, Dios jos jin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Locopyaya Judea mo'o tjuwine Jesús jupj discipulopan jis lal. Ne'aj püs pǘ'ütsja jupj yupj jis lal. Ne'aj Jesús bautizar lis tjiji gentas. ");
INSERT INTO jicNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan pülücj bautizar lis tjiji wa Aenón nt'a, ne'aj way p'in Salim mo'ó. Pajal 'üsǘ püné ne'aj, mpes bautizar lis tjiji ne'aj jupj. Ne'aj pülücj tjiquil watsja lovin Juan nt'a. Jupj lovin bautizar líjitsja nepenowá. ");
INSERT INTO jicNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nin tepyala jepa Juan cawilta mo'o 'yonsa secj p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juan discipulopan judío p'a lal la veleltsja judiopan la tjajay po'ó. Nin tjowelepj yupj 'onin ne 'üsüs se palá gentá Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tjil, tjowelepj Juan lal Jesucristo po'ó: —Rabbí, jupj cyapj tecyon̈ca wa 'üsǘ na'aj po'ó, 'üsǘ Jordán ló nt'a. Jipj 'a 'ücj velen jupj mpes lovin. Quina ma qjuisas jupj lijá. Jupj bautizar la siji wa quinam jipj jinwá, ne pjü jil jupj nt'a. Jipj nt'a ma jiquil quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan jis wala tjevele: —Dios ma 'yaya, cjuwá nempe. Nin lovin. Nin mpes ca jus nlayé Jesús tya'á, Dios tje'yaya mpes tya'a jupj niná. ");
INSERT INTO jicNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nun p'iyá tjapja'aqué napj tjevelé, mpes solejé tsjan tjevelé napj. Tjevelé Dios tjevele ca jas majamas Yom pjaní judiopan nt'a. Jupj ca jis capj mp'a'sas. Nam 'a jupj tulucj. Dios nin tjejyama 'ücj la mejay jupj locopyaya jac' mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nin p'iyá judío woya na, jupj jats'om lal jac' na. Jupj jomica se p'a'sa jupj. Se con̈ca jupj, pjoca jupj velá. Jomica pajal 'ücj jos yom woya vele mpes. Nin p'iyá napj lal. Pajal 'ücj najas 'os quinam pülücj Jesús lal japon quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Más 'ücj Jesús más püné pyala jupj. Más 'ücj napj más tsjicj way ca ma palas quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","”Jupj tsjun mpe tjac', mpes jupj más püné pjü jilal. Napj nosis nt'a patja popa p'in. Nosis nt'a pyala 'ücj velé. Jupj tsjun mpe tjac', mpes más püné jupj pjü jilal. ");
INSERT INTO jicNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jupj vele la p'a jilal jupj tjinyucá, jupj tjapjacá nin vele jupj. Newa pjü ma quelel japon jupj velá. ");
INSERT INTO jicNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pjaní p'in topon jupj tjevelá. Japon Jesucristo velá, mpes p'a witjacj ca jus nlayecj yupj japon wa Dios t'üc' way vele lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios jas tjejyama Jesús. Jupj nin vele Dios velá. Mpes yupj japon na Jesús velá, japon wa Dios velá. Dios 'yaya jupj Cjües, pjü 'ücj la mijis jupj. Pues pjü way vele pjü 'ücj vele Dios Cjües se p'a'sa mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","”Dios jupj Popay. Popay pajal quelel liji Jatjam, ne pjü way tje'yaya Jatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dios Jatjam mpes japon, lovin ca mpatjam Dios lal. P'a witjacj ma lajay Dios Jatjam vele jin, mpes yupj ma ca mpatjam Dios lal. Dios ma jos yupj malala nyuca lajay. Jupj newa nin jola jupj ca jis capj ntülüs —nin tjevele Juan el Bautista Jesucristo po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseopan tjepjyacan̈ wa gente tjowelepj Jesús po'ó. Gente tjowelepj Jesús más pülücj sin 'yüsa líjitsja Juan lal. Más pülücj bautizar lis tjiji Juan lal, tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesús p'iyá ma bautizar lis tjiji yupj. Jupj discipulopan bautizar lis tjajay jupj mpes. Mop'in nin, más pülücj sa con̈tsja Jesús Juan lal.) ");
INSERT INTO jicNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Qjuis Jepa Jesús jus nleya fariseopan tjepjyacan̈ niná. Jus nleya na, tjemey jupj Judea mpe. Tjemey niswá Galilea po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Newa jámatsja na jümücj nt'a, Samaria la nipj jámatsja jümücj mpes jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne'aj Samaria mo'ó, jus tjevyanta pülücj patja nt'a ne'aj. Sicar lotsja pülücj patja nt'a. Po 'in ne'aj way p'intsja 'amá nt'a, 'amá niná Jacob tje'yaya jupj jatjam José pajal püna. ");
INSERT INTO jicNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne'aj 'üsǘ muju tón̈catsja, niná 'üsǘ muju ton̈ca Jacob juts'a'á watsja pajal püna. Jesús jas túlatsja campa tjuwine mpes, ne 'üsǘ muju la nt'a 'etjele jupj. Lots'ac' culupwen nt'a já'asatsja quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ne'aj quepj tjac' 'üsǘ lo pul. Samaria mpe 'eseptsja jupj. —'Üsǘ ma 'en, mü'üs —tjevele Jesús jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jesús discipulopan tjiltsja pülücj patja nt'a jaylacj jis la jay jis la las. Yupj len̈tsja ne'aj, mpes jupj 'üsǘ la tjemyona quepj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Quepj Samaria mpe 'eseptsja jupj, mpes jupj tjevele Jesús lal: —Judío jipj. ¿Tsjan pjucj le mon 'üsüs napj lal? Samaria mpe 'esepj napj. Judiopan sejamicapan tulucj cupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús tjevele jupj lal: —Jipj ma selen Dios 'yayá. Ma wa selen pjacj tjevele jipj lal: ‘'Üsǘ ma 'en, mü'üs’. Ma selen pjacj napj. Napj 'ücj 'e 'á 'üsǘ p'a wa, niná 'üsǘ mpes 'ücj cüpü'üm jipj. Napj lal le mon, mya 'a ca niná. Ma selen, mpes ma la tjemyon napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Quepj tjevele jupj lal: —Jim 'a cjuwá tsjan mpes cüpul 'üsüs. Niná 'üsǘ muju ton̈ca pajal campwila. ¿Ca'aj mpe mpulun 'üsǘ 'ücj lo püt'üs? ");
INSERT INTO jicNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob püna tüpü'ü, cupj ne jupj popa p'iyá locopyaya pyatjaquecj. Jupj tyoca niná, 'üsǘ muju ton̈cá. Jupj qjuis tje'yaya niná. 'Üsüs pajal. Jupj 'üsǘ tjümü'ü wa nina popé, jupj sin popa tjimyü'ün̈ wa qui'á, jupj cabro 'ots'ipj, jupj oveja 'ots'ipj. ¿Ncu más püné way jipj Jacob lal? ");
INSERT INTO jicNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús tjevele quepj lal: —'Üsǘ niná myü'ün̈, 'üsǘ jis mvas niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nin tulucj napj jis ma'ayá lal. 'Üsǘ tjimyü'ün̈ na, napj p'iyá jis ma'ayá, lovin ma ca 'üsǘ jis mvas niswá. 'Üsǘ napj se 'a, 'üsǘ 'amá popa pyacj jinwá nsem yupj jisas mo'ó. Lovin pyaca yupj jis qjues mpe, 'ücj jis la püt'üs la mijis lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Quepj tjevele jupj lal: —'Üsǘ que'e ma 'en niná popé, ne ca ma 'üsǘ mvas niswá. Ma ca qui'á ncuwis 'üsǘ lo pul. ");
INSERT INTO jicNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús tjevele jupj lal: —Jutja, tjevele ncuwim vyayum. Ncuwim jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Quepj jupj wola tjevele: —Mvayum tulucj. Jesús tjevele jupj lal: —Jipj t'üc' velen vyayum tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cínquiya vyayumpan waytsja jipj. Jipj püt' lal quinam, vyayum tulucj. Mpes jipj t'üc' tjevelen. ");
INSERT INTO jicNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Quepj jupj lal tjevele: —Quina napj jus nley profeta jipj. Jipj Dios mpes velen. ");
INSERT INTO jicNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Püna tapatja Dios cus tocon̈ witjacj Dios lal tjowelepj qui'á. Palá nipi'tjin̈ yupj Dios wolap'a'á qui'á, joc' niná mo'ó. Qui'á tjatja na, tjowelepj Dios pajal püné. Nun judiopan nin welé cupj ma polel nin lijicj quinam. Nun welé más 'ücj pjü gente Jerusalén nt'a jil, Dios lal la veles ne'aj. Nun welé más 'ücj Jerusalén nt'a p'in palá nipi'tjin̈ Dios wolap'a'á, más 'ücj ne'aj mal jis la veles Dios püné. ");
INSERT INTO jicNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús jupj lal tjevele: —'Ücj la pon napj velé. P'a jyawca na, gente jun ta'á palá mpi'tjin̈ Dios wolap'a'á, yupj patja nt'a. Ca mvelecj Dios pajal püné, joc' niná nt'a p'in tulucj, Jerusalén nt'a p'in tulucj wa. ");
INSERT INTO jicNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nun Samaria mo'o potjaqué palá pwi'tjiqué wa Dios wolap'a'á, newa ma solejé nun 'oyn nyuca liji jupj. Nin tulucj cupj qjuis lal. Cupj judiopan, cupj palá nipi'tjiquecj wa Dios wolap'a'á, mop'in nin, cupj selecj 'oyn nyuca liji jupj. Dios ca la mijis gente 'ücj ca mpatjam jupj lal. Judiopan popa mpes nin liji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mop'in p'a casá ca nsem p'a jawas. P'a jawas Dios quelel lajay 'ücj ca palá mpi'tjin̈ Dios wolap'a'á jupj Cjües mpes. Jun ta'á, yupj patja nt'a, 'ücj ca nsem. 'Ücj ca mvelecj Dios pajal püné jupj Cjües mpes. Jupj Cjües sin 'yüsa liji t'üc' way Dios po'ó, mpes 'ücj quelel lajay jupj. Qjuis Papay Dios jos nin jina lajay quelel lajay jupj. Nin ca nsem p'a jawas. Nasa way nin tepyala quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cjües way Dios. Dios Cjües mpes p'in gente 'ücj palá mpi'tjin̈ Dios wolap'a'á. Dios Cjües mpes p'in 'ücj yola Dios püné. Dios Cjües sin 'yüsa la siji t'üc' way Dios po'ó, mpes 'ücj quelel lajay jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Quepj tjevele jupj lal: —Napj selé Dios ca jas majamas Jepa Püné cupj nt'a. Jupj ca qjuis capj mp'a'sas. (Cristo ló jupj cupj qjuilal.) Jac' na, jupj ca 'üsüs qjuisin mü'üsüs la mijis pjü way. ");
INSERT INTO jicNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús tjevele jupj lal: —Niná pjacj lal velen, napj mp'iyá niná. ");
INSERT INTO jicNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesús nin tjevele na, jupj discipulopan tjiquil. Pajal nin yólatsja tsjan mpes quepj lal véletsja jupj. Newa ma la tjü'üy tsjan mpes nin la tjiji. Ma la tjü'üy tsjan mpes tjevele quepj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Len̈ way tjemey quepan. Jupj jarro já'asa tjemey. Tjemey pülücj patja nt'a. Tjevele ne'aj tapatja jis lal: ");
INSERT INTO jicNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Nculá nun. Jus nucú ca niná yomen. Jupj nawala tjevele pjü way napj la tjejay. Jupj ne ‘Cristo’ ca nacj. Dios jas tjejyama nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mpes ne'aj tapatja jis wa nepé tjil. Jesús nt'a jiltsja. ");
INSERT INTO jicNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gente jiquiltsja na, Jesús discipulopan jupj lal la tjomon nlajas: —Rabbí, nlajan jipj —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma quelel lyájatsja jupj quinam. Jupj tjevele yupj jis lal: —Nun ma solejé 'onin niná, napj lya popé. ");
INSERT INTO jicNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jupj nin tjevele mpes discipulopan yuwá jis la tjü'üy ncu ne'aj patja sin popa teque'e, tje'yaya jupj la las. ");
INSERT INTO jicNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yupj ma sin tji'yüsa, mpes Jesús 'üsüs tjevele yupj jis lal: —Dios nin tjejyama nosis nt'a. Pjü Dios jos, pjü way quelel t'üc' lejay napj —tjevele jupj—. Napj tsji' lejay jupj mpes, quelel t'üc' lejay niná. Niná lejay pajal 'üsüs napj lal, ve lya jinwá napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nun welé mes yulupjana newa custjay, vyala mpes. Napj velé nin tulucj napj vyala lal. Gente napj jisin jinwá. Yupj topon napj jis capj p'yacj 'ücj jis la püt'üs Dios lal, yupj napj jisin popa vyala jinwá. Tjunuca nun gentas. Tjevyala nasa tji'yǘ jinwá yupj. Yupj nasa quelel japon. ");
INSERT INTO jicNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nun sin 'yüsa lojí na napj nin po'ó, yupj nepénowa ca mponecj. Nin lojí na, vyala co'á jinwá lojí napj mpes. Niná lojí na, nta'é ca nun, nun la tjüjí mpes. Dios ca la mijis wa yupj lovin ca mpatjam jupj lal yupj topon mpes. ”Namozopan jasin jinwá lajay neneyawá. Vyala jacutj jinwá lajay neneyawá. Namozo pjaní mwalá way jis lal vele Dios tjevelá, seyasa jin yola jupj tjevelá. Ma quelel japon custjay. Namozo setel sine jinwá la tjiji. P'a jawas p'a wa vele yupj jis lal Dios tjevelá, mpes yupj japon. Manas tjowelepj mpes topon. Manas ca 'ücj jisas nsem yupj topon mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nepénowa nin javelepj: ‘Pjaní sine, locopyá vyalaná’. Niná t'üc' way nun lal quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Napj nusin tjejyam la p'a jis lal la veles napj mpes. Nepénowa ca mponecj, mpes lovin ca mpatjam Dios lal. Püna ma sin 'yüsa lis tjüjí nun. La p'a sin 'yüsa lajaytsja. La p'a lajaytsja, nun cyawaja lojí quinam —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria po'o tapatja sin popa pülücj topon Jesús lal, yupj ne pülücj patja mpe ne'espan p'iyá. Quepj tjevele Jesús tjevelá, mpes topon yupj. Quepj tjevele: —Jupj nawala tjevele pjü way napj la tjejay. ");
INSERT INTO jicNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mpes Samaria po'o tapatja Jesús nt'a tjiquil na, Jesús lal la tjomon la 'osos tsjicj way yupj jis lal. Mpes ts'ac' mat'e ne'aj tüpü'ü yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesús tjevele mpes wa más pülücj topon yupj. Nin tepyala pajal pülücj topon quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mpes yupj quepj lal tjowelepj: —Jipj velen mpes tulucj pyonecj quinam. Cupj p'iyá tjepjya'aquecj jupj tjevelá, mpes selecj t'üc' way jupj ca nin la mijis gente 'ücj ca mpatjam Dios lal —nin tjowelepj Samaria po'o tapatja Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","T'üc' ts'ac' mat'e na, Jesús tjemey niswá. Galilea mo'o wínetsja. ");
INSERT INTO jicNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jesús seletsja Galilea mo'o patjá ma ca quelel la mijicj jupj, mpes jupj p'iyá véletsja: “Profeta pü'ü nt'a ma quelel japon jupj pajal 'üsüs”.) ");
INSERT INTO jicNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jus tjevyanta na Galilea mo'ó, Galilea mo'o tapatja 'ücj jisastsja jupj tjac' mpes. Galilea mo'o tapatja tjil wa nawaja'a Jerusalén mo'ó. Fiesta nt'a tjil yupj, mpes tjunuc wa pjü way pajal 'üsüs la tjiji Jesús fiesta nt'a. Nin mpes 'ücj jisastsja yupj Jesús tjac' quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Newa Galilea mo'ó p'in, Caná ne'as tjemey Jesús niswá. Pülücj patja ne'aj. Püna pajal 'üsüs la tjiji ne'aj. 'Üsǘ p'in uva 'üsǘ tepyala la tjiji Jesús ne'aj. Ne'aj way p'in pǘ'ütsja jepa auxiliar, Capernaum nt'a. Jupj jatjam pajal malala jostsja. ");
INSERT INTO jicNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","La p'a wa tjowelepj auxiliar niná lal Jesús nasa tjac' Judea nepé, niswá tjac' Galilea mo'ó. Niná jus nleya na, tjemey Jesús nt'a. Pajal la tjemyona lo cuwis Jesús, lo 'ü'süs lo jay jatjam. Jatjam nasa way pé'etsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús tjevele jupj lal: —Napj pajal 'üsüs lejay, yom p'in ma polel liji jinwá. Nin lejay nusin 'yüsa la mejay Dios nin tjejyama napj. Ma nucú niná lejay, lovin ma cüponé napj lal. Malala nin. ");
INSERT INTO jicNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Auxiliar tjevele jupj lal: —Len̈ way was. Najas 'üsüs la mijin, ne ca ma mpa'is natjam tsjicj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús tjevele auxiliar lal: —'Ücj la winin quinam. Jetjam ca mpü'üm ca nsem. Yom tepyona Jesús tjevelá, mpes wo nt'a tjemey yomen. ");
INSERT INTO jicNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Newa ne'aj jámatsja custjay, jomozopan tjiquil la nyüjüsün̈. Jupj lal tjowelepj: —Ma tepe'e jetjam. 'Ücj já'asa quinam jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mpes auxiliar jis la tji'yüya yupj 'ona tji'yü'sa. Yupj tjowelepj jupj lal: —T'an̈ t'awaná, la una na tji'yü'sa si 'awa. ");
INSERT INTO jicNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsjicj popay jus nléyatsja t'an̈ la una na p'in, Jesús tjevele jupj lal: “Jetjam ca mpü'üm ca nsem”. Nin mpes auxiliar tepyona Jesús Yom niná Dios tjevele ca jas majamas jis capj la p'acj judiopan. Nin p'iyá topon wa pjü way auxiliar wo nt'a tapatjá. ");
INSERT INTO jicNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ninana Jesús la tjijá Galilea nt'a, Judea mpe tjac' na. Pajal 'üsüs la tjiji, sin tji'yüsa lis tjiji Dios jas tjejyama jupj. La miyá quinam pajal 'üsüs la tjiji Jesús Galilea mo'ó, gente p'in ma polel lajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Locopyaya p'a wa fiesta la tjajay judiopan. Jesús viyavin tjemey Jerusalén nt'a fiesta mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén nt'a 'üsǘ muju ton̈ca jis la 'as'üs. Pajal la püné, campwílatsja jupj. Judiopan jis tin “Betesda” ló niná 'üsǘ. Ne'aj way p'in jun vilicj püné oveja mpe wama jil Jerusalén mo'ó. 'Üsǘ muju ton̈ca t'asiyú cinco corredor witjacj lejen̈tsja. ");
INSERT INTO jicNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tsjojoca nt'a malala jisas pülücj tapatja ne'aj. Nepénowa yun tuluctsja, nepénowa ma polel jiltsja, nepénowa ma polel 'yutanan̈tsja. Yupj pjü way la tjunuc 'üsǘ lo pjets'epjets'e 'üsǘ muju ton̈ca mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ángel pjaní Dios mpe tjac' neneyawá, 'üsǘ muju ton̈ca nt'a tjemey, lo pjets'epjets'e la tjiji 'üsüs. Niná la tjiji na, malala jos pjaní way tji'yü'sa jupj. Mwalá way 'üsǘ mo'o tjemey, niná p'in tji'yü'sa. Pjü way malala jisas 'ücj jis tji'yü'sa 'üsǘ niná mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yom pjaní ne'aj tüpü'ü, año pülücj malala jostsja jupj. Año treinta y ocho nas malala jostsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús jus tjinyuca, jus nleya yom niná pajal püs ne'aj tüpü'ü jupj, malala jos. Mpes la tji'yüya jupj lal: —¿Ncu quelel 'i 'ü'sa jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yom malala jos lal tjevele Jesús lal: —Len̈ pjacj ncapj cüp'acj 'üsǘ mo'o mis. Nin mpes 'üsǘ lo pjets'epjets'e na, newa nasapj jum 'üsüs mo'ó. Newa jum, p'a wa mo'o jama mwalá way p'in napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús tjevele malala jos lal: —¡Jin ni'isa jipj! Nt'ya nt'an jipj cobija. Mwinim ca. ");
INSERT INTO jicNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Len̈ way tji'yü'sa niná yomen. Jupj nt'ya jupj cobija, tjemey jupj. Sábado waytsja nin jawas, judiopan ma tsji' lajay jawastsja. ");
INSERT INTO jicNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mpes judiopan jis jepapan tjowelepj yomen tji'yü'sa lal: —Sábado yacjampa, ts'ac' niná ma tsji' lijicj jawas. Ma polel lya t'as jipj cobija. ");
INSERT INTO jicNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jupj jis lal tjevele: —Yomen ntji'ü'sa la tjiji tjevele napj lal: ‘Nt'ya nt'an jipj cobija. Mwinim ca.’ ");
INSERT INTO jicNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yupj la tjü'üy jupj: —¿Pjacj yomen lyal tjevele jipj ca nt'an jipj cobija, ca mwinim? ");
INSERT INTO jicNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yomen ma seletsja pjacj tji'yü'sa la tjiji jupj. Len̈tsja quinam Jesús. Pülücj játjatsja ne'aj, ne Jesús yupj culupwen nipj tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yacjaya Jesús la nüjüsü yomen Dios wo nt'a. Jesús tjevele jupj lal: —Nin jele t'as nin mpes: 'i tjü'ü'sa jipj quinam. Po ma newa malala la mijin quinam jipj. Jipj newa malala nyuca lejay, más malala ca mya palas jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tjemey yomen judiopan jis jepapan nt'a. Tjevele yupj jis lal tji'yü'sa la tjijá, Jesús waytsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Judiopan jis jepapan pajal ts'a 'intsja Jesús 'yü'sa líjitsja sábado na, nin jawas judiopan ma tsji' lajay. Nin mpes quelel malala lajaytsja Jesús lal. Lovin malala lajaytsja jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús yupj jis lal tjevele malala tulucj sábado na tji'yü'sa la tjiji. Tjevele: —Mpapay newa tsji' liji. Napj 'a newa tsji' lejay wa jupj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Niná tjevele mpes, judiopan jis jepapan po quelel ja'ünantsja Jesús. Más nin yólatsja quinam ca nin la mijicj. Jesús tji'yü'sa la tjiji sábado na, nin jawas yupj jajütütj ma ca tsji' la mijicj judiopan. Niná po 'in malálatsja yupj jis lal. Jupj tjevele wa Dios jupj Popay, mpes wa ts'a tji'in. Jupj tjevele mpes quelel véletsja jupj p'iyá püné jupj Popay Dios jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yupj malala yólatsja mpes, Jesús tjevele yupj jis lal. Ninana tjevelá: “Napj lejay ma polel la cüjay nasapmpa, napj p'iyá quelel lejay mpes p'in. Napj Dios Jatjam. Napj nyuc Mpapay lijá, nin p'in 'ücj wa lejay napj. Napj nin p'iyá lejay Mpapay liji jinwá. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mpapay quelel la niji. Pjü jupj p'iyá lijá, jupj nin 'yüsa liji tsjan niná jupj lijá. Nasa pajal 'üsüs la tjiji jupj pajal püné mpes. Más 'üsüs ca la mijis jupj p'a jawasiyá. Nin liji na, ca nin mü'üsüs wa la mijis niná, ne nin ca la mejay napj. Nin ca la mijis jupj, mpes nun nujola mpalas ma nusin 'yüsa 'onin ne nin lejay napj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mpapay sin jyünsa tecya'lin̈, mpatjam liji jupj. Nin p'iyá lejay napj; napj patja la sejay napj najas mpatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mpapay ntje'aya wa 'ücj la veles pjü mpes pjacj ne 'üsüs nyuca la tjajay, pjacj ne malala nyuca la tjajay. Mpapay p'iyá ma ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mpapay jos pjü pajal 'üsüs pjac javelepj napj mpes, jupj mpes 'üsüs javelepj jinwá. Nin mpes ne 'aya nin lejay napj. Ma 'üsüs pjac javelepj napj mpes, nin p'iyá ma wa 'üsüs pjac javelepj jupj mpes. Jupj nin tjejyama, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”Nepénowa napj velé jin lajay, japon wa nin tjejyama lal. Ninana lajay, nasa way patja yupj, ne lovin ca mpatjam yupj Dios lal. Lovin ma ca mvelé malala nyuca la tjajay yupj. Püna tecya'lin̈ jinwatsja Dios lal. P'a casá way quinam, jupj lal topon mpes. Lovin ca Dios lal mpatjam. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Dios lal ma japon, tecya'lin̈ jinwá yupj quinam. P'a jyawca na, yupj ca mpjacan̈ napj velé. Yupj sin popa nepenowá ca la mijicj napj velé jinwá. Napj velé jin lajay, mpatjam ca yupj lovin. Nin ca nsem p'a jawas. Nasa way nin tepyala quinam. Napj Dios Jatjam. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","”Mpapay 'ücj liji p'a wa lo püt'üs. Nin p'iyá ntje'aya napj 'ücj wa lejay la p'a lo püt'üs. ");
INSERT INTO jicNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jupj ntje'aya 'ücj la veles gente po'ó pjacj ne 'üsüs nyuca la tjajay, pjacj ne malala nyuca la tjajay. Napj 'a yom, gente popa p'iyá, mpes ntje'aya 'ücj nin lejay napj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Po ma nusey c'a t'as nun nin mpes. P'a jawas pjü tecya'lin̈, toc patja witjacj, ca mpjacan̈ napj velé. ");
INSERT INTO jicNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tjepjyacan̈ na, pje'á ncul ca yupj. 'Üsüs way la tjajay sin müjünsücj, ca mpatjam niswá. Malala nyuca la tjajay sin müjünsücj wa ca, mop'in malala ca jis mpalas yupj. Napj ca mvelé t'üc' way malala nyuca la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”Napj lejay, ma polel la cüjay nasapj, napj p'iyá quelel lejay mpes p'in. Mpapay vele napj lal, niná napj nin velé p'in. Jupj jola jin velé ncu gente malala nyuca la tjajay. Nin mpes napj velé yupj po'ó t'üc' way. Napj ma quelel lejay napj quelel le jaympa p'in. Napj quelel lejay jupj jos jin. Nin tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Napj nasapj cüwelé nun lal napj selé napj p'iyá po'ó, ma ca polel jus cülayé ncu t'üc' way niná napj velé. ");
INSERT INTO jicNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma nasapj napj. P'a vele wa jupj selé napj nin po'ó. Napj selé jupj vele napj po'ó, t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","”Juan niná napj nin velé po'ó. Nun p'iyá niyom sin tjajamá jis la veles Juan lal. Jupj seletsja mpes t'üc' way tjevele napj nin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Napj ma nin nola ncu gente p'in javelepj Dios nin tjejyama. Napj najas nun ca mponé napj lal. Najas ca Dios lal mpatjaqué. Nin mpes nin tjevelé Juan 'üsüs tjevele napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan pajal 'üsüs nusin tji'yüsa lis tjiji Dios po'ó. Jupj jyawca jinwatsja nun lal. 'Iyó je su müjǘ 'ücj la nuc. Nin p'iyá jupj tjevele mpes 'ücj nusin tji'yüsa Dios po'ó. Tsjicj way mpes 'ücj nujisastsja pajal, jupj nusin tji'yüsa la tjiji mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","”Juan 'üsüs tjevele jupj seletsja napj nin po'ó. Pjaní waytsja jupj. P'a mpes wa nun ca jus nlayé Dios nin tjejyama. Niná más 'üsüs Juan vele lal. Niná napj pajal 'üsüs lejay Mpapay mpes. Jupj ntje'aya napj ca t'üc' la mejay, niná p'iyá lejay napj. Nin mpes wa nun ca jus nlayé Mpapay nin tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","”Mpapay tjevele wa napj mpes jupj selé mpes. Nin tjejyama jupj. Newa ma tjapja'aqué jupj tjevelá. Ma wa tjunucú jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma wa nujos jupj tjevelá. Nun ma quelel lojí jupj tjevelá. Nin tjejyama jupj, newa ma poné napj t'üc' velé. ");
INSERT INTO jicNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nun nujola Dios Popel nusin 'yüsa liji 'onin ne 'ücj la püt'üs Dios lal lovin. Nin mpes tülü way mo'o welé Dios Popel. Nun quelel nusin 'yüsa Dios tjevelá. T'üc' way Dios Popel p'iyá vele napj nin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Newa nin, nun ma quelel poné napj lal. Nun ma quelel poné napj polel nucopj p'yacj, 'ücj nu la püt'üs Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”Ma nin nola gente p'in javelepj mpes napj nin po'ó. Ma nin nola ncu 'üsüs pjac javelepj napj nin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nin p'in, napj selé nun ma t'üc' way quelel lojí Dios. Napj nujus nyuc, mpes selé napj niná. ");
INSERT INTO jicNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Napj qui'á tjacuwis Mpapay qui'á nin tjejyama mpes. Newa nin, nun 'ücj jisas tulucj napj tjacuwis. P'a wa jupj sin nin 'ucuy, nun ca 'ücj jisas nsem jupj tjac'. ");
INSERT INTO jicNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","”Nun ma polel poné napj lal. Nun po jisas p'a wa nun popa javelepj nun pajal 'üsüs. Nun ma nin nujola Dios ma nin vele nun 'üsüs. Dios pjaní jupj, más püné jupj pjü jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Napj p'iyá ma ca malala mvelé nun po'ó Mpapay wolap'a'á. Ma nin nujola t'as. Dios Popel Moisés tepyacá malala mveles ca nun po'ó. Nun nujola nun lojí Moisés tjijyü'tá, ca 'üsüs nu mpalas. ");
INSERT INTO jicNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jupj tepyaca wa napj mpes. Nun cüponé Moisés tepyacá, cüponé catsja napj t'üc' tjevelé wa. Mpes jupj popel ca mveles nun malala nyuca la tjüjí. ");
INSERT INTO jicNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nun ma poné jupj tepyacá, mpes ma wa ca mponé napj velé”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Locopyaya 'üsǘ na'aj po'o tjemey Jesús. 'Üsǘ niná pajal la pünetsja, pajal campwílatsja. Galilea lotsja. Tiberias lotsja wa jupj. Mát'eya ló. ");
INSERT INTO jicNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pajal pülücj sa con̈tsja Jesús ne'aj. Tjunuc pajal 'üsüs la tjiji Jesús, jupj malala jisas jis tji'yü'sa lis tjiji na. Jupj la tjiji mpes ca jus cülayecj Dios jas tjejyama jupj. Nin mpes sa con̈tsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús neven popa viyavin tjemey. 'Etjele jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Len̈ way pyálatsja judiopan jis fiesta. “Dios Qjuis Capa Nipj Tjemey” lotsja fiesta niná. ");
INSERT INTO jicNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús jay viyá nt'ya, yus tjinyuca. Tjinyuca pajal pülücj jiquiltsja jupj nt'a. La tji'yüya Felipe lal: —¿'Onin la qjuijim jaylacj la qjuijim pansas, pjü jis la las? ");
INSERT INTO jicNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús quelel nyúcatsja tsjan la veles Felipá, mpes nin la tji'yüya jupj lal. Jupj p'iyá seletsja tsjan la mijis. ");
INSERT INTO jicNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe jupj lal tjevele: —Mes ocho tsji' lejay jaylacj, ma t'üc' t'emel nsem pan jaylacj la qjuijicj, pjü tsjicj way jis la las. ");
INSERT INTO jicNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","P'a discípulo ne'aj já'asatsja, Andrés lotsja jupj. Andrés Simón Pedro tsüípetsja jupj. Jupj tjevele Jesús lal: ");
INSERT INTO jicNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Qui'á já'asa wa yom tsjicj. Pan cebada cínquiya tya'a jupj. Cjul mát'eya tya'a wa jupj. Newa cjuwá pjü jis la las. Nenem 'a pjaní way. ");
INSERT INTO jicNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús tjevele: —Pjü jis tjüjü'tǘ majatjum yupj. Tsjutsj pülücj lejen̈tsja ne'aj, pajal 'üsüs la 'osostsja ne'aj. Mpes niyom 'atjalapj ne'aj. Pajal pülüctsja yupj, cinco mílyatsja yupj. Más 'in la' way ca nacj, más 'in pülücj way ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús nt'ya pansas, tjevele Dios lal tjüwüi'i pan tje'yaya mpes. T'üc' tjevele na, pan jis tje'yaya pjü. Pjü tjalá. Nin p'iyá la tjiji cjulun lal. Yupj jisas nas tjalá. Pajal jis col tipit'a. ");
INSERT INTO jicNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pjü t'üc' tjalá na, jis col pit'a na, Jesús tjevele jupj discipulopan jis lal: —Ma polel pjü tjalá yupj. Pan newa jatja no'oté nun. Na'aj mo'onsó, ma ca na'aj la nts'iyá pansas sin popé. ");
INSERT INTO jicNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mpes yupj natj pansas tsjictjacj. Pan cebada cinco popé quiliyú dóceya tipit'a pan lal, ma pjü tjalá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gente ne'aj tjatja tjunuc nin tepyalá. Jesús pajal 'üsüs la tjiji yom p'in ma polel liji jinwá, mpes sin tji'yüsa lis tjiji Dios jas tjejyama jupj. Tjunuc mpes javeleptsja: “T'üc' way jupj profeta niná Moisés tjevele ca ncuwim nosis nt'a”. ");
INSERT INTO jicNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús jus nleya yupj quelel jiquiltsja, quelel tji'lin̈tsja jupj, ca jepa mpalas jupj. Ma jostsja jupj. Mpes niswa neven popa viyavin tjemey jusapj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yacjaya discipulopan palavin tjiquil 'üsǘ püné la nt'a. Nasa way t'yájatsja. ");
INSERT INTO jicNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Barco wama tjil, 'üsǘ na'aj po'ó jis la winin quinam. Capernaum nt'a jiltsja yupj. Pǘstetsja quinam, newá ma tjac' Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lüpjǘ püné la tjelyapjünǘ, mpes pajal la tjepjetpjets'é 'üsǘ. ");
INSERT INTO jicNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Legua pjaní tjil na 'üsǘ casa'á, jus tjunuc Jesús. 'Üsǘ casá wínetsja, ne'aj way p'in jactsja barco nt'a. Pajal lacj tjeyaptsja discipulopan. Ma salejeptsja Jesús jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Napj ne p'in winis. Po ma locj tjeyá nun”, tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tjevele na, 'üctsja yupj jis lal jupj barco wama la winin yupj jis lal. Barco wama tjemey na, len̈ way ne'as tjil, yupj quelel jiltsja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yaya gente pülücj newa játjatsja 'üsǘ la nt'a, Jesús jis tje'yaya tjalá nt'a. Ma tjil yupj 'üsǘ na'aj po'ó Jesús discipulopan jis lal. Yupj jus nlay barco pjaní way p'in 'üsǘ la nt'a já'asatsja t'an̈. Discipulopan tjil 'üsǘ na'aj po'ó niná barco mo'ó. Salejeptsja Jesús ma wama tjemey barco mo'ó discipulopan jis lal. Yusapj tjil discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Püstapj len̈tsja barcas. Locopyaya barco tsjictjacj nepénowa tjiquil Tiberias mpe. Ne'aj p'in tjiquil niná gente pülücj tjatja nt'a, ne'aj p'intsja qjuis Jepa Jesús pan jis tje'yaya tjalá nt'a. (T'an̈ p'in pan nt'ya, tjevele Dios lal tjüwüi'i pan mpes. Jis tje'yaya, tjalá yupj.) ");
INSERT INTO jicNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yupj jus nlay Jesús len̈ yacjaj, jupj discipulopan len̈ watsja. Jus nlay na, barco wama tjil, 'üsǘ na'aj po'ó jis la winin. Capernaum mo'o tjil jis la pal Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jus tjunuc 'üsǘ na'aj po'ó. Jus tjunuc na, tjowelepj jupj lal: —Rabbí, ¿'ona tjacuy qui'á? ");
INSERT INTO jicNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús jis lal tjevele: —Nun pülücj tjalajá pansas, mpes la no palá. Nun jis col pit'a nas tjalá, mpes p'in. T'üc' way niná. La no palá 'üsüs la tjejay mpes tulucj. Nun ma nusin 'yüsa tsjan mpes pajal 'üsüs lejay, yom p'in ma polel liji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nun pajal nujola ve mpes. Po ma nin nujola t'as ve mpes. Ve newa malala pyala. Nin nujola t'as tsjan ma cyawaja mpes. Nun Dios lal cüpatjaqué lovin, newa ma ca 'acawajas niná napj nu 'ya. Napj p'iyá niná Yomen Dios jas tjejyamá. Mpapay Dios nusin tji'yüsa la tjiji t'üc' way jupj nin tjejyama —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mpes yupj la tjü'üy jupj lal: —¿Tsjan jos Dios cupj lijicj, ne jupj ca 'ücj jos nsem cupj lijicj mpes? ");
INSERT INTO jicNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús tjevele yupj jis lal: —Dios jos nun newa poné napj lal. Ninana Dios jos nun lojí. Jupj nin tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mpes jupj lal tjowelepj yupj: —¿Tsjan lejay jipj qjuisin la 'üsüs lejay Dios jin tjejyamá? Cupj cünucucj pajal 'üsüs lejay, yom p'in ma polel liji jinwá, ca cüponecj jipj velen. ¿Tsjan ca la mijin jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Judiopan püna tapatja maná jalá jiltsja wosis cjuwá nt'a lyawun̈tsja na püná. Nin mpes Dios Popel vele: ‘Ve jis tje'yaya jis la las Dios pü'ü mpe’. ");
INSERT INTO jicNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús yupj jis lal tjevele: —Moisés tulucj ve nu tje'yaya Dios pü'ü mpe. Mpapay p'in ve t'üc' way nu 'yaya jupj pü'ü mpe. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ve Dios nu 'yayá, Dios pü'ü mpe jac'. Ve niná nin liji gente 'ücj ca mpatjam lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yupj tjowelepj Jesús lal: —Lovin qjuis ma'ayan ncupj ve niná. ");
INSERT INTO jicNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús tjevele yupj jis lal: —Napj p'iyá ve niná. Napj p'iyá nin lejay gente lovin ca 'ücj mpatjam. Ncapj jacon̈ pjü ca nta'acj 'ücj jis la püt'üs Dios lal. Lovin ma vecj cya'lin̈ jinwá ca nsem yupj jis lal. Nin lovin napj lal japon jis lal. Lovin ma 'üsǘ sive jinwá ca nsem yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mop'in nun ma poné. Napj nasa tjevelé niná nun jis lal. Nun nus tjunucú, newa ma poné napj polel nucopj p'yacj 'ücj nu la püt'üs Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","”Mpapay ne 'aya gente nepenowá, yupj ca ncapj ncon̈cocj. Yupj pjü way ca mponecj napj lal. Napj lovin ma ca pje'á lis nts'i napj lal japon witjacj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Napj Dios pü'ü mpe tjacuwis nin la mejay Mpapay jos jin. Nin tjejyama jupj. Napj p'iyá najas jin lejay mpes tjacuwis tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mpapay Dios nin tjejyama. Jupj jos napj ca 'ücj la mejay ma ca len̈ cüvalas jupj ntje'ayá sin popé. Jupj jos pjü yupj sin jyünsǘ la mejay p'a jawas tecya'lin̈ sin müjünsücj na, ne ca niswa mpatjam yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nin jos Mpapay. Nepénowa japon napj ne Dios Jatjam. Japon wa napj mpes ca mpatjam Dios lal. Mpapay jos pjü yupj ca jupj lal mpatjam lovin. Napj p'iyá ca sin müjünsǘ nin jawas tecya'lin̈ sin müjünsücj na —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judiopan sin popé yuwá jas tjowelepj jupj, jupj tjevele mpes. Jupj tjevele: “Napj p'iyá ve niná. Napj tjacuwis Dios pü'ü mpe.” Ma jisastsja niná tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yupj javeleptsja: “Niná Jesús, José jatjam. Selecj pjacj jupj popay, jupj jamay. ¿Tsjan mpes nin vele quinam, Dios pü'ü mpe tjac' jupj?” ");
INSERT INTO jicNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yupj nin javeleptsja mpes, Jesús tjevele yupj jis lal: —Po ma nin tjowelé nunwá niná quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gente yusapj ma polel japon napj lal. Mpapay liji yupj 'ücj ca quelel mponecj. Napj ca sin müjünsǘ mpatjam yupj niswá. Nin ca mpalas nin jawas tecya'lin̈ sin müjünsücj na. Nin tjejyama Mpapay. ");
INSERT INTO jicNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profetapan tjowelepj: ‘Dios ca sin mü'üsüs lis mijis pjü jupj ts'uyupj’. Nin tapac profetapan Dios Popel mo'ó. Gente nepénowa pjyacan̈ Mpapay velá, sin 'yüsa wa jupj velá. Pjü way yupj ca mponecj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","”Ma quelel velé yupj jus tjunuc Mpapay Dios, yun lal. Napj p'in jus tjinyuc jupj. Jupj nepé way tjacuwis. ");
INSERT INTO jicNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Napj lal japon, Dios lal patja lovin. T'üc' way velé. ");
INSERT INTO jicNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Napj p'iyá niná ves. Napj p'iyá nin lejay gente lovin ca 'ücj mpatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","”Judiopan püna tapatja maná jalá jiltsja wosis cjuwá nt'a püná. Maná ma 'ücj la tjiji jis la püt'üs lovin. Tecya'lin̈ wa yupj, pjü gente cya'lin̈ jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ve niná napj velé mpes, más 'üsüs liji maná lal. Ve niná Dios pü'ü mpe jac'. Ve niná jalá, lovin ma ca nca'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Napj p'iyá ve niná, ve nyucunú jinwá napj. Napj Dios pü'ü mpe tjacuwis. Ve niná jalá, ca mpatjam lovin. Ve niná napj mp'üy. Ma pats' ca napj, gente 'ücj ca mpatjam Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judiopan ts'a tji'in Jesús nin tjevele mpes. La veleltsja yuwá. Javeleptsja: “¿'Oyn la qjuijis yom niná, jupj jüp'üy cü'es cülá ncupj?” ");
INSERT INTO jicNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús tjevele yupj jis lal: —Napj p'iyá niná Yomen Dios jas tjejyamá. Napj mp'üy lojá jinwá lojí tulucj, ma t'üc' way potjaqué nun. Nin p'iyá, napj na'as müsiqué jinwá lojí tulucj, ma t'üc' way potjaqué. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","”Nepénowa mp'üy jalá jinwá lajay, na'as myü'ün̈ jinwá lajay wa. Ninana lajay lovin ca mpatjam Dios lal. P'a jawas tecya'lin̈ sin müjünsücj na, nin jawas napj ca sin müjünsǘ yupj jis p'üy, mpes ca mpatjam lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Napj mp'üy ve t'üc' way jinwá. Nin lejay gente 'ücj jis la püt'üs. Nin mpes wa na'as 'ücj lo müs jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nin mpes nin velé mp'üy jalá jinwá lajay sin po'ó, na'as myü'ün̈ jinwá lajay sin po'ó wa. Ninana lajay newa ncapj jacon̈ lovin. Napj pü'üs wa yupj jisas mo'ó lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mpapay lovin pü'ü. Jupj jusapj 'ücj pü'ü. Nin tjejyama jupj, ne napj pü'üs wa jupj mpes. Nin p'iyá niná. Nepénowa pajal japon napj lal, napj 'ücj jis capj p'yacj pjü way mpes. Napj mpes ca mpatjam yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Napj p'iyá ve niná, ve niná Dios mpe tjac'. Napj maná jin tulucj. Más 'in 'üsüs napj maná lal. Judiopan püna tapatja maná jalatsja. Yupj tecya'lin̈ wa, gente janmacj cya'lin̈ jinwá. Nin tulucj ca nsem napj lal japon jis lal. Pajal japon napj lal, napj 'ücj jis capj p'yacj pjü way mpes, lovin ca mpatjam yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ninana Jesús tjevele Capernaum mo'ó, sin tji'yüsa lis tjiji na. Ne'aj sin tji'yüsa lis tjiji jis wa nt'a, judiopan 'a si mulú nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesús discipulopan pülücj ma jisastsja jupj tjevelá. Tjepjyacan̈ na jupj tjevelá, yupj tjowelepj: “Jupj tjevelá pajal malala cupj qjuilal. Ma polel qjuis la pon jupj velá. Ma qjuiyola t'as ncupj niná.” ");
INSERT INTO jicNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús seletsja yupj malala po'o tjowelepj jupj tjevele mpes. P'a wa ma Jesús wola tjevele; jupj seletsja p'in. Mpes jupj la tji'yüya yupj jis lal: —¿Ncu ma quelel poné quinam, napj nin velé mpes? ");
INSERT INTO jicNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nun ca nus nucú napj ca mis niswá Dios pü'ü nt'a, püna pü'üstsja nt'a. ¿Tsjan ca nujola nun, nin tepyala na? Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dios Cjües nujos mo'o pü'ü na p'in, 'ücj nu la püt'üs Dios lal. Gente yusapj ma polel jis la püt'üs Dios lal. ¿'Onin 'ucuy cüpüt' Dios Cjües nujos mo'ó? Napj tjevelé toponé na, Dios Cjües nujos mo'o ca mim mpü'üm. Jupj lal ca 'ücj mpatjaqué lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nun nepenowá ma poné napj velé la p'in —nin tjevele Jesús. Jesús lovin seletsja pjacj ma ca quelel mponecj. Selé watsja pjacj ca lal ncuwim jupj enemigopan, ntji'lin̈ jupj. Nin mpes nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús tjevele wa: —Nepénowa nun popa ma japon napj velé. Nin mpes nun lal tjevelé gente yusapj ma polel jis la pon napj lal. Mpapay jis capj p'ya'sa jis la pon napj lal, ca mponecj. ");
INSERT INTO jicNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesús nin tjevele na, jupj discipulopan pülücj tjil jupj mpe. Ma quelel sa con̈tsja Jesús quinam. Ma quelel sin 'yǘsatsja quinam Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mpes Jesús jis la tji'yüya jupj apostolpan doceyá: —¿Ncu nun quelel lowú wa napj mpe? ");
INSERT INTO jicNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Niyom dóceya popa Simón Pedro pjaní wa. Jupj tjevele Jesús lal: —Jipj cupj qjuis Jepa. ¿Pjacj nt'a cülaca ncupj? Jipj velen mpes qjuisin 'yüsa 'onin 'ücj qjuis la püt'üs Dios lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cupj pyonecj jipj niná Yomen Dios tjevele ca jas majamas nosis nt'a qjuis capj la p'acj. Selecj cupj t'üc' way jipj niná. ");
INSERT INTO jicNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús tjevele yupj jis lal: —Napj la nu t'ya nun, pjü dóceya, tsji' la müjí napj mpes. Mop'in ma pjü nun popa quelel tsji' lojí napj mpes. Nun popa pjaní ma quelel la niji. Jupj tsji' liji diablo mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ninana Jesús tjevelá, Judas po'ó tjevele jupj. Simón Iscariote jatjam waytsja jupj, Judas. Niyom dóceya popa watsja, mop'iyá jis lal tjemey Jesús enemigopan jis la tjilil Jesús p'a jawas. Jesús seletsja Judas ca nin la mijis. ");
INSERT INTO jicNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Locopyaya Jesús Galilea mo'o tjuwine; ne'aj patja sin 'yüsa lis tjiji jupj. Judiopan jis jepapan quelel ja'ünantsja jupj, mpes Jesús ma quelel jámatsja Judea nt'a, yupj tapatja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judiopan jis fiesta nasa quelel pyálatsja. Fiesta niná mpes judiopan ts'epjel mo'o tapatja. Nin la tjajay pjü año na. Judiopan pülücj tjil ne'aj, Jerusalén nt'a, fiesta niná tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mpes Jesús jüpülücpan tjowelepj jupj lal: —Más 'ücj mim jipj Judea mo'o. Ne'aj Jerusalén mo'ó jipj discipulopan pülücj ca ne'aj majatjum fiesta mpes. Jutja ne'aj, jis tje'yaya januc jipj pajal 'üsüs lejay Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jipj jyas pjü jis januc jipj, mpes po ma tjepjya'na niná jipj lejay. Jipj pajal 'üsüs lejay Dios mpes, más 'ücj pülücj patja nt'a mim. Ne'aj la p'a ca nucucj jipj lejay, jus nlayecj ca pjacj jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ninana tjowelepj la pjüts'ün. Jesús jüpülücpan ma topon Dios jas tjejyama jupj nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jüpülücpan nin tjowelepj na, Jesús tjevele yupj jis lal: —Yacjaj 'ücj tulucj napj jum. Nun lal ts'ac' la talata 'ücj lowú. ");
INSERT INTO jicNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dios ma jisas ma polel ts'i mi'inacj nun lal. Napj lal ts'a 'in napj velé mpes. Napj velé yupj jis lal napj selé yupj pajal malala nyuca lajay. ");
INSERT INTO jicNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lowa nun fiesta nt'a. Yacjaj 'ücj tulucj napj jum, mpes ca ma mis napj po quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nin tjevele Jesús jupj jüpülücpan jis lal, ne ma wa tjemey yupj jis lal fiesta nt'a. Newa Galilea mo'o tüpü'ü ts'ac' pjaní way p'in 'in. ");
INSERT INTO jicNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jüpülücpan tjil na fiesta nt'a, locopyaya p'a tjejyawca na, tjemey wa Jesús. Lyájasa tjemey, mpes la p'a ma jus nlay jupj tjemey. ");
INSERT INTO jicNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ne'aj fiesta nt'a judiopan jis jepapan Jesús la paltsja. Jis la 'üytsja ne'aj tjelyawun̈ jis lal: “¿Ca'aj já'asa niná yomen?” ");
INSERT INTO jicNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pülücj 'a jis tjimyula ne'aj fiesta mpes. Yupj sin popa pülücj tülü way la tjowelel Jesús po'ó. Nepénowa tjowelepj: “Yom 'üsüs way jupj”. La p'a wa tjowelepj: “Nin tulucj. Jupj li tsuwile gente jis lal, mpes ma lajay Dios jos jin.” ");
INSERT INTO jicNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Len̈ pjacj cüweles Jesús po'ó pülücj cüpjacan̈ nt'a. Lacj tjeyapj judiopan jis jepapan mpes. 'Üsüs yólatsja Jesús po'ó, judiopan jis jepapan ca jis capj ntülücj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta nasa la mitad tecyawaja na, Jesús tjemey Dios wo nt'a. Gente sin 'yüsa lis tjiji ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judiopan jis jepapan pajal yólatsja Jesús 'üsüs sin 'yüsa lis tjiji mpes. Yupj tjowelepj: “¿'Onin jus cülayé niná pjü? Jupj lovin ma tjemey qjuis escuela nt'a lo 'üsüs.” ");
INSERT INTO jicNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nin tjowelepj mpes, Jesús tjevele 'a jis tjimyula jis lal: —Napj ma nusin 'yüsa lejay napj nola mpes. Napj nusin 'yüsa lejay Dios jola jin. Nin tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nun popa pjaní quelel liji Dios jos jin, jupj ca jus nlayes ncu napj sin 'yüsa lejay napj nola jin, ca jus nlayes ncu sin 'yüsa lejay Dios jola jin. ");
INSERT INTO jicNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nepénowa yupj p'iyá yola jin sin 'yüsa lajay, jisas la p'a püné jin yola yupj. Ma nin lejay napj. Napj najas la p'a püné jin yola nin tjejyamá. Mpes nun ca jus cülayé, napj velé, t'üc' way niná; ca jus cülayé malala tulucj napj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","”Nun malalapan. Püna Moisés papel tepyaca Dios tjijyü'tá, nun mo'o la veles. Newa nun pjü way ma nin lajay Dios tjijyü'ta jin. Nun quelel na 'ü'ná. Nenem 'a malala —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nin tjevele na, nepénowa 'a jis tjimyula sin popé wola tjowelepj Jesús: —Lapanen jyas mo'o pü'ü jipj, nin lo ts'ün jipj. Len̈ pjacj quelel 'i 'ü'na. ");
INSERT INTO jicNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús tjevele yupj jis lal: —Yom pjaní tji'yü'sa la tjejay napj sábado na, nin jawas cupj ma tsji' lijicj. Nun nujola pajal malala niná, napj nin la tjejay sábado na. ");
INSERT INTO jicNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nin tulucj. Nun nin p'iyá lojí, napj lejay jinwá. Moisés tjijyü'ta judiopan t'asiyú jis la t'üs niyom tsjictjacj jis pjoloc' tsjicj way, tsjictjacj ts'ac' ocho jatatj na. (Israelpan püna tapatja p'in tjüjütütj niná.) Nun nin lojí custjay. Yom tsjicj ts'ac' ocho tya'a na, t'üjǘ jupj. Ts'ac' ocho pyala sábado na, nt'üjǘ ca sábado na. ");
INSERT INTO jicNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Ücj nun lal yom tsjicj ca nt'üjǘ sábado na, 'ücj la jay Moisés tjijyü'tá. Mpes más 'ücj ma ts'i mi'iná napj lal napj tji'yü'sa la tjejay yom jüp'üy jas tüpwes sábado na. ");
INSERT INTO jicNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Po ma tjowelé la p'a malala nyuca liji nun nujola mpes p'in. Nujola t'as ncu t'üc' way malala nyuca la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jesús nin tjevele mpes, nepénowa Jerusalén mo'o tapatja sin popé Jesús po'o javeleptsja: “T'üc' way jupj niná yomen jepapan quelel ja'ünan. ");
INSERT INTO jicNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mop'in ma lecj jeya jupj. Jupj vele pjü jis la pjac nt'a; newa nin jepapan ma jajütütj ma nin liji jupj. Yupj ca jus cülayecj t'üc' way jupj niná Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","¿'Onin nacj niná? Cupj selecj wa Jesús tjac' mpe. Cupj qjuisin tji'yüsa wa nin tulucj ca nsem Yomen Dios se jamá lal. Cupj selecj niná jac' na, ma ca jus nlayecj ca'aj mpe tjac' jupj”, nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nin javeleptsja na, Jesús tjevele t'üc' way Dios jas tjejyama jupj. Dios wo nt'a tjá'asa jupj, mpes yümücj tjevele pjü jis la pjac: —Nun nujola nus nucú. Nujola wa nun solejé ca'aj mpe tjacuwis. Nin tulucj. Napj tjacuwis napj quelel cuwistsja mpes p'in tulucj. T'üc' way p'a wa nin tjejyama. Nun ma su nucú jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nam 'a si nuc. Napj tjacuwis jupj mpe; jupj nin tjejyama —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Judiopan jis jepapan ts'a 'intsja Jesús lal Jesús nin tjevele mpes. Po quelel ntji'lin̈tsja jupj, mo'o la 'onsos jupj cawilta mo'ó. Newa ma polel ntji'lin̈ jupj. Custjay ma nin jawas nem Dios tjevele Jesús ca mpa'is, mpes ma polel ntji'lin̈ jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pajal pülücj fiesta nt'a tjiquil sin popé, pülücj topon Jesús lal. Yupj javeleptsja: “Jepa Püné niná Dios tjevele ca jas majamas qjuis capj la p'acj, ma ca más 'üsüs la qjuijis Jesús lal. Jesús pajal 'üsüs liji, yom p'in ma polel liji jinwá, qjuisin 'yüsa la qjuisiji Dios jas tjejyama.” ");
INSERT INTO jicNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseopan nepenowá tjepjyacan̈ wa gente pülücj sin popé tülü way javeleptsja niná Jesús po'ó. Niná tjepjyacan̈ na, pajal nin yólatsja yupj. Ma jisastsja la p'a jis la pon Jesús lal. Mpes jis auxiliarpan sin tjajam Jesús nt'a jis la tjilil jupj, yupj nt'a la cuman. Sacerdote noypan sin tjajam wa auxiliarpan nenem. ");
INSERT INTO jicNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús seletsja nin quelel lajaytsja yupj. Mpes tjevele: —Tsjicj way p'in pü'üs nun lal. P'a jawas ca mis niswá nin tjejyama pü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tjum na, nun ca la ma palá. Nun ca nujisas napj ca nucopj mp'acj. Mop'in ma ca nus nucú. Napj mpü'üs nt'a, nun ma ca polel nculá —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judiopan jis jepapan ma quelel japontsja Jesús tjevelá. Mpes yupj yuwá tjowelepj: “¿Ca'aj 'ucuy niná yomen, ne cupj ma polel jus la nuc? ¿Ncu ca mim judiopan tulucj pülücj patja nt'a? Judiopan nepénowa ne'aj patja judiopan tulucj patja nt'a. Ca nacj Jesús ca ne'aj mim, sin mü'üsüs lis mijis judiopan tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tsjan quelel vele jupj nin vele na, cupj ca la mpalacj jupj, cupj ca qjuisas nsem jupj qjuis capj mp'a'sas? ¿Tsjan quelel vele jupj nin vele na, cupj ma ca jus nucum, ne jupj mpü'üm nt'a cupj ma ca polel nlaca cupj?” ");
INSERT INTO jicNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pjü tjejyawca na fiesta na, ts'ac' más 'üsüstsja na, Jesús yupj jis walap'a'a tón̈catsja, yümücj tjevele pjü 'ücj jis la pjac: —'Üsǘ nusive jinwá nun nepenowá, nun pajal nujos Dios ca nucopj mp'a'sas. Toponé napj lal. Napj 'üsǘ jinwá nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","'Üsǘ 'ücj jis la püt'üs jisas mo'o cyala jinwá ca nsem napj lal japon mpes. 'Üsǘ püné jinwá ca nsem. Dios Popel nin vele ca nin nsem —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús nin tjevele na 'üsǘ mpes, jupj véletsja Dios Cjües po'ó. Jesús po'o japon nt'anquecj wa yupj Dios Cjües, jisas mo'o mpü'üm. Jesús wine secj Dios pü'ü nt'a custjay, 'a mulú la 'osos Popay lal. Nin mpes 'aya secj custjay Dios Cjües. ");
INSERT INTO jicNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tjepjyacan̈ na Jesús tjevelá, nepénowa tjowelepj: “T'üc' way jupj profeta Moisés jin p'iyá, profeta niná pajal la tjinyucucj lovin”. ");
INSERT INTO jicNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nepénowa p'a casá yólatsja, mpes tjowelepj: “Jupj ninana Yomen Dios tjevele ca jas majamas cupj nt'a qjuis capj la p'acj”. P'a wa tjowelepj: “Nin tulucj. Ma polel nacj niná Yomen Dios tjevele ca jas majamas. Selecj Yom Dios se jamá ma ca ncuwim Galilea mpe.” ");
INSERT INTO jicNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios Popel vele niná Jepa Püné Dios se jamá David püna tüpü'ü popa p'iyá jupj. Dios Popel vele wa Jepa niná Belén mpe 'esepj ca nsem jupj. Ne'aj David tüpü'ü wa püná. ");
INSERT INTO jicNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma nin way p'in yólatsja Jesús po'ó. Nepénowa 'üsüs tjowelepj Jesús po'ó. Nepénowa malala tjowelepj jupj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nepénowa quelel tji'lin̈tsja jupj, quelel jamantsja jupj jepa nt'a. Newa ma nin la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Auxiliarpan ma wa ntji'lin̈ Jesús, mpes tjil niswá sin tjajam nt'a, sacerdote noypan nt'a, fariseopan nt'a 'ots'ipj. Yupj jis la tjü'üy: —¿Tsjan mpes ma tucumaná jupj? ");
INSERT INTO jicNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Auxiliarpan jis wala tjowelepj: —Yom p'in lovin ma jupj jinwá tjevele. 'Üsüstsja pajal jupj tjevelá. Nin mpes ma quelel ntjiliquecj jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Auxiliarpan nin tjowelepj mpes, ts'a tji'in fariseopan. Tjowelepj auxiliarpan jis lal: —Jupj nujus tsyawilí wa nun ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nun solejé pjü judiopan jis jepapan ma japon Jesús mpes. Pjü fariseopan ma wa japon Jesús mpes. Cupj ma pyonecj jupj yom niná Dios se jamá. ¿'Oyn la cüjí cüponé nun? ");
INSERT INTO jicNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Gente fiesta nt'a tjiquil japon, mop'in ma salejepj yupj. Yupj 'a ma sin 'yüsa Moisés tjijyü'tá püná. Nin mpes ca Dios jis capj ntülüs. ");
INSERT INTO jicNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariseo pjaní ma nin p'iyá jólatsja la p'a fariseopan jinwá. Nicodemo lotsja jupj. Püna p'in Jesús nt'a tjemey la veles jupj lal püste na. Mpes Nicodemo tjevele quinam: ");
INSERT INTO jicNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Qjuis jepapan jajütütj cupj ma ca mvelecj t'üc' malala nyuca la tjiji, jupj ma qjuis wala tjevele mwalá way p'in. Nin lovin. Jepapan jajütütj mwalá way ca qjuisin mü'üsüs ncu t'üc' way malala la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","La p'a fariseopan ma tjowelepj ncu t'üc' Nicodemo tjevelá. Malala tjowelepj p'in. Tjowelepj: —Galilea mpe tjacuy wa jipj ca nacj, Jesús jinwá. Dios Popel mo'ó la tepyala nucun ncu nin vele Galilea mpe jac' profeta pjaní. Ma nin vele Dios Popel. (Yupj la tsawiltsja.) ");
INSERT INTO jicNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","T'üc' tjowelepj quinam, ne pjü jis wa nt'a tjil. ");
INSERT INTO jicNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús joc' 'alá tjemey püste la püt'üs lo jawaques. Yo olivo pülücj lejen̈tsja ne'aj, mpes joc' niná “Olivos” lotsja. ");
INSERT INTO jicNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pajal püstapj tjemey niswá Dios wo nt'a. Pülücj ne'aj játjatsja, Jesús tjac' na. Pjü jiquiltsja jupj nt'a jis la pjac jupj tjevelá. Mpes 'etjele Jesús, sin tji'yüsa lis tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yacjaya Moisés popel sin 'yüsa lajay tjiquil wa Jesús nt'a. Fariseopan tjiquil wa. Quepj pjaní tucuman jas la veles. Quepj niná yom p'a lal tjuwine, voyum tulucj. P'a wa jus tjunuc jupj nin la tjiji. Quina niyom tucuman jupj Jesús wolap'a'á, pjü jis la nuc ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Niyom Jesús lal tjowelepj: —Jipj sin 'yüsa lejay gentá. Pajal selen jipj. Nin mpes quelel lya 'yüyactsja 'oyn la qjuijim niná quepan lal. Quepj niná yom p'a lal tjuwine, voyum tulucj. Tjinyucucj nin la tjiji. ");
INSERT INTO jicNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés tepyaca popel mo'ó Dios tjijyü'tá. Tjevele pe mpes mü'ü'nacj nequem nin lajay. ¿Tsjan velen jipj tsjan más 'ücj la qjuijim quepj lal? —niná yupj la tjü'üy Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","T'üc' way yupj ma quelel salejeptsja tsjan la qjuijicj yupj. Yupj jisastsja Jesús malala cüveles, ne ca yupj 'ücj jat' mvelecj Jesús po'ó. Mop'iyá ma jis lal tjevele jupj. Palá tipi'tje, tepyaca 'amá 'alá, mos ts'ipal mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Newa la tjü'üy tsjan la qjuijicj quepj lal, mpes Jesús niswa jas nisa, tjevele yupj jis lal: —¿Ncu nun popa pjaní lovin ma malala nyuca la tjiji? Lovin ma malala la tjiji, jupj 'ücj ca mwalá way jay nts'iyas pe mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nasa tjevele na, niswa palá tipi'tje, niswa tepyaca 'amá 'alá. ");
INSERT INTO jicNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Niyom tjepjyacan̈ na Jesús tjevelá, jus nlay yupj p'iyá malala waytsja 'ots'ipj. Mpes pjü tjil. Más co'müypan mwalá way tjil; pjü pjaní pjaní tjil. Jesús ne'aj tjá'asa tjil. Quepj newa ne'aj já'asatsja. Jesús wolap'a'a ton̈ca custjay. ");
INSERT INTO jicNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús jas nisa, tjevele quepj lal: —¿Ca'aj tjil noyomes, yupj ne tjat' tjowelepj jipj jin po'ó? ¿Ncu len̈ pjacj cüweles cyapj cütül? ");
INSERT INTO jicNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Quepj tjevele: —Len̈ pjacj cüweles ncapj cütül. Jesús tjevele jupj lal: —Napj 'a ma wa velé cyapj cütülücj. 'Ücj la winin quinam. Po ma malala nyuca la mijin quinam, püna lejaytsja jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús tjevele niswá ne'aj tjatja jis lal. Tjevele: —Napj jyawca jinwá nosis nt'a. Napj sin 'yüsa la sejay Dios mpes. Ncapj jacon̈, jaw nt'a lyawun̈ jinwá yupj. Ca jus nlayecj 'oyn nyuca la püt'üs Dios lal. Püste nt'a lyawun̈ ma salejepj ca'aj lyawun̈ yupj. Nin tulucj ca nsem ncapj jacon̈ jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseopan ma jisastsja Jesús nin tjevelá, mpes tjowelepj jupj lal: —Jipj niná velen jipj p'iyá po'ó la p'in, mpes ma selecj ncu t'üc' velen. Len̈ pjacj cüweles jipj velen t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Nin tulucj —tjevele Jesús—. Nam 'a napj p'iyá velé napj nin po'ó, mop'iyá ca nun jus cülayé napj t'üc' way velé. Napj selé ca'aj mpe tjacuwis. Selé wa ca'aj jum p'a jawasiyá. Nun ma solejé ca'aj mpe tjacuwis. Ma wa solejé ca'aj ca mis locopyayá. ");
INSERT INTO jicNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gente p'in jin nujola nun. Nun nucú mpes p'in nun welé napj ma t'üc' way velé. Napj p'iyá ma velé p'a po'ó ncu malala jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mop'iyá napj velé na ncu pjaní malala nyuca la tjiji, 'ücj niná napj nin velé. Napj velé jupj po'ó t'üc' way. Ma velé napj nola p'in. Mpapay nin p'iyá jola napj nola jinwá. Nin tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","”P'a wa mpes nun ca jus cülayé napj p'iyá po'ó velé t'üc' way. Napj way p'in nin velé tulucj. La p'a nin p'iyá vele. Nun jis papel Moisés tepyacá nin vele 'ücj niná. Mat'e nin p'iyá javelepj na, nun 'ücj ca mponé t'üc' way javelepj yupj. Nin vele jupj popel. ");
INSERT INTO jicNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nin mpes nun 'ücj jis la pon napj velé. Napj way p'in nin velé tulucj. Napj velé napj p'iyá po'ó, napj Mpapay nin p'iyá vele wa napj po'ó. Nin tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jesús nin tjevele na, fariseopan la tjü'üy jupj lal: —¿Ca'aj pü'ü pyapay? Jupj len̈ qui'am. Jesús jis wala tjevele: —Nun ma solejé pjacj ne napj. Ma wa solejé pjacj Mpapay. Jus cülayé pjacj ne napj, jus cülayé wa pjacj Mpapay. ");
INSERT INTO jicNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ninana Jesús tjevele Dios wo nt'a, sin 'yüsa lis tjiji na ne'aj. Ne'aj já'asatsja t'emel ja'ayapj nt'a Dios mpes. Judiopan jis jepapan pajal ts'a 'intsja Jesús lal, mop'iyá ma polel ntji'lin̈ Jesús cus la tül. Newa ma jyáwcatsja Jesús pe'e jawas. ");
INSERT INTO jicNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Judiopan jis jepapan ma topon Jesús t'üc' way tjevele, mpes Jesús p'a way tjevele yupj jis lal. Tjevele: —Napj mis ca quepé p'a jawasiyá. Napj tjum na, nun ca la ma palá. Mop'in ma ca polel nus nucú. Nun co'liqué na, newa malala nsem nun, ne Dios ca nucopj ntülüs malala nyuca la tjüjí mpes. Napj jum nt'a nun ma ca polel nu la cuwis —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mop'iyá judiopan jis jepapan la tjüpjüts'ün Jesús yuwá. Tjowelepj: “¿Ncu jupj p'iyá ca mü'ü'nas jupj? Nin mpes tjevele ma polel leque jupj jama nt'a ca nacj.” ");
INSERT INTO jicNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nin javeleptsja mpes, Jesús tjevele yupj jis lal tsjan mpes nin tjevele jupj. Tjevele: —Nun nosis nt'a potjaqué. Napj Dios pü'ü mpe tjacuwis. Nun Dios enemigopan popa. Nam 'a nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nin mpes napj tjevelé nun co'liqué na, newa malala nsem nun. Nin mpes tjevelé Dios ca nucopj ntülüs malala nyuca la tjüjí mpes. Nun ma poné napj nin p'iyá napj nin tjevelé, newa malala nsem nun Dios lal, co'liqué na —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Judiopan jis jepapan tjowelepj jupj lal: —Pajal püné jin jele jipj p'iyá. ¿Pjacj ne jipj? Jesús tjevele yupj jis lal: —Napj nin p'iyá lovin nun lal tjevelé. ");
INSERT INTO jicNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Napj 'ücj pülücj cüvelé nun mpes. 'Ücj la veles pajal la pülücj malala nyuca la tjüjí nun. Nun ma poné napj velé, mop'iyá t'üc' velé napj. P'a wa nin tjejyama. Jupj lovin t'üc' way vele. Napj tjapjacas jupj tjevelá, ninana velé napj nosis nt'a patja jis lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yupj ma jus nlay Jesús jas tjevele Popay tsjun casapa pü'ü po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mpes Jesús 'üsüs tjevele t'üc' way Popay po'ó tjevele jupj. Tjevele: —Napj p'iyá niná Yomen Dios jas tjejyamá. Nun ca nin müjünsǘ la valas. Nin la tjüjí na, ca jus nlayé napj niná napj tjevelé. Nin la tjüjí na napj lal, ca jus nlayé wa napj ma lejay napj quelel lejay. Nun ca jus nlayé napj velé Mpapay nin tji'yüsa la tjiji velé. Ma p'a way velé. ");
INSERT INTO jicNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mpapay nin tjejyama, newa ncapj cyon̈ca. Lovin jupj jos jin lejay. Ma nasapj 'os. ");
INSERT INTO jicNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús nin véletsja na, pülücj topon jupj niná Yomen Dios tjevele ca jas majamas. ");
INSERT INTO jicNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Judiopan nepénowa topon Jesús lal. Jesús tjevele yupj jis lal: —Nun lovin lojí napj tjevelé jin, t'üc' way nun napj discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nun ca jus nlayé t'üc' way p'iyá. Jus nlayé na niná, esclavopan tulucj ca nsem nun. Newa 'ücj ca la müjí tsjan más 'ücj la müjí. ");
INSERT INTO jicNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—¡Cupj esclavopan tulucj! —tjowelepj yupj—. Abraham pajal püna tüpü'ü popa p'iyá ncupj. Lovin esclavopan tuluctsja ncupj. Lovin p'a juts'a'á tuluctsja cupj. ¿Tsjan pjucj niná tjevelen: ‘Esclavopan tulucj ca nsem nun?’ ");
INSERT INTO jicNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús jis wala tjevele: —Newa malala lajay, esclavopan yupj. Ma polel lajay más 'ücj lajay jin. Mop'in malala lajay. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Esclavo ma polel lo püt'üs jupj patrón wo mo'ó lovin. Jupj patrón jatjam p'in 'ücj lo püt'üs jupj popay wo nt'a lovin. Nin p'iyá nun jis lal. Nun esclavopan jinwá malala lojí mpes, ne nin mpes nun ma polel jis la püt'üs Dios lal lovin. Dios ts'uyupan p'in 'ücj jis la patj Dios lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Napj Dios Jatjam. Napj 'ücj jis la jütütj jupj juts'a'á. Nin mpes 'ücj napj nusin jyam nlawú, mpes esclavopan tulucj nsem nun. Napj nin lejay na, t'üc' way esclavopan tulucj nsem nun. Ca 'ücj la müjí Dios jos jin. ");
INSERT INTO jicNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","”Napj selé Abraham pajal püna tüpü'ü popa p'iyá nun. Mop'iyá nun quelel na 'ü'ná. Nun ma quelel poné napj tjevelé, ne nin. ");
INSERT INTO jicNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Napj tjinyuc Mpapay lal, niná velé napj. Nun nun jis papay tjevele jin lojí —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Judiopan jupj wola tjowelepj: —Abraham püna tüpü'ü popa p'iyá ncupj. ('Üsüs witjacj ncupj.) Jesús tjevele yupj jis lal: —Nin tulucj. Nun ma lojí Abraham la tjiji jinwá. Mpes nun ma t'üc' way Abraham popa. Nun Abraham popa p'iyatsja nacj, Abraham la tjiji jin p'iyá la cüjí. ");
INSERT INTO jicNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","T'üc' way tjeveletsja napj nun lal. Dios tjevele tjapjacas jin tjevelé. Mop'in nun nujola 'oyn nyuca na 'ü'ná. Mpes nin velé, nun ma lojí Abraham la tjiji jin. ");
INSERT INTO jicNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nun lojí nupopay liji jin —nin tjevele Jesús. Yupj tjowelepj jupj lal: —Qjuis Papay pjaní p'in. Dios jupj. Len̈ qjuis papay p'am. ");
INSERT INTO jicNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús tjevele yupj jis lal: —Dios jatjampan tulucj nun. Dios Nupopay nacj, ca quelel la cüjitsja napj. Napj Dios Popa; Dios mpe tjacuwis napj. Napj tjacuwis napj quelel tjacuwis mpes tulucj. Jupj nin tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tsjan mpes ma nusin 'yüsa napj velé? Nun ma quelel pjo'oqué napj velé nun lal. ");
INSERT INTO jicNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nun nupopay popa. Diablo nupopay, ne nun quelel lojí nupopay jos jin. Lovin jupj si 'ǘ'natsja (nun quelel lojí jinwá quinam). Lovin ma jos t'üc' way. Cjuwá t'üc' way jupj jos mo'ó, mpes nin. Jupj li tsuwile na, jupj jos jin p'iyá vele jupj. Jupj lovin li tsuwile; la tsuwilpan jis popay jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","”Napj t'üc' way velé. Nin mpes nun ma poné napj velé. ");
INSERT INTO jicNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ncu pjaní way p'in nun popa cüweles jupj selé napj malala nyuca la tjejay? Nin tulucj. (Lovin malala nyuca liji secj napj.) T'üc' way velé lovin. ¿'Oyn ne ma poné napj lal? ");
INSERT INTO jicNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios ts'uyupj sin 'yüsa Dios velá, quelel wa lajay jupj velá. Nun ma nusin 'yüsa Dios velá, ma wa quelel lojí Dios velá. Nin mpes nin velé nun Dios jatjampan tulucj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judiopan pajal ts'a tji'in Jesús nin tjevele na. Mpes yupj tjowelepj Jesús lal: —Jipj velen yom Samaria mpe 'esepj jinwá. Ma t'üc' velen Dios po'ó. Lapanen jyas mo'o pü'ü. Ninana tjevelecj jipj po'ó lovin, ne cupj tjevelecj, t'üc' nem. ");
INSERT INTO jicNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Nin tulucj. T'üc' tulucj —tjevele Jesús—. Lapanen len̈ najas mo'ó. Napj velé napj Mpapay pajal 'üsüs, pajal püné; newa nin, nun welé 'üsüs tulucj, püné tulucj napj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mop'in napj velé na, ma nin nola ncu p'a nin yola pajal püné, pajal 'üsüs napj. P'a wa nin jola. Jupj jos la p'a wa 'üsüs jin yola napj. Jupj ca mveles napj t'üc' way pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","T'üc' velé napj. Napj velé jin lajay ma ca nca'lin̈. Mpatjam ca Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jesús nin tjevele na, yupj tjowelepj jupj lal: —Quina selecj t'üc' way lapanen jyas mo'o pü'ü. Malala jele. Abraham tepe'e pajal püna. Profetapan pjü tecya'lin̈ wa yupj; yupj topontsja Dios tjevelá. Quina jipj nin velen jipj velen jin lajay lovin ma ca nca'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham püna tüpü'ü popa p'iyá cupj. Nasa tepe'e jupj. ¿Ncu más püné jipj jupj lal? Nin tulucj. Profetapan tecya'lin̈ wa. ¿Ncu más püné jipj yupj jis lal? Nin tulucj. ¿Tsjan jin jele jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús tjevele yupj jis lal: —Napj ma 'üsüs velé napj p'iyá po'ó. Napj nin velé napj p'iyá, ma polel nu lo pon niná. P'a wa mpes 'ücj la pon. Mpapay 'üsüs vele napj po'ó. Mpapay 'a Dios; nun welé nun so con̈có jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Newa Dios so con̈có tulucj. Nun ma nusin 'yüsa Dios lijá. Nam 'a 'üsüs way si nuc. Napj cüvelé ma si nuc, nun jin p'iyá ca la ntsawil napj. T'üc' way si nuc, ne lovin nin lejay jupj velá. ");
INSERT INTO jicNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham püna tüpü'ü, nun jupj popa p'iyá, pajal 'ücj jostsja napj ncuwistsja nosis casa'á. Tjinyuca na napj tjacuwis, 'ücj jos tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jesús nin tjevele na, judiopan jis jepapan tjowelepj jupj lal: —Año cincuenta tulucj jipj custjay. Ma wa ca jus tjinyuc Abraham. Pajal püna tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús tjevele yupj jis lal: —Abraham custjay ma tüpü'ü na p'in, napj newa tüpü'üstsja. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yupj pajal ts'a 'intsja Jesús nin tjevele mpes. Pe natj jay la ts'is, la 'ünan. Newa ma polel malala lajaytsja jupj. Jesús tjapja'na, ne Dios wo pje'á tecyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús jámatsja na, jupj jus tjinyuca yom jun tulucj. Tjemya'na pepes jun tuluctsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesús discipulopan la tjü'üy: —Rabbí, ¿tsjan mpes tjemya'na pepes jun tuluctsja niná? ¿Ncu jupj p'iyá malala nyuca la tjiji mpes nin tepyala? ¿Ncu jupj popay, jamay malala nyuca la tjajay mpes nin tepyala jupj? ");
INSERT INTO jicNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús jis wala tjevele: —Nin tulucj. Jupj p'iyá malala nyuca la tjiji mpes tulucj. Ma wa jupj popay, jamay malala nyuca la tjajay mpes nin tepyala. Dios quelel sin 'yüsa liji jupj pajal 'üsüs, pajal püné. Nin mpes tjemya'na pepes jun tuluctsja yomen. Dios ca pajal 'üsüs la mijis jupj mpes quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nosis casa'á pyatjaquecj na p'in, Dios jos lovin tsji' lijicj jupj mpes. Nun taca'liqué na, ma ca polel tsji' la müjí. Nin p'iyá pjü gente jis lal. Dios nin tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nosis casa'a pü'üs na p'in, napj jyawca jinwá nosis casá patja jis lal. Napj sin 'yüsa lejay Dios mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús nin tjevele na, 'amá 'alá tipyuts'a. Tjutj mpes pililicj tsjicj way la tjiji. Pililicj jun poloc' po'o jas tjecjyo'la yom jun tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nin la tjiji na, tjevele jupj lal: —Jutja, jin jas mpa'in 'üsǘ muju ton̈ca nt'a, 'üsǘ Siloé ló jupj. (Siloé yupj jis tin; “Jas Tjejyama” velecj cupj.) Mpes tjemey yom jun tulucj. Jun jas tepe'e Jesús tjevele jin. 'Üsǘ mpe tjac' na, 'ücj nyúcatsja quinampa. ");
INSERT INTO jicNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mpes la p'a püna jus tjunuctsja pajal nin yólatsja tsjan mpes 'ücj nyuca quinam. Nepénowa yuwá sin pópatsja yom jun tuluctsja lal, nepénowa lovin jus tjunuctsja t'emel le monatsja jupj. Yupj tjowelepj: “¿Ncu ninana p'iyá lovin t'emel la tjemyona tja'asá, jun tulucj mpes?” ");
INSERT INTO jicNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nepénowa javeleptsja: “T'üc'. Ninana yomen.” P'a wa javeleptsja: “Ninana tulucj nempe. Yom jun tulucj jin justa la p'in.” Mpes yom p'iyá tjevele: “Napj mp'iyá p'in niná yomen”. ");
INSERT INTO jicNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿'Oyn ne 'ücj nyuc quinam? —la tjü'üy jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jupj jis lal tjevele: —Yom Jesús ló 'amá 'its'its' la tjiji, nan poloc' jas tjecjyo'la. Tjevele napj lal: ‘Siloé nt'a jutja, jin jas tepe'e’. Mpes tjum, nan jas tepyatsj. T'üc' jas tepyatsj na, tji'yü'sa quinam nan. 'Ücj la nuc quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yupj la tjü'üy jupj lal: —¿Ca'aj já'asa niná yomen? —Ma selé —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mpes yom püs jun tuluctsja tjaman fariseopan nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sábado natsja Jesús 'amá 'its'its' la tjiji, tji'yü'sa la tjiji yom jun tulucj. Sábado na nin jawas judiopan ma tsji' lajay. Jesús nin la tjiji, ninana tsji' la tjijá, nin yólatsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nin mpes fariseopan la tjü'üy wa yom lal 'onin 'ücj nyuca quinam. Jupj tjevele yupj jis lal: —Jupj 'amá mpes nan poloc' po'o ts'yuca. Napj nan jas tepyatsj, ne 'ücj nyuc quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mpes fariseopan nepenowá javeleptsja: “Jesús ma tsji' liji Dios mpes. Dios mpes tsji' lajay, Dios jos jin lajay sábado nampa. Nin mpes selecj ma tsji' liji Dios mpes.” Fariseopan la p'a javeleptsja: “Nin tulucj. Yom malala liji, Dios ma se p'a'sa pajal 'üsüs liji jupj mpes. Jesús t'üc' pajal 'üsüs liji Dios mpes. Nin mpes selecj Dios mpes tsji' liji.” Nin tepyala mpes fariseopan nepénowa malala yólatsja Jesús po'ó, nepénowa 'üsüs yólatsja. ");
INSERT INTO jicNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mpes tjowelepj yom jun tuluctsja lal niswá. Tjowelepj: —Jipj velen jupj tji'yü'sa la tjiji jipj jin. ¿Tsjan jin jele jupj? Yom jun tuluctsja tjevele yupj jis lal: —Profeta jupj, nin nola napj. Dios mpes vele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judiopan jis jepapan custjay ma quelel japontsja ninana yomen püs jun tuluctsja jupj. Ma quelel japontsja quina tji'yü'sa jun. Mpes yom jamay, popay jis lal tjowelepj jis la cuwis. Tjowelepj wa yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jis la tjü'üy: —¿Ncu ninana nun sin popa? ¿Ncu t'üc' way tjemya'na pepes jun tuluctsja jupj? ¿'Oyn ne 'ücj nyuca quinam? ");
INSERT INTO jicNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yom popay, jamay yupj jis lal tjowelepj: —Selecj ninana cupj qjuis catjam. Selecj way tjemya'na pepes jun tuluctsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma selecj 'oyn ne 'ücj nyuca quinam. Ma wa selecj pjacj tji'yü'sa la tjiji jupj jun. La tjü'üyá nucú jupj. Püné quinam jupj. 'Ücj way vele jupj p'iyá tsjan tepyala jupj jun. ");
INSERT INTO jicNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yom popay, jamay lacj jeyaptsja judiopan jis jepapan jis lal, mpes nin tjowelepj yupj. Judiopan nepénowa tjowelepj Jesús ninana Yomen Dios tjevele ca jas majamas jis capj la p'acj judiopan. Jepa judiopan ma jisastsja judiopan ninana velam. Mpes yuwá tjowelepj judío pjaní nin cüveles p'a lal Jesús po'ó, yupj ca müjü'tücj jupj lovin ma polel ncuwim ne'aj judiopan 'a si mulú nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nin mpes yom popay, jamay tjowelepj: “Püné jupj quinam. La tjü'üyá nucú jupj.” ");
INSERT INTO jicNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nin mpes judiopan jis jepapan niswa la tjomon tjac' yom jun tuluctsja. Tjowelepj jupj lal: —Dios wolap'a'a mvelen t'üc' ca mvelen jipj quinam Jesús po'ó. Cupj selecj Jesús ma liji Moisés popel jyü'ta jin, mpes malala jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yom jun tuluctsja tjevele: —Napj ma selé ncu Moisés popel jyü'ta jin liji. Pjaní way p'in selé. Nan tuluctsja pünam; 'ücj nyuc quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Locopyaya jepapan la tjü'üy jupj niswá: —¿Tsjan la tjiji jupj jipj lal? ¿'Oyn la tjiji tji'yü'sa jin? ");
INSERT INTO jicNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yomen jis lal tjevele: —Nasa nun lal tjevelé 'oyn ne tji'yü'sa la tjiji nan. Nun ma quelel pjo'oqué, ma quelel nusin 'yüsa. ¿Tsjan mpes quelel pjo'oqué niswá? Nujisas nun jupj discipulopan ca nu mpalas, la p'a jinwá ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Judiopan jis jepapan ts'a tji'in yom nin tjevele mpes. Yupj quelel malala javeleptsja jupj lal, mpes tjowelepj: —Jipj Jesús discípulo; cupj nin tulucj. Moisés discipulopan ncupj, Moisés pajal püna tüpü'ü jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Cupj selecj Dios Moisés lal tjevele. Nin tulucj Jesús lal. Ma selecj ca'aj mpe tjac' niná yomen. ");
INSERT INTO jicNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yom jun tuluctsja yupj jis lal tjevele: —Napj ma selé 'onin nacj ne nin nacj nun ma jus cülayé ca'aj mpe tjac' jupj. Jupj tji'yü'sa la tjiji nan, mpes ca jus cülayé. ");
INSERT INTO jicNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cupj selecj Dios ma ca jis cü'ayas malala lajay la mon jupj lal. Nin yolá Dios pajal 'üsüs, pajal püné, lajay wa Dios jos jin, Dios se 'aya yupj la mon. ");
INSERT INTO jicNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lovin len̈tsja pjacj polel 'yü'sa liji jun, tjemya'na pepes jun tuluctsja. ");
INSERT INTO jicNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yom niná Dios mpe ma 'ucuy, ma ca polel nin la qjuijis. ");
INSERT INTO jicNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jupj nin tjevele na, judiopan jis jepapan tjowelepj yom jun tuluctsja lal: —Monuna secj p'in malálatsja jipj. Lovin nintsja jipj. ¿Tsjan mpes jipj quelel qjuisin 'yüsa lejay? Nin tjowelepj na, pje'á la ts'i jupj yupj tjatja mpe. ");
INSERT INTO jicNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús jus nleya judiopan jis jepapan yom jun tuluctsja pje'á la ts'i yupj tjatja mpe. Jus nleya na, la tepyala, jus tjinyuca jupj. Tjevele jupj lal: —¿Ncu pyon jipj Dios jas tjejyama Yom pjaní nucopj la p'acj, jupj tjevele jin? ");
INSERT INTO jicNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yom jun tuluctsja Jesús lal tjevele: —Nawala mvelen pjacj niná yomen, mpes ca mpon napj jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús tjevele jupj lal: —Nasa jus tjinyuc jipj. Nasa velen jupj lal. Napj ne jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yomen tjevele: —Pyon napj. Napj Nejepa jipj. Jesús wolap'a'a palá nipi'tje jupj. Jólatsja Jesús pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús tjevele: —Napj nosis nt'a tjacuwis mpes, nepénowa lovin ca mpatjam Dios lal. Nepénowa Dios ca jis capj ntülüs. Nepénowa ma sin 'yüsa Dios mpes. Yun tulucj jinwá yupj. Yupj japon na napj mpes, ca 'üsüs sin mü'üsüs. 'Ücj januc jinwá ca jis mpalas. La p'a nin tulucj yupj. Yupj nin yola nasa sin tji'yüsa quinam. Ma quelel japon napj lal. Nin mpes lovin ma ca polel sin mü'üsüs Dios mpes. Yun tulucj jinwá ca nsem yupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseopan nepenowá ne'aj wa tjatja Jesús nt'a. Tjepjyacan̈ jupj tjevelá. Mpes la tjü'üy jupj lal: —¿Ncu quelel velen yun tulucj jinwá cupj 'ots'ipj? ¿Ncu quelel velen cupj ma qjuisin 'yüsa Dios mpes? ");
INSERT INTO jicNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús jis lal tjevele: —Nun welé nun 'üsüs nusin 'yüsa Dios mpes. Nujun tulucj jinwá nacj, Dios ma ca nin jólatsja nun malala nyuca la tjüjí mpes. Mop'in welé nun nasa nusin 'yüsa Dios po'ó, mpes Dios newa jola nun malala nyuca la tjüjí mpes —nin tjevele Jesús fariseopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús niswa sin 'yüsa lis tjiji wa. Tjevele: —Oveja tjüwücj mo'o jatja püste na, ca ma malala jis mpalas. Jun vilicj ton̈ca wama la cuwis. La p'a ma quelel wama jil jun vilicj mpe, pwecapan yupj. T'empe viyá jil wama jil yupj. Lyawun̈ sa 'ünan. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jun vilicj mpe wama jama tjüwücj mo'ó, jupj ne jyama ovejas. ");
INSERT INTO jicNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tjüwücj nt'a yom pjaní way já'asa, jun vilicj jyama jupj. Oveja jyama tjac' na, yom jun vilicj jyama jun cjyoltse 'ücj wama la winin. Oveja jyama oveja jis lá t'ya quinam, mpes jis lá se moná jiquil. Pje'á jis lal jama, mwalá jama oveja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pjü jupj juts'a'á jis lal pje'á tjemey na, mwalá way jama jupj yupj jis lal. Yupj jupj cjüil jil. Oveja jyama vele pjac sin 'yüsa pjacj nepé vele, mpes cjüil jil. Ma wa lacj jeyapj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yupj ma sa nuc ma cjüil jil. Ts'equenen̈ jupj mpe. Ma sa nuc nepé vele pjac ma sin 'yüsa pjacj nepé velá, mpes ts'equenen̈. ");
INSERT INTO jicNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ninana Jesús tjevelá oveja jyama po'ó. Nin tjevele sin 'yüsa la siji 'onin nyuca liji jupj p'iyá, 'onin nyuca lajay wa jupj mpes japon. Nin p'in, yupj ma sin tji'yüsa tsjan po'ó tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mpes Jesús niswa tjevele: “Napj tjüwücj jun vilicj jinwá, oveja patja jinan̈ nt'a. T'üc' way niná. ");
INSERT INTO jicNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La p'a wa mwalá tjiquil napj lal, tjowelepj sin 'yüsa la tjajay 'onin 'ücj la püt'üs Dios lal. La tsawiltsja yupj. Pjü ne yupj pequepan jinwá, ja'ünan jinwá yupj 'ots'ipj. Mop'iyá napj lal japon ma topon yupj tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Napj jun vilicj jinwá Dios jyü'ta nt'a. Napj mpes pyona, lovin ca Dios lal mpü'üm, Dios ma ca cus ntülüs jupj. Napj pjü ca ma'ayá jupj jos, 'ücj lo püt'üs. Nin p'iyá liji oveja jyamá. Jupj se 'aya oveja jisas 'ücj jis la püt'üs. ");
INSERT INTO jicNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","”Pequepan jiquil na, jis la pecj mpes jiquil la p'in. Jis la 'ünan mpes jiquil wa. Pjü malala jis la jay mpes jiquil la p'in. Nin nepenowá noyomes, la p'a sin 'yüsa lajay. Yupj javelepj Dios mpes sin 'yüsa lajay, mop'in ma quelel la najay. La p'a wa malala se palá yupj mpes. Napj 'a nin tulucj. Napj tjacuwis mpes, napj lal japon lovin Dios lal mpatjam. 'Ücj jisas ca mpatjam yupj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","”Oveja jyama pajal 'üsüs, 'ücj jupj lal jupj pe'e oveja ma ca nca'lin̈. Nin nam. 'Ücj napj lal napj ma pats', napj lal japon ma ca nca'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","La p'a wa ma quelel lajay napj lal japon, ma nin lajay napj lejay jinwá. Mozo jin p'in yupj. Mozo way p'in, oveja jupj juts'a'á tulucj. Oveja jyama tulucj jupj. Mpes nyuca na pü'á jac', oveja ne'aj lejen̈ ts'üequené jupj. Mpes pü'á oveja ntjüi'le, ne pjü ts'equenen̈, sin tjan jil. ");
INSERT INTO jicNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mozo, mozo way p'in, ma quelel la siji oveja witjacj. Nin mpes pü'á tjac' na, ts'üequené. ");
INSERT INTO jicNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","”Napj oveja jyama pajal 'üsüs jinwá. Napj yus nyuc napj lal japon; yupj nus januc wa napj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nin p'iyá Mpapay nus nyuca; napj si nuc wa jupj. 'Ücj napj lal napj ma pats' ca, mpes napj lal japon ma ca nca'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nepénowa judiopan tulucj ca mponecj wa napj lal. Dios jos napj mpes ca mpatjam wa yupj jupj lal. Yupj ca la mijicj wa napj velé jin. Pjü napj lal japon napj nats'a'á ca nsem yupj. Nin p'iyá ca nsem yupj jis lal, ne napj p'iyá ca jis majamá yupj pjü way, yom jupj oveja jyama jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”Napj quelel ni pü'í yupj mpes, niswa la püt'üs napj. Nin mpes Mpapay quelel la niji. ");
INSERT INTO jicNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma najas na 'ünan, ma polel na 'ünan. Napj ca jis ma'ayá na'ünan, mpes ma pats' ca. Napj 'ücj nin jyütütj ma pats'. Napj 'ücj wa jyütütj ne ca niswa mpü'üs. Ninana Mpapay tjevele jupj nin jostsja napj nin lejay”, tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús ninana tjevele na, judiopan niswa ma nin p'in yólatsja Jesús po'ó. Nepénowa yólatsja jupj 'üsüs, nepénowa yólatsja jupj malala. ");
INSERT INTO jicNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pülücj judiopan sin popa javeleptsja: “Lapanen jupj jos mo'o pü'ü, mpes malala jola jin vele. ¿Tsjan pjucj pjo'oqué jupj velá?” ");
INSERT INTO jicNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","La p'a wa javeleptsja: “Nin tulucj. Lapanen jupj jos mo'o cüpüt', ma polel 'üsüs la veles, jupj vele jin. Lapanen ma wa cus tjep'ya'sa tji'yü'sa la tjiji yom jun. Dios way p'in nin liji niná”, nin tjowelepj judiopan nepenowá. Nepénowa 'üsüs jin yólatsja jupj; nepénowa malala jin yólatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","P'a jawasa Jesús tjuwine niswá Jerusalén mo'ó. La p'a fiesta lajaytsja quinam Jerusalén mo'ó. Fiesta niná mpes judiopan yola tepyala püna tepyalá. Püna Dios ma jisas malala la tjajay Dios wo. Nin mpes judiopan nepenowá la tapalan yupj jis lal. 'Ücj la tjajay wa Dios wo. Judiopan niswa tjowelepj Dios wo Dios mpes p'in. Mpes pjü año fiesta la tjajay, yola mpalas niná. Jive natsja niná, tsjojose wa na. ");
INSERT INTO jicNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Corredor Dios wo t'asiyú nt'a wínetsja Jesús. Corredor niná “Salomón Corredor” lotsja. ");
INSERT INTO jicNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Corredor nt'a tjuwine na, judiopan nepenowá tjiquil Jesús nt'a, t'asiyú nyüjünsünün̈. Jupj lal la tjü'üy: —¿'Ona 'üsüs way ca mvelen pjacj ne jipj? Mvelen, qjuisin mü'üsüs ncu t'üc' way jipj niná Jepa Püné Dios tjevele ca jas majamas qjuis capj la p'acj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús jis wala tjevele: —Nasa tjeveletsja. Nun ma quelel poné napj velé. Napj pajal 'üsüs lejay, yom p'in ma polel liji jin. Nin lejay Mpapay ntjijütüta jinwá. Nin mpes 'ücj ca jus cülayé pjacj ne napj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Newa nun ma poné. Napj nats'a'á popa tulucj nun, mpes nin. ");
INSERT INTO jicNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Napj lal japon, napj no'oveja jinwá yupj. Napj se jamá yupj. Napj lal japon, napj velé jin lajay. Napj yus nyuc yupj; yupj napj ncapj jacon̈. ");
INSERT INTO jicNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Napj lejay lovin Dios lal patja, ne yupj ma pjü malala jis mpalas ne'aj. Len̈ pjacj cüpwec' yupj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mpapay ntje'aya yupj. Jupj más püné pjü jis lal. Len̈ pjacj cüpwec' yupj Mpapay mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Napj 'a Mpapay jin p'iyá. Nin p'iyá lijim —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesús nin tjevele na, judiopan niswa pe natj jay la ts'is la 'ünan jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mpes Jesús nin tjevele yupj jis lal: —Nun tjunucú la pülücj napj pajal 'üsüs la tjejay. Nin la tjejay Mpapay tjevele jin. ¿Cana la tjejay mpes quelel na 'ü'ná pe mpes? ");
INSERT INTO jicNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yupj jupj wola tjowelepj: —Ma 'üsüs la tjejay mpes quelel 'i 'ü'nam. Jipj tjevelen malala Dios lal, mpes quelel 'i 'ü'nam. Yom p'in jipj; newa nin jipj velen jipj p'iyá Dios. ");
INSERT INTO jicNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús tjevele yupj lal: —Malala tulucj napj tjevelé. Nun to'á Dios Popel. Jupj Popel vele Dios tjevelá israelpan noypan jis lal pajal püna. Dios tjevele: ‘Nun Dios jinwá gente jis lal. Jü'tǘ Dios mpes.’ ");
INSERT INTO jicNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cupj selecj Dios Popel lovin t'üc' vele; jupj Popel tjevele israelpan noypan Dios jinwatsja yupj. Israelpan nenem, Dios jepapan lis tjiji yupj, mpes nintsja yupj. Gente p'intsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Napj más 'üsüs yupj jis lal. Mpapay la ntjet'á napj ca jupj jos jin la mejay. Nin tjejyama nosis nt'a. ¿Tsjan mpes welé nun napj velé malala Dios lal, napj velé na napj Dios Jatjam? ");
INSERT INTO jicNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Napj ma pajal 'üsüs la cüjay Mpapay liji jinwá, 'ücj ma quelel poné napj velé napj p'iyá po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","T'üc' way pajal 'üsüs lejay Mpapay liji jinwá. Ca nacj nun ma poné napj p'iyá Dios Jatjam napj velé mpes p'in. Nun 'ücj ca mponé napj Dios Jatjam napj pajal 'üsüs lejay mpes. Nun poné napj 'üsüs lejay Mpapay Dios mpes, nun ca jus nlayé Mpapay napj mpes já'asa, ca jus nlayé napj jupj mpes wa 'os —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesús nin tjevele na, judiopan jis jepapan niswa quelel ntji'lin̈ jupj sa tül. Custjay ma polel ntji'lin̈ jupj. Tjemey. ");
INSERT INTO jicNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Niswa 'üsǘ na'aj po'ó tjemey, 'üsǘ Jordán ló jupj. Ne'aj tjemey Jesús, Juan gente bautizar lis tjiji nt'a püná. Ne'aj tüpü'ü. ");
INSERT INTO jicNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne'aj pülücj tjiquil Jesús nt'a. Yuwá javeleptsja: “Juan lovin ma pajal 'üsüs la tjiji qjuisin la 'üsüs lo jay Dios mpes tjevele jupj. Mop'iyá pjü way Juan tjevelá niná yomen po'ó, pjü t'üc' waytsja.” ");
INSERT INTO jicNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pülücj topon Jesús lal ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yom pjaní malala jos tepyala. Jupj Lázaro lotsja. Betania mo'o pǘ'ütsja. Ne'aj Betania mo'o tapatja wa Lázaro to'opan manas. María lotsja pjaní wa, Marta lotsja pjaní wa. ");
INSERT INTO jicNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(María niná quepan qjuis Jepa Jesús tsjom jas tjecjyo'la perfume lal. Jay pjucj ts'üil lal tjapjaja la tjiji jupj tsjom. Jupj jüpülücj Lázaro tsjyúnatsja.) ");
INSERT INTO jicNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro tsjyuna na, jupj to'opan taná tjowelepj qjuis Jepa Jesús mpes: “Malala jos jipj jemica, jupj ne pajal quelel lejay jipj”. ");
INSERT INTO jicNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús tjapjaca na niná, tjevele: “Jupj malala jos mpes, la p'a ca sin mü'üsüs pajal 'üsüs Dios. Ca jus nlayecj pajal 'üsüs Dios Jatjam. Ma nin tepyala la mas jupj”, nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús pajal quelel la síjitsja conas, Marta 'ots'ipj, María 'ots'ipj, Lázaro 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mop'iyá ma len̈ way tjemey Jesús jupj nt'a. Newa ts'ac' mat'e tjá'asa ne'aj, tjá'asa nt'a. Jupj seletsja jupj ca 'üsüs la mijis locopyaya. ");
INSERT INTO jicNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Locopyaya ts'ac' mat'e na, tjevele discipulopan jis lal: —Mas quinam Judea mo'ó niswá, Lázaro pü'ü nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mpes Jesús discipulopan tjowelepj jupj lal: —Pajal nin qjuiyola jipj jay Judea mo'ó, judiopan jis jepapan patja nt'a. Nawaja'a p'in quelel ja'ünantsja jipj pe mpes. ¿Ncu yupj patja nt'a quelel jay jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Jesús jis lal tjevele: —Jyawca na, hora dóceya jyawca nin jawas. Jaw na wine, ma pojo. 'Ücj nyuca jupj, lots'ac' jyawca mpes. Püste wine p'in pojo, jupj jaw cjuwá mpes. Nin p'iyá napj lal. 'Ücj jum quinam. Jaw na jinwá napj lal custjay. Ma malala ma palas custjay. ");
INSERT INTO jicNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nin tjevele na jupj, tjevele wa discipulopan jis lal: —Cupj qjuis cajamica Lázaro tjejyá. Napj ca lya miyawǘ jupj, ca jas müjünsüs. ");
INSERT INTO jicNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mpes discipulopan tjowelepj qjuis Jepa lal: —Jupj 'a tjejyá, quina wa ca mü'ü'süs jupj. Discipulopan ma sin tji'yüsa Jesús tjevelá, mpes nin tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús quelel véletsja Lázaro tepe'e quinam. Nin mpes jupj tjevele “tjejyá” quinam. Discipulopan yólatsja Jesús nin quelel véletsja Lázaro nasa tjejyá p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mpes Jesús 'üsüs way tjevele yupj jis lal: —Lázaro tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Más 'üsüs ca nsem nun mpes ma tjo'os napj Lázaro nt'a, malala jostsja na. Napj ca pajal 'üsüs la mejay quinam jupj mpes, ne nun ca mponé napj nin po'ó. Nin mpes 'ücj najas ma tjo'os ne'aj jupj nt'a jupj malala jostsja na. Mas quinam jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jesús nin tjevele na, Tomás tjevele discipulopan p'a wa jis lal: —Mas wa ncupj, nca'lequecj wa Jesús lal. (Tomás 'a discípulo watsja. ‘Pjaní Popa Mát'eya’ lotsja wa jupj.) ");
INSERT INTO jicNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mpes Lázaro tüpü'ü nt'a tjemey Jesús, jupj discipulopan jis lal. Jus tjevyanta na, jupj jus nleya ts'ac' yulupjana tjejyawca quinam tepe'e Lazará. Ts'ac' yulupjana tjejyawca quinam jomwen jul tüpü'ü Lázaro jüp'üy. 'Ücj la tjajay la toc, judiopan lajay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lázaro tüpü'ü nt'a Betania lotsja ne'aj. Ne'aj way p'in Jerusalén nt'a, pülücj patja nt'a. Tucuc' pjaní way p'in ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne'aj way p'in, mpes judiopan pülücj tjiquil wa Jerusalén mpe yus la nuc Lázaro jüpülücpan, Marta pjaní wa, pjaní wa María. Tjiquil yus la nuc jis pülücj tepe'e mpes. Quelel 'üsüs javeleptsja yupj jis lal, ma ca pajal nin yola yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta jus nleya Jesús jac'. Jus nleya na, tjemey la nüjüsü. María newa wa nt'a tjá'asa. ");
INSERT INTO jicNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tjevele Jesús lal: —Jipj qui'á cücj, ma cüpa'istsja nquiway. ");
INSERT INTO jicNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Newa napj selé Dios ca mya 'ayas pjü way jipj le mon. ");
INSERT INTO jicNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús tjevele jupj lal: —Jiquiway ca niswa jas müjünsüs mpü'üm niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wola tjevele: —Napj selé jupj ca jas müjünsüs mpü'üm niswá, nin jawas tecya'lin̈ sin müjünsücj na. ");
INSERT INTO jicNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús tjevele jupj lal: —T'üc'. Napj p'iyá ca nin la mejay niná jiquiway mpes. Napj p'iyá ca sin müjünsǘ tecya'lin̈. Napj p'iyá nin lejay patjá. Napj lal japon, lovin ca mpatjam. Yupj cya'lin̈ na, newa ca mpatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Quina patja, napj lal japon, ma ca nca'lin̈ yupj lovin. ¿Min pyon jipj niná? —nin la tji'yüya Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta tjevele: —Napj pyon. Napj pyon jipj niná Yomen Dios tjevele ca jas majamas qjuis capj la p'acj. Jipj Dios Jatjam. Püna Dios nin tjevele jipj nosis nt'a ca ncuwim. ");
INSERT INTO jicNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta nin tjevele na, wo nt'a tjemey niswá. Tjevele ncuwim jüpülücj María. Jupj way lal p'in tjevele. Tjevele: —Nasa tjac' sin 'yüsa la sijá. Jupj la tjemyona jipj ca mim jupj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María niná tjapjaca na, len̈ way jas nisa, tjemey Jesús nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ma ne'as tjac' pülücj patja nt'a custjay. Newa Marta la nüjüsü nt'a tjá'asa jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María tjemey na, judiopan nepenowá newa wo nt'a tjatja cüiway tepe'e mpes. Yupj jus tjunuc jas nisa, len̈ way tjemey. Ma sin tji'yüsa tsjan mpes nin la tjiji. Yólatsja jupj tjemey jüpülücj toc pü'ü nt'a lo puyus ca nacj. Mpes cjüil tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María ne'as tjemey Jesús nt'a. Jus tjinyuca na, María palá nipi'tje jupj wolap'a'á. Tjevele Qjuis Jepa Jesús lal: —Jipj qui'á cücj, ma cüpa'istsja mpülücj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús jus tjinyuca María pajal li piyutsja. Tjinyuca wa judiopan María lal tjiquil pajal la puyuptsja wa yupj. Nin tjinyuca na, pajal 'aplijila way tepyala Jesús. Pajal jola tepyala jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jis la tji'yüya yupj jis lal: —¿Ca'aj tüpüntüpj jupj jüp'üy? —Was, jus nlayen —tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús la tipiya wa. ");
INSERT INTO jicNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mpes judiopan nepénowa tjowelepj: —T'üc' way quelel la tjíjitsja Lázaro. ");
INSERT INTO jicNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nepena yupj sin popa wa tjowelepj: —Jesús tji'yü'sa la tjiji ma nyucá. ¿Ncu ma polel tji'yü'sa la tjiji wa Lázaro, ma lo mas? ");
INSERT INTO jicNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Niswa pajal jola tepyala Jesús. Lázaro jüp'üy tüpü'ü nt'a tjac' quinam. 'Amá jul, neven nt'a, pǘ'ütsja jupj. Pe püné jun tapá já'asatsja jun vilicj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús tjevele: —Na'aj jas tentené pwen. Marta ne'aj já'asatsja. Tepe'e jüpülücj waytsja jupj. Tjevele Qjuis Jepa Jesús lal: —Pajal malala cjumsu quinam. Ts'ac' yulupjánatsja tepe'e nas. ");
INSERT INTO jicNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús tjevele jupj lal: —Quina ca jus nlayen Dios pajal 'üsüs. Niná nasa tjevelé jipj lal. Jipj pyon napj lal, ca jus nlayen Dios pajal 'üsüs —nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mpes na'aj jas tentené quinam pwen, jun cjol tepyala. Nin la tjajay na, Jesús tjevele Popay Dios lal. Jay la p'a'a tjinyuca, tjevele: —Wüi'is, Mpapay, jipj lal. Napj tjevelé na jipj lal, jipj ntje'an najastsjé. ");
INSERT INTO jicNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Napj selé lovin pjoc' napj velé na jipj lal. La p'a pülücj qui'á jatja, ma salejepj niná. Nin mpes 'ücj jis la pjac tjevelé jipj lal. Mpes ca mponecj jipj nin tjejyam —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tecyawaja tjevele na Popay Dios lal, Jesús yümücj tjevele: —Lázaro, pje'á was 'amá jul mpe. ");
INSERT INTO jicNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mpes jupj tjac', tepe'etsjé. Niswa nyucunú quinam. Newa jun tapá jas tjüvü'üntsja jupj. Pülül p'a wa jay tsupaptsja jupj. Mpes Jesús ne'aj jatja jis lal tjevele: —Jas 'osocté, 'ücj mim jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judiopan nepenowá María lal tjil ne'aj, mpes tjunuc wa Jesús la tjijá. Tjunuc na niná, yupj sin popa pajal pülücj topon Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nepena yupj sin popa ma topon lovin. Más ts'a 'in jis tepyala Jesús nin la tjiji mpes. Ma jisastsja pülücj japon Jesús lal. Mpes fariseopan nt'a tjil, yupj jis lal tjowelepj Jesús la tjijá. ");
INSERT INTO jicNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mpes sacerdote noypan 'a jis tjimyula fariseopan jis lal. 'A jis tjimyula na, yuwá jis la tjü'üy: —¿Tsjan ca la mijicj cupj? Yom niná pajal la pülücj pajal 'üsüs liji, yom p'in ma polel liji jinwá. Nin mpes sin 'yüsa la siji Dios jas tjejyama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cupj ma polel 'yayacj newa nin liji Jesús. Cupj 'yayacj Jesús nin liji, ca pjü mponecj jupj niná Yomen Dios tjevele ca jas majamas qjuis capj la p'acj. Yupj ca mvelecj Jesús judiopan jis Jepa. La mpa'nacj ca romanopan jis jepapan jis lal. Nin lajay nampa, romanopan ca ncul, ca pjü malala la mijicj cupj jyü'tücj nt'a. Ca mvelecj wa cupj ma polel jyü'tücj cupj qjuis gentá —nin tjowelepj yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pjaní ne'aj yupj sin popa, Caifás lotsja jupj. Año niná jupj sacerdote más pünetsja. Jupj tjevele yupj jis lal ne'aj: —Nun ma nusin 'yüsa jas tüpwes. ");
INSERT INTO jicNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nun ma jus nlayé más 'ücj cupj mpes Jesús mpa'is, ma ca judiopan pjü nca'lin̈. ");
INSERT INTO jicNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Niná jupj tjevele, jupj jola jin tuluctsja. Dios jola jin tjevele. Caifás sacerdote más pünetsja nin tepyala na, mpes Dios cus tjep'ya'sa 'ücj lo veles tsjan ca mpalas Jesús lal. Nin mpes t'üc' tjevele Jesús ca mpa'is judiopan mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pjü mpes wa tepe'e Jesús, judiopan mpes p'in tulucj. Jesús tepe'e, 'a jis mulus pjü way Dios ts'uyupj. Pjü Dios ts'uyupj, pjü jun ta'á patja, pjü jis pülücpan la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nin jawas nepé judiopan jis jepapan nin tjowelepj 'oyn la qjuijicj cü'ü'nacj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nin mpes Jesús ma tjuwine quinam pülücj patja nt'a, judiopan tapatja nt'a. Tjemey jupj Jerusalén mpe. Efraín mo'o tjemey. Pjaní way patja ne'aj 'in. Ne'aj p'intsja wa cjuwá nt'a. Ne'aj tüpü'ü Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nasa quelel fiesta p'a wa lajaytsja judiopan. “Dios Qjuis Capa Nipj Tjemey” nin lotsja fiesta niná. Mwalá way p'in, judiopan pülücj tjil Jerusalén nt'a yupj pjaní pjaní pátjatsja mpe. Judiopan püna la tjajay jin p'iyá la tjajay wa, salá jinwá jis la pal Dios lal. Ma nin la qjuijicj niná, ma polel fiesta la cüjaytsja yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yupj la tapaltsja Jesús ne'aj, Jerusalén mo'ó. Ma jus tjunuc, mpes yuwá tjowelepj Jesús po'ó, 'a jis tjimyula na Dios wo nt'a. Tjowelepj: “Jesús ma ncuwim ca nacj fiesta nt'a”. ");
INSERT INTO jicNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sacerdote noypan la pal watsja Jesús. Nin p'iyatsja fariseopan. Yupj tjüjütütj judiopan ca jis wala mvelecj ca'aj já'asa Jesús, yupj jus nlay na p'in. Quelel salejeptsja 'ücj jis la winin jis la tjilil Jesús, cus la tül. ");
INSERT INTO jicNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ts'ac' séisiya faltar custjay, fiesta mpes Jerusalén nt'a, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. Jesús jama watsja fiesta nt'a. Mpes Betania ne'as tjemey jupj, locopyaya quelel jámatsja Jerusalén mo'ó. Betania nt'a tüpü'ü Lázaro. 'In lacasana Lázaro malala jos tepyala, tepe'e. Jesús jas tjijyünsa la tjiji jupj, nyucunú tepyala niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mpes Jesús tjac' na Betania nt'a, Lázaro 'a jis tjimyula jupj jomicapan pülücj Jesús mpes, jis tja'ayapj tjalá. Jesús tjá'asa, tjelyaja jomicapan jis lal. Marta se 'áyatsja jis la las. Lázaro pjaní wa ne'aj já'asa, lyájatsja Jesús lal, la p'a jis lal wa. ");
INSERT INTO jicNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María Lázaro jüpülücj watsja. Jupj quelel 'üsüs líjitsja wa Jesús mpes. Nin mpes newa jalatsja na, Jesús tsjom perfume jas tjecjyo'la. Püné jas tjecjyo'la jupj, libra pjaní mpes jas tjecjyo'la. Perfume niná t'üc' way nardo p'in waytsja jupj. Pajal 'üsüs cjúmsutsja, pajal pülücj jaylactsja jupj. Tsjom jas tji'its'a na perfume mpes, María jas tjicjyücja jay ts'üil mpes. Wo jas tüpwes 'üsüs tjucjumsu perfume mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jesús discipulopan ne'aj jatja watsja. Yupj sin popa pjaní Judas Iscariote lotsja jupj. Simón jatjam waytsja jupj. Judas p'iyá malala la tjiji Jesús lal. P'a tjejyawca na jis capj tjep'ya'sa Jesús enemigopan jis la tjilil jupj. Judas tjevele: ");
INSERT INTO jicNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Malala pjü t'yu jupj. ¿Tsjan mpes ma vender la tjiji? T'emel 'ücj así 'yáyatsja t'emel cjuwá mpes. Pajal pülücj jaylacj ca nactsja perfumas. Yom año pjaní tsji' liji jaylacj ca nactsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nin tjevele jupj, mop'in ma t'üc' nin jólatsja t'emel cjuwá witjacj mpes. Jupj p'iyá jostsja t'emel. Pecj waytsja jupj. Judas jyámatsja t'emel pjü discipulopan yuts'a'á, Jesús juts'a'á wa. Yupj jis t'emel tüpweca neneyawá. ");
INSERT INTO jicNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús tjevele Judas lal: —Po ma cus tjeve'le jupj. Jupj selé napj ca ma pats', mpes nin la tjiji. Custjay 'ücj nin liji na napj mpes, quelel nin liji jupj. 'Ücj la ntjiji yupj ca ntoquecj napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","T'emel cjuwá jis lal ca mpatjaqué nun lovin. Napj ma ca mpü'üs nun jis lal lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judiopan pajal pülücj jus nlay Jesús Betania nt'a tjá'asa, mpes ne'aj tjil jus tjunuc. Tjil wa jus la nuc Lazará. Lázaro p'iyá tepe'e nawaja'a. Locopyaya Jesús jas tjijyünsa jupj, nyucunú tepyala niswá, mpes pülücj quelel sa nuctsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nin mpes sacerdote noypan yuwá nin tjowelepj 'onin 'ücj cü'ü'nacj wa Lazará. ");
INSERT INTO jicNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Judiopan pülücj ma quelel japontsja quinam sacerdote noypan jis lal. Quelel sa con̈tsja Jesús. Jupj pajal 'üsüs la tjiji Lázaro mpes, ne pajal pülücj topon Jesús lal quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ya pajal pülücj jus nlay Jesús jactsja Jerusalén nt'a. Yas way tjiquil fiesta lajay Jerusalén nt'a, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. ");
INSERT INTO jicNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mpes tjil la müjüsün̈ Jesús jümücj nt'a. La nyüjüsün̈ jepa püné jinwá. Manaca pjwel jatatsja pajal 'ücj jisastsja mpes. La tupuyupj: —'Üsüs pjac tjowelé Jesús po'ó. Dios pajal 'üsüs ca la mijis jupj mpes. Dios mpes vele jupj, Dios ne cupj qjuis Jepa Püné. Dios pajal 'üsüs liji israelpan jis Jepa lal —nin tjowelepj Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jerusalén mo'o jámatsja na, Jesús soysoy la tepyala, jus tjinyuca. Casá tjá'asa tjemey. Dios Popel nin véletsja nin ca la mijis Jesús. Ninana tjevelá Dios Popel: ");
INSERT INTO jicNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Po ma locj tjeyá nun, Jerusalén mo'o potjaqué. Nun jis jepa ca ncuwim. Soysoy casá ca ma'ajam, ncuwim.” ");
INSERT INTO jicNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nin tepyala na, Jesús discipulopan ma sin tji'yüsa Dios Popel tjevele jin tepyala. Locopyaya Jesús tepe'e, niswa jas tjijyünsa, tüpü'ü. Dios pajal püné la tjiji Jesús. Niná pjü tepyala na, discipulopan yola tepyala Dios Popel nin tjevele nin ca mpalas jupj jas tjejyama lal. Yola tepyala nin p'iyá la tjajay Jesús lal, Jerusalén mo'o tjac' na. ");
INSERT INTO jicNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pülücj Jesús lal tjelejen̈ püna p'in, Lázaro niswa tüpü'ü la tjiji na. Yupj tjunuc, tjepjyacan̈ wa Jesús tjevele ncuwim Lazará 'amá jul mpe. Tjunuc Lázaro nyucunú tepyala niswá, pje'á tjac'. Yupj tjunuc mpes, tjepjyacan̈ mpes wa, lovin la p'a jis wala javelepj watsja niná tepyalá. ");
INSERT INTO jicNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Javeleptsja mpes, pajal pülücj jus nlay Jesús pajal 'üsüs la tjiji, yom p'in ma polel liji jinwá. Nin mpes ca jus cülayecj Dios jas tjejyama jupj. Mpes tjil la nyüjüsün̈ Jesús, Jerusalén nt'a jactsja na. ");
INSERT INTO jicNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseopan ts'a 'intsja pajal pülücj tjil la nyüjüsün̈. Yuwá tjowelepj: —Pjü quelel lijictsja ma la tjijicj cupj lovin. Más pülücj jupj lal japon quinam. Pjü way quelel sa con̈ Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lovin pülücj tjil fiesta niná nt'a, pjü año na. Tjil Dios wo nt'a Jerusalén nt'a. Tjil la veles Dios pajal 'üsüs, pajal püné. Fiesta nt'a tjil wa griegopan nepenowá, judiopan tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Griegopan Jesús quelel sa nuctsja, jupj lal la veles. Mpes tjil Felipe nt'a. (Jesús discípulo watsja Felipá. Betsaida mpe 'eseptsja jupj, Galilea mpe se jütütj nt'a.) Griegopan tjowelepj Felipe lal: —Jesús quelel si nucucj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mpes Felipe tjemey, Andrés lal tjevele niná. Manas tjil Jesús nt'a, jupj lal tjowelepj griegopan quelel sa nuctsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús yupj jis lal tjevele: —Len̈ way Dios ca gente sin mü'üsüs la mijis napj pajal 'üsüs, pajal püné. Napj p'iyá niná Yomen Dios jas tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","T'üc' way ma pats' ca napj. Ma ni pü'í, nasapj ca mpü'üs. Ni pü'í, pajal pülücj ca mpatjam napj lal. Nin ca nsem setel sine jin p'iyá. Setel pjaní sine popé pajal pülücj vyala. ");
INSERT INTO jicNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nepénowa po quelel patja nosis nt'a. Ma jisas malala se palá, mpes ma polel lajay Dios jos jin. Yupj ma ca polel mpatjam Dios lal. Nepénowa ma nin yola ncu ca mpatjam nosis nt'a. 'Ücj wa cya'lin̈ Dios jos jin lajay mpes. Nin mpes yupj ca mpatjam wa lovin Dios lal. Nin lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Najas napj mpes tsji' lajay nin p'iyá lajay napj lejay jinwá. Nin lajay niná, napj nomozopan ca nsem yupj. Napj ca mpü'üs nt'a, ne'aj ca mpatjam wa namozopan. Napj mpes tsji' lajay, Mpapay ca mveles wa yupj 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","”Pajal 'aplijila way napj quinam. Newa ma ca mvelé Mpapay lal: ‘Ncapj tjep'ya'sa ma ma 'ü'nacj’. Tjacuwis malala la pal napj, la mas napj. Nin mpes tjacuwis nosis nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jesús Popay lal tjevele: —Mpapay, pjü sin tjü'üsüs lis mijin jipj pajal 'üsüs, pajal püné wa. Tjevele na niná, tsjun po'o nepé vele tjapjaca niná: “Nasa sin tji'yüsa la tjejay napj pajal 'üsüs, pajal püné wa. Nin ca la mejay niswá.” ");
INSERT INTO jicNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pajal pülücj ne'aj tjatja Jesús tjá'asa nt'a. Tjepjyacan̈ wa tsjun mpe tjevele. Mop'in ma jus nlay tsjan niná yupj tjepjyacan̈. Nepénowa tjowelepj t'i'ila pjac tjepjyacan̈. Nepénowa tjowelepj: —Ángel nepé tjevele Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mpes Jesús jis lal tjevele: —Tsjun mpe vele tjapjaca, napj mpes tjapjaca tulucj. Napj selé Mpapay pjoca. Nun mpes vele tjapjaca tsjun nepé, ca nun mponé napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Len̈ way ca malala jis mpalas gentas, malala la tjajay mpes. Quina diablo jyü'ta nosis nt'a. Malala ca mpalas wa jupj. Len̈ way Dios na'aj ca la nts'iyas jupj, ma müjü'tüs diablú. ");
INSERT INTO jicNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Napj ca pajal 'üsüs la mejay gente mpes. Niyom ca nin müjünsücj, campanya ca ma valacj napj. Nin tepyala na, napj pjü gente ca jis capj mp'acj mponecj napj mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jupj nin tjevele sin 'yüsa la mijis nin ca la mijicj mpa'is. ");
INSERT INTO jicNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jupj tjevele tjepjyacan̈ pajal nin yólatsja jupj tjevele mpes. Tjowelepj: —Dios Popel vele Jepa Püné Dios se jamá qjuis capj la p'acj lovin ca mpü'üm jupj. Ninana selecj cupj. Jipj velen jipj p'iyá niná Jepa Püné Dios jas tjejyamá, mop'in velen wa yupj campanya ca mvalacj jipj, mya pats' ca. Jipj tulucj ca nacj Jepa niná Dios se jamá. ¿Pjacj ne jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús tjevele yupj jis lal: —Tsjicj way p'in ca mpü'üs nun lal. Napj jaw jinwá nun mpes. Nusin 'yüsa lejay Dios mpes. Napj nun lal pü'üs na, nusin tjü'üsüs nun. Ma nusin 'yüsa napj mpes, lovin ma ca jus nlayé 'onin 'ücj la püt'üs Dios lal. Ma nusin 'yüsam, püste nt'a lowiqué jinwá. Püste nt'a wine, ma selé ca'aj jama jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Napj nun jis lal pü'üs na, toponé nun napj nin po'ó. Napj po'o poné, jaw tsjictjacj jinwá ca nsem nun. 'Ücj ca nusin mü'üsüs Dios mpes. Jesús nin tjevele na, tjemey. Yupj ma polel jus la nuc nt'a tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús pajal pülücj 'üsüs la tjiji sin la 'üsüs jis la jay Dios jas tjejyama jupj. Yupj tjunuc pajal 'üsüs la tjijá. Newa ma topon jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mpes nin tepyala Isaías tjevelá püná Dios mpes. Isaías profétatsja jupj. Ninana jupj tjevele Dios lal: “Yupj ma topon cupj tjevelecj jipj mpes. Ma wa jus nlay tsjan mpes pajal 'üsüs lejay jipj.” ");
INSERT INTO jicNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaías tjevele wa tsjan jis tepyala ma quelel japontsja mpes. Tjevele: ");
INSERT INTO jicNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dios yun tulucj jinwá lis tjiji yupj, mpes ma sin 'yüsa tsjan niná yupj januc. Jupj lis tjiji yupj ma polel jisas tsjan 'üsüs, mpes ma t'üc' way sin 'yüsa yupj. Yupj newa ma quelel sa con̈ Dios, mpes napj ma polel lejay yupj ca 'üsüs jis mpalas Dios lal.” ");
INSERT INTO jicNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Niná Isaías tepyaca Jesús po'ó. Jesús nosis nt'a cuwis secj p'in, Isaías jus tjinyuca. Jus tjinyuca jupj pajal 'üsüs, pajal püné. Nin mpes nin tjevele Jesús po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judiopan jis jepapan pülücj ma topon Jesús lal, mop'in nin, yupj sin popa pülücj topon jupj lal. Newa ma quelel javeleptsja nasa topon yupj. Lacj jeyaptsja fariseopan jis lal. Fariseopan ma jisastsja judiopan jis la veles Jesús niná Yomen Dios tjevele ca jas majamas jis capj la p'acj. Fariseopan tjowelepj judío ninana cüveles Jesús po'ó, yupj ca müjü'tücj jupj lovin ma polel ncuwim ne'aj judiopan 'a si mulú nt'a. Nin mpes lacj jeyaptsja. ");
INSERT INTO jicNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Malálatsja ma quelel javeleptsja nasa topon Jesús lal. Yupj po jisastsja la p'a 'üsüs yola yupj mpes. Ma pajal nin yólatsja ncu Dios 'üsüs jólatsja yupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús pajal yümücj tjevele ne'aj tjatja jis walap'a'á: —Napj lal pyona, ma pyona napj lal p'in. Pyona wa napj nin tjejyama lal. ");
INSERT INTO jicNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nus nyuca, si nucú wa nin tjejyamá. ");
INSERT INTO jicNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Napj tjacuwis nosis casa'á, ca jyawca jinwá nsem napj gente pjü way mpes. Dios mpes sin 'yüsa lejay. Napj lal japon, ca sin mü'üsüs Dios po'ó. Püste lyawun̈ jinwá tulucj yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","”Nepénowa napj velé pjyacan̈, newa ma nin lajay napj velé jin. Napj p'iyá ma ca mvelé yupj malala la tjajay. Jis capj la tül mpes tjacuwis tulucj. Napj nosis nt'a tjacuwis jis capj la p'acj gentas, 'ücj jis la patj Dios lal. ");
INSERT INTO jicNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","La p'a ca mveles malala la tjajay yupj, yupj ne ma quelel la najay, ma wa jisas napj velé. Pjü way napj tjevelé nin ca mveles yupj malala la tjajay. Nin ca nsem nin jawas tecya'lin̈ sin müjünsücj na. ");
INSERT INTO jicNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Napj lovin vele secj napj nola jin. Mpapay nin tjejyama, ntjijütüta tsjan la veles, ne nin tjevelé napj. ");
INSERT INTO jicNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Napj selé jupj tjevele mpes gente ca jus nlayecj 'onin nyuca 'ücj lo püt'üs jupj lal lovin. Mpes pjü way Mpapay vele napj lal, niná pjü way nin p'iyá velé napj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Len̈ way ca fiesta la mijictsja yupj, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. Jesús seletsja quina ca mim nosis mpe, Popay nt'a ca mim niswá. Lovin quelel lis tjiji jupj lal japon, nosis nt'a tapatjá. Jesús tüpü'ü na nosis nt'a, lovin quelel la síjitsja pajal. ");
INSERT INTO jicNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nasa quelel t'yaja na, Jesús discipulopan jis lal tjá'asa lo las. Judas Iscariote pjaní wa ne'aj já'asatsja. Simón jatjam waytsja jupj, Judas. Jupj nasa quelel jis capj p'yá'satsja Jesús enemigopan 'ücj la tjilil Jesús. Diablo nin la tjiji Judas nin jólatsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús seletsja jupj Popay tje'yaya jupj p'iyá 'ücj lo jay pjü. T'üc' way pjü 'ücj la tjiji Jesús. Seletsja wa Dios mpe tjac', seletsja wa ne niswa Dios nt'a ca mim. ");
INSERT INTO jicNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mop'in mozo jinwá la tjiji jupj. Jas nisa jupj tjelyaja mpe, jas quip pje'apa jas tji'ipje. Pülül wolapé tjevyala, mozo liji jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Locopyaya 'üsǘ mo'o t'yu trasto mo'ó, jupj discipulopan jis tsjam sin la patsj. Pjaní pjaní jis tsjam sin tepe'e. Pülül jupj wolapé tjevyala mpe jis tsjam tjapjaja la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tjac' wa Simón Pedro nt'a, jupj tsjom sin la patsj. Tjac' na, Simón Pedro Jesús lal la tji'yüya: —¿Ncu napj ntsjam ca jas mpa'in jipj? Jipj napj Nejepa. Ma najas jipj nin lejay napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús jupj lal tjevele: —Po quina ma jin 'yüsa tsjan mpes nin lejay napj. P'a jyawca na ca jin mü'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro tjevele: —Lovin ma ca ntsjam jas mpa'in. Jesús jupj lal tjevele: —Napj ma pjü salá way la 'ejay jipj, jipj ma polel ncapj cyon̈. ");
INSERT INTO jicNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mpes Simón Pedro tjevele Jesús lal: —Pajal quelel cyapj cyon̈ jipj. Mpes ma najas ntsjam p'in mpa'in. Nin tepe'e namas, nay pjucj 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús tjevele jupj lal: —'Ücj tsjyam way p'in jas la patsj quinam. Tja'as'üm na, salá way jipj. Ma jyas la 'as'üs niswá. Tjuwin mpes tsjyam way p'in te. Tsjyam jas tepyatsj na, p'yüy jas tüpwes salá way. Nun salá way jinwá quinam Dios lal. Jupj ma nin jola quinam nun malala la tjüjí. Mop'in ma nun pjü way salá jinwá Dios lal —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús seletsja pjacj ca jis lal ncuwim jupj enemigopan jis la tjilil jupj. Nin mpes nin tjevele: “Mop'in ma nun pjü way salá jinwá Dios lal”. ");
INSERT INTO jicNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tecyawaja na sin tepe'e jis tsjam, jas quip pje'apa jas tücüi'pe niswá, 'etjele niswá. 'Etjele na, yupj jis lal tjevele: —Napj sin tepyatsj quinam nutsjom. ¿Ncu jus nlayé tsjan nusin tji'yüsa la tjejay nin la tjejay na? ");
INSERT INTO jicNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nun welé napj nusin 'yüsa la sejay, welé wa napj nun jis Jepa. 'Ücj niná nin welé na. T'üc' way niná napj niná. ");
INSERT INTO jicNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Püné napj nun lal. Napj nun jis Jepa, nusin 'yüsa wa lejay; así nin napj nusin tepyatsj nutsjom. Napj nun jis mozo jinwá nin la tjejay napj. Mpes solejé más 'ücj nun pajal 'üsüs lojí nunwa mpes, mozopan jinwá. Tsjictjacj way nun pjü. ");
INSERT INTO jicNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Napj nin la tjejay mpes nun ca jus nlayé más 'ücj ca nin p'iyá la müjí napj la tjejay jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'Ücj nin lejay napj, 'ücj wa nin lojí nun. T'üc' niná. Nun más noypan tulucj napj lal. Mozo más püné tulucj jupj patrón lal. Auxiliar más püné tulucj jyü'ta lal. ");
INSERT INTO jicNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nun jus nlayé quinam más 'ücj lovin nin lojí nunwá. Nin lojí lovin, ca 'üsüs nujisas nsem —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jesús tjevele wa yupj jis lal: —Pjü nun mpes tulucj nin velé niná. Napj selé nun popa pjaní ma ca nin la mijis napj tjevelé. Napj la nu t'ya nun ca tsji' la müjí napj mpes. Napj pajal 'üsüs nujus nyuc pjü. Napj selé ca nin mpalas Dios Popel vele jin. Vele: ‘Najamica napj lal lyájatsja, po quelel malala la niji quinam’. Nin ca nsem, ca nin mpalas jupj Popel vele jin. ");
INSERT INTO jicNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quina velé nun jis lal nin ca mpalas. Nin tepyala tulucj custjay. P'a jawas ca mpalas. Mpes nin tepyala na napj tjevelé, newa ca mponé nun napj Dios Jatjam. ");
INSERT INTO jicNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","”Napj ca nusin majam tsji' la müjí napj mpes. La p'a wa sin majam wa ca, tsji' la mijicj wa ca napj mpes. Jil na napj mpes, nepénowa yupj jil nt'a ca 'ücj jisas nsem yupj tjiquil. 'Ücj jisas yupj tjiquil, t'üc' way 'ücj jisas wa napj mpes, napj p'iyá tjacuwis jinwá. 'Ücj jisas napj tjacuwis, 'ücj jisas wa Dios mpes, jupj p'iyá tjac' jinwá. Jupj nin tjejyama napj —tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","T'üc' nin tjevele na Jesús, 'aplijila waytsja pajal. Jupj seletsja tsjan ca mpalas, mpes niná tjevele yupj jis walap'a'á: —Nun popa pjaní malala nyuca la mijis napj lal. Jupj ca jis lal ncuwim napj enemigopan, ca yupj ma tjililin̈. T'üc' way ca nin mpalas. ");
INSERT INTO jicNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nin tjevele na, discipulopan yuwá yus tjunuc. Pues ma salejeptsja pjacj mpes tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Discípulo pjaní Jesús lal tjá'asa. Jesús pajal quelel líjitsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mpes Simón Pedro la seña tjevele niná discípulo lal la 'yüya nucus pjacj mpes nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mpes discípulo niná más 'in jun 'asas tjemey Jesús nt'a, la tji'yüya: —¿Pjacj mpes velen? ");
INSERT INTO jicNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús jupj lal tjevele: —Pan tsjicj way caldas mo'o ts'yuc, 'ya lyaja jupj; napj jupj po'ó velé. Mpes Jesús pan tsjicj way 'in tjelepta, caldas mo'o ts'yuca, tje'yaya nlajas Judas. Judas Simón Iscariote jatjam waytsja. ");
INSERT INTO jicNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas nt'ya na pansas, len̈ way Satanás jupj jos mo'o tjemey. (Satanás diablo jupj. Lapanen jis jepa jupj.) Jesús seletsja tsjan ca la mijis Judas quinam, mpes Judas lal tjevele: —Niná jipj quelel lejay, más 'in len̈ way la mijin jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","P'a wa Jesús lal tjatjá ma sin tji'yüsa tsjan mpes nin tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas t'emel jyámatsja pjü discipulopan yuts'a'á, Jesús juts'a'á wa. Mpes discipulopan nepénowa yólatsja Jesús nin tjevele jupj lal: “Jutja, jaylacj la mijin cupj qjuisas fiesta mpes nlajacj”. Nepénowa yólatsja jupj tjevele: “Jutja, jis ma'ayan niná gente jis t'emel cjuwá mpes”. Nin yólatsja yupj. Ma nin tjevele Jesús. Discipulopan ma sin 'yǘsatsja la p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas nt'ya na pan tsjicj way Jesús tje'yayá, len̈ way tjemey jupj. Pǘstetsja. ");
INSERT INTO jicNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas tjemey na, Jesús tjevele: —Napj p'iyá niná Yomen Dios jas tjejyamá. Quina gente ca nucucj ca 'üsüs la mejay napj. Napj lejay mpes ca jus nlayecj wa Dios pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Napj nin lejay gente jus nlayecj Dios pajal 'üsüs, pajal püné. Nin mpes wa Dios p'iyá ca sin 'yüsa la mijis napj pajal 'üsüs, pajal püné wa. Len̈ way ca nin la mijis jupj —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Niná tjevele wa: —Tsjicj way p'in ca mo'os nun lal quinam, nun napj tsjictjacj jinwá. Nun pajal ca quelel nus nucú. Nun ca jisas nsem napj ca nucopj mp'acj. Nin p'in, nun ma polel lowú napj jum nt'a. Nin tjevelé judiopan jis jepapan jis lal; quina nin wa velé nun jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mpes quina ca nu jyütütj tsjan la müjí, nenem 'a seyasa way. Ninana nu jyütütj: nunwa quelel la tjüjí nun. Napj quelel la nutjejay jinwá, najas nin p'iyá quelel la sojí nunwá. ");
INSERT INTO jicNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nun lovin quelel la sojí nunwá, pjü ca jus nlayecj nun napj discipulopan. Ca jus nlayecj nusin tji'yüsa napj mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro la tji'yüya Jesús lal: —¿Ca'aj mim jipj? Jesús jupj lal tjevele: —Napj jum nt'a jipj ma polel ncapj cyon̈ quinam. P'a jyawca na ca ncapj ncon̈con ne'aj, napj jum nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro tjevele jupj lal: —¿Tsjan mpes ma polel cyapj cyon̈ quinam napj? 'Ücj napj lal ni pü'í jipj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús jupj lal tjevele: —T'üc' tulucj 'ücj jipj lal jipj 'i pü'í napj mpes. Castlyaj la puyú secj p'in yacjaj, la con ca mvelen jipj ma nus nyuc. T'üc' niná —nin tjevele Jesús Pedro lal. ");
INSERT INTO jicNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús tjevele jupj discipulopan jis lal: —Po ma pajal nin nujola t'as napj ca mis mpes. Nasa toponé Dios pajal 'üsüs liji nun mpes. Nin p'iyá mponé wa napj pajal 'üsüs lejay nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mpapay wo pajal püné, pajal la püné ne'aj, pülücj ne'aj mpatjam. Napj ne'aj ca mis 'ücj la mejay ne'aj, nun 'ücj mpatjaqué nt'a. T'üc' way. Ma t'üc' nacj, ca cüveletsja niná t'üc' tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Napj ca mis 'ücj la mejay nun mpatjaqué nt'a. T'üc' way ca nin la mejay. Niswa ca ncuwis, ne ca nun jis lal mis napj lal mpatjaqué. Mpes napj pü'üs nt'a ne'aj wa ca mpatjaqué nun lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nun solejé 'onin ne 'ücj lowú napj jum nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás tjevele Jesús lal: —Ma selecj ca'aj jay jipj. Mpes ma wa selecj 'oyn nyuca ne'as la winin. ");
INSERT INTO jicNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús tjevele Tomás lal: —Napj mpes p'iyá ca ne'as jay ne'aj, Dios nt'a. Napj mpes p'iyá ca nusin mü'üsüs t'üc' way Dios po'ó. Napj mpes p'iyá ca jipj mpü'üm jupj lal. Napj mpes way p'in 'ücj la winin Mpapay nt'a. Ma polel la winin jupj nt'a p'a 'isin. ");
INSERT INTO jicNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jesús tjevele wa pjü jupj discipulopan jis lal: —Nun jus cülayé pjacj ne napj, ca jus cülayé wa pjacj Mpapay. Quina t'üc' way solejé pjacj Mpapay, jus tjunucú wa jupj quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe tjevele jupj lal: —Qjuis ma'ayan jus nucucj Pyapay. Ninana qjuisas p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús jupj lal tjevele: —Pajal püs tüpü'üs nun jis lal. ¿Ncu ma jus nlayen pjacj ne napj? Nun popa nus tjinyuca na, nasa jus tjinyuca wa Mpapay. ¿Tsjan mpes velen: ‘Qjuis ma'ayan nucucj Pyapay?’ ");
INSERT INTO jicNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ncu ma pyon Mpapay napj mpes já'asa? ¿Ncu ma pyon napj Mpapay mpes 'os wa? Nin p'iyá ncupj. Napj tjevelé nun lal, ma napj nola jin tjevelé. Mpapay najas mo'o pü'ü. Jupj tsji' liji jupj jos jinwá napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Najas mponé niná napj velé. Napj Mpapay mpes 'os. Mpapay napj mpes já'asa wa. Nun ma poné napj nin tjevelé mpes p'in, más 'ücj ca mponé napj pajal 'üsüs way lejay mpes. Mpapay Dios liji jinwá 'üsüs lejay napj. ");
INSERT INTO jicNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","”Napj mpes pyona, nin p'iyá ca la mijis napj lejay jin p'iyá. T'üc' niná. Más 'in 'üsüs ca la mijis wa napj la tjejay lal. Napj ca mis mpü'üs Mpapay nt'a, mpes 'ücj ca 'üsüs la mijis. ");
INSERT INTO jicNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Napj ca pjü la mejay nun lo moná napj lal, nun lo moná na napj mpes. Nin ca la mejay la p'a sin mü'üsüs la mejay Mpapay pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pjü 'ücj lo moná napj lal, napj mpes lo moná na. Napj mpes lo moná, pjü ca la mejay —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús tjevele wa yupj jis lal: —Nun quelel la nojí, napj nu tjijyütütj jin ca la müjí nun. ");
INSERT INTO jicNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Napj p'iyá ca la mon Mpapay lal jupj ca p'a wa jas majamas nucopj la p'acj. Mpes nin ca la mijis Mpapay. P'a wa ca ncuwim nun nt'a nucopj la p'acj. Nucopj ncon̈cos lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ninana Dios Cjües jupj. Jupj gente sin 'yüsa liji t'üc' way Dios po'ó. Dios ma jisas ma polel jis la ta'es Dios Cjües yupj jisas mo'ó. Yupj ma jus nlay jupj já'asa. Ma salejepj pjacj jupj, mpes nin. Nun solejé cana Dios Cjües. Jupj nun jis lal pü'ü, ne jupj ca mpü'üm nujos mo'ó p'a jyawca na. ");
INSERT INTO jicNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","”Napj jum na, ma ca nusapj nacj. Ncuwis ca nun nt'a niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Po quina way nosis casá patjá ma ca nus nucucj niswá; nun p'in ca nus nucú niswá. Napj pü'üs mpes, nun mpatjaqué wa ca. ");
INSERT INTO jicNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nin jawas, Dios Cjües tjac' na nujos mo'o la püt'üs, nun ca jus nlayé napj Mpapay mpes 'os. Ca jus nlayé wa nun napj mpes jotjaqué wa. Ca jus nlayé napj nun mpes 'os wa. ");
INSERT INTO jicNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","¿Cana quelel la niji? Nun popa selé napj jyütütj, liji wa niná, ninana quelel la niji t'üc' way. Jupj quelel la niji na, Mpapay ca quelel la mijis jupj. Napj ca quelel la mejay wa jupj, ne ca mis jupj nt'a, jas mü'üsüs ca la mejay jupj napj mpes —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesús nin tjevele na, Judas p'a wa (Judas Iscariote tulucj) la tji'yüya jupj: —¿Tsjan mpes jipj ca qjuisin mü'üsüs la mijin cupj p'in jipj mpes? ¿Tsjan mpes ma ca sin mü'üsüs la mijin pjü wa nosis casá patjá? ");
INSERT INTO jicNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús jupj lal tjevele: —Nun popa quelel la niji na, napj velé jin liji jupj. Ninana liji na, Mpapay ca quelel la mijis jupj, ne cupj ca nlaca jupj nt'a jupj jos mo'o la püt'üs. Pjü ma quelel la najay, mpes ma wa pjü nt'a ca nlaca la püt'üs yupj jisas mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma quelel la najay na, ma wa lajay napj velé jin. Nin mpes ma wa lajay Dios jos jinwá. Napj nusin 'yüsa lejay, ma napj nola mpes nin velé. Napj velé Mpapay jola mpes. Jupj nin tjejyama. ");
INSERT INTO jicNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","”Napj pü'üs nun lal p'in, nin tjevelé nun lal, nusin 'yüsa lejay mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dios Cjües tjac' na, jupj ca nusin mü'üsüs la mijis pjü way. Jupj ca la mijis nujola mpalas pjü way napj tjevelé nun jis lal. Jupj jac' nucopj la p'acj. Mpapay ca jas majamas jupj nun nt'a napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”Napj lejay ma nujola nsem pjü mpes. Napj ma nola jinwá, nin p'iyá ma nujola nsem lejay napj. T'üc' way nin lejay nun mpes. Más 'üsüs lejay nun mpes nosis casá patja lajay lal. Po ma pajal nin nujola t'as napj jum quinam. Ma wa locj meyá. ");
INSERT INTO jicNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nujola tapalas napj tjevelé nun jis lal. Tjevelé: ‘Napj jum nas quinam, niswa ca ncuwis nun nt'a’. Nun quelel la cüjí napj, 'ücj nujos nactsja nun napj jum Mpapay nt'a. Más püné jupj napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nin tjevelé quinam nun jis lal, ma nin tepyala na p'in, mpes nin tepyala na napj tjevelé, nun ca mponé napj nin po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","”Ma polel pülücj la veles nun jis lal quinam. Diablo jac' quinam. Jyü'ta jupj nosis casa'á. Jupj p'iyá ma polel malala la nqjuijis. ");
INSERT INTO jicNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Napj jum Mpapay jos jin lo jay. Najas nosis nt'a patja jus nlayecj ca napj pajal quelel lejay Mpapay, mpes pjü ni jütüta, pjü nin lejay napj. Mas quepé —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús tjevele jupj liji 'ücj ca 'üsüs la qjuijicj Dios jos jin. Ninana jupj tjevelá: —Napj uva 'üpǘ ts'il jinwá. Nun napj mpjel jinwá. Mpapay uva jis pjel t'yüjü lo valas jinwá liji jupj. Nin liji jupj nun mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yom uva pjwel t'yüjü, nyuca pjwel ma vyala, t'yüjü jupj. La p'a wa vyala nyuca, tsjicj way p'in t'yüjü jupj, más pülücj lo valas. ");
INSERT INTO jicNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ninana la tjiji quinam Dios nun mpes. Nun toponé napj tjevelé, mpes jupj la tjiji nun 'ücj lojí jupj jos jin. ");
INSERT INTO jicNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Najas lovin ncapj ncon̈có. Nun ncapj con̈có, napj ca nucopj ncon̈ wa. Nun ma ncapj con̈có, ma polel lojí Dios jos jin, yo pjwel t'ü ma vyala jinwá. 'Ücj ton̈ca na, 'ücj lo valas. ");
INSERT INTO jicNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”Napj uva 'üpǘ ts'il jinwá. Nun mpjel jinwá. Nun lovin ncapj con̈có, napj nucopj cyon̈ wa, t'üc' way nun ca pajal 'üsüs la müjí Dios jos jin. Napj ma nucopj p'yacj, nun ma polel lojí Dios jos jin. ");
INSERT INTO jicNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nun popa ma ncapj cyon̈ca, yo pjwel na'aj la ts'iya jinwá jupj. Yo pjwel na'aj la ts'iya, ts'üique jupj. Ts'üique mpes yom t'e'enca jupj, 'amá li ts'iyá, mpem ca quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","”Nun lovin ncapj con̈có, nun lovin lojí wa napj tjevelé, nun 'ücj lo moná Dios lal nun nujos, ne nin ca la mijis jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nun pajal 'üsüs lojí Dios jos jin, la p'a ca jus nlayecj Dios pajal 'üsüs, pajal püné. Ca jus nlayecj wa t'üc' way nun napj discipulopan. ");
INSERT INTO jicNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mpapay quelel la niji jinwá, nin p'iyá napj quelel la nusejay nun. Lovin ncapj ncon̈có; nin lojí, napj ca quelel la numejay lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nun nin lojí napj tjijyütütj, napj ca quelel la numejay lovin. Nin p'iyá napj lal. Mpapay ntjijütüta jin la tjejay napj, mpes jupj quelel la niji lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","”Najastsja 'ücj nujos nsem nun lovin, napj 'ücj najas jinwá. Nin mpes ninana tjevelé nun jis lal. La tjüjí na napj tjevelé jin, ca 'ücj nujos nsem nun pajal. ");
INSERT INTO jicNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ninana napj nu jyütütj: nunwa quelel la nutjüjí. Napj quelel la nutjejay jinwá, nunwa quelel la nutjüjí. ");
INSERT INTO jicNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yom pjaní way pe'e jis capj la p'acj jomicapan, ninana más püné quelel liji pjü jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nun lojí napj nu jyütütj, nun napj najamicapan. ");
INSERT INTO jicNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Napj ma velé quinam nun napj namozopan. Mozo ma selé tsjan mpes jupj patrón liji lijá. Quina velé nun napj najamicapan. Pjü Mpapay tjevele napj lal, pues pjü nusin tji'yüsa la tjejay nun. Nin mpes velé nun napj najamicapan. ");
INSERT INTO jicNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","”Nun ma la ntjet'á napj. Napj la nu t'ya nun. Napj nusin tjejyam nun pajal 'üsüs la müjí Dios jos jin. Lovin ca 'üsüs mpalas nun 'üsüs la tjüjí mpes. Nin mpes, pjü lo moná Mpapay lal napj mpes, pjü ca nu ma'ayas jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ninana napj nu jyütütj nun: quelel la nutjüjí nunwá —nin tjevele Jesucristo. ");
INSERT INTO jicNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ninana tjevele wa Jesús: —Nun ncapj con̈có mpes, gente ma jisas nun. Nujola tapalas püs way nas yupj ma jisastsja napj. ");
INSERT INTO jicNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nun p'iyá nosis nt'a patja jinwá nacj, nosis nt'a patja quelel la quijicj wa nun, yupj sin popa jinwá. Nun 'a yupj jin tulucj. Napj p'iyá la nu t'ya nosis casá patja popé ncapj la con̈. Nin mpes nosis casá patja ma jisas nun. ");
INSERT INTO jicNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nujola tapalas napj tjevelé nun jis lal: ‘Mozo más püné tulucj jyü'ta lal’. Malala quelel la najaytsja napj, ca malala quelel la nusejay wa nun. Ma la tjajay napj tjevelé, mpes yupj ma wa ca la mijicj nun welé jin. ");
INSERT INTO jicNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ncapj con̈có, mpes ca nin la mijicj nun lal. Yupj ma sa nuc Dios, mpes nin. Dios nin tjejyama napj. ");
INSERT INTO jicNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","”Napj ma 'ucuwistsja yupj nt'a jis lal la veles Dios po'ó, Dios ma nin jola cüpalastsja yupj ma japon. T'üc' way jola jupj quinam yupj ma japon mpes. Yupj nasa tjepjyacan̈ napj tjevelé, mpes malala nin, yupj ma japon. ");
INSERT INTO jicNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yupj ma jisas napj, ma wa jisas napj Mpapay. ");
INSERT INTO jicNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Napj ma pajal püné la cüjaytsja, la p'a ma liji jinwá, Dios ma ca jola cüpalastsja pajal malala nin, yupj ma japon. Nasa tjunuc napj pajal 'üsüs la tjejay, newa ma jisas napj, ma wa jisas Mpapay. ");
INSERT INTO jicNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yupj jis papel tjevele jin tepyala. Tjevele: ‘Yupj sin nin ma jisastsja napj’. Jis papel vele Dios tjijyü'tá, mpes t'üc' tepyala jupj tjevelá —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jesús tjevele wa jupj discipulopan jis lal: —Dios Cjües ncuwim nucopj mp'a'sas. Tjac' na, jupj ca mveles gente jis lal jupj selé napj mpes. Jupj sin 'yüsa la siji t'üc' way Dios po'ó. Mpapay mpe jac' jupj. Napj p'iyá ca jas majam jupj Mpapay mpe. ");
INSERT INTO jicNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Najas nun ca mvelé wa nun solejé way napj mpes. Nun lovin ncapj tocon̈có napj mwalá way sin tji'yüsa la tjejay na, newa nin —nin tjevele Jesús yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús tjevele wa niná: —Nin tjevelé nun jis lal, mpes nin tepyala na, napj tjevelé jin, newa ca mponé nun napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judiopan jis jepapan ca müjü'tücj nun lovin ma polel nlawú judiopan 'a si mulú nt'a. Más malala ca la mijicj wa. Nu ja'ünan na, pjü yupj ca yola nsem Dios jos jin lajay yupj. Nin ca nsem p'a jyawca na. ");
INSERT INTO jicNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yupj lovin ma cus tocon̈ Mpapay, ma wa ncapj tocon̈ napj. Nin mpes ca nin la mijicj yupj nun jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nin tjevelé nun jis lal, mpes yupj ninana la nusejay na, nun ca nujola mpalas napj tjevelé ca nin mpalas. Ma nin tjevelé püna p'in, napj nun jis lal tüpü'üs mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesús tjevele wa jupj discipulopan jis lal: —Mpapay nin tjejyama. Napj ca mis quinam jupj nt'a. Newa ma pjaní nun popé nla 'yüya ne ca'aj jum napj. ");
INSERT INTO jicNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Napj tjevelé ca mis, mpes pajal 'aplijila nu tepyala nun. ");
INSERT INTO jicNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mop'in más 'üsüs nun mpes napj jum. T'üc' way niná. Napj ma jum, Dios Cjües ma ncuwim nucopj la p'acj. Napj jum, jas majam ca jupj nun nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jupj tjac' na, jupj ca sin mü'üsüs la mijis gentas t'üc' way malala nyuca la tjajay yupj. Ca sin mü'üsüs la mijis wa tsjan t'üc' way 'üsüs Dios lal. Ca sin mü'üsüs la mijis Dios ca jis capj ntülüs malala lajay. ");
INSERT INTO jicNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jupj ca sin mü'üsüs la mijis t'üc' way malala Dios lal ma japon napj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","”Napj mis ca Mpapay nt'a, ne nun ma ca nus nucú quinam. Mpes ca Dios Cjües sin mü'üsüs la mijis wa t'üc' way napj 'üsüs, Dios nt'a tjum mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Diablo jyü'ta nosis nt'a po quina way p'in; Dios nasa tjevele jupj ca cus ntülüs diablú. Mpes Dios Cjües gente ca sin mü'üsüs la mijis wa Dios ca jis capj ntülüs malala nyuca lajay. ");
INSERT INTO jicNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”Pülücj quelel velé nun jis lal custjay, pajal ca pülücj nacj nun jis lal. Mpes ma ca pjü mvelé nun jis lal quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dios Cjües tjac' na, jupj ca nusin mü'üsüs la mijis pjü way t'üc' way. Jupj gente sin 'yüsa la siji t'üc' way Dios po'ó. Jupj ma vele jupj jola way jin p'in. Jupj tjapjacá, nin ca mveles. Nun jis lal ca mveles p'a jyawca na ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lovin ca sin mü'üsüs la mijis gentas napj pajal 'üsüs, pajal püné. Jupj ca nusin mü'üsüs la mijis napj velé. ");
INSERT INTO jicNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pjü way Mpapay vele, nin p'iyá velé wa napj. Mpes tjevelé: ‘Jupj ca nusin mü'üsüs la mijis napj velé’. ");
INSERT INTO jicNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","”Püs way tepyala na, ma ca nus nucú. Locopyaya p'a wa püs tepyala na, nun ca nus nucú niswá, Mpapay nt'a jum mpes —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesús discipulopan ma sin tji'yüsa Jesús tjevelá. Mpes yupj nepenowá yuwá tjowelepj: “¿Tsjan vele niná? Jupj vele püs tepyala na, ma ca jus nucucj. Locopyaya p'a wa püs tepyala na, ca jus nucucj niswá. Tjevele wa Popay nt'a ca mim.” ");
INSERT INTO jicNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma sin tji'yüsa mpes newa jis la tjü'üy yuwá: “¿Tsjan quelel vele niná: ‘püs tepyala na’ ca nin mpalas? Ma qjuisin 'yüsa jupj velá.” ");
INSERT INTO jicNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús seletsja yupj quelel la 'üytsja jupj lal. Mpes jupj tjevele yupj jis lal: —Nun nu la tjü'üyá nunwá tsjan mpes napj tjevelé püs tepyala na, ma ca nus nucú. Locopyaya p'a wa püs tepyala na, ca nus nucú niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","T'üc' way niná. Pajal 'aplijila ca nsem nun. Pajal ca la mpuyú. Nin tulucj Dios ma jisas jis lal. Yupj pajal 'ücj jisas nsem. Nun p'in pajal 'aplijila ca nsem malala tepyala mpes. Locopyaya pajal 'ücj nujisas mpalas. Nun ca jus nlayé malala tepyala pajal 'üsüs. ");
INSERT INTO jicNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quepj tsjicj way quelel mya'na na, 'aplijila pyala jupj malala jos ca mpalas quinam. Tsjicj tjemya'na na, 'ücj. Tsjicj jamay pajal 'ücj jos tsjicj way tjac' quinam. Mpes ma jola quinam pajal vyájatsja yas nam. ");
INSERT INTO jicNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quina 'a nin wa nun jis lal. Nun 'aplijila quinam. P'a jyawca na ca nu mü'ü'süs. Napj ca nujus nuc niswá, ne pajal ca 'ücj nujisas nsem nun. Nin tepyala na, la p'a ma ca polel la qjuijis 'aplijila cüpalas nun. ");
INSERT INTO jicNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","”Nin tepyala na, ma ca nla mü'üyá napj lal. T'üc' way la talata lo moná Mpapay lal, jupj ca nu ma'ayas nun, napj mpes lo moná mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Custjay lo moná secj nun napj mpes. Najas lovin la moná, ne nun lo moná nta'é ca. No'oté lo moná, mpes pajal ca 'ücj jisas nsem nun t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”Napj tjevelé nun jis lal costa way 'in jas la 'üsüs. P'a jyawca na ma ca nin nsem. Ma ca nin jinwá velé nun jis lal. 'Ücj jas la 'üsüs mvelé nun jis lal Mpapay po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ninana tepyala na, napj ma ca la cümon Mpapay lal nun mpes. Nun p'iyá ca la moná Mpapay lal, napj mpes lo moná mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nun quelel la ntüjí. Nasa toponé wa Dios mpe tjacuwis. Nin mpes Mpapay quelel la nusiji wa nun, ne 'ücj ca nsem nun lo moná jupj lal. ");
INSERT INTO jicNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","T'üc' way Mpapay mpe tjacuwis. Nosis nt'a tjacuwis napj. Quina mis wa ca niswá nosis casá pem. Mpapay nt'a ca mis niswá —niná Jesús tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nin tjevele na, jupj discipulopan tjowelepj jupj lal: —'Üsüs qjuisin 'yüsa velen quinam. Parábola mpes tulucj qjuisin 'yüsa lejay quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cupj jus nlayecj quinam jipj pjü selen. Jis la 'üy secj p'in, jipj selen tsjan quelel lya 'üy yupj. Nin mpes pyonecj Dios mpe tjacuy jipj. ");
INSERT INTO jicNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús jis la tji'yüya: —¿Ncu t'üc' way poné quinam? ");
INSERT INTO jicNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pjü ca nts'equenequé. Pjü ca nuwó nt'a nlawú, ne napj nasapj ca mo'os. Len̈ way ca nin mpalas. Mop'in ma ca nasapj nsem napj, Mpapay napj nlal. ");
INSERT INTO jicNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Najas nun ma nin nujola nsem; najas 'üsüs mpatjaqué nun ncapj con̈có mpes. Nin mpes niná tjevelé nun jis lal. Nosis casá patja ma jisas napj, mpes malala ca nu mpalas neneyawá. Po ma locj tjeyá. Napj más pünetsja lovin nosis nt'a patja jis lal. Lovin nin —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús tecyawaja tjevele na niná discipulopan jis lal, jupj tjinyuca tsjun po'ó, tjevele Popay Dios lal. Tjevele: “Mpapay, quina ca ma pats'. Jipj nt'a ca mis niswá, jipj tjevelen jin. Sin tjü'üsüs lis mijin gentas napj pajal 'üsüs, pajal püné. Mpes wa napj mpes ca sin mü'üsüs wa jipj pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jipj ntje'an 'ücj jis müjütütj pjü gentas. Mpes gente jipj ntje'an 'ücj lovin ca mpatjam jipj lal ca la mejay napj. Nin mpes la 'e mon gente sin mü'üsüs lis mijin napj 'üsüs, napj püné. ");
INSERT INTO jicNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yupj cyapj jacon̈ na, ncapj jacon̈ wa na, yupj lovin ca mpatjam jipj lal. Jipj pjaní t'üc' way Dios. Jipj nin tjejyam jis capj la p'acj gentas, püna tjevelen jin. ");
INSERT INTO jicNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","”Nosis nt'a napj sin 'yüsa la tjejay jipj pajal 'üsüs, pajal püné. Pjü way tecyawaja la tjejay jipj ntjijütütj. ");
INSERT INTO jicNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mpapay, nosis cjuwatsja na p'in, cupj 'a mulutsja pajal pünetsja. Quina la 'e mon napj pajal püné ca nsem niswá jipj püt' nt'a, püna jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”Napj sin 'yüsa la tjejay noyomes nenem jipj po'ó. Jipj ntje'an yupj, nosis casá patja sin popé. Yupj jipj jits'a'atsja yas nam, ne jipj ntje'an yupj quinam. Yupj la tjajay jipj tjevelen jin. ");
INSERT INTO jicNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Quina yupj salejepj jipj ntje'an pjü. Jipj p'iyá nin la tjejay napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Jipj tjevelen napj lal, napj tjevelé nin p'iyá yupj jis lal. Yupj jisas napj tjevelé. Salejepj t'üc' way napj jipj mpe tjacuwis. Topon wa jipj nin tjejyam. ");
INSERT INTO jicNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”Quina la 'e mon yupj mpes. Ma la 'e mon jipj ma jisas mpes. La 'e mon jipj ntje'an mpes p'in. Jipj jits'a'á way yupj, mpes quina la 'e mon yupj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pjü napj nats'a'á, jipj jits'a'á wa; jipj jits'a'á, napj nats'a'á wa. Niná noyomes la p'a sin 'yüsa la tjajay napj pajal 'üsüs, pajal püné. ");
INSERT INTO jicNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","”Nasa ca mis quinam napj nosis mpe. Mop'in ninana noyomes ca mpatjam nosis nt'a custjay. Napj jipj nt'a ca mis. Mpapay Dios, pajal 'üsüs way jimpe. Jipj ntje'an niná noyomes. Mpes najas jis majaman, jipj pjü 'ücj lejay mpes, ca yupj lovin cyapj ncon̈cocj. Nin mpes yupj pjü nin p'in yola ca nsem yom pjaní jinwá, cupj jin p'iyá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Napj tüpü'üs na yupj jis lal, napj p'iyá lovin jis tjejyamá, mpes lovin cyapj tocon̈ yupj. Jipj püné mpes 'ücj nin la tjejay. Jis tjejyamá ne p'a wa ma malala lis tjiji. Ma pjaní len̈ tjevyala. Pjaní p'in tjemey. Ma quelel cyapj cyón̈catsja jupj. Jupj lovin malala lajay popa p'iyatsja. Jipj Pyapel tjevele ca nin mpalas, ne nin tepyala, ca nin mpalas jipj Pyapel tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”Quina ca mis jipj nt'a. Ninana tjevelé nosis nt'a 'os na p'in, yupj pajal 'ücj jisas la sejay, napj pajal 'ücj najas jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nas tjevelé yupj jis lal tsjan niná jipj quelel velen gente jis lal. Nosis nt'a patja ma jisas yupj quinam. Yupj ma yuwal yola nosis casá patja jis lal, napj jinwá. Napj ma wa yuwal nola nosis casá patja jis lal. Mpes nosis casá patja ma jisas yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma la 'e mon jipj ca jis man yupj nosis mpe. Napj la 'e mon jipj ca majaman yupj, diablo ma malala lis mijis yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gente jipj ntje'an ma nin p'in yola nosis nt'a patja jis lal. Nin p'iyá napj. Napj ma wa nin p'in nola nosis casá patja jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sin tjü'üsüs lis mijin t'üc' way. Nin la mijin niná noyomes pajal 'üsüs witjacj ca nsem, ne ca yupj la mijicj jipj velen jin p'in. Pjü jipj velen t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jipj nin tjejyam nosis nt'a patja nt'a. Nin p'iyá napj sin tjejyam wa yupj nosis nt'a patja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Napj nin lejay jipj velen jin lovin, ca 'üsüs jis mpalas yupj. Napj nin lejay mpes, t'üc' way yupj 'ücj ca la mijicj wa jipj velen jin lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”Ma la 'e mon noyomes qui jatja mpes p'in. La p'a mpes 'a le mon wa. La p'a wa ca mponecj napj lal, niyom qui jatja javelepj mpes. Jipj lal velé yupj mpes wa. ");
INSERT INTO jicNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pjü mpes la 'e mon nin p'iyá ca yola nsem pjü, cupj jin p'iyá. Jipj napj mpes jac'; napj jipj mpes 'os wa. Mpapay, najas ca nin p'iyá nsem, yupj ca majatjum cupj mpes. Nin mpes nosis nt'a patja mponecj ca jipj nin tjejyam. ");
INSERT INTO jicNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jipj la tjejay napj 'ücj la cüjay. Napj nin p'iyá la tjejay yupj jis lal. Napj la tjejay ca yupj 'ücj wa la quijicj, napj jin p'iyá. Nin mpes 'ücj nin p'iyá yola ca nsem yupj yuwá, cupj nin p'iyá qjuiyola jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Napj yupj mpes 'os; jipj napj mpes jac' wa. Nin mpes 'ücj ca nin p'iyá yola yuwá t'üc' way. Nina jis tepyala na, nosis casá patja ca jus nlayecj jipj napj nin tjejyam. Ca jus nlayecj wa jipj quelel la sejay napj mpes japon, jipj quelel la nejay jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","”Mpapay najas gente jipj ntje'an mpatjam wa napj pü'üs nt'a. Najas ne'aj ca jus nlayecj jipj la ntjejay napj pajal püné. Nosis cjuwatsja na, jipj quelel la nejaytsja, mpes jipj la tjejay niná napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mpapay, jim 'a pajal 'üsüs. Nosis casá patja ma jis januctsja jipj; napj 'a jis nuctsja. Ninana noyomes jus nlay jipj nin tjejyam. ");
INSERT INTO jicNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Napj sin 'yüsa la tjejay jipj mpes. Newa ca sin 'yüsa la mejay. Nin mpes jipj quelel la ntjejay jinwá, nin p'iyá ca quelel la mijicj yupj p'a wa, ne napj ca mpü'üs yupj jisas mo'ó”, nin tjevele Jesús Popay lal. ");
INSERT INTO jicNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús nin tjevele na niná, nepé tjemey jupj discipulopan jis lal. 'Üsǘ vequecj la pja na'aj po'ó tjil. Cedrón lotsja jupj, 'üsǘ vequecj la pja nt'a. Ne'aj sin lejen̈. Sin lejen̈ mo'o tjemey Jesús, jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas Jesús enemigopan jis capj p'yá'satsja jis la tjilil Jesús. Jupj selé watsja Jesús tjemey nt'a. La pülücj Jesús jupj discipulopan 'a jis tjimyula ne'aj, mpes seletsja Judas. ");
INSERT INTO jicNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nin mpes Judas pajal pülücj jis lal tjac' militar romanopan, Jesús tjá'asa nt'a. Auxiliarpan nepénowa jis lal tjac' wa. Auxiliarpan sacerdote noypan mpe tjiquil, fariseopan mpe wa tjiquil. 'Iyó jaw, lámpara jaw wa tjiquil. Pjü way 'ücj jis la palan tjiquil. ");
INSERT INTO jicNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús seletsja tsjan ca mpalas jupj quinam, pjü way seletsja. Mpes Jesús pje'á tecyala la nüjüsü yupj. Jis la tji'yüya: —¿Pjacj lo palá nun? ");
INSERT INTO jicNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yupj jupj lal tjowelepj: —Cupj le palacj Jesús, Nazaret mpe 'esepj jupj. Jesús tjevele yupj jis lal: —Napj ne Jesús. Judas ne'aj wa tón̈catsja militarpan jis lal, auxiliarpan jis lal wa. Judas jis capj tjep'ya'sa Jesús enemigopan jis la tjilil Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús tjevele na: “Napj ne Jesús”, yupj jis cjüipe jin tjil, jis tyü'na. ");
INSERT INTO jicNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mpes Jesús jis la tji'yüya niswá: —¿Pjacj lo palá nun? Yupj jupj lal tjowelepj: —Cupj le palacj Jesús, Nazaret mpe 'esepj jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús yupj jis lal tjevele: —Napj nuwola tjevelé napj ne Jesús. Nun napj la no palá, mpes jis tja'ayá mal noyomes napj lal jatjá. ");
INSERT INTO jicNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jupj nin tjevele ca nin mpalas jupj Popay lal tjevelá. Yacjaj p'in nin tjevele Popay lal: “Napj jis tjejyamá mpes ma pjaní len̈ tjevyala jipj ntje'an popé”. ");
INSERT INTO jicNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro polomay tyá'atsja jupj. Polomay syults'a quinam ne'aj tjiquil popa jay lo jocj. Yom pjaní jay tjejyo'o, pjots' li'inyampe taná t'yüjü jupj. Niná yomen Malco lotsja jupj. Mozo waytsja jupj sacerdote más püné mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús ma jostsja pjots' tjejyo'o. Mpes tjevele jupj lal: —Vaina mo'o jas tjejyama jipj polomay. Mpapay jos malala ne palá quinam. Najas jupj jos jin ca ma palas. Ma ca nts'equenes. ");
INSERT INTO jicNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nin tjevele na, niyom pülücj ntji'lin̈ Jesús. Nin la tjajay militar romanopan, yupj jis jepa 'ots'ipj, judiopan auxiliarpan 'ots'ipj. Tsupapj jupj pjwel po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tjaman jupj judío püné nt'a mwalá way. Judío niná Anás lotsja. Caifás joyomtsja jupj. Joway sacerdote más pünetsja nin tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'In lacasana Caifás p'iyá tjevele judiopan jis jepapan jis lal más 'ücj yom pjaní mpa'is, ca ma nca'lin̈ judiopan pjü way. ");
INSERT INTO jicNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro Jesús cjüil tjemey campapé. Discípulo p'a wa cjüil tjemey wa. Sacerdote más püné ne'as jus tjinyuca discípulo niná. Si nucutsja mpes, jupj 'ücj wama tjemey wosis t'asiyú tjüwücj mo'ó, Jesús tjá'asa nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro newa tüwütüwǘ ton̈ca jun vilicj nt'a. Tsjücjüim jun vilicj jyámatsja. Discípulo ma'ajapj si nucutsja sacerdote más püné, mpes niswa jun vilicj nt'a tjemey, tjevele jun vilicj jyama lal. Nin mpes Pedro lal tjac' t'asiyú tjüwücj mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jun vilicj jyama tjevele Pedro lal: —¿Ncu Jesús discipulopan popa wa jipj? Pedro tjevele: —Nin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pajal tsjojósetsja. Mpes mozopan 'awa jus t'ol 'etsjecj mpes. T'asiyú tjelejen̈ jis la sis. Nin la tjajay wa militarpan. Pedro yupj jis lal ton̈ca wa la sis. ");
INSERT INTO jicNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anás sacerdote más pünetsja püna p'in. Jupj la tji'yüya Jesús lal jupj discipulopan sin po'ó. La tji'yüya wa tsjan sin tji'yüsa la tjiji jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús jupj lal tjevele: —Napj tjevelé pjü 'ücj jis la pjac nt'a. Wosis judiopan 'a si mulú nt'a sin 'yüsa la tjejay napj lovin. Dios wo nt'a sin 'yüsa lis tjejay wa, pjü judiopan 'a si mulú nt'a. Pequé tjevelé tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tsjan pjucj nin nla 'yüy napj? Pülücj tjepjyacan̈ napj tjevelé. Jis la tji'yüya tsjan tjevelé. Yupj salejepj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús nin tjevele na, auxiliar pjaní Jesús wola po'ó tyüla jupj. Ne'aj p'in tón̈catsja. La tji'yüya Jesús lal: —¿Tsjan pjucj tjevelentsja nin jinwá, sacerdote más püné lal? ");
INSERT INTO jicNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús tjevele jupj lal: —Malala tjevelé tulucj. Napj malala tjevelé, pjü jis walap'a'a mvelen tsjan malala tjevelé. Napj 'ücj tjevelé, ¿tsjan mpes nawala po'ó tyül? —tjevele jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yacjaya Anás Jesús jas tjejyama Caifás nt'a. Caifás sacerdote más pünetsja quinam. Jesús tsyu'pa tjemey. ");
INSERT INTO jicNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mwalá way p'in, Jesús ne'aj ton̈ca na p'in, Simón Pedro 'awa nt'a ton̈ca süise. La p'a ne'aj lejen̈tsja la tjü'üy jupj lal: —¿Ncu jupj discipulopan popa wa jipj? Pedro tsyüpünǘ. Tjevele: —Nin tulucj nam. ");
INSERT INTO jicNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yom p'a wa ne'aj tón̈catsja, mozo watsja jupj sacerdote más püné mpes. Mozo nenem pjots' jay tjejyo'o jopey. Pedro p'iyá mozo jopey pjots' jay tjejyo'o. Mpes jupj tjevele Pedro lal: —Napj nola napj jis tjinyuc sin lejen̈ nt'a Jesús lal. ");
INSERT INTO jicNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro niswa tsyüpünǘ. Len̈ way la tipiya costlyas. ");
INSERT INTO jicNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Locopyaya yupj Jesús lal tjil Caifás wo mpe. Jepa romano wo nt'a tjaman jupj. Pajal püstaptsja. Judiopan jis jepapan jisastsja jepa romano ca cus ntülüs Jesús. Yupj p'iyá ma wama tjil jepa romano wo mo'ó. Yupj yólatsja ma polel wama mal judío tulucj wo mo'ó. Judío tulucj wo mo'ó jil, malala nsem yupj Dios lal. Malala yupj Dios lal, ma ca polel nlajacj oveja pisis fiesta na, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. ");
INSERT INTO jicNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nin mpes jepa romano pje'á tjac' yupj nt'a. Jepa romano Pilato lotsja jupj. Jupj tjevele judiopan jis jepapan jis lal: —Nawala tjowelé tsjan la tjiji yom niná. ");
INSERT INTO jicNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yupj jupj wola tjowelepj: —Yom niná ma malala nyuca la qjuijistsja, ncupj ma ca 'ucumantsja cus cütül. ");
INSERT INTO jicNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yupj nin tjowelepj na, Pilato yupj jis lal tjevele: —Nun p'iyá tjamanú jupj. Nun la tjü'üyá ncu malala la tjiji. Nun jis jepapan jajütütj jin la müjí jupj lal. Yupj tjowelepj jupj lal: —Ncupj qjuis jepapan jajütütj la 'ünan jupj. Jipj judío tulucj. Jipj jyütütj ma polel la qjuijicj niná ncupj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nin mpes nin tepyala Jesús tjevelá. Jupj tjevele cruz po'o ca mvalas, mpa'is. Judiopan ma salejepj la 'ünan cruz po'ó. Romanopan cruz po'o jis capj jatül. ");
INSERT INTO jicNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato wo mo'ó tjemey niswá, tjevele ncuwim Jesús. La tji'yüya jupj lal: —¿Ncu jipj judiopan jis jepa püné? ");
INSERT INTO jicNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús la tji'yüya jupj lal: —¿Ncu jipj p'iyá quelel selen mpes nla 'yüy niná? ¿Ncu p'a wa javelepj mpes nla 'yüy? ");
INSERT INTO jicNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato tjevele: —Napj p'iyá quelel selé tulucj. Judío tulucj nam. Jipj gente popa tucuman jipj napj nt'a, napj cyapj la tül. Sacerdote noypan p'iyá la tjajay niná. ¿Tsjan malala la tjejay jipj? ");
INSERT INTO jicNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús tjevele jupj lal: —T'üc' way Jepa napj, mop'in napj nosis casá jajütütj jin lejay tulucj. Napj cüjütütj nosis nt'a jajütütj jinwá, napj ca jis cüjütütj namozopan jis la palan judiopan jis lal, ma ma tjililin̈. Yupj ma nin la tjajay. Napj qui'á jajütütj jin tulucj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mpes Pilato tjevele Jesús lal: —Nin velen t'üc' jepa jipj. Jesús jupj lal tjevele: —T'üc' way. Napj ne jepa. Napj tjacuwis nosis casa'á t'üc' way la veles gente jis walap'a'á, napj selé mpes. Nin mpes tjacuwis napj. Gente quelel salejepj tsjan t'üc' way, yupj pjyacan̈ napj velé. Napj velé jin lajay wa yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato tjevele Jesús lal: —Ma polel jus cülayes tsjan t'üc' way. Pilato nin tjevele na, niswa pje'á tjemey judiopan la nuctsja nt'a. Tjevele yupj jis lal: —T'üc' la tji'yüy napj. Ma polel la veles jupj malala li jam. ");
INSERT INTO jicNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Napj lovin yom pjaní se jam cawilta mpe nun jis fiesta pyala na, fiesta ‘Dios Qjuis Capa Nipj Tjemey’ ló. Lovin nin lejay nun mpes. ¿Ncu nujisas Jesús se jam cawilta mpe nun mpes? Jupj judiopan jis jepa püné. ");
INSERT INTO jicNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pilato tjevele na niná, yupj la tupuyupj: —Ma qjuisas se jam jupj. Qjuisas Barrabás se jam. Barrabás pwequepj waytsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nin tjevele na, Pilato jis tjijyü'ta jupj militarpan mo'o jasüp Jesús 'üpǘ mpes, ne nin la tjajay yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Militarpan la tjüpjüts'ün wa Jesús. Yo pjwel jam jus tjulujupj Jesús jay la 'onsos. Jesús jay tjo'onsopj, corona jay tjá'asatsja jinwá. Je jas tücüipap wa. Jepa püné jas quip jin justa la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","La pülücj jupj wolap'a'a jiquil watsja, javeleptsja: —Qjuisas 'ücj jyas mpü'üm. Jipj jepa püné judiopan jis lal. Nin tjowelepj na, wola po'o jatültsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Niswa pje'á tjac' Pilatá, judiopan tjatja nt'a. Tjevele yupj jis lal: —Quina ca mvelé Jesús ncuwim, nun jus nucú. Mpes jus nlayé napj ma tjinyuc malala la tjijam. ");
INSERT INTO jicNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mpes pje'á tjac' Jesús. Yo pjwel jam jay já'asatsja custjay jupj. Jas quip je militarpan jas tücüipap newa sa capyatsja jupj. Jesús tjac' na, Pilato judiopan jis lal tjevele: —Jus 'unuca niná yomen. ");
INSERT INTO jicNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote noypan jus tjunuc na Jesús, yupj yümücj tjowelepj: —Cruz po'o tjevyala jupj, mpa'is. Cruz po'o tjevyala jupj, mpa'is. Nin p'iyá yümücj tjowelepj wa yupj jis militarpan. Pilato tjevele yupj jis lal: —Nam ma ca müjütütj niná. Nun p'iyá cruz po'o tjovalá jupj. Napj nasa la tji'yüy tjinyuc jupj. Napj velé jupj ma la tjiji nun welé jupj po'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judiopan tjowelepj Pilato lal: —Jupj tjevele jupj p'iyá Dios Jatjam. Ncupj qjuis jepapan jajütütj ma polel la veles nenem. Jajütütj tepe'e nas ca cus ntül nin tjevele mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato tjapjaca na yupj nin tjowelepj, más lecj jéyatsja. Ma quelel si tülütsja jupj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wama tjemey jupj wo nt'a, tjevele Jesús lal: —¿Ca'ampe 'esepj jipj? Jesús ma lal tjevele. ");
INSERT INTO jicNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ts'i tji'ina Jesús lal, ma lal tjevele mpes. Mpes tjevele Jesús lal: —¿Ncu ma velen napj lal? Napj ca 'ücj jin cüjam, 'ücj wa ca cüjütütj cruz po'o cüvalacj, ca 'i quipats'. ");
INSERT INTO jicNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús jupj wola tjevele: —Dios 'e tje'aya 'ücj lo jütütj 'oyn nyuca la cüjay napj lal. Dios ma que'as, jipj ma ca cüjütütsja 'oyn nyuca la cüjay napj lal. Nin mpes yom p'a wa más malala la tjiji jipj lal, jupj nlal tjac' jipj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesús nin tjevele na, Pilato pajal quelel se jamatsja Jesús. Mop'in yümücj tjowelepj judiopan: —Jipj se jam niná, romanopan jis jepa püné jomica tulucj jipj. Jesús vele jupj p'iyá jepa püné. Yom pjaní nin vele jepa püné wa jupj, enemigo jupj romanopan jis jepa püné lal. ");
INSERT INTO jicNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato nin tjapjaca na yupj tjowelepj, pje'á tjac' Jesús lal. Pilato silla casá tjá'asa nin la veles ncu cus ntülüs Jesús. Nin mpes niná sillas. Jupj palá 'etjele na silla casa'á, pjü jus nlay jupj ca mveles quinam ncu sa tül. Silla nt'a Gabato ló ne'aj. Ncupj velecj “Pe Noypan 'Ama'á”. ");
INSERT INTO jicNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Judiopan newa fiesta lajaytsja, fiesta “Dios Qjuis Capa Nipj Tjemey” ló. Yacjaj pjü 'ücj lajaytsja ya mpes, ya ma polel tsji' la mijicj fiesta mpes. Lots'ac' culupwen nt'a já'asa nas. Pilato judiopan jis lal tjevele quinam: —Jus tjunuca nujepa püné. ");
INSERT INTO jicNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pilato nin tjevele na, yupj yümücj tjowelepj: —¡Tjü'ü'na jupj! ¡Tjü'ü'na jupj! Cruz po'o tjevyala, mpa'is. Pilato tjevele yupj jis lal: —Malala nyuca nujola nun. Malala nin nujisas napj ca müjütütj yupj ca cruz po'o mvalacj nujepa püné. Sacerdote noypan jupj wola tjowelepj: —Romanopan jis jepa püné, cupj qjuis jepa püné jupj. Len̈ p'am. ");
INSERT INTO jicNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mpes Pilato tjijyü'ta yupj jisastsja jin ca nsem. Tjijyü'ta militarpan Jesús cruz po'o ca mvalacj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Niná tjijyü'ta mpes militarpan tjil Jesús lal. Jesús p'iyá cruz tjyama jámatsja. Jay Pjucj Cjüele lotsja ne'aj, jupj tjemey nt'a. “Gólgota” tjowelepj judiopan jis tin. ");
INSERT INTO jicNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne'aj Jesús cruz po'o tjovalapj. Niyom p'a wa mat'eyá cruz po'o jis tjovalapj wa p'a wa cruz po'ó. Jesús t'empe jis tjovalapj. Jesús tón̈catsja culupwen yupj jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato tjijyü'ta tabla mpaquecj, Jesús jay pjucj nt'a lo valas cruz po'ó. Tabla niná mo'o tepyaca tsjan mpes cus tül Jesús. Ninana tepyacá niná: ");
INSERT INTO jicNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesús cruz po'o tjovalapj nt'a ne'aj way p'in Jerusalén nepem. Nin mpes judiopan pülücj mo'o tjowelepj niná mo'o tepyacá. Jis tin cont'e mpes tepyaca, judiopan jis tin pjaní wa, pjaní wa romanopan jis tin, pjaní wa griegopan jis tin. ");
INSERT INTO jicNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sacerdote noypan judiopan sin popé, ma jisastsja niná tepyacá. Mpes yupj Pilato lal tjowelepj: —Po ma tepyaca: ‘Jepa püné jupj judiopan jis lal’. Más 'ücj mpaquen: ‘Ninana yomen tjevele jupj jepa püné judiopan mpes’. ");
INSERT INTO jicNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato yupj jis wala tjevele: —Napj tepyac jinwá ma'ajam lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Militarpan Jesús cruz po'o tjovalapj na, natj yupj Jesús jas quip. Militar yulupjana játjatsja ne'aj, mpes Jesús jas quip la tequeman̈, jis tja'ayapj yuwá, yulupjana yuts'a'á. Natj wa Jesús jas quip wampa, pajal 'üsüs waytsja niná. Jupj jas quip wampa jus tjulul tulucj, jas toptsja la p'in. ");
INSERT INTO jicNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mpes militarpan yuwá tjowelepj: —Po ma la tequemam niná. Mpjelaquecj nucucj pjacj nta'es niná. Ne nin la tjajay yupj. Dios Popel tjevele ca nin la mijicj yupj, ne t'üc' way nin la tjajay, jupj Popel tjevele jinwá. Dios Popel tjevele: “Nin quip la tequeman̈, jis tja'ayapj yuwá. Tjepjelan̈ tjunuc pjacj nta'es nin quip.” Ne nin la tjajay militarpan. ");
INSERT INTO jicNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","P'a wa ne'aj lejen̈tsja cruz ton̈ca nt'a, ne'aj p'intsja 'in. Pjaní wa Jesús jamaytsja, pjaní wa Jesús jomapj, pjaní wa María, Cleofas jats'om, pjaní wa María Magdalena lotsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Discípulo pjaní ne'aj p'in ton̈ca watsja cruz ton̈ca nt'a. Jesús pajal quelel líjitsja jupj. Mpes Jesús tjinyuca na discípulo niná ne'aj way p'in jamay ton̈ca mpe, jupj tjevele jamay lal: —Namay, niná jipj jetjam quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jesús tjevele wa discípulo niná lal: —Ninana jemay quinam. Mpes nin jawas p'iyá discípulo niná Jesús jamay lal tjemey jupj wo nt'a lo püt'üs. ");
INSERT INTO jicNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Locopyaya Jesús seletsja pjü t'üc' la tjiji Dios jostsja jin. —'Üsǘ nive —tjevele jupj. Dios Popel tjevele nin ca mveles, mpes niná tjevele na, t'üc' la tjiji Dios Popel tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uva 'üsǘ 'ona ne'aj já'asatsja botella mo'ó. Mpes esponja tji'its'a la tjajay uva 'üsǘ lal, yo hisopo ló po'ó tsupapj, viyá tecyacaná Jesús lo müs. ");
INSERT INTO jicNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús tjümü'ü na niná, tjevele: —T'üc' la tjejay quinam. Tjevele na, jay t'yoca, tepe'e. ");
INSERT INTO jicNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nin jawas pjü 'ücj lajaytsja ya mpes, ya ma polel tsji' la mijicj fiesta mpes. Judiopan ma jisastsja niyom jis p'üy newa cruz po'o velan̈ ts'ac' niná yupj ma polel tsji' lajay na, sábado nsem. Sábado ma tsji' lajay jawas tsjay 'üsüstsja fiesta mpes. Nin mpes yupj la tjomon Pilato lal militarpan niyom jis tecj la 'ul, más 'in len̈ way nca'lin̈. La tjomon wa palá jis la cutj jis p'üypan tecya'lin̈ na. ");
INSERT INTO jicNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mpes militarpan cruz tjelejen̈ nt'a tjil. Nin jawas p'iyá niyom mat'e cruz po'o tjovalapj Jesús lal. Quina yom mwalá tüecj la tju'ul. Locopyaya yom ma'ajapj tüecj la tju'ul wa. ");
INSERT INTO jicNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma la tju'ul Jesús tüecj. Jesús ton̈ca nt'a ne'as tjiquil na, jus tjunuc nas tepe'e quinam. Mpes ma tju'ul jupj tüecj. ");
INSERT INTO jicNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Militar pjaní Jesús wüints'il po'o tsjyaca yo jay ts'ülül lal. Len̈ way 'as tepyala, 'üsǘ wa tepyala. ");
INSERT INTO jicNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Napj p'iyá tjinyuc nin tepyalá, mpes velé napj tjinyuc. Velé t'üc' velé. Nin velé ca 'ücj mponé wa nun. ");
INSERT INTO jicNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pjü niná tepyala pjü nin la pal Dios Popel tjevelá. Jupj Popel vele: “Jupj cjüele popé ma ca pjaní la c'ulim”. ");
INSERT INTO jicNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","P'a nt'a Dios Popel mo'ó vele wa: “Jupj 'atsjac, tjü'ünan, jus nucucj wa ca yupj”. ");
INSERT INTO jicNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pjü niná tepyala na, yom pjaní Pilato nt'a tjemey, la tjemyona Jesús jüp'üy la toc. Pilato tjevele 'ücj la ta'es jupj jüp'üy, mpes tjac', palá nt'ya jüp'üy. Yom nin la tjijá José lotsja. Arimatea mpe 'eseptsja jupj. Jesús discípulo watsja. Lecj jéyatsja la p'in judiopan jis jepapan jis lal, mpes lyájasa wínetsja püna p'in; püna ma véletsja la p'a jis lal jupj cus tecyon̈ca Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo tjac' wa José lal Jesús jüp'üy la ta'es. Püna jupj püste na tjac', tjinyuca Jesús. Nicodemo pomada teque'e Jesús jüp'üy jas la cjolol. Pomada mirra mpes la tjajay, áloe mpes la tjajay wa, 'üsüstsja pajal. Pomada pajal püné teque'e, quintal pjaní jinwá tü waytsja. ");
INSERT INTO jicNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mpes yupj manas tjat' Jesús jüp'üy, 'ücj la tjajay la toc, judiopan lajay jinwá. Pomada pülül jas tjocjolol, jas tjüwü'ün Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne'aj way p'intsja Jesús cruz po'o tjovalapj mpe, ne'aj sin lejen̈. Sin lejen̈ nt'a pe jultsja, neven nt'a, tecya'lin̈ mo'o la püntüpj. Newa mo'o püntǘ secj tepe'á pe jul mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mpes Jesús jüp'üy pe jul tüpüntüpj, ne'aj p'intsja mpes. Ts'ac' niná nasa cyawájatsja, ts'ac' 'ücj lajaytsja ya mpes. Ya ma ca polel tsji' la mijicj. Nin mpes ma p'a wa la tjajay. ");
INSERT INTO jicNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo na, María Magdalena ne'as tjemey pe jul nt'a. Pajal püstaptsja, jaw secj p'in. Jupj tjinyuca jun vilicj jun cjol quinam. Pe jomwen jul nt'a tjo'onsopj nawaja'a, jas tentené, jun cjol tepyala quinam. ");
INSERT INTO jicNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mpes ts'üequené, Simón Pedro nt'a tjemey, discípulo p'a wa nt'a wa. Jesús pajal quelel líjitsja discípulo niná. María Magdalena tjevele yupj jis lal: —Yupj pje'á tjaman qjuis Jepa jüp'üy pe jul mpe. Cupj ma selecj ca'aj tüpüntüpj jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mpes Pedro tjemey. Discípulo ma'ajapj cus tecyon̈ca. Pe jul nt'a jiltsja Jesús jüp'üy tüpüntüpj nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Manas ts'equenen̈, mop'in discípulo ma'ajapj más 'in yümücj tjemey, más 'in len̈ way ne'as tjemey pe jul nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jay t'yoca, tjinyuca. Tjinyuca pülül newa patja, jüp'üy len̈. Ma wama tjemey jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Locopyaya ne'as tjemey wa Simón Pedro. Jupj pe jul tjemey. Tjinyuca wa pülül newa ne'aj pátjatsja. ");
INSERT INTO jicNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tjinyuca wa pülül jay tsyú'patsja jas tjan tüpü'ü, jas tjüwü'ün pǘ'ütsja. Ma pülül la p'a lal pǘ'ütsja. ");
INSERT INTO jicNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Discípulo ma'ajapj mwalá way ne'as tjemey pe jul nt'a, jupj newa pje'á ton̈ca. Simón Pedro wama tjemey na, discípulo ma'ajapj wama tjemey wa. Tjinyuca wa, mpes jupj tepyona Jesús niswa pü'ü. ");
INSERT INTO jicNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Newa ma sin 'yǘsatsja Dios Popel tjevelá Jesús mpes. Tjevele tepe'e na, Dios jostsja jupj ca jas müjünsüs, mpü'üm niswá. ");
INSERT INTO jicNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Discipulopan manas pje'á tjiquil pe jul mpe, jis wa nt'a tjil yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalena newa pje'á tón̈catsja pe jul nt'a, li piyutsja. Newa li piyutsja, jay t'yoca, tjinyuca pe jul mo'ó. ");
INSERT INTO jicNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jupj tjinyuca angelpan mat'eyá. Pje way sin quiptsja yupj. Jesús tüpü'ü nt'a játjatsja yupj. Jesús jay pjucj tüpü'ü nt'a já'asatsja pjaní wa. Tsjom tapatja nt'a já'asatsja ma'ajapj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yupj la tjü'üy María Magdalena lal: —¿Tsjan mpes li piyun? Jupj tjevele yupj jis lal: —Yupj pje'á la ts'i Nejepa, ne ma selé ca'aj tüpüntüpj jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nin tjevele na niná, cjüipe tjinyuca. Jupj jus tjinyuca Jesús tón̈catsja ne'aj. Ma seletsja jupj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús la tji'yüya jupj lal: —¿Tsjan mpes li piyun? ¿Pjacj le pal jipj? María Magdalena jólatsja jupj sin lejen̈ nt'a tsji' líjitsja. Mpes tjevele Jesús lal: —Jipj tjyam tepe'á, nawala tjevele ca'aj tjyam tipyüntün jupj. Mpes napj ca mis, ca man 'üsüs nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús jupj ló tjevele. —María —tjevele jupj. Mpes María niswa cjüipe tjinyuca, tjevele Jesús lal: —Raboni. (Ninana javelepj judiopan Dios mpes sin 'yüsa liji lal.) ");
INSERT INTO jicNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús tjevele jupj lal: —Po ma ntjutjilila. Custjay wine secj Mpapay pü'ü nt'a. Mpes jutja quinam napj mpülücpan nt'a. Tjevele yupj jis lal napj ca mis Mpapay pü'ü nt'a. Jupj napj Mpapay, nun jis Papay wa. Jupj napj Dios, nun jis Dios wa —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mpes María Magdalena tjemey, tjevele discipulopan jis lal: “Nasa jus tjinyuc qjuis Jepa Jesús”. Tjevele wa Jesús jupj lal tjevelá. ");
INSERT INTO jicNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nin jawas p'iyá, domingo püste na, discipulopan 'a jis tjimyula wa mo'ó. Lacj jeyaptsja yupj judiopan jis jepapan jis lal, mpes jun t'olon jun vilicj. Len̈ way Jesús lay tepyala yupj jis lal. Yupj lejen̈ culupwen nt'a tón̈catsja jupj. Tjevele yupj jis lal: —Ma nujola t'as pjü mpes. 'Üsüs mpatjaqué. ");
INSERT INTO jicNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Niná tjevele na, jis tje'yaya tjunuc jupj mos, wüints'il 'at'anca nt'a 'ots'ipj. Discipulopan pajal 'ücj jisastsja jus tjunuc. ");
INSERT INTO jicNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jupj niswa tjevele yupj jis lal: —Ma nujola t'as pjü mpes. Mpapay nin tjejyama nosis casá. Nin p'iyá napj nusin jyam quinam, ca nun tsji' la müjí napj mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nin tjevele na, yupj lejen̈ nt'a taná tjejyó. Tjevele yupj jis lal: —Na'ata nun Dios Cjües. ");
INSERT INTO jicNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Napj nu 'ya nun 'ücj la p'a jis lal welé Dios perdonar la siji quinam yupj malala la tjajay. Nun welé na niná, t'üc' way Dios perdonar la siji. Nu 'ya wa 'ücj welé la p'a jis lal Dios newa ma perdonar la siji yupj malala la tjajay. Nin welé na, t'üc' way Dios ma perdonar la siji —nin tjevele Jesús jupj discipulopan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús tjac' na discipulopan tjatja nt'a, len̈tsja Tomás. “Pjaní Popa Mat'eyá” lotsja wa Tomás. Jesús apostolpan dóceya popa watsja jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mpes locopyaya discipulopan p'a witjacj Tomás lal tjowelepj: —Nasa jus tjinyucucj qjuis Jepa Jesús. Tomás tjevele yupj jis lal: —Napj ma nyuc clavo mo'o t'yüjü mpe jupj mos nt'a, napj ma mo'o se jam namas clavo mo'o t'yüjü mpe, napj ma ca cüpon t'üc' way jupj pü'ü niswá. Napj ma namas mo'o se jam wüints'il 'at'anca mo'ó, ma ca cüpon napj. ");
INSERT INTO jicNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Locopyaya, ts'ac' ocho tjejyawca na, Jesús discipulopan niswa wa mo'ó 'a mulú tjatja. Tomás yupj jis lal já'asa watsja quinam. Jun t'olontsja jun vilicj; Jesús lay tepyala la p'in yupj jis lal. Yupj lejen̈ culupwen nt'a tón̈catsja. Tjevele: —Ma nujola t'as pjü mpes. 'Üsüs mpatjaqué. ");
INSERT INTO jicNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nin tjevele na, tjevele wa Tomás lal: —Tjinyuca namas. Myas mo'o jas tjejyama namas mo'ó, clavo mo'o tjemey mpe. Myas mo'o jas tjejyama wa newints'il mo'ó. Ma pajal jey c'a t'as jipj. Tepyona jipj napj pü'üs niswá —nin tjevele Jesús Tomás lal. ");
INSERT INTO jicNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás Jesús lal tjevele: —Jipj napj Nejepa, jipj napj Dios wa. ");
INSERT INTO jicNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús tjevele jupj lal: —Jipj nus tjinyuc mpes pyon quinam jipj. P'a wa ma nus tjunuc, mop'in japon yupj. Nin mpes yupj pajal 'ücj jisas liji Dios —nin tjevele Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús discipulopan tjunuc jupj la tjiji. Papel niná vele wa tsjan niná Jesús la tjijá. Pajal 'üsüs la tjiji sin la 'üsüs jis la jay jupj ne Dios Jatjam. Discipulopan tjunuc pajal la pülücj 'üsüs la tjiji papel niná ma pjü way vele. ");
INSERT INTO jicNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nepénowa tepyaca p'in. Tepyaca nusin 'yüsa lo jay, ne ca mponé nun Jesús ninana Yomen Dios jas tjejyama qjuis capj la p'acj. Dios Jatjam jupj. Mpes nun poné na jupj lal, Dios lal ca mpatjaqué lovin, nun Jesús cus tocon̈có mpes. ");
INSERT INTO jicNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Locopyaya Jesús niswa lay tepyala discipulopan jis lal, 'üsǘ püné la nt'a. Tiberias lotsja jupj, 'üsǘ. Pajal la pünetsja, pajal campwila watsja. Ninana Jesús la tjiji lay tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Discipulopan nepenowá 'a mulú játjatsja. Simón Pedro pjaní watsja, pjaní wa Tomás (“Pjaní Popa Mát'eya” lotsja jupj), Natanael pjaní wa. Natanael Caná mpe 'eseptsja, Galilea mpe se jütütj mpe. Zebedeo jatjampan yupj jis lal jatja watsja. Discipulopan p'a wa mát'eya yupj jis lal jatja watsja. ");
INSERT INTO jicNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro yupj jis lal tjevele: —Napj ca mis nts'icjucj. Pjü way p'a witjacj jupj lal tjowelepj: —Ncupj ca nlaca wa jipj lal. Mpes yupj tjil. Barco jul mo'o tjil la ts'icjucj; mop'in püste cus tüpwes ma la tocoy yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nasa quelel jyawca na, 'üsǘ la nt'a tón̈catsja Jesús. Discipulopan ma salejeptsja jupj Jesús. ");
INSERT INTO jicNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mpes Jesús tjevele yupj jis lal: —¿Ncu nasa to'á cjulun? Yupj wola tjowelepj: —Cjuwá. ");
INSERT INTO jicNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús tjevele yupj jis lal: —Barco li'inyampe la ts'iyá ataraya. Ne'aj pje'á la ncoyé ca. Mpes yupj mo'o la ts'i ataraya Jesús tjevele nt'a. Pajal pit'a tepyala ataraya cjulun lal, mpes yupj ma polel wama tüpüntüpj atarayas barco mo'ó. Tütsja pajal. ");
INSERT INTO jicNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesús pajal quelel líjitsja discípulo pjaní. Ninana discípulo Pedro lal tjevele: —'Üsǘ la nt'a ton̈ca ncupj qjuis Jepa jupj. Jupj tjapjaca na niná, jupj pülül pje'apa jas tücüi'pe. Jupj jas tji'ipje yas nam cjul la ts'icjucj. Mpes jas tücüi'pe na, 'üsǘ mo'o ntolo, la tjemyaya tjemey 'üsǘ la nt'a. ");
INSERT INTO jicNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","La p'a discipulopan barco mo'o tjiquil, la tjolocjocj cjulun ataraya mo'ó. Barco campa tuluctsja 'üsǘ la nepem. Ne'aj waytsja p'in, cien metro ca nacj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","'Üsǘ la nt'a tjil na, 'etsjecj 'awa tjunuc. Cjul püné 'yǘmatsja, pan jatja watsja ne'aj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús tjevele yupj jis lal: —Cjul nepénowa nca'á ma 'e, cjulun po quina 'its'u'cú popé. ");
INSERT INTO jicNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mpes Simón Pedro barco mo'o tjemey niswá, ataraya 'üsǘ la nt'a la tjelyo'cja. Cjul noypan pajal pülücj mo'o pátjatsja, ciento cincuenta y tres mo'o pátjatsja. Mop'in ma t'anca ataraya. ");
INSERT INTO jicNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús tjevele discipulopan jis lal: —Nculá nlajá. Ma yupj popa quelel la 'üytsja Jesús pjacj ne jupj. Yupj jus nlay qjuis Jepa Jesús jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús 'awa nt'a tjac', pan nt'ya, pjü jis tje'yaya. Cjulun jis tje'yaya wa. ");
INSERT INTO jicNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nasa la cónt'eya Jesús lay tepyala jupj discipulopan jis lal, jupj jas tjijyünsa, niswa nyucunú tepyala na. ");
INSERT INTO jicNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yupj tecyawaja tjalá naya, Jesús Simón Pedro lal tjevele: —Jipj Simón, Jonás jatjam. ¿Ncu más quelel la nejay jipj yupj jis lal? Jupj tjevele Jesús lal: —Jipj napj Nejepa. Jipj selen napj quelel la 'ejay. Mpes Jesús tjevele jupj lal: —Napj lal japon sin tjü'üsüs lis mijin napj mpes. Yupj napj no'oveja tsjictjacj jinwá. ");
INSERT INTO jicNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Niswa tjevele Jesús jupj lal: —Jipj Simón, Jonás jatjam. ¿Ncu t'üc' way quelel la nejay jipj? Jupj tjevele Jesús lal: —Jipj napj Nejepa. Jipj selen napj quelel la 'ejay. Mpes Jesús tjevele jupj lal: —Tjejyama napj mpes japon. Napj no'oveja jinwá yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús niswa tjevele jupj lal, la con tjevele nasa: —Jipj Simón, Jonás jatjam. ¿Ncu t'üc' way jipj quelel la nejay? Pedro 'aplijila tepyala la con la tji'yüya Jesús ncu quelel liji jupj. Jupj tjevele Jesús lal: —Nejepa jipj. Jipj selen pjü. Jipj jus nley napj quelel la 'ejay. Jesús tjevele jupj lal: —Napj mpes japon sin tji'yüsa lis mijin napj mpes. Napj no'oveja jinwá yupj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jipj tjamacjastsja na, jipj jin quipaptsja, jipj jaytsja wa jipj quelel jaytsja nt'a. Co'müy na, p'a casá ca mpalas. Jepjel la mpactan ca, ne p'a ca jin nqui'pas. Jipj ma quelel jay nt'a ca mya manus. T'üc' way niná —nin tjevele Jesús Pedro lal. ");
INSERT INTO jicNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jupj tjevele niná jas mü'üsüs la mijis nin ca mpalas Pedro lal, mpa'is jupj. Nin ca mpalas mpes ca p'a wa sin mü'üsüs Dios pajal 'üsüs, pajal püné. Jesús niná tjevele na, tjevele wa Pedro lal: —Ncapj tecyon̈ca jipj lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro la nujuya, tjinyuca. P'a discípulo jus tjinyuca cjüil tjac'. Jesús pajal quelel líjitsja niná discipulú. Jupj p'iyá Jesús jun 'asas tjemey discipulopan 'a mulú tjalá na, Jesús ma tepe'e na p'in. Jupj Jesús lal la tji'yüya pjacj ca mim jis lal ncuwim jupj enemigopan jis la tjilil jupj. ");
INSERT INTO jicNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mpes Pedro jus tjinyuca na niná discipulú, la tji'yüya Jesús lal: —¿Tsjan ca mpalas niná yom lal? ");
INSERT INTO jicNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús tjevele Pedro lal: —Ca nacj napj najas jupj pü'ü napj tjacuwis nas. Jipj ma ca nin jele nsem nepes. Ncapj tecyon̈ca jipj lovin. ");
INSERT INTO jicNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesús nin tjevele mpes, qjuis pülücpan pülücj tjowelepj niná discípulo ma ca cüpa'is. Jesús ma tjevele niná discípulo ma ca mpa'is lovin. Jupj tjevele: “Ca nacj napj najas jupj pü'ü napj tjacuwis nas. Jipj ma ca nin jele nsem nepes.” ");
INSERT INTO jicNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Napj p'iyá niná discipulú. Napj p'iyá nin velé la p'a jis lal napj tjinyuc. Napj tepyac niná. Cupj selecj napj velé t'üc' way. ");
INSERT INTO jicNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","P'a wa pajal pülücj la tjiji Jesús, ma tepyac qui'á. Napj nola napj pjü cüpac, cjuwá nosis mo'ó ca'aj cüpajatj papel pjü. Nasa tecyawaja tepyac.");
INSERT INTO jicNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, püna 'in napj tepyac Jesucristo la tjijá. Tepyac wa jupj sin tji'yüsa la tjijá. ");
INSERT INTO jicNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nosis nt'a tjuwine na, apostolpan lis t'ya. Jupj tjijyü'ta yupj ca nin la mijicj jupj tjevele jin. Jupj tjevele Dios Cjües nin jostsja jupj velá. ");
INSERT INTO jicNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesucristo pajal malala tepyala, tepe'e. Locopyaya jas tjijyünsa, tüpü'ü niswá. Nin tepyala na, ts'ac' cuarenta lay tepyala apostolpan jilal. La pülücj lay tepyala. Jupj la tjiji mpes yupj sin tji'yüsa jupj tüpü'ü niswá. Jupj sin tji'yüsa lis tjiji Dios jyü'ta po'ó. ");
INSERT INTO jicNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","La pjaní jis tjijyü'ta: —Ma pje'á lowa custjay Jerusalén mpe. La tjunucú nun Dios Cjües jac' mpes. Mpapay tjevele jupj Cjües jas majamas nun nt'a. Napj tjevelé nun jilal nin ca mpalas. ");
INSERT INTO jicNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan bautizar lis tjiji 'üsǘ mpes la p'in. Más 'üsüs ca nu mpalas quinam. Dios ca nu ma'ayas jupj Cjües. Ts'ac' pjaní way p'in tepyala na ca nin mpalas —nin tjevele Jesucristo. ");
INSERT INTO jicNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostolpan 'a jis tjimyula na Jesucristo lal, tjowelepj jupj lal: —Qjuis Jepa, jipj selen la p'a way jajütütj quinam israelpan jis lal. ¿Ncu len̈ way ca mal yupj, israelpan jis la jütütj yupj p'iyá? ¿'Ona ca nin la mijin, Dios Popel vele jinwá? ");
INSERT INTO jicNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesucristo jis wala tjevele: —Mpapay jos nun ma ca jus nlayé tsjan jawas ca nin mpalas. Jupj p'in selé tsjan jawas niná ca la mijis israelpan jis lal. ");
INSERT INTO jicNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Najas p'a wa ca jus nlayé. Dios Cjües nujisas mo'o tjemey na, ca 'üsüs polel la müjí nun. Ca polel mvelé la p'a jilal napj mpes. Napj mpes solejé mpes ca mvelé. Nin ca la müjí Jerusalén nt'a, Judea nt'a 'ots'ipj, Samaria nt'a 'ots'ipj, nosis casá jas tüpwes ca nin la müjí —nin tjevele Jesucristo. ");
INSERT INTO jicNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesucristo t'üc' tjevele na, Dios tsjun po'o tjemyana jupj. Tjemey na, apostolpan jus tjunuc. Mol mo'o tjemey. Mol mpes ma polel jus tjunuc tsjun po'ó tjemey na. ");
INSERT INTO jicNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Newa januctsja. Januctsja na, ángel mat'e lay jis tepyala yupj nt'a. Niyom jinwá yustaptsja yupj. Yupj sin quip pje waytsja. ");
INSERT INTO jicNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tjowelepj: —¿Tsjan mpes tsjun po'o nucú? Tjunuc Jesucristo tjemey tsjun po'ó. Nin p'iyá ca ncuwim niswá —nin tjowelepj. ");
INSERT INTO jicNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mpes yupj tjil joc' mpe, joc' niná Olivos ló. Tjil Jerusalén nt'a. Ne'aj p'intsja; judiopan 'ücj ne'aj tjil sábado na, nin jawas ma polel campa jiltsja. ");
INSERT INTO jicNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wosis cuarto viyapa mo'o tjil. Ne'aj tapátjatsja yupj quinam, apostolpan. Ne'aj tjátjatsja Pedro, Jacobo 'ots'ipj, Juan 'ots'ipj, Andrés 'ots'ipj. Tjátjatsja wa Felipe, Tomás 'ots'ipj, Bartolomé 'ots'ipj, Mateo 'ots'ipj. Tjátjatsja wa Jacobo (jupj ne Alfeo popa), Simón 'ots'ipj. (Simón le palánatsja jepa lal, jepa israelpan popa tulucj. Nin mpes “Israel Mpes Jola” lotsja wa jupj.) Judas já'asa watsja (jupj ne Jacobo pópatsja). ");
INSERT INTO jicNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pajal la pülücj 'a jis tjimyula jis la veles Dios lal. Nequem nepenowá tjiquil wa, Jesucristo jamay 'ots'ipj, Jesucristo jatjaypan 'ots'ipj, tjiquil wa; 'a jis tjimyula yupj tjatja nt'a. ");
INSERT INTO jicNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","P'a jawas Jesucristo lal japon witjacj ciento veinte 'a jis tjimyula. Pedro jas tjijyünsa, tjevele: ");
INSERT INTO jicNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Natjampan, nun solejé püna David papel tepyaca Judas po'ó. Tepyaca Dios Cjües jostsja nin tepyaca jupj. Tepyaca Judas ca nin la mijis, ne nawaja'a Judas nin la tjiji David tepyaca jin p'iyá. Dios Popel tjevele ca nin la mijis, mpes nin la tjiji. Judas niyom jis ticyuna, Jesucristo la tjilil. ");
INSERT INTO jicNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas cupj sin pópatsja. T'üc' way Jesucristo la t'ya jupj 'ots'ipj, Dios mpes tsji' la tjiji 'ots'ipj. ");
INSERT INTO jicNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mop'in nin, pasal malala la tjiji Jesucristo lal. Yupj t'emel tja'ayapj Judas, jupj malala la tjiji mpes. 'Amá jaylacj la tjiji t'emel niná mpes. Ne'aj wolap'a'a tyüla, jupj col tjopjolta. Juts'ul pje'á palá tinca. ");
INSERT INTO jicNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pjü way Jerusalén po'o patja sin tji'yüsa nin tepyalá. Mpes 'amá niná jupj jaylacj la tjiji yupj ló la t'apj. Acéldama lotsja momas ne'aj. Yupj jis tin javelepj yupj, mpes Acéldama javelepj. Cupj velecj: ‘'Amá 'As’ ”, Pedro nin tjevele. ");
INSERT INTO jicNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro tjevele niswá: “Püna Dios mpes tjenejets'en̈ tapac mo'ó yom pjaní tepyaca Judas po'ó: ‘Pjü ca mal jupj wo mpe. Wo mo'ó cjuwá ca nsem. Ma ca p'a mpü'üm jupj wo nt'a. Jupj ma polel sin 'yüsa la mijis quinam. La p'a ca nin la mijis quinam jupj la tjijá’, nin tepyaca yom pjaní. ");
INSERT INTO jicNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Mpes yom p'a wa apó