﻿USE sofia;
DROP TABLE IF EXISTS sofia.jib_vpl;
CREATE TABLE jib_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jib_vpl WRITE;
INSERT INTO jib_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wàníng í tarkada á shinn yàkúká bu Yesu Kristi wùn Dawuda, Dawuda í wùn Ibrahim. ");
INSERT INTO jib_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim mà Ishaku, Ishaku mà Yakubu, Yakubu mà Yahuda ma shunwàuwá big ma wunzàwá big. ");
INSERT INTO jib_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda mà Parisa ma Zaraha, zìnn nàbá í Tamara. Parisa mà Hasaruna, Hasaruna mà Arama. ");
INSERT INTO jib_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama mà Aminadabu, Aminadabu mà Nahashuna, Nahashuna mà Salmuna, ");
INSERT INTO jib_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuna mà Buaza, zyun-à nàwá í Rahab. Buaza mà Obida zyun-à nàwá í Rautha. Obida mà Yassa, ");
INSERT INTO jib_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yassa mà kùr Dawuda. Dawuda bó mà Sulemanu zyun-à nàwá í wà ki Uriya. ");
INSERT INTO jib_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemanu mà Rahabama, Rahabama mà Abiya, Abiya mà Asa. ");
INSERT INTO jib_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mà Yahushafata, Yahushafata mà Yurama, Yurama mà Uzzaja. ");
INSERT INTO jib_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzzaja mà Yuthama, Yuthama mà Ahaza, Ahaza mà Hizkiya. ");
INSERT INTO jib_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkiya mà Manassa, Manassa mà Amuna, Amuna mà Yushiya. ");
INSERT INTO jib_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yushiya mà Yakunya ma wunzà wàníng big, á sai-à big gbar zìg yag sig mpìr Israilaká ma gbam mà Babila. ");
INSERT INTO jib_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Barà big zìg yag big mà Babila, ásim Yakunya bi mà Shaaltila, Shaaltila mà Zarubabila. ");
INSERT INTO jib_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabila mà Abihuda, Abihuda mà Aliyakima, Aliyakima mà Azura. ");
INSERT INTO jib_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azura mà Saduka, Saduka mà Ahima, Ahima mà Aliyuda. ");
INSERT INTO jib_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyuda mà Aliazara, Aliazara mà Mattana, Mattana mà Yakubu. ");
INSERT INTO jib_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu mà Yusufu nù Maryamu, Maryamu zyun-à mà sig Yesu wà big ri bar rag í Almasihu. ");
INSERT INTO jib_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bu-à pànn sig á zamanu Ibrahim hár bi fòr Dawuda í zamanu dwib agban yina. Bu-à pànn sig á zamanu Dawuda hár bi fòr á sai-à big zìg yag big mà Babila, í zamanu dwib agban yina tìnn. Bu-à pànn sig á sai-à big zìg yag big mà Babila hár big mà sig Yesu, í zamanu dwib agban yina tìnn. ");
INSERT INTO jib_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wàníng í barà big mà sig Yesu Kristi áni. Nàwá Maryamu ma Yusufu big rag bá sìr ban, ama á sai-à ku kà fig ma á lu wunù-à hi ni bàna, ku shi sig ma finn zyun-à bi sig mà byar Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu í mpìr ǹsàn, ku zìm fig aku sa pànn Maryamu àzunái áyau bìr mpìrká ni bàna. A byar-à hi ku kyab barà kwá bònn ta fim rìg wàníng, kada mpìrká abig yì bàna. ");
INSERT INTO jib_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Barà ku ri kyab àdòníng, sái wùn aswam Shìdun mà wai bi á byarwá ni á la-à ni n rag, “Yusufu yiwai Dawuda, á shàr zinn wà wá zìg wàwú Maryamu bàna, jir kai bàna ku yìm fig í finn sa bàna, ama finnwá bi sig á byar Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kwá mà wùn wunù, wá bar zìnnwá Yesu, jir kai bàna wàníng má zìg zú nì mpìrká buwá á bu pyìrbá ni.” ");
INSERT INTO jib_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bu káníng sa sig àjirà bu-à mpìr adang kyann jir Shìdun dang sig sai-à rì níng, aku shi àràg barà ku rì dang sig. ");
INSERT INTO jib_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ku dang rag, “Aning myàng, uwà sáb zyun yì fig wunù bàna má yìm finn, má mà wùn wunù, bá bar zìnnwá Immanuel.” (Yìr zìnn Immanuel í “Shìdun shi sig ma yi.”) ");
INSERT INTO jib_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Barà Yusufu dù nann zu á na-à ni, ku sìr ban ma wàwá Maryamu àràg barà wùn aswam Shìdun dinya sig ku. ");
INSERT INTO jib_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama ku yì fig wàníng í uwà bàna hár wàníng bi mà wùnwá. Ku bar zìnn wùn-à hi rag Yesu. ");
INSERT INTO jib_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Big mà sig Yesu mà finn swann Baitalami á jànn Yahudiya, á sai-à Hirudus rì na sig kùrwá. A byar-à níng hi mpìr yarká zyun-à ri myàng yì asuswirká níng, bi sig mà agunn àyúnn sàn kyùr, n yag fòr mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Big bib rag, “Ma wùn-à big mà sig ku í kùr Yahudawaká níng, ku shi sig áni rà? Yi myàng hing asuswirwá mà agunn àyúnn sàn kyùr, í bu-à sa yi bi sig jirà ayi wib ku.” ");
INSERT INTO jib_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Barà kùr Hirudus fig àdòníng, pìkyinnwá í bai rìgwá ma bu mpìrká mà Urushalima bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ku bar kwonn rìg àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma malamká, n bib big byar-à bá mà Almasihu, zyun-à Shìdun dang rag kwá swam bi níng. ");
INSERT INTO jib_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Big dinya ku n rag, bá mà wàníng á finn swann Baitalami mà jànn Yahudiya, jir kai bàna í bu-à mpìr-à ri dang kyann jir Shìdun níng, ba sig n rag: ");
INSERT INTO jib_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wù Baitalami swann Yahudiya, wù í swann títi bàna á finn jànn Yahudiya, jir kai bàna áyauwú ni bá zìg zu bi kùr zyun-à má shi kang mpìr Israilaká.” ");
INSERT INTO jib_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A byar-à níng hi, kùr Hirudus bònn bar mpìr yar káníng n bib big ádàn n rag, big myàng sig asuswir-à níng ákaun rà? ");
INSERT INTO jib_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ku swam yag big mà Baitalami n rag, “Aning yag àjirà aning bib byann jir wùn-à hi ádàn. Wà na bib dìg hing ku, aning bi dinya mì jirà mì má ń yag ń wib ku tìnn.” ");
INSERT INTO jib_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A byar-à hi big dù n yag kyonnbá. Asuswir-à big nìm myàng sig mà agunn àyúnn sàn kyùr níng, ri yag á pyànnbá ni hár n yag sar mà byar-à wùn-à hi shi sig. ");
INSERT INTO jib_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Barà big myàng asuswir-à àdòníng, big fig àjwár á pìkyinnbá ni wàni. ");
INSERT INTO jib_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Big kà yag mà lu-à hi, n myàng wùn-à shi sig ma nàwá Maryamu, big bìnn kir wann á pyànnwá ni n wib ku. Big fìnn swánnbá, n ya wùn-à hi zinariya ma lubann ma mur, bu káníng ri ning swìnn ǹsàn nímá. ");
INSERT INTO jib_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Shìdun dinya big á la-à ni n rag abig kàng yag mà byar Hirudus bàna, abig bàg gbìb zyun kim ma abig kàng yag mà jànnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Barà mpìr yar káníng dù mi ri yag àdòníng, sái wùn aswam Shìdun bi á byar Yusufu á la-à ni n rag, “A dù, á zìg wùn-à níng ma nàwá. A shàr yag rìg mà Masar jirà aning shi màhàn, sái àyúnn-à ma dang rag á dù, jir kai bàna Hirudus ri zìm aku gban rìg wùn-à hi.” ");
INSERT INTO jib_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ku dù n zìg wùn-à ma nàwá á fi-à níng hi, n yag mà Masar. ");
INSERT INTO jib_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A byar-à níng hi, ku shi shuwá màhàn hár Hirudus bi wu kiwá. Bu-à níng sa sig àdòníng jirà bu-à Shìdun rì dang sig á nu mpìr-à rìi dang kyann jírwá n rag, “N zìg zu hing wùnmí áyau mpìr Masar ni” níng, aku shi àràg barà ku rì dang sig. ");
INSERT INTO jib_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Barà Hirudus myàng mpìr yar káníng tonn gban ku, n kàng bi fig rag bàna níng, pìkyinnwá í bai rìg-à. Ku swam yag rag, abig gban rìg yann wunùká á Baitalami ma ká zyun-à shi yàr sig ma finn swann-à hi, ká zyun-à jibá fòr sig pyànà, ma ká zyun-à fòr fig bàna. Bu-à níng sa sig àdòníng, jir kai bàna mpìr yar káníng dinya sig ku sai-à big myàng sig asuswir wùn-à níng. ");
INSERT INTO jib_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A byar-à níng hi, bu-à Irimiya mpìr-à rìi dang kyann jir Shìdun dang sig níng, sa hing àràg barà ku dang sig. ");
INSERT INTO jib_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ku dang rag: “Mpìrká fig big ri kig nàikitáu ki mà Rama. I Rahila ri kig yanká buwá. Ku ngàng wà a mpìrká tonn bying ku, jir kai bàna yanká buwá wu gban rìghing.” ");
INSERT INTO jib_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Barà Hirudus wu àdòníng, sái wùn aswam Shìdun mà wai bi á byar Yusufu á la-à ni á Masar n rag, ");
INSERT INTO jib_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“A dù á zìg wùn-à níng ma nàwá á kàng yag rìg mà jànn Israila, jir kai bàna mpìrká ri zìm abig gban wùn-à níng, big wu rìghing.” ");
INSERT INTO jib_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ku dù n zìg wùn-à ma nàwá, n kàng yag rìg mà jànn Israila. ");
INSERT INTO jib_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Barà Yusufu fig rag Arkilayas wùn Hirudus zìg rìghing kùr tawá Hirudus, mi ri na kùr á shinn mpìrká á Yahudiya, sái zinn pànn rìg ku wà kwá yag màhàn. A byar-à hi Shìdun bi á byarwá ni á la-à ni n twìb ku byur. I byar-à ku í yag rìg-à mà jànn Galili. ");
INSERT INTO jib_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A byar-à hi ku yag n shi mà swann-à big ri bar rag í Nazarat, àjirà bu-à Shìdun dang sig á nu mpìrká rìi dang kyann jírwá níng, aku shi àràg barà ku dang sig. Big dang rag, “Bá bar ku mpìr á Nazarat.” ");
INSERT INTO jib_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Asai-à bó hi ni, Yohanna àsàin-à ri sa batisma bi, mi ri dang jir Shìdun mà awúnn-à ni mà Yahudiya. ");
INSERT INTO jib_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ku ri dang rag, “Aning fim bu pyìr sa, jir kai bàna àyúnn-à Shìdun má na kùrwá áni níng, nyàan fòr.” ");
INSERT INTO jib_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanna í mpìr-à Ishaya mpìr-à rìi dang kyann jir Shìdun rì dang sig jír á shinnwá ni n rag, “Mpìr zyun-à má swam yag ku níng, ku shi sig mà awúnn-à ni, ku ri dinya mpìrká jírmí rag, ‘Aning wàu kyàr gbìb-à Shinn Luyí má bàg áni. Byar-à gbìb-à gor sig níng, aning wàu lab finn yag rìg mà pyànn.’ ” ");
INSERT INTO jib_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jà Yohanna big zwàu sig ma wai rakumi, ku sìr gbam sig agau mìrwá ma wau. Bujuwá í àtìbàin ma dain. ");
INSERT INTO jib_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A byar-à níng hi, mpìrká mà Urushalima ma mpìrká mà Yahudiya bidìm pár ma byar-à shi yàr sig mà Ning Urdun, big zu n yag mà byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Big dang bu pyìrbá big sa sig, í wà ku wau big dìr batisma mà Ning Urdun. ");
INSERT INTO jib_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Barà Yohanna myàng Farisawaká ma Sadukiyawaká nìnànn nímá ri bi àjirà aku wau big dìr batisma, sái ku bib big n rag, “Ning í bushùwí big, í ni dinya sig ning í nì rag, ‘Ná zu shwìn bu-à Shìdun dang sig rag kwá swam bi níng’ rà? ");
INSERT INTO jib_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aning sa bu-à mpìrká má yì rag ning fim rìghing bu pyìrná. ");
INSERT INTO jib_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kada aning kyab rag, ná zìg zu shinn ná á shwìn-à ri bi níng ni jirà taná í Ibrahim níng, bàna. N dinya ning Shìdun má sa yì bu-à ku ri zìm, kwa zìm hing, kwá zìg abàn káníng ma màm yann adaká bu Ibrahim ma kàhi. ");
INSERT INTO jib_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aki shi sig áni zyun-à bá kyag ta wann rìg bín-à ma wan fig awan ǹsàn bàna, bá ta kà rìg mà pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mì ri wau ning dìr batisma ma zàpìr jirà mpìrká abig yì rag ning fim rìghing bu pyìrná. Ama mpìr-à má bi ásimmí ni níng, kwá wau ning dìr batisma ma Awun Shìdun, ma pyìr. Ku í àgbammí, kó tabarwá má, ǹ fòr fig wà má swann dù bàna. ");
INSERT INTO jib_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Atìtìrwá shi sig á vùwá ni, kwá pìm kyàr rìg zawá ǹsàn nímá, ma wìr kwonn rìg yìr zawá í byar ńzyun má wìr kà rìg mà vonn-à ni. Kwá wìr kà rìg asinnká á pyìr-à má dim fá dim bàna.” ");
INSERT INTO jib_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Asai-à níng hi, Yesu dù mà Galili mi ri yag mà Ning Urdun á byar Yohanna, àjirà a wàníng wau ku dìr batisma. ");
INSERT INTO jib_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohanna ri zìm aku kan dim ku, n rag, “Mì zyun-à mì ri zìm á wau mì dìr batisma, í wà à bi á byarmí ni rag ń wau wù rà?” ");
INSERT INTO jib_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A byar-à níng hi, Yesu dinya ku rag, á sa mì àdòníng tàma-à níng, àjirà ayi bàg bu-à Shìdun ri zìm. A byar-à hi Yohanna í zìm rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Barà big wau kinn rìg Yesu dìr batisma àdòníng, sái ku í nann zu rìg-à mà zàpìr-à ni, waisháu-à bó í pù fim-à sa hauu. Ku myàng Awun Shìdun ri wann bi àràg í àlàb ri bí nì á shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nài jír zu bi mà waisháu-à ni n rag, “Wàníng í wùnmí zyun-à mì ri zìm, zyun-à pìkyinnmí ri fig àjwárwá wàni.” ");
INSERT INTO jib_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A byar-à níng hi, Awun Shìdun zìg yag Yesu mà awúnn-à ni àjirà a Shaitan màg màg fig ku. ");
INSERT INTO jib_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ku sìnn nu su dìpyànà fi ma àyúnn, ku ji fig bu zyun bàna. A byar-à níng hi amor bi gban ku. ");
INSERT INTO jib_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","I byar-à Shaitan bi á byarwá ni n rag, “Wà wù ma í wùn Shìdun, á dang abàn káníng abig kàng buju.” ");
INSERT INTO jib_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sái Yesu dinya ku n rag, “Big ba sìnn sig á tarkada Shìdun n rag, ‘Mpìr má shi fig ma yonki íri jir buju ji bàna, ama sái ma jírká zyun-à ri zu bi mà nu Shìdun ni.’ ” ");
INSERT INTO jib_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","I byar-à Shaitan zìg yag ku mà finn swann Urushalima, n sìnn ku á shinn lu Shìdun ni mà wai, ");
INSERT INTO jib_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","n rag, “Wà wù ma í wùn Shìdun, á pìm tìg wann bi á jìnn ni, jir kai bàna big ba sig rag, ‘Shìdun má swam bi yann aswamwá big, bá myàng kwonn ma wù í zyun. Bá jag vù má pànn wù, àjirà kada á wab barwú abàn bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A byar-à hi Yesu dinya ku rag, “Ama big ba sig rag, ‘Kada á màg màg fig Shìdunwú bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A byar-à hi Shaitan zìg yag ku mà shinnkwìnn-à ni mà wai, n tìya ku byar shu kùrká á dunyaru bidìm pár, ma barà káníng wài sig áni, ");
INSERT INTO jib_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","n dinya ku rag, “Wà wa bìnn kir wann hing á jìnn ni ma wib hing mì, bu káníng bidìm pár má ya wù.” ");
INSERT INTO jib_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A byar-à hi Yesu dinya Shaitan rag, “A gàb dìr ma mì, jir Shìdun dang rag, ‘A wib íri Shinn Luwú Shìdun ku awínwá ni.’ ” ");
INSERT INTO jib_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A byar-à hi Shaitan dù n fim ku. Yann aswam Shìdun mà wai bi, n myàng kwonn ma ku í zyun. ");
INSERT INTO jib_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Barà Yesu fig big rag big pànn rìghing Yohanna n sìnn kà rìghing wàníng mà tonn fi níng, sái ku dù mi í yag rìg-à mà Galili. ");
INSERT INTO jib_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ku shi fig mà swann Nazarat bàna, ku í yag rìg-à mà Kafarnahum n shi màhàn mà nu zàpìr-à ni, mà shab jànn Zabuluna ma Naftali, ");
INSERT INTO jib_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","àjirà bu-à Ishaya mpìr-à rìi dang kyann jir Shìdun dang sig níng aku shi àràg barà ku dang sig n rag: ");
INSERT INTO jib_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Mpìr káníng bidìm pár shi sig á zufi-à ni. Mpìrká á Zebuluna ma Naftali, ma mpìrká á nu níng-à ni, ma ká zyun-à shi sig mà agunn Ning Urdun, ma ká zyun-à big í mpìr Yahudawaká bàna shi sig mà jànn Galili, mpìr káníng bidìm pár shi sig á zufi-à ni, ama tàma-à níng àyar yar wann bi hing á byarbá ni.” ");
INSERT INTO jib_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A byar-à níng hi, Yesu kà mi ri dang rag jir Shìdun n rag, abig fim bu pyìr sa, jir kai bàna àyúnn-à Shìdun má na kùrwá nyàan fòr. ");
INSERT INTO jib_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Barà ku ri kyann yag mà nu Ayunn Galili àdòníng, sái ku myàng mpìr pyànà, zyun í Siman zyun-à big ri bar rag Bitrus, ma wunzàwá Andarawus. Big ri vinn birgi mà zàpìr-à ni, jir kai bàna big í mpìr apànn jái big. ");
INSERT INTO jib_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu dinya big n rag, “Aning bàg bi mì. Barà ning ri pànn jái níng má tàg ning barà ná pànn zìg bi rág mpìrká á byarmí ni.” ");
INSERT INTO jib_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A byar-à níng hi, big dù báb, n fim rìg birgibá, n bàg yag rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Barà ku ri yag àdòníng, sái ku myàng mpìr pyànà big, zyun í Yakubu wùn Zabadi, big Yohanna wunzàwá. Big shi sig á kòr-à ni, kwonn ma tabá Zabadi. Big ri sa samyib birgibá, sái Yesu bar big. ");
INSERT INTO jib_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A byar-à níng hi, big dù báb, n fim rìg kòrbá ma tabá, n bàg yag ku. ");
INSERT INTO jib_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kyann gban rìg finn swannká á jànn Galili mi ri dang jir Shìdun mà tonn bìr kwonn-à ni. Ku ri dang jír á shinn barà Shìdun má na kùrwá, mi ri dàb kwonn ma mpìr dorká kim kim. ");
INSERT INTO jib_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Taiwá kàng kwìb vinn rìg jànn Suriya. A byar-à níng hi, mpìrká ri zìg bi mpìr dorká kim kim, ma ká ri wa shwìn, ma ká zyun-à wàu dab sig big, ma mpìr dor kwonnká, ma ká zyun-à dìrbá wu tag sig. Ku dàb gbam rìg big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bìr mpìrká nìnànn nímá dù n kan bàg yag rìg ku mà jànn Galili big Dikapolis big Urushalima big Yahudiya big jànn mà agunn Ning Urdun mà jann. ");
INSERT INTO jib_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Barà Yesu myàng bìr mpìrká àdòníng, ku nann zu mà shinnkwìnn-à ni, n shi màhàn. Yann sukàwá big bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A byar-à hi ku kà mi ri tàg big n rag, ");
INSERT INTO jib_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mpìrká yì hing Shìdun á kyinnbá ni, n yì hing rag big kinn fig bu bàna níng, bá fig àjwár, jir kai bàna big shi sig á vù Shìdun, ku í kùrbá. ");
INSERT INTO jib_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Mpìrká zyun-à pìkyinnbá ri bai níng, bá fig àjwár, jir kai bàna Shìdun má sa tag wann rìg pìkyinnbá. ");
INSERT INTO jib_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Mpìrká ri myàng shinnbá àràg big í bu zyun bàna níng, bá fig àjwár, jir kai bàna dunyaru má shi í bubá. ");
INSERT INTO jib_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Mpìrká zyun-à ri zìm abig sa bu-à Shìdun ri zìm níng, bá fig àjwár, jir kai bàna Shìdun má ya big bu-à big ri zìm. ");
INSERT INTO jib_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Mpìrká ma ri myàng ashi jàubá, bá fig àjwár, jir kai bàna Shìdun má myàng ashibá tìnn. ");
INSERT INTO jib_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Mpìrká zyun-à ma shi sig ma pìkyinn-à kyìkyàr, bá fig àjwár, jir kai bàna bá myàng Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Mpìrká zyun-à ma ri jùn kwonn mpìrká í byar ńzyun, bá fig àjwár, jir kai bàna bá bar big yann Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Mpìrká zyun-à mpìrká ma ri ya big shwìn jir shinn bu-à ǹsàn big ri sa á zìnn Shìdun, bá fig àjwár, jír kai bàna kùr Shìdun í bubá. ");
INSERT INTO jib_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Wà mpìrká ma ri swau ning, ma sìnn kà ning á shwìn, ma gim ya mpìrká ǹsáng á shinn ná ni jirà ning í bumí, ná fig àjwár. ");
INSERT INTO jib_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wà ba sa hing àdòníng, aning fig àjwár, jir kai bàna ladaná ùwài nímá shi sig mà wai. Wàníng í barà big rì sa sig mpìrká ri dang kyann jir Shìdun wàrì, káníng wa sig shwìn. ");
INSERT INTO jib_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ning shi síg nì mann dunyaru. Wà àdór mann ma vinn rìghing bá sa dor rág ma kai rà? Ai bàna. Má sàn fig rag bàna, bá wìr kìfinn rìg. Mpìrká má tib wam zu bar áni. ");
INSERT INTO jib_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ning shi síg nì àyar dunyaru. Finn swann-à ba mi sig mà shinn mwír-à ni má shi fig í bu atàm bàna. ");
INSERT INTO jib_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mpìr má mònn bàg hing pitila kwá zìg fig kwài má bir dim fig áni bàna. Sái kwá sìnn á shinn bu àjirà aku yar gban rìg lu-à bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ayarná aku yar á pyànn mpìrká ni àràg barà pitila ri yar àjirà abig myàng bu ǹsànká ning ri sa, ma abig wib Taná zyun-à shi sig mà wai. ");
INSERT INTO jib_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kada aning kyab rag ǹ bi sig jirà ń vim bìr rìg doka-à Musa ba sig, kó bu-à mpìrká rìi dang kyann jir Shìdun ba sig. N bi fíg jir wàníng bàna, ama ǹ bi síg jirà ń sa yà zu bu-à big ba sig. ");
INSERT INTO jib_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mì ri dinya ning àjai, hár dunyaru ma waisháu má vinn rìg, ama áyau doka Musa kó bu ńzyun má jànn fig bàna, sái bu-à big ba sig níng ma sa hing. ");
INSERT INTO jib_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mpìr-à ma bàg fig doka káníng, kó zyun-à áyau-à ni títi nímá níng bàna, ma tàg mpìrká rag abig bàg bàna tìnn, bá myàng ku àràg bu títi mà lu Shìdun ni. Ama mpìr-à ma wib hing doka-à níng, hár ma tàg hing mpìrká, bá bar ku í bu ùwài mà lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mì ri dinya ning, wà na sa àsàn ná ma kab fig bu malamká ma Farisawaká bàna, ná kà fig kùr Shìdun bàna. ");
INSERT INTO jib_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ning fig hing big rì dinya sig àgbamká buyí wàrì n rag, kada abig gban ki bàna, mpìr-à ma gban hing ki bá wà kwonnwá. ");
INSERT INTO jib_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama mì ri dinya ning mpìr-à ma nànn hing àgùnn ma jàuwá big, bá wà kwonnwá. Mpìr-à ma dang rag jàuwá í àning, bá zìg yag ku mà pyànn àgbamká ri wà kwonn jír. Mpìr-à ma dang rag, jàuwá bàna ma kyinn, bá zìg ku má tìr kà rìg mà lu pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wà wù ma ri zìm á ya Shìdun bu mà luwá ni, mà byar-à níng hi, wà wù ma ri kyab pànn barà ning ma jàuwú bai sig dìr, ");
INSERT INTO jib_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sái á fim rìg bu yawú hi màhàn. A yag àjirà á dìg jàuwú hi ma aning jùn kwonn rìg ḿpyim, í wà á bi ya rag Shìdun bu-à à zìg bi sig. ");
INSERT INTO jib_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mpìr-à ma bar sig wù kara, wà ning ma ku ma ri yag á gbìb-à ni, á jùn kwonn ma ku, jirà kada aku dang bai wù á pyànn agib jír bàna, agib jír aku ya kà wù á vù asìr dìr, jirà abig du kà wù á tonn fi bàna. ");
INSERT INTO jib_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N dinya wù, wa sa fig àdòníng bàna, wá shi mà tonn fi-à ni sái wà wa vinn rìghing bài-à big gib ya sig wù níng. ");
INSERT INTO jib_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ning fig big rì dang rag, ‘Kada á sa àyái bàna.’ ");
INSERT INTO jib_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama mì ri dinya ning, mpìr-à ma myàng byann hing uwà ma ri zìm aku sa àyái ma wàníng, ku sa rìghing àyái á kyìnnwá ni. ");
INSERT INTO jib_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wà zu vìm nuwú ma ri sa wù á sa bu-à bibai, á kpab zu rìg ma á tafinn rìg. Sàn kab síg wà zuwú aku bai rìg ma wà bá ta kà rìg dìrwú bidìm pár á pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wà vìm nuwú ma ri sa bu-à bibai, á gib kìm rìg ma á tafinn rìg, sàn kab síg nì àdòníng ma wà dìrwú bidìm pár má kà á pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Big dang hing n rag ‘Mpìr-à ma kan hing wàwá, aku ya wàníng tarkada ban gban.’ ");
INSERT INTO jib_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama mì ri dinya ning, mpìr-à ma kan tafinn hing wàwá, wà ma í jír àyái bàna, ku ri sìnn kà a wàníng sa àyái. Mpìr-à ma zìg hing uwà-à big kan tafinn sig àkan tafinn, ku ri sa àyái ma wàníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ning fig hing big rì dinya hing àgbamká n rag, ‘Wà wa tun hing ki, á sa bu-à à gib sig nu ma Shìdun n rag wá sa níng.’ ");
INSERT INTO jib_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama mì ri dinya ning, aning tun ki bàna, kó títi nímá, kó ma waisháu, jir kai bàna í byar-à Shìdun ri na kùrwá, ");
INSERT INTO jib_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kó mà jànn á jinn ni, jir kai bàna í byar-à Shìdun ri tib barwá áni, kó mà Urushalima, jir kai bàna í finn swann kùr ùwài. ");
INSERT INTO jib_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kada á tun ki ma shinnwú bàna, jir kai bàna wá sa yì fig jinn mìmìg aku kàng pìpìr bàna. ");
INSERT INTO jib_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kada aning tun ki bàna, ama aning zìm rag, ‘Nn,’ kó ‘A a.’ Wà na tun hing ki, sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ning fig hing big dang rag, ‘Mpìr-à ma wab bàg zuwú, á wab bàg zuwá tìnn. Mpìr-à ma wab kag nginnwú, á wab kag nginnwá tìnn.’ ");
INSERT INTO jib_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama mì ri dinya ning tàma-à níng kada aning sa pyann mpìr-à ma sa ning bu-à bibai bàna. Mpìr-à ma dab wù vù á sun kyìr agunn vìm nu, á vim bìr ya ku agunn vìm súr-à tìnn. ");
INSERT INTO jib_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mpìr-à ma bar karawú àjirà aku zìg jàwú, á fim ya ku jà wàuwú tìnn. ");
INSERT INTO jib_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mpìr-à ma sìnn kà wù ma gbam rag á swann ya ku swánnwá mel zyun, á swann ya ku mel pyànà. ");
INSERT INTO jib_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mpìr ma vig wù bu, á ya ku. Mpìr ma ri zìm aku zìg tonn á byarwú ni, á ya ku. ");
INSERT INTO jib_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ning fig hing big rì dang rag, ‘A zìm jàuwú, á ngàng mpìr azíbwú.’ ");
INSERT INTO jib_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama tàma-à níng mì ri dinya ning aning zìm mpìr azíbná. Mpìr-à ma sìnn kà ning á shwìn, aning vig ya ku Shìdun, àjirà a Shìdun sa sàn ya ku. ");
INSERT INTO jib_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wà na sa hing àdòníng, ná shi yann ǹsàn mà byar Taná mà wai. Ku ri sa àyúnn ri yar wann bi á byar mpìr bibaiká ma mpìr ǹsànká. Ku ri sa shyù ri tab mà byar mpìrká ri sa bu-à ǹsàn ma ká ri sa bu-à bibai tìnn. ");
INSERT INTO jib_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wà ning ma ri zìm íri mpìr azìmná, Shìdun má ya fig ning bu-à ning ri zìm bàna. Kó mpìr azìg bài jànnká má, ri zìm mpìr azìmbá. ");
INSERT INTO jib_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wà ning ma ri bib kà íri jàuná, sàn fig bàna. Ning kab sig mpìr kádà níng ma kai rà? Kó mpìrká yì fig Shìdun bàna má, ri bib kà jàubá. ");
INSERT INTO jib_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aning shi mpìrká shi sig ma pìkyinn-à ǹsàn, àràg barà Taná mà wai shi sig ma pìkyinn-à ǹsàn níng. ");
INSERT INTO jib_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Aning myàng, kada aning ya mpìrká bu jirà ning myàng sig zu mpìrká bàna. Na sa hing àdòníng, ná dìg fig bu zyun mà byar Taná mà wai bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Wà wù má ya mpìr bu, kada á sa mpìrká abig yì wù ri ya bu bàna, àràg barà mpìrká káhi ri sa mà tonn bìr kwonn-à ni, mà gbìb-à ni tìnn, àjirà mpìrká abig myàng big, ma abig wib big. Mì ri dinya ning àjai, big zìg rìghing ladabá. ");
INSERT INTO jib_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A sai-à wá ya mpìr ashiká bu á bònn yíya. Kada á zìm vìm súrwú aku yì bu-à vìm nuwú ri sa bàna, ");
INSERT INTO jib_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","jir kai bàna bu-à wa bònn ya sig áya, Tawú zyun-à myàng sig níng, má swàb kà ya wù. ");
INSERT INTO jib_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sai-à ná vig Shìdun, kada aning sa àràg barà mpìr agbar dù shinnká ri sa níng bàna, jir kai bàna big ri zìm abig sar dù nann zu á tonn bìr kwonn-à ni ma gbìb-à ni abig vig Shìdun, àjirà mpìrká abig myàng big. Mì ri dinya ning àjai big zìg rìghing ladabá. ");
INSERT INTO jib_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sai-à wa vig Shìdun, á kà mà tonnwú ni, á kìg dim rìg nu nkyun-à ma á vig Tawú zyun-à ri myàng wù barà à bònn shi sig mi ri vig ku. Kwá ya swàb kà ya wù. ");
INSERT INTO jib_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Wà ning ma ri vig Shìdun kada aning dang nànn jírká zyun-à bàna ma yìr, àràg barà mpìr asa bukiká ri sa níng bàna. Big ri kyab rag bu sìnnbá má fig jírbá wà ba vig hing big nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kada aning shi àràg big bàna, jir kai bàna Taná yì rìghing bu-à ning ri zìm sai-à ning vig fig ma ku bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wàníng í barà ná vig Shìdun áni, aning dang rag, ‘Tayí wà mà wai, á sa mpìrká abig wib zìnnwú. ");
INSERT INTO jib_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Byar shu kùrwú aku bi á byaryí ni. Ayi sa bu-à wù ri zìm á dunyaru àràg barà big ri sa mà wai. ");
INSERT INTO jib_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A ya yi buju àyúnn ma àyúnn. ");
INSERT INTO jib_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A yafa ya yi bu bibaiká yi ri sa, àràg barà yi ri yafa ya mpìrká ri sa yi bu-à bibai níng. ");
INSERT INTO jib_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kada á fim yi ayi sa bu-à bibai bàna. A zìg zu yi á vù Shaitan mpìr-à bibai.’ ");
INSERT INTO jib_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Wà na yafa ya mpìrká bu pyìrbá, Taná mà wai má yafa ya ning tìnn. ");
INSERT INTO jib_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wà na yafa ya fig mpìrká bu pyìrbá bàna, Taná má yafa ya fig ning buná bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sai-à ning ma ri sìnn nu, kada aning gbar sìr mùnnpyànn ná àràg barà mpìr agbar dù shinnká ri sa níng bàna. Big ri sa àdòníng àjirà mpìrká abig yì rag big ri sìnn nu. Mì ri dinya ning àjai, big dìg rìghing ladabá. ");
INSERT INTO jib_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama wù, á sai-à wa sìnn nu, á tung byìr á shinnwú ni ma á tu zuwú, ");
INSERT INTO jib_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","àjirà kada mpìrká abig yì rag wù ri sìnn nu bàna. Sái Tawú zyun-à big ri myàng fig ku bàna níng, aku yì nì. Taná zyun-à ri myàng bu-à ning ri bònn sa níng, ku í àsàin-à má ya ning lada. ");
INSERT INTO jib_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kada aning sìnn gbam buká ning shi sig ma kàhi níng á dunyaru bàna, byar-à ayìgkwài má yìg ji sa bai rìg, má da rìg jì, byar-à ajwúká má jwi rìg. ");
INSERT INTO jib_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama aning sìnn gbam buká buná mà wai, byar-à ayìgkwài má yìg ji sa bai fig bàna, má da fig jì bàna, ajwúká má jwi fig bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Byar-à buká buná ma shi sig, í byar-à kyinn ná má shi màhàn tìnn. ");
INSERT INTO jib_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Zuyí shi sig àràg í àyar dìryí. Wà zuwú ma àgbam, dìrwú bidìm pár má yar yà zu rìg. ");
INSERT INTO jib_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama wà zuwú ma sàn fig bàna, dìrwú má yar yà zu fig bàna. Wà àyar-à á dìrwú ni níng ma í zufi, zufi-à níng má shi á shinn rà? ");
INSERT INTO jib_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mpìr ńzyun má wib sar fig àsàin lu pyànà bàna. Sái dái kwá ngàng zyun, má zìm zyun, kó kwá fig jir zyun, má ngàng jir zyun. Wà na zìm kab síg bài, ná zìm fig Shìdun bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mì ri dinya ning jír-à níng, kada aning kyab jír á shinn byar shuná ni bàna, kó buju-à ná ji, kó bu-à ná wa bàna, kó jà-à ná wìr kà á dìrná ni bàna. Yonki kab hing buju. Dìrná kab hing jà. ");
INSERT INTO jib_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aning myàng ayinnbuká, big ri tàg fig buju bàna, big ri binn fig buju bàna, big bàna ma vonn, ama Taná mà wai ri pyag big í ni. Buná, ning kab fig ayinnbu káníng bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wà ning ma ri kyab jír, jír kyabná má swàb kà ya fig ning yonki bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bu-à sa ning ri kyab jir jà wà ná wìr kà á dìrná ni í jir kai rà? Aning myàng awu buká mà awúnn-à ni barà big ri wài áni. Big ri sa fig swàm bàna, big ri pìnn fig shwam bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mì ri dinya ning jir àjai, kó Sulemanu ma bàiká ma jàká ku shi sig ma kàhi níng, sàn fòr fig awu bu káníng bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","I Shìdun ri sá nì byannká abig shi ǹsàn, kó barà big ri shi nonn fig bàna níng. Wà má àdòníng, ning yì fig wà Shìdun má ya ning jà-à ná wìr bàna rà? Bu-à sa ning ri bir fig pìkyinn ná á byar Shìdun ni bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Jir wàníng, kada aning kyab jir bu-à ná ji, kó bu-à ná wa, kó bu-à ná wìr kà á dìrná ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bu káníng bidìm pár í mpìrká zyun-à yì fig Shìdun bàna níng ri kyab kyánn nì á pìkyinnbá ni. Ama buná, Taná mà wai yì hing rag, ning ri zìm bu káníng, kwá ya ning. ");
INSERT INTO jib_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bu-à ná sa jag bàna, aning kyab jír áshinn barà Shìdun ri na kùrwá, aning sa bu-à ǹsàn àràg barà Shìdun ri sa níng. I wà kwá ya swàb kà ning bu-à ning ri zìm. ");
INSERT INTO jib_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kada aning kyab jír wà akìn bàna. Kada aning kyab shwìn wà akìn bàna, wà akìn í bu Shìdun. Aning kyab íri shwìn-à wà janá-à níng. ");
INSERT INTO jib_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kada aning wà kwonn mpìr bàna, jirà kada a Shìdun wà kwonn ná bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gbìb-à ning ri wà mpìrká kwonn áni níng, í gbìb-à Shìdun má wà ning kwonn áni tìnn. Tasa-à na màg ya sig jàuná áni, ning má Shìdun má màg ya ning ma kàhi tìnn. ");
INSERT INTO jib_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sáshinn wù ri dinya jàuwú, ku í mpìr-à bibai, ama à sa kab bu bibai-à ínì níng rà? Sáshinn wù ri dinya jàuwú bu shi sig á yìzuwá ni, ama à màm jànn rìghing buwú shi sig ùwài nímá á yìzuwú ni níng rà? ");
INSERT INTO jib_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sáshinn wá dinya jàuwú rag, wá zìg zu ya ku bu-à kù kà sig ku á yìzuwá ni, n fim rìg buwú ùwài nímá zyun-à shi sig á zuwú ni níng rà? ");
INSERT INTO jib_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wù mpìr kyinn pyànà, á zìg zu jag ma buwú ùwài nímá shi sig á zuwú ni níng, àjirà á myàng kyàr, ma á zìg zu ya jàuwú buwá tìnn. ");
INSERT INTO jib_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kada aning ya báiká bu-à kyìkyàr bàna, kada aning ya zyùká àmyinn wàin bàna tìnn. Na sa hing àdòníng, bá tib wam zu barbá áni, bá kàng bi má pànn zwam ning. ");
INSERT INTO jib_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Aning vig, bá ya ning. Aning yàn, ná dìg. Aning kwìb nu nkyun-à, bá pù ya ning. ");
INSERT INTO jib_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kó ni ma vig hing, bá ya ku. Mpìr-à ma yàn hing, kwá dìg. Mpìr-à ma kwìb hing nu nkyun-à, bá pù ya ku. ");
INSERT INTO jib_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ning mpìrká shi sig ma yann, wà yanká buná ma vig ning buju, ná ya big abàn rà? ");
INSERT INTO jib_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kó wà ba vig ning jái, ná ya big bushùwí rà? ");
INSERT INTO jib_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ning zyun-à ning í mpìrká bibai má, ning yì hing barà ná ya yanká buná big bu ǹsàn ǹsàn, n bi bib Taná zyun-à mà wai, kwá ya ning bu ǹsànká wà na vig hing ku. ");
INSERT INTO jib_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Barà ning ri zìm á mpìr sa ya ning níng, ning má, aning sa ya mpìr àdòníng tìnn. Wàníng í yìr doka-à Shìdun ri zìm ayi sa. Wàníng í bu-à mpìrká rìi dang kyann jir Shìdun ba sig. ");
INSERT INTO jib_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aning kà á nu nkyun-à ya fig aya bàna níng, jir kai bàna nu nkyun-à ma gbìb-à má zìg yag mpìr mà byar pyìr-à ni níng ya sig wàni. Gbìb-à hi bàna ma shwìn, mpìrká nìnànn nímá má bàg wàníng hi. ");
INSERT INTO jib_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gbìb-à má zìg yag mpìrká mà byar yonki-à níng, ya fig aya bàna. Gbìb-à hi shi sig ma shwìn. Mpìrká má kà mà byar-à níng hi, nànn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kada aning zìm mpìrká ri gim ǹsáng rag big í mpìr adang kyann jir Shìdun níng abig tonn gban ning bàna. Big shi sig àràg í àdùn á zu-à ni, ama big í mpìr bibai àràg jwànnzwam. ");
INSERT INTO jib_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ná myàng yì big á swàmbá ni. Kó swai bín-à wà áni ri wan awanwá. Mpìr má dìg fig awan ating á bin sí bàna. Mpìr má dìg fig awan murbu á bín bàna. ");
INSERT INTO jib_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bín ǹsàn ma wan awan ǹsàn. Ama bín àbai má wan awan àbai. ");
INSERT INTO jib_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bín ǹsàn má wan fig awan àbai bàna, bín àbai má wan fig awan ǹsàn bàna. ");
INSERT INTO jib_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bín-à ma wan fig awan ǹsàn bàna, bá gib rìg, má ta kà rìg mà pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wàníng í barà ná myàng yì mpìrká ri gim ǹsáng rag big í yann aswam Shìdun níng áni, á byar swàmbá big ri sa. ");
INSERT INTO jib_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“I jir wà kó ni ri bar mì rag, ‘Shinn Lumí, Shinn Lumí,’ má kà nì lu Shìdun bàna. Ama sái mpìr-à ma ri sa bu-à Tamí mà wai rì zìm. ");
INSERT INTO jib_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ayúnn-à níng hi, mpìrká nìnànn nímá má bar mì rag, ‘Shinn Luyí, Shinn Luyí, á zìnnwú ni yi ri dang jir Shìdun, á zìnnwú ni yi ri kan zu wàuká, mi ri sa bu mamakiká kim kim á zìnnwú ni.’ ");
INSERT INTO jib_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A byar-à níng hi, má dinya big rag, ‘N yì fig ning bàna, aning dù á pyànnmí ni, ning í mpìrká ri sa bu-à bibai.’ ");
INSERT INTO jib_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mpìr-à ma fig hing jírmí ma wib hing, ku shi sig àràg mpìr yar-à mi sig tonnwá á shinn abàn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Barà shyù bi tab, níngká na mònn rìg ma zàpìr, wàu shyù bi gbar ma gbam á tonn-à níng hi, ama tonn-à hi kù fig bàna, jir kai bàna big mi sig á shinn abàn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Mpìr-à ma fig hing jírmí ma wib fig bàna, ku shi sig àràg mpìr àning-à mi sig tonnwá á shinn vun-à ni. ");
INSERT INTO jib_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Barà shyù-à tab, níng-à gbànn yor, wàu shyù bi gbar ma gbam á tonn-à níng hi. A byar-à hi tonn-à í wim wann rìg-à wìb.” ");
INSERT INTO jib_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Barà Yesu dang kinn rìg jír káníng, sái mpìrká kwonn shi sig màhàn níng, sa mamaki ma buká ku ri tàg níng, ");
INSERT INTO jib_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","jir kai bàna bu tàgwá shi sig ma gbam, shi fig àràg bu tàg malamká bubá bàna. ");
INSERT INTO jib_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Barà Yesu tìg wann bi mà shinnkwìnn-à ni, sái bìr mpìrká bàg yag ku. ");
INSERT INTO jib_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A byar-à níng hi, mpìr dor àkùnn zyun bi á byarwá ni n bìnn kir wann á pyànnwá ni n rag, “Shinn Lumí, wà wa zìm hing, à shi sig ma gbam-à wá dàb gbam mì.” ");
INSERT INTO jib_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu du yag vùwá n tib ku vù á dìr-à ni n rag, “N zìm hing, á gbam á dorwú ni.” A byar-à níng hi, wunù-à níng í gbam rìg-à. Dor àkùnn-à níng dà fim rìghing ku. ");
INSERT INTO jib_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I wà Yesu dinya ku rag, “Kada á dinya mpìr bu-à sa sig níng bàna. Ama á yag mà lu Shìdun ni, á yag tìya àgbam-à ri twìb swànn bu á pyànn Shìdun ni dìrwú, ma á ya bu màhàn, àràg barà Musa dang sig abig sa, jirà mpìrká abig myàng barà à gbam rìghing níng.” ");
INSERT INTO jib_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Barà Yesu ri kà yag mà Kafarnahum, sái àgbam soja zyun bi á byar Yesu n vig ku, ");
INSERT INTO jib_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","n rag, “Shinn Lumí, wùn lumí na sig dor mà lu-à ni. Dìrwá ma barwá wu tag rìghing. Ku ri wa shwìn wàni.” ");
INSERT INTO jib_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu dinya ku rag, “Má bi má dàb gbam ku.” ");
INSERT INTO jib_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A byar-à níng hi, mpìr àgbam-à níng zìm n rag, “Shinn Lumí, ǹ kinn fig wà wá bi hár á lumí ni bàna. A dang íri jír mà byar-à à sar sig níng, jirà wùn lumí aku gbam rìg. Kwá gbam rìg wà wa dang hing. ");
INSERT INTO jib_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mì má, ǹ shi sig á vù mpìr zyun ni. Sojaká shi sig á vùmí ni tìnn, ma dinya hing zyun-à níng rag aku yag, kwá yag rìg, zyun-à bó aku bi, kwá bi rìg. Ma dinya hing fàumí rag aku sa bu-à níng, kwá sa rìg.” ");
INSERT INTO jib_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Barà Yesu fig àdòníng, sái ku sa mamaki n dinya mpìrká ri bàg ku níng n rag, “Mì ri dinya ning àjai, kó áyau mpìrká á Israila, ǹ myàng fig mpìr-à má bir pìkiyinnwá á byarmí ni àràg wunù-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mì ri dinya ning, mpìrká nìnànn nímá má bi mà agunn àyúnn sànkyùr ma agunn àyúnn àkamzau, bá shi, má ji buju ma Ibrahim ma Ishaku ma Yakubu mà lu Shìdun ni mà wai. ");
INSERT INTO jib_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama yann Israila, bá zìg big má ta kà á zufi-à ni, byar-à bá kig nàikitáu hár ma zwàm kà vù á nginn wàni.” ");
INSERT INTO jib_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu dinya àgbam soja-à níng n rag, “A yag kyonnwú. Barà à bir sig pìkyinnwú á dìrmí ni níng, aku shi àdòníng.” A byar-à níng hi wùn luwá í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu kà mà lu Bitrus. Bitrus bó, na wàwá na sig dor awàu. ");
INSERT INTO jib_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu pànn vùwá, á byar-à hi awàu-à í fim rìg-à ku, ku dù nann zu n sa wàníng buju. ");
INSERT INTO jib_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Barà kamzau rag aku sa níng, sái big zìg bi mpìrká zyun-à wàu dab sig big níng á byar Yesu. Ku dang íri jír átai, wàuká í zu rìg-à. Ku dàb gbam kwonn ma mpìr dorká bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bu káníng sa sig àdòníng, jir kai bàna Ishaya mpìr-à rìi dang kyann jir Shìdun dang sig rag, “I ku kwá áwinwá ni ku zìg zu sig dorká buyí í nì.” ");
INSERT INTO jib_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Barà Yesu myàng mpìrká nànn kab gbam á pyànnwá ni àdòníng, sái ku dinya yann sukàwá big n rag, abig zìg yag ku mà jann. ");
INSERT INTO jib_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sái malam zyun bi á byar Yesu n rag, “Malam, má bàg yag wù byar-à wa yag bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu dinya ku rag, “Jwànnzwamká shi sig ma sharbá, ayinnbuká shi sig ma lubá, ama mì Wùn Mpìr Jíkwìnn, ǹ bàna ma byar shu.” ");
INSERT INTO jib_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mpìr zyun áyau yann sukàká buwá ni dinya ku rag, “Agbammí, sai tamí ma wu hing ma jì ku hing, í wà má bàg wù.” ");
INSERT INTO jib_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A byar-à níng hi Yesu dinya ku rag, “A bàg bi mì, á fim mpìrká zyun-à ri bàg fig mì bàna abig jì kibá.” ");
INSERT INTO jib_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Barà Yesu kà mà kòr-à ni àdòníng, sái yann sukàká buwá big bàg yag ku. ");
INSERT INTO jib_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A byar-à hi, wàu shyù bi gbar ma gbam wùwài nímá á zàpìr-à ni. Kòr-à shi shirag má sib kà rìg mà zàpìr-à ni. A sai-à níng hi, Yesu ri na aná. ");
INSERT INTO jib_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yann sukàká buwá yag n bar finn zir ku n rag, “Shinn Luyí, á zìg zu yi, wà ma nímá bàna yá wu.” ");
INSERT INTO jib_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu bib big n rag, “Bu-à sa ning ri shàr zinn í jir kai rà? Ning bir fig pìkyinn ná á byarmí ni bàna rà?” A byar-à hi ku dang jír ma gbam, n kan dim rìg wàu-à ma zàpìr-à, big í na tag wann rìg-à yirr. ");
INSERT INTO jib_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A byar-à hi kó ni sa mamaki n rag, “Mpìr-à níng shi sig áshinn, hár wàu ma zàpìr ri wib jírwá níng rà?” ");
INSERT INTO jib_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Barà Yesu yag mà agunn vù níng-à ni mà jann mà jànn Gadarawá, sái mpìr pyànàká zyun-à wàuká dab sig big níng, dìg kwonn ma ku á sai-à big ri zu bi á byar amirká ni. Mpìr pyànà káníng hi fàn kab gbam, hár mpìrká ri shàr zinnbá, big ri zu fig gbìb-à káníng shi sig áni níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mpìr pyànà káníng yan nài yán n rag, “Wù Wùn Shìdun, bu-à kwonn wù ma yi í kai rà? A bi sig jirà á ya yi shwìn barà suyí fòr fig ma bàna níng rà?” ");
INSERT INTO jib_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zyùká nìnànn nímá ri yàn ji bujubá, big nonn fig ma byar-à níng hi bàna. ");
INSERT INTO jib_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wàu káníng vig Yesu n rag, “Wà wá kan zu yi, á fim yi ayi kà á dìr zyù káníng ni.” ");
INSERT INTO jib_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ku dinya big n rag, “Aning yag.” Big í zu rìg-à, n yag kà rìg á dìr zyù káníng ni. A byar-à hi zyùká bidìm pár shàr wann bi mà gàin-à ni, n kù kà mà zàpìr-à ni, mi í wu rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A byar-à níng hi, mpìrká ri myàng kwonn ma zyù káníng, shàr yag mà finn swann-à ni, n dinya gban rìg mpìrká bu-à sa sig mpìrká zyun-à wàu dab sig big níng. ");
INSERT INTO jib_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mpìrká nìnànn nímá mà finn swann-à ni yag àjirà abig myàng Yesu. Barà big myàng ku àdòníng, big vig ku aku dù á jànnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kà mà kòr-à ni, n zu yag mà jann, n kàng yag mà finn swannwá ni. ");
INSERT INTO jib_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mpìrká káhi swann zìg bi mpìr zyun-à dìrwá wu tag sig. Ku na sig á syu-à ni. Barà Yesu myàng big bir sig pìkyinnbá á dìrwá ni àdòníng, sái ku dinya mpìr dìr wu titag-à níng n rag, “Wùnmí, á tib pìkyinnwú, ǹ yafa ya rìghing wù bu pyìrká buwú.” ");
INSERT INTO jib_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A byar-à níng hi, malamká dang jír ma ba dìrbá n rag, “Mpìr-à níng sa bai hing zìnn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu yì rìghing bu-à big ri kyab á kyinnbá ni, sái ku bib big n rag, “Bu-à sa ning ri kyab bu-à bibai á kyinn ná ni àdòníng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ku bib big n rag, “I wà áni fonn kab síg nì rà, wà ma dang rag, ‘N yafa rìghing wù bu pyìrwú,’ ma wà ma dang rag, ‘A dù nann zu á kyann kyonn?’ I wà áni fonn kab síg nì rà? ");
INSERT INTO jib_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama má tìya ning rag, mì Wùn Mpìr Jíkwìnn, ǹ shi sig ma gbam á dunyaru barà má yafa ya mpìr bu pyìrwá.” Ku dinya mpìr dìr wu titag-à níng n rag, “A dù nann zu, á pìnn syuwú ma á kàng yag mà luwú ni.” ");
INSERT INTO jib_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A byar-à níng hi, mpìr-à níng dù nann zu, n yag mà lu-à ni. ");
INSERT INTO jib_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Barà bìr mpìrká myàng àdòníng, zinn pànn rìg big, big swam yan zìnn Shìdun barà ku ya sig mpìr gbam-à níng. ");
INSERT INTO jib_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Barà Yesu ri wam zu àdòníng, ku myàng mpìr zyun zìnnwá í Matiyu, ku í mpìr azìg bài jànn, ku shi sig mà nu swàmwá ni. A byar-à níng hi, Yesu bar bi ku n rag, “A bàg mì.” Ku dù n bàg yag wàníng. ");
INSERT INTO jib_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Barà Yesu ri ji buju mà lu Matiyu àdòníng, sái mpìr azìg bài jànnká nìnànn nímá ma mpìr bu pyìrká bi n ji buju ma ku, ma yann sukàká buwá big. ");
INSERT INTO jib_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Barà Farisawaká myàng àdòníng, big bib yann sukàká buwá n rag, “Bu-à sa Shinn Luná ri ji kwonn buju ma mpìr azìg bài jànnká, ma mpìr bu pyìrká í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Barà Yesu fig àdòníng, ku dinya big n rag, “Mpìr-à shi sig ma gbam dìr ku ri yàn fig adàb dor bàna, sái mpìr-à dìrwá ma ri wúwa í mpìr-à ri yàn kyann adàb dor. ");
INSERT INTO jib_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aning yag ma aning kyab bu-à jir Shìdun dang sig rag, ‘Bu-à mì ri zìm bàna, aning myàng ashi mpìrká, ma wà ning nìm má twìb swànn bu á pyànnmí ni.’ N bi síg á dunyaru jirà ń bar mpìr bu pyìrká. N bi fíg á byar mpìrká ri kyab rag big í mpìr sìsàn níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yann aswam Yohanna bi á byar Yesu n bib ku rag, “Bu-à sa yi ma Farisawaká ri sìnn nu kó ákaun, ama yann sukàwú big ri sìnn fig nu bàna níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu sa big misali n dang rag, “Wà àyúnn-à mpìr zyun ma sìr ban, jàuwá big má fig àjwár. Bá sìnn fig nu bàna. Ama àyúnn zyun ki ma zìg rìghing wunù-à níng, àyúnn-à níng hi jàuwá big má sìnn nu. ");
INSERT INTO jib_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mpìr má zìg fig jà àpyú má kwìb bàg kwonn fig ma jà àkor bàna. Mpìr ma kwìb bàg kwonn hing jà àpyú ma jà àkor, àkor-à má ka zu rìg, má ka bai kab wàrì. ");
INSERT INTO jib_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Walako mpìr-à ma wìr kà zàn inabi àpyú á wau àkor, zàn inabi àpyú sái wau àpyú tìnn. Zàn inabi àpyú ba wìr kà hing á wau àkor má ka rìg, zàn inabi-à má wìr kìfinn rìg. Zàn inabi àpyú big ri wìr kà á wau àpyú. Má àdòníng, zàn inabi-à hi má zu kìfinn fig bàna. Wau-à hi má bai fig bàna tìnn.” ");
INSERT INTO jib_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Barà Yesu dinya big jír àdòníng, sái àgbam mpìr Yahudawa zyun bi á byarwá ni, n bìnn kir wann á pyànnwá ni n rag, “Wùn uwàmí wu rìghing, wúshèní, mì ri zìm á bi á tib ku vù á dìr-à ni àjirà aku wìm kàng rìg.” ");
INSERT INTO jib_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A byar-à hi, Yesu ma yann sukàwá big dù n bàg yag ku. ");
INSERT INTO jib_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uwà zyun dor wàjì ri sa shi ku hár ji dwib agban pyànà, àsà-à hi gib fig bàna. Ku bi ásim Yesu n tib vù á sung jà wàníng. ");
INSERT INTO jib_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ku kyab á pìkyinnwá ni n rag, kó wà kwa tib hing íri jà wàníng kwá gbam rìg. ");
INSERT INTO jib_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Barà Yesu myàng kàng bi zu ásim, sái ku myàng wàníng n rag, “Wùnmí, á fig àjwár, jir kai bàna pìkyinnwú à bir sig á dìrmí ni níng, dàb gbam rìghing wù.” Gbìb fig tá bàna, uwà-à níng í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Barà Yesu kà yag mà lu àgbam-à hi àdòníng, ku myàng mpìrká ri winn shàm ma yur ma bìr mpìrká, big ri gbam nài gbam jir ki-à wu sig níng. ");
INSERT INTO jib_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ku dinya big n rag, “Aning dù áyág, wùn uwà-à níng wu fig bàna, ku ri na aná.” A byar-à níng hi, big jwann ku jonn yawari. ");
INSERT INTO jib_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Barà bìr mpìr káníng zu yag mà myann àdòníng, ku kà yag n pànn wùn-à hi á vù-à ni, wàníng í dù nann zu-à. ");
INSERT INTO jib_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tai bu-à ku sa sig níng, kàng kwìb gban rìg jànn-à hi bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A byar-à níng hi, barà Yesu fim rìg swann-à hi mi ri yag àdòníng, sái mpìr àfau big pyànà bàg yag ku n rag, “A myàng ashiyí, Wùn Dawuda.” ");
INSERT INTO jib_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Barà ku kà yag mà lu-à ni, mpìr àfau káníng yag mà byarwá ni. Yesu bib big n rag, “Ning bir hing pìkyinn rag má dàb gbam ning rà?” Big zìm n rag, “Nn, Shinn Luyí.” ");
INSERT INTO jib_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","I byar-à hi ku tib káníng vù á zubá ni n rag, “Barà ning bir hing pìkyinn ná á dìrmí ni níng, aku shi àdòníng.” ");
INSERT INTO jib_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A byar-à níng hi, zubá í pù finn rìg-à. Ama Yesu twìb big byur n rag, “Aning myàng, kada aning dinya mpìr zyun bàna.” ");
INSERT INTO jib_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama big dù n yag dinya gban rìg mpìrká á jànn-à ni tai bu-à Yesu sa sig bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Barà big ri zu yag àdòníng, sái big zìg bi mpìr-à dang sar fig jír bàna á byar Yesu. I wàu dab síg ku nì. ");
INSERT INTO jib_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Barà Yesu kan zu rìg wàu-à níng àdòníng, sái mpìr-à níng dang rag jír. A byar-à níng hi, bìr mpìrká sa mamaki n rag, big myàng fig bu àdòníng kó kàun ńzyun á jànn Israila bàna. ");
INSERT INTO jib_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A byar-à hi barà Farisawaká myàng àdòníng, big dang rag, “Ku ri kan zu wàu káníng ma gbam kùr wàu.” ");
INSERT INTO jib_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kyann gban rìg finn swannká ma kauyeká, mi ri tàg jir Shìdun mà tonn shinn kwonn-à ni, mi ri dinya mpìrká jír á shinn barà Shìdun má na kùrwá. Ku ri dàb gbam kwonn ma mpìr dorká kim kim. ");
INSERT INTO jib_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Barà ku myàng bìr mpìrká àdòníng, sái ashi káníng pànn rìg ku, jir kai bàna big ri wa shwìn, big yì fig bu-à bá sa bàna. Big shi sig àràg í àdùnká bàna ma anu. ");
INSERT INTO jib_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A byar-à níng hi ku dinya yann sukàwá big n rag, “Bujuká byann rìghing, ama abinnká nànn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aning vig Shìdun àsàin da-à níng, aku swam bi mpìrká zyun-à má binn buju-à hi.” ");
INSERT INTO jib_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu bar kwonn bi yann aswamká buwá big dwib agban pyànà n ya káníng gbam wà bá kan zu wàu á dìr mpìrká ni, ma abig dàb gbam dor kó swai-à wà áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Zìnn yann aswam dwib agban pyànà káníng í Siman Bitrus, ma wunzàwá Andarawus, ma Yakubu wùn Zabadi, ma wunzàwá Yohanna, ");
INSERT INTO jib_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus ma Bartalamawas, Toma ma Matiyu zyun-à rìi zìg bài jànn, ma Yakubu wùn Halfa, ma Tadawas, ");
INSERT INTO jib_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma Siman Zaloti, ma Yahuda Iskariyoti zyun-à wann tafinn sig Yesu. ");
INSERT INTO jib_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mpìr dwib agban pyànà káníng, Yesu swam yag big n ya big gbam n rag, “Aning yag íri byar Yahudawaká, kada aning kà mà finn swann mpìrká zyun-à big í Yahudawa bàna, ma swann Samariya bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama aning yag mà byar mpìrká mà jànn Israila. Big shi sig àràg í àdùnká zyun-à nang jànn sig. ");
INSERT INTO jib_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wà na yag hing, aning yag dang jir Shìdun, aning rag, ‘Ayúnn-à Shìdun má na kùrwá áni níng, nyàan fòr.’ ");
INSERT INTO jib_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aning dàb gbam mpìr dorká, aning dàb wìm kiká, aning dàb gbam mpìr dor àkùnnká, aning kan zu wàuká á dìr mpìrká ni. Ning dìg sig gbam-à níng átai, aning dàb gbam mpìrká átai tìnn. Kada aning kyab jir bài kó bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kada aning zìg bài bàna, kó títi nímá. ");
INSERT INTO jib_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kada aning zìg lúr á kyonn ná ni bàna, kó jà pyànà, kó tab, kó tun bàna, jir kai bàna mpìr asa swàm, sàn sig abig ya ku bu-à ku ri zìm. ");
INSERT INTO jib_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Wà na yag hing mà finn swann kó kauye zyun ni, aning yàn mpìr ǹsàn zyun-à ma zìm hing rag aning shi mà luwá ni, aning shi mà luwá ni hár àyúnn-à ná dù. ");
INSERT INTO jib_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na kà hing mà lu zyun ni, aning dang rag, Shìdun aku sa sàn ya big. ");
INSERT INTO jib_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wà mpìr á lu-à hi ma shà hing ning nài bib-à ning bib kà sig big níng, aku shi àdòníng. Ama wà ba shà fig ning bàna, nài bib-à níng aku kàng bi á byarná ni. Aning fim rìg lu-à hi. ");
INSERT INTO jib_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Finn swann-à na yag bidìm pár, mpìrká màhàn ma shà fig ning, ma zìm fig jírná bàna, aning dab pìg kyàr rìg àzwìmká á barná ni ma aning fim rìg finn swann-à hi. ");
INSERT INTO jib_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mì ri dinya ning àjai, ásai-à Shìdun má wà kwonnwá níng, mpìrká zyun-à ngàng sig ning níng, bá wa shwìn, shwìnbá má kab bu mpìrká á Saduma ma Gamurata. ");
INSERT INTO jib_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mì ri swam yag ning àràg barà big ri swam yag àdùnká áyau bìr jwànnzwamká ni. Aning shi ma yar àràg bushùwí. Aning shi àràg àlàb zyun-à ri yàn fig jír bàna. ");
INSERT INTO jib_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aning sa ádàn, jir kai bàna mpìrká káhi má pànn ning má zìg yag ning mà byar agib jír, bá yang ning ashor mà tonn bìr kwonn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A jir shinnmí ni bá zìg yag ning mà byar agib jírká, ma kùrká. Bá zìg yag ning jir shinnmí jirà aning dinya big, ma mpìrká zyun-à í Yahudawaká bàna níng, jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ama á sai-à ba zìg yag ning mà byar-à bá wà ning kwonn, kada aning gib kyinn jir bu-à ná dang bàna. Ayúnn-à hi, Shìdun má tìya ning bu-à ná dang. ");
INSERT INTO jib_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ayúnn-à níng hi, ná dang fíg nì ma shinn ná bàna, ama Awun Taná zyun-à shi sig á pìkyinn ná ni, má tàg ning bu-à ná dang. ");
INSERT INTO jib_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mpìr má zìg rìg yiwaiwá, má ya kà á vù mpìrká ni, abig gban rìg. Ta má ya kà wùnwá á vù mpìrká ni, abig gban rìg. Yanká má ngàng rìg jir tabá ma nàbá, má ya kà káníng á vù mpìrká ni, abig gban rìg. ");
INSERT INTO jib_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mpìrká má zib ning jir shinnmí, ama mpìr-à ma sar gbam hing hár kinn kinn, kwá wìm zu rìg. ");
INSERT INTO jib_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wà mpìrká ma zìm fig ning mà finn swann-à ning shi sig áni níng bàna, big ma ri ya ning shwìn, aning fim rìg swann-à hi, aning yag rìg mà swann zyun kim. Mì ri dinya ning àjai, na kyann gban fig finn swannká á Israila bàna, sái wà wùn mpìr jíkwìnn ma kàng bi hing. ");
INSERT INTO jib_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mpìr-à ma ri shwann bu, kwá kab fig mpìr-à ri tàg ku bàna. Fàu má kab fig àsàin luwá bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sàn hing mpìr ashwann bu aku yì bu àràg mpìr-à ri tàg ku, sàn hing fàu aku shi àràg àsàin luwá. Wà mpìrká ma bar mì àsàin luná rag, mì í Shaitan, bá bar ningká zyun-à ning ri bàg mì níng, má kab àdòníng. ");
INSERT INTO jib_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kada aning shàr zinn mpìrká bàna. Bu-à ma shi sig bu bònn tàm má zu bi rìg á myann, mpìrká má yì rìg. ");
INSERT INTO jib_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bu-à ma dinya sig ning á zufi-à ni, aning dang kyàr zu rìg. Bu-à na bònn fig sig, aning dang zu rìg á myànn. ");
INSERT INTO jib_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kada aning shàr zinn mpìrká zyun-à má gban íri wi dìrná, má gban sar fig adìn ná bàna. Ama aning shàr zinn Shìdun, zyun-à má gban sar rìg dìrná ma adìn ná mà lu pyìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ning yì fig wà ayinnbu pyànà bá wann tafinn sule bàna rà? Ai kó áyau ayinnbu káníng ni Shìdun má màm jànn fig kó ńzyun bàna. ");
INSERT INTO jib_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Buná kó jinnká á shinn ná ni, Shìdun wànn vinn rìghing. ");
INSERT INTO jib_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jir wàníng kada aning shàr zinn bàna, jir kai bàna ning kab hing ayinnbuká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wà mpìr ma tàg hing shinnwá áyau bìr ma rag, ku í bumí, mì má, má sa ya ku àdòníng tìnn mà byar Tamí mà wai. ");
INSERT INTO jib_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama mpìr-à ma ngàng hing mì áyau bìr mpìrká ni, mì má, má ngàng ku á pyànn Tamí ni mà wai tìnn. ");
INSERT INTO jib_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ning ri kyab rag n bi síg jirà ń jùn kwonn mpìrká í byar ńzyun rà? Ai ǹ bi fíg jirà ń jùn kwonn mpìrká bàna. N bi síg jirà ń gàfinn mpìr. ");
INSERT INTO jib_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wùn má ngàng tawá, wùn uwà má ngàng nàwá. Uwà má ngàng na nùwá. ");
INSERT INTO jib_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Azíb mpìr má shi á pyù barwá ni. ");
INSERT INTO jib_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mpìr-à ma ri zìm aku bàg mì, aku zìm mì wàni, aku zìm kab mì ma tawá ma nàwá ma yanká buwá, má àdòníng bàna, kwá shi sar fig wùn sukàmí bàna. ");
INSERT INTO jib_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mpìr-à ma ri zìm aku bàg mì, kada aku ngàng wà kwá wa shwìn àràg barà má wa níng, bàna. Má àdòníng bàna, kwá kinn fig barà kwá shi wùn sukàmí bàna. ");
INSERT INTO jib_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mpìr-à ma ri zìm íri yonkiwá, kwá dìg fig bàna. Ama mpìr-à ma ya tafinn hing yonkiwá jir shinnmí, kwá dìg wà kinn kinn. ");
INSERT INTO jib_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mpìr-à ma pànn hing ning vù pyànà, ku pànn síg mì. Mpìr-à ma pànn hing mì vù pyànà, ku pànn síg zyun-à swam bi sig mì. ");
INSERT INTO jib_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mpìr-à ma pànn hing wùn aswam Shìdun vù pyànà jirà wàníng í wùn aswam Shìdun, Shìdun má ya swàb kà mpìr-à níng hi. Mpìr-à ma pànn hing mpìr ǹsàn vù pyànà jirà wàníng í mpìr ǹsàn, Shìdun má ya swàb kà ku. ");
INSERT INTO jib_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kó ni ma ya hing wùn sukàmí zyun-à fòr fig bu zyun bàna níng zàpìr aku wa, jirà ku í wùn sukàmí, Shìdun má ya mpìr-à níng hi bu-à ku ri zìm.” ");
INSERT INTO jib_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Barà Yesu dinya kinn rìg yann sukàwá big dwib agban pyànà jír àdòníng, ku dù màhàn n yag rìg mà kauyeká kim kim mi ri tàg mpìrká jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Barà Yohanna àsàin batisma shi sig mà tonn fi-à ni, ku fig bar buká Yesu Kristi ri sa, sái ku swam yag yann sukàwá big mà byar wàníng ni. ");
INSERT INTO jib_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Big bib Yesu n rag, “A dinya yi, wù í zyun-à Shìdun rì dang sig rag kwá swam bi níng rà, kó ayi shi kir mpìr zyun kim rà?” ");
INSERT INTO jib_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A byar-à níng hi, Yesu zìm n dinya big n rag, “Aning kàng yag, aning dinya Yohanna bu-à ning fig sig, ma bu-à ning myàng sig. ");
INSERT INTO jib_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","N dàb gbam rìghing àfauká, big ri myàng rag ma zubá. N dàb gbam rìghing mpìrká kyann sar fig kyonn bàna, big ri kyann rag. N dàb gbam rìghing mpìr àkùnnká, ǹ dàb gbam rìghing mpìr sung àkúnnká, big ri fig rag jír. Mì ri dàb wìm mpìrká wu rìghing, big ri dù nann zu kàng ma yonkibá. Mì ri dinya mpìr ashiká jír ǹsàn á shinn Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aning dinya Yohanna rag, mpìr-à ma fim fig wà bir pìkyinn á byarmí ni bàna, Shìdun má sa sàn ya ku.” ");
INSERT INTO jib_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Barà yann sukà Yohanna big yag rìg, sái Yesu dinya mpìrká kwonn shi sig ma ku níng jír á shinn Yohanna. Ku bib rag, “Ning yag sig mà awúnn-à ni, ning yag myàng sig í kai rà? Ning yag myàng síg byann zyun-à wàu ri gbar ning rà? ");
INSERT INTO jib_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kó ning yag myàng sig í kai rà? Ning yag myàng síg mpìr-à wìr sig jà sìsàn nímá níng rà? Wíi, mpìrká ri wìr jà sìsàn níng, í mpìrká mà lu kùr. ");
INSERT INTO jib_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ning yag myàng sig Yohanna zyun-à Shìdun swam bi sig níng rà? Nn. Ayau mpìrká zyun-à Shìdun swam bi sig níng, í Yohanna kab nì. ");
INSERT INTO jib_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","I Yohanna zyun-à Shìdun dang sig jír á shinnwá ni n rag, ‘Má swam bi jag mpìr-à aswammí á pyànnwú ni. Kwá sa samyib ya wù gbìb-à wá bàg áni.’ ");
INSERT INTO jib_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mì ri dinya ning àjai, áyau mpìrká á dunyaru bidìm pár, Yohanna àsàin batisma kab síg big ni. Ama kó mpìr títi nímá ma kà hing mà byar-à Shìdun má na kùrwá níng, ku kab hing Yohanna. ");
INSERT INTO jib_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sai-à Yohanna dang jag sig jir Shìdun, hár bi tàma-à níng, mpìrká nìnànn nímá shi, mi ri zìm abig kà mà byar-à Shìdun ri na kùrwá níng. ");
INSERT INTO jib_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mpìrká rì dang kyann sig jir Shìdun níng, big dang sig rag, ‘Ayúnn zyun Wùn Shìdun má bi kwá na kùr.’ Doka Musa dang àdòníng tìnn. Big dang àdòníng, hár Yohanna bi dang jír á shinnwá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Big rì ba sìnn sig rag, ‘Mpìr zyun àràg Iliya má bi, má sa samyib gbìb-à Kristi má bàg áni.’ Mpìr-à níng bi rìghing, ku í Yohanna. Aning bir pìkyinn ná á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mpìr-à ma shi sig ma sung-à kwá fig jír, aku fig. ");
INSERT INTO jib_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mpìrká tàma-à níng í mpìr sung gbam big. Big shi sig àràg yann sung gbam big. Má sa ya ning misali. Big shi sig àràg í yann títi big shi sig á fir jau-à ni. Big dinya bar dìrbá n dang rag, ");
INSERT INTO jib_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Yi gbà ǹggan ǹsàn, ama ning gbìb fig jau bàna. Yi dài jonn ashi, ama ning kig fig nàikitáu bàna.’ ");
INSERT INTO jib_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohanna ji n wa fig bàna. Mpìrká dang rag, ‘Ku í mpìr wàu.’ ");
INSERT INTO jib_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mì í Wùn Mpìr Jíkwìnn, mì ri ji, mì ri wa. Mpìrká dang rag mì í mpìr finn, mì í mpìr apyann shin, mì í jàu mpìr bu pyìrká, mì í jàu mpìr azìg bài jànnká. A byar swàm-à mpìr ma ri sa, í byar-à bá yì kó ku í mpìr yar.” ");
INSERT INTO jib_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A swannká zyun-à Yesu dang jir Shìdun, n sa swàm bu mamakiká kim kim, ama big ngàng jir Shìdun, big fim fig bu pyìrbá bàna níng, í bu-à sa Yesu yan ta big ");
INSERT INTO jib_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","n rag, “Mpìrká á Korasinu, ná wa shwìn. Mpìrká á Batsaida, ná wa shwìn. Swàm-à big sa sig á jànn ná ni níng, big nìm ma sa sig á Taya ma Sidon, mpìrká màhàn nìm má fim bu pyìrbá, n nìm má shi kà á sún, n nìm má wìr àswàr jà. ");
INSERT INTO jib_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N dinya ning àjai, shwìn ná má kab bu Taya ma Sidon àyúnn-à Shìdun má wà kwonnwá. ");
INSERT INTO jib_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ning mpìrká á Kafarnahum, ning í mpìr agbar dù shinn. Shìdun má ta kà rìg ning mà pyìr-à ni. Bu mamakiká big sa sig á byarná ni níng, big nìm ma sa sig mà Saduma, wàníng big nìm fim rìghing bu pyìrbá, Saduma nìm má shi hár tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mì ri dinya ning àjai, àyúnn-à Shìdun má wà kwonnwá, kwá myàng ashi mpìrká á Saduma. Ama buná kwá myàng fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Asai-à bó ni, Yesu dang rag, “I soko buwú Tamí. Wù í àsàin-à pànn sig waisháu ma byar-à á jìnn ni. I soko buwú, jir kai bàna à tàm jànn rìghing yìr bu káníng á byar mpìr yarká ni, ma mpìrká yì sig bu. Ama à tìya rìghing mpìrká shi àràg í yann wùnshái big níng. ");
INSERT INTO jib_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tamí, à sa sig àràg barà pìkyinnwú ri zìm. ");
INSERT INTO jib_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tamí ya hing mì ayì á shinn bu bidìm pár. Walai mpìr-à yì sig mì, sái Tamí. Walai mpìr-à yì Tamí, sái mì, ma mpìrká ká ma dinya sig big barà ku shi sig áni. ");
INSERT INTO jib_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aning bi á byarmí ni, ning mpìrká ri wa shwìn níng ma mpìrká zyun-à swann sig swánn lìlìb nímá níng, má sa tag wann pìkyinn ná. ");
INSERT INTO jib_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aning kwonn shinn ná á byarmí ni. Aning shwann bar shumí. Mì í mpìr ǹsàn, mì ri yàn fig ngain bàna. Má ya ning byar shu byar-à ná shi ngàng. ");
INSERT INTO jib_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wà ná kwonn shinn ná ma mì, bàna ma shwìn. Swánn-à má ya ning aning swann níng, lib fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ayúnn su zyun í àyúnn Asabar, Yesu ri wam zu yag mà da-à ni. Yann sukàwá big fig amor n gbar kab jímyànn, mi ri zwam. ");
INSERT INTO jib_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Barà Farisawaká myàng àdòníng, big dinya Yesu rag, “A myàng bu-à yann sukàwú big ri sa. A dokayí ni sàn fig wà abig sa àdòníng àyúnn Asabar bàna.” ");
INSERT INTO jib_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A byar-à níng hi Yesu bib big n rag, “Asái ning jangga fig bu-à Dawuda rì sa sig bàna rà? Ku fig amor ma mpìrká ku ma káníng ri yag kyìnn í zyun. ");
INSERT INTO jib_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Barà ku kà yag mà lu Shìdun ni, ku zìg brodi-à big wib sig Shìdun ma kàhi níng, n ji, n ya mpìrká buwá a káníng ji tìnn, wà zyun-à sàn fig wà abig ji bàna, sái àgbamká ri twìb swànn bu á pyànn Shìdun ni níng má jì ni. Ama big ji rìghing. ");
INSERT INTO jib_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ning jangga fig bu-à Musa ba sig bàna rà? Ku ba sig rag, ‘Agbamká ri twìb swànn bu á pyànn Shìdun ni, ri sa swàm àyúnn Asabar. Ama shi fig bu pyìr bàna á pyànn Shìdun.’ ");
INSERT INTO jib_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N dinya ning àjai, mpìr zyun shi sig áyág zyun-à kab lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jir Shìdun dang rag, ‘N zìm kab sig aning myàng ashi jàuná, ǹ zìm kab fig bu twìb swànn bàna.’ Wà ning nìm ma yì hing yìr wàníng, ning nìm má swau fig mpìr ǹsàn bàna. ");
INSERT INTO jib_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mì Wùn Mpìr Jíkwìnn, ǹ shi sig ma gbam barà má dang bu-à mpìr má sa àyúnn Asabar.” ");
INSERT INTO jib_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu dù mà byar-à níng hi, n yag mà tonn bìr kwonn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","I byar-à hi, mpìr zyun shi sig áni, vùwá wu tag rìghing. Mpìrká káhi shi sig màhàn, big ri zìm abig dìg pyù-à bá dang bai Yesu. I byar-à big bib ku rag, “Dokayí dang sig rag, ayi dàb gbam mpìr àyúnn Asabar rà?” ");
INSERT INTO jib_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","I byar-à hi, Yesu bib big n rag, “Wà mpìr zyun áyauná ni ma shi sig ma àdùn, wà ma kù kà hing á shar àyúnn Asabar, kwá zìg zu fig àyúnn-à níng hi bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mpìr kab hing àdùn. I bu-à sa dokayí zìm hing ayi sa shang mpìr àyúnn Asabar.” ");
INSERT INTO jib_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","I byar-à hi, ku dinya mpìr-à vù-à wu tag sig níng n rag, a wàníng gbar lafinn vùwá. Wàníng gbar lafinn vù-à hi, n myàng vùwá gbam rìghing àràg vù zyun-à níng. ");
INSERT INTO jib_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","I byar-à hi Farisawaká dù n yag kwonn nu, àjirà abig gban rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Barà Yesu yì rag mpìr káníng ri zìm abig gban ku, sái ku dù mà byar-à níng hi, mi í yag rìgwá. Mpìrká nìnànn nímá bàg yag ku, ku dàb gbam vinn rìg mpìrká zyun-à dìrbá ri wa. ");
INSERT INTO jib_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ku twìb big byur n rag, kada abig dinya mpìrká bàna. ");
INSERT INTO jib_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ku sa sig àdòníng àjirà bu-à Ishaya mpìr-à rìi dang kyann jir Shìdun dang sig níng, aku shi àdòníng hi. Ishaya rag, ");
INSERT INTO jib_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wàníng í fàumí zyun-à ǹ shig zu sig, zyun-à mì ri zìm, ǹ bir hing pìkyinnmí á byarwá ni. Má sìnn kà Awunmí á dìrwá ni. Kwá dinya mpìrká jír á shinn barà má wà kwonnmí á byar mpìrká bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kwá gbìb fig shùr bàna, kwá yan fig yán bàna. Walai mpìr-à má fig nài yánwá á gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kwá sa shang mpìrká zyun-à bàna ma gbam, ma mpìrká yì fig bu zyun bàna níng. Kwá sa mpìrká abig sa kó kai á gbìb gwangga. ");
INSERT INTO jib_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mpìrká á jànn-à ni má sìnn pìkyinnbá á dìrwá ni.” ");
INSERT INTO jib_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mpìrká káhi zìg bi mpìr àfau á byar Yesu. Ku dang yì sar fig jír bàna, jir kai bàna wàu dab sig ku. Yesu dàb gbam mpìr-à níng hi, àjirà aku myàng ma aku dang sar jír. ");
INSERT INTO jib_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","I byar-à hi, bìr mpìrká shi sig màhàn níng, sa mamaki n rag, “Kó wàníng í wùn Dawuda rà?” ");
INSERT INTO jib_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Barà Farisawaká fig àdòníng, big dang rag, bu-à sa mpìr-à níng ri kan zu wàuká níng, í Baalzabul kùr wàuká ya síg ku gbam nì aku sa àdòníng. ");
INSERT INTO jib_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu yì rìghing bu-à big ri kyab á pìkyinnbá ni. I bu-à sa ku dinya big n rag, “Jànn-à ma gàfinn hing shinnwá byar pyànà ma ngain hing dìrbá, bá shi nonn fig bàna. Finn swann-à ma gàfinn hing kyau pyànà, má nonn fig bàna. Finn lu-à ma gàfinn hing kyau pyànà, má nonn fig bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wà Shaitan ma kan zu kàng yann sukàwá, ku gàfinn rìghing shinnwá kyau pyànà, kwá sa sar fig bu bàna, gbamwá má shi nonn fig rag bàna. ");
INSERT INTO jib_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ning dang rag, mì ri kan zu wàuká ma gbam Baalzabul, mpìrká buná big ri kan zu wàuká ma gbam ni rà? A jir shinn wàníng ni, bá wà ning kwonn. ");
INSERT INTO jib_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Shi fig àràg barà ning ri dang níng bàna. Mì ri kan zu wàuká ma gbam Awun Shìdun. Wàníng ri tàg rag kùr Shìdun bi rìghing á byarná ni. ");
INSERT INTO jib_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Walai mpìr-à má kà mà lu mpìr zyun-à shi sig ma gbam, má jwi wàníng ajwú, sai wà kwa sìr gbam hing wàníng, í wà kwá kà yag, má jwi bu. ");
INSERT INTO jib_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mpìr-à ma bàg fig mì bàna, ku í mpìr azíbmí. Mpìr-à ma zà kwonn shang fig mì zaká bumí bàna, ku í àsàin-à ri sa yam kìfinn. ");
INSERT INTO jib_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mì ri dinya ning, kó íri bu pyìr wà áni bidìm pár, ma bu-à bibaiká mpìr ri dang, Shìdun má yafa ya ku. Ama mpìr-à ma dang hing jír bibai á shinn Awun Shìdun, Shìdun má yafa ya fig mpìr-à níng hi bàna. ");
INSERT INTO jib_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mpìr-à ma dang hing jír á shinn Wùn Mpìr Jíkwìnn, bá yafa ya ku. Ama mpìr-à ma dang jír á shinn Awun Shìdun, bá yafa ya fig ku á dunyaru bàna, kó mà wai. ");
INSERT INTO jib_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Bín-à ma sàn hing, awanwá má sàn tìnn. Bín-à ma bai, awanwá má bai tìnn. Bá myàng yì bín sìsàn á jir awanwá ni. ");
INSERT INTO jib_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ning mpìr káníng, ning í bushùwí. Wà barà ning í mpìr bibai níng, ná dang jir sìsàn á shinn rà? Ai bu-à ma shi sig á pìkyinn mpìr, í bu-à kwá dang. ");
INSERT INTO jib_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mpìr ǹsàn má dang jír-à ǹsàn, jir kai bàna ku í mpìr pìkyinn ǹsàn. Mpìr-à bibai má dang jír àbai, jir kai bàna ku í mpìr pìkyinn àbai. ");
INSERT INTO jib_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mì ri dinya ning, íri jírká mpìrká ri dang kìfinn átai átai níng, àyúnn-à Shìdun má wà kwonnwá áni níng, kwá yan ta mpìrká níng hi. ");
INSERT INTO jib_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jírká à dang sig, í jírká bá wà kwonnwú áni. Wa dang sig jír ǹsàn, Shìdun má yan ta fig wù bàna. Wa dang sig jír bibai, Shìdun má yan ta wù.” ");
INSERT INTO jib_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Malamká ma Farisawaká káhi, dang rag, “Malam, yi ri zìm á sa ya yi bu mamaki.” ");
INSERT INTO jib_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu dinya big n rag, “Ning asa bu pyìrká, ma asa àyáiká, ning ri zìm ń sa ya ning bu mamaki. Má sa ya fig ning bàna, sái bu Yunana. ");
INSERT INTO jib_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Barà Yunana shi sig mà finn jái mà níng-à ni su sara níng, í barà mì má, mì Wùn Mpìr Jíkwìnn, má shi mà amir-à ni su sara. ");
INSERT INTO jib_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mpìrká rì á Nineve má dang tir ning àyúnn-à Shìdun má wà kwonnwá, jir kai bàna wà Yunana dinya big jir Shìdun níng, big dà fim rìghing bu pyìrbá. Mpìr-à kab Yunana shi sig níng, ama ning dà fim fig bu pyìrná bàna. ");
INSERT INTO jib_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Uwà zyun-à í kùr ùwài mà agunn àyúnn sàn kyùr, ku bi sig mà byar zyun ni pyunn ninonn nímá àjirà aku myàng írì yar-à Sulemanu shi sig ma kàhi. Ama tàma-à níng zyun-à kab sig Sulemanu shi sig áyág, ama ning ri zìm fig aning fig jírwá bàna. Jír wàníng, uwà-à níng má dang tir ning àyúnn-à Shìdun má wà kwonnwá. ");
INSERT INTO jib_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wà wàu ma zu hing á dìr mpìr, kwá yag mà byar àwun àjirà aku dìg byar-à kwá shi ngàng awunwá, ama wà kwa dìg fig bàna, ");
INSERT INTO jib_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kwá dang rag kwá kàng yag rìg mà byar-à ku nìm zu bi sig níng. Wà kwa kàng yag ma myàng lu-à hi ma shi sig átai, ba zà kyàr rìghing, ");
INSERT INTO jib_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","kwá yag dinn kwonn bi wàu sùmpyànn ká bai kab ku. Bá kà yag ma shi màhàn. Mpìr-à níng má wa kab shwìn tàma-à níng ma wàrì. Wàníng í barà má sa áni ma mpìr bibaiká tàma-à níng.” ");
INSERT INTO jib_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","A sai-à Yesu ri dang jír ma mpìrká, nàwá ma wunzàwá big bi sig á byarwá ni. Big sar sig mà myann, big ri zìm abig dang jír ma ku. ");
INSERT INTO jib_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A byar-à níng hi mpìr zyun màhàn dinya ku n rag, “Nàwú ma wunzàwú big bi sig, big sar sig mà myann. Big ri zìm abig dang jír ma wù.” ");
INSERT INTO jib_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu zìm n rag, “Má tìya ning mpìr zyun-à í nàmí ma wunzàmí big.” ");
INSERT INTO jib_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I byar-à hi, ku tàg yag vùwá mà byar yann sukàwá big n rag, “Káníng í nàmí ma wunzàmí big. ");
INSERT INTO jib_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mpìr-à ma sa hing bu-à Tamí mà wai ri zìm, í wunzàmí ma ajunwàmí, ma nàmí.” ");
INSERT INTO jib_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ayúnn-à níng hi, Yesu dù mà lu-à ni, n yag shi mà nu zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bìr mpìrká nìnànn nímá kwonn bi á byarwá ni. Ku kà á kòr-à ni n shi wann, bìr mpìr káníng sar sig á nu gàin-à ni. ");
INSERT INTO jib_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A byar-à níng hi, ku dinya mpìr káníng jírká nìnànn nímá ma misali n rag, “Aning myàng, mpìr zyun yag sig mà dawá ni n yag minn za. ");
INSERT INTO jib_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Barà ku minn za-à àdòníng, káhi ta kù wann sig á gbìb-à ni, ayinnbuká bi, mì wun ji rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Swaiká káhi ta kù wann sig á jànn abàn-à ni. Jànnká yan sig á shinn abàn-à hi ni títi nímá. A byar-à níng hi, nonn fig bàna za-à í nga nann zu rìg-à kíni, jir kai bàna jànn-à hi zwàun fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Barà àyúnn fàn wann áni, jìká í wim wu rìg-à, jir kai bàna adinnká kà zwàun fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Swaiká káhi ta kù kà sig áyau sí, síká hi wài nann zu, n bim nann zu rìg á shinn zaká ni. ");
INSERT INTO jib_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Swaiká káhi ta kù wann sig á byar jànn ǹsàn, nga nann zu ǹsàn nímá, n yìm adau wàni. Adau za-à hi shi sig ǹkwònn ǹkwònn nímá, káhi kab dìb-swana, káhi kab dìb-sara, káhi kab dìzyun agban dwib. ");
INSERT INTO jib_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Mpìr zyun-à ma shi sig ma sung-à kwá fig jír, aku fig.” ");
INSERT INTO jib_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yann sukàká bi á byar Yesu ni, n bib ku rag, “Bu-à sa wù ma ri zìm á dinya mpìr jír, wù ri dang ma tinn jír, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu dinya big n rag, “Buná big ya hing ning gbam-à ná yì barà kùr Shìdun shi sig áni. Ama bubá big ya fig big gbam-à hi bàna. ");
INSERT INTO jib_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mpìr-à ma shi sig ma bu, bá ya swàb kà ya ku àjirà aku dìg nànn. Mpìr-à ma bàna ma bu, kó wà títi-à ku shi sig ma kàhi níng, bá zìg rìg á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bu-à sa mì ri dinya big tinn jír níng, í jirà big ri myàng, ama big myàng yì fig bàna. Big ri fig, ama big fig byann fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bu-à Ishaya ba sig níng, sa hing dáb àràg barà ku ba sig. Ku ba sig jír-à Shìdun dang sig n rag, ‘Bá fig, má fig jakàng, ama bá fig byann fig bàna. Bá myàng, má myàng jakàng, ama bá myàng kyàr fig bàna, ");
INSERT INTO jib_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","jir kai bàna pìkyinnbá wu rìghing, big ri fig fig rag jír bàna. Big bir dim rìghing zubá, nìm má àdòníng bàna, big nìm má myàng. Sungbá nìm má fig jír, big nìm má fig byann, n nìm má vim bìr kàng bi rìg á byarmí ni. N nìm má dàb gbam rìg big.’ ");
INSERT INTO jib_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ama buná ning fig hing àjwár, jir kai bàna ning ri myàng kyàr, sungná ri fig jír tìnn. ");
INSERT INTO jib_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mì ri dinya ning àjai, yann aswam Shìdun big ma mpìrká rì sa bu ǹsàn á pyànn Shìdun ni níng, big rì zìm abig myàng bu-à ning myàng sig níng, ama big myàng fig bàna. Big ri zìm abig fig bu-à ning fig sig níng, ama big fig fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Aning fig, má dinya ning yìr tinn jír á shinn aminn za-à níng. ");
INSERT INTO jib_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Swaiká zyun-à ta kù wann sig á gbìb-à ni níng, shi sig àràg mpìrká fig sig jir Shìdun, ama big fig byann fig bàna. Shaitan bi tonn gban big, n gbar vim bìr rìg bu-à big tàg sig á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Swai buká ta kù wann sig á jànn-à yan sig á shinn abàn-à ni níng, shi sig àràg mpìrká fig sig jir Shìdun ma pìkyinn àjwár, ");
INSERT INTO jib_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ama big bir zwàun fig pìkyinnbá áni bàna. Ba shi nonn títi nímá. Shwìn ma bi dìg hing big dò jirà big zìg sig jir Shìdun níng, í nann-à hi big í dà fim rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Swai buká zyun-à ta kù wann sig á sí-à ni níng, shi sig àràg í mpìrká fig sig jir Shìdun, ama big ri kyab jír wàni. Big ri zìm abig fig àjwár. Big ri zìm abig shi mpìr bài. Bu káníng bidìm pár í bu-à ri kan dim big wà bá bàg jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ká zyun-à ta kù wann sig á jànn-à ǹsàn níng, shi sig àràg í mpìrká fig sig jir Shìdun, n fig byann hing wàni. Big shi sig àràg í yìr bu-à má wan awan ǹsàn. Káhi kab dìb-swana, káhi kab dìb-sara, káhi kab dìzyun agban dwib.” ");
INSERT INTO jib_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu dinya big tinn jír zyun n rag, “Byar-à Shìdun ri na kùrwá shi sig àràg í mpìr-à minn sig swai buju ǹsàn nímá mà dawá ni. ");
INSERT INTO jib_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ama á sai-à mpìrká na jànn gban rìghing níng, mpìr azíbwá bi n minn kà yìr byann mà yau bujuká ni, mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Barà buju-à wài dù nann zu n nìm, má sa rag yìr níng, í wà byann-à í wài dù nann zu-à. ");
INSERT INTO jib_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A byar-à níng hi, fàuká bu mpìr-à níng bi n bib ku rag, ‘Malam, swai bu-à à minn sig mà dawú ni í swai bu ǹsàn. Byann káníng bi sig áni rà?’ ");
INSERT INTO jib_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A byar-à níng hi, ku dinya káníng n rag, ‘I mpìr azíbmí big minn síg nì bu-à níng.’ Fàu káníng bib ku n rag, ‘Kó ayi yag gbìb zu ya wù rà?’ ");
INSERT INTO jib_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ku dinya big n rag, ‘A a, kada aning yag gbìb zu bàna, jir kai bàna kada aning gbìb zu kwonn ma buju-à í zyun. ");
INSERT INTO jib_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aning fim buju-à ma byann-à abig wài dù nann zu í zyun har sai-à má binn buju-à. I wà má dinya mpìrká má binn níng, abig bi gbìb zu rìg byannká, ma abig sìr kwonn í byar ńzyun, abig ta kà rìg mà pyìr-à ni. Bujuká abig sìnn kwonn í byar ńzyun ma abig ngàb kà rìg mà vonn-à ni.’ ” ");
INSERT INTO jib_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu dinya mpìrká tinn jír rag, “Byar-à Shìdun ri na kùrwá shi sig àràg mpìr-à ma minn sig swai masita mà dawá ni. ");
INSERT INTO jib_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Swai-à hi shi sig títi nímá, ama wà ba minn hing, má wài nann zu hing ri wài kab kó jì bu-à wà áni bidìm pár. Ayinnbuká ri sa lubá mà ayabwá ni.” ");
INSERT INTO jib_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu dinya jakàng big tinn jír zyun n rag, “Byar-à Shìdun ri na kùrwá shi sig àràg í yisti bu-à ri lílib. Uwà zyun ma zìg hing yisti, ma ta kà hing á mìg tasa sara, mìg-à ma ji bànn kwonn hing, má lib swàb kà.” ");
INSERT INTO jib_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ri dinya kyann bìr mpìr káníng jírwá ma tinn jír, ku ri dinya fig mpìr jír átai bàna, sái ma tinn jír. ");
INSERT INTO jib_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ku ri sa bu káníng àràg barà mpìr-à rìi dang kyann jir Shìdun dang sig rag, “Má dinya mpìrká tinn jír. Má dang vinn rìg bu-à big rì bònn tàm sig tun sai-à big màm jag sig dunyaru.” ");
INSERT INTO jib_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Barà Yesu dù dà fim bìr mpìr káníng, ku kà yag mà lu-à ni, á byar-à hi yann sukàwá big bàg yag ku n bib ku rag, “A dinya yi yìr tinn jír-à á shinn byann-à mà da-à ni.” ");
INSERT INTO jib_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ku dinya big n rag, “Mpìr-à minn sig swai buju-à ǹsàn níng í Wùn Mpìr Jíkwìnn. ");
INSERT INTO jib_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Da-à hi í dunyaru, swai buju-à ǹsàn níng í mpìrká á kùr Shìdun ni. Byann káníng í mpìrká zyun-à big í bu Shaitan. ");
INSERT INTO jib_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mpìr azíb-à mìnn sig byann káníng, í Shaitan. Ayúnn-à bá binn áni níng, í àyúnn-à dunyaru má vinn áni. Abinnká í yann aswam Shìdun mà wai. ");
INSERT INTO jib_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aràg barà big ri wun kwonn byannká mi ri du swànn mà pyìr-à ni níng, í barà má sa áni àyúnn-à wà kinn shinn. ");
INSERT INTO jib_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wùn Mpìr Jíkwìnn má swam bi yann aswamwá mà wai abig wun kwonn rìg mpìrká zyun-à ri sa mpìrká abig sa bu-à bibai, ma mpìrká ri sa bu pyìr. Abig zìg zu rìg káníng mà byar-à Shìdun ri na kùrwá, ");
INSERT INTO jib_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","abig ta kà káníng á lu pyìr-à ni, á byar-à bá kig nàikitáu wàni, hár má zwàm kà vù á nginnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mpìr Shìdun big má fig àjwár. Mùnnpyànnbá má zwàm átai kpàin kpàin mà byar-à Tabá ri na kùrwá. Ká zyun-à shi sig ma sung, abig fig jír-à níng. ");
INSERT INTO jib_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Byar-à Shìdun ri na kùrwá shi sig àràg í zinariya ùwài big jì dim sig mà da-à ni. Wà mpìr zyun ma dìg hing, kwá tàm jànn rìg, má yag ma àjwár á pìkyinnwá ni, aku yag wann tafinn gban rìg buká ku shi sig ma kàhi bidìm pár, ma aku wann da-à níng, jir kai bàna ku ri zìm zinariya-à níng. ");
INSERT INTO jib_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Byar-à Shìdun ri na kùrwá shi sig àràg í mpìr-à yag mi ri yàn kyann abàn nsònn. ");
INSERT INTO jib_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Barà ku dìg wà ǹsàn-à níng, í byar-à ku yag n wann tafinn rìg buká ku shi sig ma kàhi, mi í wann rìg-à abàn-à níng ma kàhi. Ku zìm kab sig abàn nsònn-à níng ma kó kai bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Byar-à Shìdun ri na kùrwá shi sig àràg mpìr agban jáiká zyun-à wìr sig àpìbá mà níng-à ni, n gban sig jáibá kim kim. ");
INSERT INTO jib_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Barà jáiká kà mònn sig mà àpì-à ni àdòníng, big í gbar zu bi rìg-à á myann, n shi wann rìg á jìnn ni, n shig zu rìg jáiká wà ǹsàn ǹsàn níng, n sìnn kà rìg á gágsàg-à ni. Ká zyun-à sàn fig bàna níng, big í tafinn rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wàníng í barà má shi áni àyúnn-à wà kinn shinn. Ayúnn-à níng hi, yann aswam Shìdun mà wai má bi, bá shig zu rìg mpìr bibaiká áyau ǹsànká ni. ");
INSERT INTO jib_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","A byar-à níng hi, bá ta kà rìg big mà pyìr-à ni mà byar-à bá kig mínn hár má zwàm kà vù á nginnbá ni.” ");
INSERT INTO jib_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu bib big abib n rag, “Ning fig byann hing jír-à níng rà?” Big zìm n rag, “Nn.” ");
INSERT INTO jib_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ku dinya big n rag, “Malamká bidìm pár zyun-à kàng sig yann aswam á shinn barà Shìdun má na kùrwá níng, shi sig àràg àsàin lu, áyau buká ku shi sig ma kàhi níng, ku ri zìg zu bi bu àpyúká ma àkorká.” ");
INSERT INTO jib_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Barà Yesu dang vinn rìg tinn jírwá àdòníng, ku dù mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Barà ku kàng yag sig mà jànnwá ni àdòníng, sái ku kà mi ri tàg mpìrká jir Shìdun mà tonn bìr kwonn-à ni. A byar-à níng hi, mpìrká sa mamaki n rag, “Mpìr-à níng dìg sig yar-à níng ma gbam-à níng áni rà? ");
INSERT INTO jib_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wàníng í wùn kapinnta bàna rà? Nàwá í Maryamu bàna rà? Wunzàwá big í Yakubu, ma Yusufu, ma Siman, ma Yahuda bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wàníng í zyun-à ajunwàwá big shi sig ma yi níng bàna rà? Ku dìg sig yar káníng áni rà?” ");
INSERT INTO jib_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I byar-à big ngàng ku. Sái ku dinya káníng n rag, “Mpìr-à ma ri dang kyann jir Shìdun, big ri wib ku kó áni bidìm pár, ama mpìrká á jànnwá ni, ma mpìrká á luwá ni, big ri ngàng ku, mi ri wib fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ku sa fig swàm bu mamakiká nìnànn nímá màhàn bàna, jir kai bàna big bir fig pìkyinnbá á byarwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A sai-à níng hi, Hirudus kùr-à á Galili fig tai á shinn Yesu. ");
INSERT INTO jib_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ku dinya yann sukàwá big n rag, “Wàníng í Yohanna àsàin-à rìi wau dìr batisma, ku dù nann zu rìghing mà amir ki-à ni, í bu-à sa ku dìg sig gbam-à, mi ri sa bu mamaki-à níng.” ");
INSERT INTO jib_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sai-à bu-à níng sa fig ma bàna níng, Hirudus dang rìghing rag abig pànn rìg Yohanna, ma abig sìr ku, abig kìg kà ku mà tonn fi-à ni. Hirudus sa sig àdòníng á jir shinn Hirudiyas wà shunwòwá Filibus. ");
INSERT INTO jib_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bu-à sa níng, Yohanna rì dinya kyann sig Hirudus rag, barà wàníng zìg sig uwà-à níng, sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudus ri zìm aku gban rìg Yohanna, ama ku ri shàr zinn bìr mpìrká, jir kai bàna mpìrká ri myàng wàníng rag í mpìr-à ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A sai-à Hirudus sa buki àyúnn-à big mà sig ku áni níng, wùn uwà Hirudiyas gbìb jau á pyànn bìr mpìrká ni, hár Hirudus fig àjwár wàni. ");
INSERT INTO jib_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A byar-à níng hi Hirudus myàng àdòníng, n tun ki n dinya wùn uwà-à níng n rag, “Bu-à wù ma ri zìm í bu-à má ya wù.” ");
INSERT INTO jib_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wùn uwà níng hi, nàwá dinya ku n rag, “A vig Hirudus aku ya wù shinn Yohanna, àsàin-à ri wau dìr batisma níng, á tasa.” ");
INSERT INTO jib_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Barà kùr-à hi fig àdòníng, dìrwá í wu tag rìgwá. Ama jirà ku nìm gib rìghing nu á pyànn bìr mpìrká ni, sái ku dinya mpìrká buwá n rag, abig ya wùn uwà-à níng bu-à wàníng ri zìm. ");
INSERT INTO jib_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ku dinya mpìrká abig yag gib shinn Yohanna mà tonn fi-à ni. ");
INSERT INTO jib_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A byar-à hi big yag zìg bi shinn Yohanna á tasa-à ni, n ya wùn uwà-à níng, ku zìg yag mà byar nàwá ni n ya wàníng. ");
INSERT INTO jib_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yann sukà Yohanna big bi, n zìg rìg ki Yohanna, mì jì rìg-à mà shar-à ni. A byar-à hi, big yag n dinya Yesu. ");
INSERT INTO jib_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Barà Yesu fig tai Yohanna àdòníng, ku dù á byar-à níng hi, n kà á kòr-à ni, mì yag rìgwá mà byar awù zyun. Barà mpìrká fig àdòníng, big dù mà kauyebá ni kim kim, n bàg yag ku mà bar. ");
INSERT INTO jib_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Barà Yesu tìg wann mà kòr-à ni, ku myàng bìr mpìrká, sái ashi káníng pànn rìg ku, ku í dàb gbam rìg-à mpìr dorká. ");
INSERT INTO jib_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Barà kamzau fòr àdòníng, sái yann sukàká buwá bi á byarwá ni n rag, “Byar-à níng í awúnn, kamzau sa rìghing. A dwim mpìr káníng abig yag mà kauyeká ni àjirà abig wann ya shinnbá buju.” ");
INSERT INTO jib_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A byar-à níng hi, Yesu dinya big n rag, “Kada aning fim mpìrká abig yag bàna. Ning ma shinn ná aning ya big buju abig ji.” ");
INSERT INTO jib_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Big dinya Yesu n rag, “Bu-à yi shi sig ma kàhi í brodi àkunn swana ma jái àkunn pyànà.” ");
INSERT INTO jib_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A byar-à hi, Yesu dinya big n rag, abig zìg bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ku dinya bìr mpìr káníng abig shi wann á shinn byann-à ni. Ku zìg brodi àkunn swana ma jái àkunn pyànà, n myàng yag zuwá mà wai, n sa Shìdun í soko. Ku ngir gàfinn brodi awín awín n ya yann sukàká buwá big abig gàfinn ya bìr mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bìr mpìr káníng ji hár n ji mònn rìg finnbá. Yann sukàwá big wun kwonn brodi-à ma jái-à dà sig níng, mònn gágsàg dwib agban pyànà. ");
INSERT INTO jib_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bìr wunùká ká zyun-à ji sig buju-à níng, big fòr hing dubu swana. Wàníng íri wunùká, big wànn kà fig uwàká ma yanká áni bàna. ");
INSERT INTO jib_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A byar-à níng hi Yesu dinya yann sukàká buwá big abig kà á kòr-à ni, abig yag jag ku mà jann, sai wà kwa dwim gàfinn hing dìr ma bìr mpìr káníng ḿpyim, í wà kwá yág ni. ");
INSERT INTO jib_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Barà ku dwim gàfinn dìr ma mpìrká àdòníng, ku nann yag mà mwír-à ni, n vig Shìdun. Ku shi sig màhàn awínwá ni hár àkamzau. ");
INSERT INTO jib_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A sai-à níng hi, kòr-à shi sig mà yau níng-à ni, afag zàpìr ri dab wìr kà áni, jir kai bàna wàu ri gbar bi mà pyànnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","I pinnpàin Yesu bi á byar yann sukàwá big ni, ku ri kyann á shinn zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Barà yann sukàwá big myàng ku ri kyann á shinn zàpìr-à ni àdòníng, big shàr rìg zinn n yan yán n rag, “Wàníng í wàu.” Dìrbá ri zwab kàg kàg kàg. ");
INSERT INTO jib_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A byar-à níng hi, Yesu dinya big jír n rag, “Aning tib wann pìkyinn ná, í mì ǹ bi síg nì, kada aning shàr zinn bàna.” ");
INSERT INTO jib_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sái Bitrus zìm n rag, “Shinn Lumí, wà má í wù àjai, á sa ń kyann yag á byarwú ni á shinn zàpìr-à ni.” ");
INSERT INTO jib_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A byar-à hi, Yesu bar bi Bitrus n rag, “A bi!” Sái Bitrus tìg wann bi á kòr-à ni, n kyann yag mà byar Yesu á shinn zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Barà ku myàng wàu ri gbar àdòníng, ku í shàr rìgwá zinn, ku myàng ku ri sib kà wann mà mìr zàpìr-à ni. A byar-à hi, ku yan nài yán n rag, “Shinn Lumí, á zìg zu mì.” ");
INSERT INTO jib_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kinn fig su bàna, Yesu du yag vùwá n pànn zu bi ku n bib ku n rag, “A bir fig pìkyinnwú á byarmí ni bàna rà? Bu-à sa wù ri shàr zinn í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A byar-à níng hi, big pyànà bidìm pár, big kà rìg mà kòr-à ni, sái wàu-à hi í sar rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A byar-à hi, mpìrká zyun-à shi sig mà kòr-à ni níng, wib ku n rag, “Ajai wù í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Big pìm zu yag rìg mà jann, mà jànn zyun Janisarata. ");
INSERT INTO jib_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Barà mpìrká màhàn myàng yì rag í Yesu àdòníng, big dwim bar kwonn gban rìg mpìr dorká mà jànn-à níng hi bidìm pár, abig bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Big vig ku n rag, aku fim mpìr dorká a káníng pànn íri nu jàwá. Ká zyun-à pànn sig nu jàwá níng, big gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","I byar-à hi Farisawaká ma malamká, big bi sig mà Urushalima á byar Yesu ni, big bib ku jír n rag, ");
INSERT INTO jib_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bu-à sa yann sukàwú big ngàng wà bá wib jír bu-à yàkúyí big rì dang sig í jir kai rà? Bu-à sa big ri tu fig vùbá ḿpyim jirà abig ji buju íni bàna níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu zìm n dang rag, “Bu-à sa ning wib fig doka Shìdun bàna, ning ri bàg íri bu tàgná í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Shìdun dang rag, ‘Aning wib taná ma nàná.’ Ku dang jakàng n rag, ‘Mpìr-à ma swau hing tawá kó nàwá abig dab gban rìg ku.’ ");
INSERT INTO jib_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama buná ning tàg mpìrká n dang rag, kó ni aku dinya tawá ma nàwá aku rag, bu-à ku nìm má ya káníng, ku ya rìghing Shìdun. Mpìr-à ma sa hing wàníng, ku ri wib fig tawá bàna. ");
INSERT INTO jib_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ning dang rag, má sàn fig wà aku wib tawá bàna, wà má àdòníng, ning kìm hing doka Shìdun, n bàg rìghing íri jír buká ning ri tàg. Jírná sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ning í mpìrká ri dang jír nu pyànà, jír-à Ishaya rì ba sig á shinn ná ni níng, í àjai. Ku ba sig jir Shìdun n rag, ");
INSERT INTO jib_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mpìrká tàma-à níng ri wib mì ma nu átai. Ama big bir fig pìkyinnbá á byarmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Big ri wib mì ma nu átai, big ri tàg sù bu àgbamká bubá rì, mi ri sa shi rag í dokamí.’ ” ");
INSERT INTO jib_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu bar bìr mpìrká n dang rag, “Aning gang sung, ma aning fig byann jírmí. ");
INSERT INTO jib_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Walai bu-à mpìr má ji zyun-à má sìnn kàng ku jín, sái bu-à ma zu bi á nu mpìr, í bu-à má sìnn kàng ku jín.” ");
INSERT INTO jib_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","I byar-à yann sukàwá big bi n dinya kàng ku n rag, “A yì fig wà Farisawaká ri nànn àgùnn ma jír-à à dang sig níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ku dinya káníng n rag, “Bu-à ba jann sig, wà ma í Tamí mà wai ma jann fíg nì bàna, bá gbar gbìb zu rìg. ");
INSERT INTO jib_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aning fim big, big í àgbamká shi sig àràg àfau big. Afau ma gbar hing àfau, big pyànà bidìm pár bá kù kà á shar.” ");
INSERT INTO jib_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","I byar-à hi Bitrus dang rag, a wàníng dinya byann big yìr jír-à níng. ");
INSERT INTO jib_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu dinya big n rag, “Hár tàma-à níng ning fig yì fig yìr jírmí bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ning yì fig wà bu ma kà hing á nu, ri kà yag mà finn, mi ri zu bi rìg á myann níng bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama bu-à ma zu bi á nu, ri zu bi mà pìkyinn mpìr. I bu-à má sa bai mpìr. ");
INSERT INTO jib_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bu bibai-à mpìr ma sa bidìm pár ri zu bi mà pìkyinnwá ni, àràg ki gban, ma jir àyái, ma ajwú, ma jír ǹsáng, ma jír azìnn. ");
INSERT INTO jib_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bu káníng í bu-à ri sa bai mpìr. Ama jirà mpìr má ji buju ku tu fig vùwá bàna, kàhi má sa bai fig mpìr bàna.” ");
INSERT INTO jib_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu dù á byar-à hi ni n yag mà jànn Taya big Sidon. ");
INSERT INTO jib_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I byar-à hi uwà zyun mà jànn Kananiya bi n kig dinya Yesu rag, “Shinn Lumí, Wùn Dawuda, á myàng ashimí, wàu dab sig wùn uwàmí zyun, ku fig fig àjwár bàna.” ");
INSERT INTO jib_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu dang fig jír ma ku bàna. Sái yann sukàwá big bi á byarwá ni, n vig ku n dang rag aku kan rìg uwà-à níng, kada a wàníng bàg big ma nài yán bàna. ");
INSERT INTO jib_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","I byar-à Yesu dang n rag, “Big swam bi sig mì á byar àdùnká nang jànn sig, àdùnká hi í mpìr Israilaká.” ");
INSERT INTO jib_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","I byar-à hi sái uwà-à níng bi bìnn kir wann á pyànnwá ni n dang rag, “Shinn Lumí, á sa shang mì.” ");
INSERT INTO jib_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ku dang rag, “Sàn fig wà abig zìg buju yanká abig ta ya bái bàna.” ");
INSERT INTO jib_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","I byar-à hi uwà-à níng dang rag, “Jírwú àjai, Shinn Lumí. Ama báiká ri ji buju-à yanká ma ji dà sig.” ");
INSERT INTO jib_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","I byar-à Yesu dinya ku rag, “Kai, uwà-à níng pìkyinnwú à bir sig á byarmí ni níng wài hing. Bu-à wù ri zìm níng, má sa ya wù.” Kinn fig su bàna sái wùnwá í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu dù màhàn n bàg á nu Ayunn Galili, n nann zu yag mà shinnkwìnn-à ni, n shi sig màhàn. ");
INSERT INTO jib_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bìr mpìrká nìnànn nímá ri bi á byarwá ni big swann bi kwonn sig ma mpìrká ri kyann sar fig kyonn bàna, ma mpìrká vù-à ma bar-à kìm rìghing, ma àfau big, ma mpìr anam àsír big, ma mpìrká nìnànn nímá dor kim kim big sìnn sig big á pyànnwá ni. Ku dàb gbam vinn rìghing big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hár mpìrká sa mamaki big myàng mpìr anam àsír ri dang rag jír, mpìrká vùká ma barká kìm rìghing níng, bidìm pár bànn kinn kàng rìghing. Mpìrká ri kyann sar fig kyonn bàna níng ri kyann lafinn rag ma barbá. Afauká ri myàng rag ma zubá tìnn. I byar-à hi big swam yan Shìdun mpìr Israilaká á sai-à hi ni. ");
INSERT INTO jib_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu bar yann sukàwá big n dang rag, “Mì ri myàng ashi bìr mpìr káníng wàni, jir kai bàna janá-à níng subá sara big shi sig á byarmí ni, big dìg fig bu-à bá ji bàna. N zìm fig wà ń dwim gàfinn dìr ma big átai bàna, jir kai bàna kada abig kù ànù á gbìb-à ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","I byar-à hi yann sukàwá big dinya ku n rag, “Yá dìg bi buju-à yá ya bìr mpìr káníng awúnn-à níng ni á ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu bib big n dang rag, “Ning shi sig ma brodi àkunn píná rà?” Big dang rag àkunn sùmpyànn ma jái títi nímá tìnn. ");
INSERT INTO jib_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I byar-à hi ku dinya bìr mpìr káníng abig shi wann á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I byar-à ku zìg brodi àkunn sùmpyànn ma jái, n sa Shìdun ísoko, n ngir gàb fim, n ya yann sukàwá big abig gàb fim ya bìr mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I byar-à big ji har finnbá zìr. I wà yann sukàwá big wun kwonn brodi-à ma jái-à dà sig níng, mònn gágsàg sùmpyànn. ");
INSERT INTO jib_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mpìrká ji sig buju káníng dubu yina íri wunù big. Big wànn kà fig uwàká ma yann wùnsháiká áni bàna. ");
INSERT INTO jib_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I byar-à hi Yesu dwim gàb fim dìr ma big, n kà á kòr-à ni, mi í yag rìg-à mà jann Magadan. ");
INSERT INTO jib_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sái mpìr Farisawaká ma mpìr Sadukiyawaká bi abig màg màg fig Yesu, í wà big dinya ku n rag, aku sa ya big bu mamaki àjirà abig yì wà kwa wann bi síg mà byar Shìdun ni àjai. ");
INSERT INTO jib_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ama Yesu dang rag, “Wà na myàng àyúnn-à ma kà rìghing ná dang rag àyúnn-à pinn sig apa, shyù má tab fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","I pyim byau yìì nímá, na dang rag shyù má tab, wà na myàng waisháu ma wa kwonn sig jín pìpìr. Ná myàng yì bu káníng, ama bu-à Shìdun má sa tàma-à níng ná myàng yì sar fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ning mpìrká á jànn-à tàma-à níng, ning í mpìr asa bu pyìr, ning í mpìr asa àyái big, bu mamaki-à ning ri zìm ń sa ya ning, í wà áni rà? Ai má sa fig bàna. Bu mamaki-à má sa ya ning níng, má shi àràg bu Yunana rì níng.” Sái ku fim rìg káníng mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Barà big yag fòr mà jann, àsái yann sukàwá big màm jànn rìghing big pànn zìg yag kwonn fig ma brodi í zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sái Yesu dinya big n rag, “Aning pànn shinn ná, kada aning bir pìkyinn ná á yisti Farisawaká ma Sadukiyawaká ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","I byar-à hi big dang jír áyau bar dìrbá ni n rag, “Bu-à sa ku dang àdòníng, í jirà yi zìg bi fig brodi bàna níng.” ");
INSERT INTO jib_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu yì rìghing jír bu-à big ri dang níng, í wà ku dang rag, “Ning bir fig pìkyinn ná bidìm pár á byarmí ni bàna, í bu-à sa ning ri dang jír á shinn barà ning zìg bi fig brodi bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hár tàma-à níng ning yì byann fig bàna rà? Ning kyab pànn fig sai-à ǹ ngir gàb fim brodi àkunn swana, n ya mpìr dubu swana níng bàna rà? Ning wun kwonn wà dà níng mònn gágsàg píná rà? ");
INSERT INTO jib_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma sáshinn brodi àkunn sùmpyànn yi ya mpìr dubu yina níng fa? Ning wun kwonn wà dà níng mònn gágsàg píná rà? ");
INSERT INTO jib_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bu-à sa ning fig yì fig bàna í jir kai rà? Ai ǹ dang fig í jir brodi bàna, ǹ dang rag, aning pànn shinn ná ma jir yisti bu Farisawaká ma Sadukiyawaká níng.” ");
INSERT INTO jib_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I byar-à hi yann sukàwá big í fig yì rìg-à. Wato jír-à ku dinya sig káníng níng, í jír á shinn yisti bàna, ama ku ri dinya káníng jír á shinn bu tàg Farisawaká ma Sadukiyawaká. ");
INSERT INTO jib_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Barà Yesu yag mà jànn Kaisariya Filibi, í byar-à hi ku dinya yann sukàwá big n rag, “Mì Wùn Mpìr Jíkwìnn, mpìrká ri kyab rag, mì í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I byar-à hi big dang rag, “Mpìrká káhi dang rag, wù í Yohanna awau dìr batisma. Káhi dang rag, wù í Iliya. Káhi dang rag, wù í Irimiya. Káhi dang rag, kó wù í mpìr zyun áyau mpìrká rìi dang kyann jir Shìdun bi síg nì.” ");
INSERT INTO jib_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ku bib big n rag, “Ma bigná, ning ri kyab rag, mì í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","I byar-à Siman Bitrus zìm n dang rag, “Wù í Almasihu Wùn Shìdun, Shìdun àsàin-à shi sig ma yonki níng.” ");
INSERT INTO jib_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu dinya ku rag, “Jírwú sàn hing, Siman wùn Yohanna. I Tamí mà wai tàg síg wù jír-à níng nì. I mpìr zyun kim tàg fíg wù nì bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mì ri dinya wù, wù Bitrus, wù í abàn. Má bar kwonn mpìr iklisiyamí á byar abàn-à hi. Gbam lu pyìr má sa fig iklisiya bu bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Má ya wù kíi-à wá pù nu nkyun lu Shìdun áni mà wai. Bu-à wa kìg sig á jànn-à ni má kìg mà wai tìnn. Bu-à wa pù sig á jànn-à ni má pù mà wai.” ");
INSERT INTO jib_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","I byar-à Yesu dinya yann sukàwá big n rag kada ba dinya swann kó mpìr ńzyun rag ku í Almasihu. ");
INSERT INTO jib_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","I byar-à Yesu kà mi ri dinya yann sukàká buwá barà kwá wu kiwá áni. Ku dang rag shi sig ku àràg í dole aku yag mà Urushalima. Agbamká ma mpìrká ri twìb swànn bu á pyànn Shìdun ni ma malamká má du kà ku shwìn wàni. Hár kwá wu rìg, áyau su sara kwá dù nann zu kàng ma yonki. ");
INSERT INTO jib_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","I byar-à hi Bitrus gbar yag ku mà byar zyun n yan ta ku n dang rag aku shi àdòníng bàna. ");
INSERT INTO jib_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu vim bìr n myàng Bitrus n dang rag, “A dù á pyànnmí ni, wù í Shaitan, wù ri zìm ator pànn mì. Bu-à wù ri kyab níng, wù ri kyab fíg bu Shìdun bàna. Wù ri kyab bu-à mpìr ri kyab.” ");
INSERT INTO jib_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ku dinya yann sukàwá big n rag, “Mpìr-à ma ri zìm aku bàg mì, aku wann tafinn shinnwá, ma aku zìg shwìn-à má bi á dò jir shinnmí ni, í wà aku bàg mì. ");
INSERT INTO jib_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mpìr-à ma ri zìm shinnwá, kwá dìg fig yonkiwá bàna. Ama mpìr-à ma wann tafinn shinnwá á dò jir shinnmí ni, kwá dìg yonkiwá. ");
INSERT INTO jib_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wà mpìr ma dìg gban rìg buká á dunyaru, ma dìg fig yonkiwá bàna, buká ku dìg sig níng má swàb kà ya ku kai rà? Bu-à mpìr má ya jirà aku dìg kàng yonkiwá, í kai rà? ");
INSERT INTO jib_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wùn Mpìr Jíkwìnn nyàan bi, kwá bi ma gbam Tawá. Kwá bi kwonn ma yann aswamká mà wai, kwá wà kó ni kwonn ábibir bar buká big sa sig. ");
INSERT INTO jib_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jír-à níng í jír àjai, mpìrká káhi má shi sig ma áni á jànn-à ni, bá wu fig bàna, hár àyúnn-à Wùn Mpìr Jíkwìnn má wann bi ma kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na kù su sùnnjin Yesu zìg yag Bitrus ma Yakubu ma Yohanna wunzà Yakubu mà shinnkwìnn zyun ni mà wai. Big shi sig màhàn awínbá ni. ");
INSERT INTO jib_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Barà big ri myàng ku àdòníng, í byar-à zwánnwá í vim bìr rìg-à, sái big myàng zwánnwá ri zwàm kpàin kpàin àràg í àyúnn. Jàwá mìg shi karr àràg í sònn. ");
INSERT INTO jib_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","I byar-à yann sukà sara káníng myàng Musa ma Iliya mìr gbìb zu, mi ri dang jír ma Yesu. ");
INSERT INTO jib_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sái Bitrus dinya Yesu n rag, “Shinn Luyí, barà yi shi sig áyág níng, sàn hing. Wa zìm hing má dab apig sara, zyun í buwú, zyun í bu Musa, zyun í bu Iliya.” ");
INSERT INTO jib_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Barà ku ri dang níng, sái akor mìmìg karr nímá wann bi, n nim dim gban rìg big màhàn. Nài jír zu bi áyau akor-à ni n dang rag, “Wàníng í wùnmí zyun-à mì ri zìm wàni, mì ri fig àjwárwá, aning fig jírwá.” ");
INSERT INTO jib_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Barà yann sukà Yesu big fig jír-à níng sái zinn pànn rìg big, hár big yag bir kù ma finn. ");
INSERT INTO jib_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","I wà Yesu bi fòr á byarbá ni, n tib big vù á dìr n dang rag, abig dù nann á wai, abig shàr zinn bàna. ");
INSERT INTO jib_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","I byar-à big dù nann zu big myàng fig mpìr bàna, sái íri Yesu. ");
INSERT INTO jib_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Barà big tìg wann bi mà shinnkwìnn-à ni, Yesu dinya big rag, “Aning dinya mpìr bu-à ning myàng sig níng bàna fa, sái àyúnn-à ba gbar dù nann zu kàng hing Wùn Mpìr Jíkwìnn ma yonki.” ");
INSERT INTO jib_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","I byar-à yann sukàká bib Yesu n rag, “Bu-à sa malamká dang rag, Iliya má bi jág nì, í wà Kristi má bí ni níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu dinya big n rag, “Iliya má bi jág nì àjai, kwa bi hing kwá sa samyib kó kai bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama mì ri dinya ning, ái Iliya bi rìghing, ama mpìrká á jànn-à ni yì fig ku bàna. Big sa rìghing ku bu-à big ri zìm. Wàníng má í barà bá sa ma Wùn Mpìr Jíkwìnn áni tìnn.” ");
INSERT INTO jib_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","I byar-à hi yann sukàwá big yì rìghing ku ri dang jír á shinn Yohanna awau dìr batisma. ");
INSERT INTO jib_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Barà big fòr bi áyau bìr mpìrká ni, sái mpìr zyun bi á byarwá ni, n bìnn kir wann á pyànnwá ni n dang rag, ");
INSERT INTO jib_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Shinn Luyí, á myàng ashi wùnmí, kwonn ri gbar ku, ku ri wa shwìn wàni kàun nìnànn nímá. Ku ri kù kà kyann á pyìr ma zàpìr. ");
INSERT INTO jib_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N zìg yag ku mà byar yann sukàwú big ni, big dàb gbam yì sar fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","I byar-à Yesu dinya big n rag, “Kai! Bu-à sa ning bir fig pìkyinn ná á byarmí ni bàna, hár tàma-à níng, í jir kai rà? Ning ri gbam sung. N sa muyar ma ning hár ákaun rà? Aning zìg bi wùn-à hi áyág.” ");
INSERT INTO jib_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu yan ta wàu-à níng nài yán, sái wàu-à í zu bi rìg-à á dìr wùn-à ni. I nànn-à hi sái wùn-à í gbam rìg-à màhàn. ");
INSERT INTO jib_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","I byar-à hi, yann sukàwá big bònn yag mà byarwá ni n bib ku rag, “Bu-à sa yi kan zu sar fig wàu-à níng bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ku dinya káníng n rag, “Bu-à sa níng, ning bir wai fig pìkyinn ná bàna. Mì ri dinya ning í jír àjai. Wà na bir hing pìkyinn á byar Shìdun ni kó títi nímá àràg barà yìr masita shi sig títi nímá níng, na dang rag shinnkwìnn-à níng aku gbìb dù ma mìrwá aku yag màhàn bó, má yag. Wà na bir hing pìkyinn, ná sa kó kai bidìm pár.  ");
INSERT INTO jib_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iri swai wàu-à níng má zu fig átai bàna, sái ba sìnn hing nu ma vig hing Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sai-à big kwonn shi sig mà Galili, Yesu dinya big n rag, “Bá zìg Wùn Mpìr Jíkwìnn má ya kà á vù mpìrká ni, ");
INSERT INTO jib_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bá gban rìg ku, ama àyúnn wà wa sara, kwá dù nann zu kàng ma yonkiwá.” Barà yann sukàwá big fig àdòníng pìkyinnbá í bai rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Barà big bi fòr á Kafarnahum, sái malamká ri zìg bài jànn á lu Shìdun ni níng, big yag mà byar Bitrus n bib rag, “Shinn Luná ri wa bài jànn bu Lu Shìdun rà?” ");
INSERT INTO jib_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ku zìm n rag, nn, wàníng ri wa. Barà ku kàng bi á lu-à ni, sái Yesu bib ku rag, “Siman, à myàng ashinn rà? Mpìrká ri wa kùr bài jànn íni rà? I yann jànnká rà, kó í kyìnnká rà?” ");
INSERT INTO jib_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bitrus dang rag, “I kyìnnká.” I byar-à Yesu dinya ku rag, “To, kàhi yann jànnká má wa fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama yi zìm fig ayi sa bai mpìr káníng pìkyinn bàna. A yag mà níng-à ni, á ta zwann, á gbar zu jái-à ma pànn jag sig. Wá myàng bài á nuwá ni, wà zyun-à má màg bài jànnyí yi pyànà. A zìg á wa big í bài jànnyí.” ");
INSERT INTO jib_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nonn fig bàna, sái yann sukàká bu Yesu big bi n bib ku rag, “Ayauyí ni mpìr-à má shi àgbam mà fir kùr Shìdun ni í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sái ku bar wùn zyun títi nímá, n sìnn kà wàníng, a wàníng sar á pyànnbá ni. ");
INSERT INTO jib_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","I wà ku dang n rag, “Má dinya ning jír àjai. Wà na vim bìr fig ma kàng fig àràg ning í yann wùnshái big bàna, ná kà fig mà byar-à Shìdun ri na kùrwá bàna. ");
INSERT INTO jib_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mpìr-à ma sìnn kàng hing shinnwá àràg ku í wùnshái títi-à níng, ku í mpìr-à má shi àgbam mà byar-à Shìdun ri na kùrwá. ");
INSERT INTO jib_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mpìr-à ma pànn hing wùn zyun àràg wùnshái-à níng vù pyànà á jir shinnmí ni, shi sig àràg ku pànn síg mì. ");
INSERT INTO jib_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ama mpìr-à ma du kà hing wùnshái zyun áyau yann káníng ni, zyun-à bir sig pìkyinn á byarmí ni rag, a wàníng sa bu pyìr, má sàn kab ya mpìr-à níng hi abig zìg wann bu wau, abig dìnn gbam á wàinwá ni, abig ta kà wann ku á byinn aku wu rìg. ");
INSERT INTO jib_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sàn fig wà bu zyun shi sig áni, aku sìnn kà mpìr á bu pyìr bàna. Bu zyun má sìnn kà mpìr má sa bu pyìr, ama mpìr-à ma sìnn kà jàuwá a wàníng sa bu pyìr, kwá myàng àzing. ");
INSERT INTO jib_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Wà vùwú kó barwú ma ri sìnn kà wù rag á sa bu-à bibai, á gib tafinn rìg. Má sàn kab nì á kà á lu Shìdun ni mà wai ma bar àkìm kó vù àkìm, ma wà wá shi kwonn ma vù pyànà, kó bar pyànà bá ta kà wù á lu pyìr. ");
INSERT INTO jib_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wà zuwú ma ri sìnn kà wù rag á sa bu-à bibai, á kpab tafinn rìg. Má sàn kab nì á kà mà lu Shìdun ni ma zu ńzyun kwonn ma yonkiwú, ma wà wá kà mà lu pyìr ma zuwú pyànà. ");
INSERT INTO jib_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kada aning sa wùn zyun áyau yann káníng ni yawari bàna. Mì ri dinya ning yann aswam Shìdun big ká ri myàng kwonn ma yann káníng, big ri shi kyann á pyànn Shìdun ni mà wai.  ");
INSERT INTO jib_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wùn mpìr jíkwìnn bi sig jirà aku zìg zu mpìrká nang jànn sig. ");
INSERT INTO jib_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Wà mpìr zyun ma shi sig ma àdùn dìb-swana, zyun áyaubá ni ma jànn hing, kwá fim ká dà sig dìb-yina agban dwib agban zu áni ajinndúbi níng mà gàu shinnkwìnn-à ni jirà aku yag yàn dìg rìg ma zyun-à jànn sig níng ḿpyim. Kó í àdòníng bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wà kwa yàn dìg hing wàníng, kwá fig àjwár wàni. N dinya ning àjwár-à kwá fig á shinn zyun-à jànn sig níng má kab ká zyun-à jànn fig bàna níng. ");
INSERT INTO jib_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","I barà Taná mà wai má zìm fig áyau yann káníng ni, kó ńzyun aku jànn bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Wunzàwú zyun-à ma sa wu bu-à sàn fig bàna, á yag mà byarwá ni á dinya ku bu bibai-à ku sa sig. A yag dìg ku, ning ma ku pyànà. Kwa fig hing jírwú, to, à gbar kàng bi rìghing wunzàwú á byarwú ni. ");
INSERT INTO jib_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wà kwa rag, ku ngàng, á yag ma mpìr zyun kó mpìr pyànà, jirà a mpìrká fig jír káníng á nuná ni, ning sara. ");
INSERT INTO jib_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wà kwa ngàng wà kwá fig jír káníng, á dinya àgbamká iklisiya. Wà kwa ngàng hing jir mpìr iklisiyaká tìnn, á sìnn kàng rìg ku àràg í mpìr-à yì fig jir Shìdun bàna, kó àràg mpìr azìg bài jànn. ");
INSERT INTO jib_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mì ri dinya ning, bu-à na kìg sig á jànn-à ni, bá kìg mà wai tìnn. Bu-à na pù sig á jànn-à ni, bá pù mà wai tìnn. ");
INSERT INTO jib_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mì ri dinya swàb kà ning jír, wà na shi kwonn sig mpìr pyànà, pìkyinn ná ma yag hing ńzyun á shinn bu-à ning ri vig, Tamí mà wai má fig jírná, kwá sa ya ning bu-à ning ri vig níng hi. ");
INSERT INTO jib_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Byar-à mpìr pyànà kó sara ma shi kwonn sig á zìnnmí ni, ǹ shi kwonn sig ma big í zyun tìnn.” ");
INSERT INTO jib_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","I byar-à Bitrus sar bi sim, n bib rag, “Shinn Lumí, mpìr-à ma ri sa kyann mì bu-à bibai, ń yafa ya ku kàun píná rà? N yafa ya ku hár kàun sùmpyànn rà?” ");
INSERT INTO jib_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu dinya ku n rag, “I kàun sùmpyànn í nànn-à hi bàna, kó dìb-sara agban dwib hár byar sùmpyànn má sàn hing, ");
INSERT INTO jib_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","jir kai bàna byar-à Shìdun ri na kùrwá shi sig àràg kùr zyun ri zìm aku wànn byann bàiwá ma yann sukàwá big. ");
INSERT INTO jib_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Barà ku ri wànn byann bài-à àdòníng, sái wunù zyun-à ku ri bàg wàníng tonn bài àràg dubu dwib, big pànn zìg bi sig wunù-à hi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Barà wunù-à níng bàna ma bài-à kwá wa kàng àsàin luwá, sái àsàin luwá dang rag, abig wann tafinn rìg ku ma wàwá ma yanká buwá big, ma buká ku shi sig ma kàhi, abig wa zu ku áni. ");
INSERT INTO jib_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","I byar-à fàu-à níng bìnn kir wann á jìnn ni, n dang rag, ‘Shinn Lumí, á sa muyar, má wa kàng vinn rìg wù bài-à níng bidìm pár.’ ");
INSERT INTO jib_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Barà fàu-à níng dang àdòníng, sai shinn luwá myàng ashiwá n fim ya rìg ku tonn bài-à hi, aku yag. ");
INSERT INTO jib_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ama fàu-à níng zu yag mà myann, n yag dìg kwonn ma fàu zyun-à ku ri bàg wàníng tonn bài sule dìb-swana níng, n yag mòr pànn gbam wàníng á wàin-à ni n dang rag, a wàníng wa kàng ku bàiwá. ");
INSERT INTO jib_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fàu-à ku ri bàg wàníng bài-à níng bìnn kir wann á jìnn ni n dang rag, ‘A sa muyar, má wa kàng vinn rìg wù bài-à níng bidìm pár.’ ");
INSERT INTO jib_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sái mpìr-à níng ngàng rìg, n zìg yag rìg jàuwá níng n kig kà wàníng á tonn fi, jirà a wàníng wa ku bàiwá. ");
INSERT INTO jib_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ayau fàuká shi sig ma ku níng, big myàng bar bu-à ku sa sig níng, sái pìkyinnbá í bai rìg-à. Big kàng yag n yag dinya shinn lubá bar jír káníng. ");
INSERT INTO jib_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","I byar-à hi shinn lubá bar bi ku, n dinya ku n rag, ‘Wù í wùn sukà-à bibai, jír kai bàna ǹ fim ya vinn rìghing wù bài-à mì ri bàg wù dò jir barà à vig sig mì níng. ");
INSERT INTO jib_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wá myàng fig ashi jàuwú zyun àràg barà ǹ myàng sig ashiwú níng bàna rà?’ ");
INSERT INTO jib_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I byar-à shinn luwá dù rìg kyinn, n ya kà ku á vù mpìrká ri ya mpìr shwìn àjirà aku wa kàng vinn rìg bài-à níng. ");
INSERT INTO jib_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Wàníng í barà Tamí mà wai má sa ma ning áni, wà na yafa ya fig jàuná big ma kyinn ńzyun bàna.” ");
INSERT INTO jib_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Barà Yesu dang vinn rìg jírwá àdòníng, ku dù á Galili n yag mà jànn Yahudiya, n pìm zu á Ning Urdun. ");
INSERT INTO jib_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bìr mpìrká nìnànn nímá bàg yag ku màhàn, ku ri dàb gbam káníng. ");
INSERT INTO jib_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","I byar-à hi Farisawaká káhi dìg ku màhàn, big ri màg màg fig ku, big dang rag, “A dokayí ni sàn hing wà mpìr aku ya wàwá tarkada ma aku kan tafinn wàwá àràg barà kyinnwá ri zìm rà?” ");
INSERT INTO jib_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu bib big rag, “Ning jangga fig bu-à jir Shìdun dang sig bàna rà? Jir Shìdun dang sig rag, sai-à Shìdun màm jag mpìr, ku màm jag sig wunù ma uwà, ");
INSERT INTO jib_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ku dang rag, ‘Jir wàníng, í bu-à sa mpìr má dù dà fim nàwá ma tawá, má yag shi kwonn ma wàwá, jirà abig shi í bu ńzyun.’ ");
INSERT INTO jib_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hár á pyànná-à níng bá shi fig rag pyànà bàna. Bá shi í bu ńzyun. Bu-à Shìdun sìnn kwonn sig, kada mpìr aku gàfinn bàna.” ");
INSERT INTO jib_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","I byar-à hi Farisawaká bib ku n rag, “Sáshinn doka Musa dang rag, ‘Mpìr aku ya wàwá tarkada ban gban ma aku kan rìg wàwá níng’ fà?” ");
INSERT INTO jib_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I byar-à Yesu zìm n dinya big rag, “Bu-à sa Musa dang rag, aning ya wàná tarkada ban gban níng, í jirà ning shi sig ma sung gbam. Ama bu káníng shi fig àdòníng ásai-à big màm jag sig jànn á jìnn ni bàna ba. ");
INSERT INTO jib_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mì ri dinya ning, mpìr-à ma ya hing wàwá tarkada, ma kan tafinn hing wàwá, wà wàwá hi ma sa fíg àyái bàna, mpìr-à níng ma zìg kàng hing uwà zyun kim, ku ri sa àyái.” ");
INSERT INTO jib_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","I byar-à hi yann sukàwá big dinya ku n rag, “Wà jir uwà ma nùwá ma shi sig àdòníng, má sàn kab nì mpìr aku zìg uwà bàna.” ");
INSERT INTO jib_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu dinya big n rag, “Walai mpìr-à má zìm jír-à ning ri dang níng, sai kó mpìr-à Shìdun ma ya sig ku gbam barà kwá shi àdòníng. ");
INSERT INTO jib_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mpìrká káhi tun sai-à big mà sig big, big bàna ma dìr, mpìrká káhi bó í mpìr sa síg big í nì big bàna ma dìr, mpìrká káhi shi àràg big bàna ma dìr jirà abig sa swàm Shìdun ǹsàn nímá. Mpìr-à má shi yì shu átai má zìg fig uwà bàna, to aku shi.” ");
INSERT INTO jib_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mpìrká káhi ya bi Yesu yanká títi, aku tib káníng vù á dìr, ma aku vig ya káníng Shìdun. Ama yann sukàwá big yan ta mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu dang rag, “Aning fim yann títi káníng abig bi á byarmí ni, kada aning kan dim big bàna, jir kai bàna írì swai yanká àdòníng, bá kà nì mà byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","I byar-à hi ku bi tib yann káníng vù á dìr-à ni, mì yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ayúnn zyun wunù zyun bi á byar Yesu ni n dang rag, “Malam, bu-à sìsàn má sa jirà ń dìg yonki kinn kinn í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I wà Yesu dinya ku rag, “Bu-à sa à bib mì jír àdòníng á shinn bu-à sìsàn í jir kai rà? Mpìr ńzyun í mpìr-à ǹsàn í Shìdun. Wà wa ri zìm á dìg yonki kinn kinn á wib jir Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","I byar-à hi ku dinya Yesu n rag, “Má wib í kai ma kai rà?” I wà Yesu dinya ku n rag, “Kada á gban ki bàna, kada á sa àyái bàna, kada á jwi ajwú bàna, kada á gim ǹsáng á shinn mpìr bàna, ");
INSERT INTO jib_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","á wib tawú ma nàwú, ma á zìm jàuwú àràg barà wù ri zìm shinnwú tìnn.” ");
INSERT INTO jib_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","I wà wùn wunù-à níng dinya ku n rag, ai bu káníng bidìm pár ku sa vinn rìghing, bu-à dà sig aku sa í kai rà? ");
INSERT INTO jib_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu dinya ku n rag, “Wà wa ri zìm á wib vinn rìg jir Shìdun bidìm pár, á yag wann tafinn vinn rìg buká à shi sig ma kàhi bidìm pár, á zìg bài-à á ya mpìr ashiká, jirà wá dìg bu-à sàn kab wàníng mà wai, ma á bi bàg mì.” ");
INSERT INTO jib_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Barà wunù-à níng fig jír-à níng, ku í yag rìg-à, pìkyinnwá bai rìghing, jir kai bàna ku shi sig big bu wàni. ");
INSERT INTO jib_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","I byar-à Yesu dinya yann sukàwá big n rag, “Mì ri dinya ning í jír àjai, shi sig ma shwìn wà mpìr bài má kà á lu Shìdun ni mà wai. ");
INSERT INTO jib_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","N dinya swàb kà ya ning jír zyun, tù hing wàni wà mpìr bài aku kà á lu Shìdun, má fonn kab wà rakumi aku kà á pùr àbònyir, ma wà mpìr bài aku kà á byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Barà yann sukàwá big fig àdòníng, sái mamaki pànn rìg big. Big bib ku n rag, “Kai! Mpìr-à má wìm zu í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu myàng yag big n dang rag, “Bu-à mpìr má sa sar fig bàna, Shìdun má sa sar, jir kai bàna walai bu-à má nì kan Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","I byar-à Bitrus dang rag, “To, tàma-à níng yi fim rìghing buká buyí bidìm pár jirà ayi bàg wù, yá dìg í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu dinya big n rag, “Mì ri dinya ning í jír àjai, àyúnn-à wùn mpìr jíkwìnn má na kùr ma gbam mà wai, ásai-à níng hi ning yann sukà dwib agban pyànà káníng, ning má, ná shi ma gbam, ná na kùr á shinn swai mpìr dwib agban pyànà ká á jànn Israila. ");
INSERT INTO jib_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mpìr-à ma fim luwá, kó kwa fim shunwòwá, kó wunzàwá, kó ajunwàwá, kó tawá, kó nàwá, kó yanká buwá, kó dawá, á dò jir shinnmí ni, kwá dìg bu-à kab bu káníng kàun dìb-swana, kwá dìg yonki kinn kinn tìnn. ");
INSERT INTO jib_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mpìrká nìnànn nímá ká shi sig mpìr ùwài tàma-à níng, bá kàng mà sim. Mpìrká kinn fig bu bàna níng, má yag mà pyànn. ");
INSERT INTO jib_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Byar-à Shìdun ri na kùrwá mà wai shi sig àràg í àsàin lu zyun-à, zu yag sig í pyimbyau yìì nímá mà myann jirà aku yag yàn mpìrká má sa ya ku swàm á dawá ni. ");
INSERT INTO jib_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ku ma káníng dang byann sig, su zyun kwá ya káníng bài pam zyun. I byar-à hi, ku tìr yag káníng mà da-à ni. ");
INSERT INTO jib_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sái ku zu yag mà kasuwa-à ni àsháu ajinndúbi, ku yag dìg kàng mpìrká shi sig màhàn, big ri sa fig swàm bàna, big shi sig átai. ");
INSERT INTO jib_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I byar-à hi, ku dinya mpìr káníng n rag, abig yag mà dawá ni, kwá wa káníng bài bar swàm-à káníng ma sa sig bidìm pár. I byar-à hi, big í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ku yag jakàng àyúnn áyau shinn, n bar bi mpìrká kádà, àsháu sara àkamzau ku yag jakàng n yag bar bi jakàng mpìrká kádà. ");
INSERT INTO jib_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ku yag jakàng mà kasuwa ni àràg àsháu swana, n dìg mpìrká sar sig. Sái ku dinya káníng n rag, ‘Bu-à sa ning ri shi átai, mi ri sa fig swàm bàna í jir kai rà?’ ");
INSERT INTO jib_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Big dinya ku n rag, mpìr zìg fig big swàm bàna. I wà ku dang rag, to a káníng yag sa ya ku swàm mà dawá ni. ");
INSERT INTO jib_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Barà àkamzau-à màg níng, sái àsàin da-à bar mpìr-à ku du kà sig a wàníng shi shinn mpìrká ri sa ya ku swàm-à níng, a wàníng bar kwonn mpìrká jirà a wàníng wa big bài swàmbá, a wàníng wa jag ma mpìrká bi sig ásim níng ḿpyim, í wà a wàníng wa mpìrká bi jag sig níng íni. ");
INSERT INTO jib_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mpìrká zyun-à bi sig ásim níng big bidìm pár big dìg pam zyun zyun. ");
INSERT INTO jib_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mpìrká nìm kà jag sig swàm-à níng bi fòr, big ri kyab rag kó bá wa big bài-à má kab bu ká bi sig ásim níng. Sái big má, big ya big pam ńzyun ńzyun tìnn. ");
INSERT INTO jib_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Barà big zìg bài-à àdòníng, sái big kà hing jír yàng dang, pìkyinnbá bai rìghing ma àsàin da-à. ");
INSERT INTO jib_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","I wà big dinya ku n rag, ‘Mpìrká bi ásim níng sa fòr fig swàmyí bàna, ama à wa màg yi bài-à ábibir ma big. Yi zyun-à yi nìm zu sig tundaka í pyimbyau, hár àyúnn-à kà, àyúnn fàn yi fànfàn.’ ");
INSERT INTO jib_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","I byar-à àsàin da-à dinya mpìr zyun áyaubá ni n rag, ‘Awàn, ái ǹ lir ji fig wù bàna, yi ma wù dang byann rìghing jir bài-à ḿpyim, ǹ dang rag swàm su zyun pam zyun. ");
INSERT INTO jib_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","A zìg bàiwú tàma-à níng á yag mà luwú ni, má wa mpìrká bi sig ásim níng àràg barà ǹ wa sig wù níng. ");
INSERT INTO jib_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Asái ǹ bàna ma gbam á shinn buká ǹ shi sig ma kàhi rà? Kó wù ri nànn àgùnn buká mì ri sa níng rà?’ ” ");
INSERT INTO jib_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","I byar-à Yesu dang vinn rìg jírwá n rag, “Mpìrká kà sig á pyànn níng, í ká má kàng ásim, ká ásim níng í ká má yag mà pyànn.” ");
INSERT INTO jib_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ri yag mà Urushalima, ku zìg kwonn sig ma yann sukàwá big dwib agban pyànà káníng í zyun. Barà big ri yag á gbìb-à ni, sái ku bar kann káníng agang, n bònn dinya káníng jír n rag, ");
INSERT INTO jib_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yi ri yag mà Urushalima, mà byar-à bá zìg Wùn Mpìr Jíkwìnn má ya kà ku á vù àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma malamká. Bá wà ku kwonn, má dang rag abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bá zìg ku má ya kà ku á vù mpìrká ká í Yahudawaká bàna. Bá màm jwann ku, bá yang ku ashor, bá dab bàg gbam ku atàm bín. Ayúnn su sara kwá dù nann zu kàng ma awunwá.” ");
INSERT INTO jib_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","I byar-à hi wà Zabadi ma yanká buwá bi á byar Yesu ni, ku bìnn kir wann n vig wàníng bu. ");
INSERT INTO jib_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sái Yesu bib ku rag, ku ri zìm í kai rà? Ku dinya wàníng rag, “Mì ri zìm yanká bumí big pyànà níng, zyun aku shi á agunn vìm nuwú ni, zyun aku shi á agunn vìm súrwú ni, á sai-à wá na kùrwú.” ");
INSERT INTO jib_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu dinya big n rag, “Ning yì fig bu-à ning ri vig mì bàna. Wàníng ná wa sar shwìn-à má wa níng rà?” Big dang rag, nn, bá wa sar. ");
INSERT INTO jib_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I byar-à hi, ku dinya káníng n rag, “Shwìn-à má wa níng, í wà zyun-à ná wa. Ama byar shu agunn vìm numí ma agunn vìm súrmí, í bigmí bàna, ǹ bàna ma gbam-à má ya mpìr kàhi. I byar shu mpìrká Tamí sa sìnn ya sig big.” ");
INSERT INTO jib_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Barà yann sukà dwib kádà sig níng fig bu-à jàubá pyànà káníng vig sig Yesu níng, big nànn káníng àgùnn. ");
INSERT INTO jib_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","I byar-à Yesu bar kwonn bi big í byar ńzyun, n dang rag, “Ning yì hing kùrká á jànn-à ni ri tàg gbam á shinn mpìrká bigbá ni. Big ri twìm káníng, mi ri dinya káníng bu-à káníng má sa. ");
INSERT INTO jib_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama bigná má shi fig àdòníng áyauná ni bàna, wà mpìr zyun áyauná ni ma ri zìm aku shi àgbam, to, aku shí nì fàuná. ");
INSERT INTO jib_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mpìr-à ma ri zìm aku shí nì wà jijag, to, aku shí nì fàuná, ");
INSERT INTO jib_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","àràg barà Wùn Mpìr Jíkwìnn bi fíg jirà abig sa ya ku bu bàna, ama jirà aku sa ya mpìrká bu, aku ya shinnwá jirà mpìrká abig dìg yonki.” ");
INSERT INTO jib_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","I byar-à Yesu ma yann sukàwá big dù á Yariko mi ri yag, sái bìr mpìrká nìnànn nímá ri bàg yag big ásim. ");
INSERT INTO jib_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mpìr àfau pyànà big shi sig á kur gbìb-à ni. Barà big fig í Yesu ri wam zu yág nì, í byar-à hi big gbam nài gbam n rag, “Shinn Luyí á myàng ashiyí, wù Wùn Dawuda!” ");
INSERT INTO jib_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","I byar-à hi, bìr mpìr káníng kan dim big n rag, abig pànn shi rìg akim abig wa nài yán bàna. Ama big pànn shi fig bàna, n wa swàb kà nài yán ma gbam n dang rag, “Ayáa Shinn Luyí Wùn Dawuda, á myàng ashiyí.” ");
INSERT INTO jib_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","I byar-à Yesu sar wann n bib big n rag, “Ning ri zìm ń sa ya ning í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Big dinya ku n rag, “Shinn Luyí, yi ri zìm á sa yi ayi myàng ma zuyí.” ");
INSERT INTO jib_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","I byar-à Yesu myàng ashibá, n tib big vù á zu-à ni, á byar-à hi sái big í myàng rìg-à ma zubá, n kan bàg ku. ");
INSERT INTO jib_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Barà big nyàan fòr á Urushalima, n yag mà Baitafaji, á byar zyun big ri bar Wùn Mwir Zaitun, í byar-à hi Yesu swam yag yann sukàwá big pyànà, abig yag bab. ");
INSERT INTO jib_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ku dinya big n rag, “Aning yag mà kauye-à mà pyànn ná ni níng. Na kà yag hing ná dìg big sa gbam sig aswannswánn màhàn, na-à ma wùn-à, aning fìnn ya bi mì. ");
INSERT INTO jib_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mpìr-à ma bib hing ning, aning dang rag, ‘I Shinn Luyí dang síg nì rag, ayi fìnn ya bi ku, kwá tìr kàng bi rìg kíni.’ ” ");
INSERT INTO jib_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wàníng sa sig àdòníng jirà bu-à wùn aswam Shìdun rì dang sig níng aku shi àràg barà ku rì dang sig. Ku dang rag, ");
INSERT INTO jib_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Aning dinya mpìrká á Siyona, kùrná ri bi zyun-à má myàng ashiná. Ku nann shi sig á shinn wùn aswannswánn zyun ni.” ");
INSERT INTO jib_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","I byar-à hi, yann sukà Yesu big wib jir Yesu, mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Big yag zìg bi aswannswánn-à hi, na-à ma wùn-à, n wan zu jàbá, n bir wann á kwíb-à ni. I wà Yesu nann zu n shi wann á shinn aswannswánn-à hi ni. ");
INSERT INTO jib_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mpìrká nìnànn nímá shi sig màhàn. Big zìg jàbá n jag wann á gbìb-à ni. Mpìrká káhi kyag sig jì bu, mi ri jag yag á gbìb-à ni tìnn. ");
INSERT INTO jib_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sái bìr mpìrká káhi ri yag mà pyànnwá ni, káhi bó ásimwá ni. Bìr mpìrká nìnànn nímá ri swam yan ku, big dang rag, “Pyib sìsàn aku shi á shinnwú ni, wù Wùn Dawuda. Pyib sìsàn aku shi á shinn mpìr-à ri bi á zìnn Shinn Luyí ni níng, Shìdun í zyun-à mpìrká má swam yan.” ");
INSERT INTO jib_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Barà ku ri kà yag mà finn swann Urushalima àdòníng, sái mpìrká á finn swann-à ni ri sa yàg yàg yàg. Mpìrká ri dang jír kim kim, big dang rag, “Wàníng í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","I wà mpìrká dang rag, “Ai wàníng í mpìr-à ri dang kyann jir Shìdun, zìnnwá í Yesu mpìr Nazarat, ku í mpìr-à á jànn Galili.” ");
INSERT INTO jib_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kà yag mà lu Shìdun ni n kan zu rìg mpìrká ri wann tafinn bu màhàn, ma ká ri wann bu màhàn. Ku gbar ta wann rìg teburká mpìrká ri pyann bài áni níng, ma kujeraká bu mpìrká ri wann tafinn àlàb lu. ");
INSERT INTO jib_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ku dinya big n rag, “Big ba sìnn sig jír-à Shìdun dang sig rag, ‘Lumí, mpìrká ma bar rag í byar-à big ri vig Shìdun,’ ama ning sìnn kàng rìghing í byar ajwú jwi.” ");
INSERT INTO jib_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sái àfauká ma mpìrká ri gbìb títing níng, bi á byarwá ni á lu Shìdun. I wà ku dàb gbam rìg káníng. ");
INSERT INTO jib_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Barà yanká ri swam yan Yesu n rag, “Bu-à ǹsàn aku shi á shinnwú ni, wù Wùn Dawuda.” Barà àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma malamká myàng bu mamaki-à Yesu sa sig, n fig jír-à yanká ri swam yan ku níng, sái big nànn rìg àgùnn. ");
INSERT INTO jib_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Big dinya ku n rag, “Wù ri fig bu-à yann káníng ri dang rà?” I wà Yesu dinya big n rag, “Mì ri fig. Ning myàng fig bu-à big ba sìnn sig níng bàna rà? Big ba sìnn sig n rag, ‘Shìdun sìnn kà yanká abig swam yan ku.’ Ning jangga fig bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","I byar-à hi ku fim rìg káníng, ku í zu yag rìg-à mà finn swann-à ni, mi í ya rìg-à mà Baitanya, n tìg màhàn. ");
INSERT INTO jib_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na kyàr byar-à ku ri kàng yag mà finn swann-à ni, sái amor gban ku. ");
INSERT INTO jib_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Barà ku myàng yag mìr bin ating zyun sar sig á nu gbìb-à ni, ku yag màhàn, ku dìg fig awan áni bàna, sái íri jì. I byar-à hi, ku dinya bin ating-à níng, n rag, “Wá wan fig rag awan bàna, hár kinn kinn.” I byar-à hi bin ating-à hi í wim rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Barà yann sukàwá big myàng àdòníng, sái mamaki sa rìg big. Big dang rag, “A, hár bin ating-à níng wim rìghing kíni àdòníng rà?” ");
INSERT INTO jib_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","I wà Yesu dinya big, n rag, “Mì ri dinya ning jír àjai, wà na bir hing pìkyinn ná á byar Shìdun ni ma kyab fig kyinn pyànà bàna, bu-à ná sa má kab bu ating-à níng, kó na dang rag, shinnkwìnn-à níng aku gbìb dù ma mìrwá, aku yag jann kà shinnwá á zàpìr-à ni, má wib ning, má gbìb dù rìg má yag jann kà rìg shinnwá. ");
INSERT INTO jib_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kó kai na vig hing Shìdun, wà na bir hing pìkyinn ná á byar Shìdun ni, ná dìg.” ");
INSERT INTO jib_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Barà ku kà yag mà lu Shìdun ni mi ri tàg mpìrká bu, sái àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma àgbam mpìrká kádà bi á byarwá ni. Big dang rag aku dinya big, ku dìg sig gbam-à ku ri sa bu káníng ma kàhi níng áni rà? I ni ya síg ku nì rà? ");
INSERT INTO jib_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","I byar-à Yesu dinya big n rag, “Má bib ning jír zyun, wà na dinya hing mì, í wà má dinya ning mpìr-à ya sig mì gbam-à mì ri sa bu káníng ma kàhi. ");
INSERT INTO jib_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mpìr-à ya sig Yohanna gbam-à aku wau mpìrká dìr batisma í ni rà? I Shìdun rà, kó í mpìr rà? Aning dinya mì.” I byar-à hi àgbamká wà jír ma bar dìrbá n rag, “Wà ya dang rag, í Shìdun ya sig Yohanna gbam-à íni, kwá dang rag, bu-à sa yi bir fig pìkyinn á jir Yohanna ni bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wà ya dang rag, í mpìr ya sig Yohanna gbam-à íni, yi ri shàr bìr mpìr káníng, jir kai bàna big yì rìghing wà Yohanna í mpìr-à ri dang kyann jir Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","I byar-à big dinya Yesu n rag, “Yi yì fig bàna.” I byar-à hi ku dinya káníng n rag, “Mì má, má dinya fig ning mpìr-à ya sig mì gbam-à mì ri sa bu káníng ma kàhi níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mpìr zyun shi sig áni ku mà sig yann pyànà. Ku yag mà byar wùnwá zyun-à àgbam-à, n rag, a wàníng yag sa swàm mà da. ");
INSERT INTO jib_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wùn-à hi dinya tawá n rag ku ngàng. Ama ásim, ku bi zìm, mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","I byar-à mpìr-à níng vim bìr n yag mà byar wùnwá zyun ni, n dinya wàníng rag, a wàníng yag mà da-à ni. Wùnwá zyun-à níng hi zìm, n dang rag kwá yag, ama n bi ngàng rìg, n yag fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","To, bigná ning myàng áshinn, áyau yann pyànà káníng ni, mpìr-à sa sig bu-à tawá ri zìm í ni rà?” Sái mpìrká dang rag, “I wùnwá wà àgbam-à.” I byar-à Yesu dinya big yìr jír n rag, “N dinya ning jír àjai, mpìr azìg bài jànn káníng, ma uwà àyái káníng ma kà jág ning nì á byar-à Shìdun má na kùrwá. ");
INSERT INTO jib_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aning myàng, Yohanna bi aku dinya ning gbìb-à ná bàg. Ning ngàng n bir fig pìkyinn ná á byarwá ni bàna. Ama mpìrká ri zìg bài jànnká, ma uwà àyáiká bir hing pìkyinnbá á byarwá ni, ama bigná kó barà ning myàng big bir sig pìkyinnbá níng, ning ngàng wà ná fim bu pyìr sa, má bir pìkyinn á byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu dinya big n rag, “Aning fig jakàng tinn jír zyun-à níng. Mpìr zyun nàm sig da inabi, n pì kàng kwìb sig da-à hi áni, n kànn sig kàb byar-à bá shi kan bu, n kab sig shar jirà abig pinn wìr kà zàn inabi áni. Ku zìg da-à hi, n pag alaru. Ku dù n yag rìg mà jànn zyun ni. ");
INSERT INTO jib_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ayúnn-à bá binn kìnn kwonn awan inabi-à níng sa, sái mpìr-à níng swam yag fàuwá mà byar anàm bu káníng ni abig ya ku anìwá. ");
INSERT INTO jib_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Anàm bu káníng pànn fàuká buwá n dab zyun dab dab, n gban rìg zyun, n ta zyun abàn ta ta. ");
INSERT INTO jib_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hár tàma-à níng ku swam yag jakàng fàuwá big, ká kab wàrì. I barà big ri sa káníng akyib, mi ri dab big. ");
INSERT INTO jib_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","I nànn-à hi, ku swam yag wùnwá á byar káníng ni n dang rag, bá wib wùnwá níng. ");
INSERT INTO jib_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Barà anàm bu káníng myàng wùn àsàin da-à ri bi, big dang n rag, ‘To, wàníng í àsàin-à má ji gado da-à níng, ayi gban rìg ku, jirà ayi pànn nì da-à níng.’ ");
INSERT INTO jib_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","I byar-à hi, big pànn ku n vinn ta zu yag rìg ku mà myann n gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Wà àsàin da-à níng ma kàng bi hing, kwá sa mpìr anàm bu káníng í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mpìrká dinya ku n rag, “Asàin da-à níng má gban rìg mpìr káníng bidìm pár. Kwá ya rìg da-à á vù mpìrká káhi kim abig nàm, jirà àyúnn-à ba binn hing buju-à bá ya ku anìwá.” ");
INSERT INTO jib_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu dinya big n rag, “Ning taba jangga fig bu-à jir Shìdun dang sig bàna rà? ‘Abàn-à mpìr ami buká ngàng sig rag bai níng, í zyun-à big zìg kàng bi, n mi kà ágù kinn-à ni, í wà zyun-à sàn kab sig kádà. Wàníng í Shìdun sa síg nì. A byaryí ni, yi ri myàng í bu mamaki.’ ” ");
INSERT INTO jib_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu dang swàb kà jírwá n rag, “Bá zìg rìg byar-à Shìdun ri na kùrwá á byarná ni, bá ya mpìrká ma ri wan awan sìsàn. ");
INSERT INTO jib_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mpìr-à ma kù hing á shinn abàn-à níng ni, kwá kìm, ama mpìr-à abàn-à níng ma ku hing á dìrwá ni, má wau nam rìg ku murrr.” ");
INSERT INTO jib_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Barà àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma Farisawaká fig yìr jír-à níng, big yì rìghing Yesu ri dang ma big. ");
INSERT INTO jib_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sái big yàn pyù-à abig pànn sìr Yesu, ama zinn pànn rìg big, jir kai bàna bìr-à nànn kab gbam. Mpìrká yì rìghing wà Yesu í mpìr-à ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu dinya kàng big tinn jír zyun n rag, ");
INSERT INTO jib_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Byar-à Shìdun ri na kùrwá shi sig àràg barà kùr zyun ri sa buki ban wùnwá. ");
INSERT INTO jib_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ku dinya mpìrká nìnànn nímá abig bi ji buju ban wùnwá. Barà big sa kinn buju-à níng, ku dinya fàuwá big n rag, abig yag bar bi mpìrká. Ama mpìrká ngàng wà bá bi. ");
INSERT INTO jib_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ku swam yag jakàng fàuwá big abig yag dinya mpìrká ku dwim bar sig níng, ku sa byann rìghing buju-à. Big gib gban sig naiká kùkwònn nímá. Big sa kinn rìghing buká bidìm pár, abig bi bùkí-à. ");
INSERT INTO jib_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama mpìrká big dwim bar sig níng, walai mpìr-à bir pìkyinn á jír-à hi ni, big yag rìg kyonnbá, kádà í yag rìg-à mà dabá ni, kádà yag rìg mà byar swàmbá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mpìrká dà níng pànn gbam fàu káníng, n dab big dab dab, n dab gban rìg big. ");
INSERT INTO jib_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","I byar-à hi pìkyinn kùr-à bai, ku swam yag sojawá big, big yag ta gban rìg mpìrká gban sig ki-à níng, n du swànn rìg finn swann mpìr káníng bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kùr-à níng dinya fàuwá big n rag, ‘Big sa kinn rìghing buju bùkí-à, ama mpìrká ǹ dwim bar sig, big ngàng níng, big fòr fig wà bá bi bàna. ");
INSERT INTO jib_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","To, ma àdòníng, aning yag mà finn swann-à ni, mpìrká na dìg màhàn bidìm pár, aning bar bi big, abig bi bùkí-à níng.’ ");
INSERT INTO jib_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","I byar-à hi fàu káníng bàg nu gbìbká n bar kwonn bi mpìrká ba dìg á gbìb-à ni bidìm pár, mpìr bibaiká ma mpìr sìsànká tìnn. Har byar bùkí-à mònn rìg. ");
INSERT INTO jib_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“I byar-à kùr-à yag mà byar-à kyìnnká shi sig, ku yag myàng mpìr zyun màhàn wìr fig buwá jà ban-à bàna. ");
INSERT INTO jib_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ku bib wàníng n rag, ‘Ayor! A sa sig áshinn n kà síg nì áyág, barà à wìr fig jà ban-à bàna níng rà?’ Mpìr-à níng pù fig nuwá bàna. ");
INSERT INTO jib_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","I byar-à hi, kùr-à dinya fàuwá big n rag, abig sìr rìg wunù-à wìr fig jà ban-à bàna níng, vùwá ma barwá, abig ta zu yag ku mà myann ma fi-à ni, í byar-à kwá kig má zwàm pòr anamwá màhàn.” ");
INSERT INTO jib_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sái Yesu dang n rag, “To, mpìrká nìnànn nímá big ri bar big, ama mpìrká bá shig zu í títi nímá.” ");
INSERT INTO jib_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","I byar-à Farisawaká kwonn nubá, big ri zìm abig tib fig nu Yesu. ");
INSERT INTO jib_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sái big swam yag yann sukà big, ma mpìr kùr Hirudus, big dang n rag, “Malam, ái yi yì hing wù í mpìr gwangga, jir kai bàna wù ri tàg jir Shìdun á gbìb ǹsàn. Wù ri shig fig mpìr bàna, jir kai bàna kó ni wù ri myàng í bu ńzyun á byarwú ni. ");
INSERT INTO jib_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To, á dinya yi bu-à à myàng sàn sig. Sàn hing wà ayi wa kùr Kaisar bài jànn rà, kó sàn fig bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu yì rìghing big ri tib fig nuwá. I wà ku dinya káníng n rag, “Ning í mpìr bibai big. Bu-à sa ning ri tib fig numí níng, í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aning tìya mì bài-à ning ri wa bài jànn-à hi áni.” I byar-à hi big ya ku bài àsháu zyun. ");
INSERT INTO jib_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I wà ku bib big n rag, “Ma hoto mpìr-à á dìr bài-à hi ni ma zìnn-à áni níng, í bu ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Big dang n rag, “I bu kùr Kaisar.” I wà ku dinya big n rag, “To, bu-à ma í bu kùr Kaisar, aning ya kàng kùr Kaisar. Bu-à ma í bu Shìdun, aning ya kàng Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Barà big fig jir Yesu, sái mamaki pànn rìg big. I nànn-à hi big gàb rìg dìr ma ku, n bib fig rag ku jír zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ayúnn-à níng hi, Sadukiyawaká zyun-à dang rag, mpìr ma wu hing, má dù nann zu kàng fig ma yonki bàna níng, bi á byar Yesu ni, n bib ku jír, ");
INSERT INTO jib_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","n rag, “Malam, Musa dang rag, ‘Mpìr ma wu tafinn sig wàwá, ku ma wàníng ma mà fig wùn bàna, a wunzàwá zìg kàng uwà-à níng jirà aku mà ya shunwàuwá yann.’ ");
INSERT INTO jib_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tàma-à níng yi shi sig ma jír á shinn mpìr zyun, ku shi sig ma wunzàwá big sùnnjin. Mpìr-à níng hi zìg uwà, ku ma wàníng mà fig wùn bàna, ku wu rìghing. ");
INSERT INTO jib_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wà wa pyànà zìg kàng uwà-à hi, ku ma wàníng mà fig wùn bàna. Ku má, ku wu rìghing tìnn, wà wa sara níng má àdòníng tìnn. Big sùmpyànn bidìm pár big zìg yà rìg uwà-à níng, big mà fig wùn bàna. ");
INSERT INTO jib_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Barà big zìg yà rìg uwà-à níng, sái uwà-à hi, í wu rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To, tàma-à níng barà mpìr káníng zìg yà zu vinn rìghing uwà-à níng, to, àyúnn-à ba dù nann zu kàng hing ma yonki, uwà-à níng hi má shi í bu ni áyaubá ni rà?” ");
INSERT INTO jib_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","I byar-à Yesu dinya big n rag, “Ning yì fig gbam Shìdun ma bu-à big ba sig á jir Shìdun ni bàna, wàníng í bu-à sa ning nang jànn sig gbìb gwangga níng. ");
INSERT INTO jib_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ayúnn-à Shìdun má gbar dù kàng hing mpìr ma yonki, mpìrká má zìg fig rag uwà bàna, jir kai bàna mpìrká má shi àràg í yann aswamká Shìdun mà wai. ");
INSERT INTO jib_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jír wà ki má dù nann zu kàng ma yonki níng, ning jangga fig bu-à Shìdun dinya sig ning níng bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ku dang sig rag, ‘Mì í Shìdun bu Ibrahim, mì í Shìdun bu Ishaku, mì í Shìdun bu Yakubu.’ Jír-à níng ri tàg yi rag, mpìrká rì wu sig níng, shi sig ma yonki tàma-à níng. Shìdun í Shìdun ki bàna, ku í Shìdun mpìr-à ma yonki.” ");
INSERT INTO jib_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Barà mpìrká fig bu-à ku tàg sig níng, sái mamaki pànn rìg big. ");
INSERT INTO jib_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Barà Farisawaká myàng ku dang tir rìghing Sadukiyawaká ma jír, sái Farisawaká bi í byar ńzyun. ");
INSERT INTO jib_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zyun áyaubá ni í malam ri tàg bu á shinn tarkada Musa, ku ri zìm aku màg màg fig Yesu. ");
INSERT INTO jib_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ku rag, “Malam, doka zyun-à wài kab kádà, í wà áni rà?” ");
INSERT INTO jib_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu dinya ku rag, “A zìm Shinn Luwú Shìdun ma pìkyinn ńzyun, ma yonkiwú, ma bu-à wù ri kyab á kyinnwú ni. ");
INSERT INTO jib_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wàníng í doka-à wà jijag zyun-à wài kab sig kádà. ");
INSERT INTO jib_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Doka-à tib sig wàníng, á zìm jàuwú àràg barà wù ri zìm shinnwú. ");
INSERT INTO jib_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Doka-à Musa ba sig, ma bu-à mpìrká rìi dang kyann jir Shìdun dang sig níng, bidìm pár shi sig áyau doka pyànà káníng ni.” ");
INSERT INTO jib_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Barà Farisawaká kwonn bi, sái Yesu bib big jír, ");
INSERT INTO jib_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","n rag, “Ning ri kyab Almasihu í wùn ni rà?” Big rag, “I wùn Dawuda.” ");
INSERT INTO jib_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ku bib káníng n rag, “Ma sáshinn Dawuda dang rag, Almasihu í Shinn Luwá níng rà? I barà Awun Shìdun sìnn kà ku aku dang. Dawuda dang rag, ");
INSERT INTO jib_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Shìdun dinya Shinn Lumí n rag, á bi á shi á vìm numí ni áyág. Má sìnn kà mpìr azíbwú big á mìr barwú ni.’ ");
INSERT INTO jib_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawuda ma shinnwá bar ku Shinn Lumí. To, sáshinn kwá shi wùn wàníng rà?” ");
INSERT INTO jib_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Walai mpìr-à zìm sar ya ku bu-à ku bib sig níng. Daka àyúnn-à níng hi kó mpìr ńzyun wim fig pìkyinn n bib fig rag ku jír bàna. ");
INSERT INTO jib_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","I byar-à Yesu dinya bìr mpìrká ma yann sukàwá big jír n rag, ");
INSERT INTO jib_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Malamká ma Farisawaká ri tàg bu á shinn tarkada Musa. ");
INSERT INTO jib_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aning wib kó kai bu-à bá dinya ning. Ama kada aning sa bu-à big ri sa bàna, jir kai bàna big ri wib fig buká big ri dang níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Big zìg swánn lìlìb nímá n sìnn kà sig mpìrká á shinn káníng ri tàng kyann ma kàhi. Ama big swann shang fig big bàna, kó títi nímá. ");
INSERT INTO jib_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Swàmká big ri sa bidìm pár í swàm bu jirà mpìrká abig myàng big, big ri ba jir Shìdun, mi ri bàg á mùnnpyànnbá ni kwonn ma azwìnn vùbá ni, jirà mpìrká abig myàng big. Big ri wìr jà lulor nímá ri fòr hár mà kan barbá ni. ");
INSERT INTO jib_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Big ri zìm abig shi á bushu sìsàn nímá á byar bùkí, kwonn ma bushu àgbam á tonn bìr kwonn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Big ri zìm abig bib kà kyann big mà fir ati, ma abig bar kyann big malam. ");
INSERT INTO jib_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama bigná, abig bar ning malam bàna, jir kai bàna malamná í mpìr ńzyun. Ning bidìm pár ning í bu ńzyun, ning í yiwai. ");
INSERT INTO jib_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aning bar kó ni ta á dunyaru bàna, jir kai bàna ning shi sig ma ta ńzyun, ku í zyun-à shi sig mà wai, ku awínwá ni. ");
INSERT INTO jib_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ning má, abig bar ning àgbam bàna, jir kai bàna àgbamná í mpìr ńzyun, ku í Almasihu. ");
INSERT INTO jib_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ama wà mpìr zyun áyauná ni ma ri zìm aku shi àgbamná, aku sìnn kàng shinnwá àràg ku í fàuná. ");
INSERT INTO jib_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mpìr-à ma gbar dù hing shinnwá, kwá fig zunái. Ama mpìr-à ma gbar dù fig shinnwá bàna, bá gbar dù ku. ");
INSERT INTO jib_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ná wa shwìn, ning malamká ma Farisawaká, ning í agbar dù shinn big. Ning kìg dim rìghing gbìb-à mpìrká nìm má kà á byar-à Shìdun ri na kùrwá mà wai. Ning ngàng wà ná kà màhàn. Ning kan dim rìghing mpìrká ri zìm abig kà màhàn.  ");
INSERT INTO jib_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ná wa shwìn, malamká ma Farisawaká, ning í mpìr agbar dù shinn big. Ning í mpìr alir ji bu á vù uwà kiká ni. Ning ri vig nonn Shìdun, jirà mpìrká abig myàng ning, jir wàníng, ná wa shwìn. ");
INSERT INTO jib_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Malamká ma Farisawaká, ná wa shwìn, ning í mpìr agbar dù shinn big. Ning shi kàng kwìb vinn rìghing jànn-à bidìm pár ma nu zàpìrká jirà aning dìg wùn sukà zyun. Wà na dìg hing ning ri sìnn kàng rìg ku àràg ku í mpìr asa bu-à bibai, shi rag ku kab ning bu-à bibai sa. ");
INSERT INTO jib_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ná wa shwìn, ning àfauká ri gbar jàuná big níng. Ning dang n rag, wà kó ni ma tun hing ki ma lu Shìdun, bu má sa fig ku bàna, ama mpìr-à ma tun hing zinariya á lu Shìdun ni, ma sa fig bu-à ku tun sig ki áni bàna, to, bu-à ku tun sig níng má pànn ku. ");
INSERT INTO jib_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ning í àfau àning big, áyau lu Shìdun ma zinariya, í wà áni kab nì rà? Lu Shìdun í àsàin-à ri sa zinariya-à níng ri dìg gbam. ");
INSERT INTO jib_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ning dang rag, mpìr ma tun bagadi byar-à big ri twìb swànn bu màhàn níng, bu má sa fig ku bàna. Ama mpìr-à ma tun hing wi-à big sìnn sig á shinn bagadi-à ni, ma sa fig bu-à ku tun sig ki áni níng bàna, ki-à ku tun sig níng, má pànn ku. ");
INSERT INTO jib_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ning í mpìr àfau big, áyau bagadi ma wi-à big ri sìnn á shinn bagadi, í wà áni kab nì rà? I bagadi ri sa wi-à aku dìg gbam íni. ");
INSERT INTO jib_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","To, kó ni ma tun hing bagadi byar-à big ri twìb swànn bu, ku tun dig sig kàhi, ma bu-à á shinn bagadi hi ni tìnn. ");
INSERT INTO jib_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mpìr-à ma tun hing lu Shìdun, ku tun dig sig kàhi ma Shìdun àsàin-à ri shi màhàn níng tìnn. ");
INSERT INTO jib_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mpìr-à ma tun hing waisháu, ku tun síg byar-à Shìdun ri shi, ku tun sig shinnwá ma Shìdun tìnn. ");
INSERT INTO jib_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ná wa shwìn, ning malamká ma Farisawaká, ning í mpìr agbar dù shinn big. Ning ri sa fig bu-à ǹsàn ma mpìr bàna. Ning ri myàng fig ashi mpìrká bàna. Ning í mpìr gwangga bàna. Kó áyau buká ning shi sig ma kàhi kyau dwib níng, ning ri ya Shìdun kyau zyun, hár ashìtá ma jì byù. Bu-à sàn kab sig bàna, aning zìm Shìdun aning zìm mpìr. ");
INSERT INTO jib_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ning í àfauká ri gbar jàuná big. Ning ri shann zu kó àgìmbu títi nímá á zàpìr-à ná wa. Ama ning ri wa mann kà rakumi zyun-à ùwài nímá. ");
INSERT INTO jib_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ná wa shwìn, ning malamká ma Farisawaká, ning í mpìr agbar dù shinn big, ning ri tu kyàr íri kwìb akpaká buná big jwang jwang. Ama ning ri fim finn-à mà yau íri jín, bu-à mònn sig áni bàna, íri bu-à bibai. ");
INSERT INTO jib_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wù Farisawa-à níng, wù í mpìr àfau, á tu kyàr jag ma finn akpa ḿpyim, í wà á tu kyàr kwíb-à íni, jirà kwíb-à aku shi ákyàr tìnn. ");
INSERT INTO jib_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ná wa shwìn, ning malamká ma Farisawaká, ning í mpìr agbar dù shinn big, ning shi sig àràg amirká big sa samyib sig wà á myann sìsàn nímá, ama wà mà yau mònn sig íri akibká swàr wìr na sig fáin. ");
INSERT INTO jib_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ning shi sig àràg amir káníng. A zu mpìrká big ri myàng ning, ning í mpìr ǹsàn, ama á pìkyinn ná, ning mònn sig íri bu-à bibai. Ning ri gbar dù shinn. ");
INSERT INTO jib_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ná wa shwìn, ning malamká ma Farisawaká, ning í mpìr agbar dù shinn big. Ning ri sa samyib amir mpìrká rìi dang kyann jir Shìdun. Ning ri sìnn samyib amir mpìrká big ri dang rag í mpìr sìsàn. ");
INSERT INTO jib_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I wà ning dang n rag, ‘Wàníng yi má, yi nìm ma shi sig àràg á zamanu yàkúyí big ni, yi nìm má gban fig mpìrká rìi dang kyann jir Shìdun níng bàna.’ ");
INSERT INTO jib_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ning má, ning dang hing ma shinn ná, ning dang rag, ning í yann mpìrká rì gban sig mpìrká zyun-à rìi dang kyann jir Shìdun níng. ");
INSERT INTO jib_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To, tàma-à níng aning sa bànn rìg bu-à yàkúná big rì sa dà síg níng. ");
INSERT INTO jib_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ning mpìr káníng ning í bushùwí, ning ri kyab rag, ná zu áyau kwonn-à Shìdun má wà níng ni rà? ");
INSERT INTO jib_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jir wàníng má swam bi ya ning mpìrká ri dang kyann jir Shìdun, ma mpìr yarká, ma mpìrká zyun-à má tàg ning bu. Ama ná gban rìg káhi, ná dab bàg káhi átàm bín, ná yang káhi ashor mà tonn bìr kwonn, ná kan dù káhi á finn swannká ni. ");
INSERT INTO jib_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jir wàníng ná wa shwìn á shinn mpìr ǹsànká ning gban sig, bu-à pànn sig daka á shinn ki Habila hár ki Zakariya wùn Berikiya zyun-à ning rì gban sig áyau byar-à big ri twìb swànn bu mà lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mì ri dinya ning í jir àjai, ning mpìrká á zamanu-à tàma-à níng, Shìdun má du kà ning shwìn jir ki mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ning mpìrká á Urushalima! Ning mpìrká á Urushalima! Ning gban rìghing mpìrká ri dang kyann jir Shìdun. Ning ta gban rìghing mpìrká Shìdun swam bi sig níng ma abàn. Mì ri zìm ń tonn ning àràg barà kwìnn ri tonn yanká buwá mi ri bir káníng á asàwá ni, ama ning ngàng mì. ");
INSERT INTO jib_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Luná má kàng kànnfinn. ");
INSERT INTO jib_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N dinya ning, ná myàng fig rag mì bàna, sái àyúnn-à ma kàng bi hing. Ayúnn-à níng hi, ná dang rag, ‘Mpìr-à ri bi á zìnn Shìdun ni níng, a Shìdun ya ku bu-à ku ri zìm.’ ” ");
INSERT INTO jib_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Barà Yesu dù á lu Shìdun ni, mi ri yag kyonnwá, í wà yann sukàwá big bi n tìya ku barà kinn-à á lu Shìdun sàn sig. ");
INSERT INTO jib_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ku dinya káníng n rag, “Barà ning ri myàng bu káníng, àyúnn zyun ri bi, bá dab gbànn rìg lu-à hi, kó abàn ńzyun má shi fig á shinn jàuwá zyun ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Barà Yesu shi sig mà Wùn Mwir Zaitun, sái yann sukàwá big yag mà byarwá ni, n bònn bib ku n rag, “A dinya yi sai-à bu káníng má sa, má sa ákaun rà? Bu-à yá myàng jirà ayi yì àyúnn-à wá kàng bi áni í kai rà? Bu-à yá myàng jirà ayi yì àyúnn-à dunyaru ma nyàan vinn í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sái Yesu tàg big bu, n rag, “Aning pànn shinn ná, kada aning zìm mpìr zyun aku tonn gban ning bàna, ");
INSERT INTO jib_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","jir kai bàna mpìrká nìnànn nímá má bi má rag big bi sig á zìnnmí ni. Bá dang rag big í Almasihu. Bá sa mpìrká nìnànn nímá má nang jànn. ");
INSERT INTO jib_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ná fig tai kànn kó áni bidìm pár, ama kada aning gib kyinn bàna, jir kai bàna bu káníng má sa àdòníng, ama sai-à dunyaru má vinn níng màg fig ma bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jànn zyun má nu kànn ma jànn zyun. Kùr zyun má nu kànn ma kùr zyun kó áni bidìm pár á jànn-à ni. Amor má kà á jànn-à ni wàni. Jànn-à á jìnn ni má ning kó byar-à áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ama wàníng ri jag má mìr átai. ");
INSERT INTO jib_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sai-à hi, mpìrká má pànn ning, bá ya ning shwìn, hár má gban rìg ning. Mpìrká á jànn-à ni má zib ning á dò jir shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mpìrká nìnànn nímá má fim rìg gbìbmí. Káhi má kwonn nubá jirà bá ya kà jàubá á vù mpìr azíbká ni. Mpìrká má zib bar dìrbá. ");
INSERT INTO jib_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A sai-à níng hi, mpìrká nìnànn nímá ká má gim ǹsáng rag big í mpìrká ri dang kyann jir Shìdun níng, bá bi á jànn-à ni, má tonn gban mpìrká. ");
INSERT INTO jib_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bá sa swàb kà bu-à bibai á jànn-à ni. Mpìrká nìnànn nímá má zìm fig jàubá bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama mpìr-à ma wim hing kyinn hár àyúnn-à wà kinn shinn, Shìdun má pinn zu ku. ");
INSERT INTO jib_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bá dinya mpìrká bidìm pár jir àjwár á shinnmí ni, jirà abig fig vinn rìg á jànn-à ni, í wà dunyaru má vinn. ");
INSERT INTO jib_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ná myàng bu àzing má shi á lu Shìdun. Daniel ba sig jír á shinn bu àzing-à hi. (Mpìr-à ma ri jangga bu-à mì ri ba níng, aku yì byann.) ");
INSERT INTO jib_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A sai-à níng hi, mpìrká ma shi sig mà yau jànn Yahudiya, abig shàr yag mà shinnkwìnnká ni. ");
INSERT INTO jib_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mpìr-à ma shi sig mà shinn tonnwá ni, aku tìg wann kíni aku shàr yag, kada aku dang rag, kwá kà mà finn tonn-à ni, kwá zìg bu zyun, í wà kwá shàr yag ni, bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mpìr-à ma shi sig mà da-à ni, kada aku dang rag, kwá yag mà lu-à ni, kwá zìg jà, í wà kwá shàr yág ni, bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ayúnn-à hi, uwàká shi sig ma finn, ma ká shi sig ma yann àjann níng, bá wa shwìn. ");
INSERT INTO jib_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aning vig Shìdun rag àyúnn-à ná shàr shàu-à níng, aku shi á yau dí bàna, aku shi àyúnn Asabar bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A sai-à hi, mpìrká má wa shwìn wàni, írì shwìn-à big taba wa fig bàna, tun sai-à Shìdun màm sig dunyaru. Mpìr má wa jakàng fig rag írì shwìn-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wà Shìdun nìm ma gib màg gban fig su shwìn-à níng bàna, kó mpìr ńzyun nìm má wìm zu fig bàna. Ama kwá gib màg gban su shwìn-à níng áni á jir shinn mpìrká ku shig zu sig, big shi sig á dunyaru. ");
INSERT INTO jib_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wà mpìrká ma dinya ning rag, aning myàng, mà Almasihu níng, kada aning zìm bàna. Kó ba dinya ning rag, mà ku bó, aning zìm bàna. Big ri gim ǹsáng. ");
INSERT INTO jib_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mpìr agim ǹsángká má bi, bá rag big í Almasihu, káhi má dang rag, big í mpìr-à ri dang kyann jir Shìdun. Hár bá sa bu mamaki kim kim, jirà abig gbar nang jànn mpìrká Shìdun shig zu sig, wà big nìm má sa sar. ");
INSERT INTO jib_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","N dinya rìghing ning bu káníng, barà su-à màg fig ma bàna níng. ");
INSERT INTO jib_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mpìrká ma dinya ning n ma rag, ‘Almasihu shi sig mà awúnn-à ni,’ kada aning yag màhàn bàna. Kó ba dinya ning ma rag, ‘Ku shi sig mà lu-à ni,’ aning zìm bàna, big ri gim ǹsáng. ");
INSERT INTO jib_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aràg barà mpìrká ri myàng shyù ri zwàm zu mà waisháu-à ni níng, í barà bá myàng mì, mì í Wùn Mpìr Jíkwìnn má kàng bi áni. ");
INSERT INTO jib_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Byar-à kiká ma wu na sig, í byar-à shwibká má kwonn yag màhàn. ");
INSERT INTO jib_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Asim shwìn-à mpìrká má wa níng ni, àyúnn má sìr rìg fi, sònn-à má mìg fig bàna. Asuswirká mà waisháu-à ni má kù wann bi rìg á jìnn ni. Bu gbamká shi sig mà wai má ning dìrbá. ");
INSERT INTO jib_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","I wà mì Wùn Mpìr Jíkwìnn má wann bi mà waisháu-à ni. Má kàng bi ma gbam ùwài nímá kwonn ma awàimí. Swai mpìrká bidìm pár bá myàng mì, mì Wùn Mpìr Jíkwìnn. Bá kig nàikitáu, má sa bai pìkyinn. ");
INSERT INTO jib_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bá winn yur, í wà má swam yag yann aswamká bumí big á byar mpìrká á dunyaru bidìm pár, jirà abig bar kwonn bi ya mì mpìrká Shìdun shig zu sig. Bá bar kwonn bi mpìrká á jànn-à ni bidìm pár, daka mà mìr swann hár mà shinn swann. ");
INSERT INTO jib_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Aning myàng misali á shinn bin ating. Wà na myàng bin ating ma ri twìb jì àpyú, ning yì hing shyù nyàan kù. ");
INSERT INTO jib_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To, wàníng má í àdòníng tìnn, sai-à na myàng buká ǹ dinya sig ning níng ma ri sa, aning yì rag ǹ nyàan kàng bi. ");
INSERT INTO jib_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mì ri dinya ning àjai, mpìrká tàma-à níng má wu vinn fig bidìm pár bàna, sái wà buká ǹ dinya sig ning níng ma sa rìghing. ");
INSERT INTO jib_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Waisháu ma jànn-à á jìnn ni má bab jànn rìg, ama jírmí má vinn fig ávinn bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Walai mpìr-à yì àyúnn-à Wùn Mpìr Jíkwìnn má kàng bi áni. Kó yann aswam Shìdun mà wai má, big yì fig bàna. Kó mì Wùn Shìdun má, ǹ yì fig bàna tìnn. Sái Shìdun Ta-à ku awínwá ni yì síg nì. ");
INSERT INTO jib_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Barà rì sa sig á sai-à Nuhu ri shi sig níng, í barà má sa áni àyúnn-à Wùn Mpìr Jíkwìnn má kàng bi á jànn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A sai-à zàpìr-à rì binn fig ma bàna níng, mpìrká rìi ji, mi ri wa, big ri zìg uwà mi ri ya ban, hár bi fòr àyúnn-à Nuhu bi kà á kòr-à ni. ");
INSERT INTO jib_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Big yì fig bu-à má sa bàna, hár sai-à gbànn yor-à níng bi binn swann yag rìg big. Wàníng í barà mpìrká má sa áni, hár àyúnn-à Wùn Mpìr Jíkwìnn má bi. ");
INSERT INTO jib_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A sai-à níng hi, wunù pyànà ma shi sig ma da-à ni, bá zìg rìg zyun, má fim zyun. ");
INSERT INTO jib_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uwà pyànà ma ri wau bu, bá zìg rìg zyun, má fim zyun. ");
INSERT INTO jib_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Buná, aning pànn shinn ná, jir kai bàna ning yì fig sai-à Shinn Luná má kàng bi á ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wa àsàin lu-à nìm ma yì hing sai-à ajwú má kà á luwá ni, ku nìm má shi àzír, má myàng luwá, jirà ajwú aku kà á luwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aning shi àzír, jir kai bàna Wùn Mpìr Jíkwìnn má bi á sai-à ning kyab fig rag má bi bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Fàu-à shi sig ma yar, n shi sig ma gwangga í wà áni rà? Asàin lu ma dìg hing fàu-à shi sig ma gwangga, kwá ya kà luwá á vù wàníng ni, a wàníng ya fàuká dà níng buju kó ákaun. ");
INSERT INTO jib_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Asàin lu-à ma ya sig fàuwá swàm, kwa kàng bi kwa dìg wàníng ma ri sa, fàu-à hi má fig àjwár. ");
INSERT INTO jib_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mì ri dinya ning jír àjai, kwá sìnn kà wàníng a wàníng myàng kwonn ma buká ku shi sig ma kàhi bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama wà fàu-à hi ma í fàu-à bibai, kwá dang rag, àsàin luwá má kàng bi fonn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kwá dab jàuwá big fàuká. Kwá ji má wa, kwá wa pyann shin ma mpìrká ri wa pyann shin. ");
INSERT INTO jib_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Asàin lu fàu-à níng má kàng bi, fàu-à níng má yì fig àyúnn-à hi bàna. ");
INSERT INTO jib_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Asàin lu-à má yang fàuwá ashor, hár dìr fàu-à má pòr. Kwá sìnn kà wàníng á shwìn àràg barà ku ri sìnn kà mpìrká ri gbar dù shinn. Wàníng má kig mínn wàni, má zwàm kà vù á nginn. ");
INSERT INTO jib_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“A sai-à Shìdun má na kùrwá áni níng, má shi àràg barà yann uwà big dwib zìg pitilaká bubá mi ri yag abig shà ango. ");
INSERT INTO jib_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uwà swana áyaubá ni shi sig ma yar, swana bó, í àning. ");
INSERT INTO jib_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aning káníng zìg pitilabá, n pànn kwonn fig ma byìr á vùbá ni bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama uwà yar káníng pànn kwonn sig ma byìrbá í zyun á àkwìnn-à ni, kwonn ma pitilabá. ");
INSERT INTO jib_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ango-à hi bi fonn fig kíni bàna, hár uwà káníng ri dìm ná, big í na jànn rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ama áyau fi-à ni, big fig nài jir bìr mpìrká, mpìrká ri dang rag ango ri bi, aning bi shà ku. ");
INSERT INTO jib_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A byar-à níng hi, uwà dwib káníng fim zir n sa samyib pitilabá. ");
INSERT INTO jib_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Uwà àning káníng dinya uwà yar káníng n rag, ‘Aning ya yi byìr títi, jir kai bàna pitilayí ri dim.’ ");
INSERT INTO jib_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ama uwà yar káníng dinya kàng big n rag, ‘Má màg fig yi hár ma ning bàna. Bu-à ná sa bàna, aning yag mà fir ati-à ni aning wann buná.’ ");
INSERT INTO jib_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A byar-à níng hi, big dù jirà abig yag wann byìr-à hi, sái ango í bi fòr rìg-à ásimbá ni. Uwà swanaká dà sig níng, kà yag sig ma ku, í byar-à mpìrká kìg dim rìg nu nkyun-à, uwà swana bi ji buju ban-à ma ango. ");
INSERT INTO jib_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Uwàká zyun-à yag sig abig wann byìr-à níng, í fòr bi rìg-à. Big kwìb nu nkyun-à n rag, ‘Shinn Luyí, Shinn Luyí, á pù ya yi nu nkyun-à.’ ");
INSERT INTO jib_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ango dinya big n rag, ‘Mì ri dinya ning àjai, ǹ yì fig ning bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu dinya kinn big jírwá n rag, “Aning shi àzír, jir kai bàna ning yì fig àyúnn-à má kàng bi á dunyaru bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Byar-à Shìdun má na kùrwá má shi àràg mpìr-à yag sig kyìnn, n bar kwonn bi sig fàuwá big, n ya sig big bài. ");
INSERT INTO jib_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ku ya mpìr zyun bài dubu swana, zyun dubu pyànà, zyun bó dìg dubu zyun. Ku ya kó ni bar swàmwá. Barà ku ya vinn rìg káníng àdòníng, ku í yag rìg-à kyìnn. ");
INSERT INTO jib_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Fàu-à big ya sig ku dubu swana-à níng, yag n dìg swàb kà dubu swana á shinn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mpìr zyun-à big ya sig ku dubu pyànà níng, dìg swàb kà dubu pyànà á shinn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama mpìr-à big ya sig ku bài dubu zyun níng, ku yag n kab shar n tàm jànn rìg bài-à àsàin luwá ya sig ku níng. ");
INSERT INTO jib_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Barà shi nonn nonn í byar-à àsàin lubá kàng bi, ku yag dìg fàuwá big, n bib big bu-à big sa sig ma bài-à ku ya sig big níng. ");
INSERT INTO jib_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A byar-à níng hi, fàu-à big ya sig ku bài dubu swana-à níng bi, n ya àsàin luwá bu-à ku dìg swàb kà sig dubu swana. Ku dinya àsàin luwá n rag, ‘Asàin lumí, à ya sig mì dubu swana, tàma-à níng bu-à ǹ dìg swàb kà sig á shinn-à ni bàna, í dubu swana tìnn.’ ");
INSERT INTO jib_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A byar-à níng hi, àsàin luwá yan ku n rag, ‘Isoko ma swàm-à à sa sig, wù í fàu-à ǹsàn. A sa hing swàm ma pìkyinn ńzyun ma bài títi-à ǹ ya sig wù níng. A dìg swàb kà bi hing bu á shinn-à ni àràg barà ǹ ya sig wù níng. Tàma-à níng, má ya wù wà kab wàrì níng. A bi ayi fig àjwár ábìr-à ni.’ ");
INSERT INTO jib_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zyun-à big ya sig ku dubu pyànà níng, kà bi n rag, ‘Asàin lumí, à ya sig mì bài dubu pyànà, tàma-à níng bu-à ǹ dìg swàb kà sig bàna, í dubu pyànà.’ ");
INSERT INTO jib_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A byar-à níng hi, àsàin luwá yan ku n rag, ‘Isoko ma swàm-à à sa sig, wù í fàu-à ǹsàn. A sa hing swàm ma pìkyinn ńzyun ma bài títi-à ǹ ya sig wù níng. A dìg swàb kà bi hing bu á shinn-à ni, àràg barà ǹ ya sig wù níng. Tàma-à níng ma ya wù wà kab wàrì níng. A bi ayi fig àjwár ábìr-à ni.’ ");
INSERT INTO jib_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Fàu-à big ya sig ku dubu zyun-à níng, bi n rag, ‘Asàin lumí, ǹ yì hing pìkyinnwú bai. Wù ri binn kwonn buju-à à tàg fíg nì bàna. Wù ri zà kwonn yìr bujuká zyun-à à minn fíg nì bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mì ri shàr zinnwú, í bu-à sa ǹ yag n tàm jànn rìg bàiwú á shar-à ni. Tàma-à níng á zìg bàiwú.’ ");
INSERT INTO jib_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A byar-à níng hi, àsàin luwá dinya ku n rag, ‘Wù í fàu àbai, wù í mpìr dìjar. A yì hing, mì í mpìr pìkyinn àbai, mì ri binn kwonn buju-à ǹ tàg fíg nì bàna, mì ri zà kwonn yìr buju-à ǹ minn fíg nì bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wàníng wù nìm ma zìg yag rìghing bàimí mà tonn byar-à big ri sìnn gbam bài, tàma-à níng barà ǹ kàng bi sig níng, ǹ nìm má dìg swàb kà bu zyun á shinn-à ni. ");
INSERT INTO jib_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To, aning zìg rìg bài-à á vùwá ni, aning ya zyun-à shi sig ma bài dubu dwib níng. ");
INSERT INTO jib_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mpìr-à ma shi sig ma bu, bá ya swàb kà ku, kwá dìg swàb kà ùwài nímá. Ama mpìr-à ma bàna ma bu, títi zyun-à ku shi sig ma kàhi níng, bá zìg rìg á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aning kan tafinn yag rìg fàu bibai-à níng mà byar zufi á byar-à kwá kig mínn wàni hár kwá zwàm kà vù á nginn.’ ");
INSERT INTO jib_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ayúnn-à Wùn Mpìr Jíkwìnn má bi áni, kwá bi àràg í kùr, kwá bi kwonn ma yann aswamwá big í zyun. Kwá shi á byar shu kùrwá ni. ");
INSERT INTO jib_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mpìrká á jànn-à ni bidìm pár má kwonn bi rìg á pyànnwá ni. A byar-à hi, kwá gàfinn mpìr káníng kyau pyànà àràg barà aza àdùnká ri kyàb gàfinn àdùnká ma byínnká. ");
INSERT INTO jib_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kwá sìnn kà àdùnká agunn vìm nuwá ni, ama kwá sìnn kà byínnká agunn vìm súrwá ni. ");
INSERT INTO jib_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A byar-à hi, kùr-à ma dinya ká zyun-à shi sig agunn vìm nuwá ni níng, má rag, ‘Aning kà bi ning mpìr ǹsànká bu Tamí, aning bi shi ngàng á lu-à big sa sìnn ya sig ning, tun daka sai-à big màm fig ma dunyaru bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Amor rì gban mì, ning ya mì buju ǹ ji, ajor zàpìr rì gban mì, ning ya mì zàpìr ǹ wa, ǹ rì bi sig kyìnn, ning pag mì byar ná. ");
INSERT INTO jib_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","N rì kyann dìr áyonn, ning wìr mì jà, ǹ rì na sig dor, ning bi myàng kwonn ma mì í zyun. Big rì kìg kà sig mì mà tonn fi-à ni, ning bi bib kà hing mi.’ ");
INSERT INTO jib_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","A byar-à hi, mpìr ǹsàn káníng má zìm má rag, ‘Shinn Luyí, yi myàng sig wù ákaun, amor rì gban sig wù hár yi ya wù buju rà? Ajor zàpìr rì gban sig wù ákaun, hár yi ya wù zàpìr á wa rà? ");
INSERT INTO jib_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A bi sig kyìnn á byaryí ni ákaun, hár yi pag wù byar ná rà? A kyann sig dìr áyonn ákaun, hár yi ya wù jà rà? ");
INSERT INTO jib_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yi myàng wù à na sig dor ákaun, big kìg sig wù mà tonn fi-à ni ákaun, hár yi bi bib kà wù rà?’ ");
INSERT INTO jib_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A byar-à hi, kùr má rag, ‘Mì ri dinya ning àjai, barà ning sa ya sig wunzàmí zyun-à títi buká ǹsàn níng, ning sa ya sig mì.’ ");
INSERT INTO jib_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kwá dinya ká zyun-à shi sig á vìm súrwá ni má rag, ‘Aning dù á byarmí ni, ning zyun-à ning í bu Shìdun bàna níng. Aning yag kà mà lu pyìr-à big sa sìnn sig wà má dim fig ádim bàna, jir shinn Shaitan ma yann aswamwá big. ");
INSERT INTO jib_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Amor rì gban mì, ning ya fig mì buju ń ji bàna, ajor zàpìr rì gban mì, ning ya fig mì zàpìr ń wa bàna. ");
INSERT INTO jib_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N rì bi sig kyìnn, ning pag fig mì byar ná bàna, ǹ rì kyann dìr áyonn, ning ngàng wà ná wìr mì jà, ǹ rì na sig dor, ning ngàng wà ná yag má bib kà mì, big kìg kà mì mà tonn fi-à ni, ning ngàng wà ná yag má bib kà mì.’ ");
INSERT INTO jib_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","A byar-à hi, bá dang má rag, ‘Shinn Luyí, yi myàng sig wù ákaun, amor rì gban wù, ajor zàpìr rì gban sig wù ákaun rà? A bi sig kyìnn ákaun rà? A kyann sig dìr áyonn ákaun rà? A na sig dor ákaun rà? Big kìg kà sig wù ákaun, wà yi ngàng wù rà?’ ");
INSERT INTO jib_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A byar-à hi kwá dang má rag, ‘Mì ri dinya ning àjai, barà ning ngàng sig wunzàmí zyun, n sa ya fig ku bu ǹsàn bàna níng, ning ngàng síg mì.’ ");
INSERT INTO jib_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A byar-à hi, mpìr káníng, bá tìr yag big mà lu pyìr-à má dim fig ádim bàna, ama mpìr ǹsànká bá dìg yonki zyun-à má vinn fig ávinn bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Barà Yesu dang vinn rìg jírká àdòníng, ku dinya yann sukàwá big n rag: ");
INSERT INTO jib_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ning yì hing su pyànà ma wam zu hing, yá ji buju àyúnn Pìm Wam Zu. Ayúnn-à níng hi bá zìg mì, mì Wùn Mpìr Jíkwìnn, bá dab bàg gbam mì á tàm bín-à ni.” ");
INSERT INTO jib_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A byar-à níng hi àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma àgbam mpìrká kwonn bi sig í byar ńzyun mà lu Kayafa. Ku í àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Big shi kwonn, n kwonn nubá barà bá bònn pànn Yesu má gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ama big dang rag bá pànn sar fig ku á sai-à bìr mpìrká kwonn shi sig, mi ri fig àjwár níng bàna, jir kai bàna kada mpìrká abig dù ngain. ");
INSERT INTO jib_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A sai-à Yesu shi sig mà Baitanya mà lu Siman mpìr-à rì shi sig ma dor àkùnn. ");
INSERT INTO jib_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Uwà zyun bi á byarwá ni ma wùn àkwìnn byìr zyun-à ri ning swìnn ǹsàn, byìr-à hi shi sig ma bài wàni, ku wìr wann á shinn Yesu ni á sai-à wàníng ri ji buju. ");
INSERT INTO jib_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Barà yann sukàwá big myàng àdòníng, big nànn rìg àgùnn n rag, “Bu-à sa uwà-à níng ri sa kìfinn byìr-à níng í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Byìr-à níng big nìm ma wann tafinn ma bài ùwài nímá, n nìm má zìg bài-à má ya mpìr ashiká.” ");
INSERT INTO jib_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu yì rìghing bu-à big ri dang, sái ku bib big n rag, “Bu-à sa ning ri sa shi uwà-à níng í jir kai rà? Bu-à ku sa sig mì níng, ku sa síg mì bu-à ǹsàn. ");
INSERT INTO jib_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ning ri shi kyann ma mpìr ashiká í zyun kó ákaun, ama bigmí, yi ma ning má shi kyann fíg zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Byìr ǹsàn uwà-à níng wìr sig mì á dìr-à ni níng, ku wìr sig mì jirà sai-à bá jì mì áni. ");
INSERT INTO jib_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mì ri dinya ning àjai, byar-à ba dang jir àjwár Shìdun kó áni á dunyaru, bu-à ku sa sig níng bá dinya mpìrká, mpìrká má kyab pànn ku áni.” ");
INSERT INTO jib_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ayau yann sukà Yesu dwib agban pyànà níng, zyun-à big ri bar zìnnwá Yahuda Iskariyoti níng, ku yag mà byar àgbamká ri twìb swànn bu á pyànn Shìdun, ");
INSERT INTO jib_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","n rag, “Wà ma ya kà hing Yesu á vùná ni, ná ya mì í kai rà?” A byar-à níng hi, big wànn bài azurfa àkunn dìzyun agban dwib n ya ku. ");
INSERT INTO jib_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","I wà ku yàn pyù-à kwá wann tafinn ya big Yesu. ");
INSERT INTO jib_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ayúnn wà jijag wà bá ji brodi-à bàna ma yisti níng fòr, sái yann sukàká bi á byar Yesu n bib ku rag, “Wù ri zìm ayi sa buju àyúnn Pìm Wam Zu-à níng áni rà?” ");
INSERT INTO jib_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ku rag, “Aning yag mà finn swànn-à ni, ná dìg mpìr zyun màhàn. Aning dinya ku rag, ‘Malam rag, suwá nyàan màg, kwá bi má ji brodi-à bàna ma yisti níng mà luwú ni ma yann sukàwá big.’ ” ");
INSERT INTO jib_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A byar-à níng hi, yann sukàká yag n sa àràg barà Yesu dinya sig big. Big yag n sa sìnn buju àyúnn Pìm Wam Zu-à níng màhàn. ");
INSERT INTO jib_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Barà kamzau fòr àdòníng, sái Yesu ma yann sukàwá big dwib agban pyànà níng, shi wann í byar ńzyun n ji buju. ");
INSERT INTO jib_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Barà big ri ji buju àdòníng, sái Yesu dinya big n rag, “Mì ri dinya ning àjai, mpìr zyun áyauná ni má wann tafinn mì.” ");
INSERT INTO jib_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Barà big fig àdòníng, pìkyinnbá bai wàni, big bib ku zyun zyun n rag, “Shinn Luyí, kó í mì rà?” ");
INSERT INTO jib_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu zìm n rag, “Mpìr-à níng hi í mpìr-à ri swab ji kwonn brodi ma mì á tasa-à ni níng, má wann tafinn mì nì. ");
INSERT INTO jib_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mì Wùn Mpìr Jíkwìnn, má wu àràg barà big ba sig á shinnmí ni á jir Shìdun ni rag má wu níng. Ama mpìr-à má wann tafinn Wùn Mpìr Jíkwìnn níng, kwá wa shwìn, má sàn káb nì wà big nìm ma mà fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda zyun-à má wann tafinn Yesu níng, bib ku n rag, “Malam, kó í mì rà?” Sái Yesu rag, “Nn, à dang hing ma nuwú.” ");
INSERT INTO jib_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Barà big ri ji buju àdòníng, í byar-à Yesu zìg brodi n vig Shìdun, n sa wàníng ísoko, n ngir gàfinn, n ya yann sukàwá big. Ku dinya káníng rag, “Aning zìg ma aning ji, wàníng í dìrmí.” ");
INSERT INTO jib_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ku zìg kwài n sa Shìdun ísoko, n ya big n rag, “Ning bidìm pár, aning wa áni. ");
INSERT INTO jib_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wàníng í àsàmí zyun-à má kìfinn á dò shinn mpìrká ni nìnànn nímá, jirà Shìdun aku yafa ya big bu pyìrbá, àràg barà ku gib sig nu níng. ");
INSERT INTO jib_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mì ri dinya ning, má wa fig rag zàn inabi-à níng ma ning bàna, sái àyúnn-à yi ma ning má wa wà àpyú-à mà byar-à Tamí ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A byar-à níng hi big dài jonn n swam yan Shìdun, mì yag rìg-à mà Wùn Mwir Zaitun. ");
INSERT INTO jib_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu dinya big n rag, “A fi-à níng ni, ning bidìm pár ná shàr tafinn rìg mì, jir kai bàna big ba sig á shinnmí ni á jir Shìdun ni n rag, ‘Shìdun má gban rìg aza àdùn-à, àdùnká má shàr yam rìg.’ ");
INSERT INTO jib_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama sai-à ma dù nann zu kàng hing ma yonki, má yag jág ning nì mà Galili.” ");
INSERT INTO jib_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bitrus dinya Yesu n rag, “Kó wà jàumí big bidìm pár ma fim rìghing wù, bigmí má fim fig wù bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A byar-à hi Yesu dinya ku n rag, “Mì ri dinya wù àjai, á fi-à níng ni, kwìnn má dab fig ma aku bàna, wá sa yipyàr kàun sara má rag à yì fig mì bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitrus dinya ku n rag, “Kó wà mpìrká ma rag bá gban bàg kwonn mì big wù má, má sa fig yipyàr rag ǹ yì fig wù bàna.” Yann sukà kádà níng dang àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu yag kwonn ma yann sukàwá big mà byar-à big ri bar Gatsemani. Ku dinya big n rag, “Aning shi wann áyág, má yag màhàn bó má vig Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ku zìg Bitrus ma yann Zabadi àkunn pyànà, n yag kwonn ma big. Pìkyinnwá bai sig wàni. ");
INSERT INTO jib_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ku dinya káníng n rag, “Pìkyinnmí bai sig wàni, shi rag má wù wu. Aning shi áyág, ama aning shi àzír àràg mì.” ");
INSERT INTO jib_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ku yag sim mà pyànn títi, n kànn wann mùnnpyànnwá á jìnn ni, n vig Shìdun n rag, “Tamí, wà má sa, á zìg zu rìg mì áyau shwìn-à má wa níng ni. Ama á bàg bu-à á kyinnmí ni bàna, sai bu-à kyinnwú ri zìm.” ");
INSERT INTO jib_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ku kàng bi á byar yann sukàwá big sara, n dìg big na jànn rìghing. Sái ku dinya Bitrus n rag, “Wá shi fig àzír kó awa ńzyun bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aning shi àzír ma aning vig Shìdun jirà kada bu-à bibai aku tonn gban ning bàna. Pìkyinn ná ri zìm aning sa bu ǹsàn, ama gbamná fòr fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu yag jakàng n vig Shìdun n rag, “Tamí, wà wa zìg fig shwìn-à má wa níng bàna, ǹ zìm hing má wa rag shwìn-à hi.” ");
INSERT INTO jib_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ku kàng bi jakàng n dìg yann sukàwá big ri na aná, jir kai bàna zuná ri dìm big. ");
INSERT INTO jib_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu fim big n kàng yag jakàng wà wa sara, n vig Shìdun àràg barà ku nìm vig sig níng. ");
INSERT INTO jib_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ku kàng bi jakàng á byar yann sukàwá big n rag, “Hár tàma-à níng ning ri na aná, mi ri na ngàng awun ná rà? Aning myàng, àyúnn-à màg rìghing wà bá wann tafinn mì, mì Wùn Mpìr Jíkwìnn, bá ya kà mì á vù mpìr bu pyìrká ni. ");
INSERT INTO jib_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aning dù nann zu, ayi yag ning. Aning myàng, mpìr-à má ya tafinn mì níng, ma ku níng.” ");
INSERT INTO jib_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Barà Yesu ri dang jír àdòníng, í byar-à Yahuda mpìr zyun áyau yann sukà dwib agban pyànà níng, bi kwonn ma bìr mpìrká. Big bi kwonn ma kafai ma tun, jir kai bàna shun àgbamká ma àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, swàm bi síg big nì. ");
INSERT INTO jib_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zyun-à má ya tafinn Yesu níng, dinya rìghing mpìrká bu-à kwá sa. Ku dinya big n rag, “Mpìr-à na myàng ma kàm pànn ku, í mpìr-à ná pànn.” ");
INSERT INTO jib_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gbìb fig tá bàna, sái Yahuda yag mà byar Yesu ni n rag, “Malam, mì ri bib kà wù.” I byar-à ku kàm pànn wàníng. ");
INSERT INTO jib_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sái Yesu dinya ku n rag, “Jàumí, á sa bu-à zìg bi sig wù.” A byar-à níng hi, mpìr káníng bi n pànn ku, n zìg yag rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mpìr zyun áyau mpìrká bu Yesu ni, gbar wàm zu kafaiwá n kyag fàu àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. Ku kyag zu rìg wàníng sung-à. ");
INSERT INTO jib_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A byar-à hi Yesu dinya ku n rag, “A sìnn kà kàng kafaiwú mà pyirwá ni, jir kai bàna mpìr-à ma nu kànn ma kafai, kafai í bu-à má gban ku. ");
INSERT INTO jib_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ning yì fig wà kó tàma-à níng ma zìm hing, má vig Tamí, kwá swam bi ya mì yann aswamwá mà wai big dubu nìnànn nímá bàna rà? ");
INSERT INTO jib_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wà ma sa hing àdòníng, bu-à big ba sig á jir Shìdun ni á shinnmí ni níng, má shi fig àràg barà big ba sig níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A byar-à hi Yesu bib bìr mpìr káníng n rag, “Ning bi sig ma kafai kwonn ma tun àjirà aning pànn mì níng, mì í mpìr ajwú rà? Su ma su bidìm pár mì ri yag kyann mà lu Shìdun, mi ri tàg kyann mpìrká, ama ning pànn fig mì bàna, ");
INSERT INTO jib_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ama sái tàma-à níng, ná pànn mì rà? Bu káníng bidìm pár sa sig àjirà bu-à mpìrká rìi dang kyann jir Shìdun ba sig níng, aku shi àràg barà big ba sig.” A byar-à níng hi, yann sukàwá big bidìm pár shàr n fim rìg ku, mì yag rìgbá. ");
INSERT INTO jib_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mpìrká zyun-à pànn sig Yesu níng, zìg yag ku mà lu Kayafa àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun, á byar-à malamká ma àgbamká kwonn shi sig. ");
INSERT INTO jib_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ama Bitrus bàg yag ku ásim pyunn ninonn nímá, hár mà fir lu àgbam áyau mpìr-à ri twìb swànn bu. Ku kà yag n shi wann mà byar-à asa gadiká shi sig, àjirà aku myàng vinn rìg bu-à má sa. ");
INSERT INTO jib_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Agbamká áyau mpìrká ri twìb swànn bu káníng, ma àgbamká zyun-à dà sig níng, ri yàn kyann mpìrká zyun-à má gim ǹsáng á shinn Yesu, àjirà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kó barà agim ǹsángká bi dang jírbá áni bidìm pár, big dìg fig ku ma jír àbai zyun bàna. Ama ásim, mpìr pyànà big bi, ");
INSERT INTO jib_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","n rag, “Mpìr-à níng dang rag, ku shi sig ma gbam-à kwá dab gbànn rìg lu Shìdun, má mi kàng rìg á su sara.” ");
INSERT INTO jib_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A byar-à níng hi, àgbam-à áyau mpìrká ri twìb swànn bu níng, dù nann zu á wai n bib Yesu rag, “A bàna ma jír-à wá dang á shinn jír-à níng ni rà? Bu-à mpìr káníng ri dang á shinnwú ni níng, í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama Yesu pànn shi rìg akim. Agbam-à áyau mpìrká ri twìb swànn bu níng, vig ku n rag, “N kwonn hing wù ma Shìdun, á dinya mì àjai, wù í Almasihu wùn Shìdun rà?” ");
INSERT INTO jib_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu zìm ya ku n rag, “A dang hing ma nuwú. Ama mì ri dinya ning, àyúnn zyun ná myàng Wùn Mpìr Jíkwìnn má shi agunn vìm nu Shìdun ni, kwá wann bi áyau akor-à ni mà waisháu-à ni.” ");
INSERT INTO jib_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A byar-à níng hi, àgbam-à níng gbar ka rìg jàwá n rag, “Mpìr-à níng dang bai hing zìnn Shìdun. Bu-à sa yá yàn mpìrká káhi abig bi dang kàng jír á shinnwá ni níng, í jir kai rà? Tàma-à níng, ning fig hing bu-à ku dang sig. ");
INSERT INTO jib_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ning myàng ashinn?” Big zìm n rag, “Bu bibai-à ku sa sig níng fòr hing wà yá gban ku.” ");
INSERT INTO jib_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Big tu wìr ku sháng á mùnnpyànnwá ni, n dab ku gbàr. Ká dab sig ku níng, ");
INSERT INTO jib_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dang rag, “A tìya yi mpìr-à dab sig wù, wà wù ma í Almasihu.” ");
INSERT INTO jib_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Barà Bitrus shi sig mà myann, í byar-à wùn uwà zyun bi á byarwá ni, n rag, “Wù má, wù nìm shi kwonn sig ma Yesu mpìr-à á Galili.” ");
INSERT INTO jib_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama ku sa yipyàr á pyànnbá ni bidìm pár n rag, “N yì fig bu-à wù ri dang níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A byar-à níng hi, ku í zu yag rìg-à mà myann, n sar rìg mà gbà dán-à ni. Sái wùn uwà zyun mà lu kùr-à ni bi jakàng, n myàng ku n dinya mpìrká rag, “Mpìr-à níng nìm shi kwonn sig ma Yesu mpìr Nazarat.” ");
INSERT INTO jib_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bitrus sa jakàng yipyàr n tun ki n rag, ku yì fig mpìr-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Shi kàng títi nímá, mpìrká zyun-à sar sig màhàn níng, kwonn bi á byar Bitrus n rag, “Ajai, wù í mpìr zyun á yaubá ni, jir kai bàna anam jírwú tìya síg yi ni.” ");
INSERT INTO jib_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","I byar-à Bitrus dang rag, “N tung hing shinnmí ma Shìdun, ǹ yì fig mpìr-à ning ri dang níng bàna.” Gbìb fig tá bàna, sai kwìnn dab aku. ");
INSERT INTO jib_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sái ku kyab pànn bu-à Yesu rì dinya sig ku rag, “Sai-à kwìnn ra aku dab aku níng, wá sa yipyàr kàun sara, má rag à yì fig mì bàna.” A byar-à hi ku zu yag mà myann, n kig mínn wàni. ");
INSERT INTO jib_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","I pyimbyau yìì nímá, àgbamká áyau mpìrká ri twìb swànn bu káníng, ma àgbamká zyun-à dà sig níng su kwonn nubá á shinn Yesu, jirà abig gban ku. ");
INSERT INTO jib_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Big sìr ku, n zìg yag ku n ya kà á vù gwamna. Gwamna-à hi zìnnwá í Bilatus. ");
INSERT INTO jib_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Barà Yahuda mpìr-à wann tafinn sig Yesu níng, myàng barà big pànn rìghing Yesu má gban rìg wàníng, sái ku myàng bu-à ku sa sig níng sàn fig bàna. Ku zìg yag kàng rìg bài azurfa dìzyun agban dwib-à níng mà byar àgbamká áyau mpìrká ri twìb swànn bu, ma shun àgbamká. ");
INSERT INTO jib_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ku dinya big n rag, “N sa hing bu pyìr barà ǹ wann tafinn mpìr-à níng átai, ku sa fig bu-à bibai bàna níng.” A byar-à hi, àgbamká dinya ku n rag, “Bu-à du yi í kai, wàníng í jírwú.” ");
INSERT INTO jib_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A byar-à níng hi, ku í tafinn rìg-à bài-à hi mà lu Shìdun ni, mi í yag rìgwá, n yag swànn gban rìg shinnwá. ");
INSERT INTO jib_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Agbamká wun kwonn rìg bàiká hi n rag, “Wàníng í bài àsà, barà dokayí dang sig sàn fig wà ayi sìnn kà mà lu Shìdun bàna.” ");
INSERT INTO jib_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Big kwonn nubá n yag wann agunn jànn-à mpìrká ri mi pár áni, àjirà abig jì kyìnnká màhàn. ");
INSERT INTO jib_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I bu-à sa big ri bar byar-à níng hi, jànn àsà hár tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bu-à Irimiya, mpìr-à rìi dang kyann jir Shìdun ba sig níng, shi hing àjai, ku ba sig rag, “Big zìg azurfa dìzyun agban dwib. Wàníng í bài-à mpìrká á Israila zìm sig abig wann tafinn ku áni. ");
INSERT INTO jib_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Big zìg bài-à hi, n wann rìg agunn jànn-à mpìrká ri mi par áni, àràg barà Shìdun dinya sig mì.” ");
INSERT INTO jib_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu sar sig á pyànn gwamna-à ni, gwamna bib ku n rag, “Wù í kùr Yahudawaká rà?” Sái Yesu zìm n rag, “Aràg barà à dang níng.” ");
INSERT INTO jib_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Shun àgbamká ma àgbamká ri twìb swànn bu á pyànn Shìdun ni, big tìr ya Yesu jír, ama ku pù fig nuwá bàna. ");
INSERT INTO jib_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bilatus bib ku n rag, “A fig hing barà mpìrká ri dang jír á shinnwú ni nìnànn nímá níng kó?” ");
INSERT INTO jib_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama Yesu dinya fig ku kó jir ńzyun bàna. Sái gwamna sa mamaki wàni barà wàníng dang fig jír bàna níng. ");
INSERT INTO jib_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A sai-à mpìrká ma ji buju àyúnn Pìm Wam Zu, àyúnn-à níng hi, gwamna ri zìg zu kyann mpìr zyun áyau ká big kìg sig mà tonn fi-à ni, wà zyun-à mpìrká ma vig hing ku rag aku zìg zu. ");
INSERT INTO jib_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A sai-à níng hi mpìr zyun shi sig mà tonn fi-à ni, zìnnwá í Barabas. Mpìrká yì hing wà ku í mpìr bibai. ");
INSERT INTO jib_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Barà bìr mpìrká kwonn bi àdòníng, sái Bilatus bib big n rag, “Ning ri zìm ń fìnn tafinn í ni rà? N fìnn tafinn Barabas rà, kó Yesu zyun-à big ri bar ku Almasihu níng rà?” ");
INSERT INTO jib_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ku yì hing rag í jir akyib í bu-à sa big ya kà sig Yesu á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Barà Bilatus shi sig mà byar kwonn wà àdòníng, sái wàwá dwim yag adwim n rag, “A zu rìg á yau mpìr-à níng ni, ku sa fig bu bibai bàna, jir kai bàna la-à ǹ la sig jana-à níng, ǹ wa hing shwìn wàni á jir shinnwá ni.” ");
INSERT INTO jib_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma àgbamká káhi kar zìng bìr mpìr káníng n rag, abig vig Bilatus aku fìnn tafinn Barabas, ma aku gban rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","I byar-à Bilatus bib big n rag, “Ayau mpìr pyànà káníng ni, ning ri zìm ń fìnn tafinn ni rà?” Big zìm n rag, “Yi ri zìm á fìnn tafinn Barabas.” ");
INSERT INTO jib_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatus bib big n rag, “To, má sáshinn ma Yesu zyun-à big ri bar ku Almasihu níng rà?” Big bidìm pár big rag, abig dab bàg gbam ku á tàm bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sái Bilatus bib big n rag, “I jir kai rà? Ku sa sig í kai wà bá dab bàg gbam ku rà?” A byar-à níng hi, big gbam nài gbam wàni n rag, “Abig dab bàg gbam ku.” ");
INSERT INTO jib_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Barà Bilatus myàng káníng fig fig jírwá bàna, big ri gbam íri nài gbam níng, ku zìg zàpìr n tu rìg vùwá á pyànnbá ni n rag, “Ki-à mpìr-à níng má wu níng í vù jírmí bàna, í vù jírná.” ");
INSERT INTO jib_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A byar-à hi bìr mpìr káníng zìm n rag, “Yi zìm hing kiwá kwá wu níng, alaki-à aku shi á shinnyí ni, ma yanká buyí big.” ");
INSERT INTO jib_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A byar-à hi ku fìnn tafinn ya big Barabas n du kà big yang Yesu ashor. Ku ya kà wàníng á vù sojaká ni, a káníng dab bàg gbam rìg wàníng á bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sojaká bu Bilatus zìg yag Yesu mà lu gwamna. Bìr sojaká bidìm pár kwonn kàng kwìb sig ku áni. ");
INSERT INTO jib_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Big wan zu ku jàwá, n wìr kà ya ku jà zyun àràg í jà kùr. ");
INSERT INTO jib_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Big tànn kwonn àkar sí n wan kà ku á shinn-à ni, n sìnn kà ya ku tun agunn vìm nuwá ni, í wà big bìnn kir wann á pyànnwá ni, mi ri màm jwann ku n rag, “Suwú aku nonn, wù kùr Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Big tu wìr ku sháng, n zìg rìg tun-à níng n mìb ku á shinn-à ni mìb mìb. ");
INSERT INTO jib_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Barà big màm jwann kinn rìg ku àdòníng, big í wan zu kàng rìg-à jà kùr-à, n wìr kà ya kàng ku jàwá. A byar-à níng hi big í zìg yag rìg-à ku, jirà abig dab bàg gbam ku á bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Barà big ri zu yag àdòníng, sái big myàng mpìr Kurane, zyun-à zìnnwá í Siman, big sìnn kà ku big gbam rag aku swann atàm bín-à bá dab bàg gbam Yesu áni níng. ");
INSERT INTO jib_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Big bi fòr mà byar zyun big ri bar Golgota, yìr zìnn byar-à níng hi, í akib shinn. ");
INSERT INTO jib_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Big ya Yesu zàn inabi, kwonn ma zàn àban n rag aku wa. Barà ku màg màg fig àdòníng, ku í ngàng rìgwá. ");
INSERT INTO jib_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Barà big dab bàg rìg ku mà atàm bín-à ni àdòníng, big í gàfinn rìg-à jàká buwá mi ri dab shasha jirà abig myàng wà kó ni má dab ji. ");
INSERT INTO jib_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A byar-à níng hi, big shi n myàng gbam sig ku ma zu. ");
INSERT INTO jib_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mà shinnwá ni mà wai, big ba sìnn sig yìr bu-à sa big kànn bàg sig ku níng, n rag, Waning I Yesu Kur Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Big dab bàg gbam kwonn sig ku ma mpìr ajwú big pyànà, zyun águnn vìm nuwá ni, zyun bó águnn vìm súrwá ni. ");
INSERT INTO jib_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mpìrká zyun-à ri wam zu yàr màhàn níng, myàng Yesu n ning shinnbá n swau ku shì, ");
INSERT INTO jib_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","n rag, “Awúsharée, wù zyun-à à dang rag wá dab gbànn rìg lu Shìdun, má mi kàng rìg áyau su sara, to, á zìg zu shinnwú. A tìg wann bi á bín-à ni, wà wù ma í wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun, ma malamká, ma shun àgbamká kàhi, jwann ku àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Big rag, “Ku zìg zu yì hing mpìrká káhi, ama ku zìg zu yì fig shinnwá bàna. Ku dang rag ku í kùr Israila. Aku tìg wann bi á bín-à níng ni ayi myàng, àjirà ayi bir pìkyinnyí á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ku ri sìnn kyinnwá á byar Shìdun, mi ri dinya mpìrká rag, ku í Wùn Shìdun. Ayi myàng kó Shìdun hi má zìg zu ku tàma-à níng, wàníng ma ri zìm ku.” ");
INSERT INTO jib_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mpìr ajwúká big dab bàg gbam kwonn sig ma ku níng, swau ku shì àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Barà àyúnn fòr áyau shinn, fi í sìr dim gban rìg-à jànn-à bidìm pár, hár fòr àsháu sara wà àkamzau. ");
INSERT INTO jib_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Barà àsháu sara sa àdòníng, sái Yesu bar nài abor n rag, “Eli, Eli, lama sabatani?” Yìr jír-à níng í “Shìdunmí, Shìdunmí, bu-à sa à fim wa mì àdòníng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Barà mpìrká zyun-à sar yàr sig màhàn níng fig àdòníng, big dang rag, “Ku ri bar Iliya.” ");
INSERT INTO jib_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nonn fig bàna, sái mpìr zyun áyaubá ni shàr yag, n yag zìg bi soso n du kà á zàn zyun shi rag í shin àban, n sìr gbam á bín-à ni, n ya Yesu a wàníng wa. ");
INSERT INTO jib_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mpìrká zyun-à dà sig níng dang rag, “Ayi shi kim, ayi myàng wà kó Iliya má bi má zìg tìg wann ku.” ");
INSERT INTO jib_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu kig jakàng nài ngbam nímá, á byar-à níng hi ku í wu rìg-à. ");
INSERT INTO jib_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A sai-à níng hi, jà-à big gag dim sig nu nkyun lu Shìdun áni níng, í ki gàfinn rìg-à byar pyànà, daka mà wai hár á jìnn ni. Jànn-à á jìnn ni ning wàni, hár abànká gbànn kìfinn rìg byar pyànà pyànà. ");
INSERT INTO jib_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Shar kiká pù finn rìg, mpìrká bu Shìdun nìnànn nímá ká rì wù sig níng, nann zu kàng mà yonki. ");
INSERT INTO jib_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mpìr káníng hi, zu bi rìg mà shar ki-à ni. Asim barà Yesu dù nann zu mà amir-à ni, big kà yag mà finn swann kyìkyàr-à ni. Mpìrká nìnànn nímá myàng sig big màhàn. ");
INSERT INTO jib_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Barà àgbam sojaká ma sojaká zyun-à ri sar myàng kwonn ma Yesu, myàng barà jànn-à á jìnn ni ning àdòníng, ma buká sa sig níng, big shàr rìg zìnn n rag, “Ajai, ku í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Uwàká nìnànn nímá shi sig màhàn, big sar sig pyunn ninonn nímá mi ri myàng bu-à ri sa. Big í àsàinká bàg bi sig Yesu daka mà Galili, n sa ya sig ku buju. ");
INSERT INTO jib_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ayau uwà káníng hi ni, zyun í Maryamu Magdaliya, ma Maryamu na Yakubu ma Yusufu, ma wà Zabadi. ");
INSERT INTO jib_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Barà kamzau sa àdòníng, sái mpìr bài zyun bi, ku í mpìr-à mà Arimatiya, zìnnwá í Yusufu, ku í wùn sukà Yesu tìnn. ");
INSERT INTO jib_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ku yag fòr mà byar Bilatus ni, n vig wàníng rag a wàníng ya ku ki Yesu. A byar-à níng hi, Bilatus dinya mpìrká buwá abig ya Yusufu ki-à hi. ");
INSERT INTO jib_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A byar-à hi, Yusufu zìg ki-à, n bing kà á jà àpyú mìmìg nímá, ");
INSERT INTO jib_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","n sìnn kà mà shar ki àpyú-à ni, zyun-à ku rì kab sig mà mìr abàn. I byar-à ku zìg abàn ùwài nímá, n tidim nu nkyun amir-à ma kàhi. ");
INSERT INTO jib_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Magdaliya shi sig màhàn, ma Maryamu zyun tìnn, big shi sig mi ri myàng gbam shar ki-à. ");
INSERT INTO jib_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ayúnn-à byar kyàr, àyúnn-à níng hi, í àyúnn Asabar, àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma Farisawaká big yag mà byar Bilatus, ");
INSERT INTO jib_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","n dang rag, “Agbamyí, yi kyab pànn hing bu-à mpìr agim ǹsáng-à níng dang sig sai-à ku shi sig ma yonki níng. Ku rag kwá dù nann zu kàng ma yonki áyau su sara. ");
INSERT INTO jib_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A sìnn kà mpìrká káhi abig sar myàng kwonn ma shar amir-à níng í zyun hár àyúnn su sara, jirà kada yann sukàwá big abig yag ma abig jwi zìg zu ku, ma abig dinya mpìrká rag ku dù nann zu rìghing ma yonki. Wà má àdòníng, ǹsáng-à wà tàma-à níng, má kab wà àkwor-à.” ");
INSERT INTO jib_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus dinya big n rag, “Aning zìg mpìr asa gadiká jirà abig sar myàng kwonn ma amir-à, àràg barà ning ri zìm.” ");
INSERT INTO jib_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Big yag n nà bàg bu zyun ma abàn-à ni, n sìnn kà mpìrká ri sar myàng kwonn ma amir-à hi. ");
INSERT INTO jib_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayúnn Ladi í pyimbyau byar kyàr fig ma bàna, sái Maryamu Magdaliya ma Maryamu zyun, big yag abig myàng amir-à. ");
INSERT INTO jib_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gbìb fig tá bàna, jànn-à í ning rìg-à, wùn aswam Shìdun mà wai wann bi n tìr dù rìg abàn-à níng mà amir-à ni, n shi wann rìg áni. ");
INSERT INTO jib_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mùnnpyànnwá ri ngìg kpàin kpàin. Jàwá mìg shi karr nímá, mi ri ngìg kpàin kpàin tìnn. ");
INSERT INTO jib_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mpìrká zyun-à ri sar myàng kwonn ma amir-à níng, barà big myàng ku àdòníng big shàr zinn. Dìrbá í zwab rìg-à shi rag big wu rìghing. ");
INSERT INTO jib_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A byar-à níng hi, wùn aswam Shìdun dinya uwà káníng n rag, “Kada aning shàr zinn bàna, jir kai bàna ǹ yì hing ning ri yàn kyann Yesu zyun-à big dab bàg gbam sig á bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ku bàna áyág, ku dù nann zu rìghing àràg barà ku dang sig. Aning bi aning myàng byar-à big sìnn kà sig ku. ");
INSERT INTO jib_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aning yag kíni tàma-à níng, aning dinya yann sukàwá big rag, ku dù nann zu rìghing ma yonki mà amir-à ni. Kwá yag jág big nì mà Galili, í byar-à bá myàng ku màhàn. Aning màm jànn bàna.” ");
INSERT INTO jib_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A byar-à hi uwà káníng dù rìg kíni mà amir-à ni, zinn pànn rìg big, ama big ri fig kwonn ma àjwár á pìkyinnbá ni ùwài nímá. Big shàr yag n dinya yann sukà Yesu. ");
INSERT INTO jib_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sái big rag abig myàng níng, mà Yesu. A byar-à hi ku bib kà big n rag, “I soko bigná.” Big bi á byarwá ni, n bìnn kir wann á pyànnwá ni n pànn barwá, n wib ku. ");
INSERT INTO jib_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A byar-à hi Yesu dinya big n rag, “Kada aning shàr zinn bàna. Aning yag dinya wunzàmí big abig yag mà Galili, í byar-à bá myàng mì màhàn.” ");
INSERT INTO jib_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Barà uwà káníng yag rìg kyonnbá àdòníng, sái sojaká káhi áyau ká ri sar kang amir-à níng, kàng yag mà finn swann-à ni, n dinya vinn rìg àgbamká ri twìb swànn bu á pyànn Shìdun ni bar buká sa sig. ");
INSERT INTO jib_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A byar-à hi àgbamká ri twìb swànn bu-à níng bar kwonn àgbamká káhi, big shi kwonn, n kwonn nubá n ya sojaká bài ùwài nímá, ");
INSERT INTO jib_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","n dinya big n rag, “Aning dang rag yann sukàwá big bi á fi-à ni, n jwi rìghing ki-à á sai-à ning ri na aná. ");
INSERT INTO jib_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wà gwamna ma fig hing jír-à níng, yi má, ya sar gbam á shinn ná ni, jirà kada aning kà á jír bàna.” ");
INSERT INTO jib_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A byar-à níng hi soja káníng zìg bài-à, n sa àràg barà àgbamká dinya sig big. Jír-à àgbamká dinya sig sojaká rag abig dang rag yann sukàká jwi rìghing ki Yesu níng, kyann kàng kwìb gban rìghing jànn Yahudawaká bidìm pár hár àràg tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yann sukàká dwib agban zyun-à níng, yag rìg mà Galili mà wùn mwír-à ni, byar-à Yesu dinya sig big rag abig yag níng. ");
INSERT INTO jib_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Barà big myàng ku àdòníng, big wib ku. Ama áyaubá ni, káhi bir fig pìkyinnbá rag í Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A byar-à hi Yesu bi yàr á byarbá ni n rag, “Big ya rìghing mì gbam kó kai bidìm pár mà wai, ma wà á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jir wàníng, aning yag mà byar mpìrká kó áni bidìm pár, aning dinya big jir Shìdun, aning sa abig kàng yann sukàmí big, ma aning wau big dìr batisma á zìnn Ta, ma Wùnwá, ma Awun Kyìkyàr. ");
INSERT INTO jib_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aning tàg big, abig wib buká ǹ dinya sig ning, mì má, má shi kyann ma ning kó ákaun bidìm pár hár àyúnn-à dunyaru má vinn.”");
INSERT INTO jib_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wàníng í jír-à ǹsàn í tai Yesu Kristi, wùn Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jír-à níng shi sig àràg barà Ishaya mpìr-à rìi dang kyann jir Shìdun ba sig rag, “Wùnmí, má swam yag wùn aswammí zyun má kà jag wù á pyànn í ni, jirà aku wàu kyàr ya wù gbìb-à wá bàg áni. ");
INSERT INTO jib_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mpìr zyun-à má swam yag ku níng, ku shi sig mà awúnn-à ni, ku ri dinya mpìrká jírmí rag, ‘Aning wàu kyàr gbìb-à Shinn Luyí má bàg áni. Byar-à gbìb-à gor sig níng, aning wàu lab finn yag rìg mà pyànn.’ ” ");
INSERT INTO jib_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jír-à níng Shìdun ri dang Yohanna zyun-à bi mi ri wau mpìrká dìr batisma mà awúnn-à ni. Ku ri dinya mpìrká rag abig fim bu pyìr sa, ma abig wau dìr batisma, jirà a Shìdun yafa ya big bu pyìrbá. ");
INSERT INTO jib_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","I byar-à mpìrká nìnànn nímá í bi-à á byarwá ni. Mpìrká á jànn Yahudiya ma mpìrká á finn swann Urushalima big nìnànn nímá, big bi á byar Yohanna ni. Big bi, n dang bu pyìrbá big sa sig. Yohanna wau big dìr batisma á finn Ning Urdun. ");
INSERT INTO jib_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanna wìr sig jà zyun-à big zwàu sig ma wai rakumi. Ku sìr gbam sig agau mìrwá big wau. Bujuwá í àtìbàin ma dain. ");
INSERT INTO jib_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ku dinya mpìrká rag, “Mpìr zyun má bi ásimmí ni. Mpìr-à hi kab síg mì nì. N fòr fig wà má kir wann, má fìnn jùr tabarwá bàna. ");
INSERT INTO jib_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bumí mì ri wau ning dìr batisma ma zàpìr. Ama buwá kwá wau ning dìr batisma ma Awun Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A sai-à níng hi, Yesu dù mà Nazarat lu zyun á jànn Galili, n bi fòr á byar Yohanna. Wàníng wau ku dìr batisma á Ning Urdun. ");
INSERT INTO jib_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Barà ku ri nann zu bi mà zàpìr-à ni, í byar-à ku myàng waisháu-à í pù gàfinn-à sa hauu, Awun Shìdun wann bi àràg í àlàb áshinnwá ni. ");
INSERT INTO jib_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","I byar-à big fig nài jír wann bi mà waisháu-à ni, n rag, “Wù í wùn azìmmí, pìkyinnmí ri fig àjwárwú wàni.” ");
INSERT INTO jib_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gbìb fig tá bàna, Awun Shìdun zìg yag rìg ku mà awúnn-à ni. ");
INSERT INTO jib_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Su dìpyànà ku shi màhàn, ku ma wi awúnnká í zyun. Shaitan màg màg fig ku jirà aku sa bu-à bibai. Yann aswamká bu Shìdun bi n myàng kwonn ma ku í zyun. ");
INSERT INTO jib_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sai-à big kìg kà rìghing Yohanna mà tonn fi-à ni, Yesu dù n yag mà jànn Galili, n kyann mi ri dang jir àjwár bu Shìdun màhàn. ");
INSERT INTO jib_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ku dinya mpìrká rag, “Tàma-à níng su-à màg rìghing wà Shìdun má na kùrwá. Ning mpìrká, aning dà finn rìg bu pyìr sa, aning bir pìkyinn á jir àjwár bu Shìdun ni.” ");
INSERT INTO jib_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Barà Yesu yag á nu Ayunn Galili, ku myàng mpìr pyànà ri vinn birgi á zàpìr-à hi ni, jir kai bàna big í mpìr apànn jái big. Mpìr pyànà káníng, zyun zìnnwá í Siman, ma wunzàwá zyun zìnnwá í Andarawus. ");
INSERT INTO jib_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I byar-à Yesu dinya big rag, “Aning bàg bi mì. Barà ning ri pànn jái níng, má tàg ning barà ná pànn zìg bi rag mpìrká á byarmí ni.” ");
INSERT INTO jib_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A byar-à níng hi gbìb fig tá bàna, big dà finn rìg birgibá níng, n bàg yag rìg ku. ");
INSERT INTO jib_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ku yag mà pyànn títi nímá, í byar-à ku dìg mpìr pyànà, big shi sig á finn kòrbá ni. Big ri sa samyib birgibá. Mpìr pyànà káníng, í Yakubu ma wunzàwá Yohanna. Tabá í Zabadi. ");
INSERT INTO jib_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu myàng big n bar big n dang rag, abig bàg ku. Big dù dà fim rìg tabá á finn kòr-à ni, ma mpìrká ri sa swàm ma ku, n bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Big yag fòr á finn swann Kafarnahum. Ayúnn Asabar Yesu yag mà tonn bìr kwonn Yahudawaká ni, mi ri tàg mpìrká jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mpìrká fig sig bu-à ku tàg sig níng big sa mamaki, jir kai bàna bu tàgwá shi sig ma gbam, shi fig àràg bu tàg malamká bigbá bàna. ");
INSERT INTO jib_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Barà ku ri tàg big jír àdòníng, í byar-à mpìr zyun wàu dab sig ku, ku dù nann zu mà tonn bìr kwonn-à ni, n dinya Yesu jír big gbam n rag, ");
INSERT INTO jib_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu mpìr Nazarat, bu-à dù wù ma yi í kai rà? A bi síg jirà á gban rìg yi rà? N yì hing wù, wù í mpìr pìkyinn-à kyìkyàr zyun-à Shìdun dwim bi sig níng.” ");
INSERT INTO jib_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu dinya wàu-à níng hi n rag, “A mib nuwú, á zu bi á dìr mpìr-à níng ni.” ");
INSERT INTO jib_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I byar-à wàu-à níng gbar ning dìr mpìr-à níng, n yan nài yán ngbam nímá, í wà n zu rìg á dìr mpìr-à hi ni. ");
INSERT INTO jib_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Barà mpìrká myàng bu-à Yesu sa sig níng, big bidìm pár big sa mamaki n bib bar dìrbá rag, “Bu-à ku sa sig níng, í kai rà? Ku shi sig ma gbam hár ku ri dang wàuká ri wib jírwá. Jana-à níng yi myàng hing bu tàg àpyú.” ");
INSERT INTO jib_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A byar-à níng hi kinn fig su bàna, tai Yesu kyann kàng kwìb gban rìg jànn Galili. ");
INSERT INTO jib_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu zu á tonn bìr kwonn-à ni n yag mà lu Siman ma Andarawus. Ku ma Yakubu ma Yohanna big yag síg zyun. ");
INSERT INTO jib_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na wà Siman na sig dor awàu. Barà Yesu fòr màhàn àdòníng, big dinya ku. ");
INSERT INTO jib_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A byar-à níng hi, ku dù, n yag mà byar wàníng ni, n pànn wàníng á vù n gbar dù nann wàníng á wai. Awàu-à dà finn rìg wàníng. Wàníng dù nann zu n sa ya big buju. ");
INSERT INTO jib_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Barà kamzau fòr, àyúnn-à kà rìghing, í byar-à mpìrká ya bi Yesu mpìr dorká, ma mpìrká wàu dab sig big níng. ");
INSERT INTO jib_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mpìrká mà finn swann-à ni bidìm pár bi sar sig á nu nkyun-à ni, mi ri myàng kà yag. ");
INSERT INTO jib_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I byar-à Yesu dàb gbam mpìr dor nìnànn nímá, mpìrká dor kim kim. Ku kan zu rìg wàuká á dìr mpìrká ni nìnànn nímá. Ku kan dim big rag abig dang jír bàna, jir kai bàna big yì rìghing ku. ");
INSERT INTO jib_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I pyimbyau yìì nímá, Yesu zu á lu-à ni n yag mà byar-à mpìr bàna màhàn, n vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siman ma jàuwá big dù n yag yàn kyann ku. ");
INSERT INTO jib_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Big yag dìg ku n dinya ku rag, “Mpìrká bidìm pár ri bib yàn kyann wù.” ");
INSERT INTO jib_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ama ku dinya káníng n rag, “Ayi yag mà pyànn, ayi yag mà kauyeká shi kàng kwìb sig áyag, jirà ń dinya mpìrká jir Shìdun, jir kai bàna í bu-à zìg bi sig mì.” ");
INSERT INTO jib_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I byar-à ku dù n kyann yà zu rìg jànn Galili kó áni bidìm pár. Ku ri kà tonn bìr kwonnká bigbá mi ri dang jir Shìdun, mi ri kan zu wàu á dìr mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mpìr àkùnn zyun bi á byar Yesu ni n bìnn kir wann n vig ku rag, “Wà wa zìm hing, à shi sig ma gbam-à wá dàb gbam mì.” ");
INSERT INTO jib_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu fig àdòníng, ku myàng ashi wàníng, ku du yag vùwá n pànn wàníng vù á dìr, n rag, “N zìm hing, á gbam á dorwú ni.” ");
INSERT INTO jib_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gbìb fig tá bàna, dor àkùnn-à í dà finn rìg-à ku, dìrwá í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","I byar-à Yesu twìb ku byur n rag, “A yag, ");
INSERT INTO jib_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","kada á dinya mpìr bu-à ǹ sa sig wù níng bàna, á yag mà lu Shìdun ni, á yag tìya àgbam-à ri twìb swànn bu á pyànn Shìdun ni dìrwú, ma á ya bu màhàn, àràg barà doka Musa dang sig, jirà a mpìrká myàng barà à gbam rìghing níng.” ");
INSERT INTO jib_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama mpìr-à níng yag mi ri dang kyann jír-à hi, hár bi sa Yesu zu fig rag áyau bìr-à ni bàna. Ku í shi rìgwá á myann mà byar-à lu bàna màhàn. Mpìrká bi sig kó áni bidìm pár big ri bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na su pyànà, í byar-à Yesu dù n kàng bi á Kafarnahum. Mpìrká fig ku shi sig mà lu-à ni. ");
INSERT INTO jib_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bìr mpìrká nìnànn nímá kwonn bi á byarwá ni hár kó byar zyun shwìyí nímá dà fig á finn lu-à ni bàna, hár á pyànn nu nkyun-à ni bidìm pár. I byar-à ku dinya big jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","I byar-à mpìr yina swann ya bi ku mpìr-à dìrwá wu tàg rìghing. ");
INSERT INTO jib_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Big bi myàng bìr mpìrká shi kidim rìghing gbìb-à bá kà yag á byar Yesu ni. I byar-à big zìg mpìr dor-à níng, n swann nann zu yag ku mà shinn tonn-à ni mà wai, n sa pòr pùr á byar-à Yesu shi sig, n du kà wann bi mpìr dor-à níng màhàn, ku na sig á syu-à ni. ");
INSERT INTO jib_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Barà Yesu myàng mpìr káníng hi bir hing pìkyinn á byarwá ni níng, í byar-à ku dang rag, “Wùnmí, ǹ yafa ya rìghing wù bu pyìrwú.” ");
INSERT INTO jib_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Malamká ri tàg jir Shìdun níng, káhi shi sig màhàn. Big kyab á kyinnbá ni n rag, ");
INSERT INTO jib_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gborororo! Sáshinn mpìr-à níng ri dang àdòníng rà? Ku ri swau Shìdun. Mpìr-à má yafa ya mpìr bu pyìrwá bàna, sái Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu yì rìghing bu-à big ri kyab á kyinnbá ni. I byar-à ku bib big rag, “Bu-à sa ning ri kyab jír-à níng àdòníng, í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wà ma dinya mpìr dìr wu titag-à níng rag, ‘N yafa ya rìghing wù bu pyìrwú,’ ma wà ma dang rag, ‘A dù nann zu ma á pìnn syuwú, á kyann kyonn,’ í wà áni fonn kab síg nì rà? ");
INSERT INTO jib_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ama má tìya ning rag mì Wùn Mpìr Jíkwìnn, ǹ shi sig ma gbam á dunyaru barà má yafa ya mpìr bu pyìrwá.” I byar-à ku dinya mpìr dìr wu titag-à níng rag, ");
INSERT INTO jib_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A dù nann zu, á pìnn syuwú ma á kàng yag mà luwú ni.” ");
INSERT INTO jib_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Big ri myàng, big rag abig myàng níng, wàníng dù nann zu sa pyar, n pìnn syuwá mì yag rìg-à. I byar-à mpìr káníng swam yan Shìdun n dang rag, “Kai, bu-à yi myàng sig níng, yi taba myàng fig swai bu-à níng bàna.” Big bidìm pár, big sa gban rìg mamaki. ");
INSERT INTO jib_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu dù á finn lu-à ni n yag jakàng mà Ayunn Galili. Ku shi sig mà nu zàpìr-à ni, í byar-à bìr mpìrká yag dìg ku màhàn. Ku ri tàg big jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I byar-à ku dù màhàn, mi ri yag mà pyànn. Ku yag dìg mpìr azìg bài jànn zyun shi sig mà nu swàmwá ni. Zìnn mpìr-à níng í Lawi í wùn Halfa. Yesu myàng ku n dinya ku rag, “A bàg mì.” Lawi dù n bàg ku. ");
INSERT INTO jib_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wàníng zìg yag ku mà luwá ni. Ku ma yann sukàwá big shi mi ri ji buju màhàn. Mpìrká ri zìg bài jànn ma mpìr bu pyìrká, big shi sig màhàn, mi ri ji tìnn. Shinnbá big nìnànn nímá big ri bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Barà big ri ji buju, í byar-à malamká káhi áyau Farisawaká ni myàng àdòníng, n bib yann sukàwá big rag, “Bu-à sa ku ri ji kwonn buju ma mpìr azìg bài jànnká ma mpìr bu pyìrká í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu fig barà big ri bib jírbá àdòníng, í byar-à ku dinya big rag, “Mpìr-à shi sig ma gbam dìr, ku ri yàn fig adàb dor bàna, sái mpìr-à dìrwá ma ri wúwa, í mpìr-à ri yàn kyann adàb dor. N bi sig á dunyaru jirà ń bar mpìr bu pyìrká. N bi fíg á byar mpìrká ri kyab rag big í mpìr sìsàn níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Su zyun yann sukàká bu Yohanna ma Farisawaká ri sìnn nu. I byar-à mpìrká káhi bi á byar Yesu ni, n bib ku rag, “Yann sukàká bu Yohanna ma bu Farisawaká ri sìnn nu, bu-à sa yann sukàká buwú ri sìnn fig nu bàna í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu bib big rag, “Ayúnn-à mpìr zyun ma sìr ban, jàuwá big má sìnn nu rà? Ai bàna. A sai-à àsàin-à zìg sig uwà-à níng ma shi sig áni, big ri sìnn fig nu bàna. ");
INSERT INTO jib_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama àyúnn zyun ki ma zìg rìghing wunù-à níng, àyúnn-à níng hi, jàuwá big má sìnn nu. ");
INSERT INTO jib_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mpìr má zìg fig jà àpyú má kwìb bàg kwonn fig ma jà àkor bàna. Mpìr ma kwìb bàg kwonn hing jà àpyú ma jà àkor, àkor-à má ka zu rìg, má ka bai kab wàrì. ");
INSERT INTO jib_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mpìr má wìr kà fig zàn inabi àpyú á wau àkor bàna. Wà mpìr ma wìr kà hing zàn inabi àpyú á wau àkor, zàn-à má lib ka rìg wau-à, zàn inabi-à ma wau-à bidìm pár má bai rìg. Zàn inabi àpyú sái big wìr kà á wau àpyú.” ");
INSERT INTO jib_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayúnn su zyun í àyúnn Asabar, Yesu ma yann sukàwá big ri wam zu yag á da zyun ni. I byar-à yann sukàká gbar kab zu yìr jímyànn n zwam. ");
INSERT INTO jib_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","I byar-à mpìr Farisawaká bib Yesu rag, “Bu-à sa yann sukàwú big ri sa bu-à á dokayí ni sàn fig wà abig sa àyúnn Asabar bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","I byar-à Yesu bib big n rag, “Asái ning jangga fig bu-à Dawuda rì sa sig bàna rà? Ku fig amor ma mpìrká ku ma káníng ri yag kyìnn í zyun. ");
INSERT INTO jib_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ku kà yag mà lu Shìdun ni, á sai-à Abiyata í àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, n zìg brodi-à big wib sig Shìdun ma kàhi níng, n ji n ya mpìrká buwá a káníng ji tìnn, wà zyun-à sàn fig wà abig ji bàna, sái àgbamká ri twìb swànn bu á pyànn Shìdun ni níng má ji í ni. Ama big ji rìghing.” ");
INSERT INTO jib_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I byar-à ku dinya big rag, “Shìdun màm fíg mpìr dò shinn àyúnn Asabar bàna, ku sìnn sig àyúnn-à hi dò shinn mpìr. ");
INSERT INTO jib_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mì Wùn Mpìr Jíkwìnn, ǹ shi sig ma gbam barà má dang bu-à mpìr má sa àyúnn Asabar.” ");
INSERT INTO jib_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","I byar-à Yesu dù n kà yag kàng mà tonn bìr kwonn-à ni. Ku yag dìg mpìr zyun vù wàníng wu tag rìghing. ");
INSERT INTO jib_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mpìrká káhi shi sig màhàn, mi ri wonn myàng Yesu kó wàníng má dàb gbam mpìr dor-à níng àyúnn Asabar, jirà abig dìg gbìb-à bá dang bai ku. ");
INSERT INTO jib_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","I byar-à Yesu dang jír ma mpìr-à vù-à wu tag sig níng, n rag, “A zu bi á sar á pyànn áyág.” Mpìr-à níng í zu bi-à. ");
INSERT INTO jib_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","I byar-à Yesu bib mpìrká ri myàng ku níng n rag, “Bu-à doka dang sig í kai rà? Sàn sig àyúnn Asabar abig sa bu-à ǹsàn rà, kó bu-à bibai rà? Abig dàb wìm mpìr rà, kó abig fim mpìr aku wu rà?” Big pù fig nu bàna. ");
INSERT INTO jib_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ku myàng káníng pìkyinnwá bi wa ku jir sung gbam káníng. Ku myàng káníng ma àgùnn, í wà n dinya mpìr-à níng rag, a wàníng gbar lafinn vù wàníng. Barà wàníng gbar lafinn vù wàníng àdòníng, í nànn-à hi vù wàníng í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I byar-à Farisawaká dù màhàn n yag dìg mpìrká bu kùr Hirudus, n su kwonn nu ma káníng jirà abig gban rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ma yann sukàwá big dù n yag mà nu ayunn-à ni. Mpìrká nìnànn nímá bàg yag ku. Mpìrká á jànn Galili, ma mpìrká á jànn Yahudiya, ");
INSERT INTO jib_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma ká á Urushalima, ma ká á jànn Idumiya, ma ká mà Ning Urdun mà jann, ma ká mà finn swann Taya ma Sidon. Káníng bidìm pár big fig tai buká ku ri sa níng, big bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bìr mpìrká bi kwonn shi kàng kwìb ku áni hár shi àràg bá tib gban ku atib gban. I byar-à ku dinya yann sukàwá big rag abig zìg bi kòr-à kwá kà áni. ");
INSERT INTO jib_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bu-à sa níng, ku dàb gbam sig mpìr nìnànn nímá, í bu-à sa mpìr dorká yag sim mà byarwá ni, jirà abig tib vù á dìrwá ni jirà abig gbam. ");
INSERT INTO jib_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wàuká dab sig mpìrká níng, sai-à ba myàng hing ku, big ri kù wann á pyànnwá ni, mi ri yan yán, mi ri dang rag, “Wù í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama ku yan ta káníng ma gbam rag, kada abig dinya mpìrká bàna. ");
INSERT INTO jib_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu dù n yag mà wùn mwír zyun, ku bar mpìrká ku ri zìm káníng. ");
INSERT INTO jib_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ku bi shig zu mpìr dwib agban pyànà, aku káníng kyann zyun, aku swam yag káníng aswam, a káníng yag dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ku ya káníng gbam abig kan zu wàu á dìr mpìr. ");
INSERT INTO jib_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wàníng í zìnn mpìr dwib agban pyànàká ku shig zu sig níng. Zyun zìnnwá í Siman, í wà Yesu vim bìr zìnnwá àpyú big bar ku Bitrus. ");
INSERT INTO jib_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","I byar-à mpìr pyànà, Yakubu ma wunzàwá Yohanna, big í yann Zabadi. Ku bar káníng zìnnbá Buwanarjis. Yìr zìnnbá níng, í yann shyù dìng. ");
INSERT INTO jib_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kádà níng í Andarawus, ma Filibus, ma Bartalamawas, ma Matiyu, ma Toma, ma Yakubu wùn Halfa, ma Tadawas, ma Siman Zaloti, ");
INSERT INTO jib_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Yahuda Iskariyoti àsàin-à ya tafinn sig ku níng. ");
INSERT INTO jib_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ku dù n kàng yag mà lu-à ni. Bìr mpìrká kwonn bi kàng á byarwá ni, hár sa ku ma yann sukàká buwá dìg fig pyù barà bá ji buju bàna. ");
INSERT INTO jib_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Barà yiwaiwá big fig àdòníng, big bi n rag bá myàng kwonn ma ku, jir kai bàna mpìrká ri dang rag, “Kwá shàr ǹsáng.” ");
INSERT INTO jib_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Malamká ká bi sig mà Urushalima níng, big myàng àdòníng, n dang rag, “Wàuká ku ri zìg zu á dìr mpìrká ni níng, ku dìg sig gbamwá á byar Baalzabul kùr wàuká, jir kai bàna wàníng shi sig á pìkyinnwá ni.” ");
INSERT INTO jib_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","I byar-à Yesu bar bi mpìr káníng n bib big rag, “Sáshinn Shaitan má kan Shaitan rà? ");
INSERT INTO jib_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Finn jànn zyun-à ma gàfinn hing kyau pyànà, ma ri gbìb shùr, finn jànn-à hi má nonn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Finn lu-à ma gàfinn hing pyànà, finn lu-à hi má shi fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wàníng í barà shi sig áni tìnn, Shaitan ma gàfinn hing pyànà ma ri gbìb shùr, kwá shi fig bàna. Gbamwá má jànn kà rìg. ");
INSERT INTO jib_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Walai mpìr-à má kà mà lu mpìr-à shi sig ma gbam má jwi wàníng ajwú, sái wà kwa sìr gbam hing wàníng, í wà kwá kà yag má jwi bu. ");
INSERT INTO jib_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mì ri dinya ning àjai, kó írì bu pyìr-à wà áni bidìm pár, ma bu-à bibaiká mpìr ri dang, Shìdun má yafa ya ku. ");
INSERT INTO jib_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama mpìr-à ma dang jír àbai á shinn Awun Shìdun, Shìdun má yafa ya fig ku bàna hár kinn kinn, jir kai bàna ku sa sig bu pyìr zyun-à kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bu-à sa Yesu dang àdòníng, í jirà mpìrká dang rag, ku ri sa swàm ma gbam wàu. ");
INSERT INTO jib_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","I byar-à na Yesu ma wunzàwá big bi n sar sig mà myann n swam kà yag aswam rag aku bi. ");
INSERT INTO jib_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bìr mpìrká shi kàng kwìb sig ku áni, í byar-à big dinya ku rag, “Nàwú ma wunzàwú big shi sig mà myann, big rag, á yag.” ");
INSERT INTO jib_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu zìm n rag, “Má tìya ning mpìr zyun-à í nàmí big wunzàmí big.” ");
INSERT INTO jib_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I wà ku myàng mpìrká shi kàng kwìb sig ku áni níng n rag, “Káníng í nàmí ma wunzàmí big. ");
INSERT INTO jib_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mpìr-à ma ri sa bu-à Shìdun ri zìm, ku í nàmí ma wunzàmí ma ajunwàmí.” ");
INSERT INTO jib_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu dù n yag mà nu ayunn-à ni, n shi mi ri tàg mpìrká bu màhàn. Bìr mpìrká kwonn kàng kwìb sig ku áni, big nànn kab gbam. I byar-à ku dù n kà á kòr-à ni. Ku shi sig á finn kòr-à ni, bìr mpìrká sar sig á nu gàin-à ni. ");
INSERT INTO jib_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ku dinya mpìr káníng jírká nìnànn nímá ma tinn jír. Ayau bu-à ku tàg big ku rag, ");
INSERT INTO jib_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aning fig jírmí. Mpìr zyun yag sig mà dawá ni jirà aku minn za. ");
INSERT INTO jib_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Barà ku ri minn za àdòníng, káhi ta kù wann á gbìb-à ni, ayinnbuká bi mì wun ji rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Swaiká káhi ta kù wann sig á jànn abàn-à ni. Jànn-à yan sig á shinn abàn-à hi ni títi nímá. A byar-à níng, nonn fig bàna za-à í nga nann zu rìg-à kíni, jir kai bàna jànn-à hi zwàun fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Barà àyúnn-à nann zu n fàn wann áni àdòníng, jìká í wim wu rìg-à, jir kai bàna adinnká kà zwàun fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Swaiká káhi ta kù kà sig áyau sí, síká hi wài nann zu, n bim nann zu rìg á shinn zaká ni, zaká sa fig yìr bàna. ");
INSERT INTO jib_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Swaiká káhi ta kù wann sig á byar jànn ǹsàn, nga nann zu ǹsàn nímá, n yìm adau wàni, n sa swàb kà yìr wàni. Adau za-à hi shi sig ǹkwònn ǹkwònn nímá, sa hing yìr wàni, yìrká káhi kab dìzyun agban dwib, káhi kab dìb-sara, káhi kab dìb-swana.” ");
INSERT INTO jib_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","I wà ku dang rag, “Mpìr zyun-à ma shi sig ma sung-à kwá fig jír, aku fig.” ");
INSERT INTO jib_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sai-à Yesu dwim gàfinn dìr ma bìr mpìrká, yann sukàwá dwib agban pyànà big ma mpìrká dà sig mà byarbá ni níng, big bib ku yìr jír-à ku dang sig níng. ");
INSERT INTO jib_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","I byar-à ku dinya big rag, “Bigná Shìdun zìm hing aning yì yìr jírwá á shinn barà ku na sig kùrwá ni. Ama mpìrká kádà níng, jírwá shi ya sig big í tinn jír. ");
INSERT INTO jib_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wàníng shi ya sig big àràg barà big ba sig á tarkada Shìdun ni n rag, ‘Bá myàng má myàng jakàng, ama bá myàng yì fig bàna. Bá fig má fig jakàng, ama bá fig yì fig bàna. Nìm ma nímá bàna, big nìm má bi á byar Shìdun, ku nìm má yafa ya big bu pyìrbá.’ ” ");
INSERT INTO jib_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","I wà ku bib big rag, “To, barà ning fig yì fig yìr tinn jír-à níng bàna níng, ná sáshinn má fig yì yìr tinn jírká kádà rà? ");
INSERT INTO jib_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bu-à mpìr-à níng minn yag sig níng, shi sig àràg í jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Swai buká kù wann sig á gbìb-à ni níng, shi sig àràg í mpìrká ma fig hing jir Shìdun, gbìb fig tá bàna, Shaitan bi mi ri zìg rìg bu-à big fig sig á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Swai buká kù wann sig á byar abàn níng, shi sig àràg mpìrká fig sig jir Shìdun ma pìkyinn àjwár. ");
INSERT INTO jib_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama big bir zwàun fig pìkyinnbá áni bàna. Bá shi nonn títi nímá, ama shwìn ma bi dìg hing big jirà big zìg sig jir Shìdun níng, í nànn-à hi big í dà fim rìg-à gbìb-à hi kíni. ");
INSERT INTO jib_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Swai buká kù kà sig áyau sí níng, shi sig àràg mpìrká ri fig jir Shìdun, ");
INSERT INTO jib_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama big ri kyab shwìn dunyaru, big ri zìm bu dunyaru, big ri sa sunu wàni. Bu káníng ri sa big, big ri dà finn jír-à big fig sig, mi ri myàng jír-à hi àràg í bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Swai buká kù wann sig á jànn-à ǹsàn níng, big shi sig àràg í mpìrká ri fig jir Shìdun, mi ri zìg ma kyinn ńzyun, mi ri sa swàm ma kàhi. Big shi sig àràg í swai buká ri sa yìr, káhi yìr dìzyun agban dwib, káhi yìr dìb-sara, káhi yìr dìb-swana.” ");
INSERT INTO jib_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu dinya big tinn jír zyun n rag, “Mpìr ma mònn bàg hing pitila kwá bir dim kwài áni rà, kó kwá sìnn kà á mìr buná rà? Kwá sìnn á shinn bu jirà mpìrká abig myàng àyarwá rà, kó bàna rà? ");
INSERT INTO jib_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bu-à ba tàm sig bidìm pár, bá zìg zu bi rìg á myann, bu-à ba bir dim sig bidìm pár, bá pù fim rìg bu-à hi. ");
INSERT INTO jib_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mpìr-à ma shi sig ma sung-à kwá fig jír, aku fig.” ");
INSERT INTO jib_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ku dinya big rag, “Aning fig jírmí. Tasa-à ning màg ya sig mpìr áni, í tasa-à bá màg ya ning áni tìnn. Má kab wà ning màg ya sig mpìr. ");
INSERT INTO jib_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mpìr zyun-à ma shi ma bu, bá ya swàb kà ya ku. Mpìr zyun-à ma bàna ma kàhi, kó wà títi-à ku shi sig ma kàhi níng, bá zìg rìg á vùwá ni.” ");
INSERT INTO jib_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu dinya big rag “Kùr Shìdun shi sig àràg barà mpìr ri minn yìr bu mà da. ");
INSERT INTO jib_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Fi-à ma sìr, ku na, byar-à ma kyàr ku dù nann zu, hár à myàng wà yìr za-à níng ma nga nann zu hár ma wài hing. Mpìr-à minn sig níng ri yì fig barà ri sa mi ri wài áni bàna. ");
INSERT INTO jib_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jànn-à ma shinnwá í àsàin-à ri sa wài. Wà jijag í swai, í wà bi yìm, í wà n bi sa yìr. ");
INSERT INTO jib_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ayúnn-à za-à ma byann hing í wà kwá zìg kwìnn má gib, jir kai bàna sai-à kwá gib áni fòr rìghing. Wàníng í barà kùr Shìdun shi sig áni.” ");
INSERT INTO jib_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu dang rag, “Má mam kùr Shìdun ma kai rà? Má dinya ning barà kùr Shìdun shi sig áni. ");
INSERT INTO jib_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kùr Shìdun shi sig àràg í yìr masita, yìr bu-à zwau kab sig kádà, wà big ri minn á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mpìr zyun yag minn sig mà dawá ni, bu-à ku minn sig níng wài, n yab ayabwá wài kab jì buká kádà ínì, ayinnbuká bi sa lubá áni.” ");
INSERT INTO jib_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu dinya big jir Shìdun ma tinn jír nìnànn nímá àràg káníng, barà bá fig yì. ");
INSERT INTO jib_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ku ri dinya fig big bu zyun átai bàna, sái ma tinn jír. Ama wà ku ma yann sukàwá big ma ḿpyànn, ku ri dinya kyàr káníng. ");
INSERT INTO jib_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ayúnn-à níng hi àkamzau, ku dinya yann sukàwá big rag, “Ayi pìm zu yag ning mà jann.” ");
INSERT INTO jib_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Big fim bìr mpìrká mà sim, ku shi sig á kòr-à ni, big kà á kòr-à ni, n zìg yag rìg ku. Kòrká kádà shi sig màhàn tìnn. ");
INSERT INTO jib_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I byar-à wàu shyù dù bi ùwài nímá, afag zàpìr ri wìr kà mà yau kòr-à ni. Kòr-à ri zìm aku sib kà wann rìg. ");
INSERT INTO jib_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu na sig á mìr kòr-à ni mà sim. Ku na sìnn sig shinnwá á bu-à big ri na sìnn shinn áni. I byar-à yann sukàwá big bar finn zir ku n dinya ku rag, “Malam, yá wa wu á zàpìr-à ni, á fala fig yi bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I byar-à ku finn zir n yan ta wàu-à ri gbar níng hi, n dinya zàpìr-à hi rag, “A shi kim.” I byar-à wàu-à í na tag wann rìg-à. Byar-à í shi rìg-à yirr. ");
INSERT INTO jib_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ku bib yann sukàwá big rag, “Bu-à sa ning ri shàr zinn àdòníng í jir kai rà? Hár tàma-à níng, ning bàna ma pìkyinn bir rà?” ");
INSERT INTO jib_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","I byar-à big shàr rìg zinn wàni, big bib bar dìrbá n rag, “Mpìr-à níng í ni rà? Hár wàu ma zàpìr ri wib ku.” ");
INSERT INTO jib_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ma yann sukàwá big zu yag mà agunn vù ayunn-à ni mà jann, mà jànn Garasinawa. ");
INSERT INTO jib_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Barà Yesu zu á kòr-à ni àdòníng, mpìr-à wàu dab sig ku níng dù mà byar amirká ni, n bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mpìr-à níng hi ri shi kyann mà byar amirká ni, walai mpìr-à má sìr sar ku, kó ma sarka. ");
INSERT INTO jib_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Big ri sìr bab kyann ku ma sarka, vùwá ma barwá. Ama ku ri gbar gib sarka. Walai mpìr-à shi sig ma gbam-à kwá pànn sar mpìr-à níng hi, jir kai bàna mpìr-à níng hi shi sig ma gbam wàni. ");
INSERT INTO jib_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Fi ma àyúnn, ku ri shi mà yau amirká ni, kwonn ma mwírká tìnn. Ku ri yan kyann yán, ku ri gbar fan pòr dìrwá ma abàn. ");
INSERT INTO jib_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Barà ku myàng yag Yesu pyunn ninonn nímá àdòníng, ku dù bi sa báb, n bìnn kir wann á pyànn wàníng ni, n wib wàníng. ");
INSERT INTO jib_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ku gbam nài gbam n rag, “Bu-à du wù ma mì í kai, Yesu Wùn Shìdun? Mì ri vig wù á zìnn Shìdun ni, kada á ya mì shwìn bàna.” ");
INSERT INTO jib_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bu-à sa ku vig Yesu àdòníng, í jirà wàníng dinya rìghing ku rag, “Wù wàu-à níng, á zu bi á dìr mpìr-à níng ni.” ");
INSERT INTO jib_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","I byar-à Yesu bib ku rag, “Zìnnwú í kai rà?” Ku dang rag, “Zìnnmí í Bìr, jir kai bàna yi nànn hing.” ");
INSERT INTO jib_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I byar-à ku vig Yesu vig vig rag, kada a wàníng kan zu big á jànn-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mà agunn-à níng hi ni, zyùká nìnànn nímá ri yàn ji buju mà adìr mwír-à ni màhàn. ");
INSERT INTO jib_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wàuká vig Yesu n rag, “A tìr yag yi mà yau zyùká ni, á fim yi ayi kà mà dìrbá ni.” ");
INSERT INTO jib_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ku ya big pyù-à, í byar-à wàuká zu bi rìg, n yag kà rìg á dìr zyùká ni. Bìr zyùká hi yag hing dubu pyànà. Big shàr wann kà yag mà nu gàin zàpìr-à ni, mì wa wu vinn rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mpìrká ri kan kyann zyùká níng, shàr yag rìg n yag dinya mpìrká mà finn swann-à ni, ma ká mà kauyeká ni. Mpìrká yag jirà abig myàng bu-à sa sig níng. ");
INSERT INTO jib_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Big bi á byar Yesu ni, n myàng mpìr-à bìr wàuká shi sig á dìrwá ni níng, ku shi sig màhàn, n wìr kà rìghing jà, n shi sig kyinnwá ǹsàn nímá, í byar-à zinn pànn rìg bìr mpìrká. ");
INSERT INTO jib_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mpìrká ká myàng sig bu-à sa sig níng, big dinya bìr mpìrká barà Yesu dàb gbam sig mpìr-à wàuká dab sig ku níng áni, n dinya mpìrká jir zyùká tìnn. ");
INSERT INTO jib_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","I byar-à big kà mi ri vig Yesu rag, aku fim jànnbá. ");
INSERT INTO jib_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Barà ku ri kà á kòr-à ni àdòníng mpìr-à wàuká dab sig níng, vig ku rag aku ma wàníng yag zyun. ");
INSERT INTO jib_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yesu zìm fig bàna, n dinya ku rag, “A kàng yag mà lu-à ni, á dinya mpìrká buwú bu-à Shinn Luwú sa ya sig wù, kwonn ma barà ku myàng sig ashiwú.” ");
INSERT INTO jib_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","I byar-à mpìr-à níng dù n yag mà jànn Dikapolis, mi ri dinya mpìrká bu-à Yesu sa ya sig ku. Mpìrká bidìm pár fig jírwá n sa mamaki. ");
INSERT INTO jib_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kà á kòr-à ni n zu kàng yag mà agunn vù-à ni mà jann, bìr mpìrká kwonn kàng kwìb sig ku áni mà nu zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mpìr zyun áyau àgbamká mà tonn bìr kwonn-à ni zìnnwá í Yayirus, barà ku myàng Yesu àdòníng, ku bìnn kir wann á pyànn wàníng ni, ");
INSERT INTO jib_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","n vig wàníng vig vig n rag, “Wùn uwàmí títi nímá nyàan wu, wúshèní, á bi ma á tib ku vù á dìr jirà aku gbam, ma aku shi wìm zu.” ");
INSERT INTO jib_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I byar-à Yesu ma mpìr-à níng dù n yag. Bìr mpìrká bàg yag ku wàni, big ri tib ku. ");
INSERT INTO jib_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uwà zyun shi sig áni, àsà wàjì ri sa shi ku hár ji dwib agban pyànà. ");
INSERT INTO jib_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ku wa shwìn wàni á vù mpìrká shi sig ma gantí, ku gban vinn rìg bu-à á vùwá ni, ama sa ma fig bàna, mi ri swàb kà yág mà pyànn. ");
INSERT INTO jib_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ku fig rìghing tai Yesu, í byar-à ku yag áyau bìr-à ni ásim Yesu ni, n tib jà wàníng. ");
INSERT INTO jib_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ku dang mà kyinnwá ni rag, “Kó ma tib hing íri jàwá, má gbam rìg.” ");
INSERT INTO jib_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ku tib vùwá á jà Yesu ni, gbìb fig tá bàna, àsà-à ri sa shi ku níng, í gib rìg-à. Ku fig rag gbam dìrwá. ");
INSERT INTO jib_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu yì rìghing rag gbam zu hing á dìrwá ni, gbìb fig tá bàna, ku vim bìr áyau bìr-à ni n bib rag, “Mpìr-à tib jàmí í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yann sukàwá big rag, “A myàng hing barà bìr mpìrká kwonn kàng kwìb sig wù áni mi ri tib wù. Bu-à sa wù ri bib rag mpìr-à tib wù í ni rà níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama í barà Yesu ri zìm aku myàng mpìr-à tib sig ku níng. ");
INSERT INTO jib_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uwà-à níng yì rìghing barà dìrwá gbam rìghing níng, í byar-à azyúnn sa rìg ku, dìrwá zwab rìg. Ku bìnn kir wann á pyànn wàníng ni, n dinya wàníng bu-à sa sig ku. ");
INSERT INTO jib_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I byar-à Yesu dinya uwà-à níng rag, “Wùnmí, pìkyinn birwú à bir sig á byarmí ni níng, dàb gbam rìghing wù, á yag fòr ítau, ma á gbam rìg á dorwú ni.” ");
INSERT INTO jib_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Barà ku ri dang jír àdòníng í byar-à mpìrká káhi bi mà lu Yayirus àgbam á tonn bìr kwonn-à ni, n dang rag, “Wùnwú wu rìghing, bu-à sa wù ri sa shi rag malam í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu gang fig sung á jírbá ni bàna, n dinya Yayirus rag, “A gib kyinn bàna, á bir pìkyinn.” ");
INSERT INTO jib_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ku zìm fig a mpìr zyun bàg yag ku bàna, sái Bitrus ma Yakubu ma Yohanna wunzà Yakubu. ");
INSERT INTO jib_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Barà big yag fòr mà lu Yayirus ni, Yesu myàng bìr mpìrká ri kig nài ki ma nài yán wàni. ");
INSERT INTO jib_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ku kà yag mà yau n rag, “Bu-à sa ning ri yan yán mi ri kig nài ki níng, í jir kai rà? Wùn-à níng wu fig bàna. Ku ri na aná.” ");
INSERT INTO jib_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","I byar-à big jwann ku jonn yawari. Ku rag abig zu yag rìg mà myann. Ku zìg ta wùn-à ma na wùn-à, ma yann sukàwá big, ká shi sig ma ku màhàn, n kà yag mà byar-à wùn-à shi sig. ");
INSERT INTO jib_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ku pànn wàníng á vù-à ni n dang rag, “Talita kumi.” Yìr jír-à níng, í “Wùnshái-à níng, á dù nann zu.” ");
INSERT INTO jib_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gbìb fig tá bàna, wùn-à níng í wìm kàng rìg-à ma yonki, n dù nann zu n kyann kyonn. Jiwá dwib agban pyànà. I byar-à bìr mpìrká sa mamaki wàni. ");
INSERT INTO jib_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ku twìb big byur rag, kada a mpìr fig tai-à níng bàna. I wà ku dinya big rag, abig ya wùn-à buju a wàníng ji. ");
INSERT INTO jib_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu dù mà byar-à níng hi n kàng yag mà finn swannwá ni, yann sukàwá big bàg yag ku. ");
INSERT INTO jib_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ayúnn Asabar ku ri tàg mpìrká bu mà tonn bìr kwonn-à ni. Mpìrká fig sig jírwá níng, big sa mamaki n dang rag, “Mpìr-à níng dìg sig yar-à níng áni rà? Aning myàng barà ku ri sa bu mamaki kim kim. ");
INSERT INTO jib_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wàníng í kapinnta zyun-à í wùn Maryamu níng bàna rà? Wunzàwá big í Yakubu ma Yosi ma Yahuda ma Siman bàna rà? Wàníng í zyun-à ajunwàwá big shi sig ma yi níng bàna rà?” I byar-à big ngàng ku. ");
INSERT INTO jib_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu dinya big rag, “Big ri wib wùn aswam Shìdun kó áni bidìm pár, ama mpìrká á jànnwá ni, ma yiwaiká buwá ma mpìrká á luwá ni big ri ngàng ku, big ri wib fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ku sa sar fig bu mamaki màhàn bàna, sái íri wà ku tib wann mpìr dorká vù á dìr-à ni n dàb gbam big, big nànn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ku sa mamaki wàni, jir kai bàna big bir fig pìkyinn á byarwá ni bàna. I byar-à Yesu yag mà kauyeká shi kàng kwìb sig màhàn níng, mi ri tàg mpìrká jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ku bar kwonn bi yann sukàwá big dwib agban pyànà, n swam yag big pyànà pyànà, n ya big gbam abig kan zu wàu á dìr mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ku dinya big rag abig zìg bu zyun á kyonnbá ni bàna, sái íri tun. Abig zìg buju bàna, abig zìg lúr bàna, abig zìg bài bàna. ");
INSERT INTO jib_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Abig pag tab, ama abig wìr bàg kwonn jà pyànà bàna. ");
INSERT INTO jib_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ku dinya big rag, “Lu-à na kà bidìm pár, aning shi màhàn, hár àyúnn-à na dù á kauye-à hi ni. ");
INSERT INTO jib_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mpìrká ma shà fig ning, ma zìm fig jírná bàna, aning fim lu-à hi, aning pìm kyàr rìg àzwìmká á barná ni, wàníng tàg sig rag big ngàng sig jir Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","I byar-à yann sukàwá big dù n yag, n dinya mpìrká rag a káníng fim bu pyìr sa, abig kàng bi á byar Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Big kan zu wàuká nìnànn nímá á dìr mpìrká ni. Big pàb byìr á dìr mpìr dorká ni nìnànn nímá, n dàb gbam káníng. ");
INSERT INTO jib_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kùr Hirudus fig rìghing tai á shinn buká ri sa níng ni, jir kai bàna mpìrká fig rìghing tai Yesu kó áni bidìm pár. Mpìrká káhi dang rag, “I Yohanna àsàin-à rìi wau mpìrká dìr batisma níng, dù nann zu kàng síg nì. I bu-à sa ku dìg sig gbam, mi ri sa bu mamaki káníng.” ");
INSERT INTO jib_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mpìrká káhi dang rag, “Ku í Iliya.” Káhi dang rag, “Ku í wùn aswam Shìdun àràg yann aswamká bu Shìdun ká rì níng.” ");
INSERT INTO jib_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Barà Hirudus fig tai á shinn Yesu ni, ku dang rag Yesu í Yohanna, wà ku gib kìm sig shinn wàníng níng, wàníng dù nann zu kàng síg nì ma yonki. ");
INSERT INTO jib_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hirudus swam yag rìghing aswam rag abig pànn Yohanna abig sìr ku ma abig ta kà ku á tonn fi-à ni. Hirudus sa sig àdòníng á jir shinn Hirudiyas wà shunwòwá Filibus ku zìg sig níng. ");
INSERT INTO jib_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bu-à sa níng, Yohanna rì dinya kyann Hirudus rag, “Barà à zìg sig wà shunwòwú níng, sàn fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I byar-à hi, Hirudiyas pànn Yohanna á kyinn, mi ri zìm aku gban rìg wàníng. Ama ku dìg fig pyù bàna, ");
INSERT INTO jib_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","jir kai bàna kùr Hirudus ri shàr zinn Yohanna. Ku yì hing wàníng í mpìr sìsàn, í mpìr Shìdun. Ku fim wàníng ítau. Ku ri zìm aku fig jir Yohanna, kó barà bu-à Yohanna ri dinya ku ri wa ku níng. ");
INSERT INTO jib_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hirudiyas dìg sig pyù-à kwá gban Yohanna áni á sai-à Hirudus sa buki wà ku kyab pànn àyúnn-à big mà sig ku áni. Ku bar kwonn bi àgbam swàmwá big ma àgbamká bu sojaká ma àgbam mpìrká á jànn Galili, n sa ya káníng buki. ");
INSERT INTO jib_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A byar-à hi wùn uwà Hirudiyas kà bi n gbìb jau. Jau-à ku gbìb sig níng, jwar ya hing kùr Hirudus ma kyìnnká buwá. I wà ku dinya wùn uwà-à hi rag, “Bu-à wù ma ri zìm bidìm pár, á dinya mì, má ya wù.” ");
INSERT INTO jib_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ku tung ki rag, kó wàníng ma zìm agunn jànnwá vù zyun, kwá ya rìg wàníng. ");
INSERT INTO jib_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I byar-à wùn uwà-à níng yag dìg nàwá n bib nàwá rag, aku vig kai rà? Nàwá dinya ku rag aku dang rag ku ri zìm shinn Yohanna àsàin-à ri wau mpìrká dìr batisma. ");
INSERT INTO jib_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I byar-à hi ku kàng bi kíni, n dinya kùr-à rag, ku ri zìm a wàníng ya ku shinn Yohanna àsàin-à ri wau mpìrká dìr batisma, tàma tàma-à níng á tasa. ");
INSERT INTO jib_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Barà Hirudus fig àdòníng, dìrwá í wu tag rìg-à. Ku kyab barà ku nìm tung sig ki á pyànn kyìnnká buwá ni níng, bai wà kwá ngìngàng. ");
INSERT INTO jib_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","I byar-à ku swam yag soja asar gadi zyun, a wàníng yag zìg bi shinn Yohanna. Wàníng yag mà tonn fi-à ni, n yag gib kìm shinn Yohanna, ");
INSERT INTO jib_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","n zìg bi á tasa-à ni, n ya wùn uwà-à níng. Wùn uwà-à níng zìg n ya yag nàwá. ");
INSERT INTO jib_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Barà yann sukàká bu Yohanna fig tai big gban rìghing ku níng, sái big bi zìg dìrwá n jì kà wann rìg á shar amir-à ni. ");
INSERT INTO jib_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yann aswamká bu Yesu kàng bi n dinya ku bu-à big yag sa sig, ma bu-à big tàg sig. ");
INSERT INTO jib_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Barà big ri dinya ku bu-à big yag sa sig, mpìrká nìnànn nímá ri bi á byarwá ni, káhi ri kàng yag. Hár Yesu ma yann sukàwá big dìg fig pyù barà bá ji buju bàna. I byar-à Yesu dinya yann sukàwá big rag, “Aning bi, ayi yag shi mà byar-à mpìr bàna màhàn, jirà aning dìg pyù-à ná shi ngàng awun.” ");
INSERT INTO jib_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","I byar-à big dù n kà á kòr-à ni, mì yag rìg-à mà byar-à mpìr bàna màhàn. ");
INSERT INTO jib_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Barà mpìrká nìnànn nímá myàng àdòníng, big yì rìghing wà í Yesu ma yann sukàwá big, big dù á lubá ni, n shàr shàu ma bar, n yag fòr jag rìg mà byar-à Yesu ri yag níng. ");
INSERT INTO jib_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Barà Yesu fòr yag n zu á kòr-à ni àdòníng, ku myàng bìr mpìrká kwonn shi sig nìnànn nímá. Ku myàng káníng shi sig àràg àdùnká bàna ma anu. Ku myàng ashi káníng. I byar-à ku kà mi ri tàg káníng bu nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Barà kamzau fòr àdòníng, sai yann sukàwá big bi á byarwá ni n rag, “Byar-à níng í awúnn, kamzau sa rìghing. ");
INSERT INTO jib_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","A dwim mpìr káníng abig yag mà daká ni ma kauyeká shi yàr sig áyág, àjirà abig wann ya shinnbá buju.” ");
INSERT INTO jib_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","I byar-à Yesu dinya yann sukàká big n rag, “Ning ma shinn ná aning ya big buju abig ji.” I byar-à big bib ku n rag, “Wù ri zìm ayi yag wann bi brodi bu dinari dari pyànà, jirà ayi ya big abig ji rà?” ");
INSERT INTO jib_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","I byar-à Yesu bib big n rag, “Ning shi sig ma brodi píná rà? Aning yag myàng.” Big yag myàng, n dinya ku rag, “Brodi swana ma jái pyànà.” ");
INSERT INTO jib_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","I byar-à Yesu dinya yann sukàwá big rag á káníng dinya mpìrká abig shi wann kyau kyau á shinn byann-à ni. ");
INSERT INTO jib_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mpìrká shi wann á jinn ni, kyauká káhi dìb-swana, kyauká káhi dìpyànà agban dwib. ");
INSERT INTO jib_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ku zìg brodi akunn swana ma jái akunn pyànà, n myàng yag zuwá mà wai, n sa ya Shìdun í soko. I wà ku ngir gàfinn brodi awín awín, n ya yann sukàwá big, abig gàfinn ya bìr mpìr káníng. I wà ku ngir gàfinn jái àkunn pyànà káníng n ya big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bìr mpìr káníng ji hár n ji mònn rìg finnbá. ");
INSERT INTO jib_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yann sukàwá big wun kwonn brodi-à ma jái-à dà sig níng, mònn gágsàg dwib agban pyànà. ");
INSERT INTO jib_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ayau mpìrká ji sig brodi-à níng, íri wunùká big fòr hing mpìr dubu swana. ");
INSERT INTO jib_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gbìb fig tá bàna, Yesu dinya yann sukàká buwá big abig kà á kòr-à ni, abig yag jag ku mà agunn vù-à ni mà jann mà Batsaida, sai wà kwa dwim gàfinn hing dìr ma bìr mpìr káníng ḿpyim, í wà kwá yág ni. ");
INSERT INTO jib_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Barà ku dwim gàfinn dìr ma big àdòníng, ku nann yag mà mwír-à ni, n vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Barà bu-à bir rìghing àdòníng, kòr-à shi sig áyau zàpìr-à ni. Yesu shi sig á myann ku áwinwá ni. ");
INSERT INTO jib_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I byar-à ku myàng yag yann sukàká buwá big ri sa shwìn ma kòr ya, wàu-à ri gbar kàng yag big mà sim. Ku shi shi, í pinnpàin, ku dù n yag mà byar káníng ni. Ku ri kyann á shinn zàpìr-à ni. Ku yag nyàan káníng wam zu. ");
INSERT INTO jib_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ama barà big myàng ku ri bi àdòníng, big wà sig rag í wàu. I byar-à big yan yán. ");
INSERT INTO jib_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Big bidìm pár big myàng ku pìkyinnbá gib rìghing. I byar-à ku dinya big rag a pìkyinnbá na tag wann. Ku dinya big rag, “Aning tib wann pìkyinn ná, í mì ǹ bi síg nì, kada aning shàr zinn bàna.” ");
INSERT INTO jib_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","I wà ku bi kà á kòr-à ni á byarbá ni, sái wàu-à í sar rìg-à. Big sa mamaki ùwài nímá, ");
INSERT INTO jib_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","jir kai bàna barà ku ya mpìr nìnànn nímá brodi níng, big yì fig yìr-à bàna. Big í mpìr sung gbam big. ");
INSERT INTO jib_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Big pìm zu yag rìg mà jann. Big yag fòr rìg á jànn Janisarata, n sìr gbam rìg kòr-à á nu zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Barà big zu á kòr-à ni àdòníng, mpìrká myàng yì rag í Yesu. ");
INSERT INTO jib_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Barà big myàng í Yesu níng, big shàr kàng yag mà lubá ni, n kà hing mpìr dorká swann bi á buná-à káníng na sig áni, n zìg bi káníng á byar-à ba fig Yesu ma shi sig màhàn. ");
INSERT INTO jib_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Byar-à kwa yag bidìm pár, kó mà kauye, kó mà finn swann, kó mà da, mpìrká ri swann zìg yag mpìr dorká mà fír-à ni. Big vig ku n rag aku fim mpìr dorká á káníng pànn íri nu jàwá. Ká zyun-à pànn sig nu jàwá níng, big gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mpìr Farisawaká bi á byar Yesu ni kwonn ma malamká ká bi sig mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Big myàng yann sukàwá big káhi ri ji buju ma vù jín, káníng bàg fig sù bu àgbamká n tu fig ma zàpìr ḿpyim bàna. ");
INSERT INTO jib_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisawaká ma Yahudawaká kádà níng ri bàg sù bu yàkúbá. Big ri ji fig buju átai bàna, sai wà ba tu hing vùbá àràg barà shi sig á sùbá ni. ");
INSERT INTO jib_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bu-à ba dìg mà kasuwa-à ni, big ri ji fig bàna, sai wa ba tu hing vùbá. Big shi sig ma gbìbká big ri sìnn sùbá áni kim kim, àràg kwài tu, ma par tu, ma tasa tu. ");
INSERT INTO jib_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I byar-à Farisawaká ma malamká bib ku rag, “Bu-à sa yann sukàwú big ngàng wà bá wib jír bu-à yàkúyí big rì dang sig í jir kai rà? Bu-à sa big ri tu fig vùbá ḿpyim jirà abig ji buju í ni bàna níng í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu dinya big rag, “Ning í mpìrká ri dang jír nu pyànà. Jír-à Ishaya rì ba sig á shinn ná ni níng, í àjai. Ku ba sig jir Shìdun rag, ‘Mpìrká tàma-à níng ri wib mì ma nu átai. Ama big bir fig pìkyinn á byarmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Big ri wib mì ma nu átai, big ri tàg sù bu àgbamká bigbá rì, mi ri sa shi rag í dokamí.’ ");
INSERT INTO jib_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ning sìnn kann rìghing jir Shìdun agang, mi ri bàg bu-à mpìrká ri tàg ning.” ");
INSERT INTO jib_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","I byar-à ku dinya big rag, “Ning sa yì hing barà ná ngàng doka Shìdun jirà aning pànn sù bu yàkúná big. ");
INSERT INTO jib_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa dang rag mpìr aku wib tawá ma nàwá, mpìr-à ma swau tawá kó nàwá abig gban rìg mpìr-à hi. ");
INSERT INTO jib_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama bigná ning ri tàg fig mpìrká àdòníng bàna. Bigná ning ri dang rag wà mpìr-à ma shi sig ma bu-à kwá sa shang tawá ma nàwá áni, ama kwa ya fig káníng bàna, ma dang hing rag, wàníng í kurban wato í bu Shìdun, í nànn-à hi. ");
INSERT INTO jib_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wà ning ma ri tàg big àdòníng, ning ri kan dim mpìr rag aku sa shang tawá ma nàwá bàna. ");
INSERT INTO jib_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","To, barà ning ri sa àdòníng, í barà ning ri sìnn kàng jir Shìdun àràg í bu zyun bàna, jirà aning bàg sù bu yàkúná. Ning ri sa buká kádà nìnànn nímá àdòníng.” ");
INSERT INTO jib_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu bar bi jakàng mpìrká n dinya big rag, “Ning bidìm pár aning gang sung, ma aning fig byann jírmí. ");
INSERT INTO jib_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Walai bu-à mpìr má ji zyun-à má sìnn kàng ku jín, sái bu-à ma zu bi á nu mpìr, í bu-à má sìnn kàng ku jín.  ");
INSERT INTO jib_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mpìr-à ma shi sig ma sung-à kwá fig aku fig.” ");
INSERT INTO jib_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Barà ku dù n kà yag mà lu-à ni, yann sukàká buwá bi bib ku yìr jír-à hi. ");
INSERT INTO jib_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I wà ku bib big rag, “Asái ning má ning fig yì byann fig bàna rà? Bu-à mpìr má ji má sìnn kàng fig ku mpìr bibai bàna, ");
INSERT INTO jib_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","jir kai bàna bu-à ri kà á finn mpìr ri kà fig á kyinnwá ni bàna. Ama ri kà á finnwá ni, mi ri zu kàng á dìrwá ni.” Wàníng Yesu ri tìya mpìrká rag kó buju-à wà áni bidìm pár sàn hing wà jì ji. ");
INSERT INTO jib_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I wà ku dang rag, “Bu-à ri zu bi á kyinn mpìr, í bu-à ri sìnn kàng mpìr jín, ");
INSERT INTO jib_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","jir kai bàna pìkyinn í bu-à mpìr ri kyab bu-à bibai áni, àràg àyái sa, ajwú jwi, ki gban, ");
INSERT INTO jib_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sunu, akyib, mpìr tonn gban, ma wà mpìr ma ri pànn fig shinn bàna, bu wìm, mpìr zìnn swau, shinn gbar dù, bu àning sa. ");
INSERT INTO jib_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bu bibai káníng bidìm pár ri zu bi á kyinn mpìr, mì ri sìnn ku jín.” ");
INSERT INTO jib_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu dù á byar-à hi n yag mà jànn Taya ma Sidon. Ku yag shi á lu zyun ni, n zìm fig a kó ni yì wà ku shi sig màhàn bàna. Ama ku wù jànn sar fig shinnwá bàna. ");
INSERT INTO jib_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uwà zyun shi sig áni, wàu dab sig wùn uwàwá, ku fig tai Yesu, n bi bìnn kir wann á pyànn wàníng ni. ");
INSERT INTO jib_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uwà-à níng hi ku í mpìr Helena, big mà sig ku mà Surofinikiya. Ku vig Yesu rag a wàníng kan zu ya ku wàu-à níng á dìr wùnwá ni. ");
INSERT INTO jib_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I byar-à Yesu dinya ku rag, “Yanká abig ji mònn ma ḿpyim, sàn fig wà abig zìg buju yanká abig ya bái bàna.” ");
INSERT INTO jib_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I byar-à uwà-à níng rag, “Jírwú àjai, Shinn Lumí, ama báiká ri ji buju-à yanká ma ji dà sig.” ");
INSERT INTO jib_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ku dinya uwà-à níng rag, “Barà à dang hing àdòníng á yag kyonnwú. Wàu-à dà fim rìghing wùnwú.” ");
INSERT INTO jib_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uwà-à níng yag mà lu-à ni, n yag dìg wùnwá na sig á buná-à ni, wàu-à dà fim rìghing wàníng. ");
INSERT INTO jib_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu kàng bi mà jànn Taya n wam zu mà Sidon, n yag mà Ayunn Galili n yag mà jànn Dikapolis. ");
INSERT INTO jib_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mpìrká káhi swann ya bi ku mpìr sung àkúnn. Bai wà wàníng má dang jír, í byar-à big vig ku rag aku tib vùwá á dìr mpìr-à níng hi ni. ");
INSERT INTO jib_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ku zìg zu wunù-à níng hi áyau bìr mpìrká ni, n zìg kann wàníng agang n du kà pwai vùwá á sung wàníng ni, n tu sháng, n pànn anam wàníng. ");
INSERT INTO jib_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I byar-à Yesu myàng nann yag zuwá mà wai n tim atim ǹzwàun nímá, n dinya wunù-à níng hi rag, “Efata.” Yìr jír-à níng í “Sungwú aku pù fim.” ");
INSERT INTO jib_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Gbìb fig ta bàna, sung wunù-à níng í pù fim rìg-à, ku kà mi ri dang rag jír kyìkyàr nímá. ");
INSERT INTO jib_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I byar-à Yesu twìb big byur rag kada abig dinya mpìr zyun bàna, ama bidìm pár big yag dinya rìg mpìrká nìnànn nímá jír-à hi. ");
INSERT INTO jib_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mpìrká fig sig jír-à níng, big bidìm pár big sa mamaki. Big dang rag, “Mpìr-à níng sa yì hing kó kai bidìm pár wàni, hár ku ri dàb gbam mpìr sung àkúnn a wàníng fig jír. Ku ri dàb gbam anam àsír a wàníng dang jír.” ");
INSERT INTO jib_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A suká bó ni, bìr mpìrká kwonn jakàng, big dìg fig bu-à bá ji bàna. I byar-à ku bar kwonn yann sukàwá big n dinya big rag, ");
INSERT INTO jib_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mì ri myàng ashi bìr mpìr káníng, jir kai bàna subá sara big shi sig á byarmí ni, big dìg fig bu-à bá ji bàna. ");
INSERT INTO jib_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wà ma dwim hing big rag abig kàng yag mà lu-à ni, bá kù ànù á gbìb-à ni, jir kai bàna mpìrká káhi áyaubá ni bi sig byar pyunn ninonn.” ");
INSERT INTO jib_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I byar-à yann sukàwá big bib ku rag, “Yá dìg bi buju-à yá ya bìr mpìr káníng awúnn-à níng ni áni rà?” ");
INSERT INTO jib_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I byar-à ku bib káníng rag, “Ning shi sig ma brodi àkunn píná rà?” Big dang rag, “Sùmpyànn.” ");
INSERT INTO jib_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ku dinya bìr mpìrká rag abig shi wann á jinn ni, ku zìg brodi àkunn sùmpyànn-à níng hi, n sa Shìdun ísoko, n ngir gàfinn awín awín, n ya yann sukàwá big a káníng ya bìr mpìrká, káníng zìg n ya bìr mpìrká. ");
INSERT INTO jib_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Big shi sig ma àbyìr jái títi nímá, ku zìg n sa Shìdun ísoko, n rag a yann sukàwá big ya bìr mpìrká. ");
INSERT INTO jib_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I byar-à big ji hár finnbá zìr. I wà yann sukàwá big wun kwonn brodi-à ma jái-à dà sig níng, mònn gágsàg sùmpyànn. ");
INSERT INTO jib_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mpìrká màhàn fòr hing dubu yina. I byar-à ku dwim bìr mpìr káníng hi. ");
INSERT INTO jib_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kinn fig su bàna, Yesu ma yann sukàwá big kà á kòr-à ni, n yag mà jànn Dalmanuta. ");
INSERT INTO jib_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisawaká bi á byarwá ni, mi ri sa ku yipyàr, big ri zìm abig màg màg fig ku. I byar-à big rag aku tìya big bu mamaki zyun jirà abig yì wà kwa wann bi síg mà byar Shìdun ni àjai. ");
INSERT INTO jib_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I byar-à hi dìrwá í wu tag rìg-à. Ku rag, “Kai. Bu-à sa mpìrká tàma-à níng ri zìm abig myàng bu mamaki í jir kai rà? Mì ri dinya ning àjai, má tìya fig mpìrká tàma-à níng bu mamaki bàna.” ");
INSERT INTO jib_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I byar-à ku fim big n kà á kòr-à ni, n zu yag rìg mà jann. ");
INSERT INTO jib_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yann sukàwá màm jànn rìghing, big zìg yag kwonn fig ma brodi bàna, bu-à big shi sig ma kàhi, í brodi àkunn zyun í nann-à hi. ");
INSERT INTO jib_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I byar-à ku twìb big byur rag, “Aning pànn shinn ná, kada aning bir pìkyinn ná á yisti Farisawaká ma bu mpìrká bu Hirudus ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I byar-à yann sukàwá big dang jír áyau bar dìrbá ni n rag, “Bu-à sa ku dang àdòníng í jirà yi zìg bi fig brodi bàna níng.” ");
INSERT INTO jib_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu yì rìghing bu-à big ri dang, í byar-à ku dinya big rag, “Bu-à sa ning dang rag ning bàna ma brodi níng, í jir kai rà? Hár tàma-à níng ning yì byann fig bàna rà? Ning í mpìr sung gbam big rà? ");
INSERT INTO jib_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zuná ri myàng bu, sáshinn ning myàng yì fig bàna rà? Sungná ri fig jír, sáshinn ning fig yì fig bàna rà? Ning ri kyab pànn fig bàna rà? ");
INSERT INTO jib_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sai-à ǹ zìg brodi àkunn swana n ngir gàfinn ya mpìr dubu swana níng, ning wun kwonn wà dà níng mònn gágsàg píná rà?” I byar-à big dinya ku rag, “Gágsàg dwib agban pyànà.” ");
INSERT INTO jib_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ku rag, “Wà ǹ zìg brodi sùmpyànn n ngir gàfinn, n ya mpìr dubu yina níng, ning wun kwonn wà dà níng mònn gágsàg píná rà?” Big dinya ku rag, “Gágsàg sùmpyànn.” ");
INSERT INTO jib_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ku bib big rag, “Hár tàma-à níng ning yì byann fig ma bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Big bi á Batsaida, mpìrká káhi ya bi ku mpìr àfau zyun, n vig ku rag aku tib wàníng vù á dìr. ");
INSERT INTO jib_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu zìg zu rìg wunù àfau-à níng á kauye-à ni, n tu sháng á zu wàníng ni, n tib wàníng vù á dìr, n bib wàníng rag, “Wù ri myàng bu rà?” ");
INSERT INTO jib_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I byar-à wunù-à níng myàng nann zu zuwá n rag, “Mì ri myàng mpìrká, ama mì ri myàng big àràg í bínká ri kyánn nì.” ");
INSERT INTO jib_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu tib jakàng vù á zu wunù-à níng ni, í byar-à wunù-à níng myàng finn zuwá ma gbam, zuwá í yar finn rìg-à, ku myàng kyàr rag kó kai bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu dwim ku n rag aku kàng yag mà luwá ni, n dinya ku rag, “Kada á kà mà kauye-à ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","I byar-à Yesu ma yann sukàwá big dù n yag mà kauyeká ni mà Kaisariya Filibi. Barà big ri yag á gbìb-à ni, ku bib yann sukàwá big rag, “Mpìrká ri dang rag mì í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Káníng dinya ku rag, “Big ri dang rag wù í Yohanna awau dìr batisma, kádàkí ri dang rag wù í Iliya, kádàkí ri dang rag wù í mpìr zyun áyau mpìrká ri dang kyann jir Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","I byar-à ku bib big rag, “Bigná, ning ri kyab rag mì í ni rà?” Bitrus dinya ku rag, “Wù í Almasihu Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","I byar-à ku dinya big rag kada ba dang swann. ");
INSERT INTO jib_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","I byar-à ku kà mi ri dinya big rag, “Wùn Mpìr Jíkwìnn má wa shwìn kim kim. Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun, ma malamká má ngàng ku, bá gban rìg ku, áyau su sara kwá dù nann zu kàng ma yonki.” ");
INSERT INTO jib_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ku dang zu kyàr jír-à níng kyàr kyàr. I byar-à Bitrus zìg kann ku agang, n yan ta ku. ");
INSERT INTO jib_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu vim bìr n myàng yann sukàká buwá, í wà ku yan ta Bitrus rag, “A dù á pyànnmí ni, wù í Shaitan, bu-à wù ri kyab níng, wù ri kyab fig bu Shìdun bàna, wù ri kyab bu mpìr.” ");
INSERT INTO jib_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","I byar-à Yesu bar kwonn bìr mpìrká ma yann sukàwá big n dinya big rag, “Mpìr-à ma ri zìm aku bàg mì, aku wann tafinn shinnwá, ma aku zìg shwìn-à má bi á dò jir shinnmí ni, í wà aku bàg mì. ");
INSERT INTO jib_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mpìr-à ma ri zìm shinnwá, kwá dìg fig yonkiwá bàna. Ama mpìr-à ma wann tafinn shinnwá á dò jir shinnmí ni, ma dò jir shinn jir àjwár, kwá dìg yonkiwá. ");
INSERT INTO jib_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wà mpìr ma dìg gban rìg buká á dunyaru, ma dìg fig yonkiwá bàna, buká ku dìg sig níng má swàb kà ya ku kai rà? ");
INSERT INTO jib_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bu-à mpìr má ya jirà aku dìg kàng yonkiwá í kai rà? ");
INSERT INTO jib_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mpìrká tàma-à níng ri sa bu pyìr wàni. Wà mpìr ma shàr zunái barà kwá dinya mpìrká tàma-à níng rag ku í mpìrmí, mì Wùn Mpìr Jíkwìnn má shàr zunáiwá tìnn àyúnn-à ma bi hing ma gbam Tamí, ma yann aswamká bu Shìdun mà wai.” ");
INSERT INTO jib_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","I byar-à ku dinya big rag, “Mì ri dinya ning jir àjai, mpìrká káhi má shi sig ma áni á jànn-à ni, bá wu fig bàna, hár bá myàng àyúnn-à Shìdun má na kùrwá ma gbam.” ");
INSERT INTO jib_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na kù su sùnnjin, Yesu zìg yag Bitrus ma Yakubu, ma Yohanna mà shinnkwìnn-à ni, ku ma káníng shi sig ḿpyànn. Barà big ri myàng ku àdòníng, í byar-à zwánnwá í vim bìr rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jàwá mìg shi karr, walai mpìr zyun-à má tu mìg yì àdòníng á dunyaru. ");
INSERT INTO jib_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I byar-à yann sukà sara káníng myàng Iliya ma Musa mìr gbìb zu, mi ri dang jír ma Yesu. ");
INSERT INTO jib_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bitrus dinya Yesu n rag, “Shinn Luyí, barà yi shi sig áyag níng, sàn hing ayi dab apig sara, zyun í buwú, zyun í bu Musa, zyun í bu Iliya.” ");
INSERT INTO jib_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ku yì fig bu-à kwá dang bàna í bu-à sa ku dang àdòníng, jir kai bàna zinn sa rìghing big. ");
INSERT INTO jib_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Akwor nim dim gban rìghing big, í byar-à nài jír zu bi áyau akwor-à ni n rag, “Wàníng í wùn azìmmí, aning fig jírwá.” ");
INSERT INTO jib_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gbìb fig tá bàna, big rag abig myàng níng, big myàng fig rag mpìr bàna, sái íri Yesu. ");
INSERT INTO jib_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Barà big tìg wann bi mà shinnkwìnn-à ni, Yesu dinya big rag, kada abig dinya mpìr bu-à big myàng sig níng bàna, sái àyúnn-à Wùn Mpìr Jíkwìnn ma dù nann zu kàng hing ma yonki. ");
INSERT INTO jib_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Big dinya fig kó ni bàna. Big bib bar dìrbá rag, “Yìr bu-à ku ri dang rag sái wà Wùn Mpìr Jíkwìnn ma dù nann zu kàng hing níng, í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","I byar-à big bib ku rag, “Bu-à sa malamká dang rag Iliya má bi jág nì, í wà Kristi má bí ni níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu dinya big rag, “Iliya má bi jág nì, kwa bi hing kwá sa samyib kó kai bidìm pár. To, bu-à sa big ba sig rag, ‘Wùn Mpìr Jíkwìnn má wa shwìn kim kim, bá ngàng ku’ níng í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ama mì ri dinya ning, ái Iliya bi rìghing. Mpìrká sa rìghing ku bu barà big ri zìm, àràg barà big ba sig á jir Shìdun ni á shinnwá ni níng.” ");
INSERT INTO jib_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Barà big dìg kwonn ma yann sukàká kádà níng, big myàng bìr mpìrká wàni, kwonn ma malamká, káníng ri sa yipyàr ma yann sukàká. ");
INSERT INTO jib_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Barà mpìrká myàng Yesu àdòníng, big sa mamaki wàni, big shàr yag ma byarwá ni n shà ku. ");
INSERT INTO jib_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu bib yann sukàwá big rag, “Ning ma big ri sa yipyàr á jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mpìr zyun áyau bìr mpìrká ni dang rag, “Malam, ǹ zìg bi sig wùnmí á byarwú ni, jir kai bàna wàu dab sig ku, bai wà kwá dang jír. ");
INSERT INTO jib_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sai-à wàu-à hi ma dù bi hing ku wà sashi, wàníng ri gbar ta ku á jìnn ni, nuwá ri bìm zu ashwib, ku ri zwam nginnwá, dìrwá ri lab gbam. N vig yann sukàwú big rag abig kan zu rìg wàu-à níng, ama big sa sar fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","I byar-à Yesu dinya big rag, “Kai! Bu-à sa ning bir fig pìkyinn á byarmí ni bàna hár tàma-à níng í jir kai rà? N shi ma ning hár ákaun rà? N sa muyar ma ning hár ákaun rà? Aning ya bi mì wùn-à hi.” ");
INSERT INTO jib_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Big zìg bi wùn-à hi á byarwá ni. Barà wàu-à níng myàng Yesu àdòníng, gbìb fig tá bàna, ku gbar ning wùn-à níng, wùn-à níng kù wann á jìnn ni, mi ri bing kàng kwìb byar-à, ashwib ri zu á nuwá ni. ");
INSERT INTO jib_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","I byar-à Yesu bib ta-à rag, “Bu-à hi dìg sig ku ákaun rà?” Ta-à rag, “Dìg sig ku á sai-à ku í wùnshái. ");
INSERT INTO jib_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wàu-à ri gbar ta kà ku á pyìr ma zàpìr, jirà aku wu rìg. To, ama wà wá sa sar bu zyun, á myàng ashiyí, ma á sa shang yi.” ");
INSERT INTO jib_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu bib ku rag, “A dang rag má sa sísar rà? Mpìr-à ma bir hing pìkyinn, kó kai bidìm pár Shìdun má sa ya rìg ku.” ");
INSERT INTO jib_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gbìb fig tá bàna, ta wùn-à níng dang rag, “Mì ri bir pìkyinn, ama pìkyinn birmí zwau, á sa shang mì ń bir swàb kà.” ");
INSERT INTO jib_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Barà Yesu myàng bìr mpìrká ri shàr kwonn bi àdòníng, ku yan ta wàu-à hi n rag, “Wù wàu-à ri sa mpìrká abig kàng mpìr sung àkúnn, ma anam àsír níng, mì ri dinya wù rag á gàb dìr ma ku, kada á kà jakàng á dìrwá ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I byar-à wàu-à níng yan yán n gbar ning dìr wùn-à níng, dìr wùn-à níng ri zwab, í byar-à wàu-à níng gàb rìg dìr ma wùn-à níng. Wùn-à níng na sig, hár mpìrká dang rag ku wu rìghing. ");
INSERT INTO jib_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","I byar-à Yesu pànn wùn-à hi á vù-à ni, n gbar dù nann zu ku. Ku sar dù nann zu á wai. ");
INSERT INTO jib_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Barà Yesu kà yag rìg mà lu-à ni, í byar-à yann sukàwá big bònn bib ku n rag, “Bu-à sa yi kan zu sar fig wàu-à níng bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","I byar-à ku dinya big rag, “Swai wàu-à níng, mpìr má kan zu sar fig átai bàna, sái wà kwa vig hing Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","I byar-à big dù n yag wam zu mà agunn jànn Galili. Ku zìm fig a kó ni yì bàna, ");
INSERT INTO jib_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","jir kai bàna ku ri tàg yann sukàwá big, mi ri dinya káníng rag, “Bá ya kà Wùn Mpìr Jíkwìnn á vù mpìrká ni, bá gban rìg ku, wà ba gban rìghing ku, ama àyúnn-à wà wa sara kwá dù nann zu kàng ma yonki.” ");
INSERT INTO jib_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama big fig yì byann fig yìr jír-à níng bàna. Big ri shàr zinn wà bá bib ku. ");
INSERT INTO jib_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Big bi á Kafarnahum, big kà yag mà tonn-à ni. I byar-à ku bib yann sukàwá big rag, “Bu-à sa ning nìm ri sa yipyàr á gbìb-à ni níng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Big pù fig nubá bàna, jir kai bàna sai-à nìm á gbìb-à ni, big nìm ri sa yipyàr áyau bar dìrbá ni jir mpìr-à má shi àgbam-à áyaubá ni. ");
INSERT INTO jib_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","I byar-à Yesu shi wann á jìnn ni, n bar kwonn yann sukàwá dwib agban pyànà, n dinya káníng rag, “Mpìr-à ma ri zìm aku shi àgbam aku sìnn kàng shinnwá ásim, ma aku shi fàu kó ni.” ");
INSERT INTO jib_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I byar-à ku zìg wùnshái zyun, n sìnn kà áyaubá ni, n pyàr kà wàníng ágàu n dinya big rag, ");
INSERT INTO jib_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mpìr-à ma pànn wùn zyun àràg wùnshái-à níng vù pyànà á jir zìnnmí ni, shi sig àràg ku pànn síg mì. Mpìr-à ma pànn hing mì vù pyànà, shi àràg ku pànn sig àsàin-à swam bi sig mì.” ");
INSERT INTO jib_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohanna dinya ku rag, “Malam, yi myàng mpìr zyun ri kan zu wàu á dìr mpìrká ni ma zìnnwú, yi kan dim rìg ku, jir kai bàna ku ri bàg fig yi bàna.” ");
INSERT INTO jib_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ama Yesu dinya ku rag, “Kada aning kan dim ku bàna, jir kai bàna mpìr-à ma ri sa bu mamaki á zìnnmí ni, á pyànná-à níng, kwá dang fig rag jír-à bibai á shinnmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mpìr-à ma zib fig yi bàna, ku í mpìryí. ");
INSERT INTO jib_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mì ri dinya ning àjai, mpìr-à ma kab zàpìr ma ya hing ning jirà ning í bu Kristi, mpìr-à níng má dìg lada.” ");
INSERT INTO jib_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mpìr-à ma du kà hing wùnshái zyun áyau yann káníng ni, zyun-à bir sig pìkyinn á byarmí ni rag a wàníng sa bu pyìr, má sàn kab abig sìr gbam wann bu wau á wàin mpìr-à níng hi ni, ma abig ta kà rìg ku mà zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wà vùwú ma ri du kà wù rag á sa bu pyìr, á gib tafinn rìg vù-à hi, má sàn káb nì á kà á lu Shìdun ma vù ńzyun, ma wà wá shi kwonn ma vùwú pyànà bidìm pár, bá ta kà wù á lu pyìr,  ");
INSERT INTO jib_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","mà byar-à dwir ri wu fig bàna, pyìr ri dim fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wà barwú ma ri du kà wù á sa bu pyìr, á gib tafinn rìg, má sàn káb nì wà á kà mà lu Shìdun ni ma bar ńzyun, ma wà wá shi kwonn ma bar pyànà má kà mà lu pyìr,  ");
INSERT INTO jib_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","mà byar-à dwir ri wu fig bàna, pyìr ri dim fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wà zuwú ma ri du kà wù rag á sa bu pyìr, á kpab tafinn rìg. Má sàn káb nì á kà lu Shìdun ma zu ńzyun, ma wà wá shi kwonn ma zu pyànà má kà mà lu pyìr, ");
INSERT INTO jib_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","mà byar-à dwir ri wu fig bàna, pyìr ri dim fig bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Bá sa kyàr kó ni àràg barà big ri wìr kà mann á byù. ");
INSERT INTO jib_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mann í bu-à dudor, ama wà ador mann ma zu rìghing, bá sa dor rag ma kai rà? Aning shi àràg í mann, ma aning shi shu pìkyinn na tag áyau bar dìrná ni.” ");
INSERT INTO jib_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","I byar-à Yesu dù mà byar-à níng hi, n yag mà jànn Yahudiya, n pìm zu á Ning Urdun. Bìr mpìrká kwonn bi jakàng á byarwá ni, í byar-à ku tàg big àràg barà ku ri sa bab kyann. ");
INSERT INTO jib_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","I byar-à mpìr Farisawaká bi jirà abig màg màg fig ku. Big bib ku rag, “A dokayí ni, sàn hing wà mpìr aku kan tafinn wàwá rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I byar-à ku bib big rag, “Musa dinya sig ning rag í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Big dinya ku rag, “Musa ya sig doka rag abig ba tarkada ban gban, abig kan tafinn rìg uwà.” ");
INSERT INTO jib_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu dinya big rag, “Bu-à sa Musa ba ya sig ning doka àdòníng, í jirà ning í mpìr sung gbam big. ");
INSERT INTO jib_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sai-à Shìdun rì màm jag sig dunyaru, ku màm wunù ma uwà. ");
INSERT INTO jib_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jir wàníng í bu-à sa wunù má dù dà fim tawá ma nàwá, má yag shi kwonn ma wàwá, ");
INSERT INTO jib_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","jirà abig shi í bu ńzyun. Hár á pyànná-à níng bá shi fig rag pyànà bàna, bá shi í bu ńzyun. ");
INSERT INTO jib_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bu-à Shìdun sìnn kwonn sig, kada mpìr aku gàfinn bàna.” ");
INSERT INTO jib_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Barà big kàng yag mà lu-à ni, yann sukàwá big bib ku jír-à níng. ");
INSERT INTO jib_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I byar-à ku dinya big rag, “Mpìr-à ma kan tafinn wàwá, ma zìg uwà zyun kim, ku ri sa àyái á shinn wàwá ni. ");
INSERT INTO jib_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uwà-à ma fim nuwá ma zìg wunù zyun kim, ku ri sa àyái.” ");
INSERT INTO jib_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Big zìg bi yanká á byarwá ni n rag aku tib káníng vù á dìr. Ama yann sukàwá big yan ta mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Barà Yesu myàng àdòníng, pìkyinnwá bai, ku dinya yann sukàwá big n rag, “Aning fim yanká abig bi á byarmí ni, kada aning kan dim big bàna, jir kai bàna mpìrká ká ma shi àràg yanká níng, bá kà nì mà byar-à Shìdun ri na kùrwá. ");
INSERT INTO jib_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mì ri dinya ning àjai, mpìr-à ma sìnn kàng fig shinnwá àràg kù wùnshái bàna, kwá kà fig byar-à Shìdun ri na kùrwá bàna.” ");
INSERT INTO jib_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I byar-à ku pyàr káníng ágàuwá ni, n tib wann káníng vù á shinn-à ni, n wìr kà ya káníng àsàn. ");
INSERT INTO jib_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Barà ku dù mi ri yag àdòníng, wunù zyun shàr yag n yag bìnn kir wann á pyànnwá ni, n bib ku rag, “Malam ǹsàn, bu-à má sa jirà ń dìg yonki kinn kinn í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","I byar-à Yesu bib ku rag, “Bu-à sa à bar mì mpìr ǹsàn í jir kai rà? Mpìr ǹsàn bàna, sái íri Shìdun awínwá ni. ");
INSERT INTO jib_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A yì rìghing dokaká wá bàg: ‘A gban ki bàna, á sa àyái bàna, á jwi ajwú bàna, á gim ǹsáng bàna, á lir ji mpìr bàna, á wib tawú ma nàwú.’ ” ");
INSERT INTO jib_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I byar-à wunù-à níng dang rag, “Malam, ǹ wib vinn rìghing doka káníng bidìm pár tun sai-à mì í wùnshái hár tàma-à níng.” ");
INSERT INTO jib_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu myàng ku n zìm hing ku, n dinya ku rag, “Dà sig wù bu zyun, á yag wann tafinn rìg buká à shi sig ma kàhi bidìm pár, ma á ya mpìr ashiká bài-à, ma á bi á bàg mì. I wà wá dìg bu-à sàn kab wàníng mà wai.” ");
INSERT INTO jib_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Barà wunù-à níng fig àdòníng, àsà kyag kù kà ku á pìkyinn-à ni, pìkyinnwá í bai rìg-à, kù yag rìgwá, jir kai bàna ku shi sig ma bu wàni. ");
INSERT INTO jib_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu myàng yann sukàwá big n rag, “Shi sig mà shwìn wàni wà mpìr bàiká má kà á byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I byar-à yann sukàká sa mamaki ma jír-à ku dang sig níng. Yesu dinya big rag, “Yanká bumí, shi sig ma shwìn wà mpìr má kà mà lu Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Má fonn kab nì rakumi aku kà á pùr àbònyir, ma wà mpìr bài aku kà á byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Barà yann sukàká fig àdòníng, big sa mamaki wàni, n rag, “Wà má àdòníng, mpìr-à má wìm zu í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu myàng big n rag, “Bu-à mpìr má sa sar fig bàna, Shìdun má sa sar, jir kai bàna walai bu-à má nì kan Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus dang rag, “To, yi fim rìghing kó kai bidìm pár, yi ri bàg wù.” ");
INSERT INTO jib_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","I byar-à Yesu dinya big rag, “Mì ri dinya ning àjai, mpìr-à ma fim luwá, kó wunzàwá big, kó shunwòwá big, kó ajunwàwá, kó nàwá kó tawá, kó yanká buwá, kó jànnwá á jir shinnmí ni, ma dò jir shinn jir àjwár, ");
INSERT INTO jib_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kwá dìg kab buká ku fim sig níng, kwá dìg kàng hár kàun dari, luwá, ma wunzàwá big, ma shunwòwá big, ma ajunwàwá big, ma nàwá, ma yanká buwá, ma jànnwá. Bá ya ku shwìn, ama àyúnn-à wà kinn shinn, Shìdun má ya ku yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mpìrká nìnànn nímá ká shi sig mpìr ùwài tàma-à níng, bá kàng mà sim. Mpìrká kinn fig bu bàna níng, má yag mà pyànn.” ");
INSERT INTO jib_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Big ri yag mà Urushalima. Yesu kà síg nì sukàwá big á pyànn. Sukàwá big sa mamaki wàni. Mpìrká ri bàg yag big ásim níng, big shàr rìg zinn. Ku bar kwonn yann sukàwá big dwib agban pyànà níng, n zìg kann big akur, n dinya káníng bu-à má sa ma ku. ");
INSERT INTO jib_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ku dinya káníng rag, “Aning fig, yi ri yag mà Urushalima mà byar-à bá zìg Wùn Mpìr Jíkwìnn, má ya kà ku á vù àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma malamká. Bá wà ku kwonn, má dang rag abig gban rìg ku. Bá ya kà ku á vù mpìrká ká í Yahudawaká bàna. ");
INSERT INTO jib_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bá màm jwann ku, bá tu wìr ku sháng, bá yang ku ashor, bá gban rìg ku, àyúnn su sara kwá dù nann zu kàng.” ");
INSERT INTO jib_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakubu ma Yohanna, yanká bu Zabadi, big bi á byar Yesu ni n dinya ku rag, “Malam, yi ri zìm á sa ya yi bu-à ya vig wù bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu bib big rag, “Ning ri zìm ń sa yá ning kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Big dinya ku rag, “Sai-à wa na hing kùrwú, yi ri zìm á zìm ayi shi ma wù í zyun, zyun águnn vìm nuwú ni, zyun águnn vìm súrwú ni.” ");
INSERT INTO jib_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu dinya big rag, “Ning yì fig bu-à ning ri vig mì bàna. Wàníng ná wa sar shwìn-à má wa níng rà? Kó ná wau sar dìr batisma-à má wau níng rà?” ");
INSERT INTO jib_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Big dinya ku rag, nn, bá wa sar. I byar-à Yesu dinya big rag, “Shwìn-à má wa níng, í wà zyun-à ná wa. Dìr batisma zyun-à bá wau mì níng, í zyun-à bá wau ning. ");
INSERT INTO jib_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama byar shu águnn vìm numí ni, ma wà águnn vìm súrmí ni, í bigmí bàna, ǹ bàna ma gbam-à má ya mpìr kàhi. I byar shu mpìrká Tamí sa sìnn ya sig big.” ");
INSERT INTO jib_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Barà yann sukà dwib kádà sig níng fig bu-à Yakubu ma Yohanna vig sig Yesu níng, big nànn káníng àgùnn. ");
INSERT INTO jib_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","I byar-à Yesu bar kwonn bi big í byar ńzyun n dinya big rag, “Ning yì hing kùrká á jànn-à ni ri tàg gbam á shinn mpìrká bubá ni. Big ri twìm káníng, mi ri dinya káníng bu-à káníng má sa. ");
INSERT INTO jib_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama buná má shi fig àdòníng áyauná ni bàna, wà mpìr zyun áyauná ni ma ri zìm aku shi àgbam, to, aku shí nì fàuná. ");
INSERT INTO jib_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mpìr-à ma ri zìm aku shí nì wà jijag, to, aku shi fàu kó ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wùn Mpìr Jíkwìnn bi fíg jirà abig sa ya ku bu bàna, ama ku bi síg jirà aku sa ya mpìrká bu, ma aku ya shinnwá jirà mpìrká abig dìg yonki.” ");
INSERT INTO jib_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Big bi fòr á Yariko, barà ku ma yann sukàwá big ri dù á Yariko ni ma bìr mpìrká, wunù àfau zyun, big ri bar ku Bartimawas, ku í mpìr avig bu, ku í wùn Timawas, ku shi sig á kur gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barà ku fig rag í Yesu mpìr Nazarat ri wam zu yág nì, í byar-à ku gbam nài gbam n rag, “Yesu Wùn Dawuda, á myàng ashimí.” ");
INSERT INTO jib_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mpìrká nìnànn nímá yan ta ku rag aku shi kim, ama ku dang swàb kà n rag, “Ayáa, Wùn Dawuda, á myàng ashimí.” ");
INSERT INTO jib_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu sar wann n dang rag abig bar bi ku. I byar-à big bar mpìr àfau-à níng, n dinya ku rag, “A fig àjwár, á dù bi. Ku ri bar wù.” ");
INSERT INTO jib_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ku pù tafinn rìg mayafiwá, n dù nann zu n yag dìg Yesu. ");
INSERT INTO jib_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I byar-à Yesu bib ku rag, “Wù ri zìm ń sá wù kai rà?” Mpìr àfau-à níng dang rag, “Malam, mì ri zìm á sa mì ń myàng ma zumí.” ");
INSERT INTO jib_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I byar-à Yesu dinya ku rag, “A yag kyonnwú, pìkyinnwú à bir sig á byarmí ni níng, dàb gbam rìghing wù.” Gbìb fig tá bàna, ku myàng rag ma zuwá, n bàg yag Yesu. ");
INSERT INTO jib_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Barà big nyàan fòr yag mà Urushalima, big yag fòr á Baitafaji mà Baitanya á byar zyun big ri bar Wùn Mwir Zaitun. Ku swam yag yann sukàwá big pyànà, ");
INSERT INTO jib_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","n dinya káníng rag, “Aning yag mà kauye-à mà pyànn ná ni. Na kà yag hing, ná dìg big sa gbam sig wùn aswannswánn màhàn, wà zyun-à mpìr nann màg fig fig bàna, aning fìnn ya bi mì. ");
INSERT INTO jib_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mpìr-à ma bib ning rag, ‘Bu-à sa ning ri fìnn aswannswánn-à níng, í jir kai rà?’ aning dang rag, ‘I Shinn Luyí dang síg nì rag ayi fìnn ya yag ku. Kwá tìr kàng bi rìg kíni.’ ” ");
INSERT INTO jib_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","I byar-à big yag n yag dìg wùn aswannswánn-à hi, big sa gbam sig á nu nkyun-à ni, á gbìb-à ni. Barà big ri fìnn àdòníng, ");
INSERT INTO jib_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mpìrká sar sig màhàn níng bib big rag, “Bu-à sa ning ri fìnn wùn aswannswánn-à níng í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I byar-à big dinya káníng bu-à Yesu dinya sig big abig dang. Káníng fim big, big yag. ");
INSERT INTO jib_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Big zìg bi wùn aswannswánn-à hi á byar Yesu ni, n wan zu jàbá n bir wann á kwíb-à ni, Yesu nann zu n shi wann áni. ");
INSERT INTO jib_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mpìrká nìnànn nímá jag yag jàbá á gbìb-à ni, mpìrká káhi kyag jì bu á daká ni n jag yag á gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ká kà sig kà pyànn, ma ká á sim, big dang ma gbam rag, “Ayi swam yan Shìdun. Pyib sìsàn aku shi á shinn mpìr-à ri bi á zìnn Shinn Luyí ni níng. ");
INSERT INTO jib_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pyib sìsàn aku shi á shinn kùr bu Tayí Dawuda, wà ri bi níng. Shìdun aku shi bu-à mpìrká má swam yan.” ");
INSERT INTO jib_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I byar-à Yesu kà yag mà finn swann Urushalima, n kà mà lu Shìdun ni, n myàng kó kai bidìm pár. Barà bu-à bir rìghing, ku zu, ku ma yann sukàwá big dwib agban pyànà, big yag mà Baitanya. ");
INSERT INTO jib_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Byar-à kyàr, barà big ri kàng bi mà Baitanya, amor gban ku. ");
INSERT INTO jib_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ku myàng yag mìr bin ating pyunn ninonn nímá, ku yag màhàn, jirà aku myàng wà kó kwá dìg awan áni. Ku yag fòr màhàn, n dìg fig awan áni bàna, sái íri jì, jir kai bàna í sònn-à ating ri wan bàna. ");
INSERT INTO jib_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","I byar-à Yesu dinya bin ating-à níng n rag, “Mpìr má dìg fig rag awan á byarwú ni bàna.” Yann sukàwá big fig bu-à ku dang sig níng. ");
INSERT INTO jib_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Big bi fòr á Urushalima, ku kà yag mà lu Shìdun ni, n kan zu mpìrká ri wann tafinn bu màhàn, ma ká ri wann bu màhàn. Ku gbar bir wann rìg teburká mpìrká ri pyann bài áni níng, ma kujeraká bu mpìrká ri wann tafinn àlàb lu. ");
INSERT INTO jib_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ku kan dim mpìrká rag kada a kó ni swann kà yag bu zyun mà lu Shìdun ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","I byar-à ku tàg mpìrká rag, “Big ba sìnn sig á jir Shìdun ni rag, ‘Lumí, mpìrká bidìm pár má bar rag í byar-à big ri vig Shìdun,’ ama ning sìnn kàng rìghing byar-à hi í byar ajwú jwi.” ");
INSERT INTO jib_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma malamká fig àdòníng, big yàn gbìb-à abig gban ku áni. Ama big ri shàr zinn, jir kai bàna bìr mpìrká fig bu-à ku tàg sig níng, big sa mamaki. ");
INSERT INTO jib_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Barà kamzau sa, í byar-à Yesu ma yann sukàwá big zu rìg á finn swann-à ni. ");
INSERT INTO jib_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Big ri wam zu yag í pyimbyau, í byar-à big myàng bin ating zyun-à Yesu ya ku nài ya níng, ku wim wu rìghing, hár kwonn ma adinnwá. ");
INSERT INTO jib_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bitrus kyab pànn, n dinya ku rag, “Agbamyí, á myàng bin ating zyun-à à ya ku nài ya níng, ku wim rìghing.” ");
INSERT INTO jib_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","I byar-à Yesu dinya big rag, “Aning bir pìkyinn á byar Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mì ri dinya ning àjai, mpìr-à ma dinya shinnkwìnn-à níng rag, ‘A gbìb dù ma mìrwú, ma á yag jann kà shinnwú á zàpìr-à ni,’ bu-à ku dang sig níng, wà kwa sa fig shaka á kyinnwá ni bàna, ma bir hing pìkyinn rag bu-à ku dang sig níng má sa, bu-à hi má sa àjai. ");
INSERT INTO jib_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jir wàníng, mì ri dinya ning, bu-à na vig Shìdun bidìm pár, aning bir kyinn rag ná dìg bu-à hi, ná myàng ná dìg bu-à hi. ");
INSERT INTO jib_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sai-à ning ma ri vig Shìdun, aning yafa ya jàuná big ká ma sa sig ning bu-à bibai, jirà a Taná zyun-à mà wai aku yafa ya ning bu pyìrná.  ");
INSERT INTO jib_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wà na yafa ya fig jàuná big bàna, Taná mà wai má yafa ya fig ning bàna tìnn.” ");
INSERT INTO jib_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Big bi jakàng á Urushalima. Barà ku ri kyann mà lu Shìdun ni, àgbamká ri twìb swànn bu á pyànn Shìdun ni, ma malamká, ma àgbamká, big bi á byarwá ni, ");
INSERT INTO jib_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","n bib ku rag, “Gbam-à wù ri sa bu káníng ma kàhi níng, à dìg sig áni rà? Mpìr-à ya sig wù gbam-à hi í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I byar-à Yesu dinya big n rag, “Má bib ning jír zyun, wà na dinya hing mì, í wà má dinya ning mpìr-à ya sig mì gbam-à mì ri sa bu káníng ma kàhi. ");
INSERT INTO jib_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mpìr-à ya sig Yohanna gbam-à aku wau mpìrká dìr batisma íni rà? I Shìdun rà, kó í mpìr rà? Aning dinya mì.” ");
INSERT INTO jib_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I byar-à big wà jír ma bar dìrbá n rag, “Wà ya dang rag, í Shìdun ya síg Yohanna gbam-à ínì, kwá dang rag bu-à sa yi bir fig pìkyinn á jir Yohanna ni bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kó ayi dang rag, í mpìr ya síg ku nì rà?” Big ri shàr bìr mpìrká, jir kai bàna mpìrká yì rìghing wà Yohanna í mpìr-à ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","I byar-à big dinya Yesu n rag, “Yi yì fig bàna.” Yesu dinya big n rag, “Mì má, má dinya fig ning mpìr-à ya sig mì gbam-à mì ri sa bu káníng ma kàhi níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu dinya big tinn jír n rag, “Mpìr zyun nàm sig da inabi, n pì kàng kwìb sig da-à hi áni, ku kànn sig kàb byar-à mpìr má shi kan bu màhàn, ku kab sig shar jirà abig pinn wìr kà zàn inabi áni. Ku zìg da-à hi n pag mpìrká alaru. Ku dù n yag rìg mà jànn zyun ni. ");
INSERT INTO jib_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Barà awan inabi-à byann, í byar-à ku swam yag fàuwá zyun mà byar anàm bu káníng ni abig ya ku anìwá. ");
INSERT INTO jib_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama anàm bu káníng pànn fàuwá níng n dab dab, n kan kàng yag wàníng vù áyonn. ");
INSERT INTO jib_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","I byar-à ku swam yag jakàng fàuwá zyun, mpìr káníng dab pòr wàníng shinn, n sa wàníng buká sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ku swam yag jakàng fàuwá zyun, big dab gban rìg wàníng. Ku swam yag káhi nìnànn nímá, mpìr káníng gban rìg kádàkí, n dab kádàkí dab dab. ");
INSERT INTO jib_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dà kàng sig í mpìr zyun, wàníng hi í wùnwá wà ku ri zìm wàni. Ku swam yag wùnwá á byar káníng ni n dang rag, ‘Mpìr káníng má wib wùnmí.’ ");
INSERT INTO jib_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","I byar-à anàm bu káníng dinya bar dìrbá rag, ‘Wàníng í àsàin-à má ji gado da-à níng, aning bi ayi gban rìg ku mám, jirà ayi pànn nì da-à níng.’ ");
INSERT INTO jib_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I byar-à big pànn wùn-à níng mì ku í gban rìg-à, n ta yag rìg kiwá mà myann.” ");
INSERT INTO jib_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","I byar-à Yesu bib n rag, “To, buná, á myàngná ni, àsàin da inabi-à níng má sa rág kai rà? Kwá bi má yag gban rìg mpìr káníng, má zìg da inabi-à má ya mpìrká káhi. ");
INSERT INTO jib_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ning jangga fig bu-à big ba sig á jir Shìdun ni bàna rà? Big ba sig rag, ‘Abàn-à mpìr ami buká ngàng sig rag bai níng, í zyun-à big zìg kàng bi n mi kà ágù kinn-à ni, í wà zyun-à sàn kab sig kádà. ");
INSERT INTO jib_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wàníng í Shìdun sa síg nì. A byaryí ni, yi ri myàng í bu mamaki.’ ” ");
INSERT INTO jib_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Agbam Yahudawaká yàn gbìb-à abig pànn sìr ku, jir kai bàna big yì rìghing wà ku ri dáng tinn jír-à níng ma big. Ama big ri shàr zinn bìr mpìrká, í byar-à big dù n fim ku mì yag rìgbá. ");
INSERT INTO jib_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Big swam yag Farisawaká ma mpìrká bu Hirudus á byarwá ni, jirà a káníng tib fig nuwá. ");
INSERT INTO jib_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Big bi á byarwá ni n bib ku rag, “Malam, yi yì hing rag wù í mpìr gwangga, wù ri tàg jir Shìdun á gbìb ǹsàn, wù ri shig fig mpìr bàna, kó ni bidìm pár wù ri myàng í bu ńzyun á byarwú ni. Sàn hing wà ayi wa kùr Kaisar bài jànn rà, kó sàn fig bàna rà? Ayi wa rà, kó ayi wa bàna rà?” ");
INSERT INTO jib_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama Yesu yì rìghing bu-à mà kyinnbá ni, í byar-à ku bib big rag, “Bu-à sa ning ri tib fig numí níng, í jir kai rà? Aning ya bi mì bài àsháu zyun ń myàng.” ");
INSERT INTO jib_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Big ya bi ku, í wà ku bib big rag, “Ma hoto mpìr-à á dìr bài-à ni ma zìnn-à áni níng, í bu ni rà?” Big dinya ku rag, “I bu kùr Kaisar.” ");
INSERT INTO jib_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","I byar-à Yesu dinya big rag, “To, bu-à ma í bu Kaisar, aning ya kàng Kaisar. Bu-à ma í bu Shìdun, aning ya kàng Shìdun.” I byar-à big sa mamakiwá. ");
INSERT INTO jib_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukiyawaká dang rag mpìr má dù nann zu kàng fig ma yonki bàna. Big bi á byar Yesu ni n bib ku rag, ");
INSERT INTO jib_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Malam, Musa ba ya sig yi doka rag, mpìr ma zìg uwà ma mà fig wùn bàna, wà kwa wu rìghing, a wunzàwá zìg kàng uwà-à níng hi, jirà aku mà ya shunwòwá yann. ");
INSERT INTO jib_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yi shi sig ma jír á shinn mpìr zyun, ku shi sig ma wunzàwá big sùnnjin. Mpìr-à níng hi zìg uwà n mà fig wùn bàna, ku wu rìghing. ");
INSERT INTO jib_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wà wa pyànà zìg kàng uwà-à hi, ku ma wàníng mà fig wùn bàna, ku má ku wu rìghing. Wà wa sara-à níng má, àdòníng tinn. ");
INSERT INTO jib_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Big sùmpyànn bidìm pár big zìg yà zu rìg uwà hi, big mà fig wùn bàna, í nànn-à hi uwà-à níng hi í wu rìg-à tìnn. ");
INSERT INTO jib_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, barà big sùmpyànn bidìm pár big zìg yà zu rìghing uwà-à níng, àyúnn-à Shìdun má gbar dù nann zu kàng mpìrká ma yonki, uwà-à níng má shi í bu ni áyaubá ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu dinya big n rag, “Ning yì fig gbam Shìdun ma bu-à big ba sig á jir Shìdun ni bàna, wàníng í bu-à sa ning nang jànn sig gbìb gwangga níng. ");
INSERT INTO jib_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ayúnn-à Shìdun má gbar dù kàng hing mpìr ma yonki, bá shi àràg yann aswamká bu Shìdun mà wai. Mpìrká má zìg fig rag uwà bàna. ");
INSERT INTO jib_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jir wà ki má dù nann zu kàng ma yonki níng, ning jangga fig bu-à Musa ba sig bàna rà? A byar-à ku ba sig á jir Shìdun ni á shinn akyar bín-à pyìr rì swànn áni. Ku ba sig bu-à Shìdun dinya sig ku rag, ‘Mì í Shìdun bu Ibrahim, mì í Shìdun bu Ishaku, mì í Shìdun bu Yakubu.’ ");
INSERT INTO jib_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jír-à níng ri tàg yi rag, mpìrká rì wu sig níng, shi sig ma yonki tàma-à níng. Shìdun í Shìdun ki bàna, ku í Shìdun mpìr-à ma yonki. Ning nang jànn dikina á nang jànn.” ");
INSERT INTO jib_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Malam zyun fig barà big ri dang jír àdòníng, ma barà Yesu dinya big jír ǹsàn nímá níng, í byar-à ku bib Yesu n rag, “Doka zyun-à wài kab kádà í wà áni rà?” ");
INSERT INTO jib_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu dinya ku rag, “Doka-à wài kab sig í wàníng: ‘Aning fig, ning mpìr Israila, Shinn Luyí Shìdun ku í Shìdun ńzyun. ");
INSERT INTO jib_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A zìm Shinn Luwú Shìdun ma kyinn ńzyun, ma gbamwú, ma yonkiwú, ma bu-à wù ri kyab á kyinnwú ni.’ ");
INSERT INTO jib_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Doka-à tib sig wàníng dang rag: ‘A zìm jàuwú àràg barà wù ri zìm shinnwú.’ Doka-à kab pyànà káníng bàna.” ");
INSERT INTO jib_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","I byar-à malam-à níng dang rag, “Barà à dang níng í àjai, Malam! A dang hing rag Shìdun ńzyun, zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A mpìr zìm ku ma kyinn ńzyun, ma bu-à mpìr ri kyab, ma gbam mpìr bidìm pár, ma aku zìm jàuwá àràg barà ku ri zìm shinnwá. Doka pyànà káníng kab hing bu twìb swànn á pyànn Shìdun, kab síg nì kó kai bidìm pár wà big ri ya Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu yì hing rag jír-à wunù-à níng dinya kàng ku níng, sàn hing wàni, í byar-à ku dinya wàníng rag, “A nonn fig ma kùr Shìdun bàna.” A byar-à níng hi, walai mpìr-à wim kyinn n bib kàng ku jír. ");
INSERT INTO jib_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu tàg mpìrká bu mà lu Shìdun ni n rag, “Sáshinn malamká dang rag Almasihu í wùn Dawuda níng rà? ");
INSERT INTO jib_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawuda ma shinnwá Awun Shìdun tàg ku, ku dang rag, ‘Shìdun dinya Shinn Lumí n rag, á bi á shi á vìm numí ni áyág. Má sìnn kà mpìr azíbwú big á mìr barwú ni.’ ");
INSERT INTO jib_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawuda ma shinnwá bar ku Shinn Lumí. To, sáshinn kwá shi wùn Dawuda rà?” Bìr mpìrká fig jírwá ma pìkyinn àjwár. ");
INSERT INTO jib_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Barà Yesu ri tàg big bu í wà ku rag, “Aning pànn shinn ná ma malamká, big ri zìm jà lilor wìr, big ri zìm a mpìrká bib kà kyann big á fir ati-à ni. ");
INSERT INTO jib_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Big ri shig bushuká zyun-à sàn kab sig mà tonn bìr kwonn-à ni ma wà á byar-à mpìrká ma ri sa bùkí. ");
INSERT INTO jib_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Big ri lir ji uwà kiká. Big ri vig Shìdun nunonn nímá jirà a mpìrká myàng big. Shwìn-à bá wa má kab gbam.” ");
INSERT INTO jib_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu shi sig mà byar ashìkáun bài mà lu Shìdun ni, ku myàng barà mpìrká ta kà bài màhàn. Mpìr bàiká nìnànn nímá ta kà bài ùwài nímá. ");
INSERT INTO jib_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","I byar-à uwà ashi zyun bi, ku í uwà ki, ku bi ta kà naira pyànà. ");
INSERT INTO jib_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu bar kwonn yann sukàwá big n dinya káníng rag, “Mì ri dinya ning àjai, bu-à uwà ki-à níng ta kà sig níng, kab hing bu mpìrká bidìm. ");
INSERT INTO jib_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mpìrká kádà níng tinn zu sig áyau bàibá big shi sig ma kàhi, ama uwà-à níng, kó barà ku í mpìr ashi níng, ku ya vinn rìg Shìdun bu-à á vùwá ni. Bàkyinn bu-à ku nìm má wann ji bu áni níng, ku ta kà gban rìghing bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Barà Yesu ri zu á lu Shìdun ni, wùn sukàwá zyun dinya ku rag, “Malam, á myàng barà big mi sig lu-à níng ǹsàn nímá ma abànká ùwài.” ");
INSERT INTO jib_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I byar-à Yesu bib ku rag, “Wù ri myàng lu-à níng wài hing kó? Ayúnn zyun ri bi bá dab gbànn rìg lu-à hi, kó abàn ńzyun má shi fig á shinn jàuwá zyun ni bàna.” ");
INSERT INTO jib_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu shi sig mà Wùn Mwir Zaitun, shi yàr sig mà lu Shìdun, í byar-à Bitrus ma Yakubu ma Yohanna ma Andarawus bi á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Big bònn bib ku n rag, “Malam, bu káníng má sa ákaun rà? Bu-à yá myàng jirà ayi yì wà àyúnn-à hi nyàan fòr í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I byar-à Yesu dinya big rag, “Aning pànn shinn ná, kada aning zìm a mpìr zyun tonn kà ning á gbìb ajànn bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mpìrká nìnànn nímá má bi, bá dang rag big bi sig á zìnnmí ni. Bá dang rag big í Almasihu, bá sa mpìrká nìnànn nímá má nang jànn. ");
INSERT INTO jib_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wà na fig tai kànn kó áni bidìm pár, kada aning gib kyinn bàna, bu káníng má sa àdòníng, ama sai-à dunyaru má vinn níng màg fig ma bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jànn zyun má nu kànn ma jànn zyun. Kùr zyun ma nu kànn ma kùr zyun kó áni bidìm pár á jànn-à ni. Jànn á jìnn ni má ning á swannká ni kim kim á dunyaru, amor má kà á jànn-à ni wàni, ama wàníng ri jag má mìr átai. ");
INSERT INTO jib_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ama aning pànn shinn ná, jir kai bàna bá pànn ning, má zìg yag ning á pyànn agib jír, bá dab ning á tonn bìr kwonnká ni, bá zìg yag ning, ná sar á pyànn gwamnaká ni ma kùrká á dò jir shinnmí ni, jirà aning dinya big jírmí. ");
INSERT INTO jib_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sái wà ba dinya hing mpìrká á dunyaru bidìm pár jir àjwár á shinnmí ni, í wà dunyaru má vinn. ");
INSERT INTO jib_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sai-à ba zìg yag ning mà byar-à bá wà ning kwonn, kada aning shàr zinn rag ning yì fig bu-à ná dang bàna. Shìdun má tìya ning bu-à ná dang, jir kai bàna ná dang fíg nì ma shinn ná bàna, í Awun Shìdun má dang nì. ");
INSERT INTO jib_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mpìr má zìg rìg yiwaiwá, má ya kà á vù mpìrká ni abig gban rìg. Ta má ya kà wùnwá á vù mpìrká ni abig gban rìg. Yanká má ngàng rìg jir tabá ma nàbá, má ya kà káníng á vù mpìrká ni abig gban rìg. ");
INSERT INTO jib_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mpìrká nìnànn nímá má zib ning á dò shinnmí ni. Ama mpìr-à ma wim hing kyinn hár àyúnn-à wà kinn shinn, Shìdun má pinn zu ku.” ");
INSERT INTO jib_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ná myàng bu àzing má shi á lu Shìdun. (Mpìr-à ma ri jangga bu-à mì ri ba níng, aku yì byann.) A sai-à níng hi, mpìrká ma shi sig mà yau jànn Yahudiya, abig shàr yag mà shinnkwìnnká ni. ");
INSERT INTO jib_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mpìr-à ma shi sig mà shinn tonn-à ni, kada aku kà mà finn tonn-à ni ma aku zìg ma bu ḿpyim, í wà aku shàr yág ni, bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mpìr-à ma shi sig mà dawá ni, kada aku shàr kàng yag mà lu-à ni, aku zìg jà, í wà aku shàr yág ni, bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ayúnn-à hi uwàká shi sig ma finn, ma ká shi sig ma yann àjann níng, bá wa shwìn. ");
INSERT INTO jib_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aning vig Shìdun rag àyúnn-à ná shàr shàu-à níng, aku shi áyau dí bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Asai-à hi, mpìrká má wa shwìn wàni, írì shwìn-à big taba wa fig bàna, tun sai-à Shìdun màm sig dunyaru. Mpìr má wa jakàng fig rag írì shwìn-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wà Shìdun nìm ma gib màg gban fig su shwìn-à níng bàna, kó mpìr ńzyun nìm má wìm zu fig bàna. Ama ku gib màg gban sig su shwìn-à hi, jir shinn mpìrká ká ku shig zu sig. ");
INSERT INTO jib_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wà mpìrká ma dinya ning rag, aning myàng, mà Almasihu níng, kada aning zìm bàna. Kó ba dinya ning rag, mà ku bó, aning zìm bàna. Big ri gim ǹsáng. ");
INSERT INTO jib_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mpìr agim ǹsángká má bi, bá rag big í Almasihu, káhi má dang rag big í mpìrká ri dang kyann jir Shìdun. Bá sa bu mamaki kim kim jirà abig gbar nang jànn mpìrká Shìdun shig zu sig, wà big nìm má sa sar. ");
INSERT INTO jib_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aning pànn shinn ná, ǹ dinya rìghing ning bu káníng barà su-à màg fig ma bàna níng. ");
INSERT INTO jib_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Asim shwìn-à mpìrká má wa níng ni, àyúnn má sìr rìg fi, sònn má mìg fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Asuswirká mà waisháu-à ni má kù wann bi rìg á jìnn ni. Bu gbamká shi sig mà wai má ning dìrbá. ");
INSERT INTO jib_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","I byar-à mpìrká má myàng mì, mì Wùn Mpìr Jíkwìnn má wann bi mà wai áyau akwor-à ni. Má kàng bi ma gbam ùwài nímá kwonn ma awàimí. ");
INSERT INTO jib_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Má swam yag yann aswamká bumí big á byarká á dunyaru bidìm pár, jirà abig bar kwonn bi ya mì mpìrká Shìdun shig zu sig. Bá bar kwonn bi big á jànn-à ni bidìm pár, daka mà mìr swann hár mà shinn swann. ");
INSERT INTO jib_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Aning myàng misali á shinn bin ating. Wà na myàng bin ating ma ri twìb jì àpyú, ning yì hing shyù nyàan kù. ");
INSERT INTO jib_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To, wàníng má í àdòníng tìnn, sai-à na myàng buká ǹ dinya sig ning níng ma ri sa, aning yì rag ǹ nyàan kàng bi. ");
INSERT INTO jib_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mì ri dinya ning àjai, mpìrká tàma-à níng má wu vinn fig bidìm pár bàna, sái wà buká ǹ dinya sig ning níng ma sa rìghing. ");
INSERT INTO jib_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Waisháu ma jànn-à á jìnn ni má bab jànn rìg, ama jírmí má vinn fig ávinn bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Walai mpìr-à yì àyúnn-à Wùn Mpìr Jíkwìnn má kàng bi áni. Kó yann aswam Shìdun mà wai má, big yì fig bàna. Kó mì Wùn Shìdun má, ǹ yì fig bàna, sai Shìdun ta-à awínwá ni yì síg nì. ");
INSERT INTO jib_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aning pànn shinn ná, aning shi àzír, ma aning vig kyann Shìdun, jir kai bàna ning yì fig àyúnn-à níng hi bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Má shi àràg barà mpìr dù dà fim sig luwá, n yag sig kyìnn, n ya sìnn sig fàuwá big swàm-à káníng má sísa, ku dinya sig àsàin-à ri sa gadi á luwá ni a wàníng sa kyann gadi-à. ");
INSERT INTO jib_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jir wàníng aning shi àzír, jir kai bàna ning yì fig sai-à má bi bàna. Kó má bi àkamzau rà, kó áyau fi rà, kó pinnpàin rà, kó pyimbyau rà, ning yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kada ń bi dìg ning, ning ri na aná. ");
INSERT INTO jib_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bu-à ǹ dinya sig ning níng, mì ri dinya kó ni bidìm pár. Aning shi àzír.” ");
INSERT INTO jib_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dà sig su pyànà ma wà bá ji àyúnn Pìm Wam Zu ma brodi-à bàna ma yisti. I byar-à àgbamká bu mpìrká ri twìb swànn bu á pyànn Shìdun, ma malamká ri yàn gbìb-à bá bònn pànn Yesu áni jirà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ama big dang rag bá sa fig á sai-à big ri ji bùkí-à níng bàna, jir kai bàna mpìrká má dù ngain. ");
INSERT INTO jib_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Barà ku shi sig mà Baitanya á lu Siman mpìr-à rì shi sig ma dor àkùnn, ku ri ji buju. I byar-à uwà zyun bi ma wùn àkwìnn byìr zyun-à ri ning swìnn ǹsàn, byìr-à hi shi sig ma bài wàni, zìnnwá í nardi. I byar-à uwà-à níng zìg àkwìnn-à hi n dìng kìm á wàin-à ni, n wìr wann Yesu byìr-à hi á shinn-à ni. ");
INSERT INTO jib_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Barà mpìrká káhi myàng àdòníng, big nànn àgùnn n bib bar dìrbá rag, “Bu-à sa uwà-à níng ri sa kìfinn byìr-à níng í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Byìr-à níng big nìm ma wann tafinn hing, big nìm má dìg bài dinari dari sara n nìm má ya mpìr ashiká.” I byar-à big nànn uwà-à níng àgùnn, mi ri zìnn swau ku. ");
INSERT INTO jib_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Yesu dinya big rag, “Aning fim uwà-à níng. Bu-à sa ning ri sa shi ku níng í jir kai rà? Bu-à ku sa sig mì níng, ku sa síg mì bu-à ǹsàn. ");
INSERT INTO jib_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ning ri shi kyann ma mpìr ashiká í zyun kó ákaun, sai-à ning ma ri zìm kó ákaun bidìm pár, ná sa ya big bu-à ǹsàn. Ama yi ma ning má shi kyann fíg zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ku sa sig bu-à sàn sig wà aku sa. Ku pàb síg mì byìr á dìr jir sai-à bá jì mì áni. ");
INSERT INTO jib_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mì ri dinya ning àjai, byar-à ba dang jir àjwár Shìdun kó áni á dunyaru, bu-à ku sa sig níng bá dinya mpìrká, mpìrká má kyab pànn ku áni.” ");
INSERT INTO jib_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuda Iskariyoti zyun áyau yann sukà dwib agban pyànà níng, dù n yag mà byar àgbamká ri twìb swànn bu á pyànn Shìdun ni, jirà aku ya tafinn big Yesu. ");
INSERT INTO jib_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Barà big fig àdòníng, big fig àjwár, n gib nu rag bá ya ku bài. Ku yàn pyù-à kwá wann tafinn ya big Yesu. ");
INSERT INTO jib_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ayúnn wà jijag wà bá ji brodi-à bàna ma yisti níng fòr. Ayúnn-à hi í sai-à big ri gib gban kyann wùn àdùn wà bá ji àyúnn Pìm Wam Zu ma kàhi. Yann sukàká bi n bib Yesu rag, “Wù ri zìm ayi yag sa buju àyúnn Pìm Wam Zu-à níng áni rà?” ");
INSERT INTO jib_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I byar-à Yesu swam yag mpìr pyànà áyaubá ni, n dinya káníng rag, “Aning yag mà finn swann-à ni, ná dìg kwonn ma wunù zyun swann sig àgur zàpìr, aning bàg yag ku ");
INSERT INTO jib_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mà lu-à kwá kà áni, ma aning dinya àsàin lu-à rag, ‘Malam dang rag tonn-à ku ma yann sukàwá má shi má ji buju àyúnn Pìm Wam Zu áni, í wà áni rà?’ ");
INSERT INTO jib_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I wà kwá tìya ning tonn zyun ùwài nímá mà wai, wà big sìnn sig kó kai mà ni. Aning sa sìnn buju àyúnn Pìm Wam Zu-à níng màhàn.” ");
INSERT INTO jib_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yann sukàwá big yag mà finn swann-à ni, n dìg kó kai bidìm pár àràg barà Yesu dinya sig big. I byar-à big sa sìnn buju àyúnn Pìm Wam Zu-à níng màhàn. ");
INSERT INTO jib_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Barà kamzau fòr í byar-à Yesu ma yann sukàwá big dwib agban pyànà níng yag màhàn. ");
INSERT INTO jib_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Big shi mi ri ji buju. I byar-à Yesu dinya big rag, “Mì ri dinya ning àjai, mpìr zyun áyauná ni má wann tafinn mì, í wà zyun-à ri ji buju ma mì níng.” ");
INSERT INTO jib_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Barà big fig àdòníng pìkyinnbá bai wàni, big bib ku zyun zyun n rag, “Shinn Luyí, kó í mì rà?” ");
INSERT INTO jib_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu dinya big rag, “I mpìr zyun áyauná ni barà ning dwib agban pyànà níng. Mpìr-à níng hi í mpìr-à ri swab ji kwonn brodi ma mì á tasa-à ni níng. ");
INSERT INTO jib_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mì Wùn Mpìr Jíkwìnn, má wu àràg barà big ba sig á jir Shìdun ni á shinnmí ni rag má wu níng. Ama mpìr-à má wann tafinn Wùn Mpìr Jíkwìnn níng, kwá wa shwìn, má sàn káb nì wà big nìm ma mà fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Barà big ri ji buju àdòníng, í byar-à Yesu zìg brodi n vig Shìdun, n sa wàníng ísoko, n ngir gàfinn, n ya yann sukàwá big. Ku dinya káníng rag, “Aning zìg, wàníng í dìrmí.” ");
INSERT INTO jib_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","I byar-à ku zìg zàn inabi á kwài n sa Shìdun ísoko, n ya big. Big bidìm pár big wa á kwài-à hi ni. ");
INSERT INTO jib_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ku dinya big rag, “Wàníng í àsàmí zyun-à má kìfinn á dò shinn mpìrká ni nìnànn nímá. I àsà nu-à Shìdun gib ya sig mpìrká. ");
INSERT INTO jib_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mì ri dinya ning àjai, má wa fig rag zàn inabi bàna, sai àyúnn-à má wa wà àpyú-à mà byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Big dài jonn n swam yan Shìdun, mì yag rìg-à mà Wùn Mwir Zaitun. ");
INSERT INTO jib_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu dinya big n rag, “Ning bidìm pár ná shàr tafinn rìg mì, jir kai bàna big ba sig á shinnmí ni, á jir Shìdun ni n rag ‘Shìdun má gban rìg aza àdùn-à, àdùnká má shàr yam rìg.’ ");
INSERT INTO jib_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama sai-à ma dù nann zu kàng hing ma yonki, má yag jág ning nì mà Galili.” ");
INSERT INTO jib_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bitrus dinya ku n rag, “Kó wà jàumí big bidìm pár ma fim rìghing wù, bumí má fim fig wù bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu dinya ku rag, “Mì ri dinya wù àjai, á fi-à níng ni sai-à kwìnn ra aku dab zu aku nu pyànà níng, wá sa yipyàr kàun sara má rag à yì fig mì bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bitrus dang ma gbam n rag, “Kó wà ba rag bá gban bàg kwonn mì big wù má, má sa fig yipyàr rag ǹ yì fig wù bàna.” Jàuwá big kádà níng dang àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Big bi fòr á byar-à big ri bar Gatsemani, í byar-à ku dinya yann sukàwá big rag, “Aning shi wann áyág, má vig Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I byar-à ku zìg Bitrus ma Yakubu ma Yohanna. Pìkyinnwá bai wàni. ");
INSERT INTO jib_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ku dinya káníng n rag, “Pìkyinnmí bai sig wàni, shi rag má wù wu. Aning shi áyág, ama aning shi àzír.” ");
INSERT INTO jib_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ku yag sim mà pyànn títi nímá n bìnn kir wann á jìnn ni, n vig Shìdun rag, wà má sa a Shìdun zìg zu rìg ku á shwìn-à kwá wa níng ni. ");
INSERT INTO jib_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ku dang rag, “Tamí, kó kai bidìm pár wá sa sar, á zìg zu rìg mì áyau shwìn-à má wa níng ni. Ama á bàg bu-à á kyinnmí ni bàna, sái bu-à kyinnwú ri zìm.” ");
INSERT INTO jib_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I byar-à ku bi dìg yann sukàká sara níng, big ri na aná. Ku dinya Bitrus rag, “Siman, wù ri na aná rà? Wá shi fig àzír kó awa ńzyun bàna rà? ");
INSERT INTO jib_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aning shi àzír ma aning vig Shìdun, jirà kada bu-à bibai aku tonn gban ning bàna. Pìkyinn ná ri zìm aning sa bu ǹsàn, ama gbamná fòr fig bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I byar-à ku yag jakàng n vig Shìdun, ku vig jakàng bu-à ku nìm vig sig. ");
INSERT INTO jib_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ku kàng bi jakàng n dìg sukàwá big big ri na aná, jir kai bàna zuná ri dìm big. Big yì fig bu-à bá dinya ku bàna. ");
INSERT INTO jib_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ku kàng bi wà wa sara, ǹ dinya káníng rag, “Hár tàma-à níng, ning ri na aná, mi ri na ngàng dìrná rà? Wà ning na níng, màg hing. Ayúnn-à màg rag hing. Aning myàng, big ri ya kà mì Wùn Mpìr Jíkwìnn á vù mpìrká ri sa bu pyìr. ");
INSERT INTO jib_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aning dù nann zu, ayi yag ning. Aning myàng, mpìr-à má ya tafinn mì níng, ma ku níng.” ");
INSERT INTO jib_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Barà Yesu ri dang jír àdòníng, í byar-à Yahuda mpìr zyun áyau yann sukà dwib agban pyànà níng, bi kwonn ma bìr mpìrká. Big bi kwonn ma kafai ma tun, jir kai bàna shun àgbamká ma malamká ma àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, swam bi síg big nì. ");
INSERT INTO jib_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mpìr zyun-à má ya tafinn Yesu níng, dinya rìghing mpìrká bu-à kwá sa. Ku dinya mpìrká rag, “Mpìr-à na myàng ma kàm pànn ku í mpìr-à ná pànn. Aning pànn gbam ku gbam gbam, ma aning zìg yag ku.” ");
INSERT INTO jib_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gbìb fig tá bàna, Yahuda yag fòr mà byar Yesu ni, n dinya wàníng rag, “Malam, mì ri bib kà wù.” I byar-à ku kàm pànn wàníng. ");
INSERT INTO jib_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","I byar-à mpìrká pànn wàníng n zìg yag rìg wàníng. ");
INSERT INTO jib_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","I byar-à wùn sukà Yesu zyun gbar wàm zu kafaiwá n kyag fàu àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. Ku kyag zu rìg wàníng sung-à. ");
INSERT INTO jib_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","I byar-à Yesu bib bìr mpìr káníng n rag, “Ning bi sig ma kafai kwonn ma tun jirà aning pànn mì níng, mì í mpìr ajwú rà? ");
INSERT INTO jib_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Su ma su bidìm pár yi ma ning ri shi kyann í zyun mà lu Shìdun, mì ri tàg kyann mpìrká, ama ning pànn fig mì bàna. Ama wàníng sa sig àdòníng jirà bu-à mpìrká rìi dang kyann jir Shìdun ba sig níng, aku shi àràg barà big ba sig.” ");
INSERT INTO jib_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","I byar-à yann sukàwá big bidìm pár shàr n fim rìg ku, mì yag rìgbá. ");
INSERT INTO jib_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wùn sukà zyun bàg yag ku. Wùn sukà-à níng hi wìr fig jà bàna, ku bir sig íri mayafi, big pànn ku, ");
INSERT INTO jib_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","í byar-à ku wan tafinn rìg mayafiwá, n shàr yag rìg dìr áyonn. ");
INSERT INTO jib_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Big zìg yag Yesu mà byar àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. I byar-à àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma àgbamká kádà áyaubá ni ma malamká ma shun àgbamká, big bidìm pár big kwonn í byar ńzyun. ");
INSERT INTO jib_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ama Bitrus bàg bi ku ásim pyunn ninonn nímá, hár mà lu àgbam-à áyau mpìrká ri twìb swann bu. Ku shi mà byar-à níng hi, ku ma mpìrká ri sa gadi, ku shi, mi ri jwar pyìr. ");
INSERT INTO jib_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Agbam mpìrká ri twìb swànn bu á pyànn Shìdun, ma àgbamká kádà níng, big yàn kyann mpìrká zyun-à má dang jír á shinn Yesu ni, jirà abig gban rìg ku, ama big dìg fig ku ma jír àbai zyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mpìrká nìnànn nímá gim ǹsáng á shinn Yesu ni, ama jírbá yag fig ńzyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mpìrká káhi sar dù nann zu n gim ǹsáng á shinnwá ni, n dang rag, ");
INSERT INTO jib_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mpìr-à níng dang rag kwá dab gbànn rìg lu Shìdun wà mpìrká mi sig níng, má mi kàng zyun áyau su sara, kwá mi fig àràg bu mpìr bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ama bidìm pár, jírbá yag fig ńzyun bàna. ");
INSERT INTO jib_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","I byar-à àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, sar dù nann zu n bib Yesu rag, “A bàna ma jír-à wá dang á shinn jír-à níng ni rà? Bu-à mpìr káníng ri dang á shinnwú ni níng, í kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama Yesu pànn shi rìg akim, n dang fig jír bàna. Agbam-à áyau mpìrká ri twìb swànn bu níng, bib jakàng ku rag, “Wù í Almasihu Wùn Shìdun rà?” ");
INSERT INTO jib_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu dang rag, “Mì í Wùn Shìdun. Ná myàng Wùn Mpìr Jíkwìnn má shi agunn vìm nu Shìdun ni, kwá wann bi áyau akwor-à ni mà waisháu-à ni.” ");
INSERT INTO jib_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Agbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, gbar ka rìg jàwá n dang rag, “Bu-à sa yá yàn mpìrká káhi abig bi dang kàng jír á shinnwá ni níng, í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ning fig hing barà ku dang bai sig zìnn Shìdun. Ning myàng á shinn?” I byar-à big dang rag, bu bibai-à ku sa sig níng fòr hing wà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","I byar-à mpìrká káhi tu wìr ku sháng n sìr dim rìg zuwá, n fam ku vù n dinya ku rag, “A dinya yi mpìr-à dab sig wù.” Mpìrká ri sar myàng kwonn ma lu Shìdun níng, pànn yag ku n dab ku. ");
INSERT INTO jib_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Barà Bitrus shi sig mà myann á jìnn ni, í byar-à wùn uwà zyun bi, ku í wùn lu àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ku myàng barà Bitrus shi, mi ri jwar pyìr àdòníng, ku myàng wàníng n dang rag, “Wù má, wù nìm shi kwonn sig ma Yesu mpìr Nazarat.” ");
INSERT INTO jib_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama Bitrus sa yipyàr n rag, “N yì fig bu-à wù ri dang níng bàna.” A byar-à níng hi, ku í zu yag rìg-à mà gbà dán-à ni. ");
INSERT INTO jib_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wùn uwà-à níng myàng ku n dinya jakàng mpìrká sar yàr sig ma ku níng n rag, “Mpìr-à níng má, ku í bu Yesu tìnn.” ");
INSERT INTO jib_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bitrus sa jakàng yipyàr rag, “bàna.” Shi kàng títi nímá, mpìrká sar yàr sig ma ku níng, dinya ku rag, “Wù má, wù áyaubá ni àjai, jir kai bàna wù í mpìr Galili.” ");
INSERT INTO jib_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","I byar-à Bitrus dang rag, “N tung hing shinnmí ma Shìdun, ǹ yì fig mpìr-à ning ri dang níng bàna.” ");
INSERT INTO jib_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Gbìb fig tá bàna, kwìnn dab zu aku nu pyànà. Bitrus kyab pànn jír-à Yesu dinya sig ku rag, “Sai-à kwìnn ra aku dab zu aku nu pyànà níng, wá sa yipyàr kàun sara má rag à yì fig mì bàna.” Barà ku kyab pànn àdòníng ku kig mínn wàni. ");
INSERT INTO jib_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","I pyimbyau yìì nímá, àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma shun àgbamká ma malamká ma àgbamká kádà níng big kwonn í byar ńzyun n dang jír á shinn Yesu ni. Big pànn Yesu n sìr ku n zìg yag ku n ya kà ku á vù gwamna. Gwamna-à hi zìnnwá í Bilatus. ");
INSERT INTO jib_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus bib Yesu rag, “Wù í kùr Yahudawaká rà?” Yesu zìm n dang rag, “Aràg barà à dang níng.” ");
INSERT INTO jib_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","I byar-à àgbamká áyau mpìrká ri twìb swànn bu tìr ya ku jír nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatus bib jakàng ku rag, “A bàna ma bu-à wá dang rà? A fig swai jírká big ri zìg bi á shinnwú ni nìnànn nímá níng.” ");
INSERT INTO jib_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama Yesu pù fig nuwá bàna, í byar-à Bilatus sa mamaki. ");
INSERT INTO jib_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A sai-à mpìrká ma ji buju àyúnn Pìm Wam Zu, àyúnn-à níng Bilatus ri zìg zu kyann mpìr zyun áyau ká big kìg kà sig mà tonn fi-à ni, wà zyun-à mpìrká ma vig hing ku rag aku zìg zu. ");
INSERT INTO jib_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ayau mpìrká big kìg kà sig mà tonn fi-à ni níng, mpìr zyun shi sig áni, big ri bar ku Barabas. Ku sa big nu hing kànn ma finn swann-à ni hár ku gban sig ki. ");
INSERT INTO jib_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bìr mpìrká kwonn í byar ńzyun n vig Bilatus rag aku zìg zu ya big mpìr zyun àràg barà ku ri sa bab kyann. ");
INSERT INTO jib_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus bib big rag, “Ning ri zìm ń zìg zu ya ning kùr Yahudawaká rà?” ");
INSERT INTO jib_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ku yì hing rag í jir akyib, í bu-à sa àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng big ya kà sig Yesu á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni kar zìng bìr mpìrká rag abig vig Bilatus a wàníng zìg zu ya sòr big Barabas. ");
INSERT INTO jib_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatus bib jakàng big n rag, “To, má sáshinn ma mpìr-à ning ri bar ku kùr Yahudawaká níng rà?” ");
INSERT INTO jib_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","I byar-à big wa nài yán n rag, “A dab bàg gbam rìg ku á tàm bín-à ni.” ");
INSERT INTO jib_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","I byar-à Bilatus bib big rag, “I jir kai rà? Bu-à bibai-à ku sa sig í kai rà?” Big yan swàb kà nài yán n rag, “A dab bàg gbam rìg ku.” ");
INSERT INTO jib_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus ri zìm a bìr mpìrká fig àjwárwá, í byar-à ku zìg zu ya big Barabas, n zìg Yesu n du kà big yang wàníng ashor, n ya á vù sojaká ni, a káníng dab bàg gbam rìg wàníng mà bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sojaká zìg yag Yesu mà lu gwamna. Big bar kwonn sojaká kádà. ");
INSERT INTO jib_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Big wìr kà ku jà zyun àràg í jà kùr, n tànn kwonn àkar sí n wan kà ku á shinn-à ni. ");
INSERT INTO jib_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","I byar-à big bib kà ku n rag, “A suwú nonn, wù kùr Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Big zìg tun n mìb wann ku á shinn-à ni mìb mìb, n tu wìr ku sháng. Big bìnn kir wann á jìnn ni n sa shi rag big ri wib ku. ");
INSERT INTO jib_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Barà big màm jwann kinn rìg ku àdòníng, í byar-à big í wan zu kàng rìg-à jà-à big wìr kà ya sig ku àràg í jà kùr níng, n wìr kà ya kàng ku jàwá. Big zìg zu yag ku mà myann jirà abig dab bàg gbam rìg ku á bín-à ni. ");
INSERT INTO jib_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mpìr zyun big ri bar Siman, ku ri kàng bi mà kauye, ku í mpìr Kurane. Ku í ta Alizanda ma Rufas. Big du kà ku big gbam rag aku swann atàm bín-à bá dab bàg gbam Yesu áni níng. ");
INSERT INTO jib_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Big zìg bi Yesu á byar zyun big ri bar Golgota. Yìr zìnn-à níng hi í akib shinn. ");
INSERT INTO jib_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Big zìg ya ku zàn inabi, big vù kwonn sig ma zàn gantí zyun big ri bar mur. Ama ku wa fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","I byar-à big dab bàg gbam ku mà bín-à ni, n gàfinn jàká buwá n dab shasha ma kàhi, jirà abig myàng wà zyun-à kó ni má dab ji buwá. ");
INSERT INTO jib_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sai-à big dab bàg gbam sig ku á bín-à ni níng, í àsháu ajinndúbi í pyimbyau. ");
INSERT INTO jib_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Big ba sìnn sig yìr bu-à sa big kànn bàg gbam sig ku níng n rag, “Kùr Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Big dab bàg gbam kwonn sig ku ma mpìr ajwú big pyànà, zyun águnn vìm nuwá ni, zyun bó águnn vìm súrwá ni.  ");
INSERT INTO jib_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wàníng sa sig àràg barà big ba sig á jir Shìdun ni rag, “Big wànn bàg kwonn ku ma mpìrká sa sig bu-à bibai.” ");
INSERT INTO jib_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mpìrká ká ri wam zu yàr màhàn níng, big ning shinnbá n swau ku shí n rag, “Awúsharée, à dang rag wá wab gbànn rìg lu Shìdun, má mi kàng rìg áyau su sara. ");
INSERT INTO jib_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","To, á zìg zu shinnwú á bín-à ni, ma á tìg wann bi.” ");
INSERT INTO jib_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma malamká màm jwann ku n rag, “Ku zìg zu yì hing mpìrká, ama ku zìg zu yì fig shinnwá bàna. ");
INSERT INTO jib_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Almasihu kùr mpìr Israila, aku tìg wann bi á bín-à ni ayi myàng jirà ayi bir pìkyinn rag ku í Wùn Shìdun.” Mpìr pyànàká big dab bàg gbam kwonn sig ma ku níng, swau ku shi àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Barà àyúnn-à fòr áyau shinn, fi í sìr dim gban rìg-à jànn-à bidìm pár, hár fòr àsháu sara wà àkamzau. ");
INSERT INTO jib_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Barà àsháu sara sa àdòníng, Yesu bar nài abor n rag, “Eloi, Eloi, lama sabatani?” Yìr jír-à níng í “Shìdunmí, Shìdunmí, bu-à sa à fim wa mì àdòníng, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mpìrká ká sar yàr sig màhàn fig àdòníng, big dang rag, “Aning fig, ku ri bar Iliya.” ");
INSERT INTO jib_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","I byar-à mpìr zyun áyaubá ni yag n zìg bi soso, n dù kà á zàn zyun shi rag í shin àban, n sìr gbam á bín-à ni, n ya Yesu a wàníng wa, n rag, “Ayi shi kim, ayi myàng wà kó Iliya má bi má zìg tìg wann ku.” ");
INSERT INTO jib_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kig nài ngbam nímá, í byar-à awunwá í zu rìg-à. ");
INSERT INTO jib_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jà-à big gag dim sig nu nkyun lu Shìdun áni níng, í ki gàfinn rìg-à byar pyànà, daka mà wai hár á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Barà àgbam soja-à níng myàng Yesu barà wàníng wu níng, ku dang rag, “Ajai, mpìr-à níng í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Uwàká sar sig pyunn ninonn nímá mi ri myàng bu-à ri sa, zyun í Maryamu Magdaliya, zyun í Maryamu na Yusufu ma Yakubu wà àshái-à, zyun í Salome. ");
INSERT INTO jib_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Big í àsàinká bàg bi sig ku sai-à ku mà jànn Galili, big sa ya ku buju. Uwàká káhi nìnànn nímá shi sig màhàn tìnn, í uwàká bàg yag sig ku mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mpìr zyun shi sig áni, zìnnwá í Yusufu, ku í mpìr Arimatiya. Mpìrká ri yan kyinnwá wàni. Ku í àgbam Yahudawaká. Ku ri shi kir àyúnn-à kùr Shìdun má bi. Barà àkamzau ri sa rá asa, byar-à ma kyàr hing í àyúnn-à bá shi ngàng áni, ku wim kyinn n yag mà byar Bilatus n vig wàníng a wàníng ya ku ki Yesu. ");
INSERT INTO jib_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus sa mamaki barà ku fig big rag Yesu shà wu rìghing níng. Ku bar àgbam soja-à n bib wàníng wà Yesu ma wu rìghing jirà aku yì. ");
INSERT INTO jib_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Barà Bilatus fig kinn rìg jír á nu àgbam soja-à ni rag Yesu wu rìghing níng, í byar-à ku dinya Yusufu rag a wàníng zìg ki Yesu. ");
INSERT INTO jib_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu yag wann jà mìmìg, n zìg tìg wann ki Yesu n bing kà áni, n yag sìnn kà wàníng mà shar ki-à big kab sig mà mìr abàn. I byar-à ku zìg abàn ùwài nímá n kidim nu nkyun amir-à ma kàhi. ");
INSERT INTO jib_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu Magdaliya ma Maryamu na Yusufu, big myàng byar-à big sìnn kà sig ki Yesu. ");
INSERT INTO jib_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Barà àyúnn Asabar wam zu rìghing, Maryamu Magdaliya ma Maryamu na Yakubu, ma Salome, big wann sig tulare jirà abig pàb Yesu á dìr-à ni. ");
INSERT INTO jib_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ayúnn Ladi í pyimbyau, barà àyúnn-à ta nann zu rìghing, big dù n yag mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Barà big ri yag má á gbìb-à ni, big bib bar dìrbá rag, “Mpìr-à má tìr dù ya yi abàn-à á nu nkyun amir-à ni í ni rà?” ");
INSERT INTO jib_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Abàn-à hi wài hing wàni. Big yag fòr màhàn, n myàng big tìr dù rìghing abàn-à á nu amir-à ni. ");
INSERT INTO jib_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Big kà yag mà yau amir-à ni n myàng wùn sukà zyun wìr sig jà mìmìg nímá n shi sig águnn vìm nu-à ni, big sa rìg mamaki. ");
INSERT INTO jib_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I byar-à mpìr-à níng dinya big rag, “Aning sa mamaki bàna. N yì hing ning ri yàn kyann Yesu mpìr Nazarat wà big dab bàg gbam sig á bín-à ni níng. Ku bàna áyág, ku dù nann zu kàng rìghing. Aning myàng byar-à big sìnn kà sig ku. ");
INSERT INTO jib_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aning yag dinya yann sukàwá big, kwonn ma Bitrus rag, ku ri yag mà Galili, kwá yag jág big ni, bá myàng ku màhàn àràg barà ku dinya sig big níng.” ");
INSERT INTO jib_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I byar-à big zu mà amir-à ni n shàr yag, jir kai bàna azyúnn sa rìghing big, big sa mamaki. Big dinya fig mpìr bàna, jir kai bàna big ri shàr zinn.  ");
INSERT INTO jib_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Barà ku dù nann zu kàng àyúnn Ladi í pyimbyau, ku mìr gbìb zu jag á pyànn Maryamu Magdaliya, àsàin-à ku kan zu sig wàu sùmpyànn á dìr wàníng ni níng. ");
INSERT INTO jib_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wàníng yag n yag dinya mpìrká ma Yesu rìi kyann zyun níng, ku dìg káníng ri bai pìkyinn, mi ri kig. ");
INSERT INTO jib_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Barà big fig ku dang rag Yesu dù nann zu kàng rìghing ma yonki níng, big bir fig kyinn á jírwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","I wà yann sukà pyànà dù á Urushalima mì yag rìg-à mà kauye zyun ni. Ku mìr gbìb zu á pyànnbá ni, ku vìm bìr rìghing dìrwá. ");
INSERT INTO jib_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Big kàng bi n dinya yann sukàká dà níng, ama káníng bir fig pìkyinn á jírbá ni bàna. ");
INSERT INTO jib_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu mìr gbìb zu á pyànn yann sukàwá big ni, big dwib agban zyun á sai-à big ri ji buju. Ku yan ta big, jir kai bàna big ngàng wà bá bir pìkyinn á jírwá ni, ma barà big gbam sung wàni, n bir fig kyinn á jir mpìrká myàng sig ku sai-à ku dù nann zu kàng sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ku dinya big rag, “Aning yag kó áni bidìm pár á dunyaru, aning dinya mpìrká jir àjwár á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mpìr-à ma bir hing pìkyinn, ma wau hing dìr batisma, kwá wìm zu. Mpìr-à ma bir fig pìkyinn bàna, kwá wìm zu fig bàna. ");
INSERT INTO jib_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wàníng í bu mamakiká mpìrká ma bir hing pìkyinn á dìrmí ni, bá sa. Bá kan zu wàu ma zìnnmí, bá dang nu jír àpyú, ");
INSERT INTO jib_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kó wà ba pànn hing bushùwí, kó wà ba wa gantí-à bibai, bu má sa fig big bàna, bá tib wann vùbá á shinn mpìr dorká ni, káníng má gbam rìg.” ");
INSERT INTO jib_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Barà Shinn Luyí Yesu dang kinn jír ma big àdòníng, Shìdun zìg nann zu yag rìg ku mà wai. Ku shi sig mà agunn vìm nu Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yann sukàwá big yag n dang kyann jírwá kó áni bidìm pár, ku sa shang káníng n ya káníng gbam-à má tìya mpìrká rag jir káníng í àjai.");
INSERT INTO jib_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yesu sa sig bu nìnànn nímá sai-à ku shi sig á dunyaru. Mpìrká nìnànn nímá ba sig bu á shinn bu-à ku sa sig. ");
INSERT INTO jib_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Big myàng hing bu káníng sai-à ku sa jag sig. Big dinya hing yi bu káníng. Yi fig hing tai á shinn bu káníng ni. ");
INSERT INTO jib_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mì má ǹ bib byann hing tai-à níng í jír àjai. N fig hing tai bar buká ku sa jag sig. I bu-à sa ǹ dang rag, má ba má dinya wù bu káníng, Tiyofalas. Má wànn dinya wù bu káníng bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mì ri sa àdòníng, jirà á yì jír àjaiká big tàg sig wù. ");
INSERT INTO jib_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sai-à Hirudus rì na sig kùr Yahudawaká, mpìr zyun shi sig áni, ku í mpìr-à ri twìb swànn bu á pyànn Shìdun ni, big ri bar ku zìnnwá í Zakariya. Ku í mpìr-à áyau mpìr Abiya, ku zìg sig uwà zyun í yiwai Haruna. Zìnn uwà hi í Alisabatu. ");
INSERT INTO jib_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakariya ma wàwá big ri sa bu-à Shìdun ri zìm, big ri wib jir Shìdun ma bu-à Shìdun ma dang rag abig sa, big ri yàng dang fig jír bàna, big ri sa ma pìkyinn ńzyun. ");
INSERT INTO jib_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama big bàna ma wùn kó ńzyun, jir kai bàna Alisabatu í gbág. Big pyànà bidìm pár big íri àwàutím tìnn. ");
INSERT INTO jib_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ayúnn kyau swàm Zakariya á lu Shìdun ni fòr, Zakariya shi sig mà lu Shìdun ni, mi ri sa swam. ");
INSERT INTO jib_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A bu sù swàm àgbamká ri twìb swànn bu á lu Shìdun ni, big ta kuriya bi pànn á shinn Zakariya, aku sa swàm á lu Shìdun, ma aku bìm bu bìm-à. ");
INSERT INTO jib_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sai-à ku ri bìm bu bìm-à níng, mpìrká sar sig á myann big ri vig Shìdun, àràg barà big ri sa kyann wà bá bìm bu bìm-à. ");
INSERT INTO jib_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","I byar-à hi wùn aswam Shìdun mìr gbìb zu á pyànn Zakariya ni, águnn vìm nuwá á byar-à ku bìm sig bu bìm-à níng. ");
INSERT INTO jib_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Barà Zakariya myàng wàníng àdòníng, sái zinn pànn rìg ku, dìrwá zwab. ");
INSERT INTO jib_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama wùn aswam Shìdun dinya ku rag, “A shàr zinn bàna, wù Zakariya. Shìdun fig rìghing bu-à à vig sig níng. Wàwú Alisabatu má yìm finn. Kwá mà ya wù wùn, wá bar ku zìnnwá í Yohanna. ");
INSERT INTO jib_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pìkyinnwú má kyàr, wá fig àjwár, mpìrká nìnànn nímá bá fig àjwár ma wùn-à kwá mà níng tìnn. ");
INSERT INTO jib_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Shinn Luyí má myàng ku rag ku í mpìr ùwài. Kwá wa fig shin bàna, kwá wa fig bu-à má pyann ku bàna. Tun daka ku shi sig má mà finn nàwá ni, Awun Shìdun má wìr mònn ku pìkyinnwá. ");
INSERT INTO jib_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ku í àsàin-à má zìg kàng bi mpìr Israilaká nìnànn nímá á byar Shìdunbá ni. ");
INSERT INTO jib_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kwá kà jag Shinn Luyí á pyànn í nì. Kwá shi ma gbam àràg Iliya wàrì. Kwá bar jùn kwonn àgbamká ma yanká í byar ńzyun. Kwá sìnn kàng mpìr bibaiká abig kàng bi á byar Shìdun. Kwá sìnn kwonn mpìrká bu Shìdun abig shi kir Asàin Luyí.” ");
INSERT INTO jib_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","I byar-à Zakariya dinya wùn aswam Shìdun rag, “Má yì áshinn wà bu-à hi má sa àjai rà? Ndá mì í àwàutím, wàmí í àwàutím tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","I byar-à wùn aswam Shìdun-à níng dinya ku rag, “I mì Jibrailu zyun-à ri sar á pyànn Shìdun ni. Big swam bi sig mì ń dinya wù jir àjwár. ");
INSERT INTO jib_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ama à wib fig jírmí bàna. Jír-à hi má sa àjai àyúnn su zyun. Barà à wib fig jírmí bàna níng, wá dang sar fig jír bàna. Wá shi àdòníng sái àyúnn-à bu-à ǹ dinya sig wù níng ma sa hing àjai.” ");
INSERT INTO jib_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A byar-à níng hi, mpìrká ri shi kir Zakariya níng, big ri kyab bu-à sa sig, ku nonn sig mà lu Shìdun ni níng. ");
INSERT INTO jib_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Barà ku zu bi àdòníng ku dang sar fig rag jír ma mpìr káníng bàna. I byar-à big myàng yì n dang rag, “Wùn aswam Shìdun zyun mà wai dang hing jír ma ku mà lu Shìdun ni.” Ku dang sar fig jír ma káníng bàna. Bu-à kwa dinya káníng, ku tàg rág ma vù. ");
INSERT INTO jib_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Barà àyúnn-à swàmwá á lu Shìdun ni vinn àdòníng, sái ku í kàng yag rìg-à mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","I byar-à na nonn fig bàna, sái wàwá Alisabatu yìm finn. Ku zu fig á lu-à ni bàna hár sònn swana. ");
INSERT INTO jib_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","I byar-à Alisabatu dang rag ku fig hing àjwár á pyànn Shìdun ni. Wàníng sa shang hing ku, n zìg zu rìghing ku á zunái á pyànn mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Alisabatu shi sig ma finn sònnwá sùnnjin. Shìdun swam bi wùn aswamwá Jibrailu á jànn Galili, á finn swann Nazarat. ");
INSERT INTO jib_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ku shi sig ma jír zyun-à ku ri zìm aku dinya wùn uwà sáb zyun, zìnn wàníng í Maryamu. Wùn uwà-à níng hi yì fig ma wunù bàna. Wunù zyun, zìnnwá í Yusufu, má sìr ban ma ku. Yusufu í wùn ada kùr Dawuda. ");
INSERT INTO jib_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","I byar-à wùn aswam Shìdun yag mà byar Maryamu, n dinya ku rag, “N bi sig ń bib kà wù, wù í zyun-à big shig zu sig, Shìdun shi sig ma wù.” ");
INSERT INTO jib_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sai-à Maryamu myàng wùn aswam Shìdun-à níng, pìkyinnwá na tag wann fig bàna. Ku kyab jír á pìkyinnwá ni n rag í kai rà? ");
INSERT INTO jib_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ama wùn aswam Shìdun dinya ku rag, “Kada á shàr zinn bàna Maryamu, à dìg hing bu ǹsàn á pyànn Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wá yìm finn, má mà wùn, má bar ku zìnnwá YESU. ");
INSERT INTO jib_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kwá shi àgbam. Bá bar ku Wùn Shìdun mà wai. Shìdun má gbar dù ku àràg kùr bu yàkúwá Dawuda rì níng. ");
INSERT INTO jib_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kwá na kùr á shinn yann adaká bu Yakubu, hár kinn kinn. Kùrwá má vinn fig ávinn bàna.” ");
INSERT INTO jib_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","I byar-à Maryamu dinya wùn aswam Shìdun rag, “Sáshinn má shi àdòníng rà? Hár barà ǹ yì fig ma wunù bàna.” ");
INSERT INTO jib_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","I byar-à wùn aswam Shìdun zìm n dinya ku rag, “Awun Shìdun má wìr mònn wù, gbam Shìdun má shi á shinnwú ni tìnn. Jir kai bàna wùn-à wá mà níng í wùn kyìkyàr bu Shìdun. Bá bar ku Wùn Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A kyab pànn yiwaiwú Alisabatu. Big dang rag ku í gbág, kwá mà fig wùn bàna. Ama ku shi sig ma finn sònn sùnnjin tàma-à níng, kó barà ku í àwàutím níng. ");
INSERT INTO jib_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A myàng, bu-à Shìdun má sa sar fig bàna níng, bàna.” ");
INSERT INTO jib_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu dang rag, “Mì í fàu Shìdun, aku shi á shinnmí ni àràg barà à dang níng.” I byar-à wùn aswam Shìdun í ku í fim rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ayau su pyànà káníng ni Maryamu dù, n yag mà swann zyun ni, swann-à hi shi sig á dìr shinnkwìnn mà jànn Yahuda. ");
INSERT INTO jib_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ku kà yag á lu Zakariya ni aku bib kà Alisabatu. ");
INSERT INTO jib_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Barà Alisabatu fig nài bib-à Maryamu bi bib kà ku níng, í byar-à wùn àjann-à á finnwá ni níng ding dìrwá. I nànn-à hi Shìdun wìr mònn rìg Alisabatu ma Awun Kyìkyàrwá. ");
INSERT INTO jib_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Alisabatu dang jír ma gbam n dang rag, “Maryamu, wù í uwà zyun-à Shìdun shig zu sig áyau uwàká ni bidìm pár. Wùn-à á finnwú ni níng, í wùn zyun-à Shìdun shig zu sig tìnn. ");
INSERT INTO jib_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mì bó, ǹ fòr síg kai, hár na Shinn Lumí má bi á byarmí ni aku bi bib kà mì rà? ");
INSERT INTO jib_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hár barà ǹ fig à bib kà mì níng, wùn àjann-à á finnmí ni níng fig àjwár, n ding dìrwá. ");
INSERT INTO jib_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“A bir hing pìkyinnwú á jir Shìdun-à big swam bi sig á byarwú ni níng. I bu-à sa wá fig àjwár níng. Jírwá má sa àràg barà ku dinya sig wù níng.” ");
INSERT INTO jib_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","I wà Maryamu dang rag, “Pìkyinnmí ri swam yan Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pìkyinnmí ri fig àjwár, jir kai bàna Shìdun zìg zu rìghing mì. ");
INSERT INTO jib_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jir kai bàna ku kyab pànn hing ashimí, mì í fàu átai. Tun daka tàma-à níng mpìrká má bar rag mì í mpìr afig àjwár. ");
INSERT INTO jib_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Shìdun shi sig ma gbam, jir bu ùwàiká ku sa ya sig mì níng. Zìnnwá í zìnn kyìkyàr. ");
INSERT INTO jib_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Shìdun ri myàng ashi mpìrká ri wib ku, kó mpìrká tàma-à níng kó mpìrká wàrì. ");
INSERT INTO jib_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ku shi sig ma gbam. Ku kan tafinn rìghing mpìrká ri gbar dù shinn níng. Ku zìg zu rìghing bu-à big ri kyab á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ku gbar tìg rìghing kùrká á kùrbá ni, ku gbar dù nann zu rìghing mpìrká ri gbar dù fig shinn bàna níng. ");
INSERT INTO jib_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ku ri pyag mpìrká ri fig amor ma buju-à ǹsàn, ama mpìr bàiká ku kan kàng yag rìghing káníng vù áyonn. ");
INSERT INTO jib_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Shìdun sa shang rìghing mpìrká buwá mpìr Israilaká, àràg barà ku gib sig nu tun sai-à á ninonn, ku rag kwá myàng ashi káníng. ");
INSERT INTO jib_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Shìdun sa rìghing buká ku rì dinya sig tayí big ma Ibrahim ma swai mpìr Ibrahim big.” ");
INSERT INTO jib_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","I byar-à Maryamu ma Alisabatu shí zyun hár sònn sara. I wà ku í kàng yag rìg-à mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","To, í byar-à àyúnn-à Alisabatu má mà áni í fòr-à, ku bi mà wùn wunù. ");
INSERT INTO jib_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sái ayor luwá big ma yiwaiwá big fig tai jír bu-à Shìdun sa ya sig ku níng, big fig àjwár wàni á bìr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Su awinyin fòr. I wà big kyag wùn-à jur, big ri zìm abig bar ku zìnn tawá Zakariya. ");
INSERT INTO jib_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ama nàwá dang rag, N ń, abig bar ku zìnnwá í Yohanna. ");
INSERT INTO jib_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I wà big dinya ku rag, “Ai ning bàna ma yiwainá zyun-à shi sig zìnnwá àdòníng.” ");
INSERT INTO jib_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","I byar-à big bib tawá jír ma vù, n dang rag kwá bar zìnn wùnwá í kai rà? ");
INSERT INTO jib_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","I byar-à ku tàg ma vù àjirà abig ya ku bu-à kwá ba ma kàhi, í wà ku ba zìnn wùnwá rag í Yohanna. I byar-à kó ni màhàn wim gbam rìg big mamaki. ");
INSERT INTO jib_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","I byar-à hi Zakariya shinn anamwá í fìnn finn rìg-à, ku dìg pyù-à n dang rag jír, mi ri swam yan Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mpìrká ku ma káníng shi kwonn sig zyun níng, zinn pànn rìg big, tai bu káníng kàng kwìb vinn rìg agunn shinnkwìnnká á Yahudiya. ");
INSERT INTO jib_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mpìrká fig tai jír káníng n bib jír á shinnwá ni, n rag, “Wùn-à níng má shi í kai rà?” Bu-à sa big dang àdòníng, big myàng hing gbam Shìdun shi sig ma ku. ");
INSERT INTO jib_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya ta Yohanna Awun Shìdun shi sig ma ku. Ku dang jir Shìdun, n rag, ");
INSERT INTO jib_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ayi swam yan ning Shinn Luyí Shìdun bu Israilaká, ku bi aku sa shang mpìr káníng aku zìg zu big áyau shwìn. ");
INSERT INTO jib_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ku ya hing yi àgbam mpìr-à má zìg zu yi, mpìr-à hi í wùn ada Dawuda fàuwá, ");
INSERT INTO jib_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","àràg barà ku rì dang sig á nu mpìrká ri dang kyann jírwá. ");
INSERT INTO jib_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ku dang rag kwá zìg zu yi á vù mpìr azíbyí big ni, àràg mpìrká ri zìm fig yi bàna níng. ");
INSERT INTO jib_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ku rì dang rag kwá myàng ashi yàkúyí big, ku màm jànn fig bu-à ku rì dang sig rag kwá sa níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I ki-à ku rì tun ya sig yàkúyí Ibrahim n rag, ");
INSERT INTO jib_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kwá zìg zu rìg yi á vù mpìrká ri zib yi, jirà ayi sa swàm Shìdun, ayi shàr zinn bàna, ");
INSERT INTO jib_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","jirà ayi shi mpìr kyìkyàr ma shu ǹsàn á pyànnwá ni áyau su shuyí ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wù wùn-à níng, bá bar wù, wùn aswam Shìdun. Wá kà jag Shinn Luyí á pyànn í nì. Wá wàu kyàr ya ku gbìb-à kwá bàg áni. ");
INSERT INTO jib_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wá dinya mpìrká jir Shìdun, má dang rag, Shìdun aku zìg zu big á bu pyìrbá ni. Kwá zìg zu big, kwá yafa ya big. ");
INSERT INTO jib_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Shìdun ri myàng ashi mpìr. Kwá swam bi hing jir àjwárwá má shi àràg àyar ri yar wann bi mà wai. ");
INSERT INTO jib_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ayar-à má wann bi níng, má kan rìg fi, má kan rìg ki tìnn, má kan rìg zinn á pìkyinn mpìrká ni, má tìya yi gbìb-à ǹsàn, jirà pìkyinnyí aku na tag.” ");
INSERT INTO jib_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wùn-à níng hi wài gbam mi ri wib Shìdun. Ku shi sig mà awúnn-à ni hár àyúnn-à ku zu bi á byar Israilaká, í byar-à ku kà rag hing swàmwá sa. ");
INSERT INTO jib_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Asai-à níng hi kùr Augustas dang rag abig bar nài abor. Ku dang rag abig ba wànn mpìrká á jànnwá ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sai-à big kà bu wànn-à níng wà jijag sai-à níng hi Kiriniyas shi síg nì gwamna á Suriya. ");
INSERT INTO jib_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A byar-à níng hi, kó ni kàng yag mà jànnwá ni, àjirà abig ba wànn ku màhàn. ");
INSERT INTO jib_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I byar-à hi Yusufu dù mà swann Nazarat, á jànn Galili, n yag mà swann Baitalami á jànn Yahudiya. Baitalami í byar-à big mà sig Dawuda. Yusufu yag sig màhàn, jir kai bàna ku í wùn ada Dawuda. ");
INSERT INTO jib_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ku yag kwonn sig ma Maryamu uwà ku ri zìm kwá zìg. Wàníng shi sig ma finn. Big yag àjirà abig ba wànn big. ");
INSERT INTO jib_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ayúnn-à big shi sig màhàn níng, sái sù màwá fòr. ");
INSERT INTO jib_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ku mà wùn màsábwá í wunù, n bir wàníng á jà. Ku jag wann wùnwá á kwài buju bu apyagká ni, jir kai bàna big dìg fig byar ná á lu-à big tìg sig níng ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A sai-à níng hi, aza àdùnká na sig mà awúnn-à ni. Big na yàr sig mà finn swann-à ni. Big ri myàng kwonn ma bu apyagká bubá í zyun á fi-à ni. ");
INSERT INTO jib_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A byar-à níng hi wùn aswam Shìdun mà wai fòr bi n sar á shinnbá ni. Ayar Shìdun tìg wann bi n sar kàng kwìb big bidìm pár, zinn pànn big. ");
INSERT INTO jib_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I byar-à wùn aswam Shìdun dinya big rag, “Aning shàr zinn bàna. N zìg bi ya sig ning tai ǹsàn, má sa pìkyinn ná má fig àjwár wàni. Tai ǹsàn-à níng, í bu mpìrká bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Janá-à níng á finn swann-à big mà sig Dawuda, big mà ya sig ning mpìr-à má sa shang ning. Ku shi síg nì Almasihu Shinn Luyí wà Shìdun swam bi sig. ");
INSERT INTO jib_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wàníng í bu-à ná myàng. Ná dìg wùn àjann, big bir sig ku á jà, ku na sig á kwài buju bu apyagká ni.” ");
INSERT INTO jib_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Big rag abig myàng àdòníng, bìr yann aswamká bu Shìdun mà wai bi dìg zyun-à dinya mpìrká tai àjwár-à níng, big sar kàng kwìb gban rìghing byar-à hi. Big ri dài jonn, big ri swam yan zìnn Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Big dài dang rag, “Shìdun, í Shìdun ùwài mà wai. Mpìrká Shìdun ri zìm á jànn-à ni, pìkyinnbá má fig àjwár.” ");
INSERT INTO jib_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A sai-à níng hi yann aswamká bu Shìdun kàng yag rìg mà wai. Aza àdùnká myàng dìrbá, n dang rag, “Ayi yag mà finn swann Baitalami, ayi myàng wùn-à Shìdun dinya sig yi rag, big mà sig níng.” ");
INSERT INTO jib_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Big dù n yag kíni, n dìg Maryamu ma Yusufu, ma wùn àjann-à na sig á kwài buju bu apyagká ni àràg barà wùn aswam Shìdun dinya sig big. ");
INSERT INTO jib_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","I byar-à hi big dù, mi ri dinya mpìrká buká wùn aswam Shìdun dinya sig big á shinn wùn àjann-à big mà sig níng. ");
INSERT INTO jib_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Barà mpìrká fig bu-à aza àdùn káníng dinya sig big níng, big sa mamaki. ");
INSERT INTO jib_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryamu sìnn sig bu káníng á pìkyinnwá ni, mi ri kyab. ");
INSERT INTO jib_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aza àdùnká kàng yag, mi ri swam yan zìnn Shìdun á shinn buká big fig sig, ma bu-à big myàng sig, wato wùn àjann-à níng, àràg barà wùn aswam Shìdun dinya sig big. ");
INSERT INTO jib_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ayúnn su awinyin fòr, bá kyag Yesu jurwá, n bar zìnnwá Yesu àràg barà wùn aswam Shìdun dang sig á sai-à nàwá yìm fig ma finn bàna. ");
INSERT INTO jib_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ayúnn-à Maryamu má sa kyàr dìrwá fòr barà doka Musa dang sig, sái big zìg Yesu n zìg yag ku mà lu Shìdun á Urushalima jirà abig sìnn ku á pyànn Shìdun, ");
INSERT INTO jib_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","jir kai bàna doka Shìdun dang rag, “Wà uwà ma mà wùn màsábwá wunù, bá zìg yag ku mà lu Shìdun àjirà abig ya ku Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maryamu sa kyàr dìrwá ma yann àlàb pyànà, jir kai bàna jir Shìdun dang rag, “Bá sa kyàr ma yann àlàb lu pyànà kó àlàb awúnn pyànà.” ");
INSERT INTO jib_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mpìr zyun shi sig màhàn á swann Urushalima, zìnnwá í Simiyan. Ku í mpìr ǹsàn, ku ri wib Shìdun. Awun Shìdun shi sig á pìkyinnwá ni. Ku ri shi kir àyúnn-à Shìdun má swam bi wùnwá á byar mpìr Israilaká a wàníng sa shang big. ");
INSERT INTO jib_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Awun Shìdun tìya sig ku kwá wu fig bàna, sái kwa myàng hing Kristi zyun-à Shìdun má swam bi. ");
INSERT INTO jib_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Awun Shìdun dinya ku aku kà yag mà lu Shìdun. Yusufu ma Maryamu zìg kà Yesu wùn àjann-à níng mà lu Shìdun jirà abig sa bu-à doka dang sig. ");
INSERT INTO jib_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyan zìg wùn àjann-à níng, n wau swann sig ku, mi ri yan Shìdun, mi ri dang rag, ");
INSERT INTO jib_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Shìdun zyun-à màm sig yi, tàma-à níng ǹ myàng hing wùnwú, àràg barà wù rì dang sig. Kó ma wu tàma-à níng, sàn hing, ");
INSERT INTO jib_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","jir kai bàna tàma-à níng zumí myàng hing wùn azìmwú, zyun-à má zìg zu mpìrká á bu pyìrbá ni, ");
INSERT INTO jib_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wà à swam bi sig, jirà mpìrká bidìm pár abig myàng ku. ");
INSERT INTO jib_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kwá tàg mpìr nu jírká kim kim gbìb-à bá bàg. Ba wib mpìr Israilaká á jír shinnwá ni.” ");
INSERT INTO jib_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta wùn-à ma nàwá sa mamaki ma jírká Simiyan dang sig á shinn wùn àjann-à níng. ");
INSERT INTO jib_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","I byar-à hi, Simiyan vig Shìdun aku sìnn big á byar-à ǹsàn, n dinya Maryamu na Yesu n rag, “Wùn-à níng í àsàin-à má sa mpìrká nìnànn nímá má kù, ama mpìrká nìnànn nímá má dù nann á shinnwá ni á jànn Israila, ");
INSERT INTO jib_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","jir kai bàna kwá dang kyàr vinn rìg bu-à mpìrká nìnànn nímá ri kyab á pìkyinnbá ni. Wù Maryamu, pìkyinnwú má bai àràg big twìb kà sig wù kafai á pìkyinnwú ni.” ");
INSERT INTO jib_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Uwà zyun shi sig mà lu Shìdun, zìnnwá í Hanatu. Ku í wùn Fanuyila, yiwai mpìrká ma Ashiru. Ku í àwàutím, ku rì shi sig á lu nùwá ni ji sùmpyànn. ");
INSERT INTO jib_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Daga àyúnn-à nuwá wu sig, ku í wà ki, hár tàma-à níng jiwá dìb-yina agban yina. Ku ri yag kyann mà lu Shìdun, fi ma ayúnn. Ku ri vig Shìdun, ku ri sìnn nu tìnn. ");
INSERT INTO jib_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Uwà-à níng bi fòr á byar-à wùn àjann-à níng shi sig. Ku yan Shìdun á shinn wùn-à níng. Ku dinya mpìrká nìnànn nímá jír á shinn wùn àjann-à níng ni. I mpìrká ri shi kir àyúnn-à Shìdun má sa shang bìr mpìrká mà Urushalima níng. ");
INSERT INTO jib_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Barà big sa vinn rìg bu-à jir Shìdun dang rag abig sa níng, sái big í kàng yag rìg-à mà jànn Galili, á finn swannbá ni mà Nazarat. ");
INSERT INTO jib_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wùn-à níng wài gbam rìghing. Ku yar rìghing, mi ri wib Shìdun. Shìdun ri sa sàn ya ku. ");
INSERT INTO jib_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tawá ma nàwá ri yag kyann mà Urushalima jir shinn àyúnn wùwài, zìnn àyúnn-à níng hi í àyúnn Pìm Wam Zu. ");
INSERT INTO jib_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu jiwá fòr ji dwib agban pyànà. Ku ma káníng ri yag rág í zyun mà Urushalima àràg barà big ri yag kyann àyúnn ùwài-à níng. ");
INSERT INTO jib_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Barà big sa vinn rìg bu-à zìg yag sig big, sái big ri kàng yag rág mà lu-à ni. Sái Yesu í sar rìg-à á Urushalima, tawá ma nàwá yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Big ri kyab rag káhi kwá áyaubá ni, hár big kyann kyonn hár àyúnn kà. I byar-à big yàn kyann ku áyau bar yiwaiwá big ni, ma jàuwá big ni, áyau barà big yag sig níng. ");
INSERT INTO jib_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Big dìg fig ku bàna. I byar-à big í kàng yag kàng rìg-à mà Urushalima, mi ri yàn kyann ku. ");
INSERT INTO jib_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ayúnn su sara, í wà big yàn dìg rag ku mà lu Shìdun ni. Ku shi kà sig áyau àgbam malamká ri tàg bu. Ku ri fig jírbá, mi ri bib káníng jír tìnn. ");
INSERT INTO jib_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mpìrká fig sig jírwá níng, big sa mamaki, jir kai bàna ku shi sig ma yar. Jír-à ba bib ku, ku ri zìm ǹsàn. ");
INSERT INTO jib_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Barà nàwá ma tawá myàng ku, sái big sa mamaki. Nàwá dang rag, “Wùnmí, á myàng, sáshinn à sa yi àdòníng rà? A myàng, yi ma tawú ri yàn kyann wù hár pìkyinnyí bai rìghing.” ");
INSERT INTO jib_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sái ku dinya káníng rag, “Bu-à sa ning ri yàn kyann mì àdòníng í jir kai rà? Ning yì fig wà ǹ shi sig á lu tamí ni bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Big fig yì fig bu-à ku dinya sig big níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A byar-à níng hi, Yesu kàng yag ma big í zyun mà Nasarat. Ku ri wib káníng. I barà nàwá ri kyab bu káníng á pìkyinnwá ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","I byar-à Yesu ri wài. Yarwá ri swàb kà tìnn. Shìdun ri zìm ku, mpìrká ri zìm ku tìnn. ");
INSERT INTO jib_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Asai-à Kaisar Tibaryus na sig kùrwá hár ji dwib agban swana níng, Shìdun dang jír ma Yohanna, í sai-à Buntus Bilatus í gwamna á jànn Yahudiya, Hirudus í gwamna á jànn Galili, Filibus wunzà Hirudus í gwamna á jànn Ituriya mà jànn Tarakunitis, Lisaniyas í gwamna á jànn Abiliya, ");
INSERT INTO jib_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanana ma Kayafa í àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun. A sai-à níng hi, Shìdun dang jír ma Yohanna wùn Zakariya mà awúnn-à ni. ");
INSERT INTO jib_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I byar-à Yohanna dù n yag rìg mà jànn agunn Ning Urdun, ku ri dang jir Shìdun màhàn, ku dang rag, “Aning fim bu pyìrká ning ri sa. Abig wau ning dìr batisma, jirà Shìdun aku yafa ya ning bu pyìrká buná.” ");
INSERT INTO jib_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanna í zyun-à Ishaya wùn aswam Shìdun rì dang sig jír á shinnwá ni. Ku ba sig rag, “Mpìr zyun-à má swam yag ku níng, ku shi sig mà awúnn-à ni, ku ri dinya mpìrká jírmí rag, ‘Aning wàu kyar gbìb-à Shinn Luyí má bàg áni. Byar-à gbìb-à gor sig níng, aning wàu lafinn yag rìg mà pyànn. ");
INSERT INTO jib_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kó shar-à áni bidìm pár, abig wàu jì dim rìg, kó shinnkwìnn-à áni abig wàu bab jànn rìg. Abig wàu lafinn rìg gbìb-à hi, ma abig sa jann rìg. ");
INSERT INTO jib_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","I byar-à kó ni bidìm pár má myàng barà Shìdun sa wìm zu sig mpìrká buwá.’ ” ");
INSERT INTO jib_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A byar-à níng hi, bìr mpìrká ri bi á byar Yohanna aku wau big dìr batisma. Ku dinya káníng rag, “Ning í bushùwí big, í ni dinya sig ning í nì rag, ‘ná zu shwìn bu-à Shìdun dang sig rag kwá swam bi níng’ rà? ");
INSERT INTO jib_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aning sa bu-à mpìrká má yì rag ning fim rìghing bu pyìrná. Kada aning dang ma shinn ná rag, ná zìg zu shinn ná á shwìn-à ri bi níng ni, jirà taná í Ibrahim níng, bàna. N dinya ning, Shìdun má sa yì bu-à ku ri zìm, kwa zìm hing, kwá zìg abàn káníng má màm yann adaká bu Ibrahim ma kàhi. ");
INSERT INTO jib_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aki shi sig áni zyun-à bá kyag ta wann rìg bín-à ma wan fig awan ǹsàn bàna, bá ta kà rìg mà pyìr-à ni.” ");
INSERT INTO jib_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","I byar-à mpìrká bib ku rag, “Wà má àdòníng yá sa í kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ku dinya káníng rag, “Mpìr-à ma shi sig ma jà pyànà aku ya jàuwá zyun-à bàna ma kàhi níng, zyun. Mpìr-à ma shi sig ma buju, aku ya mpìr-à bàna ma kàhi.” ");
INSERT INTO jib_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mpìrká ri zìg bài jànn-à níng bi sig abig wau big dìr batisma, big bib ku rag, “Malam, yá sa í kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I byar-à ku dinya big rag, “Kada aning zìg wam zu nu-à big dinya sig ning bàna.” ");
INSERT INTO jib_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sojaká káhi bib ku rag, “Buyí yá sáshinn rà? Yá sa í kai rà?” Ku dinya big n rag, “Kada aning gbar shwar bu zyun á vù mpìrká ni bàna, kada aning yan ta mpìr átai bàna tìnn. Aning bir pìkyinn ná á bài swàmná ni kawai.” ");
INSERT INTO jib_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","I byar-à mpìr káníng kyab jír á pìkyinnbá ni, n dang rag, “Kó Yohanna í Almasihu-à Shìdun dang rag kwá swam bi níng rà?” ");
INSERT INTO jib_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","I byar-à Yohanna dinya big n rag, “Mì ri wau dìr batisma ma zàpìr, ama mpìr zyun má bi kwá shi àgbammí, kó jùr tabarwá má, ǹ fòr fig wà má fìnn sar bàna. Kwá wau ning dìr batisma ma Awun Shìdun ma pyìr. ");
INSERT INTO jib_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Shìdun má zìg zu rìg mpìrká buwá. Mpìrká ma í buwá bàna, kwá wìr kà rìg káníng á pyìr-à má dim fig á dim bàna, àràg barà mpìr ri pìm zu asinn za á za-à ni, mi ri wìr gbam rìg yìr za-à, mi ri zìg asinn-à mi ri wìr kìfinn rìg níng.” ");
INSERT INTO jib_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanna dinya mpìrká jir Shìdun á shinn buká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sái ku dinya kùr Hirudus jír á shinn bu-à wàníng sa sig bai n zìg rìg sig wà wunzà wàníng níng, uwà-à hi big ri bar ku Hirudiyas. Hirudus sa sig buká sàn fig bàna kim kim. ");
INSERT INTO jib_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sái ku sa swàb kà bu-à sàn fig bàna, n pànn rìg Yohanna n kìg kà á tonn fi. ");
INSERT INTO jib_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Barà Yohanna wau vinn rìg mpìrká dìr batisma àdòníng, sái Yesu bi abig wau ku tìnn. Barà Yohanna wau vinn rìg ku dìr batisma àdòníng, sái ku dang jír ma Shìdun. A byar-à hi, waisháu-à í pù finn-à sa hauu. ");
INSERT INTO jib_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","I byar-à hi, big myàng Awun Shìdun wann bi n kir wann á shinn Yesu ni, àràg àlàb. I byar-à big fig nài abor wann bi mà wai, n dang rag, “Wù í wùn azìmmí. Pìkyinnmí ri fig àjwárwú wàni.” ");
INSERT INTO jib_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sai-à Yesu dang jag jir Shìdun ku shi sig ma ji dìzyun agban dwib. Big sìnn sig rag, ku í wùn Yusufu, Yusufu í wùn Hali. ");
INSERT INTO jib_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hali í wùn Matati, Matati í wùn Lawi, Lawi í wùn Malki, Malki í wùn Yanna, Yanna í wùn Yusufu, ");
INSERT INTO jib_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu í wùn Mattathiya, Mattathiya í wùn Amos, Amos í wùn Nahoma, Nahoma í wùn Hasli, Hasli í wùn Najaya, ");
INSERT INTO jib_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya í wùn Maatha, Maatha í wùn Mattathiya, Mattathiya í wùn Shimi, Shimi í wùn Yuseka, Yuseka í wùn Joda, ");
INSERT INTO jib_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda í wùn Yohanna, Yohanna í wùn Risa, Risa í wùn Zarubabila, Zarubabila í wùn Shaaltila, Shaaltila í wùn Niri, ");
INSERT INTO jib_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri í wùn Malki, Malki í wùn Addi, Addi í wùn Kusama, Kusama í wùn Almodama, Almodama í wùn Iri, ");
INSERT INTO jib_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iri í wùn Joshuwa, Joshuwa í wùn Aliazara, Aliazara í wùn Yorima, Yorima í wùn Matati, Matati í wùn Lawi, ");
INSERT INTO jib_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi í wùn Simiyan, Simiyan í wùn Yahuda, Yahuda í wùn Yusufu, Yusufu í wùn Jonam, Jonam í wùn Aliyakima, ");
INSERT INTO jib_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aliyakima í wùn Malaya, Malaya í wùn Mainana, Mainana í wùn Matthata, Matthata í wùn Nathana, Nathana í wùn Dawuda, ");
INSERT INTO jib_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda í wùn Yassa, Yassa í wùn Obida, Obida í wùn Buaza, Buaza í wùn Salmuna, Salmuna í wùn Nahashuna, ");
INSERT INTO jib_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahashuna í wùn Aminadabu, Aminadabu í wùn Arama, Arama í wùn Hasaruna, Hasaruna í wùn Parisa, Parisa í wùn Yahuda, ");
INSERT INTO jib_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda í wùn Yakub, Yakub í wùn Ishaku, Ishaku í wùn Ibrahim, Ibrahim í wùn Taraha, Taraha í wùn Nahura, ");
INSERT INTO jib_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahura í wùn Saruja, Saruja í wùn Rauwa, Rauwa í wùn Falaju, Falaju í wùn Abiru, Abiru í wùn Shalahu, ");
INSERT INTO jib_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shalahu í wùn Kinana, Kinana í wùn Arfakshada, Arfakshada í wùn Sama, Sama í wùn Nuhu, Nuhu í wùn Lamaka, ");
INSERT INTO jib_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamaka í wùn Matushalaha, Matushalaha í wùn Enok, Enok í wùn Yarada, Yarada í wùn Mahalailu, ");
INSERT INTO jib_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Mahalailu í wùn Kanana, Kanana í wùn Anosha, Anosha í wùn Shitu, Shitu í wùn Adamu, Adamu í wùn Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Awun Shìdun shi sig á pìkyinn Yesu ni wàni. Ku kàng bi sig mà Ning Urdun. Awun Shìdun zìg yag sig ku mà awúnn-à ni. ");
INSERT INTO jib_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ku shi màhàn hár su dìpyànà. Shaitan shi sig ma ku á byar-à ku shi sig níng, mi ri màg màg fig ku, aku sa bu bibai. A su káníng hi ni, ku ji fig bu bàna. Barà su-à vinn vinn níng, í wà amor gban rag ku. ");
INSERT INTO jib_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shaitan rag, “Wà wù má wùn Shìdun, á dang abàn-à níng aku kàng buju ń myàng.” ");
INSERT INTO jib_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu zìm ǹ rag, “Big ba sìnn sig á tarkada Shìdun rag, ‘Mpìr má shi fig ma yonki íri jir buju ji bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sái Shaitan zìg dù yag ku mà wai, n tìya ku byar shu kùrká á dunyaru bidìm pár àràg barà big ri mig kinn zu mi ri pù finn. ");
INSERT INTO jib_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shaitan dinya ku n rag, “Má ya wù gbam á shinnbá ni bidìm pár, jir kai bàna big ya síg mì. Má ya mpìr-à mì ri zìm aku pànn. ");
INSERT INTO jib_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wà wa bìnn kir wann hing á jìnn ni ma wib hing mì, bu káníng bidìm pár má shi í buwú.” ");
INSERT INTO jib_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","I byar-à Yesu dinya ku n rag, “Jir Shìdun dang sig rag ‘A wib íri Shinn Luwú Shìdun ku awínwá ni.’ ” ");
INSERT INTO jib_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sái Shaitan zìg yag ku mà Urushalima n zìg dù nann zu ku mà wai á shinn lu Shìdun, n dang rag, “Wù Yesu, wa dang rag wù í wùn Shìdun, á pìm tìg wann bi á jìnn ni, ");
INSERT INTO jib_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","jir kai bàna jir Shìdun dang rag, ‘Kwá swam bi yann aswamwá big abig myàng kwonn ma wù í zyun. ");
INSERT INTO jib_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bá jag vù má pànn wù, àjirà kada á wab barwú abàn bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu zìm n rag, “Big ba sig n rag, ‘Kada á màg màg fig Shìdunwú bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Barà Shaitan màg màg fig kinn rìg Yesu àdòníng, ku dù dà fim ma wàníng mì yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Barà Yesu kàng yag mà jànn Galili, gbam Awun Shìdun shi sig ma ku. Taiwá kyann kàng kwìb vinn rìghing kó áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ku ri tàg mpìrká bu á tonn bìr kwonnká ni, big ri yan ku. ");
INSERT INTO jib_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sái Yesu dù màhàn, n kàng yag mà jànnwá ni mà Nazarat, í byar-à ku wài gbam sig màhàn. Ku yag àràg barà ku rìi yag jwar kyann, n yag mà tonn bìr kwonn. Ayúnn Asabar, ku yag n yag jangga ya mpìrká jir Shìdun màhàn. ");
INSERT INTO jib_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Big du ya ku tarkada Shìdun zyun-à Ishaya mpìr-à rìi dang kyann jir Shìdun ba sig. Ku pù fim n dìg byar zyun big ba sig rag, ");
INSERT INTO jib_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Awun Shìdun shi sig á shinnmí ni, jir kai bàna ku shig zu sig mì ń dinya mpìr ashiká jír àjwár á shinnwá ni. Ku swam bi sig mì ń dang abig zìg zu mpìr á tonn fi, ń dàb gbam àfau abig myàng, ń zìg zu mpìrká big ri lir ji, ");
INSERT INTO jib_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ń dinya mpìrká jír ń dang rag àyúnn-à Shìdun má zìg zu mpìrká buwá bi fòr hing.” ");
INSERT INTO jib_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I byar-à ku bir dim rìg tarkada-à n ya kàng rìg mpìr-à sar sig mà pyànn, mi í shi wann rìg-à. I byar-à kó ni mà finn tonn-à ni myàng gbam sig ku kyarr. Big ri zìm abig fig jír-à má zu á nuwá ni. ");
INSERT INTO jib_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sái ku dang swàb kà n rag, “Janá-à níng jír-à ǹ jangga sig níng sa hing àjai á zuná ni.” ");
INSERT INTO jib_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Big bidìm pár big yan ku, n sa mamaki ma jírká ku dang sig níng. Hár big dang rag wàníng má shi wùn Yusufu ràu. ");
INSERT INTO jib_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu dinya big rag, “N yì hing ná dinya mì tinn jír-à níng má rag, ń dàb gbam shinnmí, wà mì má adàb dor. Ná dang rag, buká ning fig ǹ sa sig mà swann Kafarnahum níng, ń sa á jànnmí ni tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ku dinya big n rag, “Mì ri dinya ning àjai, wùn aswam Shìdun á jànnwá ni big ri zìm fig abig fig jírwá bàna. ");
INSERT INTO jib_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ama mì ri dinya ning í jír àjai, ásai-à Iliya rìi dang kyann jir Shìdun, shyù tab fig á Israila bàna hár ji sara big sònn sùnnjin. Buju bàna á jànn-à ni. A sai-à níng hi uwà kiká nìnànn nímá shi sig mà Israila. ");
INSERT INTO jib_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama Shìdun swam yag fig Iliya aku yag sa shang uwà káníng bàna. Sái ku swam yag wàníng á byar uwà ki zyun mà Zarifat á jànn Sidon. ");
INSERT INTO jib_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sai-à Aliyasha rìi dang kyann jir Shìdun níng, mpìr àkùnn big rì nìnànn nímá mà Israila. Ama ku dàb gbam fig big bàna, sái Naaman mpìr-à mà Suriya áwinwá.” ");
INSERT INTO jib_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Barà mpìrká shi sig á tonn bìr kwonn-à ni fig àdòníng, big bidìm pár pìkyinnbá í bai rìg-à á shinn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","I byar-à hi big pìm dù nann zu, n zìg zu rìg ku á finn swann-à ni, n zìg yag ku ma kwib swann-à ni mà byar agau. Big ri zìm abig tìr ta kà ku áni. ");
INSERT INTO jib_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama ku kyann vù kà áyaubá ni, mì yag rìg-à. Big yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","I byar-à Yesu yag mà Kafarnahum á jànn Galili. Ayúnn Asabar ku tàg big bu màhàn. ");
INSERT INTO jib_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mpìrká sa mamaki ma bu tàgwá, jir kai bàna jírwá shi sig ma gbam. ");
INSERT INTO jib_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Barà ku ri tàg mpìrká jir Shìdun mà tonn bìr kwonn-à ni, sai mpìr zyun wàu dab sig ku, ku yan ta Yesu nài yán, ");
INSERT INTO jib_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","n rag, “Yesu mpìr Nazarat, á dù áyág, bu-à dù wù ma yi í kai rà? A bi síg jirà á gban rìg yi rà? N yì rìghing wù, wù í wùn kyìkyàr zyun-à Shìdun dwim bi sig níng.” ");
INSERT INTO jib_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu dinya wàu-à níng hi n rag, “A mib nuwú, á zu bi á dìr mpìr-à níng hi.” Wàu-à níng gbar ta wann mpìr-à níng á jìnn ni n fim rìg ku. Mpìrká màhàn ri myàng. Dìrwá bu zyun sa fig rag ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mpìrká sa mamaki n dang rag, “Wàníng í atàg kai rà? Hár Yesu dang jír ma gbam, í wà wàuká ri wib kyann ku, mi ri zu á dìr mpìrká ni.” ");
INSERT INTO jib_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tai bu-à ku sa sig níng kù akigtái, hár jànn-à bidìm pár fig vinn rìghing. ");
INSERT INTO jib_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Barà big dù á tonn bìr kwonn-à ni, àyúnn-à hi ku yag mà lu Siman. Na wà Siman fig fig àjwár bàna. Awàu pànn sig ku. Big vig ku aku dàb gbam wàníng. ");
INSERT INTO jib_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ku sar á shinn wàníng ni. N yan ta awàu-à níng. I nànn-à hi awàu-à dà finn rìg ku. Ku dù nann hár n yag sa ya káníng buju. ");
INSERT INTO jib_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Barà àyúnn-à kà, mpìrká zìg zu bi mpìr dorká kim kim á byar Yesu ni aku tib big vù á dìr. Ku tib big bidìm pár, big gbam rìg. ");
INSERT INTO jib_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wàuká ri zu bi á dìr mpìrká ni nìnànn nímá. Big ri wa nài yán, mi ri dang rag, “Yesu, wù í wùn Shìdun.” I byar-à ku kan dim rìg káníng, kada a káníng dang jír bàna, jir kai bàna big yì rìghing ku í Almasihu wà Shìdun swam bi sig. ");
INSERT INTO jib_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Barà byar-à ri kyàr àdòníng, ku zu n yag mà byar zyun, byar-à mpìr bàna. Sái bìr mpìrká nìnànn nímá ri yàn kyann ku, big yag fòr mà byarwá ni. Big ri zìm abig kan dim rìg ku, aku dù dà fim finn swannbá bàna. ");
INSERT INTO jib_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ku dinya big rag, “Sàn sig wà ń dinya mpìrká mà finn swannká káhi kim kim jir Shìdun tìnn, jir kai bàna í swàm bu-à Shìdun swam bi sig mì ń sa.” ");
INSERT INTO jib_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","I barà ku shi mi ri dang kyann jir Shìdun á tonn bìr kwonnká á jànn Yahudawaká ni. ");
INSERT INTO jib_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Su zyun Yesu sar sig á nu Ayunn Janisarata, ku ri tàg jir Shìdun. Mpìrká nìnànn nímá sar kàng kwìb sig ku áni, big ri fig jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ku myàng kòr pyànà shi sig á nu zàpìr-à ni, mpìr agban jáiká sìnn síg nì, big zu rìghing áni. Big ri tu kyàr birgibá. ");
INSERT INTO jib_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ku kà á finn kòr zyun ni, í kòr Bitrus, í wà ku dinya wàníng rag a wàníng ya kà yag ku mà yau zàpìr-à ni títi. Ku shi sig á finn kòr-à ni, mi ri dinya mpìrká sar sig á myann níng jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Barà ku dang vinn rìg jírwá, ku dinya Bitrus rag, “A ya kà yag kòr-à níng mà yau, ma aning wìr kà birginá.” ");
INSERT INTO jib_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","I byar-à Bitrus dinya ku n rag, “Asàin Luyí, nà níng yi nà na fig aná bàna, yi ri sa swàm. Yi dìg fig bu bàna. Ama barà à dang hing níng, má wìr kà birgi-à hi.” ");
INSERT INTO jib_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Barà big wìr kà wann birgi-à níng àdòníng, í byar-à hi big pànn jái wàni, hár birgibá ri ka, jir kai bàna jái-à mònn kab gbam. ");
INSERT INTO jib_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","I byar-à hi big bar bi jàubá mà kòr zyun ni kim a káníng bi gbar zu shang big. I byar-à káníng bi n gbar zu jái mònn gban rìg kòr pyànà káníng, hár kòrká shi shirag má sib kà wann rìg á zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Barà Bitrus myàng àdòníng, ku bìnn kir wann á pyànn Yesu ni n dang rag, “Asàin Luyí, á dù á fim mì, jir kai bàna mì í mpìr bu pyìr.” ");
INSERT INTO jib_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ku ma mpìrká dà níng, mamaki pànn rìg big á jir jái yanyínká big gban sig níng. ");
INSERT INTO jib_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yann Zabadi, Yakubu ma Yohanna, big sa mamaki tìnn. Big ma Bitrus nu swàmbá ńzyun. Yesu dinya Bitrus rag, “Kada á shàr zinn bàna. Daka tàma-à níng, wá pànn zìg bi rág mpìr á byarmí ni, ma wà wá pànn rag jái.” ");
INSERT INTO jib_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","I byar-à big yag zìg kòrbá á nu zàpìr-à ni, n fim kó kai bidìm pár, n bàg rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Barà Yesu shi sig mà finn swann zyun ni, mpìr zyun bi, dìrwá bidìm pár íri dor àkùnn. Barà ku myàng Yesu àdòníng, ku bìnn kir wann á pyànn wàníng ni, n vig wàníng rag, “Shinn Luyí, wa zìm hing, à shi sig ma gbam-à wá dàb gbam mì.” ");
INSERT INTO jib_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","I byar-à Yesu du yag vùwá n tib ku vù á dìr-à ni n rag, “N zìm hing, á gbam á dorwú ni.” I byar-à hi wunù-à níng í gbam rìg-à. Dor àkùnn-à níng dà fim rìghing ku. ");
INSERT INTO jib_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sái Yesu twìb ku byur n rag, “Kada á dinya mpìr bu-à sa sig wù níng bàna, ama á yag mà lu Shìdun ni. A yag tìya àgbam-à ri twìb swànn bu á pyànn Shìdun ni dìrwú, ma á ya bu màhàn àràg barà Musa dang sig abig sa, jirà mpìrká abig myàng barà à gbam rìghing níng.” ");
INSERT INTO jib_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ama tai Yesu kyann kàng kwìb vinn rìghing byarká bidìm pár. Mpìrká ri bi abig fig jírwá, aku dàb gbam big dorbá tìnn. ");
INSERT INTO jib_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kó ákaun ku ri yag, mi ri yàn kyann byar awù aku shi màhàn, jirà aku wib Shìdun ma aku vig wàníng. ");
INSERT INTO jib_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ayúnn zyun barà ku ri tàg mpìrká bu, Farisawaká ma malamká shi sig màhàn. Big bi sig mà kauyeká kim kim kim á jànn Galili ma jànn Yahudiya ma finn swann Urushalima. Gbam Shìdun shi sig á byarwá ni jirà aku dàb gbam mpìr dorká. ");
INSERT INTO jib_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mpìrká káhi swann zìg bi sig mpìr-à dìrwá wu tag sig á syu. Big ri zìm abig zìg kà yag ku mà finn tonn-à ni, abig jag wann ku á pyànn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Big zìm abig du kà yag ku áyau bìr mpìr káníng, aku fòr yag á byar Yesu ni. Big dìg fig pyù-à bàna. Sái big nann zu yag mà shinn tonn-à ni mà wai, n fòr yag mà byar Yesu ni, n sìnn wann bi wunù-à níng á pyànn Yesu ni áyau bìr mpìrká ká kwonn kàng kwìb sig ku áni níng, mi ri myàng barà ku na sig á syu-à ni mà pyànn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Barà Yesu myàng mpìrká zìg bi sig ku níng bir hing pìkyinnbá á byarwá ni, í byar-à ku dang rag, “Jàumí, ǹ yafa ya rìghing wù bu pyìrwú.” ");
INSERT INTO jib_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farisawaká ma malamká ri kyab á pìkyinnbá ni, n dang rag, “Mpìr-à níng sìnn kàng sig shinnwá á shinn rà? Ku ri sa bai zìnn Shìdun. Mpìr-à má yafa ya mpìr bu pyìrwá bàna, sái Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu yì rìghing bu-à big ri kyab. Ku bib káníng n rag, “Sáshinn ning ri kyab bu káníng á pìkyinn ná ni àdòníng rà? ");
INSERT INTO jib_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wà ma dang rag, ‘N yafa ya rìghing wù bu pyìrwú,’ ma wà ma dang rag, ‘A dù nann zu ma á kyann kyonn,’ í wà áni fonn kab síg nì rà? ");
INSERT INTO jib_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama má tìya ning rag, mì Wùn Mpìr Jíkwìnn ǹ shi sig ma gbam á dunyaru barà má yafa ya mpìr bu pyìrwá.” I byar-à ku dinya mpìr-à dìr-à wu tag sig níng n rag, “A dù nann zu, á pìnn syuwú, á kàng yag mà luwú ni.” ");
INSERT INTO jib_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A byar-à hi big rag abig myàng níng, ku dab dù nann zu n zìg syuwá, n yag mà luwá ni mi ri swam yan yag zìnn Shìdun á gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kó ni sa mamaki hár zinn sa rìg big, big swam yan Shìdun swam yan yan yan. Big dang rag big myàng hing bu àpyú janá-à níng. ");
INSERT INTO jib_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","I byar-à Yesu fim rìg finn swann-à, mi ri yag. Ku yag n yag dìg mpìr zyun ri zìg bài jànn, wàníng shi sig mà nu swàmwá ni, zìnnwá í Lawi. Ku dang rag a wàníng fim rìg swàm bài jànn-à níng, a wàníng bàg ku. ");
INSERT INTO jib_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi fim rìg swàmwá, n dù n bàg yag rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi bar Yesu a wàníng yag ji buju mà luwá ni, ma mpìrká nìnànn nímá, ma mpìr azìg bài jànnká tìnn. Big ri kwonn ji buju á bìr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ama Farisawaká big malamká dang jír ma yann sukàká n rag, sáshinn ning ri ji kwonn buju ma mpìr bu pyìr káníng rà? ");
INSERT INTO jib_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu zìm n dang rag, “Mpìr-à shi sig ma gbam dìr, ku ri yàn fig adàb dor bàna. Sái mpìr-à dìrwá ma ri wúwa í mpìr-à ri yàn kyann adàb dor. ");
INSERT INTO jib_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N bi sig á dunyaru jirà ń dinya mpìr bu pyìrká abig vim bìr bi pìkyinnbá á byar Shìdun. N bi fíg á byar mpìrká ri kyab rag big í mpìr sìsàn níng bàna.” ");
INSERT INTO jib_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Big dang rag, “Yann sukà Yohanna big ri sìnn kyann nu sìnn, mi ri vig Shìdun tìnn. Hár yann sukà Farisawaká má ri sa àdòníng tìnn. Ama yann sukàwú big ri ji, mi ri wa.” ");
INSERT INTO jib_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu bib big rag, “Ning ri kyab rag sai-à mpìrká ma ri nu ban bá sìnn nu rà? Bá sìnn fig nu bàna. Bá ji buju ma mpìr-à zìg sig uwà-à níng. ");
INSERT INTO jib_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama àyúnn-à ki ma zìg rìghing wunù-à níng, àyúnn-à níng hi jàuwá big má sìnn nu.” ");
INSERT INTO jib_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu sa misali n dang rag, “Wá gib ka jà àpyú, má kwìb bàg kwonn ma jà àkor rà? Wi. Sái jà àpyú bá kwìb bàg kwonn ma àpyú. Ma í nímá bàna, àkor-à má ka zu rìg. Má bànn kwonn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mpìr má wìr kà fig zàn inabi àpyú á wau àkor bàna, zàn inabi àpyú sái wau àpyú tìnn. Zàn inabi àpyú ba wìr kà hing á wau àkor má lib gbànn kìfinn rìg, wau-à má ka rìg. ");
INSERT INTO jib_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Zàn inabi àpyú big ri wìr kà á wau àpyú. ");
INSERT INTO jib_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kó ni zìm kab sig zàn inabi àkor ma àpyú-à. Big dang rag, ‘Sù àkwor-à sàn kab síg nì.’ ” ");
INSERT INTO jib_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayúnn su zyun í àyúnn Asabar, Yesu ri wam zu yag ma yann sukàwá big á da jímyànn zyun ni. I byar-à yann sukàwá big gbar kab jímyànn-à, mi ri pìg zwam. ");
INSERT INTO jib_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sái Farisawaká káhi dang rag, “Bu-à sa ning ri sa bu-à á dokayí ni sàn fig wà abig sa àyúnn Asabar bàna í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","I byar-à Yesu bib big n rag, “Asái ning jangga fig bu-à Dawuda rì sa sig bàna rà? Ku fig amor ku ma mpìrká ku ma káníng ri yag kyìnn í zyun. ");
INSERT INTO jib_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ku kà yag mà lu Shìdun ni, ku zìg brodi-à big wib sig Shìdun ma kàhi níng, n ji n ya mpìrká buwá a káníng ji tìnn, wà zyun-à sàn fig wà abig ji bàna, sái àgbamká ri twìb swànn bu á pyànn Shìdun ni níng má ji í ni. Ama big ji rìghing.” ");
INSERT INTO jib_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","I byar-à Yesu dang vinn rìg jír-à n rag, “Mì Wùn Mpìr Jíkwìnn, bigmí ǹ shi sig ma gbam barà má dang bu-à mpìr má sa àyúnn Asabar.” ");
INSERT INTO jib_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ayúnn Asabar zyun, ku yag mà tonn bìr kwonn-à ni, ku ri tàg mpìrká jir Shìdun. Mpìr zyun shi sig áyaubá ni, vìm nùwá wu tag rìghing. ");
INSERT INTO jib_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","I byar-à malamká ma àgbam Farisawaká ri wonn myàng Yesu, kó wàníng má dàb gbam mpìr àyúnn Asabar, jirà abig dìg pyù-à bá dang bai ku. ");
INSERT INTO jib_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu yì rìghing bu-à big ri kyab á pìkyinnbá ni. I byar-à ku dang jír ma mpìr-à vù-à wu tag sig níng, n rag, “A dù nann zu, ma á bi sar áyau bìr mpìr káníng ni áyag.” I byar-à hi wàníng dù n bi sar. ");
INSERT INTO jib_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sái Yesu bib mpìrká ri wonn myàng ku níng jír n rag, “N bib ning jír. Bu-à doka dang sig í kai rà? Sàn sig àyúnn Asabar abig sa bu-à ǹsàn rà, kó bu-à bibai rà? Abig dàb wìm mpìr rà? Kó abig fim mpìr aku wu rà?” ");
INSERT INTO jib_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","I byar-à ku myàng gban rìg káníng bidìm pár n dang rag, wunù-à níng aku gbar lafinn vùwá. Wunù-à níng gbar lafinn vùwá àràg barà Yesu dang níng. I nànn-à hi vùwá í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","I byar-à big nànn rìg àgùnn á jír-à níng ni wàni, mi ri dang jír barà bá sa ma Yesu áni. ");
INSERT INTO jib_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ayau suká bó ni, Yesu dù n yag mà wùn mwír zyun ni jirà aku vig Shìdun màhàn. Ku vig Shìdun hár byar kyàr. ");
INSERT INTO jib_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Barà byar-à kyàr àdòníng, ku bar kwonn yann sukàká buwá big, n shig zu mpìr dwib agban pyànà áyaubá ni. Ku dang rag, káníng í yann aswam, bá shi dang kyann jírwá. ");
INSERT INTO jib_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mpìr káníng í Siman, (í wà Yesu vim bìr zìnnwá àpyú big bar ku Bitrus,) ma wunzàwá Andarawus. Kádà níng í Yakubu, ma Yohanna, ma Filibus, ma Bartalamawas, ");
INSERT INTO jib_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Matiyu, ma Toma, ma Yakubu wùn Halfa, ma Siman Zaloti, ");
INSERT INTO jib_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Yahuda wùn Yakubu, ma Yahuda Iskariyoti zyun-à wann tafinn sig Yesu. ");
INSERT INTO jib_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ku ma káníng ri tìg wann bi á wùn mwír-à ni, n fòr bi n sar á byar zyun ni yiyar nímá. Bìr mpìrká nìnànn nímá shi sig màhàn, mpìrká á byar kim kim á jànn Yahudiya bi sig, ma mpìrká á Urushalima, ma mpìrká águnn zàpìr ayunn yiya nímá, big ri bar finn swannká hi Taya ma Sidon. Mpìr káníng bi sig abig fig jírwá, aku dàb gbam big dorbá tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mpìrká wàu-à dab sig níng, ku dàb gbam rìghing big. ");
INSERT INTO jib_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bìr mpìr káníng kó ni ri yàn pyù-à aku tib Yesu, jir kai bàna gbam adàb dor shi sig á byarwá ni. Gbamwá ri dàb gbam mpìrká bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sái ku myàng yann sukàwá big, n dang rag, “Ning mpìr ashi káníng, ná fig àjwár, jir kai bàna ning shi sig á vù Shìdun, ku í kùrná. ");
INSERT INTO jib_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ning mpìrká amor-à ri gban tàma-à níng, ná fig àjwár, jir kai bàna bá pyag ning. Ning mpìrká ri kig nàikitáu tàma-à níng, ná fig àjwár, jir kai bàna ná jwann jonn á pyànn. ");
INSERT INTO jib_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Wà mpìrká ma ri zib ning, ma ngàng ning, ma swau ning, ma shi sig ma pìkyinn-à pìpìr ma ning á jir shinnmí, mì Wùn Mpìr Jíkwìnn, ná fig àjwár. ");
INSERT INTO jib_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aning shi ma pìkyinn-à mìmìg àyúnn-à hi, aning fig àjwár, jir kai bàna ná dìg ladaná mà lu Tayí ni mà wai. Wàníng í barà yàkúká bigbá rì sa sig mpìrká rì dang kyann jir Shìdun níng áni. ");
INSERT INTO jib_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ayáa, ning mpìrká shi sig ma bài, ning dìg rìghing ladaná á myann áyag. ");
INSERT INTO jib_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ayáa, ning mpìrká ri ji mònn tàma-à níng, ná fig amor. Ayáa, ning mpìrká ri jwann jonn tàma-à níng, pìkyinn ná má bai, ná kig nàikitáu. ");
INSERT INTO jib_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ningká big ri swam yan ning tàma-à níng, ná myàng àzing, wàníng í barà yàkúká bigbá rì sa sig áni ma mpìrká zyun-à ri gim ǹsáng rag big í mpìrká ri dang kyann jir Shìdun níng. ");
INSERT INTO jib_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ama mì ri dinya ning, ning mpìrká ri fig jírmí, aning zìm mpìr azíbná. Aning sa ya mpìr azíbná bu-à ǹsàn. ");
INSERT INTO jib_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aning yafa ya mpìrká ri swau ning. Mpìrká ma du kà ning shwìn, aning vig ya big Shìdun aku ya big bu-à big ri zìm. ");
INSERT INTO jib_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mpìr-à ma dab wù vù sung kyìr, kada á dab ku bàna. A gang ya ku sung kyìrwú agunn zyun aku dab jakàng. Mpìr-à ma gbar shwar jàwú, á fim ya ku jà zyun-à dà sig níng, aku zìg rìg tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mpìr-à ma vig wù bu, á ya ku. Mpìr-à ma tùshwar wù buká buwú, kada á yàn kyann ku bàna, à fim ya ku. ");
INSERT INTO jib_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Barà ning ri zìm a mpìr sa ya ning níng, ning má aning sa ya mpìr àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wà na ri zìm íri mpìr azìmná, ná dìg fig bu zyun bàna. Ai kó mpìrká shi sig ma bu pyìr má, big ri zìm mpìr azìmbá tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wà má íri mpìrká ri sa ya ning bu-à ning ri zìm, na zìm kab íri big, ná dìg fig bu zyun bàna. Ai kó mpìr bu pyìrká má, big ri sa àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wà má íri mpìrká ning yì sig bá wa ning tonn í wà ná ya tonn íni, ná dìg fig bu zyun bàna. Ai kó mpìr bu pyìr má ri ya mpìr tonn tìnn, jir kai bàna big ri zìm abig ya kàng big ábibir. ");
INSERT INTO jib_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aning zìm mpìr azíbná big. Aning sa ya big bu-à ǹsàn. Aning ya big tonn. Kada aning kyab wà bá ya kàng ning bàna. Na sa hing àdòníng, Shìdun má ya swàb kà ning wà mà pyànn. Na sa hing àdòníng, ná shi yann Shìdun, jir kai bàna ku ri myàng ashi mpìrká bibai ma mpìrká ri swam yan fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aning myàng ashi mpìr, àràg barà Tayí mà wai ri myàng ashiyí níng. ");
INSERT INTO jib_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kada aning wà kwonn mpìr bàna. Ning má, bá wà fig ning kwonn bàna. Kada aning mam ya mpìr bu-à bibai bàna. Ning má, bá mam ya fig ning bàna tìnn. Aning yafa ya mpìr. Ning má, bá yafa ya ning tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aning ya mpìr bu. Bigná bá màg má mùmònn í wà bá ya kàng ning. Ná dìg ùwài nímá. Na ya hing títi, bá ya ning títi. Na ya hing ùwài, bá ya ning ùwài.” ");
INSERT INTO jib_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu dinya big tinn jír káníng n rag, “Ning myàng hing barà àfau ri gbar àfau rà? Má àdòníng, big pyànà bidìm pár bá kù kà á shar. ");
INSERT INTO jib_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mpìr-à ma ri shwann bu, kwá kab fig mpìr-à ri tàg ku bàna. Ama wà ba tàg byann hing ku, í wà kwá shi àràg mpìr-à tàg sig ku. ");
INSERT INTO jib_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Sáshinn wù ri dinya jàuwú, ku í mpìr-à bibai, ama à sa kab bu bibai-à í ni níng rà? Sáshinn wù ri dinya jàuwú bu shi sig á yìzuwá ni, ama à màm jànn rìghing buwú shi sig ùwài nímá á yìzuwú ni níng rà? ");
INSERT INTO jib_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sáshinn à dinya jàuwú rag, wá wun zu ya ku bu á yìzuwá ni, ama buwú ùwài nímá zyun-à shi sig á yìzuwú ni, à wun zu fig bàna níng rà? Wù mpìr kyinn pyànà, á zìg zu jag ma buwú ùwài nímá shi sig á zuwú ni níng, àjirà á myàng kyàr, ma á zìg zu ya jàuwú buwá tìnn. ");
INSERT INTO jib_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Bín-à ǹsàn má wan fig awan àbai bàna. Bín-à àbai má wan fig awan ǹsàn bàna. ");
INSERT INTO jib_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bá myàng yì bín sìsàn á jir awanwá ni. Mpìr má dìg fig awan ating á bin sí bàna. Mpìr má dìg fig awan murbu á bín bàna. Bín-à ǹsàn big ri myàng yì ku awanwá ni. ");
INSERT INTO jib_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","I barà mpìr shi áni. Mpìr-à sìsàn má dang jír-à ǹsàn, jir kai bàna ku í mpìr pìkyinn-à ǹsàn. Mpìr-à bibai má dang jír-à àbai, jir kai bàna ku í mpìr pìkyinn àbai. Ai bu-à ma shi sig á pìkyinn mpìr, í bu-à kwá dang. ");
INSERT INTO jib_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ning ri bar mì Shinn Luyí, Shinn Luyí. Bu-à sa ning wib fig bu-à mì ri dinya ning bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mpìr-à ma ri bi á byarmí ni, ma ri zìm jírmí, ma wib hing jírmí, má tìya ning misaliwá á shinn mpìr zyun ni. ");
INSERT INTO jib_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ku shi sig àràg mpìr-à mi sig tonn zyun, n kab zwàun hing mìr tonnwá hár ku mi sig á shinn abàn. Zàpìr-à ma pa kà hing á tonn-à ni, má ning fig kinn-à bàna. Bu-à sa níng, ku kab zwàun hing mìr tonn-à. ");
INSERT INTO jib_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mpìr-à ma bàg fig jírmí bàna, shi sig àràg mpìr-à mi sig tonnwá, n kab fig mìr-à bàna. Zàpìr bi n pa kà áni, kinn-à í wim wann rìg-à wìb.” ");
INSERT INTO jib_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Barà Yesu dang vinn rìg jírwá bidìm par á pyànn mpìrká ni, ku í yag rìg-à mà finn swann Kafarnahum. ");
INSERT INTO jib_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sai àgbam soja zyun shi sig màhàn ma wùn luwá, zyun-à ku ri zìm wàni. Wàníng na sig dor, hár shi shirag kwá wù wu. ");
INSERT INTO jib_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","I byar-à hi, ku fig tai big rag Yesu ri bi. Ku swam yag àgbam Yahudawaká, jirà a Yesu bi dàb gbam ya ku fàuwá níng. ");
INSERT INTO jib_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","To. Big vig Yesu ádàn-à, aku bi ma big, aku dàb gbam ya àgbam soja-à níng wùn luwá. Big rag, “Ku fòr hing wà á sa ya ku, ");
INSERT INTO jib_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","jir kai bàna ku ri zìm jíryí. Ku mi ya sig yi tonn shinn kwonn, byar-à yá wib Shìdun áni.” ");
INSERT INTO jib_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","I byar-à hi, Yesu yag ma big. Barà kwá fòr yag mà lu-à hi ni àdòníng, í byar-à àgbam soja-à níng swam yag jàuwá n rag, “Shinn Luyí, àgbam sojaká rag, kada á ya dìrwú shwìn bàna, ku fòr fig wà wá bi á byarwá ni bàna, ");
INSERT INTO jib_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","jir kai bàna ku kinn fig wà kwá bi dìg wù áyág bàna. A dinya ku jír á byar-à à sar sig níng, jirà wùn-à á luwá ni aku gbam rìg. Ku yì hing, jir kai bàna ku shi sig á vù mpìr, ku má, sojaká shi sig á vùwá ni tìnn. Kwa dang rag abig yag, bá yag, abig kàng bi, bá kàng bi. Hár ma fàuwá tìnn, aku sa wàníng kó wà bó, wàníng ri sa. Ku ri zìm á dang á rag aku gbam. Ku yì hing fàuwá má gbam rìg wà wa dang hing.” ");
INSERT INTO jib_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Barà Yesu fig jír-à níng àdòníng, ku sa mamaki. Ku myàng mpìrká ri bàg ku n dang rag, “Kó áyau Israila, ǹ dìg fig mpìr-à má bir pìkyinnwá á byarmí ni àràg mpìr-à níng bàna.” ");
INSERT INTO jib_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Barà mpìr aswam káníng kàng yag níng, big yag dìg fàu-à níng gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nonn fig bàna, Yesu big yann sukàwá big í yag rìg-à mà kauye zyun ni big ri bar Nayin. Bìr mpìrká nìnànn nímá bàg yag sig big. ");
INSERT INTO jib_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Barà big bi fòr á nu nkyun finn swann-à ni àdòníng, sai big dìg kwonn, big ri swann zu bi ki wunù zyun, ku áwinwá ni á finn nàwá ni. Nàwá í uwà ki tìnn. Mpìrká á finn swann-à ni nìnànn nímá bi sig ma ku á bìr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Barà Yesu myàng àdòníng, ashi uwà-à níng pànn rìg kù. Ku rag, “A kig bàna.” ");
INSERT INTO jib_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ku yag fòr mà byar ki-à ni, n tib vù á bín-à big jag kà sig ki-à áni níng. Mpìrká ri swann yag ki-à níng, í sar wann rìg-à, n sìnn wann ki-à á jìnn ni. Ku dang rag, “Wunù-à níng, á dù nann zu, á wìm kàng ma yonki.” ");
INSERT INTO jib_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mpìr-à wu rìghing níng, shi dù nann zu, n dang jír ma mpìrká. Yesu zìg ku, n ya kàng ku nàwá. ");
INSERT INTO jib_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sái zinn pànn vinn rìg big bidìm pár màhàn. Big ri bar swam yan Shìdun n rag, “Agbam mpìr-à ri dang jir Shìdun shi sig áyauyí ni tàma-à níng.” Mpìrká káhi dang rag, “Shìdun bi hing, jirà aku sa shang mpìrká buwá.” ");
INSERT INTO jib_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tai Yesu níng kàng kwìb vinn rìg jànn Yahudiya ma finn swannká tìnn, n yag kó áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yann sukàká bu Yohanna dinya vinn rìg Yohanna bu-à Yesu ri sa. ");
INSERT INTO jib_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ku bar bi yann sukàwá big pyànà. Ku swam yag big á byar Yesu ni abig bib wàníng rag, “Wù í zyun-à Shìdun rì dang sig rag kwá swam bi níng rà, kó ayi shi kir mpìr zyun kim rà?” ");
INSERT INTO jib_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Sái yann sukà pyànà dìg Yesu á byar-à ku ri dàb dor-à níng. Ku dàb gbam mpìrká shi sig ma dor kim kim. Mpìrká wàu dab sig níng, ku ri kan zu wàuká á dìr káníng ni. Ku ri dàb gbam àfauká tìnn. Yann sukà pyànà káníng bib ku jír-à Yohanna dinya sig big níng n rag, “Wù í zyun-à Shìdun rì dang sig rag kwá swam bi níng rà, kó ayi shi kir mpìr zyun kim rà?” ");
INSERT INTO jib_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu dang rag, “Aning yag dinya Yohanna buká ning myàng sig, n fig sig. N dàb gbam rìghing àfauká, big ri myàng rag ma zubá, ǹ dàb gbam rìghing mpìrká ma kyann sar fig kyonn bàna, big ri kyann rag, ǹ dàb gbam rìghing mpìr àkùnnká, ǹ dàb gbam rìghing mpìr sung àkúnnká, big ri fig rag jír, mì ri dàb wìm mpìrká wu rìghing, big ri dù nann zu kàng ma yonkibá, mì ri dinya mpìr ashiká jír ǹsàn á shinn Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aning dinya ku, mpìr-à ma fim fig wà bir pìkyinn á byarmí ni bàna, Shìdun má sa sàn ya ku.” ");
INSERT INTO jib_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Barà yann sukà Yohanna big yag rìg, sái Yesu dinya mpìrká kwonn shi sig ma ku níng jír á shinn Yohanna. Ku bib rag, “Ning yag sig mà awúnn-à ni, ning yag myàng sig í kai rà? Ning yag myàng síg byann zyun-à wàu ri gbar ning rà? ");
INSERT INTO jib_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kó ning yag myàng sig í kai rà? Ning yag myàng síg mpìr-à wìr sig jà sìsàn nímá níng rà? Wíi, mpìrká ri wìr jà ǹsàn níng, í mpìrká mà lu kùr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ning yag myàng sig Yohanna zyun-à Shìdun swam bi sig níng rà? Nn. Ayau mpìrká Shìdun swam bi sig níng, í Yohanna káb nì. ");
INSERT INTO jib_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I Yohanna zyun-à Shìdun dang sig jír á shinnwá ni n rag, ‘Má swam bi jag mpìr-à aswammí á pyànnwú ni. Kwá sa samyib ya wù gbìb-à wá bàg áni.’ ");
INSERT INTO jib_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mì ri dinya ning, áyau mpìrká á dunyaru bidìm pár, Yohanna kab síg nì. Ama kó mpìr-à títi nímá ma kà hing á byar-à Shìdun má na kùrwá níng, ku kab hing Yohanna.” ");
INSERT INTO jib_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mpìrká bidìm pár zìm hing jir Yesu, hár ma azìg bài jànnká. Big bidìm pár big yì hing gbìb Shìdun sàn hing. I byar-à Yohanna wau big dìr batisma. ");
INSERT INTO jib_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iri Farisawaká ma mpìrká ri twìb swànn bu á pyànn Shìdun ni, big ngàng wà Yohanna má wau big dìr batisma. Big ngàng rìg bu-à Shìdun rag abig sa. ");
INSERT INTO jib_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu rag, “Mpìrká tàma-à níng í mpìr sung gbam big. Big shi sig àràg yann sung gbam big. ");
INSERT INTO jib_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Má sa ya ning misali. Big shi sig àràg í yann títi big shi sig á fir jau-à ni. Big dinya bar dìrbá n dang rag, ‘Yi gbà ǹggan ǹsàn, ama ning gbìb fig jau bàna. Yi dài junn ashi, ama ning kig fig nàikitáu bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohanna ji n wa fig ma ning bàna. Ning dang rag ku í mpìr wàu. ");
INSERT INTO jib_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mì Wùn Mpìr Jíkwìnn, mì ri ji, mi ri wa. Ning ri dang rag mì mpìr finn, mì mpìr apyann shin, mì jàu mpìr bu pyìrká, mì jàu mpìr azìg bài jànnká. ");
INSERT INTO jib_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A byar swàm-à mpìr ma ri sa, í byar-à bá yì kó ku í mpìr yar.” ");
INSERT INTO jib_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wunù Farisawa zyun bar Yesu a wàníng yag ji buju mà luwá ni. Ku zìm hing. Barà ku shi wann má ji buju-à àdòníng, ");
INSERT INTO jib_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","uwà àyái zyun á finn swann-à ni fig big rag, “Yesu ri ji buju á lu Farisawa zyun ni.” Sái ku zìg bi byìr zyun-à ri ning swìnn ǹsàn níng á wùn àkwìnn. ");
INSERT INTO jib_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ku bi á sim Yesu ni, mi ri kig, n wìr tag bar Yesu ma zàn mínnwá, n tùn wim rìg ma jinnwá, n mam bar Yesu, n wib ku. N zìg byìr-à níng n wìr ku á bar-à ni. ");
INSERT INTO jib_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wunù Farisawa-à níng kyab á kyinnwá ni n rag, “Yesu nìm má mpìr adang kyann jir Shìdun, ái ku nìm má yì rag uwà níng í uwà àyái.” ");
INSERT INTO jib_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","I byar-à Yesu zìm ya ku, n rag, “Siman, mì ri zìm ń dinya wù bu zyun.” I wà ku rag, “To, á dang, Malam.” ");
INSERT INTO jib_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sái Yesu dinya ku misali yìr jír zyun n rag, “Mpìr zyun ya sig mpìr pyànà tonn bài, ku ya mpìr zyun 500, n ya mpìr zyun 50. ");
INSERT INTO jib_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ama big dìg fig bài-à bá wa kàng ku bàna. Sái ku yafa ya rìg big pyànà bidìm pár. To, áyaubá big pyànà níng, í wa á ni má zìm kab ku rà?” ");
INSERT INTO jib_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siman zìm n dang rag, “N myàng zyun-à tonn bài-à ùwài nímá ku yafa ya sig níng, má zìm kab ku í ni.” Yesu dang rag, “Jírwú à dang níng í ábibir.” ");
INSERT INTO jib_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","I byar-à ku myàng kàng yag uwà-à níng n dang rag, “Siman, á myàng yag uwà-à níng bìnn kir wann sig á jìnn ni áyág. Sai-à ǹ kà bi á luwú ni níng, à ya fig mì zàpìr ń tu barmí áni bàna, ama ku tu ya rìghing mì ma zàn mínnwá, n tùn wim rìghing ma jinnwá tìnn. ");
INSERT INTO jib_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A ngàng rìghing á bib kà fig mì bu aladayí bàna, ama ku bi n bib kà rìghing mì, hár n wib mì n tu barmí. I barà ǹ bi níng, ku ri wib mì. ");
INSERT INTO jib_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A ya fig mì byìr ń pàb á shinnmí ni bàna, ama uwà níng pàb hing mì byìr-à ri ning swìnn á barmí ni. ");
INSERT INTO jib_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","N dinya wù, bu pyìrká buwá nìnànn nímá níng, ǹ yafa ya rìghing ku bidìm pár, jir kai bàna ku shi sig ma kyinn azìm á pìkyinnwá ni. Ama mpìr-à ba yafa ya ku bu títi, ku ri zìm mpìr títi nímá, ku ri zìm sàn fig mpìr bàna.” ");
INSERT INTO jib_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sái ku dinya uwà-à níng rag, “N yafa ya rìghing wù bu pyìrwú big.” ");
INSERT INTO jib_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mpìrká shi kwonn sig ma ku níng dang rag, “Mpìr-à níng bó í ni rà? Hár ku ri dang rag ku yafa ya rìghing mpìr bu pyìrwá.” ");
INSERT INTO jib_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sái Yesu dinya uwà-à níng n rag, “Kyinnwú à bir sig á byarmí ni níng, í bu-à sa ǹ zìg zu sig wù á bu pyìrwú ni. A yag fòr ítau.” ");
INSERT INTO jib_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nonn fig bàna, Yesu dù n yag kyonnwá mà finn swannká ni kim kim mà kauyeká kim kim. Ku ri dinya mpìrká jir Shìdun ma tai àjwár barà Shìdun má na kùrwá. Yann sukàwá big dwib agban pyànà káníng yag sig ma ku í zyun. ");
INSERT INTO jib_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ku ma uwàká káhi yag sig í zyun. I uwàká ku dàb gbam sig káníng dor wàu ma dorká kim kim. Ayaubá ni uwà zyun zìnnwá í Maryamu, ama big ri bar ku Magdaliya, í uwà big kan zu sig ku wàu sùmpyànn á dìrwá ni, ");
INSERT INTO jib_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma Yuwana wà Kuza wùn sukà kùr Hirudus, ma Susanatu, ma uwà káhi nìnànn nímá big ri zìg buká big shi sig ma kàhi, mi ri ya Yesu ma yann sukàwá big. ");
INSERT INTO jib_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","I byar-à mpìrká nìnànn nímá kwonn bi á byar-à Yesu shi sig. Big bi sig mà finn swannká ni kim kim. I wà ku dinya káníng tinn jír n rag, ");
INSERT INTO jib_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Su zyun mpìr zyun yag sig mà dawá ni, n yag minn za. Za-à ku minn sig níng, káhi wìr wann sig á gbìb-à ni. Mpìrká tib wam zu yag sig barbá áni. Ayinnbuká bi n wun ji rìg za-à. ");
INSERT INTO jib_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ká ta kù kà sig á jànn abàn ni níng, nga nann zu, mi í wim wu rìg-à, bu-à sa níng jànn-à yan sig títi nímá á shinn abàn ni. ");
INSERT INTO jib_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yìr za-à ta kù kà sig áyau sí káníng, wài hár mà wai. Sái síká wài n bim gbar gwor rìg. Sa fig shinn bàna. ");
INSERT INTO jib_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ama za-à ku minn sig áyau jànn ǹsàn níng, yìm adau ǹkwònn ǹkwònn nímá kab hing kàun dìb-swana ma wà ku rì minn sig níng.” I byar-à Yesu dang vinn rìg jírwá n rag, “Mpìr-à ma shi sig ma sung-à kwá fig jír, aku fig.” ");
INSERT INTO jib_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","I byar-à yann sukà Yesu big bib ku n dang rag, yìr jír-à ku dang níng í kai ra? ");
INSERT INTO jib_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I byar-à Yesu dang rag, “Bigná big zìm hing aning yì barà kùr Shìdun shi sig áni. Ama ǹ dinya sig mpìrká í tinn jír, jirà abig fig, ama bá yì fig yìr-à bàna. ");
INSERT INTO jib_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Wàníng í yìr jír buká, ǹ nìm dinya sig ning níng. Swai bu káníng í jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Swai buká ta kù wann sig á gbìb-à ni níng, shi sig àràg mpìrká fig sig jir Shìdun. Ama Shaitan bi tonn gban big, n gbar vim bìr rìg pìkyinnbá, n tonn ta kà sig big á gbìb ajànn jirà kada abig bàg gbìb-à má zìg zu big bàna. ");
INSERT INTO jib_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Swai bu-à wà ta kù wann sig á jànn-à yan sig á shinn abàn-à ni níng, shi sig àràg í mpìrká fig hing jir Shìdun n zìm hing ma pìkyinn àjwár ama big bir fig pìkyinnbá áni bàna. Big zìm sig títi nímá. Wà shwìn ma dìg hing big, big í fim rìg-à gbìb Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Swai buká ta kù kà sig áyau sí káníng, shi sig àràg í mpìrká fig hing jir Shìdun, ama big ri kyab shwìn dunyaru. Big ri zìm abig shi mpìr bài, ma abig fig àjwár. Bu káníng ri kan dim big, wà bá bàg Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Swai buká shi sig á jànn-à ǹsàn níng, shi sig àràg mpìrká ri pànn jir Shìdun vù pyànà ma kyinn-à mìmìg mi ri sìnn kà á pìkyinnbá ni mi ri sa swàm ma kàhi. Big shi sig àràg í yìr bu-à má wan awan ǹsàn. ");
INSERT INTO jib_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mpìr ma mònn bàg hing pitila, kwá sìnn kà fig á mìr bunáwá ni bàna. Kwá sìnn má zìg kwài má bir dim fig áni bàna. Kwá sìnn á shinn bu, jirà abig myàng àyarwá. ");
INSERT INTO jib_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Bu-à ba tàm sig bidìm pár, bá zìg zu bi rìg á myann, bu-à ba bir dim sig bidìm pár, bá pù fim rìg bu-à hi. ");
INSERT INTO jib_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“I bu-à sa mì ri zìm aning yì byann, ma aning fig. Mpìr-à ma shi sig ma bu, bá ya swàb kà ya ku. Mpìr-à ma bàna ma bu, kó wà títi-à ku shi sig ma kàhi níng, ba zìg rìg á vùwá ni.” ");
INSERT INTO jib_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na Yesu ma wunzàwá big bi sig á byarwá ni. Ama big dìg fig pyù-à bá fòr yag bàna, jir kai bàna bìr mpìrká nìnànn nímá mònn sig mà byarwá ni. ");
INSERT INTO jib_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sái big dinya ku n rag, “Nàwú ma wunzàwú big bi sig, big sar sig mà myann. Big ri zìm abig myàng wù.” ");
INSERT INTO jib_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu dang rag, “Mpìrká ma ri fig jir Shìdun ma ri wib, í nàmí ma wunzàmí big.” ");
INSERT INTO jib_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ayúnn zyun, ku ma sukàwá big kà á kòr-à ni, ku dang rag abig pìm zu yag mà vù níng-à ni mà jann. Sái big dù n yag. ");
INSERT INTO jib_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Big shi sig áyau kyonn, sái ná zìg rìg ku. I wà shyù pìr, wàu shyù ri gbar á zàpìr-à ni. Hár kòrbá shi shirag má sib rìg. ");
INSERT INTO jib_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sái big yag n yag bar finn zir ku, n dang rag, “Asàin Luyí, Asàin Luyí, yi wu hing.” I byar-à ku í finn zir-à n yan ta wàu-à nài yán, n yan ta zàpìr-à nài yán tìnn. I byar-à hi big í na tag wann rìg-à yirr. ");
INSERT INTO jib_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu rag, “Pìkyinn birná shi á ni rà?” I byar-à zinn sa rìg big, í wà big dang jír ma ba dìrbá, n dang rag, “Mpìr-à níng í ni rà? Hár wàu ma zàpìr ri wib jírwá.” ");
INSERT INTO jib_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sái big bi fòr á jànn Garasinawaká, jànn-à hi shi sig águnn vù-à níng ni. Jànn Galili shi sig mà jann. ");
INSERT INTO jib_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Barà ku ri tìg wann bi á kòr-à ni àdòníng, sái ku dìg kwonn ma mpìr-à wàu dab sig, í mpìr-à màhàn. Wàu dab sig ku nonn hing. Ku bàna big lu. Ku ri kyann mìr áyonn byànntí bàna. Ku ri na kyann mà amirká ni. ");
INSERT INTO jib_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Barà ku myàng Yesu àdòníng, ku bìnn kir wann á jìnn ni, n gbam nài gbam n rag, “Yesu Wùn Shìdun, bu-à du wù ma mì í kai rà? Mì ri vig wù kada á ya mì shwìn bàna.” ");
INSERT INTO jib_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bu-à sa ku vig Yesu àdòníng, í jirà Yesu dinya rìghing wàu-à, n rag a wàníng zu á dìr wunù-à níng ni. Wàu-à níng ri sa shi ku kó ákaun. Big ri sìr ku á jùr kó sarka, vùwá ma barwá, mpìrká sar sig big ri myàng ku. Ku ri síg mi ri gbar gib rìg jùr-à ma sarka big sìr sig ku áni níng. Wàu-à níng ri zìg yag kyann ku mà awúnn-à ni. ");
INSERT INTO jib_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu bib ku rag, “Zìnnwú í kai rà?” Ku dang rag, “Zìnnmí í Bìr.” Bu-à sa níng, wàuká hi nànn hing á dìrwá ni. ");
INSERT INTO jib_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wàuká vig n vig jakàng, n dang rag, kada aku kan zu big bàna. Wà kwá kan zu big, kada aku kan yag big mà byar pyìr bàna. ");
INSERT INTO jib_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Byar-à zyùká ri yàn ji buju á dìr mwír-à ni, wàuká vig Yesu n rag, aku tìr yag big abig yag kà á dìr zyùká bó ni. Ku ya big pyù-à. ");
INSERT INTO jib_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","I byar-à wàu káníng gàb rìg dìr ma wunù-à níng, n yag kà á dìr zyù káníng ni. I byar-à zyù káníng shàr yag ma shàu n yag shàr kù kà rìg mà nu gàin zàpìr-à ni, mì wa wu vinn rìg-à bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sái mpìrká ri kan kyann zyù káníng, shàr kàng yag mà finn swann-à ni ma kauyeká tìnn, n dinya mpìrká tai bar bu-à sa sig. ");
INSERT INTO jib_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A byar-à hi ni, bìr mpìrká shàr kwonn bi, abig bi myàng bu-à sa sig. I wà big myàng mpìr-à big kan zu sig wàu-à á dìrwá ni níng, shi sig á pyànn Yesu ni, n wìr kà rìghing jà. Ku shi sig rag ma kyinnwá ǹsàn nímá. I byar-à bìr mpìrká shi sig níng, zinn pànn rìg big. ");
INSERT INTO jib_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","To. Mpìrká myàng sig bu-à sa sig níng, big dinya bìr mpìrká níng barà Yesu dàb gbam sig wunù-à níng áni. ");
INSERT INTO jib_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","I wà kó ni vig Yesu n dang rag a wàníng yag, a wàníng fim big dò jir bu zinn-à wàníng sa ya sig big níng. I byar-à hi ku dù n yag kà á kòr-à ni, n fim rìg jànn Garasinawaká, n yag rìg mà níng ùwài-à ni mà jann. ");
INSERT INTO jib_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mpìr-à big kan zu sig ku wàu káníng dinya Yesu n dang rag aku ma wàníng yag zyun. Yesu ngàng, ");
INSERT INTO jib_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","n dang rag, “A kàng yag mà byar yiwaiwú big ni, á dinya big bu mamaki-à Shìdun sa ya sig wù.” I byar-à ku kàng yag, mi ri swam yan Yesu jir bu mamaki-à wàníng sa sig níng. ");
INSERT INTO jib_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mpìrká ri shi kir ku mà agunn zàpìr-à mà jann. Ku yag fòr, big zìg ku vù pyànà. ");
INSERT INTO jib_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sái mpìr zyun zìnnwá í Yayirus, ku í àgbam á tonn bìr kwonn-à ni, ku bi n bìnn kir wann á pyànn Yesu ni, n vig wàníng n rag, aku ma wàníng yag zyun mà luwá ni, ");
INSERT INTO jib_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","jir kai bàna wùn uwàwá í ńzyun níng, na sig dor, shi shirag kwá wu wu. Wùn uwà níng hi jiwá dwib agban pyànà. I byar-à Yesu yag big Yayirus. Bìr mpìrká ri tib ku. ");
INSERT INTO jib_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uwà zyun shi sig áni. Ku nonn hing ma dor àsà wàjì. Jiwá dwib agban pyànà ma dor wàjì-à níng. Buká á vùwá ni vinn rìghing bidìm pár á byar mpìrká shi sig ma gantí. Walako mpìr-à dàb gbam uwà níng. ");
INSERT INTO jib_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I byar-à uwà níng bònn yag á sim Yesu ni, n tib sung jà wàníng. Sái ku rag aku myàng níng, àsà wàjì-à níng í gib rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sái Yesu dang n rag mpìr-à tib ku níng, í ni rà? Kó ni ngàng rìg. Bitrus rag, “Agbamyí, í bìr yanyín káníng tib pyàr sig wù í ni.” ");
INSERT INTO jib_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu dang rag, kai, mpìr zyun tib hing ku, jir kai bàna ku fig hing gbam zu hing á dìrwá ni. ");
INSERT INTO jib_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Uwà níng myàng kwá tàm jànn sar fig shinnwá bàna. Dìrwá ri zwab. Ku bi n bìnn kir wann á pyànn Yesu ni áyau bìr mpìrká ni, n dinya wàníng bu-à sa ku pànn sig sung jà wàníng, hár ku gbam rìghing á sai-à níng hi ni. ");
INSERT INTO jib_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu dang rag, “Wùnmí, pìkyinn birwú à bir sig á byarmí ni níng dàb gbam rìghing wù. A yag fòr mà lu-à ni ítau.” ");
INSERT INTO jib_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Barà ku ri dang jír àdòníng, sái ku myàng mpìr zyun bi sig mà lu àgbam Yahudawaká ni n dang rag, “Ai wùnwú wu rìghing. Kada á sa shi rag Malam bàna.” ");
INSERT INTO jib_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ama barà Yesu fig àdòníng, ku dinya Yayirus n rag, “Kada á gib kyinn bàna, á bir pìkyinn á byarmí ni. Wùnwú má wìm kàng rìg.” ");
INSERT INTO jib_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Barà ku yag fòr mà lu Yayirus ni, ku zìm fig wà a mpìr zyun bàg kà yag ku bàna, sái Bitrus ma Yohanna ma Yakubu, sái nà wùn-à ma ta wùn-à. ");
INSERT INTO jib_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bìr mpìrká ri kig nài ki ma nài yán wàni jir shinn wùn uwà níng. Ama Yesu rag abig shi kim. Ai ku wu fig ki bàna, ku ri na aná. ");
INSERT INTO jib_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sái big jwann ku jonn yawari. Big yì rìghing wà wùn uwà-à níng wu rìghing. ");
INSERT INTO jib_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sái ku pànn wàníng á vù-à ni n bar wàníng n rag, “Wùnmí, á dù nann zu.” ");
INSERT INTO jib_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","I byar-à wùn uwà-à níng í wìm kàng rìg-à ma yonki, n dù nann zu. Yesu dang rag, to abig ya ku buju. ");
INSERT INTO jib_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I byar-à nàwá ma tawá sa mamaki. Yesu twìb big byur n dang rag, kada abig dinya mpìr bu-à sa sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ayúnn zyun Yesu bar kwonn bi vinn rìg yann sukàwá big dwib agban pyànà, n ya big gbam abig kan zu wàu, abig dàb gbam mpìr dorká. ");
INSERT INTO jib_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I byar-à hi ku tìr yag rìg káníng kó áni, abig dinya kó ni jír á shinn barà Shìdun má na kùrwá, abig dàb gbam mpìr dorká abig dìg gbam dìrbá. ");
INSERT INTO jib_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ku dinya káníng rag, “Kyonn-à ná kyann níng, kada aning zìg tun bàna, aning zìg lúr bàna, aning zìg buju bàna, aning zìg bài bàna, aning zìg jà pyànà bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lu-à na kà bidìm pár, aning shi màhàn, hár àyúnn-à ná dù. ");
INSERT INTO jib_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mpìrká ma shà fig ning bàna, aning fim finn swann-à hi, aning pìm kyàr rìg àzwìmká á barná ni, wàníng tàg sig rag mpìr káníng ngàng sig jir Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sái big dù n yag, mi ri kyann á kauyeká ni, mi ri dang jir Shìdun, mi ri dàb gbam mpìr dorká tìnn. ");
INSERT INTO jib_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Barà Kùr Hirudus fig tai á shinn Yesu, kyinnwá gib rìghing, jir kai bàna mpìrká káhi dang rag, “I Yohanna wàrì wu sig níng, wìm kàng síg nì.” ");
INSERT INTO jib_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","I wà mpìrká káhi dang rag, “I Iliya kàng bi síg nì.” Mpìrká káhi dang rag, “I mpìr adang kyann jir Shìdun zyun kàng bi síg nì.” ");
INSERT INTO jib_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kùr Hirudus dang rag, “N gib kìm rìghing shinn Yohanna. Mpìr-à mì ri fig taiwá níng í ni rà?” Hirudus ri zìm aku myàng Yesu. ");
INSERT INTO jib_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","I byar-à yann aswam Yesu big kàng bi, big dinya ku buká big sa sig. Ku zìg yag rìg íri káníng mà swann zyun ni, big ri bar Batsaida. ");
INSERT INTO jib_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Barà bìr mpìrká fig tai-à big kan bàg ku. Ku shà big, n dinya big jír á shinn barà Shìdun má na kùrwá. A byar-à níng hi, ku dàb gbam mpìr dorká. ");
INSERT INTO jib_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","I nànn-à hi, àyúnn-à dab gang rìghing, sái yann aswamwá big dinya ku n rag, “Byar-à níng í awúnn. A dwim gàfinn dìr ma mpìr káníng jirà abig yag yàn buju mà daká shi yàr sig ma yi níng, ma kauyeká. Abig yàn byar ná ma bu-à bá ji tìnn, jir kai bàna buju bàna áyag.” ");
INSERT INTO jib_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ku dinya yann sukàwá big rag, “Ning ma shinn ná aning ya big buju abig ji.” Big dang rag, “Buju bàna, íri brodi àkunn swana ma jái pyànà. Yá yag wann ya mpìr káníng buju rà?” ");
INSERT INTO jib_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Big sa hing àràg wunù dubu swana màhàn. Yesu dang rag, “Aning dinya big abig shi wann á jìnn ni kyau kyau àràg mpìr dìpyànà agban dwib.” ");
INSERT INTO jib_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Big sa àdòníng. Kó ni shi wann á kyauwá ni. ");
INSERT INTO jib_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sái Yesu zìg brodi àkunn swana ma jái pyànà níng, n myàng yag zuwá mà wai n sa Shìdun ísoko. I wà ku ngir gbànn gàfinn awín awín, n ya yann sukàwá big, abig gàfinn ya bìr mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bìr mpìr káníng ji hár n ji mònn rìg finnbá. Yann sukàwá big wun kwonn brodi-à ma jái-à dà sig níng, mònn gágsàg dwib agban pyànà. ");
INSERT INTO jib_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Su zyun Yesu shi sig á byar awù, mi ri vig Shìdun màhàn. Ku ma yann sukàwá big í zyun. Ku bib káníng rag, “Mpìrká ri kyab rag mì í ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yann sukàwá big dang rag, “Mpìrká kyab rag wù í Yohanna awau dìr batisma, káhi dang rag wù í Iliya, káhi ri kyab rag wù í mpìr adang kyann jir Shìdun áyau ká rì wu sig níng, à kàng bi síg nì.” ");
INSERT INTO jib_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu bib big n rag, “Ma bigná, ning ri kyab rag, mì í ni ra?” Bitrus dang rag, “Wù í Almasihu zyun-à Shìdun swam bi sig.” ");
INSERT INTO jib_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","I byar-à Yesu dinya yann sukàwá big n rag kada ba dang swann. ");
INSERT INTO jib_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ku dang rag, “Shi sig àjai, mì Wùn Mpìr Jíkwìnn ń wa shwìn kim kim. Agbam mpìrká ma àgbamká ri twìb swànn bu á pyànn Shìdun ni ma malamká má ngàng mì, hár bá gban rìg mì, bá jì mì, áyau su sara má dù nann zu jakàng ma yonkimí.” ");
INSERT INTO jib_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ku dinya mpìr káníng bidìm pár ǹ rag, “Mpìr-à ma ri zìm aku bàg mì, aku wann tafinn shinnwá, ma aku zìg shwìn-à má bi á dò jir shinnmí ni, í wà aku bàg mì. ");
INSERT INTO jib_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mpìr-à ma ri zìm shinnwá, kwá dìg fig yonkiwá bàna. Ama mpìr-à ma wann tafinn shinnwá á dò jir shinnmí ni, kwá dìg yonkiwá. ");
INSERT INTO jib_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wà mpìr ma dìg gban rìg buká á dunyaru ma dìg fig yonkiwá bàna, buká ku dìg sig níng má swàb kà ya ku kai rà? ");
INSERT INTO jib_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wà mpìr ma shàr zunái barà kwá dinya mpìrká tàma-à níng rag ku í mpìrmí, mì Wùn Mpìr Jíkwìnn má shàr zunáiwá tìnn àyúnn-à ma bi hing ma gbammí ma gbam Tamí ma gbam yann aswamká bu Shìdun mà wai. ");
INSERT INTO jib_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mì ri dinya ning jír àjai, áyauná ni, mpìrká káhi má wu fig bàna, hár bá myàng sai-à Shìdun má na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sai-à ku dang sig jír-à níng sa hing àràg su awinyin, í wà ku zìg Bitrus ma Yohanna ma Yakubu, big yag mà shinnkwìnn-à ni abig vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Barà ku ri dang jír ma Shìdun àdòníng, í byar-à hi, zwánnwá í vim bìr rìg-à. Jàwá mìg shi karrr, mi ri zwàm kpàin kpàin. ");
INSERT INTO jib_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nonn fig bàna sái mpìr pyànà mìr gbìb zu á pyànnwá ni. Big ri dang jír ma ku màhàn. Zyun í Musa, zyun í Iliya. ");
INSERT INTO jib_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mpìr pyànà káníng mìr gbìb zu sig ma gbam Shìdun. Jàbá ri mìg karrr. Big ri dang jír ma Yesu àyúnn-à kwá yag má wu ki mà Urushalima nyàan fòr. ");
INSERT INTO jib_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus ma jàuwá big na jànn rìghing pátág. Barà big rag abig finn zir níng, big myàng barà jà Yesu mìg sig karrr, ku ma mpìr pyànà sar sig zyun. ");
INSERT INTO jib_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Barà mpìr káníng ri fim Yesu àdòníng, sái Bitrus dinya Yesu rag, “Asàin Luyí, barà yi shi sig áyág níng, sàn hing ayi dab apig sara, zyun aku shi í buwú, zyun aku shi í bu Musa, zyun aku shi í bu Iliya.” Ku yì fig bu-à ku ri dang bàna. ");
INSERT INTO jib_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Barà ku ri dang àdòníng, sái akwor bi nim dim rìg big. Barà akwor-à níng kà áyaubá ni, sái zinn pànn rìg big. ");
INSERT INTO jib_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","I byar-à hi nài jír wann bi mà akwor-à ni n dang rag, “Wàníng í wùnmí zyun-à ǹ shig zu sig. Aning fig jírwá.” ");
INSERT INTO jib_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Barà nài jír-à níng jànn rìg àdòníng, sái big myàng Yesu sar sig, kwá áwinwá ni. I byar-à yann sukàwá big pànn shi sig jír bàna á nubá ni. Big dinya fig mpìrká bu-à big myàng sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na kyàr byar-à big tìg wann bi mà shinnkwìnn-à ni. Bìr mpìrká dìg kwonn ma Yesu. ");
INSERT INTO jib_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ayau bìr-à ni mpìr zyun bar nài abor, n dang rag, “Malam, mì ri vig wù á myàng wùnmí. Ku í ńzyun-à níng hi. ");
INSERT INTO jib_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wàu ri sa shi ku, ku ri yan nài yán átai, wàu-à níng ri gbar ta wann ku á jìnn ni. Nuwá ri bìm zu íri ashwib. Dìrwá ri monn. Wàníng ri fim fonn fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N vig yann sukàwú big abig kan zu rìg. Big kan zu yì sar fig bàna.” ");
INSERT INTO jib_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu dang rag, “Kai! Bu-à sa ning bir fig pìkyinn ná á byarmí ni bàna hár táma-à níng í jír kai rà? Ning í mpìr sung gbam big. N sa muyar ma ning hár ákaun rà? A zìg bi wùnwú áyág.” ");
INSERT INTO jib_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Barà wùn-à ri bi á byar Yesu ni, wàu gbar ta wann ku á jìnn ni, dìrwá ri zwab. I byar-à Yesu yan ta wàu-à, n kan zu rìg wàu-à á dìr wùn-à ni, n dàb gbam rìg ku, n zìg ku, n ya kàng ku tawá. ");
INSERT INTO jib_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mpìrká bidìm pár sa mamaki áshinn gbam-à Shìdun shi sig ma kàhi. I byar-à big ri sa mamaki ma bu-à Yesu ri sa, ku dinya yann sukàwá big n rag, ");
INSERT INTO jib_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aning fig byann jírmí. Bá ya kà Wùn Mpìr Jíkwìnn á vù mpìrká ni. Bá du kà ku shwìn.” ");
INSERT INTO jib_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama big fig yì byann fig yìr jír-à níng bàna, jir kai bàna Shìdun tàm rìghing yìr jír-à hi. Big ri shàr zinn wà bá bib ku. ");
INSERT INTO jib_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yann sukàwá big sa yipyàr á shinn mpìr-à má shi àgbam-à áyaubá ni. ");
INSERT INTO jib_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Barà Yesu yì bu-à big ri kyab àdòníng, sái ku zìg wùnshái zyun n sìnn á gàuwá ni. ");
INSERT INTO jib_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ku rag, “Mpìr-à ma pànn hing wùn-à níng vù pyànà á jir zìnnmí ni, shi sig àràg ku pànn síg mì. Mpìr-à ma pànn hing mì vù pyànà, shi àràg ku pànn síg àsàin-à swam bi sig mì, jir kai bàna mpìr awib-à áyauná ni, ku í àgbam.” ");
INSERT INTO jib_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanna dinya ku rag, “Agbamyí, yi myàng hing mpìr zyun ri kan zu wàu á dìr mpìrká ni ma zìnnwú. Yi kan dim rìg ku, jir kai bàna ku ri bàg fig yi bàna.” ");
INSERT INTO jib_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","I byar-à Yesu dinya ku rag, “Kada aning kan dim ku bàna, jir kai bàna mpìr-à ma í mpìr azíbná bàna, í mpìrná.” ");
INSERT INTO jib_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sai-à bá zìg yag ku mà wai nyàan fòr. Ku sìnn rìghing á pìkyinnwá ni kwá yag mà Urushalima. Ku í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ku swam yag yann sukàwá big abig yag jag ku í ni mà kauye zyun á Samariya, jirà abig dinya mpìrká màhàn ku ri bi. ");
INSERT INTO jib_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama mpìrká màhàn ngàng. Bu-à sa níng, big yì rìghing ku ri yag mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Barà sukàwá big Yohanna ma Yakubu myàng àdòníng, big dang rag, “Shinn Luyí, wù ri zìm ayi vig Shìdun aku tìr bi pyìr mà wai aku swànn gban rìg mpìr káníng rà?” ");
INSERT INTO jib_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu vim bìr n yan ta big. ");
INSERT INTO jib_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","I wà big kà á pyànn, big yag rìg mà kauye zyun ni. ");
INSERT INTO jib_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Barà big ri yag á gbìb-à ni, wunù zyun dang rag kwá bàg wàníng byar-à wàníng ma yag bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu rag, “Jwànnzwamká shi sig ma sharbá, ayinnbuká shi sig ma lubá. Ama mì Wùn Mpìr Jíkwìnn, ǹ bàna ma byar shu.” ");
INSERT INTO jib_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ku dinya wunù zyun a wàníng bàg ku. Wàníng dang rag, “Sai tamí ma wu hing, ma jì hing ku, í wà má bàg wù.” ");
INSERT INTO jib_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu rag, “A fim mpìrká zyun-à ri bàg fig mì bàna abig jì kibá. Buwú á yag dang jír á shinn barà Shìdun má na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mpìr zyun dang rag, ku ri zìm aku bàg Yesu, ama ku ri zìm aku yag dwim gàb finn dìr ma mpìrká mà luwá ni ḿpyim. ");
INSERT INTO jib_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu rag, “Mpìr-à ma dang rag kwá bàg fig mì tàma-à níng bàna sái á pyànn, kwá dìg fig byar-à Shìdun má na kùrwá bàna.” ");
INSERT INTO jib_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A sim wàníng ni, Yesu shig zu mpìr dìb-sara agban dwib. Ku tìr yag káníng pyànà pyànà abig yag jág ku nì mà finn swannká ni, kwá bàg yag káníng. ");
INSERT INTO jib_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ku dinya káníng rag, “Bujuká byann rìghing, ama abinnká nànn fig bàna. Aning vig Shìdun Asàin da-à aku swam bi mpìrká zyun-à má binn buju-à hi. ");
INSERT INTO jib_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aning yag. N swam yag sig ning àràg àdùnká áyau bìr jwànnzwamká ni. ");
INSERT INTO jib_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kada aning zìg ashìkáun bài bàna. Kada aning zìg bà bàna. Kada aning zìg tabar bàna tìnn. Kada aning gbar nànn nài bib ma mpìr á gbìb-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Lu-à na tìg áni bidìm pár aning dang rag, Shìdun aku ya mpìr-à níng hi wà sìsàn. ");
INSERT INTO jib_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wà mpìr-à ma shi sig ma pìkyinn-à kyìkyàr màhàn, wà sìsàn-à níng má shi mà luwá ni. Wà mpìr kyinn-à kyìkyàr ma bàna màhàn, wà sìsàn ná má kàng bi rìg á byarná ni. ");
INSERT INTO jib_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aning shi á lu-à níng hi ni, kó kai bá ya ning á lu-à hi ni, ná ji ná wa, jir kai bàna mpìr-à ma ri sa swàm, sàn sig wà abig ya ku buju. Kada aning yag lu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Finn swann-à na kà bidìm pár, ba shà hing ning, kó swai buju-à wà áni wà ba ya ning aning ji. ");
INSERT INTO jib_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aning dàb gbam mpìr dorká. Aning dinya big àyúnn-à Shìdun má na kùrwá nyàan fòr. ");
INSERT INTO jib_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama finn swann-à na tìg ba shà fig ning bàna, aning bàg gbìbká á finn swann-à ni, aning dinya mpìrká, aning rag, ");
INSERT INTO jib_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kó avír-à á finn swann-à ni ma bàg hing á baryí ni, yá pìm kyàr rìg, wàníng tàg sig rag ning ngàng jir Shìdun. Ama aning yì rag àyúnn-à Shìdun má na kùrwá níng, nyàan fòr bi.’ ");
INSERT INTO jib_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mpìrká á finn swann-à níng hi ni má wa shwìn má kab ká á finn swann Saduma. ");
INSERT INTO jib_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mpìrká á Korasinu, ná wa shwìn. Mpìrká á Batsaida, ná wa shwìn. Swàm-à big sa sig á jànn ná ni níng, big nìm ma sa sig á Taya ma Sidon, mpìrká màhàn nìm má fim bu pyìrbá, n nìm má shi kà á sún, ǹ nìm má wìr àswàr jà. ");
INSERT INTO jib_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Shwìn ná má kab bu Taya ma Sidon àyúnn-à Shìdun má wà kwonnwá. ");
INSERT INTO jib_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ning mpìrká á Kafarnahum, ning í mpìr agbar dù shinn. Shìdun má ta kà rìg ning á pyìr.” ");
INSERT INTO jib_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu dinya yann sukàwá big n rag, “Mpìr-à ma ri fig jírná, ku ri fig jírmí. Mpìr-à ma ngàng ning, ku ngàng síg mì. Mpìr-à ma ngàng mì, ku ngàng síg zyun-à swam bi sig mì.” ");
INSERT INTO jib_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mpìrká Yesu swam yag sig dìb-sara agban dwib níng, big kàng bi ma pìkyinn àjwár. Big dinya Yesu rag, “Asàin Luyí, wà ya bar hing zìnnwú, wàuká ri wib jíryí.” ");
INSERT INTO jib_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ku dinya big rag, “N myàng hing Shaitan kù wann bi mà wai àràg í shyù ri zwàm zu. ");
INSERT INTO jib_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","N ya hing ning gbam-à ná tib bushùwí, ná tib nai. N ya hing ning gbam á shinn azíbná big ni. Bá sa fig ning bu bàna. ");
INSERT INTO jib_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kada aning fig àjwár íri jirà wàuká ri wib ning bàna. Ama aning fig àjwár jirà big ba rìghing zìnn ná mà lu Shìdun ni mà wai.” ");
INSERT INTO jib_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A sai-à níng hi Awun Shìdun sa Yesu fig àjwár. Ku dang rag, “I soko buwú Tamí. Wù í àsàin-à pànn sig waisháu ma byar-à á jìnn ni. I soko buwú, jir kai bàna à tàm jànn rìghing yìr bu káníng á byar mpìr yarká ni, ma mpìrká yì sig bu. Ama à tìya rìghing mpìrká zyun-à shi sig àràg í yann wùnshái big níng. Tamí, à sa sig àràg barà pìkyinnwú ri zìm. ");
INSERT INTO jib_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamí ya hing mì ayì á shinn bu bidìm pár. Walai mpìr-à yì sig mì sái Tamí. Walai mpìr-à yì Tamí, sái mì ma mpìrká ká ma dinya sig big barà ku shi sig áni.” ");
INSERT INTO jib_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ku vim bìr, n myàng yag yann sukàwá big, n bònn dinya big n rag, “Zu-à ning myàng sig níng, ning myàng sig í bu-à ǹsàn. ");
INSERT INTO jib_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N dinya ning jír-à níng í jír àjai. Mpìrká rì dang kyann sig jir Shìdun ma kùrká big rì zìm abig myàng bu-à ning myàng sig níng, ama big myàng fig bàna. Big zìm abig fig bu-à ning fig sig níng, ama big fig fig bàna.” ");
INSERT INTO jib_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ayúnn zyun àgbam malam zyun ri zìm aku màg màg fig Yesu. Ku sar dù nann n dang rag, “Asàin Luyí, má sa kai ń dìg yonki kinn kinn rà?” ");
INSERT INTO jib_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu bib ku rag, “Musa ba sig doka rag í kai rà? A jangga sig áshinn rà?” ");
INSERT INTO jib_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sái wunù-à níng zìm n rag, “Musa ba sig rag, ‘A zìm Shinn Luwú Shìdun ma kyinn ńzyun, ma gbamwú, ma yonkiwú, ma bu-à wù ri kyab á kyinnwú ni. A zìm jàuwú àràg barà wù ri zìm shinnwú tìnn.’ ” ");
INSERT INTO jib_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu rag, “A zìm hing jír-à níng ǹsàn nímá, á sa kyann àdòníng, wá dìg yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mpìr-à níng hi ri zìm mpìrká abig myàng ku, ku í mpìr-à ǹsàn. I byar-à ku bib Yesu jír-à níng n rag, “Mpìr-à má shi jàumí í ni rà? Mpìr zyun-à sàn sig ń zìm í ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sái Yesu dang rag, “Mpìr zyun dù sig mà Urushalima, kwá yag mà Yariko. Ku dìg kwonn ma ajwú big. Big jwi vinn rìg buká ku shi sig ma kàhi. Big zìg vinn rìg jàwá tìnn, n dab ku dab dab, n fim ku á gbìb-à ni. Dà sig títi nímá ku wu rìg dà hing. ");
INSERT INTO jib_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Agbam zyun ri twìb swànn bu á pyànn Shìdun ni ri wam zu yag á gbìb-à níng hi ni. Barà ku myàng wunù-à big dab sig níng, ku vinn zu rìg á kur gbìb-à ni, mi í yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A byar-à níng hi, mpìr Balawe zyun-à ri sa swàm á lu Shìdun ni níng, ku má ku bi n kyìg zu á kur gbìb-à ni, n yag rìg tìnn. ");
INSERT INTO jib_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","I byar-à wunù Samariya zyun bi fòr màhàn. Barà ku myàng wàníng àdòníng, ku myàng ashi wàníng. ");
INSERT INTO jib_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ku yag màhàn, n wìr kà byìr ma zàn bín á byarká big dab pòr sig wunù-à níng ni, n sìr gbam rìg byarká big dab pòr sig ku níng ma jà, n gbar dù nann wàníng, n sìnn wàníng á shinn aswannswánnwá ni, n zìg yag wàníng á byar-à kwá tìg níng ni, mi ri dàb dor wàníng. ");
INSERT INTO jib_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na kyàr byar-à ku ya àsàin lu-à bài, dinari pyànà. Ku dang rag, ‘A dàb dor wunù-à níng. Bu-à wa dàb dorwá ma pànn sig píná, ma kàng bi hing, á dinya mì má wa wù.’ ” ");
INSERT INTO jib_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu rag, “Ayau mpìr sara káníng ni, mpìr-à ajwú káníng dab nauna sig níng, íni má shi jàuwá rà?” ");
INSERT INTO jib_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Malam-à níng rag, “I wà zyun-à myàng sig ashiwá níng.” Yesu dinya ku n rag, ku má aku yag sa àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ma yann sukàwá big ri yag kyonnbá. Ku bi fòr á kauye zyun ni. I byar-à uwà zyun zìnnwá í Marta, ku bar Yesu n dang rag a wàníng bi shi á luwá ni. ");
INSERT INTO jib_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ku shi sig ma ajunntun zyun, zìnnwá í Maryamu. Wàníng shi sig á pyànn Yesu, mi ri fig jír-à wàníng ri dang. ");
INSERT INTO jib_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta bó, swàm buju-à ku ri sa níng zìg rìghing pìkyinnwá. Sái ku bi á byar Yesu ni ku rag, “Shinn Luyí, à kyab fig wà ajunntunmí fim ya rìghing mì, má sa swàm buju-à níng áwinmí ni níng bàna rà? A dinya ku aku bi sa shang mì.” ");
INSERT INTO jib_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Shinn Luyí Yesu rag, “Marta, Marta, pìkyinnwú dù nann zu rìghing á shinn buká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","I bu ńzyun sàn kab sig. Maryamu shig zu rìghing bu-à sàn kab sig. I bu-à bá zìg fig á vùwá ni bàna.” ");
INSERT INTO jib_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ayúnn zyun Yesu shi, mi ri vig Shìdun á byar zyun. I byar-à hi wunù zyun áyau yann sukàwá big ni vig ku n dang rag, “Asàin Luyí, á tàg yi barà yá vig Shìdun àràg barà Yohanna tàg sig yann sukàwá big.” ");
INSERT INTO jib_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu dinya big n rag, “Wà ná vig Shìdun, aning dang rag, ‘Tayí wà mà wai, á sa mpìrká abig wib zìnnwú. Byar shu kùrwú aku bi á byaryí ni. ");
INSERT INTO jib_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A ya yi buju àyúnn ma àyúnn. ");
INSERT INTO jib_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A yafa ya yi bu pyìrká yi ri sa, àràg barà yi ri yafa ya mpìrká ri sa yi bu-à bibai níng. Kada á fim yi ayi sa bu-à bibai bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ku dinya big misali jír zyun, n rag, “Mpìr zyun shi sig ma jàuwá zyun. Ku yag á byar wàníng ni á yau fi-à ni, n vig wàníng, n dang rag, a wàníng ya zu ku agir brodi sara, ");
INSERT INTO jib_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","jir kai bàna kyìnn zyun tìg sig á byarwá ni, ku bàna ma bu-à kwá ya wàníng. ");
INSERT INTO jib_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jàuwá má zìm ya ku ma dang rag, ‘Kada á sa shi mì bàna. Bigmí, n kìg rìghing nu nkyunmí. Yi ma yanká bigmí big na wann rìghing. Má dù sar fig ń ya wù bu zyun bàna tàma-à níng.’ ");
INSERT INTO jib_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N dinya ning, wà wàníng ma dù fig jirà ku í jàuwá bàna, ama wàníng má dù jirà mpìr-à níng ri sa shi ku. ");
INSERT INTO jib_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mì ri dinya ning, aning vig, bá ya ning. Aning yàn, ná dìg. Aning kwìb nu nkyun-à, bá pù ya ning. ");
INSERT INTO jib_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mpìr-à ma vig hing, bá ya ku. Mpìr-à ma yàn hing, kwá dìg. Mpìr-à ma kwìb hing nu nkyun-à, bá pù ya ku. ");
INSERT INTO jib_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ning mpìrká shi sig ma yann, wà yanká buná ma vig ning jái, ná ya big bushùwí rà? ");
INSERT INTO jib_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kó wà ba vig kìn kwìnn, ná ya big í nai rà? ");
INSERT INTO jib_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","To. Aning myàng, ning zyun-à ning í mpìrká bibai má, ning yì hing barà ná ya yanká buná big bu-à ǹsàn, n bi bib Shìdun zyun-à í Tayí mà wai, kwá ya mpìr-à ma ri vig ku Awun Kyìkyàrwá.” ");
INSERT INTO jib_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ayúnn zyun Yesu ri kan zu wàu á dìr mpìr zyun ni. Wàu-à níng ri kan dim mpìr-à níng wà dang jír. Barà Yesu kan zu rìg wàu-à níng, wunù-à níng dang rag jír. Bìr mpìrká màhàn níng sa mamaki. ");
INSERT INTO jib_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama mpìrká káhi dang rag, ku ri kan zu wàuká níng ma gbam Baalzabul kùr wàuká. ");
INSERT INTO jib_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mpìrká káhi ri zìm abig màg màg fig ku. Big vig ku n dang rag, aku tìya big bu-à má ya big mamaki, jirà abig yì ku bi síg mà byar Shìdun ni àjai. ");
INSERT INTO jib_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ku yì rìghing bu-à big ri kyab á pìkyinnbá ni. I bu-à sa, ku dang rag, “Jànn-à ma gàb finn hing shinnwá byar pyànà, ba ri gbìb shùr, jànn-à hi má nonn fig bàna. Finn lu-à ma gàb finn hing kyau pyànà, finn lu-à hi má nonn fig bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Shaitan ma gàb finn hing kyau pyànà, kwá sa sar fig bu bàna. Mì ri dinya ning jír-à níng, jir kai bàna ning dang rag, mì ri kan zu wàuká ma gbam Baalzabul. ");
INSERT INTO jib_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aning dinya mì, mpìrká buná ri kan zu wàuká ma gbam ni rà? Big ri kan zu ma gbam Shaitan rà? A jir shinn wàníng ni, bá wà ning kwonn. ");
INSERT INTO jib_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Shi fig àràg barà ning ri dang bàna. Mì ri kan zu wàu káníng ma gbam Shìdun. Wàníng ri tàg rag byar shu kùr Shìdun bi hing á byarná ni. ");
INSERT INTO jib_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wà mpìr gbam zyun ma sar sig á luwá ni ma tàu ma bìg, ma ri myàng kwonn ma buká buwá big, buká buwá big má jànn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wà mpìr-à ma gbam kab ku ma bi hing, ma tùshwar vinn rìghing bu-à ku sar gbam sig áni, wàníng má zìg vinn rìg buká buwá big, má gàb finn vinn rìg. ");
INSERT INTO jib_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mpìr-à ma bàg fig mì bàna, ku í mpìr azíbmí. Mpìr-à ma zà kwonn shang fig mì zaká bumí bàna, ku í àsàin-à ri sa yam kìfinn.” ");
INSERT INTO jib_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wà wàu ma zu hing á dìr mpìr, kwá yàn byar-à aku shi ngàng awunwá, ama kwá dìg fig bàna. Kwá dang rag kwá kàng yag rìg mà byar-à ku nìm zu bi sig. ");
INSERT INTO jib_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kwá kà kàng yag hing mà dìr mpìr-à níng ni, kwá dang rag lu-à sàn hing, n kyàr hing. ");
INSERT INTO jib_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kwá yag, má yag dinn zìg bi wàu sùmpyànn, ká bai kab ku. Bá shi màhàn. Mpìr-à níng má wa kab shwìn tàma-à níng ma wàrì.” ");
INSERT INTO jib_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Barà ku ri dang jír àdòníng, uwà zyun áyau bìr-à ni, dang jír ma gbam, n rag, “Uwà mà sig wù n pyag gbam sig wù níng, kwá fig àjwár.” ");
INSERT INTO jib_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ama Yesu dang rag, “Mpìrká ri fig jir Shìdun mi ri wib níng, í mpìrká má fig àjwár.” ");
INSERT INTO jib_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Barà bìr mpìrká ri bi swàb kà á byar Yesu, ku dang rag, “Mpìrká á jànn-à ni tàma-à níng, big ri sa bu-à bibai. Big ri vig mì bu-à má ya big bu mamaki. Má sa ya fig big bu mamaki bàna, sai àràg bu Yunana. ");
INSERT INTO jib_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Barà Yunana shi sig á finn jái su sara níng, í barà mì má, má sa áni àdòníng tìnn. Barà Yunana kàng sig bu mamaki á byar mpìrká mà Nineve níng, í barà mì má mì Wùn Mpìr Jíkwìnn, má sa mpìrká á jànn-à tàma-à níng áni tìnn. ");
INSERT INTO jib_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Uwà zyun-à í kùr ùwài mà agunn àyúnn sàn kyùr, ku bi sig mà byar zyun ni pyunn ninonn nímá, àjirà aku myàng íri yar-à Sulemanu shi sig ma kàhi. Ama tàma-à níng zyun-à kab sig Sulemanu shi sig áyág, ama mpìrká tàma-à níng ri zìm fig abig fig jírwá bàna. Jir wàníng uwà-à níng má dang tir mpìrká tàma-à níng mà byar-à bá wà kwonn-à níng. ");
INSERT INTO jib_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ayúnn-à Shìdun ma wà kwonnwá, mpìrká rì á Nineve má dang tir ning mpìrká tàma-à níng, jir kai bàna wà Yunana dinya big jir Shìdun níng, big dà fim rìghing bu pyìrbá. Mpìr-à kab Yunana shi sig níng. Ama ning dà fim fig bu pyìrná bàna. ");
INSERT INTO jib_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mpìr má mònn bàg pitila má bir dim fig kwài áni bàna. Kwá sìnn kà fig á shar bàna tìnn. Ama kwá sìnn á shinn bu jirà pyìr-à aku yar wann bi, mpìrká abig myàng àyarwá. ");
INSERT INTO jib_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Zuyí shi sig àràg í àyar dìryí. Wà zuyí ma ágbam, dìryí bidìm pár má yar yà zu rìg. Ama wà zuyí ma sàn fig bàna, dìryí má yar la fim fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aning zìm àyar á dìrná ni. Kada aning zìm fi bàna. ");
INSERT INTO jib_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wà dìrná ma shi sig ma àyar, fi bàna, àyar-à níng má sa yar gban rìg dìrná, àràg barà pitila ri yar ya yi níng.” ");
INSERT INTO jib_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Barà Yesu dang vinn rìg jír-à àdòníng, mpìr Farisawa zyun bar ku, aku yag ji buju mà luwá ni. I byar-à Yesu kà yag, n yag shi wann. ");
INSERT INTO jib_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ama Farisawa-à níng myàng Yesu tu fig vùwá bàna, ku sa mamaki. ");
INSERT INTO jib_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","I byar-à Shinn Luyí Yesu dinya ku, n rag, “Ning Farisawaká, ning shi sig àràg akpa big ri tu kyàr íri kwíb-à. Finn-à mà yau í jín. I barà ning má, ning mònn sig íri bu pyìr. ");
INSERT INTO jib_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ning í mpìr àning big, ning yì fig wà Shìdun àsàin-à sa sig kwíb-à níng, í àsàin-à sa sig finn-à bàna rà? ");
INSERT INTO jib_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ning í mpìr jiju. Aning sa bu-à ǹsàn á byar mpìr ashiká ni, ma wà ná shi mpìr jiju. Wà na sa hing àdòníng í wà ná shi mpìr pìkyinn-à sìsàn á pyànn Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ning Farisawaká, buká ning ri sa níng, sàn fig bàna. Ná wa shwìn. Ning ri sa fig bu-à ǹsàn ma mpìrká bàna. Ku má, ning ri zìm fig Shìdun ma pìkyinn ńzyun bàna. Ayau buká ning shi sig ma kàhi kyau dwib níng, ning ri ya Shìdun kyau zyun, hár ashìtá ma jì byù. Bu-à sàn kab sig bàna, aning zìm Shìdun, aning zìm mpìr. ");
INSERT INTO jib_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ning Farisawaká, ná wa shwìn. Ning ri zìm byar shu àgbam á tonn bìr kwonn-à ni. Ning ri zìm abig wib ning mà fir ati-à ni tìnn. ");
INSERT INTO jib_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ná wa shwìn. Ning shi sig àràg amir byar-à mpìrká ri kyann wam zu áni, big yì fig bàna.” ");
INSERT INTO jib_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ayau malamká ni, zyun dang rag, “Malam, wa dang hing àdòníng, wù ri swau yi tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu rag, “Ning malamká ri tàg tarkada Shìdun, ná wa shwìn. Ning zìg swánn lìlìb nímá, n zìg n sìnn kà sig á shinn mpìr káníng ni, big ri tàng kyann ma kàhi. Ning swann shang fig big bàna, kó títi nímá. ");
INSERT INTO jib_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ná wa shwìn. Ning ri sa samyib amir mpìrká rìi dang kyann jir Shìdun, ká yàkúná big rì gban sig. ");
INSERT INTO jib_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ning zìm hing bu-à yàkúná big ri sa sig, wato big gban mpìrká rìi dang kyann jir Shìdun. Ning bó, ning ri sa samyib amir-à. ");
INSERT INTO jib_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","I bu-à sa sai-à rì Shìdun zyun-à shi sig ma yar níng, dang jírwá n rag, kwá swam ya bi big mpìrká má dang jírwá ma yann aswamká buwá. Bá gban káhi, bá du kà káhi á shwìn. ");
INSERT INTO jib_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mpìrká tàma-à níng, ná wa shwìn á jir shinn mpìrká rìi dang jir Shìdun big rì gban sig, tun sai-à big ri màm sig dunyaru. ");
INSERT INTO jib_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mpìrká tàma-à níng, ná wa shwìn bu-à pànn sig daka á ki Habila hár ki Zakariya, zyun-à big rì gban sig áyau byar-à big ri twìb swànn bu mà lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ning malamká ri tàg tarkada Shìdun, ná wa shwìn. Ning zìg rìghing bu-à big ri pù nu nkyun-à áni, byar-à mpìrká má dìg yar. Ning ngàng wà ná kà màhàn, ning kan dim rìghing mpìrká ri zìm abig kà màhàn.” ");
INSERT INTO jib_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Barà Yesu zu bi á lu-à ni àdòníng, sai malamká ma Farisawaká ri swau ku, big ri bib ku jír á shinn buká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Big ri wonn ku, big ri zìm abig pànn ku ma jír buká ku nìm má dang níng. ");
INSERT INTO jib_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","I byar-à mpìrká nìnànn nímá sar kàng kwìb sig ku áni. Big sa hing dubu nìnànn nímá. Káhi ri tib bar dìrbá. Yesu dinya yann sukàwá big n rag, “Aning pànn shinn ná, kada aning bir pìkyinn ná á yisti Farisawaká ni bàna, big í mpìrká ri dang jír nu pyànà. Big sìnn sig shinnbá àràg big í mpìr-à ǹsàn, ama big í mpìr ǹsàn bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bu-à ma shi sig bu bònn tàm, má zu bi rìg á myann, mpìrká má yì rìg. ");
INSERT INTO jib_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bu-à mpìr ma bònn dang sig má zu bi rìg á myann, mpìrká má fig vinn rìg. Bu-à mpìr ma shàm dinya sig jàuwá mpìrká má fig rìg. ");
INSERT INTO jib_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mì ri dinya ning, ning jàumí big, aning shàr zinn mpìrká má gban ning bàna, jir kai bàna bá gban íri wi dìrná átai, ama bá sa fig bu-à má kab gbam bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Má dinya ning mpìr-à ná shàr, aning shàr Shìdun. Na wu hing ku shi sig ma gbam-à kwá ta kà ning á lu pyìr. Ajai, mì ri dinya ning aning shàr zinnwá. ");
INSERT INTO jib_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ning yì fig wà ayinnbu swana bá wann tafinn sule pyànà bàna rà? Ai kó áyau ayinnbu káníng ni Shìdun má màm jànn fig kó ńzyun bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kó jinnká á shinn mpìr má, Shìdun wànn vinn rìghing. To kada aning shàr zinn bàna. Ai ning kab hing ayinnbuká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mì Wùn Mpìr Jíkwìnn, mì ri dinya ning wà na dinya hing mpìrká rag ning í bu Yesu, mì má má dinya yann aswamká bu Shìdun mà wai rag ning í bumí tìnn. ");
INSERT INTO jib_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama mpìr-à ma ngàng hing mì, mì Wùn Mpìr Jíkwìnn, má ngàng ku á pyànn yann aswamká bu Shìdun ni mà wai. ");
INSERT INTO jib_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mpìr-à ma dang hing jír-à bibai á shinn Wùn Mpìr Jíkwìnn, Shìdun má yafa ya ku. Ama mpìr-à ma dang hing jír-à bibai á shinn Awun Shìdun, Shìdun má yafa ya fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Sai-à ba zìg yag hing ning mà pyànn àgbamká mà tonn bìr kwonn-à ni, kó mà pyànn agib jír, kó mà pyànn àgbam jànnká, aning shàr zinn barà ná dang ji jír bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Awun Shìdun má tàg ning yar bu-à ná dang á sai-à hi ni.” ");
INSERT INTO jib_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ayau bìr mpìrká ni, sái mpìr zyun dinya Yesu rag, “Malam, á dinya mpìrmí aku gàb finn ya yi bu ki tayí.” ");
INSERT INTO jib_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","I byar-à Yesu zìm ya ku, n dang rag, “Mpìr-à sìnn kà mì ń gàfinn ya ning bu ki taná í ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ku dang jakàng n rag, “Aning fig, kada aning sìnn pìkyinn ná á buká á dunyaru bàna, jir kai bàna buká á dunyaru má ya fig yi yonki bàna.” ");
INSERT INTO jib_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","I byar-à Yesu dinya big tinn jír n rag, “Mpìr bài zyun dawá sàn sig wàni, ku dìg sig buju ùwài nímá. ");
INSERT INTO jib_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ku kyab á kyinnwá ni n rag, ‘Má sa á shinn rà? N dìg fig byar-à má wìr kà bujuká bumí bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sái ku kyab ku rag, ‘N yì hing bu-à má sa tàma-à níng. Má dab gbànn rìg vonnká bumí bidìm pár, má mi kàng àpyúká ùwài nímá. Má ngàb kà gban rìg bujumí áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","I wà má dinya shinnmí rag, ǹ shi sig ma bu ùwài nímá, hár bu káníng má fòr ji nìnànn nímá. To, má shi ngàng, má ji má wa, má fig àjwár.’ ");
INSERT INTO jib_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Barà ku dang àdòníng, Shìdun dinya ku rag, ‘Wù í mpìr-à bàna ma kyinn. A fi-à níng ni bá zìg rìg yonkiwú. Tàma-à níng ma buwú à yàn dìg sig níng má shi í bu ni rà?’ ” ");
INSERT INTO jib_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","I byar-à Yesu dang vinn rìg jírwá n rag, “To, wàníng má, í barà mpìr-à ma ri yàn ya shinnwá bu nìnànn nímá, ku bàna ma gbìb bu zyun á pyànn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","I byar-à Yesu dinya yann sukàwá big n rag, “Jir wàníng í bu-à sa mì ri dinya ning kada aning kyab jír á shinn byar shuná ni bàna, kó buju-à ná ji, kó jà-à ná wìr kà á dìrná ni. ");
INSERT INTO jib_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yonki kab hing buju, dìr kab hing jà-à mpìr má wìr. ");
INSERT INTO jib_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aning myàng ayinnbuká, big ri tàg fig buju bàna, big ri binn fig buju bàna, big bàna big vonn, ama Shìdun í àsàin-à ri pyag big. Ning kab sig ayinnbuká íni. ");
INSERT INTO jib_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wà ning ma ri kyab jír, jír kyabná má swàb kà ya fig ning yonki bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ná sa sar fig bu títi àràg wàníng bàna, bu-à du ning ma wà ùwài í kai rà? ");
INSERT INTO jib_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Aning myàng awu buká barà big ri wài áni. Big ri sa fig swàm bàna. Big ri pìnn fig shwam bàna tìnn. Mì ri dinya ning jír àjai, Sulemanu ma bàiká ma jàká ku shi sig ma kàhi níng, sàn fòr fig awu bu káníng bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Shìdun í àsàin-à ri sa byannká abig shi ǹsàn, kó wà bá shi nonn fig bàna má. Wà má àdòníng, ning yì fig wà Shìdun má ya ning jà ná wìr bàna rà? Bu-à sa ning ri bir fig pìkyinn ná á byar Shìdun ni bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kada aning kyab bu-à ná ji kó bu-à ná wa á pìkyinn ná ni nìnànn nímá bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","I mpìrká ri bàg fig Shìdun bàna níng, big ri kyab nì bu-à bá ji má wa. Ama bigná Taná Shìdun yì hing bu-à ning ri zìm, kwá ya ning. ");
INSERT INTO jib_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ama aning bir pìkyinn ná á byar Shìdun. I ku kwá ya ning nì bu-à ning ri zìm. ");
INSERT INTO jib_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yanká bumí big, kada aning shàr zinn bàna. Shìdun ri fig àjwár ma ning. Ná dìg byar shuwá, byar-à ku na sig kùrwá. ");
INSERT INTO jib_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aning wann tafinn rìg buká buná, aning zìg bài-à aning ya mpìr ashiká. Na sa hing àdòníng, shi sig àràg ning sìnn ya síg shinn ná ashìkáun bài-à má vinn fig ávinn bàna mà wai byar-à ajwú má fòr yag fig bàna, byar-à ayìgkwài má yìg ji sa bai fig bàna. Na sa hing àdòníng, ná dìg kab kàhi mà wai. ");
INSERT INTO jib_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Byar-à buká buná ma shi sig, í byar-à kyinn ná má shi màhàn tìnn. ");
INSERT INTO jib_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Aning sar gbam samyib á swàmná ni, aning shi samímyib ");
INSERT INTO jib_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","àràg barà yann sukà á lu ri shi kir àyúnn-à shinn lubá má kàng bi mà lu ban-à ni. Kwa kàng bi hing, kwá dìng nu nkyun-à, bá pù ya ku aku kà bi. ");
INSERT INTO jib_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mpìrká ma ri sa ya shinn lubá swàm, shinn lubá ma kàng bi ma dìg big àzír bá fig àjwár. N dinya ning shinn lu-à má dinya big abig shi wann á jìnn ni, kwá sìr gbam dìrwá jirà aku ya káníng buju. ");
INSERT INTO jib_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Fàu káníng má fig àjwár wà shinn lubá ma bi áyau fi, kó yau fi ma wam zu rìghing, wà ba shi sig àzír ba ri shi kir ku. ");
INSERT INTO jib_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ama ning yì hing wà àsàin lu nìm ma yì hing wà ajwú má bi, ku nìm má shi àzír má myàng kwonn ma luwá jirà ajwú aku kà á luwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aning shi àzír. Mì Wùn Mpìr Jíkwìnn, má bi á sai-à ning kyab fig rag má bi bàna.” ");
INSERT INTO jib_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","I byar-à Bitrus bib ku n rag, “Asàin Luyí, tinn jír-à níng wù ri dang ma yi rà, kó wù ri dang big mpìrká bidìm pár rà?” ");
INSERT INTO jib_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu dang rag, “Fàu-à shi sig big yar, n shi sig big gwangga í wà áni rà? Asàin lu ma dìg hing fàu-à shi sig big gwangga, kwá ya kà luwá á vù wàníng ni, a wàníng ya fàuká dà níng buju kó ákaun. ");
INSERT INTO jib_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asàin lu-à ma ya sig fàuwá swàm, kwa kàng bi kwa dìg wàníng ma ri sa, fàu-à hi má fig àjwár. ");
INSERT INTO jib_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mì ri dinya ning jir àjai, kwá sìnn kà wàníng á wàníng myàng kwonn big buká ku shi sig ma kàhi bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama wà fàu-à hi ma dang rag, àsàin luwá má kàng bi fonn fig bàna, wà kwa kà ma ri dab fàuká kádà níng wunùká ma uwàká, wà kwa ji ma wa, ma ri wa pyann shin, ");
INSERT INTO jib_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","àyúnn-à àsàin lu fàu-à níng má kàng bi áni, fàu-à níng má yì fig àyúnn-à hi bàna. Kwá zìg fàuwá níng má sìnn kà mà byar-à bá sìnn mpìrká ri fig fig sung bàna níng. ");
INSERT INTO jib_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Fàu zyun-à ma yì hing bu-à àsàin luwá ma ri zìm aku sa, ama kwa sa fig bàna, bá dab ku gbàr ùwài nímá. ");
INSERT INTO jib_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama fàu zyun-à ma yì fig bu-à shinn luwá ri zìm aku sa bàna, ama kwa sa hing bu-à ma fòr hing wà bá dab ku gbàr, bá dab ku gbàr títi nímá. Mpìr-à ba ya sig ku bu-à ùwài, sàn sig abig dìg bu-à ùwài á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“N bi sig ń tai swànn pyìr á dunyaru, mì ri zìm àràg pyìr-à hi nìm swànn rìghing. ");
INSERT INTO jib_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","N yì hing shwìn nìnànn nímá shi sig á pyànnmí ni. Bá sìnn kà mì áyau shwìn àràg barà big ri sìnn kà mpìr áyau zàpìr mi ri wau ku dìr batisma. ");
INSERT INTO jib_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ning ri kyab rag ǹ bi síg jirà ń jùn kwonn mpìrká í byar ńzyun rà? N bi síg jirà ń gàfinn mpìr. ");
INSERT INTO jib_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A pyànn ná-à níng mpìr swana ma shi sig áyau lu zyun, bá gàfinn rìg big áni kyau pyànà. Kyau zyun mpìr pyànà, kyau zyun mpìr sara. ");
INSERT INTO jib_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta má ngàng wùnwá, wùn má ngàng tawá. Na má ngàng wùnwá, wùn má ngàng nawá. Jwáu má ngàng wà wùnwá, wà wùn má ngàng na nuwá.” ");
INSERT INTO jib_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu dinya bìr mpìr káníng n rag, “Wà na myàng waisháu-à ma pìr hing, ning ri dang rag shyù má tab. I wà shyù-à hi ri tab. ");
INSERT INTO jib_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wà na myàng apírpi ma ri nim kwonn, ning ri dang rag sònn byafàn nyàan sa, í wà sònn byafàn-à hi ri sa. ");
INSERT INTO jib_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ning í mpìrká ri tonn gban mpìr. Ning yì hing barà ná dang jír á shinn waisháu ma jànn-à á jìnn ni, ama ning yì fig bu-à má sa tàma-à níng bàna níng í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bu-à sa ning yì fig barà ná kyab bu-à ǹsàn bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mpìr ma bar sig wù á pyànn agib jír, bu-à wá sa bàna, aning ma ku dang ma jír á gbìb-à ni ḿpyim, jirà aku zìg yag wù mà pyànn agib jír-à ni bàna. Kwa zìg yag hing wù mà pyànn agib jír-à ni, agib jír-à má zìg wù má ya kà wù á vù asìr dìr. Bá kìg wù á tonn fi. ");
INSERT INTO jib_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mì ri dinya wù, bá fim fig wù bàna, sái wà wa wa rìghing bài-à ba yàn á vùwú ni.” ");
INSERT INTO jib_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A sai-à níng hi, mpìrká shi sig màhàn dinya Yesu tai á shinn mpìrká á Galili, ká Bilatus du kà sig big gban sig big á sai-à big ri twìb swànn bu mà lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","I byar-à Yesu bib big n rag, “Ning ri kyab rag, mpìrká á Galili ká big gib gban sig níng, bu pyìrbá kab nì bu mpìrká dà níng, í bu-à sa big gib gban sig big níng rà? ");
INSERT INTO jib_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","N dinya ning, í àdòníng bàna. Wà na fim fig bu pyìrná bàna fa, ná wu vinn rìg bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mpìr dwib agban awinyinká mà Siluwam, ká tonn-à big mi sig lilor nímá mà wai, wim wann big á dìr-à ni n gban rìg big níng, ning ri kyab rag big sa káb nì mpìrká á Urushalima bu pyìr rà? ");
INSERT INTO jib_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","N dinya ning, ái í àdòníng bàna. Wà na dàfinn fig bu pyìrná bàna, ná wu vinn rìg káb.” ");
INSERT INTO jib_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","I byar-à Yesu dinya big tinn jír zyun. Ku dang rag, “Mpìr zyun jann sig bin ating zyun. Ayúnn zyun, ku yag aku pyib awan-à. Ku dìg fig awan áni bàna. ");
INSERT INTO jib_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","I byar-à ku dinya mpìr-à ri myàng da-à níng n rag, ‘A myàng, jimí jana-à níng sara mi ri bi áyág ǹ dìg fig awan ating-à níng bàna. A gib ta wann rìg á jìnn ni. Sáshinn bín-à níng má sar dim byar átai rà?’ ");
INSERT INTO jib_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","I byar-à wunù-à níng dinya àsàin luwá n dang rag, ‘Shinn Lumí, ayi fim ma bín-à níng ji zyun, ayi myàng, má nàm kyàr samyib rìg mìrwá, má sìb kà jànn á mìrwá ni, má wìrkà gantí áni. ");
INSERT INTO jib_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma wan hing ji-à ri bi níng, to. Wà ma wan fig bàna, ayi gib ta wann rìg mìr-à á jìnn ni.’ ” ");
INSERT INTO jib_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ayúnn Asabar Yesu ri tàg mpìrká mà tonn bìr kwonn bu Yahudawaká ni. ");
INSERT INTO jib_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Uwà zyun màhàn wàu dab sig ku, ku na sig dor ji dwib agban awinyin, ku ri kyann lafinn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu myàng ku, n bar ku aku bi, n rag, “Uwà níng, dorwú gbam rìghing.” ");
INSERT INTO jib_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu sìnn vùwá á shinn uwà níng ni. A byar-à níng hi, wàníng kyann lafinn dìrwá, n wib Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama àgbam-à ri sa swàm mà tonn bìr kwonn-à ni níng, nànn Yesu àgùnn, jir kai bàna wàníng dàb gbam sig uwà-à níng àyúnn Asabar. Ku dinya mpìrká n rag, “Su sùnnjin shi sig wà mpìr má sa swàm. Aning bi á àyúnn káníng hi abig dàb gbam ning. Ama kada aning bi àyúnn Asabar bàna.” ");
INSERT INTO jib_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesu dang rag, “Ning í mpìr agbar dù shinn. Ning ri fìnn fig bu apyagká buná mi ri ya fig big zàpìr àyúnn Asabar bàna rà? ");
INSERT INTO jib_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uwà níng í swai Ibrahim. Shaitan sìr ku n du kà ku dor ji dwib agban awinyin. Kó sàn fig wà ǹ fìnn zu ku àyúnn Asabar bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Barà Yesu dang àdòníng, sai mpìr azíbwá big fig zunái. Ama mpìrká dà níng fig àjwár ma swàmká Yesu sa sig. ");
INSERT INTO jib_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu dang rag, “Má mam kùr Shìdun ma kai rà? Má dinya ning barà kùr Shìdun shi sig áni. ");
INSERT INTO jib_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kùr Shìdun shi sig àràg í yìr awan bu títi nímá, big ri bar í masita. Mpìr zyun zìg n yag minn sig mà dawá ni. Bu-à ku minn sig níng, wài n kàng bín. Ayinnbuká sa sig lubá á atàm bín-à hi ni. I barà byar-à Shìdun ri na kùrwá má swàb kà áni.” ");
INSERT INTO jib_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu dang rag, “Ma mam kùr Shìdun ma kai rà? N dinya ning. ");
INSERT INTO jib_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kùr Shìdun shi sig àràg í yisti bu-à ri lílib. Wà uwà zyun ma zìg hing yisti, ma ta kà hing á mìg tasa sara, mìg-à má ji bànn má lib swàb kà.” ");
INSERT INTO jib_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","I byar-à ku dù mà byar-à hi, ku ri yag kyonnwá. Bu-à pànn sig daka mà finn swann-à ni, hár mà kauyeká, agunn-à yág mà Urushalima, ku ri tàg mpìrká jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mpìr zyun bib ku, n dang rag, “Shinn Luyí, mpìrká má dìg yonki kinn kinn níng nànn fig bàna rà?” I byar-à ku dinya káníng rag, ");
INSERT INTO jib_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mì ri dinya ning, aning sa pyù-à aning kà á nu nkyun-à ya fig aya bàna, jir kai bàna mpìrká nìnànn nímá má yàn pyù-à abig kà, bá dìg fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Asàin lu-à má dù nann zu má kìg dim rìghing nu nkyun-à, ná sar sig mà myann mi ri kwìb nu nkyun-à abig pù ya ning aning kà, ná bar má dang rag, ‘Shinn Luyí, á pù ya yi nu nkyun-à.’ Kwá dang rag ku yì fig byar-à ning bi sig bàna. ");
INSERT INTO jib_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ná dang rag ning yì hing ku, ning ji kwonn hing buju ma ku, hár ku tàg hing ning bu á gbìb luná ni. ");
INSERT INTO jib_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kwá dang rag, ‘Wi, ǹ yì fig ning bàna, ǹ yì fig byar-à ning bi sig bàna. Aning dù á pyànnmí ni, ning í mpìrká ri sa bu-à bibai.’ ");
INSERT INTO jib_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ayúnn-à na myàng hing Ibrahim ma Ishaku ma Yakubu ma mpìrká ri dang kyann jir Shìdun ma shi sig mà lu Shìdun ni, bigná bá kan ning. I byar-à ná yì, ná kig nàikitáu, ná zwàm kà vù á nginn wàni, ning yì rag hing bu dìg hing ning. ");
INSERT INTO jib_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mpìrká má bi mà shinn swann, bá bi mà mìr swann, bá bi mà gàu swann agunn vìm nu, ma agunn vìm súr. Bá shi kàng kwìb byar-à Shìdun má na kùrwá. Bá ji buju màhàn. Ama bigná ná yag fòr fig mà byar-à hi ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aning fig, mpìrká nìnànn nímá ká shi sig mpìr ùwài tàma-à níng, bá kàng mà sim. Mpìrká kinn fig bu bàna níng, má yag mà pyànn.” ");
INSERT INTO jib_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ayúnn-à níng hi, sái Farisawaká bi n dinya Yesu rag aku dù kíni, jir kai bàna kùr Hirudus ri zìm a wàníng gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sái ku dinya káníng rag, “Aning yag dinya jwànnzwam-à níng rag, mì ri sa ma swàm áyau janá-à níng ma akìn. Mì ri kan zu wàu, mì ri dàb gbam mpìrká tìnn. Akìn níng má, má shi àdòníng, sái azìnn í wà swàmmí má vinn. ");
INSERT INTO jib_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ama ma yag kyonnmí janá-à níng mà Urushalima. Má fòr azìnn, jir kai bàna sàn fig wà abig gban mpìr-à ri dang kyann jir Shìdun á byar zyun ni bàna, sái mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ning mpìrká á Urushalima! Ning mpìrká á Urushalima! Ning gban rìghing mpìrká ri dang kyann jir Shìdun. Ning ta gban rìghing mpìrká Shìdun swam bi sig níng ma abàn. Mì ri zìm ń tonn ning àràg barà kwìnn ri tonn yanká buwá big, mi ri bir káníng ásàwá ni, ama ning ngàng mì. ");
INSERT INTO jib_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Luná má kàng kànnfinn. N dinya ning, ná myàng fig rag mì bàna, sái àyúnn-à ma kàng bi hing. Ayúnn-à níng hi, ná dang rag, ‘Mpìr-à ri bi á zìnn Shìdun ni níng, a Shìdun ya ku bu-à ku ri zìm.’ ” ");
INSERT INTO jib_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ayúnn Asabar, Yesu yag mà lu àgbam Farisawa zyun ni, jirà aku ji buju màhàn. I byar-à mpìrká ri wonn ku. ");
INSERT INTO jib_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sái ku rag aku myàng níng, mpìr zyun vùwá ma barwá mònn sig, shi sig á pyànnwá ni. ");
INSERT INTO jib_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu bib malam káníng ma Farisawa káníng rag, “Sàn hing wà abig dàb gbam mpìr dor àyúnn Asabar rà, kó sàn fig bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Big pù fig ku nu bàna. Yesu pànn wunù-à níng, mi í ku í dàb gbam rìg-à, n dinya ku rag aku kàng yag mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","I byar-à ku dinya káníng yìr jír zyun n rag, áyaubá ni mpìr zyun ma shi sig ma bu apyag wà ma kù kà hing á shar zàpìr àyúnn Asabar, kwá gbar zu kíni rà, kó kwá gbar zu fig bàna rà? ");
INSERT INTO jib_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","I byar-à hi big pànn shi rìg akim, big dang fig jír bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Barà Yesu myàng mpìrká bi sig buki-à níng ri shig byar shu àgbam byar-à bá shi, í wà ku sa misali n rag, ");
INSERT INTO jib_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wà ba bar wù buki ban, kada á shi á byar shu àgbamká ni bàna, jir kai bàna kó big bar sig mpìr àgbam zyun má bi zyun-à kab wù. ");
INSERT INTO jib_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mpìr-à dwim bar bi sig ning, ning pyànà níng, má dang rag, ‘A dù, á ya mpìr-à níng byar shu-à.’ Wà má àdòníng, zunái má pànn wù. Wá kàng yag má shi mà sim. ");
INSERT INTO jib_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama sai-à ba bar hing wù buki, á yag shi mà sim. A byar-à níng hi, àsàin-à bar sig wù níng, má bar wù rag, ‘Jàumí, á bi shi á pyànn.’ A byar-à níng hi, wá dìg gbam á pyànn mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mpìr-à ma gbar dù shinnwá, kwá fig zunái. Ama mpìr-à ma gbar dù fig shinnwá bàna, bá gbar dù ku.” ");
INSERT INTO jib_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ku dinya mpìr àsàin buki-à níng n rag, “Wà wa bar hing mpìr aku bi ji buju buki, kada á bar íri jàuwú big, kó yiwaiwú big, kó mpìrká buwú big, kó mpìr bàiká ning ma big shi kwonn sig í zyun níng bàna. Wa sa hing àdòníng bá bar pyann kàng wù tìnn. ");
INSERT INTO jib_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sái á bar mpìr ashiká, ma mpìrká barbá wu tag sig ma vùbá, ma mpìr àfau, ");
INSERT INTO jib_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","í wà Shìdun má ya swàb kà wù bu-à wù ri zìm, jir kai bàna mpìr káníng má ya pyann kàng sar fig wù bàna. Ayúnn-à mpìrká bu Shìdun ma dù nann zu kàng hing ma yonki, Shìdun má wa kàng wù.” ");
INSERT INTO jib_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mpìr zyun áyau mpìrka ma Yesu ri ji buju í zyun níng, ku fig jir Yesu. I wà ku dang rag, “Mpìrká ma ji buju-à mà byar-à Shìdun má na kùrwá níng, bá fig àjwár wàni.” ");
INSERT INTO jib_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu dinya ku rag, “Mpìr zyun bar kwonn sig mpìrká nìnànn nímá abig bi ji buju. ");
INSERT INTO jib_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ayúnn-à bá ji buju-à níng màg, ku swam yag fàuwá a wàníng yag dinya mpìrká àyúnn-à màg rìghing, ku sa rìghing buká big ri zìm. ");
INSERT INTO jib_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","I byar-à mpìrká ku bar sig níng, ngàng rìg. Zyun dinya ku n rag, ‘N wann sig da, má yag myàng. Mì ri vig wù, á zìm jírmí, má yag sar fig bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Zyun dang rag, ‘N wann sig nai bu nàm àkunn dwib. Má yag má màg màg fig big. Mì ri vig wù á zìm jírmí, ma á yafa ya mì.’ ");
INSERT INTO jib_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Zyun dang n rag, ‘I wà ǹ zìg sig ma uwà tàma-à níng, í bu-à sa má yag fig bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Fàu-à níng kàng bi n dinya shinn luwá tai-à níng. I byar-à shinn luwá nànn àgùnn, n dinya fàuwá rag, a wàníng zu yag kíni, a wàníng bàg gbìbká á finn swann-à ni, byar-à mpìrká shi sig. A wàníng bar kwonn mpìr ashiká, ma àfauká, ma àkùnnká, ma mpìrká bàna ma bar níng tìnn, jirà mpìr káníng abig ji buju-à níng. ");
INSERT INTO jib_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nonn fig bàna, fàu-à níng dang rag, ‘Asàin lumí, bu-à à dang níng, ǹ sa vinn rìghing. Ama í barà byar shu-à dà sig.’ ");
INSERT INTO jib_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","I byar-à àsàin buju-à níng dinya fàuwá rag, ‘A zu yag, á bàg gbìbká kim kim. A bar kwonn bi mpìrká jirà abig bi mònn á lumí ni. ");
INSERT INTO jib_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N dinya wù, áyau mpìrká yi dwim bar jag sig níng, kó mpìr ńzyun áyaubá ni má ji fig buju-à níng bàna kó títi nímá.’ ” ");
INSERT INTO jib_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mpìrká nìnànn nímá ri bàg ku, ku vim bìr n myàng big, n dang rag, ");
INSERT INTO jib_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mpìr-à ma ri zìm aku bàg mì, aku zìm mì wàni, aku zìm kab mì ma tawá, ma nàwá, ma yiwaiwá big, ma wàwá, ma yanká buwá, hár ma yonkiwá. Má àdòníng bàna, kwá shi sar fig wùn sukàmí bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mpìr-à ma zìm fig wà aku wa shwìn àràg barà má wa níng bàna, kwá shi sar fig wùn sukàmí bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mpìr-à ma ri zìm aku mi tonn, kwá shi wann ma á jìnn ni ḿpyim, jirà aku kyab bài-à má màg bu miwá, hár má kinn. ");
INSERT INTO jib_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kada aku kà bu mi-à átai bàna. Kwá kà hing bu mi-à bàiwá má màg fig bàna, bu mi-à má kinn fig bàna. Mpìrká nìm myàng sig bu mi-à níng má jwann ku, ");
INSERT INTO jib_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","má dang rag, mpìr-à níng kà sig bu mi daka í janá-à níng bàna, hár tàma-à níng ku mi kinn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wà kùr zyun ma dang rag, kwá nu kànn ma kùr zyun, kwá shi wann má dang byann ma ḿpyim, kó soja dubu dwib má nu sar soja dubu dìzyun rà? ");
INSERT INTO jib_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wà kwa myàng má sa sar fig bàna, to, bu-à kwá sa bàna, kwá swam yag mpìrká abig yag dang byann rìg jír-à mà byar kùr pyunn ninonn-à bó ḿpyim a wàníng sa muyar. ");
INSERT INTO jib_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","I bu-à sa ǹ dang rag, ń dinya ning, kó ni ma fim fig buká ku shi sig ma kàhi bàna, kwá shi sar fig wùn sukàmí bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mann í bu-à dudor, ama àdórwá ma zu rìghing, bá sa dor rág ma kai rà? Ai bàna. ");
INSERT INTO jib_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mann-à hi má sàn fig rag bàna, má shi fig í taki-à bá wìr kà á da bàna tìnn. Bá wìr kìfinn rìg átai. Mpìr-à ma shi sig ma sung-à kwá fig jír aku fig.” ");
INSERT INTO jib_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","I byar-à mpìrká ri zìg bài jànn-à níng ma mpìr bibaiká sar sig abig fig jír bu-à ku ri dang. ");
INSERT INTO jib_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sái àgbam Farisawaká ma ká ri tàg bu á tarkada Musa ni níng ri nànn àgùnn, mi ri dang rag, “Haba! Sáshinn mpìr-à níng ri dang kwonn jír ma mpìr bibai káníng rà? Hár big ri ji kwonn buju á bìr-à ni.” ");
INSERT INTO jib_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","I byar-à ku dinya káníng tinn jír n rag, ");
INSERT INTO jib_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ayauná ni mpìr zyun ma shi sig ma àdùn dìb-swana, zyun ma jànn hing, kwá sa í kai rà? Kwá fim rìg dìb-yina agban dwib agban-à zu áni ajinndúbi níng mà awúnn-à ni, jirà aku yag yàn dìg rìg ma zyun-à jànn sig níng. ");
INSERT INTO jib_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kwa dìg hing àdùn-à níng, bu-à kwá sa bàna, kwá dab kà wàníng á wàinwá ni, má kàng bi ma kàhi ma àjwár. ");
INSERT INTO jib_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kwa kàng bi hing á luwá ni, kwá bar kwonn jàuwá big, ma ayor luwá big. Kwá dinya káníng rag ku yàn dìg rìghing àdùnwá jànn sig níng. Kwá fig àjwár, kwá bar káníng a káníng bi fig shang ku àjwár-à níng áni. ");
INSERT INTO jib_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","N dinya ning jír-à níng, Shìdun má fig àjwár wàni mà wai, wà mpìr zyun ma fim hing bu pyìr sa, kab hing mpìr dìb-yina agban dwib agban-à zu áni ajinndúbi, ká zyun-à ri kyab big í mpìr ǹsàn, mi ri kyab fig wà abig fim bu pyìr sa bàna níng. ");
INSERT INTO jib_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kó àràg uwà zyun ma shi sig ma bài kó pam dwib, pam zyun áyau bài káníng ni, ma kù jànn hing. Ai kwá mònn bàg pyìr á pitila, má zà kyàr rìg lu-à, jirà aku yàn dìg rìg bài-à níng, kó nímá bàna rà? ");
INSERT INTO jib_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Uwà níng ma yàn dìg hing bài-à níng, kwá bar kwonn bi jàuwá big ma ayor luwá big, kwá dang rag, ku yàn dìg rìghing bàiwá jànn sig níng, ku ri fig àjwár, kwá sa buju, kwá bar káníng abig bi fig shang ku àjwár-à níng áni. ");
INSERT INTO jib_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","I barà yann aswamká bu Shìdun mà wai má fig àjwár áni tìnn, wà mpìr zyun ma fim hing bu pyìr sa.” ");
INSERT INTO jib_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu dang rag, “Mpìr zyun shi sig ma yann wunù pyànà. ");
INSERT INTO jib_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wùn zyun-à àshái-à níng dinya tawá rag, a wàníng ya ku bu ki-à buwá ma a wàníng wu í ni. A byar-à hi ta-à bi gàb finn ya big bu ki-à byar pyànà. ");
INSERT INTO jib_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A byar-à hi, ku zìg bu ki-à buwá mì yag rìgwá mà jànn zyun ni nunonn nímá, n yag gban vinn rìg bàiwá átai á gbìb-à sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Barà bàiwá bi vinn rìg, amor bi kà á jànn-à ni, ku dìg fig rag buju-à kwá ji bàna. ");
INSERT INTO jib_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A byar-à níng hi, ku yàn swàm á finn swann-à ni. Ku bi dìg swàm á byar mpìr zyun. Asàin lu-à ri swam yag kyann ku aku ya zyùká buju mà da-à ni. ");
INSERT INTO jib_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ku ri zìm aku ji mònn finnwá ma buju-à zyùká ri ji, ama mpìr-à má ya ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wùn-à bi kyab pànn n rag, ái fàuká mà lu tawá ni shi sig ma buju nìnànn nímá, í wà ku shi sig amor ri gban wa ku, ku dìg fig bu-à kwá ji bàna rà? ");
INSERT INTO jib_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kwá yag mà byar tawá ni, má dinya wàníng rag, ‘Tamí, ǹ sa ya hing Shìdun ma wù bu-à sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N fòr fig rag wà má shi wùnwú bàna, ama má shi àràg í wùn-à á luwú ni.’ ");
INSERT INTO jib_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A byar-à hi, wùn-à dù, mì yag rìgwá mà byar tawá ni. “Barà ku ri bi mà gbìb-à ni byar pyunn nunonn nímá, tawá myàng yag ku, ku ri bi, tawá myàng ashiwá n shàr yag mà byarwá ni, n kàm pànn bi ku á lu-à ni. ");
INSERT INTO jib_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wùn-à dang rag, ‘Tamí, ǹ sa hing bu pyìr á pyànn Shìdun ni ma wù tìnn, ǹ sàn fòr fig wà má shi wùnwú bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama ta-à dinya yanká á luwá ni n rag, abig sa kíni abig zìg bi jà ǹsàn ma abig wìrkà ku, abig pag ku tá á vù-à ni, ma tab ǹsàn á barwá ni. ");
INSERT INTO jib_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ku dinya yanká á luwá ni a káníng zìg bi zà nai ǹkwònn-à níng ma abig gib gban jirà abig sa buju abig ji, ma abig fig àjwár. ");
INSERT INTO jib_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‘Wùnmí ǹ rì dang rag ku wu rìghing níng, ku shi sig ma yonki. Ku rì jànn rìghing, tàma-à níng yi dìg hing ku.’ A byar-à hi big gbìb jau, n ji buju, n fig àjwár. ");
INSERT INTO jib_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“A sai-à níng hi, wùnwá àgbam-à shi sig mà da-à ni. Ku ri kàng bi rag á lu-à ni, ku nyàan fòr, sái ku fig mpìrká ri gbà ǹggan, mi ri gbìb jau. ");
INSERT INTO jib_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ku bar wùn zyun á luwá ni, n bib wàníng rag, ‘Buká big ri sa níng í kai rà?’ ");
INSERT INTO jib_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wùn-à á luwá ni dinya ku rag, ‘Wunzàwú kàng bi rìghing. Ibáwú gib gban sig zà nai jirà abig zwam. Ibáwú ri fig àjwár jirà wunzàwú kàng bi hing ítau.’ ");
INSERT INTO jib_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pìkyinn wùn-à àgbam-à í bai rìg-à, ku zìm fig aku kà yag mà byar buki-à bàna. A byar-à hi, tawá zu yag mà myann n vig ku aku kà bi. ");
INSERT INTO jib_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A byar-à hi ku dinya tawá n rag, ‘Ji nìnànn nímá mì ri sa ya wù swàm àràg í fàu, mì ri fig jírwú. Ama kó kàun ńzyun à gib gban fig mì byínn ayi ma jàumí big fig àjwár bàna. ");
INSERT INTO jib_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama wùnwú níng yag gban vinn rìghing bàiwú mà byar uwà àyáiká ni, n kàng bi á lu-à ni, à bi gib gban ku zà nai rà?’ ");
INSERT INTO jib_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ta-à dinya kàng ku n rag, ‘Wùnmí, yi ma wù í zyun kó ákaun. Buká ǹ shi sig ma kàhi níng, í buwú tìnn. ");
INSERT INTO jib_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ayi sa buki jirà ayi fig àjwár, jir kai bàna wunzàwú rì wu rìghing, ama tàma-à níng ku ma yonki. Ku rì jànn rìghing, tàma-à níng yi dìg hing ku.’ ” ");
INSERT INTO jib_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu dinya mpìrká ri bàg ku n rag, “Mpìr bài zyun rì shi sig áni, ku shi sig ma wùn sukà. Mpìrká yag gib mìr wùn sukàwá mà byarwá ni, n rag wàníng ri ji bàiwá. ");
INSERT INTO jib_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ku bar bi wùn sukàwá n bib wàníng rag, ‘Ma buká mì ri fig áshinnwú ni níng í kai rà? A wànn dinya mì buká à sa sig, jir kai bàna wá shi fig rag wùn sukàmí bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wùn sukà-à kyab á pìkyinnwá ni n rag, ‘Asàin lumí kan rìghing mì á swàm. Tàma-à níng má sa rag í kai ra? N bàna ma gbam-à má nàm bu, mì ri sa zunái wà má vig mpìrká bu. ");
INSERT INTO jib_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tàma-à níng ǹ yì rag hing bu-à má sa, jirà kó kwa kan hing mì á swàm, má dìg mpìrká má zìm mì ń yag á lubá ni.’ ");
INSERT INTO jib_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ku bar kwonn mpìrká àsàin luwá ri bàg big tonn bài. Ku bib jag mpìr zyun, n rag, ‘Asàin lumí ri bàg wù píná rà?’ ");
INSERT INTO jib_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wàníng dang rag, ‘Asàin luwú ri bàg mì byìr garwa dìb-swana.’ A byar-à hi ku rag a wàníng zìg tarkada ma a wàníng ba sìnn kà dìpyànà agban dwib. ");
INSERT INTO jib_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","I byar-à ku bib jakàng mpìr zyun n rag, ‘Asàin lumí ri bàg wù píná rà?’ Wàníng dang rag, ‘Ku ri bàg mì bà jímyànn dìb-swana.’ A byar-à hi ku dinya wàníng n rag a wàníng ba sìnn kà bà dìb-yina. ");
INSERT INTO jib_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Asàin lu-à swam yan wùn sukà ri lir ji ku níng jir yar-à wàníng shi sig ma kàhi. Mpìrká ri zìm buká á jànn-à níng ni yar kab sig mpìrká ri bàg Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu dinya big n rag, “Mì ri dinya ning, aning sa bu-à sìsàn ma bàiká ning shi sig ma kàhi á dunyaru, jirà àyúnn-à na bàna ma bài, Shìdun má pànn ning vù pyànà mà luwá ni mà wai. ");
INSERT INTO jib_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mpìr-à ma pànn sàn hing bu títi, kwá pànn yì bu ùwài. Mpìr-à ma pànn sar fig bu títi ma kyinn ńzyun bàna, kwá pànn samyib fig wà ùwài bàna. ");
INSERT INTO jib_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wà na pànn yì sar fig bài á dunyaru bàna, í ni má ya ning bu ǹsàn nímá mà wai rà? ");
INSERT INTO jib_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wà na pànn yì sar fig bu mpìr bàna, í ni má ya ning bu shinn dìrná í ni rà? ");
INSERT INTO jib_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mpìr ńzyun má wib sar fig àsàin lu pyànà bàna, kó kwá zìm zyun, má ngàng zyun. Kwá wib jir zyun, má ngàng jir zyun. Wà na zìm kab síg bài, ná zìm fig Shìdun bàna.” ");
INSERT INTO jib_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisawaká fig jír-à Yesu dang sig níng, big màm jwann ku, jir kai bàna big ri kyab jir bài á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ku dang rag, “Ning í mpìrká ri gbar dù shinn á pyànn mpìrká ni, ama Shìdun yì rìghing bu-à á pìkyinn ná ni. Bu-à mpìrká ri myàng fòr hing bu á pyànnbá ni níng, ama á pyànn Shìdun fòr fig bu bàna. ");
INSERT INTO jib_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sai-à Yohanna rì bi níng, big rìi tàg mpìrká jir doka Musa, ma bu-à yann aswamká bu Shìdun ba sig. Tàma-à níng big ri tàg rag jír á shinn barà Shìdun ri na kùrwá. Kó ni bidìm pár ri zìm aku kà á lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Má fonn káb nì, wà waisháu ma jànn-à á jìnn ni abig pìnn rìg ma wà yìr jir Shìdun ńzyun má jànn. ");
INSERT INTO jib_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mpìr-à ma kan tafinn wàwá ma zìg zyun, ku ri sa àyái. Mpìr-à ma zìg uwà big kan tafinn sig níng, ku má, ku ri sa àyái tìnn. ");
INSERT INTO jib_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Mpìr bài zyun rì shi sig áni, ku rì wìr jà ǹsàn, ku ri fig àjwárwá kó ákaun. ");
INSERT INTO jib_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mpìr ashi zyun shi sig áni. Big ri bar ku Liyazaru. Dìrwá bidìm pár íri yun. Ku ri shi kyann á nu nkyun mpìr bài-à níng ni. ");
INSERT INTO jib_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ku ri fig àjwár aku ji mònn bujuká mpìr bài-à níng ri ji wìr wann á jìnn ni. Báiká bi mi ri tann ji yunwá. ");
INSERT INTO jib_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nonn fig bàna sái Liyazaru bi n wu rìg. Yann aswamká bu Shìdun mà wai bi zìg yag rìg Liyazaru mà byar Ibrahim. Mpìr bài-à níng wu rìg tìnn, big bi kab jì rìg ku. ");
INSERT INTO jib_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ku shi sig mà lu pyìr-à ni mi ri wa shwìn. Ku gbar dù nann zu shinnwá n myàng Ibrahim sar sig pyunn nunonn, ma Liyazaru á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sái ku bar nài abor n rag, ‘Tamí Ibrahim, á myàng ashimí, ma á swam bi Liyazaru aku du kà pwai vùwá á zàpìr, ma aku sa tag shinn anammí, jir kai bàna mì ri wa shwìn á pyìr-à níng ni.’ ");
INSERT INTO jib_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama Ibrahim dang rag, ‘Wùnmí, á kyab. Sai-à wù rì shi sig ma yonki á dunyaru, wù rìi fig àjwár, Liyazaru rìi wa shwìn. Ama tàma-à níng ku ri fig rag àjwárwá, wù bó wù ri wa shwìn. ");
INSERT INTO jib_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iri wàníng bàna má, shar ǹzwàun nímá shi sig áyauyí ni, pyù-à yá yag mà byarná ni bàna. Ning má ná bi sar fig á byaryí ni bàna tìnn.’ ");
INSERT INTO jib_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","I byar-à àsàin bài-à níng í dang-à rag, ‘Tamí, mì ri vig wù á swam yag Liyazaru mà lu tamí ni á dunyaru. ");
INSERT INTO jib_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","N shi sig ma wunzàmí big àkunn swana. Liyazaru aku yag dinya big, kada abig bàg gbìb-à ǹ rì bàg sig níng bàna, jir kai bàna tàma-à níng mì ri wa shwìn á byar-à ǹ shi sig níng.’ ");
INSERT INTO jib_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","I byar-à Ibrahim dang rag, ‘Wunzàwú big shi sig ma tarkada wà Musa ma mpìrká rìi dang kyann jir Shìdun ba sig. Abig jangga ma abig fig jír káníng.’ ");
INSERT INTO jib_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mpìr bài-à níng í dang kàng-à rag, ‘A à, Tamí Ibrahim, mpìr-à ma wu rìghing, ma kàng yag síg nì, bá fig jírwá, bá vim bìr á bu pyìrbá ni.’ ");
INSERT INTO jib_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibrahim dang rag, ‘To, wà ba fig fig jir Musa ma jir mpìrká ri dang kyann jir Shìdun bàna, kó mpìr zyun-à wu rìghing má ma kàng yag, bá fig fig jírwá bàna tìnn.’ ” ");
INSERT INTO jib_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu dinya yann sukàká buwá n rag, “Buká má sìnn mpìr aku sa bu pyìr shi sig áni, ama mpìr-à ma sìnn kà jàuwá a wàníng sa bu pyìr, mpìr-à níng hi má wa shwìn wàni. ");
INSERT INTO jib_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wà mpìr ma du kà wùn zyun áyau yann káníng ni, a wàníng sa bu pyìr, má sàn kab ya ku abig dìnn gbam wann bu wau á wàinwá ni, ma abig ta kà ku á byinn. ");
INSERT INTO jib_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aning shi shuná ma aning hakyira. “Wà jàuwú zyun ma sa wù bu-à ma sàn fig bàna, á dinya ku. Wà kwa vig hing wù, á yafa ya ku. ");
INSERT INTO jib_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kó wà kwa sa wù bu bibai kàun sùmpyànn àyúnn ńzyun, wà kwa kàng bi hing á byarwú ni kàun sùmpyànn, ma dang rag á yafa ya ku, to á yafa ya ku.” ");
INSERT INTO jib_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yann aswamká dinya Yesu rag, “A swàb kà ya yi gbam, jirà ayi bir swàb kà pìkyinn á byar Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu dang rag, “Wà na bir hing pìkyinn á byar Shìdun ni kó títi nímá àràg barà yìr masita shi sig títi nímá níng, ná dang rag a bín-à níng gbìb dù ma mìrwá, ma aku yag jann shinnwá á finn níng-à ni, kwá wib jírná, má yag jann kà rìg shinnwá mà finn níng-à ni.” ");
INSERT INTO jib_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu dang rag, “Wà mpìr-à ma shi sig ma fàu zyun-à ma ri sa ya ku swàm á da-à ni, kó wàníng ma ri za ya ku àdùn, sai-à fàu-à hi ma kàng bi hing á lu-à ni, àsàin luwá ma dinya ku rag aku bi kíni, aku shi wann á jìnn ni, ma aku ji buju rà? ");
INSERT INTO jib_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wi! Kwá dang má rag, ‘A sa ya mì buju ń ji, ń wa. Wà ma ji kinn rìghing, í wà á ji rag buwú ni.’ ");
INSERT INTO jib_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Asàin lu-à má yan fig fàuwá bàna, jir kai bàna wàníng í fàu. ");
INSERT INTO jib_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ning má àdòníng tìnn, sai-à na sa hing bu-à ba dinya ning aning sa, aning dang rag, ‘Bigyí yi fàu. Yi sa sig íri swàmyí.’ ” ");
INSERT INTO jib_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Su zyun Yesu ri yag mà finn swann Urushalima, sái ku zu á gbìb shab jànn Samariya mà jànn Galili. ");
INSERT INTO jib_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Barà ku ri kà yag á kauye zyun ni, sái mpìr dor àkùnn big dwib, big bi dìg ku, n sar sig á gbìb-à ni, big sar sig byar pyunn nunonn. ");
INSERT INTO jib_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","I byar-à hi big bar nài abor n dang rag, “Asàin Luyí Yesu, á myàng ashiyí.” ");
INSERT INTO jib_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Barà Yesu myàng big, ku dinya big rag abig yag mà lu Shìdun, ma abig tàg shinnbá á byar àgbamká ri twìb swànn bu á pyànn Shìdun, jirà a káníng myàng barà big gbam rìghing. Barà big ri yag, sái big rag abig myàng níng big gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Zyun áyaubá ni myàng big dàb gbam rìghing ku, sái ku kàng yag, mi ri swam yan Shìdun ma nài gbam. ");
INSERT INTO jib_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ku bìnn kir wann á jìnn ni, n sa Yesu í soko, ku í mpìr Samariya. ");
INSERT INTO jib_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu dang rag, “Ning í mpìr dwib big dàb gbam sig, ma mpìr ajinndúbiká dà níng shi sig áni rà? ");
INSERT INTO jib_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Asái áyau mpìr káníng ni, mpìr-à má swam yan Shìdun bàna, sái íri wunù kyìnn-à níng áwinwá ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu dinya ku rag, “A dù á yag kyonnwú, à bir hing pìkyinnwú á dìrmí ni, í bu-à sa à dìg sig gbam dìrwú níng.” ");
INSERT INTO jib_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisawaká bib Yesu n dang rag, “Ayúnn-à Shìdun má na kùrwá má fòr ákaun rà?” Ku zìm n dang rag, “Ai àyúnn-à Shìdun má na kùrwá big ri myàng fig á zu bàna. ");
INSERT INTO jib_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","I bu-à ná dang fig rag, ‘Shi sig níng, kó shi sig bó,’ bàna. Ama Shìdun ri na kùrwá á pìkyinn ná ni.” ");
INSERT INTO jib_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ku dinya yann sukàwá big n rag, “Mì Wùn Mpìr Jíkwìnn. Ayúnn su zyun ri bi wà ná zìm aning myàng mì, ama ná myàng fig mì bàna. ");
INSERT INTO jib_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bá dinya ning rag, ‘Almasihu shi sig níng, kó ku shi sig bó,’ aning yag bàna, ma aning yàn ku bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wùn Mpìr Jíkwìnn má kàng bi jakàng, àyúnn-à kwá kàng bi áni níng má shi àràg shyù ri zwàm zu sàu sàu, byar má yar àjirà kó ni má myàng ku. ");
INSERT INTO jib_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama Wùn Mpìr Jíkwìnn má wa ma shwìn kim kim ḿpyim, mpìrká á dunyaru tàma-à níng má ngàng ku, hár má gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Barà rì sa sig á sai-à Nuhu rì shi sig níng, í barà má sa kàng áni àyúnn-à Wùn Mpìr Jíkwìnn má kàng bi á jànn-à ni. ");
INSERT INTO jib_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sai-à Nuhu shi sig á jànn-à ni, mpìrká rìi ji, mi ri wa, big ri sìr ban, mi ri zìg uwà, hár àyúnn-à Nuhu kà á kòr-à ni. I byar-à zàpìr-à bi na dim gban rìg mpìrká á jànn-à ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","I barà sa sig áni á sai-à Lutu rì shi sig áni à jànn-à ni tìnn. Big ri ji mi ri wa, big ri wann, mi ri wann tafinn, big ri tàg buju, mi ri mi tonn. ");
INSERT INTO jib_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mpìrká rìi sa bu káníng, hár àyúnn-à Lutu dù á finn swann Saduma. Shìdun tìr bi pyìr mà waisháu-à ni bi swànn gban rìg big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wàníng í barà má sa áni, àyúnn-à Wùn Mpìr Jíkwìnn má kàng bi áni. ");
INSERT INTO jib_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ayúnn-à hi mpìr-à ma shi sig mà tonn zyun ni mà wai, kada aku tìg wann bi mà tonnwá á jìnn ni aku zìg bu zyun bàna. Mpìr-à ma shi sig mà dawá ni, kada aku kàng bi á lu-à ni bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aning kyab bu-à sa sig wà Lutu. ");
INSERT INTO jib_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mpìr-à ma ri zìm íri yonkiwá, kwá dìg fig bàna. Ama mpìr-à ma ya tafinn hing yonkiwá, kwá dìg wà kinn kinn. ");
INSERT INTO jib_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ayúnn-à ma kàng bi hing, tonn zyun mpìr pyànà ma na sig áni, bá zìg zu rìg mpìr zyun, má fim zyun. ");
INSERT INTO jib_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ayúnn-à hi, uwà pyànà ma ri wau bu í byar ńzyun, bá zìg rìg zyun, má fim rìg zyun.  ");
INSERT INTO jib_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wunù pyànà ma shi sig mà da-à ni, bá zìg rìg zyun, má fim zyun.” ");
INSERT INTO jib_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Big bib n dang rag, “Bu-à hi má sa áni rà?” Ku dinya big ma tinn jír n rag, “Byar-à kiká ma wu na sig, í byar-à shwibká má kwonn yag màhàn.” ");
INSERT INTO jib_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ayúnn zyun Yesu dinya yann sukàwá big tinn jír zyun, tinn jír-à níng ku ri tàg big abig shi vig Shìdun, abig fim vù áni bàna. ");
INSERT INTO jib_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ku dang rag, “A swann zyun ni, agib jír zyun shi sig áni. Ku ri shàr fig Shìdun bàna, ku ri myàng fig mpìr ma jinn á shinn bàna. ");
INSERT INTO jib_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A finn swann-à níng hi, uwà zyun shi sig áni, nùwá wu rìghing. Uwà-à níng ku ri yag kyann á byar agib jír-à ni. Mi ri dinya wàníng rag, ‘A kà ya mì áyaumí ni yi ma mpìr azíbmí.’ ");
INSERT INTO jib_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Uwà-à níng dang kàun nìnànn nímá agib jír-à níng ngàng, ama á sim ku bi n zìm á pìkyinnwá ni, n dang rag, ‘Kó ma ri shàr fig Shìdun bàna, kó ma ri myàng fig mpìr ma jinn á shinn bàna, ");
INSERT INTO jib_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama barà uwà-à níng ri sa shi mì níng, má kà nuwá, jirà kada aku shi sa shi mì bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sái Yesu dang rag, “Aning fig bu-à agib jír-à níng ri dang. Kó kwa ri myàng fig mpìr ma jinn bàna, ama ku kà hing nu uwà-à níng. ");
INSERT INTO jib_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tò wàníng í barà Shìdun má sa áni tìnn, Shìdun má fig jír mpìrká buwá sai-à ba ri vig ku fi ma àyúnn. Kwá ngàng fig big bàna. ");
INSERT INTO jib_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bu-à ba vig ku kwá sa ya rìg big kíni. Jír-à má bib ning í wàníng. Mì Wùn Mpìr Jíkwìnn, sai-à ma kàng bi hing má bi dìg mpìrká ri wib Shìdun íshág rà?” ");
INSERT INTO jib_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mpìrká shi màhàn big rag, big í mpìr kyìkyàr, big í mpìr ǹsàn. Big ri myàng mpìrká dà níng, kinn fig bu á pyànnbá ni bàna. Ku sa ya mpìr káníng misali n rag, ");
INSERT INTO jib_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mpìr pyànà yag sig mà lu Shìdun n yag vig sig Shìdun. Zyun í Farisawa, zyun í mpìr azìg bài jànn. ");
INSERT INTO jib_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sái Farisawa-à níng dù nann zu n vig Shìdun n rag, ‘Shìdun, ǹ gode hing barà ǹ shi fig àràg mpìrká dà níng bàna. Mì í mpìr bu pyìr bàna, mì ri sa fig àyái bàna. Mì ri lir ji fig mpìr àràg azìg bài jànn-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mì ri sìnn nu kàun pyànà áyau su sùmpyànn. Mì ri ya Shìdun buká mì ri dìg, áyau kyau dwib, mì ri ya Shìdun kyau zyun.’ ");
INSERT INTO jib_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Azìg bài jànn-à níng sar sig pyunnwá nunonn nímá. Ku zìm fig wà aku gbar dù nann shinnwá á wai bàna. Ku mìb gwàin pìkyinnwá, n dang rag, ‘Shìdun, á yafa ya mì. Mì í mpìr bu pyìr.’ ” ");
INSERT INTO jib_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu dang rag, “N dinya ning, mpìr-à níng í zyun-à Shìdun zìm sig jírwá. Ku zìm fig jir Farisawa-à níng bàna. Mpìr-à ma gbar dù shinnwá, kwá fig zunái, ama mpìr-à ma gbar dù fig shinnwá bàna, Shìdun má gbar dù ku.” ");
INSERT INTO jib_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mpìrká káhi ya bi Yesu yanká bubá, aku tib káníng vù á dìr. I byar-à yann sukàwá big myàng àdòníng, sái big yan ta mpìr káníng. ");
INSERT INTO jib_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","I byar-à Yesu bar bi yann káníng á byarwá ni, n dinya sukàwá big rag, “Aning fim yann káníng abig bi á byarmí ni. Kada aning kan dim big bàna. Yiri swai yanká àdòníng, bá kà nì mà byar-à Shìdun ri na kùrwá. ");
INSERT INTO jib_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Má dinya ning jír àjai. Mpìr-à ma sìnn kàng fig shinnwá àràg ku í wùnshái bàna, kwá kà fig byar-à Shìdun ri na kùrwá bàna.” ");
INSERT INTO jib_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Agbam zyun bib Yesu n rag, “Malam ǹsàn, bu-à má sa jirà ń dìg yonki kinn kinn í kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sái Yesu bib ku rag, “Bu-à sa à bar mì mpìr sìsàn í jir kai rà? Ai mpìr sìsàn bàna, sái Shìdun kwá áwinwá ni. ");
INSERT INTO jib_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Buwú à yì hing dokaká wá bàg: ‘Kada á sa àyái bàna, kada agban ki bàna, kada á jwi ajwú bàna, kada á gim ǹsáng bàna, awib tawú ma nàwú.’ ” ");
INSERT INTO jib_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mpìr-à níng rag, “Ai mì ri wib doka káníng tun sai-à mì í wùnshái hár tàma-à níng.” ");
INSERT INTO jib_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu dinya ku rag, “Hár tàma-à níng dà sig wù bu zyun. A wann tafinn vinn rìg buká à shi sig ma kàhi bidìm pár. A ya mpìr ashiká bài-à, ma àjirà á bàg mì. I wà wá dìg bu-à sàn kab wàníng mà wai.” ");
INSERT INTO jib_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sái wunù-à níng fig àdòníng, àsà kyag kù kà ku á pìkyinn-à ni, jir kai bàna ku shi sig big bu wàni. ");
INSERT INTO jib_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu myàng ku, ku ri yag, n dinya yann sukàwá big rag, “Shi sig ma shwìn wà mpìr bàiká má kà á byar-à Shìdun ri na kùrwá. ");
INSERT INTO jib_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Má fonn káb nì wà rakumi aku kà á pùr àbònyir, ma wà mpìr bài má kà á byar-à Shìdun ri na kùrwá.” ");
INSERT INTO jib_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mpìrká ká fig sig jír-à níng big dang rag, wà má àdòníng mpìr má wìm zu rà? ");
INSERT INTO jib_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu dang rag, “Bu-à mpìr má sa sar fig bàna, Shìdun má sa sar.” ");
INSERT INTO jib_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","I byar-à Bitrus dang rag, “To, yi fim rìghing buká buyí, yi ri bàg wù.” ");
INSERT INTO jib_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu dang rag, “Má dinya ning, kó ni ma fim hing luwá, ma wàwá, ma wunzàwá big, ma tawá, ma nàwá, ma yanká buwá big á jir shinn Shìdun, ");
INSERT INTO jib_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Shìdun má zìg ku vù pyànà, má ya kab ku buká ku fim sig níng. Ayúnn-à wà kinn shinn, í wà kwá ya wàníng yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ku bar kwonn yann sukàwá big dwib agban pyànà, n dinya káníng, n rag, “Barà ning yì níng, yá yag mà Urushalima. Ya yag fòr hing màhàn, bu-à big rì ba sìnn sig á shinnmí ni, mì Wùn Mpìr Jíkwìnn níng, bidìm pár má sa àràg barà big ba sig. ");
INSERT INTO jib_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bá zìg mì, má ya mpìrká zyun-à í Yahudawaká bàna. Bá dang bai mì, bá màm jwann mì, bá tu wìr mì sháng. ");
INSERT INTO jib_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bá yang mì ashor, bá gban rìg mì, àyúnn su sara má dù nann zu kàng.” ");
INSERT INTO jib_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama yann sukàwá big yì fig bu-à ku ri dang bàna, jir kai bàna yìr jír-à hi shi sig á byar awù. Big yì fig bu-à ku dang sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Barà big yag fòr á Yariko, mpìr àfau zyun shi sig á kur gbìb-à ni, mi ri vig bìr mpìrká bu. ");
INSERT INTO jib_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Barà ku fig bìr mpìrká ri wam zu, ku bib, ku rag, “I kai sa síg nì rà?” ");
INSERT INTO jib_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Big dinya ku, n dang rag, “I Yesu mpìr-à á Nazarat ri wam zu íni.” ");
INSERT INTO jib_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sái ku gbar dù nài jírwá, n dang rag, “Ayáa, Yesu Wùn Dawuda, á myàng ashimí.” ");
INSERT INTO jib_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sái mpìrká kà sig á pyànn-à níng kan dim rìg ku, aku pànn shi rìg. Ama ku shi, mi ri wa nài yán ngbam nímá. Ku dang rag, “Ayáa, Yesu Wùn Dawuda, á myàng ashimí.” ");
INSERT INTO jib_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sái Yesu sar, n dang rag abig zìg bi mpìr-à níng á byarwá ni. Barà ku bi fòr àdòníng, Yesu bib ku n rag, ");
INSERT INTO jib_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wù ri zìm ń sa ya wù í kai rà?” Afau-à níng dang rag, “Shinn Luyí, mì ri zìm á sa mì ń myàng kàng ma zumí.” ");
INSERT INTO jib_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu dinya ku rag, “A myàng kàng ma zuwú, pìkyinnwú à bir sig á byarmí ni níng, dàb gbam rìghing wù.” ");
INSERT INTO jib_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A byar-à níng hi ni, ku í gbam rìg-à, mi ri myàng rag. Ku í kan bàg-à Yesu, mi ri swam yan Shìdun. Barà big myàng àdòníng, sái mpìrká bidìm pár swam yan Shìdun tìnn. ");
INSERT INTO jib_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu bi fòr á finn swann Yariko, mi ri wam zu. ");
INSERT INTO jib_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mpìr zyun màhàn big ri bar ku Zaka, ku í àgbam mpìr azìg bài jànnká. Ku í mpìr alir ji mpìrká. Ku í mpìr bài. ");
INSERT INTO jib_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ku yàn gbìb-à aku myàng Yesu barà wàníng shi sig áni, ama ku í mpìr àkìm. Ku myàng sar fig Yesu áyau bìr mpìr káníng ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","I byar-à, ku shàr yag mà pyànn, n yag nann bin ating zyun aku myàng byann Yesu, jir kai bàna í gbìb-à wàníng ri bi áni. ");
INSERT INTO jib_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Barà Yesu bi fòr á byar-à hi ni, ku myàng nai yag n rag, “Zaka, á tìg wann bi kíni kíni. Janá-à níng má tìg mà luwú ni.” ");
INSERT INTO jib_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I byar-à hi, Zaka tìg wann bi n shà Yesu ma pìkyinn-à mìmìg. ");
INSERT INTO jib_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Barà bìr mpìr káníng myàng àdòníng, big zìnn swau Yesu, n rag, “Ku yag kà sig kyìnnwá mà lu mpìr asa bu pyìr.” ");
INSERT INTO jib_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaka sar dù nann zu n dinya Yesu rag, “A myàng, Shinn Luyí, má gàbfinn buká ǹ shi sig ma kàhi, kyau pyànà. Má ya mpìr ashiká kyau zyun. Mpìr-à ma lir ji sig ku bidìm pár, má wa kàng ku kàun yina yina.” ");
INSERT INTO jib_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu dang rag, “Janá-à níng ǹ zìg zu rìghing mpìr-à níng ma mpìrká á luwá ni á bu pyìrbá ni, jir kai bàna ku í wùn Ibrahim tìnn. ");
INSERT INTO jib_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mì Wùn Mpìr Jíkwìnn, ǹ bi sig ń yàn kyann mpìrká nang jànn sig, jirà ń zìg zu big.” ");
INSERT INTO jib_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ku nyàan fòr yag mà Urushalima. Barà mpìrká ri fig jírwá, big dang rag, tàma-à níng kwá na kùr. I byar-à ku sa ya káníng misali, ");
INSERT INTO jib_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","n rag, “Mpìr àgbam zyun yag sig mà jànn zyun ni pyunn nunonn nímá, jirà aku yàn ya shinnwá kùr, ma aku kàng bi. ");
INSERT INTO jib_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sai-à ku yag fig ma bàna níng, ku bar kwonn fàuwá big dwib. N ya káníng pam zyun zyun zyun. Ku rag, a káníng sa swàm ma kàhi sái kwa kàng bi hing. ");
INSERT INTO jib_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mpìrká buwá big rag, big ngàng ku. Big swam yag mpìr á simwá ni n dang rag, big ngàng. Big zìm fig aku shi kùrbá bàna. ");
INSERT INTO jib_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ku dìg kùrwá, n kàng bi á jànnwá ni. N bar fàuwá big ká ku ya sig bài-à níng, n bib káníng big dìg swàb kà sig bài-à píná rà? ");
INSERT INTO jib_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wà jijag-à níng bi á pyànnwá ni, n dinya ku rag, ‘Asàin Luyí, pam zyunwú níng gbar bi hing pam dwib.’ ");
INSERT INTO jib_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I byar-à àsàin lu-à dang rag, ‘Sàn hing. Wù í fàu-à ǹsàn. To, barà à sa hing bu ǹsàn ma bu-à títi níng, á na kùr finn swann dwib.’ ");
INSERT INTO jib_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","I byar-à wà wa pyànà bi, n dang rag, ‘Shinn Luyí, pam zyunwú níng gbar bi hing pam swana.’ ");
INSERT INTO jib_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Asàin lu-à dang rag, ‘Wù má á na kùr finn swann swana.’ ");
INSERT INTO jib_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Fàu zyun bi buwá n rag, ‘Shinn Luyí, pam zyunwú shi níng. N zìg níng ǹ dìnn gbam sig á jà, n sìnn gbam sig. ");
INSERT INTO jib_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bu-à sa níng, mì ri shàr zinnwú. Wù í mpìr pìkyinn. Wù í mpìr-à ri zìm á dìg átai. Wù ri zìg bu-à í wù à tàg fíg nì bàna.’ ");
INSERT INTO jib_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Shinn lubá dinya ku rag, ‘Wù í fàu bibai. Má pànn wù ma jírká à dang sig ma nuwú níng. A yì hing mì í mpìr-à ri zìm bu átai. A yì hing mì í mpìr-à ri zìg bu-à ǹ tàg fíg nì bàna. ");
INSERT INTO jib_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Barà à yì hing àdòníng, bu-à sa à sìnn kà fig bàimí á byar-à ma kàng bi hing, má dìg bu swàb kà hing á shinn-à ni bàna, í jir kai rà?’ ");
INSERT INTO jib_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ku dinya mpìrká sar sig màhàn níng, ku rag abig zìg rìg pam zyun-à á vù wàníng ni níng, abig ya mpìr-à shi sig ma pam dwib níng. ");
INSERT INTO jib_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Big dinya ku rag, ‘Shinn Luyí, ái wunù-à níng hi shi sig ma pam dwib.’ ");
INSERT INTO jib_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Asàin lubá dinya big n rag, ‘Mì ri dinya ning, mpìr-à ma shi sig ma bu, í mpìr-à bá swàb kà ya ku. Ama mpìr-à ma bàna ma bu, títi zyun-à ku shi sig ma kàhi níng, bá zìg rìg á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mpìr azíbmí big, ká dang rag, big zìm fig ń shi kùrbá bàna níng, aning zìg bi big, aning gib gban rìg big á pyànnmí ni.’ ” ");
INSERT INTO jib_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Barà Yesu dang vinn rìg jírwá àdòníng, ku pànn gbìbwá mi ri yag mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ku fòr yag á Baitafaji ma Baitanya á byar zyun big ri bar Wùn Mwir Zaitun. Ku swam yag yann sukàwá big pyànà, ");
INSERT INTO jib_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","n dang rag, “Aning yag mà kauye mà pyànn bó, na kà hing màhàn ná dìg big sa gbam sig wùn aswannswánn, zyun-à big nann màg fig fig bàna, aning fìnn ya bi mì. ");
INSERT INTO jib_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mpìr-à ma bib hing ning, ma dang rag, ‘Bu-à sa ning ri fìnn í jir kai rà?’ aning dinya ku rag, ‘Shinn Luyí ri zìm íni.’ ” ");
INSERT INTO jib_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mpìrká ku swam yag sig níng, yag dìg aswannswánn-à àràg barà ku dinya sig big. ");
INSERT INTO jib_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Barà big ri fìnn aswannswánn-à àdòníng, àsàinká bib big n dang rag, “Bu-à sa ning ri fìnn wùn aswannswánn-à níng í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Big dang rag, “Shinn Luyí ri zìm íni.” ");
INSERT INTO jib_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I byar-à hi big zìg bi á byar Yesu ni. N bir wann jàbá á kwíb-à ni. Big sìnn dù nann zu Yesu áni. ");
INSERT INTO jib_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Barà ku shi sig áyau kyonnwá ni, mpìrká káhi zìg bi jàbá, mi ri jag á gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Barà ku ri tìg wann bi mà Wùn Mwir Zaitun, sái bìr sukàká buwá big fig àjwár. Big ri bar mi ri swam yan zìnn Shìdun ma nài yán ngbam nímá, á jir bu mamaki-à big myàng sig níng. ");
INSERT INTO jib_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Big dang rag, “Pyib sìsàn aku shi á shinn kùryí, zyun-à ri bi á zìnn Shinn Luyí ni níng. Shìdun-à mà wai sàn hing, ayi swam yan ku.” ");
INSERT INTO jib_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mpìr Farisawaká áyau bìr-à ni dinya Yesu rag, “Malam, á dinya yann sukàwú big abig pànn shi rìg.” ");
INSERT INTO jib_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu rag, “N dinya ning, kó yann sukàmí big ma pànn shi rìghing, abànká má swam yan mì.” ");
INSERT INTO jib_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ku nyàan fòr bi á Urushalima, n myàng yag finn swann-à, n kig. ");
INSERT INTO jib_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ku rag, “Ning mpìrká á Urushalima, pìkyinnmí ri bai ma ning. Ning yì fig mpìr-à má sa tag wann ning pìkyinn ná bàna. Tàma-à níng, ning yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ayúnn zyun má bi, mpìr azíbná big má sar kàng kwìb ning. Bá du ning shwìn. ");
INSERT INTO jib_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bá fam wann ning á jìnn ni, bá gban rìg ning bidìm pár. Bá mìb gbànn vinn rìg tonnká á Urushalima bidìm pár. Bá fim fig abàn ńzyun á shinn jàuwá ni bàna. Bu-à sa má sa àdòníng, ning ngàng rìghing mpìr-à Shìdun swam bi sig.” ");
INSERT INTO jib_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu kà yag mà lu Shìdun. Ku ri kan zu mpìrká ri wann tafinn bu màhàn. ");
INSERT INTO jib_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ku rag, “Big ba sìnn sig jír-à Shìdun dang sig rag, ‘Lumí, mpìrká ma bar rag í byar-à big ri vig Shìdun,’ ama ning sìnn kàng rìghing í byar ajwú jwi.” ");
INSERT INTO jib_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kó ákaun ku ri yag, mi ri tàg mpìrká bu mà lu Shìdun ni màhàn. Ama àgbamká ká ri twìb swànn bu á pyànn Shìdun ni, ma malamká ma àgbamká áyau mpìrká ni, big ri zìm abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Big yì fig rag bu-à bá sa bàna, jir kai bàna mpìrká zìm hing jírwá wàni. ");
INSERT INTO jib_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Su zyun Yesu shi sig mà lu Shìdun ni, mi ri tàg mpìrká, mi ri dinya mpìrká jir Shìdun, mi ri dinya big tai àjwár. I byar-à àgbamká ri twìb swànn bu á pyànn Shìdun, ma malamká ma shun-à àgbamká, big bi á byarwá ni, ");
INSERT INTO jib_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","n bib ku rag, “Gbam-à wù ri sa bu káníng ma kàhi níng, à dìg sig áni rà? Mpìr-à ya sig wù gbam-à hi í nì rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","I byar-à Yesu dang rag, “Má bib ning jír zyun tìnn. Aning dinya mì ḿpyim. ");
INSERT INTO jib_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mpìr-à ya sig Yohanna gbam-à aku wau mpìrká dìr batisma í ni rà? I Shìdun rà, kó í mpìr rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","I byar-à big kyab bu-à bá dang á shinn jír káníng ni. Big dang jír ma bar dìrbá, n dang rag, “Wà ya dang rag í Shìdun ya sig Yohanna gbam-à íni, kwá dang rag, bu-à sa yi bir fig pìkyinn á jir Yohanna ni bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Big bib bar dìrbá n dang rag, “Wà ya dang rag, í mpìr ya síg Yohanna gbamwá í nì, mpìr káníng má ta gban yi ma abàn. Big yì rìghing wà Yohanna í wùn aswam Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","I byar-à big dinya Yesu n dang rag, big yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","I wà Yesu dinya big n rag, “To, mì má, má dinya fig ning mpìr-à ya sig mì gbam-à mì ri sa bu káníng ma kàhi níng bàna.” ");
INSERT INTO jib_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","I byar-à Yesu dinya mpìrká tinn jír n rag, “Mpìr zyun nàm sig da inabi, n zìg n pag mpìrká alaru. Ku dù n yag rìg kyìnn mà swann zyun ni, n yag shi nonn màhàn. ");
INSERT INTO jib_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","I byar-à awan inabi-à níng byann, ku swam yag fàuwá zyun mà byar anàm bu káníng abig ya ku anìwá. Anàm bu káníng dab fàuwá níng dab dab n kan kàng yag rìg ku vù áyonn. ");
INSERT INTO jib_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I byar-à ku swam yag jakàng fàuwá zyun. Big dab wàníng dab dab, n sa wàníng buká sàn fig bàna, n kan kàng yag rìg wàníng vù áyonn tìnn. ");
INSERT INTO jib_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I byar-à ku swam yag jakàng fàuwá zyun wà wa sara mà byar anàm bu káníng ni. Big dab pòr ku dìrwá wàni, n kan kàng yag rìg kù. ");
INSERT INTO jib_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sái àsàin da-à níng dang rag, kwá sa í kai tàma-à níng rà? Kwá swam yag wùnwá zyun-à ku ri zìm wàni, kó anàm bu káníng má wib wàníng. ");
INSERT INTO jib_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Barà anàm bu káníng myàng wùn-à níng àdòníng big dang rag, ‘A myàng, wùn-à níng, í wùn-à má ji gado da-à níng. Bu-à yá sa bàna ayi dab gban rìg ku, jirà ayi pànn nì da-à níng.’ ");
INSERT INTO jib_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","I byar-à anàm bu káníng vinn ta zu yag rìg wùn-à níng mà myann, n gban rìg ku màhàn. “To, bigná á myàngná ni, bu-à àsàin da-à níng má sa, kwá sa rág kai rà? ");
INSERT INTO jib_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ayúnn-à àsàin da-à níng ma bi hing kwá gban vinn rìg anàm bu káníng bidìm pár. Kwá zìg rìg da-à má ya rìg anàm buká káhi kim, abig nàm.” Barà mpìrká fig tai-à níng big dang rag, “A Shìdun kan dim.” ");
INSERT INTO jib_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","I byar-à Yesu myàng big, n dang rag, “Aning fig tinn jír-à níng, yìrwá í kai rà? ‘Abàn mpìr ami buká ngàng sig rag bai níng, big zìg kàng bi n mi kà sig ágù kinn-à ni, í wà zyun-à sàn kab sig kádà.’ ");
INSERT INTO jib_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mpìr-à ma kù hing á shinn abàn-à níng ni, kwá kìm. Ama mpìr-à abàn níng ma kù hing á dìrwá ni, má wau nam rìg ku murr.” ");
INSERT INTO jib_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Barà malamká ma àgbamká ri twìb swànn bu á pyànn Shìdun fig jír-à níng àdòníng big yì rìghing Yesu ri dang jír-à níng ma big. Big ri zìm abig pànn ku á sai-à níng hi. Ama big ri shàr bìr mpìrká. ");
INSERT INTO jib_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Big yàn pyù-à abig pànn Yesu. I byar-à big swam yag mpìrká mà byar Yesu ni, abig sa àràg big í mpìr-à ǹsàn big. Big ri zìm abig wonn pànn Yesu ma jír jirà abig zìg yag ku mà pyànn gwamna. ");
INSERT INTO jib_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Big bib ku n dang rag, “Malam, ái yi yì hing jírwú ma bu tàgwú shi sig ma gwangga wàni, jir kai bàna à sìnn sig kó ni í bu ńzyun. Zyun kab fig zyun bàna. Wù ri tàg jir gbìb Shìdun wàni, bu tàgwú í àjai. ");
INSERT INTO jib_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sàn hing wà ayi wa Kaisar bài jànn rà, kó sàn fig bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ku bó ku yì rìghing bu-à big ri kyab á pìkyinnbá ni. Ku dinya big n rag, ");
INSERT INTO jib_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Aning zìg bi bài àsháu zyun, ń myàng.” Big zìg bi, ku myàng, n bib káníng rag, “Ma hoto mpìr-à á dìr bài-à ni ma zìnn-à áni níng, í bu ni rà?” Big dang rag, “I bu kùr Kaisar.” ");
INSERT INTO jib_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","I wà Yesu dang rag, “To. Bu-à má bu kùr Kaisar, aning ya kàng kùr Kaisar. Ama bu-à má bu Shìdun, aning ya kàng Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Big sa sar fig barà bá pànn ku ma jír-à níng áyau bìr mpìrká ni bàna. Sái mamaki pànn rìg big, big dang fig rag jír bàna. ");
INSERT INTO jib_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mpìr Sadukiyawaká dang rag, mpìr ma wu hing, ri dù nann zu kàng fig ma yonki bàna. Sái big bi á byar Yesu ni. ");
INSERT INTO jib_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Big bib ku n rag, “Malam, Musa ba ya sig yi doka káníng, n rag, ‘Mpìr ma zìg uwà ma mà fig wùn bàna, wà kwa wu rìghing, a wunzàwá zìg kàng uwà-à níng hi, jirà aku mà ya shunwàuwá yann.’ ");
INSERT INTO jib_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mpìr zyun shi sig ma wunzàwá big sùnnjin. Ku zìg uwà, ku ma wàníng mà fig wùn bàna, ku wu rìg. ");
INSERT INTO jib_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wunzàwá zyun-à tib ku níng zìg uwà-à hi, big mà fig wùn bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hár wà wa sara má àdòníng, big sùmpyànn bidìm pár big zìg yà zu rìg uwà-à níng, big mà fig wùn bàna. ");
INSERT INTO jib_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Uwà-à níng bi n wu rìg tìnn. ");
INSERT INTO jib_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mpìr sùmpyànn káníng bidìm pár, zìg yà zu rìghing uwà-à níng. To, àyúnn-à Shìdun ma gbar dù nann zu kàng hing mpìrká ma yonki, uwà-à hi má shi í bu ni áyaubá ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","I byar-à Yesu dinya big n rag, “Mpìrká tàma-à níng big ri sìr ban, mi ri zìg uwà. ");
INSERT INTO jib_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mpìrká Shìdun má gbar dù nann zu kàng á ki níng, bá shi ma yonkibá kinn kinn, bá zìg fig uwà màhàn bàna, bá sìr fig ban bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ayúnn-à hi yonki mpìrká má shi àràg bu yann aswam Shìdun mà wai, bá wu fig ki bàna, jir kai bàna big í yann Shìdun, Shìdun gbar dù nann zu kàng rìghing big ma yonki. ");
INSERT INTO jib_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa dinya sig yi jír á shinn barà mpìrká ma wu hing, bá dù nann zu kàng ma yonki. A finn tarkada Shìdun ni, Musa ba sig jír á shinn akyar bín-à pyìr swànn áni. Ku dang rag, ‘Shìdun í Shìdun bu Ibrahim, í Shìdun bu Ishaku, í Shìdun bu Yakubu tìnn.’ ");
INSERT INTO jib_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jír-à níng ri tàg yi rag, mpìrká rì wu sig níng, shi sig ma yonki tàma-à níng. Shìdunyí í Shìdun ki bàna. Ama í Shìdun mpìr-à ma yonki.” ");
INSERT INTO jib_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Malamká káhi dinya Yesu rag, “Malam, jír-à à dang sig níng, í jír àjai.” ");
INSERT INTO jib_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tun daka á sai-à níng hi big ri shàr zinn wà bá bib ku jír. ");
INSERT INTO jib_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu dinya big n rag, “Má bib ning jír tìnn. Sáshinn big dang rag, ‘Kristi í wùn Dawuda rà?’ ");
INSERT INTO jib_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawuda ma shinnwá ku dang rag, Kristi í Shinn Luwá. A tarkada Shìdun ni zyun-à big ri bar rag í Zabura, Dawuda dang rag, ‘Shìdun dinya Shinn Lumí n rag, á bi á shi á vìm numí ni áyág. ");
INSERT INTO jib_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Má sìnn kà mpìr azíbwú big á mìr barwú ni.’ ");
INSERT INTO jib_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda ma shinnwá bar ku Shinn Lumí. To, sáshinn kwá shi wùn wàníng rà?” ");
INSERT INTO jib_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu dinya yann sukàwá big jír á pyànn mpìrká ni bidìm pár, ");
INSERT INTO jib_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","n dang rag “Aning pànn shinn ná ma malamká, big ri zìm jà lilor wìr, big ri zìm mpìrká abig bib kà kyann big á fir ati-à ni. Big ri shig bushu ǹsàn mà tonn bìr kwonn-à ni, big ri zìm bushu ǹsàn á byar-à big ri sa bùkí. ");
INSERT INTO jib_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Big ri lir ji uwà kiká. Big ri vig Shìdun ninonn nímá jirà a mpìrká myàng big. Shwìn-à bá wa má kab gbam.” ");
INSERT INTO jib_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu myàng yag zuwá, ku myàng mpìr bàiká ri ta kà ya Shìdun bài ashìkáun-à ni á lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ku myàng uwà ki zyun, wàníng í mpìr ashi, wàníng bi ta kà bàiwá naira pyànà. ");
INSERT INTO jib_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu dang rag, “Mì ri dinya ning àjai, bu-à uwà ki ashi-à níng ta kà sig níng, kab hing bu mpìrká bidìm. ");
INSERT INTO jib_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mpìr káníng tinn zu sig áyau bàibá big shi sig ma kàhi, n ya sig Shìdun, ama uwà ki-à níng, kó barà ku í mpìr ashi níng, ku ya vinn rìg Shìdun bu-à ku shi sig ma kàhi.” ");
INSERT INTO jib_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yann sukàká káhi ri dang jír á shinn barà big mi sig lu Shìdun ma abàn ǹsàn ǹsàn nímá, ma barà mpìrká ri ya Shìdun buká jirà lu Shìdun aku sàn. Ama Yesu dang rag, ");
INSERT INTO jib_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Barà ning ri myàng bu káníng, àyúnn zyun ri bi bá dab gbànn rìg lu-à hi, kó abàn ńzyun má shi fig á shinn jàuwá zyun ni bàna.” ");
INSERT INTO jib_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Big bib ku n rag, “Malam, bu káníng má sa ákaun rà? Bu-à yá myàng ḿpyim, jirà ayi yì àyúnn-à hi nyàan fòr í kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ku dinya big n rag, “Aning pànn shinn ná, kada aning zìm a mpìr zyun tonn gban ning bàna, jir kai bàna mpìrká nìnànn nímá má bi, má rag big bi sig á zìnnmí ni, bá dinya ning rag big í Almasihu. Kó ba dang rag sai-à níng hi nyàan sa, kada aning zìm jírbá bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wà na fig tai kànn ma barà mpìrká ri gban ki àjirà abig na kùr, kada aning gib kyinn bàna. Bu káníng má sa àdòníng, ama sai-à dunyaru má vinn áni níng màg fig ma bàna.” ");
INSERT INTO jib_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ku dinya big n rag, “Jànn zyun má nu kànn ma jànn zyun. Kùr zyun má nu kànn ma kùr zyun kó áni bidìm pár á jànn-à ni. ");
INSERT INTO jib_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jànn-à á jìnn ni má ning wàni, amor má kà á jànn-à ni wàni, mpìrká má na dor ùwài nímá, buká má ya mpìr zinn má sa mà waisháu-à ni. ");
INSERT INTO jib_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama àyúnn-à bu káníng ma nyàan sa, bá pànn ning, má ya ning shwìn á tonn bìr kwonn, má zìg yag ning á pyànn kùr ma gwamna, bá kìg dim ning á tonn fi á dò jir zìnnmí ni. ");
INSERT INTO jib_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Byar-à na yag áni bidìm pár, aning dinya mpìrká jírmí. ");
INSERT INTO jib_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aning sar ma pìkyinn ńzyun, kada aning gib kyinn barà ná zìg zu shinn ná áni bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Má ya ning yar barà ná dang jír, barà azíbná má dìg fig ning, hár má ngang sar fig ning bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hár taná ma nàná ma yiwainá ma jàuká buná, ma mpìrká buná bá ya kà ning á vù mpìr azíbná ni. Ayauná ni bá gban rìg káhi. ");
INSERT INTO jib_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mpìrká bidìm pár má zib ning á jir shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama wai jinn ná kó ńzyun má jànn fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wà na sar gbam hing ma pìkyinn ńzyun ná dìg yonki. ");
INSERT INTO jib_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wà na myàng sojaká ma sar kàng kwìb rìghing finn swann Urushalima, aning yì rag wà bá pànn finn swann-à hi nyàan sa. ");
INSERT INTO jib_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A byar-à níng hi, ká ma shi sig mà yau jànn Yahudiya, abig shàr yag mà shinnkwìnnká ni. Ká ma shi sig mà yau finn swann-à ni, abig zu bi á myann. Ká ma shi sig mà kauye, kada abig kà á finn swann-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wàníng í àyúnn-à Shìdun má wà kwonnwá. Buká big ba sig á tarkada Shìdun, má sa àdòníng. ");
INSERT INTO jib_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ayúnn-à hi uwàká shi sig ma finn, ma ká shi sig ma yann àjann níng, bá wa shwìn. Mpìrká á jànn-à ni má wa shwìn nìnànn nímá, jir kai bàna í àyúnn-à Shìdun má wà kwonnwá áni. ");
INSERT INTO jib_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bá wa gban mpìrká káhi ma kafai. Bá zìg yag mpìrká káhi mà byar shwìn, ma jànnká káhi kim kim. Mpìrká zyun-à yì fig Shìdun bàna níng má na kùr Urushalima hár sai àyúnn-à Shìdun ma dang rag, màg hing. ");
INSERT INTO jib_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ayúnn-à hi, àyúnn ma sònn ma asuswirká má vim bìr rìg. Mpìrká á jànn-à á jìnn ni má wa shwìn wàni. Hár níngká ma zàpìr ùwàiká má ning dìrbá. Mpìrká má shàr zinn wàni, bá yì fig bu-à sa sig bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mpìrká má shàr zinn, hár awunbá má kìnn, bá kyab buká kim kim bu-à má sa á dunyaru. Buká shi sig ma gbam mà waisháu-à ni má ning dìrbá. ");
INSERT INTO jib_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","I byar-à bá myàng Wùn Mpìr Jíkwìnn má wann bi mà wai áyau akworká ni, kwá mìg karr àràg asuswir, kwá bi ma gbam íko Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wà na myàng bu káníng ma sa hing, aning shàr zinn bàna, aning fig àjwár, aning myàng yag zuná mà wai, jir kai bàna àyúnn-à Shìdun má fìnn zu ning nyàan bi fòr.” ");
INSERT INTO jib_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I byar-à Yesu dinya big tinn jír zyun, n rag, “Aning myàng misali á shinn bin ating káníng, ma bínká kim kim. ");
INSERT INTO jib_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wà na myàng jì bín káníng ma ri twìb jì àpyú, ning yì hing shyù nyàan kù. ");
INSERT INTO jib_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","To, ning má, sai-à na myàng bu káníng ma ri sa àdòníng, aning yì rag àyúnn-à Shìdun má na kùrwá nyàan fòr. ");
INSERT INTO jib_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“N dinya ning, mpìrká tàma-à níng má wu vinn fig bidìm pár bàna, sái bu káníng ma sa rìghing ḿpyim. ");
INSERT INTO jib_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Waisháu ma jànn-à á jìnn ni má bab jànn rìg, ama jírmí má vinn fig á vinn bàna. ");
INSERT INTO jib_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Aning pànn shinn ná fa, kada aning sìnn kàng shinn ná àràg mpìrká ri kyab jír shin á pìkyinnbá ni bàna, jirà kada aning kàng mpìr awa pyann shin big bàna. Kada aning kyab buká á dunyaru bàna. Na kyab hing bu káníng, àyúnn-à Shìdun ma bi hing, àyúnn-à níng hi má pànn ning àràg barà jùr ri pànn wi. ");
INSERT INTO jib_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bu káníng má sa vinn rìg kó ni á dunyaru bidìm pár, àràg í bu mamaki. ");
INSERT INTO jib_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aning shi àzír kó ákaun, aning vig Shìdun jirà aning dìg gbam, jirà aning zu áyau shwìn buká má bi níng, jirà aning dìg pyù-à ná sar á pyànn Wùn Mpìr Jíkwìnn.” ");
INSERT INTO jib_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kó ákaun Yesu ri shi mà lu Shìdun ni, mi ri tàg mpìrká bu. Ama fi ma sìr hing, ku ri zu yag, mi ri na mà wùn mwír zyun ni, big ri bar Wùn Mwir Zaitun. ");
INSERT INTO jib_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ama í pyimbyau yìyì nímá mpìrká ri shi kir ku mà lu Shìdun ni, jirà abig fig jírká kwá dang. ");
INSERT INTO jib_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ayúnn-à ùwài-à bá ji buju-à bàna ma yisti nyàan fòr. Ayúnn ùwài-à níng zìnnwá í Pìm Wam Zu. ");
INSERT INTO jib_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","I byar-à àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng ma malamká big ri zìm abig yàn gbìb-à bá bònn gban rìg Yesu, kada mpìrká abig yì bàna, jir kai bàna big ri shàr zinn mpìrká. ");
INSERT INTO jib_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","I byar-à Shaitan du kà Yahuda, wà zyun-à big ri bar rag í Iskariyoti, í wùn sukà zyun áyau yann sukà dwib agban pyànà, a wàníng sa bu-à bibai. ");
INSERT INTO jib_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I byar-à Yahuda yag, n yag dang jír ma àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma malamká ma sojaká ri myàng kwonn ma lu Shìdun tìnn, jirà aku ya tafinn big Yesu. ");
INSERT INTO jib_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I byar-à hi big fig àjwár, n dinya ku rag bá ya ku bài. ");
INSERT INTO jib_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sái Yahuda í zìm-à, n yàn pyù barà kwá sa, má ya kà Yesu á vù mpìr káníng ni, jirà kada bìr mpìrká abig yì bàna. ");
INSERT INTO jib_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ayúnn-à bá ji brodi-à bàna ma yisti níng fòr, í àyúnn-à bá gib gban wùn àdùn-à áni. Zìnn àyúnn ùwài-à níng hi, big ri bar í àyúnn Pìm Wam Zu. ");
INSERT INTO jib_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sái Yesu swam yag Bitrus ma Yohanna a káníng yag abig sa samyib buju-à bàna ma yisti níng, jirà aku ma káníng ji. ");
INSERT INTO jib_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Big bib ku n rag, “Wù ri zìm ayi sa buju-à níng áni rà?” ");
INSERT INTO jib_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ku dinya big n rag, “Sai-à na kà hing finn swann-à, ná dìg kwonn ma wunù zyun swann sig àgur zàpìr. Aning bàg ku hár mà lu-à kwá kà. ");
INSERT INTO jib_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aning dinya àsàin lu-à hi rag, ‘Malam dang rag, tonn byar-à ku ma yann sukàwá big má shi má ji buju àyúnn Pìm Wam Zu-à níng, shi sig áni rà?’ ");
INSERT INTO jib_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kwá tìya ning tonn zyun ùwài nímá mà wai, wà big sìnn sig kó kai mà ni. Aning sa sìnn buju àyúnn Pìm Wam Zu-à níng màhàn.” ");
INSERT INTO jib_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Big yag n dìg bu káníng àràg barà Yesu dinya sig big, í byar-à big sa buju àyúnn Pìm Wam Zu-à níng màhàn. ");
INSERT INTO jib_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Barà big sa kinn buju-à í sa kinn níng, sái Yesu ma yann sukàwá big shi wann á bìr-à ni, jirà abig ji buju-à. ");
INSERT INTO jib_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu dinya big n rag, “Tún daka á ninonn mì ri zìm ń ji buju-à níng ma ning ḿpyim, í wà ń wa shwìn-à níng í ni. ");
INSERT INTO jib_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mì ri dinya ning, yi ma ning má ji fig rag buju-à níng á bìr-à ni bàna, sái àyúnn-à Shìdun ma na hing kùrwá.” ");
INSERT INTO jib_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","I byar-à Yesu zìg wùn kwài, n swam yan Shìdun, n dinya big n rag, “Aning zìg, aning wa yà zu vinn rìg shinn ná. ");
INSERT INTO jib_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mì ri dinya ning, tun daka janá-à níng má wa fig rag zàn inabi bàna, sái àyúnn-à Shìdun ma na hing kùrwá.” ");
INSERT INTO jib_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","I byar-à ku zìg brodi, n swam yan Shìdun n ngir gàfinn n ya big, n dinya big rag, “Brodi-à níng í wi dìrmí. Wi dìrmí í bu-à ǹ ya sig ning. Na ji hing brodi-à níng, aning kyab pànn mì áni.” ");
INSERT INTO jib_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Barà big ji vinn buju-à í ji vinn rìg níng, Yesu zìg wùn kwài n rag, “Zàn-à níng shi sig àràg í àsàmí zyun-à má kìfinn dò jir shinn ná, àràg barà Shìdun rì gib sig nu ma mpìrká buwá níng. ");
INSERT INTO jib_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ama mpìr-à má zìg mì, má ya mpìrká má gban mì níng, yi ma ku ri ji buju í kwài ńzyun. ");
INSERT INTO jib_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mì Wùn Mpìr Jíkwìnn, má wu àràg barà big ba sìnn sig á jir Shìdun ni á shinnmí ni rag má wu níng. Ama mpìr-à má wann tafinn mì níng, kwá wa shwìn wàni.” ");
INSERT INTO jib_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","I byar-à big bib bar dìrbá n rag, “Mpìr-à má sa bu-à níng í ni rà?” ");
INSERT INTO jib_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","I byar-à yann sukà Yesu big sa yipyàr n dang jír ma gbam n rag, áyaubá ni, àgbam-à má shi í ni rà? ");
INSERT INTO jib_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu yan ta big n dang rag, “Kùrká á jànn-à ni big ri tàg gbam á shinn mpìrká ni wàni, mi ri gbar dù shinn. ");
INSERT INTO jib_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Buná, kada aning sa àdòníng bàna. Mpìr-à àgbam-à áyauná ni, aku shi mpìr-à títi, aku shi mpìr-à má gàfinn ya ning buju-à ná ji. ");
INSERT INTO jib_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mpìr-à ma shi sig á jìnn ni jàuwá ma ri ya bi ku buju, áyaubá big pyànà níng àgbam-à í ni rà? Agbam-à shí nì zyun-à shi sig á jìnn ni big ri ya bi ku buju-à níng. Ama bigmí ǹ shi sig áyauná ni àràg fàu-à ri zìg bi ya ning buju. ");
INSERT INTO jib_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yi ma ning shi sig zyun, ning myàng hing shwìnká ǹ wa sig. ");
INSERT INTO jib_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Barà Tamí wìr sig mì kùr níng, mì má, má wìr ning kùr tìnn. ");
INSERT INTO jib_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ná ji má wa ma mì, sai-à ma na hing kùr. Ning í àsàinká má na kùr á shinn swai mpìr Israilaká dwib agban pyànà níng.” ");
INSERT INTO jib_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu dang rag, “Siman, Siman, Shaitan ri yàn gbìb-à kwá màg màg fig ning, àràg barà big ri vinn za. ");
INSERT INTO jib_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mì ri vig Shìdun á shinnwú ni. Pìkyinnwú à bir sig á dìr Shìdun níng, kada á gàb dìr ma kàhi bàna. Wa kàng bi hing á byarmí ni, á gbar bying kà yiwaiwú big kádà sig níng.” ");
INSERT INTO jib_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus dang rag, “Shinn Luyí, kó ba du kà wù tonn fi, mì má abig du kà mì tìnn. Ba gban hing wù, mì má abig gban mì tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu dang rag, “N dinya wù, Bitrus. Janá-à níng kwìnn ma dab fig ma aku bàna, wá ngàng mì má sa yipyàr kàun sara, wá rag à yì fig mì bàna.” ");
INSERT INTO jib_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu dang rag, “Wà ǹ swam yag ning, ning zìg fig bài bàna, lúr bàna, tabar bàna, bu zyun nì hing ning rà?” Big dang rag, “Bu bàna.” ");
INSERT INTO jib_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ku dinya big rag, “Ama tàma-à níng, mpìr-à ma shi sig ma bài, aku zìg. Mpìr-à ma shi sig ma lúr, aku zìg. Mpìr-à ma bàna ma kafai, aku wann tafinn jàwá aku wann. ");
INSERT INTO jib_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Big ba sig á shinnmí ni á tarkada Shìdun ni n rag, má wa shwìn ma mpìrká ri sa bu-à bibai. Mì ri dinya ning, bu-à níng má sa àjai. Bu-à big ba sig á shinnmí ni níng, nyàan fòr bi.” ");
INSERT INTO jib_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yann sukàwá big dang rag, “Shinn Luyí, kafai pyànà shi sig níng.” Yesu dang rag, “Màg rìghing.” ");
INSERT INTO jib_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","I byar-à Yesu dù n yag mà Wùn Mwir Zaitun àràg barà ku ri yag kyann. Yann sukàwá big bàg yag ku ásim. ");
INSERT INTO jib_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Barà ku yag fòr byar zyun àdòníng, ku dinya káníng n rag, abig vig Shìdun jirà kada bu zyun aku màg màg fig big bàna. ");
INSERT INTO jib_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ku dù dà fim rìg káníng mi í yag rìg-à á byar zyun ni, nonn sàn fig bàna. N yag bìnn kir wann n vig Shìdun màhàn. ");
INSERT INTO jib_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ku rag, “Tamí, wa zìm hing, á zìg zu rìg mì áyau shwìn-à má wa níng ni. Ama á bàg bu-à á kyinnmí ni bàna, sái bu-à kyinnwú ri zìm.” ");
INSERT INTO jib_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","I byar-à wùn aswam Shìdun zyun bi mà waisháu-à ni, n ya ku gbam. ");
INSERT INTO jib_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pìkyinn Yesu gib sa pár. Ku sar gbam n vig Shìdun wàni. Byafànwá shi rag í àsà ri tìg nì. ");
INSERT INTO jib_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Barà ku dù á byar-à ku vig sig Shìdun níng, ku kàng yag n yag dìg yann sukàwá big na jànn rìghing, jir kai bàna pìkyinnbá bai rìghing. ");
INSERT INTO jib_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ku dinya káníng n rag, “Bu-à sa ning ri na aná í jir kai rà? Aning dù nann, aning vig Shìdun, jirà kada bu-à bibai aku tonn gban ning bàna.” ");
INSERT INTO jib_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Barà Yesu ri dang jír àdòníng, sái bìr mpìrká bi fòr. Big ri bàg Yahuda ásim, í wùn sukà Yesu. Ku bi á pyànn Yesu ni, ku kàm pànn wàníng. ");
INSERT INTO jib_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama Yesu dang rag, “Yahuda, wù ri kàm pànn mì jirà á sa pyù-à abig pànn mì Wùn Mpìr Jíkwìnn rà?” ");
INSERT INTO jib_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Barà yann sukàwá big myàng bu-à káníng ri sa àdòníng, big dang rag, “Shinn Luyí, ayi gbar wàm zu kafaiyí ayi kyag rà?” ");
INSERT INTO jib_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I byar-à sukà Yesu zyun gbar wàm zu kafai-à, n kyag fàu àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ku kyag zu rìg wàníng sung vìm nu-à. ");
INSERT INTO jib_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","I byar-à Yesu dang rag, “Màg hing nímá.” Yesu tib vù á sung mpìr-à big kyag sig níng, mi í dàb gbam rìg-à wàníng. ");
INSERT INTO jib_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu dinya àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma sojaká ri myàng kwonn ma lu Shìdun, ma àgbamká bi sig níng bidìm pár n rag, “Ning bi sig ma kafai kwonn ma tun jirà aning pànn mì níng, mì í mpìr ajwú rà? ");
INSERT INTO jib_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yi ma ning ri shi kyann í zyun mà lu Shìdun ni á bìr-à ni. Ning sa fig mì bu zyun bàna. Ama tàma-à níng jirà swàm zufi bi rìghing í bu-à sa ning dìg sig pyù jirà aning pànn mì.” ");
INSERT INTO jib_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Big pànn Yesu, n zìg yag rìg ku mà lu àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. Bitrus ri bàg yag big ásim ásim, ama pyunnwá nonn hing. ");
INSERT INTO jib_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mpìr káníng tai swànn sig pyìr á finn lu-à ni. Big shi kàng kwìb sig áni, mi ri jwar. Bitrus bi shi kà áyaubá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Uwà sáb zyun ri sa swàm màhàn, ku myàng Bitrus shi sig á dìpyìr-à ni, ku myàng gbam sig wàníng kyarrr. Ku dang rag, “Mpìr-à níng í mpìr Yesu.” ");
INSERT INTO jib_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bitrus sa yipyàr n dinya uwà níng rag, ku yì fig Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nonn fig bàna mpìr zyun myàng yì rìg Bitrus n dang rag, “Wàníng í wùn sukà Yesu tìnn.” Bitrus dang rag, “Mì í mpìrwá bàna.” ");
INSERT INTO jib_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Shi nonn fig bàna, sái wunù zyun áyau bìr mpìrká ni, dang jír ma gbam n rag, “I bu yipyàr bàna. Mpìr-à níng í mpìr Yesu, jir kai bàna ku í mpìr á Galili.” ");
INSERT INTO jib_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","I byar-à Bitrus dang rag, “N yì fig bu-à wù ri dang bàna.” Barà ku dang vinn fig ma jír-à bàna, sái kwìnn dab aku. ");
INSERT INTO jib_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yesu myàng kàng bi Bitrus zu. A byar-à hi Bitrus í kyab pànn rìg-à jír-à Yesu dinya sig ku n rag, “Janá-à níng wá sa yipyàr má rag, à yì fig mì bàna kàun sara ḿpyim, í wà kwìnn má dab aku.” ");
INSERT INTO jib_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A byar-à hi Bitrus zu yag mà myann n kig mínn wàni. ");
INSERT INTO jib_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mpìrká ri shi myàng kwonn ma Yesu níng, big shi sig mi ri jwann ku hár mi ri dab ku gbàr. ");
INSERT INTO jib_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Big sìr dim ku jà á zu-à ni n dab ku, n bib ku rag, “A dinya yi mpìr-à dab sig wù níng.” ");
INSERT INTO jib_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Big swau Yesu shí kim kim. ");
INSERT INTO jib_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na kyàr byar-à í pyimbyau mpìr àgbamká ma àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma malamká kwonn í byar ńzyun n bar bi Yesu. ");
INSERT INTO jib_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Big bib ku n rag, “A dinya yi wù í Almasihu rà?” Yesu zìm n dinya big rag, “Ma dinya ning rag mì í Almasihu, ná zìm fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kó ma bib ning jír ná zìm fig bàna. ");
INSERT INTO jib_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama daka tàma-à níng, mì Wùn Mpìr Jíkwìnn má shi rág mà agunn vìm nu bu Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Big bib ku rag, “Wù í Wùn Shìdun rà?” Yesu zìm ǹ rag, “Nn, ning dang hing àjai, mì í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","A byar-à níng hi big rag, “Ku dang hing ma nùwá, bu-à sa yá yàn jakàng mpìr-à má dang jír á shinnwá ni, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I byar-à bìr mpìr káníng dù nann zu n zìg yag rìg Yesu mà pyànn gwamna, zyun-à zìnnwá í Bilatus, aku wà kwonn Yesu. ");
INSERT INTO jib_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sái big tìr ya ku jír áshinn bu káhi nìnànn nímá. N dang rag, “Yi dìg mpìr-à níng ri sa bai mpìrká buyí, ku rag kada abig wa ya kùr Kaisar bài jànn bàna. Ku dang rag ku í Kristi zyun-à Shìdun swam bi sig. Ku dang rag ku í kùr.” ");
INSERT INTO jib_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatus bib ku n rag, “Asái wù í kùr Yahudawaká rà?” Yesu zìm n dang rag, “Aràg barà à dang níng.” ");
INSERT INTO jib_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","I byar-à Bilatus dinya àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma bìr mpìrká, n dang rag ku myàng fig jír bibai-à bá pànn Yesu ma kàhi bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","I byar-à bìr mpìrká dang jír ma gbam n rag, mpìr-à níng ri gbar dù pìkyinn mpìrká, bu-à pànn sig daka á jànn Yahudiya hár á jànn Galili hár áyág. ");
INSERT INTO jib_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Barà Bilatus fig àdòníng, ku bib n rag, “Wàníng mpìr á Galili rà?” ");
INSERT INTO jib_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Barà Bilatus fig Yesu í mpìr-à á Galili á byar-à Hirudus na sig kùrwá níng, ku tìr yag wàníng mà byar Hirudus, jir kai bàna Hirudus shi sig á Urushalima á sai-à níng hi tìnn. ");
INSERT INTO jib_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Barà Hirudus myàng Yesu, ku fig àjwár wàni, jir kai bàna ku fig nonn hing tai Yesu, ku ri zìm aku myàng wàníng, a wàníng sa ya ku bu mamaki. ");
INSERT INTO jib_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ku bib wàníng jír nìnànn nímá. Ama Yesu pù fig nuwá bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","I byar-à àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ma malamká, big dù nann n dang jír á shinn Yesu ni nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudus ma sojawá big sa Yesu bu-à sàn fig bàna. Big wìr ku jà ǹsàn nímá àràg í kùr, mi ri màm jwann ku. I wà big tìr kàng yag ku mà byar Bilatus. ");
INSERT INTO jib_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ayúnn-à níng hi Hirudus ma Bilatus pànn rìg ayor, jir kai bàna sai-à rì níng big rì kyag fig dìr bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus bar kwonn àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma àgbamká káhi, ma bìr mpìrká. ");
INSERT INTO jib_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ku dang rag, “Ning tìr bi sig mpìr-à níng á byarmí ni, ning dang rag ku ri tàg sa bai mpìrká. N fig hing jírwá, ǹ fig hing jírná tìnn, ama ǹ myàng fig byar-à jírwá bai sig á jír-à ning zìg bi sig níng ni bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirudus pànn fig ku ma jír bu zyun bàna tìnn. I bu-à sa wàníng tìr kàng bi sig ku á byaryí ni. Barà ning fig níng, ku sa fig bu-à bibai-à má gban ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Má dab ku átai, má tafinn ku.”  ");
INSERT INTO jib_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sai-à àyúnn Pìm Wam Zu ma màg hing, Bilatus ri fìnn tafinn mpìr zyun áyau mpìrká big kìg sig á tonn fi, zyun-à bìr mpìrká ma ri zìm abig fìnn. ");
INSERT INTO jib_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","I byar-à bìr mpìrká wa nài yán, n dang rag abig gban rìg Yesu. Abig fìnn tafinn ya big Barabas. ");
INSERT INTO jib_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Big kìg kà sig Barabas á tonn fi, jir kai bàna ku sa big nu hing kànn ma finn swann-à ni, hár n gban hing ki. ");
INSERT INTO jib_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus dinya jakàng bìr mpìrká níng n rag, buwá ku ri zìm aku fìnn tafinn Yesu. ");
INSERT INTO jib_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sái big wa nài yán, n dang rag abig dab bàg gbam ku á tàm bín-à ni. Abig dab bàg gbam ku á tàm bín-à ni. ");
INSERT INTO jib_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ku dinya big hár kàun sara, n dang rag, “Bu bibai-à wunù-à níng sa sig í kai rà? Mì ri myàng ku sa fig bu-à fòr sig barà má gban ku bàna. Mì ri zìm ń dab ku, ń fim ku aku yag.” ");
INSERT INTO jib_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Big shi yan nài yán, n dang rag abig dab bàg gbam ku á tàm bín-à ni. I byar-à Bilatus zìm jírbá. ");
INSERT INTO jib_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ku gib jír-à àràg barà bìr mpìr káníng ri zìm. ");
INSERT INTO jib_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","I byar-à ku fìnn zu ya big Barabas, zyun-à sa big nu kànn, hár n gban ki níng. I byar-à ku zìg Yesu n ya big abig sa bu-à bá sa ma wàníng. ");
INSERT INTO jib_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Big zìg yag rìg Yesu. Barà big ri yag, big yag dìg kwonn ma mpìr zyun, zìnnwá Siman, mpìr-à á Kurane, ku ri kàng bi mà kauye. I byar-à big zìg atàm bín-à bá dab bàg gbam Yesu áni, n pyàg kà ku, n dang rag aku swann, aku bàg Yesu ásim. ");
INSERT INTO jib_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mpìrká nìnànn nímá bàg yag ku, ma uwàká big ri yag mà nàikitáu ma jonn ki. ");
INSERT INTO jib_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ama Yesu myàng kàng bi big n dang rag, “Uwàká á Urushalima, aning kig mì bàna, aning kig jir shinn ná, ma yanká buná. ");
INSERT INTO jib_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aning myàng, àyúnn zyun ri bi wà mpìrká má wa shwìn ùwài nímá. Mpìrká má dang rag sàn kab wà uwà aku shi shu gbág àràg uwàká mà fig wùn bàna níng jir shwìn-à má bi á pyànn níng. ");
INSERT INTO jib_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Asai-à níng hi, bá rag abànká abig kù wann bi á shinnbá ni, shinnkwìnn aku bir dim gban rìg big. ");
INSERT INTO jib_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iri bu-à àdòníng ma ri sa ma bín àtag, wà ma wim rìghing má sa rag á shinn rà?” ");
INSERT INTO jib_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Big zìg bi mpìr ajwú big pyànà jirà abig gban kwonn ma Yesu. ");
INSERT INTO jib_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Barà big fòr mà mwír wà big ri bar rag í Akib Shinn, á byar-à hi big dab bàg gbam ku á bín-à ni, ma mpìr ajwú káníng, zyun águnn vìm nuwá ni, zyun bó águnn vìm súrwá ni. ");
INSERT INTO jib_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu dang rag, “Tamí, á yafa ya big, jir kai bàna big yì fig bu-à big ri sa bàna.” Big zìg jàwá n sìnn kwonn í byar ńzyun, big dab shasha, kó ni dab ji buwá. ");
INSERT INTO jib_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mpìrká sar mi ri myàng ku, àgbamká ri màm jwann ku. Big rag, “Ku zìg zu yì hing mpìrká káhi, ama ku zìg zu yì fig shinnwá bàna. Wà ku ma í Almasihu bu Shìdun, zyun-à Shìdun shig sig níng aku zìg zu shinnwá.” ");
INSERT INTO jib_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojaká má, ri màm jwann ku tìnn. Big ri bi á byarwá ni, mi ri ya ku zàpìr àban. ");
INSERT INTO jib_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Big rag, “Wà wù má í kùr Yahudawaká, á zìg zu shinnwú.” ");
INSERT INTO jib_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Big ba sig bu á shinnwá ni, n rag, “Waning I Kur Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Zyun áyau mpìr ajwú káníng swau Yesu shí n rag, “Wù í Almasihu bàna rà? A zìg zu shinnwú ma yi tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama mpìr ajwú zyun-à níng yan ta jàuwá n rag, “A shàr fig Shìdun bàna rà? A myàng barà yi bidìm pár yi ri wa shwìn, yá wu rìg. ");
INSERT INTO jib_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Big ya sig yi shwìn á jir shinn bu-à bibaiká yi sa sig níng. Ama Yesu sa fig bu-à bibai bàna.” ");
INSERT INTO jib_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ku dinya Yesu n rag, “A kyab pànn mì á sai-à wá na kùrwú.” ");
INSERT INTO jib_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu dinya ku n rag, “Mi ri dinya wù àjai, janá-à níng yi ma wù má shi ńzyun á lu Shìdun.” ");
INSERT INTO jib_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Barà àyúnn fòr áyau shinn, fi í sìr dim gban rìg-à jànn-à bidìm pár, hár fòr àsháu sara wà àkamzau. ");
INSERT INTO jib_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ayúnn-à í sar rìg wá, n yar fig rag bàna. Jà-à big gag dim sig lu Shìdun áni níng, í ki gàfinn rìg-à byar pyànà. ");
INSERT INTO jib_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu bar nài abor ngbam nímá n rag, “Tamí, mì á vùwú ni, n ya sig yonkimí á byarwú ni.” Barà ku dang vinn rìg àdòníng, awunwá í zu rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Barà àgbam soja-à níng myàng bu-à sa sig níng, ku swam yan Shìdun n rag, “Wàníng í mpìr ǹsàn.” ");
INSERT INTO jib_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Barà bìr mpìrká kwonn sig màhàn jirà abig myàng buká sa sig níng, big myàng buká sa sig níng, big mìb vù á pìkyinnbá ni, mi í kàng yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mpìrká ká yì hing ku, ma uwàká zyun-à bàg bi sig ku mà Galili, big sar sig pyunn ninonn mi ri myàng bu káníng. ");
INSERT INTO jib_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mpìr zyun áni zìnnwá í Yusufu. Ayau mpìrká big bar kwonn sig níng, ku má, ku í mpìr àgbam tìnn. Ku í mpìr ǹsàn, ku í mpìr gwangga. ");
INSERT INTO jib_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ku í mpìr-à mà finn swann Arimatiya á jànn Yahudawa. Ku ri shi kir àyúnn-à Shìdun má na kùrwá. Ku zìm fig jír-à àgbamká dang rag abig gban Yesu níng bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mpìr-à níng yag mà byar Bilatus, ku vig wàníng a wàníng ya ku ki Yesu, jirà aku jì. ");
INSERT INTO jib_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ku zìg tìg wann wàníng mà bín-à ni n bing kà wàníng jà ki á dìr-à ni, n sìnn wàníng á shar ki zyun-à big kab sig á mìr abàn, á byar-à big jì fig mpìr màhàn bàna. ");
INSERT INTO jib_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ayúnn-à níng, í àyúnn-à kó ni ri sa swàm jirà aku shi ngàng àyúnn Asabar byar-à kyàr. ");
INSERT INTO jib_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Uwàká bi sig ma ku mà Galili níng, big bàg yag mpìrká ma amir-à ni, n myàng barà bá jì Yesu. ");
INSERT INTO jib_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Uwà káníng í kàng bi rìg-à á lu-à ni, n yag yàn kyann tulare ma byìr ǹsàn. Big shi ngàng àyúnn Asabar àràg barà doka dang sig. ");
INSERT INTO jib_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ayúnn Ladi í pyimbyau byar kyàr fig ma bàna, uwàká dù n yag mà amir-à ni. Big zìg yag kwonn sig ma tulare bá pàb Yesu á dìr-à ni. ");
INSERT INTO jib_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Barà big yag fòr níng, big yag dìg big tìr dù rìghing abàn-à á nu amir-à ni. ");
INSERT INTO jib_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Big kà yag, n dìg fig dìr Shinn Luyí Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Barà big ri kyab bu-à sa sig níng, sái mpìr pyànà mìr gbìb zu mà amir-à ni á pyànnbá ni. Jàbá ri ngìg kpàin kpàin kpàin. ");
INSERT INTO jib_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I byar-à hi zinn pànn rìg big. Uwà káníng í bìnn kir wann rìg-à á jìnn ni. Mpìr jà mìmìg káníng bib uwà káníng rag, “Bu-à sa ning ri yàn kyann mpìr-à shi sig ma yonkiwá áyau ki káníng ni í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ai, ku bàna áyag. Ku dù rìghing. Aning kyab bu-à ku dinya sig ning sai-à ku rì á Galili. ");
INSERT INTO jib_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wàníng í bu-à ku rì dang sig, ku rag bá zìg ku, ku Wun Mpìr Jíkwìnn. Bá ya kà ku á vù mpìrká ri sa bu pyìr. Káníng má zìg ku, má dab bàg gbam ku átàm bín. Kwá wu. Ayúnn su sara kwá dù nann zu kàng ma yonki.” ");
INSERT INTO jib_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","I byar-à big í jírwá í kyab pànn-à. ");
INSERT INTO jib_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Uwà káníng kàng bi mà amir-à ni, n dinya yann sukà dwib agban zyun bu Yesu ma mpìr kádà níng tai buká sa sig. ");
INSERT INTO jib_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","I Maryamu Magdaliya, ma Yuwana, ma Maryamu na Yakubu, ma uwàká káhi big í àsàinká dinya sig yann sukà Yesu big tai-à níng. ");
INSERT INTO jib_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama yann sukàká big zìm fig jir uwà káníng bàna n rag uwà káníng ri dang jír átai. ");
INSERT INTO jib_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sái Bitrus dù ma shàu, n shàr yag mà byar amir-à ni. Ku bìnn kir wann, mi ri dab myàng kà yag zuwá mà amir-à ni. Ku myàng jà-à big sìnn kà sig Yesu áni níng, wan wìr wann sig màhàn. Ku kàng yag mi ri kyab bu-à sa sig. ");
INSERT INTO jib_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ayúnn-à hi, yann sukà Yesu big pyànà, big dù á Urushalima, mi ri yag mà kauye zyun ni, big ri bar Imuwasu. Pyunn gbìb-à hi mel sùmpyànn. ");
INSERT INTO jib_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Big ri dang jírbá á gbìb-à ni bar buká sa sig Yesu. ");
INSERT INTO jib_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Barà big ri dang jír á shinn buká sa sig níng ni, í byar-à Yesu ma shinnwá ku bi, mi ri kyann ma big. ");
INSERT INTO jib_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Big myàng hing ku, ama big myàng yì fig wà í ku bàna. ");
INSERT INTO jib_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ku bib káníng rag, “Ning ri dang kai á gbìb-à ni rà?” Big sar wann, pìkyinnbá ri bai. ");
INSERT INTO jib_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mpìr zyun áyaubá ni, big ri bar ku Kiliyobas, ku dang rag, “Asái áyau kyìnnká bi sig á Urushalima, íri wù wà áwinwú ni à yì fig bu-à sa sig áyau su pyànà káníng ni bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu bib big, n rag, “I kai sa síg nì rà?” Big dinya ku rag, “I jir Yesu mpìr-à á Nazarat. Ku í mpìr-à rì dang kyann sig jir Shìdun ma gbam á pyànn mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ama àgbamká buyí big ma mpìrká ri twìb swànn bu á pyànn Shìdun ni, big zìg ku n ya á vù gwamna, jirà abig gban ku á atàm bín-à ni. ");
INSERT INTO jib_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yi rì wà sig rag ku í àsàin-à má zìg zu mpìr Israilaká á shwìn. Kwonn ma wàníng, janá-à níng su sara ma wà ku wu sig. ");
INSERT INTO jib_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Uwàká yi ma big ri shi zyun níng, big sa yi bu mamaki. Big yag sig mà amir-à ni ḿbyau níng. ");
INSERT INTO jib_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Big dìg fig kiwá bàna, big kàng bi n dinya yi n rag big dìg yann aswamká bu Shìdun mà wai màhàn. Yann aswam Shìdun káníng dinya uwà káníng n rag, ‘Yesu dù nann zu kàng rìghing. Wàníng shi sig ma yonki.’ ");
INSERT INTO jib_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mpìrká yi ma big ri shi zyun, big yag mà amir-à ni tìnn, n kàng bi n dinya yi n rag, ‘Barà uwàká dang níng, í àjai.’ Ama mpìrká buyí níng, myàng fig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu dang rag, “Ning í mpìrká bàna ma kyinn. Ning ri wib fig bu-à mpìrká rìi dang kyann jir Shìdun ri dinya ning bàna. ");
INSERT INTO jib_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Jir Shìdun dinya fig ning rag, Almasihu má wa shwìn ḿpyim, í wà kwá shi mpìr ùwài íni bàna rà?” ");
INSERT INTO jib_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ku dinya byann big bu-à big ba sig á shinnwá ni á tarkada Shìdun. Ku dang jag ma á shinn bu-à Musa ba sig, ma buká mpìrká rìi dang kyann jir Shìdun káhi ba sig tìnn. ");
INSERT INTO jib_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Barà big bi fòr á kauye big ri zìm abig bi níng, í byar-à hi Yesu sa shi shirag kwá yag mà pyànn. ");
INSERT INTO jib_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Big vig ku n dang rag, aku tìg á lu-à bá tìg níng ni, jir kai bàna àyúnn-à kà rìghing. Dà sig títi nímá fi má sìr. I byar-à ku bàg yag big, ku ma káníng shi síg zyun. ");
INSERT INTO jib_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Big shi í byar ńzyun bá ji buju. Ku zìg brodi, ku yan Shìdun n ngir gbànn gàfinn brodi-à n ya big. ");
INSERT INTO jib_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","I nànn-à hi, zubá í yar rìg-à. Barà bá myàng yì í ku níng, ku í jànn rìg-à áyaubá ni. ");
INSERT INTO jib_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Big dinya bar dìrbá n rag, “Yi fig hing àjwár wàni, ku dinya byann sig yi yìr jír á shinn tarkada Shìdun ni á gbìb-à ni.” ");
INSERT INTO jib_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I byar-à big dù sa báb, n kàng yag rìg mà Urushalima, n yag dìg yann aswam Yesu big dwib agban zyun-à níng. Big shi sig í byar ńzyun ma mpìrká káhi. ");
INSERT INTO jib_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bìr mpìrká dang rag, “Ajai, Shinn Luyí Yesu dù kàng rìghing ma yonki. Hár Bitrus myàng hing ku tìnn.” ");
INSERT INTO jib_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sái mpìr pyànà káníng dinya big bar bu-à sa sig á gbìb-à ni, hár barà big myàng yì wà í Yesu á sai-à ku ngir gàb finn brodi n ya big. ");
INSERT INTO jib_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Barà mpìr pyànà káníng ri dinya big bar bu-à sa sig, sái Shinn Luyí Yesu mìr gbìb zu áyaubá ni. Ku dang rag abig shi ítau. ");
INSERT INTO jib_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ama dìrbá zwab, big shàr zinn. Big wà sig rag káhi big myàng sig í wàu. ");
INSERT INTO jib_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu dang rag, “Bu-à sa ning ri shàr zinn níng í jir kai rà? Bu-à sa ning ya fig gwangga bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aning myàng vùmí ma barmí. Ai, í mì ma shinnmí. Aning pànn mì, aning myàng. Wàu bàna ma wi dìr ma akib àràg mì.” ");
INSERT INTO jib_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Barà ku dang àdòníng, ku tìya káníng vùwá big ma barwá big. ");
INSERT INTO jib_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Big ri kyab kó í ku rà? Ajwár sa rìg big. Mamaki pànn rìg big tìnn. I byar-à Yesu bib big n rag, big shi sig ma buju áyag rà? ");
INSERT INTO jib_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","I byar-à big ya ku agir jái-à big wànn kà sig á pyìr. ");
INSERT INTO jib_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ku zìg n zwam, big ri myàng. ");
INSERT INTO jib_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ku dinya big n rag, “Wàníng í jír-à ǹ rì dinya sig ning á sai-à yi ma ning rì shi sig má í zyun. N dang rag, bu-à big ba sig á tarkada Musa, ma tarkada mpìrká ri dang kyann jir Shìdun, ma tarkada Zabura, bu káníng má sa àràg barà big rì dang sig á shinnmí ni.” ");
INSERT INTO jib_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ku sa big abig kàng mpìr yar, jirà abig yì jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ku dang rag, “I barà big ba sig áni, n rag, ‘Almasihu má wa shwìn. Bá gban ku. Ayúnn su sara kwá dù nann zu kàng ma yonki.’ ");
INSERT INTO jib_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Big ba sig n rag, ‘Mpìrká má dang jag jír-à ǹsàn daka mà Urushalima hár jànnká á dunyaru bidìm pár bá fig vinn rìg. Bá dinya mpìrká abig vim bìr bi pìkyinnbá á byar Shìdun, abig fim bu pyìrbá, jirà Shìdun má yafa ya big á zìnn Almasihu.’ ");
INSERT INTO jib_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ning myàng hing bu káníng sa hing. Aning dinya mpìrká. ");
INSERT INTO jib_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Má swam ya bi ning bu-à Shìdun rì dang sig, wato í Awun Kyìkyàrwá. Ama, aning shi má mà finn swann-à ni ḿpyim, bá ya bi ning gbam-à níng mà wai.” ");
INSERT INTO jib_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu zìg zu big á finn swann Urushalima, n zìg yag big mà kauye Baitanya. Ku bir vùwá á shinn káníng ni, n vig Shìdun n dang rag aku sàn ya big. ");
INSERT INTO jib_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Barà ku dang àdòníng, sái ku í káníng í fim rìg-à, Shìdun í ku í zìg rìg-à, n zìg yag rìg ku mà wai. ");
INSERT INTO jib_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Big swam yan ku, n kàng yag mà Urushalima ma pìkyinn àjwár. ");
INSERT INTO jib_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kó ákaun big ri yag mà lu Shìdun. Big ri swam yan ku.");
INSERT INTO jib_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sai-à Shìdun màm fig ma jànn-à bàna, mpìr zyun shi sig ma ku, zìnnwá í Yìr Jír. Ku ma Shìdun í bu ńzyun, Yìr Jír-à níng í Shìdun tìnn. ");
INSERT INTO jib_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sai-à big màm jag sig jànn-à á jìnn ni níng, Yìr Jír-à níng shi sig ma Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Shìdun sìnn kà Yìr Jír, ku ma wàníng màm kó kai bidìm pár á bìr-à ni. Shìdun màm fig bu zyun ku áwinwá ni bàna, kó kai ku ma Yìr Jír. ");
INSERT INTO jib_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yìr Jír-à níng í àsàin-à shi sig ma yonki. Yonki-à níng ya bi sig mpìrká àyar. ");
INSERT INTO jib_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yonkiwá í àyar, àyar-à má yar kàng kwìb vinn rìg fi. Ayar-à níng, fi má sìr kan dim sar fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Shìdun swam bi wùn aswamwá zyun, big ri bar ku Yohanna. ");
INSERT INTO jib_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ku bi sig aku dinya mpìrká jir àyar-à níng, jirà mpìrká abig fig, ma abig bir pìkyinnbá áni. ");
INSERT INTO jib_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanna ma shinn dìrwá ku í àyar-à hi bàna, ama ku bi sig jirà aku dang jír á shinn àyar-à hi ni. ");
INSERT INTO jib_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yìr Jír-à níng í àyar àjai, zyun-à bi sig á jànn-à ni, jirà aku yar kàng kwìb vinn rìg mpìrká bidìm pár. ");
INSERT INTO jib_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ku shi sig á jànn-à ni, wà zyun-à Shìdun màm sig jir shinnwá. Ama mpìrká á jànn-à ni myàng yì fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ku bi sig á jànnwá ni, ama mpìrká á jànnwá ni ngàng ku. ");
INSERT INTO jib_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama mpìrká zyun-à shà ku n pànn sig ku vù pyànà, n bir sig pìkyinnbá á byarwá ni níng, ku ya sig big gbam abig shi yannká bu Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mpìr káníng kàng rìghing yann Shìdun. Ama big shi fig àràg barà big ri mà mpìr bàna. Shìdun ma shinnwá í Tabá. ");
INSERT INTO jib_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yìr Jír-à níng kàng rìghing mpìr, ku shi hing áyauyí ni. Ku í mpìr-à mònn sig ma pìkyinn sìsàn ma jír àbyann. Yi myàng hing gbam swàmwá zyun-à ku sa sig. Swàm buká ku sa sig níng, í bu-à yi yì rag ku bi sig mà byar Tawá ni àjai. ");
INSERT INTO jib_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanna dang hing jír àbyann n rag, “Mpìr-à ma bi ásimmí ni níng, mpìr-à hi í àgbammí, jir kai bàna ku rì shi bab sig buwá áni, tun daka sai-à big mà fig ma mì bàna.” ");
INSERT INTO jib_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yi bidìm pár, yi dìg hing bu-à ǹsàn á shinnwá ni. Buká nìnànn nímá yi dìg hing, ku sa ya hing yi àsàn nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Shìdun ya sig dokawá big á vù Musa ni, ama àsànwá ma jír àbyannwá, ku ya kà sig kàhi á vù Yesu Almasihu. ");
INSERT INTO jib_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Walai mpìr-à myàng sig Shìdun ma yìr zuwá, sái dái wùnwá yì sig ku í nì, kwá áwinwá ni. Ku ma Tawá í bu ńzyun. Ku í àsàin-à dinya sig yi barà Tayí shi sig áni. ");
INSERT INTO jib_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yahudawaká mà Urushalima swam yag àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma Lawiyaká, jirà abig yag bib byann Yohanna ku í ni rà. ");
INSERT INTO jib_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I byar-à ku dang jírwá àjai, ku sa fig yipyàr bàna, n dang rag ku í Almasihu bàna. ");
INSERT INTO jib_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Big bib ku n rag, ku í ni rà? Ku í Iliya rà? Ku dang rag, a a! Ku í Iliya bàna. Big bib jakàng ku n rag, ku í mpìr-à Shìdun má swam bi à byarbá ni rà? Ku dang rag, “A a!” ");
INSERT INTO jib_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","I wà big bib jakàng ku, aku dinya big ku í ni rà. Bu-à sa níng, big ri zìm abig zìg kàng yag abig dinya kàng mpìrká swam bi sig big níng, aku dinya big, ku í swai mpìr kai rà. ");
INSERT INTO jib_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanna dinya big jír zyun-à Ishaya rì ba sig n rag, “I nài abormí ri su bi mà awúnn-à ni ri dang rag, abig gbar lafinn gbìb-à gwor sig níng, jirà Shinn Luyí má kyann áni.” ");
INSERT INTO jib_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mpìr káníng big í Farisawaká swam bi sig big ínì. ");
INSERT INTO jib_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","I wà mpìr káníng bib ku n rag, “Wà wù má í Almasihu bàna, wù má í Iliya bàna, wù má í Wùn Aswam Shìdun zyun-à ku dang rag kwá swam bi níng bàna tìnn, bu-à sa wù ri wau dìr batisma í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I wà Yohanna dinya big n rag, “Bumí, mì ri wau dìr batisma ma zàpìr, ama mpìr zyun sar sig áyauná ni, ning yì fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ku í zyun-à má bi ásimmí ni, í zyun-à ǹ fòr fig wà má fìnn jùr tabarwá bàna.” ");
INSERT INTO jib_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bu káníng bidìm pár rì sa sig mà Baitanya mà Ning Urdun mà jann mà byar-à Yohanna ri wau dìr batisma. ");
INSERT INTO jib_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na kyàr byar-à, sái Yohanna myàng Yesu ri bi, ku dang rag, “Aning myàng, wàníng í wùn àdùn Shìdun zyun-à má zìg zu kó ni á bu pyìrwá ni bidìm par. ");
INSERT INTO jib_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wàníng í mpìr-à ǹ dang rag, kwá bi ásimmí ni, ku í àgbammí, jir kai bàna ku rì shi bab sig sai-à big rì mà fig ma mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","N rì yì fig wà í ku bàna, ama ǹ bi sig jirà ń tìya ning ku, ning mpìrká á Israila, í bu-à sa mì ri wau dìr batisma ma zàpìr.” ");
INSERT INTO jib_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","I byar-à Yohanna dang rag, “N myàng hing barà Awun Shìdun rì tìg wann bi n kir wann á shinn Yesu ni àràg àlàb. ");
INSERT INTO jib_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","N rì yì fig wà í ku bàna. Sai-à Shìdun swam bi mì n rag ń wau dìr batisma níng, ku dinya mì rag, mpìr-à ma myàng Awun Shìdun ma tìg wann bi á shinnwá ni, ma kir sig, ku í àsàin-à má wau dìr batisma ma Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N myàng hing, í bu-à má bib fig abib bàna, wàníng í Wùn Shìdun àjai.” ");
INSERT INTO jib_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na kyàr byar-à, Yohanna sar sig ma yann sukàwá big pyànà. ");
INSERT INTO jib_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sái ku myàng Yesu ri wam zu yag, ku dang rag, “Aning myàng wàníng í Wùn Adùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Barà yann sukà pyànà káníng myàng àdòníng, sái big kan bàg yag rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu myàng vim bìr bi big, big ri kan bàg yag ku ásim, ku bib káníng n rag, “Ning ri yàn kyann í kai rà?” I byar-à big bib ku rag, “Wù ri shi áni rà? Rabbi!” (Yìr jír-à níng í Malam.) ");
INSERT INTO jib_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ku dinya big n rag, abig bi myàng. Sai-à hi àyúnn-à dab gang rìghing, àràg àsháu yina. Big bàg yag ku n yag myàng byar-à ku shi sig. Ku ma káníng shi sig í zyun hár fi. ");
INSERT INTO jib_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ayaubá big pyànà níng, big fig hing jir Yohanna mi ri bàg Yesu, zyun áyaubá ni í Andarawus wunzà Siman Bitrus. ");
INSERT INTO jib_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","I byar-à ku yag yàn dìg bi shunwàuwá Siman, ku dinya wàníng n rag, “Yi dìg hing Almasihu zyun-à Shìdun gib sig nu rag kwá bi níng.” (Yìr Almasihu í Kristi.) ");
INSERT INTO jib_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sái ku í wàníng í zìg yag rìg-à mà byar Yesu. Yesu myàng ku n dang rag, “Wù í Siman wùn Yohanna, bá bar wù Kefas (Bitrus).” Yìr jír-à níng í abàn. ");
INSERT INTO jib_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na kyàr byar-à, Yesu ri zìm aku yag mà Galili. Ku yag yàn dìg Filibus, n dinya wàníng n rag a wàníng bàg ku. ");
INSERT INTO jib_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus í mpìr-à mà Batsaida, mà lu Andarawus ma Bitrus tìnn. ");
INSERT INTO jib_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","I wà Filibus yag dìg Nataniel, n dinya wàníng rag, “Yi dìg rìghing mpìr-à Musa rì ba sig, n dang sig jír á shinnwá ni á finn tarkada. Mpìrká rìi dang kyann jir Shìdun níng, big ba sig jír á shinnwá ni tìnn. Big ri bar ku Yesu mpìr-à á Nazarat wùn Yusufu.” ");
INSERT INTO jib_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel bib n rag, “Hár bu-à ǹsàn má zu á Nazarat ràu?” I wà Filibus dang rag, “A bi myàng.” ");
INSERT INTO jib_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Barà Yesu myàng Nataniel ri bi á byarwá ni, ku dang n rag, “Mpìr-à níng í mpìr-à á Israila àjai, ku í mpìr gwangga.” ");
INSERT INTO jib_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel bib ku n rag, “A yì sig mì áshinn rà?” I byar-à Yesu dinya ku n rag, “Ai, ǹ myàng hing sai-à wù nìm shi sig á mìr ating zyun ni níng. I byar-à Filibus yag dìg sig wù màhàn.” ");
INSERT INTO jib_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sái Nataniel dinya kàng Yesu n rag, “Shinn Luyí, wù í wùn Shìdun, wá na kùr mpìrká á Israila.” ");
INSERT INTO jib_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu bib ku n rag, “Jirà ǹ dang rag, ‘N myàng hing wù, à shi sig á mìr ating-à ni’ níng, í bu-à sa à bir sig pìkyinnwú á byarmí ni níng rà? Ai, wá myàng buká má kab wàníng.” ");
INSERT INTO jib_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu dinya big n rag, “Mì ri dinya ning jír àjai. Ná myàng waisháu má pù finn rìg, yann aswam Shìdun má nai yag, má tìg wann bi á byar Wùn Mpìr Jíkwìnn.” ");
INSERT INTO jib_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ayúnn su sara, big sìr ban mpìr zyun mà swann Kana á jànn Galili. Na Yesu shi sig màhàn tìnn. ");
INSERT INTO jib_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Big dwim bar Yesu ma yann sukàwá big tìnn. ");
INSERT INTO jib_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Barà zàn inabi ban-à big ya sig mpìrká í vinn rìg-à níng, sái nàwá dinya ku rag, “Ai, zàn inabi-à bigbá vinn rìghing.” ");
INSERT INTO jib_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu dinya ku rag, “Ayáa nàmí, kada á dinya mì bu-à má sa bàna, jir kai bàna àyúnnmí màg fig ma bàna.” ");
INSERT INTO jib_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","I byar-à na Yesu dinya yann lu àsàin ban-à rag, “Bu-à Yesu ma dang rag aning sa, aning sa bu-à hi.” ");
INSERT INTO jib_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mà byar-à hi, par zànká big mi sig ma abàn, shi sig màhàn àkunn sùnnjin. Yahudawaká ri zìm írì swai par káníng hi, jir kai bàna wà ba bar kwonn hing mpìrká àdòníng, big ri wìrkà zàpìr áni. Par káníng wài hing ri ji finn yann àkwìnn dìzyun, kó dìzyun agban dwib. ");
INSERT INTO jib_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","I byar-à Yesu dinya yann lu àsàin ban-à rag, abig wìr mònn rìg par káníng ma zàpìr. I byar-à hi, big wìr mònn rìg, pák. ");
INSERT INTO jib_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","I wà ku dinya big rag, abig kab abig ya jag ma àgbam-à ri sa shang àsàin ban káníng swàm. I byar-à big kab n ya ku. ");
INSERT INTO jib_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","I byar-à àgbam-à wa fig zàpìr-à níng, zàpìr-à hi kàng rìghing zàn inabi. Agbam-à níng yì fig byar-à zàn inabi-à níng bi sig bàna. Ama yann luká yì rìghing. I byar-à hi àgbam-à bar àsàin ban-à, ");
INSERT INTO jib_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","n dang rag, “Ai, kó ni bidìm pár ri ya jag zàn inabi ǹsàn ḿpyim, í wà mpìrká ma wa màg hing, big ri ya wà zyun-à dor sàn fig bàna níng ásim. Ama buwú à sìnn gbam rìghing wà ǹsàn-à níng, sái tàma-à níng.” ");
INSERT INTO jib_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu sa jag bu mamaki-à níng mà Kana á jànn Galili. I byar-à yann sukàwá big bir pìkyinnbá n dang rag, “Asai gbam mpìr-à níng bi sig mà byar Shìdun ni àjai.” Hár big bir swàb kà pìkyinnbá á jírwá ni. ");
INSERT INTO jib_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Asim ku dù n yag mà Kafarnahum, ku ma nàwá ma wunzàwá big ma yann sukàwá big. Big shi kù màhàn su pyànà. ");
INSERT INTO jib_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayúnn Pìm Wam Zu bu Yahudawaká nyàan fòr, í byar-à Yesu í yag rìg-à mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sái ku kà yag mà finn lu Shìdun n yag dìg mpìrká ri wann tafinn nai ma àdùn ma àlàb. Mpìrká ri pyann bài má, shi sig màhàn tìnn. ");
INSERT INTO jib_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu tà ashor jùr, n kan zu rìg big á lu Shìdun ni, ku za zu rìg nai káníng ma àdùn káníng tìnn. Ku gbar bir wann rìg tebur-à á jìnn ni, bàiká yam finn rìg awín awín tìnn. ");
INSERT INTO jib_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ku dinya mpìrká ri wann tafinn àlàb káníng rag, “Aning zà zìg zu rìg bu káníng áyag, kada aning sìnn kàng lu Tamí aku shi í byar buati bàna.” ");
INSERT INTO jib_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","I byar-à yann sukàwá big kyab pànn barà big ba sig rag, “Pìkyinnmí ri zìm luwú wàni.” ");
INSERT INTO jib_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","I byar-à Yahudawaká bib ku rag, “I bu mamaki-à wà áni wá tìya yi jirà ayi yì wù ri sa swàm ma gbam Shìdun àjai rà?” ");
INSERT INTO jib_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I byar-à Yesu dinya big n rag, “Aning mìb gbànn rìg lu-à níng, má mi kàng rìg áyau su sara.” ");
INSERT INTO jib_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","I byar-à big dang n rag, “Aá, lu-à big mi sig áyau ji dìpyànà, í wà big mi kinn síg nì, í wà à dang rag, buwú wá mi kinn rìg áyau su sara rà?” ");
INSERT INTO jib_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama lu Shìdun-à Yesu dang sig níng, í dìrwá. ");
INSERT INTO jib_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sai-à ku dù nann zu kàng ma yonki níng, yann sukàwá big í kyab pànn-à rag, Yesu rì dinya hing big jír-à níng. I byar-à hi, big bir pìkyinn á jir Shìdun barà big rì dang sig á shinn Yesu ni, ma buká Yesu rì dang sig níng tìnn. ");
INSERT INTO jib_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Barà bu mamaki-à ku sa sig mà Urushalima àyúnn Pìm Wam Zu-à níng, mpìrká nìnànn nímá fig àjwár, n wib ku, hár n bir pìkyinn áni. Big dang n rag, “Mpìr-à níng í Almasihu àjai.” ");
INSERT INTO jib_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu bir fig pìkyinnwá á byarbá ni bàna, jir kai bàna ku yì rìghing bu-à mpìr jíkwìnn ri kyab á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mpìr má dinya fig ku í nì bàna, jir kai bàna ku ma shinnwá, ku yì rìghing bu-à á pìkyinn mpìrká ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mpìr Farisawa zyun shi sig áni, ku í àgbam áyau Yahudawaká ni tìnn, big ri bar ku Nikodimu. ");
INSERT INTO jib_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ku bi á fi-à ni á byar Yesu ni, n dang rag, “Shinn Luyí, yi yì hing wù í malam zyun-à Shìdun swam bi sig, jir kai bàna mpìr má sa sar fig bu mamakiká wù ri sa níng bàna, sái mpìr-à gbam Shìdun ma shi sig ma ku.” ");
INSERT INTO jib_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu dinya ku n rag, “N dinya wù jír-à níng àjai, sái ba mà kàng hing mpìr jakàng, ma í nímá bàna, kwá myàng fig byar-à Shìdun má na kùrwá bàna.” ");
INSERT INTO jib_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimu bib ku n rag, “Sáshinn bá mà kàng mpìr àwàutím rà? Mpìr-à hi má kà kàng á finn nàwá ni, í wà bá mà ku í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu dinya ku n rag, “Bu-à mì ri dinya wù níng í àjai. Sái ba mà hing mpìr ma zàpìr ma Awun Shìdun ḿpyim, í wà kwá dìg byar-à Shìdun na sig kùrwá. Ma í nímá bàna, kwá kà fig byar-à Shìdun na sig kùrwá bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dìryí yi dìg sig á byar mpìrká mà sig yi, ama awunyí yi dìg sig á byar Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kada á sa mamaki wà ǹ dang rag, bá mà kàng wù níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wàu ri gbar yag agunn-à ku ri zìm. Wá fig wàu ri gbar, ama wá yì fig byar-à ku ri bi bàna. Wá yì fig byar-à ku ri yag bàna tìnn. Mpìr-à Awun Shìdun mà sig, má shi àdòníng.” ");
INSERT INTO jib_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","I byar-à Nikodimu bib ku n rag, “Bu-à níng má sa áshinn rà?” ");
INSERT INTO jib_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu dinya ku n rag, “Wù zyun-à wù í àgbam malam-à á jànn Israila, à yì fig bu káníng bàna rà? ");
INSERT INTO jib_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mì ri dinya wù jír-à níng àjai. Yi yì hing bu-à yi ri dang, ma bu-à yi myàng sig tìnn, ama ning ngàng wà ná fig bu-à yi ri dang. ");
INSERT INTO jib_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N dinya rìghing ning jir buká á jànn-à ni. Ning bir fig pìkyinn ná áni bàna, sáshinn wà má dinya ning jír á shinn buká mà wai, ná bir pìkyinn ná áni rà? ");
INSERT INTO jib_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ama kó mpìr ńzyun yag màg fig fig mà wai bàna, sái Wùn Mpìr Jíkwìnn zyun-à wann bi sig mà wai. ");
INSERT INTO jib_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Barà Musa gbar dù nann sig bushùwí àsháu-à níng n yab sig mà shinn bín mà wai, sai-à big rì shi sig mà awúnn-à ni níng, í barà bá gbar dù nann zu Wùn Mpìr Jíkwìnn áni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mpìr-à ma bir hing pìkyinnwá á byar wàníng ni, kwá dìg yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Shìdun ri zìm mpìrká á jànn-à ni wàni, í bu-à sa ku swam bi sig wùnwá ńzyun, jirà mpìrká zyun-à ma bir hing pìkyinn á byar wàníng ni, bá wu fig ki bàna, bá dìg yonki zyun-à má vinn fig ávinn bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Shìdun swam bi fíg wùnwá á jànn-à ni, dò jirà a wàníng wà kwonn mpìrká bàna, ama a wàníng shi mpìr-à má zìg zu mpìrká á shwìn. ");
INSERT INTO jib_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Mpìr-à ma bir hing pìkyinn á dìrwá ni, bá wà fig ku kwonn bàna. Ama mpìr-à ma bir fig pìkyinnwá bàna, big wà rìghing kwonnwá tun daka í janá-à níng bàna, jir kai bàna ku ngàng wà kwá wib zìnn Wùn Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wàníng í barà bá wà kwonn-à hi áni, jir kai bàna àyar bi á jànn-à ni, mpìrká zìm kab sig fi ma àyar-à níng, jir kai bàna buká big ri sa sàn fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mpìr-à ma ri sa bu-à bibai, ku zìm fig àyar-à níng bàna. Kwá bi fig á byar àyar-à hi ni bàna, jir kai bàna kwá zìm fig swàm bu-à bibaiká ku ri sa níng aku zu á myann bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mpìr-à ma ri sa bu-à ǹsàn, kwá bi á byar àyar-à níng, jirà abig myàng swàmwá sàn sig í bu Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nonn fig bàna, sái Yesu ma yann sukàwá big í yag rìg-à mà jànn Yahudiya, í byar-à ku ma káníng shi shi, ku ri wau mpìrká dìr batisma. ");
INSERT INTO jib_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohanna ri wau dìr batisma mà Ainon byar-à hi shi yàr sig ma jànn Salim, jir kai bàna zàpìr shi sig màhàn wùwài nímá. I wà mpìrká nìnànn nímá ri yag mà byarwá ni, ku ri wau big dìr batisma. ");
INSERT INTO jib_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wàníng í sai-à big kìg fig ma Yohanna á tonn fi bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ayúnn su zyun, mpìr Yahudawa zyun sa yipyàr ma yann sukà Yohanna big á shinn barà bá sa kyàr dìr. ");
INSERT INTO jib_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I byar-à big kàng bi á byar Yohanna, n dinya ku n rag, “Shinn Luyí, mpìr-à wù nìm dìg kwonn big ku mà Ning Urdun mà jann, zyun-à wù nìm bar ku Almasihu níng, tàma-à níng ku ri wau dìr batisma, mpìrká bidìm pár ri yag mà byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanna dang rag, “Mpìr má dìg fig bu zyun bàna, sái zyun-à Shìdun ma ya hing ku. ");
INSERT INTO jib_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ning má, ning fig hing buká ǹ dang sig á numí ni n rag, ‘Mì í Almasihu bàna, big tìr bi sig mì ń kà ku á pyànn átai.’ ");
INSERT INTO jib_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sai-à mpìr ma zìg hing uwà, jàuwá má fig àjwár. Kwá fig hing nài jir mpìr-à má zìg uwà-à níng, kwá fig àjwár. Mì má, í barà mì ri fig àjwár Almasihu áni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gbamwá má shi swàb kà, ama bigmí má shi kàng ásim. ");
INSERT INTO jib_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ku bi sig mà wai, ayìwá kab bu mpìrká bidìm pár íni. Gbamwá kab bu kó ni tìnn. Ama bigmí mì í mpìr-à á jànn-à ni, ayìmí títi nímá, ama buwá ku yì vinn rìghing bu bidìm pár. ");
INSERT INTO jib_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Buká ku fig sig, n myàng sig ma zuwá níng, ku dinya gban rìghing mpìrká. Ama mpìrká zyun-à bir sig pìkyinn á jírwá ni níng, big nann fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama ká zyun-à ri bir pìkyinn á jírwá ni níng, ri bir pìkyinn rag, ‘Shìdun í Shìdun gwangga.’ ");
INSERT INTO jib_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mpìr-à Shìdun swam bi sig níng, ku ri dang kyann í jir Shìdun, jir kai bàna Shìdun ya sig ku awun-à bá màg màg fig fig àmàg màg fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ta ri zìm wùnwá, jir kai bàna kó kai bidìm pár ku ya sig á vù wùnwá ni. ");
INSERT INTO jib_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mpìr-à ma bir hing pìkyinn ma Wùn Shìdun, ku shi sig ma yonki-à má vinn fig ávinn bàna, mpìr-à ma ngàng Wùn Shìdun, kwá dìg fig yonki-à níng bàna. Shìdun má sìnn kà ku á shwìn-à má vinn fig ávinn bàna.” ");
INSERT INTO jib_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mpìr Farisawaká fig Shinn Luyí Yesu ri dìg swàb kà yann sukà big kab bu Yohanna rì níng, ku ri wau káníng dìr batisma. ");
INSERT INTO jib_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu ri wau fig nì dìr batisma bàna. Yann sukàwá big ri wau íni. ");
INSERT INTO jib_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Barà Yesu fig bu-à Farisawaká ri dang níng, ku í fim rìg-à jànn Yahudiya, n kàng yag mà jànn Galili. ");
INSERT INTO jib_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ku myàng shi sig í dole aku zu yag gbìb-à á jànn Samariya. ");
INSERT INTO jib_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","I byar-à hi, ku í zu rìg-à gbìb-à á jànn Samariya á finn swann zyun ni, big ri bar Saikar, byar-à hi nonn fig ma byar-à Yakubu rì ya sig wùnwá Yusufu jànn bàna. ");
INSERT INTO jib_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Shar zàpìr Yakubu shi sig màhàn. Yesu kyann nì rìghing. I byar-à ku shi sig á nu shar zàpìr-à hi ni. Bu-à sa níng í kyonn pyunn ninonn daka í pyimbyau, hár àyúnn áyau shinn. ");
INSERT INTO jib_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","I byar-à uwà Samariya zyun bi sig aku kab zàpìr. I byar-à Yesu dang n rag, a wàníng ya ku zàpìr aku wa. ");
INSERT INTO jib_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Yann sukàwá big yag rìghing mà finn swann-à ni, jirà abig yag wann bi buju.) ");
INSERT INTO jib_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","I byar-à hi, uwà Samariya-à níng dang n rag, “Sáshinn wá vig mì zàpìr rà? Wù zyun-à wù í wunù Yahudawa, mì zyun-à mì í uwà Samariya.” (Ai mpìr Yahudiya ma mpìr Samariya ri kyag fig dìr bàna.) ");
INSERT INTO jib_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","I byar-à hi, Yesu dinya uwà-à níng n rag, “Wù nìm ma yì hing bu-à Shìdun ri ya mpìr, ma mpìr-à ri dinya wù rag, á ya ku zàpìr aku wa níng, wù nìm má vig ku aku ya wù zàpìr-à ri ya yonki.” ");
INSERT INTO jib_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uwà-à níng dang n rag, “Shinn Luyí, à bàna ma bu-à wá kab zàpìr-à níng ma kàhi, jir kai bàna shar zàpìr-à níng zùzwàun. To, wá dìg zàpìr-à ri ya yonki-à níng áni rà? ");
INSERT INTO jib_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Asái à kab síg nì tayí Yakubu zyun-à fim ya sig yi shar zàpìr-à níng rà? Ku ma shinnwá ma yanká buwá ma bu apyagká buwá big bidìm pár, big wa hing zàpìr-à níng, ama big wu rìghing.” ");
INSERT INTO jib_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","I byar-à Yesu dinya uwà-à níng n rag, “Mpìrká ri wa zàpìr-à níng, ajor má gban kàng rìg big. ");
INSERT INTO jib_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama mpìr-à ma wa hing zàpìr-à má ya níng, kwá fig fig rag ajor zàpìr bàna hár kinn kinn, jir kai bàna zàpìr-à má ya níng, má shi àràg barà abinn ri gbìb zu, má ya mpìr yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","I byar-à hi, uwà-à níng dang rag, “Shinn Luyí, á ya mì zàpìr-à níng, jirà kada ajor zàpìr aku gban rag mì bàna ma àjirà kada ń bi kab rag zàpìr áyág bàna.” ");
INSERT INTO jib_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","I byar-à Yesu dinya uwà-à níng n rag aku yag bar bi nùwá. ");
INSERT INTO jib_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uwà-à níng dang rag, ái ku bàna ma wunù. I wà Yesu dinya ku n rag, “Ai, àjai, barà à dang níng, à bàna ma wunù àjai, ");
INSERT INTO jib_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","jir kai bàna à zu sig á lu wunù, hár swana, tàma-à níng wunù-à ning ma ku ri shi í zyun níng, í nùwú bàna. A dinya hing mì jír àjai.” ");
INSERT INTO jib_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I byar-à uwà-à níng dang n rag, “Shinn Luyí, ǹ myàng yì hing wù, wù í wùn aswam Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yàkúyí big ri wib Shìdun á shinnkwìnn-à níng ni, ama ning mpìr Yahudawaká ning dang n rag, byar-à mpìr má wib Shìdun bàna, sái mà Urushalima.” ");
INSERT INTO jib_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu dinya uwà-à níng n rag, “A zìm jír-à ma dinya wù níng. A myàng, àyúnn zyun ri bi wà mpìrká má wib fig rag Shìdun á shinnkwìnn-à níng ni bàna, kó mà Urushalima bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ning mpìrká á Samariya, ning yì fig bu-à ning ri wib bàna. Buyí yi mpìr Yahudawaká, yi yì hing bu-à yi ri wib, jir kai bàna jir Shìdun á shinn mpìr-à má zìg zu mpìrká, zu bi síg mà byar Yahudawaká ni. ");
INSERT INTO jib_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama àyúnn zyun ri bi, ái àyúnn-à hi bi rìghing, í àyúnn-à mpìr Shìdun má wib ku ma pìkyinn ńzyun, ma awunwá, jir kai bàna Shìdun ri zìm mpìrká abig wib ku àdòníng. ");
INSERT INTO jib_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Shìdun í Shìdun Awun Kyìkyàr. Mpìrká ri wib ku níng, sàn sig abig wib ku á kyinnbá ni ma pìkyinn kyìkyàr tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","I byar-à uwà-à hi dinya ku rag, “N yì hing big dang rag, Kristi ri bi, zyun-à big ri bar ku Almasihu. Ayúnn-à kwa bi hing, kwá dinya vinn rìg yi bu-à shi sig áni bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","I byar-à Yesu dinya uwà-à níng n rag, “Ai, í mì, mì ri dang jír ma wù níng.” ");
INSERT INTO jib_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Asai-à hi yann sukàwá big í kàng bi-à. Sái big sa mamaki wàni, barà big myàng Yesu shi sig ma uwà-à níng big ri dang jír. Ama áyaubá ni kó mpìr ńzyun bib fig uwà-à níng rag, ku ri yàn kyann í kai rà níng, bàna. Kó abig bib Yesu abig rag, bu-à sa ku ri dang jír ma uwà-à níng, í jir kai rà níng, bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","I byar-à uwà-à níng fim rìg par zàpìrwá màhàn, n kàng yag rìg mà lu-à ni, n yag dinya mpìrká n rag, ");
INSERT INTO jib_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aning bi myàng mpìr-à níng. Ku dinya vinn rìghing mì buká ǹ rì sa sig daka á ninonn. Kó ku í Almasihu hi rà?” ");
INSERT INTO jib_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I wà bìr mpìrká dù rìg á finn swann-à ni, jirà abig yag myàng Yesu. ");
INSERT INTO jib_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sai-à big bi fòr fig ma bàna níng, yann sukàwá big vig ku n dang rag, “Shinn Luyí, á ji ma buju ḿpyim.” ");
INSERT INTO jib_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","I byar-à ku dinya káníng n rag, “N shi sig ma buju-à má ji, buju-à níng hi ning yì fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","I byar-à yann sukàwá big bib bar dìrbá n rag, “I ni ya bi sig ku buju íni áyag rà?” ");
INSERT INTO jib_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu dinya big n rag, “Bujumí shí nì ń wib jír buká Tamí swam bi sig mì ń sa, hár ń sa aku vinn rìg. ");
INSERT INTO jib_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ning dang n rag, sai-à bá binn kwonn buju-à dà sig sònn yina. Ama mì ri dinya ning, aning myàng daká. Buju byann rìghing, ri zìm mpìrká abig binn kìnn kwonn. ");
INSERT INTO jib_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mpìr-à ri binn kìnn kwonn buju, má dìg lada á pyànn Shìdun, jir kai bàna ku ri binn buju yonki zyun-à má vinn fig ávinn bàna. Jir wàníng mpìr-à ri tàg buju ma mpìr-à ri binn kìnn kwonn buju, sàn sig wà abig shi í byar ńzyun, abig fig àjwár shinnbá. ");
INSERT INTO jib_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Big dang ta sig yìr jír, yìr jír-à hi í àjai, barà big dang sig rag, ‘Anam bu-à kim, mpìr-à má binn buju-à kim.’ ");
INSERT INTO jib_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N swam yag sig ning, aning yag binn buju mà byar-à ning nàm fíg nì bàna, í mpìrká káhi nàm síg ni byar-à hi. Ama ǹ ya hing ning gbam aning yag binn, í byafàn ná bàna, í byafànbá.” ");
INSERT INTO jib_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mpìr Samariyaká nìnànn nímá á finn swann-à hi ni bir hing pìkyinn á byar Yesu á jir bu-à uwà-à níng dang sig n rag, “Ku dinya vinn rìghing mì buká ǹ rì sa sig daka á ninonn.” ");
INSERT INTO jib_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Barà mpìr Samariyaká fòr bi á byarwá ni, big dang n rag, a Yesu bi tìg á lubá ni. I byar-à ku na màhàn su pyànà. ");
INSERT INTO jib_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mpìrká káhi nìnànn nímá kab wà nìm níng, big má big bir pìkyinn á byarwá ni tìnn á jir shinn buká ku ri dang. ");
INSERT INTO jib_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I byar-à big dinya uwà-à níng n rag, “Yi bir hing pìkyinn tàma-à níng, í jir bu-à wù nìm dang sig níng bàna, jir kai bàna yi ma shinnyí, yi fig hing tìnn, yi myàng hing àjai. Ku í mpìr-à má zìg zu mpìrká á dunyaru bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Barà Yesu shi màhàn su pyànà, sái ku í yag rìg-à mà jànn Galili. ");
INSERT INTO jib_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu ma shinnwá ku dang n rag, “Ajai, mpìr-à ma ri dang kyann jir Shìdun, big ri wib fig ku á jànnwá ni bàna.” ");
INSERT INTO jib_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Barà ku fòr yag àdòníng mà jànn Galili, sái mpìrká mà Galili shà ku wàni, jir kai bàna big shi sig mà Urushalima á sai-à àyúnn Pìm Wam Zu, big myàng hing bu-à ku rì sa sig ma zubá. ");
INSERT INTO jib_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","I byar-à Yesu yag mà Kana á jànn Galili, byar-à ku vim bìr zàpìr kàng rìg zàn inabi. Mpìr zyun shi sig á ni, ku í àgbam-à ri sa swàm gwamnati, wùnwá na sig dor mà Kafarnahum. ");
INSERT INTO jib_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Barà ku fig big dang n rag, Yesu bi sig mà jànn Yahudiya, tàma-à níng ku shi sig rag á jànn Galili. I byar-à hi, ku yag mà byar wàníng ni, n vig wàníng n rag, a wàníng bi dàb gbam ya ku wùn wunùwá, jir kai bàna wùnwá hi ri nyàan wu. ");
INSERT INTO jib_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu bib ku n rag, “Wato ná bir fig pìkyinn ná á byarmí ni bàna, sái na myàng hing bu mamaki ma bu iko ḿpyim rà?” ");
INSERT INTO jib_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wunù àgbam-à níng dang n rag, “Shinn Luyí, mì ri zìm á bi á lumí ni, jirà á dàb gbam ya mì wùnmí, dà sig títi nímá kwá wu rìg.” ");
INSERT INTO jib_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu dinya wunù-à níng n rag, a wàníng kàng yag. Wùn wàníng gbam rìghing. Wunù-à níng wib jírwá n kàng yag. ");
INSERT INTO jib_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Barà ku ri kàng yag mà lu-à ni àdòníng, sái ku ma yann luwá big dìg kwonn á gbìb-à ni. Big dinya ku n rag, “Ai wùnwú gbam rìghing, ku shi sig ma yonki, tàma-à níng ítau bu zyun bàna.” ");
INSERT INTO jib_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I byar-à ku bib káníng n rag “Wùnmí gbam sig ákaun rà?” Big dinya ku n rag, “I nàníng àràg àsháu zyun, í wà awàu-à hi fim sig ku.” ");
INSERT INTO jib_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Barà ta wùn-à níng myàng sai-à Yesu dinya ku n rag, aku kàng yag, wùnwá gbam rìghing níng, jír-à wàníng dang sig níng sa hing àdòníng hi. I byar-à hi, ku ma mpìrká á luwá ni bidìm pár, big bir pìkyinn á jir Yesu ni. ");
INSERT INTO jib_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wàníng í bu mamaki-à Yesu sa sig wà wa pyànà, ásai-à ku kàng bi mà jànn Yahudiya n yag mà Galili. ");
INSERT INTO jib_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ayunn zyun Yesu yag mà Urushalima, jir kai bàna í àyúnn ùwài bu Yahudawaká bi síg nì. ");
INSERT INTO jib_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mà Urushalima á nu nkyun byar-à big ri kìg àdùnká níng, zàpìr zyun shi sig áni, big ri bar rag, í zàpìr Betsada. Big bar sig zìnn-à hi á nu jir Yahudawaká ni. Byar-à hi apig swana shi kàng kwìb sig á nu zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A byar apig káníng ni, mpìrká nìnànn nímá ri na màhàn, àràg mpìr àfau, mpìrká bàna ma bar, ma mpìrká dìr-à wu tag rìghing bidìm pár, big ri na màhàn tìnn, jir kai bàna big ri shi kir zàpìr-à aku ding. ");
INSERT INTO jib_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Suká káhi, wùn aswam Shìdun mà wai ri tìg wann bi á zàpìr-à ni, jirà aku wab zàpìr-à. Kwa wab hing zàpìr-à, mpìr dor káníng zyun-à ma bi jag síg nì, dorwá má gbam rìg, kó ma í dor kai bidìm pár. ");
INSERT INTO jib_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A byar-à hi, mpìr zyun na sig dor má sa ji dìzyun agban dwib agban-à zu áni awinyin. ");
INSERT INTO jib_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Barà Yesu myàng wunù-à níng na sig, ku yì rìghing wàníng nonn hing ma dor-à níng. I byar-à ku bib wàníng n rag, “Wù ri zìm abig dàb gbam wù rà?” ");
INSERT INTO jib_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","I byar-à mpìr dìr wa-à níng zìm n dang rag, bu-à sa níng, ku bàna ma mpìr-à má gbar dù nann zu ku. Kó ba wab hing zàpìr-à, ku rag aku yag fòr yag níng, mpìr zyun yag fòr yag jag rìghing ku. Ku sa àdòníng sa sa hár tàma-à níng ku dìg fig pyù-à abig dàb gbam ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","I byar-à Yesu dinya ku n rag, “A sar dù nann zu á wai, á pìnn syuwú, á kyann kyonn.” ");
INSERT INTO jib_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Big rag abig myàng níng, wunù-à níng gbam rìghing àjai. Ku pìnn syuwá mi ri kyann kyonn. Ayúnn-à Yesu ri sa bu-à níng, í àyúnn Asabar, í àyúnn-à Yahudawaká ri shi ngàng áni. ");
INSERT INTO jib_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","I byar-à Yahudawaká dinya wunù-à big dàb gbam sig níng n rag, “Janá-à níng, í àyúnn Asabar, í àyúnn dokayí, sàn fig wà á pìnn syuwú áni bàna.” ");
INSERT INTO jib_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sai ku dinya big n rag, “Wunù-à dàb gbam sig mì níng, dang rag, ń pìnn syumí ń kyann kyonn.” ");
INSERT INTO jib_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yahudawaká bib ku n rag, “Mpìr-à dinya wù rag, á pìnn syuwú á kyann kyonn níng, í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama wunù-à big dàb gbam sig níng, yì byann fig Yesu bàna, jir kai bàna mpìrká nìnànn nímá, big nànn kab gbam mà byar-à hi. Yesu dù rìghing mà byar-à hi ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nonn fig bàna, sái Yesu dìg kwonn ma wunù-à ku dàb gbam sig níng mà lu Shìdun. Ku dang n rag, “A myàng tàma-à níng dìrwú gbam rìghing, kada á sa kàng bu bibai bàna. Wa sa kàng hing bu-à bibai, bu-à má dìg wù má kab wàrì.” ");
INSERT INTO jib_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sái wunù-à níng kàng yag rìg mà byar Yahudawaká ni, n dinya big rag, í mpìr-à big ri bar Yesu níng dàb gbam síg ku nì. ");
INSERT INTO jib_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","I byar-à Yahudawaká nànn àgùnn ma Yesu wàni. Big ri swau ku, bu-à sa níng, ku ri sa bu káníng àyúnn Asabar. ");
INSERT INTO jib_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","I byar-à hi Yesu dinya Yahudawaká n rag, “Tamí Shìdun ri sa swàm hár tàma-à níng, mì má mì ri sa swàm tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","I byar-à Yahudawaká yàn pyù-à abig gban rìg Yesu, jirà ku ri sa swàm àyúnn Asabar, ma jirà ku dang rag ku í Wùn Shìdun níng. Big rag ku ri mam shinnwá ma Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","I byar-à Yesu dinya big rag, “Bu-à ma dinya ning í jír àjai. Wùn má sa fig bu áwinwá ni bàna. Wùn má sa bu-à ku myàng sig Tawá ri sa. Swàm bu-à Ta ma sa, í bu-à wùn má sa tìnn, ");
INSERT INTO jib_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","jir kai bàna Ta ri zìm wùnwá wàni. Kwá tàg wùnwá buká ku ri sa bidìm pár, kwá tìya wàníng swàm, ká wài kab kàhi jirà ná sa mamaki. ");
INSERT INTO jib_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Barà Ta-à ri dàb wìm mpìrká wu rìghing ma yonki níng, í gbìb ńzyun barà wùn má dàb wìm mpìrká pìkyinnwá ri zìm tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ta má wà fig kwonn bàna, jir kai bàna ku ya kà rìghing gbam kwonn wà bidìm pár á vù wùnwá ni, ");
INSERT INTO jib_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","jirà kó ni aku wib wùn-à àràg barà ku ri wib Ta-à níng. Mpìr-à ma wib fig wùn-à bàna, kwá wib fig Ta-à zyun-à swam bi sig wùn-à níng bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Jír-à mì ri dinya ning níng, í jír àjai. Mpìr-à ma fig hing jírmí ma bir hing pìkyinn á dìr mpìr-à swam bi sig mì níng, ku dìg hing yonki-à má vinn fig ávinn bàna. Bá ya fig ku shwìn bàna, jir kai bàna ku kab hing gbam ki, ku shi sig áyau yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mì ri dinya ning àjai, àyúnn zyun má bi, hár àyúnn-à hi fòr bi rìghing, mpìrká wu rìghing níng, má fig nài jir Wùn Shìdun. Mpìrká má fig nài jírwá níng, bá dìg yonki-à má vinn fig ávinn bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aràg barà Ta ri ya mpìr yonki níng, í barà ku sìnn kà wùnwá a wàníng ya yonki tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tawá ya sig ku gbam aku wà kwonn, jir kai bàna ku í Wùn Mpìr Jíkwìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aning shàr zinn bàna, jir kai bàna àyúnn zyun ri bi, mpìrká wu rìghing big jì sig mà amir-à ni níng, bá fig jírwá, ");
INSERT INTO jib_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","má nann zu bi kàng mà amir-à ni ma yonkibá. Ama mpìrká rì sa sig bu-à bibai níng, bá dù nann zu kàng, jirà Shìdun aku wà kwonnbá. ");
INSERT INTO jib_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Má wà sar fig kwonn mì áwinmí ni bàna, sái bu-à Shìdun ma dinya mì rag ń sa, kwonn wà-à ma wà bidìm pár, í kwonn wà ǹsàn, jir kai bàna má wà fig kwonn-à pìkyinnmí ri zìm bàna, sái dái wà zyun-à àsàin-à swam bi sig mì níng ma zìm hing. ");
INSERT INTO jib_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Wà ma dang hing jír ma shinnmí, mpìrká má bir fig pìkyinn bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","I bu-à sa sàn sig mpìr zyun kim aku dang nì jír á shinnmí ni. N yì hing kó kai bu-à mpìr-à níng ma dang sig á shinnmí ni í àjai. ");
INSERT INTO jib_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ning swam yag mà byar Yohanna, ku dang hing jír á shinn gbìb àjai-à hi ni. ");
INSERT INTO jib_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bu-à Shìdun ma dang sig á shinnmí ni kab hing bu-à mpìr má dang. Ama mì ri dinya ning jír-à Yohanna dang sig á shinnmí ni, jirà aning bir pìkyinn ná á byar Shìdun ma aning dìg yonki. ");
INSERT INTO jib_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanna shi sig àràg í pitila-à big mònn bàg sig pyìr áni. Aràg barà mpìrká ri zìm abig myàng àyar pitila-à níng, í barà big ri zìm jir Yohanna áni. ");
INSERT INTO jib_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama shaida-à ǹ shi sig ma kàhi níng, kab sig bu-à Yohanna dang sig á shinnmí ni. Tamí swam bi sig mì àjirà ń sa bu mamaki, ma àjirà ń sa vinn rìg swàmwá. I bu-à mì ri sa tàma-à níng. Bu mamaki-à mì ri sa, kab gbam bu tàg Yahudawaká íni. ");
INSERT INTO jib_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tamí àsàin-à swam bi sig mì níng, ku dang hing jír á shinnmí ni tìnn. Ama ning myàng màg fig fig ku bàna, ning fig fig nài jírwá bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ning bir fig pìkyinn ná á jírwá ni bàna, í bu-à sa ning bir fig pìkyinn ma mpìr-à ku swam bi sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ning ri jangga jir Shìdun jir kai bàna ning ri kyab ná dìg yonki kinn kinn áni. Jir Shìdun ri dang jír á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama ning ngàng wà ná bi á byarmí ni, jirà aning dìg yonki kinn kinn-à hi. ");
INSERT INTO jib_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mì ri shi kir fig mpìrká abig swam yan mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N yì hing ning zìm fig Shìdun á pìkyinn ná ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bumí, ǹ bi sig á zìnn Tamí ni, ama ning ngàng mì. Mpìr zyun nìm ma bi sig ma zìnnwá, kàhi bó ning nìm má wib ku, hár má zìm ku tìnn. ");
INSERT INTO jib_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Barà ning ri zìm mpìrká abig yan ning, ama ning ri sa fig bu-à Shìdun má yan ning bàna níng, ná bir pìkyinn áshinn rà? ");
INSERT INTO jib_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kada aning kyab rag má wà ning kwonn á pyànn Tamí ni bàna. I mì bàna, í Musa zyun-à ning rì bir sig pìkyinn á byarwá ni níng, kwá wà ning kwonn á pyànn Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ning nìm ma wib hing Musa, ning nìm má wib mì tìnn, jir kai bàna Musa ba sig jír á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na wib fig bu-à Musa ba sig bàna, sáshinn ná wib jírmí rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","I byar-à Yesu zu yag mà Ayunn Galili, big ri bar rag, í Tibariya. ");
INSERT INTO jib_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","I byar-à mpìrká nìnànn nímá ri kan bàg yag ku, jir kai bàna big myàng sig bu mamaki, barà ku rì dàb gbam sig mpìr dorká níng. ");
INSERT INTO jib_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","I byar-à Yesu nai yag rìg mà shinnkwìnn-à ni, ku big yann sukàwá big. Big shi sig màhàn. ");
INSERT INTO jib_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayúnn ùwài bu Yahudawaká nyàan fòr, big ri bar rag í àyúnn Pìm Wam Zu. ");
INSERT INTO jib_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sái Yesu gbar dù nann zuwá, ku myàng yag bìr mpìrká ri bàg bi ku. I byar-à ku bar Filibus n bib wàníng rag, “Yá dìg brodi áni, jirà ayi wann ya mpìr káníng abig ji rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu bib Filibus jír-à níng, jirà aku màg màg fig wàníng. Ama ku yì rìghing bu-à kwá sa. ");
INSERT INTO jib_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","I byar-à Filibus dang rag, “Wàníng bó, sái ya sa hing swàm bài sònn awinyin ḿpyim, í wà yá dìg bài-à yá wann brodi, kó títi nímá, má ya mpìr káníng abig ji.” ");
INSERT INTO jib_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sái mpìr zyun áyau yann sukàwá big ni, zìnnwá í Andarawus, ku í wunzà Bitrus, ku dang rag, ");
INSERT INTO jib_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ai wùn zyun shi sig ma brodi áyag agir swana, ma jái pyànà. Ama bu káníng bidìm pár má màg fig mpìr káníng bàna.” ");
INSERT INTO jib_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sái Yesu dang rag, “Aning dinya mpìr káníng abig shi wann á jìnn ni.” (Byannká nìnànn nímá shi sig màhàn.) Wunùká shi wann sig áni níng, dubu swana. ");
INSERT INTO jib_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","I byar-à Yesu zìg brodi n sa Shìdun ísoko, n gàb finn ya mpìrká shi wann sig á jìnn ni níng, ku gàb finn ya jái-à àdòníng tìnn. Yesu ya mpìr káníng ùwài nímá àràg barà kyinnbá ri zìm. Bìr mpìr káníng ji brodi-à níng, hár finnbá zìr. ");
INSERT INTO jib_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Barà big ji kinn í kinn níng, sái Yesu dinya yann sukàwá big rag, abig zà kwonn rìg amig jáiká, ma brodi-à dà sig níng, kada aku shi bai átai bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Barà yann sukà Yesu big zà kwonn amig brodi káníng mònn gágsàg dwib agban pyànà, ma àkúnn brodi swana-à nìm níng. ");
INSERT INTO jib_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Barà mpìrká myàng bu mamaki-à Yesu sa sig ma brodi-à níng, í nànn-à hi, sái big dang rag, “Lalle, wàníng í wùn aswam Shìdun zyun-à má bi á dunyaru níng àjai.” ");
INSERT INTO jib_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Barà Yesu myàng mpìrká ri zìm abig wìr ku kùr, sái ku fim rìg big, n nai yag rìg mà shinnkwìnn-à ni áwinwá ni. ");
INSERT INTO jib_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Barà fi sìr àdòníng, sái yann sukàwá big í yag rìg-à mà nu zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Fi sìr rìghing, ama Yesu kàng bi fig ma á byarbá ni bàna. I byar-à yann sukàwá big yag kà á kòr-à ni, jirà abig yag mà jann, mà byinn-à mà Kafarnahum. ");
INSERT INTO jib_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","I byar-à hi, wàu shyù ri gbar wàni, afag zàpìr-à má ri gbar tìnn. ");
INSERT INTO jib_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Barà big shi sig á finn kòr-à ni, mi ri ya ma gbam, n yag rìghing byar pyunn ninonn nímá, má sa àràg mel sara, kó yina. Sái big myàng Yesu ri kyann á shinn zàpìr-à ni, ku ri bi á byarbá ni, sái zinn pànn rìg big. ");
INSERT INTO jib_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama Yesu dinya big rag, kada abig shàr zinn bàna, ái í ku. ");
INSERT INTO jib_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Barà Yesu dang zu rag í ku àdòníng, sái yann sukàwá big dang rag aku kà. I nànn-à hi, barà ku kà á kòr-à ni, sái kòr-à dù ma shinnwá mì yag fòr rìg-à mà byar-à big nìm ri zìm bá yag níng. ");
INSERT INTO jib_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na kyàr byar-à, mpìrká shi sig mà nu ayunn-à ni níng, big yì rìghing í kòr ńzyun nà shi síg nì màhàn. Big nà myàng yann sukà Yesu big nà yag rìghing mà jann. Ama Yesu nà yag fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kòrká káhi mà Tibariya bi n shi yàr sig mà byar-à Yesu nà ya mpìrká brodi-à ku swam yan sig zìnn Shìdun áni níng. ");
INSERT INTO jib_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Barà bìr mpìr káníng myàng fig Yesu bàna, big myàng fig yann sukàwá big bàna tìnn, sái big kà á kòrká á nu ayunn-à ni, n yag rìg mà Kafarnahum, big ri yàn kyann Yesu. ");
INSERT INTO jib_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","I byar-à hi, bìr mpìrká yag yàn dìg Yesu shi sig mà jann. Big bib ku rag, “Malam, à bi sig áyág ákaun rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu dinya big n rag, “N yì rìghing, ning ri yàn kyann mì í jirà ning ji sig brodi, finn ná mònn sig níng. Ama í jir bu mamaki-à ǹ sa sig ning myàng sig níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kada aning wa shwìn á jir buju-à má swàr rìg níng bàna. Aning yàn buju-à má swàr fig àswàr bàna. Buju-à níng í buju-à má ya yonki kinn kinn, í wà zyun-à Wùn Mpìr Jíkwìnn má ya ning níng. Shìdun Tayí ri zìm ku wàni, í bu-à sa wàníng kyag sig àràg í yir á dìrwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","I byar-à big bib ku rag, “Yá sa í swai swàm kai, zyun-à Shìdun má zìm rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","I byar-à Yesu dinya big rag, “Wàníng í bu-à Shìdun ri zìm aning sa, ku ri zìm aning bir pìkyinn ná á byar mpìr-à ku swam bi sig.” ");
INSERT INTO jib_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","I wà big bib ku rag, “Wá sa í bu mamaki kai jirà ayi bir pìkyinn á byarwú ni rà? Wá sa í kai rà? ");
INSERT INTO jib_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yàkúká buyí big rì ji buju zyun-à big ri bar rag í manna mà awúnn-à ni, àràg barà big ba sig áni á jir Shìdun, ‘Ku dwim ya bi big brodi mà wai abig ji.’ ” ");
INSERT INTO jib_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu dinya big rag, “I jir àjai, Musa í mpìr-à ya sig yàkúná big brodi-à bi sig mà wai níng bàna, ama brodi-à mà wai wann bi síg mà byar Tamí ni. ");
INSERT INTO jib_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ai brodi Shìdun í mpìr-à tìg wann bi sig mà wai níng, í zyun-à má ya mpìrká á jànn-à ni yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","I byar-à mpìr káníng dang rag, “Shinn Luyí, á ya kyann yi brodi-à níng kó ákaun.” ");
INSERT INTO jib_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","I byar-à Yesu dang rag, “Mì í brodi-à ri ya yonki, mpìr-à ma bi hing á byarmí ni, amor má gban fig rag ku bàna. Mpìr-à ma bir hing pìkyinn á byarmí ni, ajor má gban fig rag ku bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","N nìm dinya ning rag, ning myàng rìghing mì, ama ning bir fig pìkyinn á byarmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mpìr-à Tamí ma ya hing mì, mpìr-à hi má bi á byarmí ni. Mpìr-à ma bi hing á byarmí ni, má kan fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bu-à zìg bi sig mì mà wai níng, í jirà ń sa swàm shinnmí bàna, ama í jirà ń sa swàm àsàin-à swam bi sig mì níng. ");
INSERT INTO jib_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jír-à ku dinya sig mì níng, í wàníng: Ayau mpìrká ku ya sig mì níng, ń fim kó mpìr ńzyun bàna, ama ń gbar dù nann zu kàng mpìrká níng hi bidìm pár àyúnn-à dunyaru má vinn áni. ");
INSERT INTO jib_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wàníng í bu-à Tamí ri zìm. Mpìrká ma myàng hing wùn-à níng, ma wib hing, bá dìg yonki kinn kinn. Má gbar dù nann kàng big àyúnn-à dunyaru má vinn áni.” ");
INSERT INTO jib_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","I byar-à Yahudawaká zìnn swau ku, jirà ku dang rag, ku í brodi-à wann bi sig mà wai. ");
INSERT INTO jib_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Big dang rag, “Ama ku í Yesu, yi yì rìghing nàwá ma tawá, ku í wùn Yusufu, sáshinn kwá dang rag, ku wann bi síg mà wai rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","I byar-à Yesu dinya big n rag, “Kada aning zìnn swau mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tamí swam bi síg mì nì. Mpìr má bi sar fig á byarmí ni bàna, sái zyun-à Tamí ma dang rag aku bi. Mpìrká má bi á byarmí ni níng, má dab wìm kàng rìg big àyúnn-à dunyaru má vinn áni. ");
INSERT INTO jib_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mpìrká ri dang kyann jir Shìdun ba sìnn sig á tarkada rag, ‘Shìdun má tàg mpìrká bidìm pár.’ Mpìrká ma fig hing jir Tamí, jirà abig yì swàb kà jírwá, bá bi á byarmí ni. ");
INSERT INTO jib_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mpìr myàng yag fig Shìdun kó kàun ńzyun bàna. Sái mpìr-à bi sig mà byarwá ni, ku í àsàin-à myàng sig Ta-à. ");
INSERT INTO jib_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","N dinya ning jír-à níng, í jír àjai. Mpìr-à ma bir hing pìkyinn á byarmí ni, ku shi sig ma yonki-à kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mì í brodi-à ri ya yonki. ");
INSERT INTO jib_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yàku yàkúná big, big ji brodi manna mà awúnn-à ni, ama big wu rìghing. ");
INSERT INTO jib_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Brodi zyun-à rì wann bi sig mà wai níng, í brodi-à mpìr ma ji hing, kwá wu fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mì í brodi-à ri ya yonki, zyun-à wann bi sig mà wai. Kó ni ma ji hing brodi-à níng, kwá dìg yonki-à má vinn fig ávinn bàna. Brodi-à má ya ning níng, í wi dìrmí, jirà kó ni á jànn-à ni aku dìg yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sái Yahudawaká gbam nài gbam bar dìrbá n dang rag, “Sáshinn mpìr-à níng má dang rag, kwá ya yi wi dìrwá yá zwam rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu dinya big rag, “Mì ri dinya ning àjai wà na zwam fig wi dìr Wùn Mpìr Jíkwìnn bàna, na wa fig àsàwá bàna tìnn, ná dìg fig yonki bàna sám. ");
INSERT INTO jib_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mpìr-à ma ri zwam wi dìrmí, kwa ri wa àsàmí tìnn, ku shi sig ma yonki-à má vinn fig ávinn bàna. Mì bó, má dab wìm kàng ku àyúnn-à dunyaru má vinn áni. ");
INSERT INTO jib_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Dìrmí í buju àjai, àsàmí í bu-à bá wa àjai. ");
INSERT INTO jib_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wà mpìr-à ma zwam hing wi dìrmí, ma wa hing àsàmí tìnn, mpìr-à níng, yi ma ku shi kwonn sig í zyun, ǹ shi sig á dìrwá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamí dang rag, ń bi. Tamí shi sig ma yonki, mì má mì ri dìg yonki á byar Tamí ni. Mpìr-à ma zwam hing wimí, ku má kwá dìg yonki á byarmí tìnn. ");
INSERT INTO jib_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Brodi-à níng, í brodi-à bi sig mà wai. I swai brodi-à yàkúná big rì ji sig, ama n wu rìghing níng, bàna. Mpìr-à ma ji hing brodi-à níng, kwá dìg yonki kinn kinn.” ");
INSERT INTO jib_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sai-à Yesu ri dang bu káníng, í sai-à ku ri tàg mpìrká bu mà tonn bìr kwonn-à ni, mà Kafarnahum. ");
INSERT INTO jib_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Barà mpìrká ri kan bàg ku níng, fig àdòníng, káhi áyaubá ni dang rag, “Kai! Jír-à níng tù hing, mpìr-à má fig byann yìrwá í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Barà mpìrká ri bònn dang jír á shinn bu-à Yesu ri tàg níng, Yesu yì rìghing wà big ri bònn dang jír áshinn bu-à ku dang sig níng ni. I byar-à Yesu dang rag, “I jir shinn jír-à níng, í bu-à sa ning ri zìm aning fim mì níng rà? ");
INSERT INTO jib_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wà na myàng Wùn Mpìr Jíkwìnn ma ri nann yag mà byar-à ku rì shi sig, tò kàhi ná sáshinn rà? ");
INSERT INTO jib_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awun í zyun-à má ya yonki, gbam mpìr má sa sar fig bu zyun bàna. Jír-à ǹ dinya sig ning níng, í jír-à má ya ning Awun wà zyun-à má ya ning yonki. ");
INSERT INTO jib_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hár tàma-à níng, áyauná ni káhi bir fig pìkyinn á byarmí ni bàna.” (Tun daka á ninonn Yesu yì rìghing mpìrká zyun-à má bir fig pìkyinn á byarwá ni bàna. Ku yì rìghing mpìr-à má ya kà ku á vù mpìrká zyun-à má gban ku níng tìnn.) ");
INSERT INTO jib_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu dang rag, “I bu-à sa, mì ri dinya ning rag, mpìr má bi sar fig á byarmí ni bàna, sái mpìr-à Tamí ma zìm hing aku bi.” ");
INSERT INTO jib_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Asai-à níng hi, yann sukàwá big nìnànn nímá kàng rìg ásim. Big zìm fig rag wà abig bàg ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","I wà Yesu bib yann sukàwá big dwib agban pyànà káníng rag, “Ning má, ning ri zìm aning kàng yag tìnn rà?” ");
INSERT INTO jib_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","I wà Siman Bitrus dang rag, “Shinn Luyí, yá kàng yag mà byar ni rà? Ai à shi sig ma jír-à má ya yi yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tàma-à níng yi yì hing n bir hing pìkyinnyí rag, wù í wùn kyìkyàr bu Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","I byar-à Yesu dang rag, “N shig zu sig ning mpìr dwib agban pyànà bàna rà? Ama zyun áyauná ni í mpìr Shaitan.” ");
INSERT INTO jib_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ku ri dang jír á shinn Yahuda wùn Siman Iskariyoti, í zyun-à áyau yann sukà dwib agban pyànàká buwá ni, wàníng í àsàin-à má zìg ku má ya kà ku á vù mpìrká ni, jirà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","I byar-à Yesu ri kyann á jànn Galili, ku zu fig gbìb-à á jànn Yahudiya bàna, jir kai bàna Yahudawaká ri zìm abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Barà àyúnn-à bá sa buki wà bá dab apig-à nyàan fòr, ");
INSERT INTO jib_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","í byar-à wunzàwá big dinya ku rag, “A fim byar-à níng, á yag mà jànn Yahudiya, jirà yann sukàwú big abig myàng bu mamaki-à wá sa. ");
INSERT INTO jib_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wà mpìr ma ri zìm mpìrká abig yì ku, kwá tàm fig swàmwá bàna. Kwá tìya mpìrká á jànn-à ni, abig myàng buká ku ri sa. To, barà wù ri sa bu mamaki káníng, sàn sig mpìrká abig yì.” ");
INSERT INTO jib_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wunzàwá big má, big bir fig pìkyinnbá ma jírwá bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","I wà ku dinya káníng rag, “Ayúnnmí màg fig ma bàna, ama bigná kam, aning yag. ");
INSERT INTO jib_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bigná dunyaru ngàng fig ning bàna, ama bigmí dunyaru ngàng mì, jirà mì ri dinya mpìrká rag big ri sa bu-à bibai níng. ");
INSERT INTO jib_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aning yag mà byar-à big ri ji buju àyúnn wùwài-à níng, má yag fig ma màhàn bàna, jir kai bàna àyúnnmí màg fig ma bàna.” ");
INSERT INTO jib_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Barà ku dang jír-à níng, ku yag fig byar zyun bàna, n shi sig buwá á Galili. ");
INSERT INTO jib_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Barà wunzàwá big yag nonn fig bàna, sái ku má ku í yag rìg-à mà byar-à big ri ji buju àyúnn wùwài-à níng tìnn. Wà ku yag níng, ku bònn yag síg, ábònn yagi ku tàg fig shinnwá áyau bìr mpìrká ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sái Yahudawaká ri yàn kyann ku áyau bìr mpìrká ni, mi ri bib rag, “Ku shi sig áni rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I byar-à bìr mpìrká kà hing jír shàm dang á shinn Yesu ni. Káhi dang rag, “Yesu í mpìr-à sìsàn.” Káhi big dang rag, “A á, ku í mpìr-à ǹsàn bàna, jir kai bàna ku ri tonn gban mpìrká.” ");
INSERT INTO jib_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kó mpìr ńzyun dang sar fig jírwá á fir-à ni bàna, jir kai bàna big ri shàr zinn Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ayau buki-à big ri ji níng, sái Yesu kà yag mà lu Shìdun ni, mi ri tàg mpìrká màhàn. ");
INSERT INTO jib_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","I byar-à Yahudawaká sa mamaki á shinn Yesu ni n dang rag, “Kai! Mpìr-à níng yì hing bu wàni. Sáshinn mpìr-à níng kà fig makaranta bàna, mi ri tàg bu ǹsàn nímá àdòníng rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I byar-à Yesu dinya big rag, “Ai bu-à mì ri tàg níng, í bu tàgmí bàna, í bu àsàin-à swam bi sig mì níng. ");
INSERT INTO jib_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mpìr-à ma ri zìm aku sa bu-à Shìdun ri zìm, kwá yì kó bu tàg-à níng í bu Shìdun rà, kó í bu tàg shinn dìrmí rà. ");
INSERT INTO jib_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mpìr-à ma ri dang í jír á shinnwá ni, ku ri yan í shinnwá. Ama mpìr ma yan wà zyun-à swam bi sig ku, ku í mpìr gwangga ku tonn gban fig mpìr bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa ba ya sig ning doka, kó àdòníng bàna rà? Ama áyauná ni kó mpìr ńzyun ri wib fig doka káníng bàna. Bu-à sa ning ri zìm aning gban mì í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","I byar-à hi, bìr mpìrká dang jír ma gbam n rag, “Wù í mpìr wàu, mpìr-à ri zìm kwá gban wù áyauyí ni í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu dang rag, “N sa ya ning bu mamaki í kàun ńzyun, ama ning ri sa mamaki. ");
INSERT INTO jib_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa ba sìnn sig á shinn jur kyag, ama í ku ku kyag jag fíg nì bàna. Yàkúká buná rì kyag jag síg nì. To, tàma-à níng, ning ri kyag rag yanká buná big kó àyúnn Asabar. ");
INSERT INTO jib_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wà ba kyag hing wùnshái jur àyúnn Asabar, í jirà abig wib doka Musa, sáshinn ning ri nànn àgùnn wà ma dàb gbam mpìr àyúnn Asabar rà? ");
INSERT INTO jib_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kada aning wà kwonn á gbìb ǹsáng bàna, ama aning wà kwonn á gbìb àjai.” ");
INSERT INTO jib_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mpìrká káhi mà Urushalima bib rag, “Wàníng í mpìr-à big ri zìm abig gban níng bàna rà? ");
INSERT INTO jib_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aning myàng, ku ri dang jír áyau bìr mpìrká ni, ama big sa fig ku bu bàna. Wàníng àgbamká yì hing wà ku í Almasihu rà? ");
INSERT INTO jib_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yi yì hing byar-à mpìr-à níng bi sig, ama Almasihu ma bi hing, mpìrká má yì fig byar-à ku bi sig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Barà Yesu dang jírwá mà lu Shìdun ni, ku dang ma nài gbam, ku dang rag, “Ning yì hing mì, ning yì hing byar-à ǹ bi sig. N bi fig ma gbammí bàna, wà zyun-à swam bi sig mì níng, ku í mpìr gwangga. Ning yì fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ama ǹ yì hing ku, jir kai bàna í ku, ku swam bi síg mì nì, ǹ bi síg mà byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Barà ku dang àdòníng í nànn-à hi, mpìrká ri zìm abig pànn ku, ama big pànn sar fig ku vù á dìr bàna, jir kai bàna àyúnnwá màg fig ma bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mpìrká nìnànn nímá bir pìkyinn á dìrwá ni. Big dang rag, “Ayúnn-à Almasihu má bi áni, kwá sa bu mamaki-à má kab wà mpìr-à níng ri sa níng rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Barà Farisawaká fig bìr mpìrká ri dang jír á shinn Yesu ni àdòníng, sái àgbam mpìrká ri twìb swànn bu á pyànn Shìdun, ma àgbam Farisawaká swam yag yann sukà big abig yag pànn bi ku. ");
INSERT INTO jib_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sái Yesu dang rag, “Má shi swàb kà ma áni títi nímá ma ning ḿpyim, í wà má kàng yag íni mà byar mpìr-à swam bi sig mì níng. ");
INSERT INTO jib_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ná yàn kyann mì, ama ná dìg fig mì bàna. Byar-à má shi, ná yag sar fig màhàn bàna.” ");
INSERT INTO jib_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sái Yahudawaká bib bar dìrbá rag, “Mpìr-à níng má yag áni rà? Byar-à ku dang rag, yá dìg fig ku bàna níng, kó kwá yag mà byar-à Yahudawaká yam fim sig awín awín á dunyaru níng, jirà aku yag tàg káníng bu màhàn rà? ");
INSERT INTO jib_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ku dang rag, yá yàn kyann ku, ama yá myàng fig ku bàna, yá yag sar fig mà byar-à kwá yag bàna. Wàníng bó, yìr jír-à níng í kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ayúnn-à buki má vinn áni, í àyúnn wùwài, sái Yesu sar dù nann n dang jír ma gbam n rag, “Mpìr-à ma ri fig ajor zàpìr bidìm pár, aku bi á byarmí ni aku wa. ");
INSERT INTO jib_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mpìr-à ma bir hing pìkyinnwá á byarmí ni, àràg barà jir Shìdun rì dang sig níng, daka tàma-à níng, abinn zàpìr-à ri binn gbìb zu sàu sàu má ya yonki níng, má binn gbìb zu á pìkyinnwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ri dang jír á shinn Awun Kyìkyàr Shìdun, wà zyun-à mpìr ma bir hing pìkyinnwá á byarwá ni kwá dìg. Ama sai-à hi, Shìdun ya fig ma Awunwá bàna, jir kai bàna Yesu wu fig n dù nann zu kàng fig ma ma yonki bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Barà bìr mpìrká fig jírwá àdòníng, sái mpìrká káhi dang rag, “Mpìr-à níng í mpìr adang jir Shìdun àjai.” ");
INSERT INTO jib_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sái mpìrká káhi dang rag, “Ai wàníng í Almasihu.” Ama mpìrká káhi dang rag, “Asái Almasihu má zu bi á swai mpìrká á Galili rà? ");
INSERT INTO jib_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ama jir Shìdun dang rag, Almasihu má shi í swai Dawuda. Bá mà ku mà Baitalami, á kauye byar-à Dawuda rì shi sig.” ");
INSERT INTO jib_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","I byar-à hi, mpìrká gàb fim á jir shinn Yesu. ");
INSERT INTO jib_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mpìrká káhi ri zìm abig pànn ku, ama big pànn yì sar fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mpìrká zyun-à big swam yag sig rag abig yag pànn bi Yesu níng, big kàng bi vù átai. Sái Farisawaká ma mpìrká ri twìb swànn bu á pyànn Shìdun ni, bib big rag, “Bu-à sa ning pànn zìg bi fig ku bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","I byar-à hi big dang rag, ai big taba fig fig jír zyun àràg barà mpìr-à níng ri dang níng bàna sám. ");
INSERT INTO jib_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sái Farisawaká dang rag, “Asai ku dang lir ji rìghing ning tìnn rà? ");
INSERT INTO jib_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ning taba fig hing áyau àgbamká ma Farisawaká taba wib hing ku rà? ");
INSERT INTO jib_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama bìr mpìr káníng yì fig bu-à Musa ba sig bàna níng, Shìdun màg gban hing big.” ");
INSERT INTO jib_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimu zyun-à rì yag sig á fi mà byarwá ni níng, ku shi sig áyau Farisawa káníng ni tìnn. Ku dinya káníng rag, ");
INSERT INTO jib_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mpìr-à ma ri wà kwonn, kwá fig bu-à mpìr-à big ri wà ku kwonn-à níng ri dang, jirà abig yì bu-à ku sa sig.” ");
INSERT INTO jib_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I byar-à hi, big bib ku rag, “Wù má, wù í mpìr-à á Galili rà? A myàng byann ǹsàn nímá, ái walai mpìr-à ri dang kyann jir Shìdun zyun-à má zu bi á Galili.”  ");
INSERT INTO jib_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","I byar-à hi kó ni í yag rìg-à mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ama Yesu yag buwá mà Wùn Mwir Zaitun. ");
INSERT INTO jib_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Byar kyàr í pyimbyau, ku kàng yag mà lu Shìdun. Mpìrká bidìm pár kwonn yag rìg mà byarwá ni. A byar-à níng hi, ku shi wann mi ri tàg big bu. ");
INSERT INTO jib_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Malamká ma Farisawaká zìg bi uwà zyun-à big pànn sig ku ásai-à ku ri sa àyái, n sìnn kà ku, ku sar áyaubá ni. ");
INSERT INTO jib_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Big dinya Yesu rag, “Malam, á myàng uwà-à níng yi pànn ku, ku ri sa àyái. ");
INSERT INTO jib_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A doka Musa ku ba sig rag, ‘Uwà-à ba pànn hing ku ma àyái sa, abig ta ku abàn, sái kwa wu hing.’ Buwú wá dang kai á shinnwá ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Big dang sig jír-à níng àjirà abig màg màg fig Yesu, ma abig swau ku. Ama ku bìnn kir wann mi ri ba bu á jìnn ni ma pwai vùwá. ");
INSERT INTO jib_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Barà big sar sig mi ri bib ku jír-à níng, ku sar dù nann á wai n dinya big rag, “Ayauná ni, mpìr-à ma taba sa fig bu bibai bàna, aku zìg abàn ma aku ta jag uwà-à níng.” ");
INSERT INTO jib_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ku bìnn kir wann kàng, mi ri ba buwá á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Barà big fig àdòníng, big dù zyun zyun mi í yag rìg-à. Agbam-à yag jag í ni, n fim Yesu ku áwinwá ni ma uwà-à níng, jir kai bàna big yì hing big ri sa bu-à bibai. ");
INSERT INTO jib_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ku dù nann zu n bib uwà-à níng rag, “Ma mpìr káníng áni rà? Kó mpìr ńzyun pànn fig wù ma jír bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uwà-à níng zìm kàng n dinya ku rag, “Kó mpìr ńzyun bàna.” A byar-à hi, Yesu dinya ku rag, “Mì má ǹ pànn fig wù ma jír bàna, á yag kyonnwú, ama kada á sa jakàng bu pyìr bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu dinya jakàng mpìrká rag, “N shi síg nì àyar bu dunyaru. Mpìr-à ma bàg hing mì, kwá dìg àyar zyun-à má tìya ku yonki kinn kinn, kwá kyann fig rag á zufi-à ni bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisawaká dinya ku rag, “Wù ri kà nu shinnwú. Bu-à à dang sig níng, í àjai bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu dang rag, “I nímá bàna, kó barà ǹ kà hing nu shinnmí níng, bu-à ma dang hing í àjai, jir kai bàna ǹ yì hing byar-à ǹ bi sig ma byar-à mì ri yag. Ning yì fig byar-à ǹ bi sig bàna ma byar-à mì ri yag bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Bigná, ning ri wà kwonn ma mpìr, ama bigmí, mì ri wà fig kwonn ma mpìr bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kó ma ri wà kwonn má, mì ri dang í àjai, jir kai bàna mì áwinmí ni bàna, ama mì ma Shìdun zyun-à swam bi sig mì. ");
INSERT INTO jib_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Big ba sig áyau dokaná ni n rag, ‘Mpìr pyànà ma dang hing jír ńzyun, jír-à níng í àjai.’ ");
INSERT INTO jib_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mì í zyun-à ri dang jír á shinnmí ni. Tamí zyun-à swam bi sig mì níng, jírwá í ńzyun ma bumí tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Big bib ku rag, “Ma Tawú á ni rà?” Yesu dinya big n rag, “Ning yì fig mì bàna, ning yì fig Tamí bàna. Wà ning nìm ma yì hing mì, ning nìm yì hing Tamí zyun-à swam bi sig mì níng tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu dang jír káníng mà lu Shìdun ni, á byar-à big ri sìnn kwonn bàiká. A sai-à níng hi, kó mpìr ńzyun pànn fig ku bàna, jir kai bàna àyúnnwá màg fig ma bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu dinya big rag, “Má yag jànn rìg, ná yàn kyann mì, ama ná dìg fig mì bàna. Ná wu rìg á bu pyìrná ni. Byar-à má yag, ná yag sar fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudawaká dang rag, “Kwá gban rìg shinnwá rà? Jir kai bàna ku dang rag, byar-à kwá yag buyí yá yag sar fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu dinya big rag, “Ning í bu á jìnn ni, ama bigmí ǹ bi síg mà wai. Ning í bu dunyaru-à níng, ama mì í bu dunyaru bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","I bu-à sa ǹ dinya ning rag, ná wu á jir bu pyìrná ni. Wà na bir fig pìkyinn rag, mì í ku bàna, ná wu á bu pyìrná ni.” ");
INSERT INTO jib_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Big bib ku rag, “Wù í ni rà?” Yesu dinya big rag, “Wàníng í bu-à ǹ dinya jag sig ning. ");
INSERT INTO jib_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N shi sig ma jírká nìnànn nímá wà má dinya ning, ma buká nìnànn nímá zyun-à má wà ning kwonn á dò jir kàhi, ama zyun-à swam bi sig mì níng, ku í mpìr gwangga. Buká ǹ fig sig á byarwá ni níng, í buká mì ri dinya mpìrká á dunyaru.” ");
INSERT INTO jib_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Big yì fig wà Yesu ri dinya big jír á shinn Tawá ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu dinya big rag, “A sai-à ná gbar dù nann Wùn Mpìr Jíkwìnn mà atàm bín-à ni, á byar-à níng hi ná yì rag mì í ku, ná yì rag mì ri sa fíg bu ma shinnmí bàna, mì ri dáng bu káníng àràg barà Tamí tàg sig mì. ");
INSERT INTO jib_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ku zyun-à ku swam bi sig mì níng, ku shi kwonn sig ma mì í zyun. Ku fim fig mì awínmí ni bàna, jir kai bàna mì ri sa kyann bu-à ku ri zìm.” ");
INSERT INTO jib_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mpìrká nìnànn nímá bir hing pìkyinnbá á byar Yesu, sai-à ku dang sig jír-à níng. ");
INSERT INTO jib_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu dinya mpìr Yahudawaká, ká bir sig pìkyinnbá á byarwá ni n rag, “Wà na wib hing jírmí, ning í yann sukàká bumí àjai. ");
INSERT INTO jib_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ná yì jír àjai, jír àjai má finn tafinn ning tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Big dinya ku rag, “Yi í yann ada Ibrahim, í barà big màm sig yi, yi shi fig fàu mpìr zyun bàna. Bu-à sa à dang rag bá finn tafinn yi níng, bá finn tafinn yi áshinn rà?” ");
INSERT INTO jib_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu dinya kàng big rag, “Mì ri dinya ning àjai, mpìr-à ma sa bu pyìr, ku í fàu bu pyìr. ");
INSERT INTO jib_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Fàu ri shi kinn fig mà lu bàna, ama í wùn á lu-à hi ni ri shi nì kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wà Wùn Shìdun ma finn tafinn hing ning, á byar-à níng hi, big finn tafinn rìghing ning àjai. ");
INSERT INTO jib_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N yì hing ning í yann ada Ibrahim, ama ning ri zìm aning gban mì, jir kai bàna ning ri zìm fig jírmí bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mì ri dáng bu-à Tamí tìya sig mì, ama bigná aning sa bu-à taná tìya sig ning.” ");
INSERT INTO jib_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A byar-à níng hi, big dinya ku rag, “Tayí í Ibrahim.” Yesu dinya big rag, “Wà ning nìm ma í yann Ibrahim, ning nìm má sa bu-à ku rìi sa. ");
INSERT INTO jib_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mì ri dinya ning jír àjai zyun-à ǹ fig sig á byar Shìdun, ama ning ri zìm aning gban mì. Ai Ibrahim rì sa fig àdòníng bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ning ri sa bu-à taná ri sa.” Big dinya Yesu rag, “Yi í yann sa bàna. Shìdun í Tayí kwá áwinwá ni, í zyun-à yi shi sig ma kàhi.” ");
INSERT INTO jib_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu dinya big rag, “Shìdun nìm ma í Taná, ning nìm má zìm mì, jir kai bàna ǹ bi sig mà byar Shìdun ni. Hár tàma-à níng mì áyag. N bi fíg ma shinn dìrmí bàna, ku swam bi síg mì nì. ");
INSERT INTO jib_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bu-à sa ning fig yì fig jírmí bàna níng, í jir kai rà? Kó í jirà ning zìm fig aning fig bàna rà? ");
INSERT INTO jib_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ning í yann Shaitan, ning ri zìm aning sa bu-à bibaiká ku ri zìm. Ku í mpìr agban ki daka á ninonn, ku ri dang fig jir àjai bàna, jir kai bàna ku í mpìr gwangga bàna. Sai-à kwa gim hing ǹsáng, ku ri sa bu-à ku ri sa kyann, jir kai bàna ku í ta mpìrká ri gim ǹsáng. ");
INSERT INTO jib_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mì ri dinya ning àjai, í bu-à sa ning bir fig pìkyinn ná áni bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ayauná ni, í ni pànn síg mì nì ma bu pyìr rà? Wà ma ri dinya ning jír àjai, bu-à sa ning bir fig pìkyinn ná áni bàna í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mpìr-à ma í bu Shìdun, ku ri fig jir Shìdun. Bu-à sa ning fig fig bàna níng, í jirà ning í bu Shìdun bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudawaká dinya Yesu rag, “Jír-à yi dang sig rag wù í mpìr-à á jànn Samariya, à shi sig ma wàu á dìrwú ni níng, í àjai.” ");
INSERT INTO jib_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu dang rag, “N bàna ma wàu, mì ri wib Tamí, ama ning ri wib fig mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mì ri yàn fig àgbam ma shinnmí bàna. Ama mpìr zyun shi sig áni ku í àsàin-à ri sìnn mì ń shi àgbam. Ku í mpìr-à ri wà kwonn ábibir á dò shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mì ri dinya ning àjai, mpìr-à ma bàg jírmí, kwá wu fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","I byar-à hi, Yahudawaká dang rag, “Tàma-à níng yi yì hing wà à shi sig ma wàu! Ibrahim wu rìghing, mpìrká rìi dang kyann jir Shìdun big wu rìghing tìnn, ama bidìm pár wù ri dang rag, mpìr-à ma wib hing wù, kwá wu fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A kab hing tayí Ibrahim ma mpìrká rìi dang jir Shìdun níng rà? Big wu rìghing bidìm pár. Wù ri zìg kàng shinnwú àràg í kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu zìm n dang rag, “Kó má gbar dù shinnmí má, í bu zyun bàna. Tamí í àsàin-à ri gbar dù mì, zyun-à ning ri dang rag í Shìdun ná. ");
INSERT INTO jib_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ning yì fig ku bàna, ama bigmí ǹ yì hing ku. Wà ǹ nìm ma dang rag, ǹ yì fig ku bàna, ǹ nìm má shi mpìr ǹsáng àràg ning. N yì hing ku, hár mì ri wib jírwá. ");
INSERT INTO jib_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taná Ibrahim fig àjwár sai-à Shìdun dinya ku rag, kwá myàng àyúnn-à má bi áni. Ku myàng hing, ku fig hing àjwár.” ");
INSERT INTO jib_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Big bib ku n rag, “A fòr fig ji dìpyànà agban dwib bàna, ama à dang rag, à myàng hing Ibrahim rà?” ");
INSERT INTO jib_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu dang rag, “Mì ri dinya ning àjai, sai-à big mà fig ma Ibrahim bàna, ǹ shi sig áni.” ");
INSERT INTO jib_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A byar-à hi big zìg abàn jirà abig ta gban ku ma kàhi. Sái ku dù mà lu Shìdun ni mì bònn yag rìgwá. ");
INSERT INTO jib_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Barà Yesu ri wam zu àdòníng, sai ku myàng mpìr zyun big mà sig ku zu bàna, ku í àfau. ");
INSERT INTO jib_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yann sukàwá big bib ku n rag, “Malam, í bu pyìr ni sa síg nì, wà big mà sig ku í àfau níng rà? I bu pyìrwá rà, kó í bu pyìr tawá ma nàwá rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu dinya big n rag, “Afau-à níng í jir bu pyìrwá kó bu tawá ma nàwá bàna. Ku í àfau, jirà Shìdun aku tìya mpìrká gbamwá. ");
INSERT INTO jib_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ayi sa swàm-à ku swam bi sig mì ń sa níng, sai-à àyúnn-à dà sig ma áni, jir kai bàna zufi ri bi wà mpìr má sa sar fig rag swàm bàna. ");
INSERT INTO jib_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sai-à mì ri shi á dunyaru, mì í àyar bu dunyaru.” ");
INSERT INTO jib_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sai-à ku dang àdòníng, ku tu wìr sháng á jìnn ni, ku vù jànn àtag ma sháng-à níng, n pàb wàníng á zu-à ni. ");
INSERT INTO jib_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A byar-à hi, ku dinya wàníng rag, “A yag tu zuwú mà shar zàpìr-à ni bu Siluwam.” (Yìr zìnn-à níng í aswam). A byar-à hi, mpìr-à níng yag, n tu zuwá, n kàng bi ku ri myàng. ");
INSERT INTO jib_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ayor luwá big ma mpìrká ká rì myàng sig ku sai-à ku rìi vig kyann bu níng, myàng ku àdòníng, n bib rag, “Wàníng í mpìr zyun-à rìi shi vig kyann bu níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mpìrká káhi dang rag, “I ku.” Káhi dang rag, “I ku bàna, zu rìg dìr.” A byar-à hi, mpìr-à níng dang rag, “I mì!” ");
INSERT INTO jib_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Big bib ku rag, “A sa síg ashinn mi ri myàng tàma-à níng rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ku dinya big rag, “I mpìr-à big ri bar Yesu níng vù jànn àtag n pàb á zumí ni, n dang rag ń yag mà zàpìr Siluwam ń tu zumí. A byar-à níng hi, barà ǹ yag tu zumí àdòníng, zumí í pù finn rìg-à.” ");
INSERT INTO jib_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Big bib ku rag, wàníng áni rà? Ku dang rag, “N yì fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Big zìg bi mpìr àfau-à níng mà byar Farisawaká ni. ");
INSERT INTO jib_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","I àyúnn Asabar wà Yesu vù jànn àtag n pù zu mpìr-à níng ma kàhi. ");
INSERT INTO jib_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisawaká bib jakàng mpìr-à níng barà ku sa hár mi ri myàng tàma-à níng. Ku dinya big rag, “Wunù-à níng zìg jànn àtag, n pàb á zumí ni, ǹ yag tu zumí, í wà tàma-à níng mì ri myàng rag.” ");
INSERT INTO jib_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisawaká káhi dang rag, “Mpìr-à níng í mpìr Shìdun bàna, jir kai bàna ku wib fig àyúnn Asabar bàna.” Ama káhi dang rag, “Sáshinn mpìr-à ma í mpìr bu pyìr má sa bu àdòníng rà?” Ayaubá ni, pìkyinnbá í gàb finn rìg-à. ");
INSERT INTO jib_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisawaká bib àfau-à níng n rag, “Barà ku pù finn rìghing zuwú níng, wá dang í kai á shinnwá ni rà?” Ku zìm n rag, “Wàníng í wùn aswam Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yahudawaká zìm fig jír-à big ri dang rag, “Mpìr-à níng rì í àfau, ama tàma-à níng ku ri myàng rag ma zuwá níng” bàna. Sai big bar tawá ma nàwá, ");
INSERT INTO jib_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","n bib big rag, “Wàníng í wùn ná zyun-à ning dang rag ning mà sig ku í àfau níng bàna rà? Ma sáshinn tàma-à níng ku ri myàng rag ma zuwá rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tawá ma nàwá dang rag, “Yi yì hing wàníng í wùnyí, yi yì hing wà yi mà sig ku í àfau, ");
INSERT INTO jib_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ama tàma-à níng barà ku sa mi ri myàng níng, yi yì fig bàna, yi yì fig mpìr-à pù finn sig ku zuwá níng bàna tìnn. Ku wài gbam rìghing, aning bib ku aku dang ma nuwá.” ");
INSERT INTO jib_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Big dang àdòníng, jir kai bàna big ri shàr zinn Yahudawaká. Yahudawaká kwonn sig nubá rag, “Mpìr-à ma zìm hing rag Yesu í Almasihu, bá kan zu rìg ku á tonn bìr kwonn-à ni.” ");
INSERT INTO jib_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","I bu-à sa nàwá ma tawá dang rag, “Ku wài gbam rìghing, aning bib ku.” ");
INSERT INTO jib_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A byar-à níng hi, big bar jakàng àfau-à níng, n dinya ku rag, “A dang jír àjai á pyànn Shìdun, jir kai bàna yi yì hing mpìr-à dàb gbam sig wù níng, í mpìr bu pyìr.” ");
INSERT INTO jib_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Afau-à níng dinya kàng big n rag, “Kó ku í mpìr bu pyìr, kó bàna rà, ǹ yì fig bàna. Bu-à ǹ yì sig bàna, wàrì níng mì ri myàng fig bàna, ama tàma-à níng, mì ri myàng kyàr.” ");
INSERT INTO jib_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Big bib ku rag, “Ku sa sig wù í kai rà? Ku pù sig zuwú hi áshinn rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ku dinya big rag, “N nìm dinya hing ning, ning fig fig bàna. Bu-à sa ning ri zìm aning fig jakàng í jir kai rà? Kó ning ri zìm aning shi yann sukàwá tìnn rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Big swau ku n rag, “A shi síg nì wùn sukàwá, ama bigyí, yi í yann sukà Musa. ");
INSERT INTO jib_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yi yì hing Shìdun dang hing jír ma Musa, ama mpìr-à níng, yi yì fig byar-à ku bi sig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Afau-à níng dang rag, “Jír-à níng í bu mamaki wà barà ning yì fig byar-à ku bi sig bàna, ama ku dàb gbam hing mì! ");
INSERT INTO jib_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yi yì hing Shìdun ri fig fig jir mpìr bu pyìr bàna, ku ri fig jir mpìr-à ri wib ku mi ri sa bu-à ku ri zìm. ");
INSERT INTO jib_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tun sai-à big màm jag sig dunyaru, yi fig fig tai zyun rag, mpìr pù finn rìghing zu mpìr-à big mà sig ku í àfau bàna. ");
INSERT INTO jib_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mpìr-à níng bi sig mà byar Shìdun ni. Nìm ma í àdòníng bàna, ku nìm má sa yì fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Big dinya ku n rag, “Big mà sig wù áyau bu pyìr, ama tàma-à níng wù ri tàg yi bu rà?” Big í kan zu rìg-à ku mà tonn bìr kwonn-à ni. ");
INSERT INTO jib_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Barà Yesu fig àdòníng, ku yàn dìg wàníng n bib wàníng rag, “A bir hing pìkyinnwú á byar Wùn Mpìr Jíkwìnn rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ku zìm n dang rag, “Shinn Lumí, á dinya mì mpìr-à níng hi, àjirà ń bir pìkyinnmí á byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu dinya ku n rag, “A myàng rìghing ku, ku í mpìr-à ri dang jír ma wù níng.” ");
INSERT INTO jib_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","I byar-à ku dang rag, “Shinn Lumí, ǹ bir hing pìkyinnmí áni.” Ku bi bìnn kir wann á jìnn ni, n wib Yesu. ");
INSERT INTO jib_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu dang rag, “N bi sig á dunyaru àjirà ń wà kwonn. Ká ri myàng fig bàna níng, abig myàng. Ká ri myàng níng, abig shi àfau.” ");
INSERT INTO jib_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisawaká zyun-à shi sig ma ku níng, fig jírwá àdòníng, big bib ku n rag, “Asai yi í àfau rà?” ");
INSERT INTO jib_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu dinya big rag, “Wà ning nìm má àfau, big nìm má dang fig rag, ning shi sig ma bu pyìr bàna. Ama tàma-à níng, ning rag ning ri myàng, í bu-à sa ning shi sig á bu pyìrná ni.” ");
INSERT INTO jib_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu dang n rag, “Mì ri dinya ning í jir àjai, mpìr-à ma kà fig áyau àdùnká ni, ma bàg fig í nu nkyun-à bàna, ma nann sig á agunn gbìb zyun ni kim, mpìr-à níng í ajwú, ku ri gbar shwar bu ma gbam. ");
INSERT INTO jib_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mpìr-à ma kà hing nu nkyun-à, ku í mpìr aza àdùnká àjai. ");
INSERT INTO jib_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mpìr-à ri shi myàng nu nkyun àdùn káníng ri pù nkyun-à àjirà aza àdùn-à níng aku kà yag. Adùnká fig yì rìghing nài jir anubá, ku ri bar kó ni ma zìnnwá, mi ri zìg zu bi big á myann. ");
INSERT INTO jib_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wà kwa zìg zu rìghing káníng á myann, kwá kà á pyànn, í wà káníng má bàg ku ásim, jir kai bàna big fig yì hing nài jírwá. ");
INSERT INTO jib_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Big ri kan bàg fig kyìnn bàna, ba myàng hing kyìnn, big í shàr rìg bá, jir kai bàna big fig yì fig nài jírwá bàna.” ");
INSERT INTO jib_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu dinya big tinn jír-à níng, ama big fig yì fig bu-à ku ri dang bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu dang jakàng n rag, “Mì ri dinya ning í jir àjai, mì í nu nkyun àdùnká. ");
INSERT INTO jib_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mpìrká bi jag sig mì níng, big dang rag big í Kristi, ama big í mpìr ajwú. Adùnká ma fig fig jírbá bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","N shi síg nì nu nkyun-à, mpìr-à ma kà hing á agunnmí ni, kwá dìg yonki, kwá kà bi, má zu yag, má dìg buju. ");
INSERT INTO jib_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ajwú ri bi àjirà aku jwi bu, ma aku gban ki, ma aku sa bai bu. Ama bigmí, ǹ bi síg àjirà aning dìg yonki, àjirà ná sa fig ashi bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mì í aza àdùn ǹsàn, jir kai bàna aza àdùn ǹsàn ri ya shinnwá á byar àdùnká buwá ni. ");
INSERT INTO jib_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mpìr zyun-à ma ri sa swàm bài, wà ku ma í àsàin àdùn-à bàna, kwa myàng hing jwànnzwam ma ri bi, kwá shàr rìg má fim rìg àdùnká, jwànnzwam má pànn rìg big, kádàkí má shàr yam rìg. ");
INSERT INTO jib_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ku í mpìr asa swàm bài, ku ri kyab fig jir àdùnká bàna. I bu-à sa ku ri shàr níng. ");
INSERT INTO jib_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mì í aza àdùn ǹsàn, ǹ yì hing buká bumí big, buká bumí big yì hing mì tìnn. ");
INSERT INTO jib_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Barà Tamí yì hing mì níng, mì má ǹ yì hing ku tìnn. N ya hing yonkimí á dò shinn àdùnká ni. ");
INSERT INTO jib_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N shi sig ma àdùnká káhi zyun-à kà fig áyau káníng ni bàna. Shi sig í dole ń zìg bi big tìnn. Bá fig nài jírmí, má shi í bu ńzyun bidìm pár. Má shi àsàin lubá ńzyun. ");
INSERT INTO jib_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tamí ri zìm mì wàni, jir kai bàna mì ri wann tafinn yonkimí àjirà ń dìg jakàng. ");
INSERT INTO jib_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mpìr má zìg zu fig yonkimí bàna, má ya big shinnmí, jir kai bàna ǹ shi sig ma gbam wà má ya átai, kuma má zìg kàng. Wàníng í bu-à Tamí dinya sig mì ń sa.” ");
INSERT INTO jib_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A byar-à níng hi, mpìr Yahudawaká gbìb shùr n gàfinn dìr á jir shinn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mpìrká káhi nìnànn nímá dang rag, “Ku shi sig ma wàu, ku ri shàr ǹsáng. Bu-à sa ning ri fig jírwá í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama mpìrká káhi dang rag, “Mpìr-à ma shi sig ma wàu, má dang fig íri jír-à níng bàna. Sáshinn mpìr wàu má dàb gbam àfau rà?” ");
INSERT INTO jib_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A sònn wàu-à ni, Yahudawaká ri sa bùkí mà Urushalima. Ayúnn-à níng hi, í àyúnn-à wùwài wà big ri kyab pànn sai-à big sa kyàr sig lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu ri kyann kyann mà byar zyun á lu Shìdun ni. Byar-à níng hi, big ri bar ku byar Sulemanu. ");
INSERT INTO jib_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahudawaká sar kàng kwìb ku, n dinya ku rag, “Sáshinn wá fim yi, yi ri kyab jír pyànà á pìkyinnyí ni rà? A dinya byann yi, wù í Almasihu rà?” ");
INSERT INTO jib_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu dinya big n rag, “N nìm dinya hing ning, ama ning bir fig pìkyinn áni bàna. Bu mamakiká mì ri sa á zìnn Tamí ni níng, ri tìya mpìrká shumí. ");
INSERT INTO jib_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama ning bir fig pìkyinn ná áni bàna, jir kai bàna ning shi fig áyau àdùnká bumí ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Adùnká bumí ri fig jírmí, ǹ yì hing big, big ri bàg mì tìnn. ");
INSERT INTO jib_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mì ri ya big yonki kinn kinn. Bá wu fig bàna, mpìr má gbar shwar fig big á vùmí ni bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamí zyun-à ya sig mì big níng, kab hing kó ni bidìm pár. Mpìr fòr fig wà kwá gbar shwar big á vùwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yi ma Tamí í bu ńzyun.” ");
INSERT INTO jib_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yahudawaká zìg jakàng abàn, jirà abig ta gban ku ma kàhi. ");
INSERT INTO jib_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu dinya big rag, “N sa hing bu mamakiká nìnànn nímá á pyànn ná ni, zyun-à Tamí dinya sig mì ń sa. I jir swàm bu mamaki-à wà áni, zyun-à ning ri zìm aning ta gban mì jir kàhi níng rà?” ");
INSERT INTO jib_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahudawaká dinya kàng ku n rag, “Wà yi ri zìm ayi ta gban wù níng, í jir shinn swàm bu mamaki-à à sa sig níng bàna, ama í jirà wù ri sa bai zìnn Shìdun. Wù í mpìr jíkwìnn, ama wù ri sìnn kàng shinnwú rag wù í Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A byar-à hi Yesu dinya big rag, “Big ba sìnn sig á tarkada dokaná ni rag, ‘Shìdun dang rag, ning í Shìdun.’ ");
INSERT INTO jib_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mpìrká zyun-à Shìdun dinya sig big jírwá níng, Shìdun bar big í Shìdun. Yi yì hing jir Shìdun í àjai. ");
INSERT INTO jib_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bigmí Shìdun shig zu sig mì, n swam bi sig mì á dunyaru. Bu-à sa ning dang rag, mì ri sa bai zìnn Shìdun níng, í jirà ǹ dang rag, mì í Wùn Shìdun níng rà? ");
INSERT INTO jib_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wà ma sa fig bu-à Tamí ri sa bàna, kada aning bir pìkyinn ná á jírmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wà ma sa bu-à Tamí ri sa, kó wà na bir fig pìkyinn ná á jírmí ni bàna, aning bir pìkyinn á bu-à mì ri sa, í wà ná yì rag Tamí shi sig á byarmí ni, mì má ǹ shi sig á byarwá ni tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Big ri zìm abig pànn Yesu, ama ku í jànn rìgwá. ");
INSERT INTO jib_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ku kàng yag kàng mà Ning Urdun ni mà jann, á byar-à Yohanna rì sa jag sig batisma, n yag shi màhàn. ");
INSERT INTO jib_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mpìrká nìnànn nímá bi á byar Yesu ni n rag, “Kó barà Yohanna sa fig bu mamaki zyun bàna, tàma-à níng yi yì hing jír-à ku dang sig á shinn Yesu ni, í àjai.” ");
INSERT INTO jib_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mpìrká nìnànn nímá bir hing pìkyinnbá á byarwá ni màhàn. ");
INSERT INTO jib_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wunù zyun zìnnwá í Liyazaru, ku na sig dor, ku í mpìr-à mà Baitanya á kauye Maryamu ma shunwàuwá Marta. ");
INSERT INTO jib_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu í zyun-à wìr sig Yesu byìr tulare á barwá ni, n tung kyàr ma jinnwá. Liyazaru bó í ajunù Maryamu wà na sig dor-à níng. ");
INSERT INTO jib_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Maryamu ma Marta swam yag aswam á byar Yesu ni n rag, “Shinn Luyí, jàuwú zyun-à wù ri zìm wàni níng, na sig dor.” ");
INSERT INTO jib_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Barà Yesu fig àdòníng, ku rag, wàníng í dor ki bàna, ama í dor-à wà mpìrká má swam yan zìnn Shìdun áni, ma wà bá wib Wùn Shìdun áni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ri zìm Marta ma wunzàwá ma Liyazaru. ");
INSERT INTO jib_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Barà ku fig tai big rag, Liyazaru na sig dor, sái ku shi kàng mà byar-à ku nìm shi sig níng su pyànà. ");
INSERT INTO jib_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A byar-à níng hi, ku dinya yann sukàwá big n rag, “Tàma-à níng ayi kàng yag mà Yahudiya.” ");
INSERT INTO jib_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yann sukàká dinya Yesu n rag, “Malam, sai-à nìm níng, Yahudawaká ri zìm abig ta gban wù ma abàn. Ama tàma-à níng wù ri zìm á kàng yag kàng màhàn rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu zìm n rag, “Ayúnn-à ma nann zu hing, ri sa awa dwib agban pyànà, í wà ku ri kà í ni. Mpìr ma ri kyann á yiyar-à ni, àsìu má ta fig ku bàna, jir kai bàna ku ri myàng kyàr byarká á dunyaru. ");
INSERT INTO jib_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama wà kwa kyann á fi, àsìu má ta ku, jir kai bàna àyar-à bàna.” ");
INSERT INTO jib_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu dang jír káníng n rag, “Jàuyí Liyazaru ri na aná, má yag bar finn zir ku.” ");
INSERT INTO jib_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yann sukàwá big dinya ku rag, “Shinn Luyí, wà ku ma ri na aná kwá gbam rìg.” ");
INSERT INTO jib_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu ri dang jír á shinn ki Liyazaru, ama yann sukàwá big ri kyab rag kó wàníng ri na aná àjai. ");
INSERT INTO jib_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu dinya kyàr big àjai n rag, “Liyazaru wu rìghing. ");
INSERT INTO jib_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mì ri fig àjwár, jir kai bàna á sai-à níng hi ǹ bàna màhàn. N nìm ma shi sig màhàn, Liyazaru nìm má wu fig bàna. Tàma-à níng má tìya ning gbam-à ǹ shi sig ma kàhi á shinn ki, jirà aning bir pìkyinn ná á byarmí ni. Tàma-à níng ayi yag mà byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma, zyun-à í wùn ǹtài níng dinya jàuwá big n rag, “Ayi yag kwonn ma malam í zyun, àjirà ayi wu ma ku á bìr-à ni.” ");
INSERT INTO jib_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Asai-à Yesu bi níng, Liyazaru wu rìghing big jì dim rìghing ku hár su yina. ");
INSERT INTO jib_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Swann Baitanya shi yàr sig ma Urushalima, áyaubá ni fòr fig mel pyànà bàna. ");
INSERT INTO jib_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahudawaká nìnànn nímá yag sig mà byar Marta ma Maryamu, àjirà abig bib kà big nài ki ajunùbá. ");
INSERT INTO jib_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Barà Marta fig Yesu ri bi àdòníng sái ku yag n yag shà wàníng á gbìb-à ni. Ama Maryamu shi sig buwá á lu-à ni. ");
INSERT INTO jib_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta dinya Yesu n rag, “Shinn Luyí, wù nìm ma áyag, wàníng ajunùmí nìm wu fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama ǹ yi hing, kó tàma-à níng bu-à wa vig hing, Shìdun má ya wù.” ");
INSERT INTO jib_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu dinya Marta n rag, “Ajunùwú má dù nann zu ma yonki.” ");
INSERT INTO jib_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta dinya ku rag, “N yì hing kwá dù nann zu ma yonki àyúnn-à dunyaru má vinn áni.” ");
INSERT INTO jib_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu dinya ku n rag, “N shi síg nì mpìr-à má gbar dù nann zu mpìrká ma yonki, ǹ shi síg nì yonki. Mpìr-à ma bir hing pìkyinnwá á byarmí ni, kó kwa wu hing, kwá wìm kàng. ");
INSERT INTO jib_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mpìr-à ma shi sig ma yonki, ma bir hing pìkyinnwá á byarmí ni, kwá wu fig bàna. A bir hing pìkyinnwú áni rà, kó bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta dinya Yesu n rag, “I àjai, Shinn Luyí. N bir hing pìkyinnmí rag, wù í Almasihu Wùn Shìdun àsàin-à sai-à rì níng big rì shi kir ku aku bi á dunyaru.” ");
INSERT INTO jib_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Barà Marta dang àdòníng, ku kàng yag n yag shàm dinya wunzàwá Maryamu n rag, “Malam shi sig áyag, ku ri bar wù.” ");
INSERT INTO jib_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Barà Maryamu fig àdòníng, ku dab dù kíni n yag mà byar wàníng ni. ");
INSERT INTO jib_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kà fig ma mà kauye bàna, í barà ku shi sig ma mà byar-à ku ma Marta nìm dìg kwonn sig níng. ");
INSERT INTO jib_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahudawaká ká bi sig abig bib kà Maryamu nài ki-à níng, big shi sig í zyun ma ku mà lu-à ni. Barà big myàng Maryamu dù nann zu kíni àdòníng, mi ri zu yag mà myànn níng, big bàg ku, jir kai bàna big ri kyab rag kó ku ri yag mà amir-à ni, àjirà aku kig màhàn. ");
INSERT INTO jib_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Barà Maryamu fòr yag mà byar Yesu, n myàng wàníng àdòníng, ku bìnn kir wann á jìnn ni á bar wàníng ni n rag “Shinn Lumí, wà wù nìm ma áyag ajunùmí nìm má wu fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Barà Yesu myàng ku ri kig àdòníng, Yahudawaká ká bi sig ma ku níng ri kig tìnn, sái pìkyinnwá í bai rìg-à. ");
INSERT INTO jib_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ku bib big rag, “Ning jì síg ku áni rà?” Big dinya ku rag, “Shinn Luyí, á bi ma á myàng.” ");
INSERT INTO jib_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kig mínn. ");
INSERT INTO jib_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahudawaká dang n rag, “Aning myàng barà ku zìm sig mpìr-à níng áni.” ");
INSERT INTO jib_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama káhi áyaubá ni dang rag, “Mpìr-à níng dàb gbam hing àfauká, sáshinn ku bàna ma gbam wà kwá kan dim ki Liyazaru rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu yag fòr mà byar amir-à ni, pìkyinnwá bai shi nímá. Amir-à hi í ashòr abàn. Big kìg dim rìghing nu ashòr-à hi ma abàn. ");
INSERT INTO jib_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu dinya big rag, “Aning zìg dù rìg abàn-à níng.” A byar-à hi, Marta zyun-à ajunùwá wu sig níng, dinya Yesu rag, “Shinn Lumí, tàma-à níng ku swàr rìghing, jir kai bàna suwá sa hing yina á shar-à ni.” ");
INSERT INTO jib_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu dinya ku rag, “N nìm dinya fig wù rag wà wa bir hing pìkyinnwú á byarmí ni, wá myàng gbam Shìdun bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Big í abàn-à hi í zìg du rìg-à. Yesu myàng yag zuwá mà wai, n dang rag, “Tamí, mì ri sa wù ísoko barà à fig hing jírmí. ");
INSERT INTO jib_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N yì hing wù ri fig jírmí kó ákaun bidìm pár, ama tàma-à níng, á jir shinn bìr mpìrká níng ni, mì ri zìm á fig jírmí àjirà abig yì rag à swam bi síg mì nì.” ");
INSERT INTO jib_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Barà ku dang jír-à níng àdòníng, ku bar nài abor ma gbam n rag, “Liyazaru, á zu bi.” ");
INSERT INTO jib_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A byar-à hi, Liyazaru í zu bi-à ma jà ki-à big sìr dim sig vùwá ma barwá ma mùnnpyànnwá áni. Yesu dinya big rag, “Aning fìnn zu ku, ma aning fim ku aku yag.” ");
INSERT INTO jib_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mpìrká nìnànn nímá áyau Yahudawaká ká bi sig abig bib kà Maryamu, big myàng buká Yesu sa sig níng, big bir pìkyinnbá á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama kádàkí áyaubá ni, yag sig mà byar Farisawaká, big dinya big bu mamakiká Yesu sa sig. ");
INSERT INTO jib_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agbam malamká ma Farisawaká bar kwonn ba dìrbá mà tonn shinn kwonn n dang rag, “Ma yá sa í kai rà? Aning myàng bu mamakiká mpìr-à níng ri sa. ");
INSERT INTO jib_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wà ya fim hing ku átai àdòníng, mpìrká bidìm pár má bir pìkyinnbá á byarwá ni. Mpìr Romawaká má bi má sa bai rìg lu Shìdun má zìg rìg jànnyí.” ");
INSERT INTO jib_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ama mpìr zyun big ri bar ku Kayafa, ku í agbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ku dinya big rag, “Ning yì fig kó bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ning yì fig wà sàn hing wà barà mpìr ńzyun aku wu á jir shinnyí ni, ma wà mpìrká nìnànn nímá nìm má wu níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ku dang fig jír-à níng ma shinnwá bàna, ama barà ku í àgbam á ji-à níng ni, Shìdun sìnn kà sig ku aku dang rag, “Yesu má wu á jir shinn mpìr Yahudawaká ni.” ");
INSERT INTO jib_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ama kwá wu fig íri jir shinn mpìr Yahudawaká bàna, ama dò jirà aku bar kwonn yanká bu Shìdun ká yam sig níng. ");
INSERT INTO jib_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tunn àyúnn-à níng hi, big kwonn nubá barà bá gban ku áni. ");
INSERT INTO jib_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu tàma-à níng ri kyann fig rag á byar yiyar byar-à Yahudawaká má myàng ku bàna. Ku fim rìghing byar-à níng hi, n yag sig mà jànn zyun shi yàr sig ma awúnn, n yag kà mà finn swann zyun-à big ri bar Ifirayimu. A byar-à hi, ku yag shi kwonn sig ma yann sukàwá big. ");
INSERT INTO jib_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayúnn wùwài bu Yahudawaká, zyun-à big ri bar rag, í àyúnn Pìm Wam Zu nyàan fòr, tunn sai-à àyúnn-à hi sa fig ma bàna, mpìrká nìnànn nímá mà kauyeká ni ká nann yag sig mà Urushalima, àjirà abig sa kyàr dìrbá. ");
INSERT INTO jib_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Big yàn kyann Yesu. Barà big sar sig mà lu Shìdun ni, mi ri bib ba dìrbá rag, “Ma ning ri kyab kai tàma-à níng rà? Kwá bi fig àyúnn Pìm Wam Zu-à níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A byar-à níng hi, àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma Farisawaká dang rag, mpìr-à ma yì hing byar-à Yesu shi sig, aku dang àjirà abig pànn wàníng. ");
INSERT INTO jib_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Barà àyúnn su Pìm Wam Zu dà sig ma su sùnnjin, Yesu yag mà Baitanya byar-à Liyazaru shi sig, zyun-à Yesu gbar dù mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A byar-à níng hi, big sa ya Yesu buju, Marta ri gàfinn ya mpìrká buju. Liyazaru shi kà sig áyaubá ni, mi ri ji buju. ");
INSERT INTO jib_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sái Maryamu zìg byìr zyun ri ning swìnn ǹsàn nímá, big ri bar rag nardi. Byìr-à níng hi shi sig ma bài wàni. Ku pàb á bar Yesu ni n tùn kyàr ma jinnwá. Lu-à hi bidìm pár ning gban rìg ma swìnn byìr-à hi. ");
INSERT INTO jib_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ama Yahuda Iskariyoti wùn sukà zyun áyau yann sukàká bu Yesu, í zyun-à ri zìm aku wann tafinn Yesu, ku dang rag, ");
INSERT INTO jib_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bu-à sa big wann tafinn fig byìr-à níng bài wùwài nímá, n zìg bài-à níng n ya fig mpìr ashiká bàna í jir kai rà? Byìr-à níng bàiwá fòr hing bài swàm ji zyun bu mpìr zyun.” ");
INSERT INTO jib_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ku dang sig jír-à níng átai, ku zìm fig mpìr ashi káníng bàna. Ku í mpìr ajwú. Barà bàiká big shi sig ma kàhi níng shi sig á vùwá ni níng, ku ri tinn zu káhi mi ri ji. ");
INSERT INTO jib_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu dang rag, “Aning fim uwà-à níng, ku sìnn gbam sig byìr-à níng àjirà aku wìr kà ya mì sai-à bá jì mì. ");
INSERT INTO jib_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ná dìg kyann mpìr ashiká áyauná ni kó ákaun, ama bumí ná dìg kyann fig mì bàna.” ");
INSERT INTO jib_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mpìr Yahudawaká nìnànn nímá fig tai rag, Yesu shi sig mà Baitanya, á byar-à hi big yag màhàn. Big yag fig íri jir Yesu bàna, ama àjirà abig myàng Liyazaru zyun-à Yesu bar wìm kàng ku mà amir-à ni níng. ");
INSERT INTO jib_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A byar-à níng hi, àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, su kwonn nu àjirà abig gban Liyazaru tìnn, ");
INSERT INTO jib_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","jir kai bàna á shinn Liyazaru mpìr Yahudawaká nìnànn nímá ri ngàng jir àgbamká, mi ri bir pìkyinn á byar Yesu. ");
INSERT INTO jib_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na kyàr byar-à, mpìrká nìnànn nímá ká bi sig jir àyúnn Pìm Wam Zu-à níng, fig tai big rag Yesu má bi á Urushalima. ");
INSERT INTO jib_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Big zìg ayab lí n yag shà ku, n gbam nài gbam n rag, “Hosanna, ayi swam yan ku zyun-à ri bi á zìnn Shìdun, ayi swam yan kùr Israila.” ");
INSERT INTO jib_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu yàn dìg wùn aswannswánn zyun, n nann zu áni àràg barà big ba sig á tarkada Shìdun ni n rag, ");
INSERT INTO jib_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kada aning shàr zinn bàna, ning mpìrká á finn swann Siyona. Aning myàng kùrná ri bi, ku nann shi sig á shinn wùn aswannswánn.” ");
INSERT INTO jib_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yann sukàwá big yì fig ma yìr buká ri sa níng bàna sai-à wà jijag, ama ásim sai-à Yesu dù nann zu mà amir-à ni ma yonki níng, á byar-à hi big kyab pànn bu-à big ba sig á shinnwá ni. Asai-à níng hi, big í yì byann rìg-à bu-à hi sa hing àràg barà big rì ba sig á jir Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mpìrká nìnànn nímá ká zyun-à shi sig ásai-à Yesu bar zu bi Liyazaru mà amir-à ni ma yonki níng, myàng àdòníng, big bir pìkyinnbá áni, mi ri dinya mpìrká nìnànn nímá tai bu-à sa sig. ");
INSERT INTO jib_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","I bu-à sa bìr mpìr káníng bi sig á byarwá ni, jir kai bàna big fig sig rag, ku sa sig bu mamaki. ");
INSERT INTO jib_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A byar-à níng hi, Farisawaká dinya bar dìrbá n rag, “Aning myàng, yi dìg fig pyù bàna, kó títi nímá. Mpìrká bidìm pár ri bàg ku.” ");
INSERT INTO jib_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mpìr Helenawaká káhi shi sig áyau mpìrká yag sig mà Urushalima àjirà abig wib Shìdun àyúnn Pìm Wam Zu. ");
INSERT INTO jib_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Big yag mà byar Filibus, ku zyun-à ku í mpìr Batsaida á jànn Galili, n dang rag, “Malam, yi ri zìm ayi myàng Yesu.” ");
INSERT INTO jib_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibus yag n dinya Andarawus. A byar-à níng hi, big pyànà bidìm pár big yag n dinya Yesu. ");
INSERT INTO jib_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu dinya big n rag, “Ayúnn-à sa hing wà bá swam yan mì Wùn Mpìr Jíkwìnn. ");
INSERT INTO jib_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mì ri dinya ning àjai, wà ya tàg fig yìr za á jìnn ni bàna, má nga nann zu fig barà má sa yìr bàna, má shi áwinwá ni. Ama wà ya tàg hing á jìnn ni, má byann wàni. ");
INSERT INTO jib_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mpìr-à ma ri zìm íri shinnwá, kwá dìg fig yonki bàna. Ama mpìr-à ma wann tafinn hing shinnwá á dunyaru-à níng ni, kwá dìg yonki wà zyun-à kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mpìr-à ma ri zìm ń shi àsàin luwá, aku bàg mì, àjirà byar-à ǹ shi sig níng, fàumí aku shi màhàn tìnn. Mpìr-à ma ri zìm ń shi àsàin luwá, Tamí má sìnn kàng ku mpìr ùwài. ");
INSERT INTO jib_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tàma-à níng pìkyinnmí na tag fig bàna, má dang í kai rà? Kó ń dang rag, ‘Tamí, shwìn-à níng aku dìg mì bàna,’ rà? Ama bu-à sa ǹ bi sig á jànn-à ni í jirà ń wa shwìn-à níng. ");
INSERT INTO jib_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamí, á tìya mpìrká gbamwú.” A byar-à níng hi, nài jír zu bi mà wai n rag, “N nìm tìya rìghing big gbammí, ama má tìya jakàng big.” ");
INSERT INTO jib_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bìr mpìrká zyun-à sar sig mà byar-à níng hi níng fig àdòníng, big rag, “I shyù ri kàn nì.” Káhi dang rag, “I wùn aswam Shìdun dang síg nì jír ma ku.” ");
INSERT INTO jib_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama Yesu dinya big n rag, “Nài jír-à níng, í jir shinnmí bàna, ama í jir shinn ná. ");
INSERT INTO jib_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tàma-à níng í sai-à bá wà kwonn mpìrká á dunyaru, bá kan zu rìg Shaitan, ku zyun-à ku í kùr mpìrká ri zìm fig Shìdun bàna. ");
INSERT INTO jib_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sai-à ba gbar nann zu hing mì, má gbar bi mpìrká nìnànn nímá á byarmí ni.” ");
INSERT INTO jib_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Barà Yesu ri dang àdòníng, ku ri tìya mpìrká swai kiwá kwá wu. ");
INSERT INTO jib_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bìr mpìrká bib ku n rag, “Yi fig hing jir Shìdun dang rag, ‘Almasihu má shi kinn kinn,’ bu-à sa wá dang rag, ‘Bá gbar dù nann zu Wùn Mpìr Jíkwìnn mà wai,’ í jir kai rà? Wùn Mpìr Jíkwìnn hi í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu dinya big rag, “Ayar shi sig áyauná ni, ama àyar-à hi má shi nonn fig bàna. Aning kyann kyonn áyau àyar-à hi ni, jirà kada aning kyann kyonn á zufi bàna. Mpìr-à ma ri kyann kyonn á zufi-à ni, kwá yì fig byar-à ku ri yag bàna. ");
INSERT INTO jib_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aning bir pìkyinn ná á byar àyar-à hi ni, barà àyar-à hi shi sig ma á byarná ni, àjirà aning shi yann àyar.” Barà Yesu dang vinn rìg jír-à níng, ku í bònn yag rìgwá. ");
INSERT INTO jib_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kó barà Yesu sa bu mamaki nìnànn nímá á pyànn mpìr Yahudawaká ni níng, big bir fig pìkyinnbá á byarwá ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bu káníng sa hing àjai, àràg barà Ishaya rì ba sig. Ku ba sig rag, “Shinn Lumí, mpìr-à bir sig pìkyinnwá á jír-à yi dang sig á shinnwú ni níng, í ni rà? Shìdun tàg sig gbamwá á byar ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jir wàníng, big bir fig pìkyinnbá áni bàna, jir kai bàna Ishaya zyun-à rìi dang kyann jir Shìdun níng, dinya sig big rag, ");
INSERT INTO jib_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Shìdun bir dim rìghing zubá, n sa wu rìghing pìkyinnbá àjirà abig myàng ma zubá bàna, ma abig kyab jír á pìkyinnbá ni bàna, hár abig kàng bi á byarmí ni, àjirà ń dàb gbam big bàna.” ");
INSERT INTO jib_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya dang jír káníng, jir kai bàna ku myàng hing gbam Yesu, n dang jír á shinn wàníng ni. ");
INSERT INTO jib_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Agbam mpìr Yahudawaká nìnànn nímá bir hing pìkyinnbá á byar Yesu ni, ama big ri shàr zinn Farisawaká, í bu-à sa big ri dinya kyàr zu fig mpìrká rag big bir hing pìkyinnbá á byar Yesu ni bàna, jir kai bàna kada abig kan zu big mà tonn shinn kwonn-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Big ri zìm kab mpìrká abig yan big, ma wà Shìdun má yan big íni. ");
INSERT INTO jib_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu dinya big ma gbam n rag, “Mpìr-à ma bir hing pìkyinnwá á byarmí ni, ku bir fíg íri wà á byarmí ni bàna, ama ku bir sig á byar mpìr-à swam bi sig mì níng tìnn. ");
INSERT INTO jib_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mpìr-à ma myàng hing mì, ku myàng hing Tamí zyun-à swam bi sig mì. ");
INSERT INTO jib_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Bigmí ǹ bi sig àràg í àyar á dunyaru. Mpìr-à ma bir hing pìkyinnwá á byarmí ni, kwá shi fig á zufi-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wà mpìr-à ma ri fig jírmí, ma wib fig bàna, í mì má wà fig kwonnwá íni bàna, jir kai bàna ǹ bi fíg àjirà ń wà mpìrká á dunyaru kwonn bàna, ama àjirà ń pinn zu big. ");
INSERT INTO jib_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mpìr-à ma ngàng mì, ma zìm fig jírmí bàna, ku shi sig ma bu-à má wà ku kwonn. Jírká zyun-à ǹ dang sig níng, má shi ínì kwonn wà àyúnn-à dunyaru má vinn, ");
INSERT INTO jib_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","jir kai bàna jír káníng, ǹ dang fig ma shinnmí bàna, ama Tamí zyun-à swam bi sig mì níng, í ku dinya síg mì nì jír-à má dang. ");
INSERT INTO jib_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N yì hing jírká zyun-à Tamí dinya sig mì ń dang níng, ri ya yonki kinn kinn, jir kai bàna buká mì ri dang níng, í bu-à Tamí dinya sig mì ń dang.” ");
INSERT INTO jib_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sai-à àyúnn Pìm Wam Zu sa fig ma bàna, dà sig su zyun, Yesu yì hing wà sai-à kwá fim dunyaru-à níng má yag mà byar Tawá ni sa hing. Ku ri zìm mpìrká buwá zyun-à shi sig á dunyaru wàni, ku ri zìm big hár àyúnn-à ku bi wu. ");
INSERT INTO jib_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Asai-à Yesu ma yann sukàká buwá ri ji buju ákamzau, Shaitan sìnn kà bab rìghing Yahuda Iskariyoti wùn Siman a wàníng wann tafinn rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu yì rìghing wà Tawá ya rìghing ku gbam kó kai bidìm pár, ku yì hing wà ku bi sig mà byar Shìdun ni, kwá kàng yag jakàng mà byar Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ku dù mà byar buju-à ni, n yag wan zu rìg jàwá, n sìnn gbam. Ku zìg jà zyun n sìr gbam dìrwá ma kàhi. ");
INSERT INTO jib_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A byar-à níng hi, Yesu kab wìr kà zàpìr á kwài-à ni, mi ri tu bar yann sukàká buwá, n tùng kyàr ma jà-à ku sìr gbam sig dìrwá áni níng. ");
INSERT INTO jib_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Barà ku bi mà byar Siman Bitrus, Bitrus dinya ku rag, “Shinn Luyí, kada á tu barmí àdòníng bàna.” ");
INSERT INTO jib_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu zìm n rag, “Wá yì fig bu-à mì ri sa tàma-à níng bàna, ama wá yì á pyànn.” ");
INSERT INTO jib_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitrus dinya Yesu n rag, “Wá tu fig barmí bàna hár kinn kinn.” A byar-à níng hi Yesu dinya ku rag, “Wà ma tu fig barwú bàna, wá shi fig rag wùn sukàmí bàna.” ");
INSERT INTO jib_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Siman Bitrus dinya ku rag, “Wà má àdòníng, á tu íri barmí bàna, ama ma vùmí ma shinnmí tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu dinya ku rag, “Mpìr-à ma wau hing dìrwá, kwá tu íri barwá, jir kai bàna dìrwá shi sig ákyàr. Ning bidìm pár, ning shi sig ákyàr, ama dà sig mpìr ńzyun.” ");
INSERT INTO jib_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ku yì hing mpìr-à má wann tafinn ku, í bu-à sa ku dang rag, “Ning shi sig ákyàr, ama dà sig mpìr ńzyun.” ");
INSERT INTO jib_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Barà ku tu vinn rìg barbá àdòníng, ku zìg jàwá n wìr kà n kàng yag mà byar shuwá ni. Ku bib káníng n rag, “Ning yì hing bu-à ǹ sa sig ning níng rà? ");
INSERT INTO jib_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ning ri bar mì rag, Malam ma Shinn Luyí, ning bar sig àjai, jir kai bàna ǹ shi sig àdòníng hi. ");
INSERT INTO jib_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Barà mì í Shinn Luná, ma Malamná, ǹ tu sig barná, ning tìnn má, aning tu bar jàuná tìnn. ");
INSERT INTO jib_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N sa sig ning àdòníng jirà ning má aning yag sa mpìrká káhi àràg barà ǹ sa sig ning níng. ");
INSERT INTO jib_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mì ri dinya ning àjai, fàu má kab fig àsàin luwá bàna, wùn aswam má kab fig mpìr-à swam sig ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tàma-à níng barà ning yì hing bu káníng, wà na bàg hing, Shìdun má sa sàn ya ning. ");
INSERT INTO jib_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mì ri dang fíg jír-à níng jir shinn ná bidìm pár bàna. N yì hing írì swai mpìrká zyun-à ǹ shig zu sig. Ama àjirà jir Shìdun aku shi àràg barà big ba sig rag, ‘Mpìr zyun má wann tafinn mì, í mpìr zyun-à yá ji buju ma ku níng.’ ");
INSERT INTO jib_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mì ri dinya ning tàma-à níng, barà sai-à níng hi màg fig ma bàna níng, jir kai bàna wà àyúnn-à níng hi ma màg hing aning bir pìkyinn ná rag í mì. ");
INSERT INTO jib_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mì ri dinya ning àjai, mpìr-à ma pànn hing kó ni zyun-à ma swam bi sig vù pyànà, ku pànn síg mì. Mpìr-à ma pànn hing jírmí, ku pànn sig í jir Shìdun zyun-à swam bi sig mì.” ");
INSERT INTO jib_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Barà Yesu dang àdòníng, pìkyinnwá í bai rìgwá, ku dinya kyàr big n rag, “Mì ri dinya ning àjai, mpìr zyun áyauná ni má wann tafinn rìg mì.” ");
INSERT INTO jib_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A byar-à níng hi, yann sukàwá big myàng gbam ba dìrbá, mi ri kyab rag kó í ni áyaubá ni rà. ");
INSERT INTO jib_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mpìr zyun shi sig áni áyau yann sukàká ni, wà zyun-à Yesu ri zìm wàni, ku shi yàr sig ma Yesu. ");
INSERT INTO jib_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siman Bitrus pyar bar ku rag, “A bib Yesu rag mpìr-à níng hi í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A byar-à níng hi, ku zyun-à ku shi yàr sig ma Yesu níng, ku bib wàníng n rag, “Shinn Luyí, wù ri dang í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu dang rag, “I mpìr-à má ngir brodi má swànn kà á byù, má ya ku aku ji níng.” A byar-à níng hi, Yesu swànn kà brodi á byù-à ni, n ya Yahuda wùn Siman Iskariyoti. ");
INSERT INTO jib_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Barà Yahuda zìg brodi-à hi àdòníng, sai Shaitan kà rìg á pìkyinnwá ni. Yesu dinya ku rag, “Bu-à wù ri zìm á sa níng, á sa kíni.” ");
INSERT INTO jib_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ayaubá ni barà big shi kwonn sig á byar buju-à ni níng, big yì fig bu-à sa Yesu dinya Yahuda jír-à níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mpìrká káhi ri kyab rag, jirà bàibá shi sig á vù Yahuda ni, kó Yesu ri dang rag, a wàníng yag wann bi bujuká zyun-à bá sa bu àyúnn Pìm Wam Zu-à níng ma kàhi, kó a wàníng ya mpìr ashiká bài. ");
INSERT INTO jib_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuda ji agir brodi-à Yesu ya sig ku níng, mi í zu yag rìgwá mà myann á fi-à ni. ");
INSERT INTO jib_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Barà ku zu yag àdòníng, sái Yesu dang rag, “Tàma-à níng, bá swam yan mì Wùn Mpìr Jíkwìnn, bá swam yan Shìdun á jir shinn buká má sa. ");
INSERT INTO jib_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wà mpìrká ma myàng hing gbam Shìdun á jir shinnmí ni, Shìdun má sa mpìrká abig myàng gbammí tìnn. Kwá sa rìg tàma-à níng.” ");
INSERT INTO jib_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yesu dinya big rag, “Yanká bumí, má shi nonn fig ma ning bàna, ná yàn kyann mì, ama byar-à mì ri yag níng, ná yag sar fig bàna. Mì ri dinya ning àràg barà ǹ dinya sig àgbamká bu Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","N ya hing ning doka àpyú, aning zìm bar dìrná. Aning zìm bar dìrná àràg barà mì ri zìm ning. ");
INSERT INTO jib_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wà na ri zìm bar dìrná, í wà mpìrká má yì rag, ning í yann sukàmí.” ");
INSERT INTO jib_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siman Bitrus bib ku rag, “Shinn Luyí, wù ri yag áni rà?” Yesu zìm ya ku n rag, “Byar-à mì ri yag tàma-à níng, wá yag yì sar fig bàna, sái àyúnn su zyun í wà wá yag ni màhàn.” ");
INSERT INTO jib_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus bib ku rag, “Shinn Luyí, bu-à sa má bàg yag sar fig wù tàma-à níng bàna níng, í jir kai rà? N zìm hing ma wu á jir shinnwú ni.” ");
INSERT INTO jib_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A byar-à níng hi, Yesu bib ku rag, “A zìm hing wà á wu á jir shinnmí ni rà? Mì ri dinya wù àjai, kwìnn má dab fig aku bàna, wá dang hár kàun sara má rag à yì fig mì bàna.” ");
INSERT INTO jib_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu dang rag, “Pìkyinn ná aku bai bàna, aning shi bir pìkyinn ná á byar Shìdun, ma aning bir á byarmí ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mà lu Tamí ni, byar shu shi sig nìnànn nímá, wà nìm má àdòníng bàna, ǹ nìm má dinya fig ning bàna. Ma yag má sa samyib ya ning byar shu. ");
INSERT INTO jib_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Wà ma yag ma sa samyib hing byar shuná, í wà má kàng bi má zìg yag ning mà byar-à ǹ shi sig. ");
INSERT INTO jib_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ning yì hing gbìb-à byar-à mì ri yag.” ");
INSERT INTO jib_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma bib ku rag, “Shinn Luyí, yi yì fig byar-à wù ri yag bàna, sáshinn yá yì gbìb-à rà?” ");
INSERT INTO jib_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu dinya ku rag, “N shi síg nì gbìb-à, ǹ shi síg nì àjai, ǹ shi síg nì yonki. Mpìr má yag fig mà byar Tá bàna sái kwa bàg hing mì. ");
INSERT INTO jib_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Barà ning yì hing mì níng, ná yì Tamí tìnn. Tàma-à níng, ning yì hing ku, n myàng hing ku tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibus dinya ku rag, “Shinn Luyí, á tìya yi Ta-à hi, í bu-à yi ri zìm.” ");
INSERT INTO jib_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu bib ku rag, “Mì zyun-à ǹ shi nonn sig áyauná ni, Filibus, à yì fig mì bàna rà? Mpìr-à ma myàng hing mì, ku myàng hing Tamí. Bu-à sa wá dang rag, ń tìya ning Ta-à hi níng, í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filibus, à bir fig pìkyinnwú rag, ǹ shi sig á byar Shìdun, Shìdun tìnn shi sig á byarmí ni bàna rà? Jírká mì ri dinya ning níng, í jírmí bàna, ama í bu Tamí zyun-à shi sig á byarmí ni níng ri sá nì swàmwá. ");
INSERT INTO jib_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aning bir pìkyinn ná á byarmí ni, wà ma dinya ning rag, ǹ shi sig á byar Shìdun, Shìdun shi sig á byarmí ni tìnn. Kó wà má àdòníng bàna, aning bir pìkyinn ná á shinn bu mamakiká ǹ sa sig. ");
INSERT INTO jib_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mì ri dinya ning àjai, mpìr-à ma bir hing pìkyinnwá á byarmí ni, kwá sa bu-à mì ri sa kyann. Kwá sa buká zyun-à kab sig bumí, jir kai bàna mì ri yag mà byar Tamí ni. ");
INSERT INTO jib_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Má sa ya ning bu-à ning ri zìm wà na vig hing á zìnnmí ni, àjirà mpìrká abig myàng gbam Ta-à á byarmí ni, mì í wùnwá. ");
INSERT INTO jib_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wà na vig hing mì kó kai bidìm pár á zìnnmí ni, má sa ya ning. ");
INSERT INTO jib_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Wà ning ma ri zìm mì, aning wib jírká bumí. ");
INSERT INTO jib_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Má vig Tamí aku ya ning mpìr zyun, zyun-à má sa shang ning, má shi ma ning hár kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ku í Awun Kyìkyàr àjai. Mpìrká á dunyaru ri zìm fig ku bàna, jir kai bàna bá myàng yì sar fig ku bàna. Ama bigná, ning yì hing ku, jir kai bàna ku shi sig áyauná ni, ku ri shi kyann ma ning. ");
INSERT INTO jib_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Má fim fig ning áwin ná ni àràg yann ki bàna. Má kàng bi kàng á byarná ni. ");
INSERT INTO jib_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A pyànn áyag, mpìrká á dunyaru má myàng fig rag mì bàna, ama bigná ná myàng mì. N shi sig ma yonki, í bu-à sa ning má, ná dìg yonki tìnn. ");
INSERT INTO jib_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wà àyúnn-à níng hi ma màg hing, ná yì rag ǹ shi sig á byar Tamí ni, ning má ná shi áyaumí ni, mì má má shi áyauná ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Mpìr-à ma pànn hing jírmí, ma wib hing, í mpìr azìmmí. Mpìr-à ma zìm hing mì, Tamí má zìm ku, mì má má zìm ku tìnn, hár má tàg shinnmí á byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A byar-à níng hi Yahuda (zyun-à í Iskariyoti bàna níng) bib ku n rag, “Shinn Luyí, bu-à sa wá tàg shinnwú á byaryí ni, má tàg fig á byar mpìrká á dunyaru bàna, í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu dinya ku n rag, “Mpìr-à ma ri zìm mì, kwá wib jírmí, Tamí má zìm ku, yá bi á byarwá ni má shi ma ku. ");
INSERT INTO jib_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mpìr-à ma zìm fig mì bàna, kwá wib fig jírmí bàna. Jírká ning fig sig níng, jír-à hi í jírmí bàna, í jir Tamí zyun-à swam bi sig mì. ");
INSERT INTO jib_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Jír káníng bidìm pár, mì ri dinya ning á sai-à yi ma ning shi sig ma í zyun. ");
INSERT INTO jib_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Shìdun má swam bi Awun Kyìkyàrwá zyun-à má sa shang ning, má tàg ning kó kai bidìm pár, má kyab pànn ya ning bu-à ǹ dinya sig ning níng. ");
INSERT INTO jib_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“N ya hing ning bu àjwár, àjwármí aku shi á pìkyinn ná ni. Ajwármí shi fig àràg í bu dunyaru bàna, aning kyab jír bàna, aning shàr zinn bàna. ");
INSERT INTO jib_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ning fig hing wà ǹ dinya ning rag, má yag, ama má kàng bi jakàng á byarná ni. Wà na zìm hing mì, ná fig àjwár, jir kai bàna mì ri yag mà byar Tamí ni, zyun-à kab sig mì. ");
INSERT INTO jib_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mì ri dinya ning tàma-à níng barà sa fig ma bàna níng, jir kai bàna wà àyúnn-à níng hi ma màg hing, ná dang rag jírmí í àjai. ");
INSERT INTO jib_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma dinya fig rag ning jír nìnànn nímá bàna, jir kai bàna kùr dunyaru-à níng ri bi, ku bàna ma gbam á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama mpìrká á dunyaru abig yì rag, ǹ zìm hing Tamí, í bu-à sa mì ri sa bu-à ku dinya sig mì. “Aning dù nann zu ma ayi yag ning.” ");
INSERT INTO jib_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu dang rag, “N shi síg nì bin inabi àjai, Tamí shi síg nì àsàin da-à. ");
INSERT INTO jib_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tamí ri tìg kìfinn ayab bín zyun-à ri wan fig awan bàna. Ku ri tìg samyib ayab bín-à ri wan awan, jirà aku shi ákyàr ma aku wan swàb kà. ");
INSERT INTO jib_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tàma-à níng, ning shi sig rag ákyàr á shinn jírká ǹ dinya sig ning níng. ");
INSERT INTO jib_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Aning shi á byarmí ni, mì má má shi á byarná ni tìnn, àràg barà ayab inabi má wan fig awan awínwá ni bàna, sái kwa bàg hing á dìr murwá ni. I bu-à sa ning má, ná shi sar fig awín ná ni bàna, sái ma mì. ");
INSERT INTO jib_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“N shi síg nì bin inabi, ning bó ning shi síg ni ayabká. Mpìr-à ma shi sig ma mì, mì má má shi ma ku tìnn. Kwá wan awan nìnànn nímá. Ná sa yì sar fig bu zyun ma shinn ná bàna, sái ma mì. ");
INSERT INTO jib_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mpìr-à ma shi fig ma mì bàna, ku shi sig àràg ayab bín-à big kyag tafinn sig, wim rìghing. Bá zà kwonn ayab bínká hi, má takà mà pyìr-à ni, mà byar-à bá swànn gban rìg. ");
INSERT INTO jib_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wà na shi sig ma mì, jírmí ma shi sig á pìkyinn ná ni tìnn, bu-à ning ma ri zìm wà na vig hing mì, má ya ning. ");
INSERT INTO jib_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aning wan awan nìnànn nímá. A byar-à níng hi, mpìrká má swam yan zìnn Tamí, hár bá myàng yì wà ning í yann sukàmí big. ");
INSERT INTO jib_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Barà Tamí ri zìm mì níng, í barà mì má, mì ri zìm ning áni tìnn. Aning sìnn kà azìm-à mì ri zìm ning níng á pìkyinn ná ni. ");
INSERT INTO jib_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wà na wib hing jírmí, ná gàb fig dìr ma azìmmí bàna, àràg barà mì má ǹ wib sig jir Tamí, ǹ gàb fig dìr ma azìmwá bàna níng. ");
INSERT INTO jib_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mì ri dinya ning àdòníng, àjirà aning fig àjwár àràg barà mì ri fig níng. Ajwár-à hi aku shi hár kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wàníng í jírmí, aning zìm ba dìrná àràg barà mì ri zìm ning. ");
INSERT INTO jib_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mpìr-à ma ri zìm jàuwá hár ma ya hing yonkiwá á dò jir shinn jàuwá ni, azìm-à má kab wàníng hi bàna. ");
INSERT INTO jib_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wà na sa hing bu-à ǹ dinya sig ning níng, ná shi jàumí. ");
INSERT INTO jib_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Má bar fig rag ning fàu bàna, jir kai bàna fàu ri yì fig bu-à shinn luwá ri sa bàna. Ama má bar ning jàumí, jir kai bàna bu-à ǹ fig sig mà byar Tamí, ǹ dinya rìghing ning. ");
INSERT INTO jib_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ning shig fíg mì nì bàna, ama ǹ shig zu síg ning nì, ǹ ya sig ning gbam àjirà aning yag wan awan nìnànn nímá, awan-à hi aku shi nonn. A byar-à níng hi, Tamí má ya ning bu-à ná vig ku á zìnnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bu-à mì ri zìm aning sa í wàníng, aning zìm bar dìrná. ");
INSERT INTO jib_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kó mpìrká á dunyaru ma zib hing ning, aning kyab pànn rag big zib jag síg mì. ");
INSERT INTO jib_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wà ning nìm ma í bu dunyaru, mpìr dunyaru nìm má zìm ning. Ama jirà ning í bu dunyaru bàna, í bu-à sa mpìrká á dunyaru zìm fig ning bàna. Mì í àsàin-à shig zu sig ning. ");
INSERT INTO jib_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aning kyab pànn bu-à ǹ dinya sig ning, fàu má kab fig àsàin luwá bàna. Wà ba du kà mì shwìn, ning má bá du kà ning shwìn tìnn. Wà ba wib hing jírmí, bá wib jírná tìnn. ");
INSERT INTO jib_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mpìrká má ya ning shwìn jir shinnmí, jir kai bàna big yì fig mpìr-à swam bi sig mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wà ǹ nìm ma bi fig ma dinya fig big jír bàna, wàníng big nìm bàna ma bu pyìr, ama tàma-à níng big bàna ma pyù-à bá dang pinn zu shinnbá á jir bu pyìrbá ni. ");
INSERT INTO jib_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mpìr-à ma ngàng mì, ku ngàng hing Tamí tìnn. ");
INSERT INTO jib_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wà ǹ nìm ma sa fig bu-à kab gbam wà mpìrká má sa bàna, wàníng big nìm bàna ma bu pyìr. Ama tàma-à níng big myàng hing bu mamaki-à ǹ sa sig, ama hár tàma-à níng big ngàng mì ma Tamí tìnn. ");
INSERT INTO jib_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Big ngàng mì àdòníng, àjirà bu-à big ba sig á jir Shìdun ni aku shi àjai. Big ba sig rag, ‘Big ngàng sig mì átai, ǹ sa fig bu zyun bàna.’ ");
INSERT INTO jib_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ama má swam bi ya ning Awun Shìdun mà byar Shìdun. I Awun zyun-à má dinya ning jír àjai, kwá bi shang ning. Ku í àsàin-à má dang jír á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ning má, ná dang jír á shinnmí ni tìnn, jir kai bàna ning shi sig ma mì tìnn, sai-à wà jijag hár tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“N dinya sig ning bu káníng àjirà kada aning fim wà bir pìkyinn ná á byarmí ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bá kan zu ning mà tonn bìr kwonn-à ni. Ayúnn zyun ri bi wà mpìrká káhi má gban ning, bá kyab rag big ri sa swàm Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mpìr káníng má sa bu káníng, jir kai bàna big yì fig Tamí bàna, big yì fig mì bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama ǹ dinya sig ning bu káníng jirà wà àyúnn-à bu káníng ma sa hing, aning kyab pànn rag ǹ dinya hing ning. “N dinya jag fig ning jír káníng bàna, jir kai bàna yi ma ning shi sig í zyun. ");
INSERT INTO jib_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tàma-à níng ma kàng yag mà byarwá ni, ku zyun-à swam bi sig mì. Ayauná ni, kó mpìr ńzyun bib fig rag ma mì ri yag áni rà níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama jirà ǹ dinya sig ning àdòníng, í bu-à sa pìkyinn ná bai. ");
INSERT INTO jib_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mì ri dinya ning àjai, á jir shinn ná ni, sàn hing ń kàng yag, jir kai bàna wà ma yag fig bàna, Awun Shìdun zyun-à má sa shang ning níng, má bi fig bàna. Ama wà ma yag hing, má swam bi ku á byarná ni. ");
INSERT INTO jib_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wà kwa bi hing, kwá tìya mpìrká á dunyaru bu pyìrká big ri sa, ma buká Shìdun ri zìm, ma barà Shìdun má wà kwonnwá. ");
INSERT INTO jib_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jir bu pyìrká wà mpìrká ri sa, í bu-à sa big ngàng wà bá bir pìkyinnbá á byarmí ni. ");
INSERT INTO jib_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Big yì fig bu-à Shìdun ri zìm bàna, í bu-à sa ma kàng yag mà byar Tamí ni, ná myàng fig rag mì bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Big yì byann fig kwonn-à Shìdun má wà níng bàna, í bu-à sa Shìdun wà rìghing kwonn Shaitan àsàin-à í kùr dunyaru. ");
INSERT INTO jib_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N shi sig ma jírká nìnànn nímá, wà mì ri zìm ń dinya ning, ama ná pànn sar fig á pìkyinn ná ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ayúnn-à Awun Shìdun ma bi hing, kwá tàg ning jir àjai. Kwá sìnn kà ning aning yì gbìb àjai. Ku í Awun zyun-à ri dang jír àjai. Jírká kwá dinya ning níng, í jírwá bàna, ama í jírká ku fig sig mà byar Shìdun ni. Kwá dinya ning buká má bi á pyànn tìnn. ");
INSERT INTO jib_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kwá sa mpìrká abig wib jírmí, jir kai bàna kwá zìg bu-à ǹ dang sig níng, má dinya ning. ");
INSERT INTO jib_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Buká Tamí shi sig mà kàhi bidìm pár níng, í bumí. I bu-à sa ǹ dang rag, Awun Kyìkyàr-à níng má zìg bu-à ǹ dang sig níng, má dinya ning. ");
INSERT INTO jib_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Tàma-à níng á pyànn áyag, ná myàng fig rag mì bàna, ama á pyànn títi nímá ná myàng jakàng mì.” ");
INSERT INTO jib_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yann sukàká káhi bib bar dìrbá n rag, “Ma mpìr-à níng ri dang í kai rà? Ku dinya yi rag, á pyànn áyag yá myàng fig ku bàna, ama á pyànn títi nímá yá myàng jakàng ku. Ku dang jakàng n rag, í jirà ku ri yag mà byar Tawá ni.” ");
INSERT INTO jib_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Big shi mi ri kyab á pìkyinnbá ni n rag, “A pyànn-à níng yìrwá í kai rà? Yi yì fig bu-à ku ri dang níng bàna.” ");
INSERT INTO jib_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu yì rìghing big ri zìm abig bib ku abib, í byar-à ku dinya big n rag, “N dang rag á pyànn áyag ná myàng fig rag mì bàna, ama á pyànn títi nímá, ná myàng mì. Wàníng bu-à ǹ dang sig níng, í bu-à sa ning ri bib dìrná níng rà? ");
INSERT INTO jib_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mì ri dinya ning àjai, pìkyinn ná má bai hár ná kig mínn, ama mpìrká á dunyaru má fig àjwár. Ná bai pìkyinn, ama pìkyinn bainá má kàng bu àjwár. ");
INSERT INTO jib_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Asai-à uwà ma nyàan mà, kwá fig àwá wàni, jir kai bàna ku nyàan mà. Ama kwa mà hing, kwá fig àjwár, kwá màm jànn rìg shwìn-à ku rì wa sig, jir kai bàna ku mà zu rìghing wùnwá. ");
INSERT INTO jib_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wàníng í barà ning shi sig áni. Ning tàma-à níng, pìkyinn ná ri bai, ama má myàng jakàng ning, àjirà a pìkyinn ná fig àjwár. Ajwár-à níng hi, mpìr má zìg fig á byarná ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ayúnn-à níng hi, ná vig fig rag mì bu zyun bàna. Mì ri dinya ning àjai, Tamí má ya ning kó kai wà na vig hing ku á zìnnmí ni. ");
INSERT INTO jib_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hár tàma-à níng, ning vig fig ma bu zyun á zìnnmí ni bàna. Aning vig, ná dìg àjirà pìkyinn ná aku fig àjwár wàni. ");
INSERT INTO jib_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mì ri dinya ning jír káníng àràg í tinn jír. Ama àyúnn zyun ri bi wà má dang fig rag ma tinn jír bàna. Ayúnn-à níng hi, má dinya byann ning jír á shinn Tamí ni. ");
INSERT INTO jib_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ayúnn-à níng hi ma sa hing, ná vig Shìdun á zìnnmí ni. Ama mì ri dang fig rag í mì má vig yá ning nì bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tamí ma shinnwá, ku ri zìm ning tìnn, jir kai bàna ning ri zìm mì hár n bir hing pìkyinn ná á byarmí ni n rag, ǹ bi sig mà byarwá ni. ");
INSERT INTO jib_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N bi sig mà byar Tamí ni, í wà ǹ bi kà á dunyaru, tàma-à níng má fim dunyaru má kàng yag mà byar Tamí ni.” ");
INSERT INTO jib_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A byar-à níng hi, yann sukàká buwá dinya ku n rag, “Tàma-à níng wù ri dang byann jírwú, wù ri dang fig rag tinn jír bàna. ");
INSERT INTO jib_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yi yì hing tàma-à níng à yì hing kó kai bidìm pár. A yì hing bu-à mpìrká ri kyab á pìkyinnbá ni, kó barà big dang fig bàna níng. Wàníng í bu-à sa yi yì rag à bi síg mà byar Shìdun ni.” ");
INSERT INTO jib_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu bib big rag, “Tàma-à níng, ning bir rag hing pìkyinn ná rà? ");
INSERT INTO jib_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ayúnn zyun ri bi, hár àyúnn-à hi fòr bi rìghing, wà ning yann sukàmí big ná yam fim rìg awín awín bidìm pár, ná kàng yag mà luná ni, ná fim mì awínmí ni, ama ǹ shi fig awínmí ni bàna, jir kai bàna yi ma Tamí shi sig í zyun. ");
INSERT INTO jib_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","N dinya rìghing ning jír káníng, jir kai bàna á jir shinnmí ni ná fig àjwár. Ná wa shwìn á dunyaru-à níng ni, ama aning shàr zinn bàna, jir kai bàna ǹ kab rìghing gbam buká á dunyaru.” ");
INSERT INTO jib_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Barà Yesu dang vinn rìg jír káníng àdòníng, sái ku myàng yag zuwá mà wai, n dang rag, “Tamí, àyúnn-à màg hing wà wá swam yan wùnwú, àjirà wùnwú aku swam yan wù tìnn. ");
INSERT INTO jib_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A ya sig wùnwú gbam á shinn mpìrká ni bidìm pár, àjirà aku ya mpìrká zyun-à à ya sig ku níng yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yìr yonki kinn kinn-à níng í jirà mpìrká abig yì wù, abig yì wù í Shìdun àjai, ma abig yì mì í Yesu Kristi zyun-à à swam bi sig. ");
INSERT INTO jib_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N tìya hing mpìrká gbamwú á dunyaru. N sa vinn rìghing swàm-à à ya sig mì ń sa. ");
INSERT INTO jib_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamí, tàma-à níng mì ri zìm á tìya mpìrká gbammí, gbam-à yi ma wù rì shi sig ma kàhi á sai-à wù rì màm fig ma dunyaru bàna níng. ");
INSERT INTO jib_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“N tìya hing mpìrká buwú zyun-à à ya sig mì á dunyaru níng big yì hing wù. Big í buwú, à ya kà sig big á vùmí ni. Big ri wib jírwú. ");
INSERT INTO jib_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tàma-à níng mpìr káníng yì rag hing rag, buká à ya sig mì níng, bi síg á byarwú ni. ");
INSERT INTO jib_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","N dinya hing mpìr káníng jírká zyun-à à dinya sig mì. Big fig hing jírká hi, big zìm hing á pìkyinnbá ni. Big yì hing í àjai ǹ bi síg mà byarwú ni. Big bir hing pìkyinnbá n rag, í wù à swam bi síg mì nì. ");
INSERT INTO jib_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Tamí, mì ri vig wù á shinnbá ni. Mì ri vig fig wù á shinn mpìrká ri bàg dunyaru bàna, ama á shinn mpìrká zyun-à à ya sig mì, jir kai bàna big í buwú. ");
INSERT INTO jib_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mpìrká ǹ shi sig ma kàhi níng, í buwú. Buwú í bumí tìnn. Mpìrká ri swam yan mì á jir shinnbá ni. ");
INSERT INTO jib_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tàma-à níng mì ri kàng yag mà byarwú ni, má shi fig rag á dunyaru bàna. Ama mpìrká buwú shi sig á dunyaru. Tamí wà kyìkyàr, á kang big ma gbam zìnnwú zyun-à à ya sig mì, àjirà abig shi í bu ńzyun àràg barà yi ma wù shi sig í bu ńzyun níng. ");
INSERT INTO jib_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Asai-à ǹ shi sig ma big níng, mì ri kang big ma gbam zìnnwú zyun-à à ya sig mì. Ayau mpìr káníng ni, kó mpìr ńzyun jànn fig bàna, sái mpìr àbai-à níng, zyun-à má jànn á pyànn níng, àjirà jírwú aku shi àràg barà big ba sig. ");
INSERT INTO jib_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tàma-à níng, mì ri yag á byarwú ni, ama mì ri dang bu káníng ásai-à ǹ shi sig má á dunyaru, jirà abig fig àjwár wàni á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N dinya hing big jírwú, mpìrká á dunyaru ngàng big, jir kai bàna big í bu dunyaru bàna, àràg barà mì má, mì í bu dunyaru bàna níng. ");
INSERT INTO jib_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mì ri vig fíg wù àjirà á zìg zu big á dunyaru bàna, ama àjirà á kang big jirà kada a Shaitan dìg big bàna. ");
INSERT INTO jib_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Big shi fig í bu dunyaru bàna, àràg barà mì má, mì í bu dunyaru bàna níng. ");
INSERT INTO jib_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","A sa jírwú zyun-à í jir gwangga níng, aku sìnn kà big abig shi kyìkyàr. ");
INSERT INTO jib_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Barà à swam bi sig mì á dunyaru-à níng, í barà mì má ǹ swam yag sig big á byarká á dunyaru tìnn. ");
INSERT INTO jib_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A jir shinnbá ni, mì ri ya kà shinnmí á byarwú ni, àjirà abig shi mpìrká kyìkyàr áyau gbìb àjai. ");
INSERT INTO jib_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mì ri vig fíg wù íri jir shinn yann sukàmí big bàna, ama mì ri vig wù á shinn ká má fig jírká zyun-à yann sukàmí big má dang, má bir pìkyinnbá áni. ");
INSERT INTO jib_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mì ri vig wù jirà abig shi í bu ńzyun àràg barà wù Tamí à shi sig ma mì, mì má ǹ shi sig ma wù níng. Abig shi kwonn áyauyí ni àjirà mpìrká á dunyaru abig yì rag à swam bi síg mì nì. ");
INSERT INTO jib_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N ya hing big gbam-à à ya sig mì àjirà abig shi í bu ńzyun àràg barà yi ma wù í bu ńzyun níng. ");
INSERT INTO jib_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mì áyaubá ni, wù bó, wù áyaumí ni, àjirà abig shi í bu ńzyun, àjirà mpìrká á dunyaru abig yì rag à swam bi síg mì nì ma abig yì rag wù ri zìm big àràg barà wù ri zìm mì níng. ");
INSERT INTO jib_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamí, mì ri zìm mpìrká à ya sig mì níng, abig shi kwonn ma mì mà byar-à má shi, àjirà abig myàng gbammí, gbam-à à ya sig mì, jir kai bàna wù ri zìm mì á sai-à big rì màm fig ma dunyaru bàna. ");
INSERT INTO jib_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamí, wù í àsàin-à ri sa bu ǹsàn, mpìrká á dunyaru yì fig wù bàna, ama ǹ yì hing wù. Ama big yì hing rag í wù à swam bi síg mì ni. ");
INSERT INTO jib_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N sa big yì hing wù, má shi sa àdòníng àjirà abig yì swàb kà wù, jir kai bàna azìm-à wù ri zìm mì níng, aku shi á byarbá ni, mì má ń shi áyaubá ni tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Barà Yesu dang vinn rìg jírwá àdòníng, sái ku í pìm zu yag rìg-à ma yann sukàwá big mà jann mà asàu Kidurun, ku ma yann sukàwá big yag síg zyun mà da-à hi ni màhàn. ");
INSERT INTO jib_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda àsàin-à gib sig mìr Yesu níng yì rìghing byar-à hi, jir kai bàna Yesu ma yann sukàwá big ri yag kyann màhàn. ");
INSERT INTO jib_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","I byar-à Yahuda zìg yag mpìrká mà da-à hi ni, ku zìg yag sig kyau mpìr nìnànn nímá. Agbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ma Farisawaká swam yag mpìrká ri sar myàng kwonn ma lu Shìdun, abig bàg yag Yahuda. Sojaká yag sig tìnn. Big yag fòr màhàn, big pànn kwonn sig ma pitila ma àkìm yinn ma bu àsháu big í zyun tìnn. ");
INSERT INTO jib_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu yì vinn rìghing bu-à mpìr káníng má sa ma ku, ku sar yag á pyànnbá ni n bib big rag, big ri yàn kyann í ni rà? ");
INSERT INTO jib_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Big dang rag, big ri yàn kyann í Yesu mpìr-à á Nazarat. Ku dang rag, “Ai í mì!” Yahuda zyun-à wann tafinn sig ku níng shi sig áyau mpìr káníng ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Barà Yesu dinya big rag, ai í ku, sái mpìr káníng kàng ma kwìm mìr, n yag kù wann á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sái ku bib jakàng káníng jír wà wa pyànà, n rag, “Ning ri yàn kyann í ni rà?” Big dang rag, “Yi ri yàn kyann í Yesu mpìr-à á Nazarat.” ");
INSERT INTO jib_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu dinya big n rag, “Ai ǹ dinya ning rag í mì, wà na ri yàn kyann í mì, aning fim mpìr káníng abig kàng yag.” ");
INSERT INTO jib_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ku dang jír-à níng àjirà buká ku rì dang sig níng má shi àdòníng, barà ku rì dang sig rag, “Tamí, áyau mpìrká à ya sig mì níng, kó mpìr ńzyun má jànn fig bàna.” ");
INSERT INTO jib_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sái Bitrus gbar wàm zu kafai á pyirwá ni, n kyag fàu-à níng, n kyag zu rìg sung vìm nu wàníng ma kàhi. Fàu-à hi àsàin luwá í àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni. Zìnnwá í Malkus. ");
INSERT INTO jib_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","I byar-à Yesu dinya Bitrus n rag, “A du kà kàng rìg kafai-à níng á pyirwá ni. A zìm fig wà ń wa shwìn-à Tamí dang sig níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","I byar-à hi, sái kyau sojaká ma mpìrká ri sar kang lu Shìdun pànn rìg Yesu, n sìr ku ma jùr. ");
INSERT INTO jib_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Big zìg yag jag ku mà byar Hanana, jir kai bàna wàníng í jwau Kayafa zyun-à í àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni á ji-à níng hi. ");
INSERT INTO jib_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nonn fig bàna, sái Kayafa dinya mpìr Yahudawaká n rag, “Sàn sig wà mpìr ńzyun aku wu á dò shinn mpìrká bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","I byar-à Bitrus ma wùn sukà zyun kan bàg yag Yesu. Wùn sukà zyun-à níng hi, àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng yì rìghing ku. I byar-à ku kà yag ma Yesu í zyun mà byar Kayafa. Ama Bitrus shi sig á myann. ");
INSERT INTO jib_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wùn sukà zyun-à Kayafa yì sig níng, ku zu yag mà myann n yag bar bi Bitrus. Ku dang jír ma wùn uwà-à ri sa gadi-à á nu nkyun-à ni níng, í wà wùn uwà-à níng fim Bitrus í kà yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Uwà-à ri sa swàm á nu nkyun lu-à ni níng, dinya Bitrus n rag, “Wù má wù í wùn sukà Yesu rà?” Ku dang rag, ku í wùn sukà Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sai-à hi, wàu ri tag. Yann luká ma mpìrká ri sa gadi níng tai swànn sig pyìr, n sar kàng kwìb sig áni, mi ri jwar. Bitrus sar sig màhàn, mi ri jwar pyìr-à hi ma big tìnn. ");
INSERT INTO jib_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sái àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, bib Yesu jír á shinn yann sukàwá big, n bib ku jír á shinn bu tàgwá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","I byar-à Yesu dinya ku n rag, “Ai mì ri dinya bìr mpìrká jír, mì ri dang tàm fig á dang tàm bàna, mì ri dang á yiyar-à ni. N nonn hing, mì ri tàg mpìrká bu á lu Shìdun, mì ri tàg mpìrká bu á tonn bìr kwonn tìnn, mì ri dang tàm fig kó kai bàna. ");
INSERT INTO jib_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bu-à sa wù ri bib mì í jir kai rà? A bib mpìrká mì ri dinya kyann big jír-à níng, abig dinya wù bu-à mì ri dinya kyann big. Ai big yì rìghing bu-à mì ri tàg kyann big.” ");
INSERT INTO jib_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Barà ku dang àdòníng, mpìr zyun-à ri myàng kwonn ma lu Shìdun níng dab ku gbàr n dang rag, “Wàníng í barà wá zìm ya àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni jír áni rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","I byar-à Yesu dinya ku n rag, “Wà ma dang hing bu-à ma sàn fig bàna, á dang bu-à ǹ sa sig. Ama jírmí ma bai fig bàna, to, bu-à sa à dab mì níng í jir kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","I barà big sìr sig Yesu á jùr, í wà Hanana tìr yag ku mà byar Kayafa, wàníng í àgbam áyau mpìrká ri twìb swànn bu á pyann Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Barà Bitrus sar sig mi ri jwar pyìr, í byar-à big bib ku n rag, “Wù má, wù í wùn sukà Yesu rà?” Ku sa yipyàr n dang rag, ku í wùn sukà Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Fàu àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, dang rag, “N nìm myàng fig wù ma ku mà da-à ni bàna rà?” Wàníng í yiwai mpìr-à Bitrus kyag zu bab sig sungwá níng. ");
INSERT INTO jib_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sái Bitrus sa jakàng yipyàr n rag “Wíi!” Barà ku dang àdòníng sái shi kwìnn dab aku. ");
INSERT INTO jib_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","I byar-à hi big zìg yag Yesu mà lu Kayafa, n zìg yag ku mà byar gwamna. I pyimbyau Yahudawaká kà fig mà tonn-à byar-à bá dang jír-à hi bàna, jir kai bàna gwamna-à hi í mpìr Yahudawaká bàna, big ri shàr kada abig sa bai shinnbá. Ba sa bai hing shinnbá, bá ji fig buju àyúnn Pìm Wam Zu bàna. ");
INSERT INTO jib_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","I byar-à Bilatus zu bi á myann n bib big rag, “Ning zìg bi sig í jir kai á shinn wunù-à níng ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","I byar-à big dinya ku rag, “Mpìr-à níng nìm ma sa fig bu-à bibai bàna, yi nìm má zìg bi fig ku á pyànnwú ni bàna.” ");
INSERT INTO jib_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sái Bilatus dinya big rag, “Aning zìg yag ku ma shinn ná, aning wà ku kwonn-à ning ri zìm á gbìb dokaná ni.” I wà Yahudawaká dinya ku rag, “Ai yi bàna ma gbam-à yá wà kwonn á shinn wà abig gban mpìr.” ");
INSERT INTO jib_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bu káníng sa sig àràg barà Yesu rì dang sig á shinn swai ki-à kwá wu. ");
INSERT INTO jib_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","I byar-à Bilatus í kà kàng yag rìg-à mà luwá ni, n bar Yesu, n bib wàníng rag, “Wù í kùr Yahudawaká rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sái Yesu bib ku rag, “Bu-à wù ri dang níng, wù ri dang nì ma shinnwú rà, kó big dinya sig wù àdinya á shinnmí ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","I byar-à Bilatus dinya ku rag, “Mì í mpìr Yahudawa bàna, í mpìrká buwú big ma àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni pànn zìg bi síg wù í ni á pyànnmí ni, à sa sig í kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","I byar-à Yesu dinya ku rag, “Kùrmí má na níng, shi fig àràg wà á dunyaru bàna. Wà kùrmí má na níng nìm ma shi síg àràg wà á dunyaru, fàumí big nìm má nu kànn, Yahudawaká nìm má pànn sar fig mì bàna. Ama bu-à sa níng, kùrmí í kùr byar zyun kim.” ");
INSERT INTO jib_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","I byar-à Bilatus bib ku rag, “Asái wù í kùr rà?” I wà Yesu zìm n rag, “Aràg barà à dang níng, mì í kùr àjai, jir kai bàna ǹ bi sig á jànn-à ni, jirà ń dinya mpìrká jír àjai, jirà kó ni ma ri bàg jír àjai, kwá fig jírmí.” ");
INSERT INTO jib_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sái Bilatus bib ku n rag, “I kai má shi jír àjai rà?” Barà ku bib jír-à níng, sái ku í zu bi rìg-à á myann á byar mpìr Yahudawaká ni, n dinya big n rag, “N pànn fig Yesu ma jír bibai bàna. ");
INSERT INTO jib_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama ning shi sig ma àyúnn ùwài zyun, big ri bar rag, ‘I àyúnn Pìm Wam Zu,’ wà zyun-à sàn sig àyúnn-à níng hi ń fìnn zu ya ning mpìr pursina zyun àràg barà yi ri sa kyann. Ning ri zìm ń fìnn zu ya ning kùr Yahudawaká rà?” ");
INSERT INTO jib_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Big wa nài yán n dang rag, “A fìnn tafinn zu Yesu bàna, á fìnn tafinn zu Barabas.” Barabas í mpìr-à sa big nu kànn n gbam sig ki wàni. ");
INSERT INTO jib_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sái Bilatus sìnn kà mpìrká abig yang Yesu ashor. ");
INSERT INTO jib_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojaká tànn àkar sí, àràg jà big ri kàm bu kàm shinn kùr ma kàhi, n bir kà Yesu á shinn-à ni. Big wìr sig ku jà bá gbàinshìn àràg ku í kùr. ");
INSERT INTO jib_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","I wà big màm jwann ku, n dang rag, “Suwú aku yag mà pyànn, wù kùr Yahudawaká.” Big fam ku vù sung kyìr. ");
INSERT INTO jib_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","I byar-à Bilatus zu yag jakàng mà myann, n dinya bìr mpìrká sar sig níng n rag, “Aning myàng, má zìg zu bi ku á myann áyag, àjirà aning yì rag ku sa fig bu-à bibai wà bá gban ku áni bàna.” ");
INSERT INTO jib_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sái Yesu zu yag mà myann ma bu kàm shinn sí-à níng, ma jà bá gbàinshìn. I byar-à Bilatus dinya big rag, “Aning myàng wàníng í wunù-à hi.” ");
INSERT INTO jib_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Barà àgbamká áyau mpìrká ri twìb swànn bu á lu Shìdun ni, ma mpìrká ri sar kang lu Shìdun myàng ku, big dang rag, “A dab bàg gbam ku, á dab bàg gbam ku á bín-à ni.” Bilatus dang rag, buwá kwá dab bàg gbam fig Yesu bàna, ama bigbá abig bi zìg wàníng, ma abig dab bàg gbam, jir kai bàna ku myàng fig bu-à wàníng sa sig wà bá gban wàníng bàna. ");
INSERT INTO jib_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sái Yahudawaká dinya kàng ku, n rag, “Yi shi sig ma doka zyun-à dang sig rag, abig gban rìg ku, jir kai bàna ku dang rag ku í Wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Barà Bilatus fig big dang àdòníng, sái zinn pànn swàb kà rìg ku tìnn. ");
INSERT INTO jib_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bilatus kà kàng yag mà luwá ni, n bib jakàng Yesu jír n rag wàníng bi sig áni rà? Ama Yesu dinya fig ku jír bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sái Bilatus bib ku rag, “Wá dinya fig mì bàna rà? Asai à yì fig wà ǹ shi sig ma gbam á shinn bu-à má sa bàna rà? Kó ma dang rag má fim wù, má fim wù. Kó ma dang rag má dab bàg gbam rìg wù, má dab bàg gbam rìg wù.” ");
INSERT INTO jib_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu dang rag, “A bàna ma gbam á shinnmí ni, sái Shìdun ma ya hing wù. Jir wàníng mpìr-à ya kà sig mì á vùwú ni níng, kab wù ma bu-à bibai sa.” ");
INSERT INTO jib_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Barà Bilatus fig àdòníng, ku ri zìm aku sa pyù-à aku fìnn tafinn Yesu. Ama Yahudawaká yan nài yán n dang rag, “Wà wa sa hing àdòníng, wù í jàu kùr Kaisar bàna. Bara Yesu dang rag ku í kùr níng, ku ri sa kùr Kaisar yawari.” ");
INSERT INTO jib_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Barà Bilatus fig àdòníng, ku zìg yag Yesu mà myann mà byar-à big dab jann sig, í byar-à big ri gib jír, big ri bar byar-à hi á nu jir Yahudawaká ni rag, í Gabbata. ");
INSERT INTO jib_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ayúnn-à níng hi, byar-à ma kyàr hing í àyúnn Pìm Wam Zu. Ayúnn-à fòr rìghing áyau shinn, sái Bilatus dinya mpìr Yahudawaká n rag, kùrbá shi sig níng. ");
INSERT INTO jib_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","I byar-à hi, big wa nài yán n dang rag, “Abig gban rìg ku. Abig gban rìg ku. Abig dab bàg gbam rìg ku á bín-à ni.” Bilatus bib big rag, “Ning ri zìm ń dab bàg gbam kùrná rà?” I byar-à hi, àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni zìm, n dinya ku rag, “Yi bàna ma kùr zyun, sái kùr Kaisar.” ");
INSERT INTO jib_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","I byar-à hi ku zìg Yesu n ya big, abig dab bàg gbam wàníng á bín-à ni. Sojaká ri sar myàng kwonn ma ku í zyun. ");
INSERT INTO jib_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sái big sìnn kà ku aku swann zìg yag kwonn ma bín-à bá dab bàg gbam ku ma kàhi á byar-à big ri bar rag Akib Shinn. (A nu jir Yahudawaká ni big ri bar Golgota). ");
INSERT INTO jib_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A byar-à hi, big dab bàg gbam kwonn ku ma mpìr pyànà. Yesu shi kà sig buwá áyau-à ni, mpìr zyun shi sig buwá á agunn vìm nuwá ni, zyun shi sig á agunn vìm súrwá ni tìnn. ");
INSERT INTO jib_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus ba sìnn sig bu màhàn, n kànn bàg sig mà byar-à big dab bàg gbam sig Yesu níng, bu-à hi big ba sig n rag, “Yesu í mpìr-à á Nazarat, í kùr Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudawaká nìnànn nímá jangga hing bu-à big ba sìnn sig níng. Bu-à sa níng, byar-à big dab bàg gbam sig Yesu níng, nonn fig ma finn swann-à bàna. Big ba sig bu-à hi á nu jir Yahudawaká ni, ma nu jir Romawaká, ma nu jir Helenawaká. ");
INSERT INTO jib_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sái àgbamká áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, big dinya Bilatus rag, kada aku ba rag, “Yesu í kùr Yahudawaká” bàna, ama aku ba rag, “Wàníng dang rag wàníng í kùr Yahudawaká.” ");
INSERT INTO jib_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus dang rag, “Bu-à ǹ ba sig níng, shi rìghing.” ");
INSERT INTO jib_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Barà sojaká dab bàg gbam Yesu, big zìg jàwá, n gàfinn kyau yina. Kyau zyun í bu soja zyun, zyun í bu soja zyun tìnn. Big gàfinn àdòníng, shinnbá big yina big dìg vinn rìg. Ama dà sig í jà wùwài zyun-à big kwìb fig á kwìb bàna, big zwàu síg káhi á zwàu. ");
INSERT INTO jib_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","I byar-à big dinya bar dìrbá rag, “Kada ayi gbar ka jà-à níng átai bàna. Ama bu-à sàn sig ayi sa bàna, ayi dab shasha, mpìr-à ma ji hing aku zìg jà-à níng.” Sa sig àràg barà jir Shìdun dang sig n rag, “Bá zìg jàmí má gàfinn ya shinnbá, bá dab shasha jirà abig dab ji jà wùwàimí ni.” Wàníng í bu-à sojaká sa sig. ");
INSERT INTO jib_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Uwàká káhi sar sig á pyànn byar-à big dab bàg gbam sig Yesu níng, zyun í na Yesu, ma nàtí Yesu, ma Maryamu wà Kilofas, ma Maryamu Magdaliya. ");
INSERT INTO jib_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Barà Yesu myàng nàwá, ma wùn sukàwá zyun-à ku zìm kab sig, sar sig, ku dinya nàwá rag, “Wàníng í wùnwú!” ");
INSERT INTO jib_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I wà ku dinya wùn sukàwá n rag, “Wàníng í nàwú!” I byar-à hi, wùn sukà-à níng zìg yag na Yesu mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu yì rìghing kó kai sa n vinn rìghing. I wà ku dang rag, ku ri fig ajor zàpìr. Ku dang sig àdòníng àjirà jir Shìdun aku shi àràg barà big ba sig. ");
INSERT INTO jib_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Akwìnn zyun shi sig màhàn, big wìr mònn sig zàn àban áni. I byar-à hi, big lir kà sig soso áni, n pa kà sig á bín zyun ni. Big zìg n du kà Yesu á nu-à ni. ");
INSERT INTO jib_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Barà Yesu wa zàn àban-à níng, ku dang rag, “Tàma-à níng kó kai vinn rìghing.” Sai ku í kab wann rìg-à wàinwá. Ku í wu rìg-à. ");
INSERT INTO jib_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Barà big yì hing rag byar-à kyàr í àyúnn wùwài, í àyúnn shi ngàng, kada abig fim ki mpìr káníng á bín-à ni bàna. I wà Yahudawaká yag n vig Bilatus abig ta kìm rìg barbá, ma àjirà abig wu rìg kíni, abig zìg tìg wann big á jìnn ni. ");
INSERT INTO jib_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","I byar-à sojaká bi, n ta kìm rìg bar mpìr pyànàká big dab bàg gbam sig ma Yesu. ");
INSERT INTO jib_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama big bi fòr á byar Yesu ni, n myàng ku wu rìghing. Big ta kìm fig barwá bàna. ");
INSERT INTO jib_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ayau soja káníng ni, zyun zìg sau, n winn Yesu ma kàhi á gàu-à ni, sái àsà ma zàpìr zu á dìrwá ni. ");
INSERT INTO jib_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mpìr-à myàng sig bu káníng, ku dinya hing ning barà sa sig áni, jirà aning bir pìkyinn ná áni. Jírwá í jir àjai. Ku yì rìghing bu-à ku dinya sig ning níng í jír àjai. ");
INSERT INTO jib_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wàníng sa sig àdòníng jirà jir Shìdun aku sa àràg barà ku dang sig rag, “Akibwá kó ńzyun abig ta kìm bàna.” ");
INSERT INTO jib_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Byar zyun ku dang sig rag, “Mpìrká má myàng mpìr-à big winn sig níng.” ");
INSERT INTO jib_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mpìr zyun shi sig áni, big ri bar ku Yusufu, ku í mpìr-à mà finn swann Arimatiya. Ku ri bònn bàg Yesu, bu-à sa níng ku ri shàr zinn Yahudawaká. Ku vig Bilatus ki Yesu. I wà Bilatus dang rag tò aku yag zìg. I byar-à ku yag zìg. ");
INSERT INTO jib_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ku ma Nikodimu yag sig í zyun. I Nikodimu zyun-à rì yag sig mà byar Yesu ni á fi-à ni níng. Nikodimu pànn yag kwonn sig ma mur big vù kwonn sig ma alu, í bu-à big ri pàb ki á dìr. Bu-à hi má sa àràg tasa dari zyun. ");
INSERT INTO jib_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","I byar-à Yusufu ma Nikodimu zìg ki Yesu, n pàb ku bu-à níng hi á dìr-à ni, n bing kà ku á jà mìmìg, àràg barà Yahudawaká ri sa kyann sai-à bá jì kibá. ");
INSERT INTO jib_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Byar-à bá jì ku níng, da shi sig màhàn, mà da-à hi ni amir zyun shi sig áni big jì fig ma mpìr áni bàna. ");
INSERT INTO jib_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Amir-à hi shi yàr sig mà byar-à big shi sig. Barà í àyúnn-à Yahudawaká má sa vinn swàmbá áni, jirà abig shi ngàng àyúnn Asabar byar-à kyàr níng, í byar-à big zìg ki Yesu n yag sìnn kà áni. ");
INSERT INTO jib_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ayúnn Ladi í pyimbyau yìyì nímá bu yar fig ma bàna, sái Maryamu Magdaliya yag mà amir-à ni. Ku myàng abàn-à á nu amir-à ni big tìr dù rìghing. ");
INSERT INTO jib_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ku shàr kàng bi mà shàu á byar Bitrus ma wùn sukà Yesu zyun-à Yesu ri zìm wàni. Ku dinya káníng rag, “Big zìg zu rìghing Shinn Luyí mà amir-à ni, yi yì fig byar-à big sìnn sig kiwá bàna.” ");
INSERT INTO jib_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sái Bitrus ma wùn sukà-à hi dù n yag mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Big pyànà bidìm pár, big shàr yag ma shàu, ama wùn sukà-à níng shàr kab Bitrus í ni, n yag fòr jag rìg ku mà byar amir-à ni. ");
INSERT INTO jib_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wùn sukà-à níng bìnn kir wann, n da myàng kà yag zuwá, ku myàng sig íri jà-à big bing kà sig Yesu áni níng, ama ku kà yag fig mà amir-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","I byar-à Bitrus bi ásimwá ni, n kà yag mà shar amir-à ni, ku myàng jà-à big sìnn kà sig Yesu áni níng, wan wìr wann sig mà yau mà finn amir-à hi ni màhàn. ");
INSERT INTO jib_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jà-à big bing kà sig shinn Yesu áni níng, wan wìr wann fig á jà-à big sìnn kà sig ku áni níng bàna, ama wan wìr wann sig byar zyun kim. ");
INSERT INTO jib_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wùn sukà zyun-à nìm yag fòr jag sig mà amir-à ni níng, kà yag mà yau tìnn. Ku myàng n bir pìkyinn. ");
INSERT INTO jib_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A sai-à níng hi, big yì byann fig wà jir Shìdun dang rag, wàníng má wu, má dù nann zu kàng ma yonki níng bàna. ");
INSERT INTO jib_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","I byar-à yann sukàwá big kàng yag rìg mà lu-à ni. ");
INSERT INTO jib_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu sar sig mà nu nkyun amir-à ni mà myann, mi ri kig. Ku kir wann n myàng kà yag amir-à. ");
INSERT INTO jib_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","I byar-à ku myàng yann aswamká bu Shìdun mà wai pyànà sar sig màhàn ma jà mìmìg á byar-à big jì sig Yesu Kristi. Zyun sar sig á agunn-à và dun, zyun sar sig á agunn-à và tài. ");
INSERT INTO jib_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","I byar-à big dinya ku rag, “Uwà-à níng, wù ri kig í kai rà?” Ku dinya káníng rag, “Ai big zìg rìghing Shinn Luyí, ǹ yì fig byar-à big zìg yag sig ku bàna.” ");
INSERT INTO jib_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Barà ku dang jír-à níng, n sar vim bìr bi àdòníng, sái ku myàng Yesu sar sig ásimwá ni, ama ku yì fig wà í wàníng bàna. ");
INSERT INTO jib_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu bib ku n rag, “Uwà-à níng, wù ri kig í kai rà? Wù ri yàn kyann í ni rà?” Ku dang rag, “Wà wa zìg sig dìr Yesu í ni, á tìya mì byar-à à sìnn sig, jirà ń yag zìg.” (Ku ri kyab rag, kó wàníng í mpìr-à ri myàng kwonn ma da-à hi.) ");
INSERT INTO jib_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu bar ku n rag, “Maryamu!” Ku myàng kàng bi zuwá, n bar wàníng á nu jir Yahudawaká ni, n rag, “Rabboni!” Yìr jír-à níng í malam. ");
INSERT INTO jib_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu dinya ku rag, “A pànn mì bàna, ǹ nai yag fig ma mà byar Tamí ni bàna. Ama á yag mà byar yann sukàká bumí ni, á dinya big, mì ri nai yag mà byar Tamí ni, í Tabá tìnn. I Shìdunmí, í Shìdunbá tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","I byar-à Maryamu Magdaliya yag, n dinya yann sukàwá big n rag, ai ku myàng hing Yesu, wàníng dinya hing ku jír-à níng. ");
INSERT INTO jib_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ayúnn Ladi àkamzau yann sukà Yesu big shi sig mà tonn-à ni, n kìg dim rìghing nu nkyun-à, jir kai bàna big ri shàr zinn àgbam mpìr Yahudawaká. I byar-à Yesu bi n sar kà áyaubá ni, n dinya big rag abig shi ítau. ");
INSERT INTO jib_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Barà ku dinya big àdòníng, ku tìya big vùwá ma gàuwá tìnn, sái yann sukàwá big fig àjwár barà big myàng yì wà í Yesu. ");
INSERT INTO jib_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sái Yesu dinya jakàng big n rag, “Aning shi ítau. Barà Tamí swam bi sig mì níng, í barà má swam yag ning àdòníng tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Barà ku dang àdòníng, sái ku vinn yag káníng wàu, n dang rag, “Aning zìg Awun Kyìkyàr Shìdun. ");
INSERT INTO jib_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mpìrká na yafa ya big bu bibaibá, Shìdun yafa rìghing big, ama mpìrká na yafa ya fig big bu bibaibá bàna, Shìdun má yafa ya fig big bàna tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, í wùn sukà zyun áyau yann sukàká bu Yesu Kristi, ku í wùn ǹtài, ku bàna áyaubá ni sai-à Yesu bi níng. ");
INSERT INTO jib_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sái jàuwá big dinya ku n rag, big myàng hing Yesu. Ku dinya káníng n rag, sái kwa myàng hing àbànn kusa-à big dab bàg gbam sig wàníng á vù-à ni níng, kwa du kà hing pwai vùwá áni ḿpyim, kwa pàb hing gàu wàníng tìnn, í wà kwá ni zìm rag àjai. Wà ma í nímá bàna, kwá bir fig pìkyinn áni bàna. ");
INSERT INTO jib_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sai-à big dang jír-à níng fòr hing su awinyin, í byar-à yann sukàká kà jakàng mà tonn-à ni. Toma kà áyaubá ni tìnn. Big kìg dim rìghing nu nkyun-à big shi sig áni níng. I byar-à Yesu kà bi á byar-à big shi sig níng, ku ma káníng shi sig í zyun. Ku dinya káníng rag, abig shi ítau. ");
INSERT INTO jib_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ku dang jír ma Toma, ku rag, “A du kà pwai vùwú áyág, á myàng wàníng í vùmí, á zìg bi vùwú, á tib á gàu dìrmí, kada á sa rag yipyàr bàna. Ama bu-à mì ri zìm, á bir pìkyinnwú á byarmí ni.” ");
INSERT INTO jib_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","I byar-à Toma dang rag, “Wù í Shinn Lumí, wù í Shìdunmí tìnn.” ");
INSERT INTO jib_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","I byar-à Yesu bib ku rag, “I jirà à myàng sig mì, í bu-à sa à bir sig pìkyinnwú á byarmí ni rà? Shìdun má ya mpìrká myàng fig mì bàna, ama big bir hing pìkyinn á byarmí ni, bu-à big ri zìm.” ");
INSERT INTO jib_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu sa hing bu nìnànn nímá, á zu yann sukàká buwá ni, ká zyun-à big ba kà fig á tarkada-à níng ni bàna. ");
INSERT INTO jib_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama big ba sig káníng jirà aning bir pìkyinn á byar Yesu ni barà ku í Almasihu Wùn Shìdun. Wà na bir hing pìkyinn á zìnnwá ni, ná dìg yonki kinn kinn. ");
INSERT INTO jib_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","I byar-à Yesu mìr gbìb zu jakàng á byar yann sukàwá big mà Ayunn Tibariya. Wàníng í barà ku mìr gbìb zu sig áni: ");
INSERT INTO jib_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yann sukà Yesu sùmpyànn shi kwonn sig í byar ńzyun. Mpìr káníng í Siman Bitrus ma Toma zyun-à big ri bar ku rag wùn ǹtài, ma Nataniel á finn swann Kana á jànn Galili ma yann Zabadi, ma mpìrká káhi pyànà áyau yann sukàká ni. ");
INSERT INTO jib_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siman Bitrus dinya big rag, buwá kwá yag gban jái. A byar-à níng hi, big dinya ku rag, “Yi ri zìm yá yag ma wù í zyun.” Big zu n yag kà á kòr-à ni, ama á fi-à níng hi, big gban fig bu bàna. ");
INSERT INTO jib_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Barà byar-à bi kyàr, Yesu sar sig mà nu zàpìr-à ni, ama yann sukàwá big yì fig rag í ku bàna. ");
INSERT INTO jib_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu bib big n rag, “Jàumí big, ning pànn hing jái rà?” Big zìm n rag, “Yi pànn fig kó bu ńzyun bàna.” ");
INSERT INTO jib_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ku dinya big rag, “Aning vinn yag birginá á agunn vìm nu kòr-à ni, ná pànn jái.” Big vinn yag n pànn jái, n gbar sar fig birgi-à bàna, jir kai bàna jáiká mònn kab gbam. ");
INSERT INTO jib_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wùn sukà zyun-à Yesu ri zìm níng, dinya Bitrus rag, “I Shinn Luyí!” Barà Siman Bitrus fig àdòníng, ku zìg jàwá n bir dim dìrwá ma kàhi, jir kai bàna ku sar sig mìr áyonn, n pìm kù kà á zàpìr-à ni. ");
INSERT INTO jib_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yann sukàká káhi bi á kòr, big shi nonn fig mà nu zàpìr-à ni bàna. Big bi gbar birgi zyun-à mònn sig ma jái-à níng. ");
INSERT INTO jib_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Barà big nann zu bi àdòníng, big myàng akan pyìr ma jái á shinn pyìr-à ni, ma agir brodi. ");
INSERT INTO jib_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A byar-à níng hi, Yesu dinya big rag, “Ayau jáiká ning gban sig níng, aning zìg bi káhi.” ");
INSERT INTO jib_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siman Bitrus nann yag á kòr-à ni, n gbar zu bi birgi-à á myann, mònn sig ma jáiká ǹkwònn ǹkwònn nímá, àràg àkunn 153. Kó barà jáiká hi nànn sig wàni níng, birgi-à ka fig bàna. ");
INSERT INTO jib_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu bar big n rag “Aning bi ji buju.” A byar-à níng hi, áyau yann sukàká buwá ni, kó mpìr ńzyun bib fig ku rag, “Ku í ni rà?” bàna, jir kai bàna big yì hing í Shinn Lubá. ");
INSERT INTO jib_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu bi zìg agir brodi ma jái, n ya big. ");
INSERT INTO jib_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kwonn ma wàníng í wà wa sara wà Yesu bi á byar yann sukàwá big, ásai-à ku dù nann zu mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Barà big ji vinn rìg buju àdòníng, sái Yesu bib Siman Bitrus rag, “Siman wùn Yohanna, wù ri zìm mì hár kab bu mpìr káníng rà?” Bitrus zìm n dinya kàng ku rag, “Shinn Lumí, à yì hing àjai, mì ri zìm wù.” A byar-à níng hi, Yesu dinya ku rag, “A myàng kwonn ma àdùnká bumí.” ");
INSERT INTO jib_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu bib ku bar kàun pyànà, n rag, “Siman wùn Yohanna, wù ri zìm mì rà?” Ku zìm n dinya wàníng rag, “Shinn Lumí, à yì hing mì ri zìm wù.” Yesu dinya ku rag, “A myàng kwonn ma àdùnká bumí.” ");
INSERT INTO jib_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu bib jakàng ku kàun sara, “Siman wùn Yohanna, wù ri zìm mì rà?” A byar-à níng hi, pìkyinn Bitrus í bai rìg-à, jir abib-à Yesu bib ku kàun sara n rag, “Wù ri zìm mì rà?” Sái ku dinya Yesu rag, “Shinn Lumí, à yì hing kó kai bidìm pár, à yì hing mì ri zìm wù.” Yesu dinya ku n rag, “A myàng kwonn ma àdùnká bumí. ");
INSERT INTO jib_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mì ri dinya wù àjai, ásai-à wù í wùnshái, wù ri sa bu-à wù ri zìm, wù ri yag byarká wù ri zìm. Ama á sai-à wa kàng hing àwàutím, wá du yag vùwú, bá gbar dù nann zu wù, má zìg yag wù mà byar-à à zìm fig bàna níng.” ");
INSERT INTO jib_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Barà Yesu ri dang àdòníng, ku ri tìya mpìrká íri ki-à Bitrus má wu zyun-à mpìrká má swam yan zìnn Shìdun.) A byar-à níng hi, Yesu dinya ku rag, “A bàg bi mì.” ");
INSERT INTO jib_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus myàng kàng bi zuwá, n myàng wùn sukà zyun-à Yesu ri zìm, ri kan bàg big. Wàníng í mpìr-à shi yàr sig ma Yesu ásai-à big ri ji buju, ku zyun-à dang rag, “Shinn Luyí, mpìr-à má wann tafinn wù í ni rà?” ");
INSERT INTO jib_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Barà Bitrus myàng ku àdòníng, ku bib Yesu rag, “Shinn Lumí, ma mpìr-à níng má sa í kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu dinya ku rag, “Wà ma ri zìm aku shi hár sai-à ma kàng bi, bu-à du wù í kai rà? Buwú dái, á bàg bi mì.” ");
INSERT INTO jib_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tai jír-à níng kàng kwìb rìg mà byar mpìrká ri bàg Yesu, n rag wùn sukà-à níng má wu fig bàna. Ama Yesu dang fig àdòníng bàna. Ku dang rag, “Wà ma zìm hing aku shi hár sai-à ma kàng bi, bu-à du wù í kai rà?” ");
INSERT INTO jib_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mì Yohanna mì í wùn sukà zyun-à fig sig jír-à níng ma sungmí, ǹ myàng hing ma zumí, mì í àsàin-à ba sig jír-à á tarkada níng ni. Ayi yì rag jír-à níng í jír àbyann. ");
INSERT INTO jib_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yi shi sig ma buká nìnànn nímá wà Yesu sa sig. Mì ri kyab wà big nìm ma ba vinn rìg hing big bidìm pár, byar-à yi nìm má sìnn tarkada káníng á dunyaru-à níng ni, nìm bàna.");
INSERT INTO jib_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tarkadamí níng mì ri ba ya wù Tiyafalas. Ayau tarkadamí wà jijag ǹ ba dinya sig wù bu-à Yesu rì sa sig, á sai-à ku kà jag swàmwá, ma jírwá ku rì tàg sig, ");
INSERT INTO jib_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hár sai-à Shìdun bi zìg nann zu yag ku mà wai. Sai-à Shìdun zìg nann yag fig ma ku bàna níng, ku ri shi mi ri dang jír ma gbam Awun Shìdun, mi ri dinya vinn yann aswamwá big, ká ku shig zu sig níng, jírwá. ");
INSERT INTO jib_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sai-à ku wu rìghing, n dù nann zu kàng, ku shi su dìpyànà, ku ri zu á byarbá ni, mi ri tìya big shinnwá kàun nìnànn nímá á gbìb-à bá yì rag ku shi sig ma yonki. Ku ri dinya big jír barà Shìdun má na kùrwá. ");
INSERT INTO jib_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","To, sai-à big ri shi kwonn í byar ńzyun, ku dinya káníng rag, kada a káníng dù dà fim finn swann Urushalima bàna. Ku rag, a káníng shi màhàn sái wà Tawá Shìdun ma ya hing big Awunwá zyun-à ku rì dinya sig big rag, kwá ya big níng. Ku rag, “Bu-à Shìdun má ya ning níng, í bu-à ǹ rì dinya sig ning. ");
INSERT INTO jib_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wà Yohanna ri wau mpìr dìr batisma, ku ri wau ma zàpìr. Ama su má nonn fig bàna, Shìdun má wau ning dìr batisma ma Awunwá.” ");
INSERT INTO jib_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Barà yann sukàká ri shi kwonn ma Yesu, big bi bib ku rag, “To, Shinn Luyí, á dinya yi, tàma-à níng wá ya kàng mpìr Israilaká gbam abig na kùr á jànnbá ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sái Yesu rag, “I Tamí Shìdun yì sig sai-à hi ni. Ku í àsàin-à ri sìnn sai-à bu káníng má sa. Ama bu-à du ning ma kàhi bàna. ");
INSERT INTO jib_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sai-à Awun Shìdun ma bi hing á shinn ná ni, ná shi ma gbam, í wà ná dang jírmí á byar mpìrká shi sig á finn swann Urushalima, ma jànn Yahudiya, ma jànn Samariya, hár ma agunn jànnká á dunyaru bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Barà Yesu dang kinn rìg jírwá àdòníng, sái big rag abig myàng níng, ku zu rìghing áyaubá ni, mi ri nann zu yag mà wai, akor bi bir dim rìg ku, big myàng fig rag ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Big shi, big ri myàng nann zu yag zubá mà wai. Barà Yesu ri nann zu yag àdòníng, sái big rag abig myàng níng, mpìr pyànà bi sar sig á pyànnbá ni. Mpìr káníng wìr sig jà mìmìg. ");
INSERT INTO jib_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Big bib yann sukà káníng rag, “Ning mpìrká á Galili, sáshinn ning ri myàng nann zu yag zuná mà wai, í kai sa síg nì rà? Yesu zyun-à ning myàng ku dù á byarná ni, n yag sig mà wài níng, ná myàng kwá kàng bi kàng áyau akor-à ni àràg barà ning myàng ku yag sig níng.” ");
INSERT INTO jib_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Barà yann sukàká fig jír-à níng, big dù á Wùn Mwir Zaitun. Byar-à hi shi yàr sig mà finn swann Urushalima, fòr àràg mel zyun. To, big dù màhàn n kàng yag kàng mà finn swann-à ni. ");
INSERT INTO jib_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Big fíg jirà yag mà tonn zyun-à big mi ta bàg kwonn sig mà wai, í tonn byar-à big ri shi kyann áni. Yann sukà káníng hi í Bitrus ma Yohanna ma Yakubu ma Andarawus ma Filibus ma Toma ma Bartalamawas ma Matiyu ma Yakubu wùn Halfa ma Siman Zaloti ma Yahuda wùn Yakubu. ");
INSERT INTO jib_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mpìr káníng bidìm pár big ri kwonn nubá, mi ri vig kyann Shìdunbá í byar ńzyun. Uwàká káhi shi sig màhàn tìnn. Ayau mpìrká shi sig níng, zyun í Maryamu na Yesu, ma wunzà Yesu big. ");
INSERT INTO jib_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ayúnn zyun mpìrká ri bàg Yesu big kwonn shi sig á byar-à big ri vig kyann Shìdun. Big fòr hing mpìr dìb-sùnnjin. Ayúnn-à hi Bitrus sar dù nann zu á wai, n dang jírwá. ");
INSERT INTO jib_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ku dang rag, “Wunzàmí big, shi sig àràg í tonn, jir Shìdun aku shi àjai àràg barà big ba sig, wà zyun-à Awun Shìdun rì dang sig á nu Dawuda á jir shinn Yahuda zyun-à sa sig gbìb big pànn sig Yesu. ");
INSERT INTO jib_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Big rì wànn kà sig ku áyauyí ni, ku rì sa sig swàm-à níng tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ku yag wann da ma bài-à ku wann tafinn sig Yesu ma kàhi, n yag kù wann bi á bín mà da-à hi ni n kàng kir ma shinn, finnwá kyìg, byaafigwá dònn zu rìg á myann. ");
INSERT INTO jib_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tai kiwá níng kàng kwib gban rìg finn swann Urushalima bidìm pár, big bar da-à hi á nu jírbá ni n rag Alkadama. Yìrwá í “Da àsà.”) ");
INSERT INTO jib_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Jir kai bàna big ba sig á tarkada Zabura rag, ‘Abig sìnn kàng luwá kànnfinn, kada mpìr aku shi áni bàna.’ Big ba sig á byar zyun n rag, ‘Abig ya swàmwá á vù mpìr zyun kim.’ ");
INSERT INTO jib_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“To, barà sa sig àdòníng, ayi dìg mpìr zyun aku pyann shinnwá. Mpìr-à níng hi ayi dìg í zyun-à rì shi sig áyauyí ni, n myàng sig bu-à Yesu rì sa sig big zuwá. ");
INSERT INTO jib_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Wato mpìr zyun-à rìi kyann big Yesu sai-à Yohanna rìi wau mpìrká dìr batisma hár sai-à Shìdun bi zìg Yesu áyauyí ni, n zìg nann yag ku mà wai. I wà mpìr-à hi má dinya mpìrká barà Yesu dù nann zu kàng sig ma yonki, àràg barà yi ri dang níng.” ");
INSERT INTO jib_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Barà Bitrus dang kinn rìghing jírwá àdòníng, sái big bi dang jír á shinn mpìr pyànà. Yusufu zyun-à big ri bar ku zìnnwá Barsaba. Zìnn tawá í Yustus. Mpìr-à wà wa pyànà níng í Matiyas. ");
INSERT INTO jib_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","To. I wà big bi vig Shìdun rag, “Shinn Luyí, wù ri myàng pìkyinn mpìrká bidìm pár. To, áyau mpìr pyànà káníng ni, á tìya yi wà zyun-à à shig zu sig aku pyann shinn swàm-à Yahuda wùn aswamwú shàr tafinn, n yag wu sig níng.” ");
INSERT INTO jib_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","I byar-à hi, big bi dab shasha. Shasha big dab sig níng pànn á shinn Matiyas. Sái big bi sìnn kà ku áyau kyau yann sukàká bu Yesu dwib agban zyun-à níng. ");
INSERT INTO jib_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ayúnn ùwài zyun big ri bar rag í Pentikos, barà àyúnn-à níng hi fòr, sái mpìrká ri bàg Yesu big bidìm pár big kwonn shi sig í byar ńzyun. ");
INSERT INTO jib_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Big ri shi, sái big rag abig fig níng, big fig nài gbam wàni, shi àràg í wàu zyun ngbam nímá ri gbár nì, wann bi mà wai, n gbar mònn lu-à big shi sig áni níng bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sái big myàng bu shi àràg anam pyìr bi, n yam gàb fim rìg á shinnbá ni bidìm. ");
INSERT INTO jib_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","I byar-à hi Awun Shìdun bi kà á kyinnbá ni big bidìm pár. Big bi dang nu jírká káhi kim kim, nu jír-à big rì dang bab fig bàna. Big dang bar bu-à Awun Shìdun ya sig big abig dang. ");
INSERT INTO jib_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mpìr Yahudawaká káhi shi sig á finn swann Urushalima big í mpìrká ri wib Shìdun, big bi sig byar kim kim kó áni á dunyaru bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","I byar-à big fig nài gbam mà wai àràg í wàu. Barà big fig àdòníng, big shàr kwonn bi gban rìg á byar káníng ni. Kó ni ri fig káníng ri dang nu jírbá. ");
INSERT INTO jib_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mamaki pànn rìghing big, big rag, “Mpìrká ri dang jír-à níng bidìm íri mpìr Galiliká bàna rà? ");
INSERT INTO jib_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sáshinn yi ri fig kó ni ri dang jír big nu jíryí rà? ");
INSERT INTO jib_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yi shi síg nì mpìr jànn kim kim. Yi mpìr Partiyawaká, mpìr Madayanawaká, mpìr Ilamawaká, mpìrká á jànn Bagadaza, ma jànn Yahudiya, ma jànn Kapadokiya, ma jànn Pantas, ma jànn Asiya, ");
INSERT INTO jib_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma jànn Pirijiya, ma jànn Pamfiliya, ma jànn Masar, ma jànn Turabus agunn finn swann Kurane, hár ma mpìrká á jànn Roma. ");
INSERT INTO jib_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yi bi sig yi yann Yahudawaká big ká í Yahudawaká bàna, ká ri bàg Shìdun àràg barà mpìr Yahudawaká ri bàg. Ayauyí ni mpìrká káhi bi sig ma Karita ma Arabiya. Yi bidìm pár yi ri fig big ri dang jír big nu jíryí, big ri dang bu ùwài-à Shìdun sa sig.” ");
INSERT INTO jib_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Big sa mamaki, jír-à hi vù rìghing big átai, big bib bar dìrbá rag, bu-à hi í kai rà? ");
INSERT INTO jib_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sái mpìrká káhi màm jwann big, n dang rag, “Ai, káníng wa pyann sig shin, í bu-à sa níng.” ");
INSERT INTO jib_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sái Bitrus ma jàuwá big dwib agban zyun big sar dù nann á wai. Bitrus dang jír ngbam nímá. Ku dinya mpìrká kwonn shi sig níng rag, “Ning wunzàmí big, mpìr Yahudawaká ma mpìrká á finn swann Urushalima, aning shi akim, aning fig jírmí ń dinya ning yìr bu-à sa sig níng. ");
INSERT INTO jib_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mpìr káníng wa pyann fíg shin àràg barà ning ri dang níng bàna. Tàma-à níng í àsháu ajunndúbi, sa fig ma barà mpìr má wa pyann shin bàna. ");
INSERT INTO jib_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bu-à ning myàng sig níng, í bu-à Yoila mpìr-à rìi dang kyann jir Shìdun, ku rì ba sig n rag, ");
INSERT INTO jib_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Shìdun rag, sai-à dunyaru ma nyàan vinn, kwá wìr wann bi ya mpìrká bidìm pár Awunwá má kà á kyinnbá ni. I byar-à yann wunùká bigná big yann uwàká bigná má dang jírwá. I byar-à yann sukàká bigná má myàng bu-à big myàng bab fig á dunyaru bàna. I byar-à àgbamká bigná má la la. ");
INSERT INTO jib_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hár kwá wìr wann ya fàuká buwá big awunwá á àyúnn-à hi. Kwá wìr ya wunù ma uwà bidìm pár. I wà bá dang jírwá. ");
INSERT INTO jib_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kwá sa swàm bu mamaki mà waisháu-à ni, kwá sa á jìnn ni tìnn, barà mpìrká má myàng gbamwá. Bá myàng àsà ma pyìr ma azunn pyìr. ");
INSERT INTO jib_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bá myàng àyúnn-à má kàng rìg fi. Bá myàng sònn-à má gbànn shi àràg àsà, í wà Shinn Luyí má bi, àyúnn-à níng hi í àyúnn-à ùwài. ");
INSERT INTO jib_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","I wà kó ni ma vig hing Shinn Luyí a wàníng myàng ashiwá, wàníng má zìg zu ku.’ ");
INSERT INTO jib_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ning mpìr Israilaká, aning fig. Yesu mpìr á Nazarat í zyun-à Shìdun shig zu sig ma shinnwá. Ku sìnn sig wàníng á pyànn ná ni, ku sa swàm bu mamaki á vù wàníng ni, jirà aning yì rag í ku swam bi sig wàníng ni. Ning má, ning yì hing ku. ");
INSERT INTO jib_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Shìdun ya kà sig mpìr-à níng á vùná ni. Ku yì rìghing bu-à ná sa wàníng. Ku zìm síg nì àdòníng. Ning zìg ku, n ya kà á vù mpìrká ri sa bu-à bibai abig dab bàg gbam ku á dìr bín, ku í wu rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama barà ning gban rìghing ku níng, Shìdun bi gbar dù kàng ku ma yonki. Shìdun zìg zu rìg ku áyau awa ki. Shar ki pànn sar fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","I barà Dawuda rì dang sig áni á shinnwá ni. Ku dang rag, ‘N myàng yì rìghing Shinn Lumí, ku ri shi kyann á pyànnmí ni, ku ri shi á vim numí ni, barà kwá sa shang mì, má shàr fig kó bu zyun bàna. ");
INSERT INTO jib_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","I bu-à sa pìkyinnmí ri fig àjwár, jírmí í jir àjwár. Kó ma wu má, má bir pìkyinnmí á dìrwú ni, ");
INSERT INTO jib_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","jir kai bàna ǹ yì hing wá fim fig mì á shar ki bàna. Wá fim fig mì wùn sukà kyìkyàrwú a dìrmí aku swàr bai bàna. ");
INSERT INTO jib_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A tìya sig mì gbìb yonki zyun-à kinn kinn. Barà yi ma wù ri shi zyun níng, wá sa jwar pìkyinnmí wàni.’ I jír bu-à Dawuda ba sìnn sig níng. ");
INSERT INTO jib_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“To, wunzàmí big, tàma-à níng má dinya ning jír àjai á shinn yàkúyí Dawuda ni. Ku rì wu rìghing, big jì rìghing ku. Hár tàma-à níng, í barà amirwá shi sig áni áyág. ");
INSERT INTO jib_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Ama jírwá ku dang sig níng, ku dang sig jír á shinn Kristi. Ku rag, wàníng í àsàin-à má dù nann zu kàng ma yonki, jir kai bàna Dawuda í mpìr-à ri dang kyann jir Shìdun. Shìdun rì dinya sig ku rag, kwá sìnn kà mpìr zyun áyau yiwaiwá ni, wàníng má na kùr ásimwá ni. I bu-à sa ku dang jír-à níng á shinn Almasihu, n dang rag, ‘Bá fim fig wàníng á shar ki bàna. Dìr wàníng má swàr bai fig bàna.’ ");
INSERT INTO jib_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mpìr-à níng hi í Yesu, Shìdun gbar dù kàng sig ku ma yonki. Yi má yi myàng hing. ");
INSERT INTO jib_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","I wà Shìdun zìg yag ku mà wai. Ku yag shi sig á agunn vìm nu Shìdun. Tàma-à níng Shìdun ya ku Awun Kyìkyàr àràg barà Shìdun gib sig nu rag kwá ya. To, bu-à ning ri myàng janá-à níng ma bu-à ning ri fig, í swàm Awun-à ku wìr wann bi sig. ");
INSERT INTO jib_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda nann zu yag fig mà wai bàna. Ama ku í àsàin-à dang sig rag, ‘Shinn Luyí Shìdun dinya Shinn Lumí rag, a wàníng shi agunn vìm nuwá ni, ");
INSERT INTO jib_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sái wà kwa sìnn kà hing mpìr azíbká bu wàníng á mìr bar wàníng ni.’ ");
INSERT INTO jib_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Jir wàníng, sàn sig mpìr Israilaká bidìm pár abig yì rag í Yesu zyun-à ning dab bàg gbam sig á bín-à ni, ku í zyun-à Shìdun shig zu sig ku n sìnn sig ku Shinn Luyí.” ");
INSERT INTO jib_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Barà mpìrká shi sig níng fig jir Bitrus àdòníng, í byar-à kyinnbá gib. Big bib Bitrus ma yann aswam kádà níng n rag, “Yá sáshinn rà, jàuyí big?” ");
INSERT INTO jib_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitrus dinya big rag, “Bu-à ná sa bàna, aning fim bu pyìrná, kó ni bidìm pár aku wau dìr batisma á zìnn Yesu Kristi jirà a Shìdun yafa ning bu pyìrná, í wà kwá ya ning Awunwá. ");
INSERT INTO jib_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Shìdun dang rag, kwá ya ning Awunwá, ning ma yanká bigná big. Hár ku rag kwá ya mpìrká swaibá kim kim, ká zyun-à kwá bar bi á byarwá ni.” ");
INSERT INTO jib_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","I byar-à Bitrus dinya big jír nìnànn nímá. Ku twìb big byur rag abig zìg zu shinnbá áyau shwìn-à Shìdun má tìr bi á dunyaru. ");
INSERT INTO jib_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mpìrká fig sig jírwá níng, big nìnànn nímá big bir hing pìkyinn á jírwá ni. I byar-à big wau rìg big dìr batisma. Ayúnn-à níng hi mpìr dubu sara swàb kà mi ri bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mpìr káníng ri shwann kyann buká yann aswamká bu Yesu ri tàg big. Big ri ji kyann buju bu-à big ri kyab pànn barà Yesu wu sig níng. Big ri vig kyann Shìdun. I bu-à big ri sa kyann kó ákaun. ");
INSERT INTO jib_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yann aswam káníng bó, big ri sa swàm bu mamaki nìnànn nímá. Hár bi sa bìr mpìrká zinn wìr rìg big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Mpìrká ká ri bàg Yesu big ri shi byar ńzyun. Big zìg kwonn buká big shi sig ma kàhi, big ri wann tafim, mi ri gàb fim ya kó ni bài-à bàkyinn barà kwá sa bu-à ku ri zìm. ");
INSERT INTO jib_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Su ma su bidìm pár, big ri kwonn yag mà lu Shìdun. A lubá ni, big ri gàb fim buju-à big ri kyab pànn Yesu barà ku wu sig níng. Big ri ji buju ábìr-à ni ma pìkyinn àjwár. ");
INSERT INTO jib_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Big ri swam yan kyann Shìdun. Mpìrká ri zìm big. Su ma su Shìdun ri swàb kà ya big mpìrká ku zìg zu sig níng. ");
INSERT INTO jib_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ayúnn zyun Bitrus ma Yohanna yag mà lu Shìdun àsháu sara àkamzau. I sai-à mpìrká ri vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Big yag fòr á nu nkyun zyun-à big ri bar rag, í Nu Nkyun-à Sìsàn. Sái big myàng mpìr bar àkáb zyun, big mà zu kwonn sig ku big kàhi. Big ri swann bi kyann ku á byar-à hi. I wà ku ri vig kyann mpìrká ri kà kyann á lu Shìdun ni níng bu. ");
INSERT INTO jib_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Barà Bitrus ma Yohanna bi fòr àdòníng, í wà ku myàng big n vig big bài. ");
INSERT INTO jib_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Barà big myàng ku àdòníng, Bitrus dinya ku rag, “A myàng yi.” ");
INSERT INTO jib_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I wà ku myàng yag big, n myàng gbam sig big kyarr nímá. Ku ri kyab rag, kó bá ya ku bài. ");
INSERT INTO jib_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sái Bitrus dinya ku rag, “Bài kàm, yi bàna big kàhi kó ńzyun. Ama bu-à ǹ shi sig big kàhi í bu-à má ya wù. A zìnn Yesu Kristi mpìr á Nazarat, á dù á kyann kyonn.” ");
INSERT INTO jib_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sái ku bi pànn wàníng á vìm nu-à ni, n gbar dù nann zu wàníng. Wàníng rag aku dù nann zu àdòníng, barwá í gbam rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ku pìm dù nann zu á wai, mi ri kyann rag kyonn. I wà ku ma káníng yag kà í zyun á lu Shìdun ni. Ku ri kyann, mi ri pìm kyann, mi ri yan Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Barà mpìrká myàng ku ri kyann, mi ri yan Shìdun àdòníng, ");
INSERT INTO jib_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","big myàng yì rìghing í ku àsàin-à ri vig kyann bu á Nu Nkyun Sìsàn-à níng ni. Sái big sa mamaki wàni. Big kyab barà ku gbam sig áni, big yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I byar-à hi big shàr kwonn bi á byarwá ni. Ku shi sig á Mìtàb Sulemanu. Ku pànn gbam sig Bitrus ma Yohanna. ");
INSERT INTO jib_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Barà Bitrus myàng big shàr bi àdòníng, ku bib big jír n rag, “Mpìr Yahudawaká, sáshinn ning ri sa mamaki àdòníng rà? Ning ri kyab rag yi sa sig swàm bu mamaki-à níng big gbam shinnyí rà, kó ning ri kyab rag, í jirà yi mpìr sìsàn rà? ");
INSERT INTO jib_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Swàm-à níng í Shìdun bu yàkúyí sa síg nì. I Shìdun bu Ibrahim bu Ishaku bu Yakubu, ku ya sig wùn sukàwá Yesu gbam bu ùwài-à níng íni. Yesu-à níng hi, ning zìg ku n ya kà ku á vù Bilatus. Bilatus ri zìm á pìkyinnwá ni aku fìnn tafinn Yesu a wàníng yag, ama ning ngàng. ");
INSERT INTO jib_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu í mpìr kyìkyàr, mpìr gwangga. Ama ning ngàng ku. Ning vig Bilatus aku fìnn tafinn ya ning mpìr agban ki-à níng. ");
INSERT INTO jib_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I wà ning bi gban rìg àsàin-à ri ya mpìrká yonki-à níng. Ama Shìdun gbar dù kàng ku big yonki. Yi má, yi myàng hing ma zuyí. ");
INSERT INTO jib_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","I jir zìnn Yesu í bu-à sa mpìr-à níng dìg sig gbam dìrwá á dò jir pìkyinn bir á byar Yesu. Aning myàng, mpìr-à ning ri myàng shi sig níng, ning yì hing ku. Jir pìkyinn bir á byar Yesu ni, í bu-à sa ku dìg sig gbam dìrwá, ku shi sig ítau á pyànn ná ni. ");
INSERT INTO jib_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“To, wunzàmí big, bu-à ning ma àgbamká buná sa sig Yesu níng, ǹ yì hing, í jirà ning yì byann fig wà ning ri sá bu-à bibai bàna. ");
INSERT INTO jib_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sai-à rì níng, Shìdun dang jír á nu mpìrká rì dang kyann sig jírwá n rag, kwá swam bi Almasihu, wàníng má bi wa shwìn. I wà tàma-à níng ku sa bu-à hi sa rìghing àràg barà ku rì dang sig. ");
INSERT INTO jib_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bigná tàma-à níng aning dà fim bu pyìrná, aning vim bìr bi á byar Shìdun, jirà aku tu kyàr bu pyìrká bigná pár, ");
INSERT INTO jib_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","jirà Shìdun aku sa tag wann pìkyinn ná. Kwá swam ya bi ning Almasihu zyun-à ku shig zu sig, wato í Yesu. ");
INSERT INTO jib_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wàníng má shi mà wai mà byarwá ni, sái àyúnn-à ma màg hing wà Shìdun má màm kàng kó kai bidìm pár àpyú àràg barà ku rì dang sig á nu mpìrká rì dang kyann sig jírwá níng, í mpìr kyìkyàrká. ");
INSERT INTO jib_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","I barà Musa rì dang sig áni àdòníng. Ku dang rag, ‘Shinn Luyí Shìdun má swam bi mpìr-à má dang kyann jírwá. Kwá swam bi wàníng àràg barà ku swam bi sig mì níng. Mpìr-à hi má zu áyau yiwainá ni. To sái aning wib jír-à kwá dinya ning. ");
INSERT INTO jib_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mpìr-à ma wib fig jírwá bàna, Shìdun má wun zu rìg ku áyau mpìrká buwá ni, má gban rìg ku.’ ");
INSERT INTO jib_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Mpìrká rì dang kyann sig jir Shìdun, kwonn ma Samaila, ma ká bi dang jir Shìdun ásimwá ni, big bidìm pár big dang hing jír á shinn buká ri sa tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ning í àsàinká dìg sig bu-à Shìdun rì dinya sig yàkúná big á nu mpìrká rì dang kyann sig jírwá. Shìdun dinya Ibrahim rag, ‘Ayau yiwaiwú ni, má sa jwar pìkyinn mpìrká á dunyaru bidìm pár.’ ");
INSERT INTO jib_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Shìdun shig zu wùn sukàwá Yesu n swam bi jag wàníng á byarná ni, jirà aku sa jwar pìkyinn ná, jirà aning dà fim bu-à bibaiká ning ri sa.” ");
INSERT INTO jib_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Barà Bitrus ma Yohanna ri dang jír ma mpìrká àdòníng, sái àgbamká ri twìb swànn bu á pyànn Shìdun ma àgbam áyau mpìrká ri myàng kwonn big lu Shìdun, ma mpìr Sadukiyawaká, big bi á byar Bitrus ma Yohanna. ");
INSERT INTO jib_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pìkyinnbá bai rìghing barà big fig yann aswamká ri dinya mpìrká rag, Yesu dù nann zu kàng rìghing big yonki, mi ri tàg rag mpìr ma wu hing kwá dù kàng big yonki àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sái big pànn yann aswam káníng n kìg kà big á tonn fi-à ni. Bu-à bir rìghing, bá dang jír-à akìn. ");
INSERT INTO jib_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama áyau mpìrká fig sig jir yann aswam káníng, mpìr nìnànn nímá, big bir hing pìkyinn á byar Yesu ni. Big fòr àràg mpìr dubu swana. ");
INSERT INTO jib_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na kyàr byar-à, àgbam Yahudawaká ma shun àgbamká á finn swann-à ni ma malamká, big kwonn bi á finn swann Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Big dìg Hanana àgbam áyau mpìrká ri twìb swànn bu níng, ku ma Kayafa ma Yohanna ma Alizanda ma mpìrká kádà, ká shi sig áyau yiwai àgbam-à níng. ");
INSERT INTO jib_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Barà big kwonn bi àdòníng, sái big bar bi yann aswam pyànà káníng, n sìnn káníng á pyànnbá ni, n bib káníng jír. Big rag, “Swàm-à ma jír-à ning ri dang níng, mpìr-à ya sig ning gbam-à níng í ni rà? Ning ri sa big zìnn ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Sái Awun Shìdun bi kà Bitrus á kyinn-à ni. Ku dinya big rag, “Ning àgbamká ma shun àgbamká, ");
INSERT INTO jib_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wà na ri bib yi jír áshinn bu ǹsàn-à yi sa sig níng, barà yi dab gbam sig mpìr bar àkáb-à níng, ");
INSERT INTO jib_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ning bidìm pár aning yì, mpìrká á Israila bidìm pár abig yì tìnn. Mpìr-à ning myàng sar sig á pyànn ná ni níng, ku gbam sig á zìnn Yesu Kristi, mpìr á Nazarat, wà zyun-à ning rì dab bàg gbam sig á dìr bín-à ni. Shìdun gbar dù kàng sig ku big yonki. ");
INSERT INTO jib_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu í mpìr-à big ba sig jír á shinnwá ni n rag, ‘Abàn-à ning mpìr ami tonnká, ning myàng rag kinn fig bu bàna níng, í abàn zyun-à sàn kab sig kádà níng.’ ");
INSERT INTO jib_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Zìnn Yesu í zìnn-à Shìdun ya sig yi ayi wìm zu áni. Ayau dunyaru bidìm pár, walai zìnn-à Shìdun ya sig yi, yá wìm zu áni bàna, sái zìnn Yesu áwinwá ni.” ");
INSERT INTO jib_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","I byar-à shun àgbamká myàng barà Bitrus ma Yohanna wim pìkyinn, mi ri dinya big jír àdòníng, sái big sa mamaki. Big rag, mpìr káníng kà fig makaranta bàna, big í mpìr ùwài big bàna, sáshinn big ri sar mi ri dang írì swai jir yar àdòníng rà? I wà big yì byann wà káníng rìi kyann ma Yesu. ");
INSERT INTO jib_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Big bàna big gbìb barà bá sa yipyàr, jir kai bàna big myàng mpìr-à káníng dàb gbam sig níng, sar sig á pyànnbá ni. ");
INSERT INTO jib_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sái big dinya káníng rag, a káníng zu yag mà myann. I wà big dang byann jír bar dìrbá. ");
INSERT INTO jib_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Big rag, “Yá sáshinn big mpìr káníng rà? Kó ni bidìm pár á finn swann Urushalima yì rìghing bar bu-à big sa sig níng. Yá sa sar fig yipyàr bàna. ");
INSERT INTO jib_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama ayi twìb big byur rag, kada abig dang jakàng jir Yesu á byar mpìrká ni bàna, jirà kada a jír-à hi yag mà pyànn bàna.” ");
INSERT INTO jib_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","I byar-à big bar bi kàng big n twìb big byur rag, daka janá-à níng kada abig dang jír á shinn Yesu ni bàna, abig tàg mpìrká jír big zìnn Yesu kó títi nímá bàna. ");
INSERT INTO jib_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","I byar-à Bitrus ma Yohanna dinya big rag, “Aning myàng, bu-à sàn kab sig á pyànn Shìdun, ayi sa bu-à Shìdun má zìm rà, kó ayi sa bu-à ning ri dinya yi rà? ");
INSERT INTO jib_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Buyí kàm, shi sig àràg í tonn ayi dinya mpìrká buká yi myàng Yesu sa sig, ma jír-à yi fig ku dang sig.” ");
INSERT INTO jib_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","I byar-à àgbam káníng twìb jakàng big byur wàni. I wà n fim big rag abig yag. Big dìg fig pyù-à bá sa káníng bu bàna, jir kai bàna mpìrká bidìm pár ri swam yan Shìdun á jir bu-à sa sig níng ni. ");
INSERT INTO jib_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mpìr-à big dàb gbam sig níng, jiwá kab hing ji dìpyànà. ");
INSERT INTO jib_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Barà àgbamká fim big rag abig yag níng, í byar-à big yag dìg jàubá, n dinya káníng jír bu-à àgbamká dinya sig big níng. ");
INSERT INTO jib_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Barà jàubá fig àdòníng, big bi vig Shìdun ábìr-à ni. Big rag, “Shìdun, wù í kùryí, à màm sig waisháu-à íni ma jànn á jinn ni, ma níngká ùwài ma buká shi sig áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jírwú yàkúyí Dawuda rì dinya sig yi níng, Awunwú dinya sig ku ínì jirà ku í fàuwú. Ku rag, ‘Sáshinn mpìrká swai kim kim nànn àgùnn àdòníng rà? Hár big zìm abig sa swàm-à bibai, ama big sa yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kùrká á dunyaru big kwonn sig nubá, àgbamká ri kwonn nu tìnn. Big sa pyù-à bá nu kànn big Shinn Luyí Shìdun ma Almasihu mpìr-à ku shig zu sig níng.’ ");
INSERT INTO jib_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bu-à hi sa hing àjai. Yi myàng á finn swànn-à níng ni, kùr Hirudus ma Buntus Bilatus big kwonn nu ma mpìrká kim kim ma mpìr Israilaká bidìm, jirà abig zib wùn sukà kyìkyàrwú Yesu, zyun-à à shig zu sig níng. ");
INSERT INTO jib_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Big kwonn í byar ńzyun n sa bu-à wù ma yarwú ma gbamwú à dang sig rag bá sa níng. ");
INSERT INTO jib_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tàma-à níng, Shinn Luyí, á fig barà big ri dang wìr yi zinn. To, á ya yi, yi yann sukàwú gbam ayi dinya mpìrká jírwú big kyinn wim. ");
INSERT INTO jib_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","A sa ya yi ayi sa swàm big gbamwú big zìnn Yesu fàu kyìkyàrwú. A du bi vùwú, á sa bu mamaki, á dàb gbam mpìrká.” ");
INSERT INTO jib_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Barà big vig kinn rìghing Shìdun, sái lu byar-à big kwonn shi sig níng, ning yàng yàng, í wà Awun Shìdun bi kà á pìkyinnbá ni. Big wim kyinn n dang jir Shìdun, zinn bàna. ");
INSERT INTO jib_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mpìrká ri bir pìkyinn á byar Yesu ni kyinnbá ńzyun. Walai mpìr-à ri dim jàuwá bu-à ku shi sig ma kàhi, kó ni bidìm pár ri sa swàm big bu jàuwá. ");
INSERT INTO jib_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yann aswamká ri dang kyann jir Shìdun ma gbam ùwài nímá n rag, àjai Shinn Luyí Yesu dù kàng rìghing big yonki. Shìdun wìr kà ya big àsànwá. ");
INSERT INTO jib_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ayaubá ni ashi bu zyun sa fig mpìr zyun bàna, jir kai bàna mpìrká ká shi sig big da, big lu, big ri wann tafinn, big ri zìg bi bài-à big wann dìg sig níng, ");
INSERT INTO jib_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","big ri ya á vù yann aswamká ni. I wà káníng zìg, n gàb finn ya mpìrká bàna ma bu á vùbá ni. ");
INSERT INTO jib_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","I byar-à mpìr zyun zìnnwá í Yusufu, ku bi wann tafinn rìg dawá àdòníng, n zìg bi bài-à, n ya yann aswam káníng. Mpìr-à hi í mpìr á kyau yiwai Lawi. Big mà sig ku á jànn Kubrus. Big ri bar ku Barnabas, yìr zìnn-à níng, í mpìr-à ri dang gbam mpìrká pìkyinn. ");
INSERT INTO jib_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wunù zyun shi sig áni zìnnwá í Hananiya. Wàwá í Safiratu. Wunù-à níng bi wann tafinn rìg dawá zyun, n zìg bài-à n ya yag yann aswamká bu Yesu. Ku rag wàníng í nànn bài da-à ku wann dìg sig bidìm. ");
INSERT INTO jib_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Asái ku tàm jànn rìghing bài-à agunn vù zyun, kwá sa swàm áni. Wàwá yì rìghing wà ku tàm sig bài-à níng. I byar-à ku zìg bài-à n bi ya yann aswam káníng. ");
INSERT INTO jib_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","I byar-à hi Bitrus bib ku rag, “Hananiya, sáshinn à fim Shaitan kà rìg á pìkyinnwú ni hár à bi gim ya Awun Shìdun ǹsáng, í jir kai rà? A bi tìya yi bài dawú à rag í nànn bài-à à wann dìg sig. ");
INSERT INTO jib_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","To, ń bib wù, sai-à à wann tafinn fig ma da-à hi bàna, í buwú bàna rà? To, wà à wann tafinn níng, bài-à í buwú, kó nímá bàna rà? To, ma bu-à sa wù á kyinnwú ni, à bi gim ǹsáng àdòníng í kai rà? A myàng. Nsáng-à níng à gim ya fig mpìr bàna, à gim ya síg Shìdun.” ");
INSERT INTO jib_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Barà Hananiya fig jír-à níng àdòníng, sái ku kù wann á jìnn ni, mì wu rìg-à. Mpìrká fig sig jír-à níng, zinn pànn big wàni. ");
INSERT INTO jib_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yann wunù gbánnká dù bi, n bi zìg jà, n bing kà ku áni, n zìg zu yag ku mà myann, mì jì rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sái ásim, fòr àràg awa sara, í wà wàwá í kà bi-à á byar Bitrus ni. Ku fig fig tai bu-à sa sig nuwá bàna. ");
INSERT INTO jib_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","I wà Bitrus bib ku rag, “A dinya mì jír àjai. Wàníng í nànn bài da-à ning wann dìg sig rà?” Sái wàwá dang rag, “Nn, í nànn bài-à hi bidìm.” ");
INSERT INTO jib_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bitrus dinya ku rag, “Bu-à sa ning ma nùwú su kwonn sig nu aning tonn gban Awun Shìdun, í jir kai rà? To, á myàng. Mpìrká jì sig nuwú níng big kàng bi rìghing, big sar sig á nu nkyun-à ni. Bá swann yag rìg wù, n má yag jì rìg wù tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sái big rag abig myàng níng, uwà-à níng kù wann á pyànn Bitrus ni mì wu rìg-à. I byar-à yann wunù gbánn káníng bi. Big myàng ku wu rìghing, í wà big swann zu yag ku mà myann, n yag jì kwonn ku big nùwá. ");
INSERT INTO jib_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mpìrká fig sig jír bu-à sa sig níng, zinn pànn rìg big bidìm pár, hár ma mpìrká ri bàg Yesu bidìm. ");
INSERT INTO jib_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yann aswam káníng big ri sa swàm big gbam Shìdun kàun nìnànn nímá, áyau mpìrká ni. Mpìrká ri bàg Yesu big kwonn shi sig á Mìtàb Sulemanu á byar lu Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mpìrká ká ri bàg fig Yesu bàna níng, áyaubá ni walai mpìr-à wim kyinn n kà áyau ká ri bàg Yesu. Ama mpìrká bidìm pár ri wib big. ");
INSERT INTO jib_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bìr mpìrká nìnànn nímá ri bir pìkyinn á byar Yesu ni, big nànn kab wàrì. Wunù ma uwà bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A jir swàm-à yann aswam Yesu big ri sa níng, mpìrká ri swann bi mpìr dorká á syu ma á buná tìnn, mi ri sìnn á kur gbìb-à ni, jirà wà Bitrus ma bi wam zu yag, kó adìndínwá má wìr big á dìr-à ni, bá gbam. ");
INSERT INTO jib_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mpìrká na kàng kwìb sig finn swann Urushalima áni níng, big nìnànn nímá big swann bi sig mpìr dorká tìnn. Big ri zìg bi ká wàu dab sig big. Big bidìm pár big gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Barà àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun, ku myàng swàm yann aswamká àdòníng, ku ma mpìrká buwá ká shi sig áyau kyau Sadukiyawaká, big ri sa yann aswam káníng akyib. ");
INSERT INTO jib_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","I byar-à big bi pànn káníng n kìg kà á tonn fi-à ni. ");
INSERT INTO jib_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ayúnn-à hi á fi-à ni, mpìrká na jànn gban rìghing, sái wùn aswam Shìdun mà wai bi pù rìg nu nkyun tonn fi-à níng. Ku bi zìg zu rìg yann aswam káníng, í wà n dinya káníng rag, ");
INSERT INTO jib_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aning yag ma aning sar mà lu Shìdun ni. Aning dinya mpìrká jir yonki àpyú-à Shìdun ri ya mpìr.” ");
INSERT INTO jib_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Barà yann aswamká fig àdòníng big dù í pyim byau yìì nímá, n yag kà á lu Shìdun ni, mi ri tàg mpìrká bu. Agbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun, ma mpìrká buwá bar kwonn àgbamká ma shun àgbamká bidìm pár, í wà big swam yag aswam mà tonn fi-à ni n rag, abig yag zìg bi yann aswam káníng á pyànnbá ni. ");
INSERT INTO jib_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mpìrká yag fòr, big yag dìg fig yann aswamká á tonn fi-à ni bàna. Sái big kàng bi á byar àgbambá ni. Big dinya káníng rag, ");
INSERT INTO jib_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yi yag mà tonn fi-à ni, yi yag dìg tonn-à shi sig ákúnn. Mpìr gadiká ri sa gadi á nu nkyun-à ni. Barà yi yag pù tonn-à àdòníng, yi dìg fig kó mpìr ńzyun áni mà yau bàna.” ");
INSERT INTO jib_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Agbam gadi-à níng, ma àgbamká ri twìb swànn bu á pyànn Shìdun fig jír-à níng, big kyab bu-à sa sig yann aswam káníng, big yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sái mpìr zyun kà bi, n bi dinya big rag, “Aning myàng, mpìrká ning du kà sig á tonn fi-à ni níng, big shi sig mà lu Shìdun ni tàma-à níng. Big ri tàg mpìrká bu màhàn.” ");
INSERT INTO jib_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sái àgbam gadi-à níng bi dù ma jàuwá big. Big yag màhàn, big yag dìg yann aswam káníng, n zìg kàng bi káníng. Ama big pànn fig káníng big gbam bàna. Big ri shàr kada mpìrká ma ta gban big ma abàn. ");
INSERT INTO jib_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Big zìg bi yann aswam káníng á pyànn shun àgbamká ni, í wà àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni dinya big rag, ");
INSERT INTO jib_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yi twìb ning byur ùwài nímá rag kada aning dang jír á shinn Yesu ni bàna. Aning myàng bu-à ning sa sig. Jír-à níng mpìrká á Urushalima fig gban rìghing. Asái ning ri zìm aning sìnn kàng yi abau á jir ki-à Yesu wu sig níng ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sái Bitrus ma yann aswam kádà níng dinya big rag, “Jír-à ning ri kan dim yi níng, wà yá wib mpìr, sàn kab sig ayi wib Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Bigná ning dab bàg gbam Yesu á bín-à ni, ning gban rìg ku. Ama Shìdun bu yàkúyí big gbar dù kàng rìghing ku big yonki. ");
INSERT INTO jib_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Shìdun gbar dù nann zu ku, ku shi sig agunn vìm nu Shìdun ni, ku shi síg nì àgbam, ku í àsàin-à má pinn zu mpìrká. I byar-à mpìr Israilaká má dìg gbìb-à bá dà fim bu-à bibaibá, bá vim bìr bi kyinnbá á byar Shìdun ni, í wà Shìdun má yafa ya big bu-à bibaibá. ");
INSERT INTO jib_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yi yann aswam káníng, yì àsàinká myàng sig bu-à sa sig Yesu níng, yi big Awun Shìdun zyun-à Shìdun ri ya mpìrká ri wib ku.” ");
INSERT INTO jib_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Barà shun àgbamká fig jír káníng àdòníng, big bai pìkyinn wàni. Big nànn àgùnn, big ri zìm abig gban rìg yann aswam káníng. ");
INSERT INTO jib_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sái àgbam zyun sar dù nann zu. Ku í malam. Mpìrká bidìm pár ri wib ku. Ku í mpìr Farisi, zìnnwá í Gamaliyal. Ku sar dù nann n rag, abig zìg zu yag yann aswam káníng mà myann. ");
INSERT INTO jib_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","I wà ku dinya shun àgbamká ku rag, “Ning mpìr Israilaká, aning sa hankali big bu-à ning ri zìm aning sa mpìr káníng fa! ");
INSERT INTO jib_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sai-à rì níng yi myàng mpìr zyun bi, zìnnwá í Tudas. Mpìr-à hi zìg kàng sig shinnwá rag ku í mpìr ùwài. Mpìrká kádà ri bàg ku, big sa hing àràg mpìr dari yina. Ama sai-à big bi gban rìg ku, mpìrká ri bàg ku níng í yam gàfinn vinn rìg-à, í nànn-à hi. ");
INSERT INTO jib_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Asimwá ni, mpìr zyun á Galili bi kàng, zìnnwá í Yahuda. Ku má, ku tonn gban mpìrká kádà ri bàg ku tìnn, á sai-à big ri ba wànn mpìr. Sái big gban rìg ku, mpìrká ri bàg ku níng í yam gàfinn rìg-à tìnn. ");
INSERT INTO jib_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tàma-à níng áyau jir mpìrká ri bàg Yesu níng, bumí sàn kab sig ayi zu rìg áyaubá ni. Wà jírbá má í bu mpìr, má bai big shinnwá. ");
INSERT INTO jib_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama wà ma í jir Shìdun, ná kan dim sar fig big bàna. Wàníng má shi àràg ning ri gbìb shùr big Shìdun.” I byar-à big zìm jir Gamaliyal. ");
INSERT INTO jib_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Big bar kà bi yann aswamká, n yang káníng ashor, í wà n kan dim káníng rag, kada a káníng yag dang jir Yesu bàna kó shwìyí nímá. I byar-à big fim rìg káníng, káníng yag. ");
INSERT INTO jib_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Barà big zu yag àdòníng, big fig àjwár á pìkyinnbá ni. Big rag, big fòr hing wà abig wa shwìn jir shinn Yesu. ");
INSERT INTO jib_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Big fim fig wà dang kyann jir á shinn Yesu ni bàna. Big ri yag su ma su mà lu Shìdun ni, big ri kà á lu mpìrká ni, mi ri tàg mpìrká, mi ri dang jir àjwár á shinn Yesu ni rag ku í wà zyun-à Shìdun shig zu sig. ");
INSERT INTO jib_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ayau suká bó ni mpìrká nìnànn nímá ri bàg swàb kà Yesu. Mpìrká ri dang nu jir Helena ri zìnn swau ká ri dang nu jir Ibraniyaká, n dang rag big ya fig uwà kiká bigbá buju bàna, ama big ri ya uwà kiká bu Ibraniyaká buju su ma su. ");
INSERT INTO jib_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Sái yann aswam dwib agban pyànà káníng bar kwonn bi mpìrká ri bàg Yesu, n dinya big rag, “Sàn fig wà ayi fim wà dang kyann jir Shìdun, ma ayi kà áyau swàm buju gàfinn bàna. ");
INSERT INTO jib_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jir wàníng, wunzàyí big, aning shig zu mpìr sùmpyànà áyauná ni. Aning shig zu mpìrká Awun Shìdun mònn sig á kyinnbá ni ká zyun-à kó ni yì rìghing big í mpìr sìsàn, big shi sig big yar, ma ayi ya kà swàm-à níng á vùbá ni. ");
INSERT INTO jib_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bu-à yá sa kyann buyí bàna, yá shi vig kyann Shìdun má dang kyann jir Yesu tìnn.” Yann aswamká dinya mpìrká àdòníng. ");
INSERT INTO jib_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jírbá jwar ya hing mpìrká bidìm pár. Sái big bi shig zu mpìr sùmpyànn. Zìnn mpìrká hi, zyun zìnnwá í Istifanus. Awun Shìdun mònn sig á pìkyinnwá ni wàni. Ku ri bir pìkyinnwá ńzyun á byar Shìdun ni. Zyun í Filibus, zyun í Burukoras, zyun í Nikano, zyun í Timan, zyun í Barminas, zyun í Nikolas mpìr Antakiya. Ku í mpìr Yahudawa bàna, ama ku vim bìr mi ri bàg sù Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","I byar-à mpìrká big shig zu sig níng, big zìg bi káníng á byar yann aswamká ni. I wà yann aswamká bi tib káníng vù á shinn-à ni, n bi vig Shìdun á shinn swàm-à káníng má sa níng. ");
INSERT INTO jib_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","I byar-à jir Shìdun ri yag mà pyànn. Mpìrká ri bàg Yesu á finn swann Urushalima big nànn swàb kà yag mà pyànn, hár ma mpìrká ri twìb swànn ya Shìdun bu níng, big nìnànn nímá big ri bir pìkyinnbá á jír-à hi tìnn. ");
INSERT INTO jib_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanus í mpìr-à Shìdun shi sig á shinnwá ni, n ya sig ku gbam. Ku ri sa swàm bu mamaki á pyànn mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Barà ku shi sig mi ri sa swàmwá àdòníng, sái mpìrká kádà bi sa ku yipyàr. Mpìr káníng, sai-à rì níng big í fàu, ama tàma-à níng big shi sig big shinnbá. Big í mpìr Yahudawaká, big bi sig mà jànn Kurane ma jànn Iskandariya ma jànn Kilikiya, ma jànn Asiya. Big ri kà á tonn bìr kwonn zyun-à big ri bar rag, í tonn bìr kwonn bu mpìrká shi sig ma shinnbá. Big ri sa yipyàr big Istifanus. ");
INSERT INTO jib_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sái Awun Shìdun ya ku yar bar bu-à kwá dinya káníng, hár káníng sa sar fig barà bá sa ku yipyàr bàna. ");
INSERT INTO jib_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sái big bònn ya mpìrká káhi bài àjirà a káníng dang rag, wàníng ri dang sa bai zìnn Musa ma zìnn Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Barà mpìr káníng dang àdòníng, sái big gbar dù mpìrká kyinn, í mpìrká á finn swann-à ni ma shun àgbamká ma malamká. I byar-à big bi pànn Istifanus, n zìg yag ku á pyànn àgbamká ni, ");
INSERT INTO jib_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","í wà n zìg bi mpìrká kádà jirà abig gim ǹsáng á shinnwá ni. Káníng rag, “Mpìr-à níng ri dang sa bai lu Shìdun byar kyìkyàryí níng, mi ri dang sa bai doka Musa tìnn. ");
INSERT INTO jib_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hár yi fig ku dang rag, Yesu mpìr á Nazarat má dab gbànn rìg tonn-à níng, hár n má vim bìr bu-à Musa rì dinya sig yàkúyí big rag, ayi sa níng.” ");
INSERT INTO jib_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Barà big dang àdòníng, sái mpìrká màhàn bidìm pár myàng gbam sig Istifanus zu kyarr. Sái big myàng mùnnpyànnwá shi sig àràg í bu wùn aswam Shìdun mà wai. ");
INSERT INTO jib_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I byar-à àgbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun níng, ku bi bib Istifanus rag, “Bu-à mpìrká dang sig á shinnwú ni níng, í àjai rà?” ");
INSERT INTO jib_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","I byar-à Istifanus dang rag, “Wunzàmí big ma àgbamká, aning fig jírmí. Sai-à rì níng Shìdun mpìr ùwài mìr gbìb zu bi á byar yàkúyí Ibrahim ni, á sai-à ku shi sig mà jànn Bagadaza ku yag fig ma mà jànn Harana bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I byar-à Shìdun bi dinya ku rag, ‘Ibrahim, á dù á jànn-à à shi sig áni níng, á dà fim yiwaiwú big, á yag shi mà jànn zyun, jànn-à má tìya wù.’ ");
INSERT INTO jib_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","I byar-à Ibrahim dù, n zu rìg á jànn Kaldiya, n yag shi mà jànn Harana. Sái tawá í wu rìg-à. I wà Shìdun tìr yag ku á jànn zyun ni, í jànn-à tàma-à níng ning shi sig áni. ");
INSERT INTO jib_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Shìdun ya fig ku byar, byar-à má shi buwá bàna. Shìdun ya fig ku kó byar zyun shwìyí nímá bàna. Ama Shìdun gib nu ma ku rag, kwá ya wàníng jànn-à má shi bu wàníng ma bu yiwai wàníng ásim wàníng ni. Sai-à Shìdun gib nu ma ku níng, ku bàna ma wùn. ");
INSERT INTO jib_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Shìdun dinya ku rag, ‘Swaiká buwú má yag shi kyìnn á jànn zyun ni, jànn-à hi í jànnbá bàna. A jànn-à hi ni, bá kàng í fàu àsàin jànnká, káníng má ya big shwìn hár ji dari yina. ");
INSERT INTO jib_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wà ba shi hing màhàn ji dari yina, í wà má ya pyann kàng mpìrká ri ya big shwìn níng, shwìn tìnn. I wà swaiká buwú má zu á jànn-à hi ni, n má bi wib mì á jànn-à wà shi sig níng.’ ");
INSERT INTO jib_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","I byar-à Shìdun tìya Ibrahim jur kyag barà bá kyab pànn nu-à ku gib sig níng. I byar-à Ibrahim bi mà Ishaku. Su wàníng fòr awinyin, í wà ku kyag rìg wàníng jur. I wà Ishaku bi mà Yakubu, n bi kyag rìg wàníng jur-à tìnn. I wà Yakubu bi mà yann dwib agban pyànà, n bi kyag rìg káníng jur àdòníng tìnn. Yanká dwib agban pyànà níng, í yàkúyí big. ");
INSERT INTO jib_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ayau yann káníng ni, sái big bi sa rìg wùntunbá zyun akyib. Zìnnwá í Yusufu. Shunwòwá big zìg ku n wann tafinn yag rìg ku mà jànn Masar, ku yag shi shu fàu màhàn. Ama Shìdun shi sig á shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Barà ku shi shu fàu àdòníng, Shìdun bi zìg zu ku áyau shwìn bu-à ku ri wa níng. Sai-à big zìg bi ku á pyànn kùr Firauna, kùr ùwài-à á jànn Masar níng, Shìdun sa jirà a Firauna zìm Yusufu, a wàníng myàng Yusufu mpìr yar. I byar-à Firauna bi sìnn Yusufu a wàníng shi àgbam áyau luwá ni ma jànnwá bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","I byar-à amor bi kà á jànn Masar ma jànn Kanana á byar-à shunwòwá big shi sig níng. Mpìrká ri sa shi dìr wàni. Yàkúyí big big ri yàn kyann buju-à bá ji, big dìg fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Barà Yakubu fig big rag, buju shi sig mà jànn Masar, í byar-à ku bi swam yag yannwá big màhàn. I yàkúyí big, í kyonn-à wà wa zyun. ");
INSERT INTO jib_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kyonn-à wà wa pyànà, sái Yusufu dinya shunwòwá big n rag ku í wùntunbá. Ku dinya Firauna jír á shinn shunwòká buwá ni. ");
INSERT INTO jib_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","I byar-à Yusufu swam dinya tawá Yakubu rag, a wàníng bi á byarwá ni á jànn Masar, wàníng ma mpìrká á lu wàníng ni bidìm pár. Mpìrká hi, big yag hing mpìr dìb-sara agban dwib agban zu á myann swana. ");
INSERT INTO jib_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","I byar-à Yakubu ma mpìrká buwá big dù n yag mà jànn Masar, n yag shi màhàn. Hár ku shi n wu rìg màhàn, kwonn ma yàkúyí big, big wu rìg màhàn. ");
INSERT INTO jib_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Big zìg kàng yag kibá mà Shakima á jànn Kanana, n jì big mà amir-à Ibrahim wann sig ma bài á vù yannká bu Hamur. ");
INSERT INTO jib_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Barà su-à nyàan màg rag wà Shìdun má sa bu-à ku rì gib ya sig Ibrahim nu níng, í byar-à mpìrká buyí mà Masar big mà jwàr swàb kà wàni. ");
INSERT INTO jib_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Asim mpìr zyun kim bi na kùr mà Masar. Mpìr-à hi yì fig Yusufu bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ku lir ji mpìrká buyí, hár n ya big shwìn ùwài nímá. Ku du kà big rag, abig tafinn rìg yann àjannká bigbá jirà a káníng wu rìg. ");
INSERT INTO jib_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sai-à níng hi, í sai-à big mà Musa, í wùn zyun-à Shìdun ri myàng shi sig wùn ǹsàn nímá. Big ri myàng kwonn ma ku mà lu-à ni hár ku fòr sònn sara. ");
INSERT INTO jib_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","A byar-à níng hi big zìg zu rìg ku á lu-à ni. I byar-à wùn kùr, í wùn uwà zyun ku bi zìg Musa, n sìnn kàng wàníng a wàníng shi wùnwá, n pyag gbam wàníng. ");
INSERT INTO jib_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","I byar-à big bi tàg Musa yar bu-à mpìr Masar ri sa bidìm pár. Jírwá ku ri dang ma swàmwá ku ri sa bidìm, ri tìya mpìrká ku shi sig ma yar. ");
INSERT INTO jib_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Sai-à Musa fòr ji dìpyànà, sái bi kù kà ku á kyinn-à ni aku yag bib kà yiwaiwá big mpìr Israilaká. ");
INSERT INTO jib_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ku yag dìg mpìrwá zyun ri wa shwìn á vù mpìr Masar zyun ni. Barà ku myàng àdòníng, ku kà nu mpìrwá n dab pyann kàng mpìr Masar-à níng, n bi gban rìg wàníng. ");
INSERT INTO jib_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ku wà sig rag kó yiwaiwá big yì hing wà barà Shìdun ya sig ku gbam barà kwá zìg zu big, ama káníng yì fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","To, byar-à bi kyàr, Musa yag dìg mpìr Israila big pyànà, káníng ri ngang ngain bar dìrbá. Ku ri zìm aku gbar jùn kwonn káníng. Ku rag, ‘Aning myàng, yiwainá ńzyun. Bu-à sa ning ri ngang ngain bar dìrná í jir kai rà?’ ");
INSERT INTO jib_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sái zyun-à ri ya jàuwá shwìn níng, í tìr kann rìg-à Musa akur, n rag, ‘Mpìr-à sìnn kà sig wù á shi àgbam má á gib jír á shinnyí ni í ni rà? ");
INSERT INTO jib_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kó wù ri zìm á gban rìg mì àràg barà nà níng wù nà gban sig mpìr Masar níng rà?’ ");
INSERT INTO jib_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Barà Musa fig jír mpìr-à níng àdòníng, ku shàr dù rìg á jànn Masar ni, n yag shi rìg kyìnn mà jànn Madayana. A jànn-à níng hi, ku bi mà yann wunù big pyànà. ");
INSERT INTO jib_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ku shi màhàn ji dìpyànà. Su zyun ku yag mà yau awúnn mà agunn shinnkwìnn Sinai. I byar-à wùn aswam Shìdun mà wai bi tàg shinnwá á byarwá ni áyau pyìr-à ri swànn akyar bu. ");
INSERT INTO jib_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa myàng pyìr-à ri swànn níng, bu-à hi ya rìg ku mamaki. Ku yag yàr màhàn jirà aku myàng. Barà ku nyàan fòr màhàn, sái ku fig nài jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Wàníng dinya ku rag, ‘I mì Shìdun bu Ibrahim ma Ishaku ma Yakubu, yàkúká buwú wàrì.’ A byar-à hi, dìr Musa zwab kàg kàg kàg. Ku myàng yag fig zuwá mà byar pyìr-à hi bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","I byar-à Shìdun dinya ku rag, ‘Musa, á wan zu tabarwú. Byar-à à sar sig níng, í byar kyìkyàr. ");
INSERT INTO jib_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","I bu jau bàna, mì ri myàng mpìrká bumí mà jànn Masar barà big ri kig shwìn-à big ri wa níng, í bu-à sa ǹ wann bi sig jirà ń zìg zu big áyau-à ni. Mì ri zìm á bi ń swam yag wù mà Masar.’ ");
INSERT INTO jib_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa-à níng, í zyun-à mpìr Israilaká rì ngàng sig ku níng, big rì rag, mpìr-à sìnn sig ku àgbambá ma agib jírbá í ni rà? Musa-à níng, í zyun-à Shìdun swam yag sig ku aku shi àgbambá aku zìg zu big áyau shwìnbá ni, àràg barà wùn aswam Shìdun-à níng dinya sig ku jír áyau akyar bu rag aku sa níng. ");
INSERT INTO jib_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ku sa bu mamaki mà Masar, n zìg zu rìg big á jànn Masar. Ku sa bu mamaki á zàpìr zyun-à big ri bar Zàn Gbàinshìn, n sa mà awúnn-à ni hár ji dìpyànà. ");
INSERT INTO jib_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa-à hi ku í àsàin-à dinya sig mpìr Israilaká rag, Shìdun má swam ya bi big mpìr zyun àràg barà wàníng swam bi sig ku níng. Mpìr-à hi má shi ínì àsàin-à má dang kyann jir Shìdun. Mpìr-à hi má zu bi áyaubá ni. ");
INSERT INTO jib_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa í àsàin-à Shìdun sìnn sig má myàng kwonn ma mpìrká bu Shìdun ma kyonnbá áyau awúnn. I Musa-à wùn aswam Shìdun dinya ku jír mà shinnkwìnn Sinai. Ku shí nì Musa zyun-à Shìdun rì dinya sig ku jir yonki, hár ku zìg n ba sig jír-à hi jir shinnyí, yi mpìrká wà tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ama yàkúyí big ngàng wà bá fig jírwá. Big ngàng rìghing ku, mi ri zìm abig kàng yag kàng mà jànn Masar. ");
INSERT INTO jib_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","I byar-à big vig Haruna rag, a wàníng màm ya big bu sìnnká bá wib, buká má kà jag big à pyànn. Big rag, jir kai bàna Musa zyun-à zìg zu bi sig big mà jànn Masar níng, big yì fig bu-à sa sig ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Asai-à níng hi, í wà big bi yìg àsháu zyun àràg í wùn nai, mi ri twìb swànn bu á pyànnwá ni, mi ri wib àsháu-à hi àràg í Shìdun, big fig àjwár bu-à big sa sig ma vùbá, big sa buki, n sa àyán ma kàhi. ");
INSERT INTO jib_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","I wà Shìdun bi ya big kwìb, n zìg zu rìg vùwá áyaubá ni abig wib asuswirká àràg barà mpìrká rìi dang kyann jir Shìdun ba sig á tarkada n rag, ‘Ning mpìr Israila, ji dìpyànà ning shi sig mà awúnn-à ni, ning ri gib gban wi, mi ri twìb swànn bu, ning ri yá ni ra? Ning ya fig mì bàna. ");
INSERT INTO jib_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ning swann sig apig-à ning sa sig ma wau, wà ning sìnn kà sig bu sìnn ná Molek áni, ma bu sìnn ná wà ning ri bar Ramfan, wà ning sa sig àràg asuswir. Ning yìg sig bu káníng, mi ri wib sòr big, n ngàng wà ná wib mì. Jir wàníng má du kà abig zìg yag rìg ning mà jànn Babila, hár bá zìg wam zu yag ning mà pyànn.’ ");
INSERT INTO jib_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Yàkúyí big rì shi sig mà awúnn-à ni nonn hing. Big rìi swann kyann kwonn ma apig wau, wà ri tàg rag Shìdun shi sig mà byar-à níng hi. Big sa sig apig-à hi ábibir àràg barà Shìdun tìya sig Musa aku sa. ");
INSERT INTO jib_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Asim, yàkúyí big í àsàinká zìg pyann kàng sig apig-à níng ásim tabá ni, big swann kwonn ma kàhi á sai-à big yag kwonn ma Joshuwa, n zìg jànn-à Shìdun kan zu sig mpìrká áni níng. Apig-à hi shí mà jànn-à bó hi ni hár sai-à Dawuda bi na kùrwá. ");
INSERT INTO jib_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawuda bó, Shìdun ri fig àjwárwá. Ku í àsàin-à yàn sig gbìb-à kwá mi ya Shìdun bu Yakubu tonn. ");
INSERT INTO jib_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama wùnwá Sulemanu í àsàin-à mi ya sig Shìdun tonn-à hi. ");
INSERT INTO jib_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Shìdun ùwài, ku ri shi fig á lu-à mpìr mi sig bàna. I barà Ishaya mpìr-à rìi dang kyann jir Shìdun níng, ku dang rag, ");
INSERT INTO jib_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Shìdun dang rag, byar-à mà wai shi sig í byar-à má shi wann. A jìnn ni bó, í byar-à má sìnn wann bi barmí. To, wà má àdòníng, í swai lu-à wà áni, mpìr má mi ya mì rà? Byar-à má shi ngàng awunmí shi sig áni rà? ");
INSERT INTO jib_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bu káníng bidìm pár í mì ǹ màm fíg nì bàna rà?’ ");
INSERT INTO jib_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ning í mpìr sung gbam big, ning í mpìr kyinn kyìkyàr bàna. Ning í mpìr sung àkúnn big. Ning ri sa àràg barà yàkúná rì sa sig, ning má, ning ri ngàng kyann Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mpìr adang kyann jir Shìdun zyun-à yàkúná big ya fig ku shwìn bàna í wà áni rà? Yàkúná big gban mpìrká Shìdun swam bi sig, ká rì dinya sig big jír á shinn Mpìr Sìsàn zyun-à má bi. Tàma-à níng, ning zib mìrwá n gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ning í àsàinká Shìdun ya sig yàkúná dokawá á vù yann aswamká buwá ni mà wai, ama ning wib fig kàhi bàna.” ");
INSERT INTO jib_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Barà mpìr àgbamká fig jír-à Istifanus dang níng, í byar-à big nànn rìg àgùnn wàni, n zwàm kà vù á nginnbá ni, pìkyinnbá bai rìghing. ");
INSERT INTO jib_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","I byar-à kyinn Istifanus mònn rìg ma Awun Shìdun. Ku myàng nann zu yag zuwá mà wai, n myàng barà Shìdun shi sig ma awài. Ku myàng Yesu sar sig águnn vìm nu Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I byar-à ku dinya mpìrká rag, “Aning myàng, mì ri myàng waisháu-à ri pù finn, wùn mpìr jíkwìnn sar sig águnn vìm nu Shìdun ni.” ");
INSERT INTO jib_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Barà ku dang àdòníng, shun àgbamká níng kinn dang nài gbam, n zìg vù n bir dim á sungbá ni, n shàr kwonn yag mà byarwá ni sa wáb. ");
INSERT INTO jib_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Big gbar ta zu yag ku mà kwìm lu-à ni, n ta ku abàn. Mpìrká ta sig ku abàn níng, big sìnn sig jàbá á vù wùn sukà zyun big ri bar zìnnwá Shawulu. ");
INSERT INTO jib_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Big ta Istifanus ta ta. I byar-à ku dang rag, “Shinn Lumí Yesu, á zìg rìg awunmí.” ");
INSERT INTO jib_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ku bìnn kir wann á jìnn ni, n bar nài ngbam nímá n vig Shìdun rag, “Shinn Lumí, á sa pyann kàng mpìr káníng bu á dò jir bu pyìr-à big sa sig mì níng ni bàna.” Barà ku dang àdòníng, í byar-à yonkiwá í zu rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu zìm hing barà mpìrká gban sig Istifanus. Ayunn-à níng hi shwìn ùwài nímá dù á shinn mpìrká ri bàg Yesu, ká shi sig á finn swann Urushalima. Big bidìm pár shwìn-à hi kan yam gàb finn yag rìghing big mà agunn jànn Samariya, ma jànn Yahudiya. Sái dà sig rag yann aswamká. ");
INSERT INTO jib_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sai-à big gban Istifanus mpìrká kádà í mpìr awib Shìdun big bi jì ku, hár n kig nài kiwá wàni. ");
INSERT INTO jib_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shawulu bi, mi ri sa bai shu mpìrká ri bàg Yesu. Ku bi, mi ri kà lu lu, mi ri gbar zu wunù big uwà, mi ri kìg kà big á tonn fi-à ni. ");
INSERT INTO jib_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mpìrká big kan yam gàb finn sig níng, big bidìm pár, byar-à ba yag bidìm pár, big yag mi ri dinya mpìrká jir àjwár á shinn Yesu. ");
INSERT INTO jib_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mpìr zyun big ri bar Filibus, ku dù n yag mà finn swann zyun á jànn Samariya, ku dinya mpìrká màhàn jir Kristi zyun-à Shìdun swam bi sig níng. ");
INSERT INTO jib_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Barà mpìrká fig bu-à Filibus dang sig níng, sái big gang sung, big zìg bi pìkyinnbá abig fig jír-à ku ri dang níng, jir kai bàna big ri myàng bu mamakiká ku ri sa níng. ");
INSERT INTO jib_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wàuká ri gàb dìr big mpìrká big dab sig níng mi ri yan yán. Mpìrká ká barbá ri wúwa, big ká vùká ma barká wu tàg rìghing níng, bidìm pár big gbam rìghing. ");
INSERT INTO jib_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sái mpìrká mà finn swann-à ni big fig gban rìg íri àjwár. ");
INSERT INTO jib_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A finn swann-à níng hi, mpìr zyun shi sig áni zìnnwá í Siman. Ku í mpìr subu. Swàm-à ku ri sa níng ri ya mpìrká mamaki. Hár ku gbar dù shinn rag, ku í mpìr ùwài. ");
INSERT INTO jib_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mpìrká á finn swann-à níng hi bir pìkyinn á bu-à ku ri sa, àgbam ma yann wùnshái bidìm pár. Big rag bu-à níng í gbam Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Swàm subu-à ku ri sa níng, mpìrká ri bàg ku, jir kai bàna nonn hing ku ri sa subu-à hi. ");
INSERT INTO jib_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama barà Filibus dinya big jír barà Shìdun má na kùrwá, n dinya big jir Yesu, í wà big bir pìkyinn áni, wunù big uwà bidìm pár, big wau rìg dìr batisma. ");
INSERT INTO jib_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hár Siman ma shinnwá má, ku bir pìkyinn tìnn. I byar-à big wau ku dìr batisma. I wà ku bàg kyann Filibus. Ku ri myàng swàm bu-à wàníng ri sa kyann, hár ku ri sa mamaki. ");
INSERT INTO jib_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sái yann aswamká bu Yesu á finn swann Urushalima big fig tai rag, mpìrká mà finn swann Samariya zìg rìghing jir Shìdun. Sái big swam yag Bitrus ma Yohanna mà byar-à hi ni. ");
INSERT INTO jib_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Barà Bitrus big yag fòr màhàn, big vig ya káníng Shìdun rag Awun Shìdun aku bi kà á shinnbá ni, ");
INSERT INTO jib_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","jir kai bàna Awun Shìdun-à hi bi fig ma á shinn mpìr zyun áyaubá ni bàna. Sái dái big wau sig big dìr batisma ma zìnn Shinn Luyí Yesu. ");
INSERT INTO jib_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","I byar-à Bitrus ma Yohanna tib wann big vù á shinn-à ni. I wà Awun Shìdun bi á shinnbá ni. ");
INSERT INTO jib_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Siman myàng barà big ya Awun Shìdun á byar mpìrká ri bàg Yesu á sai-à káníng tib wann vùbá á shinn mpìrká ni, sái ku bi du ya káníng bài ");
INSERT INTO jib_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","n rag buwá ku ri zìm a káníng ya ku gbam-à big ri sa swàm ma kàhi níng tìnn, àjirà wà kwa tib hing mpìr vù á shinn-à ni, a wàníng dìg Awun Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sái Bitrus dinya ku rag, “Wù big bàiwú í zyun bidìm pár aning bai rìg, jir kai bàna à sìnn sig á pìkyinnwú ni bu-à Shìdun ri ya átai, buwú wá wann big bài. ");
INSERT INTO jib_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bu-à du wù ma swàm-à níng bàna, jir kai bàna pìkyinnwú shi fig ǹsàn á pyànn Shìdun ni bàna. ");
INSERT INTO jib_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","A dà fim rìg bu-à bibai-à wù ri kyab á pìkyinnwú ni níng, á vig Shìdun. Kó káhi kwá yafa ya wù bu pyìrwú níng. ");
INSERT INTO jib_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mì ri myàng wù, wù í mpìr akyib. Bu-à bibai pànn gbam rìghing wù.” ");
INSERT INTO jib_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sái Siman rag, “Aning vig ya mì Shìdun jirà kada bu-à ning dang sig níng ma pànn mì bàna.” ");
INSERT INTO jib_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bitrus ma Yohanna big dinya mpìrká á Samariya jírbá barà big myàng sig Yesu, n dinya káníng jir Shìdun bidìm pár. Sái big dù, n kyann á kauyeká shi sig á jànn Samariya, mi ri dang jir àjwár á shinn Yesu. Hár big kyann, n yag fòr mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ayúnn zyun wùn aswam Shìdun mà wai bi dìg Filibus, n dang jír ma ku. Ku dinya Filibus rag a wàníng dù a wàníng yag zu gbìb zyun, gbìb-à zu sig mà Urushalima, n yag sig mà finn swann Gaza. I gbìb awúnn zyun. ");
INSERT INTO jib_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Sái Filibus dù, n zu gbìb-à níng hi. Ku ri yag á gbìb-à ni, sái ku yag dìg kwonn big mpìr zyun, í mpìr Habasha. Wàníng bàna ma dìr. Mpìr-à hi shi síg nì àgbam àsàin-à ri sìnn gbam bài á jànn-à bó hi ni. Ku ri sa swàm kùr-à màhàn, kùr-à hi í uwà zyun big ri bar ku Kandekatu. Wunù-à níng hi yag sig mà Urushalima jirà aku wib Shìdun màhàn. ");
INSERT INTO jib_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wunù-à níng hi shi kà sig áyau keke zyun ni, vinnká ri gbar yag ku. Ku ri kàng bi mà Urushalima. Ku ri yag, ku ri jangga jír-à Ishaya ba sig áyau jir Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","I byar-à Awun Shìdun dinya Filibus rag, a wàníng yag dìg mpìr-à níng, ma a wàníng kyann yàr agunn keke-à ni. ");
INSERT INTO jib_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibus shàr yag shàu, n yag fòr mà byar wàníng ni. Ku fig wàníng ri jangga tarkada-à hi. Sái ku bib wàníng rag, bu-à wàníng ri jangga níng, wàníng fig yì hing rà? ");
INSERT INTO jib_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wàníng rag, “Sáshinn má fig yì rà? Wà mpìr zyun ma tàg fig mì bàna, má yì fig bàna.” I byar-à ku dinya Filibus rag, a wàníng nann kà, aku ma wàníng shi zyun á vinn àkar-à ni. ");
INSERT INTO jib_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Byar-à wàníng ri jangga níng big ba sig jír rag, “Big ri gbar ya ku àràg àdùn bá zìg yag mà byar-à big ri gib gban. Aràg barà big ri wann zu wài àdùn, àdùn ri pù fig nu bàna níng, wàníng má, í barà ku pù fig nuwá bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Big zìg kàng rìg ku á sìm, big sìnn kàng ku àràg ku í mpìr bàna. Byar-à big wà sig ku kwonn-à níng, big wà fig ku ábibir bàna. Barà zuwá bàna á dunyaru níng, mpìr má yì fig yann adawá big bàna.” ");
INSERT INTO jib_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Barà àgbam mpìr-à níng jangga kinn rìg jír-à hi, sái ku bib Filibus rag, “Bu-à mpìr-à rìi dang kyann jir Shìdun dang sig níng, ku dang síg shinnwá rà, kó ku dang síg mpìr zyun kim rà?” ");
INSERT INTO jib_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sái Filibus dinya ku yìr jír á shinn bu-à ku ri jangga níng ni. N dinya rìg ku jir àjwár-à á shinn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Barà big ri yag, sái big yag dìg zàpìr á gbìb-à ni. Agbam mpìr-à níng rag, “Filibus, zàpìr shi sig níng, bu-à má kan dim wà á wau mì dìr batisma í kai rà?”  ");
INSERT INTO jib_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibus dinya ku rag, “Wà wa bir hing pìkyinn ńzyun á byar Yesu ni, má wau wù dìr batisma.” Agbam-à níng rag, nn, ku bir hing pìkyinn rag Yesu Kristi í wùn Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","I byar-à ku pànn sar wann keke-à hi n bi tìg wann, í byar-à ku wann kà yag á zàpìr-à ni, ku ma Filibus. I wà Filibus bi wau rìg ku dìr batisma mà byar-à níng hi. ");
INSERT INTO jib_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Barà big nann zu bi á zàpìr-à ni, sái Awun Shìdun bi zìg rìg Filibus á byar-à hi. Agbam-à níng myàng fig rag ku bàna. Agbam-à níng ri yag kyonnwá kyinnwá jwar shi nímá. ");
INSERT INTO jib_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus rag aku myàng níng, ku shi sig mà lu ùwài zyun big ri bar Azota. Sái ku dù kyonnwá, ku yag swann kim kim, mi ri dinya mpìrká jir àjwár bu Yesu. Hár n yag fòr mà Kaisariya. ");
INSERT INTO jib_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A sai-à níng hi, Shawulu shi sig mà finn swann Urushalima. Ku ri ya mpìrká ri bàg Yesu shwìn, mi ri dang rag kwá gban rìg big. ");
INSERT INTO jib_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","I byar-à ku yag mà byar àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun, n yag vig wàníng a wàníng ya ku tarkada, kwá zìg yag mà tonn bìr kwonnká bu Yahudawaká ni, mà finn swann Dimashka. Ku ri zìm tarkada-à hi jirà aku pànn mpìrká ri bàg Yesu níng, aku pànn bi big á tonn fi á finn swann Urushalima. Kwá sìr wunù ma uwà bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Barà ku zìg tarkada-à hi, ku ri yag á gbìb-à ni, ku nyàan finn swann Dimashka fòr, sái ku rag aku myàng níng, ku myàng byar-à shim yar kàng kwìb ku áni tain tain, mà waisháu-à ni. ");
INSERT INTO jib_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ku kù wann á jìnn ni, sái ku fig nài jír wann bi mà wai ri bar ku rag, “Shawulu, Shawulu, sáshinn wù ri ya mì shwìn àdòníng rà?” ");
INSERT INTO jib_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sái Shawulu rag, “Wù í ni rà, wù Shinn Lumí?” Wàníng rag, “I mì Yesu àsàin-à wù ri ya mì shwìn níng. ");
INSERT INTO jib_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama á dù nann zu á yag mà finn swann-à wù ri yag níng. I byar-à bá dinya wù bu-à wá sísa.” ");
INSERT INTO jib_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mpìrká nu yag sig ku á gbìb-à ni níng, pànn shi sig akim, jir kai bàna big ri fig nài jír, ama big myàng fig mpìr bàna. ");
INSERT INTO jib_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","I byar-à hi Shawulu ngang dù nann zu. Ku rag aku myàng finn zuwá àdòníng, ku myàng fig rag bàna. I wà big gbar yag ku á vù, n zìg yag ku mà finn swann Dimashka. ");
INSERT INTO jib_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ku shi sig màhàn suwá sara, ku myàng fig bàna, ku ji fig bàna, ku wa fig bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A finn swann Dimashka mpìr zyun ri bàg Yesu shi sig màhàn zìnnwá í Hananiya. Ayúnn-à níng hi Shinn Luyí Yesu bi dinya ku jír á la-à ni, n rag, “Hananiya.” Hananiya rag, “Shinn Lumí, ǹ shi sig níng.” ");
INSERT INTO jib_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yesu rag, “A dù, á yag zu á gbìb zyun-à big ri bar rag Gbìb Vivonn. A yag bib lu mpìr zyun zìnnwá í Yahuda. Wá dìg mpìr-à big ri bar ku Shawulu màhàn, ku í mpìr á finn swann Tarsus. Ku ri vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ku myàng mpìr zyun kà bi ku á la-à ni, n tib ku vù á shinnwá ni jirà aku dìg aku myàng. Mpìr-à níng hi í wù Hananiya.” ");
INSERT INTO jib_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","I wà Hananiya dang rag, “Ayáa, Shinn Lumí, mpìr-à wù ri dang níng, ku ri ya mpìrká ri bàg wù mà finn swann Urushalima shwìn wàni. ");
INSERT INTO jib_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ku bi sig mà byar àgbamká ri twìb swànn bu mà Urushalima, ku bi kwonn sig ma gbam á finn swann-à níng ni jirà aku sìr mpìrká ri bàg wù. I wà à rag ń yag á byarwá ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Shinn Luyí rag, “A yag, mpìr-à níng ǹ shig zu sig ku aku shi wùn aswammí. Má swam yag ku á byar mpìrká swai kim kim. Kwá dinya káníng ma kùrbá jír á shinnmí ni. Hár má, kwá dinya yann Israila big bidìm pár jírmí. ");
INSERT INTO jib_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Má dinya ku shwìn-à kwá wa á dò jir shinnmí ni.” ");
INSERT INTO jib_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Barà Yesu dinya kinn rìg Hananiya àdòníng, sái Hananiya dù, n yag fòr á byar-à Shawulu shi sig, n yag tib wàníng vù á shinn-à ni. Ku rag, “Wunzàmí Shawulu, í Shinn Lumí Yesu swam bi síg mì nì á byarwú ni, àsàin-à ning ku nìm dìg kwonn á gbìb-à ni á sai-à wù nìm bi níng. I ku swam bi síg mì nì, ń bi ń tib wann wù vù á shinn-à ni, àjirà á myàng. Hár má, àjirà á dìg Awun Shìdun.” ");
INSERT INTO jib_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Barà ku dang kinn jírwá àdòníng, sái bu zyun àràg í akwàu jái kù zu á yìr zu Shawulu ni, í wà ku bi myàng rag. A byar-à hi big wau ku dìr batisma. ");
INSERT INTO jib_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","I wà ku ji buju, hár n dìg kàng gbam dìrwá. Shawulu na su pyànà á finn swann Dimashka, mi ri shi kwonn big mpìrká ri bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gbìb fig tá bàna, sái ku dù, n yag kà á tonn bìr kwonnká bu Yahudawaká ni, mi ri dang jir Yesu rag, “Yesu í wùn Shìdun.” ");
INSERT INTO jib_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mpìrká ri fig jírwá níng, big sa mamaki á dò shinnwá ni. Big rag, “Wàníng í mpìr-à rìi ya mpìrká ri bàg Yesu shwìn mà finn swann Urushalima níng bàna rà? Ku bi sig áyág jirà aku zìg yag káníng mà byar àgbamká ri twìb swànn bu mà Urushalima jirà abig wà káníng kwonn rà?” ");
INSERT INTO jib_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Shawulu dìg gbam n dang jir Yesu wàni. Barà ku ri dang rag Yesu í Almasihu mpìr-à Shìdun swam bi sig níng, bu-à hi vù rìghing Yahudawaká shi sig mà Dimashka wàni. Bai wà bá sa yipyàr. ");
INSERT INTO jib_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ku shi shi shi. I byar-à Yahudawaká kwonn nubá á shinnwá ni jirà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Big sìnn kà sig mpìrká a káníng shi kidim nu nkyun-à á finn swann-à ni fi ma àyúnn, jirà abig sar gib Shawulu ma abig gban rìg ku. Ama ku fig rìghing wà káníng ri bònn myàng byar-à kwá zu, àjirà abig pànn ku, abig gban rìg. ");
INSERT INTO jib_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sái yann sukàwá big bi sa yar zyun. Big zìg gágsàg zyun ùwài nímá, n bi zìg Shawulu á fi-à ni, n sìnn kà ku áni, n dìnn kà jùr áni, n du zu ku á pùr dan kinn-à big mi kàng kwìb sig finn swann-à áni. ");
INSERT INTO jib_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Barà ku zu á finn swann Dimashka àdòníng, ku yag mà Urushalima jirà aku kwonn shinn ma mpìrká ri bàg Yesu. Ku yag dìg káníng àdòníng, big shàr zinnwá. Big ri shàr, big yì fig wà í àjai barà ku kàng rìghing wùn sukà Yesu níng bàna. ");
INSERT INTO jib_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","I byar-à Barnabas kà nuwá n zìg yag ku á byar yann aswamká bu Yesu, n dinya big bar bu-à sa sig wàníng, barà wàníng dìg kwonn sig big Yesu á gbìb-à ni. Yesu dinya sig wàníng jír hár í wà wàníng ri dinya mpìrká jír á shinn Yesu á finn swann Dimashka hár ma pìkyinn wim. ");
INSERT INTO jib_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sái mpìr káníng zìg ku, ku ma káníng shi í zyun. Ku ma káníng ri kyann kyann á finn swann Urushalima, mi ri dinya mpìrká jír á zìnn Shinn Luyí Yesu ma pìkyinn wim. ");
INSERT INTO jib_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hár ku dang jír big mpìr Yahudawaká ká ri dang nu jir Helena. Ku ma káníng ri sa yipyàr. Káníng ri zìm abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Barà mpìrká bu Yesu fig àdòníng, big zìg yag ku mà finn swann Kaisariya, í wà n tìr yag ku mà finn swann Tarsus. ");
INSERT INTO jib_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I byar-à hi mpìrká ri bàg Yesu níng, dìg barà bá shi shubá ǹsàn nímá. Shwìn-à big rìi wa níng sa ma rìghing. Agunn jànn Yahudiya ma jànn Galili ma jànn Samariya mpìrká ri bàg swàb kà Yesu. Awun Shìdun ri myàng kwonn ma big. Mpìrká ri wib Shìdun big pìkyinn ńzyun. ");
INSERT INTO jib_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Barà Bitrus ri yag kó áni, ku yag fòr á kauye zyun big ri bar rag, Ludda. Ku yag bib kà mpìrká ri bàg Yesu màhàn. ");
INSERT INTO jib_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A byar-à hi ku dìg mpìr zyun màhàn, mpìr-à vùwá wu tag rìghing big barwá, wàníng na sig á syu dìr wa ji awinyin, wàníng dù nann zu fig áwai bàna. Zìnn mpìr-à níng hi í Iniyas. ");
INSERT INTO jib_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Barà Bitrus myàng ku àdòníng, ku rag, “Iniyas, Yesu Kristi ri dàb gbam wù. A dù nann zu, á pìnn bunáwú.” Sái wàníng í dù nann zu-à. ");
INSERT INTO jib_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mpìrká á Ludda mà mpìrká á jànn Sarona big myàng hing ku. I byar-à big bidìm pár big bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A finn swann Jopa uwà zyun shi sig áni big ri bar ku Tabita. A nu jir Helenanci big ri bar ku Dorkas, (yìr zìnnwá níng í wikyínn). Ku í mpìr-à ri sa kyann bu ǹsàn, mi ri sa shang mpìr ashiká. ");
INSERT INTO jib_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A sai-à níng hi ku bi na dor n bi wu rìg. Big wau ku dìr, n bi jag ku á tonn zyun shi sig mà wai. ");
INSERT INTO jib_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa shi yàr sig big Ludda. Barà mpìrká ri bàg Yesu fig rag Bitrus shi sig mà Ludda, í wà big swam yag mpìr pyànà á byarwá ni, n vig ku rag, aku bi á byarbá ni kíni. ");
INSERT INTO jib_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I byar-à Bitrus dù, n bàg yag big. Ku rag aku yag fòr níng, ku yag dìg uwà kiká kwonn shi sig á finn tonn-à ni byar-à big jag sig Tabita. Big shi sig, mi ri tìya ku swai jàká Tabita rì kwìb ya sig big. Big ri kig nài kiwá. ");
INSERT INTO jib_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus bi kan zu rìg mpìrká á tonn-à ni bidìm pár, n kà yag n bìnn kir wann á jìnn ni, n vig Shìdun. I wà n bar uwà-à níng rag, “Tabita, á dù nann zu.” Sái Tabita myàng finn zuwá, n myàng Bitrus, n dù nann zu n shi á wai. ");
INSERT INTO jib_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus du yag vù, n pànn ku n gbar dù nann zu ku n bar mpìrká kwonn shi sig níng, n zìg ku n ya big, ku wìm kàng rìghing. ");
INSERT INTO jib_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I byar-à mpìrká mà finn swann Jopa ni bidìm pár big fig jír bu mamaki-à Bitrus sa sig níng. Hár big nìnànn nímá big bir pìkyinn á byar Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bitrus shi su nìnànn nímá á finn swann Jopa, ku shi sig á lu mpìr zyun big ri bar ku Siman. Mpìr-à níng hi í àsàin-à ri sa samyib wau wi. ");
INSERT INTO jib_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mpìr zyun shi sig áni big ri bar ku Kaniliyas. Ku shi sig á finn swann Kaisariya. Mpìr-à níng hi í àgbam áyau sojaká ni agunn swàmwá big ri bar Italiya. ");
INSERT INTO jib_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ku ri shàr Shìdun wàni. Ku ma mpìrká mà luwá ni bidìm pár big ri wib Shìdun. Ku ri sa shang mpìr ashiká áyau Yahudawaká ni, mi ri vig kyann Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ayúnn zyun àsháu sara wà àkamzau, sái ku rag aku myàng níng, wùn aswam Shìdun mà wai bi á byarwá ni á la-à ni, n bar ku rag, “Kaniliyas”. ");
INSERT INTO jib_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pìkyinnwá gib. Ku myàng wàníng n rag, “Sáshinn rà?” Wàníng rag, “Shìdun fig hing bu-à à vig sig níng. Ku ri fig àjwár ma swàm ǹsàn-à wù ri sa ya mpìr ashiká níng. Ku myàng hing hár mà wai. ");
INSERT INTO jib_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","A swam mpìrká abig yag mà finn swann Jopa abig bar bi mpìr zyun màhàn zìnnwá í Siman Bitrus. ");
INSERT INTO jib_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I Siman zyun-à shi sig kyìnn á lu mpìr zyun àsàin-à ri sa samyib wau. Zìnn mpìr-à níng hi í Siman tìnn. Ku shi yàr sig á nu zàpìr.” ");
INSERT INTO jib_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Barà wùn aswam Shìdun-à níng dinya Kaniliyas àdòníng, sái ku dù dà fim rìg wàníng. I wà Kaniliyas bar bi mpìr pyànà, big í yann sukàká á finn luwá ni. Ku bar kwonn káníng ma soja zyun, mpìr-à ri wib Shìdun, mi ri sa ya ku swàm. ");
INSERT INTO jib_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mpìr sara káníng ku bar bi big, n dinya byann big bu-à wùn aswam Shìdun dinya sig ku. I wà ku swam yag big mà Jopa abig bar bi Bitrus. ");
INSERT INTO jib_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na kyàr byar-à barà mpìr káníng ri yag á gbìb-à ni, àyúnn-à fòr áyau shinn, big yag fòr mà Jopa. Bitrus shi sig buwá á finn swann Jopa. Ku nann zu yag sig á shinn tonn-à ni mà wai jirà aku vig Shìdun màhàn. ");
INSERT INTO jib_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Amor ri gban ku wàni. Barà big ri sa buju-à, big sa kinn fig ma bàna, sái ku la la. ");
INSERT INTO jib_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ku myàng waisháu-à pù fim rìghing. Ku myàng bu zyun shi àràg jà zyun ùwài nímá ri wann bi. Big pànn sig sung jà-à, mi ri zìg tìg wann bi. ");
INSERT INTO jib_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ku rag aku myàng nann yag zuwá àdòníng, ku myàng wiká kim kim, ma ká ri bam kyann á jìnn ni, ma ayinnbuká kim kim. Bidìm pár big shi sig áyau jà-à hi ni. ");
INSERT INTO jib_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sái ku rag aku fig níng nài jír wann bi mà wai, nài jír-à hi dang rag, “Bitrus, á du nann zu, á zìg bu káníng, á gib gban ma á zwam.” ");
INSERT INTO jib_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bitrus dang rag, “Shinn Lumí, ǹ taba zwam fig bu-à bibai, kó bu shìnn bàna, sáshinn má zwam rà?” ");
INSERT INTO jib_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nài jír-à hi dinya jakàng ku n rag, “Bu-à Shìdun sìnn sig níng í bu ǹsàn, kada á sìnn kàng bu-à hi rag í bu bibai bàna.” ");
INSERT INTO jib_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bu-à hi sa àdòníng kàun sara, í wà big zìg nann kàng yag rìg jà-à hi mà wai. ");
INSERT INTO jib_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bitrus shi sig, mi ri kyab yìr la-à ku la sig níng. I byar-à hi mpìrká Kaniliyas swam yag sig níng, big bib dìg rìghing lu Siman n sar sig á nu nkyun gbàdán-à ni. ");
INSERT INTO jib_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Big bib rag, “Mpìr-à big ri bar ku Siman Bitrus níng, ku tìg sig kyìnn áyág rà?” ");
INSERT INTO jib_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Barà Bitrus ri kyab la-à ku la sig níng, í byar-à Awun Shìdun dinya ku rag, “Bitrus, á myàng, mpìr sara bi sig á byarwú ni mi ri yàn kyann wù. ");
INSERT INTO jib_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","A dù, á tìg wai yag jirà aning ma big yág zyun. A kyab jír bàna. I mì ǹ swam bi sig big í nì.” ");
INSERT INTO jib_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A byar-à hi sái Bitrus dù, n wann yag á byar mpìr káníng ni, n dinya káníng rag, “Mpìr-à ning ri yàn kyann níng í mì. Bu-à zìg bi sig ning í kai rà?” ");
INSERT INTO jib_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Big rag, “I Kaniliyas àgbam áyau sojaká swam bi sig yi í nì. Ku í mpìr ǹsàn, mpìr-à ri wib Shìdun. Hár mpìr Yahudawaká big bidìm pár big ri yan ku. Wùn aswam Shìdun zyun bi á byarwá ni, n dinya ku rag, aku bar bi wù á luwá ni jirà aku fig jír bu-à wá dinya ku.” ");
INSERT INTO jib_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Big dang àdòníng, sái Bitrus bar kà bi big á finn lu-à hi. Big na kyàr byar-à. Byar-à kyàr ku ma káníng dù n yág zyun. Mpìrká káhi áyau mpìrká ri bàg Yesu á finn swann Jopa, bàg yag big tìnn. ");
INSERT INTO jib_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Byar-à kyàr í wà big fòr yag mà Kaisariya, byar-à Kaniliyas ri shi kir ku. Kaniliyas bar kwonn rìghing yiwaiwá big ma jàuwá big, mi ri shi kir Bitrus. ");
INSERT INTO jib_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Barà Bitrus kà yag mà lu-à ni àdòníng sái Kaniliyas bi bìnn kir wann á pyànnwá ni mi ri wib ku. ");
INSERT INTO jib_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bitrus dinya ku rag, “A dù nann zu. Mi í Shìdun bàna. Mì í mpìr àràg wù.” ");
INSERT INTO jib_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bitrus dang jír ma Kaniliyas, big kà yag mà finn lu-à ni. Ku yag dìg bìr mpìrká kwonn sig nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I byar-à Bitrus dinya big rag, “Ning yì hing, buyí yi mpìr Yahudawaká, sàn fig wà ayi kà á lu mpìrká zyun-à í Yahudawaká bàna. Ama Shìdun dinya sig mì rag, kada ń dinya mpìrká swaibá kim rag big fòr fig wà má kwonn shinn ma big bàna. ");
INSERT INTO jib_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wàníng í bu-à sa sai-à ning swam bi aswam á byarmí ni, ǹ ngàng fig wà bí bi bàna. Tàma-à níng aning dinya mì bu-à sa ning bar bi sig mì níng.” ");
INSERT INTO jib_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A byar-à níng hi Kaniliyas dinya Bitrus n rag, “Kwonn ma wà janá-à níng, sa hing su sara, á sai-à ǹ vig sig Shìdun á finn lumí ni, sai-à níng hi í àsháu sara wà àkamzau. I wà ǹ myàng mpìr zyun sar sig á pyànnmí ni, jàwá ri ngìg tain tain nímá. ");
INSERT INTO jib_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ku dinya mì rag ‘Kaniliyas, Shìdun fig hing bu-à à vig sig ku níng, ku myàng hing vù bu yawú tìnn.’ ");
INSERT INTO jib_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ku dinya mì rag ń swam mpìrká abig yag mà finn swann Jopa á byar mpìr zyun ni zìnnwá í Siman Bitrus, zyun-à tìg sig kyìnn á lu Siman zyun-à ri sa samyib wau. Luwá shi yàr sig á nu zàpìr. ");
INSERT INTO jib_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gbìb fig tá bàna, ǹ swam yag aswam mà byarwú ni. A ngàng fig bàna, à bi hing. Tàma-à níng, yi kwonn shi sig níng, yi ri zìm ayi fig bu-à Shìdun dinya sig wù á dinya yi.” ");
INSERT INTO jib_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","A byar-à níng hi Bitrus dinya big rag, “Tàma-à níng ǹ myàng hing barà Shìdun ri zìm mpìr zyun, mi ri ngàng fig mpìr zyun bàna. ");
INSERT INTO jib_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mpìr-à ma ri shàr Shìdun n ma ri sa bu-à ǹsàn, Shìdun má zìg ku, kó ku ma í swai mpìr wà áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ning yì hing bu-à sa sig á jànn Israila, barà Shìdun swam dinya big jir àjwár wà má sa tag pìkyinn á jir shinn Yesu Kristi, zyun-à í Shinn Lu kó ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ning yì hing bu-à sa sig á jànn Israila, bu-à hi sa jag sig á jànn Galili sai-à Yohanna dang kinn rìg jírwá á shinn batisma. ");
INSERT INTO jib_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ning fig hing tai Yesu mpìr-à á Nazarat barà Shìdun wìr kà ya sig ku Awunwá kwonn ma gbamwá. Ku kyann kyann, mi ri sa swàm ǹsàn, mi ri dàb gbam mpìrká ká shi sig á vù Shaitan ta wàu bibaiká, jir kai bàna Shìdun shi sig big ku. ");
INSERT INTO jib_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yi yann sukàwá big yi myàng hing buká ku sa sig bidìm pár mà jànn Yahudawaká ni hár big wà á finn swann Urushalima. Yi myàng hing barà big zìg ku, n dab bàg gbam rìg ku á bín n gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ku na su pyànà ámir-à ni, í wà àyúnn-à wà wa sara Shìdun bi gbar dù kàng rìg ku mà amir-à ni. Sai-à ku dù nann zu mà amir-à ni níng, Shìdun sìnn ku aku tàg shinnwá á byar mpìrká ni. ");
INSERT INTO jib_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ku zu bi fig á pyànn mpìrká ni bidìm pár bàna. Ama ku zu bi sig á pyànnyí ni, yi mpìrká Shìdun shig zu sig níng. Yi ká, zyun-à yi ji n wa ma ku, sai-à ku dù nann zu kàng mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ku dinya yi rag ayi tàg mpìrká jírwá ma ayi dinya mpìrká rag, Yesu í zyun-à Shìdun sìnn sig ku àsàin-à má wà kwonn mpìrká shi sig ma yonki ma ká wu rìghing níng. ");
INSERT INTO jib_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ku í zyun-à mpìrká rìi dang kyann jir Shìdun dang sig jír á shinnwá ni n rag mpìrká ma bir hing pìkyinn á byarwá ni, Shìdun má yafa ya rìg big bu pyìr-à big sa sig níng á jir zìnnwá ni.” ");
INSERT INTO jib_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Barà Bitrus ri dang jírwá àdòníng, sái Awun Shìdun wann bi á shinn mpìrká ri fig jírwá níng ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mpìrká nu bi sig Bitrus mà Jopa níng, big myàng hár big sa mamaki. Mpìr káníng hi big í mpìr Yahudawaká. Big rag, “Asái, Shìdun ya sig mpìrká swai kim kim Awunwá tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Big fig káníng ri dang nu jír àpyú mi ri yan Shìdun áni. ");
INSERT INTO jib_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Sái Bitrus dang rag, “Mpìr káníng dìg rìghing Awun Shìdun àràg barà yi mpìr Yahudawaká dìg sig níng, mpìr-à má kan dim sar big dìr batisma wau í ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A byar-à hi ku rag, abig wau káníng dìr batisma á zìnn Yesu Kristi. I wà mpìrká níng rag a Bitrus shi kù ma big su pyànà. ");
INSERT INTO jib_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mpìrká ri bàg Yesu mà jànn Yahudiya ma yann aswamká bu Yesu fig rag, mpìrká ká í Yahudawaká bàna níng, big zìg rìghing jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Barà Bitrus yag mà finn swann Urushalima, mpìrká ri ya ku laifi. Mpìr káníng ri dang rag, wà mpìr-à ma í Yahudawa bàna ma ri zìm aku bàg Shìdun, sái abig kyag ku jur. ");
INSERT INTO jib_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","I byar-à big bib Bitrus rag bu-à sa ku yag kyìnn á byar mpìrká zyun-à í mpìr Yahudawaká bàna n ji kwonn buju ma káníng, í kai sá nì rà? ");
INSERT INTO jib_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","I byar-à Bitrus dinya big jír bu-à sa jag sig ku, ku dinya byann big kó kai bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ku rag, “Sai-à ǹ shi sig á finn swann Jopa, mì ri vig Shìdun, sái ǹ la la ǹ myàng jà zyun yiya nímá big pànn sig sungwá yina, wann bi n bi tìg á pyànnmí ni. ");
INSERT INTO jib_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Sái ǹ rag ń myàng níng, ǹ myàng wiká shi sig áni kim kim, wi awúnn, ma bu apyagká, ma ayinnbu, ma buká ri ngang kyann á jìnn ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","I byar-à ǹ fig nài jír wann bi mà wai, mi ri bar mì rag, ‘Bitrus, á dù nann zu, á zìg á gib gban, á zwam.’ ");
INSERT INTO jib_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mì í zìm-à n rag, ‘Shinn Lumí, ǹ taba zwam fig bu-à bibai, kó bu shìnn bàna. Sáshinn má zwam rà?’ ");
INSERT INTO jib_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","I byar-à ǹ fig jakàng nài jír wà wa pyànà ri dinya mì rag, Bu-à Shìdun sìnn kàng sig í bu ǹsàn kada ń dang rag í bu bibai bàna. ");
INSERT INTO jib_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bu-à hi sa àdòníng hár kàun sara, í wà big zìg nann kàng yag rìg mà wai. ");
INSERT INTO jib_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A byar-à hi mpìr sara sar sig á nu nkyun-à ni. Big swam bi sig big mà Kaisariya abig bi bar mì. ");
INSERT INTO jib_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","I byar-à Awun Shìdun dinya mì rag, ń yag kwonn ma mpìr káníng, ń kyab jír bàna. I wà ǹ dù, mì yag-à. Mpìr sùnnjin káníng nu yag mì mà Kaisariya. Yi yag kà á lu Kaniliyas. ");
INSERT INTO jib_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kaniliyas dinya yi rag, wùn aswam Shìdun mà wai bi á byarwá ni n dinya ku rag, aku swam yag aswam mà Jopa abig bar bi mì, ");
INSERT INTO jib_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ma àjirà ń yag dinya ku jír zyun-à ku ma mpìrká á luwá ni bidìm pár bá wìm zu áni. ");
INSERT INTO jib_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Barà ǹ kà mì ri dinya big jír àdòníng, sái Awun Shìdun wann bi á byar mpìr káníng ni, àràg barà ku rì wann bi sig á byaryí ni wàrì níng. ");
INSERT INTO jib_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","I byar-à ǹ kyab pànn bu-à Yesu rì dinya sig yi rag, ‘Yohanna wau sig mpìrká dìr batisma ma zàpìr, ama batisma wà mà pyànn níng, Shìdun má wau ning ma Awunwá’. ");
INSERT INTO jib_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Barà Shìdun ya sig mpìrká mà lu Kaniliyas Awunwá àràg barà ku ya sig yi á sai-à yi bir pìkyinn á byar Yesu níng, sáshinn má kan dim swàm Shìdun, má rag big fòr fig wà Shìdun má zìg big bàna rà?” ");
INSERT INTO jib_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Barà mpìrká fig àdòníng, big sa fig rag yipyàr bàna, big swam yan Shìdun, big rag, “Asái Shìdun ri zìm mpìrká zyun-à í Yahudawaká bàna níng, abig dà fim bu pyìrbá jirà abig wìm zu tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sai-à big gban Istifanus níng, mpìrká ri bàg Yesu big shàr yam gàb fim rìghing á jir shinn shwìn-à mpìrká ri ya big níng. Kádà yag mà jànn Finikiya, kádà yag ma jànn Kubrus, kádà yag mà jànn Antakiya. Byarká big yag sig níng, big dinya fig mpìr àtaiká jir Yesu bàna, sái íri mpìr Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama mpìrká ká ri bàg Yesu, ká bi sig mà jànn Kubrus ma Kurane, big yag mà Antakiya, mi ri dinya mpìr àtaiká jir àjwár áshinn Yesu. ");
INSERT INTO jib_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gbam Shinn Luyí shi sig á shinnbá ni. Mpìrká nìnànn nímá bir pìkyinn á byar Yesu ni, mi ri wib ku. ");
INSERT INTO jib_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tai bu-à sa sig á jànn Antakiya níng yag kà á sung mpìrká ri bàg Yesu mà Urushalima. I byar-à big swam yag Barnabas a wàníng yag mà Antakiya. ");
INSERT INTO jib_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barà Barnabas yag fòr màhàn àdòníng, ku yag myàng barà Shìdun sìnn sig àsànwá áshinn mpìrká ni. Barà ku myàng àdòníng, ku fig àjwár á pìkyinnwá ni wàni. Ku dang gbam big kyinn rag, abig bàg Shinn Luyí Yesu ma kyinn ńzyun. ");
INSERT INTO jib_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas í mpìr-à shi sig big pìkyinn sìsàn á pyànn Shìdun. Awun Shìdun mònn sig á kyinnwá ni, ku ri bir kyann pìkyinn á byar Shìdun wàni. Mpìrká nìnànn nímá ri bàg swàb kà Yesu á jir shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","I byar-à Barnabas yag mà finn swann Tarsus jirà aku yàn Shawulu màhàn. ");
INSERT INTO jib_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Barà ku dìg wàníng àdòníng, ku zìg yag wàníng mà Antakiya. Big shi màhàn ji zyun, mi ri tàg mpìrká ri bàg Yesu jir Shìdun. Mà Antakiya í byar-à big bar jag mpìrká ri bàg Yesu zìnn Krista. ");
INSERT INTO jib_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A sai-à hi ni mpìrká káhi mà Urushalima bi á Antakiya. Big í mpìrká ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mpìr zyun áyaubá ni zìnnwá í Agabas. Ku sar dù nann zu áyau mpìrká ni, mi ri dinya big jír ma gbam Awun Shìdun rag, suká ri bi níng, amor má gban wàni á jànn-à ni bidìm pár. Amor-à hi bi gban hing á sai-à Kalaudiyas na sig kùrwá. ");
INSERT INTO jib_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Sái mpìrká ri bàg Yesu mà Antakiya níng kwonn bài jirà abig sa shang mpìrká ri bàg Yesu mà jànn Yahudiya. Kó ni zìg bi bu-à gbamwá fòr sig. ");
INSERT INTO jib_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Big zìg bàiká big kwonn sig níng n ya á vù Barnabas ma Shawulu a káníng zìg yag kwonn ma kàhi mà byar àgbamká áyau mpìrká ri bàg Yesu mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Asai-à níng hi mpìrká káhi áyau mpìrká ri bàg Yesu níng, big wa shwìn á vù kùr Hirudus ni. ");
INSERT INTO jib_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ku du kà mpìrká big pànn Yakubu wunzà Yohanna, n kyag gban rìg wàníng ma kafai. ");
INSERT INTO jib_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Barà ku myàng Yahudawaká ri fig àjwárwá á dò jir bu-à ku sa sig níng ni, í wà ku pànn Bitrus tìnn. Ku pànn wàníng áyau suká big ri ji brodi zyun-à bàna big yisti. ");
INSERT INTO jib_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Barà ku pànn wàníng n du kà á tonn fi-à ni, ku ya kà wàníng á vù sojaká ri sar gadi. Big shi sig mpìr yina yina, hár kyau yina tìnn. Ku sìnn káníng jirà a káníng sar myàng kwonn ma Bitrus í zyun, jirà sai-à ba ji wam zu rìghing buju àyúnn Pìm Wam Zu, bá zìg bi Bitrus á pyànn mpìrká ni jirà abig wà ku kwonn. ");
INSERT INTO jib_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","I byar-à big fim Bitrus mà tonn fi-à ni, mpìrká ri bàg Yesu big ri vig Shìdun á jir shinnwá ni, jirà a Shìdun zìg zu ku. ");
INSERT INTO jib_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A fi-à ni Hirudus ri kyab rag wà byar-à ma kyàr hing, bá zìg zu bi Bitrus jirà abig wà ku kwonn. Bitrus na kà sig áyau soja pyànà, ku na jànn kwonn sig ma kan àsháu-à big wìr kà sig ku á vù-à ni. Asar gadiká káhi sar dim sig á nu nkyun-à ni. ");
INSERT INTO jib_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","I byar-à hi wùn aswam Shìdun mà wai kà yag mà tonn-à ni, finn tonn-à í yar rìg-à gbauu. Wùn aswam Shìdun pànn Bitrus á fir vù-à ni n dab finn zir wàníng. Bitrus fìm finn zir. Wùn aswam Shìdun dinya ku rag, aku dù nann zu kíni. Sái Bitrus dù. A byar-à níng hi kan àsháu-à big wìr kà sig ku á vù-à ni níng, í wan zu rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wùn aswam Shìdun rag, aku zir gbam byànntíwá ma aku pag kà tabar. Bitrus zir gbam byànntíwá, n pag kà tabarwá. Wùn aswam Shìdun rag, “A bir mayafiwú, ma á bàg bi mì.” ");
INSERT INTO jib_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bitrus í mayafiwá í bir-à, mì wàníng í bàg yag-à. Barà ku kan bàg yag wàníng níng, ku wà sig rag ku ri la la. Ku yì fig wà bu-à hi í àjai bàna. ");
INSERT INTO jib_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Big dù, n wam zu rìg mpìrká sar sig gadi-à níng, n wam zu yag kàng mà byar gadi-à wà wa pyànà. Big bi fòr á byar nu nkyun-à byar-à bá zu má kà á finn swann-à ni. Agìr nu nkyun-à níng hi big sa sig big àsháu. Barà big fòr yag àdòníng àgìr nu nkyun-à hi í pù fim rìg-à ma shinnwá. Big zu yag mà myann, n yag bànn fù zu rìg mà gbìb-à ni, mi ri yag. I byar-à wùn aswam Shìdun-à níng dà fim rìg Bitrus màhàn. ");
INSERT INTO jib_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","I byar-à Bitrus dang rag, “Asái, ǹ yì rag hing wà bu-à sa sig mì níng í àjai. Shìdun swam bi wùn aswamwá, n zìg zu rìghing mì áyau shwìn-à Hirudus ya sig mì níng. Bu-à mpìr Yahudawaká ri zìm abig sa mì níng, Shìdun zìg zu rìghing mì áyau-à ni.” ");
INSERT INTO jib_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Barà ku yì rag bu-à sa sig ku níng, í byar-à ku dù n yag mà lu Maryamu na Yohanna Markus, n yag dìg mpìrká kwonn shi sig màhàn, big ri vig Shìdun á shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ku yag kwìb nu nkyun-à kwìb kwìb. Sái wùn uwà zyun dù bi. Zìnn wùn uwà-à níng hi í Roda. Ku bi aku pù nu nkyun-à. ");
INSERT INTO jib_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sai ku rag aku fig nài jír-à, í nài jir Bitrus. Ku shàr kàng yag mà finn lu-à ni ma àjwár á pìkyinnwá ni. Ku pù fig nu nkyun-à bàna, n yag dinya mpìrká rag “I Bitrus!” ");
INSERT INTO jib_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Big rag, Kai! Kwá shàr ǹsáng rà? Ama ku rag, “Ajai í Bitrus.” Sái big rag, “I ku bàna, adìnwá bi síg nì.” ");
INSERT INTO jib_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Barà Bitrus shi sig, mi ri kwìb nu nkyun-à, big bi pù fim ya ku. Barà big myàng ku àdòníng big sa mamaki. ");
INSERT INTO jib_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","I byar-à ku kà yag, n sa nann zu big vù rag, abig shi akim. Ku kan dinya big barà Shìdun zìg zu sig ku áni mà tonn fi-à ni. I wà ku dinya káníng rag, a káníng dinya Yakubu ma mpìrká ri bàg Yesu bidìm pár bu-à sa sig níng. Barà ku dang kinn jírwá àdòníng, ku dù mà byar-à hi, n yag rìg byar zyun. ");
INSERT INTO jib_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Byar-à bi kyàr. Mpìrká ri sa gadi á tonn fi-à ni níng, myàng fig Bitrus bàna. Pìkyinnbá gib, jir kai bàna big yì fig byar-à ku dù, n yag sig bàna. ");
INSERT INTO jib_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A byar-à hi kùr Hirudus rag abig yàn kyann ku. Big dìg fig ku bàna. Sái big bi pànn àsàinká ri sa gadiwá níng. Hirudus bib big jír, í wà n dang rag abig gban rìg big. Daka á byar-à hi Hirudus dù mà jànn Yahudiya, n yag mà Kaisariya. Ku shi màhàn su títi nímá. ");
INSERT INTO jib_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirudus ri dù kyinn ma mpìrká á jànn Taya ma Sidon. I byar-à mpìr káníng kwonn shinn n yag mà byar Hirudus. Big yag jag má á byar àgbam swàm áyau luwá ni, àgbam-à hi zìnnwá í Bilastus. A byar Bilastus ni, big dìg gbìb-à yág mà byar Hirudus ni, n dang jír barà bá jùn kwonn kàng ma ku, jir kai bàna big ri dìg kyann buju á jànnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ayúnn zyun ku wìr kà sig jà kùrwá, n shi sig, mi ri dang jír ma mpìrká bi sig á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sai mpìrká ri dài swam ku. Big rag, “Kai! Wàníng í mpìr ri dang fíg nì jír-à níng bàna, í Shìdun ri dáng nì.” ");
INSERT INTO jib_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A byar-à hi wùn aswam Shìdun mà wai dab ta wann Hirudus á jìnn ni, jir kai bàna Hirudus wib fig Shìdun bàna. Afirká zwam gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","I byar-à hi jir Shìdun swàb kà yag rag mà pyànn á byar mpìrká nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ma Shawulu sa kinn rìg swàmbá zyun-à mpìrká á Antakiya ri zìm abig sa mà Urushalima, í wà big kàng bi á Antakiya. Big bi kwonn ma Yohanna Markus. ");
INSERT INTO jib_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ayau mpìrká ri bàg Yesu mà Antakiya, mpìrká káhi ri dang kyann jir Shìdun, káhi ri tàg mpìrká jir Shìdun. Mpìr káníng í Barnabas ma Simiyan (zyun-à big ri bar ku mpìr pìpìr), ma Lukiyas (mpìr-à mà Kurane) ma Shawulu ma Manayin, zyun-à ku ma kùr Hirudus wài gbam nann zu sig í zyun. ");
INSERT INTO jib_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Barà big ri wib Shìdun, mi ri sìnn nu, í byar-à Awun Shìdun dinya big rag, “Aning fim ya mì Barnabas ma Shawulu, jirà abig sa swàm-à ǹ ya sig big níng.” ");
INSERT INTO jib_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","A byar-à níng hi, big sìnn nu, n vig Shìdun, n tib wann káníng vù á shinn-à ni. I byar-à big swam yag big. ");
INSERT INTO jib_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barà Awun Shìdun swam yag Barnabas ma Shawulu àdòníng, í byar-à big dù n yag mà Salukiya. Big yag kà á kòr zyun ni, n zu yag rìg mà swàin Kubrus. ");
INSERT INTO jib_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Big yag fòr mà finn swann Salamis, á swàin Kubrus, mi ri dinya mpìrká jir Shìdun á tonn bìr kwonn bu Yahudawaká ni. Yohanna Markus shi sig ma big mi ri sa shang big swàm. ");
INSERT INTO jib_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Big kyann kyann á swàin Kubrus, n yag fòr mà Bafas, mà mìr swàin-à ni mà tài. Mà byar-à níng hi, big dìg kwonn ma mpìr zyun màhàn zìnnwá í Bar-Yashuwa. Ku í mpìr subu, ku í mpìr Yahudawaká. Ku gim ǹsáng rag ku í mpìr-à ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ku í jàu gwamna Sarjiyas Bulus, gwamna-à níng hi yì sig bu wàni. Gwamna-à hi bar bi Barnabas ma Shawulu jirà aku fig jir Shìdun á nu káníng ni. ");
INSERT INTO jib_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jàu gwamna-à níng hi ku í mpìr subu, ku ri sa yipyàr ma jírbá. A nu jir Helena big ri bar ku zìnnwá Alimas. Ku ri zìm aku kan dim gwamna a wàníng zìm jir káníng bàna. ");
INSERT INTO jib_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","I byar-à Shawulu zyun-à big ri bar ku Bulus níng, Awun Shìdun kà á pìkyinnwá ni, ku myàng byann wàníng myàng byann byann, ");
INSERT INTO jib_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","n dinya wàníng rag, “Wù wùn Shaitan, wù í mpìr-à mònn sig ma bu-à bibai, wù í mpìr-à ri ngàng bu-à sìsàn. Wù ri kar ngang jirà á sìnn kàng jir Shìdun àràg í jir ǹsáng. ");
INSERT INTO jib_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Shìdun má tib wann vùwá á shinnwú ni tàma tàma-à níng, wá myàng kyàr fig rag byar bàna, hár sái àyúnn zyun.” A byar-à níng hi, zuwá í wan kinn rìg-à kùun. Ku myàng kyàr fig rag bàna. Ku ri ka kyann vùwá, mi ri yàn mpìr-à má gbar ku. ");
INSERT INTO jib_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Barà gwamna-à hi myàng àdòníng, ku bir pìkyinn á jir Yesu ni. Ku sa mamaki ma jír-à big tàg sig á shinn Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulus ma jàu kyonnwá big dù á finn swann Bafas, n kà á kòr zàpìr, n yag mà finn swann Barga, á jànn Pamfiliya. I byar-à Yohanna Markus dù dà fim rìg big, n kàng yag rìg mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","A byar-à níng hi, Bulus ma Barnabas dù màhàn, n yag mà Antakiya, í finn swann zyun á jànn Bisidiya. Ayúnn Asabar big yag kà mà tonn bìr kwonn bu Yahudawaká ni, n shi wann màhàn. ");
INSERT INTO jib_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Barà àgbamká jangga kinn rìg doka Musa, ma bu-à mpìrká rìi dang kyann jir Shìdun ba sig, í byar-à big bar Bulus rag, “Ning wunzàyí big, wà na shi sig ma jír zyun-à má gbar gbam mpìrká pìkyinn, aning bi dang.” ");
INSERT INTO jib_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","I byar-à Bulus sar dù nann zu á wai, n dang jírwá rag: “To, ning mpìr Israilaká ma mpìrká kim kim ká ri wib Shìdun níng, aning gang sung ma aning fig jírmí. ");
INSERT INTO jib_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Shìdun bu mpìr Israilaká rì shig zu sig yàkúyí big, jirà ayi shi mpìrká buwá. Sai-à big ri shi kyìnn á jànn Masar, ku sa big big mà jwàr wàni. Barà big mà jwàr àdòníng, sái ku bi zìg zu yag rìg big á jànn Masar ni ma gbamwá ku shi sig ma kàhi. ");
INSERT INTO jib_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Big ri kyann kyann áyau awúnn-à ni hár ji dìpyànà. Shìdun ri sa muyar ma big. ");
INSERT INTO jib_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Shìdun bi gban rìg kyau mpìr sùmpyànn, ká shi sig á jànn Kanana, n bi ya rìg yàkúyí jànn-à hi. ");
INSERT INTO jib_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Big shi á jànn Kanana ji dari yina big dìpyànà agban dwib. “I byar-à Shìdun bi sìnn àgbamká zyun-à má gib jír, hár sai-à Samaila zyun-à í mpìr-à rìi dang kyann jir Shìdun níng, bi shi àgbambá. ");
INSERT INTO jib_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Big vig Shìdun rag a Shìdun wìr ya big kùr. Shìdun bi wìr ya big Shawulu wùn Kish yiwai Banjamin. Ku na sig kùrwá hár ji dìpyànà. ");
INSERT INTO jib_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","I wà Shìdun gbar tìg wann rìg ku, n bi sìnn pyann kàng Dawuda, wà zyun-à Shìdun dang sig jír á shinnwá ni rag, ‘Dawuda wùn Yassa í swai mpìr-à mì ri zìm, jir kai bàna kwá wib jírmí.’ ");
INSERT INTO jib_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mpìr apínn-à Shìdun tìr bi ya sig yi mpìr Israilaká níng, í Yesu ku zìg zu sig áyau yiwai Dawuda ni àràg barà ku dang sig. ");
INSERT INTO jib_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sai-à Yesu bi fig ma bàna níng, Yohanna rì dinya mpìr Israilaká rag abig fim bu pyìr sa, ma abig wau rìg dìr batisma. ");
INSERT INTO jib_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Barà ku nyàan swàmwá sa kinn àdòníng, sái ku bib mpìrká rag, ‘Ning ri kyab rag mì í mpìr-à Shìdun rag kwá swam bi níng rà? Mì í ku bàna. Mpìr-à hi bi fig ma bàna, kwá bi á simmí ni. Mpìr-à hi, ǹ fòr fig wà má wan zu tabarwá bàna.’ ” ");
INSERT INTO jib_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bulus rag, “Ning wunzàmí big, yiwai Ibrahim ma swai mpìrká kim kim ká ri bàg Shìdun, jír-à má pinn zu mpìr wà Shìdun tìr bi sig níng, ku tìr bi síg á dò shinnyí ni. ");
INSERT INTO jib_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mpìrká mà Urushalima ma àgbamká bigbá yì byann fig ku bàna. Ayúnn Asabar big ri jangga kyann bu-à mpìrká rìi dang kyann jir Shìdun ba sig á shinnwá ni, ama big yì byann fig bàna. Big bi gban rìg ku àràg barà káníng ba sig. ");
INSERT INTO jib_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mpìr káníng pànn fig Yesu ma laifi bàna, ama big vig Bilatus rag a wàníng dang rag abig gban rìg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Barà big gban rìg ku àdòníng, big zìg tìg wann ku á bín-à ni, n jì kà ku á shar-à ni. Bu-à big sa sig níng, í bu-à mpìrká rìi dang kyann jir Shìdun ba sig á shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Shìdun gbar dù nann zu kàng rìghing ku ma yonki. ");
INSERT INTO jib_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ku shi suwá nìnànn nímá, mi ri tàg shinnwá á byar mpìrká rì kyann sig ma ku daka á jànn Galili, n nu yag sig ku mà Urushalima. Tàma-à níng big í àsàinká ri dinya mpìrká bu-à big myàng sig. ");
INSERT INTO jib_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","To, wàníng í bu-à sa yi ri dinya ning jir àjwár-à níng, jir kai bàna bu-à Shìdun rì gib ya sig yàkúyí big nu níng, yi yann adaká bigbá yi myàng hing, ");
INSERT INTO jib_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","barà ku gbar dù nann zu Yesu mà amir-à ni big yonki. Bu-à Shìdun sa sig níng, í bu-à big rì ba sig áyau tarkada Zabura sura pyànà n rag, ‘A shi nì í wùnmí, janá-à níng ǹ kàng rìghing tawú.’ ");
INSERT INTO jib_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Barà Shìdun gbar dù kàng ku ma yonkiwá n rag kwá wu fig ki bàna níng, big ba sig á jir Shìdun ni n rag, ‘Bu-à ǹ dinya sig Dawuda rag má sa níng, í bu-à má sa ya wù. Má sa ya wù bu ǹsàn nímá.’ ");
INSERT INTO jib_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ayau tarkada Zabura byar zyun big ba sig rag, ‘Shìdun má fim fig dìr wùn sukà kyìkyàrwá a wàníng swàr bai mà amir-à ni bàna.’ ");
INSERT INTO jib_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Barà Dawuda sa kinn rìg bu-à Shìdun ri zìm aku sa níng, ku í wu rìg-à. Big jì kwonn ku ma yàkúwá big, dìrwá í swàr bai rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama mpìr zyun-à Shìdun gbar dù kàng sig mà amir-à ni níng, dìrwá swàr fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Wunzàmí big, á jir shinn Yesu ni Shìdun má yafa ya ning bu pyìrná. ");
INSERT INTO jib_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A dò jir shinnwá ni mpìr-à ma bir hing pìkyinnwá kwá wìm zu áyau bu pyìrwá ni. Doka Musa má pinn zu sar fig mpìr bàna. ");
INSERT INTO jib_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Barà ning shi sig ma gbìb-à ná wìm zu áni níng, aning bir pìkyinn áni, kada aning ngàng bàna. Kada bu-à big ba sig á tarkada Shìdun ni níng, aku sa ning bàna. Big ba sig rag, ");
INSERT INTO jib_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ning mpìrká ri ngàng bu-à Shìdun dinya sig ning níng, ná myàng bu mamaki, hár ná wu kinn rìg. Má sa bu zyun, ama ná bir fig pìkyinn áni bàna, kó wà ba dinya byann hing ning má, ná ngàng.’ ” ");
INSERT INTO jib_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Barà Shawulu ma Barnabas dang kinn rìghing jírbá má zu á tonn bìr kwonn-à ni àdòníng, sái mpìrká vig big rag, abig bi dang jakàng jír àyúnn Asabar zyun-à ri bi bó. ");
INSERT INTO jib_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Barà bìr mpìrká ri zu á tonn bìr kwonn-à ni àdòníng, mpìr Yahudawaká nìnànn nímá ma mpìrká swai kim kim ká ri kà kwonn ma big á tonn bìr kwonn-à ni, big bàg yag Bulus ma Barnabas. I byar-à káníng dang gbam big pìkyinn n rag abig shi áyau àsàn-à Shìdun sa ya sig big. ");
INSERT INTO jib_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Asabar zyun-à ásim níng, mpìrká á finn swann-à ni nìnànn nímá, big bi jirà abig fig jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ama barà Yahudawaká myàng mpìrká kwonn bi sig nìnànn nímá mi ri fig jir Bulus, sái big sa ku akyib. Big ri sa yipyàr ma bu-à ku ri dang níng, mi ri swau ku. ");
INSERT INTO jib_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","I byar-à Bulus ma Barnabas wim kyinn n dinya big n rag, “To, ning mpìr Yahudawaká níng, shi ya sig yi àràg í tonn ayi nìm zìg bi jag jir Shìdun á byarná ni, ama ning ngàng jír-à hi. Ning zìm fig wà aning dìg yonki kinn kinn bàna. To, yá fim ning, yá zìg yag jír-à hi á byar mpìrká zyun-à í Yahudawaká bàna. ");
INSERT INTO jib_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wàníng í barà Shìdun dinya sig yi áni rag, ‘N sìnn sig wù á shi àràg í bu-à má yar ya mpìrká á dunyaru bidìm pár barà bá wìm zu áni.’ ” ");
INSERT INTO jib_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Barà mpìrká ká í Yahudawaká bàna big fig barà Bulus dang àdòníng, big fig àjwár n swam yan jir Shinn Luyí. Mpìrká ká Shìdun shig zu sig big jirà abig dìg yonki kinn kinn níng, big bir pìkyinn á jír-à hi ni. ");
INSERT INTO jib_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","To, jir Shinn Luyí níng shan gban rìghing finn jànn-à màhàn bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Sái Yahudawaká bi kar zìng uwàká ká ri wib Shìdun big í àgbam, kwonn ma wunù àgbamká á finn swann-à ni, jirà abig kan zu Bulus ma Barnabas. Big sa káníng akyib n kan zu rìg káníng á finn jànn-à ni. ");
INSERT INTO jib_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","I byar-à yann aswam káníng dab pìg kyàr rìg avír á barbá ni jirà abig tàg rag, mpìr káníng sa sig big bu-à sàn fig bàna. Sái big yag mà finn swann Ikoniya. ");
INSERT INTO jib_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mpìrká ri bàg Yesu fig àjwár wàni, Awun Shìdun kà mònn sig á pìkyinnbá ni. ");
INSERT INTO jib_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","To. A finn swann Ikoniya, í byar-à Bulus ma Barnabas yag kà á tonn bìr kwonn bu Yahudawaká ni àràg barà big ri sa kyann. Big dinya mpìrká jir Yesu. Hár Yahudawaká ma mpìrká zyun-à í Yahudawaká bàna nìnànn nímá bir pìkyinn á jír-à hi ni. ");
INSERT INTO jib_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama Yahudawaká ká bir fig pìkyinn á jir Yesu ni bàna níng, yag dìg mpìrká ká í Yahudawaká bàna, mi ri gbar dù káníng kyinn jirà a káníng bai dìr ma mpìrká ri bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Sái Bulus ma Barnabas big shi rìg á finn swann-à ni, hár big shi nonn màhàn. Big ri dang jir Yesu kwonn ma àsànwá, zinn bàna. Big ri sa swàm bu mamaki kim kim ma gbam-à Shìdun ya sig big. Barà káníng myàng bu mamakiká big ri sa níng, káníng bir pìkyinn á jírbá ni. ");
INSERT INTO jib_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mpìrká á finn swann-à ni kyàb gàfinn rìghing kyau pyànà. Kádà ri bàg jir Yahudawaká, kádà ri bàg jir Bulus ma Barnabas. ");
INSERT INTO jib_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mpìrká swaibá kim kim kwonn ma Yahudawaká, ma àgbambá big bi, big ri zìm abig ya Bulus ma Barnabas shwìn, ma abig ta gban káníng ma abàn. ");
INSERT INTO jib_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Barà Bulus ma Barnabas fig tai jír-à hi àdòníng, í byar-à big shàr zu rìg á finn swann-à ni, n yag rìg águnn jànn Likoniya. I byar-à big kà á finn swann Listra ma finn swann Darba ma kauyeká shi kàng kwìb sig áni níng. ");
INSERT INTO jib_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Big ri dinya kyann mpìrká jir àjwár á shinn Yesu ni màhàn. ");
INSERT INTO jib_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A finn swann Listra mpìr zyun shi sig áni, barwá bàna ma gbam. I barà big mà sig ku, ku taba kyann fig kyonn bàna. ");
INSERT INTO jib_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ayúnn-à Bulus big bi kà á finn swann-à hi ni, wunù-à níng ri shi mi ri fig jírbá. Barà Bulus myàng ku, ku shi sig ma pìkyinn barà kwá dang rag a Shìdun dàb gbam ku, ");
INSERT INTO jib_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","í byar-à Bulus dinya ku ma gbam n rag, “A dù nann zu á wai.” Ku bi pìm dù nann zu mi ri kyann kyonn. ");
INSERT INTO jib_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Barà bìr mpìrká myàng àdòníng, big dang á nu jir Likoniya ni n rag, “Kai! I bu sìnn kà síg nì á dìr mpìr káníng ni, n wann bi síg nì áyág.” ");
INSERT INTO jib_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","I byar-à big bar Barnabas rag Zafas, í zìnn bu sìnn zyun. Bulus bó, jirà ku í àsàin-à ri dang jír níng, big bar ku Hamis, í zìnn bu sìnn zyun tìnn. ");
INSERT INTO jib_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Lu byar-à big ri wib Zafas shi sig á nu nkyun finn swann-à mà myann. Sái àgbam bu sìnn-à níng hi zìg yann nai ma awu bín, n rag bá wib káníng áni. ");
INSERT INTO jib_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barà Bulus ma Barnabas myàng bu-à mpìr káníng ri zìm abig sa níng, sái big gbar ka jàbá n shàr kà yag áyau bìr mpìrká ni, n dinya mpìrká rag, ");
INSERT INTO jib_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bu-à sa ning sìnn kàng sig yi àràg yi í Shìdun níng, í kai sá nì rà? Yi í mpìr jíkwìnn àràg ning. Yi bi sig áyág jirà ayi dinya ning jir àjwár á shinn Yesu ni, jirà aning fim bu sìnnká ning ri wib níng, wà fòr fig bu zyun bàna, ma aning vim bìr kàng bi á byar Shìdun àsàin yonki, zyun-à màm sig waisháu-à ma dunyaru ma zàpìr ma buká shi sig áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sai-à rì níng, Shìdun rì fim sig kó ni aku sa bu-à kyinnwá ma ri zìm bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama Shìdun ri tìya kyann ning pìkyinn-à sìsàn, mi ri sa ya ning swàm barà ná yì ku shi sig áni. Ku ri ya ning shyù, ku ri ya ning buju, ku ri sa byann ya ning buká ning ri tàg á da-à ni. Ku ri sa jwar pìkyinn ná.” ");
INSERT INTO jib_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kó barà big dinya mpìr káníng jír-à níng, ama big sa dakyar í wà n kan dim bìr mpìr káníng rag a káníng wib big bàna. ");
INSERT INTO jib_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","I byar-à mpìr Yahudawaká káhi mà Antakiya ma Ikoniya big bi, n gbar dù kyinn mpìrká á shinn Bulus. Hár mpìrká ta ku ma abàn ta ta, í wà n gbar swann yag rìg ku mà kur lu-à ni. Big ri kyab rag ku wu rìghing. ");
INSERT INTO jib_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sái mpìrká ká ri bàg Yesu sar kàng kwìb sig ku áni, mi ri myàng ku, í byar-à ku dù nann zu, n kàng yag mà finn swann-à ni. Ku ma Barnabas bi na byar kyàr, í wà big dù n yag mà finn swann Darba. ");
INSERT INTO jib_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Big ri dinya mpìrká jir àjwár á shinn Yesu ni á finn swann Darba. Mpìrká nìnànn nímá bir pìkyinn á byar Yesu. A byar-à hi big dù n kàng yag mà Listra, hár n yag mà Ikoniya big Antakiya á jànn Bisidiya, ");
INSERT INTO jib_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","mi ri dang gbam mpìrká ri bàg Yesu kyinn, abig sar gbam á pìkyinn birbá ni. Big dinya káníng rag, “Sai wà ya wa hing shwìn nìnànn nímá í wà yá kà lu Shìdun íni.” ");
INSERT INTO jib_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Byar-à mpìrká ri bàg Yesu bidìm pár ri shi kwonn, big shig zu ya káníng àgbamká. Big vig Shìdun á shinn káníng ni, n sìnn nu n ya kà káníng á vù Shìdun ni barà káníng bir sig pìkyinn á byar wàníng ni níng. ");
INSERT INTO jib_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bulus ma Barnabas kyann kàng kwìb rìg jànn Bisidiya, hár n fòr yag mà jànn Pamfiliya. ");
INSERT INTO jib_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Big dinya mpìrká mà finn swann Barga jir Yesu. I wà big dù n yag mà finn swann Ataliya. ");
INSERT INTO jib_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","I byar-à big kà á kòr zàpìr n kàng yag mà finn swann Antakiya mà byar àsàinká swam bi sig big níng, ká rì vig sig Shìdun á shinnbá ni, barà Shìdun má myàng kwonn ma big áyau swàmbá zyun-à big sa vinn sig tàma-à níng. ");
INSERT INTO jib_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Barà big yag fòr mà Antakiya, big bar kwonn mpìrká ri kwonn shinn mi ri bàg Yesu n dinya káníng jír bu-à Shìdun sa ya sig big áyau swàmbá ni, barà Shìdun pù ya mpìrká ká í Yahudawaká bàna pyù barà káníng bir pìkyinn á jir Yesu. ");
INSERT INTO jib_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Big shi nonn màhàn ma mpìrká ri bàg Yesu. ");
INSERT INTO jib_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mpìrká káhi mà Yahudiya bi á Antakiya, mi ri tàg mpìrká ri bàg Yesu rag, “Wà na kyag fig jur bàna, àràg barà doka Musa dang sig níng, ná wìm zu fig bàna.” ");
INSERT INTO jib_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Barà Bulus ma Barnabas fig àdòníng, sái big bi sa yipyàr rag í nímá bàna. I byar-à mpìrká ri bàg Yesu rag, a Bulus ma Barnabas kwonn ma mpìrká káhi áyaubá ni abig yag mà Urushalima abig yag dang jír ma yann aswamká bu Yesu, kwonn ma àgbamká abig wà byann jír-à hi. ");
INSERT INTO jib_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","I byar-à mpìrká ri bàg Yesu swam yag big. Barà big ri yag mà Urushalima big wam zu á jànn Finikiya ma jànn Samariya. Sái big dinya mpìrká á jànn káníng ni barà mpìrká swai kim kim vim bìr bi á byar Shìdun. Hár mpìrká ri fig àjwár á dò shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Barà big fòr yag mà Urushalima àdòníng, mpìrká ri bàg Yesu ma yann aswamká màhàn, ma àgbamká shà big shà shà. I wà big dinya káníng barà Shìdun sa sig swàmwá á byar mpìrká big rì dinya sig káníng jir Yesu. ");
INSERT INTO jib_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Sái mpìr Farisawaká ká ri bàg Yesu, big sar dù nann zu n dang rag, “Mpìrká swaibá kim kim ká ri bàg Yesu, shi sig àràg í tonn abig kyag jurbá, ma abig wib doka Musa.” ");
INSERT INTO jib_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","I byar-à àgbamká ma yann aswamká kwonn í byar ńzyun jirà abig wà jír-à hi. ");
INSERT INTO jib_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Barà big ri wà jír àdòníng, sái Bitrus dù nann zu n dang rag, “To, ning wunzàmí big, aning shi kim, ń dinya ning jír. Daka á ninonn Shìdun shig zu sig mì áyauná ni, n rag ń dinya byann mpìrká swaibá kim jir àjwárwá, jirà abig fig ma abig bir pìkyinn áni. ");
INSERT INTO jib_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Shìdun àsàin-à ri yì bu-à shi sig á pìkyinn mpìr níng, ya sig mpìrká zyun-à í Yahudawaká bàna níng Awunwá àràg barà ku ya sig yi mpìr Yahudawaká níng, jirà ayi yì rag ku ri zìm mpìrká bó tìnn. ");
INSERT INTO jib_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ku gàfinn fig yi rag yi kim, big kim bàna, jir kai bàna ku tu kyàr rìghing pìkyinnbá barà big bir sig pìkyinn á byar Yesu ni níng. ");
INSERT INTO jib_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","To, wà má àdòníng, sáshinn ning ri zìm mpìrká abig bàg gbìb wà zyun-à yi ma yàkúyí big rì bàg sar fig bàna níng rà? Ning ri ya big swánn ùwài àdòníng, ning ri màg màg fig muyar Shìdun rà? ");
INSERT INTO jib_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yi má, yi wìm zu sig á dò jir shinn àsàn Shinn Luyí Yesu ni, jir pìkyinn biryí á byarwá ni. To, big má í àdòníng tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Barà bìr mpìrká fig Bulus ma Barnabas ri dinya big bu mamakiká Shìdun sa sig á vùbá ni áyau mpìrká swai kim kim níng, í byar-à big wìr shi sig yir yir. ");
INSERT INTO jib_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Barà big dang kinn rìghing jírbá àdòníng, sái Yakubu sar dù nann zu n dinya big rag, “To, ning wunzàmí big, aning fig. ");
INSERT INTO jib_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Tàma-à níng yi fig rìghing jir Siman Bitrus barà ku rag, Shìdun shig zu sig mpìrká kádà swai kim kim jirà a káníng shi mpìrká buwá. ");
INSERT INTO jib_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wàníng shi sig àràg barà mpìrká rìi dang kyann jir Shìdun dang sig á tarkada jir Shìdun ni rag, ");
INSERT INTO jib_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘A pyànn ná-à níng má kàng bi, má bi má sa bu-à ǹ gib ya sig Dawuda nu rag má sa níng. Má sa wùn adawá zyun má na kàng kùr àràg barà mpìr ri mi kàng lu-à wim wann sig, ");
INSERT INTO jib_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","jirà mpìrká swai kim kim, ká ǹ shig zu sig big rag abig shi mpìrká bumí níng, abig yàn kyann mì. ");
INSERT INTO jib_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","I mì Shìdun mì ri dáng nì jír bu-à ǹ tàg sig daka sai-à rì.’ ");
INSERT INTO jib_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“To, ámyàngmí, kada ayi dukà mpìrká ri vim bìr bi á byar Shìdun ni ma gbam rag abig wib doka Musa bàna. ");
INSERT INTO jib_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama bu-à yá sa bàna, ayi ba dinya big wasika rag, kada abig ji bu-à big ya sig bu sìnn bàna, abig sa àyái bàna, abig zwam wi zyun-à big sìm gban sig átai bàna, abig ji àsà bàna, ");
INSERT INTO jib_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","jir kai bàna daka sai-à rì níng, big ri dinya kyann mpìrká jir doka Musa, mi ri jangga kyann á tonn bìr kwonnká ni Asabar ma Asabar.” ");
INSERT INTO jib_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Barà Yakubu dang kinn rìg jírwá àdòníng, sái àgbamká bi shig zu mpìrká má yag kwonn ma Bulus ma Barnabas, jirà a káníng yag dinya mpìrká mà Antakiya jír bu-à big dang sig níng. I byar-à big shig zu Yahuda zyun-à big ri bar ku Barsaba, ma Silas, í àgbamká áyau mpìrká bu Yesu, mpìrká ri yan kyinnbá wàni. ");
INSERT INTO jib_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Big ba wasika n ya big abig ya yag káníng. Wasika-à hi big ba sig rag: “Wasika-à níng ri yag á byarná ni, ning wunzàká buyí ká swai kim kim á finn swann Antakiya ma jànn Suriya ma jànn Kilikiya. To, yi wunzàná, ma àgbamká ma yann aswamká á Urushalima yi ri bib kà ning. ");
INSERT INTO jib_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","To, bu-à sa yi ba ya sig ning wasika-à níng, jir kai bàna yi fig big rag mpìrká zu sig áyauyí ni n yag gbar dù sig ning pìkyinn á jírbá big ri dang. Ama buyí yi swam fig big bàna. ");
INSERT INTO jib_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Barà yi fig àdòníng, í bu-à sa yi myàng rag sàn sig ayi shig zu mpìrká káhi ayi swam bi big á byarná ni abig bi kwonn ma Barnabas ma Bulus mpìr azìmyí big, ");
INSERT INTO jib_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ká zyun-à wann tafinn sig yonkibá á dò jir Shinn Luyí Yesu Kristi ni. ");
INSERT INTO jib_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yi ri swam bi kwonn ma Yahuda ma Silas á byarná ni, àjirà abig dinya gban rìg ning jíryí, àràg barà yi ba sig níng. ");
INSERT INTO jib_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Awun Shìdun kwonn ma yi tìnn, yi bidìm pár yi myàng sàn fig wà ayi ya ning doka nìnànn nímá bàna. Bu-à ná sa bàna í wàníng: ");
INSERT INTO jib_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kada aning ji bu-à big ya sig bu sìnn bàna, aning ji àsà bàna, kada aning zwam bu-à big sìm gban sig átai bàna, kada aning sa àyái bàna. Wà na gàb hing dìr ma bu káníng, ning sa hing bu-à ǹsàn. Aning shi ítau.” ");
INSERT INTO jib_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mpìrká big swam yag sig big níng, big dù n yag fòr mà Antakiya. Big bar kwonn mpìrká ri bàg Yesu màhàn, n ya káníng wasika-à big zìg yag sig níng. ");
INSERT INTO jib_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Barà mpìr káníng jangga àdòníng, big fig hing àjwár wàni. Jír-à hi sa gbam big kyinn. ");
INSERT INTO jib_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuda ma Silas big í mpìrká ri dang kyann jir Shìdun tìnn, big dang nonn jír ma káníng, n dang gbam káníng kyinn, n gbar gbam káníng dìr. ");
INSERT INTO jib_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Big na nonn màhàn títi nímá, í wà mpìr káníng dwim kàng bi big ítau, big kàng yag mà Urushalima mà byar àsàinká swam bi sig big níng.  ");
INSERT INTO jib_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama Silas zìm á kyinnwá ni n shi buwá màhàn. ");
INSERT INTO jib_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bulus ma Barnabas shi mà Antakiya mi ri tàg mpìrká jir Yesu, kwonn ma mpìrká kádà nìnànn nímá, big ri tàg bu, mi ri dang jir Yesu tìnn. ");
INSERT INTO jib_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ayunn zyun sái Bulus bi dinya Barnabas rag, abig dù abig yag myàng kà mpìrká big rì dinya sig káníng jir Yesu, abig myàng barà káníng ri shi áni. ");
INSERT INTO jib_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Sái Barnabas zìm abig zìg yag kwonn ma Yohanna Markus. ");
INSERT INTO jib_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Bulus zìm fig bàna, jir kai bàna ku rag wàníng rì ngàng sig wà wàníng má kyann, má sa swàm ma big, n dù dà fim rìg big á jànn Pamfiliya sai-à big rì sa kinn fig ma swàmbá bàna. ");
INSERT INTO jib_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","I byar-à big kà mi ri sa yipyàr hár bi sa big gàb rìg dìr. Barnabas bi zìg Markus, big yag kà á kòr zàpìr, n yag mà swàin Kubrus. ");
INSERT INTO jib_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulus bó bi shig zu Silas. Ku ma wàníng yag zyun. Mpìrká ri bàg Yesu màhàn vig ya big Shìdun rag a Shìdun sa sàn ya big, ma a wàníng myàng kwonn ma big. ");
INSERT INTO jib_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","I byar-à big dù n yag mà jànn Suriya ma jànn Kilikiya. Big ri kyann á jànn káníng hi, mi ri dang gbam mpìrká ri bàg Yesu kyinn. ");
INSERT INTO jib_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus ma Silas yag mà finn swann Darba big finn swann Listra. Big yag dìg wunù zyun ku í mpìr-à màhàn, ku ri bàg Yesu, zìnnwá í Timoti. Nàwá í mpìr Yahudawa, tawá í mpìr Helenawa. Nàwá í mpìr-à ri bàg Yesu tìnn. ");
INSERT INTO jib_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mpìrká ri bàg Yesu á finn swann Listra big finn swann Ikoniya big bidìm pár big ri yan kyinn Timoti wàni. ");
INSERT INTO jib_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ri zìm a Timoti nu kyann ku á byar-à kwá dang kyann jir Shìdun. I wà ku bi gib wàníng jur, í jirà a Yahudawaká zìm wàníng, jir kai bàna káníng bidìm pár yì hing wà ta Timoti í mpìr Helena, í bu-à sa big rì gib fig ku jur bàna sai-à rì níng. ");
INSERT INTO jib_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bulus zìg ku, big ri yag á finn swann kim kim, mi ri dinya mpìrká jír bu-à yann aswamká ma àgbamká mà Urushalima ri zìm mpìrká abig sa, mi ri dinya big rag abig bàg jir káníng. ");
INSERT INTO jib_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Barà mpìrká hi fig àdòníng pìkyinnbá gbam swàb kà á jir Yesu ni. Su ma su mpìrká ri nànn swàb kà wàni. ");
INSERT INTO jib_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Big dù n yag mà jànn Firijiya ma jànn Galatiya, big wam zu rìg jànn Asiya, jir kai bàna Awun Shìdun zìm fig abig dang jir Yesu màhàn bàna. ");
INSERT INTO jib_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Barà big fòr á gàb swann Misiya, big ri zìm abig kà á finn swann Bitiniya, ama Awun Yesu kan dim big abig kà á byar-à hi ni bàna. ");
INSERT INTO jib_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","I byar-à big wam zu, n yag mà finn swann zyun big ri bar Taruwasa. ");
INSERT INTO jib_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A byar-à hi sái á fi-à ni Bulus bi la la, mpìr zyun sar sig í mpìr á jànn Makidoniya, wàníng vig ku rag, “Wúshèní, á bi á jànnyí ni á sa shang yi.” ");
INSERT INTO jib_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Barà Bulus la la-à níng àdòníng, sái yi ma ku dù, n yag màhàn. Yi rag Shìdun dang síg nì rag, ku ri zìm ayi yag dang jir àjwárwá màhàn. ");
INSERT INTO jib_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","A byar-à hi yi dù á Taruwasa, n kà á kòr zàpìr, n zu yag mà Samutaraki, n na byar kyàr, í wà yi yag mà Niyabolis. ");
INSERT INTO jib_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yi dù n yag fòr mà finn swann Filibi á jànn Makidoniya. Lu-à hi í lu ùwài, í lu mpìrká bi sig mà jànn Roma. To, yi bi n na kù su pyànà màhàn. ");
INSERT INTO jib_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ayúnn Asabar yi zu á finn swann-à ni, n yag mà nu níng-à ni, yi yag yàn kyann byar-à Yahudawaká ri vig Shìdun. Yi yag dìg uwàká kwonn shi sig màhàn. I wa yi bi shi wann n dinya big jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uwà zyun áyau-à ni ri fig jír-à yi ri dinya big níng, zìnnwá í Lidiya. Ku í mpìr-à ri wann tafinn jà gbàinshìn zyun-à shi sig ma bài wàni. Ku í mpìr-à mà finn swann Tiyatira. Ku í mpìr-à ri wib Shìdun. I byar-à Shìdun pù finn ya ku kyinnwá. Ku zìm hing jír-à Bulus ri dang níng. ");
INSERT INTO jib_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sái big bi wau ku dìr batisma, ku ma mpìrká á luwá ni. I byar-à ku bar yi rag, “Wà na zìm hing rag ǹ bir sig pìkyinnmí á jir Yesu ni, aning bi shi á lumí ni.” Ku kar vig yi vig vig, hár yi yag mà luwá ni. ");
INSERT INTO jib_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ayúnn su zyun yi dù mi ri wai yag mà byar-à yá vig Shìdun, sái yi dìg kwonn ma wùn uwà zyun ku í fàu, wàu shi sig á dìrwá ni, ku ri vann akwonn. Akwonn-à ku ri vann níng, ku ri dìg bài ùwài nímá áni, mi ri ya shinn luwá big. ");
INSERT INTO jib_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","To, wùn uwà-à níng, ku ri bàg yi á sim, yi ma Bulus. Ku ri dang jír ma gbam, mi ri dang rag, “Mpìr káníng í fàu Shìdun. Big ri tàg ning gbìb-à ná wìm zu áni.” ");
INSERT INTO jib_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Su ma su ku ri dang kyann àdòníng. I byar-à pìkyinn Bulus bai, ku vim bìr bi n dinya wàu-à níng hi n rag, “Mì ri dinya wù á zìnn Yesu Kristi, á zu á dìr wùn uwà-à níng ni.” Gbìb fig tá bàna wàu-à í zu rìg-à n dà fim rìg wùn uwà-à níng hi. ");
INSERT INTO jib_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Barà shinn luká bu wùn uwà-à níng myàng bu-à big ri dìg bài áni jànn rìg rag hing níng, sái big bi pànn Bulus ma Silas, n zìg yag big mà byar àgbamká ri wà kwonn ma kasuwa-à ni. ");
INSERT INTO jib_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Barà big zìg yag fòr big àdòníng, sái big rag, “Mpìr káníng í mpìr Yahudawaká, big ri gbar dù kyinn mpìrká á finn swannyí ni. ");
INSERT INTO jib_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Big ri tàg bu-à dokayí kan dim sig. Buyí yi mpìr Romawaká yi zìm fig bu-à big ri tàg níng bàna, yá bàg fig bàna.” ");
INSERT INTO jib_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Barà big dang àdòníng, sái bìr mpìrká kwonn dab Bulus ma Silas. Agbamká àsàinká ri gib jír níng, wan zu big jà á dìr-à ni, n du kà mpìrká káhi abig dab káníng ashor. ");
INSERT INTO jib_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Barà big dab kinn káníng àdòníng, sái big zìg káníng n kìg kà rìg á tonn fi-à ni. Big dinya àsàin-à ri sa gadi màhàn rag a wàníng sar gadi ǹsàn nímá. ");
INSERT INTO jib_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Barà àsàin gadi fig àdòníng, ku bi zìg big, n kìg kà big á finn tonn-à wà mà yau n bi zìg punn, n wìr kà big á barbá ni. ");
INSERT INTO jib_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ayau fi-à ni, Bulus ma Silas ri vig Shìdun mi ri yan Shìdun ma jonn. Mpìrká ká big kìg sig mà tonn fi-à ni níng, ri fig. ");
INSERT INTO jib_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Gbìb fig tá bàna, jànn-à bi ning yàng yàng. Tonn fi-à ning hár ma mìrwá bidìm pár. Nu nkyunká bidìm pár pù fim rìghing. Punnká big sìr kà sig á bar mpìrká big kìg sig níng, wan zu rìghing. ");
INSERT INTO jib_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Barà àsàin-à ri sa gadi-à fim zir àdòníng, ku myàng nu nkyunká pù finn rìghing. Ku bi gbar wàm zu kafaiwá, ku ri zìm aku gban shinnwá, jir kai bàna ku ri kyab rag mpìrká shàr kyag zu rìghing. ");
INSERT INTO jib_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sái Bulus bar ku nài abor n rag, “A a, kada á gban shinnwú bàna. Yi bidìm pár yi shi sig áyág.” ");
INSERT INTO jib_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Asàin-à ri sa gadi-à níng rag, abig zìg bi pitila. Ku shàr kà yag á byar Bulus ma Silas, n bìnn kir wann á pyànnbá ni, dìrwá ri zwab kàg kàg kàg. ");
INSERT INTO jib_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Sái ku zìg zu yag káníng mà myann n bib káníng rag, “Agbamká, bu-à má sa jirà ń wìm zu í kai rà?” ");
INSERT INTO jib_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Big dinya ku rag, “A bir pìkyinnwú á byar Shinn Luyí Yesu ni. Ku í àsàin-à má pìnn zu wù ma mpìrká buwú bidìm pár.” ");
INSERT INTO jib_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","I byar-à hi big dinya ku jír á shinn Yesu, ku ma mpìrká á luwá ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A fi-à níng hi ni, asa gadi-à níng bi zìg big n bi tu rìg big yun byar-à big dab pòr sig big níng. I byar-à káníng wau ku dìr batisma, ma mpìrká á luwá ni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ku bi zìg kà yag rìg káníng mà finn luwá ni, n bi zìg buju n ya káníng. Ku ma mpìrká buwá ri sa àyán, jir kai bàna big bir rìghing pìkyinn á byar Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Barà byar-à bi kyàr àdòníng sái àgbamká bu Romawaká swam yag poliská n rag, abig fìnn zu Bulus ma Silas á tonn fi-à ni. ");
INSERT INTO jib_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sái àsàin-à ri sa gadi-à níng yag dinya Bulus rag, “To, àgbamká swam bi aswam rag ń dà finn ning. To, aning dù, aning yag sìsàn.” ");
INSERT INTO jib_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Sái Bulus dinya poliská n rag, “Aning myàng, yá yag fig bàna. Big pànn fig yi ma bu-à bibai bàna, í wà big bi dab yi ashor átai áyau bìr mpìrká ni. Yi má, yi í mpìr Roma. Big kìg yi á tonn fi-à ni, í wà tàma-à níng big ri zìm abig bònn pù finn yi átai rà? Yá yag fig bàna. Agbam káníng abig bi ma abig zìg zu yi ma shinnbá.” ");
INSERT INTO jib_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polis káníng yag dinya àgbamká jír bu-à Bulus dang sig rag bá yag fig bàna níng. Barà big fig rag Bulus ma Silas í mpìr Roma àdòníng, sái dìrbá í wu tàg rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Big dù bi n bi dìg káníng n rag a káníng yafa ya big. Hár big zìg zu káníng á tonn fi-à ni, n rag wúshèní a káníng dù á jànnbá ni. ");
INSERT INTO jib_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Barà big zu mà tonn fi-à ni àdòníng, big dù n yag mà lu Lidiya. Big dìg kwonn ma mpìrká ri bàg Yesu màhàn. Big dang gbam káníng pìkyinn. I wà mì wam zu yag rìgbá. ");
INSERT INTO jib_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Sái big yag, big wam zu á finn swann Amfibolis ma Aboloniya, n bi fòr á Tasalonika, í wà big bi dìg tonn bìr kwonn Yahudawaká màhàn. ");
INSERT INTO jib_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A byar-à níng hi Bulus yag kà tonn bìr kwonn àràg barà ku ri sa kyann. Hár Asabar sara ku ri kà, mi ri tàg mpìrká bu-à shi sig áyau tarkada Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ku ri dinya káníng rag Yesu í Almasihu zyun-à Shìdun rì dang sig rag kwá swam bi níng. Ku rag tarkada Shìdun ri tìya big rag, Almasihu ma bi hing, wàníng má wa shwìn, hár má wu. Wà wàníng ma wu hing, wàníng má dù nann zu kàng ma yonki. ");
INSERT INTO jib_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yahudawaká káhi bir pìkyinn á jírwá ni. I wà big kà, mi ri bàg ku, ku ma Silas. Mpìr Helenawaká kádà, ká ri shàr Shìdun níng, big bir pìkyinn, hár uwàká, ká í mpìr àgbam má, big bir pìkyinn tìnn. ");
INSERT INTO jib_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Sái mpìr Yahudawaká kádà níng sa akyib jirà mpìrká nìnànn nímá bi bàg Bulus big. Sái big bar kwonn yann àbínnká ká ri shi á kasuwa-à ni átai níng, n dinya big rag abig gbar dù pìkyinn mpìrká á finn swann-à ni á shinn Bulus ma Silas ni. Big kinn bi á lu Jason jirà abig zìg zu bi káníng á pyànn mpìrká ni ma abig wà big kwonn. ");
INSERT INTO jib_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama big dìg fig káníng bàna. Sái big zìg zu bi Jason ma mpìrká ri bàg Yesu, n zìg yag káníng á byar àgbamká ri wà kwonn á finn swann-à ni. Big ri yan yán n rag, “Mpìr káníng byar-à ba yag bidìm pár, big ri gbar dù kyann pìkyinn mpìrká. Tàma-à níng big bi sig áyág. ");
INSERT INTO jib_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","I wà Jason zìg big n tìg sig big á luwá ni. To, barà big shi sig áyág níng big ri bàg fig doka kùryí Kaisar bàna, big dang rag kùr zyun shi sig áni zìnnwá í Yesu.” ");
INSERT INTO jib_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Barà bìr mpìrká ma àgbamká fig àdòníng, pìkyinnbá fìb hing wàni. ");
INSERT INTO jib_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Agbamká du kà Jason ma mpìrká kádà a káníng wa bài, jirà abig fìnn tafinn Bulus ma Silas, n dwim káníng rag a káníng yag. ");
INSERT INTO jib_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A fi-à ni mpìrká ri bàg Yesu níng, bi dwim Bulus ma Silas a káníng yag mà Biriya. Barà big fòr yag màhàn àdòníng, big kà á tonn bìr kwonn Yahudawaká ni. ");
INSERT INTO jib_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mpìrká á Biriya níng big zìg jir Yesu vù pyànà. Big kab hing mpìrká á Tasalonika, big ri jangga kyann jir Shìdun su ma su jirà abig myàng wà bu-à Bulus dang sig níng ma àjai. ");
INSERT INTO jib_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Big nìnànn nímá big bir hing pìkyinn á byar Yesu ni. Mpìr Yahudawaká nìnànn nímá bir pìkyinn, kwonn ma mpìr Helenawaká wunùká ma uwà àgbamká tìnn. ");
INSERT INTO jib_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Barà Yahudawaká mà Tasalonika fig rag Bulus shi sig mà Biriya, mi ri dang jir Shìdun màhàn níng, sái big dù n yag tàg mpìrká màhàn jirà a káníng bai dìr ma Bulus. ");
INSERT INTO jib_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","I byar-à mpìrká ri bàg Yesu níng tìr yag ku mà lu zyun á nu níng ùwài-à ni aku yag shi màhàn. Silas ma Timoti big shi sig bigbá mà Biriya, big yag fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mpìrká káhi nu fòr yag Bulus mà Atina. I byar-à hi ku dwim big rag abig kàng yag, abig dinya Silas ma Timoti a káníng yag kíni abig yag dìg ku. ");
INSERT INTO jib_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Barà Bulus ri shi kir Silas ma Timoti á finn swann Atina, sái ku bi myàng mpìrká màhàn shi sig ma bu sìnn wàni. Ku bai pìkyinn wàni. ");
INSERT INTO jib_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Su ma su ku ri dang jír ma Yahudawaká á tonn bìr kwonn-à ni á shinn Yesu ni. Ku dang jír ma mpìrká ká í Yahudawaká bàna, ká ri wib Shìdun. Hár ku ri yag mà kasuwa-à ni, mi ri dang jír ma mpìrká màhàn. ");
INSERT INTO jib_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Malamká kádà ri dang jír ma ku tìnn, í malamká ká big ri bar big Abikiriya ma Sitokiya, big í àsàinká yì sig bu á jànn-à ni. Mpìrká kádà áyaubá ni ri dang rag, bu-à mpìr awànn nu-à níng ri zìm aku dang níng í kai rà? Kádà bó, barà big fig ku ri dang jír á shinn Yesu ni barà wàníng dù nann zu kàng sig ma yonki níng, big ri dang rag, kó ku ri dang jír á shinn bu sìnn mpìrká mà swann kim kim. ");
INSERT INTO jib_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","I byar-à big zìg yag ku mà wùn mwír zyun, zìnn mwír-à hi í Arasa. I byar-à big ri kwonn màhàn. I wà big bib ku rag, “To, yi ri zìm ayi fig bu tàg àpyú zyun-à wù ri tàg níng. ");
INSERT INTO jib_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bu-à wù ri dang áyau jírwú ni shi sig í bu àpyú á byaryí ni, yi ri zìm ayi fig yìrwá.” ");
INSERT INTO jib_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Mpìrká mà Atina, wà ba fig hing jír àpyú zyun, í bu-à big ri dang kyann. Big ri sa fig bu zyun bàna mi ri gang fig kyann íri kàhi. Hár kyìnnká shi sig màhàn bidìm pár big ri sa àdòníng tìnn.) ");
INSERT INTO jib_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","I byar-à Bulus bi sar dù nann zu áyaubá ni á Wùn Mwir Arasa ni. Ku dinya big jír, n rag, “Ning mpìrká á Atina, mì ri myàng ning shi sig ma gbìb bu sìnnká ning ri wib nìnànn nímá. ");
INSERT INTO jib_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sai-à mì ri kyann kyann á finn swann ná ni, mì ri myàng byarká ning ri wib bu sìnnká. Hár ǹ myàng abàn zyun, big ba sig á dìrwá ni rag, ‘Wàníng í jir shinn Shìdun zyun-à mpìr yì fig ku bàna.’ To, Shìdun zyun-à mì ri dang jír á shinnwá ni níng, ku shí nì Shìdun zyun-à ning ri wib ku, n yì fig ku bàna níng. ");
INSERT INTO jib_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Shìdun zyun-à mì ri dang níng ku í Shìdun àsàin-à màm sig dunyaru ma buká shi sig áni bidìm pár. Ku shí nì àgbam-à mà wai ma wà á jìnn ni bidìm pár. Ku ri shi fig á lu zyun-à mpìr mi sig bàna. ");
INSERT INTO jib_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Buwá ku ri yàn fig bu zyun á byar mpìr bàna, jir kai bàna walai bu zyun-à kab sig gbamwá. Ku ya sig mpìr awun í nì, ma buká kádà. ");
INSERT INTO jib_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sai-à ku jag màm sig mpìr á dunyaru, ku màm jag síg mpìr ńzyun, í wà á byar mpìr-à níng hi, swai mpìrká bidìm pár bi jwàr. Ku rag abig shi kó áni bidìm pár á dunyaru. Ku ya sig big byar-à bá shi tib, kwonn ma su-à bá shi á dunyaru. ");
INSERT INTO jib_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","To, barà ku màm sig mpìr káníng, ku ri zìm abig yàn kyann ku jirà kó bá dìg ku. Ama ku nonn fig ma yi bàna. ");
INSERT INTO jib_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mpìr zyun dang sig rag, ‘Shìdun í àsàin-à sa sig yi shi sig ma yonki ma gbam.’ Aràg barà ning dài sig áyau jonnká bigná ni n rag, ‘Yi bidìm pár yi í yann Shìdun.’ ");
INSERT INTO jib_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","To, barà yi í yann Shìdun níng, bu-à sa yi ri zìg àsháu zinariya ma àsháu azurfa ma abàn, mi ri kànn, mi ri dang rag í Shìdun níng, í kai sá nì rà? Shìdun shi fig àdòníng bàna. ");
INSERT INTO jib_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sai-à rì níng, mpìrká ri sa àdòníng, jir kai bàna big yì fig bu zyun bàna. Shìdun rì myàng gbam sig big ma zu. Ama tàma-à níng ku ri dinya yi rag, kó ni bidìm pár aku dà finn bu pyìr sa. ");
INSERT INTO jib_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ku sìnn sig àyúnn-à kwá wà mpìrká kwonn. Kwonn-à kwá wà níng kwá wà á gbìb gwangga. Ku sìnn sig mpìr àsàin-à má wà kwonn àyúnn-à níng hi. Mpìr-à níng Shìdun gbar dù nann zu kàng sig ku ma yonki mà amir-à ni. Barà Shìdun gbar dù kàng sig ku ma yonki níng, í barà ku tìya sig mpìrká rag, kwá wà kwonn-à hi.” ");
INSERT INTO jib_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Barà mpìrká fig jír bu-à Bulus dang sig áshinn barà ki ma du nann zu kàng ma yonki níng, mpìrká káhi jwann ku. Ama mpìrká kádà rag, bigbá big ri zìm abig fig jakàng jír-à níng hi. ");
INSERT INTO jib_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","I byar-à Bulus dù dà finn rìg big. ");
INSERT INTO jib_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mpìrká kádà bàg yag ku. Big bir pìkyinn á jír-à ku dang sig. Zyun áyaubá ni í Diyonisiyas, ku í mpìr àgbam bu finn swann-à níng hi. Zyun í uwà zyun big ri bar ku Damaris, kwonn ma mpìrká kádà. ");
INSERT INTO jib_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","I byar-à Bulus dù á finn swann Atina, ku yag mà finn swann Korinti. ");
INSERT INTO jib_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ku dìg kwonn ma mpìr zyun zìnnwá í Akila, í mpìr Yahudawa. Big mà sig ku á jànn Pantas. Ku ma wàwá Biriskila big rì shi hing á jànn Italiya, í wà Kalaudiyas, kùr-à màhàn dang rag, mpìr Yahudawaká abig dù á finn swannwá ni. Finn swann-à hi í Roma. Sai-à Bulus yag mà Korinti ku bib kà big màhàn. ");
INSERT INTO jib_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ku myàng swàmwá ku ma káníng í ńzyun. Swàmbá big ri kwìb wau zyun-à big ri sa apig áni. I byar-à ku shi kwonn ma big n sa swàm ma big. ");
INSERT INTO jib_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Asabar ma Asabar ku ri yag kyann mà tonn bìr kwonn-à ni, mi ri kar zìng mpìr Yahudawaká ma mpìr Helenawaká a káníng zìm jir Yesu. ");
INSERT INTO jib_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Barà Silas ma Timoti dù á Makidoniya n yag mà Korinti, big dìg Bulus màhàn. I byar-à Bulus dà fim rìg swàm wau-à ku ri kwìb níng, mi ri dang kyann jir Shìdun. Ku ri dinya byann mpìr Yahudawaká rag, Yesu shí nì Almasihu zyun-à Shìdun swam bi sig. ");
INSERT INTO jib_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","I byar-à big zìm fig jírwá bàna. Big ri sa yipyàr ma jírwá, mi ri swau ku. I byar-à ku pìm zu rìg avír-à á jàwá ni á pyànnbá ni n rag, “To, wà na sa Shìdun ma ngàng ning, to í jírná, í vù jírmí bàna. Tàma-à níng má yag á byar mpìrká ká swaibá kim kim.” ");
INSERT INTO jib_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","I wà ku zu á tonn bìr kwonn-à ni, n dù n yag shi á lu mpìr-à ri bàg Shìdun big ri bar ku Titus Yustus. Luwá shi yàr sig ma tonn bìr kwonn-à hi. ");
INSERT INTO jib_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisbus àgbam-à á tonn bìr kwonn-à ni níng, ku fig jír-à hi, hár ku bir pìkyinn á byar Yesu ni, ku ma mpìrká mà luwá ni bidìm pár. Mpìrká mà Korinti nìnànn nímá big fig jír-à hi, n bir pìkyinn áni. I wà big wau big dìr batisma. ");
INSERT INTO jib_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ayúnn zyun á fi-à ni, Shìdun bi dang jír ma Bulus á la-à ni n rag, “A shàr zinn mpìrká bàna, á dang kyann jírmí, kada á fim bàna. ");
INSERT INTO jib_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","N shi sig á shinnwú ni, walai mpìr-à kinn sig barà kwá sa wù bu. N shi sig ma mpìrká nìnànn nímá á finn swann-à níng ni.” ");
INSERT INTO jib_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus shi màhàn hár ji zyun ma sònn swìnnjin, mi ri tàg mpìrká màhàn jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sai-à Galiyo shi síg nì gwamna á jànn Akaya, sái mpìr Yahudawaká bi pànn Bulus n zìg yag rìg ku mà byar àgbamká ni jirà abig wà ku kwonn. ");
INSERT INTO jib_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Big dinya àgbamká rag, “Mpìr-à níng tàg mpìrká rag abig wib Shìdun á gbìb zyun-à dokayí kan dim sig.” ");
INSERT INTO jib_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Barà Bulus má kan dang jírwá àdòníng, sái gwamna-à hi dinya mpìrká rag, “Bu-à ning ri dang níng, ning ri zìg bi jír á shinn doka bu Yahudawaká ni átai, ning ri zìg bi fíg jír á shinn dokayí ni bàna. Bulus nìm ma sa sig bu-à bibai áyau dokayí ni, ǹ nìm má gang sung á jírná ni. ");
INSERT INTO jib_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama barà í jir shinn jír dang, ma zìnn, ma dokaná, to, aning dang ma shinn ná. Má dang fig bu zyun á shinn íri buká àdòníng bàna.” ");
INSERT INTO jib_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","I byar-à ku kan zu rìg káníng á tonn kwonn wà-à ni. ");
INSERT INTO jib_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Barà ku kan zu rìg káníng àdòníng, sái big pànn àgbam zyun-à shi síg nì shinn áyau tonn bìr kwonn-à ni, zìnn mpìr-à níng hi í Sastanisu. Big pànn ku n dab ku dab dab. Big ri dab ku á myann mà byar tonn kwonn wà-à ni. Galiyo bó bu-à du ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus shi nonn mà Korinti ma mpìrká ri bàg Yesu. I wà ku ri zìm aku yag mà Suriya. Ku dù, ku ma Biriskila ma Akila, big í yag rìg-à. Barà big fòr á Kankiriya, Bulus tun ya Shìdun ki, n wann rìg jinnwá, í wà big kà á kòr-à ni, mì yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","I byar-à big yag mà finn swann Afisa. Bulus fim Biriskila ma Akila abig sa swàm màhàn. Ku yag n kà á tonn bìr kwonn-à ni, mi ri dang jír ma Yahudawaká màhàn, mi ri tàg káníng bu. ");
INSERT INTO jib_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yahudawaká ká ri bàg Yesu ri zìm a Bulus shi nonn ma big, ama ku zìm fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ku dinya big rag, “Sái wà Shìdun ma zìm hing, í wà má kàng bi kàng á byarná ni.” I wà ku dù ma Afisa n kà á kòr, mì yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Barà ku fòr yag mà Kaisariya, ku yag bib kà mpìrká ri bàg Yesu mà Urushalima. I wà ku dù n yag mà finn swann Antakiya. ");
INSERT INTO jib_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ku shi nonn màhàn títi nímá, í wà ku dù n yag mà jànn Galatiya ma jànn Firijiya, mi ri dang gbam mpìrká ri bàg Yesu kyinn. ");
INSERT INTO jib_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mpìr Yahudawa zyun big ri bar ku Apolos, ku bi fòr á finn swann Afisa, big mà sig ku mà finn swann Iskandariya. Ku dang yì hing jír wàni, hár ku yì hing jír-à shi sig á tarkada Shìdun ni wàni. ");
INSERT INTO jib_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Big tàg hing ku gbìb Shinn Luyí wàni. Ku ri tàg mpìrká ma pìkyinn ńzyun. Jírwá ábibir ma bu-à shi sig áyau tarkada Shìdun, ama batisma-à ku yì sig, ku yì sig íri bu Yohanna, ku yì fig ma barà big ri wau mpìr dìr batisma áyau zìnn Yesu bàna. ");
INSERT INTO jib_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ku wim pìkyinn mi ri dang jir Yesu mà tonn bìr kwonn-à ni. Barà Biriskila ma Akila big fig àdòníng, sái big zìg yag ku mà lubá ni, mi ri tàg swàb kà ku gbìb Shìdun wàni. ");
INSERT INTO jib_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos ri zìm aku yag mà jànn Akaya. I byar-à hi mpìrká ká ri bàg Yesu sa shang ku bu zyun. Big bi ba wasika, n dwim yag mà byar mpìrká ri bàg Yesu mà Akaya. Big rag a káníng pànn ku vù pyànà. I byar-à ku dù n yag màhàn. Barà ku fòr yag màhàn àdòníng, ku sa shang mpìrká ká zyun-à á dò jir àsàn Shìdun ni, big bir sig pìkyinnbá á byar Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ku ri dang jír ma gbam mi ri sa yipyàr ma Yahudawaká áyau bìr mpìrká ni rag, jir Shìdun ri tàg yi rag Yesu shí nì Almasihu zyun-à Shìdun swam bi sig. ");
INSERT INTO jib_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sai-à Apolos shi sig buwá á finn swann Korinti, sái Bulus kyann kyann á finn swannká á jànn Asiya, n yag mà finn swann Afisa. Ku bi dìg mpìrká káhi ri bàg Yesu màhàn. ");
INSERT INTO jib_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","I byar-à ku bib big rag, “Sai-à ning bir pìkyinn á byar Yesu ni níng, ning dìg hing Awun Shìdun rà?” Big rag, big dìg fig bàna, big taba fig fig bu-à big ri dang rag í Awun Shìdun níng bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Sái ku bib big rag, “Big wau sig ning írì dìr batisma wà áni rà?” Big rag big wau sig big batisma àràg barà Yohanna ri wau níng. ");
INSERT INTO jib_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus dinya big rag, “Batisma bu Yohanna í dò jir shinn mpìrká dà fim sig bu pyìrbá. Buwá ku ri tàg mpìr Israilaká rag, a káníng bir kyinn á byar mpìr zyun-à má bi á simwá ni. Mpìr-à níng hi í Yesu.” ");
INSERT INTO jib_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Barà mpìr káníng fig àdòníng, sái big wau rìg dìr batisma ma zìnn Shinn Luyí Yesu. ");
INSERT INTO jib_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bulus tib big vù á shinn-à ni, í wà Awun Shìdun bi kà á kyinnbá ni. Sái big bi dang jír big nu jír kim kim zyun-à big taba dang fig bàna. Big ri dang bu-à Shìdun dinya sig big. ");
INSERT INTO jib_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mpìr káníng big fòr hing mpìr dwib agban pyànà. ");
INSERT INTO jib_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus yag dang jír mà tonn bìr kwonn-à ni. Ku ri dang jír zinn bàna. Hár sònn sara ku shi mi ri dang jír big mpìrká á shinn Yesu ni, mi ri zìng byafàn jirà a káníng yì byann barà Shìdun má na kùrwá. ");
INSERT INTO jib_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mpìrká kádà fig jír-à hi big gbam sung, n zìg fig bàna. Big bi dang jír àbai á shinn jír gbìb Shìdun. Big ri dang àdòníng á byar bìr mpìrká ni. Barà Bulus myàng àdòníng, sái ku zu áyaubá ni, n zìg yag mpìrká ri bàg Yesu, big yag kà á tonn ùwài nímá byar-à big ri tàg mpìrká bu. Tonn-à hi í bu Tiranus. Bulus ri dinya kyann káníng jír su ma su. ");
INSERT INTO jib_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ji pyànà big ri sa àdòníng. Hár bi sa mpìrká shi sig mà jànn Asiya, big nìnànn nímá big fig rìg jir Yesu. Mpìr Yahudawaká ma ká í Yahudawaká bàna bidìm pár big fig rìghing jir Shinn Luyí Yesu. ");
INSERT INTO jib_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Shìdun ya sig Bulus gbam barà kwá sa bu mamaki wà mpìr taba myàng fig bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Big zìg jàwá zyun-à ku sa sig swàm ma kàhi, n ya yag mpìrká na sig dor big tib vù áni, dìrbá í gbam rìg-à. Wàuká zu n dà fim rìg big. ");
INSERT INTO jib_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yahudawaká kádàkí bi, ká ri sa kyann subu, big ri zìm abig kan zu wàu big zìnn Yesu tìnn. Big dang rag, “Yi ri dinya ning á zinn Yesu zyun-à Bulus ri dang kyann jírwá níng, aning zu rìg á dìr mpìrká ni.” ");
INSERT INTO jib_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yann wunù sùmpyànn, í yanká bu àgbam zyun-à ri twìb swànn bu á pyànn Shìdun áyau Yahudawaká ni, zìnnwá í Siba. Yanká bu àgbam-à níng hi sa àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wau-à hi dang rag, “N yì hing Yesu, ǹ yì hing Bulus, ama bigná kam, ning í ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mpìr-à wàu-à dab sig ku níng, bi pìm dù nann zu n dab big. Hár ku dab nauna big wàni. I byar-à big shàr zu mà lu-à ni, jàbá ka rìghing, big shàr zu dìr áyonn kwonn ma àwá í zyun, jir kai bàna gbamwá kab hing gbambá. ");
INSERT INTO jib_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mpìr Yahudawaká ma mpìrká zyun-à í Yahudawaká bàna shi sig mà finn swann Afisa níng, big bidìm pár, big fig rìg tai bu-à sa sig níng. Barà big fig àdòníng, zinn pànn rìg big. Mpìrká swam yan zìnn Shinn Luyí Yesu kab wàrì. ");
INSERT INTO jib_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ayau mpìrká zyun-à bir sig pìkyinn, mpìr nìnànn nímá bi dang zu bu bibaiká big sa sig. ");
INSERT INTO jib_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Big nìnànn nímá big zìg bi tarkada swàm subu-à big ri sa níng, n bi twìb swànn rìg áyau bìr mpìrká ni. Big dab lisafi bài tarkada subu-à big twìb swànn sig níng, bàiwá fòr hing 50,000 á bài azurfa. ");
INSERT INTO jib_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","A jir bu-à sa sig níng ni, mpìrká ri fig swàb kà yag jir Shìdun mà pyànn ma gbam kó áni bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Barà bu káníng sa rìg àdòníng, sái Bulus ri zìm á kyinnwá ni rag, kwá kyann kyonn kwá yag mà jànn Makidoniya big jànn Akaya, hár kwá yag fòr mà finn swann Urushalima, á pyànn kwá yag mà finn swann Roma. ");
INSERT INTO jib_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","I byar-à ku bi swam yag Timoti ma Arastas, a káníng yag jág ku nì mà Makidoniya. Káníng àsàinká ri sa shang ku swàm. Ku shi swàb kà tim buwá á jànn Asiya. ");
INSERT INTO jib_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","To, á sai-à níng hi ni, ngain bi dù áyau mpìrká á finn swann Afisa jir shinn gbìb Yesu. ");
INSERT INTO jib_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mpìr zyun big ri bar ku Dimitiriyas, ku í mpìr ayìg bu. Ku ri yìg yann tonnká ri zu àràg tonn bu bu sìnn zyun-à big ri bar Artamisa. Tonnká hi ku ri yìg ma àsháu azurfa. Ku ma mpìrká ri sa swàm á byarwá ni níng, big ri dìg bài áyau swàmbá ni wàni. ");
INSERT INTO jib_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","I byar-à ku bar kwonn gban rìg mpìrká ri sa swàm ma ku, ma ká ri sa swàm àràg bigbá níng n dinya big rag, “To, aning myàng barà yi ri dìg bài ùwài á jir swàmyí ni. ");
INSERT INTO jib_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ama aning myàng barà Bulus mpìr-à níng ri kyann, mi ri tàg mpìrká rag, bu-à mpìr ma yìg sig ma vùwá, í Shìdun bàna. Mpìrká nìnànn nímá á Afisa áyág ma ká mà Asiya nìnànn nímá zìm jírwá. ");
INSERT INTO jib_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wàníng má du kà mpìrká má ngàng swàmyí. Iri jir wà bá ngàng swàmyí bàna má, bá sìnn kàng tonn bu sìnnyí Artamisa má shi fig rag í bu zyun bàna, ku zyun-à mpìrká mà Asiya ma mpìrká bidìm pár ri wib ku níng, bá sìnn kàng fig rag ku bu ǹsàn bàna.” ");
INSERT INTO jib_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Barà mpìrká fig jir Dimitiriyas àdòníng, sái big bai rìg pìkyinn áni. Big yan nài yán n dang rag, “Artamisa zyun-à Afisawaká ri wib níng, ku í bu ùwài.” ");
INSERT INTO jib_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A byar-à níng hi kyinn mpìrká mà finn swann-à ni dù. I byar-à mpìrká pànn Gayus ma Aristarkus big í mpìrká mà Makidoniya. Big bi kwonn ma Bulus í zyun mà Makidoniya. Mpìrká ri gbar yag big ma gbam mà fír-à ni. ");
INSERT INTO jib_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus ri zìm aku kà nu mpìr pyànà káníng, aku kan dim bìr mpìrká bu-à bá sa káníng. Ama mpìrká ri bàg Yesu kan dim ku rag, kada aku yag màhàn bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Agbamká káhi á jànn-à ni, big í jàuká bu Bulus, big má, big dwim yag big rag, wúshèní kada a Bulus du kà shinnwá áni bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","I barà bìr mpìrká shi mi ri yan yán. Kádà ri dang bu zyun kim, kádà ri dang bu zyun kim. Káhi nìnànn nímá áyaubá ni big yì fig bu-à zìg yag sig big mà byar-à níng hi bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mpìr Yahudawaká bi tìr yag Alizanda mà pyànn, jirà aku dinya mpìrká jír. Mpìrká wà sig rag ku í àsàin-à sa sig big ri bai dìr níng. I byar-à ku sa nann zu vùwá n rag abig shi kim, ku ri zìm aku dang jír. ");
INSERT INTO jib_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Barà mpìrká myàng yì rìg ku, ku í mpìr Yahudawa níng, í byar-à big bi yan swàb kà nài yán, hár fòr awa pyànà. Nài jírbá bidìm pár yag rìghing ńzyun. Big rag, “Artamisa zyun-à Afisawaká ri wib níng, ku í bu ùwài.” ");
INSERT INTO jib_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mpìr àsàin-à ri ba sìnn jir àgbamká á finn swann-à ni, dinya bìr mpìrká rag abig shi kim. I wà ku dang rag, “To, ning mpìr Afisawaká, aning gang sung. Kó ni bidìm pár yì hing wà yi í àsàinká ri myàng kwonn ma bu sìnnyí Artamisa. Kó ni yì hing wà yi shí nì àsàinká ri myàng kwonn ma abàn zyun-à kù wann bi sig mà waisháu-à ni níng tìnn. ");
INSERT INTO jib_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Walai mpìr-à má sa yipyàr rag ku yì fig bu káníng bàna. Kada aning sa bu asàr bàna. ");
INSERT INTO jib_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Aning myàng. Ning zìg bi sig mpìr pyànà káníng áyág, big jwi fig bu áyau tonn bu sìnnyí ni bàna. Big dang sa bai fig zìnn bu sìnnyí bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Wà Dimitiriyas ma mpìrká ri sa swàm ma ku ma ri zìm abig bar kara mpìr, abig yag mà tonn kwonn wà, mà byar àsàinká ri gib jír, jirà abig dang jírbá màhàn. ");
INSERT INTO jib_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Wà ning ma ri zìm aning dang jír zyun, aning shi kir sái àyúnn-à mpìrká ma ri kwonn shinn. ");
INSERT INTO jib_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Barà bu-à níng sa sig àdòníng, mpìr Romawaká má ya yi laifi á shinn ngain-à dù sig janá-à níng. Bá rag, yi í mpìr yawari, hár yá zu yì fig áyau jír-à hi ni bàna.” ");
INSERT INTO jib_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Barà ku dang àdòníng, ku dwim mpìrká rag abig kàng yag mà lu-à ni. ");
INSERT INTO jib_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Barà ngain-à tag wann àdòníng, sái Bulus bar kwonn mpìrká ri bàg Yesu, n dang gbam big kyinn, í wà ku dwim káníng, n dù n yag rìg mà jànn Makidoniya. ");
INSERT INTO jib_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Byar-à kwa yag fòr bidìm pár, ku ri bar mpìrká ri bàg Yesu màhàn, mi ri dang gbam káníng pìkyinn. I byar-à ku dù màhàn n yag mà Giris. ");
INSERT INTO jib_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ku shi màhàn sònn sara. Ku ri zìm aku yag rag mà Suriya. I byar-à ku rag aku fig níng, big rag Yahudawaká ri kwonn nu á shinnwá ni barà bá pànn ku má gban rìg. I byar-à ku dù n kàng yag mà jànn Makidoniya. ");
INSERT INTO jib_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mpìrká ku ma káníng yag sig í zyun níng, zyun í Subataras wùn Burus, ku bi sig mà Biriya. Káhi bó í Aristarkus ma Sakundus mpìrká á Tasalonika, ma Gayus mpìr Darba, ma Timoti, kwonn ma Tikikus ma Tarufimas, mpìrká bi sig mà jànn Asiya. ");
INSERT INTO jib_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mpìr káníng big kà sig yi kà pyànn n shi kir sig yi mà finn swann Taruwasa. ");
INSERT INTO jib_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sái yi dù á jànn Filibi á sai-à big ji kinn rìghing àyúnn-à ùwài zyun-à big ri ji brodi zyun-à bàna ma yisti. Yi kyann kyonn á kòr zàpìr-à ni su swana, n bi dìg big á Taruwasa. A byar-à hi yi shi su sùmpyànn màhàn. ");
INSERT INTO jib_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ayúnn Asabar á fi-à ni, yi mpìrká ri bàg Yesu níng, yi kwonn shinn jirà ayi ji buju zyun-à yá kyab pànn Yesu áni. Sái Bulus dinya mpìrká jir Shìdun. Ku dang jírwá hár yau fi, jir kai bàna byar-à ma kyar hing kwá yag rìg. ");
INSERT INTO jib_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Big mònn bàg sig pitila nìnànn nímá áyau tonn-à yi shi sig áni níng, tonn-à hi big mi sig hár mà wai. ");
INSERT INTO jib_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wùn sukà zyun zìnnwá í Aftikos, ku shi sig mà pùr tonn-à big gib sig níng, ku ri dim aná. I byar-à ku na jann màhàn. I barà Bulus ri dang jírwá, mi ri yag mà pyànn, sái wùn sukà-à níng hi kù wann bi mà pùr tonn-à ni mà wai. Tonn-à hi big mi dann wann sig zyun á shinn zyun ni, zyun á shinn zyun ni. Wùn sukà-à níng kù wann bi sig daka mà pùr tonn zyun-à mà wai níng, hár n kù wann bi á jìnn ni. Big bi gbar dù nann zu ku, ku wu rìghing. ");
INSERT INTO jib_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Sái Bulus wann bi n lab finn dìrwá á dìr wùn-à níng hi ni, n bi wau swann wàníng. I wà n dinya mpìrká rag, “Kada aning kig bàna, ku shi sig ma yonki.” ");
INSERT INTO jib_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bulus nann kàng yag kàng mà tonn-à ni, n yag ngir gàfinn brodi-à mi ri ji, mi ri dang swàb kà jír ma big hár byar-à bi kyàr. I wà ku dù mì yag rìgwá. ");
INSERT INTO jib_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","I byar-à big zìg yag wùn sukà-à níng mà lu-à ni, ku wim kàng rìghing, pìkyinnbá jwar hing wàni. ");
INSERT INTO jib_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Buyí yi dù á finn swann-à ni, n bi kà á kòr-à ni n ya zu yag mà finn swann Asus, àràg barà Bulus dinya sig yi ayi sa. Bulus kyann sig buwá ma bar. ");
INSERT INTO jib_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","I byar-à hi ku bi dìg yi màhàn. Ku kà á kòryí ni, í wà yi yag mà Mitilini. ");
INSERT INTO jib_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Daka á Mitilini yi kà á kòr-à ni n yag, byar-à bi kyàr í wà yi bi yàr á byar swàin zyun-à big ri bar Kiyas. Byar-à bi kyàr íwà yi yag fòr mà swàin Samos. Byar-à bi kyàr jakàng í wà yi yag fòr á finn swann Militus. ");
INSERT INTO jib_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulus ri zìm fig aku sar wann mà jann Afisa bàna, jir kai bàna ku zìm fig aku shi nonn mà Asiya bàna. Ku ri zìm aku yàb yag fòr mà Urushalima àyúnn Pentikos, wà bu zyun ma kan dim fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ku swam aswam á Militus abig yag mà Afisa, abig bar bi ya ku àgbamká ri bàg Yesu màhàn. ");
INSERT INTO jib_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Barà big fòr bi àdòníng, ku dinya káníng rag, “Ning ma shinn ná, ning yì hing shu-à ǹ shi sig áyauná ni sai-à ǹ tib barmí n kà á jànn Asiya. ");
INSERT INTO jib_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mì ri sa swàm Shìdun ma kyinn ńzyun, ǹ gbar dù fig shinn bàna, mì ri wa zàn mínn, mpìr Yahudawaká ya hing mì shwìn kim kim, big su kwonn nu áshinnmí ni, jirà abig gban rìg mì. Ama ǹ fim fig swàm-à hi bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ning yì hing wà bu-à ma myàng ma í bu-à má sàn ya ning, mì ri tàm fig ning bàna, mì ri dinya ning. Mì ri tàg ning, mì ri kà lu lu mi ri dinya ning jir Shìdun, mì ri dang jir Shìdun áyau bìr-à ni tìnn. ");
INSERT INTO jib_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mì ri dinya mpìr Yahudawaká ma ká í Yahudawaká bàna rag abig dà finn bu pyìrbá, abig bi á byar Shìdun ma abig bir pìkyinn á byar Shinn Luyí Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","To, tàma-à níng í yagmí hi mà Urushalima. Awun Shìdun ri tìr yag mì màhàn. N yì fig bu-à má dìg mì màhàn bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bu-à ǹ yì sig bàna, finn swann-à ma yag bidìm pár, Awun Shìdun ri dinya mì rag, mpìrká má ya mì shwìn wàni, bá kìg kà mì á tonn fi-à ni. ");
INSERT INTO jib_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama ǹ wann tafinn shinnmí, jirà ń sa vinn swàmmí, swàm-à Shinn Luyí Yesu ya sig mì rag ń dinya mpìrká jir àsàn-à Shìdun shi sig ma kàhi níng. ");
INSERT INTO jib_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“N kyann kyann hing áyauná ni, ǹ dinya hing ning jír barà Shìdun ri na kùrwá. To, tàma-à níng ǹ yì hing ná myàng fig rag mì bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Wàníng í bu-à sa mì ri dinya ning janá-à níng, wà mpìr zyun áyauná ni ma nang jànn hing gbìb Shìdun, kàhi í vù jírmí bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","N dinya vinn rìghing ning barà Shìdun ri pinn zu mpìr mi ri ya mpìr yonki áni. ");
INSERT INTO jib_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Aning pànn shinn ná, ma aning myàng kwonn ma mpìrká ri bàg Yesu. Awun Shìdun ya kà sig big á vùná ni rag aning myàng kwonn ma big í zyun. Aning sa swàm Shìdun ǹsàn nímá jir shinnbá. Ku swam bi wùnwá Yesu wu sig á dò shinnbá ni, jirà abig shi mpìrká buwá. ");
INSERT INTO jib_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N yì hing wà ma yag hing, mpìrká kádà má bi ásimmí ni, bá kà áyauná ni, big í mpìr pìkyinn pìpìr big. Bá fim fig ning àsàn bàna, bá sa mpìrká káhi má zu á gbìb Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mpìrká kádà áyauná ni má bi gim ǹsáng, bá gbar vim bìr kyinn mpìrká ri bàg Yesu á byarbá ni. ");
INSERT INTO jib_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jir wàníng aning na aná bàna, aning kyab pànn barà jimí sara, fi ma àyúnn mì ri tàg kyann ning jir Shìdun, fi ma àyúnn mì ri kig mínn. ");
INSERT INTO jib_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“To, tàma-à níng, ǹ ya kà sig ning á vù Shìdun ni barà kwá myàng kwonn ma ning. Jir àsànwá má du kà ning ná sar gbam áyau gbìb Yesu. Kwá sa sàn ya ning àràg barà ku ri sa sàn ya mpìrká bidìm pár ká ri bàg ku. ");
INSERT INTO jib_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N wìm fig bu zyun á byarná ni bàna, kó bài, kó zinariya, kó jà, ǹ wìm fig rag aning ya mì bàna. ");
INSERT INTO jib_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ning ma shinn ná, ning yì hing mì ri sa swàm ma vùmí jirà ayi ma jàu swàmmí big dìg bu-à yi ri zìm. ");
INSERT INTO jib_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","To, bu-à ǹ sa sig bidìm pár á byarná ni níng, ǹ tìya sig ning rag áyau swàm ùwàiká yi ri sa níng ni, ayi sa shang mpìrká bàna ma gbam níng. Aning kyab bu-à Yesu rì dang sig rag, ‘Mpìr-à ma ri ya vù, ku fig káb nì àjwár ma mpìr-à ri zìg bu á vù mpìr.’ ” ");
INSERT INTO jib_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Barà Bulus dang kinn jírwá àdòníng, sái ku ma káníng bìnn kir wann á jìnn ni n vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Barà ku dwim gàfinn dìr ma big àdòníng, big kàm pànn ku mi ri wìr mínn. ");
INSERT INTO jib_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bu-à sa big ri kig níng, í jirà ku nìm dinya sig big rag, bá myàng fig rag ku bàna níng. I byar-à big nu yag ku hár mà nu níng-à ni, byar-à kòr shi sig níng, n dwim gàfinn dìr ma ku màhàn. ");
INSERT INTO jib_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","I byar-à yi dù màhàn n yag kà á kòr-à ni, n bi yag fòr á swàin zyun big ri bar Kos. Byar-à bi kyàr, yi bi dù mà n yag mà swàin zyun-à big ri bar Rodusa. Yi dù mà Rodusa n yag fòr mà swàin zyun-à big ri bar Batara. ");
INSERT INTO jib_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","A byar-à hi yi bi dìg kòr zyun-à ri yag mà Finikiya. I wà yi kà áni, mì yag rìg-à. ");
INSERT INTO jib_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Yi bi fòr á byar-à yi myàng swàin zyun-à big ri bar Kubrus. Yi dà fim sig swàin-à hi agunn vìm súr-à ni, n yag fòr mà jànn Suriya n bi tìg á finn swann Taya, í byar-à bá wu wìr zu swánnká á kòr-à ni màhàn. ");
INSERT INTO jib_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yi yag dìg mpìrká ri bàg Yesu mà finn swann-à níng hi, n shi su sùmpyànn ma big. Mpìrká màhàn níng, Awun Shìdun dinya big rag abig dinya Bulus kada aku yag mà Urushalima bàna. ");
INSERT INTO jib_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Barà sai-à yá dù kyonnyí màg àdòníng, í byar-à yi dù, n yag. Mpìrká ri bàg Yesu níng, wunù ma uwà ma yann wùnshái bidìm pár nu wam zu yag yi á finn swann-à ni. Hár yi ma big bi fòr mà nu zàpìr ùwài-à ni. Barà yi bi fòr màhàn, sái yi bìnn kir wann á jìnn ni n vig Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Barà yi ma big dwim gàfinn dìr àdòníng, yi kà á kòr-à ni, í wà big í kàng yag rìg-à ma lubá ni. ");
INSERT INTO jib_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Yi dù á Taya n bi tìg á finn swann Talamayas. A byar-à hi yi yàn dìg mpìrká ri bàg Yesu níng, n bib kà big, n na su zyun ma big. ");
INSERT INTO jib_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Byar-à bi kyàr, sái yi pànn gbìb-à, mi í yagyí, í wà yi bi fòr á finn swann Kaisariya. Yi tìg á lu Filibus. Ku í àsàin-à ri dang jir Yesu. Ku shi sig áyau mpìr sùmpyànnká big shig zu sig mà Urushalima jirà abig sa swàm Shìdun níng. ");
INSERT INTO jib_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ku shi sig ma yann uwà yina, big bidìm pár big zìg fig ma wunù bàna, big ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","To, yi shi màhàn su pyànà, sái mpìr zyun bi dìg yi màhàn. Mpìr-à hi bi sig mà jànn Yahudiya, zìnnwá í Agabas. Ku í mpìr-à ri dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Barà ku bi dìg yi àdòníng, sái ku bi dìg Bulus, n zìg bel wàníng n sìr á barwá ni ma vùwá, n dinya wàníng rag, “Wàníng í bu-à Awun Shìdun dinya sig mì rag àsàin bel-à níng, mpìr Yahudawaká má pànn ku má sìr ku àdòníng mà Urushalima. Bá ya kà ku á vù mpìrká ká í Yahudawaká bàna.” ");
INSERT INTO jib_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Barà yi fig jir mpìr-à níng àdòníng, yi vig Bulus rag, kada aku yag mà Urushalima bàna. ");
INSERT INTO jib_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","I byar-à ku bib yi rag, “Sáshinn ning ri dang, mi ri kig mínn àdòníng rà? Ning ri sa gíb mì kyinn rà? Bumí ǹ sìnn sig á pìkyinnmí ni má yag. Kó ba sìr mì mà Urushalima, kó ba gban mì màhàn jir zìnn Yesu, má shàr fig zinn bàna.” ");
INSERT INTO jib_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Barà ku bàg fig jíryí bàna níng, í byar-à yi fim ku yi rag to, sái bu-à Shìdun ma sa. ");
INSERT INTO jib_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","A byar-à hi yi shi màhàn, í wà yi sìr kwonn swánnyí n yag mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mpìrká á Kaisariya ká ri bàg Yesu, káhi nu yag fòr yi, n zìg yag yi mà lu Manason, byar-à yá tìg, ku í mpìr-à ri bàg Yesu daka á ninonn. Ku í mpìr á Kubrus. ");
INSERT INTO jib_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Barà yi yag fòr mà finn swann Urushalima àdòníng, sái mpìrká ri bàg Yesu big shà samyib yi ǹsàn nímá. ");
INSERT INTO jib_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na kyàr byar-à Bulus yag kwonn ma yi í zyun mà byar Yakubu. Yi dìg àgbamká bu mpìrká ri bàg Yesu big shi sig màhàn big bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulus bib kà big n dinya big bu-à Shìdun sa sig áyau mpìrká zyun-à í Yahudawaká bàna, á jir swàmwá ni. ");
INSERT INTO jib_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Barà àgbamká fig àdòníng, big fig àjwár n swam yan Shìdun. I byar-à big dinya ku n rag, “Wunzàyí, à myàng hing kó? Mpìr Yahudawaká big dubu nìnànn nímá, big bir sig pìkyinnbá á byar Yesu ni, big ri sìnn gbambá á byar doka. ");
INSERT INTO jib_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Big fig hing barà wù ri kyann á jànnká ni kim kim. Mpìrká dinya hing big rag wù ri tàg Yahudawaká ká shi sig á jànn mpìrká ká zyun-à í Yahudawaká bàna rag, kada abig bàg doka Musa bàna, big rag wù ri tàg mpìr káníng rag abig kyag yanká bubá jur bàna, ma abig bàg bu sù Yahudawaká bàna tìnn. ");
INSERT INTO jib_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bá fig taiwú barà à bi sig níng. To, ma yá sáshinn rà? ");
INSERT INTO jib_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","A sa bu-à yá dinya wù. Yi shi sig ma mpìr yina, big gib sig nu ma Shìdun rag bá sa bu zyun. ");
INSERT INTO jib_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","A kà áyaubá ni ma aning big sa bu-à bá sa níng ábìr-à ni. A wa big bài-à bá wann jinnbá ma kàhi. Wà wa sa hing àdòníng, í wà kó ni ma yì wà barà wù má, wù ri bàg doka Musa tìnn, bá yì bar jír-à big fig sig á shinnwú ni níng, í àjai bàna. ");
INSERT INTO jib_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mpìrká ká í Yahudawaká bàna, ká bir sig pìkyinnbá á byar Yesu ni níng, bigbá yi ba ya sig big wasika rag kada abig ji buju-à big ya sig bu sìnn bàna. Kada abig ji àsà bàna. Kada abig zwam wi zyun-à big sìm gban sig átai bàna. Kada abig sa àyái bàna tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Barà Bulus fig jir àgbam káníng àdòníng, ku í zìm-à. Byar-à bi kyàr, sái ku zìg mpìr yina káníng ku ma káníng sa rìg nu bu-à káníng gib sig. I byar-à ku dù n yag mà lu Shìdun-à ni, n yag dinya àgbamká màhàn àyúnn-à bu-à big ri sa níng má vinn áni, í àyúnn-à kó ni áyaubá ni má ya Shìdun bu. ");
INSERT INTO jib_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Barà su sùmpyànn nyàan màg, sái mpìr Yahudawaká bi sig mà jànn Asiya, big myàng Bulus mà lu Shìdun ni. I byar-à big tàg gbam mpìrká pìkyinn n bi pànn ku. ");
INSERT INTO jib_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Big bar mpìrká rag, “Ning mpìr Israilaká aning bi sa shang yi. Mpìr-à yi pànn sig níng, í mpìr-à ri kyann kyann mi ri tàg sa bai mpìrká á shinn bu-à yi mpìr Yahudawaká yi ri sa. Hár ku ri tàg sa bai mpìrká á shinn doka Musa, kwonn ma lu Shìdun-à níng. Iri wàníng bàna má, ku zìg bi sig mpìrká zyun-à í Yahudawaká bàna, n sa bai rìghing lu Shìdun byar kyìkyàr-à níng.” ");
INSERT INTO jib_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bu-à sa big dang àdòníng, big myàng Tarufimas, mpìr Afisa, ma Bulus ri kyann kyann í zyun á finn swann-à ni. Big wà sig rag ku ma wàníng kà bi sig í zyun á finn lu Shìdun ni. ");
INSERT INTO jib_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Barà mpìrká á finn swann-à ni fig àdòníng, big shàr bi vinn rìg ma shàu, pìkyinnbá dù rìghing. Big bi n pànn Bulus, n gbar zu yag ku mà myann, gbìb fig tá bàna, big bi kìg rìg nu nkyunká bu lu Shìdun á simwá ni. ");
INSERT INTO jib_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Big ri kar rág barà bá gban ku. Sái tai bu-à big ri sa níng yag fòr á byar àgbam sojaká ni rag, mpìrká bidìm pár ri ngang ngain á finn swann-à ni. ");
INSERT INTO jib_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","I byar-à àgbam soja-à níng zìg sojaká, ma àgbam sojaká kádà, big yag mà byar-à mpìrká shi sig. Barà big yag fòr àdòníng, sái mpìrká fim Bulus, n dab fig rag ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Agbam soja-à níng yag yàr màhàn, n pànn Bulus n rag abig sìr ku ma sarka pyànà. Barà big sìr wàníng àdòníng, sái ku bib byann mpìrká rag wàníng í ni rà? Abig dinya ku bu-à wàníng sa sig. ");
INSERT INTO jib_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bìr mpìrká kwonn sig níng, kó ni dang buwá kim, kó ni dang buwá kim, hár àgbam soja-à hi fig yì fig yìr jír-à bàna. I byar-à ku rag abig zìg yag Bulus mà bariki. ");
INSERT INTO jib_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Barà big zìg yag fòr ku á nu nkyun-à ni mà byar akyáb bu-à big ri tib bar áni níng, sái mpìrká ri sa shi rag shinnbá vinn rìghing. I byar-à sojaká swann nann zu ku á wai. ");
INSERT INTO jib_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mpìrká ri bàg ku á sim níng, dang nài ngbam nímá mi ri dang rag, “Aning gban rìg ku.” ");
INSERT INTO jib_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Barà bá swann zìg kà yag Bulus á finn bariki-à ni àdòníng, í byar-à ku dinya àgbam soja-à níng rag, “Mì ri zìm ń dinya wù bu zyun.” Agbam soja-à níng hi bib ku rag, “Asái wù ri dang nu jir Helena rà? ");
INSERT INTO jib_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Wù í mpìr Masar zyun-à rì nu sig kànn ma àgbam jànnyí n gbar zìg yag sig mpìr agban ki dubu yina mà awúnn-à ni níng bàna rà?” ");
INSERT INTO jib_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus rag, “Wi, í mì bàna, mì í mpìr Yahudawa. Big mà sig mì á finn swann Tarsus mà jànn Kilikiya, í finn swann zyun ùwài. Wúshèní á ya mì pyù, mì ri zìm ń dinya mpìr káníng jír.” ");
INSERT INTO jib_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","I byar-à àgbam-à í zìm-à. Bulus sar sig buwá á nu akyáb bu-à mà wai, n sa nann zu vùwá n dang rag, mpìrká abig pànn shi akim. Mpìrká í pànn shi rìg-à. I byar-à ku dinya káníng jír á nu jírbá ni, í nu jir Yahudawaká. ");
INSERT INTO jib_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ku rag, “To, àgbammí big ma jàumí big, aning shi akim aning fig bu-à má dinya ning barà ǹ sa fig bu-à bibai bàna níng.” ");
INSERT INTO jib_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Barà big fig ku dinya big jír á nu Yahudawaká, wà í nu jírbá níng, í byar-à big shi rìg yir. I wà ku dang rag, ");
INSERT INTO jib_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mì í mpìr Yahudawa, big mà sig mì á Tarsus á jànn Kilikiya. N wài gbam sig áyág á finn swann Urushalima. Mì í wùn sukà Gamaliyal. Ku tàg sig mì bu barà má bàg doka yàkúyí big ábibir. Mì má, ǹ sa hing swàm Shìdun àràg barà ning ri sa níng tìnn. ");
INSERT INTO jib_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Wàrì níng mì ri ya mpìrká ri bàg Yesu shwìn wàni. Mì ri pànn wunù ma uwà mì ri kìg kà big á tonn fi-à ni, mì ri gban big. ");
INSERT INTO jib_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bu-à mì ri dang níng, àgbam zyun-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun, ma àgbamká kádà bidìm pár, bá zìm jírmí mì ri dang níng rag í àjai. A byar àgbamká ri twìb swànn bu á pyànn Shìdun ni, ǹ dìg sig wasika zyun jirà má yag mà finn swann Dimashka, ń pànn mpìrká ri bàg Yesu mà, ń sìr big á sarka, n zìg kàng bi big á Urushalima jirà abig sìnn kà big á shwìn. ");
INSERT INTO jib_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Barà ǹ shi áyau kyonn, mì ri yag, ǹ nyàan á finn swann Dimashka fòr, daidai àyúnn áyau shinn. I byar-à àyar yar wann bi mà wai shi àràg àbàin pyìr, n yar kàng kwìb mì áni. ");
INSERT INTO jib_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","N kù wann á jìnn ni, ǹ fig nài jír ri bar mì rag, ‘Shawulu, Shawulu, sáshinn wù ri ya mì shwìn àdòníng rà?’ ");
INSERT INTO jib_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","I byar-à n bib rag, ‘Wù í ni rà, wù Shinn Lumí?’ I wà ku rag, ‘Mì í Yesu mpìr á Nazarat zyun-à wù ri ya mì shwìn níng.’ ");
INSERT INTO jib_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mpìrká nu yag sig mì á gbìb-à ni níng, big myàng hing àyar-à hi, ama big fig yì fig nài jír mpìr-à ri dinya mì jír-à níng hi bàna. ");
INSERT INTO jib_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","I byar-à ǹ bib ku rag, ‘Shinn Lumí, má sa kai rà?’ Ku dinya mì rag ń dù ń yag kà á finn swann Dimashka, bá dinya mì bu-à Shìdun ri zìm ń sa màhàn. ");
INSERT INTO jib_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Zumí bàg rìghing jir àyar-à níng hi. I byar-à jàu kyonnmí big bi pànn mì á vù-à ni n zìg kà yag mì mà finn swann Dimashka. ");
INSERT INTO jib_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“To, mpìr zyun shi sig á finn swann-à níng hi ni big ri bar ku Hananiya. Ku í mpìr-à ri wib Shìdun, ku ri bàg dokayí. Mpìr Yahudawaká á finn swann-à níng hi ni bidìm pár ri yan ku wàni. ");
INSERT INTO jib_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mpìr-à níng hi bi sar yàr ma mì n dang rag, ‘Wunzàmí Shawulu, zuwú aku yar finn.’ A byar-à níng hi, zumí í yar finn rìg-à, ǹ myàng ku. ");
INSERT INTO jib_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","I byar-à ku dinya mì rag, ‘Shìdun bu yàkúyí big shig zu sig wù jirà á yì bu-à ku ri zìm á sa, ma á myàng Mpìr Kyinn Sìsàn-à níng ma á fig jír á nuwá ni. ");
INSERT INTO jib_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wá shi àsàin-à má dinya mpìrká bu-à à myàng sig n fig sig á shinnwá ni. ");
INSERT INTO jib_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","To, kada á shi kir bu zyun bàna, á dù, abig wau wù dìr batisma, á bar zìnn Shinn Luwú Yesu jirà a Shìdun tu kyàr wù bu pyìrwú.’ ");
INSERT INTO jib_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“I byar-à hi ǹ dù n kàng yag kàng ma Urushalima. Ayúnn su zyun ǹ yag kà á lu Shìdun ni mi ri vig Shìdun, í byar-à ǹ myàng bu shi àràg mì ri la la. ");
INSERT INTO jib_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A byar-à hi ǹ myàng Shinn Luyí, ku dinya mì rag, ‘A dù kíni ma á fim Urushalima, jir kai bàna wà wa dinya hing mpìrká á Urushalima jír á shinnmí ni, bá zìm fig bàna.’ ");
INSERT INTO jib_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","I byar-à ǹ dinya ku rag, ‘Shinn Lumí, mpìr káníng yì rìghing barà mì ri kà kyann tonn bìr kwonn kim kim mi ri kìg kà kyann mpìrká bir sig pìkyinn á byarwú ni níng á tonn fi, ma barà ǹ dab sig big dab dab níng. ");
INSERT INTO jib_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sai-à big gban Istifanus mpìr àsàin-à dinya sig mpìrká jírwú níng, ǹ shi sig màhàn, ǹ zìm hing wàni, hár mì ri shi myàng kwonn ma jà mpìrká ri gban ku níng.’ ");
INSERT INTO jib_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Sái Shinn Lumí rag, ‘A yag, má swam yag wù á byar mpìrká ká í Yahudawaká bàna, wá yag pyunn ninonn nímá, má yag dinya big jírmí.’ ” ");
INSERT INTO jib_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mpìrká shi sig á byar-à hi big ri shi, mi ri fig jir Bulus barà ku dang rag Shìdun ri swam yag ku á byar mpìrká ká í Yahudawaká bàna. I byar-à hi pìkyinnbá bai rìg. Big gbam nài gbam n rag, má sàn káb nì wà abig gban rìg ku, sàn fig wà aku shi á dunyaru bàna. ");
INSERT INTO jib_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Big yan nài yán n zìg jàbá mi ri pìm nímá pìm nímá. Big pyar avír mi ri fam yag mà wai. ");
INSERT INTO jib_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","I byar-à àgbam soja-à níng rag, abig zìg kà yag Bulus mà finn bariki, abig yang ku ashor jirà aku dinya big bu-à ku sa sig mpìrká ri yan yán àdòníng. ");
INSERT INTO jib_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Barà big ri sìr ku jùr bá dab ku àdòníng, sái Bulus bib àgbam soja-à níng n rag, “Sáshinn wá dab mpìr Roma barà à wà fig ma ku kwonn bàna níng rà? Doka dang sig àdòníng rà?” ");
INSERT INTO jib_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Barà àgbam soja zyun-à níng fig àdòníng, ku yag dinya àgbambá n rag, “Bu-à wù ri sa níng sàn hing rà? Mpìr-à níng í mpìr Roma.” ");
INSERT INTO jib_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","I byar-à àgbam soja-à níng bi bib Bulus rag “Ajai wù í mpìr Roma rà?” Bulus rag, nn, ku í mpìr Roma àjai. ");
INSERT INTO jib_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Agbam soja-à níng dinya Bulus rag, “N wa sig bài ùwài nímá, í wà big ya mì pyù ń shi mpìr Roma.” Bulus dinya ku rag, “Bumí mì í wùn Roma, jir kai bàna tamí í mpìr Roma.” ");
INSERT INTO jib_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Gbìb fig tá bàna, sai mpìrká ri zìm abig bib ku jír-à níng, big dà fim rìg ku. Agbam soja-à hi má, zinn pànn rìg ku, jir kai bàna ku yì fig wà wàníng í mpìr Roma bàna, n sìr rìghing wàníng ma sarka. ");
INSERT INTO jib_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Agbam-à níng ri zìm aku yì byann mìr jír bu-à sa Yahudawaká ri ya Bulus laifi níng. Byar-à kyàr í wà ku pù finn wàníng á tonn fi-à ni, í wà n bar kwonn àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma agbamká kádà, abig kwonn í byar ńzyun. I byar-à ku zìg bi Bulus n sìnn kà wàníng áyaubá ni, jirà a wàníng dang bu-à wàníng sa sig. ");
INSERT INTO jib_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","I byar-à Bulus myàng àgbamká shi sig níng, n dinya big rag, “To, yiwaimí big, mì ri sa swàm Shìdun, Shìdun yì hing kyinnmí barà ǹ sa fig ku bu-à bibai bàna, hár bi àyúnn-à jánn níng.” ");
INSERT INTO jib_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Barà Bulus dang àdòníng, Hananiya àgbam-à áyau mpìrká ri twìb swànn bu níng, dinya ká sar yàr sig ma Bulus n rag, abig dab ku á nu-à ni. ");
INSERT INTO jib_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","I byar-à Bulus dinya ku rag, “Shìdun má dab wù tìnn, wù mpìr-à ri dang jír nu pyànà. Wù ri wà mì kwonn jir shinn doka. Doka Musa dang rag abig dab mpìr bàna, ama wù ri kìm doka-à hi rag abig dab mì.” ");
INSERT INTO jib_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mpìrká ká sar sig màhàn níng bib ku rag, “Sáshinn wù ri swau àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng rà?” ");
INSERT INTO jib_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","I byar-à Bulus rag, “Yiwaimí big, ǹ yì fig wà ku í àgbam áyau mpìrká ri twìb swànn bu bàna. Jir Shìdun ri dinya yi rag kada ayi dang jír-à bibai á shinn mpìr-à shi sig àgbam áyauyí ni bàna.” ");
INSERT INTO jib_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Barà Bulus myàng yì rag mpìrká kádà í Sadukiyawaká, kádà í mpìr Farisawaká níng, í byar-à ku dang jírwá rag, “Yiwaimí big, mì í mpìr Farisawa, mì í wùn Farisawa tìnn. Big ri wà mì kwonn jirà ǹ rag mpìrká wu sig níng, má dù nann zu kàng ma yonki.” ");
INSERT INTO jib_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Barà ku dang àdòníng, sái shùr gbìb bi kà áyau Farisawaká ma Sadukiyawaká ni, hár big gàfinn rìg áni kyau pyànà. ");
INSERT INTO jib_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadukiyawaká dang rag mpìr ma wu hing má dù nann zu kàng fig ma yonki bàna. Big ri dang rag yann aswam Shìdun mà wai bàna, adìn mpìr bàna tìnn. Ama Farisawaká ri bir pìkyinn á shinn bu sara káníng ni bidìm pár.) ");
INSERT INTO jib_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Barà big ri gbìb shùr wàni àdòníng, í byar-à malamká ká áyau Farisawaká ni dù nann zu, n dang rag “Haba, yi myàng fig laifi bu zyun á byar mpìr-à níng ni bàna. Káhi jirà ku ri dinya mpìrká níng, í wùn aswam Shìdun zyun dinya síg ku nì, ma nímá bàna, í adìn zyun dinya síg ku nì.” ");
INSERT INTO jib_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Shùr gbìb-à hi bi kab rìg gbam. Barà àgbam soja-à níng myàng shi àràg mpìr káníng má gbar yab gàfinn Bulus áni níng, zinn pànn rìg ku, í byar-à ku dang rag a sojaká tìg wann yag abig zìg zu bi Bulus mà yau bìr mpìrká ni, ma abig zìg kàng yag ku mà bariki. ");
INSERT INTO jib_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A fi-à ni, Shinn Luyí bi á byar-à Bulus shi sig, n dinya ku rag, “A wim pìkyinn, barà à dinya sig mpìrká á finn swann-à níng ni jírmí níng, í barà wá yag dinya mpìrká mà jànn Roma jírmí áni tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na kyàr byar-à mpìr Yahudawaká bi tung ki ùwài nímá n rag bá ji fig buju bàna, bá wa fig zàpìr bàna, sái wà ba gban rìghing Bulus. ");
INSERT INTO jib_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mpìrká dinn kwonn sig dìrbá níng, big kab hing mpìr dìpyànà. ");
INSERT INTO jib_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","I byar-à big yag mà byar àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma àgbamká kádà, n dinya káníng rag, big tung ki rag sái wà ba gban rìghing Bulus í wà bá ji buju í ni. ");
INSERT INTO jib_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Big dinya káníng rag, “Ning ma àgbamká bigná bidìm pár, aning yag vig àgbam soja-à níng rag aku ya bi ning Bulus. Aning sa shi rag ning ri zìm aning bib swàb kà ku jír, jirà wà kwa bi hing ayi gban rìg ku á gbìb-à ni.” ");
INSERT INTO jib_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Yar-à big ri sa jirà abig gban Bulus níng, wùn ajunwàwá fig rìghing. I byar-à wùn ajunwàwá yag mà bariki soja, n yag dinya ku jír-à hi. ");
INSERT INTO jib_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","I byar-à Bulus bar bi àgbam soja zyun n dinya ku rag aku zìg yag wùn sukà-à níng mà byar àgbambá ni, jir kai bàna wùn-à hi shi sig ma jír-à kwá dinya àgbam-à níng. ");
INSERT INTO jib_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ku zìg yag wùn-à níng hi mà byar àgbambá ni n dang rag, “Bulus zyun-à ning kìg sig ku níng, ku bar mì n rag ń zìg bi wùn sukà-à níng á byarwú ni, ku shi sig ma jír-à kwá dinya wù.” ");
INSERT INTO jib_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","I byar-à àgbam-à níng hi bi pànn wùn-à hi á vù-à ni n zìg kann ku agang n bib ku rag, “To, bu-à wù ri zìm á dinya mì níng, í kai rà?” ");
INSERT INTO jib_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Wùn-à níng rag, “Mpìr Yahudawaká kwonn sig nu rag bá vig wù rag, akìn á zìg wai yag Bulus á pyànn àgbamká ni. Bá sa yar rag big ri zìm abig bib Bulus jír. ");
INSERT INTO jib_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama kada á zìm bàna, jir kai bàna mpìrká ri shi kir ku á gbìb-à ni jirà abig pànn ku á gbìb-à ni ma abig gban rìg ku, big kab hing mpìr dìpyànà. Big tung sig ki ùwài nímá rag bá ji fig buju bàna, bá wa fig zàpìr bàna sái wà ba gban hing ku. Big dinn kwonn kinn rìghing dìrbá, big ri shi kir ku á gbìb-à ni. Big ri shi kir rág bu-à wá dang.” ");
INSERT INTO jib_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","I byar-à àgbam soja-à níng dinya ku rag, “A yag, kada á dinya mpìr zyun rag à dinya sig mì jír-à níng bàna.” ");
INSERT INTO jib_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","I byar-à àgbam soja-à níng bar àgbam soja pyànà n dinya big rag, “Aning zìg soja dari pyànà, kwonn ma ká má nann á vinn big dìb-sara agban dwib, ká má pànn sau big dari pyànà. Aning dù àsháu ajunndúbi á fi-à ni aning yag mà Kaisariya. ");
INSERT INTO jib_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aning zìg bi vinnká Bulus má nann áni, aning zìg yag fòr ku mà byar gwamna Filikus ítau.” ");
INSERT INTO jib_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Agbam soja-à níng ba yag gwamna wasika n rag: ");
INSERT INTO jib_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Wasika-à níng, í mì Kalaudiyas Lisiyas mì ri ba nì. Mì ri bib wù gwamna Filikus. Mì ri bib wù bib bib. ");
INSERT INTO jib_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bu-à sa ǹ ba ya sig wù wasika-à níng, jir kai bàna mpìr-à ǹ tìr bi sig ku á byarwú ni níng, Yahudawaká pànn ku big ri zìm abig gban rìg ku. I byar-à ǹ yag kwonn ma sojaká bumí, yi zìg zu rìg ku á vùbá ni, jir kai bàna ku í mpìr Roma. ");
INSERT INTO jib_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mì ri zìm ń yì bu-à sa big ri dang ku jír níng. I byar-à ǹ zìg yag ku á pyànn àgbambá ni, jirà abig dinya mì bu-à ku sa sig. ");
INSERT INTO jib_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","N dìg fig bu bibai-à ku sa sig wà bá gban ku, kó barà bá du kà ku á tonn fi bàna. Big dang ku jír á shinn dokabá ni. ");
INSERT INTO jib_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Barà ǹ fig big rag Yahudawaká káhi ri zìm abig gban rìg ku níng, í bu-à sa ǹ tìr bi sig ku á byarwú ni. N dinya rìghing mpìrká ri zib ku níng rag, wà ba zìm jír dang, abig bi á byarwú ni.” ");
INSERT INTO jib_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","I byar-à sojaká bi zìg Bulus á fi-à ni n yag fòr mà finn swann Antibaris àràg barà big dinya sig big. ");
INSERT INTO jib_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na kyàr byar-à sái sojaká fim ku á vù sojaká ká nann sig á vinn-à ni jirà a káníng zìg yag ku mà Kaisariya. I byar-à big í kàng yag rìg-à mà bariki-à ni. ");
INSERT INTO jib_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Káníng zìg yag ku mà Kaisariya. A byar-à hi big ya gwamna wasika-à hi. Big zìg Bulus n sìnn sig á vùwá ni. ");
INSERT INTO jib_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gwamna bi jangga tarkada-à hi, n bib Bulus rag, wàníng zu bi sig áni rà? Bulus rag ku zu bi sig á jànn Kilikiya. ");
INSERT INTO jib_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Sái gwamna rag, “To, wà mpìrká tìr ya sig wù jír níng ma bi hing, í wà má fig byann jírwú.” I byar-à ku sìnn sojaká sa gadi wàníng á finn lu Hirudus ni. ");
INSERT INTO jib_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na kù su swana, í byar-à Hananiya àgbam-à áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni níng, yag mà Kaisariya mà àgbamká kádà, kwonn ma loya zyun zìnnwá í Tartulus. Big kwonn nubá n dang bai Bulus á pyànn gwamna-à ni. ");
INSERT INTO jib_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Barà big bar Tartulus àdòníng, ku kà mi ri tìr ya Bulus jír. Ku dinya gwamna-à hi rag, “Wù Filikus àgbam-à níng, mpìrká ri shi shu pìkyinn na tag á dò shinnwú ni. Wù ri sa ya mpìrká bu-à ǹsàn á jànnyí ni. ");
INSERT INTO jib_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kó áni bidìm pár mpìrká zìm hing swàmwú. Nuyí kinn fig wà yá sa wù ísoko bàna. ");
INSERT INTO jib_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","N zìm fig ń sa bai wù nu swàmwú bàna, ama mì ri zìm á tàg kyinn ajun ma á fig jíryí títi nímá. ");
INSERT INTO jib_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Yi dìg mpìr-à níng ri gbar wab kwonn mpìrká shinn. Ku ri gbar dù ngain áyau mpìr Yahudawaká ni, kó áni bidìm pár. Ku má, ku í àgbam áyau mpìrká ri bàg mpìr zyun-à zu sig mà Nazarat. ");
INSERT INTO jib_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ku ri zìm aku sa bai rìg lu Shìdun, í bu-à sa yi pànn sig ku níng. Yi ri zìm ayi wà ku kwonn àràg barà dokayí dang sig. ");
INSERT INTO jib_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ama Lisiyas àgbam soja-à níng, bi gbar shwar zu ku á vùyí ni ma gbam. ");
INSERT INTO jib_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Agbam soja-à níng dang rag wà ya zìm ayi dang jír, ayi zìg bi á byarwú ni. A bib Bulus, wá fig byann jír-à yi zìg bi sig níng á nuwá ni.” ");
INSERT INTO jib_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mpìr Yahudawaká kà áyau jír-à hi ni, n dang rag í àjai. ");
INSERT INTO jib_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gwamna-à hi sa nann zu vùwá n rag a Bulus dang jírwá. Bulus dang rag, “N yì hing wà jiwú nìnànn nímá, wù ri wà kyann kwonn. Jir wàníng má dang jírmí ma pìkyinn àjwár. ");
INSERT INTO jib_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Sai-à ǹ yag mà Urushalima jirà ń wib Shìdun níng, kwonn ma wà janá-à níng kab fig su dwib agban pyànà bàna. Wà wa bib hing má, bá dinya wù. ");
INSERT INTO jib_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mpìr Yahudawaká dìg fig mì, mì ri sa yipyàr ma mpìr zyun mà lu Shìdun ni bàna. Big dìg fig mì, mì ri gbar wab kwonn mpìrká shinn bàna, kó mà tonn bìr kwonn, kó mà byar zyun á finn swann-à ni bàna. ");
INSERT INTO jib_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tàma-à níng bá dinya fig wù yìr bu-à sa big ri tìr ya mì jír níng bàna. ");
INSERT INTO jib_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Má dinya wù yìr bu-à sa sig. Mì ri wib Shìdun àsàin-à yàkúyí big rìi wib níng, ama mì ri wib Shìdun á gbìb-à mpìr káníng ri dang rag bai níng. Mì ri bir pìkyinn á buká Musa ba sig á dokawá ni, kwonn ma bu mpìrká rìi dang kyann jir Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N sìnn sig á pìkyinnmí ni àràg barà big sìnn sig níng rag mpìrká sa sig bu ǹsàn, ma ká sa sig bu bibai bidìm pár, bá dù nann zu kàng mà amir-à ni. ");
INSERT INTO jib_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jir wàníng í bu-à sa mì ri kar ngang mì ri sa kyann bu-à ǹsàn á pyànn Shìdun ni, ma á pyànn mpìrká ni bidìm pár, àràg barà kyinnmí ri zìm. ");
INSERT INTO jib_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“To, barà jimí nìnànn nímá ǹ yag fig mà Urushalima bàna níng, ǹ zìg bài n yag màhàn jirà ń sa shang mpìr ashiká bumí màhàn, ma ń ya Shìdun bu. ");
INSERT INTO jib_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Big dìg mì á lu Shìdun ni á sai-à ǹ sa kinn rìghing swàm bu ya-à níng, ma sai-à ǹ sa kyàr rìghing dìrmí. Sai-à níng hi bìr mpìrká bàna màhàn. Mpìrká gbìb fig shùr bàna. ");
INSERT INTO jib_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama mpìr Yahudawaká káhi bi sig mà jànn Asiya shi sig màhàn, sàn sig abig nìm bi á byarwú ni, abig dang bu-à ǹ sa sig, wà ba shi sig ma jír zyun á shinnmí ni. ");
INSERT INTO jib_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kó ká shi sig áyág níng, abig dang bu bibai-à big dìg sig mì mì ri sa, sai-à ǹ sar á pyànn àgbamká ni níng. ");
INSERT INTO jib_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Bu-à ǹ dang sig màhàn bàna, íri wà ǹ dang rag janá-à níng ning ri wà mì kwonn jirà ǹ sìnn sig á pìkyinnmí ni rag, mpìrká wù rìghing má dù nann zu kàng ma yonki níng.” ");
INSERT INTO jib_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filikus yì byann hing Gbìb-à níng hi wàni, ku dinya big rag, “Aning fim ma jír-à hi, sái wà Lisiyas àgbam soja-à níng, ma bi hing í wà má wà kwonn-à í ni.” ");
INSERT INTO jib_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ku dinya àsàin-à ri sar gadi-à níng rag a wàníng sar myàng kwonn ma Bulus, ma a wàníng ya Bulus pyù barà Bulus má yàn finn dìr, ma a wàníng ya jàuwá big pyù barà bá ya bi ku bu-à ku ri zìm. ");
INSERT INTO jib_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Na kù su pyànà, Filikus bi kwonn ma wàwá Durusila, uwà-à hi í mpìr Yahudawa. I byar-à ku swam aswam rag, abig zìg bi Bulus. Ku fig jir Bulus barà wàníng ri dang jir pìkyinn bir á byar Yesu ni. ");
INSERT INTO jib_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bulus ri dang jír á shinn shu pìkyinn sìsàn, ma shinn pànn samyib, ma àyúnn-à Shìdun má wà kwonn. I byar-à Filikus shàr rìg zinn, n dinya Bulus rag, “Tàma-à níng á dù rág. Sai-à ma dìg hing pyù-à, má bar bi jakàng wù.” ");
INSERT INTO jib_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ku wà sig rag Bulus má ya ku bài, í bu-à sa ku ri bar bi kyann wàníng, mi ri dang jír ma wàníng. ");
INSERT INTO jib_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Barà ji pyànà wam zu àdòníng, Borikiya Festas pyann kàng shinn Filikus n shi kàng nì gwamna. Sai-à Filikus tìg wann fig ma bàna níng, ku fim Bulus á tonn fi-à ni, jir kai bàna ku ri zìm a mpìr Yahudawaká zìm ku. ");
INSERT INTO jib_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sai-à gwamna Festas bi á Kaisariya byar-à kwá sa swàmwá, ku shi màhàn suwá sara, í wà ku dù n yag mà Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Barà ku yag fòr àdòníng, àgbam mpìrká ri twìb swànn bu á pyànn Shìdun ni, ma àgbam Yahudawaká yag mà byarwá ni, n zìg yag jírbá á shinn Bulus ni. Big vig Festas ");
INSERT INTO jib_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","n rag, wúshèní a wàníng sa ya big bu, a wàníng dwim ya bi big Bulus mà Urushalima. Bu-à sa big vig gwamna àdòníng, big ri zìm wà Bulus ma bi hing, bá gban rìg ku á gbìb-à ni. ");
INSERT INTO jib_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festas dinya big rag, “Big kìg sig Bulus mà Kaisariya mi ri sar myàng kwonn ma ku. Mì ri zìm ń yag màhàn su pyànà káníng. ");
INSERT INTO jib_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ayi ma àgbamká buná yág zyun, abig dang jír-à màhàn wà kwa sa sig bu-à bibai.” ");
INSERT INTO jib_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festas na suwá awinyin kó dwib ma big, í wà ku dù n kàng yag mà Kaisariya. Byar-à kyàr ku shi wann mà tonn kwonn wà-à ni, n dang rag abig zìg bi Bulus á byarwá ni. ");
INSERT INTO jib_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Barà Bulus fòr bi àdòníng, í byar-à Yahudawaká ká bi sig mà Urushalima níng, sar kàng kwìb ku áni, n zìg bi jír ùwài kim kim nìnànn nímá á shinnwá ni, n rag ku sa sig buká sàn fig bàna. Ama big dang fig jír zyun-à má tàg rag bu-à big ri dang níng í àjai níng bàna. ");
INSERT INTO jib_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulus kan dang jírwá n rag, “N sa fig bu bibai áyau doka Yahudawaká ni bàna, kó mà lu Shìdun ni, kó doka kùr Roma bàna tìnn.” ");
INSERT INTO jib_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festas ri zìm Yahudawaká abig fig àjwárwá, í byar-à ku bib Bulus rag, “Wù ri zìm abig zìg yag wù mà Urushalima jirà abig wà wù kwonn-à níng mà pyànnmí ni màhàn rà?” ");
INSERT INTO jib_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","I byar-à Bulus rag, “Mì ri zìm fig abig zìg yag mì mà Urushalima bàna, jir kai bàna ǹ sa fig Yahudawaká bu bàna àràg barà wù ma shinnwú à yì níng. Mì ri zìm abig wà kwonnmí á byar tonn kwonn wà bu kùr Roma byar-à sàn sig abig wà. ");
INSERT INTO jib_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","N nìm ma sa hing bu-à bibai wà zyun-à fòr sig wà bá gban mì áni, má ngàng fig wà abig gban mì bàna. Ama wà jír-à big zìg bi sig á shinnmí níng ma àjai bàna, walai mpìr-à má ya kà sar mì á vùbá ni. Bumí mì ri zìm ń zìg yag jírmí mà byar kùr Roma.” ");
INSERT INTO jib_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festas bi wà jír-à big mpìr swàmwá big jirà aku fig bu-à bá dang á shinn jir Bulus. I byar-à ku dinya Bulus rag, “A dang rag wù ri zìm á yag mà byar kùr Roma, to, má tìr yag wù mà byar kùr Roma.” ");
INSERT INTO jib_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ayunn zyun sái kùr zyun-à big ri bar ku Agariba níng, ku ma wàwá Barniki bi kyìnn á Kaisariya jirà abig shà Festas. ");
INSERT INTO jib_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Big shi nonn màhàn. Sái Festas zìg bi jír Bulus á byar kùr-à hi ni n dang rag, “Mpìr zyun shi sig áni, big kìg sig ku tunn sai-à Filikus shi sig á gwamna, wàníng fìnn fig ku bàna. ");
INSERT INTO jib_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Sai-à ǹ yag mà Urushalima, àgbam Yahudawaká ma àgbamká ri twìb swànn bu á pyànn Shìdun ni níng, zìg bi jír á shinnwá ni n bi dìg mì. Big ri zìm ń dang rag jír pànn hing ku, jirà abig gban rìg ku. ");
INSERT INTO jib_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ama ǹ dinya big rag, dokayí yi Romawaká, sai-à ba gib fig ma jír bàna, yá ya kà fig mpìr á vù mpìrká ri dang bai ku níng, jirà a pìkyinnbá jwar bàna. Yá ya àsàin-à big pànn sig níng pyù, aku dang jír-à á nuwá ni á pyànn mpìrká pànn sig ku. ");
INSERT INTO jib_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Big bi dìg mì áyág níng, ǹ jag fig jau áni bàna, byar kyàr ǹ shi mà byar tonn kwonn wà-à ni, n dang rag abig zìg bi mpìr-à hi. ");
INSERT INTO jib_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mpìrká zìg bi sig jír á shinnwá ni, big sar dù nann zu á wai, ama big dang fig bu-à ku sa sig àràg barà ǹ wà sig rag bá dang níng bàna. ");
INSERT INTO jib_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Big sa yipyàr ma ku n yag zìg bi sòr jír á shinn adinibá ni, kwonn ma jír á shinn Yesu mpìr-à wu sig níng, wà zyun-à Bulus ri dang rag wàníng dù nann zu kàng rìghing ma yonki níng. ");
INSERT INTO jib_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","To, bumí, ǹ yì fig barà má sa má fig byann jír-à hi áni bàna. I byar-à ǹ dinya Bulus rag wà kwa zìm hing, aku yag mà Urushalima jirà abig wà kwonn-à hi màhàn. ");
INSERT INTO jib_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama Bulus vig rag abig fim ma ku, sái wà kwa yag hing mà byar kùr Roma. I byar-à ǹ rag abig sar myàng kwonn ma ku sái wà ma tìr yag hing ku mà byar kùr-à ni.” ");
INSERT INTO jib_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","I byar-à Agariba rag ku ri zìm aku fig jír á nu Bulus ni. Festas dinya ku rag, “Akìn níng wá fig.” ");
INSERT INTO jib_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Byar-à kyàr sái Agariba ma Barniki bi, mpìrká wib big wàni. Big kà á tonn ùwài byar-à mpìrká ri kwonn shinn. Big kà bi kwonn ma àgbam sojaká ma àgbam mpìrká á finn swann-à ni. I byar-à Festas dang rag abig zìg kà bi Bulus áyau tonn-à ni. ");
INSERT INTO jib_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","I byar-à Festas dang rag, “To, Kùr Agariba kwonn ma ning mpìrká bi sig áyág níng, mpìr-à ning myàng sar sig áyág níng, ku í mpìr-à Yahudawaká ká mà Urushalima ma ká á finn swann-à níng ni bidìm pár, big zìg bi jír á shinnwá ni nìnànn nímá n bi dìg mì. Big gbam nài gbam n rag, big zìm fig wà abig fim ku ma yonki bàna. ");
INSERT INTO jib_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","To, bumí ǹ myàng fig bu-à ku sa sig wà bá gban ku bàna. Ama ku vig rag ku ri zìm aku yag mà byar kùr Roma jirà abig wà kwonnwá màhàn. I byar-à ǹ dang rag má tìr yag ku màhàn. ");
INSERT INTO jib_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama ǹ yì fig jír buká ku sa sig wà má ba ya kùr Roma á shinnwá ni bàna. I bu-à sa ǹ zìg bi sig ku á pyànn ná ni jirà aning sa shang mì. N zìg bi sig á pyànnwú ni, wù kùr Agariba. Wà ya fig rìghing jírwá, í wà má yì bu-à má ba ya àgbamyí kùr Roma, í wà má tìr yag ku í ni. ");
INSERT INTO jib_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A myàngmí ni, wà ya tìr yag mpìr-à big kìg sig níng á byarwá ni, wà ya pànn fig mpìr-à níng ma bu bibai bàna, kàhi sàn fig bàna.” ");
INSERT INTO jib_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","I byar-à Agariba dinya Bulus rag, “N ya hing wù pyù-à wá dang jírwú.” I byar-à Bulus sa nann zu vùwá n dang jírwá rag, ");
INSERT INTO jib_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Wù Kùr Agariba, ǹ pànn hing sáà barà má zìg bi jírmí á pyànnwú ni á shinn bu-à Yahudawaká ri dang á shinnmí ni níng. ");
INSERT INTO jib_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A yì rìghing bu sù mpìr Yahudawaká wàni. A yì hing barà big shi sig áni. Jir wàníng mì ri vig wù á sa muyar, ma á fig jírmí níng. ");
INSERT INTO jib_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Mpìr Yahudawaká yì hing bar shumí tunn sai-à mì í wùnshái, ma sai-à ǹ shi sig á byar mpìrká bumí ni á jànnmí ni, kwonn ma shumí wà á Urushalima. ");
INSERT INTO jib_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Daka á ninonn big yì hing mì. Big yì hing wà sai-à rì níng mì í Farisawa, mì ri shi shumí àràg barà Farisawa ri shi. Mì ri jag fig jau ma adini bàna. Wà ba zìm hing bá dinya wù. ");
INSERT INTO jib_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","To, tàma-à níng bu-à sa big ri myàng laifimí níng, big ri myàng á jir shinn barà ǹ bir sig pìkyinnmí á jir bu-à Shìdun rì gib ya sig yàkúyí big nu n rag kwá sa níng. ");
INSERT INTO jib_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Bu-à níng hi í bu-à yi swai mpìr dwib agban pyànà, yi ri bir pìkyinn áni, hár mi ri wib kyann Shìdun fi ma àyúnn. Wàníng í bu-à sa Yahudawaká myàng laifimí áni. A fig, Agariba wù mpìr àgbam. ");
INSERT INTO jib_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bu-à sa ning zìm fig rag Shìdun má gbar dù nann zu ki bàna níng, í jir kai rà? ");
INSERT INTO jib_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Sai-à rì níng mì ma shinnmí, mì ri zib zìnn Yesu mpìr-à á Nazarat. N sa hing mpìrká ri bàg ku níng bu-à bibai kim kim, mì ri kyab rag sàn hing ń sa àdòníng. ");
INSERT INTO jib_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Sai-à ǹ shi mà Urushalima, ǹ sa hing àdòníng. Agbam mpìrká ri twìb swànn bu á pyànn Shìdun ni ya mì gbam n pànn mpìrká bu Yesu nìnànn nímá n kìg kà big á tonn fi. Wà mpìrká ma ri zìm abig gban big, mì má, mì ri zìm àdòníng tìnn. ");
INSERT INTO jib_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kàun nìnànn nímá mì ri kà á tonn bìr kwonnká ni mi ri ya big shwìn, mì ri kar ngang jirà abig dang rag bá bàg fig Yesu bàna. Mì ri nànn àgùnn. Mì ri yag mà swannká ni kim kim, mì ri ya big shwìn. ");
INSERT INTO jib_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Wàníng í yìr bu-à zìg dù mì ǹ yag mà Dimashka. Agbam áyau mpìrká ri twìb swànn bu á pyànn Shìdun ni ya mì pyù rag ń yag. ");
INSERT INTO jib_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Wù mpìr àgbam á fig. Barà mì ri kyann á gbìb-à ni àdòníng àyúnn áyau shinn, sái bu zyun bi sa mì. N myàng byar-à bi yar daka mà waisháu-à ni hár n kab rìg àyúnn-à ri fàn níng. Ayar-à hi yar kàng kwìb yi áni, yi ma jàu kyonnmí big. ");
INSERT INTO jib_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yi bidìm pár yi kù wann á jìnn ni. I byar-à ǹ fig nài jír zyun áyau nu jir Yahudawaká dang rag, ‘Shawulu, Shawulu, sáshinn wù ri ya mì shwìn rà? Bu-à wù ri sa níng, wù ri yá shinnwú shwìn átai.’ ");
INSERT INTO jib_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","I byar-à ǹ bib rag, ‘Wù í ni rà, Shinn Lumí?’ Ku rag, ‘I mì Yesu zyun-à wù ri ya mì shwìn níng.’ ");
INSERT INTO jib_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","I byar-à ku dinya mì rag, ‘A dù nann zu ádun. Bu-à sa ǹ bi sig á byarwú ni níng, í jirà má sìnn kàng wù wá shi fàumí, wá bi tàg mpìrká bu-à à myàng sig níng, ma buká má tàg wù mà pyànn níng bidìm pár. ");
INSERT INTO jib_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Má pinn zu wù á vù mpìr Israilaká ni, ma mpìrká swaibá kim kim, ká má swam yag wù mà byarbá ni níng. ");
INSERT INTO jib_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Wá pù ya big zubá, í wà bá vim bìr kyinnbá n má ngàng zufi, bá kàng bi á gbìb bu-à ǹsàn. Wàníng í barà bá zu á vù Shaitan má bir pìkyinnbá á byarmí ni, í wà Shìdun má yafa big bu pyìrká big sa sig, kwá zìg big, má sìnn big bá shi kwonn ma mpìrká buwá ká ku shig zu sig níng.’ ");
INSERT INTO jib_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Agariba, wù kùr, ǹ ngàng fig wà má wib jír-à ǹ fig sig mà wai níng bàna. N wib hing. ");
INSERT INTO jib_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N dang jag jir Shìdun mà finn swann Dimashka, í wà ǹ yag mà finn swann Urushalima n dang jir Shìdun màhàn, kwonn ma jànnká shi kàng kwìb sig finn swann Yahudiya áni. Mì ri dinya mpìrká ká í Yahudawaká bàna níng tìnn. Mì ri dinya mpìrká rag abig dà finn bu-à bibaiká big ri sa, abig bir kyinnbá á byar Shìdun, ma abig sa swàm-à má tàg rag big ri bàg Shìdun. ");
INSERT INTO jib_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Wàníng í yìr bu-à sa Yahudawaká pànn mì á sai-à ǹ shi sig mà lu Shìdun ni, mi ri zìm abig gban rìg mì níng. ");
INSERT INTO jib_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama Shìdun shi sig á shinnmí ni, hár janá-à níng, n shi sig ma yonki. Mì ri dinya wùnshái ma àgbam bidìm pár. Jírmí mì ri dang níng, mì ri dang fig bu zyun kim bàna, mì ri dang bu-à mpìrká rìi dang kyann jir Shìdun ba sig, ma bu-à Musa ba sig. Mì ri dang bu-à big ba sig rag má sa. ");
INSERT INTO jib_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Barà big ba sig rag, wà Almasihu ma bi hing, kwá wa shwìn, ku í àsàin-à má dù nann zu jag mà amir-à ni, í wà kwá dinya mpìr Yahudawaká ma ká í Yahudawaká bàna barà bá wìm zu. Wàníng shi sig í gbìb yiyar.” ");
INSERT INTO jib_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Barà Bulus dang jírwá àdòníng, í byar-à Festas yan ta ku ngbam nímá n rag, “Haba, Bulus, shinnwú vinn rìghing, à kàng rìghing mpìr ǹsáng. Ilimiwú kab gbam í bu-à sa shinnwú ri zìm aku vinn níng.” ");
INSERT INTO jib_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","I byar-à Bulus dinya ku rag, “Wù gwamna, á fig. Shinnmí vinn fig ávinn bàna, jír-à mì ri dang níng í àjai, shi sig ma yìr tìnn. ");
INSERT INTO jib_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kùr Agariba, má dinya kyàr wù kyàr kyàr, má tàm fig wù bàna, jir kai bàna à yì rìghing bu káníng. Bu-à mì ri dang níng big sa tàm fig átàm bàna. ");
INSERT INTO jib_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kùr Agariba, wù ri bir pìkyinn á bu-à mpìrká rìi dang kyann jir Shìdun ba sig níng ra? N yì hing wù ri bir pìkyinn áni.” ");
INSERT INTO jib_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agariba bib Bulus rag, “Wù ri kyab rag má bàg Yesu á dò jir jír títi-à à dinya sig mì níng ni rà?” ");
INSERT INTO jib_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus rag, “Kó wà ma í jír títi, kó wà ma í jír ùwài, mì ri vig Shìdun, wù ma mpìrká shi sig áyág mi ri fig jírmí janá-à níng bidìm pár, aning nìm shi àràg mì. Ama ǹ dang fig rag abig kìg kà ning á tonn fi bàna.” ");
INSERT INTO jib_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","A byar-à níng hi, kùr ma gwamna, ma Barniki, ma mpìrká kádà big dù nann zu. ");
INSERT INTO jib_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Barà big dù àdòníng, big yag wà jír, big rag Bulus sa fig bu bibai zyun-à bá gban rìg ku áni, kó wà bá sìr ku áni bàna. ");
INSERT INTO jib_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kùr Agariba dinya Festas rag, “Bulus nìm ma dang fig ma shinnwá rag kwá zìg yag jír mà pyànn kùr Roma ni bàna, yi nìm má gban rìg jír-à hi.” ");
INSERT INTO jib_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Barà big wà jír-à bi pànn rag yá yag mà Roma á jànn Italiya. I byar-à big sìnn Bulus kwonn ma pursunaká kádà á vù àgbam soja zyun-à big ri bar ku zìnnwá Juliyas. Ku shi sig áyau kyau soja bu kùr Roma. ");
INSERT INTO jib_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","I byar-à hi yi bi kà á kòr zyun ni, zyun-à dù sig mà finn swann Adramitiya, n bi fòr á finn swann Kaisariya. Big ri zìm bá yag má tìg áyau finn swannká mà jànn Asiya. Yi ma Aristarkus big yag sig í zyun á kòr-à ni. Ku í mpìr-à mà finn swann Tasalonika á jànn Makidoniya. ");
INSERT INTO jib_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Byar-à kyàr yi bi fòr á finn swann Sidon. Juliyas àgbam soja-à níng hi sa ya Bulus àsàn, n ya wàníng pyù, a wàníng yag bib kà jàuká bu wàníng á finn swann-à ni, jirà kó káníng má ya wàníng bu. ");
INSERT INTO jib_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","I byar-à yi dù á finn swann-à níng hi ni yi ri yag á gbìb-à ni. Wàu shyù ri gbar, hár wàu gbar kàng yag yi mà sim, yi sa sar fig barà yá yag á gbìb-à yi 