﻿USE sofia;
DROP TABLE IF EXISTS sofia.jao_vpl;
CREATE TABLE jao_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jao_vpl WRITE;
INSERT INTO jao_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jinangu wuka alunga liyi-raangaji liyikiliyi-arduwu ki-Jikaba. Kalu-arri jabungka nalarrku likili-ardu, nya-mangaji yalkuyi Jujiba alu likili-baba, rrankurri-arduwujara wu-Bila kulu rrankirri-arduwujara wu-Jilba, kalu-arri jabungka, kalu-arri namba yukumantharra jibi marda yukularri yiku ki-malbuwu nyuwalunganyu-biyiyu. Namba kalu-wardima awara linji-mangaji linjikulinji-babalu ki-Jujiba kulu kili-nu nyiki-biyi alunga ki-Jujiba ki-burinju. ");
INSERT INTO jao_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jinangu malbu Jikaba, kalngiya ka-arri na-wurdu yiku ki-Jujiba, kilu-manmarralanga nya-mangaji ambuliyalu alunga liyikiliyi-arduwu kangka malbu ka-arri ngaliwa nya-mangaji ka-yanjarri. Kilu-yabima jumbala yiku ki-Jujiba, marringaya rdirardiramantha jumbala, nya-mangaji barranamba alunga liyi-wirdiyu, marringaya jumbala kilu-yabima ngayamantharra yiku. ");
INSERT INTO jao_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ngala likili-baba ki-Jujiba, aluwiji, kala-kala nyalunga-biyi, ka-arri na-wurdu yiku ki-Jujiba ki-arrkulawu, kilu-manmarralanga yiwa ambuliyalu alunga, kulu kalu-mulamulanganthaninya yiku ki-Jujiba, kalngiya kalu-mulamulanganthaninya nalu-wurdu nyuwalunga-anyirawu ki-buringku, kangka yamulu kumba-riyarraba nyiki-biyi yiku ki-buwingku. Kalu-lhawarndi yiku, kurdardi kalu-wukanyinma yabi yiku, kurdardi, kalu-mulamulanga wakulamba. ");
INSERT INTO jao_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kulu jina Jujiba, wundururra kilu-mawuranga awara. Ngaliwa kalili-nu likili-baba wumba kilu-mawuranga awara ngalalu kalu-mulamulanganthaninya mili yurrulu yiku wakulamba. ");
INSERT INTO jao_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ka-arri alunga, “Marrirru, kanhirra-nykarrila. Kanhirra-nykarrila kulu kirrirni-nala wumba karna-mawuranga awara wundururra. ");
INSERT INTO jao_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Wujurl karna-kala, wujurl jakarda ma-ngarra. Kambala-arri baji jabungka, kambala-rdirrirra nya-mangaji wujurl, kurarra ka-arri. Kulu niwarrku kurarra, arrkula nya-ngatha, ka-alarri ankaya, ka-alarri baji, ngala niwarrku kurarra nyirrunga, ka-wingka lukuluku nyuwu-ngatha. Nya-ngatha ka-arri wumbiji alarrinjarra ngala nyirrunga ka-arri mududu nyuwu-ngatha. Nganambaji karna-mawuranga awara.” ");
INSERT INTO jao_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kulu kalu-yalbanga, “Ngani yinda, ngani? Nungka yinda ka-nmala nya-nganunga wirdi, nganu nmanthawu mududu yinku, li-buyi yinku?” Mili yurrulu kalu-mulamulanganthaninya yiku wirangu nya-mangaji wuka kalili-nu wumba kilu-mawuranga awara, yiwa anmanthawu wirdi alunga. ");
INSERT INTO jao_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mili yurrulu kilu-mawuranga wundururra ki-Jujiba, kulu kalili-nu mili likili-baba wungkuwungkulamba. “Marrirru! Karna-mawuranga awara mili yurrulu. Karna-kala awara, rra-kamba, ngakarla, kulu marralhawa ll-bala karna-kala, kulu karna-kala nya-mangaji nmanthawu mududu barra ngathangkalu,” nganinya kalili-nu, baki nganinya kili-nu nyiki-biyi marda. ");
INSERT INTO jao_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kulu malbu Jikuba, ka-mirirri yiku. Ka-arri, “Kajakaja! Ngandarra barra kinyu-mawuranganhu awara? Minja yalkuyi marninda kulu nganu barra, kana-nmala mududu yinku? Nganu barra, yinkurra-wibi baki likili-baba li-ll-bala, wayi barra nganu anmanthawu mududu barra yinku ki-buriyu?” Ka-arri yiku nganinya. ");
INSERT INTO jao_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ngala likili-baba ki-Jujiba, kalu-wardirri nalu-wurdu yiku, kalu-nganyma yiku, ngala nyiki-biyi, kilu-linginma Jujiba wumba kilu-mawuranga awara. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kalu-lhuwarri nguthundiya likili-baba ki-Jujiba, nguthundiya kalu-lhuwarri bajinju Jikim naluyirdi jibiyu baki yukularriyu, kalu-yukuma jibi wiji yiku nyuwalunga-biyiyu. Kala-ka bajinju wujurlu nyamba-wudurrumarithawu ngaliwa ka-arri wambu nya-mangaji Jujiba, wambu kawula-arri nyiki-biyi baji Yiburun. ");
INSERT INTO jao_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ka-arri malbu yiku ki-Jujiba, “Kajakaja! Ngandarra ka-wingkala nguthundiya nganthalu nyinki-baba, kalu-rnani juju barra. Kalu-lhuwarri nguthundiya naluyirdi jibiyu baki yukularriyu, bajinju Jikim kalu-wingka. Bawuji kirni-jala aluwalu.” Kumba-ngarninyma yiku, “Karna-wingkala, biyi.” ");
INSERT INTO jao_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ka-arri mili malbu, “Bawuji lhuwarriya nganthalu li-mangaji, wayi barra alunga, wayi barra jibi wiji. Kulu bawuji waniya karinguthunda, waniya ngathangkalu nalinanthalu awara. Bawuji barra, kajakaja.” ");
INSERT INTO jao_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ankaya ka-lhuwarri...i nguthundiya. Ka-wingka yurrujurru nyala bajinju Jikim. Baji ka-arri yarrbantharra alunga liyikiliyi-babawu. Kila-kala ki-arrkulangku, kila-kala wingkalwingkayarra lukuluku. “Ngabinya! Ngalhiyu ja-yarrbanjimu?” ");
INSERT INTO jao_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kumba-ngarninyma, “Jarna-yarrbanji alunga liyingathaliyi-babawu. Karingamala kalu-wingka marnajinju, kala-ka jibi wiji marnajinju nyamba-wudurrumanthawu wujurl. Kalinyi-nganhu kirna-barlirra? Nganthiwuthu bajalu?” ");
INSERT INTO jao_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ka-arri yiku, “Kalu-lhuwarri marningu, kalirna-kala. Kalirna-nykarri nyamba-wukanyinjarra, ‘Bawuji ngambala-lhuwarriya nguthundiya nyala Duthan.’ Kalu-lhuwarri bajinju.” Kulu nguthundiya ka-lhuwarri Jujiba, kalilu-wanda barra, kalilu-wakarama baji Duthan. ");
INSERT INTO jao_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ngaliwa ka-rilirri karingamala, kala-kala linjikulinji-babalu, kala-kala kulu kalinyamba-wukanyi barra ngandarra ramanthalu nya-mangaji nyalunga-anyira. ");
INSERT INTO jao_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Marniwa barra ngambalalu nya-mangaji jamawuranga. ");
INSERT INTO jao_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bawuji ngambala, winarrku barra ngambala-ramaya jinangu Jujiba. Ngambala-walimaya na-manka, ngambala-walimaya nambinju wajkaliya lawarru. Bawuji barra kulu kambali-nala wunyatha yiku, kila-tha ki-wardalinju, nganinya kambali-nala. Kurdardi kilu-mawurangarru awara mili yurrulu. Ngambalu-rraya mawuranganthawu barra nya-mangaji.” ");
INSERT INTO jao_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ngala nya-mangaji Rubin, kalila-nykarri nyamba-wukanyinjarra, ka-rarri na-wurdu nyiki-anyirawu, kumba-nykalanykarri yiku marakamanthawu. “Marrirru! Waraba kambala-ramarru, wa-nmaya lhungku nyirrunga-anyira!” ");
INSERT INTO jao_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kulu ka-arri mili alunga, “Barni-ramantha marda barni-wurrubantha yilirri nyikungu. Winarrku rru-yibarraya wajkaliya lawarra baji munjimunji ngala barni-ramantha.” Minja ka-wukanyi nganinya alunga ngala minja kumba-wukanyi na-wurdu, “Baku karna-lhungkumala nyangathi-anyira, karna-rdumala kariwajka nakari lawarra. Baku ka-wanila wunyathalu yilalu, karni-jala yamulu yilalu.” ");
INSERT INTO jao_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kulu Jujiba, ka-wingka, ka-wingka nayirdi ki-jumbalawu ki-marringayawu wumba kilu-ngunda nyiki-biyilu, ka-wingka bajinju aluwalu. Kulu yinarrambalulu kalu-wardima, kali-nma jumbala nyikungu, nya-mangaji marringaya kali-nma. ");
INSERT INTO jao_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kulu kalu-rduma nyalunga-anyira, kala-ka bajinju, kalu-walima wajkaliya lawarra, na-lawarr kalu-mulantha li-wulu ambuliyalu, ki-wabudawu kalu-mulantha...i wajkaliya, na-ruku barra na-mangaji na-lawarr, kalu-walima Jajiba wajkaliya lawarru linjikulinji-babalu, kala-nda baji, bawuji kalu-wani alanjilu. ");
INSERT INTO jao_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ngaliwa nya-mangaji nyiki-baba wirdi ki-Jujiba, Rubin, ka-mamarri ki-ngabiyala ngalalu li-mbangu li-wulu, likili-nganji ki-Yijmayil, li-mangaji nalarrku li-jibiya Midiyan, li-karingamalangu, li-mangaji barra kalu-rilirri karakarra nakari mayangka awara Kiliyad, kalu-rilirri. Kalu-wingkalwingkayaninya akarriya bajinju Kiliyad bayimanthalu yumbulyumbumantha awara baji, kalu-bayimanthaninya awara, kala-kalakanthaninya...i ki-wawinja ngamaliya...i, aya barra bajinju Yijiba, bawuji. Kalu-jilimanthaninya awara baji. Li-mangaji kalu-rilirri karakarra ngalalu likili-baba ki-Jujiba kalu-arri baji nyamba-wudurrumantharra, ngaliwa ka-mamarri wirdi Rubin, ka-mamarri ngabiyanthawu. ");
INSERT INTO jao_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kulu arrkula nyiki-baba, Juda na-wini, ka-arri alunga nuwalarrkulu, “Namba kambala-ramanjima nya-mangaji Jujiba, kambalamba-wajkirranjima nyuwu-mangajiwuthu ngulakari, kambalamba-wajkirranjima, minja kambala-waninjima ngamaliya winarrku bardabarda. ");
INSERT INTO jao_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","“Kulu ngambala, barni-ramantha nya-mangaji ngala ngambala-jilimaya aluwalu linji-mangajiwuthu linji-nganjinyu ki-Yijmayil, ngambala-jilimaya aluwalu mu-maniyu ngambalanga. Kalu-bayimala ngambalalu kulu kala-kala...i aya jujungku. Kala-kala...i aya bajinju Yijiba, jilimanthawu yilalu nyungku-mbangu barra, jilimanthawu barra baji juju angula. Nganambaji barra kambala-nmala, kurdardi kambala-ramarru nya-mangaji nyangambalanga-anyira, wurrbi nyangambalanga-anyira, ngambala-jilimaya nya-mangaji aluwalu linjikulinji-nganjinyu ki-Yijmayil mu-maniyu!” Kalinyamba-wukanyi li-mangaji likili-baba kulu kalu-ngayama wiji, alu jilimanthawu nyalunga-anyira nganinya. ");
INSERT INTO jao_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nyalalhurrku barra ngalalu nalarrku likili-nganji ki-Yijmayil kalu-wingka...i bajinju ngalalu likili-baba ki-Jujiba, kalu-rankarrma kariwajka, kala-ka aluwalu linjikulinji-nganjinyu ki-Yijmayil, kalu-jilima nyalunga-anyira, kalu-jilima aluwalu, kalu-jilima mu-maniyu. Kulu linjikulinji-nganjinyu ki-Yijmayil, kalalu-bayima ma-janyka ma-wurrirri ma-20-bala, kalu-rduma Jujiba mungku-ja barra bawuji. Kulu bawuji barra kalu-lhuwarri ngamaliya...i, kalu-lhuwarri naluyirdi yiku ki-Jujiba, kalu-wingkalwingka...i aya bajinju Yijiba. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ka-wani barra Rubin ngulakari, ka-lukulukuma nyala bajinju lawarru, karnila-kala kurdardi yiku ki-Jujiba, karnila-kala mili nularna-lawarr. Ka-rarri na-wurdu kurdandu, kulu kilu-ma jumbala nyikungu, kilu-ma jumbala kangka ka-rarri na-wurdu wakulamba, nganinya narnu-yuwa narnalunga. ");
INSERT INTO jao_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kulu ka-wani alanjilu aluwalu linjikulinji-anyiralu. “Marrirru, nganthiwa Jujiba nyangambalanga-anyira, nganthiwa? Ngandarra karna-nmala?” Ngala kalu-arri baji jakudi yiku, mili kalinyamba-wama. ");
INSERT INTO jao_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ngala nya-mangaji barra jumbala yiku ki-Jujiba, nya-mangaji marringaya kilu-ngunda nyiki-biyilu, baji ka-arri aluwa. Kulu kalu-rama kidikidi, kalu-rama kulu kalu-yibarra nya-mangaji jumbala yilirrinja ki-kidikidiyu. “Kambala-arrila wunyathawu yiku, katha kambala-wakarama jinangu jumbala wumbiji yabala, katha kila-tha ki-wardalinju.” ");
INSERT INTO jao_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kulu kalu-wani ngamaliya barra bawuji yilalu ki-malbungku ki-Jikaba naluyirdi jumbalawu yiku ki-Jujiba. Kalu-wingka bajinju yilalu, kulu kalu-mirnima nya-mangaji jumbala nyuwalunga-biyiyu, kulu kalu-warndima yiku, “Biyi! Ngandarra jinangu jumbala yilirriwiji kanu-nirri wumbiji? Jinangu nyikungu nyinki-arduwu?” ");
INSERT INTO jao_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kulu kilu-lhaa ki-malbungku. “Yiya, jinangu jumbala jarna-lhaanji nyikungu nyungathi-arduwu ki-Jujiba. Kila-tha nungka ki-wardalinju baji wumbiji. Kilu-ma na-manka nyangathi-ardu marlijinda, kilu-ma na-manka ki-wardalinju, kila-tha. Warriya luku nyangathi-ardu.” Kalu-warndima kurdandu. ");
INSERT INTO jao_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kulu ka-wardirri barra malbu na-wurdu nyiki-arduwu. Ka-rarri na-wurdu kurdandu. Kilu-ma jumbala nyikungu kangka ka-rarri na-wurdu wakulamba, kulu kumba-yulyulba nyarrku wardi jumbala rarrinjarra yiku, nganinya narnu-yuwa narnalunga. Kurdandu barra ka-rarri...i yurrngumantha nyiki-arduwu ki-buringku. ");
INSERT INTO jao_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kalu-wingkalwingka yilalu ki-malbungku likili-ardu wiji. Kalu-wingkalwingka yilalu yabimanthawu na-wurdu yiku ki-Jujiba ngala minja kalinyamba-ayayanu. Kumba-ngarrarnma alunga, alu yabimanthawu na-wurdu. Ka-arri, “Baku karna-wingkala nambinju, karna-lhakanbala ki-awaralu nyungkalunga liyi-ngabangakuwu, karna-wingkala bajinju nyala rarrinjarra ngarna-wurdu yiku nyungathi-arduwu, warriya luku nyangathi-ardu buyi.” Kulu nganinya barra ka-rarrinjaninya...i na-wurdu yurrngumantha, ka-rarrinjaninya na-wurdu nyiki-arduwu ki-buringku. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nya-mangaji Jujiba, karakarra kala-ka linji-wulungku linjikulinji-nganjinyu ki-Yijmayil, nakaringu ki-awarala Kinin kala-ka, jibiya Kinin ka-arri nya-mangaji, kala-ka bajinju Yijiba juju angula. Kulu nya-mangaji alka, wirdi alka yiku ki-king, na-wini alka Budiba, kilu-bayima Jujiba baji Yijiba. ");
INSERT INTO jao_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kulu ka-arri jawina barra jinangu Jujiba, nyikungu jawina ki-Budiba. Ka-arri jabungka yiku yurrngumantha baki ka-arri walkurr ki-barrawula ki-Budiba marda. Wirdiwalangu Kada ka-arri yilaa ki-Jujiba yurrngumantha. Ngaliwa Jujiba ka-arri waki ngaliwa kilu-yabima nya-mangaji awara yiku ki-Wirdiwalangu ki-Kud. Marringaya awara barra ka-arri wumba ka-arri jabungka baji Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","4","Kila-nganthaninya ki-Budiba, jinangu Jujiba kiwa-ninya jabungka kalngi yabi. Kilu-lhaa kalngi marringaya jinangu, ka-ngayama yiku, kulu baku barra kilu-yibarra ki-Budiba yiwa nganthawu alunga, kilu-yibarra wirdi ngulakari yilaa, kangka kilu-lhaa jinangu Jujiba ki-Budiba, Wirdiwalangu Kud ka-arri yilaa ki-Jujiba kulu kilu-yabima awara yiku baji barra. ");
INSERT INTO jao_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bajingu kilu-mirlirlmirlirlma awara baji ki-Wirdiwalangu, kilu-yabima barrawu arndaarnda baki awara lukuluku badiki winkanda, kilu-yabima wiji kangka ka-arri baji Jujiba, wirdi nganthawu li-jawina ki-Budiba baji ki-awarala wiji. ");
INSERT INTO jao_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kulu Budiba, kumba-wudurruma kulu ka-lhuwarri jabuwu, ngala Jujiba ka-arri jirrinymantharra ki-awarawu wiji, kilu-yibarra ki-Budiba wirdi alunga liyi-wuluwu wiji, wirdi ki-awarawu wiji Kulu kala-kala Jujiba linji-wulungku, “Kalngiya marringaya jinangu mirningiya, ndiwa marringayangurru, yabiyanyka!” ");
INSERT INTO jao_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kulu rra-mangaji, riku-wangu ki-alkawu ki-Budiba, kanda-ninya baji ki-barrawula yukulyukumantharra awara. Kanda-nganthaninya jinangu barra Jujiba, kanumba-wukanyi nanda-wurdu, “Nya-marringaya, nya-yabi nya-ja, nya-rlikarlika!” Kulu bajingu kandu-mijanga barra kandu-mijanga kulu nungkarnarrku barra kandu-yalbanga jinangu Jujiba wula walkurru. “Kali-nmala walkurr!” ");
INSERT INTO jao_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngala yiwa Jujiba, kumba-ngarrarnma anku, ka-wukanyi anku, “Ngabiyarra! Waraba karni-biyarru walkurr yindaa kangka karnili-yibarra jabungka marnaji yiwa nyungkinku-wangu. Karnili-yibarra ngarna wirdi marnaji ki-awarawu wiji. ");
INSERT INTO jao_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ngarna wirdi barranamba yiwa wirdi marnaji. Ngayamantharra yinda ruthuruthu yiku rriku-wangu jirnilu-ningumanji ngatha. Kulu kurdardi barra karna-wardimarru wakulamba awara yiku. Kulu kurdardi mili karna-wardimarru wakulamba yiku awara ki-Yijanku ki-Kud.” ");
INSERT INTO jao_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Barra yurrujurru kandu-yalbanganthaninya jinangu Jujiba, kandu-yalbanganthaninya wula walkurru miyilmiyil, ngala ka-ngajbirri anku, kumba-milmirilangu anku, wakangu barra ka-arri. ");
INSERT INTO jao_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ngala baku, ka-ngalba ki-barrawula wakilu kulu waraba alunga nuwalarrkulu liyi-jawinawu, ka-arri baji arrkula yiwalumba. ");
INSERT INTO jao_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kulu kanda-arri ndiwi barra manhanthawu yiku, “Kali-nmala walkurr kangka kurdardi alunga!” Kanda-ayayanu manhanthawu yiwa. Kandu-manhu nyala jumbala yilaa ngala yiwa ka-wuluma, ka-wuluma winkandu yarlajka, ngala minja nya-mangaji jumbala kila-nda wambu marlijinda andaa barra. ");
INSERT INTO jao_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ngalanda kanda-kala jumbala nyikungu marlijinda andaa kulu Jujiba wulumantharra winkandu, ");
INSERT INTO jao_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ngalanda kanda-wajba alunga liyi-jawinawu, lankungu. “Marrirru! Kawayi! Nya-karra jinangu jumbala, nyikungu ki-Jujiba. Wardimbangu nya-mangaji. Nya-ja barra nya-Yiburu wumba kanyila-ka marnajinju nyungathanyu-wangungku, jilu-wardimanji awara ngambalanga nyungku-ja. Yiwa kiwa-ngalba arndaarndalu marnajinju kulu kumba-ayayanu nmanthawu majkarra ngathangka ngala ngarna karnamba-yiwama. ");
INSERT INTO jao_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Karnamba-yiwama kurdandu, kulu kiya-wuluma winkandu,” nganinya kanda-arri. Kandu-warndima anda kurdandu alunga. ");
INSERT INTO jao_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kulu kandu-manha nya-mangaji jumbala nambalu lhurrku wumba ka-wani nyanku-wangu Budiba, nya-mangaji wirdi nyikungu ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kandu-mirnima barra yiku nya-mangaji jumbala kulu kandu-warndima nganambajilulu yiku, “Ngabinya! Kabu nya-karra jinangu jumbala. Kiya-wingka ngathangkalu nya-mangaji nya-Jujiba, nya-mangaji nya-Yiburu wumba kinya-kanhu marnajinju, yiwa kiya-wingka. Kulu karnilu-yalbanga ngatharra katharra-nmanma walkurr, ");
INSERT INTO jao_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ngala ngarna, karnamba-ngarrarnma yiku kulu karnamba-yiwa yiku, karna-wardanka. Kulu kilu-murdirri barra jinangu jumbala, kila-nda ngathangka kulu kiya-wuluma winkandu.” ");
INSERT INTO jao_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Jinangu barra, ka-wardirri na-wurdu barra ki-Jujiba marda barra ka-yinjathirri kalngiya yiku, kangka kandu-warndima kurdandu rrungkiku-wangu, kandu-warndima kurdandu. ");
INSERT INTO jao_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kulu kalili-jirrinyma, kalu-yibarra Jujiba baji ki-burijin, ki-burijin alunga liyi-mbangu wumba kalu-wardima awara yiku ki-king, baji aluwa ka-arri Jujiba, rdirrirrantha barra arndaarnda. ");
INSERT INTO jao_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kulu bawuji barra ka-arri arndaarnda yurrngumantha jinangu Jujiba. Ngala ka-arri Wirdiwalangu Kud yilaa, ka-yabirri na-wurdu yiku ki-Jujiba baji, kilu-manmarralanganthaninya yurrngumantha, kulu kilu-yabima awara baji arndaarnda yiku ki-Jujiba, kilu-yabima marda wirdi ki-burijin, kilu-yabima na-wurdu, yiwa ngayamanthawu yiku ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kulu baji wumba kalilu-yukumanthaninya li-ja li-wulu arndaarnda jina mirningiya wirdi, kila-kala jinangu Jujiba kalngi marringaya ka-arri baji aluwa, baji barra kiwa-ninya yurrujurru, kulu kila-kala barra nyungku-ja ki-wirdinju kulu ka-wukanyi yiku ki-Jujiba, “Ngarna wirdi kalirna-yukumanji nganthawu awara ngala yinda jirna-yibarranji ngulakari ngathangka, yinda ngalanganthawu li-wulu lukuluku marnaji arndaarnda.” ");
INSERT INTO jao_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Namba kili-jirrinyma Jujiba ki-wirdinju kulu ka-ngayangayarri yiku jinangu Jujiba. Ka-arri yabi yiku, yukumantharra awara wiji. Kila-nda Jujiba kalngiya wirdi kangka Wirdiwalangu Kud ka-arri yilaa ki-Jujiba, yabimanthawu awara barra yiku, mirlirlmirlirlmanthawu awara wumba ka-arri jabungka barra baji jinangu Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kulu baku ngulakari arndaarnda kawula-arri rri-mbangu, kawulalu-walima mirningiyawujara rri-jawina rri-wirdi nyiku ki-wirdiwalangu ki-king, nya-mangaji king alunga liyi-jibiya Yijiba. Kulu jina nyarrku wirdi kulkurdanthawu wabuda yiku ki-king ngala jina nyarrku wirdi mu-ngarranku yiku ki-king. Kawula-wardima awara yiku ki-king, ");
INSERT INTO jao_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","kulu rriyiku ka-yinjathirri wulanga rriyi-ja rriyi-wirdiyu. ");
INSERT INTO jao_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kawulili-ja bajinju nmanthawu rdirrirrantha barra, kawulili-ja yilalu ki-wirdiyu ki-burijin, nya-mangaji burijin wumba Jujiba ka-arri baji. ");
INSERT INTO jao_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kulu nyungku-ja ki-wirdinju, kawulila-ka yilalu ki-Jujiba kulu yiwa barra yukulyukumanthawu awara wulanga marda. Kila-ka ma-ngarra wulanga, kila-ka wabuda wulanga, kawulilu-kunkunma baji...i yurrngumantha ngalawula kawula-arri baji. ");
INSERT INTO jao_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kulu baji barra, wundururra barra, kawula-mawuranga awara, rri-ja jawinawujara yiku ki-king. Kawula-mawuranga awara ruthuruthu yiku nyuwarrkulu baki yiku nyuwarrkulu. ");
INSERT INTO jao_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kulu yalibala kawula-lhuwarri wardirrinjarra nawula-wurdu, nyamba-rarrinjarra nawula-wurdu kangka kurdardi kawula-nykarrinma nya-mangaji wumba kawula-mawuranga. Kulu ka-wingka Jujiba yalibala barra wulalu, kulu rri-ja barra kanymardawujara rri-jawina wardirrinjarra nawula-ngurru. ");
INSERT INTO jao_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kulu kawulilu-yalbanga ki-Jujiba, “Marrimbala! Ngandarra jimbala-wardirrinji nimbala-wurdu? Ruthu nimbala-ngurru jimbalirna-nganji.” ");
INSERT INTO jao_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ngalawula kawula-arri yiku, “Katharramba-mawuranga wundururra narnu-ngabiya, kulu marningatharra rri-manji nuwu-mangaji. Kulu kurdardi nganinju katharrilu-yunduyundumarru jina wuka, kurdardi yiku marnaji.” Kulu ka-arri wulanga Jujiba, “Nganhimbali-naya kimbala-mawuranga kangka mamiwa Kud jiwini ngathangka kalngi yijan, yiwa mirdan jinawuthu mawuranganthawu, kulu yiwa ki-Kud kilu-yunduyundumala ngatha jinangu awara barra wumba kimbala-mawuranga.” ");
INSERT INTO jao_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kulu yiwa barra ambuliyalu nyungku-ja, wirdi kulkurdanthawu wabuda yiku ki-king. Kulu kili-nu barra narniku wumba kilu-mawuranga. “Ngarna, karna-mawuranga na-mbangu narnu-walawala karnu-arri, ");
INSERT INTO jao_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","narnu-yala ankangu karanka na-kanymarda arrkula. Kulu ka-wurlma wanjirr, ka-wurlma wulanthantha karna-kala. Bajingu kurna-kala nu-wulaya ma-mangaji ma-kuriba, ku-wunhunhurri. ");
INSERT INTO jao_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kulu ka-arri banikin marlijinda ngathangka, nya-mangaji baji yabi barra nyiku ki-king. Bajingu kurna-jabuma karanka ma-kuriba kulu kurna-burrujulma nu-ngiliny wajkaliya banikindu, kulu karna-ngunda king, karna-yibarra banikin marlijinda yilaa. Nganinya barra karna-mawuranga.” ");
INSERT INTO jao_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kulu Jujiba barra ka-wukanyi yiku, “Jinangu wumba kinyu-mawuranganhu, jinangu yunduyundumanthawu awara yinku nganinya. Na-mangaji na-kanymarda arrkula karanka, jinangu barra Yijan Kud ja-wukanyinji na-kanyraarda arrkula na-wunbarr. ");
INSERT INTO jao_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kumba-yangamala na-wurdu king, ka-yabirrila yinku barra na-wurdu, kulu baku, na-kanymarda arrkula na-wunbarr kirnili-nmala kulu ka-wingkala winkandu. Ka-wanila barra bajinju yilalu, kinya-kalakanthanama wabuda barra nguthalimanthawu yiku ki-king. Jinangu barra yinku kinyu-mawuranganhu.” ");
INSERT INTO jao_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kulu mili ka-wukanyi yiku Jujiba, “Ngala minja kanha-linginmala namba yinda ka-wanila ki-king yilalu, kirna-barlirra, kulu kanhi-nala yiku ngarna wingkayawu winkandu, ");
INSERT INTO jao_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","kangka winarrku karakarra kamalu-rduma nakaringu nyungku-nganunga ki-awarala, nganunga liyi-wuluwu liyi-Yiburu, kulu karnala-ka marnajinju. Kulu mili winarrku barra karnilu-yibarra rdirrirrantha arndaarnda winarrku, kurdardi karna-wardimanma awara. Nganinya kanhi-nala yiku ki-king, kirna-barlirra.” ");
INSERT INTO jao_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kulu bajingu barra, yiwa nyarrku barra, jina wirdi mu-ngarranku yiku ki-king, kila-nykarri wukanyinjarra yiku nyuwarrkulu, yunduyundumantharra yiku narnu-yabi. Ka-arri yiku ki-Jujiba, “Kulu marningarna, ngarna barra karna-mawuranga awara. Kurna-kanthaninya wulala ngathangka ma-mbangu, ma-minini ma-kanymarda arrkula ma-mangaji, nu-lhangka ma-ngarra arndaarnda, yumbulyumbumantha ma-ngarra wumba kalu-wuba. ");
INSERT INTO jao_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kulu julaki barra, ka-wabama bajinju ngathangkalu wulalu kulu ankaya. Kumba-wudurrumanthaninya ma-mangaji ma-wunhunhu ngathangka wulala, kumba-wudurrumanthaninya ma-mangaji mungka-mininila wumba kurna-rduma yiku ki-king.” ");
INSERT INTO jao_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kulu Jujiba yiku ka-wukanyi, kili-nu barra, “Jinangu wumba kinyu-mawuranganhu, jinangu yunduyundumanthawu awara yinku nganinya. Ja-wukanyinji jinangu wuka yinku Yijan Kud. Ma-kanymarda arrkula ma-minini, na-kanymarda arrkula na-wunbarr. ");
INSERT INTO jao_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nya-mangaji king, kalili-nala yinku, ka-wingkala winkandu-ngala kirnalu-marra nda-ngunduwa, ka-nbala na-wulaya, kalali-nala nganinya. Kirnalu-yibarrala na-manka arrijila ki-wurndaa, baku na-kanymarda arrkula na-wunbarr. Kulu nya-mangaji julaki kumba-wudurruma ma-mangaji ma-ngarra, marda yinda barra kumba-wudurrumala yinku, nyungku-mangaji ki-julakinda.” Nganinya barra ka-arri yiku Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kulu baku barra, na-kanymarda arrkula na-wunbarr ngalarnu na-mangaji wumba ka-yanjarri wabarrangu king barra bajingulaji, winarrku ka-arri mingkiya bumantharra wirdiwalangu king, alu rarrmanthawu ma-ngarra, nyamba-lhawarrmanthawu yiku. Kulu kalili-ja barra likungu li-jawina ki-king, rdumanthawu barra rri-ja kanymarda mirningiyawujara. ");
INSERT INTO jao_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kulu jinangu barra, wirdi kulkurdanthawu wabuda yiku ki-kinga, kilu-waninjanguma ki-king barra bajinju yilalu. Kili-yibarra mili banikin marlijinda yilaa ki-king, yiwa wunjayawu. ");
INSERT INTO jao_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ngala jinangu nyarrku barra, wirdi mu-ngarranku yiku ki-king, kila-kanthaninya, kalu-yibarra arrijila ki-wurndaa, kulu kalu-rama barra, kalu-ma na-ngunduwa, bawuji. Nya-mangaji wuka wumba ka-wukanyi yiwa Jujiba kilu-yunduyunduma awara, nganambajilulu barra ka-ngabiya awara wulanga. ");
INSERT INTO jao_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ngala nya-mangaji nyarrku, ngaliwa ka-arri yilaa ki-king mili yurrulu, ngala minja kilu-murdirri kurdandu jinangu Jujiba, kurdardi mili kilu-linginmanma. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ka-arri Jujiba arndaarnda bajingulaji, kanymarda lhabayi ka-arri arndaarnda. Kulu bajingu barra kilu-mawuranga ki-king awara. Karnila-kala na-ja na-wulangi na-walkurra, karnalu-wundarrba na-wulangi narnu-wini Nayil. Kumba-mawuranga alarrinjarra nungku-ja nungku-wulanginda. ");
INSERT INTO jao_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kila-kala a-kawurna a-kanymarda kulu rra-kanymarda kulu rra-kanymarda arrkula, a-ja barra a-kawurna kalngi rra-yabi a-manynguliji. Kalu-walalanyma barra kariwajka nakaringu wulanginda, ankaya barra nyamba-wudurrumantharra yarla wujurl. ");
INSERT INTO jao_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kulu mili yurrulu kila-kala a-kawurna a-kanymarda kulu rra-kanymarda kulu rra-kanymarda arrkula, a-ja barra a-kawurna kalngiya barra a-wardi, a-ngurlingurli. Rra-ja barra rra-ngurlingurli, kanda-walalanyma kariwajka nakaringu wulanginda bajinju rungkarrkulu marda, yiwirra kanda-arri. ");
INSERT INTO jao_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Karranda-tha wiji a-ja a-manynguliji, karranda-tha rrungku-ja rrungku-ngurlingurlilu. Bawuji kulu jinangu wirdi, king, kumba-yarraka walkurrngu. ");
INSERT INTO jao_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kulu mili yurrulu kumbi-ja wajkaliya walkurru, kulu mili yurrulu kilu-mawuranga awara. Kilu-mawuranga barra ma-ngarra barranamba ma-kingkirra. Kila-kala arrkula wurnda ankaya kulu nyungku-ja ki-arrkulangka ki-wurndaa yilaa na-yala ku-yirdardi ma-ngarra, ma-kanymarda kulu ma-kanymarda kulu ma-kanymarda arrkula. Kila-kala barra, ma-yabi, ma-marringaya ku-yirdardi nu-manka. ");
INSERT INTO jao_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kulu ngulakari mili yurrulu kila-kala ma-ngarra nyungku-ja ki-arrkulangka ki-wurndaa ku-yirdardi ma-ngarra. Ma-ja barra ma-ngarra ngulakari ma-wardi, ma-ngurlingurli, ma-rukarra kangka jinangu lhambiji walkurra ka-warrmanthaninya karakarra kulu kilu-rukarrama ma-ja ma-ngarra ma-ngulakaringu. ");
INSERT INTO jao_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kulu kilu-ja barra ma-ja ma-ngarra ma-mbangu ma-marringaya mungku-ja mungku-ngurlingurlilu, bawuji. Kulu ka-walanyma nakaringu walkurrngu kulu kumba-wukanyi na-wurdu, “Ayi! Minja karna-mawuranga awara.” ");
INSERT INTO jao_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kulu yalibala barra ka-wardirri na-wurdu barra jinanguwuthu barra awarawu kilu-mawuranga. Kulu kumbi-ja na-mulu aluwalu barra nungkalarrku linji-wulungku linji-mankarninju, alu wiji ki-awarala ki-mayangka Yijiba. Kulu linji-ja linji-mankarnilu, kurdardi kalu-lhaanma jinangu wumba kilu-mawuranga, kurdardi kalngiya kalu-lhaanma. Li-manji kalu-arri wiji yunduyundumanthawu awara yiku ki-king wumba kilu-mawuranga. ");
INSERT INTO jao_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kulu nyungku-ja ki-mirningiyalu, kila-kanthaninya wabuda yilalu ki-king, kilu-linginma barra nya-mangaji Jujiba barra, kilu-linginma. “Yuwu! Wirdiwalangu! Ngarna barra murdu. ");
INSERT INTO jao_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wabarrangu ka-yinjathirrinyu ngatharranga, ngatharra nya-mangaji nyarrku nyinkungu wumba wirdi mu-ngarranku kiwa-ninya, ka-yinjathirrinyu kulu katharrinyi-janhu bajinju ki-burijin, katharra-arri rdirrirrantha baji arndaarnda. ");
INSERT INTO jao_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kulu katharra-mawuranga awara, ngatharra barra bajingulaji wundururra. Kilu-mawuranga ruthuruthu yiku baki ngarna karna-mawuranga ruthuruthu ngatha, nya-mangajiwuthu kanymarda yunduyundumanthawu awara ngatharranga. ");
INSERT INTO jao_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Katharra-arri manji nyuwu-mangajiwuthu ngala ka-arri baji nganuwa arrkula yalkuyi, karakarrangu Yiburu nya-mangaji na-wini Jujiba, jawina yiku ki-wirdiyu ki-burijin. Ngalingatharra katharri-nu awara yiku wumba katharra-mawuranga kulu yiwa barra, kalngiya karnilu-yunduyunduma ngatharranga narnu-yuwa. ");
INSERT INTO jao_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kulu ngarna, kinyu-waninjangumanhu marnajinju yindalu, kirna-barlirra wirdiwalangu, kinyu-waninjangumanhu barrabaji kilu-yunduyunduma nya-mangaj iwuthu yinda waninj angumanthawu. Kulu yiwa nyarrku, kalu-rama, kalu-yibarra arrijila ki-wurndaa barrabaji kilu-yunduyunduma nya-mangaj iwuthu bajarnaji yiku nyungku-mangaji ki-Yiburu na-wini Jujiba, nganinya barra.” ");
INSERT INTO jao_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kulu ki-king, kalili-ja yarlajka rdumanthalu yilalu ki-Jujiba. Kulu kali-nma Jujiba kariwajka, kulu kumba-wurrkurrba jamuka yiku, kulu kalu-ngunda rlikarlika jumbala yiwa nyamba-yulyulbanthawu, kulu bawuji ka-wingka yilalu ki-king. ");
INSERT INTO jao_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kulu king, ka-wukanyi yiku ki-Jujiba, “Karna-mawuranga awara ngala kurdardi alunga nanthawu awara ngatha. Ngala minja karnili-nu ki-jawinalu yinku, ‘Nya-mangaji Jujiba, namba kila-nykarrila ki-almirawu kulu kilu-yunduyundumala.’” ");
INSERT INTO jao_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ngala Jujiba kumba-ngarninyma yiku, “Wirdiwalangu! Waraba ngarna mirdan nyu-jawuthu ki-awarawu, ngayamantharra yiwa ki-Yijandu nyungku-ngatha, ki-Kud. Yiwa barra jarnili-nanji, ngarna yunduyundumanthawu awara yabi.” ");
INSERT INTO jao_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kulu king barra, kilu-wirijkalma awara barra bajarnaji wumba kilu-mawuranga ambuliyalu, nganinya ka-arri yiku, “Nganinya karna-mawuranga, ambuliyalu karna-kala. Karna-alarri yiwirra wulanginda ki-Nayil. ");
INSERT INTO jao_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Karna-kala kariwajka nakaringu wabudala rra-kawurna rra-kanymarda kulu rra-kanymarda kulu rra-kanymarda arrkula, a-ja barra a-kawurna kalngiya rra-marringaya a-manynguliji. ");
INSERT INTO jao_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kulu bajingu ngulakari karrarna-kala mili a-kawurna rra-kanymarda kulu rra-kanymarda kulu rra-kanymarda arrkula, a-ja barra kalngiya a-wardi a-ngurlingurli Kurdardi nganinya karrarna-nganma wabarrangu ngala aliyaliya barra, karna-ruwama. ");
INSERT INTO jao_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kulu rrungku-ja rru-ngulakaringu rru-kawurnalu, kanumba-wudurruma a-ja rra-manynguliji wiji, ");
INSERT INTO jao_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","kulu nyala bajanda a-mangaji a-ngurlingurli a-kawurna. Kulu bajingu karna-lhuwarri nakaringu walkurrngu. ");
INSERT INTO jao_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Kulu mili yurrulu karnambi-ja wajkaliya walkurru, kulu mili yurrulu karna-mawuranga. Karna-kala wurnda ankaya ka-yirdardi walkurra nayirdi mu-ngarranku yilaa na-yala barra ma-kanymarda kulu ma-kanymarda kulu ma-kanymarda arrkula, ma-yabi barra ma-marringaya ku-yirdardi nu-manka. ");
INSERT INTO jao_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kulu nyungkulu-mangaji ki-wurndaa ku-yirdardi ma-ja barra ma-wardi ma-rukarra, ma-kanymarda kulu ma-kanymarda kulu ma-kanymarda arrkula. Kurdardi kalngi ku-yirdardinma nu-manka kangka walkurra lhambiji ka-warrmanthaninya karakarra yurrngumantha, kulu kilu-rukarrama ma-ja ma-ngarra ma-ngurlingurli ma-ngulakaringu. ");
INSERT INTO jao_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kulu mungku-ja mungku-wardinju mungku-ngarrandu, kilu-rarrma ma-ja ma-wurrirri ma-ngarra wiji, kinyamba-wudurruma wayathantharra. Bawuji barra. Kulu karnambi-ja ngarna-mulu alunga liyi-ja liyi-mankarniyu, kalu-wingka ngathangkalu marnajinju, kulu jinangu wuka wumba karna-mawuranga karni-nu alunga ngala kurdardi kalu-lhaanma awara, nyala marningarna manji.” ");
INSERT INTO jao_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kulu Jujiba, ka-wukanyi yiku ki-king, “Jinangu kinyu-mawuranganhu ambuliyalu kanymardawu, jinangu wuka kinyu-mawuranganhu arrkula, nganinya barra ja-wukanyinji jirnili-nanji ki-Kud ki-Yijandu. Jirnilu-yunduyundumanji baku ngulakari barra ngandarra kilu-arrila nyungku-ja ki-Yijandu. ");
INSERT INTO jao_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Jinangu ambuliyalu kinyu-mawuranganhu rra-kawurna rra-kanymarda kulu rra-kanymarda kulu rra-kanymarda arrkula, rra-mangaji rra-manynguliji, kulu ma-ja mili ma-ngarra ma-yabi ma-marringaya ma-wurrirri, ma-kanymarda kulu ma-kanymarda kulu ma-kanymarda arrkula, jinangu barra jili-nanji lhabayi. ");
INSERT INTO jao_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Kulu rra-ja rra-kawurna rra-ngulakaringu ka-mawuranganhu rra-wardi rra-ngurlingurli kulu ma-ja mili ma-ngulakaringu ma-ngarra ma-wardi ma-rukarra, kurdardi kalngi ku-yirdardinma nu-manka, ma-ja ma-kanymarda kulu ma-kanymarda kulu ma-kanymarda arrkula, jinangu barra ngulakari kurdardi ki-lhabayiyu, marnarnaji barra ngulakari kalngiya narnu-wirndajku. ");
INSERT INTO jao_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Kirni-nu barrungku, kulu kalngiya barra, jirnili-nanji barra ki-Kud, jirnili-nanji awara ngandarra kilu-arrila baku. ");
INSERT INTO jao_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Marningu barra, jinangu lhabayi barra kiwa-nbayama kalngiya barra ka-yirdardila wudurru wakulamba, lhabayi barra kanymarda kulu kanymarda kulu kanymarda arrkula, jinangu barra maya awara, mayangka ka-yirdardila barra wudurru ngayamantharra nyungku-ja barra ki-lhabayila. ");
INSERT INTO jao_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ngala bajarnaji ngulakari kinyu-mawuranganhu kanymarda kulu kanymarda kulu kanymarda arrkul wardi lhabayi kiwa-nmala, kurdardi ka-yirdardirru wudurru ki-lhabayila nyungku-ja ngulakari, kalngi wirndajku barra kiwa-nmala awara, rukarra awara kiwa-nmala, kurdardi ki-wabudawu. Kulu li-wulu, kalu-murdirrila barra awara mu-ja barra mu-ngarranku ambuliyalu wumba ma-jakarda. ");
INSERT INTO jao_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kalu-murdirrila barra bajarnaji wumba ku-yirdardi kurdandu ma-ngarra, wudurru jakarda ka-arri, kalu-murdirrila, kangka ngulakari ka-nmala wirndajku...i awara, wirndajku, bardabarda ki-wudurruwu, ruku awara narnu-wardi alunga. ");
INSERT INTO jao_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“Kulu kinyu-mawuranganhu nganinya kanymardawu kangka kalngiya barra jirnili-nanji ki-Kud. Jirnili-nanji nganinya ki-Kud, kulu nyalalhurrku kili-jala lhabayi, kiwa-nbayanama...i bawuji, kulu ngulakari kilu-ningumanthanama wabuda, kurdardi kiwa-nbayarru, ka-rukurrila awara...i bawuji. Nganambajilulu kilu-arrila ki-Kud kulu nganinyanga jilu-yunduyundumanji awara yinku. Kirnilu-ngunda yinda mawuranganthawu kanymardawu kangka jina wuka kalngiya barra nakaringu yilaa ki-Kud. ");
INSERT INTO jao_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Bajuwarnu, wirdiwalangu, yinda barra rdumanthawu nyarrku marringaya wirdi, kalngiya mirdan, yiwa anmanthawu wirdiwalangu nyuwu-ja ki-awarawu ngulakari yindaa, ");
INSERT INTO jao_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","kulu yinda rdumanthawu nalarrku li-wirdi mu-ngarranku, alu yibalyibarranthawu arndaarnda rdalbirranthawu nuwarrku ma-ngarra barra. Nuwarrku ma-jakarda kalu-rarrmala li-wulu kulu nuwarrku kalu-rdulurdumala linji-wulungku, yibalyibarranthawu. Kiwa-nmala barra wudurru walkurra barra baji, marda bajiwuthu winkanda nyungkarrku ki-barrawula, alu barra yibalyibarranthawu wudurru nganinyanga, alunga barra wiji nyungku-ja ki-mayangka. ");
INSERT INTO jao_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Arndaarnda barra kuwa-nmala ma-ngarra kurdandu, kulu yinda barra wirdiwalangu muwu-mangaji mu-ngarranku wiji. Kalu-yibalyibarranthanama yinku linji-mangaji wumba kalinyi-yibarrala, kalu-marakamanthanama ma-ngarra nganambaji, kalu-yukumanthanama baji. ");
INSERT INTO jao_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","“Kulu bajuwarnajiyu ngulakari baku barra bajarnaji barra narnu-wirndajku ngulakari kalngiya barra, ngala nganinyanga barra kuwa-nmala ma-ngarra ndiwi arndaarnda, kuwa-nmala barra baji, ma-maraka barra. Baku barra nganinya kulu kurdardi kalinyamba-yarrbarru wudurruwu, kurdardi kalinyamba-mirrarru wirndajku, ngala kalinyamba-wudurrumanthanama yamulu ma-mangaji, alu li-wulu wiji. Bawuji barra, wirdiwalangu.” Jujiba, karnilu-wayatha bajarnaji jinangu wuka wumba ka-wukanyi yiku ki-king. ");
INSERT INTO jao_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ngala king, kila-nykarri kulu ka-ngayama wakulamba marda li-mangaji wumba kalu-arri baji li-jawina, kalngiya kalu-yabirri nalu-wurdu yiku ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kulu king, ka-arri alunga nuwalarrkulu liyi-jawinawu, “Kurdardi karna-nganma barra nganinya mirningiya barranamba yiwa, kalngiya wunungu, kalngiya mingkin, kalngiya Yijan Kud Na-ngawulu jiwini yilaa mankanda,” nganinya barra kumba-lhawarrma. ");
INSERT INTO jao_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kulu ka-arri yiku ki-Jujiba, “Kulu yinda barra kalngiya mirdan, kurdardi nyuwarrkulu barranamba yinda ngala yinda kalngiya mingkin, kangka Yijan Kud kirnili-nu nyuwu-ja ki-wukawu, nganu yibalyibarranthawu ma-mangaji ma-ngarra. Kulu jirna-lhaanji barra kangka yiwa Yijan Kud jirnilu-ngundayi marnarnaji wuka narnu-yabi narniku. ");
INSERT INTO jao_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kulu yinda barra ka-nmala wirdi ngathangka wukalwukanyinjawu alunga liyi-jawinawu ngalalu jabungka, kulu li-wulu wiji, kalu-ngayangayamala yinku. Ngayamantharra ngarna ambirriju wirdi yinku, ngala yinda ngulakari ngathangka. ");
INSERT INTO jao_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ka-nmala wirdi lukuluku ki-barrawula ngalangantharra awara ki-mayangka Yijiba wiji,” nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kulu ki-king kili-nma ring nakaringu marlijinda yilaa, nya-mangaji barranamba ma-rilkarra, kili-nma kulu kilu-yibarra yilaa ki-Jujiba marlijinda, ngayamantharra alunga liyi-mangaji wumba kalu-arri li-wirdiwalangu wurrbi, jinangu ring. Kulu jumbala marringaya kalngiya kilu-ngunda Jujiba, kulu nya-mangaji barra marringaya yibarranthawu ngunduwala aluwa linji-wirdiwalangu, kilu-yibarra yilaa ki-Jujiba ngunduwala. ");
INSERT INTO jao_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kilu-ngunda mili wilbarra kulu wawi, nya-mangaji nyikungu niwarrku, kilu-ngunda nya-mangaji wilbarra wumba kalu-lhaa linji-wulungku wiji, kala-kala kulu jalu-wajba, “Nirru-wilalamaya! Wirdiwalangu marniwa!” Nganinya barra ki-king kili-yibarra Jujiba kalngiya wirdiwalangu alunga liyi-wuluwu mura. ");
INSERT INTO jao_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kulu ka-arri mili king, “Ngarna king, ngala yinda Jujiba jirna-ngundayi wuka anmanthawu wirdi alunga wukalwukanyinjawu liyi-wuluwu. Kalinya-jirrinymala kulu kala-kala yinku wuka, kalu-ngayangayarrila yinku, kurdardi kalu-ngajbirriyu yinku, yinda wirdiwalangu walkurrawala.” ");
INSERT INTO jao_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kulu kilu-wundarrba na-wini Yijibangala Jabinibaniya, kulu kilu-ngunda a-nhanawaya riku-wangu, nanda-wini rra-Ajinada, a-mangaji barra yikurra-ardu ki-Budibira, yiwa barra nyanki-biyi ka-arri mingirringki nyu-jawuthu Yijanku, baji ki-barrawula ki-Wuna, yikurra-ardu a-Ajinada kilu-ngunda ki-king, anda anmanthawu riku-wangu ki-Jujia. Bawuji barra, nganinya ka-wingkayaninya Jujiba barra, wirdiwalangu ki-awarawu Yijiba, kalu-lhaanthaninya nya-mangaji kalngiya wirdiwalangu. ");
INSERT INTO jao_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jujiba ka-lhuwarri nakaringu yilaa ki-king, ka-lhuwarri bajingu lukuluku ki-awarala ki-mayangka. Na-yalkuyi barra na-30-bala ka-arri ngaliwa ka-arri jawina yiku ki-king jabungka. ");
INSERT INTO jao_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nya-mangaji lhabayi, jinangu barra kiwa-nba marringaya, kanymarda kulu kanymarda kulu kanymarda arrkula lhabayi, ka-yirdardi barra wudurru barra wakulamba. ");
INSERT INTO jao_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kulu ka-wingkalwingka jinangu Jujiba nyungkarrku ki-barrawula kulu nyarrku barrawu, lukuluku nyungku-ja ki-mayangka Yijiba, ka-wingkalwingka rdumantharra ma-ngarra. Namba ka-arri barrawu baji, kulu li-mbangu li-jibiya baji kalu-rdulurduma wudurru yiku nakaringu ki-badikila lukuluku ki-barrawula, kalu-waninjanguma bajinju ki-barrawula ki-walkurrala rdarlbirranthawu baji baku. ");
INSERT INTO jao_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Baji barra lukuluku ki-mayangka kalu-rdarlbirranthaninya...i arndaarndalu barra, ma-jakarda ma-ngarra ki-barrawula ki-jakardala. Kalu-yibalyibarra...i kulu ka-arri barra muru awara arndaarnda ma-ngarra, kangku-ngaya awara na-wurdu barrawu mungku-ngarrandu kulu winkanda ku-arri nuwarrku ngaliwa nganambaji kalakantharra, kunyamba-yiwa. ");
INSERT INTO jao_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kulu baji barra ka-arri Jujiba yurrngumantha kulu kumba-kajakajama kanymarda yiku, mayaniwujara, rrankirri-arduwujara wu-Ajinada. Kawula-yanjarri baji ngaliwa lhabayi marringaya. ");
INSERT INTO jao_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","52","Kulu kilu-wundarrba nya-mangaji marrantharl Manaja, kulu ngulakari mili buri kilu-wundarrba na-wini Yibrayim. Jinangu jalu-wundarrbanji nyungkalunga ki-wukangka Manaja, jinangu barranamba murdirrinjawu. Jujiba kumba-wukanyi, “Karnilu-yabima ngarna-wurdu Yijandu ki-Kud, kulu kurdardi barra linginmanthawu ngulakari bajarnaji narnu-dabudaburr narnu-yuwa bajarnaji wumba wabarra karna-lhuwarri nakaringu wunyathala yilaa. Karnilu-yabima ngarna-wurdu ngarna murdirrinjawu barra.” Kulu jinangu nyarrku na-wini Yibrayim nganambajilulu mili jalu-wundarrbanji ki-wukangka nyungkalunga, jinangu barranamba nyamba-kaj akaj aman thawu. Kumba-wukanyi Jujiba, “Marnawula rringatharri-arduwujara. Ki-Yijandu ki-Kud kilu-yabima awara ngatha marnarnaji narnu-yabi wumba karnu-arri ngatha narnu-dabudaburr ngala marningarna karnilu-yabima ngarna-wurdu wulanga, kanymardawujara arduwujara mayaniwujara,” nganinya kumba-wukanyi. ");
INSERT INTO jao_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nya-mangaji barra lhabayi yabi, kanymarda kulu kanymarda kulu kanymarda arrkula, ka-wayarri barra, barranamba ka-wukanyi Jujiba ambuliyalu yiku ki-king. ");
INSERT INTO jao_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Jinangu barra lhabayi wardi ka-wunumbarrirri, nya-mangaji wardi lhabayi ngaliwa wirndajku awara. Jinangu barra maya awara Yijiba lukuluku, kurdardi barra mu-ngarranku, wiji ku-wayarri. Baji barra ki-mayangka lukuluku Yijiba, wardi lhabayi barra ka-arri marda, barra kurdardi ku-yirdardinma ma-ngarra kangka wardi lhabayi, winarrku barra kalu-arri wirndajku. Ngala arrkula awara barra, baji barra Yijiba barra, ku-arri ma-ngarra aluwa, wudurru ka-arri baji arndaarnda rdarlbu. ");
INSERT INTO jao_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kulu li-mangaji li-jibiya bajingulaji Yijiba, kalinyamba-rarri mu-ngarranku, ngala wirndajku. Kulu kalu-wingka, kalu-yalbanga jinangu wirdi king, “Wayi barra ma-ngarra? Janu-wirndajkirrinji.” Kulu king barra, ka-wukanyi alunga, “Kurdardi ngarna! Rru-wingkaya yilalu ki-Jujiba! Nyirru-yalbangaya mu-ngarranku barra! Nyirra-nykarriya yiwa barra!” ");
INSERT INTO jao_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bawuji barra, lukuluku ka-arri awara kurdardi mu-ngarranku, baji barra Yijiba. Bawuji barra kulu karriili-nma barra narnu-mulu nya-mangaji barrawu wumba ku-arri ma-ngarra arndaarnda, kali-nma nya-mangaji barrawu jakarda lukuluku ki-awarala, nya-mangaji wiji. Kulu kalu-arri baji li-wirdi mu-ngarranku, jilimantharra nya-mangaji wudurru alunga, kulu li-jibiya Yijiba, kalu-wingkalwingka rdulurdumantharra wudurru kangka kalngiya narnu-wirndajku. ");
INSERT INTO jao_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Marda li-mbangu li-jibiya winkanda bajiwuthu, nyungkarrku ki-awarala, kala-nykarri wuka nya-mangaji awara arrkula Yijiba wudurruwiji, kalu-linginma, kulu kalinyamba-alathama barra nyungku-ja ki-awaralu rdulurdumanthalu ma-ngarra alunga wiji. Kangka wardi barra lhabayi lukuluku, kurdardi kiwa-nbanma wabuda yurrulu alunga wiji. ");
INSERT INTO jao_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jinangu barra malbu Jikaba, marda Yijrayil na-wini, jinangu nyiki-biyi ki-Jujiba, nyala bajiwa lhungku ka-arri akarru, nyungkiku ki-awarala baji Kinin. Nya-mangaji barra, ka-wukanyi alunga liyikiliyi-arduwu nganinya, ka-arri nganinya, “Marrirru! Marnirru nyamba-wunkanantharra nirru-mi marnaji ngala minja jirrini marnaji winarrku. ");
INSERT INTO jao_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nganhirra-nykarriya! Karna-nykarri awara jinangu Yijiba, bajawu barra ma-jakarda ma-ngarra. Aya kirru-wingkala bajinju, kirru-lhakanbala rdumanthalu ngambalanga. Marnaji marnaji kambalamba-mirranma wirndajku. Kirru-wingkala rdumanthalu ngambalanga wudurru, ngambala anmanthawu li-lhungku.” ");
INSERT INTO jao_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kulu li-ja barra, likili-ardu li-10-bala, likili-baba ki-Jujiba, kalu-lhuwarri ngamaliya barra, rdumanthalu ma-ngarra, li-ja li-wulu. Kurdardi kalngi rralungarra-wibi rra-arrkula ngala ruthuruthu lalungali-wibi ngala jinangu nyalunga-biyi malbu Jikaba arrkula. ");
INSERT INTO jao_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kulu jinangu nyarrku Binjamin kulu Jujiba, rri-ja barra kanymarda kawulamba-mirnirri rra-arrkula rrawulangarra-wibi. Ka-arri barra jinangu Binjamin wambu nyiki-biyila kangka ka-wardirri na-wurdu malbu barra Jikaba, nungka ka-wardirrinjima awara yiku ki-buringku, yiwa kurdardi waninjawu kariya, kulu kurdardi barra kili-janma aluwa jinangu ngulakaringu, ngala nalarrku li-wirdi kalili-ja bajinju Yijiba angula. ");
INSERT INTO jao_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Li-ja likili-ardu ki-Yijrayil, ki-malbuwu ki-Jikaba, alu kalu-wingka bajinju Yijiba. Kulu marda li-mbangu winkanda lukuluku baji ki-awarala ki-mayangka Kinin, marda barra alu wiji kalu-arri wirndajku. Kulu alu barra, li-ja li-wulu kalu-lhuwarri rdulurdumanthalu ma-ngarra. Marda likili-ardu ki-Jikaba, kalu-yibanda baji Yijiba, li-mangaji wiji. ");
INSERT INTO jao_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Baji angula barra ka-arri Jujiba, nyungku-ja ki-awarala Yijiba, yiwa barra ka-arri wirdiwalangu ngulakari yilaa ki-king. Yiwa barra, Jujiba, kilu-jilimanthaninya ma-ngarra alunga liyi-wuluwu liyi-nganjiyu wiji. Ngulakari barra kalu-rilirri li-ja likili-baba. Kalu-wingka barra yilalu, kulu kala-nba wajkaliya mududu yilalu, nganinya narnu-yuwa narnalunga liyi-Juwu. ");
INSERT INTO jao_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Kulu yiwa kalilu-lhaa likili-baba ngala alu, linjikulinji-babalu, kurdardi kalu-lhaanma jinangu Jujiba. Kulu kumba-wajkirra alunga. Ka-wukanyi aluwalu narnu-ladalada, ka-arri alunga, “Nganthingu marnirru?” Kalinyamba-ngarninyma, “Nganu nakaringu ki-awarala Kinin kanu-wingka bayimanthalu ma-ngarra.” ");
INSERT INTO jao_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ngalalu mududu yilalu baji ngaliwa ki-Jujiba karnilu-lingilinginma bajarnaji wabarrangu wumba kilu-mawuranga awara alunga, alu anmanthawu mududu yilalu nganinya. Kulu ka-arri alunga Jujiba, “Yirru li-yinjatha! Kirru-wingka marnajinju wunkanantharra awara nya-nganunga, kulu kirru-wanila kariya nalinanthawu awara yiku ki-wirdiyu, nungka jumba-nykalanykarrinji wardimanthawu nya-nganunga awara.” ");
INSERT INTO jao_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kalinyamba-ngarninyma yiku, “Wirdiwalangu! Kurdardi nganu li-wardi, kurdardi. Kurdardi kanu-wingkanma wunkanantharra nyirrunga awara. Winarrku li-buyi yinku janini barramarni linkungu li-jawina marnajinganu. Ngayamantharra rdumanthalu ma-ngarra kanu-wingka marnajinju. ");
INSERT INTO jao_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Marninganu, nganu wiji arrkula nyanganunga-biyi. Kalngiya yurlurr li-yabi nganu. Kurdardi kanu-wardimarru awara yinku.” ");
INSERT INTO jao_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kumba-ngarninyma alunga, “Kurdardi! Jirru-wingkayi li-wardimbangu ngalanganthalu awara nya-nganunga.” ");
INSERT INTO jao_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kulu yurrulu barra kalu-wukanyi yiku, “Wirdiwalangu, nganu minja li-12-bala bajinganu kaninyamba-mirnirri li-jibiya Kiniri, ngayamantharra arrkula kumba-kajakajama nganunga, nganu barra likili-ardu. Buri nganunga bajiwa wambu wunyathala yilaa, kulu nyarrku, kurdardi kiwima nganinyanga.” ");
INSERT INTO jao_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ngala kumba-ngarninyma alunga, “Barranamba ambuliyalu karna-wukanyi yirrunga marnaji, yirru jirru-wingkayi wunkananthalu awara nganunga. Yirru li-yinjatha. ");
INSERT INTO jao_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Namba nya-mangaji nyirrunga-anyira ka-wingkala marnajinju, kulu kirrirna-lhaala barra yirru li-yabi, yurlurr wukanyinjawu kalngi wuka. Namba kurdardi ka-wingkarru, kulu bajingarna barra karna-lhaala yirru li-wardi, kirru-warndimanji. Nganinya kirrirna-lhaala wayi barra yirru. Kulu jirrirni-nanji kalngiya, kurdardi kirru-lhuwarriyu marnajingu, kirra-nmanthanama wambu marnaji namba kurdardi ka-wingkarru marnajinju nyirrunga-anyira. ");
INSERT INTO jao_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nyirri-jaya arrkula wa-waniya rdumanthalu nyirrunga-anyira ngalirru nirrarrku anmantharra wambu arndaarnda ki-burijin. Namba ka-waninjima nayirdi ki-buriyu, kulu yamulu, kirrirna-lhaanjima kanhirri-nu kalngi, yirru. Namba kurdardi, kulu kirrirna-lhaanjima kalngiya li-yinj atha bawuji. Kirrirna-lhaala nganinya barra, nungka li-marringaya, nungka li-wardi.” ");
INSERT INTO jao_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kulu bajingu barra kalilu-yibarra arndaarnda ki-barrawula rdirrirrantha, na-kanymarda arrkula na-wunbarr kalu-arri baji arndaarnda. ");
INSERT INTO jao_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Bajingu barra kalu-walanyma nakaringu ki-burijin, kalala-ka yilalu ki-Jujiba. Ka-wukanyi alunga nganinya, “Namba kirra-kala ngatha wuka kulu namba yirru li-ngayangaya, kulu kirra-nmala barra li-lhungku, kangka jama-lhaanji Yijan Kud kalngiya bajingarna barra jarna-walwardankayi yiku. Minja jirrirna-maramaramanji. ");
INSERT INTO jao_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Namba yirru li-yurlurr li-yabi, kulu ngayamantharra arrkula marnaji ka-nmala rdirrirrantha arndaarnda, kulu nirrarrku yamulu kirru-wanila barra kantharra ma-ngarra alunga liyirrungaliyi-nganjingku, bajalu wirndajku yukumantharra yirrunga. ");
INSERT INTO jao_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Baki nyirra-kaya nyirrunga-anyira marnajinju ngathangkalu kulu karna-ngayamala yirrunga yirru li-yurlurr wukanyinjawu, kulu kurdardi barra kirrirna-ramarru.” Kulu alu barra, kalu-wukanyi yiku ki-Jujiba, nganinya kalu-arri, “Yiya, yamulu barra. Kanu-waninjangumala nyanganunga-anyira.” ");
INSERT INTO jao_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bajingu barra kalinyamba-wukanyi, “Marningambala barra warriya, kangka kambala-wardimala awara yiku nyungambalanga-anyirawu. Kalngiya kambala-arri li-wardimbangu yiku. Kambala-kala rarrinjarra wakulamba na-wurdu, kambala-kala kumba-yiwama ngambalanga, ngambala marakamanthawu, ngala kambala-ngajbirri yiku, kurdardi kambala-nykarrinma, kambali-jala marnajinju ki-Yijiba. Bajungkarnu barra marningambala, marnarnaji narnu-dabudaburr ngambalanga, ki-Kud jilu-wardimanji awara ngambalanga kangka ngambala li-wardi kambala-arri.” ");
INSERT INTO jao_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kulu wirdi Rubin ka-wukanyi alunga nuwalarrkulu, nganinya ka-arri, “Yiya. Karna-wukanyinjaninya yirrunga ndayawu yiku, barni-wardimantha, ngala yirru waraba kirra-nykarrinma. Li-yakayaka kirru-murdirri awara kurdandu. Nganinya jambalini marnaji nungkarnu-wardinja, wirangu barra nyangambalanga-anyira kumba-mirra. Bajuwarnu jambalilu-ramanji ki-Kud.” ");
INSERT INTO jao_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ngala waraba kalu-lhaanma kalngiya nyalunga-anyira nganambaji baji ka-arri alunga kalila-nykarrinjaninya ngala yiwa kalilu-lhaa likili-baba. Ngala alu kalu-ngalnganda kangka jina wuka ka-wukanyi alunga Yijibangala kulu ngulakari ki-jawinalu nyungkiku kilu-yangama wuka alunga, ka-wukanyi Yiburungala kangka alu li-Yiburu, kulu kathiwa jibiya baji Yijiba nya-mangaji Jujiba wumba ka-wukanyi alunga. ");
INSERT INTO jao_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kalila-nykarri baji nyamba-wukanyinjarra, ka-wirnirri nakaringu aluwa, ka-wingka nyamba-rarrinjarra kangka li-ja likili-baba wurrbi. Namba kumba-lumbuma na-wurdu kulu mili ka-wani aluwalu barra bajinju wukanyinjalu. Kulu kilu-ruthuruthuma ambuliyalu Jimiyan, nya-mangaji wirdi ngulakari yilaa ki-Rubin, kilu-ruthuruthuma, kulu kalili-jirrinyma li-mangaji likungu li-jawina kalu-rdirrirra jinangu barra Jimiyan ngalalu nganambaji nalarrku likili-baba nyala wunkanantharra. Kulu kalu-lhuwarri barra nakaringu yilaa, alu wiji likili-baba. ");
INSERT INTO jao_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Bajingu barra kalili-jirrinyma likungu li-jawina, “Rru-yibalyibarraya wu-bayikilu rrungkalunga ma-ngarra a-murumulu! Kulu baji barra arndaarnda rru-waninjangumaya ma-mangaji ma-mani rrungkalunga rru-bayikila ruthuruthu! Kulu nuwarrku barra ma-ngarra rru-yibarraya alu nyamba-wudurrumanthawu wumbiji.” Nganinya barra ka-wukanyi alunga liyiku liyi-jawinawu. Kulu kalu-yibarra nganambaji barra alunga kangka yiwa Jujiba ka-wukanyi alunga liyi-jawinawu, ma-mangaji ma-ngarra barranamba ma-kingkirra kalu-yibarra. ");
INSERT INTO jao_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kulu likili-baba ki-Jujiba, ankaya barra kalu-yibalyibarra ki-yirrikirrila kulu kalu-lhuwarri barra akarriya nyungkalunga ki-awaralu. ");
INSERT INTO jao_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kalu-wingka...i nyala bajinju wumbiji, kalu-yibanda barra. Kulu nyungkarrku barra, ki-arrkulangku, karrili-nma a-birndawara nanda-mulu, yiwa wudurrumanthawu nyiku yirrikirri, kulu kila-kala barra mili arndaarnda mulungka wu-bimdawarala, kila-kala arndaarnda. ");
INSERT INTO jao_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Marnawu ma-mani mikungu!” Ka-ruwama. “Marnawu ma-mani ngathangka, rrungku-ngatha rru-bayikila nungkandu-mulungka!” Kulu alu barra wiji kalu-wardirri nalu-wurdu, kalu-arrkama nalu-manka. “Ngalhiyu kalu-waninjanguma ma-ja ma-mani, ngalhiyu? Ngandarra ja-arrinji Kud ngambalanga, ngandarra?” Nganinya barra kalinyamba-yalbanga. ");
INSERT INTO jao_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kulu kalu-lhuwarri bajingu yalibala. Kalu-wingka...i yurrngumantha nyala bajinju ki-awaralu nyungkalunga Kinin kulu nyungkalunga-biyilu ki-malbungku. Kalu-yibanda barra baji. Kulu yinarrambalulu barra kalinyambi-nu yiku, kalu-arri yiku, ");
INSERT INTO jao_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ngabinya biyi! Nya-mangaji barra wirdi angula, kanilu-rulama li-nganji, ka-wukanyi nganunga narnu-ladalada. Kathinganu kanu-wingka bajinju wunkananthalu awara, kathinganu li-yinjatha. ");
INSERT INTO jao_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ngala kaninyambi-nu yiku, ‘Kurdardi kanu-wingkanma wunkananthalu awara. Waraba nganu li-yinjatha, waraba. Nganu kalngiya barra li-yurlurr. ");
INSERT INTO jao_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nganu wiji li-12-bala, arrkula nyanganunga-biyi, kumba-kajakajarna nganunga. Arrkula kurdardi kiwima ngala buri bajiwa yilaa wunyathala, bajiwa akarru Kinin,’ nganinya kanu-arri yiku. ");
INSERT INTO jao_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kulu kumba-ngarninyma nganunga nya-mangaji wirdi, ‘Kirrinyamba-mirnimala ngatha, namba yirru barra li-yurlurr li-yabi. Kirra-ndarra marnaji arrkula ngathangka, kirru-lhuwarrila nirrarrku kantharra ma-ngarra alunga liyi-mangaji liyirrunga liyi-wirndajkuwu. ");
INSERT INTO jao_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kulu namba kirru-wanila mili marnajinju, kirra-kala nya-mangaji buri nyirrunga-anyira yirruwa, barni-murdirrinja karna-ngayamala barra yirrunga kulu karna-yabirrila yirrunga ngarna-wurdu, kirrirna-lhaala barra yirru karnirri-nu kalngi wuka, kurdardi li-yinjatha yirru. Kulu ngulakari barra karni-nma nyirrunga-baba, kulu kirru-wanila yankumantharra nya-mangaji, marda kirrirna-ngundarra barra ma-ngarra barra yurrulu,’ nganinya barra ka-wukanyi barra nganunga.” Kalu-arri nganinya yiku nyuwalunga-biyiyu ki-Jikaba. ");
INSERT INTO jao_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bawuji barra kali-nmalinma ma-ngarra alunga wiji, kalu-yibalyibarra baji awarala. Kulu karrali-nma a-birndabirndawara wiji alunga nanda-mulu kulu kalu-wakarama barra ma-mani aluwa rrungku-ja rru-birndawarala nganambaji ku-wani. Kulu kala-kala wiji barra, wiji kala-kala ma-ja ma-mani rrungkalunga rru-birndawarala wiji ku-wani, kulu bawuji barra kalu-wardanka, kalu-ruwama kurdandu. ");
INSERT INTO jao_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kulu malbu barra ka-wukanyi alunga, “Yirru wardimanthawu awara ngatha kulu liyingathaliyi-ardubirriyu wiji. Jujiba kurdardi kiwima, baki Jimiyan kurdardi kiwima, kulu mili yurrulu jarnirru-yalbanganji yirru kanthawu jinangu buri Binjamin nakaringu ngathangka. Kulu ngarna warriya luku, ngarna wardirrinjawu ngarna-wurdu.” ");
INSERT INTO jao_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kulu Rubin barra ka-wukanyi yiku nyiki-biyiyu, “Namba kurdardi karna-waninjangumarru buri Binjamin yindalu, kulu kirna-ngundarra rringatharri-ardu mayaniwujara kawulinya-ramala. Ngarna-ngundarra ngarna! Karna-kunkunmala kulu karna-waninjangumala yindalu.” ");
INSERT INTO jao_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ngala yiwa malbu ka-wukanyi, “Nyangathi-ardu kurdardi ka-wingkarru yindaa, wambu kiwa-nmala ngathangka. Bajiwa barra nyiki-baba kumba-mirra, kulu jinangu arrkula barra marniwa ngathangka. Ngarna warriya malbu. Namba jinangu kumba-mirranma ngatha yabayabala, nungka ngarna mili karnamba-rarrinma kulu nyamba-mirranthalu wirangu barra yiwa,” nganinya barra ka-arri yiku. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Baku barra kalu-arri bajingulaji ki-awarala Kinin. Kulu mili yurrulu kurdardi kiwa-nbanma wabuda, kulu mili yurrulu ka-rukurri awara, kalngiya narnu-wirndajku...i narnu-walkurra narnu-wirndajku barra. ");
INSERT INTO jao_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kulu kalu-wayatha ma-mangaji ma-ngarra wumba kalu-rduma nakaringu Yijiba, kalu-wayatha. Kalu-arri barra wirndajku. Ka-wukanyi barra malbu Jikaba, “Bawuji barra kirru-wingkala yurrulu rdumanthalu ma-ngarra ngambalanga.” ");
INSERT INTO jao_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kulu yiwa barra Juda, ka-wukanyi yiku, nganinya ka-arri, “Ngabinya biyi! Nyungku-mangaji mili ki-wirdinju baji Yijiba, ka-wukanyi narnu-ladalada nganunga, kanilu-maramarama, nganu kanthawu jinangu nyanganunga-anyira buri. Kurdardi kanilu-wirrangarru nganu ngalbanthawu yilalu namba kurdardi yiku ki-buriyu, nganu nganulumba. ");
INSERT INTO jao_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Namba kinyi-jala jinangu nyanganunga-anyira nganuwa, kulu yamulu barra kanu-lhakanbala rdumanthalu ma-ngarra ngambalanga. ");
INSERT INTO jao_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Namba kurdardi kinyi-jarru, kurdardi kanu-lhakanbarru bajinju rdumanthalu wudurru, kangka kanili-nu ki-wirdinju, namba kanu-wingkala bajinju bardabarda yiku, kulu kurdardi kanu-ngalbarru yilalu, kurdardi kanu-rdumarru wudurru.” ");
INSERT INTO jao_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kulu malbu Yijrayil, ka-wukanyi alunga, “Ngala ngalhiyu kirri-nu, ngalhiyu, jinangu nyirrunga-anyira? Jarnirru-wardimanji mili ngarna-wurdu.” ");
INSERT INTO jao_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kulu alu barra, kalinyamba-ngarninyma yiku ki-malbuwu, “Ngabinya! Yiwa kanilu-yalbayalbanga yiwalungu. Kanilu-yalbayalbanga liyinganungaliyi-nganjingku kulu ka-arri, ‘Wayi nyirrunga-biyi? Bajiwa yamulu jiwini? Kulu li-ngandarrangu baji yilaa lirrungali-anyira?’ Kulu nganambaji barra kanu-wukanyi kirningani-nu, kulu kani-nu mili nya-mangaji nyanganunga-anyira. Kurdardi kanu-biyarru jakudi yiku ngala nganambaji kaninyamba-ngarninyma yiku. Nganu li-manji yiku, li-manji kanu-arri ngalhiyu kanilu-yalbayalbanga ngala yiwa kanili-nu nganu kanthawu nyanganunga-anyira buri.” ");
INSERT INTO jao_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kulu Juda ka-wukanyi yiku nyiki-biyiyu, yiku ki-Yijrayil, “Nyi-jaya ngathangka! Kulu namba kinyi-jala ngathangka, kulu yinarrambalulu kanu-lhuwarrila ngayangaya marnajingu rdumanthalu wudurru ngambalanga. Kambala-nmala kuja wudurru, ngambala anmanthawu lhungku, nganu baki yinda baki linganungali-ardu, mili baji kambalamba-mirranma wirndajku. ");
INSERT INTO jao_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kalngiya karna-kunkunmala, kangka ngathangka kiwa-nmala marlijinda. Yabi jarni-nanji, yabi, biyi. Namba kurdardi karna-waninjangumarru yindalu yabi, yiwa alarrinjawu marnaji yindaa, kulu karna-wanala kurdandu ngarna-yurrngu, kamamba-yunduyundumala ngarna karna-wardima awara. ");
INSERT INTO jao_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nyala marninganu yukulyiikumantharra nganu lhuwarrinj awu. Rikarra kunganu-waninjangumanma ma-ngarra ngala nyala marninganu marnajingulaji yukulyukumantharra ngandarra ja-arrinjimu.” ");
INSERT INTO jao_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ka-wukanyi nyalunga-biyi Yijrayil alunga, “Marningarna rarrinjarra, ngala yamulu barra nganinya rdumanthawu ngambalanga. Kulu yirru, kirra-kala niwarrku yabi yumbulyumbumantha marringaya awara yiku nyuwu-mangaji ki-wirdiyu, yirru ngundayawu. Kila-kala dulbarri, ma-mangaji nu-kurnbal, na-mirdijin, kulu nyarrku awara, kulu kirra-kala yiku. ");
INSERT INTO jao_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kulu rra-kaya yurrulu ma-mani, mulu-mangaji wumba ku-arri wu-bayikila, ku-wani yirruwa ambuliyalu, kulu rra-kaya yurrulu mili bayimanthawu yurrulu ma-ngarra. Nungka kalu-murdirri awara bajiwaji wabarrangu wumba kalu-yibarra ma-mangaji ma-mani. ");
INSERT INTO jao_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","“Kulu nyirra-kaya nyirrunga-anyira kulu rru-lhuwarriya yinarrambalulu yilalu ki-wirdinju. ");
INSERT INTO jao_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Jarna-yalbanganji Wunungu Kud yiku nyuwu-mangaji ki-wirdiyu, yiwa Kud yabimanthawu na-wurdu yirrunga, yirru waninjangumanthawu Binjamin kulu nya-mbangu nyarrku wumba jiwini rdirrirrantha, wula waninjawu yirruwa. Kulu ngarna, namba karna-rarrinjima wulanga rriyingatharriyi-arduwuj aranguwu rriyi-ngabangakuwu baku, kulu nganambaji karna-rarrila wulanga.” ");
INSERT INTO jao_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kulu bajingu barra li-mangaji likili-ardu kalu-rdulurduma barra marrimarringaya awara yumbulyumbumantha kala-ka barra aluwa, kulu marda yurrulu barra ma-walkurra ma-mani kala-ka barra aluwa. Kulu bawuji barra aya kalu-lhuwarri marda Binjamin aluwa, bajinju barra Yijiba. Kalu-wingka...i lhakanbayarra nyala bajinju. Kalu-wingka ki-wirdinju yilalu, kalu-yibanda baji yilaa ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kulu ki-Jujiba, ngaliwa kila-kala Binjamin aluwa, kulu ka-wukanyi nyuwiku ki-jawinawu ki-wirdiyu, “Linya-kaya li-ja li-wulu nyungku-ngatha ki-barrawula kangka kambalamba-wudurrumala mukunjarna, baji darrkirla awara, kangka wirndajku barra. Nya-ramaya buluki kulu wubalubaya na-warnnyibirri ngambalanga!” ");
INSERT INTO jao_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kulu nyungku-ja nyungkiku ki-jawinalu, kalila-ka barra bajinju nyungkiku ki-barrawulu. ");
INSERT INTO jao_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ngala kalu-wingka bajinju wandayarra nya-mangaji, kalu-wardanka kurdandu. Kulu kalinyamba-wukanyi barra, “Nyungku-ja barra, jambalila-kanji marnajinju wirangu ma-mbangu ambuliyalu ma-mani ku-wani ngambalaa rru-bayikila. Nungka nyalalhurrku barra kambalalu-ramala, kala-kala barra jinangu yirrikirri aluwa, ngala ngambala kambala-nmala li-jawina aluwa, li-ngayangaya likungu.” ");
INSERT INTO jao_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kulu kalu-yibanda baji ki-barrawula, kulu kalu-mirrinyma nya-mangaji jawina wirdi baji winkanda ki-barrawula nyungkiku ki-Jujiba, kulu kalinyamba-yunduyunduma yiku baji. ");
INSERT INTO jao_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Kalu-arri nganinya, “Wirdi, kirna-barlirra! Kanu-wingka marnajinju ambuliyalu rdumanthalu ma-ngarra. ");
INSERT INTO jao_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kulu bawuji barra kanu-lhuwarri nyala bajinju wumbiji kanu-arri walkurr, kulu namba kani-nma awara wajkaliya kanu-yibarra karrangani-nma barra kulu kunganu-wakarama barra wu-bayikila ma-mani barra arndaarnda ku-arri nungkandu-mulungka, ma-mangaji barra wiji ku-wani nganuwa. Kulu kunganu-waninjanguma ma-mangaji ma-mani marnawu nganuwa. ");
INSERT INTO jao_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kulu nuwarrku barra kungana-ka yurrulu rdumanthawu barra mili yurrulu ma-ngarra. Nganu li-manji barra nganinju nungka barra kilu-yibarra barra ma-ja ma-mani rrungku-nganunga rru-bayikila,” kalu-arri yiku nganinya. ");
INSERT INTO jao_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kulu nya-mangaji wirdi jawina ka-arri alunga, “Barni-wardirrinja nirru-wurdu! Barni-wardankaya rra-nmaya! Nungka ki-Yijandu, nya-mangaji Yijan yiku nyuwirrunga-biyiyu, nungku nyungku-mangaji ki-Yijandu kilu-yibarra ma-mangaji ma-mani yirrunga. Kurna-rduma ma-mangaji ma-mani ambuliyalu yamulu,” nganinya ka-arri. Kulu bawuji barra bajingu kila-ka Jimiyan bajinju aluwalu. ");
INSERT INTO jao_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ki-jawinalu nyungku-mangaji, kalila-ka arndaarndalu, kalilu-ngunda wabuda alu nyamba-arlkarlbanthawu nalu-mamda, kulu mili kilu-ngunda ma-ngarra yirrikirriyu nyamba-wudurrumanthawu. Kulu kalili-nu, “Nya-mangaji wirdi, ka-wingkala barra marnajinju mukunjarna, kulu kirrinyamba-wudurrumala yilaa,” nganinya jawina ka-arri alunga. ");
INSERT INTO jao_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bajingu alu barra kalu-rdulurduma nya-mangaji yumbulyumbumantha marringaya awara, kalu-yibalyibarra baji yiku barra, alu ngundayawu. ");
INSERT INTO jao_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kulu ngulakari barra, Jujiba ka-wingka bajinju, kulu kalu-wingka barra arndaarndalu, kala-ka barra nya-mangaji barra yumbulyumbumantha ngundayawu yiku. Kulu kala-nba wajkaliya mududu yilaa. ");
INSERT INTO jao_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kulu kalilu-yalbanga ki-Jujiba, “Yamulu barra marnirru? Kulu wayi barra nyirrunga-biyi, nya-mangaji wumba kirri-nu ngatha? Nyala bajiwa yabi, kurdardi kumba-milmirranjima?” ");
INSERT INTO jao_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kulu kalinyamba-ngarninyma yiku, “Yiya, wirdiwalangu, kirna-barlirra. Yamulu yabi bajiwa, kurdardi kumba-milmirranjima, bajiwa lhungku.” Kulu yurrulu mududu kalu-arri yilalu. ");
INSERT INTO jao_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kulu kila-kala nyiki-anyira kalngiya yiwa, rra-arrkula rrawulangarra-wibi, kulu kilu-lhaa. Kulu ka-arri, “Marniwa barra jinangu, nyirrunga-anyira wumba kirri-nu ngatha ambuliyalu.” Kulu ka-wukanyi yiku, “Yalkuyi! Jarna-yalbanganji Yijan Kud, yiwa anmanthawu yabi yinku.” ");
INSERT INTO jao_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kulu bajingu winarrku ka-lhuwarri nyala arndaarndalu nungkiku nungku-alanjilu, kangka kumba-nykalanykarri yiwa wunumbarra barra rarrinjawu aluwalu. Kulu ka-rarri barra baji arndaarnda yiwalumba, ka-rarri barra kangka kila-kala wurrbi nyiki-anyira ngulakari yilaa. ");
INSERT INTO jao_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bawuji barra bajingu nakaringu arndaarnda kumba-rukulrukuma na-mi ki-ngirlilu. Kumba-lumbuma na-wurdu ngaliwa ka-walanyma aluwalu. Kalili-jirrinyma likungu li-jawina anmanthawu awara barra wudurru. ");
INSERT INTO jao_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kalili-nu li-mangaji li-jawina yibarranthawu na-ja na-dibul na-arrkula, yiwa nmanthawu mingkiya baji yiwalumba, yiwa wirdi, kulu narrku mili alunga liyi-jawinawu wumba kalinyamba-wudurrumanthaninya yilaa, kulu narrku mili alunga liyikuliyi-babawu, kangka li-ja li-jibiya Yijiba, kurdardi barra nyamba-wudurrumanthawu aluwa linji-Yiburu, kalu-ngalngandayaninya wakulamba nyamba-wudurrumanthawu aluwa, nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kulu barra kalili-jirrinyma li-jawina, alu yibalyibarranthawu likili-baba anmanthawu mingkiyawu, ki-wirdiyu ambirriju kulu nuwalarrkulu barra liyi-yumbuwarrawu ngulakari yilaa, liyikiliyi-anyirawu, kulu kalu-yibalyibanda barra wajkaliya barra. Bawuji kalinyamba-wunkanu wumimbijilu kulu kalu-ruwama barra yiku, kangka kalilu-yibalyibarra nganinya, wirdi ambirriju kulu ngulakari nyarrku kulu ngulakari nyarrku, kalu-ruwama yiku wayi barra yiwa mirdan alunga nganinya. ");
INSERT INTO jao_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kalili-jirrinyma mili li-jawina likungu kalakantharra na-warnnyi bajingu barra dibula nungkiku ki-Jujiba, kala-kalaka bajinju ka-arri barra na-warnnyi barra na-rarrawumba baji barra rdarlbu ka-arri dibula, kulu nakaringu bajingu nikungu dibula ki-Jujiba kalu-ruthuruthumanthaninya, kalalu-ngulngundayaninya barra. Kalu-rarrma ma-ngarra kulu kala-tha na-warnnyi barra, kalinyamba-wudurruma kurdandu. Kulu ki-Jujiba kili-ja mili na-warnnyi yiku ki-Binjamin, kili-ja jakarda yiku. Kulu kalu-wulwunja barra yabi jinawuthu marringaya wabuda, kulu kalu-yabirri nalu-wurdu wakulamba, baji yilaa. ");
INSERT INTO jao_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jujiba ka-wukanyi yiku nyuwiku ki-jawinawu ki-wirdiyu, kili-nu nganinya, “Bawuji barra, yibalyibarraya ma-ngarra alunga rrungkalunga rru-bayikila! Ma-jakarda yibarraya kurdandu kulu kurdardi munhamanthawu! Kulu baji barra rru-bayikila rrungkalunga nungkandu-mulungka yibarraya ma-mani ruthuruthu aluwa! ");
INSERT INTO jao_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kulu jinangu, nya-mangaji banikin marringaya nya-ngatha, ma-jakarda ma-mani karna-ngunda bayimanthawu nya-mangaji, nya-yibarraya nyuwu-mangaji yilaa ki-buyiyu rrungkiku rru-bayikila nungkandu-mulungka!” Kulu nganambaji barra kilu-yibarra ma-mangaji barranamba ma-kingkirra alunga, kilu-yibalyibarra...i, wiji kilu-wayatha awara alunga. ");
INSERT INTO jao_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bajingu barra bawuji nunyilanku kalali-ja, kalu-lhuwarri akarriya barra nakaringu aluwa, nyungkalunga ki-awaralu kalu-wani, likili-baba kulu alunga yirrikirri. ");
INSERT INTO jao_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kulu Jujiba ka-wukanyi yiku nyuwiku ki-jawinawu ngalalu bajalu nyala wunumbarra ki-barrawula ki-walkurrangka, kili-nu yiwa wingkayawu aluwalu. Ka-arri yiku, “Wingkaya aluwalu linji-mangaji linji-wulungku! Yarlajka wingkaya! Namba linya-mirrinymaya kulu linyi-yalbangaya, arriya alunga, ‘Nyangatha wirdi ka-wukanyi ngatha nganinya. Wayi yirru kirru-wardima nungka awara yiku? Ngalhiyu barra kirru-wardima yiku wumba ka-arri yabi yirrunga? Ngalhiyu kirru-wajkirra nya-mangaji banikin yiku ki-wirdiyu? ");
INSERT INTO jao_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kilu-ngunda ma-jakarda ma-mani bayimanthawu nya-mangaji, ma-jakarda barra kulu ja-wunja yurrngumantha nyungku-mangaji ki-banikinda. Kilu-barlirra kurdandu nya-mangaji. Yirru barra kirru-wardima awara kurdandu!’” Nganinya kili-nu ki-Jujiba, yiwa wukanyinjawu alunga. ");
INSERT INTO jao_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kulu ka-wingka yarlajka kulu kalilu-mirrinyma, kalila-kala marnalu. Ka-wukanyi nya-mangaji wuka barrawumba kili-nu ki-wirdinju nyungkiku, ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kala-nykarri wukanyinjarra nganinya, kulu kalu-ruwama kurdandu, kalinyamba-ngarninyma yiku, “Ngalhiyu ja-wukanyinyu nganinya nganunga, ngalhiyu? Kurdardi kana-kanma awara yiku, kurdardi! Nganu li-yabi, li-marringaya. Kurdardi nganu wajkirranthawu awara, kurdardi. ");
INSERT INTO jao_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Yabi kunganu-waninjanguma ma-mangaji ma-mani wumba ku-arri wu-bayikila nganuwa, nakaringu jujungka ki-awarala Kinin kunganu-waninjanguma wumba kunganu-wakarama kulu nganambaji kungana-ka nganuwa kulu kanu-ngunda yiwa barra wirdi. Mili ngalhiyu kanu-wajkirrinjima awara bajingu ki-barrawula nganinyanga? ");
INSERT INTO jao_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Namba kinyu-wakaramanjima nya-mangaji banikin nganinya jiwini yilaa, kulu kinyu-ramala nganambaji ngala nganarrku barra kana-nmala li-jawina yiku,” nganinya kalu-arri yiku. ");
INSERT INTO jao_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kulu ka-wukanyi alunga nya-mangaji jawina, “Kurdardi yirru, ngala nya-mbangu wumba nya-mangaji banikin yilaa, yiwa barra kiwa-nmala jawina yiku wambu, ngala yirru winarrku kirru-wanila akarriya, li-yabiwiji.” ");
INSERT INTO jao_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kulu bawuji barra kalu-yibalyibarra wajkaliya awaralu a-birndabirndawara kulu karrili-nmalinma a-birndawara alunga ruthuruthu. ");
INSERT INTO jao_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kulu ambuliyalu ki-wirdiyu ka-yarrba barra nya-mangaji jawina, karrila-kala a-bayiki barra arndaarnda, kurdardi. Kulu nyuwu-mangaji mili ngulakaringu nyiki-anyirawu ka-lhanka, karrila-kala. Kurdardi yiku. Kulu mili yurrulu kiwa-lhankalarra rrungkalunga rru-bayikila nuwalarrkulu. Kurdardi kilu-wakaramanma. Kulu ngulakari barra ki-buriyu ki-Binjamin rrikungu a-birndawara, karrili-nma nanda-mulu, ka-lhanka arndaarnda, kila-kala marniwa barra, wakara nya-mangaji banikin. “Yiya! Marniwa barra nya-mangaji! Marniwa nya-mangaji banikin yilaa, nyungku-ja!” ");
INSERT INTO jao_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kulu li-mangaji likili-baba, kalu-ruwama kulu kalu-rarri nalu-wurdu, kulu kalu-maluma alunga jumbala, kalngiya kalu-wardirri nalu-wurdu nyuwalunga-anyirawu yiku. Kulu yurrulu kalu-yibalyibarra a-birndawara ki-yirrikirrila. Kalu-wani barra karakarra aya barra bajinju ki-barrawulu. ");
INSERT INTO jao_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ngala kalu-yibanda barra baji alanjila ngaliwa Jujiba nyala bajingulaji ki-barrawula ka-arri. Kulu kalu-wingka yilalu, kala-kala marniwa mingkiya, kala-nba wajkaliya mududu, nyamba-yibarranthawu li-buyi yiku, nganinya narnu-yuwa narnalunga liyi-Juwu. ");
INSERT INTO jao_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jujiba ka-wukanyi alunga, “Ngandarra kirru-arri ngatha, ngandarra? Marda kirrima mirdan ngatha, ngarna kalngiya wirdiwalangu, mingkin jarnini ki-awarawu wayi ka-nmala baku.” ");
INSERT INTO jao_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kulu yiwa, nyiki-baba Juda kumba-ngarninyma yiku, “Wirdi, kirna-barlirra. Ngandarra nganu wukanyinjawu yinku? Ngandarra nganu yunduyundumanthawu awara yinku? Ngandarra nganu nyamba-mirnimanthawu li-yabi? Kurdardi. Ki-Yijandu ki-Kud, kanilu-lhaa nganu li-wardi, ja-wukanyinji nganinya nganunga nganu-wurdu. Nganu wiji kana-nmala marnaji li-jawina yinku. Kurdardi arrkula, yiwa wumba ka-arri nya-mangaji banikin yilaa, ngala nganu wiji.” ");
INSERT INTO jao_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kulu Jujiba ka-arri yiku, “Kurdardi ngarna wardimanthawu awara wiji yirrunga, kurdardi barra yirru anmanthawu marnaji li-jawina ngatha, ngala ngayamantharra nya-mangaji, bawuji ka-arri banikin yilaa, bawuji yiwa. Yamulu yirru nirrarrku kirru-wanila yabi yilalu ki-malbungku nyungkirrunga-biyilu.” ");
INSERT INTO jao_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Bajingu Juda ka-wunambarrirri yilalu ki-Jujiba kulu ka-wukanyi yiku, “Kirna-barlirra wirdi! Yamulu karna-wukanyinjima yinku? Barni-yinjatharrinja ngatha! Yinda wirdiwalangu barranamba king. ");
INSERT INTO jao_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Wirdi, kaninya-yalbanganhu ambuliyalu, ‘Bajiwa kuna nyirrunga-biyi kulu nyirrunga-anyira?’ ");
INSERT INTO jao_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kulu kaninyamba-ngarninyma yinku, kani-nu nyanganunga-biyi kulu nyanganunga-anyira, ka-yanjarri ngaliwa ka-malburri. Nyiki-baba ambirriju yilaa, kumba-mirra. Jinangu barra, marniwa barra, arrkula anku rrikurra-wibiyu lhungku, kulu nyiki-biyi ja-yabirrinji na-wurdu kurdandu yiku, kanu-wukanyi yinku nganinya ambuliyalu. ");
INSERT INTO jao_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Kulu wirdi, yinda kaninya-yalbanganhu nganu kanthawu marnajinju, yinda nganthawu yiku. ");
INSERT INTO jao_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kulu kaninyamba-ngarriinyma, ‘Kurdardi nya-mangaji yalkuyi kila-ndarru nyiki-biyi. Namba ka-lhuwarrinjima, kila-ndayima, kulu kumba-mirranjima nyiki-biyi.’ ");
INSERT INTO jao_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kangka ka-wukanyinyu yindalungu nganunga, ‘Namba kurdardi kirra-karru marnajinju kulu barni-wingkaya marnajinju ngathangkalu bardabarda yiku,’ ");
INSERT INTO jao_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","kulu kanu-wani yilalu wunyathalu, kulu kanu-wukanyi yiku bajarnaji barrawumba yinda ka-wukanyinyu nganunga. ");
INSERT INTO jao_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Kulu baku barra yiwalungu kali-nu wunyathalu nganu waninjawu marnajinju barra rdumanthalu ma-ngarra. ");
INSERT INTO jao_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kulu kaninyamba-linginma barra yinku bajarnaji, kulu kanu-wukanyi yiku wunyathawu, ‘Kurdardi kanu-wingkarru winarrku nganulumba. Kurdardi kana-ngarru nya-mangaji wirdi namba nyanganunga-anyira kiwa-nmala marnajingulaji. Namba nganu wiji kanu-wingkala bajinju, kulu yamulu.’ ");
INSERT INTO jao_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Kulu wunyatha ka-wukanyi nganunga, ‘Yirru li-mirdan, rra-ngatha a-Rijil, kanumba-kulhakulhama ngayamantharra kanymardawujara rri-mayani. ");
INSERT INTO jao_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mayani arrkula bajiyawuthu barra nungka. Nyungku-mbanguwuthu barra ki-wardalinju kila-tha. Ka-lhuwarri nakaringu ngathangka kulu kurdardi ka-waninma ngathangkalu. ");
INSERT INTO jao_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Namba kirra-kala jinangu nakaringu ngathangka kulu ka-wardirrinjima awara yiku, kurdardi ka-waninjima, kulu karnamba-rarrinjima barra yiku yurrngumantha kulu ngarna nyamba-mirranthalu ndingarna ngarna-malbu,’ nganinya ka-arri nganunga. ");
INSERT INTO jao_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Wiirdi! Namba kanu-wanila yilalu wunyathalu nganulumba, namba kanila-ngala bardabarda yiku ki-yalkuyiyu, kulu kumba-mirranma. Kumba-yibarra na-wurdu yiku kalngiya nyuwu-ja, jiwini baji akarru yukumantharra yiku waninjawu. Kalngiya ja-malburrinji kurdandu. Namba kanila-nganjima nganu nganulumba bardabarda yiku, kulu kumba-rarrinjima baji yurrngumantha kulu nyamba-mirranthalu. ");
INSERT INTO jao_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“Kulu ngarna, karna-wukanyi yiku wunyathawu, ngarna waninjangumanthawu jinangu yalkuyi yabi yilalu, kulu namba kurdardi, ngarna anmanthawu wananjawu yiku ngarna-yurrngu, ngarna karnamba-yunduyundumala ngarna-yurrngu, karna-wardima awara yiku wunyathawu. ");
INSERT INTO jao_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Wirdi, kirna-barlirra! Ngarna karna-nmala marnaji jawina nyinku ngala nya-mangaji yalkuyi nyi-jaya aluwa linjikulinji-babala, ngala karna-nmala yiku marnaji. ");
INSERT INTO jao_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kurdardi karna-wanirru bajinju wunyathalu yilalu ngarnalumba, bardabarda yiku ki-yalkuyiyu. Jarna-rarrinji ngarna-wurdu nyamba-nykalanykarrinjarra wunyatha namba karna-ndayima nyangathi-anyira marnaji kulu karna-waninjima wunyathalu ngarnalumba, bardabarda yiku. Kurdardi karna-wardimarru awara yiku ki-malbuwu nganambaji.” ");
INSERT INTO jao_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Bawuji barra wunumbarra ka-rarrinma barra aluwalu ngala minja kumba-lumbuma baku na-wurdu. Winarrkululu kalili-ja winkandu li-mangaji li-jawina likungu, li-jibiya Yijiba, ngala alu likili-baba, baji kalu-arri arndaarnda, alulumba yilaa. Kulu bawuji barra kumbi-nu alunga liyikiliyi-babawu. “Ngarna barra, marningarna nyirrunga-anyira Jujiba.” ");
INSERT INTO jao_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Bawuji barra ka-rarri kalngiya kurdandu aluwalu kangka li-ja wurrbi likili-baba, arrkula alunga nyalunga-biyi, kurdandu ka-rarri. Kulu li-mangaji winkanda, li-jibiya Yijiba, wumba kala-nykarri rarrinjarra kulu kalu-lhaa yiwa nyamba-rarrinjarra liyikuliyi-babawu, kalu-lhaa kulu kala-ka jinangu wuka barra aluwa linji-jawinalu, linjiku ki-king, “Nya-mangaji barra jumba-rarrinji Jujiba, kangka bajalu barra likili-baba yilaa,” nganinya kalu-arri alunga liyiku. ");
INSERT INTO jao_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kulu yiwa barra Jujiba, ka-arri alunga liyikuliyi-babawu, “Kalngiya barra ngarna Jujiba. Kulu wayi barra wunyatha? Yabi bajiwa?” Ngala li-mangaji likili-baba, wumba kumbi-nu alunga kalngiya yiwa, kulu kalinyamba-kala nalu-mi, kulu kalu-ruwama yiku, kalu-wardanka barra kurdandu barra yiku, marnalu barra yilaa ki-Jujiba. Karnalu-linginma barra bajarnaji wabarrangu wumba kalu-wardimanthaninya awara yiku, bajarnaji barra kalu-wardanka nalu-wurdu yiku kurdandu. Kulu li-ja likili-baba, kurdardi barra kalinyamba-ngarninymanma yiku, kalinyamba-wama yiku wambu. ");
INSERT INTO jao_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kulu mili yurrulu ka-wukanyi alunga Jujiba liyikuliyi-babawu, “Marrirru, kirna-barlirra. Kawa rru-wingkaya wunumbarra ngathangkalu!” Kulu kalu-wingka barra yilalu wunumbarra. Kulu mili yurrulu ka-wukanyi, “Ngarna kalngiya Jujiba nyirrunga-anyira wumba kanhirri-jilima wabarrangu linji-ja aluwalu, karnala-ka karakarra wabarrangu, jilimanthalu marnaji Yijiba, kulu marningarna barra. ");
INSERT INTO jao_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","“Barni-wardirrinja rra-nmaya nirru-wurdu kulu barni-wanantha! Kulu barninyamba-yunduyundumantha rra-nmaya wumba kanhirri-ja bajarnaji wabarrangu. Ngala kurdardi yirru kanhirri-janma marnajinju ngala yiwa ki-Yijandu ki-Kud karnili-ja marnajinju barra, ambuliyalu yirrunga barra, ngarna yabimanthawu barra awara yirrunga marda wudurruwu barra, ngarna barra ngulngundayawu nganinya wumba nuwarnu-wirndajkuwu, yirru nmanthalu lhungku, yirru yabirrinjawu nirru-manka. ");
INSERT INTO jao_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","“Marnarnaji barra jinangu lhabayi ka-wayarrinji barra. Kulu yurrulu mili kambala-nmala kurdardi ki-lhabayiyu kanymarda kulu kanymarda arrkula yurrujurru kiwa-nmala kurdardi ki-lhabayiyu. ");
INSERT INTO jao_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yiwa kalngiya ki-Yijandu ki-Kud, karnili-ja barra marnajinju yirrunga ambirriju. Kulu ngarna barra karna-ruwama yiku ki-Kud kangka karnili-yibarra wirdiwalangu marnaji nungkarnu-wirndajku, ngarna ngulngundayawu ma-ngarra alunga liyirrungaliyi-ardubirriyu kulu liyirrungaliyi-nganjingku, liyirrungaliyi-murimuribirriyu, kurdardi barra wirndajkirrinjawu nganinyaji barra kangka yiwa barra ki-Yijandu ki-Kud karnili-yibarra marnaji. ");
INSERT INTO jao_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kurdardi yirru ngala yiwa. Yiwa barra karnili-yibarra wirdi marnaji. Yiwa kinga wirdi ambirriju ngathangka ngala ngarna ngulakari yilaa wirdi nyuwu-jawuthu ki-yumbulyumbumanthawu ki-awarawu, jarnini wirdi ngulakari yilaa alunga liyi-wuluwu liyi-jibiya Yijiba, alunga wiji. ");
INSERT INTO jao_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Yarlajka rru-waniya wunyathalu yilalu! Nyirri-naya ngandarra ja-arrinji awara marnaji! Nyirri-naya wunyatha ngatha, marningarna ngarna Jujiba, jarnini marnaji wirdi ki-awarala Yijiba. Karnili-yibarra ki-Yijandu ki-Kud wirdi nyuwu-ja ki-awarawu marnaji Yijiba. Kulu nyirri-naya ka-wingkala marnajinju ngathangkalu, wingkayawu marnajinju yarlajka. ");
INSERT INTO jao_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kulu karnilu-yabimala na-alanji baji Kujin, nguthundu awara, baji barra yiwa arrinjawu wunumbarra ngathangka, yiwa baki likili-ardu, likili-murimuri kulu nyiku yukularri marda nyiku buluki marda nya-mbangu yumbulyumbumantha wumba jiwini yilaa. ");
INSERT INTO jao_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","“Kulu yiwa baji barra Kujin, ngarna barra wudurrumanthawu wunumbarra likili-nganji. Baku barra yurrulu mili kanymarda kulu kanymarda kulu arrkula kiwa-nmala awara kurdardi lhabayiyu. Kalirna-wudurrumanthanama kulu kurdardi yiwa kulu likili-nganji anmanthawu wirndajku, marda nyiku yumbulyumbumantha buluki, jibi, kurdardi anmanthawu wirndajku,” nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kulu yurrulu ka-wukanyi alunga Jujiba, nganinya ka-arri, “Yirru barra wiji, janhirra-nganji ngarna, janhirra-lhaanji barra kalngiya ngarna Jujiba wukanyinjarra. Marda yinda, wunhaka, janha-nganjimu kalngiya ngarna Jujiba nyinki-baba. ");
INSERT INTO jao_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","“Nyirri-naya wunyatha, ngarna barra walkurrawala wunungu wirdiwalangu nyuwu-ja ki-awarawu wiji lukuluku marnaji Yijiba, kulu rru-arriya yiku jinawuthu yumbulyumbumantha wumba jirra-nganji marnaji! Nyirri-nalinaya barra jirra-ngalanganji awara yabi marringaya, nganinya barra rru-arriya yiku wunyathawu. Kulu nyirra-kaya yarlajka marnajinju ngathangkalu!” Ka-arri nganinya bawuji. ");
INSERT INTO jao_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kulu kilu-manha wakurlu wurrbi nyiki-anyira Binjamin, kulu ka-rarri yilalu, arrkula rrawulangarra-wibi, kulu marda yiwa Binjamin, kilu-manha, wumimbijilu babakula, marda yiwa ka-rarri yiku nganambajilulu. ");
INSERT INTO jao_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kulu nganambajilulu mili li-mangaji nalarrku likili-baba, nganambajilulu kalinyamba-rarri wumimbijilu, kulu kalilu-lhuji likili-baba wiji. Kulu bawuji barra kalinyamba-wukalukanyi barra yabi. ");
INSERT INTO jao_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kulu bawuji barra, jinangu barra wuka ja-wingka aluwalu barra, kalala-nykarri wumba kumbi-nu Jujiba alunga liyikuliyi-babawu linji-mangaji winkanda, kala-ka wuka barra yilalu ki-king. Kali-nu nya-mangaji barra king kulu ka-yabirri na-wurdu, kilu-barlirra Jujiba, marda wiji li-jawina likungu ki-king marda, kalu-yabirri nalu-wurdu alunga. ");
INSERT INTO jao_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kulu king, ka-arri yiku ki-Jujiba, “Linyi-naya barra linkili-baba, jalirni-jirrinymanji nganinya. Nyalu-yabilyabimaya awara alunga, nyalu-yibalyibarraya awara ki-yirrikirrila, alu waninjawu bajinju ki-awaralu nyungkalunga Kinin. ");
INSERT INTO jao_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kulu alu rdumanthawu nyalunga-biyi kulu lalungali-ardu wingkayawu marnajinju, alu lalungali-nganji wiji. Kulu kalirna-ngundarra awara marnaji Yijiba, nya-mangaji awara marringaya, yabi awara alunga marda kalirna-ngundarra, marda ma-ngarra alunga ma-jakarda, alu anmanthawu wudurru yurrngumantha. ");
INSERT INTO jao_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kulu linyi-naya jalirni-jirrinymanji mili, nyala-kaya wilbarra aluwa nakaringu marnajingu Yijiba, liyalungaliyi-ardubirriyu, kulu liyalungaliyi-nhanawawu kulu marda nyuwirrunga-biyiyu. Lu-wingkaya aluwa marnajinju. ");
INSERT INTO jao_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","“Kalinyi-nala nganinya, barninyamba-nykalanykarrinja nyuwu-mangajiwuthu ki-awarawu baji, kanthawu marnajinju! Wambu wandi baji nya-mangaji yumbulyumbumantha, wambu wandi! Yamulu kalirna-ngulngundarra awara marnaji, kalngiya marringaya ki-Yijiba awara kalirna-ngulngundarra,” nganinya ka-arri king yiku ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kulu ki-Jikaba likili-ardu, nganambaji barra kalu-arri. Kulu ki-Jujiba, kalilu-ngunda wilbarra wumba kalila-ngunda ki-king, kulu marda ma-ngarra alunga, alu nyamba-wudurrumanthawu rru-yabalawu alunga. ");
INSERT INTO jao_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kulu kalilu-ngulngunda marringaya jumbala ruthuruthu, ngala wakulamba yiwa nyiki-anyira kilu-ngunda kurdandu jumbala marda ma-jakarda ma-mani yiku nyiki-anyirawu. ");
INSERT INTO jao_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kulu marda kili-ja marda yiku nyiki-biyiyu, mili ruthuruthu 10-bala yirrikirri ji-munhama barra awara marrimarringaya yumbulyumbumantha kulu rrarrku mili a-10-bala a-yirrikirri nandayirdi wudurruwu barra ma-jakarda ma-ngarra ma-burlurlu, wudurru yiku nyiki-biyiyu. Jinangu barra wudurru alunga kili-ja, nuwarrku yiku nyamba-wudurrumanthawu baji akarru baki nuwarrku yiku nyamba-wudurrumanthawu baku ngaliwa karakarra wumbiji wu-yabalangka ngaliwa ka-lhuwarrila karakarra. ");
INSERT INTO jao_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kulu kalili-ja barra likili-baba, kalilu-murdama, kulu kalili-jirrinyma, “Barninyamba-mirirrinja yabayabala!” ");
INSERT INTO jao_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kulu kalu-lhuwarri bajingu Yijiba bawuji. Akarriya kalu-wingka...i nyala bajinju, kalu-yibanda baji nyungkalunga-biyila ki-Jikaba, baji Kinin. ");
INSERT INTO jao_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kulu kalu-wukanyi yiku, “Ngabinya biyi! Bajiwa nyinki-ardu Jujiba, nyala lhungku bajiwa Yijiba. Bajiwa kalngiya wirdiwalangu alunga liyi-wuluwu liyi-jibiya Yijiba, alunga wiji. Nyinki-ardu bajiwa yamulu!” Kulu ka-wurdulanba, ka-ngajbirri alunga. “Ngandarra yaa!” ");
INSERT INTO jao_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngala kalu-wukanyi barra yiku mili jinangu wuka wumba yiwa Jujiba ka-wukanyi alunga, nya-mangaji barra wuka kalu-wukanyi yiku nyuwalunga-biyiyu. Kulu nganinya ka-warnkanga, kila-kala barra nya-mangaji wilbarra wumba kili-ja yiku, yiwa wingkayawu yilaa barra nyungku-mangaji bajinju Yijiba. Kulu ka-yabirri na-wurdu kurdandu, kulu na-ngawulu ka-mirlilmirlilirri. ");
INSERT INTO jao_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Nyangathi-ardu Jujiba, bajiwa ngatha lhungku,” nganinya ka-arri. “Ka-yabirri barra ngatha awara. Karna-wingkala barra nganthalu yiku ngalingarna lhungku,” ka-arri nganinya bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jikaba barra, Yijrayil nya-mangaji, kilu-yibalyibarra awara wiji nyikungu, kulu kalu-lhuwarri barra ngamaliya bajinju ki-awaralu Biyajiba. Ka-wingka barra bajinju, yiwa wukanyinjawu ankaya ki-Yijanku ki-Kud. Ka-arri baji janyka, kilu-linginma nyulu-mangaji janyka wumba kilu-rdarlbirra ambuliyalu nyungkiku-biyilu ki-Yajika. Kulu ki-Jikaba kilu-yibarra ankawa buyuka kulu lhangka yilaa ki-buyukala kilu-rama barra jibi kilu-yibarra, kilu-wabija baji yiku ki-Kud, kilu-wabija bawuji. Bajingu ka-wukanyi barra ki-Yijanku ki-Kud, jinangu Yijan Kud nyikungu nyiki-biyiyu ki-Yajika marda. ");
INSERT INTO jao_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kulu ka-arri walkurr baji wundururra barra, kulu kilu-mawuranga awara. Kila-nykarri Kud, ka-wukanyi yiku kalngiya kila-nykarri yiwa wundururra. Kulu ka-wajba yiku, “Jikaba! Jikaba!” “Yiya, marningarna,” nganinya kumba-ngarninyma. ");
INSERT INTO jao_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Ngarna Yijan, nyinki-biyiyu ki-Yajika,” nganinya ka-arri. “Barni-wardankaya wingkayawu bajinju Yijiba. Ngarna karna-yabimala awara. Li-mangaji linkili-nganji ngulakari yindaa, kala-nmala barra linkungu, li-jakarda nalu-miji kala-nmala ki-awarala baji. ");
INSERT INTO jao_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kulu ngarna, karna-lhakanbala yindaa bajinju Yijiba, kulu baku ngulakari linkili-nganj i nakaringu yindaa nalu-miji, kariya kalirna-waninjangumala marnajinju nyungku-ja ki-awaralu. Kulu nya-mangaji Jujiba, ka-nmala yindaa ngalinda kinyamba-mirrala baku,” nganinya ka-arri Kud. ");
INSERT INTO jao_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bajingu Jikaba, malbu Yijrayil nya-mangaji, ka-lhuwarri nakaringu Biyajiba. Kulu likili-ardu, kalu-yibarra yiwa barra kulu lalungali-ardubirri kulu lalungali-wangu kalalu-yibarra nyungku-mangaji barra ki-wilbarrala ki-kanymakanymarda wumba kili-ja ki-king nakaringu Yijiba alunga. ");
INSERT INTO jao_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Kala-ka buluki nyalunga, jibi, yukularri, bawuji nya-mbanguwuthu yumbulyumbumantha nakaringu nyungkalunga ki-awarala Kinin, wiji kala-ka aluwa. Nganinya barra kalu-yibanda baji Yijiba, Jikaba, likili-ardu kulu likili-murima barra, li-nhananhanawa kulu li-mayamayani, ka-lhakanba bajinju malbu nayirdi alunga wiji. ");
INSERT INTO jao_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Kulu ki-Jikaba yiku li-jakarda barra likili-ardu kulu likili-murima. Li-ja barra likili-ardu andaa wu-Liya, kalu-yanjarri baji ki-awarala nguthundu, lankili-ardu andaa wu-Liya: jina wirdi Rubin, kulu ngulakari yilaa Jimiyan, kulu ngulakari yilaa Libayi, kulu ngulakari yilaa Juda kulu ngulakari yilaa Yijaka, kulu ngulakari yilaa Jibulun, marda a-nhanawaya yikurra-ardu ki-Jikaba a-Dayina, li-ja barra lankili-ardu wu-Liya, likili-ardu ki-Jikaba. Kulu li-ja barra lalungali-ardu, likili-murima ki-Jikaba: li-ja likili-ardu ki-Rubin: jina wirdi Yanuka, kulu ngulakari yilaa Balu, kulu ngulakari yilaa Yijrun, kulu ngulakari yilaa Kami, li-ja likili-ardu ki-Rubin. Li-ja barra likili-murima ki-Jikaba marda, likili-ardu ki-Jimiyan: jina wirdi Jimuwil, kulu ngulakari yilaa Jamin, kulu ngulakari yilaa Wuwad, kulu ngulakari yilaa Jakin, kulu ngulakari yilaa Juwa, kulu ngulakari yilaa Jawul, yikurra-wibi a-jibiya Kinin, li-ja barra likili-ardu ki-Jimiyan. Li-ja barra likili-murima ki-Jikaba marda, likili-ardu ki-Libayi: jina wirdi Kirijun, kulu ngulakari yilaa Kuwatha, kulu ngulakari yilaa Mirari, li-ja barra likili-ardu ki-Libayi. Li-ja barra likili-murima ki-Jikaba marda, likili-ardu ki-Juda: jina wirdi Jila, kulu ngulakari yilaa Birij, kulu ngulakari yilaa Jirra, kulu kawulamba-mirra baji Kinin nawularrku rrikirri-ardu Yira kulu Wunan, kawulamba-mirra baji. Marda rrikirri-murima ki-Juda, rrikirri-ardu ki-Birij, jina wirdi Yijrun, kulu ngulakari yilaa Yamul, li-ja barra likili-ardu kulu rrikirri-murima ki-Juda. Li-ja barra marda likili-murima ki-Jikaba, likili-ardu ki-Yijaka: jina wirdi Dula, kulu ngulakari yilaa Buwa, kulu ngulakari yilaa Jajuba, kulu ngulakari yilaa Jimurun. Li-ja barra likili-murima marda ki-Jikaba, likili-ardu ki-Jibulun: jina wirdi Jirid, kulu ngulakari yilaa Yilun, kulu ngulakari yilaa Jalil, li-ja barra likili-ardu ki-Jibulun. Kulu li-ja barra wiji likungu ki-Jikaba, li-ja barra nakaringu andaa wu-Liya wumba kanumba-kulhakulhama baji Badanarama, li-33-bala, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Kulu ki-Jikaba yiku, rri-ja barra rrikirri-ardu andaa wu-Jilba, a-mangaji a-jawina anku wu-Liya, kandu-ngunda anmanthawu walkurr yilaa ki-Jikaba rrungkiku-wangu wu-Liya. Rri-ja rrikirri-ardu wu-Jilba barra: jina wirdi Kida, kulu ngulakari yilaa Aja. Kulu li-ja barra likili-ardu ki-wirdiyu ki-Kida: jina wirdi Jibiyun, kulu ngulakari yilaa Yaki, kulu ngulakari yilaa Juni, kulu ngulakari yilaa Yijbun, kulu ngulakari yilaa Yiri, kulu ngulakari yilaa Yarudi, kulu ngulakari yilaa Arili. Kulu li-ja barra likili-ardu ki-buriyu ki-Aja: jina wirdi Yimna, kulu ngulakari yilaa Yijba, kulu ngulakari yilaa Yijbi, kulu ngulakari yilaa Biraya, kulu ngulakari yilaa rra-Jira rralungarra-anyira. Kulu mili rri-ja barra rrikirri-ardu ki-Biraya, nyiki-murima ki-Aja, nyiki-ardu ki-Jikaba: rri-ja barra rrikirri-ardu ki-Biraya: jina wirdi Yibira kulu ngulakari yilaa Malkiyal. Kulu li-ja barra wiji likungu ki-Jikaba, li-ja barra nakaringu andaa wu-Jilba, a-mangaji a-jawina wumba ki-Liban kayilu-ngunda rruwikurru-arduwu wu-Liya, li-ja nakaringu andaa wu-Jilba, li-16-bala bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Kulu ki-Jikaba rikuwangu a-Rijil, ankurra-anyira wu-Liya, kanumba-kulhakulhama kanymardawujara rri-mayani: jina wirdi Jujiba, kulu ngulakari yilaa Binjamin. ");
INSERT INTO jao_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kulu nya-mangaji Jujiba, baji Yijiba, kumba-kajakajama kanymardawujara rri-mayani, jina wirdi Manaja, kulu ngulakari yilaa Yibrayim, kulu rrawulangarra-wibi a-mangaji rra-Ajinada, yikurra-ardu ki-Budibira, yiwa mingirringki nyu-jawuthu Yijanku, baji ki-barrawula ki-Wuna, yikurra-ardu barra a-mangaji rrawulangarra-wibi wulanga rriyikirri-arduwu ki-Jujiba. ");
INSERT INTO jao_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kulu li-ja barra marda likili-murima ki-Jikaba, likili-ardu ki-Binjamin: jina wirdi Bila, kulu ngulakari yilaa Bikira, kulu ngulakari yilaa Ajbil, kulu ngulakari yilaa Kira, kulu ngulakari yilaa Naman, kulu ngulakari yilaa Yiyayi, kulu ngulakari yilaa Ruja, kulu ngulakari yilaa Mubima, kulu ngulakari yilaa Yubima, kulu ngulakari yilaa Arda, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Li-ja barra wiji likungu ki-Jikuba nakaringu andaa wu-Rijil, li-14-bala, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Kulu ki-Jikaba yiku, rri-ja barra rrikirri-ardu andaa wu-Bila, a-mangaji a-jawina anku wu-Rijil, kandu-ngunda anmanthawu walkurr yilaa ki-Jikaba wu-Rijil rrungkiku-wangu: jina barra wirdi Dana, kulu ngulakari yilaa Nabaduli. Jina barra nyiki-murima ki-Jikaba, nyiki-ardu ki-Dana, jina Yujima. Kulu li-ja barra likili-murima ki-Jikaba, likili-ardu ki-Nabaduli: jina wirdi Jajil, kulu ngulakari yilaa Kuni, kulu ngulakari yilaa Jijira, kulu ngulakari yilaa Jilima bawuji. Li-ja barra wiji likungu barra ki-Jikaba nakaringu andaa wu-Bila barra, a-mangaji a-jawina wumba ki-Liban kayilu-ngunda rruwikurru-arduwu wu-Rijil, li-ja barra nakaringu andaa wu-Bila, li-7-bala, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kulu li-ja barra likili-ardu ki-Jikaba kulu likili-murima, li-ja barra yilaa wiji kalu-arri li-66-bala, kalu-wingka nakaringu Kinin bajinju Yijiba. ");
INSERT INTO jao_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kulu nya-mangaji Jujiba marda rrikirri-ardu, alu wiji kalu-arri baji Yijiba, li-70-bala bawuji bajalu likungu ki-Jikaba, kulu mili yurrulu kalu-arri baji likungu marda 11-nhananhanawa li-jakarda, alu wiji bawuji. ");
INSERT INTO jao_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kulu malbu barra Jikaba, kili-ja nyiki-ardu Juda ambirriju yilalu ki-Jujiba kulu ka-arri yiku, “Wunhaka! Bajiwa wunyatha ngulakari, jiwini wumbiji wingkayawu bajinju Kujin. Kumbi-ja na-mulu yindalu, yinda wingkayawu bajinju kinya-ngala baji Kujin.” Kulu alu barra, kalu-yibanda ambuliyalu baji barra, Kujin kalu-yibanda. ");
INSERT INTO jao_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kulu kalila-nykarri ki-Jujiba kalu-yibalyibanda kulu ka-wingka aluwalu barra riyungkiku ki-wilbarrala. Ka-wingka barra yilalu nganthalu. Ngala wunumbarra barra kila-kala nyiki-biyi, ka-wuluma yilalu, kilu-manha wakurlu nyiki-biyi, nyiki-biyi kilu-manha wakurlu barra kulu kumba-rarri yilalu baku, baji ka-arri rarrinjarra yilaa nyiki-biyila. ");
INSERT INTO jao_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kulu yiwa, malbu Jikaba, nya-mangaji Yijrayil, ka-wukanyi yiku nganinya, “Bawuji barra, kirna-kala barra yabi marninda lhungku ngatha. Kirna-kala marninda, kalngiya nda-manka, kirna-kala barra bawuji. Marningarna barra ndiwi jarnini ngarna nyamba-mirranthawu barra, yabi ngarna-wurdu.” ");
INSERT INTO jao_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kulu Jujiba, ka-wukanyi alunga liyikiliyi-babawu kulu liyikiliyi-nganjingku marda, “Bawuji barra waluku ngarna yilalu, nanthalu ki-king yilalu. Kirrirni-nala barra yiku, wiji marnirru nakaringu ki-awarala Kinin, kirru-wingka ngathangkalu. ");
INSERT INTO jao_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kulu kirrirni-nala barra yirru, yirru barra jirru-yukulyukuma jibi marda buluki, ambuliyalu kulu marnirru. Kirra-ka buluki, jibi, yukularri, kulu yumbulyumbumantha. ");
INSERT INTO jao_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","“Kulu namba baku, namba kumbi-jala na-mulu yirrunga, namba kirrilu-yalbangala ngalhi jabungka kirru-arri kulu kirru-wukanyila nganinya yiku, ‘Nganu barra, janu-yukulyukuma buluki yurrngumantha, linganungali-nganji ambuliyalu nganinya kalu-yukulyukumanthaninya nganinya, kulu nganu barra barranamba alu barra,’ nganinya kirru-arrila yiku. Namba kirru-wukanyila nganinya, kirrinyambi-nala yiku, kulu ka-yabirrila na-wurdu yirrunga, yirru anmanthawu baji barra Kujin. Kirralu-lhaala yirru likili-nganji yiku ki-bulukiyu, kulu yumbulyumbumanthawu, ruthu jirrini nungkarnirrunga. Kangka li-ja, li-jibiya Yijiba, jalu-ngalngandayi liyi-mbangu liying an jiyu wumba jalini yukulyukumantharra jibi alunga, jalu-ngalngandayi wakulamba, jalu-walardankayi alunga. Kirra-nmala baji barra Kujin yamulu, bijal juju alunga, kirra-nmala yamulu,” nganinya ka-arri alunga liyikuliyi-babawu, b awuji. ");
INSERT INTO jao_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kulu bajingu barra kalila-ka ki-Jujiba, kalila-ka nyiki-biyi baki likili-baba yilalu, nganthalu king. Kulu yiwa barra yiwalumba ka-wingka ambirriju arndaarndalu barra. Ka-wukanyi barra yiku ki-king, kalili-nu yiku likili-nganji barra, nganinya ka-arri; “Wirdi! Wunyatha kulu alu lingathili-baba, kalu-wingka karakarra nakaringu Kinin. Kala-ka marda aluwa nyalunga jibi kulu buluki kulu yukularri kulu yumbulyumbumantha bawuji nyalunga. Kulu kalu-yibanda bajalu Kujin,” nganinya ka-arri yiku. ");
INSERT INTO jao_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kulu kalilu-rduma likili-baba li-5-bala, kalila-ka bajinju yilalu ki-king, kalilu-yunduyunduma barra. ");
INSERT INTO jao_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kulu kalili-yalbanga barra ki-king, “Marrirru! Ngandarra barra yirru jirribiya jabungka baji akarru, ngandarra?” Kulu alu barra kalinyamba-ngarninyma yiku, “Wirdiwalangu! Nganu kana-ninya jabunka, kanu-yukulyukumanthaninya jibi wiji nya-nganunga. Li-mbangu linganungali-nganji li-wankala, nganambajilulu kalu-yukulyukumanthaninya, kulu nganu nganinyanga. ");
INSERT INTO jao_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kulu kanu-wingka barra marnajinju nyunku-ja ki-awaralu, kanu-wingka nmanthalu baku, kangka kurdardi wudurruwu yiku ki-jibiyu alunga wiji, ka-rukurri awara wiji baji ki-awarala Kinin, kurdardi barra ki-wudurruwu barra baji yurrngumantha. Wirdiwalangu, kirna-barlirra, kaninya-ngundarra awara, niwarrku awara baji Kujin, nganu anmanthawu baji,” nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kulu yiwa barra king, ka-wukanyi yiku ki-Jujiba, “Karna-yabirri ngarna-wurdu alunga nyinki-biyiyu kulu linkili-babawu, kalu-wingka yindalu. ");
INSERT INTO jao_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kulu yinda, ngalkingundayarra winarrku awara alunga, nya-mbangu awara marringaya alunga! Linya-ngundarra! Kulu baji barra la-nmaya mingkiya nguthundu Kujin, ki-marringayala ki-awarala. Namba nalarrku linkili-nganji marda li-mingkin ki-bulukiyu, kulu linya-yibarraya li-wirdi nmanthawu ki-bulukiyu ngatha yukumantharra,” ka-arri yiku nganinya. ");
INSERT INTO jao_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Bajingu barra ngulakari kila-ka ki-Jujiba nyiki-biyi yilalu ki-king kulu kilu-yunduyunduma. Kulu nyiki-biyi Jikaba, kilu-yalbanga ankaya Yijan Kud, yiwa mirlilmirlilmanthawu awara yiku ki-king, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kulu king, kilu-yalbanga malbu, “Ngabinya! Nganthimbala yinda ka-yanjarrinyu?” ");
INSERT INTO jao_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kumba-ngarninyma yiku Jikaba, “Wirdi! Ngarna wabarrangu linji-wankala karna-yanjarri, kulu karnala-nda nyala marningarna lhungku. Kulu karna-wingkalwingkayaninya lukuluku bajiwuthu ki-lhabayila nyungku-mbangu ngulakari kulu nyungku-ja ambirriju, karnilu-mirrinyma ki-lhabayilu kulu nyala marningarna. Karna-wingkayaninya kiwa-ninya budijbudij awara ngatha. Ambuliyalu barra ngarna-yalkuyi karna-arri aluwa linjingathalinji-nganjinya, bajingarnaji barra ambuliyalu. Alu barra kala-ninya li-yalkuyi nalu-manka yurrujurru, ngala ngarna barra, karna-arri yalkuyi ngarna-manka buyi bawuji. Marningarna warriya luku barra, jarna-malburrinji bawuji, 130-bala lhabayi ngatha,” nganinya ka-arri yiku ki-king. ");
INSERT INTO jao_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kulu Jikaba, kilu-murdama king, mili yurrulu wukanyinjarra ankaya ki-Yijanku ki-Kud, yiwa mirlilmirlilmanthawu awara yiku ki-king. Kulu ka-lhuwarri, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kulu nyungku-ja barra ki-Jujiba, kalila-ka likili-nganji kulu nyiki-biyi nguthundiya bajinju barra ki-awaralu Kujin, Kujin marda Ramiji na-wini, kanymarda. Kalilu-ngunda awara, nya-mangaji barra nguthundu, marringaya alunga nuwalarrkulu liyi-jibiya Kujin, kalngiya marringaya barrawumba kili-jirrinyma ki-king. Kulu marda yiwa barra ka-arri baji aluwa yabilyabimantharra awara alunga barra na-alanji, alu anmanthawu baji. ");
INSERT INTO jao_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kulu kalilu-ngulngunda ki-Jujiba ma-ngarra barra alunga, alunga nyiki-biyiyu kulu liyikiliyi-babawu, alunga liyikiliyi-nganjingku wiji. Kalilu-ngunda ma-ngarra alunga liyi-ardubirriyu kulu liyi-wurrirriyu, bawuji. Ngaliwa kilu-wayatha na-alanji alunga kulu ka-wani barra bajingu ngamalakarilu, yilalu ki-king. ");
INSERT INTO jao_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bajingu barra ku-wayarri mili yurrulu barra ma-ngarra lukuluku nyungku-mangaji ki-awarala, wiji bawuji kalu-arri wirndajku, waraba wudurruwu. Kulu li-wulu, li-jibiya baji Yijiba kulu li-mangaji li-jibiya Kinin, wiji bawuji kalu-arrkama nalu-manka wirndajku. ");
INSERT INTO jao_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kulu Jujiba, kilu-rdulurdumanthaninya ma-mani nakaringu aluwa...i, nu-miji kilu-rduma namba kalu-bayimanthaninya ma-ngarra yilaa yurrngumantha, kulu ma-mangaji ma-mani kilu-yibalyibarranthaninya arndaarnda ki-barrawula yiku ki-king, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ngulakari barra ku-wayarri ma-mani alunga liyi-wuluwu, li-mangaji baji Yijiba baki baji Kinin, kangka kalu-wayatha ambuliyalu wiji alunga ma-mani rdumantharra ma-ngarra. Kulu kalu-wingka barra yilalu ki-Jujiba yalbanganthalu wudurruwu, bardabarda mu-maniyu. Kulu nganinya kalu-arri, “Ngabinya! Nganinya-ngundarra wudurru! Barni-ndaya nganunga, kaninyamba-mirranma baji wirndajku! Anmaya nganinya yabimanthawu awara nganunga, kangka ku-wayarri barra ma-mani nganunga, kurdardi kuwima marlijinda nganuwa, kalngiya kurdardi.” ");
INSERT INTO jao_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kulu Jujiba barra yiwa, ka-wukanyi alunga, “Marrirru! Namba kurdardi yirrunga mu-maniyu kulu nyirra-kaya nya-mangajiwuthu buluki, yukularri, wawi, baki yirrikirri! Nyirra-kaya ngathangkalu wiji, kulu kirru-rdumala barra ma-ngarra barra nyungku-mangajiwuthu. Nganinya barra kirrirna-ngundarra ma-ngarra yirrunga, yirrunga wudurruwu,” nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kulu bajingu barra kalu-rdulurduma nyungku-jawuthu barra, kalu-rdulurduma barra wiji bulukibirri kulu yukularri, yirrikirri kulu wawi. Bawuji barra kala-ka yilalu. Jabarri kalilu-ngunda barra wudurru alunga nganinya. Baji barra kalu-rduma ma-ngarra alunga nganinya, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kulu mili yurrulu lhabayila kalu-wani mili yilalu, kulu nganinya kalu-arri, “Ngabinya, kurdardi kaninyamba-wajkirrarru yinku ngala minja kaninyambi-nala yinku barra, marninganu winarrku kanu-wingka yindalu, kalngiya bardabarda. Ku-wayarri barra ma-mani nganunga ambuliyalu, kulu ngulakari mili ka-wayarri buluki, wawi, yukularri, yirrikirri barra bawuji, kirninganu-ngunda bawuji. Kalngiya kurdardi barra kiwima nganuwa. Marninganu barra janini nganu nganu-manka, ngayamantharra barra awara nganuwa badiki bajiwa, bawuji barra. ");
INSERT INTO jao_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","“Barni-ndaya nganunga nyamba-mirranthawu! Nya-yabimaya awara nganunga! Kulu marninganu janu-wardirrinji nganu-wurdu kangka kurdardi wanjirru kulu kurdardi nu-mi yirdardinjawu ki-awarala nganunga. Winarrku barra kana-nmala yiku ki-king li-jawina winarrku, kulu kirninganu-ngundarra barra awara badiki. Nganinya kana-nmala, kulu yinda barra ngundayawu nganunga ma-ngarra kulu nu-mi yibarranthawu. Winarrku barra kana-nmala li-jawina yiku ki-king, nganu barra rdumanthawu ma-ngarra winarrku, nganinya barra winarrku kaninyamba-wudurrumanthanama nganu arrinjawu lhungku,” nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kulu Jujiba barra, kilu-rdulurdumanthaninya awara wiji baji barra Yijiba, ki-king yiku kilu-rduma. Kulu li-mangaji li-jibiya Yijiba lukuluku baji, winarrku barra kalu-jilima awara nyalunga kangka ku-wayarri ma-ngarra, alu barra rdumanthawu wudurru. Kulu wiji barra nya-mangaji awara kilu-rduma barra wiji ki-king kulu ka-arri nyikungu ki-king. ");
INSERT INTO jao_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Kulu alu barra li-jibiya baji Yijiba li-wulu wiji, kalu-arri li-jawina yiku ki-king, li-mangaji lukuluku nyungku-mangaji ki-awarala, likungu barra kalu-arri winarrku. ");
INSERT INTO jao_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ngala nya-mangaji awara alunga liyi-mingirringkiyu, kurdardi kalilu-rdumanma nya-mangaji awara aluwa, kurdardi. Yamulu ma-mani bajawu aluwa rdumanthawu ma-ngarra yamulu, kangka yurrngumantha ki-king, kalilu-ngulngundayaninya ma-mani yurrngumantha. Kurdardi kalu-jilimanma nyalunga awara linji-mangaji, kurdardi. ");
INSERT INTO jao_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kulu Jujiba barra, mili yurrulu ka-wukanyi alunga liyi-wuluwu, nganinya ka-arri, “Marrirru! Bawuji barrungku karna-bayima awara wiji nakaringu yirruwa, bawuji barra jinangu awara nyikungu ki-king. Marda barra yirru, kirrirna-bayima, kirra-nmala likungu li-jawina ki-king bawuji. Kulu nganinyanga barra jirrirna-ngundayi ma-ja barranamba ma-kingirra. Nuwarrku kirru-rarrmala kulu nuwarrku nu-mi kirru-yibarrala. Kirru-wanila barra yibalyibarranthawu ki-awarala barra, yiwa yirdardinjawu barra wudurru. ");
INSERT INTO jao_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","“Kulu baku barra ngalawu ma-ngarra ku-yirdardila, kulu nuwarrku mirrunga kulu nuwarrku mikungu ki-king. Nganinya nuwarrku kirru-ngundarra king ngala nuwarrku ma-jakarda kuwa-nmala yirruwa, nganinya kirru-ruthuruthumala ma-mangaji yurrngumantha yiku ki-king kulu yirrunga nganinya. Kulu ma-mangaji mirrunga ma-ngarra, nuwarrku nyamba-wudurrumanthawu kuwa-nama yirrunga, yirrunga liyirrungaliyi-nganjingku, liyi-wurrirriyu baki liyi-ardubirriyu, ngala nuwarrku barra mili yibarranthawu nu-mi baku,” nganinya ka-arri alunga. ");
INSERT INTO jao_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kulu kalinyamba-ngarninyma yiku, “Wirdiwalangu, kirna-barlirra barra! Kaninya-marakamanhu, kulu kinyu-yabimanhu awara nganunga, nganu anmanthawu li-lhungku. Kalngiya barra janinyamba-riyarrabanji wakulamba yinku. Yiya, nganambaji barra kana-nmala li-jawina yiku ki-king,” nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kulu ki-Jujiba, kilu-yibarra jinangu, narnu-yuwa karnilu-yibarra nyuwu-mangaji ki-awarawu Yijiba nganinya. Nuwarrku ma-ngarra yiku ki-king kulu ma-mangaji nuwarrku ma-jakarda alunga liyi-wuluwu, nganinya kalu-ruthuruthumanthanama ma-ngarra linji-wulungku yurrngumantha. Kulu na-mangaji narnu-yuwa karnu-arri alunga narnu-yurrngu baji. Kulu awara wiji nyikungu awara ki-king. Ngayamantharra liyi-mirringkiyu, nyalunga awara ka-arri wambu. ");
INSERT INTO jao_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ngala li-ja barra li-wulu, likili-nganji ki-Jikaba, nya-mangaji Jikaba baki Yijrayil na-wini, li-mangaji kalalu-wundarrba likili-nganj i ki-Yijrayil. Kulu kala-ninya baji barra Yijiba, ki-awarala Kujin. Kulu yurrulu barra mili ka-arri awara alunga kurdandu barra yumbulyumbumantha, kalu-arri barra li-wurrama, marda li-jakarda li-ardubirri alunga, kalu-yanjarri baji nyungku-mangaji ki-awarala. ");
INSERT INTO jao_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kulu nya-mangaji barra malbu Jikaba, ka-arri yurrulu nyarrku 17-bala lhabayi ka-arri baji, kalngiya malbu, 147-bala lhabayi barra yiku. ");
INSERT INTO jao_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Kulu bawuji barra kumba-nykalanykarri barra yiwa wunumbarra nyamba-mirranthawu, kulu ka-wukanyi alunga liyikuliyi-arduwu, alu rdumanthawu Jujiba. Kulu ka-wingka bajinju Jujiba yilalu barra nyiki-biyilu ngaliwa baji arndaarnda lhulunda. Ka-wukanyi barra malbu yiku, Kajakaja! Kawa wunumbarra ngathangkalu kulu nganha-nykarriya! Kajakaja, kirna-barlirra, kurdardi kanha-kurramarru ngarna-manka marnaji ki-awarala Yijiba, kurdardi, ngala kanha-waninjangumala ngarna-manka akarriya bajinju ki-awaralu nyungku-ngatha Kinin, baji barra wunumbarra aluwa linjingathalinji-nganjinya wumba kalinyamba-mirra ambuliyalu. Baji barra aluwa kanha-yibarrala nganinya, nganha-yibarraya ngarna-manka baji. Kulu nyamba-yibarraya nda-marliji rarrama ngathangka kariwajka kulu nganinya nganhi-naya kalngiya barra yabimantharra, yinda anmanthawu ngayangaya ngatha!” Kulu Jujiba, kumba-ngarninyma yiku, “Biyi, bajingarna jirna-nykarrinji, ngayangaya karna-nmala yinku.” ");
INSERT INTO jao_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kulu yurrulu mili ka-wukanyi Jikaba yiku, “Kawa kajakaja! Nyamba-yibarraya nda-marliji ngathangka rarrama, kulu nganambaji barra nganhi-naya!” Kulu Jujiba, kumba-yibarra na-marliji, mili yurrulu barra ka-wukanyi yiku, yiwa waninjangumanthawu barra bajinju nyungkiku ki-awaralu Kinin. Kulu Jikaba, ka-yabirri na-wurdu yiku, kulu kilu-barlirra ankaya Yijan Kud yabimanthawu awara yiku nganinya, ka-arri baji, mududu barra, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kulu baku barra, malbu Jikaba, kumba-mirra bawuji, ngalalu likili-ardu kalu-arri baji yilaa kumba-mirra bawuji kurdan. Kulu Jujiba, kumba-walima wajkaliya na-manka nyiki-biyila yilaa lhangka. Ka-rarri kurdandu yiku, kilu-lhuji. Nganinya ka-rarri baji, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kulu ka-alarri barra, kumba-lumbuma na-wurdu, kulu kalili-jirrinyma li-jawina likungu li-maralnguji, alu yabimanthawu na-manka ngabangaku, yiwa anmanthawu yabi barni-wurrungkayawu ngalalu kalakantharra akarriya bajinju ki-Kinin. Kulu li-mangaji li-maralnguji, kalu-yabima ngabangaku, kalu-yibarra na-mirdijin na-mangaji yabimanthawu ki-ngabangakuwu nyiki-biyiyu ki-Jujiba, yiwa kurdardi wardirrinjawu. ");
INSERT INTO jao_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kalu-arri baji jabunka nganinya li-maralnguji arrkula ngakarla kulu buyi ngakarla, na-40-bala na-wunbarr, barranamba kala-ninya jabungka li-mangaji nganinya yurrngumantha ki-ngabangakuwu baji. Kulu li-mbangu li-jibiya Yijiba, kalu-rarri yiku ki-ngabangakuwu kanymarda ngakarla kulu buyi ngakarla, na-70-bala na-wunbarr. Bawuji. ");
INSERT INTO jao_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Bajingu yiwa Jujiba, kili-ja wuka yiku ki-king nganinya, ka-arri alunga liyi-jawinawu yiku ki-king, “Marrirru, kirna-barlirra. Kirru-wingkala yilalu ki-king, kirru-yalbangala ngatha barra nganinya. ");
INSERT INTO jao_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kirri-nala ngatha, nyangathi-biyi, ngaliwa lhungku, kumba-lhaa wunumbarra nyamba-mirranthawu kulu karnili-jirrinyma, ngarna waninjangumanthawu na-manka akarriya bajinju Kinin, ngarna yibarranthawu na-manka baji nungku-ajinjala wumba kilu-yabima wabarrangu. Kulu karni-nu, ngarna anmanthawu kalngiya ngayangaya yiku nganinya. Kirru-yalbangala king, yiwa wirranganthawu ngatha, ngarna lhuwarrinjawu nganinya, ngarna kurramanthawu ki-ngabangakuwu wurrbi baji bawuji. Kulu bajingu karna-wanila yarlajka karakarra. Nganinya kirru-yalbangala king ngatha barra, kirrirna-barlirra.” ");
INSERT INTO jao_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kalu-yalbanga king kulu kumba-ngarninyma, “Jarni-janji ngarna-mulu yiku ki-Jujiba nganinya, ‘Ngabinya! Lhuwarriya ankaya bajinju ki-Kinin kurramanthalu ngabangaku barranamba kirnili-nu! Anmaya ngayangaya yiku nganambaji!’” Kulu kali-nu Jujiba barra. ");
INSERT INTO jao_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kulu ka-lhuwarri ankaya kurramanthalu nyiki-biyi na-manka baji akarru Kinin. Kalu-lhuwalhuwarri alu li-jawina yiku ki-king, li-malbumalbu li-mbangu wumba kala-ninya yilaa ki-king, marda nalarrku li-malbumalbu li-jibiya Yijiba, alu wiji barra. ");
INSERT INTO jao_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Kalu-wingkalwingka yilaa ki-Jujiba mili alu likili-nganji ki-malbuwu, likili-baba ki-Jujiba marda li-mbangu nalarrku li-wulu likili-nganji wiji. Minja kalu-arri wambu li-nhanawa kulu li-ardubirri, kulu buluki, jibi, yukularri kala-nda baji wambu Kujin ngala kalu-lhuwalhuwarri li-wulu wiji kurramanthalu. ");
INSERT INTO jao_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Baki nalarrku kalu-wingkalwingka aluwa naluyirdi ki-wilbarrawu kulu ki-wawiyu, alu wiji nalu-rarrawumba kalu-lhuwalhuwarri...i akarriya bajinju Kinin. ");
INSERT INTO jao_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kulu wumbiji kalu-yibalyibanda ki-awarala, na-wini awara Kurina-Adad. Bajarnu na-wulangi karinguthunda, narnu-wini Judin, kulu baji barra barrawu Kurina-Adad wulanginda barra akarrakarimba. Bawuji barra kalu-arri baji rarrinjarra...i, na-kanymarda kulu kanymarda kulu kanymarda arrkula na-wunbarr, bawuji. Nganinya kalu-rarri yiku ki-ngabangakuwu. ");
INSERT INTO jao_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kulu kalu-arri baji akarimba li-mbangu, li-jibiya Kinin. Kalala-nykarri rarrinjarra, kalala-kala li-mangaji nalu-rarrawumba, kulu kalinyamba-wukanyi, “Ayi! Kalngiya jalu-rarrinji wakulamba, jalu-rarrinji kurdandu barra li-mangaji li-jibiya Yijiba, bajalu akarrakarimba.” Kulu li-mangaji, ngulakari kalu-wundarrba mili nya-mangaji awara akarrakarimba Abil-Mijrayima, kalu-wundarrba nya-mangaji awara akarru wulanginda nganinya kangka kalu-rarri baji li-mangaji nalu-rarrawumba, li-jibiya Yijiba li-mangaji. ");
INSERT INTO jao_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kulu li-mbangu, likili-ardu ki-ngabangakuwu, kalu-arri ngayangaya yiku kalngiya barranamba kalili-nu, ");
INSERT INTO jao_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","kulu kala-ka mili aya, kalu-lhuwarri nungku-wulanginda aya bajinju Kinin. Kulu kala-ka nyala bajinju ki-awaralu Makibila, nya-mangaji awara akarrunga ki-awarawu Mamuri, kala-ka bajinju nungku-ajinjalu, na-mangaji na-ajinja wumba ki-Yiburama kilu-rduma badiki baji wabarrangu alunga kurramanthawu. Li-mbangu li-wulu li-Yidaj kala-ninya baji, nyalunga awara barra, kulu ki-Yiburama kilu-bayima badiki nakaringu ki-arrkulangka ki-Yidaj, na-wini mirningiya Yibruna. Kulu bajarnu ki-badikila na-mangaji na-ajinja alunga kurramanthawu, kulu kala-ka ngabangaku bajinju, kalu-yibarra baji arndaarnda wambu bawuji, kulu nganinya likili-ardu kalu-arri ngayangaya yiku. ");
INSERT INTO jao_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kulu kalu-walwani alu wiji barra karakarra, kalu-lhakalhakanba aya...i yurrngumantha, kalu-walwani bajingu Yijiba, bawuji. ");
INSERT INTO jao_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bawuji barra kulu likili-baba ki-Jujiba, kalinyamba-wukanyi yiku ki-Jujiba kulu kalu-wardanka yiku kurdandu. Kalinyamba-wukanyi nganinya, “Kumba-mirra ngambalanga wunyatha, bawuji ngambalalumba kambalila-nda. Nungka bajiwa Jujiba wardirrinjawu na-wurdu ngambalanga, nungka ja-yinjathirrinji na-wurdu ngambalanga. Wabarrangu kambala-wardima awara yiku wakulamba. Nungka nganinyanga, jabarri kilu-wardimanma awara ngambalanga kangka marningambala ngambalalumba.” ");
INSERT INTO jao_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Bajingu kali-ja wuka yiku ki-Jujiba, kalu-wukanyi yiku nganinya, “Wunhaka, ngaliwa lhungku nyinki-biyi, kambalili-jirrinyma nganinya, ‘Nyirri-naya Jujiba, “Nyamba-yabimaya nda-wurdu alunga liyi-ja liyinkiliyi-babawu! Kalngiya kalu-wardima awara yinku wakulamba ngalinda nda-yalkuyi ngala nyamba-yabimaya nda-wurdu alunga nuwu-mangaji nuwarnu-wardiyu!’”, nganinya ka-wukanyi wunyatha. ");
INSERT INTO jao_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Kulu ngambala marda, kirninganu-yalbanganji, kirna-barlirra wunhaka, nyamba-yabimaya nda-wurdu nganunga nuwarnu-wardiyu nuwarnu-nganunga. Marninganu barra li-jawina likungu ki-Yijan ki-Kud barranamba wunyatha jawina nyikungu marda,” nganinya kali-ja wuka yiku ki-Jujiba. Kila-nykarri ki-Jujiba, kulu ka-rarri barra alunga kangka kalu-arri nganinya yiku. ");
INSERT INTO jao_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kulu kalu-wingka yilalu likili-baba, kulu kala-nba yilalu mududu, kulu kalu-arri, “Wirdi, marninganu li-jawina linkungu, li-ngayangaya yinku.” ");
INSERT INTO jao_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ngala Jujiba, ka-arri alunga, “Barni-wardankaya rra-nmaya! Kurdardi Kud ngarna, ramanthawu yirrunga wirangu nuwarnu-wardiyu, kurdardi. ");
INSERT INTO jao_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yirru barra wabarrangu, kalngiya kirrinyamba-nykalanykarri wardimanthawu awara ngatha, ngala yiwa Yijan, bajingulaji barra, kalngiya kumba-nykalanykarri yabimanthawu awara, yabimanthawu alunga liyi-wuluwu, nalu-rarrawumba winkanda. Narnu-wirndajku karnu-arri, kalngiya narnu-wirndajku narnu-wardi, ngala kurdardi kambalamba-mirranma. Marningambala nyala nyamba-wudurrumantharra, nyala lhungku. Karnila-ka marnajinju ki-Yijandu, ngarna marakamanthalu wudurru, ngarna wudurrumanthalu li-wulu wiji. ");
INSERT INTO jao_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Barni-wardankaya rra-nmaya ngatha! Kirrirna-wudurrumanthanama yirru lirrungali-ardu,” nganinya ka-wukanyi alunga, yabimanthawu nalu-wurdu, mirlilmirlilmanthawu nalu-wurdu bawuji. ");
INSERT INTO jao_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Kulu Jujiba, kiwa-ninya baji barra nambalu 110-bala lhabayi yiku. ");
INSERT INTO jao_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Kulu rrikirri-arduwujara ki-Jujiba, Manaja wula Yibrayim, kawula-arri alinda baji Yijiba, kawulamba-kajakajama. Kulu Jujiba, kalila-kala likili-ardu baki likili-murima ki-Yibrayim, kila-kala mili Makira nyiki-ardu ki-Manaja, kulu likili-murima ki-Manaja marda, kalila-kala li-ja likungu. ");
INSERT INTO jao_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bawuji barra, jinangu Jujiba, kumba-lhaa wunumbarra nyamba-mirranthawu. Ka-wukanyi alunga liyikiliyi-babawu, ka-arri nganinya, “Marningarna barra, marningarna wunumbarra nyamba-mirranthawu, marnaji Yijiba. Ngala Kud jambalila-nganji karanka, ngambala li-jawina likungu, kulu nungkarnarrku baku kirrila-kala marningu, kirrilu-waninjangumala akarriya bajinju ki-Kinin, nya-mangaji awara wumba kalili-nu yiwa ngundayawu alunga, alu Yiburama, kulu nyiki-ardu Yajika nyangambalanga-murimuri, kulu nyangambalanga-biyi Jikaba, kalili-nu ki-Kud yiwa kalngiya ngundayawu jinangu awara alunga kulu liyalungaliyi-nganjingku nakaringu aluwa. Kulu nganinya barra kirrilu-waninjangumala akarriya bajinju. ");
INSERT INTO jao_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","“Kulu yirru, nganhirri-naya kalngiya, namba kirrilu-waninjangumala bajinju ki-Kud, kulu yirru karnilu-waninjangumala ngarna-buyu marningu, karnila-kala ngarna-buyu bajinju, yibarranthalu baji nyungku-ngatha ki-awarala.” Kalilu-maramarama nganinya kulu kalu-ngayama yiku. ");
INSERT INTO jao_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Bawuji barra kulu kumba-mirra Jujiba, kalngiya malbu, 110-bala lhabayi yiku. Kulu kalu-yabima na-manka ngabangaku, yiwa anmanthawu yabi barni-wurrungkayawu, kalu-yabima linji-mangaji linji-mankarnilu wumba kalu-arri mirdan nyuwu-mangajiwuthu. Kalu-yibarra ki-larlangka barra, kalu-yibarra ki-larlangka bajingulaji Yijiba, nganinya kalu-arri, bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Kulu ka-arri arrkula na-wini mirningiya Yilimilika, kumbu-ngka Yibratha. Ka-arri baji mayangka, wirndajkumba, kurdardi wudurruwu. Riku-wangu nanda-wini a-Niyumi, rrikirri-arduwujara kanymardawujara, nyarrku na-wini Malun kulu nyarrku na-wini Jiliyan. Kalu-arri ki-barrawula Bidiliyima ki-mayangka Juda baji Yijrayil, li-jibiya baji kalu-arri. Kalu-yibaka bajingu wumba wirndajku awara, akarriya kalu-wingka nyungkarrku ki-awarala, ngabiyala Muwab. Baji kanalu-rama na-alanji, kalu-arri baji. ");
INSERT INTO jao_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Kalu-arri baji baki malbu kumba-minmirra kulu kumba-mirra. Kanda-arri andalumba a-Niyumi nandayirdi ankirri-arduwujaranguwu. ");
INSERT INTO jao_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Kulu rri-mangaji, kawula-arri alinda rri-mbangu nhanawawujara nyuwu-mangaji ki-awarawu Muwab, nawula-wini rra-Wuba wula a-Rutha. ");
INSERT INTO jao_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Baku baku ngulakari, na-10-bala lhabayi, mili kawulamba-minmirra, wula barra ankirri-arduwuj ara wu-Niyumi, kawulamba-minmirra kulu kawulamba-mirra. Andalumba kanda-arri nandayirdi wulanga rriyi-kayibanthaandalu, andalumba kanda-arri, bardabarda nyuwanku-wanguwu kulu rriyankurri-arduwu, bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Baku barra ngulakari kanda-nykarri wuka wu-Niyumi, kanuraba-yarraka bajingu, kanda-nykarri wuburr na-miji ngabiyala baji barra nungkanku ki-awarala, kangka Wirdiwalangu, Wirdiwalangu kalu-wundarrba nya-mangaji Yijan Kada, kilu-yabima awara barra ki-Wirdiwalangu ngundayarra ki-wuburru alunga. ");
INSERT INTO jao_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Bawuji kulu kanumba-yarraka. Nakaringu Muwab kanda-lhuwarri bawuji nandayirdi wulanga rriyi-kayibanthaandalu, kanda-lhuwarri waninjalu bajinju Juda. Kalu-wingka aya, alu barra mardamarda. ");
INSERT INTO jao_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ngala wumbiji kanumba-yangama, kanda-arri wulanga, “Marrimbala! Bawuji kimbala-wanila marnajingu rrinjimbalangarrinji-wibilu. Jarna-wukanyinji ki-Wirdiwalangu ankaya, yiwa yabimanthawu awara yimbalanga barranamba yimbala kimbala-arri yabi ngatha marda wulanga rriyingatharriyi-arduwu wumba kawulamba-mirra. ");
INSERT INTO jao_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Baku ki-Wirdiwalangu kilu-yabimala awara yimbalanga, nmanthawu alinda, nganinya janyarna-yalbanganji ankaya yimbalanga.” Kawulanda-lhuji baki kawulanda-murdama, kulu kawula-rarri andalu wakulamba, karrawula-manmarralanga wakulamba. ");
INSERT INTO jao_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Kulu kawula-arri, “Kurdardi barra katharra wanirru. Wambu katharra-nmala yindaa, linjinkulinji-nganjinya marda ngatharra, kurdardi ngatharra katharra-wanirru.” ");
INSERT INTO jao_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","13","Ngala kanda-arri a-Niyumi, “Bawuji kimbala-wanila. Ngalhiyu jimbala-wingkayi ngathangka? Kurdardi barra kimbala-wingkarru ngathangka. Kurdardi mili yurrulu karnamba-kulhakulhamarru, yimbala anmanthawu alinda nganinyaji kangka wulambalu jarna-bardibardirrinj Namba karna-nmanjima majkarra lhurrku wundururra, namba karnamba lhakalhakarranjima bardardawujaranguwu mayaniwujaranguwu baku, kurdardi kimbala-yukumarru wulanga yirdardinjawu, kangka yurrujurru kawula-yirdardi yili. Kurdardi kimbalamba-ngibarru yukumantharra wulanga, kurdardi. Kilu-wardima nyu-Wirdiwalangu awara ngatha kulu jarna-rarrinji yimbalanga ngarna-wurdu.” ");
INSERT INTO jao_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Mili wula barra kawula-rarri andalu. Kulu rra-ja rra-kayibandaanthalu nanda-wini a-Wuba, karrandu-lhuji nyamba-murdamanthawu. Kanda-ngayama anda waninjawu bajinju linjankulinji-nganjinju. Ngala rra-ja rra-Rutha, wambu kanda-arri andaa. Kalngiya kurdandu karrandu-manmarralanga, anda wingkayawu nganambaji andaa rrungkankurru-yuwarnila. ");
INSERT INTO jao_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kulu a-Niyumi kanda-wukanyi anku wu-Rutha, “Yuwarni, bawuji rra-kayibanthangathangkalu barra, janda-lhuwarrinji a-ja, yinkurra-milkamba, janda-waninji aluwalu linjankulinji-nganjilu kulu jingkanku yi-yijandu. Marda yinda, bawuji waniya andaa!” ");
INSERT INTO jao_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ngala a-ja a-Rutha kanumba-ngarninyma, “Kurdardi kanha-yalyarrungkarru nganinya, ngarna ndayawu yinda, ngarna waninjawu nakaringu yindaa, kurdardi. Karna-ma yindaa, kurdardi kirna-ndarru. Karna-wingkala nganambaji yindaa yurrngumantha lurrulurru. Ka-lhuwarrila nambiwuthu kulu karna-wingkayama nganambaji yindaa lurrulurru yurrngumantha. Namba ka-nmala walkurr, kulu ngarna mili karna-nmala walkurr yindaa nungkinku nungku-alanjila nganambaji. Linkili-nganji kala-nmala kulu mili ngarna lingathili-nganji. Nyinkungu Yijan Kada kulu kiwa-nmala nyangatha Yijan. ");
INSERT INTO jao_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Namba kinyamba-mirrala kulu ngarna karnamba-mirrala marda jingkinku ji-awarala, nungkarnarrku karnamba-mirrala bajingulaji. Namba kirnalu-kurramala kulu ngarna marda karnalu-kurramala baji yindaa. Kurdardi kirna-ndarru. Ngali barra, arrkula kali-wingkala, marda nyungkarrku ji-awaralu, ngali arrkula.” Kulu a-Rutha mili kanumbi-nu, “Jarna-yalbanganji ankaya Wirdiwalangu nganinya, ‘Namba kirna-ndayima kulu nganambaji mili karnilu-ramanjima wakulamba nyu-Wirdiwalangu, wakulamba ki-wardirrinjima barra ngatha awara,’ nganinya jarna-yalbanganji. Ngala yurrngumantha karna-nmala yindaa nganambaji.” ");
INSERT INTO jao_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kulu a-Niyumi barra, karrandu-lhaa wakulamba, kanda-arri mirdan anku barra wu-Rutha, kurdardi karranda-ndarrma, kalngiya karrandu-lhaa, kulu a-Rutha kanda-wingka andaa barra. Kulu a-Niyumi, kurdardi yurrulu kanda-wukanyinma anku, barni-wuka kanda-arri wambu. ");
INSERT INTO jao_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Bajingu Muwab kulu kawula-wingka barra aya bajinju Bidiliyima. Kawula-wingka...i wula a-kayibanthaandalu, bajinju Bidiliyima, wula barra. Ngala li-ja barra, li-wulu li-jibiya baji, alu wiji kalu-ruwama anku wu-Niyumi, kalu-ruwama wulanga. Kulu li-nhanawa, kalu-arri, “A-ngani rra-ja, a-ngani, marrirru? Nungka rra-ja a-Niyumi, andalaya barra?” ");
INSERT INTO jao_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ngala anda kanda-wukanyi alunga, “Kurdardi nganinya kanyirru-wundarrbarru a-Niyumi kangka bajarnaji Niyumi barranamba yabi, ngala nganhirru-wundarrbaya a-Mara kangka marnarnaji Mara narnu-dabudaburr ni-wini. A-Mara nganhirru-wundarrbaya kangka nyungku-ja nyu-Wunungulu nyu-Yijandu nyu-Kada, karnilu-ngunda bajarnaji narnu-dabudaburr, dabudaburr awara ki-arri ngatha,” nganinya kanda-wukanyi alunga. ");
INSERT INTO jao_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","“Ngalingarna marnaji karna-arri ambuliyalu, jakarda ki-arri awara ngatha, jakarda, kulu kariya karna-wingka akarriya. Karna-wani nakaringu bajingu Muwab, bardabarda barra, winarrku jarnini kangka kalngiya ki-wardirri awara ngatha. Kilu-ngabiya ngatha nyu-Wunungulu nyu-Kada barranamba dabudaburr awara ki-arri ngatha. Kulu marningarna barra, karna-wani marnajinju, karnilu-waninjanguma karakarra, karnilu-waninjanguma barra nyu-Wirdiwalangu, kurdardi barra awarawu ngatha, bardabarda. Ngala barni-wundarrbantha ngatha ngarna-wini a-Niyumi ngala winarrku nganhirru-wundarrbaya a-Mara kangka dabudaburr awara ngatha ki-arri.” Kanda-arri nganinya kangka kanumba-nykalanykarri nganinya nanda-wurdu ngalanda waninjarra bardabarda bajinju. ");
INSERT INTO jao_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Kulu nganinyaji barra a-ja barra a-Niyumi kanda-wani, nganinya kawula-wani karakarra ki-awaralu barra, wula barra, anda barra a-mangaji a-kayibanthaandalu, a-jibiya Muwab. Kawula-yibanda baji barra barrawula Bidiliyima ngalalu kalinyamba-yanirri rdumanthalu ma-ngarra ma-bali, ma-mangaji ma-bali barranamba ma-kingkirra. Kalinyamba-wukanyi li-wulu, “Bawuji ngambala wajkaliya rdumanthalu ma-mangaji ma-ngarra ma-bali, bajawu ndiwi malumanjawu,” kalu-arri nganinya bajarnaji wumba kawula-yibanda baji Bidiliyima. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Baji Bidiliyima kalu-arri lankili-nganji wu-Niyumi. Arrkula bajiwa, jina barra mirningiya, na-wini Buwaj, baji ka-arri nyungku-mangaji ki-awarala wirdi nyuwu-mangaji ki-awarawu, danyawiji, kulu mirningiya nyiki-nganji wunumbanyngu ki-Yilimilika wumba kumba-mirra akarru, jinangu barra. ");
INSERT INTO jao_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","A-ja a-Rutha, a-nganji alunga, nakaringu Muwab, kanda-wukanyi anku wuwankurru-yuwarniyu, karrandu-yalbanga a-Niyumi, “Bawuji karna-wingkala ngandarra wajkaliya bajinju, mujinjalu ma-ngarra barra ma-bali, li-mangaji wumba jalini jabungka baji wumba jala-ndayi nuwarrku ngulakari. Nungka bajiwa nya-arrkula karnilu-wirrangarru ngarna mulmujinjarra ma-mangaji ma-bali, nungka karnilu-jirrinymala, ‘Warriya wakaya kangka kala-nda nuwarrku,’” kanda-arri nganinya anku. Kanda-ngayama anku, kanda-arri, “Yamulu barra, yuwarni. Narnu-yabi barra wingkaya nganambaji rdumanthalu ngalinga.” ");
INSERT INTO jao_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Baki kanda-wingka, karrandi-ja barra wu-Niyumi nambiwuthu kulu a-Rutha kanda-wingka minja bajinju nyungku-mangaji ki-awaralu, nya-mangaji badiki baji ka-arri wumba nya-mangaji kalu-yirdardinjangundayaninya, ma-ngabiya ma-bali baji. Nya-mangaji awara badiki niwarrku nyikungu ka-arri ki-mirningiyawu na-wini Buwaj, nyiki-nganji ki-Yilimilika nya-mangaji. Kulu kanda-arri barra baji, bawuji jabungka kanda-wingkayaninya ngulakari aluwa mujinjarra namba nuwarrku wumba kala-ndayaninya. Kiwa-nbayaninya nakaringu aluwa ngalalu rdumantharra, ngalanda ngulakari kanda-wingka rdulurdumantharra. ");
INSERT INTO jao_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Baki baku barra ka-wingka barra walkurrawala mirningiya Buwaj, ka-lhakanba nakaringu Bidiliyima. Kulu kalila-kala likungu li-jawina. Ka-arri alunga, “Marrirru, marnajingarna. Wirdiwalangu bajiwa yirruwa yurrngumantha.” Kulu kalinyamba-ngarninyma yiku, “Ki-Wirdiwalangu kirnilu-mirlirlmirlirlmala.” ");
INSERT INTO jao_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kulu ka-warnkanga baki kayila-kala a-ja mili a-Rutha, baji ngulakari aluwa jabungka. Baki kilu-yalbanga nya-mangaji nyikungu wirdi wumba kalilu-jirrinymanthaninya nuwarnu-jabuwu, kilu-yalbanga nganinya, “A-ngani baji rra-mangaji? A-nganthangu a-mangaji a-nhanawaya?” ");
INSERT INTO jao_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","“Yiya,” ka-ngayama nya-mangaji mirningiya, “A-mangaji rra-nganji, a-yalkuyi nakaringu nyungkarrku ki-awarala. A-mangaji kanda-wingka andaa wu-Niyumi ngalanda kanda-wani karakarra nakaringu Muwab. ");
INSERT INTO jao_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","“Karnandu-yalbanga anda wingkayawu ngulakari aluwa linji-mangaji wumba jalini jabungka rdirrirrantharra ma-bali kurarra baji, mujinjawu ma-bali anku. Kanda-arri jabungka wungkuwungkulamba, kanda-arri nirrinjarra i...i yurrngumantha, ngala minja bajanda jandini mingkiya nganduwa waluku,” ka-arri nganinya nya-mangaji mirningiya nyikungu ki-Buwaj. ");
INSERT INTO jao_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ka-wingka andalu Buwaj bajinju, baki ka-wukanyi anku, “Ngabiyarra! Nganha-nykarriya! Bawuji barra ka-nmala marnaji jabungka yurrngumantha. Barni-lhuwarrinja marnajingu, barni-yibakantha nyungkarrku ki-awarala ki-badikilu nambiwuthu nungkalarrku. Marnaji biya aluwa linji-ja linji-nhanawala linji-jawinala, anmaya marnajingulaji. ");
INSERT INTO jao_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","“Linya-nganthani nganthiwuthu jalini jabungka. Bajingulaji anmanthani aluwa, nirrinjarra ngulakari. Jirna-yibarranji ngarna barra, kangka ngarna wirdiwalangu jarnini barra marnaji. Kulu karna-arri alunga, kurdardi kirnalu-wardimarru linji-wulungku. Namba wabuda, barni-wardankaya wunjayawu jinangu wabuda wumba kalu-kurda! Wunjayani baji linji-ja nungkalarrku,” ka-arri nganinya anku. ");
INSERT INTO jao_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kanda-ruwama yiku, yiwa yabimanthawu awara nganinya anku, kulu kanda-arri mududu wajkaliya awaralu nyamba-yibarranthawu a-buyi yiku, kulu kanda-wukanyi nganinya, “Ngalhiyu barra jinyamba-nykalanykarrinjimu ngatha yabimanthawu awara? Ngalhiyu jinyu-yabimanjimu awara ngatha nganinya, ngarna rra-nganji?” ");
INSERT INTO jao_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Kumba-ngarninyma, “Yiya, kirna-nykarri, kirna-nykarri kangka yinda barra ka-arrinyu andaa wu-Niyumi yurrngumantha ngalinda a-miyaji, ka-arri yurrngumantha andaa, baji barra nyungku-ja ki-awarala, nganambaji kirna-nykarri. Kulu wumba kalinya-ndanhu nyinki-biyi kulu yinkurra-wibi, kalinya-ndanhu wambu. Ngala yurrngumantha karra-mirlirlmirlirlmanhu, ka-arrinya andaa yinkurra-yuwarnila. Kinya-ndanhu awara, ka-wingkanhu nyungku-ja ki-awarala ki-nganjinyu. Kulu marninda barra andaa yurrngumantha jimu. Kurdardi kinyamba-nykarrinjima, kurdardi ka-nmanma aluwa akarru, andaa rrungkinkurru-wibila, nganambaji kinya-ndanhu awara, yinkurra-wibi, nyinki-biyi, kangka kalinya-ndanha wambu, ngala yurrngumantha ka-arrinju andaa. Kulu marninda barra ki-nganjinya ki-awarala, nganuwa linji-nganj inya. ");
INSERT INTO jao_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Kulu bajingu jarna-yalbanganji yinku ankaya Wirdiwalangu, yiwa yabimanthawu kulu mirlirlmirlirlmanthawu nda-wurdu, yiwa ngundayawu ngabiya narnu-yabi narnu-jakarda yinku, yiwa ngundayawu nganinya, nya-mangaji Yijan alunga liyi-Yijrayilaja, Yijan nganunga, wumba kinyamba-yibarra nda-wurdu yilaa, yiwa kunkunmanthawu yinku anmanthawu Yijan yinku.” ");
INSERT INTO jao_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Kanumba-ngarninyma a-Rutha, “Kirna-barlirra ngabinya, nya-yabi jimu ngatha, janha-yabimanjimu ngarna-wurdu. Yinda barra nya-walkurrawala, ja-wukanyinjimu ngatha narnu-yabi barra ngalingarna marnajingarna a-nganji, minja a-buyi. Kurdardi karnima a-jibiya marnaji yinkurra-nganji barramarni li-ja li-jawina linkungu, kurdardi, ngala minja ngarna a-nganji a-buyi, ngala ja-wukanyinjimu ngatha yabimantharra, janha-yabiman jimu ngarna-wurdu, kirna-barlirra,” kanda-arri nganinya, bawuji. ");
INSERT INTO jao_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Bawuji barra jinangu barra mukunjarna kalinyamba-wudurrumanha kulu Buwaj barra ka-yibanda. Baki ka-wajba anku wu-Rutha, “Kawa wingkaya marnajinju!” Kanda-wingka bajinju baki kilu-ma ma-ngarra anku baki karrilu-ngunda. “Nyamba-wudurrumaya ma-ja ma-burlurlu, baki lhakarraya marnaji wajka, marnaji ma-ja nyungku-ja ki-ngilinya.” Baki kandu-lhakarra ki-ngilinya, kanumba-wudurruma. Kulu kandu-yibanda aluwa linji-mangaji linji-jawinala. Baki yurrulu mili ki-Buwaj karrilu-ngunda ma-mangaji ma-bali ma-wunhunhu. Kanumba-wudurruma wakulamba, kulu bawuji kanda-ngayama. Baki kandu-yibarra nuwarrku wambu baku anku wu-Niyumi, kanda-wuluwuluma kangka kanumba-wudurruma wakulamba bawuji, karrilu-wudurruma yiwa ki-Buwaj. Kanda-yabirri, kanda-mirlirlmirlirlirri nanda-manka bawuji. ");
INSERT INTO jao_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kanda-lhuwarri barra yurrulu, anda mujinjawu. Baki ki-Buwaj, kalili-nu li-jawina likungu ngalalu kalu-arri ngulakari barra ngalalu kalinyamba-wudurruma bawuji, ngalalu kalu-lhuwalhuwarri barra bawuji jabungku yurrulu, baki ka-arri alunga, “Rra-ja a-nhanawaya rrirra-karra. Kanda-rdumanthanama ngulakari yirruwa, nganambaji wumba ma-mbangu jirra-ndayi ngulakari. Namba kurdardi kanda-wingkanma ngulakari, namba nu-wurun kanda-nirrinjima wunumbarra yirruwa wumba jirru-rdirrirranji kurarra, barni-mirirrinja anku, wambu rrirra-ndarra nirrinjarra. ");
INSERT INTO jao_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","“Marda rri-rrbundayani bajingu nakaringu mungkirrunga, namba kirri-rrbundayanama anku nirrinjawu, barni-ngabiyantha, barni-mirirrinja anku. Yirru wirranganthani nganambaji rdumantharra,” ka-arri nganinya nya-mangaji Buwaj. ");
INSERT INTO jao_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Bawuji baku barra ngabungabula kanda-arri jabungka barra baji kulu kanda-nba a-kamba barra aya, ngabungabula barra ngalanda barra kandu-rduma nu-lhangka bawuji. Kulu kandu-rama barra baji, nu-mi awunbayawu wajkaliya lhulundu, kandu-rama barra baki wakulamba, ku-matha bawuji. ");
INSERT INTO jao_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kulu kanda-ka barra ankaya birndawarawiji barra alanjilu rruwankurru-yuwarniyu anku, baji ki-barrawula. Kulu kanda-yunduyunduma ma-ngarra wumba kanda-nirri. Kulu karrandu-rduma nuwarrku ma-ngarra nakaringu mukunjarna, ma-wunhunhu karrandu-ngunda. ");
INSERT INTO jao_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Kulu a-Niyumi, kanda-yabirri nanda-wurdu, kanda-arri, “Yaa! Ngantha baji kuwu-rdumanhu ma-ja ma-ngarra nu-rarrawumba? Jingki-nganthangu ji-badikila ka-arrinyu jabungka? Janyarna-yalbanganji ankaya, nyu-Wirdiwalangu kanyilu-mirlirlmirlirlmala nya-mangaji nya-mirningiya wumba kiya-arri yabi yinku nganinya.” Kanda-arri a-Rutha anku nganinya, “Baji karna-arri jabungka barrungku jingkiku nyu-Buwaj,” kanda-arri nganinya anku. ");
INSERT INTO jao_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ngala a-Niyumi kanda-yabirri nanda-wurdu wakulamba, kanda-arri, “Janyarna-yalbanganji ankaya, nyu-Wirdiwalangu kanyilu-mirlirlmirlirlmala nya-mangaji nya-mirningiya niya-manka, kalngiya wakulamba. Barranamba nya-Wirdiwalangu kiya-wukanyi alunga liyi-mbangu ambuliyalu liyi-wuluwu, yiwa yabimanthawu awara, barranamba kilu-yabimanji awara awara ngulakari ngalalu jalini liyi-lhungkuwu; ngalalu kalinyamba-mirra bawuji ngaliwa yabimanthawu awara mili barranamba ka-wukanyi alunga liyi-mangaji wumba kalu-arri li-lhungku. Jilu-yabimanji awara ngalinga, nya-marringaya jiwini nya-Wirdiwalangu,” nganinya kanda-arri a-Niyumi. Mili kanda-arri, “Nya-mangaji barra nya-Buwaj, kalngi nyangambalanga-nganji nya-mangaji, nya-mangaji arrkula aluwa, alu kunkunmanthawu ngalinga rriyi-miyajiyu.” ");
INSERT INTO jao_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","A-Rutha kanda-wukanyi, “Kalngiya nya-marringaya kiya-arri ngatha, ngarna mujinjarra nu-wurun yurrngumantha ma-ngarra aluwa linji-mangaji wumba jalini jabungka kulu baku ngalalu kalu-wayathala rdumanthawu baji.” ");
INSERT INTO jao_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","A-Niyumi kanda-wukanyi anku, “Yiya, a-kayibanthangathangkalu, narnu-yabi nganinya jimu jabungka, aluwa nungkalarrku linji-yibuwunyarrala jabungka ki-badikila nyikungu ki-Buwaj. Barni-wingkaya nungkalarrku nambiwuthu, kangka kirnalu-wardimanma linji-wulungku nungkalarrku.” ");
INSERT INTO jao_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kulu a-Rutha, kanda-arri jabungka aluwa linji-nhanawala linji-jawinala likungu ki-Buwaj, kanda-arri mujinjarra ma-ngarra barra nganambaji, ma-mangaji ma-bali ambuliyalu, kulu marrku ma-wid, ma-mangaji barranamba ma-kingkirra marda, kanda-nirri ngalalu kalu-rduma ma-mangaji ma-wid ngulakari bawuji. Kulu kanda-ninya nungku-alanjila andaa rrungkankurru-yuwarnila yurrngumantha bawuji. ");
INSERT INTO jao_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Baku barra mili kanda-wukanyi a-Niyumi anku wu-Rutha, “Yuwarni! Bawuji ka-nmala alinda bawuji Karnamba-nykalanykarri yinda nmanthawu alinda, nya-mbangu nyinku-wangu yiwa kunkunmanthawu yinku, kanda-arri anku nganinya. ");
INSERT INTO jao_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","3","“Nya-mbangu nya-mirningiya wumba yirru kirru-arri jabungka arrkula, yinda marda kulu nalarrku li-yibuwunyarra, yirru kirru-arri jabungka yilaa, nya-mangaji barra nyangambalangany nganji kunkunmanthawu awara ngalinga,” kanda-arri anku a-Niyumi nganinya. “Nganha-nykarriya! Bawuj barra anmaya, nya-rdumaya yinku jumbala marringaya ngaburra, nya-yibarraya marringaya nya-mbangu mankanda yindaa, nya-mbangu wulwurrungkayarra, kulu nyamba-yulyulbaya nya-mangaji jumbala. Kangka ngabungabula kilu-ngabiyala, baji kiwa-nmala aluwa linjiku linji-mbangu linji-jawinala aluwa, kalila-nganjama baji ruthuruthumantharra nu-mi ma-bali. Bawuji wingkaya namba kinya-ngala aluwa baji, kulu barninyamba-mirnimantha yiku. Nya-karra nakaringu winkanda jujunyngu, mili kirnila-nganma baji, barni-ngantha yiku wa-nmaya. Namba kanilu-wayathala nyamba-wudurrumantharra baki wunjayarra, baku nya-wirrakarra nganambaji. Nganambaji kiya-wunjala baki kumba-wudurrumala ngalinda baku wajkirrantha. ");
INSERT INTO jao_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Baku nya-wirrakarra nambiwa kumbi-jarra wajkaliya, yinda mili ka-wingkala ngulakari. Kinya-rankarrmala bilangki yilaa ngulakari marndaa, kulu ka-ngalbala yilaa wirrbanya. Baku nambiwa kirnila-ngala namba kulu kirnili-nala ngandarra anmanthawu baku, yiwa kirnili-nala.” ");
INSERT INTO jao_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Baki kanda-arri anku wu-Rutha, “Yiya, kirna-barlirra, narnu-yabi. Karna-ngayamanji barra bajuwarnu. Karna-arrila barra nganinya wumba yinda janhi-nanjimu, nyinkungu wuka jirna-kanji.” Bawuji. ");
INSERT INTO jao_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kulu a-Rutha, kanda-lhakanba bawuji bajinju nyungku-mangaji ki-awarala wumba rrungkankurru-yuwarnilu karrandi-nu, ngaliwa Buwaj barra ka-arri baji nyamba-wudurrumantharra. ");
INSERT INTO jao_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Kumba-wudurruma kulu ka-wunja, ka-mirlirlmirlirlirri na-manka, bawuji. Ngaliwa baj barra ma-bali ku-arri, ma-arrkula ma-lija ku-arri barra baji, ku-arri ma-mangaji ma-ngarra rdalbu, baki ka-wingka walkurru baji wunumbarra. Ka-arri walkurr. Ngalanda a-Rutha ngantharra yiku kumbi-ja, kulu anda barra ngulakari mili kanumba-lhabalhabanyma wingkayarra, kanda-arri walkurrwalkurr baji yilaa wirrbanya ngulakari. Kandu-rankarrma bilangki, kanda-ngalba yilaa arndaarnda bilangkila, kanda-arri baji walkurrwalkurr, yukumantharra yiku wumba ka-lhuwarri. ");
INSERT INTO jao_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ngala baku mili wumbuwumbiji kila-nykarri ngalhi baji yilaa wirrbanya, baki ka-lhuwarri ankaya, kilu-malmanha nganinya awara kulu karrilu-manha nganinya, “A-nhanawaya ngathangka, rra-ja walkurrwalkurr,” kumba-wukanyi nganinya na-wurdu. Bawuji anda mili lhungku kulu kanda-lhuwarri. ");
INSERT INTO jao_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Karrilu-yalbanga, “A-ngani baji yinda?” Ka-arri anku nganinya. “Ngarna a-Rutha, a-ngayangaya yinku,” kanda-arri yiku. “Kangka yinda barra nyalunganya-nganji liyi-mbangu wumba ki-ngubalirri ngatha bujibuji, yinda kunkunmanthawu ngatha, ngarna anmanthawu yindaa alinda, kirna-barlirra, karna-nmala yabi barra alinda yindaa, karnandi-ja nganinya wu-Niyumi.” ");
INSERT INTO jao_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bawuji barra ka-wukalukanyi nganinya barra anku, “Jarna-yalbanganji ankaya, ki-Wirdiwalangu kirnilu-mirlirlmirlirlmala, ngabiyarra. Yinda a-marringaya. Barranamba ka-arrinyu anku wu-Niyumi kulu marninda barra ka-wingkanhu ngathangkalu, ngarna malbu, yinda barra yabimanthawu awara wakulamba alunga liyinganungaliyi-nganjingku, kalngiya rra-marringaya marninda. Waraba mili ka-wingkanma winkandu nganthiwuthu linji-jakardalu linji-yumbuwarralu, yalbanganthalu yinda alinda arrinjawu aluwa, kurdardi ka-wingkanma yilalu ki-arrkulangku aluwa, kurdardi. Ka-wingkanhu ngathangkalu, ngarna kangka nyawulanga-nganji kalngi rriyi-mangaji wumba ka-nmanhu wulaa wu-Niyumi rrankirri-arduwujara, kalngi a-marringaya yinda. Ki-Wirdiwalangu barra kirnilu-yabimala,” nganinya ka-arri Buwaj anku wu-Rutha. ");
INSERT INTO jao_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ngabiyarra, barni-wardirrinja nda-wurdu anmaya. Alu, li-jibiya Bidiliyima, li-mangaji wiji, jalini li-mirdan yinku marda kangka yinda a-marringaya, marda ngarna mirdan. Karna-yabimal awara yinku nganambaji wumba janha-yalbanganjimu. ");
INSERT INTO jao_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","“Yiya, ngarna barra nyiki-nganji nyuwu-mangaji wumba ka-arrinyu yilaa ki-mirningiyala, ngarna barra yukumanthawu yinku, ngala bajiwa nyarrku barra ambuliyalu, nyarrku nyiki-nganji wirdi ngatha wurrbi, nganinya barra narnu-yuwa narnu-nganunga liyi-Juwu. ");
INSERT INTO jao_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","“Baku anmaya rikarrawu marnaji kulu baku karna-nykarrila namba nungka kirnilu-yukumala nyungku-mangaji ki-wirdinju, nungka kurdardi. Namba ka-ngayamala kulu yamulu. Namba kurdardi, kulu jirni-nanji baki jarni-nanji Wirdiwalangu, ngarna barra kunkunmanthawu yinku. Marnajingulaji anmaya walkurr kulu karnu-arlanala.” ");
INSERT INTO jao_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kulu kanda-arri walkurr baji barra yilaa wirrbanya baki kanda-lhuwarri nyala wungkuwungkulamba ngalalu barnikalinyamba-ngarru li-wulu, kangka kumba-wukanyi na-wurdu Buwaj, “Li-wulu, kala-nmala li-manji anku wumba kanda-arri marnaji wundururra. Namba karrala-nganjima marnaji, kalu-wukanyinjima wardingala anku rruwu-ja rru-marringayawu.” ");
INSERT INTO jao_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Kulu ka-lhuwarri Buwaj baki ka-wukanyi anku, “Kabu jumbala lhangka nyinkungu, nya-rdumaya! Nya-yibarraya awarala marnaji!” Kanda-lhulunma baki kilu-wurruba ma-ngarra anku barra wajkaliya kulu nu-lhangka, barranamba kanda-rduma ki-badikila, mili yurrulu kayilu-ngunda ma-ngarra. Kilu-rdirrirra kulu kilu-rankarrma andalu wulungarndalu ma-mangaji barra ma-bali. Baki kanda-wani kariwajka barra alanjilu baji ki-barrawula, kanda-wani yirdiwiji nandayirdi mu-ngarranku rrungkanku-yuwarnilu andalu. ");
INSERT INTO jao_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kanda-yibanda baji rrungkankurru-yuwarnila. Baki karrandu-yalbanga yinarrambululu, kanda-arri barra, “Wayi barra ngandarra? Ngantha ka-arrinyu? Ngandarra barra wuka, yuwarni?” Baki wu-Rutha karrandi-nu narnu-jakarda narnu-yuwa nakaringu ki-Buwaj, baki karrandi-nu, ");
INSERT INTO jao_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","“Karnili-nu ngarna waninjawu yirdiwiji yindalu, ngarna ngarnayirdi muwu-ja mu-ngarranku. Karnilu-ngunda ma-ja ngalinga,” kanda-arri nganinya. ");
INSERT INTO jao_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kanda-wukanyi anku wu-Rutha, “Baku barra yili yukumaya ngandarra kilu-yabimala awara nyungku-mangaji. Barranamba yiwa bajiwa kalila-ngala, barnikiwa-nmarru nyala bajiwa nyamba-nykalanykarrinjarra, barnikilu-murdirriyu awara, kulu kiya-wingkala nambiwa kulu kilu-yabimala awara, bajiwa nyalalhurrku,” kanda-arri anku wu-Rutha nganinya barra. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bawuji barra Buwaj ka-wingka ankaya barra bajinju barra nyungku-ja ki-walkurrangku ki-barrawulu Bidiliyima, alu nyamba-wukanyinjawu barra ki-awarawu baki rruwu-mangaji barra wu-nhanawayawu wu-Rutha. Barra baji ka-ngalba nungkarnu-mulungka ki-barrawula, kulu li-mangaji nalarrku li-wurrirri li-wulu, kalu-wingka bajinju, kalu-yibanda baji, alu nyamba-wukanyinjawu marnarnaji narnu-yuwa. Ka-wingka bajinju Buwaj, kulu ka-yibanda. Nyarrku mili nyiki-baba ki-Buwaj, nya-mangaji wumba karrili-nu a-Rutha yiku, ka-wingka bajinju. Bawuj ka-wajba yiku, “Ngabinya! Kawa wingkaya marnajinju mingkiyalu!” Ka-wingka bajinju, ka-yibanda. ");
INSERT INTO jao_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Kulu Buwaj kalilu-rduma li-mbangu li-wirdiwalangu ki-barrawuwu, li-10-bala, kalilu-yalbanga alu mingkiyawu nykarrinjawu wulanga ngalawula nyamba-wukanyin jarra nyiki-baba. ");
INSERT INTO jao_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ngalalu mingkiya kulu ka-arri Buwaj nyiki-babawu, “A-Niyumi kanda-wani, marnanda nakaringu Muwab, kanda-arrila jilim nya-mangaji badiki, nya-mangaj ki-Yilimilika ka-arri. ");
INSERT INTO jao_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","“Marningarna barra karna-wingka, yinda nykarrinjalu. Ngandarra kinya-arrila? Namba kinya-bayimala, kulu nya-bayimaya ngalalu li-ja marnalu ngaliya mingkiya. Namba kurdardi kinya-bayimarru, kulu nya-ndarra ngathangka, ngarna karna-bayimala. Jirna-yalbanganji nganinya kangka yinda wirdi ngatha, wirdi wurrbi rdumanthawu nya-mangaji awara, yinda ambuliyalu kulu minja ngarna ngulakari yindaa.” Baki ka-wukanyi nya-mangaji nyarrku nyiki-baba, “Karna-bayimala,” ka-arri nganinya. ");
INSERT INTO jao_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Baki Buwaj, kumba-yangama yilalu, ka-arri nganinya, “Namba kinya-bayimala nya-mangaji awara nakaringu andaa wu-Niyumi, kulu nda-nmaya yindaa a-Rutha alinda, a-mangaji a-miyaji nakaringu Muwab. Kulu kiwa-nmala nya-mangaji awara nyungkankunyu-ardungka wu-Niyumi ki-ngabangakuwu nungka-wininja,” ka-arri yiku nganinya. “Namba kanumba-kulhakulhamala a-Rutha, ardu barra, nyikungu barra nya-mangaji awara kulu na-wini nakaringu yilaa nyungku-mangaji, nyanku-wangu wu-Rutha wumba kumba-mirra. Nganinya barra kali-nmala yurlurr nuwarnu-yuwawu nuwarnu-ngambalanga liyi-Juwu, narnu-yuwa ki-awarawu ngambalanga.” ");
INSERT INTO jao_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ngala jina mili kumba-nykalanykarri yarlajka, baki ka-arri yiku, kumba-yangama yilalu, ka-arri, “Kurdardi. Yinda nya-rdumaya nya-mangaji awara, nya-bayimaya. Kulu kanda-nmala yindaa alinda marda a-mangaji a-Rutha. Namba ngarna karrarna-rdumanma, mili kala-nmanma li-ja li-ardubirri li-ngatha marnalu minja buyi awara alunga baku. Jinangu wuka kurdardi wajkirrantha, jarna-wukanyinji nganinya alunga ambuliyalu, kurdardi wajkirrantha. Nya-mangaji awara wumba karna-rdumanjima ngarna ambuliyalu, jarnamba ngarrarnmanji nyuwu-mangaji, kurdardi karna-mijangarru rdumanthawu. Yinda nya-rdumaya,” ka-arri nganinya. ");
INSERT INTO jao_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","“Yiya. Bawuji narnu-yabi.” Kawula-arri nganinya baki ka-ngayama barra wakulamba, nya-mangaji nyarrku nyiki-baba. Kulu kili-nma barra nya-mangaji jarrbunungkaji nakaringu yilaa marndaa, baki kilu-ngunda, ka-arri yiku ki-Buwaj, “Yinda, nya-rdumaya nya-mangaji awara!” Nganambajilulu barra kilu-ngunda nya-mangaji jarrbunungkaji nya-mangaji ngundayawu ki-awarawu. Nya-mangaji wumba karnilu-ngunda yiku nyuwarrkulu yiwa rdumanthawu awara, kili-nma jarrbunungkaji kulu kilu-ngunda nya-mbangu wumba kilu-rduma, nganinya barra minja yunduyundumanthawu nuwalarrkulu. Nganambaji barra narnu-yuwa narnalunga liyi-wuluwu liyi-Juwu baji wankala. Bawuji kulu nya-mangaji nyiki-baba ki-Buwaj kilu-warrangka barra baji, nganinya kanilu-wayatha barra. ");
INSERT INTO jao_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kulu ka-ngayama jinangu Buwaj. Baki ka-arri alunga wiji, “Marnajirru barra. Katharrirra-kala barra marnaji nganinya wukanyinjarra. Kirra-kala jinangu, kili-nma barra jarrbunungkaji, karnilu-ngunda. Kulu karnirra-kala, karna-ka. Karna-rduma barra nya-mangaji awara barra nakaringu wu-Niyumi, nya-mangaji wiji ki-Yilimilika baki rriyikirriyi-arduwu ki-Jiliyan baki ki-Malun, bawuji. ");
INSERT INTO jao_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","“Karrarna-rduma mili a-Rutha, a-mangaji nakaringu Muwab, a-miyaji rrikuwangu ki-Malun a-mangaji, a-ja barra a-ngatha a-nhanawaya barra kanda-nmala ngathangka,” ka-arri nganinya. “Jinangu awara kiwa-nmala nganinya nungka-wininja ki-ngabangakula. Marda ardu nya-mangaji ambuliyalu karnamba-kajakajamala kulu kiwa-nmala marlijinda jinangu awara yilaa, nganambaji, nyikungu barranamba nyikungu nyuwiku-murimuriyu ka-arri. Kulu na-wini ki-ngabangakuwu ka-nmala nyala marnaji yilaa ki-ardungka,” nganinya barra ka-arri Buwaj. “Yirru barra marnirru nganinya nykarrinjarra ngatharranga, marnanaji narnu-yuwa ngatharranga.” ");
INSERT INTO jao_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ngala li-mangaji li-wurrirri li-wulu mingkiya kalu-arri nykarrinjarra, kulu nalarrku wumba kalu-arri minja baji mingkilmingkiya, kalu-ngayama bawuji wakulamba. “Marninganu nganinya nykarrinjarra.” Baki kalu-arri mili yiku barra nganinya, “Bawuji barra janu-wukanyinji ankaya yiku ki-Wirdiwalangu, kayilu-yabimala rinku-wangu, kanumba-kulhakulhamala barranamba linkili-ardu kala-nmala barranamba wu-Rijil kalu-arri, kanumba-kulhakulhama baki a-Liya, li-jakarda marda baki Jikaba nyalunga-biyi, kalu-arri li-jakarda likili-ardu, nganinya barra, nganambaji kanumba-kulhakulhamala marda rinku-wangu. Janu-wukanyinji yiku ki-Wirdiwalangu mili, yinda anmanthawu mili yurrulu danyawiji aluwa linji-wulungka linji-Yiburatha, baki yinda yabiwiji wurrbingu marnaji Bidiliyima. ");
INSERT INTO jao_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","“Janu-wukanyinji mili ankaya, ki-Wirdiwalangu kalili-yibarrala linkili-ardu nmanthawu li-wirdi aluwa linjalungalinji-nganjinya barranamba kili-yibarra wankala nyinki-nganji Birij, nya-mangaji wumba kanumba-kulhakulhama a-Dama yilaa ki-Juda, nya-mangaji Birij kili-yibarra ki-Wirdiwalangu anmanthawu wirdi aluwa linjikulinji-nganjinya, kalilu-yibarrala linkili-ardu nganambajilulu, li-mangaji wumba kirnilu-ngundarra ki-Wirdiwalangu, andaa wu-yalkuyila rrungkinku-wangu.” ");
INSERT INTO jao_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Bawuji kulu Buwaj, karrilu-rduma barra a-Rutha baki karrila-ka nungkiku nungku-alanjilu, riku-wangu barra, kawula-arri majkarra kalngiya. Bawuji baki ki-Kada, karrilu-mirlirlmirlirlma a-Rutha baki baku ngulakari kanda-arri nanda-wurdu ki-arduwu kulu kanumba-kulhakulhama mayani. ");
INSERT INTO jao_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kulu li-nhanawa li-mbangu winkanda, kalu-yabirri nalu-wurdu, baki kalu-wukanyi anku wu-Niyumi, “Kanyanganu-barlirra nya-Wirdiwalangu,” kalu-arri nganinya anku. “Kirnilu-ngunda nya-ardu nya-kamangkanhu barrungku. Janyanganu-yalbanganji ankaya nya-Wirdiwalangu, kiwa-nmala barra nya-mangaji nya-bardarda nya-wurrbingu barra nya-yabiwiji, li-mirdan kala-nmala yiku li-mbangu winkanda, kala-nykarrila wuka barra yiku li-mangaji, nalarrku li-Yijrayilaja,” nganinya kalu-wukanyi anku. ");
INSERT INTO jao_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","“A-mangaji rra-kayibanthayindalu kanda-arri a-marringaya. Kirnandu-manmarralanga wakulamba, kurdardi kirnanda-ndarrma. Namba li-ardubirri li-mayamayani kala-nmanma, waraba nganinya kalu-arrinma yinku,” kalu-arri nganinya anku. “Anda barra kanda-arri wakulamba yinku. Bawuji barra, marnanda barra, kanumba-kulhakulhama nyu-mayaniyu nyu-arduwu nyu-kamangkanhu. Kulu yiwa, kalngi barra karnila-kala barra narnu-marringaya yindalu. Kirnilu-mirlirlmirlirlmala nda-manka, yiwa barra kirnilu-kunkunmala ngalinda ka-bardibardirrila,” kalu-arri nganinya, “kangka kanumba-kulhakulhama yiku a-Rutha.” ");
INSERT INTO jao_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kulu wu-Niyumi kandu-rduma nya-mangaji ardu, kanda-ka widiwidi andaa, bajiwuthu, kanda-kunkunma. ");
INSERT INTO jao_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Li-mangaji li-nhanawa winkanda nalarrku wunumbarra bajingulaji, alaalanji kalu-arri andaa, kalinyamba-alathama bajinju, nganthalu yiku bardarda. Kalu-wunkanu nya-mangaji ardu kulu kalu-wundarrba na-wini Wubid. Kalali-nu li-jakarda barra nyuwu-mangaji nuwa-winiyu, nganinya marda winkanda kalali-nu nganinya, “Wu-Niyumi nya-kandumangkayi, nya-ardu kiwa-yanjarri. Kalu-arri niya-wini nya-Wubid,” nganinya kalu-arri. Kulu baku barra nya-mangaji Wubid ka-arri nyiki-biyi ki-Jiji, nya-mangaji barra Jiji nyiki-biyi ki-Dabida, nya-mangaji wumba ka-nmala wirdiwalangu kinga alunga. ");
INSERT INTO jao_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Li-ja barra kalinyamba-kajakajama baki bajingu yurrngumantha nakaringu ki-Birij yilalu ki-Dabida. Bajingu Birij, baki Yijrun, Rama, Aminadab, Najun, Jalmun, Buwaj, Wubid, Jiji, Dabida. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nguthundiya ka-wingka Jijaj nankawala arnindawa, nankawa baji na-wini Kalili; kawulila-kala kanymardawujara mirningiyawujara, Jamun baki nyiki-anyira Anduru, kawul ila-kala dawarrkantharra arlku, rri-mangaji rrikirri-nganji ki-arlkuwu kawula-ninya. ");
INSERT INTO jao_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka-wukanyi Jijaj wulanga, “Wambu wandi arlku! Kawa! Nganhimbala-wandarra ngarna! Kimbala-rdumanthaninya arlku ambuliyalu; bawuji barra kimbil irna-yangamala rdumanthawu li-wulu ngatha.” ");
INSERT INTO jao_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kulu kawula-nda wanika yinarrambalulu; kawula-wanda Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ka-wingka mili nguthundiya, kawulila-kala barra kanymarda mirningiyawujara, rrikirri-ardu ki-Jibidi, Jamij wula nyiki-anyira Jana, kawul ila-kala muwardala yabimantharra wanika. ");
INSERT INTO jao_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ka-wajba Jijaj wulanga wula wandayawu yiku; kawula-nda wambu nyawulanga-biyi, bajiwa wu-muwardala marda nalarrku yilaa wumba kala-ninya waki yiku, kalawula-nda baji, kawula-wanda barra Jijaj, bawuji. ");
INSERT INTO jao_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nambanda kanda-nba a-kamba aya; ka-wukanyi alunga liyi-jawinawu liyiku, “Bawuji ngambala akarrakarilu...i!” ");
INSERT INTO jao_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kala-ka muwardala akarriya wurdula; Kalala-nda nalarrku li-wulu bajingulaji ngalalu kalu-lhuwarri, andarrku a-muwarda a-kularrkularr kalu-wajanga aluwa. ");
INSERT INTO jao_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka-warrma alunga barra walkurra lhambiji wumbiji rarra; karrandu-rama wu-rumungku a-muwarda nanda-winkan alunga; kulu ka-ngarlarlama karakarra kariya wabuda wurdulu; wurluburlu ka-arri wabuda wurdula muwardala; ");
INSERT INTO jao_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ngaliwa: Jijaj walkurr ka-arri ngulakari ramangka arndaarnda na-wulaya marrajkala; kalu-yarrungka; kalu-wukanyi yiku, “Wirdi, wulambalu jambala-yinanthani! Waraba kinyamba-yngkalayngkarrinjima nganunga janu-yinanthani?” ");
INSERT INTO jao_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka-walanyma barra; ka-wukanyi ki-lhambijiyu marda ka-wukanyi ki-wabudawu, “Bawuji biya! Nyamba-wamaya!” Kulu wabuda kiwa-bi barra, lhambiji ka-nyiburri, nyibu ");
INSERT INTO jao_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","barra ka-arri na-wurdu; kulu ka-wukanyi alunga, “Ngalhiyu jirru-wardankayi, ngalhiyu? Nungka waraba barra kirra-kanma wuka wunyathawu, nungka kirru-ngajbirri? Katha karna-murdirri yirrunga?” ");
INSERT INTO jao_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kulu kalu-ruwama yiku wakulamba, kulu alulumba kalinyamba-yalbanga, “Ngani baji jina mirningiya, ngani? Namba ja-wukanyinji ki-wabudawu marda ki-lhambijiyu kulu jiwa-binji yiku; jila-yngkarrinji arrkulamantharra.” Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ka-wingka Jijaj wu-muwardala akarrakarilu, marda li-jawina likungu, akarrakari awara alunga liyi-wuluwu liyi-Kirrijin; ka-wundirri akarrakari yiwirra ");
INSERT INTO jao_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","yilalu ka-wingka mirningiya, wardimbangu ngawulu mankanda yilaa, kilu-yakayakama na-arnma ki-ngawulungku, ka-wingka nya- ");
INSERT INTO jao_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mangaji mirningiya yilalu nakari lhawarra linji-ngabangakula, na-alanji baji karna-ninya yiku. Waraba kalu-rdirrirranma linji-wulungku, waraba ki-kijbakijbala kalu- ");
INSERT INTO jao_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","yarrma, wambu barra kala-nda; ambuliyalu barra kalu-rdirrirra ki-kijbakijbala, na-wirrba marda na-wi kalu-rdirrirra, ngala kumba-rulba na-wi, kilu-ma kilu-ma; kijbakijba wirrbanya mili kilu-maluma kilu-maluma wiji barra, wardajiwardaji kiwu-nu kiwu-nu, nya-mangaji wunungu alunga, kalu-mayarri yiku ");
INSERT INTO jao_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","manhanthawu. Kiwa-ninya ki-awarala liyi-ngabangakuwu yurrngumantha, kambaa marda baralala; ka-wajbanthaninya winarrku baji jayngkajayngka, kumbu-manjaninya na-manka ");
INSERT INTO jao_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ki-jayngkaa. Ngaliwa kila-kala Jijaj juju, warramanja yilalu ka-wuluma, kumba-lhawarrma yiku. ");
INSERT INTO jao_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ka-wukanyi yiku Jijaj, “Ngawulu, walanymaya yilaa ki-mirningiyala! Waka wingkaya nakari yilaa!” Ka-wajba kurdandu yiku murdu, “Ngaliyu ka-wingkanhu ngathangkalu, yinda Jijaj nyiki-ardu ki-Kada ki-wirdiwalangu? Jirna-yalbanganji - marniwa Kada yngkarrinjawu ngalinga - jirna-yalbanganji, barni-ramantha ngatha!” ");
INSERT INTO jao_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kilu-yalbanga ki-Jijaj, “Ngandarra nda-wini?” Kumba-ngarninyma yiku, “Ngarna-wini Jakarda kangka marninganu li-jakarda arndaarnda.” ");
INSERT INTO jao_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kulu kilu-yalbanga jababa, “Barni-jantha nganunga nyungkarrku ki-awaralu; wambu marnaji kana-ma.” ");
INSERT INTO jao_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Namba anka barra wunumbarra jakarda bikibiki baji ka-arri, nyamba- ");
INSERT INTO jao_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","wudurrumantharra wujurl; kulu ka-wukanyi ngawulu yiku ki-jababawu, “Bawuji kana-ma ngalbanthalu mankanda ki-bikibikila. Nganu-ngalbaya ki-bikibikila!” ");
INSERT INTO jao_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ka-arri Jijaj, “Yamulu barra, kirru-ngalbala ki-bikibikila.” Ka-walanyma nakari ki-murdungka mankanda yilaa ngawulu jakarda wayathantharra, ka-ngalba mankanda ki-bikibikila na-mangaji narnu-ngawulu, na-miji bikibiki 2 jawujanbala; anarrala karanka ka-lhakalhakanba bikibiki, ka-wuluma yiwirryiwirr, wajkaliya barra wurralu, ka-yinu wajka wabudala nayurrngu ka-arri bawuji. ");
INSERT INTO jao_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bajingu kalu-lhuwarri nalu-wakuru li-mbangu li-wulu, kalu-yukumanthaninya bikibiki, kalu-wuluma bajingu, kalali-nu nalarrku li-wulu ki-barrawula ki-walkurrangka marda li-wulu nungku-alanjila winkanda kalali-nu, kalu-wukanyi ki-bikibikiyu, ka-wuluma wajkaliya, ka-yinu, bawuji barra nayurrngu. Bawuji barra, kalu-wani bajinju li-wulu wayathantharra, kalu-wingka nganthalu awara ");
INSERT INTO jao_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ki-bikibikiyu; kalu-wingka yilalu ki-Jijaj; kala-kala nya-mangaji, ambuliyalu murdu ka-arri, ngawulu wardimbangu mankanda yilaa, ngala kala-kala ka-arri mingkiya baji jumbalawiji, lingi barra ka-arri yabi, kalu-ruwama, kalu-wardanka. ");
INSERT INTO jao_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kulu bajalu li-mbangu nalarrku, kalu-arri baji yurrngumantha wunkanantharra awara, li-mangaji winkanda winarrku; kalali-nu yiku barra li-mbangu nakari barrawula, kalali-nu ki-mirningiyawu murdu ambuliyalu, ki-ngawuluwu marda ki-bikibikiyu kalali-nu li-mangaji nakari barrawula. ");
INSERT INTO jao_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kalu-wukanyi yiku ki-jababawu, “Barni-nmantha marnaji nyungkanganunga ki-awarala! Waniya waka yinda nyungkinku ki-awaralu! Lhuwarriya bawuji waka!” ");
INSERT INTO jao_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ngaliwa ka-ngalba muwardala wajka jababa, nya-mangaji mirningiya ka-arri murdu ambuliyalu, kilu-yalbanga, “Wirdi, yamulu karna-wingkala kuna yindaa? Karnima yindaa.” ");
INSERT INTO jao_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ka-arri Jijaj, “Waraba barra. Ka-lhuwarrila aluwalu linjinkulinji-nganjinyu, kal inyi-nala, ‘Karna-arri murdu, wardimbangu ngawulu mankanda ngathangka karna-arri ambuliyalu ngala ka-wingka ngathangkalu jababa Jijaj, kilu-jujunyma ngawulu jakarda nakari mankanda ngathangka; bawuji barra, yamulu jarnini lingi barra’; nganinya kalinyi-nala linkili-nganji.” ");
INSERT INTO jao_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bawuji barra kulu ka-wani barra aluwalu linjikulinji-nganjinyu, kulu baji barra ki-awarala ki-mayangka Dikabulij kalili-nu ki-Jijaj yiku, “Marnajingarna! Karna-wani yirruwalu; ambuliyalu karna-arri murdu, marningarna yabi; karnilu-yabima ki-Jijaj, kilu-jujunyma ngawulu wardimbangu ngathangka mankanda, kulu jarnini yabi barra.” Kulu kalu-ruwama yiku li-wulu wayathantharra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kalu-wani li-jawina likungu ki-Jijaj, kalili-ja wukanyinjawu yiku, kalu-wani yilalu nakaringu nyungkarrku ki-awarala; kalinyambi-nu barra wukalukanyinjawu yiku marda yabimanthawu li-wulu kalu-arri li-bulmungkurru marda jujunymanthawu ngawulu wardimbangu nakari mankanda aluwa, nganinya kalinyambi-nu yiku. ");
INSERT INTO jao_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bajinju kalu-wingka li-mbangu winkanda, kalinyamba-athama aluwalu; kalu-arri warada aluwa li-jawina ki-Jijaj yurrngumantha; kurdardi kalu-rarrmanma ma-ngarra; warada kalu-arri wirndajkumba aluwa. Ka-wukanyi Jijaj alunga liyiku liyi-jawinawu, “Bawuji ngambalal Kambala-lhuwarrila ngambalalumba bumanthalu waka; kambala-wingkala nambinju waraba ");
INSERT INTO jao_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","liyi-jakardawu namba.” Bawuji barra kalu-lhuwarri alulumba wu-muwardala, kalu-wingka bajinju ki-awaralu warranganthalu munji alulumba. ");
INSERT INTO jao_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kalala-kala lhuwarrinjarra linji-wulungku, li-wulu barra kalu-arri barrawula yiwirra, kala-kala Jijaj baki li-jawina likungu; kalalu-laa, kalu-wuluma yiwirra ngulakari, arrkula kalinyamba-mayama nakari nyungkarrku ki-barrawula marda nyungkarrku ki-barrawula, kalu-wuluma marndaa yiwirryiwirr, kulu bawuji barra kalu-yibanda ambuliyalu ki-Jijaj alunga liyi-jawina liyiku. ");
INSERT INTO jao_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ngaliwa ka-yibanda Jijaj, kal ila-kala li-wulu bajalu mirrkali, ka-rarri na-wurdu alunga kangka li-mangaji li-manji ki-Kada, waraba alunga wirdi milirdimanthawu; bawuji kalilu-milirdima ki-Jijaj, ka-wukanyi alunga yurrngumantha. ");
INSERT INTO jao_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanda-akarirri a-kamba; kalu-wingka yilalu li-jawina likungu, kalu-arri, “Wirdi, kalu-arri wirndajkumba li-mangaji, kulu wirndajku awara jina, kulu ja- ");
INSERT INTO jao_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ngabungaburrinji awara. Linyi-jaya li-ja li-wulu waninjawu ki-barrawulu rdumalrdumanthawu ma-ngarra alunga alu nyamba-wudurrumanthawu baji mijinja.” ");
INSERT INTO jao_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kumba-ngarninyma alunga Jijaj, “Lirru-ngundarra ma-ngarra nyamba-wudurrumanthawu!” Kalu-arri yiku, “Nganu barra, kanu-wingkala rdumanthalu ma-ngarra alunga? Marnalu li-jakarda li-wulu, li-mijimbangu, kulu ma-jakarda ma-mani rdumanthawu ma-burlurlu alunga, ma-kijululu nu-miji, waraba nganuwa kuwima nu-rarrawumba, ku-kularrkularr nganuwa juwini.” ");
INSERT INTO jao_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka-arri alunga, “Barra ngandarra ma-burlurlu yirruwa linji-wulungka? Lirru-yalbangaya li-wulu mu-burlurluwu alunga!” Kalalu-yalbanga li-wulu, kalu-wani yilalu, kalu-arri, “Marnawu ma-burlurlu ma-kanymarda kulu ma-kanymarda kulu ma-arrkula kulu arlku kanymarda marniwa.” ");
INSERT INTO jao_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bawuji barra kalili-nu li-wulu, “Rrinyamba-ruthuruthumaya! Rru-yibandarra ");
INSERT INTO jao_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","wayka awarala ruthuruthu!” Kulu kalinyamba-ruthuruthuma, kalu-arri mingkiya ruthuruthu, nalarrku li-50-bala, nalarrku li-100-bala barra. ");
INSERT INTO jao_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kilu-rduma ma-burlurlu kulu arlku ki-Jijaj, kulu ka-arri mududu ankaya na-mi, kilu-barlirra ankaya wunyatha mu-ngarranku, kulu kilu-ma ma-burlurlu yumbuyumbu, kalilu-ngunda alunga liyiku liyi-jawinawu, kalalu-ngulngunda ma-ngarra li-mbangu mingkiya kalu-arri, kulu arlku kanymarda kilu-maluma yumbuyumbu ngundayawu alunga liyi-wuluwu wayathantharra. ");
INSERT INTO jao_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Wiji kalu-rarrma kulu kalu-wuka, kalu-arri wudurru barra, bawuji; ma-jakarda ma-ngarra alunga kulu nyala bajawu nuwarrku ku-mayarri; kulu kalu-nilnirri nu-wurun barra ma-ngarra baki na-wurun arlku, kalu-yibarra wu-mininila, a-minini kanda-matha a-mangaji a-12-bala bawuji; kalu-wuka barra li-mijimbangu, li-wulu li-5-jawujanbala, marda li-nhanawa kulu li-ardubirri, kalu-wuka wayathantharra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ka-wukanyi Jijaj alunga liyi-jawinawu liyiku, “Bawuji yirru rru-wingkaya ambirrijul Rru-wingkaya aya muwardala bajinju Bidajarda, na-wini awara Bidajarda. Ngarna barra ngulakari yirrunga karna-wingkala; wambu ngarna; kalirni-jala li-wulu kalu-wanila nungalunga nungku-alanjilu.” ");
INSERT INTO jao_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","47","Kalilu-murdama bawuji; kulu ka-arri baji yiwalumba, ka-wingka ankaya ki-jayngkaa, ka-arri baji mududu barra, ka-wukanyi wunyathawu yiwalumba. Ngalanda aya kanda-nba a-kamba ngalanda a-muwarda ki-nankawala ki-walkurrala ngaliwa Jijaj yiwalumba barra ki-awarala baji. ");
INSERT INTO jao_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kulu kal ila-kala likungu li-jawina wu-muwardala angula, kalu-majarrmajarrirri kalu-wardirri wajanganthawu kangka walkurra ka-warrma kariya, kalilu-ngka akarriya, kal ila-kala baji, wunumbarra barra arlanantharra ngaliwa karakarra wingkayarra aluwalu ki-wabudala lhangka, nganambaji ka-wingka, kalilu-ngularuma buyi. ");
INSERT INTO jao_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kulu kalu-kala aya linji-jawinalu linjiku, kala-kala wingkayarra nankawala barra; “Marrirru, ngabaya bajiwa!” Marda winarrku kal inyamba-yiwama kangka kathiwa ");
INSERT INTO jao_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ngabaya nya-mangaji, kalu-wardanka kurdandu barra. Ngala yinarrambalulu ka-wukanyi alunga Jijaj, ka-arri, “Ngarna barra Jijaj marnajingarna! Rru-yabirriya nirru-wurdu! Barni-wardankaya rra-nmaya!” ");
INSERT INTO jao_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bawuji barra kiwa-nka muwardala, kiwa-bi lhambiji ngaliwa wurdula; kalu-ruwama barra yiku. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jayngkaa ka-wundirri ankaya jababa Jijaj nayirdi alunga ki-Bida marda ki-Jamij wulanga ki-Jana, li-mangaji li-jawina likungu, kalila-ka li-kanymarda arrkula, kalu-wundirri ki-jayngkaa ankaya alulumba ");
INSERT INTO jao_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","kulu kumba-yangama na-manka aluwa; jumbala yiku ka-mirnmirnma burnalkarra, waraba mili ngubunthurr, kalngiya barra burnalkarra ka-arri jumbala yiku ngaliwa kumba-yangama na-manka. ");
INSERT INTO jao_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kulu kawulala-kala mirningiyawujara rri-wankala rri-mangaji, Mujij kulu Yilaja nawula-wini, kawula-arri baji aluwa; kawula-wukanyi yiku ki-jababawu ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kulu ka-arri Bida yiku ki-Jijaj, “Wirdi, yabi barra janini marnaji yirruwa; kanunganu-yabimala na-ngandu na-kanymarda arrkula, arrkula yinku, narrku ki-Mujij yiku, mili narrku yiku ki-Yilaja.” ");
INSERT INTO jao_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nganinya ka-arri kangka yiwa manji wukanyinjawu alunga; alu Jamij wula Jana kalu-wardanka wakulamba barra nalu-wurdu. ");
INSERT INTO jao_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka-lhakanba ngawu karanka; ka-arri alunga karanka, ka-wukanyi ki-ngawungka wunyatha, “Jina nyangathi-ardu; karnamba-riyarraba yiku nyungathi-arduwu; nyirra-yngkarriya!” Ka-wukanyi alunga bawuji. ");
INSERT INTO jao_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yinarrambalulu barra kalu-warnkanga ki-jababalu yilalu li-kanymarda arrkula li-wulu, kulu kala-kala yiwalumba, waraba rri-mangaji yilaa, ngayamantharra yiwa kala-kala. ");
INSERT INTO jao_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bawuji barra kalu-lhakanba karanka ki-jayngkaa; ka-wukanyi alunga Jijaj, “Barni-wukanyinja ngatha rra-nmaya! Barni-wukanyinja nganunga Mujij wula Yilaja; mirningiya ngarna karankangu; baku karnalu-ramala, kurdan karna-nmala ngabangaku; baku barra karna-walanymala lhungku; bawuji barra ngatha kirru-wukanyila ngalingarna lhungku.” ");
INSERT INTO jao_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kulu kalinyamba-wama yiku, ngala alulumba kalinyamba-yalbanga, “Ngalhi jina wuka, ka-nmala kurdan kulu ka-walanymala lhungku? Ngandarra barra ka-lhungkurrila, jina mirningiya, ngandarra?” Nganinya kalinyamba-yalbanga. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ngalalu kalu-wingka karanka aluwalu linji-jawinalu linjiku, kalala-kala li-mijimbangu lukuluku aluwa, li-mbangu li-wirdiwalangu mili, kalu-milirdimanthaninya li-wulu nuwarnalunga, kalu-arri baji wajka nyamba-mirirrinjarra, li-wirdiwalangu marda ");
INSERT INTO jao_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","li-jawina liyiku ki-jababawu; kala-kala jababa linji-wulungku wayathantharra, kalu-ruwama nganthawu yiwa, kalu-wuluma yilalu, kalinyamba-lhawarrma yiku. ");
INSERT INTO jao_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka-wukanyi jababa alunga liyi-jawinawu, kalilu-yalbanga, “Ngandarra kirrinyamba-wukanyinji li-wirdiwalangu, ngandarra?” ");
INSERT INTO jao_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Nya-mbangu arrkula, bajiwa aluwa linji-wulungka, ka-arri yiku ki-jababawu, “Wirdi, karna-ka nyangathi-ardu yindalu, jina ardu wardimbangu ngawulu mankanda yilaa, barni-wukanyinja marniwa kangka narnu-wardimbangu narnu-ngawulu yilaa, narniku ki-ngabayawu; kulu nungkarnarrku kila-ka ardu nyungku-mangaji ki-ngabayangka, kilu-walima ardu wajkaliya awaralu; ardu mili rayal yilaa mulungka ka-wujba; ka-mayija na-mayi, ka-kadirri na-manka; nganinya ka-arri ngaliwa kila-ka nyungku-mangaji. Bawuji karna-ka marnajinju; kalarna-yalbanga li-ja, li-jawina liyinku, walimanthawu jina ngabaya ngala alu barra li-barlkibarlki ngawuluwu”; nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kumba-ngarninyma alunga Jijaj, “Jirru-ngajbirrinji ngatha, yirru li-wulu wayathantharra; waraba karnirra-yngkarrinjima; waraba kirra-kanjima wuka ngatha; jarna-wukanyinji yirrunga yurrngumantha, yurrngumantha barra, kulu nyala marnirru li-manji. Nya-kaya jina ardu ngathangkalu.” ");
INSERT INTO jao_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kala-ka ardu yilalu ki-jababalu; kulu ngaliwa kila-kala Jijaj barra nungku mangaji nungkarnu-wardi mbangu nungkarnu-ngawulu narniku ki-ngabayawu, kulu yinarrambalulu kilu-walima ardu wajkaliya ki-awaralu, ka-arri durungku baji, kumba-wanjaba, ka-wujba rayal mulungka yilaa ki-ardungka. ");
INSERT INTO jao_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka-arri Jijaj yiku nyiki-biyiyu, “Nganthimbala ka-arri nganinya ambuliyalu, nganthimbala barra?” ");
INSERT INTO jao_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ka-arri mirningiya, “Ka-arri nganinya ngaliwa ardu buyi; jilu-walima ardu ki-ngawulungku wajkaliya buyukalu, wurralu wajka mili jilu-walima nyungku-mangaji, ramanthalu barra. Namba yinda wunungu walimanthawu jina ngabaya, rarrinjarra nda-wurdu ngatharranga ki-arduwu, katharrinya-anyiramala.” ");
INSERT INTO jao_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka-arri Jijaj yiku, “Ngalhiyu ka-wukanyinyu ngatha ‘Namba yinda wunungu?’ Jarnini wunungu yabimanthawu, kalngiya wunungu. Namba kirnila-yngkarrinjima kurdandu ki-arrkulangku, namba kila-kanjima wuka ngatha, kulu jarnini wunungu marakamanthawu nya-mangaji”, nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yinarrambalulu ka-wajba yiku nyiki-biyi ki-arduwu, “Wirdi, buyi kirna-ka wuka yinku; karnama kanthawu wuka yinku wayathantharra; ngarna-marakamaya!” ");
INSERT INTO jao_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kilu-wunkana awara ki-Jijaj, kalila-kala mili li-mbangu li-wulu nalarrku kalu-wingka bajinju; kulu ka-mirirri ki-ngawuluwu, ka-arri, “Wardimbangu ngawulu, wardimbangu yinda; namba yinda mankanda yilaa ki-ardungka, kulu murdu-arnma nya-mangaji barra, barni-wukanyinja bajiwa, wardimbangu yinda; jirna-maramaramanji nganinya, walanymaya nakari mankanda yilaa ki-ardungka! Barni-waninja yilalu nyungku-mangaji! Nya-ndayani jina ardu bawuji!” Nganinya ka-arri jababa. ");
INSERT INTO jao_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka-wajba kurdandu winarrku nya-mangaji wardimbangu ngawulu; kilu-jarlajarlama kurdandu ardu; bawuji barra ka-walanyma nakari mankanda yilaa, kila-nda; kulu bajiwa ardu awarala wajka, barranamba ngabangaku ka-arri; kathiwa ngabangaku, kalu-arri li-wulu, “Jina jina kurdan ka-arri”; kathiwa kurdan. ");
INSERT INTO jao_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngala Jijaj ka-rubanba wajkaliya, kilu-manha ardu na-marliji, kilu-rankarrma ankaya, ka-alarri ankaya ardu; bawuji barra ka-yabirri. ");
INSERT INTO jao_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lhurrku barra kalu-ngalba ki-barrawula, jababa marda li-jawina liyiku; kalu-arri alulumba, waraba nuwalarrkulu aluwa; kalu-yalbanga yiku, “Wayi barra kanu-arri li-barlkibarlki ki-ngawulungka ki-wardimbangu, wayi? Barnikanu-walimanma nya-mangaji.” ");
INSERT INTO jao_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka-arri Jijaj alunga, “Namba jina ngawulu, kirru-wukanyinjima wunyathawu kulu kirrilu-wunungumanjima wal imanthawu; kirru-wukanyinjima wunyathawu namba niwarrku ngawulu wardimbangu barranamba jina ki-ardungka ka-arri”, nganinya ka-arri. Bawuji. ");
INSERT INTO jao_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kalu-wingka bajinju barrawula Jirriku, Jijaj marda li-jawina likungu; kalu-lhuwarri bajingu li-mangaji marda nalumiji nakaringu winkanda. Bajiwa mirningiya mingkiya rru-yabala na-wini Bardimiyaj, nyiki-ardu ki-Dimiyaj, kabuji ka-arri, bajiwa mingkiya yukulyukulmantharra alunga yalbanganthawu mu-maniyu. ");
INSERT INTO jao_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","48","Ngaliwa kalila-yngkarri li-wulu kalu-wukanyi, “Marniwa Jijaj jibiya Najarrida”, baki yiwa ka-wajba, “Jijaj, nyiki-nganji ki-Dabida, rarriya ngatha nda-wurdu!” Li-wulu kalu-mirirri yiku, kalu-arri, “Lhaba anmaya!” Ngaliwa wajbantharra mili kurdandu, “Nyiki-nganji ki-Dabida, rarriya ngatha nda-wurdu!” ");
INSERT INTO jao_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kulu kumba-wama alarrinjarra, kumba-yngkalayngkarri yiku Jijaj, ka-arri alunga, “Nyirri-naya wa-wingkaya” Kulu kalu-wajba ki-kabujiyu yiku, kalu-wukanyi, “Yamulu barra, alarriyal Ja-wajbanji yinku Jijaj wingkaya yilalu!” ");
INSERT INTO jao_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kili-nma jumbal a lhangka nya-mangaji kilu-walima wajkaliya, ka-alarri yarlayka, ka-wingka yilalu ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kilu-yalbanga ki-Jijaj, “Ngandarra karna-arrila yinku?” Ka-arri yiku kabuji, “Wirdi, nganha-yabimaya ngarna-mi, ngarna nganthawu awara!” ");
INSERT INTO jao_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka-arri yiku Jijaj, “Lhuwarriya ngantharra awara! Kinya-ngala barra kangka kinyamba-yibarra nda-wurdu ngathangka.” Yinarrambalulu barra ka-yabirri na-mi, kila-kala awara yabi barra; kulu kilu-wanda Jijaj rru-yabala. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Karakarra kalu-wingka jababa Jijaj alu li-jawina likungu wangani karakarra, akarrunga Jirrujalima bajiwa barrawu kanymarda, na-wini nyarrku barrawu Bidabija mili na-wini nyarrku barra Bidani, kulu baji ankangu jayngka na-wini jayngka Aliba, kalu-arri baji barra, dinkidinki kalu-arr kanymarda arrkula barrawu. ");
INSERT INTO jao_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ka-wukanyi Jijaj rriyikurriyi-jawinawu, “Ambirriju nyimbala-karra barrawu! Mbila-wingkaya ngalbanthawu barrawula baji! Kulu yamulu, yinarrambalulu kimbala-ngala yirrikirri buyi, waraba kalilu-ngabarlamanma aliyaliya. Nyi-nmaya nya-mangaji, nya-kaya ");
INSERT INTO jao_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","marnajinjul Namba ka-wukanyila mirningiya yimbalanga, ‘Ngalhiyu jimbala-kanji jina yirrikirri ngalhiyu?’, kulu mbila-wukanyiya, ‘Ki-wirdinju katharrili-nu rdumanthawu jina; Kilu-wanjangumaia marnajinju nyalalhurrku’. Mbila-wukanyiya nganinya yiku!” ");
INSERT INTO jao_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kulu kawula-lhuwarri, kawula-wakarama nya-mangaji yirrikirri, bajiwa rdirrirrantha nungkanu-mulungka winkanda barrawula. ");
INSERT INTO jao_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bajalu li-mbangu li-wulu alarrinjarra wunkanantharra alunga, kawulalu-yalbanga, “Ngandarra kimbala-arri? Ngalhiyu jimbali-nmanji jina yirrikirri?” ");
INSERT INTO jao_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kulu kawula-arri alunga, “Ki-wirdinju katharrili-nu rdumanthawu jina yiku; kili-jala marnajinju nyalalhurrku.” Kalu-arri wulanga, “Yamulu barra, nyimbala-kaya!” ");
INSERT INTO jao_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kulu kawula-ka yirrikirri yilalu ki-Jijaj, kawula-yibarra jumbala wulanga ki-yirrikirrila kulu ankaya kiwa-nka ");
INSERT INTO jao_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ki-yirrikirrila wukungka Jijaj; bajalu nalarrku lu-wulu, kalu-yibarra jumbala alunga wajkaliya yabayabala ambirriju ki-jababawu; mili nalarrku li-wulu, kalu-ma wurnda na-yala, wanjirriji kalu-yibarra wajkaliya yabayabala; nganinya kalu-yibarra yabimanthawu awara yiku kangka kalinyamba-riyarraba yiku ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kalu-wingka aya, nalarrku wingkayarra ambirriju yilaa mili nalarrku ngulakari yilaa, bajiwa wumbiji; kalu-wajba yiku ki-Kada, kalu-barlirranha, “Wunyatha, nyamba-riyarrabaya yiku nyuwu-ja kangka yabi marniwa, kinyi-janhu nganuwalu; baku ");
INSERT INTO jao_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","barra kinya-yibarrala wirdiwalangu kinga liyinku liyi-wuluwu barra wumba nyanganunga-nganji Dabida ki-wankalawu ka-arri wirdiwalangu kinga; janu-yabirrinji nganu-wurdu nyamba-yngkalayngkarrinjarra ki-wirdiwalangu; bawuji barra”; nganinya kalu-barlirranha. ");
INSERT INTO jao_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kulu bawuji barra ka-wingka bajinju Jirrujalima, ka-ngalba nungkanu-mulungka barrawula Jirrujalima; ka-wingka bajinju ki-barrawulu ki-kurdukurdula nyungkiku ki-Kada. (Lhurrku ka-wani akarriya ki-barrawulu Bidani walkurru.) ");
INSERT INTO jao_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Karakarra kalu-wingka bajinju Jirrujal ima; ka-ngalba Jijaj ki-barrawula ki-kurdukurdula nyungkiku ki-Kada kulu kalilu-jujunyma li-wulu kalu-arri arndaarnda, nalarrku li-wulu kala-ninya nyamba-ngulngundayarra ma-kijululu marrababawu wiji yibarranthawu ki-kurdukurdula, nalarrku li-wulu kalu-arri rdumantharra aluwa ma-kijululu, kalilu-jujunyma li-mangaji wayathantharra winkandu. Kulu baji arndaarnda ka-arri daladala lhulun alunga liyi-wuluwu, jabarrimba kalu-yangama ma-kijuiulu alunga nuwalarrkulu linji-wulungku, ma-arrku barra ma-kijululu ku-arri ki-barrawula ki-kurdukurdula nyungkiku ki-Kada, kulu kilu-wirrinma daladala alunga ki-Jijaj; bajalu mili arndaarnda li-mbangu, kala-ninya ngulngundayarra marrababa; kilu-wirrinma alunga mingkiyawu daladala ki-jababalu. ");
INSERT INTO jao_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kulu ka-wukanyi alunga liyi-wuluwu, “Barni-wingkaya jakajakarda ki-barrawula ki-Kada! Waka nyirra-kanthani nambiwuthu winkanda! ");
INSERT INTO jao_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kalilu-mil irdima baji, ka-arri, “Ka-wukanyi Kada nungka-burruburrula nungkiku, ‘Kalu-wukanyila li-wulu, “Jina barrawu ki-Kada, kiwa-nmala barrawu mududuwu alunga liyi-wuluwu, li-mbangu li-kariyangu marda li-karakarrangu, li-karinguthundangu marda li-karingamalangu; jina barrawu alunga wayathantharra mududuwu,’” nganinya ka-wukanyi Kada nungka-burruburrula nungkiku; ngala yirru, kirru-wardima jina barrawu, barranamba na-ajinja alunga liyi-wuluwu liyi-wardiyu barra, li-mangaji li-wajkilwajkil barra, kalu-wajkirra yumbulyumbumantha arndaarnda nungku-ajinjala nungkalunga, barranamba na-mangaji na-ajinja barra jina barrawu wunyathawu, kirru-wardima barra.” ");
INSERT INTO jao_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bajalu ki-barrawula li-mbangu li-wirdiwalangu li-wurrirri, kalu-arri nalarrku li-wirdiwalangu nyuwiku ki-barrawuwu ki-Kada, kalu-arri mili nalarrku li-wirdiwalangu, kalu-milirdima li-wulu nuwarnalunga, bajalu li-mangaji li-wirdiwalangu wayathantharra ki-barrawula ki-kurdukurdula nyuwiku ki-Kada. Kala-yngkarri Jijaj wukanyinjarra baji arndaarnda, kalinyamba-wukanyi, “Ngandarra kambala-ramala yundulu nya-mangaji, ngandarra?” Nganinya kal inyamba-wukanyi ramanthawu Jijaj, kalu-wardanka yiku kangka kala-yngkarri jababa linji-wulungku, waraba kalala-yngkarr inma li-wirdiwalangu, Jijaj kala-yngkarri, kulu kalu-wardanka yiku li-mangaji li-wirdiwalangu, kal inyamba-wukanyi ramanthawu yiwa. ");
INSERT INTO jao_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wundururra ka-lhuwarri Jijaj nakari barrawu Jirrujal ima, ka-lhuwarri nayirdi alunga liyi-jawinawu liyiku. ");
INSERT INTO jao_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kulu kala-ka Jijaj linji-mbangu linji-alkangku, kala-ka winkandu akarriya alu bilbirdamanthalu yiku warriwarriyamba barra ki-wurndaa. ");
INSERT INTO jao_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka-wani karakarra nakari badika mirningiya, na-wini Jamun, jibiya Jarini namba mayangka Abirika, nya-mangaji nyawulanga-biyi ki-Alijanda wulanga ki-Rubuj, ka-wani karakarra Jamun. Kalu-rra Jamun linji-alkangku; kalu-wukanyi yiku, “Nya-kaya jina wurnda, jina yibarranthalu yilaa warriwarriyamba!” Kalu-jululuma Jamun rdumanthalu wurnda. ");
INSERT INTO jao_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kulu kala-ka Jijaj nambinju ki-awaralu, na-wini awara Kulkutha; (jalu-wundarrbanji Juwungala Kulkutha, ngala janu-wukanyinji Yanyuwangala na-ngulyanda wulala; Yanyuwa wuka na-ngulyanda wulala marda wuka alunga liyi-Juwu Kulkutha, nganambaji barra.) ");
INSERT INTO jao_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kulu kalu-ngunda linji-wulungku wunjayawu wayin mayamantha na-mirdijin nanu-wini na-mura, ngala waraba ka-wunjanma, ");
INSERT INTO jao_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","kanila-nda wambu. Kalu-arrijinma ki-wurndaa linji-alkangku, kalu-yibarra malambi na-wi, kalu-bilbirdama, kalu-kadirra wurnda nayirdi yiku, bawuji; kulu kalu-arri baji lhurrangka li-alka, kulu kalu-rduma jumbala nyuwiku ki-Jijaj, kalinyamba-ngunda jumbala lhurrangkawu. ");
INSERT INTO jao_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","26","Kalu-bilbirdama Jijaj ngalanda a-kamba ankangu akarrakari; ngalalu kalu-bilbirdama nya-mbangu mirningiya wardi ki-wurndaa kalu-yibarra wuka nalinanthawu nuwarnu-wardiyu nuwarniku, kalu-yibarra wuka ankangu yiku ki-wurndaa; kalu-yibarra wuka ki-jababawu mili, kulu kanalu-barlirra, “Jina wirdiwalangu kinga alunga liyi-wuluwu liyi-Juwu”; nganinya kanalu-barlirra kulu kalu-yibarra ankangu. ");
INSERT INTO jao_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kulu kawulalu-bilbirdama ki-wurndaa mili mirningiyawujara, kawula-arri wajkilwajkilwujara wardiwujara, kawulalu-bilbirdama, ngala jababa wumbiji kalu-yibarra wulaa, wajkilwajkilwujara ngamalamba kulu nguthundawa yilaa. ");
INSERT INTO jao_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kulu kalu-wingkalwingka yabayabala baji li-wulu, kalu-kiwuma, “Juwayi! Yinda kalinyi-nanhu malumanjarra barrawu kurdukurdu ki-Kada kulu kinya-yabimanjimu nya-mangaji yurrulu mili na-kanymarda arrkula; yamulu barra, nyamba-marakamaya yindalumba! Lhakanbaya karanka nakaringu ki-wurndaa!” Nganinya kalu-kiwuma. ");
INSERT INTO jao_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Baji li-wirdiwalangu, nalarrku li-wirdiwalangu nyuwiku ki-barrawuwu wunyathawu marda nalarrku li-wirdiwalangu kalu-mil irdimanthaninya li-wulu nuwarnalunga, alu barra, li-wirdiwalangu wayathantharra, kal inyamba-wukanyi lhawumanthawu yiku, alulumba kalu-arri, “Yiwa barra, kalilu-marakama nalarrku ngala waraba kumba-marakamanjima, waraba yiwa barra. Kalu-wukanyi li-wulu, ‘Yiwa barra Kurayij, yiwa barra kalili-nu ki-Kada janthawu’, kalu-wukanyi li-wulu, ‘Yiwa barra wirdiwalangu kinga alunga liyikul iyi-nganjingku ki-Yijriyil ki-wankalawu’, nganinya kalu-arri li-wulu. ");
INSERT INTO jao_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Namba yiwa nya-mangaji barra, Kurayij, ka-lhakanbayima karanka nakaringu ki-wurndaa; namba kambala-ngala nya-mangaji lhakanbayarra, kambala-kala wuka nyikungu nungka”, nganinya kal inyamba-wukanyi li-wirdiwalangu; marda nawularrku kawulalu-bilbirdama, kawula-kiwuma Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ngalanda kanda-arri wumbiji a-kamba, kulu bawuji barra ka-arri ngubunthurr awara barranamba wundururra; ka-arri ngubunthurr awara ki-mayangka barra, maya Balijayin ");
INSERT INTO jao_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","wayathantharra; kulu ngalanda a-kamba ankangu akari, yamulu barra, a-kamba awara ka-arri mili; kulu bajingulaji ka-wajba Jijaj kurdandu, ka-wajba ki-wukangka liyi-wuluwu liyi-Juwu, “Yiluyi, yiluyi, lama jabakathani?”, kulu jina wuka Yanyuwangala nganinya, “Wunyatha, wunyatha ngatha, ngalhiyu ka-lhuwarrinyu nakari ngathangka?” ");
INSERT INTO jao_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kala-yngkarri linji-wulungku, kalu-arri alarrinjarra baji wunkanantharra yiku, kalu-alalarri, “Ja-wajbanji yiku ki-Yilaja ");
INSERT INTO jao_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ki-wankalawu.” Ka-wuluma arrkula, kilu-rduma nya-mbangu barranamba na-kuwanda, kilu-lawunma ki-wayin, kilu-yibarra ki-wurndaa, kulu ankaya banra yiku ki-jababawu wuyanthawu, ngaliwa ka-wukanyi nya-mangaji mirningiya alunga liyi-wuluwu, “Ngambala-yukumaya! Ngambala-karra! Nungka ka-wanila karanka Yilaja manthalu yiku.” ");
INSERT INTO jao_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ka-wajba kurdandu Jijaj, winarrku ka-wajba, kulu bawuji barra, kumba-mirra ");
INSERT INTO jao_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","bawuji, yundulu barra; ngaliwa kumba-mirra jababa ngalanu nanu-mulu arndaarnda ki-barrawula ki-kurdukurdula nyuwiku ki-Kada, jumbala barra na-mangaji nanu-mulu, kanu-nu kanymardalu, karanka kanu-nu. ");
INSERT INTO jao_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kulu ngaliwa kumba-mirra Jijaj, bajiwa wirdi alunga liyi-alkawu, ka-arri ambirriji yilaa ki-jababala jarrijarr imantharra, kulu ngaliwa kumba-mirra ka-wukanyi nya-mangaji wirdi, “Kalngiya jina mirningiya ka-arri nyiki-ardu ki-Kada.” ");
INSERT INTO jao_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Marda kalu-jarrijarrima Jijaj linji-nhanawalu, kalu-arri wakangu yilaa alalarrinjarra barra wunkanantharra yiku, alu barra a-Miri Makadalina, a-Jalumi, marda a-Miri rrawulangarra-wibi ki-Jamij wulanga ki-Jujij, nya-mangaji Jamij yalkuyi barra, yikurra-wibi. Ambuliyalu ngaliwa ka-arri nyamba-yurrmantharra Jijaj ki-mayangka ki-awarala Kalili ngalalu kalu-wanda linji-nhanawalu, kalu-wuba ma-ngarra yiku, kalu-arlkarlba jumbala yiku baji, li-mangaji barra kalu-arri wunkanantharra jababa ki-wurndaa, marda nalarrku li-nhanawa kalu-wingka karinguthunda nyala Jirrujalima wingkayarra yilaa, ii-mangaji li-jakarda barra. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nambiwa waka barrawula mirningiya, na-wini Jajiba, jibiya Arimathiya nya-mangaji, ka-arri wirdi alunga liyi-wuluwu liyi-Juwu baji Jirrujalima, yabiwiji alunga, marda nya-mangaji ka-arri yukumantharra barra yiku ki-Kada anmanthawu wirdiwalangu kinga alunga liyi-wuluwu, yiwa barra Jajiba. Kumba-wukanyi na-wurdu, “Ngabungabu awara marniwa kulu rikarrarikarra Jarirdi, kambala-thala kurdukurdula; karna-nmala ngarra; karna-wingkayani yilalu ki-wirdiwalangu ki-Bilada, karna-yalbanga rdumanthawu ngabangaku nyala bajiwa ki-wurndaa”, nganinya ka-arri nya-mangaji Jajiba. Ka-wingka yilalu ki-wirdiwalangu; kilu-yalbanga ki-ngabangakuwu ki-Jijaj; ");
INSERT INTO jao_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","ka-ruwama barra wirdiwalangu Bilada; “Rikarra kumba-mirra, rikarra?” Ka-wajba yiku ki-alkawu nyikungu, “Wayi barra nya-mbangu ki-wurndaa, nya-mangaji Jijaj? Kumba-mirranhu kurdan?” Kumba-ngarninyma, “Yuwu, ngabangaku bajiwa”; ka-arri wirdiwalangu yiku ki-Jajiba, “Yamulu. Nya-kaya ngabangaku, yamulu.” ");
INSERT INTO jao_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bawuji ka-wingka ki-barrawulu rdumanthalu jumbala, wayarrwayarr jumbala burnalkarra kilu-rduma, kulu ka-wingka akarriya bajinju Kulkutha, kilu-rduma karanka na-manka Jijaj, kilu-rdirdilma ki-jumbalangka, bawuji; kila-ka bajinju nungku-ajinjalu, bajanu na-ajinja kanalu-ma ki-jayngkaa, kilu-yibarra ngabangaku baji arndaarnda; ka-arri jayngka walkurra wunungu, kilu-jululuma, kanilu-muruma nanu-mulu na-ajinja. Ngaliwa kilu-yibarra ngabangaku arndaarnda ngalawula nhanawawujara kawula-kala, wula barra a-Miri Makadalina marda rrarrku a-Miri rrikurra-wibi ki-Jujij, rri-mangaji barra, kawula-wunkanu awara. ");
INSERT INTO jao_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rikarrarikarra jarirdi bawuji; kulu ngulakari li-nhanawa, a-Miri Makadalina, a-Jalumi marda a-Miri yikurra-wibi ki-Jamij, kanalu-rduma na-marringaya nuwu-mankanku alu banthawu yiku, kanalu-rduma yibarranthalu yilaa ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nunyilanku wunthaa jandi ngalanda a-kamba kanda-walanyma, kalu-wingka li-nhanawa bajinju nungku-ajinjalu nungku- ");
INSERT INTO jao_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","mangaji; kalinyamba-wukanyi, “Nyu-nganinju barra kilu-walimala jayngka nakari nungku-ajinjala ngambalanga?” Nganinya kalu-arri kangka walkurra nya-mangaji jayngka; kanala-kala na-ajinja; yamulu bajiwa jayngka winkanda. ");
INSERT INTO jao_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kalu-ngalba arndaarndalu nungku-ajinjalu, “Nya-ngani nya-ja?” Bajiwa nyiku jawina ki-Kada, barranamba yalkuyi; ka-arri mingkiya aluwa mayangka baji, kulu ");
INSERT INTO jao_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","burnalkarra jumbala yilaa; kalu-ruwama yiku; ka-arri alunga, “Barni-ruwamantha ngatha! Jirru-yarrbanji yiku ki-Jijaj, kalu-bilbirdama nya-mangaji; kulu ka-lhungkurri, waraba marniwa, nyirra-karra awara wumba ka-arri baji lhulurrungku, ");
INSERT INTO jao_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","waraba yiku. Rru-wingkaya aluwalu linji-jawinalu linjiku, kal irri-nala, marda Bida barra, kalirri-nala yiku ki-jababawu, ja-wingkayi ambirriju yirrunga bajinju Kalili, kirra-ngala baji; kirrili-nu ambuliyalu, nganambaji barra.” ");
INSERT INTO jao_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kalu-walanyma nungku-ajinjala, kalu-wuluma bajingu kangka kalu-wardirri nalu-wurdu; kalu-arrkama nalu-manka; barni-wukanyinja kalu-arri kangka kalu-wardanka; kurdardi kalali-nanma nalarrku, alulumba kalu-laa awara; bawuji. ");
INSERT INTO jao_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Karanka kili-ja ki-Kada jawina nyikungu, na-wini Kaburriyil, wajkaliya kili-ja andalu wu-rumanngulu, nanda-wini a-Miri a-jibiya barrawu Najarrida, baji ki-awarala ki-mayangka Kalili, kili-ja ki-Kada andalu, kanda-arri arninanthangu yiku ki-mirningiyawu, na-wini Jajiba, nyiki-nganji yiku ki-wankalawu ki-Dabida, ka-lhakanba wajkaliya andalu wu-Miri nya-mangaji jawina. ");
INSERT INTO jao_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka-arri, “Bajinda. Jiwini yindaa wirdi Kada, kumba-riyarraba yinku.” ");
INSERT INTO jao_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kanda-wardirri nanda-wurdu ngaliwa ka-wukanyi anku, kanumba-wukanyi nanda-wurdu, “Ngalhiyu kiya-wukanyi ngatha nganinya, ngalhiyu?” ");
INSERT INTO jao_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka-wukanyi anku, “Ngabiyarra, barni-wardankaya anmaya! Jumba-riyarrabanji yinku Kada; kulu kinya-rdumala bardarda; baku ka-yanjarrila yindaa nyinku, kulu kinya-wundarrbala na-wini Jijaj. Kiwa- ");
INSERT INTO jao_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","nmala wirdiwalangu nya-mangaji. Kalu-wukanyila li-wulu yiku nyinki-arduwu, ‘Jina nyiki-ardu ki-Kada ki-wirdiwalangu’, nganinya kalu-arrila. Wabarrangu kilu-yibarra nyiki-nganji Dabida wirdiwalangu kinga ki-Kada, kinga alunga liyi-wuluwu liyiku wunyathawu; baku kilu-yibarrala jina Jijaj mili wirdiwalangu kinga wunyathalu, kinga alunga liyi-wuluwu wunyathawu liyiku, kilu-yibarrala ki- ");
INSERT INTO jao_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kada nganambajilulu; nayurrngu kiwa-nmala wirdiwalangu kinga barra, waraba nyuwa-rrkulu ngulakari yiku, ngayamantharra yiwa barra wirdiwalangu yurrngumantha arrkula, waraba barra binjawu, bawuji yurrngumantha.” ");
INSERT INTO jao_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kulu kanda-wukanyi a-Miri ki-jawinawu yiku, “Ngandarra barra kirna-rdumala bardarda, ngandarra? Jarnini walkurr ngarnalumba, waraba barra katharra-nmanma wingkuru walkurr nya-mirningiya, waraba.” ");
INSERT INTO jao_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka-wukanyi anku jawina, “Ka-lhakanbala yindalu karanka Jawukama ki-Kada karankangu, jiwini wunungu Kada, kiwa-nmala yindaa, kulu ka-yanjarila yindaa bardarda. Kalu-wukanyila yiku li-wulu, ‘Jina kurdukurdu nyiki-ardu ki-Kada jiwini, ");
INSERT INTO jao_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","kurdukurdu’. Kulu nambanda yinkurra-nganji a-Yilijabida, a-bardibardi, kulu wurdula andaa bajiwa bardarda, bijal walkurra ja-yirdardinji wurdula, rra-mangaji barra, ambuliyalu kalu-wukanyi li-wulu anku, ‘Barni-bardarda jandini, waraba anku bardardawu’, nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A-bardibardi jandini; ngalanda a-yalkuyi waraba danda-rdumanma bardarda, kulu kanda-bardibardirri, ngala kawul ilu-ngunda bardarda ki-Kada wula nyanki-wangu, bajiwa nya-mangaji bardarda wurdula andaa. Wirdiwalangu barra Kada, wunungu, waraba barlkibarlki yiwa, yiwa wirdiwalangu, kalngiya barra wunungu jiwini Kada.” ");
INSERT INTO jao_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kulu kanda-arri a-Miri, “Marnajingarna a-buyi yiku nyu-wirdiyu nyu-Kada, jarnamba-wirringundayi yiku. Kiwa-nmala nya-bardarda wurdula ngathangka, baku kiwa-yanjarrila, kangka kiya-wukanyi ngatha nganinya.” Kulu karrila-nda ki-jawinalu, ka-lhuwarri bawuji. ");
INSERT INTO jao_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wirdiwalangu na-wini Wukajaj, kalilu-maramarama li-wulu, “Kirru-wanila ki-awaralu nyungkirrunga yirru li-wulu wayathantharra, barrawulu bajinju kirru-wanila, kirru-yanjarri wumba baji; kirrilu-yibarrala nirru-wini wiji”, ");
INSERT INTO jao_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","nganinya ka-arri, ngaliwa nya-mbangu Kwirriniyaj ka-arri wirdi ki-awarala na-wini ");
INSERT INTO jao_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","awara Jirriya. Kulu kalu-wingkalwingka li-wulu wayathantharra, kalu-wani ki-awaralu nyungkalunga wiji. ");
INSERT INTO jao_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Barra ngamaliya ka-wingka mirningiya Jajiba wula a-Miri, kanda-arri arninanthangu yiku, rra-bundubundu, nakari Najarrida kawula-wingka, barrawu barra Najarrida namba nguthundu ki-awarala ki-mayangka Kalili, ngamaliya kawula-wingka nyala barrawu Bidiliyima ki-awarala ki-mayangka Judiya juju, na-wini barrawu Bidiliyima kalu-wundarrba, mili barrawu yiku ki-Dabida ki-wankalawu barra kalu-wundarrba, kanymarda na-wini; ka-wingka ngamaliya bajinju Jajiba, kangka nyiki-nganji ki-Dabida ki-wankalawu ka-arri, kulu Bidiliyima awara alunga liyikiliyi-nganjingku ki-Dabida. ");
INSERT INTO jao_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Kawula-yibanda baji, kawula-arri walkurr ki-barrawula nyungkiku ki-wunalawu; waraba kawula-nmanma nyungka-lunga liyi-wuluwu kangka kalu-ngaya wulanga awara linji-jakardalu kulu kawulamba-arrkalarrkanu. Kulu kumba-yarraka wurdula yanjarrinjawu bardarda, kanumba-lhakalhakarra a-Miri, ka-yanjarri barra marrantharl anku; kanda-rdirdilma ki-jumbalangka bardarda, kanda-yibarra ki-daladalangka lhangka ki-wujurla ki-rukungka, jinangu wujurl ma-ngarra ki-wunalawu, baji kanda-yibarra. ");
INSERT INTO jao_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kulu wundururra namba waka li-mbangu li-wulu, wujurl wujurl kalu-arri, kalu-yukuma jibi, kalu-wunkanu jibi baji. ");
INSERT INTO jao_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kulu karanka ka-lhakanba jawina yiku ki-Kada, kala-kala baji, kulu na-rlangan karnu-mirnngarri nakaringu ankangu ki-Kada, karnu-mirnngarri lukuluku aluwa, kalu-wardanka kurdandu yiku. ");
INSERT INTO jao_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ka-wukanyi alunga jawina yiku ki-Kada, “Barni-wardankaya! Kirrirni-nala narnu-yabi; baku kalu-yabirrila nalu-wurdu nyuwu-ja ki-wukawu ki-marringayawu li-wulu ");
INSERT INTO jao_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","wayathantharra. Rikarra ka-yanjarri bardarda ki-barrawula, kalu-wundarrba barrawu ki-Dabida; kalilu-marakamala-li-wulu nyungku-mangaji ki-bardardalu ngaliwa kiwa-nmala walkurra; wabarrangu kalili-nu ki-Kada li-wulu kili-jala nya-mangaji Kurayij; marniwa barra jina ");
INSERT INTO jao_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","bardarda ka-yanjarri. Kirru-laala nya-mangaji bardarda kalngiya yiwa kangka jirrirni-nanji yiku kirra-ngala nganinya, kanda-rdirdilma rrikurra-wibilu ki-jumbalangka, kanda-yibarra baji wujurla lhangka, ma-ngarra ma-ja ki-wunalawu jinangu wujurl, jiwini baji nganambaji; kirru-laala jarna-wukanyinji kalngiya yirrunga ngalirru kirra-ngala bardarda nganambaji.” ");
INSERT INTO jao_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kulu yinarrambalulu kalu-arri baji li-jawina likungu wunyathawu nalumiji, kalinyamba-riyarraba yiku ki-Kada, kalinyamba-lhawarrma yiku, kalu-wukanyi, ");
INSERT INTO jao_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bajiwa Kada ankangu juju, wirdiwalangu jiwini yabi; marnalu awarala wayka li-mbangu li-wulu, jumba-riyarrabanji alunga Kada, kiwa-ma kalu-yabirrila nalu-wurdu ll-mangaji li-wulu.” ");
INSERT INTO jao_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ngalalu kalu-wundirri ankaya awaralu yiku wunyathalu li-jawina, kalinyamba-wukanyi li-mangaji, nakalu-yukumanthaninya jibi, “Bawuji ngambala bjinju Bidiliyima! Kambala-ngala bardarda ki-daladalangka, kili-ja jawina ki-Kada nanthalu ngambalalu yiku, kambala-ngala ngandarra.” ");
INSERT INTO jao_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bajingu kalu-wingka nyala Bidil iyima nalu-wakuru, kawulalu-wakarama a-Miri wula Jajiba marda bardarda ki-daladalangka ka- ");
INSERT INTO jao_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","arri, kala-kala baji. Nawumba kalalinu li-wulu nya-mangaji wuka ki-bardardawu, kalilinu ambuliyalu ki-jawina nyiku ki-Kada ngalalu yukumantharra jibi, kalali-nu nalarrku li-wulu nganambaji. ");
INSERT INTO jao_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kalala-yngkarri nungkalarrku linji-wulungku, kalu-ruwama yngkarrinjawu jina wuka. Kulu li-mangaji, nakalu-yukumanthaninya jibi, kalu-wani ki-awaralu nyungkalunga, kalinyamba-wukanyi, “Marringaya barra jiwini Kada, wirdiwalangu jiwini, kilija jawina nyikungu nanthawu ngambalanga ki-bardardawu; kambala-kala bardarda; ka-wukanyi ngambalanga kalngi wuka Kada, jiwini wirdiwalangu barra, marringaya”, nganinya kalu-arri. ");
INSERT INTO jao_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngala a-mangaji a-Miri, kanda-linginmanthaninya ki-bardardawu nganambaji, kanumba-yngkalayngkarrinjaninya ki-bardardawu kulu liyi-mangaji, kalu-yukumanthaninya jibi, kulu aluwalu ka-lhakanba jawina yiku ki-Kada, ka-wukanyi alunga ki-bardardawu, kanumba-yngkalayngkarrinjaninya wumba ka-yanjarri bardarda. Bawuji. ");
INSERT INTO jao_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ngaliwa yarrambawaja baji Jirrujalima, na-wini yarrambawaja Bajuba, ngalawula nakaringu Najarrida kawula-wingka ngamaliya bjinju riyiki-biyi wula rrikurra-wibi ");
INSERT INTO jao_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ki-Jijaj; miyilmiyil ngalanda rra-mardu kawula-wingka nyungku-mangaji ki-yarrambawajalu, kulu ngaliwa Jijaj wangulu kalu-wingka bajinju nyala Jirrujalima nganambajilulu. ");
INSERT INTO jao_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kalu-wayatha yarrambawaja, kalu-walwani barra karingamala ngala waraba ka-wingkanma aluwa nya-mangaji wangulu, kiwa-bi baji ki-walkurrangka ki-barrawula Jirrujalima; nyiki-biyi wula rrikurra-wibi kawula-lhuwarri nguthundiya, rri-manji yiku kawula-lhuwarri ngaliwa kiwa-bi baji, ");
INSERT INTO jao_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","kathiwa aluwa ambirriju nungkalarrku linjiwulangalinji-nganjinya; kawula-yarrba yiku, kanawula-arrkalarra yiku, kalawula-wunkanu nalarrku, waraba yiku baji; kalawula-yalbanga liwulangali-nganji, “Nganthiwa nya-ardu, nganthiwa?”, ngala waraba barra kawula-wakaramanma baji aluwa, waraba. ");
INSERT INTO jao_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bawuji barra karinguthunda kawula-wani mili yarrbantharra yiku nyuwawulangaki-arduwu, kawula-wani ngamaliya Jirrujalima; ");
INSERT INTO jao_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","na-kanymarda arrkula na-wunbarr kawula-wingka; kawula-wakarama baji ki-kurdukurdula ki-barrawula nyiku ki-Kada, bajiwa wangulu, ka-arri mingkiya arndaarnda aluwa linji-wirdila, kalalu-milirdimanthaninya li-wulu yiku ki-Kada, ka-arri aluwa wangulu ngaliwa barra yngkarrinjarra, kalilu-yalbanganthaninya. ");
INSERT INTO jao_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kala-yngkarri ngaliwa ka-wukanyi, kalu-ruwama yiku baji ngaliwa ka-wukanyi ");
INSERT INTO jao_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","jululu, kalngi mingkin ka-arri; baki kawula-ruwama yiku ngaluwula kawula-wakarama baji; kanda-arri yiku yikurra-wibi, “Kulhakulha, ngalhiyu ka-binyu marnaji aluwa? Ngatharra nyinkunya-biyi katharra-yarrba yinku lukuluku, katharra-wardirri ngatharra-wurdu yinku wakulamba.” ");
INSERT INTO jao_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kawulilu-yalbanga, “Ngalhiyu kimbala-yarrba ngatha, ngalhiyu? Jina barrawu nyikungu wunyathawu, wunyathawu ngatha; yabingala karna-arri marnaji. Ngalhiyu yimbala rri-manji ngatha karna-arri wambu marnaji, ngalhiyu?” ");
INSERT INTO jao_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kawulamba-yakalyakaba yiku ngaliwa ka-wukanyi wulanga nganinya. ");
INSERT INTO jao_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bawuji barra, karingamala kawula-wingka nawula-yirdi yiku nyala alanjilu bajinju Najarrida. Lingi ka-arri wulaa, waraba barra ka-murdirrinma; kulu rrikurra-wibi kanumba-linginmanthaninya, kanumba-yngkalayngkarrinjaninya yiku, nganambaji ka-arri baji Jirrujalima. ");
INSERT INTO jao_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ka-yirdardi walkurra, kulu milirdi ka-arri baki lingi, kalinyamba-riyarraba nalu-wurdu yiku li-wulu, marda nyiki-biyi ankangu ka-yabirri na-wurdu yiku. Bawuji. ");
INSERT INTO jao_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Karakarra ka-wingka Jijaj bajinju ki-barrawulu, na-wini barrawu Niyin; ka-wingka bajinju nayirdi alunga liyiku liyi-jawina marda liyi-mbangu winkanda, kalu-wingka yilaa nalu-miji. ");
INSERT INTO jao_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngaliwa ka-wingka karakarra nungkanu-mulungka ngalbanthawu ki-barrawulu Niyin ngalalu kariya kalu-walanyma nungkulu-mangaji nungkanu-mulungka nalarrku li-wulu, akarrakarilu kala-ka ngabangaku linji-wulungku, mungku-alakala kala-ka. Kulu bajanda rrikurra-wibi ki-ngabangakuwu, a-miyaji a-mangaji, kumba-mirra nyanki-wangu; ngayamantharra arrkula nyanki-ardu, marda nya-mangaji kumba-mirra, ngabangaku bajiwa, kalu-walanyma nungkanu-mulungka li-jakarda andaa ngaliwa Jijaj nungkanu-mulungku. ");
INSERT INTO jao_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kayila-kala ki-jababalu bardabarda nyuwanki-arduwu rarrinjarra, kulu ka-rarri na-wurdu anku jababa; ka-arri, “Ngabiyarra, barni-rarrinja niyinki-arduwu!” ");
INSERT INTO jao_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Barra ka-wingka, kulu ma-alakala kilu-wuburrma wajkaliya, kulu kal inyamba-wama alarrinjarra li-mangaji, kala-ka wumba ma-alakala, kalu-jarrijarrima; ka-wukanyi jababa yiku ki-ngabangakuwu, “Yalkuyi, walanymayal Mingkiya anmaya!” ");
INSERT INTO jao_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kulu nya-mangaji barra ngabangaku, ka-walanyma yinarrambalulu, mingkiya ka-arri lhungku barra wukalukanyinjarra alunga; kila-ka lhungku andalu rrikurra-wibilu ki-jababalu, karrilu-ngunda yiku lhungku. ");
INSERT INTO jao_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kalu-wardanka kurdandu li-wulu wayathantharra; Ral inyamba-lhawarrma yiku ki-Kada, kalu-wukanyi, “Ka-wingka wunungu mirningiya nganuwalu, wirdiwalangu barra marniwa, yiwa wunyathawu nyikungu, ja-wukanyinji wuka yiku ki-Kada”; kulu kalu-arri, “Janilu-kunkunmanji ki-Kada, kilija jina mirningiya nganuwalu wunyathalu barra.” ");
INSERT INTO jao_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kulu baku li-mbangu li-wulu, li-jibiya, lukuluku ki-mayangka ki-awarala Judiya, kalinyamba-wukalukanyinjaninya yiku ki-Jijaj li-mangaji wayathantharra, kalu-arri, “Wunungu nya-mangaji Jijaj, ja-wukanyinji wuka wunyathawu, kili-ja ngambalalu wunyathalu.” Bawuji. ");
INSERT INTO jao_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ngalalu kalinyamba-wukalukanyi li-jawina yiku ki-Jijaj, ka-wingka baki ka-alarri Jijaj wumbiji aluwa; ka-arri, ");
INSERT INTO jao_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","“Marrirru marnajingarna!” Ngala kalu-wardanka nalu-wurdu, kalu-wardanka kurdandu nalu-wurdu barra, “Ngabaya ngabaya marniwa”; kathiwa ngabaya. ");
INSERT INTO jao_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka-arri alunga, “Ngalhiyu jirru-wardirrinji nirru-wurdu, ngalhiyu? Jirrinyamba-wukanyinji nirru-wurdu, ‘Ngalhi ");
INSERT INTO jao_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","jina?’ Wayi barra? Nganhirra-karra ngarna-marliji mili ngarna-marnda, kalngiya ngarna barra. Nganhirru-manhaya! Nganhirra-karra! Waraba narnu-ngawulu ngala ngarna ngarna-manka ngarnayirdi niyingarna-ngulyandawu.” ");
INSERT INTO jao_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kulu kalu-arri lhaba nyamba-yngkalayngkarrinjarra yiku, “Kalngiya yiwa barra nungka ka-wani?” Kalu-ruwama, kalu-yabirri nalu-wurdu yiku. Ka-arri alunga, “Ngalhi wudurru yirruwa thanthawu?” ");
INSERT INTO jao_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Kalu-ngunda arlku na-warnnyi, wunhunhu barra; kila-ka arlku, kiwa-tha nya-mangaji ngalalu kalu-wunkanu. Bawuji. ");
INSERT INTO jao_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kumba-mirra Jijaj yundulu, ngabaya kalu-yibarra bawuji; ngala ka-lhungkurri, kulu kumba-mirnajima lhungku alunga liyi-jawinawu liyiku arrkula ngakarla baki buyi ngakarla, na-40 na-wunbarr, kunba-mirnajima kalngiya yiwa, kulu ka-wukanyinjaninya alunga bakuwu ngaliwa Kada ka-nmala wirdiwalangu kinga alunga liyi-wuluwu. ");
INSERT INTO jao_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Ngaliwa Jijaj ka-arri aluwa baki ka-arri alunga, “Rra-nmaya marnaji Jirrujalima! Barni-lhuwarrinja! Ambuliyalu karnili-nu wunyathalu, kulu kirrirni-nu ngulakari, baki kanhirra-yngkarri, ka-wingkala yirruwalu Jawukama ki-Kada karankangu; ambuliyalu kalilu-ngabunjama li-wulu ki-Jana, kalilu-ngabunjama winarrkululu ki-wabudala, ngala baku ngulakari yiwa kirrilu-ngabunjamala ki-Jawukama ki-Kada karankangu, kirrilu-ngabunjama wunyathalu. Bawuji barra, rru-yukumaya marnajingulaji yiku!” ");
INSERT INTO jao_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ngalalu kalinyamba-darlbirra baji li-jawina liyiku, kalu-yalbanga, “Wirdi, nyala marnalu li-ja li-nganji nyungku-ja ki-mayangka, li-ja li-wirdi nganunga, nganu li-Juwu likili-nganji ki-wankalawu ki-Yijriyil. Nganthimbala kilinya-jujunymala li-mangaji, kulu nganu barra li-Juwu nganulumba, waraba alunga nuwalarrkulu? Nganthimbala kal inya-jujunymala? Nganthimbala yinda wirdi nganunga? Nungka nyalalhurrku?” ");
INSERT INTO jao_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ka-arri alunga, “Jarnilu-laanji narnu-yuwa wunyathalu, ngayamantharra yiwa milirdi, jarnilu-laanji, ngala waraba mili yirru, yirru li-manji; kirrili-nala ");
INSERT INTO jao_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","nganthimbala karna-nmala wirdi; ngala kirra-nmala li-wunungu ngaliwa ka-wingkala yirruwalu Jawukama ki-Kada karankangu, yiwa anmanthawu yirruwa, kulu kalirri-nalinala li-wulu ngatha barra, kal irri-nal inalal nalu-arrku li-jibiya Jirrujalima, marda li-jibiya nyungku-ja ki-mayangka Judiya marda Jamiriya, baki kal irri-nal inala nalarrku li-wulu jalini nyungkarrku ki-mayangka akarru, angula, nguthundu, ngamala, kalirri-nalinala ngatha barra li-wulu wayathantharra.” ");
INSERT INTO jao_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nganinya ka-arri alunga, kulu bawuji barra Jijaj ankaya, kilu-rankarrma ankaya wunyathalu ngalalu wunkanantharra yiku kulu kilu-ngaya ki-ngawungku, waraba ");
INSERT INTO jao_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","kalu-nganma mili bawuji; ngalalu alarrinjarra ngantharra ankaya ngala kawulala-kala kanymarda jawinawujara ki-Kada alarrinjarra wunumbarra, barranamba rri-mirningiya rri-mangaji, burnalkarra ");
INSERT INTO jao_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","wulanga jumbala, kulu kawula-arri, “Marrirru, yirru li-jibiya Kalili, ngalhiyu yirru wunkanantharra ankaya ki-ararru, ngalhiyu? Jina Jijaj kirra-kala ankaya wunyathalu bajinju ki-awaralu ki-Kada, ka-wanila nyulu-mangaji, ka-wanila baku; kirra-kala yiwa ankaya rikarra; nganambajilulu ka-wanila karanka baku.” Bawuji barra kulu li-jawina liyiku ki-jababawu kalu-wani aya bajinju Jirrujalima. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Marnajingarna, Bula, ngayangaya yiku ki-Jijaj Kurayij, karnilu-ngalkingunda, karnilu-yibarra ngarna nmanthawu ruthuruthu nyikungu jawina, nanthawu awara yiku, Karnilu-ruthuruthuma nakaringu linji-wulungka nungkalarrku, ngarna nalinanthawu awara yiku ki-Yijanku ki-Kada, wukanyinjawu nuwarniku nuwarnu-yabiyu. ");
INSERT INTO jao_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Na-mangaji narnu-yabi narniku ki-Kada, ki-wankalawu karnili-nu narnu-buyi alunga liyi-mbangu liyi-wuluwu, kalili-nu li-mbangu wumba nakalu-wukanyinjaninya yiku, kulu karnalu-yibarranthaninya nungku-burruburrula na-mangaji narnu-marringaya narniku ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Na-mangaji narnu-yabi, ambuliyalu kalili-nu ki-Kada buyi wuka yiku nyiki-arduwu, ka-yanjarri na-bardarda nya-mangaji, nakaringu ki-wankalawu ki-Dabida bajingu nyiki-murimuri, ");
INSERT INTO jao_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","kulu na-ngawulu ki-Yijanku ki-Kada, marringaya. Ki-Kada, kilu-lhungkuma Jijaj wumba ngabangaku ka-arri. Bajingu ngarabala kambala-lhaa yiwa nyiki-ardu kalngiya wunungu, yabi, nya-mangaji Jijaj Kurayij, ngambalanga Wirdiwalangu. ");
INSERT INTO jao_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Yiwa jiwini yabi ngambalanga, yabi nganunga wumba kanilu-yibarra nmanthawu ruthuruthu likungu li-jawina, nanthawu li-wulu yiku. Namba jalingani-nanji li-wulu yiku ki-Jijaj, li-wulu lukuluku, alu wiji wayathantharra, kulu nalarrku jala-nykarrinji nya-mangaji wuka, jalinyamba-yibarranji nalu-wurdu yilaa, jalini ngayangaya yiku. Bajuwarnu kanilu-yibarra li-jawina likungu. ");
INSERT INTO jao_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Marda yirru, kirra-nykarri wuka wumba janu-wukanyinji, kirrinyamba-yangama yirru nmanthawu ngayangaya yiku ki-Jijaj, kirrilu-ngalkingunda, kirrilu-yibarra yirru nmanthawu likungu. ");
INSERT INTO jao_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Jarna-balirranji wuka yirrunga, jirrini baji angula ki-barrawula, na-wini barrawu Ruma. Jirrilu-manmarralanganji wakulamba ki-Yijandu ki-Kada, wabarrangu kirrilu-ngalkingunda nyungku-ja, yirru nmanthawu ruthuruthu likungu. Jarna-balirranji jinangu yirrunga, kulu karna-yalbanganji Yijan Kada ankaya yirrunga, Wunyatha wula Wirdiwalangu Jijaj Kurayij kawulima-yalbanganji, wula yabimanthawu awara yirrunga, yirru nmanthawu yabi nirru-wurdu, wuntha nirru-wurdu. ");
INSERT INTO jao_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Jarna-wukanyinji ankaya Wunyathawu, kulu ambuliyalu jarna-barlirranji yirrunga wumba kirrinyamba-yibarra nirru-wurdu yilaa ki-Jijaj Kurayij. Jarna-barlirranji mili yirrunga kangka li-mbangu nalarrku li-wulu, ki-awarala ki-mayangka lukuluku li-mangaji, kala-nykarri yirrunga wumba kirrinyamba-yibarra nirru-wurdu yilaa ki-Jijaj, jalali-nanji lalungali-nganji yirrunga, jalali-nanji nganinya, “Marrirru! Li-mbangu li-wulu, li-jibiya barrawu Ruma, bajalu nalarrku likungu ki-Jijaj, Li-mangaji barra, kalinyamba-yibarra nalu-wurdu yilaa ki-Jijaj Kurayij kalngiya li-mangaji,” nganinya jalu-wukanyinji. Kulu jarna-barlirranji Wunyatha yirrunga. ");
INSERT INTO jao_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kulu jilu-lhaanji awara ngatha ki-Kada, kalngiya jarna-yalbanganji ankaya yirrunga yurrngumantha. Karnamba-yibarra ngarna-wurdu yilaa ki-Kada, ngarna nmanthawu jabungka yiku, kulu yurrngumantha kalirni-nanji li-wulu yiku ki-Jijaj, nyiki-arduwu. Jilu-lhaanji awara ngatha nyungku-ja ki-Kada, wumba jarnini mududu, kalngiya jarna-yalbanganji yirrunga miyilmiyil, ");
INSERT INTO jao_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","baki mili jarna-yalbanganji Kada, karnilu-wirrangala wingkayarra yirruwalu. Jarnini ndiwi wingkayawu aya yarlajka bajinju yirruwalu kangka jirrirna-mijanganji. ");
INSERT INTO jao_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Jirrirna-ngandiyanganji nganthawu yirrunga, jirrima-ngandiyanganji ngarna nmanthawu yirruwa baji, milirdimanthawu mili yurrulu nyikungu wuka ki-Kada, nya-mangaji wuka wunungumanthawu nirru-wurdulu. ");
INSERT INTO jao_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Karnamba-yibarra ngarna-wurdu yilaa ki-Jijaj, marda yirru, kirrinyamba-yibarra nirru-wurdu yilaa ki-Jijaj. Kulu kambalamba-wukalukanyila yiku ki-Jijaj, kulu kambalamba-wunungumala ngambala-wurdulu nganinya, ngambala wiji. Jirrirna-mijanganji nganinya. ");
INSERT INTO jao_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Karnambi-nanjama yirrunga, marrirru, yirru nmanthawu li-mirdan ngatha, karnamba-nykalanykarri miyilmiyil ngarna wingkayawu aya yirruwalu, ngala minja karnamba-ayayanu wingkayawu. Karna-wingkayama yirruwalu, ngarna milirdimanthawu yirrunga, yirru nykarrinjawu Wirdiwalangu Jijaj mili yurrulu, yirru yirdardinjawu barranamba li-mbangu nalarrku winkanda wumba kalirna-milirdima, alu yirdardinjawu. ");
INSERT INTO jao_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kangka karnilu-maramarama Wunyathalu, ngarna wukanyinjawu alunga liyi-wuluwu liyi-jakardawu, alu nykarrinjawu Wirdiwalangu Jijaj, Karnilu-yibarra milirdimanthawu li-wulu, nalarrku li-wulu li-Kurika baki nalarrku li-nganji, nalarrku wumba jalini li-mirdan ki-awarawu baki nalarrku wumba jalini li-manji ki-awarawu. ");
INSERT INTO jao_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kulu jarnini marnaji yukumantharra baku ngalingarna karna-wukanyila yirrunga marda, yirru li-jibiya Ruma, karna-wukanyinjama nya-mangaji, narniku narnu-yabi ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kurdardi karna-wananjima nyuwu-ja ki-wukawu nalinanthawu yiku ki-Jijaj ngala jarnamba-riyarrabanji nyuwu-ja ki-wukawu wakulamba, kangka jiwini wunungu Kada marakamanthawu li-wulu nyungku-ja ki-wukangka, jiwini wunungu marakamanthawu li-mangaji wumba jala-kanji jinangu wuka yabimantharra, jalinyamba-yibarranji nalu-wurdu yilaa. Jinangu wuka wumba karni-nu alunga liyi-wuluwu ki-awarala ki-jakardala, ambuliyalu karni-nu alunga liyi-wuluwu liyi-Juwu kulu ngulakari kalirni-nu li-wulu nalarrku bajalu marda, kulu jarna-lhaanji jinangu wuka nganinya barra, wunungu yabimanthawu li-wulu nalu-wurdulu, ");
INSERT INTO jao_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kulu jinangu wuka nalinanthawu yiku ki-Jijaj, jinangu wuka wumba ka-wukanyi Kada, ja-wukanyinji ngambalanga, “Marrirru! Ngalirru jirrinyamba-yibarranji nirru-wurdu ngathangka, ngalingarna jirrirna-yibarranji yirru nmanthawu yurlurr ngatha. Kulu ngalirru jirrini yurlurr ngatha ngalirru kirrinyamba-yibarranthanama nirru-wurdu ngathangka.” Barranamba wankala kili-nu wuka ki-Kada, kilu-balirra ki-arrkulangku ki-wankalangku, “Li-mangaji li-wulu, kalinyamba-yibarra nalu-wurdu ngathangka kulu kalirna-yibarra alu nmanthawu yurlurr ngatha, li-mangaji barra kala-nmala lhungku nalu-yurrngu,” nganinya ka-arri. ");
INSERT INTO jao_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","19","Jinangu Yijan Kada ankangu, jila-nganji awara, jalila-nganji li-wulu li-mangaji li-wardi wumba jalu-wardimanji awara, jalu-wingkayi wardimbangu, jalini nungkarnu-wardinja. Jalila-nganji ki-Kada kulu ja-wukanyinji alunga liyi-wuluwu nalu-wurdu, jumbi-nanji barra, yiwa ja-yinjathirrinji wirangu narnu-wardi na-mangaji narnalunga wumba jalini li-wardi, kulu bajuwarnu nuwarnu-wardiyu kalilu-ramala li-mangaji wumba jalini li-wardimbangu, kalilu-ramala. Kangka li-mangaji, jalu-wardimanji awara alunga nuwalarrkulu, alu nykarrinjawu ki-Kada wuka nyikungu marringaya. Li-mangaji nalarrku, kurdardi kala-nykarriyu namba Kada ja-wukanyinji kalngiya alunga nalu-wurdu kangka ngayamantharra narnu-wardi jarnala-nykarrinji yurrngumantha, ngayamantharra li-wulu li-wardi nungkarnu-wardinja jalala-nganji, kurdardi kala-nykarriyu Kada ki-awarala baji. Nganinya li-mangaji li-wardimbangu jalu-wardimanji awara alunga. Bajuwarnu barra Yijan Kada, ja-yinjathirrinji nuwarnu-wardiyu nuwarnalunga, kalilu-ramala li-mangaji li-wardimbangu. Nganinya barra jiwini Kada yinjathirrinjarra na-wurdu, kangka li-mangaji jalini buyi mirdan yiku ki-Kada kangka kala-kala awara wiji wumba kilu-yabima ngala kurdardi kalinyamba-nykalanykarrinjanima yiku ki-Kada wumba kilu-yabima. ");
INSERT INTO jao_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Li-mbangu li-wankala, kala-nganthaninya awara, nya-mangaji awara wumba ki-Yijandu ki-Kada kilu-yabima mulungka wumba kurdardi ki-awarawu, kilu-yabima wiji bawuji, kala-nganthaninya, kulu bajingu kala-ninya buyi mirdan yiku ki-Kada. Kulu nganinyanga marda jala-nganji jinangu awara linji-wulungku linji-mangaji linji-wardimbangu marda. Kurdardi kala-nganjima yiwa Kada ngala jalanganji yamulu jinangu awara wumba kilu-yabima. Kulu bajingu barra li-mangaji li-mirdan yiku nganinya, nyungku-mangaji kilu-yabima awara, nya-mangaji wumba najiwini walkurrawala, wunungu nakaringu ambuliyalu wumba kilu-yabima awara, kalngiya yijan yiwa. Bajingu barnikala-wukanyirru barra, “Nganu li-manji yiku ki-yijanku nyuwu-mangaji,” barnikala-wukanyirru nganinya, ");
INSERT INTO jao_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","kangka kala-nganthaninya awara wumba kilu-yabima, kulu jalu-lhaanji nganinya linji-wulungku linji-mangaji, jalu-lhaanji awara wumba kilu-yabima ngala kurdardi kalu-ngayamanjima yiku ki-Kada wumba kilu-yabima, kurdardi kalinyamba-lhawarrmanjima yiku, kurdardi kalu-barlirranjima yiwa, ngala minja jalinyamba-nykalanykarrinji winarrku, jalu-yakayakirrinji, waraba nykarrinjawu awara kalngiya, nganinya jalini li-wardi. ");
INSERT INTO jao_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Jalinyamba-wukanyinji, “Ngambala li-mirdan,” ngala kurdardi, li-manji jalini li-yakayaka ki-awarawu, jalu-yakayakirrinji. ");
INSERT INTO jao_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Kala-nda nya-mangaji, kala-nda nya-mangaji wumba kala-nykarri yiku ki-Yijanku ki-Kada ambuliyalu. Waraba kalinyamba-lhawarrmanma yiku, yiwa walkurrawala wunungu, lhungku na-yurrngu nya-mangaji, kalngiya marringaya Yijan yiwa, kala-nda, kulu kalu-yibarra nyarrku yijan, nya-mbangu barranamba mirningiya wumba kumba-mirrala ngabangaku, nya-mbangu barranamba julaki kalu-yibarra yijan, nya-mbangu barranamba wunala, barranamba lhuwa, nya-mangaji nyarrku kalu-yibarra yijan alunga, kulu jalu-ngayamanji nyuwu-mangaji, jalinyamba-lhawarrmanji yiku barra bawuji, kurdardi kalinyamba-lhawarrmanjima Kada. ");
INSERT INTO jao_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Bajuwarnu barra kalila-nda li-mangaji ki-Kada, kalila-nda. Bajingu barra jalu-mijanganji nalu-wurdu nmanthawu nungkarnu-wardinja, nganinya jalini li-wardimbangu wiji. Jalu-wardirrinji nalu-wurdu mijanganthawu nuwarnu-wardiyu, jalu-wardirrinji nalu-manka nungkarnu-wardinja wumbimbijilu. ");
INSERT INTO jao_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nganinya kalila-nda ki-Kada kangka kala-nda yiwa wumba kalngiya kala-nykarri awara yiku, kalu-lhuwarri yiwa wambu kalngiya Yijan, kulu kalu-wanda nyarrku wumba kathiwa yijan, kurdardi kalinyamba-lhawarrmanma yiku ki-Kada, nya-mangaji wumba kalngiya kilu-yabima awara wiji, kurdardi, ngala kalinyamba-lhawarrma nyuwarrkulu wumba kalu-yibarra yijan, kalu-yabima marlijinda nya-mangaji barranamba mirningiya, julaki, wunala, marda lhuwa, jalu-wandayi nya-mangaji barra wumba buyi yiku jiwini. Yiwa Kada kalngiya Yijan, walkurrawala, kilu-yabima nya-mangaji mirningiya, julaki, wunala, lhuwa wiji, yiwa marringaya, yabi alunga liyiwuluwu wiji, alu ngayamanthawu yiku nalu-yurrngu, alu nyamba-lhawarrmanthawu yiku nalu-yurrngu barni-binjawu. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Bajingu barra kalila-nda ki-Kada, kalila-nda li-mangaji wumba kala-nda yiwa. Kulu li-mangaji, jalinyamba-mijanganji wumimbijilu wardingala. Li-mbangu li-nhanawa, jalalu-mijanganji nalarrku li-nhanawa nmanthawu barranamba lalungali-wangu. ");
INSERT INTO jao_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Kulu li-mbangu li-wulu, nganambaji marda kalala-nda li-nhanawa lalungali-wangu, kulu jalalu-mijanganji nalarrku li-mayani nmanthawu barranamba lalungali-wangu, wakulamba barra jalalu-mijanganji li-mayani, kurdandu barra jalalu-mijanganji nganinya wardimbangu, kurdardi yabi ngala kalngiya wardimbangu. Li-mayani jalini nungkarnu-wardinja, li-wardi, li-mayani barranamba li-majkalmajkarra - jarna-wananji nalinanthawu awara alunga - kulu bajuwarnu barra jalu-wardirrinji nalu-manka, jalu-wardirrinji barra kangka jalini li-wardimbangu nganinya. ");
INSERT INTO jao_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kulu li-mangaji li-wulu, waraba kalinyamba-lhawarrmanjima yiku ki-Kada ngala minja jalungajbirrinji yiku, kulu jalila-ndayi ki-Kada, alu nyamba-nykalanykarrinjawu wardingala yurrngumantha, alu nmanthawu nganinya nungkarnu-wardinja, wardimantharra awara. ");
INSERT INTO jao_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Kulu li-mangaji barra, kurdandu barra jalu-wardimanji awara, wurluburlu nalu-wurdu nuwarnu-wardiyu. Jalu-wingkayi wardingala, li-ngajbirrinj amara, j alalu-wardimanji nalarrku, jalini li-warrki rdumanthawu awara, kurdardi nuwarnu-yabiyu aluwa ngala ngayamantharra jarnalu-mijanganji narnu-wardi, li-mangaji wurluburlu nalu-wurdu nuwarnu-wardiyu. Jalu-nganymanji alunga nuwalarrkulu, marda jalu-wangarrabanji li-wangarrmara, marda li-ramanthamara jalini, jalalu-ramanji nalarrku yundulu bawuji. Jalinyamba-wajkirranji nyamba-wukanyinjarra wardingala marda alunga nuwalarrkulu, marda jalinyamba-nykalanykarrinji nuwarnu-wardiyu yurrngumantha, kulu wardimanthawu awara alunga nuwalarrkulu, li-mangaji wurluburlu nalu-wurdu nuwarnu-wardiyu. Jalu-wukanyinji wardingala alunga nuwalarrkulu. ");
INSERT INTO jao_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Jalalu-lhawamanji wakulamba, kulu jalu-mulamulanganji Yijan Kada. Li-mangaji liwardi, jalu-wukanyinji li-arramanthangu, jalu-wingkalwingkayi li-arramanthangu, jalinyamba-alarramanji wiji. Li-mangaji jalinyamba-wukanyinji, “Ngandarra barra nmanthawu narnarrku narnu-wardi, ngandarra?” Kulu jalu-ngajbirrinji liyiyalungaliyi-biyiyu, liyiyalungaliyi-wibiyu jalu-ngajbirrinji. ");
INSERT INTO jao_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Li-mangaji, kurdardi kalima lingi, li-yakayaka jalini. Namba jalalu-warrangkayi kulu kurdardi kalima nganinya ngulakari, minja jalalu-warrangkayi winarrku. Kurdardi kalalu-manmarralanganj ima lalungali-nganji, kurdardi kalu-rarrinjima alunga nalu-wurdu, nganinya jalini li-wardimbangu, wurluburlu nalu-wurdu nuwarnu-wardiyu li-mangaji. ");
INSERT INTO jao_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Kulu li-mangaji, jalinyamba-nykalanykarrinji nalu-wurdu yiku ki-Yijanku ki-Kada, yiwa kalilu-ramala li-mbangu wumba jalu-wardimanji awara nganinya, kalilu-ramala ki-Kada alu nyamba-mirranthawu. Jalinyamba-nykalanykarrinji nganinya, ngala minja jalu-wardimanji awara, jalu-ngajbirrinji yiku ki-Kada wumba jalu-lhaanji nganinya. Alu jalu-wardimanji awara nganinya, kulu jalu-ngayamanji alunga nuwalarrkulu wumba jalu-wardimanji awara, jalu-ngayamanji alunga wumba jalu-ngajbirrinji yiku ki-Kada marda. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","2","Karna-wukanyila barra alunga liyi-wuluwu wiji wayathantharra. Yirru, wumba jirrini li-wardi, jirru-wukanyinji alunga nuwalarrkulu, “Li-mangaji, kurdardi yurlurr kalu-wingkayima, kurdardi.” Ngalirru jirru-wukanyinji nganinya ngalirru jirrinyambi-nanji yirru li-mirdan nuwarnu-yuwawu wingkayawu yurlurr. Namba yirru jirru-wukanyinji nganinya barra nganinyanga, kulu baku kurdardi kirrinyambi-narru yiku ki-Kada, “Nganu li-manji. Baji ngalinganu kanu-wardimanthaninya awara, li-manji kanu-arri wingkayawu yurlurr,” barnikirrinyambinu yiku nganinya. Namba jirrinyamba-wukanyinji nganinyanga, “Ngambala, li-mirdan jambalini alunga liyi-mangaji wumba jalu-wardimanji awara,” kulu baku kirrili-nala ki-Kada, “Yirru, ngalirru kirru-wardimanthaninya awara ngalirru kirrinyamba-lhaanthaninya yirru wardimanthawu awara. Kulu ngarna barra, jarnini yurlurr ngalingarna kirrirna-ramala, kirrirna-ramala nuwarnu-wardiyu nuwu-mangaji nuwarnirrunga.” Kulu Kada, kiwa-nmala yurlurr ngaliwa ka-wukanyila alunga liyi-wuluwu nganinya. ");
INSERT INTO jao_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","4","Kulu yirru, nungka jirrinyamba-wukanyinji, “Li-mangaji, jalingambala-lhaanji alu wardimantharra awara, kurdardi yurlurr li-mangaji, li-wardimbangu. Ngala minja ngambala, jambala-wardimanji awara ngala minja kambala-wingayanama winarrku, kurdardi ngambala kambalilu-ramarru ki-Kada, kurdardi kambalilu-ramarru nuwarnu-wardiyu nuwarnu-ngambalanga,” nganinya jirru-arrinji. Ngala kurdardi. Kalngiya kirrilu-ramala nuwarnu-wardiyu. Nungka jirrinyamba-wukanyinji mili, “Kada yabi barra, jiwini yabi ngambalanga, kurdardi kambalilu-ramanma nuwarnu-wardiyu ambuliyalu. Bawuji barra, kambala-wardimanthanama awara ngambala-yurrngu kangka kurdardi kambalilu-ramarru,” nungka nganinya jirrinyamba-wukanyinji. Ngala kurdardi. Jirru-warndimanji awara nganinya. Yabi jiwini Kada yirrunga, aliyaliya kirrilu-ramala nuwarnu-wardiyu, aliyaliya, kangka ja-yukumanji yirrunga, yirru nyamba-yangamanthawu, yirru rarrinjawu nuwarnu-wardiyu nuwarnirrunga, ja-yukumanji yirrunga, yirru ndayawu na-mangaji namu-wardi. ");
INSERT INTO jao_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ngala yirru, kurdardi karnirra-ndarrma, jirru-wardimanji awara, jirru-ngajbirrinji yiku ki-Kada, waraba rarrinjawu nuwarnu-wardiyu nuwarnirrunga, jirru-wardimanji awara. Kulu bajungkarnu jirru-wardimanji awara marda yirrunga bakuwu. Ki-Kada jarnilu-mulamulanganji narnu-wardi kurdandu. Ka-yinjathirrila nuwu-mangaji nuwarnu-wardiyu nuwarnirrunga nuwarnu-jakardawu, ka-yinjathirrila baku ngaliwa kalilu-ramala li-wulu li-wardi, li-mangaji wumba kurdardi kalu-wingkayanima yurlurr yiku. Ngala li-mbangu nalarrku, kalu-wingkayaninya yurlurr yiku, kurdardi kalilu-ramarru li-mangaji, kalu-wingkalwingkayanama winarrku yabi. Nganinya ka-arrila alunga liyi-wuluwu wiji, kalngiya jiwini yurlurr, Yijan Kada. ");
INSERT INTO jao_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kulu kilu-yabimala awara ngambalanga liyi-yabiyu liyiku ngala alunga liyi-wardiyu kilu-wardimala awara. ");
INSERT INTO jao_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nalarrku jalu-wingkayi yurrngumantha yabimantharra, yukumantharra yiku ki-Kada, yiwa yabimanthawu awara alunga baku, jalu-mijanganji yiwa ngayamanthawu alunga, yiwa nyamba-riyarrabanthawu alunga, marda jarnalu-mijanganji alu nmanthawu li-lhungku nalu-yurrngu barranamba yiwa jiwini lhungku na-yurrngu. Li-mangaji barra kalilu-ngundarra na-mangaji narnu-lhungku ki-Kada, kalilu-lhungkumala nganinya, alu nmanthawu li-lhungku nalu-yurrngu barni-binjawu. ");
INSERT INTO jao_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ngala nalarrku, minja jalinyamba-nykalanykarrinji nuwarnalunga, rdulurdumanthawu awara ruthuruthu alunga, alu nmanthawu li-walkurrawala. Kurdardi kala-kanjima wuka, nya-mangaji yurlurr wuka yiku ki-Kada, kurdardi kalima ngayangaya nyuwu-mangaji ngala minja narnu-wardi jarnala-kanji, jalini ngayangaya alunga liyi-wardiyu nmanthawu nungkarnu-wardinja, li-mangaji barra. Ngala Kada, ka-wardirrila na-wurdu alunga, ka-yinjathirrila alunga wirangu narnu-wardi narnalunga. Kurdardi kumba-riyarrabarru alunga ngala ka-yinjathirrila na-wurdu alunga nuwarnu-wardiyu wakulamba. ");
INSERT INTO jao_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Alunga liyi-mangaji wumba jalu-wardimanji awara, kala-nmala nungkarnu-wardinja. Ka-wingkala budijbudij awara alunga, rukurrinjawu nalu-manka, rarrinjawu, ka-wingkala alunga liyi-mangaji wiji, ambuliyalu alunga liyi-wuluwu liyi-Juwu, ngala alunga liyi-wuluwu nuwalarrkulu ngulakari. ");
INSERT INTO jao_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ngala alunga liyi-mbangu wumba jalu-yabimanji awara, kala-nmala nungkarnu-yabinja yilaa ki-Kada. Ka-ngayamala alunga, kumba-riyarrabala alunga, kalilu-yabimala nalu-wurdu nmanthawu wuntha, nganinya ka-nmala alunga liyi-mangaji wiji, ambuliyalu alunga liyi-wuluwu liyi-Juwu, ngala alunga nuwalarrkulu ngulakari. ");
INSERT INTO jao_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kurdardi kumba-yangamanjima Kada alunga nuwalarrkulu kulu nuwalarrkulu ngala minja nganinya arrkula jiwini yurrngumantha alung liyi-wuluwu wiji, ngayamantharra yurlurr. Yurlurr jiwini alunga liyi-wardiyu wumba kalilu-ramala li-Juwu baki nalarrku, wiji li-wardi. Marda alunga liyi-yabiyu jiwini yurlurr yabimanthawu awara alunga, alunga liyi-Juwu baki alunga nuwalarrkulu, alunga liyi-yabiyu wiji. ");
INSERT INTO jao_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Li-mbangu, jalu-wardimanji awara wumba jalini li-manji nuwarnu-yuwawu ki-Mujij, kalilu-ramala ki-Kada; waraba kangka kalu-ngajbirrinjima nuwu-mangaji, ngala kalilu-ramala kangka jalu-wardimanji awara, waraba kalu-wingkayima yurlurr nuwu-mbangu wumba jarnala-nykarrinji narnu-yabi nalu-wurdu. Li-mbangu nalarrku, jalu-wardimanji awara wumba bajarnu narnu-yuwa ki-Mujij aluwa, kalilu-ramala ki-Kada kangka jalu-ngajbirrinji nuwu-mangaji nuwarnalunga. Kalilu-ramala nganinya li-mangaji nuwarnu-yuwawu kangka jarnala-nykarrinji winarrku, waraba kalu-ngayangayarrinjima nuwu-mangaji. ");
INSERT INTO jao_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kurdardi ki-Kada kalili-narru li-mangaji li-wulu, “Yirru yurlurr kangka karnirra-nykarri narnu-yuwa narnu-ngatha wumba karna-ngunda Mujij,” kurdardi ka-arriyu nganinya alunga, kangka jarnala-nykarrinji winarrku, kurdardi kalu-ngayangayarrinjima nuwarnu-yuwawu nuwarnu-yabiyu wumba jalini naluyirdi nuwu-mangaji. Ngala nalarrku, namba jarnala-nykarrinji narnu-yuwa, jarnala-kanji, jalu-wingkayi yurlurr nuwu-mangaji, kulu kalili-nala li-mangaji, “Yirru kirrirna-yibarra yirru nmanthawu barranamba yurlurr ngatha,” nganinya ka-arrila alunga. ");
INSERT INTO jao_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kulu li-mbangu, waraba li-Juwu ngala nalarrku li-wulu, waraba alunga barra narnu-yuwa ki-Mujij ngala li-manji li-mangaji, namba jarnala-nykarrinji narnu-yabi nalu-wurdu li-mangaji marda jalu-wingkayi yabi barranamba ki-Mujij kilu-yibarra alunga liyi-wuluwu wingkayawu yabi, kulu li-mangaji barra jalini barranamba li-mbangu wumba jalini li-mirdan nuwarnu-yuwawu, li-ngayangaya jalini, nganinya jalini li-mangaji wumba kurdardi aluwa barra narnu-yuwa ki-Mujij. ");
INSERT INTO jao_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Namba jalu-ngayamanji nuwarnu-yabiyu, namba jalu-wananji nuwarnu-wardiyu, kulu nalarrku li-wulu winkanda, jalini mirdan alunga wumba jala-nykarrinji Kada kalngiya nalu-wurdu. Nganinya j alinyamba-nykalanykarrinj i barranamba Kada ja-wukanyinji nuwarnu-yabiyu baki nuwarnu-wardiyu nungkarnu-yuwangka nungkarniku. ");
INSERT INTO jao_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Bawuji barra kulu Kada, nganinya ka-nmala alunga liyi-wuluwu wiji barra, baku ngaliwa kilu-maramaramala Jijaj Kurayij, yiwa ruthuruthumanthawu li-wulu, ruthuruthumanthawu li-mbangu wumba jalini li-yabi barra nalu-wurdu nyamba-nykalanykarrinjarra barra, mili li-mbangu nalarrku barra wumba jalini li-wardi nyamba-nykalanykarrinjarra barra nalu-wurdu barra. Na-ja barra narnu-yabi wumba jalili-nanji li-wulu. ");
INSERT INTO jao_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ngala yirru, marrirru, jirrinyambi-nanji, “Nganu li-Juwu,” yirru barra jirrinyamba-alarramanji nganinya, “Nganu likungu ki-Yijanku ki-Kada, li-yabi. Karnilu-ngunda narnu-yuwa narnu-yabi na-nganunga. ");
INSERT INTO jao_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Nganu li-mirdan nuwarnu-yuwawu ki-Kada, nganu janu-ngayamanji nuwarnu-marringayawu kangka kanalu-milirdinia narnu-yuwa linj i-wurrirrinju linji-nganunga. ");
INSERT INTO jao_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","Nganu li-mirdan yunduyundumanthawu awara alunga liyi-mbangu wumba li-manji jalini li-yakayaka. Barranamba nya-mbangu yumbu ja-wingkayi nungku-rlangandu, jumba-alathamanji nungku-rlangandu wundururra, barranamba li-wulu kalu-wingkayima nganuwalu, kalinyamba-alathamanjima nganuwalu, nganu li-wirdiwalangu milirdimanthawu, ngayamantharra nganuwalu. Jalinganu-milirdimanji li-yakayaka wumba jalini li-manji barranamba li-ardubirri. Nganu li-mirdan barra, li-yuwawiji barra, nganu nganuyirdi nuwarnu-yuwawu wumba kalngiya wuka ki-Kada,” nganinya jirrinyamba-alarramanji. ");
INSERT INTO jao_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kulu jarna-wukanyinji yirrunga barra. Namba jirrinyambi-nanji nganinya, yirru nirruyirdi nuwarnu-yuwawu ki-Mujij, yurlurr jinangu wuka kalngiya, namba jirru-yunduyundumanji awara alunga nuwalarrkulu nganinya, kulu wayi barra yirru? Ngalhiyu kurdardi kirrinyamba-milirdimanjima yirru? Jalirri-nanji li-mangaji, “Barni-wajkirrantha awara!”, ngala yirru, jirru-wajkirranji awara. ");
INSERT INTO jao_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Jalirri-nanji lalungali-wangu nuwalarrkulu, “Barni-rdumantha lalungali-wangu nuwalarrkulu! Barni-yiwantha li-mayirli nuwalarrkulu!” Ngala yirru, jalirru-rdumanji, jalirru-yiwanji. Jirrinyambi-nanji, “Nganu, janu-mulamulanganji nya-mbangu nyarrku yijan alunga liyi-wuluwu winkanda, wambu janini juju yiku,” ngala yirru, jirru-wingkayi bajinju nungku-alanjilu yiku ki-yijanku nyalunga wajkirranthalu awara baji. ");
INSERT INTO jao_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Jirrinyamba-alarramanji, “Nganu li-yabi li-yuwawiji,” ngala jirru-ngajbirrinji nuwu-mangaj i. Li-mbangu winkanda, jirrala-nganji, jirrala-nykarrinji ngalirru jirru-ngajbirrinj i nuwarnu-yuwawu nuwarniku ki-Kada, kulu jalu-lhawamanji yiku, jalu-lhawamanji yiku ki-Kada li-mangaji kangka yirru jirru-ngajbirrinji nuwu-mangaji nuwarnu-yuwawu nuwarniku. ");
INSERT INTO jao_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kulu nganambajilulu barra wankala mirningiya, kilu-balirra wuka nyungku-mangaji, yiku wuka ki-Kada, “Li-mbangu winkanda, jalu-lhawamanji Kada, jalu-lhawarndiyi yiku, jalu-arrinji, ‘Wardimbangu nya-mangaji yijan Kada, nya-mangaji alunga liyi-ja wardimbangu,’ kulu jalu-wukanyinji nganinya kangka yirru li-Juwu jirrini li-wardi, kurdardi kirru-wingkayima yurlurr yiku, yirru barra,” nganinya kilu-yibarra ki-wankalangku. ");
INSERT INTO jao_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kulu yirru, kirralu-ma yirru li-Juwu li-mayani barranamba ki-Kada kili-nu malbu Yiburama wankala manjarra nganinya, alu nmanthawu li-wulu likungu li-rduwarduwarra, wankala kili-nu ki-Kada. Kulu yirru li-rduwarduwarra, li-yabi barra jirrini namba jirru-ngayangayarrinji nuwarnu-yuwawu ki-Mujij. Namba li-rduwarduwarra jirrini, li-ngayangaya nuwarnu-yuwawu, kulu nganinya barra marringaya yirrunga, kalngiya marringaya nmanthawu li-rduwarduwarra, namba jirrini li-ngayangaya nuwarnu-yuwawu. Ngala namba kurdardi, namba yirru li-rduwarduwarra jirru-ngajbirrinji nuwarnu-yuwawu, kulu jirrini barranamba li-mbangu li-nganji ki-Kada, minja kirralu-ma winarrku. ");
INSERT INTO jao_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ngala li-mbangu nalarrku winkanda, li-manji nuwarnu-yuwawu manjawu, namba li-mangaji kalu-wingkayima barrawumba kalima yurlurr nuwarnu-yuwawu ki-Mujij, kalima li-ngayangaya nalu-wurdu yiku ki-Kada, kulu li-mangaji li-wulu kalima likungu kangka kalima li-ngayangaya nalu-wurdu barranamba li-rduwarra wumba nalu-wurdu li-ngayangaya nuwarnu-yuwawu ki-Mujij. ");
INSERT INTO jao_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Li-mangaji barra li-winkanda, kurdardi kalima li-rduwarra, ngala minja kala-nykarrinjima Kada nalu-wurdu, li-mangaji kalala-nganjima nungkalarrku, “Li-mangaji li-marringaya jalu-ngayangayarrinji yiku ki-Kada.” Ngala yirru, jirrala-nganji yirru li-rduwarra, bajarnu yirruwa narnu-yuwa ki-Mujij balirrantha, jirrala-nganji yirru ngajbirrinjawu nuwu-mangaji, “Li-mangaji li-wardimbangu! Jalu-ngajbirrinji nuwarnu-yuwawu ki-Mujij.” ");
INSERT INTO jao_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","29","Kirrirni-nu nganinya, marrirru, kangka li-wulu barra, jalini likungu ki-Kada, jalini likungu kalngiya, kurdardi kangka li-mbangu lalungali-biyi li-Juwu, kurdardi kangka jalini li-rduwarra, kurdardi nganinya nmanthawu likungu ki-Kada, ngala li-wulu jalini likungu ki-Kada, kalngiya jalini likungu kangka jala-nykarrinji Kada nalu-wurdu, jalinyamba-yibarranji nalu-wurdu yilaa. Kulu li-mangaji, nungka nalarrku li-wulu kalinyamba-lhawarrmanjima alunga, nungka kurdardi, ngala Kada, ka-wukanyila alunga, “Jarnamba-riyarrabanji alunga liyi-mangaji, jalinyamba-yibarranji nalu-wurdu ngathangka, li-ja li-marringaya,” ka-wukanyila nganinya alunga. Yiwa Kada kumba-lhawarrmala alunga kumba-lhawarrmala alunga barra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Li-mbangu, li-mbangu li-wulu li-manji, nungkarnarrku jarnala-nykarrinji kulu jarnalu-yalbanganji, “Ngabinya! Kulu wayi barra li-mangaji li-Juwu? Kulu wayi barra narnu-yuwa narnalunga manjawu? Yabi barra na-mangaji?”, ndalu li-manji li-mangaji jarnilu-yalbanganji. ");
INSERT INTO jao_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kulu jalirni-nanji, “Yabi alunga liyi-mangaji wumba jalini li-Juwu, kalngiya yabi kangka alunga liyi-Juwu barra ka-wukanyinjaninya Kada, kalilu-ngunda nya-mangaji wuka nyikungu, alunga liyi-Juwu kilu-ngunda.” ");
INSERT INTO jao_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Kulu jarnalu-yalbanganji mili karingula, “Nalarrku li-Juwu, kalu-ngajbirri nuwarnu-yuwawu, kalinyamba-yangama alu ndayawu nya-mangaji wuka. Ngala wayi barra Kada? Nungka yiwa marda kumba-yangamala nuwarnu-yuwawu, ka-ngajbirrila nya-mangaji wuka wumba kalili-nu, nungka yiwa marda?” ");
INSERT INTO jao_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ngala kurdardi. Wardimbangu wuka jalu-wukanyinji, wardimbangu. Li-yakayaka bajalu li-yakayaka. Ngambala-lhaaya Kada, ngayamantharra yurlurr wuka ja-wukanyinji, kurdardi ka-ngajbirriyu nyuwu-mangaji ki-wukawu. Li-wulu jalu-warndimanji awara, nungkarnarrku ngambala marda, li-wulu wiji warndimanthawu, ngala barnika-warndimanjima Kada, kurdardi yiwa, ngayamantharra kalngi wuka ja-wukanyinji. Barranamba wankala nya-mangaji mirningiya Dabida, ka-wukanyi yiku ki-Kada, nganinya ka-arri, “Li-wulu, nalu-lhaaya yinda, nyinkungu wuka yurlurr nya-mangaji. Namba jalinyamba-yalbanganji li-wulu winkanda, ‘Nya-mangaji yijan Kada, nungka wardi jiwini? Nungka yabi?’, namba jalu-arrinji nganinya, kulu nalu-lhaaya yinda, yurlurr jimu kalngiya.” Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Li-mangaji li-manji, jalu-yudirrinji baki mili jalu-wukanyinji, “Nalarrku li-wulu, jalini mirdan yiku ki-Kada, jiwini marringaya, jalu-ngayamanji. Ngala nganu, ngalinganu janu-wardimanji awara kulu jalinyamba-wukanyinji, ‘Li-ja li-wardimbangu. Kada, kurdardi kiwima barranamba li-ja li-wardimbangu. Jiwini kalngiya marringaya, ngayamantharra marringaya,’ nganinya jalu-arrinji. Nganinya barra jalu-ngayamanji mili yurrulu Kada ngalinganu janala-nganji wardimantharra. Nganinya jalu-ngayamanj i Kada mili yurrulu kangka janini wardimantharra. Namba jalu-ngayamanji Kada mili yurrulu nganinya kangka jambalini wardimantharra, kulu nganinya barra yabi yiku ki-Kada. Kurdardi kanilu-ramanjima ki-Kada nuwu-mangajiwuthu wumba janini wardimantharra, kurdardi kanilu-ramanjima,” nganinya jalu-arrinji li-manji, jalu-warndimanji. ");
INSERT INTO jao_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ngala jalirni-nanji, “Wardimbangu wuka jirru-wukanyinji, wardimbangu. Li-yakayaka bajirru, li-yakayaka. Yurlurr ka-nmala Kada ngaliwa kirrilu-ramala yirru li-wulu wiji wayathantharra wumba jirru-wardimanji awara, ka-nmala yurlurr. Kurdardi ka-yabirriyu na-wurdu yirrunga liyi-wardiyu, kurdardi, ngala kirrilu-ramala. ");
INSERT INTO jao_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Li-mangaji li-manji, jalu-yudirrinji mili kulu jalu-wukanyinji, “Nganu, janu-warndimanji awara nungkarnarrku. Ngalinganu janu-warndimanji awara ngalalu janala-nykarrinji linji-wulungku nya-nganunga wuka, jalinyamba-wukanyinji, ‘Alu, jalu-warndimanji awara.’ Bajingu, ngalalu jala-nykarrinji wuka ki-Kada linji-mangaji ngalalu jalinyamba-wukanyinji, ‘Yiwa Kada, ja-wukanyinji yurlurr wuka, kalngi wuka, kurdardi barranamba li-mangaji wumba jaluwarndimanji,’ nganinya jalu-arrinji. Jalu-ngayamanji Kada mili yurrulu kangka janu-warndimanji. Ngalhiyu barra kanilu-ramala ki-Kada nuwu-mangajiwuthu baku ngallwa kalila-ramala li-wulu li-wardi? Janu-yabimanji awara yiku ki-Kada. Li-mangaji nalarrku jalu-ngayamanji Kada mili yurrulu kangka j anu-warndimanji. ");
INSERT INTO jao_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nganu yamulu. Nganu-wardimanthani awara, yabimanthawu awara yiku ki-Kada nganinya.” Ngala jarna-arrinji alunga liyi-mangaji liyi-manjiyu, “Wardimbangu wuka jirru-wukanyinj i, wardimbangu. Jirru-warndimanji awara nganinya mili yurrulu. Kulu nalarrku marda, jalu-warndimanji awara ngatha marda, jalu-arrinji, ‘Nya-mangaji Bula, jambalili-nanji, yamulu ngambalanga jambala-wardimanji awara, yamulu barra nganinya.’ Ngala ngarna, kurdardi kalirni-nanma nya-mangaji wuka, kurdardi. Jalu-warndimanji ngatha kurdandu ngala kurdardi kalu-wukanyinjima kalngi wuka. Ka-nmala yurlurr Kada ngaliwa kalilu-ramala nuwarnu-wardiyu nuwarnalunga baku.” Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kulu li-wulu li-Juwu, jarnalu-yalbanganji, “Kulu wayi barra ngambalanga liyi-Juwu? Baku namba kalilu-ruthuruthumala li-wulu ki-Kada, ruthuruthumanthawu li-yabi kulu li-wardi, wayi barra ngambala li-Juwu? Nungka kambalilu-yibarrala ngambala wiji li-yabi?” Nganinya jarnalu-yalbanganji ngala jalirni-nanji, Kurdardi barra. Ambuliyalu karna-yunduyunduma alunga, li-wulu wiji jalini li-wardi, ngambala li-Juwu marda nalarrku, ngambala wiji li-wulu jambalini li-wardi. Wunungu ngambalanga narnu-wardi na-mangaji, ngambalanga wiji. ");
INSERT INTO jao_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Barranamba wankala kala-ninya li-wulu ngaliwa ki-arrkulangku kilu-yibarra wuka, wuka nyikungu ki-Kada nya-mangaji, kilu-yibarra, “Kurdardi kalima yurlurr li-wulu, waraba. Waraba arrkula. ");
INSERT INTO jao_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kurdardi kalima mirdan nuwarnu-yabiyu, jalini manji. Kurdardi kalinyamba-nykalanykarrinjima, ‘Nganthiwa yijan, kalngiya yijan arrkula, nganthiwa?’ Kurdardi kalinyamba-nykalanykarrinjima yiku. ");
INSERT INTO jao_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Alu wiji kalu-wirnirri winkandu. Kalinyamba-wardima, waraba kalu-yabimanjima awara, waraba barra, kurdardi arrkula. ");
INSERT INTO jao_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Jalu-lhawalhawamanji awara, jalu-lhawarndiyi awara, jalu-warndimanji awara, li-wardiwiji nalu-nganthal. Jalu-wukanyinji wuka ladalada wardimanthawu alunga liyi-wuluwu nuwalarrkulu, kulu li-mangaji nalarrku, jalu-wardirrinji nalu-wurdu alunga liyi-wardiyu wumba jalu-wukanyinji wardi wuka barranamba jalu-wardirrinji nalu-wurdu ki-lhuwanku ki-ngulwawu namba kalila-thanjima. ");
INSERT INTO jao_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Kulu li-wardi, jalu-wardirrinji nalu-wurdu alunga nuwalarrkulu, jalu-mulamulanganji alunga, kulu bajingu barra jalu-wukalukanyinji alunga wardi wardi wuka. ");
INSERT INTO jao_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Jalu-yinjathirrinji yarlajka, li-ramanthamara jalini, jalalu-ramanji li-wulu yundulu bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ngalalu jalini namba alanjila ngaliwa dabudaburr awara ja-wingkayi. Jalu-wardimanji awara wumba jalini baji, rarrinjarra awara jiwini alunga nuwalarrkulu. ");
INSERT INTO jao_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Jalini li-mirdan barra yinjathirrinjawu marda wardimanthawu awara ngala li-manji jalini wunthanbayawu, li-manji nmanthawu nungkarnu-yabinja. ");
INSERT INTO jao_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Li-mangaji mili, kurdardi kalu-wardankayima yiku ki-Yijanku ki-Kada. Yiwa Yijan, kalngi, arrkula, ngala jalu-ngajbirrinji yiku.” Nganinya kilu-yibarra wuka yiku ki-Kada ki-wankalangku. Jinangu wuka ki-Kada, narnu-yuwa narniku barra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Li-mangaji li-manji, jalu-yudirrinji kulu jalu-wukanyinji ngatha, “Jinangu wuka nalinanthawu awara alunga liyi-wuluwu winkanda. Kada ja-wukanyinji alunga, alu barra jalini li-wardi, kurdardi kalima yurlurr. Ja-wukanyinji jinangu wuka alunga nuwalarrkulu Kada, kurdardi ngambalanga liyi-Juwu,” jalu-arrinji nganinya. Ngala kurdardi. Jalu-warndimanji. Ngambala, jambalini mirdan nyuwu-ja ki-wukawu, jinangu ja-wukanyinji Kada alunga liyi-wuluwu liyi-Juwu baki alunga liyi-wuluwu nuwalarrkulu, ngambalanga wiji. Jinangu wuka, jambalili-nanji li-wulu wiji, jambalini li-wardi, kurdardi kambalima yurlurr. Kulu baku, kurdardi kambalambi-narru yiku ki-Kada, ngambala li-marringaya, kurdardi. Ngambala, li-wulu wiji, kambala-nmala jakudi yiku ki-Kada baku ngaliwa kambalila-ngala, kambalila-ngala li-wulu wiji ruthuruthumanthawu li-mbangu wumba kalilu-ramala. ");
INSERT INTO jao_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ki-Kada, karnilu-ngunda narnu-yuwa narniku ki-Mujij milirdimanthawu ngambalanga liyi-wuluwu wiji, jambalini li-wardi. Ka-arri mirdan ngambalanga liyi-wuluwu wiji, kurdardi kambala-wingkayima yurlurr nungku-mangaji nungkarnu-yuwangka wumba karnilu-ngunda yiku ki-Mujij. Karnilu-ngunda na-mangaji milirdimanthawu ngambalanga wiji, jambalini li-wardi. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ngala ngulakari, nungku-ja, jumbi-nanji Kada ngambalanga, yiwa yibarranthawu li-wulu yurlurr yiku, kurdardi nungkarnu-yuwangka ki-Mujij ngala nungkarnu-yuwangka nungkarnarrku. Ngala minja li-mangaji li-wankala wumba nakalu-wukanyinjaninya yiku ki-Kada, kalu-yibarra buyi barra na-ja narnu-yuwa narnarrku, wankala minja buyi kala-nykarri. ");
INSERT INTO jao_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Na-ja narnu-yuwa narniku ki-Kada nganinyanga, jambalilu-yibarranji ngambala li-wulu nmanthawu yurlurr yiku ngalingambala jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj Kurayij. Na-ja narniku arrkula barra ngambalanga liyi-wuluwu liyi-Juwu kulu alunga nuwalarrkulu, ngambalanga wiji, ");
INSERT INTO jao_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kangka ngambala li-wulu wiji jambala-wardimanji awara, kurdardi kambalima marringaya barni-wardimanthawu, waraba kambalima marringaya yiku ki-Kada, yiwa ngayamanthawu ngambalanga, waraba, ngala jambala-wardimanji awara, ngambala li-wulu mura. ");
INSERT INTO jao_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ngala jiwini yabi Kada. Yiwa jambalilu-yibarranji ngambala nmanthawu barranamba yurlurr yiku, kangka nyiki-ardu Jijaj Kurayij, kumba-mirra ngambalanga, ka-lhungkurri ngambalanga, yiwa yabimanthawu awara ngambalanga nuwarnu-wardiyu wumba barnikambalamba-yabimanma, ngambala li-wulu. ");
INSERT INTO jao_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kili-ja karanka ki-Kada, kili-ja nyiki-ardu nyamba-mirranthalu. Kumba-mirra barra, ka-wujba yilirri mankanda yilaa Bajingu ki-Kada kambalilu-yayama narnu-wardi ngambalanga liyi-wardiyu. Kulu namba ngambala, jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj, kulu jarnilu-yayamanji narnu-wardi narnu-ngambalanga kangka kumba-mirra Jijaj, ka-wujba yilirri nyikungu nuwarnu-wardiyu yayamanthawu. Ngaliwa kili-ja nyiki-ardu nganinya ki-Kada, nyamba-mirranthalu nuwarnu-wardiyu, kulu jambalini mirdan yiku, yiwa yurlurr yurrngumantha. Ka-arri yurlurr alunga ridinja ngaliwa aliyaliya kalilu-ramanma wirangu narnu-wardi narnalunga, kangka ngulakari kumba-mirra nyiki-ardu nuwarnu-wardiyu nuwarnalunga, alunga liyi-wankalawu marda kumba-mirra. ");
INSERT INTO jao_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ngaliwa ki-Kada kili-ja nyiki-ardu nyamba-mirranthalu nuwarnu-wardiyu, jumba-mirnimanji ngambalanga, yiwa yurlurr nganinyanga marda, kulu jambalilu-yibarranji ngambala nmanthawu barranamba yurlurr yiku, ngambala wumba kambalamba-yibarra ngambala-wurdu yilaa ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nganinya barra ki-Kada, jambalilu-yibarranji nmanthawu barranamba yurlurr yiku, jambalilu-yibarranj i yiwa. Kulu ngambala, kurdardi kambalamba-arramanjima, kurdardi kambalambi-nanjima, “Ngambala yurlurr, jambala-wingkayi yurlurr nuwarnu-yuwawu yurrngumantha, jambalamba-yibarranji ngambala nmanthawu yurlurr yiku ki-Kada, ngambala ngambalalumba,” kurdardi kambala-arrinjima nganinya. Kangka Kada, yiwa barra jambalilu-yibarranji nmanthawu barranamba yurlurr yiku ngalingambala jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kulu nganinya barra nganu, jalinganu-milirdimanji li-wulu, ngalalu jalinyamba-yibarranji nalu-wurdu yilaa ki-Jijaj ngaliwa jalilu-yibarranji alu nmanthawu barranamba yurlurr, ki-Kada jalilu-yibarranji nganinya bawuji, kurdardi nuwarnu-yuwawu ki-Mujij jalilu-yibarranji. Kurdardi kumba-yalbanganjima Kada, “Yurlurr nuwarnu-yuwawu li-ja?”, kurdardi. ");
INSERT INTO jao_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kulu Kada, jiwini Yijan ngambalanga liyi-Juwu, ngala kurdardi ngayamantharra ngambalanga. Jiwini Yijan alunga nuwalarrkulu marda, alunga liyi-wuluwu wiji. ");
INSERT INTO jao_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Jiwini arrkula, Kada, ngayamantharra yiwa, kulu narnu-yuwa narniku narnu-arrkula. Kambalilu-yibarrala ngambala li-Juwu li-rduwarra nmanthawu barranamba yurlurr yiku namba jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj, kulu nganambajilulu kalilu-yibarrala li-wulu nalarrku winkanda nmanthawu barranamba yurlurr yiku namba jalinyamba-yibarranji nalu-wurdu yilaa ki-Jijaj marda, nganinya barra alunga liyi-wuluwu wiji. ");
INSERT INTO jao_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kulu ngambala, jambalamba-yibarranji ngainbala-wurdu yilaa ki-Jijaj marda jambaiini nyala nykarrinjarra nya-mangaji wuka wumba ki-Kada kili-nu malbu Mujij, kurdardi kambala-walimanma nya-mangaji wuka. Ngala minja jambala-wukanyinji nyuwu-mangaji, “Marringaya jinangu wuka, yurlurr,” nganinya jambala-wukanyinji. Nganinya jirrirni-nanji barra. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kulu wayi barra nya-mangaji, nya-mangaji mirningiya, wankala mirningiya nyangambalanga-nganji Yiburama? Nya-mangaji yabiwiji, kambala-wundarrbanji nyangambalanga-biyi liyi-Juwu kangka ngambala li-Juwu wiji, jambalini nakaringu yilaa ki-Yiburama ki-wankalangka. Wayi barra nya-mangaji? Kirrirni-nala yiku barra. ");
INSERT INTO jao_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nya-mangaji Yiburama, kurdardi ki-Kada kilu-yibarranma nmanthawu barranamba yurlurr kangka nya-mangaji malbu yabi yurrngumantha, kurdardi kiwa-nima ngayamantharra yabi, Yiburama. Kurdardi kumba-alarramanma yiku ki-Kada, “Kanha-yibarra ngarna yurlurr yinku kangka jarnini marringaya,” kurdardi. Ngala Kada, kumba-nykalanykarri nuwarnu-yuwawu nuwarnarrku. ");
INSERT INTO jao_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kulu ki-arrkulangku, kilu-yibarra wuka yiku ki-Yiburama, kilu-balirra yiku ki-wukangka ki-Kada ngalhi wuka? Kilu-balirra nganinya, “Nya-mangaji Yiburama, kumba-yibarra na-wurdu yilaa ki-Kada, kulu ka-arri Kada, ‘Jarna-yibarranji Yiburama nmanthawu barranamba yurlurr ngatha kangka kumba-yibarra na-wurdu ngathangka,’ ka-arri nganinya Kada.” Nganinya kilu-yibarra ki-wukangka nyikungu ki-arrkulangku, bawuji. ");
INSERT INTO jao_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kulu li-mbangu, li-mbangu jalini jabungka, kalu-rdumanji ma-kijululu. Kurdardi kalilu-ngundayima ma-mani winarrku ki-wirdinju nyungkalunga ngala jalu-yabimanji awara yiku, alu rdumanthawu ma-kijululu ma-mangaji, jalilu-ngundayi ma-kijululu kangka jalini jabungka yiku. ");
INSERT INTO jao_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ngala Kada, kurdardi kiwima barranamba nya-mangaji mirningiya wirdi. Kulu ngambala, kurdardi kambalima jabungka yabimanthawu awara yiku ki-Kada, ngambala rdumanthawu awara nakaringu yilaa, kurdardi. Narnu-yuwa narniku ki-Kada narnarrku. Kada, kambalilu-yibarranji ngambala nmanthawu barranamba yurlurr yiku, kurdardi kangka jambala-yabimanji awara yiku, kurdardi kangka jambalini jabungka yiku, ngala jambalilu-yibarranji nmanthawu barranamba yurlurr yiku kangka jambalamba-yibarranji ngambala-wurdu yilaa, ngambala li-wardi, jambalamba-yibarranji ngambala-wurdu yilaa nganinya. Kulu nganambaji marda ki-Kada kilu-yibarra Yiburama nmanthawu barranamba yurlurr yiku. ");
INSERT INTO jao_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Marda nyarrku, nya-mangaji nyarrku wankala ngulakari, nyangambalanga-nganji nya-mangaji yabiwiji Dabida, kila-nykarri narnu-yuwa, karnila-nykarri narnu-yuwa narniku ki-Kada wumba kalilu-yibarranthaninya li-wulu, alu nmanthawu barranamba yurlurr yiku, alunga liyi-wuluwu wumba kurdardi kalu-wingkayima yurlurr yurrngumantha. Karnila-nykarri na-mangaji ki-Dabida, kulu kalili-nu li-mbangu li-wulu, jalini yabi nalu-wurdu, li-mangaji wumba ki-Kada jalilu-yibarranji nmanthawu barranamba yurlurr nganinya. ");
INSERT INTO jao_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Kalili-nu nganinya, “Yabi nalu-wurdu li-mbangu namba Kada ja-wukanyinji alunga, ‘Kurdardi karna-linginmarru nya-mbangu, kurdardi karnarna-linginmarru narnu-wardi wumba kirru-wardima awara ngala kirna-wayathanjima nykarrinjawu, kirna-wayathanjima nykarrinjawu nuwarnu-wardiyu nuwarnuwirrunga bawuji,’ nganinya ja-wukanyinji. Yabi nalu-wurdu li-wulu namba narnalunga narnu-wardi jarnilu-yayamanji ki-Kada wurdula aluwa. ");
INSERT INTO jao_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","“Yabi barra nalu-wurdu li-wulu namba ki-Kada jalilu-yibarranji nmanthawu barranamba yurlurr yiku, li-mangaji wumba Kada jumba-wukanyinji alunga, ‘Kurdardi karnamba-nykalanykarriyu nuwarnu-wardiyu nuwarnalunga.’” Nganinya barra kilu-balirra wuka ki-Dabida. ");
INSERT INTO jao_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","10","Kulu ka-wukanyi nganinya nya-mangaji Dabida alunga liyi-wuluwu ngala minja wayi barra nalu-yanyka li-mangaji? Li-rduwarra li-Juwu kalili-nu, mili li-mbangu nalarrku marda li-wulu wiji kalili-nu? Li-ngani barra? Jirrirna-linginmanji barra, jinangu wuka liyi-wuluwu wiji, alunga liyi-rduwarduwarrawu marda alunga nuwalarrkulu, alunga liyi-wuluwu wiji. Wayi barra malbu Yiburama? Ngaliwa nya-mangaji malbu Yiburama kumba-yibarra na-wurdu yilaa ki-Kada ngaliwa ki-Kada kilu-yibarra yiwa nmanthawu barranamba yurlurr yiku. Nungka rduwarra kilu-yibarra nganinya? Nungka kurdardi rduwarra? Jirrirna-linginmanji barra, kilu-yibarra Yiburama nmanthawu barranamba yurlurr yiku ki-Kada ngaliwa aliyaliya rduwarra nyamangaji, aliyaliya rduwarra. ");
INSERT INTO jao_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Nganinya barra, namba aliyaliya rduwarra nya-mangaji, baji barra kumba-yibarra na-wurdu yilaa ki-Kada, kulu ki-Kada kilu-yibarra malbu, yiwa nmanthawu barranamba yurlurr yiku. Kulu ngulakari barra kalu-ma barra Yiburama, kalu-ma yiwa nmanthawu rduwarra, kalu-ma nganinya, yiwa yiku nganthawu karanka ndiwa nyikungu, Yiburama. Ambuliyalu Yiburama, kurdardi kiwa-nmanma rduwarra, kumba-yibarra na-wurdu yilaa ki-Kada, kulu ngulakari nalarrku kalu-wanda nya-mangaji. Nganambajilulu alu marda, kurdardi li-rduwarra, kalinyamba-yibarra nalu-wurdu yilaa ki-Kada. Kulu nganinya barra Yiburama ambuliyalu alunga ka-arri barranamba nyalunga-biyi, kulu li-mangaji, kurdardi li-rduwarra, ngulakari jalinyamba-yibarranji nalu-wurdu ki-Kada marda, kulu ki-Kada jalilu-yibarranji nmanthawu barranamba yurlurr yiku ngalalu nyamba-yibarrantharra nalu-wurdu yilaa barranamba Yiburama. ");
INSERT INTO jao_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kulu nganambajilulu barra nya-mangaji Yiburama, jiwini barranamba nyangambalangabiyi, ngambalanga liyi-rduwarduwarrawu liyi-Juwu wumba jambalamba-yibarranji ngambala-wurdu yilaa ki-Kada, kulu jambalini barranamba likili-ardu ki-Yiburama wumba kumba-yibarra na-wurdu yilaa ki-Kada, aliyaliya rduwarra ndiwa. ");
INSERT INTO jao_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kulu Kada ka-wukanyi yiku ki-Yiburama, kumbi-nu yiwa ngundayawu awara yiku, yiwa ngundayawu mayangka awara wiji yiku ki-Yiburama, alunga liyi-mangaji liyi-ngulangulakaringu wumba nakaringu yilaa ki-Yiburama, awara wiji nyalunga awara baku, nganinya kili-nu ki-Kada. Marda ka-wukanyi jinangu wuka ngaliwa aliyaliya na-mangaji, aliyaliya na-mangaji narnu-yuwa narnalunga balirrantha. Baku karnilu-ngunda narnu-yuwa yiku ki-Mujij ngala minja kili-nu Yiburama nyuwu-mangaji ki-awarawu ambuliyalu, Kulu ki-Kada kili-nu Yiburama ki-awarawu kangka kumba-yibarra na-wurdu yilaa Yiburama, kurdardi kangka yiwa wingkayawu yurlurr nuwarnu-yuwawu ki-Mujij, kurdardi. Kumba-yibarra na-wurdu yilaa ki-Kada, kulu ki-Kada kilu-yibarra nmanthawu barranamba yurlurr, kulu ngulakari kili-nu Yiburama ki-awarawu ngundayawu. ");
INSERT INTO jao_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kulu nalarrku li-wulu li-manji, jalu-yudirrinji, katha li-mbangu li-jawina nuwarnu-yuwawu, kalu-rdumala nya-mangaji awara wumba kilu-ngundarra ki-Kada, kilu-ngundarra awara ngayamantharra alunga liyi-mangaji wumba jalini li-jawina nuwarnu-yuwawu ki-Mujij. Namba ki-Kada, kilu-ngundayima awara ngayamantharra alunga liyi-mangaji, kulu li-wulu nalarrku, kalinyamba-yibarranjima nalu-wurdu yilaa ki-Jijaj winarrku. Ngala kurdardi. Ki-Kada kilu-ngundarra awara alunga, kilu-yabimala awara alunga liyi-mangaji wumba jalini yilaa ki-Jijaj nalu-wurdu. ");
INSERT INTO jao_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Narnu-yuwa ki-Mujij, karnilu-ngunda ki-Kada, kulu kurdardi kambala-wingkayima yurlurr nuwu-mangaji yurrngumantha, waraba. Bajarnu narnu-yuwa ngambalanga, ngala jambala-ngajbirrinji nuwu-mangaji, nungkarnarrku jambala-ngajbirrinji nuwu-mangaji nagambala wiji. Namba jambala-ngajbirrinji nuwarnu-yuwawu nganinya kulu bajuwarnu Kada ja-yinjathirrinji ngambalanga liyi-ngajbirrinjamara, kulu baku kambalilu-ramala ki-Kada, kambalilu-ramala kangka kurdardi kambala-wingkayima yurlurr nuwarnu-yabiyu nuwarnu-yuwawu. Ngala minja bajalu nalarrku li-mbangu winkanda, kurdardi aluwa narnu-yuwa ki-Mujij, kurdardi ki-wukawu alunga yunduyundumanthawu alunga, “Jinanguwuthu yabi ngala jinanguwuthu niwarrku wardi.” Namba kurdardi ki-wukawu nyuwu-mangaji alunga kulu kurdardi kalili-narru ki-Kada, kurdardi kalili-narru baku, “Jirru-ngajbirrinji nuwarnu-yuwawu,” kurdardi kalili-narru nganinya. ");
INSERT INTO jao_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ngala nya-mangaji wuka wumba ki-Kada kili-nu Yiburama, Kada ngundayawu awara alunga liyi-wuluwu, nya-mangaji wuka kili-nu ki-Kada ngambalanga liyi-wuluwu wiji wumba jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj, kurdardi kangka ngambala wingkayawu yurlurr nuwarnu-yuwawu ki-Mujij ngala minja kangka ngambala nyamba-yibarranthawu ngambala-wurdu yilaa. Kili-nu malbu Yiburama ngambalanga marda, yiwa Kada ngundayawu, ngundayawu winarrku ngambalanga. Jiwini yabi Yijan Kada, nganinya kilu-ngundarra winarrku, ndiwa yabi. Kulu Kada, namba ka-wukanyi jinangu wuka, kalngiya nganinya kilu-ngundarra, kalngiya nganinya kilu-ngundarra awara ngambalanga. Ki-Kada kilu-ngundarra awara ngambalanga wumba jambalini li-jawina nuwarnu-yuwawu ki-Mujij kulu jambalamba-yibarranji ngambala-wurdu yilaa ki-Kada. Marda kilu-ngundarra awara alunga liyi-mbangu wumba kurdardi aluwa narnu-yuwa ki-Mujij ngala minja jalinyamba-yibarranji nalu-wurdu yilaa. Kalilu-ngundarra awara ngambalanga wiji kangka ngambala wiji jambala-wandayi Yiburama, jambalamba-yibarranj i ngambala-wurdu yilaa ki-Kada barranamba Yiburama ka-arri, jambala-wandayi barranamba li-ardubirri jalu-wandayi nyalunga-biyi, nganinya barra Yiburama barranamba nyangambalanga-biyi, kangka ngambala ngulakari jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj barrawumba yiwa ka-arri. ");
INSERT INTO jao_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kada, kili-nu Yiburama nganinya kulu kilubalirra jinangu wuka ki-arrkulangku nganinya, “Jirna-yibarranji yinda nmanthawu wurrama. Nakaringu yindaa kala-nmala li-jakarda, li-ngulangulakaringu nalu-miji. Kala-nmala ki-awarala ki-mayangka ki-jakardala, nganinya kala-nmala li-mangaji linkili-nganji nakaringu yindaa,” ka-arri nganinya. Kulu Kada wumba naja-wukanyinji kalngi wuka, yiwa kili-nu nya-mangaji wuka, kili-nu nya-mangaji malbu wumba kumba-yibarra na-wurdu yilaa. Yiwa barra Kada, jalilu-ngabiyanji li-mbangu li-ngabangaku, jalilu-lhungkumanji, jarnilu-ngundayi narnu-lhungku alunga wumba nambalu barni-lhungku, jalilu-ngundayi li-ardubirri alunga liyi-wuluwu wumba nambalu barni-bardarda. Kulu ja-wukanyinji ki-ngabiyawu barra namba aliyaliya kiwima nya-mbangu, jilu-lhaanji nya-mbangu namba aliyaliya kiwima. ");
INSERT INTO jao_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kulu nya-mangaji Yiburama, ka-malburri, ka-wardirri na-manka, kumba-lhaa ka-malburri kurdandu kulu kurdardi nyiki-arduwu barra, kalngiya malbu kumba-lhaa, kurdardi nyamba-kajakajamanthawu barra yiwa, Ngala minja kili-nu ki-Kada, “Li-jakarda nakaringu yindaa kala-nmala li-ngulangulakaringu.” Kulu Yiburama, kila-nykarri, kala-ka nya-mangaji wuka, yiwa nyamba-kajakajamanthawu li-jakarda, nakaringu yilaa li-jakarda likili-nganji, alu nmanthawu ki-awarala ki-mayangka ki-jakardala, kila-ka nya-mangaji wuka kulu kumba-yibarra na-wurdu yilaa ki-Kada nuwu-mangaji barra. ");
INSERT INTO jao_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Kumba-nykalanykarri barra yiwa malbu, ka-wingkalwingkayaninya lukuluku bajiwuthu ki-lhabayila nyungku-mbangu ngulakari kulu nyungku-ja ambirriju, kilu-mirrinyma ki-lhabayilu, kalngiya malbu. Kumba-nykalanykarri mili anku riku-wanguwu wu-Jira, a-mangaji a-bardibardi, a-wardikirri barra, kurdardi nyamba-kulhakulhamanthawu bardardawu kangka rra-bardibardi barra Nganinya kumba-nykalanykarri nya-mangaji malbu ngala minja kila-ka wuka wumba kili-nu ki-Kada, li-jakarda li-ngulangulakaringu nakaringu yilaa kala-nmala, kila-ka wuka kulu kumba-yibarra na-wurdu yilaa ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kurdardi ka-ngajbirrinma nyuwu-mangaji ki-wukawu wumba kili-nu ki-Kada, kurdardi kumba-yangamanma na-wurdu, ngala minja yurrngumantha kumba-yibarra na-wurdu yilaa ki-Kada, mili yurrulu kumba-yibarra na-wurdu wakulamba yilaa nganinya. Kumba-lhawarrma yiku ki-Kada ki-wukawu nyuwu-mangaji, kilu-barlirra. Bajingu lumbu ka-arri wunungu, yiwa nyamba-yibarranthawu na-wurdu yilaa ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Kilu-lhaa Kada, kalngiya jiwini wunungu, ja-wukanyinji ngayamantharra kalngi wuka. Kilu-lhaa, namba Kada jalili-nanji li-wulu ngabiyawu kulu baku kilu-ngabiyala awara nganambajilulu wumba kalili-nu, jiwini kalngiya wunungu, kalngiya yurlurr. ");
INSERT INTO jao_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nganinya barra kumba-yibarra na-wurdu yilaa ki-Kada malbu Yiburama, kulu bajuwarnu barra ka-arri Kada, “Kirna-yibarrala jinangu nmanthawu barranamba yurlurr ngatha kangka kumba-yibarra na-wurdu ngathangka.” ");
INSERT INTO jao_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","25","Ngala kurdardi ngayamantharra yiku ki-Yiburama ka-wukanyi nganinya Kada, kurdardi. Ngala minja nya-mbangu wankala mirningiya ki-Kada, kilu-balirra nya-mangaji wuka ngambalanga kangka nya-mangaji wuka ka-wukanyi ngambalanga marda, Kada. Namba jambalamba-yibarranji ngambala-wurdu yilaa ki-Kada, nya-mangaji Kada wumba kilu-lhungkuma ngabangaku, kilu-lhungkuma Jijaj Kurayij wumba kumba-mirra ngambalanga kangka jambalini li-wardi, kilu-lhungkuma mili ki-Kada, yiwa yibarranthawu ngambala, ngambala nmanthawu yurlurr yiku namba jambalamba-yibarranji ngambala-wurdu yilaa ki-Kada. Kulu kili-nu wuka marda ngambalanga, “Kalirna-yibarrala li-ja, alu nmanthawu barranamba yurlurr ngatha,” nganinya barra kili-nu. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","2","Nya-mbangu, nya-mangaji Jijaj Kurayij, karnilu-yabima na-budijbudij, kilu-yabima awara ngambalanga nyungku-mangaji, kilu-yabima Yijan Kada na-wurdu wumba ka-wardirri na-wurdu nuwarnu-wardiyu nuwarnu-ngambalanga wumba kambala-wardima awara barra. Ngalingambala kambala-arri li-wardi wardimantharra awara ngalarnu karnungka-wardima awara yiku ki-Kada nungkarnu-wardinju nungkarnu-ngambalanga, ka-wardirri na-wurdu Kada, ka-yinjathirri wirangu narnu-wardi narnu-ngambalanga. Ngala yiwa, Wirdiwalangu Jijaj Kurayij, kumba-mirra, kumba-mirra nuwarnu-wardiyu nuwarnu-ngambalanga liyi-wuluwu, kilu-yabima na-wurdu Kada ngambalanga, kilu-wunthama na-wurdu nuwarnu-wardiyu nuwarnu-ngambalanga bawuji. Kulu ngambala, kambalamba-yibarra ngambala-wurdu yilaa nyungku-ja ki-Jijaj, kulu kambalilu-yibarra ki-Kada, kambalilu-yibarra ngambala nmanthawu barranamba yurlurr yilaa. Bajingu jambalini nungkarnu-yabinja barra yilaa ki-Kada, yamulu jambalini likili-nganji li-wunumbanyngu, likili-nganji li-wunumbanyngu ngambala. Kulu ngambala, jambala-yabirrinji ngambala-wurdu, jambalamba-riyarrabanji yiku ki-Jijaj ngalingambala jambalamba-nykalanykarrinji nganinya, kambala-nama yilaa ki-Kada, kambala-nama nungkarnu-yabinja nungkarniku, jambalamba-nykalanykarrinj i nganinya kulu jambalamba-riyarrabanji yiku. ");
INSERT INTO jao_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Kulu jambalamba-riyarrabanji mili, jambalamba-riyarrabanji ngaliwa dabudaburr awara ja-wingkayi ngambalanga. Jambalamba-riyarrabanji baji kangka ki-awarala ki-dabudaburra barra jambalilu-milirdimanji ki-Kada, nungkarnu-dabudaburra jambalilu-milirdimanj i ngambala lumburrinjawu ngambala-wurdu yilaa, ngambala wingkayarra i...i yurrujurru yilaa barni-wirnirrinjawu. ");
INSERT INTO jao_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Kulu namba jambala-wingkayi...i yurrujurru yilaa nganinya kulu kambala-yirdardila barra, kambala-yirdardila nambalu ka-ngayamala barra ngambalanga Kada, ngambala li-anthamu likungu, ka-ngayamala ngambalanga. Kulu namba jambala-yirdardinji nganinya, kulu jambala-yabirrinji ngambala-wurdu yukumantharra baku, yukumantharra yiku ki-Kada, yiwa yabimanthawu awara ngambalanga. ");
INSERT INTO jao_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kulu namba jambala-yabirrinji ngambala-wurdu yukumantharra yiku nganinya, kurdardi winarrku jambala-yukumanji yiku ngala baku kambala-rdumala awara, nya-mangaji marringaya awara wumba kambalili-nu ki-Kada, nungku-burruburrula nungkiku kambalili-nu. Kulu jambalini yabi ngambala-wurdu yukumantharra nganinya, kangka nya-mangaji Yijan Kada, jambalilu-manmarralanganji wakulamba. Kili-ja nya-mbangu, kili-ja Na-ngawulu karanka, yiwa nmanthawu wurdulula ngambalaa. Kulu nya-mangaji Na-ngawulu ki-Kada, ja-wukanyinji ngambalanga ngambala-wurdu nanthawu yiku Wunyathawu wumba jambalilu-manmarralanganji kurdardu Wunyathalu. ");
INSERT INTO jao_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kulu Jababa Jijaj Kurayij, ngalingambala kambala-ninya li-barlkibarlki ngambala-wurdulu, kambalamba-ayayanu nyamba-yibarranthawu ngambala nmanthawu yurlurr, ngaliwa kumba-wukanyi nyiki-biyi Kada, “Nganinyanga barra, nganinyanga nyangathi-ardu kumba-mirrala, kumba-mirrala alunga liyi-wuluwu liyi-wardiyu,” ka-arri nganinya Kada ngaliwa kumba-mirra ngambalanga Jijaj, kumba-mirra ngambalanga, ngambala li-wardimbangu. ");
INSERT INTO jao_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kulu ngambala li-wulu, kurdardi kambalamba-yibarranjima nyamba-mirranthawu, kurdardi kambalamba-yibarranjima nyamba-mirranthawu alunga nuwalarrkulu, kurdardi alunga liyiyabiyu. Ngala minja nungka nya-mbangu arrkula kumba-mirranjima yiku ki-marringayawu, nungka nungka. ");
INSERT INTO jao_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ngala Yijan Kada, jambalini li-mirdan yiku jambalilu-manmarralanganji wakulamba kangka kili-ja nyiki-ardu Jijaj Kurayij karanka, kumba-mirra ngambalanga Jijaj, ngalingambala li-wardi kambala-arri nyala wardimantharra kumba-mirra ngambalanga. ");
INSERT INTO jao_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Jambalini li-mirdan yiku ki-Jijaj, wabarrangu kumba-mirra ngambalanga yibarranthalu ngambala nmanthawu barranamba yurlurr yiku ki-Kada. Kulu bajuwarnu mili jambalini li-mirdan yiku ki-Jijaj, baku kambalilu-yibarrala, kalngiya kambalilu-yibarrala ki-marakala aluwa linji-yabinja baku ngaliwa Kada kalilu-ramala li-wulu li-wardi. ");
INSERT INTO jao_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Wabarrangu ngalingambala kambala-arri li-nganji yiku ki-Kada, juju yiku, ngaliwa Jijaj kumba-mirra ngabangaku, kumba-mirra ngambalanga waninjangumanthalu yilalu ki-Kada, ngambala nmanthawu li-wunumbanyngu. Namba ambuliyalu kambalilu-waninjanguma ngambala nmanthawu li-wunumbanyngu, kulu nganinyanga Jijaj lhungku, lhungku na-yurrngu, kalngiya kilu-wayathala yabimanthawu awara ngambalanga, kambalilu-marakamala, ngambala nmanthawu nungkarnu-yabinja yilaa ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Bawuji barra, jambalamba-riyarrabanji yiku ki-Kada, jambalamba-lhawarrmanji yiku, “Wunyatha! Yinda walkurrawala, marringaya kangka kinyi-janhu nyinki-ardu Wirdiwalangu Jijaj Kurayij, kilu-yabima awara nganunga, kumba-mirra nganunga, kinyu-wunthama nuwarnu-wardiyu nuwarnu-nganunga, kanilu-yibarra nganu nmanthawu li-wunumbanyngu, linkili-ardu. Kirna-barlirra Wunyatha,” nganinya jambala-arrinji. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Wankala, wankala ka-arri arrkula mirningiya, na-wini Adam, kulu kilu-wardima awara, wardi ka-arri. Ka-ngajbirri yiku ki-Kada, ka-ngajbirri nyuwu-mangaji ki-wukawu wumba kili-jirrinyma ki-Kada. Bajingu narnu-wardi yilaa ki-Adam kulu karnila-ka narnu-wardi bajinju ki-awaralu, nganinya karnilaka narnu-wardi ngambalalu linji-wulungku. Bajingu barra ngambala li-wulu wiji jambalini nungkarnu-wardinja, jambala-wardimanji awara. Bajungkarnu barra kambalamba-mirrala barra, kambalamba-mirrala kangka jambala-wardimanji awara. ");
INSERT INTO jao_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Nganinya ngambala jambala-wardimanji awara. Narnu-wardi karnu-arri ngalarnu aliyaliya na-mangaji narnu-yuwa, aliyaliya narnu-yuwa ki-Mujij. Baji barra, ngalalu li-wulu kalu-arri li-manji nuwarnu-yuwawu, kurdardi narnu-yuwa balirrantha alunga, kulu kurdardi ka-wukanyinma alunga Kada, “Marrirru! Yirru li-wardi, li-wardi nuwarnu-yuwawu,” kurdardi ka-wukanyinma nganinya. ");
INSERT INTO jao_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ngala kalinyamba-mirra li-mangaji marda, kalinyamba-mirra wiji li-mangaji wumba aliyaliya narnu-yuwa ki-Mujij. Narnarrku narnu-wardi narnalunga baki narnarrku narnu-wardi narniku ki-Adam. Adam kilu-wardima awara, yiwa arrkula ka-ngajbirri nyuwu-mangaji ki-wukawu ki-Kada wumba ka-wukanyi yiku, nganinya kilu-wardima awara, kulu kumba-mirra. Li-ja li-wulu ngulaya yiku, kalu-wardima awara, kurdardi nuwarnu-yuwawu. Alu winarrku kalu-wardima awara, alulumba kalu-wardima awara nganinya kulu kalinyamba-mirra. Adam, arrkula mirningiya, yiwa ambirriju nuwalarrkulu liyi-wuluwu, ka-wingka ambirriju alunga kulu linji-mangaji kalu-wanda, ambirriju yiwa ka-wingkayaninya wardimantharra kulu ngulakari alu kalu-wingkayaninya wardimantharra, li-wardi. Nganinya ka-arri ambirriju alunga liyi-wuluwu liyi-jakardawu. Baki Jijaj, arrkula mirningiya, nyikungu ki-Kada, yiwa marda ambirriju nuwalarrkulu liyi-wuluwu, ka-wingka ambirriju alunga kulu linji-mangaji kalu-wanda, ambirriju yiwa ka-wingkayaninya yabimantharra, kulu ngulakari ngambala likungu ki-Kada, jambala-wingkayi yabimantharra, li-yabi. Nganinya ka-arri ambirriju ngambalanga liyi-wuluwu liyi-jakardawu. Kulu nganinya barra Adam ka-arri barranamba Jijaj, ambirriju ka-arri alunga liyi-jakardawu kulu kalu-wanda. ");
INSERT INTO jao_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ngala yiwa Jijaj, karnila-ka ngambalanga liyi-wuluwu, narnu-yabi karnila-ka ngaliwa kumba-mirra ngambalanga, Kada yibarranthawu ngambala nmanthawu barranamba yurlurr, ngala Adam, kurdardi karnila-kanma narnu-yabi ngala minja karnila-ka narnu-wardi, karnila-ka narnu-wardi ngaliwa kumba-ngajbirri yiku ki-Yijanku ki-Kada. Nya-mangaji Adam, ka-ngajbirri yiku ki-Kada, narnu-wardi karnila-ka ki-arrkulangku ngambalanga liyi-wuluwu liyi-jakardawu, kulu bajingu jambala-wardimanji awara kulu jambalamba-mirranji, jambalamba-mirranji ngambala li-wulu wiji. Ngala nyarrku, Jababa Jijaj Kurayij, narnu-yabi karnila-ka ki-arrkulangku, karnila-ka narnu-yabi ngambalanga liyi-jakardawu ngaliwa kumba-mirra ngambalanga. Karanka kili-ja ki-Yijandu ki-Kada, yabi jiwini, kalngiya yabi jiwini yabimanthawu awara ngambalanga liyi-wardiyu nganinya. ");
INSERT INTO jao_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Jijaj, kumba-mirra ngambalanga wumba kambala-wardima awara yurrngumantha, kumba-mirra kulu bajingu ki-Kada jambalilu-yibarranji nmanthawu barranamba yurlurr yiku, nganinya ki-Jijaj karnila-ka narnu-yabi Ngala Adam, kurdardi karnila-kanma narnu-yabi ngala narnu-wardi karnila-ka bajarnaji wumba kilu-wardima awara, kumba-ngajbirri arrkulawu yiku ki-Kada, nganinya kilu-wardima awara kulu bajingu ki-Kada jalilu-ramanji li-wulu nuwarnu-wardiyu. ");
INSERT INTO jao_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kulu ngambala, jambalini li-mirdan yiku ki-Adam, kilu-wardima awara yiwa arrkula kulu bajingu jambalamba-mirranji, jambalamba-mirranji ngambala li-ngulangulakaringu, li-wulu wiji. Jambalamba-mirranji wiji kangka ka-ngajbirri arrkula ki-wukawu wumba kili-jirrinyma ki-Kada, ka-ngajbirri arrkula. Baki mili jambalini li-mirdan yiku ki-Jijaj, kalngiya jambalini li-mirdan yiku, kumba-mirra yiwa arrkula ngambalanga liyi-wuluwu, kulu Wunyatha, jambalilu-mirlirlmirlirlmanji, j ambalilu-mirlirlmirlirlmanj i kalngiya, jambalilu-yibalyibarranji ngambala nmanthawu barranamba yurlurr yiku ki-Kada, kangka kumba-mirra ngambalanga liyi-wuluwu nya-mangaji arrkula, Jijaj Kurayij. Bajingu jambalilu-mirlirlmirlirlmanji mili yurrulu, jambalilu-ngulngundayi narnu-lhungku narniku, na-mangaji narnu-lhungku karanka jambalilu-ngulngundayi, kulu kambaliluyibalyibarrala nungkarnu-yabinja ankangu, ngambala nmanthawu ngambala-lhungku ngambala-yurrngu, yurrngumantha barni-binja. ");
INSERT INTO jao_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nganinya barra jarna-yunduyundumanji yirrunga, arrkula mirningiya Adam ka-ngajbirri yiku ki-Kada kulu bajingu li-wulu wiji jambala-wardimanji awara, kulu jambalilu-ramanji ki-Kada nuwarnu-wardiyu kangka kambalilu-warrirra ki-arrkulangku. Kulu nyarrku mirningiya yurlurr Jijaj Kurayij kumba-mirra, kulu bajingu ki-Kada jambalilu-yibalyibarranji nmanthawu barranamba yurlurr yiku, jambalilu-ngulngundayi narnu-lhungku narniku ngambalanga liyi-wuluwu wiji namba jambalamba-yibarranji ngambala-wurdu yilaa ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nganinya barra, arrkula mirningiya ka-ngajbirri ki-Kada, kulu ngambala li-jakarda jambalini nungkarnu-wardinja wardimantharra. Nganambajilulu barra nyarrku mirningiya ka-ngayangayarri ki-Kada, kulu ngambala li-jakarda jambalini nungkarnu-yabinja, ki-Kada kambalilu-yibarrala nmanthawu barranamba yurlurr yilaa. ");
INSERT INTO jao_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kulu jarna-yunduyundumanji yirrunga nganinya, Yijan Kada kilu-ngunda narnu-yuwa yiku ki-Mujij, kalilu-milirdima li-wulu nganinya nungkarnu-yuwangka nungku-mangaji, ngalalu jalu-wardimanji awara li-wulu ngalalu jalu-ngajbirrinji yiku ki-Kada li-mangaji wumba jalu-wardimanji. Kulu li-mangaji li-yuwawiji, kurdardi kalinyamba-wamanma wardimanthawu awara ngala minja kalu-wardimanthaninya mili yurrulu. Ngala Yijan Kada, yabi jiwini, kalngiya yabi, kilu-yabimanthaninya awara alunga liyi-mangaji, kiwa-ninya wuntha na-wurdu alunga bakuwu. ");
INSERT INTO jao_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Kulu jarna-yunduyundumanji mili yirrunga, linji-wulungku kalu-wardima awara kurdandu kulu kalinyamba-mirra nuwarnu-wardiyu. Ngala yabi jiwini Kada. Ngulakari kili-ja nyiki-ardu Jijaj Kurayij nya-mangaji yurlurr, kumba-mirra ngambalanga liyi-wardiyu, ngambala nmanthawu barranamba yurlurr yiku ki-Kada, kulu kambala-nama lhungku barra nungkarnu-yabinja barra, jambalilu-ngundayi narnu-lhungku narnu-yurrngu ki-Kada, yabi barra jiwini, kalngiya yabi. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Li-mbangu, li-mbangu li-wulu li-manji, jalu-yudirrinji kulu jalu-arrinji ngatha nganinya, “Ngabinya! Janinyu-milirdimanjimu barra, namba janu-wardimanji awara kulu Yijan Kada jiwini yabi yabimantharra awara nganunga, yabimantharra awara nuwarnu-wardiyu nuwarnu-nganunga. Namba janu-wardimanji kurdandu, kulu Yijan Kada, yabi jiwini kalngiya, yabi barra yabimantharra awara nuwarnu-wardiyu nuwarnu-nganunga mili yurrulu. Jinangu wuka wumba janinyi-nanjimu marringaya. Kanu-wardimanjanama yurrngumantha, kanu-wardimanjanama wakulamba, kulu kilu-yabimanthanama awara nganunga ki-Kada, kilu-yabimanthanama awara wakulamba nuwarnu-wardiyu nuwarnu-nganunga. Kiwa-nama yabi Kada, yabi barra nganinya. Wayi barra? Janu-wukanyinji yamulu barra?” Jalu-arrinji nganinya kulu jarnalu-yalbanganji nganinya, ndalu li-manji. ");
INSERT INTO jao_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Wardimbangu wuka jalu-wukanyinji, wardimbangu. Li-yakayaka jalini, li-yakayaka. Ambuliyalu kambala-arri li-wardi wardimantharra awara yurrngumantha, ngala nganinyanga kurdardi. Kambalamba-yibarra ngambala-wurdu yilaa ki-Jijaj wumba kumba-mirra nuwarnu-wardiyu nuwarnu-ngambalanga. Kurdardi kambalamba-nykalanykarriyu nuwarnu-wardiyu yurrngumantha barrawumba kambala-arri ambuliyalu, kurdardi. Karnangambala-wayatha nyamba-nykalanykarrinj awu nuwarnu-wardiyu bawuji. ");
INSERT INTO jao_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Karnangambala-ndarra wardimanthawu awara kangka kambalalu-ngabunjama. Kambalamba-yibarra ngambala-wurdu yilaa ki-Jijaj Kurayij kulu kambalalu-ngabunjama nganinya, ngambala nyamba-mirnimanthawu likungu barra, ngambala-ngawulu yilaa nungka-ngawulungka, nmantharra lhungku marda, arrkula barra. Namba kambalalu-ngabunjama, ngambala nmanthawu yilaa ki-Jijaj nungka-ngawulungka, arrkula nganinyanga, kulu jambalini ngambala-ngawulu barranamba kambala-arri yilaa nungka ngawulungka ambuliyalu marda. Ngaliwa kumba-mirra ngalingambala barrawumba kambalambamirra marda baji yilaa, ngambala Jijaj arrkula. ");
INSERT INTO jao_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ngalalu kalu-kurrama nungku-ajinjala, baki ngambala mili barrawumba kambala-arri kurramantha yilaa, ngambala Jijaj arrkula. Kambalamba-mirnima nganinya ngalalu kambalalu-ngabunjama, ngambala nmanthawu yilaa nungka-ngawulungka ki-Jijaj arrkula. Kulu ka-lhungkurri Jijaj. Kilu-lhungkuma Wunyathalu, kilu-lhungkuma Wunyathalu nungkarnu-wunungula nungkarniku. Ngaliwa ka-lhungkurri Jijaj baki mili barranamba ngambala kambala-lhungkurri yilaa, ngambala Jijaj arrkula, bawuji. Kulu bajungkarnu jambalini barranamba nalarrku li-wulu, barranamba li-rdiyangu li-wulu. Bajingu jambala-wingkayi yurlurr yilaa ki-Jijaj, ngambala nmanthawu yilaa li-marringaya li-yurlurr. ");
INSERT INTO jao_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Namba kambala-arri barranamba nalu-ngabaya baji yilaa ki-Jijaj na-ngabangaku, kulu jambalini mirdan, baku kambala-lhungkurrila, ki-Kada kambalilu-lhungkumala ngambala marda baku, ngambala nmanthawu ngambala-lhungku ngambala-yurrngu barrawumba kilu-lhungkumala Jijaj, jiwini lhungku na-yurrngu, kambala-nama li-lhungku yilaa. ");
INSERT INTO jao_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Kulu nganinya jambalamba-lhaanji barra. Ngambala li-wulu, nungkarnarrku kambala-mij anganthaninya, kambala-ninya wuluwulu nuwarnu-wardiyu, narnu-wardi karnangambala-mijanganthaninya. Ngala Jababa Jijaj kalu-yibarra warriwarriyamba ki-wurndaa, kalu-rama baji, kulu nganinya barra ngambala ki-Jijaj arrkula, barrawumba kambalalu-yibarra, barrawumba kambalalu-rama, barrawumba kambalalu-rama ngambala mijangantharra nuwarnu-wardiyu ngambala-wurdu yurrngumantha. Kumba-mirra baji Jijaj, barrawumba kambalamba-mirra marda baji, kulu karnangambala-wayatha nykalanykarrinj awu nuwarnu-wardiyu yurrngumantha, karnangambala-wayatha. Nganinya ngambala-wingkayani winarrku yilaa ki-Jijaj barninyamba-nykalanykarrinjawu nuwarnu-wardiyu, kangka kambalamba-mirra ngambala ki-Jijaj arrkula, jambala-wingkayi winarrku barni-wardimanthawu. ");
INSERT INTO jao_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Karnangambala-nda wambu narnu-wardi namba barranamba kambalamba-mirra ngambala ki-Jijaj arrkula, jambala-wingkayi winarrku barni-wardimanthawu, ngambala likungu ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kulu ngambala, jambalini mirdan nganinya, namba barranamba kambalamba-mirra ngambala ki-Jijaj Kurayij arrkula, kulu barranamba Jijaj ka-lhungkurri, jiwini lhungku, barrawumba ngambala kambala-lhungkurrila, kambala-nama ngambala-lhungku yilaa. ");
INSERT INTO jao_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kangka jambalini li-mirdan yiku ki-Jijaj, jiwini lhungku barni-binja, kilu-lhungkuma ki-Kada wumba na-ngabaya ka-arri, barnikumba-mirrarru mili yurrulu, jiwini lhungku na-yurrngu. Jiwini lhungku na-yurrngu barra, kilu-wayatha yiwa nyamba-mirranthawu, kila-nda bawuji, lhungku ka-wingkalwingkayanama winarrku. ");
INSERT INTO jao_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ngaliwa kumba-mirra, ngabaya ka-arri nuwarnu-wardiyu nuwarnu-ngambalanga liyi-wuluwu arrkulawu bawuji. Ngala minja ka-lhungkurri barra, lhungku jiwini yiku ki-Kada, lhungku ndiwa. ");
INSERT INTO jao_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Marrirru, yirru marda, rra-nmanthani nganinya, rra-nmanthani arrkula yilaa ki-Jijaj, kurdardi nyamba-nykalanykarrinj awu nuwarnu-wardiyu, nyirra-ndarra bawuji! Ngala minja rra-nmanthani nungkarnu-yabinja yilaa ki-Jijaj Kurayij, rru-wingkayani yurlurr yiku ki-Kada li-jawina likungu li-marringaya. ");
INSERT INTO jao_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kulu yirru, namba jarnirru-mijanganji narnu-wardi mili yurrulu nirru-wurdu kulu rrinyamba-wukanyiya nirru-wurdu, yirru nmanthawu li-wirdi nuwarnu-mangajiwuthu mijanganthawu narnu-wardi, yirru nyamba-ngarrarnmantharra nuwarnu-wardiyu. Rrinyamba-wukanyiya nganinya, “Kurdardi karna-wardimarru awara, karnamba-ngarrarnmala nuwarnu-wardiyu.” ");
INSERT INTO jao_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Barninyamba-wirringundarra nirru-nganthai wukanyinjawu wardi wuka ngala rrinyamba-wirringundarra wukanyinjawu yabi wuka yiku ki-Kada. Barninyamba-wirringundarra nirru-marliji wardimanthawu ngala rrinyamba-wirringundarra yabimanthawu awara yiku. Barninyamba-wirringundarra nirru-marnda wingkayawu nambinju nungkarnu-wardinju ngala rrinyamba-wirringundarra wingkayawu nambinju wumba kirrili-nanjima ki-Kada nungkarnu-yabinja. Rrinyamba-wukanyiya nirru-wurdu nganinya nyamba-ngarrarnmantharra nirru-manka nmanthawu nungkarnu-wardinja ngala minja rrinyamba-yibarraya nirru-manka yiku ki-Kada, yirru likungu nmanthawu nungkarnu-yabinja, kangka kirrilu-waninjanguma, kirrilu-waninjanguma nakaringu nyungku-mangajiwuthu nyamba-mirranthawu, kirrilu-yibarra, yirru nmanthawu li-lhungku nirru-ngawulu. ");
INSERT INTO jao_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ambuliyalu ngalirru kirra-nykarrinjaninya narnu-yuwa ki-Mujij, narnu-wardi karnu-arri narnu-wunungu yirrunga kulu kirru-wardimanthaninya awara, kirru-arri li-wardi. Ngala nganinyanga ngaliwa Kada jiwini yabi yirrunga, kulu barni-nykarrinja nuwarnu-yuwawu yurrngumantha ngala nyirra-nykarrinjani yiku ki-Kada wumba yabi jiwini, rru-wingkayani yurlurr yiku, likungu li-jawina. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Li-mbangu li-wulu li-manji, jalu-yudirrinji kulu jalu-arrinji mili ngatha, “Ngabinya! Yinda janinyu-milirdimanjimu barra nganinya. Ambuliyalu kambala-arri li-jawina, li-jawina nuwarnu-yuwawu ki-Mujij. Jiwini yabi Yijan, yabi barra Kada, kulu kambala-wingkayima winarrku nuwarnu-yuwawu. Karnangambala-ndarra na-mangaji narnu-yuwa. Kambala-wingkala winarrku nuwarnu-yuwawu wumba kambalili-nu ki-Kada, ngambala nyamba-ngarrarnmanthawu nuwarnu-wardiyu. Minja kambala-wingkala wardimantharra. Wayi barra? Janu-wukanyinji yamulu barra?” Jalu-arrinji nganinya, jarnalu-yalbanganji nganinya, ndalu li-manji. Wardimbangu wuka jalu-wukanyinji, wardimbangu. Li-yakayaka jalini, li-yakayaka. Ngalalu jarnalu-yalbanganji nganinya ngalingarna milirdimantharra alunga mili yurrulu nganinya. ");
INSERT INTO jao_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Yirru, kirrima mirdan, namba jirra-nykarrinji arrkula mirningiya yurrngumantha, namba jirru-ngayangayarrinji yiku, kulu jirrinyamba-yibarranji yiku, jirrinyamba-yibarranji yirru nmanthawu li-jawina yiku, li-jawina nyuwu-mangaji. Barranamba nya-mangaji wuka, namba jalirra-nykarrinji liyi-wuluwu wumba jarrilu-yalbanganji wardimanthawu, jirru-ngayangayarrinji alunga kulu jirrini li-jawina nuwarnu-wardiyu, bajingu kirrinyamba-mirrala nirru-ngawulu. Ngala minja namba yirru jirra-nykarrinji Kada yurrngumantha, namba jirru-ngayangayarrinji yiku, kulu jirrinyamba-yibarranji yirru nmanthawu li-jawina likungu. Bajingu ki-Kada, kirrilu-yibarrala nmanthawu barranamba yurlurr yiku, ka-ngayamala yirrunga. ");
INSERT INTO jao_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kulu yirru, ambuliyalu yirru kirra-ninya li-jawina nuwarnu-wardiyu, kirra-ninya li-jawina nuwu-mangajiwuthu nuwarnu-wardiyu, ngala nganinyanga karna-barlirra Wunyatha, karna-barlirra Wunyatha ankaya yirrunga kangka kirrinyamba-yangama, kirrinyamba-yangama yabi barra, kirra-nykarri nya-mangaji wuka, kirra-nykarri nya-mangaji wuka wumba kirrali-nu yiku ki-Jijaj, kulu kirrinyamba-yangama, jirru-ngayangayarrinji nyuwarrkulu, jirru-ngayangayarrinji nya-mangaji wuka ki-Jijaj, nya-mangaji wuka wumba kalu-wukanyi yirrunga nalarrku. ");
INSERT INTO jao_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ambuliyalu kirru-arri li-jawina nuwu-mangaj iwuthu nuwarnu-wardiyu, kurdardi kirru-wingkanma winarrku yabi, ngala ki-Jijaj kirrilu-yabima, yirru wayathanthawu nmanthawu li-jawina nuwarnu-wardiyu, kulu nganinyanga jirrini li-jawina barra nuwarrkulu, jirrini li-jawina nuwarniku ki-Kada, li-jawina barra nuwu-mangaj iwuthu nuwarnu-yabiyu. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ngala minja jarna-wukanyinji nganinya yirrung minja jarna-wukanyinji nganinya liyi-mangaji liyi-wuluwu liyi-j awinawu yunduyundumanthawu awara yirrunga kangka jirrini li-manji. Kurdardi kirrima wunungu nyamba-ngarrarnmanthawu nuwarnu-wardiyu ngala jirrini burlurlu nirru-manka nuwarnu-wardiyu, kulu jarna-wukanyinji minja liyi-jawinawu yunduyundumanthalu awara yirrunga. Ambuliyalu, namba karnirru-mijanga narnu-wardi, kulu kirrinyamba-wirringunda nirru-manka nuwarnu-wardiyu, kirrinyamba-wirringunda nirru-nganthal, nirru-marliji, nirru-marnda, wiji kirrinyamba-wirringunda nirru-manka nuwarnu-wardiyu, kulu kirrinyamba-wirringunda mili yurrulu nuwarnu-wardiyu nuwarnu-jakardawu, nganinya kirra-ninya yurrngumantha. Ngala nganinyanga rrinyamba-wirringundarra nirru-manka yabimanthawu, rinyamba-wirringundarra yabimanthawu awara nirru-nganthal, nirru-marliji, nirru-marnda, rrinyamba-wirringundarra nirru-manka wiji nuwarnu-yabiyu. Nganinya kirra-nmala rlikarlika nirru-wurdu, li-marringaya, kulu Yijan Kada kumba-riyarrabala yirrunga. ");
INSERT INTO jao_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ambuliyalu, ngalirru kirru-arri li-jawina nuwu-mangajiwuthu nuwarnu-wardiyu ngalarnu na-mbanguwuthu narnarrku, na-mangajiwuthu nuwarnu-yabiyu, kurdardi yirrunga na-mangaji. Minja kirru-wingkayaninya kurdardi nykarrinjawu na-mangaj iwuthu nuwarnu-yabiyu ngala nykarrinjawu nuwarnu-wardiyu. ");
INSERT INTO jao_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ngala nganinyanga jirru-wananji nuwu-manga j iwuthu nuwarnu-wardiyu wumba kirru-wingkayaninya wardimantharra, jirru-wananji. Kulu wayi barra na-mangajiwuthu nuwarnu-wardiyu? Yabi yirrunga na-mangaji? Yabi barra kirra-ninya nirru-wurdu nungku-mangajiwuthu? Kurdardi. Karnungka-wardimanthaninya awara yirrunga nungku-mangajiwuthu ngala kurdardi karnungka-yabimanthanima, kurdardi. Li-mbangu li-wulu, namba jalini nungkarnu-wardinja yurrngumantha kulu bajingu barra kala-nama winkanda ki-awarala ki-Kada nalu-yurrngu, waraba barra kala-nmarru yilaa, kurdardi. ");
INSERT INTO jao_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ngala yirru, ngalirru jirrinyamba-yibarranji yirru nmanthawu li-jawina likungu ki-Kada, bajingu ki-Kada jirrilu-yabimanji nirru-wurdu, yirru ndayawu narnu-wardi, yirru wingkayawu winarrku yabi, yirru nmanthawu rlikarlika nirru-wurdu. Kulu ngambalanga, marrirru, ngambalanga wiji wumba rlikarlika ngambala-wurdu, kambalilu-ngundarra ki-Kada, kambalilu-ngundarra na-mangaji narnu-lhungku, narnu-lhungku narniku narnu-yurrngu ngambalanga, ndingambala li-rlikarlikawurdu. ");
INSERT INTO jao_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bawuji barra, nganinya jirna-yunduyundumanji, namba li-wulu jalu-wardimanji awara, namba jalinyamba-yibarranji li-jawina nuwu-mangajiwuthu nuwarnu-wardiyu, kulu kalinyamba-mirrala nyungku-mangajiwuthu, kalinyamba-mirrala li-mangaji. Ngala li-mbangu nalarrku, li-jawina likungu ki-Kada, jambalilu-ngundayi narnu-lhungku, jambalilu-ngundayi kalngiya na-mangaji narnu-lhungku narnu-yurrngu, kangka Wirdiwalangu Jijaj Kurayij, kumba-mirra ngambalanga. Bajuwarnu jambalilu-ngundayi kalngiya narnu-lhungku narnu-yurrujurru, na-mangaji barra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Marrirru, na-mangaji, na-mangaji narnu-yuwa ki-Mujij, jirrini li-mirdan nuwu-mangaji, na-mangaji alunga liyi-lhungkuwu, kurdardi alunga liyi-ngabangakuwu. Kalili-nu li-wulu ki-Kada, alu nmanthawu li-ngayangaya nuwu-yuwawu ngalalu jalini lhungku, alunga liyi-lhungkuwu na-mangaji. ");
INSERT INTO jao_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kulu bajiwa arrkula wuka nungkarnu-yuwangka ki-Mujij, nya-mangaji alunga liyi-majkalmajkarranguwu, narnu-yuwa alunga. Rra-mangaji rriku-wangu, kanda-nmala wambu yilaa nyungkanku-wangu. Waraba kanda-wulumarru yilaa nyungkarrku, waraba kanda-wulumarru rra-mayirli, kanda-nmala wambu yilaa alinda nyungkanku-wangu bawuji. Ngala baku ngulakari, namba kumba-mirrala nya-mangaji nyanku-wangu, kulu waraba yiku nyuwanku-wanguwu, a-mangaji wambu jandini. Nya-mangaji wuka alunga liyi-majkalmajkarranguwu barra, waraba mili anku, ngabangaku barra nyanku-wangu, waraba anku nya-mangaji wuka. Kanda-nmala winarrku ki-wukawu nyuwu-mangaji, kanda-nmala winarrku. ");
INSERT INTO jao_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ambuliyalu, namba rra-mangaji rriku-wangu jandini walkurr yilaa nyungkarrku ngaliwa jiwini lhungku nyanku-wangu, kulu jandini rra-mayirli, kurdardi yurlurr nuwarnu-yuwawu ki-Mujij ngala rra-wardimbangu rra-mayirli. Ngala namba jandini wambu yilaa nyungkanku-wangu yurlurr, namba kumba-mirrala nyanku-wangu nungkarnarrku baku, kulu nya-mangaji wuka ki-Mujij waraba barra mili anku, kanda-wingkala winarrku. Namba a-miyaji rumanda kanda-nmala alinda yilaa nyungkarrku, kanda-nmala rriku-wangu yamulu, kurdardi kanda-nmarru rra-mayirli nganinya, kurdardi, narnu-yabi. Nganinya barra namba kumba-mirra nyanku-wangu, baku kanda-nmala mili yurrulu alinda yilaa nyungkarrku yamulu, kurdardi barra rra-mayirli nuwarnu-yuwawu, kurdardi barra, kangka kumba-mirra nyarrku nyanku-wangu ambuliyalu, kumba-mirra, kulu kanda-arri winarrku nuwarnu-yuwawu. ");
INSERT INTO jao_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Barranamba a-mangaji a-nhanawaya janda-wingkayi winarrku nuwarnu-yuwawu kangka kumba-mirra nyanku-wangu, jandini winarrku nmanthawu alinda nyungkarrku, barranamba ngambala, marrirru, jambala-wingkayi winarrku nuwarnu-yuwawu ki-Mujij kangka ngambala kambala-arri ngambala-ngawulu barranamba arrkula yilaa ki-Jijaj Kurayij, barranamba arrkula yilaa ngaliwa kumba-mirra ngabangaku, barrawumba kambalamba-mirra ngambala ki-Jijaj arrkula baji. Kulu barranamba ngabaya karnilu-wayatha nyamba-nykalanykarrinjawu nuwarnu-yuwawu, ngayangayarrinjawu nuwarnu-yuwawu, barranamba ngambala jambala-wingkayi winarrku nuwarnu-yuwawu, jambalini winarrku nmanthawu likungu nyuwarrkulu, likungu ki-Jijaj, barranamba rra-mangaji kanda-arri winarrku nuwarnu-yuwawu, winarrku nmanthawu rrikungu nyuwarrkulu. Jambalini winarrku nmanthawu likungu ki-Jijaj, nya-mangaji wumba kilu-lhungkuma ki-Kada. Kulu jambalini likungu ki-Jijaj, likungu nmanthawu li-yabi yiku ki-Kada, ngambala nyamba-mirnimanthawu ngambala likungu li-marringaya. ");
INSERT INTO jao_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ambuliyalu, kurdardi kambala-nima li-marringaya nganinya, kurdardi. Ambuliyalu kambalamba-nykalanykarri ngambala-wurdu, ngambala mijanganthawu nuwarnu-wardiyu yurrngumantha. Kambala-nykarri narnu-yuwa ki-Mujij, ngambala nyamba-ngarrarnmanthawu, nyamba-ngarrarnmanthawu nuwarnu-wardiyu. Ngala minja bajingu kambalamba-nykalanykarri nuwarnu-wardiyu ngambala-wurdu, kambalamba-nykalanykarri nuwarnu-wardiyu kulu kambala-wardima awara barra, kambala-wardima awara. Kulu li-wulu, namba jalu-wingkayi nungkarnu-wardinj a yurrngumantha kulu kalinyamba-mirrala. Kulu ambuliyalu ngambala marda, kambala-wingkayaninya nganinya. ");
INSERT INTO jao_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ngala nganinyanga kurdardi, jambala-wingkayi winarrku nuwarnu-yuwawu, kurdardi kambalamba-nykalanykarriyu nuwarnu-yuwawu yurrngumantha. Jambala-wingkayi winarrku kangka ngambala-ngawulu barrawumba kambalamba-mirra ngambala ki-Jijaj ngabaya arrkula, kambalamba-mirra nuwarnu-yuwawu, jambala-wingkayi winarrku. Kulu nganinyanga, kurdardi kambala-wandayima na-mangaji narnu-yuwa wumba kalu-balirra wankala ngala minja jambala-wandayi Na-ngawulu Kada, Na-ngawulu Kada karanka jambala-wandayi, jambala-ngayangayarrinji nyuwu-mangaji. Jiwini lhungku kulu jambalilu yabimanji, jambalilu-yangamanji ngambala-wurdu, ngambala mijanganthawu nuwarnu-yabiyu. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Kulu li-mbangu, li-mangaji li-wulu li-manji, jalu-yudirrinji kulu jalu-arrinji mili ngatha, “Ngabinya! Ngalhi jinangu janinyi-nanjimu? Ngalhi jinangu janinyi-nanjimu nuwarnu-yuwawu ki-Mujij? Narnu-yuwa wardimbangu? Wardimbangu na-mangaji?” Nganinya jarnilu-yalbanganji, ndalu li-manji. Ngala kurdardi barra, kurdardi. Li-yakayaka jalini, li-yakayaka. Narnu-yuwa narnu-marringaya, kurdardi wardimbangu. Ngala minja ambuliyalu ngalingarna karna-arri manji nuwarnu-yuwawu ngalingarna karna-arri manji nuwarnu-wardiyu nuwu-mangaji wumba kalu-yunduyunduma nungkarnu-yuwangka. Ngulakari karnalu-milirdima narnu-yuwa, kulu karnalu-milirdima, “Barni-mijangantha nya-mbangu yiku nyuwarrkulu, barni-mijangantha nyikungu!” Ambuliyalu karna-arri manji nuwarnu-wardiyu nuwu-mangaji, mijanganthawu nyuwiku ki-awarawu, kurdardi karnarna-lhaanma. Ngala minja ngulakari mirdan karna-arri, namba karna-mijanganjima nya-mbangu nyikungu kulu karna-wardimanjima awara nganinya. ");
INSERT INTO jao_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kirna-nykarri nya-mangaji wuka, “Barni-mijangantha nya-mbangu yiku nyuwarrkulu,” karnamba-nykalanykarri nyuwu-mangaji ki-wukawu barra ngarna-wurdu, kulu karna-arri wardingala ngarna-wurdu mijanganthawu, karna-arri nganinya. Namba waraba nuwarnu-yuwawu kulu waraba barra kalinyamba-nykalanykarrinjima nuwarnu-wardiyu nganinya li-wulu. ");
INSERT INTO jao_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ngarna, wabarrangu karna-arri manji nuwarnu-yuwawu ngala minja ngulakari kirna-nykarri nya-mangaji wuka, mirdan nyuwu-mangaji ki-wukawu nuwarnu-wardiyu, karnamba-nykalanykarri nuwarnu-wardiyu, kulu karna-wardima awara, kulu bajingu karna-wardirri ngarna-wurdu, rarrinjarra ngarna-wurdu, karnamba-lhaa kalngiya wardi barni-yabirrinjawu. ");
INSERT INTO jao_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","11","Narnu-yuwa, na-mangaji yunduyundumanthawu awara ngambalanga, ngambala nyamba-ngarrarnmanthawu nuwarnu-wardiyu, ngambala nmanthawu yabi ngambala-wurdu, ngala ngarna, karnarna-nykarri na-mangaji kulu karna-wardima awara, karna-ngajbirri nuwu-mangaji kulu bajingu karna-wardirri ngarna-wurdu rarrinjarra ngarna-wurdu, karnamba-lhaa kalngiya wardi barni-yabirrinjawu. Ngarna, mirdan nuwarnu-yuwawu ki-Mijij, karna-arri nganinya. Kathingarna ngarna wingkayawu yurlurr nuwarnu-yuwawu, ngarna nmanthawu yabi, ngala kurdardi. Karna-wardima awara, karna-arri nungkarnu-wardinja. Ngala ngarna ngarna-wurdu mijanganthawu nuwarnu-wardiyu, karnamba-mululuma, karnamba-walarndima baku, baku karnamba-nguyulnguyulma. Ngalingarna karna-nykarri narnu-yuwa, kurdardi karnamba-ngarrarnmanma nuwarnu-wardiyu ngala karnamba-nykalanykarri nuwarnu-wardiyu ngarna-wurdu, karnamba-nykalanykarri kulu karna-wardima awara. Kulu bajingu karna-wardirri ngarna-wurdu, rarrinjarra ngarna-wurdu, karnamba-lhaa kalngiya wardi barni-yabirrinj awu. Karnamba-nguyulnguyulma nganinya. Katha karna-mijanga narnu-yabi yabimanthawu awara ngatha, katha yamulu barra wardimanthawu awara, ngala kurdardi. Karna-wardima kulu karna-wardima awara ngatha, ngarna rarrinjawu ngarna-wurdu. ");
INSERT INTO jao_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ngala narnu-yuwa, na-mangaji narnu-marringaya, karanka nakaringu ki-Kada, yurlurr barra. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kulu li-mangaji li-wulu li-manji, jalu-yudirrinji kulu jalu-arrinji ngatha, “Ngabinya! Janinyi-nanjimu na-mangaji narnu-yuwa narnu-marringaya. Ngala minja janinyi-nanjimu, kirnalu-milirdima narnu-yuwa kulu bajingu yinda ka-wardirrinyu nda-wurdu, rarrinjarra nda-wurdu, kinyamba-lhaanhu kalngiya wardi barni-yabirrinjawu. Kulu ngalhinju barra kilu-wardima awara yinku nganinya? Ka-wardirrinyu nakaringu nungkarnu-yuwangka ki-Mujij? Nungka narnu-wardi na-mangaji?” Jarnalu-yalbanganji nganinya, ndalu li-manji. Kulu jalirni-nanji, kurdardi barra, kurdardi. Li-yakayaka jalini, li-yakayaka. Ngarna ngarna-wurdu mijanganthawu nuwarnu-wardiyu, karnarna-nykarri na-mangaji narnu-yuwa narnu-marringaya, karnarna-nykarri narnu-yabi ngala minja karna-arri wardi, karnawardima awara kulu bajingu karna-wardirri ngarna-wurdu, rarrinjarra ngarna-wurdu, karnamba-lhaa kalngiya wardi barni-yabirrinj awu. Bajingu Kada, jambalilu-milirdimanji nganinya, na-mangajiwuthu mijanganthawu narnu-wardi, na-mangajiwuthu mijanganthawu wardimanthawu, wardimbangu na-mangajiwuthu, kalngiya wardimbangu. ");
INSERT INTO jao_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ngala narnu-yuwa na-mangaji narnu-marringaya, karanka karnilu-ngunda ki-Kada Nungka-ngawulungku, ngala ngarna, jarnini jibiya ki-awarala marnaji wajka. Jarnini barranamba li-wulu wiji, kulu ngambalanga liyi-wuluwu narnu-wardi na-mangaji narnu-wunungu, na-mangajiwuthu mijanganthawu nuwarnu-wardiyu, wunungu ngambalanga barra. ");
INSERT INTO jao_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Kulu jarnamba-yalbanganji ngarna-wurdu, “Ngalhiyu jarnini wardi nganinya? Ngalhiyu jarna-wardimanji awara nganinya?” Jarnamba-yalbanganji nganinya kangka kurdardi karna-wingkayima yurlurr wumba jarna-mijanganji wingkayawu yurlurr. Jarna-ngandiyanganji yabimanthawu awara ngala minja kurdardi karna-yabimanjima ngala minja jarna-wardimanji awara. Ngalingarna jarna-wardimanji nganinya, jarna-wardirrinji ngarna-wurdu nyamba-nykalanykarrinjawu ngatha, ngarna wardi. ");
INSERT INTO jao_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Namba jarna-wardimanji awara, kulu jarna-wardirrinj i ngarna-wurdu marda nuwarnu-wardiyu nuwarnu-ngatha wumba jarna-wardimanji. Kulu namba jarna-wardirrinji ngarna-wurdu nuwarnu-wardiyu, kulu jarna-ngayamanji nuwu-mangaji nuwarnu-yuwawu kangka ki-Kada, jambalilu-milirdimanji nungku-mangaji nungkarnu-yuwangka, narnu-wardi barra wardimbangu, jarna-ngayamanji yiku. ");
INSERT INTO jao_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jarna-ngandiyanganji wardimantharra, kulu wunungu barra ngatha na-mangajiwuthu ngandiyangantharra nuwarnu-wardiyu. Ngarna ngarnalumba, jarnini burlurlu nuwu-mangajiwuthu, waraba barra karnima wunungu nyamba-ngarrarnmanthawu. Ngarna ngarna-wurdu ngandiyanganthawu nuwarnu-yabiyu, jarnini burlurlu, baki ngarna ngarna-wurdu ngandiyanganthawu nuwarnu-wardiyu, minja jarna-wardimanji awara. ");
INSERT INTO jao_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mijanganthawu nuwarnu-wardiyu, bajarnajiwuthu narnu-wardi jarnini ngathangka. Jarnamba-wukanyinji ngarna-wurdu, “Karna-wingkayama yurlurr, kalngiya karna-wingkayanama yurlurr,” jarnamba-wukanyinji ngarna-wurdu yamulu, ngala minja kurdardi karnima wingkayarra yurlurr, kurdardi. ");
INSERT INTO jao_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ngalingarna karnama nmanthawu yabi, karna-yabimanjama awara ngalingarna jarnamba-ayayananji yabimanjawu, minja jarnamba-ayayananji. Ngalingarna karnama nyamba-ngarrarnmantharra nuwarnu-wardiyu, karnamba-ngarrarnmanthama nuwu-mangaji ngalingarna jarna-wardimanji awara, minja jarna-wardimanji. ");
INSERT INTO jao_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ngalingarna jarna-wardimanji awara ngalingarna ngarna-wurdu kurdardi karnarnu-mijanganjima bajarnajiwuthu ngala minja jarna-wardimanji awara winarrku. ");
INSERT INTO jao_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Kulu nganinya barra jinangu awara, namba karna-yabimanjama awara kulu na-mangaji narnu-wardi “Marnajarnu! Marnajarnu!”, yurrngumantha ngathangka. ");
INSERT INTO jao_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kulu ngarna, jarnamba-riyarrabanji nuwarnu-yuwawu ki-Kada, jarnamba-riyarrabanji nuwu-mangaji ngarna-wurdu, ngala minja marnajingarna barranamba rri-kanymarda. ");
INSERT INTO jao_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ngarna barra arrkula karnarna-wandayama narnu-yuwa ki-Kada ngala ngarna barra nyarrku karnarna-wandayama narnarrku, na-mangajiwuthu mijanganthawu nuwarnu-wardiyu. Kulu na-mangajiwuthu mijanganthawu nuwarnu-wardiyu, wunungu ngatha barra, wunungu ngatha barranamba wirdi ngatha. ");
INSERT INTO jao_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","25","Bawuji barra, jirrirni-nanji barra, marrirru, jarna-yunduyundumanji awara ngatha nganinya, namba kurdardi karnilu-yabimanjima nganinju, namba karnima minja ngarna ngarnalumba, kulu jarnamba-nykalanykarrinji ngarna nmanthawu yurlurr ngala minja jarnini jawina nuwu-mangajiwuthu mijanganthawu nuwarnu-wardiyu, ngarna ngarnalumba. Warriya luku ngarna! Nganinju karnilu-yabimala? Nganinju karnilu-yabimala ngarna nmanthawu arrkula yabi? Nganinju karnilu-walimala na-mangajiwuthu mijanganthawu nuwarnu-wardiyu, na-mangajiwuthu wardimanthawu awara ngatha kurdandu? Nganinju karnilu-marakamala, ngarna wingkayawu winarrku yabi, nganinju? Wakara barra! Marniwa arrkula wunungu! Kirna-barlirra Wunyatha, karanka kinyi-janhu Jijaj, Wirdiwalangu Jijaj Kurayij, nya-mangaji barra yabimanthalu awara ngatha, nya-mangaji marakamanthalu, kirna-barlirra Wunyatha. Bawuji barra. ");
INSERT INTO jao_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Marrirru, kilu-yabima awara ki-Jijaj Kurayij, kalngiya kilu-yabima awara ngambalanga wumba jambalini likungu, ngambala-ngawulu yilaa ki-Jijaj arrkula. Kulu Kada, baku ngaliwa kalilu-ramala li-wulu li-wardi, kurdardi kambalilu-ramarru, kurdardi kambalilu-ramarru ngambala likungu ki-Jijaj, kurdardi, yabi kambala-nama winarrku kangka ki-Jijaj kilu-yabima awara ngambalanga. ");
INSERT INTO jao_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kurdardi karabalilu-ramarru ki-Kada bajarnaji kangka kambalilu-yabima ngambala-wurdu ki-Jijaj, kambalilu-yabima wumba karnangambala-mijanga narnu-wardi ambuliyalu. Ambuliyalu karnangambala-wanda bajarnajiwuthu mijanganthawu nuwarnu-wardiyu ngala nganinyanga jambala-wandayi nyarrku, jambala-wandayi Jijaj Kurayij, jarnangambala-wandayi narnu-yuwa narnu-marringaya narniku. Kulu Na-ngawulu karanka, Na-ngawulu Jijaj wumba jambalilu-ngundayi narnu-lhungku, yiwa kambalili-nu wingkayawu winarrku, kambalili-nu wingkayawu winarrku nuwarnu-yuwawu ki-Mujij wumba kambalamba-ayayanu ngayangayarrinjawu nuwu-mangaji, kambalili-nu ngambala wingkayawu winarrku bajarnaji ngaliwa ki-Kada kalilu-ramala li-wulu li-wardi. ");
INSERT INTO jao_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Na-mangaji narnu-yuwa ki-Mujij, karnangambala-nykarri ngala kurdardi karnangambala-wayathanma mij anganthawu nuwarnu-wardiyu, kurdardi karnangambala-wayathanma wardimantharra ngalingambala karnangambala-nykarri na-mangaji. Ngala Kada, kili-ja nyiki-ardu Jijaj karanka, yiwa nmanthawu kalngiya mirningiya, na-manka barranamba ngambala-manka, kulu kumba-mirra ngambalanga. Kumba-mirra kulu bajarnaji kilu-yabima awara ngambalanga, ngambala wayathanthawu wardimanthawu. Ambuliyalu kambala-ninya nungkarnu-wardinja ngala kumba-mirra Jijaj yangamanthawu awara ngambalanga. ");
INSERT INTO jao_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Bajingu kambala-nmala yurlurr yiku, barrawumba kambalilu-milirdima ki-Kada nungkarniku nungkarnu-yuwangka, ngambala nmanthawu yurlurr. Ngalingambala jambalini yurlurr yiku nganinya kulu ngambala barra ngambala-wurdu, jambala-nykarrinji Na-ngawulu Kada karanka, jambala-nykarrinji nya-mangaji barra, kurdardi kambalamba-nykarrinjima ngambala mijanganthawu nuwarnu-wardiyu, kurdardi. ");
INSERT INTO jao_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Li-mbangu, li-wulu wumba jalinyamba-nykarrinji nalu-wurdu mi jangantharra wardimanthawu, j alinyamba-yurrujurrumanji nyamba-nykalanykarrinj arra mijanganthawu wardimanthawu, ngala ngambala wumba jambalanykarrinji Na-ngawulu Kada karanka, jambalamba-yurrujurrumanji ngayangayarrinjawu yiku. ");
INSERT INTO jao_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kulu li-wulu, namba jalinyamba-yurruj urrumanji nyamba-nykalanykarrinjarra mijanganthawu nuwarnu-wardiyu kulu kalinyamba-mirrala nalu-ngawulu, kala-nama winkanda ki-awarawu nyuwiku ki-Kada, kurdardi kala-nmarru yilaa ki-awarala ki-yabinja ki-Kada. Ngala ngambala, namba jambalamba-yurrujurrumanji nykarrinjarra Na-ngawulu Kada, kulu kambala-nama lhungku ngambala-ngawulu, kambala-nama yabi ngambala-wurdu wuntha, nungkarnu-yabinja yilaa ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ngala li-mangaji nalarrku, jalinyamba-yurruj urrumanji nyamba-nykalanykarrinjarra mijanganthawu nuwarnu-wardiyu, jalini li-nganji yiku ki-Kada, barranamba li-yinjatha yiku. Jalu-ngajbirrinji nuwarnu-yuwawu ki-Kada, kurdardi kalu-ngayangayarrinjima nuwu-mangaji nuwarnu-yuwawu, kulu kurdardi kalu-ngayangayarriyu. ");
INSERT INTO jao_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Alunga liyi-mangaji kurdardi kumba-riyarrabanjima Kada, barnikumba-riyarrabarru alunga liyi-mangaji. ");
INSERT INTO jao_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ngala yirru, kurdardi kirrima barranamba li-mangajiwuthu, waraba kirrinyamba-nykalanykarrinj ima nuwarnu-wardiyu yurrngumantha ngala jirra-nykarrinji Na-ngawulu Kada yurrngumantha kangka nya-mangaji Na-ngawulu jiwini yirruwa wurdulula. Namba bajalu nalarrku, bardabarda yiku nyuwu-mangaji Nuwa-ngawuluwu ki-Kada, bardabarda yiku Nuwa-ngawuluwu ki-Jijaj Kurayij, nya-mangaji Na-ngawulu arrkula, namba nalarrku jalini bardabarda yiku nyuwu-mangaji, kulu waraba barra kalima likungu ki-Jijaj, kurdardi barra likungu. ");
INSERT INTO jao_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ngala ngambala, marrirru, namba Na-ngawulu Jijaj Kurayij jiwini wurdulula ngambalaa, kulu ngambala-ngawulu kambala-nama lhungku, ngambala-ngawulu kambala-nama lhungku ngambala-yurrngu, kangka kambalilu-yibarra ki-Jijaj, kambalilu-yibarra ngambala nmanthawu barranamba yurlurr yiku ki-Kada, ngala minja ngambala-manka kambalamba-mirrala, minja kambalamba-mirrala kangka nuwarnu-wardiyu ngala ngambala-ngawulu kambala-nama lhungku. ");
INSERT INTO jao_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jijaj Kurayij, kumba-mirra ngala ki-Yijandu ki-Kada kilu-lhungkuma, kilu-lhungkuma nya-mangaji ngabangaku. Namba jiwini wurdulula ngambalaa Na-ngawulu Kada, namba jiwini mankanda ngambalaa nganinyanga ngalingambala li-lhungku, kulu kambalilu-lhungkumala ngambala ngambala-ngabangaku baku ngulakari. Kambalamba-mirrala ngala baku ngulakari kambalilu-lhungkumala ki-Kada, kambala-wingkala ngambala ngambala-lhungku li-mankawiji namba Na-ngawulu Kada ngambalaa jiwini mankanda nganinyanga. ");
INSERT INTO jao_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Marrirru, kangka kambalilu-ngunda Na-ngawulu nganinya, kulu kurdardi kambalamba-nykalanykarriyu mijanganthawu nuwarnu-wardiyu, kurdardi kambala-wingkarru nganinya, kambala-wingkayanama yabi yiku. ");
INSERT INTO jao_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Namba kambala-wingkayima wardingala, namba kambalamba-nykalanykarrinj ima mij anganthawu wardimanthawu yurrngumantha, kulu kambalamba-mirrala bawuji. Namba kambala-wingkayima nykarrinjarra yiku Nuwa-ngawuluwu ki-Kada, namba kambala-ngayangayarrinjima nya-mangaji baki kambalamba-ngarrarnmanjima wardiman thawu, kulu kambala-nama lhungku ngambala-ngawulu ngambala-yurrngu. ");
INSERT INTO jao_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kangka ngambala wumba jambalamba-wirringundayi yiku Nuwa-ngawuluwu ki-Kada, ngambala li-jawina likungu, mili jambalini likili-ardu ki-Kada, wurrbi likili-ardu. ");
INSERT INTO jao_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","16","Na-ngawulu ki-Kada, jiwini marringaya, kurdardi kambalilu-wardimanjima ngambala-wurdu ngambala wardankayawu ki-Kada yurrngumantha, ngambala nyamba-nykalanykarrinj awu yiku ki-Kada ramanthawu ngambalanga, ngala minja jambalilu-yibarranji ngambala nmanthawu likili-ardu ki-Kada. Kulu nya-mangaji Na-ngawulu, jilu-yunduyundumanji Kada ngambalanga ngambala-wurdu, nya-mangaji Yijan nyangambalanga-biyi, ngambala nyamba-lhawarrmanthawu yiku, “Biyi! Wunyatha!” Nganinya barra ngambala, jambalini mirdan ngambala-wurdu, jambalini likili-ardu ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Namba jambalini wurrbi likili-ardu ki-Kada nganinya kulu kambalilu-ngundarra awara, kambalilu-ngundarra narnu-yabi barranamba kilu-ngunda narnu-yabi yiku ki-Jijaj Kurayij nyiki-arduwu. Ngaliwa yiwa ka-wani ankaya ki-awaralu ki-Kada, kilu-ngunda narnu-yabi ki-Kada, kulu kilu-ngundarra narnu-yabi ngambalanga marda, namba kambala-wingkayima yabi yilaa. Nungkarnarrku wabarrangu ka-wingka budijbudij awara yiku ki-Jijaj, rukurrinjarra yiku. Nungkarnarrku baku ka-wingkala budijbudij awara ngambalanga, rukurrinjarra awara marda. Namba kambala-wingkayima yabi yilaa bajarnaji, namba kambala-wingkayima...i yurrujurru yilaa baji ki-awarala nyungku-mangaji, kulu kilu-yabima la awara ngambalanga ki-Kada barranamba kilu-yabima awara yiku ki-Jijaj kulu kambalilu-ngundarra narnu-yabi narniku karanka barranamba kilu-ngunda yiku ki-Jijaj. ");
INSERT INTO jao_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kulu na-mangaji narnu-budijbudij ngambalanga marnaji, ngayamantharra buyi barra, waluku ngambalanga na-mangaji, ngala baku kambala-nama ngambala-lhungku ngambala-yurrngu, yabi kambala-nama nungkarnu-yabinja yilaa ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kulu jinangu awara wumba kilu-yabima ki-Yijandu ki-Kada, awara, janyka, wurnda, wanjirr, wunala, julaki, lhuwa, arlku, walya, yumbulyumbumantha wiji jibiya awara, jibiya wabuda, jibiya alibi, jinangu wiji, ja-yukumanji i...i, ja-yukumanji yiku ki-Kada baku ngaliwa kilu-yabimala awara, kalilu-mirnajimala li-wulu likili-ardu wiji, kalilu-yunduyundumala, “Li-ja lingathali-ardu marnajalu!” ");
INSERT INTO jao_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Nganinya ja-yukumanji i...i jinangu awara kangka awara marda ka-wardirri wankala. Kurdardi ka-wardirri awara yiwalumba, kurdardi, ngala minja ka-wardirri ngalawula kawula-arri rri-wardi. Ngalawula kawula-ngajbirri yiku ki-Kada Adam wula rra-Yiba, ngaliwa kilu-wardima awara wiji ki-Kada kulu ka-wardirri wakulamba, ka-wardirri awara yiku ki-jibiya awara, ki-jibiya wabuda, ki-jibiya alibi marda, yiku wiji. Ngala Kada, kilu-wardima buyi jinangu awara bakuwu bawuji, kurdardi na-yurrngu ngala minja kilu-yabimala jinangu awara marda baku. ");
INSERT INTO jao_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Kilu-yabimala jinangu awara yiku ki-jibiya wiji ngalingambala likili-ardu ki-Kada kambala-nama yurlurr li-yabi ngambala-yurrngu, ngaliwa awara marda kilu-yabimala ki-Kada, awara marda nmanthawu yabi barra na-yurrngu. ");
INSERT INTO jao_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Jambalini li-mirdan barra nyuwu-ja ki-awarawu, nganinya ja-yukumanji yabirrinjawu, wardimantha nganinya ja-yukumanji...i nambalu kilu-yabimala ki-Yijandu ki-Kada. ");
INSERT INTO jao_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ngambala marda, jambala-wardirrinji ngambala-wurdu yukumantharra yiku ki-Kada baku ngaliwa kilu-yabimala awara ngambalanga. Ambuliyalu kambalilu-ngunda ki-Kada, kambalilu-ngunda Na-ngawulu karanka nmanthawu ngambalaa, jinangu kambalilu-ngunda arrkula, marringaya. Kambalilu-ngunda Na-ngawulu kulu bajingu jambalini mirdan yiku ki-Kada, kambalilu-yangamala ngambala-manka, kambalilu-yangamala kambala-nama ngambalayirdi niyingambala-mankawu liyi-rdiyangu, kambalilu-ngundarra ngambala-manka li-rdiyangu. Kulu marningambala barra, jambala-wardirrinji ngambala-wurdu yukumantharra i...i bakuwu ngaliwa ki-Kada kambalilu-mirnajimala ngambala nmanthawu likili-ardu ngambala-yurrngu. ");
INSERT INTO jao_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","25","Ambuliyalu kambalamba-yibarra ngambala-wurdu yilaa ki-Jijaj kulu ki-Kada kambalilu-yibarra ngambala nmanthawu barranamba yurlurr yiku, kambalilu-maraka nganinya. Bajingu jambalamba-yabimanji ngambala-wurdu yuknmanthawu, jambala-yukumanji bakuwu wumba kumbi-nu yiwa yabimanthawu ngambalanga wayathantharra baku. Jambalini yukumantharra kangka aliyaliya kilu-yangamala awara ki-Kada, kurdardi kambala-nganjima na-mangaji narnu-rdiyangu wumba kambalili-nu ki-Kada, baku aliyaliya, kulu marningambala nyala yukumantharra, jambalamba-yabimanji ngambala-wurdu, ngambala yukumanthawu i...i yurrujurru bajinju. ");
INSERT INTO jao_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Kulu Na-ngawulu karanka, jambalilu-yabimanji ngalingambala jambalini li-barlkibarlki, li-barlkibarlki wingkayawu yurrujurru yilaa ki-Jijaj. Li-barlkibarlki jambalini li-manji yalbanganthawu ankaya, “Ngalhiyu kambala-yalbanganjima, ngalhiyu?” Ngala Na-ngawulu, yiwa barra kilu-yalbanganji Kada ankaya ngambalanga, kilu-yalbanganji kurdardi ki-wukawu, ja-rarrinji na-wurdu ngambalanga, nganinya kilu-yalbanganji. ");
INSERT INTO jao_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Kulu Wunyatha, jambalila-nykarrinji ngambala nyamba-wukanyinjarra ngambala-wurdu, jiwini nykarrinjarra wakulamba ngambalanga. Kulu yiwa, jila-nykarrinji Na-ngawulu ki-Kada, yiwa yalbanganthawu ngambalanga nganinya, rarrinjarra na-wurdu ngambalanga, jila-nykarrinji ki-Kada. Jiwini mirdan Nuwa-ngawuluwu ki-Kada wumba jiwini nyamba-nykalanykarrinjarra, jiwini mirdan yiku Kada, kangka wula barra Na-ngawulu ki-Kada jawula-ngayamanji ngalawula jawulamba-nykalanykarrinji ngambalanga, jawula-ngayamanji ngaliwa Na-ngawulu jilu-yalbanganji ngambalanga. ");
INSERT INTO jao_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nungkarnarrku narnu-dabudaburr, nungkarnarrku narnu-yabi, ngala ngambala jambalini li-mirdan yiku ki-Kada, yiwa jilu-yabimanji awara miyilmiyil, jilu-yabimanji awara ngambalanga liyi-wuluwu wumba jambala-manmarralanganji, ngambalanga liyi-wuluwu wumba kambalilu-ngalkingunda ngambala nmanthawu likungu, ngayangayarrinjawu yiku. ");
INSERT INTO jao_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Wankala barra Kada ka-arri mirdan ngambalanga ngalingambala aliyaliya kambala-nmala. Kambalilu-ngalkingunda, ngambala nmanthawu likungu, baji kambalilu-ngalkingunda yangamanthalu ngambala baku, baji ki-awarala ki-Kada ankangu, ngambala-manka kambala-nama barranamba nyiki-ardu Jijaj na-manka. Kulu mili kambalilu-ngalkingunda ngambala li-wulu nmanthawu likili-anyira ki-Jijaj, ngambala-miji, marda nalarrku li-wulu nalu-miji, kulu Jijaj jiwini nyangambalanga-baba nganinyanga barra. ");
INSERT INTO jao_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Kulu ngambala barra, li-mangaji wumba wankala kambalilu-ngalkingunda nmanthawu likungu, ka-wukanyi ngambalanga ngambala-wurdu, ngambala nyamba-yangamanthawu yilalu. Kulu ngambala wumba ka-wukanyi ngambalanga nyamba-yangamanthawu kambalilu-yibarra, ngambala nmanthawu barranamba yurlurr yiku. Kulu ngambala wumba kambalilu-yibarra nmanthawu barranamba yurlurr yiku, ngambalanga ka-arri, “Baku kirrirna-yangamala nirru-manka, yirru nmanthawu yabiwiji barranamba Jijaj na-manka yabiwiji, karna-ngayamala yirrunga, kalngiya karna-ngayamala,” nganinya ka-arri. Bawuji. ");
INSERT INTO jao_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Bajingu jambalini mirdan yiku ki-Kada, namba li-mbangu li-yinjatha kambalalu-ramanjama kulu kalinyamba-ayayanala, minja kalinyamba-ayayanala kangka Yijan Kada, nya-ngambalanga Yijan, jiwini wunungu alunga nuwalarrkulu wiji kulu kalilu-kadamala yiwa, ndiwa walkurrawala alunga wiji. ");
INSERT INTO jao_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Jinangu Yijan Kada, kurdardi kilu-ningumanma nyiki-ardu Jijaj wambu ankangu nungkarnu-yabinj a yurrngumantha, kurdardi kilu-ningumanma, ngala Jijaj ka-lhakanba karanka, ka-lhuwarri nakaringu nungkarnu-yabinja, nyungkiku-biyilu ki-Kada kili-ja karanka nyamba-mirranthalu ngambalanga. Namba kilu-ngunda nyiki-ardu arrkula ngambalanga ki-Kada, kulu kambalilu-ngulngundayanama awara marda, kambalilu-ngulngundayanama awara wiji, ngambala wingkayawu yabi yiku. ");
INSERT INTO jao_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","34","Kulu nganinju barra kili-nanjima Kada, nganinju kili-nanjima Kada ngambalanga, “Li-ja li-wulu li-wardimbangu, kalinyu-ramanjima!” Nganinju? Kurdardi yiku, kurdardi. Nungka Jijaj Kurayij barra, ka-wukanyinjima nganinya yiku ki-Kada ramanthawu ngambala? Waraba barra, kurdardi yiwa. Kangka yiwa Jijaj, kumba-mirra ngambalanga, kumba-mirra ngambalanga ngambala wingkayawu winarrku baku barni-ramantha. Kulu Kada, kili-ja karanka Jijaj nyamba-mirranthalu ngambalalu, kulu bajingu ki-Kada jambalilu-yibarranji nmanthawu barranamba yurlurr yiku. Bajuwarnu kurdardi kila-nykarriyu namba nyungku-mangaji kili-nanjima ramanthawu ngambala. Kulu Jijaj, kilu-lhungkuma ki-Kada kulu jiwini ankangu alarrinjarra baji yilaa ki-Kada, wirdiwalangu yilaa, kulu jilu-yalbanganji Kada yabimanthawu awara ngambalanga, kurdardi nanthawu ramanthawu. ");
INSERT INTO jao_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kulu nganinju kilu-yiwanjima ngambala, nganinju kilu-yiwanjima ngambala Jijaj Kurayij, yiwa wayathanthawu manmarralanganthawu ngambalanga, nganinju? Kurdardi yiku, kurdardi! Jambalilu-manmarralanganji na-yurrngu, kurdardi binjawu. Namba budijbudij awara ja-wingkayi kulu jambalilu-manmarralanganji. Namba jumba-rarrinji awara kulu jambalilu-manmarralanganji. Namba nungkalarrku jambalalu-mulamulanganji, jalu-wardimanji awara ngambalanga kulu jambalilu-manmarralanganji. Namba wirndajku awara ngambalanga, waraba mu-ngarranku, waraba ki-jumbalawu, kulu nyala bajiwa manmarralangantharra. Namba ladalada awara, namba wangarr awara, namba nyamba-arrkanantharra, nyamba-ramantharra, kulu nyala bajiwa manmarralangantharra. Jambalilu-manmarralanganji na-yurrngu, kurdardi binjawu. ");
INSERT INTO jao_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nungkarnarrku li-wulu, jalalu-mulamulanganji li-wulu likungu ki-Kada, jalu-mijanganji ramanthawu li-mangaji ki-Kada, kulu wankala nganambajilulu nalarrku, kalu-mijanganthaninya ramanthawu li-wulu likungu ki-Kada. Kilu-yibarra wuka yiku ki-Kada ki-arrkulangku ki-wankalangku, kilu-yibarra nganinya, “Nganu linkungu, Wirdiwalangu Kada. Kulu janalu-ramanji yurrngumantha, janalu-ramanji linji-wulungku kangka janini linkungu. Li-mangaji winkanda, janala-wunkananji barranamba jala-wunkananji jibi ngalalu jalu-rdumanji jibi kila ramanthawu.” Kilu-yibarra nganinya wankala. Kulu nganinyanga marda jalu-mijanganji ramanthawu li-wulu likungu ki-Kada nganinya, ngambala barra. ");
INSERT INTO jao_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ngala ngambala, ngalalu wardimantharra awara ngambalanga nganinya, jambalini li-wunungu alunga, jambalini li-wunungu ngambala-wurdu alunga, ngayamantharra buyi jalini ngambalanga marda. Jambalini wunungu ngambala-wurdulu, ngarra alunga kangka jambalilu-wunungumanji ngambala-wurdulu ki-Jijaj, jambalilu-wurdulungkayi nyungku-mangaji wumba jambalilu-manmarralanganji. ");
INSERT INTO jao_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kangka jarnini mirdan, jarnini mirdan yiku ki-Kada, jambalilu-manmarralanganji na-yurrngu, i...i barni-binjawu, ngala barnikilu-yangamarru nganinju, kambalilu-manmarralanganthanama i...i yurrngumantha. Jambalilu-manmarralanganji ngalingambala li-lhungku baki ngalingambala li-ngabangaku kambalilu-manmarralangala. Barnikalu-rrarru Wunyatha manmarralangantharra, waraba alunga liyi-jawinawu liyiku ankangu, waraba nyuwarrkulu nuwa-ngawuluwu ki-wirdiwalangu, waraba ngani baji. Barnikalu-rrarru Wunyatha ngala kambalilu-manmarralanganthanama i...i yurrngumantha i...i barnibinjawu. Jambalilu-manmarralanganji mili nganinyanga mili baku. Namba jilu-ngabiyanji awara, nyala bajiwa ngambalaa, nyala bajiwa manmarralangantharra miyilmiyil. Kulu ngabiya, narnu-wunungu nyuwarrkulu ki-yijanku ngabiyanthalu, marda narnu-wunungu alunga liyi-wuluwu liyi-wurrirriyu alunga liyi-ramanthamarawu, bajarnajiwuthu nuwarnu-wununguwu wiji, barnikilu-rrarru yiwa Kada, barnikilu-rrarru ngala jambalilu-manmarralanganji i...i yurrngumantha. ");
INSERT INTO jao_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Jambalilu-manmarralanganji ngalingambala ki-awarala akarru mili angula, nguthundu mili ngamala, ankangu mili wajka. Nya-mbangu, nya-mbangu wiji wumba ki-Yijandu ki-Kada kilu-yabima na-ngawulu wiji baki li-wulu, nya-mangajiwuthu wiji, barnikilu-rrarru Wunyatha manmarralanganthawu, ngala jambalilu-manmarralanganji i...i ki-Jijaj Kurayij, i...i yurrngumantha, jambalilu-manmarralanganji i...i ki-Kada, i...i yurrngumantha, kambalilu-manmarralanganthanama i...i miyilmiyil i...i yurrngumantha i...i barni-binjawu, nganinya jambalilu-manmarralanganji ki-Kada. Bawuji. ");
ALTER TABLE jao_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
