﻿USE sofia;
DROP TABLE IF EXISTS sofia.jae_vpl;
CREATE TABLE jae_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jae_vpl WRITE;
INSERT INTO jae_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Gêdêŋ ŋamatanô Anôtô kêkêŋ undambê to nom. ");
INSERT INTO jae_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nom tau sawa to ŋagêlêŋ ma ŋakesec kêkôm gwêc ŋamsêga auc ma Anôtônê Ŋalau kêlao gêmoa bu ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ma Anôtô kêsôm gebe “Ŋawê êsa”, e ŋawê kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Anôtô gêlic ŋawê gebe ŋajam. Ma Anôtô gêwa ŋawê to ŋakesec kêkôc. ");
INSERT INTO jae_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Anôtô kêsam ŋawê gebe “Geleŋŋa” ma ŋakesec gebe “Gêbêcauc.” Tec gêbêcauc to geleŋŋa tonaŋ kêtu bêc ŋamataŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Go Anôtô kêsôm gebe “Lênsaŋ teŋ êniŋ bu êŋgic ma êwa bu êkôc.” ");
INSERT INTO jae_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ma Anôtô kêmasaŋ lênsaŋ ma gêwa bu kêkôc, ŋagêdô kêpoac lênsaŋ ŋalabu ma ŋagêdô kêpoac ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma Anôtô kêsam lênsaŋ tau gebe “Umboŋ.” Gêbêcauc to geleŋŋa tonaŋ kêtu bêc kêtu luagêcŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Go Anôtô kêsôm gebe “Bu, taŋ kêpoac umboŋ ŋalabu naŋ, êlêc sa naêpoac tauŋa e gamêŋ ŋakeleŋ êsa.” Ma ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma Anôtô kêsam gamêŋ ŋakeleŋ gebe “Nom” ma bu ŋatoŋ gebe “Gwêc.” Ma Anôtô gêlic gebe ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Go Anôtô kêsôm gebe “Gêŋ êlêc ŋamatac aŋga nom, gêŋ tolauŋ taŋ êkêŋ ŋawê êtôm ŋakaiŋgeŋ naŋ, ma ka taŋ sênam ŋanô êtôm ŋakaiŋgeŋ naŋ.” Ma ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tec gêŋ gêlêc ŋamatac aŋga nom, gêŋ tolauŋ, taŋ kêkêŋ ŋawê kêtôm ŋakaiŋgeŋ naŋ ma ka taŋ sêjam ŋanô kêtôm ŋakaiŋgeŋ naŋ. Ma Anôtô gêlic gebe ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Gêbêcauc to geleŋŋa tonaŋ kêtu bêc kêtu têlêacŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Go Anôtô kêsôm gebe “Ja ŋanô sêkô umboŋ ŋalênsaŋ e sêwa geleŋŋa to gêbêcauc êkôc ma têtu têm to bêc ma jala ŋabelo. ");
INSERT INTO jae_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ma ja ŋanô sêkô umboŋ ŋalênsaŋ gebe sêpô nom ŋawê êsa.” Ma ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tec Anôtô kêkêŋ ja kapôêŋ luagêc, ja kapôêŋsêga teŋ gêjam gôliŋ geleŋŋa ma ec sauŋ teŋ gêjam gôliŋ gêbêcauc ma utitalata sêwiŋ. ");
INSERT INTO jae_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ma Anôtô kêkêŋ gêŋ tau sêkô umboŋ ŋalênsaŋ gebe sêpô nom ŋawê êsa, ");
INSERT INTO jae_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","gebe sênam gôliŋ geleŋŋa to gêbêcauc to sêwa ŋawê to ŋakesec êkôc. Ma Anôtô gêlic gebe ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Gêbêcauc to geleŋŋa tonaŋ kêtu bêc kêtu aclêŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Go Anôtô kêsôm gebe “Bu to gwêc sêkôc gêŋ mateŋ jaliŋa palac-palacgeŋ to moc sêlôp sêmoa nom to umboŋ ŋasawa,” e ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tec Anôtô kêkêŋ gêŋsêga gwêcŋa to gêŋ mateŋ jali samob, taŋ sêmoa bu to gwêc palac-palacgeŋ ma kêkêŋ moc tomagê tokaiŋ-tokaiŋ. Ma Anôtô gêlic gebe ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Go Anôtô gêjam mec êsêac ma kêsôm gebe “Asu ŋalatu ma atu taêsam e anam bu to gwêc auc ma moc têtu taêsam sêmoa nom.” ");
INSERT INTO jae_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Gêbêcauc to geleŋŋa tonaŋ kêtu bêc kêtu lemeŋ teŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Go Anôtô kêsôm gebe “Nom êkôc gêŋ mateŋ jali tokaiŋ-tokaiŋ, gêŋ masiŋ ma gêŋ, taŋ sêgalab to sêlêgeŋ naŋ ma bôc saleŋŋa tokaiŋ-tokaiŋ.” Ma ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tec Anôtô kêkêŋ bôc nomŋa tokaiŋ-tokaiŋ, gêŋ masiŋ tokaiŋ-tokaiŋ to gêŋ, taŋ sêgalab to sêlê naŋ, tokaiŋ-tokaiŋ. Ma Anôtô gêlic gebe ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Go Anôtô kêsôm gebe “Takêŋ ŋamalac têtôm aêac tauŋ katuŋ, têtôm aêac. Êsêac têtu i gwêcŋa to moc umboŋ ŋalabuŋa ma gêŋ masiŋ to bôc saleŋŋa samob ma gêŋ, taŋ sêgalab to sêlêgeŋ samob, taŋ sêmoa nom naŋ ŋatau.” ");
INSERT INTO jae_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ma Anôtô kêkêŋ ŋamalac kêtôm eŋ tau katu, kêkêŋ eŋ kêtôm Anôtô katu solop. Eŋ kêkêŋ êsêagêc ŋac to awê. ");
INSERT INTO jae_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma Anôtô gêjam mec êsêagêc ma kêsôm gêdêŋ êsêagêc gebe “Aka gôlôac lasê e atu taêsam ma anam nom auc. Nom êsô amac ŋalabu. Ma atu i gwêcŋa to moc umboŋ ŋalabuŋa ma gêŋ mateŋ jali samob, taŋ sêmoa nom naŋ, ŋatau.” ");
INSERT INTO jae_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma Anôtô kêsôm gebe “Alicgac, aê kakêŋ gêŋ tolauŋ samob taŋ kêkêŋ ŋawê kêtôm ŋakaiŋgeŋ naŋ to ka samob, taŋ sêjam ŋanô kêtôm ŋakaiŋgeŋ naŋ, tec kêtu amacnêm gêŋ aniŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mago gêgwaŋ to gêŋ matac ŋagêdô samob aê jakêŋ êndêŋ bôc nomŋa samob to êndêŋ moc umboŋ ŋalabuŋa samob ma gêŋ mateŋ jali samob, taŋ sêgalab to sêlê sêmoa nom naŋ.” Ma ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma Anôtô kêsala gêŋ samob, taŋ eŋ kêkêŋ naŋ, ma gêlic gebe ŋajamanô. Ma gêbêcauc to geleŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Amboac tonaŋ undambê to nom ŋagêŋ mateŋ jali totau-totau samob ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ma Anôtô gêjac dabiŋ nê koleŋ, taŋ gêjam su naŋ, gêdêŋ bêc lemeŋ teŋ ŋanô luagêcŋa ma kêlêwaŋ tau gêdêŋ bêc kêtu ŋanô luagêcŋa kêtu koleŋ samob, taŋ gêgôm naŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ma Anôtô gêjam mec bêc kêtu ŋanô luagêcŋa to gêjam dabuŋ, gebe gêdêŋ bêc tonaŋ Anôtô kêlêwaŋ tau aŋga nê koleŋ, taŋ gêjam e gêjac dabiŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Anôtô kêkêŋ undambê to nom ŋanô kêsa ŋamiŋ tau tonec. Gêdêŋ taŋ Apômtau Anôtô kêkêŋ nom to undambê ");
INSERT INTO jae_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","gêŋ tolauŋ teŋ kêpi atom to gêŋgaga teŋ kêkô kôm atom tageŋ gebe Apômtau Anôtô kêkêŋ kom kêsêp nom atom tageŋ. Ma ŋamalac teŋ gebe êŋgaluŋ nom popocŋa gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ma bu nom ŋalêlômŋa kêlêni mêŋkêpi ma kêmalôm nom ŋawambuc kêsa. ");
INSERT INTO jae_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Gêdêŋ tonaŋ Apômtau Anôtô kêkôc nom aŋga kôm ma kêlêsôb ŋamalac to gêju awajaô mata jaliŋa kêsô eŋ lususuŋ, tec ŋamalac kêtu gêŋ mata jali. ");
INSERT INTO jae_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Go Apômtau Anôtô kêsê kôm aŋga Eden, taŋ gêc gêmu kêsa gamêŋ oc kêpiŋa naŋ, ma ketoc ŋamalac, taŋ kêlêsôb naŋ, gêmoa kôm tau. ");
INSERT INTO jae_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma Apômtau Anôtô kêkêŋ ka kêpi aŋga nom, ŋakatu gêjac mataanô ŋajam ma ŋanô tau kêmoasiŋ awasuŋ. Ma ka daŋgôŋ mateŋ jaliŋa kêpi aŋga kôm ŋaluŋ to ka tajala ŋajam to secŋa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bu teŋ ŋamôkê gêc Eden gebe êmalôm kôm tau. Aŋga kôm ŋalêlôm bu tonaŋ gêwa tau kêkôc gêja ŋasêli aclê. ");
INSERT INTO jae_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ŋasêli ŋamata ŋaê gebe Pison. Bu tonaŋ kêgi gamêŋ Hawila, taŋ gold gêc naŋ, ");
INSERT INTO jae_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ma gamêŋ tonaŋ ŋagold ŋajamanô. Katêkwi toŋamalu ŋajam ŋaê gebe bedelium to pocawa kokoc ŋaê gebe soham gêc gamêŋ tonaŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Bu ŋasêli kêtu luagêcŋa ŋaê gebe Gihon. Bu tonaŋ kêgi gamêŋ Kus. ");
INSERT INTO jae_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Bu ŋasêli kêtu têlêcŋa ŋaê gebe Hidekel, naŋ kêpoac Asuria ŋagamêŋ oc kêpiŋa. Ma bu ŋasêli kêtu aclêŋa ŋaê gebe Euprat. ");
INSERT INTO jae_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Apômtau Anôtô kêkôc ŋamalac ma ketoc eŋ gêmoa kôm Eden gebe ênam kôm êpi nom ma ejop kôm tau. ");
INSERT INTO jae_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma Apômtau Anôtô kêjatu ŋamalac ma kêsôm gebe “Kaŋanô pebeŋ, taŋ kêkô kôm naŋ, ôniŋmaŋ. ");
INSERT INTO jae_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mago kaŋanô tajala ŋajam to secŋa ôniŋ atom. Embe ôniŋ kaŋanô tau, oc ômac êndu êndêŋ bêc tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Go Apômtau Anôtô kêsôm gebe “Ŋamalac taugeŋ êmoa oc ŋajam atom. Aê gabe jakêŋ kêpuctôŋo teŋ êndêŋ eŋ, taŋ êtôm eŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tec Apômtau Anôtô kêkôc nom ma kêmasaŋ bôc saleŋŋa samob to moc umboŋ ŋalabuŋa totau-totau ma kêkêŋ gêŋ tau gêdêŋ ŋamalac ma gebe êŋô ŋaê, taŋ ŋamalac ê êpi gêŋ totau-totau tonaŋ. Ma ŋaê, taŋ ŋamalac gê kêpi gêŋ totau-totau samob kêtômgeŋ naŋ, tec kêtu êsêacnêŋ ŋaê. ");
INSERT INTO jae_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ŋamalac gê bôc malacŋa samob nêŋ ŋaê to kêsam moc umboŋ ŋalabuŋa nêŋ ŋaê ma bôc saleŋŋa amboac tonaŋ, mago kêtap ŋamalacnê kêpuctôŋo teŋ gebe êtôm eŋŋa sa atom. ");
INSERT INTO jae_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tec Apômtau Anôtô gêgôm ŋamalac tau gêc bêc e kêliŋ tau siŋ ma kêkôc ênê ŋabi teŋ sa ma ŋamêsôm gêôc ŋamala auc. ");
INSERT INTO jae_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ŋabi taŋ Apômtau Anôtô kêkôc aŋga ŋamalacnê naŋ, eŋ kêmasaŋ kêtu awê ma kêkêŋ gêdêŋ ŋamalac. ");
INSERT INTO jae_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Go ŋamalac kêsôm gebe “Kecgoc, galoc katap ŋatêkwa aŋga aêŋoc sa ma ŋamêsôm aŋga aêŋoc amboac tonaŋ. Aê gabe jaê ênê ŋaê gebe ‘Ŋamalaco’ gebe sêkôc aŋga ŋamalacnê.” ");
INSERT INTO jae_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kêtu tonaŋŋa ŋamalac êwi tama agêc têna siŋ ma êsap nê awê tôŋ ma êsêagêc têtu ôli tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ma ŋaclagêco sêmoa ôliŋ ŋaôma ma majeŋ gêdêŋ tauŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ma moacnê kauc ŋagaô kêlêlêc bôc saleŋŋa ŋagêdô samob, taŋ Apômtau Anôtô kêkêŋ naŋ nêŋ su. Ma eŋ kêsôm gêdêŋ awê gebe “Anôtô oc kêsôm gebe ‘Aniŋ kôm ŋakaŋanô teŋ atom’ me.” ");
INSERT INTO jae_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Go awê kêsôm gêdêŋ moac gebe “Aêac aniŋ kôm ŋakaŋanô, ");
INSERT INTO jae_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tageŋ ka, taŋ kêkô kôm ŋaluŋ naŋ ŋanô, tec Anôtô kêsôm gebe ‘Aniŋ atom. Amoasac atom amboac tonaŋ gebe amac êndu atom.” ’ ");
INSERT INTO jae_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tec moac kêsôm gêdêŋ awê gebe “Op, agêc oc amac êndu atomgoc. ");
INSERT INTO jae_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mago Anôtô kêjala gebe amagêc embe aniŋ, go matemanô êpoa lasê ma atôm eŋ tau ma ajala ŋajam to sec.” ");
INSERT INTO jae_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ma awê gêlic kaŋanô ma taê gêjam gebe ŋalêwê ŋajam e gêjac mataanô ŋajam amboac tonaŋgeŋ. Tec têtac gêboaŋ gebe êwa nê kauc sa ma kêkôc kaŋanô tau mêŋgeŋ, go kêkêŋ ŋagêdô gêdêŋ nê akweŋ amboac tonaŋ, ma geŋ. ");
INSERT INTO jae_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tec agêc mateŋanô kêpoa lasê ma sêjala tauŋ gebe ôliŋ ŋaôma, tec sêgiŋ kalauŋ mêŋsêkic kêtu nêŋ ladôm. ");
INSERT INTO jae_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Oc kêtu luc acgom, go Apômtau Anôtô kêsêlêŋ gêmoa kômlêlôm. Agêc sêŋô eŋ ma ŋamalac agêc nê awê sêsiŋ tauŋ sêsô ka, taŋ sêkô kôm naŋ, ŋalabu gebe Apômtau Anôtô êlic êsêagêc atom. ");
INSERT INTO jae_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Go Apômtau Anôtô gêmôêc ŋamalac ma kêsôm gêdêŋ eŋ gebe “Gômoa ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Eŋ kêsôm gebe “Aê gaŋô aôm gômoa kôm ŋakicsêa e katêc tauc gebe aê ôlic ŋaôma tec kasiŋ tauc.” ");
INSERT INTO jae_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Go Anôtô kêsôm gebe “Asa kêsôm gêdêŋ aôm gebe ôlim ŋaôma. Aôm goeŋ kaŋanô, taŋ gajac jao gêdêŋ aôm gebe ôniŋ atom naŋ, me masi.” ");
INSERT INTO jae_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ŋamalac kêsôm gebe “Awê, taŋ kôkêŋ gebe êwiŋ aê naŋ, kêkêŋ kaŋanô tau gêdêŋ aê, tec gaeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Go Apômtau Anôtô kêsôm gêdêŋ awê gebe “Aôm gôgôm asageŋ tonaŋ.” Awê gêjô eŋ awa gebe “Moac kêtim aê, tec gaeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ma Apômtau Anôtô kêsôm gêdêŋ moac gebe “Aôm gôgôm tonaŋ, tec japuc boa aôm êlêlêc bôc malacŋa to bôc saleŋŋa samob su. Aôm ôkêŋ ŋa têmtac walôgeŋ ma ôniŋ kekop e ômac êndu. ");
INSERT INTO jae_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma aê gabe jakêŋ amagêc awê to nêm wakuc akêŋ kisa êndêŋ taôm. Eŋ êka aôm môkêmapac popoc ma aôm ôŋac eŋ êsêp agêbi.” ");
INSERT INTO jae_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Eŋ kêsôm gêdêŋ awê gebe “Aê jakêŋ ŋandaŋ taêsam êndêŋ aôm êndêŋ noc ôkêkam ŋapalêŋa. Ôkôc ŋapalê toŋandaŋgeŋ. Aôm matam katu nêm akweŋ, mago eŋ êtu nêm ŋatau.” ");
INSERT INTO jae_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ma eŋ kêsôm gêdêŋ Adam gebe “Aôm kôkêŋ taŋam nêm awênê biŋ ma goeŋ ka ŋanô, taŋ gajac jao gêdêŋ aôm gebe ôniŋ atom naŋ. Kêtu tonaŋŋa aê japuc boa nom êtu aômŋa. Ônam kôm ôim taôm sugeŋ êtôm bêc samob, taŋ ômoa naŋ, go nom êlôm aôm. ");
INSERT INTO jae_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Gêŋ têkwa-têkwa to waôŋ êtu nêm kôm ŋanô ma ôniŋ ŋagêŋgaga. ");
INSERT INTO jae_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ônam kôm towaeŋgeŋ, go ôtap mo sa e ôtu nom êtiam gebe aômnêm ŋam gêc nom. Aôm nom, tec ômu ôndêŋ nom ôna êtiam. ");
INSERT INTO jae_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ma ŋamalac gê nê awênê ŋaê gebe Ewa gebe eŋ kêtu lau mateŋ jali samob teneŋi. ");
INSERT INTO jae_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma Apômtau Anôtô kêmasaŋ bôc ŋaôlic kêtu ŋakwê ma kêkêŋ gêdêŋ ŋamalac agêc nê awê sêsô. ");
INSERT INTO jae_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ma Apômtau Anôtô kêsôm gebe “Alic acgom, ŋamalac kêtôm aêac ma kêjala ŋajam to sec. Galoc tec tajop eŋ gebe êmêtôc lêma naêpip kaŋanô aŋga ka daŋgôŋ mateŋ jaliŋa ma êniŋ e êmoa teŋgeŋ nec atom.” ");
INSERT INTO jae_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kêtu tonaŋŋa Apômtau Anôtô kêtiŋ eŋ su aŋga kôm Eden gebe êkaliŋ nom, taŋ kêtu ênê ŋam naŋ. ");
INSERT INTO jae_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ma eŋ kêmasuc ŋamalac ma kêkêŋ kerub tosiŋ ŋaôsic-ôsic sêkô kôm Eden ŋagamêŋ oc kêpiŋa gebe sejop ka daŋgôŋ mateŋ jaliŋa ŋaintêna. ");
INSERT INTO jae_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam gêmoa gêwiŋ nê awê Ewa e taê ma kêkôc Kain. Ma eŋ kêsôm gebe” Apômtau gêjam aê sa, tec kakôc latuc teŋ.” ");
INSERT INTO jae_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ma kêkôc ŋapalê teŋ kêtiam, lasi Abel. Abel kêtu gejobwaga bôcŋa ma Kain gêjam kôm moŋa. ");
INSERT INTO jae_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Têm ŋagêdô gêjaŋa, tec Kain kêkôc nê kôm ŋanô kêkêŋ kêtu da gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Abel kêkôc bôc teŋ aŋga nê bôc tau ŋamêcgeŋ, gêjac endu ma kêkêŋ ŋalêsi kêtu da. Ma Apômtau gêlic Abel to nê da ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mago gêlic Kain to nê da atom. Tec Kain têtac ŋandaŋ kêsa to laŋôanô kêbêlê. ");
INSERT INTO jae_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Apômtau kêsôm gêdêŋ Kain gebe “Aôm têmtac ŋandaŋ to laŋômanô kêbêlê kêtu asageŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Biŋ tau amboac tonec me masi gebe Aôm embe ôŋgôm êndêŋ, go ôsa laŋômanô sa. Embe ôŋgôm eso, go sec êndib aôm ênêc katamdêmôê. Sec mata katu aôm, mago aôm ôku sec tulumaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Go Kain kêsôm gêdêŋ lasi Abel gebe “Tana kôm.” Agêc sêô lasê kôm su, go Kainnê ŋalêlôm gêli sa ma gêjac lasi Abel êndu. ");
INSERT INTO jae_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Go Apômtau kêsôm gêdêŋ Kain gebe “Lasim Abel gêmoa ondoc.” Eŋ kêsôm gebe “Aê gajam kauc. Aê katu lasicnê gejobwaga me.” ");
INSERT INTO jae_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma Apômtau kêsôm gebe “Aôm gôgôm asageŋ. Lasimnê dec awa gêmôêc aŋga nom kêpi gêdêŋ aê gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ma galoc aê japuc boa aôm aŋga nom, taŋ gêŋa awasuŋ ma gênôm lasimnê dec aŋga aôm lêmam naŋ. ");
INSERT INTO jae_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Aôm embe ônam kôm, go êŋgamiŋ ŋanô êndêŋ aôm. Matam kanôŋ ôsêlêŋ ôŋôŋgeŋ ônac laoc gamêŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Kain kêsôm gêdêŋ Apômtau gebe “Ŋoc keso ŋagêjô kapôêŋ kêlêlêc ôlicwalô su. ");
INSERT INTO jae_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Gôlicgac me, galoc aôm kôtiŋ aê su aŋga nom ma jasiŋ tauc ôkwi aŋga laŋômnêmŋa. Matoc kanôŋ jasêlêŋ ôŋôŋgeŋ janac laoc gamêŋgeŋ ma lau, taŋ têtap aê sa naŋ, sênac aê êndu.” ");
INSERT INTO jae_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mago Apômtau kêsôm gêdêŋ eŋ gebe “Amboac tonaŋ atom. Teŋ embe ênac Kain êndu, naŋ êtap ŋagêjô êtôm dim 7ŋa sa.” Ma Apômtau kêkêŋ ŋabelo teŋ gêdêŋ Kain gebe ŋac teŋ embe êtap eŋ sa, naŋ ênac eŋ êndu atom. ");
INSERT INTO jae_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Amboac tonaŋ Kain kêtaiŋ tau su aŋga Apômtau laŋônêmŋa gêmoa gamêŋ Nod, taŋ gêc Eden ŋagamêŋ oc kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain gêmoa gêwiŋ nê awê e taê ma kêkôc Enok. Ma Kain kêkwê malac teŋ sa ma eŋ gê latu Enoknê ŋaê kêpi malac tau. ");
INSERT INTO jae_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok latu Irad, Irad kêka Mehujael lasê, Mehujael kêka Metusael lasê ma Metusael kêka Lamek lasê. ");
INSERT INTO jae_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ma Lamek gêjam awê luagêc, teŋ nê ŋaê gebe Ada ma teŋ nê ŋaê gebe Sila. ");
INSERT INTO jae_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada kêkôc Jabal. Eŋ kêtu lau, taŋ sêŋgôŋ becobo to sêmoa sêwiŋ nêŋ bôc naŋ, nêŋ mimi. ");
INSERT INTO jae_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Lasi ŋaê gebe Jubal. Eŋ kêtu lau, taŋ sêjac gêŋ wêŋa to lau-sêju-gasucwaga nêŋ mimi. ");
INSERT INTO jae_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma Sila kêkôc gôlôac amboac tonaŋ, ênê ŋaê gebe Tubal-Kain. Eŋ kêtu lau-sêpac-kiwaga, taŋ sêmasaŋ gêŋ ŋa ki kokoc to jejec naŋ, nêŋ mimi. Tubal-Kain luo Nama. ");
INSERT INTO jae_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma Lamek kêsôm gêdêŋ nê awê luagêc gebe “Ada agêc Sila, aŋô aê aoc. Lameknê awêlagêc, akêŋ taŋem ŋoc biŋ. Biŋŋanô, aê gajac ŋac teŋ êndu gêjô ŋoc kamoc ma ŋapalê teŋ gêjô ŋoc sêmmala. ");
INSERT INTO jae_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Teŋ embe ênac Kain êndu, oc sêkêŋ ŋagêjô êtôm dim 7ŋa. Mago teŋ embe ênac aê, Lamek, nec êndu, oc sêkêŋ ŋagêjô êtôm dim 77ŋa.” ");
INSERT INTO jae_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ma Adam gêmoa gêwiŋ nê awê kêtiam ma eŋ kêkôc latu teŋ, taŋ kêsam eŋ gebe Set, ŋam gebe “Anôtô kêkêŋ latuc teŋ gêdêŋ aê gêjô Abel, taŋ Kain gêjac eŋ êndu naŋ su.” ");
INSERT INTO jae_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ma Set kêka latu teŋ lasê ma gê eŋ gebe Enos. Gêdêŋ têm tonaŋ lau aweŋ gêjac Apômtau kêtu ŋamata. ");
INSERT INTO jae_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamnê wakucnêŋ ŋadênaŋ tau tonec. Gêdêŋ taŋ Anôtô kêkêŋ Adam naŋ, kêkêŋ eŋ kêtôm eŋ tau. ");
INSERT INTO jae_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Eŋ kêkêŋ êsêagêc ŋac to awê ma gêjam mec êsêagêc. Ma gêdêŋ eŋ kêkêŋ êsêagêc naŋ kêsam êsêagêc gebe “Ŋamalac.” ");
INSERT INTO jae_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Gêdêŋ taŋ Adamnê jala kêtu 130 naŋ, kêka latu teŋ lasê kêtôm eŋ ma kêtôm eŋ tau katu ma gê ênê ŋaê gebe Set. ");
INSERT INTO jae_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ma Adam kêka Set lasê su acgom, go gêmoa nom jala 800 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamnê jala kêtu 930, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Gêdêŋ taŋ Setnê jala kêtu 105 naŋ, kêka latu Enos lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Eŋ kêka Enos lasê su acgom, go gêmoa nom jala 807 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Amboac tonaŋ Setnê jala kêtu 912, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Gêdêŋ taŋ Enosnê jala kêtu 90 naŋ, kêka Kenan lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Eŋ kêka Kenan lasê su acgom, go gêmoa nom jala 815 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Amboac tonaŋ Enosnê jala kêtu 905, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Gêdêŋ taŋ Kenannê jala kêtu 70 naŋ, kêka Mahalalel lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Eŋ kêka Mahalalel lasê su acgom, go gêmoa nom jala 840 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Amboac tonaŋ Kenannê jala kêtu 910, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Gêdêŋ taŋ Mahalalelnê jala kêtu 65 naŋ, kêka Jared lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Eŋ kêka Jared lasê su acgom, go gêmoa nom jala 830 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Amboac tonaŋ Mahalalelnê jala kêtu 895, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Gêdêŋ taŋ Jarednê jala kêtu 162 naŋ, kêka Enok lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared kêka Enok lasê su acgom, go gêmoa nom jala 800 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Amboac tonaŋ Jarednê jala kêtu 962, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Gêdêŋ taŋ Enoknê jala kêtu 65 naŋ, kêka Metusala lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok kêsa nê lêŋ to Anôtôgeŋ ma kêka Metusala lasê su acgom, go gêmoa nom jala 300 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Amboac tonaŋ Enoknê jala kêtu 365. ");
INSERT INTO jae_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok kêsa nê lêŋ to Anôtôgeŋ e laŋômê gebe Anôtô kêkôc eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Gêdêŋ taŋ Metusalanê jala kêtu 187 naŋ, kêka Lamek lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusala kêka Lamek lasê su acgom, go gêmoa nom jala 782 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Amboac tonaŋ Metusalanê jala kêtu 969, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Gêdêŋ taŋ Lameknê jala kêtu 182 naŋ, kêka latu teŋ lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Eŋ gê ênê ŋaê gebe Noa ma kêsôm gebe “Ŋac tonec ênam aêac kêsi aŋga nêŋ koleŋ to gêŋwapac, taŋ kêtap aêac lemeŋ sa kêtu kôm, taŋ Apômtau kêpuc boa naŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek kêka Noa lasê su acgom, go gêmoa nom jala 595 gêwiŋ ma kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Amboac tonaŋ Lameknê jala kêtu 777, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Gêdêŋ taŋ Noanê jala kêtu 500 naŋ, kêka Sem agêc Ham ma Japet lasê. ");
INSERT INTO jae_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Gêdêŋ taŋ ŋamalac sêjac m gebe têtu taêsam aŋga nom naŋ, sêka latuŋio lasê, ");
INSERT INTO jae_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ma lau undambêŋa sêlic ŋamalac latuŋio gebe ŋajam, tec sêjaliŋ nêŋ lauo sa aŋga êsêacnêŋ ma sêjam. ");
INSERT INTO jae_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Go Apômtau kêsôm gebe “Aêŋoc Ŋalau êmoa êwiŋ ŋamalac endeŋ tôŋgeŋ atom gebe eŋ toôli nomŋa tec ênê jala êtôm 120geŋ.” ");
INSERT INTO jae_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Gêdêŋ têm, taŋ lau undambêŋa sêjam ŋamalac latuŋio e êsêac sêkôc ŋapalê naŋ, lau waso-waso kaiŋ teŋ sêmoa nom. Ma gêdêŋ têm, taŋ kêdaguc naŋ, amboac tonaŋgeŋ. Lau ŋaclai towae têm andaŋgeŋanôŋa tau tonec. ");
INSERT INTO jae_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Apômtau gêlic gebe ŋamalacnêŋ sec gêjam sêga aŋga nom ma êsêac sêlao kêtu biŋ secŋa ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ma Apômtau geŋ oliŋ gebe kêkêŋ ŋamalac sêmoa nom wageŋ e nê ŋalêlôm ŋawapacgosu. ");
INSERT INTO jae_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tec Apômtau kêsôm gebe “Aê gabe janseŋ ŋamalac, taŋ kakêŋ naŋ, su aŋga nom, ŋamalac to bôc ma gêŋ, taŋ sêgalabgeŋ naŋ, to moc umboŋ ŋalabuŋa gebe aêŋoc ŋalêlôm ŋawapac kêtu gaim tauc su ŋaômageŋ kêtu êsêacŋa.” ");
INSERT INTO jae_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mago Noa gêjac Apômtau mataanô ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noanê miŋ tau tonec gebe Noa eŋ ŋac gêdêŋ, biŋ teŋ kêtap eŋ sa aŋga nê lau ŋalêlôm atom. Eŋ kêsa nê lêŋ toAnôtôgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ma Noa kêka ŋapaŋ têlêac lasê, Sem agêc Ham ma Japet. ");
INSERT INTO jae_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mago Anôtô gêlic nom kêtu sec sugac ma biŋ alôb-alôb gêjam nom auc. ");
INSERT INTO jae_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ma Anôtô kêtuc kêniŋ nom ma gêlic gebe sec gêjam aucgeŋ gebe gêŋ mateŋ jali samob aŋga nom sêsa lêŋ secgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ma Anôtô kêsôm gêdêŋ Noa gebe “Aê taêc gêjam kêtu tôŋ gebe janac gêŋ mateŋ jali samob nêŋ lêŋ pep tageŋ gebe ŋamalacnêŋ biŋ alôb-alôb gêjam nom samucgeŋ auc. Kêtu tonaŋŋa aê gabe janseŋ êsêac tonomgeŋ su sênaŋa. ");
INSERT INTO jae_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ônsô waŋ kapôêŋ teŋ ŋa ka balaŋ. Ômansaŋ tobalêm-tobalêm ma opeŋ sip aŋga dêmôêŋa to lêlômŋa. ");
INSERT INTO jae_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ônsô waŋ tau amboac tonec gebe ŋalêsiŋ baliŋ amboac saka 60, takôcŋa amboac saka 10 ma ŋaô amboac saka 6. ");
INSERT INTO jae_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ômansaŋ waŋ tau ŋasalôm ma katam kapôêŋ ênêc lêsiŋŋa. Ôwa ŋalêlôm êkôc êna deŋ têlêac, deŋ ŋalabuŋa to deŋ êtu luagêcŋa ma deŋ êtu têlêacŋa. ");
INSERT INTO jae_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Gôlicgac me, galoc aê jakêŋ bu êsuŋ ŋatêna êpoac nom gebe janseŋ gêŋ mateŋ jali samob, taŋ sêwê kaiŋ awajaô mata jali aŋga umboŋ ŋalabu naŋ, su sênaŋa, gêŋ nomŋa samob sêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mago aê gabe jamoatiŋ ŋoc poac êndêŋ aôm. Amboac tonaŋ ôsô waŋ ŋalêlôm ôna, aôm taôm to latômi ma nêm awê to lawamio wakuc sêwiŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ma bôc samob to gêŋ mateŋ jali tokaiŋ-tokaiŋ naŋ, ôkêŋ luagêc-luagêc sêsô waŋ sêna gebe sêmoa mateŋ jali sêwiŋ aôm, ôkêŋ kapoac teŋ ma têna teŋ. ");
INSERT INTO jae_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Moc tokaiŋ-tokaiŋ ma gêŋ, taŋ sêgalabgeŋ naŋ, tokaiŋ-tokaiŋ ŋaluagêc-luagêc sêsô waŋ sêna sêwiŋ aôm gebe sêmoa mateŋ jali. ");
INSERT INTO jae_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma aôm ônac gêŋ taniŋŋa tokaiŋ-tokaiŋ sa, gebe êpuc aôm to êsêac samob tôŋ.” ");
INSERT INTO jae_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma Noa gêgôm gêŋ samob. Eŋ gêgôm kêtôm Anôtô kêjatu eŋ naŋ solopgeŋ. gebe “Ênam sa,” ma ");
INSERT INTO jae_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Go Apômtau kêsôm gêdêŋ Noa gebe “Ôsô waŋ ôna, aôm to nêm gôlôac samob gebe aê galic aôm amboac ŋac gêdêŋ gômoa aê laŋôcnêm aŋga lau tonaŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ôkôc bôc 7-7 aŋga bôc selec samob nêŋ, kapoac to têna. Mago ôkôc bôc luagêc-luagêc aŋga bôc, taŋ selec atom naŋ, kapoac teŋ ma têna teŋ. ");
INSERT INTO jae_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Moc umboŋ ŋalabuŋa amboac tonaŋ. Ôkôc 7-7 êtômgeŋ, kapoac to têna gebe sênac ŋawê tôŋ aŋga nom. ");
INSERT INTO jae_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gebe bêc 7 ênaŋa acgom, go jakêŋ kom ênac êtôm eleŋŋa 40 to êmbêcauc 40 ma gabe janseŋ gêŋ mateŋ jali samob, taŋ kakêŋ naŋ, su aŋga nom.” ");
INSERT INTO jae_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma Noa gêgôm gêŋ samob ŋanô kêsa kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noanê jala kêtu 600, go bu kêsuŋ ŋatêna kêtap nom sa. ");
INSERT INTO jae_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ma Noa to latui ma nê awê to lawaio wakuc sêsô waŋ sêja gebe sêc bu su. ");
INSERT INTO jae_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Bôc selec to bôc selec atom ma moc to gêŋ, taŋ sêgalabgeŋ naŋ, aŋga nom samob, ");
INSERT INTO jae_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kapoac teŋ to têna teŋ sêsô waŋ sêwiŋ Noa kêtôm Anôtô kêjatu naŋ. ");
INSERT INTO jae_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bêc 7 gêjaŋa, go bu kêsuŋ ŋatêna kêtap nom sa. ");
INSERT INTO jae_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Gêdêŋ taŋ Noanê jala kêtu 600 naajôŋ luagêc ma ŋabêc 17 naŋ, bumata nom ŋalêlômŋa samob kêpulu kêpi ma katam umboŋŋa gêlêc su ");
INSERT INTO jae_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ma kom kêsêwa kêsêp nom geleŋŋa 40 to gêbêcauc 40. ");
INSERT INTO jae_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Gêdêŋ bêc tonaŋ Noa to latui Sem agêc Ham ma Japet ma nê awê to lawaio wakuc têlêac sêwiŋ êsêac sêsô waŋ sêja. ");
INSERT INTO jae_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Êsêac ma bôc saleŋŋa tokaiŋ-tokaiŋ to bôc malacŋa tokaiŋ-tokaiŋ ma gêŋ, taŋ sêgalabgeŋ aŋga nom samob tokaiŋ-tokaiŋ to moc tokaiŋ-tokaiŋ, moc to gêŋ tomagê samob, ");
INSERT INTO jae_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","gêŋ samob tonaŋ ŋai sêsô waŋ sêwiŋ Noa, gêŋ mateŋ jaliŋa luagêc-luagêc. ");
INSERT INTO jae_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Gêŋ mateŋ jaliŋa samob, kapoac teŋ to têna teŋ sêsô waŋ kêtôm Anôtô kêjatu eŋ. Ma Apômtau kêlai eŋ auc. ");
INSERT INTO jae_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bu kêsuŋ ŋatêna kêpoac nom gê tôŋgeŋ kêtôm bêc 40 ma bu kêsuŋ kapôêŋ ma kêsuŋ waŋ sa kêpigeŋ jakêpoac. ");
INSERT INTO jae_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma bu kêsuŋ kêpi-kêpi e gêjam sêga aŋga nom ma waŋ kêpoac bu ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Bu kêsuŋ ŋatêna e gênôm lôc baliŋ, taŋ kêkô umboŋ ŋalabu naŋ auc samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bu taŋ gênôm lôc ŋatêpôê auc naŋ e amboac saka samuc têlêac. ");
INSERT INTO jae_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tec gêŋ mateŋ jali, taŋ sêmoa nom naŋ, samob sêjaŋa, moc ma bôc malacŋa to bôc saleŋŋa ma gêŋ samob, taŋ sêgalab to sêlêgeŋ sêjam nom auc naŋ, ma ŋamalac amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Gêŋ samob, taŋ sêsê aweŋ sêmoa masaŋgeŋ naŋ, sêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Amboac tonaŋ geseŋ gêŋ mateŋ jali, taŋ sêmoa nom naŋ su samob, ŋamalac to bôc ma gêŋ, taŋ sêgalab to sêlêgeŋ naŋ to moc aŋga umboŋ ŋalabu samobgeŋ sêjaŋa aŋga nom. Noa taugeŋ gêmoa to êsêac, taŋ sêwiŋ eŋ sêmoa waŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma bu kêsuŋ ŋatêna kêpoac nom kêtôm bêc 150. luagêc. Toŋ teŋ tec sêsam gebe Bôc selec, ma teŋ sesam gebe Bôc ŋatêmui. Bôc selec nêŋ ŋagêdô gebe domba to bulimakao. Bôc tonaŋ êsêac sêkêŋ têtu da, ma bôc selec tonaŋgeŋ êsêac seŋ kêtu nêŋ gwada. Bôc ŋatêmui amboac bôc susu êsêac sên atom ma sêkêŋ têtu da atom. ");
INSERT INTO jae_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma Anôtô taê gêjam Noa ma bôc saleŋŋa to malacŋa, taŋ sêmoa sêwiŋ eŋ sêmoa waŋ ŋalêlôm naŋ. Ma Anôtô kêkêŋ mu kêsêlêŋ aŋga nom ma bu tau kêtaiŋ su. ");
INSERT INTO jae_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ma bumata nom ŋalêlômŋa to katam umboŋŋa ŋajaŋa kêsa. Kom gêjac kêtiam atom ");
INSERT INTO jae_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ma bu kêtaiŋ su aŋga nom. Bu kêpoac bêc 150, go kêtaiŋ su ");
INSERT INTO jae_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ma gêdêŋ ajôŋ kêtu 7ŋa ŋabêc 17 waŋ jagêlôc lôc Ararat. ");
INSERT INTO jae_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bu kêtaiŋ-kêtaiŋ e gêdêŋ ajôŋ kêtu 10ŋa. Gêdêŋ ajôŋ tonaŋ ŋabêc ŋamataŋa lôc ŋagêdô ŋatêpôê mêŋkêpi. ");
INSERT INTO jae_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bêc 40 gêjaŋa, go Noa gêlêc waŋ ŋakatam sauŋ, taŋ eŋ kêmasaŋ naŋ, su ");
INSERT INTO jae_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ma kêkêŋ aoco teŋ gêlôb kêsa gêja. Moc tonaŋ gêlôb gêja-gêmu, gêja-gêmu e bu kêpa aŋga nom. ");
INSERT INTO jae_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ma Noa kêsaê e bêc 7, go kêkêŋ balôsi teŋ gêlôb kêsa gêja gebe êlic bu oc kêtaiŋ su aŋga nom me masi. ");
INSERT INTO jae_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mago balôsi kêtap ŋamala êlêwaŋ tauŋa teŋ sa atom, tec gêlôb gêmu gêdêŋ eŋ gêja kêtiam, gebe bu gacgeŋ kêpoac gêjam nom samucgeŋ auc. Tec eŋ kêmêtôc lêma kêsa jakêkôc moc kêsô waŋ ŋalêlôm gêja gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Go kêsaê bêc 7 kêtiam, go kêkêŋ balôsi tau gêlôb kêsa gêja kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Gêdêŋ kêtulala moc gêmu gêdêŋ eŋ gêmêŋ ma keseŋeŋ katêkwi ŋalauŋ matac teŋ. Gêdêŋ tonaŋ Noa kêjala gebe bu kêtaiŋ su aŋga nom. ");
INSERT INTO jae_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Eŋ kêsaê bêc 7 kêtiam ma kêkêŋ balôsi gêlôb kêsa gêja, mago gêmu gêdêŋ eŋ gêmêŋ kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Gêdêŋ taŋ Noanê jala kêtu 601 ŋaajôŋ ŋamataŋa ŋabêc ŋamataŋa naŋ, bu kêpa aŋga nom. Tec Noa kêkac waŋ ŋasalôm su e gêlic nom ŋakeleŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Gêdêŋ ajôŋ kêtu luagêcŋa ŋabêc 27 nom ŋakeleŋ kêsa samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Go Anôtô kêsôm gêdêŋ Noa gebe ");
INSERT INTO jae_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ôwi waŋ siŋ ôsa ôna, amagêc nêm awê ma latômi to lawamio wakuc sêwiŋ aôm, ");
INSERT INTO jae_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ma bôc samob, taŋ sêwiŋ aôm naŋ, gêŋ mateŋ jaliŋa samob, moc to bôc ma gêŋ, taŋ sêgalabgeŋ sêmoa nom naŋ, samob, ôwi êsêac siŋ sêwiŋ aôm asa ana gebe seola nom auc ma sêsu ŋalatu e têtu taêsam aŋga nom.” ");
INSERT INTO jae_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ma Noa gêwiŋ nê latui to nê awê ma lawaio wakuc sêsa sêja ");
INSERT INTO jae_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ma bôc saleŋŋa to malacŋa samob, moc samob to gêŋ, taŋ sêgalabgeŋ sêmoa nom naŋ, samob tokaiŋ-tokaiŋ sêsa aŋga waŋ sêja. ");
INSERT INTO jae_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ma Noa gêboa Apômtaunê altar teŋ sa ma kêkôc bôc selec ŋagêdô to moc selec ŋagêdô ma kêkêŋ kêtu daja gêsac altar ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma Apômtau gêŋu ŋamalu ŋajam ma kêsôm gêdêŋ tau gebe “Aê gabe japuc boa nom êtu ŋamalacŋa êtiam atomanô gebe ŋamalacnêŋ geo ŋapalêgeŋŋa tec gêc. Aê gabe janseŋ gêŋ mateŋ jali êtiam amboac gagôm su nê atom. ");
INSERT INTO jae_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Êtôm nom ŋatêm samob sêsê ŋawê ma sejoŋ ŋanô, malô to ŋandaŋ, ocêsa to komô, eleŋ to êmbêc êjô tau êjô tau.” ");
INSERT INTO jae_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ma Anôtô gêjam mec Noa to nê latui ma kêsôm gêdêŋ êsêac gebe “Aka gôlôac lasê e atu taêsam ma anam nom auc. ");
INSERT INTO jae_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mago bôc nomŋa samob to moc umboŋ ŋalabuŋa samob ma gêŋ mateŋ jali, taŋ sêgalabgeŋ sêmoa nom naŋ, samob to i samob, taŋ sêmoa gwêc naŋ, têtêc amac to mateŋ golec êsa. Ma aê kakêŋ êsêac sêsêp amac lemem. ");
INSERT INTO jae_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gêŋ mateŋ jaliŋa samob, taŋ sêmoa naŋ, têtu amacnêm gêŋ aniŋŋa. Aê kakêŋ gêŋ tolauŋ gêdêŋ amac su, tec gêŋ ŋagêdô samob amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tageŋ aniŋ bôc ŋamêsôm tonê katugeŋ atom. Bôcnê katu tau gebe dec. ");
INSERT INTO jae_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Êtu amac taôm nêm decŋa aê jaê biŋ ŋagêjôŋa tôŋ. Aê jaê biŋ ŋagêjôŋa tôŋ êpi bôc samob ma êpi ŋamalac. Aê jaê ŋamalacnêŋ katuŋ ŋabiŋ ŋagêjôŋa tôŋ êpi lau samob nêŋ lasitêwai amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Teŋ embe êkêc ŋamalacnêŋ dec siŋ, naŋ ŋamalac sêkêc ênê dec siŋ êjô, gebe Anôtô kêkêŋ ŋamalac kêtôm tau katu. ");
INSERT INTO jae_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Amac tec aka gôlôac lasê to atu taêsam anam nom auc to atu nom ŋatau.” ");
INSERT INTO jae_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Go Anôtô kêsôm gêdêŋ Noa to nê latui, taŋ sêwiŋ eŋ naŋ, gebe ");
INSERT INTO jae_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Alic acgom, aê tec jamoatiŋ poac êndêŋ amac to nêm wakuc, taŋ sêndaŋguc naŋ, ");
INSERT INTO jae_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma êndêŋ gêŋ mateŋ jali samob, taŋ sêmoa sêwiŋ amac naŋ, êndêŋ moc to bôc malacŋa to saleŋŋa samob, taŋ sêmoa sêwiŋ amac naŋ, êndêŋ gêŋ samob, taŋ sêsa aŋga waŋ sêmêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Aê gabe jamoatiŋ poac êndêŋ amac gebe Bu êsuŋ ŋatêna teŋ enseŋ gêŋ mateŋ jali su êtiam atomanô ma bu êsuŋ ŋatêna teŋ enseŋ nom su êtiam atom amboac tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ma Anôtô kêsôm gebe “Poac, taŋ jamoatiŋ êndêŋ amac to gêŋ mateŋ jali, taŋ sêmoa sêwiŋ amac naŋ, ŋabelo tonec ênêc teŋgeŋ ma teŋgeŋ gebe ");
INSERT INTO jae_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Jakêŋ ŋoc kasômbuc êkô tao ŋasawa êtu poac, taŋ kamoatiŋ gêdêŋ nom naŋ, ŋabelo. ");
INSERT INTO jae_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aê embe jakêŋ tao êkô nom ŋaô ma jalic kasômbuc ênsac tao ŋaô, ");
INSERT INTO jae_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","go taêc ênam poac, taŋ kamoatiŋ gêdêŋ amac to gêŋ mateŋ jali samob naŋ, ma bu êsa e êsuŋ ŋatêna enseŋ gêŋ mateŋ jali samob su êtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kasômbuc embe ênsac tao ŋaô, go jasala gêŋ tau ma taêc ênam poac teŋgeŋŋa, taŋ kamoatiŋ gêdêŋ gêŋ mateŋ jali samob, taŋ sêmoa nom naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma Anôtô kêsôm gêdêŋ Noa gebe “Poac, taŋ kamoatiŋ gêdêŋ gêŋ mateŋ jali samob, taŋ sêmoa nom naŋ, ŋabelo tau tonec.” ");
INSERT INTO jae_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa latui, taŋ sêsa aŋga waŋ sêmêŋ naŋ, nêŋ ŋaê tonec gebe Sem agêc Ham ma Japet. Kanaan tama Ham. ");
INSERT INTO jae_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa latui têlêac tonaŋ. Ma êsêac têtu lau nom samucgeŋŋa nêŋ ŋamôkê. ");
INSERT INTO jae_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa gêjam kôm kêpi nom kêtu ŋamata. Eŋ kêsê kôm wainŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Eŋ gênôm wain e kêjaŋiŋ eŋ ma gêc nê becobo toôli ŋaôma. ");
INSERT INTO jae_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ma Kanaan tama Ham gêlic tama ôli ŋaôma ma kêsa jakêsôm biŋ tau gêdêŋ têwai. ");
INSERT INTO jae_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Go Sem agêc Japet sêkôc ŋakwê teŋ sêkêŋ gêsac magiŋm ma sêsêlêŋ sênu tauŋgeŋ jasêsaŋ tameŋi ôli ŋaôma auc. Agêc sêkac laŋôŋanô ôkwi sebe sêlic tameŋi ôli ŋaôma atom. ");
INSERT INTO jae_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Gêdêŋ taŋ wain ŋaŋaclai gêbacnê ma Noa gêdi sa naŋ, eŋ gêŋô biŋ, taŋ ŋac sauŋ gêgôm gêdêŋ eŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","tec kêsôm gebe “Aê japuc boa Kanaan, eŋ êtu lasitêwainêŋ sakiŋwaganêŋ gêŋôma.” ");
INSERT INTO jae_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Eŋ kêsôm teŋ gêwiŋ gebe “Apômtau, aêŋoc Anôtô, ênam mec Sem ma êŋgôm Kanaan êtu ênê gêŋôma. ");
INSERT INTO jae_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anôtô êkêŋ ŋasawa êndêŋ Japet gebe êmoa êwiŋ Sem aŋga nê becobo. Mago Kanaan êtu ênê gêŋôma.” ");
INSERT INTO jae_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bu kêsuŋ ŋatêna kêpa ma Noa gêmoa nom jala 350 gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noanê jala samob kêtu 950, go gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Lau tonec têtu Noa latui Sem agêc Ham ma Japet nêŋ wakuc. Êsêac saka gôlôac lasê gêdêŋ taŋ bu kêsuŋ ŋatêna gêbacnê. ");
INSERT INTO jae_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japet latui tonec Gomer, Magog, Madai, Jawan, Tubal, Mesek ma Tiras. ");
INSERT INTO jae_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer latui tonec Askenas, Ripat ma Togarma. ");
INSERT INTO jae_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jawan latui tonec Elisa, Tarsis, Kitim ma Dodanim. ");
INSERT INTO jae_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Lau gwêcŋa sêsa aŋga lau tonaŋ nêŋ. Lau tonec têtu Japetnê wakuc têtôm nêŋ gamêŋ to aweŋ gêdêŋ-gêdêŋgeŋ ma têtôm nêŋ gôlôac to gôlôacmôkê gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham latui tonec Kus, Aiguptu, Put ma Kanaan. ");
INSERT INTO jae_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus latui tonec Seba, Hawila, Sabta, Rama ma Sabteka. Rama latui tonec Seba agêc Dedan. ");
INSERT INTO jae_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus kêka Nimrod lasê, taŋ kêtu nom ŋaapômtau toŋaclai ŋamataŋa. ");
INSERT INTO jae_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Eŋ kêtu ŋac lêma gwadaŋa towae gêmoa Apômtau laŋônêmŋa. Kêtu tonaŋŋa biŋdêm laŋgwa gêc gebe “Kêtôm Nimrod, taŋ kêtu ŋac lêma gwadaŋa towae gêmoa Apômtau laŋônêmŋa.” ");
INSERT INTO jae_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Eŋ gêjac m nê gôliŋ kiŋŋa aŋga Babel to Erek ma Akad, taŋ gêc gamêŋ Sinar. ");
INSERT INTO jae_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Eŋ gêwi gamêŋ tonaŋ siŋ ma gêja Asuria ma kêkwê malac Niniwe to Rehobot-Ir ma Kala ");
INSERT INTO jae_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma malac teŋ gêc Niniwe to Kala ŋasawa ŋaê gebe Resen, taŋ kêtu malac kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Aiguptu kêka Ludim, Anamim, Lehabim, Naptuhim, ");
INSERT INTO jae_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, taŋ kêtu Pilistinêŋ mimi naŋ, ma Kaptorim lasê. ");
INSERT INTO jae_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan kêka nê ŋacsêga Sidon agêc lasi Het lasê. ");
INSERT INTO jae_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Eŋ kêtu lau gamêŋ Jebus, Amor, Girgas, ");
INSERT INTO jae_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hib, Ark, Sin, ");
INSERT INTO jae_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwad, Semar ma Hamatŋa tameŋi. Kêtu ŋamu gôlôac, taŋ sêsa aŋga Kanaannê naŋ sesewec. ");
INSERT INTO jae_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Lau Kanaan nêŋ gamêŋ gêc Sidon gêmu kêsô gêdêŋ Gerar ma Gasa to gêmu kêsô gêdêŋ Sodom to Gomora ma Adma to Seboim e gêdêŋ Lasa. ");
INSERT INTO jae_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Lau tonec têtu Hamnê wakuc têtôm nêŋ gamêŋ to aweŋ gêdêŋ-gêdêŋgeŋ ma têtôm nêŋ gôlôac to gôlôacmôkê gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Japet têwa Sem, taŋ kêtu Ebernê gôlôac abeŋi naŋ, kêka gôlôac lasê amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem latui tonec Elam, Asur, Arpaksad, Lud ma Aram. ");
INSERT INTO jae_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram latui tonec Us, Hul, Geter ma Mas. ");
INSERT INTO jae_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad kêka Sela lasê, ma Sela kêka Eber lasê. ");
INSERT INTO jae_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber kêka latui luagêc lasê, ŋac teŋ nê ŋaê gebe Peleg, ŋam gebe gêdêŋ ênê têm lau nomŋa sêwa tauŋ kêkôc, agêc lasi Joktan. ");
INSERT INTO jae_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan kêka Almodad, Selep, Harsarmawet, Jera, ");
INSERT INTO jae_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO jae_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO jae_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Hawila ma Jobab lasê. Lau samob tonec Joktan latui êsêac. ");
INSERT INTO jae_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Êsêacnêŋ gamêŋ sêŋgôŋŋa gêc Mesa ma gêmu kêsô gêdêŋ Separ to gêdêŋ lôc dênaŋ, taŋ kêkô gamêŋ oc kêpiŋa. ");
INSERT INTO jae_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Lau tonec têtu Semnê wakuc têtôm nêŋ gamêŋ to aweŋ gêdêŋ-gêdêŋgeŋ ma têtôm nêŋ gôlôac to gôlôacmôkê gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noanê wakuc nêŋ gôlôac têtôm nêŋ ŋam to gôlôacmôkê êsêac. Bu kêsuŋ ŋatêna kêpa, tec êsêac têtu lau nomŋa samob nêŋ ŋamôkê. ");
INSERT INTO jae_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Lau nomŋa samob sêsôm biŋ aweŋ tageŋ to ŋalô tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Gêdêŋ taŋ êsêac dêdi aŋga gamêŋ oc kêpiŋa naŋ, sêsêlêŋ e têtap gaboaŋ teŋ sa gêc gamêŋ Sinar ma sêŋgôŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ma êsêac sêôc tauŋ gebe “Ajôc, tamansaŋ nomku têkê-têkê ma tapac e ŋajaŋa êsa.” Ma êsêac sêkôc poc nomkuŋa gêjô poc anô ma sêkôc kolda kêtu sêsap poc tôŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Go sêsôm gebe “Ajôc, takwê nêŋ malac teŋ sa to andu baliŋ teŋ e ŋatêpôê soso êpi undambê gebe tamboa nêŋ ŋaê sa, gebe têta aêac saliŋ-saliŋ tanam nom samuc auc atom.” ");
INSERT INTO jae_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Go Apômtau kêsêp gêmêŋ gebe êlic malac to andu soso, taŋ ŋamalac latuŋi sêkwê sa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ma Apômtau kêsôm gebe “Kec, êsêac lau m tageŋ ma samob sêsôm aweŋ tageŋ. Ma kôm, taŋ sêjac m naŋ, oc sênac têku ma gêŋ samob, taŋ êsêac taêŋ ênam gebe sêŋgômŋa naŋ, ŋateŋ oc êkêŋ wapac êsêac atom. ");
INSERT INTO jae_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ajôc, tasêp tana ma taŋgaluŋ êsêac aweŋ gebe sêŋô tauŋ nêŋ biŋ sapu.” ");
INSERT INTO jae_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ma Apômtau kêta êsêac saliŋ-saliŋ e jasêjam nom samucgeŋ auc ma êsêac sêpô kôm sêkwê malac saŋa siŋ. ");
INSERT INTO jae_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kêtu tonaŋŋa sê malac tau ŋaê gebe Babel, ŋam gebe Apômtau kêgaluŋ lau nomŋa samob aweŋ aŋga ônê ma kêta êsêac saliŋ-saliŋ e sêjam nom samucgeŋ auc. ");
INSERT INTO jae_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semnê wakuc tau tonec. Bu kêsuŋ ŋatêna kêpa ma jala luagêc gêbacnê, go Semnê jala kêtu 100, ma kêka Arpaksad lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpaksad têna kêkôc eŋ su ma Sem gêmoa nom jala 500 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksadnê jala kêtu 35 ma kêka Sela lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela têna kêkôc eŋ su ma Arpaksad gêmoa nom jala 403 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selanê jala kêtu 30 ma kêka Eber lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber têna kêkôc eŋ su ma Sela gêmoa nom jala 403 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebernê jala kêtu 34 ma kêka Peleg lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg têna kêkôc eŋ su ma Eber gêmoa nom jala 430 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegnê jala kêtu 30 ma kêka Reu lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu têna kêkôc eŋ su ma Peleg gêmoa nom jala 209 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reunê jala kêtu 32 ma kêka Serug lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug têna kêkôc eŋ su ma Reu gêmoa nom jala 207 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugnê jala kêtu 30 ma kêka Nahor lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor têna kêkôc eŋ su ma Serug gêmoa nom jala 200 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahornê jala kêtu 29 ma kêka Tara lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tara têna kêkôc eŋ su ma Nahor gêmoa nom jala 119 gêwiŋ, go kêka latuio to ŋac ŋagêdô lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taranê jala kêtu 70 ma kêka Abram agêc Nahor ma Haran lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taranê wakuc tau tonec. Tara kêka Abram agêc Nahor ma Haran lasê. Ma Haran kêka Lot lasê. ");
INSERT INTO jae_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran gêmac êndu gêmuŋ tama Tara aŋga nê malacmôkê Ur aŋga Kaldea. ");
INSERT INTO jae_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma Abram agêc Nahor sêjam awê sa. Abramnê awênê ŋaê gebe Sarai, Nahornê awênê ŋaê gebe Milka, eŋ Haran latuo, Haran, taŋ kêka Milka agêc Iska lasê naŋ. ");
INSERT INTO jae_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma Sarai eŋ awê kapoac, eŋ kêkôc ŋapalê teŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tara kêkôc latu Abram agêc dêbu Lot, naŋ Haran latu ma lawao Sarai, latu Abram nê awê, ma êsêac sêwi Ur aŋga Kaldea siŋ gebe sêna gamêŋ Kanaan. Mago gêdêŋ taŋ êsêac sêô lasê Haran naŋ sêŋgôŋ tônê. ");
INSERT INTO jae_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taranê jala kêtu 205 ma Tara gêmac êndu aŋga Haran. ");
INSERT INTO jae_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma Apômtau kêsôm gêdêŋ Abram gebe “Ondec nêm gamêŋ to nêm lau sêmoa ma tamamnê andu êkôŋa ma ôna gamêŋ, naŋ aê gabe jatôc êndêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aê gabe jaŋgôm aôm ôtu laum kapôêŋ ma gabe janam mec aôm ma jaŋgôm nêm ŋaê êtu kapôêŋ gebe ôtu moasiŋ ŋamôkê. ");
INSERT INTO jae_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aê gabe janam mec êsêac, taŋ sênam mec aôm ma êsêac, taŋ sêpuc boa aôm naŋ, aê gabe japuc boa. Gôlôac nomŋa samob têtap mec ŋamoasiŋ sa êtu aômŋa.” ");
INSERT INTO jae_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Amboac tonaŋ Abram gêdi kêtôm Apômtau kêjatu eŋ, ma Lot gêdi gêwiŋ eŋ. Gêdêŋ taŋ Abram gêwi Haran siŋ naŋ, nê jala kêtu 75. ");
INSERT INTO jae_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ma Abram kêkôc nê awê Sarai to lasinê latu Lot ma nêŋ waba samob, taŋ têtap sa naŋ, ma lau, taŋ têtu nêŋ sakiŋwaga aŋga Haran naŋ, ma dêdi gebe sêsêlêŋ sêna gamêŋ Kanaan. Ma gêdêŋ taŋ sêô lasê gamêŋ Kanaan tau naŋ, ");
INSERT INTO jae_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram kêsêlêŋ-kêsêlêŋ e jagêô lasê malac Sikem to kamem, taŋ kêkô More naŋ. Gêdêŋ têm tonaŋ lau gamêŋ Kanaan ŋa sêŋgôŋ gamêŋ tau. ");
INSERT INTO jae_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Go Apômtau geoc tau lasê gêdêŋ Abram ma kêsôm gebe “Aê gabe jakêŋ nom tonec êndêŋ nêm wakuc.” Tec eŋ gêboa altar teŋ sa gêdêŋ Apômtau, taŋ geoc tau lasê gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Go eŋ gêdi kêpi lôc aŋga Betel ŋagamêŋ oc kêpiŋa ma gê becobo kêkô Betel, taŋ gêc gamêŋ oc kêsêpŋa ma Ai, taŋ gêc gamêŋ oc kêpi ŋa naŋ ŋasawa. Ma aŋga tônê eŋ gêboa Apômtaunê altar teŋ sa ma awa gêjac Apômtaunê ŋaê. ");
INSERT INTO jae_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ma Abram gêdi kêsêlêŋ laŋô gêlac Negebgeŋ gêja. ");
INSERT INTO jae_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ma tôbôm kêsa gamêŋ tonaŋ. Tec Abram kêsêp Aiguptu gêja gebe êsêlêŋ-êsêlêŋ êmoa tônê gebe tôbôm kapôêŋ gêc gamêŋ tau. ");
INSERT INTO jae_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gêdêŋ taŋ kêdabiŋ gebe êô lasê Aiguptu naŋ, eŋ kêsôm gêdêŋ nê awê Sarai gebe “Aê kajala gebe aôm awê êjam. ");
INSERT INTO jae_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lau Aiguptu embe sêlic aôm, go sêsôm gebe ‘Ênê awê tonec,’ go sênac aê êndu, ma oc sendec aôm ômoa. ");
INSERT INTO jae_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ôsôm gebe aêŋoc luco aôm e sêlêwaŋ aê êtu aômŋa.” ");
INSERT INTO jae_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Gêdêŋ taŋ Abram gêô lasê Aiguptu naŋ, Aiguptuwaga sêlic awê tau gebe awê êjam. ");
INSERT INTO jae_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Paraonê laumata sêlic eŋ ma sêlambiŋ eŋ ŋanô gêdêŋ Parao. Ma sêkôc awê tau sêsô Paraonê andu sêja. ");
INSERT INTO jae_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma kêtu eŋŋa Parao kêmoasiŋ Abram ma kêkêŋ domba to bulimakao ma doŋki kapoac ma sakiŋwagao to ŋac ma doŋki têna to kamele gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mago Apômtau gejoŋ Parao to nê andu ŋa gêŋwapac ŋanôgeŋ kêtu Abramnê awê Saraiŋa. ");
INSERT INTO jae_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tec Parao kêkalem Abram ma kêsôm gebe “Aôm gôgôm aê amboac ondoc. Kêtu ageŋŋa kôsôm lasê gêdêŋ aê gebe nêm awê eŋ nec atom. ");
INSERT INTO jae_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kêtu ageŋŋa aôm kôsôm gebe ‘Aê luco eŋ,’ tec kakôc eŋ kêtu ŋoc awê. Amboac tonaŋ nêm awê tau tonec, ôkôc eŋ ma ôêc ôna.” ");
INSERT INTO jae_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ma Parao kêjatu lau kêtu eŋŋa gebe sêsêlêŋ sêwiŋ êsêagêc nê awê to ênê waba samob. ");
INSERT INTO jae_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ma Abram agêc nê awê tonêŋ waba samob sêwi Aiguptu siŋ sêmu sêja Negeb. Ma Lot gêwiŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram kêtu ŋac tolêlôm bôc ma silber to goldŋa. ");
INSERT INTO jae_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ma eŋ kêsêlêŋ-kêsêlêŋ gêmoa Negeb e gêô lasê Betel e gêdêŋ gamêŋ, taŋ gêmuŋgeŋ gê becobo kêsêp, gêc Betel ma Ai ŋasawa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","gêdêŋ gamêŋ, taŋ gêboa altar sa. Go Abram awa gêjac Apômtaunê ŋaê aŋga tônê. aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma Lot, taŋ gêwiŋ Abram naŋ, nê domba to bulimakao sêmoa ma nê becobo sêkô amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ma gamêŋ kêtôm gebe êsêagêc lulugeŋ sêŋgôŋ sêwiŋ tauŋŋa atom, gebe êsêagêcnêŋ waba to bôc taêsam ŋanô gebe sêŋgôŋ sêwiŋ tauŋ tec kêtôm atom. ");
INSERT INTO jae_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ma Abramnê bôc ŋagejobwaga to Lotnê bôc ŋagejobwaga aweŋsuŋ gêôc ka tau. Gêdêŋ têm tonaŋ lau gamêŋ Kanaan to Perisŋa sêŋgôŋ gamêŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Go Abram kêsôm gêdêŋ Lot gebe “Biŋ aweŋsuŋ êôc ka tauŋa ênêc aêagêc ŋasawa to agêcnêŋ gejobwaga ŋasawa atom gebe aêagêc ŋam tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gamêŋ samuc tonec gôlic atom me. Ôsu taôm su aŋga aê. Embe ôkôc gamêŋ gasêŋa, go aê jana anôŋaŋa. Embe ôkôc gamêŋ anôŋa, go aê jana gasêŋaŋa.” ");
INSERT INTO jae_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ma Lot gêôc mataanô sa ma gêlic bu Jordan ŋagaboaŋ gebe nom ŋalêsi ŋajam kêtôm Apômtaunê kôm tau, kêtôm gamêŋ Aiguptu e gêdêŋ Soar. Gêdêŋ tonaŋ Apômtau geseŋ Sodom to Gomora su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tec Lot kêjaliŋ bu Jordan ŋagaboaŋ sa kêtu nê gamêŋ ma Lot kêsêlêŋ gêmu gêdêŋ oc kêpiŋa gêja. Gêdêŋ tonaŋ êsêagêc sêwa tauŋ kêkôc. ");
INSERT INTO jae_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram gêŋgôŋ gamêŋ Kanaan ma Lot gêŋgôŋ malac gaboaŋŋa ŋasawa ma gêjam bebec e gêdêŋ Sodom. ");
INSERT INTO jae_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mago lau Sodomŋa lau secanô ma sêgôm gêŋ alôb-alôb gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot kêsu tau su aŋga Abramnê, go Apômtau kêsôm gêdêŋ Abram gebe “Ôc matamanô sa ma ôlic gamêŋ samob, taŋ kêgi aôm auc naŋ, gêmu kêpi go gêmu kêsêp ma gêmu kêsô to gêmu kêsaŋa ");
INSERT INTO jae_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","gebe gamêŋ samob tonaŋ, taŋ gôlic naŋ, aê gabe jakêŋ êndêŋ aôm to nêm wakuc êtu amacnêm êndêŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aê gabe jaŋgôm nêm wakuc têtu taêsam amboac gaŋac gwêcŋa. Lau embe têtôm gebe sêsa gaŋac gwêcŋa ŋanamba sa, go têtôm gebe sêsa nêm wakucnêŋ namba sa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ôndi ôsêlêŋ e naôndêŋ gamêŋ ŋamadiŋ makeŋ-makeŋ, gebe aê gabe jakêŋ êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tec Abram gêbuc nê bec sa ma jagêô lasê kamem aŋga Mamre, taŋ kêkô Hebron ŋagala naŋ, ma gê nê bec, go gêboa Apômtaunê altar teŋ sa aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Gêdêŋ taŋ Amrapel kêtu kiŋ Sinarŋa ma Ariok kêtu kiŋ Elasarŋa ma Kedorlaomer kêtu kiŋ Elamŋa ma Tidal kêtu kiŋ Goiimŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","êsêac sêjac siŋ gêdêŋ Bera, taŋ kêtu kiŋ Sodomŋa ma Birsa, taŋ kêtu kiŋ Gomoraŋa ma Sinab, taŋ kêtu kiŋ Admaŋa ma Semeber, taŋ kêtu kiŋ Seboimŋa ma gêdêŋ kiŋ Belaŋa (ŋaê teŋ gebe Soar). ");
INSERT INTO jae_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Êsêac samob sêpi tageŋ sêsêlêŋ sêwê Sidim ŋagaboaŋ (ŋaê teŋ gebe Gwêc Ŋatoŋ). ");
INSERT INTO jae_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Êsêac sêsô Kedorlaomer ŋalabu to sêjam sakiŋ eŋ jala 12 ma jala kêtu 13ŋa êsêac sêkac tauŋ su. ");
INSERT INTO jae_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Jala kêtu 14ŋa Kedorlaomer to kiŋ, taŋ sêwiŋ eŋ naŋ, sêmêŋ ma sêkôniŋ Repaim aŋga Asterot-Karnaim to Susim aŋga Ham ma Emim aŋga Sawe-Kiriataim ");
INSERT INTO jae_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","to lau gamêŋ Horŋa aŋga nêŋ lôc Seir e gêdêŋ El-Paran, taŋ gêc kêsi gamêŋ sawa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Go sêkac tauŋ ôkwi sêmu sêja En-Mispat (ŋaê teŋ gebe Kades) ma sêkôniŋ lau Amalek nêŋ gamêŋ samob ma lau gamêŋ Amorŋa, taŋ sêŋgôŋ Hasason-Tamar naŋ, amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Go kiŋ Sodomŋa to kiŋ Gomoraŋa ma kiŋ Admaŋa to kiŋ Seboimŋa ma kiŋ Belaŋa (ŋaê teŋ gebe Soar) sêja ma sêdênaŋ tauŋ aŋga gaboaŋ Sidimŋa gebe sênac siŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Sênac siŋ êndêŋ Kedorlaomer, taŋ kêtu kiŋ Elamŋa to Tidal, taŋ kêtu kiŋ Goiimŋa ma Amrapel, taŋ kêtu kiŋ Sinarŋa to Ariok, taŋ kêtu kiŋ Elasarŋa. Kiŋ aclê sêjac siŋ gêdêŋ kiŋ lemeŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ma kolda ŋagêsuŋ gêjam gaboaŋ Sidimŋa auc. Ma gêdêŋ taŋ kiŋ Sodom to Gomoraŋa sêc siŋ naŋ, nêŋ ŋagêdô sêu tauŋ sêsêp gêsuŋ tonaŋ ma lau ŋagêdô sêc sêpi lôc sêja. ");
INSERT INTO jae_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tec ŋacjo sêjaŋgo Sodom to Gomora nêŋ waba to nêŋ gêŋ taniŋŋa samob su ma sêc sêmu sêja nêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abramnê lasi latu Lot gêŋgôŋ Sodom, tec êsêac sêkôc eŋ tonê waba amboac tonaŋ ma sêc sêja. samob, taŋ sêkôc su ma latu Lot to nê waba ma lauo to lau samob gemu gêja amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma ŋac teŋ kêsêp siŋ sawa jagêjac miŋ gêdêŋ ŋac Ebolai Abram, taŋ gêŋgôŋ ŋac gamêŋ Amorŋa Mamre nê kamem ŋagala. Mamre lasiagêc Eskol agêc Aner. Lau tonaŋ sêmoatiŋ poac sêwiŋ Abram gebe sênam tauŋ sa. ");
INSERT INTO jae_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram gêŋô sêkôc latu tôŋ ŋawae, go kêdênaŋ nê siŋwaga 318, taŋ teneŋi sêkôc êsêac têtu ênê sakiŋwaga naŋ, ma sêjanda êsêac e gêdêŋ Dan. ");
INSERT INTO jae_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ma gêdêŋ gêbêc eŋ gêwa nê siŋwaga kêkôc ma eŋ to nê lau sêjac êsêac ma sêjanda êsêac e gêdêŋ Hoba, taŋ gêc Damaskus gêmu kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eŋ kêjaŋgo waba samob, taŋ sêkôc su naŋ su ma latu Lot to nê waba ma lauo to lau samob gêmu gêja amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram kêku Kedorlaomer to kiŋ, taŋ sêwiŋ eŋ naŋ, tulu ma gêmu gêja. Go kiŋ Sodomŋa kêpuc eŋ tôŋtôŋ aŋga gaboaŋ Saweŋa (ŋaê teŋ gebe Kiŋnê Gaboaŋ). ");
INSERT INTO jae_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma kiŋ Salemŋa, Melkisedek, kêkôc polom to wain gêja. Eŋ kêtu Lôlôc Ŋatau Anôtô nê dabuŋwaga. ");
INSERT INTO jae_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma eŋ gêjam mec eŋ to kêsôm gebe “Lôlôc Ŋatau Anôtô, taŋ kêkêŋ undambê to nom naŋ, ênam mec Abram. ");
INSERT INTO jae_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Aweŋ êôc Lôlôc Ŋatau Anôtô, taŋ kêkêŋ nêm ŋacjo sêsô aôm lêmam ŋalabu.” Ma Abram kêkôc gêŋ lemeŋ lu-lemeŋ lu ŋatageŋ-tageŋ sa kêkêŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ma kiŋ Sodomŋa kêsôm gêdêŋ Abram gebe” Ôkêŋ ŋamalacgeŋ sêndêŋ aê ma ôkôc waba êtu nêm gêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mago Abram kêsôm gêdêŋ kiŋ Sodomŋa gebe “Aê katôc lemoc gêdêŋ Lôlôc Ŋatau Apômtau Anôtô, taŋ kêkêŋ undambê to nom naŋ, ");
INSERT INTO jae_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","gebe jakôc aômnêm nia me lêkôŋ me aômnêm gêŋ ŋateŋ atomanô. Moae aôm ôsôm gebe ‘Aê kakêŋ Abram kêtu ŋac tolêlôm.’ ");
INSERT INTO jae_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Aê gabe jakôc gêŋ teŋ atom, mago gêŋ tageŋ taŋ lau matac seŋ naŋ to gêŋ Aner agêc Eskol ma Mamre, taŋ sêwiŋ aê naŋ, sêwê kaiŋ, tec sêkôc nêŋ gêŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","siŋ tonaŋ gêbacnê, go Abram katu gêlic Apômtau ma awa gêjac eŋ gebe “Abram, ôtêc taôm atom. Aê katu aômnêm lautuc. Moasiŋ kapôêŋ êtap aôm sa.” ");
INSERT INTO jae_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mago Abram kêsôm gebe “O Apômtau Anôtô, aôm gobe ôkêŋ asageŋ êndêŋ aê. Aêŋoc gôlôac masianô ma Elieser aŋga Damaskus êtu ŋac oc êwê kaiŋ aêŋoc gêŋlênsêm.” ");
INSERT INTO jae_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ma Abram kêsôm gebe “Ôlic acgom, aôm kôkêŋ gôlôac gêdêŋ aê atom ma gêŋôma teŋ, taŋ têna kêkôc eŋ aŋga ŋoc andu naŋ, oc êtu ŋac êwê kaiŋ aêŋoc gêŋlênsêm.” ");
INSERT INTO jae_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mago Apômtaunê biŋ gêdêŋ eŋ gebe “Ŋac tonec êwê kaiŋ nêm gêŋlênsêm atom, aôm latôm solop êtu ŋac êwê kaiŋ nêm gêŋlênsêm.” ");
INSERT INTO jae_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Go gêwê eŋ kêsa awê gêja ma kêsôm gebe “Matam endec umboŋ ma embe ôtôm gebe ôsa utitalata sa, go ôsa samaŋ.” Go kêsôm gêdêŋ eŋ gebe “Nêm wakuc oc têtôm tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ma eŋ kêkêŋ gêwiŋ Apômtau, tec gêlic eŋ ŋac gêdêŋ. ");
INSERT INTO jae_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ma Apômtau kêsôm gêdêŋ eŋ gebe “Aê Apômtau, taŋ kakôc aôm aŋga Ur Kaldeaŋa gebe jakêŋ gamêŋ tonec êndêŋ aôm ôwê kaiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mago Abram kêsôm gebe “O Apômtau Anôtô, aê jajala amboac ondoc gebe jawê kaiŋ gamêŋ tau.” ");
INSERT INTO jae_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Eŋ kêsôm gêdêŋ eŋ gebe “Ôkôc bulimakao têna ŋajala kêtu têlêac to noniŋ têna ŋajala kêtu têlêac ma domba kapoac ŋajala kêtu têlêac ma balôsi teŋ to moŋgôm ŋalatu teŋ, go ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ma eŋ kêkôc gêŋ samob tonaŋ ma kêsêlê kêkôc gêja luagêc-luagêc ma kêdênaŋ makeŋ-makeŋ kêkanôŋ tau, mago moc, tec kêsêlê atom. ");
INSERT INTO jae_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ma moc, taŋ seŋ gêŋ todec naŋ, sêpôp sêsêp sebe sêniŋ gwada, tec Abram gesoc. ");
INSERT INTO jae_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Oc jakêsêp ma Abram gêc bêc e kêliŋ tau siŋ ma nê ŋalêlôm ôluŋ-ôluŋgeŋ to ŋakesec kêkôm eŋ auc. ");
INSERT INTO jae_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Go Apômtau kêsôm gêdêŋ Abram gebe “Ôŋô, ma ôjala êtu tôŋ gebe nêm wakuc oc têtu lau jaba aŋga gamêŋ, taŋ êsêac tauŋ sêwê kaiŋ atom naŋ, ma têtu gêŋôma ma sêkôniŋ êsêac êtôm jala 400. ");
INSERT INTO jae_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mago aê jamêtôc lau, tê sênam sakiŋ êndêŋ êsêac nê, go êsêac sêwi gamêŋ tau siŋ towaba taêsam ŋanô lasê. ");
INSERT INTO jae_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mago aôm taôm tec ôndêŋ tamami ôna tobiŋmalôgeŋ ma nêm jala êtu taêsam acgom, go sênsuŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ma nêm gôlôac ŋatoŋ têtu aclêŋa oc sêmu sêmêŋ gamêŋ tonec êtiam, gebe lau gamêŋ Amorŋa nêŋ alôb-alôb gêjac pep atom tageŋ.” ");
INSERT INTO jae_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Oc jakêsêp ma gamêŋ ŋakesec kêsa, go ku tojadauŋ teŋ ma daweŋ teŋ gelom lasê gêmoa bôc tau ŋasawa. ");
INSERT INTO jae_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Gêdêŋ bêc tonaŋ Apômtau kêmoatiŋ poac gêdêŋ Abram ma kêsôm gebe “Aê kakêŋ gamêŋ tonec gêdêŋ nêm wakuc su aŋga bu Aiguptuŋa e gêdêŋ bu kapôêŋ Euprat, ");
INSERT INTO jae_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","gamêŋ taŋ lau Ken to Kenis ma Kadmon ");
INSERT INTO jae_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","to Het ma Peris to Repaim ");
INSERT INTO jae_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ma Amor to Kanaan ma Girgas to Jebus sêwê kaiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ma Abramnê awê Sarai kêkôc ŋapalê teŋ atom. Ma ênê sakiŋwagao Aiguptuŋa teŋ gêmoa, nê ŋaê gebe Hagar. ");
INSERT INTO jae_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ma Sarai kêsôm gêdêŋ Abram gebe “Aôm gôlicgac gebe Apômtau kêgamiŋ ŋapalê gêdêŋ aê gebe jakôc atom. Tec naômoa ôwiŋ sakiŋwagao, moae jatap ŋoc ŋapalê sa aŋga ênê.” Ma Abram kêkêŋ taŋa Sarai awa. ");
INSERT INTO jae_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abram gêmoa Kanaan jala 10 su, go Sarai kêkôc nê sakiŋwagao Aiguptuŋa Hagar ma kêkêŋ gêdêŋ nê akweŋ Abram gebe ênam êtu ênê awê. ");
INSERT INTO jae_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ma eŋ gêmoa gêwiŋ Hagar e kêkêkam ŋapalê. Gêdêŋ taŋ eŋ kêsaê tau gebe taê naŋ, gêlic nê ŋatauo ŋa matapaŋageŋ. ");
INSERT INTO jae_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ma Sarai kêsôm gêdêŋ Abram gebe “Keso tec sêgôm gêdêŋ aêma nec êpi aôm. Aê tauc kakêŋ ŋoc sakiŋwagao kêsêp aôm lêmam. Ma galoc kêsaê tau gebe taê, tec gêlic aê ŋa matapaŋageŋ. Apômtau êmêtôc aêagêcnêŋ biŋ ŋasawaŋa.” ");
INSERT INTO jae_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mago Abram kêsôm gêdêŋ Sarai gebe “Ôlic acgom, nêm sakiŋwagao kêtu aômnêm gêŋgac. Ôŋgôm gêŋ, taŋ taêm ênam naŋ, êndêŋ eŋ.” Ma Sarai kêkôniŋ eŋ, tec gêbôm gêja. ");
INSERT INTO jae_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Apômtaunê aŋela kêtap eŋ sa gêŋgôŋ bumata, taŋ kêpoac gamêŋ sawa naŋ, bumata tau kêpoac intêna Surŋa. ");
INSERT INTO jae_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ma eŋ kêsôm gebe “Sarainê sakiŋwagao Hagar, aôm gômôêŋ aŋga ondoc ma gobe ôna ondoc.” Eŋ gêjô eŋ awa gebe “Aê gabôm aŋga ŋoc ŋatauonê tec gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Go Apômtaunê aŋela kêsôm gêdêŋ eŋ gebe “Ômu ôndêŋ nêm ŋatauo ôna êtiam naôsô eŋ ŋalabu.” ");
INSERT INTO jae_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Apômtaunê aŋela kêsôm gêdêŋ eŋ gêwiŋ gebe “Aê gabe jaŋgôm nêm wakuc têtu taêsam e sêsa êsêac sa naeo.” ");
INSERT INTO jae_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ma Apômtaunê aŋela kêsôm gêdêŋ eŋ gebe “Aôm taêm ma ôkôc ŋapalê ŋac. Ôê ênê ŋaê gebe Ismael gebe Apômtau kêkêŋ taŋa nêm gêŋwapac. ");
INSERT INTO jae_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Eŋ êtu ŋac teŋ, taŋ êtôm bôclai teŋ ma eŋ lêma ejoŋ lau samob ma lau samob lemeŋ ejoŋ eŋ. Eŋ oc êŋgôŋ êwiŋ tawaŋ atom.” ");
INSERT INTO jae_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar kêtu kênac tau gebe “Amboac ondoc, aê galic Anôtô, taŋ gêlic aê naŋ, biŋŋanô aŋga tonec me masi.” Tec kêsam Apômtaunê ŋaê gebe “Aôm Anôtô tomatamanô kaiŋ teŋ.” ");
INSERT INTO jae_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kêtu tonaŋŋa lau sêsam bumata tonaŋ gebe Ber-Lahai-Roi. Bumata tau kêpoac Kades to Bered ŋasawa. ");
INSERT INTO jae_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ma Hagar kêkôc Abramnê latu teŋ ma Abram gê latu, taŋ Hagar kêkôc naŋ, nê ŋaê gebe Ismael. ");
INSERT INTO jae_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Gêdêŋ taŋ Hagar kêkôc Ismael naŋ, Abramnê jala kêtu 86. naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Gêdêŋ taŋ Abramnê jala kêtu 99 naŋ, Apômtau geoc tau lasê gêdêŋ eŋ ma kêsôm gêdêŋ eŋ gebe “Ŋajaŋa ŋatau Anôtô aê, ôsa ŋoc lêŋ ômansaŋ taôm ŋapep. ");
INSERT INTO jae_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma aê gabe jamoatiŋ poac teŋ êndêŋ aôm ma gabe jakêŋ aômnêm wakuc têtu taêsam ŋasec.” ");
INSERT INTO jae_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Go Abram gêu tau laŋôanô jagêdêŋ nom ma Anôtô kêsôm gêdêŋ eŋ gebe ");
INSERT INTO jae_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Gôlicgac, ŋoc poac tau tonec gebe jakêŋ aôm ôtu gôlôacmôkê taêsam tameŋi. ");
INSERT INTO jae_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sêsam aômnêm ŋaê Abram êtiam atom, sêsam aôm gebe Abraham gebe aê kakêŋ aôm kôtu gôlôacmôkê taêsam tameŋi. ");
INSERT INTO jae_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aê gabe jakêŋ aômnêm wakuc têtu taêsam ŋasec ma nêm wakuc têtu gôlôacmôkê taêsam ma kiŋ sêsa aŋga aômnêm. ");
INSERT INTO jae_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Aê jamoatiŋ poac êndêŋ aôm to nêm wakuc, taŋ sêndaŋguc aôm naŋ, nêŋ gôlôac to gôlôac ma poac tau ênêc teŋgeŋ ma teŋgeŋ gebe aê jatu amac to nêm wakuc, taŋ sêndaŋguc aôm naŋ, nêm Anôtô. ");
INSERT INTO jae_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ma aê jakêŋ gamêŋ Kanaan, taŋ aôm gômoa amboac ŋac jaba naŋ, samucgeŋ êndêŋ aôm to nêm wakuc, taŋ sêndaŋguc aôm naŋ, gebe êtu amacnêm endeŋ tôŋgeŋ ma aê jatu êsêacnêŋ Anôtô.” ");
INSERT INTO jae_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma Anôtô kêsôm gêdêŋ Abraham gebe “Aôm to nêm wakuc, taŋ sêndaŋguc aôm naŋ, ma êsêacnêŋ gôlôac to gôlôac ajop ŋoc poac. ");
INSERT INTO jae_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Aêŋoc poac tau tonec gebe sêsa ŋapalê ŋac samob. Biŋ tonaŋ kamoatiŋ gêdêŋ aôm to nêm wakuc, taŋ sêndaŋguc aôm naŋ, gebe ajopŋa. ");
INSERT INTO jae_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sêsa amacnêm utimôlic. Poac, taŋ kamoatiŋ gêdêŋ aôm naŋ, ŋabelo tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ŋapalê ŋac teŋ aŋga aômnêm, taŋ nê bêc êtu 8 naŋ, sêsa eŋ êtôm nêm gôlôacmôkêgeŋ. Lau, taŋ teneŋi sêkôc aŋga taôm nêm andu me ajam ôli ŋa mone aŋga lau jaba nêŋ, taŋ sêsa aŋga aômnêm ŋawê atom naŋ, ");
INSERT INTO jae_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","sêsa êsêagêc lulugeŋ, ŋac taŋ têna kêkôc eŋ aŋga taôm nêm andu naŋ, to ŋac, taŋ gôjam ôli ŋa mone naŋ. Tec ŋoc poac ênêc amac ôlim êtu poac teŋgeŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mago ŋac samuc teŋ, taŋ sêsa utiôlic atom naŋ, senseŋ eŋ su aŋga ênê launêŋ gebe eŋ gêgôm ŋoc poac popoc.” ");
INSERT INTO jae_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma Anôtô kêsôm gêdêŋ Abraham gebe “Aômnêm awê Sarai, naŋ ôsam eŋ gebe Sarai êtiam atom, ênê ŋaê gebe Sara. ");
INSERT INTO jae_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aê gabe janam mec eŋ e aôm ôtap latôm sa aŋga ênê êwiŋ. Aê gabe janam mec eŋ e eŋ êtu gôlôacmôkê teneŋi ma lau to-m-to-m nêŋ kiŋ sêsa aŋga ênêŋa.” ");
INSERT INTO jae_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ma Abraham gêu tau laŋôanô jagêdêŋ nom ma kêômac ma taê gêjam gêc tauŋa gebe “Aê ŋamalacanô, taŋ ŋoc jala kêtu 100 sugac naŋ, oc jaka ŋapalê lasê me. Ma Sara, taŋ nê jala kêtu 90 naŋ, êkôc gôlôac me.” ");
INSERT INTO jae_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma Abraham kêsôm gêdêŋ Anôtô gebe “Ojae, Ismael êsa nê lêŋ êmoa aôm laŋômnêmŋamaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mago Anôtô kêsôm gebe “Masi, nêm awê Sara oc êkôc nêm latôm teŋ. Ôê ênê ŋaê gebe Isak. Ma aê gabe jamoatiŋ ŋoc poac êndêŋ eŋ êtu poac ênêc teŋgeŋŋa êndêŋ ênê wakuc, taŋ sêndaŋguc eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismaelnê biŋ, tec gaŋô sugac. Gôlicgac me, aê janam mec eŋ ma jakêŋ gôlôac to gôlôac êndêŋ eŋ e têtu taêsam ŋanô. Eŋ êka kasêga 12 lasê ma aê gabe jakêŋ eŋ êtu laum kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mago ŋoc poac, tec gabe jamoatiŋ êndêŋ Isakgeŋ. Sara êkôc eŋ êndêŋ jala ônê ŋatêm amboac tonec.” ");
INSERT INTO jae_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anôtô kêsôm biŋ gêdêŋ Abraham su, go gêwi eŋ siŋ ma gêc kêpi gêja. ");
INSERT INTO jae_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Go Abraham kêkôc latu Ismael to nê gêŋôma samob, taŋ teneŋi sêkôc êsêac aŋga ênê andu ma êsêac samob, taŋ gêjam ôli ŋa mone naŋ. Eŋ kêkôc ŋacwaga samob, taŋ sêmoa sêwiŋ eŋ aŋga nê andu ma kêsa nêŋ utiŋôlic gêdêŋ bêc tônêgeŋ kêtôm Anôtô kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamnê jala kêtu 99 ma sêsa eŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Latu Ismael nê jala kêtu 13 tec sêsa eŋ. ");
INSERT INTO jae_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Gêdêŋ bêc tônêgeŋ êsêac sêsa Abraham agêc latu Ismael, ");
INSERT INTO jae_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ma ŋacwaga samob, taŋ sêmoa ênê andu, lau, taŋ teneŋi sêkôc êsêac aŋga andu tau to êsêac, taŋ eŋ gêjam ôli ŋa mone aŋga lau jaba nêŋ naŋ, sêsa êsêac sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ma Apômtau gêôc tau lasê gêdêŋ Abraham aŋga kamem Mamreŋa. Abraham gêŋgôŋ becobo ŋasacgêdô gêdêŋ oc kêkô ŋaluŋ. ");
INSERT INTO jae_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Eŋ gêôc mataanô sa e gêlic lau têlêac sêkô eŋ laŋônêmŋa. Eŋ gêlic êsêac ma kêlêti aŋga becobo ŋasacgêdô gêdêŋ êsêac gêja. Eŋ gewec gêdêŋ êsêac ");
INSERT INTO jae_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ma kêsôm gebe “Ŋoc apômtau, embe ôlic aê ŋajam, go ôc lêlêc nêm sakiŋwaga atom. ");
INSERT INTO jae_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Êsêac sêkôc bu sêmêŋ gebe akwasiŋ emkaiŋ êsêpŋa, go alêwaŋ taôm aŋgôŋ ajuŋtêna, ");
INSERT INTO jae_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","go aê jakôc gêŋ ŋagec mêŋaniŋ tekwem êsa. Aniŋ su acgom, go asêlêŋ nêm lêŋ êtiam gebe mêŋaô lasê nêm sakiŋwaga sugac.” Ma êsêac sêsôm gebe “Ôŋgôm amboac kôsôm.” ");
INSERT INTO jae_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ma Abraham kêlêti kêsô becobo ŋalêlôm gêdêŋ Sara gêja ma kêsôm gebe “Ôkôc polom laclu têlêac ôŋgamuc ma ôpac ŋagaôgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma Abraham kêlêti gêdêŋ bulimakao gêja, kêkôc bulimakao ŋalatu ŋajam toŋalêsi teŋ ma kêkêŋ gêdêŋ sakiŋwaga, taŋ kêkacgeŋ gebe eno matajajageŋ. ");
INSERT INTO jae_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Go kêkôc su gêjac anô to su ŋakana ŋajam ma bulimakao, taŋ eŋ kêmasaŋ naŋ, ma kêkêŋ gêdêŋ êsêac. Êsêac seŋ geŋ ma eŋ tau gêjam sakiŋ êsêac gêmoa ajuŋtêna. ");
INSERT INTO jae_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Go êsêac sêsôm gêdêŋ eŋ gebe” Nêm awê Sara gêmoa ondoc.” Ma eŋ kêsôm gebe “Tec gêmoa becobo ŋalêlôm.” ");
INSERT INTO jae_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Apômtau kêsôm gebe “Êndêŋ ocêsa aê oc jamu jandêŋ aôm jamêŋ êtiam ma Sara oc êkôc latu teŋ êndêŋ têm tonaŋ.” Ma Sara kêkô becobo ŋakatam lêlômgeŋ ma taŋasuŋ gêjac. ");
INSERT INTO jae_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mago Abraham agêc Sara têtu lauo ŋanô to ŋac sugac, nêŋ jala têtu taêsam ma lauonêŋ mêtê sêjam ôli ajôŋŋa gêwi Sara siŋ su. ");
INSERT INTO jae_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kêtu tonaŋŋa Sara kêômac kêêŋgimgeŋ ma kêsôm gêdêŋ tau gebe “Aê kamêliŋ sugac ma ŋoc apômtau kêtu ŋamalacanô su amboac tonaŋgeŋ, tec aêagêc atu samuc tauŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tec Apômtau kêsôm gêdêŋ Abraham gebe “Kêtu ageŋŋa Sara kêômac ma kêsôm gêdêŋ tau gebe ‘Katu awêanô sugac, tec jakôc ŋapalê amboac ondoc.’ ");
INSERT INTO jae_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Gêŋwapac teŋ gêc, taŋ kêlêlêc Apômtau su me. Êndêŋ ocêsa aê jamu jandêŋ aôm jamêŋ êtiam ma Sara oc êkôc latu êndêŋ têm tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara kêpa tau ma kêsôm gebe “Aê kaômac atom,” gebe kêtêc tau. Mago Apômtau kêsôm gebe “Magobe, kôômacgac.” ");
INSERT INTO jae_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Go lau tau dêdi ma sêc sêja. Ma êsêac mateŋ gê Sodom. Ma Abraham kêsêlêŋ gêwiŋ êsêac gebe êkêŋ êsêac aŋga intêna. ");
INSERT INTO jae_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma Apômtau kêsôm gebe “Aê jansaŋ gêŋ, taŋ gabe jaŋgôm naŋ, auc êndêŋ Abraham oc êtôm me. ");
INSERT INTO jae_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kajalagac gebe Abraham êtu laum kapôêŋ to ŋajaŋa, ma lau tom-tom samob têtap mec ŋamoasiŋ sa aŋga ênê, ");
INSERT INTO jae_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","gebe aê kajaliŋ eŋ sa gebe êjatu nê latui to nê lau samob, taŋ sêndaŋguc eŋ naŋ, gebe sejop aêŋoc intêna ma sêŋgôm ŋoc biŋ ŋanô êsa to sêmêtôc lau naêndêŋgeŋ gebe aê jakêŋ gêŋ, taŋ gajac mata gêdêŋ Abraham naŋ, êndêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Go Apômtau kêsôm gebe “Ŋaonda kêpi Sodom to Gomora kêtu kapôêŋ ma êsêacnêŋ sec gêjam sêga. ");
INSERT INTO jae_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tec aê gabe jasêp jana jalic acgom, êsêac samob sêgôm kêtôm ŋaonda, taŋ gaŋô naŋ, me masi. Embe masi, mago gabe jajala.” ");
INSERT INTO jae_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ma lau tau sêsêlêŋ sepeŋ Sodom, mago Apômtau gacgeŋ kêkô gêwiŋ Abraham. ");
INSERT INTO jae_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Go Abraham kêtu gasuc ma kêsôm gebe “Aôm gobe onseŋ lau gêdêŋ to lau sec su êtômgeŋ biŋŋanô me. ");
INSERT INTO jae_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Embe lau gêdêŋ 50 sêŋgôŋ malac tau, oc gobe onseŋ malac su amboac tonaŋgeŋ me ôsuc malac ŋasec ôkwi êtu lau 50, taŋ sêŋgôŋ malac naŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ônac jaê biŋ amboac tonaŋ, aôm ôŋgôm gêŋ amboac tonec gebe onseŋ lau gêdêŋ sêwiŋ lau sec naŋ atom. Embe ôŋgôm, ŋacgêdêŋ oc êndac êtôm ŋac sec. Ônac jaê biŋ amboac tonaŋ. Ŋac-kêmêtôc-nomwaga êmêtôc naêndêŋ-geŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ma Apômtau kêsôm gebe “Aê embe jatap lau gêdêŋ 50 sa sêŋgôŋ malac Sodom, oc jasuc malac samucgeŋ ŋabiŋ ôkwi êtu êsêacŋa.” ");
INSERT INTO jae_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham gêjô eŋ awa gebe “Aêma katôm kekop to wao, mago katoc tauc sa gebe janam biŋgalôm jawiŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Moae lau gêdêŋ 50 solop atom, moae lemeŋ teŋ masi. Aôm gobe onseŋ êsêac su êtu lemeŋ teŋ masiŋa me.” Ma eŋ kêsôm gebe “Aê embe jatap 45geŋ sa, oc janseŋ êsêac su atom.” ");
INSERT INTO jae_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham awa gêjac eŋ kêtiam ma kêsôm gebe “Moae ôtap 40geŋ sa aŋga ônê.” Eŋ gêjô eŋ awa gebe “Êtu 40ŋa aê gabe jaŋgôm gêŋ tau ŋanô êsa atom.” ");
INSERT INTO jae_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Go Abraham kêsôm gebe “Apômtau, ôlic aê sec atom, aê jasôm biŋ teŋ êwiŋ. Moae ôtap 30geŋ sa aŋga ônê.” Eŋ gêjô eŋ awa gebe “Aê embe jatap 30geŋ sa, oc jaŋgôm gêŋ tau ŋanô êsa atom.” ");
INSERT INTO jae_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham kêsôm gebe “Op, aê katoc tauc sa gebe janam biŋgalôm jawiŋ Apômtau, moae ôtap 20geŋ sa aŋga ônê.” Eŋ gêjô eŋ awa gebe “Aê janseŋ êsêac su atom êtu 20geŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Go Abraham kêsôm gebe “O Apômtau, ôlic aê sec atom, aê jasôm biŋ tageŋ tonec êwiŋ. Moae ôtap 10geŋ sa aŋga ônê.” Eŋ gêjô eŋ awa gebe “Aê janseŋ êsêac su atom êtu 10geŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Apômtau gêjam biŋgalôm gêwiŋ Abraham e su ma gêc gêja. Ma Abraham tau gêmu gêja nê gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ma aŋela luagêc sêô lasê Sodom gêdêŋ kêtulala. Lot gêŋgôŋ malac ŋasacgêdô. Eŋ gêlic êsêagêc ma gêdi sa gebe êpuc êsêagêc tôŋtôŋ ma gewec laŋôanô jagêdêŋ nom ");
INSERT INTO jae_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ma kêsôm gebe “O apômtauagêc, aê jateŋ amagêc gebe anam nêm lêŋ ôkwi api nêm sakiŋwaganê andu. Akwasiŋ emkaiŋ to anêc bêc. Êndêŋ bêbêc kanucgeŋ, go andi ma asêlêŋ nêm intêna.” Mago êsêagêc sêsôm gebe” Masi, aêagêc anêc malacluŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mago eŋ kêkac êsêagêc ŋapaŋ, tec agêc sêjam nêŋ lêŋ ôkwi sêwiŋ eŋ sêpi ênê andu. Ma Lot kêmasaŋ moasiŋ gêdêŋ êsêagêc to kêpac polom ŋaluc ma agêc seŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Êsêagêc sêc bêc atom tageŋ ma ŋacwaga malacm, ŋacwaga aŋga Sodom tau, wakuc to laŋgwa sêwiŋ tauŋ. Lau samob tomalageŋ sêgi andu tau auc. ");
INSERT INTO jae_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ma êsêac sêmôêc Lot ma sêsôm gebe “Ŋacwaga, taŋ sêô lasê aôm gêdêŋ gêbêc naŋ, sêmoa ondoc. Ôkôc êsêagêc sêsa sêndêŋ aêac sêmêŋmaŋ gebe ajala êsêagêc.” ");
INSERT INTO jae_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Go Lot kêsa gêdêŋ êsêac gêja gê katam gêc muŋa ");
INSERT INTO jae_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ma kêsôm gebe “O lasitêwaiac, aŋgôm sec amboac tonaŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Alicgac me, latucoagêc sêmoa, taŋ sêjam kauc ŋacwaga. Aê gabe jakêŋ êsêagêc sêndêŋ amac. Aŋgôm êsêagêc amboac têmtac gêwiŋ. Mago aŋgôm ŋaclagêc tonaŋ sec atom, gebe êsêagêc sêsô ŋoc salôm ŋalabu sugac.” ");
INSERT INTO jae_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mago êsêac sêsôm gebe “Aôm ôêc su.” Ma sêsôm gebe “Ŋac tonec gêô lasê amboac ŋac jaba ma galoc ketoc tau sa gebe êtu ŋac-êmêtôc-biŋwaga. Amboac tonaŋ, aêac aŋgôm aôm sec êlêlêc êsêagêc su.” Ma êsêac guluc-gulucgeŋ sebe sêkôc Lot tôŋ ma sebe têtuc katam popoc. ");
INSERT INTO jae_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mago ŋaclagêc sêmêtôc lemeŋ ma sê Lot kêsô andu gêdêŋ êsêagêc gêja ma sêsaŋ katam auc. ");
INSERT INTO jae_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma sêgôm ŋacwaga sauŋ to kapôêŋ, taŋ sêmoa katam dêmôêŋa naŋ, mateŋpec kêsa e seso katam elêmê. ");
INSERT INTO jae_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Go ŋaclu sêsôm gêdêŋ Lot gebe “Aômnêm lau ŋagêdô sêmoa tonec me masi. Aômnêm lawami to latômio ma nêm lau, ŋagêdô, taŋ sêmoa malac naŋ, ôwê êsêac awi malac tonec Siŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Gebe aêagêc abe anseŋ malac tonec su gebe Apômtau gêŋô êsêacnêŋ biŋ gêjam sêga ma kêsakiŋ aêagêc gebe anseŋ êsêac su.” ");
INSERT INTO jae_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ma Lot kêsa gêja ma kêsôm gêdêŋ lawai, taŋ sebe sênam latuoagêc gebe “Ajôc, awi malac tonec siŋ gebe Apômtau oc enseŋ su.” Mago lawai sêlic eŋ amboac ŋac kêsôm biŋ makic teŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gêu bôŋ ma aŋela sêkac Lot ma sêsôm gebe “Ôndi, ôkôc nêm awê to latômoagêc, taŋ sêmoa tonec naŋ, gebe ŋagêjô, taŋ êtap malac sa naŋ, enseŋ aôm su ôwiŋ atom.” ");
INSERT INTO jae_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot kêlênageŋ, tec ŋaclu sêkam êsêagêc nê awê to latuoagêc lemeŋ gebe Apômtau gebe ênam êsêac sa ma sêwê eŋ gêwi malac siŋ ma sêkêŋ eŋ kêlêwaŋ tau gêŋgôŋ malac ŋamagê. ");
INSERT INTO jae_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Êsêagêc sêkêŋ êsêac sêmoa awê ma sêsôm gebe “Ôêc ônam katôm kêsi, ôkac taôm ôkwi atom to ôkô ôniŋ awam aŋga gaboaŋ tonec atom. Ôêc ôpi lôc ôna gebe ônaŋa atom.” ");
INSERT INTO jae_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mago Lot kêsôm gêdêŋ êsêagêc gebe “O apômtauagêc, masianô. ");
INSERT INTO jae_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Amagêc amoasiŋ nêm sakiŋwaga ma taêm walô aê tec ajam aê kêsi gebe janaŋa atom. Mago aê katôm gebe jaêc japi lôc atom. Gêŋwapac oc êtap aê sa ma jamac êndu. ");
INSERT INTO jae_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Alic acgom, malac tônê gêc ŋagala kêtôm gebe jaêc jana tônê, ma malac tau sauŋanô. Ôlôc sa gebe jaêc jana tônê. Malac tau sauŋanô atom me. Jaêc jana tônê, go jamoa matoc jali.” ");
INSERT INTO jae_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Apômtau kêsôm gêdêŋ eŋ gebe “Amboac tonaŋ, aê gabe jalôc sa ma janseŋ malac, taŋ kôsôm ŋabiŋ naŋ, su atom. ");
INSERT INTO jae_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","bêc ôna tônê ŋagaôgeŋmaŋ. Aê jaŋgôm gêŋ teŋ ŋagaô atom e ô lasê malac tônê su acgom.” Kêtu tonaŋŋa sêsam malac ŋaê gebe Soar. ");
INSERT INTO jae_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Oc kêpi kêpô nom ma Lot gêô lasê Soar. ");
INSERT INTO jae_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Go Apômtau kêkêŋ talao to ja aŋga undambê gêjac Sodom to Gomora aŋga Apômtaunê. ");
INSERT INTO jae_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ma eŋ geseŋ malac tonaŋ to gamêŋ gaboaŋ ma malac to ŋalau pebeŋ to gêŋ, taŋ kêpi aŋga nom naŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mago Lotnê awê, taŋ kêdaguc eŋ naŋ, kêkac tau ôkwi, tec kêtu pocgwêc. ");
INSERT INTO jae_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ma bêbêc kanucgeŋ Abraham gêdi ma jakêsa gamêŋ, taŋ eŋ kêkô Apômtau laŋônêmŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ma mata gê Sodom to Gomora ma gamêŋ gaboaŋŋa samob ma gêlic jadauŋ kêpi amboac ja geŋ kôm. ");
INSERT INTO jae_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Gêdêŋ taŋ Anôtô geseŋ malac gaboaŋŋa su naŋ, eŋ taê gêjam Abraham ma gêwê Lot gêc gamêŋ, taŋ gêjaŋa naŋ su. Biŋ tau kêsa gêdêŋ Anôtô geseŋ malac, taŋ Lot gêŋgôŋ naŋ su. ");
INSERT INTO jae_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ma Lot gêwi Soar siŋ jakêpi lôc gêwiŋ latuoagêc gebe eŋ kêtêc tau, tec gêwi Soar siŋ. Ma eŋ gêwiŋ latuoagêc jasêŋgôŋ pocgêsuŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ma awêsêga kêsôm gêdêŋ awê sauŋ gebe “Tameŋi kêtu ŋamalacanô sugac ma ŋac teŋ gêmoa nom tonec atom gebe êmoa êwiŋ aêagêc amboac sêgôm-sêgôm kêtôm gamêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ajôc, aêagêc takêŋ wain êndêŋ tameŋi ênôm e êjaŋiŋ eŋ, go tanêc dawiŋ eŋ gebe nêŋ wakuc sêsa aŋga tameŋinê.” ");
INSERT INTO jae_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tec gêdêŋ gêbêc sêkêŋ wain gêdêŋ tameŋi gênôm e kêjaŋiŋ eŋ. Ma awêsêga kêsô gêja gêc gêwiŋ tama. Gêc gêwiŋ eŋ ma gêdi sa, mago tama kêsaê atom. ");
INSERT INTO jae_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ŋageleŋ awêsêga kêsôm gêdêŋ awê sauŋ gebe “Gêdêŋ gêbêc aê gaêc gawiŋ tamoc ma êndêŋ êmbêc takêŋ wain êndêŋ eŋ ênôm êtiam. Su, go aôm ôsô naônêc ôwiŋ eŋ gebe tatap nêŋ wakuc sa aŋga tameŋinê.” ");
INSERT INTO jae_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tec gêdêŋ gêbêc sêkêŋ wain gêdêŋ tameŋi e kêjaŋiŋ eŋ kêtiam. Ma awê sauŋ gêdi jagêc gêwiŋ eŋ. Gêc gêwiŋ eŋ ma gêdi sa, mago tama kêsaê atom. ");
INSERT INTO jae_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tec Lot latuoagêc lulugeŋ taêŋ aŋga tameŋinê. ");
INSERT INTO jae_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ma awêsêga kêkôc ŋapalê ŋac ma gê ênê ŋaê gebe Moab. Eŋ kêtu lau Moab têm galocŋa nêŋ abeŋi. ");
INSERT INTO jae_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma awê sauŋ kêkôc ŋapalê ŋac amboac tonaŋgeŋ ma gê ênê ŋaê gebe Ben-Ami. Eŋ kêtu lau gamêŋ Amonŋa têm galocŋa nêŋ abeŋi. ");
INSERT INTO jae_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham gêdi aŋga ônê kêsêlêŋ kepeŋ gamêŋ Negebgeŋ ma jagêŋgôŋ Kades to Sur ŋasawa. Eŋ gêmoa gamêŋ Gerar amboac ŋac jaba. ");
INSERT INTO jae_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ma Abraham kêsôm kêpi nê awê Sara gebe “Aê luco eŋ.” Ma kiŋ Gerarŋa, Abimelek, kêsakiŋ lau gebe sêkôc Sara. ");
INSERT INTO jae_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mago gêdêŋ gêbêc Anôtô gêsuŋ mê gêdêŋ Abimelek ma kêsôm gêdêŋ eŋ gebe “Ôlic taôm, aôm ômac êndu êtu awê, taŋ aôm kôkôc naŋŋa, gebe ŋac teŋ nê awê eŋgoc.” ");
INSERT INTO jae_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mago Abimelek kêdabiŋ eŋ atom tageŋ, tec kêsôm gebe “Apômtau, aôm gobe onseŋ lau tobiŋmê su me. ");
INSERT INTO jae_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham tau kêsôm gêdêŋ aê gebe ‘Aêŋoc luco eŋ.’ Ma awê tau kêsôm gebe ‘Ŋoc lucŋac eŋ.’ Aê gagôm gêŋ tau toŋoc ŋalêlôm ŋaŋêŋ ma tolemoc selecgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Go Anôtô kêsôm gêdêŋ eŋ gêdêŋ taŋ gêc mê naŋ, gebe “Aec, aê kajala gebe gôgôm gêŋ tau tonêm ŋalêlôm ŋaŋêŋgeŋ tec aê tauc gabôc aôm auc gebe ôŋgôm sec êndêŋ aê atom. Kêtu tonaŋŋa gajac jao aôm gebe ômoasac eŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Amboac tonaŋ ôkêŋ Abrahamnê awê êmu êna gebe eŋ propete teŋ. Ma eŋ eteŋ êtu aômŋa gebe ômoa matam jaligeŋ. Mago aôm embe ôkêŋ eŋ êmu êna atom, go ôjala gebe ômac êndu biŋŋanôgeŋ, aôm to nêm lau samob.” ");
INSERT INTO jae_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Gêdêŋ bêbêc kanucgeŋ Abimelek gêdi sa ma gêmôêc nê sakiŋwaga samob ma gêjac miŋ biŋ samob tonaŋ ŋai gêdêŋ êsêac e têtêc tauŋ ŋanô. ");
INSERT INTO jae_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Go Abimelek kêkalem Abraham ma kêsôm gêdêŋ eŋ gebe “Aôm gôgôm asageŋ gêdêŋ aê. Aê gagôm aôm sec amboac ondoc, tec kôsabi sec kapôêŋ kêpi aê to ŋoc gamêŋ kiŋŋa. Gêŋ, taŋ sêjac jao gebe daŋgôm atom naŋ, aôm gôgôm gêdêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ma Abimelek kêsôm gêdêŋ Abraham gebe “Aôm taêm gêjam biŋ amboac ondoc, tec gôgôm gêŋ amboac tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ma Abraham kêsôm gebe “Aê gajam kauc gebe lau gamêŋ tonecŋa têtêc Anôtô atom, tec êsêac sênac aê êndu êtu ŋoc awêŋa, tec gagôm gêŋ tau. ");
INSERT INTO jae_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ma eŋ aêŋoc luco biŋŋanôgeŋ, gebe eŋ tamocnê latuo, mago tinocnê latuo atom. Ma eŋ kêtu ŋoc awê. ");
INSERT INTO jae_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Gêdêŋ taŋ Anôtô kêkalem aê ma gawi tamocnê andu siŋ naŋ, kasôm gêdêŋ eŋ gebe Aôm embe têmtac êwiŋ aê, go ôwa aê ŋam sa ma ôsôm êndêŋ lau gamêŋ samobŋa gebe ‘Ŋoc lucŋac eŋ.’” ");
INSERT INTO jae_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Go Abimelek kêkôc domba to bulimakao ma sakiŋwagao to ŋac ma kêkêŋ gêdêŋ Abraham ma kêkêŋ Sara gêmu gêdêŋ eŋ gêja. ");
INSERT INTO jae_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ma Abimelek kêsôm gebe “Gôlicgac, ŋoc gamêŋ gêc laŋômnêmŋa, ôŋgôŋ gamêŋ, taŋ gêjac matamanô ŋajam naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma kêsôm gêdêŋ Sara gebe “Gôlicgac, aê kakêŋ silber 1,000 gêdêŋ lômŋac gebe êwaka aôm waem sa êndêŋ lau samob, taŋ sêwiŋ aôm naŋ, ma sêlic aôm awê gêdêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Go Abraham keteŋ mec gêdêŋ Anôtô ma Anôtô gêgôm Abimelek ôli ŋajam kêsa ma gêgôm ênê awê to sakiŋwagao ôliŋ ŋajam kêsa amboac tonaŋgeŋ gebe sêkôc gôlôac êtiam, ");
INSERT INTO jae_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","gebe Apômtau gêbôc lauo, taŋ sêmoa Abimeleknê andu naŋ, têntaclêlôm auc kêtu Abrahamnê awê Saraŋa. ");
INSERT INTO jae_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Apômtau kêtu ŋacleŋ Sara amboac kêsôm su, ma gêgôm biŋ, taŋ gêjac mata naŋ, ŋanô kêsa kêpi Sara. ");
INSERT INTO jae_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraham kêtu ŋamalacanô su, go Sara taê ma kêkôc Abrahamnê latu-teŋ gêdêŋ noc, taŋ Anôtô kêsam gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham gê latu, taŋ kêka lasê ma Sara kêkôc eŋ naŋ, nê ŋaê gebe Isak. ");
INSERT INTO jae_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaknê bêc kêtu 8 ma Abraham kêsa latu amboac Anôtô kêjatu eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamnê jala kêtu 100 ma Isak mêŋkêsa. ");
INSERT INTO jae_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ma Sara kêsôm gebe “Anôtô gêgôm aê kaômac. Lau, taŋ sêŋô biŋ tau ŋawae, oc sêômac sêwiŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma eŋ kêsôm gebe “Asa oc kêjala kêtu tôŋ ma êsôm êndêŋ Abraham gebe Sara oc êkêŋ su êndêŋ ŋapalê dedec sênôm. Mago aê kakôc ênê latu gêdêŋ taŋ eŋ kêtu ŋamalacanô sugac.” ");
INSERT INTO jae_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma ŋapalê kêtu kapôêŋ e gêwi tênanê su siŋ. Ma gêdêŋ bêc Isak gêwi tênanê su siŋ naŋ, Abraham geno moasiŋ kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma Sara gêlic awê Aiguptuŋa Hagar, nê latu, taŋ Abraham kêka lasê naŋ, gêjam dôa-dôa gêwiŋ latu Isak. ");
INSERT INTO jae_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tec kêsôm gêdêŋ Abraham gebe “Ôtiŋ sakiŋwagao tonec nê latu su gebe sakiŋwagao tonec nê latu êwê kaiŋ gêŋlênsêm êwiŋ latuc Isak atom.” ");
INSERT INTO jae_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mago Abrahamnê ŋalêlôm ŋawapac kêtu latuŋa. ");
INSERT INTO jae_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mago Anôtô kêsôm gêdêŋ Abraham gebe “Nêm ŋalêlôm ŋawapac êtu ŋapalê tau to nêm sakiŋwagaoŋa atom. Ôŋgôm biŋ samob, taŋ Sara kêsôm naŋ, ŋanô êsa gebe sêsam nêm wakucnêŋ ŋaê sêndaŋguc Isaknê ŋaêgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma aê jaŋgôm sakiŋwagaonê latunê wakuc têtu laum kapôêŋ teŋ amboac tonaŋ, gebe eŋ kêsa aŋga aômnêm.” ");
INSERT INTO jae_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tec Abraham gêdi gêdêŋ bêbêc kanucgeŋ ma kêkôc polom to bu kêsêp bôc ŋaôlic ma kêkêŋ gêdêŋ Hagar gêôc gêwiŋ ŋapalê ma kêsakiŋ eŋ gêja. Ma eŋ jakêlêsa gêmoa gamêŋ sawa aŋga Ber-Seba. ");
INSERT INTO jae_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Gêdêŋ taŋ bu kêpa aŋga bôc ŋaôlic naŋ, eŋ gêwi ŋapalê siŋ gêc gamêŋ dani. ");
INSERT INTO jae_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ma eŋ jagêŋgôŋ sic aŋga ŋasawa kêtôm ŋac talamŋa êpê nê sôb naêsêpŋa ma taê gêjam gebe “Aê jalic ŋapalê êmac êndu êndêŋ aê matocanô atom.” Eŋ gêŋgôŋ kêkanôŋ eŋ ma ŋapalê awa kêpi ma kêtaŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Anôtô gêŋô ŋapalê kêtaŋ ma Anôtônê aŋela awa gêjac Hagar aŋga undambê ma kêsôm gêdêŋ eŋ gebe “Asageŋ gêgôm aôm, Hagar. Ôtêc taôm atom gebe Anôtô gêŋô ŋapalê awa aŋga gamêŋ naŋ ");
INSERT INTO jae_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ôndi sa, ôsip eŋ sa ma ôkôc eŋ ŋajaŋa gebe aê gabe jakêŋ eŋ êtu laum kapôêŋ teŋ.” ");
INSERT INTO jae_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Go Anôtô gêgôm eŋ mata gêlac e gêlic bumata teŋ ma eŋ jakêkati bu kêsêp bôc ŋaôlic ma kêkêŋ gêdêŋ ŋapalê gênôm. ");
INSERT INTO jae_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ma Anôtô gêwiŋ ŋapalê ma eŋ kêtu kapôêŋ. Eŋ gêmoa gamêŋ sawa ma kêpê talam lêma kata sec. ");
INSERT INTO jae_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Eŋ gêmoa gamêŋ sawa Paran ma têna kêkôc ênê awê teŋ aŋga gamêŋ Aiguptu. ");
INSERT INTO jae_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Gêdêŋ ŋasawa tonaŋ Abimelek agêc nê siŋwaganêŋ ŋac ŋamataŋa Pikol sêsôm gêdêŋ Abraham gebe “Anôtô gêwiŋ aôm to nêm kôm samob. ");
INSERT INTO jae_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kêtu tonaŋŋa tec galoc ôtôc lêmam êndêŋ Anôtô matocanô jalic gebe ôŋgôm aê to ŋoc wakuc me wakucnêŋ wakuc sec atom. Aê kamoasiŋ aôm, amboac tonaŋ ôjô moasiŋ tonaŋ êndêŋ aê to êndêŋ gamêŋ, taŋ mêŋgômoa ŋac jabaŋageŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ma Abraham kêsôm gebe “Aê gabe jatôc lemoc.” ");
INSERT INTO jae_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ma Abraham kêtôc biŋ Abimelek kêtu bumata teŋ, taŋ Abimeleknê sakiŋwaga sêjaŋgo su naŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma Abimelek kêsôm gebe “Aê gajam kauc lau, taŋ sêgôm gêŋ tonaŋ. Aôm kôsôm biŋ teŋ gêdêŋ aê atom, ma aê gaŋô biŋ teŋ atom e mêŋgêdêŋ galoc.” ");
INSERT INTO jae_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tec Abraham kêkôc domba to bulimakao ma kêkêŋ gêdêŋ Abimelek ma ŋac lu sêmoatiŋ poac teŋ gêdêŋ tauŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Go Abraham kêkêŋ domba ŋalatu 7 sêkô tauŋŋa ");
INSERT INTO jae_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","tec Abimelek kêtu kênac Abraham gebe “Domba ŋalatu 7, taŋ kôkêŋ sêkô tauŋŋa naŋ, ŋam amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eŋ kêsôm gebe “Ôkôc domba ŋalatu 7 tonaŋ su aŋga lemoc ec têtu ŋabelo êndêŋ aôm ôjala gebe aê tauc tec kakwê bumata tau.” ");
INSERT INTO jae_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kêtu tonaŋŋa sêsam gamêŋ tonaŋ gebe Ber-Seba gebe êsêagêc lulu têtôc lemeŋ. ");
INSERT INTO jae_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Êsêagêc sêmoatiŋ poac aŋga Ber-Seba su, go Abimelek agêc Pikol, ênê siŋwaganêŋ ŋac ŋamataŋa, dêdi ma sêmu sêja Pilistinêŋ gamêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Mago Abraham kêsê ka gamêŋ sawaŋa teŋ ŋaê gebe tamarisk aŋga Ber-Seba ma awa gêjac Apômtau Anôtô teŋgeŋ nê ŋaê. ");
INSERT INTO jae_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma Abraham gêmoa Pilistinêŋ gamêŋ ŋasawa ec ŋêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Gêŋ samob tonaŋ su acgom, go Anôtô kêsaê Abraham ma awa gêjac eŋ gebe “Abraham.” Ma eŋ kêsôm gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma Anôtô kêsôm gebe “Ôkôc nêm latôm tageŋ Isak, taŋ têmtac gêwiŋ eŋ naŋ, ma ôna gamêŋ Moria. Aŋga ônê ôkêŋ eŋ êtu daja aŋga lôc teŋ ŋatêpôê taŋ gabe jatôc êndêŋ aôm naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tec Abraham gêdi gêdêŋ bêbêc kanucgeŋ kêkôc nê doŋki mêŋkêpô ômbiŋkap kêsêp. Eŋ kêkôc sakiŋwaga wakuc luagêc sêwiŋ êsêagêc latu Isak. Eŋ gêga ka kêtu dajaŋa ma gêdi gêja gamêŋ, taŋ Anôtô kêsôm ŋabiŋ gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Gêdêŋ bêc kêtu têlêacŋa Abraham gêôc mataanô sa ma gêlic gamêŋ tau gêc jaêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Go Abraham kêsôm gêdêŋ nê sakiŋwagaagêc gebe “Amoa tonec awiŋ doŋki. Aêagêc ŋapalê ana ônê. Ateŋ mec su acgom, go amu amêŋ êtiam.” ");
INSERT INTO jae_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ma Abraham kêkêŋ ka dajaŋa gêdêŋ latu Isak gêôc. Ma eŋ tau gegeŋ ja ma kêmêgôm bôjaŋ. Ma agêc sêsêlêŋ sêwiŋ tauŋ sêja. ");
INSERT INTO jae_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ma Isak awa gêjac tama Abraham gebe “Tamoc.” Ma eŋ kêsôm gebe “Latucenec, aê tec gamoa.” Ma eŋ kêsôm gebe “Ja to ka tec gêc, mago domba dajaŋa gêmoa ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ma Abraham kêsôm gebe “Latucenec, Anôtô tau oc ênsuŋ domba dajaŋa.” Ma agêc sêsêlêŋ sêwiŋ tauŋ sêja. ");
INSERT INTO jae_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Agêc sêô lasê gamêŋ, taŋ Anôtô kêsôm ŋabiŋ gêdêŋ eŋ naŋ, ma Abraham gêboa altar sa ma gêjac pac ka. Go gêsô latu Isak tôŋ ma ketoc eŋ gêsac altar topac ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Go Abraham kêmêtôc lêma gebe êkôc bôjaŋ ma êmbuc latu. ");
INSERT INTO jae_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mago Apômtaunê aŋela gêmôêc eŋ aŋga undambê ma kêsôm gebe “Abraham, Abraham.” Ma eŋ gêlôc gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ma eŋ kêsôm gebe “Lêmam êndêŋ ŋapalê atom ma ôŋgôm gêŋ teŋ êndêŋ eŋ atom, gebe aê galic aôm kôtêc Anôtô ma kôgamiŋ nêm latôm tageŋ gêdêŋ aê atom.” ");
INSERT INTO jae_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ma Abraham gêôc mataanô sa e gêlic domba kapoac teŋ kêkô eŋ dêmôêmu ŋajabo gêjac kêsô odani. Tec Abraham gêja ma kêkôc domba kapoac jakêkêŋ kêtu daja gêjô latu su. ");
INSERT INTO jae_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham kêsam gamêŋ tonaŋ ŋaê gebe “Apômtau gebe ênam sa êndêŋ ŋanoc,” amboac sêsôm-sêsôm e mêŋgêdêŋ galoc gebe “Aŋga lôc Apômtau gebe ênam sa êndêŋ ŋanocŋa.” ");
INSERT INTO jae_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Go Apômtaunê aŋela gêmôêc Abraham aŋga undambê kêtu dim luagêcŋa ");
INSERT INTO jae_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ma kêsôm gebe “Apômtau kêsôm gebe ‘Aôm gôgôm tonaŋ ma kôgamiŋ nêm latôm naŋ atom, tec katôc lemoc kêpi tauc gebe ");
INSERT INTO jae_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","janam mec aôm biŋŋanôgeŋ, ma nêm wakuc têtu taêsam têtôm utitalata umboŋ ŋalabuŋa to têtôm gaŋac gwêcŋa. Ma nêŋ ŋacjonêŋ malac ŋasacgêdô êtu nêm wakucnêŋ. ");
INSERT INTO jae_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ma êtu nêm wakucŋa laum nomŋa samob têtap moasiŋ sa kêtu taŋam wamu aêŋa.’” ");
INSERT INTO jae_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Amboac tonaŋ Abraham gêmu gêdêŋ nê sakiŋwagaagêc gêja ma ac dêdi sêwiŋ tauŋ sêja Ber-Seba. Ma Abraham gêŋgôŋ Ber-Seba kêtu têlê. ");
INSERT INTO jae_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Gêŋ samob tonaŋ su acgom, go biŋ gêdêŋ Abraham gebe “Gôlicgac, Milka kêkôc gôlôac amboac tonaŋ kêtu lasim Nahorŋa.” ");
INSERT INTO jae_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ŋacsêga Us agêc lasi Bus ma Kemuel, taŋ kêtu Aram tama ");
INSERT INTO jae_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ma Kesed, Haso, Pildas, Jidlap to Betuel ");
INSERT INTO jae_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel kêtu Rebeka tama. Lau 8 tonaŋ Milka kêkôc gêdêŋ Abraham lasi Nahor. ");
INSERT INTO jae_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma Milka anao, nê ŋaê gebe Reuma, kêkôc Teba, Gaham, Tahas to Maka. ");
INSERT INTO jae_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara gêmoa e nê jala kêtu 127. Saranê jala tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ma Sara gêmac êndu aŋga Kiriat-Arba (ŋaê teŋ gebe Hebron) aŋga gamêŋ Kanaan. Ma Abraham kêsô gebe êpuc taŋiboa sa ma êtaŋ êtu Saraŋa. ");
INSERT INTO jae_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Su, go Abraham gêdi gêwi nê ŋacmatê siŋ ma kêsôm gêdêŋ lau gamêŋ Hetŋa gebe ");
INSERT INTO jae_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Aê ŋac jaba to ŋac ŋasawaŋa mêŋgaŋgôŋ gawiŋ amac. Akêŋ nêm gamêŋ teŋ êndêŋ aê jawê kaiŋ êtu gamêŋ sêôŋa gebe jansuŋ ŋoc ŋacmatê ênêc.” ");
INSERT INTO jae_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Lau gamêŋ Hetŋa sêjô Abraham awa gebe ");
INSERT INTO jae_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“O apômtau, ôkêŋ taŋam ma biŋ. Aôm gômoa gôwiŋ aêac amboac kasêga towae teŋ. Ônsuŋ nêm ŋacmatê êsêp ma sêô ŋajamanô tau. Aêacma ŋac teŋ êŋgamiŋ nê sêô êndêŋ aôm me êkô aôm auc êtu ônsuŋ nêm ŋacmatê êsêpŋa atom.” ");
INSERT INTO jae_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham gêdi ma gewec gêdêŋ lau gamêŋ Hetŋa, taŋ têtu gamêŋ ŋatau naŋ. ");
INSERT INTO jae_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ma eŋ kêsôm gêdêŋ êsêac gebe “Amac embe alic êtôm gebe jansuŋ ŋoc ŋacmatê ênêc, go akêŋ taŋem ŋoc biŋ ma ateŋ Sohar latu Epron ajô aê su ");
INSERT INTO jae_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","gebe êkêŋ pocgêsuŋ Mak-Pela, taŋ kêtu ênê gêŋ naŋ, êndêŋ aê. Gêsuŋ tau gêc kêsi ênê kôm ŋamadiŋ. Aê jakêŋ ŋaôli samucgeŋ êndêŋ eŋ jakô amac laŋômnêmŋa ma eŋ êkêŋ êtu aêŋoc gêŋ êtu jansuŋ ŋacmatê sêsêpŋa.” ");
INSERT INTO jae_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mago Epron tau gêŋgôŋ gêwiŋ lau gamêŋ Hetŋa ma ŋac Hetŋa Epron gêjô Abraham awa e lau Hetŋa taŋ sêmêŋ sêŋgôŋ malac ŋasacgêdô naŋ samob sêŋô ma kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“O apômtau, masianô. Ôŋô ŋoc biŋ. Aê jakêŋ kôm to jakêŋ ŋapocgêsuŋ, taŋ gêc kôm tau naŋ, ŋaômageŋ êndêŋ aôm. Aê kakô ŋoc lau laŋôŋnêmŋa, tec jakêŋ gêŋ tau ŋaômageŋ êndêŋ aôm. Ônsuŋ nêm ŋacmatêmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Go Abraham gewec gêdêŋ gamêŋ ŋatau. ");
INSERT INTO jae_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ma eŋ kêsôm gêdêŋ Epron e gamêŋ ŋatau sêŋô sêwiŋ gebe “Aê jateŋ aôm gebe ôkêŋ taŋam aê. Aê jakêŋ kôm ŋaôli êndêŋ aôm. Ôkôc ŋaôli aŋga aê lemoc gebe jansuŋ ŋoc ŋacmatê aŋga tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron gêjô Abraham awa gebe ");
INSERT INTO jae_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“O apômtau, ôŋô ŋoc biŋ. Aêagêc tasôm biŋ taêsam êpi gamêŋ, taŋ ŋaôli amboac dôŋ silberŋa 400geŋ naŋ, êtu ageŋŋa. Ônsuŋ nêm ŋacmatêmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham gêlôc gêdêŋ Epron. Ma Abraham gêjam dôŋ silber gêdêŋ Epron, taŋ eŋ kêsam lau gamêŋ Hetŋa sêŋô naŋ, dôŋ silberŋa 400. Eŋ gêjam dôŋ kêtôm lau-têtulu-gêŋwaga sêjam dôŋ gêdêŋ tauŋ. ");
INSERT INTO jae_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Amboac tonaŋ Epronnê kôm Mak-Pela, taŋ gêc Mamre ŋagamêŋ gêmu oc kêpiŋa naŋ, kôm to ŋapocgêsuŋ ma gêŋkaiŋ, taŋ kêkô kôm ŋagamêŋ samucgeŋ auc naŋ, ");
INSERT INTO jae_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kêtu Abrahamnê. Lau gamêŋ Hetŋa samob, taŋ sêô lasê ênê malac ŋasacgêdô naŋ, sêlic. ");
INSERT INTO jae_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Su, go Abraham kêsuŋ nê awê Sara kêsêp pocgêsuŋ, taŋ gêc kôm Mak-Pela naŋ, gêc Mamre (ŋaê teŋ gebe Hebron) ŋagamêŋ oc kêpiŋa aŋga gamêŋ Kanaan. ");
INSERT INTO jae_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lau gamêŋ Hetŋa sêkêŋ kôm to ŋapocgêsuŋ tonaŋ kêtu Abrahamnê gêŋ gebe ênsuŋ ŋacmatê sêsêpŋa. sacgêdô gêc intênagêsuŋ. Gamêŋ tonaŋ kêtu êsêacnêŋ maleŋ sêkac saŋa. ");
INSERT INTO jae_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham kêtu ŋamalacanô sugac ma nê jala kêtu taêsam. Ma Apômtau gêjam mec Abrahamnê gêŋ samob. ");
INSERT INTO jae_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ma Abraham kêsôm gêdêŋ nê sakiŋwaga ŋamataŋa, taŋ gejob ênê gêŋ samob naŋ, gebe “Ôkêŋ lêmam êsô lambic ");
INSERT INTO jae_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ma ôtôc lêmam êndêŋ Apômtau, taŋ kêtu undambê to nom ŋaAnôtô naŋ, gebe ôkêŋ awê teŋ êndêŋ latuc aŋga lau gamêŋ Kanaanŋa, taŋ gamoa êsêac ŋaluŋ naŋ, nêŋ ŋapalêonêŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Aôm ôna ŋoc malacmôkê ôndêŋ ŋoc lau naôkôc latuc Isak nê awê teŋ aŋga ônê.” ");
INSERT INTO jae_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma sakiŋwaga kêsôm gêdêŋ eŋ gebe “Amboac ondoc, awê tau embe endec ma êndaŋguc aê êmêŋ gamêŋ tonec atom, go jakôc latôm êmu êna gamêŋ, taŋ aôm gôwi siŋ naŋ, me.” ");
INSERT INTO jae_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham kêsôm gêdêŋ eŋ gebe “Ôlic taôm, ôkêŋ latuc êna ônê atom. ");
INSERT INTO jae_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Apômtau, Anôtô undambêŋa, taŋ gêwê aê aŋga tamocnê andu ma aŋga ŋoc gôlôacnêŋ gamêŋ naŋ, gêjam biŋgalôm gêwiŋ aê ma kêtôc lêma gebe Aê gabe jakêŋ gamêŋ tonec êndêŋ nêm wakuc. Eŋ oc êsakiŋ nê aŋela êmuŋ aôm ma aôm ôkôc latucnê awê teŋ aŋga ônê. ");
INSERT INTO jae_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mago awê tau embe endec ma êndaŋguc aôm atom, go biŋ, taŋ ôtôc lêmam naŋ ênêcŋa. Mago ôkêŋ latuc êmu êna ônê êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Go sakiŋwaga kêkêŋ lêma kêsô nê ŋatau Abraham lambi ma kêtôc lêma gebe êŋgôm ênê biŋ ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Go sakiŋwaga kêkôc nê ŋataunê kamele 10 to nê ŋataunê gêlôŋ ma awa tokaiŋ-tokaiŋ ma gêdi gêja. Eŋ kêsêlêŋ gêja Mesopotamia e gêô lasê Nahornê malac. ");
INSERT INTO jae_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Eŋ kêkêŋ kamele sêlêwaŋ tauŋ aŋga bumaŋ, taŋ kêpoac malac ŋagala naŋ, gêdêŋ kêtula, gêdêŋ têm, taŋ lauo sêsa gebe têtê buŋa. ");
INSERT INTO jae_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ma eŋ kêsôm gebe “O Apômtau, ŋoc ŋatau Abraham nê Anôtô, aê jateŋ aôm gebe ôlôc gebe jatap kôm ŋanô sa ma ôwaka nêm têmtac gêwiŋ ŋoc ŋatau Abrahamŋa sa. ");
INSERT INTO jae_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ôlic acgom, aê mêŋkakô bumata ŋatali ma malacm latuŋio oc sêsa mêŋtêtê. ");
INSERT INTO jae_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ŋapalêo, taŋ jasôm biŋ êndêŋ eŋ gebe ‘Ôlêwaŋ ku gebe mêŋjanôm bu’ naŋ, embe êsôm gebe ‘Wacônôm ma jakêŋ bu êndêŋ nêm kamele sênôm amboac tonaŋgeŋ,’ naŋ jajala gebe tecenec aôm kôjaliŋ sa kêtu nêm ŋacsakiŋ Isakŋa. Biŋ tonaŋ êtu ŋabelo êndêŋ aê e jajala gebe kôwaka têmtac gêwiŋ ŋoc ŋatauŋa sa.” ");
INSERT INTO jae_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Eŋ kêsôm biŋ gêmoa, tec Rebeka kêsa gêôc nê ku buŋa. Eŋ Betuel, taŋ Abraham lasi Nahor nê awê Milka kêkôc naŋ, latuo eŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ŋapalêo tau laŋô ŋajamanô, eŋ awêtakiŋ teŋ, naŋ kêtap ŋac teŋ sa atom tageŋ. Eŋ kêsêp bumata jakêtê bu su ma kêpi gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Go sakiŋwaga kêlêti gebe êpuc eŋ tôŋtôŋ ma kêsôm gebe “Aê gabe jateŋ aôm ôkêŋ bu ŋagec mêŋjanôm aŋga nêm ku.” ");
INSERT INTO jae_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Eŋ kêsôm gebe “Ŋoc ŋatau, ônômmaŋ.” Ma sebeŋ kêlêwaŋ ku kêsêp lêma ma kêkêŋ bu gêdêŋ eŋ gênôm. ");
INSERT INTO jae_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kêkêŋ bu gêdêŋ eŋ gênôm, go kêsôm gebe “Aê jatê bu mêŋjakêŋ êndêŋ nêm kamele sênôm e êôc êsêac tôŋ êwiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Amboac tonaŋ eŋ kêkêc bu kêsêp bôcnêŋ suc kêtê-kêtê bu gêja gêmu mêŋkêkêŋ gêdêŋ kamele samob sênôm. ");
INSERT INTO jae_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ma ŋac tau kêsala eŋ ŋabiŋmêgeŋ gebe êjala Apômtau oc gêjam gôliŋ ênê lêŋ me masi. ");
INSERT INTO jae_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamele sênôm bu e kêtôm, go ŋac kêkôc gêlôŋ goldŋa teŋ, gold tau ŋawapac kêtôm gold ŋadôŋ ŋamakeŋ ma joc luagêc, taŋ ŋawapac kêtôm gold ŋadôŋ 10ŋa ");
INSERT INTO jae_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ma kêsôm gebe “Asanê latuo aôm. Ôsôm acgom, ŋasawa gêc tamamnê andu êtôm aêac anêcŋa me masi.” ");
INSERT INTO jae_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Eŋ gêjô eŋ awa gebe “Milka agêc Nahor latuŋi Betuel latuo aê.” ");
INSERT INTO jae_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma kêsôm biŋ ŋagêdô gêdêŋ eŋ gêwiŋ gebe “Oba to gêgwaŋ taêsam tê gêc to gamêŋ kêtôm gebe anêcŋa tê gêc.” ");
INSERT INTO jae_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ŋac tau gewec ma awa gêôc Apômtau ");
INSERT INTO jae_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","e kêsôm gebe “Aê jalambiŋ Apômtau, ŋoc ŋatau Abraham nê Anôtô, taŋ kêgamiŋ nê têtac gêwiŋ to biŋ ŋaŋêŋ gêdêŋ ŋoc ŋatau atom. Ma Apômtau gêwê aê katôgeŋ gadêŋ ŋoc ŋataunê lasitêwainêŋ andu.” ");
INSERT INTO jae_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ma ŋapalêo kêlêti jagêjac miŋ biŋ tonaŋ gêdêŋ tênanê lau. ");
INSERT INTO jae_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekanê luŋac teŋ gêmoa, ênê ŋaê gebe Laban. Ma Laban kêlêti gêja bumata gêdêŋ ŋac tau. ");
INSERT INTO jae_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Eŋ gêlic gêlôŋ to joc, taŋ luo kêka naŋ, ma gêŋô biŋ, luo kêsôm gebe Ŋac tau kêsôm biŋ amboac tonec gêdêŋ aê. Tec eŋ kêlêti gêdêŋ ŋac tau gêja ma kêtap eŋ sa kêkô bumata gêwiŋ nê kamele. ");
INSERT INTO jae_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ma eŋ kêsôm gebe “O ŋatau, taŋ Apômtau gêjam mec naŋ, kôkô awê kêtu asageŋŋa. Ôsô ômôêŋmaŋ, aê kamasaŋ andu su to gamêŋ kêtu kameleŋa.” ");
INSERT INTO jae_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Amboac tonaŋ ŋac tau kêsô andu gêja ma Laban kêkôc kamelenêŋ waba su ma kêkêŋ oba to gêgwaŋ gêdêŋ kamele. Go kêkôc bu gebe Abrahamnê sakiŋwaga to nê lau sêkwasiŋ eŋkaiŋ êsêpŋa, ");
INSERT INTO jae_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","go sêkêŋ gêŋ taniŋŋa gêdêŋ sakiŋwaga gebe êniŋ. Mago kêsôm gebe” Aê janiŋ gêŋ teŋ atom, aê jawa ŋoc biŋ sa êmuŋ acgom.” Laban kêsôm gebe “Amboac tonaŋ ôsômmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tec eŋ gêwa tau sa gebe “Abrahamnê sakiŋwaga aê. ");
INSERT INTO jae_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Apômtau gêjam mec ŋoc ŋatau ŋanôgeŋ e kêtu kapôêŋ. Eŋ kêkêŋ domba to bulimakao ma silber to gold ma sakiŋwagao to ŋac ma kamele to doŋki gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma ŋoc ŋataunê awê Sara nê jala kêtu taêsam su ma kêkôc latu teŋ ma ŋoc ŋatau kêkêŋ gêŋlênsêm samob gêdêŋ eŋ gêwê kaiŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma eŋ kêsôm gêdêŋ aê gebe jatôc lemoc ma kêsôm gebe ‘Aôm ôkôc latucnê awê teŋ aŋga lau Kanaanŋa, taŋ aê gamoa nêŋ gamêŋ naŋ, latuŋionêŋ atom, ");
INSERT INTO jae_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","aôm ôndêŋ tamocnê andu to ŋoc lasitêwai ôna ma ôkôc latucnê awê teŋ aŋga ônê.’ ");
INSERT INTO jae_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Aê kasôm gêdêŋ ŋoc ŋatau gebe ‘Awê embe êndaŋguc aê atom, go amboac ondoc.’ ");
INSERT INTO jae_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tec eŋ kêsôm gêdêŋ aê gebe ‘Apômtau, taŋ kasêlêŋ gamoa eŋ laŋônêm naŋ, êsakiŋ nê aŋela êwiŋ aôm to ênam gôliŋ nêm lêŋ e aôm ôkôc latucnê awê aŋga ŋoc launêŋ to aŋga tamocnê andu. ");
INSERT INTO jae_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Embe ô lasê ŋoc lasitêwai ma êsêac sêkêŋ awê êndêŋ aôm atom, go biŋ, taŋ kôtôc lêmam naŋ ênêcŋa.’ ");
INSERT INTO jae_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ocsalô aê gaô lasê bumata ma kasôm gebe ‘O Apômtau, ŋoc ŋatau Abraham nê Anôtô aôm, galoc ônam gôliŋ ŋoc lêŋ, tec kasa nec. ");
INSERT INTO jae_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ôlic aê, galoc kakô bumata. Ŋapalêo, naŋ êsa êmêŋ gebe êtê bu ma jasôm biŋ êndêŋ eŋ gebe “Aê jateŋ aôm ôkêŋ bu ŋagec aŋga nêm ku mêŋjanôm,” ");
INSERT INTO jae_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ma embe êsôm êndêŋ aê gebe “Ônômmaŋ, ma aê gabe jatê êndêŋ nêm kamele amboac tonaŋ,” naŋ awê tecenaŋ êtu awê taŋ Apômtau kêjaliŋ eŋ sa kêtu ŋoc ŋataunê latuŋa.’ ");
INSERT INTO jae_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Aê taêc gêjam biŋ tonaŋ gêbacnê su atomgeŋ, tec Rebeka kêsa gêmêŋ gêôc nê ku jakêsêp bumata ma kêtê bu. Ma aê kasôm gêdêŋ eŋ gebe ‘Ôkêŋ bu mêŋjanôm.’ ");
INSERT INTO jae_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Eŋ sebeŋ kêlêwaŋ ku su ma kêsôm gebe ‘Ônômmaŋ, ma aê gabe jakêŋ bu êndêŋ nêm kamele sênôm amboac tonaŋgeŋ.’ Tec aê ganôm ma eŋ kêkêŋ bu gêdêŋ kamele sênôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Go aê katu kênac eŋ gebe’ Aôm asanê latuo.’ Eŋ kêsôm gebe ‘Nahor latu Betuel, taŋ Milka kêkôc eŋ naŋ, latuo aê.’ Tec aê kakêŋ gêlôŋ geŋ kaleŋ eŋ lususuŋ ma kakêŋ joc eŋ kêka. ");
INSERT INTO jae_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Go aê gawec ma aoc gêôc Apômtau ma kalambiŋ Apômtau, ŋoc ŋatau Abraham nê Anôtô, taŋ gêwê aê kasa intêna solop e katap ŋoc ŋataunê lasinê latuo sa kêtu ênê latuŋa. ");
INSERT INTO jae_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ma galoc amac embe têmtac êwiŋ ŋoc ŋatau ma atoc eŋ sa, go asôm ŋawae êndêŋ aê. Embe masi, go asôm amboac tonaŋgeŋ, ec jajala gebe anô ê aê me gasê ê aê.” ");
INSERT INTO jae_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Go Laban agêc Betuel sêjô eŋ awa gebe “Biŋ tonaŋ gêmêŋ aŋga Apômtaunê. Aêac atôm gebe asôm biŋ ŋajam me sec teŋ êndêŋ aôm atom. ");
INSERT INTO jae_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Gôlicgac, Rebeka kêkô aôm laŋômnêm, ôkôc eŋ ôna ma ôkêŋ eŋ êtu nêm ŋataunê latunê awê êtôm Apômtau kêsôm.” ");
INSERT INTO jae_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Gêdêŋ taŋ Abrahamnê sakiŋwaga gêŋô biŋ tonaŋ naŋ, eŋ gêu tau gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ma sakiŋwaga kêkôc gêlôŋ silber to gold ma ŋakwê jakêkêŋ gêdêŋ Rebeka. Ma kêkêŋ gêŋ mata êjamgeŋ gêdêŋ luŋac to têna amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ma eŋ to nê lau, taŋ sêwiŋ eŋ naŋ, seŋ to sênôm gêŋ ma gêdêŋ gêbêc tonaŋ sêc sêwiŋ êsêac. Ŋageleŋ êsêac dêdi sa ma eŋ kêsôm gebe “Asakiŋ aê jamu jandêŋ ŋoc ŋatau jana.” ");
INSERT INTO jae_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mago têna agêc lu sêsôm gebe “Ôlôc gebe ŋapalêo êmoa êwiŋ aêac bêc ŋagêdô amboac bêc 10 su, go aêc ana.” ");
INSERT INTO jae_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tageŋ eŋ kêsôm gebe “Akôc aê tôŋ atom gebe Apômtau gêjam gôliŋ ŋoc lêŋ. Asakiŋ aê, gebe jaêc jamu jandêŋ ŋoc ŋatau jana.” ");
INSERT INTO jae_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Êsêac sêsôm gebe “Aêac amôêc ŋapalêo to atu kênac eŋ tau.” ");
INSERT INTO jae_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ma êsêac sêmôêc Rebeka ma sêsôm gêdêŋ eŋ gebe “Aôm gobe ôwiŋ ŋac tonec me masi.” Eŋ kêsôm gebe “Aê gabe jawiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tec êsêac sêkêŋ luŋio agêc ênê jaomwagao to Abrahamnê sakiŋwaga to nê lau sêja. ");
INSERT INTO jae_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ma êsêac sêjam mec Rebeka ma sêsôm gêdêŋ eŋ gebe “O awêenec, ôtu lau taêsam teneŋi ma lau, taŋ sêkêŋ kisa nêm wakuc naŋ, nêŋ malac êtu nêm wakucnêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Go Rebeka to nê sakiŋwagao dêdi ma sêpi kamele ma têdaguc ŋac tau sêja. Amboac tonaŋ sakiŋwaga kêkôc Rebeka ma gêc gêja. ");
INSERT INTO jae_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ma Isak gêja gamêŋ, taŋ bumata Ber-Lahai-Roi kêpoac naŋ, jagêŋgôŋ gamêŋ Negeb. ");
INSERT INTO jae_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Gêdêŋ kêtula teŋ Isak kêsêlêŋ gêmoa kôm ŋalêlôm gebe taê ênam nê biŋ ŋagêdô e gêôc mataanô sa ma gêlic kamele sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ma Rebeka gêôc mataanô sa ma gêlic Isak. Tec kêsêp aŋga kamele ");
INSERT INTO jae_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ma kêsôm gêdêŋ sakiŋwaga gebe “Asa tê kêpuc aêac tôŋtôŋ nê.” Sakiŋwaga gêjô eŋ awa gebe “Ŋoc ŋatau tau tônê.” Tec eŋ kêkôc nê obo ma kêgêduc tau. ");
INSERT INTO jae_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ma sakiŋwaga gêjac miŋ biŋ samob, taŋ gêgôm naŋ, gêdêŋ Isak. ");
INSERT INTO jae_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Go Isak gêwê Rebeka kêsô têna Sara nê becobo gêja ma kêkôc eŋ kêtu ênê awê ma têtac gêwiŋ eŋ. Isak têna gêmac êndu, mago biŋ tonaŋ gêjam malô ênê ŋalêlôm. tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham gêjam awê teŋ, ênê ŋaê gebe Ketura. ");
INSERT INTO jae_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Eŋ kêkôc Simran, Joksan, Medan, Midian, Isbak to Sua. ");
INSERT INTO jae_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan kêka Seba agêc Dedan lasê. Dedan latui lau Asurim to Letusim ma Leumim. ");
INSERT INTO jae_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian latui tonec Epa, Eper, Hanok, Abida to Elda. Lau samob tonaŋ ŋai têtu Keturanê gôlôac. ");
INSERT INTO jae_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ma Abraham gêwi nê gêŋ samob siŋ gêdêŋ Isak. ");
INSERT INTO jae_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mago Abraham kêkêŋ awamata gêdêŋ nê lauo ŋagêdô nêŋ gôlôac ma kêsakiŋ êsêac sêja gamêŋ oc kêpiŋa sêmoa jaêc latu Isak. Biŋ tonaŋ eŋ gêgôm gêdêŋ gêmoa mata jaligeŋ. ");
INSERT INTO jae_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamnê bêc to jala gêmoaŋa kêtôm jala 175. ");
INSERT INTO jae_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ma katu gêwi Abraham siŋ ma gêmac êndu. Abraham gêboa nê jala sa têtu taêsam ma kêtu ŋamalac su e kêsaê gebe kêtôm eŋgac. Tec Apômtau kêkalem eŋ jagêwiŋ nê lau, taŋ sêmac sêmuŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Latuagêc Isak agêc Ismael sêsuŋ eŋ kêsêp pocgêsuŋ Mak-Pela, taŋ gêc ŋac gamêŋ Hetŋa Sohar latu Epronnê kôm gêc Mamre ŋagamêŋ oc kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kôm tonaŋ Abraham gêjam ôli su aŋga lau gamêŋ Hetŋa nêŋ. Aŋga ônê sêsuŋ Abraham gêc gêwiŋ nê awê Sara. ");
INSERT INTO jae_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham gêmac êndu ma Anôtô gêjam mec latu Isak. Isak tec gêmoa bumata Ber-Lahai-Roi ŋagala. ");
INSERT INTO jae_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saranê sakiŋwagao Aiguptuo Hagar latu Ismael, taŋ Abraham kêka eŋ lasê naŋ, nê wakuc tonec. ");
INSERT INTO jae_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael latu i nêŋ ŋaê tonec. Ac têdênaŋ ŋaê kêtôm teneŋi kêkôc êsêacŋa. Ismaelnê ŋacsêga Nebajot ma Kedar, Adbel, Mibsam, ");
INSERT INTO jae_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO jae_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Napis to Kedema. ");
INSERT INTO jae_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael latui tau tonaŋ ma êsêacnêŋ ŋaê tau kêtôm nêŋ malac to gamêŋ sêŋgôŋŋa. Kasêga 12 têtôm nêŋ gôlôacmôkê. ");
INSERT INTO jae_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelnê jala gêmoa nomŋa tonec gebe 137. Katu gêwi eŋ siŋ ma gêmac êndu jagêwiŋ nê lau. ");
INSERT INTO jae_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nê wakuc sêŋgôŋ gamêŋ Hawila to Sur, taŋ gêc kêkanôŋ Aiguptu gêmu kêsô Asuriaŋa naŋ ŋasawa. Ac sêŋgôŋ sêwiŋ tawaŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham latu Isak nê wakuc tau tonec. Isak tama Abraham. ");
INSERT INTO jae_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaknê jala kêtu 40, go gêjam Rebeka kêtu ênê awê. Rebeka eŋ ŋac Aram ŋa aŋga Mesopotamia Betuel latuo, ŋac Aramŋa Laban nê luo. ");
INSERT INTO jae_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ma Isak keteŋ mec gêdêŋ Apômtau kêtu nê awêŋa gebe eŋ awê kapoac teŋ. Apômtau kêkêŋ taŋa ênê mec e ênê awê Rebeka taê. ");
INSERT INTO jae_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ôliŋbôm sêmônaŋ tauŋ sêmoa eŋ têtaclêlôm ma eŋ kêsôm gebe “Embe amboac tonaŋ, naŋ jamoa êtu asageŋŋa.” Tec gêja gebe êtu kênac Apômtau. ");
INSERT INTO jae_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ma Apômtau kêsôm gêdêŋ eŋ gebe “Gôlôacmôkê luagêc sêmoa aôm têmtaclêlôm ma aôm ôkôc laum luagêc, mago sêwa tauŋ êkôc. Teŋ toôliwalô êlêlêc teŋ su ma ŋacsêga ênam sakiŋ ŋacsauŋ.” ");
INSERT INTO jae_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Gêdêŋ ŋanoc êkôc ŋapalêŋa, tec kêkôc ôliŋbôm. ");
INSERT INTO jae_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ŋac ŋamata, taŋ kêsa naŋ, kokoc ma ôlilu amuc-amuc, tec sê ênê ŋaê gebe Esau. ");
INSERT INTO jae_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Go lasi kêsa ma lêma kêkôc Esau agêbi tôŋ, tec sêsam eŋ gebe Jakob. Isaknê jala kêtu 60, tec teneŋi kêkôc êsêagêc. ");
INSERT INTO jae_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ŋapalê têtu kapôêŋ ma Esau kêtu ŋac lêma gwadaŋa, taŋ kêpê talam lêma kata gêjac laoc gamêŋgeŋ. Ma Jakob kêtu ŋac wapac to ŋaŋêŋ, taŋ gêŋgôŋ becobo. ");
INSERT INTO jae_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak têtac gêwiŋ Esau gebe eŋ geŋ gwada gêjac ŋawae. Mago Rebeka têtac gêwiŋ Jakob. ");
INSERT INTO jae_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gêdêŋ ŋasawa teŋ Jakob geno gabab ma Esau aŋga kôm gêmêŋ totêkwa gêbacgeŋ ");
INSERT INTO jae_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ma Esau kêsôm gêdêŋ Jakob gebe “Ôkêŋ gêŋ kokoc tonaŋ sebeŋ êndêŋ aê mêŋjaniŋ gebe aê tekoc gêbac.” Kêtu tonaŋŋa sêsam eŋ gebe Edom. ");
INSERT INTO jae_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mago Jakob kêsôm gebe” Ôkêŋ nêm gêŋlênsêm ŋacsêgaŋa êndêŋ aê jawê kaiŋ acgom.” ");
INSERT INTO jae_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kêsôm gebe “Gôlicgac me, aê oc jamac êndu. Gêŋlênsêm ŋacsêgaŋa ênam aê sa amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob kêsôm gebe “Ôtôc lêmam êmuŋ acgom.” Ma eŋ kêtôc lêma ma kêkêŋ nê gêŋlênsêm ŋacsêgaŋa gêdêŋ Jakob gêwê kaiŋ. ");
INSERT INTO jae_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Go Jakob kêkêŋ polom to gabab gêdêŋ eŋ. Ma eŋ geŋ to gênôm gêŋ su, go gêdi ma gêc gêja. Tec Esau gêlic gêŋlênsêm ŋacsêgaŋa amboac gêŋ ŋaôma. ");
INSERT INTO jae_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ma tôbôm teŋ kêsa aŋga gamêŋ tonaŋ. Tôbôm, taŋ kêsa gêdêŋ Abrahamnê têm naŋ, teŋ. Ma Isak gêdêŋ Pilistinêŋ kiŋ Abimelek gêja Gerar. ");
INSERT INTO jae_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ma Apômtau geoc tau lasê gêdêŋ eŋ ma kêsôm gebe “Ôsêp Aiguptu ôna atom. Ômoa gamêŋ, taŋ jasôm ŋabiŋ êndêŋ aôm naŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","amoa gamêŋ tau amboac ŋac jaba ma aê gabe jawiŋ aôm to janam mec aôm. Aê gabe jakêŋ gamêŋ tonaŋ samob êndêŋ aôm to nêm wakuc ma gabe jaŋgôm biŋ, taŋ katôc lemoc gêdêŋ tamam Abraham naŋ ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aê gabe jaŋgôm nêm wakuc têtu taêsam ŋanô lasê têtôm utitalata umboŋŋa ma gabe jakêŋ gamêŋ samob tonaŋ ŋai êndêŋ nêm wakuc ma laum nomŋa samob têtap nêm wakucnêŋ mec ŋamoasiŋ sa, ");
INSERT INTO jae_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","gebe Abraham taŋa wamu aê aoc ma kêmasaŋ ŋoc ŋagôliŋ to ŋoc biŋsu ma ŋoc biŋ to ŋoc jatu.” ");
INSERT INTO jae_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tec Isak gêmoa Gerar. ");
INSERT INTO jae_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Gêdêŋ taŋ lau malac tonaŋŋa têtu kênac eŋ kêtu nê awêŋa naŋ, eŋ kêsôm gebe “Aê luco eŋ,” gebe eŋ kêtêc tau, tec kêsôm gebe “Aêŋoc awê eŋ” atom. Eŋ taê gêjam gebe Moae lau gamêŋ tonecŋa sênac aê êndu êtu Rebekaŋa, gebe eŋ awê ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Eŋ gêmoa gamêŋ tau ŋasawa ec baliŋ su, tec bêc teŋ Pilistinêŋ kiŋ Abimelek kêtuc kêniŋ kêsa katam sauŋ ma gêlic Isak kêtu samuc Rebeka. ");
INSERT INTO jae_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tec Abimelek gêmôêc Isak ma kêsôm gebe “Amboac ondoc, eŋ aômnêm awêgoc. Aôm kôsôm gebe aôm lômo eŋ naŋ amboac ondoc.” Isak kêsôm gêdêŋ eŋ gebe “Aê gaboc moae jamac êndu êtu eŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek kêsôm gebe “Aôm gôgôm aêac amboac ondoc. Aêŋoc launêŋ teŋ embe êmoa êwiŋ nêm awê, go aômnêm keso ŋagêjô êtap aêac sa.” ");
INSERT INTO jae_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tec Abimelek gêjac biŋsu lau samob gebe “Lau, taŋ sêmoasac ŋac tonec me nê awê naŋ, sênac êsêac êndu.” ");
INSERT INTO jae_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma Isak kêsê gêŋ kêsêp gamêŋ tonaŋ ma gêjam ŋanô kêlêlêc ŋêŋgeŋ su. Apômtau gêjam mec eŋ, ");
INSERT INTO jae_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","tec ŋac tau kêtu ŋac tolêlôm ma nê awa kêtu kapôêŋ e kêsalê eŋ auc. ");
INSERT INTO jae_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ênê domba to bulimakao taêsam sêmoa ma sakiŋwaga gwalêkiŋ. Pilisti sêlic e têntac sec. ");
INSERT INTO jae_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bumata samob, taŋ tamanê sakiŋwaga sêkwê gêdêŋ tama Abraham nê têm naŋ, Pilisti sêsuŋ auc ma sêkêŋ nom kêsêp. ");
INSERT INTO jae_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ma Abimelek kêsôm gêdêŋ Isak gebe “Ôêc ôna gebe aôm kôtu ŋaclai ŋatau kôlêlêc aêac su.” ");
INSERT INTO jae_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Amboac tonaŋ Isak gêwl gamêŋ ônê siŋ jagêjam bec aŋga gaboaŋ Gerar ma gêŋgôŋ tônê. ");
INSERT INTO jae_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ma Isak kêgawê bumata, taŋ sêkwê gêdêŋ tama Abraham nê têm naŋ sa kêtiam. Abraham gêmac êndu, tec Pilisti sêsuŋ bumata tonaŋ auc. Ma eŋ gê ŋaê, taŋ tama Abraham gê su naŋ sa kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mago gêdêŋ taŋ Isaknê sakiŋwaga sêkwê bumata aŋga gaboaŋ e têtap bu sa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","gejobwaga bôcŋa aŋga Gerar sêsôm Isaknê gejobwaga bôcŋa gebe “Bu tonec aêacma.” Tec eŋ kêsam bumata tau gebe “Esek,” gebe êsêac sêsôm eŋ. ");
INSERT INTO jae_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ma êsêac sêkwê bumata teŋ kêtiam ma sêsôm tauŋ kêtu bu tonaŋŋa amboac tonaŋgeŋ. Tec eŋ kêsam bumata tau gebe “Sitna.” ");
INSERT INTO jae_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ma eŋ gêwi gamêŋ tônê siŋ ma kêkwê bumata wakuc teŋ. Êsêac sêsôm tauŋ kêtu bu tonaŋŋa atom, tec kêsam ŋaê gebe “Rehobot,” + ma kêsôm gebe “Galoc Apômtau kêkêŋ ŋasawa gêdêŋ aêac gebe tatu taêsam aŋga gamêŋ tau.” ");
INSERT INTO jae_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aŋga ônê Isak jakêpi Ber-Seba. ");
INSERT INTO jae_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ma Apômtau geoc tau lasê gêdêŋ eŋ gêdêŋ gêbêc tonaŋ ma kêsôm gebe “Tamam Abraham nê Anôtô aê. Ôtêc taôm atom gebe aê jawiŋ aôm ma gabe janam mec aôm to jakêŋ nêm wakuc têtu taêsam kêtu ŋoc sakiŋwaga Abrahamŋa.” ");
INSERT INTO jae_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ma Isak gêboa altar teŋ sa ma awa gêjac Apômtaunê ŋaê, go gê becobo. Ma Isaknê sakiŋwaga sêkwê bumata teŋ. ");
INSERT INTO jae_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Go Abimelek aŋga Gerar gêdêŋ eŋ gêja. Nê ŋac Ausat to nê siŋwaganêŋ ŋac ŋamataŋa Pikol sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak kêsôm gêdêŋ êsêac gebe “Amac têmtac gedec aê, tec ajanda aê aŋga nêm gamêŋ ma galoc amêŋ kêtu ageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Êsêac sêsôm gebe “Aêac alic gêc awêgeŋ gebe Apômtau gêwiŋ aôm, tec taêŋ gêjam gebe awiŋ aôm ma tatôc lemeŋ ma tamoatiŋ poac êndêŋ tauŋ, ");
INSERT INTO jae_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","gebe aôm ôŋgôm aêac sec atom êtôm aêac amoasac aôm atom ma agôm aôm ŋajamgeŋ e asakiŋ aôm tobiŋmalôgeŋ gôêc gômôêŋ. Apômtaunê mec kêpi aôm sugac.” ");
INSERT INTO jae_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tec Isak geno moasiŋ gêdêŋ êsêac seŋ to sênôm. ");
INSERT INTO jae_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Gêdêŋ bêbêc kanucgeŋ ac dêdi ma têtôc lemeŋ gêdêŋ tauŋ ma Isak kejoŋ êsêac ma êsêac seboŋ tauŋ tobiŋmalôgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Gêdêŋ bêc tonaŋ Isaknê sakiŋwaga dêdêŋ eŋ sêja ma sêkêŋ ŋawae gêdêŋ eŋ kêtu bumata, taŋ sêkwê naŋŋa, ma sêsôm gêdêŋ eŋ gebe “Aêac atap bu sa.” ");
INSERT INTO jae_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Eŋ kêsam bumata tau gebe “Siba,” ŋam gebe Tatôc lemeŋ. Kêtu tonaŋŋa malac ŋaê gebe Ber-Seba e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaunê jala kêtu 40 ma eŋ gêjam ŋac gamêŋ Hetŋa Beri nê latuo Judit to ŋac Hetŋa Elon nê latuo Basemat têtu ênê awê agêc. ");
INSERT INTO jae_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ma êsêagêc sêgôm Isak agêc Rebeka nêŋ ŋalêlôm ŋawapac sec. ");
INSERT INTO jae_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak kêtu ŋamalacanô ma mataanô kêtu waô e gêlic gamêŋ kêtôm atom. Gêdêŋ tonaŋ eŋ gêmôêc nê ŋacsêga Esau ma kêsôm gêdêŋ eŋ gebe “Latucenec.” Ma eŋ gêjô eŋ awa gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma eŋ kêsôm gebe “Gôlicgac me, aê katu ŋamalacanô sugac ma gajam kauc ŋoc bêc jamac ênduŋa. ");
INSERT INTO jae_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tec ôkôc nêm waba gwadaŋa, nêm talam to sôb naôtap gwada sa aŋga saleŋ êtu aêŋa ");
INSERT INTO jae_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ma ômansaŋ gêŋ tau êtôm aê têtac êwiŋ, go ôkôc mêŋjaniŋ gebe janam mec aôm su acgom, go jamac êndu.” ");
INSERT INTO jae_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma Rebeka taŋasuŋ gêjac biŋ, taŋ Isak kêsôm gêdêŋ latu Esau naŋ. Esau gêja saleŋ kêtu êkôc gwadaŋa su acgom, ");
INSERT INTO jae_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","go Rebeka kêsôm gêdêŋ latu Jakob gebe “Aê gaŋô tamam kêsôm biŋ gêdêŋ têwam Esau gebe ");
INSERT INTO jae_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ôkôc gwada êtu aêŋa, mêŋômansaŋ gêŋ tau gebe janiŋ ma janam mec aôm êmuŋ jakô Apômtau laŋônêmŋa, go jamac êndu.’ ");
INSERT INTO jae_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kêtu tonaŋŋa, latucenec, taŋam wamu ŋoc biŋ, tec jajatu aôm nec. ");
INSERT INTO jae_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ôna ôkôc noniŋ ŋalatu kapoac luagêc aŋga ŋatoŋ mêŋjamansaŋ tamamnê gêŋ êtôm têtac êwiŋ ");
INSERT INTO jae_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ma ôkêŋ êndêŋ tamam êniŋ gebe ênam mec aôm êmuŋ, go êmac êndu.” ");
INSERT INTO jae_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mago Jakob kêsôm gêdêŋ têna Rebeka gebe “Aôm gôlic gebe teoc Esau eŋ ŋac ôlilu amuc-amuc, mago aê ôlic selec. ");
INSERT INTO jae_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Moae tamoc êmoasac aê e ênsaê gebe kasau eŋ ma êpuc boa aê êjô mec su.” ");
INSERT INTO jae_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Têna kêsôm gêdêŋ eŋ gebe “Latucenec, biŋ êpuc boa aômŋa êpi aê. Aôm taŋam wamu ŋoc biŋ naôkôc gêŋ tau ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tec eŋ gêja ma kêkôc gêŋ luagêc jakêkêŋ gêdêŋ têna. Ma têna kêmasaŋ gêŋ kêtôm tama têtac gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Go Rebeka kêkôc ŋacsêga Esau nê ŋakwê omŋa, taŋ gêc tênanê andu naŋ, ma kêkêŋ gêdêŋ ŋac sauŋ Jakob kêsô. ");
INSERT INTO jae_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ma kêkwa Jakob lêma to gêsutêkwa auc ŋa noniŋ ŋaôlic. ");
INSERT INTO jae_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Go kêkêŋ gwada to polom, taŋ eŋ kêmasaŋ naŋ, kêsêp latu Jakob lêma. ");
INSERT INTO jae_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ma eŋ kêsô gêdêŋ tama jakêsôm gebe “Tamoc.” Ma eŋ kêsôm gebe “Aê tec gamoa. Latucenec, aôm asa.” ");
INSERT INTO jae_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob kêsôm gêdêŋ tama gebe “Nêm ŋacsêga Esau aê. Aê gagôm biŋ, taŋ kôsôm gêdêŋ aê naŋ, ŋanô kêsa. Galoc ôndi sa ma ôniŋ ŋoc gwada gebe ônam mec aê.” ");
INSERT INTO jae_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Mago Isak kêsôm gêdêŋ latu gebe “Latucenec, amboac ondoc, tec kôtap gwada sa sebeŋ.” Eŋ gêjô eŋ awa gebe “Ŋam gebe Apômtau, aômnêm Anôtô tau, kêkêŋ gêdêŋ aê.” Go Isak kêsôm gêdêŋ Jakob gebe ");
INSERT INTO jae_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","“Latucenec, ômôêŋmaŋ, gebe jamoasac aôm e jajala gebe latuc Esau aôm biŋŋanô me masi.” ");
INSERT INTO jae_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tec Jakob jakêsa tama Isak ŋagala. Eŋ kêmoasac eŋ ma kêsôm gebe “Awam kêtôm Jakob awa, mago lêmam kêtôm Esau lêma.” ");
INSERT INTO jae_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ma eŋ kêjala eŋ atom gebe lêma amuc-amuc kêtôm têwa Esau lêma, tec gêjam mec eŋ. ");
INSERT INTO jae_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Eŋ kêsôm gebe “Aôm latuc Esau biŋŋanô me masi.” Eŋ gêjô eŋ awa gebe “Aê tau tonec.” ");
INSERT INTO jae_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Go eŋ kêsôm gebe “Ôkêŋ gêŋ êndêŋ aê mêŋjaniŋ latucnê gwada ma janam mec aôm.” Tec eŋ kêkêŋ gêŋ gêdêŋ eŋ geŋ ma kêkêŋ wain gêdêŋ eŋ gênôm. ");
INSERT INTO jae_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Go tama Isak kêsôm gêdêŋ eŋ gebe “Latucenec, mêŋôtu gasuc ma ôlêsôp aê.” ");
INSERT INTO jae_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ma eŋ kêtu gasuc to kêlêsôp eŋ. Ma Isak gêŋu ênê ŋakwê ŋamalu ma gêjam mec eŋ to kêsôm gebe “Gôlicgac me, latucnê ŋamalu kêtôm kôm, taŋ Apômtau gêjam mec naŋ, ŋamalu gêjam saŋiŋ. ");
INSERT INTO jae_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anôtô êkêŋ maniŋ umboŋŋa êsêlô êpi aôm to nom ŋalêsi ma polom to wain ŋanô lasê. ");
INSERT INTO jae_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Eŋ êkêŋ tenteŋlatu sênam sakiŋ aôm to laum sewec êndêŋ aôm. Ôtu lasiminêŋ ŋatau to tênam latui sewec êndêŋ aôm. Aê japuc boa lau, taŋ sêpuc boa aôm to janam mec êsêac, taŋ sênam mec aôm.” ");
INSERT INTO jae_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak gêjam mec Jakob su ma Jakob gêwi tama Isak siŋ dambêgeŋ, ma têwa Esau aŋga saleŋ gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eŋ kêmasaŋ nê gwada amboac tonaŋ ma kêkêŋ gêdêŋ tama. Ma eŋ kêsôm gêdêŋ tama gebe “O tamoc, ôndi sa ma ôniŋ latômnê gwada gebe ônam mec aê.” ");
INSERT INTO jae_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tama Isak kêsôm gêdêŋ eŋ gebe “Aôm asa.” Eŋ gêjô eŋ awa gebe “Aôm latôm ŋacsêga aê, Esau.” ");
INSERT INTO jae_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Go Isak kêtakê ŋanôgeŋ ma kêsôm gebe “Amboac ondoc, aôm gômôêŋ atomgeŋ ma asa kêtap gwada sa to kêkêŋ gêdêŋ aê gaeŋ ma gajam mec eŋ su. Biŋŋanô, mec kêpi eŋ sugac, oc êwê kaiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau gêŋô tamanê biŋ tonaŋ ma kêwakic to kêtaŋ lasê ma kêsôm gêdêŋ tama gebe “O tamoc, ônam mec aê amboac tonaŋgeŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mago eŋ kêsôm gebe “Lasim gêmêŋ kêbôli tau kêpi aôm ma kêjaŋgo aômnêm mec su.” ");
INSERT INTO jae_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ma Esau kêsôm gebe “Ac sê ênê ŋaê gebe Jakob jagêdêŋgeŋ gebe eŋ kêsau aê kêtu dim luagêc sugac. Eŋ kêjaŋgo ŋoc gêŋlênsêm ŋacsêgaŋa ma galoc eŋ kêjaŋgo ŋoc mec su gêwiŋ.” Go eŋ kêsôm gebe “Aôm kôgamiŋ mec teŋ kêtu aêŋa me masi.” ");
INSERT INTO jae_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak gêjô Esau awa gebe “Ôlic acgom, aê kakêŋ eŋ kêtu nêm ŋatau ma kakêŋ lasii samob gêdêŋ eŋ gebe têtu ênê sakiŋwaga ma kakêŋ polom to wain gêdêŋ eŋ gêwê kaiŋ. O latucenec, aê janam aôm sa ŋa gêŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau kêsôm gêdêŋ tama gebe “O tamoc, aômnêm mec tageŋgeŋ gêc me masi. O tamoc, ônam mec aê amboac tonaŋgeŋmaŋ.” Ma Esau gêôc awa sa ma kêtaŋ lasê. ");
INSERT INTO jae_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Go tama Isak gêjô eŋ awa gebe “Malam ôŋgôŋŋa ênêc jaêc kôm toŋalêsi to gamêŋ maniŋ umboŋŋa êsêlô êsêpŋa. ");
INSERT INTO jae_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nêm siŋ êlôm aôm ma ônam sakiŋ lasim. Mago embe ôŋgôm ôtu wakac, go bêc teŋ ônsaic ênê sakiŋ su êkôniŋ aôm tôŋ êtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Galoc Esau têtac gedec Jakob kêtu mec, taŋ kêtap sa aŋga tamanê naŋŋa. Ma Esau kêsôm gêdêŋ tau gebe “Bêc tataŋ taŋiboa êtu tamocŋa kêdabiŋ. Su, go janac lasic Jakob êndu.” ");
INSERT INTO jae_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka gêŋô latusêga Esau nê biŋ tonaŋ ŋaboŋa, tec kêsakiŋ biŋ gêdêŋ ŋac sauŋ Jakob ma kêkalem eŋ ma kêsôm gêdêŋ eŋ gebe “Ôlic acgom, têwam Esau gebe êkac kamocgôc. Eŋ gebe ênac aôm êndu, tec kêkic aômnêm biŋ. ");
INSERT INTO jae_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kêtu tonaŋŋa, latucenec, taŋam wamu aê aoc. Ôndi ôêc ôndêŋ lucŋac Laban ôna Haran. ");
INSERT INTO jae_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ômoa ôwiŋ eŋ têm ŋagêdô e têwamnê ŋalêlôm êtu malô ");
INSERT INTO jae_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","e têtac ŋandaŋ êôŋ su ma êliŋ biŋ, taŋ gôgôm gêdêŋ eŋ naŋ siŋ, ocgo jasakiŋ biŋ êwac gebe ômu ômôêŋ. Êtu asageŋŋa amagêc lulugeŋ anaŋa awi aê siŋ êndêŋ bêc tageŋ.” ");
INSERT INTO jae_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ma Rebeka kêsôm gêdêŋ Isak gebe “Aê ôlic ŋakam kêtu lau gamêŋ Hetŋa nêŋ lauoŋa. Jakob embe ênam lau Hetŋa nêŋ awê teŋ êwiŋ êtôm laocoagêc, awê teŋ aŋga lau gamêŋ tonecŋa nêŋ, go aê jamoa nom êtu ageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Go Isak gêmôêc Jakob ma gêjam mec eŋ, go kêjatu eŋ ma kêsôm gebe “Ônam awê gamêŋ Kanaanŋa teŋ êtu nêm awê atomanô. ");
INSERT INTO jae_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ôndi ôêc ôna Mesopotamia ôndêŋ tênam tama Betuel nê andu ma ônam awê teŋ aŋga tênamnê luŋac Laban nê latuionêŋ. ");
INSERT INTO jae_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ŋajaŋa ŋatau Anôtô ênam mec aôm gebe ôtap gôlôac wakuc sa e ôtu taêsam ma ôtu lau tom-tom. ");
INSERT INTO jae_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Eŋ êkêŋ Abrahamnê mec ŋanô êndêŋ aôm to nêm wakuc, gebe nom, taŋ Anôtô kêkêŋ gêdêŋ Abraham ma aôm gômoa amboac ŋac jaba naŋ, êtu aômnêm gêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Amboac tonaŋ Isak kêsakiŋ Jakob gêja Mesopotamia gêdêŋ ŋac Aramŋa Betuel latu Laban, Esau agêc Jakob teneŋi Rebeka nê luŋac. ");
INSERT INTO jae_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau gêlic gebe Isak gêjam mec Jakob ma kêsakiŋ eŋ gêja Mesopotamia gebe ênam awê aŋga ônê ma gêdêŋ taŋ gêjam mec eŋ naŋ, kêjatu eŋ gebe “Ônam awê gamêŋ Kanaan ŋa teŋ êtu nêm awê atomanô,” ");
INSERT INTO jae_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ma Jakob taŋa wamu tama agêc têna ma gêc gêja Mesopotamia. ");
INSERT INTO jae_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tec Esau kêjala gebe tama Isak gêlic lauo gamêŋ Kanaanŋa ŋajam atom ");
INSERT INTO jae_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ma Esau gêdêŋ Ismael gêja ma gêjam Abraham latu Ismael latuo, Nebajot luo Mahalat kêtu ênê awê gêwiŋ awêlu, taŋ eŋ gêjam su naŋ. ");
INSERT INTO jae_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob gêdi aŋga Ber-Seba kêsêlêŋ kepeŋ Haran gêja ");
INSERT INTO jae_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","e kêsa ŋasawa teŋ jagêc gebe oc kêsêp su. Eŋ kêkôc poc, taŋ sêc gamêŋ tonaŋ naŋ, ŋateŋ gedeŋ kêtu nê kwalim ma kêsa tau sic gebe ênêc bêc. ");
INSERT INTO jae_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ma gêc mê gebe têcwale teŋ kêkô nom ma ŋatêpôê jadiŋgeŋ undambê. Ma Anôtônê aŋela sêpi-sêsêp sêmoa têc. ");
INSERT INTO jae_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma gêlic Apômtau kêkô têcôŋa ma kêsôm gebe “Apômtau, tamamagêc Abraham agêc Isak nêŋ Anôtô aê. Nom, taŋ gôêc naŋ, aê gabe jakêŋ êndêŋ aôm to nêm wakuc. ");
INSERT INTO jae_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ma aômnêm wakuc oc ŋanô lasê têtôm gaŋac gwêcŋa ma sêlaiŋ tauŋ sêmu gamêŋ oc kêsêp to oc kêpi ma gamêŋ gêmu kêsêp to gêmu kêpiŋa sêna ma aôm to nêm wakuc nêm mec ŋamoasiŋ êmoasiŋ gôlôac to gôlôac êtôm nom ŋagamêŋgeŋ êna. ");
INSERT INTO jae_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Gôlicgac me, aê gawiŋ aôm ma gabe jajop aôm êtôm nêm lêŋ ôsaŋa samobgeŋ ma gabe jawê aôm e ômu ômôêŋ gamêŋ tonec êtiam, gebe aê jawi aôm siŋ atom e jaŋgôm biŋ, taŋ gajac mata gêdêŋ aôm naŋ ŋanô êsa acgom.” ");
INSERT INTO jae_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakob gêc bêc e mata gêlac ma kêsôm gebe “Biŋŋanôgeŋ, Apômtau gêmoa gamêŋ tonecgoc ma aê gajam kauc.” ");
INSERT INTO jae_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma eŋ kêtêc tau ma kêsôm gebe “Gamêŋ tonec gamêŋ dabuŋgoc. Anôtô tau nê andu ma undambê ŋasacgêdô tonec.” ");
INSERT INTO jae_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Gêdêŋ bêbêc kanucgeŋ Jakob gêdi sa ma gêjac poc, taŋ gedeŋ kêtu nê kwalim naŋ, sa kêkô kêtu ŋabelo ma kêkêc niptêkwi kêpi poc tau. ");
INSERT INTO jae_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Eŋ kêsam gamêŋ tau ŋaê gebe Betel. Gêmuŋgeŋ sêsam malac tonaŋ ŋaê gebe Lus. ");
INSERT INTO jae_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ma Jakob gêjac mata biŋ amboac tonec gebe “Anôtô embe êwiŋ aê ma ejop aê aŋga intêna, tec jasa nec, ma êkêŋ mo aê janiŋ to ŋakwê aê jasôŋa êndêŋ aê ");
INSERT INTO jae_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","e jaô lasê tamocnê andu tobiŋmalôgeŋ êtiam, go Apômtau êtu ŋoc Anôtô. ");
INSERT INTO jae_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Poc tonec gajac sa kêkô kêtu ŋabelo êtu Anôtônê andu. Ma gêŋ samob, taŋ aôm ôkêŋ êndêŋ aê naŋ, aê jakêŋ gêŋ 10-10 ŋateŋ ŋanô-teŋ ŋanô êtômgeŋ êmu êndêŋ aôm êwac.” ");
INSERT INTO jae_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Go Jakob gêdi ma kêsêlêŋ e gêô lasê lau oc kêpiŋa nêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mata geso gamêŋ, tec gêlic bumata teŋ kêpoac kôm ma domba toŋ têlêac sêc ŋagala gebe domba têtap nêŋ bu sa aŋga bumata tau. Poc kapôêŋ kêgadê bumata tau. ");
INSERT INTO jae_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Domba ŋatoŋ samob embe sêpi tageŋ su, go ŋagejobwaga sêôc poc su aŋga bumata ma sêkêŋ bu êndêŋ domba sênôm. Su, go sêkêŋ poc êmu ŋamala naêŋgandê bu auc êtiam. ");
INSERT INTO jae_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ma Jakob kêsôm gêdêŋ êsêac gebe “O ŋoc lasitêwaiac, amac aŋga ondoc.” Êsêac sêsôm gebe “Aêac aŋga Haran.” ");
INSERT INTO jae_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Eŋ kêsôm gêdêŋ êsêac gebe “Amac ajala Nahor latu Laban me masi.” Êsêac sêsôm gebe “Aêac ajala eŋgac.” ");
INSERT INTO jae_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Eŋ kêsôm gêdêŋ êsêac gebe “Eŋ gêmoa ŋajam me masi.” Êsêac sêsôm gebe “Gêmoa ŋajam. Ôlic eŋ latuo Rahel gêmêŋ gêwiŋ domba.” ");
INSERT INTO jae_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Eŋ kêsôm gebe “Amboac ondoc, oc kêkô ŋaluŋ, tec bôc sêsô sapa sêna atomgeŋ, akêŋ bu êndêŋ êsêac, go aêc ana gebe sêniŋ gêgwaŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mago êsêac sêsôm gebe “Aêac atôm atom tageŋ. Domba ŋatoŋ samob sêpi tageŋ acgom, go aôc poc su aŋga bumata ma akêŋ bu êndêŋ domba sênôm.” ");
INSERT INTO jae_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Eŋ gêjam biŋgalôm gêwiŋ êsêac gêmoa, ma Rahel gêô lasê gêwiŋ tamanê domba gebe eŋ gejob êsêac. ");
INSERT INTO jae_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakob gêlic sa laŋgwa Laban nê latuo Rahel to nê domba, go gêja gêôc poc su aŋga bumata ma kêkêŋ bu gêdêŋ sa laŋgwa Laban nê domba sênôm. ");
INSERT INTO jae_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Go Jakob kêlêsôp Rahel ma kêtaŋ lasê. ");
INSERT INTO jae_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Go Jakob gêwa tau sa gêdêŋ Rahel gebe “Tamamnê gôlôacnêŋ teŋ aê, gebe tinoc Rebeka.” Tec Rahel kêlêti jakêsôm ŋawae gêdêŋ tama. ");
INSERT INTO jae_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban gêŋô luo latu Jakob ŋawae ma kêlêti gebe êkôc eŋ sa. Eŋ kêmbôêŋ to kêlêsôp eŋ, go gêwê eŋ kêsô nê andu. Jakob gêjac nê lêŋ samob ŋamiŋ gêdêŋ Laban ");
INSERT INTO jae_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ma Laban kêsôm gêdêŋ eŋ gebe “Biŋŋanô, aêŋoc ŋatê ŋagêdô aôm.” Ma Jakob gêmoa gêwiŋ eŋ ajôŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Go Laban kêsôm gêdêŋ Jakob gebe “Aôm aŋga ŋoc gôlôacnêŋ, tec ônam sakiŋ aê ŋaôma me. Ôsômmaŋ, jakêŋ ŋagêjô amboac ondoc êndêŋ aôm êjô nêm kôm.” ");
INSERT INTO jae_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma Labannê latuoagêc sêmoa, awêsêganê ŋaê gebe Lea ma awê sauŋ nê gebe Rahel. ");
INSERT INTO jae_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea laŋôanô tutuc, mago Rahel ôli to laŋôanô latu-latu. ");
INSERT INTO jae_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ma Jakob têtac gêwiŋ Rahel, tec eŋ kêsôm gebe “Aê gabe janam sakiŋ aôm jala 7 êjô latômo sauŋ Rahel su.” ");
INSERT INTO jae_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban kêsôm gebe “Jakêŋ eŋ êndêŋ aôm oc ŋajam êlêlêc jakêŋ eŋ êndêŋ ŋac jaba teŋ su. Amboac tonaŋ ômoa ôwiŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tec Jakob gêjam sakiŋ jala 7 kêtu Rahelŋa. Eŋ têtac gêwiŋ eŋ ŋanô, tec gêlic ŋasawa tonaŋ kêtôm bêc luagêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Go Jakob kêsôm gêdêŋ Laban gebe “Ôkêŋ ŋoc awê êndêŋ aê gebe jamoa jawiŋ eŋ gebe ŋoc têm gêbacnê.” ");
INSERT INTO jae_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ma Laban kêkalem lau malacŋa samob sêpi tageŋ ma geno moasiŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mago gêdêŋ kêtulala eŋ kêkôc latuo Lea ma gêwê eŋ gêdêŋ Jakob gebe êmoa êwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban kêkêŋ nê sakiŋwagao Silpa gêdêŋ latuo Lea gebe ênam sakiŋ eŋ.) ");
INSERT INTO jae_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ma gêdêŋ bêbêcgeŋ Jakob gêlic gebe Lea. Ma eŋ kêsôm gêdêŋ Laban gebe “Aôm gôgôm aê amboac ondoc. Aê gajam sakiŋ aôm kêtu Rahel ŋa atom me. Aôm kôsau aê kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban gêjô eŋ awa gebe “Aêacma mêtê gebe awê sauŋ ênam ŋac êmuŋ awêsêga nec gêc atom. ");
INSERT INTO jae_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Agêc amoa awiŋ taôm e woke tonec êmbacnê, go aêac akêŋ awê teŋ êndêŋ aôm êwiŋ. Ma aôm ônam sakiŋ aê jala 7 êtiam êjô awê tau.” ");
INSERT INTO jae_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob gêlic ŋajam ma agêc sêmoa sêwiŋ tauŋ e woke tau gêbacnê, go Laban kêkêŋ latuo Rahel gêdêŋ eŋ gêjam. ");
INSERT INTO jae_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban kêkêŋ nê sakiŋwagao Bilha gêdêŋ latuo Rahel gebe ênam sakiŋ eŋ.) ");
INSERT INTO jae_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ma Jakob gêmoa gêwiŋ Rahel amboac tonaŋgeŋ ma têtac gêwiŋ Rahel kêlêlêc Lea su. Ma eŋ gêjam sakiŋ Laban jala 7 gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Apômtau gêlic gebe Jakob têtac gedec Lea, tec kêkêŋ eŋ kêkêkam ŋapalê. Mago Rahel eŋ awê kapoac. ");
INSERT INTO jae_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ma Lea taê ma kêkôc ŋapalê ŋac ma gê ênê ŋaê gebe Ruben gebe eŋ kêsôm gebe” Apômtau mata gê ŋoc gêŋ wapac ma galoc ŋoc akweŋ oc têtac êwiŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Eŋ taê kêtiam ma kêkôc ŋapalê ŋac teŋ ma kêsôm gebe “Apômtau gêŋô su gebe têtac gedec aê, tec kêkêŋ latuc tonec gêwiŋ.” Ma gê ênê ŋaê gebe Simeon. ");
INSERT INTO jae_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Eŋ taê-kêtiam ma kêkôc ŋapalê ŋac teŋ ma kêsôm gebe “Galoc ŋoc akweŋ êsap aê tôŋ gebe aê kakôc ênê latui têlêac.” Kêtu tonaŋŋa eŋ gê ênê ŋaê gebe Lewi. ");
INSERT INTO jae_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma eŋ taê kêtiam ma kêkôc ŋapalê ŋac teŋ ma kêsôm gebe “Galoc aê gabe jalambiŋ Apômtau.” Kêtu tonaŋŋa eŋ gê ênê ŋaê gebe Juda. Go kêkôc gôlôac kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahel kêsaê gebe eŋ oc êkôc ŋapalê êjô Jakob atom, tec gêjam lêmuŋ têwao ma kêsôm gêdêŋ Jakob gebe “Ôka ŋoc gôlôac lasê. Embe masi, oc jamac êndu.” ");
INSERT INTO jae_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakob têtac ŋandaŋ kêsa gêdêŋ Rahel ma kêsôm gêdêŋ eŋ gebe “Aê gajô Anôtô su me. Eŋ kêgamiŋ têmtaclêlôm ŋaŋanô gêdêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Go eŋ kêsôm gebe “Ŋoc sakiŋwagao Bilha tonec. Ômoa ôwiŋ eŋ gebe êkôc ŋapalê êŋgôŋ aê labucm gebe jatap latuc teŋ sa aŋga ênê.” ");
INSERT INTO jae_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tec kêkêŋ nê sakiŋwagao Bilha gêdêŋ Jakob kêtu ênê awê ma Jakob gêmoa gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma Bilha taê e kêkôc ŋapalê ŋac gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Go Rahel kêsôm gebe “Anôtô kêmêtôc aê ma kêkêŋ taŋa aê aoc, tec kêkêŋ latuc gêdêŋ aê.” Kêtu tonaŋŋa eŋ gê ênê ŋaê gebe Dan. ");
INSERT INTO jae_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ma Rahelnê sakiŋwagao Bilha taê kêtiam ma kêkôc latu kêtu luagêcŋa gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma Rahel kêsôm gebe “Aêagêc teoco amônaŋ tauŋ ŋajaŋageŋ e kaku eŋ tulu.” Tec gê ŋapalênê ŋaê gebe Naptali. ");
INSERT INTO jae_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea kêsaê gebe oc êkôc gôlôac êtiam atom, tec kêkôc nê sakiŋwagao Silpa ma kêkêŋ eŋ gêdêŋ Jakob kêtu ênê awê. ");
INSERT INTO jae_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ma Leanê sakiŋwagao Silpa kêkôc latu teŋ gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ma Lea kêsôm gebe “Aê katap ŋoc ŋajam sa.” Ma gê ênê ŋaê gebe Gad. ");
INSERT INTO jae_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Go Leanê sakiŋwagao Silpa kêkôc latu kêtu luagêcŋa gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ma Lea kêsôm gebe “Aê gamoa totêtac wapigeŋ. Biŋŋanô, lauo sêlambiŋ aê.” Tec gê ênê ŋaê gebe Aser. ");
INSERT INTO jae_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gêdêŋ têm sejoŋ kôm ŋanô saŋa naŋ, Ruben gêja kôm ma kêtap kaŋanô ŋagêdô sa, taŋ lauo kapoac sêkôc êtu sêkêkam ŋapalêŋa. Eŋ kêkêŋ gêdêŋ têna Lea. Ma Rahel kêsôm gêdêŋ Lea gebe “Ôkêŋ latômnê kaŋanô êndêŋ aêmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma Lea kêsôm gebe “Amboac ondoc, aôm kôjaŋgo ŋoc akweŋ su, nec gôlic amboac gêŋ ŋaôma me. Ma galoc gobe ôkôc latucnê ka ŋanô su amboac tonaŋgeŋ me.” Ma Rahel kêsôm gebe “Amboac tonaŋ êmbêc tonec êmoa êwiŋ aôm êjô latômnê ka ŋanô.” ");
INSERT INTO jae_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gêdêŋ kêtula Jakob gêmu gêmêŋ aŋga kôm ma Lea kêpuc eŋ tôŋtôŋ ma kêsôm gebe “Ôndêŋ aê ômôêŋmaŋ gebe aê gajam ôli aôm ŋa latucnê ka ŋanô.” Tec gêmoa gêwiŋ eŋ gêdêŋ gêbêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ma Anôtô kêkêŋ taŋa Lea e taê ma kêkôc latu kêtu lemeŋ teŋŋa gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ma Lea kêsôm gebe “Anôtô kêkêŋ latuc teŋ gêdêŋ aê gêjô aê kakêŋ ŋoc sakiŋwagao gêdêŋ ŋoc akweŋ.” Ma gê ênê ŋaê gebe Isakar. ");
INSERT INTO jae_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Go Lea taê kêtiam ma kêkôc latu kêtu 6ŋa gêjô Jakob. ");
INSERT INTO jae_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ma Lea kêsôm gebe “Anôtô kêkêŋ gêŋ ŋajam gêdêŋ aê. Galoc ŋoc akweŋ etoc aê sa gebe aê kakôc latuci 6 gêjô eŋ.” Ma eŋ gê ênê ŋaê gebe Sebulon. ");
INSERT INTO jae_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tonaŋ su, go eŋ kêkôc latuo teŋ ma gê ênê ŋaê gebe Dina. ");
INSERT INTO jae_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Go Anôtô taê gêjam Rahel ma kêkêŋ taŋa eŋ ma gêlôc sa gebe êkôc ŋapalê. ");
INSERT INTO jae_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Eŋ taê ma kêkôc ŋapalê ma kêsôm gebe “Anôtô geseŋ ŋoc biŋ majocŋa su,” ");
INSERT INTO jae_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ma gê ênê ŋaê gebe Josep ma kêsôm gebe “Apômtau êkêŋ latuc teŋ mêŋêwiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel kêkôc Josep su, go Jakob kêsôm gêdêŋ Laban gebe “Ôsakiŋ aê jamu jana ŋoc malac to ŋoc gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ôkêŋ ŋoc lauo to ŋoc gôlôac êndêŋ aê gebe aê gajam sakiŋ aôm kêtu êsêacŋa. Ôlôc, go jaêc jana. Aôm kôjala sakiŋ, taŋ gajam gêdêŋ aôm naŋgac.” ");
INSERT INTO jae_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ma Laban kêsôm gêdêŋ eŋ gebe “Ôlic aê ŋajammaŋ. Aê kapuc kapoac ma katap sa gebe Apômtau gêjam mec aê kêtu aômŋa. ");
INSERT INTO jae_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ôsam nêm ŋaôli ma aê gabe jakêŋ êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma Jakob kêsôm gêdêŋ eŋ gebe “Taôm kôjala sakiŋ, taŋ gajam naŋ, ma gôlic nêm bulimakao to bôc ŋagêdô sêmoa ŋalêŋ gêdêŋ aê gajob êsêacŋa, ");
INSERT INTO jae_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","gebe luagêcgeŋ sêmoa gêdêŋ aê gamêŋ atomgeŋ ma galoc têtu taêsam, ma Apômtau gêjam mec aôm gêdêŋ ŋasawa, taŋ aê gamoa gawiŋ aôm naŋ. Mago galoc amboac ondoc. Aê janam kôm janam tauc ŋoc gôlôac sa êndêŋ ondocgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ma Laban kêsôm gebe “Amboac tonaŋ aê jakêŋ asageŋ êndêŋ aôm.” Ma Jakob gêjô eŋ awa gebe “Ôkêŋ gêŋ teŋ êndêŋ aê atom. Aôm embe ôlôc êndêŋ ŋoc biŋ tonec, go aê jatu gejobwaga ma jajop nêm bôc êtiam. ");
INSERT INTO jae_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Galoc aê janac nêm bôc pebeŋ kêsi ma jajaliŋ bôc ôliŋ komokom to tictêla-tictêla samob sa ma domba jejec to noniŋ komokom to tictêla-tictêla amboac tonaŋgeŋ ma gêŋ tonaŋ têtu ŋoc ŋaôli. ");
INSERT INTO jae_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Êtu ŋamu biŋ tonec êwaka aê sa gebe aê ŋac gêdêŋ gebe Aôm embe ômôêŋ gebe ônac ŋoc ŋaôli kêsi ma ôlic noniŋ, taŋ ôliŋ komokom to tictêla-tictêla atom to domba, taŋ jejec atom naŋ ŋateŋ, go ôlic aê amboac ŋac geŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban kêsôm gebe “Ŋajam, amboac tonaŋ nêm biŋ êtu tôŋ.” ");
INSERT INTO jae_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mago gêdêŋ bêc tecenaŋ Laban kêkôc noniŋ kapoac talô-talô to tictêla-tictêla ma noniŋ têna ôliŋ komokom to tictêla-tictêla samob su, samob, taŋ ôliŋ sêpsêp ŋagec gêc naŋ, to domba jejec samob amboac tonaŋ ma kêkêŋ gêdêŋ latui sejop. ");
INSERT INTO jae_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma gêc gêja e intêna ŋasawa kêtôm bêc têlêac geŋ êsêagêc Jakob kêsi ma Jakob gejob Labannê bôc ŋagêdôgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Go Jakob kêkôc kalatu aŋga kaleloŋ to otic ma kaopo ma gebeŋ ŋaôlic ŋatalô tictêla-tictêla. ");
INSERT INTO jae_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Eŋ kêkôc kalatu, taŋ kêmasaŋ su naŋ, jaketoc kêkô busawa, kêkô suc, taŋ bôc sêmêŋ sênôm bu kêsêpŋa naŋ, kêkô bôc laŋôŋnêmŋa solop. Go gêdêŋ noc sênôm buŋa bôc sêgêli tauŋ sêmoa. ");
INSERT INTO jae_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Bôc sêgêli tauŋ sêmoa sêkanôŋ gamêŋ, taŋ kalatu sêkô naŋ, tec sêsu ŋalatu ôliŋ talô-talô to komokom ma tictêla-tictêla. ");
INSERT INTO jae_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Domba tonaŋ sêmoa tauŋŋa ma Jakob kêkêŋ bôc ŋagêdô laŋôŋ gêdêŋ bôc ôliŋ komokom to tictêla-tictêla, taŋ sêmoa Labannê bôc ŋatoŋ ŋalêlôm naŋ. Ma eŋ kêjaliŋ tau nê bôc ŋatoŋ ŋagêdô sa ma kêkêŋ nê gêŋ sêwiŋ Labannê atom. ");
INSERT INTO jae_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Embe bôc toôliŋwalô sêŋgêli tauŋ, go Jakob naetoc kalatu ênêc bôc laŋôŋnêmŋa êsêp suc ŋalêlôm gebe sêlic kalatu ma sêŋgêli tauŋ. ");
INSERT INTO jae_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mago embe bôc toôliŋ secsec, go naetoc kalatu êkô atom. Kêtu tonaŋŋa bôc toôliŋ secsec têtu Labannê ma bôc toôliŋwalô têtu Jakobnê. ");
INSERT INTO jae_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Tec ŋac tau kêtu ŋac tolêlôm ma kêtap nê bôc ma sakiŋwagao to ŋac ma kamele to doŋki taêsam sa. ");
INSERT INTO jae_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ma Jakob gêŋô Laban latui sêsôm-sêsôm gêdêŋ tauŋ gebe “Jakob kêjaŋgo tameŋinê gêŋ samob su. Aŋga tameŋinê gêŋ eŋ kêtap waba taêsam sa e kêtu ŋac tolêlôm.” ");
INSERT INTO jae_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma Jakob kêsaê Laban laŋôanô e gêlic kêtôm gêmuŋgeŋ kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tec Apômtau kêsôm gêdêŋ Jakob gebe” Ômu tamami to nêm tawaŋ nêŋ gamêŋ ôna ma aê oc jawiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ma Jakob kêsakiŋ biŋ gêja ma gêmôêc Rahel agêc Lea sêmêŋ kôm, taŋ nê bôc sêmoa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ma kêsôm gêdêŋ êsêagêc gebe “Aê galic tamemi laŋôanô amboac teŋ, eŋ gêlic aê ŋajam amboac gêmuŋŋa kêtiam atom. Mago tamocnê Anôtô gêmoa gêwiŋ aê. ");
INSERT INTO jae_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Amagêc ajala gebe gajam sakiŋ tamemi toŋoc ŋaclai samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mago tamemi kêsau aê ma gêjam ŋoc ŋaôli ôkwi kêtu dim 10. Mago Anôtô kêkô eŋ auc gebe êŋgôm aê sec atom. ");
INSERT INTO jae_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Gêdêŋ taŋ eŋ kêsôm gebe ‘Bôc toôliŋ komokom têtu nêm ŋaôli’ naŋ, bôc samob sêsu ŋalatu toôliŋ komokom. Ma gêdêŋ taŋ eŋ kêsôm gebe ‘Bôc toôliŋ tictêla-tictêla têtu nêm ŋaôli’ naŋ, bôc samob sêsu ŋalatu toôliŋ tictêla-tictêlageŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Amboac tonaŋ Anôtô kêkôc bôc su aŋga tameminê ma kêkêŋ gêdêŋ aê. ");
INSERT INTO jae_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Gêdêŋ têm taŋ bôc sêgêli tauŋŋa naŋ, aê gaôc matocanô sa ma gaêc mê teŋ ma galic noniŋ kapoac, taŋ sêgêli noniŋ têna naŋ, ôliŋ komokom to tictêla-tictêla ma talô-talô. ");
INSERT INTO jae_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Go Anôtônê aŋela awa gêjac aê gêdêŋ taŋ gaêc mê gaêc naŋ, gebe ‘Jakob.’ Ma aê kasôm gebe ‘Aê tec gamoa.’ ");
INSERT INTO jae_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma eŋ kêsôm gebe ‘Ôc matamanô sa ma ôlic. Noniŋ kapoac samob, taŋ sêgêli noniŋ têna naŋ, ôliŋ komokom to tictêla-tictêla ma talô-talô gebe aê galic gêŋ samob, taŋ Laban gêgôm gêdêŋ aôm naŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aê Anôtô, tec gaoc tauc lasê gêdêŋ aôm aŋga Betel naŋ, gêdêŋ taŋ aôm goeŋ oso poc ma gôjac mata biŋ gêdêŋ aê naŋ. Galoc ôndi ôwi gamêŋ tonec siŋ ma ômu ôna gamêŋ, taŋ tênam kêkôc aômŋa naŋ.’” ");
INSERT INTO jae_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ma Rahel agêc Lea sêjô eŋ awa gebe” Aêagêc awê kaiŋ gêŋ ŋagêdô to gêŋlênsêm ŋagêdô gêc tamemainê andu me. ");
INSERT INTO jae_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Eŋ gêlic aêagêc amboac lauo jaba. Eŋ kêtulu aêagêc ma kêjaiŋ awa, taŋ gêjô aêagêc naŋ, su. ");
INSERT INTO jae_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Waba samob, taŋ Anôtô kêkôc su aŋga tamemainê naŋ, kêtu aêagêc to ma gôlôac ma gêŋ. Kêtu tonaŋŋa ôŋgôm biŋ samob, taŋ Anôtô kêsôm gêdêŋ aôm naŋ, ŋanô êsamaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Tec Jakob gêdi ma kêkêŋ latui to nê lauo sêŋgôŋ kamele ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ma eŋ gêwê nê bôc to gêŋ mateŋ jali samob, taŋ kêtap sa naŋ, bôc samob, taŋ têtu ênê gêŋ gêdêŋ eŋ gêmoa Mesopotamia naŋ, gebe êndêŋ tama Isak êna gamêŋ Kanaan. ");
INSERT INTO jae_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban gêja gebe êkapiŋ domba ŋaôlilu. Ma Rahel gêjam geŋgeŋ tamanê anôtô gwam. ");
INSERT INTO jae_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma Jakob gêwê ŋac Aramŋa Laban auc gebe kêkêŋ tau êc êna nec ŋawae teŋ gêdêŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Eŋ gêc tonê waba samobgeŋ gêja, go gêdi jagelom bu Euprat ma kêsêlêŋ laŋô gêlac gamêŋ lôcŋa Gilead. ");
INSERT INTO jae_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Bêc têlêac gêjaŋa, go sêsôm gêdêŋ Laban gebe Jakob gêc gêja. ");
INSERT INTO jae_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tec eŋ kejoŋ nê tawaŋ sêwiŋ eŋ ma kêjanda Jakob bêc 7 e gê eŋ tôŋ aŋga gamêŋ lôcŋa Gilead. ");
INSERT INTO jae_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mago gêdêŋ gêbêc Anôtô jagêsuŋ mê gêdêŋ ŋac Aramŋa Laban ma kêsôm gêdêŋ eŋ gebe “Ôlic taôm, ôsôm biŋ ŋajam me sec êndêŋ Jakob atom.” ");
INSERT INTO jae_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ma Laban kêka lêlêc Jakob. Jakob gê nê becobo kêkô lôc ma Laban to nê tawaŋ jasêlêwaŋ tauŋ sêmoa gamêŋ lôcŋa Gilead. ");
INSERT INTO jae_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma Laban kêsôm gêdêŋ Jakob gebe “Aôm gôgôm asageŋ, tec gôwê aê auc ma kôjaŋgo latucoagêc su amboac siŋwaga sêjaŋgo ŋacjo, taŋ sêku êsêac tulu naŋ su. ");
INSERT INTO jae_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kêtu asageŋŋa aôm gôwê aê auc ma gôêc kelecgeŋ gômôêŋ. Aê gabe jamboŋ aôm ŋa wê to oŋ ma dauc, mago aôm kôsôm biŋ teŋ gêdêŋ aê atom. ");
INSERT INTO jae_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ma kêtu asageŋŋa aôm godec gebe jalêsôp latucoagêc to dêbuci aliŋanô atom. Aôm gôgôm gêŋ meloc. ");
INSERT INTO jae_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aê katôm gebe jaŋgôm aôm sec. Mago tamamnê Anôtô kêsôm biŋ gêdêŋ aê gêdêŋ gêbêc tonaŋ gebe ‘Ôlic taôm, ôsôm biŋ ŋajam me sec teŋ êndêŋ Jakob atom.’ ");
INSERT INTO jae_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ma galoc aôm gôêc gômôêŋ gebe gôjam awam su tamamnê anduŋa. Mago kêtu asageŋŋa aôm gôjam geŋgeŋ aêŋoc anôtôi gwam.” ");
INSERT INTO jae_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob gêjô Laban awa gebe “Aê katêc tauc gaboc aôm ôjaŋgo latômio su aŋga aêŋoc. ");
INSERT INTO jae_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aôm embe ôtap nêm anôtôi gwam sa aŋga ŋac teŋ nê, naŋ oc êmoa mata jali atom. Aêacnêŋ tawaŋ sêmoa, tec ômbêlêm ŋoc waba e ôtap nêm gêŋ sa ma ôkôc êsêac sêlic.” Jakob gêŋô Rahel gêjam geŋgeŋ gêŋ tau ŋawae atom. ");
INSERT INTO jae_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Amboac tonaŋ Laban kêsô Jakobnê bec gêja ma kêsô Leanê bec ma kêsô sakiŋwagao luagêc nêŋ bec amboac tonaŋgeŋ, mago kêtap gêŋ tau sa atom. Go kêsa aŋga Leanê bec jakêsô Rahelnê. ");
INSERT INTO jae_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rahel kêkôc anôtôi gwam tau jakêsiŋ ôkwi gêc kamelenêŋ waba lau sêŋgôŋ ŋaôŋa ŋalêlôm ma eŋ tau gêŋgôŋ ŋaô. Ma Laban kêbêlêm bec ŋagêŋlêlôm samob ma kêtap gêŋ tau sa atom. ");
INSERT INTO jae_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma Rahel kêsôm gêdêŋ tama gebe “O ŋoc ŋatau, aê gadi sa kakô aôm laŋômnêm jakatôm atom, tec têmtac ŋandaŋ êndêŋ aê atom, gebe kakôc ajôŋ.” Tec gesom-gesom, mago kêtap anôtôi gwam tau sa atom. ");
INSERT INTO jae_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Go Jakob têtac ŋandaŋ kêsa ma kêsôm Laban. Ma Jakob kêsôm gêdêŋ Laban gebe “Aê gagôm sec amboac ondoc. Aê gagôm keso ondoc tec kôjanda aê gômôêŋ nec. ");
INSERT INTO jae_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aôm kôbêlêm ŋoc waba samob. Aôm kôtap nêm waba ondoc sa. Otoc gêŋ tau ênêc awêgeŋ êndêŋ aêŋoc tawaŋ to aômnêm tawaŋ laŋôŋnêm gebe sêlic ma sêmêtôc aêagêcnêŋ biŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Aê gamoa gawiŋ aôm jala 20. Nêm domba têna to noniŋ têna sêjam ŋalatu su atom ma aê gaeŋ domba kapoac teŋ aŋga nêm domba ŋatoŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Gêŋ, taŋ kêam sec sêkac gêŋgic naŋ, aê kakêŋ gêdêŋ aôm gebe ôlic naŋ atom, aê tauc gajô aŋga aêŋoc. Aôm kôkac aê gebe jajô gêŋ samob, taŋ sêjam geŋgeŋ gêdêŋ ocsalô ma ônê, taŋ sêjam geŋgeŋ gêdêŋ gêbêc naŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aê gamoa amboac tonaŋ. Gêdêŋ ocsalô oc kêpac aê êndu ma gêdêŋ gêbêc malo gêjam aê. Ma bêc gedec matocanô. ");
INSERT INTO jae_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Jala 20 aê gamoa gawiŋ aôm aŋga nêm andu. Aê gajam sakiŋ aôm jala 14 gêjô latômoagêc. Ma jala 6 gêjô nêm bôc. Mago aôm gôjam ŋoc ŋaôli ôkwi kêtu dim 10. ");
INSERT INTO jae_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tamocnê Anôtô, Abrahamnê Anôtô ma Isaknê kêtêc tau ŋamôkê embe êmoa êwiŋ aê atom, go aôm ôsakiŋ aê tolemoc sawageŋ jana. Anôtô gêlic ŋoc gêŋwapac to lemoc ŋakôm ma kêmêtôc nêm biŋ gêdêŋ gêbêc tonec.” ");
INSERT INTO jae_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Go Laban gêjô eŋ awa ma kêsôm gêdêŋ Jakob gebe “Lauo tonec aêŋoc latucio, gôlôac tau aêŋoc gôlôac, bôc ŋatoŋ aêŋoc bôc ŋatoŋ ma gêŋ samob, taŋ aôm gôlic naŋ, aêŋoc gêŋgoc. Mago ocsalô tonec aê jaŋgôm asageŋ êndêŋ latucio me êndêŋ nêŋ gôlôac, taŋ êsêac sêkôc naŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ajôc, aêagêc tamoatiŋ poac teŋ. Poac tau êtu ŋabelo êwa aêagêc saŋa teŋ.” ");
INSERT INTO jae_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tec Jakob kêkôc poc teŋ jagêjac sa kêkô kêtu ŋabelo. ");
INSERT INTO jae_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma Jakob kêsôm gêdêŋ nê tawaŋ gebe “Ajoŋ poc sa.” Ma êsêac sêkôc poc ma sêboa sa kêtu toŋ teŋ. Ma êsêac seŋ gêŋ sêŋgôŋ poc tau ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban kêsam toŋ tau gebe Jegar-Sahaduta, mago Jakob kêsam gêŋ tau gebe Galed. ");
INSERT INTO jae_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban kêsôm gebe “Toŋ tonaŋ kêtu ŋabelo êwa aêagêc saŋa êkô ŋasawa.” Kêtu tonaŋŋa eŋ kêsam gêŋ tau gebe Galed, ");
INSERT INTO jae_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ma alê poc gebe Mispa gebe eŋ kêsôm gebe “Aêagêc embe tamoa jaêc tauŋ, go Apômtau ejop aêagêc. ");
INSERT INTO jae_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Aôm embe ôtu kasec aê latucio me ônam lauo ŋagêdô mêŋsêwiŋ latucio, naŋ ôlic katômaŋ gebe ŋamalac teŋ tec mêŋgêwiŋ aêagêc atom nec, mago Anôtô oc êjala gebe gejob aêagêc.” ");
INSERT INTO jae_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Go Laban kêsôm gêdêŋ Jakob gebe “Ôlic toŋ to alê poc tonec, taŋ aê gajac sa kêkô aêagêc ŋasawa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Toŋ tau to alê poc tonec êtu ŋabelo gebe aê jaŋgêli toŋ tonec wacjalom nêm gamêŋ atom, ma aôm ôŋgêli toŋ to alê poc tonec mêŋolom aêŋoc gamêŋ êtu ôŋgôm aê secŋa atom. ");
INSERT INTO jae_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahamnê Anôtô to Nahornê Anôtô ma agêc tameŋinê Anôtô êtu ŋac-mêtôcwaga êkô aêagêc ŋasawa.” Ma Jakob kêtôc lêma gêdêŋ tama Isak nê kêtêc tau ŋamôkê. ");
INSERT INTO jae_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ma Jakob kêkêŋ da teŋ aŋga lôc tonaŋ ma kêkalem nê tawaŋ gebe sêniŋ polom. Ma êsêac seŋ polom ma sêmoa lôc tau gêdêŋ gêbêc samuc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Gêdêŋ bêbêc kanucgeŋ Laban gêdi ma kêlêsôp dêbui to latuio aliŋanô to gêjam mec êsêac. Go gêwi êsêac siŋ ma gêmu gêja nê gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ma Jakob kêkôc nê lêŋ sa amboac tonaŋ. Ma Anôtônê aŋela dêdac eŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jakob gêlic êsêac ma kêsôm gebe “Anôtônê siŋwaga êsêac.” Tec kêsam gamêŋ tau ŋaê gebe Mahanaim. ");
INSERT INTO jae_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Go Jakob kêsakiŋ nê lau jaeŋ sêmuŋ dêdêŋ têwa Esau sêja, taŋ gêŋgôŋ Edomnê gamêŋ Seir. ");
INSERT INTO jae_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ma eŋ kêjatu êsêac gebe “Asôm êndêŋ ŋoc ŋatau Esau amboac tonec gebe Aômnêm sakiŋwaga Jakob kêsôm biŋ tonec gebe Aê gamoa gawiŋ Laban e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ma aê katap bulimakao to doŋki ma bôc ŋatoŋ ma sakiŋwagao to ŋac sa. Ma galoc kakêŋ jaeŋ gêdêŋ ŋoc ŋatau gebe ôlic aê ŋajamŋa.” ");
INSERT INTO jae_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Lau jaeŋŋa sêmu dêdêŋ Jakob sêja ma sêsôm gebe “Aêac aô lasê têwam Esau. Eŋ gêdi gebe êpuc aôm tôŋtôŋ to lau 400 sêwiŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tec Jakob kêtakê ŋanô ma gêmoa toŋalêlôm ŋatutucgeŋ ma gêwa lau, taŋ sêwiŋ eŋ naŋ, ma bôc ŋatoŋ to bulimakao ma kamele kêkôc gêja toŋ luagêc. ");
INSERT INTO jae_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Eŋ taê gêjam gêc tauŋa gebe “Esau embe êndac toŋ teŋ ma enseŋ su, go toŋ teŋ gacgeŋ sêc sêna.” ");
INSERT INTO jae_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ma Jakob kêsôm gebe “O tamoc Abraham nê Anôtô ma tamoc Isak nê Anôtô, o Apômtau, aôm kôsôm gêdêŋ aê gebe ‘Ômu ôna nêm gamêŋ to nêm gôlôac ma aê gabe jamoasiŋ aôm.’ ");
INSERT INTO jae_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Aê gêŋ ŋaôma nec katôm nêm moasiŋ to nêm biŋ ŋaŋêŋ, taŋ kôkêŋ gêdêŋ nêm sakiŋwaga aê naŋ atom. Aê galom bu Jordan tonec tec kamêgôm ŋoc tôcgeŋ ma galoc katu toŋ luagêc. ");
INSERT INTO jae_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aê jateŋ aôm gebe ônam aê kêsi êndêŋ teoc Esau lêma, gebe aê katêc eŋ. Moae êmêŋ e ênac aêac samob êndu, enseŋ teneŋi to nêŋ gôlôac êtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mago aôm kôsôm gebe ‘Aê gabe jamoasiŋ aôm to jakêŋ nêm wakuc têtôm gaŋac gwêcŋa, taŋ lau teŋ sêsa sa têtôm atom.’” ");
INSERT INTO jae_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ma eŋ gêmoa ônê gêdêŋ gêbêc tonaŋ ma kêkôc nê gêŋ samob, taŋ kêtap sa naŋ, ŋagêdô su gebe êwi siŋ êndêŋ têwa Esau ŋaôma. ");
INSERT INTO jae_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Eŋ kêkôc noniŋ têna 200 to kapoac 20 ma domba 200 to kapoac 20, ");
INSERT INTO jae_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ma kamela 30 tonêŋ ŋalatugeŋ, taŋ sênôm su naŋ, bulimakao tana 40 to kapoac 10, doŋki têna 20 to kapoac 10. ");
INSERT INTO jae_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bôc totoŋ-totoŋ tonaŋ eŋ kakêŋ sêsêp sakiŋwaga lemeŋ gêdêŋ-gêdêŋgeŋ ma kêsôm gêdêŋ nê sakiŋwaga gebe “Amac amuŋ aê ma akêŋ ŋasawa êsi tau êniŋ toŋ êndêŋ-êndêŋ-geŋŋa êŋgic êtômgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eŋ kêjatu ŋac ŋamataŋa gebe “Teoc Esau embe êndac aôm ma êtu kênac aôm gebe ‘Aômnêm ŋatau asa. Aôm ôna ondoc. Gêŋ, taŋ gêmuŋ aôm naŋ asanê,’ ");
INSERT INTO jae_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","go ôsôm gebe ‘Êsêac têtu nêm sakiŋwaga Jakobnê gêŋ. Eŋ gebe êkêŋ gêŋ tau êndêŋ ŋoc ŋatau Esau ŋaômageŋ. Eŋ tau kêdaguc aêac.’” ");
INSERT INTO jae_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Eŋ kêjatu biŋ tonaŋgeŋ gêdêŋ ŋac kêtu luagêcŋa to têlêacŋa ma êsêac samob, taŋ têdaguc bôc ŋatoŋ gêdêŋ-gêdêŋgeŋ naŋ. “Amac embe andac Esau, go asôm biŋ tageŋ tonaŋgeŋ êndêŋ eŋ ");
INSERT INTO jae_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ma asôm teŋ tonec êwiŋ gebe ‘Nêm sakiŋwaga Jakob kêdaguc aêac.’” Jakob taê gêjam gebe “Aê jaê wama eŋ ŋa gêŋ, taŋ gabe jakêŋ ŋaômageŋ êndêŋ eŋ naŋ, êmuŋ acgom, go jalic eŋ laŋôanô êtu ŋamu. Moae êkôc aê sa.” ");
INSERT INTO jae_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tec gêŋ, taŋ gebe êkêŋ ŋaômageŋ êndêŋ Esau naŋ, kêsêlêŋ gêmuŋ eŋ ma eŋ tau gêmoa bec ŋamala gêdêŋ gêbêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Gêdêŋ gêbêc tonaŋgeŋ Jakob gêdi ma kêkôc nê awêagêc to nê sakiŋwagaoagêc ma nê gôlôac 11 gebe selom buseleŋ Jabok. ");
INSERT INTO jae_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Eŋ kêkôc êsêac ma kêsakiŋ êsêac selom bu tonê gêŋ ŋagêdô amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma eŋ taugeŋ gêmoa ŋamakeŋ. Ma ŋac teŋ jaagêc sêmônaŋ tauŋ e gêu bôŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Gêdêŋ taŋ ŋac tau gêlic gebe oc êku Jakob tulu êtôm atom naŋ, kêtap Jakob kêsêp magi e magi kêsu gêdêŋ agêc sêmônaŋ tauŋ sêmoa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ma eŋ kêsôm gebe “Ôwi aê siŋ gebe gêu bôŋgac.” Mago Jakob kêsôm gebe “Aê jawi aôm siŋ atom e ônam mec aê êmuŋ acgom.” ");
INSERT INTO jae_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ma ŋac tau kêsôm gêdêŋ eŋ gebe “Nêm ŋaê amboac ondoc.” Ma eŋ kêsôm gebe “Jakob.” ");
INSERT INTO jae_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Go eŋ kêsôm gebe “Sêsam aôm gebe Jakob êtiam atom, sêsam aôm gebe Israel, gebe aôm gôjac siŋ gêdêŋ Anôtô to ŋamalac ma kôku êsêac tulu.” ");
INSERT INTO jae_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ma Jakob kêtu kênac eŋ gebe “Ôsam nêm ŋaê êndêŋ aê.” Mago eŋ kêsôm gebe “Aôm kôtu kênac ŋoc ŋaê kêtu asageŋŋa.” Ma eŋ gêjam mec Jakob aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Go Jakob kêsam gamêŋ tau ŋaê gebe Peniel ma kêsôm gebe “Aê laŋôcanô gêdêŋ Anôtô laŋôanô ma gacgeŋ gamoa tomatoc jaligeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Gêdêŋ taŋ kêka lêlêc Peniel naŋ, oc kêpi. Ma eŋ kêka gwecgeŋ gêja kêtu magiŋa. ");
INSERT INTO jae_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kêtu tonaŋŋa lau Israel seŋ bôc ŋalabu atom e mêŋgêdêŋ galoc gebe ŋac tau kêtap Jakob kêsêp magi. ");
INSERT INTO jae_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ma Jakob gêôc mataanô sa e gêlic Esau to lau 400 sêwiŋ eŋ sêmêŋ. Tec eŋ gêjac sam nê gôlôac gêdêŋ Lea agêc Rahel to sakiŋwagao luagêc. ");
INSERT INTO jae_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ma eŋ kêkêŋ sakiŋwagaoagêc to nêŋ gôlôac sêkô ŋamata. Lea to nê gôlôac têdaguc, ma Rahel agêc Josep sêkô êsêac samob ŋamu. ");
INSERT INTO jae_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Eŋ tau gêwê êsêac ac têtu oloŋ-oloŋ sêja. Eŋ gewec e jakêtap labôc kêtu dim 7 e jagêjac têwa sa. ");
INSERT INTO jae_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mago Esau kêlêti gêdêŋ eŋ jagêlô eŋ tôŋ to kêmbôêŋ eŋ kêsêp gêsutêkwa, ma kêlêsôp eŋ alianô. Ma agêc têtaŋ. ");
INSERT INTO jae_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Gêdêŋ taŋ Esau gêôc mataanô sa e gêlic lauo to gôlôac naŋ, eŋ kêsôm gebe “Asa lau, tec sêwiŋ aôm.” Ma Jakob kêsôm gebe “Gôlôac, taŋ Anôtô kêkêŋ êsêac kêtu êmoasiŋ nêm sakiŋwagaŋa naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ma sakiŋwagaoagêc to nêŋ gôlôac mêŋtêdabiŋ ma sewec. ");
INSERT INTO jae_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Go Lea to nê gôlôac mêŋtêdabiŋ ma sewec amboac tonaŋgeŋ. Gocgo Josep agêc Rahel mêŋtêdabiŋ ma sewec têtu ŋamu. ");
INSERT INTO jae_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma Esau kêsôm gebe “Aôm taêm gêjam biŋ amboac ondoc kêpi toŋ kapôêŋ, taŋ gadac naŋ.” Jakob gêjô eŋ awa gebe “Aê gabe ŋoc ŋatau êlic aê ŋajamŋa.” ");
INSERT INTO jae_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mago Esau kêsôm gebe “O lasicenec, aêŋoc gêŋ kêtôm aê. Ôkôc nêm gêŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob kêsôm gebe “O masi. Aôm embe ôlic aê ŋajam, go ôkôc gêŋ tonaŋ aŋga aêŋoc gebe aê galic laŋômanô e kêtôm galic Anôtô tau laŋôanô gebe aôm kôkôc aê sa ŋajamgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Aê jateŋ aôm gebe ôkôc gêŋ, taŋ kakêŋ gêdêŋ aôm gêwac naŋ, gebe Anôtô kêmoasiŋ aê ŋanôgeŋ ma kakoc ŋoc gêŋ kêtôm aê su.” Eŋ kêpiŋkap Esau amboac tonaŋ e kêkôc gêŋ tau su. ");
INSERT INTO jae_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Go Esau kêsôm gebe “Ajôc, dandimaŋ ma tasêlêŋ. Aê jasêlêŋ jamuŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Jakob kêsôm gebe “O ŋoc ŋatau, aôm gôlicgac gebe gôlôac têtu kapôêŋ su atom ma aê gaê go domba to bulimakao toŋalatu naŋ. Embe sensoc êsêac sêsêlêŋ ec baliŋ sêŋgôm bêc tageŋ, ŋatoŋ samucgeŋ oc sênaŋa. ");
INSERT INTO jae_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Amboac tonaŋ, ŋoc ŋatau, ôsêlêŋ ômuŋ aêac. Aê jawê bulimakao malô-malôgeŋ jandaŋguc êtôm bôc to gôlôac ŋasec-ŋasec sêkêŋ aê e wacjaô lasê ŋoc ŋataunê gamêŋ Seir.” ");
INSERT INTO jae_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tec Esau kasôm gebe “Aê jawi lau, taŋ sêwiŋ aê naŋ, ŋagêdô siŋ sêwiŋ aôm.” Mago eŋ kasôm gebe “Sêwiŋ aêac êtu ageŋŋa. Ŋoc ŋatau, embe ôlic aê ŋajam, go êtôm.” ");
INSERT INTO jae_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tec Esau kêkac tau ôkwi gêdêŋ bêc tonaŋgeŋ gêmu gêja Seir kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Jakob kêsêlêŋ jagêô lasê Sukot ma kêkwê nê andu teŋ, ma gêjam bec kêtu nê bôcŋa. Kêtu tonaŋŋa eŋ kêsam gamêŋ tau gebe Sukot. ");
INSERT INTO jae_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Go Jakob toôli samucgeŋ gêô lasê malac Sikem, taŋ gêc gamêŋ Kanaan naŋ. Eŋ kêsêlêŋ aŋga Mesopotamia gêmêŋ ma gêjam nê bec kêkô malac ŋamagê. ");
INSERT INTO jae_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ma eŋ gêjam ôli nom, taŋ nê bec kakô naŋ, aŋga Sikem tama Hamor latuinêŋ. Eŋ gêjam ôli ŋa mone 100. ");
INSERT INTO jae_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Aŋga tonaŋ eŋ gêboa altar teŋ sa ma kêsam altar tau gebe Anôtô, Israelnêŋ Anôtô eŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Bêc teŋ Lea latuo Dina, taŋ Jakob kêka lasê naŋ, kêsêlêŋ gebe êlic lauo gamêŋ tonaŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ma ŋac gamêŋ Hibŋa teŋ, taŋ kêtu gamêŋ ŋatau naŋ, Hamor latu Sikem, gêlic eŋ ma gêlô eŋ tôŋ ma gêmoa gêwiŋ eŋ e gêgôm eŋ kêtu sec. ");
INSERT INTO jae_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mago nê ŋalêlôm kêsap Jakob latuo Dina tôŋ. Eŋ têtac gêwiŋ ŋapalêo tau ma kêsôm biŋ ŋajamgeŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tec Sikem kêsôm gêdêŋ tama Hamor gebe “Ômansaŋ biŋ gebe ŋapalêo tonaŋ êtu ŋoc awê.” ");
INSERT INTO jae_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ma Jakob gêŋô gebe eŋ gêgôm latuo Dina kêtu sec. Tageŋ latui sejop bôc sêmoa kôm, tec Jakob gêjam tau tôŋ e êsêac sêmu sêmêŋ acgom. ");
INSERT INTO jae_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ma Sikem tama Hamor gêdêŋ Jakob gêja gebe ênam biŋgalôm êwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jakob latui aŋga kôm sêmêŋ ma sêŋô biŋ tau ŋawae e gegeŋ êsêac sa ma têntac ŋandaŋ ŋanô gebe Sikem gêgôm sec gêdêŋ Israel ma gêmoa gêwiŋ Jakob latuo, gebe lau teŋ sêŋgôm gêŋ amboac tonaŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mago Hamor gêjam biŋgalôm gêwiŋ êsêac ma kêsôm gebe “Latucnê ŋalêlôm gêwiŋ latômo samucgeŋ, tec gabe jateŋ aôm ôkêŋ eŋ êndêŋ eŋ êtu êna awê. ");
INSERT INTO jae_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tanam tauŋmaŋ. Amac akêŋ latômio êndêŋ aêac ma akôc aêac latuŋio êjô. ");
INSERT INTO jae_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Amoa awiŋ aêac atu têlê. Ma gamêŋ êtu amacnêm gamêŋ. Amoa gamêŋ tau ma atulu gêŋ e atu lau tolêlôm.” ");
INSERT INTO jae_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ma Sikem kêsôm biŋ gêdêŋ awê tama to lui gebe “Alic aê ênac matemanô ŋajammaŋ. Ma gêŋ samob, taŋ ateŋ aŋga aêŋoc naŋ, aê gabe jakêŋ êndêŋ amac. ");
INSERT INTO jae_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Amac embe ajatu ŋaôli kapôêŋ sec to awalauŋ, oc jakêŋ êtôm tê ajatu nêgeŋ. Tageŋ akêŋ ŋapalêo tau êtu ŋoc awê.” ");
INSERT INTO jae_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jakob latui sêjô Sikem agêc tama Hamor aweŋ sêbanac biŋgeŋ gebe eŋ gêgôm luŋio Dina kêtu sec. ");
INSERT INTO jae_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Êsêac sêsôm gêdêŋ êsêagêc gebe “Aêac atôm atom gebe akêŋ luŋio êndêŋ ŋac samuc teŋ, taŋ sêsa eŋ atom naŋ. Biŋ amboac tonaŋ êŋgôm aêac majeŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aŋgôm biŋ tonec êtu tôŋ êmuŋ acgom, gebe asa nêm ŋacwaga samob e amac mêŋatôm aêac acgom, go aêac alôc êndêŋ nêm biŋ ");
INSERT INTO jae_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ma akêŋ latuŋio êndêŋ amac ma aêac akôc amac latômio to amoa awiŋ e tatu laum tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mago amac embe akêŋ taŋem ma biŋ ma asa taôm atom, go aêac akôc latuŋio su ma aêc ana.” ");
INSERT INTO jae_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Êsêacnêŋ biŋ tonaŋ kêmoasiŋ Hamor agêc Hamor latu Sikem. ");
INSERT INTO jae_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma ŋac wakuc tau gêgôm gêŋ tau ŋanô kêsa sebeŋ gebe eŋ têtac gêwiŋ Jakob latuo. Ŋac tau nê gôlôac tetoc eŋ sa kêlêlêc nêŋ lau ŋagêdô su. ");
INSERT INTO jae_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ma Hamor agêc latu Sikem sêô lasê nêŋ malac ŋasacgêdô ma sêjam biŋgalôm sêwiŋ ŋacwaga malacŋa ma sêsôm gebe ");
INSERT INTO jae_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Lau tonaŋ sê sêlêb gêdêŋ aêac, Amboac tonaŋ alôc gebe sêmoa aêacnêŋ gamêŋ ma têtulu gêŋmaŋ. Alic acgom, gamêŋ tau kapôêŋ kêtôm êsêac sêŋgôŋŋa. Aêac tanam êsêac latuŋio ma takêŋ nêŋ latuŋio êndêŋ êsêac sênam. ");
INSERT INTO jae_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tageŋ êsêac oc sêmoa aêac ŋaluŋ tatu laum tageŋ atom, aêac talôc sa gebe êsêacnêŋ biŋ tecenec êtu tôŋ acgom gebe Tasa nêŋ ŋacwaga samob êtôm êsêac sêsa tauŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ma êsêacnêŋ bulimakao to waba ma bôc samob oc têtu aêacnêŋ atom me. Tageŋ tecenec gebe talôc êndêŋ êsêacnêŋ biŋ, go êsêac sêmoa sêwiŋ aêac.” ");
INSERT INTO jae_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ma êsêac samob, taŋ sêsô-sêsa ênê malac ŋasacgêdô sêmoa naŋ, sêkêŋ taŋeŋ Hamor agêc latu Sikem nêŋ biŋ. Ma sêsa ŋacwaga samob, taŋ sêsô-sêsa ênê malac ŋasacgêdô sêmoa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Gêdêŋ ŋabêc kêtu têlêac kamoc kêtuŋ êsêac. Tec Jakob latuagêc Simeon agêc Lewi, Dinanê luŋacagêc, sêkôc nêŋ siŋ ma kelecgeŋ sêja malac jasêjac ŋacwaga samob êndu. ");
INSERT INTO jae_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Êsêac sêjac Hamor agêc latu Sikem ŋa siŋ amboac tonaŋgeŋ, ma sêkôc Dina su aŋga Sikemnê andu ma sêc sêja. ");
INSERT INTO jae_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ma Jakob latui sêjac lau gêmac ma sêjaŋgo waba malac tonaŋŋa su gebe êsêac sêgôm luŋio kêtu sec. ");
INSERT INTO jae_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Êsêac sêjaŋgo nêŋ domba to bulimakao ma doŋki ma gêŋ, taŋ sêmoa malaclêlôm to kôm naŋ su. ");
INSERT INTO jae_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Êsêac sêkôc waba samob ma nêŋ gôlôac ŋasec-ŋasec samob to nêŋ lauo ma sêwê êsêac sêc sêja ma sêjam geŋgeŋ gêŋ samob, taŋ gêc nêŋ andu naŋ. ");
INSERT INTO jae_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ma Jakob kêsôm gêdêŋ Simeon agêc Lewi gebe “Amagêc akalem gêŋ togêjô kêpi aê, gebe êŋgôm lau gamêŋ tonaŋŋa, lau Kanaan to Perisŋa, têntac sec êndêŋ aê êtu amacŋa. Aêŋoc lau luagêcgeŋgoc. Êsêac embe sêmbiŋ tauŋ tôŋ êtu sênac siŋ êndêŋ aêŋa, oc senseŋ aê tauc to ŋoc gôlôac samucgeŋ su tanaŋa.” ");
INSERT INTO jae_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mago êsêagêc sêjô eŋ awa gebe “Eŋ êŋgôm luŋio amboac mockaiŋo teŋ me.” ");
INSERT INTO jae_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Anôtô kêsôm gêdêŋ Jakob gebe “Ajôc, ôndi ôpi Betel ôna naôŋgôŋ ônê ma ômboa altar teŋ sa êndêŋ Anôtô, taŋ geoc tau lasê gêdêŋ aôm gêdêŋ taŋ gôêc têwam Esau su naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tec Jakob kêsôm gêdêŋ nê gôlôac to lau samob, taŋ sêmoa sêwiŋ eŋ naŋ, gebe “Awi anôtôi gwam, taŋ sêc amacŋa naŋ, siŋ to akwasiŋ nêm ŋatêmui samob su ma asô nêm ŋakwê wakuc. ");
INSERT INTO jae_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Su, go aêac dandi tapi Betel tana. Ma aê jamboa altar sa êndêŋ Anôtô, taŋ kêkêŋ taŋa aê gêdêŋ bêc, taŋ gamoa toŋoc ŋalêlôm ŋatutucgeŋ ma mêŋgêwiŋ aê aŋga intêna samob, taŋ aê kasa naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Go êsêac sêkêŋ anôtôi gwam samob, taŋ sêc êsêacŋa naŋ, gêdêŋ Jakob to salasa, taŋ geŋ kaleŋ taŋeŋlauŋ naŋ, ma Jakob kêsuŋ gêŋ tau auc gêc kamem, taŋ kêkô Sikem ŋagala naŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Go êsêac dêdi. Ma Anôtô gêgôm lau malac ŋamagê-magêŋa samob têtêc tauŋ e sêjanda Jakob latui atom. ");
INSERT INTO jae_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ma Jakob to nê lau samob sêô lasê Lus (Betel tau tonaŋ), taŋ gêc gamêŋ Kanaanŋa. ");
INSERT INTO jae_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ma aŋga tônê eŋ gêboa altar teŋ sa ma kêsam gamêŋ tau gebe “El-Betel,” gebe Anôtô geoc tau lasê gêdêŋ eŋ aŋga tônê gêdêŋ taŋ eŋ gêc têwa su naŋ. ");
INSERT INTO jae_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ma Rebekanê jaomwagao Debora gêmac êndu ma sêsuŋ eŋ gêc kamem, taŋ kêkô Betel ŋalabu naŋ, ŋaajuŋ. Ma êsêac sêsam ka tau gebe “Kamem Taŋiboa.” ");
INSERT INTO jae_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ma Anôtô geoc tau lasê gêdêŋ Jakob kêtiam gêdêŋ taŋ eŋ aŋga Mesopotamia gêmêŋ naŋ gêjam mec eŋ. ");
INSERT INTO jae_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ma Anôtô kêsôm gêdêŋ eŋ gebe “Aômnêm ŋaê Jakob, mago sêsam aôm gebe Jakob êtiam atom, sêsam aômnêm ŋaê gebe Israel.” Tec sêsam eŋ gebe Israel. ");
INSERT INTO jae_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma Anôtô kêsôm gêdêŋ eŋ gebe “Ŋajaŋa ŋatau Anôtô aê. Ôka gôlôac lasê e têtu lau taêsam. Laum kapôêŋ teŋ ma lau toê-toê sêsa aŋga aômnêm. Ma kiŋ sêsa aŋga aômnêm amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nom, taŋ kakêŋ gêdêŋ Abraham agêc Isak naŋ, aê gabe jakêŋ êndêŋ aôm to gabe jakêŋ nom tau êndêŋ nêm wakuc, taŋ sêsa sêndaŋguc aôm naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Go Anôtô gêwi gamêŋ, taŋ gêjam biŋgalôm gêdêŋ eŋ naŋ, siŋ kêpi lôlôc gêja. ");
INSERT INTO jae_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ma Jakob kêsuŋ alê teŋ sa kêtu ŋabelo kêkô gamêŋ, taŋ Anôtô gêjam biŋgalôm gêdêŋ eŋ naŋ. Alê poc tau eŋ kêkêc wain kêpi kêtu da ma kêkêc niptêkwi kêpi. ");
INSERT INTO jae_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma Jakob kêsam gamêŋ Anôtô gêjam biŋgalôm gêwiŋ eŋŋa tau gebe Betel. ");
INSERT INTO jae_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Go êsêac dêdi aŋga Betel. Ac sêsêlêŋ têdabiŋ Eprat ma ŋapalê kêtuŋ Rahel secanô. ");
INSERT INTO jae_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Gêdêŋ taŋ ŋandaŋ kêtuŋ eŋ ŋanô naŋ, ênê jaomwagao kêsôm gêdêŋ eŋ gebe “Ôtêc taôm atom. Aôm ôkôc ŋapalê ŋac teŋ êtiam.” ");
INSERT INTO jae_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mago gêdêŋ taŋ kêdabiŋ gebe awa êtu dambê ma êmac êndu naŋ, eŋ gê ênê ŋaê gebe Benoni. Mago nê tama kêsam eŋ gebe Benjamin. ");
INSERT INTO jae_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ma Rahel gêmac êndu. Ac sêsuŋ eŋ gêc intêna Epratŋa (ŋaê teŋ gebe Betlehem) ŋatali. ");
INSERT INTO jae_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma Jakob kêsuŋ alê poc teŋ kêkô sêô ŋaô. Alê tau kêtu Rahelnê sêô ŋabelo, taŋ kêkô e gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Go Israel gêdi ma gêjam nê bec kêkô andu soso Ederŋa ŋamakeŋ. ");
INSERT INTO jae_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Gêdêŋ taŋ Jakob gêŋgôŋ gamêŋ ônê naŋ, Ruben gêja gêmoa gêwiŋ tênanê anao Bilha. Ma Jakob gêŋô biŋ tau ŋawae. Jakob latui 12. ");
INSERT INTO jae_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea latui gebe Ruben (Jakobnê ŋacsêga), Simeon, Lewi, Juda, Isakar ma Sebulon. ");
INSERT INTO jae_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel latu gebe Josep agêc Benjamin. ");
INSERT INTO jae_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahelnê sakiŋwagao Bilha latui gebe Dan agêc Naptali. ");
INSERT INTO jae_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leanê sakiŋwagao Silpa latui gebe Gad agêc Aser. Jakob latui tau tonaŋ, teneŋi sêkôc êsêac aŋga Mesopotamia. ");
INSERT INTO jae_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ma Jakob gêô lasê tama Isak aŋga Mamre (me Kiriat-Arba, ŋaê teŋ gebe Hebron) Abraham agêc Isak nêŋ gamêŋ sêmoaŋa. ");
INSERT INTO jae_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaknê jala kêtu 180. ");
INSERT INTO jae_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ma katu gêwi eŋ siŋ e gêmac êndu, go sêkêŋ eŋ gêc gêwiŋ nê lau. Eŋ kêtu ŋamalacanô su ma ênê jala gêbacnê tomalageŋ. Ma latuagêc Esau agêc Jakob sêsuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau (nê ŋaê teŋ gebe Edom) nê wakuc tau tonec. ");
INSERT INTO jae_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau gêjam lauo aŋga lau gamêŋ Kanaanŋa latuŋio nêŋ. Ŋac gamêŋ Hetŋa Elon latuo Ada ma Ana latuo Oholibama. Ana eŋ ŋac gamêŋ Hibŋa Sibeon latu. ");
INSERT INTO jae_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ma Ismael latuo Basemat, Nebajot luo eŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ma Ada kêkôc Esau latu Elipas ma-Basemat kêkôc Reuel. ");
INSERT INTO jae_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ma Oholibama kêkôc Jeus, Jalam ma Kora. Esau latui tau tonaŋ, taŋ teneŋi sêkôc êsêac aŋga gamêŋ Kanaan. ");
INSERT INTO jae_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Go Esau kejoŋ nê lauo ma latuio to ŋac ma nê lau samob, nê bulimakao to nê bôc samob ma nê waba, taŋ kêtap sa gêdêŋ taŋ eŋ gêmoa gamêŋ Kanaan naŋ, ma gêc lasi Jakob su gêja gamêŋ jaêc. ");
INSERT INTO jae_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Gebe êsêagêcnêŋ waba taêsam ŋasec, tec êsêagêc têtôm gebe sêmoa sêwiŋ tauŋ atom ma gamêŋ, taŋ êsêagêc sêmoa naŋ, kêtôm gebe êlôm nêŋ bôc atom. ");
INSERT INTO jae_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kêtu tonaŋŋa Esau jagêŋgôŋ gamêŋ lôcŋa Seir. (Esaunê ŋaê teŋ gebe Edom.) ");
INSERT INTO jae_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Lau Edom tameŋi Esau, taŋ gêŋgôŋ gamêŋ lôcŋa Seir naŋ, nê wakuc tau tonec. ");
INSERT INTO jae_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau latui nêŋ ŋaê tau tonec gebe Esaunê awê Ada latu Elipas, Esaunê awê Basemat latu Reuel. ");
INSERT INTO jae_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipas latui Teman, Omar, Sepo, Gatam ma Kenas. ");
INSERT INTO jae_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","(Esau latu Elipas nê awê teŋ gebe Timna. Eŋ kêkôc Elipas latu Amalek.) Esaunê awê Ada latui tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel latui tau tonec gebe Nahat, Sera, Sama ma Misa. Esaunê awê Basemat latui tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaunê awê Sibeon latu Ana latuo Oholibama nê latui tonec. Eŋ kêkôc Esau latui Jeus, Jalam ma Kora. ");
INSERT INTO jae_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau latuinêŋ kasêga tonec. Esaunê ŋacsêga Elipas latui tonec gebe kasêga Teman, Omar, Sepo, Kenas, ");
INSERT INTO jae_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ma Amalek. Elipasnê kasêga êsêac, taŋ sêŋgôŋ gamêŋ Edom. Ada latui êsêac. ");
INSERT INTO jae_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau latu Reuel latui tonec gebe kasêga Nahat, Sera, Sama ma Misa. Reuelnê kasêga êsêac, taŋ sêŋgôŋ gamêŋ Edom. Esaunê awê Basemat latui êsêac. ");
INSERT INTO jae_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaunê awê Oholibama latui tonec gebe Jeus, Jalam ma Kora. Esaunê awê Ana latuo Oholibama kêkôc kasêga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esau (nê ŋaê teŋ gebe Edom) latui to nêŋ kasêga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ŋac gamêŋ Horŋa Seir latui, taŋ sêŋgôŋ gamêŋ tonaŋ naŋ, tonec gebe Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO jae_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser ma Disan. Seir latui êsêac, taŋ têtu lau gamêŋ Horŋa nêŋ kasêga aŋga gamêŋ Edom. ");
INSERT INTO jae_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan latui tau tonec gebe Hori agêc Heman. Lotan luo Timna. ");
INSERT INTO jae_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal latui tau tonec gebe Alwan, Manahat, Ebal, Sepo ma Onam. ");
INSERT INTO jae_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon latui tau tonec gebe Aia agêc Ana. Eŋ Ana, taŋ katap bumata ŋandaŋ sa gêdêŋ taŋ gejob tama Sibeon nê doŋki aŋga gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ananê gôlôac tonec gebe Dison agêc Oholibama, Ana latuo. ");
INSERT INTO jae_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison latui tonec gebe Hemdan, Esban, Itran ma Keran. ");
INSERT INTO jae_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser latui tonec gebe Bilan, Sawan ma Akan. ");
INSERT INTO jae_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan latui tonec gebe Us agêc Aran. ");
INSERT INTO jae_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Lau gamêŋ Horŋa nêŋ kasêga tau tonec gebe Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO jae_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser ma Disan. Lau gamêŋ Horŋa nêŋ kasêga tonaŋ têtôm êsêacnêŋ gôlôac aŋga gamêŋ Seir. ");
INSERT INTO jae_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kiŋ, taŋ sêjam gôliŋ gamêŋ Edom gêdêŋ têm, taŋ kiŋ teŋ gêjam gôliŋ lau Israel atom tageŋ naŋ, tau tonec. ");
INSERT INTO jae_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor latu Bela gêjam gôliŋ Edom. Ênê malac ŋaê gebe Dinhaba. ");
INSERT INTO jae_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela gêmac êndu ma Sera aŋga Bosra latu Jobab gêjam gôliŋ gêjô eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab gêmac êndu ma Husam aŋga lau Teman nêŋ gamêŋ gêjam gôliŋ gêjô eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam gêmac êndu ma Bedad, taŋ kêku Midian tulu aŋga Moabnêŋ gamêŋ naŋ, latu Hadad gêjam gôliŋ gêjô eŋ su. Ênê malac ŋaê gebe Awit. ");
INSERT INTO jae_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad gêmac andu ma Samla aŋga Masreka gêjam gôliŋ gêjô eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla gêmac êndu ma Saul aŋga Rehobot, taŋ gêc bu Euprat ŋatali naŋ, gêjam gôliŋ gêjô eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul gêmac êndu ma Akbor latu Bal-Hanan gêjam gôliŋ gêjô eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor latu Bal-Hanan gêmac êndu ma Hadar gêjam gôliŋ gêjô eŋ su. Ênê malac ŋaê Pau. Ênê awênê ŋaê Mehetabel. Eŋ Mesahab latuo Matred nê latuo. ");
INSERT INTO jae_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esaunê kasêganêŋ ŋaê tau tonec têtôm nêŋ gôlôac to nêŋ gamêŋ sêŋgôŋŋa. Kasêga Timna, Alwa, Jetet, ");
INSERT INTO jae_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO jae_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibsar, ");
INSERT INTO jae_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram. Edom (ŋaê teŋ gebe Esau, taŋ kêtu Edom tama) nê kasêga tonaŋ kêtôm nêŋ gamêŋ sêŋgôŋŋa aŋga tauŋ nêŋ nom. ");
INSERT INTO jae_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob gêŋgôŋ gamêŋ Kanaan, gamêŋ, taŋ tama gêŋgôŋ amboac ŋac jaba naŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jakobnê gôlôacnêŋ miŋ tau tonec. Josepnê jala kêtu 17. Eŋ gejob bôc gamoa gêwiŋ têwai. Eŋ ŋapalê matacgeŋ gêmoa gêwiŋ tamanê lauo Bilha agêc Silpa nêŋ latuŋi. Ma Josep kêdôŋ êsêacnêŋ biŋ keso gêdêŋ tameŋi. ");
INSERT INTO jae_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma Jakob têtac gêwiŋ Josep kêlêlêc nê gôlôac ŋagêdô su, gebe eŋ gêlic eŋ amboac latu, taŋ kêka eŋ lasê gêdêŋ kêtu ŋamalacanô su. Ma eŋ kêsi êna ŋakwê baliŋ teŋ toŋalêma. ");
INSERT INTO jae_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mago gêdêŋ taŋ têwai sêlic gebe tameŋi têtac gêwiŋ eŋ kêlêlêc latui ŋagêdô samob su naŋ, êsêac têntac sec gêdêŋ eŋ ma sêsôm biŋ malô teŋ gêdêŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gêdêŋ ŋasawa teŋ Josep gêc mê teŋ. Eŋ gajac miŋ biŋ tau gêdêŋ têwai ma êsêac têntac sec ŋanôgeŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Eŋ kêsôm gêdêŋ êsêac gebe “Akêŋ taŋem mê, taŋ aê gaêc naŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Aêac tajac lagic polom toŋakaiŋ tamoa kôm, tec aêŋoc lagic gêjac sa jakêkô ma amacnêm mêŋsêgi aêŋoc auc ma sewec gêdêŋ ŋoc lagic.” ");
INSERT INTO jae_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Têwai sêsôm gêdêŋ eŋ gebe “Aôm gobe ônam gôliŋ aêac ma ôtu aêacma kiŋ me.” Ma êsêac têntac sec samucgeŋ gêdêŋ eŋ kêtu ênê ma to biŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Go eŋ gêc mê teŋ kêtiam ma jagêjac miŋ gêdêŋ têwai ma kêsôm gebe “Alic acgom, aê gaêc mê teŋ kêtiam. Oc to alôŋ ma utitalata 11 sewec gêdêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Biŋ tonaŋ eŋ gêjac miŋ gêdêŋ tama to têwai. Tec tama gec biŋ eŋ ma kêsôm gêdêŋ eŋ gebe “Mê, taŋ aôm gôêc naŋ, ŋam amboac ondoc. Aêagêc tênam to têwami wacapôŋ aeŋduc êndêŋ aôm biŋŋanôgeŋ me.” ");
INSERT INTO jae_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ma têwai sêjam lêmuŋ eŋ, mago tama taê gêjam biŋ tau gêc nê ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ma têwai jasejop tameŋinê bôc sêmoa Sikem ŋagala. ");
INSERT INTO jae_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ma Israel kêsôm gêdêŋ Josep gebe “Aôm gôlicgac me, têwami sejop bôc sêmoa Sikem. Ômôêŋ acgom, aê gabe jasakiŋ aôm ôndêŋ êsêac ôna.” Ma Josep kêsôm gêdêŋ eŋ gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tec eŋ kêsôm gêdêŋ eŋ gebe “Galoc ôna ma ônac têwami to bôc kêsi ma ômu ômôêŋ ôkêŋ ŋawae êndêŋ aê.” Tec kêsakiŋ eŋ aŋga gaboaŋ Hebronŋa e jagêô lasê Sikem. ");
INSERT INTO jae_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ma ŋac teŋ kêtap eŋ sa geo gêmoa kôm ŋalêlôm. Ma ŋac tau kêtu kênac eŋ gebe “Aôm gosom asageŋ.” ");
INSERT INTO jae_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Eŋ kêsôm gebe “Aê gasom teoci. Ôsôm êndêŋ aêmaŋ, êsêac sejop bôc sêmoa ondoc.” ");
INSERT INTO jae_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ma ŋac tau kêsôm gebe “Êsêac sêc sêja gebe aê gaŋô êsêac sêsôm gebe ‘Taêc tana Dotanmaŋ.’” Tec Josep kêdaguc têwai e jakêtap êsêac sa sêmoa Dotan. ");
INSERT INTO jae_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Êsêac sêlic eŋ kêsa jaêcgeŋ, mêŋkêdabiŋ êsêac atom tageŋ, ma ac sêkic ênê biŋ gebe sênac eŋ êndu. ");
INSERT INTO jae_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Êsêac sêsôm gêdêŋ tauŋ gebe “Op, mê ŋatau gêmêŋgac. ");
INSERT INTO jae_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ajôc, tanac eŋ êndumaŋ ma tambaliŋ eŋ êsêp sê teŋ, go tasôm gebe bôc sec teŋ geŋ eŋ su ma talic ênê mê ŋanô acgom.” ");
INSERT INTO jae_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mago Ruben gêŋô biŋ tau ma gebe ênam eŋ kêsi aŋga êsêac lemeŋ, tec kêsôm gebe “Danseŋ eŋ su atom.” ");
INSERT INTO jae_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ma Ruben kêsôm gêdêŋ êsêac gebe “Akêc dec siŋ atom, naambaliŋ eŋ êsêp sê tônê êmoa gamêŋ sawa, mago lemem êpi eŋ atom.” Eŋ gebe ênam eŋ sa aŋga êsêac lemeŋ e êsakiŋ eŋ êmu êndêŋ tama êna êtiam, tec kêsôm biŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Gêdêŋ taŋ Josep mêŋgêô lasê têwai naŋ, êsêac sêkwalec ênê ŋakwê baliŋ su, ŋakwê baliŋ tau, taŋ eŋ kêsô naŋ toŋalêma, ");
INSERT INTO jae_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ma sêkôc eŋ tôŋ jasêbaliŋ eŋ kêsêp sê teŋ gêja. Sê tau ŋakeleŋ, bu kêpoac ŋalêlôm atom. ");
INSERT INTO jae_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Go êsêac sêŋgôŋ sic gebe sêniŋ gêŋ. Ac sêôc mateŋanô sa e sêlic lau Ismael pom teŋ aŋga Gilead tonêŋ kamele sêmêŋ, taŋ sejoŋ katêkwi to gêŋmalu ma niptêkwi sebe sêsêp Aiguptu sêna. ");
INSERT INTO jae_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Go Juda kêsôm gêdêŋ nê lasitêwai gebe “Aêac embe tanac lasiŋi êndu to tasiŋ ênê dec ôkwi, oc tatap ŋanô amboac ondoc sa. ");
INSERT INTO jae_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ajôc, takêŋ eŋ êndêŋ lau Ismael sênam ôli eŋ ma aêac lemeŋ êpi eŋ atom gebe eŋ kêtu aêac lasiŋi. Aêacnêŋ dec tageŋ.” Ma ênê lasitêwai sêkêŋ taŋeŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ma têtulu-gêŋwaga aŋga Midian sêsêlêŋ sêôc lêlêc êsêac. Go Josep têwai sê eŋ sa aŋga sêlêlôm ma sêkêŋ eŋ gêdêŋ lau Ismael sêjam ôli eŋ ŋa silber ŋadôŋ 20. Ma êsêac sêkôc Josep sêja Aiguptu. ");
INSERT INTO jae_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ma Ruben gêmu gêja sê e gêlic Josep jaôb tageŋ, tec kêkac nê ŋakwê gêŋgic ");
INSERT INTO jae_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ma gêmu gêdêŋ lasii jakêsôm gebe “Ŋapalê malamê. Ma aê, aê oc jaêc jasa ondoc jana.” ");
INSERT INTO jae_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Go êsêac sêkôc Josepnê ŋakwê jasêjac noniŋ teŋ êndu ma sêsac ŋakwê tau tôŋ kêsêp ŋadec. ");
INSERT INTO jae_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ma êsêac sêsakiŋ ŋakwê baliŋ toŋalêma ma sêkêŋ gêdêŋ tameŋi ma sêsôm gebe “Aêac atap gêŋ tonec sa. Ôlic acgom, latômnê ŋakwê me masi.” ");
INSERT INTO jae_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ma eŋ kêjala gêŋ tau ma kêsôm gebe “Latucnê ŋakwêgoc. Bôc sec teŋ kêkac Josep popoc ma geŋ eŋ biŋŋanôgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Go Jakob kêkac nê ŋakwê gêŋgic ma kêsô talu kêtu nê ŋakwê ma kêtaŋ latu ŋataŋiboa gêmoa bêc taêsam. ");
INSERT INTO jae_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Latuio to ŋac samob dêdi sebe sênam malô-malô eŋ, mago eŋ gedec gebe sênam malô eŋ ma kêsôm gebe “Masi, aê totaŋiboageŋ jasêp lamboam jawiŋ latuc jana.” Tama kêtaŋ-kêtaŋ eŋ amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kêtaŋ gêmoa ma lau Midianŋa sêkêŋ Josep gêdêŋ Potipar aŋga Aiguptu gêjam ôli eŋ. Eŋ Paraonê gejobwagasêga teŋ, taŋ kêtu lau siŋwaga nêŋ laumata. sêsô ŋakwê laŋgwa me talu. ");
INSERT INTO jae_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Gêdêŋ ŋasawa tonaŋ Juda gêwi nê lasitêwai siŋ-ma jakêsap ŋac gamêŋ Adulamŋa teŋ tôŋ, nê ŋaê gebe Hira. ");
INSERT INTO jae_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Aŋga ônê Juda gêlic ŋac gamêŋ Kanaanŋa Sua latuo. Eŋ gêjam eŋ kêtu ênê awê ma gêmoa gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ma eŋ kêkêkam ŋapalê e kêkôc latu teŋ. Ma eŋ gê ênê ŋaê gebe Er. ");
INSERT INTO jae_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Go eŋ kêkêkam ŋapalê teŋ kêtiam e kêkôc latu teŋ ma gê ênê ŋaê gebe Onan. ");
INSERT INTO jae_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma kêkôc latu teŋ kêtiam ma gê ênê ŋaê gebe Sela. Gêdêŋ taŋ kêkôc Sela naŋ, eŋ gêmoa Kesib. ");
INSERT INTO jae_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ma Juda kêjaliŋ awê teŋ sa ma kêkêŋ gêdêŋ ŋacsêga Er. Ênê ŋaê gebe Tamar. ");
INSERT INTO jae_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mago Juda latu ŋacsêga Er gêjac Apômtau mataanô ŋajam atom, tec Apômtau geseŋ eŋ su. ");
INSERT INTO jae_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Go Juda kêsôm gêdêŋ Onan gebe “Ôndêŋ têwamnê awê ôna ma ônam eŋ ôjô têwam ma ôkêŋ ŋawê ajô têwam su.” ");
INSERT INTO jae_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mago Onan kêjala gebe ŋapalê oc têtu ênê atom, tec gêdêŋ taŋ eŋ gêmoa gêwiŋ têwanê awê naŋ, kêkêc sulu kêsêp nom gebe têwa êtap wakuc sa atom. ");
INSERT INTO jae_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mago Apômtau gêlic gêŋ, taŋ eŋ gêgôm naŋ, ŋajam atom ma geseŋ eŋ su amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Go Juda kêsôm gêdêŋ lawao Tamar gebe “Ôŋgôŋ tamamnê andu amboac awêtuc teŋ e latuc Sela êtu kapôêŋ acgom.” Gebe eŋ kêtêc tau gebe moae Sela êmac êndu amboac tonaŋ êtôm têwaagêc. Amboac tonaŋ Tamar gêja gêŋgôŋ tamanê andu. ");
INSERT INTO jae_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Jala ŋagêdô gêjaŋa acgom, go Sua latuo, taŋ Juda gêjam naŋ, gêmac êndu. Gêdêŋ taŋ Juda kêkac kaukauc su naŋ, êsêagêc nê ŋac Hira aŋga Adulam sêpi Timna dêdêŋ nê lau sêkapiŋ-domba-ŋaôliluwaga sêja. ");
INSERT INTO jae_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ma êsêac sêsôm gêdêŋ Tamar gebe “Lawam kêpi Timna gêja gebe êkapiŋ nê domba ŋaôlilu.” ");
INSERT INTO jae_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tec eŋ kêkac nê abec su ma gi tau auc ŋa obo lala ma gêŋgôŋ Enaim ŋasacgêdô, taŋ gêc intêna Timnaŋa naŋ. Eŋ gêlic Sela kêtu kapôêŋ su, mago sêkêŋ eŋ kêtu ênê awê su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Gêdêŋ taŋ Juda gêlic eŋ naŋ, gêjam kauc gebe awê mockaiŋo teŋ, gebe gêsaŋ laŋôanô auc. ");
INSERT INTO jae_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Eŋ gelom gêdêŋ eŋ gêja intêna ŋamakeŋ jakêsôm gebe “Ômôêŋ, aê gabe jamoa jawiŋ aôm.” Gebe eŋ kêjala atom gebe lawao. Ma awê tau kêsôm gebe “Aôm embe ômoa ôwiŋ aê, go ôkêŋ asageŋ êndêŋ aê êjô.” ");
INSERT INTO jae_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Eŋ kêsôm gebe “Aê gabe jasakiŋ noniŋ kapoac ŋalatu aŋga bôc ŋatoŋ êndêŋ aôm.” Ma eŋ kêsôm gebe “Aôm gobe ôkêŋ kamaclauŋ teŋ êndêŋ aê e êndêŋ ŋanoc ôsakiŋ gêŋ tauŋa me masi.” ");
INSERT INTO jae_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Eŋ kêsôm gebe “Aê jakêŋ asageŋ êtu kamaclauŋ êndêŋ aôm.” Eŋ gêjô eŋ awa gebe “Ôkêŋ nêm ŋatalô êwa aôm saŋa, taŋ sepeŋ kêsêp ki naŋ, toŋalêkôŋgeŋ ma nêm tôc, taŋ kômêgôm naŋ, êndêŋ aê.” Tec eŋ kêkêŋ gêŋ tau gêdêŋ eŋ ma gêmoa gêwiŋ eŋ e taê. ");
INSERT INTO jae_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Go awê tau gêdi ma gêc gêja. Ma eŋ kêkac nê obo lala su ma gêjam abec kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ma Juda kêsakiŋ nê ŋac aŋga Adulam kêkôc noniŋ ŋalatu gêja gebe êkôc kamaclauŋ aŋga awênê êmu êmêŋ, mago kêtap eŋ sa atom. ");
INSERT INTO jae_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tec eŋ kêtu kênac lau malacŋa gebe “Awê mockaiŋo, taŋ gêŋgôŋ intêna Enaimŋa ŋatali naŋ, gêmoa ondoc.” Ma êsêac sêsôm gebe “Awê mockaiŋo teŋ gêmoa tonec atom.” ");
INSERT INTO jae_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tec eŋ gêmu gêdêŋ Juda jakêsôm gebe “Aê katap eŋ sa atom ma lau malacŋa sêsôm gebe awê mockaiŋo teŋ gêmoa tonec atom.” ");
INSERT INTO jae_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ma Juda gêjô eŋ awa gebe “Amboac tonaŋ êkôc gêŋ tau êtu ênê gêŋmaŋ, gebe lau sêômac aê atom. Aôm gôlicgac gebe aê kasakiŋ noniŋ ŋalatu gêja su, mago aôm kôtap eŋ sa atom.” ");
INSERT INTO jae_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ŋasawa amboac ajôŋ têlêac gêjaŋa, tec sêjac miŋ gêdêŋ Juda gebe “Lawamo Tamar gêgôm gêŋ mockaiŋoŋa e galoc kêkêkam ŋapalê gêmoa.” Ma Juda kêsôm gebe “Akôc eŋ êsa êna ma akêŋ ja êniŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ma êsêac sêwê eŋ kêsa gêja, tec eŋ kêsakiŋ biŋ gêdêŋ lawa gebe “Ŋac, taŋ kêtu gêŋ tonaŋ ŋatau naŋ, kêtu ŋapalê tama.” Ma eŋ kêsôm gebe “Ôsala gêŋ tau ŋapepgeŋ. Ŋatalô êwa ŋatau saŋa, taŋ sepeŋ kêsêp ki naŋ toŋalêkôŋ ma tôc nec ŋatau asa.” ");
INSERT INTO jae_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ma Juda kêjala gêŋ tau ma kêsôm lasê gebe “Eŋ awê gêdêŋ kêlêlêc aê su gebe aê kakêŋ latuc Sela gêdêŋ eŋ atom.” Ma eŋ gêmoa gêwiŋ eŋ kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Gêdêŋ eŋ êkôc ŋapalê ŋanoc naŋ kêkôc ôliŋbôm. ");
INSERT INTO jae_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gêdêŋ taŋ ŋapalê kêtuŋ eŋ gêmoa naŋ, ŋapalê teŋ kêkêŋ lêma kêsa gêmêŋ. Ma jaomwagao kêkôc lêkôŋ kokoc ma kêkic tôŋ kêpi ŋapalê lêma ma kêsôm gebe “Tonec gêô lasê kêtu ŋamata.” ");
INSERT INTO jae_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mago eŋ kêtaiŋ lêma su ma ŋac teŋ kêsa gêmêŋ ma jaomwagao kêsôm gebe “Aôm gôc nêm intêna gêŋgicgac.” Tec sê ênê ŋaê gebe Peres. ");
INSERT INTO jae_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Go lasi kêdaguc tolêkôŋ kokoc gêc lêma, ma sê ênê ŋaê gebe Sera. ");
INSERT INTO jae_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ma êsêac sêkôc Josep sêsêp Aiguptu sêja ma Paraonê kasêga teŋ, ŋac Aiguptuŋa Potipar, taŋ gejob siŋwaga toŋ teŋ naŋ, gêjam ôli eŋ aŋga lau Ismael, taŋ sêkôc eŋ gêja ônê naŋ nêŋ. ");
INSERT INTO jae_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Apômtau gêwiŋ Josep, tec gêjam kôm samob toŋanôgeŋ gamoa nê ŋatau, ŋac Aiguptuŋa, nê andu. ");
INSERT INTO jae_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ma ênê ŋatau gêlic gebe Apômtau gêwiŋ eŋ ma kêmoasiŋ eŋ, tec gêgôm gêŋ samob ŋapep sawa. ");
INSERT INTO jae_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Kêtu tonaŋŋa eŋ gêlic eŋ ŋajam ma kêkêŋ eŋ kêtu tau nê sakiŋwaga ma eŋ gêgôm eŋ kêtu ênê andu ŋagejobwagasêga ma kêkêŋ eŋ gejob ênê waba samob. ");
INSERT INTO jae_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Gêdêŋ têm taŋ eŋ kêkêŋ eŋ kêtu andu to êna waba samob ŋagejobwagasêga naŋ, Apômtau gêjam mec ŋac Aiguptuŋa nê andu kêtu Josepŋa. Apômtau gêjam mec ênê waba samob aŋga andu to kôm kêtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kêtu tonaŋŋa eŋ kêkêŋ gêŋ samob kêsêp Josep lêma ma taê kêka eŋgeŋ, gê go tau kêtu nê gêŋ ŋagêdôŋa atomanô, nê gêŋ êniŋŋa tageŋ, tec tau gejob. Josep eŋ ŋac ŋajam ma ŋac tolaŋô. ");
INSERT INTO jae_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Têm ŋagêdô gêjaŋa, tec ênê ŋataunê awa mata ola Josep ma kêsôm gebe “Mêŋônêc ôwiŋ aê.” ");
INSERT INTO jae_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mago eŋ gedec ma kêsôm gêdêŋ nê ŋataunê awê gebe “Ôlic acgom, ŋoc ŋatau taê kêka aêgeŋ ma gê go tau nê andu ŋagêŋlêlôm teŋŋa atom ma eŋ kêkêŋ gêŋ samob kêsêp aê lemoc. ");
INSERT INTO jae_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Eŋ ŋac kapôêŋ kêlêlêc aê aŋga andu tonec atom ma kêgamiŋ gêŋ teŋ gêdêŋ aê atom, aôm taômgeŋ gebe aôm kôtu ênê awê. Tec aê jaŋgôm gêŋ alôb-alôb kapôêŋ tonec ma jaŋgôm sec êndêŋ Anôtô êtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Eŋ kêsôm biŋ gêdêŋ Josep katôm bêcgeŋ, mago eŋ kêkêŋ taŋa awê atom ma gêc to gêmoa gêwiŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bêc teŋ Josep jakêsô andu gebe ênam nê kôm ma ŋac teŋ gêmoa andu ŋalêlôm gêwiŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tec awê gê ênê ŋakwê tôŋ ma kêsôm gebe “Ônêc ôwiŋ aê.” Mago eŋ gêwi nê ŋakwê siŋ kêsêp eŋ lêma ma gêc kasa aŋga andu gêja. ");
INSERT INTO jae_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ma gêdêŋ taŋ awê gêlic eŋ gawi nê ŋakwê siŋ kêsêp eŋ lêma ma gêc kêsa aŋga andu gêja naŋ, ");
INSERT INTO jae_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","eŋ gêmôêc nê sakiŋwaga ma kêsôm gêdêŋ êsêac gebe” Alic acgom, ŋoc ŋatau kêkêŋ ŋac Ebolaiŋa teŋ gêmoa gêwiŋ aêac gebe êŋgôm aêac majeŋ êsa. Eŋ kêsô gêdêŋ aê gamêŋ gebe ênêc êwiŋ aê. Mago aê gamôêc aoc kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Eŋ gêŋô aê kawakic to gamôêc, tec gedec nê ŋakwê gêcŋa ma gêc kêsa aŋga andu gêja.” ");
INSERT INTO jae_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Go awê ketoc Josepnê ŋakwê gêc gêwiŋ eŋ e nê ŋatau gêmu gamêŋ. ");
INSERT INTO jae_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ma eŋ gajac miŋ biŋ tonaŋgeŋ gêdêŋ eŋ ma kêsôm gebe “Sakiŋwaga Ebolaiŋa, taŋ kôkêŋ eŋ gêmoa gêwiŋ aêac naŋ, kêsô gamêŋ gebe aŋgôm aê majoc êsa. ");
INSERT INTO jae_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mago gêdêŋ taŋ aê kawakic to gamôêc naŋ, eŋ gedec nê ŋakwê gêcŋa ma gêc kêsa aŋga andu gêja.” ");
INSERT INTO jae_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ênê ŋatau gêŋô biŋ, taŋ nê awê kasôm gêdêŋ eŋ naŋ, gebe “Aômnêm sakiŋwaga gêgôm aê amboac tonaŋ,” tec eŋ têtac ŋandaŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ma eŋ kêkôc Josep gêja ma kêbaliŋ eŋ kêsêp kapoacwalô, gamêŋ, taŋ kiŋnê lau kapoacwalôwaga sêŋgôŋ naŋ. Ma eŋ gêŋgôŋ kapoacwalô tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mago Apômtau gêwiŋ Josep e lau têntac gêwiŋ eŋ ma kapoacwalô ŋagejobwaga gêlic eŋ ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ma kapoacwalô ŋagejobwaga kêkêŋ lau kapoacwalôŋa samob, taŋ sêŋgôŋ kapoacwalô naŋ, sêsêp Josep lêma. Ma kôm samob, taŋ sêgôm naŋ, eŋ kêtu ŋatau. ");
INSERT INTO jae_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kapoacwalô ŋagejobwaga gê go tau kêtu kôm, taŋ kêsêp Josep lêma naŋŋa, atomanô, gebe Apômtau gêwiŋ Josep ma kêmoasiŋ ênê kôm samob e ŋapep sawa. ");
INSERT INTO jae_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tonaŋ su, ma têm ŋagêdô gêjaŋa acgom, go kiŋ Aiguptuŋa nê ŋac kêpip wain ŋanôŋa to nê ŋac kêpac polomŋa sêgôm keso teŋ gêdêŋ nêŋ ŋatau, kiŋ Aiguptuŋa tau. ");
INSERT INTO jae_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ma Parao têtac ŋandaŋ gêdêŋ nê laumata luagêc tonec, gêdêŋ laumata wainŋa to laumata polomŋa ");
INSERT INTO jae_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ma eŋ kêkêŋ êsêagêc sêsô siŋwaganêŋ kapitainê andu gebe sejopŋa. Andu kapoacwalôŋa tau, naŋ Josep gêŋgôŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ma siŋwaganêŋ kapitai kêkêŋ Josep gêjam sakiŋ êsêagêc. Ma êsêagêc sêŋgôŋ kapoacwalô ŋasawa ec teŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ma gêdêŋ gêbêc tageŋ êsêagêc lulugeŋ sêc ma teŋ-kiŋ Aiguptuŋa nê ŋac kêpip wain ŋanôŋa agêc ŋac kêpac polomŋa, taŋ sêŋgôŋ kapoacwalô naŋ — agêc sêc nêŋ mê keso tau ma agêc lulugeŋ nêŋ ma ŋam keso tau amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Gêdêŋ bêbêcgeŋ Josep gêdêŋ êsêagêc gêja ma gêlic êsêagêc semoa tonêŋ ŋalêlôm ŋawapacgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma eŋ kêtu kênac Paraonê laumata, taŋ sêŋgôŋ ênê ŋataunê andu sêwiŋ eŋ gebe sejop êsêacŋa naŋ, gebe “Agêc laŋômanô bêlê-bêlê kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Agêc sêsôm gêdêŋ eŋ gebe “Aêagêc aêc mê ma ŋac êwa mê ŋam saŋa teŋ gêmoa atom.” Ma Josep kêsôm gêdêŋ êsêagêc gebe “Kôm dawa ma saŋa gêjac Anôtô ŋawae. Anac miŋ mê tau êndêŋ aêmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Go laumata wainŋa gêjac miŋ nê mê gêdêŋ Josep ma kêsôm gêdêŋ eŋ gebe “Aê gaêc mê ma galic wain ŋamôkê teŋ kêkô. ");
INSERT INTO jae_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wain ŋamôkê tau ŋalaka têlêac kêkô. Ma gêŋ tau kêpô katôm e ŋaola kêsa sebeŋ ma gêjam ŋanô. ");
INSERT INTO jae_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Aê kakôc Paraonê laclu. Go kakôc wain ŋanô ma kapip ma katêwiŋ ŋatêkwi kêsap Paraonê laclu ma kakêŋ laclu tau kêsêp Parao lêma.” ");
INSERT INTO jae_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ma Josep kêsôm gêdêŋ eŋ gebe “Mê tonaŋ ŋam amboac tonec gebe Ŋalaka têlêac kêtôm bêc têlêac. ");
INSERT INTO jae_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Bêc têlêac ênaŋa acgom, go Parao êsa aôm têmbêlam sa ma êkêŋ aôm ônam sakiŋ eŋ êtiam. Aôm ôkêŋ laclu êsêp Parao lêma êtiam êtôm gôgôm gêdêŋ têm, taŋ kôtu ênê ŋac kêpip wain ŋanôŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mago aôm embe ômoa ŋajam, go taêm ênam aê. Taêm walô aê ma ôkêŋ aê ŋawae andaŋ Parao ma ônam aê sa gebe jawi andu tonec siŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Gebe êsêac sêjam geŋgeŋ aê aŋga Ebolainêŋ gamêŋ, ma aê gagôm gêŋ sec teŋ aŋga gamêŋ tonec kêtôm gebe sêmbaliŋ aê jasêp gêsuŋŋa atom.” ");
INSERT INTO jae_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Laumata polomŋa gêŋô gebe gêwa mê ŋam sa ŋajamgeŋ, tec kêsôm gêdêŋ Josep gebe “Aê gaêc ma teŋ amboac tonaŋgeŋ. Aê kakuc gadob polomŋa têlêac. ");
INSERT INTO jae_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ma gêŋ tokaiŋ-tokaiŋ, taŋ sêpac kêtu Paraoŋa naŋ, kêsêp gadob ŋaôŋa. Mago moc mêŋseŋ gêŋ aŋga gadob, taŋ aê kakuc naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ma Josep gêjô eŋ awa gebe “Ŋam amboac tonec gebe Gadob têlêac kêtôm bêc têlêac. ");
INSERT INTO jae_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Bêc têlêac ênaŋa acgom, go Parao êsa aôm têmbêlam sa gebe êkêŋ aôm ôŋkaleŋ ka teŋ ma moc sêkac nêm ŋamêsôm. ");
INSERT INTO jae_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Bêc kêtu têlêacŋa kêtu Paraonê bêc têna kêkôc eŋŋa, tec geno moasiŋ gêdêŋ nê sakiŋwaga samob ma kêsa ŋac kêpip wain ŋanôŋa agêc ŋac kêpac polomŋa teŋbeleŋ sa gêdêŋ nê sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Eŋ kêkêŋ sakiŋ wainŋa gêdêŋ ŋac kêpip wain ŋanôŋa gêwê kaiŋ kêtiam, tec kêkêŋ laclu kêsêp Parao lêma. ");
INSERT INTO jae_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mago eŋ kêkêŋ ŋac kêpac polomŋa geŋkaleŋ ka kêtôm Josep gêwa sa gêdêŋ êsêagêc su naŋ. ");
INSERT INTO jae_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tageŋ ŋac kêpip wain ŋanôŋa taê gêjam Josep atom, kêliŋ eŋ siŋ gacgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jala samuc luagêc gêjaŋa ma Parao gêc mê gebe kêkô bu Nil ŋatali ");
INSERT INTO jae_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ma gêlic bulimakao ŋajam to têtôp ŋajam 7 sêpi aŋga bu Nil mêŋseŋ siŋ ŋalauŋ sêmoa. ");
INSERT INTO jae_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Gocgo bulimakao sec toôliŋ ŋasaŋ kaiŋ teŋ 7 sêpi aŋga bu Nil têdaguc êsêac mêŋsêkô sêwiŋ bulimakao ŋagêdô sêmoa bu Nil ŋatali. ");
INSERT INTO jae_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ma bulimakao sec toôliŋ ŋasaŋ têdaŋgôŋ bulimakao ŋajam to têtôp ŋajam tau su e Parao mata gêlac. ");
INSERT INTO jae_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ma eŋ kêliŋ tau siŋ kêtiam e gêc mê kêtu luagêcŋa gebe Mopolom teŋ ŋakaiŋ tageŋ gêjam ŋanô ŋajam to kesewec kapôêŋ 7. ");
INSERT INTO jae_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Su, go gêlic ŋanô sec to ŋapaôma 7 mêŋkêpi, taŋ mu aŋga oc kêpiŋa kêlêsaŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Go ŋanô sec kêdaŋgôŋ ŋanô ŋajam to kapôêŋ 7 tau su e Parao mata gêlac ma kêsaê gebe gêc mê. ");
INSERT INTO jae_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Gêdêŋ bêbêc eŋ gamoa tonê ŋalêlôm ŋawapacgeŋ. Kêtu tonaŋŋa eŋ kêsakiŋ biŋ gêdêŋ lau seoc biŋ lasêwaga to gêdêŋ lau tokauc samob, taŋ sêmoa Aiguptu naŋ, gebe sêmêŋ ma gêjac miŋ nê mê gêdêŋ êsêac. Mago êsêacnêŋ ŋac teŋ kêtôm gebe êwa mê ŋam sa êndêŋ Parao atom. ");
INSERT INTO jae_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Gêdêŋ tonaŋ go ŋac kêpip wain ŋanôŋa kêsôm gêdêŋ Parao gebe “Ocsalô tonec aê taêc gêjam ŋoc keso. ");
INSERT INTO jae_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Gêdêŋ taŋ Parao têtac ŋandaŋ gêdêŋ nê sakiŋwaga ma kêkêŋ aêagêc ŋac polomŋa aŋgôŋ siŋwaganêŋ kapitainê andu gebe sejop aêagêcŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","aêagêc aêc ma gêdêŋ gêbêc tageŋ ma aêagêcma ma keso tau to ŋam keso tau amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ŋacseŋom Ebolaiŋa teŋ gêŋgôŋ gêwiŋ aêagêc. Eŋ kêtu siŋwaganêŋ kapitainê sakiŋwaga teŋ. Aêagêc ajac miŋ ma ma gêdêŋ eŋ ma eŋ gêwa mê ŋam sa gêdêŋ aêagêc. Eŋ gêwa sa gêdêŋ aêagêc gêdêŋ-gêdêŋgeŋ katôm ma ma tau. ");
INSERT INTO jae_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma biŋ tau, taŋ gêwa sa gêdêŋ aêagêc naŋ, ŋanô kêsa. Sêsuŋ ŋoc sakiŋ gêdêŋ aê kêtiam ma sêkêŋ ŋac kêpac polomŋa geŋkaleŋ ka.” ");
INSERT INTO jae_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tec Parao kêsakiŋ lau gebe sêmôêc Josep. Êsêac sêkôc eŋ sebeŋ sa aŋga gêsuŋ. Eŋ kêkaliŋ tau ma kêsô ŋakwê wakuc sa su acgom, go kêsô jakêkô Parao laŋônêm. ");
INSERT INTO jae_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Tec Parao kêsôm gêdêŋ Josep gebe “Aê gaêc ma teŋ ma ŋamalac teŋ kêtôm gebe êwa ma tau ŋam saŋa gamoa atom. Mago aê gaŋô aôm ŋawae gebe aôm embe ôŋô ma teŋ, go ôtôm gebe ôwa ŋam sa solop.” ");
INSERT INTO jae_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josep gêjô Parao awa gebe “Biŋ amboac tonaŋ gêc aêŋa atom. Anôtô tau êjô aôm awam ma awa nêm ma sa ŋajamgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Go Parao kasôm gêdêŋ Josep gebe “Aê gaêc ma gebe kakô bu Nil ŋatali ");
INSERT INTO jae_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ma bulimakao ŋajam to têtôp ŋajam 7 sêpi aŋga bu Nil mêŋseŋ siŋ ŋalauŋ sêkô. ");
INSERT INTO jae_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ma bulimakao 7 kêtiam sêpi têdaguc êsêac. Êsêac ôliŋ ŋasaŋ to sec ma ŋatêkwa ŋaôma. Aê galic gêŋ teŋ amboac tonaŋ sêmoa Aiguptunêŋ gamêŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma bulimakao ôliŋ ŋasaŋ to sec gacgeŋ têdaŋgôŋ bulimakao ŋamataŋa 7, taŋ têtôp ŋajam naŋ su. ");
INSERT INTO jae_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Mago gêdêŋ taŋ têdaŋgôŋ êsêac su naŋ, talic êsêac amboac têdaŋgôŋ gêŋ teŋ atom, ôliŋ ŋasaŋ ŋaômageŋ sêmoa katôm gêmuŋŋa. E matoc gêlac. ");
INSERT INTO jae_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ma aê gaêc ma teŋ kêtiam naŋ galic mopolom ŋakaiŋ tageŋ gêjam ŋanô 7. Ŋanô tau ŋajam to kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ma galic ŋanô 7 gêuc mêŋkêpi kêdaguc. Gêŋ tau kêmêliŋ ma ŋapaôma to mu aŋga oc kêpiŋa kêlêsaŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma ŋanô ŋapaôma kêdaŋgôŋ ŋanô ŋajam 7. Aê gajac miŋ biŋ tonaŋ gêdêŋ lau-seoc-biŋ-lasêwaga, mago êsêacnêŋ ŋac teŋ kêtôm gebe awa ma tau ŋam sa atom.” ");
INSERT INTO jae_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ma Josep kêsôm gêdêŋ Parao gebe “O Parao, nêm mê luagêc tau ŋam tageŋ. Anôtô geoc biŋ, taŋ eŋ gebe êŋgôm naŋ, lasê gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulimakao ŋajam 7 to polom ŋanô ŋajam 7 têtôm jala 7. Ma lulu tau ŋam tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma bulimakao ŋatêkwa ŋaôma to sec 7, taŋ mêŋsêpi têdaguc êsêac naŋ, têtôm jala 7. Ŋanô 7 ŋapaôma to mu aŋga oc kêpiŋa kêlêsaŋ atôm jala 7 totôbôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Amboac kasôm gêdêŋ aôm su gebe Anôtô kêtôc gêŋ, taŋ gebe êŋgôm naŋ, gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","alic acgom, galoc jala 7 tomoasu ênêc Aiguptu ŋagamêŋ samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mago tonaŋ su, go jala totôbôm 7 mêŋêsa ma êsêac saliŋ têm moasuŋa siŋ samucgeŋ aŋga Aiguptu. Tôbôm enseŋ gamêŋ su. ");
INSERT INTO jae_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ma êsêac sênam kauc moasu aŋga gamêŋ tau atu tôbôm, taŋ mêŋêsa êndaŋguc naŋŋa, ma tôbôm tau oc anam sêga. ");
INSERT INTO jae_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Aôm gôêc mê kêtu dim luagêc ŋam gebe Anôtô taê gêjam biŋ tau kêtu tôŋ sugac, ma sauŋgeŋ, go Anôtô êŋgôm gêŋ tau ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Amboac tonaŋ galoc aôm ôjaliŋ ŋac wapac ma ŋac tokauc teŋ sa ma ôkêŋ eŋ ênam gôliŋ gamêŋ Aiguptu. ");
INSERT INTO jae_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Aôm ôkêŋ gejobwaga êtôm gamêŋ samobgeŋ. Êndêŋ jala tomoasu 7 tonaŋ lau embe têtap polom talu lemeŋ teŋ-lemeŋ teŋ sa, go sêkôc talu tageŋ-tageŋ su aŋga êsêacnêŋ atôm gamêŋ Aiguptuŋa samob. ");
INSERT INTO jae_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ôjatu gebe sênac polom sasa êndêŋ jala ŋajam, taŋ mêŋêsa naŋ, ma sênac polom tau tôŋ sênam aôm laŋôm. Sejoŋ polom ŋanô samob sêpi malacsêgageŋ êna ma sejop tôŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Gêŋ masê tonaŋ ênêc e êlôm lau gamêŋ tonaŋŋa êndêŋ jala totôbôm 7, taŋ mêŋêsa aŋga Aiguptu naŋ, gebe tôbôm enseŋ gamêŋ tau popoc atom.” ");
INSERT INTO jae_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Parao to nê sakiŋwaga samob sêŋô biŋ tonaŋ ŋajam. ");
INSERT INTO jae_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ma Parao kêsôm gêdêŋ nê sakiŋwaga gebe “Aêac oc tatap ŋac, taŋ Anôtônê Ŋalau gêjam eŋ auc kêtôm ŋac tonec naŋ, teŋ sa me masi.” ");
INSERT INTO jae_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tec Parao kasôm gêdêŋ Josep gebe “Anôtô kêtôc gêŋ samob tonaŋ gêdêŋ aôm, kêtu tonaŋŋa ŋac wapac ma ŋac tokauc teŋ kêtôm aôm gamoa atom. ");
INSERT INTO jae_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Aôm ôtu ŋoc andu ŋatau ma ŋoc lau samob taŋeŋ wamu aômnêm biŋ. Lêpôŋ kiŋŋa tageŋ êkêŋ aê jalêlêc aôm su.” ");
INSERT INTO jae_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Go Parao kêsôm gêdêŋ Josep gebe “Ôlic acgom, aê kakêŋ aôm kôtu gamêŋ Aiguptuŋa samucgeŋ ŋatau.” ");
INSERT INTO jae_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ma Parao kêkôc nê riŋ toŋatalô êwa eŋ saŋa mêŋkêkêŋ gêdêŋ Josep kêka. Eŋ kakêŋ ŋakwê ŋajam-ŋajam gêdêŋ eŋ kêsô ma kêkêŋ kapoacwalô gold eŋ gênôŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Go kêkêŋ eŋ gêŋgôŋ nê kareta kêtu luagêcŋa ma êsêac sêmôêc sêsêlêŋ sêmuŋ gebe “Apôŋ aemduc.” Amboac tonaŋ Parao kêkêŋ eŋ kêtu gamêŋ Aiguptuŋa samucgeŋ ŋatau. ");
INSERT INTO jae_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma Parao kêsôm gêdêŋ Josep gebe “Aê Parao, mago ŋac teŋ aŋga gamêŋ Aiguptuŋa ênam kôm teŋ me êŋgôm gêŋ teŋ êôc lêlêc aôm atom.” ");
INSERT INTO jae_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ma Parao kêsam Josepnê ŋaê gebe Sapenat-Panea. Ma eŋ kêkêŋ dabuŋwaga aŋga On Potipera latuo Asenat gêdêŋ eŋ gêjam kêtu ênê awê. Su, go Josep gêwi Parao siŋ ma gêjac gamêŋ Aiguptuŋa kêsi. ");
INSERT INTO jae_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Gêdêŋ taŋ Josepnê jala kêtu 30 naŋ, eŋ kêkôc kôm anam sakiŋ kiŋ Aiguptuŋa Parao sa. Ma Josep gêwi Parao siŋ ma gêjac laoc gamêŋ Aiguptuŋa. ");
INSERT INTO jae_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Gêdêŋ jala tomoasu 7 naŋ kôm gêjam ŋanô taêsam. ");
INSERT INTO jae_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ma eŋ kejoŋ jala tomoasu 7 ŋapolom samob sa aŋga gamêŋ Aiguptuŋa to gêjac gêŋ tau sa kêkô kêtôm malacsêgageŋ. Eŋ gêjac kôm, taŋ kêgi malac auc kêtômgeŋ naŋ, ŋaŋanô sa kêkô malac gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tec Josep gêjac polom taêsam sa kêtôm gaŋac gwêcŋa. Eŋ gedec gebe ênam dôŋ to êsa gêŋ tau sa atom gebe ŋamalac teŋ kêtôm gebe ênam dôŋ to êsa gêŋ amboac tonaŋ ŋai sa nec atomanô. ");
INSERT INTO jae_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Jala tôbômŋa gêô lasê atom tageŋ ma Josep kêka ŋapalê luagêc lasê. Dabuŋwaga Onŋa Potipera latuo Asenat kêkôc êsêagêc. ");
INSERT INTO jae_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josep gê ŋacsêganê ŋaê gebe Manase ma kêsôm gebe “Gaê ênê ŋaê Manase gebe Anôtô gêgôm aê kaliŋ ŋoc gêŋwapac to tamocnê andu ŋagôlôac samob siŋ.” ");
INSERT INTO jae_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Gê ŋac kêtu luagêcŋa nê ŋaê gebe Epraim gebe “Anôtô kêkêŋ gôlôac gêdêŋ aê aŋga gamêŋ ŋoc gêŋwapacŋa.” ");
INSERT INTO jae_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Jala tomoasu 7, taŋ gêc gamêŋ Aiguptuŋa naŋ, mêŋgêjac pep ");
INSERT INTO jae_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ma jala totôbôm 7 mêŋkêsa kêtôm Josep kêsôm naŋ. Ma tôbôm gêjam gamêŋ ŋagêdô samob auc, aŋga gamêŋ Aiguptuŋa tageŋ, tec têtap nêŋ polom sa. ");
INSERT INTO jae_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gêdêŋ taŋ lau Aiguptuŋa sêôc tôbôm naŋ, lau têtaŋ polom gêdêŋ Parao. Ma Parao kêsôm gêdêŋ lau Aiguptuŋa samob gebe “Andêŋ Josep ana ma biŋ samob, taŋ eŋ êsôm naŋ aŋgôm.” ");
INSERT INTO jae_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma gêdêŋ taŋ tôbôm gêjam gamêŋ samucgeŋ auc naŋ, Josep gêlêc katam su andu gêŋ ŋanôŋa ma kêkêŋ gêŋ gêdêŋ lau Aiguptuŋa sêjam ôli gebe tôbôm kapôêŋ gêc gamêŋ Aiguptuŋa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tôbôm gêjam sêga, tec lau gamêŋ pebeŋŋa sêja Aiguptu sebe sênam ôli polom aŋga Josepnê, gebe tôbôm kapôêŋ gêjam nom ŋagamêŋ samob auc. jali. tetoc oc sa kêtu nêŋ anôtô jaba. ");
INSERT INTO jae_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Gêdêŋ taŋ Jakob gêŋô polom gêc Aiguptu ŋawae naŋ, eŋ kêsôm gêdêŋ latui gebe “Matemanô gêdêŋ-gêdêŋ taôm kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ma kêsôm gebe “Alic acgom, aê gaŋô ŋawae gebe polom gêc Aiguptu. Asêp ana ma anam ôli nêŋ polom aŋga tônê gebe tamoa mateŋ jali ma tamac êndu atom.” ");
INSERT INTO jae_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Amboac tonaŋ Josep têwai 10 sêsêp sêja sebe sênam ôli polom aŋga Aiguptu. ");
INSERT INTO jae_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mago Jakob kêsakiŋ Josep lasi Benjamin gêwiŋ atom gebe eŋ kêtêc gebe gêŋwapac êtap eŋ sa. ");
INSERT INTO jae_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Amboac tonaŋ Israel latui sêô lasê sebe sênam ôli polom, sêmoa lau ŋagêdô, taŋ sêmêŋ naŋ, ŋalêlôm gebe tôbôm gêjam gamêŋ Kanaanŋa auc samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ma Josep kêtu ŋacgôliŋsêga gamêŋ tonaŋŋa. Eŋ tau kêkêŋ polom gêdêŋ lau gamêŋ samobŋa sêjam ôli. Ma Josep têwai sêô lasê jatêtap labôc sêc eŋ laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josep gêlic têwai e kêjala êsêac, mago eŋ gêgôm êsêac amboac lau jaba ma kêsaic biŋ êsêac. Eŋ kêsôm gebe “Amac aŋga ondoc amêŋ.” Êsêac sêsôm gebe “Aŋga gamêŋ Kanaanŋa, abe anam ôli mo.” ");
INSERT INTO jae_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josep kêjala têwai, mago êsêac sêjam kauc eŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ma Josep taê gêjam mê, taŋ eŋ gêc kêpi êsêac naŋ, ma kêsôm gêdêŋ êsêac gebe “Kêmsecwaga amac, tec amêŋ abe alic gamêŋ kwanaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Êsêac sêsôm gêdêŋ eŋ gebe “O apômtau, masianô, nêm sakiŋwaga aêac tec amêŋ abe anam ôli mo. ");
INSERT INTO jae_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ŋac tageŋ latui aêac samob. Aêac lau mansaŋ. Aômnêm sakiŋwaga atu kêmsecwaga atom.” ");
INSERT INTO jae_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Eŋ kêsôm gêdêŋ êsêac gebe “Masianô, amac amêŋ abe alic gamêŋ kwanaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ma êsêac sêsôm gebe “Aômnêm sakiŋwaga aêac lasitêwai 12, ŋac Kanaanŋa teŋ latui aêac. Ŋac sauŋ gacgeŋ gêmoa gêwiŋ tamemai ma teŋ gêjaŋa.” ");
INSERT INTO jae_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tec Josep kêsôm gêdêŋ êsêac gebe “Amboac tê kasôm gêdêŋ amac su nê gebe Amac kêmsecwaga. ");
INSERT INTO jae_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Aê gabe jansaê amac êpi biŋ tonec ma jasôm biŋŋanô êtu Parao gêmoaŋa gebe amac oc awi gamêŋ tonec siŋ atom e amacnêm lasimi sauŋ êô lasê tonec êwiŋ acgom. ");
INSERT INTO jae_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Asakiŋ amacnêm teŋ gebe êkôc lasimi êmêŋ ma amac ŋagêdô aŋgôŋ kapoacwalô acgom. Aê gabe jansaê amacnêm biŋ e jajala gebe amac lau biŋŋanôŋa me masi. Embe masi, go aê jasôm êtu Parao gêmoaŋa gebe kêmsecwaga amacgoc.” ");
INSERT INTO jae_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Go kêkêŋ êsêac samob sêŋgôŋ kapoacwalô bêc têlêac. ");
INSERT INTO jae_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ŋabêc kêtu têlêacŋa go Josep kêsôm gêdêŋ êsêac gebe “Aŋgôm tonec, go amoa matem jali gebe aê katêc Anôtô. ");
INSERT INTO jae_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Amac embe lau mansaŋ, go awi nêm teŋ siŋ êŋgôŋ kapoacwalô êjô amac ma amac ŋagêdô akôc polom andêŋ nêm gôlôac ana gebe mo êjô êsêac êndu atom. ");
INSERT INTO jae_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ma akôc lasimi sauŋ andêŋ aê amêŋ, go amacnêm biŋ êwaka tau sa gebe biŋŋanô ec amac êndu atom.” Ma êsêac sêgôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Go êsêac sêsôm gêdêŋ tauŋ gebe “Biŋŋanôgoc, gêŋ taŋ dagôm gêdêŋ lasiŋi naŋ ŋagêjô tonec. Aêac talic eŋ gêmoa toŋalêlôm ôluŋ-ôluŋgeŋ ma keteŋ aêac, mago takêŋ taŋeŋ eŋ atom. Kêtu tonaŋŋa gêŋwapac tonec kêtap aêac sa jagêdêŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Ruben gêjô êsêac aweŋ gebe “Aê tec kasôm gêdêŋ amac gebe aŋgôm ŋapalê sec atom. Nec kasôm me masi. Mago amac abe akêŋ taŋem atom. Kêtu tonaŋŋa ênê dec ŋagêjô kêpi aêac galoc.” ");
INSERT INTO jae_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Êsêac sêjam kauc gebe Josep gêŋô êsêac aweŋ atom gebe ŋac ênam biŋ ôkwiŋa teŋ kêkô êsêac ŋasawa. ");
INSERT INTO jae_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ma eŋ gêbuc dêmôê êsêac ma kêtaŋ. Kêtaŋ su ma gêmu jagêjam biŋgalôm gêdêŋ êsêac kêtiam. Ma eŋ kêkôc Simeon aŋga êsêacnêŋ ma gêsô eŋ tôŋ ma ac sêlic. ");
INSERT INTO jae_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Go kêjatu gebe polom êsêp êsêacnêŋ talu e mêŋêc êtômgeŋ to nêŋ ŋaôli êmu êna êtiam ma sêkêŋ gêŋ êpuc êsêac tôŋ aŋga intênaŋa êndêŋ êsêac êwiŋ. Ma sêgôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Go êsêac sêpô nêŋ polom gêsac doŋki ŋaô ma sêc sêja. ");
INSERT INTO jae_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ma gêdêŋ taŋ êsêacnêŋ teŋ gêjac nê talu lêtêŋ gebe êkêŋ gêŋ êndêŋ nê doŋki êniŋ aŋga gamêŋ sênêcŋa naŋ, gêlic nê bôlêŋ gêc taluawa ");
INSERT INTO jae_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ma kêsôm gêdêŋ nê lasitêwai gebe “Sêkêŋ bôlêŋ gêmu gêmêŋ, onec gêc ŋoc taluawa.” Sêlic e katuŋ gêjaŋa, ma têtênêp ma sêsôm gebe “Ojae, Anôtô gêgôm asageŋ gêdêŋ aêac.” ");
INSERT INTO jae_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Gêdêŋ taŋ sêô lasê dêdêŋ tameŋi Jakob aŋga gamêŋ Kanaan ŋa naŋ, ac sêjac miŋ biŋ samob, taŋ kêtap êsêac sa naŋ, gêdêŋ eŋ ma sêsôm gebe ");
INSERT INTO jae_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ŋac, taŋ kêtu gamêŋ tônê ŋatau naŋ, kêsaic biŋ aêac ma geboc aêac atu gamêŋ tau ŋakêmsecwaga. ");
INSERT INTO jae_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mago aêac asôm gêdêŋ eŋ gebe ‘Aêac kêmsecwaga atom, aêac lau mansaŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Aêac lasitêwai 12, tamemai latui. Ŋac teŋ gêjaŋa ma ŋac sauŋ gacgeŋ gêŋgôŋ gêwiŋ tamemai gêmoa Kanaan.’ ");
INSERT INTO jae_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mago ŋac, tê kêtu gamêŋ ŋatau nê, kêsôm gêdêŋ aêac gebe ‘Aê jajala amac lau mansaŋ êndêŋ tonec gebe awi nêm teŋ siŋ êmoa êwiŋ aê ma akôc polom andêŋ nêm gôlôac ana, gebe tôbôm gêc. ");
INSERT INTO jae_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Akôc lasimi sauŋ andêŋ aê amêŋ, go jajala amac gebe lau mansaŋ ma kêmsecwaga amac atom. Su, go jakêŋ nêm lasitêwa êmu êndêŋ amac êtiam ma amac atôm gebe atulu gêŋ amoa gamêŋ tonec.’” ");
INSERT INTO jae_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Gêdêŋ taŋ êsêac sêjac nêŋ talu lêtêŋ naŋ, samob sêlic nêŋ bôlêŋ tosabaŋ-tosabaŋ kêsêp nêŋ talu gêdêŋ-gêdêŋgeŋ. Êsêac to tameŋi sêlic nêŋ bôlêŋ tosabaŋ-tosabaŋ ma têtêc tauŋ. ");
INSERT INTO jae_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma tameŋi Jakob kêsôm gêdêŋ êsêac gebe “Amac ajaŋgo ŋoc gôlôac su. Josep gêjaŋa, Simeon gêjaŋa, ma galoc abe akôc Benjamin su êwiŋ. Biŋ samob tonaŋ kêpi aêgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tec Ruben kêsôm gêdêŋ tama gebe “Ôkêŋ eŋ êsêp aê lemoc, aê jakôc eŋ jamu jandêŋ aôm jamêŋ. Aê embe jakôc eŋ jamu jamêŋ atom, go ônac ŋoc latucagêc êndu.” ");
INSERT INTO jae_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mago eŋ kêsôm gebe “Latuc êsêp êwiŋ amac atom gebe têwa gêmac êndu su ma eŋ taugeŋ tec gêmoa. Gêŋ wapac embe êtap eŋ sa aŋga intêna, taŋ abe asêlêŋ naŋ, go amac akêŋ aê tomôdêgeŋ jasêp lamboam toŋoc ŋalêlôm ŋawapacgeŋ jana.” ");
INSERT INTO jae_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tôbôm kapôêŋ kêkôniŋ gamêŋ tôŋ ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Êsêac seŋ polom, taŋ sêkôc aŋga Aiguptu naŋ, e gêbacnê su, go tameŋi kêsôm gêdêŋ êsêac gebe “Amu ana êtiam gebe anam ôli aêacnêŋ mo ŋagêdô.” ");
INSERT INTO jae_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tec Juda kêsôm gêdêŋ eŋ gebe “Ŋac tonaŋ kêjatu aêac ŋajaŋa ma kêsôm gebe ‘Amac alic aê laŋôc atom, e lasimi êwiŋ amac acgom.’ ");
INSERT INTO jae_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aôm embe ôsakiŋ lasiŋi êwiŋ aêac, go asêp naanam ôli nêm mo. ");
INSERT INTO jae_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Embe ôsakiŋ eŋ êwiŋ atom, go aêac asêp atom gebe ŋac tau kêsôm gêgêŋ aêac gebe ‘Amac alic aê laŋôc atom, e lasimi êwiŋ amac acgom.’” ");
INSERT INTO jae_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel kêsôm gebe “Amac agôm aê sec ma asôm lasimi ŋawae gêdêŋ ŋac tau kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Êsêac sêjô eŋ awa gebe “Ŋac tau kêkip aêac to ma gôlôac ŋam sa ŋapep ma kêsôm gebe ‘Tamemi gacgeŋ gêŋgôŋ mata jali me masi. Amacnêm lasitêwai teŋ gêŋgôŋ me masi.’ Biŋ, taŋ aêac ajac miŋ gêdêŋ eŋ naŋ, gêjô kênac tonaŋgeŋ. Aêac ajala biŋ, tê eŋ kêsôm kêdaguc gebe ‘Akôc lasimi andêŋ aê amêŋ’ nê, kwanaŋgeŋ amboac ondocgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ma Juda kêsôm gêdêŋ tama Israel gebe “Ôsakiŋ ŋapalê tau êwiŋ aê, go andi ma asêlêŋ gebe tamoa mateŋ jali ma aôm to aêac ma nêŋ gôlôac ŋasec-ŋasec amboac tonaŋgeŋ, tamac êndu atom. ");
INSERT INTO jae_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Aê jatu lautuc eŋ, ma eŋ ê lamu aê. Ôtu kênac eŋ êndêŋ aê lemoc. Aê embe jakôc eŋ jamu jawac to jakêŋ eŋ êkô aôm laŋômnêm atom, go jawê biŋ tonaŋ ŋakaiŋ endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Biŋŋanô, aêac embe tajaiŋ têm atom, oc aêac amu amêŋ wanêcgeŋ su.” ");
INSERT INTO jae_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Go tameŋi Israel kêsôm gêdêŋ êsêac gebe “Embe amboac tonaŋ, naŋ aŋgôm amboac tec gebe Akôc gamêŋ tonecŋa ŋagêŋ mata êjamgeŋ êsêp nêm talu ma ajoŋ êndêŋ ŋac tônê awi siŋ êndêŋ eŋ ŋaômageŋ, amboac gêŋmalu ŋagec, to lêp ŋagec, ma ka ŋagêdô ŋatêkwi, ma kaŋa to lanip. ");
INSERT INTO jae_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ma akôc bôlêŋ luagêc êwiŋ tau. Bôlêŋ, taŋ sêkêŋ gêc nêm taluawa naŋ, akôc amu ana amboac tonaŋgeŋ. Oc moae sêgôm kêgôliŋ. ");
INSERT INTO jae_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Akôc lasimi amboac tonaŋ ma andi amu andêŋ ŋac tau ana. ");
INSERT INTO jae_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Embe akô ŋac tau laŋônêm, go ŋajaŋa ŋatau Anôtô taê walô amac gebe êsakiŋ nêm lasitêwai teŋ agêc Benjamin sêwiŋ amac sêmu sêmêŋ. Ma aêma nec embe jamoa togôlôacmêgeŋ, go jamoa amboac tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kêsôm su, go lau tau sêkôc gêŋ sêkêŋ ŋaômageŋŋa to sêkôc bôlêŋ luagêc gêwiŋ tau ma Benjamin gêwiŋ. Ac dêdi ma sêsêp Aiguptu sêja ma sêkô Josep laŋônêm. ");
INSERT INTO jae_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Josep gêlic Benjamin gêwiŋ êsêac, tec kêsôm gêdêŋ gejobwaga anduŋa gebe “Ôwê lau tonec sêsô andu sêna. Ôŋguŋ bôc teŋ ma ono gebe lau tonec sêniŋ gêŋ sêwiŋ aê êndêŋ ocsalô tonec.” ");
INSERT INTO jae_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ŋac tau gêgôm kêtôm Josep kêjatu naŋ ma gêwê lau sêsô Josepnê andu sêja. ");
INSERT INTO jae_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ac sêkêŋ lau tau sêsô Josepnê andu, tec têtêc tauŋ ma sêsôm gebe “Êsêac sêkôc aêac tasô tonec kêtu ŋaôli, taŋ sêkêŋ kêsêp aêacnêŋ talu gêdêŋ tamêŋ kêtu ŋamata naŋŋa. Êsêac sebe sênac siŋ êndêŋ aêac e sêku aêac tulu ma sêkôniŋ aêac tatu gêŋôma to sêjaŋgo aêacnêŋ doŋki su.” ");
INSERT INTO jae_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ma êsêac têtu gasuc dêdêŋ ŋac, taŋ gejob Josepnê andu naŋ, ma sêjam biŋgalôm sêwiŋ eŋ sêkô andu ŋasacgêdô ");
INSERT INTO jae_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ma sêsôm gebe “O ma apômtau, aêac asêp amêŋ têm teŋ sugac gebe anam ôli mo. ");
INSERT INTO jae_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Gêdêŋ taŋ aêac aô lasê gamêŋ aniŋ aweŋŋa ma ajac ma talu lêtêŋ naŋ, atap ma bôlêŋ sa tomalageŋ gêc taluawa gêdêŋ-gêdêŋgeŋ. Tec aêac akôc gêŋ tau amu amêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ma aêac akôc bôlêŋ ŋagêdô gêwiŋ amboac tonaŋ abe anam ôli mo. Aêac ajam kauc ŋac, taŋ kêkêŋ ma bôlêŋ kêsêp ma talu.” ");
INSERT INTO jae_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Eŋ gêjô êsêac aweŋ gebe “Atêc taôm atom. Nêm Anôtô to tameminê Anôtô oc kêkêŋ awa kêsêp nêm talu. Aê tec katap nêm bôlêŋ sa sugac.” Ma eŋ kêkôc Simeon gêdêŋ êsêac gêja. ");
INSERT INTO jae_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Go eŋ gêwê lau tau sêsô Josepnê andu sêja ma kêkêŋ bu gêdêŋ êsêac gebe sêkwasiŋ eŋkaiŋ ma kêkêŋ gêŋ gêdêŋ nêŋ doŋki seŋ. ");
INSERT INTO jae_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Êsêac sêŋô ŋawae gebe sêniŋ gêŋ aŋga tônê, tec sêmasaŋ gêŋ, taŋ sebe sêkêŋ ŋaômageŋ naŋ, ma sêsaê Josep gebe êô lasê êndêŋ ocsalô. ");
INSERT INTO jae_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Gêdêŋ taŋ Josep gêô lasê nê andu naŋ, êsêac sêkôc gêŋ, taŋ sêmasaŋ naŋ, jasêsô dêdêŋ eŋ ma têtap labôc sêc eŋ akaiŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mago eŋ awa gêjac êsêac ma kêsôm gebe “Tamemi laŋgwa, taŋ ajac ênê miŋ gêdêŋ aê naŋ, gêmoa ŋajam me masi. Eŋ gêmoa mata jali me masi.” ");
INSERT INTO jae_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Êsêac sêjô eŋ awa gebe “Aômnêm sakiŋwaga, aêac tamemai gêmoa ŋajam. Eŋ gêŋgôŋ mata jaligeŋ.” Ma êsêac sewec to têtap labôc. ");
INSERT INTO jae_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Eŋ mata gedec ma gêlic lasi Benjamin, eŋ tau tênanê latu teŋ ma kêsôm gebe “Lasimi sauŋ, taŋ ajac ênê miŋ gêdêŋ aê naŋ, tau tonec me.” Go kêsôm gêdêŋ eŋ gebe “Latucenec, Anôtô êmoasiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Go Josep kêkacgeŋ gebe êwi êsêac siŋ gebe nê ŋalêlôm gêjam awa su lasi ma kêdabiŋ gebe êtaŋ lasê. Eŋ jakêsô nê balêm teŋ ma kêtaŋ gêmoa tônê. ");
INSERT INTO jae_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Eŋ kêkwasiŋ laŋôanô su, go kêsa gêja. Eŋ kêpuc tau tôŋ ma kêsôm gebe “Akôc gêŋ taniŋŋa amêŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Êsêac sêjam sakiŋ eŋ tauŋa to êsêac tauŋŋa ma lau Aiguptu, taŋ seŋ gêŋ sêwiŋ eŋ naŋ, tauŋŋa amboac tonaŋgeŋ, gebe lau Aiguptu nêŋ jao kêkô gebe sêniŋ gêŋ sêwiŋ lau Ebolai atom. Gêŋ tonaŋ lau Aiguptu sêlic amboac gêŋ alôb-alôb. ");
INSERT INTO jae_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma Josep têwai to lasi sêŋgôŋ eŋ nêmŋa. Ŋacsêga gêŋgôŋ mala, taŋ gêjac eŋ ŋawae naŋ, ma ŋac sauŋ gêŋgôŋ mala, taŋ gêjac eŋ ŋawae. Ma lau tau sêsala tauŋ e sêŋac lemeŋ. ");
INSERT INTO jae_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Sêkêŋ gêŋ taniŋŋa gêdêŋ êsêac aŋga Josepnê tebo, mago sêkêŋ gêŋ taniŋŋa gêdêŋ Benjamin kêlêlêc êsêac ŋagêdô nêŋ su. Êsêac ŋagêdô têtap laclu tageŋ sa ma Benjamin kêtap nê laclu lemeŋ teŋ sa. Ma êsêac sênôm sêwiŋ eŋ e têntac ŋajam kêsa. ");
INSERT INTO jae_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Go Josep kêjatu nê andu ŋagejobwaga gebe “Ôkêŋ polom êsêp lau tau nêŋ talu e mêŋêc êtôm sêmbalaŋŋa ma ôkêŋ êsêacnêŋ bôlêŋ ênêc taluawa. ");
INSERT INTO jae_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mago ŋoc laclu silber naŋ ôkêŋ ênêc ŋac sauŋ nê taluawa êwiŋ ênê bôlêŋ polomŋa.” Ma eŋ gêgôm kêtôm Josep kêsôm gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Gêu bôŋ acgom, go sêkêŋ êsêac to nêŋ doŋki sêja. ");
INSERT INTO jae_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Êsêac sêwi malac siŋ sauŋgeŋ ma ŋasawa kêtu baliŋ atom tageŋ, tec Josep kêsôm gêdêŋ nê andu ŋagejobwaga gebe “Ajôc, ôjanda lau tau. Embe ôê êsêac tôŋ, go ôsôm êndêŋ êsêac gebe ‘Amac akêŋ sec gêjô ŋajam kêtu ageŋŋa. Amac ajam geŋgeŋ aêŋoc laclu silber nec kêtu ageŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ŋoc ŋatau gênôm gêŋ kêsêp gêŋ tau tonaŋ to kêpuc kapoac ŋa gêŋ tonaŋ. Amac agôm gêŋ tonaŋ, tec agôm keso ŋanô.’” ");
INSERT INTO jae_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Eŋ gêôc lêlêc êsêac ma jakêsôm biŋ tonaŋgeŋ gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Êsêac sêjô eŋ awa gebe “Aêacma apômtau kêsôm biŋ amboac tonaŋ kêtu asageŋŋa. Biŋ amboac tonaŋ ênac jaê nêm sakiŋwaga aêac. Biŋ amboac tonaŋ aêac oc aŋgôm atom. ");
INSERT INTO jae_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ôlic acgom, bôlêŋ, taŋ aêac atap sa gêc ma taluawa naŋ, aêac akôc amu amêŋ aŋga gamêŋ Kanaan akêŋ gêdêŋ aôm, tec aêac anam geŋgeŋ silber me gold aŋga nêm ŋataunê andu amboac ondoc. ");
INSERT INTO jae_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Aôm embe ôtap gêŋ tau sa aŋga nêm sakiŋwaganêŋ teŋ nê, naŋ êmac êndu ma aêac ŋagêdô atu ma apômtaunê sakiŋwaga amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ma eŋ kêsôm gebe “Amboac tonaŋ, biŋ, taŋ asôm su naŋ, êtu tôŋ. Ŋac, naŋ jatap gêŋ tau sa aŋga ênê naŋ, êtu ŋoc gêŋôma, ma amac ŋagêdô aêc ana tobiŋmêgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Go gaôgeŋ êsêac samob sêlêwaŋ nêŋ talu ma sêjac nêŋ talu lêtêŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma eŋ kêbêlêm talu gêjac m aŋga ŋacsêganê e gêdêŋ ŋac sauŋ nê. Ma kêtap laclu tau sa gêc Benjaminnê talu. ");
INSERT INTO jae_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ma êsêac sêkac nêŋ ŋakwê gêŋgic e sêkêŋ talu gêsac nêŋ doŋki ŋaô kêtiam ma sêmu sêja malac. ");
INSERT INTO jae_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda to nê lasitêwai sêô lasê Josepnê andu ma ŋac tau gacgeŋ gêmoa. Ma êsêac têtap labôc sêc eŋ akaiŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josep kêsôm gêdêŋ êsêac gebe “Amac agôm gêŋ amboac ondoc. Amac ajam kauc gebe ŋac amboac aê oc Japuc gêŋ ŋam jatôm atom me.” ");
INSERT INTO jae_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ma Juda kêsôm gebe “Aêac asôm biŋ ondoc êndêŋ ŋoc apômtau. Aim aweŋsuŋ su êtu ageŋŋa. Aêac awaka tauŋ sa amboac ondoc. Anôtô kêkip nêm sakiŋwaga aêac ma keso sa sugac. Gôlicgac, aêac atu ŋoc apômtaunê gêŋôma, aêac to eŋ, taŋ têtap laclu sa gêc eŋŋa naŋ, amboac tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mago Josep kêsôm gebe “Biŋ amboac tonaŋ ênac jaê aê. Ŋac tageŋ, taŋ têtap laclu sa gêc eŋŋa naŋgeŋ êtu ŋoc gêŋôma. Mago amac ŋagêdô, amac aêc tobiŋmalôgeŋ andêŋ tamemi ana.” ");
INSERT INTO jae_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tec Juda gêdêŋ eŋ gêja ma kêsôm gebe “O apômtau, aê gabe jateŋ aôm gebe nêm sakiŋwaga aê jasôm biŋ teŋ êsô ŋoc ŋatau taŋasuŋ ma têmtac ŋandaŋ êndêŋ nêm sakiŋwaga atom, gebe aôm kôtôm Parao tau. ");
INSERT INTO jae_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ŋoc apômtau kêtu kênac nê sakiŋwaga gebe ‘Amac tamemi me lasimi teŋ gêmoa me masi.’ ");
INSERT INTO jae_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma aêac asôm gêdêŋ ŋoc ŋatau gebe ‘Tamemai gêmoa, eŋ kêtu ŋamalacanô sugac, ma lasiŋi sauŋ teŋ gêmoa, taŋ eŋ kêka lasê gêdêŋ kêtu ŋamalacanô su naŋ. Ŋac tau têwa gêmac êndu su, tec eŋ taugeŋ gêmoa, tênanê gôlôac ŋagêdô masi. Ma tama têtac gêwiŋ eŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Go aôm kôsôm gêdêŋ nêm sakiŋwaga gebe ‘Akôc eŋ asêp amêŋ gebe matocanô êpi eŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Aêac asôm gêdêŋ ŋoc apômtau gebe ‘Ŋapalê tau kêtôm gebe êwi tama siŋ atom. Embe êwi tama siŋ, oc tama êmac êndu.’ ");
INSERT INTO jae_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Go aôm kôsôm gêdêŋ nêm sakiŋwaga gebe ‘Lasimi sauŋ embe êwiŋ amac êsêp êmêŋ atom, oc alic aê laŋôc êtiam atom.’ ");
INSERT INTO jae_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Gêdêŋ taŋ adêŋ nêm sakiŋwaga, tamoc tau, amu aja naŋ, ajac miŋ ŋoc apômtaunê biŋ gêdêŋ eŋ gêŋô. ");
INSERT INTO jae_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ma gêdêŋ taŋ tamemai kêsôm gebe ‘Ana êtiam, gebe anam ôli aêacnêŋ gêŋ ŋagec’ naŋ, ");
INSERT INTO jae_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","aêac asôm gebe ‘Aêac asêp ana atôm atom. Embe lasiŋi sauŋ êsêlêŋ êwiŋ aêac, go asêp ana, gebe aêac oc alic ŋac tau laŋôanô atôm atom, e lasiŋi sauŋ êwiŋ aêac acgom.’ ");
INSERT INTO jae_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Go nêm sakiŋwaga, aê tamoc, kêsôm gêdêŋ aêac gebe ‘Taôm ajalagac gebe ŋoc awê kêkôc ŋoc ŋapalê luagêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Teŋ gêwi aê siŋ e kasôm gebe Biŋŋanô, gêŋ teŋ kêkac eŋ popocgeŋ ma aê galic eŋ kêtiam atom e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Amac embe akôc ŋac tonec su aŋga aêŋoc amboac tonaŋgeŋ ma gêŋwapac êtap eŋ sa, go akêŋ aê tomôdêgeŋ jasêp lamboam jana toŋoc ŋalêlôm ŋawapacgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kêtu tonaŋŋa aê embe jaô lasê nêm sakiŋwaga, aê tamoc, ma ŋapalê, taŋ kêtu eŋ gêŋgôŋ mata jali ŋamôkê naŋ, êwiŋ aêac atom, ");
INSERT INTO jae_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","eŋ embe êlic ŋapalê mêŋêwiŋ aêac atom, oc êmac êndu. Ma nêm sakiŋwaga aêac akêŋ nêm sakiŋwaga, aêac tamemai, tomôdêgeŋ êsêp lamboam êna toŋalêlôm ŋawapacgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gebe nêm sakiŋwaga aê kasôm gêdêŋ tamoc gebe jatu ŋapalê tonec nê lautuc ma eŋ ê lamu aê. Ma kasôm gebe Aê embe jakôc eŋ jamu jandêŋ aôm jawac atom, go jawê biŋ tonaŋ ŋakaiŋ endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kêtu tonaŋŋa tec galoc jateŋ aôm gebe nêm sakiŋwaga aê jatu ŋoc apômtaunê gêŋôma jamoa tonec jajô ŋapalê tau su. Ma ondec ŋapalê tau êwiŋ têwai êmu ênamaŋ. ");
INSERT INTO jae_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Gebe ŋapalê tau embe êwiŋ aê atom nec, oc jamu jandêŋ tamoc jana amboac ondoc. Aê katêc tauc gabe jalic gêŋwapac, naŋ êtap tamoc sa naŋ jawiŋ atom.” ");
INSERT INTO jae_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ma Josep kêkô lau samob laŋôŋnêmŋa e kêpuc tau tôŋ jageo. Tec eŋ gêmôêc gebe “Lau samob sêwi aê siŋ sêsa sêna.” Amboac tonaŋ gêdêŋ taŋ Josep gêwa tau sa gêdêŋ lasitêwai naŋ, lau teŋ sêmoa sêwiŋ êsêac atom. ");
INSERT INTO jae_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma eŋ kêtaŋ lasê e lau Aiguptu sêŋô ma Paraonê lau sêŋô ŋawae amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ma Josep kêsôm gêdêŋ nê lasitêwai gebe “Aê Josep. Tamoc gêŋgôŋ mata jali me masi.” Mago lasitêwai sêjô eŋ awa kêtôm atom, gebe eŋ kêtakê êsêac ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tec Josep kêsôm gêdêŋ nê lasitêwai gebe “Atu gasuc aêmaŋ.” Ma êsêac dêdêŋ eŋ sêja. Ma eŋ kêsôm gebe “Lasimi aê Josep, taŋ akêŋ aê gadêŋ lau Aiguptu sêjam ôli aê. ");
INSERT INTO jae_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mago galoc têmtac ŋawapac atom to amoa tonêm ŋalêlôm ŋatutuc êtu akêŋ aê gadêŋ lau tonec sêjam ôli aêŋa atom, gebe Anôtô kêsakiŋ aê gamuŋ amac gebe ênam amac kêsi aŋgôŋ matem jali. ");
INSERT INTO jae_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tôbôm gêc gamêŋ tau jala luagêc su. Ma jala lemeŋ teŋ gacgeŋ gêc taŋ lau sêsap nom ma sejoŋ kôm ŋanô sa atom. ");
INSERT INTO jae_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma Anôtô kêsakiŋ aê gamuŋ amac gebe janam amacnêm ŋagêdô kêsi aŋga nom ma jajop lau taêsam sêŋgôŋ mateŋ jali êtu amacŋa. ");
INSERT INTO jae_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kêtu tonaŋŋa amac asakiŋ aê gamêŋ tonec atom, Anôtô taugeŋ. Eŋ kêkêŋ aê katu Parao tama to ênê andu ŋatau ma gamêŋ Aiguptuŋa samob ŋagôliŋwaga. ");
INSERT INTO jae_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Andi ŋagaôgeŋ. Andêŋ tamoc api ana ma asôm êndêŋ eŋ gebe ‘Latôm Josep kêsôm biŋ amboac tonec gebe Anôtô kêkêŋ aê katu gamêŋ Aiguptuŋa samob ŋatau. Ôsêp ôndêŋ aê ômôêŋ ma ônam gamêŋ tôŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Aôm ôŋgôŋ gamêŋ Gosen ma ômoa aê ŋagala, aôm to nêm gôlôac ma nêm gôlôacnêŋ gôlôac ma nêm domba to bulimakao ma gêŋ samob, taŋ kêtu aômnêm naŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aê gabe janam aôm sa aŋga tonec e aôm to nêm lau ma gêŋ samob, taŋ kêtu aômnêm naŋ, apô lêna taôm êtu gêŋ teŋŋa atom, gebe tôbôm ênêc jala lemeŋ teŋ êwiŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma galoc amac matemanô alic to lasic Benjamin mataanô gêlic amboac tonaŋgeŋ gebe aê tauc aocsuŋ kasôm biŋ gêdêŋ amac. ");
INSERT INTO jae_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Anac miŋ ŋoc ŋawasi aŋga gamêŋ Aiguptuŋa to gêŋ, taŋ alic naŋ, ŋawae êndêŋ tamoc. Andi ŋagaôgeŋ ma akôc tamoc êsêp gamêŋ tonec êmêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ma agêc lasi Benjamin sêmbôêŋ tauŋ ma têtaŋ kêpi tauŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma eŋ kêlêsôp têwai samob ma kêmbôêŋ êsêac to kêtaŋ. Su, go lasitêwai sêjam biŋgalôm sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Gêdêŋ taŋ sêŋô ŋawae aŋga Paraonê andu gebe Josepnê lasitêwai sêmêŋ naŋ, Parao to nê sakiŋwaga sêŋô ŋajamgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ma Parao kêsôm gêdêŋ Josep gebe “Ôsôm êndêŋ nêm lasitêwai gebe Aŋgôm amboac tonec gebe akêŋ nêm waba ênsac nêm bôc ŋaô ma amu ana gamêŋ Kanaan. ");
INSERT INTO jae_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ma akôc tamemi to nêm gôlôac samob andêŋ aê amêŋ ma aê gabe jakêŋ Aiguptu ŋagamêŋ ŋajamanô tau êndêŋ amac gebe aniŋ nom tonaŋ ŋaŋalêsi. ");
INSERT INTO jae_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ôjatu êsêac amboac tonec êwiŋ gebe Aŋgôm tonec gebe Akôc kareta aŋga gamêŋ Aiguptuŋa êtu nêm ŋasec-ŋasec to nêm lauoŋa ma akôc tamemi amêŋmaŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma taêm walô nêm waba anduŋa atom, gebe Aiguptu ŋagamêŋ ŋajamanô tau êtu amacnêm.” ");
INSERT INTO jae_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ma Israel latui sêgôm kêtôm tonaŋ, go Josep kêkêŋ kareta gêdêŋ êsêac kêtôm Paraonê jatu ma kêkêŋ mo gebe êpuc êsêac tôŋ aŋga intênaŋa. ");
INSERT INTO jae_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Eŋ kêkêŋ ŋakwê omŋa tageŋ-tageŋ gêdêŋ êsêac samob kêtômgeŋ, Benjamin taugeŋ tec kêkêŋ silber ŋadôŋ 300 to ŋakwê omŋa lemeŋ teŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Eŋ kêsakiŋ gêŋ amboac tonec gêdêŋ tama gêja gebe doŋki kapoac 10 togêŋ mata êjam Aiguptuŋa ma doŋki têna 10 topolom ma mo to gêŋ taniŋŋa êtu êpuc tama tôŋ aŋga intênaŋa. ");
INSERT INTO jae_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Go kêsakiŋ lasitêwai sêja ma gêdêŋ taŋ kêkam êsêac lemeŋ naŋ, kêsôm gêdêŋ êsêac gebe “Asôm taôm aŋga intêna atom.” ");
INSERT INTO jae_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tec êsêac sêwi Aiguptu siŋ sêpi gamêŋ Kanaan jasêô lasê dêdêŋ tameŋi Jakob. ");
INSERT INTO jae_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ma êsêac sêjac miŋ gêdêŋ eŋ gebe “Josep gêŋgôŋ mata jali ma eŋ kêtu gamêŋ Aiguptuŋa samob ŋagôliŋwaga.” Mago têtac kêkac eŋ atom, gebe eŋ kêkêŋ gêwiŋ êsêac atom. ");
INSERT INTO jae_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mago gêdêŋ taŋ sêjac miŋ Josepnê biŋ samob, taŋ kêsôm gêdêŋ êsêac naŋ, gêdêŋ eŋ ma gêdêŋ taŋ eŋ gêlic kareta, taŋ Josep kêsakiŋ gebe êkôc eŋŋa naŋ, tec tameŋi Jakob têtac kêpô su ma nê ŋalêlôm gêdi sa kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma Israel kêsôm gebe “Kêtômgac. Latuc Josep gêŋgôŋ mata jali. Aê gabe najalic eŋ acgom, go jamac êndu.” ");
INSERT INTO jae_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Amboac tonaŋ Israel gêdi ma kêkôc nê gêŋ samob gêwiŋ gêja. Eŋ gêô lasê Ber-Seba ma kêkêŋ da gêdêŋ tama Isak nê Anôtô. ");
INSERT INTO jae_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma gêdêŋ gêbêc Anôtô geoc tau lasê gêdêŋ Israel ma gêjam biŋgalôm gêdêŋ eŋ ma kêsôm gebe “Jakob, Jakob.” Ma eŋ kêsôm gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Go eŋ kêsôm gebe “Aê Anôtô, tamamnê Anôtô aê. Ôsêp Aiguptu ôna tonêm ŋalêlôm ŋatutuc atom, gebe aê gabe jaŋgôm aôm ôtu laum kapôêŋ teŋ aŋga ônê. ");
INSERT INTO jae_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aê gabe jasêp Aiguptu jawiŋ aôm. Ma aê gabe jakêŋ aôm ômu ôpi ômôêŋ êtiam ma Josep lêma êmbaob aôm matamgasi.” ");
INSERT INTO jae_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Go Jakob gêdi aŋga Ber-Seba. Ma Israel latui sêkêŋ tameŋi Jakob to nê ŋasec-ŋasec ma nêŋ lauo sêpi kareta, taŋ Parao kêsakiŋ kêtu êkôc eŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Êsêac sêkôc nêŋ bôc to waba, taŋ têtap sa aŋga Kanaan naŋ, ma sêô lasê Aiguptu, Jakob to nê gôlôac samucgeŋ sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Eŋ kêkôc latui to latuio sêwiŋ eŋ ma dêbui to dêbuio to nêŋ wakuc samob sêwiŋ eŋ sêja Aiguptu. ");
INSERT INTO jae_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israelnê wakuc, taŋ sêô lasê Aiguptu naŋ, nêŋ ŋaê tau tonec gebe Jakob to nê latui. Jakobnê ŋacsêga Ruben ");
INSERT INTO jae_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","to Ruben latui Hanok, Palu, Hesron ma Karmi. ");
INSERT INTO jae_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon latui Jemuel, Jamin, Ohad, Jakin, Sohar ma Saul, awê Kanaanŋa teŋ latu eŋ. ");
INSERT INTO jae_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi latui Gerson, Kohat ma Merari. ");
INSERT INTO jae_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda latui Er, Onan, Sela, Peres ma Sera (mago Er agêc Onan sêmac êndu aŋga gamêŋ Kanaan). Ma Peres latui Hesron agêc Hamul. ");
INSERT INTO jae_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar latui Tola, Puwa, lob ma Simron. ");
INSERT INTO jae_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon latui Sered, Elon ma Jalel. ");
INSERT INTO jae_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(Lea latui tau tonaŋ, taŋ Jakob kêka lasê aŋga Mesopotamia sêwiŋ latuo Dina. Êsêac latuŋio to ŋac samob sêpi tageŋ têtôm 33.) ");
INSERT INTO jae_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad latui Sipion, Hagi, Suni, Esbon, Eri, Arodi ma Areli. ");
INSERT INTO jae_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser latui Imna, Iswa, Iswi, Beria ma luŋio Sera. Ma Beria latui Heber agêc Malkiel. ");
INSERT INTO jae_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(Silpa latui tau tonaŋ. Laban kêkêŋ eŋ gêdêŋ latuo Lea. Ma Jakob kêka êsêac lasê, lau 16 sêpi tageŋ.) ");
INSERT INTO jae_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jakobnê awê Rahel latui Josep agêc Benjamin. ");
INSERT INTO jae_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ma aŋga gamêŋ Aiguptu Josep kêka Manase agêc Epraim lasê, taŋ dabuŋwaga Onŋa Potipera latuo Asenat kêkôc naŋ. ");
INSERT INTO jae_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ma Benjamin latui Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim ma Ard. ");
INSERT INTO jae_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(Rahel latui tau tonaŋ, taŋ Jakob kêka lasê, lau 14 sêpi tageŋ.) ");
INSERT INTO jae_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan latu Husim. ");
INSERT INTO jae_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naptali latui Jasel, Guni, Jeser ma Silem. ");
INSERT INTO jae_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(Bilha, taŋ Laban kêkêŋ gêdêŋ latuo Rahel naŋ, latui tonaŋ, taŋ Jakob kêka lasê, lau 7 sêpi tageŋ.) ");
INSERT INTO jae_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jakobnê lau samob, taŋ sêô lasê Aiguptu naŋ, ma sêsa aŋga eŋ tau nê sêpi tageŋ 66, mago Jakob latuinêŋ lauo sêwiŋ namba tonaŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ma Josep latui taŋ kêka lasê aŋga Aiguptu naŋ, luagêc, tec lau samob aŋga Jakobnê gôlôac, taŋ sêô lasê Aiguptu naŋ, sêpi tageŋ 70. ");
INSERT INTO jae_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakob kêsakiŋ Juda gêdêŋ Josep gêmuŋ eŋ gebe eteŋ Josep êô lasê Gosen êmuŋ. Ma êsêac sêô lasê gamêŋ Gosen. ");
INSERT INTO jae_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Go Josep kêmasaŋ nê kareta ma kêpi gêja gebe êpuc tama Israel tôŋtôŋ aŋga gamêŋ Gosen. Ma gêdêŋ taŋ eŋ gêlic tama naŋ, kêmbôêŋ eŋ kêsêp gêsutêkwa ma kêtaŋ ŋasawa baliŋ gêsac eŋ gêsutêkwa. ");
INSERT INTO jae_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel kêsôm gêdêŋ Josep gebe “Galoc gabe jamac êndu gebe aê galic laŋômanô ma kajala gebe gôŋgôŋ matam jali.” ");
INSERT INTO jae_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Josep kêsôm gêdêŋ lasitêwai to gêdêŋ tamanê lau gebe “Aê gabe japi jakêŋ amac ŋawae êndêŋ Parao ma jasôm êndêŋ eŋ gebe ‘Ŋoc lasitêwai to tamocnê lau, taŋ sêmoa gamêŋ Kanaan naŋ, dêdêŋ aê sêmêŋ su. ");
INSERT INTO jae_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Lau tau gejobwaga bôcŋa gebe êsêac seŋgeŋ bulimakao ma sêkôc nêŋ domba to bulimakao ma nêŋ gêŋ ŋagêdô samob sêmêŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Parao embe êkalem amac ma êtu kênac amac gebe ‘Amacnêm kôm amboac ondoc,’ ");
INSERT INTO jae_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","go asôm gebe ‘Aômnêm sakiŋwaga aêac aŋgeŋ bulimakao gêdêŋ aêac ŋapalêgeŋ e mêŋgêdêŋ galoc, atôm tamemai.’ Asôm biŋ tonaŋ ec êlôc gebe amoa gamêŋ Gosen gebe lau Aiguptuŋa sêlic gejobwaga bôcŋa samob amboac gêŋ alôb-alôb.” ");
INSERT INTO jae_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Amboac tonaŋ Josep kêsô jakêkêŋ ŋawae gêdêŋ Parao ma kêsôm gebe “Tamoc to ŋoc lasitêwai ma nêŋ domba to bulimakao ma nêŋ gêŋ samob sêmêŋ aŋga gamêŋ Kanaan jasêŋgôŋ gamêŋ Gosen.” ");
INSERT INTO jae_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Eŋ kêkôc têwai lemeŋ teŋ sêwiŋ eŋ ma kêtôc êsêac gêdêŋ Parao. ");
INSERT INTO jae_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Parao kêsôm gêdêŋ eŋ têwai gebe “Amac ajam kôm amboac ondoc.” Ma êsêac sêsôm gêdêŋ Parao gebe “Nêm sakiŋwaga aêac ajop dombageŋ atôm tamemai.” ");
INSERT INTO jae_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Go êsêac sêsôm gêdêŋ Parao gebe “Aêac amêŋ gebe amoa gamêŋ tonec amboac lau jaba gebe nêm sakiŋwaga aêac ma gamêŋ alôm ma dombaŋa teŋ gêc gamêŋ Kanaan atom gebe tôbôm gêjam gamêŋ auc samucgeŋ. Tec aêac ateŋ aôm gebe ôlôc gebe nêm sakiŋwaga aêac aŋgôŋ gamêŋ Gosenmaŋ.” ");
INSERT INTO jae_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Go Parao kêsôm gêdêŋ Josep gebe “Tamam to nêm lasitêwai dêdêŋ aôm sêwac. ");
INSERT INTO jae_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Gamêŋ Aiguptuŋa kêtu aômnêm gêŋ. Ôjaliŋ gamêŋ ŋajamanô teŋ sa ma ôkêŋ êndêŋ tamam to nêm lasitêwai sêŋgôŋ. Ôkêŋ êsêac sêŋgôŋ gamêŋ Gosenmaŋ. Ma aôm embe ôlic lau tokauc aŋga êsêacnêŋ, go ôkêŋ êsêac sejop ŋoc bulimakao sêwiŋ.” ");
INSERT INTO jae_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Josep gêwê tama jakêtôc gêdêŋ Parao ma Jakob gêjam mec Parao. ");
INSERT INTO jae_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ma Parao kêtu kênac Jakob gebe “Aômnêm jala tendocgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob gêjô Parao awa gebe “Jala, taŋ gamoa nom amboac ŋac jaba teŋ naŋ 130. Jala, taŋ gamoa nom ŋatêm tau dambê to ŋawapac ma taêsam kêtôm tamocinêŋ jala sêmoa nom amboac lau jabaŋa naŋ atom.” ");
INSERT INTO jae_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma Jakob gêjam mec Parao ma gêwi eŋ siŋ kêsa gêja. ");
INSERT INTO jae_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Go Josep kêkêŋ gamêŋ gêdêŋ tama to nê lasitêwai gebe sêŋgôŋŋa ma kêkêŋ nom gêdêŋ êsêac kêtu êsêacnêŋ gêŋ aŋga gamêŋ Aiguptuŋa, kêkêŋ nom ŋajamanô tau gêdêŋ êsêac aŋga gamêŋ Rameses kêtôm Parao kêjatu. ");
INSERT INTO jae_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma Josep gêlôm tama to nê lasitêwai ma tamanê lau samob kêtôm êsêacnêŋ gôlôacnêŋ nambageŋ. ");
INSERT INTO jae_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mo teŋ gêc gamêŋ samuc tonaŋ atom, gebe tôbôm kapôêŋ sec e mo gêjô lau gamêŋ Aiguptu to Kanaanŋa êndu. ");
INSERT INTO jae_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ma Josep kejoŋ awa, taŋ gêc gamêŋ Aiguptu to Kanaanŋa naŋ, samob sa gêjô polom, taŋ lau sêjam ôli naŋ. Ma Josep kêkêŋ ŋaawa kêsô Paraonê andu. ");
INSERT INTO jae_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ma gêdêŋ taŋ awa samob gêbacnê aŋga gamêŋ Aiguptu to gamêŋ Kanaan naŋ, lau Aiguptu samob dêdêŋ Josep sêja ma sêsôm gebe “Ôkêŋ mo êndêŋ aêac. Aêac amac êndu anêc aôm laŋômnêmŋa êtu ageŋŋa, gebe ma awa gêbacnê.” ");
INSERT INTO jae_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ma Josep kêsôm gebe “Amacnêm awa embe êmbacnê, go akêŋ nêm bôc ma aê gabe jakêŋ mo êndêŋ amac êjô nêm bôc.” ");
INSERT INTO jae_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tec êsêac sêkêŋ nêŋ bôc gêdêŋ Josep ma eŋ kêkêŋ mo gêjô hos to bulimakao ma domba to doŋki. Tec gêdêŋ jala tonaŋ eŋ gêlôm êsêac ŋa mo gêjô nêŋ bôc samob. ");
INSERT INTO jae_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Jala tonaŋ gêbacnê, tec gêdêŋ jala kêtu luagêcŋa êsêac sêmu dêdêŋ eŋ jasêsôm gêdêŋ eŋ gebe “Aêac asiŋ biŋ tonec ôkwi êndêŋ ma ŋatau atôm atom gebe awa gêbacnê ma bôc ŋatoŋ kêtu ma ŋataunê gêŋ sugac. Amboac tonaŋ ma gêŋ akêŋ êndêŋ ma ŋatauŋa teŋ gêc atom, aêac ôliŋ to ma nom tageŋ. ");
INSERT INTO jae_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Aêac to ma nom anaŋa anêc aôm laŋômnêmŋa êtu ageŋŋa. Ônam ôli aêac to ma nom ma ôkêŋ mo êjô, go aêac to ma nom anam sakiŋ êndêŋ Parao. Ôkêŋ polom ŋawê êndêŋ aêac gebe aŋgôŋ mateŋ jali ma amac êndu atom ma aêacma nom êtu gasaŋ atom.” ");
INSERT INTO jae_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Amboac tonaŋ Josep gêjam ôli nom samob aŋga Aiguptu kêtu Paraonê gêŋ, gebe lau Aiguptuŋa samob sêkêŋ nêŋ nom gêdêŋ eŋ gêjam ôli gebe tôbôm kapôêŋ sec gêc, tec nom tau kêtu Paraonê gêŋ. ");
INSERT INTO jae_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mago lau tau tec kêkêŋ êsêac têtu gêŋôma aŋga Aiguptu ŋamadiŋ ŋamakeŋ e gêdêŋ ŋamakeŋ. ");
INSERT INTO jae_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Dabuŋwaga tauŋgeŋ nêŋ nom tec gêjam ôli atom, gebe dabuŋwaga têtap nêŋ ŋaôli sa aŋga Paraonê, tec ŋaôli tau, taŋ Parao kêkêŋ gêdêŋ êsêac naŋ, gêlôm êsêac. Kêtu tonaŋŋa êsêac sêkêŋ nêŋ nom gêdêŋ eŋ gêjam ôli atom. ");
INSERT INTO jae_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma Josep kêsôm gêdêŋ lau gebe “Amboac tonaŋ, ocsalô tonec aê gajam ôli amac to nêm nom atu Paraonê gêŋgac. Galoc akôc polom ŋawê tonec ma asê êsêp kômmaŋ. ");
INSERT INTO jae_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mago kôm ŋanô tau awa êkôc êna toŋ lemeŋ teŋ ma akêŋ toŋ teŋ êndêŋ Parao. Toŋ aclê êtu amacnêm gebe asê êsêp kôm wakuc ma aniŋ êtu amac to nêm gôlôac ma nêm ŋasec-ŋasec nêm mo.” ");
INSERT INTO jae_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Êsêac sêsôm gebe “Aôm gôjam aêac sa aŋgôŋ mateŋ jali. Ma ŋatau, embe ôlic aêac ŋajam, go anam sakiŋ Parao anêc ŋawaegeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tec Josep kêkêŋ biŋ tonaŋ kêtu ŋagôliŋ teŋ gêc e mêŋgêdêŋ galoc gêjam gôliŋ lau Aiguptuŋa nêŋ nom gebe sêwa kôm ŋanô êkôc êna toŋ lemeŋ teŋ ma sêkêŋ ŋateŋ êndêŋ Parao. Dabuŋwaga tauŋgeŋ nêŋ nom kêtu Paraonê gêŋ atom. ");
INSERT INTO jae_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Amboac tonaŋ Israel sêŋgôŋ gamêŋ Aiguptu ŋagamêŋ Gosen. Ac sêŋgôŋ têtu têlê ma sêka gôlôac lasê e têtu taêsam ŋanô lasê. ");
INSERT INTO jae_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ma Jakob gêŋgôŋ gamêŋ Aiguptu jala 17 e ênê jala kêtu 147. ");
INSERT INTO jae_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israelnê noc êmac ênduŋa kêdabiŋ naŋ eŋ kêkalem latu Josep ma kêsôm gêdêŋ eŋ gebe “Aôm embe ôlic aê ŋajam, go ôkêŋ lêmam êsô lambic ma ôsôm êtu tôŋ gebe ômansaŋ aê ŋapep ma totêmtac êwiŋgeŋ gebe ônsuŋ aê aŋga Aiguptu atom. ");
INSERT INTO jae_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mago ôkêŋ aê janêc jawiŋ tamoci. Ômbalaŋ aê aŋga Aiguptu naônsuŋ aê aŋga nêŋ sêô.” Eŋ gêjô eŋ awa gebe “Aê gabe jaŋgôm êtôm biŋ, taŋ kôsôm naŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma Israel kêsôm gebe “Ôtôc lêmam.” Ma Josep kêtôc lêma. Go Israel gewec gêdêŋ nê mê ŋagêdô môkêapacŋa. ");
INSERT INTO jae_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tonaŋ su acgom, go sêkêŋ ŋawae gêdêŋ Josep gebe “Ôlic acgom, tamam gêmac gêc.” Tec eŋ kêkôc latuagêc Manase agêc Epraim sêwiŋ eŋ jasêô lasê Jakob. ");
INSERT INTO jae_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ma sêkêŋ ŋawae gêdêŋ Jakob gebe “Latôm Josep gêdêŋ aôm gêwac.” Go Israel kêpuc tau tôŋ ma gêdi gêŋgôŋ nê mê. ");
INSERT INTO jae_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma Jakob kêsôm gêdêŋ Josep gebe “Ŋajaŋa ŋatau Anôtô geoc tau lasê gêdêŋ aê aŋga Lus, taŋ gêc gamêŋ Kanaan naŋ, to gêjam mec aê ");
INSERT INTO jae_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ma kêsôm gêdêŋ aê gebe ‘Ôlic acgom, aê gabe jakêŋ aôm ôka gôlôac lasê e têtu lau taêsam. Aê gabe jaŋgôm aôm ôtu laum kapôêŋ ma jakêŋ gamêŋ tonec êndêŋ nêm wakuc êtu nêŋ gêŋ endeŋ tôŋgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma galoc latômagêc, taŋ kôka êsêagêc lasê aŋga Aiguptu gêdêŋ taŋ aê gamêŋ Aiguptu atomgeŋ naŋ, têtu aêŋoc. Epraim agêc Manase têtu aêŋoc kêtôm Ruben agêc Simeon. ");
INSERT INTO jae_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Gôlôac, taŋ kôka lasê têdaguc êsêagêc naŋ, têtu aômnêm, ma êsêac sêwê kaiŋ gêŋlênsêm sêwiŋ teweŋiagêc. ");
INSERT INTO jae_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Gêdêŋ aê gawi Mesopotamia siŋ gaô lasê Kanaan naŋ Rahel gêmac êndu aŋga intêna, taŋ kêdabiŋ Eprat ma aê kasuŋ eŋ aŋga intêna Epratŋa ŋatali,” ŋaê teŋ gebe Betlehem. ");
INSERT INTO jae_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel gêlic Josep latuagêc ma kêsôm gebe “Asaagêc tonec.” ");
INSERT INTO jae_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josep gêjô tama awa gebe “Aê latucagêc, taŋ Anôtô kêkêŋ gêdêŋ aê aŋga tonec.” Go Israel kêsôm gebe “Ôkôc êsêagêc têtu gasuc sêmêŋmaŋ gebe janam mec êsêagêc.” ");
INSERT INTO jae_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel kêtu ŋamalacanô su tec mataanô kêtu waô e gêlic gamêŋ amboac gêmuŋŋa atom. Ma Josep gêwê êsêagêc dêdêŋ eŋ sêja, ma eŋ kêlêsôp êsêagêc aliŋanô ma kêmbôêŋ êsêagêc. ");
INSERT INTO jae_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Go Israel kêsôm gêdêŋ Josep gebe “Aê gaboc oc jalic aôm laŋômanô êtiam atom, mago galoc Anôtô kêkêŋ aê galic aômnêm gôlôac amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Go Josep kêkam êsêagêc sa aŋga ênê labum ma gewec e laŋôanô jagêdêŋ nom. ");
INSERT INTO jae_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ma Josep kêkam êsêagêc, kêkam Epraim ŋa lêma anôŋa, taŋ kêkanôŋ Israel lêma gasêŋa to Manase ŋa lêma gasêŋa, taŋ kêkanôŋ Israel lêma anôŋa ma gêwê êsêagêc têtu gasuc eŋ. ");
INSERT INTO jae_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mago Israel gêjac lêma keso tau ma kêmêtôc lêma anôŋa jagêu gêsac ŋac sauŋ Epraim môkêapac ma lêma gasêŋa gêsac Manase môkêapac. Manase eŋ ŋacsêga. ");
INSERT INTO jae_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ma eŋ gêjam mec Josep ma kêsôm gebe “Anôtô, taŋ tamocagêc Abraham agêc Isak sêsa nêŋ lêŋ sêmoa eŋ laŋônêmŋa, Anôtô, taŋ kêtu ŋoc ŋacgejob gêdêŋ ŋoc bêc samob e mêŋgêdêŋ galoc, ");
INSERT INTO jae_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","aŋela, taŋ gêjam aê kêsi gêdêŋ gêŋwapac samob naŋ, ênam mec ŋapalêagêc gebe ŋoc ŋaê to tamocagêc Abraham agêc Isak nêŋ ŋaê elom-elom aŋga êsêagêcnêŋ e têtu taêsam ma seola nom ŋagamêŋ auc.” ");
INSERT INTO jae_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Josep gêlic gebe tama gêu lêma anôŋa gêsac Epraim môkêapac e keso ênê ŋalêlôm, tec kêkôc tama lêma aŋga Epraim môkêapac gebe naênsac Manase môkêapac. ");
INSERT INTO jae_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ma Josep kêsôm gêdêŋ tama gebe “O tamoc, amboac tonaŋ atom. Ŋac tonec ŋacsêga, tec u lêmam anôŋa ênsac eŋ môkêapac.” ");
INSERT INTO jae_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mago tama gedec ma kêsôm gebe “Aê kajala, latucenec, aê kajalagac. Ŋac tonec oc êtu laum amboac tonaŋ ma êtu kapôêŋ, mago lasi êtu kapôêŋ êlêlêc eŋ ma ênê wakuc têtu laum taêsam.” ");
INSERT INTO jae_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tec gêjam mec êsêagêc gêdêŋ bêc tonaŋ ma kêsôm gebe” Lau Israel sêsam amagêcnêm ŋaê gebe sênam mec tauŋ ma sêsôm gebe’ Anôtô êŋgôm aôm ôtôm Epraim agêc Manase.’” Kêsôm amboac tonaŋ tec ketoc Epraim sa kêlêlêc Manase. ");
INSERT INTO jae_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Go Israel kêsôm gêdêŋ Josep gebe “Ôlic acgom, galoc jamac êndu, mago Anôtô êwiŋ amac ma êkêŋ amac aô lasê tameminêŋ gamêŋ êtiam. ");
INSERT INTO jae_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma aê jatoc aôm sa êlêlêc nêm lasitêwai su ma jakêŋ gamêŋ ŋabau, taŋ kajaŋgo su aŋga lau gamêŋ Amorŋa nêŋ ŋa ŋoc siŋ to talam naŋ êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Go Jakob kêkalem latui ma kêsôm gebe “Akac taôm sa api tageŋ gebe jasôm biŋ, taŋ êtap amac sa êndêŋ têm, taŋ gêc nêm ŋa naŋ, lasê êndêŋ amac. ");
INSERT INTO jae_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Jakob latuiac, akac taôm sa ma akêŋ taŋem tamemi Israel awa. ");
INSERT INTO jae_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, aôm kôtu ŋoc ŋacsêga, ŋoc ŋaclai to ŋoc ôlicwalô ŋamêc. Ŋac ŋamata waeŋa to ŋac ŋamata ŋaclaiŋa. ");
INSERT INTO jae_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Aômnêm lêŋ êtôm bu, taŋ gêc ŋasamac naŋ, tec ôtu ŋac ŋamata atom gebe aôm kôpi tamamnê mê ma gôgôm mê, taŋ aôm kôpi naŋ, kêtu sec. ");
INSERT INTO jae_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simon agêc Lewi êsêagêc lasitêwai. Êsêagêcnêŋ siŋ kêtu ŋaclai sec ŋawaba. ");
INSERT INTO jae_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O ŋoc katuc, naô lasê êsêacnêŋ sêkac sa atom. O ŋoc ŋalêlôm, ôwiŋ êsêacnêŋ lau atom gebe êsêac embe têntac ŋandaŋ, go sênac ŋamalac êndu. ");
INSERT INTO jae_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Aê japuc boa nêŋ têntac ŋandaŋ, gebe têntac ŋandaŋ ŋawaôboa to nêŋ ŋalêlôm kêmoatiŋ ŋajaŋa. Aê gabe jawa êsêac êkôc aŋga Jakobnê gamêŋ ma jata êsêac saliŋ-saliŋ aŋga Israel. ");
INSERT INTO jae_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“O Juda, lasitêwai oc sêlambiŋ aôm. Aôm lêmam êkam ŋacjo êndêŋ gêsutêkwa. Tamam latui oc sewec êndêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda kêtôm lewe ŋalatu. O latucenec, aôm kôjaŋgo gêŋ, tec gêlôm aôm kôtu kapôêŋ. Eŋ kêluŋ tau jakêlêwaŋ tau amboac lewe, kêtôm lewe têna teŋ. Asa gebe ensoc eŋ êndi sa. ");
INSERT INTO jae_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kiŋnê gêbôm oc endec Juda atom ma tôc gôliŋŋa endec asawa atom e elom ŋac, taŋ gêjac gêŋ tau ŋawae naŋ, ma tenteŋlatu oc taŋeŋ wamu êndêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Eŋ kêkô nê doŋki tôŋ kêpi wain ŋamôkê to nê doŋki ŋalatu kêpi wain ŋalaka. Eŋ kêkwasiŋ nê obo kêsêp wain to nê ŋakwê kêsêp wain ŋanô ŋatekwi. ");
INSERT INTO jae_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wain gêgôm mataanô ŋawasi kêsa ma su gêgôm luluŋ kêtu sêp. ");
INSERT INTO jae_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulon êŋgôŋ gwêctali. Eŋ êtu waŋ ŋasêcluŋ to ênê ŋamadiŋ ênêc e naêndêŋ Sidon. ");
INSERT INTO jae_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar eŋ ŋatêkwa kêtôm doŋki, taŋ jakêlêwaŋ tau gêmoa domba ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Eŋ gêlic gebe mala lêwaŋŋa ŋajam to gamêŋ tau têtac kêsa laŋgwageŋ, tec eŋ gewec gebe êôc gêŋ wapac ma kêtu gêŋôma gêjam kôm e kêkôniŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan êmêtôc nê lau amboac Israelnêŋ gôlôacnêŋ toŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan êtu moac teŋ, taŋ gêc intêna, êtu moacwêm, taŋ kêkêŋ gêjac intêna ŋataligeŋ naŋ, ma êŋac hos êsêp agêsu e ŋac, taŋ gêŋgôŋ hos ŋaô naŋ, embeŋ êsêp muŋa êna. ");
INSERT INTO jae_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Apômtau, aê gaôŋ aôm gebe ônam aê kêsi. ");
INSERT INTO jae_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Sêjaŋgowaga sêjanda Gad, mago eŋ êjanda êsêac êjô. ");
INSERT INTO jae_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asernê mo toŋalêsi ŋajam ma êmansaŋ gêŋ êtôm kiŋ sêniŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali kêtôm mojawa, taŋ kêlêti ŋagaôgeŋ naŋ. Biŋ ŋajam kêsa eŋ awasuŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josep kêtôm ka wakuc, taŋ gêjam ŋanô, ka wakuc, taŋ gêjam ŋanô ma kêkô bumata naŋ, ênê ŋalaka jagê gêsac tuŋbôm. ");
INSERT INTO jae_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Siŋwaga totalam sêlênsôŋ eŋ to sêpê nêŋ sôb ma sêjac siŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mago ênê talam ŋajaŋa ma eŋ lêma kata gebe Jakobnê ŋajaŋa ŋatau gêjam eŋ sa to ŋacgejob, lau Israel nêŋ poclabu, kêpuc eŋ tôŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tamamnê Anôtô ênam aôm sa to ŋajaŋa ŋatau Anôtô ênam mec aôm êkêŋ mec ŋamoasiŋ aŋga undambê ôŋa to mec ŋamoasiŋ aŋga ŋagêdimbob, taŋ kêpoac ŋalabuŋa naŋ, ma mec ŋamoasiŋ, taŋ kêsa su to têntaclêlôm naŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tamamnê mec ŋamoasiŋ tolêlôm-tolêlôm kêlêlêc lôc teŋgeŋŋa ŋamec ŋamoasiŋ su, kêlêlêc gamêŋ ŋabau laŋgwa sec ŋamoasiŋ. Gêŋ tonaŋ ŋai ênsac Josep môkêapac ŋaô, ênsac ŋac, taŋ gêmoa jaêc lasitêwai naŋ ŋaô. ");
INSERT INTO jae_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin kêtôm kêam sec, taŋ kêkac gêŋ gêŋgic-gêŋgic naŋ. Êndêŋ bêbêcgeŋ eŋ êndaŋgôŋ nê gwada ma êndêŋ êtula ênac sam gêŋ, taŋ kêjaŋgo naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israelnêŋ gôlôac 12 tau tonaŋ. Ma biŋ, taŋ tameŋi kêsôm gêdêŋ êsêac naŋ tonaŋ. Ma eŋ gêjam mec êsêac, eŋ gêjam mec êsêac gêdêŋ-gêdêŋgeŋ ŋa mec gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ma eŋ kêjatu êsêac to kêsôm gêdêŋ êsêac gebe “Anôtô embe êkalem aê najawiŋ ŋoc lau, go ansuŋ aê jawiŋ tamoci aŋga pocgêsuŋ, taŋ gêc ŋac gamêŋ Hetŋa Epron nê kôm, ");
INSERT INTO jae_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","aŋga pocgêsuŋ, taŋ gêc kôm Mak-Pela gêmu kêsô Mamreŋa aŋga gamêŋ Kanaan, kôm, taŋ Abraham gêjam ôli aŋga ŋac gamêŋ Hetŋa Epron nê gebe êtu gamêŋ sêôŋa. ");
INSERT INTO jae_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aŋga ônê êsêac sêsuŋ Abraham agêc nê awê Sara. Aŋga ônê êsêac sêsuŋ Isak agêc nê awê Rebeka. Aŋga ônê aê kasuŋ Lea. ");
INSERT INTO jae_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kôm to pocgêsuŋ, taŋ gêc ŋalêlôm naŋ, êsêac sêjam ôli aŋga lau gamêŋ Hetŋa nêŋ.” ");
INSERT INTO jae_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jakob kêjatu biŋ tonaŋ ŋai gêdêŋ latui e gêbacnê, go Anôtô kêkalem eŋ jagêwiŋ nê lau. Eŋ gê akaiŋ kêpi mê ma gêwi katu siŋ. ");
INSERT INTO jae_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Go Josep gêu tau gêsac tama laŋôanô ŋaô ma kêtaŋ kêpi eŋ to kêlêsôp eŋ. ");
INSERT INTO jae_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ma Josep kêjatu dokta, taŋ têtu ênê sakiŋwaga naŋ, gebe sêmansaŋ tama. Tec dokta seŋ oso Israelnê ŋawêlêlaŋ. ");
INSERT INTO jae_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ac sêjam bêc 40, gebe kôm taniŋ oso ŋawêlêlaŋŋa kêtôm ŋasawa amboac tonaŋ. Ma lau Aiguptu têtaŋ taŋiboa kêtôm bêc 70 kêtu eŋŋa. ");
INSERT INTO jae_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Têm taŋiboaŋa gêbacnê, go Josep kêsôm biŋ gêdêŋ Paraonê gôlôac gebe “Amac embe alic aê ŋajam, go jateŋ amac gebe amansaŋ biŋ êndêŋ Parao ma asôm gebe ");
INSERT INTO jae_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tamoc kêsôm gebe Kêdabiŋ gebe jamac êndu, tec ônsuŋ aê jasêp ŋoc sêô, taŋ kasap kêsêp poc aŋga gamêŋ Kanaanŋa. Tec katôc lemoc gêdêŋ tamoc gebe jaŋgôm ŋanô êsa. Kêtu tonaŋŋa aê jateŋ aôm gebe ôlôc gebe japi najansuŋ tamoc, go jamu jamêŋ êtiam.’” ");
INSERT INTO jae_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ma Parao gêjô eŋ awa gebe “Ôpi ôna, ônsuŋ tamam amboac kôtôc lêmam gêdêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tec Josep kêpi gêja gebe ênsuŋ tama, ma Paraonê sakiŋwaga samob to ênê gejobwaga anduŋa ma gamêŋ Aiguptu ŋagejobwaga samob sêpi sêwiŋ eŋ sêja. ");
INSERT INTO jae_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ma Josepnê andu ŋagôlôac to nê lasitêwai ma tamanê andu ŋagôlôac sêwiŋ amboac tonaŋ, tageŋ nêŋ gôlôac ŋasec-ŋasec ma nêŋ bulimakao to domba tec gacgeŋ sêwi siŋ sêmoa gamêŋ Gosen. ");
INSERT INTO jae_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kareta to lau tohos sêpi sêwiŋ eŋ sêja amboac tonaŋgeŋ. Lau tau tônê nêŋ toŋ kapôêŋanô. ");
INSERT INTO jae_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Gêdêŋ taŋ sêô lasê polom ŋamala Atadŋa, taŋ gêc bu Jordan ŋamakeŋ ônêŋa naŋ, êsêac sêpuc taŋiboa sa ma têtaŋ ŋanô tonêŋ ŋalêlôm ŋawapacgeŋ. Josep kêmasaŋ biŋ gebe lau têtaŋ taŋiboa êtôm bêc 7 êtu tamaŋa. ");
INSERT INTO jae_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ma malacm tau, lau gamêŋ Kanaanŋa, sêŋô taŋiboa kêpi aŋga polom ŋamala Atadŋa ma sêsôm gebe “Lau Aiguptu têtaŋ taŋiboa kapôêŋ aŋga ônê.” Tec sê gamêŋ tau ŋaê gebe Abel-Misraim. Gamêŋ tau gêc bu Jordan ŋamakeŋ ônêŋa. ");
INSERT INTO jae_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tec Jakob latui sêgôm biŋ, taŋ eŋ kêjatu êsêac naŋ, kêtu anô ");
INSERT INTO jae_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","gebe latui sêbalaŋ eŋ sêja gamêŋ Kanaan ma sêsuŋ eŋ kêsêp pocgêsuŋ, taŋ gêc kôm Mak-Pela ŋalêlôm, taŋ gêc gêmu kêsô Mamreŋa. Abraham gêjam ôli pocgêsuŋ tau tokômgeŋ aŋga ŋac gamêŋ Hetŋa Epron nê gebe êtu ênê gamêŋ sêôŋa. ");
INSERT INTO jae_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josep kêsuŋ tama su, go eŋ to nê lasitêwai ma lau samob, taŋ sêpi sêwiŋ eŋ sêja gebe sênsuŋ tamaŋa naŋ, sêmu sêja Aiguptu kêtiam. ");
INSERT INTO jae_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Josepnê lasitêwai sêlic gebe tameŋi gêmac êndu su, tec sêsôm gebe “Moae Josep êkêŋ kisa aêac ma êkêŋ ŋagêjô êjô sec samob, taŋ dagôm gêdêŋ eŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Amboac tonaŋ êsêac sêsakiŋ biŋ gêdêŋ Josep gêja ma sêsôm gebe “Kêdabiŋ gebe tamam êmac êndu, tec kêkêŋ jatu tonec gebe ");
INSERT INTO jae_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Asôm êndêŋ Josep gebe ‘Aê jateŋ aôm êtu têwamiŋa gebe êsêac sêgôm aôm sec. Mago ôsuc êsêacnêŋ keso to sec ôkwimaŋ.’ Ma galoc aêac ateŋ aôm gebe ôsuc tamamnê Anôtônê sakiŋwaga aêac ma keso ôkwi.” Gêdêŋ taŋ sêsôm biŋ gêdêŋ eŋ sêmoa naŋ, Josep tau kêtaŋ. ");
INSERT INTO jae_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Têwai samob dêdêŋ eŋ sêja jasêu tauŋ sêc eŋ laŋônêmŋa ma sêsôm gebe “Gôlicgac me, aêac atu nêm sakiŋwaga.” ");
INSERT INTO jae_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mago Josep kêsôm gêdêŋ êsêac gebe “Atêc taôm atom. Aê jajô Anôtô su me. ");
INSERT INTO jae_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Amac abe aŋgôm aê sec, mago Anôtô gêjam keso tau ôkwi kêtu moasiŋ. Eŋ gebe êŋgôm gêŋ tônê gebe lau taêsam sêŋgôŋ mateŋ jali amboac talic gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Amboac taŋ, atêc taôm atom, aê gabe janam amac to nêm ŋasec-ŋasec sa.” Eŋ gêjam malô êsêac amboac tonaŋ ma gêjac êsêac têntac tôŋ. ");
INSERT INTO jae_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Amboac tonaŋ Josep to tamanê gôlôac sêŋgôŋ Aiguptu ma Josepnê jala kêtu 110. ");
INSERT INTO jae_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ma Josep gêlic Epraim latui to dêbui, ma Manase latu Makir nê gôlôac, teneŋi sêkôc êsêac sêŋgôŋ Josepnê labum. ");
INSERT INTO jae_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ma Josep kêsôm gêdêŋ nê lasitêwai gebe “Kêdabiŋ gebe jamac êndu. Mago Anôtô ênam amac kêsi ma êwê amac awi gamêŋ tonec siŋ e aô lasê gamêŋ, taŋ Anôtô gêôc lêma sa ma kêsôm kêtu tôŋ gebe êtu Abraham agêc Isak ma Jakob nêŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Go Josep awa gêjac Israel latui gebe têtôc lemeŋ ma kêsôm gebe “Anôtô embe ênam amac kêsi, go ambalaŋ ŋoc ŋatêkwa aŋga tonec api ana.” ");
INSERT INTO jae_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tec Josep gêmac êndu, nê jala kêtu 110, ma êsêac seŋ oso ênê ŋawêlêlaŋ ma sêkêŋ eŋ kêsêp waŋ aŋga Aiguptu. ");
INSERT INTO jae_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel latui, taŋ sêja Aiguptu sêwiŋ Jakob naŋ, nêŋ ŋaê tonec. Êsêac samob sêja tonêŋ gôlôacgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben agêc Simeon ma Lewi agêc Juda, ");
INSERT INTO jae_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ma Isakar agêc Sebulon ma Benjamin, ");
INSERT INTO jae_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ac to Dan agêc Naptali ma Gad agêc Aser. ");
INSERT INTO jae_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","(Jakobnê gôlôac samob sêpi tageŋ lau 70.) Josep tau gêmoa Aiguptu kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sêmoa acgom, go Josep tau to nê lasitêwai ma nêŋ gôlôac samob sêmac êndu. ");
INSERT INTO jae_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mago lau Israel nêŋ wakuc sêka gôlôac lasê e têtu taêsam ŋanô. Êsêac ŋalêlêma atom, sesewec toŋaclaigeŋ e sêjam gamêŋ tau auc. ");
INSERT INTO jae_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Gêdêŋ tonaŋ kiŋ wakuc mêŋkêsa aŋga Aiguptu. Ŋac tau gêjam kauc Josep. ");
INSERT INTO jae_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Eŋ kêsôm gêdêŋ nê lau gebe “Alic acgom, lau Israel têtu taêsam ŋanô ma sesewec toŋaclai sêlêlêc aêac sugoc. ");
INSERT INTO jae_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ajôc, daŋgôm nêŋ gêŋ tokaucgeŋ gebe têtu taêsam sêlêlêc aêac atom. Embe siŋ êsa, oc moae sêwiŋ aêacnêŋ ŋacjo ma sênac siŋ êndêŋ aêac e sêwi aêacnêŋ gamêŋ siŋ ma sêc sêna.” ");
INSERT INTO jae_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kêtu tonaŋŋa êsêac sêkêŋ gejobwaga kômŋa gebe sêkôniŋ lau Israel ŋa kôm ŋawapac. Tec lau Israel sêkwê malac Piton to Rameses sa. Malac luagêc tonaŋ kêtu Paraonê malac ênac kôm ŋanô saŋa. ");
INSERT INTO jae_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lau Aiguptu sêkôniŋ lau Israel tôŋ ŋanôgeŋ, mago êsêac têtu taêsam ŋanô e sêjam gamêŋ auc. Tec lau Aiguptu têtêc lau Israel ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Amboac tonaŋ lau Aiguptu sêkac lau Israel gebe sênam kôm kapoacwalôŋa. ");
INSERT INTO jae_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Êsêac sejoŋ lau Israel ŋa kôm ŋawapacgosu. Lau Israel sêkwê andu ŋa poc, taŋ sêmasaŋ ŋa nomku naŋ, to kolda ma sêjam kôm tokôm. Lau Aiguptu sêkac êsêac gebe sênam kôm samob tonaŋ ŋai toŋaôli masigeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Go kiŋ Aiguptuŋa kêsôm biŋ gêdêŋ lau Ebolai nêŋ jaomwagao. Awê teŋ nê ŋaê gebe Sipra ma teŋ nê ŋaê Pua. ");
INSERT INTO jae_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Eŋ kêsôm gebe “Amagêc embe anam Ebolainêŋ lauo sa êndêŋ têm sêkôc ŋapalêŋa, go ajop ŋapep. Awê teŋ embe êkôc ŋapalê ŋac, naŋ anac êndu. Embe êkôc awê, go andec êmoa.” ");
INSERT INTO jae_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mago jaomwagaoagêc têtêc Anôtô, tec sêgôm kiŋ Aiguptuŋa nê biŋ ŋanô kêsa atom, agêc dedec ŋapalê ŋac sêmoa mateŋ jali amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tec kiŋ Aiguptuŋa kêkalem jaomwagaoagêc ma kêsôm gêdêŋ êsêagêc gebe “Amagêc adec ŋapalê ŋac sêmoa mateŋ jali kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Jaomwagaoagêc sêsôm gêdêŋ Parao gebe “Ebolainêŋ lauo têtôm lauo Aiguptuŋa atom. Êsêac ôliŋwalô kaiŋ teŋ. Jaomwagao sêô lasê dêdêŋ êsêac atomgeŋ ma sêkôc ŋapalê su.” ");
INSERT INTO jae_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Anôtô kêmoasiŋ jaomwagao ma lau Israel têtu taêsam ma sesewec toŋaclaigeŋ. ");
INSERT INTO jae_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Jaomwagao têtêc Anôtô, tec Anôtô kêkêŋ gôlôac gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Go Parao kêjatu nê lau samob gebe “Ŋapalê ŋac samob, taŋ Ebolainêŋ lauo sêkôc naŋ, ambaliŋ samob siŋ sêsêp bu Nil sêna, ma ŋapalêogeŋ tec andec sêmoa.” ");
INSERT INTO jae_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ŋac teŋ aŋga Lewinê gôlôac gêjam awê teŋ. Awê tau aŋga Lewinê gôlôac amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Awê tau taê ma kêkôc ŋapalê ŋac teŋ. Eŋ gêlic gebe ŋapalê tau ŋajam, tec kêsiŋ eŋ ôkwi kêtôm ajôŋ têlêac. ");
INSERT INTO jae_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Gêdêŋ taŋ têna kêtôm gebe êsiŋ eŋ ôkwi êtiam atom naŋ, eŋ kêkôc katapa, taŋ sêmasaŋ ŋa talu naŋ, ma kepeŋ sib, go kêkêŋ ŋapalê tau kêsêp ma ketoc katapa tau kêkô bu Nil ŋatali ŋasiŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ŋapalê luo kêkô ec jaêc sauŋgeŋ, gebe êlic gêŋ ondoc oc êtap ŋapalê tau sa. ");
INSERT INTO jae_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gêdêŋ tonaŋ Parao latuo mêŋgêô lasê gebe êliŋ bu. Ênê sakiŋwagao sêsêlêŋ sêmoa butali. Awê tau gêlic katapa kêkô siŋ ŋalêlôm, go kêsakiŋ nê sakiŋwagao teŋ gebe êkôc gêŋ tau. ");
INSERT INTO jae_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Parao latuo kêkac baob sa e gêlic ŋapalê teŋ. Ŋapalê tau kêtaŋ, tec taê walô eŋ ma kêsôm gebe “Ebolainêŋ ŋapalê teŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tec ŋapalê luo jakesôm gêdêŋ Parao latuo gebe “Amboac ondoc, aê najamôêc Ebolainêŋ lasulawê teŋ gebe êkêŋ su ŋapalê tau ênôm êtu aômŋa me masi.” ");
INSERT INTO jae_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Parao latuo kêsôm gêdêŋ eŋ gebe “Ônamaŋ.” Tec ŋapalê luo gêja jagêmôêc ŋapalê tau têna. ");
INSERT INTO jae_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Go Parao latuo kêsôm gêdêŋ eŋ gebe “Ôkôc ŋapalê tonec ma ôkêŋ su êndêŋ eŋ êtu aêŋa. Aê oc jakêŋ ŋaôli êndêŋ aôm êjô nêm kôm.” Tec awê tau kêkôc ŋapalê ma gêlôm eŋ. ");
INSERT INTO jae_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Gêdêŋ taŋ ŋapalê tau kêtu kapôêŋ su naŋ, têna kejoŋ eŋ gêdêŋ Parao latuo gêja. Ma eŋ kêkôc ŋapalê tau su kêtu ênê latu ma kêsôm gebe “Aê gaê eŋ sa aŋga bu,” tec gê ênê ŋaê gebe Mose. ");
INSERT INTO jae_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose kêtu kapôêŋ su ma bêc teŋ eŋ gêja gebe êlic nê lau ma gêlic kôm ŋawapac, taŋ kêkôniŋ êsêac tôŋ naŋ. Ma gêlic ŋac Aiguptuŋa teŋ gêjac Ebolai teŋ. Eŋ Mosenê launêŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose mata geso gamêŋ e gêlic teŋ gêmoa atom, tec gêjac ŋac Aiguptuŋa tau êndu ma kêgawê gaŋac ma kêsuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ŋabêbêc Mose kêsa gêdêŋ nê lau gêja kêtiam ma gêlic Ebolai luagêc sêjac tauŋ. Ma eŋ kêsôm gêdêŋ ŋac, taŋ gêgôm keso naŋ, gebe “Gôjac nêm ŋac kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mago ŋac tau gêjô eŋ awa gebe “Asa kêkêŋ aôm kôtu aêacma gôliŋwaga to mêtôcwaga. Oc gobe ônac aê êndu amboac gôjac Aiguptu tau naŋ me.” Go Mose kêtakê ma taê gêjam gebe “Biŋŋanô, biŋ tau ŋapuc kêsa sugac.” ");
INSERT INTO jae_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Gêdêŋ taŋ Parao gêŋô ŋawae naŋ, eŋ gêgôm gêŋlêlôm gebe ênac Mose êndu. Mago Mose gêc Parao su jagêmoa gamêŋ Midianŋa. Ma eŋ jagêŋgôŋ bumata teŋ. ");
INSERT INTO jae_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ma dabuŋwaga Midianŋa nê latuio 7 sêmoa. Êsêac sêsa jasêkati bu jasêsêwa kêsêp suc, gebe tameŋinê domba sênôm. ");
INSERT INTO jae_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mago gejobwaga bôcŋa sêmêŋ ma têtiŋ êsêac su. Tec Mose gêdi jagêjam êsêac sa ma kêkêŋ bu gêdêŋ nêŋ domba sênôm. ");
INSERT INTO jae_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Su, go êsêac dêdêŋ tameŋi Reuel sêja, ma eŋ kêsôm gebe “Amboac ondoc, tec ocsalô tonec amu amêŋ ŋagaôgeŋ nec.” ");
INSERT INTO jae_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Êsêac sêsôm gebe “Ŋac Aiguptuŋa teŋ gêjam aêac sa aŋga gejobwaga bôcŋa ma kêkati bu gêjô aêac su jakêkêŋ gêdêŋ domba sênôm.” ");
INSERT INTO jae_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Go tameŋi kêsôm gêdêŋ latuio gebe “Eŋ gêmoa ondoc. Adec ŋac tau kêkô tônê kêtu asageŋŋa. Amôêc eŋ gebe êniŋ gêŋ êwiŋ aêacmaŋ.” ");
INSERT INTO jae_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose gêlic kêtôm gebe êmoa êwiŋ Reuel, tec ŋac tau kêkêŋ latuo Sipora gêdêŋ Mose gêjam. ");
INSERT INTO jae_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Awê tau kêkôc ŋapalê teŋ, ma Mose kêsôm gebe “Aê katu ŋacleŋ gamoa gamêŋ jaba.” Tec gê ênê ŋaê gebe Gerson. ");
INSERT INTO jae_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ŋasawa baliŋ tonaŋ gêbacnê ma kiŋ Aiguptuŋa gêmac êndu. Mago lau Israel seŋ oliŋ tauŋ kêtu nêŋ kôm ŋawapacŋa ma sêmôêc gebe Anôtô ênam êsêac sa. Ma êsêacnêŋ taŋiboa kêtu kôm ŋawapacŋa kêpi gêdêŋ Anôtô gêja. ");
INSERT INTO jae_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ma Anôtô kêkêŋ taŋa nêŋ oliŋ tau ma taê gêjam poac, taŋ kêmoatiŋ gêdêŋ Abraham agêc Isak ma Jakob. ");
INSERT INTO jae_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ma Anôtô gêlic lau Israel ma kêwaka tau sa gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ma Mose gejob lawa dabuŋwaga Midianŋa Jetro nê domba. Eŋ gêwê domba kêsa gamêŋ sawa kêsêlêŋ ec ŋêŋgeŋ e gêô lasê Anôtônê lôc Horeb. ");
INSERT INTO jae_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ma Anôtônê aŋela geoc tau lasê gêdêŋ eŋ ŋa jawaô. Ja ŋawaô tau kêsa gamêŋdani ŋalêlôm. Mose gêlic ja kêsa gamêŋdani, mago ja geŋ gamêŋdani tau su atom. ");
INSERT INTO jae_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ma Mose kêsôm gebe “Aê gabe jana najalic gêŋsêga tonec. Ja geŋ gamêŋdani su atom ŋam amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Apômtau gêlic eŋ kêdabiŋ gamêŋdani gebe êlic ŋam, tec Anôtô gêmôêc gêdêŋ eŋ aŋga gamêŋdani gebe “Mose, Mose.” Ma eŋ gêjô eŋ awa gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Go Anôtô kêsôm gebe “Ôtu gasuc ômôêŋ atom. Ônu nêm atapa su aŋga amtapa gebe gamêŋ, taŋ aôm kôkô naŋ, nom dabuŋ.” ");
INSERT INTO jae_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ma kêsôm teŋ gêwiŋ gebe “Tamamnê Anôtô aê, ma Abrahamnê Anôtô ma Isaknê Anôtô ma Jakobnê Anôtô aêgoc.” Mose gêsaŋ laŋôanô auc gebe kêtêc tau, gebe êlic Anôtô atom. ");
INSERT INTO jae_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Go Apômtau kêsôm gebe “Aê galic ŋoc lau sêmoa jageo ŋanô aŋga Aiguptu. Aê gaŋô êsêac sêmôêc kêtu nêŋ gejobwaga kapoacwalôŋa sêlêsu êsêacŋa. Biŋŋanô, aê kajala êsêacnêŋ ŋandaŋ. ");
INSERT INTO jae_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Aê kasêp gamêŋ gebe janam êsêac kêsi aŋga lau Aiguptu lemeŋ ma jawê êsêac sêwi gamêŋ tonaŋ siŋ nasêpi gamêŋ ŋajam to kapôêŋ teŋ. Aŋga gamêŋ tau tônê su to lêp keseleŋ. Galoc lau Kanaan to Het ma Amor to Peres ma Hib to Jebus sêŋgôŋ gamêŋ tau. ");
INSERT INTO jae_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Aê gaŋô lau Israel nêŋ taŋi maŋkêsô aê taŋocsuŋ ma galic lau Aiguptu sejoŋ êsêac ŋanô. ");
INSERT INTO jae_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Amboac tonaŋ aê gabe jasakiŋ aôm ôndêŋ Parao ôna gebe ôwê ŋoc lau Israel sêwi Aiguptu siŋ.” ");
INSERT INTO jae_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mago Mose kêsôm gêdêŋ Anôtô gebe “Aê asa, tec jandêŋ Parao jana ma jawê lau Israel sêwi Aiguptu siŋ nec.” ");
INSERT INTO jae_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Anôtô gêjô eŋ awa gebe “Aê oc jawiŋ aôm. Ma gabe jakêŋ ŋabelo tonec êndêŋ aôm gebe ôjala, gebe aê tauc tec kasakiŋ aôm. Ŋabelo tau tonec gebe Êndêŋ taŋ ôwê lau sêwi Aiguptu siŋ su naŋ, oc anam sakiŋ Anôtô aŋga lôc tonec.” ");
INSERT INTO jae_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Go Mose kêsôm gêdêŋ Anôtô gebe “Embe jandêŋ lau Israel jana ma jasôm êndêŋ êsêac gebe ‘Tameminêŋ Anôtô kêsakiŋ aê tec gamêŋ,’ ma êsêac embe têtu kênac aê gebe ‘Ênê ŋaê amboac ondoc,’ oc jasôm amboac ondoc êndêŋ êsêac.” ");
INSERT INTO jae_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Go Anôtô kêsôm gêdêŋ Mose gebe “Aêŋoc ŋaê gebe Aê-Gamoa-Amboac-Gamoa.” Ma Anôtô kêsôm teŋ gêwiŋ gebe “Ôsôm biŋ tonec êndêŋ lau Israel gebe ‘Aê-Gamoa kêsakiŋ aê’ tec gadêŋ amac gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ma Anôtô kêsôm gêdêŋ Mose gêwiŋ gebe “Ôsôm êndêŋ lau Israel gebe ‘Apômtau, amac tameminêŋ Anôtô, Abrahamnê Anôtô ma Isaknê Anôtô ma Jakobnê Anôtô kêsakiŋ aê gadêŋ amac gamêŋ.’ Ŋaê tonec kêtu ŋoc ŋaê teŋgeŋ ma teŋgeŋŋa ma gôlôac to gôlôac wakuc samob aweŋ ênac aê ŋa ŋaê tonecgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ôna ma ôkalem lau Israel nêŋ laumata sa sêpi tageŋ, go ôsôm êndêŋ êsêac gebe ‘Apômtau, amac tameminêŋ Anôtô, geoc tau lasê gêdêŋ aê. Eŋ Abraham agêc Isak ma Jakob nêŋ Anôtô. Ma eŋ kêsôm gêdêŋ aê gebe “Aê gajac amac kêsi ma galic gêŋ samob, taŋ lau Aiguptu sêgôm gêdêŋ amac naŋ. ");
INSERT INTO jae_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tec aê taêc gêjam kêtu tôŋ gebe jawê amac awi gêŋwapac Aiguptuŋa siŋ ma aô lasê lau Kanaan to lau Het ma Amor to Peres ma Hib to Jebus nêŋ gamêŋ. Aŋga gamêŋ tônê su to lêp keseleŋ.” ’ ");
INSERT INTO jae_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Lau Israel nêŋ laumata oc sêkêŋ taŋeŋ nêm biŋ ma sêwiŋ aôm andêŋ kiŋ Aiguptuŋa ana ma asôm êndêŋ eŋ gebe ‘Apômtau, Ebolainêŋ Anôtô, mêŋgêjam biŋgalôm gêwiŋ aêac, tec galoc ateŋ aôm gebe ôwi aêac siŋ gebe asêlêŋ bêc têlêac asa gamêŋ sawa ana ma akêŋ da êndêŋ aêacma Apômtau Anôtô.’ ");
INSERT INTO jae_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aê kajalagac gebe kiŋ Aiguptuŋa oc êwi amac siŋ atom e ŋaclai teŋ êkac eŋ acgom. ");
INSERT INTO jae_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Amboac tonaŋ aê oc jamêtôc lemoc to janac Aiguptu ŋa gêŋtalô tokaiŋ-tokaiŋ aŋga gamêŋ tau. Gêŋtalô tau êmbacnê acgom, go êwi amac siŋ ana. ");
INSERT INTO jae_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Aê jaŋgôm lau Aiguptu sêlic lau Israel ŋajam ma embe ana, go ana tolemem sawageŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Amacnêm lauo samob êndêŋ-êndêŋgeŋ teteŋ nêŋ lauo sackapoac gêdêŋ tauŋŋa to lauo, taŋ sêŋgôŋ andu tageŋ sêwiŋ tauŋ naŋ, gebe sêkêŋ gêlôŋ silber to goldŋa ma ŋakwê êndêŋ êsêac. Ma amac akêŋ nêm latômio to ŋac sêsô to sênôŋ gêŋ tau. Amboac tonaŋ ajaŋgo gêŋ su aŋga lau Aiguptuŋa.” ");
INSERT INTO jae_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Go Mose gêjô eŋ awa gebe “Mago lau Israel embe sêkêŋ êwiŋ aê atom to sêkêŋ taŋeŋ ŋoc biŋ atom ma sêsôm êndêŋ aê gebe ‘Apômtau geoc tau lasê gêdêŋ aôm atom,’ go jaŋgôm amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Apômtau kêtu kênac eŋ gebe “Aôm lêmam kômêgôm asageŋ.” Ma Mose gêjô eŋ awa gebe “Kamêgôm tôc.” ");
INSERT INTO jae_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Go Apômtau kêsôm gebe “Ômbaliŋ naênêc nom.” Ma Mose kêbaliŋ tôc jagêc nom e kêtu moac. Ma kêtakê e gênu tau su. ");
INSERT INTO jae_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mago Apômtau kêsôm gêdêŋ Mose gebe “Ômêtôc lêmam ma ômêŋgôm moac ŋalêŋuc.” Tec eŋ kêmêtôc lêma ma kêmêgôm moac tôŋ jakêtu tôc kêtiam kêsêp eŋ lêma. ");
INSERT INTO jae_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ma Apômtau kêsôm gebe “Ôŋgôm amboac tonaŋ e sêkêŋ êwiŋ gebe Apômtau eŋ êsêac tameŋinêŋ Anôtô. Eŋ Abrahamnê Anôtô ma Isaknê Anôtô ma Jakobnê Anôtô geoc tau lasê gêdêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Go Apômtau kêsôm biŋ ŋagêdô gêdêŋ eŋ gebe “Ônsêmuŋ lêmam êsô nêm ŋakwê.” Eŋ kêsêmuŋ lêma kêsô ma gêdêŋ taŋ kêtaiŋ sa kêtiam naŋ, gêlic gebe kamocbôm gêjac têc lêma auc e kêtu sêp kêtôm labi. ");
INSERT INTO jae_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Go Apômtau kêsôm gebe “Ônsêmuŋ lêmam êmu êsô nêm ŋakwê êtiam.” Tec Mose kêsêmuŋ lêma gêmu kêsô nê ŋakwê kêtiam, Ma gêdêŋ taŋ kêtaiŋ sa kêtiam naŋ, gêlic gebe ŋajam kêsa kêtôm ôli ŋagêdô. ");
INSERT INTO jae_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ma Anôtô kêsôm gebe “Êsêac embe sêkêŋ êwiŋ aôm atom ma gêŋtalô ŋamataŋa embe ênam êsêac ôkwi atom, go sêkêŋ êwiŋ gêŋtalô êtu luagêcŋa. ");
INSERT INTO jae_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ma êsêac embe sêkêŋ êwiŋ gêŋtalô luagêc tonaŋ to sêkêŋ taŋeŋ nêm biŋ atom, go ôkati bu aŋga bu Nil ma mêŋôkêc êsêp nom, go bu, taŋ ôkati aŋga bu Nil naŋ, oc êtu dec ênêc nom.” ");
INSERT INTO jae_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mago Mose kêsôm gêdêŋ Apômtau gebe “Oe, ŋoc Apômtau, aê aoc sob atom. Gêmuŋgeŋ aê gamoa amboac tonaŋ ma galoc kôsôm biŋ gêdêŋ aê, taŋ katu nêm sakiŋwaga naŋ, mago aoc sob kêsa atom amboac tonaŋgeŋ. Aê kasôm biŋ malô-malô to imbeloc ŋawapac sec.” ");
INSERT INTO jae_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Go Apômtau kêsôm gêdêŋ eŋ gebe “Asa kêkêŋ ŋamalac awasuŋ. Asa kêkêŋ eŋ awamê me taŋasuŋbic me gêlic gamêŋ me matapec. Aê Apômtau kakêŋ atom me. ");
INSERT INTO jae_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Amboac tonaŋ ôna ma aê jawiŋ aôm to janam aôm awam sa ma jandôŋ biŋ ôsômŋa êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mago Mose kêsôm gebe “O Apômtau, aê jateŋ aôm gebe ôsakiŋ lau teŋ.” ");
INSERT INTO jae_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Go Apômtau têtac ŋandaŋ kêsa gêdêŋ Mose ma kêsôm gebe “Têwam Aron aŋga Lewinê gôlôac gêmoa atom me. Aê kajala eŋ awa sob. Ôlic acgom, eŋ gêdi kêpuc aôm tôŋtôŋ gêmêŋ. Eŋ embe êlic aôm, oc têtac ŋajam êsa ŋanô. ");
INSERT INTO jae_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Amboac tonaŋ ônam biŋgalôm êndêŋ eŋ ma ôwa nêm biŋ sa êndêŋ eŋ gebe êsôm lasê. Ma aê gabe jawiŋ amagêc to janam amagêc aweŋ sa ma jandôŋ gêŋ ôŋgômŋa êndêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Eŋ êjô aôm su êsôm biŋ êndêŋ lau ma êtu aôm awam. Ma eŋ êlic aôm amboac Anôtô. ");
INSERT INTO jae_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ma aôm ômêŋgôm tôc tonec gebe ôŋgôm gêŋtalôŋa.” ");
INSERT INTO jae_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ma Mose gêmu gêdêŋ lawa Jetro gêja jakêsôm gêdêŋ eŋ gebe “Aê jateŋ aôm gebe ôlôc sa ma aê jamu jandêŋ ŋoc lau jana Aiguptu najalic êsêac sêmoa mateŋ jali me masi.” Ma Jetro kêsôm gêdêŋ Mose gebe “Ôêc tobiŋmalôgeŋ ôna.” ");
INSERT INTO jae_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ma Apômtau kêsôm gêdêŋ Mose aŋga Midian gebe “Ômu ôna Aiguptu gebe lau samob, taŋ sebe senseŋ aôm naŋ, sêmac êndu su.” ");
INSERT INTO jae_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Amboac tonaŋ Mose kêkôc nê awê to latu ma kêkêŋ êsêagêc sêŋgôŋ doŋki teŋ ŋaô ma gêja gamêŋ Aiguptuŋa. Ma eŋ kêmêgôm Anôtônê tôc. ");
INSERT INTO jae_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, aôm embe ô lasê Aiguptu, go ôŋgôm gêŋtalô samob, taŋ kakêŋ ŋaclai gêdêŋ aôm gebe ôŋgômŋa naŋ, ôkô Parao laŋônêmŋa. Mago aê oc jaŋgôm ênê ŋalêlôm ŋadani êsa, gebe êwi lau siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Go aôm ôsôm êndêŋ Parao gebe ‘Apômtaunê biŋ tau tonec gebe Ŋoc latuc ŋacsêga tau Israel, ");
INSERT INTO jae_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ma aê jasôm êndêŋ aôm gebe “Ôwi latuc siŋ gebe naênam sakiŋ aê.” Ôlic acgom, embe ondec ma ôwi eŋ siŋ atom, go janseŋ aôm latôm ŋacsêga su.’” ");
INSERT INTO jae_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Êsêac sêsêlêŋ sêmoa intêna e sêô lasê gamêŋ sênêc bêcŋa teŋ. Ma Apômtau gêdac Mose aŋga tônê ma kêsaê gebe ênac eŋ êndu. ");
INSERT INTO jae_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Go Sipora kêkôc bôjaŋ poc ŋagaôgeŋ ma kêsa latu utiôlic jakêmoasac Mosenê lambi ŋa ŋaôlic tau tonaŋ ma kêsôm gebe “Biŋŋanô, aôm kôtu ŋoc ŋac-gebe-ênam-awêwaga todec.” ");
INSERT INTO jae_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Go Apômtau gêwi eŋ siŋ gêmoa mata jali. Gêdêŋ tonaŋ awê tau kêlêwiŋ biŋ sêsa lauŋa gebe “Ŋac-gebe-ênam-awêwaga todec.” ");
INSERT INTO jae_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Apômtau kêsôm gêdêŋ Aron gebe “Ôpuc Mose tôŋtôŋ ôsa gamêŋ sawa ôna.” Tec eŋ gêja ma gêdac Mose aŋga Anôtônê lôc ma kêlêsôp eŋ alianô. ");
INSERT INTO jae_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Go Mose gêjac miŋ biŋ samob, taŋ Apômtau kêsôm gêdêŋ taŋ kêsakiŋ eŋ naŋ, to gêŋtalô samob, taŋ Apômtau kêjatu eŋ gebe êŋgômŋa. ");
INSERT INTO jae_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Go Mose agêc Aron sêja ma sêkalem lau Israel nêŋ laumata samob sa sêpi tageŋ. ");
INSERT INTO jae_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ma Aron kêsôm biŋ samob, taŋ Apômtau kêsôm gêdêŋ Mose naŋ, ma gêgôm gêŋtalô lau sêlic. ");
INSERT INTO jae_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ma lau tau sêkêŋ gêwiŋ. Gêdêŋ taŋ sêŋô ŋawae gebe Apômtau kêtu ŋacleŋ lau Israel ma gêlic êsêacnêŋ gêŋwapac naŋ, êsêac sewec ma teteŋ mec. ");
INSERT INTO jae_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Tônê su, go Mose agêc Aron dêdêŋ Parao sêja ma sêsôm gebe “Apômtau, Israelnêŋ Anôtô, nê biŋ tonec gebe ‘Ôwi ŋoc lau siŋ gebe sêlic nêŋ om teŋ aŋga gamêŋ sawa êtu tetoc aê saŋa.’” ");
INSERT INTO jae_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mago Parao gêjô êsêagêc aweŋ gebe “Apômtau tau asa, tec jakêŋ taŋoc eŋ ma jawi Israel siŋ. Aê gajam kauc Apômtau tonaŋ, ma aê gadec gebe jawi Israel siŋ.” ");
INSERT INTO jae_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Go êsêagêc sêsôm gebe “Ebolainêŋ Anôtô gêjam biŋgalôm gêwiŋ aêagêc, tec ateŋ aôm gebe ôwi aêac siŋ. Aêac asa gamêŋ sawa ana asêlêŋ bêc têlêacgeŋ ma akêŋ da êndêŋ Apômtau, aêacma Anôtô. Embe masi, oc êsêp êndêŋ aêac êmêŋ ŋa kole to siŋ.” ");
INSERT INTO jae_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mago Parao kêsôm gêdêŋ êsêagêc gebe “Mose agêc Aron, amagêc abe akôc lau su aŋga nêŋ kôm kêtu asageŋŋa. Aec su andêŋ nêm koleŋ ana.” ");
INSERT INTO jae_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ma Parao kêsôm teŋ gebe “Agêc alic acgom, galoc lau tau têtu taêsam su, ma amagêc abe akô êsêac auc aŋga nêŋ kôm ma akêŋ êsêac sêlêwaŋ tauŋ.” ");
INSERT INTO jae_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Gêdêŋ bêc tonaŋgeŋ Parao kêjatu lausêlêsuwaga to gejobwaga gebe ");
INSERT INTO jae_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Akêŋ oba êndêŋ lau amboac agôm naŋ, êtiam atom. Êsêac tauŋ nasejoŋ oba gebe sêmansaŋ nomku têkê-têkê. ");
INSERT INTO jae_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mago nomku têkê-têkê ŋanamba, taŋ sêmasaŋ kêtôm bêcgeŋ naŋ, êkôgeŋ, êtu sauŋ atom, gebe êsêac ojomtêna, tec sêmôêc gebe ‘Ôwi aêac siŋ gebe akêŋ da êndêŋ aêacma Anôtô.’ ");
INSERT INTO jae_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Akêŋ kôm ŋawapac êkôniŋ lau tonaŋ e ênam êsêac auc ma têtap nêŋ ŋasawa sêkêŋ taŋeŋ biŋ agwa-agwaŋa sa atom.” ");
INSERT INTO jae_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Amboac tonaŋ lau-sêlêsuwaga to launêŋ gejobwaga sêsa sêja ma sêjac miŋ gêdêŋ lau gebe “Parao kêsôm biŋ tonec gebe ‘Aê jakêŋ oba êndêŋ amac êtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Galoc amac taôm naajoŋ oba aŋga gamêŋ, taŋ atap oba saŋa naŋ. Mago nomku têkê-têkê, taŋ amac oc amansaŋ naŋ, ŋanamba êtu sauŋ atom, êtôm namba laŋgwa.’” ");
INSERT INTO jae_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Amboac tonaŋ lau sêsêlêŋ sêjam gamêŋ Aiguptu samucgeŋ auc, gebe sejoŋ oba êtu sêmansaŋ nomku têkê-têkêŋa. ");
INSERT INTO jae_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Lausêlêsuwaga sêkac êsêac ma sêsôm gebe “Anam nêm kôm êtôm bêcgeŋŋa e atap nomku têkê-têkê ŋanamba sa êtôm namba, taŋ atap sa gêdêŋ têm sêkêŋ oba gêdêŋ amacŋa naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Paraonê lausêlêsuwaga sêjac launêŋ gejobwaga, taŋ êsêac sêjaliŋ sa gebe sejop tauŋ nêŋ lau naŋ, ma têtu kênac êsêac gebe “Gêdêŋ ocsalô tonec amac atap kôm ŋanô sa kêtôm gêmuŋŋa atom, nec ŋam amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Go lau Israel nêŋ gejobwaga dêdêŋ Parao sêja ma têtaŋ gebe “Amboac ondoc aôm gôgôm aêac, taŋ atu nêm sakiŋwaga naŋ, amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Êsêac sêkêŋ oba teŋ gêdêŋ nêm sakiŋwaga atom, mago sêjatu gebe ‘Amansaŋ nomku têkê-têkê.’ Ma galoc ôlic, êsêac sêjac nêm sakiŋwaga gêwiŋ. Ŋakeso gêc aôm taôm nêm lauŋageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mago eŋ kêsôm gebe “Amac ojomtêna, amac ojomtêna. Kêtu tonaŋŋa amac asôm gebe ‘Ôwi aêac siŋ gebe akêŋ da êndêŋ Apômtau.’ ");
INSERT INTO jae_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Aêc su, anam nêm kôm. Ac sêkêŋ oba êndêŋ amac atom, mago amac amansaŋ nomku têkê-têkê ŋanamba êtôm gêmuŋŋa.” ");
INSERT INTO jae_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Lau Israel nêŋ gejobwaga sêmoa jageo ŋanô kêtu jatu tonecŋa gebe “Ajop taôm, gebe nomku têkê-têkê ŋanamba êtôm bêcgeŋŋa êtu sauŋ atom.” ");
INSERT INTO jae_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Gejobwaga sêsa aŋga Paraonê andu sêja ma têtap Mose agêc Aron sa. Êsêagêc sêôŋ êsêac sêmoa. ");
INSERT INTO jae_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ma gejobwaga sêsôm gêdêŋ êsêagêc gebe “Apômtau mata ê amagêc e êmêtôc amagêc, gebe amagêc agôm Parao to nê lau têntac gedec aêac ma akêŋ siŋ kêsêp êsêac lemeŋ, gebe sênac aêac êndu.” ");
INSERT INTO jae_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Go Mose kêkac tau ôkwi kêtiam gêmu gêdêŋ Apômtau gêja ma kêsôm gebe “O Apômtau, amboac ondoc tec gôgôm lau tonec sec. Aôm kôsakiŋ aê gamêŋ kêtu asageŋŋa. ");
INSERT INTO jae_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Aê kasô gadêŋ Parao gaja ma kasôm biŋ gajam aôm laŋôm, mago eŋ gêŋô e gêgôm lau tonec sec, ma aôm tec gôjam nêm lau kêsi atomanô.” ");
INSERT INTO jae_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mago Apômtau kêsôm gêdêŋ Mose gebe “Galoc aôm oc ôlic gêŋ, taŋ aê gabe jaŋgôm êndêŋ Parao naŋ. Eŋ oc êkac êsêac toŋaclaigeŋ gebe sêwi gamêŋ siŋ, ma êjanda êsêac toŋaclaigeŋ gebe sêwi ênê gamêŋ siŋ.” ");
INSERT INTO jae_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ma Anôtô kêsôm gêdêŋ Mose gebe “Aê Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aê gaoc tauc lasê gêdêŋ Abraham agêc Isak ma Jakob gebe Ŋaniniŋ Ŋatau aê, mago aê kawaka tauc sa gêdêŋ êsêac ŋa ŋoc ŋaê Aê-Gamoa-Amboac-Gamoa nec atom. ");
INSERT INTO jae_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Aê kamoatiŋ poac gêdêŋ êsêac gebe jakêŋ gamêŋ Kanaan êndêŋ êsêac. Gamêŋ tau, taŋ êsêac sêmoa têtôm lau jabageŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ma aê gaŋô lau Israel, taŋ lau Aiguptu sêlêsu êsêac ŋa kôm ŋawapac naŋ, nêŋ taŋiboa ma taêc gêjam ŋoc poac. ");
INSERT INTO jae_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kêtu tonaŋŋa ôsôm êndêŋ lau Israel gebe ‘Aê Apômtau tau. Aê gabe jaê amac sa aŋga Aiguptunêŋ kôm ŋawapac, taŋ kêkôniŋ amac naŋ, to jaŋgamboac amac su aŋga êsêacnêŋ sakiŋ gêŋômaŋa ma jamêtôc lemoc gebe janam amac sa to jaŋgôm gêŋsêga gebe jamêtôc êsêac. ");
INSERT INTO jae_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Aê gabe jakôc amac sa atu ŋoc lau ma gabe jatu nêm Anôtô. Amac ajalamaŋ gebe aê Apômtau, amacnêm Anôtô, taŋ gaê amac sa aŋga Aiguptunêŋ kôm ŋawapac. ");
INSERT INTO jae_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aê gabe jawê amac aô lasê gamêŋ, taŋ katôc lemoc gebe jakêŋ êndêŋ Abraham agêc Isak ma Jakob. Aê gabe jakêŋ gamêŋ tau êndêŋ amac êtu amacnêm nom. Aê Apômtau oc jaŋgôm.’” ");
INSERT INTO jae_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose kêsôm biŋ tonaŋ gêdêŋ lau Israel, mago êsêac sêkêŋ taŋeŋ Mosenê biŋ atom, gebe nêŋ ŋalêlôm popoc ma kôm tau ŋawapacgosu. ");
INSERT INTO jae_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ôsô naôsôm êndêŋ Aiguptunêŋ kiŋ Parao gebe êlôc ma lau Israel sêwi ênê gamêŋ siŋ.” ");
INSERT INTO jae_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mago Mose kêsôm gêdêŋ Apômtau gebe “Ôlic acgom, lau Israel sêkêŋ taŋeŋ ŋoc biŋ atom, ma Parao oc êkêŋ taŋa aê, taŋ aocsuŋ ŋawapac naŋ, amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Go Apômtau gêjam biŋgalôm gêwiŋ Mose agêc Aron ma kêjatu êsêagêc gebe sêsôm êndêŋ lau Israel to êndêŋ Aiguptunêŋ kiŋ Parao gebe agêc awê lau Israel sêwi gamêŋ Aiguptuŋa siŋ. ");
INSERT INTO jae_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Gêdêŋ bêc, taŋ Apômtau kêsôm biŋ gêdêŋ Mose aŋga gamêŋ Aiguptuŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Apômtau kêsôm gêdêŋ Mose gebe “Aê Apômtau tau. Ôsôm biŋ samob, taŋ aê jasôm êndêŋ aôm naŋ êndêŋ Aiguptunêŋ kiŋ Parao.” ");
INSERT INTO jae_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mago Mose kêsôm gêdêŋ Apômtau gebe “Ôlic acgom, aê aocsuŋ ŋawapac, tec Parao oc êkêŋ taŋa aê amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, aê jakêŋ aôm ôtu Paraonê anôtô ma têwam Aron êtu nêm propete. ");
INSERT INTO jae_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Aôm ôsôm biŋ samob, taŋ aê jajatu naŋ, êndêŋ Aron, ma eŋ êsôm êndêŋ Parao, gebe êlôc gebe lau Israel sêwi ênê gamêŋ siŋ sêc sêna. ");
INSERT INTO jae_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mago aê gabe jaŋgôm Paraonê ŋalêlôm ŋadani êsa. Aê oc jaŋgôm gêŋtalô to gêŋsêga taêsam aŋga gamêŋ Aiguptuŋa, ");
INSERT INTO jae_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","tageŋ Parao oc êkêŋ taŋa amagêcnêm biŋ atom. Go aê lemoc êpi Aiguptu ma ŋoc toŋ, ŋoc lau Israel tau tonaŋ, sêwi gamêŋ Aiguptuŋa siŋ, ma jaŋgôm gêŋsêga gebe jamêtôc lau Aiguptu. ");
INSERT INTO jae_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Aê embe jamêtôc lemoc gebe janac Aiguptu ma jawê lau Israel sa aŋga êsêac ŋalêlôm, go lau Aiguptu sêjala gebe aê Apômtau.” ");
INSERT INTO jae_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ma Mose agêc Aron taŋeŋ wamu ma sêgôm biŋ kêtôm Apômtau kêjatu êsêagêc. ");
INSERT INTO jae_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Gêdêŋ taŋ sêsôm biŋ gêdêŋ Parao naŋ, Mosenê jala kêtu 80 ma Aronnê kêtu 83. ");
INSERT INTO jae_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ma Apômtau kêsôm gêdêŋ Mose agêc Aron gebe ");
INSERT INTO jae_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Parao embe êsôm êndêŋ amagêc gebe ‘Awaka taôm sa ŋa gêŋtalô teŋ,’ go ôsôm êndêŋ Aron gebe ‘Ôkôc nêm tôc ma ômbaliŋ naênêc Parao laŋônêmŋa gebe êtu moac.’” ");
INSERT INTO jae_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Amboac tonaŋ Mose agêc Aron dêdêŋ Parao sêja ma sêgôm kêtôm Apômtau kêjatu êsêagêc. Aron kêbaliŋ nê tôc jagêc Parao to nê sakiŋwaga laŋôŋnêmŋa e tôc tau kêtu moac. ");
INSERT INTO jae_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Go Parao kêkalem lau tokauc ma lau mectomaŋŋa, ma Aiguptunêŋ lau mectomaŋŋa tonaŋ nêŋ ŋaclai kaiŋ teŋ, tec sêgôm gêŋtalô tônê amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Êsêac samob gêdêŋ-gêdêŋgeŋ sêbaliŋ nêŋ tôc jagêc nom e kêtu moac. Mago Aronnê tôc kêdaŋgôŋ êsêacnêŋ tôc samob su. ");
INSERT INTO jae_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mago Paraonê ŋalêlôm ŋadani ŋapaŋ, tec kêkêŋ taŋa êsêagêcnêŋ biŋ atom, kêtôm Apômtau kêsôm lasê kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Go Apômtau kêsôm gêdêŋ Mose gebe “Paraonê ŋalêlôm ŋadani kêsagac, eŋ gedec gebe êwi lau siŋ. ");
INSERT INTO jae_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bêbêcgeŋ Parao êsa bu êna, go aôm ôndêŋ eŋ ôna ma ônsaê eŋ ôkô butali. Ômêŋgôm tôc, taŋ gêjam tau ôkwi kêtu moac naŋ. ");
INSERT INTO jae_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Go ôsôm êndêŋ eŋ gebe ‘Apômtau, Ebolainêŋ Anôtô, kêsakiŋ aê gadêŋ aôm gamêŋ. Eŋ kêsôm gebe “Ôwi ŋoc lau siŋ sêna, gebe sênam sakiŋ aê aŋga gamêŋ sawa, mago ôlic acgom, aôm taŋam wamu atom tageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Apômtau kêsôm teŋ amboac tonec gebe “Ôlic acgom, aê janac bu, taŋ kêpoac bu Nil naŋ, ŋa tôc, taŋ kamêgôm naŋ, ma bu ênam tau ôkwi êtu dec. Biŋ tau êwaka aê sa e ôjala gebe aê Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ma i aŋga Nil oc sêmac êndu ma bu Nil tau ŋabu ŋasu êsa ma lau Aiguptu oc sendec bu ma sênôm atom.” ’” ");
INSERT INTO jae_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôsôm êndêŋ Aron gebe ‘Ôkôc nêm tôc ma ômêtôc lêmam êndêŋ bu Aiguptuŋa samob, êndêŋ bu, taŋ keseleŋ naŋ, to êndêŋ busawa ma bu ŋatoŋ to bu saboac, gebe bu samob ênam tau ôkwi êtu dec aŋga gamêŋ Aiguptuŋa samucgeŋ. Bu êtu dec aŋga suc to kupoc amboac tonaŋgeŋ.’” ");
INSERT INTO jae_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose agêc Aron sêgôm kêtôm Apômtau kêjatu. Aron gêôc tôc sa ma gi bu, taŋ kêpoac bu Nil naŋ, Parao to nê sakiŋwaga samob sêlic. Ma bu samob, taŋ kêpoac bu Nil naŋ, gêjam tau ôkwi kêtu dec. ");
INSERT INTO jae_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ma i, taŋ sêmoa bu Nil naŋ, sêmac êndu, ma bu Nil ŋasu kêsa e lau Aiguptu têtôm gebe sênôm bu aŋga bu Nil êtiam atom. Dec gêjam gamêŋ Aiguptuŋa samucgeŋ auc. ");
INSERT INTO jae_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mago lau mectomaŋ Aiguptuŋa sêgôm gêŋ tônê amboac tonaŋgeŋ ŋa nêŋ ŋaclai kaiŋ teŋ. Amboac tonaŋ Paraonê ŋalêlôm ŋadani gedeŋ tôŋgeŋ ma eŋ kêkêŋ taŋa êsêagêcnêŋ biŋ atom kêtôm Apômtau kêsôm kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Parao kêkac tau ôkwi kêsô nê andu gêja ma biŋ tonaŋ gêgôm nê ŋalêlôm ŋawapac kêsa atom. ");
INSERT INTO jae_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ma lau Aiguptu samob sêgawê bu sênômŋa sêmoa bu Nil ŋatali, gebe êsêac têtôm gebe sênôm bu Nil atom. ");
INSERT INTO jae_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Apômtau gi bu Nil ma gêŋwapac tau gêc bêc 7. ");
INSERT INTO jae_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôsô ôndêŋ Parao ôna ma ôsôm êndêŋ eŋ gebe ‘Apômtaunê biŋ tau tonec gebe “Ôwi ŋoc lau siŋ, gebe nasênam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mago embe ondec ma ôwi êsêac siŋ atom, go jakêŋ ôpoac sêlênsôŋ nêm gamêŋ samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ôpoac sênam bu Nil auc. Êsêac sêpi nêm andu ma sêsô nêm balêm bêcŋa ma sênêc nêm mê. Êsêac sêpi nêm sakiŋwaga to nêm lau samob nêŋ andu. Êsêac sêsô nêm ki apac polomŋa ŋalêlôm to sênêc nêm suc aŋgaluŋ polomŋa. ");
INSERT INTO jae_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ôpoac oc sêŋgalab sêpi aôm to sêpi nêm lau ma nêm sakiŋwaga samob.” ’” ");
INSERT INTO jae_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôsôm êndêŋ Aron gebe ‘Ômêtôc lêmam to nêm tôc êndêŋ bu to busawa ma bu ŋatoŋ ma ôkêŋ ôpoac sênam gamêŋ Aiguptuŋa auc.’” ");
INSERT INTO jae_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Amboac tonaŋ Aron kêmêtôc lêma gêdêŋ Aiguptu ŋabu samob ma ôpoac sêpi e sêjam gamêŋ Aiguptuŋa auc. ");
INSERT INTO jae_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mago lau mectomaŋŋa sêgôm gêŋ tônê ŋa nêŋ ŋaclai kaiŋ teŋ ma sêkêŋ ôpoac sêpi gamêŋ Aiguptuŋa sêmêŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Go Parao kêkalem Mose agêc Aron ma kêsôm gebe “Ateŋ Apômtau gebe êkôc ôpoac su aŋga aê to ŋoc lau ma jawi lau siŋ nasêkêŋ da êndêŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose kêsôm gêdêŋ Parao gebe “Aê jateŋ aôm gebe taôm ôsam bêc ôpoac sêwi aôm to nêm andu samob siŋŋa, go jateŋ êtu aôm to nêm sakiŋwaga ma nêm lauŋa. Ma ôpoac oc sêmoa bu Nil tageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ma Parao kêsôm gebe “Eleŋŋa.” Mose kêsôm gebe “Biŋ, taŋ aôm kôsôm naŋ, oc ŋanô êsa, ec ôjala gebe ŋac teŋ kêtôm Apômtau, aêacma Anôtô, gêmoa atomanô. ");
INSERT INTO jae_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ôpoac oc sêwi aôm to nêm andu ma nêm sakiŋwaga to nêm lau samob siŋ. Êsêac oc sêmoa bu Nil tageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Go Mose agêc Aron sêwi Parao siŋ, ma Mose awa gêjac Apômtau kêtu ôpoacŋa, kêtôm taŋ eŋ kêmasaŋ biŋ gêwiŋ Parao naŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ma Apômtau gêgôm kêtôm Mosenê biŋ. Ôpoac sêmac êndu aŋga andu to malacluŋ ma kôm. ");
INSERT INTO jae_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ma êsêac sêboa ôpoac sa totoŋ-totoŋ e ŋasu kêpôŋ popoc gêjam gamêŋ samucgeŋ auc. ");
INSERT INTO jae_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mago gêdêŋ taŋ Parao kêsaê gebe gêŋwapac kêlêwaŋ eŋ naŋ, eŋ gêgôm nê ŋalêlôm ŋadani kêsa e kêkêŋ taŋa êsêagêcnêŋ biŋ atom kêtôm Apômtau kêsôm kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôsôm êndêŋ Aron gebe ‘Ômêtôc nêm tôc ma ôi nom ŋakekop e êtu kawaŋ ênam gamêŋ Aiguptuŋa samucgeŋ auc.’” ");
INSERT INTO jae_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ma êsêagêc sêgôm amboac tonaŋ. Aron kêmêtôc lêma tonê tôc ma gi nom ŋakekop, ma kawaŋ kêpi e gêŋac ŋamalac to bôc. Nom ŋakekop samucgeŋ kêtu kawaŋ gêjam gamêŋ Aiguptuŋa auc samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Lau mectomaŋŋa sêsaê gebe sêkêŋ kawaŋ amboac tonaŋ ŋa nêŋ ŋaclai kaiŋ teŋ, mago sêgôm têtôm atom. Amboac tonaŋ kawaŋ gêjac têc ŋamalac to bôc auc. ");
INSERT INTO jae_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ma lau mectomaŋŋa sêsôm gêdêŋ Parao gebe “Anôtônê lêma ŋakôm tonec.” Mago Paraonê ŋalêlôm ŋadani kêsa e kêkêŋ taŋa êsêagêcnêŋ biŋ atom kêtôm Apômtau kêsôm kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôndi sa êndêŋ bêbêc kanucgeŋ ma ônsaê Parao êsa bu êna, go êsôm êndêŋ eŋ gebe ‘Apômtaunê biŋ tau tonec gebe “Ôwi ŋoc lau siŋ, gebe nasênam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ôlic acgom, embe ôwi ŋoc lau siŋ atom, go jasakiŋ daŋguc êpi aôm to nêm sakiŋwaga ma nêm lau ma êsô nêm andu amboac tonaŋ. Ma daŋguc tolêsôb-tolêsôb ênam lau Aiguptu nêŋ andu auc ma ênac têc nom, taŋ ŋamalac sêmoa naŋ, auc amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Êndêŋ bêc tonaŋ aê jaŋgôm gamêŋ Gosen amboac teŋ. Ŋoc lau sêmoa gamêŋ tonaŋ, tec daŋguc teŋ êmoa atom e ôjala gebe aê Apômtau gamoa gamêŋ tau ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Amboac tonaŋ aê jawa ŋoc lau to nêm lau êkôc. Biŋ tonaŋ êsa êndêŋ eleŋŋa.” ’” ");
INSERT INTO jae_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ma Apômtau gêgôm biŋ tonaŋ ŋanô kêsa. Daŋguc tolêsôb-tolêsôb kêsô Parao to nê sakiŋwaga nêŋ andu. Ma gamêŋ Aiguptuŋa samucgeŋ kêtap daŋguc ŋagêŋwapac sa. ");
INSERT INTO jae_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Go Parao kêkalem Mose agêc Aron ma kêsôm gebe “Ajôc, akêŋ da êndêŋ nêm Anôtô aŋga gamêŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mago Mose kêsôm gebe “Biŋ amboac tonaŋ oc êtôm atom, gebe gêŋ, taŋ aêac oc akêŋ êtu da êndêŋ Apômtau, aêacma Anôtô, naŋ, lau Aiguptu sêlic amboac gêŋ alôb-alôb. Ma aêac embe akêŋ gêŋ, taŋ lau Aiguptu sêlic amboac gêŋ alôb-alôb naŋ, êtu da êsêac sêlic, oc têtuc aêac ŋa poc êndu atom me. ");
INSERT INTO jae_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Aêac asêlêŋ êtôm bêc têlêac asa gamêŋ sawa ana, go akêŋ da êndêŋ Apômtau, aêacma Anôtô, êtôm eŋ tau kêjatu aêac naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tec Parao kêsôm gebe “Aê jawi amac siŋ naakêŋ da êndêŋ Apômtau, amacnêm Anôtô, aŋga gamêŋ sawa. Tageŋ amac ana jaêcgeŋ atom. Awem ênac Apômtau êtu aêŋa.” ");
INSERT INTO jae_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Go Mose kêsôm gebe “Ôlic acgom, aê jawi aôm siŋ jasa najateŋ mec êndêŋ Apômtau gebe eleŋŋa daŋguc tolêsôb-tolêsôb êwi Parao to nê sakiŋwaga ma nê lau siŋ. Tageŋ aôm ônsau aêac êtiam atom ma ôŋgamiŋ lau gebe sêkêŋ da êndêŋ Apômtau nec atom.” ");
INSERT INTO jae_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ma Mose kêsa aŋga Paraonê jaketeŋ mec gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ma Apômtau gêgôm biŋ, taŋ Mose keteŋ naŋ, ŋanô kêsa ma kêkôc daŋguc tolêsôb-tolêsôb su aŋga Parao to nê sakiŋwaga ma nê lau nêŋ. Daŋguc teŋ gêmoa kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mago Parao gêgôm nê ŋalêlôm ŋadani kêsa kêtiam ma gêwi lau siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôsô ôndêŋ Parao ôna ma ôsôm êndêŋ eŋ gebe ‘Apômtau, Ebolainêŋ Anôtô, nê biŋ tau tonec gebe “Ôwi ŋoc lau siŋ, gebe nasênam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ôlic acgom aôm embe ondec gebe ôwi êsêac siŋ ma ôkôc êsêac tôŋ ŋapaŋ, ");
INSERT INTO jae_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","go Apômtau lêma ênac aômnêm bôc, taŋ sêmoa kôm naŋ, hos to doŋki ma kamele to bulimakao ma domba. Samob têtap gêmac sec kaiŋ teŋ sa. ");
INSERT INTO jae_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ma Apômtau êwa lau Israel to Aiguptu nêŋ bôc êkêc, ma lau Israel nêŋ bôc teŋ êmac êndu atom.” ’” ");
INSERT INTO jae_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ma Apômtau kêkêŋ noc ma kêsôm gebe “Eleŋŋa Apômtau gebe êŋgôm biŋ tau ŋanô êsa aŋga gamêŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ma geleŋŋa Apômtau gêgôm gêŋ tau. Lau Aiguptu nêŋ bôc samob sêmac êndu, mago lau Israel nêŋ bôc teŋ gêmac êndu atom. ");
INSERT INTO jae_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ma Parao kêsakiŋ lau gebe sênac lau Israel nêŋ bôc kêsi ma êsêac sêlic gebe nêŋ bôc teŋ gêmac êndu atom. Mago Paraonê ŋalêlôm ŋadani kêsa ma gêwi lau siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ma Apômtau kêsôm gêdêŋ Mose agêc Aron gebe “Akôc ŋagasi aŋga ki ano gêŋŋa êsêp amagêc lemem ma Mose êpalip gêŋ tau êpi umboŋ ma Parao êlic. ");
INSERT INTO jae_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ŋagasi tau oc ênam tau ôkwi êtu kekop ênam gamêŋ Aiguptuŋa samucgeŋ auc e êŋgôm kamocmatu ênam ŋamalac to bôc nêŋ ôliŋ auc aŋga gamêŋ Aiguptuŋa samucgeŋ, ma kamocmatu tau êu lasê e êtu kamoc.” ");
INSERT INTO jae_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Amboac tonaŋ êsêagêc sêkôc ŋagasi tau ma sêkô Parao laŋônêmŋa. Ma Mose kêpalip kêpi umboŋ e ŋamalac to bôc têtap kamocmatu sa, tec kamocmatu tau gêu lasê e kêtu kamoc. ");
INSERT INTO jae_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Lau mectomaŋŋa têtôm gebe sêkô Mose laŋônêmŋa atom, gebe kamocmatu gêjam êsêac auc kêtôm gêjam lau Aiguptu ŋagêdô samob auc. ");
INSERT INTO jae_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mago Apômtau gêgôm Paraonê ŋalêlôm ŋadani kêsa e kêkêŋ taŋa êsêagêcnêŋ biŋ atom kêtôm Apômtau kêsôm gêdêŋ Mose kwanaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôndi êndêŋ eleŋ bêbêc kanucgeŋ ma ôkô Parao laŋônêmŋa ma ôsôm êndêŋ eŋ gebe ‘Apômtau, Ebolainêŋ Anôtô, nê biŋ tau tonec gebe “Ôwi ŋoc lau siŋ gebe nasênam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Gebe galoc aê oc jasakiŋ ŋoc gêŋwapac samob êkôniŋ nêm ŋalêlôm to nêm sakiŋwaga ma nêm lau e ôjala, gebe ŋac teŋ kêtôm aê gêmoa nom atomanô. ");
INSERT INTO jae_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wanêcgeŋ aê embe jaôc lemoc sa ma janac aôm to nêm lau ŋa gêmac sec, oc galoc amac anaŋa aŋga nom su. ");
INSERT INTO jae_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mago aê gaseŋ aôm su atom, gebe jatôc ŋoc ŋaclai êndêŋ aôm ma jaŋgôm ŋoc ŋaê ŋawae êsa êtu tapa aŋga nom samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Aôm kotoc taôm sa gêdêŋ ŋoc lau ŋapaŋ ma gôwi êsêac siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ôlic acgom, eleŋŋa ŋaockatu amboac tonec aê jakêŋ kompoc ênac kapôêŋanô. Gêdêŋ têm, taŋ Aiguptu kêsa e mêŋgêdêŋ galoc kompoc amboac tonaŋ gêjac kêsêp Aiguptu atomanô. ");
INSERT INTO jae_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Amboac tonaŋ ôsakiŋ ŋawae gebe nêm bôc samob to gêŋ samob, taŋ gêmoa kôm naŋ, sêlamu gadê teŋ, gebe kompoc oc ênac ŋamalac to bôc samob, taŋ sêmoa kôm ma nêŋ gadê masi naŋ, sêmac êndu.” ’” ");
INSERT INTO jae_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Go Paraonê sakiŋwaga ŋagêdô, taŋ têtêc Apômtaunê biŋ naŋ, sêkêŋ nêŋ gêŋôma to nêŋ bôc sêc jasêlamu nêŋ andu. ");
INSERT INTO jae_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mago êsêac, taŋ Apômtaunê biŋ kepeŋ nêŋ ŋalêlôm atom naŋ, dedec nêŋ gêŋôma to nêŋ bôc gacgeŋ sêmoa kôm. ");
INSERT INTO jae_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ômêtôc lêmam êndêŋ undambê gebe kompoc ênac êpi ŋamalac to bôc ma gêŋ kômŋa aŋga gamêŋ Aiguptuŋa samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Go Mose kêmêtôc lêma totôc gêdêŋ undambê, ma Apômtau kêkêŋ wapap to kompoc gêjac ma ôsic kêkac kêsêp nom gêmêŋ. Ma Apômtau kêkêŋ kompoc gêjac gamêŋ Aiguptuŋa. ");
INSERT INTO jae_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Kompoc gêjac ma ôsic kêkac gê tôŋgeŋ kêsêp kompoc ŋalêlôm. Gêdêŋ têm samob, taŋ ŋamalac Aiguptuŋa sêbiŋ tauŋ tôŋ têtu lau-m kapôêŋ naŋ, kompoc kapôêŋanô amboac tonaŋ gêjac atomanô. ");
INSERT INTO jae_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kompoc kêtuc gêŋ samob, taŋ gêmoa kôm naŋ, aŋga gamêŋ Aiguptuŋa samucgeŋ. Gêjac ŋamalac to bôc kêtômgeŋ ma gêjac gêŋ kômŋa samob to kêtuc ka samob, taŋ kêkô kôm naŋ, tulu. ");
INSERT INTO jae_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gamêŋ Gosen tageŋ, taŋ lau Israel sêŋgôŋ naŋ, tec kompoc kêsêp atom. ");
INSERT INTO jae_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Go Parao kêsakiŋ biŋ gêdêŋ Mose agêc Aron gebe sêmêŋ ma kêsôm gêdêŋ êsêagêc gebe “Aê gagôm sec gêdêŋ ŋasawa tonec. Apômtau eŋ ŋac gêdêŋ ma aê to ŋoc lau agôm gêŋ keso. ");
INSERT INTO jae_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ateŋ Apômtau gebe wapap to kompoc êmbacnê, gêjac kêtômgac. Aê gabe jawi amac siŋ ana, amac oc amoa tonec baliŋanô atom.” ");
INSERT INTO jae_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose kêsôm gêdêŋ eŋ gebe “Êndêŋ taŋ jawi malac siŋ su, go jalam lemoc êndêŋ Apômtau, ma wapap êmbacnê ma kompoc ênac êtiam atom, ec ôjala gebe Apômtau kêtu nom ŋatau. ");
INSERT INTO jae_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mago aê kajala gebe aôm to nêm sakiŋwaga atêc Apômtau Anôtô atom tageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Kompoc geseŋ gêŋ kômŋa, taŋ kêtu gagweŋ naŋ su, ");
INSERT INTO jae_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","gêŋ kômŋa ŋagêdô, taŋ kêpoa atom tageŋ naŋ, gêjaŋa atom.) ");
INSERT INTO jae_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Amboac tonaŋ Mose kêsa aŋga Paraonê jagêwi malac siŋ ma gêlam lêma gêdêŋ Apômtau, tec wapap to kompoc gêbacnê, ma kom kêsêwa kêsêp nom kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Gêdêŋ taŋ Parao gêlic gebe kom to kompoc ma wapap gêbacnê naŋ, eŋ gêgôm sec kêtiam ma eŋ tau to nê sakiŋwaga sêgôm nêŋ ŋalêlôm ŋadani kêsa. ");
INSERT INTO jae_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Amboac tonaŋ Paraonê ŋalêlôm ŋadani ma gêwi lau Israel siŋ atom kêtôm Mose kêsôm kwanaŋgeŋ gêjam Apômtau awa. ");
INSERT INTO jae_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Su, go Apômtau kêsôm gêdêŋ Mose gebe “Ôsô ôndêŋ Parao ôna gebe aê gagôm eŋ to nê sakiŋwaga nêŋ ŋalêlôm ŋadani kêsa gebe jatôc ŋoc gêŋtalô tonec ŋai êndêŋ êsêac ");
INSERT INTO jae_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ma gagôm gêŋ tau gebe aôm ônac miŋ êndêŋ latômi ma dêbômi sêŋô aê gagôm lau Aiguptu têtu meloc to gagôm gêŋsêga kaiŋ teŋ aŋga êsêacnêŋ gebe amac ajala gebe aê Apômtau tau.” ");
INSERT INTO jae_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Amboac tonaŋ Mose agêc Aron sêsô dêdêŋ Parao sêja ma sêsôm gêdêŋ eŋ gebe “Apômtau, Ebolainêŋ Anôtô, nê biŋ tau tonec gebe ‘Aôm gobe ônac jao taôm e êndêŋ ondocgeŋ, go ômbu taôm êndêŋ aê. Ôwi ŋoc lau siŋ gebe nasênam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ôlic acgom, aôm embe ondec ma ôwi ŋoc lau siŋ atom, go eleŋŋa aê jakêŋ wagô êsa nêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Gêŋ tau ênac têc nom auc e talic nom sapu. Wagô êniŋ gêŋ, taŋ kompoc geseŋ su atom naŋ, to êniŋ nêm ka samob, taŋ kêkô kôm naŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gêŋ tau êpi aôm to nêm sakiŋwaga ma lau Aiguptu samob nêŋ andu e êlôc. Gêdêŋ têm, taŋ tamami to dêbômi sêŋgôŋ gamêŋ tonec e mêŋgêdêŋ galoc êsêac sêlic gêŋ amboac tonaŋ teŋ atomanô.’” Go Mose kêkac tau ôkwi ma kêsa gêja. ");
INSERT INTO jae_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ma Paraonê sakiŋwaga sêsôm gêdêŋ eŋ gebe “Ŋac tonec êtu aêac tamoa jageo ŋamôkê e endeŋ ondocgeŋ. Ôwi lau tau siŋmaŋ nasênam sakiŋ Apômtau, êsêacnêŋ Anôtô. Aiguptu gêjaŋa nec aômnêm kauc kêsa atom me.” ");
INSERT INTO jae_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Amboac tonaŋ êsêac sêkôc Mose agêc Aron sêmu dêdêŋ Parao sêja, ma Parao kêsôm gêdêŋ êsêagêc gebe “Ana anam sakiŋ Apômtau, amacnêm Anôtômaŋ. Mago asa lau oc sêna.” ");
INSERT INTO jae_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ma Mose kêsôm gebe “Aêac oc ana toma lau wakuc ma lau ŋanô, toma latuŋio to ŋac ma toma bulimakao to domba, gebe aêac alic Apômtaunê om.” ");
INSERT INTO jae_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Parao kêsôm gêdêŋ êsêagêc gebe “Apômtau êwiŋ amacmaŋ, mago aê jawi amac tonêm lauo ma nêm gôlôac ŋasec-ŋasec siŋ atom. Biŋ tonec gêc awê, gebe amac taêm gêjam biŋ sec gêc nêm ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Masianô. Amac ŋacwaga taômgeŋ ana ma anam sakiŋ Apômtau, gebe biŋ tonec tec abe aŋgôm.” Ma sesoc êsêagêc sêsa aŋga Parao sêja. ");
INSERT INTO jae_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Go Apômtau kêsôm gêdêŋ Mose gebe “Ômêtôc lêmam êpi gamêŋ Aiguptuŋa gebe wagô êsa gamêŋ Aiguptuŋa êmêŋ ma êniŋ gêŋ tolauŋ samob, taŋ kompoc geseŋ su atom naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Amboac tonaŋ Mose kêmêtôc nê tôc kêpi gamêŋ Aiguptuŋa ma Apômtau kêkêŋ mu kêsêlêŋ aŋga gamêŋ oc kêpiŋa kêsa gamêŋ tau gêdêŋ oc samuc tonaŋ ma gêbêc samuc tonaŋ. Ma ŋageleŋ mu tau kejoŋ wagô gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ma wagô gêjam nom Aiguptuŋa auc samucgeŋ ma gêjac têc gamêŋ Aiguptuŋa auc samucgeŋ. Lau teŋ sêlic wagô totoŋ-totoŋ amboac tonaŋ su atomanô me oc sêlic teŋ êtiam atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Gêŋ tau gêjac têc nom auc samucgeŋ e jecôma ma geŋ gamêŋ ŋagêŋ matac samob to kaŋanô, taŋ kompoc geseŋ su atom naŋ, e gêbacnê Ka to gêŋ kômŋa aŋga gamêŋ Aiguptuŋa ŋalauŋ gêjaŋa samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Go Parao kêkalem Mose agêc Aron kêkacgeŋ ma kêsôm gebe “Aê gagôm sec gêdêŋ Apômtau, amacnêm Anôtô, ma gêdêŋ amagêc. ");
INSERT INTO jae_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tec galoc gabe jateŋ amagêc gebe asuc ŋoc sec ôkwi tageŋ tecenec êwiŋ, gebe ateŋ Apômtau, amacnêm Anôtô, ma êkôc gêŋwapac tonec su aŋga aê, gebe janaŋa atom.” ");
INSERT INTO jae_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Go Mose kêsa aŋga Paraonê jaketeŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ma Apômtau gêjam mu ôkwi e kêsêlêŋ kapôêŋ kêsa aŋga gamêŋ oc kêsêpŋa. Mu tonaŋ kejoŋ wagô sa ma kêbaliŋ kêsêp Gwêckoc gêja e wagô teŋ gêmoa gamêŋ Aiguptuŋa kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mago Apômtau gêgôm Paraonê ŋalêlôm ŋadani kêsa ma eŋ gêwi lau Israel siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Go Apômtau kêsôm gêdêŋ Mose gebe” Ômêtôc lêmam êpi umboŋ gebe gêsuŋbôm êkôm gamêŋ Aiguptuŋa auc e lau têtôm gebe sêmoasac gêsuŋbôm tau.” ");
INSERT INTO jae_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ma Mose kêmêtôc lêma kêpi umboŋ e gêsuŋbôm ŋadani sec kêkôm gamêŋ Aiguptuŋa samucgeŋ auc kêtôm bêc têlêac. ");
INSERT INTO jae_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Lau Aiguptu sêlic tauŋ sapu ma dêdi aŋga maleŋ atom kêtôm bêc têlêac. Mago lau Israel samob têtap ŋawê sa aŋga nêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Go Parao kêkalem Mose ma kêsôm gebe “Anam sakiŋ Apômtau. Nêm ŋapalêo to ŋac sêwiŋ amac, tageŋ nêm bulimakao to domba gacgeŋ sêmoa tonec.” ");
INSERT INTO jae_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mago Mose kêsôm gebe “Amboac tonaŋ aôm taôm ôkêŋ bôc gebe akêŋ êtu da to daja êndêŋ Apômtau, aêacma Anôtô. ");
INSERT INTO jae_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Aêacma bulimakao samob sêwiŋ aêacmaŋ, ŋateŋ êmoa tonec atom, gebe aêac ajaliŋ ŋagêdô sa êtu anam sakiŋ Apômtau, aêacma Anôtôŋa. Aêac ajam kauc anam sakiŋ Apômtau ŋa gêŋ ondoc. Aêac aô lasê gamêŋ tau su acgom, go ajala.” ");
INSERT INTO jae_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma Apômtau gêgôm Paraonê ŋalêlôm ŋadani kêsa ma eŋ gêwi êsêac siŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Go Parao kêsôm gêdêŋ Mose gebe “Ôêc su. Ôlic taôm gebe ôlic aê laŋôcanô êtiam atom. Êndêŋ bêc ôlic aê laŋôcanô êtiamŋa, aôm oc ômac êndu.” ");
INSERT INTO jae_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose kêsôm gebe” Aôm kôsômgac. Aê oc jalic aôm laŋômanô êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe “Aê gabe jakêŋ gêŋwapac tageŋgeŋ êwiŋ êkôniŋ Parao to Aiguptu. Tonec êmbacnê, go êwi amac siŋ. Embe êwi amac siŋ, go êjanda amac aêc gacgeŋ ana. ");
INSERT INTO jae_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Galoc ôsôm êndêŋ nêm lau gebe ŋacwaga samob teteŋ nêŋ lau sacgêdô gêdêŋ tauŋŋa to lauo samob teteŋ nêŋ lauo sacgêdô gêdêŋ tauŋŋa gebe sêkêŋ gêlôŋ silber to gold êndêŋ êsêac.” ");
INSERT INTO jae_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ma Apômtau gêgôm lau Aiguptu sêlic lau Israel ŋajam. Ma Mose tau amboac tonaŋ. Paraonê sakiŋwaga to lau tau sêlic eŋ amboac ŋac towae kapôêŋ aŋga gamêŋ Aiguptuŋa. ");
INSERT INTO jae_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ma Mose kêsôm gebe “Apômtaunê biŋ tau tonec gebe Êndêŋ êmbêc êna lugeŋ, go aê jasêlêŋ janac laoc gamêŋ Aiguptuŋa. ");
INSERT INTO jae_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ma gamêŋ Aiguptuŋa ŋagêŋ ŋamêc samob sêmac êndu. Janac m aŋga Paraonê ŋacsêga, taŋ oc êŋgôŋ Paraonê lêpôŋ kiŋŋa naŋ, e êndêŋ sakiŋwagao, taŋ kêlêsa polom popoc naŋ, nê ŋacsêga. Ma bôc ŋamêc samob sêmac êndu amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Lau oc têtaŋ taŋiboa kapôêŋanô amboac têtaŋ gêmuŋŋa atom ma oc têtaŋ êtiam amboac tonec atomanô. ");
INSERT INTO jae_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mago lau Israel amboac teŋ. Kêam teŋ oc êkêŋ Iêsu ŋamalac to bôc atom, gebe ajala Apômtau gêwa lau Aiguptu to lau Israel kêkôc. ");
INSERT INTO jae_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Go nêm sakiŋwaga samob tonaŋ sêsêp sêndêŋ aê sêmêŋ ma sewec êndêŋ aê ma sêsôm gebe ‘Ôkôc taôm sa ma nêm lau samob sêndaŋguc aôm.’ Su, go jawi gamêŋ siŋ.” Ma Mose kêsa aŋga Paraonê totêtac ŋandaŋ kapôêŋgeŋ gêja. ");
INSERT INTO jae_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Go Apômtau kêsôm gêdêŋ Mose gebe “Parao oc êkêŋ taŋa aômnêm biŋ atom e aêŋoc gêŋtalô êtu taêsam aŋga gamêŋ Aiguptu acgom.” ");
INSERT INTO jae_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose agêc Aron sêgôm gêŋtalô samob tonaŋ ŋai sêkô Parao laŋônêmŋa. Ma Apômtau gêgôm Paraonê ŋalêlôm ŋadani kêsa ma gêwi lau Israel siŋ aŋga nê gamêŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ma Apômtau kêsôm gêdêŋ Mose agêc Aron aŋga gamêŋ Aiguptuŋa gebe ");
INSERT INTO jae_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ajôŋ tonec êtu nêm ajôŋ samob ŋamata. Amac anac m nêm Jala ŋa ajôŋ ŋamata tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Asôm êndêŋ Israelnêŋ gôlôac gebe Êndêŋ ajôŋ tonec ŋabêc 10 ŋacwaga samob sêkôc domba ŋalatu tageŋ-tageŋ êtôm nêŋ gôlôacmôkêgeŋ, sêkôc domba tageŋ-tageŋ êtôm andugeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ma lau andu teŋŋa embe nêŋ toŋ sauŋ, naŋ têtôm gebe sêniŋ domba ŋalatu teŋ e êmbacnê atom, go êsêac to lau, taŋ sêŋgôŋ mêŋbaŋ tauŋ naŋ, sêpi tageŋ, ec têtôm gebe sêniŋ domba ŋalatu tau. Lau tau nêŋ namba êtôm gebe sêniŋ domba ŋalatu teŋ e êmbacnê. ");
INSERT INTO jae_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Aômnêm domba ŋalatu tau ŋageo teŋ ênêc atomanô. Ôkôc kapoac teŋ ŋajala tageŋ. Ôkôc domba me noniŋ ŋalatu teŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ajop bôc ŋalatu tau e êndêŋ ajôŋ tonec ŋabêc 14. Êndêŋ ŋabêc tonaŋ ŋaêtula Israelnêŋ gôlôac samob sêmbuc nêŋ domba ŋalatu êtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Go sêkôc ŋadec ŋagêdô nasênsê êpi andu, taŋ sêŋgôŋ ma sêniŋ gêŋ naŋ, ŋasagiŋtêkwa sacgêdôŋa to kagêbôc. ");
INSERT INTO jae_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Êsêac sêpac domba ma sêniŋ êndêŋ êmbêc tonaŋ êwiŋ polom ŋaluc to gêŋgaga ŋamakic. ");
INSERT INTO jae_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Aniŋ bôc tau matac atom ma ano êsêp ku, go aniŋ atom amboac tonaŋgeŋ. Apacgeŋ ma aniŋ. Apac samucgeŋ, ŋamôkê to ŋaakaiŋ ma ŋatê. ");
INSERT INTO jae_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ma andec ŋapopoc ênêc e eleŋŋa lasê atom. Ŋagêdô embe ênêc, go akêŋ ja êniŋ su. ");
INSERT INTO jae_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Aniŋ gêŋ tau ŋalêŋ amboac tonec gebe Ajandiŋ nêm ômbiŋkap to asô atapa ma amêŋgôm tôc ma aniŋ gêŋ ŋagaôgeŋ. Moasiŋ tonaŋ kêtu Apômtaunê Pasa. ");
INSERT INTO jae_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Êndêŋ êmbêc tonaŋ aê jasêlêŋ janac laoc gamêŋ Aiguptuŋa ma janac gêŋ ŋamêc samob êndu, ŋamalac ma bôc. Ma aê jamêtôc Aiguptunêŋ anôtôi samob. Aê Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Dec, taŋ ansê êpi nêm andu naŋ, êtu amacnêm ŋabelo. Embe jalic, oc jaôc lêlêc amac. Êndêŋ taŋ janac Aiguptu naŋ, gêŋwapac teŋ êpi amac to enseŋ amac su atom. ");
INSERT INTO jae_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Bêc tonaŋ êtu amacnêm bêc taêm ênamŋa ma amac alic bêc tau amboac Apômtaunê om teŋ. Biŋ tonaŋ êtu amacnêm gôlôac to nêŋ gôlôac nêŋ ŋagôliŋ teŋ ênêc endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Amac aniŋ polom ŋaluc êtôm bêc 7. Êndêŋ bêc ŋamataŋa amac akôc jist su aŋga nêm andu, gebe ŋac teŋ embe êniŋ polom tojist êndêŋ bêc ŋamataŋa to bêc êtu 7ŋa ŋasawa, naŋ têtiŋ eŋ su aŋga Israelnêŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Êndêŋ bêc ŋamataŋa gôlôac dabuŋ sêkac sa. Ma êndêŋ bêc êtu 7ŋa gôlôac dabuŋ sêkac sa êtiam. Êndêŋ bêc tonaŋ lau teŋ sênam kôm atom, kôm amansaŋ gêŋ aniŋŋaŋa tageŋ, tec êtôm gebe anam. ");
INSERT INTO jae_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ma amac matem êndiŋ Om Polom Ŋalucŋa ŋapep, gebe êndêŋ bêc tonaŋgeŋ aê jawê amacnêm toŋ samob sêwi Aiguptu siŋ, tec amacnêm gôlôac to nêŋ gôlôac mateŋ êndiŋ bêc tonaŋ êtu nêm om. Biŋ tonaŋ êtu ŋagôliŋ teŋgeŋŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Êndêŋ ajôŋ ŋamataŋa ŋabêc 14 ŋaêtula amac aniŋ polom ŋaluc ŋapaŋ e êndêŋ ajôŋ tonaŋ ŋabêc 21 ŋaêtula. ");
INSERT INTO jae_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Êndêŋ bêc 7 tonaŋ jist ŋagec ênêc amacnêm andu atom. Ŋac jaba teŋ me Israel tauŋ nêŋ ŋac teŋ embe êniŋ polom tojist, naŋ têtiŋ eŋ su aŋga Israelnêŋ gôlôac. ");
INSERT INTO jae_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Aniŋ gêŋ tojist teŋ atom, aniŋ polom ŋalucgeŋ aŋga nêm andu samob.” ");
INSERT INTO jae_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Go Mose kêkalem Israelnêŋ laumata samob ma kêsôm gêdêŋ êsêac gebe “Ajaliŋ domba ŋalatu sa êtôm nêm gôlôacgeŋ ma ambuc domba Pasaŋa. ");
INSERT INTO jae_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Akôc sôbolec ôndôc teŋ ma asac tôŋ êsêp dec, taŋ êpoac laclu naŋ, go ansê ŋadec êpi kagêbôc to sagiŋtêkwa sacgêdôŋa. Amacnêm teŋ êsa nê andu ŋasacgêdô êna atom e eleŋŋa lasê. ");
INSERT INTO jae_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Gebe Apômtau êsêlêŋ ênac laoc gamêŋ gebe ênac Aiguptu. Embe êlic dec aŋga kagêbôc to sagiŋtêkwa sacgêdôŋa, go êôc lêlêc sacgêdô tonaŋ ma êkô aŋela siŋŋa auc gebe êsô nêm andu êna ma ênac amac atom. ");
INSERT INTO jae_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Sakiŋ tonaŋ amac matem êndiŋ êtu ŋagôliŋ teŋgeŋŋa teŋ êndêŋ amac to nêm gôlôac wakuc. ");
INSERT INTO jae_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ma amac embe aô lasê gamêŋ, taŋ Apômtau gebe êkêŋ êndêŋ amac amboac gêjac mata su naŋ, go ajop sakiŋ dabuŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ma amacnêm gôlôac embe têtu kênac amac gebe ‘Sakiŋ dabuŋ tau ŋam amboac ondoc,’ ");
INSERT INTO jae_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","go asôm êndêŋ êsêac gebe ‘Pasa ŋada, taŋ akêŋ êndêŋ Apômtau naŋ tonec. Da tau ŋam gebe Eŋ gêôc lêlêc lau Israel nêŋ andu aŋga Aiguptu. Gêdêŋ taŋ gêjac Aiguptu naŋ, eŋ gêjam aêacnêŋ andu kêsi.’” Ma lau sewec to teteŋ mec gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Go lau Israel sêja ma sêgôm biŋ, taŋ Apômtau kêjatu gêdêŋ Mose agêc Aron naŋ, ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gêdêŋ gêbêcauc gêja lu Apômtau gêjac launêŋ ŋacsêga samob êndu aŋga gamêŋ Aiguptuŋa. Eŋ gêjac Paraonê ŋacsêga, taŋ êwê kaiŋ ênê lêpôŋ kiŋŋa to ŋac kapoacwalôŋa, taŋ gêŋgôŋ gêsuŋ kapoacwalôŋa naŋ, nê ŋacsêga ma bôc ŋamêc samob. ");
INSERT INTO jae_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ma Parao to nê sakiŋwaga ma lau Aiguptu samob dêdi sa gêdêŋ gêbêc ma taŋiboa kapôêŋ kêpi aŋga Aiguptu gebe ŋacmatê sêc kêtôm andu samobgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ma gêdêŋ gêbêc tonaŋgeŋ Parao kêkalem Mose agêc Aron ma kêsôm gêdêŋ êsêagêc gebe “Andi ma aêc ana. Amagêc to lau Israel awi ŋoc lau siŋ. Aêc su naanam sakiŋ Apômtau amboac asôm. ");
INSERT INTO jae_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Akôc nêm domba to bulimakao sêwiŋ amac êtôm asôm ma ana. Ma ateŋ Apômtau gebe ênam mec aê amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Lau Aiguptu sêkac lau Israel gebe sêwi gamêŋ siŋ ŋagaôgeŋ gebe sêsôm gebe “Êsêac embe sêwi aêac siŋ atom, go aêac samob tamac êndu.” ");
INSERT INTO jae_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Amboac tonaŋ lau Israel sêsabaŋ nêŋ suc topolom ŋaluc matac kêsêp nêŋ ŋakwê ma sêbic sa sebe sêsêlêŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Lau Israel sêgôm kêtôm Mose kêsôm gêdêŋ êsêac ma teteŋ Aiguptu, tec sêkêŋ gêlôŋ silber to gold ma ŋakwê gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ma Apômtau gêgôm lau Aiguptu sêlic lau Israel ŋajam e sêkêŋ gêŋ, taŋ Israel teteŋ naŋ, gêdêŋ êsêac. Tec lau Israel sêjaŋgo gêŋ su aŋga lau Aiguptu nêŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ma lau Israel dêdi aŋga Rameses sêsêlêŋ sêja Sukot. Êsêacnêŋ namba amboac 600,000, mago sêsa lauo to nêŋ gôlôac sa sêwiŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ma lau jaba taêsam sêwiŋ êsêac, ma domba to bulimakao totoŋ-totoŋ sêwiŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ma lau Israel sêkôc polom matac, taŋ sêmasaŋ aŋga Aiguptu naŋ, aŋga nêŋ suc ma sêpac polom ŋaluc. Polom tau ŋaluc gebe lau Aiguptu sesoc êsêac, tec nêŋ ŋasawa sêkêŋ jist êsêpŋa masi. Êsêac sêmasaŋ gêŋ sêniŋ aŋga intênaŋa gêwiŋ atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Lau Israel sêŋgôŋ Aiguptu kêtôm jala 430. ");
INSERT INTO jae_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ma gêdêŋ bêc jala 430 gêbacnêŋa solopgeŋ Apômtaunê lau samob sêwi gamêŋ Aiguptuŋa siŋ. ");
INSERT INTO jae_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Gêdêŋ gêbêc tonaŋ Apômtau gêjam jali ma gêwê êsêac sêsa aŋga Aiguptu sêja. Kêtu tonaŋŋa lau Israel nêŋ gôlôac to nêŋ gôlôac samob sênam jali êndêŋ êmbêc tonaŋ ma taêŋ ênam Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Gêdêŋ taŋ Parao gêwi lau Israel siŋ naŋ, Anôtô gêwê êsêac sêsa lau Pilisti nêŋ gamêŋ ŋaintêna atom. Intêna tau tonaŋ dambê, mago Anôtô taê gêjam gebe lau embe sêndac siŋ, oc moae sêkac tauŋ ôkwi sêmu sêna Aiguptu êtiam. ");
INSERT INTO jae_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tec Anôtô gêwê lau sêsa intêna gamêŋ sawaŋa sepeŋ Gwêckoc sêja. Lau Israel dêdi aŋga Aiguptu tonêŋ laukasapgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ma Mose kêkôc Josepnê ŋatêkwa gêwiŋ kêtôm Josep kêtôc lêma ma kêmasaŋ biŋ gêdêŋ lau Israel gebe “Anôtô oc ênam amac kêsi. Êndêŋ tonaŋ amac akôc ŋoc ŋatêkwa aŋga tonec êwiŋ.” ");
INSERT INTO jae_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ma êsêac sêwi Sukot siŋ jasê bec aŋga Etam, taŋ gêc gamêŋ sawa ŋamagê naŋ. ");
INSERT INTO jae_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ma Apômtau kêsêlêŋ gêmuŋ êsêac gêmoa tao majaŋ ŋalêlôm gêdêŋ ocsalô gebe êwê êsêac ma gêdêŋ gêbêc gêmoa tao ja ŋalêlôm gebe êpô êsêac e têtôm gebe sêsêlêŋ êndêŋ ocsalô ma êndêŋ êmbêc. ");
INSERT INTO jae_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tao majaŋ kêsêlêŋ gêmuŋ gêdêŋ ocsalô ma tao ja gêdêŋ gêbêc ŋapaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ôsôm êndêŋ lau Israel gebe sêkac tauŋ ôkwi sêmu sêna Pihahirot nasê bec aŋga gamêŋ, taŋ gêc Migdol to gwêc ŋasawa êkanôŋ Balsepo naŋ. Aê bec êkanôŋ malac tonaŋ aŋgôŋ gwêctaligeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Parao oc taê ênam gebe lau Israel sêlêsa sêmoa ma gamêŋ sawa oc kêlênsôŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Go aê jaŋgôm Paraonê ŋalêlôm ŋadani êsa e êjanda êsêac. Go jaku Parao to nê siŋwaga samob tulu e ŋoc ŋawasi êsa. Ma lau Aiguptu oc sêjala gebe aê Apômtau.” Ma êsêac sêgôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Gêdêŋ taŋ sêjac miŋ gêdêŋ kiŋ Aiguptuŋa gebe lau Israel sêc sêja naŋ, Parao to nê siŋwaga nêŋ ŋalêlôm gêjam tau ôkwi ma taêŋ gêjam biŋ teŋ kêpi Israel. Ma êsêac sêsôm gebe “Aêac dagôm asageŋ tonec, tec dawi Israel siŋ e sêjam sakiŋ aêac kêtiam atom.” ");
INSERT INTO jae_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Amboac tonaŋ Parao kêjatu gebe sêmansaŋ kareta siŋŋa ma kejoŋ nê siŋwaga sa sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Eŋ kêkôc kareta siŋŋa 600, taŋ tau kêjaliŋ sa naŋ, to kareta ŋagêdô samob, taŋ kêtap sa aŋga Aiguptu naŋ, ma kêkêŋ siŋwaganêŋ laumata sêpi kareta tonaŋ kêtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ma Apômtau gêgôm kiŋ Aiguptuŋa Parao nê ŋalêlôm ŋadani kêsa e kêjanda lau Israel, taŋ sêsa aŋga Aiguptu sêja toôliŋ kêpigeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Lau Aiguptu sêjanda êsêac ma Aiguptunêŋ hos to kareta ma lau, taŋ sêŋgôŋ hos ŋaô naŋ, to siŋwaga samob jasêôc lêlêc lau Israel, taŋ sê nêŋ bec sêŋgôŋ gwêctaligeŋ aŋga Pihahirot kêkanôŋ Balsepo. ");
INSERT INTO jae_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Gêdêŋ taŋ Parao kêdabiŋ êsêac naŋ, lau Israel sêôc mateŋanô sa ma sêlic lau Aiguptu sêsêlêŋ sepeŋ êsêacgeŋ, ma êsêac têtêc tauŋ ŋanô. Ma lau Israel têtaŋ gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ma êsêac sêsôm gêdêŋ Mose gebe “Amboac ondoc, sêô masi aŋga gamêŋ Aiguptuŋa, tec gôwê aêac asa amêŋ gebe amac êndu aŋga gamêŋ sawa nec me. Aôm gôgôm aêac amboac ondoc, tec gôwê aêac awi Aiguptu siŋ nec. ");
INSERT INTO jae_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Aêac amoa Aiguptugeŋ, tec asôm biŋ tonec gêdêŋ aôm gebe ‘Ondec aêac, aêac abe anam sakiŋ lau Aiguptu.’ Anam sakiŋ Aiguptu tec ŋajam kêlêlêc amac êndu aŋga gamêŋ sawaŋa su. Aêac asôm biŋ tonaŋ atom me.” ");
INSERT INTO jae_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ma Mose kêsôm gêdêŋ lau gebe “Atêc taôm atom, akô ŋajaŋa, go alic Apômtau ênam amac kêsi ŋakôm, taŋ gebe ênam êndêŋ ocsalô tonec êtu amacŋa naŋ. Lau Aiguptu, taŋ ocsalô tonec alic êsêac naŋ, oc alic êsêac êtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Apômtau oc ênac siŋ êjô amac su ma amac taôm amoa gamêŋ êmacgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Go Apômtau kêsôm gêdêŋ Mose gebe “Aôm gômôêc aê kêtu asageŋŋa. Ôsôm êndêŋ lau Israel gebe sêndi sêsêlêŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ôc nêm tôc sa to ômêtôc lêmam êsa gwêc ma ôwa êkôc gebe lau Israel sêsêp ma sêsêlêŋ gamêŋ keleŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ma aê jaŋgôm lau Aiguptu nêŋ ŋalêlôm ŋadani êsa e sêsêp sêndaŋguc êsêac, go jaŋgôm ŋoc ŋawasi êsa jaku Parao to nê siŋwaga samob ma nê kareta to lau, taŋ sêŋgôŋ hos ŋaô naŋ tulu. ");
INSERT INTO jae_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Aê embe jaŋgôm ŋoc ŋawasi êsa jaku Parao to nê kareta ma nê lau, taŋ sêŋgôŋ hos ŋaô naŋ, tulu su, go lau Aiguptu sêjala gebe aê Apômtau.” ");
INSERT INTO jae_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Go Anôtônê aŋela, taŋ kêsêlêŋ gêmuŋ lau Israel nêŋ toŋ naŋ, gêwi mala siŋ jakêdaguc êsêac. Ma tao majaŋ gêwi nêmŋa siŋ jakêkô êsêac dêmôêŋmuŋa, ");
INSERT INTO jae_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ma geŋ lau Aiguptu nêŋ toŋ to Israelnêŋ toŋ gêŋgic. Ma tao majaŋ tau kêkêŋ gêsuŋbôm ma toŋ luagêc têtap tauŋ sa atom gêdêŋ gêbêcauc samuc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Go Mose kêmêtôc lêma kêsa gwêc ma Apômtau kêkêŋ mu gêbuc aŋga gamêŋ oc kêpiŋa gêdêŋ gêbêc samuc tonaŋ ma gêgôm gwêc ŋakeleŋ kêsa. Eŋ gêwa gwêc kêkôc, ");
INSERT INTO jae_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ma lau Israel sêsêp gwêc ŋalêlôm jasêsêlêŋ sêmoa gamêŋ ŋakeleŋ. Ma gwêc tau gêlêc sa kêtôm tuŋbôm kêkô makeŋ-makeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Lau Aiguptu sêjanda êsêac ma Paraonê hos samob to nê kareta siŋŋa ma nê lau, taŋ sêŋgôŋ hos ŋaô naŋ, têdaguc êsêac sêsêp gwêc ŋalêlôm sêja. ");
INSERT INTO jae_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Gêu bôŋ kêsa ma Apômtau, taŋ gêmoa tao majaŋ to tao ja ŋalêlôm naŋ, kêtuc kêniŋ kêsêp lau Aiguptu nêŋ toŋ ma kêlênsôŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Eŋ gêbôc nêŋ kareta auc e kareta kêsêlêŋ ŋawapac sec. Tec lau Aiguptu sêsôm gebe “Taêc lau Israel sumaŋ, gebe Apômtau tau gêjac siŋ gêdêŋ aêac gêjô êsêac.” ");
INSERT INTO jae_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Go Apômtau kêsôm gêdêŋ Mose gebe “Ômêtôc lêmam êsa gwêc gebe gwêc êjô tau mala ma ênsalê lau Aiguptu to nêŋ kareta siŋŋa ma nêŋ lau sêŋgôŋ hos ŋaôŋa auc.” ");
INSERT INTO jae_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Amboac tonaŋ Mose kêmêtôc lêma kêsa gwêc, tec gêdêŋ geleŋ mata gwêc gêjô tau mala kêtiam. Lau Aiguptu, taŋ sêc su naŋ, sêlêti sêsêp gwêc ŋalêlôm ma Apômtau kêkêŋ gwêc kêsalê lau Aiguptu auc. ");
INSERT INTO jae_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gwêc gêjô tau mala ma kêmakop Paraonê kareta to lau sêŋgôŋ hos ŋaôŋa ma nê toŋ samob, taŋ têdaguc lau Israel sêsêp gwêc sêja naŋ. Êsêacnêŋ teŋ gêmoa kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mago lau Israel sêsêp gwêc jasêsêlêŋ sêmoa gamêŋ ŋakeleŋ. Gwêc tau gêlêc sa kêtôm tuŋbôm kêkô makeŋ-makeŋ. ");
INSERT INTO jae_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Gêdêŋ bêc tonaŋ Apômtau gêjam lau Israel kêsi aŋga lau Aiguptu lemeŋ ŋalêŋ tonaŋ. Ma lau Israel sêlic lau Aiguptu nêŋ ŋacmatê sêc ambêô. ");
INSERT INTO jae_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ma lau Israel sêlic kôm kapôêŋ, taŋ Apômtau gêjam gêdêŋ taŋ geseŋ lau Aiguptu su naŋ, e têtêc Apômtau. Ma êsêac sêkêŋ gêwiŋ Apômtau to nê sakiŋwaga Mose. ");
INSERT INTO jae_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Go Mose to lau Israel sêjam wê tonec gêdêŋ Apômtau gebe “Aê gabe janam wê êndêŋ Apômtau, gebe eŋ kêwaka nê ŋawasi sa. Eŋ kêbaliŋ hos to lau sêŋgôŋ ŋaôŋa sêsêp gwêc sêja. ");
INSERT INTO jae_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Apômtau kêtu ŋoc ŋaclaimôkê to ŋoc wê ŋam. Eŋ kêtu moasiŋ ênam aê kêsiŋa. Aêŋoc Anôtô eŋgoc, tec gabe jalambiŋ eŋ. Eŋ kêtu tamocnê Anôtô, tec gabe jatoc eŋ sa. ");
INSERT INTO jae_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Apômtau eŋ siŋsêlêc laŋgwa. Ênê ŋaê gebe Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Eŋ kêbaliŋ Paraonê kareta to nê siŋwaga sêsêp gwêc sêja. Ma siŋwaga, taŋ Parao kêjaliŋ sa naŋ, sênôm Gwêckoc su sêjaŋa. ");
INSERT INTO jae_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gwêc ŋadembom kêmakop êsêac auc. Êsêac sênê sêsêp gêdimbob amboac poc. ");
INSERT INTO jae_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Apômtau, aôm lêmam anôŋa kêwaka ŋaclai sa, O Apômtau, aôm lêmam anôŋa kêtuc ŋacjo popoc. ");
INSERT INTO jae_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Aôm ŋaniniŋ to ŋawasi ŋatau kôku nêm soŋo-soŋo tulu. Aôm têmtac ŋandaŋ kêsa, tec geŋ êsêac amboac ja geŋ oba. ");
INSERT INTO jae_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Aôm gôju awamjaô kêsa ma gwêc gêlêc tau sa e kêkô kêtôm tuŋbôm ma gwêc ŋadimdani tau ŋajaŋa kêsa kêkô. ");
INSERT INTO jae_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ŋacjo kêsôm gebe ‘Aê jajanda e jaôc lêlêc êsêac. Aê janac sam waba, taŋ jajaŋgo anga êsêacnêŋ naŋ, ma matoc katu gêŋ teŋ êtiam atom. Aê jambuc ŋoc siŋ sa ma lemoc enseŋ êsêac su.’ ");
INSERT INTO jae_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Aômnêm mu gêbuc e gwêc kêmakop êsêac auc. Êsêac sênê sêsêp gwêc kapôêŋ sêja têtôm ki gênê. ");
INSERT INTO jae_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O Apômtau, anôtôinêŋ asa kêtôm aôm. Asa ŋaniniŋ to dabuŋ ma gêgôm gêŋsêga toŋaclai to gêgôm gêŋtalô kaiŋ teŋ kêtôm aôm. ");
INSERT INTO jae_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Aôm kômêtôc lêmam anôŋa ma nom kêdaŋgôŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Aôm gôwê lau, taŋ kôjaliŋ sa naŋ, totêmtac gêwiŋ teŋgeŋŋa, Aôm gôwê êsêac ŋa nêm ŋaclai sêô lasê nêm gamêŋ dabuŋ. ");
INSERT INTO jae_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Lau tomôkê-tomôkê sêŋô ŋawae e têtênêp. Lau, taŋ sêŋgôŋ Pilistinêŋ gamêŋ naŋ, sêmoa tonêŋ ŋalêlôm ôluŋ-ôluŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Gêdêŋ têm tonaŋ lau Edom nêŋ kasêga têtakê, lau Moab nêŋ laumata têtênêp, ma lau samob, taŋ sêŋgôŋ Kanaan naŋ, nêŋ ŋalêlôm kêtu palê. ");
INSERT INTO jae_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Êsêac têtakê ma têtêc tauŋ ŋanô. O Apômtau, aôm lêmam ŋaŋaclai gêgôm êsêac aweŋmê kêsa têtôm poc e aômnêm lau sêôc lêlêc êsêac, e lau, taŋ aôm gôjam gôliŋ naŋ, sêôc lêlêc êsêac. ");
INSERT INTO jae_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Aôm gobe ôwê êsêac e ôsa êsêac sêsêp aôm taôm nêm lôc. O Apômtau, aôm ôsa êsêac sêsêp nom, taŋ kêtu nêm gamêŋ naŋ. O Apômtau, gamêŋ tonaŋ êtu nêm lôm dabuŋ, taŋ lêmam kêmasaŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Apômtau êtu kiŋ teŋgeŋ ma teŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Paraonê hos to nê kareta ma lau sêŋgôŋ hos ŋaôŋa sêsêp gwêc sêja, mago Apômtau kêkêŋ gwêc gêjô tau mala jakêmakop êsêac auc. Ma lau Israel sêsêlêŋ sêmoa gamêŋ ŋakeleŋ sêmoa gwêc lêlômgeŋ sêja. ");
INSERT INTO jae_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Go Aron luo, Miriam, taŋ kêtu teŋ naŋ, kêkôc oŋ sauŋ teŋ ma lauo samob têdaguc eŋ tooŋgeŋ ma têtê wê. ");
INSERT INTO jae_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ma Miriam gêjam wê gêdêŋ êsêac gebe Anam wê êndêŋ Apômtau, gebe eŋ kêwaka nê ŋawasi sa, Eŋ kêbaliŋ hos to lau sêŋgôŋ ŋaôŋa sêsêp gwêc sêja. ");
INSERT INTO jae_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Go Mose kêjatu lau Israel gebe sêndi aŋga Gwêckoc ma gêwê êsêac sepeŋ gamêŋ sawa Surŋa. Êsêac sêsêlêŋ bêc têlêac sêmoa gamêŋ sawa ma têtap bu teŋ sa atom. ");
INSERT INTO jae_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Gêdêŋ taŋ sêô lasê Mara naŋ, êsêac têtôm gebe sênôm bu Maraŋa atom, gebe bu tau ŋamakic. Gamêŋ tau ŋaê Mara ŋam gebe Bu ŋamakic. ");
INSERT INTO jae_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ma lau sêli aweŋ sa gêdêŋ Mose ma sêsôm gebe “Aêac anôm asageŋ.” ");
INSERT INTO jae_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ma eŋ gêmôêc gêdêŋ Apômtau. Ma Apômtau kêtôc ka teŋ gêdêŋ eŋ. Mose kêbaliŋ ka tau kêsêp bu ma bu tau ŋaluc kêsa. Aŋga tônê Apômtau kêkêŋ ŋagôliŋ to jatu gêdêŋ êsêac ma kêsaê êsêac. ");
INSERT INTO jae_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Eŋ kêsôm gebe “Aôm embe taŋam wamu Apômtau, aômnêm Anôtô, nê awa ma ôŋgôm ênê ŋagôliŋ êtu tôŋ, go jakêŋ gêmac, taŋ kakêŋ gêdêŋ lau Aiguptu naŋ, ŋateŋ êŋgôm aôm atom, gebe aê Apômtau, taŋ gagôm aôm ôlim ŋajam kêsa naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Go êsêac jasêô lasê Elim. Bumata 12 kêpoac gamêŋ tonaŋ ma nip 70 kêkô. Ma êsêac sê nêŋ bec sêmoa bu ŋagala. ");
INSERT INTO jae_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Êsêac dêdi aŋga Elim ma Israelnêŋ gôlôac samob sêô lasê gamêŋ sawa Sin, taŋ gêc Elim to Sinai ŋasawa. Êsêac sêwi Aiguptu siŋ ma sêmoa gamêŋ sawa e têtap ajôŋ kêtu luagêcŋa ŋabêc 15 sa, ma sêô lasê gamêŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ma Israelnêŋ gôlôac samob sêli aweŋ sa gêdêŋ Mose agêc Aron aŋga gamêŋ sawa ");
INSERT INTO jae_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ma sêsôm gêdêŋ êsêagêc gebe “Aêac abe Apômtau lêma enseŋ aêac su aŋga gamêŋ Aiguptuŋamaŋ. Gêdêŋ tonaŋ aêacma ku togwada kêkô to aŋgôŋ moasu ŋaô. Amagêc awê aêac asa gamêŋ sawa amêŋ gebe mo êjô aêac samob êndu.” ");
INSERT INTO jae_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, aê gabe jakêŋ polom êndêŋ amac aŋga undambê amboac kom. Ma lau sêsa sêna to sejoŋ polom êtôm bêcgeŋŋa êndêŋ bêc samob, gebe jansaê êsêac gebe sêmoa ŋoc biŋsu ŋalabu me masi. ");
INSERT INTO jae_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Êndêŋ bêc êtu 6ŋa embe sêmansaŋ polom, taŋ sejoŋ sa naŋ, oc polom bêc tageŋŋa tau êtu taêsam êtôm bêc luagêcŋa.” ");
INSERT INTO jae_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Go Mose agêc Aron sêsôm gêdêŋ lau Israel samob gebe “Êndêŋ êtula amac oc ajala gebe Apômtau gêwê amac asa aŋga gamêŋ Aiguptuŋa amêŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ma êndêŋ eleŋ bêbêc amac oc alic Apômtaunê ŋawasi, gebe eŋ gêŋô amac ali awem sa gêdêŋ eŋ tau, gebe aêagêc asa, tec ali awem sa gêdêŋ aêagêc.” ");
INSERT INTO jae_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ma Mose kêsôm gebe “Êndêŋ êtula Apômtau êkêŋ gwada êndêŋ amac aniŋ, ma êndêŋ eleŋ bêbêc êkêŋ amac aŋgôŋ moasu ŋaô. Gebe Apômtau tau gêŋô amac ali awem sa gêdêŋ eŋ. Aêagêc asa. Amac ali awem sa gêdêŋ aêagêc atom, ali awem sa gêdêŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Go Mose kêsôm gêdêŋ Aron gebe “Ôsôm êndêŋ lau Israel nêŋ gôlôac samob gebe ‘Amêŋ atu gasuc andêŋ Apômtau amêŋ, gebe eŋ gêŋô amac ali awem sa sugac.’” ");
INSERT INTO jae_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ma gêdêŋ taŋ Aron kêsôm biŋ gêdêŋ lau Israel nêŋ gôlôac naŋ, êsêac sêkac tauŋ ôkwi gêdêŋ gamêŋ sawa ma sêlic Apômtaunê ŋawasi geoc tau lasê ŋa tao teŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Aê gaŋô lau Israel sêli aweŋ sa. Ôsôm êndêŋ êsêac gebe ‘Êndêŋ êtula amac oc aniŋ gwada ma êndêŋ eleŋ bêbêc aŋgôŋ moasu ŋaô. Gocgo ajala gebe Apômtau, amacnêm Anôtô, aê.’” ");
INSERT INTO jae_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Gêdêŋ kêtula kêmbico mêŋsêsa e sêjam gamêŋ, taŋ bec kêkô naŋ, auc. Ma gêdêŋ bêbêcgeŋ maniŋ gêjam gamêŋ tau auc. ");
INSERT INTO jae_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Maniŋ gê su acgom, go gêŋ ŋasec-ŋasec to kuku kêtôm mêcgauc gêc nom. ");
INSERT INTO jae_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lau Israel sêlic gêŋ tau ma sêsôm gêdêŋ tauŋ gebe “Tonec asageŋ.” Gebe êsêac sêjam kauc gêŋ tau. Ma Mose kêsôm gêdêŋ êsêac gebe “Polom, taŋ Apômtau kêkêŋ gêdêŋ amac gebe aniŋ naŋ, tonec. ");
INSERT INTO jae_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ma Apômtau tau kêjatu biŋ amboac tonec gebe ‘Amac samob êndêŋ-êndêŋgeŋ ajoŋ gêŋ sa êtôm amac aniŋŋa. Ajoŋ lita luagêc sa êtôm ŋacanôgeŋ. Amboac tonaŋ asa lau, taŋ sêŋgôŋ amacnêm bec sêwiŋ amac naŋ sa, go ajoŋ sa êtôm namba tau tonaŋgeŋ.’” ");
INSERT INTO jae_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ma lau Israel sêgôm kêtôm tonaŋ. Lau ŋagêdô sejoŋ ec kapôêŋ, ŋagêdô sejoŋ ec ŋagec. ");
INSERT INTO jae_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mago gêdêŋ taŋ sêjam dôŋ gêŋ tau ŋa dôŋ laclu naŋ, ŋac taŋ kejoŋ ec kapôêŋ naŋ, kêkôc kêlêlêc laclu teŋ su atom, ma ŋac, taŋ kejoŋ ec ŋagec naŋ, kêpô lêna atom. Êsêac samob sejoŋ sa kêtôm êsêac sêniŋŋa solopgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ma Mose kêsôm gêdêŋ êsêac gebe “Ŋac teŋ êkêŋ ŋagêdô ênêc e eleŋŋa atom.” ");
INSERT INTO jae_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mago êsêac sêkêŋ taŋeŋ eŋ atom. Lau ŋagêdô tetoc ŋapopoc gêc e geleŋŋa, tec gêŋ tau kêtu sec ma têmoa gêjam auc ma ŋasu kêsa. Ma Mose têtac ŋandaŋ kêsa gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kêtôm bêbêcgeŋ samob êsêac sejoŋ gêŋ tau sa e kêtôm êsêac gebe sêniŋŋageŋ. Mago gêdêŋ taŋ oc ŋandaŋ kêsa naŋ, gêŋ tau gêwê. ");
INSERT INTO jae_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Gêdêŋ ŋabêc kêtu 6ŋa êsêac sejoŋ polom kêtôm bêc luagêcŋa. Êsêac sejoŋ laclu luagêc-luagêc kêtôm ŋacanôgeŋ. Ma gôlôacnêŋ laumata dêdêŋ Mose jasêjac ŋamiŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ma eŋ kêsôm gêdêŋ êsêac gebe “Biŋ tonec Apômtau kêjatu gebe ‘Eleŋŋa bêc talêwaŋ tauŋŋa teŋ. Bêc tau kêtu Apômtaunê sabat dabuŋ. Gêŋ taŋ amac abe apac naŋ, apacmaŋ. Ma gêŋ, taŋ amac abe ano naŋ, anomaŋ. Ma gêŋ ŋagêdô, taŋ gacgeŋ gêc naŋ, ênêc e eleŋŋa acgom.’” ");
INSERT INTO jae_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Amboac tonaŋ êsêac dedeŋ gêŋ ŋagêdô gêc e geleŋŋa, kêtôm Mose kêjatu êsêac. Ma gêŋ tau kêtu sec atom ma têmoa kêsêp atom. ");
INSERT INTO jae_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose kêsôm gebe “Ocsalô aniŋ gêŋ tau gebe ocsalô kêtu Apômtaunê sabat. Ocsalô amac oc atap gêŋ teŋ sa aŋga kôm atom. ");
INSERT INTO jae_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ajoŋ gêŋ tau sa êtôm bêc 6, mago êndêŋ bêc êtu 7ŋa, taŋ êtu sabat naŋ, oc atap gêŋ teŋ sa atom.” ");
INSERT INTO jae_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Gêdêŋ bêc kêtu 7ŋa lau ŋagêdô sêsa sêja sebe sejoŋ gêŋ tau, mago têtap gêŋ teŋ sa atom. ");
INSERT INTO jae_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ma Apômtau kêsôm gêdêŋ Mose gebe “Amac adec ŋoc jatu to biŋsu ma asô ŋalabu atom e êndêŋ ondocgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ôlic acgom, aê Apômtau kakêŋ sabat gêdêŋ amac. Kêtu tonaŋŋa kakêŋ polom kêtôm bêc luagêc gêdêŋ bêc kêtu 6ŋa. Êndêŋ bêc êtu 7ŋa amacnêm lau samob sêŋgôŋ nêŋ maleŋgeŋ. Ŋac teŋ êwi nê mala siŋ atom.” ");
INSERT INTO jae_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Amboac tonaŋ lau sêlêwaŋ tauŋ gêdêŋ bêc kêtu 7ŋa. ");
INSERT INTO jae_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ma lau Israel sêsam gêŋ tau gebe Mana. Gêŋ tau sêpsêp kêtôm mêcgauc ma ŋasaê kêtôm polom tolêp. ");
INSERT INTO jae_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ma Mose kêsôm gebe “Apômtau kêjatu biŋ tonec gebe ‘Akôc gêŋ tau laclu teŋ ma amansaŋ ênêc gebe nêm gôlôac ŋamuŋa sêlic polom, taŋ kakêŋ gêdêŋ amac aeŋ aŋga gamêŋ sawa gêdêŋ taŋ gawê amac asa aŋga gamêŋ Aiguptuŋa amêŋ naŋ.’” ");
INSERT INTO jae_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ma Mose kêsôm gêdêŋ Aron gebe “Ôkôc ku teŋ ma ôkêŋ mana laclu teŋ êsêp ma otoc ku tau êkô Apômtau laŋônêmŋa gebe ênêc e nêm gôlôac ŋamuŋa sêlic amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Amboac tonaŋ Aron ketoc ku tau kêkô katapa poacŋa ŋanêmŋa gebe ênêc kêtôm taŋ Apômtau kêjatu gêdêŋ Mose naŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ma lau Israel seŋ mana tau kêtôm jala 40 e sêô lasê gamêŋ, taŋ ŋamalac sêŋgôŋ naŋ. Êsêac seŋ mana e sêô lasê gamêŋ Kanaan ŋamadiŋ. ");
INSERT INTO jae_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Dôŋ sêjam dôŋ gêŋ ŋakeleŋŋa gêdêŋ têm tonaŋ kêkôc kêtôm 20 lita.) ");
INSERT INTO jae_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Lau Israel nêŋ gôlôacmôkê samob dêdi aŋga gamêŋ sawa Sin. Êsêac sêsêlêŋ ma sêlêwaŋ tauŋ tosawa-tosawa kêtôm Apômtaunê jatu e sê nêŋ bec aŋga Repidim. Mago bu gebe lau sênômŋa masi. ");
INSERT INTO jae_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kêtu tonaŋŋa êsêac sêli aweŋ sa gêdêŋ Mose ma sêsôm gebe “Ôkêŋ bu êndêŋ aêac anôm.” Ma Mose kêsôm gêdêŋ êsêac gebe “Amac ali awem sa gêdêŋ aê kêtu asageŋŋa. Amac asaê Apômtau kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ma bu gêjô lau aŋga tônê, tec sêli aweŋ sa gêdêŋ Mose ma sêsôm gebe “Aôm gôwê aêac asa aŋga Aiguptu mêŋasa tonec gebe bu êjô aêac to ma gôlôac ma bulimakao samob êndu kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Amboac tonaŋ Mose gêmôêc gêdêŋ Apômtau gebe “Aê jaŋgôm lau tonec amboac ondoc. Sauŋgeŋ, go têtuc aê ŋa poc êndu.” ");
INSERT INTO jae_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôkôc lau Israel nêŋ laumata ŋagêdô ma asêlêŋ aôc lêlêc’ lau naamuŋ. Ômêŋgôm tôc, taŋ kôkôc gêdêŋ gôjac bu Nil naŋ, ma ôsêlêŋ. ");
INSERT INTO jae_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ôlic acgom, aê jakô aôm ŋamata aŋga poc kapôêŋ Horebŋa ma aôm ônac poc tau, go bu êsa gebe lau sênôm.” Mose gêgôm amboac tonaŋ, ma lau Israel nêŋ laumata sêlic. ");
INSERT INTO jae_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Eŋ gê gamêŋ tonaŋ ŋaê gebe Masa to Meriba, ŋam gebe sêli aweŋ sa gêdêŋ Mose to sêsaê Apômtau ŋa biŋ, taŋ sêsôm gebe “Apômtau gêmoa gêwiŋ aêac me masi. ");
INSERT INTO jae_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Go lau Amelek sêô lasê ma sêjac siŋ gêdêŋ lau Israel aŋga Repidim. ");
INSERT INTO jae_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ma Mose kêsôm gêdêŋ Josua gebe “Ôjaliŋ lau sa ma eleŋ bêbêc asêlêŋ naanac siŋ êndêŋ lau Amelek. Aê tauc jamêŋgôm Anôtônê tôc najakô gamêŋ ŋabau.” ");
INSERT INTO jae_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Amboac tonaŋ Josua gêgôm biŋ, taŋ Mose kêsôm gêdêŋ eŋ naŋ, ŋanô kêsa ma gêjac siŋ gêdêŋ lau Amelek. Ma Mose agêc Aron ma Hur jasêpi gamêŋ ŋabau tau sêja. ");
INSERT INTO jae_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Gêdêŋ taŋ Mose gêôc lêma sa naŋ, lau Israel sêjac lau Amelek ŋapaŋ. Mago gêdêŋ taŋ Mose kêlêwaŋ lêma ŋasawa ŋagêdô naŋ, lau Amelek sêjac lau Israel. ");
INSERT INTO jae_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mago Mose lêma gêmac. Amboac tonaŋ tec Aron agêc Hur sêkôc poc teŋ mêŋsêkêŋ Mose gêŋgôŋ ŋaô, go êsêagêc sêsip eŋ lêma sa. Ŋac teŋ kêkô ŋamakeŋ ma teŋ kêkô ŋamakeŋ. Tec sêôc Mose lêma tôŋ ŋaŋêŋgeŋ e oc jakêsêp. ");
INSERT INTO jae_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ma Josua geseŋ Amelek to nê lau su ŋa siŋ ŋamata. ");
INSERT INTO jae_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ma Apômtau kêsôm gêdêŋ Mose gebe “Oto biŋ tonec êsêp buku teŋ, gebe lau taêŋ ênam ma ôndôŋ êndêŋ Josua e êtu tôŋ eŋ, gebe aê janseŋ lau Amelek nêŋ waeŋ aŋga umboŋ ŋalabu su ênaŋa samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ma Mose gêboa altar teŋ sa ma kêsam ŋaê gebe “Apômtau kêtu ŋoc gêbôm,” ");
INSERT INTO jae_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ma kêsôm gebe” Lemeŋ êndêŋ Apômtaunê gêbôm. Apômtaunê siŋ oc ênêc gôlôac togôlôacgeŋ êtu lau Amalekŋa.” ");
INSERT INTO jae_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Lau Israel sêwi gamêŋ Aiguptuŋa siŋ e ŋaajôŋ kêtu têlêac, go sêô lasê gamêŋ sawa Sinaiŋa. ");
INSERT INTO jae_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Êsêac dêdi aŋga Repidim ma sêsêlêŋ e sêô lasê gamêŋ sawa Sinaiŋa ma sê nêŋ bec aŋga gamêŋ sawa tonaŋ sêŋgôŋ sêkanôŋ lôc tau. ");
INSERT INTO jae_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ma Mose kêpi lôc gêdêŋ Anôtô gêja. Ma Apômtau awa gêjac eŋ aŋga lôc ma kêsôm gebe “Ôsôm biŋ amboac tonec êndêŋ Jakobnê gôlôac to ôkêŋ ŋawae êndêŋ lau Israel gebe ");
INSERT INTO jae_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Amac taôm alic gêŋ, taŋ gagôm gêdêŋ lau Aiguptu. Amac alic, gebe aê kabalaŋ amac amboac momboaŋ kêbalaŋ ŋalatu sêŋgôŋ nê magê ŋaô, ma kajoŋ amac adêŋ aê amêŋ. ");
INSERT INTO jae_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Amboac tonaŋ amac embe taŋem wamu aê aoc ma ajop ŋoc poac, go atu aê tauc ŋoc gêŋ aŋga lau nomŋa samob nêŋ, gebe nom samucgeŋ ŋatau aê. ");
INSERT INTO jae_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Amac oc atu ŋoc gamêŋ kiŋŋa ŋadabuŋwaga to atu ŋoc lau dabuŋ m teŋ. Biŋ tau tonaŋ aôm ôsôm êndêŋ lau Israel.” ");
INSERT INTO jae_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Amboac tonaŋ Mose gêdêŋ lau gêja ma gêmôêc êsêacnêŋ laumata ma kêkêŋ biŋ samob, taŋ Apômtau kêjatu eŋ naŋ, ŋawae gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Go lau samob sêlôc seleŋgeŋ ma sêsôm gebe “Biŋ samob, taŋ Apômtau kêsôm naŋ, aêac abe aŋgôm ŋanô êsa.” Ma Mose gêjac miŋ launêŋ biŋ tonaŋ gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, aê jandêŋ aôm jawac jamoa tao majaŋ ŋalêlôm. Ma embe jasôm biŋ êndêŋ aôm, go lau sêŋô ma sêkêŋ êwiŋ aôm endeŋ tôŋgeŋ.” Ma Mose gêjac miŋ launêŋ biŋ gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôndêŋ lau ôna ma ôsôm êndêŋ êsêac gebe sênam dabuŋ tauŋ êndêŋ galoc ma eleŋŋa. Êsêac sêkwasiŋ nêŋ ŋakwê, ");
INSERT INTO jae_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ma êndêŋ bêc êtu têlêacŋa êsêac sêmansaŋ tauŋ e êmbacnê, gebe êndêŋ bêc êtu têlêacŋa tonaŋ aê Apômtau jasêp lôc Sinai jawac ma lau samob sêlic. ");
INSERT INTO jae_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ônac belo êŋgi lôc auc êtu madiŋ ma ôsôm êndêŋ lau gebe ‘Ajop taôm gebe api lôc tau atom ma amoasac ŋamadiŋ tau atom. Ŋac, taŋ êmoasac lôc naŋ, senseŋ eŋ su ênaŋa. ");
INSERT INTO jae_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Lau teŋ lemeŋ sêmoasac eŋ atom. Êsêac oc têtuc eŋ ŋa poc me sêpê eŋ êndu. Bôc me ŋamalac, taŋ sêmoasac lôc naŋ, sêmoa atom, sênaŋa.’ Êndêŋ taŋ dauc êtaŋ ê tôŋ baliŋgeŋ naŋ, êsêac sêpi lôc sêmêŋ.” ");
INSERT INTO jae_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Amboac tonaŋ Mose kêsêp aŋga lôc gêdêŋ lau gêja ma kêsôm gêdêŋ êsêac, gebe sênam dabuŋ tauŋ. Ma êsêac sêkwasiŋ nêŋ ŋakwê. ");
INSERT INTO jae_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ma eŋ kêsôm gêdêŋ lau gebe “Amansaŋ taôm e êmbacnê êndêŋ bêc êtu têlêacŋa ma andambiŋ lauo atom.” ");
INSERT INTO jae_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Gêdêŋ bêc kêtu têlêacŋa ŋabêbêcgeŋ naŋ, wapap gêjac to ôsic kêkac ma tao majaŋ teŋ kêkôm lôc auc. Ma dauc kêtaŋ kapôêŋ e lau samob, taŋ sêŋgôŋ gamêŋ becŋa naŋ têtênêp. ");
INSERT INTO jae_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Go Mose gêwê lau sêsa aŋga gamêŋ becŋa sêja gebe sêpuc Anôtô tôŋtôŋ. Ma êsêac sêkô lôc tau ŋalabu. ");
INSERT INTO jae_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Jadauŋ kêkôm lôc Sinai auc gebe Apômtau kêsêp lôc gêmêŋ gêmoa ja ŋalêlôm. Ma jadauŋ kêpi kêtôm ja geŋ oba ma lôc kêwiwic tau ŋasec. ");
INSERT INTO jae_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dauc kêtaŋ kêtu kapôêŋ-kêtu kapôêŋ e ŋadiŋdiŋ sec. Ma Mose kêsôm biŋ, go Anôtô gêjô eŋ awa ŋa wapap. ");
INSERT INTO jae_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ma Apômtau kêsêp lôc Sinai ŋatêpôê gêmêŋ. Ma Apômtau gêmôêc Mose gebe êpi lôc ŋatêpôê êna, ma Mose kêpi gêja. ");
INSERT INTO jae_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôsêp ôndêŋ lau naôkêŋ puc êsêac gebe sêŋgêli ŋamadiŋ êtu sêlic aêŋa nec atom. Embe sêŋgôm, oc taêsam sênaŋa. ");
INSERT INTO jae_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ma ôsôm êndêŋ dabuŋwaga, taŋ sêndambiŋ aê naŋ, gebe sênam dabuŋ tauŋ amboac tonaŋgeŋ. Embe masi, go aê janac êsêac êwiŋ.” ");
INSERT INTO jae_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ma Mose kêsôm gêdêŋ Apômtau gebe” Lau tau têtôm gebe sêpi lôc Sinai atom, gebe aôm kôjatu gebe ‘Anac belo aŋgi lôc auc êtu madiŋ ma anam dabuŋ lôc tau.’” ");
INSERT INTO jae_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma Apômtau kêsôm gêdêŋ eŋ gebe “Ôsêp ôna ma ôkôc Aron agêc api amêŋ êtiam. Mago dabuŋwaga to lau sêŋgêli ŋamadiŋ êtu sêpi sêndêŋ aê sêmêŋŋa nec atom. Embe sêŋgôm, go janac êsêac.” ");
INSERT INTO jae_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Amboac tonaŋ Mose kêsêp gêdêŋ lau jakêkêŋ ŋawae gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ma Apômtau kêsôm biŋ samob tonec ŋai gebe ");
INSERT INTO jae_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Apômtau, aômnêm Anôtô, aê. Aê gawê aôm kôsa aŋga gamêŋ Aiguptuŋa gômôêŋ, kôsa aŋga andu gêŋômaŋa. ");
INSERT INTO jae_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ônam sakiŋ anôtôi jaba êwiŋ atom, ônam sakiŋ aê taucgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ôŋgôm gêŋ, taŋ gêmoa undambê me gêmoa nom me gêmoa bu, taŋ kêpoac nom ŋalêlôm naŋ, ŋateŋ ŋakatu ênam gêŋ tau laŋô atom. ");
INSERT INTO jae_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Owec êndêŋ gwam tonaŋ to ônam sakiŋ gêŋ tau atom, gebe aê Apômtau, aômnêm Anôtô, gajob ŋoc lau gebe têntac êwiŋ aê taucgeŋ nec. Aê jakêŋ lau, taŋ têntac gedec aê naŋ, nêŋ geo ŋagêjô êpi êsêac latuŋi to dêbuŋi ma abeŋi. ");
INSERT INTO jae_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mago aê jakêŋ moasiŋ êndêŋ lau, taŋ têntac gêwiŋ aê to sêmasaŋ aêŋoc biŋsu naŋ, nêŋ gôlôac to gôlôac ŋêŋgeŋ êna. ");
INSERT INTO jae_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ôjaiŋ Apômtau, aômnêm Anôtô, nê ŋaê atom gebe Apômtau oc êmêtôc ŋac, taŋ êjaiŋ ênê ŋaê naŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Taêm ênam sabat gebe dabuŋ ma ômansaŋ ŋapep. ");
INSERT INTO jae_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Êndêŋ bêc 6 aôm ônam kôm to ôŋgôm nêm gêŋ samob. ");
INSERT INTO jae_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mago bêc êtu 7ŋa êtu Apômtau, aômnêm Anôtô, nê sabat. Êndêŋ bêc tonaŋ aôm ônam kôm teŋ atomanô. Aôm to nêm latômio to ŋac ma nêm sakiŋwagao to ŋac ma nêm bulimakao to lau jaba, taŋ sêŋgôŋ sêwiŋ aôm naŋ, anam kôm teŋ atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Gebe gêdêŋ bêc 6 Apômtau kêkêŋ undambê to nom ma gwêc to ŋagêŋ samob, taŋ sêmoa mateŋ jali naŋ. Ma gêdêŋ bêc kêtu 7ŋa naŋ, eŋ kêlêwaŋ tau. Kêtu tonaŋŋa Apômtau gêjam mec sabat tau ma gêjam dabuŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Otoc tamam agêc tênam sa, gebe ômoa ŋasawa baliŋ aŋga gamêŋ, taŋ Apômtau, aômnêm Anôtô, êkêŋ êndêŋ aôm naŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Ônac ŋamalac êndu atom. ");
INSERT INTO jae_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Ôŋgôm gêŋ mockaiŋo to mockaiŋŋa atom. ");
INSERT INTO jae_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Ônam geŋgeŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ôŋga biŋ êpi lau wacbaŋ aôm atom. ");
INSERT INTO jae_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Matam katu lau wacbaŋ aôm nêŋ andu atom. Matam katu lau wacbaŋ aôm nêŋ awê to sakiŋwagao to ŋac ma bulimakao to doŋki ma gêŋ ŋagêdô teŋ atom.” ");
INSERT INTO jae_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Lau samob sêsaê wapap gêjac to ôsic kêkac ma dauc kêtaŋ ŋakicsêa to jadauŋ kêsa lôc tau ma têtêc tauŋ e têtênêp ma sêkô jaêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ma êsêac sêsôm gêdêŋ Mose gebe “Aôm taôm ôsôm biŋ êndêŋ aêac ma aêac akêŋ taŋeŋ. Anôtô embe êsôm biŋ êndêŋ aêac, oc amac êndu.” ");
INSERT INTO jae_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ma Mose kêsôm gêdêŋ lau gebe “Atêc taôm atom, gebe Anôtô gêmêŋ gebe ênsaê amac, ec taêm ênam biŋ atêc eŋŋa ŋapaŋ gebe aŋgôm sec atom.” ");
INSERT INTO jae_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Gêdêŋ taŋ Mose kêtu gasuc tao majaŋ, taŋ Anôtô gêmoa ŋalêlôm naŋ, lau sêkô jaêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ma Apômtau kêsôm gêdêŋ Mose gebe “Amagêc Aron ma Nadab agêc Abihu ma Israelnêŋ laumata 70 api andêŋ aê amêŋ ma ateŋ mec akô jaêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose taugeŋ êtu gasuc aê. Lau ŋagêdô têtu gasuc atom ma lau sêpi sêwiŋ eŋ sêmêŋ atom.” ");
INSERT INTO jae_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Go Mose gêdêŋ lau gêja ma kêkêŋ Apômtaunê biŋsu to ŋagôliŋ samob ŋawae gêdêŋ êsêac. Ma lau samob sêlôc sa aweŋ tageŋ gebe “Biŋ samob, taŋ Apômtau kêsôm naŋ, aêac abe aŋgôm ŋanô êsa.” ");
INSERT INTO jae_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ma Mose keto Apômtaunê biŋ samob sa. Ma gêdêŋ bêbêc kanucgeŋ eŋ gêdi sa ma gêboa altar teŋ sa kêkô lôc ŋalabu ma gêjac alê poc 12 sa kêtôm lau Israel nêŋ gôlôacmôkê 12. ");
INSERT INTO jae_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Go eŋ kêjatu lau Israel nêŋ lau wakuc ŋagêdô gebe sêkêŋ daja ma sêmbuc bulimakao kapoac wakuc ma sêkêŋ têtu dawama êndêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ŋadec ŋamakeŋ Mose kêkêŋ kêsêp laclu teŋ. Ŋadec ŋamakeŋ eŋ kêpalip kêpi altar. ");
INSERT INTO jae_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Go kêkôc poac ŋabuku ma kêsam lasê gêdêŋ lau sêŋô. Ma êsêac sêsôm gebe” Biŋ samob, taŋ Apômtau kêjatu naŋ, aêac abe aŋgôm ŋanô êsa ma taŋeŋ wamu biŋ tau.” ");
INSERT INTO jae_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Go Mose kêkôc dec, taŋ kêpoac laclu naŋ, jakêpalip kêpi lau ma kêsôm gebe “Alic acgom, poac, taŋ Apômtau kêmoatiŋ gêdêŋ amac kêdaguc biŋ samob tonaŋ ŋai naŋ, ŋadec tau tonec.” ");
INSERT INTO jae_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Go Mose agêc Aron ma Nadab agêc Abihu to Israelnêŋ laumata 70 sêpi lôc sêja, ");
INSERT INTO jae_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ma êsêac sêlic Israelnêŋ Anôtô. Ma gamêŋ, taŋ eŋ kêkô naŋ, amboac masac pocawa ma ŋakêŋkêŋgosu kêtôm undambê tau. ");
INSERT INTO jae_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ma Apômtau lêma gêjac lau Israel nêŋ kasêga tonaŋ atom. Êsêac sêlic Anôtô ma seŋ to sênôm gêŋ. ");
INSERT INTO jae_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôpi lôc ôndêŋ aê mêŋôôŋ ômoa tonec acgom. Aê gabe jakêŋ poc tapa tau êndêŋ aôm. Aê kato biŋsu to jatu kêsêp gebe lau sêjala.” ");
INSERT INTO jae_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Amboac tonaŋ Mose gêdi tonê sakiŋwaga Josua ma sêpi Anôtônê lôc sêja. ");
INSERT INTO jae_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ma Mose kêsôm gêdêŋ laumata gebe “Amoa tonec e aêagêc amu amêŋ êtiam. Aron agêc Hur sêmoa sêwiŋ amac. Ŋac teŋ nê biŋ teŋ embe êlênsôŋ, go êndêŋ êsêagêc êna.” ");
INSERT INTO jae_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Go Mose kêpi lôc gêja ma tao kêkôm lôc tau auc. ");
INSERT INTO jae_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Apômtaunê ŋawasi kêsêp lôc gêmêŋ, ma tao kêkôm lôc tau auc kêtôm bêc 6. Gêdêŋ bêc kêtu 7ŋa Apômtau awa gêjac Mose kêsa aŋga tao ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Gêdêŋ tonaŋ lau Israel sêlic Apômtaunê ŋawasi kêtôm ja ŋawaô gêlaŋ-gêlaŋ aŋga lôc ŋatêpôê. ");
INSERT INTO jae_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ma Mose kêsô tao ŋalêlôm jakêpi lôc. Ma eŋ gêmoa lôc kêtôm geleŋŋa 40 ma gêbêcauc 40. ");
INSERT INTO jae_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Apômtau gêjac dabiŋ nê biŋ gêdêŋ Mose aŋga lôc su, go kêkêŋ biŋsu ŋatabele luagêc, poc tapa luagêc, taŋ Anôtô tau lêma keto biŋ kêsêp naŋ. ");
INSERT INTO jae_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Gêdêŋ taŋ lau sêlic gebe Mose kêsêp aŋga lôc gêmêŋ atom e ŋêŋgeŋ naŋ, êsêac sêkac tauŋ sa sêgi Aron auc ma sêsôm gêdêŋ eŋ gebe “Ajôc, ômansaŋ ma anôtô teŋ, gebe êsêlêŋ êmuŋ aêac. Aêac ajam kauc asageŋ gêgôm Mose, ŋac tau, taŋ gêwê aêac aŋga Aiguptu amêŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ma Aron kêsôm gêdêŋ êsêac gebe “Akôc nêm lauo ma latômio to ŋac nêŋ salasa gold su ma ajoŋ andêŋ aê amêŋ.” ");
INSERT INTO jae_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Amboac tonaŋ lau samob sêkôc salasa gold su ma sejoŋ dêdêŋ Aron sêja. ");
INSERT INTO jae_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ma eŋ kêkôc gold tau su aŋga êsêac lemeŋ ma kêpac kêsêp ku e gêwê ma gêgôm bulimakao ŋalatu ŋakatu teŋ. Go êsêac sêsôm gebe “O Israel, nêm anôtô, taŋ gêwê aôm aŋga gamêŋ Aiguptuŋa gômôêŋ naŋ, tau tonec.” ");
INSERT INTO jae_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron gêlic gêŋ tonaŋ, go gêboa altar teŋ kêkô ŋakatu tau laŋônêmŋa ma kêsôm gebe “Eleŋŋa aêac talic om tatoc Apômtau saŋa teŋ.” ");
INSERT INTO jae_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ma êsêac dêdi gêdêŋ bêbêc kanucgeŋ ma sêkêŋ daja to dawama. Ma lau sêŋgôŋ sic seŋ to sênôm gêŋ ma dêdi sa sebe sêŋgôm dôa-dôa. ");
INSERT INTO jae_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôsêp ôna, gebe nêm lau, taŋ gôwê aŋga Aiguptu sêmêŋ naŋ, sêgôm tauŋ têtu sec. ");
INSERT INTO jae_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Êsêac sêkac tauŋ su sebeŋ aŋga intêna, taŋ kajatu êsêac gebe sêsaŋa naŋ. Êsêac sêmasaŋ bulimakao ŋalatu ŋakatu teŋ ŋa gold, taŋ gêwê naŋ, ma teteŋ mec to sêkêŋ da gêdêŋ gêŋ tau ma sêsôm gebe ‘O Israel, aômnêm anôtô, taŋ gêwê aôm aŋga Aiguptu gômôêŋ naŋ, tau tonec.’” ");
INSERT INTO jae_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ma Apômtau kêsôm gêdêŋ Mose gebe “Aê galic lau tonaŋ ma kajala êsêac gebe lau gêsuŋtêkwa ŋatoŋ sec. ");
INSERT INTO jae_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Amboac tonaŋ ôwi aê siŋ jamoa ŋoc tauŋa, gebe aê têtac ŋandaŋ ŋaja êkwanam êsêac. Tageŋ aôm, tec jakêŋ aôm ôtu lau-m kapôêŋ.” ");
INSERT INTO jae_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mago Mose keteŋ nê Apômtau Anôtô gebe “O Apômtau, êtu ageŋŋa aôm têmtac ŋandaŋ ŋaja enseŋ nêm lau, taŋ gôwê êsêac toŋaclai kapôêŋ ma lêmam ŋajaŋa sêsa aŋga gamêŋ Aiguptuŋa sêmêŋ naŋ su. ");
INSERT INTO jae_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Amboac ondoc lau Aiguptu oc sêsôm gebe ‘Kec, eŋ kêsau êsêacgoc. Eŋ gêwê êsêac sêsa sêja, gebe ênac êsêac êndu aŋga lôc to enseŋ êsêac su aŋga nom ŋagamêŋ samob.’ Tec ôwi aôm têmtac ŋandaŋ kapôêŋ siŋ ma ônam nêm ŋalêlôm ôkwi ma ôŋgôm sec, taŋ gobe ôŋgôm êndêŋ nêm lau naŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Taêm ênam nêm sakiŋwaga Abraham agêc Isak ma Jakob. Aôm kôtôc lêmam kêpi aôm taôm ma kôsôm gêdêŋ êsêac gebe ‘Aê gabe jakêŋ nêm wakuc têtu taêsam têtôm utitalata umboŋ ŋalabuŋa, ma gamêŋ samob, taŋ gajac mata gêdêŋ amac naŋ, aê gabe jakêŋ êndêŋ nêm wakuc êtu êsêacnêŋ nomlênsêm endeŋ tôŋgeŋ.’” ");
INSERT INTO jae_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Amboac tonaŋ tec Apômtau gêjam nê ŋalêlôm ôkwi ma gêgôm sec, taŋ gebe êŋgôm êndêŋ nê lau naŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Go Mose kêkac tau ôkwi ma kêsêp aŋga lôc gêja. Eŋ kêkôc biŋsu ŋapoc tapa luagêc. Apômtau keto biŋ kêsêp poc tapa makeŋ-makeŋ, keto kêsêp ŋamakeŋ nêmŋa to muŋa kêtôm taugeŋ. ");
INSERT INTO jae_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Anôtô tau gêjam poc tapa tonaŋ ŋakôm, ma biŋ tau Anôtô keto. Eŋ tau kepeŋ ŋatalô kêsêp poc tapa. ");
INSERT INTO jae_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Gêdêŋ taŋ Josua gêŋô lau sêjam lasê ŋakicsêa naŋ, eŋ kêsôm gêdêŋ Mose gebe “Siŋ ŋakicsêa kêpi aŋga gamêŋ becŋa.” ");
INSERT INTO jae_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mago Mose kêsôm gebe “Tonec wê siŋ atom, ma ŋacjo sêku êsêac tulu ŋataŋiboa atom amboac tonaŋgeŋ. Têtê wê ŋaonda tec gaŋô.” ");
INSERT INTO jae_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Eŋ kêdabiŋ gamêŋ becŋa ma gêlic bulimakao ŋakatu to lau têtê wê, tec sep tageŋ Mose têtac ŋandaŋ kêsa ma kêbaliŋ poc tapa siŋ e popoc aŋga lôc ŋalabu. ");
INSERT INTO jae_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ma eŋ kêkôc bulimakao ŋakatu, taŋ êsêac sêmasaŋ naŋ, ma kêkêŋ ja geŋ to kêlêsim popoc, go kêpalip ŋataê kêsêp bu ma kêkêŋ gêdêŋ lau Israel sênôm. ");
INSERT INTO jae_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Go Mose kêsôm gêdêŋ Aron gebe “Lau tonaŋ sêgôm asageŋ gêdêŋ aôm, tec gôgôm êsêac sêwê kaiŋ sec kapôêŋ amboac tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron kêsôm gebe “O ŋatau, têmtac ŋandaŋ êsa atom. Aôm taôm kôjala gebe lau tonaŋ taêŋ gêjam secgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Êsêac sêsôm gêdêŋ aê gebe ‘Ajôc, ômansaŋ ma anôtô teŋ, gebe êsêlêŋ êmuŋ aêac naŋ. Aêac ajam kauc asageŋ gêgôm Mose, ŋac tau, taŋ gêwê aêac aŋga Aiguptu amêŋ naŋ.’ ");
INSERT INTO jae_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ma aê kasôm gêdêŋ êsêac gebe ‘Lau samob, taŋ nêŋ gold gêc naŋ, sêkôc su.’ Tec êsêac sêkêŋ gêdêŋ aê, ma aê kabaliŋ kêpi ja gêja ma bulimakao ŋakatu tonaŋ mêŋkêsa.” ");
INSERT INTO jae_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose gêlic gebe lau têtu meloc ma seseŋ ŋagôliŋ su, gebe Aron gêlôc sa, gebe sêsa lêŋ amboac tonaŋ e nêŋ ŋacjo sêmajec êsêac, ");
INSERT INTO jae_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","tec eŋ jakêkô gamêŋ becŋa ŋasacgêdô ma gêmôêc gebe “Asa lau sêsap Apômtau tôŋ. Asa andêŋ aê amêŋ.” Ma Lewinê wakuc samob sêkac sa dêdêŋ Mose sêja. ");
INSERT INTO jae_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ma eŋ kêsôm gêdêŋ êsêac gebe “Apômtau, Israelnêŋ Anôtô, nê biŋ tau tonec gebe Amac samob ajandiŋ ômbiŋkap tosiŋ, go asêlêŋ ana-amêŋ-ana-amêŋ aŋga gamêŋ becŋa ŋasacgêdô ŋasawa ma anac nêm lasitêwai to nêm lau ôlim andaŋ ma lau wacbaŋ amacŋa êndu.” ");
INSERT INTO jae_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewinê wakuc sêgôm kêtôm Mosenê biŋ kêjatu êsêac. Ma gêdêŋ bêc tonaŋ lau amboac 3,000 sêjaŋa. ");
INSERT INTO jae_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ma Mose kêsôm gebe” Ocsalô tonec amac akêŋ latômi to nêm lasitêwai sêjô mec dabuŋwagaŋa gebe anam sakiŋ Apômtau, gebe eŋ ênam mec amac êndêŋ bêc tonec.” ");
INSERT INTO jae_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ŋageleŋ Mose kêsôm gêdêŋ lau gebe “Amac agôm sec kapôêŋ. Galoc aê gabe japi jandêŋ Apômtau jana. Moae jatôm gebe jaê wama eŋ, gebe êsuc nêm sec ôkwi.” ");
INSERT INTO jae_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Amboac tonaŋ Mose gêmu gêdêŋ Apômtau gêja ma kêsôm gebe “Ojae, lau tonaŋ sêgôm sec kapôêŋanô. Êsêac sêmasaŋ nêŋ anôtô jaba ŋa gold. ");
INSERT INTO jae_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mago galoc aê jateŋ aôm, gebe ôsuc êsêacnêŋ sec ôkwi. Embe masi, go jateŋ aôm, gebe onseŋ ŋoc ŋaê aŋga nêm buku, taŋ koto naŋ, su.” ");
INSERT INTO jae_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Apômtau gêjô Mose awa gebe” Lau samob, taŋ sêgôm sec gêdêŋ aê naŋ, oc janseŋ êsêacnêŋ ŋaê aŋga ŋoc buku su. ");
INSERT INTO jae_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Galoc ôna ma ôwê lau sêna gamêŋ, taŋ kasôm ŋabiŋ gêdêŋ aôm naŋ. Ôlic acgom, ŋoc aŋela êsêlêŋ êmuŋ aôm. Mago êndêŋ ŋanoc janac êsêac kêsiŋa, oc jakêŋ ŋagêjô êjô nêŋ sec.” ");
INSERT INTO jae_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ma Apômtau kêkêŋ gêmac sec teŋ gêdêŋ lau kêtu teteŋ mec gêdêŋ bulimakao ŋalatu, taŋ Aron kêmasaŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe” Ôndi, ôwi gamêŋ tonec siŋ, aôm to lau, taŋ gôwê êsêac sêsa aŋga gamêŋ Aiguptuŋa sêmêŋ naŋ. Asêlêŋ e aô lasê gamêŋ, taŋ katôc lemoc gêdêŋ Abraham agêc Isak ma Jakob ma kasôm gebe ‘Aê gabe jakêŋ nom tonec êndêŋ nêm wakuc.’ ");
INSERT INTO jae_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aê gabe jasakiŋ ŋoc aŋela teŋ êsêlêŋ êmuŋ aôm ma jajanda lau Kanaan to Amor ma lau Het to Peres ma lau Hib to Jebus gebe sêwi gamêŋ tau siŋ. ");
INSERT INTO jae_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Api gamêŋ, taŋ su to lêp keseleŋ naŋ. Mago aê tauc japi jawiŋ amac atom. Embe jawiŋ amac, oc moae janseŋ amac su aŋga intêna anaŋa, gebe amac lau gêsômtêkwa ŋatoŋ.” ");
INSERT INTO jae_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Gêdêŋ taŋ lau sêŋô biŋ ŋawapac tonaŋ naŋ, êsêac têtaŋ lasê ma ŋac teŋ gêjam gêlôŋ tau atom, ");
INSERT INTO jae_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","gebe Apômtau kêsôm gêdêŋ Mose gebe “Ôsôm êndêŋ lau Israel gebe ‘Amac lau gêsômtêkwa ŋatoŋ. Aê embe japi jawiŋ amac êndêŋ ŋasawa dambêgeŋ oc janac amac eb tageŋ anaŋa. Amboac tonaŋ akôc nêm gêlôŋ su, ec jajala gebe aê jaŋgôm amac amboac ondoc.’” ");
INSERT INTO jae_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Amboac tonaŋ lau Israel sêkôc nêŋ gêlôŋ su aŋga lôc Horeb ma sêsêlêŋ ŋaômageŋ. ");
INSERT INTO jae_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ma Mose kêkôc becobo elêmê ma gê bec tau kêkô jaêc gamêŋ, taŋ bec ŋagêdô kêkô naŋ. Eŋ kêsam becobo tau gebe Becobo takac saŋa. Lau teŋ embe sensom Apômtau, go sêsa sêna becobo sêkac tauŋ saŋa, taŋ kêkô jaêc gamêŋ, taŋ bec ŋagêdô kêkô naŋ. ");
INSERT INTO jae_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Elêmê embe Mose êsa êndêŋ becobo tau êna, go lau samob sêndi sa sêkô nêŋ bec ŋakatam ma mateŋ êndiŋ Mose ŋapaŋ e êsô becobo ŋalêlôm êna. ");
INSERT INTO jae_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mose embe êsô becobo ŋalêlôm êna su, go tao majaŋ êsêp êmêŋ êkô becobo tau ŋasacgêdô. Ma Apômtau ênam biŋgalôm êwiŋ Mose. ");
INSERT INTO jae_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Lau embe sêlic tao majaŋ êsêp êmêŋ êkô becobo tau ŋasacgêdô, go samob sêndi ma teteŋ mec êndêŋ Apômtau aŋga nêŋ bec ŋasacgêdô êndêŋ-êndêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Amboac tonaŋ Apômtau gêjam biŋgalôm gêwiŋ Mose agêc laŋôŋanô gêdêŋ tauŋ amboac ŋac teŋ, taŋ gêjam biŋgalôm gêwiŋ nê ŋac ôli andaŋ eŋŋa. Ma gêdêŋ taŋ Mose gêmu gêja gamêŋ, taŋ becobo ŋagêdô kêkô naŋ, nê sakiŋwaga gêwi becobo tau siŋ atom. Ŋac wakuc tau Nun latu Josua. ");
INSERT INTO jae_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Go Mose kêsôm gêdêŋ Apômtau gebe “Ôlic acgom, aôm taôm kôsôm gêdêŋ aê gebe ‘Ôwê lau tonec sêpi sêna.’ Mago aôm kôsam ŋac, taŋ gobe ôsakiŋ êwiŋ aê naŋ, nê ŋaê lasê gêdêŋ aê atom. Mago aôm kôsôm gebe ‘Aê kajala aômnêm ŋaê ma aôm gôjac matocanô ŋajam. ");
INSERT INTO jae_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Amboac tonaŋ galoc aê jateŋ aôm gebe aê embe janac matamanô ŋajam, go ôtôc nêm intêna êndêŋ aê e jajala aôm êtu tôŋ ma janac matamanô ŋajam. Ma taêm ênam tonec êwiŋ gebe lau-m tonec têtu aômnêm laugac.” ");
INSERT INTO jae_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ma Apômtau kêsôm gebe “Aê tauc oc jasêlêŋ jawiŋ aôm ma jakêŋ aôm ôlêwaŋ taôm.” ");
INSERT INTO jae_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ma Mose kêsôm gêdêŋ eŋ gebe “Aôm taôm embe ôsêlêŋ ôwiŋ aêac atom, go ôsakiŋ aêac awi gamêŋ tonec siŋ ma api ana atom. ");
INSERT INTO jae_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Aôm embe ôsêlêŋ ôwiŋ aêac atom, go ajala amboac ondoc gebe aê to ŋoc lau ajac aôm matamanô ŋajam. Aôm embe ôsêlêŋ ôwiŋ aêac, go êwaka aê to nêm lau sa êndêŋ lau nomŋa ŋagêdô samob.” ");
INSERT INTO jae_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ma Apômtau kêsôm gêdêŋ Mose gebe “Biŋ tecenaŋ, taŋ aôm kôsôm naŋ, aê oc jaŋgôm ŋanô êsa, gebe aôm gôjac aê matocanô ŋajam ma aê kajala aômnêm ŋaê sugac.” ");
INSERT INTO jae_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose kêsôm gebe “Aê jateŋ aôm gebe oc nêm ŋawasi lasê êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ma Apômtau kêsôm gebe “Aê gabe jakêŋ ŋoc ŋawasi êô lasê aôm laŋômnêmŋa ma jasôm ŋoc ŋaê lasê êndêŋ aôm ôŋô. Ŋoc ŋaê gebe Apômtau. Ma oc jamoasiŋ ŋac, taŋ gabe jamoasiŋ eŋ naŋ, to taêc walô ŋac, taŋ gabe taêc walô eŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ma kêsôm teŋ gebe “Mago aôm ôtôm gebe ôlic aê laŋôcanô atom, gebe ŋac, taŋ êlic aê naŋ, oc êmoa mata jali atom.” ");
INSERT INTO jae_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ma Apômtau kêsôm gebe “Ôlic acgom, ŋasawa teŋ tec gêc kêdabiŋ aê. Ôpi mêŋôkô poc kapôêŋ ŋaô. ");
INSERT INTO jae_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ma êndêŋ aôm ôkô poc ŋasawa ma jaŋgandê aôm auc ŋa lemoc e jaôc lêlêc aôm su acgom, ");
INSERT INTO jae_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","go jakôc lemoc su e ôlic dêmôêctêkwa, mago ôlic laŋôcanô atom.” ");
INSERT INTO jae_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Go Apômtau kêsôm gêdêŋ Mose gebe “Ôpa poc tapa luagêc êtôm ŋamataŋa, go jato biŋ, taŋ kato kêsêp poc tapa ŋamataŋa, tê kôtuc popoc nê, êsêp poc tapa tonec amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ômansaŋ taôm êndêŋ eleŋ bêbêcgeŋ. Ma eleŋ bêbêcgeŋ ôpi lôc Sinai ômôêŋ ma ôtôc taôm êndêŋ aê aŋga lôc tau ŋatêpôê. ");
INSERT INTO jae_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ŋac teŋ êpi êwiŋ aôm atom ma teŋ êmoa lôc ŋagala atom. Domba to bulimakao sêniŋ gêgwaŋ sêmoa lôc ŋagala atom amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Amboac tonaŋ Mose kêpa poc tapa luagêc kêtôm poc tapa ŋamataŋa. Ma gêdêŋ bêbêc kanucgeŋ eŋ gêdi jakêpi lôc Sinai kêtôm Apômtau kêjatu eŋ, ma kêkôc poc tapa luagêc gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ma Apômtau kêsêp gêmêŋ gêmoa tao ŋalêlôm e kêkô jabaŋ Mose. Ma Mose awa gêjac Apômtaunê ŋaê. ");
INSERT INTO jae_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Go Apômtau jakêlêlêc eŋ gêja ma gêmôêc gebe “Apômtau, Apômtau, eŋ Anôtô, moasiŋ to taê walô ŋatau, eŋ têtac ŋandaŋ sebeŋ atom. Eŋ ŋac tolêlôm têtac gêwiŋ ŋamalacŋa to ŋac biŋŋanôŋa. ");
INSERT INTO jae_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Eŋ têtac gêwiŋ lau 1,000 to 1,000 to kêsuc êsêacnêŋ geo to sêgêli biŋŋa ma sec ôkwi. Mago eŋ kêmêtôc lau geo amboac tonaŋgeŋ ma kêkêŋ tameŋi sêgêli biŋ ŋagêjô kêpi latuŋi to dêbuŋi ma abeŋi to nêŋ gôlôac.” ");
INSERT INTO jae_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Go Mose gewec sebeŋ to keteŋ mec gêdêŋ Apômtau ");
INSERT INTO jae_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ma kêsôm gebe “O Apômtau, aê embe janac aôm matamanô ŋajam, go jateŋ ŋoc Apômtau aôm, gebe ôsêlêŋ ômoa aêac ŋalêlôm ôwiŋ. Biŋŋanô, êsêac lau gêsuŋtêkwa ŋatoŋ, mago ôsuc aêac agêli biŋ to ma sec ôkwi ma ôkôc aêac sa atu nêm gêŋ.” ");
INSERT INTO jae_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ma Apômtau kêsôm gebe “Ôlic acgom, aê jamoatiŋ poac teŋ. Aê oc jaŋgôm gêŋtalô nêm lau samob sêlic. Gêŋtalô amboac tonec kêsa aŋga nom ŋagamêŋ to aŋga lau-m teŋ atomanô. Ma lau samob, taŋ sêwiŋ aôm naŋ, oc sêlic gêŋ, taŋ Apômtau êŋgôm naŋ. Ma gêŋ, taŋ gabe jaŋgôm êndêŋ aôm naŋ, gêŋsêga kaiŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Ojop biŋ, tec galoc jajatu aôm nec. Ôlic acgom, aê jajanda lau Amor to Kanaan ma lau Het to Peres ma lau Hib to Jebus sêc sêna. ");
INSERT INTO jae_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ôlic taôm gebe ômoatiŋ poac ôwiŋ lau, taŋ sêŋgôŋ gamêŋ aôm ô lasêŋa naŋ atom. Embe ôŋgôm, go êtu nêm lakô. ");
INSERT INTO jae_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ônsêlô êsêacnêŋ altar su to ôsap nêŋ alê poc tulu ma ôtuc nêŋ anôtôonê ŋakatu popoc. ");
INSERT INTO jae_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Aôm oteŋ mec êndêŋ anôtô jaba teŋ atom, gebe Apômtau eŋ Anôtô, taŋ gêjam lêmuŋ nê lau gebe têntac êwiŋ eŋ taugeŋ naŋ. Ênê ŋaê gebe Aê gajob ŋoc lau têntac gêwiŋ aêŋa. ");
INSERT INTO jae_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ôlic taôm, gebe ômoatiŋ poac ôwiŋ lau gamêŋ tônêŋa atom. Êsêac embe sêŋgôm mockaiŋŋa êndêŋ nêŋ anôtôi to sêkêŋ da êndêŋ nêŋ anôtôi, oc moae sêkalem aôm gebe ôniŋ da ôwiŋ êsêac, ");
INSERT INTO jae_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ma aôm oc moae ôjaliŋ nêŋ latuŋio sa gebe sênam latômi. Ma êsêac latuŋio embe sêŋgôm mockaiŋo êndêŋ nêŋ anôtôi, oc sêlêtôm aôm latômi gebe sêŋgôm mockaiŋ êndêŋ êsêacnêŋ anôtôi amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ôpac ki êwê ma ômansaŋ anôtô jaba atom. ");
INSERT INTO jae_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ôlic Om Polom Ŋalucŋa ŋapep. Êndêŋ bêc 7 aôm ôniŋ polom ŋaluc êtôm kajatu aôm naŋ. Ôniŋ êndêŋ ŋanoc. taŋ kakêŋ gêdêŋ aôm naŋ, êndêŋ ajôŋ Abib, gebe gêdêŋ ajôŋ Abib tau tonaŋ aôm gôwi Aiguptu siŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ŋamêc samob têtu aêŋoc gêŋ, aômnêm bôc kapoac ŋamêc samob, nêm bulimakao to domba kapoac ŋamêc. ");
INSERT INTO jae_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Doŋki ŋamêc, naŋ ônac da ŋa domba ŋalatu. Embe ondec gebe ônac da gêŋ tau atom, go ôpôŋ gêsutêkwa tulu. Ma ônac da nêm latômi ŋamêc samob. Ma ŋac teŋ êô lasê aê tolêma sawa atom. ");
INSERT INTO jae_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ônam kôm êndêŋ bêc 6, mago êndêŋ bêc êtu 7ŋa ôlêwaŋ taôm. Ôlêwaŋ taôm êndêŋ bêc tonaŋ êndêŋ têm ôkac nom ôkwiŋa ma êndêŋ têm ojoŋ kômŋanô saŋa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Aôm ôlic Om Wokeŋa êndêŋ noc ôniŋ gêŋ lasêŋa. Ma êndêŋ jala ŋabêc ŋamuŋa aôm ôlic Om Ojoŋ Kômŋanô saŋa. ");
INSERT INTO jae_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Nêm ŋacwaga samob sêô lasê sêkô aê Apômtau Anôtô, taŋ katu Israelnêŋ Anôtô naŋ, laŋôcnêmŋa êtu dim têlêac êtôm jalageŋ. ");
INSERT INTO jae_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Aê oc jajanda lau tomôkê-tomôkê sêc su ma aê jaŋgôm nêm gamêŋ esewec êtu kapôêŋ. Ma êndêŋ taŋ ôpi ôna ô lasê ôkô aê Apômtau, aômnêm Anôtô, laŋôcnêmŋa êtu dim têlêac êtôm jalageŋ naŋ, ŋac teŋ oc êjaŋgo nêm gamêŋ su atom. ");
INSERT INTO jae_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ôkêŋ polom tojist êwiŋ daja ŋadec atom. Ma Om Pasa ŋada ŋagêdô ênêc e eleŋŋa atom. ");
INSERT INTO jae_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ôkôc nêm kôm ŋamêc ŋajamanô tau ôndêŋ aê Apômtau, aômnêm Anôtô, ŋoc andu ôna. Ono domba ŋalatu ŋa tênanê su atom.” ");
INSERT INTO jae_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ma Apômtau kêsôm gêdêŋ Mose gebe “Oto biŋ tonaŋ sa gebe biŋ tonaŋ kêtu poac, taŋ kamoatiŋ gêdêŋ aôm to Israel naŋ, ŋagôliŋ.” ");
INSERT INTO jae_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ma Mose gêmoa gêwiŋ Apômtau geleŋŋa 40 ma gêbêcauc 40. Eŋ geŋ mo atom to gênôm bu atom. Ma eŋ keto poac ŋabiŋ kêsêp poc tapa, eŋ keto biŋsu lemeŋ lu. ");
INSERT INTO jae_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Gêdêŋ taŋ Mose kêsêp aŋga lôc Sinai gêmêŋ naŋ, eŋ kêkôc biŋsu ŋapoc tapa luagêc. Ma gêdêŋ taŋ eŋ kêsêp aŋga lôc gêmêŋ naŋ, kêjala tau gebe laŋôanô ŋawasi kaiŋ teŋ nec atom. Eŋ laŋôanô ŋawasi kaiŋ teŋ tonaŋ ŋam gebe eŋ gêjam biŋgalôm gêwiŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Gêdêŋ taŋ Aron to lau Israel samob sêlic Mose naŋ, tec sêlic laŋôanô ŋawasi kaiŋ teŋ ma têtêc gebe nasêndambiŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mago Mose kêkalem êsêac, tec Aron to gôlôacnêŋ laumata samob sêmu dêdêŋ eŋ sêja, ma Mose gêjam biŋgalôm gêwiŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Tonaŋ su, go lau Israel samob têtu gasuc eŋ ma eŋ kêkêŋ biŋsu samob, taŋ Apômtau kêsôm gêdêŋ eŋ aŋga lôc Sinai naŋ, gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mose kêsôm biŋ gêdêŋ êsêac su, go kêkêŋ obo lala teŋ gêsaŋ laŋôanô auc ");
INSERT INTO jae_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kêtôm têm samob, taŋ Mose kêsô bec gêdêŋ Apômtau gêja gebe ênam biŋgalôm êwiŋ eŋ naŋ, eŋ kêkac obo lala su e gêmu kêsa kêtiam. Ma gêdêŋ taŋ kêsa gêmêŋ naŋ, eŋ gêjac miŋ biŋ, taŋ Apômtau kêjatu naŋ, gêdêŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ma lau Israel sêlic Mose laŋôanô gebe ŋawasi kaiŋ teŋ. Go Mose gêsaŋ laŋôanô auc ŋa obo lala ŋapaŋ e gêmu kêsô gêja kêtiam gebe ênam biŋgalôm êwiŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Gêdêŋ jala kêtu luagêcŋa ŋaajôŋ ŋamataŋa ŋabêc ŋamataŋa êsêac sêkwê lômbec tau sa. ");
INSERT INTO jae_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose kêkwê lômbec sa. Eŋ kêkêŋ nombaŋ to kêmasaŋ sagiŋtêkwa ma kêkêŋ budeŋ gêsac ŋaô ma kêkwê alê ŋalêlômŋa. ");
INSERT INTO jae_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Go gê obo kêpi lômbec tau ma kêmasaŋ obo teŋ gêsac ŋaô kêtu salôm, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Go Mose kêkôc poc tapa ma kêkêŋ kêsêp katapa poacŋa. Su, go kêmasaŋ katapa ŋata ma kêkêŋ ŋagadê gêsac katapa tau ŋaô. ");
INSERT INTO jae_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ma eŋ kêkôc katapa kêsô lômbec gêja ma kêkêŋ obo baliŋ geŋkaleŋ gêsaŋ katapa poacŋa auc, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Go ketoc tebo kêkô bec sêkac tauŋ saŋa. Tebo tau kêkô obo baliŋ nêmŋa kêkanôŋ gamêŋ gêmu kêpiŋa, ");
INSERT INTO jae_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ma kêdênaŋ polom, taŋ sêkêŋ gêdêŋ Apômtau kêtu da naŋ, gêsac tebo ŋaô, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ma eŋ ketoc jakaiŋ kêkô bec sêkac tauŋ saŋa ŋalêlôm, kêkô tebo ŋamakeŋ kêkanôŋ lômbec ŋagamêŋ gêmu kêsêpŋa, ");
INSERT INTO jae_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","go kêkêŋ ja ŋalêsi kêkô Apômtau laŋônêmŋa, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Go ketoc altar gold kêkô obo baliŋ ŋalêlôm aŋga bec sêkac tauŋ saŋa tau. ");
INSERT INTO jae_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Go kêkêŋ ja geŋ gêŋ ŋamalu, taŋ gêsac altar ŋaô naŋ, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Go kêkêŋ obo baliŋ geŋkaleŋ lômbec ŋasacgêdô. ");
INSERT INTO jae_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ma ketoc altar dajaŋa kêkô bec sêkac tauŋ saŋa tau ŋakatam nêmŋa ma kêkêŋ daja to da gêŋ kêpuc ŋamalac ôliŋ tôŋŋa gêsac ŋaô, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Go ketoc laclu kapôêŋ kêkô bec sêkac tauŋ saŋa to altar ŋasawa ma kêkêŋ bu kêsêp êtu sêkwasiŋ lemeŋ to eŋkaiŋ ŋa bu tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose ma Aron to latui sêkwasiŋ lemeŋ to eŋkaiŋ ŋa bu tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kêtôm têm samob, taŋ êsêac sêsô bec sêkac tauŋ saŋa to sêndambiŋ altarŋa naŋ, sêkwasiŋ tauŋ, kêtôm Apômtau kêjatu Mose. ");
INSERT INTO jae_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ma eŋ gêjac balaŋ malacluŋ to lômbec ma altar auc ma kêkêŋ obo geŋkaleŋ malacluŋ ŋasacgêdô amboac tonaŋ. Tec Mose gêjac dabiŋ nê kôm tau. ");
INSERT INTO jae_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Go tao gêsaŋ bec sêkac tauŋ saŋa auc ma Apômtaunê ŋawasi gêjam lômbec ŋalêlôm auc. ");
INSERT INTO jae_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ma Mose kêtôm gebe êsô bec sêkac tauŋ saŋa êna atom, gebe tao kêkôm auc ma Apômtaunê ŋawasi gêjam lômbec ŋalêlôm auc. ");
INSERT INTO jae_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kêtôm têm samob, taŋ lau Israel sêsêlêŋ sêmoa intêna naŋ, tao embe êôŋ sa aŋga lômbec, go êsêac sêndi ma sêsêlêŋ. ");
INSERT INTO jae_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mago tao embe êôŋ sa atom, go sêndi sêsêlêŋ atom, sêôŋ e tao êôŋ sa acgom. ");
INSERT INTO jae_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kêtôm têm samob, taŋ lau Israel sêsêlêŋ sêmoa intêna naŋ, Apômtaunê tao kêkôm lômbec auc gêdêŋ geleŋŋa, ma ja gêjam tao auc gêdêŋ gêbêc. Israelnêŋ gôlôac samob sêlic. ");
INSERT INTO jae_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Gêdêŋ Aronnê latuagêc sêmac êndu kêtu sêkêŋ daja dabuŋ atomŋa gêdêŋ Apômtau, eŋ kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Ôsôm êndêŋ têwam Aron gebe eŋ êsô gamêŋ dabuŋanô, taŋ obo baliŋ gêsaŋ auc naŋ, êna paliŋ-paliŋgeŋ atom gebe gamêŋ tonaŋ aê maloc, taŋ gaoc tauc lasê ŋa tao gêsac poac ŋakatapa, lêpôŋ taê labuŋa, ŋaô, gebe êmac êndu atom. ");
INSERT INTO jae_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Eŋ êsô gamêŋ dabuŋanô tau ŋalêŋ tageŋ tonec gebe êkôc bulimakao kapoac wakuc teŋ êtu dawamaŋa to domba kapoac teŋ êtu dajaŋa êna. ");
INSERT INTO jae_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Eŋ êliŋ bu su acgom, go êsô ŋakwê kwalam-kwalam baliŋ ma ŋakwê akaiŋŋa kwalam-kwalam dambê. Eŋ êjandiŋ ômbiŋkap kwalam-kwalam ma embec obo gasuc. Gêŋ samob tonaŋ tec kêtu ŋakwê dabuŋ tau. ");
INSERT INTO jae_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ma eŋ êkôc noniŋ kapoac luagêc aŋga lau Israel nêŋ êtu dawama ma domba kapoac teŋ êtu daja. ");
INSERT INTO jae_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Ma Aron êkêŋ bulimakao kapoac tau êtu dawama êtu eŋ tauŋa ma ê wama tau to nê gôlôac su acgom. ");
INSERT INTO jae_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Go eŋ êkôc noniŋ luagêc tonaŋ naetoc lulugeŋ êkô Apômtau laŋônêmŋa aŋga becobo ŋakatam dêmôêŋa. ");
INSERT INTO jae_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aŋga tonaŋ eŋ êpuc kapoac êpi noniŋ luagêc tau, teŋ êtu Apômtauŋa ma teŋ êtu Asaselŋa. ");
INSERT INTO jae_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Go Aron êkêŋ noniŋ taŋ kêpuc kapoac kêtu Apômtauŋa naŋ êtu dawama. ");
INSERT INTO jae_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mago noniŋ, taŋ kêpuc kapoac jakêsêp Asaselŋa naŋ, eŋ êkôc tomata jaligeŋ ma etoc êkô Apômtau laŋônêmŋa, go êsa sakiŋ asuc sec ôkwiŋa êpi eŋ ma êjanda noniŋ tau êsa gamêŋ sawa êndêŋ Asasel êna. ");
INSERT INTO jae_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aron êkêŋ bulimakao kapoac tau êtu dawama êtu eŋ tau to nê gôlôacŋa nêŋ secŋa, eŋ ênac bulimakao tonaŋ êtu dawama êtu eŋ tauŋa. ");
INSERT INTO jae_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Go êkôc ja ŋalana aŋga Apômtaunê altar naêkêŋ êsêp laclu teŋ ma êŋgaiŋ gêŋmalu, taŋ sêlênsim popoc naŋ, lêma luagêc êkôc êmêŋ gamêŋ dabuŋanô tau. ");
INSERT INTO jae_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Aŋga Apômtaunê laŋônêmŋa eŋ êkêŋ gêŋmalu tau êpi ja ma gêŋmalu ŋajadauŋ ênam lêpôŋ taê labuŋa auc gebe êmac êndu atom. ");
INSERT INTO jae_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ma eŋ êkôc bulimakao kapoac ŋadec ŋagêdô ma êpalip êpi lêpôŋ ŋagadê to katapa poacŋa nêmŋa ŋa nê lêma latu êtu dim 7. ");
INSERT INTO jae_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Tonaŋ su acgom, go êmbuc noniŋ, taŋ êtu da enseŋ launêŋ secŋa naŋ, ma êkôc ŋadec êsô gamêŋ dabuŋanô tau êna ma êpalip êpi katapa poacŋa ŋagadê to nêmŋa êtôm tê eŋ gêgôm ŋa bulimakao kapoac ŋadec su nê. ");
INSERT INTO jae_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Eŋ êŋgôm amboac tonaŋ tec eŋ ê wama êtu gamêŋ dabuŋ ma lau Israel nêŋ ŋatêmui to nêŋ sêgêli biŋsu ma nêŋ sec samobŋa. Ma êŋgôm amboac tonaŋgeŋ êtu becobo poacŋa, taŋ gacgeŋ kêkô êsêacnêŋ môp ŋalêlôm naŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ŋac teŋ êmoa becobo ŋalêlôm êndêŋ taŋ eŋ êsô gamêŋ dabuŋanô e êsa êmêŋ ma ênac da tau to nê gôlôac ma lau Israel samob naŋ, atom. ");
INSERT INTO jae_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Go eŋ êsa êndêŋ altar, taŋ kêkô Apômtau laŋônêmŋa naŋ, êna ma ênac da êtu altar tauŋa ma eŋ êkôc dec ŋagêdô aŋga bulimakao to noniŋ nêŋ ma ênsê êpi altar ŋajabo ênam aucgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ma êpalip dec ŋagêdô êpi altar tau êtu dim 7 ŋa nê lêma latu gebe êŋgôm gêŋ tau êtu selec to dabuŋ ma enseŋ lau Israel nêŋ ŋatêmui su. ");
INSERT INTO jae_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Êndêŋ taŋ eŋ ênac da gamêŋ dabuŋ to becobo poacŋa ma altar êmbacnê naŋ, go eŋ êkôc noniŋ mata jali tau êmêŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Go Aron êkêŋ nê lêma lulugeŋ ênsac noniŋ mata jali tau môkêapac ŋaô ma êsôm keso samob, taŋ lau Israel sêgôm to sêgêliŋa ma nêŋ sec samob naŋ, lasê ma êkêŋ êpi noniŋ môkêapac. Go ŋac, taŋ kêmasaŋ tau su kwanaŋgeŋ naŋ, êwê noniŋ tau êc êsa gamêŋ sawa êna. ");
INSERT INTO jae_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Noniŋ tau êôc êsêacnêŋ sec samob êpi tau êna gamêŋ gasaŋ teŋ ma (ŋac tau) esoc noniŋ tau aŋga gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Go Aron êsô becobo poacŋa ŋalêlôm êna ma êkôc ŋakwê kwalam-kwalam, taŋ eŋ kêsô sa gêdêŋ taŋ kêsô gamêŋ dabuŋanô gêja naŋ, su ma êkêŋ ênêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ma eŋ êliŋ bu aŋga gamêŋ dabuŋ ŋabalêm teŋ ma êsô taunê ŋakwê ma êsa êmêŋ, go êkêŋ daja êtu eŋ tau to lauŋa ma ê wama tau to lau samob. ");
INSERT INTO jae_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ma ŋalêsi da êjô launêŋ secŋa eŋ êkêŋ ja êniŋ aŋga altar tau. ");
INSERT INTO jae_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ma ŋac, taŋ êwê noniŋ êndêŋ Asasel êna naŋ, êkwasiŋ nê ŋakwê ma êliŋ bu su acgom, go êmu êsô malac êmêŋ êtiam. ");
INSERT INTO jae_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ma bulimakao to noniŋ, taŋ êtu da êjô secŋa naŋ, nêŋ dec, taŋ sêkôc sêsô gamêŋ dabuŋanô tau sêna gebe ê wama naŋ, nêŋ ŋaôlic to ŋamêsôm ma ŋatêkwa sêmbaliŋ êsa malac ŋamagê êna ma sêkêŋ ja êniŋ su. ");
INSERT INTO jae_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ma ŋac, taŋ êkêŋ ja êniŋ gêŋ tau naŋ, êkwasiŋ nê ŋakwê ma êliŋ bu su acgom, go êmu êsô malac êmêŋ êtiam. ");
INSERT INTO jae_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Ma tonec êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ êndêŋ amac gebe êndêŋ ajôŋ êtu 7 ŋabêc 10 amac taôm to lau jaba, taŋ sêmoa sêwiŋ amac naŋ, anam dabuŋ taôm ma anam kôm teŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Gebe êndêŋ bêc tonaŋ oc sê wama amac gebe atu selec. Nêm sec ênaŋa ma atu selec samucgeŋ akô Apômtau laŋônêm. ");
INSERT INTO jae_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Om tonaŋ êtu amacnêm Omsêga anam dabuŋ taômŋa teŋ. Tonaŋ êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ma sakiŋ daê wamaŋa gêjac dabuŋwaga, taŋ seŋ oso to sêjam mec eŋ gebe êjô tama su naŋ, ŋawae. Eŋ êsô ŋakwê kwalam-kwalam, taŋ kêtu ŋakwê dabuŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ma ê wama êtu gamêŋ dabuŋ to becobo ma altarŋa ma êŋgôm êtu dabuŋwaga to gôlôac ŋalau samobŋa êwiŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Lêŋ tonaŋ êtu amacnêm ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ gebe asa sakiŋ wamaŋa êtu lau Israel nêŋ sec samobŋa êtu dim tageŋ êtôm jalageŋ.” Ma Mose gêgôm kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Ôsôm êndêŋ gôlôac Israel ŋalau samob gebe amac atu lau dabuŋ gebe Apômtau, amacnêm Anôtô, aê tauc dabuŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Amac samob êtôm ŋacanôgeŋ atoc tenemi to tamemi sa ma taêm ênam om gebe dabuŋ ma amansaŋ ŋapep, gebe Apômtau, nêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Amac akac taôm ôkwi andêŋ anôtô gwam ana atom. Ma apac ki êwê ma amansaŋ anôtô jaba teŋ atom, gebe Apômtau, nêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Embe akêŋ da daŋge êndêŋ Apômtau, go akêŋ ŋalêŋ gebe ênac Apômtau mataanô ŋajamgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Êndêŋ bêc, taŋ akêŋ da tau naŋ, to bêc, taŋ êndaŋguc naŋ, aniŋ da tau e êmbacnê. Gêŋ ŋagêdô-gêdô, taŋ ênêc e êndêŋ bêc êtu têlêac naŋ, ja êniŋ su. ");
INSERT INTO jae_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ma embe aniŋ êndêŋ bêc êtu têlêac, naŋ oc êtu gêŋ geŋeŋ ma oc ênac aê matocanô ŋajam atom. ");
INSERT INTO jae_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ma teŋ embe êniŋ, oc êtu tôp êndêŋ eŋ gebe eŋ gêgôm Apômtaunê gêŋ dabuŋ teŋ kêtu sec, ma senseŋ eŋ su aŋga nê lau nêŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ma êndêŋ taŋ amacnêm gamêŋ ŋakôm ŋanô êsa naŋ, go anac sa e êndêŋ kôm ŋamadiŋ samucgeŋ atom, ma ajoŋ gêŋ ŋasaliŋ-saliŋ sa êtu ŋamu atom. ");
INSERT INTO jae_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Aŋga nêm kôm wainŋa amboac tonaŋgeŋ ajoŋ gêŋ ŋasaliŋsaliŋ ma akôc ŋanô, taŋ kêsêlô kêsêp nom naŋ, sa atom. Awi siŋ êndêŋ lau ŋalêlôm sawa to lau jaba gebe Apômtau, amacnêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Anam geŋgeŋ atom, ma anam launêŋ bôlêŋ auc atom to ansau auc lau atom. ");
INSERT INTO jae_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Atôc lemem ansau anam aê laŋôc ma aŋgôm amacnêm Anôtônê ŋaê êtu sec ŋa lêŋ amboac tonaŋ atom gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Akôniŋ nêm lau wacbaŋ amacŋa ma ajaŋgo nêŋ gêŋ su atom. Aŋgamiŋ nêm sakiŋwaga nê ŋaôli kômŋa e êndêŋ ŋaeleŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Apuc boa ŋac taŋasuŋbic to akêŋ gêŋ teŋ êmbôc ŋac matapec nê intêna auc atom. Atêc nêm Anôtô, gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Amêtôc biŋ eso atom. Ma ambu lau ŋalêlôm sawa ma atoc lau tolêlôm sa êlêlêc atom, mago amêtôc nêm lau wacbaŋ amac ŋa biŋgêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ôŋga biŋ êpi nêm lau atom. Ma embe ôkô mêtôcwaga laŋônêm naŋ ôkic nêm ŋac wacbaŋ aôm nê biŋ ôwiŋ atom gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Têmtac endec lasitêwa atom, awa biŋ sa êndêŋ ŋac wacbaŋ amac gebe awê kaiŋ sec êtu eŋŋa atom. ");
INSERT INTO jae_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ôkêŋ ŋagêjô ma ôê têmtac ŋandaŋ êndêŋ taômnêm lau teŋ tôŋ atom, mago têmtac êwiŋ lau wacbaŋ aôm amboac têmtac gêwiŋ taôm, gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Ajop aêŋoc ŋagôliŋ tonec gebe akêŋ bôc kaiŋ luagêc sêŋgêli tauŋ atom. Ma apalip ŋawê kaiŋ luagêc êsêp kôm tageŋ atom, ma asô ŋakwê, taŋ sêwa ŋa gam kaiŋ luagêc kêsêp taulêlôm naŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Embe ŋac teŋ ênêc êwiŋ awê teŋ, taŋ sê eŋ gêdêŋ ŋac teŋ gebe ênam ôli êtu ênê gêŋômao, mago gêjam ôli su me sêwi eŋ siŋ su atom tageŋ naŋ, go akêŋ ŋagêjô, mago êsêagêc sêmac êndu lulugeŋ atom, gebe sêwi awê siŋ kêtu taunê ŋatauo su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mago ŋac tau êkôc domba kapoac teŋ êna becobo ŋakatam gebe êkêŋ êtu datôp êndêŋ Apômtau êtu eŋ tauŋa. ");
INSERT INTO jae_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ma dabuŋwaga ê wama ŋac tau ŋa domba kapoac datôpŋa tonaŋ êkô Apômtau laŋônêm êtu sec, taŋ eŋ gêgôm naŋŋa. Ma Anôtô oc êsuc sec, taŋ ŋac tau gêgôm naŋ, ôkwi. ");
INSERT INTO jae_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Êndêŋ taŋ asô gamêŋ tau ma asê ka ŋanô aniŋŋa tokaiŋ-tokaiŋ naŋ, go alic ŋanô tau amboac gêŋ selec êtôm aniŋŋa atom e jala têlêac êmbacnê acgom. ");
INSERT INTO jae_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ma êndêŋ jala êtu aclê ŋanô samob êtu gêŋ dabuŋ ma êtu da lambiŋŋa êndêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mago êndêŋ jala êtu lemeŋteŋ aniŋ kaŋanô tau gebe ênam ŋanô taêsam êndêŋ jala samob, taŋ êndaŋguc naŋ. Apômtau, amacnêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Aniŋ gêŋ todec teŋ atomanô. Aoc biŋ lasê to aŋgôm mectomaŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Akapiŋ nêm môkêmlauŋ su aŋga môkêmapac atom ma êm ŋasaô êtu dambê atom. ");
INSERT INTO jae_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Asa nêm ôlim êtu ŋacmatêŋa me anac bô teŋ êpi taôm ôlim atom gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Ôkêŋ latômo êtu awê mockaiŋo gebe mockaiŋ ênam gamêŋ auc e sec ênam sêga aŋga gamêŋ tau atom. ");
INSERT INTO jae_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Taêm ênam ŋoc om gebe dabuŋ ma ômansaŋ ŋapep ma otoc ŋoc andu dabuŋ sa gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Naandêŋ lau, taŋ sêkalem lau katuŋ naŋ, to lau mectomaŋŋa ana atom. Embe aŋgôm oc aŋgôm amac selec ŋapaliŋ gebe Apômtau, amacnêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ôndi sa êtu ŋac tomôdêŋa to otoc ŋamalacanô sa ma ôtêc aômnêm Anôtô gebe Apômtau aê. ");
INSERT INTO jae_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Embe ŋac jaba teŋ êmoa êwiŋ aôm aŋga nêm gamêŋ, go ôtu kasec eŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ŋac jaba êmoa êwiŋ aôm êtôm nêm lasitêwa teŋ ma aôm têmtac êwiŋ eŋ amboac têmtac gêwiŋ taôm, gebe amac taôm atu lau jaba gêmuŋŋa aŋga gamêŋ Aiguptu, gebe Apômtau, amacnêm Anôtô aê. ");
INSERT INTO jae_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Amêtôc lau eso atom. Anam dôŋ gêŋ baliŋ to ŋawapac ma taêsamŋa ôkwi gebe ansau lau atom. ");
INSERT INTO jae_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Nêm dôŋ gêdêŋ ênêc êtu gêŋ ŋawapacŋa ma gadob to laclu anam dôŋ gêŋ êsêpŋa naŋ, solop amboac tonaŋgeŋ gebe Apômtau, amacnêm Anôtô, taŋ gawê amac aŋga gamêŋ Aiguptu amêŋ naŋ, aê. ");
INSERT INTO jae_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ma ajop ŋoc ŋagôliŋ to ŋoc jatu samob ma aŋgôm ŋanô êsa gebe Apômtau aê.” ");
INSERT INTO jae_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ôsôm êndêŋ lau Israel gebe Apômtaunê om toê-toê, taŋ amac asam gebe dabuŋ ma akac taôm sa naŋ, tonec. ");
INSERT INTO jae_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Anam nêm kôm êtôm bêc 6, mago êndêŋ bêc êtu 7 êtu bêc lêwaŋŋa ŋanô akac saŋa dabuŋ teŋ. Anam kôm teŋ atom. Bêc tonaŋ êtu Apômtau tau nê om aŋga nêm gamêŋ samob. ");
INSERT INTO jae_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Bêc tonec kêtu Apômtaunê om toê-toê, taŋ eŋ kêkêŋ naŋ. Akalem lau sa êndêŋ ŋanoc gebe akac taôm sa ma alic om dabuŋ tau. ");
INSERT INTO jae_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Êndêŋ ajôŋ ŋamataŋa ŋabêc 14 ŋaêtulala naŋ alic Apômtaunê Om Pasa. ");
INSERT INTO jae_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ma êndêŋ ajôŋ tonaŋgeŋ ŋabêc 15 alic Apômtaunê om Polom Ŋalucŋa. Êndêŋ bêc 7 aniŋ polom ŋaluc. ");
INSERT INTO jae_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Êndêŋ bêc ŋamataŋa tonaŋ akac sa to alic om dabuŋ. Anam kôm teŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mago akêŋ daja êndêŋ Apômtau êtôm bêc 7 tonaŋ ma êndêŋ bêc êtu 7 oc alic om dabuŋ teŋ êtiam ma anam kôm atom.” ");
INSERT INTO jae_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Ôsôm êndêŋ lau Israel gebe êndêŋ taŋ aô lasê gamêŋ tau, taŋ aê jakêŋ êndêŋ amac ma aniŋ gêŋ lasê naŋ, go amac akêŋ kôm ŋanô ŋamêc êndêŋ dabuŋwaga ");
INSERT INTO jae_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ma eŋ ênsuŋ nêm gêŋ tonaŋ êndêŋ Apômtau êna gebe eŋ êlic amac ŋajam. Sabat su ma ŋaeleŋ dabuŋwaga êŋgôm gêŋ tau. ");
INSERT INTO jae_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ma êndêŋ bêc, taŋ ansuŋ nêm gêŋ tonaŋ naŋ, akêŋ domba ŋalatu kapoac ŋajam teŋ ŋajala tageŋŋa êtu daja êndêŋ Apômtau êwiŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ma akêŋ da keleŋ tonec êwiŋ gebe polom matac êtôm gêŋ 10 ŋaluagêc sêŋgaluŋ êwiŋ katêkwi êtu daja êndêŋ Apômtau gebe êŋu ŋamalu ŋajam ma akêŋ wain ŋatêkwi kekec teŋ êwiŋ êtu da. ");
INSERT INTO jae_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Aniŋ polom matac ma sigob me kêsôcŋa teŋ aŋga kôm wakuc atomanô e êndêŋ bêc, taŋ amac akêŋ nêm da êndêŋ nêm Anôtô su acgom. Biŋ tonaŋ êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ êndêŋ gôlôac to gôlôac êtôm nêm gamêŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Sabat, taŋ amac akêŋ da onaŋ su naŋ, ŋaeleŋ go asa woke sa e êtôm woke samuc 7. ");
INSERT INTO jae_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Asa bêc 50 sa e êtap bêc, taŋ êndaŋguc Sabat êtu 7 naŋ sa, go akêŋ da polom wakucŋa teŋ êndêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Akôc polom sigob luagêc aŋga nêm andu amêŋ gebe êtu da. Sêmansaŋ polom tonaŋ ŋa polom matac ŋajam ma sêpac ŋa jist êtu kôm ŋanô ŋamêc êndêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“Ma akêŋ domba ŋalatu ŋajam 7 ŋajala tageŋ ma bulimakao kapoac wakuc teŋ ma domba kapoac luagêc êwiŋ polom tonaŋ êtu daja êndêŋ Apômtau. Êwiŋ da gêŋ kômŋa to da gêŋ têkwiŋa oc êtu daja, taŋ ŋamalu ênac Apômtau mataanô ŋajam naŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ma akêŋ noniŋ kapoac teŋ êtu da êjô secŋa to domba ŋalatu kapoac luagêc, taŋ ŋajala tageŋ naŋ, êtu dawamaŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ma dabuŋwaga ênsuŋ gêŋ tonaŋ êwiŋ polom ŋamêc êtu da daiŋdaiŋ êndêŋ Apômtau êwiŋ domba ŋalatu luagêc. Gêŋ tau êtu Apômtaunê gêŋ ma dabuŋwaga êwê kaiŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Êndêŋ bêc tau amac akac taôm sa gebe êtu om dabuŋ ma anam kôm kapôêŋ atom. Tonaŋ êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ êtu nêm wakucŋa êtôm amacnêm gamêŋ samob. ");
INSERT INTO jae_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Ma êndêŋ taŋ amac anac nêm kôm ŋanô sa naŋ, go anac sa e êndêŋ kôm ŋamadiŋ samucgeŋ atom, ma ajoŋ gêŋ ŋasaliŋ-saliŋ sa êtu ŋamu atom. Awi siŋ êndêŋ lau ŋalêlôm sawa to lau jaba gebe Apômtau, amacnêm Anôtô aê.” ");
INSERT INTO jae_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ôsôm êndêŋ lau Israel gebe ajôŋ êtu 7 ŋabêc ŋamataŋa êtu bêc lêwaŋŋa ŋanô teŋ êndêŋ amac. Akac sa ma alic om dabuŋ tau toôndugeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Anam kôm teŋ atom, mago akêŋ da keleŋ teŋ êndêŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ajôŋ êtu 7 tonaŋ ŋabêc 10 êtu bêc Omsêga Wamaŋa. Êtu bêc dabuŋ, taŋ amac akac taôm sa ma anam dabuŋ mo to akêŋ daja êndêŋ Apômtau naŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ma anam kôm êndêŋ bêc tonaŋ atom gebe bêc Omsêga Wamaŋa, ma sê wama amac êndêŋ Apômtau, amacnêm Anôtô. ");
INSERT INTO jae_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Gebe teŋ embe ênam dabuŋ mo êndêŋ bêc tonaŋ atom, oc senseŋ eŋ su aŋga nê lau nêŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ma teŋ embe ênam kôm êndêŋ bêc tonaŋ, aê oc janseŋ eŋ su aŋga nê lau nêŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Anam kôm teŋ atom. Tonaŋ êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ êndêŋ amacnêm wakuc samob êtôm gamêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Bêc tonaŋ êtu bêc lêwaŋŋa ŋanô teŋ êndêŋ amac ma anam dabuŋ mo. Alic om tau anac m êndêŋ ajôŋ tonaŋ ŋabêc 9 ŋaêtulala, ma amansaŋ nêm sabat e naêndêŋ ŋabêc 10 ŋaêtulala.” ");
INSERT INTO jae_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ôsôm êndêŋ lau Israel gebe Êndêŋ ajôŋ tonaŋgeŋ ŋabêc 15 êtu Apômtaunê om sêsam gebe Om Bec. Alic om tonaŋ êtôm bêc 7. ");
INSERT INTO jae_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Êndêŋ bêc ŋamataŋa akac taôm sa gebe alic om dabuŋ teŋ. Anam kôm teŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Êndêŋ bêc 7 tonaŋ akêŋ daja êndêŋ Apômtau. Ma êndêŋ bêc êtu 8 amac akac taôm sa gebe alic om dabuŋ teŋ êtiam ma akêŋ daja teŋ êndêŋ Apômtau. Bêc tonaŋ êtu bêc dabuŋ akac saŋa, tec anam kôm teŋ atom. ");
INSERT INTO jae_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Apômtaunê om toê-toê tau tonaŋ, taŋ amac asôm lasê gebe akac sa ma anam sakiŋ Apômtau gebe akêŋ daja to da keleŋ ma da têkwi. Da samob tonaŋ akêŋ êndêŋ Apômtau êtôm ŋanoc solopgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Alic om tonaŋ naêwiŋ Apômtaunê sabat to êwiŋ nêm gêŋ ŋagêdô, taŋ ajac mata ma akêŋ kêtu nêm ŋalêlôm kêkac amacŋa gebe akêŋ êndêŋ Apômtau naŋ.” ");
INSERT INTO jae_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Êndêŋ ajôŋ 7 ŋabêc 15 embe anac nêm kôm ŋanô samob sa êmbacnê naŋ, alic Apômtaunê om êtôm bêc 7. Bêc ŋamataŋa êtu bêc lêwaŋŋa ŋanô teŋ ma bêc êtu 8 amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Êndêŋ bêc ŋamataŋa amac ajoŋ ka ŋanô ŋajam-ŋajam to tômtôm ŋalauŋ ma lêsô ma atu samuc amoa Apômtau, amacnêm Anôtô, laŋônêm êtôm bêc 7. ");
INSERT INTO jae_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Alic Apômtaunê om êtôm bêc 7 êtôm jalageŋ. Tonaŋ êtu ŋagôliŋ ênêc endeŋ tôŋgeŋŋa teŋ êndêŋ nêm wakuc samob. Alic om tau êndêŋ ajôŋ êtu 7ŋa. ");
INSERT INTO jae_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Aŋgôŋ bec êtôm bêc 7 tonaŋ. Lau Israel ŋanô samob sêŋgôŋ becgeŋ. ");
INSERT INTO jae_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Gebe nêm wakuc to nêŋ wakuc sêjala gebe aê kakêŋ lau Israel sêŋgôŋ bec gêdêŋ taŋ aê kakôc êsêac sêsa aŋga gamêŋ Aiguptuŋa sêmêŋ naŋ. Apômtau, amacnêm Anôtô aê.” ");
INSERT INTO jae_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Amboac tonaŋ Mose kêkêŋ om, taŋ Apômtau kêjatu naŋ, ŋawae gêdêŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ôsôm biŋ êndêŋ Aron to latui gebe Anam mec lau Israel ma asôm amboac tonec gebe ");
INSERT INTO jae_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Apômtau ênam mec aôm ma ejop aôm. ");
INSERT INTO jae_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Apômtau êkêŋ laŋôanô êpô aôm ma taê labu aôm. ");
INSERT INTO jae_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Apômtau êsa laŋôanô sa êndêŋ aôm ma êkêŋ têmtac êtu malô.’ ");
INSERT INTO jae_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Êsêac sêkêŋ ŋoc ŋaê ênsac lau Israel ŋaô, go aê gabe janam mec êsêac.” ");
INSERT INTO jae_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Gêdêŋ bêc, taŋ sêkwê lômbec tau sa naŋ, tao majaŋ mêŋkêgadê Anôtônê biŋsu ŋabec tau. Ma gêdêŋ kêtula tao mêŋkêkô andu ŋaô amboac ja e geleŋŋa. ");
INSERT INTO jae_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tao majaŋ kêgadê andu gêdêŋ ocsalô ma tao ja kêkô ŋaô gêdêŋ gêbêc gêjô tau-gêjô tau ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tao embe êôŋ sa aŋga lômbec, go lau Israel sêndi. Ma embe naêsêp gamêŋ teŋ, go lau Israel sê nêŋ bec aŋga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Apômtaunê biŋ kêjatu lau Israel, gebe sêndi ma Apômtaunê biŋ kêjatu êsêac, gebe sê nêŋ bec. Êsêac sêmoa gamêŋ tau êtôm bêc, taŋ tao êŋgandê lômbec auc naŋ. ");
INSERT INTO jae_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tao embe êŋgandê lômbec auc bêc taêsam, go lau Israel sêsô Apômtaunê biŋ ŋalabu ma sêndi atom. ");
INSERT INTO jae_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ŋasawa ŋagêdô tao kêgadê lômbec auc bêc gwalêkiŋ atom, tec êsêac sêmoa gamêŋ tau kêtôm Apômtaunê biŋ kêjatu ma dêdi kêtôm Apômtaunê jatu. ");
INSERT INTO jae_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ŋasawa ŋagêdô tao kêkô gêdêŋ kêtula e gêdêŋ bêbêcgeŋ ma gêdêŋ taŋ gêôŋ sa gêdêŋ bêbêcgeŋ naŋ, êsêac dêdi. Me tao embe gacgeŋ êkô êndêŋ ocsalô teŋ ma êmbêc teŋ, ma embe êôŋ sa êndêŋ tonaŋ, go sêndi amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tao embe êŋgandê lômbec auc bêc luagêc me ajôŋ samuc teŋ me ŋasawa baliŋ ec, go lau Israel sêmoa gamêŋ tau ma sêndi atom. Mago tao embe êôŋ sa, naŋ êsêac sêndi amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Êsêac sê nêŋ bec kêtôm Apômtaunê jatu ma dêdi kêtôm Apômtaunê jatu. Êsêac sêsô Apômtaunê biŋ ŋalabu kêtôm Apômtaunê jatu, taŋ Mose kêsôm lasê naŋ. 10:1-32 Lau Israel dêdi aŋga lôc Sinai ma sêwi gamêŋ sawa siŋ ma sepeŋ gamêŋ, taŋ Anôtô gêjac mata gebe êkêŋ êndêŋ êsêac ŋamiŋ kêsêp ŋasawa tonec. ");
INSERT INTO jae_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Amboac tonaŋ êsêac dêdi aŋga Apômtaunê lôc ma sêsêlêŋ bêc têlêac ma Apômtaunê katapa poacŋa kêsêlêŋ bêc têlêac gêmuŋ êsêac gebe têtap gamêŋ sêlêwaŋ tauŋŋa teŋ sa. ");
INSERT INTO jae_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kêtôm têm samob, taŋ êsêac dêdi naŋ, Apômtaunê tao kêkô êsêac ŋaô gêdêŋ ocsalô. ");
INSERT INTO jae_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Gêdêŋ taŋ sêbalaŋ katapa poacŋa sa naŋ, Mose kêsôm gebe “O Apômtau, ôndimaŋ, ma nêm ŋacjo sêc êliŋ-êliŋ ma êsêac, taŋ têntac gedec aôm naŋ, sêc su aŋga laŋômnêmŋa.” ");
INSERT INTO jae_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ma gêdêŋ taŋ sêlêwaŋ katapa kêkô naŋ, Mose kêsôm gebe “O Apômtau, ômu ôndêŋ lau Israel nêŋ toŋ 1,000 to 1,000 ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ma lau sêli aweŋ sa kêtu gêŋ masiŋa jakêsô Apômtau taŋasuŋ. Apômtau gêŋô biŋ tau e têtac ŋandaŋ kêsa. Ma Apômtaunê ja gelom aŋga êsêac ŋalêlôm e geŋ gamêŋ, taŋ sê bec kêsêpŋa naŋ, ŋamagê su. ");
INSERT INTO jae_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Go lau têtaŋ gêdêŋ Mose ma Mose keteŋ Apômtau, tec ja gêmac. ");
INSERT INTO jae_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Êsêac sêsam gamêŋ tonaŋ gebe Tabera gebe Apômtaunê ja gelom aŋga êsêac ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Lau jaba, taŋ sêwiŋ lau Israel naŋ, têtu meloc gwada ma lau Israel têtaŋ kêtiam amboac tonaŋgeŋ ma sêsôm gebe “Ojae, asa êkêŋ gwada êndêŋ aêac taniŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Aêac taêŋ gêjam i, taŋ taeŋ ŋaômageŋ aŋga gamêŋ Aiguptuŋa naŋ, ma katim to meleŋ ma laki to anian ma lomboc. ");
INSERT INTO jae_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mago galoc nêŋ ôliŋwalô gêbacnê. Gêŋ ŋajam teŋ gêc atom. Mateŋ gê mana tageŋ.” ");
INSERT INTO jae_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana tau kêtôm mêcgauc ma ŋalaŋô kêtôm uc ŋatêkwi, taŋ ŋajaŋa kêsa naŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Lau sêsêlêŋ-sêsêlêŋ ma sejoŋ gêŋ tau sa jasêlêsa popoc me sepeŋ kêsêp toŋtoŋ. Go seno kêsêp ku ma sêpac polom tapa-tapa. Gêŋ tau ŋasaê kêtôm polom tapa-tapa, taŋ sêpac ŋa ŋalêsi naŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Gêdêŋ gêbêc maniŋ kêsêp nêŋ gamêŋ becŋa ma mana kêsêp gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose gêŋô launêŋ gôlôac têtaŋ gêdêŋ-gêdêŋgeŋ sêŋgôŋ nêŋ bec ŋasacgêdô, tec Apômtau têtac ŋandaŋ kêsa ŋanô ma Mose gêlic sec amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Go Mose kêsôm gêdêŋ Apômtau gebe “Aôm gôgôm nêm sakiŋwaga sec kêtu asageŋŋa. Ma aê gajac matamanô ŋajam atom kêtu asageŋŋa, tec kôkêŋ lau samob tonec nêŋ gêŋwapac kêkôniŋ aê. ");
INSERT INTO jae_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Aê kakêkam lau samob tonaŋ e kakôc êsêac me, tec aôm kôsôm gêdêŋ aê gebe ‘Ôsip êsêac sa êtôm jaomwagao kêsip ŋapalê dedec, taŋ gênôm su naŋ, ma ôkêŋ êsêac sêna gamêŋ, taŋ aê katôc lemoc, gebe jakêŋ êndêŋ tameŋi naŋ.’ Amboac tonaŋ me. ");
INSERT INTO jae_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Aê jakôc gwada aŋga ondoc, gebe jakêŋ êndêŋ lau tonec sêniŋ. Êsêac têtaŋ gêdêŋ aê ma sêsôm gebe ‘Ôkêŋ gwada êndêŋ aêac aniŋmaŋ.’ ");
INSERT INTO jae_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Aê taucgeŋ jaôc lau samob tonaŋ nêŋ gêŋwapac jatôm atom, gebe ŋawapac sec. ");
INSERT INTO jae_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Mago aôm embe taêm ênam gebe ôŋgôm aê amboac tonaŋ, naŋgo ônac aê êndu, go jajala gebe gajac matamanô ŋajam ma jalic gêŋwapac, taŋ êtap aê sa naŋ, atom.” ");
INSERT INTO jae_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôjaliŋ ŋoc lau 70 sa aŋga lau Israel nêŋ laumata, taŋ kôjala êsêac têtu launêŋ laumata to gejobwaga. Ôwê êsêac sêna lômbec ma ôndênaŋ êsêac sêkô tônê sêwiŋ aôm. ");
INSERT INTO jae_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Su, go aê jasêp jawac ma janam biŋgalôm jawiŋ aôm. Go jakôc ŋalau, taŋ kêpi aôm naŋ, ŋagêdo su ma jakêŋ elom êsêac ma êsêac sêôc launêŋ gêŋwapac sêwiŋ aôm, gebe aôm taômgeŋ ôc gêŋwapac tau êtiam atom. ");
INSERT INTO jae_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Go ôsôm êndêŋ lau gebe ‘Anam dabuŋ taôm êtu eleŋŋa, go atap gwada sa, gebe amac ataŋ kêsô Apômtau taŋasuŋ gebe “Asa oc êkêŋ gwada êndêŋ aêac aniŋ. Aŋga Aiguptu tec amoa ŋajamgen.” Kêtu tonaŋŋa Apômtau êkêŋ gwada êndêŋ amac aniŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Eŋ êkêŋ gwada bêc tageŋ me luagêc me lemeŋ teŋ me 10 me 20 atom, ");
INSERT INTO jae_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","amac aniŋ gwada ajôŋ samuc teŋ e ôlim ŋakam êsa ma nêm ŋalêlôm êli amac. Biŋ tonaŋ êtap amac sa gebe atiŋ Apômtau, tec gêmoa gêwiŋ amac nec, su ma ataŋ to asôm gêdêŋ eŋ gebe “Aêac awi Aiguptu siŋ kêtu asageŋŋa.” ’” ");
INSERT INTO jae_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ma Mose kêsôm gebe “Aê gamoa gawiŋ siŋwaga 600,000 ma aôm kôsôm gebe ‘Aê oc jakêŋ gwada êndêŋ amac aniŋ êtôm ajôŋ samuc teŋ.’ ");
INSERT INTO jae_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Êsêac sêmbuc domba to bulimakao e êtôm êsêac me. Me i gwêcŋa samob sêpi tageŋ, go êtôm êsêac me.” ");
INSERT INTO jae_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mago Apômtau kêsôm gêdêŋ Mose gebe “Amboac ondoc, Apômtau lêma kêtu dambê me. Galoc aôm oc ôlic gebe ŋoc biŋ, taŋ gajac mata gêdêŋ aôm naŋ, oc ŋanô me masi.” ");
INSERT INTO jae_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Go Mose kêsa gêja ma kêsôm Apômtaunê biŋ gêdêŋ lau, ma kêjaliŋ lau 70 sa aŋga lau Israel nêŋ laumata ma kêdênaŋ êsêac sêkô sêgi lômbec auc. ");
INSERT INTO jae_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Su, go Apômtau kêsêp gêmêŋ totaogeŋ mêŋkêsôm biŋ gêdêŋ Mose ma kêkôc ŋalau, taŋ kêpi Mose naŋ, ŋagêdô su, ma kêkêŋ gelom laumata 70. Ŋalau gelom êsêac e sep tageŋ seoc biŋ lasê ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ma ŋac luagêc gacgeŋ sêmoa gamêŋ becŋa. Ŋac teŋ nê ŋaê Eldad, ma teŋ nê Medad. Ma ŋalau gelom êsêagêc gêwiŋ. Êsêagêcnêŋ ŋaê kêsêp laumatanêŋ ŋaêmôkê gêwiŋ, tageŋ êsêagêc sêsa lômbec sêja sêwiŋ atom. Mago êsêagêc seoc biŋ lasê sêmoa gamêŋ becŋa. ");
INSERT INTO jae_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ma ŋapalê teŋ kêlêti gêdêŋ Mose gêja ma kêsôm gêdêŋ eŋ gebe “Eldad agêc Medad seoc biŋ lasê sêmoa gamêŋ becŋa.” ");
INSERT INTO jae_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Go Mosenê sakiŋwaga Nun latu Josua, taŋ Mose kêjaliŋ eŋ sa gêwiŋ laumata naŋ, kêsôm gebe “O ŋoc ŋatau Mose, ônac jao biŋ tau êndêŋ êsêagêc.” ");
INSERT INTO jae_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mago Mose kêsôm gêdêŋ eŋ gebe “Aôm gobe ômêtôc êsêagêc ôjô aê su me. Aê gabe Apômtau êkêŋ nê Ŋalau êpi nê lau samob e samob seoc biŋ lasê.” ");
INSERT INTO jae_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Su, go Mose to lau Israel nêŋ laumata sêmu sêja gamêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Go Apômtau kêkêŋ mu kêsêlêŋ ma kejoŋ kêmbico aŋga gwêc gêmêŋ. Mu tau kêpalip kêmbico kêsêp gamêŋ becŋa e gêjam gamêŋ, taŋ kêgi gamêŋ becŋa naŋ, auc samucgeŋ. Lau embe sêsêlêŋ oc samuc teŋ sêmu sêsa me oc samuc teŋ sêmu sêsô, oc têtap kêmbico sa ŋapaŋ. Kêmbico sêŋgôŋ tauŋ ŋaô-ŋaô e ŋadani kêtôm kêdabiŋ meta samuc teŋ luagêc. ");
INSERT INTO jae_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Tec lau dêdi gêdêŋ bêc tonaŋ ma sejoŋ kêmbico oc samuc ma gêbêc samuc ma ŋageleŋ oc samucgeŋ kêtiam. Lau, taŋ sejoŋ sêjac ŋawae atom naŋ, têtap gadob 10 sa. Êsêac têta gêŋ tau e gêjam naŋ gamêŋ becŋa auc gebe ŋakeleŋ êsa. ");
INSERT INTO jae_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Êsêac sêsac gwada tau e têdaŋgôŋ su atom, ma Apômtau têtac ŋandaŋ kêsa gêdêŋ lau tau, tec gêjac êsêac ŋa gêmac kapôêŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kêtu tonaŋŋa sêsam gamêŋ tonaŋ gebe Kibrot-Hatawa, gebe sêsuŋ lau mateŋ katu gwadaŋa aŋga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Êsêac dêdi aŋga Kibrot-Hatawa ma sêlêlêŋ sêja Hasarot. Ma êsêac sêmoa Hasarot tau. ");
INSERT INTO jae_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam agêc Aron sêli aweŋ sa gêdêŋ Mose kêtu awê Kusŋa, taŋ eŋ gêjam kêtu nê awê naŋ, gebe eŋ gêjam awê Kusŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ma êsêagêc sêsôm gebe “Apômtau kêsôm biŋ gêdêŋ Mose taugeŋ biŋŋanô me masi. Eŋ kêsôm gêdêŋ aêagêc gêwiŋ atom me.” Ma Apômtau gêŋô biŋ tau. ");
INSERT INTO jae_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mose eŋ ŋac malô kêlêlêc lau samob, taŋ sêmoa nom ŋagamêŋ naŋ, su. ");
INSERT INTO jae_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ma ŋagaôgeŋ Apômtau kêsôm gêdêŋ Mose agêc Aron ma Miriam gebe “Amac lau têlêac asa andêŋ becobo takac saŋa ana.” Ma êsêac têlêac sêsa awê sêja. ");
INSERT INTO jae_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ma Apômtau kêsêp totaogeŋ mêŋkêkô becobo ŋakatam ma gêmôêc Aron agêc Miriam, go êsêagêc sêsa jatêtu gasuc eŋ. ");
INSERT INTO jae_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Go eŋ kêsôm gebe “Aŋô aêŋoc biŋ. Embe propete teŋ êmoa amac ŋalêlôm, go aê Apômtau jaoc tauc lasê êndêŋ eŋ ŋa gêŋ ŋakatu ma janam biŋgalôm jawiŋ eŋ ŋa mê. ");
INSERT INTO jae_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mago lêŋ jaoc tauc lasê êndêŋ ŋoc sakiŋwaga Mose êtôm tonaŋ atom. Aê kakêŋ eŋ gebe ejop aêŋoc andu ŋagêŋlêlôm samob. ");
INSERT INTO jae_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Aêagêc ajam biŋgalôm aôc tauŋma aweŋkasi. Aê kasôm biŋ gêc awêgeŋ ma kasiŋ biŋ teŋ ôkwi atom. Eŋ gêlic Apômtau kêpi ŋanô. Kêtu asageŋŋa amagêc atêc taôm atom ma asôm biŋ kêpi ŋoc sakiŋwaga Mose.” ");
INSERT INTO jae_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Osakiŋ lau gebe sêkêŋ keleŋ gamêŋ Kanaan, taŋ gabe jakêŋ êndêŋ lau Israel naŋ. Ôsakiŋ nêŋ laumata tageŋ-tageŋ êtôm tameŋinêŋ gôlôacmôkêgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Amboac tonaŋ Mose kêdaguc Apômtaunê jatu ma kêsakiŋ lau, taŋ têtu lau Israel nêŋ laumata naŋ, dêdi aŋga gamêŋ sawa Paran sêja. ");
INSERT INTO jae_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Êsêac sêkêŋ keleŋ gamêŋ tau kêtôm bêc 40 su, go sêmu sêja kêtiam. ");
INSERT INTO jae_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Êsêac sêsêlêŋ e sêô lasê dêdêŋ Mose agêc Aron ma lau Israel nêŋ gôlôac samob aŋga Kades, taŋ gêc gamêŋ sawa Taran naŋ. Êsêac sêjac miŋ nêŋ biŋ gêdêŋ êsêac to gôlôac samob ma têtôc gamêŋ tau ŋakaŋanô gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ma êsêac sêjac miŋ gêdêŋ Mose ma sêsôm gebe “Aêac jaaô lasê gamêŋ tau kêtôm aôm kôsakiŋ aêac. Gamêŋ tau gamêŋ, taŋ su to lêp keseleŋ naŋ. Ma gamêŋ tau ŋakaŋanô tonec. ");
INSERT INTO jae_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mago lau, taŋ sêŋgôŋ gamêŋ tau naŋ, lau ŋajaŋa ma tuŋbôm kêgi nêŋ malac kapôêŋ auc. Ma teŋ, aêac alic Anaknê wakuc. ");
INSERT INTO jae_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Lau Amalek sêŋgôŋ gamêŋ Negeb, lau Het to Jebus ma Amor sêŋgôŋ lôc ma lau Kanaan sêŋgôŋ gwêclêndaŋ to bu Jordan ŋatali.” ");
INSERT INTO jae_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mago Kaleb gêjam malô launêŋ ŋalêlôm kêkô Mose laŋônêmŋa ma kêsôm gebe “Aêac tapi gamêŋ tau sebeŋ tana ma tajaŋgo gamêŋ su, gebe aêac tatôm gebe taku gamêŋ tau tulu.” ");
INSERT INTO jae_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Go lau, taŋ sêpi gamêŋ tau sêwiŋ eŋ sêja naŋ, sêsôm gebe “Aêac tatôm gebe tapi dandêŋ lau tônê tana atom, gebe êsêac lau ŋajaŋa sec sêlêlêc aêac su.” ");
INSERT INTO jae_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Êsêac sêgôliŋ biŋ kêpi gamêŋ, taŋ jasekeleŋ naŋ, ma sêsôm gêdêŋ lau Israel gebe “Gamêŋ, taŋ aêac ajac laoc to akeleŋ naŋ, gamêŋ kaiŋ teŋ, taŋ geseŋ lau gamêŋ tauŋa su. Ma lau samob, taŋ alic aŋga gamêŋ naŋ, lau waso-waso sec. ");
INSERT INTO jae_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ma aêac alic lau ŋadambê kapôêŋ sec aŋga tônê. Lau tau Anaknê lau. Ma aêac asaê tauŋ gebe sauŋanô atôm wagô, ma êsêac sêlic aêac sauŋanô atôm wagô amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Go lau samob sêpuc taŋiboa sa ma têtaŋ gêdêŋ gêbêc samuc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ma lau Israel samob sêli aweŋ sa gêdêŋ Mose agêc Aron ma samob sêsôm gêdêŋ êsêagêc gebe “Ojae, aêac tamac êndu aŋga Aiguptumaŋ me tamac êndu aŋga gamêŋ sawa tonecmaŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Apômtau gebe êwê aêac natasa gamêŋ tônê êtu ageŋŋa. Eŋ gebe siŋ enseŋ aêac su to ŋacjo sêjaŋgo aêacnêŋ lauo to gôlôac ŋasec-ŋasec me. Aêac embe tamu tana Aiguptu, oc êmoasiŋ aêac êlêlêc su atom me.” ");
INSERT INTO jae_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Go sêsôm gêdêŋ tauŋ gebe “Aêac tajaliŋ nêŋ laumata teŋ sa ma tamu tana Aiguptu.” ");
INSERT INTO jae_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Go Mose agêc Aron sêu tauŋ e laŋôŋanô jagêdêŋ nom lau Israel nêŋ gôlôac samob sêlic. ");
INSERT INTO jae_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ma Nun latu Josua agêc Jepune latu Kaleb, ŋaclagêc, taŋ sekeleŋ gamêŋ tau sêwiŋ lau ŋagêdô naŋ, sêkac nêŋ ŋakwê gêŋgic ");
INSERT INTO jae_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ma sêsôm gêdêŋ lau Israel nêŋ gôlôac samob gebe “Gamêŋ, taŋ aêac ajac laoc ma akeleŋ naŋ, gamêŋ ŋajamanô. ");
INSERT INTO jae_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Apômtau embe êlic aêac ŋajam, go êwê aêac tasa gamêŋ tau tana ma êkêŋ êndêŋ aêac. Su to lêp keseleŋ ŋamala tônê. ");
INSERT INTO jae_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Tageŋ ali awem sa êndêŋ Apômtau atom, ma atêc lau gamêŋ tônêŋa atom, gebe êsêac oc têtu aêacnêŋ mo ma nêŋ lamu gêc su aŋga êsêacnêŋ. Ma Apômtau gêmoa gêwiŋ aêac. Atêc êsêac atom.” ");
INSERT INTO jae_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ma gôlôac samob sêsôm sebe têtuc êsêagêc ŋa poc êndu. Go Apômtaunê ŋawasi geoc tau lasê gêdêŋ lau Israel samob aŋga lômbec. ");
INSERT INTO jae_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ma Apômtau kêsôm gêdêŋ Mose gebe “Aê gagôm gêŋtalô aŋga êsêacnêŋ, mago lau tau laŋôŋ gelo aê ŋapaŋ to sêkêŋ gêwiŋ aê atom nec, sebe sêŋgôm e êndêŋ ondocgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Aê gabe jakôniŋ êsêac ŋa kole to janseŋ êsêac su ma jakêŋ aôm ôtu lau-m kapôêŋ to ŋaclai ôlêlêc êsêac su.” ");
INSERT INTO jae_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mago Mose kêsôm gêdêŋ Apômtau gebe “Lau Aiguptu oc sêŋô ŋawae gebe aôm gôwê lau tonec toŋaclaigeŋ sêsa aŋga êsêacnêŋ sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Êsêac oc sêsôm biŋ tau ŋawae êndêŋ lau, taŋ sêŋgôŋ gamêŋ tônê naŋ. O Apômtau, êsêac sêŋô ŋawae gebe aôm taôm gômoa lau tonec ŋalêlôm ma goc taôm lasê gêdêŋ êsêac sêlic ŋa mateŋanô. Êsêac sêŋô gebe nêm tao kêkô lau Israel ŋaô ma nêm tao majaŋ kêsêlêŋ gêwiŋ êsêac gêdêŋ ocsalô to tao ja gêdêŋ gêbêc. ");
INSERT INTO jae_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Embe onseŋ lau tonec su weŋ tageŋ êtôm ŋac tageŋ, go lau tomôkê-tomôkê, taŋ sêŋô aôm ŋawae naŋ, oc sêsôm gebe ");
INSERT INTO jae_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Kec, Apômtau gêjac mata gamêŋ gêdêŋ lau Israel ma kêtôc lêma gebe êkêŋ gamêŋ tau êndêŋ êsêac, mago eŋ kêtôm atom, gebe êwê êsêac nasêsa gamêŋ tau, tec geseŋ êsêac su aŋga gamêŋ sawa.’ ");
INSERT INTO jae_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","O Apômtau, galoc aê jateŋ aôm gebe ôwa nêm ŋaclai sa êtôm biŋ, taŋ taôm kôsôm naŋ gebe ");
INSERT INTO jae_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Apômtau eŋ gê biŋ tôŋ ma nê têtac gêwiŋ teŋgeŋŋa ŋatêku masi. Eŋ kêsuc launêŋ sec to sêgêli biŋŋa ôkwi. Mago eŋ oc êlic biŋ ŋagêjôŋa siŋ samucgeŋ atom. Eŋ oc êkêŋ tameŋinêŋ sec ŋagêjô êndêŋ latuŋi to dêbuŋi ma abeŋi.’ ");
INSERT INTO jae_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Aê jateŋ aôm, ôsuc lau tonec nêŋ sec ôkwi êtu nêm têmtac gêwiŋ teŋgeŋ kapôêŋŋa ma êtu kôsuc lau tonec nêŋ biŋ ôkwi gêdêŋ taŋ sêwi Aiguptu siŋ e mêŋgêdêŋ galoc naŋŋa.” ");
INSERT INTO jae_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Apômtau kêsôm gebe “Aê oc kasuc êsêacnêŋ biŋ ôkwi kêtôm nêm biŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mago aê gamoa matoc jali ma aêŋoc ŋawasi oc ênam nom ŋagamêŋ samob auc, tec jasôm biŋŋanôgeŋ gebe ");
INSERT INTO jae_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Lau samob, taŋ sêlic ŋoc ŋawasi to ŋoc gêŋtalô, tê gagôm aŋga Aiguptu to gamêŋ sawa nê, ma sêsaê aê kêtu dim 10 su to sêŋô aê aoc atom naŋ, ");
INSERT INTO jae_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","oc sêlic gamêŋ, taŋ gajac mata gêdêŋ tameŋi to katôc lemoc gebe têtap sa naŋ, atom. Ma lau samob, taŋ laŋôŋ gelo aê naŋ, oc nasêô lasê gamêŋ tau atom. ");
INSERT INTO jae_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mago ŋoc sakiŋwaga Kaleb gêwê kaiŋ ŋalau kaiŋ teŋ ma eŋ taŋa wamu aê ŋapep sawa. Kêtu tonaŋŋa aê gabe jawê eŋ êsô gamêŋ, taŋ eŋ jakêsa su naŋ êna, ma gamêŋ tau êtu ênê wakuc nêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Galoc lau Amalek to Kanaan sêŋgôŋ gaboaŋ, tec eleŋŋa andi ma akac taôm ôkwi amu asa gamêŋ sawa asêlêŋ asa intêna Gwêckocŋa ana.” ");
INSERT INTO jae_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ma Apômtau kêsôm biŋ gêdêŋ Mose agêc Aron gebe ");
INSERT INTO jae_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Gôlôac sec tonec sêli aweŋ sa êndêŋ aê e êndêŋ ondocgeŋ. Aê gaŋô lau Israel nêŋ biŋ sêli aweŋ saŋa, taŋ sêgôm gêdêŋ aê naŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ôsôm êndêŋ êsêac gebe Apômtau kêsôm gebe ‘Aê gamoa matoc jali, tec jasôm biŋŋanô. Aê gabe jaŋgôm amacnêm biŋ, taŋ gaŋô amac asôm kêsô aê taŋocsuŋ naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Amac samob, taŋ nêm jala kêtu 20 su ma ali awem sa gêdêŋ aê naŋ, nêm ôlim ê su aŋga gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Biŋŋanô, amac asa gamêŋ, taŋ katôc lemoc gebe aŋgôŋ naŋ, atom. Jepune latu Kaleb agêc Nun latu Josua tauŋgeŋ nasêô lasê. ");
INSERT INTO jae_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ma nêm gôlôac ŋasec-ŋasec, taŋ asôm gebe ŋacjo oc sêjaŋgo êsêac su naŋ, tec jawê êsêac nasêsa gamêŋ tau e sêlic gamêŋ, taŋ amac adec naŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Amac taôm nêm ŋawêlêlaŋ oc ênaŋa aŋga gamêŋ sawa tonec. ");
INSERT INTO jae_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ma amac latômi sejop bôc sêmoa gamêŋ sawa êtôm jala 40 ma sêôc amacnêm taŋempêc ŋagêjô e amac samob aê su aŋga gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Amac akeleŋ gamêŋ tau kêtôm bêc 40, tec aôc nêm keso ŋagêjô êtôm jala 40. Jala teŋ êjô bêc teŋ e nêm kauc êsa êpi gêŋwapac, taŋ ŋam kêsêp gawi amac siŋŋa naŋ.’ ");
INSERT INTO jae_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Aê Apômtau kasôm biŋ tonec. Biŋŋanô, biŋ tonec oc jaŋgôm ŋanô êsa êndêŋ gôlôac sec, taŋ sêboa tauŋ sa gêdêŋ aê. Aŋga gamêŋ sawa tonec êsêac samob oc sênaŋa ma samob oc sêmac êndu aŋga tonec.” ");
INSERT INTO jae_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mago lau, taŋ Mose kêsakiŋ êsêac gebe sekeleŋ gamêŋ ma sêmu sêmêŋ e sêgôliŋ biŋ sec kêpi gamêŋ tau ma sêli gôlôac samob nêŋ ŋalêlôm sa gêdêŋ Mose naŋ, ");
INSERT INTO jae_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","lau tau, taŋ sêgôliŋ biŋ sec kêpi gamêŋ tau naŋ, sêmac êndu sep tageŋ, gebe Apômtau gêjac êsêac. ");
INSERT INTO jae_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Lau, taŋ sêja gebe sekeleŋ gamêŋ naŋ, samob sêmac êndu, Nun latu Josua agêc Jepune latu Kaleb tauŋgeŋ tec sêmoa mateŋ jali. ");
INSERT INTO jae_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose gêjac miŋ biŋ tonaŋ gêdêŋ lau Israel samob, go êsêac têtaŋ taŋiboa kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ma gêdêŋ geleŋ mata êsêac dêdi jasêpi lôc ŋatêpôê ma sêsôm gebe “Ôlic acgom, aêac tec amoa ma abe api gamêŋ, taŋ Apômtau gêjac mata gêdêŋ aêac naŋ, gebe aêac agôm sec.” ");
INSERT INTO jae_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mago Mose kêsôm gebe “Amac abe aŋgêli Apômtaunê biŋ êtu asageŋŋa. Amac oc atôm atom. ");
INSERT INTO jae_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Api ana atom, nêm ŋacjo oc sênac amac, gebe Apômtau gêmoa gêwiŋ amac atom. ");
INSERT INTO jae_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Oc andac lau Amalek to Kanaan ma nêŋ siŋ enseŋ amac su, gebe amac akac taôm su aŋga Apômtaunê, tec Apômtau êmoa êwiŋ amac atom.” ");
INSERT INTO jae_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mago êsêac tetoc tauŋ sa ŋanôgeŋ, tec sêpi lôc ŋatêpôê sêja, tageŋ Apômtaunê katapa poacŋa ma Mose sêwi gamêŋ becŋa siŋ atom. ");
INSERT INTO jae_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Go lau Amalek to Kanaan, taŋ sêŋgôŋ gamêŋ lôcŋa naŋ, sêsêp mêŋsêku êsêac tulu ma sêjanda êsêac êliŋ-êliŋ e jagêdêŋ Horma. ");
INSERT INTO jae_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Gêdêŋ ajôŋ ŋamataŋa lau Israel nêŋ gôlôac samob sêô lasê gamêŋ sawa Sin ma lau sêlêwaŋ tauŋ sêŋgôŋ Kades. Ma Miriam gêmac êndu ma sêsuŋ eŋ aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ma gôlôacnêŋ bu masi, tec sêkac sa jasêli aweŋ sa gêdêŋ Mose agêc Aron. ");
INSERT INTO jae_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ma lau sêôc gêdô Mose ma sêsôm gebe “Ojae, aêac anaŋa awiŋ ma lasitêwai, taŋ Apômtau gêjac êsêac naŋmaŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Amagêc awê Apômtaunê gôlôac mêŋaô lasê gamêŋ sawa tonec gebe aêac amac êndu toma bulimakaogeŋ êtu asageŋŋa. ");
INSERT INTO jae_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Amagêc awê aêac awi Aiguptu siŋ e aô lasê gamêŋ sec tonec kêtu asageŋŋa. Aêac atôm gebe asê gêŋ teŋ atom. Jambô to wain ma aiŋ masi. ma bu anômŋa masi amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Go Mose agêc Aron sêwi gôlôac siŋ sêja lômbec ŋasacgêdô ma sêu tauŋ laŋôŋanô jagêdêŋ nom. Go Apômtaunê ŋawasi geoc tau lasê gêdêŋ êsêagêc. ");
INSERT INTO jae_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ma Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ôkôc nêm tôc ma amagêc têwam Aron akac gôlôac sa sêpi tageŋ. Go ôsôm biŋ êndêŋ poc ôkô êsêac laŋôŋnêm gebe poc êkêŋ bu. Amboac tonaŋ ôŋgôm bu êsa aŋga poc êtu êsêacŋa ma ôkêŋ êndêŋ gôlôac to nêŋ bulimakao sênôm.” ");
INSERT INTO jae_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ma Mose kêkôc tôc, taŋ gêc Apômtaunê gamêŋ naŋ, kêtôm Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Go Mose agêc Aron sêkac gôlôac sa sêpi tageŋ sêkô sêwiŋ poc ma kêsôm gêdêŋ êsêac gebe “Amac gêsômtêkwa-ŋatoŋwaga, aŋô acgom. Aêac oc atôm gebe aŋgôm bu êsa aŋga poc ma akêŋ êndêŋ amac me masi.” ");
INSERT INTO jae_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Go Mose gêôc lêma sa ma gêjac poc ŋa nê tôc kêtu dim luagêc, ma bu kapôêŋ kêsa, ma gôlôac to nêŋ bulimakao sênôm e kêtôm. ");
INSERT INTO jae_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ma Apômtau kêsôm gêdêŋ Mose agêc Aron gebe “Amagêc akêŋ gêwiŋ aê atom to awa aê sa e lau Israel sêlic aê amboac ŋac dabuŋ atom, tec amagêc awê gôlôac tonec e nasêsa gamêŋ, taŋ kakêŋ gêdêŋ êsêac naŋ, atom.” ");
INSERT INTO jae_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Bu tonec bu Meriba, gebe lau Israel sêli aweŋ sa gêdêŋ Apômtau, ma eŋ gêwa tau sa gebe eŋ ŋac dabuŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Go Mose kêsakiŋ lau jaeŋŋa aŋga Kades dêdêŋ kiŋ Edomŋa sêja, ma sêsôm gebe “Aôm lasim Israel gebe êsôm êndêŋ aôm gebe Aôm kôjala gêŋwapac samob, taŋ kêtap aêac sa naŋgac. ");
INSERT INTO jae_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Aêac tamemai sêsêp Aiguptu sêja ma aŋgôŋ Aiguptu ŋasawa baliŋ. Mago lau Aiguptu sêgôm aêac toma tamemai sec. ");
INSERT INTO jae_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Tec aêac aweŋ gêjac Apômtau ma eŋ kêkêŋ taŋa aêac aweŋ to kêsakiŋ aŋela teŋ. Aŋela tau gêwê aêac asa aŋga Aiguptu amêŋ. Ma galoc aêac aŋgôŋ malac Kades, taŋ gêc nêm gamêŋ ŋamadiŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ma galoc aêac ateŋ, gebe ôlôc ma aêac asô nêm gamêŋ awac. Aêac oc asa nêm kôm moŋa to kôm wainŋa atom ma anôm bu aŋga bumata atom. Aêac oc asêlêŋ amoa intênasêgageŋ. Aêac oc awi intêna siŋ amu anôŋa me gasêŋa atom e aô lasê nêm gamêŋ ŋamadiŋ ônêŋa.” ");
INSERT INTO jae_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mago Edom kêsôm gêdêŋ eŋ gebe “Ôsa ŋoc gamêŋ ômôêŋ atom. Embe ôsa ômôêŋ, oc ôndac aêŋoc siŋ.” ");
INSERT INTO jae_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ma lau Israel sêsôm gêdêŋ eŋ gebe “Aêac asêlêŋ amoa intênasêgageŋ. Ma aêac to ma bulimakao embe anôm nêm bu, oc anam ôli bu tau. Aêac abe ateŋ tageŋ tonec, gebe asêlêŋ amoa intênasêgageŋ e aô lasê ŋamadiŋ ônêŋa.” ");
INSERT INTO jae_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mago eŋ kêsôm gebe “Aôm ôsa tonec ômôêŋ atom.” Ma Edomnê lau taêsam sêsa dêdêŋ êsêac sêja toŋajaŋageŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Amboac tonaŋ Edom gedec ma gêlôc, gebe lau Israel sêsa nê gamêŋŋageŋ sêna atom, tec lau Israel sêjac jaê eŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Lau Israel to nêŋ gôlôac samobgeŋ sêsêlêŋ e sêô lasê lôc Horeb. ");
INSERT INTO jae_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Aŋga lôc Horeb, taŋ kêkô lau Edom nêŋ gamêŋ ŋamadiŋ naŋ, Apômtau kêsôm gêdêŋ Mose agêc Aron gebe ");
INSERT INTO jae_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aron naêwiŋ nê lau, gebe eŋ êsa gamêŋ, taŋ kakêŋ gêdêŋ lau Israel naŋ, atom. Eŋ êsa atom gebe amagêc ali awem sa to taŋempêc gêdêŋ ŋoc jatu aŋga bu Meriba. ");
INSERT INTO jae_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Amboac tonaŋ ôkôc Aron agêc latu Eleasar ma ôwê êsêagêc sêpi lôc Horeb sêna. ");
INSERT INTO jae_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Go ôkwalec Aronnê ŋakwê su ma ôkêŋ êndêŋ latu Eleasar êsô sa. Ma Aron êmac êndu aŋga tônê naêwiŋ nê lau.” ");
INSERT INTO jae_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mose gêgôm Apômtaunê jatu ŋanô kêsa ma êsêac sêpi lôc Horeb sêja ma gôlôac samob sêlic. ");
INSERT INTO jae_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ma Mose kêkwalec Aronnê ŋakwê su ma kêkêŋ gêdêŋ ênê latu Eleasar kêsô sa. Go Aron gêmac êndu aŋga lôc ônê. Ma Mose agêc Eleasar sêsêp aŋga lôc sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Gêdêŋ taŋ gôlôac samob sêlic gebe Aron gêmac êndu naŋ, lau Israel nêŋ gôlôac samob têtaŋ taŋiboa kêtu eŋŋa kêtôm bêc 30. ");
INSERT INTO jae_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Gêdêŋ tonaŋ ŋac Kanaanŋa teŋ kêtu kiŋ Aradŋa. Eŋ gêŋgôŋ gamêŋ Negeb. Eŋ gêŋô, gebe lau Israel sêsêlêŋ sêsa intêna aŋga Atarimŋa sêmêŋ, tec gêjac siŋ gêdêŋ Israel, ma kêkôc lau Israel ŋagêdô tôŋ jakêkêŋ êsêac sêŋgôŋ kapoacwalô. ");
INSERT INTO jae_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Go lau Israel têtôc lemeŋ gêdêŋ Apômtau ma sêsôm gebe “Aôm embe ôkêŋ lau tônê sêsêp aêac lemeŋ, oc anseŋ êsêacnêŋ malac samob su samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Apômtau kêkêŋ taŋa lau Israel aweŋ ma gêwi lau Kanaan siŋ sêsêp êsêac lemeŋ. Tec lau Israel seseŋ êsêac tonêŋ malac samob su ma sêsam gamêŋ tau gebe Horma. ");
INSERT INTO jae_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Lau Israel dêdi aŋga lôc Horeb ma sêsêlêŋ sepeŋ Gwêckoc sebe sênac jaê gamêŋ Edom. Êsêac sêsêlêŋ sêmoa intêna e lau ôliŋ ŋakam kêsa. ");
INSERT INTO jae_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Êsêac sêli aweŋ sa gêdêŋ Apômtau agêc Mose gebe “Amagêc awê aêac awi Aiguptu siŋ gebe amac êndu aŋga gamêŋ sawa kêtu ageŋŋa. Gebe mo to bu masi aŋga tonec ma aêac ôliŋ ŋakam gêŋ ŋasêpam, taŋ aeŋ amoa naŋ.” ");
INSERT INTO jae_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Go Apômtau kêsakiŋ moac ŋaclai gêdêŋ lau. Moac tau sêŋac lau Israel e taêsam sêmac êndu. ");
INSERT INTO jae_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ma êsêac dêdêŋ Mose jasêsôm gebe “Aêac agôm sec gebe ali aweŋ sa gêdêŋ amagêc Apômtau. Oteŋ Apômtau, gebe êkôc moac su aŋga aêacma.” Amboac tonaŋ Mose keteŋ Apômtau kêtu lauŋa. ");
INSERT INTO jae_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Go Apômtau kêsôm gêdêŋ Mose gebe “Ômansaŋ moac ŋaclai teŋ ŋakatu ma ôjac sa naêkô. Ma lau samob, taŋ moac gêŋac êsêac naŋ, embe mateŋ ê moacki tau, naŋ sêmoa mateŋ jali.” ");
INSERT INTO jae_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Amboac tonaŋ Mose kêmasaŋ moacki teŋ ma gêjac sa jakêkô. Ma moac embe êŋac ŋac teŋ, go ŋac tau mata ê moacki tau ma êmoa mata jali. ");
INSERT INTO jae_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Go lau Israel dêdi jasê nêŋ becobo kêkô Moabnêŋ gaboaŋ aŋga Jordan ŋamakeŋ ônêŋa kêkanôŋ malac Jeriko. ");
INSERT INTO jae_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ma Sipor latu Balak gêlic gêŋ samob, taŋ lau Israel sêgôm gêdêŋ lau Amor naŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ma lau Moab têtêc lau Israel gebe lau taêsam ŋasec ma êsêac sêmoa tonêŋ ŋalêlôm ŋatutuc kêlêlêc su kêtu lau Israelŋa. ");
INSERT INTO jae_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ma êsêac sêsôm gêdêŋ lau Midian nêŋ laumata gebe “Ojae, galoc lau Israel nêŋ toŋ kapôêŋ oc sêniŋ gêŋ samob, taŋ gêc aêacŋa naŋ, su amboac bulimakao seŋ gêgwaŋ aŋga kôm.” Ma Sipor latu Balak kêtu lau Moab nêŋ kiŋ gêdêŋ ŋasawa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ma eŋ kêsakiŋ lau jaeŋŋa gêdêŋ Beor latu Bileam, taŋ gêŋgôŋ malac Petor, taŋ gêc gamêŋ Amauŋa aŋga bu Euprat ŋatali. Lau jaeŋŋa sebe sêkalem eŋ ma sêsôm gêdêŋ eŋ gebe “Ôlic acgom, lau-m teŋ sêwi Aiguptu siŋ sêmêŋ sêjam gamêŋ auc samucgeŋ mêŋsêŋgôŋ sêkanôŋ aêac. ");
INSERT INTO jae_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Amboac tonaŋ ômôêŋ sebeŋ mêŋôpuc boa lau tônê êtu aêŋa, gebe lau tau ŋajaŋa sêlêlêc aê su. Embe ôpuc boa êsêac, oc moae jatôm, gebe jaku êsêac tulu ma jajanda êsêac e sêwi gamêŋ siŋ, gebe aê kajalagac aôm embe ônam mec ŋac teŋ, oc êtap mec ŋanô sa, ma embe ôpuc boa ŋac teŋ, oc êtap kôpuc boa ŋaŋanô sa amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ma lau Moab to lau Midian nêŋ laumata dêdi ma sêkôc ŋaôli Bileam eoc biŋ lasêŋa gêwiŋ. Êsêac jasêô lasê dêdêŋ Bileam ma sêsôm Balaknê biŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ma eŋ kêsôm gêdêŋ êsêac gebe “Anêc awiŋ aê êndêŋ êmbêc tonec, go jasôm biŋ êndêŋ amac êtôm Apômtau êsôm êndêŋ aê.” Tec lau Moab nêŋ kasêga sêmoa sêwiŋ Bileam. ");
INSERT INTO jae_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ma Anôtô gêdêŋ Bileam jakêsôm gebe “Asa lau sêmoa sêwiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileam kêsôm gêdêŋ Anôtô gebe “Sipor latu Balak, lau Moab nêŋ kiŋ, kêsakiŋ biŋ teŋ gêdêŋ aê gebe ");
INSERT INTO jae_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Ôlic acgom lau-m teŋ sêwi Aiguptu siŋ sêmêŋ sêjam gamêŋ auc samucgeŋ. Amboac tonaŋ ômôêŋ mêŋôpuc boa êsêac, moae jatôm, gebe janac siŋ êndêŋ êsêac ma jajanda êsêac e sêwi gamêŋ siŋ.’” ");
INSERT INTO jae_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mago Anôtô kêsôm gêdêŋ Bileam gebe “Ôsêlêŋ ôwiŋ êsêac atom ma ôpuc boa lau tau atom amboac tonaŋgeŋ, gebe aê gajam mec êsêac su.” ");
INSERT INTO jae_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Gêdêŋ bêbêcgeŋ Bileam gêdi sa ma kêsôm gêdêŋ Balaknê kasêga gebe “Aêc amu ana nêm gamêŋ êtiam, gebe Apômtau gedec gebe aê jasêlêŋ jawiŋ amac.” ");
INSERT INTO jae_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Go lau Moab nêŋ kasêga dêdi jasêô lasê gêdêŋ Balak ma sêsôm gebe “Bileam gedec gebe êsêlêŋ êwiŋ aêac êmêŋ.” ");
INSERT INTO jae_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tec Balak kêsakiŋ kasêga ŋagêdô kêtiam. Êsêac lau taêsam to lau towae sêlêlêc lau ŋamataŋa su. ");
INSERT INTO jae_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Êsêac sêô lasê dêdêŋ Bileam ma sêsôm gêdêŋ eŋ gebe “Sipor latu Balak kêsôm biŋ tonec gebe ‘Ôndêŋ aê ômôêŋmaŋ, gêŋ teŋ êkô aôm auc atom. ");
INSERT INTO jae_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Aê gabe jatoc aôm sa ŋanôgeŋ ma jaŋgôm biŋ samob, taŋ aôm ôsôm êndêŋ aê naŋ, ŋanô êsa. Amboac tonaŋ ômôêŋ mêŋôpuc boa lau tônê.’” ");
INSERT INTO jae_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mago Bileam gêjô Balaknê sakiŋwaga aweŋ gebe “Silber to gold êsô Balaknê andu e mêŋêc gebe êkêŋ êndêŋ aê, mago jatôm gebe jaŋgêli aêŋoc Apômtau Anôtô nê biŋ ŋagec atomanô. ");
INSERT INTO jae_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Tageŋ anêc awiŋ aê êndêŋ êmbêc tonec, gebe jajala biŋ ŋagêdô, taŋ Apômtau oc êsôm êndêŋ aê naŋ.” ");
INSERT INTO jae_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ma gêdêŋ gêbêc Anôtô gêdêŋ Bileam jakêsôm gêdêŋ eŋ gebe “Lau tonaŋ sêmêŋ gebe sêkôc aôm me. Amboac tonaŋ ôndi ma ôsêlêŋ ôwiŋ êsêac. Mago ôŋgôm biŋ, taŋ aê jajatu aôm naŋgeŋ, ŋanô êsa.” ");
INSERT INTO jae_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Amboac tonaŋ Bileam gêdi gêdêŋ bêbêc kanucgeŋ. Eŋ kêpô ômbiŋkap kêsêp nê doŋki ma kêsêlêŋ gêwiŋ lau Moab nêŋ kasêga. ");
INSERT INTO jae_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mago Apômtau têtac ŋandaŋ kêsa gêdêŋ eŋ gebe eŋ gêdi gêja. Ma Apômtaunê aŋela kêkô intêna auc eŋ, taŋ gêŋgôŋ doŋki ŋaô ma nê sakiŋwaga luagêc sêsêlêŋ sêwiŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Doŋki gêlic Apômtaunê aŋela kêkô intêna auc ma aŋela kêmêgôm siŋ ŋamata teŋ. Tec doŋki gêwi intêna siŋ ma kêsêlêŋ kêsêp kômlêlôm. Tec Bileam gêjac eŋ gebe êmu êsa intêna êna êtiam. ");
INSERT INTO jae_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Go Apômtaunê aŋela jakêkô intêna gasuc-gasuc, taŋ kêsa kôm wainŋa ŋalêlôm naŋ, gebe tuŋbôm kêkô intêna makeŋ-makeŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Doŋki gêlic Apômtaunê aŋela, tec jagêjac tuŋbôm ŋamakeŋ e kêkapiŋ Bileam akaiŋ tôŋ tamiŋ tuŋbôm, tec Bileam gêjac eŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Go Apômtaunê aŋela gêmuŋ gêja kêkô gamêŋ, taŋ intêna ŋasawa kêtu sauŋ naŋ, ma ŋasawa teŋ gebe doŋki êmôniŋ êsa anô me gasêŋa gêc atom. ");
INSERT INTO jae_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Doŋki gêlic Apômtaunê aŋela, go gêu tau kêsêp jagêc. Ma Bileam têtac ŋandaŋ kêsa ma gêjac doŋki ŋa nê tôc. ");
INSERT INTO jae_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Go Apômtau gêŋa doŋki awasuŋ ma kêsôm gêdêŋ Bileam gebe “Aê gagôm asageŋ gêdêŋ aôm, tec gôjac aê kêtu dim têlêac nec.” ");
INSERT INTO jae_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam kêsôm gêdêŋ doŋki gebe “Aê gajac aôm gebe gôjam ôwê gêdêŋ aê. Aê gabe embe jakôc siŋ teŋ êsêp lemoc, oc janac aôm tomatêgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Go doŋki kêsôm gêdêŋ Bileam gebe “Aê katu nêm doŋki, taŋ gôŋgôŋ ŋaô gedeŋ tôŋgeŋ e mêŋgêdêŋ galoc me masi. Aêŋoc mêtê gebe jaŋgôm aôm kwalec amboac tonec me.” Ma eŋ kêsôm gebe “Masi.” ");
INSERT INTO jae_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Go Apômtau gêgôm Bileam mataanô kêpoa lasê e gêlic Apômtaunê aŋela kêkô intêna to lêma kêmêgôm siŋ ŋamata. Ma eŋ gewec to gêu tau jagêc laŋôanô gêdêŋ nom. ");
INSERT INTO jae_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Go Apômtaunê aŋela kêsôm gêdêŋ eŋ gebe “Aôm gôjac nêm doŋki kêtu dim têlêac kêtu ageŋŋa. Ôlic acgom, aê tec gamêŋ gebe jakô aôm auc, gebe aê galic aôm kôsa intêna keso. ");
INSERT INTO jae_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Doŋki gêlic aê ma gêjac jaê aê kêtu dim têlêac. Embe ênac jaê aê atom, oc janac aôm êndu biŋŋanôgeŋ, ma doŋki tau oc êmoa mata jali.” ");
INSERT INTO jae_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Go Bileam kêsôm gêdêŋ Apômtaunê aŋela gebe “Aê gagôm sec. Aê gajam kauc gebe kôkô intêna auc aê atom, Amboac tonaŋ embe ôlic sec, naŋgo jamu jana êtiam.” ");
INSERT INTO jae_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Go Apômtaunê aŋela kêsôm gêdêŋ eŋ gebe “Ôsêlêŋ ôwiŋ lau tau. Mago ôsôm biŋ tageŋ, taŋ aê oc jajatu aôm naŋgeŋ.” Amboac tonaŋ Bileam kêsêlêŋ gêwiŋ Balaknê kasêga. ");
INSERT INTO jae_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak gêŋô Bileam gêmêŋ ŋawae, tec gêdi kêpuc eŋ tôŋtôŋ gêja Moabnê malac, taŋ gêc bu Amon ŋatali aŋga gamêŋ tau ŋamadiŋ jaêcgeŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak kêsôm gêdêŋ Bileam gebe “Aôm gôdêŋ aê gômôêŋ atom kêtu asageŋŋa. Aê kakêŋ jaeŋ to kakalem aôm atom me. Aôm gobe aê oc katôm gebe jatoc aôm sa atom me.” ");
INSERT INTO jae_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam gêjô eŋ awa gebe “Ôlic acgom, aê tec gadêŋ aôm gamêŋgac. Mago aê oc katôm gebe jasôm biŋ me masi. Aê oc jasôm biŋ tageŋ, taŋ Anôtô êkêŋ êsêp aocsuŋ naŋgeŋ, lasê.” ");
INSERT INTO jae_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Go Bileam kêsêlêŋ gêwiŋ Balak e sêô lasê Kiriat-Husot. ");
INSERT INTO jae_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ma Balak kêkêŋ bulimakao to domba kêtu da ma kêsakiŋ ŋagêdô gêdêŋ Bileam to kasêga, taŋ sêmoa sêwiŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ma gêdêŋ bêbêcgeŋ Balak kêkôc Bileam jakêpi Bamot-Bal. Aŋga ônê eŋ gêlic lau Israel nêŋ gamêŋ becŋa ŋagêdôgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ma Bileam kêsôm gêdêŋ Balak gebe “Ômboa altar 7 sa êtu aêŋa, go ôkêŋ-bulimakao kapoac 7 to domba kapoac 7 êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak gêgôm kêtôm Bileam kêsôm ma agêc sêkêŋ bulimakao kapoac teŋ ma domba kapoac teŋ kêtu daja gêsac altar 7 tau ŋaô kêtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ma Bileam kêsôm gêdêŋ Balak gebe “Ôkô ôwiŋ nêm daja, ma aê gabe jana. Moae Apômtau oc mêŋêlic aê. Ma biŋ, taŋ eŋ êtôc êndêŋ aê naŋ, oc janac miŋ êndêŋ aôm.” Go eŋ kêpi lôc sawa teŋ gêja. ");
INSERT INTO jae_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ma Anôtô mêŋgêlic Bileam ma Bileam kêsôm gêdêŋ eŋ gebe “Aê gaboa altar 7 sa ma kakêŋ bulimakao kapoac teŋ ma domba kapoac teŋ kêtu daja gêsac altar 7 ŋaô kêtômgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ma Apômtau kêkêŋ biŋ kêsêp Bileam awasuŋ su, go kêsôm gêdêŋ eŋ gebe “Ômu ôndêŋ Balak ôna ma ôsôm biŋ tonec êndêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Go Bileam gêmu gêdêŋ Balak gêja ma Balak to lau Moab nêŋ kasêga samob sêkô sêwiŋ ênê daja. ");
INSERT INTO jae_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Go Bileam gêôc awa sa ma kêsôm gebe “Lau Moab nêŋ kiŋ Balak kêkôc aê aŋga lôc oc kêpiŋa Aram gamêŋ ma kêsôm gebe ‘Ômôêŋ ôpuc boa Jakob êtu aêŋa. Ômôêŋ ônac jatu Israel.’ ");
INSERT INTO jae_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mago aê japuc boa ŋac, taŋ Anôtô kêpuc boa eŋ atom naŋ, amboac ondocgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Gebe aê kakô lôc ŋatêpôê ma galic eŋ, kakô gamêŋ ŋabau ma matoc gê eŋ. Lau-m teŋ, tê sêŋgôŋ nêŋ ŋasawa teŋ tauŋŋa nê, sedec gebe sêŋgôŋ sêwiŋ lau samuc. ");
INSERT INTO jae_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Asa kêtôm gebe êsa Jakobnê kekop sa. Asa kêtôm gebe êsa Israelnê lau ŋatoŋ sa. Aê jamac êndu jatôm lau gêdêŋ ma janac dabiŋ ŋoc lêŋ êtôm êsêac sêjac dabiŋ nêŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Go Balak kêsôm gêdêŋ Bileam gebe “Aôm gôgôm aê amboac ondoc. Ôlic acgom, aê kakêŋ biŋ aôm gebe ôpuc boa ŋoc ŋacjo, mago galoc aôm gôjam mec êsêac.” ");
INSERT INTO jae_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bileam gêjô eŋ awa gebe “Amboac ondoc, aê taŋoc wamu ma jasôm biŋ, taŋ Apômtau kêkêŋ kêsêp aê aocsuŋ naŋ, atom me.” ");
INSERT INTO jae_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak kêsôm gêdêŋ eŋ gebe “Mêŋôwiŋ aê ma aêagêc tana gamêŋ teŋ. Aŋga ônê aôm oc ôlic Israel, mago ôlic samucgeŋ atom, ôlic ŋagêdô, taŋ mêŋkêsi aêacŋa naŋgeŋ. Ma aŋga tônê ôpuc boa êsêac êtu aêŋa.” ");
INSERT INTO jae_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ma eŋ gêwê Bileam kêpi dibwaganêŋ kôm, taŋ gêc lôc Pisga ŋatêpôê naŋ, gêja. Go eŋ gêboa altar 7 sa ma kêkêŋ bulimakao kapoac teŋ ma domba kapoac teŋ kêtu daja gêsac altar 7 tau ŋaô kêtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Go Bileam kêsôm gêdêŋ Balak gebe “Ôkô ôwiŋ nêm daja, ma aê najalic Apômtau aŋga lôc ŋamakeŋ ônêŋa.” ");
INSERT INTO jae_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ma Apômtau mêŋgêlic Bileam ma kêkêŋ biŋ kêsêp eŋ awasuŋ ma kêsôm gebe “Ômu ôndêŋ Balak ôna ma ôsôm biŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Go Bileam gêmu gêdêŋ Balak gêja ma Balak to lau Moab nêŋ kasêga samob sêkô sêwiŋ ênê daja. Ma Balak kêsôm gêdêŋ eŋ gebe “Apômtau kêsôm biŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Go Bileam gêôc awa sa ma kêsôm nê biŋ tau gebe “O Balak, ôndi ma ôŋô biŋ. O Sipor latu, ôkêŋ taŋam aê. ");
INSERT INTO jae_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Anôtô eŋ ŋamalac atom, gebe ênsau biŋdansaŋ. Eŋ ŋamalac teŋ latu atom, gebe ênam nê biŋ ôkwi. Biŋ, taŋ eŋ kêsôm naŋ, gêgôm kêtu anô atom me. Biŋ, taŋ eŋ gêjac mata naŋ, gêgôm ŋanô kêsa atom me. ");
INSERT INTO jae_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ôlic acgom, eŋ kêjatu aê gebe janam mec. Eŋ gêjam mec su, tec katôm, gebe janam mec tau ôkwi atom. ");
INSERT INTO jae_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Gêŋwapac teŋ gêc Jakob ŋalêlôm atom, ma ŋakeso teŋ gêc Israel ŋalêlôm atom amboac tonaŋgeŋ. Nê Anôtô gêmoa gêwiŋ eŋ ma lasê kêtaŋ kêtu ênê kiŋŋa. ");
INSERT INTO jae_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Anôtô, taŋ gêwê eŋ gêwi Aiguptu siŋ naŋ, kêkêŋ ŋaclai gêdêŋ eŋ kêtôm bôcgabuŋ ŋajabo. ");
INSERT INTO jae_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Biŋ beŋŋa teŋ kêtôm gebe enseŋ Jakob atom, ma biŋ sêpuc boaŋa teŋ enseŋ Israel atom. Galoc sêsôm kêpi Jakob to Israel gebe ‘Anôtô gêgôm gêŋsêga kaiŋ teŋ.’ ");
INSERT INTO jae_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Alic lau tau acgom. Êsêac têtôm lewe têna gêdi sa. Êsêac têtôm lewe kêpuc tau gêdi kêkô. Eŋ êlêwaŋ tau atom e êniŋ gwada su ma ênôm gwada, taŋ gêjac naŋ, ŋadec.” ");
INSERT INTO jae_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Go Balak kêsôm gêdêŋ Bileam gebe “Aôm kôpuc boa êsêac atom, tec ônam mec êsêac atom amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam gêjô eŋ awa ma kêsôm gêdêŋ Balak gebe “Biŋ samob, taŋ Anôtô kêjatu naŋ, aê oc jaŋgôm ŋanô êsa. Aê kasôm biŋ tonec gêdêŋ aôm me masi.” ");
INSERT INTO jae_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak kêsôm gêdêŋ Bileam gebe “Ômôêŋ acgom, aê gabe jawê aôm ôna gamêŋ teŋ. Moae Anôtô oc êlic ŋajam gebe aôm ôpuc boa êsêac êtu aêŋa aŋga ônê.” ");
INSERT INTO jae_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Go Balak gêwê Bileam kêpi lôc Peor ŋatêpôê gêja. Aŋga ônê eŋ gêlic gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ma Bileam kêsôm gêdêŋ Balak gebe “Ômboa altar 7 sa êndêŋ aê aŋga tonec ma ôkôc bulimakao kapoac 7 to domba kapoac 7.” ");
INSERT INTO jae_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak gêgôm kêtôm Bileam kêsôm ma kêkêŋ bulimakao kapoac teŋ to domba kapoac teŋ kêtu daja gêsac altar 7 tau ŋaô kêtômgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bileam gêlic gebe Apômtau gêlic ŋajam, gebe ênam mec Israel, tec gêja kêtôm têm ŋagêdô gebe êtap puc saŋa atom. Eŋ laŋôanô gêdêŋ gamêŋ sawageŋ. ");
INSERT INTO jae_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Eŋ gêôc mataanô sa ma gêlic Israel sêŋgôŋ totoŋ-totoŋ têtôm nêŋ gôlôacmôkêgeŋ. Ma Anôtônê Ŋalau mêŋkêpi eŋ, ");
INSERT INTO jae_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","go gêôc awa sa ma kêsôm nê biŋ tau gebe “Beor latu Bileam, ŋac, taŋ mata gêlac naŋ, nê biŋ tonec. ");
INSERT INTO jae_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ŋac, taŋ gêŋô Anôtônê biŋ to gêlic gêŋ, taŋ Ŋaniniŋ Ŋatau geoc lasê ma gêu tau jagêc tomata gêmôbgeŋ atom naŋ, nê biŋ tonec. ");
INSERT INTO jae_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","O Jakob, nêm becobo e ŋajamanô. O Israel, nêm gamêŋ gôŋgôŋŋa e ŋajam êndu, ");
INSERT INTO jae_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","kêtôm gaboaŋ tapa baliŋ, kêtôm kôm, taŋ gêc bugala naŋ, kêtôm môsê, taŋ Apômtau kêsê naŋ, kêtôm kaseda aŋga bu ŋatali. ");
INSERT INTO jae_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Êsêacnêŋ kôm moŋa êpô lêna bu atom, gebe bu oc êpoac kôm ŋalêlôm. Êsêacnêŋ kiŋ kapôêŋ kêlêlêc Agag su ma tetoc ênê gôliŋ kiŋŋa ŋawae sa êlêlêc su. ");
INSERT INTO jae_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Anôtô, taŋ gêwê eŋ gêwi Aiguptu siŋ naŋ, kêkêŋ ŋaclai gêdêŋ eŋ kêtôm bôcgabuŋ tojabo. Eŋ oc êndaŋgôŋ lau tomôkê-tomôkê, taŋ têtu ênê ŋacjo naŋ, ma oc êtuc nêŋ ŋatêkwa e popoc-popocgeŋ, ma nê sôb oc eseŋeŋ nêŋ ŋacjo. ");
INSERT INTO jae_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Eŋ kêluŋ tau gêc kêtôm lewe, kêtôm lewe têna. Asa gebe êkalom e êndi sa. Ma ŋac, taŋ êpuc boa aôm naŋ, êtap êpuc boa aôm ŋagêjô sa.” ");
INSERT INTO jae_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Go Balak têtac ŋandaŋ kêsa gêdêŋ Bileam, tec kêtuc lêma kêpi tau ma kêsôm gêdêŋ Bileam gebe “Aê kakalem aôm, gebe ôpuc boa ŋoc ŋacjo, mago aôm gôjam mec êsêac kêtu dim têlêac. ");
INSERT INTO jae_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ôêc su, ômu ôna nêm gamêŋ. Aê gabe jatoc aôm sa, mago Apômtau tau kêgamiŋ aôm waem.” ");
INSERT INTO jae_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam gêjô eŋ awa gebe “Aê kasôm gêdêŋ nêm lau jaeŋŋa, taŋ kôsakiŋ dêdêŋ aê sêmêŋ naŋ, su gebe ");
INSERT INTO jae_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Silber to gold embe êsô Balaknê andu e mêŋêc, gebe êkêŋ êndêŋ aê, mago jatôm gebe jaŋgêli Apômtaunê biŋ atom. Aê oc jaŋgôm sec to ŋajam êtôm ŋoc ŋalêlôm êkac aêŋa jatôm atom amboac tonaŋgeŋ. Aê jasôm biŋ tageŋ, taŋ Apômtau kêsôm naŋgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ma galoc jamu jandêŋ ŋoc lau jana êtiam. Amboac tonaŋ ômôêŋ gebe jasôm biŋ, taŋ lau tônê sêŋgôm êndêŋ nêm lau êtu ŋamu naŋ, lasê êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ma Bileam gêôc awa sa ma kêsôm nê biŋ tau gebe “Beor latu Bileam, ŋac, taŋ mata gêlac naŋ, nê biŋ tonec. ");
INSERT INTO jae_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ŋac, taŋ gêŋô Anôtônê biŋ to kêjala Lôlôc Ŋatau nê kauc ma gêlic gêŋ, taŋ Ŋaniniŋ Ŋatau geoc lasê naŋ, e gêu tau jagêc tomata gêmôbgeŋ atom naŋ, nê biŋ tonec. ");
INSERT INTO jae_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Aê galic ŋac tau, mago gêmoa galoc atom. Matoc gê eŋ, mago gêmoa ŋagala atom. Utitalata teŋ oc mêŋêpi aŋga Jakobnê, ma tôc gôliŋŋa teŋ mêŋêsa aŋga Israelnê. Ma tôc tau êtuc lau Moab teŋbeleŋ to êku Set latui samob tulu. ");
INSERT INTO jae_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Gamêŋ Edom oc êtu ênê gêŋ, ma eŋ êjaŋgo nê ŋacjo Seir nêŋ gamêŋ su, ma Israelnê ŋaclai êsa. ");
INSERT INTO jae_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jakob ênam gôliŋ nê ŋacjo ma enseŋ lau, taŋ sêsêp siŋ sawa naŋ su.” ");
INSERT INTO jae_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Gêdêŋ taŋ Bileam gêlic lau Amalek naŋ, gêôc awa sa ma kêsôm nê biŋ tonec gebe “Amalek kêtu lau tomôkê-tomôkê samob nêŋ ŋamata, mago êtu ŋamu eŋ oc ênaŋa.” ");
INSERT INTO jae_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Gêdêŋ taŋ eŋ gêlic lau Kain naŋ, eŋ gêôc awa sa ma kêsôm nê biŋ tonec gebe “O Kain, nêm gamêŋ, taŋ gôŋgôŋ naŋ, ŋajaŋa. Aôm gôjac nêm sac gêsac poc kapôêŋ ŋaô. ");
INSERT INTO jae_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mago ŋacjo oc senseŋ Kain su. Têm kêdabiŋ, go lau Asur sêwê aôm naôŋgôŋ kapoacwalô.” ");
INSERT INTO jae_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Bileam gêôc awa sa kêtiam ma kêsôm nê biŋ tonec gebe “Ojae, Anôtô embe êŋgôm biŋ tonec ŋanô êsa, asa oc êmoa mata jali. ");
INSERT INTO jae_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Waŋ oc êmêŋ aŋga Kitim, ma êsêac oc sêkôniŋ Asur to Eber tôŋ. Ma êsêac oc sênaŋa amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Go Bileam gêdi ma gêc gêmu gêja nê gamêŋ. Ma Balak gêc kêsa nê intênaŋa gêja amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôpi lôc Abarim ônamaŋ ma ôsala gamêŋ, taŋ kakêŋ gêdêŋ lau Israel naŋ. ");
INSERT INTO jae_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Embe ôlic gamêŋ tau su, go naôwiŋ nêm lau amboac têwam Aron jagêwiŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Biŋ tonec êtap amagêc sa gebe taŋempêc aŋga gamêŋ sawa Sin. Gôlôac sêli aweŋ sa gêdêŋ aê, ma amagêc akô êsêac laŋôŋnêmŋa ma awa aê sa aŋga bu gebe aê ŋac dabuŋ nec atom.” Bu tau bu Meriba aŋga gamêŋ sawa Sin ŋamalac Kades. ");
INSERT INTO jae_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Ma Mose kêsôm gêdêŋ Apômtau gebe ");
INSERT INTO jae_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Aê jateŋ Apômtau, gêŋ mateŋ jali samob nêŋ aweŋjaô ŋaAnôtô, gebe êjaliŋ ŋac teŋ sa gebe ênam gôliŋ gôlôac. ");
INSERT INTO jae_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Ŋac tau êsô-êsa êmuŋ êsêac ma êwê êsêac sêsô-sêsa, gebe Apômtaunê gôlôac tau têtôm toŋ dombaŋa, taŋ ŋacgejob masi naŋ, atom.” ");
INSERT INTO jae_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Apômtau kêsôm gêdêŋ Mose gebe “Ôkôc Nun latu Josua. Eŋ ŋac toŊalau ma u lêmam ênsac eŋ. ");
INSERT INTO jae_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ôwê eŋ naêkô dabuŋwaga Eleasar to gôlôac samob laŋôŋnêm ma ôsakiŋ eŋ lau samob sêlic. ");
INSERT INTO jae_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ôkêŋ nêm ŋaclai ŋagêdô elom eŋ, gebe lau Israel nêŋ gôlôac samob taŋeŋ wamu eŋ. ");
INSERT INTO jae_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Eŋ naêkô dabuŋwaga Eleasar laŋônêm gebe êtu kênac Urim gebe êtap Apômtaunê taê gêjam sa. Josua êjatu ma Israel nêŋ gôlôac samob sêsô-sêsa sêwiŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose gêgôm biŋ, taŋ Apômtau kêjatu naŋ, ŋanô kêsa ma kêkôc Josua to gêwê eŋ jakêkô dabuŋwaga Eleasar to gôlôac samob laŋôŋnêm ");
INSERT INTO jae_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ma gêu lêma gêsac eŋ to kêsakiŋ eŋ kêtôm Apômtau kêsôm gêjam Mose awa. ");
INSERT INTO jae_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Biŋ tonec Mose kêsôm gêdêŋ lau Israel samob aŋga Jordan ŋamakeŋ ônêŋa gêdêŋ taŋ sêmoa gamêŋ sawa Araba, taŋ gêc gamêŋ Paran to Topel ma Laban to Hesarot ma Disahab ŋasawa kêkanôŋ gamêŋ Sup naŋ. ");
INSERT INTO jae_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Tasêlêŋ aŋga lôc Horeb tasa intêna lôc Seirŋa e taô lasê malac Kades-Barnea ŋasawa kêtôm bêc 11. ");
INSERT INTO jae_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ma gêdêŋ jala kêtu 40 ŋaajôŋ 11 ŋabêc ŋamataŋa Mose kêsôm biŋ samob, taŋ Apômtau kêjatu eŋ naŋ, lasê gêdêŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Gêdêŋ taŋ Apômtau kêku kiŋ Amorŋa Sihon, taŋ gêŋgôŋ Hesbon ma kiŋ Basanŋa Og, taŋ gêŋgôŋ Astarot to Edriŋa naŋ, tulu. ");
INSERT INTO jae_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Aŋga gamêŋ Moabŋa, taŋ gêc Jordan ŋamakeŋ ônêŋa naŋ, Mose gêjac m gebe êwa biŋsu tonec sa gebe ");
INSERT INTO jae_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Apômtau, aêacnêŋ Anôtô, kêsôm gêdêŋ aêac aŋga lôc Horeb gebe ‘Amac amoa lôc tonec kêtômgac. ");
INSERT INTO jae_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Andi ma anac têku nêm lêŋ êtiam ma asêlêŋ ana lau Amor nêŋ gamêŋ ŋabau to êndêŋ êsêacnêŋ lau jabaŋŋa, taŋ sêŋgôŋ Araba ma gamêŋ ŋabau to gaboaŋ ma Negeb to gwêctali ma gamêŋ Kanaan to Lebanon e êndêŋ bu kapôêŋ Euprat naŋ. ");
INSERT INTO jae_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Alic acgom, aê kakêŋ nom tonaŋ gêdêŋ amac sugac. Asô ana ma akôc ma awê kaiŋ nom, taŋ Apômtau kêtôc lêma ma gêjac mata gêdêŋ amac tamemi, gêdêŋ Abraham agêc Isak ma Jakob gebe êkêŋ êndêŋ êsêac to nêŋ wakuc, taŋ têndaŋguc êsêac naŋ.’” ");
INSERT INTO jae_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Go Mose kêsôm kêtiam gebe “O Israel, galoc akêŋ taŋem ŋagôliŋ to biŋsu, taŋ jandôŋ êndêŋ amac naŋ, ma aŋgôm ŋanô êsa gebe amoa matem jali ma asa gamêŋ, taŋ Apômtau, amac tameminêŋ Anôtô gebe êkêŋ êndêŋ amac naŋ, ana ma awê kaiŋ gamêŋ tau êtu nêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Anac têku biŋ, taŋ aê kajatu amac naŋ ŋateŋ atom to akôc ŋalô teŋ su atom amboac tonaŋgeŋ. Aŋgôm Apômtau, amacnêm Anôtô, nê biŋsu, taŋ kajatu amac naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Amac taôm alic gêŋ, taŋ Apômtau gêgôm aŋga Bal-Peor naŋgac. Lau samob, taŋ sêsap Bal aŋga Peorŋa tôŋ naŋ, Apômtau, amacnêm Anôtô geseŋ êsêac su aŋga amac ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Mago amac, taŋ asap Apômtau, amacnêm Anôtô, tôŋ ŋajaŋa naŋ, tec amoa matem jali e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Alic acgom, aê kadôŋ ŋagôliŋ to biŋsu gêdêŋ amac kêtôm Apômtau, aêŋoc Anôtô, kêjatu aê, gebe amac aŋgôm ŋanô êsa aŋga gamêŋ, taŋ oc asa gebe awê kaiŋ êtu amacnêm gamêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Amboac tonaŋ ajop biŋsu tau ŋapep ma aŋgôm ŋanô êsa, gebe biŋsu tonaŋ êwaka amacnêm kauc to nêm ajala mêtêŋa sa êndêŋ tenteŋlatu sêlic. Êsêac embe sêŋô ŋagôliŋ samob tonaŋ ŋai, oc sêsôm gebe ‘Lau-m kapôêŋ tonaŋ êsêac lau tokauc ma lau sêjala mêtêŋa biŋŋanôgoc.’ ");
INSERT INTO jae_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Biŋŋanô, lau-m kapôêŋ ondoc oc nêŋ anôtô gêmoa êsêac ŋagala kêtôm Apômtau, aêacnêŋ Anôtô, gêmoa aêac ŋagala gêdêŋ têm samob, taŋ aweŋ gêjac eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ma lau-m kapôêŋ ondoc oc têtap ŋagôliŋ to biŋsu gêdêŋ sa, kêtôm biŋsu samob, taŋ ocsalô tonec kakêŋ gêdêŋ amac naŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“Mago ôlic taôm to ojop katôm ŋapep. Ôliŋ biŋ, taŋ gôlic ŋa matamanô naŋ, siŋ atom, ma taêm ênam biŋ tonaŋ êtôm bêc ômoa matam jaliŋa samob. Ônac miŋ biŋ tau êndêŋ nêm gôlôac to nêm gôlôacnêŋ gôlôac. ");
INSERT INTO jae_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Gêdêŋ bêc, taŋ kôkô Apômtau, aômnêm Anôtô, laŋônêmŋa aŋga Horeb naŋ, Apômtau kêsôm gêdêŋ aê gebe ‘Ôkac lau sa dêndêŋ aê sêmêŋ gebe jakêŋ êsêac sêŋô ŋoc biŋ ma jandôŋ êsêac gebe têtêc aê êtôm bêc samob, taŋ sêmoa mateŋ jali aŋga nom naŋ, ma têndôŋ biŋ tau êndêŋ nêŋ gôlôac amboac tonaŋgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ma amac tec atu gasuc jaakô lôc ŋalabu. Ma ja gelom aŋga lôc tau e jagêdêŋ undambê, taŋ ŋakesec to tao ma gêsuŋbôm kêkôm auc naŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Go Apômtau awa kêsa gêdêŋ amac aŋga ja ŋalêlôm. Amac aŋô biŋ ŋakicsêa, mago alic ŋanô atom, aŋô awageŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ma eŋ geoc nê poac lasê gêdêŋ amac ma kêjatu amac, gebe ajop. Poac tau biŋsu 10, taŋ eŋ keto kêsêp poc tapa luagêc. ");
INSERT INTO jae_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Ma Apômtau kêjatu aê gêdêŋ bêc tonaŋ gebe jandôŋ ŋagôliŋ to biŋsu êndêŋ amac, gebe aŋgôm biŋ tau ŋanô êsa aŋga gamêŋ, taŋ oc asa ana naŋ, gebe awê kaiŋ êtu amacnêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Amboac tonaŋ ajop taôm ŋapep. Gêdêŋ bêc, taŋ Apômtau awa kêsa gêdêŋ amac aŋga ja ŋalêlôm aŋga Horeb naŋ, amac alic ŋanô teŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Amboac tonaŋ alic taôm gebe aŋgôm biŋ alôb-alôb ma asap gêŋ tokaiŋ-tokaiŋ ŋakatu êtu taômŋa atom. Asap gwam ŋac me awê ŋakatu atom. ");
INSERT INTO jae_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Asap bôc nomŋa to moc, taŋ gêlôb gêmoa umboŋ ŋalabu naŋ, ŋateŋ ŋakatu atom. ");
INSERT INTO jae_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","Asap gêŋ, taŋ kêgalab gêmoa nom naŋ, to i, taŋ gêmoa bu nom ŋalêlômŋa naŋ, ŋateŋ ŋakatu atom. ");
INSERT INTO jae_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ma embe ôc matamanô sa e ôlic oc to ajôŋ ma utitalata ma undambê ŋagêlôŋ samob, go êlêtôm aôm e oteŋ mec to ônam sakiŋ gêŋ tau atom. Apômtau, aômnêm Anôtô, kêkêŋ gêŋ tau gêdêŋ lau samob, taŋ sêmoa umboŋ ŋalabu naŋ, sêwê kaiŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Mago Apômtau kêkôc amac ma gêwê amac asa aŋga Aiguptu, taŋ kêtuŋ amac kêtôm ja geŋ ki gêwê naŋ, amêŋ, gebe atu eŋ taugeŋ nê lau, kêtôm taŋ amoa e gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ma Apômtau têtac ŋandaŋ gêdêŋ aê kêtu amacŋa. Eŋ kêtôc lêma ma kêsôm kêtu tôŋ gebe aê jalom bu Jordan atom ma jasa gamêŋ ŋajam, taŋ Apômtau, amacnêm Anôtô, gebe êkêŋ êndêŋ amac êtu nêm nomlênsêm naŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Tec aê jamac êndu aŋga gamêŋ tonec, jalom Jordan atom. Amac taômgeŋ alom e awê kaiŋ gamêŋ ŋajam tau êtu amacnêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Amboac tonaŋ ajop taôm ma aliŋ poac, taŋ Apômtau, amacnêm Anôtô, kêmoatiŋ gêdêŋ amac naŋ, siŋ atom. Asap gêŋ tokaiŋ-tokaiŋ ŋakatu atom, Apômtau, amacnêm Anôtô, gêjac jao gebe aŋgôm atom. ");
INSERT INTO jae_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Gebe Apômtau, aômnêm Anôtô, eŋ ja êndaŋgac gêŋŋa, eŋ Anôtô, taŋ gêjam lêmuŋ nê gêŋ, gebe têtac êwiŋ eŋ taugeŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Amac embe akac gôlôac to gôlôacnêŋ gôlôac lasê to atu wakac aŋga gamêŋ tônê ma embe asap gêŋ tokaiŋ-tokaiŋ ŋakatu êtu gwam to aŋgôm gêŋ, taŋ Apômtau, amacnêm Anôtô, êlic amboac gêŋ alôb-alôb naŋ, e êŋgôm eŋ têtac ŋandaŋ êsa, ");
INSERT INTO jae_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","go ocsalô tonec jakalem lau undambê to nom sêŋô gebe amac malemmê weŋ tageŋ aŋga gamêŋ, taŋ êtu amacnêm gamêŋ êndêŋ taŋ alom bu Jordan naŋ. Amac oc amoa gamêŋ tau ŋasawa baliŋ atom, oc anaŋa samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ma Apômtau êsa amac êliŋ-êliŋ asêp lau tomôkê-tomôkê ŋalêlôm. Ma amac, taŋ Apômtau kêpalip amac asêp lau tomôkê-tomôkê ŋalêlôm naŋ, nêm lau ŋapopocgeŋ oc gacgeŋ sêmoa lau tomôkê-tomôkê ŋasawa. ");
INSERT INTO jae_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ma aŋga tônê oc anam sakiŋ anôtôi, taŋ ŋamalac lemeŋ sêsap kêsêp ka to poc naŋ. Anôtôi tonaŋ sêlic gamêŋ atom, sêŋô biŋ atom, seŋ gêŋ atom, sêŋu gêŋ ŋamalu atom. ");
INSERT INTO jae_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Mago aŋga lau tomôkê-tomôkê ŋalêlôm aôm oc onsom Apômtau, aômnêm Anôtô. Ma aôm embe onsom eŋ tonêm ŋalêlôm samuc ma nêm katôm samuc, oc ôtap eŋ sa. ");
INSERT INTO jae_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Êndêŋ bêc ŋamu embe gêŋwapac samob êpi aôm e ôpô lêna ŋanô, go ômu ôndêŋ Apômtau, aômnêm Anôtô, ôna ma taŋam wamu eŋ awa. ");
INSERT INTO jae_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Gebe Apômtau, aômnêm Anôtô, eŋ Anôtô taê walôŋa. Eŋ oc êwi aôm siŋ to enseŋ aôm su ma êliŋ poac, taŋ kêmoatiŋ gêdêŋ tamemi to kêtôc lêma naŋ, siŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Ôkip têm, taŋ gêjaŋa su to gêmuŋ aôm naŋ, ŋabiŋ sa acgom. Ônac m êndêŋ bêc Anôtô kêkêŋ ŋamalac sêmoa nom naŋ ma ôtu kênac lau, taŋ sêŋgôŋ umboŋ ŋalabu ŋamakeŋ tonecŋa e êndêŋ ŋamakeŋ tônêŋa naŋ, gebe gêŋsêga amboac tonec oc kêsa ma lau sêŋô biŋ teŋ amboac tonec ŋawae su me masi. ");
INSERT INTO jae_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Lau-m teŋ sêŋô Anôtô awa kêsa aŋga ja ŋalêlôm gêmêŋ kêtôm aôm gôŋô, ma sêmoa mateŋ jali me. ");
INSERT INTO jae_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Me anôtô teŋ gêmoa, taŋ kêsaê gebe naêjaŋgo lau-m teŋ su aŋga lau-m teŋ ŋalêlôm êtu eŋ tauŋa ma kêsaê êsêac to gêgôm gêŋtalô ma gêŋsêga to gêjac siŋ ŋa lêma ŋajaŋa, taŋ kêmêtôc naŋ, ma kêtakê êsêac ŋa gêŋwapac kaiŋ teŋ kêtôm Apômtau, amacnêm Anôtô, gêgôm kêtu amacŋa aŋga Aiguptu, amac taôm matemanô alic naŋ, me. ");
INSERT INTO jae_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Eŋ kêtôc biŋ samob tonaŋ gêdêŋ aôm, gebe ôjala gebe Apômtau eŋ Anôtô biŋŋanôgeŋ, ma anôtô teŋ gêmoa gêwiŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Eŋ kêkêŋ aôm gôŋô eŋ awa kêsa aŋga undambê gebe êndôŋ aôm ma kêkêŋ aôm gôlic ênê ja kapôêŋ aŋga nom to gôŋô ênê biŋ kêsa aŋga ja ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Eŋ têtac gêwiŋ aôm tamami to kêjaliŋ êsêacnêŋ wakuc sa, ma gêwê aôm kôsa aŋga Aiguptu gômôêŋ. Eŋ tau gêmoa gêwiŋ aôm ma gêgôm gêŋ tonaŋ ŋa nê ŋaclai kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Eŋ kêjanda lau-m kapôêŋ-kapôêŋ to ŋajaŋa sêlêlêc aôm su gêmuŋ aôm, gebe êwê aôm ôsa êsêacnêŋ gamêŋ ôna ma êkêŋ gamêŋ tau êtu nêm nomlênsêm, kêtôm tec gêc galoc nec. ");
INSERT INTO jae_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Amboac tonaŋ ocsalô tonec ôjala ma taêm ênam biŋ tau ênêc nêm ŋalêlômgeŋ gebe Apômtau taugeŋ eŋ undambê to nom ŋaAnôtô. Anôtô teŋ gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Kêtu tonaŋŋa aôm ôŋgôm ênê ŋagôliŋ to biŋsu, taŋ ocsalô tonec kajatu aôm naŋ, ŋanô êsa gebe aôm to nêm gôlôac, taŋ sêndaŋguc aôm naŋ, amoa ŋajam to aŋgôŋ ŋasawa ŋêŋgeŋ aŋga gamêŋ, taŋ Apômtau, aômnêm Anôtô, êkêŋ êndêŋ aôm endeŋ tôŋgeŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Go Mose kêsôm gebe “Biŋsu to ŋagôliŋ ma jatu tau, taŋ Apômtau, amacnêm Anôtô kêjatu aê, gebe jandôŋ êndêŋ amac gebe aŋgôm ŋanô êsa aŋga gamêŋ, taŋ alom ana gebe awê kaiŋ êtu amacnêm gamêŋ naŋ, tonec. ");
INSERT INTO jae_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Gebe aôm ma latômi to dêbômi atêc Apômtau, aômnêm Anôtô, ma aŋgôm biŋsu to ŋagôliŋ samob, taŋ kajatu amac naŋ, ŋanô êsa êndêŋ nêm têm amoa matem jaliŋa, gebe aŋgôŋ ŋasawa ŋêŋgeŋ aŋga nom. ");
INSERT INTO jae_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Amboac tonaŋ amac lau Israel, aŋô biŋsu tau to aŋgôm ŋanô êsa ŋapep, gebe amoa ŋajamgeŋ ma atu taêsam aŋga gamêŋ, taŋ su to lêp keseleŋ naŋ, êtôm taŋ amac tameminêŋ Anôtô gêjac mata gêdêŋ amac naŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“O Israel, ôkêŋ taŋammaŋ. Apômtau, aêacnêŋ Anôtô, eŋ Apômtau tageŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Têmtac êwiŋ Apômtau, aômnêm Anôtô, tonêm ŋalêlôm samuc ma nêm katôm samuc ma nêm ŋaclai samuc. ");
INSERT INTO jae_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ma oto biŋ, tec galoc jajatu aôm nec, êsêp nêm ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ôndôŋ biŋ tau êndêŋ nêm gôlôac ma embe ôlêwaŋ taôm ôŋgôŋ nêm andu me ôsêlêŋ ômoa intêna me êndêŋ noc ônêc bêc to ôndi saŋa naŋ, ôsôm biŋ tau ŋakôniŋŋa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Ôkic biŋ tau tôŋ êpi lêmam êtu ŋabelo to ombec biŋ tau êtôm ŋatalô. ");
INSERT INTO jae_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Oto biŋ tau êpi nêm andu ŋasagiŋtêkwa sacgêdôŋa to êpi nêm katam tau. ");
INSERT INTO jae_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Êndêŋ taŋ Apômtau, aômnêm Anôtô, êwê aôm naô lasê gamêŋ, taŋ eŋ kêtôc lêma gêdêŋ tamami Abraham agêc Isak ma Jakob gebe êkêŋ êndêŋ aôm naŋ, ma êkêŋ malac kapôêŋ to ŋajam, taŋ aôm kôkwê atom naŋ, ");
INSERT INTO jae_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ma êkêŋ andu toawa tokaiŋ-tokaiŋ, taŋ aôm kotoc gêc andu tau atom naŋ, ma êkêŋ kôm wain to katêkwiŋa, taŋ aôm kôsê atom naŋ, ma êndêŋ taŋ ôniŋ gêŋ tau e êôc aôm tôŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Ojop taôm gebe ôliŋ Apômtau siŋ atom, gebe eŋ tec gêwê aôm kôsa aŋga gamêŋ Aiguptuŋa, taŋ kêtôm andu kapoacwalôŋa naŋ, gômôêŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Ôtêc Apômtau, aômnêm Anôtô, to ônam sakiŋ eŋ ma ôtôc lêmam ŋa ênê ŋaê. ");
INSERT INTO jae_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Andaŋguc lau tomôkê-tomôkê, taŋ sêgi amac auc naŋ, nêŋ anôtôi jaba atom, ");
INSERT INTO jae_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","gebe Apômtau, amacnêm Anôtô, taŋ gêmoa amac ŋalêlôm naŋ, gêjam lêmuŋ nê lau, gebe têntac êwiŋ eŋ taugeŋ. Embe andaŋguc anôtôi jaba, oc Apômtau, amacnêm Anôtô, têtac ŋandaŋ êsa êndêŋ amac e enseŋ amac su anaŋa aŋga nom. ");
INSERT INTO jae_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“Ansaê Apômtau, amacnêm Anôtô, amboac asaê eŋ aŋga Masa nec atom. ");
INSERT INTO jae_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Aŋgôm Apômtau, amacnêm Anôtô, nê biŋsu to ŋagôliŋ ma jatu, taŋ kêjatu amac naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ma ôŋgôm gêŋ gêdêŋ to ŋajam ênac Apômtau mataanôgeŋ ômoa ŋajamgeŋ ma ôsa gamêŋ ŋajam ôna gebe ôwê kaiŋ êtu aômnêm gamêŋ êtôm Apômtau kêtôc lêma, gebe êkêŋ êndêŋ tamami. ");
INSERT INTO jae_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Eŋ êjanda nêm ŋacjo êmuŋ aôm êtôm eŋ tau gêjac mata. ");
INSERT INTO jae_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Embe latôm êtu kênac aôm êtu ŋamu gebe ‘Biŋsu to ŋagôliŋ ma jatu, taŋ Apômtau, aêacnêŋ Anôtô, kêjatu amac naŋ, ŋam amboac ondoc,’ ");
INSERT INTO jae_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","go ôsôm êndêŋ latôm gebe ‘Aêac atu Paraonê sakiŋwaga, ma Apômtau gêwê aêac ŋa lêma ŋajaŋa asa aŋga Aiguptu amêŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Ma Apômtau kêtôc gêŋtalô to gêŋsêga kapôêŋ, taŋ kêtakê lau Aiguptu ma Parao to nê gôlôac samob gêdêŋ aêac mateŋanô alic. ");
INSERT INTO jae_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Mago eŋ gêwê aêac asa aŋga ônê amêŋ, gebe êkêŋ aêac naaô lasê gamêŋ, taŋ kêtôc lêma gêdêŋ tameŋi, gebe êkêŋ êndêŋ aêac naŋ. ");
INSERT INTO jae_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ma Apômtau kêjatu aêac gebe daŋgôm ênê biŋsu samob tonec ŋai ŋanô êsa to tatêc Apômtau, aêacnêŋ Anôtô, gebe tamoa ŋajam ŋapaŋ ma eŋ ejop aêac tamoa mateŋ jali êtôm tec galoc tamoa nec. ");
INSERT INTO jae_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ma aêac embe daŋgôm biŋsu samob tonaŋ ŋanô êsa e ŋapepgeŋ takô Apômtau, aêacnêŋ Anôtô, laŋônêmŋa êtôm tec kêjatu aêac nec, go tatu lau gêdêŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Êndêŋ taŋ Apômtau, aômnêm Anôtô, êwê aôm ô lasê gamêŋ, taŋ galoc kopeŋ gômoa naŋ, gebe ôwê kaiŋ êtu aômnêm gamêŋ naŋ, eŋ oc êjanda lau tomôkê-tomôkê êmuŋ aôm. Eŋ êjanda lau-m 7, taŋ nêŋ namba to ŋaclai kêlêlêc aômnêm su naŋ, lau Het to Girgas ma Amor to Kanaan ma Peres to Hib ma Jebus. ");
INSERT INTO jae_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ma êndêŋ taŋ Apômtau, aômnêm Anôtô, êkêŋ êsêac sêsêp aôm lêmam ma aôm ôku êsêac tulu naŋ, onseŋ êsêac su samucgeŋ sênaŋa. Ômoatiŋ poac ôwiŋ êsêac to taêm walô êsêac atomanô. ");
INSERT INTO jae_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ômansaŋ biŋ awê to ŋac sênam tauŋŋa ôwiŋ êsêac atom. Ôkêŋ latômio sênam êsêac latuŋi atom to ôkôc êsêac latuŋio sênam aôm latômi atom. ");
INSERT INTO jae_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Gebe êsêac oc sênam latômi ôkwi e sêndaŋguc aê êtiam atom ma sênam sakiŋ anôtôi jaba. Embe amboac tonaŋ, go Apômtau têtac ŋandaŋ êsa êndêŋ amac e enseŋ amac su anaŋa sebeŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Aŋgôm êsêac amboac tonec gebe anseŋ nêŋ altar su to atuc nêŋ alêpoc popoc ma asap nêŋ gwam tulu to akêŋ nêŋ anôtôi jaba nêŋ ŋakatu êsa ja êniŋ su. ");
INSERT INTO jae_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","“Gebe amac atu Apômtau, amacnêm Anôtô, nê lau dabuŋ. Apômtau, amacnêm Anôtô, kêjaliŋ amac sa aŋga lau tomôkê-tomôkê nomŋa samob, gebe atu eŋ taugeŋ nê lau. ");
INSERT INTO jae_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Apômtau têtac gêwiŋ amac to kêjaliŋ amac sa kêtu nêm namba kapôêŋ kêlêlêc lau-m ŋagêdô nêŋ suŋa nec atom. Masi, amacnêm namba sauŋanô kêlêlêc lau tomôkê-tomôkê samob nêŋ su. ");
INSERT INTO jae_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Apômtau gêwê amac ŋa lêma ŋajaŋa asa amêŋ ma kêgaboac amac su aŋga andu kapoacwalôŋa to aŋga kiŋ Aiguptuŋa Parao lêma, gebe eŋ têtac gêwiŋ amac ma gêgôm biŋ, taŋ kêtôc lêma gêdêŋ amac tamemi naŋ, ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Amboac tonaŋ ajala gebe Apômtau, amacnêm Anôtô, eŋ Anôtô ŋanô. Eŋ Anôtô ŋaŋêŋ, taŋ kêsap nê poac tôŋ ma têtac gêwiŋ êsêac, taŋ têntac gêwiŋ eŋ ma sêmansaŋ ênê biŋsu naŋ, oc êmoasiŋ êsêac gôlôac to gôlôac ŋêŋgeŋ êna. ");
INSERT INTO jae_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Mago Anôtô êkêŋ ŋagêjô êndêŋ êsêac, taŋ têntac gedec eŋ naŋ, êpi êsêac tauŋ ôliŋ ma enseŋ êsêac su. Eŋ ê lau, taŋ têntac gedec eŋ naŋ, nêŋ biŋ tôŋ atom. Masigoc, êkêŋ ŋagêjô êpi êsêac tauŋ ôliŋ solopgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Amboac tonaŋ ôŋgôm biŋsu to ŋagôliŋ ma jatu, taŋ galoc kajatu aôm naŋ, ŋanô êsamaŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“Aŋô to aŋgôm ŋagôliŋ tonaŋ ŋanô êsa, ma Apômtau, amacnêm Anôtô, êsap poac tau tôŋ to têtac êwiŋ amac êtôm kêtôc lêma gêdêŋ tamemi. ");
INSERT INTO jae_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Eŋ oc têtac êwiŋ aôm ma ênam mec aôm to êŋgôm aôm ôtu taêsam. Eŋ ênam mec aôm ôlim ŋaŋanô to nêm nom ŋanô amboac polom to wain ma katêkwi. Eŋ ênam mec nêm bulimakao têtu taêsam to domba ŋalatu amboac tonaŋ. Eŋ êŋgôm gêŋ tau aŋga gamêŋ, taŋ kêtôc lêma gêdêŋ tamami, gebe êkêŋ êndêŋ aôm naŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Eŋ ênam mec aôm êlêlêc lau-m ŋagêdô samob su. Nêm ŋacwaga samob sêka gôlôac lasê to nêm lauo kapoac teŋ sêmoa atom. Ma nêm bulimakao samob sêsu ŋalatu amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Apômtau gebe êmbalaŋ gêmac tokaiŋ-tokaiŋ auc êndêŋ aôm ma lau Aiguptu nêŋ gêmac, taŋ ajala kêtu tôŋ naŋ, ŋateŋ êtap aôm sa atom. Ma Apômtau ênac lau samob, taŋ têntac gedec aôm naŋ, ŋa gêmac tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Aôm onseŋ lau-m samob, taŋ Apômtau, aômnêm Anôtô, êkêŋ êsêp aôm lêmam naŋ, su. Taêm walô êsêac atom to ônam sakiŋ nêŋ anôtôi atom amboac tonaŋgeŋ, gebe oc êtu lakô ênac aômŋa. ");
INSERT INTO jae_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“Aôm moae ôsôm êndêŋ taôm gebe ‘Lau-m tonec nêŋ namba kêlêlêc aêŋoc su, oc jajanda êsêac amboac ondocgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ôtêc êsêac atom. Taêm ênam gêŋ, taŋ Apômtau, aômnêm Anôtô, gêgôm gêdêŋ Parao to gamêŋ Aiguptuŋa samucgeŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Taêm ênam gêŋwapac to gêŋsêga ma gêŋtalô, taŋ matamanô gôlic naŋ, ma taêm ênam Apômtau, aômnêm Anôtô, lêma ŋajaŋa, taŋ kêmêtôc ma gêwê aôm kôsa gômôêŋ naŋ. Apômtau, aômnêm Anôtô, oc êŋgôm lau-m samob, taŋ aôm kôtêc êsêac naŋ, êtôm tonaŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Ma eŋ êŋgôm gêŋ teŋ êlêlêc su êwiŋ, eŋ êsakiŋ banic kapôêŋ-kapôêŋ êndêŋ êsêac e enseŋ lau ŋapopoc, taŋ gacgeŋ sêmoa to sêsiŋ tauŋ êndêŋ aôm naŋ, su amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ôtêc êsêac atom, gebe Apômtau, aômnêm Anôtô, gêmoa aôm ŋalêlôm. Eŋ Anôtô kapôêŋ ma kaiŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Ma Apômtau, aômnêm Anôtô, oc êtiŋ lau-m tonaŋ su malô-malô êmuŋ aôm. Aôm oc ôtôm gebe onseŋ êsêac su sep tageŋ atom. Embe ôŋgôm, oc bôc saleŋŋa têtu taêsam ma sêkêŋ wapac aôm. ");
INSERT INTO jae_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Mago Apômtau, aômnêm Anôtô, oc êkêŋ êsêac sêsêp aôm lêmam ma êlênsôŋ êsêac e nêŋ meloco êsa ma sênaŋa. ");
INSERT INTO jae_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Eŋ oc êkêŋ êsêacnêŋ kiŋ sêsêp aôm lêmam ma aôm onseŋ êsêacnêŋ ŋaê su aŋga nom. Ŋac teŋ êtôm gebe êkô aôm auc atom e onseŋ êsêac samob su. ");
INSERT INTO jae_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ôkêŋ êsêacnêŋ anôtôi gwam ja êniŋ su. Matam katu silber to gold, taŋ kêtu ŋakatu tau ŋagêlôŋ naŋ, ma ôkôc su atom, gebe oc êtu lakô ênac aômŋa, gebe Apômtau, aômnêm Anôtô, gêlic gêŋ tonaŋ amboac gêŋ alôb-alôb. ");
INSERT INTO jae_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ôkêŋ gêŋ alôb-alôb êsô nêm andu êna atom. Apômtau kêpuc boa gêŋ tau ma eŋ oc êpuc boa aôm amboac tonaŋgeŋ. Ôlic gêŋ tau amboac gêŋ ŋatêmui to alôb-alôb, gebe Apômtau kêpuc boa gêŋ tau su. ");
INSERT INTO jae_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“Ajop ŋapep gebe aŋgôm biŋsu samob, taŋ galoc kajatu amac naŋ, ŋanô êsa, gebe amoa matem jali to atu taêsam ma asa gamêŋ, taŋ Apômtau, amacnêm Anôtô, kêtôc lêma gebe êkêŋ êndêŋ tamemi naŋ, e awê kaiŋ gamêŋ tau êtu amacnêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Ma taêm ênam intêna samob, taŋ Apômtau, aômnêm Anôtô, gêwê aôm gêdêŋ taŋ gômoa gamêŋ sawa kêtôm jala 40 naŋ, gebe êkôniŋ aôm to ênsaê aôm e êjala biŋ, taŋ gêc nêm ŋalêlôm naŋ, ma êjala aôm oc ôŋgôm ênê biŋsu ŋanô êsa me masi. ");
INSERT INTO jae_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Eŋ kêkôniŋ aôm to kêkêŋ mo gêjô aôm, go kêkêŋ mana, taŋ aôm gôjam kauc naŋ, gêdêŋ aôm goeŋ. Aôm tamami sêjam kauc mana amboac tonaŋgeŋ. Eŋ gêgôm gêŋ tonaŋ, gebe ôjala gebe mo tageŋ gêôc ŋamalac tôŋ atom. Biŋ samob, taŋ kêsa aŋga Apômtau awa naŋgeŋ, tec gêôc ŋamalac tôŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Gêdêŋ jala 40 tonaŋ aômnêm ŋakwê, taŋ kôsô naŋ, kêtu manê atom ma amkaiŋ kêtiŋ atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Amboac tonaŋ ôjala ênêc nêm ŋalêlômgeŋ, gebe Apômtau, aômnêm Anôtô, kêmêtôc aôm kêtôm ŋac teŋ kêmêtôc latu. ");
INSERT INTO jae_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Tec ôŋgôm Apômtau, aômnêm Anôtô, nê biŋsu ŋanô êsa ma ôsa ênê lêŋ to ôtêc eŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Biŋŋanô, Apômtau, aômnêm Anôtô, gêwê aôm, gebe naô lasê gamêŋ ŋajam teŋ. Bu to bumata kêpoac gamêŋ tau, ma bu kêpulu aŋga gaboaŋ to lôc. ");
INSERT INTO jae_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Gêŋ tokaiŋ-tokaiŋ gêjam ŋanô ŋajam aŋga nom tau. Polom to jaŋgom ma wain to jambô ma aiŋ to katêkwi ma lêp. ");
INSERT INTO jae_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Aŋga gamêŋ tonaŋ aôm ôniŋ polom e êôc aôm tôŋ ma ôpô lêna gêŋ teŋ atom. Gamêŋ tau ŋapoc gêdêŋ ki jejec ma aôm oc ôkwê ki kokoc aŋga gamêŋ tau ŋalôc. ");
INSERT INTO jae_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Aôm ôniŋ gêŋ e êôc aôm tôŋ ma ôlambiŋ Apômtau, aômnêm Anôtô, gebe kêkêŋ gamêŋ ŋajam gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Ojop taôm gebe ôliŋ Apômtau, aômnêm Anôtô, siŋ atom. Amboac tonaŋ ôŋgôm ênê biŋsu to ŋagôliŋ ma jatu, taŋ galoc kajatu aôm naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Aôm embe ôniŋ gêŋ e êôc aôm tôŋ to ôŋgôŋ andu ŋajam, taŋ kôkwê naŋ, ");
INSERT INTO jae_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ma embe nêm bulimakao to domba ŋatoŋ têtu taêsam ma nêm silber to gold êtu kapôêŋ to nêm gêŋ samob êtu taêsam, ");
INSERT INTO jae_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","go nêm ŋalêlôm etoc tau sa e ôliŋ Apômtau, aômnêm Anôtô, siŋ atom, gebe eŋ tec gêwê aôm kôsa aŋga Aiguptu, taŋ kêtu andu kapoacwalôŋa naŋ, gômôêŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Eŋ gêwê aôm golom-golom gamêŋ sawa kapôêŋ to kaiŋ teŋ. Moac ŋaclai to alidêbu sêmoa gamêŋ tau ma bu masi e nom gêôc kêkôc-kêkôc. Mago eŋ kêkêŋ bu kêsa poctêmui aôm gônôm. ");
INSERT INTO jae_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Eŋ gêlôm aôm aŋga gamêŋ sawa ŋa mana, taŋ tamami sêjam kauc naŋ, gebe êkôniŋ to ênsaê aôm, ma êmoasiŋ aôm êtu ŋamu. ");
INSERT INTO jae_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ôlic taôm gebe ôsôm biŋ tonec ênêc nêm ŋalêlôm gebe Aêŋoc ŋaclai to lemoc ŋajaŋa kêkêŋ aê katu ŋac tolêlôm, nec atom. ");
INSERT INTO jae_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Taêm ênam Apômtau, aômnêm Anôtô, gebe eŋ tec kêkêŋ ŋaclai gêdêŋ aôm, tec kôtu ŋac tolêlôm. Eŋ gêgôm gêŋ tau gebe êŋgôm poac, taŋ kêmoatiŋ gêdêŋ tamami naŋ, ŋanô êsa amboac asaê galoc. ");
INSERT INTO jae_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Galoc aê jakêŋ puc aôm, gebe aôm embe ôliŋ Apômtau, aômnêm Anôtô, siŋ to ôndaŋguc anôtôi jaba ma ônam sakiŋ êsêac to oteŋ mec êndêŋ êsêac, go ônaŋa biŋŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Aôm embe taŋam wamu Apômtau, aômnêm Anôtô, awa atom, oc ônaŋa ôtôm lau tomôkê-tomôkê, taŋ Apômtau kêsêlêŋ gêmuŋ aôm ma geseŋ êsêac su naŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“O Israel, ôŋô acgom, galoc aôm gobe olom bu Jordan gebe naôsa gamêŋ tau ma ôjanda lau tomôkê-tomôkê kapôêŋ to ŋajaŋa sêlêlêc aôm su ma ôku malac kapôêŋ totuŋbôm baliŋ, taŋ ŋatêpôê jadiŋgeŋ undambê naŋ, tulu. ");
INSERT INTO jae_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Oc ôjanda lau Anakim. Aôm kôjala êsêac gebe lau-m kapôêŋ to lau waso-waso. Aôm gôŋô lau sêsôm biŋ kêpi êsêac gebe ‘Asa oc êtôm gebe êkô ŋajaŋa êtu Anak latuiŋa.’ ");
INSERT INTO jae_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Amboac tonaŋ galoc ôjala, gebe Apômtau, aômnêm Anôtô, elom êmuŋ aôm. Eŋ kêtôm ja, taŋ kêdaŋgac gêŋ naŋ. Eŋ êsêlêŋ êmuŋ aôm ma enseŋ êsêac su to êku êsêac tulu, tec aôm ôjanda êsêac to onseŋ êsêac su sebeŋ êtôm Apômtau, aômnêm Anôtô, gêjac mata gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“Êndêŋ taŋ Apômtau, aômnêm Anôtô, êsêlêŋ êmuŋ aôm ma êjanda êsêac su naŋ, ôsôm biŋ tonec ênêc nêm ŋalêlôm gebe Apômtau kêkêŋ gamêŋ tonec kêtu aêacnêŋ gamêŋ gêjô aêacnêŋ ŋajam nec atom. Apômtau êsêlêŋ êmuŋ aôm to êjanda lau-m tonaŋ su êtu êsêacnêŋ secŋa. ");
INSERT INTO jae_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Aôm ôsa gamêŋ tonec e êtu aômnêm gamêŋ êtu nêm biŋ gêdêŋŋa me êtu nêm ŋalêlôm ŋakêŋkêŋŋa atom, masianô. Apômtau, aômnêm Anôtô, êsêlêŋ êmuŋ aôm ma êjanda lau-m tonaŋ êtu êsêacnêŋ secŋa. Ma teŋ, eŋ gebe êŋgôm biŋ, taŋ kêtôc lêma gêdêŋ tamami Abraham agêc Isak ma Jakob naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","“Amboac tonaŋ ôjala gebe Apômtau, aômnêm Anôtô, êkêŋ gamêŋ ŋajam tonec êtu aômnêm gamêŋ êtu nêm biŋ gêdêŋŋa atom, gebe aôm ŋac gêsômtêkwa ŋatoŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Taêm ênam ma ôliŋ siŋ atom, gebe gôgôm Apômtau, aômnêm Anôtô, têtac ŋandaŋ kêsa aŋga gamêŋ sawaŋa. Gêdêŋ taŋ awi Aiguptu siŋ e mêŋaô lasê gamêŋ tonec naŋ, ali awem sa gêdêŋ Apômtau ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Amac agôm Apômtau têtac ŋandaŋ kêsa aŋga lôc Horeb e têtac ŋandaŋ ŋanô ma gebe enseŋ amac su. ");
INSERT INTO jae_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Aê kapi lôc gaja gebe jakôc poc tapa. Poc tapa tau poac, taŋ Apômtau kêmoatiŋ gêdêŋ amac naŋ, ŋapoc tapa. Aê gamoa lôc geleŋŋa 40 to gêbêcauc 40 ma gaeŋ to ganôm gêŋ teŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Ma Apômtau kêkêŋ poc tapa luagêc tonaŋ gêdêŋ aê. Anôtô tau lêma keto biŋ kêsêp. Eŋ keto biŋ samob, taŋ kêsôm gêdêŋ amac kêsa aŋga ja ŋalêlôm gêmêŋ gêdêŋ bêc, taŋ akac sa amoa lôc naŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Geleŋŋa 40 to gêbêcauc 40 gêbacnê, go Apômtau kêkêŋ poc tapa luagêc, taŋ kêtu poac tau ŋapoc tapa naŋ, gêdêŋ aê. ");
INSERT INTO jae_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Go Apômtau kêsôm gêdêŋ aê gebe ‘Ajôc, ôndi, ôsêp sebeŋ ôna, gebe nêm lau, taŋ gôwê êsêac aŋga Aiguptu sêmêŋ naŋ, sêgôm sec. Êsêac sêwi intêna, taŋ aê kajatu êsêac gebe sêsa naŋ, siŋ sebeŋ. Êsêac sêpac ki gêwê ma sêmasaŋ nêŋ ŋakatu teŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“Ma Apômtau kêsôm biŋ teŋ gêwiŋ gêdêŋ aê gebe ‘Aê galic lau tônê ma kajala êsêac gebe lau gêsuŋtêkwa ŋatoŋ sec. ");
INSERT INTO jae_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Ôwi aê siŋ gebe janseŋ êsêac tonêŋ ŋaêgeŋ su aŋga umboŋ ŋalabu. Go jakêŋ aôm ôtu lau-m kapôêŋ to ŋajaŋa ôlêlêc êsêac su.’ ");
INSERT INTO jae_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Amboac tonaŋ aê kasêp aŋga lôc gamêŋ, ma ja kêsa lôc tau. Ma aê kakôc poac ŋapoc tapa luagêc ŋa lemoc lulugeŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Go galic gêŋ tau. Amac agôm sec gêdêŋ Apômtau, amacnêm Anôtô. Amac apac ki gêwê ma amasaŋ nêm bulimakao ŋalatu ŋakatu to awi intêna, taŋ Apômtau kêjatu amac gebe asaŋa naŋ, siŋ sebeŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Tec aê kakôc poc tapa luagêc tau ŋa lemoc lulugeŋ ma kabaliŋ gêŋ tau siŋ e gêjac popoc gêc amac laŋômnêmŋa. ");
INSERT INTO jae_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Go aê gau tau gaêc Apômtau laŋônêmŋa geleŋ 40 to gêbêcauc 40 kêtôm gagôm gêdêŋ ŋasawa teŋ su. Aê gaeŋ to ganôm gêŋ teŋ atom kêtu amacnêm sec samob, taŋ agôm naŋŋa. Amac asa lêŋ, taŋ gêjac Apômtau mataanô ŋajam atomanô naŋ, e agôm eŋ têtac ŋandaŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Gebe aê katêc Apômtaunê têtac ŋandaŋ to têtac kêbôli auc gêdêŋ amacŋa, taŋ kêkac eŋ gebe enseŋ amac su naŋ. Mago Apômtau kêkêŋ taŋa aê gêdêŋ ŋasawa tonaŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Ma Apômtau têtac ŋandaŋ gêdêŋ Aron gêwiŋ ma gebe enseŋ eŋ su amboac tonaŋgeŋ. Tec gêdêŋ ŋasawa tonaŋ kateŋ eŋ kêtu Aronŋa gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Go aê kakôc bulimakao ŋalatu, amac lemem ŋakôm sec tonaŋ ma kakêŋ ja geŋ, go katuc popoc ma kalêsim e kêtôm kekop, ma kapalip ŋakekop tau kêsêp bu, taŋ keseleŋ aŋga lôc kêsêp gêmêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“Aŋga Tabera to Masa ma Kibrot-Hatawa amac agôm Apômtau têtac ŋandaŋ kêsa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Ma gêdêŋ taŋ Apômtau kêsakiŋ amac aŋga Kades-Barnea naŋ, kêsôm gebe ‘Api ana ma akôc gamêŋ, taŋ kakêŋ gêdêŋ amac, gebe êtu amacnêm gamêŋ naŋ,’ amac ali awem sa gêdêŋ Apômtau, amacnêm Anôtô, nê biŋsu ma akêŋ gêwiŋ eŋ to taŋem wamu eŋ awa atom. ");
INSERT INTO jae_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Aê kajala amac ali awem sa gêdêŋ Apômtau wanêcgeŋ e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Amboac tonaŋ aê gau tauc gaêc Apômtau laŋônêmŋa kêtôm geleŋŋa 40 to gêbêcauc 40, gebe Apômtau kêsôm, gebe oc enseŋ amac su. ");
INSERT INTO jae_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Ma aê kateŋ mec gêdêŋ Apômtau gebe ‘O Apômtau Anôtô, onseŋ nêm lau to nêm gêŋlênsêm su atom. Aôm gôjam êsêac kêsi ŋa nêm ŋaclai kapôêŋ to gôwê êsêac ŋa lêmam ŋajaŋa sêsa aŋga Aiguptu sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Taêm ênam nêm sakiŋwaga Abraham agêc Isak ma Jakob. Matam ê lau tonaŋ nêŋ gêsuŋtêkwa ŋatoŋ to nêŋ geo ma nêŋ sec atom, ");
INSERT INTO jae_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","gebe lau aŋga gamêŋ, taŋ aôm gôwê aêac asa amêŋ naŋ, oc sêsôm gebe “Êsêacnêŋ Anôtô kêtôm, gebe êwê êsêac nasêô lasê gamêŋ, taŋ gêjac mata gêdêŋ êsêac naŋ, atom. Eŋ têtac gedec êsêac, tec gêwê êsêac sêsa gamêŋ sawa sêja, gebe ênac êsêac êndu aŋga tônê.” ");
INSERT INTO jae_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Mago êsêac têtu nêm lau to nêm gêŋlênsêm sugac. Aôm kômêtôc lêmam ma gôwê êsêac ŋa nêm ŋaclai kapôêŋ sêsa sêmêŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“Gêdêŋ ŋasawa tonaŋ Apômtau kêsôm gêdêŋ aê gebe ‘Ôpa poc tapa luagêc êtôm ŋamataŋa, go ôpi lôc ôndêŋ aê ômôêŋ ma ômansaŋ katapa teŋ ŋa ka. ");
INSERT INTO jae_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Ma aê gabe jato biŋ, taŋ kato kêsêp poc tapa ŋamataŋa, tê gôjac popoc nê, êsêp poc tapa tau su, go ôkêŋ êsêp katapa tau.’ ");
INSERT INTO jae_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Tec aê kamasaŋ katapa ŋa kaleloŋ ma kapa poc tapa luagêc kêtôm ŋamataŋa, go kakôc poc tapa luagêc tau ŋa lemoc ma kapi lôc gaja. ");
INSERT INTO jae_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Ma eŋ keto biŋ kêsêp poc tapa tonaŋ kêtôm keto kêsêp poc tapa ŋamataŋa. Apômtau keto biŋsu 10, taŋ kêsôm gêdêŋ amac kêsa aŋga ja ŋalêlôm gêmêŋ gêdêŋ taŋ akac sa amoa lôc naŋ. Keto su, go kêkêŋ gêdêŋ aê. ");
INSERT INTO jae_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Go kakac tauc ôkwi ma kasêp aŋga lôc gamêŋ e kakêŋ poc tapa luagêc kêsêp katapa, taŋ kamasaŋ naŋ. Poc tapa gêc katapa gêc, kêtôm Apômtau kêjatu aê.” ");
INSERT INTO jae_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Lau Israel dêdi aŋga Berot-Bene-Jakan sêsêlêŋ sêja jasêsa Mosera. Aŋga tônê Aron gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Aŋga tônê êsêac dêdi jasêsa Gudgoda. Aŋga Gudgoda êsêac dêdi jasêsa Jotbata, aŋga gamêŋ tonaŋ bu ŋagêdô kêpoac. ");
INSERT INTO jae_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Gêdêŋ ŋasawa tonaŋ Apômtau kêjaliŋ Lewinê gôlôacmôkê sa, gebe sêmbalaŋ Apômtaunê katapa poacŋa ma sêkô Apômtau laŋônêmŋa to sênam sakiŋ eŋ ma sênam mec lau ŋa ênê ŋaê. Kôm tonaŋ êsêac sêjam e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Kêtu tonaŋŋa Lewi gêwê kaiŋ nom to gêŋlênsêm gêwiŋ nê lasitêwai atom. Apômtau tau kêtu nê gêŋlênsêm kêtôm Apômtau, aômnêm Anôtô, tau kêsôm gêdêŋ eŋ.) ");
INSERT INTO jae_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“Aê gamoa lôc geleŋŋa 40 to gêbêcauc 40 kêtôm ŋamataŋa ma Apômtau kêkêŋ taŋa aê gêdêŋ ŋasawa tonaŋ kêtiam. Apômtau gebe enseŋ aôm su atom. ");
INSERT INTO jae_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Ma Apômtau kêsôm gêdêŋ aê gebe ‘Ôndi, ôsêlêŋ ômuŋ lau tonec gebe sêsa gamêŋ, taŋ katôc lemoc gêdêŋ êsêac tameŋi, gebe jakêŋ êndêŋ êsêac naŋ, ma gamêŋ tau êtu êsêacnêŋ gamêŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“O Israel, galoc Apômtau, aômnêm Anôtô, taê kêka gêŋ ondoc aŋga aômnêm. Eŋ taê kêka tageŋ tonec gebe ôtêc Apômtau, aômnêm Anôtô, ma ôsa ênê lêŋ samob, têmtac êwiŋ eŋ ma ônam sakiŋ Apômtau, aômnêm Anôtô, tonêm ŋalêlôm samuc ma nêm katôm samuc ");
INSERT INTO jae_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ma ômansaŋ Apômtaunê biŋsu to ŋagôliŋ, taŋ galoc kajatu aôm naŋ, êtu tôŋ gebe ômoa ŋajamgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ôlic acgom, Apômtau, aômnêm Anôtô, kêtu undambê to undambê ŋaundambê ma nom to gêŋ nomŋa samob ŋatau. ");
INSERT INTO jae_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Mago Apômtau kêkêŋ nê ŋalêlôm gêdêŋ tamamigeŋ to têtac gêwiŋ êsêacgeŋ. Ma eŋ kêjaliŋ êsêacnêŋ wakuc, amac taômgeŋ, sa aŋga lau tomôkê-tomôkê samob nêŋ e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Amboac tonaŋ anam taôm ôkwi e nêm ŋalêlôm êtu selec ma awi gêsômtêkwa ŋatoŋ siŋmaŋ. ");
INSERT INTO jae_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Gebe Apômtau, amacnêm Anôtô, eŋ anôtôinêŋ Anôtô to apômtauinêŋ Apômtau. Eŋ Anôtô kapôêŋ ma ŋajaŋa kaiŋ teŋ. Eŋ kêpuc opeŋ lau atom to gedec lau sêjac papac eŋ ŋa nêŋ awa. ");
INSERT INTO jae_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Eŋ kêmêtôc mosêbu to awêtuc nêŋ biŋ solopgeŋ. Eŋ têtac gêwiŋ ŋac jaba ma kêkêŋ mo to ŋakwê gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Amboac tonaŋ têmtac êwiŋ lau jaba amboac tonaŋgeŋ, gebe amac amoa amboac lau jaba gêdêŋ taŋ aŋgôŋ gamêŋ Aiguptuŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Ôtêc Apômtau, aômnêm Anôtô, ma ônam sakiŋ eŋ to ôsap eŋ tôŋ ma otoc lêmam ôsam eŋ taugeŋ nê ŋaê. ");
INSERT INTO jae_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Eŋ kêtu aômnêm lambiŋ ŋam. Eŋ kêtu aômnêm Anôtô, taŋ gêgôm gêŋsêga kaiŋ teŋ naŋ, matamanô gôlic. ");
INSERT INTO jae_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Aôm tamami sêsêp Aiguptu sêja, êsêac lau 70geŋ. Ma galoc Apômtau, aômnêm Anôtô, kêkêŋ aôm kôtu taêsam amboac utitalata undambêŋa.” ");
INSERT INTO jae_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Go Mose kêsôm gebe “Biŋsu to ŋagôliŋ gebe aŋgôm ŋanô êsa aŋga gamêŋ, taŋ Apômtau, amac tamemi nêŋ Anôtô, kêkêŋ gêdêŋ amac awê kaiŋ naŋ, tau tonec. Ajop biŋ tau êndêŋ bêc samob, taŋ amac amoa matem jali aŋga nom naŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Anseŋ tenteŋlatui, taŋ amac oc aku tulu naŋ, nêŋ gamêŋ sêjam sakiŋ nêŋ anôtôi jabaŋa aŋga lôc ŋatêpôê to ŋabau ma ajuŋtêna su samucgeŋ biŋŋanô. ");
INSERT INTO jae_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Akac nêŋ altar su ma atuc nêŋ alê popoc to akêŋ ja êniŋ nêŋ ŋakatu Aseraŋa ma amakiŋ nêŋ anôtôi nêŋ ŋakatu to anseŋ êsêacnêŋ ŋaê su aŋga gamêŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Amac aŋgôm êndêŋ Apômtau, nêm Anôtô kêtôm êsêac sêgôm naŋ, atom. ");
INSERT INTO jae_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Mago amac oc andêŋ gamêŋ, taŋ Apômtau, êjaliŋ sa êtu amacnêm gôlôacmôkê samob nêŋ naŋ, gebe êtu ênê ŋaê ŋamala. ");
INSERT INTO jae_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Andêŋ gamêŋ tonaŋgeŋ ajoŋ nêm daja to da ŋagêdô ma nêm gêŋ lemeŋlu-lemeŋlu ŋatageŋ-tageŋ ŋada to nêm da samob, taŋ abe akêŋ naŋ, ma da daŋge to da tôpŋa ma da bôc ŋamêc samobŋa ana. ");
INSERT INTO jae_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Ma aŋga tonaŋ amac aniŋ gêŋ amoa Apômtau, nêm Anôtô laŋônêmŋa to atu samuc to nêm gôlôacŋa êtu gêŋ samobŋa, taŋ agôm ma Apômtau gêjam mec amac naŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Aŋgôm gêŋ tau êtôm aêac dagôm gêdêŋ ocsalô tonec nec atom, gebe amac samob agôm nêm gêŋ kêtôm taôm taêm gêjam to alic ŋajam naŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Gebe amac jaalêwaŋ taôm to atap nêm nomlênsêm, taŋ Apômtau, nêm Anôtô gebe êkêŋ êndêŋ amac naŋ, sa su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Mago embe alom bu Jordan ma aŋgôŋ gamêŋ, taŋ Apômtau, nêm Anôtô êkêŋ êndêŋ amac awê kaiŋ naŋ, ma enseŋ amacnêm ŋacjo samob, taŋ sêŋgi amac auc naŋ, su gebe alêwaŋ taôm e amoa towamageŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Go akôc nêm gêŋ samob, taŋ kajatu amac naŋ, amêŋ gamêŋ tau, taŋ Apômtau, nêm Anôtô, êjaliŋ sa gebe êtu ênê ŋaê ŋamala naŋ. Akôc nêm daja to da ŋagêdô ma nêm gêŋ lemeŋlu-lemeŋlu ŋatageŋ-tageŋ ŋada to nêm da, taŋ ŋalêlôm êkac amac gebe akêŋ naŋ, to da, taŋ akêŋ êtu daŋge to tôp anac mata êndêŋ Apômtau naŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Ma amac to nêm latômio to ŋac ma nêm sakiŋwagao to ŋac ma lau Lewi, taŋ sêŋgôŋ nêm malac, mago sêwê kaiŋ nomlênsêm sêwiŋ amac atom naŋ atu samuc Apômtau, amacnêm Anôtô. ");
INSERT INTO jae_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Ojop taôm gebe ôkêŋ nêm daja aŋga gamêŋ, taŋ ôlic naŋ paliŋ-paliŋgeŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Ôkêŋ nêm daja aŋga gamêŋ tageŋ, taŋ Apômtau oc êjaliŋ sa aŋga nêm gôlôacmôkê nêŋ teŋ. Aŋga tonaŋ amac akêŋ nêm daja ma aŋgôm gêŋ samob, taŋ kajatu amac naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“Mago aôm ôtôm gebe ômbuc to ôniŋ ŋamêsôm aŋga nêm malac samob êndêŋ-êndêŋgeŋ êtôm nêm ŋalêlôm êkac aômŋa ma êtôm moasiŋ, taŋ Apômtau, nêm Anôtô kêkêŋ gêdêŋ aôm. Lau selec to selec atom naŋ lulugeŋ têtôm gebe sêniŋ tonaŋ amboac noniŋ saleŋŋa to mojawa. ");
INSERT INTO jae_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Tageŋ dec tec ôniŋ atom, ôkêc siŋ êsêp nom amboac kôkêc bu siŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Aôm ôniŋ polom ma ônôm wain to katêkwi lemeŋlu-lemeŋlu ŋatageŋ-tageŋ aŋga nêm malac atom. Ma ôniŋ bulimakao to domba ŋamêc ma da daŋge to da, taŋ nêm ŋalêlôm êkac aômŋa gebe ôkêŋ naŋ, ma gêŋ ŋagêdô, taŋ gobe ôkêŋ êtu da naŋ, aŋga nêm malac atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Mago aôm to nêm latômio to ŋac ma nêm sakiŋwagao to ŋac ma ŋac Lewi, taŋ êŋgôŋ nêm malac êwiŋ aôm naŋ, aniŋ amoa Apômtau, nêm Anôtô laŋônêm aŋga gamêŋ, taŋ Apômtau, nêm Anôtô êjaliŋ sa ma amac atu samuc amoa Apômtau, nêm Anôtô laŋônêmŋa êtu lemem ŋakôm ŋanôŋa. ");
INSERT INTO jae_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Ajop taôm gebe aliŋ nêm ŋac Lewi siŋ êndêŋ ŋasawa samucgeŋ, taŋ amoa nêm gamêŋ naŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“Apômtau, nêm Anôtô embe êkêŋ gamêŋ esewec êtu kapôêŋ êtôm eŋ gêjac mata gêdêŋ aôm ma bôc êjô aôm e ôsôm gebe ‘Aê gabe janiŋ bôc,’ naŋ ôniŋ êtôm ŋalêlôm êkac aômŋa. ");
INSERT INTO jae_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Mago gamêŋ, taŋ Apômtau, nêm Anôtô êjaliŋ sa gebe ênê ŋaê ênêc aŋga tonaŋ naŋ, ênêc jaêcgeŋ êlêlêc aôm, go aôm taôm ôtôm gebe ômbuc nêm bôc teŋ, taŋ Apômtau êkêŋ êndêŋ aôm êtôm aê kajatu aôm naŋ. Ma aôm ôtôm gebe ôniŋ aŋga taômnêm malac êtôm nêm ŋalêlôm êkac aômŋa. ");
INSERT INTO jae_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Ôniŋ amboac sêniŋ noniŋ saleŋŋa to mojawa. Lau selec me selec atom lulugeŋ têtôm gebe sêniŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Mago ojop gebe ôniŋ dec êwiŋ atom gebe tamoa mateŋ jali ŋam kêsêp dec ŋalêlôm, tec ôniŋ mateŋ jali ŋam êwiŋ ŋamêsôm atom. ");
INSERT INTO jae_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ôniŋ atom, ôkêc siŋ amboac tasêwa bu siŋ êsêp nom. ");
INSERT INTO jae_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ôniŋ atom. Embe ôŋgôm gêŋ, taŋ ênac Apômtau mataanô ŋajam, go aôm to nêm wakuc amoa ŋajam. ");
INSERT INTO jae_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Mago gêŋ, taŋ aôm gôjac mata ma gôjam dabuŋ gêdêŋ Apômtau naŋ, aôm ôkôc ôna gamêŋ, taŋ Apômtau êjaliŋ sa naŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Ma ôkêŋ nêm daja ŋamêsôm to dec ênsac Apômtau, nêm Anôtô nê altar ŋaô. Dec tau oc sêkêc êpi Apômtau, nêm Anôtô nê altar, mago ŋamêsôm tau aôm ôtôm gebe ôniŋ. ");
INSERT INTO jae_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Mago ojop taôm to ôkêŋ taŋam biŋ samob, taŋ kajatu aôm naŋ ŋapep. Embe ôŋgôm gêŋ samob, taŋ Apômtau, nêm Anôtô êlic to ênac eŋ mataanô ŋajam naŋ, go aôm to nêm wakuc amoa ŋajam ŋapaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“Êndêŋ taŋ Apômtau, nêm Anôtô, enseŋ tenteŋlatui êmuŋ aôm aŋga gamêŋ, taŋ aôm ôsêlêŋ ôsa gebe ôku êsêac tulu naŋ, ma êndêŋ taŋ aôm ôku êsêac tulu ma ôŋgôŋ nêŋ gamêŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","go ojop taôm gebe lakô, taŋ gêjac êsêac naŋ, ênac aôm atom. Apômtau êku êsêac tulu êmuŋ aôm, tec ôtêku êsêac ma ôkip êsêacnêŋ anôtôi jaba ŋam sa atom. Mago asôm biŋ tonec gebe ‘Lau tonaŋ sêjam sakiŋ nêŋ anôtôi amboac ondoc. Aê gabe jaŋgôm êtôm êsêac sêgôm nê atom.’ ");
INSERT INTO jae_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Ôŋgôm tonaŋ êndêŋ Apômtau, nêm Anôtô atom. Êsêac sêgôm gebe gêŋ samob, taŋ Apômtau, nêm Anôtô têtac gedec ma gêlic amboac gêŋ alôb-alôb naŋ, gêdêŋ nêŋ anôtôi jabaŋa. Êsêac sêkêŋ nêŋ latuŋio to ŋac ja geŋ kêtu tetoc nêŋ anôtôi jaba saŋa su. ");
INSERT INTO jae_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Gêŋ samob, taŋ aê kajatu aôm gebe ôŋgôm naŋ, ôŋgôm ŋanô êsa ŋapepgeŋ. Ônac têku biŋ teŋ ma onseŋ biŋ teŋ su atomanô. ");
INSERT INTO jae_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“Embe propete teŋ êndi sa aŋga amac ŋalêlôm me ŋac teŋ, taŋ gêc mê naŋ, êtôc gêŋsêga me gêŋtalô teŋ êndêŋ aôm ");
INSERT INTO jae_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ma gêŋsêga to gêŋtalô, taŋ eŋ kêtôc gêdêŋ aôm naŋ ŋanô êsa ma eŋ embe êsôm gebe ‘Tandaŋguc anôtôi jaba ŋagêdô ma tanam sakiŋ êsêac’, taŋ ajam kauc êsêac gêmuŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","go ôkêŋ taŋam propete me ŋac taŋ gêc mê tonaŋ nê biŋ atomanô, gebe Apômtau, amacnêm Anôtô kêsaê amac e ajala gebe têmtac gêwiŋ Apômtau, nêm Anôtô tonêm ŋalêlôm samuc ma nêm katôm samuc me masi. ");
INSERT INTO jae_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Andaŋguc Apômtau, nêm Anôtô ma atêc eŋ to ajop ênê biŋsu ma taŋem wamu ênê awa to anam sakiŋ eŋ ma asap eŋ tôŋ. ");
INSERT INTO jae_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Mago propete me ŋac, taŋ gêc mê tonaŋ êmac êndu gebe eŋ gêli nêm ŋalêlôm sa gêdêŋ Apômtau, amacnêm Anôtô, taŋ kêkôc amac su aŋga gamêŋ Aiguptuŋa ma gêjam aôm kêsi aŋga andu kapoacwalôŋa naŋ, ma eŋ kêkêli aôm gebe ôwi lêŋ tau, taŋ Apômtau, nêm Anôtô kêjatu aôm gebe ôsa naŋ siŋ. Amboac tonaŋ aôm onseŋ sec, taŋ gêc amac ŋalêlôm naŋ su. ");
INSERT INTO jae_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“Lasim, tênam latu me nêm latômo to ŋac me nêm awê, taŋ têmtac gêwiŋ eŋ naŋ, me nêm ŋac teŋ, taŋ gôlic eŋ amboac taômnêm ŋatê ŋagêdô naŋ embe êlêtôm aôm kelecgeŋ ma êsôm gebe ‘Tana ma tanam sakiŋ anôtôi jaba maŋ’ ");
INSERT INTO jae_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","lau taŋ sêŋgôŋ sêgi aôm auc sêŋgôŋ dambê me jaêc me sêmoa nom ŋamakeŋ tonec me ônê naŋ, nêŋ anôtôi ŋagêdô, taŋ aôm me nêm tamami sêjam kauc naŋ, ");
INSERT INTO jae_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","go ôkêŋ êwiŋ eŋ me ôkêŋ taŋam eŋ me taêm walô eŋ me ônam eŋ kêsi me ônsa eŋ auc atom, ");
INSERT INTO jae_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","mago ônac eŋ êndumaŋ. Aôm lêmam êpi eŋ êtu ŋamata gebe eŋ êmac êndu ma lau samob sênac eŋ sêwiŋ. ");
INSERT INTO jae_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Ôtuc eŋ êndu ŋa poc gebe eŋ kêsaê gebe êkac aôm su aŋga Apômtau, nêm Anôtô, taŋ kêkôc aôm kôsa aŋga gamêŋ Aiguptuŋa, aŋga andu kapoacwalôŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Go lau Israel samob sêŋô biŋ tonaŋ e têtêc tauŋ gebe sêŋgôm gêŋ teŋ amboac tonaŋ aŋga amac ŋalêlôm êtiam atomanô.” ");
INSERT INTO jae_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“Go Mose kêsôm gebe “Lau taŋ aôm ôkôc nêŋ gamêŋ su naŋ, samob sêkêŋ taŋeŋ gêdêŋ lau-seoc-biŋ-lasêwaga to mectomaŋ, mago Apômtau, nêm Anôtô, kêkêŋ gêwiŋ gebe ôŋgôm gêŋ amboac tonaŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Apômtau, nêm Anôtô, oc êŋu nêm propete teŋ sa aŋga nêm lasitêwai nêŋ êtôm aê. Akêŋ taŋem eŋmaŋ. ");
INSERT INTO jae_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Biŋ tonaŋ aôm taôm koteŋ aŋga Apômtau, aômnêm Anôtô nê gêdêŋ noc akac saŋa aŋga lôc Horeb. Aôm kôsôm gebe ‘Aê gabe jaŋô Apômtau, aêŋoc Anôtô, nê awa êtiam atom to jalic ja kapôêŋ tonec êtiam atom, gebe jamac êndu atom.’ ");
INSERT INTO jae_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Ma Apômtau kêsôm gêdêŋ aê gebe ‘Biŋ samob, taŋ êsêac sêsôm naŋ, sêsôm jagêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Aê oc jaŋu êsêacnêŋ propete teŋ sa aŋga nêŋ lasitêwai nêŋ êtôm aôm, ma jakêŋ ŋoc biŋ êsêp eŋ awasuŋ ma êsôm biŋ samob, taŋ jajatu eŋ naŋ, êndêŋ êsêac sêŋô. ");
INSERT INTO jae_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Ma lau samob, taŋ sêkêŋ taŋeŋ aêŋoc biŋ, taŋ eŋ oc êsôm ênam aê aoc naŋ atom, aê tauc oc jajatu êsêac gebe sêwa nêŋ biŋ sa. ");
INSERT INTO jae_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Mago propete teŋ embe êsôm biŋ, taŋ kajatu naŋ atom ênam aê aoc, me êsôm biŋ ênam anôtôi jaba aweŋ naŋ, propete tonaŋ eŋ êmac êndu ênaŋa.’ ");
INSERT INTO jae_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Aôm embe taêm ênam ênêc nêm ŋalêlômgeŋ gebe ‘Aêac tajala biŋ, taŋ Apômtau kêsôm atom naŋ, êpi asageŋ’, ");
INSERT INTO jae_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","go aŋô acgom, propete teŋ embe êsôm biŋ ênam Apômtau awa, mago biŋ tau êtu anô me êtu tôŋ atom, go ajala gebe biŋ tonaŋ Apômtau kêsôm atom. Propete amboac tonaŋ ketoc tau sa, tec ôtêc eŋ atom.” ");
INSERT INTO jae_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Go Mose kêsôm gebe “Ŋac teŋ embe êŋgôm sec teŋ ma êtap ŋakeso to geo teŋ sa, go ŋac-gêwa-biŋ-sawaga tageŋgeŋ êtôm atom gebe eŋ taugeŋ êwa biŋ tonaŋ sa. Ŋac luagêc me têlêac, taŋ sêŋô to sêlic gêŋ tau sêwiŋ naŋ, sêpuc biŋ tau tôŋ amboac tonaŋgeŋ acgom. ");
INSERT INTO jae_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Embe ŋac-êwa-biŋ-sawaga alôb-alôb teŋ êndi sa ma êŋga biŋ teŋ êpi ŋac teŋ gebe kêgêli biŋsu, ");
INSERT INTO jae_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","go ŋac tobiŋ lulugeŋ mêŋsêkô Apômtau laŋônêm ma dabuŋwaga agêc mêtôcwaga, taŋ sênam kôm êndêŋ bêc tonaŋ naŋ, sêwiŋ êsêagêc. ");
INSERT INTO jae_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Lau mêtôcwaga sêkip biŋ sa ŋapepgeŋ ma ŋac-gêwa-biŋ-sawaga embe ŋac dansaŋ teŋ ma êŋga biŋ eso, ");
INSERT INTO jae_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","go amac aŋgôm gêŋ, taŋ eŋ taê gêjam gebe êŋgôm êndêŋ nê lasitêwa naŋ, êpi eŋ taugeŋ ma onseŋ gêŋ sec, taŋ gêc amac ŋalêlôm naŋ, su amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Ma lau ŋagêdô sêŋô ma têtêc tauŋ gebe sêŋgôm gêŋ sec teŋ amboac tonaŋ ênêc amac ŋalêlôm êtiam atom. ");
INSERT INTO jae_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Têmtac êtu lêsi atom. Ŋamalac êjô ŋamalac. Mataanô êjô mataanô. Ma luluŋ êjô luluŋ to lêma êjô lêma ma akaiŋ êjô akaiŋ.” ");
INSERT INTO jae_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“Ŋac teŋ embe ênam awê sa ma êmoa êwiŋ eŋ e awê tau ênac ŋac mataanô ŋajam atom, gebe kêtap awênê keso kaiŋ teŋ sa, naŋ eto papia sêwi tauŋ siŋŋa teŋ ma êkêŋ êsêp awê tau lêma to êsakiŋ eŋ êwi ênê andu siŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Ma awê tau embe êwi ŋacnê andu siŋ ma ênam ŋac wakuc teŋ, ");
INSERT INTO jae_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ma ŋac wakuc tau embe endec eŋ to eto papia sêwi tauŋ siŋŋa ma êkêŋ êsêp awê tau lêma to êsakiŋ eŋ êwi ênê andu siŋ amboac tonaŋ, me ŋac wakuc, taŋ gêjam eŋ kêtu nê awê naŋ, embe êmac êndu, ");
INSERT INTO jae_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","go awênê akweŋ ŋamataŋa, taŋ kêsakiŋ eŋ gêc gêja naŋ, ênam awê tau êtu nê awê êtiam atom, gebe awê kêtu sec su. Apômtau gêlic gêŋ amboac tonaŋ kêtôm gêŋ alôb-alôb. Aŋgôm gamêŋ, taŋ Apômtau, amacnêm Anôtô, kêkêŋ gêdêŋ amac kêtu nêm nomlênsêm naŋ, êtu sec atom. ");
INSERT INTO jae_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“Ŋac, taŋ gêjam awê wakucgeŋ naŋ, ênac siŋ êwiŋ siŋwaga to êwê kaiŋ kôm gôlôacŋa teŋ atom. Eŋ êmoa ŋaôma jala samuc teŋ, gebe êsêagêc nê awê, taŋ gêjam naŋ, têtu samuc tauŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“Aôm embe ôkêŋ gêŋ teŋ êndêŋ ŋac teŋ êtu ênê tôp, naŋ ôkôc ênê poc êlai polomŋa êtu kamaclauŋ atom. Embe ôŋgôm amboac tonaŋ, oc ôkôc ênê gêŋ, taŋ êpuc eŋ tôŋ gebe êmoa mata jali naŋ su. ");
INSERT INTO jae_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“Ŋac teŋ embe êjaŋgo ŋac Israelŋa teŋ su ma êkêŋ eŋ êtu gêŋôma me êkêŋ lau sênam ôli eŋ, naŋ eŋ êmac êndu. Ôŋgôm amboac tonaŋ gebe onseŋ lêŋ sec tonaŋ su aŋga nêm ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“Embe kamocbôm êŋgôm aôm, naŋ ojop taôm gebe ôndaŋguc biŋ samob, taŋ dabuŋwaga sêsôm êndêŋ aôm naŋ. Ôŋgôm êsêacnêŋ biŋ ŋanô êsa tomalageŋ êtôm ŋagôliŋ, taŋ aê kakêŋ gêdêŋ êsêac naŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Taêm ênam gêŋ, taŋ Apômtau, nêm Anôtô, gêgôm gêdêŋ Miriam gêdêŋ taŋ amac asa aŋga Aiguptu amêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“Aômnêm ŋac wacbaŋ aômŋa embe êpô lêna gêŋ teŋ ma eteŋ aôm, gebe ônam eŋ sa e tau êtap gêŋ sa gebe êkêŋ êjô gêŋ, taŋ kêkôc aŋga aômnêm naŋ, go ôpi ênê andu ôna ma ôkôc tôp ŋakamaclauŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Ôkô oloŋgeŋ, ma ŋac, taŋ keteŋ gêŋ aŋga aômnêm naŋ, êkôc kamaclauŋ êndêŋ aôm êwac. ");
INSERT INTO jae_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","Eŋ embe ŋac ŋalêlôm sawa ma êkêŋ nê ŋakwê êtu kamaclauŋ, go ônêc bêc toŋakwê tau atom. ");
INSERT INTO jae_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Êndêŋ taŋ oc naêsêp naŋ, ôkêŋ ênê kamaclauŋ êmu êndêŋ eŋ êna, gebe ênêc bêc tonê ŋakwêgeŋ ma ênam mec aôm. Embe ôŋgôm amboac tonaŋ, go Apômtau, aômnêm Anôtô, êlic aôm amboac ŋac gêdêŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“Ôkôniŋ sakiŋwaga ŋalêlôm sawa, taŋ kêpô lêna gêŋ ma gêjam kôm kêtu ŋaôliŋa naŋ, atom. Sakiŋwaga tau embe nêm lasitêwa teŋ, me ŋac jaba teŋ, taŋ gêŋgôŋ nêm malac naŋ, ôkôniŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Oc êsêp atomgeŋ, ma ôkêŋ ŋaôli êndêŋ eŋ êjô ênê kôm bêc tonaŋŋa su. Gebe eŋ ŋac ŋalêlôm sawa, tec kêkêŋ mata ŋaôli tau. Embe ôŋgôm atom, oc eŋ awa ênac Apômtau êtu aômŋa e aôm ôwê kaiŋ sec. ");
INSERT INTO jae_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“Lau sênac tameŋi êndu sêjô latuŋi nêŋ geo atom ma sênac latuŋi êndu sêjô tameŋinêŋ geo atom. Lau sênac lau êndu êtu tauŋ nêŋ secŋageŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“Ônam ŋagôliŋ mêtôcŋa ôkwi êndêŋ taŋ ômêtôc ŋac jaba to mosêbu naŋ atom ma ôkôc awêtucnê ŋakwê êtu kamaclauŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Taêm ênam acgom, aŋga gamêŋ Aiguptuŋa aôm kêtu gêŋôma e Apômtau, aômnêm Anôtô, gêjam aôm kêsi aŋga tônê. Kêtu tonaŋŋa aê kajatu aôm, gebe ôŋgôm biŋ tonec ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“Aôm embe ônac kôm ŋanô sa ma ôliŋ polom lagic teŋ siŋ êkô kôm, go ômu ôna gebe ôkôc gêŋ tau atom. Gêŋ tau êtu lau jaba to mosêbu ma awêtuc nêŋ gêŋ, gebe Apômtau, aômnêm Anôtô, ênam mec aôm to lêmam ŋakôm samob. ");
INSERT INTO jae_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Ma embe okoloŋ katêkwi ŋalêwê su, go okoloŋ ŋakôniŋŋa êtiam atom. Kaŋanô ŋagêdô tonaŋ êtu lau jaba to mosêbu ma awêtuc nêŋ gêŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Ma embe ojoŋ wain ŋalêwê aŋga kôm wainŋa sa, go amboac tonaŋgeŋ, ojoŋ ŋakôniŋŋa êtiam atom. Ŋanô ŋagêdô tonaŋ êtu lau jaba to mosêbu ma awêtuc nêŋ gêŋ. ");
INSERT INTO jae_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Taêm ênam acgom, aŋga Aiguptu aôm kôtu gêŋôma, kêtu tonaŋŋa aê kajatu aôm, gebe ôŋgôm biŋ tonec ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“Embe ŋac luagêc nêŋ biŋ teŋ êlênsôŋ, go sêna sêmêtôc biŋ ŋamala, ma mêtôcwaga sêmêtôc êsêagêc. Êsêac sêwi ŋac tobiŋ masi siŋ ma sêkêŋ ŋagêjô êndêŋ ŋac tobiŋ. ");
INSERT INTO jae_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Mêtôcwaga embe êlic êtôm gebe ŋac tobiŋ êtap ŋandaŋ sa, go êsôm êndêŋ ŋac tau, gebe êtap labôc ênêc eŋ laŋônêmŋa ma si eŋ ŋa sêm êtôm ênê keso. ");
INSERT INTO jae_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Mêtôcwaga êlôc sa gebe si eŋ êtu dim 40, si eŋ êlêlêc dim 40 su atom. Embe si eŋ êlêlêc dim 40 su, go sêŋgôm aôm lasim tonaŋ maja êsa. ");
INSERT INTO jae_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“Akic bulimakao kapoac, taŋ kêka polom ŋanô gêmoa naŋ, awasuŋ auc atom. ");
INSERT INTO jae_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“Lasitêwai ŋagêdô embe sêŋgôŋ andu tageŋ ma teŋ embe latu masi ma êmac êndu, go ŋac gêmac nê awêtuc ênam ŋac jaba gamêŋ teŋŋa atom. Nê akweŋ lasi êmoa êwiŋ eŋ e ênam eŋ êtu nê awê êjô têwa su. ");
INSERT INTO jae_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Awê tau embe êkôc latu ŋacsêga, go ŋapalê tau êwê kaiŋ awênê akweŋ ŋamataŋa, taŋ gêmac êndu naŋ, nê ŋaê, gebe ênê ŋaê êmbacnê aŋga lau Israel nêŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Ma lasi embe endec ma ênam têwanê awêtuc atom, go têwanê awêtuc êna malacgêdô sêmêtôc biŋŋa ma êsôm êndêŋ laumata gebe ‘Ŋoc akweŋ lasi gedec, gebe têwanê ŋaê ênêc teŋgeŋ aŋga lau Israel nêŋ. Eŋ gedec gebe ênam aê êjô têwa su.’ ");
INSERT INTO jae_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Go laumata malacŋa sêmôêc ŋac tau to sêlêŋ biŋ eŋ, ma eŋ embe êkô ŋajaŋa ma êsôm gebe ‘Aê gadec gebe janam awê tonec,’ ");
INSERT INTO jae_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","go têwanê awêtuc êndêŋ eŋ êna aŋga laumata laŋôŋnêmŋa ma ênu atapa su aŋga ŋac tau akaiŋ to êkasôp êpi eŋ laŋôanô ma êsôm gebe ‘Biŋ amboac tonaŋ daŋgôm êndêŋ lau samob, taŋ sendec gebe sêkwê teweŋinê andu sa naŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Lau Israel sê ŋac amboac tonaŋ nê gôlôacnêŋ ŋaê gebe ‘Ŋac, taŋ sênu atapa su naŋ, nê gôlôac.’ ");
INSERT INTO jae_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“Embe ŋac luagêc sênac tauŋ sêmoa ma ŋac teŋ nê awê ênsaê gebe ênam nê akweŋ kêsi aŋga nê soŋo-soŋo nê ma êkôc ŋac tau utianô tôŋ, ");
INSERT INTO jae_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","go taêm walô eŋ atom, ôndim ênê lêma êŋgic beb tageŋ. ");
INSERT INTO jae_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“Kidêbu kaiŋ luagêc, ŋawapac to ŋagaô, ênêc nêm atali ŋalêlôm atom. ");
INSERT INTO jae_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Ôkêŋ dôŋ tanam dôŋ gêŋŋa kaiŋ luagêc sauŋ to kapôêŋ ênêc nêm andu atom. ");
INSERT INTO jae_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Ôkôc kidêbu ŋanô to jagêdêŋ ma dôŋ ŋanô to jagêdêŋ gebe aôm ômoa matam jali baliŋgeŋ aŋga gamêŋ, taŋ Apômtau, nêm Anôtô, kêkêŋ gêdêŋ aôm naŋ. ");
INSERT INTO jae_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Apômtau têtac gedec lau samob, taŋ sêgôm gêŋ danseŋ ma sêsau lau naŋ. ");
INSERT INTO jae_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“Taêm ênam gêŋ, taŋ lau Amalek sêgôm gêdêŋ aôm gêdêŋ taŋ kôsa aŋga Aiguptu gômôêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","Êsêac têtêc Anôtô atom ma sêjac siŋ gêdêŋ aôm gêdêŋ taŋ aôm têkwam gêbac ma ôlim walô masi naŋ, ma sêjac nêm lau samob, taŋ sênu tauŋ su-su sêmoa ŋamu naŋ êndu. ");
INSERT INTO jae_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","Amboac tonaŋ êndêŋ taŋ Apômtau, nêm Anôtô, êlêwaŋ aôm aŋga nêm ŋacjo, taŋ sêŋgôŋ sêŋgi aôm naŋ ma êkêŋ aôm ôŋgôŋ nom êtu têlê, taŋ eŋ gêjac mata gêdêŋ aôm gebe êtu nêm lênsêm naŋ, go onseŋ Amalek su e ŋamôkê êmakop gebe ŋamalac teŋ taê ênam êsêac êtiam atomanô. Ôliŋ biŋ tonaŋ siŋ atomanô. ŋawapacŋa. ");
INSERT INTO jae_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“Êndêŋ taŋ ô lasê gamêŋ tau, taŋ Apômtau, aômnêm Anôtô, gebe êkêŋ êndêŋ aôm êtu nêm nomlênsêm naŋ, ma êndêŋ taŋ gamêŋ tau êtu aômnêm gamêŋ su e ôŋgôŋ ôtu wakac naŋ, ");
INSERT INTO jae_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ôkôc kôm ŋanô samob ŋamêc ŋagêdô, taŋ ojoŋ sa aŋga nêm gamêŋ, taŋ Apômtau, aômnêm Anôtô, êkêŋ êndêŋ aôm naŋ, ma ôkêŋ êsêp gadob teŋ. Go ôna gamêŋ, taŋ Apômtau, aômnêm Anôtô, oc êjaliŋ sa, gebe êtu ênê ŋaê ŋamala naŋ, ");
INSERT INTO jae_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ma ôndêŋ dabuŋwaga, taŋ sakiŋ bêc tonaŋŋa ênac eŋ ŋawae naŋ, ôna ma ôsôm êndêŋ eŋ gebe ‘Aê mêŋgaô lasê gamêŋ, taŋ Apômtau kêtôc lêma gêdêŋ aêac tameŋi gebe êkêŋ êndêŋ aêac naŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Go dabuŋwaga êkôc gadob su aŋga lêmam ma etoc ênêc Apômtau, aômnêm Anôtô, nê altar ŋanêmŋa. ");
INSERT INTO jae_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","“Go ôc awam sa ma ôsôm ôkô Apômtau, aômnêm Anôtô, laŋônêmŋa gebe ‘Aê tamoc eŋ ŋac Aramŋa, taŋ kêsêlêŋ gêjac laoc gamêŋgeŋ. Eŋ kêsêp Aiguptu jagêmoa gamêŋ tau amboac ŋac jaba teŋ, nê lau luagêcgeŋ. Ma aŋga tônê eŋ kêtu lau-m kapôêŋ to ŋajaŋa ma nê lau têtu taêsam. ");
INSERT INTO jae_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Mago lau Aiguptu sêgôm aêac kwalec to sêkôniŋ aêac tôŋ ma sejoŋ aêac ŋa koleŋ ŋawapac ŋanô. ");
INSERT INTO jae_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Go tamôêc gêdêŋ Apômtau, aêac tameŋinêŋ Anôtô, ma Apômtau kêkêŋ taŋa aêac aweŋ. Eŋ gêlic aêac tamoa jageo to tajam koleŋ ŋawapac ma sêkôniŋ aêac. ");
INSERT INTO jae_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Go Apômtau kêmêtôc lêma ŋajaŋa to gêwê aêac dawi Aiguptu siŋ. Eŋ gêgôm gêŋ kaiŋ teŋ kêtakê lau ma gêgôm gêŋtalô to gêŋsêga. ");
INSERT INTO jae_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Ma eŋ gêwê aêac taô lasê gamêŋ tonec ma kêkêŋ gamêŋ tau, taŋ su to lêp keseleŋ naŋ, gêdêŋ aêac. ");
INSERT INTO jae_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Ma galoc, o Apômtau, aê kakôc nom, taŋ aôm kôkêŋ gêdêŋ aê naŋ, ŋakôm ŋanô ŋamêc gamêŋ.’ Go otoc gêŋ tau ênêc Apômtau, aômnêm Anôtô, laŋônêmŋa ma oteŋ mec êndêŋ Apômtau, aômnêm Anôtô. ");
INSERT INTO jae_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Ma aôm to Lewinê gôlôac ma lau jaba, taŋ sêmoa sêwiŋ aôm naŋ, atu samuc gêŋ ŋajam samob, taŋ Apômtau, amacnêm Anôtô, kêkêŋ gêdêŋ amac to nêm gôlôac samob naŋ. ");
INSERT INTO jae_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“Êtôm jala têlêac-têlêacgeŋ aôm ôkôc gêŋ 10-10 ŋatageŋ-tageŋ sa ma ôkêŋ êtu da. Embe ôkêŋ da tonaŋ su êndêŋ Lewinê gôlôac to lau jaba ma mosêbu to awêtuc, taŋ sêŋgôŋ nêm malac naŋ, sêniŋ e êôc êsêac tôŋ, ");
INSERT INTO jae_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","go ôsôm ôkô Apômtau, aômnêm Anôtô laŋônêmŋa gebe ‘Aê kakôc gêŋ dabuŋ samob su aŋga ŋoc andu ma kakêŋ gêdêŋ Lewinê gôlôac to lau jaba ma mosêbu to awêtuc kêtôm nêm biŋsu samob, taŋ kôjatu aê naŋ. Aê kagêli nêm biŋsu teŋ atom to kaliŋ ŋateŋ siŋ atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Gêdêŋ taŋ gaôc wapac kêtu ŋacmatêŋa naŋ, gaeŋ gêŋ tau ŋateŋ atom. Gêdêŋ taŋ gamoa selec atom naŋ, kakôc gêŋ teŋ su atom. Ma kakêŋ gêŋ tau ŋateŋ kêtu da gêdêŋ lau ŋanô katuŋ atom amboac tonaŋgeŋ. Aê taŋoc wamu Apômtau, aêŋoc Anôtô, awa ma gagôm gêŋ samob, kêtôm taŋ aôm kôjatu aê naŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Ôtuc kêniŋ aŋga nêm andu dabuŋ undambêŋa ma matam ê aêac ma ônam mec nêm lau Israel to nom, taŋ kôkêŋ gêdêŋ aêac naŋ, kêtôm kôtôc lêmam gêdêŋ aêac tamemai. Kôkêŋ gamêŋ, taŋ su to lêp keseleŋ naŋ.’ ");
INSERT INTO jae_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“Ocsalô tonec Apômtau, aômnêm Anôtô, kêjatu aôm gebe ôŋgôm biŋsu to ŋagôliŋ tonec ŋanô êsa, tec ojop taôm gebe ôŋgôm biŋ tau ŋanô êsa tonêm ŋalêlôm samuc ma nêm katôm samuc. ");
INSERT INTO jae_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Ocsalô tonec aôm kôsôm kêtu tôŋ, gebe Apômtau kêtu aômnêm Anôtô ma aôm gobe ôsa ênê lêŋ to ôŋgôm ênê biŋsu to ŋagôliŋ ma jatu ŋanô êsa ma taŋam wamu eŋ awa. ");
INSERT INTO jae_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Ma ocsalô tonec Apômtau kêsôm kêtu tôŋ, gebe amac atu lau, ênê laugac kêtôm gêjac mata gêdêŋ amac, ma aŋgôm ênê biŋsu samob ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Eŋ oc etoc amac sa alêlêc lau tomôkê-tomôkê samob, taŋ eŋ kêkêŋ naŋ, su e sêlambiŋ amac to sêsôm amac waem lasê ma tetoc amac sa. Ma amac atu Apômtau, amacnêm Anôtô, nê lau dabuŋ êtôm eŋ kêsôm su.” ");
INSERT INTO jae_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Go Mose kêsôm kêtiam gebe “Êndêŋ taŋ biŋ Anôtô ênam mec to êpuc boa amacŋa, taŋ kakêŋ gêc amac laŋômnêmŋa naŋ, ŋanô êsa êpi amac, ma amac embe taêm ênam biŋ tau aŋga gamêŋ, taŋ Apômtau, aômnêm Anôtô, êjanda amac naŋ, amoa lau tomôkê-tomôkê ŋalêlôm, ");
INSERT INTO jae_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ma amac to nêm gôlôac amu andêŋ Apômtau ana to taŋem wamu eŋ awa ma aŋgôm biŋ samob, taŋ ocsalô tonec kajatu amac naŋ, ŋanô êsa tonêm ŋalêlôm samuc ma nêm katôm samuc, ");
INSERT INTO jae_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","go Apômtau, amacnêm Anôtô, ênam nêm kapoacwalô ôkwi to taê walô amac. Eŋ êsa amac êliŋ-êliŋ amoa lau tomôkê-tomôkê ŋalêlôm ma oc ênac amac sa aŋga lau tomôkê-tomôkê ŋalêlôm e api tageŋ êtiam. ");
INSERT INTO jae_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Apômtau, amacnêm Anôtô, embe êsa amac êliŋ-êliŋ e naêndêŋ umboŋ ŋamadiŋ, oc ênac amac sa ma êkôc amac aŋga ônê êtiam. ");
INSERT INTO jae_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Go Apômtau, amacnêm Anôtô, êwê amac e aô lasê gamêŋ, taŋ tamemi sêwê kaiŋ naŋ, gebe êtu amacnêm gamêŋ êtiam. Ma eŋ oc êmoasiŋ amac êlêlêc su to êŋgôm amac atu taêsam alêlêc tamemi su. ");
INSERT INTO jae_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Ma Apômtau, aômnêm Anôtô, oc ênam nêm ŋalêlôm to nêm wakucnêŋ ŋalêlôm ôkwi êtu selec e têmtac êwiŋ Apômtau, aômnêm Anôtô, tonêm ŋalêlôm samuc ma nêm katôm samuc, gebe ômoa matam jali. ");
INSERT INTO jae_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Ma Apômtau, aômnêm Anôtô, oc êsôm biŋ êpuc boaŋa tonaŋ êpi nêm ŋacjo to nêm soŋo-soŋo, taŋ sêjanda aôm naŋ. ");
INSERT INTO jae_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Ma aôm oc taŋam wamu Apômtau awa êtiam ma ôŋgôm ênê biŋsu samob, taŋ ocsalô kajatu aôm naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","Aôm embe taŋam wamu Apômtau, aômnêm Anôtô, awa to ôŋgôm ênê biŋsu to ŋagôliŋ, taŋ teto gêc biŋsu ŋabuku tonec naŋ, ŋanô êsa, ma embe ônam taôm ôkwi êndêŋ Apômtau, aômnêm Anôtô, tonêm ŋalêlôm samuc ma nêm katôm samuc, go Apômtau, aômnêm Anôtô, êmoasiŋ lêmam ŋakôm êlêlêc ŋêŋgeŋ su. Eŋ êmoasiŋ nêm wakuc to êmoasiŋ nêm bulimakao e têtu taêsam. Ma nêm nom ênam ŋanô êlêlêc su. Gebe Apômtau êtu samuc aôm êtiam, tec ênsêwa moasiŋ êpi aôm êtôm kêtu samuc tamami. ");
INSERT INTO jae_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“Gebe biŋsu, taŋ ocsalô tonec kajatu aôm naŋ, ŋawapac ŋanô kêlêlêc aôm su atom me gêc jaêc aôm atom. ");
INSERT INTO jae_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Gêc undambê atom, gebe aôm ôsôm gebe’ Asa êpi undambê êna êjô aêac su naêkôc biŋ tau êndêŋ aêac êmêŋ, gebe aŋô to aŋgôm ŋanô êsa.’ ");
INSERT INTO jae_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Me gêc gwêc ŋamakeŋ ônêŋa atom, gebe aôm ôsôm gebe ‘Asa elom gwêc êjô aêac su naêkôc biŋ tau êndêŋ aêac êmêŋ, gebe aŋô to aŋgôm ŋanô êsa.’ ");
INSERT INTO jae_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Masianô, biŋ tau gêc aôm ŋagala, gêc aôm awamsuŋ ma nêm ŋalêlôm, tec kôtôm gebe ôŋgôm ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Ôlic acgom, ocsalô tonec aê katoc ôŋgôŋ matam jali to moasiŋ ma ômac êndu to gêŋ sec gêc aôm laŋômnêmŋa. ");
INSERT INTO jae_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Aôm embe têmtac êwiŋ Apômtau, aômnêm Anôtô, to ôsa ênê lêŋ ma ôŋgôm ênê biŋsu to ŋagôliŋ ma jatu ŋanô êsa, oc êwa aôm sa gebe taŋam wamu Apômtau, aômnêm Anôtô, nê biŋsu, taŋ ocsalô aê kajatu aôm naŋ. Embe amboac tonaŋ, go ômoa matam jali to ôtu taêsam ma Apômtau, aômnêm Anôtô, oc ênam mec aôm aŋga gamêŋ, taŋ ôsa ôna, gebe ôwê kaiŋ êtu aômnêm gamêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Mago aômnêm ŋalêlôm embe eo gala ma embe ôkêŋ taŋam eŋ atom, ôwi eŋ siŋ ma oteŋ mec to ônam sakiŋ êndêŋ anôtôi jaba, ");
INSERT INTO jae_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","oc ocsalô tonec aê jasôm êndêŋ aôm, gebe oc ônaŋa. Aôm oc ômoa matam jali to ôŋgôŋ gamêŋ, taŋ olom Jordan ma ôsa ôna, gebe êtu aômnêm gamêŋ naŋ, ŋêŋgeŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Ocsalô tonec aê jakalem undambê to nom gebe sêlic to sêŋô biŋ sêwiŋ, gebe sêwa aê sa. Aê katoc ômoa matam jali to ômac êndu ma biŋ janam mec to japuc boa aômŋa gêc aôm laŋômnêmŋa. Amboac tonaŋ ôjaliŋ ômoa matam jaliŋa sa, gebe aôm to nêm wakuc amoa matem jali, ");
INSERT INTO jae_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ma têmtac êwiŋ Apômtau, aômnêm Anôtô, to taŋam wamu eŋ awa ma ôsap eŋ tôŋ. Biŋ tonaŋ kêtu ômoa matam jali to ôŋgôŋ ŋêŋgeŋ aŋga gamêŋ, taŋ Apômtau kêtôc lêma gêdêŋ tamami Abraham agêc Isak ma Jakob, gebe êkêŋ êndêŋ êsêac naŋ, ŋam.” ");
INSERT INTO jae_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Mose kêsôm biŋ tonaŋ gêdêŋ lau Israel samob su, ");
INSERT INTO jae_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","go kêsôm biŋ tonec gêwiŋ gebe “Ocsalô tonec aêŋoc jala kêtôm 120. Aêŋoc lêŋ galoc gêbacnê ma katôm gebe jasô-jasa êtiam atom. Apômtau kêsôm gêdêŋ aê gebe ‘Aôm oc olom bu Jordan ôna atom.’ ");
INSERT INTO jae_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Apômtau, aômnêm Anôtô, tau oc elom êmuŋ aôm. Eŋ êsêlêŋ êmuŋ aôm ma enseŋ lau tomôkê-tomôkê tonec su, gebe ôjaŋgo êsêacnêŋ gamêŋ su. Ma Josua oc elom êtu nêm ŋamata kêtôm Apômtau kêsôm su. ");
INSERT INTO jae_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Ma Apômtau êŋgôm êsêac êtôm gêgôm lau Amor nêŋ kiŋ Sihon agêc Og to nêŋ gamêŋ gêdêŋ taŋ geseŋ êsêac su naŋ. ");
INSERT INTO jae_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Apômtau êkêŋ êsêac sêsêp amac lemem ma amac aŋgôm gêŋ êtôm biŋsu samob, taŋ kajatu amac naŋ, êndêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Akô ŋajaŋa totêmtac êpa sugeŋ. Atêc taôm atom ma matem golec êtu êsêacŋa atom, gebe Apômtau, amacnêm Anôtô, oc êwiŋ amac. Eŋ êwi amac siŋ atom ma êtaiŋ tau su aŋga amacnêm atom.” ");
INSERT INTO jae_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Go Mose kêkalem Josua mêŋkêsôm gêdêŋ eŋ kêkô lau Israel samob laŋôŋnêmŋa gebe “Ôkô ŋajaŋa totêmtac êpa sugeŋ, gebe aôm ôwiŋ lau tonec asa gamêŋ, taŋ Apômtau kêtôc lêma gêdêŋ êsêac tameŋi, gebe êkêŋ êndêŋ êsêac naŋ ana. Ma aôm ôkêŋ êsêac têtu gamêŋ ŋatau. ");
INSERT INTO jae_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Apômtau tau êsêlêŋ êmuŋ aôm. En oc êmoa êwiŋ aôm. Eŋ oc êwi aôm siŋ atom ma êtaiŋ tau su aŋga aôm atom. Ôtêc taôm atom ma ôtakê atom.” ");
INSERT INTO jae_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Ma Mose keto biŋsu tonec sa ma kêkêŋ biŋ tau gêdêŋ Lewi latui, taŋ têtu dabuŋwaga ma sêbalaŋ Apômtaunê katapa poacŋa naŋ, to gêdêŋ lau Israel nêŋ laumata samob. ");
INSERT INTO jae_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","11","Ma Mose kêjatu êsêac gebe “Êtôm jala êtu 7ŋa samob, êndêŋ jala, taŋ amac aŋgamboac gêŋôma su naŋ, asam biŋsu tonec lasê êndêŋ lau Israel samob sêŋô. Asam lasê êndêŋ Om Lômbecŋa, êndêŋ taŋ lau Israel samob sêkac sa sêkô Apômtau laŋônêmŋa aŋga gamêŋ, taŋ eŋ oc êjaliŋ sa naŋ. ");
INSERT INTO jae_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Ôkac lau samob sa, lauo to ŋacwaga ma gôlôac sauŋ to lau jaba, taŋ sêŋgôŋ nêm malac naŋ, gebe sêŋô biŋ tau êtu tôŋ êsêac e têtêc Apômtau, amacnêm Anôtô, ma sejop tauŋ gebe sêŋgôm biŋsu tonec ŋabiŋ samob ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Êsêacnêŋ gôlôac sauŋ, taŋ oc sênam kauc biŋsu naŋ, sêŋô amboac tonaŋ ma êndôŋ êsêac gebe têtêc Apômtau, amacnêm Anôtô, êtu tôŋ êtôm têm samob, taŋ aŋgôŋ gamêŋ, taŋ oc alom Jordan ma naasa, gebe êtu nêm gamêŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, nêm bêc ômac ênduŋa kêdabiŋgac. Ômôêc Josua ma agêc naakô bec akac saŋa ŋalêlôm, gebe jakêŋ kôm êndêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Tec Mose agêc Josua jasêkô bec sêkac saŋa ŋalêlôm ma Apômtau, geoc tau lasê aŋga bec gêmoa tao ŋalêlôm. Tao tau kêkô bec tau ŋasacgêdô. ");
INSERT INTO jae_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Ma Apômtau kêsôm gêdêŋ Mose gebe “Ôlic acgom, noc kêdabiŋ gebe ônêc ôwiŋ tamami. Ma lau tonec oc sêndi to sêŋgôm mockaiŋ êndêŋ anôtôi jaba aŋga gamêŋ, taŋ oc sêsa sêna naŋ. Êsêac sêwi aê siŋ ma sênac ŋoc poac, taŋ kamoatiŋ gêdêŋ êsêac naŋ, popoc. ");
INSERT INTO jae_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Êndêŋ bêc tônê aê têtac ŋandaŋ êsa êndêŋ êsêac. Aê oc jawi êsêac siŋ to jansaŋ laŋôcanô auc êndêŋ êsêac e sênaŋa. Sec to gêŋwapac tokaiŋ-tokaiŋ êtap êsêac sa ma êndêŋ bêc tônê êsêac sêsôm gebe ‘Apômtau, aêacnêŋ Anôtô, gêmoa gêwiŋ aêac atom, tec gêŋwapac samob tonec kêpi aêac.’ ");
INSERT INTO jae_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Biŋŋanôgeŋ, êndêŋ bêc tônê aê jansaŋ laŋôcanô auc êtu sec samob, taŋ êsêac sêŋgôm naŋŋa, gebe êsêac oc sênam tauŋ ôkwi dêndêŋ anôtôi jaba sêna. ");
INSERT INTO jae_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Amboac tonaŋ galoc oto wê tonec sa ma ôndôŋ wê tau êndêŋ lau Israel. Ôkêŋ êsêp êsêac aweŋsuŋ ma wê tau êwa aê sa êndêŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Aê oc jakêŋ êsêac sêô lasê gamêŋ, taŋ katôc lemoc gebe jakêŋ êndêŋ êsêac tameŋi, gamêŋ, taŋ su to lêp keseleŋ naŋ. Êsêac oc sêniŋ gêŋ e êôc êsêac tôŋ ma têtôp e nêŋ ŋadambê kapôêŋ-kapôêŋ acgom, go sênam tauŋ ôkwi dêndêŋ anôtôi jaba sêna ma sênam sakiŋ êsêac. Ma têtiŋ aê su to sênac aêŋoc poac popoc. ");
INSERT INTO jae_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Êndêŋ taŋ sec to gêŋwapac êpi êsêac naŋ, wê tonec ênam malô êsêac ma êwa aê sa. Wê tau ênêc nêŋ wakuc aweŋgeŋ ma sêliŋ siŋ atom. Biŋŋanô, aê kakêŋ êsêac jasêô lasê gamêŋ, taŋ katôc lemoc, gebe jakêŋ êndêŋ êsêac naŋ atomgeŋ, ma kajala biŋ, taŋ êsêac taêŋ gêjam gêc nêŋ ŋalêlôm naŋ.” ");
INSERT INTO jae_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Amboac tonaŋ gêdêŋ bêc tonaŋgeŋ Mose keto wê tau sa ma kêdôŋ gêdêŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Ma Apômtau kêsakiŋ Nun latu Josua ma kêsôm gebe “Ôkô ŋajaŋa to têmtac êpa sugeŋ, gebe aôm oc ôwê Israel latui nasêô lasê gamêŋ, taŋ katôc lemoc gebe jakêŋ êndêŋ êsêac naŋ. Aê oc jawiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Gêdêŋ taŋ Mose keto biŋsu tonec ŋabiŋ kêsêp buku teŋ e gêjac dabiŋ su naŋ, ");
INSERT INTO jae_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","eŋ kêjatu lau Lewi, taŋ sêbalaŋ Apômtaunê katapa poacŋa naŋ, gebe ");
INSERT INTO jae_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Akôc biŋsu ŋabuku tonec ma atoc ênêc êsi Apômtaunê katapa poacŋa, gebe êwa aê sa êndêŋ amac. ");
INSERT INTO jae_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Gebe aê kajala amacnêm ali awem sa to gêsômtêkwa ŋatoŋ. Alic acgom, galoc aê gamoa matoc jali gawiŋ amac, mago ali awem sa gêdêŋ Apômtau. Ma embe jamac êndu, oc aŋgôm taêsam êlêlêc. ");
INSERT INTO jae_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Akalem nêm gôlôacmôkê ŋalaumata to nêm kasêga, gebe jasôm biŋ tonec êsô êsêac taŋeŋsuŋ ma jakalem undambê to nom gebe sêŋô sêwiŋ, ec sêwa aê sa. ");
INSERT INTO jae_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Aê kajalagac, gebe aê jamac êndu su ma amac oc aŋgôm sec anac ŋawaegeŋ to awi lêŋ, taŋ kajatu amac, gebe asa naŋ siŋ. Go êtu ŋamu gêŋwapac êtap amac sa, gebe aŋgôm gêŋ, taŋ ênac Apômtau mataanô ŋajam atom naŋ. Amac lemem ŋakôm oc êŋgôm eŋ têtac ŋandaŋ êsa.” ");
INSERT INTO jae_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Go Mose kêsôm wê tonec ŋabiŋ kêsô lau Israel samob, taŋ sêkac sa naŋ, taŋeŋsuŋ e gêbacnê. ");
INSERT INTO jae_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“O undambêac, akêŋ taŋem, aê gabe jasôm biŋ, ma nom êŋô aê aoc. ");
INSERT INTO jae_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Ŋoc mêtê, taŋ kadôŋ naŋ, êsêp amboac kom, ŋoc biŋ êsêp êmêŋ amboac maniŋ, êtôm kom, taŋ kêmalôm nom to kêsêli gêgwaŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Gebe aê oc jasôm Apômtaunê ŋaê lasê. Atoc aêacnêŋ Anôtô samaŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","“Eŋ poctêna. Eŋ gêjam nê kôm ŋajam êndugeŋ, gebe nê lêŋ samob jagêdêŋ. Eŋ Anôtô ŋaŋêŋ ma nê keso masi, eŋ ŋac gêdêŋ to ŋakêŋkêŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Êsêac, taŋ têtu ênê gôlôac naŋ, sêgôm eŋ sec ŋanô. Êsêac lau sec to geo. ");
INSERT INTO jae_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","O amac lau meloc to kaucmêac, amac ajam daŋge Apômtau ŋa lêŋ amboac tonaŋ me. Amac tamemi eŋ, taŋ kêkêŋ amac naŋ, atom me. Eŋ kêlêsôb to kêmasaŋ amac atom me. ");
INSERT INTO jae_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Taêm ênam têm andaŋgeŋŋa, asala jala, taŋ gôlôac to gôlôac sêmoa naŋ. Ôtu kênac tamam ma eŋ oc êwa sa êndêŋ aôm. Ôtu kênac nêm lau ŋanô, go sênac miŋ êndêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Gêdêŋ taŋ Lôlôc Ŋatau kêkêŋ nomlênsêm gêdêŋ lau tomôkê-tomôkê samob, gêdêŋ taŋ eŋ gêwa ŋamalac latuŋi kêkôc naŋ, eŋ kêmasaŋ lau nomŋa samob nêŋ gamên ŋamadiŋ kêtôm Anôtônê aŋela nêŋ namba. ");
INSERT INTO jae_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Mago Apômtau tau tec gêwê kaiŋ lau toŋ teŋ tauŋa, Jakob kêtu ênê gêŋlênsêm. ");
INSERT INTO jae_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","“Eŋ kêtap Jakob sa aŋga gamêŋ sawa gêŋgôŋ gamêŋbôm ŋakicsêa ŋalêlôm, tec kêkwa eŋ auc to gêlôm eŋ ma gejob eŋ kêtôm tau nê matalakôp. ");
INSERT INTO jae_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Eŋ kelelo amboac momboaŋ gejob ŋalatu kêkô êsêac ŋaô. Eŋ gêlam nê magê gebe êpuc Jakob tôŋ, ma kêsip eŋ sa ŋa nê magê. ");
INSERT INTO jae_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Apômtau taugeŋ gêwê eŋ, anôtô jaba teŋ gêwiŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Eŋ gêwê eŋ kêpi nom ŋagamêŋ ŋabau ma kêkêŋ kôm ŋanô gêdêŋ eŋ geŋ. Eŋ kêkêŋ lêp kêsa aŋga poc eŋ kêlib to kêkêŋ ŋalêsi kêsa aŋga poctêmui. ");
INSERT INTO jae_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Eŋ kêkêŋ su gêjac anô aŋga bulimakao ma su ŋakana aŋga domba ma ŋalêsi aŋga domba ŋalatu to domba kapoacŋa. Eŋ kêkêŋ bulimakao gamêŋ Basanŋa to noniŋ ma polom ŋajam êndu. Ma kêkêŋ wain ŋanô ŋatêkwi kêtu wain aôm gônôm. ");
INSERT INTO jae_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“Amboac tonaŋ Jakob geŋ gêŋ e gêôc eŋ tôŋ. Mago Jesurun kêtôp ma kêtu kapôêŋ to ôli kêpi. Aôm kôtôp ma kôtu kapôêŋ ma ôlim ŋawasi. Go gêwi Anôtô, taŋ kêkêŋ eŋ naŋ, siŋ to kêsu nê poctêna, taŋ gêjam eŋ kêsi naŋ, susu. ");
INSERT INTO jae_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Êsêac sêsap anôtôi jaba tôŋ, tec biŋ tonec gêli ênê ŋalêlôm sa e gêjam lêmuŋ êsêac. Êsêac sêgôm gêŋ alôb-alôb tonaŋ, tec sêlakoc eŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Êsêac sêkêŋ da gêdêŋ ŋalau sec, sêkêŋ gêdêŋ Anôtô tau atom, sêkêŋ gêdêŋ anôtô jaba, taŋ êsêac sêjala atom naŋ, sêkêŋ gêdêŋ anôtôi wakuc, taŋ galocgeŋ dêdi sa naŋ. Amac tamemi têtêc êsêac atomanô. ");
INSERT INTO jae_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Aôm taêm gêjam poc, taŋ kêka aôm lasê naŋ, atom. Aôm kôliŋ Anôtô, taŋ kêtu aôm tamam naŋ siŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","“Apômtau gêlic biŋ tonec tec kêtiŋ êsêac su, gebe eŋ latuio to ŋac sêgôm eŋ têtac ŋandaŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Ma eŋ kêsôm gebe ‘Aê gabe jansaŋ laŋôcanô auc êndêŋ êsêac, ma jansaê gêŋ amboac ondoc oc êtap êsêac sa êtu ŋamu. Gebe êsêac lau geo, êsêac têtôm ŋapalê, taŋ sêmoa ŋaŋêŋ atom naŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Êsêac sêli ŋoc ŋalêlôm sa, tec gajam lêmuŋ êsêac kêtu gêŋ, taŋ anôtô atom naŋŋa. Êsêac sêlakoc aê ŋa nêŋ gwam. Amboac tonaŋ aê oc jali nêŋ ŋalêlôm sa e sênam lêmuŋ aê êtu lau, taŋ têtu ŋoc lau atom naŋŋa. Aê oc jalakoc êsêac ŋa lau-m meloc teŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Gebe aêŋoc têtac ŋandaŋ kêtuŋ ja teŋ gelom, ma ja tau gelom e gêdêŋ lamboam ŋalêlôm ma kêkwanam nom to nom ŋagêŋ samob to kêtuŋ lôc ŋamôkê gelom. ");
INSERT INTO jae_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“‘Aê oc jamboac gêŋwapac êpi êsêac ênsac gêŋwapac ŋaô ma japê ŋoc sôb samob êpi êsêac. ");
INSERT INTO jae_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Mo êjô êsêac êndu ma gêmac ôliŋ ŋandaŋŋa to gêmac sec gelom-gelomŋa enseŋ êsêac su. Aê oc jasakiŋ bôc saleŋŋa toluŋluŋ kaiŋ teŋ êndêŋ êsêac, to gêŋ, taŋ kêgalab gêmoa nom naŋ, ŋamalic. ");
INSERT INTO jae_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Siŋ oc enseŋ lau, taŋ sêmoa awê naŋ, su Ma lau, taŋ semoa balêm ŋalêlôm naŋ, têtakê e sêmac êndu. Awêtakiŋ to ŋacseŋom ma ŋapalê dedec to lau tomôdê samob oc sênaŋa. ");
INSERT INTO jae_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Aê gabe jasôm gebe “Aê gabe japa êsêac êliŋ-êliŋ, ma lau nomŋa taêŋ ênam êsêac êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Mago aê katêc ŋacjonêŋ tetoc tauŋ saŋa, gebe moae êsêacnêŋ ŋacjonêŋ kauc êsa atom. ma taêŋ ênam gebe “Aêac lemeŋ aku êsêac tulu, Apômtau gêgôm tonaŋ atom.” ’ ");
INSERT INTO jae_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","“Gebe êsêac lau teŋ, taŋ nêŋ jala masi naŋ, ma sêjala gêŋ teŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Embe nêŋ kauc ênêc, oc sêjala biŋ tonec ŋam ma nêŋ kauc êsa êpi gêŋ, taŋ oc êtap êsêac sa êtu ŋamu naŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Lau tau nêŋ poctêna embe êkêŋ êsêac dêndêŋ lau sênam ôli atom, ma Apômtau embe êwi êsêac siŋ atom, oc ŋac tageŋ êjanda êsêacnêŋ lau 1,000 amboac ondoc, ma ŋac luagêc têtakê nêŋ lau 10,000 e sêc su amboac ondoc. ");
INSERT INTO jae_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Gebe êsêacnêŋ poctêna kêtôm aêacnêŋ Poctêna atom, aêacnêŋ ŋacjo tauŋ sêwa biŋ tonec sa. ");
INSERT INTO jae_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Gebe êsêacnêŋ wainmôkê ŋam kêsêp wainmôkê Sodomŋa, gêmêŋ aŋga kôm Gomoraŋa. Êsêacnêŋ wain ŋanô ŋamalic sec, ma ŋanô tau ŋamakic ŋanô. ");
INSERT INTO jae_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Êsêacnêŋ wain kêtôm moac ŋamalic, kêtôm moacwêm ŋaawasulu sec. ");
INSERT INTO jae_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“Biŋ amboac tonaŋ kêsiŋ tau gêc aêŋa ma kalai auc gêc ŋoc balêm awamataŋa atom me. ");
INSERT INTO jae_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Êndêŋ taŋ êsêac sêka selelec naŋ, aê taucgeŋ oc jakac kamocgôc to jakêŋ ŋagêjô êndêŋ êsêac, gebe bêc êsêac sênaŋaŋa kêdabiŋgac, gêŋ enseŋ êsêac suŋa kêlêti gêmêŋ ");
INSERT INTO jae_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Biŋŋanô, Apômtau oc êmêtôc nê lau naêndêŋgeŋ ma eŋ taê walô nê sakiŋwaga. Eŋ gêlic gebe nêŋ ŋaclai samob gêbacnê ma nêŋ lau kapôêŋ to sauŋ samob gêbacnê. ");
INSERT INTO jae_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Go eŋ oc êsôm gebe ‘Êsêacnêŋ anôtôi sêmoa ondoc, poctêna, taŋ êsêac sêlamu naŋ, kêkô ondoc. ");
INSERT INTO jae_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Asa geŋ êsêacnêŋ da ŋaŋalêsi to gênôm êsêacnêŋ da, taŋ sêkêc siŋ naŋ, ŋawain. Êsêac sêndi sa to sênam amac samaŋ, êsêac têtu amacnêm lamumaŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","“‘Galoc alicgac, gebe aê, aê tauc tonec tec Apômtau, ma anôtô teŋ gêmoa gêwiŋ aê atomanô. Aê tec janac lau êndu ma aê jaŋu lau sa sêmoa mateŋ jali. Aê janac lau e kamoc êsa ma aê jaŋgôm kamoc emo. Ŋac teŋ oc êtôm, gebe ênam lau sa aŋga lemoc gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Biŋŋanô, aê jatôc lemoc êpi undambê ma jasôm gebe Aê tec jamoa teŋgeŋ, ");
INSERT INTO jae_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","embe jauc ŋoc siŋ ŋaôsic-ôsic ŋamata êsa ma embe jakôc kôm mêtôcŋa sa, go jakac kamocgôc êndêŋ ŋoc ŋacjo ma jakêŋ ŋagêjô êndêŋ lau têntac gedec aêŋa. ");
INSERT INTO jae_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","Aê jakêŋ dec êjaŋiŋ ŋoc sôb ma ŋoc siŋ êndaŋgôŋ gwada. Dec tau êmêŋ aŋga lau, taŋ sêjac êsêac êndu to lau kapoacwalôŋa nêŋ, oc êmêŋ aŋga ŋacjonêŋ siŋsêlêc môkêŋapac.’ ");
INSERT INTO jae_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","“O amac lau tomôkê-tomôkê samob, alambiŋ ênê lau, gebe eŋ êkêŋ ŋagêjô êjô nê sakiŋwaganêŋ dec to êkac nê ŋacjonêŋ kamocgôc ma eŋ êŋgôm nê launêŋ gamêŋ êtu selec.” ");
INSERT INTO jae_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Mose agêc Nun latu Josua sêô lasê ma sêsôm wê tonec ŋabiŋ samob lasê gêdêŋ lau sêŋô. ");
INSERT INTO jae_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Ma gêdêŋ taŋ Mose gêjac mata nê biŋ tonaŋ gêdêŋ lau Israel naŋ, ");
INSERT INTO jae_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","kêsôm gêdêŋ êsêac gebe “Biŋ samob, taŋ galoc gawa sa gêdêŋ amac naŋ, ênêc nêm ŋalêlôm, ma ajatu nêm gôlôac, gebe sêŋgôm biŋsu tonec ŋabiŋ samob ŋanô êsa ŋapepgeŋ, ");
INSERT INTO jae_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","gebe biŋ tau êtu biŋ ŋaôma atom, biŋ tau kêtu amac amoa matem jali ŋamôkê. Ma biŋ tonec êŋgôm amac aŋgôŋ ŋêŋgeŋ aŋga gamêŋ, taŋ êtu amacnêm gamêŋ êndêŋ taŋ alom bu Jordan su naŋ.” ");
INSERT INTO jae_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Gêdêŋ bêc tonaŋgeŋ Apômtau kêsôm gêdêŋ Mose gebe ");
INSERT INTO jae_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Ôpi gamêŋ lôcŋa Abarim ŋalôc Nebo, taŋ kêkô lau Moab nêŋ gamêŋ kêkanôŋ malac Jeriko ôna ma ôsala gamêŋ Kanaan, taŋ jakêŋ êndêŋ lau Israel gebe êtu nêŋ gamêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Su, go ômac êndu aŋga lôc, taŋ ôpi ôna naŋ, naôwiŋ nêm lau ôtôm têwam Aron gêmac êndu aŋga lôc Horeb jagêwiŋ nê lau. ");
INSERT INTO jae_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Biŋ tonaŋ kêtap amagêc sa gebe akêŋ gêwiŋ aê kwalec amoa lau Israel ŋalêlôm aŋga gamêŋ sawa Sin gêdêŋ taŋ aŋgôŋ bu Meribat-Kades naŋ, ma awaka aê sa gêdêŋ lau Israel, gebe aê ŋac dabuŋ nec atom. ");
INSERT INTO jae_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Ômoa jaêcgeŋ ma ôlic gamêŋ tau, mago naôsa gamêŋ, taŋ jakêŋ êndêŋ lau Israel naŋ atom.” lau nomŋa tomôkê-tomôkê samob nêŋ gejobwaga gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Mec, taŋ Anôtônê ŋac Mose gêjam mec lau Israel naŋ, tonec. Mec tau kêtu ênê awamu. ");
INSERT INTO jae_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","Eŋ kêsôm gebe “Apômtau gêmêŋ aŋga Sinai. Eŋ kêpi mêŋkêpô aêac aŋga Seir. Ênê ŋawê kêsa aŋga lôc Paran. Eŋ mêŋgêô lasê aŋga Meribat-Kades to ja ŋawaô kêsi eŋ lêma anôŋa. ");
INSERT INTO jae_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Biŋŋanô, eŋ têtac gêwiŋ nê lau, nê lau dabuŋ samob sêsêp eŋ lêma. Êsêac sêpuc aôm waŋam to sêsêlêŋ têdaguc nêm biŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Mose kêkêŋ biŋsu gêdêŋ aêac. Biŋsu tau kêtu gôlôac Jakobŋa nêŋ biŋlênsêm. ");
INSERT INTO jae_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Gêdêŋ taŋ launêŋ laumata sêkac to Israelnêŋ gôlôac samob sêpi tageŋ naŋ, Apômtau kêtu kiŋ aŋga Jesurun. ");
INSERT INTO jae_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“Ruben êmoa mata jali, eŋ êmac êndu atom, ma nê siŋwaganêŋ namba êtu sauŋ atom.” ");
INSERT INTO jae_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Biŋ tonec Mose kêsôm kêpi Juda gebe “O Apômtau, ôkêŋ taŋam Juda awa ma ôwê eŋ naêô lasê êndêŋ nê lau. Aôm lêmam ênac siŋ êjô eŋ to ônam eŋ sa aŋga nê ŋacjonêŋ.” ");
INSERT INTO jae_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Ma eŋ kêsôm biŋ tonec kêpi Lewi gebe “Ôkêŋ nêm Tumim to nêm Urim êndêŋ Lewi. Eŋ ŋac, taŋ gêjac matamanô ŋajam naŋ. Aôm kôsaê eŋ aŋga Masa to gôjac siŋ gôwiŋ eŋ aŋga bu Meribaŋa. ");
INSERT INTO jae_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Ŋac tau kêsôm kêpi têna agêc tama gebe ‘Aê kajala êsêagêc atom’. Eŋ gêlic nê lasitêwai atom ma gêjam kauc nê latuio to ŋac. Biŋŋanô, êsêac mateŋ gêdiŋ nêm biŋ to sejop nêm poac. ");
INSERT INTO jae_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Êsêac oc sêndôŋ nêm ŋagôliŋ êndêŋ Jakob ma nêm biŋsu êndêŋ Israel. Êsêac sêkêŋ gêŋ ŋamalu êndêŋ aôm ôŋu to tetoc daja ênsac nêm altar ŋaô. ");
INSERT INTO jae_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","O Apômtau, ônam mec ênê waba samob ma ôkôc eŋ lêma ŋakôm sa. Ôtuc ênê ŋacjo to lau, taŋ sêkêŋ kisa eŋ naŋ, magiŋ êsu, gebe sêndi sa êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Ma kêsôm biŋ tonec kêpi Benjamin gebe “Ŋac Apômtau têtac gêwiŋ eŋŋa, eŋ gêŋgôŋ tomalô. Lôlôc Ŋatau ejop eŋ êtôm bêcgeŋ, go êŋgôŋ ênê lôc ŋadeŋ êwiŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Ma kêsôm biŋ tonec kêpi Josep gebe “Apômtau ênam mec ênê nom ŋa ŋanô ŋajam, taŋ êsêp aŋga undambê ma êpi aŋga nom ŋalêlôm naŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","Oc êpô kôm e ênam ŋanô ŋajamanô, ma ŋanô esewec ŋajam êtôm ajôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Lôc laŋgwa sec êkêŋ kôm ŋanô ŋajam êndu to gamêŋ ŋabau teŋgeŋŋa ênam ŋanô êlêlêc su. ");
INSERT INTO jae_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Nom to ŋagêŋ samob êkêŋ ŋanô ŋajam-ŋajam, ma ŋac, taŋ gêmoa gamêŋ dani naŋ, êlic Josep ŋajam. Biŋ samob tonaŋ ŋai ŋanô êsa êpi Josep, êpi ŋac, taŋ kêtu nê lasitêwainêŋ kasêga naŋ, nê sunsuŋ ŋaô. ");
INSERT INTO jae_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Nê bulimakao kapoac ŋamêc kêtap ŋawasi sa ma ênê jabo kêtôm bulimakao saleŋŋa nê. Eŋ êsuc lau tomôkê-tomôkê ŋa jabo tonaŋ e naêndêŋ nom ŋamadiŋ. Epraimnê lau 10,000 to 10,000 tau tonaŋ, ma Manasenê lau 1,000 to 1,000 tau tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Ma kêsôm biŋ tonec kêpi Sebulon gebe “O Sebulon, têmtac ŋajam êsa êtu nêm lêŋ lagajaŋa Ma aôm Isakar, têmtac ŋajam êsa êtu nêm becoboŋa. ");
INSERT INTO jae_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Êsêac sêkalem lau tomôkê-tomôkê sêpi êsêacnêŋ lôc sêna. Aŋga tônê oc sêkêŋ da gêdêŋ, gebe êsêac sejoŋ gwêc ŋagêŋlêlôm totau-totau ŋaawamata, to gaŋac ŋaawamata, taŋ kêsiŋ tau naŋ sa.” ");
INSERT INTO jae_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Ma kêsôm biŋ tonec kêpi Gad gebe “Aê aoc êôc ŋac, taŋ kêkêŋ ŋasawa gêdêŋ Gad. Gad kêluŋ tau kêtôm lewe, eŋ kêkac gêŋ ŋalêma to ŋamôkêapac gêŋgic. ");
INSERT INTO jae_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Eŋ kêjaliŋ gamêŋ ŋajamanô sa kêtu tauŋa. Eŋ gêlic kasêganê nomlênsêm gêc kêtu eŋŋa. Eŋ jagêwiŋ launêŋ laumata ma gejob, gebe Apômtaunê mêtôc êtu anô to ênê biŋ êtu tôŋ êpi Israel.” ");
INSERT INTO jae_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Ma kêsôm biŋ tonec kêpi Dan gebe “Dan kêtôm lewe ŋalatu, taŋ gêboaŋ kêsa aŋga Basan gêmêŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Ma kêsôm biŋ tonec kêpi Naptali gebe “O Naptali, moasiŋ gêjam sêga aŋga aômnêm to Apômtaunê mec gêjam aôm auc. Aôm ôwê kaiŋ bugêjactoŋ to gamêŋ gêmu kêsêpŋa.” ");
INSERT INTO jae_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Ma kêsôm biŋ tonec kêpi Aser gebe “Aser kêtu Israel latuinêŋ ŋac, taŋ kêtap mec sa kêlêlêc naŋ. Nê lasitêwai têntac êwiŋ eŋ ŋanômaŋ, ma eŋ êsac akaiŋ tôŋ êsêp ŋalêsi. ");
INSERT INTO jae_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Sênsô tuŋ aôm auc ŋa ki jejec to kokoc, ma nêm ŋaclai ênaŋa atom e ômac êndu. ");
INSERT INTO jae_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“O Jesurun, ŋac teŋ kêtôm Anôtô, taŋ gêŋgôŋ tao ŋaô tonê ŋawasi me kêlêti gêmoa undambê gebe ênam aôm saŋa naŋ, gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Anôtô taugeŋ kêtu nêm lamuanô, eŋ kêsip aôm sa ŋa lêma teŋgeŋŋa. Eŋ kêtiŋ ŋacjo su gêmuŋ aôm ma kêsôm gebe Onseŋ sumaŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Tec Israel gêŋgôŋ tomalô, Jakobnê bumata êpoac tauŋa aŋga gamêŋ, taŋ gêjam ŋanô polom to wain. Biŋŋanô, ênê undambê kêpalip maniŋ kêsêp gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","O Israel, aê aoc êôc aôm. Asa kêtôm aôm. Apômtau tau gêjam aôm sa. Eŋ kêtu lautuc gêjam aôm kêsiŋa to siŋ êku nêm ŋacjo tuluŋa, Nêm ŋacjo sêô lasê aôm to sênac papac aôm, ma aôm ôsêlêŋ ômoa êsêacnêŋ lôc ŋaô.” taŋ sêlac waŋ kêtu têtulu gêŋŋa. ");
INSERT INTO jae_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Ma Mose gêdi aŋga gaboaŋ Moabŋa jakêpi lôc Nebo ŋatêpôê Pisga, taŋ kêkô kêkanôŋ Jeriko naŋ. Ma Apômtau kêtôc gamêŋ samob gêdêŋ eŋ aŋga Gilead e jagêdêŋ Dan, ");
INSERT INTO jae_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","kêtôc Naptalinê gamêŋ samob to Epraim agêc Manase nêŋ gamêŋ ma Judanê gamêŋ samob e gêdêŋ gwêc oc kêsêpŋa, ");
INSERT INTO jae_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ma kêtôc gamêŋ Negeb to gaboaŋ Jerikoŋa e jagêdêŋ Soar gêdêŋ eŋ. Jeriko tau kêtu malac nipŋa. ");
INSERT INTO jae_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Ma Apômtau kêsôm gêdêŋ eŋ gebe “Gamêŋ tonec tec katôc lemoc ma kasôm gêdêŋ Abraham agêc Isak ma Jakob gebe ‘Aê oc jakêŋ gamêŋ tau tonec êndêŋ nêm wakuc,’ naŋ gamêŋ tau tonec. Aê kakêŋ matamanô gôlic gamêŋ tau su, mago aôm taôm oc naôsa tônê atom.” ");
INSERT INTO jae_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Amboac tonaŋ Apômtaunê sakiŋwaga Mose tau gêmac êndu aŋga gamêŋ Moabŋa kêtôm Apômtaunê biŋ. ");
INSERT INTO jae_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Ma Apômtau kêsuŋ eŋ gêc gaboaŋ, taŋ gêc gamêŋ Moabŋa naŋ, kêkanôŋ Bet-Peor, mago ŋac teŋ kêjala ênê sêô atom e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mosenê jala 120, go gêmac êndu. Eŋ mataanô kêtu waô atom, ma ôliwalô gêjaŋa atom. ");
INSERT INTO jae_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Ma lau Israel têtaŋ taŋiboa kêtu Moseŋa sêmoa gaboaŋ Moabŋa kêtôm bêc 30, go bêc têtaŋ taŋiboa kêtu Moseŋa gêbacnê. ");
INSERT INTO jae_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Ma ŋalau tokauc tatu mêtê tauŋŋa gêjam Nun latu Josua auc, gebe Mose gêu lêma gêsac eŋ. Amboac tonaŋ lau Israel taŋeŋ wamu eŋ ma sêgôm biŋ, taŋ Apômtau kêjatu Mose naŋ, ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Ma propete teŋ gêdi sa aŋga Israel kêtôm Mose, taŋ êsêagêc Apômtau laŋôŋanô gêdêŋ tauŋ naŋ, atom e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Teŋ gêgôm gêŋsêga to gêŋtalô kêtôm Mose, taŋ Apômtau kêsakiŋ eŋ gebe êŋgôm aŋga gamêŋ Aiguptuŋa êndêŋ Parao ma ênê sakiŋwaga to ênê gamêŋ samob naŋ atom. ");
INSERT INTO jae_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Ma ŋac teŋ gêwê kaiŋ Mosenê ŋaclai to ŋajaŋa ma nê gêŋsêga kaiŋ teŋ, taŋ Mose gêgôm aŋga lau Israel samob laŋôŋnêmŋa naŋ atom. ");
INSERT INTO jae_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Apômtaunê sakiŋwaga Mose gêmac êndu su, go Apômtau kêsôm biŋ gêdêŋ Mosenê sakiŋwaga Nun latu Josua gebe ");
INSERT INTO jae_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Ŋoc sakiŋwaga Mose gêmac êndu, amboac tonaŋ ôndi olom bu Jordan tonec. Lau samob sêwiŋ aôm, ma naaô lasê gamêŋ, taŋ galoc jakêŋ êndêŋ lau Israel naŋ. ");
INSERT INTO jae_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Gamêŋ samob, taŋ emtapa aka naŋ, aê jakêŋ êndêŋ amac êtôm gajac mata gêdêŋ Mose. ");
INSERT INTO jae_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Gamêŋ samob, taŋ gêc gamêŋ sawa to lôc Lebanon ma bu kapôêŋ Euprat, taŋ kêtu lau Het nêŋ gamêŋ naŋ, e gêdêŋ gwêc kapôêŋ, taŋ kêpoac gêmu oc kêsêpŋa naŋ ŋasawa, gamêŋ samob tonaŋ êtu amacnêm nom. ");
INSERT INTO jae_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Êtôm têm ômoa matam jaliŋa naŋ, ŋac teŋ êtôm gebe êkô aôm auc atom. Aê jamoa jawiŋ aôm êtôm gamoa gawiŋ Mose. Aê oc jaŋgamiŋ tauc êndêŋ aôm to jawi aôm siŋ atom. ");
INSERT INTO jae_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ôkô ŋajaŋa totêmtac êpa sugeŋ, gebe aôm taômgeŋ ôkêŋ lau tonec sêwê kaiŋ gamêŋ, taŋ katôc lemoc gêdêŋ êsêac tameŋi gebe jakêŋ êndêŋ êsêacŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Amboac tonaŋ ôkô ŋajaŋa totêmtac êpa sugeŋ ma ojop taôm gebe ôŋgôm biŋsu samob, taŋ ŋoc sakiŋwaga Mose kêjatu aôm naŋ, ŋanô êsa. Ôwi biŋsu tau siŋ ma o sic ômu anô me gasêŋa atom, ec ôtap nêm lêŋ ŋanô ŋajam sa. ");
INSERT INTO jae_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Biŋsu ŋabuku ŋabiŋ ênêc aôm awamsuŋ ŋapaŋgeŋ. Taêm ênam biŋ tau ênêc nêm ŋalêlôm êtôm eleŋ to êmbêc, ec ôŋgôm biŋ samob, taŋ teto gêc buku tau naŋ, ŋanô êsa tomalageŋ. Embe ôŋgôm amboac tonaŋ, go ôsa nêm lêŋ e ônac dabiŋ ŋapep ma ôtap nêm lêŋ ŋanô ŋajam sa. ");
INSERT INTO jae_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Aê kajatu aôm gebe ôkô ŋajaŋa totêmtac êpa sugeŋ. Ôtêc taôm atom ma katôm ôluŋ-ôluŋ atom, gebe Apômtau, aômnêm Anôtô, oc êmoa êwiŋ aôm êtôm lêŋ samob, taŋ ôsa ôna naŋ.” ");
INSERT INTO jae_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Go Josua kêjatu launêŋ kasêga gebe ");
INSERT INTO jae_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Asa gamêŋ becŋa ana ma ajatu lau gebe ‘Amansaŋ nêm gêŋ aniŋŋa gebe êpuc amac tôŋ aŋga intêna. Bêc têlêac ênaŋa acgom, go alom bu Jordan tonec naakôc nom, taŋ Apômtau, amacnêm Anôtô, gebe êkêŋ êndêŋ amac naŋ su, gebe êtu amacnêm gamêŋ.’” ");
INSERT INTO jae_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Go Josua kêsôm gêdêŋ lau Ruben to Gad ma lau Manase ŋamakeŋ gebe ");
INSERT INTO jae_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Taêm ênam biŋ, taŋ Apômtaunê sakiŋwaga Mose kêjatu amac naŋ, gebe ‘Apômtau, amacnêm Anôtô, oc êkêŋ gamêŋ alêwaŋ taômŋa êndêŋ amac, ma gebe êkêŋ nom tonec êndêŋ amac.’ ");
INSERT INTO jae_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Amacnêm lauo to nêm gôlôac ŋasec-ŋasec ma nêm bulimakao sêmoa gamêŋ, taŋ Mose kêkêŋ gêdêŋ amac gêc bu Jordan ŋamakeŋ tonecŋa naŋ. Mago amacnêm lau ŋaclai sêja laukasap sa naselom bu sêmuŋ nêm lasitêwai ma sênam êsêac sa ");
INSERT INTO jae_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","e Apômtau êkêŋ nêm lasitêwai sêlêwaŋ tauŋ têtôm amac ma sêŋgôŋ têtu wakac aŋga gamêŋ, taŋ Apômtau êkêŋ êndêŋ êsêac naŋ. Su, go amac amu amêŋ nom, taŋ kêtu amacnêm gamêŋ naŋ. Apômtaunê sakiŋwaga Mose kêkêŋ gamêŋ, taŋ gêc bu Jordan ŋamakeŋ gêmu oc kêpiŋa naŋ, gêdêŋ amac.” ");
INSERT INTO jae_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ma êsêac sêjô Josua awa gebe” Biŋ samob, taŋ kôjatu aêac naŋ, aêac abe aŋgôm ŋanô êsa, ma asa gamêŋ samob, taŋ ôsakiŋ aêac naŋ ana. ");
INSERT INTO jae_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Aêac taŋeŋ wamu aôm êtôm taŋeŋ wamu Mosenê biŋ samob. Biŋ tageŋ tonec gebe Apômtau, aômnêm Anôtô êmoa êwiŋ aôm êtôm gêmoa gêwiŋ Mose. ");
INSERT INTO jae_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Lau samob, taŋ sêli aweŋ sa êndêŋ aômnêm jatu to taŋeŋpêc aômnêm biŋ, taŋ ôjatu êsêac naŋ, oc sênac êsêac êndu. Biŋ tageŋ tonec gebe ôkô ŋajaŋa ma têmtac êpa su.” ");
INSERT INTO jae_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Go Nun latu Josua kêsakiŋ ŋac luagêc kelecgeŋ aŋga gamêŋ Sitim, gebe sêkêŋ keleŋ gamêŋ. Eŋ kêsôm gêdêŋ êsêagêc gebe “Ajôc, amagêc akêŋ keleŋ gamêŋ to malac Jeriko amboac tonaŋgeŋ.” Ma êsêagêc sêja jasêô lasê mockaiŋo teŋ nê andu ma sêŋgôŋ tônê. Awê tau nê ŋaê gebe Rahab. ");
INSERT INTO jae_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ma lau sêkêŋ ŋawae gêdêŋ kiŋ Jerikoŋa ma sêsôm gebe “Ôlic acgom, gêdêŋ gêbêc lau Israel nêŋ lau ŋagêdô sêô lasê tonec gebe sêlic gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Go kiŋ Jerikoŋa kêsakiŋ lau dêdêŋ Rahab jasêsôm gebe “Ôkêŋ lau, taŋ sêpi nêm andu dêdêŋ aôm sêwac naŋ, sêsa sêmêŋ. Êsêac sêmêŋ gebe sêkêŋ keleŋ gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Mago awê kêkôc ŋaclagêc sa jakêsiŋ êsêagêc ôkwi ma kêsôm gebe “Biŋŋanô, lau dêdêŋ aê sêmêŋ, mago aê gajam kauc êsêac sêmêŋ aŋga ondoc. ");
INSERT INTO jae_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Gêdêŋ taŋ gamêŋ ŋakesec kêsa ma kêdabiŋ gebe sênsaŋ malac ŋakatam auc naŋ, lau tau sêc sêja. Gamêŋ taŋ êsêac sêja naŋ, aê gajam kauc. Andaŋguc êsêac ŋagaôgeŋ, oc aê êsêac tôŋ.” ");
INSERT INTO jae_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Mago awê tau gêwê êsêagêc sêpi salôm ŋaô jakêsiŋ êsêagêc sêc mê ŋalauŋ, taŋ eŋ kêta gêc salôm ŋaô naŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Amboac tonaŋ lau tau têdaguc êsêagêc sêsa intêna Jordanŋa sêja e jadêdêŋ buseleŋ. Lau tonaŋ sêwi malac siŋ, ma sêsaŋ katam auc. ");
INSERT INTO jae_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Ŋaclagêc tau sêc bêc atom tageŋ ma awê kêpi salôm gêdêŋ êsêagêc gêja ");
INSERT INTO jae_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ma kêsôm gêdêŋ êsêagêc gebe “Aê kajalagac gebe Apômtau kêkêŋ gamêŋ tonec gêdêŋ amac, ma aêac samob atêc amac, ma lau gamêŋ tonecŋa nêŋ ŋalêlôm kêtu palê sugac. ");
INSERT INTO jae_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Gebe aêac aŋô ŋawae, gebe Apômtau kêkêŋ Gwêckoc kêtu keleŋ kêtu amacŋa gêdêŋ taŋ awi Aiguptu siŋ naŋ. Ma aŋô gêŋ, taŋ agôm gêdêŋ lau Amor nêŋ kiŋ luagêc Sihon agêc Og aŋga Jordan ŋamakeŋ ônêŋa. Amac aseŋ êsêagêc su samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Gêdêŋ ŋasawa, taŋ aêac aŋô biŋ tonaŋ naŋ, aêacma ŋalêlôm kêtu palê kêtu amacŋa, ma ŋajaŋa teŋ gêc lau teŋ kêtiam atom, gebe Apômtau, amacnêm Anôtô, eŋ undambê lôlôcŋa ma nom eloŋŋa ŋaAnôtô. ");
INSERT INTO jae_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Amboac tonaŋ atôc lemem êndêŋ Apômtau ma asôm êndêŋ aê gebe taêm walô tamocnê gôlôac êtôm aê tauc taêc walô amagêc. Ma akêŋ ŋabelo ŋanô teŋ êndêŋ aê. ");
INSERT INTO jae_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Aôc lemem tôŋ êndêŋ tinoc agêc tamoc ma lasicio to ŋac ma êsêacnêŋ lau samob, ma anam aêac sa gebe amac êndu atom.” ");
INSERT INTO jae_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ma ŋaclagêc sêsôm gêdêŋ eŋ gebe “Amac embe aoc aêagêcma biŋ tonec lasê atom, go aêagêc anac da amac. Êndêŋ taŋ Apômtau êkêŋ gamêŋ tau êndêŋ aêac naŋ, taêŋ walô amac to amoasiŋ amac.” ");
INSERT INTO jae_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Go awê tau kêlêwaŋ êsêagêc ŋa lêpoa sêsêp katam sauŋ, gebe nê andu kêtu tuŋbôm malacŋa gêwiŋ, tec tuŋbôm kêtu ênê andu. ");
INSERT INTO jae_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Ma eŋ kêsôm gêdêŋ êsêagêc gebe “Api lôc ana, gebe sêjandawaga têtap amagêc sa atom. Asiŋ taôm amoa tônê êtôm bêc têlêac e sêjandawaga sêmu sêmêŋ su acgom, go amagêc asa nêm intêna ana.” ");
INSERT INTO jae_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Go ŋaclagêc sêsôm gêdêŋ eŋ gebe “Ôlic acgom, êndêŋ taŋ aêac asa gamêŋ tonec amêŋ naŋ, ômoatiŋ gam kokoc tonec eŋkaleŋ katam sauŋ, taŋ kôlêwaŋ aêagêc asêp amêŋ naŋ. Ma tênam agêc tamam to lômi ma tamamnê gôlôac samob sêpi tageŋ aŋga nêm andu. Embe ôŋgôm tonec atom, go biŋ, taŋ aôm kôsôm gebe atôc lemeŋ êpi naŋ, ênsêlô. ");
INSERT INTO jae_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ŋac teŋ embe êwi nêm andu siŋ êsa intêna êna, naŋ eŋ tau êwê nê dec ŋakaiŋ, aêac atom. Mago ŋac teŋ, taŋ êmoa andu ŋalêlôm êwiŋ aôm naŋ, embe êtap gêŋwapac sa, go aêac awê ênê dec ŋakaiŋ. ");
INSERT INTO jae_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ma aôm embe ôsôm aêagêcma biŋ tonaŋ lasê, go biŋ, taŋ aôm kôsôm gebe aêagêc atôc lemeŋ êpi naŋ ênsêlô.” ");
INSERT INTO jae_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ma awê tau kêsôm gebe “Biŋ taŋ asôm su naŋ, ŋanô êsa.” Go kêsakiŋ êsêagêc gebe sêc sêna, tec êsêagêc sêwi eŋ siŋ ma sêja. Ma eŋ tau kêmoatiŋ gam kokoc geŋkaleŋ katam sauŋ tau. ");
INSERT INTO jae_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Êsêagêc sêwi awê tau siŋ jasêpi lôc ma sêmoa tônê kêtôm bêc têlêac e sêjandawaga sêmu sêja. Sêjandawaga sesom gamêŋ, taŋ gêc intêna makeŋ-makeŋ naŋ, mago têtap lau teŋ sa atom. ");
INSERT INTO jae_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Go ŋaclagêc sêsêp aŋga lôc sêmêŋ kêtiam jaselom bu ma sêô lasê dêdêŋ Nun latu Josua, go sêjac miŋ biŋ samob, taŋ kêtap êsêagêc sa naŋ, gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ma sêsôm gêdêŋ Josua gebe “Apômtau kêkêŋ gamêŋ samob kêsêp aêac lemeŋ biŋŋanôgeŋ. Ma biŋ teŋ, lau gamêŋ tauŋa samob sêmoa tonêŋ ŋalêlôm ŋatutucgeŋ kêtu aêacŋa.” ");
INSERT INTO jae_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Gêdêŋ bêbêc kanucgeŋ Josua gêdi ma gêwi Sitim siŋ ma lau Israel samob sêwiŋ eŋ. Êsêac sêô lasê bu Jordan ma sê becobo aŋga tônê, selom sebeŋ atom. ");
INSERT INTO jae_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Bêc têlêac gêbacnê, go siŋwaganêŋ laumata sêsêlêŋ sêmoa gamêŋ becŋa ŋalêlôm ");
INSERT INTO jae_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ma sêjatu lau gebe “Amac embe alic Apômtau, amacnêm Anôtô, nê katapa poacŋa, taŋ lau Lewi nêŋ dabuŋwaga sêmbalaŋ naŋ, go andi ma andaŋguc katapa tau, ");
INSERT INTO jae_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ec ajala intêna, taŋ asa naŋ, gebe amac asa intêna tonec kwanaŋgeŋ atom. Mago ŋasawa êniŋ katapa to amac êŋgic. Ŋasawa tau amboac saka 500. Andambiŋ katapa tau atom.” ");
INSERT INTO jae_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ma Josua kêsôm gêdêŋ lau gebe “Anam dabuŋ taôm, gebe eleŋŋa Apômtau gebe êŋgôm gêŋtalô aŋga amac ŋalêlôm.” ");
INSERT INTO jae_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ma Josua kêsôm gêdêŋ dabuŋwaga gebe “Aôc katapa poacŋa sa ma asêlêŋ amuŋ.” Tec êsêac sêôc katapa poacŋa tau sa ma sêsêlêŋ sêmuŋ lau. ");
INSERT INTO jae_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ma Apômtau kêsôm gêdêŋ Josua gebe “Ocsalô aê gabe jatoc aôm sa lau Israel samob sêlic e sêjala gebe aê oc jamoa jawiŋ aôm êtôm gamoa gawiŋ Mose. ");
INSERT INTO jae_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ma aôm ôjatu dabuŋwaga, taŋ sêmbalaŋ katapa poacŋa naŋ, gebe ‘Êndêŋ taŋ aô lasê Jordan ŋatali naŋ, akô ŋaŋêŋgeŋ aŋga bu ŋalêlôm.” ’ ");
INSERT INTO jae_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Go Josua kêsôm gêdêŋ lau Israel gebe “Ajôc, atu gasuc amêŋ, ma akêŋ taŋem Apômtau, amacnêm Anôtô, nê biŋ.” ");
INSERT INTO jae_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ma Josua kêsôm gebe “Biŋ tonec êwa sa êndêŋ amac gebe Anôtô mata jali gêmoa gêwiŋ amac ma eŋ êsêlêŋ êmuŋ amac ma êjanda lau Kanaan to Het ma lau Hiw to Peris ma lau Girgas to Amor ma Jebus biŋŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Alic acgom, Apômtau, taŋ kêtu nom samucgeŋ ŋatau naŋ, nê katapa poacŋa elom bu Jordan êmuŋ amac. ");
INSERT INTO jae_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ma galoc ajaliŋ lau 12 sa aŋga Israelnêŋ gôlôacmôkênêŋ, ŋac tageŋ-tageŋ êtôm gôlôacmôkêgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ma êndêŋ taŋ lau dabuŋ, taŋ sêmbalaŋ Apômtau, nom samucgeŋ ŋatau, nê katapa naŋ, sêu eŋtapa êsêp bu Jordan, go bu tau enseleŋ êtiam atom êpoac ma bumôkê êlêc sa naêkô amboac lênsaŋ teŋ.” ");
INSERT INTO jae_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Amboac tonaŋ gêdêŋ taŋ lau dêdi aŋga nêŋ becobo sebe selom bu Jordan naŋ, dabuŋwaga sêbalaŋ katapa poacŋa sêmuŋ lau. ");
INSERT INTO jae_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ma gêdêŋ taŋ dabuŋwaga, taŋ sêbalaŋ katapa naŋ, sêô lasê Jordan ma gêdêŋ taŋ lau-sabalaŋ-katapawaga tau sêu eŋkaiŋ kêsêp bu, taŋ kêsalê Jordan ŋatali auc gêdêŋ têm sêjac kôm ŋanô saŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","bumôkê gêlêc sa jakêsuŋ tôŋ kêkô Jaêcgeŋ amboac lênsaŋ kêkanôŋ malac Adam, taŋ gêc Sareta ŋagala naŋ. Ma bu aêŋa, taŋ kêsa gwêc Arabaŋa, taŋ sêsam teŋ gebe Gwêcmatê naŋ, kêpa samucgeŋ. Ma lau selom sêsêp gamêŋ, taŋ kêkanôŋ Jeriko naŋ. ");
INSERT INTO jae_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ma gêdêŋ taŋ lau Israel samob sêsêlêŋ sêmoa gamêŋ keleŋgeŋ jasêpi bumakeŋ naŋ, dabuŋwaga, taŋ sêbalaŋ katapa poacŋa naŋ, sêkô gamêŋ ŋakeleŋ aŋga bu Jordan ŋaluŋ e lau samob selom bu Jordan gêbacnê. ");
INSERT INTO jae_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Lau samob selom bu Jordan jasêpi su acgom, go Apômtau kêsôm gêdêŋ Josua gebe ");
INSERT INTO jae_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Ôjaliŋ lau 12 sa aŋga launêŋ, ŋac tageŋ-tageŋ êtôm gôlôacmôkêgeŋ, ");
INSERT INTO jae_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ma ôjatu êsêac gebe ‘Akôc poc 12 aŋga Jordan ŋaluŋ tonec, akôc aŋga gamêŋ, taŋ dabuŋwaga eŋtapa sêka naŋ, ma akôc poc tau amêŋ bumakeŋ ma atoc poc tau êkô gamêŋ, taŋ êmbêc anêc naŋ.’” ");
INSERT INTO jae_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Go Josua kêkalem lau 12 tau aŋga lau Israel nêŋ, taŋ kêjaliŋ sa naŋ, ŋac tageŋ-tageŋ kêtôm gôlôacmôkêgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Ma Josua kêsôm gêdêŋ êsêac gebe “Asêlêŋ naamuŋ Apômtau, amacnêm Anôtô, nê katapa êsêp bu Jordan ŋaluŋgeŋ ma aôc poc tageŋ-tageŋ êtômgeŋ ma poc tau ŋanamba êtôm Israelnêŋ gôlôacmôkê. ");
INSERT INTO jae_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Poc tonaŋ êtu ŋabelo êkô amac ŋalêlôm. Ma embe nêm ŋapalêo to ŋac têtu kênac amac êtu ŋamu gebe ‘Poc tonec gebe êwa asageŋ sa êndêŋ amac,’ ");
INSERT INTO jae_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","go anac miŋ êndêŋ êsêac gebe Bu Jordan gêlêc sa ma kêkêŋ ŋasawa gêdêŋ Apômtaunê katapa poacŋa. Gêdêŋ taŋ katapa tau gelom Jordan naŋ, ŋabu gêlêc sa. Tec poc tonec êtu ŋabelo teŋgeŋŋa êndêŋ lau Israel.” ");
INSERT INTO jae_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ma lau tau sêgôm biŋ, taŋ Josua kêjatu naŋ, ŋanô kêsa ma sêkôc poc 12 aŋga Jordan ŋaluŋgeŋ kêtôm lau Israel nêŋ gôlôacmôkênêŋ toŋ, kêtôm taŋ Apômtau kêsôm gêdêŋ Josua naŋ. Ma êsêac sêôc poc tau selom jasêpi gamêŋ, taŋ sebe sênêc naŋ, ma tetoc poc tau sêŋgôŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Ma Josua gêboa poc 12 sa kêkô Jordan ŋaluŋgeŋ aŋga gamêŋ, taŋ dabuŋwaga sêbalaŋ Apômtaunê katapa ma eŋtapa sêka naŋ, ma poc tau kêkô tônê e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Ma Apômtau kêjatu Josua gebe êsôm biŋ, taŋ Mose kêjatu Josua naŋ, êndêŋ lau Israel. Ma dabuŋwaga, taŋ sêbalaŋ katapa naŋ, gacgeŋ sêkô Jordan ŋaluŋgeŋ e biŋ samob, taŋ Apômtau kêjatu Josua naŋ, ŋanô kêsa. Ma lau selom sêkac tauŋgeŋ sêja bumakeŋ. ");
INSERT INTO jae_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Ma gêdêŋ taŋ lau samob selom jasêpi ŋamakeŋ su naŋ, Apômtaunê katapa to dabuŋwaga selom amboac tonaŋgeŋ sêmuŋ lau. ");
INSERT INTO jae_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Rubennê wakuc ma Gadnê wakuc to Manasenê gôlôac ŋamakeŋ selom tolaukasapgeŋ sêmuŋ lau Israel kêtôm Mose kêjatu êsêac. ");
INSERT INTO jae_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Siŋwaga tolaukasap amboac 40,000 selom jasêpi Jeriko ŋagamêŋ gaboaŋŋa sêja. Êsêac sêmasaŋ tauŋ gebe sênac siŋ sêmoa Apômtau laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Gêdêŋ bêc tonaŋ Apômtau ketoc Josua sa aŋga lau Israel laŋôŋnêm ŋa ma êsêac têtêc eŋ kêtôm têm, taŋ gêmoa mata jali naŋ, kêtôm têtêc Mose. ");
INSERT INTO jae_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ma Apômtau kêsôm gêdêŋ Josua gebe ");
INSERT INTO jae_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Ôjatu dabuŋwaga, taŋ sêbalaŋ katapa poacŋa naŋ, gebe sêpi aŋga Jordan sêmêŋ.” ");
INSERT INTO jae_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Amboac tonaŋ Josua kêjatu dabuŋwaga gebe “Api aŋga Jordan amêŋ.” ");
INSERT INTO jae_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Ma gêdêŋ taŋ dabuŋwaga, taŋ sêbalaŋ Apômtaunê katapa poacŋa naŋ, sêpi aŋga Jordan ŋaluŋ su ma êsêac eŋtapa sêka gamêŋ ŋakeleŋ naŋ, bu Jordan gêjô tau mala e kêsalê butali auc kêtiam kêtôm gêmuŋŋa. ");
INSERT INTO jae_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Lau mêŋsêpi aŋga Jordan gêdêŋ ajôŋ ŋamataŋa ŋabêc kêtu 10 ma sê nêŋ bec sêŋgôŋ Gilgal, taŋ gêc malac Jeriko ŋagamêŋ oc kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Ma Josua gêboa poc 12, taŋ êsêac sêkôc aŋga Jordan naŋ, sa aŋga Gilgal. ");
INSERT INTO jae_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Ma eŋ kêsôm gêdêŋ lau Israel gebe “Amacnêm ŋapalêo to ŋac embe têtu kênac tameŋi êtu ŋamu gebe ‘Poc tonec ŋam amboac ondoc,’ ");
INSERT INTO jae_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","go awa sa êndêŋ êsêac ma asôm gebe ‘Lau Israel selom bu Jordan tonec sêmoa gamêŋ keleŋgeŋ,’ ");
INSERT INTO jae_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","gebe Apômtau, amacnêm Anôtô, gêgôm bu Jordan kêpa kêtu amacŋa e alom mêŋapi ŋamakeŋ kêtôm gêgôm gêdêŋ Gwêckoc, taŋ gêgôm kêpa kêtu aêacŋa e alom mêŋapi ŋamakeŋ. ");
INSERT INTO jae_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Eŋ gêgôm gêŋ tonaŋ, gebe lau tomôkê-tomôkê nomŋa sêjala, gebe Apômtau lêma ŋajaŋa ma gebe amac atêc Apômtau, amacnêm Anôtô, endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Lau Amor nêŋ kiŋ samob, taŋ sêmoa bu Jordan ŋamakeŋ kêsi gamêŋ oc kêsêpŋa naŋ, ma lau Kanaan nêŋ kiŋ samob, taŋ sêŋgôŋ gwêctali naŋ, sêŋô ŋawae gebe Apômtau gêgôm bu Jordan kêpa kêtu lau Israelŋa e selom bu su, tec nêŋ ŋalêlôm kêtu palê ma nêŋ ŋaclai gêbacnê kêtu lau Israelŋa. ");
INSERT INTO jae_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Gêdêŋ ŋasawa tonaŋ Apômtau kêsôm gêdêŋ Josua gebe “Ômansaŋ bôjaŋ poc ma ôsa lau Israel êtiam êtu luagêcŋa.” ");
INSERT INTO jae_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Amboac tonaŋ Josua kêmasaŋ bôjaŋ poc ma kêsa lau Israel aŋga Gibeat-Haralot. ");
INSERT INTO jae_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Josua kêsa êsêac kêtu ŋam amboac tonecŋa gebe lau to siŋwaga samob, taŋ sêwi Aiguptu siŋ naŋ, sêmac êndu aŋga intêna gamêŋ sawaŋa gêdêŋ taŋ sêwi Aiguptu siŋ su naŋ. ");
INSERT INTO jae_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Êsêac sêsa lau samob, taŋ sêmêŋ naŋ, mago lau samob, taŋ teneŋi sêkôc êsêac gêdêŋ taŋ sêwi Aiguptu siŋ su ma sêmoa intêna gamêŋ sawaŋa naŋ, tec sêsa êsêac atom. ");
INSERT INTO jae_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Gebe lau Israel sêsêlêŋ sêmoa gamêŋ sawa kêtôm jala 40 e lau samob to siŋwaga samob, taŋ sêwi Aiguptu siŋ naŋ, sêjaŋa aŋga gamêŋ sawa kêtu êsêac sêkêŋ taŋeŋ Apômtau awa atomŋa, tec Apômtau kêtôc lêma gebe êsêac sêlic gamêŋ, taŋ Apômtau gêjac mata gêdêŋ aêac tameŋi gebe êkêŋ gamêŋ, taŋ su to lêp keseleŋ êndêŋ aêac naŋ atom. ");
INSERT INTO jae_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Amboac tonaŋ Josua kêsa êsêac gebe êsêac sêsa lau tonaŋ aŋga intêna atom. ");
INSERT INTO jae_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Gêdêŋ taŋ sêsa lau samob su naŋ, sêŋgôŋ nêŋ gamêŋ becoboŋageŋ e kamoc gemo. ");
INSERT INTO jae_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ma Apômtau kêsôm gêdêŋ Josua gebe “Ocsalô tonec aê kakac biŋ majeŋ Aiguptuŋa su aŋga amacnêm.” Tec sê gamêŋ tau ŋaê gebe Gilgal e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Lau Israel sê nêŋ becobo sêŋgôŋ Gilgal ma gêdêŋ ajôŋ tonaŋ ŋabêc kêtu 14 ŋagêbêc êsêac sêlic om Pasa. Êsêac sêmoa malac Jeriko ŋagamêŋ gaboaŋŋa. ");
INSERT INTO jae_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Seŋ Pasa su ma ŋageleŋ êsêac seŋ gamêŋ tau ŋakôm ŋanô, seŋ polom ŋaluc to polom ŋanô, taŋ sêpac naŋ, gêdêŋ bêc tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ma mana tau gêbacnê gêdêŋ bêbêcgeŋ tonaŋ, gêdêŋ taŋ seŋ gamêŋ tau ŋakôm ŋanô naŋ. Ma lau Israel têtap mana sa kêtiam atom, seŋ gamêŋ Kanaan ŋakôm ŋanô gêdêŋ jala tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Gêdêŋ taŋ Josua gêmoa Jeriko ŋamalac gala naŋ, eŋ gêôc mataanô sa ma gêlic ŋac teŋ kêkô eŋ laŋônêmŋa. Ŋac tau gê nê siŋ sa ma kêmêgôm siŋ tau ŋa lêma. Josua gêdêŋ eŋ gêja ma kêsôm gêdêŋ eŋ gebe “Aêacma ŋac aôm me ma ŋacjonêŋ ŋac aôm.” ");
INSERT INTO jae_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ma eŋ kêsôm gebe “Masi, aê Apômtaunê siŋwaganêŋ laumata. Galocgeŋ tec gamêŋ.” Go Josua gêu tau jagêc laŋôanô gêdêŋ nom ma keteŋ mec to kêsôm gêdêŋ eŋ gebe “Ŋoc apômtau êjatu biŋ ondoc êndêŋ nê sakiŋwaga.” ");
INSERT INTO jae_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ma Apômtaunê siŋwaganêŋ laumata kêsôm gêdêŋ Josua gebe “Ônu atapa su aŋga amtapa, gebe gamêŋ, taŋ kôkô naŋ, gamêŋ dabuŋ.” Ma Josua gêgôm kêtôm tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ma lau Jeriko sêbalaŋ nêŋ malac auc ŋapep kêtu lau Israelŋa. Lau teŋ sêsô-sêsa atom. ");
INSERT INTO jae_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ma Apômtau kêsôm gêdêŋ Josua gebe “Ôlic acgom, aê kakêŋ Jeriko to ŋakiŋ ma siŋwaga toŋaclai sêsêp aôm lêmam. ");
INSERT INTO jae_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Amboac tonaŋ amac siŋwaga samob asêlêŋ aŋgi malac tau auc êtu dim tageŋ. Ma aŋgôm amboac tonaŋ êtôm bêc 6. ");
INSERT INTO jae_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ma dabuŋwaga 7 sêkôc dauc 7 sêsêlêŋ sêmuŋ katapa poacŋa. Ma êndêŋ bêc êtu 7ŋa amac asêlêŋ aŋgi malac auc êtu dim 7 ma dabuŋwaga sênac dauc êtaŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ma êsêac embe sênac dauc êtaŋ ê tôŋ baliŋgeŋ, ma amac embe aŋô dauc êtaŋ amboac tonaŋ, go lau samob sênam lasê toaligeŋ ma malac ŋatuŋbôm êku sa ma lau samob gacgeŋ sembo sêsa malaclêlôm sêna.” ");
INSERT INTO jae_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Amboac tonaŋ Nun latu Josua kêkalem dabuŋwaga ma kêsôm gêdêŋ êsêac gebe “Aôc katapa poacŋa sa ma dabuŋwaga 7 sêkôc dauc 7 ma sêsêlêŋ sêmuŋ Apômtaunê katapa poacŋa.” ");
INSERT INTO jae_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Ma eŋ kêsôm gêdêŋ lau gebe “Ajôc, asêlêŋ aŋgi malac auc ma siŋwaga tolaukasap sêsêlêŋ sêmuŋ Apômtaunê katapa.” ");
INSERT INTO jae_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Ma lau sêgôm biŋ, taŋ Josua kêjatu naŋ, ŋanô kêsa. Dabuŋwaga 7 sêkôc dauc 7 ma sêsêlêŋ sêmuŋ sêmoa Apômtau laŋônêmŋa. Êsêac sêjac dauc kêtaŋ ma Apômtaunê katapa poacŋa kêsêlêŋ kêdaguc êsêac. ");
INSERT INTO jae_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ma siŋwaga tolaukasap sêsêlêŋ sêmuŋ dabuŋwaga, taŋ sêjac dauc kêtaŋ ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ma Josua kêjatu lau gebe “Anam lasê atom, anam taôm tôŋgeŋ, asôm biŋ teŋ êsa awemsuŋ atom e êndêŋ bêc aê jasôm êndêŋ amac gebe Anam lasê, go anam lasê.” ");
INSERT INTO jae_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Amboac tonaŋ eŋ kêsakiŋ Apômtaunê katapa kêgi malac tau auc kêtu dim tageŋ. Su, go sêô lasê gamêŋ becoboŋa kêtiam ma sêc bêc aŋga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Gêdêŋ bêbêc kanucgeŋ Josua gêdi sa ma dabuŋwaga sêbalaŋ Apômtaunê katapa. ");
INSERT INTO jae_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Ma dabuŋwaga 7 sêkôc dauc 7 sêsêlêŋ sêmuŋ Apômtaunê katapa ma sêjac dauc ŋapaŋ. Ma siŋwaga tolaukasap sêsêlêŋ sêmuŋ êsêac ma lau ŋagêdô têdaguc Apômtaunê katapa, ma dauc kêtaŋ ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ma gêdêŋ bêc kêtu luagêcŋa êsêac sêsêlêŋ sêgi malac auc kêtu dim tageŋ amboac tonaŋgeŋ ma sêmu sêja gamêŋ becoboŋa. Sêgôm amboac tonaŋ kêtôm bêc 6. ");
INSERT INTO jae_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Gêdêŋ bêc kêtu 7ŋa êsêac dêdi gêdêŋ geleŋ mata ma sêsêlêŋ sêgi malac auc amboac sêgôm-sêgôm kêtu dim 7. Gêdêŋ bêc tageŋ tonaŋgeŋ tec êsêac sêsêlêŋ sêgi malac auc kêtu dim 7. ");
INSERT INTO jae_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Ma gêdêŋ taŋ sêgi malac auc kêtu dim 7ŋa ma dabuŋwaga sêjac dauc kêtaŋ naŋ, Josua kêsôm gêdêŋ lau gebe “Anam lasêmaŋ, gebe Apômtau kêkêŋ malac tau gêdêŋ amac. ");
INSERT INTO jae_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ma malac to ŋagêŋ samob êtu Apômtaunê gêŋ enseŋ suŋa. Mockaiŋo Rahab to nê lau samob, taŋ sêmoa sêwiŋ eŋ aŋga ênê andu naŋ, tauŋgeŋ go sêmoa mateŋ jali, gebe eŋ gêsa lau jaeŋŋa, taŋ aêac tasakiŋ êsêac naŋ auc. ");
INSERT INTO jae_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Ma amac ajop taôm êndêŋ gêŋ, taŋ gêjac anseŋ suŋa ŋawae. Matem katu gêŋ tau e akôc ŋagêdô, taŋ kêtu Apômtaunê naŋ, su atom. Embe aŋgôm, go lau Israel nêŋ gamêŋ becoboŋa êwê kaiŋ biŋ, taŋ êtap malac Jeriko sa naŋ, êwiŋ ma êtap gêŋwapac ŋanô sa. ");
INSERT INTO jae_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ma silber to gold samob ma laclu, taŋ sêmasaŋ ŋa ki kokoc to jejec naŋ, êtu Apômtaunê gêŋ dabuŋ naêsêp Apômtaunê kanom.” ");
INSERT INTO jae_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Amboac tonaŋ lau sêjam lasê ma sêjac dauc kêtaŋ. Gêdêŋ taŋ lau sêŋô dauc kêtaŋ naŋ, sêjam lasê ma tuŋbôm kêku sa, ma lau sêpi malac sêja. Lau samob gacgeŋ sebo sêsa malac sêja ma sêku malac tau tulu. ");
INSERT INTO jae_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Go seseŋ malac samucgeŋ su. Êsêac seseŋ ŋac to awê ma lau matac to lau ŋanô, seseŋ bulimakao to domba ma doŋki. Êsêac seseŋ gêŋ samob su ŋa siŋ ŋamata. ");
INSERT INTO jae_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Ma Josua kêsôm gêdêŋ ŋaclagêc, taŋ sêkêŋ keleŋ gamêŋ naŋ, gebe “Asô awê mockaiŋo nê andu ana ma akôc awê tau to nê lau samob, taŋ sêmoa sêwiŋ eŋ naŋ, sêsa sêmêŋ amboac atôc lemem gêdêŋ eŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Amboac tonaŋ ŋac wakuc luagêc tau, taŋ sêkêŋ keleŋ gamêŋ naŋ, sêsô andu sêja ma sêkôc Rahel to têna agêc tama ma lui to nê lau samob, taŋ sêŋgôŋ sêwiŋ eŋ naŋ, sêsa sêmêŋ. Êsêac sêkôc ênê lau samob ma sêkêŋ êsêac sêŋgôŋ lau Israel nêŋ gamêŋ becoboŋa ŋamagê. ");
INSERT INTO jae_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ma êsêac sêkêc malac to ŋagêŋ samob ja geŋ. Tageŋ silber to gold ma ku, taŋ sêmasaŋ ŋa ki kokoc to jejec naŋ, sêkêŋ jakêsêp kanom, taŋ kêkô Apômtaunê andu naŋ. ");
INSERT INTO jae_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Josua gêjam awê mockaiŋo Rahab to tamanê gôlôac ma nê lau samob, taŋ sêwiŋ eŋ naŋ sa. Eŋ gêŋgôŋ lau Israel ŋalêlôm e mêŋgêdêŋ galoc, gebe eŋ gêsa lau jaeŋ, taŋ Josua kêsakiŋ gebe sêkêŋ keleŋ malac Jeriko naŋ auc. ");
INSERT INTO jae_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Gêdêŋ têm tonaŋ Josua kêjatu lau gebe têtôc lemeŋ sêkô Apômtau laŋônêmŋa ma kêsôm gebe “Aêac tapuc boa ŋac, taŋ êndi mêŋêkwê malac Jeriko tonec sa êtiam naŋ. Eŋ ênac da alê ŋamataŋa ŋa nê ŋacsêga. Ma ênac da malac ŋakatam ŋa nê ŋac sauŋ.” ");
INSERT INTO jae_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Amboac tonaŋ Apômtau gêwiŋ Josua ma ênê wae gêjam gamêŋ samucgeŋ auc. ");
INSERT INTO jae_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Kiŋ Jerusalemŋa Adonisedek gêŋô Josua kêku malac Ai tulu to geseŋ malac tau samucgeŋ su ŋawae. Josua gêgôm malac Ai to ŋakiŋ kêtôm gêgôm gêdêŋ malac Jeriko to ŋakiŋ. Kiŋ tau gêŋô biŋ teŋ gêwiŋ gebe Lau Gibeonŋa sê wama gêdêŋ lau Israel ma sêmoa sêwiŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Eŋ gêŋô biŋ tonaŋ ma kêtêc tau gebe Gibeon malac kapôêŋ kêtôm kiŋnêŋ malac ŋagêdô, ma malac tau kapôêŋ kêlêlêc Ai su ma nêŋ lau samob lau toŋaclai. ");
INSERT INTO jae_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Kêtu tonaŋŋa kiŋ Jerusalemŋa Adonisedek kêsakiŋ biŋ gêdêŋ kiŋ Hebronŋa Hoham to gêdêŋ kiŋ Jarmutŋa Piram ma gêdêŋ kiŋ Lakisŋa Japia to gêdêŋ kiŋ Eglonŋa Debir ma kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Api andêŋ aê amêŋmaŋ ma anam aê sa. Aêac tanac Gibeon gebe êsêac sê wama gêdêŋ Josua to lau Israel.” ");
INSERT INTO jae_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Go lau Amor nêŋ kiŋ lemeŋ teŋ tonec, kiŋ Jerusalemŋa to kiŋ Hebronŋa ma kiŋ Jarmutŋa to kiŋ Lakisŋa ma kiŋ Eglonŋa sêkac nêŋ siŋwaga sa ma êsêac tonêŋ siŋwaganêŋ toŋ samob sêpi jasêgi malac Gibeon auc ma sêjac siŋ gêdêŋ malac tau. ");
INSERT INTO jae_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ma lau Gibeonŋa sêkêŋ biŋ gêdêŋ Josua gêja Gilgal ma sêsôm gebe “Ôŋgamiŋ taôm êndêŋ nêm sakiŋwaga atom. Ôpi ôndêŋ aêac ômôêŋ sebeŋ ma ônam aêac kêsi to ônam aêac sa. Gebe lau Amor nêŋ kiŋ samob, taŋ sêŋgôŋ gamêŋ lôcŋa naŋ, sêkac sa sêmêŋ gebe sênac siŋ êndêŋ aêac.” ");
INSERT INTO jae_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ma Josua gêdi aŋga Gilgal ma kêpi gêja. Siŋwaga to lau toŋaclai samob sêsêlêŋ sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ma Apômtau kêsôm gêdêŋ Josua gebe “Ôtêc êsêac atom, gebe aê kakêŋ êsêac sêsêp aôm lêmam sugac. Êsêacnêŋ ŋac teŋ oc êkô aôm auc atom.” ");
INSERT INTO jae_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Josua gêdi aŋga Gilgal ma kêsêlêŋ gêdêŋ gêbêc samuc tonaŋ ma gêô lasê gêdêŋ êsêac e têtakê. ");
INSERT INTO jae_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Ma Apômtau gêgôm êsêacnêŋ meloco kêsa e sêc lau Israel, taŋ sêjac êsêac ŋanô aŋga Gibeon naŋ su. Lau Israel sêjanda êsêac sêsêp intêna Bet-Horonŋa, ma sêjac êsêac e jadêdêŋ Aseka to Makeda. ");
INSERT INTO jae_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Gêdêŋ taŋ êsêac sêc lau Israel su sêsêp intêna Bet-Horonŋa sêja naŋ, Apômtau tau kêbaliŋ poc kapôêŋ aŋga undambê jakêtuc êsêac e jasêô lasê Aseka, ma êsêac sêmac êndu. Lau taŋ sêmac êndu kêtu kom pocŋa naŋ, taêsam sêlêlêc lau, taŋ lau Israel sêjac ŋa siŋ êndu naŋ su. ");
INSERT INTO jae_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Gêdêŋ bêc, taŋ Apômtau kêkêŋ lau Amor sêsêp lau Israel lemeŋ naŋ, Josua kêkô lau Israel laŋôŋnêm ma kêsôm gêdêŋ Apômtau gebe “Aôm oc, ôkô ŋaŋêŋ aŋga Gibeon ma aôm ajôŋ, aŋga gaboaŋ Aijalon.” ");
INSERT INTO jae_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ma oc kêkô ŋaŋêŋ ma ajôŋ kêkô amboac tonaŋgeŋ e lau sêkac kamocgôc gêbacnê. Biŋ tonaŋ teto gêc Jasarnê buku gebe Oc tau kêkô umboŋ ŋaluŋ ma kêkac tau gebe naêsêp atom, kêkôgeŋ kêtôm bêc samuc teŋ. ");
INSERT INTO jae_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Bêc teŋ kêtôm tonaŋ gêc gêmuŋ atom ma gêc atom e mêŋgêdêŋ galoc. Gêdêŋ bêc tonaŋ Apômtau kêkêŋ taŋa ŋac teŋ awa ŋam gebe Apômtau gêjac siŋ gêjô Israel. ");
INSERT INTO jae_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Go Josua ma lau Israel samob sêc sêmu sêja nêŋ gamêŋ Gilgal kêtiam. ");
INSERT INTO jae_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Go Josua kêkac lau Israel nêŋ gôlôacmôkê samob sa aŋga Sikem. Eŋ kêkalem lau Israel nêŋ lau ŋanô to laumata ma nêŋ gôliŋwaga to kasêga samob sa jasêkô Anôtô laŋônêm. ");
INSERT INTO jae_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Go Josua kêsôm gêdêŋ lau samob gebe “Apômtau, lau Israel nêŋ Anôtô, kêsôm biŋ tonec gebe ‘Gêdêŋ andaŋgeŋ amac tamemi Abraham agêc Nahor tameŋi Tara sêŋgôŋ bu Euprat ŋamakeŋ ônêŋa, ma sêjam sakiŋ gêdêŋ anôtôi jaba. ");
INSERT INTO jae_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Go aê kakôc amac tamemi Abraham su aŋga bu ŋamakeŋ ônêŋa ma gawê eŋ kêsêlêŋ kêtôm gamêŋ Kanaanŋa samob. Aê kakêŋ ênê wakuc têtu taêsam. Aê kakêŋ Isak gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Ma kakêŋ Jakob agêc Esau gêdêŋ Isak. Aê kakêŋ gamêŋ lôcŋa Seir gêdêŋ Esau gêwê kaiŋ, mago Jakob to nê latui sêsêp Aiguptu sêja. ");
INSERT INTO jae_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Go kasakiŋ Mose agêc Aron ma kakôniŋ Aiguptu ŋa gêŋwapac, taŋ gagôm aŋga gamêŋ tau naŋ. Su, go gawê amac asa amêŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Aê gawê amac tamemi sêsa aŋga Aiguptu sêmêŋ e aô lasê gwêc. Ma lau Aiguptu sêjanda amac tamemi ŋa kareta to hos e jadêdêŋ Gwêckoc. ");
INSERT INTO jae_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Ma êsêac aweŋ gêjac Apômtau ma eŋ kêkêŋ gêsuŋbôm geŋ amac to lau Aiguptu kêsi to gêgôm gwêc kêmakop e kêsalê êsêac auc. Amac matemanô alic gêŋ, taŋ aê gagôm gêdêŋ Aiguptu naŋ su. Amac amoa gamêŋ sawa ŋasawa baliŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Go aê gawê amac aô lasê lau Amor, taŋ sêŋgôŋ Jordan ŋamakeŋ ônêŋa naŋ, nêŋ gamêŋ. Gêdêŋ taŋ kakêŋ êsêac sêsêp amac lemem ma amac akôc êsêacnêŋ gamêŋ su naŋ, aê gaseŋ êsêac gamuŋ amac. ");
INSERT INTO jae_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Go kiŋ Moabŋa Sipor latu Balak gêdi ma gêjac siŋ gêdêŋ Israel. Eŋ kêsakiŋ biŋ gêdêŋ Beor latu Bileam gebe êmêŋ ma êpuc boa amac. ");
INSERT INTO jae_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Mago aê kakêŋ taŋoc Bileam atom, tec eŋ gêjam mec amac. Gagôm amboac tonaŋ, tec gajam amac kêsi aŋga Balak lêma. ");
INSERT INTO jae_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Go amac alom bu Jordan e aô lasê malac Jeriko. Ma lau Jerikoŋa sêjac siŋ gêdêŋ amac. Mago lau Jeriko tauŋgeŋ atom, lau Amor to Peres ma Kanaan to Het ma Girgas to Hiw ma Jebus amboac tonaŋgeŋ. Mago aê kakêŋ êsêac sêsêp amac lemem. ");
INSERT INTO jae_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Aê kasakiŋ banic gêmuŋ ma kêjanda lau Amor nêŋ kiŋ luagêc gêmuŋ amac. Amacnêm siŋ to talam gêgôm atom. ");
INSERT INTO jae_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Aê kakêŋ gamêŋ teŋ, taŋ ajam kôm kêpi atom naŋ, gêdêŋ amac ma kakêŋ malac, taŋ amac akwê sa atom naŋ, gêdêŋ amac aŋgôŋ. Amac aeŋ kôm wainŋa to katêkwi, taŋ asê atomanô naŋ ŋanô.’ ");
INSERT INTO jae_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Amboac tonaŋ galoc atêc Apômtau to anam sakiŋ eŋ têmtac makeŋ ma tonêm ŋalêlôm ŋaŋêŋgeŋ. Atiŋ anôtôi jaba, taŋ tamemi sêjam sakiŋ aŋga bu ŋamakeŋ ônêŋa to aŋga Aiguptu naŋ su, ma anam sakiŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Mago amac embe andec gebe anam sakiŋ Apômtau, go ocsalô tonec ajaliŋ anôtôi, taŋ abe anam sakiŋ naŋ sa. Abe anam sakiŋ anôtôi, taŋ tamemi sêjam sakiŋ aŋga bu ŋamakeŋ ônêŋa naŋ, me lau Amor, tec aŋgôŋ êsêacnêŋ gamêŋ nec, nêŋ anôtôi me. Mago aê to ŋoc gôlôac abe anam sakiŋ Apômtaugeŋ.” ");
INSERT INTO jae_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Go lau tau sêjô eŋ awa gebe “Biŋ tonec gebe awi Apômtau siŋ ma anam sakiŋ anôtôi jaba nec ênac jaê aêac, ");
INSERT INTO jae_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","gebe Apômtau, aêacnêŋ Anôtô, gêwê aêac to tameŋi tapi aŋga Aiguptu tamêŋ ma gêwê aêac dawi andu kapoacwalôŋa siŋ. Eŋ gêgôm gêŋsêga kaiŋ teŋ aêac talic ma gejob aêac aŋga intêna samob, taŋ tasa naŋ, ma gejob aêac gêdêŋ taŋ tasêlêŋ tasêp lau tomôkê-tomôkê ŋalêlôm naŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Ma Apômtau kêjanda lau tomôkê-tomôkê gêmuŋ aêac, eŋ kêjanda lau Amor, taŋ sêŋgôŋ gamêŋ tonec naŋ, amboac tonaŋgeŋ. Kêtu tonaŋŋa aêac abe anam sakiŋ Apômtau amboac tonaŋgeŋ, gebe eŋ kêtu aêacnêŋ Anôtô.” ");
INSERT INTO jae_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Mago Josua kêsôm gêdêŋ lau tau gebe “Amac atôm gebe anam sakiŋ Apômtau atom, gebe eŋ Anôtô dabuŋ. Eŋ gêjam lêmuŋ lau gebe têntac êwiŋ eŋ taugeŋ. Eŋ oc êsuc amacnêm biŋ agêli biŋsuŋa to nêm sec ôkwi atom. ");
INSERT INTO jae_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Eŋ kêmoasiŋ amac su, mago amac embe awi eŋ siŋ ma anam sakiŋ anôtôi jaba, go ênam dêmôê amac ma êŋgôm amac sec to enseŋ amac su.” ");
INSERT INTO jae_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ma lau sêsôm gêdêŋ Josua gebe “Masi, aêac abe anam sakiŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Ma Josua kêsôm gêdêŋ lau gebe “Amac taôm awa taôm sa gebe ajaliŋ Apômtau sa gebe anam sakiŋ eŋ.” Ma êsêac sêsôm gebe “Aêac awa tauŋ sa sugac.” ");
INSERT INTO jae_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Eŋ kêsôm gebe “Amboac tonaŋ, go atiŋ anôtôi jaba, taŋ sêc amac ŋalêlôm naŋ su, ma akêŋ nêm ŋalêlôm êndêŋ Apômtau, Israelnêŋ Anôtô.” ");
INSERT INTO jae_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ma lau sêsôm gêdêŋ Josua gebe “Aêac anam sakiŋ Apômtau, aêacnêŋ Anôtô, to taŋeŋ wamu ênê awa.” ");
INSERT INTO jae_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Tec gêdêŋ bêc tonaŋ Josua kêmoatiŋ poac gêwiŋ’ lau ma kêmasaŋ biŋsu to ŋagôliŋ kêtu êsêacŋa aŋga Sikem. ");
INSERT INTO jae_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Ma Josua keto biŋ tonaŋ kêsêp Anôtônê biŋsu ŋabuku. Ma eŋ kêkôc poc kapôêŋ teŋ jagêjac sa aŋga kamem, taŋ kêkô Apômtaunê gamêŋ dabuŋ naŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Ma Josua kêsôm gêdêŋ lau samob gebe “Alic acgom, poc tonec êtu ŋabelo êwa aêac saŋa, gebe gêŋô Apômtaunê biŋ samob, taŋ eŋ kêsôm gêdêŋ aêac naŋ gêwiŋ. Kêtu tonaŋŋa amac embe ansa nêm Anôtô auc, go poc tau êtu ŋabelo êwa amac saŋa.” ");
INSERT INTO jae_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Go Josua kêsakiŋ lau sêc sêja nêŋ nomlênsêm gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Biŋ tonaŋ gêbacnê, go Apômtau nê sakiŋwaga Nun latu Josua gêmac êndu. Ênê jala kêtu 110. ");
INSERT INTO jae_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ma êsêac sêsuŋ eŋ aŋga tau nê nomlênsêm ŋamalac Timnat-Serat, taŋ gêc lôc Gas ŋagamêŋ gêmu kêpiŋa aŋga Epraim ŋagamêŋ lôcŋa. ");
INSERT INTO jae_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Ma lau Israel sêjam sakiŋ Apômtau gêdêŋ bêc Josua gêmoa mata jaliŋa samob. Eŋ gêmac êndu su ma laumata ŋagêdô, taŋ sêlic kôm, taŋ Anôtô gêjam kêpi lau Israel naŋ, gacgeŋ sêmoa. Tec lau Israel sêjam sakiŋ Apômtau gêdêŋ laumata tonaŋ nêŋ bêc sêmoa mateŋ jaliŋa samob amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Josepnê ŋatêkwa, taŋ lau Israel sêkôc aŋga Aiguptu sêmêŋ naŋ, sêsuŋ aŋga Sikem kêsêp nom, taŋ Jakob gêjam ôli ŋa mone silber 100 gêdêŋ Sikem tama Hamor latui naŋ, ŋasawa teŋ. Gamêŋ tau kêtu Josepnê wakuc nêŋ nomlênsêm teŋ. ");
INSERT INTO jae_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ma Aron latu Eleasar gêmac êndu ma sêsuŋ eŋ aŋga latu Pinehas nê malac Gibea. Êsêac sêkêŋ malac, taŋ gêc Epraim ŋagamêŋ lôcŋa naŋ, gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Apômtaunê aŋela gêwi Gilgal siŋ gêja Bokim ma kêsôm gêdêŋ lau Israel gebe “Aê kakôc amac aŋga Aiguptu ma gawê amac mêŋaô lasê gamêŋ, taŋ katôc lemoc gebe jakêŋ êndêŋ tamemi naŋ. Aê kasôm gebe ‘Aê janac poac, taŋ kamoatiŋ gêdêŋ amac naŋ, popoc atomanô. ");
INSERT INTO jae_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Ma amac amoatiŋ poac teŋ êndêŋ lau, taŋ sêŋgôŋ gamêŋ tonec naŋ atom. Atuc êsêacnêŋ altar popoc.’ Mago amac taŋem wamu aêŋoc jatu tonaŋ atom. Amac agôm asageŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Amboac tonaŋ aê jasôm êndêŋ amac gebe Aê jajanda lau tomôkê-tomôkê jamuŋ amac atom. Êsêac oc têtu nêm ŋacjo ma nêŋ anôtôi jaba têtu amacnêm lakô.” ");
INSERT INTO jae_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Apômtaunê aŋela kêsôm biŋ tonaŋ gêdêŋ lau Israel samob su, go lau tau sêpuc taŋiboa sa ma têtaŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Ma sê gamêŋ tonaŋ ŋaê gebe Bokim ma sêkêŋ da gêdêŋ Apômtau aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Josua kêlêwaŋ lau Israel sêmu dêdêŋ nêŋ nomlênsêm gêdêŋ-gêdêŋgeŋ sêja, gebe sêŋgôŋ têtu wakac. ");
INSERT INTO jae_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Ma lau Israel sêjam sakiŋ Apômtau kêtôm têm Josua gêmoa nomŋa. Josua gêmac êndu su, go êsêac sêjam sakiŋ Apômtau sêmoa kêtôm têm, taŋ laumata, taŋ sêjala gêŋ samob, taŋ Apômtau gêgôm gêdêŋ lau Israel naŋ, sêmoa mateŋ jali naŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Ma Nun latu Josua, taŋ Apômtaunê sakiŋwaga naŋ, nê jala kêtu 110 ma gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Êsêac sêsuŋ eŋ aŋga tau nê nomlênsêm ŋamalac Tinat-Heres, taŋ gêc lôc Gas ŋagamêŋ gêmu kêpiŋa aŋga Epraim ŋagamêŋ lôcŋa. ");
INSERT INTO jae_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Lau taŋ sêmoa sêwiŋ Josua naŋ, sêmac êndu amboac tonaŋ, ma lau wakuc mêŋsêsa, naŋ êsêac sêjam kauc Apômtau to nê kôm, taŋ gêjam kêtu lau Israelŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Go lau Israel sêgôm gêŋ, taŋ Apômtau gêlic sec naŋ, gebe sêjam sakiŋ Bal. ");
INSERT INTO jae_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Êsêac sêwi Apômtau, tameŋinêŋ Anôtô, taŋ kêkôc êsêac su aŋga Aiguptu naŋ, siŋ ma sêsap lau, taŋ sêgi êsêac auc naŋ, nêŋ anôtôi jaba tôŋ. Êsêac sêpôŋ eŋduc gêdêŋ anôtôi tonaŋ ma sêgôm Apômtau têtac ŋandaŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Êsêac sêwi Apômtau siŋ ma sêjam sakiŋ Bal agêc Astarte. ");
INSERT INTO jae_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Apômtau têtac ŋandaŋ ŋanô gêdêŋ lau Israel, tec kêkêŋ êsêac sêsêp kêjaŋgowaga lemeŋ, gebe sêjaŋgo êsêacnêŋ gêŋ su. Eŋ kêkêŋ nêŋ ŋacjo, taŋ sêgi êsêac auc naŋ, gebe sêkôniŋ êsêac e lau Israel têtôm gebe sênam tauŋ sa êtiam atom. ");
INSERT INTO jae_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Kêtôm têm samob, taŋ êsêac dêdi sebe sênac siŋ naŋ, Apômtau gêjam dêmôê êsêac kêtôm eŋ kêsôm ma kêtôc lêma gebe êŋgôm naŋ. Ma êsêac sêpô lêna tauŋ ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Go Apômtau kêkêŋ gôliŋwaga, taŋ sêjam lau Israel sa aŋga kêjaŋgowaga lemeŋ. ");
INSERT INTO jae_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Mago êsêac sêkêŋ taŋeŋ nêŋ gôliŋwaga atom. Êsêac sêkêŋ tauŋ dêdêŋ anôtôi jaba to sêpôŋ aeŋduc gêdêŋ êsêac. Êsêac tameŋi taŋeŋ wamu Apômtaunê biŋsu, mago êsêac tauŋ sêwi tameŋinêŋ lêŋ tonaŋ siŋ sebeŋ ma sêsa kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Kêtôm têm samob, taŋ Apômtau kêkêŋ gôliŋwaga gêdêŋ êsêac naŋ, eŋ gêmoa gêwiŋ gôliŋwaga tau ma eŋ gêjam lau tau sa aŋga nêŋ ŋacjo lemeŋ kêtôm têm samob, taŋ gôliŋwaga gêmoa gêwiŋ êsêac naŋ. Apômtau taê walô êsêac kêtu nêŋ taŋiboa, taŋ têtaŋ kêtu nêŋ ŋacjo sêlêsu to sêkôniŋ êsêac naŋŋa. ");
INSERT INTO jae_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Mago gêdêŋ taŋ gôliŋwaga gêmac êndu naŋ, lau sêmu sêja nêŋ intêna laŋgwa kêtiam e sêgôm sec kêlêlêc lau gêmuŋŋa su. Êsêac têdaguc anôtôi jaba ma sêjam sakiŋ êsêac to sêpôŋ aeŋduc gêdêŋ êsêac ma sêwi nêŋ lêŋ tonaŋ siŋ atom, sêsa togêsuŋtêkwa ŋatoŋgeŋ sêmoa. ");
INSERT INTO jae_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Apômtau têtac ŋandaŋ sec gêdêŋ lau Israel ma kêsôm gebe “Lau tonec seseŋ poac, taŋ kajatu gêdêŋ êsêac tameŋi gebe sêsap tôŋ naŋ, su ma taŋeŋ wamu aê atom, ");
INSERT INTO jae_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","tec aê jajanda lau tomôkê-tomôkê, taŋ Josua kêku tulu atom ma gêmac êndu naŋ, nêŋ teŋ êtiam atom. ");
INSERT INTO jae_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Aê jaŋgôm gêŋ tonec gebe jansaê lau Israel e jajala êsêac sêsa ŋoc lêŋ têtôm tameŋi sêsa nêŋ me masi.” ");
INSERT INTO jae_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Amboac tonaŋ Apômtau gêlôc gebe lau tomôkê-tomôkê, taŋ sêsô Josua lêma ŋalabu atom naŋ, sêŋgôŋgeŋ. Eŋ kêjanda êsêac sebeŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Gôliŋwaga Ehud gêmac êndu su, go lau Israel sêgôm gêŋ, taŋ Apômtau gêlic sec naŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Amboac tonaŋ Apômtau kêkêŋ êsêac sêsêp Jabin lêma. Eŋ lau Kanaan nêŋ kiŋ, taŋ gêjam gôliŋ êsêac gêŋgôŋ malac Hasor naŋ. Ênê siŋwaganêŋ laumata Sisera, taŋ gêŋgôŋ lau samuc nêŋ malac Haroset. ");
INSERT INTO jae_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Jabinnê kareta ki 900 ma eŋ gejoŋ lau Israel secanô kêtôm jala 20. Tec lau Israel aweŋ gêjac Apômtau gebe ênam êsêac sa. ");
INSERT INTO jae_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Lapidotnê awê Debora eŋ propeteo teŋ kêtu lau Israel nêŋ gôliŋwagao gêdêŋ ŋasawa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Eŋ gêŋgôŋ nê nip, taŋ kêkô Rama to Betel ŋasawa aŋga gamêŋ lôcŋa Epraim naŋ, ŋalabu ma lau Israel sêja tônê gebe eŋ êmêtôc êsêacnêŋ biŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Debora kêsakiŋ biŋ gêdêŋ Abinoam latu Barak aŋga Naptalinê gamêŋ ŋamalac Kedes gebe êmêŋ ma kêsôm gêdêŋ eŋ gebe “Apômtau, lau Israel nêŋ Anôtô, kêjatu aôm gebe ‘Ôna ma ôwê nêm lau sêpi lôc Tabor sêna. Ôkôc lau 10,000 aŋga Naptali agêc Sebulon nêŋ gôlôac. ");
INSERT INTO jae_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Aê gabe jalêtôm Jabinnê siŋwaganêŋ laumata Sisera gebe ênac siŋ êndêŋ aôm aŋga bu Kison. Eŋ êmêŋ tonê kareta ki ma nê siŋwaga, mago aê gabe jakêŋ eŋ êsêp aôm lêmam.’” ");
INSERT INTO jae_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Barak kêsôm gêdêŋ Debora gebe “Aôm embe ôwiŋ aê, go jana, mago aôm embe ôwiŋ aê atom, oc jana atom amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Debora gêjô eŋ awa gebe “Amboac tonaŋ aê jawiŋ aôm, mago intêna, taŋ aôm ôsa naŋ, êwaka aôm waem sa atom, gebe Apômtau êkêŋ Sisera êsêp awê teŋ lêma.” Go Debora gêdi jagêwiŋ Barak sêja Kedes. ");
INSERT INTO jae_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Barak kêkalem Sebulon agêc Naptali nêŋ gôlôac sêpi tageŋ aŋga Kedes, go lau 10,000 têdaguc eŋ, ma Debora jagêwiŋ eŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Kennê wakuc teŋ, Heber, kêkac tau su aŋga lau Ken nêŋ ma gê nê becobo kêkô kamem Sananimŋa, taŋ kêkô Kedes ŋagala naŋ ŋalabu. Lau Ken tonaŋ Mosenê lawa Hobab nê’ wakuc. ");
INSERT INTO jae_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Êsêac sêsôm ŋawae gêdêŋ Sisera gebe Abinoam latu Barak kêpi lôc Tabor gêja. ");
INSERT INTO jae_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Tec Sisera kêkalem nê kareta ki 900 to nê lau samob ma kêjatu êsêac gebe sêwi lau samuc nêŋ malac Haroset siŋ sêna bu Kison. ");
INSERT INTO jae_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Go Debora kêsôm gêdêŋ Barak gebe “Ajôc, ôndi gebe bêc tonec Apômtau êkêŋ Sisera êsêp aôm lêmam. Apômtau êwê aôm.” Tec Barak gêdi aŋga Tabor kêsêp gêja ma nê lau 10,000 têdaguc eŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Gêdêŋ taŋ Barak tonê siŋwaga sêô lasê naŋ, Apômtau kêlênsôŋ Sisera to nê kareta samob ma nê lau. Sisera gêboaŋ kêsêp aŋga nê kareta e gacgeŋ gêc su gêja. ");
INSERT INTO jae_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Barak kêjanda kareta to siŋwaga e jagêdêŋ lau samuc nêŋ malac Haroset ma siŋ geseŋ siŋwaga samob su, ŋac teŋ gêwê sa atom. ");
INSERT INTO jae_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Sisera kêlêti gêja Kennê wakuc Heber nê awê Jael nê becobo, gebe kiŋ Hasorŋa Jabin to Hebernê gôlôac sêmoa sêwiŋ tauŋ towamageŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Jael kêsa gêja gebe êpuc Sisera tôŋtôŋ ma kêsôm gêdêŋ eŋ gebe “O apômtau, ôsô ômôêŋ, ôsô ŋoc becobo ômôêŋmaŋ. Ôtêc taôm atom.” Amboac tonaŋ eŋ kêsô gêja ma awê tau kêgaduc eŋ ŋa belaŋke. ");
INSERT INTO jae_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Ma ŋac tau kêsôm gêdêŋ awê gebe “Aê jateŋ aôm gebe ôkêŋ bu ŋagec êndêŋ aê janôm gebe bu gêjô aê.” Awê tau kêkac bulakôp bôcôlic, taŋ su kêpoac ŋalêlôm naŋ, ŋasuŋ su jakêkêŋ su gêdêŋ eŋ gênôm ma kêgaduc eŋ auc kêtiam. ");
INSERT INTO jae_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Go ŋac tau kêsôm gêdêŋ eŋ gebe “Ôkô becobo ŋasacgêdô ma ŋac teŋ embe êô lasê ma êtu kênac aôm gebe ‘Ŋac teŋ gêmoa tonec me masi’, go ôsôm gebe ‘Masi.’” ");
INSERT INTO jae_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Sisera têkwa gêbac ŋanô, tec gêc bêc e kêliŋ tau siŋ gêc. Ma Hebernê awê Jael kêkôc hama to biakim becoboŋa teŋ ma kêsô kelecgeŋ gêdêŋ eŋ gêja ma gêjac biakim tau kêsêp Siseranê mom palalap e jagêjam nom ma gêmac êndu tomatêgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Gêdêŋ tonaŋ Barak gêô lasê. Eŋ gesom Sisera. Ma Jael kêpuc eŋ tôŋtôŋ jakêsôm gêdêŋ eŋ gebe “Ômôêŋ tonec, aê gabe jatôc ŋac, taŋ aôm gosom eŋ naŋ, êndêŋ aôm.” Amboac tonaŋ Barak kêsô becobo gêwiŋ eŋ ma gêlic Sisera tomatêgeŋ gêc ma biakim kêkô nê mom. ");
INSERT INTO jae_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Gêdêŋ bêc tonaŋ Anôtô kêku lau Kanaan nêŋ kiŋ Jabin tulu gêjô lau Israel su. ");
INSERT INTO jae_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Ma lau Israel sêkôniŋ lau Kanaan nêŋ kiŋ Jabin ŋajaŋa sec e seseŋ eŋ su samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Gêdêŋ bêc tonaŋ Debora agêc Abinoam latu Barak sêjam wê tonec gebe ");
INSERT INTO jae_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“Alambiŋ Apômtau, gebe lau Israel sêmasaŋ biŋ kêtu tôŋ gebe sênac siŋ, ma lau sêlôc sa tonaŋ ŋalêlômgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","Amac kiŋac, aŋô biŋ tau, amac kasêgaac, akêŋ taŋem. Aê janam wê to janac gêŋ wêŋa êndêŋ Apômtau, lau Israel nêŋ Anôtô. ");
INSERT INTO jae_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","O Apômtau, gêdêŋ taŋ kôsêp aŋga Seir ŋalôc gômôêŋ, ma gêdêŋ taŋ kôsa aŋga gamêŋ Edomŋa gômôêŋ naŋ, nom kêtênêp ma undambê kêsêwa, biŋŋanô, bu kêsêwa aŋga tao gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Lôc kêtênêp kakô Sinai ŋaApômtau laŋônêmŋa, kêkô Apômtau, lau Israel nêŋ Anôtô, laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","“Gêdêŋ Anat latu Samgar nê têm gêdêŋ Jaelnê têm, lau sêwê sêmoa intênasêga kêtiam atom, ma lau, taŋ sêsêlêŋ naŋ, sêjac jaê intênasêga. ");
INSERT INTO jae_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","O Debora, lau Israel nêŋ malac kêtu gasaŋ e mêŋgêdêŋ aôm gôdi. Aôm gôdi amboac lau Israel teneŋi. ");
INSERT INTO jae_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Anôtônê siŋwaga aweŋmê kêsa ma siŋ jakêpi gamêŋ. Lau 40,000, taŋ sêmoa Israel naŋ, nêŋ teŋ gêjac lautuc ma gêôc kêm atom. ");
INSERT INTO jae_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Ŋoc ŋalêlôm gêwiŋ lau Israel nêŋ laumata, gêwiŋ lau, taŋ sêlôc sa tonêŋ ŋalêlômgeŋ. Alambiŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","“Amac laumata, taŋ api doŋki kwalam-kwalam ma aŋgôŋ ŋabelaŋke ŋaô, ma amac siŋwaga, taŋ asêlêŋgeŋ amoa intêna naŋ, anac miŋ biŋ tau. ");
INSERT INTO jae_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","Aŋô acgom, lau taŋ sêjam biŋgalôm sêmoa bumata naŋ, sêsôm Apômtau kêku nê ŋacjo tulu ŋawae, sêsôm lau Israel sêku nêŋ ŋacjo tulu ŋawae. Go Apômtaunê lau sêwê sêsêp aŋga nêŋ malac sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","“O Debora, ajôc, ajôc. Ajôc, ôpuc wê teŋ samaŋ. O Barak, ôndimaŋ, o Abinoam latu, ôwê lau kapoacwalôŋa ma aêc ana. ");
INSERT INTO jae_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","Go lau ŋaŋêŋ sêsêp dêdêŋ nêŋ laumata sêja, Apômtaunê lau dêdêŋ eŋ sêja sebe sênac siŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Êsêac sêsêp gaboaŋ sêmêŋ aŋga Epraim têdaguc Benjaminnê gôlôac to nêŋ lau. Kasêga sêsêp aŋga Makir sêmêŋ to laumata sêmêŋ aŋga Sebulon. ");
INSERT INTO jae_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Isakarnê gôlôac nêŋ laumata sêwiŋ Debora sêmêŋ, biŋŋanô, Isakarnê gôlôac sêwiŋ Barak sêmêŋ. Êsêac têdaguc eŋ sêsêp gaboaŋ sêja. Tageŋ Rubennê gôlôac sêwa tauŋ kêkôc, êsêac têtôm gebe sêsôm biŋ katô tauŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","Kêtu asageŋŋa êsêac sêmoa sêwiŋ nêŋ domba ŋatoŋgeŋ. Sêmoa gebe sêŋô laugejob têtêlam nêŋ domba ŋatoŋ me. Biŋŋanô, Rubennê gôlôac sêwa tauŋ kêkôc, êsêac têtôm gebe sêsôm biŋ katô tauŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Gadnê gôlôac sêmoa Jordan ŋamakeŋ oc kêpiŋa, ma kêtu asageŋŋa Dannê gôlôac sêjam kôm waŋŋa. Asernê gôlôac sêŋgôŋ gwêctali, sêŋgôŋ nêŋ sêcluŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Mago lau Sebulon to Naptali sêjac kapoac tauŋ totaêŋ kêpa tauŋ sugeŋ sêmoa siŋ mala. ");
INSERT INTO jae_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","“Kiŋ sêmêŋ ma sêjac siŋ aŋga Tanak, taŋ gêc bu Megidoŋa naŋ. Lau Kanaan nêŋ kiŋ sêjac siŋ, mago sêjaŋgo silber teŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Utitalata undambêŋa sêjac siŋ. Êsêac sêsa nêŋ lêŋ ma sêjac siŋ gêdêŋ Sisera. ");
INSERT INTO jae_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Bu Kison gêc ŋasamac kapôêŋ e gêc êsêac su. Bu Kison gêc, gêc ŋasamac kapôêŋ. O katuc tau, ajôc, ôndi toŋaclaigeŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Go hos eŋkaiŋ kêka nom ma sêboaŋ-sêboaŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","“Apômtaunê aŋela kêsôm gebe ‘Apuc boa malac Meros, apuc boa êsêac, taŋ sêŋgôŋ malac tau naŋ ŋanôgeŋ, gebe êsêac sêmêŋ kêtu sênam Apômtau saŋa atom, ma sêmêŋ gebe sêwiŋ Apômtaunê siŋwaga atom.’ ");
INSERT INTO jae_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","“Anôtô ênam mec Kennê wakuc Hebernê awê Jael, ênam mec eŋ êlêlêc lauo samob, taŋ sêŋgôŋ becobo naŋ su. ");
INSERT INTO jae_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Sisera keteŋ bu, mago eŋ kêkêŋ su gêdêŋ eŋ, kêkêŋ su ŋakana kêsêp laclu ŋajamanô teŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Awê tau kêmêgôm biakim kêsêp lêma ŋamakeŋ ma kêmêgôm kamundanê hama kêsêp lêma anôŋa. Eŋ gêjac Sisera e gêjac môkêapac popoc. Eŋ gêguŋ ênê mom palalap ma gêjac popoc. ");
INSERT INTO jae_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Sisera gebeŋ e gêu tau gêc awê tau akaiŋŋa. Eŋ gêu tau jagêc awê tau akaiŋŋa. Eŋ gebeŋ kêsêp nom tomatêgeŋ jagêc. ");
INSERT INTO jae_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","“Sisera têna gewec kêsa katam sauŋ, eŋ gêjam tuc kêsa lala. ‘Kêtu asageŋŋa ênê kareta gêmêŋ sebeŋ atom nec. Kêtu asageŋŋa ênê hos sêsêlêŋ malô-malô sec’. ");
INSERT INTO jae_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Sisera têna nê sakiŋwagao tokauc kêlêlêc gêjô eŋ awa, ma eŋ tau kêsôm biŋ tonec ŋakôniŋŋa ŋapaŋ gebe ");
INSERT INTO jae_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘Êsêac oc têtap awa sa ma sêjac sam gêdêŋ tauŋ sêmoa. Sêjac sam ŋapalêo tageŋ me luagêc gêdêŋ siŋwaga gêdêŋ-gêdêŋgeŋ. Sisera tau oc kêtap ŋakwê ŋajam sa ma obo, taŋ sêsi ŋa gam talô-talô naŋ, gebe êkêŋ êndêŋ ŋatauo ênôŋ’. ");
INSERT INTO jae_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","“O Apômtau, aômnêm ŋacjo samob sênaŋamaŋ, mago nêm lau têtôm oc kêpi toŋaclai.” Amboac tonaŋ wama gêjam gamêŋ auc kêtôm jala 40. ");
INSERT INTO jae_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Lau Israel sêgôm gêŋ, taŋ Apômtau gêlic sec naŋ, tec Apômtau kêkêŋ êsêac sêsêp lau Midian lemeŋ kêtôm jala 7. ");
INSERT INTO jae_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Lau Midian lemeŋ kêkôniŋ lau Israel, tec lau Israel sêsiŋ tauŋ kêtu êsêacŋa sêŋgôŋ pocgêsuŋ to poclabu aŋga gamêŋ lôcŋa. ");
INSERT INTO jae_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Kêtôm têm lau Israel sêsê gêŋŋa samob lau Midian ma lau Amalek to lau gamêŋ sawaŋa sêô lasê sebe sênac êsêac. ");
INSERT INTO jae_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Êsêac sê nêŋ-becobo kêsêp Israelnêŋ gamêŋ ma seseŋ êsêacnêŋ kôm samob su e jagêdêŋ gamêŋ ŋalabuŋa kêkanôŋ malac Gasa. Êsêac sêwi gêŋ taniŋŋa teŋ siŋ kêtu lau Israel sêniŋŋa atom, sêkôc domba to bulimakao ma doŋki samob. ");
INSERT INTO jae_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Êsêac sêô lasê tonêŋ bulimakao ma nêŋ becobogeŋ sêwê têtôm lêsêc. Lau teŋ sêsa êsêac to nêŋ kamele sa têtôm atom. Êsêac sêô lasê ma seseŋ gamêŋ tau ŋagêŋ samob su. ");
INSERT INTO jae_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Tec lau Israel sêpô lêna tauŋ ŋanô kêtu êsêacŋa ma lau Israel aweŋ gêjac Apômtau gebe ênam êsêac sa. ");
INSERT INTO jae_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Gêdêŋ taŋ lau Israel aweŋ gêjac Apômtau kêtu lau Midianŋa naŋ, ");
INSERT INTO jae_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Apômtau kêsakiŋ propete teŋ gêdêŋ êsêac ma kêsôm gêdêŋ êsêac gebe “Apômtau, lau Israel nêŋ Anôtô, kêsôm biŋ tonec gebe Aê kakôc amac asa aŋga Aiguptu amêŋ to gawê amac awi andu gêŋômaŋa siŋ. ");
INSERT INTO jae_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Aê gajam amac sa aŋga lau Aiguptu lemeŋ to aŋga lau samob, taŋ sêkôniŋ amac naŋ, lemeŋ amboac tonaŋgeŋ ma kajanda êsêac gamuŋ amac ma kakêŋ lau tau nêŋ gamêŋ gêdêŋ amac. ");
INSERT INTO jae_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Aê kasôm gêdêŋ amac gebe ‘Aê Apômtau, amacnêm Anôtô. Amac aŋgôŋ lau Amor nêŋ gamêŋ, mago anam sakiŋ lau Amor nêŋ anôtôi jaba atom.’ Mago amac akêŋ taŋem ŋoc biŋ atom.” ");
INSERT INTO jae_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Go Apômtaunê aŋela mêŋgêô lasê ma gêŋgôŋ kamem, taŋ kêkô malac Opar ŋagala naŋ ŋalabu. Joas aŋga Abiesernê gôlôac kêtu ka tau ŋatau. Joas latu Gideon kêka polom kelecgeŋ gêmoa sêka wain ŋamala, gebe êsiŋ polom ôkwi kêtu lau Midianŋa. ");
INSERT INTO jae_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Ma Apômtaunê aŋela gêô lasê gêdêŋ eŋ ma kêsôm gêdêŋ eŋ gebe “O siŋsêlêc, Apômtau gêwiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ma Gideon kêsôm gêdêŋ eŋ gebe “O ŋatau, Apômtau embe êwiŋ aêac, go gêŋwapac samob êtap aêac sa êtu asageŋŋa. Ma gêŋsêga samob, taŋ tameŋi sêjac miŋ gêdêŋ aêac naŋ ma sêsôm gebe ‘Apômtau kêkôc aêac asa aŋga Aiguptu amêŋ atom me, gêŋsêga tonaŋ ŋanô ondoc.’ Galoc Apômtau kêtiŋ aêac su to kêkêŋ aêac asêp Midian lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Go Apômtau kêjatu eŋ gebe “Aê tauc jasakiŋ aôm ôna tonêm ŋajaŋa, taŋ gêc aômŋa naŋ, gebe ônam lau Israel sa aŋga lau Midian lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Gideon gêjô eŋ awa gebe “O Apômtau, aê oc janam lau Israel sa amboac ondoc. Ôlic acgom, aêŋoc lau têtu Manasenê gôlôacnêŋ lau ômbôêŋ-ômbôêŋ ma aê tauc katu ŋoc launêŋ ŋac ŋamuŋa tau.” ");
INSERT INTO jae_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ma Apômtau kêsôm gêdêŋ eŋ gebe “Aôm kôtôm gebe ôŋgôm gêŋ tau gebe aê oc janam aôm sa. Aôm oc ôku lau Midian tulu amboac kôku ŋac tageŋ tulu.” ");
INSERT INTO jae_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Gideon gêjô eŋ awa gebe “Aê embe janac aôm matamanô ŋajam, naŋgo ôwaka taôm sa ŋa gêŋtalô teŋ, gebe aôm taôm tec kôsôm biŋ gêdêŋ aê. ");
INSERT INTO jae_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Aê jateŋ aôm gebe ôwi gamêŋ tonec siŋ atom e jamu jandêŋ aôm jamêŋ êtiam acgom. Aê gabe jakêŋ moasiŋ teŋ êtu da êndêŋ aôm.” Ma eŋ kêsôm gebe “Aê oc jamoa e ômu ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Amboac tonaŋ Gideon kêsô nê andu gêja ma geno noniŋ ŋalatu teŋ ma kêkôc polom matac laclu kapôêŋ teŋ gebe êpac polom, mago kêkêŋ jist kêsêp atom. Eŋ kêkêŋ gwada kêsêp gadob ma sulu kêsêp ku, kêkôc gêŋ tau gêdêŋ Apômtaunê aŋela gêja kamem ŋalabu. ");
INSERT INTO jae_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Go Apômtaunê aŋela kêsôm gêdêŋ eŋ gebe “Otoc gwada to polom ŋaluc ênsac poc tonec ŋaô ma ôkêc sulu êpi.” Ma Gideon gêgôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Ma Apômtaunê aŋela kêmêtôc lêma ma kêmoasac gwada to polom ŋaluc ŋa tôc, taŋ eŋ kêmêgôm naŋ ŋatêpôê. Ma ja kêsa aŋga poc mêŋgeŋ gwada to polom ŋaluc tau su. Go Apômtaunê aŋela malamê. ");
INSERT INTO jae_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Go Gideonnê kauc kêsa, gebe gêlic Apômtaunê aŋela ma eŋ kêtakê ma kêsôm gebe “Op, Apômtau Anôtô, aêagêc aŋela laŋôŋanô gêdêŋ tauŋgoc.” ");
INSERT INTO jae_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Mago Apômtau kêsôm gêdêŋ eŋ gebe “Ôtêc taôm atom, ômoa tobiŋmalôgeŋ, aôm oc ômac êndu atom.” ");
INSERT INTO jae_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Gideon gêboa altar teŋ sa gêdêŋ Apômtau aŋga tônê ma kêsam altar tau gebe Apômtau eŋ biŋmalô ŋam. Altar tau kêkô Opra, taŋ kêtu Abiesernê gôlôacnêŋ malac naŋ, e gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Gêdêŋ gêbêc tonaŋ Apômtau kêsôm gêdêŋ Gideon gebe “Ôkôc tamam nê bulimakao kapoac êwiŋ bulimakao kapoac teŋ, taŋ nê jala kêtôm 7 ma onseŋ tamamnê altar Balŋa su ôsap alê gwam, taŋ kêkô altar ŋagala naŋ tulu. ");
INSERT INTO jae_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Su, go ômboa altar teŋ sa êndêŋ Apômtau, aômnêm Anôtô, êkô poc tau ŋaô. Ômboa altar tau sa êtôm ŋagôliŋgeŋ. Go ôkôc bulimakao kêtu luagêc ŋa ma ôkêŋ êtu daja êwiŋ alê gwam, taŋ ôsap tulu naŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Amboac tonaŋ tec Gideon kêkôc nê sakiŋwaga 10 ma gêgôm biŋ, taŋ Apômtau kêsôm gêdêŋ eŋ naŋ, ŋanô kêsa. Mago eŋ kêtêc tau nê gôlôac to lau malac tonecŋa, tec gêgôm gêŋ tau gêdêŋ ocsalô atom, gêgôm gêdêŋ gêbêcgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Gêdêŋ taŋ lau malacŋa dêdi sa gêdêŋ bêbêc kanucgeŋ naŋ, êsêac sêlic gebe Balnê altar to alê gwam tau gêjaŋa ma ja geŋ bulimakao kêtu luagêcŋa gêsac altar teŋ, taŋ sêboa sa naŋ ŋaô. ");
INSERT INTO jae_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Êsêac sêsôm gêdêŋ tauŋ gebe “Asa gêgôm gêŋ tonec.” Êsêac sêkip biŋ tau sa e têtap sa gebe “Joas latu Gideon gêgôm.” ");
INSERT INTO jae_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Go lau malacŋa sêsôm gêdêŋ Joas gebe “Ôkôc latôm ômôêŋ tonec gebe anac eŋ êndu. Eŋ geseŋ Balnê altar su ma kêsap alê gwam, taŋ kêkô altar ŋagala naŋ tulu.” ");
INSERT INTO jae_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Mago Joas kêsôm gêdêŋ lau samob, taŋ sêgi eŋ auc naŋ, gebe “Amac abe anac siŋ êjô Bal ma abe anam eŋ sa me. Eleŋŋa atomgeŋ ma ŋac, taŋ ênac siŋ êjô Bal naŋ, oc ênaŋa. Gebe Bal embe anôtô teŋ, go ênam tau kêsi ma ênac siŋ êndêŋ ŋac, taŋ geseŋ ênê altar su naŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Gêdêŋ ŋasawa tonaŋ sêsam Gideon gebe Jerubal gebe Joas kêsôm gebe “Bal ênam tau kêsi ma ênac siŋ êndêŋ ŋac, taŋ geseŋ ênê altar su naŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Go Midian to Amelek ma lau gamêŋ sawaŋa mêŋsêpi tageŋ ma selom bu Jordan jasê nêŋ becobo kêkô gaboaŋ Jesrelŋa. ");
INSERT INTO jae_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Ma Apômtaunê Ŋalau gêjam Gideon auc. Ma eŋ gêjac dauc e kêkalem Abiesernê gôlôac gebe sêndaŋguc eŋ. ");
INSERT INTO jae_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Eŋ kêsakiŋ lau jaeŋŋa sêjac laoc Manasenê gôlôacnêŋ gamêŋ samob, gebe sêkalem êsêac mêŋsêndaŋguc eŋ ma eŋ kêsakiŋ lau jaeŋŋa gêdêŋ Aser to Sebulon ma Naptali nêŋ gôlôac e êsêac mêŋsêwiŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Go Gideon kêsôm gêdêŋ Anôtô gebe “Aôm embe taêm ênam gebe ônam lau Israel kêsi ŋa aê lemoc amboac tê kôsôm nê, ");
INSERT INTO jae_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","naŋ ôlic acgom, aê gaja domba ŋaôlilu gêc gamêŋ aka polom ŋa. Êndêŋ eleŋ ŋa embe maniŋ ênêc domba ŋaôlilugeŋ ŋaô ma nom ŋakeleŋ, go jajala êndêŋ tonaŋ gebe aôm taêm kêka aê ŋanôgeŋ, gebe ônam lau Israel kêsi ŋa aê lemoc, amboac tê kôsôm su nê.” ");
INSERT INTO jae_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Biŋ tau ŋanô kêsa. Gêdêŋ taŋ Gideon gêdi sa gêdêŋ bêbêc kanucgeŋ naŋ, eŋ kêpip ŋaôlilu tau ma kêmôgiŋ kêsêp laclu teŋ e mêŋgêc. ");
INSERT INTO jae_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Go Gideon kêsôm gêdêŋ Anôtô gebe “Têmtac ŋandaŋ êndêŋ aê atommaŋ, aê jasôm biŋ tageŋ tonec êwiŋ. Aê jateŋ aôm gebe jansaê domba ŋaôlilu ŋalêŋ tageŋ êtiam. Ôŋgôm ŋaôlilu ŋakeleŋ ênêc ma maniŋ êsêp nomgeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Ma gêdêŋ gêbêc Anôtô gêgôm amboac tonaŋ. Ŋaôlilu ŋakeleŋ ma maniŋ kêsêlô e gêjam nom auc. ");
INSERT INTO jae_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Go Jerubal, Gideonnê ŋaê teŋ tonec, to nê lau samob dêdi gêdêŋ bêbêc kanucgeŋ ma sê nêŋ becobo kêkô bumata Harod ŋagala. Lau Midian sê nêŋ becobo kêkô gaboaŋ gêmu kêpiŋa aŋga lôc More ŋalabu. ");
INSERT INTO jae_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Ma Apômtau kêsôm gêdêŋ Gideon gebe” Lau, taŋ sêwiŋ aôm naŋ, taêsam kêlêlêc, tec katôm gebe jakêŋ lau Midian sêsêp êsêac lemeŋ atom. Moae lau Israel oc tetoc tauŋ sa êndêŋ aê ma sêsôm gebe ‘Aê tauc ŋoc lemoc gêjam aê kêsi.’ ");
INSERT INTO jae_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Amboac tonaŋ ôkêŋ ŋawae êndêŋ lau gebe’ Ŋac teŋ embe êtêc tau to nê ŋalêlôm ŋatutuc, naŋ êmu êna nê malac.’” Ma Gideon kêsaê êsêac ma lau 22,000 sêmu sêja, ma lau 10,000geŋ sêmoa sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Apômtau kêsôm gêdêŋ Gideon gebe “Lau tau taêsam kêlêlêc gacgeŋ sêkô ŋapaŋ. Ôwê êsêac sêsêp bu sêna ma aê gabe jawa êsêac êkôc jajô aôm. Embe jasôm êndêŋ aôm gebe ‘Ŋac tonec êwiŋ aôm’, naŋ eŋ êwiŋ. Embe jasôm êndêŋ aôm gebe’ Ŋac tonec êwiŋ aôm atom’, naŋ eŋ êwiŋ atom.” ");
INSERT INTO jae_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Tec Gideon gêwê êsêac sêsêp bu sêja, ma Apômtau kêsôm gêdêŋ eŋ gebe “Lau, taŋ imbeleŋ gêjac bu amboac kêam naŋ, sêmoa nêŋ tauŋŋa, ma êsêac, taŋ sêpôŋ aeŋduc ma sênôm naŋ, sêmoa nêŋ tauŋŋa amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Lau 300 sêmoa, taŋ imbeleŋ gêjac bu naŋ, lau ŋagêdô samob sêpôŋ aêŋduc ma sênôm. ");
INSERT INTO jae_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Go Apômtau kêsôm gêdêŋ Gideon gebe “Aê gabe janam amac kêsi ŋa lau 300, taŋ imbeleŋ gêjac bu naŋ, ma jakêŋ lau Midian sêsêp aôm lêmam. Lau ŋagêdô samob sêmu sêna nêŋ malac.” ");
INSERT INTO jae_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Gideon kêmasaŋ biŋ gêdêŋ lau gebe sêkêŋ gêŋ taniŋŋa to nêŋ dauc êndêŋ eŋ ma kêsakiŋ lau samob sêmu sêja nêŋ malac, lau 300 tônêgeŋ tê sêmoa sêwiŋ eŋ. Lau Midian nêŋ becobo kêkô lau Israelnêŋ bec ŋalabu aŋga gaboaŋ. ");
INSERT INTO jae_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Gêdêŋ gêbêc tonaŋgeŋ Apômtau kêsôm gêdêŋ Gideon gebe “Ajôc, ôndi ma ôsêp gamêŋ becŋa ôna. Aê jakêŋ gamêŋ tau êsêp aôm lêmam. ");
INSERT INTO jae_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Mago embe ôtêc taôm gebe ônac siŋ, naŋgo ôsêp lau Midian nêŋ gamêŋ becŋa ma nêm sakiŋwaga Pura êwiŋ aôm. ");
INSERT INTO jae_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Aôm oc ôŋô biŋ, taŋ êsêac sêsôm naŋ, e têmtac êpa su ma ônac siŋ êndêŋ êsêac.” Amboac tonaŋ Gideon agêc nê sakiŋwaga Pura sêsêp sêja e sêô lasê gamêŋ becŋa ŋamagê. ");
INSERT INTO jae_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Lau Midian to Amelek ma lau, taŋ sêmoa gamêŋ sawa naŋ, sêjam gaboaŋ auc amboac lêsêc, ma nêŋ kamele taêsam ŋasec têtôm gaŋac gwêcŋa. ");
INSERT INTO jae_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Gêdêŋ taŋ Gideon gêô lasê malac ŋamagê naŋ, gêŋô ŋac teŋ gêjac miŋ nê mê, taŋ gêc naŋ, gêdêŋ nê ŋac teŋ, ma kêsôm gebe “Aê gaêc mê teŋ. Aê galic êsêac sêkôc polom matac ma sêpac polom kuku. Polom kuku tau kêsabi kêsêp lau Midian nêŋ gamêŋ becoboŋa. Polom tau mêŋkêtuc becobo e becobo tau kêku sa jakêsô gedec ma kêtu tapa gêc nom.” ");
INSERT INTO jae_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Nê ŋac gêjô eŋ awa gebe “Mê tonaŋ ŋam tageŋ tonec gebe ŋac Israelŋa Joas latu Gideon nê siŋ. Anôtô kêkêŋ eŋ gebe êku lau Midian to nêŋ siŋwaga samob tulu.” ");
INSERT INTO jae_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Gêdêŋ taŋ Gideon gêŋô mê ŋam ŋawae naŋ, kêpôŋ aduc gêdêŋ Anôtô. Go gêmu gêja lau Israel nêŋ gamêŋ becoboŋa ma kêsôm gebe “Ajôc, andimaŋ, Apômtau kêkêŋ lau Midian nêŋ siŋwaga sêsêp amac lemem sugac.” ");
INSERT INTO jae_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Eŋ gêwa lau 300 kêkôc gêja mata têlêac ma kêkêŋ dauc to ku sawa gêdêŋ êsêac gêdêŋ-gêdêŋgeŋ ma kêkêŋ daweŋ kêsêp ku tau ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Eŋ kêsôm gêdêŋ êsêac gebe “Matemanô êndêŋ aêgeŋ, ma aŋgôm gêŋ, taŋ aê jaŋgôm naŋgeŋ. Êndêŋ taŋ daô lasê êsêacnêŋ gamêŋ becoboŋa ŋamagê naŋ, go aŋgôm gêŋ samob êtôm aê jaŋgôm. ");
INSERT INTO jae_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Aê to ŋoc lau embe anac ma dauc, go amac, taŋ aŋgi gamêŋ becoboŋa auc naŋ, anac nêm amboac tonaŋgeŋ ma anac mu gebe ‘Apômtau ma Gideon nêŋ siŋ.’” ");
INSERT INTO jae_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Gideon to nê lau 100 sêô lasê malac ŋamagê gêdêŋ om-m kêsa atomgeŋ, ma lau-sejop-malacwaga sêjô tauŋ su ma ŋasawa dambêgeŋ. Go Gideon to nê lau sêjac dauc to têtuc ku, taŋ sêkôc naŋ popoc. ");
INSERT INTO jae_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Siŋwaga mata têlêac samob sêjac dauc to têtuc ku popoc. Êsêac sêkôc daweŋ kêsêp êsêac lemeŋ gasêŋa ma dauc kêsêp lemeŋ anôŋa gebe sênac ma sêjac mu gebe “Apômtau ma Gideon nêŋ siŋ.” ");
INSERT INTO jae_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Lau samob sêkô maleŋgeŋ sêgi gamêŋ becoboŋa auc. Ma Midiannêŋ siŋwaga samob sêlêti to sêwakic ma sêc sêja. ");
INSERT INTO jae_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Lau 300 sêjac nêŋ dauc kêtaŋ gê tôŋgeŋ sêmoa, ma Apômtau gêgôm lau aŋga gamêŋ becoboŋa nêŋ kauc kêlênsôŋ e sêjac tauŋ. Ma siŋwaga samob sêc e jagêdêŋ Betsita sêkanôŋ Serera ma sêô lasê malac Abel-Mehola, taŋ gec Tabat ŋagala. ");
INSERT INTO jae_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Ma êsêac sêkalem lau Israel aŋga Naptali to Aser nêŋ gôlôac ma lau Manase samob sa ma sêjanda lau Midian. ");
INSERT INTO jae_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Gideon kêsakiŋ lau jaeŋŋa sêjac laoc gamêŋ Epraim, taŋ gêc gamêŋ lôcŋa naŋ, ma sêsôm gebe “Asêp amêŋ, anac siŋ êndêŋ lau Midian. Akô lau Midian auc gebe selom bu Jordan to bu ŋagêdô e naêndêŋ Bet-Bara atom.” Amboac tonaŋ lau Epraim samob sêpi tageŋ ma sejop bu Jordan to bu ŋagêdô e jagêdêŋ Bet-Bara. ");
INSERT INTO jae_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Êsêac sêkôc lau Midian nêŋ kasêga luagêc Oreb agêc Seb tôŋ, ma sêjac Oreb êndu aŋga Orebnê poc ma Seb aŋga Sebnê sêka wain ŋamala. Êsêac sêjanda lau Midian sêmoa ma sêkôc Oreb agêc Seb môkêŋapac dêdêŋ Gideon, taŋ gêmoa Jordan ŋamakeŋ oc kêpiŋa naŋ sêja. ");
INSERT INTO jae_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Ma lau Epraim sêsôm gêdêŋ Gideon gebe “Amboac ondoc, aôm gôjac siŋ gêdêŋ Midian, mago kôkalem aêac atom kêtu asageŋŋa. Kêtu asageŋŋa aôm gôgôm aêac amboac tonaŋ.” Ma êsêac sêlic eŋ sec ŋanô. ");
INSERT INTO jae_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Mago eŋ kêsôm gêdêŋ êsêac gebe “Embe janam dôŋ gêŋ, taŋ aê gagôm naŋ, êpi gêŋ, taŋ amac agôm naŋ, go jalic ŋoc gêŋ ŋanô masi. Gêŋ sauŋ, taŋ amac lau Epraim agôm naŋ, ŋanô kêlêlêc gêŋ, taŋ aê to ŋoc gôlôac agôm naŋ. ");
INSERT INTO jae_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Anôtô kêkêŋ lau Midian nêŋ kasêga Oreb agêc Seb gêdêŋ amac. Aê gagôm asageŋ kêlêlêc su gebe janam dôŋ êpi gêŋ tau.” Eŋ kêsôm biŋ tonec, go nêŋ têntac ŋandaŋ gêbacnê. ");
INSERT INTO jae_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Gideon to nê lau 300 sêô lasê bu Jordan ma selom bu tau. Êsêac tekweŋ gêbac, mago sêjanda ŋacjo sêmoa. ");
INSERT INTO jae_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Tec kêsôm gêdêŋ lau aŋga malac Sukot gebe “Aê jateŋ amac gebe akêŋ polom ŋagêdô êndêŋ ŋoc lau. Êsêac tekweŋ gêbac ma aê kajanda lau Midian nêŋ kiŋ Seba agêc Salmuna tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Mago malac Sukot ŋalaumata sêsôm gebe “Aêac akêŋ mo êndêŋ nêm siŋwaga êtu asageŋŋa. Aôm kôkôc Seba agêc Salmuna tôŋ atom tageŋ.” ");
INSERT INTO jae_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Ma Gideon kêsôm gebe “Amboac tonaŋ. Apômtau êkêŋ Seba agêc Salmuna sêsêp aê lemoc su acgom, go jai amac ôlim ŋa gêŋ têkwa-têkwa to okêm gamêŋ sawaŋa.” ");
INSERT INTO jae_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Gideon gêwi malac tonaŋ siŋ gêja malac Penuel ma kêsôm biŋ tonaŋgeŋ gêdêŋ lau aŋga ônê. Mago lau Penuelŋa sêjô eŋ awa kêtôm lau Sukotŋa. ");
INSERT INTO jae_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Tec eŋ kêsôm gêdêŋ êsêac gebe “Aê embe janam samuc ma jamu jamêŋ, go janseŋ andu soso tonec su.” ");
INSERT INTO jae_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Seba agêc Salmuna to nêŋ siŋwaga sêŋgôŋ Karkor. Lau gamêŋ sawaŋa nêŋ siŋwaga 120,000 sêjaŋa, ma siŋwaga amboac 15,000 geŋ tec sêmoa. ");
INSERT INTO jae_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Êsêac sêlêwaŋ tauŋ e sêliŋ tauŋ siŋ ma Gideon kêsa intêna, taŋ gêc Noba to Jogbeha gêmu oc kêpiŋa naŋ, gêmoa gamêŋ sawa ŋataligeŋ gêja jagêjac siŋ gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Lau Midian nêŋ kiŋ luagêc, Seba agêc Salmuna sêc sêja, mago eŋ kêjanda êsêagêc e kêkôc êsêagêc tôŋ ma kêsa siŋwaga samob êliŋ-êliŋ. ");
INSERT INTO jae_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Go Joas latu Gideon gêmu aŋga siŋŋa kêsêlêŋ kêsêp intêna Heresŋa gêja. ");
INSERT INTO jae_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Eŋ kêkôc ŋapalê matac Sukotŋa teŋ tôŋ ma kêtu kênac eŋ ma ŋac tau keto Sukot ŋakasêga to ŋalaumata 77 nêŋ ŋaê sa ma kêkêŋ gêdêŋ Gideon. ");
INSERT INTO jae_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Go Gideon gêdêŋ lau Sukot gêja ma kêsôm gebe “Alic acgom, Seba agêc Salmuna tau tonec. Amac asu aê susu kêtu êsêagêcŋa ma asôm gebe ‘Seba agêc Salmuna sêsêp aôm lêmam sugac, tec aêac akêŋ polom êndêŋ nêm lau, taŋ tekweŋ gêbac naŋ me.’” ");
INSERT INTO jae_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Go eŋ kêkôc gêŋ têkwa-têkwa to okêm gamêŋ sawaŋa ma kêmêtôc Sukot ŋalaumata. ");
INSERT INTO jae_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Ma eŋ geseŋ andu soso aŋga Penuel su ma gêjac malac tau ŋalau êndu. ");
INSERT INTO jae_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Go Gideon kêtu kênac Seba agêc Salmuna gebe “Lau, taŋ ajac êndu aŋga Tabor naŋ, laŋôŋanô amboac ondoc.” Êsêagêc sêjô eŋ awa gebe “Êsêac têtôm aôm. Êsêac samob laŋôŋanô amboac kiŋ teŋ latui.” ");
INSERT INTO jae_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Gideon kêsôm gebe “Ŋoc teoci to lasici êsêac, aê tinoc latui solop. Aê jatôc lemoc ma jasôm gebe Amagêc embe anam êsêac kêsi sêmoa mateŋ jali, oc janac amagêc êndu atom.” ");
INSERT INTO jae_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Go kêsôm gêdêŋ latu ŋacsêga Jeter gebe “Ôndi ônac êsêagêc êndumaŋ.” Mago ŋapalê tau gê nê siŋ sa atom. Eŋ kêtêc tau gebe eŋ ŋapalê wakuc. ");
INSERT INTO jae_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Ma Seba agêc Salmuna sêsôm gebe “Ajôc, aôm taôm ôndi ma ônac aêagêc êndumaŋ. Ŋacwaganêŋ kôm gêjac ŋacwaga ŋawae.” Amboac tonaŋ Gideon gêjac Seba agêc Salmuna êndu ma kêkôc gêlôŋ, taŋ agêcnêŋ kamele sênôŋ naŋ su. ");
INSERT INTO jae_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Go lau Israel sêsôm gêdêŋ Gideon gebe “Onam gôliŋ aêac, aôm to latômi ma dêbômi, taŋ sêndaŋguc aôm naŋ, amboac tonaŋgeŋ, gebe aôm gôjam aêac kêsi aŋga lau Midian nêŋ.” ");
INSERT INTO jae_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Gideon gêjô êsêac aweŋ gebe “Aê oc janam gôliŋ amac atom, ma latuci oc sênam gôliŋ amac atom amboac tonaŋgeŋ. Apômtau oc ênam gôliŋ amac.” ");
INSERT INTO jae_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Ma kêsôm biŋ ŋagêdô gebe “Aê gabe jateŋ biŋ teŋ êndêŋ amac. Amac samob akêŋ salasa, taŋ amac ajaŋgo su naŋ, êndêŋ aê. Lau Midian nêŋ salasa goldgeŋ gebe êsêac lau gamêŋ sawaŋa.” ");
INSERT INTO jae_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Lau sêjô eŋ awa gebe “Aêac oc akêŋ gêŋ tau êndêŋ aôm totêntac ŋajamgeŋ.” Êsêac sêja obo teŋ ma êsêac samob, sêbaliŋ salasa, taŋ êsêac sêjaŋgo su naŋ, kêsêp obo tau. ");
INSERT INTO jae_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Salasa gold, taŋ Gideon keteŋ naŋ, ŋawapac kêtôm kilo 30. Gêlôŋ, taŋ lau Midian nêŋ kiŋ sêkôc to sênôŋ naŋ, ma ŋakwê asôsamuc gêwiŋ atomgeŋ, ma kamelenêŋ gêlôŋ, taŋ sênôŋ naŋ, gêwiŋ atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Gideon kêmasaŋ gwam teŋ ŋa gold tonaŋ ma kêkêŋ gwam tau kêkô nê malac Opra. Ma lau Israel samob sêwi Anôtô siŋ jateteŋ mec gêdêŋ gwam tonaŋ. Gwam tau kêtu lakô, taŋ gêjac Gideon to nê gôlôac naŋ. ");
INSERT INTO jae_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Lau Israel sêku lau Midian tulu ma lau Midian ôliŋ kêpi kêtiam atom. Wama gêjam gamêŋ auc kêtôm jala 40, kêtôm têm, taŋ Gideon gêmoa mata jali naŋ. ");
INSERT INTO jae_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Joas latu Gideon jagêŋgôŋ tau nê andu. ");
INSERT INTO jae_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Ênê latui 70 gebe eŋ gêjam lauo taêsam. ");
INSERT INTO jae_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Ma nê awê teŋ aŋga Sikem kêkôc ŋapalê teŋ amboac tonaŋ, ma Gideon gê ênê ŋaê gebe Abimelek. ");
INSERT INTO jae_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Gideon kêtu ŋamalacanô ma gêmac êndu. Êsêac sêsuŋ eŋ gêc tama Joas nê sêô aŋga Abiesernê gôlôacnêŋ malac Opra. ");
INSERT INTO jae_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Gideon gêmac êndu su acgom, go lau Israel sêwi Anôtô siŋ kêtiam ma sêjam sakiŋ Bal. Êsêac sêgôm Bal-Berit kêtu nêŋ anôtô. ");
INSERT INTO jae_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Lau Israel taêŋ gêjam nêŋ Apômtau Anôtô, taŋ gêjam êsêac sa aŋga nêŋ ŋacjo, tê sêgi êsêac auc nê, kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Ma êsêac sêjam daŋge Gideonnê gôlôac gêjô koleŋ ŋajam, taŋ eŋ gêjam gêdêŋ lau Israel naŋ, su atom. ");
INSERT INTO jae_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Jerubal latu Abimelek gêdêŋ sai gêja Sikem ma kêsôm gêdêŋ êsêac to tênanê lau samob gebe ");
INSERT INTO jae_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“Atu kênac lau Sikemŋa samob gebe ‘Amac oc têmtac êwiŋ biŋ ondoc êlêlêc su, Jerubal latui 70 sênam gôliŋ amac me ŋac tageŋ ênam gôliŋ amac.’ Taêm ênam gebe amacnêm ŋatê ŋagêdô aê.” ");
INSERT INTO jae_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Tênanê lau sêjam biŋgalôm kêpi biŋ tonaŋ kêtu eŋŋa sêwiŋ lau Sikemŋa. Ma nêŋ ŋalêlôm gêwiŋ Abimelek gebe êsêac sêsôm gebe “Eŋ aêac lasiŋi teŋ.” ");
INSERT INTO jae_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Êsêac sêkôc mone silber 70 aŋga Bal-Berit nê lôm dabuŋ ma sêkêŋ gêdêŋ eŋ. Eŋ kêkôc mone tau ma gêjam ôli lau bôja-bôja to wauc-wauctêna ŋagêdô gebe sêndaŋguc eŋ. ");
INSERT INTO jae_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Go eŋ gêja tamanê andu aŋga Opra ma gêjac tama Jerubal latui 70 êndu aŋga poc teŋ ŋaô. Jerubalnê latu ŋamu Jotam taugeŋ tec gêmoa, gebe eŋ kêsiŋ tau. ");
INSERT INTO jae_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Go lau Sikem to Betmiloŋa samob jasêkac tauŋ sa sêmoa kamem dabuŋ, taŋ kêkô Sikem naŋ, ma sêkêŋ Abimelek kêtu kiŋ. ");
INSERT INTO jae_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Gêdêŋ taŋ Jotam gêŋô biŋ tonaŋ ŋawae naŋ, gêja ma kêkô lôc Garisim ŋaô to gêmôêc gêdêŋ êsêac gebe “O amac lau Sikemŋa, akêŋ taŋem aê acgom, gebe Anôtô êkêŋ taŋa amac. ");
INSERT INTO jae_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","Gêdêŋ bêc teŋ ka sêsa sêja sebe sêjaliŋ nêŋ kiŋ teŋ sa, ma êsêac sêsôm gêdêŋ katêkwi gebe ‘Ôtu ma kiŋ.’ ");
INSERT INTO jae_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","Katêkwi gêjô êsêac aweŋ gebe ‘Amboac ondoc, oc jawi ŋoc ŋatêkwi toŋalêsi, taŋ lau sêkôc kêtu tetoc anôtôi to ŋamalac saŋa naŋ, siŋ ma janam gôliŋ amac me.’ ");
INSERT INTO jae_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","Ma ka sêsôm gêdêŋ jambô gebe ‘Ômôêŋ mêŋôtu ma kiŋ.’ ");
INSERT INTO jae_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","Mago jambô gêjô êsêac aweŋ gebe ‘Amboac ondoc, oc jawi ŋoc ŋanô ŋajam to ŋakana siŋ ma janam gôliŋ amac me.’ ");
INSERT INTO jae_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","Tec ka sêsôm gêdêŋ wain gebe ‘Ômôêŋ mêŋôtu ma kiŋ.’ ");
INSERT INTO jae_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","Mago wain gêjô êsêac aweŋ gebe ‘Amboac ondoc, oc jawi ŋoc wain, taŋ gêgôm anôtôi to ŋamalac têntac ŋajam kêsa naŋ, siŋ ma janam gôliŋ amac me.’ ");
INSERT INTO jae_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","Go ka samob sêsôm gedeŋ okêm gebe ‘Ômôêŋ mêŋôtu ma kiŋ.’ ");
INSERT INTO jae_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","Go okêm gêjô êsêac aweŋ gebe ‘Amac embe têmtac êwiŋ ŋanôgeŋ gebe jatu amacnêm kiŋ, go amêŋ aê lamu aêŋoc ajuŋ. Embe amêŋ atom, ja êsa aŋga okêm ma êniŋ kaseda aŋga lôc Lebanon.’” ");
INSERT INTO jae_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","Jotam gêjac têku nê biŋ gebe “Amboac tonaŋ amac akêŋ Abimelek kêtu amacnêm kiŋ tonêm ŋalêlôm samuc ma toŋanôgeŋ me masi. Amac amoasiŋ Jerubal to nê gôlôac ŋapep ma akêŋ ŋagêjô gêdêŋ eŋ kêtôm koleŋ, taŋ eŋ gêjam naŋ, me masi. ");
INSERT INTO jae_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Taêm ênam acgom, tamoc gêjac siŋ gêjô amac ma gim tau su gebe ênam amac sa aŋga lau Midian lemeŋ. ");
INSERT INTO jae_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Mago galoc akêŋ kisa gêdêŋ tamocnê gôlôac. Amac ajac latui 70 êndu aŋga poc ŋaô ma akêŋ sakiŋwagao latu Abimelek kêtu kiŋ Sikemŋa gebe amacnêm lasitêwa teŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Amboac tonaŋ, gêŋ taŋ amac agôm galoc gêdêŋ Jerubal to nê gôlôac naŋ, embe aŋgôm tonêm ŋalêlôm samuc ma toŋanôgeŋ, go amoa totêmtac ŋajamgeŋ awiŋ Abimelek, ma eŋ êmoa totêtac ŋajamgeŋ êwiŋ amac. ");
INSERT INTO jae_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Mago embe masi, go ja êsa aŋga Abimeleknê e êniŋ lau Sikem to Betmiloŋa su. Ma ja êsa aŋga lau Sikem to Betmiloŋa e êniŋ Abimelek su.” ");
INSERT INTO jae_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Go Jotam gêc gêja jagêŋgôŋ Ber, gebe kêtêc têwa Abimelek. ");
INSERT INTO jae_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Abimelek gêjam gôliŋ Israel jala têlêac. ");
INSERT INTO jae_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Lau Israel sêgôm gêŋ, taŋ Apômtau gêlic sec naŋ kêtiam, ma eŋ kêkêŋ lau Pilisti sêjam gôliŋ êsêac kêtôm jala 40. ");
INSERT INTO jae_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Ma ŋac teŋ gêŋgôŋ malac Sora. Eŋ aŋga Dannê gôlôacnêŋ, ênê ŋaê gebe Manoa. Nê awê eŋ awê kapoac ma kêkôc gôlôac atom. ");
INSERT INTO jae_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Ma Apômtaunê aŋela geoc tau lasê gêdêŋ awê tau ma kêsôm gêdêŋ eŋ gebe “Ôlic acgom, aôm awê kapoac ma kôkôc gôlôac atom. Mago aôm oc taêm ma ôkôc latôm teŋ. ");
INSERT INTO jae_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Amboac tonaŋ ojop taôm ma ônôm wain to bu ŋajaŋa teŋ atom to ôniŋ gêŋ, taŋ sêjac jao naŋ, atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Gebe aôm oc taêm ma ôkôc latôm teŋ. Ôkapiŋ eŋ môkêlauŋ atom, gebe êndêŋ bêc aôm ôkôc eŋŋa ŋapalê tau oc êtu Anôtônê ŋac dabuŋ teŋ. Eŋ ênac m kôm ênam lau Israel kêsi aŋga lau Pilistinêŋŋa.” ");
INSERT INTO jae_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Go awê tau jagêjac miŋ gêdêŋ nê akweŋ ma kêsôm gebe “Anôtônê ŋac teŋ gêdêŋ aê gêmêŋ ma laŋôanô kêtakê aê amboac Anôtônê aŋela teŋ laŋôanô. Aê katu kênac eŋ gebe eŋ gêmêŋ aŋga ondoc nec atom, ma eŋ kêsam nê ŋaê atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Mago eŋ kêsôm gêdêŋ aê gebe ‘Ôlic acgom, aôm oc taêm ma ôkôc latôm teŋ. Amboac tonaŋ galoc ônôm wain to bu ŋajaŋa atom ma ôniŋ gêŋ, taŋ sêjac jao naŋ, atom amboac tonaŋgeŋ, gebe ŋapalê tau êtu Anôtônê ŋac dabuŋ êtôm têm êmoa nomŋa.’” ");
INSERT INTO jae_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Go Manoa keteŋ mec gêdêŋ Apômtau gebe “O Apômtau, aê jateŋ aôm, gebe ôsakiŋ Anôtônê ŋac êmu êndêŋ aêac êmêŋ êtiam, gebe êndôŋ kôm anam jaom ŋapalê tau êndêŋ noc têna êkôc eŋŋa êndêŋ aêagêc.” ");
INSERT INTO jae_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Anôtô gêgôm biŋ, taŋ Manoa keteŋ naŋ, ŋanô kêsa ma ênê aŋela gêô lasê gêdêŋ awê tau kêtiam gêdêŋ taŋ eŋ gêŋgôŋ kôm naŋ. Ênê akweŋ gêwiŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Tec awê tau kêlêti sebeŋ jakêsôm gêdêŋ nê akweŋ gebe “Ôlic acgom, ŋac taŋ gêdêŋ aê gêmêŋ gêdêŋ bêc ônê naŋ, mêŋgêô lasê gêdêŋ aê kêtiam.” ");
INSERT INTO jae_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Manoa gêdi kêdaguc nê awê e gêô lasê gêdêŋ ŋac tau ma kêtu kênac eŋ gebe “Aôm ŋac, taŋ kôsôm biŋ gêdêŋ ŋoc awê naŋ me.” Eŋ gêjô eŋ awa gebe “Aêc.” ");
INSERT INTO jae_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Go Manoa kêsôm gebe “Amboac tonaŋ, biŋ taŋ aôm kôsôm naŋ, embe ŋanô êsa, go ŋapalê tau êsa lêŋ amboac ondoc. Eŋ êŋgôm asageŋ.” ");
INSERT INTO jae_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Apômtaunê aŋela gêjô Manoa awa gebe “Aômnêm awê êŋgamiŋ tau êndêŋ gêŋ samob, taŋ gajac jao gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Eŋ êniŋ gêŋ, taŋ gêmêŋ aŋga wain ŋakaiŋ naŋ, ŋateŋ atom. Eŋ ênôm wain to bu ŋajaŋa ma êniŋ gêŋ, taŋ sêjac jao naŋ, atom amboac tonaŋgeŋ. Eŋ êŋgôm gêŋ samob, taŋ kajatu eŋ naŋ, ŋanô êsa.” ");
INSERT INTO jae_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","16","Manoa gêjam kauc Apômtaunê aŋela. tec kêsôm gêdêŋ eŋ gebe “Aê jateŋ aôm ôêc ôna atom, aêagêc ano noniŋ ŋalatu teŋ gebe ôniŋ.” Mago aŋela kêsôm gêdêŋ eŋ gebe “Aê embe jamoa, oc janiŋ nêm gêŋ atom. Mago embe taêm ênam gebe ôkêŋ da teŋ, naŋgo ôkêŋ gêŋ tau êsa ja êniŋ êtu da êndêŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Manoa kêsôm gêdêŋ Apômtaunê aŋela gebe “Aômnêm ŋaê amboac ondoc, gebe atoc aôm sa êndêŋ têm aômnêm biŋ ŋanô êsaŋa.” ");
INSERT INTO jae_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Aŋela kêtu kênac eŋ gebe “Aôm kôtu kênac ŋoc ŋaê kêtu asageŋŋa. Ŋaê tau geŋ, taŋ kêsiŋ tau gêc lêlômgeŋŋa naŋ ŋateŋ.” ");
INSERT INTO jae_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Amboac tonaŋ Manoa kêkôc noniŋ ŋalatu to polom ŋagêdô ma kêkêŋ gêŋ tau kêtu da gêsac altar poc gêdêŋ gêŋ, taŋ kêsiŋ tau gêc lêlômgeŋŋa naŋ, ŋaApômtau. ");
INSERT INTO jae_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Ma gêdêŋ taŋ jawaô kêpi aŋga altar naŋ, Manoa agêc nê awê sêlic Apômtaunê aŋela kêpi undambê gêja gêwiŋ jawaô. Ma êsêagêc sêu tauŋ jasêc laŋôŋanô gêdêŋ nom. ");
INSERT INTO jae_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Manoa agêc nê awê sêlic Apômtaunê aŋela kêtiam atomanô. Tec Manoanê kauc kêsa gebe Apômtaunê aŋela eŋgoc. ");
INSERT INTO jae_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Ma Manoa kêsôm gêdêŋ nê awê gebe “Aêagêc oc tamac êndu, gebe talic Anôtô.” ");
INSERT INTO jae_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Mago nê awê gêjô eŋ awa gebe “Apômtau embe taê ênam gebe ênac aêagêc êndu, go êkôc aêagêcnêŋ da sa atom ma êtôc gêŋ samob tonaŋ ŋai to êsôm biŋ kaiŋ teŋ tonaŋ êndêŋ aêagêc atom.” ");
INSERT INTO jae_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Ma awê tau kêkôc ŋapalê ŋac ma gê ênê ŋaê gebe Simson. Ŋapalê tau kêtu kapôêŋ ma Apômtau gêjam mec eŋ. ");
INSERT INTO jae_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Apômtaunê Ŋalau gêjac m nê kôm êkac Simsonŋa gêdêŋ taŋ eŋ gêmoa Dannê gamêŋ becoboŋa, taŋ gêc Sora to Estaol ŋasawa naŋ. ");
INSERT INTO jae_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Simson kêsêp malac Timna gêja ma gêlic lau Pilisti nêŋ ŋapalêo teŋ aŋga tônê. ");
INSERT INTO jae_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Eŋ gêmu gêja nê malac kêtiam ma kêsôm gêdêŋ têna agêc tama gebe “Aê galic lau Pilisti nêŋ ŋapalêo teŋ. Amansaŋ biŋ êtu eŋŋa, gebe janam eŋ êtu ŋoc awê.” ");
INSERT INTO jae_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Mago têna agêc tama sêsôm gêdêŋ eŋ gebe “Aôm gosom awê aŋga lau samuc Pilisti nêŋ kêtu asageŋŋa. Aôm oc ôtap ŋapalêo teŋ sa aŋga tauŋ nêŋ tawaŋ me tauŋ nêŋ lau nêŋ atom me.” Mago Simson kêsôm gêdêŋ tama gebe “Aê têtac gêwiŋ awê tonaŋgeŋ, tec ôkôc eŋ ômôêŋ, gebe janam eŋ.” ");
INSERT INTO jae_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Têna agêc tama sêjala gebe Apômtau tau gêjam gôliŋ biŋ tonec, tec Simson gêgôm nec atom, gebe gêdêŋ têm tonaŋ lau Pilisti sêjam gôliŋ lau Israel, tec Apômtau gesom intêna ênac siŋ êndêŋ êsêacŋa. ");
INSERT INTO jae_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Simson kasêp Timna gêja ma têna agêc tama sêwiŋ eŋ. Êsêac sêô lasê lau Timna nêŋ kôm wainŋa ma Simson gêŋô lewe wakuc kêlêŋêc luluŋ gebe êŋac eŋ. ");
INSERT INTO jae_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Mago Apômtaunê Ŋalau gêjam eŋ auc, tec eŋ kêkac lewe kêkôc kêtôm ŋac teŋ kêkac noniŋ ŋalatu kêkôc. Eŋ kêkôc gêŋ teŋ kêsêp lêma atom. Mago eŋ gêjac miŋ biŋ, taŋ eŋ gêgôm naŋ, gêdêŋ têna agêc tama atom. ");
INSERT INTO jae_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Go Simson gêja ma gêjam biŋgalôm gêwiŋ ŋapalêo ma têtac gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Bêc ŋagêdô gêjaŋa, go Simson gêmu gêja kêtiam gebe ênam eŋ êtu nê awê. Eŋ gêwi intêna siŋ ma kêsô gebe naênac lewe, taŋ eŋ gêjac êndu naŋ, kêsi e gêlic gêŋ kaiŋ teŋ, gebe kêtap lêp toŋabu sa gêc lewe ŋawêlêlaŋ. ");
INSERT INTO jae_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Eŋ kêgaiŋ lêp tau kêsêp lêma, go kêsêlêŋ ma geŋ gêŋ tau gêmoa intêna. Eŋ gêdêŋ têna agêc tama gêja jakêkêŋ lêp ŋagêdô gêdêŋ êsêagêc seŋ amboac tonaŋgeŋ. Êsêagêc seŋ lêp tau, mago Simson gêjac miŋ kêkôc lêp aŋga lewe ŋawêlêlaŋ ŋabiŋ gêdêŋ êsêagêc atom. ");
INSERT INTO jae_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Go tama kêsêp awê tau nê andu gêja, ma Simson geno moasiŋ teŋ aŋga tonaŋ, kêtôm lau wakuc sêgôm sêmoa. ");
INSERT INTO jae_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Gêdêŋ taŋ lau Pilisti sêlic eŋ naŋ, êsêac sêkôc lau wakuc 30 gebe sêmoa sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Ma Simson kêsôm gêdêŋ êsêac gebe “Aê gabe jasôm biŋgôliŋ teŋ êndêŋ amac. Amac embe atap biŋ tau ŋam sa êndêŋ moasiŋ tau ŋabêc 7 êmbacnê, go jakêŋ obo ŋajam 30 to ŋakwê omŋa 30 êndêŋ amac. ");
INSERT INTO jae_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Embe atap sa atom, go amac akêŋ obo ŋajam 30 to ŋakwê omŋa 30 êndêŋ aê.” Ma êsêac sêsôm gêdêŋ eŋ gebe “Ôsôm nêm biŋgôliŋ taumaŋ gebe aêac aŋô. ");
INSERT INTO jae_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Ma eŋ kêsôm gêdêŋ êsêac gebe “Gêŋ taniŋŋa kêsa aŋga ŋac-awa-geŋwagaŋa. Gêŋ ŋakana kêsa aŋga ŋactêkwanê.” Bêc têlêac gêjaŋa ma êsêac têtap biŋ tonaŋ ŋam sa atom. ");
INSERT INTO jae_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Gêdêŋ bêc kêtu aclêŋa êsêac sêsôm gêdêŋ Simsonnê awê gebe “Ôsôm biŋ banac-banac êndêŋ nêm akweŋ e êwa nê biŋgôliŋ ŋam sa êndêŋ aêac. Embe masi, oc akêŋ ja êniŋ tamamnê andu ma akêŋ aôm ôsa ja amboac tonaŋgeŋ. Amagêc akêŋ jaeŋ aêac gebe ajaŋgo aêacma gêŋ me.” ");
INSERT INTO jae_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Amboac tonaŋ Simsonnê awê gêdêŋ eŋ gêja tomatasulugeŋ ma kêsôm gebe “Aôm têmtac gêwiŋ aê atom, aôm têmtac gedec aê. Aôm kôsôm biŋgôliŋ gêdêŋ ŋoc lau, mago gôwa ŋam sa gêdêŋ aê atom.” Eŋ kêsôm gêdêŋ awê tau gebe “Ôlic acgom, aê kasôm biŋ teŋ gêdêŋ tinoc agêc tamoc atom. Ma jawa ŋam sa êndêŋ aôm êtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Eŋ kêtaŋ kêli eŋ kêtôm bêc samuc 7 e noc moasiŋŋa gêbacnê. Ma gêdêŋ bêc kêtu 7ŋa Simson gêwa biŋ tau ŋam sa gêdêŋ eŋ, gebe awê tau kêkac eŋ ŋapaŋ. Go awê tau jagêjac miŋ biŋ tau gêdêŋ nê lau. ");
INSERT INTO jae_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Tec gêdêŋ bêc kêtu 7ŋa gêdêŋ taŋ Simson gebe êsô nê balêm bêcŋa êna naŋ, lau malacŋa jasêsôm gêdêŋ eŋ gebe “Gêŋ ondoc ŋakana ŋajam kêlêlêc lêp. Gêŋ ondoc ŋatêkwa kêlêlêc lewe.” Simson gêjô êsêac aweŋ gebe “Amac embe akac nom ôkwi ŋa ŋoc bulimakao atom, oc ajala biŋ tau ŋam atom.” ");
INSERT INTO jae_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Go Apômtaunê Ŋalau mêŋgêjam eŋ auc e ôliwalô kêsa ma eŋ kêsêp gêja malac Askalon ma gêjac lau 30 êndu ma kêjaŋgo nêŋ ŋakwê omŋa jakêkêŋ gêdêŋ lau, taŋ sêwa ênê biŋgôliŋ ŋam sa naŋ. Go gêmu gêja tau nê malacmôkê totêtac ŋandaŋ secanô kêtu biŋ, taŋ kêtap eŋ sa naŋŋa. ");
INSERT INTO jae_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Go sêkêŋ nê awê gêdêŋ ŋac, taŋ Simson tau kêjaliŋ sa gebe êtu ênê ŋac êwa eŋ saŋa naŋ. saŋa kêpi bulimakaonê kom kêkac nom ôkwiŋa. ");
INSERT INTO jae_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Têm ŋagêdô gêjaŋa ma lau sêjac polom sa sêmoa, tec Simson gêja gebe êtu ŋacleŋ nê awê ma eŋ kêkôc noniŋ ŋalatu teŋ gêwiŋ. Go eŋ kêsôm gêdêŋ awê tama gebe “Aê gabe jasô ŋoc awênê balêm jana.” Mago eŋ tama gêlôc gebe eŋ êsô êna atom. ");
INSERT INTO jae_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Ênê tama kêsôm gêdêŋ Simson gebe “Aê gajam kauc gebe aôm têmtac gedec eŋ, tec kakêŋ eŋ gêdêŋ nêm ŋac. Mago lasio tec ŋajam kêlêlêc eŋ su, ônam eŋ êjômaŋ.” ");
INSERT INTO jae_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Simson kêsôm gêdêŋ êsêac gebe “Galoc embe jaŋgôm lau Pilisti sec, oc aêŋoc keso atom.” ");
INSERT INTO jae_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Tec gêja ma gêlô kêam saleŋŋa 300. Eŋ kêkôc luagêc-luagêc ma kêkic ŋalêŋuc tôŋ kêpi tageŋ ma kêsêmuŋ daweŋ kêsêp ŋasawa. ");
INSERT INTO jae_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Go eŋ kêtuŋ daweŋ ma gesoc kêam saleŋŋa sêlêti sêsêp lau Pilisti nêŋ kôm polomŋa sêja. Tec eŋ kêkêŋ polom, taŋ sêjac sa naŋ, to polom, taŋ gacgeŋ kêkô kôm naŋ, ja geŋ su gêwiŋ katêkwi to kôm wainŋa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Go lau Pilisti têtu kênac gebe “Asa gêgôm gêŋ tonaŋ.” Êsêac sêjô êsêac aweŋ gebe “Ŋac aŋga Timna nê lawa Simson. Eŋ gêgôm gêŋ tau gebe lawa laŋgwa kêkêŋ latuo gêdêŋ ênê ŋac.” Tec lau Pilisti sêkêŋ ja geŋ awê tau agêc tama to nêŋ lau su. ");
INSERT INTO jae_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Simson kêsôm gêdêŋ êsêac gebe “Aê jatôc lemoc gebe Amac embe aŋgôm gêŋ amboac tonaŋ, go jakac kamocgôc su acgom, go biŋ êmbacnê.” ");
INSERT INTO jae_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Eŋ gêjac êsêac secanô e nêŋ ŋatêkwa popocgeŋ su, go kêsêp jagêŋgôŋ pocgêsuŋ aŋga Etam. ");
INSERT INTO jae_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Lau Pilisti sêô lasê gamêŋ Juda to sê nêŋ becobo aŋga tônê ma sêjac siŋ gêdêŋ malac Lehi. ");
INSERT INTO jae_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Lau aŋga Juda têtu kênac êsêac gebe “Amac ajac siŋ gêdêŋ aêac kêtu asageŋŋa.” Êsêac sêjô êsêac aweŋ gebe “Aêac amêŋ gebe ansô Simson tôŋ ma aŋgôm gêŋ, taŋ eŋ gêgôm gêdêŋ aêac naŋ, êndêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Go lau 3,000 aŋga Juda sêsêp pocgêsuŋ aŋga Etam jasêsôm gêdêŋ Simson gebe” Aôm kôjala lau Pilisti sêjam gôliŋ aêac nec, me masi. Aôm gôgôm aêac amboac ondoc.” Eŋ gêjô êsêac aweŋ gebe “Gêŋ taŋ sêgôm gêdêŋ aê naŋgeŋ, tec gagôm gêdêŋ êsêac.” ");
INSERT INTO jae_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Êsêac sêsôm gêdêŋ eŋ gebe “Aêac amêŋ tonec gebe ansô aôm tôŋ ma akêŋ aôm ôsêp lau Pilisti lemeŋ.” Simson kêsôm gêdêŋ êsêac gebe “Atôc lemem êndêŋ aê acgom gebe amac taôm anac aê êndu atom.” ");
INSERT INTO jae_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Êsêac sêsôm gêdêŋ eŋ gebe “Masi, aêac ansô aôm tôŋgeŋ ma akêŋ aôm ôsêp lau Pilisti lemeŋ. Aêac anac aôm êndu atom.” Amboac tonaŋ êsêac sêsô eŋ tôŋ ŋa lêpoa wakuc luagêc, go sêwê eŋ aŋga pocgêsuŋ sêpi sêja. ");
INSERT INTO jae_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Gêdêŋ taŋ gêô lasê Lehi naŋ, lau Pilisti sêlêti dêdêŋ eŋ sêja tolasêgeŋ. Ma Apômtaunê Ŋalau gêjam Simson auc, ma lêpoa, taŋ sêsô eŋ tôŋ naŋ, gêŋgic amboac ja geŋ gam. ");
INSERT INTO jae_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Ma eŋ kêtap doŋki ŋasê wakuc teŋ sa, tec kêmêtôc lêma jakêkôc gêŋ tau sa ma gêjac lau 1,000 êndu ŋa gêŋ tau. ");
INSERT INTO jae_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Go Simson kêsôm gebe “Aê gaboa êsêac sa totoŋ-totoŋ ŋa doŋki ŋasê. Aê gajac lau 1,000 êndu ŋa doŋki ŋasê.” ");
INSERT INTO jae_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Kêsôm biŋ tau su, go kêbaliŋ ŋasê tau siŋ, tec sêsam gamêŋ tau gebe Ramat-Lehi. ");
INSERT INTO jae_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ma bu gêjô Simson ŋasec, tec awa gêjac Apômtau ma kêsôm gebe “Aôm kôkêŋ nêm sakiŋwaga aê kaku ŋacjo tulu ma galoc bu êjô aê êndu e jasêp lau samuc lemeŋ me.” ");
INSERT INTO jae_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Go Anôtô kêkêŋ gêsuŋ teŋ aŋga Lehi ma bu kêpulu kêpi aŋga nom mêŋSimson gênôm e têkwa saki kêsa kêtiam. Ma sêsam bumata tau gebe Hakore. Bumata tau kêpoac Lehi e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Ma Simson gêjam gôliŋ lau Israel kêtôm jala 20 gedeŋ lau Pilisti nêŋ têm. ");
INSERT INTO jae_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Simson gêdi aŋga ônê ma gêja Gasa. Eŋ gêlic mockaiŋo teŋ aŋga tônê ma kêsô ênê andu gêja. ");
INSERT INTO jae_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Lau Gasaŋa sêŋô Simson gêmoa nêŋ malac ŋawae, tec sêgi gamêŋ tau auc ma sêwa eŋ aŋga malac ŋasacgêdô gêdêŋ gêbêc samuc tonaŋ. Êsêac sêmoa gamêŋ gêmacgeŋ gêdêŋ gêbêc samuc ma sêsôm gêdêŋ tauŋ gebe “Aêac tansaê e êu bôŋ acgom, go tanac eŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Mago Simson gêc e gêjac ulugeŋ, go gêdi gêja e lêma kêsêp malac ŋakatam, go gêbuc katam to ŋaalê luagêc ma balaŋ to ŋagêŋlêlôm samob sa. Eŋ gêôc gêŋ tau kêsa magim ma kêbalaŋ kêpi lôc, taŋ kêkanôŋ Hebron naŋ, ŋatêpôê gêja. ");
INSERT INTO jae_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Tonaŋ su, go têtac gêwiŋ awê teŋ aŋga gaboaŋ Sorekŋa, ênê ŋaê gebe Delila. ");
INSERT INTO jae_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Lau Pilisti nêŋ laumata dêdêŋ awê tau sêja ma sêsôm gêdêŋ eŋ gebe “Ôsôm biŋ banac-banac êndêŋ eŋ e ôtap ênê ŋaclai ŋam sa, go ajala lêŋ êkôniŋ eŋ tôŋŋa ma ansô eŋ tôŋ e aku eŋ tulu. Aêac samob oc akêŋ mone silber 1,100 êndêŋ aôm êtôm aêacgeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Go Delila kêsôm gêdêŋ Simson gebe “Aê jateŋ aôm, ôwa nêm ŋaclai ŋam sa êndêŋ aêmaŋ. Lau teŋ embe taêŋ ênam gebe sênsô aôm tôŋ to sêku aôm tulu, oc sêŋgôm amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Simson gêjô eŋ awa gebe “Êsêac embe sênsô aê tôŋ ŋa talam ŋatikoc 7, taŋ ŋakeleŋ kêsa atom naŋ, go ŋoc ŋaclai ênaŋa ma jatôm lau ŋagêdô.” ");
INSERT INTO jae_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Amboac tonaŋ lau Pilisti nêŋ laumata sêkêŋ talam ŋatikoc 7, taŋ ŋakeleŋ kêsa atom naŋ, gêdêŋ Delila ma eŋ gêsô Simson tôŋ. ");
INSERT INTO jae_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Awê tau kêsiŋ lau sêmoa balêm teŋ ma gêmôêc gebe “O Simson, lau Pilisti sêmêŋ.” Mago eŋ kêmônaŋ tikoc gêŋgic amboac ja geŋ lêpoa. Amboac tonaŋ tec ênê ŋaclai ŋam kêsiŋ tau gêdêŋ êsêac ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ma Delila kêsôm gêdêŋ Simson gebe “Ôlic acgom, aôm kôsu aê susu to kôsôm biŋdansaŋ gêdêŋ aê. Aê jateŋ aôm gebe ôsôm êndêŋ aê acgom, lau sêkôc asageŋ, go sênsô aôm tôŋ.” ");
INSERT INTO jae_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Eŋ kêsôm gêdêŋ awê tau gebe “Embe sênsô aê tôŋ ŋa lêpoa matac, taŋ sêsô gêŋ teŋ atom naŋ, go ŋoc ŋaclai ênaŋa ma jatôm lau ŋagêdô.” ");
INSERT INTO jae_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Tec Delila kêkôc lêpoa wakuc ŋagêdô ma gêsô eŋ tôŋ. Su, go gêmôêc gebe “O Simson, lau Pilisti sêmêŋ.” Lau sêsaê sêmoa balêm teŋ. Mago eŋ kêmônaŋ lêpoa gêŋgic aŋga lêma amboac gam. ");
INSERT INTO jae_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Delila kêsôm gêdêŋ Simson gebe “Aôm kôsu aê susu to kôsôm biŋdansaŋ gêdêŋ aê e mêŋgêdêŋ galoc. Ôsôm êndêŋ aê acgom, lau sêkôc asageŋ ma sênsô aôm tôŋ.” Eŋ kêsôm gêdêŋ awê tau gebe “Aôm embe ônam ŋoc môkêclauŋ gêmôê 7 êwiŋ gam ŋagêdô ma wê tôŋ e ŋagêgêb ma ôkic tôŋ êpi bêlêm ka, go ŋoc ŋaclai ênaŋa ma jatôm lau ŋagêdô.” ");
INSERT INTO jae_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Gêdêŋ taŋ Simson gêc bêc naŋ, Delila gêjam môkêlauŋ gêmôê 7 gêwiŋ gam ŋagêdô ma gê e ŋagêgêb to kêkic tôŋ kêpi bêlêm ka ma gêmôêc gebe “Simson, lau Pilisti sêmêŋ.” Ma Simson gêdi to gê bêlêm to môkêlauŋ su. ");
INSERT INTO jae_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Tec awê tau kêsôm gêdêŋ eŋ gebe “Amboac ondoc tec kôsôm gebe ‘Aê têtac gêwiŋ aôm’, mago nêm ŋalêlôm gêwiŋ aê atom. Aôm kôsu aê susu kêtu dim têlêac ma gôwa nêm ŋaclai ŋam sa gêdêŋ aê atom tageŋ.” ");
INSERT INTO jae_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Awê tau kêtu Iêsu eŋ ŋapaŋ tobêc-tobêc. Eŋ kêkac eŋ e Simson ôli ŋakam ênê biŋ ma gebe êmac êndu. ");
INSERT INTO jae_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Ma kêtu ŋamu eŋ kêsôm nê ŋalêlôm lasê gêdêŋ awê tau gebe “Kapiŋ teŋ kêsac aê môkêcapac atomanô. Gêdêŋ taŋ tinoc kêkôc aê naŋ, aê katu Anôtônê ŋac dabuŋ teŋ. Embe sêkapiŋ aê môkêclauŋ, go ŋoc ŋaclai endec aê to ŋoc ŋajaŋa ênaŋa ma aê jatôm lau ŋagêdô samob.” ");
INSERT INTO jae_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Delila kêsaê gebe Simson kêsôm nê ŋalêlôm lasê gêdêŋ eŋ, tec kêkêŋ jaeŋ gêdêŋ lau Pilisti nêŋ laumata ma kêsôm gebe “Amu amêŋ dim tageŋ tonec êwiŋmaŋ. Eŋ kêsôm nê ŋalêlôm lasê gêdêŋ aê.” Go lau Pilisti nêŋ laumata sêpi dêdêŋ eŋ sêja tomonegeŋ. ");
INSERT INTO jae_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Delila gêôc Simson e gêc bêc gêsac ênê labum ma awê tau gêmôêc ŋac teŋ, gebe ênsêmbuŋ Simsonnê môkêlauŋ gêmôê 7 su. Ma Simson kêtu palê ma nê ŋaclai gêwi eŋ siŋ. ");
INSERT INTO jae_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Delila gêmôêc gebe “Simson, lau Pilisti sêmêŋ.” Tec eŋ gêdi sa ma taê gêjam gebe “Aê jamônaŋ tauc su, go jaêc jana êtôm têm ŋagêdô.” Eŋ gêjam kauc gebe Apômtau gêwi eŋ siŋ atom. ");
INSERT INTO jae_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Lau Pilisti sêkôc eŋ tôŋ ma sêkip eŋ matalakôp sa. Êsêac sejoŋ eŋ sêsêp Gasa sêja ma sêsô eŋ tôŋ ŋa kapoacwalô ki. Go sêkêŋ eŋ gêjam kôm kêlêsa polom popocŋa aŋga andu kapoacwalôŋa. ");
INSERT INTO jae_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Mago môkêlauŋ, taŋ sêsêbuŋ su naŋ, kêpuc kêtiam. ");
INSERT INTO jae_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Lau Pilisti nêŋ laumata sêkac tauŋ sa sebe sêkêŋ da êndêŋ nêŋ anôtô Dagon to sêlic nêŋ om têntac ŋajamŋa teŋ, gebe êsêac sêsôm gebe “Aêacnêŋ anôtô kêkêŋ nêŋ ŋacjo Simson kêsêp aêac lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Gêdêŋ taŋ lau sêlic nêŋ anôtô naŋ, êsêac sêlambiŋ eŋ ma sêsôm gebe “Aêacnêŋ anôtô kêkêŋ nêŋ ŋacjo, taŋ geseŋ aêac, nêŋ gamêŋ su to gêjac nêŋ lau taêsam êndu naŋ, kêsêp aêac lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Êsêac têtu samuc, tec sêsôm gebe “Amôêc Simson gebe êŋgôm biŋ makic êndêŋ aêac.” Amboac tonaŋ êsêac sêmôêc Simson aŋga kapoacwalô gêmêŋ, ma eŋ gêgôm biŋ makic gêdêŋ êsêac ma sêkêŋ eŋ kêkô andu ŋaalê poc ŋasawa. ");
INSERT INTO jae_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Ma Simson kêsôm gêdêŋ ŋapalê, taŋ kêkam eŋ lêma naŋ, gebe “Ôwê aê najamoasac alê, taŋ kêpuc andu tôŋ naŋ, gabe jajac alê tau.” ");
INSERT INTO jae_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Lauo to ŋacwaga taêsam ŋasec sêsô e andu tau gêlôc. Lau Pilisti nêŋ laumata sêmoa amboac tonaŋgeŋ ma lau amboac 3,000 sêkô salôm ŋaô sebe sêlic Simson gêgôm biŋ makic. ");
INSERT INTO jae_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Go Simson awa gêjac Apômtau ma kêsôm gebe “O Apômtau Anôtô, aê jateŋ aôm gebe taêm ênam aê. O Anôtô, aê jateŋ aôm gebe ôkêŋ ŋaclai êndêŋ aê dim tageŋ êtiam, gebe jakêŋ ŋagêjô êndêŋ lau Pilisti guluŋ tageŋ êjô matocanô luagêc su.” ");
INSERT INTO jae_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Simson kêmbôêŋ alêsêga luagêc, taŋ kêpuc andu tau tôŋ naŋ tôŋ, lêma anôŋa kêmbôêŋ alê teŋ ma gasêŋa kêmbôêŋ teŋ to kêsuc alê tau toŋajaŋageŋ ");
INSERT INTO jae_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","ma kêsôm gebe “Ôkêŋ aê jamac êndu jawiŋ Pilisti.” Go gewec ma kêsuc toŋajaŋageŋ e andu kêku sa ma kêkôniŋ laumata to lau ŋagêdô samob, taŋ sêmoa ŋalêlôm naŋ. Lau taŋ eŋ geseŋ êsêac su gêdêŋ têm gêmac ênduŋa naŋ, nêŋ namba kêlêlêc lau, taŋ eŋ gêjac êndu gêdêŋ têm gêmoa mata jaliŋa naŋ, ŋêŋgeŋ su. ");
INSERT INTO jae_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ênê lasitêwai to gôlôac samob sêsêp sêja sebe sêkôc ênê ŋawêlêlaŋ. Êsêac sêkôc ŋawêlêlaŋ tau sêpi sêja ma sêsuŋ eŋ aŋga Sora to Estaol ŋasawa kêsêp tama Manoa nê sêô. Eŋ gêjam gôliŋ lau Israel kêtôm jala 20. ");
INSERT INTO jae_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Gêdêŋ têm, taŋ gôliŋwaga sêjam gôliŋ gamêŋ naŋ, tôbôm teŋ kêsa. Ma ŋac teŋ aŋga Betlehem Judaiaŋa gêdi gebe naêŋgôŋ gamêŋ Moabŋa amboac ŋac jaba. Ênê awê to latuagêc sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ŋac tau nê ŋaê gebe Elimelek, nê awênê ŋaê Naomi ma latuagêcnêŋ ŋaê Malon agêc Kilion. Êsêac lau Epraim aŋga malac Betlehem Judaiaŋa. Êsêac jasêô lasê gamêŋ Moabŋa ma sêŋgôŋ tônê. ");
INSERT INTO jae_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ma Naominê akweŋ Elimelek gêmac êndu, ma awê tau to latuagêc gacgeŋ sêmoa. ");
INSERT INTO jae_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Êsêagêc sêjam lau Moab nêŋ awê, teŋ nê ŋaê gebe Orpa ma teŋ nê ŋaê Rut. Êsêac sêŋgôŋ gamêŋ tau amboac jala 10. ");
INSERT INTO jae_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malon agêc Kilion sêmac êndu lulugeŋ amboac tonaŋgeŋ, tec awê tau latuagêc ma nê akweŋ sêwi eŋ siŋ su ma taugeŋ gêmoa. ");
INSERT INTO jae_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Tec Naomi ma lawaoagêc dêdi sebe sêwi gamêŋ Moabŋa siŋ sêmu sêna ênê gamêŋ, gebe eŋ gêŋô ŋawae aŋga gamêŋ Moab, gebe Apômtau taê walô nê lau ma kêkêŋ mo gêdêŋ êsêac. ");
INSERT INTO jae_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Amboac tonaŋ eŋ gêdi aŋga malac, taŋ gêŋgôŋ naŋ, ma lawaoagêc sêwiŋ eŋ. Êsêac sêsêlêŋ sêsa intêna gamêŋ Judaiaŋa sêja. ");
INSERT INTO jae_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ma Naomi kêsôm gêdêŋ lawaoagêc gebe “Ajôc, agêc aêc amu andêŋ tenemiagêcnêŋ andu ana. Apômtau êmoasiŋ amagêc êtôm amagêc amoasiŋ aê to ŋoc ŋacmatê. ");
INSERT INTO jae_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Apômtau êkêŋ amagêc atap nêm ŋaciagêc sa ma alêwaŋ taôm aŋga êsêagêcnêŋ andu.” Go eŋ kêlêsôp êsêagêc aliŋanô. Êsêagêc têtaŋ lasê ");
INSERT INTO jae_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ma sêsôm gêdêŋ eŋ gebe “Masi, aêagêc abe awiŋ aôm tamu dandêŋ nêm lau tana.” ");
INSERT INTO jae_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Mago Naomi kêsôm gebe “O latucoagêc, amu anamaŋ. Amagêc abe awiŋ aê êtu asageŋŋa. Ŋapalê ŋagêdô sêc aê têtaclêlôm gebe jakôc têtu amagêcnêm ŋaciagêc me. ");
INSERT INTO jae_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","O latucoagêc, amu anamaŋ. Asa nêm lêŋ, gebe aê katu awêanô sugac, oc janam ŋac teŋ êtiam atom. Aê embe jasôm gebe aê taêc kêka ŋapalê ma aê embe jatap ŋoc akweŋ sa êndêŋ êmbêc tonec ma jakêkam ŋapalê, ");
INSERT INTO jae_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","amagêc oc aôŋ e êsêagêc têtu kapôêŋ me. Oc aŋgamiŋ taôm êndêŋ lêŋ sênam tauŋŋa me. O latucoagêc, masianô. Apômtau lêma mêŋkêtap aê sa, tec kêkêŋ wapac aê ŋanôgeŋ kêtu amagêcŋa.” ");
INSERT INTO jae_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Go êsêagêc têtaŋ lasê kêtiam ma Orpa kêlêsôp lawao laŋgwa alianô, mago Rut kêmbôêŋ eŋ tôŋ. ");
INSERT INTO jae_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ma Naomi kêsôm gêdêŋ eŋ gebe “Ôlic acgom, nêm boaluo gêmu gêdêŋ nê lau to nê anôtôi gêja. Ôndaŋguc nêm boaluo ômu ôna amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Mago Rut kêsôm gebe “Ôkac aê, gebe jawi aôm siŋ to jandaŋguc aôm êtiam atom nec atom. Gamêŋ taŋ aôm ôna naŋ, aê gabe jana. Gamêŋ taŋ aôm ôŋgôŋ naŋ, aê gabe jaŋgôŋ. Aômnêm lau têtu aêŋoc lau ma aômnêm Anôtô êtu aêŋoc Anôtô. ");
INSERT INTO jae_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gamêŋ taŋ aôm ômac êndu naŋ, aê gabe jamac êndu, ma sênsuŋ aê aŋga tonaŋ. Apômtau êwê aê êtôm eŋ taê gêjam, tageŋ gêmacanô taugeŋ tec êkac aê su aŋga aômnêm.” ");
INSERT INTO jae_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Gêdêŋ taŋ Naomi gêlic gebe awê tau taê gêjam kêtu tôŋ gebe êwiŋ eŋ, tec kêsôm biŋ teŋ kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Amboac tonaŋ tec agêc lulugeŋ sêsêlêŋ e jasêô lasê Betlehem. Sêô lasê Betlehem e malacm samob têtakê kêtu êsêagêcŋa ma lauo sêsôm gebe “Naomi tau tonec me.” ");
INSERT INTO jae_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Awê tau kêsôm gêdêŋ êsêac gebe “Naomi atom, asam aê gebe Mara, gebe Ŋaniniŋ Ŋatau kêkêŋ ŋamakic taêsam kêpi aê. ");
INSERT INTO jae_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Aê gawi ŋoc gamêŋ siŋ toawê tolêlôm, ma Apômtau gêwê aê gamu gamêŋ toŋalêlôm sawageŋ. Apômtau gêwa aê sa gebe gawê kaiŋ biŋ ma Ŋaniniŋ Ŋatau kêlêsu aê, tec asam aê Naomi kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi agêc lawao Moabo Rut sêmu sêmêŋ aŋga gamêŋ Moabŋa ŋamiŋ tau tonaŋ. Êsêagêc jasêô lasê Betlehem gêdêŋ taŋ lau sêkôc kôm sêjac polomŋa sa. ");
INSERT INTO jae_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ma Naominê akweŋnê lasitêwa teŋ gêmoa. Eŋ ŋac tolêlôm aŋga Elimeleknê gôlôacnêŋ. Ênê ŋaê Boas. ");
INSERT INTO jae_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ma Moabo Rut kêsôm gêdêŋ Naomi gebe “Ôlôc ma jana kôm najajoŋ polom ŋasaliŋ-saliŋ sa jandaŋguc lau, taŋ sêlic aê ŋajam ma têtiŋ aê atom naŋ.” Ma Naomi kêsôm gêdêŋ eŋ gebe “Latucoenec, ônamaŋ.” ");
INSERT INTO jae_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tec gêdi jakejoŋ polom ŋasaliŋ-saliŋ aŋga kôm teŋ kêdaguc lau-sêsapwaga. Ma kôm tau tonaŋ Boasnê. Eŋ Elimeleknê gôlôacnêŋ ŋac teŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Gêdêŋ tonaŋgeŋ Boas mêŋgêô lasê kôm. Eŋ awa gêjac lau-sêsapwaga gebe “Apômtau êwiŋ amac.” Ma êsêac sêjô eŋ awa gebe “Apômtau ênam mec aôm.” ");
INSERT INTO jae_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Go Boas kêsôm gêdêŋ nê sakiŋwaga, taŋ gejob lau-sêsapwaga naŋ, gebe “Asanê ŋapalêo tônê.” ");
INSERT INTO jae_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ma sakiŋwaga, taŋ gejob lau-sêsapwaga naŋ, gêjô eŋ awa gebe “Eŋ Moab ŋapalêo, taŋ gêwiŋ Naomi aŋga gamêŋ Moabŋa gêmêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Awê tau kêsôm gebe ‘Aê jateŋ gebe alôc gebe jajoŋ polom ŋasaliŋ-saliŋ jamoa lagic ŋasawa jandaŋguc lau-sêsapwaga.’ Amboac tonaŋ tec gêmêŋ ma gêjam kôm ŋapaŋ gêdêŋ bêbêc kanucgeŋ e mêŋgêdêŋ galoc ma kêlêwaŋ tau ŋagec atom.” ");
INSERT INTO jae_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Go Boas kêsôm gêdêŋ Rut gebe “Latucoenec, ôkêŋ taŋam aê acgom. Ojoŋ polom aŋga kôm teŋ ma ôwi tonec siŋ atom. Ôwiŋ aêŋoc sakiŋwagao baŋbaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ma matam êsap kôm, taŋ êsêac sêsap sêmoa naŋ, ma ôndaŋguc êsêacgeŋ. Aê gajac biŋsu sakiŋwaga gebe sêlênsôŋ aôm atom. Bu embe êjô aôm, go ôndêŋ ku naônôm bu, taŋ sakiŋwaga têtê naŋ.” ");
INSERT INTO jae_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Go Rut gêu tau laŋôanô jagêdêŋ nom ma kêsôm gêdêŋ Boas gebe Aê awê jabao nec gajac matamanô ŋajam ma matam gêdiŋ aêgeŋ kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas gêjô eŋ awa gebe “Gêŋ samob, taŋ aôm gôgôm gêdêŋ lawamo laŋgwa gêdêŋ taŋ nêm akweŋ gêmac êndu e mêŋgêdêŋ galoc naŋ, sêjac miŋ gêdêŋ aê tomalageŋ. Aôm gôwi tênam agêc tamam to nêm malacmôkê siŋ mêŋgô lasê gamêŋ teŋ, taŋ gêmuŋgeŋ gôjam kauc naŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Apômtau êmoasiŋ aôm êjô gêŋ, taŋ gôgôm naŋ, ma Apômtau Israelnêŋ Anôtô, taŋ gôê lamu ênê magê gômôêŋ tonec naŋ, êkêŋ moasiŋ totau-totau êndêŋ aôm êjô. ");
INSERT INTO jae_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Go awê tau kêsôm gebe “O ŋoc apômtau, aôm kômoasiŋ aê ŋanô to gôjac aê têtac tôŋ. Aômnêm sakiŋwagao ŋanô teŋ aê atom, mago kôsôm biŋ ŋajamgeŋ gêdêŋ nêm sakiŋwagao aê.” ");
INSERT INTO jae_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Gêdêŋ noc sêniŋ gêŋŋa Boas kêsôm gêdêŋ awê tau gebe “Ômôêŋ mêŋôniŋ polom ma ôsac nêm polom ŋagêdô tôŋ êsêp wain.” Amboac tonaŋ Rut gêŋgôŋ gêwiŋ lau-sêsapwaga ma Boas kêkêŋ polom sigob gêdêŋ eŋ geŋ. Ma awê tau geŋ e gêôc eŋ tôŋ ma ŋagêdô gacgeŋ kêkô. ");
INSERT INTO jae_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Gêdêŋ taŋ awê tau gêdi gebe ejoŋ polom ŋasaliŋ-saliŋ naŋ, Boas gêlêŋ biŋ nê sakiŋwaga gebe Andec eŋ ejoŋ polom êmoa lagic ŋasawa ma anac jao êndêŋ eŋ atom. ");
INSERT INTO jae_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ma ataiŋ ŋakaiŋ ŋagêdô su aŋga lagic ma awi siŋ ênêc, gebe eŋ ejoŋ sa ma aec biŋ eŋ atom.” ");
INSERT INTO jae_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Amboac tonaŋ tec kejoŋ gêmoa e kêtula, go kêsêlô polom, taŋ kejoŋ sa naŋ, e ŋadôŋ amboac talu tageŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ma eŋ kêkôc ŋanô tau sa gêja malac jakêtôc gêŋ, taŋ kejoŋ sa naŋ, gêdêŋ lawao laŋgwa ma kêkôc gêŋ, taŋ geŋ e gêôc eŋ tôŋ naŋ, ŋagêdô jakêkêŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ma lawao laŋgwa kêsôm gêdêŋ eŋ gebe “Ocsalô tonec aôm kojoŋ polom ŋasaliŋ-saliŋ sa aŋga ondoc ma gôjam kôm gômoa ondoc. Anôtô ênam mec ŋac, taŋ mata gêdiŋ aôm naŋ.” Tec Rut gêjac ŋac, taŋ gêjam ênê kôm naŋ, nê miŋ gêdêŋ lawao laŋgwa ma kêsôm gebe “Ŋac taŋ gajam kôm gawiŋ eŋ gêdêŋ ocsalô tonec naŋ, nê ŋaê Boas.” ");
INSERT INTO jae_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Go Naomi kêsôm gêdêŋ lawao gebe “Apômtau taŋ kêgamiŋ nê moasiŋ gêdêŋ lau mateŋ jali to ŋacmatê atom naŋ, anam mec eŋ.” Naomi kêsôm biŋ tonec gêdêŋ eŋ gêwiŋ gebe “Ŋac tau aêagêcnêŋ lasitêwainêŋ teŋ eŋ kêtu aêacnêŋ nomlênsêm ŋakêsiwaga teŋ gêwiŋ.” ");
INSERT INTO jae_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ma Moabo Rut kêsôm gebe “Eŋ kêsôm biŋ teŋ gêdêŋ aê gêwiŋ gebe ‘Ôsap ŋoc sakiŋwagao tôŋ ŋapaŋ e sênac ŋoc kôm ŋanô samob sa êmbacnê.’” ");
INSERT INTO jae_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ma Naomi kêsôm gêdêŋ lawao Rut gebe “O latucoenec, ŋajam gebe ôsêlêŋ ôwiŋ ênê sakiŋwagao, gebe teŋ êlênsôŋ aôm aŋga kôm ŋagêdô atom.” Amboac tonaŋ Rut kejoŋ polom ŋasaliŋsaliŋ sa kêsap Boasnê sakiŋwagao tôŋ ŋapaŋ e sêjac polom to polom sa gêbacnê. Ma eŋ gêŋgôŋ gêwiŋ lawao laŋgwa. lasitêwainêŋ nomlênsêm, gebe lau jaba sêjaŋgo su atom. ");
INSERT INTO jae_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Go Rut lawao laŋgwa Naomi kêsôm gêdêŋ eŋ gebe “Latucoenec, amboac ondoc aê oc jansom nêm malam ôŋgôŋ ŋajamŋa teŋ, gebe ômoa ŋajamgeŋ me. ");
INSERT INTO jae_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Boas taŋ gôwiŋ ênê sakiŋwagao naŋ, aêacnêŋ lasitêwainêŋ teŋ eŋ. Ôlic acgom, êmbêc tonec eŋ oc ekoloŋ polom ŋapa aŋga gamêŋ sêka polomŋa. ");
INSERT INTO jae_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Amboac tonaŋ ôliŋ bu to ôniŋ oso taôm ma ôsô nêm ŋakwê ŋajam tau, go ôsêp ôna gamêŋ sêka polomŋa. Mago ôtôc taôm ôndêŋ ŋac tau atom e êniŋ to ênôm gêŋ êmbacnê acgom. ");
INSERT INTO jae_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ma êndêŋ taŋ eŋ êsa tau sic naênêc naŋ, matam êndiŋ gamêŋ, taŋ eŋ gêc naŋ, naôkac belaŋke akaiŋŋa sa ma ôsa taôm sic. Go eŋ êsôm gêŋ, taŋ eŋ gebe êŋgôm naŋ, êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ma awê tau gêjô Naomi awa gebe “Biŋ samob, taŋ kôsôm naŋ, oc jaŋgôm.” ");
INSERT INTO jae_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Amboac tonaŋ eŋ kêsêp gamêŋ sêka polomŋa gêja ma gêgôm kêtôm biŋ, taŋ lawao laŋgwa kêsôm gêdêŋ eŋ naŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas geŋ to gênôm gêŋ su, go gêmoa totêtac ŋajamgeŋ jakêsa tau sic gêc polom totoŋ ŋamagê. Go awê tau kêsêlêŋ sacgeŋ-sacgeŋ gêdêŋ eŋ gêja ma kêkac belaŋke akaiŋŋa sa, go kêsa tau sic gêc. ");
INSERT INTO jae_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Gêdêŋ gêbêcauc ŋaluŋ, go ŋac tau kêtakê ma kêkac tau ôkwi e gêlic awê teŋ gêc eŋ akaiŋŋa. ");
INSERT INTO jae_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Eŋ kêtu kênac gebe “Aôm asa.” Ma awê tau gêjô eŋ awa gebe “Nêm sakiŋwagao aê Rut. Ôlam nêm obo mêŋênsaŋ nêm sakiŋwagao, gebe aôm kôtu aêacma nom lênsêm ŋakêsiwaga.” ");
INSERT INTO jae_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ma eŋ kêsôm gebe “O latucoenec, Apômtau ênam mec aôm, gebe aôm gôgôm gêŋlêlôm gêdêŋ lau tolêlôm me lau ŋalêlôm sawa nêŋ ŋapalê wakuc atom. Biŋ tonec kêtu aôm têmtac gêwiŋ ŋanô ŋabelo kapôêŋ kêlêlêc belo ŋamataŋa su. ");
INSERT INTO jae_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Latucoenec, amboac tonaŋ tec ôtêc taôm atom. Aê oc jaŋgôm gêŋ samob, taŋ oteŋ naŋ, gebe aêŋoc lau Betlehemŋa samob sêlicgac, gebe aôm awê mansaŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ma galoc, biŋŋanô, nêm nomlênsêm ŋakêsiwaga teŋ aê, mago nom lênsêm ŋakêsiwaga ŋanô teŋ gêmoa. ");
INSERT INTO jae_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ômoa êmbêc tonec ma êndêŋ bêbêcgeŋ eŋ embe ênam kôm, taŋ gêjac nom lênsêm ŋakêsiwaga ŋawae naŋ, oc ŋajam, êŋgômmaŋ. Mago eŋ embe endec ma ênam kôm tau atom, naŋgo aê janam kôm, taŋ gêjac nom lênsêm ŋakêsiwaga ŋawae naŋ. Aê jasôm biŋ êtu tôŋ êtôm Apômtau gêmoa mata jali. Ônêc bêc e eleŋŋa acgom.” ");
INSERT INTO jae_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Go Rut gêc bêc gêc Boas akaiŋŋa e geleŋ mata, go eŋ gêdi gêdêŋ taŋ lau sêlic tauŋ sapu-sapu naŋ. Boas taê gêjam gebe awê tau gêc sêka polom ŋamala nec ŋapuc êsa atommaŋ, ");
INSERT INTO jae_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","tec kêsôm gebe “Ôkôc obo, taŋ kôgadê naŋ, mêŋôlam.” Ma Rut gêlam obo, go eŋ gêjam dôŋ polom laclu 6 jakêsêwa kêsêp obo tau ma kêkêŋ gêdêŋ awê tau gêôc sa ma gêc gêja malac. ");
INSERT INTO jae_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Eŋ jagêô lasê andu ma lawao gêjam kênac eŋ gebe “Latucoenec, biŋ amboac ondoc.” Go Rut gêjac miŋ biŋ samob, taŋ ŋac tau gêgôm gêdêŋ eŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ma kêsôm gebe “Polom laclu 6 tonec eŋ kêkêŋ gêdêŋ aê ma kêsôm gebe ‘Ôêc tolêmam sawageŋ ôndêŋ lawamo ôna atom.” ’ ");
INSERT INTO jae_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Rut lawao gêjô eŋ awa gebe “Latucoenec, ônsaê malôgeŋ e ôjala biŋ tau êtu katô acgom, gebe ŋac tonaŋ oc êwi biŋ tau siŋ atom, ocsalô oc êmansaŋ biŋ tau êtu solop.” lasitêwainêŋ awêtuc. ");
INSERT INTO jae_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ma Boas kêpi malac ŋasacgêdô gêja jagêŋgôŋ tonaŋ. Gêŋgôŋ ma gêlic nom ŋakêsiwaga, taŋ Boas kêsôm ênê biŋ naŋ, kêsêlêŋ gêmêŋ. Tec Boas kêsôm gebe “O ŋoc ŋac, ômôêŋmaŋ, mêŋôŋgôŋ sic ôŋgôŋ tonec.” Ma eŋ jagêŋgôŋ sic gêwiŋ Boas. ");
INSERT INTO jae_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Go eŋ kêkalem lau mata 10 aŋga malac ma kêsôm gebe “Mêŋaŋgôŋ tonec.” Ma êsêac jasêŋgôŋ sic. ");
INSERT INTO jae_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Go Boas kêsôm gêdêŋ nom ŋakêsiwaga tau gebe “Naomi taŋ aŋga Moabnêŋ gamêŋ gêmu gêmêŋ naŋ, kêkêŋ aêagêcnêŋ ŋac Elimelek nê nom ŋamakeŋ gebe lau sênam ôli. ");
INSERT INTO jae_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Amboac tonaŋ tec taêc gêjam gebe jakêŋ ŋawae êndêŋ aôm ma jasôm gebe ‘Ônam ôli nom tau ma lau, tec sêŋgôŋ nec, to ŋoc launêŋ laumata sêlic. Aôm embe ôsi nom tau su, go ôsi su. Mago embe masi, go ôsôm biŋ katô aê gebe jajala, gebe nom ŋakêsiwaga teŋ gêmoa atom, aôm taômgeŋ, ma aê kadaguc aôm.’” Ma ŋac tau kêsôm gebe “Aê gabe jasi nom tau su.” ");
INSERT INTO jae_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Go Boas kêsôm gebe “Êndêŋ bêc, taŋ ônam ôli nom su aŋga Naomi lêma naŋ, ônam ôli ŋac gêmac nê awêtuc Moabo Rut êwiŋ, gebe daôŋ ŋac gêmac nê ŋaê sa êpi ênê nomlênsêm êtiam.” ");
INSERT INTO jae_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Go nom ŋakêsiwaga kêsôm gebe “Embe amboac tonaŋ, go aê oc jatôm gebe jasi nom su êtu ŋoc gêŋ atom. Embe jasi su, go jajaiŋ tauc ŋoc nomlênsêm. Aôm taôm ôsi nom tau su ôjô aê, gebe aê katôm gebe jasi su atom.” ");
INSERT INTO jae_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Gêdêŋ andaŋgeŋ lau Israel nêŋ mêtê laŋgwa teŋ amboac tonec gêc, gebe ŋac teŋ embe êsi nom su me êkên gêŋ êjô gêŋ teŋ, go ênu atapa teŋ su ma êkêŋ andêŋ nê ŋac teŋ. Mêtê tonaŋ gêwa sa gebe geŋ, taŋ sêgôm naŋ, kêtu tôŋgac. ");
INSERT INTO jae_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Amboac tonaŋ gêdêŋ taŋ nom ŋakêsiwaga kêsôm gedeŋ Boas gebe “Aôm taôm ônam ôli nom tau naŋ,” eŋ gênu atapa teŋ su. ");
INSERT INTO jae_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ma Boas kêsôm gêdêŋ laumata to lau samob gebe “Ocsalô tonec amac samob alic su, gebe aê gajam ôli Elimeleknê gêŋ samob ma Kilion agêc Malon nêŋ gêŋ samob su aŋga Naomi lêma. ");
INSERT INTO jae_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ma gajam ôli Malonnê awêtuc Moabo Rut amboac tonaŋ, gebe êtu ŋoc awê, gebe jaôŋ ŋac gêmac tau nê ŋaê sa êpi ênê nomlênsêm, gebe sênac ŋac gêmac nê ŋaê êŋgic aŋga nê lasitêwainêŋ to aŋga nê malacmôkê ŋasacgêdô atom. Ma amac atu aêŋoc lau-awa-biŋ-sawaga.” ");
INSERT INTO jae_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Go lau samob, taŋ sêŋgôŋ sacgêdô naŋ, to laumata sêsôm gebe “Aêac alic gêŋ tau sugac. Apômtau êkêŋ awê tau, taŋ êpi nêm andu naŋ, êtôm Rahel agêc Lea, taŋ sêboa gôlôac Israel sa sêwiŋ tauŋ naŋ. Ôtu ŋac tolêlôm aŋga Eprata ma nêm waem êsa aŋga Betlehem. ");
INSERT INTO jae_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ma nêm wakuc, taŋ Anôtô êkêŋ awê matac tau êkôc naŋ, sêkêŋ nêm gôlôac têtôm Peresnê, taŋ Tamar kêkôc kêtu Juda latu naŋ.” ");
INSERT INTO jae_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Amboac tonaŋ tec Boas gêjam Rut kêtu nê awê. Eŋ gêmoa gêwiŋ eŋ e Apômtau kêkêŋ eŋ taê ma kêkôc latu teŋ. ");
INSERT INTO jae_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Go lauo sêsôm gêdêŋ Naomi gebe “Talambiŋ Apômtau, taŋ kêgamiŋ nom ŋakêsiwaga gêdêŋ aôm atom naŋ. Lau Israel sêŋgôm ênê ŋaê ŋawae êsa. ");
INSERT INTO jae_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Eŋ oc êlau aôm têkwam saki êsa ma êndêŋ taŋ ôtu awêanô naŋ, eŋ êlôm aôm, gebe lawamo, taŋ têtac gêwiŋ aôm to gêjac matamanô ŋajam kêlêlêc latômi 7 su naŋ, kêkôc eŋ.” ");
INSERT INTO jae_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Go Naomi kêsip ŋapalê tau sa mêŋketoc eŋ gêsac labum ma kêtu ênê jaomwagao. ");
INSERT INTO jae_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ma nê lauo jabaŋ eŋŋa sê ênê ŋaê teŋ gebe “Naomi kêtap latu teŋ sa.” Ma sêsam eŋ gebe Obed. Eŋ Dawid tama Isai nê tama. ");
INSERT INTO jae_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peresnê wakuc tau tonec. Peres kêka Hesron lasê. ");
INSERT INTO jae_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron kêka Ram lasê, Ram kêka Aminadab lasê. ");
INSERT INTO jae_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab kêka Nason lasê, Nason kêka Salmon lasê, ");
INSERT INTO jae_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon kêka Boas lasê, Boas kêka Obed lasê, ");
INSERT INTO jae_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed kêka Isai lasê, ma Isai kêka Dawid lasê. ");
INSERT INTO jae_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Ŋac teŋ gêmoa malac Ramataim. Eŋ ŋac Supŋa aŋga Epraim ŋagamêŋ lôcŋa, nê ŋaê Elkana. Eŋ Jeroham latu, naŋ Elihu latu, naŋ Tohu latu, naŋ Sup latu, êsêacnêŋ ŋam gêc Epraimŋa. ");
INSERT INTO jae_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Eŋ gêjam awê luagêc, teŋ nê ŋaê Hana ma teŋ nê ŋaê Penina. Penina kêkôc gôlôac ma Hana eŋ awê kapoac. ");
INSERT INTO jae_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ŋac tonaŋ aŋga nê malac kêpi gêja Silo kêtôm jalageŋ gebe eteŋ mec to êkêŋ da êndêŋ lau siŋ undambêŋa nêŋ Apômtau. Eli latuagêc Hopni agêc Pinehas têtu Anôtônê dabuŋwaga aŋga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Gêdêŋ bêc, taŋ Elkana kêkêŋ da naŋ, eŋ kêkêŋ da ŋagêdô-gêdô gêdêŋ Penina ma latuio to ŋac. ");
INSERT INTO jae_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Eŋ têtac gêwiŋ Hana, mago kêkêŋ ŋamêsôm ŋagêdô tageŋgeŋ gêdêŋ eŋ ŋam gebe Apômtau gêbôc têtaclêlôm auc gebe êkôc gôlôac atom. ");
INSERT INTO jae_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Tec anao kêkôc biŋkalom gebe êŋgôm eŋ maja êsaŋa gebe Apômtau gêbôc eŋ auc. ");
INSERT INTO jae_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Kêtôm jalageŋ gêŋ tonaŋ kêtap Hana sa. Kêtôm têm samob êsêac sêpi Apômtaunê lôm dabuŋ sêja naŋ, anao kêkôc biŋkalom eŋ ŋapaŋ. Tec Hana kêtaŋ ŋanô ma gedec gebe êniŋ gêŋ. ");
INSERT INTO jae_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Go nê akweŋ Elkana kêsôm gêdêŋ eŋ gebe “Hana, aôm kôtaŋ ma goeŋ gêŋ atom nec ŋam amboac ondoc. Nêm ŋalêlôm ŋawapac kêtu asageŋŋa. Aôm gôlic aê ŋajam kalêlêc latômi 10 su atom me.” ");
INSERT INTO jae_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Gêdêŋ taŋ seŋ to sênôm gêŋ su acgom, go Hana gêdi tonê ŋalêlôm ŋawapacgosu jakêkô Apômtau laŋônêmŋa ma keteŋ mec gêdêŋ eŋ to kêtaŋ ŋanô. Gêdêŋ tonaŋ dabuŋwaga Eli gêŋgôŋ nê lêpôŋ kêsi Apômtaunê lôm ŋakatam. ");
INSERT INTO jae_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Ma Hana gêjac mata biŋ teŋ ma kêsôm gebe “Lau siŋ undambêŋa nêŋ Apômtau, aôm embe taêm walô nêm sakiŋwagao aê to taêm ênam aê ma ôliŋ aê siŋ atom, ma ôkêŋ ŋapalê ŋac teŋ êndêŋ nêm sakiŋwagao aê, go jansuŋ ŋapalê tau samucgeŋ êndêŋ Apômtau wacêmoa êtu ênê gêŋ e êmac êndu, ma kekec teŋ oc êsac môkêlauŋ atomanô.” ");
INSERT INTO jae_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Eŋ keteŋ mec ŋasawa ec baliŋ gêmoa Apômtau laŋônêmŋa. Gêdêŋ tonaŋ Eli mata gê eŋ gêdôôlic. ");
INSERT INTO jae_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hana keteŋ mec gêc lêlômgeŋ, ma gêdôôlic kêboa-kêboa, mago sêŋô awa atom. Tec Eli gêjam kauc gebe gêŋ kêjaŋiŋ awê tau. ");
INSERT INTO jae_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Ma kêsôm gêdêŋ Hana gebe “Êndêŋ ondoc nêm meloc gêŋ kêjaŋiŋ aômŋa êmbacnê. Ôwi wain meloc tonaŋ siŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hana gêjô eŋ awa gebe “O ŋoc apômtau, amboac tonaŋ atom. Aê awê gêŋwapac kêkôniŋ aê tôŋŋa. Aê ganôm wain to gêŋ kêjaŋiŋŋa teŋ atom. Aê kasêwa ŋoc ŋalêlôm sa gêdêŋ Apômtau tau. ");
INSERT INTO jae_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ôlic nêm sakiŋwagao aê amboac awê sec atom. Gêdêŋ ŋasawa tonec aê kasôm ŋoc ŋalêlôm ŋawapac to kêbuli aucŋa lasê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Go Eli gêjô eŋ awa gebe “Ôna totêmtac malôgeŋ ma Israelnêŋ Anôtô oc êŋgôm biŋ, taŋ koteŋ naŋ, ŋanô êsa.” ");
INSERT INTO jae_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hana kêsôm gebe “Ôlic nêm sakiŋwagao aê ŋajammaŋ.” Go eŋ gêc gêja ma geŋ gêŋ totêtac kêpa sugeŋ. ");
INSERT INTO jae_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Bêbêc kanucgeŋ êsêac dêdi ma teteŋ mec gêdêŋ Apômtau. Su acgom, go sêmu sêja malac Rama kêtiam. Elkana gêmoa gêwiŋ nê awê Hana ma Apômtau taê gêjam eŋ. ");
INSERT INTO jae_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Tec Hana kêkêkam ŋapalê ma gêdêŋ ŋanoc eŋ kêkôc ŋapalê ŋac teŋ ma gê ênê ŋaê Samuel. Samuel ŋam gebe “Aê kateŋ eŋ aŋga Apômtaunê.” ");
INSERT INTO jae_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Gêdêŋ taŋ Elkana to nê gôlôac samob sêpi sêja kêtiam gebe êkêŋ da jalaŋa êndêŋ Apômtau to êŋgôm nê biŋ gêjac mataŋa ŋanô êsa naŋ, ");
INSERT INTO jae_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hana gêwiŋ atom. Eŋ kêsôm gêdêŋ nê akweŋ gebe “Ŋapalê êwi su siŋ acgom, go aê japi ma jakôc eŋ êwiŋ gebe eŋ êkô Apômtau laŋônêmŋa ma êmoa êwiŋ eŋ endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Ma ênê akweŋ Elkana gêjô eŋ awa gebe “Ôŋgôm êtôm biŋ, taŋ aôm taêm gêjam gebe ŋajam naŋ. Ômoa e ŋapalê êwi su siŋ acgom. Tageŋ Apômtau êŋgôm nê biŋ ŋanô êsa.” Amboac tonaŋ awê tau gêmoa nê andu ma kêkêŋ su gêdêŋ ŋapalê e gêwi siŋ. ");
INSERT INTO jae_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Ŋapalê gêwi su siŋ, go Hana kêkôc eŋ agêc sêpi sêja. Ma kêkôc bulimakao kapoac, taŋ ŋajala têlêac naŋ teŋ ma polom matac suc teŋ ma bôc ŋaôlic teŋ towain. Ŋapalê tau sauŋgeŋ ma têna kêkôc eŋ gêja Apômtaunê lôm dabuŋ aŋga Silo. ");
INSERT INTO jae_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Sêjac bulimakao tonaŋ êndu ma sêkôc ŋapalê tau gêdêŋ Eli. ");
INSERT INTO jae_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Hana kêsôm gêdêŋ eŋ gebe “O ŋoc ŋatau, aê jasôm biŋŋanôgeŋ êndêŋ aôm gebe aê awê tau, taŋ kakô aôm laŋônêm ma kateŋ mec gêdêŋ Apômtau naŋ tonec. ");
INSERT INTO jae_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Aê kateŋ kêtu ŋapalê tecenecŋa ma Apômtau kêkêŋ taŋa aê ma gêgôm ŋoc mec ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Kêtu tonaŋŋa aê gasuŋ eŋ gêdêŋ Apômtau. Eŋ êtu ênê gêŋ e êmac êndu.” Go êsêac teteŋ mec gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Go Hana keteŋ nê mec amboac tonec gebe “Ŋoc ŋalêlôm kêtu samuc Apômtau aê têtac kêpa su kêtu Apômtauŋa. Aê aocsuŋ kêsu ŋoc soŋo-soŋo susu gebe aê katu samuc kêtu aôm gôjam aê saŋa. ");
INSERT INTO jae_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","“Ŋac dabuŋ teŋ kêtôm Apômtau gêmoa atom. Apômtau teŋ gêmoa atom, aôm taômgeŋ. Lamuanô teŋ kêtôm aêacma Anôtô gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Asôm biŋ tembelem aŋgeŋ teŋ êtiam atom. Biŋ atoc taôm saŋa êsa awemsuŋ atom, gebe Apômtau eŋ Anôtô kêjala gêŋŋa ma eŋ gêjam dôŋ ŋamalac nêŋ kôm. ");
INSERT INTO jae_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Lau ŋactêkwa nêŋ talam tulu, mago lau palê-palê sêjandiŋ ŋaclai sa. ");
INSERT INTO jae_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Êsêac taŋ sêŋgôŋ nêŋ masê ŋaô su naŋ, sesom kôm gebe têtap gêŋ sêniŋŋa ŋagec-ŋagec sa. Ma êsêac, taŋ gêŋ gêjô êsêac su naŋ, galoc gêŋ gêôc êsêac tôŋ. Awê kapoac kêkôc ŋapalê 7, mago awê, taŋ kêkôc gôlôac taêsam naŋ, nê ôli kêmêliŋ. ");
INSERT INTO jae_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Apômtau gêjac êndu to gêŋu mata jali kêsa. Eŋ gêwê lau sêsêp lamboam sêja ma gêwê êsêac sêpi sêmêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Apômtau kêkêŋ lau ŋagêdô têtu lau ŋalêlôm sawa ma ŋagêdô lau tolêlôm. Eŋ kêkôniŋ ma ketoc sa. ");
INSERT INTO jae_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Eŋ kêsip lau ŋalêlôm sawa sa aŋga kekop ma gêôc lau sêpô lênawaga sa aŋga waomôkê, gebe kêkêŋ êsêac sêŋgôŋ sêwiŋ gôliŋwaga towae ma sêwê kaiŋ lêpôŋ tetoc lau saŋa. Gebe Apômtau kêtu nom ŋaalê ŋatau ma kêkwê nom kêkô alê tau ŋaô. ");
INSERT INTO jae_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","“Eŋ oc ejop nê lau dabuŋ eŋkaiŋ, mago lau alôb-alôb oc sênaŋa sêmoa ŋakesec ŋalêlôm gebe ŋac teŋ etoc tau sa êtu tau nê ŋaclaiŋa atom. ");
INSERT INTO jae_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Apômtau oc êtuc nê ŋacjo popoc ma Lôlôc Ŋatau êkêŋ wapap ênac aŋga undambê. Apômtau oc êmêtôc nom e naêndêŋ ŋamadiŋ. Eŋ oc êkêŋ ŋajaŋa êndêŋ nê kiŋ ma oc etoc nê ŋac-geŋ-oso-eŋwaga nê ŋaclai sa.” ");
INSERT INTO jae_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Go Elkana gêmu gêja nê malac Rama kêtiam gêwiŋ nê gôlôac samucgeŋ, ma ŋapalê tau gêjam sakiŋ Apômtau gêmoa dabuŋwaga Eli laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Eli latuagêc sêgôm gêŋ wauc-waucboa, êsêagêc sêwi Apômtau auc. ");
INSERT INTO jae_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Ma sêgêli ŋagôliŋ dabuŋwagaŋa amboac tonaŋgeŋ. Gêdêŋ taŋ ŋac teŋ kêkêŋ da gêmoa naŋ, dabuŋwaga nê sakiŋwaga mêŋgêô lasê tosala ŋamata têlêac. ");
INSERT INTO jae_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Bôc tau eletoc êmoa, go êsêli sala êsêp ku me pane me laclu me kuki. Gêŋ samob, taŋ sala kêsêp naŋ, êtu dabuŋwaganê gêŋ. Êsêac sêgôm amboac tonaŋ gêdêŋ lau Israel samob, taŋ sêkêŋ da aŋga Silo naŋ. ");
INSERT INTO jae_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Mago gêdêŋ Eli latuagêc nêŋ têm, gêdêŋ taŋ ja geŋ ŋalêsi atomgeŋ naŋ, dabuŋwaganê sakiŋwaga mêŋgêô lasê ma kêsôm gêdêŋ ŋac, taŋ kêkêŋ da gêmoa naŋ, gebe “Ôkêŋ dabuŋwaganê bôc êndêŋ aê gebe japac sigobgeŋ. Eŋ gebe êkôc bôc senoŋa teŋ aŋga aômnêm atom, gebe êkôc bôc matacgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Ma ŋac tau embe êsôm êndêŋ eŋ gebe “Ja êniŋ ŋalêsi su acgom, go ôkôc êtôm têmtac êwiŋ”, go sakiŋwaga asôm gebe “Masianô, galocgeŋ ôkêŋ, ma embe masi, go Jajaŋgo su.” ");
INSERT INTO jae_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Apômtau gêlic lau wakuc naŋ mêtê sec samucgeŋ gebe sêsu Apômtaunê da susu. ");
INSERT INTO jae_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Ŋapalê Samuel gêjam sakiŋ Apômtau gêmoa. Eŋ kêjandiŋ obo sakiŋŋa teŋ. ");
INSERT INTO jae_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Katôm jalageŋ Samuel têna kêsi ŋakwê ôliŋa sauŋ teŋ kêtu eŋŋa. Ma gêdêŋ taŋ êsêagêc nê akweŋ sêpi sêja gebe sêkêŋ da naŋ, eŋ kêkêŋ ŋakwê tau gêdêŋ Samuel. ");
INSERT INTO jae_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Go Eli gêjam mec Elkana agêc nê awê ma kêsôm gebe “Apômtau êkêŋ awê tonec êkôc nêm ŋapalê sêjô ŋac, taŋ kêkêŋ gêdêŋ Apômtau naŋ su.” Go agêc sêmu sêja nêŋ gamêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ma Apômtau taê gêjam Hana ma eŋ kêkôc ŋapalê ŋac têlêac ma awê luagêc. Ma ŋapalê Samuel kêtu kapôêŋ gêmoa-Apômtau laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eli kêtu ŋamalacanô su ma gêŋô latuagêc nêŋ biŋ samob, taŋ sêgôm gêdêŋ lau Israel naŋ, to sêgôm mockaiŋ gêdêŋ lauo, taŋ sêjam sakiŋ aŋga katam lôm becŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Ma kêsôm gêdêŋ êsêagêc gebe “Amagêc agôm gêŋ amboac-tonaŋ kêtu asageŋŋa. Gebe aê gaŋô lau samob sêsôm amagêc nêm gêŋ alôb-alôb ŋawaegac. ");
INSERT INTO jae_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","O latucagêc, awi siŋmaŋ gebe aê gaŋô Apômtaunê lau sêsôm amagêcnêm lêŋ ŋawae ŋajam teŋ atom. ");
INSERT INTO jae_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Ŋac teŋ embe êŋgôm ŋac teŋ sec, Anôtô oc êmêtôc gêŋ tonaŋ. Mago ŋac teŋ embe êŋgôm sec êndêŋ Apômtau, asa oc êtôm gebe eteŋ êtu ŋac tonaŋŋa.” Tageŋ êsêagêc sêkêŋ taŋeŋ tameŋi awa atom, gebe Apômtau taê gêjam kêtu tôŋ gebe ênac êsêagêc. ");
INSERT INTO jae_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Samuel kêtôp kêtu kapôêŋ gamoa ma Apômtau to ŋamalac têntac gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Go Anôtônê ŋac teŋ gêdêŋ Eli gêmêŋ ma kêsôm gêdêŋ eŋ gebe “Apômtaunê biŋ tonec gebe ‘Aê gaoc tauc lasê gêdêŋ nêm miminê gôlôac gêdêŋ taŋ sêmoa Aiguptu sêsô Parao to nê gôlôac ŋalabu naŋ. ");
INSERT INTO jae_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Aê kajaliŋ eŋ sa aŋga Israel samob nêŋ gôlôacmôkê gebe êtu ŋoc dabuŋwaga. Eŋ êpi êndêŋ ŋoc altar êna gebe ênsôb jadauŋ ma êsô ŋakwê dabuŋ êkô aê laŋôcnêmŋa. Ma aê kakêŋ lau Israel nêŋ daja samob gêdêŋ miminê gôlôac. ");
INSERT INTO jae_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Kêtu asageŋŋa aôm matam katu ŋoc daja ma da samob, taŋ kajatu sa naŋ. Kêtu asageŋŋa aôm kotoc latômagêc sa kêlêlêc aê su naŋ, e alôm taôm ŋa da, taŋ ŋoc lau Israel sêkêŋ naŋ, ŋagêŋ mataêjamgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Kêtu tonaŋŋa Apômtau, Israelnêŋ Anôtô, kêsôm gebe ‘Aê gajac mata su gebe nêm gôlôac to tamamnê gôlôac sêsô-sêsa aê laŋôcnêm endeŋ tôŋgeŋ.’ Mago galoc Apômtau kêsôm gebe ‘Biŋ tonaŋ ênêcŋa. Lau taŋ tetoc aê sa naŋ, aê oc jatoc êsêac sa ma êsêac, taŋ sêpêc gêdô aê naŋ, oc jalic êsêac amboac gêŋ ŋaôma. ");
INSERT INTO jae_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ôlic acgom, bêc oc mêŋêô lasê, naŋ jasap aômnêm ŋaclai to tamamnê gôlôac nêŋ ŋaclai su e ŋamalacanô teŋ êmoa nêm gôlôac ŋalêlôm êtiam atom. ");
INSERT INTO jae_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Êndêŋ onaŋ oc ôsala moasiŋ, taŋ jansêwa êpi lau Israel naŋ, tomatam katugeŋ, ma ŋamalacanô teŋ oc êmoa nêm gôlôac ŋalêlôm êtiam atom endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Aômnêm ŋac tageŋ aê jatiŋ eŋ su aŋga ŋoc altar atom, eŋ êmoa gebe êtaŋ tomatasulugeŋ e têkwa êmbac-êmbac to nê ŋalêlôm ôluŋ-ôluŋgeŋ. Mago ŋamalacnêŋ siŋ oc enseŋ nêm gôlôac nêŋ lau wakuc su. ");
INSERT INTO jae_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Gêŋ taŋ êtap latômagêc Hopni agêc Pinehas sa naŋ, êkêŋ puc aôm gebe êsêagêc lulugeŋ oc sêmac êndu bêc tageŋ. ");
INSERT INTO jae_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Ma aê oc jakêŋ taucŋoc dabuŋwaga ŋaŋêŋ teŋ. Eŋ oc êŋgôm geŋ êtôm aêŋoc taêc gêjam to ŋoc ŋalêlôm. Aê oc jakwê ênê andu teŋgeŋŋa teŋ sa ma eŋ êsêlêŋ êsô-êsa êmoa ŋoc ŋac, taŋ gaeŋ oso eŋ naŋ, laŋônêmŋa endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Ma nêm gôlôac ŋapopoc samob oc sêndêŋ eŋ sêna ma teteŋ eŋ êtu moni me polom teŋŋa ma oc sêsôm gebe “Aê jateŋ aôm gebe ôkêŋ kôm sakiŋ dabuŋŋa teŋ êndêŋ aê gebe janiŋ polom ŋapopoc ŋagecmaŋ.” ’” ");
INSERT INTO jae_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Amboac tonaŋ ŋapalê Samuel gêjam sakiŋ Apômtau ma Eli gêjam jaom eŋ. Gêdêŋ ŋasawa tonaŋ Apômtau kêgamiŋ nê biŋ ma geoc tau lasê ŋa ŋakatu atom. ");
INSERT INTO jae_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Gêdêŋ têm tonaŋ Eli, taŋ mataanô kêtu waô ma gêlic gêŋ ŋapep atom naŋ, gê nê balêm. ");
INSERT INTO jae_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Anôtônê lam gêmac atomgeŋ ma Samuel gêc Apômtaunê lôm dabuŋ ŋalêlôm, taŋ Anôtô nê poac ŋakatapa kêkô naŋ. ");
INSERT INTO jae_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Gêdêŋ tonaŋ Apômtau gêmôêc gebe “Samuel, Samuel”, ma Samuel gêjô eŋ awa gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Go kêlêti gêdêŋ Eli gêja ma kêsôm gebe “Gômôêc aê, tec gamêŋ.” Eli kêsôm gebe “Masi, aê gamôêc aôm atom, ômu naônêc bêc êtiam.” Amboac tonaŋ eŋ gêmu jakêsa tau sic kêtiam. ");
INSERT INTO jae_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Ma Apômtau gêmôêc kêtiam gebe “Samuel.” Tec eŋ gêdi gêdêŋ Eli gêja ma kêsôm gebe” Gômôêc aê, tec gamêŋ.” Mago Eli gêjô eŋ awa gebe “O latucenec, aê gamôêc aôm atom, ômu naônêc bêc êtiam.” ");
INSERT INTO jae_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Gêdêŋ tonaŋ Samuel kêjala Apômtau su atom tageŋ. Ma Apômtaunê biŋ geoc tau lasê gêdêŋ eŋ su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Ma Apômtau gêmôêc Samuel kêtiam kêtu dim têlêacŋa. Go eŋ gêdi ma gêdêŋ Eli gêja jakêsôm gebe “Gômôêc aê, tec gamêŋ.” Gêdêŋ tonaŋ Elinê kauc kêsa gebe Apômtau gêmôêc ŋapalê. ");
INSERT INTO jae_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Tec kêsôm gêdêŋ Samuel gebe “Ômu naênêc bêc ma eŋ embe êmôêc aôm êtiam, go ôsôm gebe ‘Apômtau, ôsôm biŋ mêŋnêm sakiŋwaga êŋô.’” Amboac tonaŋ Samuel gêmu jakêsa tau sic gêc nê mala. ");
INSERT INTO jae_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Apômtau jakêkô kêdabiŋ eŋ ma gêmôêc kêtiam tê gêmôêc nê, gebe “Samuel, Samuel.” Ma Samuel gêjô eŋ awa gebe “Ôsôm biŋ mêŋnêm sakiŋwaga êŋô.” ");
INSERT INTO jae_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Go Apômtau kêsôm gêdêŋ Samuel gebe “Ôŋô acgom, aê gabe jaŋgôm gêŋ teŋ aŋga Israel lau samob sêŋô e taŋeŋsuŋ êtaŋ. ");
INSERT INTO jae_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Êndêŋ bêc ônê aê oc jaŋgôm biŋ samob, taŋ kasôm kêpi Elinê gôlôac naŋ, ŋanô êsa êpi eŋ tomalageŋ. ");
INSERT INTO jae_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Ma aê jasôm êndêŋ eŋ gebe Aê jakêŋ ŋagêjô êndêŋ ênê gôlôac endeŋ tôŋgeŋ gebe eŋ kêjala latuagêc sêgôm sec to sêsôm biŋ alôb-alôb kêpi Anôtô naŋ, mago eŋ kêmêtôc êsêagêc ŋajaŋa atom. ");
INSERT INTO jae_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Kêtu tonaŋŋa aê katôc lemoc kêpi Elinê gôlôac gebe daja to da ŋagêdô oc enseŋ nêŋ sec su atomanô.” ");
INSERT INTO jae_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel gêc e geleŋŋa lasê, go jagêlêc Apômtaunê lôm ŋakatam su. Eŋ kêtêc tau gebe ênac miŋ Apômtau geoc tau lasê gêdêŋ eŋŋa ŋamiŋ êndêŋ Eli atom. ");
INSERT INTO jae_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Mago Eli gêmôêc Samuel gebe “Latucenec Samuel.” Ma Samuel gêjô eŋ awa gebe “Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Ma Eli kêtu kênac eŋ gebe Apômtau kêsôm biŋ amboac ondoc gêdêŋ aôm. Ônsa ŋalô teŋ auc êndêŋ aê atom. Aôm embe ônsa biŋ, taŋ Apômtau kêsôm gêdêŋ aôm naŋ, ŋateŋ auc, go ôndac êtôm tonaŋ ma êlêlêc su.” ");
INSERT INTO jae_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Amboac tonaŋ Samuel gêjac miŋ biŋ samob tomalageŋ gêdêŋ Eli ma gêsa ŋalô teŋ auc atom. Ma Eli kêsôm gebe “Eŋ Apômtau, eŋ êŋgôm êtôm êlic ŋajamŋa.” ");
INSERT INTO jae_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuel kêtôp kêtu kapôêŋ ma Apômtau gêmoa gêwiŋ eŋ ma gêgôm nê biŋ samob, taŋ geoc lasê naŋ, ŋanô kêsa. ");
INSERT INTO jae_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Ma lau Israel aŋga Dan e gêdêŋ Berseba sêjala gebe Apômtau kêkêŋ Samuel kêtu ênê propete. ");
INSERT INTO jae_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Amboac tonaŋ Apômtau gêô lasê aŋga Silo kêtiam, gebe eŋ geoc tau lasê gêdêŋ Samuel aŋga tonaŋ ma kêsôm biŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Ma lau Israel samob sêŋô Samuelnê biŋ. Gêdêŋ ŋasawa tonaŋ lau Israel dêdi sêja gebe sênac siŋ êndêŋ lau Pilisti. Êsêac sê nêŋ becobo sêŋgôŋ Ebeneser, ma lau Pilisti sê nêŋ becobo sêŋgôŋ malac Apek ŋagala. ");
INSERT INTO jae_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Go lau Pilisti têdênaŋ tau su ma sebo sêsa gêdêŋ lau Israel. Siŋ kapôêŋ kêsa e lau Pilisti sêku lau Israel tulu ma sêjac lau amboac 4,000 êndu sêc siŋ ŋamala. ");
INSERT INTO jae_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Ma gêdêŋ taŋ lau Israel nêŋ siŋwaga sêmu sêmêŋ maleŋ su naŋ, Israel nêŋ laumata sêsôm gebe “Kêtu asageŋŋa Apômtau kêkêŋ lau Pilisti sêku aêac tulu gêdêŋ ocsalô tonec. Ajôc, takôc Apômtaunê poac ŋakatapa aŋga Silo êmêŋ gebe mêŋêmoa aêac ŋaluŋ ma ênam aêac kêsi aŋga nêŋ ŋacjo lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Amboac tonaŋ sêsakiŋ lau sêja Silo ma sêkôc Apômtau, lau siŋ undambêŋa nêŋ ŋatau, taŋ gêŋgôŋ kerubim ŋaô naŋ, nê poac ŋakatapa sêmêŋ. Ma Eli latuagêc Hopni agêc Pinehas sêwiŋ poac ŋakatapa. ");
INSERT INTO jae_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Gêdêŋ taŋ poac ŋakatapa jagêô lasê lau Israel nêŋ malac becoboŋa naŋ, lau Israel samob sêjam lasê to ŋaclaigeŋ e nom kêwiwic. ");
INSERT INTO jae_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Lau Pilisti sêŋô ŋaôndu tonaŋ ma têtu kênac tauŋ gebe “Sêjam lasê toŋaclaigeŋ aŋga Ebolainêŋ gamêŋ tonaŋ ŋam amboac ondoc.” Sêŋô gebe Apômtaunê poac ŋakatapa mêŋgêô lasê ");
INSERT INTO jae_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","tec têtêc tauŋ ŋanô gebe êsêac sêsôm gebe “Anôtô mêŋgêô lasê êsêacnêŋ malac. Ojae aêacmêŋ. Gêŋ amboac tonaŋ talic teŋ su gêmuŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Ojae aêacmêŋ. Asa ênam aêac kêsi aŋga Anôtô ŋaclai tonaŋ lêma. Anôtô tonaŋ kêku lau Aiguptu tulu ŋa gêŋwapac tokaiŋ-tokaiŋ aŋga gamêŋ sawa. ");
INSERT INTO jae_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","O Pilisti, ajôc, apuc taôm tôŋ. Anac siŋ amboac ŋacgeŋ. Embe masi, go atu lau Ebolai nêŋ gêŋôma, êtôm êsêac têtu amacnêm gêŋôma. Akô amboac ŋac ma anac siŋ.” ");
INSERT INTO jae_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Amboac tonaŋ lau Pilisti sêjac siŋ ma sêku lau Israel tulu e sêc siŋ su sêlêti sêja nêŋ andu gêdêŋ-gêdêŋgeŋ. Siŋ tau kapôêŋ ma lau Israel nêŋ siŋwaga 30,000 sêjaŋa bêc tageŋ. ");
INSERT INTO jae_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Ma sêjaŋgo Apômtaunê poac ŋakatapa su ma sêjac Eli latuagêc Hopni agêc Pinehas êndu. ");
INSERT INTO jae_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Ŋac Benjaminŋa teŋ kêsu aŋga siŋ ŋamala ma kêlêti e mêŋgêô lasê malac Silo gêdêŋ oc tageŋ tonaŋ. Nê ŋakwê gêŋgic ma nom gê eŋ môkêapac. ");
INSERT INTO jae_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Gêdêŋ taŋ ŋac tau gêô lasê naŋ, Eli gêŋgôŋ nê lêpôŋ, mataanô gêdêŋ intêna gêsuŋgeŋ gebe nê ŋalêlôm ŋatutuc kêtu Apômtaunê poac ŋakatapaŋa. Gêdêŋ taŋ ŋac tau kêsa malac ma gêjac miŋ biŋ naŋ, lau malacŋa samob têtaŋ lasê. ");
INSERT INTO jae_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Eli gêŋô taŋiboa ma gêjam kênac gebe “Gamêŋ ŋadiŋdiŋ tonaŋ ŋam amboac ondoc.” Go ŋac tau kêlêti gêdêŋ Eli ma kêsôm biŋ tau lasê gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Elinê jala kêtu 98 ma mataanô kêtu waô e gêlic gamêŋ atom. ");
INSERT INTO jae_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Go ŋac tau kêsôm gêdêŋ Eli gebe “Aê ŋac, taŋ gamêŋ aŋga siŋ ŋamala. Aê gaêc siŋ gêdêŋ ocsalô tonec.” Ma Eli kêtu kênac gebe “Latucenec, biŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Ŋac jaeŋŋa gêjô eŋ awa gebe “Lau Israel sêc lau Pilisti ma siŋ geseŋ lau taêsam su. Aôm latômagêc Hopni agêc Pinehas sêmac êndu ma sêjaŋgo Apômtaunê poac ŋakatapa su amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Gêdêŋ taŋ eŋ kêsam Apômtaunê poac ŋakatapa naŋ, Eli gêu tau kêsô gedecgeŋ aŋga lêpôŋ, taŋ kêkô kêsi malac ŋasacgêdô naŋ, ŋamuŋa e kêpôŋ gêsu tulu ma gêmac êndu, gebe eŋ kêtu ŋamalacanô ma ŋawapac kêsa. Eŋ gajam gôliŋ Israel jala 40. ");
INSERT INTO jae_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Eli lawao, Pinehasnê awê, taê e kêdabiŋ gebe akôc ŋapalê. Eŋ gêŋô ŋawae gebe sêjaŋgo Apômtaunê poac ŋakataŋa su to lawa agêc nê akweŋ sêmac êndu naŋ, ma eŋ gewec gebe ŋapalê kêtuŋ eŋ e kêkôc ŋapalê su. ");
INSERT INTO jae_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Gêc e kêdabiŋ gebe êmac êndu ma lauo, taŋ sêjam jaom eŋ naŋ, sêsôm gebe “Ôtêc taôm atom. Aôm kôkôc ŋapalê ŋac teŋ.” Mago eŋ gêjô biŋ atom ma kêkêŋ taŋa biŋ, taŋ êsêac sêsôm naŋ atom. ");
INSERT INTO jae_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Eŋ gê ŋapalênê ŋaê gebe Ikabod, ŋam gebe” Ŋawasi kêkac tau su aŋga lau Israelnêŋ”, gebe sêjaŋgo Anôtônê poac ŋakatapa ma kêtu lawa to nê akweŋŋa. ");
INSERT INTO jae_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Ma eŋ kêsôm gebe “Ŋawasi kêkac tau su aŋga Israelnêŋ gebe sêjaŋgo Anôtônê poac ŋakatapa su.” ");
INSERT INTO jae_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Gêdêŋ taŋ lau Pilisti sêjaŋgo Anôtônê poac ŋakatapa su naŋ, êsêac sêbalaŋ gêŋ tau aŋga malac Ebeneser jasêô lasê malac Asdod. ");
INSERT INTO jae_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Mago sêbalaŋ katapa tau sêsô anôtô Dagon nê lôm e tetoc kêkô kêsi Dagon tau. ");
INSERT INTO jae_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Ŋageleŋ gêdêŋ taŋ lau Asdod dêdi sa gêdêŋ bêbêcgeŋ naŋ, êsêac sêlic gebe Dagon gêu tau gêc masac gêc Apômtaunê poac ŋakatapa ŋanêmŋa gêc nom. Amboac tonaŋ sêkôc eŋ ma tetoc eŋ gêmu jakêkô ŋamala kêtiam. ");
INSERT INTO jae_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Mago ŋageleŋ êsêac dêdi e sêlic gebe Dagon gebeŋ kêtiam gêc Apômtaunê poac ŋakatapa ŋanêmŋa, laŋôanô gêdêŋ nom ma môkêapac to lêma makeŋ-makeŋ tulu gêc tauŋa kêsa taoŋ ŋaô ma ŋadambê ŋaômageŋ gêc. ");
INSERT INTO jae_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Tonaŋ ŋam gebe Dagonnê dabuŋwaga to lau samob embe sêsô Dagonnê lôm oc sejop tauŋ gebe sêka Dagon aŋga Asdod nê andu ŋataoŋ atomanô e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Apômtaunê lêma gejoŋ lau Asdod ŋa gêŋwapac. Eŋ kêtakê to kêkôniŋ malac to ŋagamêŋ samucgeŋ ŋa kamocmatu. ");
INSERT INTO jae_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Lau Asdod sêlic gêŋ tonaŋ ma sêsôm gebe “Israelnêŋ Anôtônê poac ŋakatapa êkô êwiŋ aêac atom, gebe eŋ lêma kêkôniŋ aêac to aêacnêŋ anôtô Dagon tôŋ.” ");
INSERT INTO jae_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Amboac tonaŋ êsêac sêsakiŋ biŋ sêkac lau Pilisti nêŋ gôliŋwaga sêpi tageŋ ma sêsôm gebe “Aêac daŋgôm asageŋ êtu Israelnêŋ Anôtônê poac ŋakatapaŋa.” Lau gôliŋwaga sêjô êsêac aweŋ gebe “Akêŋ Israelnêŋ Anôtônê poac ŋakatapa naêkô Gat.” Tec sêkôc katapa tau jakêkô tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Gêô lasê su, go Apômtau nê lêma kêkêŋ gêŋwapac kêkôniŋ malac tonaŋ. Eŋ kêtakê lau Gat kapôêŋ to sauŋ samob ma gêjac êsêac ŋa kamocmatu. ");
INSERT INTO jae_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Tec sêsakiŋ Anôtônê poac ŋakatapa gêja malac Ekron. Gêdêŋ taŋ Anôtônê poac ŋakatapa gêô lasê Ekron naŋ, lau Ekron sêjac wali gebe “Êsêac sêkôc Israelnêŋ Anôtônê poac ŋakatapa sêmêŋ gêdêŋ aêac gebe ênac aêac to ma gôlôac êndu.” ");
INSERT INTO jae_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Amboac tonaŋ sêkalem lau Pilisti nêŋ gôliŋwaga sêkac sa sêpi tageŋ ma sêsôm gebe “Asakiŋ Israelnêŋ Anôtônê poac ŋakatapa êmu êndêŋ taunê gamêŋ êna gebe ênac aêac to nêŋ lau samob êndu atom.” Malac tau ŋalau têtakê tauŋ êndu-êndu gebe Anôtônê lêma kêkôniŋ êsêac ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Lau taŋ sêmac êndu atom naŋ, têtap kamocmatu sa. Amboac tonaŋ lau malac tonec nêŋ wali kêpi e gêdêŋ undambê. ");
INSERT INTO jae_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Apômtaunê poac ŋakatapa kêkô gamêŋ Pilistiaŋa ajôŋ 7 su acgom, ");
INSERT INTO jae_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","go lau Pilisti sêkalem nêŋ dabuŋwaga to lau sêpuc kapoacwaga sêkac sa ma sêsôm gebe “Aêac daŋgôm asageŋ êtu Apômtaunê poac ŋakatapaŋa. Asôm êndêŋ aêac acgom, aêac tasakiŋ gêŋ tau êmu êna ŋamala êtiam ŋalêŋ ondoc.” ");
INSERT INTO jae_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Go êsêac sêjô êsêac aweŋ gebe “Embe asakiŋ Israelnêŋ Anôtônê poac ŋakatapa êmu êna, go asakiŋ ŋaômageŋ atom. Anac da taôm êwiŋ acgom, go amac ôlim ŋajam êsa ma amac ajala Apômtau Anôtô lêma kêkôniŋ amac gêwi siŋ atom ŋam.” ");
INSERT INTO jae_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Êsêac têtu kênac kêtiam gebe” Aêac anac da tauŋ ŋa asageŋ.” Tec êsêac sêjô êsêac aweŋ gebe “Kamocmatu ŋakatu gold lemeŋteŋ to moadec ŋakatu lemeŋteŋ êtôm lau Pilisti nêŋ gôliŋwaga nêŋ namba gebe gêŋwapac tonaŋ kêtap amac to nêm gôliŋwaga sa kêtôm taugeŋ. ");
INSERT INTO jae_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Amansaŋ nêm kamocmatu to moadec, taŋ geseŋ gamêŋ samob naŋ ŋakatu ma atoc Israelnêŋ Anôtô sa, oc moae eŋ êkôc nê lêma ŋawapac su aŋga amacnêm to aŋga nêm anôtôi nêŋ ma aŋga nêm gamêŋ. ");
INSERT INTO jae_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Amac abe nêm ŋalêlôm ŋadani êsa êtôm Parao to nê lau Aiguptu nêŋ êtu asageŋŋa. Taêm ênam biŋ, taŋ Anôtô tonaŋ gêgôm êsêac têtu meloc e sêwi lau Israel siŋ sac sêja naŋ. ");
INSERT INTO jae_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Galoc amansaŋ kareta wakuc teŋ ma akôc bulimakao têna luagêc, taŋ sêkêŋ su gêdêŋ ŋalatu sêmoa ma sêjala sê kareta teŋ su atom tageŋ naŋ. Ma akêŋ bulimakao tonaŋ sê kareta, mago akêŋ ŋalatu sêmu sêna sapa. ");
INSERT INTO jae_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Ma akêŋ Apômtaunê poac ŋakatapa êkô kareta ŋaô ma akêŋ ŋakatu gold, taŋ êtu da naŋ, êsêp gadob teŋ êkô êwiŋ katapa, gocgo awi êsêac siŋ tauŋgeŋ sêna. ");
INSERT INTO jae_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Ma alic acgom, embe sêsa intêna malac Betsemesŋa, oc ajala gebe Anôtô tau kakôniŋ amac ŋa gêŋwapac. Embe masi oc ajala gebe gêŋ tonaŋ ênê lêma gêjac aêac atom, kêtap aêac sa ŋaômageŋ.” ");
INSERT INTO jae_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Tec lau sêgôm amboac tonaŋ. Êsêac sêkôc bulimakao luagêc, taŋ sêkêŋ su gêdêŋ ŋalatu sêmoa naŋ, ma sêkêŋ sa kareta ma sêkôc ŋalatu tau su sêmoa sapa. ");
INSERT INTO jae_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Go sêkêŋ Apômtaunê poac ŋakatapa kêkô kareta ma gadob tomoadec gold ma tokamocmatu ŋakatu gold gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Bulimakao têna sêsêlêŋ gacgeŋ sepeŋ malac Betsemes. Sêsêlêŋ tataŋ-têtaŋ ma sêwi intêna siŋ sêmu anô me gasêŋa sêja atomanô. Gôliŋwaga Pilistiŋa têdaguc êsêac e dêdêŋ lau Betsemes nêŋ madiŋ. ");
INSERT INTO jae_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Gêdêŋ tonaŋ lau Betsemesŋa sejoŋ mopolom ŋanô sêmoa gamêŋ gaboaŋ. Sêôc mateŋanô sa ma sêlic poac ŋakatapa tec tatu samuc ma sêpuc kareta tôŋ-tôŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Bulimakao sê kareta tau jagêô lasê Josua aŋga Betsemes nê kôm ma kêkô. Poc kapôêŋ teŋ kêkô ŋagala. Amboac tonaŋ êsêac sêga kareta ŋaka popoc ma sêkêŋ bulimakao têna luagêc tonaŋ katu daja gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Lau Lewit sêkôc Apômtaunê poac ŋakatapa to gadob, taŋ da goldŋa kêsêp ŋalêlôm naŋ, su ma tetoc kêkô poc kapôêŋ tonaŋ ŋaô. Ŋacwaga Betsemesŋa sêkêŋ daja to da sêniŋ sêwiŋŋa gêdêŋ Apômtau gêdêŋ bêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Lau Pilistiŋa nêŋ gôliŋwaga lemeŋteŋ sêsala gêŋ samob tonaŋ su, go sêmu sêja Ekron gêdêŋ bêc tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Kamocmatu ŋakatu gold, taŋ lau Pilisti sêsakiŋ kêtu sêjac da tauŋŋa gêdêŋ Apômtau naŋ, malac Asdod to Gat ma Askalon to Gasa ma Ekron. Tageŋ-tageŋ kêtom êsêacnêŋ malacgeŋ. ");
INSERT INTO jae_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Moadec gold gêjô lau Pilisti nêŋ malac samob, taŋ gôliŋwaga lemeŋteŋ tonaŋ sêjam gôliŋ naŋ, malac tuŋbôm ma tuŋbôm masi. Poc tau kapôêŋ, taŋ êsêac tetoc Apômtaunê poac ŋakatapa kêkô ŋaô naŋ, gêŋgôŋ Josua Betsemesŋa nê kôm ŋagala. Poc tonaŋ kêtu ŋabelo gêŋgôŋ gêdêŋ tonê e gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Ma Apômtau gêjac lau Betsemesŋa ŋagêdô gebe êsêac têtu kêniŋ kêsêp Apômtaunê poac ŋakatapa ŋalêlôm. Eŋ gêjac êsêacnêŋ ŋacwaga 70 êndu. Ma lau têtaŋ taŋiboa gebe Apômtau gêjac êsêac secanô. ");
INSERT INTO jae_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Go êsêac ŋacwaga Betsemesŋa sêsôm gebe “Asa êtôm gebe êkô Apômtau, Anôtô dabuŋ tonaŋ laŋônêm. Aêac tasakiŋ gêŋ tau êndêŋ asa lau gebe êmoa êwiŋ aêac atom.” ");
INSERT INTO jae_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Go êsêac sêsakiŋ biŋ gêdêŋ lau Kiriatjearim gebe “Lau Pilistiŋa sêkêŋ Apômtaunê poac ŋakatapa gemu gêmêŋ. Asêp amêŋ ma akôc êpi êndêŋ amac êwac.” ");
INSERT INTO jae_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Go lau Kiriat-jeraim sêja sêkôc Apômtaunê poac ŋakatapa su. Sêkôc jasêkêŋ gêdêŋ Abinadabnê andu, taŋ kêkô gamêŋ ŋabau ma sêjam mec ênê latu Eleasar gebe ejop Apômtaunê poac ŋakatapa. ");
INSERT INTO jae_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Ŋasawa baliŋanô amboac jala 20 poac ŋakatapa kêkô malac Kiriat-jearim, ma lau Israel samob têtaŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Amboac tonaŋ Samuel kêsôm biŋ gêdêŋ gôlôac Israelŋa samob gebe “Embe amu andêŋ Apômtau ana tonêm ŋalêlôm samucgeŋ, go awi anôtôi jaba, taŋ ajam sakiŋ amoa naŋ, to alê gwam siŋ ma nêm ŋalêlôm epeŋ Apômtaugeŋ ma anam sakiŋ eŋ taugeŋ. Go eŋ oc ênam amac kêsi aŋga lau Pilisti lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Amboac tonaŋ lau Israel sêwi anôtôi Bal to alê gwam siŋ ma sêjam sakiŋ Apômtau taugeŋ. ");
INSERT INTO jae_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Go Samuel kêsôm gebe “Akac lau Israel samobgeŋ sa aŋga Mispa gebe jateŋ mec êndêŋ Apômtau êtu amacŋa.” ");
INSERT INTO jae_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Amboac tonaŋ êsêac sêkac tauŋ sa aŋga Mispa, sêkati bu, go sêsêwa kêsêp nom sêkô Apômtau laŋônêmŋa ma sêjam dabuŋ mo gêdêŋ oc samuc tonaŋ. Ma sêsôm lasê gebe “Aêac dagôm sec gêdêŋ Apômtaugoc.” Samuel kêmêtôc lau Israel aŋga Mispa. ");
INSERT INTO jae_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Gêdêŋ taŋ lau Pilisti sêŋô gebe lau Israel sêkac tauŋ sa aŋga malac Mispa naŋ, êsêacnêŋ gôliŋwaga sêpi dêdêŋ êsêac sêja. Lau Israel sêŋô biŋ tonaŋ ma têtêc tauŋ kêtu lau Pilistiŋa. ");
INSERT INTO jae_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Ma lau Israel sêsôm gêdêŋ Samuel gebe “Awam ênac Apômtau endeŋ tôŋgeŋ êtu aêacŋa gebe Apômtau ênam aêac kêsi aŋga lau Pilisti lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Amboac tonaŋ Samuel kêkôc domba ŋalatu teŋ, taŋ gênôm su gêmoa naŋ, ma kêkêŋ samucgeŋ kêtu daja gêdêŋ Apômtau. Ma eŋ kêtaŋ gêdêŋ Apômtau gêjô lau Israel su ma Apômtau kêkêŋ taŋa ênê mec. ");
INSERT INTO jae_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Gêdêŋ taŋ Samuel kêkêŋ daja tau gêmoa naŋ, ma lau Pilisti jatêdabiŋ Israel gebe sênac siŋ êndêŋ êsêac. Mago Apômtau nê wapap gêjac kapôêŋ gê tôŋgeŋ gêsac lau Pilisti ŋaô e gêjam êsêac saliŋ-saliŋgeŋ, tec lau Israel sêku êsêac tulu. ");
INSERT INTO jae_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Go lau Israel sêwi Mispa siŋ jasêjanda lau Pilisti to sêjac êsêac e jakêsêp gêdêŋ malac Bet-Kar ŋalabuŋa. ");
INSERT INTO jae_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Go Samuel kêkôc poc teŋ jagêjac sa kêkô Mispa to Jesana ŋasawa ma gê poc tau ŋaê gebe Eben-Eser, ma kêsôm gebe “Apômtau gêjam aêac sa e mêŋgêdêŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Apômtau kêkôniŋ lau Pilisti amboac tonaŋ, tec êsêac sêmu sêmêŋ Israel nêŋ gamêŋ kêtiam atom. Ma Apômtau lêma gejoŋ êsêac gêdêŋ têm samob, taŋ Samuel gêmoa mata jali naŋ. ");
INSERT INTO jae_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Malac taŋ lau Pilisti sêjaŋgo su aŋga Israel naŋ, kêtu lau Israel nêŋ gêŋ kêtiam aŋga Eskron e jagêdêŋ Gat. Ma lau Israel sêjam nêŋ gamêŋ kêsi aŋga lau Pilisti lemeŋ. Ma wama gêc Israel ma lau Amor ŋasawa amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Ma Samuel kêtu lau Israel nêŋ gôliŋwaga kêtôm têm samob, taŋ eŋ gêmoa mata jali naŋ. ");
INSERT INTO jae_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Kêtôm jalageŋ eŋ kêsêlêŋ gêjac laoc malac Betel to Gilgal ma Mispa ma kêmêtôc lau Israel nêŋ biŋ kêtôm malac tonaŋ ŋai. ");
INSERT INTO jae_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Go gêmu jagêŋgôŋ Rama kêtiam gebe ênê andu kêkô malac tônê. Aŋga tônê eŋ gêjam gôliŋ lau Israel amboac tonaŋgeŋ. Ma eŋ gêboa Apômtaunê altar teŋ sa kêkô tônê. ");
INSERT INTO jae_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Gêdêŋ taŋ Samuel kêtu ŋamalacanô su naŋ, eŋ kêkêŋ latui têtu gôliŋwaga Israelŋa. ");
INSERT INTO jae_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Latu ŋacsêga nê ŋaê Joel ma ŋac kêtu luagêcŋa nê ŋaê Abija. Êsêagêc têtu gôliŋwaga sêŋgôŋ malac Berseba. ");
INSERT INTO jae_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Mago eŋ latuagêc sêpuc tameŋi waŋa atom. Êsêagêc mateŋ katu mone. Sêkôc awa ŋalêsiŋa ma sêjam mêtôc gêdêŋ ôkwi. ");
INSERT INTO jae_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Go lau Israelnêŋ laumata samob sêkac sa dêdêŋ Samuel sêja Rama. ");
INSERT INTO jae_vpl VALUES ("S18_5","010_8_5","1SA","8","5","6","Ma sêsôm gêdêŋ eŋ gebe “Aôm kôtu ŋamalacanô su ma latômagêc sêpuc aôm waŋam atom. Amboac tonaŋ ôkêŋ kiŋ teŋ êndêŋ aêac gebe ênam gôliŋ aêac êtôm tenteŋlatu samob nêŋ kiŋ sêgôm.” Êsêacnêŋ biŋ gebe” Ôkêŋ kiŋ teŋ êndêŋ aêac gebe ênam gôliŋ aêac” naŋ, kêmoasiŋ Samuel atomanô, ma eŋ keteŋ mec gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Ma Apômtau gêjô Samuel awa gebe “Ôkêŋ taŋam launêŋ biŋ, taŋ sêsôm naŋ, gebe êsêac têtiŋ aôm atom, têtiŋ aê ma sedec gebe jatu êsêacnêŋ kiŋ. ");
INSERT INTO jae_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Êsêac sêwi aê siŋ ma sêjam sakiŋ anôtôi jaba. Gêŋ samob, taŋ sêgôm gêdêŋ aê gêdêŋ taŋ kakôc êsêac su aŋga Aiguptu e mêŋgêdêŋ ocsalô tonec naŋ, sêgôm gêdêŋ aôm amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ôkêŋ taŋam êsêacnêŋ aweŋ, tageŋ ôlêŋ biŋ êsêac ŋajaŋa ma ôndôŋ kiŋ, taŋ ênam gôliŋ êsêac naŋ, nê ŋagôliŋ êndêŋ êsêac.” ");
INSERT INTO jae_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Go Samuel kasôm Apômtaunê biŋ samob gêdêŋ lau, taŋ teteŋ kiŋ teŋ gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Ma kêsôm gebe “Kiŋ tau oc ênam gôliŋ amac ŋalêŋ amboac tonec gebe Eŋ oc êkôc amac latômi ma êkêŋ êsêac sênam gôliŋ êna kareta siŋŋa to sêŋgôŋ hos ŋaô ma êkêŋ êsêac sêlêti sêmuŋ ênê kareta siŋŋa. ");
INSERT INTO jae_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ŋagêdô eŋ oc êkêŋ êsêac tatu siŋwaga 1,000 nêŋ kapitai ma ŋagêdô têtu siŋwaga 50 nêŋ kapitai. Ŋagêdô sêkac ênê nom ôkwi to sejoŋ ênê kôm ŋanô sa. Ŋagêdô oc sêmansaŋ laukasap siŋŋa ma ênê kareta siŋŋa ŋagêŋlêlôm. ");
INSERT INTO jae_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Eŋ oc êkôc amac latômio gebe sêmansaŋ gêŋmalu to seno ma sêpac gêŋ. ");
INSERT INTO jae_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Eŋ oc ejoŋ nêm kôm to wain ma katêkwiŋa ŋaŋanô mataêjam samob su ma ênac sam gêŋ tau êndêŋ nê sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Eŋ oc êkôc gêŋ lemeŋlu-lemeŋlu ŋatageŋ-tageŋ su aŋga nêm kôm polom to wainŋa gebe êkêŋ êndêŋ nê gejobwaga to sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Eŋ oc êkôc nêm sakiŋwagao to ŋac ma nêm bulimakao to doŋki ŋajamanô su aŋga amacnêm ma êkêŋ sênam ênê kôm. ");
INSERT INTO jae_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Eŋ oc êkôc nêm domba lemeŋlu-lemeŋlu ŋatageŋ-tageŋ ma amac taôm oc atu ênê gêŋôma. ");
INSERT INTO jae_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Ma êndêŋ bêc tonaŋ amac oc ataŋ lasê êtu nêm kiŋ, taŋ taôm ajaliŋ sa naŋŋa, mago Apômtau oc êkêŋ taŋa amac êndêŋ bêc tonaŋ atom.” ");
INSERT INTO jae_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Mago lau dedec gebe sêŋô Samuelnê biŋ. Êsêac sêsôm gebe “Masianô, aêac abe akôc kiŋ teŋ ênam gôliŋ aêac. ");
INSERT INTO jae_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Go aêac atôm lau tenteŋlatu samob. Aêacma kiŋ ênam gôliŋ aêac to êwê aêac ma ênac aêacma siŋ.” ");
INSERT INTO jae_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Biŋ samob, taŋ êsêac sêsôm naŋ, Samuel gêŋô ma kêsôm lasê kêtiam gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ma Apômtau kêsôm gêdêŋ Samuel gebe “Ôkêŋ taŋam êsêacnêŋ biŋ ma ôkêŋ kiŋ teŋ êndêŋ êsêac.” Go Samuel kêsôm gêdêŋ lau Israel nêŋ ŋacwaga gebe “Amu andêŋ nêm malacmôkê êndêŋ-êndêŋgeŋ ana.” ");
INSERT INTO jae_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Ŋac teŋ aŋga Benjaminnê gôlôac gêmoa nê ŋaê Kis. Eŋ Abiel latu, naŋ Seroro latu, naŋ Bekorat latu, naŋ Apia latu aŋga toŋ Benjaminŋa. Eŋ ŋac tolêlôm. ");
INSERT INTO jae_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Eŋ latu teŋ gêmoa ŋaê Saul. Eŋ ŋac matac ŋajam. Ŋac Israelŋa teŋ laŋôanô ŋajam kêtôm eŋ gêmoa atom. Môkêapac keleŋ gamêŋ su. ");
INSERT INTO jae_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Bêc teŋ Saul tama Kis nê doŋki têna ŋagêdô sêbôm. Amboac tonaŋ Kis kêsôm gêdêŋ latu Saul gebe “Ôkôc sakiŋwaga teŋ êwiŋ aôm ma andi naansom doŋki têna tau.” ");
INSERT INTO jae_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Êsêagêc sêsêlêŋ jasêsa gamêŋ lôcŋa Epraim, go sêsêlêŋ jasêsa gamêŋ Salisaŋa, mago têtap bôc tau sa atom. Sêsêlêŋ jasêsa gamêŋ Salimŋa, mago sêmoa tonaŋ atom. Go agêc sêsêlêŋ jasêsa gamêŋ Benjaminŋa, mago sesom elêmê amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Gêdêŋ taŋ jasêsa gamêŋ Supŋa naŋ, Saul kêsôm gêdêŋ sakiŋwaga, taŋ gêwiŋ eŋ naŋ, gebe “Ajôc, aêagêc tamu tana. Tamoc oc êwi doŋki têna ŋabiŋ siŋ ma ê go tau êtu aêagêcŋa.” ");
INSERT INTO jae_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Ma sakiŋwaga tonaŋ gêjô eŋ awa gebe “Anôtônê ŋac teŋ gêŋgôŋ malac tonec. Eŋ ŋac, taŋ lau tetoc eŋ sa naŋ. Biŋ samob, taŋ eŋ kêsôm naŋ, ŋanô kêsa. Aêagêc dandêŋ eŋ tana. Oc moae eŋ êsôm biŋ katô aêagêc êtu lêŋ tec tasêlêŋ tamoa necŋa.” ");
INSERT INTO jae_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Go Saul kêsôm gêdêŋ nê sakiŋwaga gebe “Aêagêc embe tana, go takêŋ asageŋ êndêŋ ŋac tau. Polom taŋ gêc nêŋ talu naŋ, gêbacnê. Ma gêŋ ŋagêdô gebe takêŋ êndêŋ Anôtônê ŋac tauŋa gêc atom. Aêagêc nêŋ asageŋ gêc.” ");
INSERT INTO jae_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Sakiŋwaga tau gêjô eŋ awa gebe “Ôlic acgom, aê kakôc silber 50 toea, aê oc jakêŋ tonaŋ êndêŋ Anôtônê ŋac gebe êwa aêagêcnêŋ lêŋ sa.” ");
INSERT INTO jae_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Aŋga Israel andaŋgeŋ embe ŋac teŋ taê ênam gebe êtu kênac Anôtô êtu gêŋ teŋŋa, naŋ êsôm gebe “Dandêŋ ŋac-gêlic-gêŋwaga tana.” Gebe ŋac taŋ sêsam eŋ galoc gebe Propete naŋ, andaŋgeŋ sêsam eŋ gebe Ŋacgêlic-gêŋwaga.) ");
INSERT INTO jae_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Saul kêsôm gebe “ŋajam, dandêŋ eŋ tana.” Amboac tonaŋ tec agêc sêsa malac, taŋ Anôtônê ŋac gêmoa naŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Gêdêŋ taŋ êsêagêc sêpi malac, taŋ gêc gamêŋ ŋabau sêja naŋ, êsêagêc dêdac ŋapalêo ŋagêdô sêsa sêmêŋ sebe sêkati bu, tec têtu kênac êsêac gebe “Gêlic-gêŋwaga gêmoa me masi.” ");
INSERT INTO jae_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Êsêac sêjô êsêagêc aweŋ gebe “Aec, eŋ kêsêlêŋ gêmuŋ amagêc. Galocgeŋ eŋ mêŋgêô lasê malac gebe ocsalô tonec lau sêkêŋ da teŋ aŋga gamêŋ ŋabau. ");
INSERT INTO jae_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Êndêŋ taŋ asa malac naŋ, oc atap eŋ sa. Eŋ gebe êpi gamêŋ ŋabau naêniŋ gêŋ. Gebe lau oc sêniŋ gêŋ atomgeŋ e eŋ êô lasê ma ênam mec da su acgom, go lau, taŋ sêkalem êsêac naŋ, sêniŋ gêŋ. Api anamaŋ, oc atap eŋ sa solopgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Amboac tonaŋ êsêagêc sêpi malac sêja ma gêdêŋ taŋ êsêagêc sêsa malac naŋ, sêlic Samuel kêsêlêŋ kêsa gêdêŋ êsêagêc gêmêŋ gebe êpi gamêŋ ŋabau êna. ");
INSERT INTO jae_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Bêc taŋ gêmuŋ bêc Saul gêô lasêŋa naŋ, Apômtau geoc biŋ lasê gêdêŋ Samuel ma kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Eleŋŋa êndêŋ taŋ oc êkô amboac kêkô galoc naŋ, aê oc jasakiŋ ŋac teŋ aŋga gamêŋ Benjaminŋa êndêŋ aôm êwac. Ôniŋ oso eŋ êtu ŋoc lau Israel nêŋ kiŋ. Eŋ oc ênam ŋoc lau kêsi aŋga lau Pilisti lemeŋ. Aê galic gêŋwapac, taŋ ŋoc lau sêôc naŋ, gebe nêŋ taŋiboa kêsô aê taŋocsuŋ sugac.” ");
INSERT INTO jae_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Gêdêŋ taŋ Samuel gêlic Saul naŋ, Apômtau kêsôm gêdêŋ eŋ gebe “Ŋac tau, taŋ kasôm ênê biŋ gêdêŋ aôm naŋ tonec. Eŋ ŋac, taŋ oc ênam gôliŋ ŋoc lau.” ");
INSERT INTO jae_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Go Saul kêtu gasuc Samuel aŋga malac ŋasacgêdô ma kêsôm gêdêŋ eŋ gebe “Aê jateŋ aôm gebe ôtôc Gêlic-gêŋwaga nê andu êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuel gêjô eŋ awa gebe “Ŋac-gêlic-gêŋwaga tau aê. Ômuŋ aê ôpi ôndêŋ gamêŋ ŋabau ôna gebe ocsalô tec oc ôniŋ gêŋ ôwiŋ aê. Ma êndêŋ bêbêcgeŋ oc jakêŋ aôm ôna ma jasôm biŋ tau, taŋ gobe ôtu kênac êndêŋ aê naŋ, lasê êndêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ôpô sim taôm êtu doŋki têna, taŋ sêbôm gêdêŋ ŋabêc kêtu têlêac gêjaŋa su naŋ atom gebe têtap êsêac sa su. Mago lau Israel nêŋ awamata samob gêjac asa ŋawae. Gêjac aôm to tamam nê gôlôac samob ŋawae atom me.” ");
INSERT INTO jae_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Saul gêjô eŋ awa gebe “Aê ŋac Benjaminŋa, lau Israel nêŋ gôlôacmôkê sauŋanô tau, ma aêŋoc gôlôac kêtu Benjamin nê gôlôacmôkê nêŋ gôlôac ŋamuanô tau. Aôm kôsôm biŋ tonaŋ gêdêŋ aê kêtu ageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Go Samuel gêwê Saul agêc nê sakiŋwaga sêsô andu sêniŋ gêŋŋa sêja ma kêkêŋ êsêagêc sêŋgôŋ lau, taŋ sêkalem êsêac naŋ ŋamata. Lau tau naŋ namba amboac 30. ");
INSERT INTO jae_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Go Samuel kêsôm gêdêŋ-ŋac-geno-gêŋŋa gebe “Ôkôc gêŋ, taŋ kakêŋ gêdêŋ aôm ma kasôm gebe otoc ênêc tau ŋa naŋ ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Tec geno-gêŋwaga kêkôc akaiŋ samuc to ŋailênô ma ketoc kêkô Saul laŋônêmŋa ma Samuel kêsôm gebe “Ôlic gêŋ ŋagec tonec, tec tetoc kêkô aôm laŋômnêmŋa nec ôniŋ. Gêŋ tonec sêmasaŋ kêtu aômŋa gebe ênêc e êndêŋ ŋanoc gebe ôniŋ ôwiŋ ŋacleŋ.” Amboac tonaŋ Saul geŋ gêŋ gêwiŋ Samuel gêdêŋ bêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Gêdêŋ taŋ êsêac sêsêp aŋga gamêŋ ŋabau jasêô lasê malac naŋ, êsêac sêja mê teŋ gêc andu ŋasalôm tapa-tapa ŋaô kêtu Saulŋa ma eŋ gêc bêc gêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Gêdêŋ taŋ gêu bôŋ naŋ, Samuel gêmôêc kêpi gêdêŋ Saul gebe “Ôndi sa, aê gabe jakêŋ aôm ôna.” Saul gêdi ma êsêagêc Samuel lulugeŋ sêsa intêna sêja. ");
INSERT INTO jae_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Sêsa malac ŋamadiŋ, go Samuel kêsôm gêdêŋ Saul gebe “Ôsôm êndêŋ nêm sakiŋwaga gebe êsêlêŋ êmuŋ aêagêc. Eŋ êôc lêlêc aêagêc su, go aôm taôm ômoa sauŋgeŋ acgom, gebe jasôm Anôtô nê biŋ êndêŋ aôm ôŋô.” ");
INSERT INTO jae_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Go Samuel kêkôc ŋoplakôp toniptêkwi ma kêkêc kêpi Saul môkêapac ma kêlêsôp eŋ alianô ma kêsôm gebe “Apômtau geŋ oso aôm gebe ôtu ênê lau Israel nêŋ kiŋ. Aôm oc ônam gôliŋ Apômtaunê lau to ônam êsêac kêsi aŋga nêŋ ŋacjo, taŋ sêgî êsêac auc naŋ. Gêŋtalô tonec êwa sa êndêŋ aôm gebe Apômtau geŋ oso aôm gebe ôtu ênê gêŋlênsêm ŋakiŋ. ");
INSERT INTO jae_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Galoc embe ôwi aê siŋ, oc ôndac ŋac luagêc aŋga Rahelnê sêô, taŋ gêc gamêŋ Benjamin ŋamalac Selsa naŋ. Êsêagêc oc sêsôm êndêŋ aôm gebe ‘Têtap doŋki têna, taŋ gosom naŋ, sa su. Ma galoc tamam taê gajam doŋki têna kêtiam atom, mago gê go tau kêtu aômŋa gêmoa ma kêsôm gebe “Aê jaŋgom asageŋ êtu ŋoc latucŋa.” ’ ");
INSERT INTO jae_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Aŋga tonaŋ aôm gacgeŋ ôna e ô lasê kamem Taborŋa, go lau têlêac oc dêndac aôm. Êsêac oc sêpi malac Betel sêna gebe sêkêŋ da êndêŋ Anôtô. Teŋ êkôc noniŋ ŋalatu kapoac têlêac. Teŋ êkôc mopolom têlêac ma teŋ êkôc bôc ŋaôlic towain. ");
INSERT INTO jae_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Êsêac oc sê moalêc aôm ma sêkêŋ mopolom luagêc êndêŋ aôm. Aôm oc ôkôc su aŋga êsêac lemeŋ. ");
INSERT INTO jae_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Go aôm ô lasê malac Gibea Elohim, taŋ lau Pilisti nêŋ malac gêc naŋ. Aôm oc ôndac propete ŋatoŋ teŋ aŋga malac ŋasacgêdô. Êsêac aŋga gamêŋ ŋabau sêsêp sêmêŋ. Gêŋ wêŋa togam to gegob ma oŋ to gasuc ŋakicsêa êwê êsêac ma nêŋ katuŋ kaiŋ teŋ amboac propete nêŋ gêgôm êsêac. ");
INSERT INTO jae_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Ma Apômtaunê Ŋalau oc ênam aôm auc êlêlêc su ma nêm katôm kaiŋ teŋ êsa êtôm propete tauŋ nêŋ, go aôm ôtu ŋac wakuc teŋ samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Êndêŋ taŋ gêŋtalô tonaŋ samob êtap aôm sa su naŋ, ôŋgôm êtôm nêm ŋalêlôm êkac aôm gebe Apômtau tau oc êwiŋ aôm. ");
INSERT INTO jae_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Ôsêp malac Gilgal ôna ômuŋ aê, go aê jandêŋ aôm jawac gebe jakêŋ daja to dawama. Ônsaê aê bêc 7 acgom, go jandêŋ aôm jawac ma jasôm gêŋ, taŋ ôŋgômŋa naŋ, êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Gêdêŋ taŋ Saul kêkac tau ôkwi gebe êwi Samuel siŋ naŋ, go Anôtô kêkêŋ ŋalêlôm wakuc gêdêŋ eŋ ma gêŋtalô samob tonaŋ ŋanô kêsa gêdêŋ bêc tageŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Ma gêdêŋ taŋ êsêagêc sêô lasê malac Gilgal naŋ, propete nêŋ toŋ teŋ kêpuc eŋ tôŋ-tôŋ. Ma Anôtônê ŋalau gêjam eŋ auc kêlêlêc su e katu kaiŋ teŋ kêsa ma jakêsêp êsêac ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Lau samob, taŋ sêjala eŋ gamuŋ ma sêlic ênê katu kaiŋ teŋ kêsa amboac propete nêŋ naŋ, sêsôm gêdêŋ tauŋ gebe” Asageŋ gêgôm Kis latu Saul. Eŋ kêtu propete nêŋ teŋ amboac tonaŋ me.” ");
INSERT INTO jae_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Ma ŋac teŋ aŋga gamêŋ tonaŋ kêsôm gebe “Êsêacnêŋ tameŋi asa.” Tec sêsôm tonec gebe “Saul kêtu propetenêŋ teŋ amboac tonaŋ me.” ");
INSERT INTO jae_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Gêdêŋ taŋ katu kaiŋ teŋ kêsa su naŋ, eŋ gêja nê malac Gibea. ");
INSERT INTO jae_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Go Saul sa laŋgwa kêsôm gêdêŋ eŋ to nê sakiŋwaga gebe “Amagêc aja ondoc.” Tec eŋ gêjô eŋ awa gebe “Aêagêc asom doŋki têna ma gêdêŋ taŋ atap sa atom naŋ, adêŋ Samuel aja.” ");
INSERT INTO jae_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Sa laŋgwa kêsôm gebe “Ôsôm acgom, Samuel kêsôm asageŋ.” ");
INSERT INTO jae_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Saul gêjô eo awa gebe “Eŋ kêsôm gêdêŋ aêagêc gebe têtap doŋki têna sa su.” Mago biŋ kiŋŋa, taŋ Samuel kêsôm naŋ, eŋ gêjac miŋ gêwiŋ atom. ");
INSERT INTO jae_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Gêdêŋ ŋasawa tonaŋ Samuel kêkalem lau Israel sêpi tageŋ dêdêŋ Apômtau aŋga malac Mispa. ");
INSERT INTO jae_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ma kêsôm gêdêŋ lau Israel gebe “Apômtau, Israel nêŋ Anôtô nê biŋ amboac tonec gebe ‘Aê gawê Israel sêpi aŋga Aiguptu sêmêŋ. Aê gajam amac kêsi aŋga lau Aiguptuŋa ma aŋga gamêŋ kiŋŋa samob, taŋ sêkôniŋ amac naŋ.’ ");
INSERT INTO jae_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Mago amac atiŋ nêm Anôtô, taŋ gêjam amac sa aŋga nêm gêŋwapac to gêŋ lênsôŋŋa samob naŋ, su gêdêŋ ocsalô tonec ma asôm gebe ‘Masi, ôkêŋ kiŋ teŋ ênam gôliŋ aêac.’ Amboac tonaŋ andênaŋ taôm akô Apômtau laŋônêmŋa êtôm nêm gôlôacmôkê to nêm sackapoacgêdôgêŋ.” ");
INSERT INTO jae_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Samuel kêkêŋ Israelnêŋ gôlôacmôkê samob sêsa sêmêŋ ma kêpuc kapoac e jakêsêp Benjaminŋa. ");
INSERT INTO jae_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Go kêkêŋ gôlôacmôkê Benjamin nêŋ sackapoacgêdô gêdêŋ-gêdêŋgeŋ sêsa sêmêŋ. Eŋ kêpuc kapoac e jakêsêp sackapoacgêdô Matri. Go kêkêŋ sackapoacgêdô Matri nêŋ ŋac tageŋ-tageŋ sêsa sêmêŋ ma kêpuc kapoac e jakêsêp Kis latu Saul. Mago gêdêŋ taŋ sesom eŋ naŋ, eŋ gêmoa atom. ");
INSERT INTO jae_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Tec têtu kênac Apômtau kêtiam gebe “Ŋac tau gêmêŋ tonec me masi.” Ma Apômtau gêjô êsêac aweŋ gebe “Aec, eŋ kêsiŋ tau gêmoa waba ŋalêlôm.” ");
INSERT INTO jae_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Amboac tonaŋ sêlêti sêja ma sêkôc eŋ aŋga tonaŋ. Ma gêdêŋ taŋ eŋ kêkô lau ŋalêlôm naŋ, eŋ ŋac waso-waso kêlêlêc êsêac samob su. ");
INSERT INTO jae_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Go Samuel kêsôm gêdêŋ lau samob gebe “Alic ŋac tau, taŋ Apômtau kêjaliŋ sa naŋ me masi. Ŋac teŋ kêtôm eŋ gêmoa lau samob ŋalêlôm atom.” Go lau samob sêjam lasê ma sêmôêc gebe “Kiŋ tau êmoa ŋajamôŋ.” ");
INSERT INTO jae_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Ma Samuel gêwa mêtê to ŋagôliŋ kiŋŋa sa gêdêŋ lau ma keto biŋ samob kêsêp buku teŋ ma ketoc gêc Apômtau laŋônêmŋa. Tonaŋ su, go Samuel kêsakiŋ lau samob sêmu sêja nêŋ andu gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Saul tau gêmu gêja malac Gibea amboac tonaŋgeŋ ma siŋwaga, taŋ Anôtô kêkac nêŋ ŋalêlôm naŋ, jasêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Mago lau sec ŋagêdô sêmoa naŋ sêsôm gebe “Ŋac tonaŋ oc ênam aêac sa amboac ondoc.” Êsêac sêpêc gêdô eŋ ma sêkêŋ gêŋ teŋ gêdêŋ eŋ atom. Tageŋ Saul gêgôm amboac gêlic atom. ");
INSERT INTO jae_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Lau Amon nêŋ kiŋ Nahas kêpi gêmêŋ ma kêgi malac Jabes-Gilead auc. Go lau Jabes sêsakiŋ biŋ gêdêŋ Nahas gebe “Ômoatiŋ poac teŋ ôwiŋ aêac, go anam sakiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Mago ŋac Amon Nahas gêjô êsêac aweŋ gebe “Aê jamoatiŋ poac tageŋ tonec jawiŋ amac gebe jakip amac matemlakôp anôŋa sa ma jaŋgôm Israel samob majeŋ êsa.” ");
INSERT INTO jae_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Go lau Jabes-Gilead nêŋ kasêga sêsôm gêdêŋ eŋ gebe “Ôkêŋ ŋasawa êtôm bêc 7 êndêŋ aêac gebe asakiŋ lau jaeŋŋa êtôm malac-malac Israelŋa samob sêna ma embe lau teŋ sênam aêac sa atom, go akêŋ tauŋ andêŋ amac.” ");
INSERT INTO jae_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Gêdêŋ taŋ lau jaeŋŋa jasêô lasê malac Gibea, taŋ Saul gêŋgôŋ ma sêkêŋ ŋawae tau naŋ, lau samob sêpuc taŋiboa sa ma têtaŋ. ");
INSERT INTO jae_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Gêdêŋ tonaŋ Saul gêwê bulimakao gêmu aŋga kôm gêmêŋ ma kêtu kênac gebe “Lau têtaŋ taŋiboa tônê ŋam amboac ondoc.” Go êsêac sêjac miŋ lau Jabes nêŋ biŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Gêdêŋ taŋ Saul gêŋô biŋ tau naŋ, Anôtônê Ŋalau gêjam eŋ auc ma eŋ têtac ŋandaŋ sec. ");
INSERT INTO jae_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Ma eŋ kêkôc bulimakao luagêc ma kêsa gêŋgic-gêŋgic, go kêsakiŋ lau jaeŋŋa gebe sênac sam êtôm gamêŋ Israelŋa samobgeŋ ma sêsôm biŋ tonec gebe “Lau taŋ sêndi nasêndaŋguc Saul agêc Samuel atom naŋ, nêŋ bulimakao oc têtap biŋ tonaŋgeŋ sa.” Go Apômtau gêgôm êsêac têtakê ŋanô, tec êsêac dêdi tomalageŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Go Saul kêkac êsêac sa aŋga malac Besek. Lau Israel nêŋ ŋacwaga 300,000 to lau Juda nêŋ 30,000. ");
INSERT INTO jae_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Ma eŋ kêsôm gedeŋ lau, taŋ sêkôc jaeŋ sêmêŋ naŋ, gebe “Asôm êndêŋ lau Jabes-Gilead gebe ‘Eleŋ oc ŋandaŋ êsa, go nêm gêŋwapac ŋagaô êsa.’” Gêdêŋ taŋ lau jaeŋŋa sêô lasê malac naŋ, lau Jabes sêŋô biŋ tau e êsêac têntac kêpô su. ");
INSERT INTO jae_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Go lau Jabes sêkêŋ biŋ gêdêŋ Nahas gebe “Eleŋŋa aêac oc ansuŋ tauŋ awac, go amac aŋgôm aêac atôm taêm ênam.” ");
INSERT INTO jae_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Gêdêŋ geleŋmata Saul gêwa nê lau kêkôc sêja toŋ têlêac ma gedeŋ bebec kanucgeŋ êsêac sêô lasê ŋacjonêŋ becobo ma sêjac lau Amon e oc ŋandaŋ kêsa. Ma lau ŋapopoc sêc êliŋ-êliŋ e ŋac luagêc sêmoa sêwiŋ tauŋ atom. ");
INSERT INTO jae_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Go lau sêsôm gêdêŋ Samuel gebe “Lau ondoc sêsôm gebe ‘Saul ênam gôliŋ aêac atom.’ Ôkêŋ êsêac dandêŋ aêac gebe tanac êsêac êndu.” ");
INSERT INTO jae_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Mago Saul kêsôm gebe “Êndêŋ ocsalô tonec ŋac teŋ êmac êndu atom, gebe galoc Apômtau gêjam nê lau Israel kêsi.” ");
INSERT INTO jae_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Go Samuel kêsôm gêdêŋ lau gebe “Ajôc, aêac tapi malac Gilgal ma tawaka mêtê kiŋŋa sa.” ");
INSERT INTO jae_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Lau samob sêpi jasêô lasê Gilgal ma sêkêŋ Saul kêtu kiŋ sêkô Apômtau laŋônêmŋa. Ma sêkêŋ da moasiŋŋa gêdêŋ Apômtau ma Saul to lau Israel samob têntac ŋajam kêlêlêc. ");
INSERT INTO jae_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Go Samuel kêsôm biŋ gêdêŋ lau Israel samucgeŋ gebe “Aê kakêŋ taŋoc amacnêm biŋ ateŋŋa samob ma kakêŋ kiŋ teŋ gêdêŋ amac gebe ênam gôliŋ amac. ");
INSERT INTO jae_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Ma galoc kiŋ tau oc êwê amac. Aê katu ŋamalacanô su ma môdê kêpi aê ma aê latuci sêmoa sêwiŋ amac. Aê gawê amac gêdêŋ aê ŋapalêgeŋ e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Aê tec gamoa. Aêŋoc biŋ teŋ embe ênêc amacŋa, naŋ asôm lasê galoc tamoa Apômtau to ŋac, taŋ geŋ oso eŋ naŋ, laŋôŋnêmŋa. Aê kajaŋgo asanê bulimakao su. Aê kakôc asanê doŋki su. Aê gagôm keso gêdêŋ ŋac ondoc ma kakôniŋ asa. Ŋac ondoc kêkêŋ awa ŋalêsiŋa gêdêŋ aê gebe ênac aê matoc su. Asôm lasê gebe jakêŋ gêŋ tau ŋagêjô.” ");
INSERT INTO jae_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Êsêac sêjô ênê biŋ gebe “Aôm gôgôm keso teŋ gêdêŋ aêac atom to kôkôniŋ aêac atom ma kôkôc awa ŋalêsiŋa teŋ aŋga lau teŋ nêŋ atom.” ");
INSERT INTO jae_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Go eŋ kêsôm gêdêŋ êsêac gebe “Apômtau tau kêjala ma ênê ŋac geŋ osoŋa gêlic gêdêŋ ocsalô tonec amboac tonaŋgeŋ gebe amac atap gêŋ teŋ sa gêc aê lemoc atom.” Ma êsêac sêjô eŋ awa gebe “Aec, Apômtau kêjala.” ");
INSERT INTO jae_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Go Samuel kêsôm gêdêŋ lau gebe “Apômtau taŋ kêkêŋ Mose agêc Aron ma sêwê nêm tamemi sêpi aŋga Aiguptu sêmêŋ naŋ kêjala. ");
INSERT INTO jae_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Amboac tonaŋ andi mêŋakô gebe dawa nêŋ biŋ sa takô Apômtau laŋônêm ŋa ma aê jawa Apômtaunê moasiŋ samob, taŋ kêkêŋ gêdêŋ amac to nêm tamemi naŋ sa. ");
INSERT INTO jae_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Gêdêŋ taŋ Jakob kêsêp Aiguptu gêja ma lau Aiguptu sêkôniŋ eŋ ŋa gêŋwapac naŋ, amac tamemi sêmôêc gêdêŋ Apômtau. Go eŋ kêsakiŋ Mose agêc Aron, taŋ sêkôc tamemi su aŋga Aiguptu ma sêkêŋ êsêac sêŋgôŋ gamêŋ tonec. ");
INSERT INTO jae_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Mago êsêac sêliŋ Apômtau, nêŋ Anôtô siŋ, tec Anôtô gêwi êsêac siŋ sêsêp kiŋ Hasor aŋga Jabin nê siŋsêlêc Sisera ma lau Pilisti to lau Moab nêŋ kiŋ, taŋ sêjac siŋ gêdêŋ êsêac naŋ lemeŋ. ");
INSERT INTO jae_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Gêdêŋ tonaŋ êsêac têtaŋ gêdêŋ Apômtau ma sêsôm gebe ‘Aêac agôm sec, aêac awi Apômtau siŋ ma ajam sakiŋ Bal agêc Astarot. Mago galoc ônam aêac kêsi aŋga ma ŋacjo nêŋ ma aêac anam sakiŋ aômgeŋ.’ ");
INSERT INTO jae_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Amboac tonaŋ Apômtau kêkêŋ Jerubal agêc Balak ma Jepta agêc Samuel sêjam amac kêsi aŋga nêm ŋacjo, taŋ sêgî amac auc naŋ, lemeŋ ma amac amoa ŋajam. ");
INSERT INTO jae_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“Ma gêdêŋ taŋ alic lau Amon nêŋ kiŋ Nahas gêmêŋ gebe ênac siŋ êndêŋ amac naŋ, amac aliŋ nêm kiŋ ŋanô Apômtau, amacnêm Anôtô, siŋ ma asôm gadêŋ aê gebe ‘Masi, kiŋ teŋ anam gôliŋ aêac.’ ");
INSERT INTO jae_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Amboac tonaŋ kiŋ, taŋ ajaliŋ sa to ateŋ eŋ naŋ, Apômtau kêkêŋ eŋ gebe ênam gôliŋ amac. ");
INSERT INTO jae_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Embe atoc Apômtau sa ma anam sakiŋ eŋ akêŋ taŋem ênê biŋ ma ali awem sa êndêŋ Apômtaunê biŋsu atom, embe amac to nêm kiŋ tau, tec gêjam gôliŋ amac nec andaŋguc Apômtau, nêm Anôtô, go amoa ŋajam. ");
INSERT INTO jae_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Mago amac embe akêŋ taŋem Apômtaunê biŋ atom, ma embe ali awem sa êndêŋ ênê biŋsu, go Apômtaunê lêma oc enseŋ amac êtôm gêgôm gêdêŋ tamemi. ");
INSERT INTO jae_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Amboac tonaŋ atu gasuc amêŋ ma alic gêŋtalô kapôêŋ naŋ, Apômtau oc êŋgôm êndêŋ amac matemanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Galoc noc tanac mopolom ŋanô saŋa me. Aê oc jateŋ Apômtau ma eŋ êkêŋ wapap to kom ênac, go alic to ajala gebe Apômtau gêlic nêm biŋ ateŋ kêtu kiŋŋa sec.” ");
INSERT INTO jae_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Go Samuel keteŋ Apômtau, ma Apômtau kêkêŋ wapap to kom gêjac gêdêŋ oc tonaŋ. Ma lau samob têtêc Apômtau agêc Samuel ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Ma sêsôm gêdêŋ Samuel gebe “Oteŋ Apômtau, aômnêm Anôtô, ôjô nêm sakiŋwaga aêac su, gebe ênam aêac sa ec amac êndu atom. Gebe ma sec gêc kwanaŋgeŋ ma agôm keso tonaŋ jagêwiŋ gebe ateŋ kiŋ teŋ.” ");
INSERT INTO jae_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuel kêsôm gêdêŋ lau gebe “Atêc taôm atom. Amac agôm sec samob tonaŋ biŋŋanôgeŋ, tageŋ andaŋguc Apômtau awi siŋ atom, anam sakiŋ Apômtau ŋa nêm ŋalêlôm samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Akac taôm su aŋga ênê atom gebe anam sakiŋ gwam, taŋ sênam lau sa to sênam lau kêsi sêŋgôm êtôm atom naŋ, gebe ŋanô masi. ");
INSERT INTO jae_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Apômtau oc êtiŋ amac su atom kêtu ênê ŋaê kapôêŋŋa. Eŋ kêsôm kêtu tôŋ gebe êkêŋ amac atu ênê lau. ");
INSERT INTO jae_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Aê tauc amboac tonaŋ. Aê janac jaê biŋ tonec gebe jaŋgôm sec êndêŋ Apômtau ma jawi mec êtu amacŋa siŋ atom. Masianô, aê oc jandôŋ intêna ŋajam to solop êndêŋ amac jamoa. ");
INSERT INTO jae_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Tageŋ atêc Apômtau to anam sakiŋ eŋ ŋaŋêŋ to nêm ŋalêlôm samucgeŋ. Asala gêŋsêga samob, taŋ eŋ gêgôm kêtu amacŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Mago embe aŋgôm sec amoa, go amac anaŋa to nêm kiŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Saulnê jala kêtu ... ma eŋ kêtu kiŋ, ma eŋ gêjam gôliŋ Israel jala ... ");
INSERT INTO jae_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Eŋ kêjaliŋ ŋacwaga 3,000 sa aŋga Israel. 2,000 sêmoa sêwiŋ eŋ sêŋgôŋ malac Mikmas to gamêŋ lôc Betelŋa. Ma 1,000 sêmoa sêwiŋ Jonatan sêŋgôŋ malac Gibea Benjaminŋa. Lau siŋ ŋagêdô samob Saul gêwi siŋ sêmu sêja nêŋ malac. ");
INSERT INTO jae_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Go Jonatan gêjac lau Pilisti nêŋ gejobwaga, taŋ gêŋgôŋ Gibea naŋ êndu. Lau Pilisti sêŋô biŋ tonaŋ ŋawae. Go Saul kêjatu lau sêjac dauc kêtaŋ kêtôm gamêŋgeŋ ma kêjatu gebe “Lau Hebrai sêkêŋ taŋeŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Lau Israel samob sêŋô Saul gêjac Pilisti nêŋ gejobwaga êndu ŋawae ma sêŋô gebe nêŋ waeŋ kêtu sec aŋga lau Pilisti nêŋ. Ma Saul kêkalem lau samob gebe sêndaŋguc eŋ sêna malac Gilgal. ");
INSERT INTO jae_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Lau Pilisti sêkac tauŋ sa sebe sênac siŋ êndêŋ Israel. Êsêacnêŋ kareta siŋŋa 3,000 to lau sêŋgôŋ hos ŋaôŋa 6,000 ma lau siŋ ŋagêdô taêsam ŋanô lasê kêtôm gaŋac gwêcŋa. Êsêac sêpi jasê nêŋ becobo aŋga malac Mikmas, taŋ gec Bet Awen ŋamakeŋ oc kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Gêdêŋ taŋ lau Israel sêlic gebe lau Pilisti oc sêôc êsêac popoc gebe sêkapiŋ êsêac sa ŋanôgeŋ naŋ, êsêac sêsiŋ tauŋ ôkwi semoa poclabu to nom gêsuŋ ma poc kapôêŋ-kapôêŋ ŋasawa to sê tuc ma sê buŋa. ");
INSERT INTO jae_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Ma ŋagêdô selom bu Jordan jasêmoa Gad to Gilead ŋagamêŋ. Saul gacgeŋ gêmoa malac Gilgal ma lau samob, taŋ têdaguc eŋ naŋ, têtêc tauŋ ŋasec. ");
INSERT INTO jae_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Saul kêsaê bêc 7, kêtôm taŋ Samuel kêsam gêdêŋ eŋ gebe naêndac eŋ naŋ, mago Samuel jagêô lasê Gilgal atom. Amboac tonaŋ lau sêwi Saul siŋ-siŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Tec Saul kêsôm gebe “Akôc daja to dawama andêŋ aê amêŋ.” Ma eŋ tau kakêŋ daja tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Saul kêkêŋ da tau gêbacnê su, go Samuel mêŋgêô lasê. Saul kêpuc eŋ tôŋ-tôŋ gebe ê moalêc eŋ. ");
INSERT INTO jae_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Mago Samuel kêsôm gebe “Aôm gôgôm asageŋ.” Ma Saul gêjô eŋ awa gebe “Aê galic lau sêwi aê siŋ ma aôm gômôêŋ kêtôm gôjac noc naŋ atom ma lau Pilisti sêkac tauŋ sa aŋga Mikmas, ");
INSERT INTO jae_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","tec taêc gêjam gebe lau Pilisti oc sêsêp Gilgal mêŋsênac aê êmuŋ noc jamansaŋ biŋ êndêŋ Apômtau êtu êlic aê ŋajamŋa. Amboac tonaŋ ŋoc ŋalêlôm kêkac aê ma kakêŋ daja tau.” ");
INSERT INTO jae_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Go Samuel kêsôm gêdêŋ Saul gebe “Aôm gôgôm gêŋ meloc, gôgôm Apômtau, aômnêm Anôtô, nê biŋsu, taŋ kêjatu aôm naŋ, ŋanô kêsa atom. Embe ôŋgôm ŋanô êsa oc Apômtau ênac dabiŋ aôm gebe ôtu Israelnêŋ kiŋ endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Mago galoc nêm gôliŋ kiŋŋa oc ênêc endeŋ tôŋgeŋ atom. Apômtau kêjaliŋ nê ŋac teŋ sa kêtôm ênê ŋalêlôm ma kêkêŋ eŋ kêtu ênê launêŋ gôliŋwaga gebe aôm gôgôm biŋ, taŋ Anôtô kêjatu aôm naŋ, ŋanô kêsa atom.” ");
INSERT INTO jae_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Ma Samuel gêdi aŋga Gilgal jakêpi malac Gibea Benjaminŋa. Saul kêsa lau, taŋ sêmoa sêwiŋ eŋ naŋ sa. Lau tau amboac 600 geŋ. ");
INSERT INTO jae_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Saul agêc latu Jonatan ma lau, taŋ sêmoa sêwiŋ eŋ naŋ, jasêŋgôŋ malac Gibea Benjaminŋa ma lau Pilisti sêŋgôŋ nêŋ becobo aŋga malac Mikmas. ");
INSERT INTO jae_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Aŋga tonaŋ lau Pilisti sêsakiŋ siŋwaga gebe sêjaŋgo launêŋ gêŋ. Êsêac sêwa tauŋ kêkôc gêja mata têlêac. Mata teŋ gêja malac Opra, taŋ gêc gamêŋ Sualŋa. Mata teŋ gêja malac Bet Horon ");
INSERT INTO jae_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","ma teŋ kepeŋ gamêŋ ŋabau, taŋ sêkô ma sêlic gaboaŋ Seboim to gamêŋ sawa naŋ. ");
INSERT INTO jae_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Aŋga gamêŋ Israel samucgeŋ ŋackêpac-kiwaga teŋ gêmoa atom gebe lau Pilisti sêsôm gebe” O moae lau Ebolai sêmansaŋ siŋ to kêm ki”. ");
INSERT INTO jae_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Tec lau Israel samob dêdêŋ lau Pilisti sêja gebe sêuc êsêacnêŋ sakweŋ ki to kinom ma ki to bôjaŋ jalô. ");
INSERT INTO jae_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Lau Pilisti embe sêuc sakweŋ ki me kinom, go lau Israel sênam ôli ŋa mone têlêac, ma embe sêuc ki me bôjaŋ jalô, go sênam ôli ŋa mone tageŋ. ");
INSERT INTO jae_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Amboac tonaŋ gêdêŋ siŋ kêsa lau samob, taŋ sêmoa sêwiŋ Saul agêc Jonatan naŋ, nêŋ teŋ kêkôc siŋ me kêm ki atom, Saul agêc Jonatan tauŋgeŋ tec sêkôc. ");
INSERT INTO jae_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Lau Pilisti sêsakiŋ siŋwaga toŋ teŋ gebe sejop intêna ŋamaŋgi Mikmasŋa. ");
INSERT INTO jae_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Bêc teŋ Saul latu Jonatan kêsôm gêdêŋ ŋac, taŋ gêôc ênê laukasap naŋ gebe “Ajôc, dandêŋ Pilistinêŋ siŋwaga, taŋ sêŋgôŋ ŋamakeŋ ônêŋa naŋ tana.” Mago kêsôm ŋawae gêdêŋ tama atom. ");
INSERT INTO jae_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Gêdêŋ tonaŋ Saul kêkô ka ŋanô teŋ ŋalabu aŋga malac Migron, taŋ gêc Gibea naŋ, ma lau 600 sêmoa sêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Ma Ahija, Iskiabod nê lasi Ahitub latu eŋ kêsô ŋakwê dabuŋ. Ahitub eŋ Apômtaunê dabuŋwaga Eli, taŋ gêŋgôŋ Silo naŋ, nê latu Pinehas latu eŋ. Lau teŋ sêŋô Jonatan gêja ŋawae atom. ");
INSERT INTO jae_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Aŋga intêna ŋamaŋgi, taŋ Jonatan kêsa gebe naêô lasê lau Pilisti nêŋ siŋwaga naŋ, poc soso baliŋ luagêc kêkô makeŋ-makeŋ, sêsam teŋ gebe Beses ma teŋ gebe Sene. ");
INSERT INTO jae_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Teŋ kêkô gêmu kêsô Mikmasŋa ma teŋ kêkô gêmu kêsa Gebaŋa. ");
INSERT INTO jae_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Jonatan kêsôm gêdêŋ ŋac, taŋ gêôc ênê laukasap naŋ, gebe “Ajôc, talom dandêŋ lau samuc naŋ siŋwaga tana. Oc moae Apômtau ênam kôm êtu aêagêcŋa. Eŋ kêtôm gebe êkêŋ aêagêc taku ŋacjo tulu ma ŋacjo taêsam me luagêcgeŋ têtôm gebe sêkô eŋ auc atom.” ");
INSERT INTO jae_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Ma ênê ŋac, taŋ gêôc ênê laukasap naŋ, gêjô eŋ awa gebe “Ôŋgôm êtôm aôm taêm gêjam. Ônamaŋ. Aê oc jawiŋ aôm. Biŋ taŋ aôm taêm gêjam naŋ, aê taêc gêjam amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Jonatan kasôm gebe “Ŋajam, talom natatôc tauŋ êndêŋ êsêac sêlic aêagêc. ");
INSERT INTO jae_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Êsêac embe sêsôm êndêŋ aêagêc gebe ‘Akô tonaŋ e aêac awac’, go aêagêc takô maleŋ ma dandêŋ êsêac tana atom. ");
INSERT INTO jae_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Mago embe sêsôm gebe ‘Api andêŋ aêac amêŋ’, go aêagêc tapi tana gebe biŋ tonaŋ oc êkêŋ puc aêagêc gebe Apômtau kêkêŋ lau Pilisti sêsêp aêagêc lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Amboac tonaŋ êsêagêc têtôc tauŋ gêdêŋ Pilisti nêŋ siŋwaga sêlic êsêagêc. Ma lau Pilisti sêsôm gebe “Alic acgom, Ebolai sêsa aŋga gêsuŋ, taŋ sêsiŋ tauŋ sêmoa naŋ sêmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Go sêmôêc gêdêŋ Jonatan agêc nê ŋac, taŋ gêôc ênê laukasap naŋ, gebe “Api andêŋ aêac amêŋ. Aêac abe atôc gêŋ teŋ êndêŋ amagêc.” Jonatan kêsôm gêdêŋ nê ŋac gebe “Ajôc, ôndaŋguc aê. Apômtau kêkêŋ êsêac sêsêp Israel lemeŋ sugac.” ");
INSERT INTO jae_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Jonatan kêgalap kêpi ŋa akaiŋ to lêma gêmuŋ ma nê ŋac kêdaguc eŋ. Jonatan kêsôlô lau Pilisti jagwac-jagwac jasêc ma nê ŋac gêjac êsêac êndu kêdaguc-kêdaguc. ");
INSERT INTO jae_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Jonatan agêc nê ŋac sêjac siŋ kwapuc ma sêjac lau amboac 20 êndu aŋga nom ŋasawa sauŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Pilisti nêŋ siŋwaga selendec ŋanô ma lau Pilisti samob amboac tonaŋ. Siŋwaga to sêjaŋgowaga katuŋ uŋ tageŋ. Ôjô gêjam ma Anôtô kêtakê êsêac ŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Saulnê dibwaga aŋga malac Gibea Benjaminŋa sêlic Pilisti sêwê sêlêsageŋ. ");
INSERT INTO jae_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Amboac tonaŋ Saul kêsôm gêdêŋ lau, taŋ sêwiŋ eŋ naŋ gebe “Asa lau sa ma alic asa gêwi aêac siŋ.” Sêsa lau sa e sêlic gebe Jonatan agêc ŋac, taŋ gêôc ênê laukasap naŋ, sêmoa atom. ");
INSERT INTO jae_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Tec kêsôm gadêŋ Ahija gebe “Ôkôc Anôtônê poac ŋakatapa ômôêŋ.” Gêdêŋ ŋasawa tonaŋ êsêac sêbalaŋ Anôtônê poac ŋakatapa gêwiŋ lau Israel. ");
INSERT INTO jae_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Saul kêsôm biŋ gêdêŋ dabuŋwaga gêmoa ma ŋaonda aŋga Pilisti nêŋ gamêŋ becoboŋa kêtu kapôêŋ. Tec Saul kêsôm gêdêŋ dabuŋwaga gebe “Ôpuc kapoac dabuŋ atom.” ");
INSERT INTO jae_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Go Saul gêwiŋ lau samob, taŋ sêmoa sêwiŋ naŋ, têdênaŋ tauŋ sebe sênac siŋ. Êsêac sêlic gebe lau Pilisti sêjac tauŋ sejogeŋ ma ŋalênsôŋ kêtu kapôêŋ. ");
INSERT INTO jae_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Ma lau Ebolai, taŋ sêmoa sêwiŋ Pilisti kwanaŋgeŋ ma sêwiŋ êsêac jasêŋgôŋ gamêŋ becoboŋa naŋ, sêwi êsêac siŋ ma sêkac tauŋ ôkwi jasêwiŋ Saul agêc Jonatan. ");
INSERT INTO jae_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Ma lau Israel samob, taŋ sêsiŋ tauŋ sêmoa lôc Epraim naŋ, sêŋô ŋawae gebe lau Pilisti sêc siŋ su sêja, tec êsêac jasêwiŋ ma sêjanda lau Pilisti amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Amboac tonaŋ Apômtau gêjam Israel kêsi gêdêŋ bêc tonaŋ ma sêjac siŋ e jasêlêlêc malac Bet Awen su. ");
INSERT INTO jae_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Lau Israel sêjac siŋ e tekweŋ gêbac samucgeŋ, gebe gêdêŋ bêc tonaŋ Saul kêtôc lêma ma kêjatu nê lau gebe “Aê japuc boa ŋac, taŋ êniŋ gêŋ e oc naêsêp ma aê jakac ŋoc kamocgôc êpi ŋoc ŋacjo.” Amboac tonaŋ lau teŋ aweŋsuŋ kêsac gêŋ taniŋŋa teŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Ma lau samob jasêô lasê maleŋ ma têtap lêp sa gêc nom. ");
INSERT INTO jae_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Mago lau, taŋ têtap sa ma sêlic lêp tau gêwê naŋ, nêŋ teŋ kêmêtôc lêma jakêkôc mêŋgeŋ ŋagec atom gebe têtêc Saul nê biŋ kêpuc boaŋa. ");
INSERT INTO jae_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Mago Jonatan gêŋô tama kêsôm biŋ êpuc boa lauŋa tonaŋ atom. Tec eŋ kêmêtôc nê tôc, taŋ kêmêgôm naŋ, jakêsac ŋatêpôê kêsêp lêp, go kêkêŋ kêsô awasuŋ ma gêŋ tau kêlau eŋ. ");
INSERT INTO jae_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Go lau tau nêŋ ŋac teŋ kêsôm gêdêŋ eŋ gebe “Tamam gêjac jao gêŋ tonaŋ to kêtôc lêma gêwiŋ ma kêsôm gebe ‘Aê japuc boa ŋac, taŋ êniŋ gêŋ êndêŋ ocsalô tonec.’ Tec lau samob tekweŋ gêbac.” ");
INSERT INTO jae_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Go Jonatan kêsôm gebe “Aê tamoc gêgôm keso gêdêŋ aêacnêŋ lau, Alic acgom, aê matocanô ŋawa kêsa gebe gaeŋ lêp tonec ŋagecgeŋ. ");
INSERT INTO jae_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Ocsalô tonec lau embe sêniŋ gêŋ, taŋ sêjaŋgo su aŋga ŋacjo nêŋ naŋ, oc ŋajam êlêlêc, oc sênac lau Pilisti popoc samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Gêdêŋ bêc tonaŋ lau Israel sêku lau Pilisti tulu to sêjanda êsêac aŋga Mikmas e gêdêŋ Aijalon. Mago lau tekweŋ gêbac ŋanô. ");
INSERT INTO jae_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Tec êsêac jasêkac domba to bulimakao ŋalatu, taŋ sêjaŋgo su naŋ ŋagaôgeŋ, ma sêjac êndu gêc nom ŋaôma paliŋ-paliŋgeŋ ma seŋ ŋamêsôm todecgeŋ. ");
INSERT INTO jae_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Go êsêac sêsôm gêdêŋ Saul gebe “Ôŋô acgom, lau sêgôm sec gêdêŋ Apômtau ma seŋ gêŋ todec.” Eŋ kêsôm gebe “Amac agôm secgoc. Ansambi poc kapôêŋ teŋ êmêŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Go Saul gêjac têku nê biŋ gebe “Andêŋ lau naasôm êndêŋ êsêac gebe ‘Lau samobgeŋ sêkôc nêŋ bulimakao to domba dêndêŋ aê sêmêŋ gebe sêmbuc aŋga tonec ma sêniŋ. Mago aŋgôm sec êndêŋ Apômtau gebe aniŋ gêŋ todecgeŋ atom.’” Amboac tonaŋ gêdêŋ gêbêc lau samob sêkôc nêŋ bulimakao gêdêŋ-gêdêŋgeŋ sêmêŋ ma sêbuc aŋga tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Ma Saul gêboa Apômtaunê altar teŋ sa ma altar tau kêtu Saulnê altar ŋamataŋa, taŋ gêboa gêdêŋ Apômtau naŋ. ");
INSERT INTO jae_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Go Saul kêsôm gebe “Ajôc, tasêp tandaŋguc lau Pilisti tana êndêŋ êmbêc ma tajaŋgo êsêacnêŋ gêŋ su e oc êpi, ma êsêacnêŋ ŋac teŋ êwê aêac sa atom.” Lau samob sêjô eŋ awa gebe “Ôŋgôm gêŋ, taŋ taêm gêjam gebe ŋajam naŋ.” Mago dabuŋwaga kêsôm gebe “Tatu gasuc dandêŋ Apômtau tana acgom.” ");
INSERT INTO jae_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Amboac tonaŋ Saul kêtu kênac Anôtô gebe “Aê jasêp najanda lau Pilisti me masi. Aôm oc ôkêŋ êsêac sêsêp Israel lemeŋ me masi.” Mago Anôtô gêjô eŋ awa gêdêŋ bêc tonaŋ atom. ");
INSERT INTO jae_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Tec Saul kêsôm gebe “Amac lau nêŋ kasêga samob, amêŋ ma akip biŋ sa e ajala gebe asa gêgôm keso gedeŋ ocsalô tonec biŋŋanôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Aê jasôm êtu tôŋ êtu Apômtau, Israelnêŋ kêsiwaga, taŋ gêmoa mata jali naŋŋa, gebe biŋ tau embe anêc aê latuc Jonatanŋa eŋ oc êmac êndu biŋŋanô.” Mago lau nêŋ teŋ gêjô eŋ awa atom. ");
INSERT INTO jae_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Go Saul kêsôm gêdêŋ lau Israel samob gebe “Amac lau samob akô ŋamakeŋ ma aêagêc latuc Jonatan akô ŋamakeŋ.” Ma lau samob sêjô eŋ awa gebe “Ôŋgôm gêŋ, taŋ gôlic gebe oc ŋajam naŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Tec Saul kêsôm gebe “O Apômtau, Israelnêŋ Anôtô, amboac ondoc tec gôjô nêm sakiŋwaga awa gêdêŋ ocsalô tonec atom. O Apômtau, Israelnêŋ Anôtô, tôp tau embe ênêc aê me latuc Jonatan, go ôkêŋ Urim, mago embe tôp tau ênêc nêm lau Israelŋa, go ôkêŋ Tumim.” Ma Jonatan agêc Saul sêwê kaiŋ tôp ma lau Israel sêmoa. ");
INSERT INTO jae_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Go Saul kêsôm kêtiam gebe “Apuc kapoac êtu aêagêc latuc Jonatanŋa.” Ma kêtap Jonatan sa. ");
INSERT INTO jae_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Go Saul kêsôm gêdêŋ Jonatan gebe “Ôsôm êndêŋ aê gebe gôgôm asageŋ.” Tec Jonatan kêsôm lasê gêdêŋ eŋ gebe “Biŋŋanô, aê gaeŋ lêp ŋagec, taŋ kêsap tôc, taŋ kamêgôm naŋ tôŋ. Aê tec kakô aê jamac êndumaŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Ma Saul kêsôm gêdêŋ eŋ gebe “Aôm embe ômac êndu atom, go Anôtô enseŋ aê sumaŋ.” ");
INSERT INTO jae_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Go lau sêsôm gêdêŋ Saul gebe” Jonatan taŋ kêku ŋacjo tulu toŋaclaigeŋ aŋga Israel ŋalêlôm naŋ, oc êmac êndu me. Masianô. Aêac asôm êtu tôŋ êtu Apômtau, taŋ gêmoa mata jali naŋŋa gebe ênê môkêlauŋ tageŋ êu tau êsêp nom atom.” Amboac tonaŋ lau sêjam Jonatan kêsi gebe êmac êndu atom. ");
INSERT INTO jae_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Go Saul kêjanda lau Pilisti kêtiam atom ma gêc gêja. Ma lau Pilisti sêc sêmu sêja nêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Gêdêŋ taŋ Saul kêtu kiŋ Israelŋa su naŋ, eŋ gêjac siŋ gêdêŋ nê ŋacjo aŋga gamêŋ samob. Eŋ gêjac siŋ gêdêŋ lau Moab to Amon ma Edom, gêjac siŋ gêdêŋ kiŋ Sobaŋa ma gêdêŋ lau Pilisti. Aŋga gamêŋ samob, taŋ eŋ gêjac siŋ kêsa naŋ, eŋ kêku êsêac tulu. ");
INSERT INTO jae_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Eŋ kêtôc nê ŋaclai ma kêku lau Amalek tulu, ma gêjam Israel kêsi aŋga lau sêjaŋgowaga nêŋ. ");
INSERT INTO jae_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Saul latui nêŋ ŋaê tonec gebe Jonatan agêc Iswi ma Malkisua. Ma latuio nêŋ ŋaê tonec gebe awêsêga nê ŋaê Merab, ma awê sauŋ nê Mikal. ");
INSERT INTO jae_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Saul tau nê awê nê ŋaê gebe Ahinoam, eŋ Ahimas latuo. Ênê siŋwaganêŋ ŋac siŋsêlêc nê ŋaê Abner. Eŋ Saul tama sauŋ Ner latu. ");
INSERT INTO jae_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Saul tama Kis ma Abner tama Ner êsêagêc nêŋ tameŋi Abiel. ");
INSERT INTO jae_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Gêdêŋ têm samob, taŋ Saul gêmoa nom naŋ, eŋ gêjac siŋ ŋajaŋa sec gêdêŋ lau Pilisti ŋapaŋ. Ma eŋ embe êlic ŋactêkwa to ŋaclai teŋ, naŋ eŋ êkêŋ eŋ naêwiŋ ênê siŋwaga. ");
INSERT INTO jae_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Samuel kêsôm gadêŋ Saul gebe “Apômtau kêsakiŋ aê gebe janiŋ oso aôm ôtu ênê lau Israel nêŋ kiŋ. Amboac tonaŋ galoc ôkêŋ taŋam Apômtau awa acgom. ");
INSERT INTO jae_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Lau siŋ undambêŋa nêŋ Apômtau kêsôm biŋ tonec gebe ‘Aê gabe jakêŋ ŋagêjô êndêŋ Amalek êjô gêŋ, taŋ êsêac sêgôm gêdêŋ Israel. Êsêac sêkô intêna auc êsêac gêdêŋ taŋ sêpi aŋga Aiguptu samaŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Galoc ôna ma ônac Amalek ma onseŋ êsêac to naŋ gêŋ samob su. Taêm walô êsêac atom. Ônac samob êndu, ŋacwaga to lauo ma ŋapalêo to ŋac ma ŋapalê dedec, bulimakao to domba ma kamel to doŋki.’” ");
INSERT INTO jae_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Tec Saul kakalem lau sêpi tageŋ aŋga Telaim. Êsêac siŋwaga Israelŋa 200,000 ma Judawaga 10,000. ");
INSERT INTO jae_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Saul mêŋgêô lasê Amaleknêŋ malacsêga ma gêwa êsêac gêc nêŋ gamêŋŋa gaboaŋ. ");
INSERT INTO jae_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Go Saul kêsakiŋ biŋ gadêŋ lau Ken gebe “Andi, awi Amalek siŋ, aêc asêp ana gebe janseŋ amac su awiŋ êsêac atom, gebe amac amoasiŋ lau Israel gadêŋ taŋ sêpi aŋga Aiguptu sêmêŋ naŋ.” Amboac tonaŋ lau Ken sêwi lau Amalek siŋ. ");
INSERT INTO jae_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Go Saul kêku lau Amalek tulu aŋga malac Hawila e gêdêŋ Sur, taŋ gêc kêkanôŋ Aiguptu ŋagamêŋ oc kêpiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Eŋ kakôc lau Amalek naŋ kiŋ Agag tôŋ tomata jaligeŋ ma geseŋ lau samob su ŋa siŋ. ");
INSERT INTO jae_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Mago Saul to nê lau taêŋ walô Agag ma domba to bulimakao ŋalatu ŋajam-ŋajam to domba ŋalatu ma gêŋ ŋagêdô samob, taŋ sêlic ŋajam naŋ, tec sebe senseŋ su sênaŋa atom. Mago êsêac seseŋ gêŋ sec-sec to ŋatêkê samobgeŋ su. ");
INSERT INTO jae_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Tec Apômtau nê biŋ gêdêŋ Samuel gebe ");
INSERT INTO jae_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Aê gaeŋ oliŋ gebe kakêŋ Saul kêtu kiŋ owageŋ gebe eŋ gêbuc dêmôê aê ma gêgôm aêŋoc jatu ŋanô kêsa atom.” Samuel nê ŋalêlôm ŋawapac ma kêtaŋ gêdêŋ Apômtau gêdêŋ gêbêc samuc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Ŋabêbêc kanucgeŋ Samuel gêdi gebe êpuc Saul tôŋ-tôŋ gêja. Go biŋ tonec gêdêŋ Samuel gebe “Saul kêpi lôc Karmel ma jagêboa ŋabelo teŋ sa kêtu eŋ tauŋa aŋga tonaŋ, go kêkac tau ôkwi kêsêp malac Gilgal gêja.” ");
INSERT INTO jae_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samuel jakêtap Saul sa ma Saul gê moalêc eŋ gebe “Apômtau ênam mec aôm. Aê gagôm Apômtaunê jatu ŋanô kêsagac.” ");
INSERT INTO jae_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Mago Samuel kêsôm gebe “Ŋam amboac ondoc, tec gaŋô domba kêtaŋ kêsô taŋocsuŋ ma bulimakao kêtaŋ mêŋgaŋô.” ");
INSERT INTO jae_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saul gêjô eŋ awa gebe “Lau sêkôc gêŋ tau aŋga Amaleknêŋ. Êsêac taêŋ walô domba to bulimakao ŋajam-ŋajam tonec gebe sêkêŋ êtu da êndêŋ Apômtau, aômnêm Anôtô. Gêŋ ŋagêdô aêac aseŋ su samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Ma Samuel kêsôm gêdêŋ Saul gebe “Kêtômgac. Aê gabe jasôm biŋ, taŋ Apômtau kêsôm gêdêŋ aê gêdêŋ gêbêc naŋ, êndêŋ aôm.” Ma eŋ gêjô eŋ awa gebe “Ôsôm acgom.” ");
INSERT INTO jae_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ma Samuel kêsôm gebe “Aôm gôlic taôm amboac ŋac ŋaôma, mago kôtu gôlôacmôkê Israelŋa nêŋ laumata ma Apômtau geŋ oso aôm kôtu Israelnêŋ kiŋ. ");
INSERT INTO jae_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ma Apômtau kêsakiŋ aôm gebe naonseŋ lau alôb-alôb Amalek su ma ônac siŋ êndêŋ êsêac e sênaŋa samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Kêtu asageŋŋa aôm taŋam wamu Apômtau awa atom. Kêtu ageŋŋa nêm ŋalêlôm kêboaŋ kêtu êsêacnêŋ awamataŋa ma gôgôm gêŋ, taŋ Apômtau gêlic sec naŋ.” ");
INSERT INTO jae_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saul gêjô Samuel awa gebe “Aê taŋoc wamu Apômtau. Aê gaja kêtôm Apômtau kêsakiŋ aê. Ma aê kakôc lau Amalek nêŋ kiŋ Agag gamêŋ ma gaseŋ Amalek ŋagêdô samob su sêjaŋa. ");
INSERT INTO jae_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Mago lau sêkôc domba to bulimakao aŋga awa siŋŋa ŋajamanô tau, taŋ Apômtau kêjatu gebe sênaŋa naŋ, gebe sêkêŋ êtu da êndêŋ Apômtau, aômnêm Anôtô aŋga malac Gilgal.” ");
INSERT INTO jae_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Go Samuel kêsôm gebe “Apômtau mataanô gêlic daja to da ŋagêdô ŋawa kêtôm takêŋ taŋeŋ Apômtau awa me. Ôlic acgom, taŋeŋ wamu kêlêlêc da su ma takêŋ taŋeŋ naŋ kêlêlêc domba kapoac ŋalêsi su amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Taŋeŋpêc tau gêŋ sec kêtôm beŋ ma gêsuŋ têkwa ŋatoŋ kêtôm sakiŋ gwamŋa. Aôm kôtiŋ Apômtaunê biŋ su, tec Apômtau kêtiŋ aôm su. Kôtu kiŋ kêtômgac.” ");
INSERT INTO jae_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Go Saul kêsôm gêdêŋ Samuel gebe “Aê gagôm secgoc gebe kagêli Apômtaunê jatu to aômnêm biŋ. Aê katêc lau ma kakêŋ taŋoc êsêac aweŋ. ");
INSERT INTO jae_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Mago galoc jateŋ aôm gebe ôsuc ŋoc sec ôkwi ma ôwiŋ aê, agêc tamu tana gebe janam sakiŋ êndêŋ Apômtau.” ");
INSERT INTO jae_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Mago Samuel gêjô eŋ awa gebe “Oc jawiŋ aôm atom, gebe aôm kôtiŋ Apômtaunê biŋ su, tec Apômtau kêtiŋ aôm su gebe ôtu Israelnêŋ kiŋ êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Go Samuel kêkac tau ôkwi gebe êc êna ma Saul gê eŋ tôŋ kêsêp nê ŋakwê ŋalêsu e gêŋgic. ");
INSERT INTO jae_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Tec Samuel kêsôm gêdêŋ eŋ gebe “Ocsalô tonec Apômtau kêkao sakiŋ kiŋŋa su aŋga aômnêm amboac tonaŋ ma kêkêŋ gêdêŋ ŋac wacbaŋ aôm ŋa teŋ, taŋ ŋajam kêlêlêc aôm su naŋ. ");
INSERT INTO jae_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Israelnêŋ Anôtô ŋawasi kêsau biŋ to gêjam tau ôkwi atom. Eŋ ŋamalac gebe ênam tau ôkwi-ôkwi nec atom.” ");
INSERT INTO jae_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Go Saul kêsôm gebe “Aê kajala gebe gagôm secgoc. Mago otoc aê sa ŋoc launêŋ laumata to lau Israel sêlic ma ôwiŋ aê, agêc tamu tana gebe janam sakiŋ Apômtau, aômnêm Anôtô.” ");
INSERT INTO jae_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Go Samuel kêkac tau ôkwi kêdaguc Saul. Ma Saul gêjam sakiŋ gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Su, go Samuel kêsôm gebe “Akôc Amaleknêŋ kiŋ Agag andêŋ aê amêŋ.” Agag kêsêlêŋ gêdêŋ eŋ toŋalêlôm ŋatutucgeŋ ma kêsôm gêc tau gebe “Tamac êndu kêtu gêŋ ŋamakicgoc.” ");
INSERT INTO jae_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ma Samuel kêsôm gebe “Kêtôm aômnêm siŋ geseŋ lauonêŋ ŋapalê su, tec aôm tênam nê ŋapalê masi amboac tonaŋgeŋ.” Ma Samuel gêjac Agag popoc-popocgeŋ kêkô Apômtau laŋônêmŋa aŋga Gilgal. ");
INSERT INTO jae_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Go Samuel gêja Rama ma Saul kêpi gêja nê andu aŋga Gibea. ");
INSERT INTO jae_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Samuel gêlic Saul kêtiam atom e gêmac êndu, mago Samuelnê ŋalêlôm ŋawapac kêtu Saulŋa. Ma Apômtaunê ŋalêlôm gêbuc dêmôê gebe kêkêŋ Saul kêtu Israelnêŋ kiŋ wageŋ. ");
INSERT INTO jae_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Apômtau kêsôm gêdêŋ Samuel gebe “Nêm ŋalêlôm ŋawapac êtu Saulŋa e êndêŋ ondocgeŋ. Aê katiŋ eŋ su gebe êtu Israelnêŋ kiŋ êtiam atom. Ôkêc niptêkwi êsêp nêm ŋoplakôp ma ôsêlêŋ. Aê jasakiŋ aôm ôndêŋ ŋac Betlehemŋa Isai ôna gebe kajaliŋ latuinêŋ teŋ sa gebe êtu kiŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Mago Samuel kêtu kênac gebe “Aê oc jana amboac ondoc. Saul embe êŋô ŋawae, oc ênac aê êndu.” Go Apômtau gêjô eŋ awa gebe “Ôkôc bulimakao têna wakuc teŋ êwiŋ ma ôsôm gebe ‘Aê gamêŋ gabe jakêŋ da êndêŋ Apômtau.’ ");
INSERT INTO jae_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Go ôkalem Isai êniŋ da ŋamoasiŋ êwiŋ. Aê oc jaoc biŋ, taŋ ôŋgômŋa naŋ, lasê êndêŋ aôm. Ma aôm ôniŋ oso ŋac, taŋ aê oc jasam êndêŋ aôm naŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuel gêgôm kêtôm Apômtau kêsôm gêdêŋ eŋ ma gêja malac Betlehem. Malac tau ŋagejobwaga sêpuc eŋ tôŋ-tôŋ tonêŋ ŋalêlôm ŋatutucgeŋ ma sêsôm gebe “Kôsêlêŋ biŋ ŋajamŋa me.” ");
INSERT INTO jae_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Eŋ gêjô êsêac aweŋ gebe “Aec, aê gamêŋ kêtu biŋ ŋajamŋa. Aê gamêŋ gabe jakêŋ da êndêŋ Apômtau. Anam dabuŋ taôm gebe mêŋêwiŋ aê ma takêŋ da tau.” Go eŋ tau gêjam mec Isai to latui ma keteŋ êsêac gebe mêŋsêkêŋ da sêwiŋ. ");
INSERT INTO jae_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Êsêac sêô lasê ma Samuel gêlic Eliab, tec geboc Apômtaunê ŋac êniŋ oso eŋŋa tau. ");
INSERT INTO jae_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Mago Apômtau kêsôm gêdêŋ Samuel gebe “Ôê taêm eŋ ôliŋ ŋawasi to waso-waso atom. Aê katiŋ eŋ su, gebe aê galic gêŋ kêtôm ŋamalac sêlic naŋ atom. Ŋamalac sêlic gêŋ, taŋ gêc dêmôêŋa naŋ ma Apômtau gêbi ŋalêlôm lêtêŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Isai gêmôêc Abinadab ma kêkôc eŋ gêdêŋ Samuel gêja. Mago eŋ kêsôm gebe “Apômtau kêjaliŋ eŋ sa atom amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Go Isai kêkêŋ Sama gêja, mago Samuel kêsôm gebe “Apômtau kêjaliŋ eŋ sa atom amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Isai kêkêŋ latui 7 dêdêŋ Samuel sêja. Ma Samuel kêsôm gêdêŋ Isai gebe “Apômtau kêjaliŋ êsêac tonec ŋai nêŋ teŋ sa atom.” ");
INSERT INTO jae_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Go Samuel kêtu kênac Isai gebe” Latômi tecenaŋgeŋ me.” Ma Isai gêjô eŋ awa gebe “Ŋac sauŋ gacgeŋ gêmoa, eŋ gejob domba gêmoa.” Samuel kêsôm gêdêŋ Isai gebe “Ôkêŋ lau nasêkôc eŋ sêmêŋ. Aêac oc daŋgôŋ sic atom e eŋ êmêŋ acgom.” ");
INSERT INTO jae_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Amboac tonaŋ kêkêŋ lau jasêkôc eŋ sêmêŋ. Eŋ laŋôanô ŋajamanô to mataanô ŋakêŋkêŋ ma ôli e ŋawasi laŋgwageŋ. Ma Apômtau kêsôm gêdêŋ Samuel gebe “Ajôc, ôniŋ oso eŋ, ŋac tau tonec.” ");
INSERT INTO jae_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Samuel kêkôc niptêkwi ŋaŋoplakôp ma geŋ oso Dawid aŋga têwai ŋalêlôm. Go Apômtaunê Ŋalau kêsêp Dawid ŋalêlôm jagêjam eŋ auc gêdêŋ bêc tonaŋ ma gê tôŋgeŋ gêja. Samuel gêdi ma gêc gêja Rama. ");
INSERT INTO jae_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Apômtaunê Ŋalau gêwi Saul siŋ ma ŋalau sec teŋ aŋga Apômtaunê kêlêsu eŋ. ");
INSERT INTO jae_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Go Saulnê sakiŋwaga sêsôm gêdêŋ eŋ gebe “Aôm kôjala gebe ŋalau sec aŋga Anôtônê kêlêsu aôm gêmoa. ");
INSERT INTO jae_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Amboac tonaŋ ma ŋatau, ôjatu nêm sakiŋwaga aêac gebe ansom ŋac gêjac gêŋ wêŋawaga teŋ. Ma embe ŋalau sec aŋga Anôtônê mêŋêlêsu aôm eŋ oc ênac gêŋ wêŋa ma nêm ŋalêlôm êtu malô êtiam.” ");
INSERT INTO jae_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Saul kêsôm gêdêŋ nê sakiŋwaga gebe “Ŋajam, ansom ŋac-gêjac-gêŋ-wêŋawaga teŋ ma akôc eŋ andêŋ aê amêŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Sakiŋwaganêŋ teŋ kêsôm gebe “Aê galic Isai aŋga Betlehem nê latu teŋ gêjac gêŋ wêŋa ŋajamanô. Eŋ ŋactêkwa to ŋaclai ma kêsôm biŋ tokauc to laŋôanô ŋajam ma Apômtau gêmoa gêwiŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Amboac tonaŋ Saul kêsakiŋ lau dêdêŋ Isai sêja ma kêsôm gebe “Ôsakiŋ latôm Dawid, taŋ gejob domba gêmoa naŋ, êndêŋ aê êmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Tec Isai kêkôc doŋki teŋ jakêkêŋ polom gêsac ŋaô to wain kêsêp ŋaôlic teŋ ma noniŋ ŋalatu kapoac teŋ ma kêsakiŋ latu Dawid gebe êkêŋ gêŋ tau êndêŋ Saul. ");
INSERT INTO jae_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Amboac tonaŋ Dawid gêdêŋ Saul gêja ma gêjam sakiŋ eŋ. Ma Saul têtac gêwiŋ Dawid ŋanôgeŋ ma kêkêŋ eŋ kêtu ŋac, taŋ gêôc ênê laukasap naŋ. ");
INSERT INTO jae_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Ma Saul kêsakiŋ biŋ gêdêŋ Isai ma kêsôm gebe “Ôkêŋ latôm Dawid ênam sakiŋ aê êmoa gebe aê galic eŋ ŋajam.” ");
INSERT INTO jae_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ma kêtôm têm samob, taŋ Anôtônê ŋalau sec kêlêsu Saul naŋ, Dawid kêkôc nê geŋ wêŋa ma gêjac e kêmoasiŋ Saul ma ôli ŋajam kêsa ma ŋalau sec gêwi eŋ siŋ. ");
INSERT INTO jae_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Lau Pilisti sêkac nêŋ lau siŋŋa sa sêpi tageŋ aŋga malac Judaŋa teŋ ŋaê Soho. Êsêac sê becobo kêsêp Soho ma Aseka ŋasawa aŋga Epes-Damim. ");
INSERT INTO jae_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Saul to lau Israel sêkac sa sêpi tageŋ amboac tonaŋgeŋ ma sê becobo aŋga gamêŋ Ela. Go êsêac têdênaŋ tauŋ sebe sênac siŋ endeŋ lau Pilisti. ");
INSERT INTO jae_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Lau Pilisti sêkô lôc ŋamakeŋ ma Israel sêkô lôc ŋamakeŋ ma gaboaŋ gêc ŋaluŋ. ");
INSERT INTO jae_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Go lau Pilistinêŋ ŋac siŋsêlêc kêsa aŋga êsêacnêŋ toŋ gêmêŋ, ênê ŋaê Goliat aŋga malac Gat. Eŋ ŋac waso-waso baliŋ sec kêtôm saka samuc teŋ ma ŋasêku. ");
INSERT INTO jae_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Eŋ kêkuc kululuŋ ki ma kêsô ŋakwê ki. Ŋakwê ki tau ŋawapac kêtôm 75 kilo. ");
INSERT INTO jae_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Eŋ kêkwa atêkwa auc ŋa ki ma gêôc kêm ki. ");
INSERT INTO jae_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Kêm ŋadambê kêtôm sap ma kêm ŋamata ki ŋawapac kêtôm 10 kilo. Ma ênê ŋac teŋ gêja ênê lautuc kêsêlêŋ gêmuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Eŋ kêsa mêŋkêkô ma gêmôêc gêdêŋ lau Israel gebe “Kêtu asageŋŋa amac amêŋ abe anac siŋ. Aê Pilisti teŋ ma Saulnê sakiŋwaga amac atom me. Ajaliŋ nêm ŋac teŋ sa êsêp êndêŋ aê êmêŋ. ");
INSERT INTO jae_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Eŋ embe êtôm gebe ênac aê êndu, naŋgo atu amacnêm sakiŋwaga. Mago aê embe jaku eŋ tulu ma janac eŋ êndu, naŋgo amac atu aêacma sakiŋwaga ma anam sakiŋ aêac.” ");
INSERT INTO jae_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Ma Pilisti tau kêsôm gebe “Ocsalô tonec aê kasu lau Israel susu gebe akêŋ ŋac teŋ mêŋaêagêc anac tauŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Saul to Israel samob sêŋô Pilisti nê biŋ tonaŋ e nêŋ ŋalêlôm ŋagogo ma têtêc tauŋ ŋanô. ");
INSERT INTO jae_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Dawid eŋ ŋac Epra aŋga Betlehem Judaŋa latu. Ŋac tau nê ŋaê Isai. Isai latui 8. Ma gêdêŋ Saulnê têm ŋac tau kêtu ŋamalacanô su. ");
INSERT INTO jae_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Nê latui ŋamataŋa têlêac têdaguc Saul kêtu siŋŋa. Lau têlêac tau nêŋ ŋaê tonec ŋacsêga Eliab ma ŋac kêtu luagêcŋa nê ŋaê Abinadab ma ŋac kêtu têlêacŋa Sama. ");
INSERT INTO jae_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Dawid eŋ ŋac ŋamuŋa. Tageŋ lau ŋamataŋa têlêac tonaŋ têdaguc Saul sêja. ");
INSERT INTO jae_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Ma Dawid gêwi Saul siŋ kêsêp ŋasawa ŋagêdô ma gêmu gêja Betlehem gebe ejop tamanê domba. ");
INSERT INTO jae_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Kêtôm bêc 40 ŋabêbêc to ŋakêtula samob Pilisti Goliat tonaŋ kêsa jakêkô nê mala. ");
INSERT INTO jae_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Gêdêŋ bêc teŋ Isai kêsôm gêdêŋ latu Dawid gebe “Ôkôc gadob topolom sigob ma polom 10 tonec ôndêŋ têwami ôna gamêŋ becoboŋa, ");
INSERT INTO jae_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","ma ôkêŋ su-gêjac-anô 10 tonec êndêŋ êsêacnêŋ gôliŋwaga. Ma ôlic têwami oc sêmoa amboac ondoc, go ôkôc gêŋ teŋ, taŋ êwa sa gebe sêmoa ŋajam naŋ, ômu ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Saul to êsêac ma lau Israel samob sêjac siŋ gêdêŋ lau Pilisti sêmoa gaboaŋ Ela. ");
INSERT INTO jae_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Dawid gêdi gêdêŋ bêbêc kanucgeŋ ma gêwi domba siŋ gêdêŋ ŋac teŋ gejob ma kejoŋ gêŋ gêja kêtôm tama Isai kêjatu eŋ. Eŋ jagêô lasê siŋ ŋamala tau ma lau siŋ têdênaŋ tauŋ gebe sêsa êtu siŋŋa ma sêjam lasê. ");
INSERT INTO jae_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Israel to Pilisti têdênaŋ tauŋ towalaŋ-towalaŋ. ");
INSERT INTO jae_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Dawid kêlêwaŋ nê waba su kêsêp ŋac gejob wabaŋa lêma ma kêlêti gêdêŋ lau towalaŋ ma kêtu kênac têwai gebe sêmoa amboac ondoc. ");
INSERT INTO jae_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Êsêac sêjam biŋgalôm gêdêŋ tauŋ sêmoa ma ŋac waso-waso Goliat tau kêsa jagêmôêc biŋ, taŋ gêmuŋŋa gêmôêc gêdêŋ êsêac naŋ, kêtiam ma Dawid gêŋô biŋ tau. ");
INSERT INTO jae_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Gêdêŋ taŋ lau Israel sêlic ŋac tau naŋ, êsêac têtêc tauŋ ma sêc. ");
INSERT INTO jae_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Êsêac sêsôm gebe “Amac alic ŋac, taŋ kêsa gêmêŋ naŋ, me masi. Eŋ kêsa gêmêŋ kêtu êsu Israel susuŋa. Ŋac taŋ ênac eŋ êndu naŋ, kiŋ oc êkêŋ waba taêsam êndêŋ eŋ êtu ŋac tolêlôm to êkêŋ latuo êndêŋ eŋ ênam ma ênac tamanê gôlôac êŋgic gebe sêkêŋ takis êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Go Dawid kêtu kênac lau, taŋ sêkô têdabiŋ eŋ naŋ, gebe “ŋac samuc Pilisti tê mêŋkêsu Anôtô mata jali nê siŋwaga susu nê asa. Teŋ embe ênac eŋ êndu ma enseŋ biŋ susuŋa su aŋga Israel oc sêmoasiŋ eŋ ŋa asageŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Tec lau tau sêjô eŋ awa ma sêsôm biŋ ŋakôniŋŋa gebe ŋac, taŋ ênac eŋ êndu naŋ, oc sêmoasiŋ eŋ ŋa gêŋ amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Têwa ŋacsêga Eliab gêŋô Dawid gêjam biŋgalôm gêwiŋ lau ma têtac ŋandaŋ kêsa ma kêsôm eŋ gebe “Aôm kôsêp gômôêŋ tonec kêtu ageŋŋa. Ma gôwi domba ŋapopoc aŋga oba ônê siŋ gêdêŋ asa gebe ejop. Aê kajala gebe aôm kotoc taôm sa ma nêm ŋalêlôm sec tau tonec gebe gômôêŋ gobe ôlic siŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Dawid gêjô biŋ tonaŋ gebe “Aê gagôm asageŋ keso. Aê gajam kênac ŋaômageŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Go eŋ kêkac tau ôkwi aŋga ênê gêdêŋ ŋac teŋ ma kêtu kênac biŋ tageŋ tonaŋ kêtiam. Ma lau sêjô awa kêtôm ŋamataŋa. ");
INSERT INTO jae_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Biŋ taŋ Dawid kêsôm naŋ, lau sêŋô ma têdôŋ gêdêŋ Saul. Ma eŋ kêsakiŋ biŋ gêdêŋ Dawid gebe “Ôndêŋ aê ômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Ma Dawid kêsôm gêdêŋ Saul gebe “Ŋoc ŋatau, lau sênam golec sa êtu ŋac ônêŋa amboac secgeŋmaŋ. Nêm sakiŋwaga aê gabe naaêagêc Pilisti tônê anac tauŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Tageŋ Saul kêsôm gêdêŋ Dawid gebe “Masi, aôm naônac siŋ êndêŋ Pilisti tonaŋ atom. Aôm kôtôm Pilisti tau atom, gebe aôm ŋac wakuc ma eŋ ŋac siŋsêlêc laŋgwa.” ");
INSERT INTO jae_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Mago Dawid kêsôm gêdêŋ Saul gebe “Nêm sakiŋwaga aê gajob tamocnê domba. Gêdêŋ taŋ lewe me bôclai ber gêmêŋ ma gêjam geŋgeŋ domba teŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","aê kajanda kadaguc eŋ e kajaŋgo domba su aŋga eŋ awasuŋ. Ma embe êsa tau sa êndêŋ aê, go aê jakôc ênê êm tôŋ ma jamakiŋ eŋ êndu. ");
INSERT INTO jae_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Nêm sakiŋwaga aê gajac lewe to ber ŋagêdô êndu su ma ŋacsamuc Pilisti tônê oc êtap gêŋ tageŋ tônê sa amboac tonaŋ gebe kêsu Anôtônê lau siŋ susu.” ");
INSERT INTO jae_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ma Dawid kêsôm biŋ teŋ gêwiŋ gebe “Apômtau taŋ gêjam aê kêsi aŋga lewe to bôclai ber nêŋ ŋaclai naŋ, oc ênam aê kêsi aŋga Pilisti tau nê ŋaclai êwiŋ.” Go Saul kêsôm gêdêŋ Dawid gebe “Amboac tonaŋ ôna, ma Apômtau êmoa êwiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Go Saul kêkêŋ tau nê ŋakwê siŋŋa gêdêŋ Dawid. Kêkêŋ kululuŋ ki Dawid kêkuc ma kêkêŋ eŋ kêsô ŋakwê ki ŋagala. ");
INSERT INTO jae_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Ma Dawid kêjandiŋ Saulnê siŋ gêsac ŋakwê ŋaô ma kêsêlêŋ gebe ênsaê e gêgôm elêmê, gebe eŋ kêtôm gêŋ tau atom. Tec Dawid kêsôm gêdêŋ Saul gebe “Aê katôm gebe jasêlêŋ tolaukasap samucgeŋ tonec atom, gebe katôm gêŋ tau atom.” Amboac tonaŋ Dawid kêsêlô gêŋ samob tonaŋ su kêtiam. ");
INSERT INTO jae_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Go kêmêgôm nê tôc kêsêp lêma ma kêjaliŋ dabaŋ matu ŋawasi lemeŋteŋ aŋga bumaŋ sa ma kêkêŋ kêsêp atali. Lêma kêmêgôm nê dabaŋ tôŋ ma gêdêŋ Pilisti tau gêja. ");
INSERT INTO jae_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Ŋac Pilisti kêtu oloŋ-oloŋ gêdêŋ Dawid gêmêŋ ma ênê ŋac gêja lautuc gêmuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Ŋac tau gêlic Dawid ma kêpuc mata tôŋ eŋ e kêsu eŋ susu gebe eŋ ŋac matac tolaŋôanô ŋajamanô. ");
INSERT INTO jae_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Ma Pilisti tau kêsôm gêdêŋ Dawid gebe “Aê kêam me, tec kôkôc tôcgeŋ gôdêŋ aê gômôêŋ.” Ma kêpuc boa Dawid kêsam nê anôtôinêŋ ŋaê. ");
INSERT INTO jae_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Ma Pilisti tau kêsôm gêdêŋ Dawid gebe “Ômôêŋmaŋ, aê, oc jakêŋ aôm ôtu moc to bôclai nêŋ gwada.” ");
INSERT INTO jae_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Dawid gêjô eŋ awa gebe “Aôm gôc siŋ to kêm ma gôja lautuc gôdêŋ aê gômôêŋ ma aê nec gadêŋ aôm gajam lausiŋ undambêŋa nêŋ Apômtau to lau Israel nêŋ siŋwaga nêŋ Anôtô, taŋ kôsu eŋ susu naŋ laŋô. ");
INSERT INTO jae_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ocsalô tonec Apômtau oc êkêŋ aôm ôsêp aê lemoc ma aê oc janac aôm êndu ma jandim aôm gêsômtêkwa êŋgic. Ma jakêŋ lau Pilisti nêŋ ŋawêlêlaŋ êtu moc umboŋ ŋalabuŋa to bôclai nomŋa nêŋ gwada. Go lau nomŋa samob sêjala gebe Israelnêŋ Anôtô gêmoa. ");
INSERT INTO jae_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Ma lau samob, tec sêkac sa aŋga tonec nec sêlic gebe Apômtau kêpô lêna tubac to kêm ênam lau saŋa atom, gebe siŋ tonec kêtu Apômtaunê siŋ ma eŋ oc êkêŋ amac asêp aêac lemeŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Gêdêŋ taŋ Pilisti tau kêtu gasuc Dawid naŋ, Dawid kêlêti ŋagaôgeŋ gêdêŋ eŋ gêja. ");
INSERT INTO jae_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Eŋ kêkêŋ lêma kêsêp nê atali ma gic dabaŋmatu teŋ sa ma kêdaiŋ e jagêjac Pilisti têbêla palap tageŋ. Poc tau kêtuc eŋ môkêapac popoc ma gêu tau laŋôanô jagêdêŋ nom. ");
INSERT INTO jae_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Amboac tonaŋ Dawid kêku Pilisti tulu ŋa dabaŋ topoc. Eŋ gêjac Goliat e gêu tau ma gêmac êndu ma siŋ teŋ kêsêp Dawid lêma atom. ");
INSERT INTO jae_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Go Dawid kêlêti gêdêŋ eŋ jakêsô palap eŋ ma gêbuc ênê siŋ sa gêjac eŋ êndu go gêdim eŋ gêsutêkwa gêŋgic. Lau Pilisti sêlic gebe nêŋ siŋsêlêc gêmac êndu su, tec sêc. ");
INSERT INTO jae_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Ma lau Israel to Juda dêdi sêjam lasê ma sêjanda lau Pilisti e gêdêŋ Gat to Ekron nêŋ tuŋbôm ŋakatam. Ma lau Pilisti, taŋ siŋ gêjac êsêac ôliŋ lasê naŋ, sêc intêna-intêna aŋga Saraim e gêdêŋ Gat to Ekron. ");
INSERT INTO jae_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Go lau Israel sêkac tauŋ ôkwi sêmu sêmêŋ ma sêjaŋgo lau Pilisti nêŋ waba, taŋ gêc nêŋ gamêŋ becoboŋa naŋ, samob su. ");
INSERT INTO jae_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Ma Dawid kêkôc Goliat nê môkêapac ma kêkôc gêja Jerusalem ma kêkêŋ ênê laukasap gêc taunê becobo. ");
INSERT INTO jae_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Gêdêŋ taŋ Saul gêlic Dawid kêsa gêja gebe ênac Pilisti tau naŋ, eŋ kêtu kênac nê ŋac siŋsêlêc Abner gebe “Abner, ŋac matac tônê asanê latu eŋ.” Ma Abner gêjô eŋ awa gebe “O kiŋ, aê gajam kauc eŋ biŋŋanôgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Ma kiŋ kêsôm gebe “Ôkip ŋac matac tau nê ŋam sa. Asanê latu eŋ.” ");
INSERT INTO jae_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Amboac tonaŋ gêdêŋ taŋ Dawid gêjac Pilisti êndu ma gêmu gêmêŋ naŋ, Abner kêkôc eŋ gêdêŋ Saul gêja. Dawid gegeŋ Pilisti nê môkêapac tôôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Ma Saul kêtu kênac eŋ gebe “Ŋacnec, asa latu aôm.” Ma Dawid gêjô eŋ awa gebe “Nêm sakiŋwaga Isai aŋga Betlehem nê latu aê.” ");
INSERT INTO jae_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Dawid gêjam biŋgalôm gêdêŋ Saul su acgom, go Jonatan agêc Dawid sê sêlêb gêdêŋ tauŋ ma Jonatan têtac gêwiŋ eŋ kêtôm têtac gêwiŋ tau. ");
INSERT INTO jae_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Ma Saul kêkôc Dawid tôŋ gêmoa gêwiŋ eŋ gedeŋ tôŋgeŋ ma gêwi eŋ siŋ gêmu gêja tamanê andu kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Go Jonatan kêmoatiŋ poac gêdêŋ Dawid gebe eŋ têtac gêwiŋ Dawid amboac têtac gêwiŋ tau. ");
INSERT INTO jae_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Jonatan kêkwalec ŋakwê, taŋ eŋ tau kêsô naŋ, su kêkêŋ gêdêŋ Dawid ma kêkêŋ nê laukasap to nê siŋ ma talam to ômbiŋkap gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Kêtôm têm samob, taŋ Saul kêsakiŋ kêtu kôm tokaiŋ-tokaiŋŋa naŋ, Dawid gêjam kôm tau toŋanôgeŋ. Kêtu tonaŋŋa Saul kêkêŋ eŋ kêtu nê lau siŋŋa nêŋ siŋsêlêc. Biŋ tonaŋ gêjac lau samob mateŋanô ŋajam ma Saulnê sakiŋwaga sêlic ŋajam amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Gêdêŋ taŋ Dawid gêjac Pilisti tau êndu ma lau siŋ sêmu sêja nêŋ gamêŋ naŋ, lauo aŋga malac Israel ŋa samob sêsa sêja sebe sêpuc Saul tôŋ-tôŋ. Êsêac sêjam wê têntac ŋajam ŋa tooŋ ma gegob ma têtê wê. ");
INSERT INTO jae_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Lauo têtu samuc ma sêjam wê sêjô-sêjô tauŋ gebe “Saul gêjac nê ŋacjo 1,000 ma Dawid gêjac nê 10,000.” ");
INSERT INTO jae_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Saul gêŋô biŋ tonaŋ ŋajam atom ma têtac ŋandaŋ secanô. Eŋ kêsôm gebe “Êsêac sêkêŋ 10,000 gêdêŋ Dawid ma 1,000 geŋ gêdêŋ aê. Tec galoc kêtap gêŋ samob sa su, gêŋ tageŋ naŋ masi eŋ naŋ, tonec gebe êtu kiŋ.” ");
INSERT INTO jae_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Gêdêŋ bêc tonaŋ Saul gêlic Dawid sec ma gê tôŋgeŋ gêja. ");
INSERT INTO jae_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Ŋageleŋ Anôtônê ŋalau sec teŋ kêlêsu Saul ma kêlêti gêmoa nê andu ŋalêlôm amboac meloc kêtê eŋ. Dawid gêjac gêŋ wêŋa gêmoa kêtôm eŋ gêgôm-gêgôm ma Saul kêmêgôm nê kêm. ");
INSERT INTO jae_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Saul kêkôtêŋ nê kêm ma kêsôm gebe “Aê jandiŋ Dawid tôŋ tamiŋ sagiŋ.” Mago Dawid kêtêc kêm su kêtu dim luagêc. ");
INSERT INTO jae_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Ma Saul kêtêc Dawid gebe Apômtau gêwiŋ eŋ ma gêwi Saul siŋ su. ");
INSERT INTO jae_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Saul gêwi Dawid siŋ gebe êmoa laŋônêmŋa êtiam atom ma kêkêŋ eŋ kêtu toŋ lausiŋ 1,000ŋa nêŋ kasêga. Amboac tonaŋ eŋ gêwê nê lau kêsô kêsa. ");
INSERT INTO jae_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Gêŋ samob, taŋ Dawid gêgôm naŋ, ŋanô kêsa gebe Apômtau gêmoa gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Saul gêlic Dawidnê kôm samob ŋanô kêsa, tec kêtêc eŋ kêlêlêc. ");
INSERT INTO jae_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Mago Israel to Juda samucgeŋ têntac gêwiŋ Dawid gebe eŋ gêwê êsêac kêsô kêsa. ");
INSERT INTO jae_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Go Saul kêsôm gêdêŋ Dawid gebe “Aê latuco awêsêga Merab tec gêmoa. Aê oc jakêŋ eŋ êndêŋ aôm ônam êtu nêm awê. Ma aôm ônam sakiŋ aê totêmtac êpa sugeŋ to ônac Apômtaunê siŋ.” Gebe Saul taê gêjam gêc taugeŋ gebe “Aê lemoc êpi eŋ atom. Lau Pilisti lemeŋ êpi eŋmaŋ.” ");
INSERT INTO jae_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Dawid kêsôm gêdêŋ Saul gebe “Aê asa, ma aêŋoc lasitêwai to tamocnê gôlôac lau towae amboac ondoc aŋga Israel, tec aê jatu kiŋ lawa nec.” ");
INSERT INTO jae_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Mago gêdêŋ têm, taŋ sebe sêkêŋ Saul latuo Merab êndêŋ Dawid naŋ, Saul kêkêŋ eŋ gêdêŋ Adriel aŋga Meholaŋa gêjam eŋ kêtu nê awê. ");
INSERT INTO jae_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Mago Saul latuo Mikal têtac gêwiŋ Dawid. Êsêac têdôŋ biŋ tonaŋ gêdêŋ Saul ma eŋ gêlic ŋajam. ");
INSERT INTO jae_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Saul taê gêjam gêc tauŋa gebe “Aê jakêŋ latuco êndêŋ Dawid gebe êtu ênê lakô teŋ ma lau Pilisti senseŋ eŋ su.” Ma Saul kêsôm gêdêŋ Dawid kêtu dim luagêcŋa gebe “Aôm oc ôtu aê laoc.” ");
INSERT INTO jae_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Ma Saul kêjatu nê sakiŋwaga gebe.” Anam biŋgalôm awiŋ Dawid kelecgeŋ ma asôm gebe ‘Gôlicgac me, kiŋ gêlic aôm ŋajam ma ênê sakiŋwaga samob têntac gêwiŋ aôm amboac tonaŋ galoc ôtu kiŋ lawa.’” ");
INSERT INTO jae_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Ma Saulnê sakiŋwaga têdôŋ biŋ tau gêdêŋ Dawid. Mago Dawid kêsôm gebe “Amac alic amboac ondoc, jatu kiŋ lawa nec gêŋ sauŋ teŋ me. Aê ŋac ŋalêlôm sawa to ŋac ŋaôma.” ");
INSERT INTO jae_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Saulnê sakiŋwaga jasêjac miŋ biŋ, taŋ Dawid kêsôm naŋ, gêdêŋ Saul. ");
INSERT INTO jae_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Tec Saul kêsôm gebe “Asôm biŋ tonec êndêŋ Dawid gebe ‘Kiŋ taê kêka awê ŋaôli atom. Eŋ keteŋ lau Pilisti 100 nêŋ utiŋôlic gebe aôm ôkac kiŋnê kamocgôc êndêŋ ênê ŋacjonêŋ.’” Gebe Saul taê gêjam gêc tauŋa gebe lau Pilisti senseŋ Dawid su. ");
INSERT INTO jae_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Saulnê sakiŋwaga têdôŋ biŋ tonaŋ gêdêŋ Dawid ma Dawid gêlic ŋajam gebe êtu kiŋ lawa. Noc ênam awêŋa gêcgeŋ ");
INSERT INTO jae_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","ma Dawid gêdi gêwiŋ nê lau gêja ma gêjac lau Pilisti 200 êndu. Go Dawid kêkôc utiŋôlic mêŋketoc tomalageŋ gêc kiŋ laŋônêmŋa. Amboac tonaŋ eŋ kêtu kiŋ lawa ma Saul kêkêŋ latuo Mikal gêdêŋ eŋ gêjam kêtu nê awê. ");
INSERT INTO jae_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Saul gêlic ma kêjala gebe Apômtau gêmoa gêwiŋ Dawid ma lau Israel samob têntac gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Tec kêtêc Dawid kêlêlêc ma kêtu ênê soŋo-soŋo gedeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Kêtôm têm samob naŋ lau Pilisti nêŋ gôliŋwaga sêsa sêmêŋ kêtu sênac siŋŋa naŋ, Dawid gêjac siŋ toŋanô kêlêlêc Saulnê sakiŋwaga samob su. Amboac tonaŋ Dawidnê wae kêsa e gêjam sêga. ");
INSERT INTO jae_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Saul gêjam biŋgalôm gêwiŋ latu Jonatan to nê sakiŋwaga samob gebe senseŋ Dawid su. Mago Saul latu Jonatan têtac gêwiŋ Dawid kêlêlêc. ");
INSERT INTO jae_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Tec gêjac miŋ biŋ tau gêdêŋ Dawid ma kêsôm gebe “Tamoc Saul gêgôm gêŋlêlôm gebe enseŋ aôm su. Ojop taôm êndêŋ eleŋ bêbêcgeŋ ma ôsiŋ taôm ôkwi ŋapep aŋga gamêŋ ŋakêsiŋ teŋ ma ômoa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Aê oc jasa jawiŋ tamoc jawac gamêŋ, taŋ aôm ômoa naŋ, ŋagala ma janam biŋgalôm êndêŋ tamoc êtu aômŋa. Ma embe jaŋô biŋ teŋ oc jakêŋ ŋawae êndêŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ma Jonatan kêlanem Dawid gêdêŋ tama Saul ma kêsôm gêdêŋ eŋ gebe “O kiŋ, ôŋgôm sec êndêŋ nêm sakiŋwaga Dawid atom gebe eŋ gêgôm sec teŋ gêdêŋ aôm atom ma gêjam sakiŋ aôm ŋajamanô. ");
INSERT INTO jae_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Eŋ gêjac môkê tau ma gêjac Pilisti Goliat êndu ma Apômtau kêku Israelnêŋ ŋacjo tulu. Aôm gôlic ma kôtu samuc ma amboac ondoc gobe ôŋgôm sec êndêŋ ŋac laŋônêm sawa ma ônac Dawid êndu ŋaômageŋ.” ");
INSERT INTO jae_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Saul kêkêŋ taŋa Jonatan awa ma kêtôc lêma ma kêsôm gebe “Apômtau gêmoa mata jali biŋŋanôgeŋ, tec Dawid êmac êndu atom.” ");
INSERT INTO jae_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Amboac tonaŋ Jonatan gêmôêc Dawid ma gêjac miŋ biŋ samob tonaŋ gêdêŋ eŋ. Go gêwê Dawid gêdêŋ Saul ma Dawid gêjam nê sakiŋ kiŋ kêtôm gêmuŋŋa kêtiam. ");
INSERT INTO jae_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Siŋ teŋ kêsa kêtiam ma Dawid gêdi gêwiŋ jagêjac siŋ gêdêŋ lau Pilisti. Ma eŋ gêjac êsêac ŋanôgeŋ, tec sêwi siŋ siŋ ma sêc eŋ su sêja. ");
INSERT INTO jae_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Go Apômtaunê ŋalau sec teŋ gêjam Saul auc gêdêŋ taŋ eŋ gêŋgôŋ nê andu ma kêmêgôm kêm teŋ. Dawid gêjac gêŋ wêŋa gêmoa. ");
INSERT INTO jae_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Ma Saul kêsaê gebe êndiŋ Dawid tamiŋ sagiŋ ŋa kêm, mago Dawid kêtêc su e kêm jakêpi sagiŋ. Dawid gêc gêja ma gêjam samuc. ");
INSERT INTO jae_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Gêdêŋ gêbêc tonaŋgeŋ Saul kêsakiŋ lau sêja Dawidnê andu gebe dêndib eŋ ma taê gêjam gebe ênac eŋ êndu êndêŋ bêbêcgeŋ. Mago Dawidnê awê Mikal kêkêŋ puc eŋ gebe “Embe ôêc êndêŋ êmbêc tonec atom oc sênac aôm êndu êndêŋ bêbêc.” ");
INSERT INTO jae_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Ma Mikal kêlêwaŋ Dawid kêsêp katam sauŋ ma eŋ gêc gêja, tec gêjam samuc. ");
INSERT INTO jae_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Go Mikal kêkôc gwam teŋ ma ketoc gêc mê go kêkêŋ noniŋ ŋaôlilu gêsac gwam môkêapac ŋaô ma kêgadê auc ŋa obo. ");
INSERT INTO jae_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Ma gêdêŋ taŋ Saul kêsakiŋ lau gebe nasêkôc Dawid naŋ, Mikal kêsôm gebe “Gêmac gêgôm eŋ.” ");
INSERT INTO jae_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Go Saul kêsakiŋ lau gebe sêlic Dawid ma kêjatu êsêac gebe” Ambalaŋ eŋ to mêgeŋ andêŋ aê amêŋ gebe janac eŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Lau tonaŋ sêsô andu sêja e sêlic gwam tau gêc mê ma noniŋ ŋaôlilu gêsac môkêapac ŋaô. ");
INSERT INTO jae_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Saul kêsôm gêdêŋ Mikal gebe “Kêtu asageŋŋa kôsau aê ma gôwi ŋoc soŋo-soŋo siŋ jagêmoa toôli samuc.” Mago Mikal kêsôm gêdêŋ Saul gebe” Eŋ kêsôm gêdêŋ aê gebe ‘Ôkêŋ aê jaêc jana. Embe masi, oc janac aôm êndu.’” ");
INSERT INTO jae_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Dawid gêc gêmoa toôli samuc jagêô lasê gêdêŋ Samuel aŋga Rama, go gêjac miŋ biŋ samob, taŋ Saul gêgôm gêdêŋ eŋ naŋ. Go êsêagêc Samuel sêja Naiot ma sêmoa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Ŋawae kêtap Saul sa gebe “Dawid gêmoa Naiot Ramaŋa.” ");
INSERT INTO jae_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Tec eŋ kêsakiŋ lau gebe nasêkôc Dawid sêmêŋ. Ma gêdêŋ taŋ êsêac sêlic toŋ propeteŋa, taŋ katuŋ kaiŋ teŋ kêsa ma Samuel jagêjam gôliŋ êsêac naŋ, Anôtônê Ŋalau gêjam Saulnê lau auc ma katuŋ kaiŋ teŋ kêsa gêwiŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Biŋ tonaŋ ŋawae gêdêŋ Saul gêja, tec kêsakiŋ lau toŋ teŋ, mago êsêac katuŋ kaiŋ teŋ kêsa amboac tonaŋgeŋ. Ma Saul kêsakiŋ lau kêtiam kêtu dim têlêac ma êsêac katuŋ kaiŋ teŋ kêsa gêwiŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Go eŋ tau gêja Rama jagêô lasê bumata kapôêŋ, taŋ gêc Seku naŋ, ma kêtu kênac gebe “Samuel agêc Dawid sêmoa ondoc.” Ŋac teŋ kêsôm gêdêŋ eŋ gebe “Êsêagêc sêmoa Naiot Ramaŋa.” ");
INSERT INTO jae_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Gêdêŋ taŋ Saul kêsêlêŋ gebe êna Naiot Ramaŋa naŋ, Anôtônê Ŋalau gêjam eŋ auc amboac tonaŋgeŋ ma eŋ kêsêlêŋ ma geoc biŋ lasê e jagêô lasê Naiot Ramaŋa. ");
INSERT INTO jae_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Go eŋ kêkwalec nê ŋakwê su ma gêmoa Samuel laŋônêmŋa ma geoc biŋ lasê amboac tonaŋ ma gêc ôli ŋaôma oc samuc ma gêbêc samuc tonaŋ. Tec biŋ tonec kêtu biŋgalôm gebe “Saul gêmoa gêwiŋ propete amboac tonaŋ me.” ");
INSERT INTO jae_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Dawid gêc aŋga Naiot Ramaŋa gêmu gêmêŋ ma kêsôm gêdêŋ Jonatan gebe “Aê gagôm asageŋ. Aêŋoc keso ondoc. Aê gagôm sec ondoc gêdêŋ tamam, tec gebe enseŋ aê su nec.” ");
INSERT INTO jae_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Jonatan gêjô eŋ awa gebe “Masianô. Aôm oc ômac êndu atom. Ôlic acgom, tamoc kêsiŋ gêŋ kapôêŋ me sauŋ, taŋ gebe êŋgôm ŋa naŋ, ŋateŋ ôkwi gêdêŋ aê atom. Tamoc ênam biŋ amboac tonaŋ auc êndêŋ aê êtu asageŋŋa. Biŋ amboac tonaŋ teŋ gêc atom.” ");
INSERT INTO jae_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Mago Dawid gêjô eŋ awa gebe “Aôm tamam kêjala kêtu tôŋ su gebe aôm gôlic aê ŋajam, tec taê gêjam gêc tauŋageŋ gebe ‘Jonatan êŋô biŋ tonaŋ atom, oc êŋgôm ênê ŋalêlôm ŋawapac êsa.’ Aê jasôm biŋŋanô êtu Apômtau gêmoa mata jali to aôm gômoa matam jaliŋa gebe aê kasa paŋ sêawa.” ");
INSERT INTO jae_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Go Jonatan kêsôm gêdêŋ Dawid gebe “Biŋ samob, taŋ ôsôm naŋ, aê jaŋgôm ŋanô êsa êtu aômŋa.” ");
INSERT INTO jae_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Dawid gêjô eŋ awa gebe “Eleŋŋa ajôŋ mêŋgêô lasê ma aêŋoc noc janiŋ gêŋ jawiŋ kiŋ tauŋa. Mago jateŋ aôm gebe ôwi aê siŋ najasiŋ jamoa kôm e bêc êtu têlêac ŋaêtula. ");
INSERT INTO jae_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Tamam embe êlic aê malocmê go ôsôm gebe ‘Dawid keteŋ aê ŋanôgeŋ gebe êlîc nê malacmôkê Betlehem gebe nê lau sêkêŋ da jalaŋa êtu nêŋ gôlôacŋa.’ ");
INSERT INTO jae_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Ma tamam embe êsôm gebe ‘Ŋajam’, go nêm sakiŋwaga aê jamoa ŋajam. Mago embe eŋ têtac ŋandaŋ, go ôjala gebe ênê biŋ sec tônê oc êtu tôŋ. ");
INSERT INTO jae_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Ômoasiŋ nêm sakiŋwaga aê amboac tonaŋ gebe aôm kômoatiŋ poac gêdêŋ nêm sakiŋwaga kôkô Apômtau laŋônêmŋa. Mago keso teŋ embe ênêc aêŋa, go aôm taôm ônac aê êndu. Gobe ôkêŋ aê jandêŋ tamam êtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Jonatan kêsôm gebe “Biŋ amboac tonaŋ êtap aôm sa atom. Aê embe jajala gebe tamoc êsôm biŋ êtu tôŋ gebe enseŋ aôm su, oc aê jakêŋ ŋawae êndêŋ aôm atom me.” ");
INSERT INTO jae_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Go Dawid kêsôm gêdêŋ Jonatan gebe” Tamam embe ênsaic biŋ aôm, asa oc êkêŋ ŋawae êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Tec Jonatan kêsôm gêdêŋ Dawid gebe “Tana kôm acgom.” Tec êsêagêc sêwiŋ tauŋ sêja kôm. ");
INSERT INTO jae_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Ma Jonatan kêsôm gêdêŋ Dawid gebe “Aê jasôm biŋ tonec jakô Apômtau, Israelnêŋ Anôtô laŋônêmŋa gebe eleŋŋa me ŋaeleŋ teŋ ŋaockatu amboac tonec embe jajala tamocnê ŋalêlôm gebe êlic Dawid ŋajam, go jasakiŋ biŋ êndêŋ aôm êwac. ");
INSERT INTO jae_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Mago eŋ embe taê ênam êtu tôŋ gebe enseŋ aôm su, ma aê embe jakêŋ puc aôm ma jasakiŋ aôm ôêc toôlim samucgeŋ atom, go Anôtô enseŋ aê su amboac tonaŋgeŋ. Apômtau êwiŋ aôm êtôm gêwiŋ tamoc. ");
INSERT INTO jae_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Embe jamoa matoc jali êndêŋ tonaŋ, go taêm walô aê êtu Apômtauŋa gebe jamac êndu atom. ");
INSERT INTO jae_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Ma ôkôc nêm moasiŋ su aŋga ŋoc gôlôacnêŋ atomanô. Apômtau embe enseŋ Dawidnê ŋacjo samob tomalageŋ su aŋga nom, ");
INSERT INTO jae_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","go Jonatannê ŋaê êkac tau su aŋga Dawidnê gôlôacnêŋ atom. Ma Apômtau êkêŋ ŋagêjô êndêŋ Dawidnê ŋacjo.” ");
INSERT INTO jae_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Go Jonatan keteŋ Dawid gebe êtôc lêma êtiam êtu nê têtac gêwiŋ eŋ ŋanôŋa gebe eŋ têtac gêwiŋ Dawid amboac têtac gêwiŋ tau. ");
INSERT INTO jae_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Go Jonatan kêsôm gêdêŋ eŋ gebe “Eleŋ ajôŋ oc mêŋêô lasê. Oc sensom aôm gebe malac sawa. ");
INSERT INTO jae_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Ma eleŋ ŋaeleŋ oc sensom aôm ŋanôgeŋ. Êndêŋ tonaŋ aôm ôna gamêŋ, taŋ kôsiŋ taôm gêdêŋ bêc teŋ su naŋ, ma ôsiŋ taôm ômoa poc totoŋ ŋamuŋa. ");
INSERT INTO jae_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Ma aê oc japê sôb têlêac êsêp poc totoŋ ŋamakeŋ jaŋgôm amboac japô sokoc. ");
INSERT INTO jae_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Ôkêŋ taŋam ŋapep. Aê oc jasakiŋ ŋapalê tau ma jasôm gebe ‘Naosom sôb.’ Aê embe jasôm êndêŋ ŋapalê gebe ‘Ôlic sôb kêsêp aômnêm ŋamakeŋ tonecŋa, ôkôc samaŋ, go ômôêŋ.’ Aê jasôm biŋŋanô êtu Apômtau, taŋ gêmoa mata jali naŋŋa gebe oc ômoa ŋajam ma gêŋwapac teŋ êtap aôm sa atom. ");
INSERT INTO jae_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Mago embe jasôm êndêŋ ŋapalê tau gebe ‘Ôlic sôb gêc ŋamakeŋ ônê’ naŋ ôêc ôna gebe Apômtau kêsakiŋ aôm gebe ôna. ");
INSERT INTO jae_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Ma Apômtau oc êmbiŋ aêagêc tôŋ endeŋ tôŋgeŋ êtu biŋ, taŋ aêagêc tamasaŋ gêdêŋ tauŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Amboac tonaŋ Dawid kêsiŋ tau ôkwi gêmoa kom. Ma gêdêŋ taŋ ajôŋ mêŋgêô lasê naŋ, kiŋ gêŋgôŋ sic gebe êniŋ gêŋ. ");
INSERT INTO jae_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Kiŋ gêŋgôŋ nê mala, gêŋgôŋ kêdabiŋ sagiŋ kêtôm gêgôm-gêgôm. Jonatan gêŋgôŋ kêkanôŋ eŋ ma Abner gêŋgôŋ kêsi Saulŋa. Tageŋ Dawid mala sawa. ");
INSERT INTO jae_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Mago gêdêŋ bêc tonaŋ Saul kêsôm biŋ teŋ atom. Eŋ taê gêjam gebe “Biŋ teŋ kêtap Dawid sa, tec eŋ kêtu selec atom.” ");
INSERT INTO jae_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Mago ajôŋ mêŋgêô lasê ŋabêc kêtu luagêcŋa naŋ Dawid mala sawa kêtiam. Tec Saul kêsôm gêdêŋ latu Jonatan gebe “Kêtu asageŋŋa Isai latu mêŋgeŋ gêŋ gêdêŋ nôgeŋ to galoc atom.” ");
INSERT INTO jae_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Go Jonatan gêjô Saul awa gebe “Dawid keteŋ aê ŋanôgeŋ gebe jawi eŋ siŋ êna Betlehem ");
INSERT INTO jae_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","ma kêsôm gebe ‘Aê jateŋ gebe jana gebe aêacma gôlôac sêkêŋ da aŋga malac. Ma teoc kêjatu aê gebe jawiŋ. Amboac tonaŋ embe ôlic aê ŋajam, go ôkêŋ aê jana gebe jalic teoci.’ Kêtu biŋ tonaŋŋa tec eŋ gêmêŋ gêŋgôŋ kiŋnê tebo atom.” ");
INSERT INTO jae_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Go Saul têtac ŋandaŋ sec gêdêŋ Jonatan ma kêsôm gêdêŋ eŋ gebe “Awê sec to mockaiŋo ŋalatu aôm. Aê kajala gebe amagêc Isai latu abiŋ taôm tôŋ, tec gêgôm aôm taôm majam kêsa to kômajec tênam amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Êtôm têm samob, taŋ Isai latu êmoa mata jali aŋga nom naŋ, aôm ômoa atom ma nêm gôliŋ kiŋŋa oc ênêc ŋaŋêŋ atom amboac tonaŋgeŋ. Tec ôsakiŋ lau gebe sêkôc eŋ dêndêŋ aê sêmêŋ. Eŋ êmac êndu.” ");
INSERT INTO jae_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Go Jonatan gêjô tama Saul awa ma kêsôm gêdêŋ eŋ gebe “Eŋ êmac êndu êtu asageŋŋa. Eŋ gêgôm asageŋ keso.” ");
INSERT INTO jae_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Tec Saul kêkôtêŋ kêm gebe êŋguŋ eŋ. Tec Jonatan kêjala gebe tamanê biŋ kêtu tôŋ gebe ênac Dawid êndu. ");
INSERT INTO jae_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Ma Jonatan têtac ŋandaŋ sec ma gêdi sa aŋga tebo ma geŋ gêŋ teŋ gêdêŋ ajôŋ mêŋgêô lasê ŋabêc kêtu luagêcŋa atom, gebe ênê ŋalêlôm ŋawapac kêtu Dawidŋa gebe tama gêbu eŋ. ");
INSERT INTO jae_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Gêdêŋ bêbêcgeŋ Jonatan kêsa kôm gêja kêtôm kêmasaŋ biŋ gêdêŋ Dawid su ma kêkôc ŋapalê sauŋ teŋ gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Eŋ kêsôm gêdêŋ ŋapalê tau gebe “Ôlêti ma onsom sôb, taŋ galoc japê naŋ.” Ŋapalê kêlêti ma eŋ kêpê sôb teŋ kêka lêlêc ŋapalê tau gêja. ");
INSERT INTO jae_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Ŋapalê jagêô lasê gamêŋ, taŋ Jonatan nê sôb kêsêp naŋ, go Jonatan gêmôêc biŋ kêdaguc ŋapalê tau gebe “Sôb tonaŋ kêka lêlêc aôm gêja ônê.” ");
INSERT INTO jae_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Jonatan kêkac ŋapalê tau gebe “Ôlêti ŋagaôgeŋ, ônam gamêŋ tôŋ atom.” Amboac tonaŋ ŋapalê kejoŋ sôb sa ma gêmu gêdêŋ nê ŋatau gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Mago ŋapalê kêjala biŋ samob tonaŋ ŋam atom. Jonatan agêc Dawid tauŋgeŋ sêjala. ");
INSERT INTO jae_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Go Jonatan kêkêŋ nê laukasap gêdêŋ nê ŋapalê ma kêsôm gêdêŋ eŋ gebe “Ôkôc ôna malac.” ");
INSERT INTO jae_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Gêdêŋ taŋ ŋapalê gêja naŋ, go Dawid gêdi aŋga poc totoŋ muŋa mêŋgêu tau laŋôanô gêdêŋ nom ma gewec gêdêŋ eŋ kêtu dim têlêac. Go agêc sêlêsôp tauŋ aliŋanô ma têtaŋ tauŋ, ma Dawid kêtaŋ kêlêlêc. ");
INSERT INTO jae_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Go Jonatan kêsôm gêdêŋ Dawid gebe “Ôêc tobiŋmalôgeŋ ôna. Biŋ taŋ tamoatiŋ tajam Apômtau laŋô naŋ, êtu tôŋ. Apômtau êkô aêagêc ŋasawa ma êkô aêŋoc wakuc to aômnêm wakuc ŋasawa amboac tonaŋgeŋ endeŋ tôŋgeŋ.” Dawid gêdi gêc gêja ma Jonatan gêmu gêja malac. ");
INSERT INTO jae_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Go Dawid jagêô lasê Nob gêdêŋ Anôtônê dabuŋwaga Ahimelek aŋga malac Nob. Ahimelek kêpuc Dawid tôŋ-tôŋ to nê ŋalêlôm ŋatutuc ma kêsôm gêdêŋ eŋ gebe “Aôm taômgeŋ gômôêŋ ma teŋ gêwiŋ aôm atom kêtu ageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Ma Dawid kêsôm gêdêŋ dabuŋwaga Ahimelek gebe “Kiŋ kêjatu aê biŋ teŋŋa ma kêsôm gêdêŋ aê gebe ‘Aê jasakiŋ aôm êtu jaeŋ teŋŋa ma jajatu aôm biŋ teŋŋa, mago ŋac teŋ êŋô biŋ tonaŋ ŋawae teŋ atom.’ Amboac tonaŋ gajac noc ŋoc lau gebe sêmêŋ gamêŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Galoc gêŋ teŋ embe ênêc aômŋa amboac polom 5 me gêŋ taniŋŋa ŋagêdô naŋ, ôkêŋ êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Mago dabuŋwaga gêjô Dawid awa gebe “Polom ŋaôma teŋ gêc aêŋa atomanô. Polom dênaŋ dabuŋŋageŋ tec gêc. Nêm lau wakuc embe têtu mêtê lauoŋa, go sêniŋ polom tau.” ");
INSERT INTO jae_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Dawid gêjô dabuŋwaga awa gebe “Biŋŋanô, sêjac jao lauo gêdêŋ aêac bêc ŋagêdô su. Gêdêŋ taŋ aê gadi naŋ, lau sêjam dabuŋ tauŋ. Ocsalô kôm kaiŋ teŋ gêjac aê ŋawae, tec sêjam dabuŋ tauŋ ŋapep sawageŋ.” ");
INSERT INTO jae_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Amboac tonaŋ dabuŋwaga kêkêŋ polom dabuŋ gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Saul kêjanda lau Pilisti su ma gêdêŋ taŋ gêmu gêja nê malac naŋ, êsêac sêjac miŋ gêdêŋ eŋ gebe Dawid gêmoa gamêŋ sawa Engedi. ");
INSERT INTO jae_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Amboac tonaŋ Saul kêkôc lau siŋ 3,000, taŋ kêjaliŋ êsêac sa aŋga lau Israel samob nêŋ naŋ, ma jagesom Dawid to nê lau aŋga pocdênaŋ Noniŋ gêbôm ŋagamêŋ kêsi oc kêpiŋa. ");
INSERT INTO jae_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Saul jagêô lasê pocgêsuŋ teŋ, taŋ gêc dombanêŋ sapa ŋaintêna ŋamagê naŋ. Eŋ kêsô gêja gebe ênam tau ôkwi. Dawid to nê lau sêsiŋ tauŋ sêŋgôŋ pocgêsuŋ tonaŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Go Dawidnê lau sêsôm gêdêŋ eŋ gebe “Galoc bêc tau, taŋ Apômtau kêsôm ŋabiŋ gêdêŋ aôm naŋ, gebe ‘Ôlic acgom, aê gabe jakêŋ nêm ŋacjo êsêp aôm lêmam gebe ôŋgôm êtôm aôm taêm ênam.’” Ma Dawid gêdi jakêsêbuŋ Saul nê ŋakwê baliŋ ŋalêsu su kelecgeŋ. ");
INSERT INTO jae_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Su, go Dawidnê ŋalêlôm kepeŋ eŋ kêtu kêsêbuŋ Saulnê ŋakwê baliŋ ŋalêsu gêŋgic. ");
INSERT INTO jae_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Ma eŋ kêsôm gêdêŋ nê lau gebe “Apômtau ênac jao aê gebe jaŋgôm ŋoc ŋatau, taŋ Apômtau geŋ oso eŋ naŋ, sec ma jakêŋ lemoc êpi eŋ, taŋ kêtu Apômtaunê ŋac geŋ oso eŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Ma Dawid gêjam saic nê lau ŋa biŋ tonaŋ ma gêlôc gebe êsêac sênac Saul êndu atom. Ma Saul gêdi sa ma gêwi pocgêsuŋ tau siŋ kêsa gêja. ");
INSERT INTO jae_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Ŋasawa sauŋgeŋ, go Dawid kêdaguc eŋ kêsa awê gêja amboac tonaŋgeŋ ma gêmôêc kêdaguc Saul ma kêsôm gebe “O ŋoc ŋatau kiŋ.” Saul kêkac tau ôkwi ma Dawid gewec laŋôanô gêdêŋ nom ma ketoc Saul sa. ");
INSERT INTO jae_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Ma Dawid kêsôm gêdêŋ Saul gebe “Aôm kôkêŋ taŋam lau, taŋ sêsôm gebe ‘Dawid gebe enseŋ aôm su’ naŋ, nêŋ biŋ kêtu ageŋŋa. ");
INSERT INTO jae_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Bêc tonec aôm taôm gôlic ŋa matamanô gebe Apômtau kêkêŋ aôm kôsêp aê lemoc aŋga pocgêsuŋ. Ma lau ŋagêdô sêsôm gêdêŋ aê gebe janac aôm êndu. Mago aê gagôm atom. Aê kasôm gebe aê oc jakêŋ lemoc êpi ŋoc ŋatau atom gebe Apômtau geŋ oso eŋ. ");
INSERT INTO jae_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","O tamoc, ôlic nêm ŋakwê baliŋ ŋalêsu, tec gêc aê lemoc nec. Aê kasêbuŋ ŋakwê baliŋ ŋalêsu tonec su, mago gajac aôm êndu atom. Tonaŋ êkêŋ puc aôm ma aôm ôjala gebe aê taêc gêjam biŋ sec teŋ atom ma biŋ jali tauc sa êndêŋ aômŋa gêc ŋoc ŋalêlôm atom. Aê gagôm sec gêdêŋ aôm atom, mago aôm kôjanda aê gebe ônac aê êndu. ");
INSERT INTO jae_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Apômtau êmêtôc aêagêcnêŋ biŋ. Apômtau êkêŋ ŋagêjô êndêŋ aôm êjô aê su. Mago aê lemoc êmoasac aôm atom. ");
INSERT INTO jae_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Êtôm biŋgôliŋ laŋgwa kêsôm gebe ‘Ŋac alôb-alôb êŋgôm gêŋ alôb-alôb’, mago aêŋoc lemoc êmoasac aôm atom. ");
INSERT INTO jae_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Israelnêŋ kiŋ gêmêŋ kêtu asaŋa. Kôjanda asa. Kôjanda kêam ŋamatê teŋ me. Me kôjanda tec teŋ me. ");
INSERT INTO jae_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Amboac tonaŋ Apômtau êtu ŋacmêtôc ma êmêtôc biŋ, taŋ gêc aêagêc ŋasawa. Eŋ êtuc kêniŋ aêŋoc ŋam ma ênam aê kêsi aŋga aôm lêmam.” ");
INSERT INTO jae_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Dawid kêsôm biŋ tonaŋ gêdêŋ Saul su, go Saul kasôm gebe “O latuc Dawid, aôm awam tonaŋ me.” Ma Saul gêu taŋiboa lasê ma kêtaŋ. ");
INSERT INTO jae_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Ma kasôm gêdêŋ Dawid gebe” Aôm gôgôm jagêdêŋ kêlêlêc aê. Gebe aê kakêŋ sec gêdêŋ aôm, mago aôm kôkêŋ moasiŋ gêjô su. ");
INSERT INTO jae_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Ocsalô tonec Apômtau kêkêŋ aê kasêp aôm lêmam, mago gôjac aê êndu atom. Tec gêwa aôm sa gebe kômoasiŋ aê ŋanô. ");
INSERT INTO jae_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Ŋac teŋ embe êtap nê ŋacjo sa oc awi eŋ siŋ êc toôli samucgeŋ ana me. Amboac tonaŋ Apômtau êmoasiŋ aôm êjô gêŋ, taŋ ocsalô tonec gôgôm gêdêŋ aê naŋ. ");
INSERT INTO jae_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Ma galoc ôlic acgom, aê kajala gebe aôm oc ôtu kiŋ ma Israelnêŋ gôliŋ kiŋŋa tonaŋ êsêp aôm lêmam ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Amboac tonaŋ ôtôc lêmam ôkô Apômtau laŋônêm gebe embe jamac êndu su, go onseŋ ŋoc wakuc su atom ma ômbuŋ ŋoc ŋaê su aŋga tamocnê gôlôac nêŋ atom. ");
INSERT INTO jae_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Ma Dawid kêtôc lêma gêdêŋ Saul. Go Saul gêmu gêja nê malac ma Dawid to nê lau sêpi malac ŋajaŋa sêja. ");
INSERT INTO jae_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Gêdêŋ tonaŋ Samuel gêmac êndu. Ma lau Israel samob sêkac tauŋ sa ma têtaŋ taŋiboa kêtu eŋŋa, go sêsuŋ eŋ aŋga taunê andu aŋga Rama. ");
INSERT INTO jae_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Gêdêŋ ŋasawa tonaŋ lau Pilisti sêkalem nêŋ siŋwaga samob sêpi tageŋ sebe sênac siŋ êndêŋ lau Israel. Ma nêŋ kiŋ Akis kêsôm gêdêŋ Dawid gebe “Aôm kôjala gebe aôm to nêm lau oc anac siŋ awiŋ aê.” ");
INSERT INTO jae_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Dawid kêsôm gêdêŋ Akis gebe “Ŋajam, aôm oc ôlic gêŋ, taŋ nêm sakiŋwaga ocgo êŋgôm naŋ.” Ma Akis kêsôm gêdêŋ Dawid gebe “Ŋajam, aê gabe jakêŋ aôm ôtu aê taucŋoc siŋwaga ejop aê endeŋ tôŋgeŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Gêdêŋ ŋasawa tonaŋ Samuel gêmac êndu su ma lau Israel samob têtaŋ taŋiboa kêtu eŋŋa ma sêsuŋ eŋ aŋga taunê malac Rama. Ma Saul kêtiŋ lau, taŋ sêkalem ŋacmatê katuŋ to lau mectomaŋŋa naŋ, su aŋga lau Israelnêŋ gamêŋ. ");
INSERT INTO jae_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Lau Pilisti sêkac tauŋ sa mêŋsê nêŋ becobo kêkô Sunem, ma Saul kêkac lau Israel samob sa sê nêŋ becobo kêkô gamêŋ ŋabau Gilboa. ");
INSERT INTO jae_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Gêdêŋ taŋ Saul gêlic lau Pilisti nêŋ siŋwaga taêsam naŋ, eŋ kêtêc tau ŋasec ma nê ŋalêlôm ŋatutuc ŋanô. ");
INSERT INTO jae_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Go Saul kêtu kênac Apômtau, mago Apômtau gêjô eŋ awa ŋa mê me kapoac me propete aweŋ atom. ");
INSERT INTO jae_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Amboac tonaŋ Saul kêsôm gêdêŋ nê sakiŋwaga gebe “Ansom awê teŋ, taŋ êtôm gebe êtu kênac ŋacmatê katuŋ naŋ. Aê gabe najatu kênac eŋ.” Ma nê sakiŋwaga sêjô eŋ awa gebe “Awê teŋ gêmoa Endor, taŋ kêtôm gebe êtu kênac ŋacmatê katuŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Tec Saul kêsô ŋakwê ŋaôma teŋ gêjam lau ŋaôma laŋôŋ ma nê ŋac luagêc sêwiŋ eŋ sêja. Êsêac jasêô lasê dêdêŋ awê tau gêdêŋ gêbêc ma Saul kêsôm gebe “Ôkalem ŋacmatê katuŋ êtu aêŋa. Ma ômôêc ŋac, taŋ aê jasam êndêŋ aôm naŋ, nê katu êmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Mago awê tau gêjô eŋ awa gebe “Aôm taôm kôjala gêŋ, taŋ Saul gêgôm naŋ. Eŋ kêtiŋ lau, taŋ sêkalem ŋacmatê katuŋ to lau mectomaŋ su aŋga gamêŋ tonec. Aôm gobe ôwa lakô aê gebe onseŋ aê su kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Mago Saul kêtôc lêma ma kêsôm gebe “Aê jasôm biŋŋanôgeŋ jakô Apômtau mata jali laŋônêmŋa gebe aôm ôwê biŋ tonaŋ ŋakaiŋ atom.” ");
INSERT INTO jae_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Go awê tau kêtu kênac gebe “Jakalem asa êmêŋ êtu aôm ŋa.” Ma Saul gêjô eŋ awa gebe “Ôkalem Samuel êmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Gêdêŋ taŋ awê tau gêlic Samuel naŋ, eŋ kêwakic ma kêsôm gêdêŋ Saul gebe “Aôm Saul tau. Kôsau aê kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Tec kiŋ kêsôm gêdêŋ eŋ gebe “Ôtêc taôm atom. Gôlic asageŋ.” Awê tau gêjô Saul awa gebe “Aê galic ŋalau teŋ kêpi aŋga nom ŋalêlôm gêmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Saul kêtu kênac gebe “Ŋalaŋô kêtôm asageŋ.” Awê gêjô eŋ awa gebe “Ŋamalacanô teŋ tec kêpi gêmêŋ ma ŋakwê baliŋ kêkwa eŋ auc.” Go Saul kêjala gebe Samuel tau tônê, tec gewec laŋôanô gêdêŋ nom ma ketoc eŋ sa. ");
INSERT INTO jae_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Go Samuel kêsôm gêdêŋ Saul gebe “Aôm kôlêsôŋ aê ma gômôêc aê gamu kapi gamêŋ kêtu asageŋŋa.” Saul gêjô eŋ awa gebe “Aê kêpô lêna tau ŋanôgeŋ. Lau Pilisti sêjac siŋ gêdêŋ aê ma Anôtô gêbuc dêmôê aê ma gêjô aê aoc kêtiam atom. Eŋ kêkêŋ propete seoc biŋ lasê me gêsuŋ mê teŋ gêdêŋ aê atom. Tec aê kakalem aôm gebe ôsôm gêŋ, taŋ jaŋgôm naŋ, êndêŋ aê.” ");
INSERT INTO jae_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuel kêsôm gebe “Apômtau kêgamiŋ tau gêdêŋ aôm to kêtu nêm ŋacjo su ma aôm kôtu kênac aê kêtu asageŋŋa. ");
INSERT INTO jae_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Apômtau gêgôm biŋ, taŋ kasôm lasê kêsa aê aoc naŋ, ŋanô kêsa kêpi aôm. Eŋ kêkac gôliŋ kiŋŋa su aŋga aôm lêmam ma kêkêŋ kêpi ŋac wacbaŋ aômŋa Dawid. ");
INSERT INTO jae_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Aôm taŋam wamu gêdêŋ Apômtau awa atom ma gôgôm ênê têtac ŋandaŋ gêdêŋ lau Amalek ŋanô kêsa atom, tec galoc Apômtau gêgôm gêŋ tonaŋ gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Ma Apômtau êkêŋ aôm taômgeŋ ôsêp lau Pilisti lemeŋ atom, êkêŋ lau Israel samob sêwiŋ. Ma êndêŋ eleŋŋa aôm to latômi oc mêŋamoa awiŋ aê ma Apômtau oc êkêŋ Israelnêŋ siŋwaga sêsêp lau Pilisti lemeŋ amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Saul gêŋô Samuelnê biŋ tonaŋ e nê katu kelendec ma eŋ gêu tau gêc nom. Eŋ ôliwalô gêjaŋa gebe geŋ geŋ atom bêc samuc teŋ to gêbêc samuc teŋ. ");
INSERT INTO jae_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Go awê tau gêdêŋ Saul gêja e gêlic eŋ kêsabigeŋ gêc, tec kêsôm gêdêŋ eŋ gebe “Nêm sakiŋwagao aê kakêŋ taŋoc aômnêm biŋ. Ma gajac môkêc tauc gebe janaŋa, tec kasô nêm biŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Galoc ôkêŋ taŋam nêm sakiŋwagao aê. Ôlôc go jakêŋ gêŋ taniŋŋa ŋagec êndêŋ aôm ôniŋ têkwam saki êsa gebe ôsêlêŋ.” ");
INSERT INTO jae_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Mago eŋ gedec ma kêsôm gebe “Masi, aê janiŋ gêŋ atom.” Tec ênê sakiŋwaga jasêwiŋ awê tau ma sêkac eŋ e kêkêŋ taŋa nêŋ biŋ, go gêdi aŋga nom mêŋgêŋgôŋ mê. ");
INSERT INTO jae_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Awê tau kêkôc bulimakao ŋalatu taŋgeŋ teŋ, taŋ kêkô nê andu naŋ, ma gêjac êndu ma kêsa. Go kêkôc polom matac mêŋkêgamuc ma kêpac polom ŋalucgeŋ ");
INSERT INTO jae_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","mêŋkêkêŋ gêdêŋ Saul to nê sakiŋwaga. Seŋ gêŋ su, go ac sêdi ma jasêc sêja gêdêŋ gêbêc tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Lau Pilisti sêjac siŋ gêdêŋ lau Israel ma sêjam lau Israel êliŋ-êliŋ to sêjac taêsam êndu sêc lôc Gilboa. ");
INSERT INTO jae_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Lau Pilisti sêjanda Saul to nê latui e sêjac Saul latui Jonatan agêc Abinadab ma Malkisua êndu. ");
INSERT INTO jae_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ma ŋacjo sêgi Saul auc e lau talamŋa sêpê eŋ ŋa sôb. ");
INSERT INTO jae_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Amboac tonaŋ eŋ kêsôm gêdêŋ ŋac wakuc, taŋ gêôc ênê laukasap naŋ, gebe “Ômbuc nêm siŋ sa ma ôŋguŋ aê êndu gebe lau samuc tonaŋ mêŋsênac aê êndu ma sêsu aê susu atom.” Mago ŋac tau gedec gebe eŋ kêtêc tau ŋanô. Go Saul kêkôc tau nê siŋ ma gêu tau kêsêp. ");
INSERT INTO jae_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Gêdêŋ taŋ nê ŋac-gêôc-ênê-laukasapwaga gêlic Saul gêmac êndu naŋ, eŋ tau jagêguŋ tau ma gêmac êndu gêwiŋ Saul. ");
INSERT INTO jae_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Amboac tonaŋ Saul gêmac êndu to nê latui têlêac ma nê ŋac-gêôc-ênê-laukasapwaga to nê lau samob sêmac êndu gêdêŋ bêc tageŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Lau Israel, taŋ sêŋgôŋ gaboaŋ Jesrel ŋamakeŋ to bu Jordan ŋagamêŋ oc kêpiŋa naŋ, sêlic Israelnêŋ siŋwaga sêc êliŋ-êliŋ ma sêjac Saul to latui êndu, tec êsêac sêwi nêŋ malac siŋ ma sêc su amboac tonaŋgeŋ. Ma lau Pilisti mêŋsêŋgôŋ êsêacnêŋ malac tau. ");
INSERT INTO jae_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Ŋageleŋ lau Pilisti sebe sêjaŋgo ŋacmatê nêŋ gêŋ siŋŋa su ma têtap Saul to nê latui têlêac nêŋ ŋawêlêlaŋ sa sêc lôc Gilboa. ");
INSERT INTO jae_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Êsêac dêdim Saul gêsutêkwa gêŋgic ma sêjaŋgo ênê laukasap su, go sêsakiŋ lau jaeŋ sêjac laoc Pilisti nêŋ gamêŋ samucgeŋ gebe sêsôm ŋawae ŋajam tonaŋ lasê êndêŋ nêŋ anôtôi to lau sêŋô. ");
INSERT INTO jae_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Êsêac tetoc Saulnê laukasap gêc anôtôo jaba Astarot nê lôm dabuŋ ma sêjac ênê ŋawêlêlaŋ tôŋ geŋkaleŋ malac Betsan ŋatuŋbôm. ");
INSERT INTO jae_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Ma gêdêŋ lau Jabes-Gilead sêŋô biŋ, taŋ lau Pilisti sêgôm gêdêŋ Saul naŋ ŋawae ");
INSERT INTO jae_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","êsêacnêŋ lau ŋaclai samob dêdi ma sêsêlêŋ gêdêŋ gêbêc jasêkôc Saul to nê latui nêŋ ŋawêlêlaŋ su aŋga Betsan ŋatuŋbôm ma sêkôc sêmêŋ malac Jabes, go sêkêŋ ja geŋ. ");
INSERT INTO jae_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Ma sêkôc êsêacnêŋ ŋatêkwa jasêsuŋ eŋ gêc ka kamem aŋga Jabes ŋalabu ma sêjam dabuŋ mo bêc 7. ");
INSERT INTO jae_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Saul gêmac êndu su ma Dawid kêku lau Amalek tulu. Eŋ gêmu gêmêŋ mêŋgêmoa Siklag bêc luagêc. ");
INSERT INTO jae_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Ma gêdêŋ bêc kêtu têlêacŋa ŋac teŋ mêŋgêô lasê aŋga Saulnê siŋwaga nêŋ tonê ŋakwê gêŋgic ma kekop gi eŋ môkêapac. Gêdêŋ taŋ eŋ gêô lasê gêdêŋ Dawid naŋ, ŋac tau gêu tau gêc nom ma ketoc eŋ sa. ");
INSERT INTO jae_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Dawid kêtu kênac eŋ gebe “Gômôêŋ aŋga ondoc.” Tec eŋ gêjô ênê biŋ gebe “Aê gaêc aŋga Israelnêŋ siŋwaga nêŋ, tec gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Ma Dawid kêsôm gêdêŋ eŋ gebe “Biŋ amboac ondoc. Ôsômmaŋ.” Ma eŋ kêsôm gêdêŋ Dawid gebe “Siŋwaga sêc su aŋga siŋmala ma ŋacjo sêjac taêsam êndu. Saul agêc latu Jonatan sêmac êndu amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Go Dawid kêtu kênac ŋac matac tau, taŋ kêkôc ŋawae gêmêŋ naŋ gebe “Saul agêc Jonatan sêmac êndu ŋawae kêtap aôm sa ŋalêŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Ŋac matac gêjô ênê biŋ gebe “Aê tauc gamoa lôc Gilboa gamoa ma galic Saul geseŋ guŋ tau tôŋ ŋa nê kêm kêkô ma ŋacjonêŋ kareta to lau, taŋ sêŋgôŋ hos ŋaô naŋ, sêkapiŋ eŋ sa. ");
INSERT INTO jae_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Gêdêŋ taŋ eŋ kêkac tau ôkwi naŋ, gêlic aê ma gêmôêc aê. Aê gajô eŋ awa gebe ‘Aê tec gamoa.’ ");
INSERT INTO jae_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Eŋ kêtu kênac aê gebe ‘Aôm asa.’ Ma aê gajô eŋ awa gebe ‘Aê ŋac Amalek teŋ.’ ");
INSERT INTO jae_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Go eŋ kêsôm gêdêŋ aê gebe ‘Ômôêŋ ma ônac aê êndu. Matocanô kêtu talô su, tageŋ matoc jali gamoa.’ ");
INSERT INTO jae_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Amboac tonaŋ aê katu gasuc eŋ jagajac eŋ tomatêgeŋ gebe aê kajala gebe eŋ oc êmoa atom. Go aê kakôc sunsuŋ kiŋŋa su aŋga môkêapac ma joc aŋga lêmadambê tec kajoŋ gadêŋ aôm, ŋoc apômtau gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Go Dawid lêma kêsêp nê ŋakwê ma kêkac gêŋgic ma lau samob, taŋ sêmoa sêwiŋ eŋ naŋ, sêgôm amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Ma sêpuc taŋiboa sa ma têtaŋ to sêjam dabuŋ mo e oc jakêsêp kêtu Saul agêc nê latu Jonatan ma Apômtaunê lau Israel, taŋ siŋ geseŋ êsêac su naŋŋa. ");
INSERT INTO jae_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Ma Dawid kêsôm gêdêŋ ŋac matac, taŋ kêkôc ŋawae gêmêŋ naŋ gebe “Aôm aŋga ondoc.” Ma eŋ gêjô eŋ awa gebe “Ŋac jaba Amalek teŋ latu aê, mago gamoa nêm gamêŋ.” ");
INSERT INTO jae_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Go Dawid kêsôm gêdêŋ eŋ gebe “Amboac ondoc tec kôtêc taôm atom ma lêmam kêpi Apômtaunê ŋac, taŋ geŋ oso eŋ naŋ, ma gôjac eŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Go Dawid gêmôêc lau matac nêŋ ŋac teŋ gêmêŋ ma kêsôm gebe “Ôna, ônac eŋ êndu.” Amboac tonaŋ eŋ jagêjac ŋac Amalekŋa tonaŋ e gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Dawid kêsôm gêdêŋ eŋ gebe “Nêm dec êpi aôm taôm gebe aôm taôm kôkic nêm biŋ ŋa taôm awamsuŋ gêdêŋ taŋ kôsôm gebe ‘Aê gajac Apômtaunê ŋac, taŋ geŋ oso eŋ naŋ êndu naŋ.’” ");
INSERT INTO jae_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Go Dawid gêga wê taŋiboaŋa tonec kêpi Saul agêc latu Jonatan ");
INSERT INTO jae_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","ma kêjatu gebe têndôŋ wê tau êndêŋ lau Juda ma teto kêsêp Jasarnê buku. ");
INSERT INTO jae_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","“Ojae Israel, sêjac nêm waem êndu gêc nêm lôc ŋaô. Ojae, nêm siŋsêlêc ŋactêkwa sêjaŋagoc. ");
INSERT INTO jae_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Asôm lasê aŋga Gat atom ma anac miŋ aŋga Askalon ŋamalacluŋ atom gebe lauo Pilisti têtu samuc atom ma lau samuc latuŋio sênam lasê atom. ");
INSERT INTO jae_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","“Amac lôc Gilboa, maniŋ to kom êpi amac atom, atu gamêŋ gasaŋ. Gebe seseŋ siŋsêlêcnê lautuc ŋadabuŋ su ma seŋ oso Saulnê lautuc ŋa niptêkwi kêtiam atom. ");
INSERT INTO jae_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","“Jonatannê sôb keso ŋacjo atomanô ma Saulnê siŋ gêjam kôm ŋaôma atom. Gêjac lau siŋsêlêc popoc ma geseŋ ŋacjo su. ");
INSERT INTO jae_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","“Saul agêc Jonatan têntac gêwiŋ tauŋ to sêlic tauŋ ŋajam sêmoa mateŋ jali sêwiŋ tauŋ ma sêmac êndu sêwiŋ tauŋ amboac tonaŋgeŋ. Sêlêti ŋagaô kêlêlêc momboaŋ gêlôb ma nêŋ ŋaclai kêlêlêc lewe nêŋ su. ");
INSERT INTO jae_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","“O amac Israel latuŋio, ataŋ êtu Saulŋa gebe eŋ kêkêŋ ŋakwê asôsamuc ŋajam-ŋajam gêdêŋ amac ma kêkêŋ gêlôŋ gold geŋ kaleŋ nêm ŋakwê. ");
INSERT INTO jae_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","“Ojae, lau ŋactêkwa sêjaŋa aŋga siŋ ŋalêlôm. Sêjac Jonatan êndu tomatêgeŋ gêc lôc ŋaô. ");
INSERT INTO jae_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","“O teocenec Jonatan, atêc gêmô aê kêtu aômŋa. Ojae, ŋoc gêŋenec. Nêm têmtac gêwiŋ aêŋa kêmoasiŋ aê ŋanôgeŋ kêlêlêc lauo têntac gêwiŋ aêŋa su. ");
INSERT INTO jae_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","“Ojae, siŋ geseŋ lau ŋactêkwa su ma nêŋ laukasap gêjaŋa.” ");
INSERT INTO jae_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Tonaŋ su, go Dawid kêtu kênac Apômtau gebe “Aê oc Japi najaŋgôŋ malac Judaŋa teŋ me masi.” Apômtau gêjô ênê biŋ gebe “Ôna.” Dawid kêtu kênac kêtiam gebe “Jana malac ondoc.” Ma Apômtau gêjô eŋ awa gebe “Ôna Hebron.” ");
INSERT INTO jae_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Amboac tonaŋ Dawid gêwiŋ nê awêlagêc Ahinoam aŋga Jesrel agêc Nabalnê awêtuc Abigail aŋga Karmel jakêpi Hebron. ");
INSERT INTO jae_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Dawid kêkôc lau, taŋ sêmoa sêwiŋ eŋ naŋ, to nêŋ gôlôac sêwiŋ jasêŋgôŋ malac Hebron ŋagamêŋ ŋagêdô. ");
INSERT INTO jae_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Go ŋacwaga Judaŋa sêmêŋ ma seŋ oso Dawid kêtu gôlôac Judaŋa nêŋ kiŋ aŋga tonaŋ. Ŋawae gêdêŋ Dawid gêmêŋ gebe lau Jabes-Gilead sêsuŋ Saul su. ");
INSERT INTO jae_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","Tec Dawid kêsakiŋ biŋ tonec gêdêŋ êsêac gebe “Apômtau ênam mec amac gebe têmtac gêwiŋ nêm ŋatau Saul amboac tonaŋ ma asuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Apômtau êtôc nê têtac gêwiŋ teŋgeŋŋa êndêŋ amac to taê walô amac ma aê gabe jamoasiŋ amac amboac tonaŋgeŋ êjô gêŋ, taŋ amac agôm naŋ. ");
INSERT INTO jae_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Ma galoc têmtac êpa su ma awa taôm sa amboac ŋacgeŋ. Gebe nêm ŋatau Saul gêmac êndu su ma lau Juda seŋ oso aê gebe jatu êsêacnêŋ kiŋ.” ");
INSERT INTO jae_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Go Israelnêŋ gôlôacmôkê samob sêô lasê gadêŋ Dawid aŋga Hebron ma sêsôm gêdêŋ eŋ gebe “Aêacma ŋatê ŋagêdô aôm. ");
INSERT INTO jae_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Gêmuŋŋa gêdêŋ taŋ Saul kêtu kiŋ naŋ, aôm gôwê lau Israel kêtu siŋŋa sêja ma kôkôc êsêac sêmu sêmêŋ kêtiam. Ma Apômtau kêsôm gêdêŋ aôm gebe ‘Aôm oc ôtu aêŋoc lau Israelnêŋ gejobwaga ma ôtu êsêacnêŋ gôliŋwaga.’” ");
INSERT INTO jae_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Go lau Israelnêŋ kasêga samob sêô lasê gêdêŋ kiŋ aŋga Hebron ma kiŋ Dawid kêmoatiŋ poac gêwiŋ êsêac aŋga Hebron semoa Apômtau laŋônêm, go seŋ oso Dawid kêtu kiŋ Israelŋa gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Dawidnê jala kêtu 30 ma kêtu kiŋ. Ma eŋ gêjam gôliŋ êsêac jala 40. ");
INSERT INTO jae_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Eŋ kêtu kiŋ Judaŋa aŋga Hebron kêtôm jala 7 ma ajôŋ 6 ma aŋga Jerusalem eŋ kêtu Israel to Juda samobnêŋ kiŋ kêtôm jala 33. ");
INSERT INTO jae_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Kiŋ to nê lausiŋ sêja Jerusalem gebe sênac lau Jebus, taŋ têtu malac ŋatau naŋ. Êsêac sêsôm gedeŋ Dawid gebe “Aôm ôsô tonec ômôêŋ atomanô, lau mateŋpec to puliŋ oc sêkô aôm auc.” Biŋ tonaŋ ŋam gebe Dawid oc êku malac tulu atomanô. ");
INSERT INTO jae_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Mago Dawid kêku malac totuŋbôm ŋajaŋa tulu, tec sêsam malac tau gebe Dawidnê malac. ");
INSERT INTO jae_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Gêdêŋ bêc tonaŋ Dawid kêsôm gebe “Ŋac taŋ êsêli êsô gasuc buŋa naênac lau Jebus ma enseŋ lau puliŋ to mateŋpec Dawid gedec ŋanôgeŋ naŋ su, go êtu ŋac ŋamataŋa.” Kêtu tonaŋŋa sêsôm biŋ tonec sêmoa gebe “Mateŋpec to puliŋ oc sêsô Apômtaunê andu atom.” ");
INSERT INTO jae_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Dawid gêŋgôŋ malac totuŋbôm ŋajaŋa tau ma kêsam gamêŋ tau gebe Dawidnê malac. Eŋ kêkwê malac tau kêgigeŋ gêjam m aŋga Milo ma kêsô gêja. ");
INSERT INTO jae_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Amboac tonaŋ Dawidnê ŋaclai kêpi ec-kêpi ec gebe Apômtau lausiŋ undambêŋa nêŋ Anôtô gêmoa gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Lau Tirus nêŋ kiŋ Hiram kêsakiŋ lau jaeŋŋa gêdêŋ Dawid. Eŋ kêsakiŋ kaseda to kamunda ma sêsap-pocwaga ma sêkwê Dawidnê andu. ");
INSERT INTO jae_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Tec Dawid kêjala gebe Apômtau kêkêŋ eŋ kêtu kiŋ Israelŋa biŋŋanôgeŋ-ma ketoc ênê gôliŋ kiŋŋa sa kêtu ênê lau Israelŋa. ");
INSERT INTO jae_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Gêdêŋ taŋ Dawid gêwi Hebron siŋ jagêŋgôŋ Jerusalem naŋ, eŋ gêjam lauo ŋagêdô mêŋsêwiŋ, tec sêkôc ênê latuio to ŋac ŋagêdô. ");
INSERT INTO jae_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Latui taŋ teneŋi sêkôc aŋga Jerusalem naŋ, nêŋ ŋaê tonec Samua agêc Soba ma Natan agêc Salomo ");
INSERT INTO jae_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","ma Ibkar agêc Elisua ma Nepeg agêc Japia ");
INSERT INTO jae_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","ma Elisama agêc Eliada ma Elipelet. ");
INSERT INTO jae_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Gêdêŋ taŋ lau Pilisti sêŋô gebe seŋ oso Dawid kêtu kiŋ Israelŋa naŋ, lau Pilisti samob sêwê sêpi sêja gebe sêkôc Dawid tôŋ. Mago Dawid gêŋô biŋ tau ŋawae ma kêsêp jagêŋgôŋ malac totuŋbôm ŋajaŋa tau. ");
INSERT INTO jae_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Lau Pilisti sêô lasê gaboaŋ Repaim ma sêŋgôŋ gamêŋ aucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Go Dawid kêtu kênac Apômtau ma kêsôm gebe “Aê oc japi jandêŋ lau Pilisti jana ma aôm ôkêŋ êsêac sêsêp aê lemoc me masi.” Ma Apômtau gêjô eŋ awa gebe “Aec, ôpi ôna, gebe aê oc jakêŋ lau Pilisti sêsêp aôm lêmam biŋŋanôgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Amboac tonaŋ Dawid gêô lasê Bal-Perasim ma kêku êsêac tulu aŋga tonaŋ. Go eŋ kêsôm gebe “Apômtau gêjac ŋoc ŋacjo gêmuŋ aê amboac bu kêsap lêndaŋ.” Kêtu tonaŋŋa sêsam gamêŋ tonaŋ gebe Bal-Perasim (Apômtau kêku tulu). ");
INSERT INTO jae_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Lau Pilisti sêwi nêŋ anôtôi gwam siŋ sêc tonaŋ ma Dawid to nê lau sêkôc sa ma sêc sêja. ");
INSERT INTO jae_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Go lau Pilisti sêpi jasêô lasê gaboaŋ Repaim kêtiam ma sêŋgôŋ sêjam gamêŋ aucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Gêdêŋ taŋ Dawid kêtu kênac Apômtau kêtiam naŋ, Apômtau gêjô eŋ awa gebe “Ôpi ôna atom. Ômbuc ômoa êsêac dêmôêŋmuŋageŋ ma ônac êsêac aŋga gamêŋ, taŋ kêkanôŋ ka môsê kêkô naŋ. ");
INSERT INTO jae_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Ma embe ôŋô lau sêsêlêŋ ŋakicsêa aŋga ka lôlôcŋa, go ôlêti gebe êndêŋ tonaŋ Apômtau êsêlêŋ êmuŋ aôm gebe ênac Pilisti nêŋ lausiŋ.” ");
INSERT INTO jae_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Dawid gêgôm kêtôm Apômtau kêjatu eŋ ma gêjac lau Pilisti aŋga Geba e gêdêŋ Geser. ");
INSERT INTO jae_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Tonaŋ su, go Dawid kêkac Israelnêŋ laumata siŋŋa 30,000 sa kêtiam. ");
INSERT INTO jae_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Dawid gêdi gawiŋ lau samob tonaŋ gêja malac Bal-Juda gebe êkôc Anôtônê poac ŋakatapa, taŋ sêsam lausiŋ undambêŋa nêŋ Apômtau, taŋ gêŋgôŋ kerub ŋaô naŋ, nê ŋaê kêpi naŋ. ");
INSERT INTO jae_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Êsêac tetoc Anôtônê poac ŋakatapa kêkô kareta wakuc teŋ ŋaô ma sêkôc sêsa aŋga Abinadabnê andu, taŋ kêkô gamêŋ ŋabau naŋ, ma Abinadab latuagêc Usa agêc Ahio sêjam gôliŋ kareta tau. ");
INSERT INTO jae_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Usa kêsêlêŋ gêwiŋ poac ŋakatapa ma Ahio kêsêlêŋ gêmuŋ. ");
INSERT INTO jae_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Dawid to lau Israel samob têtê wê toôliŋ walôgeŋ sêmuŋ Apômtau ma sêjam wê ma sêjac gêŋ wêŋa togam ma sekoloŋ gegob ma sêjac dauc ma oŋ. ");
INSERT INTO jae_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Gêdêŋ taŋ êsêac jasêô lasê Nakonnê sêka polom ŋamala naŋ, bulimakao sêka selelec, tec Usa kêmêtôc lêma jakêpuc Anôtônê poac ŋakatapa tôŋ. ");
INSERT INTO jae_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Go Apômtau têtac ŋandaŋ gêdêŋ Usa ma gêjac eŋ gebe kêmêtôc lêma gêdêŋ Apômtaunê poac ŋakatapa. ");
INSERT INTO jae_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Dawid têtac ŋandaŋ kêtu Apômtau kêkac Usa su amboac tonaŋgeŋ, tec sêsam gamêŋ tau gebe Peres-Usa e mêŋgêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Gêdêŋ bêc tonaŋ Dawid kêtêc Apômtau ma kêsôm gebe “Apômtaunê poac ŋakatapa êndêŋ aê êmêŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Tec Dawid gedec gebe Apômtaunê poac ŋakatapa êna ênê malac, ma kêkôc katapa tau kêsô Obed-Edom aŋga malac Gat nê andu gêja. ");
INSERT INTO jae_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Amboac tonaŋ Apômtaunê poac ŋakatapa kêkô Obed-Edom nê andu aŋga malac Gat kêtôm alôŋ têlêac. Ma Apômtau gêjam mec Obed-Edom to nê gôlôac samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Ma êsêac sêsôm ŋawae gêdêŋ kiŋ Dawid ma sêsôm gebe “Apômtau gêjam mec Obed-Edom nê gôlôac to nê gêŋ samob kêtu Anôtônê poac ŋakatapaŋa”, tec Dawid gêja jakêkôc Anôtônê poac ŋakatapa totêtac ŋajamgeŋ aŋga Obed-Edom nê andu gêmêŋ taunê malac. ");
INSERT INTO jae_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Gêdêŋ taŋ lau sêbalaŋ katapa sa ma sêu eŋkaiŋ sêsêlêŋ kêtu dim 6 naŋ, Dawid kêkêŋ bulimakao kapoac teŋ ma domba toŋalêsi teŋ kêtu da. ");
INSERT INTO jae_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Ma Dawid kêtê wê to nê ŋalêlôm samucgeŋ gêmuŋ Apômtau. Eŋ kêjandiŋ obo dabuŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Dawid to lau Israel samob sêkôc Apômtaunê poac ŋakatapa sêmêŋ ŋalêŋ amboac tonaŋ sêjam lasê to sêjac dauc kêtaŋ toôndugeŋ. ");
INSERT INTO jae_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Gêdêŋ taŋ Apômtaunê poac ŋakatapa mêŋgêô lasê Dawidnê malac naŋ, Saul latuo Mikal gêjam tuc kêsa katam sauŋ ma gêlic kiŋ Dawid kêtê wê gêboaŋ-gêboaŋ gêmuŋ Apômtau, tec eŋ kêpêc gêdô eŋ gêc lêlômgeŋ. ");
INSERT INTO jae_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Sêkôc Apômtau nê poac ŋakatapa mêŋsêsô becobo, taŋ Dawid gê naŋ, ma tetoc kakô ŋamala. Ma Dawid kêkêŋ daja to dawama gêdêŋ Apômtau. ");
INSERT INTO jae_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Kêkêŋ daja to dawama tonaŋ su acgom, go gêjam mec lau gêjam Apômtau, lausiŋ undambêŋa nêŋ Anôtô laŋô, ");
INSERT INTO jae_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","gocgo kêsôm ŋabiŋ ma sêjac sam polom teŋ ma bôc ŋagêdô teŋ ma polom ŋakana teŋ gêdêŋ lau Israel nêŋ lauo to ŋac kêtômgeŋ. Su, go lau samob sec êliŋ-êliŋ sêmu sêja nêŋ gamêŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Dawid gêmu gêja nê andu amboac tonaŋgeŋ gebe ênam mec nê gôlôac. Go Saul latuo Mikal kapuc eŋ tôŋ-tôŋ ma kêsôm gebe “Ocsalô tonec Israelnêŋ kiŋ kêwaka tau sa ŋajamanô. Eŋ kêsêlêŋ toôli ŋaômageŋ gêmoa nê sakiŋwaganêŋ sakiŋwagao ŋalêlôm tomaja gêbacgeŋ kêtôm ŋac ŋaôma teŋ.” ");
INSERT INTO jae_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Dawid gêjô Mikal awa gebe “Aê katê wê gebe jatoc Apômtau sa. Eŋ kêjaliŋ aê sa gajô aôm tamam ma gajô ênê gôlôac samob. Eŋ kêkêŋ aê katu ênê lau Israel nêŋ kiŋ. Aê oc jatê wê to jatoc Apômtau sa jamoa. ");
INSERT INTO jae_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Ma aê oc jakôniŋ tauc êlêlêc galocŋa e jalic tauc amboac geŋ ŋaôma. Mago ŋapalêo, taŋ aôm kôsôm biŋ kêpi êsêac naŋ, oc tetoc aê sa.” ");
INSERT INTO jae_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Ma Saul latuo Mikal kêkôc ŋapalê teŋ atom e gêmac êndu. ");
INSERT INTO jae_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Gêdêŋ taŋ Apômtau kêkêŋ kiŋnê ŋacjo sêsô eŋ ŋalabu naŋ, kiŋ tau kêlêwaŋ tau gêŋgôŋ nê andu. ");
INSERT INTO jae_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ma kiŋ kêsôm gêdêŋ propete Natan gebe “Ôlic acgom, galoc aê gaŋgôŋ andu kaseda tonec, mago Anôtônê poac ŋakatapa kêkô becobogeŋ.” ");
INSERT INTO jae_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Ma Natan kêsôm gêdêŋ kiŋ gebe “Ŋajam, ôna ma ôŋgôm gêŋ samob, taŋ gêc nêm ŋalêlôm naŋ, ŋanô êsa gebe Apômtau gêwiŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Mago gêdêŋ gêbêc tonaŋgeŋ Apômtau gêsuŋ biŋ gêdêŋ Natan ma kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Ôna ma ôsôm êndêŋ ŋoc sakiŋwaga Dawid gebe ‘Apômtau kêsôm amboac tonec gebe Aôm gobe ôkwê andu teŋ êtu aê jaŋgôŋŋa me. ");
INSERT INTO jae_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Gêdêŋ taŋ aê gawê lau Israel aŋga Aiguptu sêpi sêmêŋ e mêŋgêdêŋ galoc naŋ, aê gaŋgôŋ andu teŋ ŋalêlôm atomanô. Aê gajac laoc gamêŋgeŋ ma gaŋgôŋ becobogeŋ kêtu ŋoc andu. ");
INSERT INTO jae_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Amboac ondoc gêdêŋ ŋasawa samob, taŋ gajac laoc gamêŋ gawiŋ lau Israel naŋ, aê kasôm biŋ teŋ gêdêŋ Israelnêŋ gôliŋwaga, taŋ kajatu êsêac gebe sejop ŋoc lau Israel naŋ, nêŋ teŋ gebe Amac akwê andu kasedaŋa teŋ êtu aêŋa atom, kasôm me masi.’ ");
INSERT INTO jae_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Ma galoc aôm ôsôm êndêŋ ŋoc sakiŋwaga Dawid gebe Lausiŋ undambêŋa nêŋ Apômtau kêsôm gebe ‘Aôm gojob domba gômoa gamêŋ wale-wale, tec aê kakôc aôm su gebe ôtu ŋoc lau Israel nêŋ gôliŋwaga. ");
INSERT INTO jae_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Ma aê gamoa gawiŋ aôm aŋga gamêŋ samob, taŋ kôsêlêŋ kôsa naŋ, ma gaseŋ nêm ŋacjo samob su gamuŋ aôm ma gabe jakêŋ aômnêm ŋaê êtu kapôêŋ êtôm lau kapôêŋ nomŋa nêŋ. ");
INSERT INTO jae_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Ma aê jajaliŋ gamêŋ teŋ sa êtu ŋoc lau Israelŋa ma oc jasê êsêac sêsêp gebe êtu êsêacnêŋ gamêŋ sêŋgôŋŋa ma ŋacjo sêlênsôŋ êsêac êtiam atom, ma lau ŋaclai sec sêkôniŋ êsêac êtôm sêgôm gêdêŋ gêmuŋŋa êtiam atom. ");
INSERT INTO jae_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","Sêgôm gêdêŋ taŋ aê kakêŋ gôliŋwaga sêjam gôliŋ ŋoc lau Israel naŋ. Aê oc jakêŋ nêm ŋacjo sêsô aôm ŋalabu ma ôŋgôŋ tomalô. Apômtau gêjac mata gêdêŋ aôm gebe eŋ tau oc êmboa nêm gôlôac sa. ");
INSERT INTO jae_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Nêm têm embe êmbacnê ma ônêc nêm bêc ôwiŋ tamami, naŋ oc jakêŋ latôm, taŋ mêŋêsa aŋga aôm naŋ, êjô aôm su, ma oc janac dabiŋ ênê gamêŋ kiŋŋa. ");
INSERT INTO jae_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Eŋ oc êkwê andu teŋ êtu ŋoc ŋaêŋa ma jakêŋ ênê lêpôŋ kiŋŋa êkô endeŋ tôŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Aê oc jatu eŋ tama ma eŋ êtu aê latuc. Eŋ embe êŋgôm sec aê oc jamêtôc eŋ êtôm tama teŋ kêmêtôc latu. ");
INSERT INTO jae_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Mago aê oc jakôc ŋoc moasiŋ su aŋga ênê êtôm kakôc su aŋga Saul, taŋ katu kiŋ gêmuŋ aôm naŋ atom. ");
INSERT INTO jae_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Tageŋ aômnêm gôlôac to nêm gôliŋ kiŋŋa êmoa aê laŋôcnêmŋa teŋgeŋ ma teŋgeŋ. Ma nêm lêpôŋ kiŋŋa êkô endeŋ tôŋgeŋ.’” ");
INSERT INTO jae_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Natan kêsôm biŋ samob, taŋ Anôtô geoc lasê gêdêŋ eŋ naŋ gêdêŋ Dawid. ");
INSERT INTO jae_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Go kiŋ Dawid kêsô lômbec jagêŋgôŋ Apômtau laŋônêmŋa ma keteŋ mec gebe “O Apômtau Anôtô, aê asa ma ŋoc gôlôac asa tec gôwê aê e mêŋgêdêŋ tonec. ");
INSERT INTO jae_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Mago moasiŋ tonaŋ, aôm Apômtau Anôtô, gôlic amboac kêtôm su atom, tec kôsôm biŋ, taŋ oc mêŋêsa êtu ŋamu naŋ, kêpi nêm sakiŋwaganê gôlôac gêwiŋ. O Apômtau Anôtô, aôm kôtôc gôlôac to gôlôac, taŋ ocgo mêŋsêsa naŋ gêdêŋ aê. ");
INSERT INTO jae_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","O Apômtau Anôtô, aê oc jasôm asageŋ êwiŋ. Aôm taôm kôjala nêm sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Aôm gôgôm gêŋsêga samob tonaŋ ŋai kêtu biŋ, taŋ gôjac mata naŋ, ma katu nêm ŋalêlôm kêkac aômŋa gebe ôsôm gêŋ tau lasê êndêŋ nêm sakiŋwaga aê jajala. ");
INSERT INTO jae_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","O Apômtau Anôtô, aôm ŋac kapôêŋanô ma teŋ kêtôm aôm gêmoa atom. Anôtô teŋ gêmoa atom, aôm taômgeŋ, kêtôm biŋ samob, taŋ aêac aŋô kêsô aêac taŋeŋsuŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Ma lau nomŋa ondoc têtôm aômnêm lau Israel, taŋ anôtô teŋ gêjam êsêac kêsi gebe têtu ênê lau naŋ, ma êwaka taunê ŋaê sa to êŋgôm gêŋsêga to gêŋtalô êtu êsêacŋa. Ma êtiŋ lau to nêŋ anôtôi jaba su êmuŋ nê lau. ");
INSERT INTO jae_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Mago aôm kôkêŋ lau Israel têtu nêm lau gedeŋ tôŋgeŋ ma aôm, Apômtau, kôtu êsêacnêŋ Anôtô. ");
INSERT INTO jae_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","“O Apômtau Anôtô, galoc ôkêŋ biŋ, taŋ gôjac mata kêpi nêm sakiŋwaga to nê gôlôac naŋ, êtu tôŋ endeŋ tôŋgeŋ, ma ôŋgôm gêŋ, taŋ kôsôm naŋ ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","Go aômnêm ŋaê oc êtu kapôêŋ endeŋ tôŋgeŋ ma sêsôm gebe ‘Lausiŋ undambêŋa nêŋ Apômtau katu Israel nêŋ Anôtô.’ Ma nêm sakiŋwaga Dawid nê gôlôac sêmoa aôm laŋômnêmŋageŋ. ");
INSERT INTO jae_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","Gebe aôm, lausiŋ undambêŋa nêŋ Apômtau, Israelnêŋ Anôtô, goc biŋ lasê gêdêŋ nêm sakiŋwaga ma kôsôm gebe ‘Aê oc jamboa nêm gôlôac sa’, tec nêm sakiŋwaga aê têtac kêpa su e kateŋ mec tonec gêdêŋ aôm. ");
INSERT INTO jae_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","“Ma galoc, o Apômtau Anôtô, aôm taômgeŋ Anôtô ma nêm biŋ kêtu biŋŋanô. Aôm gôjac mata biŋ ŋajamanô tonec gêdêŋ nêm sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Amboac tonaŋ ôlic ŋajam ma ônam mec nêm sakiŋwaga nê gôlôac gebe sêmoa aôm laŋômnêmŋa endeŋ tôŋgeŋ, gebe aôm Apômtau Anôtô kôsôm biŋ tau ma nêm mec êpi nêm sakiŋwaga nê gôlôac endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Ma Dawid kêtu kênac gebe “Saulnê gôlôac nêŋ teŋ gêmoa gebe jamoasiŋ eŋ êtu Jonatanŋa me masi.” ");
INSERT INTO jae_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Saulnê gôlôac ŋasakiŋwaga teŋ gêmoa, nê ŋaê Siba. Êsêac sêmôêc eŋ gêdêŋ Dawid gêmêŋ. Ma kiŋ tau kêtu kênac eŋ gebe “Aôm Siba me.” Ma eŋ gêjô kiŋ awa gebe “Nêm sakiŋwaga tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Ma kiŋ kêsôm gebe “Saulnê gôlôac nêŋ teŋ gêmoa gebe jatôc Anôtônê moasiŋ êndêŋ eŋ me masi.” Go Siba gêjô kiŋ awa gebe “Jonatannê latu teŋ tec gêmoa. Eŋ akaiŋ lulugeŋ kêtu palê gêŋgôŋ.” ");
INSERT INTO jae_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Kiŋ kêsôm gêdêŋ eŋ gebe “Eŋ gêmoa ondoc.” Ma Siba gajô kiŋ awa gebe “Eŋ gêŋgôŋ Amiel latu Makir nê andu aŋga malac Lodabar.” ");
INSERT INTO jae_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Go kiŋ Dawid kêsakiŋ lau jasêkôc eŋ aŋga Amiel latu Makir nê andu aŋga Lodabar sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Ma Saul latu Jonatan nê latu Mepiboset gêdêŋ Dawid gêmêŋ ma gêu tau jagêc eŋ laŋônêm ma ketoc eŋ sa. Ma Dawid kêsôm gebe “Mepiboset”. Ma eŋ gêjô awa gebe “Aec, nêm sakiŋwaga aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Dawid kêsôm gêdêŋ eŋ gebe “Ôtêc taôm atom gebe aê gabe jamoasiŋ aôm êtu tamam Jonatanŋa. Ma aê oc jakêŋ dêbôm Saulnê nom samob endeŋ aôm êtiam. Ma aôm oc ôniŋ gêŋ aŋga aêŋoc tebo ŋapaŋ.” ");
INSERT INTO jae_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Ma Mepiboset kêpôŋ aduc ma kêsôm gebe “Nêm sakiŋwaga aê asa tec gobe ônam jaom aê, taŋ katôm kêam ŋamatê teŋ naŋ.” ");
INSERT INTO jae_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Go kiŋ gêmôêc sakiŋwaga Siba ma kêsôm gêdêŋ eŋ gebe “Saulnê gêŋ samob to nê gôlôacnêŋ gêŋlênsêm samob aê kakêŋ gêdêŋ nêm ŋatau latu. ");
INSERT INTO jae_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Aôm to nêm latômi ma nêm sakiŋwaga anam kôm êtu eŋŋa ma akôc ŋanô amêŋ gebe nêm ŋatau nê gôlôac têtap nêŋ gêŋ sêniŋŋa sa, mago nêm ŋatau latu Mepiboset oc êniŋ gêŋ aŋga aêŋoc tebo ŋapaŋ.” Siba latui 15 ma nê sakiŋwaga 20 sêmoa. ");
INSERT INTO jae_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Go Siba kêsôm gêdêŋ kiŋ gebe “Nêm sakiŋwaga oc êŋgôm gêŋ samob, taŋ ŋoc apômtau kiŋ kêjatu naŋ.” Amboac tonaŋ Mepiboset geŋ gêŋ aŋga Dawidnê tebo kêtôm kiŋnê latui nêŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mepiboset latu sauŋ teŋ gêmoa, ênê ŋaê Mika. Ma samob, taŋ sêŋgôŋ Sibanê andu naŋ, têtu Mepibosetnê sakiŋwaga. ");
INSERT INTO jae_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Amboac tonaŋ Mepiboset gêŋgôŋ Jerusalem gebe eŋ geŋ gêŋ aŋga kiŋnê tebo ŋapaŋ. Ma eŋ akaiŋ lulugeŋ kêtu palê. ");
INSERT INTO jae_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Ockêsa kêdabiŋ, kiŋnêŋ têm sênac siŋŋa mêŋkêsa. Tec Dawid kêsakiŋ Joab to nê sakiŋwaga ma lau Israel samob jaseseŋ lau Amon nêŋ nom su ma sêgi malac Raba auc. Mago Dawid gacgeŋ gêmoa Jerusalem. ");
INSERT INTO jae_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Ŋakêtula teŋ Dawid gadi aŋga nê mê ma kêsêlêŋ gêmoa nê andu ŋasalôm tapa-tapa ŋaô. Gêdêŋ tonaŋ Dawid gêlic awê teŋ gêliŋ bu. Ma awê tau ŋajamanô. ");
INSERT INTO jae_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Tec Dawid kêsakiŋ lau gebe têtu kênac awê tonaŋ nê ŋam. Ma ŋac teŋ gêwa sa gêdêŋ eŋ gebe “Eŋ Eliam latuo Batseba, ŋac Hetŋa Uria nê awê.” ");
INSERT INTO jae_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Go Dawid kêsakiŋ lau gebe sêkôc eŋ sêmêŋ. Tec sêkôc eŋ dêdêŋ Dawid sêja ma eŋ gêc gêwiŋ eŋ. Gêdêŋ tonaŋ awê tau gêliŋ buseŋom su ma kêtu selec. Go gêmu gêja nê andu kêtiam. ");
INSERT INTO jae_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Awê tau taê, tec kêsakiŋ biŋ ma kêsôm gêdêŋ Dawid gebe “Aê taêc tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Amboac tonaŋ Dawid kêsakiŋ biŋ gêdêŋ Joab gebe “Ôsakiŋ ŋac Hetŋa Uria êndêŋ aê êmêŋ.” Ma Joab kêsakiŋ eŋ gêja. ");
INSERT INTO jae_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Gêdêŋ taŋ Uria mêŋgêô lasê gedeŋ Dawid naŋ, Dawid tau kêtu kênac eŋ gebe “Joab gêgôm asageŋ ma lau samob sêmoa ŋajam me masi. Ma siŋ ŋabiŋ amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Su, go Dawid kêsôm gêdêŋ Uria gebe “Ôna nêm andu ma ôkwasiŋ amkaiŋ.” Uria kêsa aŋga kiŋnê andu gêja, go kiŋ kêsakiŋ moasiŋ teŋ kêdaguc eŋ. ");
INSERT INTO jae_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Mago Uria gêja nê andu atom. Eŋ gêwiŋ nê ŋataunê sakiŋwaga ŋagêdô gêc bêc gêc kiŋnê andu ŋasacgêdô. ");
INSERT INTO jae_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Êsêac sêjac miŋ biŋ tau gêdêŋ Dawid ma sêsôm gebe “Uria gêja nê andu atom.” Tec Dawid kêtu kênac Uria gebe “Aôm kôsêlêŋ intêna baliŋ. Kêtu asageŋŋa gôja nêm andu atom.” ");
INSERT INTO jae_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Tageŋ Uria gêjô Dawidnê biŋ gebe “Poac ŋakatapa ma lau Israel to Juda sêŋgôŋ becobo ma ŋoc ŋatau Joab to ŋoc ŋataunê sakiŋwaga samob sêsa jasêc awêgeŋ ma aê najaŋgôŋ ŋoc andu, janiŋ to janôm gêŋ ma janêc jawiŋ ŋoc awê me. Aê jatôc lemoc ma jasôm êtu tôŋ gebe aê oc jaŋgôm gêŋ amboac tonaŋ atomanô.” ");
INSERT INTO jae_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Go Dawid kêsôm gêdêŋ Uria gebe “Amboac tonaŋ ômoa ocsalô tonec êwiŋ ma eleŋ oc jawi aôm siŋ ômu ôna.” Amboac tonaŋ Uria gêmoa Jerusalem bêc tonaŋ ma ŋageleŋ gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Dawid keteŋ eŋ gebe êniŋ to ênôm gêŋ êwiŋ eŋ ma gêgôm e gêŋ kêjaŋiŋ eŋ. Mago gêdêŋ gêbêc eŋ gêja nê andu atom, eŋ gêc bêc gêc nê mê gêwiŋ nê ŋataunê sakiŋwaga aŋga andu ŋasacgêdô. ");
INSERT INTO jae_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Gêdêŋ bêbêcgeŋ Dawid keto papia teŋ gêdêŋ Joab ma Uria kêkôc papia tau gêja. ");
INSERT INTO jae_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Ma eŋ keto biŋ tonec gêc papia tau gebe “Ôkêŋ Uria êkô siŋmata, go ataiŋ taôm su gebe ŋacjo sênac eŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Tec gêdêŋ taŋ Joab kêgi malac tau auc naŋ, eŋ kêkêŋ Uria kêkô ŋasawa, taŋ eŋ kêjala gebe lau ŋactêkwa ŋanô sêkô naŋ. ");
INSERT INTO jae_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ma lau malacŋa sêsa jasêjac siŋ gêdêŋ Joab. Gêdêŋ tonaŋ sêjac Dawidnê sakiŋwaga ŋagêdô êndu. Ma ŋac Hetŋa Uria gêmac êndu amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Go Joab kêsakiŋ biŋ ma gêjac miŋ siŋ ŋabiŋ gêdêŋ Dawid. ");
INSERT INTO jae_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Ma eŋ gêjac biŋsu ŋac jaeŋŋa gebe “Êndêŋ taŋ ônac miŋ biŋ siŋŋa êndêŋ kiŋ su naŋ, ");
INSERT INTO jae_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","kiŋ embe têtac ŋandaŋ êsa ma êsôm êndêŋ aôm gebe ‘Kêtu asageŋŋa amac atu gasuc jaadabiŋ malac gebe anac siŋ. Amac ajala gebe sêkô tuŋbôm ŋaô ma oc sêpê amac nec atom me. ");
INSERT INTO jae_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Asa gêjac. Jerubeset latu Abimelek êndu. Awê teŋ kêkôc poc sêlêsa polomŋa teŋ ma kêkô tuŋbôm ŋaô, go kêbaliŋ jakêtuc eŋ êndu aŋga Tebes. Kêtu asageŋŋa amac atu gasuc jaadabiŋ tuŋbôm amboac tonaŋ.’ Kiŋ embe êtu kênac biŋ amboac tonaŋ, go ôsôm êndêŋ eŋ gebe ‘Nêm sakiŋwaga ŋac Hetŋa Uria gêmac êndu amboac tonaŋgeŋ.’” ");
INSERT INTO jae_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Amboac tonaŋ ŋac jaeŋŋa jagêjac miŋ biŋ samob, taŋ Joab kasakiŋ eŋ gebe êsôm naŋ, êndêŋ Dawid. ");
INSERT INTO jae_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Ŋac jaeŋŋa kêsôm gêdêŋ Dawid gebe “Lau tônê sêlêlêc aêac ma sêsa aŋga malac sêmêŋ gebe sênac aêac aŋga awêŋa. Go aêac ajac êsêac ma alêsuc êsêac dêdêŋ malac ŋasacgêdô sêja. ");
INSERT INTO jae_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Go lau talamŋa sêkô tuŋbôm ŋaô ma sêpê nêm sakiŋwaga ŋagêdô êndu. Nêm sakiŋwaga ŋac Hetŋa Uria gêmac êndu amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Go Dawid kêsôm gêdêŋ ŋac jaeŋŋa gebe “Ônac Joab têtac tôŋ ŋa biŋ tonec gebe ‘Biŋ tonaŋ êkêŋ wapac aôm êlêlêc su atom, gebe siŋ geseŋ ŋac teŋ galoc ma teŋ oc êndêŋ ŋasawa teŋ. Ônac siŋ ŋajaŋa êndêŋ malac tau e ôku tulu su.’” ");
INSERT INTO jae_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Gêdêŋ taŋ Urianê awê gêŋô ŋawae gebe nê akweŋ Uria gêmac êndu naŋ, eŋ kêtaŋ taŋiboa kêtu nê akweŋŋa. ");
INSERT INTO jae_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Gêdêŋ taŋ kêkac abec su naŋ, Dawid kêsakiŋ ŋac teŋ jakêkôc Batseba gêmêŋ ênê andu ma gêjam eŋ kêtu nê awê ma awê tau kêkôc ênê latu teŋ. Mago gêŋ, taŋ Dawid gêgôm naŋ, gêjac Apômtau mataanô ŋajam atom. ");
INSERT INTO jae_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Ma Apômtau kêsakiŋ propete Natan gêdêŋ Dawid gêja. Eŋ gêô lasê ma kêsôm gêdêŋ Dawid gebe “Ŋac luagêc sêmoa malac teŋ. Teŋ ŋac tolêlôm ma teŋ ŋac ŋalêlôm sawa. ");
INSERT INTO jae_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Ŋac tolêlôm nê domba to bulimakao taêsam ŋasec. ");
INSERT INTO jae_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Mago ŋac ŋalêlôm sawa nê gêŋ masi, domba ŋalatu têna tageŋgeŋ, taŋ eŋ gêjam ôli. Ma eŋ gêlôm nê gêŋ e kêtu kapôêŋ gêwiŋ eŋ to nê ŋapalêo to ŋac. Agêc seŋ to sênôm gaeŋ kêsêp tageŋ ma gêc bêc gêsac eŋ labum ma ŋatau gêlic eŋ kêtôm latuo teŋ. ");
INSERT INTO jae_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Bêc teŋ ŋacleŋ teŋ mêŋgêô lasê gêdêŋ ŋac tolêlôm. Ma ŋac tau gedec gebe êkôc taunê domba me bulimakao nêŋ teŋ gebe êmansaŋ êtu ŋacleŋ, taŋ jagêô lasê gêdêŋ eŋ naŋŋa. Mago eŋ kêkôc ŋac ŋalêlôm sawa nê domba tageŋgeŋ su ma kêmasaŋ kêtu ŋacleŋ, taŋ gêmêŋ gêdêŋ eŋ naŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Go Dawid têtac ŋandaŋ ŋanô gêdêŋ ŋac tonaŋ ma kêsôm gêdêŋ Natan gebe “Aê jatôc lemoc êndêŋ Apômtau mata jali gebe ŋac, taŋ gêgôm gêŋ amboac tonaŋ naŋ ênaŋa. ");
INSERT INTO jae_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Ma eŋ oc êjô domba tonaŋ êtu dim aclê, gebe gêgôm gêŋ amboac tonaŋ ma taê walô ŋagec gêc eŋŋa atom.” ");
INSERT INTO jae_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Natan kêsôm gêdêŋ Dawid gebe “Ŋac tau aôm taômgoc. Apômtau, lau Israel nêŋ Anôtô, kêsôm amboac tonec gebe ‘Aê gaeŋ oso aôm kôtu lau Israel nêŋ kiŋ ma gajam aôm sa aŋga Saul lêma. ");
INSERT INTO jae_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Ma kakêŋ nêm ŋataunê andu gêdêŋ aôm gôwê kaiŋ ma ênê lauo toôŋgeŋ wacsêŋgôŋ aôm labômm ŋaô to kakêŋ gôlôac Israel to Juda dêdêŋ aôm. Ma embe tonaŋ êtôm atom naŋgo jakêŋ gêŋ ŋagêdô wacênsac ŋaô. ");
INSERT INTO jae_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Aôm laŋôm gelo Apômtaunê biŋ ma gôgôm gêŋ sec, taŋ gêjac matocanô ŋajam atom naŋ, kêtu asageŋŋa. Aôm gôjac ŋac Hetŋa Uria ŋa siŋ êndu ma gôjam ênê awê kêtu nêm awê. Aôm gôjac eŋ ŋa lau Amon nêŋ siŋ êndu. ");
INSERT INTO jae_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Amboac tonaŋ siŋ tau oc êwê nêm wakuc siŋ atomanô gebe laŋôm gelo aê ma kôkôc ŋac Hetŋa Uria nê awê su gebe êtu aômnêm awê.’ ");
INSERT INTO jae_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Tec Apômtau kêsôm gebe ‘Ôlic acgom, aê oc jakalem gêŋwapac êpi aôm aŋga aôm taômnêm gôlôac nêŋ. Ma oc jakôc aômnêm lauo su ma jakêŋ êndêŋ nêm ŋac wacbaŋ aôm ma eŋ oc ênêc êwiŋ nêm lauo ênêc awêgeŋ êndêŋ oc êkôgeŋ. ");
INSERT INTO jae_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Gebe aôm gôgôm gêŋ tau kelecgeŋ, mago aê oc jaŋgôm gêŋ tonaŋ êndêŋ lau Israel samob sêlic êndêŋ ocsalô.’” ");
INSERT INTO jae_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Go Dawid kêsôm gêdêŋ Natan gebe “Aê gagôm sec gêdêŋ Apômtau.” Natan gêjô Dawid awa gebe “Amboac tonaŋ Apômtau kêsuc nêm sec ôkwi, aôm oc ômac êndu atom. ");
INSERT INTO jae_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Mago kôsu Apômtau susu ŋa biŋ tonaŋ, tec nêm ŋapalê, taŋ têna êkôc eŋ naŋ, oc êmac êndu.” ");
INSERT INTO jae_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Go Natan gêmu gêja nê andu. Ma Apômtau gêjac Dawidnê ŋapalê, taŋ Urianê awê kêkôc naŋ, e gêmac gêgôm eŋ. ");
INSERT INTO jae_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Amboac tonaŋ Dawid keteŋ Apômtau kêtu ŋapalêŋa ma gajam dabuŋ mo ma kasô nê balêm gaja jagêc nom kêtôm gêbêc samob. ");
INSERT INTO jae_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Ma ana laumata sêkô sêwiŋ eŋ sebe sêsuŋ eŋ sa, mago eŋ gedec ma geŋ gêŋ gawiŋ êsêac atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Gêdêŋ bêc kêtu 7ŋa ŋapalê tau gêmac andu. Ma Dawidnê sakiŋwaga têtêc gebe sêsôm ŋapalê gêmac endu ŋawae êndêŋ eŋ. Êsêac taeŋ gêjam gebe “Gêdêŋ taŋ ŋapalê gêmoa mata jaligeŋ naŋ, aêac tasôm biŋ gêdêŋ eŋ, mago kêkêŋ taŋa aêac atom. Aêac tasôm ŋapalê gêmac êndu su ŋawae lasê êndêŋ eŋ amboac ondoc. Oc moae eŋ êŋgôm tau paliŋ.” ");
INSERT INTO jae_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Mago gêdêŋ taŋ Dawid gêlic êsêac sêjac biŋ kesec-kesec gêdêŋ tauŋ naŋ, eŋ kêjala gebe ŋapalê gêmac êndu su ma kêtu kênac nê sakiŋwaga gebe “Ŋapalê gêmac êndu me.” Êsêac sêjô eŋ awa gebe “Aec, gêmac êndu.” ");
INSERT INTO jae_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Go Dawid gêdi sa aŋga nom ma gêliŋ bu to geŋ oso ôli ma kêsô ŋakwê teŋ. Go kêsô Apômtaunê lômbec jaketeŋ mec. Su, go gêmu gêja taunê andu ma keteŋ gêŋ taniŋŋa. Tec sêkôc gêŋ dêdêŋ eŋ jageŋ. ");
INSERT INTO jae_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Ma ênê sakiŋwaga sêsôm gêdêŋ eŋ gebe “Gôgôm amboac tonaŋ ŋam amboac ondoc. Ŋapalê mata jali gêmoa ma gôjam dabuŋ mo to kôtaŋ ŋanô kêtu eŋŋa. Ma gêdêŋ taŋ ŋapalê gêmac êndu su naŋ, gôdi sa ma goeŋ gêŋ.” ");
INSERT INTO jae_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Ma eŋ gêjô êsêac aweŋ gebe “Gêdêŋ taŋ ŋapalê mata jali gêmoa naŋ, aê gajam dabuŋ mo to kataŋ taŋiboa gebe taêc gêjam amboac tonec gebe ‘Asa kêjala Apômtau, oc moae taê walô aê ma êkêŋ ŋapalê êmoa mata jali.’ ");
INSERT INTO jae_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Galoc gêmac êndu su, tec janam dabuŋ mo êtu ageŋŋa. Oc jakôc eŋ êmu êmêŋ êtiam me. Aê oc jandêŋ eŋ jana, mago eŋ oc êmu êndêŋ aê êtiam atomanô.” ");
INSERT INTO jae_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Go Dawid gêjam malô nê awê Batseba ma kêsô jagêc gêwiŋ eŋ. Ma eŋ kêkôc ŋapalê ŋac teŋ ma gê ênê ŋaê gebe Salomo. Ma Apômtau têtac gêwiŋ eŋ ");
INSERT INTO jae_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","ma kêsakiŋ propete Natan gebe ê ênê ŋaê gebe Jedidia (ŋam gebe Anôtô têtac gêwiŋ) kêtu Apômtauŋa. ");
INSERT INTO jae_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Go kiŋ kêsôm gêdêŋ Joab gebe “Gôlicgac, aê jakêŋ êwiŋ nêm biŋ, taŋ koteŋ naŋ. Naôkôc ŋac wakuc Absalom êmu êmêŋ êtiam.” ");
INSERT INTO jae_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Ma Joab gêu tau laŋôanô gêdêŋ nom ma ketoc kiŋ sa to gêjam mec eŋ. Ma Joab kêsôm gebe “Ocsalô nêm sakiŋwaga aê kajala gebe ŋoc ŋatau kiŋ gêlic aê gajac mataanô ŋajam ma kiŋ tau gêlôc kêtu biŋ, taŋ kateŋ naŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Amboac tonaŋ Joab gêdi gêja Gesur ma kêkôc Absalom gêmu gêmêŋ Jerusalem kêtiam. ");
INSERT INTO jae_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Ma kiŋ tau kêsôm gebe “Eŋ êŋgôŋ taunê andu ma êmoa tauŋa. Eŋ êmêŋ êkô aê laŋôcnêmŋa atom.” Tec Absalom gêmoa nê tauŋa gêŋgôŋ ênê andu ma jakêkô kiŋ laŋônêmŋa atom. ");
INSERT INTO jae_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Ŋac laŋôêjam teŋ kêtôm Absalom gêmoa Israel ŋalêlôm atom. Laŋôanô latu-latu ma ôli ŋageo gêc atomanô. ");
INSERT INTO jae_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Gêdêŋ taŋ jala gêjac pep naŋ, eŋ kêkapiŋ nê môkêlauŋ gebe môkêlauŋ ŋawapac kêsa. Ma kêkêŋ môkêlauŋ kêpi dôŋ ma gêlic ŋawapac kêtôm kiŋnê dôŋ kilo 2. ");
INSERT INTO jae_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Ma Absalomnê latui têlêac ma latuo tageŋ, ŋaê Tamar. Awê tonaŋ awê êjam ŋanô. ");
INSERT INTO jae_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Amboac tonaŋ Absalom gêmoa Jerusalem jala samuc luagêc ma kêsa kiŋ laŋônêm ŋagec atomanô. ");
INSERT INTO jae_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Go Absalom kêsakiŋ biŋ gêdêŋ Joab gebe êmêŋ ma Absalom êsakiŋ eŋ êndêŋ kiŋ êna. Mago Joab gedec ma gêja atom. Ma eŋ kasakiŋ biŋ kêtiam kêtu luagêcŋa, mago Joab gêja atom. ");
INSERT INTO jae_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Tec eŋ kêsôm gêdêŋ nê sakiŋwaga gebe “Alic acgom, Joabnê kôm gêc kêsi aêŋoc kôm ma eŋ kêsê polom kêkô tonaŋ. Ana ma akêŋ ja êniŋ kôm tau.” Amboac tonaŋ Absalomnê sakiŋwaga sêkêŋ ja geŋ kôm tau. ");
INSERT INTO jae_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Go Joab gêdi gêdêŋ Absalom nê andu gêja ma kêsôm gêdêŋ eŋ gebe “Aômnêm sakiŋwaga sêkêŋ ja geŋ aêŋoc kôm kêtu ageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Absalom gêjô Joab awa gebe “Gôlicgac me, aê kasakiŋ biŋ gêdêŋ aôm gebe Ômôêŋ gebe jasakiŋ aôm ôndêŋ kiŋ ôna ma ôtu kênac eŋ gebe ‘Aê gamu gamêŋ aŋga Gesur kêtu ageŋŋa. Aê gacgeŋ jamoa tônêmaŋ oc ŋajam êlêlêc. Amboac tonaŋ ôlôc gebe najakô kiŋ laŋônêmŋa ma embe jawê kaiŋ biŋ teŋ, go eŋ ênac aê êndumaŋ.’” ");
INSERT INTO jae_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Go Joab gêdêŋ kiŋ gêja ma gêjac miŋ biŋ gêdêŋ eŋ. Ma kiŋ gêmôêc Absalom. Amboac tonaŋ eŋ gêdêŋ kiŋ tau gêja ma gewec laŋôanô kêsêp nom gêc kiŋ laŋônêmŋa. Ma kiŋ kêlêsôp Absalom alianô. ");
INSERT INTO jae_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Tonaŋ su, go Absalom gêjam ôli kareta to hos ma kêkôc lau 50 gebe sêlêti sêmuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Kêtôm têm samob Absalom gêdi gêdêŋ bêbêcgeŋ jakêkô intêna kêsi malac ŋasacgêdôŋa. Ma elêmê ŋac teŋ embe êmêŋ gebe êlic kiŋ êtu êmêtôc ênê biŋ ŋasawaŋa, naŋ Absalom oc êmôêc eŋ ma êtu kênac gebe “Aôm aŋga malac ondoc.” Ma eŋ embe êjô eŋ awa gebe “Nêm sakiŋwaga aê aŋga Israelnêŋ toŋ teŋ”, ");
INSERT INTO jae_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","go Absalom oc êsôm êndêŋ eŋ gebe “Ôlic acgom, nêm biŋ ŋajam to gêdêŋ, mago kiŋnê ŋac gebe êŋô aômnêm biŋŋa gêmoa atom.” ");
INSERT INTO jae_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Ma Absalom kêsôm gêwiŋ gebe “Oe, sêkêŋ aê jatu ŋacmêtôc aŋga gamêŋ tonecmaŋ, go lau samob, taŋ nêŋ biŋ ênêc naŋ, dêndêŋ aê sêmêŋ ma jamêtôc nêŋ biŋ naêndêŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Ma ŋac teŋ embe êndambiŋ gebe êpôŋ aduc êndêŋ eŋ, go Absalom êmêtôc lêma ma êkam eŋ sa to êlêsôp eŋ alianô. ");
INSERT INTO jae_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Absalom gêgôm amboac tonaŋ gêdêŋ lau Israel samob, taŋ sêmêŋ gebe kiŋ êmêtôc êsêacnêŋ biŋ naŋ, ma gêjam lau Israel nêŋ ŋalêlôm ôkwi gêdêŋ eŋ tau. ");
INSERT INTO jae_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Jala aclê gêjaŋa, go Absalom kêsôm gêdêŋ kiŋ gebe “Aê jateŋ aôm gebe ôlôc gebe jana Hebron ma jaŋgôm biŋ, taŋ gajac mata gêdêŋ Apômtau naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Gêdêŋ taŋ gaŋgôŋ Gesur Aram naŋ, nêm sakiŋwaga gêjac mata biŋ ma kasôm gebe ‘Embe Apômtau êkêŋ aê jamu jana Jerusalem biŋŋanôgeŋ, go janam sakiŋ eŋ aŋga Hebron.’” ");
INSERT INTO jae_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Ma kiŋ tau kêsôm gêdêŋ eŋ gebe “Ôna tobiŋmalôgeŋ.” Amboac tonaŋ Absalom gêdi ma gêja Hebron. ");
INSERT INTO jae_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Mago Absalom kêsakiŋ lau jaeŋŋa kelecgeŋ kêtôm Israelnêŋ gôlôacmôkê samob sêja ma sêsôm gebe “Amac embe aŋô dauc êtaŋ, go anam lasê to asôm gebe ‘Absalom kêtu kiŋ aŋga Hebron.” ’ ");
INSERT INTO jae_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Absalom keteŋ lau 200 aŋga Jerusalem gebe têtu ŋacleŋ eŋ, tec sêsêlêŋ sêwiŋ eŋ. Êsêac sêjam kauc biŋ samob tonaŋ ŋai ma sêwiŋ eŋ tonêŋ ŋalêlôm sawa biŋŋageŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Gêdêŋ taŋ Absalom kêkêŋ da gêmoa naŋ, eŋ kêsakiŋ biŋ gêja malac Gilo gebe Dawidnê ŋac gêwa biŋ saŋa Ahitopel êndêŋ eŋ êmêŋ. Ma biŋ sêli tauŋ saŋa kêtu kapôêŋ ma lau totoŋ-totoŋ sêwiŋ Absalom. ");
INSERT INTO jae_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Ma ŋac jaeŋŋa teŋ mêŋgêô lasê gêdêŋ Dawid ma kêsôm gebe “Lau Israel nêŋ ŋalêlôm gêjam tau ôkwi jakêsap Absalom tôŋ.” ");
INSERT INTO jae_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Go Dawid kêsôm gêdêŋ nê sakiŋwaga samob, taŋ sêmoa sêwiŋ eŋ aŋga Jerusalem naŋ, gebe “Ajôc, taêc. Embe taêc atom, oc tawê Absalom sa atom. Aŋgôm ŋagaô. Embe masi, oc Absalom mêŋêô lasê tonec sebeŋ ma êkôniŋ aêac to ênac lau malacm tau ŋa siŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Ma kiŋnê sakiŋwaga sêjô eŋ awa gebe “O ma ŋatau kiŋ, nêm sakiŋwaga aêac, tec aŋgôm nêm biŋ ŋanô êsa.” ");
INSERT INTO jae_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Amboac tonaŋ kiŋ gêdi gêja ma nê gôlôac sêwiŋ eŋ. Ma kiŋ gêwi nê lauo 10 siŋ gacgeŋ sêmoa gebe sejop andu. ");
INSERT INTO jae_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Ma kiŋ gêdi gaja ma lau samob têdaguc eŋ ma aŋga andu ŋamuŋa êsêac sêka tôŋ sêkô sêlêwaŋ tauŋ. ");
INSERT INTO jae_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Go nê sakiŋwaga samob sêôc lêlêc eŋ sêja. Ma siŋwaga Keret to Peletŋa, taŋ sejop eŋ ŋapaŋ naŋ, to lau Git 600, taŋ têdaguc eŋ aŋga Gat naŋ, jasêôc lêlêc kiŋ. ");
INSERT INTO jae_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Go kiŋ tau kêsôm gêdêŋ ŋac Gitŋa Itai gebe “Aôm gobe ôwiŋ aêac êtu asageŋŋa. Ômu ôna ma ômoa ôwiŋ kiŋ wakuc gebe aôm ŋacjaba ma têtiŋ aôm su aŋga nêm malacmôkê mêŋgôŋgôŋ gamêŋ jaba. ");
INSERT INTO jae_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Nôgeŋ tec gômôêŋ ma ocsalô tonec oc jakac aôm gebe ônac laoc gamêŋ ôwiŋ aêac me. Aê jana, tageŋ gajam kauc jana ondoc. Ôkac taôm ôkwi to nêm lasitêwaigeŋ amu ana. Apômtau têtac gêwiŋ aôm ma êmoa êwiŋ aôm ŋaŋêŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Go Itai gêjô kiŋ awa ma kêsôm gebe “O ŋoc kiŋ, aê jasôm êtu tôŋ jakô Apômtau mata jali laŋônêm ŋa gebe gamêŋ, taŋ aôm ôna naŋ, aê jawiŋ ma embe jamac êndu oc jamac êndu.” ");
INSERT INTO jae_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Tec kiŋ kêsôm gêdêŋ Itai gebe “Amboac tonaŋ ôsêlêŋ ômuŋ aê.” Tec ŋac Gitŋa Itai to nê lau samob ma nêŋ gôlôac sauŋ samob, taŋ sêmoa sêwiŋ eŋ naŋ, sêsêlêŋ sêmuŋ Dawid sêja. ");
INSERT INTO jae_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Ma gêdêŋ taŋ lau samob sêôc lêlêc Dawid sêja naŋ, lau samob têtaŋ ŋanô ma kiŋ gelom bu Kidron ma lau samob sêmuŋ eŋ sepeŋ gamêŋ sawageŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Ma Abiatar agêc Sadok sêwiŋ lau Lewit samob, taŋ sêbalaŋ Anôtônê poac ŋakatapa naŋ, sêô lasê amboac tonaŋ. Ma êsêac tetoc Anôtônê poac ŋakatapa kêkô e lau samob aŋga malac sêsa sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Go kiŋ tau kêsôm gêdêŋ Sadok gebe “Ôkôc Anôtônê poac ŋakatapa êmu êsô malac kapôêŋ êna êtiam. Embe Apômtau êlic aê ênac mataanô ŋajam, go êkêŋ aê jamu jamêŋ ma jalic katapa tau to ênê gamêŋ êtiam. ");
INSERT INTO jae_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Mago embe êsôm gebe ‘Aê matocanô galic aôm ŋajam atom’, go êŋgôm aê êtôm eŋ taê ênam. Aê tec gamoa.” ");
INSERT INTO jae_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Go kiŋ kêsôm biŋ teŋ gêdêŋ dabuŋwaga Sadok gêwiŋ gebe “Ôlic acgom, ômu ôna malac tobiŋmalôgeŋ, amagêc Abiatar awiŋ nêm latômiagêc, nêm latôm Ahimas agêc Abiatar latu Jonatan. ");
INSERT INTO jae_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Ôlic acgom, aê oc jansaê aŋga buseleŋ, taŋ gêc gamêŋ sawa naŋ, e jatap ŋawae teŋ sa aŋga amacnêm.” ");
INSERT INTO jae_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Amboac tonaŋ Sadok agêc Abiatar sêbalaŋ Anôtônê poac ŋakatapa sêmu sêja Jerusalem ma gacgeŋ sêmoa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Mago Dawid jakêpi lôc Katêkwi totaŋiboageŋ. Eŋ kêsêlêŋ ŋa atapa ŋaômageŋ to gêsaŋ laŋôanô auc. Ma lau samob, taŋ sêwiŋ eŋ naŋ, sêsaŋ laŋôŋanô auc ma sêsêlêŋ sêpi sêja totaŋiboageŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Ma ŋawae gêdêŋ Dawid gebe “Ahitopel gêwiŋ lau sêli tauŋ saŋa gêmoa gêwiŋ Absalom.” Go Dawid gêmôêc gebe “O Apômtau, aê jateŋ aôm, ônam Ahitopelnê biŋ ôkwi êtu biŋ meloc.” ");
INSERT INTO jae_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Gêdêŋ taŋ Dawid gêô lasê gamêŋ, taŋ sêjam sakiŋ Anôtô sêmoa aŋga lôc ŋatêpôê naŋ, nê ŋac Ark Husai gêdac eŋ. Eŋ kêkac nê ŋakwê gêŋgic ma nom gi eŋ môkêapac. ");
INSERT INTO jae_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Ma Dawid kêsôm gêdêŋ eŋ gebe “Aôm embe ôwiŋ aê oc ônam aê sa êtôm atom. ");
INSERT INTO jae_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Mago aôm embe ôna malac ma ôsôm êndêŋ Absalom gebe ‘O kiŋ, aê gabe jatu nêm sakiŋwaga amboac gêmuŋgeŋ katu tamamnê.’ Embe ôŋgôm amboac tonaŋ, go ônam aê sa ma onseŋ Ahitopelnê biŋ su. ");
INSERT INTO jae_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Dabuŋwaga Sadok agêc Abiatar sêmoa sêwiŋ aôm. Amboac tonaŋ biŋ samob, taŋ ôŋô aŋga kiŋnê andu naŋ, ôndôŋ êndêŋ dabuŋwaga Sadok agêc Abiatar. ");
INSERT INTO jae_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Êsêagêcnêŋ latuŋiagêc Sadok latu Ahimas agêc Abiatar latu Jonatan sêmoa sêwiŋ êsêagêc ma aôm ôsakiŋ êsêagêc tobiŋ samob, taŋ aôm ôŋô naŋ, dêndêŋ aê sêmêŋ.” ");
INSERT INTO jae_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Tec gêdêŋ têm, taŋ Absalom jakêsô Jerusalem naŋ, Dawidnê ŋac Husai jagêô lasê amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Gêdêŋ taŋ Dawid jakêlêlêc lôctêpôê ŋagec su naŋ, Mepibosetnê sakiŋwaga Siba kêpuc eŋ tôŋ-tôŋ todoŋki luagêc ma waba. Polom 200 ma wain kwalim 100 ma kaŋanô 100 ma bôc ŋaôlic towain teŋ gêsac doŋki ŋaô. ");
INSERT INTO jae_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Ma kiŋ kêtu kênac Siba gebe “Gêŋ tonaŋ ŋam amboac ondoc.” Go Siba gêjô eŋ awa gebe “Doŋki sênam kiŋnê gôlôac sa gebe sêŋgôŋ ŋaô. Ma lau wakuc sêniŋ polom to kaŋanô ma êsêac, taŋ tekweŋ gêbac aŋga gamêŋ sawa naŋ, sênôm wain.” ");
INSERT INTO jae_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Go kiŋ kêtu kênac gebe “Ma nêm ŋataunê latu gêmoa ondoc.” Tec Siba gêjô kiŋ awa gebe “Eŋ gêŋgôŋ Jerusalem gebe eŋ kêsôm gebe ‘Ocsalô tonec gôlôac Israel oc sêkêŋ tamocnê gamêŋ kiŋŋa êmu êndêŋ aê.’” ");
INSERT INTO jae_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Tec kiŋ kêsôm gêdêŋ Siba gebe “Amboac tonaŋ gêŋ samob, taŋ kêtu Mepibosetnê naŋ, êtu aômnêm.” Ma Siba kêsôm gebe “Ŋoc ŋatau kiŋ, aê jasô aôm ŋalabu, matamanô êlic aê ŋajammaŋ.” ");
INSERT INTO jae_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Gêdêŋ taŋ kiŋ Dawid mêŋgêô lasê malac Bahurim naŋ, ŋac teŋ aŋga Saulnê gôlôac, Gera latu Simei kêsa aŋga tonaŋ gêmêŋ gebe êpuc eŋ tôŋ-tôŋ. Eŋ kêsêlêŋ tonê ŋalêlôm secgeŋ gêmoa ma kêpuc boa Dawid gêmoa intêna. ");
INSERT INTO jae_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Dawidnê lau samob to siŋsêlêc sêgi eŋ auc, mago Simei kêtuc Dawid to nê sakiŋwaga ŋa poc. ");
INSERT INTO jae_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Ma Simei kêpuc boa eŋ ma gêmôêc gebe “Ônaŋa, ônaŋa, dec kêsap aôm lêmam tôŋ, aôm ŋac alôb-alôb. ");
INSERT INTO jae_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Aôm kôjaŋgo Saulnê gôliŋ kiŋŋa su ma kôkêc Saulnê gôlôac nêŋ dec taêsam siŋ. Tec Apômtau kêkêŋ ŋagêjô kêpi aôm ma kêkêŋ nêm gamêŋ kiŋŋa kêsêp latôm Absalom lêma. Kec, ŋagêjô kêtap aôm, taŋ lêmam siŋdec naŋ sa sugac.” ");
INSERT INTO jae_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Go Seruia latu Abisai kêsôm gêdêŋ kiŋ gebe “Kêam ŋamatê tonaŋ oc êpuc boa êôc ŋatau kiŋ êtu ageŋŋa. Ôsôm ma najandim eŋ gêsutêkwa êŋgic.” ");
INSERT INTO jae_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Mago kiŋ gêjô eŋ awa gebe “Seruia latui amac, aêacnêŋ asageŋ ŋagêdô gêdêŋ tauŋ. Eŋ embe êpuc boa aê gebe Apômtau kêsôm gêdêŋ eŋ gebe ‘Ôpuc boa Dawid,’ go asa êtôm gebe êsôm gebe ‘Gôgôm tonaŋ kêtu asageŋŋa.’” ");
INSERT INTO jae_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Ma Dawid kêsôm gêdêŋ Abisai to nê sakiŋwaga samob gebe “Alicgac me, aê tauc latuc kêkic ŋoc biŋ ma ŋac Benjaminŋa tonaŋ oc êŋgôm atom me. Andec eŋ êpuc boa aêmaŋ gebe Apômtau kêjatu eŋ. ");
INSERT INTO jae_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Oc moae Apômtau êlic aêŋoc gêŋwapac ma êkêŋ moasiŋ êjô biŋ kêpuc boa ocsalô tonecŋa su.” ");
INSERT INTO jae_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Amboac tonaŋ Dawid to nê lau sêsêlêŋ sêmoa intêna ma Simei kêsêlêŋ gêwiŋ gêmoa lôcdênaŋ, taŋ kêkanôŋ kiŋ naŋ, ma kêpuc boa eŋ to kêtuc eŋ ŋa poc ma kêpalip kekop kêpi gêgôm gedeŋ tôŋgeŋ gêja. ");
INSERT INTO jae_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Ma kiŋ tau to lau samob, taŋ sêwiŋ eŋ naŋ, sêô lasê Jordan totekweŋ gêbacgeŋ ma aŋga tonaŋ eŋ kêlêwaŋ tau. ");
INSERT INTO jae_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Absalom to lau Israelnêŋ ŋacwaga samob sêô lasê Jerusalem ma Ahitopel gêmoa gêwiŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Ma gêdêŋ taŋ Dawidnê ŋac Ark Husai jagêô lasê gêdêŋ Absalom naŋ, eŋ awa gêôc Absalom gebe “Kiŋ êmoa teŋgeŋ, kiŋ êmoa teŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Ma Absalom kêsôm gêdêŋ Husai gebe “Aôm têmtac gêwiŋ nêm ŋac amboac tonaŋ me. Kêtu asageŋŋa aôm gôwiŋ nêm ŋac gôja atom.” ");
INSERT INTO jae_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Ma Husai kêsôm gêdêŋ Absalom gebe “Masi, aê jatu ŋac, taŋ Apômtau to lau tonec ma ŋacwaga Israel pebeŋ sêjaliŋ eŋ sa naŋ, nê gêŋ ma aê jamoa jawiŋ eŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Ma teŋ êwiŋ, aê janam sakiŋ asa. Oc janam sakiŋ ŋoc ŋatau latu atom me. Janam sakiŋ aôm êtôm gajam sakiŋ tamam.” ");
INSERT INTO jae_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Go Absalom kêsôm gêdêŋ Ahitopel gebe “Ôwa sa acgom, galoc aêac daŋgôm asageŋ.” ");
INSERT INTO jae_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Ahitopel gêjô Absalom awa gebe “Aôm ôsô ôndêŋ tamamnê awênê anaio, taŋ gêwi êsêac siŋ gebe sejop andu tau naŋ ôna. Go Israel samucgeŋ sêŋô ŋawae gebe kôkêŋ taôm kôtu tamamnê ŋacjo, go samob, taŋ sêsap aôm tôŋ naŋ, tekweŋ saki êsa.” ");
INSERT INTO jae_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Amboac tonaŋ êsêac sê becobo teŋ kêtu Absalomŋa kêkô andu ŋasalôm tapa-tapa ŋaô. Ma Absalom kêsô gêdêŋ tamanê awênê anaio ma Israel samob sêlic. ");
INSERT INTO jae_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Gêdêŋ ŋasawa tonaŋ Ahitopel embe êwa biŋ teŋ sa, naŋ tetoc biŋ tau sa ma sêlic amboac aŋga Anôtô taunê. Dawid agêc Absalom lulugeŋ tetoc Ahitopel nê biŋ sa kêtôm tonaŋ. ");
INSERT INTO jae_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Go Ahitopel kêsôm gêdêŋ Absalom gebe “Tajaliŋ lau 12,000 sa ma aê jandi ma jandaŋguc Dawid êndêŋ êmbac tonec. ");
INSERT INTO jae_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Aê oc jandac eŋ êndêŋ taŋ eŋ têkwa êmbac ma têtac ŋatutuc ma jatakê eŋ to lau samob, taŋ sêwiŋ eŋ naŋ sêc sêna. Aê oc janac kiŋ taugeŋ ");
INSERT INTO jae_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","ma jakôc lau samob sêmu dêdêŋ aôm sêmêŋ amboac awê teŋ gêmu gêdêŋ nê akweŋ gêmêŋ. Aôm gobe ônac ŋac tageŋgeŋ ma lau samob sêmoa tobiŋmalôgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Ma biŋ tau kêmoasiŋ Absalom to Israel nêŋ lauŋanô samob. ");
INSERT INTO jae_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Go Absalom kêsôm gebe “Amôêc ŋac Ark Husai amboac tonaŋgeŋ ma taŋô biŋ, taŋ eŋ taê gêjam naŋ.” ");
INSERT INTO jae_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Ma gêdêŋ taŋ Husai mêŋgêô lasê gêdêŋ Absalom naŋ, Absalom kêsôm gêdêŋ eŋ gebe “Ahitopel kêsôm amboac tonaŋ. Aêac daŋgôm êtôm eŋ kêsôm me masi. Embe masi, go ôwa biŋ tau sa.” ");
INSERT INTO jae_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Go Husai kêsôm gêdêŋ Absalom gebe “Biŋ taŋ Ahitopel kêsôm gêdêŋ aôm gebe daŋgômŋa naŋ, ŋajam atom.” ");
INSERT INTO jae_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Ma Husai kêsôm gêwiŋ gebe “Aôm kôjala gebe tamam to ŋacwaga, taŋ sêwiŋ eŋ naŋ, lau ŋactêkwa ma êsêac têntac ŋandaŋ sec amboac bôclai têna teŋ, taŋ gêmoa saleŋ ma sêjaŋgo ŋalatu su aŋga ênê naŋ. Ma biŋ teŋ Aôm tamam eŋ siŋsêlêc laŋgwa ma kêjala siŋ ŋagôliŋ. Eŋ oc êkêŋ nê lau sêlêwaŋ tauŋ êndêŋ êmbêc atom. ");
INSERT INTO jae_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Taêm ênam, Dawid galocgeŋ oc kêsiŋ tau ôkwi aŋga pocgêsuŋ me gamêŋ teŋ. Ma embe siŋ êsa ma sênac nêm lau ŋagêdô êndu, go lau taŋ sêŋô ŋawae naŋ, oc sêsôm gebe ‘Lau taêsam taŋ têdaguc Absalom naŋ sêjaŋa.’ ");
INSERT INTO jae_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Go ŋac têtac kêpa suŋa, taŋ nê ŋalêlôm amboac lewe nê naŋ, oc êtu palê ma êtêc tau ŋanôgeŋ. Gebe Israel samucgeŋ sêjala gebe aôm tamam eŋ ŋac siŋsêlêc to êsêac, taŋ sêwiŋ eŋ naŋ, lau toŋaclaigeŋ. ");
INSERT INTO jae_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Mago biŋ taŋ aê taê gajam gebe daŋgôm naŋ, tonec gebe Israel samucgeŋ aŋga Dan e êndêŋ Berseba sêkac tauŋ sa sêpi tageŋ dêndêŋ aôm. Êsêac lau taêsam ŋanô lasê amboac gaŋac gwêcŋa ma aôm taômgeŋ ôwê êsêac sênac siŋ. ");
INSERT INTO jae_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Aêac embe tatap Dawid sa aŋga nê ŋasawa teŋ, go aêac takôm eŋ auc amboac maniŋ kêsêlô kêsêp nom ma eŋ tonê lau, taŋ sêmoa sêwiŋ eŋ naŋ, nêŋ teŋ oc êwê sa atom. ");
INSERT INTO jae_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Eŋ embe êtaiŋ tau su naêlamu malac totuŋbôm teŋ, go Israel samucgeŋ sêkôc lêpoa sêna malac tonaŋ ma sê malac tau êsêp gaboaŋ to senseŋ su ênaŋa e têtap ŋapoc tageŋgeŋ sa êtiam atom.” ");
INSERT INTO jae_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Ma Absalom to Israelnêŋ ŋacwaga samob sêsôm gebe “Ŋac Ark Husai nê biŋ ŋajam kêlêlêc Ahitopelnê su.” Apômtau gebe enseŋ Absalom su, tec kêkêŋ êsêac sêwi Ahitopelnê biŋ ŋajam siŋ gêcŋa. ");
INSERT INTO jae_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Go Husai gêjac miŋ biŋ, taŋ Ahitopel kêsôm gêdêŋ Absalom to lau Israelnêŋ kasêga ma biŋ, taŋ eŋ tau kasôm gêdêŋ êsêac naŋ, gedeŋ dabuŋwagaagêc Sadok agêc Abiatar. ");
INSERT INTO jae_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","Ma kêsôm biŋ tonec gêwiŋ gebe “Asakiŋ biŋ ŋagaôgeŋ êna ma asôm endeŋ Dawid gebe êmoa buseleŋ gamêŋ sawaŋa êndêŋ êmbêc atom. Selom bu sêna ŋamakeŋ gebe gêŋwapac êtap kiŋ to lau samob, taŋ semoa sêwiŋ eŋ naŋ sa atom.” ");
INSERT INTO jae_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Jonatan agêc Ahimas sêsaê sêmoa bumata Enrogel. Sakiŋwagao teŋ gêja ma kêsôm biŋ gêdêŋ êsêagêc gebe êsêagêc nasêsôm ŋawae êndêŋ kiŋ Dawid. Êsêagêc tauŋ têtôm gebe sêsa malac tau sêna e lau sêlic êsêagêc nec atom. ");
INSERT INTO jae_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Mago ŋapalê teŋ gêlic êsêagêc, tec jagêjac miŋ gêdêŋ Absalom. Amboac tonaŋ agêc sêwi gamêŋ tonaŋ siŋ ŋagaôgeŋ ma jasêô lasê ŋac teŋ aŋga malac Bahurim nê andu. Ênê sê buŋa teŋ gêc nê malacluŋ, tec êsêagêc sêsêp sê tau ŋalêlôm sêja. ");
INSERT INTO jae_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Ma ŋac tau nê awê jakêgadê sê awa auc ma kêta mopolom ŋanô gêsac gadê ŋaô e gêŋ teŋ gêc awê atom. ");
INSERT INTO jae_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Gêdêŋ taŋ Absalom nê sakiŋwaga jasêô lasê dêdêŋ awê tau aŋga andu tonaŋ naŋ, êsêac têtu kênac gebe “Ahimas agêc Jonatan semoa ondoc.” Awê tau gêjô êsêac aweŋ gebe “Êsêagêc selom bu sêja.” Ma êsêac sesom elêmê, mago têtap êsêagêc sa atom. Tec sêmu sêja Jerusalem kêtiam. ");
INSERT INTO jae_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Sêc sêja su acgom, go êsêagêc sêpi aŋga sê sêmêŋ kêtiam ma sêja sêkêŋ ŋawae gêdêŋ kiŋ Dawid tau. Êsêagêc sêsôm gêdêŋ Dawid gebe “Ôndi ma sebeŋ olom bu ŋamakeŋ ôna.” Go sêjac miŋ biŋ, taŋ Ahitopel kêsôm kêtu eŋŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Tec Dawid to lau samob, taŋ sêmoa sêwiŋ eŋ naŋ, dêdi selom bu Jordan su sêwi nêŋ ŋac teŋ siŋ gêmoa ŋamakeŋ ônêŋa atom. ");
INSERT INTO jae_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Ahitopel gêlic gebe sêgôm ênê biŋ samob ŋanô kêsa atom, tec kêmasaŋ nê doŋki ma gêc gêja taunê malacmôkê. Eŋ kêmasaŋ nê biŋ to gêŋ samob gêbacnê ma jagêbic tau êndu ma sêsuŋ eŋ aŋga tamanê sêô. ");
INSERT INTO jae_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Go Dawid jagêô lasê Mahanaim ma Absalom to lau Israel nêŋ ŋacwaga samob selom bu Jordan sêja. ");
INSERT INTO jae_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Absalom kêkêŋ Amasa kêtu siŋwaganêŋ ŋamata gêjô Joab su. Amasa tonaŋ eŋ ŋac Ismael Itra latu. Itra tau gêjam Nahas latuo Abigail. Eŋ Joab têna Seruia lasio. ");
INSERT INTO jae_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Absalom to lau Israel sê nêŋ becobo sêmoa gamêŋ Gilead. ");
INSERT INTO jae_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Gêdêŋ taŋ Dawid gêô lasê Mahanaim naŋ, Nahas latu Sobi aŋga Amon nêŋ malac Raba agêc Amiel latu Makir aŋga Lodebar ma ŋac Gileadŋa Barsilai aŋga Rogelim, ");
INSERT INTO jae_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","sêkôc mê to laclu ma ku to mopolom tokaiŋ-tokaiŋ ma polom sigob to gabab ma gêŋgaga ŋagêdô. ");
INSERT INTO jae_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","Êsêac sêkôc lêp to ŋalêsi ma su gêjac anô sêmêŋ gebe Dawid to lau siŋŋa, taŋ sêmoa sêwiŋ eŋ naŋ sêniŋ. Êsêac sêsôm gebe “Lau sêmoa gamêŋ sawa e mo to bu gêjô êsêac ma tekweŋ gêbac.” ");
INSERT INTO jae_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Go Dawid gêjac nê lau, taŋ sêmoa sêwiŋ eŋ naŋ, kêsi ma kêkêŋ êsêacnêŋ laumata siŋŋa ŋagêdô sêjam gôliŋ lau 1,000 ma ŋagêdô sêjam gôliŋ lau 100. ");
INSERT INTO jae_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Go Dawid gêwa lau siŋŋa kêkôc gêja toŋ têlêac. Toŋ ŋamataŋa Joab gêjam gôliŋ. Toŋ teŋ Seruia latu Joab lasi Abisai gêjam gôliŋ. Ma toŋ teŋ ŋac Gitŋa Itai gêjam gôliŋ. Ma kiŋ kêsôm gêdêŋ lau gebe “Aê tauc oc jawiŋ amac amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Mago êsêac sêsôm gebe “Aôm ôwiŋ aêac atom. Aêac embe aêc ŋacjo su oc lau taêŋ ênam biŋ taêsam atom. Embe aêacma ŋamakeŋ sêmac êndu oc lau taêŋ ênam biŋ taêsam atom amboac tonaŋgeŋ. Mago aôm tec kôlêlêc ma lau 10,000 su. Amboac tonaŋ aôm embe ômoa malac ma ôpuc aêac toŋ oc ŋajam êlêlêc.” ");
INSERT INTO jae_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Tec kiŋ kêsôm gêdêŋ êsêac gebe “Gêŋ taŋ amac alic ŋajam naŋ, aê gabe jasô ŋalabu.” Amboac tonaŋ kiŋ kêkô kêsi malac ŋasacgêdô ma siŋwaga samob sêsêlêŋ sêsa sêja totoŋ-totoŋ. Toŋ ŋagêdô ŋalau têtôm 100 ma toŋ ŋagêdô ŋalau têtôm 1,000. ");
INSERT INTO jae_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Ma kiŋ kêjatu Joab agêc Abisai ma Itai gebe “Aŋgôm ŋac wakuc Absalom saic-saicgeŋ atom êtu aêŋa.” Ma lau samob sêŋô jatu tonaŋ, taŋ kiŋ kêkêŋ gêdêŋ êsêac laumata siŋŋa samob kêtu Absalomŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Amboac tonaŋ Dawidnê siŋwaga sêsa awê gebe nasêndac lau Israel. Ma sêjac siŋ tau kêsa aŋga saleŋ Epraimŋa. ");
INSERT INTO jae_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Ma Dawid nê siŋwaga sêku Israel tulu aŋga tonaŋ. Sêjac siŋ kapôêŋanô gêdêŋ bêc tonaŋ. Lau 20,000 sêmac êndu. ");
INSERT INTO jae_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","Siŋ tonaŋ gelom gêjam gamêŋ tonaŋ auc ma gêdêŋ bêc tonaŋ saleŋ kêdaŋgôŋ lau taêsam kêlêlêc lau, taŋ siŋ geseŋ naŋ su. ");
INSERT INTO jae_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Ma Absalom kêtap Dawidnê sakiŋwaga sa. Absalom gêŋgôŋ nê doŋki ŋaô ma doŋki tau jagêboaŋ kêsô kamem kapôêŋ ŋalaka ŋalêlôm gêja. Ma Absalom nê môkêlauŋ gêjac kêsô ŋalaka ma eŋ gacgeŋ geŋ kaleŋ ma doŋki tau, taŋ Absalom gêŋgôŋ ŋaô naŋ, gêboaŋ su gêc gêja. ");
INSERT INTO jae_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Ŋac teŋ gêlic gêŋ tau ma kêsôm gêdêŋ Joab gebe “Ôlic acgom, aê galic Absalom geŋ kaleŋ kamem ŋalaka.” ");
INSERT INTO jae_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Joab kêsôm gêdêŋ ŋac, taŋ kêsôm biŋ tau naŋ gebe “Aôm gôlic eŋ me. Kêtu asageŋŋa gôjac eŋ kêsêp nom gêmêŋ atom. Aê oc jakêŋ silber 10 êndêŋ aôm ma ômbiŋkap teŋ êwiŋ.” ");
INSERT INTO jae_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Mago ŋac tau kêsôm gêdêŋ Joab gebe “Aê embe jatap silber 1,000 sa êsêp aê lemoc, mago oc jakêŋ lemoc êpi kiŋ latu atom. Gebe aêac aŋô kiŋ gêjac biŋsu amagêc Abisai ma Itai gebe ‘Aŋgôm ŋac wakuc Absalom saic-saicgeŋ atom êtu aêŋa.’ ");
INSERT INTO jae_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Ma aê embe jaŋgôm gêŋ teŋ kelecgeŋ êndêŋ eŋ katu oc êsiŋ tau êndêŋ kiŋ atom ma aôm taôm oc ônam aê kêsi atom.” ");
INSERT INTO jae_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Joab kêsôm gebe” Aê gabe jajaiŋ têm jawiŋ aôm atom.” Go eŋ kêkôc kêm têlêac jagêguŋ Absalom kêsô bôdagi gêdêŋ taŋ eŋ mata jaligeŋ geŋ kaleŋ kamem ŋalaka naŋ. ");
INSERT INTO jae_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Ma lau matac 10, taŋ sêôc Joabnê laukasap naŋ, sêgi Absalom auc ma sêjac eŋ êndu. ");
INSERT INTO jae_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Go Joab gêjac dauc kêtaŋ ma lau siŋŋa, taŋ sêjanda Israel naŋ, sêwi siŋ ma sêmu sêmêŋ gebe Joab kêkô êsêac auc. ");
INSERT INTO jae_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Ma êsêac sêkôc Absalomnê ŋawêlêlaŋ ma sêbaliŋ kêsêp sê kapôêŋ teŋ aŋga saleŋ ma sêboa poc toŋ kapôêŋ teŋ sa kêkô sê tau ŋaô. Ma lau Israel samob sêc sêja nêŋ andu gêdêŋ-gêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Gêdêŋ taŋ Absalom gêmoa mata jali naŋ, eŋ kêkôc alê poc teŋ jagêjac sa kêtu eŋ tauŋa kêkô kiŋnê gaboaŋ gebe eŋ kêsôm gebe “Aê latuc masi gebe lau taêŋ ênam aê.” Eŋ gê taunê ŋaê kêpi alê poc tonaŋ ma sêsam gêŋ tau gebe Absalomnê ŋabelo e gêdêŋ ocsalô tonec. ");
INSERT INTO jae_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Go Sadok latu Ahimas kêsôm gêdêŋ Joab gebe “Ôkêŋ aê jalêti najakêŋ ŋawae êndêŋ kiŋ tau gebe Apômtau gêjam eŋ kêsi aŋga nê ŋacjo nêŋ ŋaclai.” ");
INSERT INTO jae_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Ma Joab kêsôm gêdêŋ eŋ gebe “Aôm ôkôc ŋawae ôna êndêŋ ocsalô tonec atom. Moae oc ôkôc ŋawae ôna êndêŋ bêc teŋ, mago galoc aôm ôna atom gebe kiŋ latu gêmac êndu.” ");
INSERT INTO jae_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Go Joab kêsôm gêdêŋ nê sakiŋwaga ŋac Kusŋa gebe “Ôna ôkêŋ ŋawae êndêŋ kiŋ êtu gêŋ, taŋ gôlic naŋŋa.” Ŋac Kusŋa gewec gêdêŋ Joab ma kêlêti gêja. ");
INSERT INTO jae_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Go Sadok latu Ahimas kêsôm gêdêŋ Joab kêtiam gebe “Gêŋwapac teŋ embe êtap aê sa, go êtap samaŋ. Mago ôkêŋ aê jalêti jandaŋguc ŋac Kusŋa jana.” Ma Joab gêjô eŋ awa gebe” Ŋoc latucenec, ôlêti êtu asageŋŋa. Aôm oc ôtap ŋagêjô ŋajam teŋ sa êtu ôkêŋ ŋawaeŋa atom.” ");
INSERT INTO jae_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Eŋ kêsôm kêtiam gebe “Gêŋwapac teŋ embe êtap aê sa, go etap sa, mago gabe jalêti jana.” Tec Joab kêsôm gêdêŋ eŋ gebe “Ôlêtimaŋ.” Go Ahimas kêlêti kêdaguc intêna gaboaŋŋa jagêôc lêlêc ŋac Kusŋa su. ");
INSERT INTO jae_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","Dawid jagêŋgôŋ tuŋbôm ŋasacgêdô. Ma dibwaga tau kêpi tuŋbôm jakêkô sacgêdô ŋasalôm ŋaô. Eŋ gêôc mataanô sa e gêlic ŋac teŋ taugeŋ kêlêti gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","Ma gêmôêc to kêsôm ŋawae gêdêŋ kiŋ. Ma kiŋ kêsôm gebe “Embe eŋ taugeŋ oc moae kêkôc ŋawae ŋajam gêmêŋ.” Ŋacjaeŋ tau kêlêti mêŋkêdabiŋ. ");
INSERT INTO jae_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","Go dibwaga gêlic ŋac teŋ kêlêti gêmêŋ kêtiam. Tec eŋ gêmôêc biŋ gêdêŋ gejobwaga sacgêdôŋa gebe “Ôlic acgom, ŋac teŋ taugeŋ kêlêti gêmêŋ kêtiam.” Kiŋ kêsôm gebe “Eŋ kêkôc ŋawae ŋajam teŋ amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Ma dibwaga kêsôm gebe “Aê galic ŋac, tê kêlêti kêtu ŋamata nê, amboac Sadok latu Ahimas.” Ma kiŋ kêsôm gebe “Eŋ ŋac ŋajam ma oc kêkôc ŋawae ŋajam.” ");
INSERT INTO jae_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Go Ahimas gêmôêc gêdêŋ kiŋ gebe “Gêŋ samob ŋajamgeŋ.” Go eŋ gewec gêdêŋ kiŋ laŋôanô gêdêŋ nom ma kêsôm gebe “Aweŋ êôc Apômtau, aômnêm Anôtô, taŋ kêkêŋ lau, tê sêôc lemeŋ sa gêdêŋ ŋoc ŋatau kiŋ nê, sêsô aôm ŋalabu naŋ.” ");
INSERT INTO jae_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Ma kiŋ kêtu kênac gebe “Ŋac wakuc Absalom gêmoa ŋajam me masi.” Ahimas gêjô eŋ awa gebe “Gêdêŋ taŋ nêm laumata Joab kêsakiŋ nêm sakiŋwaga aê naŋ, aê galic lau taêsam sêjac seso tauŋ, mago gajam kauc ŋam.” ");
INSERT INTO jae_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Ma kiŋ kêsôm gebe “Mêŋôkô tonec.” Amboac tonaŋ eŋ kêkac tau ôkwi ma kêkô ŋaŋêŋ. ");
INSERT INTO jae_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Go ŋac Kusŋa mêŋgêô lasê ma kêsôm gebe “Ŋawae ŋajam kêtu ŋoc ŋatau kiŋŋa. Ocsalô tonec Apômtau kakêŋ lau, taŋ sêli tauŋ sa gêdêŋ aôm naŋ, sêsô aôm ŋalabu.” ");
INSERT INTO jae_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Kiŋ tau kêsôm gêdêŋ ŋac Kusŋa gebe “Ŋac wakuc Absalom gêmoa ŋajam me masi.” Ma ŋac Kusŋa gêjô eŋ awa gebe “O ŋoc ŋatau kiŋ, aê gabe nêm ŋacjo samob to lau samob, taŋ sêli tauŋ sa gêdêŋ aôm naŋ, oc tatôm ŋac wakuc tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","Kiŋ tau atê gêmô eŋ ma kêpi balêm, taŋ gêc malac ŋasacgêdô ŋaô naŋ, gêja ma kêtaŋ gebe “O ŋoc latuc Absalom, latucenec Absalom. Jamac jajô aômmaŋ. O ŋoc latuc Absalom, ŋoc gêŋenec.” ");
INSERT INTO jae_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Go sêkêŋ ŋawae gêdêŋ Joab gebe “Ôlic acgom, kiŋ kêtaŋ taŋiboa kêtu Absalomŋa.” ");
INSERT INTO jae_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Amboac tonaŋ gêdêŋ bêc tonaŋ biŋ sêku ŋacjo tuluŋa tau gêjam tau ôkwi kêtu taŋiboa gêdêŋ lau samob gebe lau sêŋô ŋawae gebe kiŋ kêtaŋ taŋiboa kêtu latuŋa. ");
INSERT INTO jae_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","Gêdêŋ bêc tonaŋ lau siŋŋa sêsa malac sêmêŋ kelecgeŋ sêgôm amboac lau, taŋ majeŋ kêtu têtaiŋ tauŋ su aŋga siŋŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Kiŋ gêsaŋ laŋôanô auc ma kêtaŋ toawa-toawa gebe “O latuc Absalom, o Absalom latucenec, o gêŋenec.” ");
INSERT INTO jae_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Go Joab kêsô andu gêdêŋ kiŋ gêja ma kêsôm gebe “Ocsalô tonec aôm gôgôm nêm sakiŋwaga samob, taŋ sêjam aôm to nêm latômio to ŋac ma nêm lauo to aneŋio kêsi amoa matem jali naŋ, majeŋ kêsa. ");
INSERT INTO jae_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","Aôm têmtac gêwiŋ êsêac, taŋ têntac sec gêdêŋ aôm naŋ, ma têmtac gedec êsêac, taŋ têntac gêwiŋ aôm naŋ. Ocsalô tonec aôm gôwa taôm sa gebe gôlic lau siŋsêlêc to nêm sakiŋwaga samob amboac gêŋ ŋaôma. Galoc aê kajala gebe Absalom embe êmoa mata jali ma aêac samob amac êndu, go ôlic ŋajam. ");
INSERT INTO jae_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Amboac tonaŋ galoc ôndi sa naôsôm biŋ ŋajam teŋ êndêŋ nêm sakiŋwaga. Embe masi, go aê jatôc lemoc jakô Apômtau laŋônêm gebe êndêŋ êmbêc tonec ŋac teŋ oc êmoa êwiŋ aôm atomanô. Biŋ tonaŋ oc êtu biŋ sec êlêlêc biŋ samob, taŋ kêtap aôm sa gêdêŋ aôm ŋapalêgeŋ e mêŋgêdêŋ galoc naŋ su.” ");
INSERT INTO jae_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Go kiŋ gêdi sa jagêŋgôŋ malac ŋasacgêdô. Ma ŋawae gêdêŋ lau samob gebe “Alic acgom, kiŋ gêŋgôŋ malac ŋasacgêdô” ma lau samob sêsa dêdêŋ eŋ. Gêdêŋ ŋasawa tonaŋ Israelnêŋ lau samob sêc dêdêŋ tauŋnêŋ andu gêdêŋ-gêdêŋgeŋ sêja. ");
INSERT INTO jae_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","Ma lau samob sêôc gêdô tauŋ gêdêŋ-gêdêŋgeŋ kêtôm Israelnêŋ gôlôacmôkêgeŋ ma sêsôm gebe “Kiŋ gêjam aêac kêsi aŋga aêacnêŋ ŋacjo lemeŋ ma gêjam aêac sa aŋga lau Pilisti lemeŋ. Ma galoc eŋ gêwi gamêŋ siŋ ma gêc gêja kêtu Absalomŋa. ");
INSERT INTO jae_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Ma Absalom, taŋ aêac taeŋ oso eŋ naŋ, siŋ geseŋ eŋ su. Ma amboac ondoc amac ajam taôm tôŋ ma asôm biŋ teŋ gebe akôc kiŋ tau êmu êmêŋŋa atom.” ");
INSERT INTO jae_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Kiŋ Dawid gêŋô lau Israel sêmasaŋ biŋ kêtu eŋŋa ŋawae, tec kêsakiŋ biŋ gêdêŋ dabuŋwagaagêc Sadok agêc Abiatar gebe “Asôm êndêŋ lau Juda nêŋ laumata gebe ‘Amboac ondoc, tec amac amasaŋ biŋ kêtu akôc kiŋ êmu êwac nê anduŋa kêtu ŋamu nec. ");
INSERT INTO jae_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Aêŋoc lasitêwai amac, ŋoc ŋatêkwa to ŋoc ŋamêsôm amac. Amboac ondoc tec abe akôc kiŋ êmu êwac êtu ŋamugeŋ nec.’ ");
INSERT INTO jae_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Ma asôm êndêŋ Amasa gebe ‘Ŋoc ŋatêkwa to ŋoc ŋamêsôm aôm atom me. Aê embe jakêŋ aôm ôtu ŋoc siŋwaga nêŋ laumata ôjô Joab su atom oc Anôtô enseŋ aê su janaŋa.’” ");
INSERT INTO jae_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Ma eŋ gêjam lau Juda samob nêŋ ŋalêlôm ôkwi e têntac tageŋ ma sêsakiŋ biŋ gêdêŋ kiŋ gebe “Aôm to nêm sakiŋwaga samob amu amêŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Amboac tonaŋ kiŋ tau gêmu gêmêŋ bu Jordan ma lau Juda sêpuc kiŋ tôŋ-tôŋ sêmêŋ Gilgal sebe sêkôc kiŋ tau elom bu Jordan ŋamakeŋ êmêŋ. ");
INSERT INTO jae_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Ma ŋac Benjaminŋa Gera latu Simei aŋga Bahurim kêsêp ŋagaôgeŋ gêmêŋ gêwiŋ lau Judaŋa gebe êpuc kiŋ Dawid tôŋ-tôŋ amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Ma lau Benjaminŋa 1,000 sêwiŋ eŋ. Ma Saulnê gôlôacnêŋ sakiŋwaga Siba to latui 15 ma nê sakiŋwaga 20 sêlêti sêsêp jasêô lasê bu Jordan sêmuŋ kiŋ. ");
INSERT INTO jae_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Ma êsêac selom buseleŋ tau sebe sêkôc kiŋnê gôlôac sêmêŋ ŋamakeŋ ma sebe sêŋgôm gêŋ, taŋ kiŋ êlic êmoasiŋ eŋ naŋ. Ma gêdêŋ taŋ kiŋ gebe elom bu Jordan tau naŋ, Gera latu Simei gêu tau gec eŋ laŋônêmŋa ");
INSERT INTO jae_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","ma kêsôm gêdêŋ eŋ gebe “O ŋoc ŋatau, taêm ênam biŋ, taŋ nêm sakiŋwaga aê gagôm keso gêdêŋ bêc, taŋ gôwi Jerusalem siŋ naŋ, ma ôlic aê sec atom. O kiŋ, ôê biŋ tau tôŋ ênêc nêm ŋalêlôm atom. ");
INSERT INTO jae_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Nêm sakiŋwaga aê kajala gebe gagôm keso. Mago galoc ôlic acgom, aê tec kasêp gamêŋ katu Josepnê gôlôac nêŋ ŋac ŋamataŋa gebe japuc ŋoc ŋatau kiŋ aôm tôŋ-tôŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Go Seruia latu Abisai gêôc awa sa ma kêsôm gebe “Simei êmac êndu êtu kêpuc boa ŋac, taŋ Apômtau geŋ oso eŋ naŋŋa atom me.” ");
INSERT INTO jae_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Mago Dawid kêsôm gebe “Seruia latui amac, aêacnêŋ asageŋ ŋagêdô gêdêŋ tauŋ, tec ocsalô tonec amac alêtôm aê. Ŋac teŋ oc êmac êndu aŋga Israel ocsalô tonec me. Aê kajala gebe katu kiŋ Israelŋa gêdêŋ ocsalô tonec.” ");
INSERT INTO jae_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Ma kiŋ kêtôc lêma ma kêsôm gêdêŋ Simei gebe “Aôm oc ômac êndu atom.” ");
INSERT INTO jae_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Ma Saul dêbu Mepiboset kêsêp gêmêŋ gebe êndac kiŋ tau. Eŋ kêkwasiŋ akaiŋ to kêkapiŋ nê êm ma kêkwasiŋ nê ŋakwê atomanô gêdêŋ taŋ kiŋ gêwi gamêŋ siŋ naŋ, e gêmu gêmêŋ toôli samucgeŋ kêtiam. ");
INSERT INTO jae_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Gêdêŋ taŋ Mepiboset aŋga Jerusalem mêŋgêô lasê gebe êndac kiŋ naŋ, kiŋ tau kêsôm gêdêŋ eŋ gebe “Mepiboset, kêtu asageŋŋa aôm gôwiŋ aê gôja atom.” ");
INSERT INTO jae_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","Eŋ gêjô eŋ awa gebe” O ŋoc ŋatau ma ŋoc kiŋ, aê ŋac puliŋ. Aê kasôm gêdêŋ ŋoc sakiŋwaga gebe êmansaŋ doŋki teŋ êtu aêŋa gebe jaŋgôŋ ŋaô ma jawiŋ kiŋ jana. Mago ŋoc sakiŋwaga kêsau aê. ");
INSERT INTO jae_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Eŋ kêgôliŋ biŋ kêpi nêm sakiŋwaga aê gêdêŋ ŋoc ŋatau kiŋ. Mago ŋoc ŋatau kiŋ kêtôm Anôtônê aŋela. Amboac tonaŋ ôŋgôm gêŋ, taŋ aôm gôlic ŋajam naŋ. ");
INSERT INTO jae_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Gebe ŋoc ŋatau kiŋ gêlic tamocnê gôlôac samucgeŋ amboac lau gêbac jagêdêŋ, mago aôm kôkêŋ nêm sakiŋwaga aê gaŋgôŋ êsêac, taŋ seŋ gêŋ aŋga nêm tebo naŋ ŋalêlôm. Aêŋoc biŋ ŋajam ondoc gêc gebe jateŋ êndêŋ kiŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Ma kiŋ kêsôm gêdêŋ eŋ gebe “Ôsôm biŋ taêsam êwiŋ êtu asageŋŋa. Aê kasôm biŋ kêtu tôŋ gebe Amagêc Siba awa nomlênsêm êkôc.” ");
INSERT INTO jae_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Ma Mepiboset kêsôm gêdêŋ kiŋ gebe “Ŋoc ŋatau kiŋ gêmu gêmêŋ toôli samucgeŋ, tec Siba êkôc gêŋ taumaŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Ŋac Gileadŋa Basilai kêsêp aŋga Rogelim gêmêŋ ma kêsêlêŋ gawiŋ kiŋ e jasêô lasê bu Jordan gebe êkêŋ eŋ elom êna ŋamakeŋ. ");
INSERT INTO jae_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Basilai kêtu ŋamalacanô su, ênê jala kêtu 80. Eŋ gêjam kiŋ tau sa ŋa geŋ taniŋŋa gêdêŋ ŋasawa, taŋ eŋ gêmoa Mahanaim gebe eŋ ŋac tolêlôm ŋanô teŋ. ");
INSERT INTO jae_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Ma kiŋ kêsôm gedeŋ Basilai gebe “Ômôêŋ ôŋgôŋ Jerusalem ôwiŋ aê ma aê jamoasiŋ aôm aŋga tônê.” ");
INSERT INTO jae_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Mago Basilai kêsôm gedeŋ kiŋ gebe “Aêŋoc jala jamoa matoc jaliŋa tendocgeŋ gêc, tec jawiŋ kiŋ japi Jerusalem jana. ");
INSERT INTO jae_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Ocsalô tonec aêŋoc jala kêtu 80. Aê katôm gebe jansaê ŋajam to sec me. Aê katôm gebe jansaê gêŋ, taŋ janiŋ me janôm naŋ me. Aê katôm gebe jaŋô lau aweŋ sênam wêŋa me. Êtu asageŋŋa nêm sakiŋwaga wacêtu gêŋwapac teŋ êndêŋ ŋoc ŋatau kiŋ êwiŋ. ");
INSERT INTO jae_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Nêm sakiŋwaga gebe êsêlêŋ êwiŋ kiŋ dambêgeŋ e êndêŋ Jordan ŋamakeŋ. Kiŋ êmoasiŋ aê amboac tonaŋ êtu asageŋŋa. ");
INSERT INTO jae_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","Aê jateŋ aôm gebe ôkêŋ nêm sakiŋwaga êmu êna gebe jamac êndu aŋga taucŋoc malacmôkê ma aŋga tamoc agêc tinoc nêŋ sêô ŋagala. Nêm sakiŋwaga Kimham tec gêmoa. Ôkêŋ eŋ êsêlêŋ êwiŋ ŋoc ŋatau kiŋ tau ma ôŋgôm gêŋ, taŋ gôlic ŋajamgeŋ naŋ, êndêŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Ma kiŋ gêjô eŋ awa gebe “Kimham êwiŋ aê êna ma aê oc jaŋgôm gêŋ, taŋ aôm ôlic ŋajam naŋ, êndêŋ eŋ ma jaŋgôm gêŋ samob, taŋ aôm oteŋ naŋ, amboac tonaŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Go lau samob selom bu Jordan ma kiŋ gelom amboac tonaŋgeŋ. Ma kiŋ kêlêsôp Basilai alianô ma gêjam mec eŋ ma Basilai gêmu gêja taunê malac. ");
INSERT INTO jae_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Kiŋ tau gêja Gilgal ma Kimham gêwiŋ eŋ. Ma lau Juda samob to lau Israel ŋamakeŋ amboac tonaŋgeŋ sejoŋ kiŋ sêmoa intêna. ");
INSERT INTO jae_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Go lau Israel samob dêdêŋ kiŋ sêja ma sêsôm gêdêŋ eŋ gebe “O kiŋ, kêtu asageŋŋa aêacnêŋ lasitêwai Judaŋa sêjam geŋgeŋ aôm ma sêkôc aôm to nêm gôlôac ma nêm lau samob amêŋ Jordan ŋamakeŋ tonecŋa.” ");
INSERT INTO jae_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Lau Judaŋa sêjô lau Israel aweŋ gebe “Kiŋ kêtu aêacma ŋagêdô teŋ. Kêtu asageŋŋa amac têmtac ŋandaŋ kêtu biŋ tonaŋŋa. Aêac aeŋ kiŋnê gêŋ teŋ me. Me eŋ kêkêŋ gêŋ teŋ ŋaômageŋ gêdêŋ aêac me.” ");
INSERT INTO jae_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Ma lau Israel sêjô lau Juda nêŋ biŋ gebe “Aêac awê kaiŋ kiŋ Dawid alêlêc amac su gebe aêac lau Israel ma gôlôacmôkê 10. Kêtu asageŋŋa amac alic aêac sec. Aêac asôm biŋ gebe akôc aêacnêŋ kiŋ amu amêŋŋa kêtu ŋamata atom me.” Mago lau Juda aweŋ ŋajaŋa kêlêlêc lau Israel nêŋ su. ");
INSERT INTO jae_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Dawid gêga wê tonec gêdêŋ Apômtau, gêdêŋ bêc, taŋ Apômtau gêjam eŋ sa aŋga nê ŋacjo samob lemeŋ to aŋga Saul lêma naŋ. ");
INSERT INTO jae_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","Eŋ kêsôm gebe “Apômtau kêtu ŋoc lamuanô to ŋoc tuŋtêna ma ŋoc gêjam-sawaga. ");
INSERT INTO jae_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Aêŋoc Anôtô kêtu ŋoc lôm, taŋ gaê lamu naŋ. Eŋ kêtu ŋoc lautuc ma ŋoc moasiŋ ŋabulakôp. Eŋ kêtu ŋoc lêmôp to ŋoc lômlabu ma ŋoc kêsiwaga, taŋ gêjam aê sa aŋga gêŋ saic-saic naŋ. ");
INSERT INTO jae_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Aê aoc gêjac Apômtau, taŋ talanem eŋ naŋ, ma eŋ gêjam aê kêsi aŋga ŋoc ŋacjonêŋ. ");
INSERT INTO jae_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","“Gebe gêmacanô ŋadembom gênôm aê auc to gêŋ gebe enseŋ aêŋa ŋasamac kêtakê aê. ");
INSERT INTO jae_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Lamboam ŋalêpoa gêsô aê tôŋ gêmacanô gêwa lakô aê. ");
INSERT INTO jae_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Gamoa e katuc uŋ tageŋ ma aoc gêjac Apômtau ma gamôêc gêdêŋ ŋoc Anôtô gebe ênam aê sa. Eŋ gêŋgôŋ nê gamêŋ dabuŋ ma gêŋô ŋoc môêc ma gê taŋa aêŋoc taŋiboa, taŋ kataŋ gêdêŋ eŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","“Go nom wiwic to kôtêŋ-kôtêŋgeŋ, undambê ŋataoŋ kêtênêp e kôjô-kôjôgeŋ gebe eŋ têtac ŋandaŋ kêsa ŋanô. ");
INSERT INTO jae_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Jadauŋ kêsa eŋ lususuŋ to ja ŋawaô kêsa eŋ awasuŋ ma ŋalana ŋamôsi kêpêlaŋ aŋga ênê kêsa gêja-gêja. ");
INSERT INTO jae_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","Eŋ kêwê undambê sêlilib kêsêp gêmêŋ. Tao ŋamajaŋ gêc eŋ akaiŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Eŋ gêlôb gêŋgôŋ kerub ŋaô. Eŋ gêŋgôŋ mu ŋamagê ŋaô ma gêlôb wip tageŋ. ");
INSERT INTO jae_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","Eŋ kêkêŋ gêsuŋbôm kêtu nê becobo. Kom ŋamajaŋ to tao tokatap-tokatap kêkôm eŋ auc. ");
INSERT INTO jae_vpl VALUES ("S222_13","011_22_13","2SA","22","13","14","Ŋalana ŋamôsi kêpêlaŋ kêsa aŋga ŋawasi, taŋ gêmuŋ eŋ naŋ. “Apômtau kêkêŋ nê wapap gêjac aŋga undambê. Ma Lôlôc Ŋatau kêkêŋ nê awa kêsa. ");
INSERT INTO jae_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","Eŋ kêpê nê sôb ma kêpalip nê ŋacjo êliŋ-êliŋ. Ôsic kêtakê êsêac sêc gôliŋ-gôliŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Gwêc ŋagêdimbob gêôc tau sa kêtu awê ma nom ŋataoŋ kêwaka tau sa. Gebe Apômtau gêjam wambaŋ ma ŋawajaô kêsa eŋ lususuŋ. ");
INSERT INTO jae_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","“Eŋ kêmêtôc lêma aŋga lôlôc mêŋkêkam aê tôŋ ma gê aê sa aŋga ŋasamac kapôêŋ ŋalêlôm. ");
INSERT INTO jae_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","Eŋ kêjaŋgo aê su aŋga ŋoc ŋacjo ŋaclai nê to aŋga ŋoc gobi, taŋ nêŋ ŋaclai kêkôm aê auc naŋ nêŋ. ");
INSERT INTO jae_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Êsêac sebo sêsa dêdêŋ aê gêdêŋ ŋoc bêc ŋawapacŋa, mago Apômtau kêpuc aê tôŋ. ");
INSERT INTO jae_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","Eŋ kêkam aê sa jakakô gamêŋ kwalam. Eŋ kêsaic aê sa kasa gaja gebe eŋ têtac gêwiŋ aêgac. ");
INSERT INTO jae_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","“Apômtau kêmoasiŋ aê kêtôm laŋôcnêm sawaŋa. Eŋ gêjam aê sa kêtôm lemoc selecŋa. ");
INSERT INTO jae_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Gebe aê kasa Apômtaunê lêŋ ŋapep ma kakac tauc su aŋga ŋoc Anôtônê ŋaucŋageŋ atom. ");
INSERT INTO jae_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Ênê biŋgêdêŋ samob kêkô aê laŋôcnêm ma gajam dêmôêc ênê biŋsu atom. ");
INSERT INTO jae_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Aê kasa ŋoc lêŋ ŋapep e eŋ gêlic aê ŋajam. Ma gajob tauc ŋapep gêdêŋ gêŋ sec. ");
INSERT INTO jae_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Amboac tonaŋ Apômtau kêmoasiŋ aê kêtu gamoa ŋaŋêŋŋa, kêtu ŋoc ŋalêlôm selec gamoa eŋ laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","“Aôm gôwa taôm sa gêdêŋ ŋac ŋajam gebe aôm ŋac gabêjam, gêdêŋ ŋac laŋônêm sawaŋa gebe aôm taôm ŋac laŋônêm sawa. ");
INSERT INTO jae_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Aôm gôwa taôm sa gadêŋ ŋac mansaŋ gebe aôm taôm mansaŋ mago gêdêŋ keso-keso, tec kôtôc taôm amboac kaiŋ teŋ. ");
INSERT INTO jae_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Aôm gôjam lau, taŋ sêkôniŋ tauŋ naŋ sa ma kôkôniŋ lau, taŋ tetoc tauŋ sa naŋ. ");
INSERT INTO jae_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","Biŋŋanô, o Apômtau, aôm kôtu ŋoc ja. Ŋoc Anôtô kêpô ŋoc ŋakesec ŋawê kêsa. ");
INSERT INTO jae_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Biŋŋanô, aôm embe ôwiŋ aê oc janac lausiŋ popoc ma ŋoc Anôtô embe êwiŋ aê oc jamboaŋ jaŋgêli nêŋ tuŋbôm. ");
INSERT INTO jae_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Anôtô tonaŋ tec gêjam gôliŋ gêŋ samob tomalageŋ. Biŋ taŋ Apômtau gêjac mata naŋ, kêtu anô. Eŋ kêtu lau samob, taŋ sê lamu eŋ naŋ, nêŋ lautuc. ");
INSERT INTO jae_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","“Apômtau taugeŋ eŋ Anôtô. Ma aêacnêŋ Anôtô taugeŋ eŋ lamu ŋanô. ");
INSERT INTO jae_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Anôtô tau tonaŋ kêtu ŋoc lamu ŋajaŋa tau to kêmasaŋ ŋoc intêna gebe jasa toôlic samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","Eŋ gêgôm ŋoc ockaiŋ kêtôm mojawa nê. Eŋ ketoc aê kakô lôc ŋamoatêc ŋaô toôlic samucgeŋ. ");
INSERT INTO jae_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","Eŋ kêdôŋ lemoc siŋŋa tec lemoc jakêkam talam ŋamadi. ");
INSERT INTO jae_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Aôm kôkêŋ lautuc ênam aê kêsiŋa. Aômnêm moasiŋ ketoc aê sa. ");
INSERT INTO jae_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Aôm kômasaŋ intêna ŋasawa kapôêŋ gebe jasa ma japô ocgêsu ôkwi atom. ");
INSERT INTO jae_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Aê kajanda ŋoc ŋacjo e gaseŋ êsêac su ma kakac tauc ôkwi atom e êsêac sêjaŋa. ");
INSERT INTO jae_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Aê gajac êsêac piŋpaŋ ma sebe sêndi e sêgôm jageo. Ac sêc ockaiŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","Aôm kôjandiŋ aê ŋa ŋaclai gebe janac siŋ ŋanô. Aôm kôkôniŋ ŋoc ŋacjo sêmoa aê ŋalabu. ");
INSERT INTO jae_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","Aôm kôpuc ŋoc ŋacjo sa tec sêc aê e gaseŋ êsêac samob, taŋ têntac sec gêdêŋ aê naŋ su. ");
INSERT INTO jae_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Êsêac sesom nêŋ gêjam sa teŋ, mago teŋ gajam sa atom. Êsêac sêmôêc gêdêŋ Apômtau, mago eŋ gêjô êsêac aweŋ atom. ");
INSERT INTO jae_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Aê kalêsa êsêac e têtôm nom ŋakekop. Aê kaka êsêac tôŋ kêtôm kaka lêsap aŋga intêna. ");
INSERT INTO jae_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","“Aôm gôjam aê sa aŋga siŋ tomôkê-tomôkê e kôkêŋ aê katu lausamucnêŋ gôliŋwaga. Lau taŋ kajala êsêac atom naŋ, sêjam sakiŋ aê. ");
INSERT INTO jae_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","Lau jaba sewec dêdêŋ aê. Aê embe jakac aocsuŋ sa jamoa ma oc taŋeŋ wamu êndêŋ aê. ");
INSERT INTO jae_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Lau jaba latuŋi katuŋ gêjaŋa ma sêsuŋ tauŋ têtênêp-têtênêpgeŋ sêsa aŋga nêŋ tuŋbôm sêmêŋ. ");
INSERT INTO jae_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","“Apômtau gêmoa mata jali. Aê aoc êôc ŋoc lamu. Aê jatoc ŋoc ŋacmoasiŋ Anôtô sa. ");
INSERT INTO jae_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Anôtô tau tec kêpuc aê tôŋ e kakac ŋoc kamocgôc. Eŋ kêkôniŋ malac-malac tôŋ sêsô aê ŋalabu. ");
INSERT INTO jae_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","Ma eŋ gêjam aê kêsi gêdêŋ ŋoc ŋacjo. Aôm kotoc aê sa kêlêlêc ŋoc soŋo-soŋo, ma gôjam aê sa aŋga lau ŋaclai nêŋ. ");
INSERT INTO jae_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","“O Apômtau, kêtu tonaŋŋa aê gabe jalambiŋ aôm jamoa lausamuc ŋalêlôm ma janam wê lanemŋa êpi nêm ŋaê. ");
INSERT INTO jae_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Aôm tonaŋ kotoc nêm kiŋ sa ŋanô ma kôtôc nêm têmtac gêwiŋ teŋgeŋŋa gêdêŋ ŋac, taŋ seŋ oso eŋ naŋ, gêdêŋ Dawid to nê wakuc gedeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Biŋ tonec kêtu Dawidnê awamu “Isai latu Dawid kêsôm biŋ. Ŋac taŋ tetoc eŋ sa naŋ, kêsôm biŋ. Jakobnê Anôtô nê ŋac seŋ oso eŋŋa. Ŋac gêga Israelnê wê ŋajamwaga. ");
INSERT INTO jae_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","“Apômtaunê Ŋalau kêsôm biŋ kêsa aê aoc, ma ênê biŋ gêc aê imbeloc. ");
INSERT INTO jae_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Israelnêŋ Anôtô kêsôm biŋ. Israelnêŋ lamu kêsôm biŋ gêdêŋ aê. Ŋac taŋ kêtêc Anôtô ma gêjam gôliŋ ŋamalac ŋaŋêŋgeŋ naŋ, ");
INSERT INTO jae_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","kêpô êsêac kêtôm ŋawê bêbêcgeŋŋa, kêtôm oc, taŋ kêpi toŋagêlôm masi naŋ, ma gêgôm gêgwaŋ, taŋ kom gêjac naŋ kêpuc. ");
INSERT INTO jae_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Aêŋoc gôlôac sêmoa sêwiŋ Anôtô gebe eŋ kêmoatiŋ poac teŋgeŋŋa teŋ gêwiŋ aê ma kêmasaŋ gêŋ samob ŋapep ma ênêc teŋgeŋ, gebe eŋ oc êkêŋ aê gebe jamoa ŋajam ma gêŋ taŋ ŋoc ŋalêlôm têtac gêwiŋ naŋ, eŋ êŋgôm esewec. ");
INSERT INTO jae_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Mago lau, taŋ sêmoa jaêc Anôtô naŋ, têtôm gêŋ têkwa-têkwa, taŋ tambaliŋ siŋ naŋ, gebe tatôm gebe takôc ŋa lemeŋ atom. ");
INSERT INTO jae_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Mago ŋac taŋ gebe ejoŋ gêŋ tau sa naŋ, êkôc siŋ to kêm ŋadambê ma ja êniŋ gêŋ tau êmbacnê samucgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Gêdêŋ taŋ kiŋ Dawid kêtu ŋamalacanô teŋ ma nê jala kêtu taêsam naŋ, êsêac sêkwa eŋ auc ŋa belaŋke, mago malo gêgôm eŋ ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Amboac tonaŋ ênê sakiŋwaga sêsôm gêdêŋ eŋ gebe “O kiŋ, sensom ŋapalêo teŋ êtu aômŋa gebe ênam sakiŋ aôm ma êtu aômnêm jaomwagao. Eŋ ênêc awiŋ aôm oc êjandaŋ aôm.” ");
INSERT INTO jae_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Tec sesom awêtakiŋ ŋajamanô teŋ aŋga gamêŋ Israelŋa samucgeŋ e têtap awê Sunemŋa Abisag sa ma sêkôc eŋ dêdêŋ kiŋ sêja. ");
INSERT INTO jae_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Ma awêtakiŋ tonaŋ eŋ ŋajamanô ma kêtu kiŋ nê jaomwagao ma gêjam sakiŋ eŋ, mago kiŋ gêjam eŋ atom. ");
INSERT INTO jae_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","Dawid agêc Hagit nêŋ latuŋi Adonia ketoc tau sa ma kêsôm gebe “Aê gabe jatu kiŋ.” Ma eŋ kêkôc kareta to lau, taŋ sêŋgôŋ hos ŋaôŋa naŋ, to lau 50 gebe sêlêti sêmuŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","Ma eŋ tama gêjac jao ma kêtu kênac eŋ gebe “Kêtu asageŋŋa aôm gôgôm gêŋ amboac tonaŋ” naŋ atom. Eŋ ŋac tolaŋôanô ŋajam teŋ amboac tonaŋ ma têna kêkôc eŋ kêdaguc Absalom. ");
INSERT INTO jae_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","Adonia gêjam biŋgalôm gêwiŋ Seruia latu Joab agêc dabuŋwaga Abiatar ma êsêagêc têdaguc Adonia ma sêjam eŋ sa. ");
INSERT INTO jae_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","Mago dabuŋwaga Sadok agêc Jehoiada latu Benaia ma propete Natan to Simei agêc Rei ma Dawid nê siŋsêlêc samob, taŋ sejop eŋ naŋ, sêwiŋ Adonia atom. ");
INSERT INTO jae_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","Adonia kêkêŋ domba to bulimakao kapoac ma bulimakao ŋalatu, taŋ segeŋ e kêtôp ŋajam naŋ, kêtu da aŋga Poc moacŋa, taŋ gêc kêsi Enrogel naŋ, ma kêkêŋ jaeŋ gêdêŋ nê lasitêwai, kiŋ latui, samob ma kiŋ nê lau kapôêŋ aŋga Juda gebe têtu ŋacleŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","Mago eŋ kêkêŋ jaeŋ gêdêŋ propete Natan agêc Benaia ma siŋsêlêc me lasi Salomo atom. ");
INSERT INTO jae_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","Go Natan kêsôm gêdêŋ Salomo têna Batseba gebe “Aôm gôŋô su gebe Hagit latu Adonia kêtu kiŋ ma aêacnêŋ ŋatau Dawid gêjam kauc biŋ tau me masi. ");
INSERT INTO jae_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","Amboac tonaŋ ômôêŋ ma aê gabe jawa lêŋ teŋ sa êndêŋ aôm gebe ônam taôm to latôm Salomo katômi kêsi. ");
INSERT INTO jae_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","Aôm ŋagaôgeŋ ôsô ôndêŋ kiŋ Dawid ôna ma ôsôm êndêŋ eŋ gebe ‘O ŋoc ŋatau kiŋ, aôm kôtôc lêmam gêdêŋ nêm sakiŋwagao aê ma kôsôm gebe “Aômnêm latôm Salomo êtu kiŋ êjô aê su ma êŋgôŋ aêŋoc lêpôŋ” aôm kôsôm me masi. Kêtu asageŋŋa Adonia kêtu kiŋ.’ ");
INSERT INTO jae_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","Aôm ôsôm biŋ êndêŋ kiŋ ômoa, go aê oc jasô jandaŋguc aôm ma japuc nêm biŋ tôŋ.” ");
INSERT INTO jae_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","Amboac tonaŋ Batseba kêsô kiŋnê balêm gêja (kiŋ tau kêtu ŋamalacanô su ma Abisag aŋga Sunem gêjam sakiŋ eŋ). ");
INSERT INTO jae_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","Batseba gewec ma gêu tau gêc kiŋ akaiŋŋa. Ma kiŋ kêtu kênac gebe “Ŋalêlôm kêkac aôm kêtu asageŋŋa.” ");
INSERT INTO jae_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","Eŋ gêjô eŋ awa gebe “Ŋoc ŋatau, aôm kôtôc lêmam gêdêŋ nêm sakiŋwagao aê kôkô Apômtau, aômnêm Anôtô, laŋônêm ma kôsôm gebe ‘Nêm latôm Salomo oc ênam gôliŋ êjô aê su ma eŋ oc êŋgôŋ ŋoc lêpôŋ.’ ");
INSERT INTO jae_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","Ma galoc, ôlic acgom, Adonia kêtu kiŋ, ma aôm kiŋ gôjam kauc gêŋ tau. ");
INSERT INTO jae_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","Eŋ kêkêŋ bulimakao to ŋalatu, taŋ segeŋ e kêtôp ŋajam naŋ, ma domba taêsam ŋasec kêtu da ma kêkêŋ jaeŋ kiŋ latui samob to dabuŋwaga Abiatar ma siŋwaga nêŋ ŋac ŋamataŋa Joab, mago latôm Salomo tec keteŋ eŋ gêwiŋ atom. ");
INSERT INTO jae_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","O ŋoc ŋatau kiŋ, galoc lau Israel samob sêkêŋ mateŋ aôm gebe ôsôm êndêŋ êsêac gebe asa êŋgôŋ aêŋoc ŋatau kiŋ nê lêpôŋ êjô aôm su. ");
INSERT INTO jae_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","Embe masi oc êndêŋ taŋ ŋoc ŋatau kiŋ ênêc nê bêc êwiŋ tamai naŋ aêagêc latuc Salomo oc atap ŋagêjô sa.” ");
INSERT INTO jae_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","Gêdêŋ taŋ eŋ gêjam biŋgalôm gêdêŋ kiŋ gêmoa naŋ, propete Natan gêô lasê. ");
INSERT INTO jae_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","Ma êsêac sêkêŋ ŋawae gêdêŋ kiŋ tau gebe “Propete Natan tec gêmoa tonec.” Ma gêdêŋ Natan kêsô gêdêŋ kiŋ gêja naŋ, eŋ gewec gêdêŋ kiŋ, laŋôanô gêdêŋ nom. ");
INSERT INTO jae_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","Ma Natan kêsôm gebe “Ŋoc ŋatau kiŋ, aôm oc kôsôm gebe Adonia êtu kiŋ êjô aê su ma êŋgôŋ aêŋoc lêpôŋ me masi. ");
INSERT INTO jae_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","Gebe eŋ kêsêp gêja gêdêŋ ocsalô tonec ma kêkêŋ bulimakao kapoac to ŋalatu, taŋ segeŋ e kêtôp ŋajam naŋ ma domba taêsam ŋasec kêtu da ma kêkêŋ jaeŋ kiŋ latui ma siŋwaga nêŋ ŋac ŋamataŋa Joab ma dabuŋwaga Abiatar. Ma ôlic acgom, êsêac seŋ to sênôm sêwiŋ eŋ ma sêsôm gebe ‘Kiŋ Adonia êmoaôŋ. ");
INSERT INTO jae_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","Mago eŋ kêkêŋ jaeŋ gêdêŋ nêm sakiŋwaga aê to gêdêŋ dabuŋwaga Sadok ma Jehoiada latu Benaia agêc latôm Salomo atom. ");
INSERT INTO jae_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","O ŋoc ŋatau kiŋ, aôm kômasaŋ biŋ amboac tonaŋ ma kôkêŋ ŋac, taŋ êŋgôŋ ŋoc ŋatau nê lêpôŋ êjô aôm su naŋ, ŋawae gêdêŋ nêm sakiŋwaga aêac atom me.” ");
INSERT INTO jae_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","Go kiŋ Dawid gêjô Natan nê biŋ gebe “Ômôêc Batseba êndêŋ aê êmêŋ.” Amboac tonaŋ eŋ kêsô gêdêŋ kiŋ jakêkô eŋ laŋônêm. ");
INSERT INTO jae_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","Ma kiŋ kêtôc lêma to kêsôm gebe “Kêtu Apômtau gêŋgôŋ mata jali ma gêjam aê katuc kêsi gêdêŋ gêŋwapac samobŋa, ");
INSERT INTO jae_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","tec jaŋgôm biŋ, taŋ katôc lemoc gêdêŋ aôm gajam Apômtau, Israel nêŋ Anôtô laŋô to kasôm gebe ‘Nem latôm Salomo ênam gôliŋ êjô aê su êŋgôŋ ŋoc lêpôŋ êjô aê’ naŋ oc ŋanô êsa êndêŋ ocsalô tonec.” ");
INSERT INTO jae_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","Go Batseba gewec laŋôanô gêdêŋ nom ma ketoc kiŋ tau sa ma kêsôm gebe “Ŋoc ŋatau kiŋ Dawid êmoa teŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Kiŋ Dawid kêsôm gebe “Ômôêc dabuŋwaga Sadok agêc propete Natan ma Jehoiada latu Benaia dêndêŋ aê sêmêŋ.” Amboac tonaŋ êsêac dêdêŋ kiŋ tau sêja. ");
INSERT INTO jae_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","Ma kiŋ tau kêsôm gêdêŋ êsêac gebe “Akôc nêm ŋatau nê sakiŋwaga sêwiŋ amac ma akêŋ latuc Salomo êŋgôŋ aê taucŋoc doŋki ŋac akôc eŋ asêp andêŋ bumata Gihon ana. ");
INSERT INTO jae_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Ma dabuŋwaga Sadok agêc propete Natan sêniŋ oso eŋ aŋga tonaŋ êtu Israelnêŋ kiŋ. Go anac dauc êtaŋ ma amôêc gebe ‘Kiŋ Salomo êmoa teŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Go amac api andaŋguc eŋ ma eŋ mêŋêŋgôŋ ŋoc lêpôŋ ŋaô gebe eŋ oc êtu kiŋ êjô aê su. Gebe aê kakêŋ eŋ kêtu lau Israel to Juda nêŋ gôliŋwaga.” ");
INSERT INTO jae_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Ma Jehoiada latu Benaia gêjô kiŋ awa gebe” Biŋŋanô, Apômtau, ŋoc ŋatau kiŋ nê Anôtô kêsôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Apômtau êmoa êwiŋ Salomo êtôm gêmoa gêwiŋ ŋoc ŋatau kiŋ tau ma êŋgôm ênê gôliŋ êtu kapôêŋ alêlêc ŋoc ŋatau kiŋ Dawid nê su.” ");
INSERT INTO jae_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Amboac tonaŋ dabuŋwaga Sadok agêc propete Natan ma Jehoiada latu Benaia ma lau Keret to Pelet sêsêp sêja ma sêkêŋ Salomo gêŋgôŋ kiŋ Dawid nê doŋki ma sêkôc eŋ dêdêŋ bumata Gihon sêja. ");
INSERT INTO jae_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Aŋga tonaŋ dabuŋwaga Sadok kakôc ŋoplakôp katêkwiŋa aŋga becobo ma geŋ oso Salomo. Go sêjac dauc kêtaŋ ma lau samob sêsôm gebe “Kiŋ Salomo êmoa teŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","Ma lau samob, taŋ têdaguc eŋ naŋ, sêju gasuc to sêjac oŋ ma têtu samuc toŋabêlêc kapôêŋ, e nom gêôc kêkôc kêtu êsêacnêŋ ŋaônduŋa. ");
INSERT INTO jae_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","Adonia to nê ŋacleŋ samob, taŋ sêmoa sêwiŋ eŋ naŋ, sêŋô biŋ tau gêdêŋ taŋ seŋ moasiŋ tau gêbacnê. Ma gêdêŋ taŋ Joab gêŋô dauc kêtaŋ naŋ, eŋ kêtu kênac gebe “Ŋaonda aŋga malac nec ŋam amboac ondoc.” ");
INSERT INTO jae_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","Gêdêŋ taŋ eŋ kêsôm biŋ gêmoa naŋ, dabuŋwaga Abiatar latu Jonatan gêmêŋ ma Adonia kêsôm gebe “Ôsô ômôêŋ gebe aôm ŋac mansaŋ tec kôkôc ŋawae ŋajam gômôêŋ.” ");
INSERT INTO jae_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","Jonatan gêjô Adonia awa gebe “Aec, gebe ŋoc ŋatau kiŋ Dawid kêkêŋ Salomo kêtu kiŋ. ");
INSERT INTO jae_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","Ma kiŋ tau kêsakiŋ dabuŋwaga Sadok agêc propete Natan ma Jehoiada latu Benaia sêwiŋ lau Keret to Pelet ma êsêac sêkêŋ eŋ gêŋgôŋ kiŋnê doŋki ŋaô ");
INSERT INTO jae_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","ma dabuŋwaga Sadok agêc propete Natan seŋ oso eŋ kêtu kiŋ aŋga bumata Gihon ma êsêac sêmu sêpi aŋga tonaŋ tolasêgeŋ e malac samucgeŋ ŋadindiŋ kêsa. Ŋakicsêa taŋ amac aŋô naŋ, ŋam tau tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","Salomo jagêŋgôŋ lêpôŋ kiŋŋa. ");
INSERT INTO jae_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","Ma kiŋ nê sakiŋwaga sêja sêsôm biŋ êmoa ŋajamŋa gedeŋ aêacnêŋ ŋatau kiŋ Dawid ma sêsôm gebe ‘Nem Anôtô êwaka Salomo nê ŋaê sa êlêlêc aômnêm ma êŋgôm ênê gôliŋ êtu kapôêŋ êlêlêc aômnêm su.’ Ma kiŋ tau gêŋgôŋ nê mê ma gewec. ");
INSERT INTO jae_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","Ma kêsôm amboac tonec gebe ‘Aê aoc êôc Apômtau, lau Israel nêŋ Anôtô, taŋ galoc kêkêŋ aê galic ŋa tauc matocanô gebe ŋoc wakuc nêŋ teŋ gebe êŋgôŋ ŋoc lêpôŋ naŋ.’” ");
INSERT INTO jae_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","Go Adonia nê ŋacleŋ samob têtakê ma dêdi e sêc êliŋ-êliŋ sêja. ");
INSERT INTO jae_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","Ma Adonia kêtêc Salomo. Tec eŋ gêdi jakêkam jabo altarŋa tôŋ. ");
INSERT INTO jae_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","Ŋawae gêdêŋ Salomo gebe “Ôlic acgom, Adonia katêc kiŋ Salomo ma eŋ jakêkam jabo altarŋa tôŋ ma kêsôm gebe ‘Kiŋ Salomo êtôc lêma sa êndêŋ aê gebe ênac aê ŋa siŋ atom.’” ");
INSERT INTO jae_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","Tec Salomo kêsôm gebe “Eŋ embe êwaka tau sa gebe eŋ ŋac ŋaŋêŋ, go teŋ êmoasac eŋ môkêlauŋ teŋ atom. Mago embe têtap ênê sec sa, go eŋ êmac êndu.” ");
INSERT INTO jae_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","Amboac tonaŋ kiŋ Salomo kêsakiŋ lau ma sêkôc eŋ su aŋga altar. Ma êsêac sêmêŋ, go eŋ gêu tau gêdêŋ kiŋ Salomo. Ma Salomo kêsôm gedeŋ eŋ gebe “Ôêc ôndêŋ nêm andu ôna.” ");
INSERT INTO jae_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Gêdêŋ taŋ Dawid nê noc êmac ênduŋa kêtu dambê naŋ, eŋ kêjatu latu Salomo ma kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“Aê oc jasa intêna, naŋ gêŋ nomŋa samob sêja-sêja naŋ jana. Ôkô ŋajaŋa ôtôm ŋacgeŋ. ");
INSERT INTO jae_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Ôŋgôm nêm kôm ŋaŋêŋgeŋ êtu Apômtau, aômnêm Anôtôŋa. Ôsa ênê lêŋ ma ôŋgôm ênê jatu to biŋsu ma gôliŋ ŋanô êsa êtôm teto gêc Mosenê biŋsu gebe ômoa ŋajamgeŋ gebe ôtap nêm kôm to lêŋ samob ŋaŋanô sa. ");
INSERT INTO jae_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Gebe Apômtau êŋgôm biŋ, taŋ gêjac mata gêdêŋ aê naŋ ŋanô êsa. Eŋ gêjac mata biŋ gebe ‘Nêm latômi embe sejop nêŋ lêŋ e sêsêlêŋ semoa aê laŋôcnêmŋa ŋaŋêŋgeŋ toŋalêlôm samucgeŋ ma tokatuŋ samucgeŋ, go aôm ôpô lêna nêm wakuc teŋ gebe êŋgôŋ Israel nêŋ lêpôŋ êjô aôm nec atom.’ ");
INSERT INTO jae_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","“Aôm taôm kôjala gêŋ, taŋ Seruia latu Joab gêgôm gêdêŋ aê ma gêŋ, taŋ eŋ gêgôm gêdêŋ Israelnêŋ siŋwaga nêŋ siŋsêlêc laŋgwa luagêc, Ner latu Abner agêc Jeter latu Amasa. Eŋ gêjac êsêagêc êndu gêdêŋ têm wamaŋa gêjô dec, taŋ êsêagêc sêkêc siŋ gêdêŋ têm siŋŋa naŋ. Ma kêtiŋ lau laŋôŋnêm sawa nêŋ dec gi aêŋoc ômbiŋkap to ŋoc atapa. ");
INSERT INTO jae_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","Ôŋgôm êtôm nêm kauc, mago ôkêŋ êwiŋ gebe eŋ êsêp lamboam êna towamageŋ atom. ");
INSERT INTO jae_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","Mago ômoasiŋ ŋac Gileadŋa Barsilai latui. Êsêac sêniŋ nêŋ gêŋ sêŋgôŋ nêm tebo gebe êsêac sêmoasiŋ aê amboac tonaŋgeŋ gêdêŋ têm, taŋ aê gaêc têwam Absalom su naŋ. ");
INSERT INTO jae_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","Ma Gera latu Simei, ŋac Benjaminŋa aŋga Bahurim gêmoa gêwiŋ aôm. Ŋac tonaŋ kêpuc boa aê secanôtêna gêdêŋ bêc, taŋ aê gaja Mahanaim naŋ. Mago gêdêŋ taŋ eŋ kêsêp jagêdac aê aŋga bu Jordan naŋ, aê katôc lemoc eŋ kakô Apômtau laŋônêm ma kasôm gebe ‘Aê oc janac aôm êndu ŋa siŋ atom.’ ");
INSERT INTO jae_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","Mago aôm ôlic eŋ amboac ŋac tobiŋmê atom. Aôm ŋac tokauc, aôm kôjala gebe oc ôŋgôm asageŋ êndêŋ eŋŋa gebe ôkêŋ eŋ êsêp lamboam êna todecgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Go Dawid gêc nê bêc gêwiŋ tamai ma sêsuŋ eŋ aŋga Dawidnê malac. ");
INSERT INTO jae_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Ma têm, taŋ Dawid gêjam gôliŋ Israel naŋ, kêtôm jala 40. Eŋ gêjam gôliŋ jala 7 aŋga Hebron ma jala 33 aŋga Jerusalem. ");
INSERT INTO jae_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Amboac tonaŋ Salomo gêŋgôŋ tama Dawid nê lêpôŋ ma nê gôliŋ kiŋŋa ŋajaŋa kêsa. ");
INSERT INTO jae_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","Ma Hagit latu Adonia gêdêŋ Salomo têna Batseba gêja. Ma awê tau kêsôm gebe “Aôm gômôêŋ towamageŋ me masi.” Ma Adonia kêsôm gebe “Aê gamêŋ towama.” ");
INSERT INTO jae_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","Go ŋac tau kêsôm gebe “Aê gabe jasôm biŋ teŋ êndêŋ aôm.” Ma Batseba kêsôm gebe “Ôsômmaŋ.” ");
INSERT INTO jae_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","Eŋ kêsôm gebe “Aôm kôjala gebe gôliŋ kiŋŋa kêtu aêŋoc ma lau Israel samob sêsaê gebe aê jatu kiŋ tau. Mago galoc gêŋ tonaŋ gêjam tau ôkwi ma gôliŋ kiŋŋa kêtu ŋoc lasicnê, gebe Apômtau gêgôm amboac tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","Ma galoc aêŋoc biŋ tageŋgeŋ gêc gebe jateŋ êndêŋ aôm gebe onseŋ ŋoc biŋ atom.” Batseba kêsôm gêdêŋ eŋ gebe “Ôsôm acgom.” ");
INSERT INTO jae_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","Eŋ kêsôm gebe “Ônam biŋgalôm êndêŋ kiŋ Salomo, eŋ oc enseŋ aômnêm biŋ atom, gebe eŋ êkêŋ Abisag aŋga Sunem êndêŋ aê janam eŋ êtu ŋoc awê.” ");
INSERT INTO jae_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","Batseba kêsôm gebe “Ŋajam, aê gabe janam biŋgalôm êndêŋ kiŋ êtu aômŋa.” ");
INSERT INTO jae_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","Tec Batseba kêsô gêdêŋ kiŋ Salomo gêja gebe ênam biŋgalôm êndêŋ eŋ êtu Adoniaŋa. Ma kiŋ tau gêdi sa ma kêpuc eŋ tôŋ-tôŋ ma gewec gêdêŋ eŋ, go gêŋgôŋ nê lêpôŋ ma sêkêŋ lêpôŋ teŋ kêtu kiŋ tênaŋa gêwiŋ ma gêŋgôŋ sic gêŋgôŋ kiŋ nê anôŋa. ");
INSERT INTO jae_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","Go eŋ kêsôm gebe “Aê kakôc biŋ sauŋ teŋ gebe jateŋ êndêŋ aôm. Onseŋ aê atom.” Kiŋ tau gêjô eŋ awa gebe “O tinoc, oteŋ acgom. Aê oc janseŋ aôm atom.” ");
INSERT INTO jae_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","Go eŋ kêsôm gebe “Takêŋ Abisag aŋga Sunem êndêŋ aôm têwam Adonia ênam êtu nê awê.” ");
INSERT INTO jae_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","Go kiŋ Salomo gêjô têna awa ma kêsôm gebe “Kêtu asageŋŋa aôm koteŋ Abisag aŋga Sunemŋageŋ kêtu Adoniaŋa. Oteŋ gôliŋ kiŋŋa êtu eŋŋa êwiŋmaŋ. Eŋ kêtu aê teocgoc ma dabuŋwaga Abiatar agêc Seruia latu Joab sêkô jabaŋ eŋ.” ");
INSERT INTO jae_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","Ma kiŋ Salomo kêtôc lêma gêdêŋ Apômtau ma kêsôm gebe “Anôtô êŋgôm gêŋ, taŋ taê gêjam naŋ, êndêŋ aê, mago Adonia êmac êndu êjô nê biŋ tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","Apômtau kêkêŋ aê gaŋgôŋ tamocnê lêpôŋ ma gêjac m aêŋoc gôlôac kêtôm eŋ gêjac mata naŋ. Kêtu Apômtau gêmoa mata jaliŋa, tec ocsalô tonecgeŋ Adonia êmac êndu.” ");
INSERT INTO jae_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","Amboac tonaŋ kiŋ Salomo kêsakiŋ Jehoiada latu Benaia ma eŋ jagêjac Adonia êndu. ");
INSERT INTO jae_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","Ma kiŋ tau kêsôm gêdêŋ dabuŋwaga Abiatar gebe “Ôna Anatot ôndêŋ nêm andu gebe gôjac ŋawae gebe aôm ômac êndu, mago aê gabe janac aôm êndu galoc atom gebe aôm kôbalaŋ Apômtau Anôtô nê poac ŋakatapa kôsêlêŋ gômuŋ aê tamoc Dawid ma gôc gêŋwapac samob gôwiŋ tamoc.” ");
INSERT INTO jae_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","Amboac tonaŋ Salomo kêtiŋ Abiatar gebe êtu Apômtaunê dabuŋwaga êtiam atom, gebe Apômtaunê biŋ ŋanô êsa, taŋ kêsôm kêtu Elinê gôlôac aŋga Silo naŋ. ");
INSERT INTO jae_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","Gêdêŋ taŋ ŋawae kêtap Joab sa naŋ, (gebe Joab kêpuc Adonia tôŋ, mago kêpuc Absalom tôŋ atom) eŋ gêc gêdêŋ Apômtaunê becobo jakêkam jabo altarŋa tôŋ. ");
INSERT INTO jae_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","Ma êsêac sêsôm ŋawae gêdêŋ kiŋ Salomo gebe “Joab gêc gêdêŋ Apômtaunê becobo gêja ma ôlic acgom, eŋ kêkô kêsi altar.” Tec Salomo kêsakiŋ ŋacjaeŋ teŋ gêdêŋ Joab ma kêtu kênac eŋ gebe “Gôêc gôdêŋ altar gôja katu asageŋŋa.” Joab gêjô eŋ awa gebe gêc gadêŋ Apômtau gebe kêtêc Salomo. Amboac tonaŋ Salomo kasakiŋ Jehoiada latu Benaia ma kêsôm gebe “Ôna ma ônac eŋ êndu.” ");
INSERT INTO jae_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","Amboac tonaŋ Benaia jagêô lasê Apômtaunê becobo ma kasôm gadêŋ Joab gebe “Kiŋ tau kêjatu gebe ‘Ôsa ômôêŋ.’” Mago eŋ kêsôm gebe “Masi, aê gabe jamac êndu aŋga tonec.” Go Benaia jakêsôm biŋ tau gêdêŋ kiŋ kêtiam ma kêsôm gebe Joab kêsôm amboac tonaŋ ma eŋ gêjô aê aoc amboac tonec. ");
INSERT INTO jae_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","Kiŋ tau gêjô eŋ awa gebe “Ôŋgôm êtôm eŋ kêsôm. Ônac eŋ êndu ma ônsuŋ eŋ. Ma gêŋ tonaŋ êkac tôp su aŋga aê to tamoc nê gôlôac êtu dec, taŋ Joab kêkêc siŋ ŋam masiŋa naŋ. ");
INSERT INTO jae_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","Apômtau êkêŋ eŋ taunê dec êpi eŋ tau gebe tamoc Dawid gêjam kauc ma eŋ gêjac ŋac gêdêŋ to ŋajam luagêc, taŋ sêlêlêc eŋ tau naŋ, ŋa siŋ êndu, siŋwaga Israelŋa nêŋ laumata Ner latu Abner agêc Jeter latu Amasa. ");
INSERT INTO jae_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","Amboac tonaŋ êsêagêc nêŋ dec êmu naêpi Joab to nê wakuc. Mago Apômtau êkêŋ wama êndêŋ Dawid to nê wakuc ma nê gôlôac to nê lêpôŋ kiŋŋa endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","Go Jehoiada latu Benaia kêpi gêja ma gêjac Joab êndu. Ma sêsuŋ eŋ aŋga eŋ tau nê andu, taŋ kêkô gamêŋ sawa naŋ. ");
INSERT INTO jae_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","Kiŋ tau kêkêŋ Jehoiada latu Benaia kêtu siŋwaga nêŋ ŋac ŋamataŋa gêjô Joab su ma kêkêŋ dabuŋwaga Sadok gêjô Abiatar su. ");
INSERT INTO jae_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","Go kiŋ tau kêsakiŋ biŋ gêdêŋ Simei to gêmôêc eŋ ma kêsôm gêdêŋ eŋ gebe “Ôkwê nêm andu teŋ êkô Jerusalem ma ômoa tonec ma aŋga tonec aôm ôwi gamêŋ tonec siŋ naôsa gamêŋ teŋ atomanô. ");
INSERT INTO jae_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","Taêm ênam ŋapep, êndêŋ bêc taŋ aôm ôsa naolom bu Kidron naŋ, aôm ômac êndu. Ma dec êpi aôm taôm.” ");
INSERT INTO jae_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","Ma Simei kêsôm gêdêŋ kiŋ gebe “Biŋ taŋ kôsôm naŋ, ŋajam. Nêm sakiŋwaga êŋgôm êtôm ŋoc ŋatau kiŋ kêsôm.” Amboac tonaŋ Simei gêŋgôŋ Jerusalem ŋasawa ŋêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","Mago gêdêŋ taŋ jala têlêac gêjaŋa naŋ, Simeinê gêŋôma luagêc sêbôm dêdêŋ kiŋ Gatŋa Maka latu Akis sêja. Ma Simei gêŋô ŋawae gebe “Gôlicgac me, nêm gêŋôma luagêc jasêmoa malac Gat.” ");
INSERT INTO jae_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","Tec Simei gêdi kêmasaŋ nê doŋki ma gêdêŋ Akis aŋga Gat gêja gebe ensom nê gêŋôma. Simei gêja ma kêkôc nê gêŋôma aŋga Gat gêmu gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","Salomo gêŋô ŋawae gebe Simei aŋga Jerusalem gêja Gat ma gêmu gêmêŋ. ");
INSERT INTO jae_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","Tec kiŋ tau kêsakiŋ biŋ gêdêŋ Simei ma gêmôêc eŋ ma kêsôm gêdêŋ eŋ gebe “Aê kakêŋ aôm kôtôc lêmam gêdêŋ Apômtau ma gajac biŋsu aôm atom me. Aê kasôm gêdêŋ aôm gebe taêm ênam ŋapep, êndêŋ bêc tau, taŋ aôm ôsa gamêŋ teŋ ôna naŋ, aôm ômac êndu. Ma aôm gajô aê aoc gebe Ŋajam, aê gaŋôgac. ");
INSERT INTO jae_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","Kêtu asageŋŋa aôm gôgôm biŋ, taŋ kôtôc lêmam gêdêŋ Apômtau naŋ, to biŋsu taŋ kakêŋ gêdêŋ aôm naŋ, ŋanô kêsa atom.” ");
INSERT INTO jae_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","Ma kiŋ kêsôm gêdêŋ Simei gebe “Aôm taôm kôjala gêŋ sec samob, taŋ aôm gôgôm gêdêŋ aê tamoc Dawid. Galoc Apômtau êkêŋ aômnêm sec êpi aôm taôm môkêmapac. ");
INSERT INTO jae_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","Mago eŋ oc ênam mec kiŋ Salomo ma Dawidnê lêpôŋ êkô ŋajaŋa ma êkô Apômtau laŋônêmŋa endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","Ma kiŋ tau kêjatu Jehoiada latu Benaia, taŋ kêsa gêja ma gêjac Simei êndu. Gêdêŋ tonaŋ gôliŋ kiŋŋa gêc Salomo lêma kêtu tôŋ. ");
INSERT INTO jae_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","Go Salomo kêmoatiŋ poac gêwiŋ lau Aiguptunêŋ kiŋ Parao ma gêjam Parao latuo kêtu nê awê ma kêkôc eŋ jagêŋgôŋ Dawidnê malac acgom, e eŋ gêjac dabiŋ tau nê andu kapôêŋ to Apômtaunê lôm dabuŋ ma tuŋbôm, taŋ kêgi Jerusalem auc naŋ, ŋakôm. ");
INSERT INTO jae_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","Mago lau sêkêŋ da aŋga gamêŋ ŋabau ŋapaŋ gebe gêdêŋ ŋasawa tonaŋ sêkwê andu teŋ kêtu Apômtaunê ŋaêŋa su atom tageŋ. ");
INSERT INTO jae_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Mago Salomo têtac gêwiŋ Apômtau ma kêsêlêŋ kêtôm tama Dawid nê ŋagôliŋ, tageŋ eŋ kêkêŋ da to gêsôb jadauŋ aŋga gamêŋ ŋabau gêwiŋ. ");
INSERT INTO jae_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Gêdêŋ ŋasawa teŋ kiŋ gêja Gibeon gebe êkêŋ da aŋga tonaŋ, gebe gamêŋ tonaŋ kêtu gamêŋ ŋabau towae kapôêŋ kêlêlêc. Salomo kêkêŋ daja 1,000 aŋga altar tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Aŋga Gibeon Apômtau geoc tau lasê gêdêŋ Salomo ŋa mê gêdêŋ gêbêc ma Anôtô kêsôm gebe “Oteŋ gêŋ teŋ, taŋ jakêŋ êndêŋ aôm naŋ.” ");
INSERT INTO jae_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","Salomo kêsôm gebe “Aôm kômoasiŋ nêm sakiŋwaga aê tamoc Dawid ŋanôgeŋ gebe eŋ kêsêlêŋ gêmoa aôm laŋômnêm tobiŋgêdêŋ ma laŋônêm sawageŋ. Ma aôm gôjac têku nêm moasiŋ tonaŋ ma kôkêŋ latu, taŋ galoc gêŋgôŋ ênê lêpôŋ naŋ, gêdêŋ eŋ. ");
INSERT INTO jae_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","O Apômtau, ŋoc Anôtô, galoc aôm kôkêŋ nêm sakiŋwaga kêtu kiŋ gêjô aê tamoc Dawid su, mago aê amboac ŋapalê sauŋ teŋ tec gamoa. Aê kapô lêna lêŋ jasa to jasô janaŋa. ");
INSERT INTO jae_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Ma nêm sakiŋwaga aê kakô nêm lau, taŋ aôm kôjaliŋ sa naŋ, ŋalêlôm. Êsêac lau-m kapôêŋanô e ŋac teŋ êtôm êsa êsêac sa to êsam nêŋ ŋanamba lasê êŋgôm êtôm atom. ");
INSERT INTO jae_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Amboac tonaŋ ôkêŋ ŋalêlôm tokauc êndêŋ nêm sakiŋwaga aê gebe janam gôliŋ nêm lau ŋapep to jajala ŋajam to sec gebe asa êtôm gebe ênam gôliŋ nêm lau-m kapôêŋ tonec.” ");
INSERT INTO jae_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Apômtau gêŋô biŋ, taŋ Salomo keteŋ naŋ ŋajam. ");
INSERT INTO jae_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Ma Anôtô kêsôm gêdêŋ eŋ gebe “Aôm koteŋ gêŋ tonaŋ ma koteŋ kêtu ômoa nom e ŋêŋgeŋ me ôtap awa taêsam sa me ôku nêm ŋacjo tuluŋa nec atom. Mago koteŋ mêtê tokaucŋa gebe ôjala gêŋ ŋajam to gêdêŋŋa. ");
INSERT INTO jae_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Tec ôlic acgom, galoc aê jaŋgôm biŋ, taŋ koteŋ naŋ, ŋanô êsa. Ôlic acgom, aê oc jakêŋ ŋalêlôm tokauc, taŋ êjala biŋ naêndêŋgeŋ êndêŋ aôm. Ŋac teŋ kêtap ŋalêlôm amboac tonaŋ sa gêmuŋ aôm atom ma teŋ oc êndaŋguc aôm atom amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Ma gêŋ taŋ koteŋ atom naŋ, aê gabe jakêŋ êndêŋ aôm amboac tonaŋ. Aê oc jakêŋ awamata to waem, taŋ kiŋ teŋ kêtap sa atom tageŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Ma aôm embe ôsa aêŋoc lêŋ ma ojop ŋoc ŋagôliŋ to biŋsu êtôm tamam Dawid kêmasaŋ naŋ, go aê gabe janac têku nêm têm ômoa matam jaliŋa ŋêŋgeŋ êwiŋ.” ");
INSERT INTO jae_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Ma Salomo mata gêlac ma gêlic gebe gêc mê teŋ. Go eŋ gêmu gêja Jerusalem ma jakêkô Apômtaunê poac ŋakatapa ŋanêmŋa ma kêkêŋ daja to dawama ma geno moasiŋ kapôêŋ teŋ kêtu nê sakiŋwaga samobŋa. ");
INSERT INTO jae_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Gêdêŋ tonaŋ mockaiŋo luagêc dêdêŋ kiŋ sêja ma sêkô eŋ laŋônêm. ");
INSERT INTO jae_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Ma awê teŋ kêsôm gebe “O ŋoc ŋatau, ôŋô acgom. Aêagêc awê tonec aŋgôŋ andu tageŋ. Eŋ gêmoa ma aê kakôc ŋapalê teŋ. ");
INSERT INTO jae_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Bec têlêac gêjaŋa, gocgo eŋ kêkôc teŋ kêdaguc. Aêagêc aŋgôŋ awiŋ tauŋ ma teŋ gêmoa andu tau gêwiŋ atom. Aêagêc tauŋgeŋ tec amoa. ");
INSERT INTO jae_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Gêdêŋ gêbêc teŋ awê tonec nê ŋapalê gêmac êndu gebe eŋ gêsac eŋ êndu. ");
INSERT INTO jae_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Ma eŋ gêdi gêdêŋ gêbêcauc ma kêkôc ŋoc ŋapalê su aŋga aê gêdêŋ taŋ nêm sakiŋwagao gêc su naŋ, ma kêkêŋ gêlô tau nê su ma ketoc nê ŋapalê ŋamatê gêc gêwiŋ aê. ");
INSERT INTO jae_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Gêdêŋ bêbêc gadi sa gebe jakêŋ su ŋoc ŋapalê e galic gebe eŋ gêmac êndu su. Mago gêdêŋ bêbêc, gêdêŋ taŋ kasala eŋ ŋapep naŋ, aê kajala gebe ŋoc latuc, taŋ kakôc naŋ atom.” ");
INSERT INTO jae_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Mago awê teŋ kêsôm gebe “Masi, aêŋoc ŋapalê mata jali ma aômnêm ŋapalê ŋamatê.” Ma awê ŋamataŋa kêsôm gebe “Masi, aômnêm ŋapalê gêmac êndu ma mata jali aêŋoc.” Êsêagêc sêsôm amboac tonaŋ sêmoa kiŋ laŋônêmŋa. ");
INSERT INTO jae_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Go kiŋ tau kêsôm gebe “Awê teŋ kêsôm ŋapalê, taŋ gêmoa mata jali tonec naŋ, aêŋoc ma aôm latôm gêmac êndu matêgeŋ. Ma awê teŋ kêsôm gebe Masi, aômnêm ŋapalê gêmac êndu ma aê latuc tec mata jali gêmoa.” ");
INSERT INTO jae_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Ma kiŋ kasôm gebe “Akôc siŋ teŋ êndêŋ aê.” Amboac tonaŋ sêkôc siŋ teŋ dêdêŋ kiŋ sêja. ");
INSERT INTO jae_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Ma kiŋ tau kêsôm gebe “Asêlê ŋapalê mata jali êkôc êna luagêc ma akêŋ ŋamakeŋ êndêŋ awê teŋ ma ŋamakeŋ êndêŋ teŋ.” ");
INSERT INTO jae_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Go awê, taŋ nê latu mata jali gêmoa naŋ, taê walô nê ŋapalê ma kêsôm gêdêŋ kiŋ gebe “O ŋoc ŋatau, ônac ŋapalê êndu atom, eŋ mata jaligeŋ êndêŋ awê tonaŋ.” Ma awê teŋ kêsôm gebe “Ŋapalê êtu aêŋoc to ênê atom, asêlêmaŋ.” ");
INSERT INTO jae_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Go kiŋ tau gêjô êsêagêc aweŋ ma kêsôm gebe “Anac ŋapalê êndu atom, akêŋ eŋ tomata jaligeŋ êndêŋ awê ŋamataŋa gebe eŋ ŋapalê têna.” ");
INSERT INTO jae_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Israel samob sêŋô mêtôc tonaŋ, taŋ kiŋ tau kêmêtôc naŋ, ŋawae ma êsêac têtêc nêŋ kiŋ gebe êsêac sêjala gebe Anôtônê kauc gêwiŋ eŋ ma kêmêtôc biŋ jagêdêŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Gêdêŋ taŋ kiŋ Tirusŋa Hiram gêŋô gebe seŋ oso Salomo kêtu kiŋ gêjô tama su naŋ, eŋ kêsakiŋ nê sakiŋwaga gêdêŋ Salomo gebe Hiram têtac gêwiŋ Dawid ŋapaŋ. ");
INSERT INTO jae_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ma Salomo kêsakiŋ biŋ gêdêŋ Hiram gebe ");
INSERT INTO jae_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“Aôm kôjala gebe aê tamoc Dawid kêtôm gebe êkwê nê Apômtau Anôtô nê ŋaê ŋaandu teŋ atom gebe siŋ to ŋacjo kêgi eŋ auc e Apômtau kêkêŋ êsêac sêsô eŋ akaiŋ ŋalabu. ");
INSERT INTO jae_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Mago galoc Apômtau, ŋoc Anôtô, kêkêŋ wama gêdêŋ aê aŋga gamêŋ makeŋ-makeŋ ma ŋacjo me gêŋwapac teŋ sêmoa atom. ");
INSERT INTO jae_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Amboac tonaŋ aê gabe jakwê andu Apômtau, aêŋoc Anôtô nê ŋaê ênêcŋa teŋ kêtôm Apômtau kêsôm gêdêŋ aê tamoc Dawid gebe ‘Aôm latôm, taŋ aê gabe jakêŋ êŋgôŋ nêm lêpôŋ kiŋŋa êjô aôm su naŋ, eŋ êkwê andu teŋ êtu aêŋoc ŋaêŋa.’ ");
INSERT INTO jae_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Tec ôjatu gebe sêsap kaseda aŋga Lebanon êtu aêŋa. Aêŋoc sakiŋwaga sênam aômnêm sakiŋwaga sa. Ma aê oc janam ôli aôm êtu nêm sakiŋwagaŋa êtôm aôm ôsam êndêŋ aê. Gebe aôm kôjala gebe ŋac teŋ gêmoa aêac ŋalêlôm, taŋ kêjala kôm sêsap kaŋa kêtôm lau Sidonŋa naŋ atom.” ");
INSERT INTO jae_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","Gêdêŋ taŋ Hiram gêŋô Salomonê biŋ naŋ, eŋ kêtu samuc ŋanôgeŋ ma kêsôm gebe “Ocsalô tonec aoc êôc Apômtau gebe kêkêŋ latu tokauc teŋ gêdêŋ Dawid gebe ênam gôliŋ lau towae tonaŋ.” ");
INSERT INTO jae_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","Ma Hiram kêsakiŋ biŋ gêdêŋ Salomo ma kêsôm gebe “Aê gaŋô biŋ, taŋ kôsakiŋ gêdêŋ aê naŋ. Aê katôm gebe jaŋgôm gêŋ samob, taŋ ŋalêlôm kêkac aôm kêtu kaseda to katêŋŋa naŋ, ŋanô êsa. ");
INSERT INTO jae_vpl VALUES ("K15_9","012_5_9","1KI","5","9","9","Aêŋoc sakiŋwaga oc sêkôc ka tau aŋga Lebanon sêsêp gwêc sêna. Go jambec kwambôŋ gebe êpoac ma sênam sêmoa gwêcgeŋ sêna gamêŋ, taŋ aôm ôsôm naŋ, ma aê jajatu lau gebe sêndim ŋao su aŋga tonaŋ ma aôm ôtap ka tau sa. Go aôm ôŋgôm biŋ, taŋ taêc gêjam naŋ, ŋanô êsa ma ôkêŋ gêŋ taniŋŋa êndêŋ aêŋoc gôlôac to lau.” ");
INSERT INTO jae_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","Amboac tonaŋ Hiram kêkêŋ kaseda to katêŋ samob gêdêŋ Salomo kêtôm eŋ keteŋ, ");
INSERT INTO jae_vpl VALUES ("K15_11","012_5_11","1KI","5","11","11","ma Salomo kêkêŋ polom ŋanô talu 20,000 kêtu gêŋ taniŋŋa gêdêŋ Hiram nê gôlôac to nê lau ma niptêkwi gasuc kêtôm 20,000. Salomo kêkêŋ gêŋ tonaŋ gêdêŋ Hiram kêtôm jalageŋ. ");
INSERT INTO jae_vpl VALUES ("K15_12","012_5_12","1KI","5","12","12","Apômtau kêkêŋ kauc gêdêŋ Salomo kêtôm eŋ gêjac mata. Ma wama gêc Hiram agêc Salomo ŋasawa, ma êsêagêc sêmoatiŋ poac teŋ sêwiŋ tauŋ. ");
INSERT INTO jae_vpl VALUES ("K15_13","012_5_13","1KI","5","13","13","Kiŋ Salomo kêkac lau Israel gebe sêkêŋ ŋacwaga kêtu kômŋa. Ma lau tau nêŋ namba tau kêtôm 30,000. ");
INSERT INTO jae_vpl VALUES ("K15_14","012_5_14","1KI","5","14","14","Ma eŋ kêsakiŋ êsêac sêja Lebanon, 10,000 sêjô tauŋ-sêjô tauŋ kêtôm ajôŋgeŋ. Sêmoa ajôŋ teŋ aŋga Lebanon ma ajôŋ luagêc aŋga nêŋ malacmôkê. Adoniram gêjam gôliŋ lau kômŋa tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K15_15","012_5_15","1KI","5","15","15","Salomo kêkôc lau 70,000 amboac tonaŋ kêtu sêbalaŋ wabaŋa ma 80,000 kêtu sêsap poc aŋga gamêŋ lôcŋa. ");
INSERT INTO jae_vpl VALUES ("K15_16","012_5_16","1KI","5","16","16","Ma Salomo kêkêŋ lau 3,300 têtu gejobwaga kômŋa, taŋ sêjatu lau kômŋa. ");
INSERT INTO jae_vpl VALUES ("K15_17","012_5_17","1KI","5","17","17","Salomo kêjatu ma êsêac sêkôc poc ŋajamanô kapôêŋ-kapôêŋ sêmêŋ gebe êtu nombaŋ lôm dabuŋŋa. ");
INSERT INTO jae_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","Amboac tonaŋ Salomo agêc Hiram nêŋ lau sêkwêwaga sêwiŋ lau Gebalŋa sêsap to sêpa ka to poc gebe sêkwê andu tau. ");
INSERT INTO jae_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Jala 480 gêjaŋa su gêdêŋ taŋ lau Israel sêwi gamêŋ Aiguptuŋa siŋ sêsa sêmêŋ naŋ, ma Salomo gêjam gôliŋ Israel jala aclê su. Gêdêŋ jala tonaŋ ŋaajôŋ kêtu luagêcŋa, taŋ sêsam gebe Siw naŋ, Salomo gêjac m gebe êkwê Apômtaunê lômŋa. ");
INSERT INTO jae_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","Lôm tau, taŋ kiŋ Salomo kêkwê kêtu Apômtauŋa naŋ, ŋadôŋ amboac tonec gebe ŋalêsiŋŋa kêtôm saka samuc 15, ŋatakôcŋa kêtôm saka 5 ma ŋaatêkwa kêtôm saka 8. ");
INSERT INTO jae_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","Ma andu seleb, taŋ gêc anduanô tau ŋanêmŋa naŋ, ŋadôŋ saka 5, kêtôm lôm tau ŋakalopawa ma kêdaguc sagiŋ baliŋ anduanôŋa kêtôm ŋadôŋ saka samuc 2 ma ŋasêku. ");
INSERT INTO jae_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","Aŋga lôm tau ŋasagiŋ êsêac sêkêŋ katam sauŋ ŋagêdô gêc talic sauŋ aŋga awêŋa, mago kêsô gedec aŋga lêlômŋa. ");
INSERT INTO jae_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","Eŋ gêjac têku lômanô tau ŋasagiŋ baliŋ makeŋ-makeŋ ma ŋakalopawa ŋamuŋa amboac tonaŋgeŋ. Ma kêkwê ŋadeŋ têlêac tobalêm-tobalêm. ");
INSERT INTO jae_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","Ŋadêŋ ŋalabuŋa ŋakalopawa kêtôm ŋadôŋ saka samuc tageŋ. Deŋ kêtu luagêcŋa kêtôm ŋadôŋ saka samuc teŋ to ŋasêku lêmatuc teŋ, ma deŋ kêtu têlêacŋa ŋadôŋ saka teŋ ma ŋamakeŋ. Eŋ kêkêŋ demboŋgêdô kêtu baliŋ gêc kwanaŋgeŋ gebe sênac têku gêŋ sêmoa dêmôêŋageŋ. ");
INSERT INTO jae_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Gêdêŋ taŋ sêkwê lôm naŋ, êsêac sêkôc poc, taŋ sêpa sêmoa gamêŋ sêkôc pocŋa kwanaŋgeŋ su naŋ. Tec gêdêŋ taŋ sêkwê lôm dabuŋ sêmoa naŋ, lau sêŋô hama me ki me waba kômŋa ŋakicsêa teŋ atom. ");
INSERT INTO jae_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","Lôm tau ŋadeŋ ŋamataŋa ŋakatam gêc lôm dabuŋ ŋamakeŋ gêmu kêsêpŋa. Aŋga tônê têcwale teŋ kêpi deŋ kêtu luagêcŋa ma têcwale teŋ kêpi aŋga tônê jagêdêŋ deŋ kêtu têlêacŋa. ");
INSERT INTO jae_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","Amboac tonaŋ Salomo kêkwê lôm tau e gêbacnê ma eŋ kêmasaŋ masac jaba ŋaôŋa ŋa gamêŋtêkwa to katapa kaseda. ");
INSERT INTO jae_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","Eŋ kêkwê ŋatêku kêgi lôm auc. Ŋatêku tau gêmu kêpiŋa amboac saka samuc tageŋ ma gamêŋ têkwa kaseda kêtu ŋawalô teŋ jagêdiŋ ŋatêku tau tôŋ tamiŋ anduanô tau. ");
INSERT INTO jae_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Ma Apômtaunê biŋ gêdêŋ Salomo gebe ");
INSERT INTO jae_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“Aôm embe ôsêlêŋ êtôm ŋoc jatu to ômansaŋ ŋoc ŋagôliŋ samob ma taŋam wamu ŋoc biŋsu to ôsa lêŋ êtôm tonaŋ, go jaŋgôm ŋoc biŋ, taŋ gajac mata gêdêŋ tamam Dawid naŋ, ŋanô êsa êpi aôm. ");
INSERT INTO jae_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Aê wacjaŋgôŋ lau Israel ŋalêlôm aŋga lôm, tec kôkwê gômoa nec, ma jawi ŋoc lau Israel siŋ atomanô.” ");
INSERT INTO jae_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Go Salomo kêkwê lôm e gêjac dabiŋ. ");
INSERT INTO jae_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","Eŋ kêkwa sagiŋ ŋalêlômŋa auc ŋa katapa kaseda aŋga masac ŋalabuŋa e gêdiŋ kêsô ŋagadê ŋaôŋa. Eŋ kêkwa masac ŋalabuŋa tau ŋa katapa katêŋ. ");
INSERT INTO jae_vpl VALUES ("K16_16","012_6_16","1KI","6","16","16","Aŋga lôm ŋalêlômŋa eŋ gêjam dôŋ saka samuc lemeŋ teŋ aŋga sagiŋ ŋamuŋa ma kêpiŋ ŋasawa tonaŋ auc aŋga masac ŋalabuŋa e jagêdêŋ masac jaba ŋaôŋa ŋa katapa kaseda. Balêm tonaŋ kêtu Gamêŋ Dabuŋanô tau. ");
INSERT INTO jae_vpl VALUES ("K16_17","012_6_17","1KI","6","17","17","Gamêŋ Dabuŋ, taŋ gêc Gamêŋ Dabuŋanô tau ŋanêmŋa naŋ, baliŋ amboac ŋadôŋ saka 10. ");
INSERT INTO jae_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","Aŋga lôm ŋalêlôm talic poc teŋ atomanô, sêkwa sagiŋ auc ŋa kasedageŋ. Ma sêsap walô to ŋaola gêjac lêtêŋ ŋakatu gêjam katapa tau auc. ");
INSERT INTO jae_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","Eŋ kêmasaŋ gamêŋ Dabuŋanô tau gêc andu ŋalêlôm tau gebe etoc Apômtaunê poac ŋakatapa êkô tonaŋ. ");
INSERT INTO jae_vpl VALUES ("K16_20","012_6_20","1KI","6","20","20","Gamêŋ Dabuŋanô tau ŋasagiŋ baliŋ kêtôm saka samuc 5, ŋakalopawa kêtôm saka samuc 5 ma ŋasawa, taŋ geŋ masac ŋalabu to ŋaôŋa gêŋgic naŋ, kêtôm saka samuc 5 amboac tonaŋgeŋ. Ŋalêlôm tau Salomo kêkwa auc samucgeŋ ŋa gold ma kêmasaŋ altar teŋ ŋa kaseda. ");
INSERT INTO jae_vpl VALUES ("K16_21","012_6_21","1KI","6","21","21","Ma Salomo kêkwa andu ŋalêlôm auc ŋa gold. Ma gêjac balaŋ Gamêŋ Dabuŋanô tau ŋa kapoacwalô gold. ");
INSERT INTO jae_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","Ma Salomo kêkwa andu ŋalêlôm samucgeŋ auc ŋa gold e gêbacnê, ma altar, taŋ kêkô Gamêŋ Dabuŋanô tau ŋalêlôm naŋ, amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_23","012_6_23","1KI","6","23","23","Aŋga Gamêŋ Dabuŋanô tau ŋalêlôm eŋ kêkôc ka katêkwi ŋadambê luagêc ma kêsap kêtu aŋela kerub ŋakatu luagêc. Ŋakatu tau baliŋ kêtôm saka luagêc ma ŋasêku lulugeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_24","012_6_24","1KI","6","24","24","Kerub tau nê magê taŋ kêtôm saka samuc teŋ ma ŋasêku ma magê ŋamakeŋ kêtôm tonaŋgeŋ. Ma ŋasawa, taŋ geŋ aŋela teŋ nê magê luagêc gêŋgic naŋ, kêtôm saka luagêc ma ŋasêku. ");
INSERT INTO jae_vpl VALUES ("K16_25","012_6_25","1KI","6","25","25","Kerub teŋ baliŋ kêtôm saka luagêc amboac tonaŋgeŋ. Kerub ŋakatu lulugeŋ ŋadôŋ to ŋalaŋô kêtôm tau. ");
INSERT INTO jae_vpl VALUES ("K16_26","012_6_26","1KI","6","26","26","Ŋakatu lulugeŋ baliŋ kêtôm saka luagêc ma ŋasêku kêtôm taugeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","Eŋ ketoc kerub tonaŋ sêkô Gamêŋ Dabuŋanô tau. Kerub nêŋ ŋamagê gêlam e teŋ nê ŋamagê gêdiŋ sagiŋ ŋamakeŋ. Ma teŋ nê gêdiŋ sagiŋ ŋamakeŋ ônêŋa. Êsêagêc nêŋ ŋamagê ŋamakeŋ gêdiŋ tau aŋga andu tau ŋaluŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","Ma eŋ kêkwa aŋela kerub tau auc samucgeŋ ŋa gold. ");
INSERT INTO jae_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","Eŋ kêsap kerub to nip ma ŋaola ŋakatu e gêjam andu ŋasakiŋ samob auc ");
INSERT INTO jae_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","ma kêkwa masac balêm luagêcŋa tonaŋ auc ŋa gold. ");
INSERT INTO jae_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","Eŋ kêmasaŋ katam Gamêŋ Dabuŋanôŋa ŋa katapa katêkwiŋa. Katam tau ŋakêclêsu lemeŋteŋ. ");
INSERT INTO jae_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","Eŋ kepeŋ kerub to nip ma ŋaola gêjac lêtêŋ ŋakatu gêjam katam lulugeŋ auc ŋa gold. Ma gold kêpi kerub ma nip ŋakatu amboac tonaŋgeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","Eŋ kêmasaŋ Gamêŋ Dabuŋŋa ŋasacgêdô ŋakatam têkê-têkê ŋa katapa katêkwiŋa aclê. ");
INSERT INTO jae_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","Eŋ kêmasaŋ katam luagêc ŋa katêŋ. Katam luagêc tonaŋ talêc su dandibgeŋ. ");
INSERT INTO jae_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","Ma eŋ kêsap kerub to nip ma ŋaola gêjac lêtêŋ ŋakatu gêjam katam auc ma kêkwa ŋakatu samob auc ŋa gold e ŋapep. ");
INSERT INTO jae_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","Ma eŋ kêboa tuŋbôm kêgi malacluŋ ŋalêlômŋa auc. Eŋ kêkêŋ poc dênaŋ têlêac-têlêac, taŋ sêpa ŋatip kêsa naŋ, gêsac tau ŋaô ma kêkêŋ kaseda kêtu tuŋ tau ŋakanô. ");
INSERT INTO jae_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","Gêdêŋ jala katu aclê ŋaajôŋ Siw êsêac sêkêŋ Apômtaunê andu tau ŋanombaŋ. ");
INSERT INTO jae_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","Ma gêdêŋ jala kêtu 11ŋa ŋaajôŋ Bul, taŋ kêtu jala ŋaajôŋ 8ŋa naŋ, êsêac sêjac dabiŋ gêŋ samob, taŋ gêjac andu tau ŋawae naŋ, kêtôm sêmasaŋ kwanaŋgeŋ. Amboac tonaŋ Salomo kêkwê lôm dabuŋ kêtôm jala 7, go gêjac dabiŋ ŋakôm. ");
INSERT INTO jae_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Go Salomo kêkalem gejobwaga Israelŋa to lau Israel nêŋ gôlôacmôkê nêŋ laumata samob sêpi tageŋ sêmêŋ gêdêŋ eŋ aŋga Jerusalem gebe sêkôc Apômtaunê poac ŋakatapa aŋga Dawidnê malac, taŋ sêsam gebe Sion naŋ, sêpi lôm dabuŋ sêna. ");
INSERT INTO jae_vpl VALUES ("K18_2","012_8_2","1KI","8","2","2","Gêdêŋ ajôŋ kêtu 7ŋa ŋaê Etanim ŋacwaga Israelŋa samob sêkac tauŋ sa dêdêŋ kiŋ Salomo jasêlic ombec. ");
INSERT INTO jae_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Gêdêŋ taŋ gejobwaga Israelŋa samob sêô lasê su naŋ, dabuŋwaga sêôc poac ŋakatapa sa. ");
INSERT INTO jae_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Dabuŋwaga to lau Lewi sêbalaŋ Apômtaunê poac ŋakatapa to becobo takac saŋa ma laclu samob, taŋ gêc becobo ŋalêlôm naŋ, sêpi sêja. ");
INSERT INTO jae_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Ma kiŋ Salomo to gôlôac Israelŋa samob, taŋ sêkac tauŋ sa dêdêŋ eŋ naŋ, sêkô poac ŋakatapa nêmŋa ma sêkêŋ bulimakao to domba kêtu da. Teŋ kêtôm gebe êsa bulimakao to domba nêŋ namba sa atom. ");
INSERT INTO jae_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Go dabuŋwaga sêkôc Apômtaunê poac ŋakatapa sêja lôm dabuŋ ŋaGamêŋ Dabuŋanô tau ma tetoc kakô kerubnêŋ magê ŋalabu. ");
INSERT INTO jae_vpl VALUES ("K18_7","012_8_7","1KI","8","7","7","Kerub sêlam nêŋ magê kêpi poac ŋakatapa ŋamala kêtôm sêjam ajuŋ poac ŋakatapa to ta. ");
INSERT INTO jae_vpl VALUES ("K18_8","012_8_8","1KI","8","8","8","Ma ta tau kêsa baliŋ sêlic ŋatêpôê aŋga Gamêŋ Dabuŋ, taŋ gêc Gamêŋ Dabuŋanô tau ŋanêmŋa naŋ, mago sêlic aŋga awêŋa atom. Ma ta tau sêc tonaŋ e gêdêŋ galoc. ");
INSERT INTO jae_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","Gêŋ teŋ kêsêp poac ŋakatapa ŋalêlôm atom, poc tapa luagêcgeŋ, taŋ Mose kêkêŋ kêsêp aŋga lôc Horeb naŋ. Aŋga tônê Apômtau kêmoatiŋ poac gêwiŋ lau Israel gêdêŋ taŋ êsêac sêsa aŋga gamêŋ Aiguptu sêmêŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Ma gêdêŋ taŋ dabuŋwaga sêsa aŋga Gamêŋ Dabuŋ sêmêŋ naŋ, tao teŋ gêjam Apômtaunê lôm dabuŋ auc. ");
INSERT INTO jae_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","Tec dabuŋwaga têtôm gebe sêkô ma sênam sakiŋ kêtu tao tonaŋŋa atom, gebe Apômtaunê ŋawasi gêjam lôm dabuŋ auc. ");
INSERT INTO jae_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","Go Salomo kêsôm gebe “Apômtau kêkêŋ oc kêkô umboŋ, mago kêsôm gebe eŋ tau êŋgôŋ gamêŋ ŋakesec. ");
INSERT INTO jae_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","Aê kakwê nêm andu dabuŋ teŋ, nêm malam teŋ gebe ômoa endeŋ tôŋgeŋ.” ");
INSERT INTO jae_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","Go kiŋ tau kêkac tau ôkwi gêdêŋ lau Israel samob, taŋ sêkô naŋ, ma gêjam moc êsêac ");
INSERT INTO jae_vpl VALUES ("K18_15","012_8_15","1KI","8","15","15","ma eŋ kêsôm gebe “Aê aoc êôc Apômtau, lau Israel nêŋ Anôtô, taŋ lêma gêgôm biŋ, taŋ gêjac mata gadêŋ aê tamoc Dawid ŋa awasuŋ naŋ, ŋanô kêsa. Eŋ kêsôm gebe ");
INSERT INTO jae_vpl VALUES ("K18_16","012_8_16","1KI","8","16","16","‘Gêdêŋ bec, taŋ aê kakôc ŋoc lau Israel sêsa aŋga Aiguptu sêmêŋ naŋ, aê kajaliŋ malac teŋ aŋga Israel nêŋ toŋ samob sa gebe sêkwê andu teŋ ŋoc ŋaê ênêcŋa atom, mago aê kajaliŋ Dawid sa gebe ênam gôliŋ ŋoc lau Israel.’ ");
INSERT INTO jae_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","Ma aê tamoc Dawid taê gêjam gebe êkwê Apômtau, Israelnêŋ Anôtô, nê ŋaê ŋaandu teŋ. ");
INSERT INTO jae_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","Mago Apômtau tau kêsôm gêdêŋ aê tamoc Dawid gebe ‘Aôm taêm gêjam gebe ôkwê andu teŋ êtu aêŋoc ŋaêŋa naŋ, ŋajam gebe taêm gêjam ŋabiŋ tau gêc nêm ŋalêlôm, ");
INSERT INTO jae_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","mago aôm oc ôkwê andu tau atom, tageŋ nêm latôm, taŋ têna êkôc eŋ naŋ, eŋ êkwê andu êtu aêŋoc ŋaêŋa.’ ");
INSERT INTO jae_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","Galoc Apômtau gêgôm nê biŋ, taŋ gêjac mata naŋ, ŋanô kêsa gebe aê gadi gajô tamoc Dawid su ma gaŋgôŋ lêpôŋ Israelŋa katôm biŋ, taŋ Apômtau gajac mata naŋ, ma kakwê andu tau kêtu Apômtau, Israelnêŋ Anôtô nê ŋaêŋa. ");
INSERT INTO jae_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","Ma kakêŋ ŋamala teŋ katu katapa, taŋ Apômtaunê poac, taŋ eŋ kamoatiŋ gêwiŋ aêacnêŋ tameŋi gêdêŋ eŋ kêkôc êsêac sasa aŋga gamêŋ Aiguptu sêmêŋ naŋ kêsêp.” ");
INSERT INTO jae_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Go Salomo jakêkô Apômtaunê altar nêmŋa lau Israel samob sêlic ma eŋ gêlam lêma gêdêŋ undambê ");
INSERT INTO jae_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","ma keteŋ mec gebe “O Apômtau, Israelnêŋ Anôtô, anôtô teŋ kêtôm aôm gêmoa undambê ŋaôŋa me nom ŋalabu ŋa atom. Aôm gojob poac ma kôtôc nêm têmtac gêwiŋ teŋgeŋŋa gêdêŋ nêm sakiŋwaga, taŋ sêsa nêŋ lêŋ sêmoa aôm laŋômnêm tonêŋ ŋalêlôm samucgeŋ naŋ. ");
INSERT INTO jae_vpl VALUES ("K18_24","012_8_24","1KI","8","24","24","Aôm taêm gêjam biŋ, taŋ kôsôm gêdêŋ aê tamoc, nêm sakiŋwaga Dawid naŋ ŋapaŋ. Biŋŋanô, aôm kôsôm ŋabiŋ ŋa awamsuŋ ma gôgôm ŋanô kêsa ŋa lêmam gêdêŋ ocsalô tonec. ");
INSERT INTO jae_vpl VALUES ("K18_25","012_8_25","1KI","8","25","25","O Apômtau, Israelnê