﻿USE sofia;
DROP TABLE IF EXISTS sofia.jacNT_vpl;
CREATE TABLE jacNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jacNT_vpl WRITE;
INSERT INTO jacNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Haꞌ icham Abraham yeb naj rey David, haꞌ yichmam Comam Jesucristo. Hac tiꞌ ye istxolal yichmam Comam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Icham Abraham, haꞌ icham ismam naj Isaac, naj Isaac haꞌ naj ismam naj Jacob, naj Jacob, haꞌ naj ismam naj Judá yeb huntekꞌanxa yuẍtaj. ");
INSERT INTO jacNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Naj Judá, haꞌ naj ismam naj Fares yeb naj Zara, haꞌ xin ismiꞌ ebnaj cawan̈ tuꞌ haꞌ ton ix Tamar. Naj Fares haꞌ naj ismam naj Esrom, naj Esrom haꞌ naj ismam naj Aram. ");
INSERT INTO jacNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Naj Aram, haꞌ naj ismam naj Aminadab, naj Aminadab, haꞌ naj ismam naj Naasón, naj Naasón, haꞌ naj ismam naj Salmón. ");
INSERT INTO jacNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Naj Salmón, haꞌ naj ismam naj Booz, wal ismiꞌ naj Booz, haꞌ ton ix Rahab. Naj Booz, haꞌ naj ismam naj Obed, wal ismiꞌ naj Obed tuꞌ, haꞌ ton ix Rut. Naj Obed, haꞌ naj ismam naj Isaí. ");
INSERT INTO jacNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Naj Isaí, haꞌ naj ismam naj rey David. Haxa naj David, haꞌ naj ismam naj Salomón, ismiꞌ naj Salomón tuꞌ xin, haꞌ ton ix yixalticꞌa naj Urías yet yalan̈tocanoj. ");
INSERT INTO jacNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Wal naj Salomón, haꞌ naj ismam naj Roboam, naj Roboam, haꞌ naj ismam naj Abías, naj Abías, haꞌ naj ismam naj Asa. ");
INSERT INTO jacNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Naj Asa, haꞌ naj ismam naj Josafat, naj Josafat haꞌ naj ismam naj Joram, naj Joram, haꞌ naj ismam naj Uzías. ");
INSERT INTO jacNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Naj Uzías, haꞌ naj ismam naj Jotam, naj Jotam, haꞌ naj ismam naj Acaz, naj Acaz haꞌ naj ismam naj Ezequías. ");
INSERT INTO jacNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Naj Ezequías, haꞌ naj ismam naj Manasés, naj Manasés, haꞌ naj ismam naj Amón, naj Amón haꞌ naj ismam naj Josías. ");
INSERT INTO jacNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Naj Josías, haꞌ naj ismam naj Jeconías yeb huntekꞌanxa yuẍtaj. Haꞌ yin̈ istiempohal naj Jeconías tuꞌ ilaxto ebnaj Israel preso yul con̈ob Babilonia. ");
INSERT INTO jacNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hayet yelti ebnaj yalan̈ yip Babilonia tuꞌ xin haꞌ naj Jeconías, haꞌ naj ismam naj Salatiel, naj Salatiel, haꞌ naj ismam naj Zorobabel. ");
INSERT INTO jacNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Naj Zorobabel, haꞌ naj ismam naj Abiud, naj Abiud, haꞌ naj ismam naj Eliaquim, naj Eliaquim, haꞌ naj ismam naj Azor. ");
INSERT INTO jacNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Naj Azor, haꞌ naj ismam naj Sadoc, naj Sadoc haꞌ naj ismam naj Aquim, haxa naj Aquim, haꞌ naj ismam naj Eliud. ");
INSERT INTO jacNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Naj Eliud, haꞌ naj ismam naj Eleazar, naj Eleazar, haꞌ naj ismam naj Matán, haxa naj Matán, haꞌ naj ismam naj Jacob. ");
INSERT INTO jacNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Naj Jacob, haꞌ naj ismam naj José, naj José tuꞌ haꞌ naj yichamil ix María. Ix María tuꞌ haꞌ ix ismiꞌ Comam Jesús, haꞌ ton Comam Cristo. ");
INSERT INTO jacNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wal xin ay can̈lahon̈wan̈ mame yin̈ istxolal yichmam Comam Jesucristo chiichiti yin̈ icham Abraham masanta yin̈ naj rey David. Tzujanilo yinta naj rey David tuꞌ yichipaxti can̈lahon̈wan̈ mame istxolal yichmam Comam masanta yet yilaxto ebnaj Israel preso bey Babilonia. Tzujanxa yet yilaxto ebnaj Israel preso yul con̈ob Babilonia tuꞌ yichipaxti can̈lahon̈wan̈xa ebnaj mame yin̈ istxolal yichmam Comam Jesucristo masanto yin̈ istiempohal yet ispitzcꞌa Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hac tiꞌ ye istzotiꞌal yin̈ yet ispitzcꞌa Comam Jesucristo. Wal ix María takꞌwebilxa yu ix ismohyi yeb naj José, yajaꞌ yet maẍto chiyikꞌ isba, ispitzcꞌatiꞌ nichꞌan unin yin̈ ix yu yip Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wal naj José waxan̈ca caw yijem naj tet isley naj Moisés, yajaꞌ mach isje iscꞌul naj iskꞌanaꞌ yin̈ ix María tuꞌ, yoc yin̈ isnabal naj isbejnicano ix yin̈ ewantajil. ");
INSERT INTO jacNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hayet lan̈an yecꞌ huneꞌ tuꞌ yin̈ isnabal naj, isyeni isba huneꞌ yángel Comam Dios tet naj yul iswayic; yalni naj ángel tuꞌ hacaꞌ tiꞌ: —José, hach titnajach yin̈ yuninal naj rey David, mach chinanon hacꞌul hamohyi yeb ix María, yuto haꞌ nichꞌan unin ijbilico yu ix yet Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nichꞌan unin chipitzcꞌa tuꞌ, Jesús chawaco isbihoj, yuto haꞌ naj chicolnilti yet con̈ob yalan̈ ismul, ẍi naj ángel. ");
INSERT INTO jacNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hac tuꞌ yu yijni isba tzet yalcano Comam Dios tet huneꞌ ischejab yet payat, yet istzꞌibn̈encano hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ay huneꞌ ix kꞌopo maẍto hunu winaj chikꞌle, yajaꞌ chipitzcꞌati nichꞌan winaj unin yin̈ ix, nichꞌan unin chipitzcꞌa tuꞌ Emanuel chiyij isbi, ẍiayoj. Emanuel, haꞌ chaliloj ayco Comam Dios coxol. ");
INSERT INTO jacNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lahwi tuꞌ yel iswayan̈ naj José, isyijen naj yin̈ tzet yal yángel Comam Dios, ismohyi naj yeb ix María. ");
INSERT INTO jacNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yajaꞌ mach ishunba isba masanto yet ispitzcꞌa nichꞌan yunin ix. Haꞌ nichꞌan unin pitzcꞌa tuꞌ xin, Jesús yaco naj isbihoj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bey yul con̈ob Belén ayco yul ismajul txꞌotxꞌ Judea, haꞌ tuꞌ pitzcꞌa nichꞌan Jesús. Yet huneꞌ tiempohal tuꞌ haꞌ naj Herodes ayco isreyalo txꞌotxꞌ Judea. Ay xin huntekꞌan ebnaj caw ay ishelanil chicuyni yin̈ tzettaj ye txꞌumel, ispeto ebnaj yin̈ yetcꞌulal bay chiahilo tzꞌayic. Yet yapni ebnaj bey con̈ob Jerusalén, ");
INSERT INTO jacNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","iskꞌamben ebnaj: —¿Baytuꞌwal ay huneꞌ naj nichꞌan xapitzcꞌahi, naj chioc isreyalo anma Israel tiꞌ? Jilan̈ yahilo huneꞌ txꞌumel yin̈ yetcꞌulal bay chiahilo tzꞌayic, haꞌ xin akꞌni cotxumulojan̈ tato xapitzcꞌa naj. Yuxin macon̈titan̈ jikꞌayo cobahan̈ tet naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yet yaben naj rey Herodes huneꞌ tuꞌ, caw somchacan̈ yul iswiꞌ naj yeb sunil anma ay yul con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yuxin yawte naj Herodes tuꞌ ebnaj yahawil yin̈ ebnaj sacerdote Israel, yeb ebnaj cuywawom yin̈ isley naj Moisés; iskꞌamben naj tet ebnaj: —¿Baytaxca tuꞌ chipitzcꞌa naj Cristo? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Istakꞌwi ebnaj tet naj: —Yul con̈ob Belén yul ismajul Judea chipitzcꞌa naj, yuto hac tuꞌ yu istzꞌibn̈elaxcanayo yul Yum Comam Dios yu huneꞌ ischejab yet payat, bay chal hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Con̈ob Belén, haꞌ caw nichꞌanchꞌan sata hunuxa con̈ob ay yul ismajul txꞌotxꞌ Judea, yajaꞌ caw ecꞌbalto yelapno ye sata huntekꞌan con̈ob tuꞌ, yuto haꞌ bey tuꞌ chipitzcꞌa huneꞌ naj yahaw. Haꞌ naj xin chioc tan̈eno con̈ob Israel, ẍiayoj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lahwi tuꞌ xin, yawten naj rey Herodes ebnaj mago yin̈ ewantajil, yoc naj iskꞌambeno tet ebnaj yin̈ tzet tiempohal isye isba huneꞌ txꞌumel tuꞌ tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lahwi tuꞌ xin ischejnito naj Herodes tuꞌ ebnaj bey con̈ob Belén, yalni naj tet ebnaj: —Asiwe bey Belén tuꞌ, caw xin chekꞌambe yin̈ tzet caw ye nichꞌan unin tuꞌ. Lahwi yilcha naj heyu cat heyul heyalno wetan cat intopaxojan winayo inbahan tet naj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lahwi yalni naj Herodes huneꞌ tuꞌ isto ebnaj. Wal huneꞌ txꞌumel yil ebnaj yin̈ yetcꞌulal bay chiahilo tzꞌayic babel sata ebnaj, yoc lin̈no bay ay nichꞌan Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hayet yilni ebnaj huneꞌ txꞌumel tuꞌ caw tzalacan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hayet yapni ebnaj xin yocto ebnaj yul n̈a. Yilni ebnaj nichꞌan neneꞌ tuꞌ yeb ismiꞌ, yay jahno ebnaj sata nichꞌan neneꞌ tuꞌ, yalni ebnaj cꞌulla tzotiꞌ yin̈. Lahwi tuꞌ ishajni ebnaj iscꞌuwanbal, yakꞌni ebnaj chꞌen oro, yeb teꞌ pom, yeb huntekꞌan an̈ caw xukꞌ sam chiyij mirra sabehal tet nichꞌan Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yajaꞌ xin hallax tet ebnaj yul iswayic tato matxa chꞌecꞌ ebnaj yalaꞌ tet naj rey Herodes yin̈ nichꞌan Jesús tuꞌ, yuxin nan behalxa bay to ebnaj yet ispaxto ebnaj bey iscon̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Haxa yet xapaxto ebnaj mago hulicꞌo ilno nichꞌan Jesús, isyeni isba huneꞌ yángel Comam Dios tet naj José yul iswayic, yalni naj ángel tuꞌ: —Ahan̈wano yin̈ an̈e, ito nichꞌan unin tiꞌ yeb ismiꞌ cat hato bey Egipto. Wal haweh bey tuꞌ masanto haninan chiwalan tawet bakꞌin chachmeltzohi, yuto chati naj Herodes issayomal nichꞌan unin tiꞌ cat ispotxꞌni naj yalni, ẍi naj ángel tet naj José. ");
INSERT INTO jacNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lahwi tuꞌ yahwano naj José, yinito naj nichꞌan Jesús tuꞌ, isto naj yin̈ isbel yeb ix María bey Egipto yin̈ akꞌbalil. ");
INSERT INTO jacNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Haꞌ bey tuꞌ xin ehayo naj yeb ix masanto cam naj rey Herodes. Hac tuꞌ yu yijnicano isba tzet halbilcano yu Comam Dios tet huneꞌ ischejab yet payat yet istzꞌibn̈encano naj hacaꞌ tiꞌ: “Bey Egipto chiwawteti Incꞌaholan,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hayet yilni naj rey Herodes tato matxa ecꞌ ebnaj mago yalaꞌ tet naj yin̈ naj nichꞌan Jesús, caw tit ishowal naj yuto etli ebnaj yin̈ naj yabe. Ischejni naj potxꞌlaxo sunil niẍte winaj unin, neneꞌ masanta niẍte yin̈ cab habil ay yul con̈ob Belén yeb huntekꞌanxa con̈ob ayco yin̈ ishoyanil, yuto hac tuꞌ chielico istiempohal yin̈ tzet yal ebnaj mago tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hac tuꞌ yu yijnicano isba tzet tzꞌibn̈ebilcano yu naj Jeremías, huneꞌ ischejab Comam Dios yet payat bay chala: ");
INSERT INTO jacNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Abelax huneꞌ aw yul con̈ob Ramá, caw ay okꞌil yeb nimeta biscꞌulal. Haꞌ ton ix Raquel chiokꞌ yin̈ej yunin, machi xin chisje ix chiakꞌlax isnimanbal iscꞌul ix, yuto camnaxa ej yunin ix tuꞌ, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Haxa yet xacam naj rey Herodes, isyeni isba huneꞌ yángel Comam Dios tet naj José yul iswayic bey Egipto, yalni naj ángel tuꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ahan̈wanoj cat hameltzo yeb nichꞌan unin tiꞌ yeb ismiꞌ bey hacon̈ob Israel, yuto xacam ebnaj ochen potxꞌno camo nichꞌan unin tiꞌ, ẍi naj ángel. ");
INSERT INTO jacNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Haxa yet yaben naj José huneꞌ tuꞌ yahwano naj, yinito naj naj nichꞌan Jesús tuꞌ yeb ismiꞌ, ispaxti naj sat txꞌotxꞌ Israel hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yajaꞌ yabelo naj tato naj Arquelao, iscꞌahol naj rey Herodes tuꞌ oc reyalo selelo bey Judea, yuxin xiw naj yapni bey tuꞌ. Yajaꞌ xin hallax tet naj yul iswayic yu Comam Dios tato chito naj yul ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yet yapni naj bey tuꞌ yehayo naj yeb ix María yeb naj nichꞌan Jesús yul con̈ob Nazaret. Hac tuꞌ yu yijni isba tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat bay chala tato nazareno chihallax yin̈ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yet huneꞌ tiempohal tuꞌ xin apni naj Juan anican̈ haꞌ iswiꞌ anma bey txꞌotxꞌ desierto, yul ismajul Judea. ");
INSERT INTO jacNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yalni naj tet anma apni bey tuꞌ: —Bejwecano hewatxꞌen istxꞌojal, yuto yocxa Comam Dios ay yul satcan̈ yahawo teyin̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Haꞌ ton yin̈ naj Juan tiꞌ bay yal naj Isaías, huneꞌ ischejab Comam Dios yet payat, yet istzꞌibn̈encano naj hacaꞌ tiꞌ: Ay huneꞌ naj chiawi yin̈ caw ip bey huneꞌ txꞌotxꞌ desierto, chalni naj: “Watxꞌeweco heyanma yuto chihul Comam Dios Jahawil. Hacaꞌ chu istoholban̈elax hunu beh yet chihul hunu naj jahaw, hac tuꞌ cheyute hayanma,” ẍi naj, ẍi yul Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Wal naj Juan tuꞌ, xil noꞌ camello watxꞌebilayo xilo iskꞌap naj, tzꞌum noꞌ xin ayco istxꞌambalo naj. Haꞌ tzet chislo naj haꞌ ton noꞌ niẍte nokꞌ hacaꞌ noꞌ litꞌ yeb noꞌ cab ay xolaj telaj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hantan̈e xin anma yul con̈ob Jerusalén yeb yul ismajul Judea, yebpaxo anma ayayo istila haꞌ niman Jordán apni abeno tzet yal naj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yet chalnati anma ismul xin, cat yahcano haꞌ iswiꞌ yu naj Juan yul haꞌ niman Jordán. ");
INSERT INTO jacNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hayet yilni naj Juan tato txꞌiꞌal ebnaj fariseo yeb ebnaj saduceo apni iscꞌatan̈ yu yah haꞌ iswiꞌ, yalni naj tet ebnaj: —Hex tiꞌ caw hacaꞌtan̈e heyicꞌal heba yeb noꞌ laba, caw helanex hecolni heba. ¿Mac halni teyet ta yun̈e chꞌah haꞌ hewiꞌ yuxin chexcolcha tet huneꞌ isyaꞌtajil chati Comam Dios? ");
INSERT INTO jacNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tato caw yeli xaheyacano sunilal istxꞌojal, yilal heyenilo yu iscꞌulal chewatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tajca chetxum hacaꞌ tiꞌ: “Han̈on̈tiꞌan̈ jichmaman̈ ye icham Abraham, yuxin xacon̈colchahan̈ yalan̈ isyaꞌtajil chatiꞌ Comam Dios, tajca quexchi. Wal xin chiwalan teyet, tato choche Comam Dios chu yanico Comam huntekꞌan chꞌen chꞌen tiꞌ yuninalo icham Abraham heseleloj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Cawilxa yeti huneꞌ isyaꞌtajil chati Comam Dios, lahan hacaꞌ yet yocxa chꞌen eche yich xeꞌ hunu te teꞌ yu istzꞌocꞌlaxayo teꞌ. Yuxin sunil te teꞌ mach cꞌulo issatni chitzocꞌlaxayo teꞌ cat iskꞌojlaxto teꞌ yul kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yin̈ caw yeli hanintiꞌan han̈e ha haꞌ chiwakꞌan yahbalo haꞌ hewiꞌ yun̈e isyenicanilo isba tato caw yeli xahebejcano istxꞌojal. Yaj ay huneꞌ naj tzujan yul wintajan, naj tuꞌ chiyacan̈ naj haꞌ hewiꞌ, yaj yu iskꞌakꞌal yip Comam Espíritu Santo. Haꞌ naj tuꞌ caw ecꞌbalcano yelapno ye naj insatajan, walinan xin caw matzet welapnojan chiwabehan, nitam intꞌun̈nihan isxan̈ab naj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Naj chul tuꞌ lahan naj hacaꞌ hunu naj chixunilo iskꞌal ixim trigo, nan chakꞌ naj ixim sat, nan chakꞌpaxo naj ixim yoj, wal ixim sat tuꞌ chiscꞌubato naj ixim yul iscꞌun̈a, haxa ixim yoj tuꞌ xin chiskꞌojto naj ixim xol kꞌa kꞌaꞌ mach istan̈bal,” ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yet huneꞌ tiempohal tuꞌ el Comam Jesús bey Galilea, isto Comam istiꞌ haꞌ niman Jordán iscꞌatan̈ naj Juan, yu yah haꞌ iswiꞌ Comam yu naj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wal naj Juan tuꞌ mach chisje naj yakꞌaꞌcan̈ haꞌ iswiꞌ Comam. Yalni naj tet Comam: —Machoj, wal xin haꞌ hawet hach yilal hawanican̈ haꞌ inwiꞌan, maẍtajach chachhul incꞌatan̈an yu wanican̈an haꞌ hawiꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yajaꞌ takꞌwi Comam tet naj: —Mach chu haman̈cꞌon huneꞌ tiꞌ, wal xin yilal coyijen tzet chal Comam Dios, ẍi Comam. Hac tuꞌ xin yu isyijen naj Juan yanican̈ haꞌ iswiꞌ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yet lahwi yah haꞌ iswiꞌ Comam tuꞌ, yahti Comam xol haꞌ, yin̈n̈ena tuꞌ ishajni isba satcan̈. Yilni Comam yayilo Comam Espíritu Santo yiban̈ hacaꞌ hunu noꞌ cuwis. ");
INSERT INTO jacNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yabelax huneꞌ yul nukꞌe satcan̈, halni hacaꞌ tiꞌ: —Haꞌ naj tiꞌ Incꞌaholan, caw xahan ay wuhan, caw chintzalahan yin̈ naj, ẍiaytij. ");
INSERT INTO jacNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lahwi tuꞌ yilaxto Comam Jesús yu Comam Espíritu Santo bey txꞌotxꞌ desierto yu yilwelax Comam yu naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Caw xin yulbal cawina tzꞌayic yeb cawina akꞌbal mach waꞌ Comam, lahwi tuꞌ isn̈ohchacan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yapni naj matzwalil yilweno Comam, yalni naj tet Comam: —Ta yeli Iscꞌahol Dios hawehi, hal tet huntekꞌan chꞌen chꞌen tiꞌ meltzojabico chꞌen wahil, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Istakꞌwi Comam tet naj: —Wal xin tzꞌibn̈ebilcano yul Yum Comam Dios tato maẍn̈etaj yu tzet chicolo yuxin ay cokꞌinal, to yupaxo Istzotiꞌ Comam, ẍiayoj, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lahwi tuꞌ yinito naj matzwalil Comam yul con̈ob Jerusalén, iscon̈ob Comam Dios, yinato naj Comam yin̈ iswiꞌ yatut Comam bey tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yalni naj tet Comam: —Tato caw yeli Iscꞌahol Dios hawehi kꞌojayto haba bey tiꞌ, yuto tzꞌibn̈ebilcano yul Yum Comam Dios hacaꞌ tiꞌ: Chakꞌati Comam Dios yángel chachistan̈eꞌ yun̈e mach chaẍischayo ebnaj sat txꞌotxꞌ, haxinwal mach chilahwi hawoj yin̈ chꞌen chꞌen, ẍiayoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Istakꞌwi Comam Jesús tet naj: —Tzꞌibn̈ebilpaxcanayo yul Yum Comam Dios hacaꞌ tiꞌ: “Mach chinheyacojan yin̈ ilwebal yuto Heyahawil yeb heDiosal wehan,” ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lahwi tuꞌ yinito naj Comam yin̈ iswiꞌ huneꞌ witz caw nahat yecanocan̈, isyeni naj sunilej con̈ob ay yul sat yiban̈kꞌinal tiꞌ yeb iskꞌalomal con̈ob tuꞌ tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yalni naj tet Comam: —Sunil huntekꞌan chawil tiꞌ chiwakꞌan tawet, yaj tato chaẍay jahno insatajan cat hawinayo haba wetan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Istakꞌwi Comam: —Ach matzwalil hitzan̈ilo incꞌatan̈an yuto chal yul Yum Comam Dios hacaꞌ tiꞌ: “Iweyo heba tet Comam Dios yuto Heyahawil yeb heDiosal ye Comam, han̈e tet Comam xin cheyije tzet chala,” ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yet yalni Comam Jesús hacaꞌ tuꞌ isbejnicano naj Comam, yapni huntekꞌan ebnaj ángel colwal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hayet yaben Comam Jesús tato alaxicto naj Juan anican̈ haꞌ iswiꞌ anma yul preso, isto Comam yul ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yajaꞌ xin mach cancano Comam yul con̈ob Nazaret, wal xin to Comam yul con̈ob Capernaum, haꞌ tuꞌ xin ehayo Comam. Huneꞌ con̈ob tuꞌ ayayo istiꞌ haꞌ mar Galilea, txꞌotxꞌ chiyij Zabulón yeb Neftalí. ");
INSERT INTO jacNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hac tuꞌ yu yijni isba tzet tzꞌibn̈ebilcano yu naj Isaías, ischejab Comam Dios yet payat, bay chala: ");
INSERT INTO jacNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Txꞌotxꞌ Zabulón yeb txꞌotxꞌ Neftalí, txꞌotxꞌ ayicꞌto satacꞌto haꞌ Jordán, txꞌotxꞌ ayayo istiꞌ haꞌ mar, yul ismajul txꞌotxꞌ Galilea bay ay txꞌiꞌal anma mach Israeloj. ");
INSERT INTO jacNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Huntekꞌan anma tuꞌ ayticꞌaco xol kꞌejholo yajaꞌ wal tinan̈ xin xaapni issajilkꞌinal tet. Huntekꞌan anma tuꞌ iscambalxaticꞌa, yajaꞌ wal tinan̈ xaapni issajilkꞌinal yakꞌlobal yanma, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Haꞌ bey tuꞌ xin ichico Comam Jesús yalnicꞌo Istzotiꞌ Comam Dios, chalni Comam: —Bejwecano hewatxꞌen istxꞌojal yuto yocxa Comam Dios ay yul satcan̈ Yahawo teyin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hayet lan̈an isbelwi Comam Jesús istiꞌ haꞌ lago Galilea, yapni Comam iscꞌatan̈ cawan̈ ebnaj ikꞌomati cay, lan̈an yanayto ebnaj ishacꞌ chiinahti noꞌ cay xol haꞌ. Ebnaj cawan̈ tiꞌ yuẍta isba ebnaj, haꞌ ton naj Simón, naj chihallaxpaxo Pedro, yeb xin naj Andrés. ");
INSERT INTO jacNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yalni Comam tet ebnaj: —Ocan̈we tzujno wintajan, wal tinan̈ haxa anma chexoc heyikꞌahtij cat yoc yul inkꞌaban, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yet yaben ebnaj yalni Comam hacaꞌ tuꞌ, isbejnicano ebnaj ishacꞌ, yoc tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Haniqꞌuixto chito Comam Jesús xin yilnipaxo Comam cawan̈xa ebnaj yuẍta isba, haꞌ ton naj Jacobo yeb naj Juan, ebnaj iscꞌahol icham Zebedeo. Ayahto ebnaj yul isbarco yeb ismam tuꞌ, lan̈an xin isbujni ebnaj ishacꞌ. Yalnipaxo Comam tet ebnaj tato chioc tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yet yaben ebnaj huneꞌ tuꞌ yanicano ebnaj isbarco yeb ismam, yoc tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Caw sunil yul ismajul Galilea ecꞌ Comam Jesús, iscuyni Comam anma yul hunun iscapilla ebnaj Israel, yalni Comam tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. Yakꞌni cawxo Comam anma yin̈ sunilal yabil ayco yin̈, yeb anma chiecꞌyaꞌ yanma. ");
INSERT INTO jacNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Caw xin pujnacan̈ iskꞌumal Comam yul ismajul Siria, chiniti anma macta ayco yabil yin̈. Ay mac chꞌecꞌyaꞌ yanma yu yabil, ay mac ayco ischejab naj matzwalil yin̈, aypaxo mac chilow yaxcamic yin̈, yeb aypaxo mac camnajilo isnimanil. Sunil huntekꞌan anma tuꞌ yakꞌ cawxo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Caw hantan̈e anma oc tzujno yinta Comam; ay anma ah Galilea, ay anma ah Decápolis, ay anma ah Jerusalén yeb anma ah Judea, yebpaxo anma ay iskꞌaxepicꞌto haꞌ niman Jordán. ");
INSERT INTO jacNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hayet yilni Comam Jesús tato caw hantan̈e anma apni iscꞌatan̈, yahto Comam yin̈ istzalanil huneꞌ won̈an, yay tzꞌon̈no Comam, ishitzico ebnaj iscuywom Comam iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yoc Comam iscuyno ebnaj iscuywom tuꞌ, yichico Comam yalni hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Sakꞌal yet mac chitxumchalo yu ta mach chu iscolni isba ischuquil, yuxin yin̈n̈e Comam chicawxi iscꞌul. Huneꞌ mac tuꞌ yet ay yoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sakꞌal yet mac chiyikꞌ biscꞌulal yu istxꞌojal chiswatxꞌe, yuto chiakꞌlax yakꞌlobal iscꞌul yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sakꞌal yet mac chewchotan̈e chute isba yuto chischah huneꞌ txꞌotxꞌ haltebilcano yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sakꞌal yet mac choche iscꞌul iswatxꞌeꞌ tzet chal Comam Dios yuto chij isba tzet choche. ");
INSERT INTO jacNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sakꞌal yet mac chitzꞌay iscꞌul yin̈ yet anmahil, yuto hac tuꞌ chu istzꞌaypaxo iscꞌul Comam Dios yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sakꞌal yet mac sajxa ye yanma yul sat Comam Dios, yuto haꞌ anma tuꞌ chiapni iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sakꞌal yet mac chisayni akꞌancꞌulal yuto chal Comam Dios yuninaloj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sakꞌal yet mac caj chiillaxi yu chiswatxꞌe istoholal hacaꞌ choche Comam, yuto ayxaco yul iskꞌab Comam Dios ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sakꞌal heyet yet chexbahlaxi yeb yet chexetalaxi, cat ishoblaxcan̈ lekꞌtiꞌal teyin̈ yuto tzujanex wintajan. ");
INSERT INTO jacNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Caw akꞌwe tzalaho heyanma ta hac tuꞌ chexutelaxi yuto chꞌakꞌlax ispaj selel teyet bey satcan̈. Yuto hacaꞌ heyilni isyaꞌtajil tiꞌ, hac tuꞌ yu yecꞌyaꞌ yanma ebnaj ischejab Comam Dios ecꞌlena yet payat, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yalnipaxo Comam Jesús: —Hex tiꞌ, hacaꞌ atzꞌam atzꞌam, hac tuꞌ heye yul sat yiban̈kꞌinal tiꞌ. Kꞌinalo ta chiel iscꞌachiꞌal atzꞌam matxa chu yoc iscꞌachiꞌal atzꞌam hunelxa, hacꞌ tuꞌ xin matxa tzet chꞌocnico atzꞌam, to chitirlaxtoj cat isxan̈laxicꞌo yu anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yalnipaxo Comam Jesús: —Hex tiꞌ hacaꞌpaxo sajilkꞌinal heye yul sat yiban̈kꞌinal tiꞌ. Kꞌinalo ta ay hunu con̈ob yin̈ iswiꞌ hunu witz, caw haban jilnilto nahat. ");
INSERT INTO jacNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yet chicotzujbanico kꞌaꞌ yin̈ hunu cantil, mach chicon̈ohbaco hunu almuh yiban̈, wal xin chicotꞌun̈bacan̈ yun̈e ismujli yin̈ anma ayicto yul n̈a tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hacojab tuꞌ xin istzejla huneꞌ sajilkꞌinal ayxaco teyin̈ yin̈ sat anma, haxinwal chil anma iscꞌulal chewatxꞌe. Hac tuꞌ xin cꞌul istzotel anma yin̈ Comam ay yul satcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yalnipaxo Comam Jesús hacaꞌ tiꞌ: —Tajca chetxumu ta yu intan̈tzenilojan isley naj Moisés yeb cuybanile aycano yu ebnaj ischejab Comam Dios yuxin quinhulan, machoj, walxinto yun̈e wakꞌnihan ohtan̈elaxilo yin̈ tzet chaliloj yuxin quinhulan. ");
INSERT INTO jacNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yin̈ caw yeli chiwalan teyet ta caw yilal yijni isba sunil tzet tzꞌibn̈ebilcano yul Yum Comam Dios. Yulbal yul sat yiban̈kꞌinal tiꞌ yeb satcan̈, machi hun txꞌinano ayayo yin̈ ley mach chꞌecꞌto yet yijni isba. ");
INSERT INTO jacNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yuxin haꞌ mac mach chiyijen hunu chejbanile ayco yin̈ ley, waxan̈ca machi bin tzet chaliloj, machi xin chiscuypaxo yet anmahil isyijeni, haꞌ huneꞌ mac tuꞌ machi yelapno chuco xol mac chioc yul iskꞌab Comam Dios. Wal mac chiyijen xin cat iscuynipaxo yet anmahil isyijeni, haꞌ huneꞌ mac tuꞌ caw ay yelapno chuco xol anma chꞌoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yuxin chiwalan teyet tato mach ecꞌbalto cꞌul cheyute heyijen yin̈ tzet halbilcano yu Comam Dios tuꞌ sata ebnaj chicuywa yin̈ ley yeb ebnaj fariseo, mach chexoc yul iskꞌab Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yalnipaxo Comam Jesús: —Hex tiꞌ heyohtaj tato hallax tet ebnaj jichmam hacaꞌ tiꞌ: “Mach chepotxꞌcamo heyet anmahil, yuto haꞌ mac chipotxꞌni hunu yet anmahil yilal yilaxto sata naj juez cat yoc yin̈ isyaꞌtajil yu naj,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yajaꞌ haninan chiwalan teyet, haꞌ mac chichiwa iscꞌul yin̈ yet anmahil chiay isyaꞌtajil yiban̈ yu Comam Dios. Haꞌ mac chibuchwa yin̈ yet anmahil xin, haꞌ ebnaj iswiꞌehal yin̈ lahtiꞌ yul con̈ob chiilni tzet chielicoj. Haxa mac chibahni yet anmahil cat yakꞌni taco iscꞌul, haꞌ huneꞌ mac tuꞌ ay ismay isto xol kꞌa kꞌaꞌ mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kꞌinalo tato yet lan̈an heyinito heyofrenda tet Comam Dios sat altar cat henanitij tato ay hemul tet hunu maca, ");
INSERT INTO jacNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","awecano heyofrenda tuꞌ yich ismeẍahil bay chiakꞌlax xahanbal tuꞌ, cat heto heyanoco heba yin̈ akꞌancꞌulal yeb huneꞌ mac tuꞌ, tzujan tuꞌ xin xaisje heyakꞌni heyofrenda tuꞌ tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tato ay hunu mac chikꞌanni teyin̈ yu hunu istxꞌojal chewatxꞌe, watxꞌeweyo huneꞌ tuꞌ yin̈ akꞌancꞌulal yeb huneꞌ mac tuꞌ yet yalan̈to maẍto chexto sata naj alcal. Yuto ta chexapni sata naj, chexyaco naj yul iskꞌab ebnaj mayor, haxa ebnaj mayor tuꞌ xin chexanicto yul preso. ");
INSERT INTO jacNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yin̈ caw yeli chiwalan teyet, mach chexelti yul preso tuꞌ ta mach tzꞌajano cheyakꞌ hemulta, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yalnipaxo Comam Jesús: —Hex tiꞌ heyohtaj tato hallax hacaꞌ tiꞌ: “Mach chexixli,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yajaꞌ hanintiꞌan chiwalan teyet, mac xan̈eticꞌa chiilni hunu ix ix cat isnanico istxꞌojal yin̈ ix cat yochenico ix, haꞌ huneꞌ mac tuꞌ xayanaco ismul yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kꞌinalo tato isbakꞌ hesat yin̈ hewatxꞌkꞌab chexakꞌni aycꞌayoj yin̈ hunu istxꞌojal, cꞌulmi tato cheyilti huneꞌ isbakꞌ hesat tuꞌ cat hekꞌojnito nahat. Wal xin ecꞌbal cꞌul tato ayto hunu tzet mach tzꞌajano yin̈ henimanil sata ta tzꞌajan sunil henimanil cat heyalaxto xol kꞌa kꞌaꞌ mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kꞌinalo tato hewatxꞌkꞌab chexakꞌni aycꞌayo yin̈ hunu istxꞌojal, cꞌulmi ta chetzoqꞌuilto huneꞌ hekꞌab tuꞌ, cat hekꞌojnito nahat. Wal xin ecꞌbal cꞌul tato matxa huneꞌ hekꞌab satato tzꞌajan henimanil cat heyalaxto xol kꞌa kꞌaꞌ mach istan̈bal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yalnipaxo Comam: —Hallaxpaxo yet payat hacaꞌ tiꞌ: “Ta ay hunu naj chispoh isba yeb yixal, yilal iswatxꞌicano yumal cat yakꞌnicano naj huneꞌ hum tuꞌ tet ix,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yajaꞌ wal intiꞌan chiwalan, tato ay hunu naj chispoh isba yeb yixal, yajaꞌ ta mach yuho issayni ix ismul yeb hunuxa winaj, huneꞌ naj tuꞌ lan̈an istubtento naj ix issayaꞌ ismul yikꞌni hunuxa yichamil. Haꞌ xin naj chiikꞌni ix chispoh isba yeb yichamil tuꞌ, haꞌ hun naj chahpaxico ismul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yalnipaxo Comam Jesús: —Hex tiꞌ, heyohtapaxoj tato hallax tet ebnaj jichmam hacaꞌ tiꞌ: “Ta cheyawte isbi Comam Dios yin̈ hunu tzet chetakꞌwe teyin̈, yilal heyijen huneꞌ tuꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yajaꞌ wal intiꞌan chiwalan teyet, mach cheyakꞌ binaho isbi Comam Dios yin̈ tzet chetakꞌweco teyiban̈. Mach cheyakꞌ binaho satcan̈ yet chetakꞌwenico hunu tzet ye tuꞌ teyiban̈, yuto haꞌ bey tuꞌ tzꞌon̈an Comam Dios Jahawil. ");
INSERT INTO jacNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mach cheyakꞌpaxo binaho txꞌo txꞌotxꞌ yet chetakꞌwenico hunu tzet ye tuꞌ teyiban̈, yuto txꞌo txꞌotxꞌ isbatxobal yoj Comam ye txꞌotxꞌ. Mach cheyakꞌ binaho isbi con̈ob Jerusalén yet chetakꞌwenico hunu tzet ye tuꞌ teyiban̈, yuto iscon̈ob Comam Dios Jahawil caw ay yelapno yehi. ");
INSERT INTO jacNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mach cheyakꞌ binaho hewiꞌ yin̈ tzet chetakꞌweco teyiban̈, yuto mach chu hesajn̈en maca hekꞌejn̈en hunu xil hewiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wal xin tato cheyal hoꞌ, yelojab cheyala, taca machoj ta quexchi, machojabi; yuto ta cheyakꞌ binaho isbi huntekꞌan tuꞌ yakꞌni isba yin̈ tzet cheyala, wal xin yin̈ naj matzwalil chitit huntekꞌan tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yalnipaxo Comam Jesús hacaꞌ tiꞌ: —Hex tiꞌ heyohtaj tato hallaxpaxo hacaꞌ tiꞌ: “Tato ay hunu mac chimakꞌni poho isbakꞌsat hunu maca, makꞌlaxojabpaxo poho isbakꞌsat huneꞌ mac tuꞌ. Tato ay hunu mac chimakꞌnilti yeh hunu maca, makꞌlaxojabpaxilti yeh huneꞌ mac tuꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yajaꞌ wal intiꞌan chiwalan, mach chu hepajtzen istxꞌojal chiswatxꞌe hunu mac teyin̈. Wal xin tato ay mac chipakꞌnilto hecotxꞌ, meltzowepaxto kꞌaxepxa tet. ");
INSERT INTO jacNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta ay hunu mac chikꞌanni teyin̈ tet naj alcal, cat yinito hecamiẍ yalni, matzet cheyala ta chipaxto hechumpa. ");
INSERT INTO jacNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yeb xin ta ay hunu mac chalni teyet tato cheyijto yijatz yictajo legua, colwahan̈we yin̈, iweto yijatz tuꞌ hunu legua. ");
INSERT INTO jacNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta ay mac chikꞌanni hunu tzet ye tuꞌ teyet, akꞌwe tet. Tato ay hunu mac chikꞌanni hunu tzet ye tuꞌ cꞌamil teyet, colwahan̈we yin̈ huneꞌ mac tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yalnipaxo Comam Jesús: —Hex tiꞌ heyohtaj tato hallax hacaꞌ tiꞌ: “Xahan cheyil mac xahan chexilni. Mac ayco ishowal teyin̈ xin, ocojabpaxo hehowal yin̈,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yajaꞌ wal intiꞌan chiwalan teyet, xahan cheyil mac ayco ishowal teyin̈. Kꞌanwe iscꞌulal Comam Dios yiban̈ macta chexetani. ");
INSERT INTO jacNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta cheyije hacaꞌ tuꞌ, hac tuꞌ chu heyeniloj tato quexyuninal Comam Dios ay yul satcan̈, yuto haꞌ Comam Dios chiakꞌni aholo tzꞌayic yiban̈ anma cꞌul yeb yiban̈ anma txꞌoj. Lahan chapaxayo Comam haꞌ n̈ab yiban̈ mac cꞌul yeb yiban̈ mac txꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wal xin tato han̈cꞌan̈e anma xahan chexilni, haꞌn̈e xin xahan cheyilpaxoj, ¿mataxca chechah ispaj huneꞌ tuꞌ tet Comam Dios? Machoj, yuto hac tuꞌ chute isbeybaln̈e ebnaj mulum, hacaꞌ ebnaj ikꞌomilo tohlabal chito bey Roma. ");
INSERT INTO jacNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yeb xin tato han̈cꞌan̈e tet heyuẍtaj chextioẍli, ¿cꞌulmi huneꞌ tuꞌ? Machoj. Wal xin haꞌ anma mach ohtan̈eho Comam Dios hac tuꞌ chisbeybaln̈e. ");
INSERT INTO jacNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tzꞌajanojab chu hebeybaln̈e sunil iscꞌulal, yuto Comam Dios ay yul satcan̈ tzꞌajan lahan yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yalni Comam Jesús: —Caw nann̈e heyu yin̈ tzet chewatxꞌe, machn̈ehojab yin̈ sat anma cꞌul cheyute heba, yuto ta yun̈e heyillaxi yuxin chewatxꞌe iscꞌulal, mach chechah ispaj selel tet Comam Dios ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yuxin yet chexcolwa yin̈ hunu mebaꞌ, mach chepujbacꞌo hacaꞌ chute ebnaj chal isba cꞌulal. Ebnaj tuꞌ chꞌakꞌ ebnaj issabehal yulaj capilla yeb yulaj calle, yun̈e yallax ebnaj cꞌulal. Yin̈ caw yeli chiwalan teyet, yet chihallax cꞌulla tzotiꞌ yin̈ ebnaj tuꞌ lan̈an ischahnina ebnaj ispaj selel. ");
INSERT INTO jacNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wal hex tiꞌ xin, hayet chexcolwa yin̈ anma mebaꞌ machi mac tet cheyala, nitam tet hunu heyamigo. ");
INSERT INTO jacNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wal xin yin̈ ewantajil cheyakꞌ tet, haxinwal Comam ay yul satcan̈ chiilni tzet chawatxꞌe yin̈ ewantajil, cat yakꞌni Comam ispaj selel teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yalnipaxo Comam Jesús: —Hayet chextxahli tet Comam Dios, mach cheyute hacaꞌ chute ebnaj chal isba cꞌulal. Haꞌ ebnaj tuꞌ yun̈e yillax ebnaj yu anma, yuxin ton̈eticꞌa choche islin̈ba isba istxahli yulaj iscapilla ebnaj Israel, yebpaxo yin̈la istxiquin txon̈bal. Yin̈ caw yeli chiwalan teyet, yet chitxahli ebnaj hacaꞌ tuꞌ chischahnina ebnaj ispaj selel tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Walex hex tiꞌ, mach cheyute hacaꞌ tuꞌ. Wal xin hayet chextxahli, chexocto yul heyatut cat hepeban ispultahil teꞌ, cat hetxahli tet Comam Dios, Comam chiaben tzet cheyala. Chil Comam sunil tzet cheyu yin̈ ewantajil cat yakꞌni Comam ispaj selel teyet. ");
INSERT INTO jacNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Hayet chextxahli, machojab chexoc hecayen̈e tzotiꞌ matzet chaliloj hacaꞌ chute anma maẍto ohtan̈eho Comam Dios. Yuto chistxum ebnaj ta yu caw nimej chute ebnaj yoj istxah, caw chabe Comam Dios tzet chal ebnaj yalni. ");
INSERT INTO jacNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wal xin mach cheyute hacaꞌ tuꞌ, yuto Comam Dios yohtaxa tzet chiocnico heyu yalan̈to yet maẍto chekꞌan tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hayet chextxahli, hac tiꞌ cheyute heyalni hacaꞌ tiꞌ: Hach Comam, hach coDios, ayach yul satcan̈, nimanojab yelapno habi yul sat anma. ");
INSERT INTO jacNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hulan̈ cat hawoc jahawilojan̈ yul sat yiban̈kꞌinal tiꞌ. Yijab isba tzet chawoche sat txꞌo txꞌotxꞌ tiꞌ hacaꞌ chu yijni isba yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mamin, chicokꞌanan̈ tawet, akꞌ tzet chicolohan̈ hunun tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Akꞌ nimancꞌulal yin̈ istxꞌojal chicowatxꞌehan̈, hacaꞌ chu jakꞌni nimancꞌulalan̈ yin̈ anma chiwatxꞌen istxꞌojal jin̈an̈. ");
INSERT INTO jacNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mach chon̈hachayojan̈ xol ilwebal, caw colon̈ilojan̈ yul iskꞌab naj matzwalil, quexchi yin̈ hetxah, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yalnipaxo Comam: —Ta cheyakꞌ nimancꞌulal yin̈ anma chiwatxꞌen istxꞌojal teyin̈, haꞌ Comam Dios ay yul satcan̈ chꞌakꞌnipaxo nimancꞌulal teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yaj ta mach cheyakꞌ nimancꞌulal yin̈ heyet anmahil chiwatxꞌen istxꞌojal teyin̈, mach chakꞌpaxo nimancꞌulal Comam Dios teyin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Lahwi tuꞌ yalnipaxo Comam Jesús: —Hayet mach chexwaꞌ yu hetxahli tet Comam Dios, mach biscꞌulalo cheyute hesat hacaꞌ chute ebnaj chal isba cꞌulal, yuto ebnaj tuꞌ caw biscꞌulal chute ebnaj sat yun̈e yillax ebnaj yu anma tato ayco ebnaj yin̈ yet mach chon̈wahi yu cotxahli tet Comam Dios. Yin̈ caw yeli chiwalan teyet chischahna ebnaj ispaj selel yet chiillax ebnaj yu anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Walex tiꞌ xin, yet mach chexwaꞌ yu hetxahli tet Comam Dios, chetxꞌahwe hesat cat hexínito xil hewiꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","yun̈e mach chalilo isba tato ayexico yin̈ yet mach chexwaꞌ yu hetxahli tet Comam Dios. Wal xin han̈cꞌan̈e Comam ewan yehi, haꞌ chiilni tzet cheyu cat yakꞌni Comam ispaj selel teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yalnipaxo Comam Jesús hacaꞌ tiꞌ: —Mach chetenba hekꞌalomal sat txꞌo txꞌotxꞌ tiꞌ, yuto chioc noꞌ ih yetaꞌtoj, cat xin yocpaxo iskꞌuxewal. Macato chul ebnaj elkꞌom yin̈ cat yinito ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wal xin haꞌ huneꞌ cheyute, tenbawe hekꞌalomal yul satcan̈ bay machi noꞌ ih chietantoj, bay mach chiocpaxo iskꞌuxewal, yeb bay mach chiapni ebnaj elkꞌom yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yuxin haꞌ bay ay hekꞌalomal haꞌ tuꞌ cheyapaxico heyanma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Isbakꞌ cosat cantil yehico yin̈ conimanil, yuxin ta han̈cꞌan̈e iscꞌulal choche yilaꞌ hesat tuꞌ, sunil henimanil ayco yin̈ sajilkꞌinal. ");
INSERT INTO jacNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yajaꞌ ta yin̈n̈e istxꞌojal ayco hemujlubal; sunil henimanil ayco yin̈ kꞌejholo. Ta huneꞌ issajilkꞌinal ayco teyin̈ tuꞌ chimeltzoco yin̈ kꞌejholohal, chexcancano xol kꞌejholo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yalnipaxo Comam Jesús hacaꞌ tiꞌ: —Machi hunu mac chu yoc chejabo tet cawan̈ patrón, yuto ta chisyije naj tzet chal naj babel, chisman̈cꞌo naj tzet chal naj iscab. Yeb xin tato xahan chil naj naj babel, chisyah naj naj iscab. Hac tuꞌ heye hex tiꞌ, mach chu heyijen tzet chal Comam Dios tato ecꞌbal cheyaco heyanma yin̈ kꞌalomal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yalnipaxo Comam Jesús: —Yuxin chiwalan teyet, mach cheyaco yin̈ hecꞌul yin̈ tzet chelo, yeb yin̈ tzet chu yoc xil hekꞌap yul sat yiban̈kꞌinal tiꞌ. Ta chakꞌ Comam Dios cocawil, ¿haꞌ tom xin tzet chicolo mach chakꞌ Comam, heyalni? Ta haꞌ Comam akꞌn̈e conimanil, ¿haꞌ tom xil cokꞌap mach chakꞌ Comam? ");
INSERT INTO jacNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilwecꞌanab noꞌ chꞌic chiecꞌ satcan̈, machi yawal noꞌ chacoj, mach chihatxꞌwi noꞌ, machipaxo iscꞌun̈a noꞌ, yajaꞌ xin chiakꞌlax tzet chislo noꞌ yu Comam ay yul satcan̈. ¡Hajxamex to caw ecꞌbal heyelapno sata noꞌ! ");
INSERT INTO jacNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Aymi hunujex tiꞌ yu caw cheyaco yin̈ hecꞌul yuxin chu heyanico hanicꞌoxa yakꞌbil hakꞌinal yul sat yiban̈kꞌinal tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Tzet yin̈ xin caw cheyaco yin̈ hecꞌul yin̈ tzet chu yoc xil hekꞌap? Ilwecꞌanab teꞌ caj chichꞌib xol kꞌebtaj, mach chimunla teꞌ, mach chichemlipaxo teꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","yajaꞌ chiwalan teyet, naj rey Salomón yet payat mach apni iskꞌaptzen isba naj hacaꞌ iscꞌulchꞌanil teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Walca caw cꞌulchꞌan jilni isxumaquil teꞌ tinan̈, yajaꞌ yet hecal cabe chin̈uslaxto teꞌ yul horno. Ta chakꞌ Comam iscꞌulchꞌanil teꞌ caj tuꞌ, ¿haꞌ tom xin xil hekꞌap mach chakꞌ Comam? Hex tiꞌ caw mach cheyaco heyanma yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yuxin mach cheyaco yin̈ hecꞌul cheyalni hacaꞌ tiꞌ: ¿Baytaxca chitit tzet chicolo yeb xil cokꞌap? ");
INSERT INTO jacNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yuto haꞌ anma mach ohtan̈e Comam Dios chianico huntekꞌan tuꞌ yin̈ iscꞌul. Yajaꞌ wal Comam Dios ay yul satcan̈, yohtaxa Comam tato chiocnico huntekꞌan tuꞌ heyu. ");
INSERT INTO jacNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wal xin aweco yin̈ hecꞌul hesaynilo Comam Dios babel cat heyijen tzet chala, walpaxo tzet chiocnico heyu yul sat yiban̈kꞌinal tiꞌ xaticꞌa yakꞌaꞌ Comam Dios teyet. ");
INSERT INTO jacNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mach cheyaco yin̈ hecꞌul yin̈ tzet chu yecꞌ heyu yet hecal, yuto yet hecal tuꞌ nanto tzet cheyaco yin̈ hecꞌul yin̈ tzet cheyu, yuto masan ay isyaꞌtajil yetbi hunun tzꞌayic, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yalnipaxo Comam Jesús: —Mach comono chexoc heyilaꞌ tzet ye hunu heyet anmahil, haꞌ xin wal mach chiocpaxo Comam Dios yilaꞌ tzet heyehi. ");
INSERT INTO jacNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yuto hacaꞌticꞌa chu heyilni tzet ye heyet anmahil, hac tuꞌ chu quexyilnipaxo Comam. Wal xin hacaꞌticꞌa hemal cheyacoj yet cheyilni tzet yeco hunu heyet anmahil, haꞌticꞌa xin chexmalenpaxo yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kꞌinalo tato ay hunu hawuẍtaj ayicto iskꞌal teꞌ chꞌim yul isbakꞌsat, wal hachpaxo xin patzab teꞌ aypaxicto yul isbakꞌ hasat. Ta mach chawilti teꞌ patzab ayicto yul isbakꞌ hasat tuꞌ, ¿hatocꞌanab nichꞌan iskꞌalemal teꞌ chꞌim ayicto yul isbakꞌsat hawuẍta tuꞌ chu hawiniltij? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Mataxca xin chu hawalni tet heyuẍta tuꞌ hacaꞌ tiꞌ: “Wuẍtaj, wikꞌaltijan huneꞌ iskꞌal teꞌ chꞌim ayicto yul isbakꞌ hasat,” ta cachi? Wal hachpaxo xin kꞌatanicto huneꞌ teꞌ patzab yul isbakꞌ hasat. ");
INSERT INTO jacNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tato hac tuꞌ hawalni, ¡lekꞌtiꞌach! Wal xin icanilti teꞌ patzab ayicto yul isbakꞌ hasat babel, lahwi tuꞌ cat hawinilti iskꞌal teꞌ chꞌim ayicto yul isbakꞌsat hawuẍtaj. ");
INSERT INTO jacNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Istzotiꞌ Comam Dios lahan yeb huntekꞌan chꞌen chꞌen perla isbi, caw ay istohol. Yuxin mach chu jakꞌni Istzotiꞌ Comam tet hunu mac machi yelapno Comam yul sat, yuto lahan yeb metx txꞌiꞌ caw how, chitit lemna jin̈. Aypaxo mac hacaꞌ noꞌ txitam, ton̈e chioc isxan̈aꞌto tzet chꞌakꞌlax tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yalnipaxo Comam Jesús: —Kꞌanwe tet Comam Dios cat yakꞌni Comam teyet, saywej cat yilcha heyu, elojabico heyaw sat pulta cat ishajlax teyet. ");
INSERT INTO jacNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yuto haꞌ mac chikꞌanni chischah, haꞌ mac chisayni chiilcha yu. Haꞌ mac chielico yaw sat pulta chihajlax tet. ");
INSERT INTO jacNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kꞌinalo tato chiskꞌan heyuninal tzet chislo teyet, ¿tom cheyakꞌ hunu chꞌen chꞌen tet? ");
INSERT INTO jacNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Maca tato chiskꞌan hunu noꞌ cay iscꞌuxuꞌ, ¿tom cheyakꞌ hunu noꞌ laba tet? ");
INSERT INTO jacNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yajaꞌ waxan̈ca caw txꞌojex heyohta heyakꞌni iscꞌulal tet heyuninal, hajxam xin Comam Dios ay yul satcan̈, ¿tom mach chꞌakꞌ iscꞌulal teyet, ta chekꞌana? ");
INSERT INTO jacNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ta cheyoche cꞌul chute iscꞌul anma teyin̈, hex babel cꞌul cheyute hecꞌul yin̈ anma tuꞌ, yuto hac tuꞌ yalni yin̈ ley yeb yin̈ tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yalnipaxo Comam Jesús: —Wal ispultahil satcan̈ bay ay Comam Dios, lahan hacaꞌ hunu pulta nichꞌanchꞌan sat, haꞌ tuꞌ xin chexoctoj. Yuto huneꞌ pulta yeb huneꞌ beh caw nimajal sat, yul cambal chitohi. Caw xin niman anma chito yul huneꞌ pulta yeb huneꞌ beh tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wal huneꞌ pulta yeb huneꞌ beh nichꞌanchꞌan sat xin chon̈yito bay ay kꞌinale mach istan̈bal, yajaꞌ haywan̈n̈e mac chiocto yul huneꞌ pulta tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yalnipaxo Comam Jesús: —Caw cheyil heba tet ebnaj lekꞌtiꞌwom chisbalico isba ischejabo Comam Dios, yuto hayet chitzotel ebnaj teyet, caw cꞌulchꞌan chute iscꞌul ebnaj hacaꞌ noꞌ meꞌ, yajaꞌ wal yanma ebnaj xin lahan hacaꞌ noꞌ oj chon̈cꞌuxnitoj. ");
INSERT INTO jacNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ixtan̈ hetxumilo tzet nabil yu ebnaj yuto haꞌ tzet chiswatxꞌe ebnaj chihalniloj. Kꞌinalo teꞌ uva tinan̈, ¿tom chakꞌ teꞌ sat teꞌ txꞌix? Maca teꞌ higo, ¿tom satpaxo teꞌ txꞌix chakꞌ teꞌ? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wal xin teꞌ satnom teꞌ cꞌul, cꞌul sat teꞌ chakꞌa. Yajaꞌ wal teꞌ mach cꞌuluj xin machiswalil sat teꞌ chakꞌa. ");
INSERT INTO jacNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Teꞌ satnom teꞌ cꞌul, ¿tom machiswalil sat teꞌ chakꞌa? ¡Machoj! Yeb te teꞌ machiswalil, ¿tom cꞌul sat teꞌ chakꞌa? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Yuxin ebnaj chal isba ischejabo Comam Dios, yin̈ tzet chiswatxꞌe ebnaj haꞌ yin̈ chetxumiloj tzet nabil yu ebnaj. Hacaꞌ chu istzocꞌlaxcan̈ te teꞌ mach cꞌulo sat chakꞌa, chilahwi tuꞌ xin cat isn̈uslaxto teꞌ xol kꞌa kꞌaꞌ, hac tuꞌ chiutelax huntekꞌan ebnaj tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yalnipaxo Comam Jesús: —Mach sunilo mac chihalni: “Mamin, Mamin,” win̈an, chioc yul iskꞌab Comam Dios, wal xin han̈e mac chiyijen tzet chal Inmaman ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hayet chiapni islahobal tzꞌayic hantan̈e mac chihalni hacaꞌ tiꞌ: “Mamin, Mamin, han̈on̈tiꞌan̈ con̈ecꞌan̈ jalaꞌan̈ hatzotiꞌ tet anma. Jinipaxilojan̈ ischejab naj matzwalil yin̈ anma yin̈ habi, yeb xin txꞌiꞌal cꞌaybalcꞌule coyehan̈ tet anma,” ẍi anma yin̈ huneꞌ tzꞌayic tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yajaꞌ chintakꞌwihan tet hacaꞌ tiꞌ: “Mach quexwohtajojan, hitzan̈welo yin̈ insatan. Hex tiꞌ istxꞌojaln̈eticꞌa hewatxꞌe,” quinchin̈eticꞌahan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yalnipaxo Comam Jesús: —Mac chiaben Intzotiꞌan cat isyijeni, lahan yeb huneꞌ naj caw ay yitzꞌatil iswiꞌ, yuto hayet yanican̈ naj yatut, yiban̈ chꞌen chꞌen yayto naj isxeꞌal teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lahwi tuꞌ xin istit huneꞌ niman jakꞌekꞌ n̈ab, isnohcan̈ ha haꞌ, ismakꞌnico isba haꞌ yin̈ teꞌ n̈a tuꞌ, yajaꞌ xin mach aycꞌay teꞌ, yuto caw cꞌul yehayto xeꞌ teꞌ yiban̈ chꞌen chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yajaꞌ wal mac chiaben Intzotiꞌan, machi xin chisyije tzet chala, lahan yeb huneꞌ naj mach isnabal, yiban̈ arena yayo xeꞌ yatut. ");
INSERT INTO jacNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lahwi tuꞌ, yakꞌni huneꞌ niman jakꞌekꞌ n̈ab, ischꞌibcan̈ ha haꞌ, ismakꞌnico isba haꞌ yin̈ teꞌ yaycꞌay teꞌ, yuchcꞌacanto teꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hayet lahwi istzotel Comam Jesús tuꞌ xin, caw sunil anma cꞌaycanocan̈ iscꞌul yaben iscuywa Comam, ");
INSERT INTO jacNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yu caw ay yip Comam iscuywahi, mach hacaꞌo chu iscuywa ebnaj cuywawom yin̈ isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yet ispaxayti Comam Jesús iswiꞌ huneꞌ won̈an tuꞌ, caw hantan̈e anma oc tzujno yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yelilo huneꞌ naj yul beh, ayco huneꞌ yabil chiyij lepra yin̈. Ishitzico naj iscꞌatan̈ Comam, yay jahno naj sata Comam, yalni naj: —Mamin, ta chawoche chu hawinilo huneꞌ yabil tiꞌ win̈an, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yanayo Comam iskꞌab yiban̈ naj, yalni Comam: —Hoꞌ, chiwochehan ta chiel huneꞌ yabil tiꞌ tawin̈, ẍi Comam. Yin̈n̈ena xin yel huneꞌ yabil tuꞌ yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lahwi tuꞌ, yalni Comam tet naj: —Machi mac tet chawalicꞌo huneꞌ tiꞌ, wal xin as ye haba tet naj sacerdote, cat hawakꞌni haxahanbal hacaꞌ yalni isley naj Moisés, yun̈e yohtan̈encanilo anma tato xaelcano huneꞌ yabil tiꞌ tawin̈, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hayet yoc apno Comam Jesús yul con̈ob Capernaum, yapni huneꞌ naj capitán romano iscꞌatan̈ Comam, iskꞌanni naj ta chakꞌ cawxo Comam huneꞌ ischejab naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yalni naj tet Comam: —Mamin, ay huneꞌ inchejaban caw yaꞌay, mach chibili isnimanil, caw xin chꞌecꞌyaꞌ yanma naj yu huneꞌ yabil tuꞌ, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yalni Comam tet naj: —Cꞌulticꞌa, chintohan wakꞌaꞌ cawxojan naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Istakꞌwi naj capitán tuꞌ tet Comam: —Mamin, caw mach chu hawapni yul watutan chiwabehan yuto caw matzet welapnojan. Wal xin ton̈e chachtzotelnato yin̈ hacn̈e tiꞌ cat iscawxican̈ inchejabtuꞌan. ");
INSERT INTO jacNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wohtajan huneꞌ tiꞌ, yuto hanintiꞌan ayinictojan yalan̈ ischejbanil ebnaj wahawan, aypaxo xin ebnaj soldado ayico yalan̈ wipan. Ta chiwalan tet hunu naj: “Asiꞌ bey tuꞌ,” ta quinchiyan, cat isto naj. Taca chiwalan tet hunuxa naj: “Cata,” ta quinchiyan, cat istit naj. Yebpaxo xin ta chiwalan tet hunuxa naj inchejaban: “Watxꞌe huneꞌ tilah,” ta quinchiyan, cat yoc naj iswatxꞌenoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hayet yaben Comam yalni naj hacaꞌ tuꞌ, caw cꞌayilo iscꞌul Comam, yalni Comam tet anma tzujanico yinta tuꞌ: —Yin̈ caw yeli chiwalan teyet, maẍto hunu mac chiwilan yanico yanma yin̈ Comam Dios yul con̈ob Israel hacaꞌ huneꞌ naj tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wal xin chiwalan teyet, chitit anma bay chiahilo tzꞌayic, yeb bay chito tzꞌayic cat iscutxbanico isba yeb naj Abraham, naj Isaac yeb naj Jacob sat ismeẍa Comam Dios bey satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Haꞌ anma Israel yetticꞌa ay yoc sat huneꞌ meẍa tuꞌ, yaj ay ebnaj chicancano yintajilo xol kꞌejholo. Haꞌ bey tuꞌ xin chꞌoc okꞌoj cat isn̈etxꞌla yeh yu isyaꞌtajil, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lahwi tuꞌ xin, yalni Comam tet naj capitán: —Paxan̈to hawatut, yubojab hacaꞌ chawoche yuto maxawayto yul hawanma win̈an, ẍi Comam tet naj. Yin̈ticꞌa huneꞌ orahil tuꞌ xin cawxican̈ ischejab naj capitán. ");
INSERT INTO jacNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lahwi tuꞌ xin, isto Comam Jesús yatut naj Pedro. Yet yapni Comam yilni tato hilanto ismiꞌ yixal naj Pedro tuꞌ sat txꞌat yu huneꞌ niman kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yoc tzabno Comam yin̈ iskꞌab ixnam, yelna huneꞌ kꞌaꞌ tuꞌ yin̈ ixnam, iscawxican̈ ixnam. Lahwi tuꞌ yahwano ixnam, yoc ixnam iswatxꞌeno tzet chislo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hayet lan̈anxa yay numnahi caw hantan̈e anma ayco ischejab naj matzwalil yin̈ ilaxto iscꞌatan̈ Comam. Caw xin huneꞌn̈echꞌan tzotiꞌ chal Comam cat yel ischejab naj matzwalil yin̈ anma. Yakꞌnipaxo cawxo Comam anma yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yin̈ huntekꞌan iswatxꞌe Comam tuꞌ yijcano isba tzet halbilcano yu naj Isaías, huneꞌ ischejab Comam yet payat, yet yalni naj hacaꞌ tiꞌ: “Yiban̈ naj chitocano yabil ayco jin̈, cat xin yabenpaxo isyaꞌil coseleloj,” ẍi naj Isaías tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hayet yilni Comam Jesús tato caw hantan̈e anma hoyanico yin̈, yalni Comam tet ebnaj iscuywom tato chiecꞌto ebnaj yeb Comam iskꞌaxepicꞌto haꞌ lago. ");
INSERT INTO jacNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yajaꞌ yet yalan̈to maẍto chito Comam yeb ebnaj, ishitzico huneꞌ naj chicuywa yin̈ isley naj Moisés iscꞌatan̈ Comam, yalni naj: —Mam cuywawom, chinoc tzujnojan tawintaj bajxan̈etuꞌwal chachtohi, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yalni Comam tet naj: —Noꞌ wech ay isn̈achꞌen noꞌ bay chiwayi, yebpaxo noꞌ chꞌic ay yatut noꞌ. Yajaꞌ Hanin Akꞌbilintijan texol yu Comam Dios, machi watutan bay chinxewninojan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yalnipaxo huneꞌxa naj iscuywom Comam: —Mamin, chinoc tzujnojan tawintaj, yaj estam chawakꞌ inhamanilan chito inmujcano inmaman babel, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yalni Comam tet naj: —Wal xin ocan̈ tzujno wintajan yuto haꞌ mac camom yul sat Comam Dios, haꞌ chimujni yet camomal, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lahwi tuꞌ xin, yocto Comam Jesús yeb ebnaj iscuywom yul huneꞌ teꞌ barco. ");
INSERT INTO jacNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hayet lan̈an yecꞌto Comam yeb ebnaj yiban̈ ha haꞌ tuꞌ xin, yichico yecꞌ huneꞌ niman jakꞌekꞌ caw how. Toxan̈e chitiẍla yah ha haꞌ tuꞌ yin̈ teꞌ barco, wal Comam Jesús xin wayo chu yul teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hayet yilni ebnaj iscuywom Comam huneꞌ tuꞌ, yoc ebnaj yinolo iswayan̈ Comam, yalni ebnaj: —¡Mamin colon̈an̈, yuto lan̈an coto yich haꞌ! ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Istakꞌwi Comam tet ebnaj: —¿Tzet yin̈ xin caw chexxiwi? ¡Caw mach cheyaco heyanma yin̈ Comam Dios! ẍi Comam tet ebnaj. Lahwi tuꞌ xin yahwano Comam, iscachni Comam jakꞌekꞌ yeb ha haꞌ. Hac tuꞌ yu islin̈ban isbili ha haꞌ tuꞌ yeb jakꞌekꞌ, ispaxtzꞌin̈nahi. ");
INSERT INTO jacNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wal ebnaj iscuywom Comam tuꞌ, caw cꞌaycanilo iscꞌul ebnaj, yalni ebnaj tet hunun: —¿Mac anmahil huneꞌ yaꞌ tiꞌ yuxin chisyije jakꞌekꞌ yeb ha haꞌ tzet chal yaꞌ? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hayet yapni Comam Jesús yeb ebnaj iscuywom iskꞌaxepicꞌto haꞌ lago bey huneꞌ txꞌotxꞌ chiyij Gadara, yapni cawan̈ ebnaj ayco ischejab naj matzwalil yin̈ iscꞌatan̈ Comam; ispeto ebnaj yul camposanto. Ebnaj cawan̈ tuꞌ caw chixiw anma tet ebnaj yuto caw aycano yip ebnaj. Caw xin machi hunu mac chiecꞌ bay ay ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yah yaw ebnaj tet Comam yin̈ caw ip: —¿Tzet hawoc jin̈an̈ hach Jesús Iscꞌahol Dios? ¿Tom chachhul hawakꞌaꞌ ecꞌoyaꞌ janmahan̈ yalan̈to maẍto chiapni istiempohal? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iscawilal tuꞌ, ay huntekꞌan noꞌ txitam lan̈an istan̈elaxi, ");
INSERT INTO jacNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","yuxin iskꞌan ebnaj ischejab naj matzwalil tuꞌ tet Comam hacaꞌ tiꞌ: —Tato chon̈hawilojan̈ yin̈ ebnaj tiꞌ, chicokꞌanan̈ tawet, chejon̈tojan̈ yin̈ noꞌ txitam tuꞌ lah, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Istakꞌwi Comam: —Cꞌulticꞌa, asiꞌwej, ẍi Comam. Hac tuꞌ xin yu yel ebnaj ischejab naj matzwalil yin̈ ebnaj cawan̈ tuꞌ, istocano ebnaj yin̈ noꞌ txitam. Lahwi tuꞌ xin yelcan̈ noꞌ txitam tuꞌ, iskꞌojnito isba noꞌ sat pahaw, yay apno noꞌ xol ha haꞌ, ishikꞌnito noꞌ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wal ebnaj tan̈em txitam xin elcan̈ ebnaj. Hayet yapni ebnaj yul con̈ob yalni ebnaj tet anma yin̈ tzet yu ebnaj cawan̈ bay ayticꞌaco ebnaj ischejab naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yuxin sunil anma yul con̈ob tuꞌ to ilno Comam. Hayet yapni anma iscꞌatan̈ Comam tuꞌ xin, yoc anma iskꞌanno tet Comam tato chiel Comam yul ismajul istxꞌotxꞌ ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Lahwi tuꞌ xin yocto Comam Jesús yul teꞌ barco, ismeltzoti Comam iskꞌaxepxacꞌti haꞌ lago tuꞌ, yapni Comam yul iscon̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yilaxto huneꞌ naj mach chibili isnimanil iscꞌatan̈ Comam sat batxteꞌ. Hayet yilni Comam xin tato caw ayco yanma ebnaj initi naj tuꞌ yin̈ Comam, yalni Comam tet naj yaꞌay tuꞌ: —Hach wet anmahil aco yip hawanma, tinan̈ chiakꞌlaxcano nimancꞌulal yin̈ hamul, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ay xin huntekꞌan ebnaj cuywawom yin̈ isley naj Moisés, istxum hacaꞌ tiꞌ: “Huneꞌ naj tiꞌ caw txꞌoj istzotel naj yin̈ Comam Dios, yuto chaco isba naj Diosal,” ẍi ebnaj yul yet ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wal Comam xin, yohta tzet chiecꞌ yin̈ isnabal ebnaj, yuxin yal Comam: —¿Tzet yin̈ xin caw txꞌoj chiecꞌ yin̈ henabal? ");
INSERT INTO jacNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Baytet subuta walnihan heyalni, tom “chꞌakꞌlax nimancꞌulal yin̈ hamul,” mato “ahan̈wanoj cat hapaxtoj?” ");
INSERT INTO jacNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tinan̈ xin chinyehan heyilaꞌ tato Hanin Akꞌbilintijan texol yu Comam Dios, ay wipan wakꞌnihan nimancꞌulal yin̈ ismul anma yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. Yalni Comam tet naj yaꞌay tuꞌ: —Ahan̈wanoj, ican̈ habatxteꞌ tiꞌ cat hapaxto hawatut, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yin̈n̈ena tuꞌ xin yahwano naj, ispaxto naj yatut. ");
INSERT INTO jacNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hayet yilni anma huneꞌ tuꞌ caw xiwcanocan̈, yoc anma yakꞌno tzalaho iscꞌul yin̈ Comam Dios, yuto caw txꞌiꞌal yip Comam isye tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lahwi tuꞌ isto Comam Jesús. Hayet yecꞌto Comam xin, yilni Comam huneꞌ naj ikꞌomilo tohlabal, Mateo isbi. Tzꞌon̈anayo naj bay chiel chꞌen tohlabal chialaxto bey Roma. Yalni Comam Jesús tet naj: —Ocan̈ tzujno wintajan incuywomojan, ẍi Comam. Hayet yaben naj huneꞌ tuꞌ, yahwano naj, yoc tzujno naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lahwi tuꞌ yawtelax Comam waꞌo yu naj yul yatut, yoc Comam sat meẍa yeb ebnaj iscuywom, yebpaxo xin huntekꞌanxa ebnaj ikꞌomilo tohlabal, yeb huntekꞌan anma txꞌoj isbeybal. ");
INSERT INTO jacNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hayet yilni ebnaj fariseo huneꞌ tuꞌ, yalni ebnaj tet ebnaj iscuywom Comam: —¿Tzet yin̈ xin chiwaꞌ naj hecuywawom tiꞌ xol ebnaj ikꞌomilo tohlabal, yeb xol ebnaj txꞌoj isbeybal? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hayet yaben Comam huneꞌ tuꞌ xin, yalni Comam tet ebnaj: —Haꞌ anma mach yaꞌo ay, matzet chiocnico naj an̈lom yu, to haꞌ anma yaꞌay haꞌ chiocnico naj an̈lom yu. ");
INSERT INTO jacNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yuxin chiwalan teyet, saywe yul Yum Comam Dios cat hetxumni yin̈ bay chal hacaꞌ tiꞌ: “Haꞌ huneꞌ chiwochehan ta chitzꞌay hecꞌul yin̈ heyet anmahil, maẍn̈etaj heyakꞌni hexahanbal wetan,” ẍiayoj. Mach hulnajojinan wawteꞌan anma chalni ta cꞌul yecoj, ¡machoj! Walxinto yu anma chistxumu ta mulum, yuxin hulnajinan, yun̈e isbejnicano yanico ismul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yet hunel apni ebnaj ischejab naj Juan anican̈ haꞌ iswiꞌ anma iscꞌatan̈ Comam Jesús, iskꞌamben ebnaj tet Comam: —Han̈on̈tiꞌan̈ yeb ebnaj fariseo caw chicoyijehan̈ huneꞌ yet mach chon̈waꞌ cotxahli. Walpaxo ebnaj hacuywom xin, ¿tzet yin̈ xin mach chisyije ebnaj huneꞌ tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yalni Comam tet ebnaj: —Kꞌinalo tato ay hunu mohyilal tinan̈, aypaxo xin anma awtebil yin̈ mohyilal tuꞌ. ¿Tom xin chioc anma tuꞌ yijle wahil yet aycꞌo naj mohyom tuꞌ? ¡Machoj! Wal xin hato yet chiapni istiempohal yilaxilo naj mohyom tuꞌ xol anma, catto yoc anma yin̈ yijlen wahil, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yalnipaxo Comam: —Mach chu yalaxico hunu kꞌap kꞌap acꞌto isbujilo huno xilkꞌape xilxa, yuto hayet chitxꞌahlax kꞌap, chimoqꞌui kꞌap acꞌ ayco isbujilo kꞌap xilxa tuꞌ, cat xin istzilmocanto huneꞌ xilkꞌape tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hacpax tuꞌ xin, mach chu yalaxayto acꞌ vino yul noꞌ tzꞌum xilxa yuto chilin̈mo noꞌ cat ismalto vino tuꞌ, cat yetaxpaxcanto noꞌ tzꞌum tuꞌ. Wal xin yul noꞌ tzꞌum acꞌto chialaxayto acꞌ vino, hac tuꞌ xin mach chietaxto teꞌ vino yeb noꞌ tzꞌum, ẍi Comam Jesús tet ebnaj iscuywom naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hayet lan̈an yalni Comam Jesús huntekꞌan cuybanile tuꞌ, yapni huneꞌ naj yahawil yin̈ ebnaj Israel iscꞌatan̈ Comam, yalni naj tet Comam: —Mamin, ay huneꞌ nichꞌan incutzꞌinan lan̈anto iscamayoj, yaj ta chachto wintajan cat hawanayo hakꞌab yiban̈ ix, chihulcan̈ iscꞌul ix, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lahwi tuꞌ yah lin̈no Comam, isto yinta naj yeb ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Xol anma tzujan yinta Comam tuꞌ xin, ay huneꞌ ix yaꞌay, cablahon̈ebxa habil mach chilin̈i yay istxꞌahwobal ix. Yuxin hitzico ix iscꞌatan̈ Comam, ispitni ix istiꞌ xil iskꞌap Comam, ");
INSERT INTO jacNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yuto istxum ix hacaꞌ tiꞌ: “Walca han̈e istiꞌ xil iskꞌap Comam chinpitan cat incawxocan̈an,” ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wal Comam xin, ismeltzo isba Comam, yoc tꞌan̈no Comam yin̈ ix, yalni Comam hacaꞌ tiꞌ: —Aco yip hawanma miyay. Macachcawxican̈ tinan̈ yuto maxawaco hawanma win̈an, ẍi Comam tet ix. Yin̈n̈ena tuꞌ xin iscawxican̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hayet yapni Comam Jesús bey yatut naj yahawil ebnaj Israel tuꞌ xin, yilni Comam tato ayxacꞌo ebnaj chianico teꞌ suꞌ yin̈ ismujubal ix nichꞌan iscutzꞌin naj Jairo tuꞌ, yebpaxo xin wejanxan̈e anma yokꞌi. ");
INSERT INTO jacNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hayet yilni Comam huneꞌ tuꞌ, yalni Comam tet anma: —Elan̈wetoj, ix nichꞌan tiꞌ mach camnajo ix, ton̈e chiway ix, ẍi Comam. Wal anma tuꞌ xin oc tzebo yin̈ tzet yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lahwi ischejni Comam eloti sunil anma yul n̈a, yocto Comam iscꞌatan̈ ix nichꞌan tuꞌ. Yoc tzabno Comam yin̈ iskꞌab ix, yahwano ix. ");
INSERT INTO jacNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sunil anma ay yul ismajul huneꞌ con̈ob tuꞌ, abenilo tzet yuhi. ");
INSERT INTO jacNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yet yel Comam bey tuꞌ, ay cawan̈ ebnaj mach chu yilni oc tzujno yinta Comam. Chi-xin-awito ebnaj tet Comam hacaꞌ tiꞌ: —Mamin, iscꞌahol jichmam David, tzꞌayojab hacꞌul jin̈an̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hayet yapni Comam yul n̈a, yocpaxto ebnaj yul n̈a yinta Comam, yalni Comam tet ebnaj: —¿Chimheyayto yul heyanma tato chu wakꞌni hajlojan hesat? ẍi Comam. Istakꞌwi ebnaj tet Comam: —Hoꞌ Mamin, chijaytojan̈ yul janmahan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yanico Comam iskꞌab yin̈ isbakꞌsat ebnaj, yalni Comam tet ebnaj: —Yubojab hacaꞌ cheyoche yuto maxeyaco heyanma win̈an, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hac tuꞌ xin yu ishajlo isbakꞌsat ebnaj, yalnicano Comam tet ebnaj: —Tinan̈ xin, machi mac tet cheyalicꞌo huneꞌ tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yajaꞌ haniqꞌuixto chito ebnaj, yichico ebnaj yalni tet anma yin̈ tzet yu ishajlo isbakꞌsat ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hayet caw lan̈an ispaxto ebnaj hajlo isbakꞌsat yu Comam Jesús tuꞌ, yapni huntekꞌan ebnaj yakꞌnocano huneꞌ naj iscꞌatan̈ Comam. Huneꞌ naj tuꞌ mach chu istzotel naj yuto ayco ischejab naj matzwalil yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hayet ischejnilo Comam ischejab naj matzwalil yin̈ naj, yichico naj istzoteli. Wal anma ilni huneꞌ tuꞌ xin caw cꞌaycanocan̈ iscꞌul. Yalni anma hacaꞌ tiꞌ: —Maẍto hunelo chijil yuni yul con̈ob Israel hacaꞌ huneꞌ tiꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wal ebnaj fariseo xin yal ebnaj hacaꞌ tiꞌ: —Huneꞌ naj tiꞌ chílo naj ischejab naj matzwalil yin̈ anma yu yip naj matzwalil, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Caw sunil yulajla con̈ob yeb yulajla aldea bay ecꞌ Comam Jesús, iscuyni Comam anma yulaj iscapilla ebnaj Israel yul hunu con̈ob tuꞌ. Yalnicꞌo Comam yin̈ tzet chu yoc anma yul iskꞌab Comam Dios, yakꞌni cawxo Comam anma tzijxan̈e yabilal ayco yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hayet yilnico Comam yin̈ anma xin caw tzꞌaycan̈ iscꞌul yin̈ anma tuꞌ, yuto bejbilcanoj, mach chitxumcha yu tzet wal yuten isba. Hacaꞌ noꞌ meꞌ machi mac chitan̈eni, hac tuꞌ ye anma. ");
INSERT INTO jacNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yuxin yal Comam tet ebnaj iscuywom: —Huntekꞌan anma tiꞌ lahan hacaꞌ ixim trigo lan̈an iskꞌanbiloj. Caw hantan̈e munil, yajaꞌ haywan̈n̈e ebnaj munlawom. ");
INSERT INTO jacNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yuxin kꞌanwe tet Comam Dios yahaw munil, haxinwal chati Comam ismunlawom xol anma, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lahwi tuꞌ, iscutxbanico Comam Jesús ebnaj cablahon̈wan̈ iscuywom, yakꞌni Comam yip ebnaj yinilo ischejab naj matzwalil yin̈ anma, yebpaxo xin yu yakꞌni cawxo ebnaj anma yaꞌay, yeb yu yinilo ebnaj tzettaj yaꞌ yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hac tiꞌ xin isbi ebnaj cablahon̈wan̈ ischejab Comam hacaꞌ tiꞌ: Naj Simón chiyijpaxo Pedro, naj Andrés yuẍta naj Simón, naj Jacobo yeb naj Juan, ebnaj cawan̈ tiꞌ iscꞌahol icham Zebedeo ye ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Naj Felipe, naj Bartolomé, naj Tomás, naj Mateo, naj chiticꞌa inilo chꞌen tohlabal chito bey Roma, naj Jacobo iscꞌahol icham Alfeo, naj Tadeo. ");
INSERT INTO jacNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yebpaxo xin naj Simón, ayticꞌaco yin̈ huneꞌ partido chiyij cananista, yeb naj Judas Iscariote, naj anico Comam yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Haꞌ ebnaj cablahon̈wan̈ tiꞌ ischejto Comam Jesús, yalni Comam ischejbanil ebnaj hacaꞌ tiꞌ: —Mach chexecꞌ yulaj iscon̈ob anma mach Israeloj, yebpaxo xin mach chexecꞌ yulajla con̈ob ay yul ismajul Samaria. ");
INSERT INTO jacNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cachann̈e xol jet con̈ob Israel chextohi, yuto lahan anma hacaꞌ noꞌ meꞌ chicꞌayicꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Asiꞌwe xin, cat heyalni tet anma tato Comam Dios ay yul satcan̈ yocxa yahawo yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Akꞌwe cawxo anma yaꞌay, ta ay mac chicami cheyakꞌ hulucan̈ iscꞌul, ta ay mac ayco lepra yin̈ cheyakꞌ cawxoj, cat heyinipaxilo ischejab naj matzwalil yin̈ anma. Huneꞌ heyip chiwakꞌtiꞌan matanil chechah, yuxin mach chekꞌan hetohol yet cheyakꞌni cawxo anma. ");
INSERT INTO jacNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yin̈ hebel tuꞌ xin matzet cheyitoj; mach cheyito hemelyu, nitam hunu centavo, ");
INSERT INTO jacNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mach cheyipaxto hetzꞌispa, yeb hehelbal, mach cheyipaxto ishelbal hexan̈ab, yebpaxo xin mach cheyikꞌ hekꞌojoch. Chiwalan huntekꞌan tiꞌ teyet yuto naj munlawom chiakꞌlax tzet chislo naj yin̈ ismunil. ");
INSERT INTO jacNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hayet chexapni yul hunu con̈ob maca yul hunu aldea chesay mac cꞌulchꞌan iscꞌul, haꞌ tuꞌ xin chexcani masanto yet chexmeltzohi. ");
INSERT INTO jacNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yet chexapni bey teꞌ n̈a bay chexcancano tuꞌ, cheyal tet anma tuꞌ hacaꞌ tiꞌ: “Ayojab akꞌancꞌulal texol,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta choche mac ay yul huneꞌ n̈a tuꞌ akꞌancꞌulal, chiakꞌlax akꞌancꞌulal tuꞌ tet, taca mach choche xin, mach chiakꞌlax tet. ");
INSERT INTO jacNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yajaꞌ tato mach chexchahlaxi, yeb xin mach chiabelax tzet cheyala, chexel yatut anma tuꞌ maca yul huneꞌ con̈ob tuꞌ, cat xin hetzicnilo pojoj yin̈ heyoj yun̈e heyeniloj tato matxa heyoc yin̈ anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yin̈ caw yeli chiwalan teyet, yet chilni Comam yin̈ tzet chielico anma tuꞌ, caw ecꞌbalto isyaꞌtajil chischah sata anma ay bey con̈ob Sodoma yeb con̈ob Gomorra, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yalnipaxo Comam Jesús tet ebnaj iscuywom tuꞌ: —Chexinchejtojan xol anma hacaꞌ noꞌ meꞌ chito xol noꞌ oj. Yuxin helan cheyute heba hacaꞌ noꞌ laba, yajaꞌ huncuentan̈e cheyute hecꞌul hacaꞌ noꞌ cuwis. ");
INSERT INTO jacNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Caw cheyil heba, yuto chexilaxto sata ebnaj iswiꞌehal yin̈ lahtiꞌ yul con̈ob. Chexmakꞌlax yulajla capilla. ");
INSERT INTO jacNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chexalaxico sata ebnaj gobernador, maca sat ebnaj nimeta yahaw, yuto ayexico yul inkꞌaban. Hac tuꞌ chu quinheyakꞌnihan yohtan̈elo ebnaj, yeb tet anma mach Israeloj. ");
INSERT INTO jacNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hayet chexalaxico sata ebnaj yahaw tuꞌ, mach cheyaco yin̈ hecꞌul yin̈ tzet chu hetzoteli, yuto haꞌ Comam Dios chiakꞌni hehelanil hetzoteli. ");
INSERT INTO jacNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wal xin maẍtajex chextzoteli, to haꞌ Yespíritu Comam chitzotel teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yet chihul huneꞌ tiempohal tuꞌ ay ebnaj chianico yuẍta yul iskꞌab camical, aypaxo ebnaj mame chianico iscꞌahol yul iskꞌab camical, aypaxo xin ebnaj cꞌahole chianico howal yin̈ ismam cat ispotxꞌni camo ebnaj ismam. ");
INSERT INTO jacNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sunil anma chichiwa iscꞌul teyin̈ yuto ayexxaco yul inkꞌaban, yajaꞌ wal mac chitecha yu masanto yet islahobal, chicolchahi. ");
INSERT INTO jacNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hayet chextzumbelaxilo yul hunu con̈ob, chexel bey tuꞌ cat heto yul hunuxa con̈ob, yuto yin̈ caw yeli chiwalan teyet; maẍtoticꞌa chilahwi heyecꞌ yul sunil con̈ob Israel tiꞌ cat wul lemnahan, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Machi hunu naj lan̈an iscuylaxi chipalcꞌonnacan̈ yiban̈ naj chicuyni tuꞌ, yeb xin machi hunu naj chejab chipalcꞌonnacan̈ yiban̈ ispatrón. ");
INSERT INTO jacNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yajaꞌ tato ay hunu naj chicuywi tuꞌ chiapni yitzꞌatil iswiꞌ hacaꞌ naj cuywawom tuꞌ, caw cꞌul huneꞌ tuꞌ, yeb xin tato ay hunu naj chejab chiapni islahann̈e isba yeb ispatrón, cꞌulpaxo huneꞌ tuꞌ. Ta chinhallaxan Beelzebú, naj yahawil yin̈ ebnaj ischejab naj matzwalil, hajexxampaxoj, ¿tzet mach hallaxo teyin̈? ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yalnipaxo Comam Jesús: —Mach chexxiw tet anma, yuto machi hunu tzet ye tuꞌ ewan mach chiel yen̈el, yeb xin machi hunu tzet chihallax yin̈ ewantajil mach chiabchaloj. ");
INSERT INTO jacNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sunil tzet chiwalan teyet yin̈ ewantajil tinan̈, pujbawecꞌo tet anma. Yeb huntekꞌan ton̈e chinsahan yul hetxiquin, halwecꞌo yin̈ caw ip yulaj calle. ");
INSERT INTO jacNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mach chexxiw tet ebnaj chipotxꞌni henimanil, yuto wal heyanma mach chikꞌoji ebnaj ispotxꞌni. Wal xin han̈e tet Comam Dios bay wal hexiwi, yuto chu yanito Comam henimanil yeb heyanma xol kꞌa kꞌaꞌ mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Chisje hetxumni yin̈ noꞌ niẍte chꞌic tinan̈, cacꞌon̈ noꞌ chitxon̈lax yin̈ centavo. Yajaꞌ machi hunu noꞌ chicami tato maẍtaj Comam ay yul satcan̈ chihalni. ");
INSERT INTO jacNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Hajxam hex tiꞌ to caw ecꞌbal heyelapno sata noꞌ niẍte chꞌic tuꞌ, caw bisbil xil hewiꞌ yin̈ hununtajil yu Comam. Yuxin chiwalan teyet, mach chexxiwi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yalnipaxo Comam Jesús: —Haꞌ mac mach chitxꞌixwi yalni yin̈ sat anma tato wetxahan yehi, haquintuꞌan mach chintxꞌixwihan walnihan tet Inmaman ay yul satcan̈ tato wetan yehi. ");
INSERT INTO jacNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yajaꞌ wal mac chihalni yin̈ sat anma tato mach wetojan yehi, chiwalpaxojan yin̈ sat Inmaman ay yul satcan̈ tato mach wetojan yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yalnipaxo Comam Jesús: —Tajca chetxumu tato hulnajinan yu wanicojan akꞌancꞌulal xol anma yul sat yiban̈kꞌinal tiꞌ, machoj, walxinto yu yakꞌlencan̈ howal win̈an. ");
INSERT INTO jacNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Quinhulan yu yakꞌnican̈ howal naj cꞌahole yeb ismam, ix unine chioc ix howal yin̈ ismiꞌ, ix alibe chioc ix howal yin̈ ixnam alibe, ");
INSERT INTO jacNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yuxin xolticꞌa mac ayto yu isba chiah howal. ");
INSERT INTO jacNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mac ecꞌbal chaco yanma yin̈ ismam maca ismiꞌ insatajan, mach istzano yoc wetojan, yeb xin haꞌ mac ecꞌbal ayco yanma yin̈ iscꞌahol maca iscutzꞌin insatajan, mach istzano yoc yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Haꞌ mac hinan yakꞌlen isyaꞌtajil win̈an, waxan̈ca chiakꞌlax camo yin̈ culus, haꞌ chu yoc wetojan. ");
INSERT INTO jacNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Haꞌ mac ecꞌbal chisyaꞌiln̈e isba insatajan, chicꞌaytoj, mach chikꞌ iskꞌinal mach istan̈bal. Wal mac hinan iscam win̈an xin chischah iskꞌinal mach istan̈bal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yalnipaxo Comam Jesús: —Haꞌ mac chexchahni, haninan chinischahan, haꞌ mac chinchahnihan chischah Mac an̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Haꞌ mac chichahni hunu ischejab Comam Dios, lahan ismatan chischah hacaꞌ ischejab Comam tuꞌ. Mac chichahni hunu mac iscꞌulaln̈eticꞌa chiswatxꞌe, lahan ispaj chischah yeb mac iscꞌulaln̈eticꞌa chiswatxꞌe tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Haxa mac chiakꞌni hunu vaso chewalaꞌ tet hunu incuywoman, waxan̈ca caw comon jilni, yin̈ caw yeli chiwalan teyet, huneꞌ mac tuꞌ chischah ispaj selel tet Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lahwi yalnicano Comam Jesús ischejbanil ebnaj cablahon̈wan̈ iscuywom, isto Comam cuywal; yecꞌ Comam yalnocꞌo Istzotiꞌ Comam Dios yul hunun con̈ob ayco yin̈ ishoyanil bay ay Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yin̈ huneꞌ tiempohal tuꞌ ayicto naj Juan anican̈ haꞌ iswiꞌ anma yul preso. Yabe naj iskꞌumal yin̈ tzettaj chiswatxꞌe Comam Cristo. Ischejnito naj cawan̈ ebnaj iscuywom ");
INSERT INTO jacNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","iskꞌambeno tet Comam: —¿Ham hach tiꞌ Cristo echmabil yul juhan̈, mato chijechmahan̈ yul hunuxa naj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Istakꞌwi Comam: —As halwe tet naj Juan tuꞌ yin̈ sunil tzet maxeyabe yeb yin̈ tzet maxeyila. ");
INSERT INTO jacNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Halwe tet naj tato haꞌ mac maẍticꞌa chu yilni hajlocanocan̈ sat, haxa mac maẍticꞌa chu yeqꞌui, belwican̈. Haꞌ mac ayco lepra yin̈ xin an̈chacanoj, haꞌ mac maẍticꞌa chabe, hajlo istxiquin. Aypaxo camom hulcan̈ iscꞌul, cat xin yallaxpaxo Tzotiꞌ yet colbanile tet anma machi bay chicawxi iscꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Sakꞌal yet mac mach chicabcon yanma win̈an! quexchi, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hayet lahwi ispaxto ebnaj xin, yichico Comam yalni tet anma yin̈ tzet yelapno ye naj Juan, yalni Comam hacaꞌ tiꞌ: —Nawetij tzet quexbey heyilaꞌ bey txꞌotxꞌ desierto, ¿tom haꞌ huneꞌ teꞌ ah chꞌecꞌ kꞌelah yu jakꞌekꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Mato hunu naj caw nanxa yoc xil iskꞌap ayco quexbey heyilaꞌ? ¡Machoj! Yuto ebnaj caw nanxa islow yehico xil iskꞌap yuln̈e yatut ebnaj rey ay ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Mac quexbey heyilaꞌ? Wal xin huneꞌ ischejab Comam Dios quexbey heyilaꞌ. Yin̈ caw yeli huneꞌ ischejab Comam Dios quexbey heyilaꞌ tuꞌ caw ecꞌbalto yelapno ye ismunil naj sata ebnaj ischejab Comam Dios ecꞌlena yet payat. ");
INSERT INTO jacNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yin̈ naj Juan tzꞌibn̈ebilcano yul Yum Comam Dios bay chal hacaꞌ tiꞌ: Haninan chinchejtojan inchejaban babel tasataj, yun̈e iswatxꞌen habeh yalan̈to maẍto chachapni, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yin̈ caw yeli chiwalan teyet, xol sunil anma yul sat yiban̈kꞌinal tiꞌ machi hunu mac ecꞌbal yelapno yiban̈ naj Juan tuꞌ. Yajaꞌ wal mac chioc yul iskꞌab Comam Dios xin waxan̈ca caw comonn̈e yeqꞌui, ecꞌbal sakꞌal yet sata naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yet taxticꞌa yichiti naj Juan tuꞌ yanican̈ haꞌ iswiꞌ anma masanta tinan̈, yin̈ isyaꞌtajil choc anma yul iskꞌab Comam Dios, yajaꞌ han̈cꞌan̈e mac chihti yanma yin̈, haꞌ chitzujcha apno yu yoc yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sunil tzet yal ebnaj ischejab Comam Dios yet payat yeb sunil tzet yal isley naj Moisés yalan̈to maẍto chiichico ismunil naj Juan, ton̈e bina yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta cheyoche cheyayto yul heyanma yin̈ tzet chiwaltiꞌan, txumchaojabilo heyu tato haꞌ naj Juan tuꞌ, haꞌ naj hacaꞌ naj Elías echmabil yul heyu. ");
INSERT INTO jacNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Maquex cheyabe huneꞌ tiꞌ akꞌwe heyanma hetxumniloj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Anma ay yul huneꞌ tiempohal tiꞌ, cꞌul inlahbanan yeb niẍte unin chiay tzꞌon̈no yul txon̈bal cat issajchi, cat yahwi tet niẍte yet uninal, chalni: ");
INSERT INTO jacNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Naban̈e jeta cobahan̈ jokꞌtzenan̈ teꞌ suꞌ, yuto mach quexcan̈alwi. Naban̈e jacojan̈ bit caw biscꞌulal yoqui, yuto mach quexokꞌpaxoj,” ẍi niẍte unin tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chiwalan huneꞌ tiꞌ, yuto yet yul naj Juan anican̈ haꞌ iswiꞌ anma mach waꞌ naj yeb anma, yuxin hallaxi tato ayco ischejab naj matzwalil yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Haxa Hanin Akꞌbilintijan texol yu Comam Dios, chinwaꞌan yeb anma yuxin chihallax win̈an hacaꞌ tiꞌ: “Wal naj Jesús tiꞌ waꞌon̈eticꞌa chu naj yeb ucꞌu vinon̈eticꞌa chu naj, yamigo isba naj yeb ebnaj txꞌoj chiswatxꞌe yeb ebnaj ikꞌomilo tohlabal chꞌen chito bey Roma,” ẍi anma win̈an. Yajaꞌ wal anma ayco ishelanil Comam Dios yin̈ haban isyenilo isba yin̈ tzettaj iscꞌulal chi-la-iswatxꞌe, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yet hunel xin oc Comam Jesús yalaꞌ istxꞌojal huntekꞌan con̈ob bay caw txꞌiꞌal cꞌaybalcꞌule xaisye Comam, yuto anma ay yul huntekꞌan con̈ob tuꞌ maẍticꞌa chisna isba isbejnicano iswatxꞌen istxꞌojal, yuxin yal Comam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Hex ay yul con̈ob Corazín cꞌanchꞌanex, yeb hex ay yul con̈ob Betsaida, cꞌanchꞌanexpaxoj, yuto ta yul con̈ob Tiro yeb con̈ob Sidón yelax huntekꞌan cꞌaybalcꞌule chiyelax texol tiꞌ, payxam isbejcano anma iswatxꞌen istxꞌojal, yamahto anma tan̈ yin̈ iswiꞌ, yeb yamico anma xil iskꞌap chiyenilo biscꞌulal. ");
INSERT INTO jacNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yajaꞌ chiwalan teyet, yet chiapni istzꞌayical bay chil Comam Dios yin̈ tzet chielico anma, caw ecꞌbalto isyaꞌtajil chischah huntekꞌan anma tiꞌ sata anma ay yul con̈ob Tiro yeb anma ay yul con̈ob Sidón. ");
INSERT INTO jacNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Haxa hex ay yul con̈ob Capernaum, ham heyalni ta chexilaxcan̈ satcan̈, machoj; wal xin chexkꞌojlaxayto xol camom. Yuto ta yul con̈ob Sodoma yelax huntekꞌan cꞌaybalcꞌule chiyelax texol tiꞌ, isbejmicano anma yanico ismul, aytomicꞌo huneꞌ con̈ob tuꞌ tinan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yuxin chiwalan teyet yet chilni Comam Dios yin̈ tzet chielico anma, caw ecꞌbalto isyaꞌtajil chechah sata anma ah Sodoma tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hayet huneꞌ tiempohal tuꞌ txahli Comam Jesús, yalni Comam: —Mamin, yahawil satcan̈ yeb txꞌo txꞌotxꞌ, chiwakꞌan yuchꞌandios tawet yuto haweba huntekꞌan tiꞌ tet ebnaj ay ishelanil yeb tet ebnaj ay iscuyu yul sat anma, hawakꞌni yohtan̈elo anma matzet yohtaj. ");
INSERT INTO jacNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mamin, hac tuꞌ chuhi yuto hac tuꞌ el yin̈ hacꞌul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Lahwi tuꞌ yalni Comam tet anma: —Sunil tzet ye tuꞌ ayco yul inkꞌaban yu Inmaman. Machi hunu mac ohtan̈einan hanin Cꞌahole intiꞌan, cachann̈e Inmaman ohtan̈einan. Machi hunu mac ohtan̈e Inmaman, cachann̈e haninan quiniscꞌaholtiꞌan wohtajan, cat wakꞌnihan Inmamtuꞌan yohtan̈elo tet mac bay chiwochehan. ");
INSERT INTO jacNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maquex sicꞌomexxa yu hemunil yeb hex xatibayo heyu yalan̈ yalil heyijatz, titan̈we incꞌatan̈an, yuto haninan chexwakꞌ xewojan. ");
INSERT INTO jacNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ijwe huneꞌ ijatz chiwakꞌan heyijaꞌ. Cuywan̈we wintajan haxinwal chixew heyanma, yuto hanintiꞌan cꞌulchꞌan incꞌulal yeb xin ay isnimanil incꞌulan. ");
INSERT INTO jacNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Huneꞌ ijatz chiwakꞌan heyijaꞌ tiꞌ mach aloj, mach yaꞌtajo heyijenpaxoj, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yin̈ huneꞌ tzꞌayical xewilal ecꞌto Comam Jesús yeb ebnaj iscuywom yul huneꞌ nichꞌan beh xol ixim trigo. Caw xin xan̈ohcha ebnaj yuxin oc ebnaj yikꞌalo iswiꞌ ixim trigo, ischilnilo ebnaj ixim iscꞌuxuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hayet yilni ebnaj fariseo huneꞌ tuꞌ, yalni ebnaj tet Comam: —Ilcꞌanab tzet chu ebnaj hacuywom tilah, lan̈an yinilo ebnaj iswiꞌ ixim trigo iscꞌuxuꞌ. Yajaꞌ xin caw txahul comunla yin̈ istzꞌayical xewilal, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Istakꞌwi Comam tet ebnaj: —¿Tom maẍto cheyil yul Yum Comam Dios yin̈ tzet yakꞌle naj rey David yet caw chin̈ohcha naj yeb ebnaj tzujan yintaj? ");
INSERT INTO jacNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Naj David tuꞌ octo naj yul yatut Comam Dios iswahnito naj ixim pan haltebilxa tet Comam Dios, iswahnipaxo ebnaj tzujan yinta naj tuꞌ ixim. Wal xin han̈cꞌan̈e ebnaj sacerdote chu iswahni ixim. ");
INSERT INTO jacNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Tom maẍto cheyilpaxo yin̈ isley naj Moisés yin̈ tzet yu ebnaj sacerdote ay yul yatut Comam Dios? Ebnaj sacerdote tuꞌ mach chixew ebnaj yin̈ tzꞌayic xewilal, yajaꞌ mach chaco ebnaj ismul yul sat Comam Dios yin̈ huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yajaꞌ yin̈ caw yeli chiwalan teyet: Hanintiꞌan ecꞌbal welapnojan sata yatut Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tzettam sakꞌal tato chitxumchalo heyu bay chal yul Yum Comam Dios hacaꞌ tiꞌ: “Haꞌ huneꞌ chiwochehan tato chitzꞌay hecꞌul yin̈ heyet anmahil, maẍn̈etaj hen̈usni no nokꞌ yin̈ xahanbalil wetan,” ẍiayoj. Ta chetxum huneꞌ tiꞌ mach chimcheyala tato ay ismul ebnaj, wal xin mach ismul ebnaj yin̈ huneꞌ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wal Hanin Akꞌbilintijan texol yu Comam Dios chu walnihan yin̈ tzet cheyu yin̈ istzꞌayical xewilal, ẍi Comam tet ebnaj fariseo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lahwi tuꞌ isto Comam Jesús, yocto Comam yul iscapilla ebnaj Israel, ");
INSERT INTO jacNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","haꞌ tuꞌ xin ayicto huneꞌ naj camnajilo huneꞌ iskꞌab. Yun̈e yoc ebnaj fariseo akꞌocꞌule yin̈ Comam, yuxin iskꞌambe ebnaj tet Comam: —¿Chimyu jakꞌni cawxo hunu anma yaꞌay yin̈ istzꞌayical xewilal? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Istakꞌwi Comam tet ebnaj: —Kꞌinalo ta ay hunujex chitohcꞌay hunu hemeꞌ yul hunu cꞌuh yin̈ istzꞌayical xewilal, ¿mataxca mach chexto heyikꞌahti noꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hajxam hunu anma, to ecꞌbalto yelapno sata noꞌ meꞌ tuꞌ, yuxin chisje cowatxꞌen hunu tzet ye tuꞌ cꞌul yin̈ istzꞌayical xewilal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lahwi tuꞌ yalni Comam tet naj camnajilo huneꞌ iskꞌab tuꞌ: —Toholban̈elto hakꞌab, ẍi Comam. Hayet istoholban̈enilto naj iskꞌab tuꞌ, iswatxꞌicanilo. ");
INSERT INTO jacNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hayet yilni ebnaj fariseo huneꞌ tuꞌ yelti ebnaj yul capilla, yoc ebnaj islahtiꞌn̈en isba yin̈ tzet chu yakꞌni camo ebnaj Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hayet yabenilo Comam Jesús huneꞌ tuꞌ, isto Comam. Caw hantan̈e anma oc tzujno yinta Comam; yakꞌni cawxo Comam macta yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yalni Comam tet anma ta mach chispujbacꞌo yin̈ tzet iswatxꞌe Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hac tuꞌ yu yijnicano isba tzet tzꞌibn̈ebilcano yu naj Isaías, ischejab Comam Dios yet payat, bay chal hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Haꞌ naj tiꞌ inchejaban sicꞌbilico wuhan, caw xahan ay wuhan, caw chintzalahan yin̈ naj. Chiwacojan Wespírituhan yin̈ naj cat ispujbanicꞌo naj tetej con̈ob mach Israelo yin̈ tzet chu isbeybaln̈en istoholal. ");
INSERT INTO jacNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Machi mac yeb chiah howal yu naj, machi xin caw chiel yaw naj yin̈ caw ip, machipaxo chiel yaw naj yulaj calle. ");
INSERT INTO jacNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ay anma caw cꞌanchꞌan hacaꞌ teꞌ ah kꞌahnatoj, maca hacaꞌ teꞌ tah ton̈e chimutzꞌmun xaj kꞌaꞌ yin̈ hac tuꞌ yehi. Yajaꞌ haꞌ naj xin chicolwa yin̈; mach chislah naj yetantoj. Hac tuꞌ chute naj masanta chioc sunil yalan̈ istoholal yu naj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sunilej con̈ob chicawxi iscꞌul yin̈ naj, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yilaxto huneꞌ naj mach chu yilni yeb mach chu istzotel yu ischejab naj matzwalil tet Comam Jesús, yakꞌni cawxo Comam naj. Hac tuꞌ xin yu ishajlo isbakꞌsat naj, istzotelpaxocan̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sunil anma ilni huneꞌ tuꞌ caw cꞌayilo iscꞌul, yalni hacaꞌ tiꞌ: —¿Ham naj tiꞌ, titna yin̈ yuninal naj rey David echmabil yul ju? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yajaꞌ hayet yaben ebnaj fariseo yalni anma huneꞌ tuꞌ, yalni ebnaj: —Huneꞌ naj tiꞌ chilo naj ischejab naj matzwalil yin̈ anma, yaj yu ayco yip naj Beelzebú, naj yahawil ebnaj ischejab naj matzwalil yin̈ naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wal Comam yohtaxa tzet chiecꞌ yin̈ isnabal ebnaj, yuxin yal Comam: —Kꞌinalo ta chispoh isba anma yul hunu niman con̈ob, huneꞌ con̈ob tuꞌ yin̈ an̈emi chipax yip. Maca ta hunu con̈ob maca hunu n̈ahil anma chispoh isba cat yanico howal yin̈ hunun, caw yin̈ an̈emi chitan̈iloj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hac tuꞌ ye naj matzwalil, ta chaco naj howal yin̈ yet matzwalilal, yin̈ticꞌa naj chaco howal. ¿Tzet xin chu yikꞌni yip naj yin̈ hacaꞌ tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hex tiꞌ cheyala tato yu naj yahawil ebnaj matzwalil yuxin chiwilojan ischejab naj matzwalil yin̈ anma. Ta hac tuꞌ, ¿mac xin chiakꞌni yip ebnaj tzujan yin̈ hecuybanil yet chinilo ebnaj ischejab naj matzwalil yin̈ anma? Yuxin haꞌ ebnaj tuꞌ chiyenilo teyet tato mach cꞌulo tzet cheyal win̈an. ");
INSERT INTO jacNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yajaꞌ ta yu Yespíritu Comam Dios chiwilojan ischejab naj matzwalil yin̈ anma, haꞌ chalniloj tato ayxacꞌo yip Comam Dios texol. ");
INSERT INTO jacNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kꞌinalo hunu naj yahaw n̈a caw ay yip, machi hunu mac chu yocto yul yatut naj cat yelkꞌanilto tzet ay naj. Yajaꞌ ta chicꞌalbalax naj, wal tuꞌ chu yilaxilo tzet ay naj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Haꞌ mac mach ayoco wetbihojan ayco ishowal win̈an. Haꞌ mac mach chicolwa yanico anma yul inkꞌaban, haꞌ istzumbenilo anma tuꞌ haꞌ chu. ");
INSERT INTO jacNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yuxin chiwalan teyet, tzijxan̈e istxꞌojal yeb ismul anma chacoj, ay nimancꞌulal yin̈ yu Comam Dios. Yajaꞌ tato ay hunu mac txꞌoj istzotel yin̈ Comam Espíritu Santo, huneꞌ mac tuꞌ matxa bakꞌinal ay nimancꞌulal yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tato ay hunu mac txꞌoj istzotel win̈an, Hanin Akꞌbilintijan texol yu Comam Dios, ayto nimancꞌulal yin̈. Wal mac txꞌoj istzotel yin̈ Comam Espíritu Santo matxa nimancꞌulal yin̈, yin̈ huneꞌ cotiempohal tiꞌ yeb yin̈ huneꞌ chihul cosataj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yalnipaxo Comam Jesús: —Kꞌinalo hunu te teꞌ cꞌul, cꞌul sat teꞌ chakꞌa, wal teꞌ machiswalil, mach cꞌulo sat teꞌ chakꞌa. Yuxin yin̈ sat te teꞌ chicotxumu tzet teꞌal teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hex tiꞌ lahanex yeb noꞌ laba, caw txꞌojex. ¿Tzet chu heyalni tzotiꞌ cꞌul tato txꞌoj ayayto yul heyanma? Wal xin haꞌ tzet ayayto yul heyanma haꞌ chal hetiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Haꞌ mac iscꞌulal ayayto yul yanma, cꞌul tzotiꞌ chala, haxaꞌ mac istxꞌojal ayayto yul yanma, haꞌ istxꞌojal chala. ");
INSERT INTO jacNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yajaꞌ chiwalan teyet, yet chilni Comam Dios yin̈ tzet chielico anma, sunil mac chiilchahoti yin̈ tzettaj tzotiꞌal chielti yul istiꞌ, waxan̈ca comon tzotiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hataticꞌa hacaꞌ hetzoteli hac tuꞌ chu yilni Comam Dios yin̈ tzet chexelicoj, ta ay hemul maca machi hemul yin̈ tzet cheyala, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yet hunel tuꞌ, ay huntekꞌan ebnaj cuywawom yin̈ isley naj Moisés yeb ebnaj fariseo halni tet Comam: —Mam cuywawom chijochehan̈ chaye hunu cꞌaybalcꞌule jilaꞌan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Istakꞌwi Comam tet ebnaj: —Hex ayex yul huneꞌ tiempohal tiꞌ caw txꞌojexcanoj, caw man̈cꞌomex tet Comam Dios. Chekꞌan cꞌaybalcꞌule heyilaꞌ, huneꞌ chiyenilo ishelanil yip Comam Dios. Yajaꞌ huneꞌn̈e cꞌaybalcꞌule chiakꞌlax heyilaꞌ, haꞌ ton huneꞌ hacaꞌ tzet yakꞌle huneꞌ ischejab Comam Dios yet payat chiyij Jonás, haꞌ chiakꞌlax heyilaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Naj Jonás tuꞌ oxeb tzꞌayic yeb oxeb akꞌbal ayayto naj yul iscꞌul huneꞌ noꞌ niman cay. Hacaꞌ yakꞌle naj tuꞌ, hac tuꞌ chiwakꞌlehan, Hanin Akꞌbilintijan texol yu Comam Dios. Oxeb tzꞌayic yeb oxeb akꞌbal chinmujihan yul txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yet isbey naj Jonás tuꞌ yalno Istzotiꞌ Comam Dios tet anma ay yul con̈ob Nínive isbejnicano anma iswatxꞌen istxꞌojal. Wal tzet chiwaltiꞌan ecꞌbalto yelapno sata tzet yal naj Jonás tuꞌ, yajaꞌ mach chebejcano hetxꞌojal. Yuxin hayet islahobal tzꞌayic haꞌ huneꞌ con̈obal anma ah Nínive tuꞌ haꞌ chihalnilo hemul. ");
INSERT INTO jacNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hacpax tuꞌ yu ix reina ay yul ismajul txꞌotxꞌ Sabá, waxan̈ca caw nahat ay ix yajaꞌ masan hul ix yabe yitzꞌatil iswiꞌ naj rey Salomón. Yajaꞌ wal hanintiꞌan ecꞌbal welapnojan sata naj rey Salomón tuꞌ, yajaꞌ mach cheyaco yin̈ hecꞌul yin̈ tzet chiwalan. Yuxin yet islahobal tzꞌayic haꞌ caw ix reina tuꞌ chihalnilo hemul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yalnipaxo Comam Jesús: —Kꞌinalo ta ay hunu ischejab naj matzwalil chiel yul yanma hunu anma. Lahwi yel naj tuꞌ cat isto naj bey txꞌotxꞌ desierto issayaꞌ bay chixewi, yajaꞌ mach chiilcha bay chixew naj tuꞌ yu. ");
INSERT INTO jacNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Lahwi tuꞌ cat yecꞌ yin̈ isnabal naj hacaꞌ tiꞌ: “Etzan̈em cꞌul inmeltzohan bayticꞌa ayinan,” ẍi naj. Haxa yet chiapni naj xin cat yilni naj yanma huneꞌ naj tuꞌ hacaꞌ hunu n̈a machi yahaw, caw cꞌul yecan̈ kꞌalem yul. ");
INSERT INTO jacNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hayet chilni naj huneꞌ tuꞌ xin cat isto naj yinoti hujwan̈xa yetbi caw ecꞌbalto istxꞌojal sataj, cat yocto ebnaj ehoyo yul yanma huneꞌ naj tuꞌ. Huneꞌ naj bay chiocto ebnaj tuꞌ, caw ecꞌbalto txꞌoj chielico naj sata yet babelal. Hacaꞌ chakꞌle huneꞌ naj tuꞌ hac tuꞌ chakꞌle huntekꞌan anma caw txꞌoj tiꞌ tinan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hayet lan̈an istzotel Comam tet anma tuꞌ xin yapni ismiꞌ Comam yeb ebnaj yuẍta Comam, iscancano istiꞌ ispultahil teꞌ n̈a bay ayicto Comam. Yajaꞌ xin yoche ismiꞌ Comam yeb ebnaj yuẍta tuꞌ tzotelo tet. ");
INSERT INTO jacNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yuxin yal huneꞌ naj tet Comam: —Mamin, aycꞌo hamiꞌ yeb ebnaj hawuẍta istin̈a, choche ebnaj tzotelo tawet yalni, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yajaꞌ takꞌwi Comam tet naj: —¿Mac xin inmiꞌan yeb wuẍtatuꞌan hawalni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lahwi tuꞌ isyenito Comam tet ebnaj iscuywom, yalni Comam: —Haꞌ huntekꞌan anma tiꞌ haꞌ hacaꞌ inmiꞌan yeb hacaꞌ wuẍtajan. ");
INSERT INTO jacNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yuto haꞌ mac chiyijen tzet chal Inmaman ay yul satcan̈, haꞌ ton wuẍtajan, wanaban yeb inmiꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yin̈ticꞌa huneꞌ tzꞌayic tuꞌ, elti Comam Jesús yul n̈a, isto Comam istiꞌ haꞌ lago, yay tzꞌon̈no Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yajaꞌ caw txꞌiꞌal anma apni iscꞌatan̈ Comam, yuxin ahto Comam yul huneꞌ teꞌ barco, yay tzꞌon̈noj, yichico Comam iscuywahi. Wal anma xin cancano istiꞌ haꞌ lago tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Caw txꞌiꞌal yechel yaco Comam yet iscuyni Comam anma tuꞌ, yichico Comam yalni hacaꞌ tiꞌ: —Yet hunel ay huneꞌ naj to txiho trigo. ");
INSERT INTO jacNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yet lan̈an istxihni naj ixim, ay ixim apni cꞌatna yul beh, yapni noꞌ chꞌic issicꞌnocan̈ ixim. ");
INSERT INTO jacNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aypaxo ixim apni cꞌatna xolaj chꞌen chꞌen bay machi bin txꞌo txꞌotxꞌ; caw xin pet ahilo ixim yuto mach nahato yehayto yich txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yajaꞌ haxa yet yahilo tzꞌayic yet yikꞌnican̈ yip kꞌaꞌ istajilo ixim yuto machi bay yayto isxeꞌ ixim yu chꞌen chꞌen tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aypaxo ixim apni cꞌatna xol yin̈atil teꞌ txꞌix, hayet ischꞌibcan̈ ixim ischꞌibpaxocan̈ teꞌ txꞌix tuꞌ, hac tuꞌ yu istzꞌonbayo ixim xol teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Walpaxo ixim hin̈at apni xol txꞌo txꞌotxꞌ caw cꞌul, caw sakꞌal yu ischꞌibcan̈ ixim. Yet yakꞌni ixim sat, ay ixim akꞌni cien yin̈ hunun iswiꞌ, aypaxo ixim sesenta, aypaxo ixim yakꞌ treinta sat yin̈ hunun iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Maquex cheyabe huneꞌ tiꞌ akꞌwe heyanma hetxumniloj, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lahwi tuꞌ ishitzico ebnaj iscuywom Comam Jesús iscꞌatan̈, iskꞌamben ebnaj: —Mamin, ¿tzet yin̈ yuxin yet chacuyni anma yecheln̈e chawakꞌbaln̈e tet? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Istakꞌwi Comam: —Teyetn̈e chakꞌ Comam Dios heyohtan̈elo huntekꞌan tzet ye tuꞌ ewan yehi, yun̈e hetxumni yin̈ tzet chu heyoc yul iskꞌab Comam Dios. Walpaxo tet huntekꞌanxa anma xin mach chꞌakꞌlax yohtan̈eloj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yuto haꞌ mac chiyoche chiyohtan̈elo huntekꞌan tiꞌ caw ecꞌnaxa chiakꞌlax yohtan̈eloj, wal mac mach choche yohtan̈eloj, haꞌ nichꞌan etza chitxumcha yu chiilaxilo tet. ");
INSERT INTO jacNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yuxinto yecheln̈e chiwacojan yet chincuynihan anma. Wal xin waxan̈ca chiyila, yajaꞌ mach chinachalo yu, waxan̈ca chabe yajaꞌ mach chitxumchalo yu. ");
INSERT INTO jacNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yuto lan̈an yijni isba tzet tzꞌibn̈ebilcano yin̈ huntekꞌan anma tiꞌ yu naj Isaías, ischejab Comam Dios yet payat, bay chal hacaꞌ tiꞌ: Wal huntekꞌan anma tiꞌ waxan̈ca chabe, yajaꞌ mach chitxumchalo yu. Waxan̈ca chiyila, yaj mach chináchalo yu. ");
INSERT INTO jacNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yuto huntekꞌan anma tiꞌ caw nohna yanma yu ecꞌnajil, hacaꞌtan̈e majan istxiquin yuxin mach chabe. Hacaꞌtan̈e mutzꞌan sat yuxin mach chila, hac tuꞌ xin mach chistxum isba cat yanico isba yul inkꞌaban cat yan̈chahi, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yajaꞌ walex tiꞌ sakꞌal heyet, yuto haban istxumchalo heyu yet cheyilni, yeb xin yet cheyabeni haban henaniloj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yin̈ caw yeli chiwalan teyet, caw txꞌiꞌal ebnaj ischejab Comam Dios, yeb txꞌiꞌal mac cꞌul isbeybal yet payat yocheꞌ yilaꞌ huntekꞌan cheyil tiꞌ, yajaꞌ mach yil ebnaj. Yochepaxo ebnaj yabe huntekꞌan cheyabe tiꞌ yajaꞌ mach yabe ebnaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yalni Comam Jesús: —Tinan̈ xin chiwalan teyet yin̈ tzet chal yelapno naj txihom trigo. ");
INSERT INTO jacNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ixim hin̈at aycꞌay yul beh, yechel yeco ixim yin̈ mac chiaben Istzotiꞌ Comam Dios, yajaꞌ mach chitxumchalo yu. Lahwi tuꞌ cat yul naj matzwalil yinolo Istzotiꞌ Comam tuꞌ yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Haxa ixim hin̈at aycꞌay yiban̈ chꞌen chꞌen, yechel huneꞌ tuꞌ yin̈ anma chiaben Istzotiꞌ Comam Dios cat ischahni yul yanma yin̈ tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yajaꞌ machi caw yip yanma yin̈ yet Comam, yeb xin mach huneln̈eho chucanico yin̈ yanma, yuxin hayet chihul ilwebal yin̈ yu Istzotiꞌ Comam, yin̈ an̈e chicabconcan̈ iscꞌul cat ismeltzo yintaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Haxa ixim hin̈at apni cꞌatna xol yin̈atil teꞌ txꞌix, yechel huneꞌ tuꞌ yin̈ mac chiaben Istzotiꞌ Comam Dios yajaꞌ yu ecꞌbalto chaco yanma yin̈ kꞌalomal yeb yin̈ tzet ay yul sat yiban̈kꞌinal tiꞌ, yuxin chilo yanma yin̈ Istzotiꞌ Comam Dios. Haꞌ huntekꞌan anma tuꞌ lahan hacaꞌ ixim trigo tzꞌonbayoj, machi sat yakꞌa. ");
INSERT INTO jacNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wal ixim hin̈at aycꞌay bay caw cꞌul txꞌo txꞌotxꞌ xin, yechel huneꞌ tuꞌ yin̈ anma chiaben Istzotiꞌ Comam Dios, caw cꞌul istxumni cat ischahni yul yanma, lahan yeb ixim trigo caw niman sat yacoj. Ay mac hacaꞌ ixim trigo yakꞌ cien sat yin̈ hunun iswiꞌ, aypaxo mac hacaꞌ ixim yakꞌ sesenta, aypaxo xin mac hacaꞌ ixim yakꞌ treinta yin̈ hunun iswiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yalnipaxo Comam Jesús huneꞌ yechel hacaꞌ tiꞌ: —Hayet chioc Comam Dios yahawilo anma, lahan hacaꞌ chakꞌle hunu naj chitxihni ixim hin̈at trigo caw cꞌul sat istxꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yajaꞌ yet akꞌbalil xin yet wayo chu naj, yapni huneꞌ naj ayco ishowal yin̈ naj, istxihnayo naj yin̈atil teꞌ chꞌim hacaꞌ ixim trigo tuꞌ xol ixim, isto naj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lahwi tuꞌ ischꞌibcan̈ ixim, haxa yet yoc iswiꞌ ixim isyenilo isba teꞌ chꞌim tuꞌ xol ixim. ");
INSERT INTO jacNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hayet yilni ebnaj munlawom huneꞌ tuꞌ, isto ebnaj yalno tet naj yahaw munil hacaꞌ ti: “Mamin, caw cꞌul ixim hin̈at trigo cachbey hatxihayoj, yajaꞌ ¿tzet yin̈ xin caw ay teꞌ chꞌim ahilo xol ixim?” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Istakꞌwi naj: “Ham hunu mac ayco ishowal win̈an txihnayo yin̈atil teꞌ chꞌim xol ixim,” ẍi naj. Iskꞌambenpaxo ebnaj ismunlawom naj tuꞌ: “Ta chisje hacꞌul chon̈tohan̈ cohocꞌocan̈an̈ teꞌ chꞌim tuꞌ xol ixim,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yalni naj: “Machoj, yuto ta chehocꞌcan̈ teꞌ ham hun ixim trigo chehocꞌcan̈ yinta teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wal xin chꞌibojabna teꞌ xol ixim, hatojab yet chiapni istempohal bay chicꞌuplaxcan̈ ixim cat yah teꞌ, cat walnihan tet ebnaj inmunlawoman tato chiscꞌupcan̈ ebnaj teꞌ xol ixim cat iscꞌalnayo ebnaj teꞌ yin̈ hunun yachan, lahwi tuꞌ cat isn̈uslaxto teꞌ. Wal ixim trigo tuꞌ xin chicꞌubalaxto ixim yul incꞌun̈ahan,” ẍi naj yahaw munil tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yanipaxico Comam Jesús yin̈atil teꞌ mostaza yechelo yet iscuywahi, yalni Comam hacaꞌ tiꞌ: —Chiwalpaxojan teyet yin̈ tzet chu ischꞌib isbisil anma chioc yul iskꞌab Comam Dios, lahan hacaꞌ nichꞌan yin̈atil teꞌ mostaza chistzꞌun hunu naj sat istxꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yin̈ caw yeli, teꞌ hin̈at mostaza tuꞌ, haꞌ teꞌ caw niẍchꞌan xol teꞌ hin̈at, yaj haxa yet chiahilo teꞌ cat ischꞌibcan̈ teꞌ, haꞌ teꞌ caw nimej chielico xol sunilej teꞌ itah chitzꞌunlaxi. Teꞌ mostaza tuꞌ nimej chu teꞌ yuxin chiapni noꞌ chꞌic iswatxꞌe yatut xol iskꞌab teꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yanipaxico Comam Jesús yan̈al ixim pan yechelo yet iscuywa tet anma, yalni Comam tet anma tuꞌ: —Chiwalpaxojan teyet yin̈ tzet chu ischꞌib isbisil anma chaco isba yul iskꞌab Comam Dios. Lahan hacaꞌ nichꞌan yan̈al ixim pan chaco hunu ix ix xol oxeb mal ixim harina. Haxa yet chissomni ix ixim cat issipcꞌa ixim yu nichꞌan yan̈al chioqui, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yet yakꞌni Comam Jesús Istzotiꞌ Comam Dios iscuyu anma naba yecheln̈e bay tzotel Comam, ");
INSERT INTO jacNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","yun̈e yijni isba tzet tzꞌibn̈ebilcano yu ischejab Comam Dios yet payat, bay chal hacaꞌ tiꞌ: Yecheln̈e chiwakꞌan tet anma yet chintzotelan. Chiwalan tet yin̈ huntekꞌan tzet ewan yehi yichitaxticꞌa iswatxꞌi yul sat yiban̈kꞌinal ti, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lahwi tuꞌ istakꞌli Comam Jesús tet anma chiaben tzet chal tuꞌ, yocto Comam yul n̈a yeb ebnaj iscuywom. Ishitzico ebnaj iscꞌatan̈ Comam iskꞌamben ebnaj yin̈ tzet chal yelapno teꞌ chꞌim ahilo xol ixim trigo. ");
INSERT INTO jacNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yalni Comam tet ebnaj xin: —Naj txihom trigo yechel yeco naj win̈an, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Haꞌ txꞌo txꞌotxꞌ bay txihlaxayo ixim trigo, yechel anma ay yul sat yiban̈kꞌinal tiꞌ ye txꞌotxꞌ. Haꞌ ixim hin̈at cꞌul, yechel anma chioc yul iskꞌab Comam Dios ye ixim. Haxa teꞌ chꞌim chꞌibcan̈ xol ixim trigo tuꞌ, yechel anma ayco yul iskꞌab naj matzwalil ye teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naj txihnayo teꞌ hin̈at chꞌim xol ixim trigo tuꞌ, yechel naj matzwalil ye naj. Yet chicꞌuplaxcan̈ ixim trigo tuꞌ xin, yechel yin̈ yet chilahwi yul sat yiban̈kꞌinal tiꞌ. Haxa ebnaj chicꞌupni ixim trigo tuꞌ, yechel ebnaj ángel ye ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hacaꞌ yet chiilaxilo teꞌ chꞌim xol ixim trigo cat isn̈uslaxto teꞌ, hac tuꞌ chiutelax anma mach chaco isba yul iskꞌab Comam Dios yet chitan̈ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hanin Akꞌbilintijan texol yu Comam Dios tiꞌ, chinchejtijan ebnaj ángel iscutxbaco sunil mac chꞌakꞌni aycꞌayo yet anmahil yeb mac istxꞌojaln̈eticꞌa chiswatxꞌe, ");
INSERT INTO jacNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","cat yalaxto huntekꞌan mac tuꞌ xol kꞌa kꞌaꞌ bay chꞌokꞌi, cat isn̈etxꞌla yeh yu isyaꞌil. ");
INSERT INTO jacNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wal mac chiyijen tzet chal Comam Dios xin, chitzejla hacaꞌ tzꞌayic yul iskꞌab Comam Dios ay yul satcan̈. Maquex cheyabe huneꞌ tiꞌ akꞌwe heyanma hetxumniloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yalnipaxo Comam Jesús: —Anma chꞌoc yul iskꞌab Comam Dios, lahan yeb huneꞌ kꞌalomal caw ay istohol mujbil yul txꞌo txꞌotxꞌ chiilcha yu huneꞌ naj, lahwi tuꞌ cat ismujnipaxo naj. Caw xin chitzala naj yin̈ huneꞌ kꞌalomal tuꞌ cat isto naj istxon̈noto sunil tzet aya yun̈e islokꞌni naj huneꞌ txꞌotxꞌ bay mujan huneꞌ kꞌalomal tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yalnipaxo Comam Jesús: —Haꞌ anma chꞌoc yul iskꞌab Comam Dios, lahan hacaꞌ hunu naj txon̈wom chiecꞌ sayno huntekꞌan chꞌen chꞌen caw ay istohol chiyij perla. ");
INSERT INTO jacNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Haxa yet chiilcha hunu chꞌen yu naj, chito naj istxon̈oꞌto sunil tzet aya cat islokꞌni naj huneꞌ chꞌen perla caw cꞌul tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yalnipaxo Comam Jesús: —Chiwalpaxojan teyet, haꞌ anma chioc yul iskꞌab Comam Dios, lahan yeb huneꞌ txꞌan̈ hacꞌ ikꞌomati cay chayto huntekꞌan ebnaj xol ha haꞌ. Yet chibejlaxayto txꞌan̈ xol haꞌ caw txꞌiꞌal noꞌ cay chioc yul txꞌan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Haxa yet chinohilo txꞌan̈ yu noꞌ xin cat yilaxahti txꞌan̈ xol haꞌ, cat yay tzꞌon̈no ebnaj istiꞌ haꞌ, cat issicꞌnilo ebnaj noꞌ cꞌul cat yanayto ebnaj noꞌ yul motx. Haxa noꞌ mach cꞌuluj xin, chiskꞌojto ebnaj noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hac tuꞌ chakꞌle anma yet chilahwi huneꞌ yul sat yiban̈kꞌinal tiꞌ. Chul ebnaj ángel ispoholo anma txꞌoj xol anma cꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Haꞌ huntekꞌan anma txꞌoj chialaxto xol kꞌa kꞌaꞌ, haꞌ bey tuꞌ xin chiokꞌ yin̈ cat isn̈etxꞌla yeh yu isyaꞌil, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lahwi tuꞌ iskꞌamben Comam Jesús tet ebnaj iscuywom hacaꞌ tiꞌ: —¿Chimhetxum sunil huntekꞌan yechel chiwaltiꞌan? ẍi Comam. Istakꞌwi ebnaj: —Hoꞌ Mamin, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yalni Comam xin: —Haꞌ chalilo huneꞌ tiꞌ, ta ay hunu naj cuywawom yin̈ ley chicuywa yin̈ tzet chu yoc anma yul iskꞌab Comam Dios, lahan hacaꞌ hunu naj mame yohta yocnico huntekꞌan tzet ye tuꞌ acꞌ yu yeb huntekꞌan tzet ye tuꞌ xilxa cꞌuwan yul iscꞌuwanbal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lahwi yalnicano Comam huntekꞌan cuybanile tuꞌ, isto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yet yapni Comam yul iscon̈ob, iscuyni Comam anma yul iscapilla ebnaj Israel. Hayet yaben anma istzotel Comam, caw cꞌayilo iscꞌul, yuxin yal anma hacaꞌ tiꞌ: —¿Bay chitit ishelanil huneꞌ naj tiꞌ, yeb bay chitit iscan̈il ye naj iswatxꞌen huntekꞌan cꞌaybalcꞌule tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naj tiꞌ iscꞌahol naj hutxꞌum teꞌ ye naj, yebpaxo yunin ix María ye naj, yeb yuẍta isba naj yeb naj Jacobo, naj José, naj Simón yeb naj Judas. ");
INSERT INTO jacNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yebpaxo xin ebix yanab naj, coxol tiꞌ ay ebix. ¿Baytaxca xin chitit ishelanil naj tiꞌ? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yuxin machi cam iscꞌul anma yaben tzet chal Comam. Yalni Comam tet anma tuꞌ: —Sunil bay xahan chiillax ischejab Comam Dios yu anma, yajaꞌ wal yul iscon̈ob yeb yul yatut chiyahlaxi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wal Comam xin mach txꞌiꞌalo cꞌaybalcꞌule isye Comam yul iscon̈ob tuꞌ, yuto mach chayto anma yul yanma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yin̈ huneꞌ tiempohal tuꞌ xin, yabelo naj rey Herodes, naj ayco gobernadoral bey Galilea, isbina Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yuxin yal naj tet ebnaj chimunla yinta tuꞌ: —Huneꞌ naj chibina tuꞌ, ham naj Juan anican̈ haꞌ iswiꞌ anma itzitzbican̈, yuxin ay yip naj iswatxꞌen huntekꞌan cꞌaybalcꞌule tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yal naj huneꞌ tuꞌ yuto haꞌ naj chejni tzablaxoyo naj Juan, iscꞌallaxayo naj yu chꞌen cadena, yalaxicto naj yul preso yuto cachwa naj yin̈ naj Herodes tuꞌ yet yikꞌnican̈ naj ix Herodías, yixal yuẍtaj, haꞌ ton naj Felipe. ");
INSERT INTO jacNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Caw xin txꞌiꞌal el yal naj Juan tuꞌ tet naj Herodes hacaꞌ tiꞌ: —Mach cꞌulo hawikꞌni yixal hawuẍtaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wal naj Herodes tuꞌ xin caw yoche naj ispotxꞌoꞌ naj Juan, yaj xin xiw naj yuto sunil anma chalni tato ischejab Comam Dios ye naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yet hunel xin, yecꞌtze naj Herodes huneꞌ kꞌin̈ yuto tzꞌajna naj yin̈ ishabilal, caw xin txꞌiꞌal anma yawte naj. Yin̈ kꞌin̈ tuꞌ, can̈alwi ix yunin ix Herodías yin̈ sat naj Herodes yeb yin̈ sat sunil anma awtebil. Caw xin cꞌulchꞌan yu iscan̈alwi ix yil naj, ");
INSERT INTO jacNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yuxin yalte naj tet ix tato chakꞌ naj tzijxan̈e tzet chiskꞌan ix. ");
INSERT INTO jacNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yalni ismiꞌ ix tet tato chiskꞌan ix iswiꞌ naj Juan; yuxin yal ix tet naj Herodes tuꞌ: —Haꞌ iswiꞌ naj Juan anican̈ haꞌ iswiꞌ anma chawakꞌ wetan yul hunu plato, ẍi ix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hayet yaben naj Herodes huneꞌ tuꞌ yoc biscꞌulal yin̈ iscꞌul naj. Yajaꞌ yu xayal naj yin̈ sat sunil anma tet ix tato chakꞌ naj tzet chiskꞌan ix, yuxin yal naj ta chiakꞌlax tzet chiskꞌan ix tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ischejni naj yilaxolo iswiꞌ naj Juan yul preso. ");
INSERT INTO jacNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hac tuꞌ xin yu yilaxti iswiꞌ naj yul huneꞌ plato yakꞌlax tet ix, yinito ix tet ismiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lahwi tuꞌ xin, yapni ebnaj iscuywom naj Juan tuꞌ, yinito ebnaj isnimanil naj mujlaxoj. Tzujan tuꞌ isbey ebnaj yalno tet Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hayet yaben Comam Jesús ta cam naj Juan yel Comam bey tuꞌ, yahto Comam yul huneꞌ teꞌ barco, yecꞌ apno Comam iskꞌaxepicꞌto haꞌ lago bay machi anma. Hayet yaben anma ay yulaj con̈ob xin tato to Comam, istopaxo anma yu yoj istiꞌla haꞌ bay chiapni Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hayet yelti Comam yul teꞌ barco tuꞌ xin yilnitoj ta tenanxato anma yechmani. Istzꞌaycan̈ iscꞌul Comam yin̈ anma, yakꞌni cawxo Comam anma yaꞌay ilaxto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Haxa yet lan̈anxa iskꞌejbayo xin, ishitzico ebnaj iscuywom Comam iscꞌatan̈, yalni ebnaj tet Comam: —Mamin, makꞌejbi lah yebpaxo xin machi teꞌ n̈a bey tiꞌ, yuxin cꞌulmi hachejnito anma tiꞌ yulaj wayan̈bal cocawilal tiꞌ islokꞌo tzet chislo, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yalni Comam tet ebnaj: —Mach yilalo chipaxto anma tiꞌ, akꞌwe tzet chislo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Istakꞌwi ebnaj tet Comam: —Mamin, caw han̈cꞌan̈e howeb ixim pan yeb cacꞌon̈ cay coxol tiꞌ, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yalni Comam: —Iweti ixim yeb noꞌ cay tuꞌ bey tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lahwi tuꞌ ischejni Comam anma cutxanico tuꞌ tato chiay tzꞌon̈no sat chekꞌan. Yinican̈ Comam ixim howeb pan yeb noꞌ cacꞌon̈ cay, yah tꞌan̈no Comam satcan̈, yakꞌni Comam yuchꞌandiosal tet Comam Dios yin̈ ixim yeb yin̈ noꞌ. Lahwi tuꞌ iskꞌaxponayo Comam ixim, yakꞌni Comam ixim tet ebnaj iscuywom, yoc ebnaj yitxkꞌanoto ixim yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Caw sunil anma waꞌi hantaticꞌa caw yoche iscꞌul, caw xin cablahon̈ebto motx nohcan̈ yin̈ ixim matxa lahwi yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Caw howeb mil ebnaj winaj waꞌi, wal ebix ix yeb niẍte unin mach oc istzꞌajo yin̈ huneꞌ isbisil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lahwi tuꞌ xin, yalni Comam Jesús tet ebnaj iscuywom ta chꞌocto ebnaj yul huneꞌ teꞌ barco yu isbabito ebnaj iskꞌaxepxacꞌto haꞌ lago tuꞌ. Wal Comam cancano Comam takꞌlo tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hayet lahwi istakꞌlicano Comam tet anma tuꞌ xin, yahto Comam txahlo ischuquil istzalanil huneꞌ witz. Haꞌ tuꞌ xin ah akꞌbal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wal ebnaj iscuywom Comam nahatxa chito ebnaj yiban̈ haꞌ lago tuꞌ, yaj xin ay huneꞌ niman jakꞌekꞌ chimakꞌnican̈ ha haꞌ sata teꞌ barco tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Haxa yet lan̈anxa issajbilo xin istzujcha ebnaj yu Comam, belwito Comam yiban̈ ha haꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hayet yilni ebnaj isbelwi Comam yiban̈ haꞌ isxiwcan̈ ebnaj, yah yaw ebnaj yu xiwquilal, yalni ebnaj: —¡Huneꞌ tiꞌ ispixan camom! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yalnican̈ Comam: —Mach chexxiwi, haninan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yalni naj Pedro tet Comam: —Mamin, ta hach huneꞌ tuꞌ, hala ta chinbelwihan yiban̈ ha haꞌ tiꞌ cat wapnihan bay ayach tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yalni Comam tet naj xin: —Cꞌulticꞌa, titan̈, ẍi Comam. Hayet yaben naj Pedro huneꞌ tuꞌ, yel naj yul teꞌ barco, isto naj iscꞌatan̈ Comam, yichico naj isbel yiban̈ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yajaꞌ yet yilni naj isbili haꞌ tuꞌ yu jakꞌekꞌ isxiwcan̈ naj, yichico naj isto xol haꞌ, yah yaw naj tet Comam yin̈ caw ip: —Mamin, colinan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yin̈ an̈e xin oc tzabno Comam yin̈ iskꞌab naj, yalni Comam tet naj: —Hach tiꞌ caw mach ayoco hawanma win̈an. ¿Tzet yin̈ xin macabconcan̈ hacꞌul? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Haxa yet yahto Comam yul teꞌ barco yeb naj, islin̈i yecꞌ jakꞌekꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wal sunil ebnaj ayicto yul teꞌ barco tuꞌ xin ay jahno ebnaj sata Comam, yalni ebnaj hacaꞌ tiꞌ: —¡Yin̈ caw yeli hach tiꞌ Iscꞌahol Comam Dios hawehi! ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hayet iskꞌaxponicꞌto Comam Jesús yiban̈ haꞌ lago tuꞌ yeb ebnaj iscuywom, yapni Comam yul ismajul txꞌotxꞌ Genesaret. ");
INSERT INTO jacNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Haxa yet yohtan̈enilo anma Comam xin, ispujbalaxicꞌo iskꞌumal Comam sunil yul ismajul txꞌotxꞌ Genesaret tuꞌ. Caw xin hantan̈e anma yaꞌay ilaxto tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iskꞌanni anma tet Comam ta waxan̈ca han̈echꞌan istiꞌ xil iskꞌap Comam chistzab anma yaꞌay, yuxin sunil anma yaꞌay tzabni istiꞌ xil iskꞌap Comam tuꞌ cawxicanocan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yet hunel apni huntekꞌan ebnaj fariseo yeb ebnaj cuywawom yin̈ isley naj Moisés ilwal yin̈ Comam Jesús, ispeto ebnaj bey Jerusalén. Iskꞌamben ebnaj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tzet yin̈ xin mach chisyije hacuywom tiꞌ huntekꞌan chejbanile yet ebnaj jichmam? Yuto ebnaj hacuywom tiꞌ mach chistxꞌah ebnaj iskꞌab yet chiwaꞌ ebnaj, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Istakꞌwi Comam tet ebnaj: —Haquexpax tuꞌ, ¿tzet yin̈ xin cheman̈cꞌo ischejbanil Comam Dios cheyijento ischejbanil anma? ");
INSERT INTO jacNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yuto chal yul Yum Comam hacaꞌ tiꞌ: “Ayojab yelapno hamam, hamiꞌ yul hasat. Mac chitzꞌactiꞌn̈en ismam maca ismiꞌ yilal iscami,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yajaꞌ hex tiꞌ cheyala tato mach yilalo iscolwa anma yin̈ ismam maca ismiꞌ ta chiyal hacaꞌ tiꞌ: “Mam, mach chu incolwahan tawin̈ yuto haꞌ tzet ayintiꞌan yetxa Comam Dios ye wuhan,” ta ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Haꞌ mac chihalni hacaꞌ tuꞌ matxa yilalo iscolwa yin̈ ismam maca ismiꞌ, heyalni. Yajaꞌ yin̈ hacaꞌ tuꞌ cheman̈cꞌo ischejbanil Comam Dios yu heyijento ischejbanil anma. ");
INSERT INTO jacNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wal xin nabn̈e cheyal heba cꞌulal. Teyin̈ bay yalcano naj Isaías, ischejab Comam Dios yet payat yet yalnicano hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Huntekꞌan anma tiꞌ, istiꞌn̈e chinakꞌni binahojan, yajaꞌ wal yanma nahat yehilo win̈an. ");
INSERT INTO jacNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nabn̈e chala ta chiyo isba wetan, wal xin han̈cꞌan̈e ischejbanil ebnaj winaj chakꞌ ebnaj iscuyuꞌ yet anmahil, ẍiayoj, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lahwi tuꞌ yawtenti Comam anma iscꞌatan̈, yalni Comam tet anma tuꞌ: —Abewej cat hetxumni yin̈ tzet chiwaltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maẍtaj tzet chiocto yul istiꞌ anma, haꞌ chietanto yul sat Comam Dios, walxinto haꞌ istxꞌojal chiahti yul istiꞌ, haꞌ chietanto yul sat Comam, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ishitzico ebnaj iscuywom Comam iscꞌatan̈, yalni ebnaj: —Mamin, ¿mamxatxumu tato yet maxawalni huneꞌ tiꞌ machíwacan̈ iscꞌul ebnaj fariseo? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Istakꞌwi Comam: —Sunil te teꞌ maẍtaj Inmaman ay yul satcan̈ tzꞌunn̈e chihocꞌlaxcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wal xin yilaꞌxam ebnaj, lahan ebnaj hacaꞌ anma mach chu yilni cat yocpaxo ebnaj yijbanpaxicꞌo anma mach chu yilni. Kꞌinalo ta ay hunu naj mach chu yilni chixecnito hunuxa naj mach chu yilni, chisxecleto isba ebnaj iscawan̈il yul xab, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yalni naj Pedro tet Comam hacaꞌ tiꞌ: —Mamin, hal jetan̈ tzet chalilo huneꞌ maxawal tet ebnaj fariseo tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Istakꞌwi Comam: —¿Tom haꞌ hunex machi maxetxumpaxo yin̈ tzet mawaltuꞌan? ");
INSERT INTO jacNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tom mach heyohtajoj ta sunil tzet chiocto yul istiꞌ anma yul iscꞌul chiapni, chilahwi tuꞌ xin cat yel yin̈? ");
INSERT INTO jacNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yajaꞌ haꞌ tzotiꞌ chiahti yul istiꞌ anma, yin̈ yanma chitita, haꞌ xin huntekꞌan tuꞌ chietanto yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yuto yul yanma anma chipitzcꞌati sunil istxꞌojal hacaꞌ potxꞌwal, ixloj, winajloj, elekꞌ, lekꞌtiꞌal, yeb buchwal. ");
INSERT INTO jacNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Haꞌ ton huntekꞌan tuꞌ chietanto anma yul sat Comam Dios, yaj wal huneꞌ yet mach chicotxꞌah cokꞌab yet chon̈oc waꞌoj, ischejbanil ebnaj winaj yehi, mach chetato janma yul sat Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lahwi tuꞌ xin isto Comam Jesús yul ismajul txꞌotxꞌ Tiro yeb txꞌotxꞌ Sidón. ");
INSERT INTO jacNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bey tuꞌ ay huneꞌ ix ix ah Cananea, mach Israeloj. Apni ix yilaꞌ Comam Jesús, yalni ix yin̈ caw ip: —Mamin, hach yuninal iscꞌahol naj David, tzꞌayojab hacꞌul win̈an. Ay huneꞌ nichꞌan wuninan caw chietalax yu ischejab naj matzwalil, caw xin chiecꞌyaꞌ yanma ix yu naj, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yajaꞌ xin machi takꞌwi Comam tet ix, yuxin hitzico ebnaj iscuywom Comam tuꞌ iscꞌatan̈, yalni ebnaj: —Mamin, hal tet ix paxojabto ix haxinwal chisbej ix yel yaw jin̈, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Istakꞌwi Comam: —Tetn̈e anma Israel chejbilintijan yu Comam Dios, yuto lahan anma tuꞌ hacaꞌ noꞌ meꞌ cꞌaynatoj, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yajaꞌ hitzico ix, yay jahno ix sata Comam, yalni ix: —Mamin, colwahan̈ nino win̈an, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yalni Comam tet ix: —Mach cꞌulo ta chꞌilaxilo tzet chislo ebnaj uninale cat yakꞌlax tet metx txꞌiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yalnipaxo ix: —Hoꞌ Mamin yeli, yajaꞌ metx txꞌiꞌ tuꞌ chi-ticꞌa-yican̈ metx iskꞌal istiꞌ ebnaj uninale chiaycꞌay yalan̈ meẍa yet chiwaꞌ ebnaj, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lahwi tuꞌ xin, yalni Comam tet ix: —Miyay, caw ayco hawanma yin̈ Comam Dios, yuxin yubojab hacaꞌ choche hacꞌul, ẍi Comam. Yin̈n̈ena tuꞌ xin iscawxican̈ nichꞌan yunin ix tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yel Comam Jesús bey tuꞌ, isto Comam istiꞌ haꞌ lago Galilea, haꞌ tuꞌ xin ahto Comam yin̈ huneꞌ won̈an, yay tzꞌon̈no Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Caw xin hantan̈e anma apni iscꞌatan̈ Comam. Ay mac ikꞌn̈e anma yaꞌay yeb ay mac ikꞌn̈e anma mach chu yeqꞌui, yeb anma mach chu yilni, yeb anma txꞌoj ye iskꞌab, yeb anma mach chu istzoteli; yalaxayo sunil anma tuꞌ yich yoj Comam. Sunil anma tuꞌ xin cawxicanocan̈ yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hayet yilni anma huneꞌ tuꞌ caw cꞌaycanilo iscꞌul yuto yakꞌ tzotelo Comam anma maẍticꞌa chu istzoteli, yebpaxo anma txꞌoj ye iskꞌab watxꞌicaniloj. Isbelwipaxocan̈ anma maẍticꞌa chu yeqꞌui, yeb anma maẍticꞌa yu yilni hajlocanocan̈ issat yu Comam. Yu huneꞌ tuꞌ caw sunil anma yakꞌ tzalaho iscꞌul yin̈ Comam Dios, isDiosal Israel. ");
INSERT INTO jacNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lahwi tuꞌ, yawtenti Comam ebnaj iscuywom iscꞌatan̈, yalni Comam tet ebnaj: —Caw chitzꞌay incꞌulan yin̈ huntekꞌan anma tiꞌ yuto isyoxebxa tzꞌayic yehicꞌo incꞌatan̈an, matxa xin tzet chislo. Mach chisje incꞌulan inchejatojan yatut yuto tato mach chiwaꞌi, chalotaxca ispaxilo yip yulaj beh, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yalni ebnaj iscuywom Comam tet: —Mamin, caw txꞌiꞌal anma lah, ¿baytuꞌwal xin chon̈tohan̈ jikꞌatijan̈ tzet chislo anma tiꞌ? Yuto bay ayon̈ tiꞌ machi teꞌ n̈a, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iskꞌamben Comam tet ebnaj: —¿Hayeb ixim pan coxol tiꞌ? ẍi Comam. Istakꞌwi ebnaj: —Hujebchꞌan ixim yeb haycꞌon̈ noꞌ niẍte cay, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yalni Comam tet anma tato chiay tzꞌon̈no sat txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Lahwi tuꞌ xin yinican̈ Comam ixim hujeb pan yeb haycꞌon̈ noꞌ cay tuꞌ, yakꞌni Comam yuchꞌandiosal tet Comam Dios. Lahwi tuꞌ iskꞌaxponayo Comam ixim, yakꞌni Comam ixim yeb noꞌ cay tuꞌ tet ebnaj iscuywom, yoc ebnaj yitxkꞌanto yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Caw sunil anma waꞌi hantaticꞌa yoche iscꞌul, caw xin hujebto motx nohcan̈ yin̈ ixim matxa lahwi yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xol sunil anma waꞌ tuꞌ can̈eb mil isbisil ebnaj winaj, machi xin oc ebix ix yeb niẍte unin istzꞌajo yin̈ huneꞌ isbisil tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lahwi istakꞌlicano Comam Jesús tet anma, yahto Comam yul huneꞌ teꞌ barco, isto Comam yul ismajul txꞌotxꞌ Magdala. ");
INSERT INTO jacNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ay huntekꞌan ebnaj fariseo yeb ebnaj saduceo apni ilno Comam Jesús yun̈e yilwen ebnaj Comam. Yalni ebnaj tet Comam ta chisye hunu cꞌaybalcꞌule chiyeniloj tato caw yeli haꞌ Comam Dios chejn̈eti Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Istakꞌwi Comam tet ebnaj: —Yin̈ kꞌejbiyalil yet cheyilni istzꞌay moyan, cheyal hacaꞌ tiꞌ: “Wal tinan̈ yeloxa hajan, yuto lan̈an istzꞌay moyan,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Taca yet sacꞌayal xin cheyal hacaꞌ tiꞌ: “Wal tinan̈ yocxa haꞌ n̈ab yuto caw kꞌej moyan,” quexchi. Hex tiꞌ caw helanex hetxumni yin̈ tzet chute isba tiempo, ta chakꞌ haꞌ n̈ab maca machoj. Yajaꞌ wal yin̈ huneꞌ tiempohal bay ayex tiꞌ, mach chitxumchalo heyu. ");
INSERT INTO jacNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anma yin̈ huneꞌ tiempohal tiꞌ, caw txꞌojcanoj yeb caw mach yijemoj. Chiskꞌan cꞌaybalcꞌule yilaꞌ, yajaꞌ huneꞌn̈echꞌan cꞌaybalcꞌule chiakꞌlax yilaꞌ, hacaꞌ huneꞌ isye Comam Dios yin̈ naj Jonás, ẍi Comam Jesús. Lahwi tuꞌ yel Comam iscꞌatan̈ ebnaj, isto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yet yecꞌ apno Comam Jesús yeb ebnaj iscuywom iskꞌaxepicꞌto haꞌ lago isnaniti ebnaj tato mach yito tzet chislo. ");
INSERT INTO jacNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yalni Comam tet ebnaj: —Cheyil heba tet yan̈al ispan ebnaj fariseo yeb ebnaj saduceo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yet yaben ebnaj huneꞌ tuꞌ, yichico ebnaj yalni tet hunun: —Chal Comam huneꞌ tiꞌ yumi machi majiti tzet chicolo, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yet yabenilo Comam huneꞌ tuꞌ, yalni Comam tet ebnaj: —¿Tzet yin̈ xin cheyala ta machi hepan ikꞌbil heyu? Caw mach chicawxi hecꞌul yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tom mach chinachalo heyu? yeb ¿tom matxa chitit yul hecꞌul yin̈ ixim howeb pan yabe yin̈ howeb mil ebnaj winaj? Tijab yin̈ henabal hayeb motx ixim matxa lahwi yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yeb xin, ¿tom matxa chenati yin̈ ixim hujeb pan yabe yin̈ ebnaj can̈eb mil? Yeb xin, ¿tom matxa chenapaxtij hayeb motx ixim matxa lahwi yu anma tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tzet yin̈ xin machi matxumchalo heyu tato maẍtaj yin̈ ixim pan mantzotelan yet mawalnihan teyet ta cheyil heba tet yan̈al ispan ebnaj fariseo yeb ebnaj saduceo? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lahwi tuꞌ istxumnilo ebnaj tato maẍtaj yin̈ yan̈al ixim pan tzotel Comam, to yin̈ cuybanile chakꞌ ebnaj fariseo yeb ebnaj saduceo. ");
INSERT INTO jacNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yet yapni Comam Jesús yeb ebnaj iscuywom bey Cesarea yul ismajul Filipo, iskꞌamben Comam tet ebnaj iscuywom tuꞌ hacaꞌ tiꞌ: —Hanin Akꞌbilintijan texol yu Comam Dios, ¿mac anmahilinan yalni anma? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Istakꞌwi ebnaj: —Ay mac chalni ta hach tiꞌ naj Juan anican̈ haꞌ iswiꞌ anma, aypaxo mac chalni tato Elías hach, aypaxo mac chalni tato hach tiꞌ naj Jeremías, maca to hunuxa ischejab Comam Dios ecꞌlena yet payat, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iskꞌambenpaxo Comam tet ebnaj: —Haxaca hex tiꞌ, ¿mac anmahilinan heyalni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Istakꞌwi naj Simón Pedro: —Hach tiꞌ, Cristo hach, Iscꞌahol Comam Dios itzitz, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yalni Comam tet naj: —Simón, iscꞌahol naj Jonás, caw sakꞌal hawet yuto huneꞌ maxawal tiꞌ mach anmaho chiyenilo tawet. Walxinto haꞌ Inmaman ay yul satcan̈, haꞌ chiakꞌni hatxumuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Haquinpaxtuꞌan chiwalan tato Pedro chijcano habi. Yiban̈ huneꞌ chꞌen niman chꞌen tiꞌ chiwacan̈an wiglesiahan, machi xin chikꞌoji camical istan̈tzeniloj. ");
INSERT INTO jacNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chiwacanicojan lawe tawet yun̈e chu yoc anma yul iskꞌab Comam Dios. Haꞌ tzet mach tꞌin̈ano yeco yul sat yiban̈kꞌinal tiꞌ hawalni, mach tꞌin̈ano chucano yul satcan̈. Haxa tzet tꞌin̈an yeco sat txꞌo txꞌotxꞌ tiꞌ hawalni, huneꞌ tuꞌ tꞌin̈an chucano yul satcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lahwi yalni Comam huntekꞌan tuꞌ xin, yalnicano Comam tet ebnaj iscuywom tato machi bay chalicꞌo ebnaj tato haꞌ Comam Jesús haꞌ ton Cristo. ");
INSERT INTO jacNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Haꞌ yin̈ huneꞌ tiempohal tuꞌ ichico Comam yalni tet ebnaj iscuywom tato yilal yul isyaꞌtajil yiban̈, yalni Comam hacaꞌ tiꞌ: —Caw yilal intohan bey Jerusalén, cat xin yecꞌyaꞌ wanmahan yu ebnaj ichamta winaj iswiꞌehal con̈ob Israel, yeb yu ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés. Chinispotxꞌan ebnaj, yajaꞌ yin̈ yox tzꞌayic cat witzitzbican̈an hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hayet yaben naj Pedro huneꞌ tuꞌ, yawtenilo naj Comam Jesús, iscachwa naj yin̈ Comam hacaꞌ tiꞌ: —Mamin, ¡haꞌojab Comam Dios chachcolni yin̈ huneꞌ isyaꞌtajil tuꞌ! Machojab chachyaco yul iskꞌab, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Istꞌan̈xico Comam yin̈ naj, yalni Comam: —Ach matzwalil, elan̈ yin̈ insatan yuto chachoc quinhawakꞌaꞌ aycꞌayojan, wal xin maẍtaj haꞌ tzet nabil yu Comam Dios chiecꞌ yin̈ hanabal, walxinto hacaꞌ tzet chisna anma haꞌ chiecꞌ yin̈ hanabal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lahwi tuꞌ yalni Comam tet ebnaj iscuywom: —Tato ay hunu mac choche chioc incuywomojan, caw matxahojab yeto isba ischuquil, yeb xin caw hinanojab yaben isyaꞌtajil win̈an. Ta hinan yetan yanma hacaꞌ tuꞌ ecꞌojab tzujtzun wintajan. ");
INSERT INTO jacNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yuto haꞌ mac mach hinan iscam win̈an yul sat yiban̈kꞌinal tiꞌ, chiscꞌayto iskꞌinal mach istan̈bal. Wal mac chishin isba iscam win̈an xin chischah iskꞌinal yin̈ huneln̈e. ");
INSERT INTO jacNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kꞌinalo ta ay hunu mac chikꞌoji ismajnilo sunil tzet ay yul sat yiban̈kꞌinal tiꞌ, yaj ta chiscꞌayto iskꞌinal mach istan̈bal, ¿tzettaxca chischah huneꞌ mac tuꞌ selelo iskꞌinal chiscꞌayto tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hanin Akꞌbilintijan texol yu Comam Dios chinhulan yeb iskꞌakꞌal yip Inmaman yeb ebnaj ángel, cat wakꞌnihan ispaj selel tet hunun anma, hataticꞌa tzet chiswatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yin̈ caw yeli, chiwalan teyet, ay haywan̈ mac texol tiꞌ maẍto chicami masanto chiyil wulan cat wocan Yahawoj, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wajebxa tzꞌayic xin, ishecꞌnilo isba Comam Jesús xol anma yinito Comam naj Pedro, naj Jacobo yeb yuẍtaj, haꞌ ton naj Juan, yin̈ iswiꞌ huneꞌ witz caw nahat yecan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Haꞌ bey tuꞌ xin ishel isba yillax yin̈ Comam, caw toxan̈e chitzejtzon sat Comam hacaꞌ tzꞌayic. Wal xil iskꞌap Comam xin, caw sajhopon̈e elicoj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lan̈antoticꞌa xin yilni ebnaj naj Elías yeb naj Moisés, lan̈an istzotel ebnaj yeb Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yalnican̈ naj Pedro tet Comam Jesús: —Mamin, caw cꞌul ta wal je bey tiꞌ, ta chisje hacꞌul chu cowatxꞌenan̈ oxebo niẍte pat; hunu hawet, hunu yet naj Moisés, yeb hunu yet naj Elías tiꞌ, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hayet lan̈an yalni naj Pedro huneꞌ tuꞌ xin, yayilo huneꞌ moyan caw sajhopon̈e, yoc hoyno yin̈ ebnaj yeb Comam. Yaben ebnaj iscuywom Comam tuꞌ huneꞌ yul nukꞌe xol moyan tuꞌ yalni hacaꞌ tiꞌ: —Haꞌ naj tiꞌ Incꞌaholan caw xahan ay wuhan, caw chintzalahan yin̈ naj; abewe tzet chal naj, ẍiayti xol moyan. ");
INSERT INTO jacNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hayet yaben ebnaj oxwan̈ iscuywom Comam huneꞌ tuꞌ, caw xiwcan̈ ebnaj, yaycano xulno ebnaj sat txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lahwi tuꞌ, ishitzico Comam iscꞌatan̈ ebnaj, yanayo Comam iskꞌab yiban̈ ebnaj, yalni Comam: —Ahan̈wewanoj, mach chexxiwi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hayet yilniti ebnaj xin, matxa mac lin̈ancan̈ iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Haxa yet lan̈an yayti Comam yin̈ iswiꞌ huneꞌ witz tuꞌ yeb ebnaj iscuywom, yalni Comam: —Machi bay cheyal huneꞌ maxeyil tiꞌ masanto yet chinitzitzbican̈an xol camom, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lahwi tuꞌ iskꞌamben ebnaj tet Comam: —¿Tzet yin̈ xin chal ebnaj cuywawom yin̈ isley naj Moisés tato yilal babel chul naj Elías sata naj Cristo? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Istakꞌwi Comam tet ebnaj iscuywom tuꞌ: —Yeli hac tuꞌ, yilal yul naj Elías tuꞌ babel yun̈e isnani isba anma cat yoc yin̈ istoholal. ");
INSERT INTO jacNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yajaꞌ chiwalan teyet tato xahul naj Elías tuꞌ yajaꞌ mach txumchalo naj yu ebnaj, yuxin iswatxꞌe ebnaj baytet yal iscꞌul yin̈ naj Elías tuꞌ. Hac tuꞌ xin chinutelaxan Hanin Akꞌbilintijan texol yu Comam Dios, chiecꞌyaꞌ wanmahan yu ebnaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lahwi tuꞌ xin, istxumchalo yu ebnaj tato haꞌ yin̈ naj Juan anican̈ haꞌ iswiꞌ anma tzotel Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yet yayilo Comam yeb iscuywom xol anma xin, ishitzico huneꞌ naj iscꞌatan̈ Comam, yay jahno naj sata Comam, yalni naj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Mamin, caw tzꞌayojab hacꞌul yin̈ incꞌaholtiꞌan yuto caw chilow huneꞌ yaxcamic yin̈ naj, caw chiecꞌyaꞌ yanma naj yu. Txꞌiꞌalxa el chito naj yul kꞌaꞌ yeb xol ha haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mawitijan naj tet ebnaj hacuywom tiꞌ, yajaꞌ xin machi yu yakꞌni cawxo ebnaj naj, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Istakꞌwi Comam: —Hex tiꞌ, caw mach cheyaco heyanma yin̈ Comam Dios, caw txꞌojexcanoj. Caw nimanxa tiempo ayinicꞌojan texol. ¿Hantatocꞌanab tiempo chextecha wuhan? Caw yaꞌxa wanmahan heyu. Iweti naj bey tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ischejnilo Comam ischejab naj matzwalil ayco yin̈ naj tzeh tuꞌ. Lan̈antoticꞌa xin iscawxilo naj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Haxa yet ischuquilxan̈e Comam Jesús yeb ebnaj iscuywom tuꞌ, iskꞌamben ebnaj tet Comam: —Mamin, ¿tzet yin̈ xin machi mayu jinilojan̈ ischejab naj matzwalil yin̈ naj tzeh tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Istakꞌwi Comam tet ebnaj: —Yuto hex tiꞌ ayto mach chiapni heyanico heyanma yin̈ Comam Dios. Yin̈ caw isyelal chiwalan teyet ta chicawxi hecꞌul yin̈ Comam Dios waxan̈ca txann̈e yeco heyanma yin̈ Comam hacaꞌn̈e hunu nichꞌan yin̈atil teꞌ mostaza, chu heyalni tet hunu witz hacaꞌ tiꞌ: “Heqꞌuilo haba bey tiꞌ, asiꞌ hunuxa bayah,” ta quexchi, chisyije huneꞌ witz tuꞌ tzet cheyala. Sunil chu hewatxꞌeni ta ayco heyanma yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yuto huntekꞌan ischejab naj matzwalil tiꞌ, machi el yin̈ anma ta mach chextxahli yeb heyakꞌlen wahil hetxahli tet Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hayet yecꞌ Comam Jesús yeb ebnaj iscuywom yul ismajul Galilea, yalni Comam tet ebnaj: —Hanin Akꞌbilintijan texol yu Comam Dios chinálaxicojan yul iskꞌab anma. ");
INSERT INTO jacNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chinakꞌlax camojan, yajaꞌ yin̈ yox tzꞌayic xin cat witzitzbican̈an hunelxa, ẍi Comam. Hayet yaben ebnaj huneꞌ tuꞌ caw occano biscꞌulal yin̈ yanma ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hayet yapni Comam Jesús yeb ebnaj iscuywom bey con̈ob Capernaum, yapni ebnaj chiinilo chꞌen tohlabal yin̈ yatut Comam Dios iscꞌatan̈ naj Pedro. Iskꞌamben ebnaj tet naj: —¿Chimyakꞌ naj chachcuyni istohlabal yin̈ yatut Comam Dios? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Istakꞌwi naj Pedro: —Hoꞌ chitohlawi yaꞌ, ẍi naj. Hayet yocto naj Pedro tuꞌ yul n̈a haꞌ Comam babel kꞌamben tet naj: —Simón, ¿tzet chu hatxumni yin̈ huneꞌ tiꞌ? Mac tet chiskꞌan ebnaj yahaw con̈ob chꞌen tohlabal, ¿ham tet yet con̈ob ebnaj, mato tet anma nan con̈obal? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Istakꞌwi naj Pedro: —Haꞌ anma nan con̈obal, haꞌ chꞌakꞌni chꞌen, ẍi naj. Yalni Comam: —Ta hac tuꞌ, haꞌ mac yuninalticꞌa con̈ob yehi mach yilalo chakꞌ chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yajaꞌ yun̈e mach chꞌoc ishowal ebnaj jin̈, asiꞌ istiꞌ haꞌ lago cat hawanayto chꞌen ikꞌomati cay xol haꞌ. Haꞌ xin yul istiꞌ noꞌ babel cay chiahti hawu ayicto huneꞌ chꞌen melyu cꞌuxan iskꞌoji istohlan hawet yeb wetan. Chawiti chꞌen cat hato hawakꞌnocano chꞌen tet ebnaj chichahni chꞌen tohlabal tuꞌ, ẍi Comam tet naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yin̈ huneꞌ tiempohal tuꞌ, iskꞌambe ebnaj iscuywom Comam Jesús tet hacaꞌ tiꞌ: —¿Mac ecꞌbal yelapno xol anma ayxaco yul iskꞌab Comam Dios? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yawtenti Comam huneꞌ nichꞌan unin yanico Comam xolbal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yalni Comam: —Yin̈ caw yeli chiwalan teyet, ta mach chehel hebeybal, yeb ta mach cheyiyo heba hacaꞌ nichꞌan unin tiꞌ, mach chu heyoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yuxin mac chiyiyo isba hacaꞌ nichꞌan unin tiꞌ, haꞌ ecꞌbal yelapno xol mac ayxaco yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yuxin haꞌ mac chichahni hunu nichꞌan unin yuto wetan yehi, haninan chinischahan, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yalnipaxo Comam Jesús: —Haꞌ mac chiakꞌni lectaho hunu mac uninto yanico isba yul inkꞌaban, cꞌul iscꞌallaxico hunu niman ischꞌenal chꞌen molino yet trigo yin̈ isnukꞌ, cat iskꞌojlaxayto xol haꞌ mar, sata ta chioc yakꞌaꞌ aycꞌayo hunu maca. ");
INSERT INTO jacNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Caw biscꞌulal yet anma ay yul sat yiban̈kꞌinal tiꞌ yuto hantan̈e tzet bay wal yaycꞌayi. Wal tuꞌ caw yeli, yul sat yiban̈kꞌinal tiꞌ ayn̈eticꞌa yin̈ bay chaycꞌay anma, yajaꞌ xin cꞌanchꞌan mac chiakꞌni aycꞌayo hunu maca. ");
INSERT INTO jacNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yuxin tato hekꞌab maca heyoj chexakꞌni aycꞌayo yin̈ istxꞌojal, cꞌulmi hetzocꞌniltoj cat hekꞌojnito nahat. Waxan̈ca matxa tzꞌajano henimanil yet chechahni hekꞌinal mach istan̈bal ecꞌbalto cꞌul sata ta tzꞌajan henimanil yet chexalaxto xol kꞌa kꞌaꞌ mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta isbakꞌ hesat chexakꞌni aycꞌayo xin, cꞌulmi heyiniltij cat hekꞌojnito nahat, wal xin waxan̈ca hunxan̈e isbakꞌ hesat ayicto yet chechahni hekꞌinal mach istan̈bal sakꞌalmi heyet sata ta chexalaxto xol kꞌa kꞌaꞌ yeb iscabil isbakꞌ hesat, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yalnipaxo Comam Jesús: —Nann̈e heyu, tajca chehincꞌuln̈e hunu mac uninto yanico isba yul inkꞌaban, chiwalan teyet, ebnaj ángel chitan̈en ebnaj tiꞌ ayco ebnaj yin̈ sat Inmaman yul satcan̈, ");
INSERT INTO jacNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yuto Hanin Akꞌbilintijan texol yu Comam Dios, hulnajinan insayaꞌan mac cꞌaynatoj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kꞌinalo ta ay hunu naj ay cien ismeꞌ cat xin iscꞌayto hunu noꞌ, ¿mataxca xin mach chacano naj noꞌ noventa y nueve, cat isto naj issayno noꞌ cꞌaynato tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yajaꞌ ta chiilcha noꞌ yu naj xin, yin̈ caw yeli chiwalan teyet tato ecꞌbalto chitzala naj yin̈ noꞌ cꞌaynaticꞌato tuꞌ sata yin̈ noꞌ noventa y nueve mach cꞌaynahotoj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hac tuꞌ Comam ay yul satcan̈, mach chisje iscꞌul tato ay hunu mac uninto yul inkꞌaban chicꞌaytoj, ẍi Comam. Yalnipaxo Comam Jesús: ");
INSERT INTO jacNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Ta ay hunu hawuẍta chiwatxꞌen hunu istxꞌojal tawin̈, as tzotelan̈ tet naj hachuquil, cat xin hacachni naj. Ta chabeto naj tzet chawala, yocxa akꞌancꞌulal texol chal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yajaꞌ ta mach chabeto naj tzet chawala, awteti hunuj maca cawan̈o mac chito tawintaj, haxinwal chiwatxꞌicanayo tzet cheyal tuꞌ yin̈ sat cawan̈ maca oxwan̈ testigo. ");
INSERT INTO jacNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yajaꞌ ta mach chabeto naj yin̈ hacaꞌ tuꞌ, hal tet ebnaj juẍtaj. Taca mach chabeto naj tzet chal ebnaj juẍta tuꞌ xin, hacaꞌ hunu mac mach ohtan̈eho Comam Dios, hac tuꞌ chucano naj yul hesat, maca hacaꞌ hunu ebnaj chiinilo chꞌen tohlabal. ");
INSERT INTO jacNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yin̈ caw yeli chiwalan teyet, sunil tzet checꞌalba yul sat yiban̈kꞌinal tiꞌ chicꞌalbalaxpaxo yul satcan̈, yebpaxo tzet chepuhilo yul sat yiban̈kꞌinal tiꞌ, chipuhlaxpaxo yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chiwalpaxojan teyet: Tato ay cawan̈ojex hun chu hekꞌanni hunu tzet ye tuꞌ yin̈ hetxah tet Comam Dios yul sat yiban̈kꞌinal tiꞌ chiakꞌlax teyet yu Inmaman ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yuxin haꞌ bay chiscutxba isba cawan̈ maca oxwan̈ mac yu yinayo isba wetan, ayinicojan xolbal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lahwi tuꞌ, ishitzico naj Pedro iscꞌatan̈ Comam, iskꞌamben naj: —Mamin, ta ay hunu wuẍtajan chiyaco ismul wetan, ¿hayelmi chiwakꞌ nimancꞌulalan yin̈, tom hujel mato hantaj? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Istakꞌwi Comam: —Mach chiwalan tawet tato hujeln̈e, walxinto hujel el chielto setenta chawakꞌ nimancꞌulal yin̈ hawuẍtaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yalnipaxo Comam Jesús: —Chiwalpaxojan teyet yin̈ anma ayxaco yul iskꞌab Comam Dios, lahan hacaꞌ huneꞌ naj rey ilni hanta iscꞌas ebnaj ismunlawom. ");
INSERT INTO jacNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hayet lan̈an yichico naj yilni hanta iscꞌas ebnaj tuꞌ, yilaxti huneꞌ naj caw ismilalxa iscꞌas tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yajaꞌ huneꞌ naj tuꞌ, mach chikꞌoji naj istohlan sunil iscꞌas tuꞌ. Yuxin ischej naj rey tuꞌ txon̈laxoto naj yeb yixal, yeb yuninal, yeb sunil tzet aya. ");
INSERT INTO jacNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wal naj ay iscꞌas tuꞌ xin ay jahno naj sata naj rey, yoc naj yalno tet naj hacaꞌ tiꞌ: “Mamin, caw niman chawute hacꞌul win̈an hayeboxa tzꞌayic, chinkꞌuyayojan chꞌen cat wakꞌnihan sunil incꞌastuꞌan tawet,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wal naj rey tuꞌ, caw tzꞌaycan̈ iscꞌul naj yin̈ naj, yakꞌni tan̈o naj iscꞌas naj tuꞌ sunil, isbejtzolax naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Haxa yet yelti naj sata naj rey tuꞌ, yilnayo naj huneꞌ naj yet munlawomal, ay xin hanicꞌ iscꞌas naj tet naj. Yoc yachno naj yin̈ isnukꞌ naj, etzaxan̈e xin majayto ishakꞌo naj yu naj, yalni naj tet naj: “Tinan̈ xin chawacanayo hacꞌas wetan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wal naj ay iscꞌas tuꞌ ay jahno naj yin̈ sat naj, yalni naj tet naj: “Mamin, niman chawute hacꞌul, hawechman hayeboxa tzꞌayic, chinkꞌuyayojan chꞌen cat wakꞌni incꞌastuꞌan tawet,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yajaꞌ naj bay ay iscꞌas naj tuꞌ, mach yabeto naj tzet yal naj, walxinto yito naj naj tet naj alcal, yalaxicto naj yul preso masanto yakꞌcano naj sunil iscꞌas tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cꞌuxan xin ay huntekꞌan ebnaj yet munlawomal naj ilni huneꞌ tuꞌ, caw xin tac iscꞌul ebnaj, yuxin to ebnaj yalaꞌ tet naj rey yin̈ tzet yu tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hayet yaben naj rey huneꞌ tuꞌ, yanito naj yawtemal naj. Yalni naj tet naj: “Hach tiꞌ caw mach hawalil, wakꞌ nimancꞌulalan yin̈ hacꞌas yuto hakꞌan nimancꞌulal wetan. ");
INSERT INTO jacNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Estam xin matzꞌay hacꞌul yin̈ hawet munlawomal tuꞌ hacaꞌ mayu istzꞌay incꞌulan tawin̈,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Caw xin tit ishowal naj rey tuꞌ yin̈ naj, ischejni naj yalaxocto naj txꞌoj tuꞌ yul preso masanto istohlacano naj sunil iscꞌas tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yalnipaxo Comam hacaꞌ tiꞌ: —Hac tuꞌ chute Inmaman ay yul satcan̈ teyin̈ tato mach cheyakꞌ nimancꞌulal yin̈ sunil heyanma yin̈ heyuẍta chaco ismul teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lahwi yalnicano Comam Jesús huntekꞌan cuybanile tuꞌ xin, yel Comam yul ismajul Galilea, isto Comam yul ismajul txꞌotxꞌ Judea iskꞌaxepicꞌto haꞌ Jordán. ");
INSERT INTO jacNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Caw xin hantan̈e anma oc tzujno yinta Comam, hac tuꞌ xin yu yakꞌni cawxo Comam anma yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ay xin huntekꞌan ebnaj fariseo apni iscꞌatan̈ Comam, yoc ebnaj yilweno Comam yun̈e yaycꞌay yin̈ hunu ismul, iskꞌamben ebnaj tet Comam: —Mamin, ¿chimyu ispohni isba hunu naj yeb yixal waxan̈ca yu hunu comon tzet ye tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Istakꞌwi Comam tet ebnaj: —¿Tom maẍto cheyil yul Yum Comam Dios bay chala tato hayet iswatxꞌencano Comam Dios anma, iswatxꞌe Comam Dios naj winaj, iswatxꞌenpaxo Comam ix ix? ");
INSERT INTO jacNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yalni Comam Dios hacaꞌ tiꞌ: “Yuxin chacano naj winaj ismam yeb ismiꞌ cat ishunbancano isba naj yeb yixal, hac tuꞌ xin hunxan̈e anmahil chielcanico iscawan̈il, ẍicano Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yuxin matxa cawan̈o anmahil yehi, to hunxan̈e chielcanicoj. Yuxin haꞌ mac chishunba Comam Dios machi hunu mac chu ispohni,” ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iskꞌambenpaxo ebnaj fariseo tuꞌ tet Comam: —¿Tzet yin̈ xin yalcano naj Moisés tato chu yakꞌlax teꞌ hum yet pohlebahil tet ix ixale cat yalaxcano ix yu yichamil? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yalni Comam tet ebnaj: —Yu hetxꞌojal yuxin yal naj Moisés huneꞌ tuꞌ ta chu hepohlencano heba yeb heyixal. Wal yet yichebanil yul sat yiban̈kꞌinal tiꞌ, mach haco tuꞌ ye yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yuxin chiwalan teyet, haꞌ mac chibejnicano yixal, yajaꞌ ta mach taj yu issayni ix hunuxa winaj, cat ismohyipaxo naj yeb hunuxa ix, yin̈ hacaꞌ tuꞌ chaco naj ismul yul sat Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yalni ebnaj iscuywom Comam hacaꞌ tiꞌ: —Tato matxa chu copohni coba yeb jixal, cꞌulmi mach chijikꞌ jixal chal tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Istakꞌwi Comam tet ebnaj: —Yajaꞌ mach sunilo mac chiijcha yu yin̈ huneꞌ cheyal tiꞌ, wal xin han̈cꞌan̈e mac yetticꞌa yehi. ");
INSERT INTO jacNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ay ebnaj maẍticꞌa tzꞌajano isnimanil yetticꞌa chipitzcꞌahi, yuxin mach chu yikꞌni ebnaj yixal. Aypaxo ebnaj yet anmahil chiuteni, yuxin mach chu yikꞌnipaxo ebnaj yixal. Aypaxo ebnaj xin yu ismunla yin̈ ismunil Comam Dios yuxin machi yixal. Yuxin haꞌ mac chitecha yu, machojab chikꞌ yixal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lahwi tuꞌ xin, yilaxti haywan̈ niẍte unin iscꞌatan̈ Comam Jesús yu yanayo Comam iskꞌab yiban̈, yebpaxo yu istxahli Comam yin̈. Wal ebnaj iscuywom Comam xin, oc ebnaj iscachaꞌ anma ikꞌn̈e niẍte unin tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yuxin yal Comam tet ebnaj: —Mach checach istit niẍte unin tiꞌ incꞌatan̈an, yuto haꞌ mac chaco yanma yin̈ Comam Dios hacaꞌ yeco yanma niẍte unin tiꞌ yin̈ ismam ismiꞌ, haꞌ chu yoc yul iskꞌab Comam ay yul satcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yanayo Comam Jesús iskꞌab yiban̈ iswiꞌ niẍte unin tuꞌ, lahwi tuꞌ xin isto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ay huneꞌ naj tzeh apni iscꞌatan̈ Comam Jesús, iskꞌamben naj tet Comam: —Mam cuywawom, ¿tzet hunu cꞌul inwatxꞌenan yun̈e inchahnihan kꞌinale mach istan̈bal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yalni Comam Jesús tet naj: —¿Tzet yin̈ xin chakꞌambe wetan yin̈ tzet ye tuꞌ cꞌul? Wal xin huneꞌn̈e mac cꞌul. Yaj ta chawoche hachab hakꞌinal mach istan̈bal, yije chejbanile akꞌbilcano yu naj Moisés, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iskꞌamben naj hacaꞌ tiꞌ: —¿Baytet xin huntekꞌan chejbanile chawal tiꞌ? ẍi naj. Yalni Comam: —Mach chachpotxꞌwahi, mach chachixli yebpaxo mach chachelkꞌawi, yeb mach chahobcan̈ lekꞌtiꞌal yin̈ hawet anmahil. ");
INSERT INTO jacNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yije tzet chal hamam, hamiꞌ, yebpaxo xin xahan chawil hawet anmahil hacaꞌ hayaꞌiln̈en haba, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Istakꞌwi naj tet Comam: —Sunil huntekꞌan chawal tiꞌ yijebilticꞌa wuhan yichitaxticꞌa inchꞌibcan̈an. ¿Tzet hunuxa wal inyijenan? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yalni Comam tet naj: —Yajaꞌ ta chawoche chachoccano cꞌulal, as txon̈to sunil tzet ayach, cat hapohnican̈ istohol yin̈ anma mebaꞌ, haxinwal ay hakꞌalomal yul satcan̈. Lahwi tuꞌ cat hawoccano tzujno wintajan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hayet yaben naj tzeh tuꞌ yalni Comam hacaꞌ tuꞌ, ispaxto naj yin̈ biscꞌulal yuto caw kꞌalomcano naj sicꞌlebil. ");
INSERT INTO jacNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yalni Comam Jesús tet ebnaj iscuywom: —Yin̈ caw yeli chiwalan teyet, caw yaꞌta yoc anma kꞌalom yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chiwalpaxojan teyet, hacaꞌ hunu noꞌ camello tinan̈, ¿tom subutaj yecꞌto noꞌ yul isholanil hunu chꞌen acuẍa? Hac tuꞌ ye anma kꞌalom, caw yaꞌta yoc yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hayet yaben ebnaj iscuywom Comam huneꞌ tuꞌ caw cꞌayilo iscꞌul ebnaj, yalni ebnaj tet hunun: “Ta hac tuꞌ, ¿mactaxca chicolchahi?” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yoc tꞌan̈no Comam yin̈ ebnaj, yalni Comam: —Huneꞌ tiꞌ mach chikꞌoji anma iswatxꞌeni, wal Comam Dios sunil tzet chu iswatxꞌen Comam, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yalni naj Pedro tet Comam: —Mamin, han̈on̈tiꞌan̈ bejbilcano sunil tzet ayon̈an̈ yu joc tzujnojan̈ tawintaj, ¿yuxin tzet chicochahan̈ ispajoj? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yalni Comam: —Yin̈ caw yeli chiwalan teyet, yet chiapni istiempohal yet chiacꞌbilo sunil tzet ye tuꞌ, Hanin Akꞌbilintijan texol yu Comam Dios chinoc tzꞌon̈nojan yul incapilan caw cꞌulchꞌancanoj. Haxa hex chexecꞌ tzujtzun wintatiꞌan, chexoc tzꞌon̈no yul hunun hecapil, cat heyoc heyilni yin̈ tzet chielico cablahon̈eb majan ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yuxin mac chisbejcano yatut wuhan maca yuẍtaj, yanab, maca ismam, maca ismiꞌ, maca yuninal, maca istxꞌotxꞌ; huntekꞌan mac tuꞌ caw ecꞌbalto txꞌiꞌal ispaj selel chiakꞌlax tet, yeb chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Haꞌ mac caw ay yelapno ye tinan̈, yet chiapni huneꞌ tiempohal tuꞌ, caw matxa yelapno chielicoj. Haxa mac machi yelapno ye tinan̈ chijute jilni, yet chiapni huneꞌ tiempohal tuꞌ caw aycano yelapno chielcanicoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yalnipaxo Comam Jesús tet ebnaj iscuywom: —Anma chioc yul iskꞌab Comam Dios lahan hacaꞌ hunu naj yahaw munil to yin̈ caw sahab sacꞌayal issayaꞌ iscꞌamteꞌ chimunla xol teꞌ uva. ");
INSERT INTO jacNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hayet yilcha huntekꞌan ebnaj yu naj, yalni naj tato huneꞌ denario chakꞌ naj yin̈ tzꞌayic tet hunun ebnaj, lahwi tuꞌ isto ebnaj munlaho xol yuva naj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yin̈mi chꞌen balon̈eb yin̈ yet yalan̈ chuman isto naj yul txon̈bal, yilni naj huntekꞌanxa ebnaj mach ismunil. ");
INSERT INTO jacNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yalni naj tet ebnaj: “Ay munil incꞌatan̈an, chexintohlahan hacaꞌticꞌa caw yehi,” ẍi naj. Istopaxo ebnaj munil xol yuva naj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naj yahaw munil tuꞌ elpaxto naj yin̈ chumanil, yeb yin̈ chꞌen oxeb, hacticꞌapax tuꞌ yute yalni naj tet huntekꞌanxa ebnaj ilcha yu. ");
INSERT INTO jacNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yin̈xa chꞌen howeb xin, istopaxo naj txon̈bal hunelxa, yilni naj huntekꞌan ebnaj chiecꞌ bey tuꞌ mach ismunil. Iskꞌamben naj tet ebnaj: “¿Tzet yin̈ xin ton̈e chiecꞌ tzꞌayic teyiban̈ bey tiꞌ?” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Istakꞌwi ebnaj: “Mamin, to machi mac chiakꞌni yet comunilan̈,” ẍi ebnaj. Yalni naj tet ebnaj: “Ta chisje hecꞌul asiꞌwe munil wintajan, chexintohlahan hacaꞌ caw yehi,” ẍi naj. Isto ebnaj munil yinta naj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Haxa yin̈ kꞌejbiyal xin, yalni naj yahaw munil tuꞌ tet naj chiilni ismunil hacaꞌ tiꞌ: “Awte sunil ebnaj munlawom cat hatohlan ebnaj. Ebnaj maoc munil yin̈ islahobal, haꞌ ebnaj chatohla babel. Wal ebnaj caw sahab maichico ismunla xin, islahobal chatohla ebnaj,” ẍi naj yahaw munil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lahwi tuꞌ xin yawtelax ebnaj oc munil yin̈ chꞌen howeb, haꞌ ebnaj babel tohlalaxi, huneꞌ denario akꞌlax tet hunun ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Haxa yet yawtelax ebnaj ichico munil yin̈ caw sahab sacꞌayal, ham yalni ebnaj tato ecꞌbal istohol ebnaj chiakꞌlaxi, yajaꞌ machoj, huneꞌn̈e denario akꞌlaxpaxo tet hunun ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hayet ischahni ebnaj istohol tuꞌ yichico ebnaj isbuchwa yin̈ naj yahaw munil tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","yalni ebnaj: “Ebnaj mahul yet islahobalxa tiꞌ hunxan̈e hora mamunla ebnaj, ¿tzet yin̈ xin lahan cotoholan̈ maxawakꞌ yeb ebnaj? Han̈on̈tiꞌan̈ ecꞌbal macon̈munlahan̈, yeb xin caw majakꞌ janmahan̈ xol kꞌaꞌ,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Istakꞌwi naj yahaw munil tuꞌ tet huneꞌ naj hacaꞌ tiꞌ: “Hach wet anmahil, mach chinetlihan tawin̈ yuto majala tato huneꞌ denario chintohlahan hatzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wal xin mawakꞌan hatohol, paxan̈toj. Ta chiwochehan ta lahan chikꞌ ebnaj lan̈oxa maoc munil yebex, mach hawoc yin̈ huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hanintiꞌan chu wakꞌnihan inmelyuhan tet mac bay chiwochehan, ¿mato chichiwa hacꞌul yu cꞌul incꞌulan?” ẍi naj yahaw munil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yuxin haꞌ mac babel tinan̈, haꞌ chicancano yin̈ islahobal, wal mac islahobal ye tinan̈, haꞌ chioc yin̈ babel. Hantan̈e mac awtebil yu Comam Dios, yajaꞌ haywan̈n̈e mac sicꞌbililoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yet ayxaco Comam Jesús yeb anma yin̈ isbel bey Jerusalén, yawtenilo Comam ebnaj cablahon̈wan̈ iscuywom, yalni Comam tet ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Tinan̈ xin lan̈an coto bey Jerusalén, yajaꞌ Hanin Akꞌbilintijan texol yu Comam Dios, chinálaxicojan yul iskꞌab ebnaj yahawil yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés cat iskꞌanni ebnaj camical wiban̈an. ");
INSERT INTO jacNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chilahwi tuꞌ cat quinyanicojan ebnaj yul iskꞌab ebnaj mach Israeloj, cat isbuchwa ebnaj win̈an, cat quinismakꞌnihan ebnaj. Chilahwi tuꞌ cat quinyanican̈an ebnaj yin̈ teꞌ culus, yajaꞌ yin̈ yox tzꞌayic cat witzitzbican̈an hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yet huneꞌ tiempohal tuꞌ apni ismiꞌ ebnaj iscꞌahol icham Zebedeo ilwal yin̈ Comam Jesús. Tzujan xin ebnaj cawan̈ tuꞌ yinta ismiꞌ, yay jahno ixnam sata Comam yuto ay huneꞌ tzet choche ixnam iskꞌanaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iskꞌamben Comam tet ixnam: —Miyay, ¿tzet chawoche hakꞌanaꞌ wetan? ẍi Comam. Istakꞌwi ixnam: —Mamin, yet chachoc Yahawoj chinkꞌanan tawet tato cawan̈ wunintiꞌan chioc tacꞌatan̈. Hunu naj chioc tzꞌon̈no yin̈ hawatxꞌkꞌab, hunuxa naj chioc tzꞌon̈no yin̈ hameckꞌab, ẍi ixnam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Istakꞌwi Comam: —Hex tiꞌ mach heyohtajo tzet chekꞌana. ¿Chimyu heyucꞌni huneꞌ vaso ha haꞌ caw cꞌah hacaꞌ huneꞌ chiwucꞌan? ẍi Comam. Istakꞌwi ebnaj: —Hoꞌ, chu jucꞌnihan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yalni Comam tet ebnaj xin: —Yeltoni chu heyucꞌni huneꞌ vaso ha haꞌ caw cꞌah chiwaltiꞌan, yajaꞌ wal hanintiꞌan mach wetojan walnihan mac chiay tzꞌon̈no yin̈ inwatxꞌkꞌaban yeb yin̈ inmeckꞌaban, to han̈e Inmaman ohtan̈e mac tet chakꞌa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hayet yaben ebnaj lahon̈wan̈xa iscuywom Comam, caw tit ishowal ebnaj yin̈ ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yet yilni Comam huneꞌ tuꞌ, yawtenico Comam ebnaj iscꞌatan̈, yalni Comam: —Hex tiꞌ caw heyohtaj tato ebnaj ayco yahawo con̈ob, ay yip ebnaj yiban̈ con̈ob tuꞌ. Haxa ebnaj nime winaj yul con̈ob yahawxa chute isba ebnaj yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wal texol xin mach cꞌuluj tato hac tuꞌ cheyute, wal xin ta ay hunu mac ecꞌbal yelapno ye chabe, ahojab chioc chejaboj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Haxa mac choche ecꞌbal yelapno chuco texol xin, yakꞌabico isba chejaboj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hac tuꞌ wehan Hanin Akꞌbilintijan texol yu Comam Dios, mach hulnajojinan yu inchejnihan anma, walxinto hacaꞌ chejab wecojan xol anma, cat wakꞌni camo inbahan hac tuꞌ xin chu intohlanan ismul txꞌiꞌal anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hayet yel Comam Jesús yeb ebnaj iscuywom yul con̈ob Jericó, caw hantan̈e anma oc tzujno yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ay xin cawan̈ ebnaj mach chu yilni, tzꞌon̈anayo istiꞌ beh. Hayet yaben ebnaj tato haꞌ Comam Jesús lan̈an yecꞌtoj, yahwi ebnaj tet Comam yin̈ caw ip hacaꞌ tiꞌ: —Mamin, yuninal iscꞌahol naj rey David, caw tzꞌayojab hacꞌul jin̈an̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yajaꞌ xin oc anma iscachaꞌ ebnaj yun̈e isbejni ebnaj yel yaw, yaj caw islahico ebnaj yahwi, yalnipaxo ebnaj: —Mamin, iscꞌahol jichmam David, caw tzꞌayojab hacꞌul jin̈an̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yet yaben Comam Jesús huneꞌ tuꞌ yoc lin̈noj, yawtenti Comam ebnaj iscꞌatan̈, iskꞌamben Comam tet ebnaj: —¿Tzet cheyoche chinwatxꞌehan? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Istakꞌwi ebnaj: —Mamin, chijochehan̈ chawakꞌ hajlo cosatan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Istzꞌaycan̈ iscꞌul Comam yin̈ ebnaj; yanico Comam iskꞌab yin̈ isbakꞌsat ebnaj, yin̈n̈ena tuꞌ xin ishajlo issat ebnaj, yoc tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hayet ayto yapni Comam Jesús yeb ebnaj iscuywom bey Jerusalén yapni Comam bey Betfagé, iscawilal won̈an Olivo. Ischejnito Comam cawan̈ ebnaj iscuywom, ");
INSERT INTO jacNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yalni Comam tet ebnaj: —Asiꞌwe bey aldea cosatacꞌto tiꞌ, yet chexapno bey tuꞌ cheyilaꞌ huneꞌ noꞌ miꞌe burro xecan, ayco yunin noꞌ iscꞌatan̈; chepuholo noꞌ cat heyinoti noꞌ wetan. ");
INSERT INTO jacNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yajaꞌ ta ay tzet chihallax teyin̈ xin, cheyalaꞌ hacaꞌ tiꞌ: “Ay chiocnico noꞌ yu Comam Jesús, yajaꞌ chon̈hulan̈ jakꞌaꞌpaxojan̈ noꞌ,” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hac tuꞌ yu yijni isba tzet tzꞌibn̈ebilcano yu huneꞌ ischejab Comam Dios yet payat hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Halwe tet anma ay yul con̈ob Sión hacaꞌ tiꞌ: Ilwecꞌanabi, lan̈an yul hereyal texol, huneꞌ heyahaw tiꞌ caw cꞌul iscꞌul, ayahto yiban̈ huneꞌ noꞌ tzeh burro, yunin huneꞌ noꞌ miꞌe burro ijtzom, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Isto ebnaj cawan̈ tuꞌ, isyijen ebnaj hacaꞌticꞌa yu yalni Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yet yapni ebnaj bey tuꞌ ispuhnilo ebnaj noꞌ miꞌe burro tuꞌ, yiniti ebnaj noꞌ yeb noꞌ yunin tet Comam. Islitxꞌbanahto ebnaj xil iskꞌap iskꞌan̈o yichin̈ noꞌ tzeh burro tuꞌ, lahwi tuꞌ yahto Comam yiban̈ noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Caw hantan̈e anma oc tzujno yinta Comam, ay mac islebayo xil iskꞌap yul beh. Aypaxo mac inilo xaj te teꞌ yanayo yul beh bay chiecꞌto Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sunil anma babelico sata Comam yeb tzujanico yintaj, ichico yawi yin̈ caw ip, chalni hacaꞌ tiꞌ: —¡Caw niman yelapno naj tiꞌ, haꞌ naj tiꞌ titna yin̈ yuninal jichmam rey David! ¡Jalaꞌwe tzotiꞌ cꞌul yin̈ mac chihul coxol yu Comam Dios! ¡Jakꞌaꞌwe yuchꞌandiosal tet Comam Dios ay satcan̈! ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hayet yapni Comam bey Jerusalén, iswejchacan̈ anma sunil, iskꞌambeni: —¿Mac anmahil huneꞌ naj tiꞌ? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Istakꞌwi huntekꞌanxa ebnaj: —Haꞌ naj tiꞌ Jesús, ischejab Comam Dios ay bey Nazaret yul ismajul Galilea, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lahwi tuꞌ xin yocto Comam Jesús yul yatut Comam Dios, istzumbenilti sunil anma chitxon̈wi yeb chilokꞌwi bey tuꞌ. Iswacchancan̈ Comam ismeẍa ebnaj helom melyu, ispacꞌchanpaxocan̈ Comam isẍila ebnaj txon̈om palamuch. ");
INSERT INTO jacNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yalni Comam tet ebnaj: —Tzꞌibn̈ebilcano yul Yum Comam Dios hacaꞌ tiꞌ: “Haꞌ watutan yet txah yehi,” ẍiayoj. Yajaꞌ hex tiꞌ hacaꞌ hunu isn̈achꞌen elkꞌom, hac tuꞌ ye heyu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hayet ayicto Comam yul yatut Comam Dios tuꞌ yapni huntekꞌan ebnaj mach chu yilni yeb ebnaj txꞌoj ye yoj; yakꞌni cawxo Comam ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hayet yilni ebnaj yahawil yin̈ ebnaj sacerdote, yeb ebnaj cuywawom yin̈ ley huntekꞌan cꞌaybalcꞌule iswatxꞌe Comam tuꞌ caw tit ishowal ebnaj; yeb yet yaben ebnaj yalni niẍte unin: “Jakꞌaweco ismay iscꞌahol jichmam rey David,” ẍi, ");
INSERT INTO jacNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","yalni ebnaj tet Comam: —¿Chimhawabe tzet chal niẍte unin tiꞌ? ẍi ebnaj. Istakꞌwi Comam: —Hoꞌ chiwabehan, yajaꞌ ¿tom maẍto bay cheyil yul Yum Comam Dios bay chal hacaꞌ tiꞌ?: Haꞌ niẍte unin yeb niẍte chi-to-txutxwi haꞌ chakꞌan bitn̈eno habi, ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lahwi tuꞌ yel Comam yul con̈ob Jerusalén, isto yul con̈ob Betania, bey tuꞌ xin cancano Comam huneꞌ akꞌbal. ");
INSERT INTO jacNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Haxa hunxa tzꞌayic yin̈ caw sahab sacꞌayalil, ismeltzo Comam Jesús yul con̈ob Jerusalén. Yet ayco Comam yin̈ isbel tuꞌ isn̈ohchacan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yilnito Comam huneꞌ teꞌ higuera istiꞌ beh, isto Comam yich teꞌ, yilni Comam ta machi sat teꞌ, xajn̈e teꞌ aycoj. Yalni Comam yin̈ teꞌ hacaꞌ tiꞌ: —¡Matxa bakꞌinal chachsatni! ẍi Comam. Yin̈n̈ena tuꞌ xin istajilo teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hayet yilni ebnaj iscuywom Comam huneꞌ tuꞌ, caw cꞌaycan̈ iscꞌul ebnaj, iskꞌamben ebnaj tet Comam: —¿Tzet mayu istajnalo teꞌ yin̈ an̈e? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yalni Comam tet ebnaj: —Yin̈ caw yeli chiwalan teyet, ta caw cheyaco heyanma yin̈ Comam Dios, machi xin chicabcon hecꞌul, maẍn̈etaj huneꞌ mayu yin̈ teꞌ higuera tiꞌ chisje hewatxꞌeni. Wal xin tato cheyal tet huneꞌ witz tiꞌ: “Heqꞌuilo haba bey tiꞌ cat hato hawanoyto haba xol haꞌ mar,” ta quexchi, chiyij isba tzet cheyala. ");
INSERT INTO jacNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yuxin ta yin̈ sunil heyanma chextxahli tet Comam Dios yet chekꞌanni hunu tzet ye tuꞌ, chiakꞌlax teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lahwi tuꞌ xin, yapni Comam Jesús yul con̈ob Jerusalén, yocto Comam yul yatut Comam Dios. Hayet lan̈an iscuywa Comam xin ishitzico ebnaj yahawil yin̈ ebnaj sacerdote, yeb ebnaj ichamta winaj iswiꞌehal yin̈ ebnaj Israel, iskꞌamben ebnaj tet Comam: —¿Mac cachchejni hawatxꞌen huntekꞌan hawatxꞌe yet ewi? ¿Mac akꞌni hawip? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Istakꞌwi Comam: —Haquintuꞌan ay huneꞌ inkꞌambebalan teyet, ta chepajtze wetan chiwalan mac akꞌn̈e wipan inwatxꞌenan huntekꞌan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Mac chejniti naj Juan yanocan̈ haꞌ iswiꞌ anma? ¿Tom Comam Dios mato haꞌ anma? ẍi Comam. Yichico ebnaj yallen tet hunun hacaꞌ tiꞌ: —Tato chijalaꞌ ta Comam Dios chejniti naj Juan tuꞌ, chimyalaꞌ naj jet: “¿Tzet yin̈ xin mach heyayto yul heyanma yin̈ tzet yal naj?” ẍim naj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Yajaꞌ ta chijalpaxoj ta haꞌ anma chejn̈e naj, chon̈xiw jalni yuto sunil anma chianayto yul yanma tato naj Juan tuꞌ ischejab Comam Dios ye naj,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yuxin takꞌwi ebnaj tet Comam: —Mach johtajojan̈, ẍi ebnaj. Yalni Comam tet ebnaj: —Haquintuꞌan mach chiwalan mac akꞌn̈e wipan inwatxꞌenan huntekꞌan tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yalnipaxo Comam Jesús tet ebnaj hunelxa: —¿Tzet cheyute heyalni yin̈ huneꞌ chiwaltiꞌan? Ay huneꞌ naj mame ay cawan̈ iscꞌahol; yalni naj tet naj babel hacaꞌ tiꞌ: “Cꞌahol, as munlahan̈ xol teꞌ uva,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Istakꞌwi naj: “¡Mach chintohan!” ẍi naj. Yajaꞌ tzujanxa xin yoc yin̈ isnabal naj istohi. ");
INSERT INTO jacNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lahwi tuꞌ yalnipaxo naj mame tuꞌ tet naj iscab tato chitopaxo naj munil; istakꞌwi naj: “Cꞌulticꞌa mam chintohan,” ẍi naj. Yajaꞌ xin mach to naj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Mac xin najil yijen tzet yal ismam yin̈ ebnaj cawan̈ tuꞌ? ẍi Comam. Istakꞌwi ebnaj: —Naj babel, ẍi ebnaj. Yalni Comam: —Yin̈ caw yeli chiwalan teyet, ebnaj ikꞌomilo tohlabal yeb ebix ix txꞌoj ye iswiꞌ haꞌ chioc babel yul iskꞌab Comam Dios tesataj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yuto hulicꞌo naj Juan anican̈ haꞌ iswiꞌ anma quexiscuyuꞌ yin̈ iscꞌulal, yajaꞌ mach heyayto yul heyanma yin̈ tzet yal naj. Wal ebnaj ikꞌomilo tohlabal yeb ebix txꞌoj ye iswiꞌ yayto yul yanma yin̈ tzet yal naj. Wal hex tiꞌ xin, waxan̈ca caw heyil huntekꞌan tuꞌ yajaꞌ mach hehel hebeybal, yeb xin mach heyayto yul heyanma, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yalnipaxo Comam Jesús tet ebnaj: —Abewe huneꞌxa yechel chiwaltiꞌan: “Ay huneꞌ naj yahaw munil tzꞌunni teꞌ uva sat istxꞌotxꞌ, ispenayo naj istzꞌunub tuꞌ. Iswatxꞌen naj bay chiyatzꞌlax yal teꞌ, iswatxꞌenpaxocan̈ naj huneꞌ n̈a nimajal yucan̈ istel yun̈e istan̈elax huneꞌ peyab tuꞌ. Lahwi tuꞌ xin, yanito naj istzꞌunub tuꞌ comonal tet huntekꞌan ebnaj. Isto naj yul huneꞌxa con̈ob caw nahat. ");
INSERT INTO jacNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Haxa yet yapni istiempohal yuxlax teꞌ uva tuꞌ xin, yanito naj huntekꞌan ischejab ischahno ismajul tet ebnaj munlawom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hayet yapni ebnaj chejab tuꞌ xin, yoc ebnaj istzabnoyo ebnaj, ismakꞌni ebnaj huneꞌ naj, hunxa naj makꞌbil ispotxꞌni ebnaj, haxa hunxa naj xin kꞌojlaxcan̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Haxa yin̈ iscayel ecꞌbalxa ebnaj chejab yato naj yahaw munil, yajaꞌ xin hacticꞌapax tuꞌ utelax ebnaj yu ebnaj munlawom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yin̈xa istzujanil xin, haꞌ caw iscꞌahol naj yahaw munil tuꞌ yatoj, istxumni naj hacaꞌ tiꞌ: ‘Wal tet naj incꞌaholtiꞌan chimisyije ebnaj,’ ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yajaꞌ hayet yilni ebnaj yapni naj cꞌahole tuꞌ, yalni ebnaj tet hunun: ‘Haꞌ tet naj tiꞌ chicancano huneꞌ txꞌo txꞌotxꞌ tiꞌ, wal tinan̈ copotxꞌowe camo naj haxinwal jetxa chuco huneꞌ istxꞌotxꞌ naj tiꞌ,’ ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yoc ebnaj istzabnoyo naj, yilaxilto naj yintalto peyab tuꞌ yu ebnaj, ispotxꞌni ebnaj naj,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iskꞌamben Comam tet ebnaj: —Yet chihul naj yahaw munil tuꞌ, ¿tzettaxca chute naj ebnaj munlawom tuꞌ cheyute heyalni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Istakꞌwi ebnaj: —Matxa chitzꞌay iscꞌul naj ispotxꞌni ebnaj munlawom txꞌoj tuꞌ, cat yanito naj istzꞌunub tuꞌ comonal tet huntekꞌanxa ebnaj munlawom tzꞌajan chu yakꞌni ismajul yet chiuxlax sat teꞌ uva tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yalni Comam Jesús: —¿Tom maẍto cheyil yul Yum Comam Dios bay chal hacaꞌ tiꞌ?: Haꞌ huneꞌ chꞌen chꞌen mach isje ebnaj watxꞌemcan̈ n̈a yakꞌaco yin̈ ismunil, haꞌ chꞌen caw ecꞌbalto cꞌul yoc xeꞌo n̈a. Haꞌ Comam watxꞌen̈e huneꞌ tuꞌ, caw xin chicꞌay cocꞌul jilni, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yuxin chiwalan teyet ta nanxa con̈obal chioc yul iskꞌab Comam Dios heseleloj, yuto yijem anma tuꞌ yakꞌni ismajul yin̈ tzet chiswatxꞌe tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wal huneꞌ chꞌen chꞌen tuꞌ, ta ay mac chiaycꞌay yiban̈ chꞌen hayebtam iskꞌahilal chioqui. Yajaꞌ ta haꞌ chꞌen chiaycꞌay yiban̈, chiquechmoto yalan̈ chꞌen, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hayet yaben ebnaj iswiꞌehal ebnaj sacerdote, yeb ebnaj fariseo yalni Comam hacaꞌ tuꞌ, istxumni ebnaj tato yin̈ ebnaj yal Comam huntekꞌan yechel tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yuxin yoche ebnaj istzabayo Comam, yajaꞌ xiw ebnaj tet anma yuto sunil anma chalni tato ischejab Comam Dios ye Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yichipaxico Comam Jesús yalni tet ebnaj, yanico Comam huntekꞌan yechel yin̈ cuybanile tuꞌ, yalni Comam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Haꞌ anma awtebil yoc yul iskꞌab Comam Dios, lahan hacaꞌ yakꞌle anma yin̈ huneꞌ kꞌin̈ yecꞌtze huneꞌ naj rey yet ismohyi iscꞌahol. ");
INSERT INTO jacNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hayet cꞌulxa ye sunil, yanito naj ischejab yikꞌati ebnaj awtebil yin̈ huneꞌ mohyilal tuꞌ. Yajaꞌ machi hunu ebnaj isjetij. ");
INSERT INTO jacNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lahwi tuꞌ yanipaxto naj huntekꞌanxa ischejab, yalni naj tet ebnaj hacaꞌ tiꞌ: “Halwe tet anma awtebil tuꞌ tato watxꞌebilxa itah. Manchejan potxꞌlaxo haycꞌon̈ inwacaxan, yeb hunmajanxa no nokꞌ caw bakꞌich, watxꞌebilxa sunil. ‘Asiꞌwe yin̈ kꞌin̈ tuꞌ,’ quexchi,” ẍi naj rey. ");
INSERT INTO jacNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yajaꞌ ebnaj awtebil tuꞌ, maẍticꞌa cam iscꞌul ebnaj istita. Huneꞌ naj to ilno ismunil, hunxa naj xin to ilno istxon̈. ");
INSERT INTO jacNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Haxa huntekꞌanxa ebnaj xin, oc ebnaj howal yin̈ ebnaj chejab tuꞌ, ispotxꞌlax ebnaj yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hayet yaben naj rey huneꞌ tuꞌ caw tit ishowal naj. Ischejni naj issoldado ispotxꞌno ebnaj potxꞌwawom tuꞌ, isn̈uslaxpaxilo iscon̈ob ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lahwi tuꞌ yalnipaxo naj rey tuꞌ tet huntekꞌanxa ebnaj ischejab: “Sunil tzet chiocnico yin̈ huneꞌ kꞌin̈ tiꞌ watxꞌebilxa sunil, yajaꞌ ebnaj awtebil wuhan mach chisjeti ebnaj, yuxin mach istzano ebnaj yul yin̈ huneꞌ kꞌin̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wal tinan̈ asiꞌwe yulaj calle cat hechejniti sunil mac chiilcha heyu yin̈ huneꞌ kꞌin̈ tiꞌ,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yet yaben ebnaj chejab huneꞌ tuꞌ, isto ebnaj yulaj calle, yiniti ebnaj sunil anma chiecꞌ bey tuꞌ. Ay anma cꞌul isbeybal, ay anma txꞌoj isbeybal. Caw xin nohilo teꞌ n̈a yu anma yin̈ huneꞌ kꞌin̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hayet yocto naj rey yilno anma cutxanxaco tuꞌ, yilni naj huneꞌ naj mach ayoco xil iskꞌap yet mohyilal. ");
INSERT INTO jacNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yalni naj rey tet naj: “¿Tzet mayu hawocti bey tiꞌ, machi xin xil hakꞌap yet mohyilal aycoj?” ẍi naj. Yajaꞌ xin maẍticꞌa takꞌwi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yalni naj rey tuꞌ tet ebnaj ischejab: “Cꞌalbawe yoj huneꞌ naj tiꞌ yeb iskꞌab naj cat heyanilto naj xol kꞌejholo, haꞌ bey tuꞌ xin chiokꞌo naj yin̈, cat isn̈etxꞌlaho yeh naj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wal xin chiwalan teyet, caw txꞌiꞌal mac awtebil yu Comam Dios yajaꞌ haywan̈n̈e mac chissiqꞌuilo Comam, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lahwi tuꞌ ishecꞌnilo isba ebnaj fariseo, islahtiꞌn̈en isba ebnaj yin̈ tzet chu yakꞌni aycꞌayo ebnaj Comam yin̈ hunu tzotiꞌ, cat yoc ebnaj akꞌocꞌule yin̈ Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yuxin yato ebnaj haywan̈ ebnaj ayco yin̈ ispartido, yeb haywan̈ ebnaj ayco yin̈ ispartido naj Herodes iscꞌatan̈ Comam, yun̈e yilwen ebnaj Comam. Yalni ebnaj tet Comam: —Mam cuywawom, caw johtajan̈ tato hach tiꞌ isyelaln̈eticꞌa chawala, chacuynipaxo anma iswatxꞌen hacaꞌ choche iscꞌul Comam Dios. Machi xin comono chawabeto yin̈ tzet chal anma, yuto lahan yelapno anma yul hasat. ");
INSERT INTO jacNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yuxin, ¿tzet chawute hawalni yin̈ huneꞌ tiꞌ: Chꞌen tohlabal chiel jin̈ yu naj jahaw ay Roma, cꞌulmi jakꞌni chꞌen mato machoj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yajaꞌ wal Comam Jesús pet istxumnalo Comam tzet nabil yu ebnaj. Yuxin yal Comam: —Hex cheyal heba cꞌulal tiꞌ, ¿tzet yin̈ xin chesay yin̈ tzet chu waycꞌayan yul hekꞌab? ");
INSERT INTO jacNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yewe hunu chꞌen melyu cheyakꞌ yin̈ hetohlabal tuꞌ wilaꞌan nan̈, ẍi Comam. Yakꞌni ebnaj huneꞌ chꞌen denario tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iskꞌamben Comam tet ebnaj: —¿Mac najil ayco yechel sat yeb isbi yin̈ chꞌen? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Istakꞌwi ebnaj: —Yechel sat naj jahaw ay bey Roma, yeb xin isbi naj ayco yin̈ chꞌen, ẍi ebnaj. Yalni Comam xin: —Akꞌwe tet naj yahaw Roma, baytet yet naj yehi, cat heyakꞌni tet Comam Dios baytet yet Comam yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yet yaben ebnaj yalni Comam huneꞌ tuꞌ, caw cꞌayilo iscꞌul ebnaj, isbejnicano ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yin̈ticꞌa huneꞌ tzꞌayic tuꞌ, ay huntekꞌan ebnaj saduceo bey ilno Comam Jesús. Ebnaj saduceo tuꞌ mach chayto ebnaj yul yanma tato itzitzbican̈ anma camnaxa, yuxin iskꞌambe ebnaj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mam cuywawom, halbilcano yin̈ isley naj Moisés hacaꞌ tiꞌ: “Ta chicam yichamil hunu ix ix, machi xin yuninal naj yeb ix, yilal yikꞌni ix yuẍta naj camna tuꞌ, yun̈e ay yuninal naj yeb ix cat yoc yuninalo naj camna tuꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yajaꞌ yet hunel, coxoltiꞌan̈ ay hujwan̈ ebnaj yuẍtan̈e isba. Naj babel mohyi yeb huneꞌ ix yajaꞌ cam naj, machi xin yuninal naj yeb yixal tuꞌ, yuxin mohyi naj iscab yeb ix. ");
INSERT INTO jacNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yajaꞌ campaxo naj, hacticꞌapax tuꞌ yu naj isyox, masanta apni yin̈ naj ishuj, sunil ebnaj ikꞌlen ix. ");
INSERT INTO jacNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lahwi tuꞌ iscampaxo ix. ");
INSERT INTO jacNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yuxin hayet chiitzitzbican̈ camom, ¿mac ebnaj hujwan̈ tuꞌ chioc yichamilo ix yuto ishujwan̈il ebnaj mohyi yeb ix? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Istakꞌwi Comam Jesús tet ebnaj saduceo tuꞌ: —Hex tiꞌ, maẍtaj haꞌ ye heyu, yuto mach heyohtajo tzet chal yul Yum Comam Dios, yeb mach heyohtajo yip Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wal xin hayet chiitzitzbican̈ anma camom matxa chimohyi, yuto lahanxa chielico hacaꞌ ebnaj ángel ay satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yin̈ yet chiitzitzbican̈ anma camom tuꞌ, ¿tom maẍto cheyil yul Yum Comam Dios bay chal hacaꞌ tiꞌ?: ");
INSERT INTO jacNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Hanintiꞌan isDiosal naj Abraham, naj Isaac yeb naj Jacob,” ẍiayoj. Yuxin waxan̈ca cam ebnaj yajaꞌ mach cam ebnaj yin̈ huneln̈e. Yuto mach isDiosalo camom ye Comam Dios to isDiosal anma itzitz, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yet yaben anma huntekꞌan cuybanile yal Comam tuꞌ caw cꞌayilo iscꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yet yaben ebnaj fariseo tato matxa yu istakꞌwi ebnaj saduceo tet Comam Jesús, iscutxbanico isba ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xol ebnaj tuꞌ xin ayco huneꞌ naj cuywawom yin̈ ley, haꞌ naj oc ilweno Comam, yalni naj: ");
INSERT INTO jacNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mam cuywawom, ¿baytet chejbanile caw ecꞌbal yelapno xol chejbanile aycano yu naj Moisés? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Istakꞌwi Comam tet naj: —Ochewe Comam Dios yin̈ sunil hecꞌul, heyanma yeb henabal. ");
INSERT INTO jacNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Haꞌ xin huneꞌ chejbanile tuꞌ haꞌ babel yeb ecꞌbal yelapno xol huntekꞌanxa. ");
INSERT INTO jacNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Haꞌ huneꞌxa iscab xin, lahan hacaꞌ huneꞌ babel, chal hacaꞌ tiꞌ: “Xahan cheyil heyet anmahil hacaꞌ hexahann̈en heba,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hayet chicoyijen cabeb chejbanile tiꞌ, lan̈an coyijen huntekꞌanxa cuybanile akꞌbilcano yu naj Moisés, yeb tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hayet cutxantoco ebnaj fariseo tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","iskꞌamben Comam Jesús tet ebnaj: —¿Tzet cheyute hetxumni yin̈ naj Cristo? ¿Mac yin̈ chitit naj heyalni? ẍi Comam. Istakꞌwi ebnaj: —Yin̈ naj rey David chitit naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yalnipaxo Comam: —Yajaꞌ naj David tuꞌ, yal naj naj Cristo Yahawoj yet yakꞌlax yalaꞌ naj yu Comam Espíritu Santo yet yalni naj hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yal Comam Dios tet Wahawilan: “Ayan̈ tzꞌon̈no yin̈ inwatxꞌkꞌaban masanto chiwacojan mac ayco ishowal tawin̈ yalan̈ hawoj,” ẍi Comam, ẍi naj David. ");
INSERT INTO jacNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Tzet yin̈ xin yal naj David tuꞌ naj Cristo Yahawiloj tato yin̈ naj titna naj? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Machi hunu ebnaj yu istakꞌwi yin̈ tzet yal Comam. Haꞌticꞌa yin̈ huneꞌ tzꞌayic tuꞌ xin matxaticꞌa hunu ebnaj hitzico iskꞌamben hunu tzet ye tuꞌ tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lahwi tuꞌ yalni Comam Jesús tet anma yeb tet ebnaj iscuywom: ");
INSERT INTO jacNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ebnaj fariseo yeb ebnaj cuywawom yin̈ ley, haꞌ ismunil ebnaj tuꞌ haꞌ ton quexiscuyni yin̈ isley Moisés. ");
INSERT INTO jacNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yuxin sunil tzet chal ebnaj teyet yijewej, yajaꞌ mach chebeybaln̈eto tzet chiswatxꞌe ebnaj, yuto haꞌ tzet chal ebnaj mach chisbeybaln̈e ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Haꞌ cuybanil chakꞌ ebnaj tet anma, lahan hacaꞌ hunu ijatz caw al, machi mac chikꞌoji yinican̈. Wal ebnaj xin nitam hunu yiximal iskꞌab ebnaj chishitzico yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Cꞌul yub ebnaj, caw yijem chute isba ebnaj, yajaꞌ yun̈e yillax ebnaj yu anma. Caw nimej chute ebnaj sat noꞌ tzꞌum bay tzꞌibn̈ebilico Istzotiꞌ Comam Dios cat yanico ebnaj noꞌ yin̈ iskꞌab, maca yin̈ ispalan̈. Chanipaxico ebnaj huntekꞌan xil iskꞌap nimej ishojo istiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yet chiawtelax ebnaj waꞌo yin̈ kꞌin̈, haꞌ huntekꞌan tzꞌon̈obal caw ay yelapnoj haꞌ chismajilo ebnaj, hac tuꞌ chutepaxo ebnaj yulaj capilla. ");
INSERT INTO jacNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hayet chiecꞌpaxo ebnaj yulaj calle yochebal ebnaj caw cꞌul chu istioẍli anma tet ebnaj, yeb xin caw choche ebnaj yabeꞌ tato chihallax cuywawomal yin̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wal hex tiꞌ xin, machojab cheyoche chihallax cuywawomal teyin̈, yuto huneꞌn̈e mac hecuywawom, wal xin heyuẍtan̈e heba. ");
INSERT INTO jacNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Machi hunu mac cheyal hemamo yul sat yiban̈kꞌinal tiꞌ, yuto huneꞌn̈echꞌan Hemam, haꞌ ton Comam Dios ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Machojab cheyoche chihallax iswiꞌehal teyin̈, yuto huneꞌn̈e mac iswiꞌehal yeco teyin̈, haꞌ ton Comam Cristo. ");
INSERT INTO jacNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wal xin haꞌ mac ecꞌbal yelapno yehi, yakꞌabico isba chejabo texol. ");
INSERT INTO jacNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yuto haꞌ mac chican̈ isba, chiilaxayoj, wal mac chiyiyo isba xin, chiilaxcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hex cuywawom yin̈ isley naj Moisés yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal, ¡caw cꞌanchꞌanex! yuto checach yoc anma yul iskꞌab Comam Dios. Mach cheyaco heba, machi xin chejépaxo chioc mac choche yakꞌaco isba yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hex cuywawom hex tiꞌ yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal, ¡caw cꞌanchꞌanex! yuto cheyilo yatut ebix hun ix, chilahwi tuꞌ caw nimej cheyute yoj hetxah, hacaꞌtan̈e mach istxꞌojal chewatxꞌe. Wal xin caw ecꞌbalto isyaꞌtajil chiay teyiban̈. ");
INSERT INTO jacNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hex cuywawom yin̈ ley yeb xin hex fariseo hex tiꞌ cheyal heba cꞌulal. ¡Caw cꞌanchꞌanex! yuto sunil yul sat yiban̈kꞌinal tiꞌ yeb yiban̈ haꞌ mar chelahwilo heyeqꞌui yun̈e hemontenico anma teyintaj. Haꞌ mac chimoncha heyu tuꞌ xin chisomchacanto yul iswiꞌ heyu, cayel ecꞌbalto chischah isyaꞌtajil xol kꞌa kꞌaꞌ tesataj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hex tiꞌ lahanex hacaꞌ hunu mac mach chu yilni, yajaꞌ cheyaco heba ijbalomal. ¡Caw cꞌanchꞌanex! Cheyalnipax hacaꞌ tiꞌ: “Ta ay mac chiakꞌni binaho yatut Comam Dios yet chistakꞌwenico hunu tzet ye tuꞌ yin̈, mach yilalo chisyije. Yaj ta isbi chꞌen oro ayicto yul yatut Comam chakꞌ binaho yin̈ hunu tzet ye tuꞌ, caw yilal isyijeni,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Caw suc hex! Lahanex hacaꞌ anma mach chu yilni. ¿Baytet ecꞌbal yelapno yehi? ¿Tom chꞌen oro mato yatut Comam Dios? Wal xin, yu yatut Comam Dios yuxin ay yelapno ye chꞌen oro ayicto yul yatut tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Cheyalnipaxoj: “Ta ay hunu mac chiakꞌni binaho altar yet chistakꞌwenico hunu tzet ye tuꞌ yiban̈, mach yilalo chisyije. Yajaꞌ ta isbi xahanbal ayahto yiban̈ altar tuꞌ chakꞌ binahoj, caw yilal chisyije,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Caw lahanex yeb anma mutzꞌan sat! ¿Baytet caw ecꞌbal yelapno yehi? ¿Tom haꞌ xahanbal ayahto yiban̈ altar tuꞌ, mato haꞌ altar huneꞌ chianico ismay xahanbal tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wal xin haꞌ mac chiakꞌni binaho altar yin̈ tzet chala, haꞌ hun tzet ayahto yiban̈ altar tuꞌ chakꞌ binahoj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hacpax tuꞌ mac chiakꞌni binaho yatut Comam Dios yin̈ tzet chala, haꞌ hun Comam Dios ay bey tuꞌ chakꞌ binahoj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hacpax tuꞌ mac chiakꞌni binaho satcan̈ yin̈ tzet chala, haꞌ hun istzꞌon̈obal Comam Dios chiyakꞌ binahoj, cat yakꞌnipaxo binaho Comam tzꞌon̈an yul yehobal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hex cuywawom yin̈ isley naj Moisés yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal. ¡Cꞌanchꞌanex! cheyakꞌ isdiezmohal teꞌ alawena, teꞌ aniẍ, yeb teꞌ comino, yajaꞌ machi cam hecꞌul heyijen chejbanile caw ay yelapno aycano yu Comam Dios; haꞌ ton hewatxꞌen istoholal, yeb istzꞌay hecꞌul yin̈ heyet anmahil, yeb xin heyijen tzet chal Comam Dios, yeb heyanico heyanma yin̈ Comam, haꞌ ton huntekꞌan tiꞌ yilal heyijeni, machi xin chebejpaxo heyijen huntekꞌanxa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Hex tiꞌ lahanex yeb anma mutzꞌan sat, yajaꞌ cheyaco heba ijbalomal yin̈ hunuxa maca. Hex tiꞌ caw cheyila tato machi hunu noꞌ nichꞌan us chito xol heyitah, yajaꞌ mach cheyabe hebikꞌnito noꞌ camello! ");
INSERT INTO jacNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hex cuywawom yin̈ isley naj Moisés yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal, ¡caw cꞌanchꞌanex! yuto caw cꞌul cheyute hetxꞌahni yinta hevaso yeb hesecꞌ, yajaꞌ wal yul xin, nohnayto yu istzꞌilal heyelekꞌ yeb yu heyecꞌnajil. ");
INSERT INTO jacNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hex fariseo hex tiꞌ, lahanex hacaꞌ hunu mac mutzꞌan issat. Wal xin txꞌahwe babel yul hevaso yeb hesecꞌ, haxinwal saj chielpaxico yintaj. ");
INSERT INTO jacNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hex cuywawom hex yin̈ isley naj Moisés, yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal. ¡Caw cꞌanchꞌanex! yuto lahanex hacaꞌ hunu panteón caw cꞌul yehico istxohal; caw cꞌulchꞌan jilni, yajaꞌ wal yul xin, nohna yu isbajil camom yeb tzꞌil. ");
INSERT INTO jacNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hacaꞌ huntekꞌan panteón tuꞌ haquex tuꞌ. Han̈e yin̈ sat anma caw cꞌul cheyute heba, wal heyanma xin nohna yu lekꞌtiꞌal yeb yu istxꞌojal. ");
INSERT INTO jacNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hex cuywawom yin̈ isley naj Moisés yeb hex fariseo hex tiꞌ, cheyal heba cꞌulal. ¡Caw cꞌanchꞌanex! yuto checayen̈e hetzantencan̈ bay mujan ebnaj ischejab Comam Dios. Chetzantenpaxo bay mujan ebnaj cꞌul iswatxꞌe, ");
INSERT INTO jacNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","cheyalni hacaꞌ tiꞌ: “Tato ayon̈icꞌo yin̈ huneꞌ tiempohal yet ispotxꞌlax ebnaj ischejab Comam Dios yu ebnaj jichmam, mach chimjaco coba copotxꞌni ebnaj,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hayet cheyalni hacaꞌ tuꞌ, hex caw ex cheyaliloj tato yin̈ yuninal ebnaj potxꞌni camo ebnaj ischejab Comam tuꞌ quextita. ");
INSERT INTO jacNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Wal xin haꞌ tzet ichebilxa yu ebnaj heyichmam tuꞌ, lahwecanoj! ");
INSERT INTO jacNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hex tiꞌ, lahanex yeb noꞌ laba yuto caw helanex yin̈ istxꞌojal. ¿Tzettaxca chu hecolni heba tet isyaꞌtajil xol kꞌa kꞌaꞌ mach istan̈bal? ");
INSERT INTO jacNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chinchejtojan ischejab Comam Dios texol yeb mac itzꞌat iswiꞌ yin̈ yet Comam, yeb ebnaj cuywawom. Yajaꞌ xin ay ebnaj chepotxꞌ yul hecapilla, ay ebnaj cheyacan̈ yin̈ culus, aypaxo ebnaj chemakꞌ yul hecapilla, yeb xin ay ebnaj chetzumbecꞌo yul hunun con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Teyiban̈ xin chititcano isyaꞌtajil yu iscamical sunil ebnaj potxꞌbil; ebnaj cꞌul tzet iswatxꞌe chiichiti yin̈ iscamical naj Abel masanta yin̈ iscamical naj Zacarías, iscꞌahol icham Berequías, potxꞌbil xolbal yatut Comam Dios yeb bay chiakꞌlax xahanbal. ");
INSERT INTO jacNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yin̈ caw yeli chiwalan teyet, chititcano isyaꞌtajil yiban̈ anma yin̈ huneꞌ tiempohal tiꞌ yu iscamical ebnaj tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yalnipaxo Comam Jesús: —¡Hex ah Jerusalén tiꞌ chepotxꞌ camo ebnaj ischejab Comam Dios, cat hekꞌojni camo ebnaj ischejti Comam texol! ¡Txꞌiꞌal el quexwawtecojan yul inkꞌaban, hacaꞌ chu yawtenico noꞌ miꞌe chiyo niẍte yunin yalan̈ isxicꞌ, yajaꞌ machi heje! ");
INSERT INTO jacNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Abewecano tzet chiwaltiꞌan, huneꞌ hecon̈ob tiꞌ chebejaꞌcanoj, chicancano man̈ anmahil. ");
INSERT INTO jacNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tinan̈ xin chiwalcanojan teyet tato matxa chinheyilan masanto yet cheyalni hacaꞌ tiꞌ: “¡Jakꞌawe tzalaho cocꞌul yin̈ mac chul coxol yu Comam Dios!” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lahwi tuꞌ, yelti Comam Jesús yul yatut Comam Dios. Hayet lan̈an yelti Comam tuꞌ xin ishitzico ebnaj iscuywom Comam iscꞌatan̈, yichico ebnaj isyeni huntekꞌan teꞌ n̈a yetbi isba yeb yatut Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yalni Comam tet ebnaj: —Yin̈ caw yeli chiwalan teyet, huntekꞌan cheyil tiꞌ chiapni istzꞌayical bay chiuchcꞌalaxtoj. Machi hunu chꞌen chꞌen latzꞌbil tiꞌ chican yiban̈ yet chꞌenal, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lahwi tuꞌ isto Comam Jesús yin̈ istzalanil won̈an Olivo, yay tzꞌon̈no Comam bey tuꞌ, ishitzico ebnaj iscuywom Comam iscꞌatan̈. Hayet ischuquil ebnaj yeb Comam tuꞌ iskꞌamben ebnaj tet Comam: —Mamin, hal jetan̈, ¿bakꞌin chu huntekꞌan maxawal tuꞌ, yeb baytet huntekꞌan yechel chisye isba yet toxa chaẍhuli yeb yin̈ yet chilahwi yul sat yiban̈kꞌinal tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yichico Comam yalni tet ebnaj: —Caw cheyil heba, machojab mac chexakꞌni subchahoj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yuto txꞌiꞌal ebnaj chuli cat isbalnico ebnaj inbihan yin̈, cat yalni: “Hanintiꞌan Cristo inan,” ẍi ebnaj. Caw xin txꞌiꞌal mac chisubcha yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cheyaben yichican̈ howal bey tiꞌ, yeb yul huntekꞌanxa con̈ob. Yajaꞌ mach chexxiwi yuto yilal yul huntekꞌan tuꞌ, yaj maẍto istan̈balo yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chakꞌlecan̈ howal ej txꞌotxꞌ nimeta con̈ob yeb huntekꞌanxa txꞌotxꞌ nimeta con̈ob, cat yanipaxico howal huneꞌ con̈ob yin̈ huneꞌxa con̈ob. Caw txꞌiꞌal howal yeb yabil chuli, chulpaxo wahil yeb chixcab yul hunun con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yajaꞌ yichebaniln̈e isyaꞌilal ye huntekꞌan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hex tiꞌ, chexilaxto sata ebnaj yahaw con̈ob yu yakꞌlax ecꞌoyaꞌ heyanma, cat xin quexispotxꞌni camo ebnaj. Sunil anma yul sat yiban̈kꞌinal tiꞌ chexcajni yuto tzujanex wintajan. ");
INSERT INTO jacNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yin̈ huneꞌ tiempohal tuꞌ, txꞌiꞌal mac chiyilo yanma yin̈ Comam Dios. Chioc ishowal anma yin̈ hunun, cat ishobnican̈ anma lekꞌtiꞌal yin̈ hunun. ");
INSERT INTO jacNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Txꞌiꞌal ebnaj chalico isba ischejabo Comam Dios, caw xin txꞌiꞌal mac chisubcha yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Caw chiahcan̈ anma iswatxꞌen istxꞌojal, yuxin matxa xahano chil anma yet anmahil. ");
INSERT INTO jacNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Haꞌ mac chitecha yu masanto yin̈ islahobal, haꞌ chicolchahi. ");
INSERT INTO jacNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yajaꞌ wal Tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios, yilal ispujbalaxicꞌo yul hunun con̈ob yun̈e yohtan̈encanilo anma, lahwi tuꞌ cat yul islahobal tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tzꞌibn̈ebilcano yu huneꞌ ischejab Comam Dios chiyij Daniel yin̈ huneꞌ naj chihul etanoto yatut Comam Dios yu istxꞌojal chiswatxꞌe naj. Mac chiilni huneꞌ tiꞌ istxumabiloj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yuxin maquex ayexicꞌo yul con̈ob Judea tiꞌ yet chiyuni huneꞌ tuꞌ yilal heyelcan̈ cat heto iswiꞌla witz. ");
INSERT INTO jacNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Haꞌ mac ayahto yiban̈ yacꞌalil yatut, matxa chiayti yikꞌalti hunu tzet ye tuꞌ yul yatut, to beh yelcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wal mac ayto xol ismunil xin, matxa chimeltzo yikꞌalti xil iskꞌap yul yatut. ");
INSERT INTO jacNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Cꞌanchꞌan ebix ix ayxa tzet yehi, yeb ebix chi-to-txutxwi niẍte yunin yet chiyuni huneꞌ tuꞌ! ");
INSERT INTO jacNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yuxin kꞌanwe tet Comam Dios, haxinwal machojab yin̈ n̈abil chu huneꞌ tuꞌ, machojabpaxo yin̈ istzꞌayical xewilal chiyuhi. ");
INSERT INTO jacNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yuto huneꞌ isyaꞌtajil chul yin̈ huneꞌ tiempohal tuꞌ, caw nanxa islowi, maẍto hunelo chu yichitax iswatxꞌi yul sat yiban̈kꞌinal tiꞌ, matxa bakꞌinal chupaxoj yet chilahwi yecꞌcanoj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yajaꞌ tato mach chiscꞌotzba Comam Dios yoj huneꞌ tiempo tuꞌ, machim hunu mac chicolchahi. Wal xin chiscꞌotzba Comam yu iscolni macta sicꞌbilxa yu. ");
INSERT INTO jacNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yuxin ta ay mac chihalni teyet: “Ay naj Cristo bey tiꞌ, lah,” maca “ay naj Cristo bey tuꞌ, lah,” ta ẍi, mach cheyayto yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yuto ay ebnaj chisbalico isba Cristohal, yeb ay ebnaj chalico isba ischejabo Comam Dios. Chisye ebnaj huntekꞌan yechel yeb cꞌaybalcꞌule yun̈e issubcha anma yu ebnaj. Etza xin chisubchapaxo mac sicꞌbilxa yu Comam Dios yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wal xin, ayto chiwalnicanojan huntekꞌan tiꞌ teyet. ");
INSERT INTO jacNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yuxin ta ay mac chihalni teyet: “As ilwej, ay naj Cristo bey txꞌotxꞌ desierto,” ta ẍi, mach chextohi. Maca ta chihallax teyet: “Ewan ye naj bey tiꞌ, lah,” ta ẍi, mach cheyayto yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yuto hacaꞌ jilni isjebla cꞌuh bay chiahilo tzꞌayic, cat isjeplapaxo bay chito tzꞌayic, hac tuꞌ chu wulan Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Haꞌticꞌa bay ayayo isnimanil hunu camom, haꞌ tuꞌ chiscutxba isba noꞌ usmij, ẍi Comam tet ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yalnipaxo Comam Jesús: —Chin̈elahwi yecꞌto huntekꞌan nimeta isyaꞌtajil tuꞌ, cat iskꞌejholilo yoj tzꞌayic, wal ixahaw matxa chimujli, cat istitcꞌay txꞌumel ay satcan̈, cat xin istzicobtan̈elax sunil tzet ay yip yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lahwi tuꞌ cat isyenican̈ isba yechel wulbalan yul satcan̈, Hanin Akꞌbilintijan texol yu Comam Dios. Wal anma ay yul hunun con̈ob yul sat yiban̈kꞌinal tiꞌ, chixiwcan̈ cat yoc okꞌoj yet chiyilni wulan xol moyan. Chinhulan yeb iskꞌakꞌal wipan. ");
INSERT INTO jacNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hayet chiokꞌ chꞌen trompeta yin̈ caw ip, chinchejnicojan ebnaj ángel iscutxbaco sunil macta sicꞌbilxa wuhan yul yiban̈kꞌinal. Caw xin sunil yul sat yiban̈kꞌinal chiecꞌ ebnaj iscutxbacan̈ anma sicꞌbilxa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Txumwecꞌanab yin̈ teꞌ higuera, hayet chiyaxbilo ischon iskꞌab teꞌ cat yelilo niẍte xaj teꞌ, cheyohtan̈eloj ta toxa chioc haꞌ n̈ab. ");
INSERT INTO jacNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hacpax tuꞌ xin yet cheyilni yijni isba sunil tzet chiwaltiꞌan, cheyohtan̈eloj tato cawilxa wetijan, hacaꞌ hunu mac lin̈anxaco sat pulta. ");
INSERT INTO jacNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yin̈ caw yeli chiwalan teyet, sunil huntekꞌan tiꞌ chij isba yalan̈to maẍto chicam huntekꞌan anma ayicꞌo yin̈ huneꞌ tiempohal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Haꞌ satcan̈ yeb txꞌo txꞌotxꞌ chitan̈iloj, yajaꞌ wal intzotiꞌan xin machi ecꞌto yet yijni isba tzet chala. ");
INSERT INTO jacNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yajaꞌ wal yin̈ tzet tzꞌayical yeb tzet orahil chinhultuꞌan, machi mac ohtan̈e, nitam ebnaj ángel ay satcan̈. Mach wohtapaxojan hanin Iscꞌahol Comam Dios intiꞌan, walxinto han̈cꞌan̈e Inmaman ohtan̈e. ");
INSERT INTO jacNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hacaꞌ yu anma yin̈ istiempohal naj Noé, hac tuꞌ chu anma yin̈ huneꞌ tiempohal yet chinhulan, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yuto yet yalan̈to maẍto chihul haꞌ niman yaxn̈ab, caw matzet chal iscꞌul anma yin̈ tzet yal naj Noé, caw xin han̈e waꞌoj yeb ismohyi ayco yin̈ iscꞌul masanto yet yocto naj Noé yul teꞌ barco. ");
INSERT INTO jacNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hayet tona nahul ay anma tuꞌ, yul huneꞌ niman yaxn̈ab yiban̈, istan̈ilo anma sunil. Hacaꞌ yu anma yin̈ huneꞌ tiempohal tuꞌ, hac tuꞌ chu anma yet chinhul lemnahan, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kꞌinalo ta ay cawan̈o ebnaj winaj huneꞌn̈e chimunlahi yet chiyuni huneꞌ tuꞌ, huneꞌ naj chiilaxtoj, huneꞌxa naj xin chicancanoj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yeb xin ta ay cawan̈ ebix huneꞌn̈e lan̈an iscawni, huneꞌ ix chiilaxtoj huneꞌxa ix chicancanoj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Caw majwahan̈wej, yuto mach heyohtajo tzet tzꞌayical chinhulan, hanin Heyahaw intiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kꞌinalo ta yohta hunu naj yahaw n̈a tzet orahil chul hunu naj elkꞌom yin̈ akꞌbalil, chimyilo naj iswayan̈. Hac tuꞌ xin mach chiocto naj elkꞌom tuꞌ yelkꞌalti tzet ay naj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Haꞌ quexpax tuꞌ hex tiꞌ, helan cheyute heba, yuto yet matxa nano heyu cat wul lemnahan, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yalnipaxo Comam Jesús: —Kꞌinalo ta ay hunu naj yahaw munil ay haywan̈o ischejab, ham naj yijem yeb caw helan chacano naj seleloj yu yakꞌni tzet chislo ebnaj ismunlawom yet chicꞌayayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sakꞌal yet naj chejab ta lan̈an isyijen naj tzet halbilcano tet yet chiapni naj yahaw tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yin̈ caw yeli chiwalan teyet, naj yahaw munil tuꞌ chaco naj naj yijem tuꞌ yahawo yin̈ sunil tzet aya. ");
INSERT INTO jacNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yajaꞌ ta mach cꞌuluj chute isba naj, cat yoc naj yalni hacaꞌ tiꞌ: “Yaꞌ wahawtuꞌan, ¿bakꞌintam chul yaꞌ?” ta ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Cat yoc naj ismakꞌni ebnaj chejab tuꞌ, cat yoc naj waꞌoj yeb xin ucꞌu xol ebnaj ucꞌum teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Haxa yet istzꞌayical mach echmabilo yahaw naj tuꞌ yu, hayet tohna nahul ay naj cat yul lemna yahaw naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hac tuꞌ xin chiakꞌlax ecꞌoyaꞌ yanma naj yu naj yahaw tuꞌ, hacaꞌ yakꞌlax ecꞌoyaꞌ yanma huntekꞌan ebnaj chal isba cꞌulal. Haꞌ tuꞌ xin chiokꞌ naj cat isn̈etxꞌla yeh naj yu isyaꞌtajil, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yalnipaxo Comam Jesús: —Yet chioc Comam Dios Yahawo bey tiꞌ, lahan chakꞌle anma hacaꞌ yu lahon̈wan̈ ebix kꞌopo to yin̈ huneꞌ mohyilal yin̈ akꞌbalil. Yito ebix iscantil, isto ebix chahwal yin̈ naj mohyom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yajaꞌ xin ay howan̈ ebix mach helanoj, wal howan̈xa ebix xin caw helan ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ebix mach helano tuꞌ, han̈e teꞌ aceite ayayto yul iscantil ebix, han̈e teꞌ yito ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wal ebix helan xin isnohtze ebix iscantil, yinipaxto ebix yakꞌbilxa yaceite yul islimeta. ");
INSERT INTO jacNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yajaꞌ xin ecꞌto yorahil yulbal naj chimohyi tuꞌ, caw xin kꞌahan yechman ebix, matxa chitecha wayan̈ yu ebix yuxin waycan̈ ebix sunil. ");
INSERT INTO jacNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Haxa yin̈ chuman akꞌbal, yaben ebix yallax hacaꞌ tiꞌ: “¡Ahan̈wewanoj! ¡Lan̈an yul naj chimohyi lah! Elan̈weti hechaba naj,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yet yaben ebix huneꞌ tuꞌ yahwano ebix, yanico ebix kꞌaꞌ yin̈ iscantil. ");
INSERT INTO jacNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yalni ebix howan̈ mach helano tuꞌ tet ebix helan hacaꞌ tiꞌ: “Akꞌwe nino heyaceite jetan̈ yuto lan̈an istan̈ilo kꞌaꞌ yin̈ cocantilan̈ lah,” ẍi ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Istakꞌwi ebix helan tet ebix mach helano tuꞌ: “Mach chu jakꞌnihan̈ heyet, yuto ta chijakꞌan̈ hanicꞌo heyet mach chimchabe hanicꞌ tiꞌ teyin̈, mach chimchabepaxocan̈ jetan̈. Wal xin, cꞌul ta chexto helokꞌo heyet,” ẍi ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yet ayto ebix howan̈ lokꞌo aceite tuꞌ, yapni naj chimohyi. Wal ebix caw helan tuꞌ octo ebix yinta naj yin̈ mohyilal tuꞌ, lahwi tuꞌ xin ispebalaxcanilti teꞌ pulta. ");
INSERT INTO jacNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hunepxaticꞌa xin yapni ebix howan̈ to lokꞌo aceite, yoc ebix awocto sat pulta, yalni ebix: “Mamin, Mamin, haj pulta jetan̈,” ẍi ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Istakꞌwilti naj mohyom tuꞌ tet ebix: “¡Machoj! Yin̈ caw yel chiwalan, mach quexwohtajojan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yuxin chiwalcanojan teyet, caw helan cheyute heba yuto mach heyohtajoj tzet tzꞌayical yeb tzet orahil chinhulan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yalnipaxo Comam Jesús: —Yet chul Comam Dios Yahawoj, lahan chakꞌle anma hacaꞌ yu ebnaj ischejab huneꞌ naj yahaw munil. Oc yin̈ isnabal naj isto bey huneꞌxa nan con̈obal caw nahat, yajaꞌ yet yalan̈to maẍto chito naj, yawten naj ebnaj ischejab yu yanicano naj ismelyu yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tet huneꞌ naj, howeb mil quetzal yacano naj yul iskꞌab naj, wal tet hunxa naj xin, cab mil quetzal yacano naj, haxa tet hunxa naj xin mil quetzaln̈e yacano naj. Hataticꞌa ishelanil hunun ebnaj, hac tuꞌ yu yanicano naj chꞌen tet ebnaj. Lahwi tuꞌ isto naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Naj chejab chahnicano chꞌen howeb mil quetzal, oc naj munil yeb chꞌen, caw xin howebto mil chꞌen yikꞌ naj yiban̈ilo chꞌen howeb mil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hacpax tuꞌ naj chahnicano chꞌen cab mil, cab milto chꞌen yikꞌpaxo naj yiban̈ilo chꞌen cab mil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wal naj chahnicano chꞌen huneꞌ mil, ishol naj txꞌo txꞌotxꞌ ismujni naj chꞌen alaxcano tet yu naj yahaw tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yet caw nimanxa tiempo chielto xin, yul naj yahaw melyu tuꞌ, yawten naj ebnaj ischejab yu yilni naj hantaxa ismelyu. ");
INSERT INTO jacNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naj chahnicano chꞌen howeb mil, haꞌ naj oc babel yin̈ sat naj yahaw melyu tuꞌ. Yanicano naj chꞌen howeb mil akꞌlax tet yeb chꞌen howeb mil yikꞌ naj, yalni naj: “Mamin, howeb mil chꞌen hawacano wetan, yajaꞌ xin howebxa mil chꞌen chiwikꞌan yiban̈ilo chꞌen,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yalni naj yahaw melyu tuꞌ tet naj: “Caw cꞌul mayu hamunlahi, yeb caw yijem maxawute haba. Yu caw cꞌul maxawute haba yin̈ hanicꞌ wacanojan tawet, yuxinto caw hantan̈eto tzet chiwacanicojan yul hakꞌab. Tinan̈ xin ocan̈, akꞌ tzalaho hacꞌul incꞌatan̈an,” ẍi naj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Lahwi tuꞌ xin yapni naj chahnicano chꞌen cab mil, yalni naj tet naj yahaw melyu tuꞌ: “Mamin, cab mil chꞌen hawacano wetan, yajaꞌ xin cabtopaxo mil chꞌen wikꞌan yiban̈ilo chꞌen,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yalni naj yahaw melyu tuꞌ tet naj: “Caw cꞌul mayu hamunlahi, yeb caw yijem maxawute haba. Yu caw cꞌul hawute haba yin̈ hanicꞌ wacanojan tawet, yuxin caw nimanto tzet chiwacanojan yul hakꞌab. Wal tinan̈ ocan̈, akꞌ tzalaho hacꞌul incꞌatan̈an,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Haxa yet yapni naj chahni chꞌen huneꞌ mil xin, yalni naj tet naj yahaw melyu tuꞌ: “Mamin, wohtajan tato hach tiꞌ caw how hach, yuto chahatxꞌ tzet ye tuꞌ maẍtajach tzꞌunn̈e; chawinipaxocan̈ tzet ye tuꞌ maẍtajach watxꞌen̈eloj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wal xin quinxiwan, yuxin inmujan hamelyu yalan̈ txꞌotxꞌ, yajaꞌ tinan̈ xin chiwakꞌcanojan chꞌen tawet,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yalni naj yahaw melyu tuꞌ tet naj hacaꞌ tiꞌ: “Hach tiꞌ caw mach cꞌulo hamunlahi, caw isa hach. Ta hawohtaj tato chinhatxꞌcan̈an tzet ye tuꞌ maẍtajinan tzꞌunn̈e, yeb ta chiwican̈an tzet ye tuꞌ maẍtajinan watxꞌen̈eloj, ");
INSERT INTO jacNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","estam hawacto inmelyutiꞌan yul banco. Hayet maquinhultiꞌan xin, manchahnihan chꞌen yeb yal,” ẍi naj tet ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lahwi tuꞌ xin yalni naj tet ebnaj ischejab: “Iwelo chꞌen mil quetzal tet naj cat heyakꞌni chꞌen tet naj ikꞌn̈e chꞌen lahon̈eb mil. ");
INSERT INTO jacNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yuto haꞌ mac ay tzet aya chiakꞌlax yakꞌbil tet, hac tuꞌ xin caw ecꞌbalto tzet ay huneꞌ mac tuꞌ. Wal mac matzet ay xin, haꞌ nichꞌan ay yul iskꞌab tuꞌ, chiilaxilo tet. ");
INSERT INTO jacNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huneꞌ naj chejab matzet chiel yin̈ tiꞌ hawelto naj xol kꞌejholo, haꞌ bey tuꞌ xin chiokꞌ naj yin̈, cat isn̈etxꞌla yeh naj yu isyaꞌtajil,” ẍi naj yahaw tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yalnipaxo Comam Jesús: —Hanin Akꞌbilintijan texol yu Comam Dios, chinhulan Yahawilo yeb iskꞌakꞌal wipan, cat yulpaxo ebnaj ángel wintajan, cat way tzꞌon̈nojan yul incapilan. ");
INSERT INTO jacNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wal anma ay yul hunun con̈ob yul sat yiban̈kꞌinal tiꞌ, chicutxico insatajan, cat inpohnihan xol, hacaꞌ chu ispohni naj tan̈em meꞌ, noꞌ meꞌ xol noꞌ chiw. ");
INSERT INTO jacNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Noꞌ meꞌ tuꞌ yin̈ iswatxꞌkꞌab naj chaco noꞌ, wal noꞌ chiw xin yin̈ ismeckꞌab naj chꞌoc noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hanin Yahawil intiꞌan chiwalan tet anma ayco yin̈ inwatxꞌkꞌaban hacaꞌ tiꞌ: “Hex xahechah iscꞌulal Inmaman, ocan̈we yul huneꞌ ehobal watxꞌebil teyet yu Inmaman. Huneꞌ tiꞌ watxꞌebil yettax iswatxꞌi huneꞌ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yuto hayet inn̈ochahan, heyakꞌni tzet chinlohan. Yet istaj intiꞌan heyakꞌni haꞌ wucꞌuꞌan, yet wecꞌan inkꞌanaꞌan bay chinwayan, heyakꞌni bay quinwayan. ");
INSERT INTO jacNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yet lan̈anxa wel tꞌilnojan, heyakꞌni xil inkꞌapan; yet yaꞌayinan, hebey quinhetuclenojan. Yet ayinictojan yul preso, hebey quinheyilnojan,” quinchin̈eticꞌahan tet anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Haꞌ anma watxꞌen istoholal tuꞌ xin, chiskꞌambe wetan hacaꞌ tiꞌ: “Mamin, ¿bakꞌini cachn̈ohcha tuꞌ jakꞌnihan̈ tzet chalo? yeb ¿bakꞌini taj hatiꞌ jakꞌnihan̈ haꞌ hawucꞌu? ");
INSERT INTO jacNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bakꞌini xin hakꞌan bay cachway jetan̈, jakꞌnihan̈ bay cachwayi? yeb ¿bakꞌini matxa xil hakꞌap, jakꞌnihan̈ xil hakꞌap? ");
INSERT INTO jacNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bakꞌini cachyabilnipaxoj, cobeyan̈ cachcotuclenojan̈, yeb yet hawocto yul preso, con̈beyan̈ cachjilnojan̈?” ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chiwalnihan tet hacaꞌ tiꞌ: “Yin̈ caw yeli chiwalan teyet, yet hecolwa yin̈ hunu ebnaj wuẍtajan, waxan̈ca caw comon yeqꞌui, win̈an hewatxꞌe sunil huntekꞌan tuꞌ,” quinchin̈eticꞌahan tet. ");
INSERT INTO jacNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Lahwi tuꞌ xin chiwalnihan tet anma ayco yin̈ inmeckꞌaban: “Elan̈we yin̈ insatan hex tzꞌactiꞌn̈ebilexxa tiꞌ, asiꞌwe xol kꞌa kꞌaꞌ mach istan̈bal watxꞌebilxa tet naj matzwalil yeb tet ebnaj ischejab naj. ");
INSERT INTO jacNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yuto yet inn̈ohchahan, maẍticꞌa heyakꞌ nino tzet inlohan, yet istaj intiꞌan, maẍticꞌa heyakꞌ nichꞌano haꞌ wucꞌuꞌan. ");
INSERT INTO jacNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yet wecꞌan inkꞌanaꞌan bay chinwayan, maẍticꞌa heyakꞌ bay quinwayan. Yet matxa xil inkꞌapan maẍticꞌa heyakꞌ hunu xil inkꞌapan. Yet yaꞌayinan yeb yet ayinictojan yul preso, maẍticꞌa quinhetuclehan,” quinchin̈eticꞌahan tet. ");
INSERT INTO jacNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yajaꞌ chiskꞌambe anma tuꞌ wetan: “Mamin, ¿bakꞌini cachn̈ohchahi, yeb istaj hatiꞌ, cachecꞌpaxo hakꞌanaꞌ bay cachwayi, yeb yet matxa xil hakꞌap, machi xin con̈colwahan̈ tawin̈? Yebpaxo, ¿bakꞌini cachyabilni yeb hawocto yul preso? ¿Machi xin con̈colwapaxojan̈ tawin̈ hawalni?” ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yajaꞌ chintakꞌwihan tet: “Yin̈ caw yeli chiwalan teyet, yet mach quexcolwa yin̈ hunu ebnaj wuẍtajan, yeb ebix wanaban, waxan̈ca caw comonn̈e yeqꞌui, win̈an mach quexcolwa tuꞌ,” quinchin̈eticꞌahan tet. ");
INSERT INTO jacNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Haꞌ huntekꞌan anma tuꞌ xin, chitocano yin̈ isyaꞌtajil yin̈ huneln̈e. Wal anma watxꞌen iscꞌulal, chischah iskꞌinal mach istan̈bal, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lahwi yalnicano Comam Jesús huntekꞌan tuꞌ xin, yalni Comam tet ebnaj iscuywom: ");
INSERT INTO jacNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Hex tiꞌ heyohtaj tato cabexan̈e kꞌin̈ Pascua, yin̈ kꞌin̈ tuꞌ xin chinalaxicojan yul iskꞌab anma cat walaxcan̈an yin̈ culus, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yin̈ticꞌa huneꞌ tzꞌayic tuꞌ xin, ebnaj iswiꞌehal yin̈ ebnaj sacerdote, yeb ebnaj ichamta winaj yul con̈ob tuꞌ, iscutxbaco isba ebnaj bey yatut naj Caifás, naj yahawil yin̈ ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Islahtiꞌn̈en isba ebnaj yin̈ tzet lekꞌtiꞌal chal ebnaj yin̈ Comam Jesús, yun̈e istzabnayo ebnaj, cat yakꞌni camo ebnaj Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yalni ebnaj tet hunun: —Yajaꞌ mach yin̈o kꞌin̈, haxinwal mach chiah bulna anma, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yet ayxa Comam Jesús yul con̈ob Betania xin, isto Comam yatut naj Simón, naj ayticꞌaco yabil chiyij lepra yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yet ayco Comam waꞌo sat meẍa, yapni huneꞌ ix ix iscꞌatan̈ Comam. Ikꞌbil huneꞌ chꞌen limeta yu ix, alabastro isbi, nohna chꞌen yu huneꞌ an̈ caw xukꞌ sam, yeb caw ay istohol. Isjobnayo ix yiban̈ iswiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hayet yilni ebnaj iscuywom Comam huneꞌ tuꞌ istit ishowal ebnaj yin̈ ix, yalni ebnaj: —¿Tzet yin̈ xin ton̈e chietalaxto huneꞌ an̈ tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Huneꞌ an̈ tiꞌ caw ay istohol, majaltam matxon̈laxtoj, cat ispohlaxcan̈ istohol yin̈ anma mebaꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hayet yaben Comam Jesús huneꞌ tuꞌ, yalni Comam: —¿Tzet yin̈ xin cheyiti hehowal yin̈ ix? Huneꞌ maswatxꞌe ix win̈tiꞌan, caw cꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Anma mebaꞌ ayn̈eticꞌaco texol, walinan xin mach sunilbal tiempo ayinicꞌojan texol. ");
INSERT INTO jacNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Huneꞌ ix tiꞌ masjobayo ix huneꞌ an̈ caw xukꞌ sam wiban̈an yun̈e cꞌulxa ye innimanilan yet chinmujlaxan. ");
INSERT INTO jacNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yin̈ caw yeli chiwalan teyet, bajxan̈etuꞌwal chihallax Tzotiꞌ cꞌul yet colbanile chihallaxpaxo huneꞌ maswatxꞌe ix tiꞌ, hac tuꞌ xin chiakꞌlax binaho ix, ẍi Comam Jesús tet ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naj Judas Iscariote, naj ayco istzꞌajo ebnaj cablahon̈wan̈ iscuywom Comam Jesús, to naj iscꞌatan̈ ebnaj iswiꞌehal yin̈ ebnaj sacerdote, ");
INSERT INTO jacNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yalni naj tet ebnaj: —¿Hanta cheyakꞌ wetan, chiwacojan naj Jesús yul hekꞌab? ẍi naj. Yalten ebnaj treinta melyu naba plata tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hac tuꞌ xin yu yichico naj issayni yin̈ tzet chu yanico naj Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Haxa yet yayilo babel tzꞌayic kꞌin̈ Pascua, yet chiwahlax ixim pan machi yan̈al, ishitzico ebnaj iscuywom Comam iscꞌatan̈, iskꞌamben ebnaj: —Mamin, ¿baytuꞌwal chawoche chicowatxꞌehan̈ tzet chicolo yin̈ kꞌin̈ Pascua tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Istakꞌwi Comam: —Asiꞌwe yul con̈ob, yet chexapnoj cat heto bey yatut huneꞌ naj, cat heyalno tet naj: “Macon̈ischejtijan̈ Comam cuywawom jalan̈ tawet tato hanicꞌxan̈e tiempohal aycꞌo coxolan̈, yuxin haꞌ bey hawatut tiꞌ chon̈hulan̈ jecꞌtzehan̈ kꞌin̈ Pascua tiꞌ yeb Comam,” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lahwi tuꞌ, isto ebnaj iscuywom Comam Jesús, isyijen ebnaj hacaꞌticꞌa yu yalni Comam. Yoc ebnaj iswatxꞌen tzet chilolax yin̈ kꞌin̈ Pascua. ");
INSERT INTO jacNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Haxa yet yah akꞌbal xin, yoc Comam waꞌo sat meẍa yeb ebnaj cablahon̈wan̈ iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yet lan̈an iswaꞌ Comam yeb ebnaj tuꞌ, yalni Comam: —Yin̈ caw yeli chiwalan teyet, ay huneꞌ mac texol tiꞌ chinanocojan yul iskꞌab camical, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yet yaben ebnaj huneꞌ tuꞌ, caw oc biscꞌulal yin̈ iscꞌul ebnaj. Yoc ebnaj iskꞌambeno tet Comam yin̈ hununtajil: —Mamin, ¿machmitajinan? ẍi ebnaj yin̈ hununtajil. ");
INSERT INTO jacNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Istakꞌwi Comam: —Haꞌ huneꞌ mac huneꞌn̈e chu wanaytojan inkꞌaban yul plato yebi haꞌ chinanocojan yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hanin Akꞌbilintijan texol yu Comam Dios, yilal wecꞌan yin̈ camical, hacaꞌ yalni yul Yum Comam Dios. Yajaꞌ, ¡cꞌanchꞌan naj chinanicojan yul iskꞌab camical! Ayxicꞌa mach pitzcꞌa naj yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Naj Judas naj chianico Comam yul iskꞌab camical tuꞌ, iskꞌambe naj: —Mam cuywawom, ¿tom haninan? ẍi naj. Istakꞌwi Comam: —Hoꞌ, hachtoni, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yet lan̈an iswaꞌ Comam, yinican̈ ixim pan, yakꞌni Comam yuchꞌandiosal tet Comam Dios, iskꞌaxponayo Comam ixim. Lahwi tuꞌ yakꞌni Comam ixim tet ebnaj iscuywom; yalni Comam: —Wawej, huneꞌ tiꞌ yechel innimanilan yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yinipaxocan̈ Comam chꞌen vaso, yakꞌni Comam yuchꞌandiosal tet Comam Dios. Lahwi tuꞌ yakꞌni Comam chꞌen vaso tuꞌ tet ebnaj, yalni Comam: —Ucꞌwe huneꞌ tiꞌ hesunil, ");
INSERT INTO jacNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yuto haꞌ huneꞌ tiꞌ yechel inchiqꞌuilan chimalto yu istan̈ ismul txꞌiꞌal anma, yun̈e yijnicano isba istrato Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chiwalpaxojan teyet tato matxa chiwucꞌan yal teꞌ uva masanto yet chioc Inmaman Yahawilal catto wucꞌnihan yin̈ yacꞌtohal hunelxa, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hayet lahwi isbitn̈encano ebnaj bit tet Comam Dios, isto Comam Jesús yeb ebnaj bey won̈an Olivo. ");
INSERT INTO jacNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yalni Comam tet ebnaj iscuywom tuꞌ: —Yin̈ huneꞌ akꞌbal tiꞌ chicabconocan̈ heyanma win̈an hesunil, yuto tzꞌibn̈ebilcano hacaꞌ tiꞌ: “Chinpotxꞌan naj tan̈em meꞌ, cat ispujnacanto noꞌ meꞌ tuꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yajaꞌ yet chinitzitzbican̈an xin, chinbabitojan tesata bey Galilea, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yalni naj Pedro tet Comam: —Mamin, waxan̈ca sunil mac chicabconcan̈ iscꞌul tawin̈, yajaꞌ walinan, machoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yalni Comam Jesús tet naj: —Yin̈ caw isyelal chiwalan tawet, yin̈ huneꞌ akꞌbal tiꞌ oxelxa chawala ta mach quinhawohtajojan yet chiokꞌocan̈ noꞌ icham chiyo, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Istakꞌwi naj Pedro: —Waxan̈ca chinakꞌlax camojan tawinta Mamin, yajaꞌ mach chu walnihan ta mach cachwohtajojan, ẍi naj. Hacaꞌticꞌa yu yalni naj Pedro tuꞌ, hac tuꞌ yu yalnipaxo ebnaj sunil. ");
INSERT INTO jacNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lahwi tuꞌ xin, isto Comam Jesús yeb ebnaj iscuywom bey huneꞌ peyab chiyij Getsemaní, yalni Comam tet ebnaj: —Canan̈wecano tzꞌon̈no bey tiꞌ, chintohan txahlo cosatato tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yinito Comam naj Pedro yeb ebnaj cawan̈ iscꞌahol icham Zebedeo yintaj. Yoc huneꞌ niman biscꞌulal yin̈ yanma Comam, caw xin yaꞌ yuco yin̈ yanma. ");
INSERT INTO jacNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yalni Comam tet ebnaj: —Caw chiwabehan isyaꞌil isbiscꞌulal camical yin̈ wanmahan. Canan̈wecano bey tiꞌ; ¡iwelo hewayan̈ wintajan! ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lahwi tuꞌ xin ishitzilo Comam hanicꞌ yin̈ ebnaj, yay jahno Comam, yay xulno sat txꞌotxꞌ. Yichico istxahli: “Mam, ta chisje hacꞌul colinan tet huneꞌ isyaꞌtajil chul wiban̈tiꞌan; yaj mach hacaꞌ chiwochehan, to hacaꞌojab tzet chal hacꞌul,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lahwi tuꞌ yul Comam bay cancano ebnaj oxwan̈, caw xin chiway ebnaj yet yapni Comam, yalni Comam tet naj Pedro: —¿Tom mach chitecha heyu heyinilo hewayan̈ hunu orahil wintajan? ");
INSERT INTO jacNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Iwelo hewayan̈, txahlan̈we tet Comam Dios haxinwal mach chexaycꞌay yul iskꞌab istxꞌojal. Wal heyanma hinan isyijen tzet chal Comam Dios, yajaꞌ wal henimanil xin mach chitecha ilwebal yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Istopaxo Comam txahlo hunelxa, yalnipaxo Comam yin̈ istxah: “Mam, ta mach chiecꞌayo huneꞌ tiꞌ wiban̈an, yuhojab hacaꞌ chal hacꞌul,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ismeltzopaxo Comam iscꞌatan̈ ebnaj, caw xin yexn̈e isway ebnaj yuto caw mach chitecha naj wayan̈ yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lahwi tuꞌ istopaxo Comam txahlo yin̈ yoxel, hacaꞌticꞌa yu yalni Comam yin̈ babelal yeb yin̈ iscayel, hacticꞌapax tuꞌ yu yalni Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lahwi tuꞌ xin ismeltzo Comam bay ay ebnaj iscuywom tuꞌ, yalni Comam tet ebnaj: —¿Tom yexn̈eto hewayi, yeb hexewi? Wal tinan̈ maapni yorahil walaxicojan, Hanin Akꞌbilintijan texol yu Comam Dios, yul iskꞌab anma mulum. ");
INSERT INTO jacNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ahan̈wewanoj, ton̈wej yuto lan̈an yul naj chinanicojan yul iskꞌab camical, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yet lan̈an istzotel Comam Jesús tuꞌ, yapni naj Judas, naj ayco istzꞌajo ebnaj cablahon̈wan̈ iscuywom Comam. Caw xin hantan̈e ebnaj tzujan yinta naj, ikꞌbil yespada yeb isteꞌ ebnaj yu; chejbil ebnaj yu ebnaj iswiꞌehal yin̈ ebnaj sacerdote, yeb ebnaj ichamta winaj iswiꞌehal con̈ob Israel. ");
INSERT INTO jacNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wal xin halbilxa tet ebnaj yu naj Judas tuꞌ yin̈ tzet chu yanico naj Comam yul iskꞌab ebnaj, yet yalni naj: —Haꞌ naj chintzꞌohan iskꞌotx, haꞌ naj chetzabayoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuxin hayet ishitzico naj iscꞌatan̈ Comam, yalni naj: —¿Hanicꞌ hawe Mam cuywawom? ẍi naj. Istzꞌohni naj iskꞌotx Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yalni Comam tet naj: —Hach amigo, haꞌ tzet chihul hawub watxꞌe tinan̈, ẍi Comam. Istit bulna ebnaj istzabnoyo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yajaꞌ ay huneꞌ naj iscuywom Comam yihti yespada yul yatut, ispitnilto naj istxiquin huneꞌ ischejab naj yahawil yin̈ ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yalni Comam Jesús tet naj: —Ayto hawespada yul yatut yuto haꞌ mac espada chakꞌa, espada chipotxꞌnipaxo camoj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tom mach chu inkꞌannihan cablahon̈eb majan ebnaj ángel tet Inmaman tinan̈ ta chiwochehan? ");
INSERT INTO jacNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yajaꞌ ta hac tuꞌ, machim chiyij isba tzet tzꞌibn̈ebilcano yul Yum Comam Dios win̈an bay chala tato yilal yuni huntekꞌan tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lahwi tuꞌ, yalni Comam tet ebnaj apni tuꞌ: —¿Tom elkꞌominan teyet yuxin ikꞌbil heyespada yeb heteꞌ win̈an chexhul quinhetzabnoyojan? Hunun tzꞌayic inbeyan cuywal yul yatut Comam Dios texol, yajaꞌ mach quinhetzabayojan. ");
INSERT INTO jacNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yajaꞌ tinan̈, yilal yuni sunil huntekꞌan tiꞌ yun̈e yijni isba sunil tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat, ẍi Comam. Wal ebnaj iscuywom Comam xin elcan̈ ebnaj, yanicano ebnaj Comam ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lahwi tuꞌ yinito ebnaj Comam Jesús bey yatut naj Caifás, naj yahawil yin̈ ebnaj sacerdote. Haꞌ bey tuꞌ xin cutxanico ebnaj cuywawom yin̈ isley naj Moisés, yeb ebnaj iswiꞌehal con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Wal naj Pedro xin nahat tzujan isto naj yinta Comam, yapni naj yamakꞌil yatut naj yahawil yin̈ ebnaj sacerdote tuꞌ, yay tzꞌon̈no naj xol ebnaj chitan̈en yatut Comam Dios yu yilni yin̈ tzet chielico Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wal ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj yahawil yin̈ lahtiꞌ xol ebnaj Israel issay ebnaj mac chioc halno lekꞌtiꞌal yin̈ Comam yun̈e iscawxico camical yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Caw xin txꞌiꞌal mac octoj, ishobnican̈ ebnaj lekꞌtiꞌal yin̈ Comam, yajaꞌ maẍticꞌa hunu tzet oc ismulo Comam. Lahwi tuꞌ yapni cawan̈xa ebnaj, ");
INSERT INTO jacNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yalni ebnaj: —Huneꞌ naj tiꞌ jabehan̈ yalni naj hacaꞌ tiꞌ: “Hanintiꞌan chu wuchcꞌanayojan huneꞌ yatut Comam Dios tiꞌ, cat wanican̈an isselel yin̈ oxeb tzꞌayic,” ẍi naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yah lin̈no naj yahawil yin̈ ebnaj sacerdote, yalni naj tet Comam: —¿Tzet yin̈ xin mach chaẍtakꞌwi? ¿Tzet ye huntekꞌan chal ebnaj tiꞌ tawin̈? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yajaꞌ maẍticꞌa takꞌwi Comam tet naj, lahwi tuꞌ yalnipaxo naj: —Yin̈ isbi Comam Dios itzitz, hal yin̈ isyelal jetan̈. ¿Ham hach tiꞌ Cristo, Iscꞌahol Comam Dios? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Istakꞌwi Comam tet naj: —Hoꞌ, hanintonan hacaꞌ hawalni tiꞌ. Chiwalan teyet tato Hanin Akꞌbilintijan texol yu Comam Dios cheyil woc tzꞌon̈nojan yin̈ iswatxꞌkꞌab Comam Dios caw aycano yip, cat heyilni wulan xol moyan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yet yaben naj yahawil ebnaj sacerdote tzet yal Comam tuꞌ, istzilnilo naj xil iskꞌap yu ishowal, yalni naj tet ebnaj yetbi tuꞌ: —Huneꞌ mayal naj tiꞌ, caw txꞌoj yul sat Comam Dios. Yuxin tinan̈ matxa yilal chicokꞌan anma chihalni ismul naj, wal xin han̈-caw-on̈ majabe istxꞌojal istzotel naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yuxin, ¿tzet cheyute heyalni hex tiꞌ? ẍi naj. Istakꞌwi ebnaj: —Ay ismul naj, camojab naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Istzublico ebnaj yin̈ sat Comam, ismakꞌnipaxo ebnaj Comam, ay ebnaj xin pakꞌnilto sat Comam, ");
INSERT INTO jacNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","chalni ebnaj: —Hach Cristo, txumiloj mac macachmakꞌni, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yet tzꞌon̈anayo naj Pedro istiꞌ yamakꞌil teꞌ n̈a tuꞌ, ishitzico huneꞌ ix chejab iscꞌatan̈ naj, yalni ix: —Hach tiꞌ hawetbi haba yeb naj Jesús ah Galilea, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wal naj Pedro tuꞌ yeba naj yin̈ sat sunil anma, yalni naj: —Mach wohtajojan tzet chawala, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Haxa yet yapni naj bey ispultahil yamakꞌil teꞌ n̈a tuꞌ, yalni hunxa ix tet anma cutxanico bey tuꞌ: —Naj tiꞌ yetbi isba naj yeb naj Jesús ah Nazaret, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yajaꞌ yeba naj hunelxa, yalni naj: —Caw chabe Comam Dios, ¡mach wohtajojan huneꞌ naj tuꞌ! ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hunepixto xin ishitzico huntekꞌan ebnaj iscꞌatan̈ naj, yalni ebnaj: —Yin̈ caw yeli, hach tiꞌ hawetbi haba yeb ebnaj chiecꞌ yinta naj Jesús tiꞌ yuto ixtan̈ cotxumnilojan̈ hatzoteli, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yajaꞌ oc naj Pedro tuꞌ istzꞌactiꞌn̈e isba, yalni naj: —Caw chabe Comam Dios mach wohtajojan huneꞌ naj tuꞌ, ẍi naj. Lan̈antoticꞌa xin yokꞌcan̈ huneꞌ noꞌ icham chiyo. ");
INSERT INTO jacNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hac tuꞌ yu isnaniti naj Pedro yin̈ tzet yal Comam yet yalni Comam hacaꞌ tiꞌ: “Oxelxa chawala ta mach quinhawohtajojan yet chiokꞌcan̈ noꞌ icham chiyo,” ẍi Comam. Lahwi tuꞌ yelti naj Pedro bey tuꞌ, yoc naj okꞌo sicꞌlebil. ");
INSERT INTO jacNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Haxa yet issajbilo xin, islahtiꞌn̈en isba ebnaj iswiꞌehal yin̈ ebnaj sacerdote, yeb ebnaj ichamta winaj iswiꞌehal con̈ob tuꞌ yin̈ tzet chu yakꞌlax camo Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lahwi tuꞌ iscꞌalnayo ebnaj Comam, yinito ebnaj Comam sata naj gobernador ah Roma chiyij Poncio Pilato. ");
INSERT INTO jacNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wal naj Judas, naj anico Comam yul iskꞌab ebnaj tuꞌ, hayet yilni naj ta cawxico camical yiban̈ Comam, istac iscꞌul naj yu istxꞌojal iswatxꞌe tuꞌ, isto naj yakꞌnopaxo chꞌen treinta plata tet ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb tet ebnaj iswiꞌehal con̈ob, ");
INSERT INTO jacNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","yalni naj tet ebnaj: —Caw mawaco inmulan, yuto mawacojan huneꞌ naj machi ismul yul iskꞌab camical, ẍi naj. Istakꞌwi ebnaj tet naj: —¡Tzet jocan̈ tawin̈, ila tzet chawute haba! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hayet yaben naj huneꞌ tuꞌ xin istiẍnicanicto naj chꞌen melyu tuꞌ yul yatut Comam Dios. Lahwi tuꞌ isto naj istꞌun̈bano isba. ");
INSERT INTO jacNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ebnaj iswiꞌehal yin̈ ebnaj sacerdote issicꞌcan̈ ebnaj chꞌen melyu tuꞌ, yalni ebnaj: —Huntekꞌan chꞌen melyu tiꞌ mach chu jahnayto chꞌen xol chꞌen ofrenda, yuto istohol camical ye chꞌen, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Islahtiꞌn̈en isba ebnaj, islokꞌni ebnaj huneꞌ txꞌo txꞌotxꞌ chihallax: “Istxꞌotxꞌ naj watxꞌem xi,” yu yoc camposantohal bay chimujlax anma nan con̈obal chicam bey yul con̈ob Jerusalén tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yuxin Istxꞌotxꞌal Chicꞌ occano isbiho huneꞌ txꞌo txꞌotxꞌ tuꞌ, haꞌ xin chihallax yin̈ txꞌotxꞌ tinan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hac tuꞌ yu yijni isba tzet halbilcano yu naj Jeremías, yet yalni naj: “Yican̈ ebnaj chꞌen treinta plata, chꞌen yakꞌ ebnaj Israel istoholo huneꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yin̈ chꞌen xin islokꞌ ebnaj istxꞌotxꞌ naj watxꞌem xi, hac tuꞌ yu yalni Comam Dios Jahawil wetan,” ẍicano naj Jeremías yul Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yet ayco Comam Jesús sata naj Pilato iskꞌamben naj tet Comam: —¿Tom yahawil anma Israel hawehi? ẍi naj. Istakꞌwi Comam: —Hoꞌ, yeli hacaꞌ hawalni tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wal ebnaj iswiꞌehal ebnaj sacerdote yeb ebnaj iswiꞌehal con̈ob, caw oc ebnaj akꞌocꞌule yin̈ Comam. Yajaꞌ wal Comam xin maẍticꞌa takꞌwi ninoj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yuxin yal naj Pilato tet Comam: —¿Tom mach chawabe tzet chal ebnaj tiꞌ tawin̈? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yajaꞌ maẍticꞌa takꞌwi Comam tet naj Pilato tuꞌ, yuxin caw cꞌayilo iscꞌul naj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yin̈ hunun kꞌin̈ Pascua chisbejtzo naj gobernador tuꞌ hunun ebnaj presowom, yajaꞌ haꞌticꞌa mac chal iscꞌul anma haꞌ chibejtzolaxi. ");
INSERT INTO jacNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cꞌuxan xin ayco huneꞌ naj Barrabás isbi yul preso, caw ohtabil naj yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yet cutxanico anma tuꞌ iskꞌamben naj Pilato tet anma: —¿Mac cheyoche chinbejtzohan, tom naj Barrabás mato naj Jesús, naj cheyal Cristohal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yal naj huneꞌ tuꞌ yuto yohta naj ta yu ayco ishowal ebnaj iswiꞌehal sacerdote yin̈ Comam yuxin ilaxto Comam sata naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yet ayicto naj Pilato yul iscapil tuꞌ, yapni tzotiꞌ tet naj yu yixal hacaꞌ tiꞌ: “Mach chawaco haba xol ebnaj yin̈ huneꞌ naj machi ismul tuꞌ, yuto hayet may akꞌbal ay huneꞌ inwayican caw xiwquilta yin̈ naj,” ẍito ix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wal ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj ichamta winaj yul con̈ob tuꞌ, oc ebnaj akꞌocꞌule tet anma ta chala ta chibejtzolax naj Barrabás cat yakꞌlax camo Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iskꞌambenpaxo naj gobernador tuꞌ tet anma: —Yin̈ ebnaj cawan̈ tiꞌ, ¿mac cheyoche chinbejtzohan? ẍi naj. Istakꞌwi anma tuꞌ sunil: —¡Naj Barrabás chabejtzo! ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Iskꞌamben naj: —¿Tzet xin chiwutehan naj Jesús tiꞌ heyalni, naj chihallax Cristohal tiꞌ? ẍi naj. Istakꞌwi anma sunil: —Ahojab naj yin̈ culus, ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iskꞌamben naj Pilato tuꞌ: —¿Tzet xin istxꞌojal iswatxꞌe naj? ẍi naj. Yajaꞌ wal anma tuꞌ caw ecꞌbalto ah yaw, yalni hacaꞌ tiꞌ: —¡Camojab naj yin̈ culus! ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hayet yilni naj Pilato ta caw ecꞌbalto ah wejna anma, matxa hunuxa tzet tzꞌaj yuteꞌ naj, iskꞌanniti naj ha haꞌ. Yoc naj istxꞌahno iskꞌab yin̈ sat sunil anma yu isyenilo naj tato machi yoc naj yin̈ iscamical Comam Jesús. Lahwi tuꞌ yalni naj: —Mach wiban̈ojan chitit iscamical huneꞌ naj tiꞌ, wal xin teyiban̈ chitocanoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Istakꞌwi anma sunil: —Waxan̈ca chioc iscamical naj tuꞌ comulojan̈ yeb yiban̈ juninalan̈, ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hac tuꞌ yu isbejtzon naj Pilato naj Barrabás, ischejni naj hatelaxo Comam Jesús. Lahwi tuꞌ yanico naj Comam yul iskꞌab ebnaj yu yalaxcan̈ yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yinito ebnaj soldado Comam Jesús bey ispalacio naj gobernador tuꞌ. Yet yapni Comam xin, iscutxbanico isba ebnaj soldado, yoc hoyno ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yinilo ebnaj xil iskꞌap Comam, yanico ebnaj huneꞌ xilkꞌape caj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Isbakꞌonayo ebnaj huntekꞌan teꞌ txꞌix coronahil, yahnato ebnaj yin̈ iswiꞌ Comam. Yanipaxico ebnaj huneꞌ te teꞌ yul iskꞌab Comam, yichico ebnaj istzebi yin̈ Comam, chila xin ay jahno ebnaj sata Comam, yalni ebnaj: —¡Tzalajon̈we yin̈ naj yahawil anma Israel tiꞌ! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Istzublipaxico ebnaj yin̈ Comam, yinilo ebnaj te teꞌ ayco yul iskꞌab ismakꞌnico ebnaj teꞌ yin̈ iswiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lahwi yetancano ebnaj Comam, yinilo ebnaj huneꞌ xilkꞌape caj yaco ebnaj yin̈ Comam tuꞌ, yanipaxico ebnaj xil iskꞌap Comam. Lahwi tuꞌ yinito ebnaj Comam yu yalaxcan̈ yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hayet lan̈an yilaxto Comam bay chialaxcan̈ yin̈ culus, istzabnayo ebnaj soldado huneꞌ naj ah Cirene, Simón isbi, ischejnico ebnaj naj yinoto isculus Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hayet yapni ebnaj bey huneꞌ txꞌotxꞌ chiyij Gólgota, chihallaxpaxo Isbajil Wiꞌe, ");
INSERT INTO jacNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","issomni ebnaj yal teꞌ uva yeb huntekꞌan teꞌ cꞌahla telaj, yakꞌni ebnaj yucꞌuꞌ Comam. Yajaꞌ yet yablen Comam matxa isje Comam yucꞌuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hayet ayxacan̈ Comam yin̈ culus yu ebnaj, yoc ebnaj soldado tuꞌ yilweno isba yin̈ xil iskꞌap Comam yu ispohnican̈ ebnaj yin̈. Hac tuꞌ yu yijni isba tzet tzꞌibn̈ebilcano yu ischejab Comam Dios yet payat bay chala: “Ispohcan̈ ebnaj xil inkꞌapan yin̈, yocpaxo ebnaj yilweno isba mac cꞌul yin̈bal yin̈ xil inkꞌaptuꞌan,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lahwi tuꞌ, yoc tzꞌon̈no ebnaj istan̈en Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yanico ebnaj hayeb tzꞌib yiban̈ iswiꞌ Comam yin̈ teꞌ culus tuꞌ bay chala tzet yin̈ xin akꞌlax camo Comam. Haꞌ huntekꞌan tzꞌib tuꞌ ẍi hacaꞌ tiꞌ: “Haꞌ naj tiꞌ Jesús Yahawil anma Israel,” ẍicoj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aypaxo cawan̈ ebnaj elkꞌom alaxcan̈ yin̈ culus yinta Comam. Huneꞌ naj ah yin̈ iswatxꞌkꞌab Comam, huneꞌxa naj xin ah yin̈ ismeckꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Haꞌ macta chiecꞌto bey tuꞌ oc buchwal yin̈ Comam, chisbilen iswiꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","chalni hacaꞌ tiꞌ: —¡Hach tiꞌ, hawala tato chawuchacꞌayo yatut Comam Dios, cat hawanican̈ isselel yin̈ oxeb tzꞌayic hawalni! ¡Yuxin colayti haba tato yel chawala Iscꞌahol Comam Dios hawehi! ¡Ayan̈ti yin̈ teꞌ culus tuꞌ! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hacpax tuꞌ ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés yeb ebnaj ichamta winaj iswiꞌehal con̈ob tuꞌ, oc ebnaj buchwal yin̈ Comam, chalni ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Naj tiꞌ iscol naj anma, wal naj xin mach chu iscolni isba. Tato yeli haꞌ naj tiꞌ Jahawil han̈on̈ Israel hon̈ tiꞌ, jilaꞌ yinayti isba naj yin̈ culus, wal tuꞌ chijaco janma yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Chicawxi iscꞌul naj yin̈ Comam Dios yalni yuxin jilaꞌ yul Comam Dios colwal yin̈ naj tato caw yeli ochebil naj yu Comam, yuto chal naj tato Iscꞌahol Comam Dios ye naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hacpax tuꞌ ebnaj elkꞌom alaxcan̈ yin̈ culus yinta Comam, ocpaxo ebnaj buchwal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yet chumanil iskꞌejholilo yul sat yiban̈kꞌinal tiꞌ masanto yin̈ chꞌen oxeb yin̈ kꞌejbiyalil sajbipaxiloj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yin̈ huneꞌ orahil tuꞌ ah yaw Comam Jesús yin̈ caw ip, yalni Comam: —Elí, Elí, ¿lama sabactani? ẍi Comam. Chal yelapnoj: Hach inDiosal, hach inDiosal, ¿tzet yin̈ xin chinhabejcanojan? ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ay xin huntekꞌan ebnaj aben huneꞌ tuꞌ, yalni ebnaj: —Ham naj Elías, ischejab Comam Dios chawte naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ay xin huneꞌ yetbi ebnaj to yin̈ an̈e yinoti huneꞌ esponja, islahbanayto naj xol pahla vino, iscꞌalnico naj yin̈ iswiꞌ huneꞌ teꞌ ah, yanahto naj yin̈ istiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yajaꞌ cachlax naj yu huntekꞌanxa ebnaj hacaꞌ tiꞌ: —Maẍton̈e bela, jilaꞌ tato chul naj Elías iscoloꞌ naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yahwipaxo Comam yin̈ caw ip hunelxa, lahwi tuꞌ xin iscamiloj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yin̈n̈ena tuꞌ istzilmoyo kꞌap kꞌap aycan̈ yul yictabal yatut Comam Dios, cab ayico kꞌap. Ichiti istzilbanil kꞌap yin̈ iswiꞌ, yaycanilo yin̈ yojtabanil. Yecꞌpaxo huneꞌ niman chixcab, ispohto chꞌen nimeta chꞌen yu. ");
INSERT INTO jacNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ay xin ej chꞌen n̈achꞌen bay mujan camom hajlohi; txꞌiꞌal xin ebnaj ayxaco yul iskꞌab Comam Dios itzitzbican̈. ");
INSERT INTO jacNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hato xin yet yitzitzbican̈ Comam Jesús yelti ebnaj bay mujan tuꞌ. Lahwi tuꞌ isto ebnaj yul con̈ob Jerusalén, txꞌiꞌal mac xin ilni ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hayet yaben naj capitán yeb issoldado chitan̈en Comam huneꞌ chixcab tuꞌ caw xiwcan̈ ebnaj, yeb yet yilni ebnaj sunil tzet yuhi, yalni ebnaj: —Haꞌ huneꞌ naj macam tuꞌ, yin̈ caw yeli Iscꞌahol Comam Dios ye naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ay xin huntekꞌan ebix tꞌan̈anto yilni nahat yin̈ tzet chuhi. Haꞌ ebix tuꞌ tit yinta Comam bey Galilea, iscolwapaxo ebix yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Xol ebix ayco ix María ah Magdala, yeb ix María ismiꞌ naj Jacobo yeb naj José, yeb xin ismiꞌ ebnaj iscꞌahol icham Zebedeo. ");
INSERT INTO jacNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ay huneꞌ naj caw kꞌalom chiyij José, ah con̈ob Arimatea. Naj tuꞌ iscuywom Comam Jesús ye naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Haxa yin̈ kꞌejbiyal xin, isto naj iscꞌatan̈ naj Pilato, yoc naj iskꞌanni isnimanil Comam yu ismujni naj. Hac tuꞌ yu ischejni naj Pilato ebnaj issoldado yakꞌno isnimanil Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Lahwi ischahni naj isnimanil Comam tuꞌ, ispichnico naj huneꞌ sábana caw saj yeb caw cꞌul yin̈ isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ay xin huneꞌ chꞌen niman chꞌen holbil yu naj; yet naj ye chꞌen, caw acꞌto chꞌen, maẍto hunu camom chialaxicto yul chꞌen, haꞌ tuꞌ xin yacto naj isnimanil Comam. Yanicanico naj huneꞌ chꞌen niman chꞌen ismajiloj, lahwi tuꞌ ispaxto naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wal ix María ah Magdala yeb huneꞌxa ix chiyij María, cancano tzꞌon̈no ebix sata bay mujlax Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Haxa yin̈ huneꞌxa tzꞌayic, yet istzꞌayical xewilal, isto ebnaj yahawil yin̈ ebnaj sacerdote yeb ebnaj fariseo yilaꞌ naj Pilato, ");
INSERT INTO jacNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","yalni ebnaj tet naj: —Mam jahaw, chiconatijan̈ tato yet itzitzto huneꞌ naj lekꞌtiꞌ tuꞌ yal naj tato yin̈xa yoxeb tzꞌayic iscam naj cat yitzitzbican̈ naj hunelxa, ");
INSERT INTO jacNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","yuxin tinan̈ chicokꞌanan̈ tawet, ato nino istan̈emal bay mujan naj, masanto hecal yin̈ kꞌejbiyal. Ta mach xin apnita ebnaj iscuywom naj cat yinito ebnaj isnimanil naj, cat yalni ebnaj tet anma tato itzitzbican̈ naj xol camom. Yin̈ hacaꞌ tuꞌ ecꞌbalto huneꞌ lekꞌtiꞌal tiꞌ sata huneꞌ lekꞌtiꞌal yaco naj yet itzitzto naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Istakꞌwi naj Pilato tet ebnaj: —Cꞌulticꞌa, iweto ebnaj soldado teyintaj cat heto hecawxenocano bay mujan naj hacaꞌ chal hecꞌul, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lahwi tuꞌ isto ebnaj yeb ebnaj soldado. Iscawxencano ebnaj bay mujan Comam, yanicanico ebnaj huneꞌ sello yin̈ chꞌen chꞌen ayco ismajilo chꞌen bay mujan Comam. Yanicanico ebnaj ebnaj soldado istan̈enoj. ");
INSERT INTO jacNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lahwi yecꞌcanto istzꞌayical xewilal, haxa yet issajbilo yin̈ babel tzꞌayic yin̈ semana, caw sahab to ix María ah Magdala yeb huneꞌxa ix chiyij María tuꞌ yilaꞌ bay mujan Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hayet lan̈an isto ebix tuꞌ yecꞌ huneꞌ niman chixcab yuto ayilo huneꞌ yángel Comam Dios bay mujan Comam tuꞌ. Yinilo naj huneꞌ chꞌen chꞌen ayco ismajilo istiꞌ bay mujan Comam, yay tzꞌon̈no naj yiban̈ chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Caw chijepla yin̈ naj hacaꞌ isjepla cꞌuh. Wal xil iskꞌap naj xin caw sajhopon̈e. ");
INSERT INTO jacNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hayet yilni ebnaj soldado huneꞌ tuꞌ isluyluncan̈ ebnaj yu xiwquilal, yah pacꞌna ebnaj hacaꞌ camom. ");
INSERT INTO jacNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yalni naj ángel tet ebix cawan̈ tuꞌ: —Mach chexxiwi, wohtajan tato haꞌ Comam Jesús alaxcan̈ yin̈ culus, haꞌ lan̈an hesayni. ");
INSERT INTO jacNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wal xin matxa Comam ayicti bey tiꞌ, to xaitzitzbican̈ hacaꞌ yu yalni teyet. Ilwecꞌanab bay ecꞌle Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tinan̈ xin as halwe tet ebnaj iscuywom tato maitzitzbican̈ Comam xol camom. Chibabito Comam tesata bey Galilea, haꞌ bey tuꞌ cheyilaꞌ Comam. Haꞌ huntekꞌan tiꞌ manhul walaꞌan teyet, ẍi naj ángel tuꞌ tet ebix. ");
INSERT INTO jacNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hayet yaben ebix huntekꞌan tuꞌ, isto ebix yalno yin̈ an̈e tet ebnaj iscuywom Comam; caw xiw ebix, yajaꞌ xin caw tzalapaxo ebix yaben huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hayet ayco ebix yin̈ isbel tuꞌ xin, isyeni isba Comam tet ebix, istioẍli Comam tet ebix. Ishitzico ebix iscꞌatan̈ Comam, yay jahno ebix sata Comam, yoc lakꞌno ebix yin̈ yoj Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yalni Comam tet ebix: —Mach chexxiwi, as halwe tet ebnaj wuẍtajan tato chito bey Galilea, haꞌ bey tuꞌ chinyilaꞌan ebnaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yet lahwi isto ebix tuꞌ, isto haywan̈ ebnaj soldado ayco istan̈eno Comam tuꞌ yul con̈ob. Yalni ebnaj tet ebnaj iswiꞌehal yin̈ ebnaj sacerdote yin̈ tzet yuhi. ");
INSERT INTO jacNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yet yaben ebnaj huneꞌ tuꞌ isto ebnaj islahtiꞌn̈eno isba yeb ebnaj ichamta winaj iswiꞌehal con̈ob Israel. Yakꞌni ebnaj niman melyu tet ebnaj soldado tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yalni ebnaj tet ebnaj: —Hac tiꞌ cheyute heyalni hacaꞌ tiꞌ: “Yet lan̈an cowayan̈ yet akꞌbalil yul ebnaj iscuywom naj yelkꞌanoto isnimanil naj,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yajaꞌ ta chabelo naj gobernador huneꞌ tuꞌ matzet chal hecꞌul, chon̈ocan̈ tzotelo teyin̈ tet naj haxinwal matzet chitit teyiban̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Lahwi tuꞌ ischahnilo ebnaj chꞌen melyu tet ebnaj yahawil yeco yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ ley. Yalni ebnaj soldado tet anma hacaꞌticꞌa yute yalni ebnaj tet ebnaj. Huneꞌ lekꞌtiꞌal isnacan̈ ebnaj tuꞌ, yexn̈eto yallax xol anma Israel tinan̈. ");
INSERT INTO jacNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lahwi tuꞌ, isto ebnaj hunlahon̈wan̈ iscuywom Comam Jesús bey Galilea yin̈ istzalanil huneꞌ won̈an bay yal Comam ta chiapni ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Haꞌ bey tuꞌ xin yil ebnaj Comam, yoc ebnaj yanoco ismay Comam, yajaꞌ xin ay hun cawan̈ ebnaj cabcon iscꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ishitzico Comam iscꞌatan̈ ebnaj iscuywom tuꞌ, yalni Comam: —Quinyacojan Comam Dios Yahawo yin̈ tzet ay yul satcan̈ yeb yin̈ tzet ay yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tinan̈ xin as cuywe anma yul hunun con̈ob yul sat yiban̈kꞌinal tiꞌ cat yoc yul inkꞌaban. Cheyacanocan̈ haꞌ iswiꞌ yin̈ isbi Comam Dios Mame, yeb yin̈ inbihan, hanin Iscꞌahol Comam Dios intiꞌan, yeb yin̈ isbi Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Checuyni anma isyijen sunil cuybanile xawakꞌan teyet. Walinan xin ayinn̈eticꞌacojan heyetbiho yin̈ sunilbal tiempo masanto yet chilahwi huneꞌ yul sat yiban̈kꞌinal tiꞌ, ẍicano Comam Jesús tet ebnaj iscuywom.");
INSERT INTO jacNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hac tiꞌ chu yichico Tzotiꞌ cꞌul yet colbanile yin̈ Comam Jesucristo, Iscꞌahol Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ay huneꞌ ischejab Comam Dios chiyij Isaías tzꞌibn̈encano yin̈ tzet yal Comam Dios tet Iscꞌahol, bay chala: Chiwatojan inchejaban tasataj yun̈e iswatxꞌen naj habeh yet yalan̈to maẍto chachapni. ");
INSERT INTO jacNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chꞌawi naj yin̈ caw ip bey txꞌotxꞌ desierto, chalni naj: “Watxꞌeweco heyanma yuto chihul Comam Dios Jahawil. Hacaꞌ chu istoholban̈elax hunu beh yet chihul hunu naj jahaw, hac tuꞌ cheyute heyanma,” ẍi naj, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Huneꞌ tiꞌ yij isba yet yapni naj Juan chꞌanican̈ haꞌ iswiꞌ anma bey txꞌotxꞌ desierto. Yichico naj yalni ta yilal yahcano haꞌ iswiꞌ anma, yun̈e isyenilo isba tato chisbej anma iswatxꞌen istxꞌojal, cat yakꞌlaxcano tan̈o ismul yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sunil anma ay yul ismajul Judea yeb anma ay yul con̈ob Jerusalén apni abeno tzet chal naj Juan. Hayet chalnati anma ismul, cat yahcano haꞌ iswiꞌ yu naj yul haꞌ niman Jordán. ");
INSERT INTO jacNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wal naj Juan tuꞌ, xil noꞌ camello watxꞌebilayo xilo iskꞌap naj, tzꞌum noꞌ xin ayico istxꞌambalo naj. Haꞌ xin tzet chislo naj, haꞌ ton noꞌ litꞌ yeb iscabil noꞌ txꞌilab. ");
INSERT INTO jacNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Chalni naj Juan tuꞌ tet anma: —Ay huneꞌ naj tzujan yul wintajan, caw ecꞌbal yelapno ye naj insatajan, walinan xin machi welapnojan chiwabehan nitam way cꞌon̈nojan inpuhnilojan istxꞌan̈al isxan̈ab naj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hanintiꞌan yin̈ caw yeli, han̈e ha haꞌ chiwakꞌan yahbalo haꞌ hewiꞌ, wal naj chiwaltuꞌan xin chiyacan̈ naj haꞌ hewiꞌ yaj yu iskꞌakꞌal yip Comam Espíritu Santo, ẍi naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yet huneꞌ tiempohal tuꞌ, el Comam Jesús yul con̈ob Nazaret ayco yul ismajul Galilea, yapni bey haꞌ niman Jordán, yah haꞌ iswiꞌ Comam yu naj Juan yul haꞌ Jordán tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hayet lan̈an yahti Comam xol haꞌ tuꞌ, yilni Comam ishajni isba satcan̈, yayilo Comam Espíritu Santo yiban̈, isyeni isba hacaꞌ yayti hunu noꞌ palamuch. ");
INSERT INTO jacNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yabelax huneꞌ yul nukꞌe yul satcan̈, halni hacaꞌ tiꞌ: —Hach tiꞌ, hach Incꞌaholan caw xahan ay wuhan, caw chintzalahan tawin̈, ẍiaytij. ");
INSERT INTO jacNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lahwin̈e tuꞌ yilaxto Comam Jesús yu Comam Espíritu Santo bey huneꞌ txꞌotxꞌ desierto. ");
INSERT INTO jacNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cawina tzꞌayic ehayo Comam bey tuꞌ xolej noꞌ xoltelajil nokꞌ. Yoc naj matzwalil yilweno Comam, yajaꞌ ayco ebnaj ángel yilno Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yet majanxa naj Juan yul preso, isto Comam Jesús bey Galilea, yoc Comam yalnocꞌo Tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chalni Comam tet anma: —Wal tinan̈ mayij isba huneꞌ tiempo halbilcanoj yocxa Comam Dios Heyahawoj. Bejwecano hetxꞌojal, chahwe Tzotiꞌ cꞌul yet colbanile yul heyanma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Hayet lan̈an isbelwi Comam Jesús istiꞌ haꞌ lago Galilea, yilnito Comam cawan̈ ebnaj ikꞌomati cay yet lan̈an yanayto ebnaj ishacꞌ chiinahti noꞌ xol haꞌ; ebnaj cawan̈ tiꞌ yuẍta isba ebnaj, haꞌ ton naj Simón yeb naj Andrés. ");
INSERT INTO jacNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yalni Comam tet ebnaj: —Ocan̈we tzujno wintajan, wal tinan̈ haxa anma chexoc heyikꞌahti yul inkꞌaban, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yaben̈e ebnaj yalni Comam hacaꞌ tuꞌ, isbejnicano ebnaj ishacꞌ yoc tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Haniqꞌuixto chito Comam Jesús xin, yilnipaxo Comam cawan̈xa ebnaj yuẍta isba, haꞌ ton naj Jacobo yeb naj Juan, ebnaj iscꞌahol icham Zebedeo. Ayahto ebnaj yul isbarco, lan̈an isbujni ebnaj ishacꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yalni Comam tet ebnaj tato chioc tzujno ebnaj yinta Comam. Hayet yaben ebnaj yalni Comam hacaꞌ tuꞌ, yanicano ebnaj ismam yeb ebnaj cꞌamteꞌ yul teꞌ barco, yoccano tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lahwi tuꞌ xin, yapni Comam Jesús yeb ebnaj iscuywom yul con̈ob Capernaum. Haxa yin̈ huneꞌ tzꞌayic xewilal yocto Comam yul iscapilla ebnaj Israel, yichico Comam iscuyni anma ayicto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Caw xin chicꞌay iscꞌul anma yaben iscuywa Comam yuto caw haban isyenilo isba ta caw akꞌbil yip yu Comam Dios, mach hacaꞌo chu iscuywa ebnaj cuywawom yin̈ isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yul capilla tuꞌ ayicto huneꞌ naj ayco ischejab naj matzwalil yin̈, yah yaw naj yin̈ caw ip, yalni naj: ");
INSERT INTO jacNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Tzet hawoc jin̈an̈ ach Jesús ah Nazaret? ¿Tom chachhul con̈hatan̈tzelojan̈ hawalni? Wohtajan mac anmahilach. Hach tiꞌ mach nino istxꞌojal ayco tawin̈, yet Dios hawehi, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iscachwa Comam yin̈ ischejab naj matzwalil tuꞌ, yalni Comam: —¡Cach hatiꞌ, elan̈ yin̈ naj! ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Istit huneꞌ yaxcamic yin̈ naj yu ischejab naj matzwalil. Yichico ischejab naj matzwalil tuꞌ yel yaw, yelcano naj yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hayet yilni anma ayicto yul capilla huneꞌ tuꞌ caw xiwcan̈, iskꞌamben anma tet hunun: —¿Tzettaxca chalilo huneꞌ tiꞌ? Huntekꞌan cuybanile chal huneꞌ naj tiꞌ caw acꞌto, maẍto bay chijabe, yeb caw ay yip naj iscuywahi. Hayet chalni naj tato chiel ischejab naj matzwalil yin̈ anma, cat isyijen ebnaj tzet chal naj, ẍi anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Caw xin yin̈ an̈e pujnato iskꞌumal Comam yul sunil ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lahwi yelti Comam Jesús yul capilla, isto Comam yeb naj Jacobo, yeb naj Juan bey yatut naj Simón yeb naj Andrés. ");
INSERT INTO jacNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yajaꞌ xin hilanto ismiꞌ yixal naj Simón sat txꞌat yu kꞌaꞌ. Yallax tet Comam tato hilanto ixnam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ishitzico Comam istiꞌ istxꞌat ixnam, yoc tzabno Comam yin̈ iskꞌab ixnam tuꞌ, isxecnican̈ Comam ixnam. Yin̈n̈ena tuꞌ xin yel huneꞌ kꞌaꞌ yin̈ ixnam, yoc ixnam iswatxꞌeno tzet chislo Comam Jesús yeb ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Haxa yin̈ kꞌejbiyalil yin̈ huneꞌ tzꞌayic tuꞌ, yilaxto sunilej anma yaꞌay tet Comam yeb anma ayco ischejab naj matzwalil yin̈. ");
INSERT INTO jacNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Etza sunil anma ay yul con̈ob tuꞌ apni istiꞌ ispultahil teꞌ n̈a bay ayicto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Caw txꞌiꞌal anma nananta yabil ayco yin̈ cawxicanocan̈ yu Comam, txꞌiꞌalpaxo xin anma el ischejab naj matzwalil yin̈. Machi xin ischah Comam tzotelo ebnaj ischejab naj matzwalil tuꞌ, yun̈e mach chalilo ebnaj mac anmahil Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Haxa yin̈ hunxa tzꞌayic caw sahab ahwano Comam Jesús, isto Comam bay machi anma chieqꞌui, haꞌ bey tuꞌ xin txahli Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tzujan tuꞌ isto naj Simón yeb ebnaj yetbi saywal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hayet yilcha Comam yu ebnaj, yalni ebnaj tet Comam: —Mamin, sunil anma lan̈an cachissaynicꞌoj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Istakꞌwi Comam tet ebnaj: —Ton̈we yulaj con̈ob ayco yin̈ ishoyanil con̈ob tiꞌ, yuto yilal walnipaxojan Istzotiꞌ Comam Dios tet anma, yu ton huneꞌ tuꞌ yuxin quinhulan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Caw xin sunil yul ismajul Galilea ecꞌ Comam yalaꞌ Istzotiꞌ Comam Dios yulaj hunun iscapilla ebnaj Israel. Yinipaxilo Comam ischejab naj matzwalil yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ay huneꞌ naj ayco lepra yin̈ apni iscꞌatan̈ Comam Jesús, yay jahno naj sata Comam, yoc naj iskꞌanno tet Comam: —Mamin, ta chawoche chu hawinilo huneꞌ yabil tiꞌ win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Istzꞌaycan̈ iscꞌul Comam yin̈ naj, yanayo Comam iskꞌab yiban̈ naj, yalni Comam tet naj: —Hoꞌ, chiwochehan ta chiel huneꞌ yabil tiꞌ tawin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yin̈n̈ena tuꞌ xin yel huneꞌ yabil yin̈ naj, iscawxican̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yalni Comam tet naj ta chipaxto naj, istakꞌencano Comam tet naj hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Machi bay chawalicꞌo huneꞌ tiꞌ, beh hato hayeno haba tet naj sacerdote cat hawakꞌni haxahanbal tet Comam Dios hacaꞌ yalni isley naj Moisés yin̈ anma chielcano lepra yin̈. Hac tuꞌ chu yohtan̈encanilo anma tato maelcano huneꞌ yabil tiꞌ tawin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yajaꞌ yet ispaxto naj, yichico naj yalni tet anma yin̈ tzet yu iscawxilo naj, yuxin matxa chu isyeni isba Comam yin̈ caw haban yulaj con̈ob. Wal xin istxamlaxan̈e con̈ob chiecꞌ Comam bay machi anma chieqꞌui. Yajaꞌ sunil anma ay yulaj con̈ob apni iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lahwi yecꞌto hayeb tzꞌayic, ismeltzopaxo Comam Jesús yul con̈ob Capernaum. Hayet yabenilo anma tato apni Comam yul n̈a bayticꞌa chicani, ");
INSERT INTO jacNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","caw txꞌiꞌal anma iscutxba isba bey tuꞌ; caw nohilo yul n̈a yeb istin̈a yu anma. Yoc Comam yalno Istzotiꞌ Comam Dios tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yapni can̈wan̈ ebnaj ikꞌn̈e huneꞌ naj camnajilo isnimanil. ");
INSERT INTO jacNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yajaꞌ mach yu yocto ebnaj yul n̈a iscꞌatan̈ Comam, yuto caw witzꞌan yu anma. Yuxin ahto ebnaj yiban̈ teꞌ n̈a tuꞌ, isholnican̈ ebnaj hanicꞌ yiban̈ teꞌ yin̈ yetcꞌulal bay ay Comam; yanayto ebnaj naj camnajilo isnimanil tuꞌ sat huneꞌ batxteꞌ tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hayet yilni Comam tato caw ayco yanma ebnaj ikꞌn̈e naj tuꞌ yin̈ Comam, yalni Comam tet naj yaꞌay tuꞌ: —Hach wet anmahil, wal tinan̈ maoccano nimancꞌulal yin̈ hamul, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ay xin huntekꞌan ebnaj cuywawom yin̈ isley naj Moisés ayicto bey tuꞌ, hayet yaben ebnaj yin̈ tzet yal Comam, yoc ebnaj istxumni hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tzet yin̈ xin hac tuꞌ yalni naj? Caw txꞌoj chal naj yin̈ Comam Dios, walxinto han̈cꞌan̈e Comam chu yakꞌni tan̈o mule,” ẍi ebnaj yin̈ isnabal. ");
INSERT INTO jacNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yajaꞌ xin istxumilo Comam yin̈ tzet chiecꞌ yin̈ isnabal ebnaj, yuxin yal Comam: —¿Tzet yin̈ hac tuꞌ hetxumni? ");
INSERT INTO jacNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Txumweloj, ¿baytet subuta walnihan tet naj tiꞌ: “Chiakꞌlax tan̈o hamul,” mato, “ahan̈wanoj, ican̈ habatxteꞌ tiꞌ cat hapaxtoj?” ");
INSERT INTO jacNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wal tinan̈ xin chinyelojan Hanin Akꞌbilintijan texol yu Comam Dios tato ay wipan wakꞌni nimancꞌulalan yin̈ ismul anma ay yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. Lahwi tuꞌ yalni Comam tet naj yaꞌay tuꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Haninan chiwalan tawet, ahan̈wanoj, ican̈ habatxteꞌ tiꞌ cat hapaxto hawatut, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yin̈n̈ena tuꞌ yahwano naj, yinican̈ naj isbatxteꞌ, yelti naj yul n̈a yin̈ sat sunil anma, ispaxto naj. Hayet yilni anma huneꞌ tuꞌ caw cꞌayilo iscꞌul, yichico anma yalni cꞌulla tzotiꞌ yin̈ Comam Dios. Yalni anma hacaꞌ tiꞌ: —Maẍto hunelo chijil huneꞌ hacaꞌ mayu tiꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Lahwi tuꞌ istopaxo Comam Jesús istiꞌ haꞌ lago Galilea, caw hantan̈e anma apni iscꞌatan̈ Comam. Yoc Comam iscuyno anma apni iscꞌatan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lahwi tuꞌ istopaxo Comam. Yilnito Comam naj Leví, iscꞌahol icham Alfeo, tzꞌon̈anayo naj bay chiel chꞌen tohlabal yin̈ anma, chꞌen chito bey Roma. Yalni Comam tet naj: —Ocan̈ tzujno wintajan, ẍi Comam. Yet yaben naj huneꞌ tuꞌ yah lin̈no naj, yoc tzujno naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Naj Leví tuꞌ, yawte naj Comam waꞌo yatut. Yoc Comam waꞌo sat meẍa yeb ebnaj iscuywom, yeb ebnaj ikꞌomilo tohlabal, yeb huntekꞌanxa mac mach cꞌulo isbeybal. Caw xin hantan̈e anma tzujan yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hayet yilni ebnaj cuywawom yin̈ isley naj Moisés yeb ebnaj fariseo ta chiwaꞌ Comam yeb anma tuꞌ, iskꞌamben ebnaj tet ebnaj iscuywom Comam: —¿Tzet yin̈ xin chiwaꞌ naj hecuywawom tiꞌ xol ebnaj ikꞌomilo tohlabal yeb ebnaj txꞌoj isbeybal? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hayet yaben Comam huneꞌ tuꞌ, yalni Comam tet ebnaj: —Haꞌ anma mach yaꞌo ay matzet chiocnico naj an̈lom yu, walxinto haꞌ anma yaꞌay haꞌ chiocnico naj an̈lom yu. Mach quinhulan wawteꞌan anma chalni tato cꞌul yecoj, walxinto haꞌ anma mulum, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yet hunel ayco ebnaj iscuywom naj Juan anican̈ haꞌ iswiꞌ anma yeb ebnaj fariseo isyijen yet mach chiwaꞌ ebnaj yu istxahli tet Comam Dios, yuxin apni huntekꞌan ebnaj iskꞌambeꞌ tet Comam Jesús: —¿Tzet yin̈ xin mach chisyije ebnaj hacuywom tiꞌ yin̈ yet mach chon̈waꞌi yu cotxahli tet Comam Dios? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Istakꞌwi Comam tet ebnaj: —Kꞌinaloj hunu mohyilal tinan̈, ¿tom chakꞌle anma awtebil tuꞌ wahil yet aycꞌo naj mohyom xol anma tuꞌ? Machoj, wal xin mach chu yijlen anma tuꞌ wahil ta aycꞌo naj mohyom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yajaꞌ chiapni istiempohal bay chiilaxilo naj mohyom tuꞌ catto yoc anma isyijen huneꞌ yet mach chon̈waꞌi yu cotxahli tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mach chu yalaxico hunu kꞌap kꞌap acto isbujilo hunu xilkꞌape caw xilxa, yuto hayet chimoqꞌui kꞌap acꞌto tuꞌ, cat cam yahcan̈ istzilmocanto huneꞌ kꞌap xilxa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hacpax tuꞌ xin, mach chu yalaxayto acꞌ vino yul noꞌ tzꞌum xilxa yuto yet chihowbican̈ teꞌ vino tuꞌ, chitzilmoto noꞌ tzꞌum tuꞌ, cat ismalcanto teꞌ vino. Yuxin yul noꞌ acꞌ tzꞌum chialaxayto teꞌ vino acꞌto, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yin̈ huneꞌ tzꞌayic xewilal xin, yecꞌto Comam Jesús yul huneꞌ nichꞌan beh xolbal ixim trigo yeb ebnaj iscuywom; yinilo ebnaj iswiꞌ ixim iscꞌuxuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yuxin yal ebnaj fariseo tet Comam: —¿Tzet yin̈ chilo ebnaj hacuywom tiꞌ iswiꞌ ixim trigo iscꞌuxuꞌ? ¿Tom mach heyohtajoj tato txahul comunla yin̈ tzꞌayic xewilal? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yajaꞌ xin takꞌwi Comam tet ebnaj: —¿Tom maẍto bay cheyil yul Yum Comam Dios yin̈ naj rey David yet isn̈ohchacan̈ naj yeb ebnaj tzujan yintaj? ");
INSERT INTO jacNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hayet isn̈ohchacan̈ naj yeb ebnaj, yocto ebnaj yul yatut Comam Dios, iswahni naj David tuꞌ ixim pan haltebilxa tet Comam, yakꞌnipaxo naj ixim iswab ebnaj yetbi tuꞌ, yajaꞌ xin han̈e ebnaj sacerdote chu iswahni ixim. Yet yuni huneꞌ tuꞌ naj Abiatar ayco yahawilo ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yacano Comam Dios tzꞌayic xewilal yu iscꞌulal yin̈ anma, maẍtaj yu coyijen tzꞌayic xewilal yuxin watxꞌicano yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hanin Akꞌbilintijan texol yu Comam Dios, chu walnihan yin̈ tzet cheyu yin̈ tzꞌayical xewilal, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yocto Comam Jesús yul iscapilla ebnaj Israel hunelxa, cꞌuxan xin ayicto huneꞌ naj camnajilo huneꞌ iskꞌab. ");
INSERT INTO jacNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ay xin huntekꞌan ebnaj ayictoj yun̈e yilni ta chakꞌ cawxo Comam huneꞌ naj tuꞌ yin̈ istzꞌayical xewilal, cat yoc ebnaj akꞌocꞌule yin̈ Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yalni Comam tet naj camnajilo iskꞌab tuꞌ: —Ahan̈wanoj cat hawoc lin̈no coxoltiꞌan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iskꞌamben Comam tet ebnaj ayicto yul capilla tuꞌ: —¿Baytettaxca chisje cowatxꞌen yin̈ istzꞌayical xewilal heyalni, ham iscꞌulal mato istxꞌojal? ¿Chimyu jan̈ten anma yaꞌay mato machoj? ẍi Comam. Hayet yaben ebnaj yalni Comam hacaꞌ tuꞌ machi hunu ebnaj takꞌwi. ");
INSERT INTO jacNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ishowbican̈ Comam, yecꞌ tꞌan̈tꞌon yin̈ anma ayicto yul capilla tuꞌ. Caw xin biscꞌulal elpaxico iscꞌul Comam yuto mach chisje ebnaj yabeto yin̈ tzet chal Comam. Lahwi tuꞌ xin yalni Comam tet naj camnajilo iskꞌab: —Toholban̈elto hakꞌab, ẍi Comam. Istoholban̈enilto naj iskꞌab, iswatxꞌicaniloj. ");
INSERT INTO jacNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Haxa yet yelti ebnaj fariseo bey tuꞌ yoc ebnaj islahtiꞌn̈en isba yeb ebnaj ayco yin̈ ispartido naj Herodes yin̈ tzet chu yakꞌni camo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lahwi tuꞌ, isto Comam istiꞌ haꞌ lago yeb iscuywom. Caw xin hantan̈e anma oc tzujno yinta Comam. Ay anma ay bey ismajul Galilea, aypaxo anma ay bey ismajul Judea, ");
INSERT INTO jacNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aypaxo xin anma ah con̈ob Jerusalén, yeb anma ah Idumea. Aypaxo xin anma ay iskꞌaxepicꞌto haꞌ niman Jordán apni. Aypaxo anma tit yul ismajul con̈ob Tiro yeb yul ismajul con̈ob Sidón. Apni sunil anma tuꞌ yuto yabelo sunil cꞌaybalcꞌule xaiswatxꞌe Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Caw xin txꞌiꞌal anma apni iscꞌatan̈ Comam, yuxin yal Comam tet ebnaj iscuywom ta chiti ebnaj hunu teꞌ barco bay chiahto Comam yun̈e machi istenico isba anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yuto caw txꞌiꞌal mac cawxican̈ yu Comam, caw xin tzetcꞌa anma yaꞌay apni yun̈e istzabni anma Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Xol anma istenba isba iscꞌatan̈ Comam tuꞌ, ay anma ayco ischejab naj matzwalil yin̈. Hayet yilni ebnaj Comam, yay jahno ebnaj sata Comam, yahwi ebnaj yin̈ caw ip: —Hach tiꞌ hach Iscꞌahol Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yajaꞌ cachwa Comam yin̈ ebnaj ta mach chalilo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lahwi tuꞌ yahto Comam Jesús yin̈ istzalanil huneꞌ won̈an, yawtenti Comam macta chal iscꞌul, ishitzico macta yawte Comam tuꞌ iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lahwi tuꞌ issicꞌlenilo Comam cablahon̈wan̈ ebnaj yu yoccano tzujno yinta Comam yeb yu yalnicꞌo Istzotiꞌ Comam Dios tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yakꞌnicano Comam yip ebnaj ischejnilo ischejab naj matzwalil yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hac tiꞌ isbi ebnaj cablahon̈wan̈ tuꞌ hacaꞌ tiꞌ: naj Simón, Pedro yaco Comam isbiho naj, ");
INSERT INTO jacNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","naj Jacobo, yeb naj Juan; ebnaj cawan̈ tiꞌ yuẍta isba ebnaj, iscꞌahol icham Zebedeo ye ebnaj, Boanerges yacanico Comam isbiho ebnaj. Huneꞌ bihe tuꞌ chal yelapnoj Yuninal Cꞌuh. ");
INSERT INTO jacNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yebpaxo xin naj Andrés, naj Felipe, naj Bartolomé, naj Mateo, naj Tomás, naj Jacobo, Iscꞌahol icham Alfeo. Naj Tadeo, naj Simón ayticꞌaco yin̈ huneꞌ partido cananista, ");
INSERT INTO jacNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yeb naj Judas Iscariote, naj anico Comam yul iskꞌab camical. Lahwi tuꞌ yapni Comam Jesús yul huneꞌ n̈a yeb ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Caw xin txꞌiꞌal anma apnipaxo iscꞌatan̈ Comam, caw matxaticꞌa chu iswaꞌ Comam yeb ebnaj iscuywom tuꞌ yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hayet yohtan̈enilo ebnaj yuẍta Comam ta apni Comam bey huneꞌ n̈a tuꞌ, yapni ebnaj ikꞌwal yin̈ Comam yalni, yuto challaxi tato xaetaxto yul iswiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aypaxo xin huntekꞌan ebnaj cuywawom yin̈ isley naj Moisés ispeto Jerusalén apni iscꞌatan̈ Comam, yalni ebnaj yin̈ Comam hacaꞌ tiꞌ: —Naj tiꞌ chu yinilo naj ischejab naj matzwalil yin̈ anma yuto naj Beelzebú, yahawil ebnaj matzwalil, chiakꞌni yip naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hayet yaben Comam yalni ebnaj hacaꞌ tuꞌ, yawten Comam ebnaj, yanico Comam huneꞌ yechel tiꞌ tet ebnaj: —¿Tzettaxca chu yinilo naj matzwalil hunuxa yet matzwalilal yin̈ anma? ");
INSERT INTO jacNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kꞌinaloj ta ay hunu con̈ob chispoh isba cat yanico howal yin̈ hunun, ta hac tuꞌ caw yin̈ an̈emi chitan̈ilo yip huneꞌ con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hacpax tuꞌ xin ta ay hunu n̈ahil ebnaj yuẍtan̈e isba chakꞌle howal, yin̈ an̈emi chipax yip huneꞌ n̈ahil anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hacmi tuꞌ chu naj matzwalil ta chispoh isba naj yeb ischejab cat yanico naj howal yin̈ ischejab tuꞌ, ta hac tuꞌ caw yin̈ an̈emi chipax yip naj cat istan̈ilo naj. ");
INSERT INTO jacNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kꞌinalo ta ay hunu naj yahaw n̈a caw ay yip, machmi hunu naj elkꞌom chu yocto yul yatut naj yelkꞌanolti tzet ay naj, cachann̈e tato chikꞌoji naj elkꞌom tuꞌ yin̈ naj cat iscꞌalban naj naj, hacn̈em tuꞌ chu yelkꞌanilti naj tzet ay naj. ");
INSERT INTO jacNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yin̈ caw yeli chiwalan teyet, tzijxan̈e mulehal chaco anma, maca tzijxan̈e tzotiꞌ txꞌoj chala, ayto nimancꞌulal yin̈ yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yajaꞌ wal mac txꞌoj istzotel yin̈ Comam Espíritu Santo, huneꞌ mac tuꞌ matxa bakꞌinal ay nimancꞌulal yin̈ yu Comam Dios, chicanto ismul tuꞌ yin̈ sunilbal tiempo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yal Comam hacaꞌ tuꞌ yuto yal ebnaj tato ayco ischejab naj matzwalil yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hayet yapni ismiꞌ Comam Jesús yeb ebnaj yuẍta ilwal yin̈, mach octo yul n̈a, ton̈e ischej ebnaj awtelaxo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Xol anma tzꞌon̈anayo iscꞌatan̈ Comam tuꞌ, ay mac halni: —Mam cuywawom, aycꞌo hamiꞌ yeb ebnaj hawuẍta istiꞌ n̈a, lan̈an cachissayni ebnaj, ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Istakꞌwi Comam: —¿Mac inmiꞌan yeb wuẍtajan heyalni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yecꞌ tꞌan̈tꞌon Comam yin̈ sunil mac tzꞌon̈anayo iscꞌatan̈ tuꞌ, yalni Comam xin: —Haꞌ mac ayicti bey tiꞌ, haꞌ inmiꞌan, haꞌ wuẍtajan, ");
INSERT INTO jacNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yuto haꞌ mac chiyijen tzet chal Comam Dios, haꞌ wuẍtajan, haꞌ wanaban yeb xin haꞌ inmiꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Haxa yet hunelxa xin oc Comam Jesús iscuyu anma istiꞌ haꞌ lago, yajaꞌ yu caw hantan̈e anma yuxin ahto Comam yul huneꞌ teꞌ barco ayco iscawilal, wal anma xin cancano istiꞌ haꞌ lago tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yichico Comam iscuyni anma, caw xin txꞌiꞌal tzet yaco Comam yecheloj yet chicuywahi. Yet iscuywa Comam tuꞌ yalni Comam huneꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tinan̈, abewe tzet chiwalan: Ay huneꞌ naj to txiho trigo. ");
INSERT INTO jacNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hayet lan̈an istxihnayo naj ixim, ay ixim apni cꞌatna yul beh, yul noꞌ chꞌic islohnoto ixim. ");
INSERT INTO jacNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aypaxo xin ixim apni cꞌatna xolaj chꞌen chꞌen bay machi bin txꞌo txꞌotxꞌ, caw xin pet ahilo ixim yu kꞌaxan xolaj chꞌen, mach nahatto yehayto yich txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yajaꞌ yet yahilo tzꞌayic yet yikꞌnican̈ yip kꞌaꞌ istajayo ixim, yuto machi bay yayto xeꞌ ixim yu chꞌen chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aypaxo xin ixim apni xolaj yin̈atil teꞌ txꞌix, hayet ischꞌibcan̈ ixim ischꞌibpaxocan̈ teꞌ, yuxin tzꞌonbayo ixim, machi xin sat ixim yacoj. ");
INSERT INTO jacNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wal ixim apni cꞌatna xol txꞌo txꞌotxꞌ caw cꞌul, caw sakꞌal yu ischꞌibcan̈ ixim yeb caw yakꞌ sat ixim. Ay ixim treinta yuteco sat yin̈ hunun iswiꞌ, ay bay sesenta, aypaxo bay cien yuco sat ixim yin̈ hunun iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Maquex cheyabe huneꞌ tiꞌ akꞌwe heyanma hetxumniloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hayet haxan̈e iscuywom Comam Jesús cancano iscꞌatan̈ yeb mac chi-ticꞌa-aben tzet chal Comam, yoc ebnaj iskꞌambeno tet Comam yin̈ tzet chal yelapno huneꞌ yechel yaco Comam yet iscuywahi. ");
INSERT INTO jacNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Istakꞌwi Comam tet ebnaj: —Teyetn̈e chakꞌ Comam Dios heyohtan̈elo huntekꞌan ewanticꞌa yehi, yun̈e hetxumni yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. Wal tet comon anma xin yecheln̈e chakꞌ Comam tet. ");
INSERT INTO jacNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Waxan̈ca hajan isbakꞌsat, yajaꞌ mach chila, waxan̈ca chabe, yajaꞌ mach chitxumchalo yu, yuxin mach chaco isba yul iskꞌab Comam Dios cat yakꞌlax nimancꞌulal yin̈ ismul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yalnipaxo Comam tet iscuywom: —Ta machi txumchalo heyu yin̈ naj txihom trigo wacojan yechelo teyet, ¿tzicꞌanab xin chu hetxumnilo huntekꞌanxa yechel chiwalan chal tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Naj txihom trigo tuꞌ, yechel yeco naj yin̈ mac chihalnicꞌo Istzotiꞌ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ixim hin̈at apni yul beh, yechel yin̈ anma chiaben Istzotiꞌ Comam Dios, yajaꞌ lahwi yabeni cat yul naj matzwalil yinolo yin̈ yanma. ");
INSERT INTO jacNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ixim aycꞌay xolaj chꞌen chꞌen, yechel yin̈ anma chiaben Istzotiꞌ Comam Dios cat ischahni yin̈ tzalahilal yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yajaꞌ yu maẍto yip yanma yin̈ Comam yuxin hayet chul ilwebal yiban̈ yeb yet chicajlax yu Istzotiꞌ Comam, caw yin̈ an̈e chilo yanma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ixim hin̈at apni xolaj yin̈atil teꞌ txꞌix yechel yin̈ mac chiaben Istzotiꞌ Comam Dios, ");
INSERT INTO jacNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yajaꞌ yu ecꞌbal chaco yin̈ iscꞌul yin̈ tzet ay yul sat yiban̈kꞌinal tiꞌ cat yanico yanma yin̈ kꞌalomal, chochenpaxto sunil tzet ye tuꞌ. Haꞌ sunil huntekꞌan tuꞌ chiakꞌni cꞌayolo Istzotiꞌ Comam yul yanma, hac tuꞌ xin mach chichꞌib yin̈ yet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Haxa ixim hin̈at apni xol txꞌo txꞌotxꞌ caw cꞌul, yechel yin̈ anma chiaben Istzotiꞌ Comam Dios cat ischahni yul yanma. Lahan anma tuꞌ hacaꞌ ixim caw niman sat yakꞌa; hacaꞌ ixim yaco treinta sat yin̈ hunun iswiꞌ, hacaꞌ ixim sesenta yeb ixim yaco cien sat yin̈ hunun iswiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yalnipaxo Comam Jesús: —Yet chicotzujbanico kꞌaꞌ yin̈ hunu cantil, mach chicon̈ohbaco hunu cahon yiban̈, mach chijapaxicto yalan̈ txꞌat. Wal xin nahat chicotꞌun̈bacan̈ yun̈e ismujli. ");
INSERT INTO jacNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hacpax tuꞌ xin sunil tzet ewan yehi, chiixtan̈wiloj yeb sunil tzet ye tuꞌ mach ohtabiloj chiohtan̈elaxi. ");
INSERT INTO jacNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maquex cheyabe huneꞌ tiꞌ, akꞌwe heyanma hetxumniloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yalnipaxo Comam: —Cam cheyabe tzet chiwaltiꞌan yuto hacaꞌ heyanico yin̈ heyanma heyabeni, hac tuꞌ chu yakꞌni Comam Dios hetxumuꞌ, caw xin ecꞌbalto chu yakꞌni Comam hetxumuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yuto haꞌ mac chakꞌ yanma istxumni, chakꞌpaxo Comam yakꞌbil tet, yajaꞌ wal mac mach chicam iscꞌul istxumni, haꞌ nichꞌan etza chitxumchalo yu chiilaxilo tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yalnipaxo Comam Jesús: —Anma chioc yul iskꞌab Comam Dios, lahan hacaꞌ hunu naj chitxihnayo ixim trigo sat txꞌo txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Waxan̈ca chiway naj akꞌbalil cat yahwano naj tzꞌayical, yajaꞌ ixim hin̈at tuꞌ chul iscꞌul ixim cat ischꞌib ixim; mach yohtajo naj yin̈ tzet chu ischꞌib ixim. ");
INSERT INTO jacNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yul txꞌotxꞌ chiswatxꞌe isba ixim; haꞌ yin̈ babelal chiahilo ixim, haxa yin̈ tzujanilxa xin cat ispoh ixim, lahwi tuꞌ cat yoc yul ixim. ");
INSERT INTO jacNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Haxa yet chikꞌanbilo ixim, cat yul naj iscꞌupnocan̈ ixim yuto istiempohalxa yah ixim, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yalnipaxo Comam Jesús: —¿Tzettaxca chiyu ischꞌib isbisil anma chioc yul iskꞌab Comam Dios chute hetxumni? ");
INSERT INTO jacNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wal xin lahan hacaꞌ nichꞌan yin̈atil teꞌ mostaza chitzꞌunlaxi. Teꞌ hin̈at mostaza tuꞌ, haꞌ teꞌ caw nichꞌanchꞌan xol sunilej teꞌ hin̈at, ");
INSERT INTO jacNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","yajaꞌ yet chitzꞌunlax teꞌ xin cat ischꞌibcan̈ teꞌ, haꞌ xin teꞌ ecꞌbal nimajal chu sata sunilej teꞌ itah. Caw nimej chu iskꞌab teꞌ yuxin chiapni noꞌ chꞌic iswatxꞌe yatut xol iskꞌab teꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hac tuꞌ yu iscuyni Comam Jesús anma yin̈ Istzotiꞌ Comam Dios yet yanico Comam huntekꞌan yechel tet anma. Caw txꞌiꞌal yechel yaco Comam, hataticꞌa hanta chikꞌoji anma istxumni. ");
INSERT INTO jacNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sunil cuybanile yakꞌ Comam, yecheln̈e yaco Comam tet anma. Wal tet ebnaj iscuywom Comam xin, yal Comam yin̈ haban yin̈ tzet chal yelapnoj. ");
INSERT INTO jacNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yet kꞌejbiyalil yin̈ticꞌa huneꞌ tzꞌayic tuꞌ, yalni Comam Jesús tet ebnaj iscuywom: —Ton̈we iskꞌaxepicꞌto haꞌ lago tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hac tuꞌ yu iscancano anma istiꞌ haꞌ, yinito ebnaj Comam yul teꞌ barco ayayo bey tuꞌ. Aypaxo xin huntekꞌan teꞌ barco oc tzujno yinta teꞌ bay ayicto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hayet ayco teꞌ yiban̈ ha haꞌ istit huneꞌ niman jakꞌekꞌ, yichico jakꞌekꞌ ismakꞌnicto haꞌ yul teꞌ barco tuꞌ, caw xin nohayto haꞌ yul teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wal Comam xin wayo chu yin̈ilto isyutz teꞌ, kꞌeyanayo yiban̈ huneꞌ iskꞌan̈ wiꞌe. Yoc ebnaj yinolo iswayan̈ Comam, yalni ebnaj: —Mam cuywawom, caw matzet chal nino hacꞌul, lan̈an coto yich haꞌ lah, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hayet yaben Comam huneꞌ tuꞌ yahwano Comam, iscachni Comam jakꞌekꞌ yeb ha haꞌ: —Matxa chexbili, lin̈bawe heba, ẍi Comam. Yin̈n̈ena tuꞌ islin̈ban isba jakꞌekꞌ yeb ha haꞌ, ispaxtzꞌin̈nahi. ");
INSERT INTO jacNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yalni Comam tet ebnaj iscuywom tuꞌ: —¿Tzet yin̈ xin caw chexxiwi? Caw mach chicawxi hecꞌul yin̈ Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wal ebnaj iscuywom Comam tuꞌ caw xiw ebnaj, yalni ebnaj tet hunun: —¿Mac anmahil yaꞌ tiꞌ yuxin chisyije jakꞌekꞌ yeb ha haꞌ yin̈ tzet chal yaꞌ? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lahwi tuꞌ, yapni Comam Jesús iskꞌaxepicꞌto haꞌ lago yeb iscuywom yul ismajul Gadara. ");
INSERT INTO jacNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hayet yel Comam yul teꞌ barco tuꞌ, yapni huneꞌ naj ayco ischejab naj matzwalil yin̈ iscꞌatan̈ Comam. Naj tuꞌ ispeto naj xolaj panteón, ");
INSERT INTO jacNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","caw xin haꞌ bey tuꞌ huneln̈e ye naj. Maẍticꞌa xin chakꞌ cꞌalba isba naj waxan̈ca chicꞌalbalax naj yu chꞌen cadena. ");
INSERT INTO jacNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Caw txꞌiꞌal el cꞌalbalax iskꞌab naj yeb yoj naj yu chꞌen cadena, yajaꞌ chislin̈to naj chꞌen, caw machi hunu mac chikꞌoji yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yet tzꞌayical yeb yet akꞌbalil chꞌecꞌ naj yin̈la istzalanil witz yeb xolaj panteón, caw xin chiel yaw naj yet chiecꞌ naj; chi-xin-ismakꞌico isba naj yin̈ej chꞌen chꞌen yeqꞌui. ");
INSERT INTO jacNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yet nahatto ay naj yilnito naj Comam, istit naj yin̈ an̈e isjahbanayo isba sata Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yalni Comam: —¡Hach matzwalil, elan̈ yin̈ naj tiꞌ! ẍi Comam. Yah yaw naj yin̈ caw ip: —¿Tzet hawoc win̈an Jesús, Iscꞌahol Dios caw aycano yip? Caw chinkꞌanan tawet, mach chawakꞌ ecꞌoyaꞌ wanmahan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iskꞌamben Comam tet naj: —¿Tzet habi? ẍi Comam. Istakꞌwi naj: —Legión inbihan yuto caw niman jikꞌni cobahan̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Caw xin iskꞌan ebnaj ischejab naj matzwalil tuꞌ tet Comam tato mach chischejilo Comam ebnaj yul ismajul huneꞌ txꞌo txꞌotxꞌ bay ay tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cꞌuxan xin tzetcꞌa noꞌ txitam lan̈an islo yin̈ istzalanil huneꞌ witz tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","yuxin yal ebnaj ischejab naj matzwalil tuꞌ tet Comam: —Chejon̈tojan̈ yin̈ noꞌ txitam tuꞌ lah, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Istakꞌwi Comam: —Quexwej, ẍi Comam. Hac tuꞌ yu yelcano ebnaj ischejab naj matzwalil yin̈ naj, istocano ebnaj yin̈ noꞌ txitam tuꞌ, aymi noꞌ cabo mil. Hayet yapni ebnaj ischejab naj matzwalil yin̈ noꞌ xin, iskꞌojnito isba noꞌ sat pahaw yay apno noꞌ yul haꞌ lago, ishikꞌnito noꞌ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hayet yilni ebnaj tan̈em txitam huneꞌ tuꞌ yelcan̈ ebnaj, isto ebnaj yalno tet ebnaj lan̈an ismunla iscawilal tuꞌ yeb tet anma ay yul con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hayet yapni anma iscꞌatan̈ Comam, yilni anma naj bay ayticꞌaco ebnaj ischejab naj matzwalil, ayxaco xil iskꞌap naj, caw xiw anma yilni huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Haꞌ xin anma ilni yin̈ tzet iswatxꞌe Comam yin̈ naj bay ayticꞌaco ischejab naj matzwalil tuꞌ, yeb yin̈ tzet yu isto noꞌ txitam sat pahaw, haꞌ ebnaj halni tet huntekꞌanxa anma apni ilnoj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yichico anma yalni tet Comam tato chiel Comam sat istxꞌotxꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hayet yocto Comam yul teꞌ barco, yet ismeltzoxa, yalni naj bay el ischejab naj matzwalil tet Comam tato chischahto Comam naj yintaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yajaꞌ xin mach chisje Comam, yalni Comam tet naj: —As paxan̈to hawatut cat hawalni tet sunil mac ayto hawu haba yebi yin̈ tzet mayu hacawxican̈ yeb iscꞌulchꞌanil iscꞌul Comam tawin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hayet yaben naj huneꞌ tuꞌ ispaxto naj, yichico naj ispujbanicꞌo yulaj con̈ob ay yul ismajul Decápolis yin̈ tzet yu iscawxican̈ naj. Wal anma xin caw chicꞌay iscꞌul yaben tzet chal naj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hayet yeqꞌuilo Comam Jesús iskꞌaxepicꞌto haꞌ lago, caw hantan̈e anma apni iscꞌatan̈ Comam, yuxin cancano Comam istiꞌ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lahwi tuꞌ, yapni huneꞌ naj chiyij Jairo iscꞌatan̈ Comam, yahawil yeco naj yin̈ capilla. Haꞌ yet yapni naj iscꞌatan̈ Comam yay jahno naj yich yoj Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yoc naj iskꞌanno tet Comam hacaꞌ tiꞌ: —Mamin, ay huneꞌ nichꞌan incutzꞌinan lan̈anxa iscami, estam chachto nino wintajan cat hawanayo hakꞌab yiban̈ ix haxinwal chicawxican̈ ix, hac tuꞌ xin mach chicam ix, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hac tuꞌ yu isto Comam yinta naj, caw xin hantan̈e anma ocpaxo tzujno yinta Comam, toxan̈e xin chistenico isba anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xol anma tuꞌ ayco huneꞌ ix cablahon̈ebxa habil yichico yay istxꞌahwobal, matxaticꞌa chilin̈i. ");
INSERT INTO jacNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Caw txꞌiꞌalxa ebnaj doctor bay xaecꞌ ix, caw xaistan̈tzelo ix sunil tzet aya yu yan̈chahi, yajaꞌ maẍticꞌa chian̈cha ix; wal xin caw ip yahcan̈ huneꞌ yabil tuꞌ yin̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yajaꞌ xayabe ix yin̈ ej iscꞌulal chiswatxꞌe Comam, yuxin hitzico ix yinta Comam xol anma tuꞌ, istzabni ix xil iskꞌap Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yuto istxum ix hacaꞌ tiꞌ: “Waxan̈ca han̈e xil iskꞌap Comam chintzaban cat incawxican̈an,” ẍi ix ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lan̈antoticꞌa istzabni ix xil iskꞌap Comam, islin̈inacan̈ yin̈ ix, iscawxinalo ix. ");
INSERT INTO jacNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wal Comam Jesús yohtan̈eloj tato ay huneꞌ mac cawxilo yu yip, yuxin ismeltzo isba Comam istꞌan̈xito yin̈ anma tuꞌ, yalni Comam: —¿Mac maquintzabnihan? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Istakꞌwi ebnaj iscuywom Comam: —Mamin, ¿tom mach chawila tato caw hantan̈e anma chistenico isba tawin̈ cat hakꞌambenpaxoj mac macachtzabni? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yajaꞌ yexn̈e yecꞌ tꞌan̈tꞌon Comam yin̈ anma tuꞌ yu yilni mac tzabni Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wal ix xin toxan̈e chibayla yah ix yu xiwquilal, ishitzico ix, yay jahno ix sata Comam, yalnilo ix yin̈ tzet yu iscawxican̈. ");
INSERT INTO jacNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yalni Comam tet ix: —Miyay, macachcawxinacan̈ yu maxawaco hawanma win̈an, paxan̈to yin̈ tzalahilal, cawachxa tinan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lan̈antoticꞌa xin, yapni huntekꞌan ebnaj ispeto bey yatut naj Jairo, ismam ix nichꞌan yaꞌay tuꞌ, yalni ebnaj tet naj: —Mam Jairo, wal ix hacutzꞌin macamna ix, nabxan̈e chawito naj cuywawom tiꞌ tawintaj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hayet yaben Comam yin̈ tzet yal ebnaj tuꞌ, yalni Comam tet naj Jairo: —Mach chawaco yin̈ hacꞌul, wal xin aco hawanma yin̈ Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mach xin isje Comam tato chito anma yintaj, cachann̈e naj Pedro, naj Jacobo yeb naj Juan yito Comam; naj Jacobo yeb naj Juan tuꞌ, yuẍta isba ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hayet yapni Comam yatut naj Jairo tuꞌ, yilni Comam tatoxan̈e chiwejcha anma yokꞌ yu biscꞌulal yin̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yocto Comam yul n̈a tuꞌ, yalni Comam tet anma: —¿Tzet yin̈ xin chexwejcha heyokꞌi? Ix nichꞌan tiꞌ mach camnajo ix, wal xin ton̈e chiway ix, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hayet yaben anma yalni Comam hacaꞌ tuꞌ, yoc anma tzebo yin̈ Comam. Lahwi tuꞌ ischejnilti Comam sunil mac ayicto bey tuꞌ, haxan̈e xin ismam yeb ismiꞌ ix yeb ebnaj oxwan̈ tuꞌ octo yinta Comam bay ay ix nichꞌan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yoc tzabno Comam yin̈ iskꞌab ix, yalni Comam tet ix: —Talita cumi, ẍi Comam. Haꞌ chal yelapno tuꞌ: “Hach nichꞌan tzꞌul, haninan chiwalan tawet, ahan̈wanoj.” ");
INSERT INTO jacNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yin̈n̈ena tuꞌ yahwano ix nichꞌan tuꞌ, yichico ix yeqꞌui. Caw xin cablahon̈eb habil ix. Hayet yilni anma huneꞌ tuꞌ, caw toxan̈e chicꞌay iscꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yalni Comam tato chiakꞌlax waꞌo ix, yalnipaxo Comam tato mach bay chihallaxicꞌo huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lahwi tuꞌ yel Comam Jesús yul con̈ob Capernaum, yapni Comam yul iscon̈ob, haꞌ ton xin Nazaret; tzujanpaxo xin ebnaj iscuywom Comam yintaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Haxa yin̈ istzꞌayical xewilal, yoc Comam iscuyno anma yul capilla. Hayet yaben anma iscuywa Comam caw cꞌayilo iscꞌul, yalni anma tuꞌ hacaꞌ tiꞌ: —¿Baytuꞌwal bey naj tiꞌ iscuyu huntekꞌan tiꞌ? ¿Baytuꞌwal chiti naj ishelanil yeb yip iswatxꞌen huntekꞌan cꞌaybalcꞌule chisye tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Tom maẍtaj naj tiꞌ naj hutxꞌum teꞌ, naj yunin ix María? yeb ¿tom mach yuẍtajo isba naj yeb naj Jacobo, naj José yeb naj Judas, yeb naj Simón? ¿Tom xin maẍtaj coxol tiꞌ aypaxo yanab naj? ẍi ebnaj. Yu huneꞌ tuꞌ yuxin mach isje ebnaj yabeꞌ yin̈ tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yalni Comam tet ebnaj: —Sunil ischejab Comam Dios yul hunuxa nan con̈obal caw xahan chiillaxi, wal yul iscon̈ob xin mach xahano chiillax yu yet con̈ob, yeb yu mac ayto yu isba yebi yeb yu ej yuẍtaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mach txꞌiꞌalo cꞌaybalcꞌule isye Comam bey tuꞌ, cachann̈e haywan̈n̈e mac yaꞌay bay yayo Comam iskꞌab, iscawxiloj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Caw xin cꞌay iscꞌul Comam yuto huntekꞌan anma ay bey tuꞌ mach yayto yul yanma yin̈ Comam. Lahwi tuꞌ xin, isto Comam Jesús iscuyno anma yin̈ Istzotiꞌ Comam Dios yulaj con̈ob ayco yin̈ ishoyanil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yawten Comam ebnaj cablahon̈wan̈ iscuywom yanito Comam ebnaj yin̈ catawan̈. Yakꞌni Comam yip ebnaj yinilo ischejab naj matzwalil yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yet yalan̈to maẍto chito ebnaj tuꞌ, yalnicano Comam ischejbanil ebnaj hacaꞌ tiꞌ: —Matzet cheyito yin̈ hebel, mach cheyito hetzꞌispa yeb tzet chelo, yebpaxo hemelyu. Wal xin han̈cꞌan̈e hekꞌojoch cheyitoj, ");
INSERT INTO jacNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yeb han̈e hexan̈ab ayco yin̈ heyoj haꞌn̈echꞌan cheyitoj, machi xin cheyipaxto hehelbal. ");
INSERT INTO jacNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hayet chexapni yul hunun con̈ob, haꞌ teꞌ n̈a bay chekꞌan bay chexwayi, han̈e bey tuꞌ chexapni wayoj masanta yet chexmeltzohi. ");
INSERT INTO jacNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yajaꞌ tato ay hunu con̈ob bay mach chexchahlax yu anma yeb mach choche yabe tzet cheyala, chexel yul huneꞌ con̈ob tuꞌ, cat hetzicnicanilo ispojojal iscon̈ob anma tuꞌ yin̈ heyoj, yun̈e heyeniloj tato matxa heyoc yin̈ huntekꞌan anma tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lahwi tuꞌ xin, isto ebnaj iscuywom Comam tuꞌ yalno tet anma ta chisbejcano iswatxꞌen istxꞌojal, cat yanico isba yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Caw xin txꞌiꞌal mac bay yilo ebnaj ischejab naj matzwalil, txꞌiꞌal mac yaꞌay ismasico ebnaj aceite yin̈, iscawxicanocan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yabelo naj rey Herodes iskꞌumal Comam Jesús yuto sunilxan̈e bay cꞌul istzotel anma yin̈ Comam. Yalni naj Herodes hacaꞌ tiꞌ: —Haꞌ huneꞌ naj tuꞌ, haꞌ ton naj Juan anican̈ haꞌ iswiꞌ anma xaitzitzbican̈, yuxin ay yip naj iswatxꞌen cꞌaybalcꞌule, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aypaxo mac chalni: —Etzan̈em naj Elías huneꞌ tuꞌ, ẍi. Aypaxo mac chalni: —Huneꞌ naj tuꞌ ischejab Comam Dios ye naj, hacaꞌ ebnaj ecꞌlena yet payat, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hayet yaben naj rey Herodes huneꞌ tuꞌ xin, yalni naj: —Haꞌ huneꞌ naj tuꞌ haꞌ ton naj Juan anican̈ haꞌ iswiꞌ anma xaitzitzbican̈, naj inchejan eloto iswiꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yuto yu ix Herodías, yuxin ischej naj Herodes tzablaxoyo naj Juan, iscꞌalbalax naj yu chꞌen cadena, yalaxicto naj yul preso. Ix Herodías tuꞌ, yixal yuẍta naj rey Herodes ye ix, haꞌ ton naj Felipe. Yajaꞌ yikꞌcan̈ naj rey Herodes tuꞌ yixal yuẍtaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yu huneꞌ tuꞌ, yuxin cachwa naj Juan yin̈ naj Herodes hacaꞌ tiꞌ: “Mach cꞌulo hawikꞌni yixal hawuẍtaj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hayet yaben ix Herodías huneꞌ tuꞌ, caw oc ishowal ix yin̈ naj Juan, yuxin yoche ix ispotxꞌo naj, yajaꞌ machi yu yu ix, yuto ayco istan̈emal naj yu naj Herodes yu chixiw naj yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wal naj Herodes caw yohta naj tato caw tohol isbeybal naj Juan tuꞌ, yeb ta machi nino istxꞌojal yin̈ naj. Hayet chitzotel naj Juan tuꞌ caw chabe naj Herodes yin̈ tzet chal naj, yajaꞌ mach chitxumcha yu naj yin̈ tzet wal yuten isba. ");
INSERT INTO jacNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yajaꞌ yet hunel xin yecꞌtze naj Herodes huneꞌ kꞌin̈ yuto tzꞌajna naj yin̈ ishabilal, yawten naj ebnaj nimeta winaj chimunla yinta waꞌo yin̈ huneꞌ kꞌin̈ tuꞌ. Yawtenpaxo naj ebnaj yahawil yin̈ ebnaj soldado yeb ebnaj iswiꞌehal yin̈ con̈ob Galilea. Haꞌ tuꞌ xin apni istzꞌayical bay chu iswatxꞌen ix Herodías istxꞌojal yin̈ naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ix yunin ix Herodías tuꞌ, octo ix can̈alwo yin̈ huneꞌ kꞌin̈ tuꞌ, caw xin cꞌul yu iscan̈alwi ix yin̈ sat naj Herodes yeb yin̈ sat ebnaj ayco waꞌo iscꞌatan̈ naj Herodes tuꞌ, yuxin yal naj tet ix: —Kꞌan tzet chawoche wetan chiwakꞌan tawet. ");
INSERT INTO jacNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Caw chiwalan yabe Comam Dios tato chiwakꞌan tzet chakꞌana, waxan̈ca yicta tzet ayco yul inkꞌaban, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hayet yaben ix huneꞌ tuꞌ, yelto ix, isto ix iskꞌambeno tet ismiꞌ: —¿Tzettaxca chinkꞌanan miꞌ? ẍi ix. Yalni ix Herodías tet yunin tuꞌ: Haꞌ iswiꞌ naj Juan anican̈ haꞌ iswiꞌ anma chakꞌana, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Isto ix yin̈ an̈e iscꞌatan̈ naj Herodes tuꞌ, yalni ix: —Tinan̈ chiwochehan chawakꞌ iswiꞌ naj Juan yul hunu plato wetan, naj anican̈ haꞌ iswiꞌ anma, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hayet yaben naj rey Herodes huneꞌ tuꞌ caw biscꞌulal elico iscꞌul naj, yajaꞌ matxa yu isman̈cꞌon naj yuto yal naj yin̈ sat ebnaj cutxanico tuꞌ ta chakꞌ naj tzijxan̈e tzet chiskꞌan ix. ");
INSERT INTO jacNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ischejni naj huneꞌ naj soldado yikꞌalo iswiꞌ naj Juan. Isto naj soldado tuꞌ yinolo iswiꞌ naj Juan yul preso, yinito naj yul huneꞌ plato, yakꞌni naj tet ix kꞌopo tuꞌ. Lahwi tuꞌ xin isto ix yakꞌno tet ismiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hayet yaben ebnaj iscuywom naj Juan huneꞌ tuꞌ, yul ebnaj iskꞌanno isnimanil naj, isto ebnaj ismujnocanoj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hayet ismeltzoto ebnaj ischejab Comam Jesús iscꞌatan̈, yichico ebnaj yalni tet Comam yin̈ tzet iswatxꞌe yeb yin̈ tzet bey ebnaj yakꞌaꞌ iscuyuꞌ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lahwi tuꞌ xin yalni Comam tet ebnaj: —Ton̈we xewo bay machi anma chieqꞌui, ẍi Comam. Yal Comam hacaꞌ tuꞌ yutoxan̈e chitenxi anma yin̈ Comam, ay anma chitohi, aypaxo anma chihuli. Matxaticꞌa xin ishamanil Comam iswaꞌ yeb ebnaj iscuywom yu anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yuxinto octo Comam yeb ebnaj ischejab yul huneꞌ teꞌ barco, isto Comam bay machi anma chieqꞌui. ");
INSERT INTO jacNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yajaꞌ txꞌiꞌal mac ilni isto Comam yeb ebnaj, istxumnilo anma bay chiapni Comam, yuxin sunil anma ay yul huntekꞌan con̈ob ayayo istiꞌ haꞌ tuꞌ, to yu yoj bay chiapni Comam. Babel xin apni anma tuꞌ sata Comam yuxin hayet yapni Comam wejanxato anma yechmani. ");
INSERT INTO jacNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hayet yelti Comam yul teꞌ barco tuꞌ, yilni Comam anma tenanayo tuꞌ, istzꞌaycan̈ iscꞌul Comam yin̈ anma yuto lahan anma tuꞌ hacaꞌ noꞌ meꞌ machi mac chitan̈eni. Hac tuꞌ yu yocpaxo Comam yalni txꞌiꞌal cuybanile tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Haxa yin̈ kꞌejbiyal xin ishitzico ebnaj iscuywom Comam iscꞌatan̈, yalni ebnaj xin: —Mamin, caw kꞌejbixa lah, machi xin teꞌ n̈a bay ayon̈ tiꞌ; ");
INSERT INTO jacNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","estam chachejto anma bay ayej teꞌ n̈a, maca yulaj aldea ayco cohoyanil tiꞌ cat islokꞌni tzet chislo, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yalni Comam tet ebnaj: —Akꞌwe tzet chislo anma hex ti, ẍi Comam. Istakꞌwi ebnaj tet Comam: —¿Tom chon̈tohan̈ colokꞌohan̈ cab ciento denario ixim pan chiswah anma tiꞌ chal tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yalni Comam tet ebnaj: —¿Hayeb ixim pan ay texol? Ilwej hayeb ixim, ẍi Comam. Hayet yilni ebnaj, yalni ebnaj tet Comam: —Mamin, howebn̈e ixim yeb cacꞌon̈ noꞌ niẍte cay, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yalni Comam tet anma tato chiay tzꞌon̈no sat chekꞌan tuꞌ yin̈ hunta majan. ");
INSERT INTO jacNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yuxin ay tzꞌon̈no anma yin̈ cincuenta yeb cien yin̈ hunun majan. ");
INSERT INTO jacNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Lahwi tuꞌ xin yinican̈ Comam ixim howeb pan yeb noꞌ cacꞌon̈ cay, istꞌan̈xican̈ Comam satcan̈, iskꞌanni Comam iscꞌulal Comam Dios yiban̈ tzet chilolax tuꞌ. Lahwi tuꞌ yoc Comam iskꞌaxponoyo ixim pan, yakꞌni Comam ixim tet ebnaj iscuywom, yoc ebnaj yitxkꞌanoto ixim yin̈ anma; yitxkꞌanpaxto ebnaj noꞌ cacꞌon̈ cay yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sunil anma waꞌi hantaticꞌa caw yoche iscꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hayet lahwi iswaꞌcanilo sunil anma tuꞌ, yoc ebnaj iscuywom Comam iscutxbanocan̈ ixim pan yeb noꞌ cay matxa lahwi yu anma; caw xin cablahon̈ebto motx nohcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Howeb mil ebnaj waꞌ yu Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lahwi tuꞌ ischejnito Comam Jesús ebnaj iscuywom yul teꞌ barco, yun̈e isbabito ebnaj sata Comam bey con̈ob Betsaida iskꞌaxepicꞌto haꞌ lago tuꞌ, wal Comam xin cancano takꞌlo tet anma. ");
INSERT INTO jacNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lahwi tuꞌ isto Comam yin̈ iscꞌul huneꞌ won̈an yu istxahli. ");
INSERT INTO jacNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Haxa yet yah akꞌbal xin yictabalxa haꞌ ayco teꞌ barco tuꞌ, wal Comam aytocano yin̈ iscꞌul huneꞌ won̈an tuꞌ ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yilnito Comam tato caw yaꞌta chakꞌle ebnaj iscuywom tuꞌ ismakꞌni haꞌ yu yinicꞌo teꞌ barco tuꞌ yiban̈ ha haꞌ, yuto caw ay yip istit jakꞌekꞌ sata teꞌ barco tuꞌ. Haxa yet lan̈anxa issajbilo xin isto Comam istzujnoyo ebnaj, isbelwito Comam yiban̈ haꞌ, yajaꞌ isyelo Comam hacaꞌtan̈e palan̈ yecꞌto Comam sata ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Hayet yilni ebnaj isbelwi Comam yiban̈ ha haꞌ tuꞌ, ispixanmi camom yalni ebnaj, yuxin ah yaw ebnaj yin̈ caw ip. ");
INSERT INTO jacNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Caw sunil ebnaj ilni, isxiwcan̈ ebnaj, yajaꞌ yal Comam tet ebnaj: —¡Ayojab yip heyanma, mach chexxiwi yuto haninan! ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lahwi tuꞌ yahto Comam yul teꞌ barco, hayet ayxahto Comam yul teꞌ islin̈i yecꞌ jakꞌekꞌ, caw xin cꞌayilo iscꞌul ebnaj iscuywom Comam yilni huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Waxan̈ca yil ebnaj yet iswatxꞌen Comam huneꞌ cꞌaybalcꞌule yin̈ ixim pan, yajaꞌ xin machi txumchalo yu ebnaj, yuto maẍto chihajcha isnabal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hayet iskꞌaxponicꞌto Comam Jesús yiban̈ haꞌ lago yeb ebnaj iscuywom, yapni Comam yul ismajul Genesaret, isxecbancano ebnaj isbarco istiꞌ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yet yelti Comam yeb ebnaj iscuywom yul teꞌ barco yohtan̈enilo anma ta haꞌ Comam apni bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Caw xin sunil yul ismajul huneꞌ con̈ob tuꞌ pujbalaxicꞌoj ta apni Comam. Hayet yabenilo anma bay ay Comam yinito anma macta yaꞌay sat batxteꞌ iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sunil aldea yeb con̈ob yeb bay pujanto yatut anma bay ecꞌ Comam, yilaxilti anma yaꞌay yulaj calle bay chiecꞌto Comam tuꞌ, chiskꞌanni anma tet Comam ta chistzab anma yaꞌay tuꞌ Comam, waxan̈ca han̈e istiꞌ xil iskꞌap Comam chistzaba. Sunil anma tzabni Comam tuꞌ cawxicanocan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ay xin huntekꞌan ebnaj fariseo yeb ebnaj cuywawom yin̈ isley naj Moisés apni iscꞌatan̈ Comam Jesús, ispeto ebnaj bey Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hayet yilni ebnaj tato ay ebnaj iscuywom Comam mach chistxꞌah iskꞌab yet chioc waꞌoj hacaꞌ yalni iscuybanil yichmam ebnaj; yichico ebnaj isbuchwa yin̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Haꞌ ebnaj fariseo yeb sunil anma Israel caw chisyije ischejbanil yichmam, yuto ta mach chistxꞌah iskꞌab ebnaj mach chiwaꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hacpax tuꞌ yet chimeltzo ebnaj yul txꞌon̈bal, mach chiwaꞌ ebnaj ta mach chistxꞌah ebnaj iskꞌab babel. Caw txꞌiꞌalto tzet chisyije ebnaj, hacaꞌ istxꞌahni ebnaj isvaso, isẍalu, yeb huntekꞌan chꞌen xi, cat istxꞌahnipaxo ebnaj istxꞌat. ");
INSERT INTO jacNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yuxin iskꞌambe ebnaj fariseo yeb ebnaj cuywawom yin̈ isley naj Moisés tet Comam: —¿Tzet yin̈ xin mach chisyije ebnaj hacuywom tiꞌ ischejbanil ebnaj jichmam, yuto mach chissajn̈e ebnaj iskꞌab yet chioc waꞌoj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Istakꞌwi Comam tet ebnaj: —Caw cꞌul hexmi heyalni, teyin̈ halbilcano yu naj Isaías, yet yalnicano naj: Huntekꞌan anma tiꞌ istiꞌn̈e chinakꞌni binahojan, wal yanma xin nahat yehilo win̈an. ");
INSERT INTO jacNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nabn̈e chala ta chiyiyo isba wetan, wal xin han̈cꞌan̈e ischejbanil ebnaj winaj chakꞌ ebnaj iscuyu yet anmahil, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Hex tiꞌ xaheyahcano chejbanile akꞌbil teyet yu Comam Dios yu heyijento chejbanile yet ebnaj payat ichmame. ");
INSERT INTO jacNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Caw sakꞌal heyijen chejbanile yet ebnaj payat ichmame tuꞌ, wal chejbanile akꞌbil teyet yu Comam Dios xin, xahenahuln̈ecantoj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tzꞌibn̈ebilcano yu naj Moisés hacaꞌ tiꞌ: “Xahan chawil hamam, hamiꞌ, yuto haꞌ mac chalni tzotiꞌ txꞌoj yin̈ ismam ismiꞌ, makꞌbil iscami,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yajaꞌ hex tiꞌ cheyala ta chu yalni hunu mac tet ismam yeb tet ismiꞌ hacaꞌ tiꞌ: “Mach chu incolwahan teyin̈ yuto haꞌ tzet ayintiꞌan, yetxa Comam Dios ye wuhan,” ta ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Cheyala ta matxa yilalo chicolwa yin̈ ismam yeb ismiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hac tuꞌ chu heyintan̈encanilto ischejbanil Comam Dios cat heyijen ischejbanil ebnaj jichmam tuꞌ, yajaꞌ maẍn̈etaj tuꞌ, wal xin ayto huntekꞌanxa tzet hacaꞌ tuꞌ cheyijepaxoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lahwi tuꞌ yawtenti Comam anma tenanto iscawilal tuꞌ, yalni Comam xin: —Cam txumwelo yin̈ tzet chiwaltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Maẍtaj haꞌ tzet chelo chexetanto yul sat Comam Dios, wal xin haꞌ istxꞌojal chitit yul heyanma haꞌ chexetanto yul sat Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Maquex cheyabe huneꞌ tiꞌ, akꞌwe heyanma hetxumniloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lahwi tuꞌ xin, yel Comam Jesús xol anma, isto Comam yul n̈a bayticꞌa aya. Haxa yet ay Comam bey tuꞌ, iskꞌamben ebnaj iscuywom Comam tet: —Mamin, ¿tzet chal yelapno huneꞌ yechel maxawal tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Istakꞌwi Comam: —¿Tom haꞌ hunex mach maxetxum yin̈ tzet mawaltuꞌan? ¿Tom mach chetxumu tato sunil tzet chicolo mach chon̈yetato yul sat Comam Dios, ");
INSERT INTO jacNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","yuto mach yulo janma chiapni, to yul cocꞌul chiapni, lahwi tuꞌ xin cat yel jin̈? ẍi Comam. Haꞌ chal yelapno tuꞌ tato sunil tzet ye tuꞌ cꞌul coloni machi xin chon̈yetato yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yalnipaxo Comam tet ebnaj iscuywom tuꞌ: —Wal xin haꞌ istxꞌojal chitit yul yanma anma haꞌ chietanto yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yuto yin̈ yanma anma chipitzcꞌati isnani iswatxꞌen istxꞌojal hacaꞌ yixli, iswinajli, yelkꞌawi, ispotxꞌwahi, ");
INSERT INTO jacNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","maca mohyinaxa cat issayni hunuxa yetbi. Yin̈ yanma tuꞌ chipitzcꞌati yochenico hunu tzet ye tuꞌ yeb sunil istxꞌojal, yeb lekꞌtiꞌal, yeb iskꞌaycanico yin̈ istxꞌojal, yeb ischiwa iscꞌul yin̈ yet anmahil, yeb ishobnican̈ tzotiꞌ, yeb loloꞌal, yeb mach cꞌulo istxumni. ");
INSERT INTO jacNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sunil huntekꞌan tuꞌ yul yanma anma chipitzcꞌatij, haꞌ xin chietanto yanma anma yul sat Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lahwi tuꞌ, isto Comam Jesús yul ismajul con̈ob Tiro. Hayet yapni Comam bey tuꞌ, yocto Comam yul huneꞌ n̈a, machi xin yoche Comam tato chiabelaxiloj, yajaꞌ hunepn̈echꞌan abchalo yu anma tato apni Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ay xin huneꞌ ix ayco ischejab naj matzwalil yin̈ huneꞌ nichꞌan yunin. Hayet yaben ix ta apni Comam, isto ix iscꞌatan̈ Comam, yay jahno ix sata Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Huneꞌ ix ix tuꞌ mach Israelo ix, wal xin yul ismajul txꞌotxꞌ sirofenicia ay ix. Iskꞌanni ix tet Comam ta chílo Comam ischejab naj matzwalil ayco yin̈ nichꞌan yunin ix. ");
INSERT INTO jacNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yajaꞌ takꞌwi Comam tet ix, yalni Comam: —Waꞌojabcano ebnaj uninale babel, yuto mach cꞌuloj ta chiilaxilo tzet chislo ebnaj uninale cat yakꞌlax tet metx txꞌiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yalni ix tet Comam: —Yel Mamin, yajaꞌ metx txꞌiꞌ tuꞌ masanticꞌa chissicꞌcan̈ metx iskꞌal istiꞌ ebnaj uninale chiaycꞌay yalan̈ meẍa, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hayet yaben Comam yalni ix hacaꞌ tuꞌ, yalni Comam tet ix: —Caw haꞌ ye tzet maxawala, chisje hapaxtoj, maelna ischejab naj matzwalil tuꞌ yin̈ hawunin, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Haxa yet yapni ix yatut, hilanto ix nichꞌan tuꞌ sat txꞌat; xaelna ischejab naj matzwalil yin̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lahwi tuꞌ, yel Comam Jesús yul ismajul con̈ob Tiro, isto Comam yul ismajul con̈ob Sidón yeb yulaj con̈ob ayco yul ismajul Decápolis. Lahwi tuꞌ yapnicano Comam istiꞌ haꞌ lago Galilea. ");
INSERT INTO jacNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yilaxti huneꞌ naj mach chu yabeni yeb mach chu istzoteli iscꞌatan̈ Comam. Iskꞌanni anma tet Comam tato chayo Comam iskꞌab yiban̈ iswiꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yinilo Comam naj xol anma, yanicto Comam yiximal iskꞌab yul istxiquin naj, lahwi tuꞌ istzublico Comam yin̈ yiximal iskꞌab, yanayo Comam yiban̈ yakꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Istꞌan̈xican̈ Comam satcan̈, yah iscꞌul, yalni Comam hacaꞌ tiꞌ: —Efata, ẍi Comam. Haꞌ chalilo huneꞌ tuꞌ Hajlojabi. ");
INSERT INTO jacNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yaln̈ena Comam huneꞌ tuꞌ xin, ishajlo istxiquin naj. Iswatxꞌipaxilo yakꞌ naj, istzotelcan̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yalnicano Comam tet anma tato machi bay chihallaxicꞌo huneꞌ tuꞌ, yajaꞌ yet iscachni Comam anma tuꞌ caw ecꞌbalto ispujbacꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hayet yaben anma huneꞌ tuꞌ caw cꞌayilo iscꞌul, yalni anma: —Sunil tzet chiswatxꞌe Comam cꞌul chielicoj, chakꞌ hajlo Comam istxiquin ebnaj mach chabe, cat yakꞌni tzotelo Comam mac maẍticꞌa chu istzoteli, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yin̈ huneꞌ tzꞌayic tuꞌ, caw hantan̈e anma cutxanico iscꞌatan̈ Comam Jesús, matxa xin tzet chislo anma, yuxin yawte Comam ebnaj iscuywom, yalni Comam: ");
INSERT INTO jacNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Caw chitzꞌay incꞌulan yin̈ anma tiꞌ, yuto oxebxa tzꞌayic aycꞌo incꞌatan̈an, matxa xin tzet chislo. ");
INSERT INTO jacNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yaj ta chinchejtojan anma tiꞌ yatut, machi xin chiwaꞌi, ay ismay ispax yip yulaj beh yu n̈ohchahilal, yuto ay anma caw nahat aya, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Istakꞌwi ebnaj iscuywom Comam tuꞌ, yalni ebnaj: —¿Tzet xin chu jakꞌni waꞌo anma tiꞌ hawalni, yuto bay ayon̈ tiꞌ machi teꞌ n̈a? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iskꞌamben Comam tet ebnaj: —¿Hayeb ixim pan ay texol? ẍi Comam. Istakꞌwi ebnaj: —Hujeb, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ischejni Comam tato chiay tzꞌon̈no anma sat txꞌotxꞌ. Yinican̈ Comam ixim hujeb pan tuꞌ, yakꞌni Comam yuchꞌandiosal tet Comam Dios yin̈ ixim. Lahwi tuꞌ xin iskꞌaxponayo Comam ixim, yakꞌni Comam ixim tet ebnaj iscuywom, yoc ebnaj yitxkꞌanoto ixim yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aypaxo xin haycꞌon̈ noꞌ niẍte cay ikꞌbil yu ebnaj. Yakꞌnipaxo Comam Jesús yuchꞌandiosal yin̈ noꞌ tet Comam Dios, lahwi tuꞌ yalni Comam tet ebnaj iscuywom tuꞌ tato chiyitxkꞌapaxto ebnaj noꞌ yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sunil anma waꞌi, caw nohcano iscꞌul. Caw xin hujebto motx nohcanocan̈ yu ixim pan yeb noꞌ cay matxa lahwi yu anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Anma waꞌ tuꞌ aymi can̈ebo mil. Istakꞌlicano Comam tet anma, ");
INSERT INTO jacNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","lahwi tuꞌ xin yahto Comam yul huneꞌ teꞌ barco yeb ebnaj iscuywom, isto Comam yul ismajul Dalmanuta. ");
INSERT INTO jacNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ay xin huntekꞌan ebnaj fariseo apni iscꞌatan̈ Comam Jesús, yoc ebnaj buchwal yin̈ Comam. Yajaꞌ yun̈e yilwen ebnaj Comam yuxin oc ebnaj iskꞌanaꞌ ta chisye Comam hunu cꞌaybalcꞌule chiyeniloj tato yeli ischejab Comam Dios ye Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yah iscꞌul Comam Jesús, yalni Comam hacaꞌ tiꞌ: —¿Tzet yin̈ xin chiskꞌan huntekꞌan anma tiꞌ yechel yip Comam Dios yilaꞌ? Yin̈ caw isyelal chiwalan tato machi hunu tzet chiyelax tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yel Comam iscꞌatan̈ ebnaj fariseo tuꞌ, yahto Comam yul teꞌ barco hunelxa yeb ebnaj iscuywom, isto Comam iskꞌaxepicꞌto haꞌ lago. ");
INSERT INTO jacNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wal ebnaj iscuywom Comam tuꞌ to nahul yu ebnaj yinito tzet chislo yul teꞌ barco, huneꞌn̈e ixim pan ikꞌbil yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yalni Comam tet ebnaj: —Abewe tzet chiwalan, caw cheyilwe heba tet yan̈al ispan ebnaj fariseo yeb naj Herodes, tajca chexetaxto yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yoc ebnaj tzotelo yiban̈ilo huneꞌ tuꞌ, chalni ebnaj: —Yumi machi ixim pan ikꞌbil ju, yuxin chal Comam hacaꞌ tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yohtan̈enilo Comam yin̈ tzet chal ebnaj, yalni Comam: —¿Tzet yin̈ xin cheyala tato machi pan ikꞌbil heyu? ¿Tom maẍto chexkꞌoji hetxumniloj yeb maẍto cheyohtan̈eloj? Caw cawto henabal. ");
INSERT INTO jacNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ay isbakꞌ hesat yaj mach cheyila, ay hetxiquin yaj mach cheyabe. ¿Tom xin mach chitit yul hecꞌul? ");
INSERT INTO jacNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yet witxkꞌantojan ixim howeb pan yin̈ howeb mil anma, ¿hayebto motx ixim matxa lahwi yu anma hecutxbacan̈? ẍi Comam. Istakꞌwi ebnaj: —Cablahon̈eb motx ixim, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yalnipaxo Comam: —Haxapaxo yet witxkꞌantojan ixim hujeb pan yin̈ can̈eb mil anma, ¿hantato ixim matxa lahwi yu anma? ẍi Comam. —Hujeb motx ixim, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yalnipaxo Comam tet ebnaj: —¿Tom maẍtoticꞌa chitxumcha nichꞌano heyu? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lahwi tuꞌ xin yapni Comam yeb ebnaj iscuywom yul con̈ob Betsaida. Yilaxti huneꞌ naj mutzꞌan sat tet Comam, iskꞌanni anma tet Comam ta chayo iskꞌab yiban̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yoc tzabno Comam yin̈ iskꞌab naj, isxecnito Comam naj istxam con̈ob, yanico Comam istzub yin̈ isbakꞌsat naj, yanayo Comam iskꞌab yiban̈ naj, lahwi tuꞌ xin iskꞌamben Comam tet naj ta xayu yilni naj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yichico naj yilni, yalni naj tet Comam: —Chiwilan yecꞌ anma, hacaꞌ te teꞌ chu wilnihan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yanico Comam iskꞌab yin̈ sat naj hunelxa, caw iswatxꞌilo yilni naj, xin habanxa yilni naj sunil tzet ye tuꞌ cawil yeb nahat. ");
INSERT INTO jacNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ischejnitopaxo Comam naj yatut, yalni Comam: —Matxa chaẍecꞌ yul con̈ob tiꞌ, wal xin beh hatohi, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lahwi tuꞌ xin, isto Comam yeb ebnaj iscuywom yulaj aldea ayco yul ismajul txꞌotxꞌ Cesarea Filipo. Hayet ayco Comam yin̈ isbel yeb ebnaj iscuywom tuꞌ, iskꞌamben Comam tet ebnaj: —¿Mac anmahilinan yalni anma? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Istakꞌwi ebnaj tet Comam: —Ay mac chalni tato hach tiꞌ naj Juan anican̈ haꞌ iswiꞌ anma, aypaxo mac chalni tato Elías hach, maca hunu ischejab Comam Dios ecꞌlena yet payat, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iskꞌambenpaxo Comam tet ebnaj: —Haxaca hex tiꞌ, ¿mac anmahilinan heyalni? ẍi Comam. Istakꞌwi naj Pedro tet Comam hacaꞌ tiꞌ: —Hach ton tiꞌ Cristo, echmabil yuli, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yalni Comam tato machi bay chalicꞌo ebnaj huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lahwi tuꞌ xin yichico Comam yalni tet ebnaj iscuywom: —Wal Hanin Akꞌbilintijan texol yu Comam Dios caw yilal yecꞌyaꞌ wanmahan, cat quinyintan̈encaniltojan ebnaj ichamta winaj iswiꞌehal con̈ob Israel, yeb ebnaj yahawil yin̈ ebnaj sacerdote, yeb ebnaj cuywawom yin̈ isley naj Moisés. Chinyakꞌ camojan ebnaj, yajaꞌ yin̈ yox tzꞌayic xin cat witzitzbican̈an hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Caw yalcano Comam yin̈ caw haban tet ebnaj. Hayet yaben naj Pedro huneꞌ tuꞌ, yinilo naj Comam ischuquil, yoc naj iscachno Comam yin̈ huneꞌ yal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ismeltzo Comam, yoc tꞌan̈no yin̈ ebnaj iscuywom, yoc Comam iscachno naj Pedro, yalni Comam: —¡Hach matzwalil, elan̈ yin̈ insatan! Yuto hach tiꞌ maẍtaj tzet nabil yu Comam Dios chꞌecꞌ yin̈ hanabal, walxinto hatzet chisna anma, haꞌ chiecꞌ yin̈ hanabal, ẍi Comam tet naj Pedro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lahwi tuꞌ xin, yawtenti Comam ebnaj iscuywom yeb anma wejanto tuꞌ, yalni Comam: —Tato ay hunu mac choche chioc incuywomojan, caw yilal matxa yeto isba ischuquil, caw hinanojab yaben isyaꞌtajil, waxan̈ca chialaxcan̈ yin̈ culus. Haꞌ mac chishin isba tuꞌ haꞌ choc incuywomojan. ");
INSERT INTO jacNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yuto haꞌ mac ay yalaꞌ mach chiscꞌayto iscawil win̈an yul sat yiban̈kꞌinal tiꞌ chiscꞌayto iskꞌinal mach istan̈bal. Wal mac hinan yakꞌni camo isba win̈an yeb yu Tzotiꞌ cꞌul yet colbanile, chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kꞌinaloj ta ay hunu mac chikꞌoji ismajnicꞌo sunil tzet ay yul sat yiban̈kꞌinal tiꞌ, yajaꞌ ta chiscꞌayto iskꞌinal mach istan̈bal, ");
INSERT INTO jacNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿tzettaxca chischah selelo iskꞌinal chiscꞌayto tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yuxin ta ay mac chitxꞌixwi win̈an, yeb yalni intzotiꞌan yin̈ sat huntekꞌan anma txꞌoj tiꞌ yeb mach ohtan̈e Comam Dios, haquinpaxtuꞌan Hanin Akꞌbilintijan texol yu Comam Dios, chintxꞌixwipaxilojan yin̈ yet chinhulan yeb iskꞌakꞌal yip Inmaman, yeb ebnaj yángel Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yalnipaxo Comam: —Yin̈ caw yeli chiwalan teyet, ay haywan̈ mac texol hex tiꞌ, maẍto chicami masanto chil yoc Comam Dios Yahawiloj, yeb sunil yip, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iswajxa tzꞌayic xin, isto Comam Jesús yin̈ iswiꞌ huneꞌ witz nahat yecan̈, han̈e xin naj Pedro, naj Jacobo yeb naj Juan yito Comam yintaj, haꞌ bey tuꞌ xin ishel isba yillax Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cawxan̈e chitzejla xil iskꞌap Comam, caw sajhopon̈e elicoj. Machi hunu ix txꞌahwom chisajn̈en hunu xilkꞌape hacaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yin̈n̈ena tuꞌ yilni ebnaj iscuywom Comam naj Elías yeb naj Moisés; tzotelo chu ebnaj yeb Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yalni naj Pedro tet Comam: —Mam cuywawom, caw sakꞌal je bey tiꞌ, wal xin chicowatxꞌecan̈an̈ oxebo pat; hunu hawet, hunu yet naj Moisés yeb hunu yet naj Elías, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Caw xiw ebnaj iscuywom Comam tuꞌ, yuxin matxa chitxumcha yu naj Pedro yin̈ tzet chute yalni, yuxin yal naj hacaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lahwi tuꞌ yayilo huneꞌ moyan yiban̈ ebnaj, yaben ebnaj huneꞌ yul nukꞌe xol moyan tuꞌ, yalni hacaꞌ tiꞌ: —Haꞌ naj tiꞌ Incꞌaholan caw xahan ay wuhan, abewe tzet chal naj, ẍi. ");
INSERT INTO jacNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Haxa yet yecꞌ tꞌan̈tꞌon ebnaj xin, yilni ebnaj tato haxan̈e Comam aycꞌoj, matxa ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hayet lan̈an ispaxayti Comam yin̈ iswiꞌ witz yeb ebnaj oxwan̈ tuꞌ, yalni Comam tet ebnaj: —Machi mac tet cheyal huneꞌ maxeyil tuꞌ, wal xin haꞌ to yet chinitzitzbican̈an xol camom, Hanin Akꞌbilintijan texol yu Comam Dios catto heyalni, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yuxin machi mac tet bay yal ebnaj huneꞌ tuꞌ, yajaꞌ xin iskꞌambele ebnaj tet hunun yin̈ tzet chal yelapno yet chiitzitzbican̈ Comam xol camom. ");
INSERT INTO jacNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yoc ebnaj iskꞌambeno tet Comam: —¿Tzet yin̈ xin chal ebnaj cuywawom yin̈ isley naj Moisés tato naj Elías chul babel sata naj Cristo? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Istakꞌwi Comam: —Yeltoni, haꞌ naj Elías tuꞌ babel chuli, yun̈e isnani isba anma cat yoc yin̈ istoholal. Yajaꞌ, ¿tzet tzꞌibn̈ebilcano win̈an, Hanin Akꞌbilintijan texol yu Comam Dios? Tzꞌibn̈ebilcanoj tato caw yilal yecꞌyaꞌ wanmahan, cat wintan̈elaxcaniltojan yu anma. ");
INSERT INTO jacNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yajaꞌ chiwalan teyet ta naj Elías tuꞌ xahulicꞌo naj, yaj iswatxꞌe anma istxꞌojal yin̈ naj hacaꞌ yoche iscꞌul, hacaꞌ tzet tzꞌibn̈ebilcano yul Yum Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Haxa yet yayilo Comam Jesús yeb ebnaj oxwan̈ iscꞌatan̈ huntekꞌanxa ebnaj iscuywom, yilni Comam tato caw hantan̈e anma hoyanico yin̈ ebnaj; ay huntekꞌan ebnaj cuywawom yin̈ isley naj Moisés ayco isteyeleno isba yeb ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hayet yilni anma yapni Comam, caw cꞌayilo iscꞌul, isto anma yin̈ an̈e iscꞌatan̈ Comam, istioẍli anma tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iskꞌamben Comam tet ebnaj: —¿Baytet yin̈ lan̈an heteyelen heba? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Istakꞌwi huneꞌ naj xol anma tuꞌ, yalni naj: —Mam cuywawom, mawitijan nichꞌan incꞌaholan tawet, ay huneꞌ ischejab naj matzwalil ayco yin̈ naj, yuxin mach chu istzotel naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hunta el chilow yin̈ naj yu naj matzwalil tuꞌ, caw chitzicobtan̈elax naj, cat istit hujuy yul istiꞌ naj, yeb xin caw chin̈etxꞌla yeh naj cat iscawyan̈ilo naj. Mankꞌanan tet ebnaj hacuywom tiꞌ tato chílo ebnaj ischejab naj matzwalil yin̈ incꞌaholtiꞌan, yajaꞌ mach yu yu ebnaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Istakꞌwi Comam: —Hex tiꞌ, caw mach cheyaco heyanma yin̈ Comam Dios, caw nimanxa tiempo ayinicꞌojan texol, ¿hantatocꞌanab tiempo chextecha wuhan? Iweti naj nichꞌan tuꞌ bey tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yilaxto naj sata Comam, hayet yilni ischejab naj matzwalil tuꞌ Comam, yichico islow huneꞌ yaxcamic tuꞌ yin̈ naj, istirlaxayo naj sat txꞌotxꞌ, yichico naj yecꞌ balboni, istit hujuy yul istiꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iskꞌamben Comam tet naj mame tuꞌ: —¿Bakꞌintax tzabloti naj nichꞌan tzeh tiꞌ? ẍi Comam. Istakꞌwi naj: —Yettax caw nichꞌanto naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Caw txꞌiꞌalxa el chito naj yul kꞌaꞌ yeb xol ha haꞌ yu ischejab naj matzwalil yun̈e iscam naj. Yajaꞌ ta chu hawu, colwahan̈ ninoj, caw tzꞌayojab hacꞌul jin̈an̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yalni Comam tet naj: —Tato chawayto yul hawanma, chuhi, yuto sunil mac chianayto yul yanma yin̈ Comam Dios sunil tzet chiskꞌana chij isba, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yet yaben naj mame huneꞌ tuꞌ yah yaw naj yin̈ caw ip, yalni naj: —Chiwaytojan yul wanmahan, yajaꞌ colwahan̈ win̈an haxinwal chikꞌ yip wanico wanmahan yin̈ Comam Dios, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hayet yilni Comam tato caw hantan̈e anma iscutxbaco isba iscꞌatan̈, ischejnilo Comam ischejab naj matzwalil yin̈ naj nichꞌan tzeh tuꞌ, yalni Comam: —Ach ischejab naj matzwalil, akꞌom sucbo anma, yeb hawu yuxin mach chabe naj nichꞌan tzeh tiꞌ, haninan chiwalan tawet, elan̈ yin̈ naj, matxa chachmeltzo hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yah yaw ischejab naj matzwalil tuꞌ yin̈ caw ip, islow huneꞌ yaxcamic yin̈ naj nichꞌan tzeh tuꞌ, yelcano ischejab naj matzwalil yin̈ naj. Hacaꞌ camom yucanilo naj, yuxin txꞌiꞌal mac txumni ta cam naj yin̈ huneln̈e. ");
INSERT INTO jacNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wal Comam Jesús xin oc tzabno Comam yin̈ iskꞌab naj, isxecnican̈ Comam naj, yah lin̈no naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lahwi tuꞌ, yocto Comam Jesús yul huneꞌ n̈a yeb ebnaj iscuywom. Haxa yet ischuquilxan̈e ebnaj yeb Comam xin, iskꞌamben ebnaj tet Comam: —Mamin, ¿tzet yin̈ mach yu jinilojan̈ ischejab naj matzwalil yin̈ naj nichꞌan tzeh tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Istakꞌwi Comam: —Huntekꞌan ischejab naj matzwalil hacaꞌ tiꞌ, mach chiel ebnaj ta mach chextxahli, yeb ta mach cheyije huneꞌ yet mach chexwaꞌ yu hetxahli tet Comam Dios, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lahwi tuꞌ xin, yel Comam Jesús bey tuꞌ, yapni yul ismajul Galilea, machi xin choche Comam tato chiabelaxiloj ta apni bey tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yuto ayco Comam yakꞌno cuybanil tet ebnaj iscuywom yin̈ iscamical, yalni Comam: —Hanin Akꞌbilintijan texol yu Comam Dios chinalaxicojan yul iskꞌab anma cat inpotxꞌlax camojan, yaj yin̈xa yox tzꞌayic incamtuꞌan cat witzitzbipaxocan̈an hunelxa, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yajaꞌ machi txumcha yu ebnaj yin̈ tzet yal Comam, chixiwpaxo ebnaj iskꞌamben tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lahwi tuꞌ xin, yapni Comam Jesús yeb ebnaj iscuywom yul con̈ob Capernaum. Haxa yet ayxa Comam yul n̈a bayticꞌa chicani, iskꞌamben Comam tet ebnaj: —¿Baytet yin̈ heteyele heba yet ayon̈ico yin̈ cobel? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yajaꞌ maẍticꞌa takꞌwi ebnaj tet Comam yuto isteyele isba ebnaj yin̈ mac ecꞌbal yelapno ye xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yay tzꞌon̈no Comam, yawtenti Comam ebnaj cablahon̈wan̈ tuꞌ iscꞌatan̈, yalni Comam: —Tato ay hunu mac choche chioc iswiꞌehalo texol, yuteojab isba hacaꞌ hunu mac islahobalxa yehi, cat yoc chejaboj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lahwi tuꞌ xin yanico Comam nichꞌan unin xolbal ebnaj, ischelnican̈ Comam, yalni hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Macn̈eticꞌa chichahni hunu nichꞌan unin yuto wetan yehi, haninan chinischahan. Haꞌ mac chinchahnipaxojan xin maẍn̈etajinan chinischahan, to chischahpaxo Mac an̈eintijan, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yalni naj Juan tet Comam: —Mam cuywawom, jilan̈ yinilo huneꞌ naj ischejab naj matzwalil yin̈ anma yin̈ habi, yajaꞌ cocachan̈ naj yuto mach jetbiho naj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Istakꞌwi Comam tet naj: —Mach checach naj, yuto machi hunu mac lahwi iswatxꞌen hunu cꞌaybalcꞌule yin̈ inbihan cat yoc yalnopaxo tzotiꞌ txꞌoj win̈an. ");
INSERT INTO jacNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Haꞌ mac mach chichiwa iscꞌul jin̈, ayco jetbihoj. ");
INSERT INTO jacNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yin̈ caw isyelal chiwalan macxan̈eticꞌa chiakꞌni hunu vaso haꞌ teyet yu ayexico yul inkꞌaban, chiakꞌlax ispaj selel tet huneꞌ mac tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yalnipaxo Comam Jesús: —Macn̈eticꞌa chiakꞌni aycꞌayo hunu mac uninto yanico isba yul inkꞌaban, huneꞌ mac tuꞌ cꞌul iscꞌallaxico hunu niman ischꞌenal chꞌen molino yin̈ isnukꞌ, cat istirlaxto xol haꞌ mar. ");
INSERT INTO jacNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yuxin tato yu hekꞌab xin chexaycꞌay yin̈ istxꞌojal, cꞌul ta chetzoqꞌuiltoj. Yuto ecꞌbalto cꞌul ta matxa huneꞌ hekꞌab yet chechahni hekꞌinal mach istan̈bal sata iscabil hekꞌab aycoj, cat hekꞌojlaxto xol kꞌa kꞌaꞌ mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Bey tuꞌ xin maẍticꞌa chicam noꞌ hahaꞌ, maẍticꞌa chitan̈paxo kꞌa kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Maca xin ta heyoj chexakꞌni aycꞌayo yin̈ istxꞌojal, chetzoqꞌuiltoj. Yuto ecꞌbalto cꞌul ta huneꞌn̈e heyoj ayco yet chechahni hekꞌinal mach istan̈bal, sata ta chexkꞌojlaxto xol kꞌa kꞌaꞌ mach istan̈bal yeb iscabil heyoj, ");
INSERT INTO jacNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","bay matxaticꞌa chicam noꞌ hahaꞌ yeb bay matxaticꞌa chitan̈ kꞌa kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yajaꞌ ta xin isbakꞌ hesat chexakꞌni aycꞌayo yin̈ istxꞌojal, cꞌul ta cheyiltij yuto ecꞌbalto cꞌul waxan̈ca hunxan̈e isbakꞌ hesat yet chechahni hekꞌinal mach istan̈bal, sata heyalaxto xol kꞌa kꞌaꞌ mach istan̈bal yeb iscabil isbakꞌ hesat, ");
INSERT INTO jacNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","bay maẍticꞌa chicam noꞌ hahaꞌ, yeb bay maẍticꞌa chitan̈ kꞌa kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yuto hacaꞌ yoc atzꞌam atzꞌam yin̈ xahanbal, hac tuꞌ yoc kꞌa kꞌaꞌ yin̈ sunil anma. ");
INSERT INTO jacNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Caw cꞌul atzꞌam atzꞌam, yajaꞌ ta chiel iscꞌachiꞌal atzꞌam, ¿tzettaxca chu ismeltzoco iscꞌachiꞌal hunelxa? Hacaꞌojab yakꞌni atzꞌam atzꞌam isxukꞌal hunu tzet ye tuꞌ, hacojab hex tuꞌ, yeb xin ayojab akꞌancꞌulal texol, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Lahwi tuꞌ, yel Comam Jesús yul con̈ob Capernaum, isto yul ismajul Judea yeb bey iskꞌaxepicꞌto haꞌ niman Jordán. Caw xin hantan̈e anma apni iscꞌatan̈ Comam, yoc Comam iscuyno anma tuꞌ hacaꞌticꞌa chuhi. ");
INSERT INTO jacNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ay xin huntekꞌan ebnaj fariseo apni ilweno Comam, iskꞌamben ebnaj tet Comam: —¿Chimyu ispohni isba hunu naj winaj yeb yixal? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Istakꞌwi Comam: —¿Tzet halbilcano teyet yu naj Moisés yin̈ huneꞌ tuꞌ? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Istakꞌwi ebnaj: —Halbilcano yu naj ta chisje ispohni isba hunu naj yeb yixal, yajaꞌ yilal yakꞌnicano naj hunu hum yet pohlebahil tet ix, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yalni Comam tet ebnaj: —Yu caw mach cheyabe yuxin akꞌbilcano huneꞌ chejbanil tuꞌ yu naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yajaꞌ yet iswatxꞌencano Comam Dios yul sat yiban̈kꞌinal tiꞌ, iswatxꞌe Comam naj winaj yeb ix ix. ");
INSERT INTO jacNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yalnicano Comam Dios ta chácano naj winaj ismam yeb ismiꞌ cat ishunban isba naj yeb yixal, ");
INSERT INTO jacNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hunxan̈e xin anmahil chucanoj. Hac tuꞌ xin matxa cawan̈o yehi, to hunxan̈e anmahil. ");
INSERT INTO jacNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yuxin haꞌ mac hunbabil yu Comam Dios, mach chu ispohni anma, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Haxa yet ayxa Comam yeb ebnaj iscuywom yul n̈a bayticꞌa chicani, yoc ebnaj iskꞌambeno tet Comam yin̈ tzet chalilo huneꞌ yal Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yalni Comam tet ebnaj: —Ta chispoh isba hunu naj yeb yixal cat yikꞌni naj hunuxa ix, chaco naj ismul tet yixal hacaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yajaꞌ ta xin ix ix chispoh isba yeb yichamil, cat yikꞌni ix hunuxa naj, chapaxico ix ismul, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ay xin huntekꞌan niẍte unin ilaxti tet Comam Jesús yu yanayo Comam iskꞌab yiban̈, yajaꞌ cachwa ebnaj iscuywom Comam yin̈ anma initi niẍte yunin tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hayet yilni Comam huneꞌ tuꞌ ishowbican̈ Comam yin̈ ebnaj, yalni Comam: —Mach checach istit niẍte unin tiꞌ incꞌatan̈an, tijabi yuto haꞌ mac chaco yanma yin̈ Comam Dios hacaꞌ yeco yanma niẍte unin yin̈ ismam ismiꞌ, haꞌ chioc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chiwalan yin̈ isyelal teyet; haꞌ mac mach chichahni Comam Dios Yahawiloj hacaꞌ ischahni nichꞌan unin hunu tzet ye tuꞌ, mach chu yoc yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yoc Comam ischelno niẍte unin tuꞌ, yanayo Comam iskꞌab yiban̈, iskꞌannicano Comam iscꞌulal Comam Dios yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Haxa yet lan̈an isto Comam Jesús yin̈ isbel xin, yapni huneꞌ naj yin̈ an̈e iscꞌatan̈ Comam, yay jahno naj sata Comam, iskꞌamben naj: —Mam cuywawom, hach tiꞌ caw cꞌulach, ¿tzet wal wuten inbahan yun̈e inchahnihan kꞌinale mach istan̈bal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yalni Comam tet naj: —¿Tzet yin̈ xin chinhawalan cꞌulal? Huneꞌn̈e mac cꞌul, haꞌ ton Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hawohtami huntekꞌan chejbanile chalni hacaꞌ tiꞌ: “Mach chachpotxꞌwahi, mach chachixli, mach chachelkꞌawi, mach chahobcan̈ tzotiꞌ yin̈ hawet anmahil, mach chawaco lekꞌtiꞌal, yeb xin ayojab yelapno hamam, hamiꞌ yul hasat, ¿hawohtami huntekꞌan tiꞌ?” ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Istakꞌwi naj tet Comam: —Mam cuywawom, sunil huntekꞌan tiꞌ chinyijehan yichitax inchꞌibtijan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Istꞌan̈xico Comam yin̈ naj yin̈ tzalahilal, yalni Comam: —Hunxan̈e tzet maẍto chayije; as txon̈to sunil tzet ayach cat hawitxkꞌanto istohol yin̈ anma mebaꞌ, haxinwal ay hakꞌalomal satcan̈, lahwi tuꞌ xin cat hawoc tzujno wintajan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hayet yaben naj huneꞌ tuꞌ caw txꞌoj yuco yin̈ yanma naj yu biscꞌulal yuto caw kꞌalomcano naj sicꞌlebil, ispaxto naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yecꞌ tꞌan̈tꞌon Comam yin̈ ebnaj iscuywom, yalni Comam: —Tzet isyaꞌtajil yoc anma kꞌalom yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Caw cꞌaycan̈ iscꞌul ebnaj iscuywom Comam yaben huneꞌ tuꞌ, yuxinto yalpaxo Comam tet ebnaj: —Hex xahan ay wutiꞌan, haꞌ anma chaco yanma yin̈ kꞌalomal caw yaꞌta yoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kꞌinalo hunu noꞌ camello tinan̈, ¿tom subuta yecꞌto noꞌ yul isholanil hunu chꞌen acꞌuxa? Hac tuꞌ ye anma kꞌalom, caw yaꞌta yoc yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hayet yaben ebnaj huneꞌ tuꞌ, caw ecꞌbalto cꞌayilo iscꞌul ebnaj, yalni ebnaj tet hunun: —Ta hac tuꞌ, ¿mactaxca chu iscolchahi? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Istꞌan̈xico Comam yin̈ ebnaj, yalni Comam: —Yul sat anma caw yaꞌta huneꞌ tuꞌ, wal yul sat Comam Dios mach yaꞌtajoj, yuto machi hunu tzet ye tuꞌ tiꞌ mach chu iswatxꞌen Comam, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yalni naj Pedro tet Comam: —Mamin, sunil tzet ayon̈an̈ bejbilcano juhan̈ yu joccano tzujnojan̈ tawintaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Istakꞌwi Comam: —Yin̈ caw isyelal chiwalan teyet; macn̈eticꞌa chisbejcano yatut, yuẍtaj, ismam, ismiꞌ, yuninal maca istxꞌotxꞌ yu yoc tzujno wintajan yeb yu Tzotiꞌ cꞌul yet colbanile, ");
INSERT INTO jacNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","huneꞌ mac tuꞌ chiakꞌlax ispaj selel tet yul sat yiban̈kꞌinal tiꞌ; hocꞌal el to chiakꞌlax ispaj selel yatut, yuẍtaj, yanab, ismiꞌ yeb istxꞌotxꞌ, waxan̈ca xin chiakꞌlax ecꞌoyaꞌ yanma. Haxa yin̈ huneꞌ tiempohal maẍto chihuli chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yuxin haꞌ mac caw ay yelapno ye tinan̈, matxa yelapno chielicoj, wal mac machi yelapno xin, haꞌ caw ecꞌbal yelapno chielcanicoj, ẍi Comam tet ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hayet ayco Comam Jesús yin̈ isbel bey Jerusalén, babelico Comam sata ebnaj iscuywom, caw xin chicꞌay iscꞌul ebnaj, wal anma tzujanpaxico xin caw chixiwi. Yawtenilo Comam ebnaj cablahon̈wan̈ iscuywom ischuquil, yoc Comam yalno tet ebnaj yin̈ tzet chihul yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yalni Comam: —Tinan̈, lan̈an coto bey Jerusalén, Hanin Akꞌbilintijan texol yu Comam Dios tiꞌ, chinalaxicojan yul iskꞌab ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés, chiscawxeco ebnaj camical wiban̈an cat quinyanicojan ebnaj yul iskꞌab ebnaj mach Israeloj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Haxa ebnaj tuꞌ xin chioc tzebo win̈an, cat istzublico win̈an, cat xin quinismakꞌnihan ebnaj. Lahwi tuꞌ cat quinyakꞌnicamojan ebnaj, yajaꞌ yin̈ yox tzꞌayic xin cat witzitzbican̈an hunelxa, ẍi Comam tet ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hitzico naj Juan yeb naj Jacobo iscꞌatan̈ Comam Jesús, ebnaj iscꞌahol icham Zebedeo, yalni ebnaj tet Comam: —Mam cuywawom, ay huneꞌ tzet chicokꞌanan̈ tawet, yajaꞌ chijochehan̈ chawakꞌ jetan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iskꞌamben Comam: —¿Tzet xin cheyoche? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yalni ebnaj: —Estam chaje chon̈oc tzꞌon̈nojan̈ tacꞌatan̈ yet chachoc Yahawil, hunujon̈an̈ yin̈ hawatxꞌkꞌab, hunuxahon̈paxojan̈ yin̈ hameckꞌab, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Istakꞌwi Comam: —Hex tiꞌ, mach heyohtajo tzet chekꞌana. ¿Chimyu heyucꞌni huneꞌ vaso cꞌahla haꞌ, hacaꞌ chiakꞌlax wucꞌuꞌan? yeb ¿tom chitecha huneꞌ niman isyaꞌtajil heyu hacaꞌ huneꞌ bay chinecꞌojan, hacaꞌ yahbal haꞌ cowiꞌ? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Istakꞌwi ebnaj cawan̈ tuꞌ: —Hoꞌ, chitecha juhan̈, ẍi ebnaj. Yalni Comam: —Yeltoni chu heyucꞌni huneꞌ cꞌahla haꞌ chiwaltuꞌan, yeb chitecha isyaꞌtajil heyu hacaꞌ huneꞌ chihul wiban̈an, hacaꞌ yahbalo haꞌ cowiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yajaꞌ wal heyoc tzꞌon̈no yin̈ inwatxꞌkꞌaban yeb yin̈ inmeckꞌaban, mach chu walnihan teyet, wal xin watxꞌebil tet mac yetxaticꞌa yehi, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hayet yaben ebnaj lahon̈wan̈xa huneꞌ tuꞌ, istit ishowal ebnaj yin̈ naj Juan yeb naj Jacobo. ");
INSERT INTO jacNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yawtenti Comam ebnaj sunil, yalni Comam: —Caw heyohta hex tiꞌ tato ebnaj ayco yahawilo yin̈ txꞌotxꞌ nime con̈ob, caw yahawilxa chute isba ebnaj. Hacpax tuꞌ ebnaj caw aycano yelapno yulaj con̈ob, caw ay yip ebnaj yiban̈ej anma. ");
INSERT INTO jacNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yajaꞌ wal texol hex tiꞌ, mach haco tuꞌ cheyute, wal xin tato ay hunujex cheyoche ay yelapno cheyuco xol ebnaj heyetbi, aweco heba chejaboj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yeb xin ta ay hunu mac choche chioc iswiꞌehalo texol, yakꞌabico isba hechejaboj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yuto Hanin Akꞌbilintijan texol yu Comam Dios, mach hulnajojinan yu inchejnihan anma, walxinto yu wocan hacaꞌ chejab xol anma yeb yu wakꞌni inbahan yin̈ camical yu iscolcha txꞌiꞌal anma, ẍi Comam tet ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lahwi tuꞌ yapni Comam Jesús yul con̈ob Jericó yeb ebnaj iscuywom. Hayet yel Comam yeb ebnaj bey tuꞌ xin, caw hantan̈e anma oc tzujno yinta Comam. Ay xin huneꞌ naj mach chu yilni, tzꞌon̈anayo istiꞌ beh kꞌano melyu; Bartimeo isbi naj, iscꞌahol naj Timeo ye naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hayet yaben naj tato haꞌ Comam Jesús ah Nazaret chiecꞌtoj, yichico naj yahwi yin̈ caw ip, chalni naj: —Mam Jesús, hach titnajach yin̈ yuninal naj rey David, caw tzꞌayojab hacꞌul win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Caw xin txꞌiꞌal mac cachwa yin̈ naj yun̈e isbejni naj yel yaw, yajaꞌ xin caw ecꞌbalto ah yaw naj, yalnipaxo naj: —Mamin, hach titnajach yin̈ yuninal naj rey David, caw tzꞌayojab nino hacꞌul win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yoc lin̈no Comam, yalni hacaꞌ tiꞌ: —Awteweti naj, ẍi Comam. Yawtelaxti naj, yallax tet naj hacaꞌ tiꞌ: —Aco yip hawanma, ahan̈lin̈noj chachyawte Comam, ẍi anma tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hayet yaben naj hacaꞌ tuꞌ, yah lin̈no naj yin̈ an̈e, isbejnicano naj huneꞌ xil iskꞌap hucanico yin̈, istit naj iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iskꞌamben Comam tet naj: —¿Tzet chawoche chinwatxꞌehan? ẍi Comam. Istakꞌwi naj: —Mam cuywawom, chiwochehan chawakꞌ hajlo insatan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yalni Comam tet naj: —Hajlojab hasat yuto maxawaco hawanma win̈an, xaisje hapaxtoj, ẍi Comam tet naj. Yin̈n̈ena tuꞌ xin ishajlo isbakꞌsat naj, yoc tzujno naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hayet lan̈an yapni Comam Jesús yeb ebnaj iscuywom bey con̈ob Jerusalén, yet ayco Comam yin̈ istzalanil won̈an Olivo, xolbal con̈ob Betfagé yeb Betania, ischejni Comam cawan̈ ebnaj iscuywom, ");
INSERT INTO jacNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yalni Comam tet ebnaj: —Asiꞌwe bey aldea cosatacꞌto tiꞌ. Hayet chexapno bey tuꞌ, cheyilaꞌ huneꞌ noꞌ burro xecan, maẍto hunu mac chiahto yiban̈ noꞌ. Chepuhilo noꞌ cat heyiniti noꞌ wetan. ");
INSERT INTO jacNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta ay mac chikꞌamben teyet: “¿Tzet yin̈ xin chepuhilo noꞌ?” ta ẍi, cheyala: “To ay chiocnico noꞌ yu Comam, yajaꞌ pet chon̈hulan̈ jakꞌaꞌcanojan̈ noꞌ,” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Isto ebnaj cawan̈ tuꞌ, yilni ebnaj noꞌ nichꞌan burro tuꞌ, xecan noꞌ iscawilal huneꞌ pulta, ispuhnilo ebnaj noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ay xin huntekꞌan ebnaj lin̈anayo iscawilal tuꞌ kꞌamben tet ebnaj: —¿Tzet yin̈ xin chepuhilo noꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hacaꞌticꞌa xin yu yalni Comam, hac tuꞌ yu yalni ebnaj, matxa tzet yal huntekꞌan ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lahwi tuꞌ yinito ebnaj noꞌ nichꞌan burro tet Comam. Yanahto ebnaj xil iskꞌap yiban̈ noꞌ, lahwi tuꞌ yahto Comam yiban̈ noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Caw hantan̈e anma islitxꞌbayo xil iskꞌap yul beh sata Comam. Aypaxo mac inilo iskꞌab te teꞌ yanayo yul beh bay chiecꞌto Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yah yaw anma babelico sata Comam yeb anma tzujanico yinta Comam, yalni anma hacaꞌ tiꞌ: —¡Jalaꞌwe tzotiꞌ cꞌul yin̈ mac chul coxol tiꞌ, yuto chejbilti naj yu Comam Dios! ");
INSERT INTO jacNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Jakꞌawe tzalaho cocꞌul yin̈ Jahawil chioc reyal coxol selelo jichmam David! ¡Yuchꞌandios tet Comam Dios! ẍixan̈e anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yapni Comam Jesús bey Jerusalén, yocto Comam yul yatut Comam, yilni Comam tzet ye yul yatut Comam Dios. Lahwi tuꞌ ismeltzo Comam yeb ebnaj iscuywom bey Betania hunelxa yuto kꞌejbixa. ");
INSERT INTO jacNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Haxa yet huneꞌxa tzꞌayic xin yel Comam Jesús yeb ebnaj iscuywom yul con̈ob Betania, ismeltzo Comam yul con̈ob Jerusalén. Yet ayco Comam yin̈ isbel tuꞌ isn̈ohchacan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nahatto ay Comam xin yilnito huneꞌ teꞌ higuera xaelilo xaj, isto Comam yilnoj tato ay sat teꞌ aycoj, yajaꞌ machi hunu sat teꞌ ilcha yu Comam, wal xin xajn̈e teꞌ aycoj yuto maẍto istiempohalo issatni teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yuxin yal Comam yin̈ teꞌ: —Matxa bakꞌinal chilolax hunu hasat, ẍi Comam. Wal ebnaj iscuywom Comam xin yabe ebnaj yalni Comam huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lahwi tuꞌ, yapni Comam Jesús yeb ebnaj iscuywom yul con̈ob Jerusalén; yocto Comam yul yatut Comam Dios, istzumbenilti Comam sunil mac chitxon̈wi yeb mac chilokꞌwi bey tuꞌ. Ispacꞌchancanocan̈ Comam ismeẍa ebnaj helom melyu yeb isẍila ebnaj txon̈om palamuch. ");
INSERT INTO jacNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Machi xin isje Comam ta chiecꞌto anma yeb yijatz yul yamakꞌil yatut Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yoc Comam yalno tet anma tuꞌ hacaꞌ tiꞌ: —Tzꞌibn̈ebilcano yul Yum Comam Dios hacaꞌ tiꞌ: “Haꞌ watutan yet txah yehi, bay chul anma ay yul hunun txꞌotxꞌ nimeta con̈ob txahloj,” ẍiayoj. Walex tiꞌ xin hacaꞌ isn̈achꞌen elkꞌom ye yatut Inmaman heyu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hayet yaben ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés tzet iswatxꞌe Comam tuꞌ, yoc ebnaj issayni yin̈ tzet chu ispotxꞌni ebnaj Comam, yajaꞌ xiw ebnaj tet Comam yuto caw chitzala anma yaben cuybanile chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Haxa yet lan̈anxa yay numna xin yel Comam yul con̈ob yeb ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Haxa yin̈ hunxa tzꞌayic yin̈ sahab sacꞌayal ismeltzopaxo Comam Jesús yeb ebnaj iscuywom yul con̈ob Jerusalén, yilni ebnaj iscuywom Comam ta xatajilo teꞌ higuera. ");
INSERT INTO jacNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Isnaniti naj Pedro ta haꞌ teꞌ istzꞌactiꞌn̈e Comam, yalni naj tet Comam: —Mam cuywawom, ilcꞌanabi, matajnalo teꞌ higuera hatzꞌactiꞌn̈e, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Istakꞌwi Comam: —Aweco heyanma yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yin̈ caw isyelal chiwalan teyet; macn̈eticꞌa chihalni tet huneꞌ witz tiꞌ: “Elan̈ bey tiꞌ, bejayto haba xol haꞌ mar,” ta ẍi. Ta xin chayto yul yanma yin̈ tzet chal tuꞌ, mach chi-xin-chicabcon yanma, chij isba tzet chiskꞌana. ");
INSERT INTO jacNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yuxin chiwalan teyet, sunil tzet chekꞌan yin̈ hetxah tet Comam Dios yilal heyanayto yul heyanma ta chakꞌ Comam teyet; ta hac tuꞌ chechah tzet chekꞌana. ");
INSERT INTO jacNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yeb yet lan̈an hetxahli, yilal heyakꞌni nimancꞌulal yin̈ mac ayco ishowal teyin̈, haxinwal chakꞌpaxo nimancꞌulal Comam Dios yin̈ hemul. ");
INSERT INTO jacNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yuto ta mach cheyakꞌ nimancꞌulal, mach chakꞌpaxo Hemam ay yul satcan̈ nimancꞌulal teyin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lahwi tuꞌ, yapni Comam yul con̈ob Jerusalén hunelxa. Haxa yet lan̈an yecꞌ Comam yul yatut Comam Dios xin yapni ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés yeb ebnaj ichamta winaj iswiꞌehal con̈ob, iscꞌatan̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iskꞌamben ebnaj tet Comam: —¿Mac chachchejni hawatxꞌen huntekꞌan hawatxꞌe yet ewi? ¿Mac akꞌn̈e hawip hawatxꞌen huntekꞌan tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Istakꞌwi Comam: —Haquintuꞌan ay huneꞌ inkꞌambebalan teyet: ¿Mac an̈eti naj Juan anican̈ haꞌ iswiꞌ anma, Comam Dios mato haꞌ anma? Ta chepajtze wetan chiwalpaxojan mac chejn̈eintijan inwatxꞌenan huntekꞌan tuꞌ, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yet yaben ebnaj yalni Comam hacaꞌ tuꞌ, yichico ebnaj yallen tet hunun: —Ta chijala ta Comam Dios an̈eti naj Juan tuꞌ, chimiskꞌambe naj jet: “¿Tzet yin̈ xin mach heyayto yul heyanma yin̈ naj?” ẍim naj jet. ");
INSERT INTO jacNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Tom xin chijalaꞌpaxoj tato haꞌ anma chejn̈e naj Juan tuꞌ? ẍi ebnaj. Yal ebnaj hacaꞌ tuꞌ yu chixiw ebnaj tet anma yuto chal anma tato naj Juan tuꞌ ischejab Comam Dios ye naj. ");
INSERT INTO jacNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yuxin takꞌwi ebnaj tet Comam: —Mach johtajojan̈, ẍi ebnaj. Yalni Comam: —Haquinpaxtuꞌan mach chiwalan teyet mac akꞌn̈e wipan inwatxꞌenan huntekꞌan tuꞌ, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lahwi tuꞌ yichico Comam Jesús iscuyni anma, yanico Comam huneꞌ yechel tiꞌ: —Ay huneꞌ naj tzꞌunni teꞌ uva sat istxꞌotxꞌ, ispenayo naj istzꞌunub tuꞌ. Iswatxꞌenpaxo naj bay chiyatzꞌlax yal teꞌ. Yanipaxocan̈ naj huneꞌ n̈a nimajal istel bay chitan̈elax teꞌ uva tuꞌ. Lahwi tuꞌ yanito naj istzꞌunub comonal tet huntekꞌan ebnaj munlawom, isto naj yin̈ huneꞌ isbel caw nahat. ");
INSERT INTO jacNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Haxa yet yapni istiempohal yuxlax teꞌ uva tuꞌ ischejnito naj huneꞌ ischejab ischahno ismajul. ");
INSERT INTO jacNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yajaꞌ yet yilni ebnaj munlawom yapni naj istzablaxayo naj, ismakꞌlax naj, ischejlaxtopaxo naj. Matzet xin yakꞌ ebnaj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lahwi tuꞌ yanipaxto naj yahaw munil tuꞌ hunxa ischejab hunelxa, yajaꞌ kꞌojlaxcan̈ naj chejab tuꞌ yu ebnaj. Caw xin how ebnaj yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yanipaxto naj yahaw munil tuꞌ huneꞌxa ischejab, yajaꞌ makꞌbil iscam naj yu ebnaj. Caw xin txꞌiꞌalto ebnaj chejab yato naj yahaw munil tuꞌ, yajaꞌ ay ebnaj ismakꞌ ebnaj, aypaxo ebnaj makꞌbil iscam yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yajaꞌ xin ayto huneꞌxa mac maẍto chato naj, haꞌ ton iscꞌahol naj caw xahan ay yu. Haxa yin̈ islahobal xin yanito naj iscꞌahol tuꞌ, istxumni naj hacaꞌ ti: “Wal tet naj incꞌaholtiꞌan etzan̈em chixiw ebnaj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yajaꞌ yet yapni naj cꞌahole tuꞌ, yallen ebnaj munlawom tuꞌ tet hunun: “Lan̈an yul naj cꞌahole lah, haꞌ tet naj tiꞌ chicancano huneꞌ txꞌotxꞌ tiꞌ, wal tinan̈ copotxꞌowe camo naj, haxinwal jetxa chucanico huneꞌ txꞌo txꞌotxꞌ tiꞌ,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hac tuꞌ yu istzabnayo ebnaj naj cꞌahole tuꞌ, ispotxꞌni ebnaj naj, yinilto ebnaj isnimanil naj yintalto peyab. ");
INSERT INTO jacNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Tzet xin chiutelax ebnaj munlawom yu naj yahaw munil tuꞌ, heyalni? Wal xin haꞌ caw naj chꞌapni, cat ispotxꞌni camo naj ebnaj munlawom tuꞌ, cat xin yanito naj istzꞌunub tuꞌ comonal tet huntekꞌanxa ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Tom maẍto bay cheyil yul Yum Comam Dios bay chala?: Haꞌ huneꞌ chꞌen chꞌen iskꞌojilo ebnaj watxꞌemcan̈ n̈a, haꞌ chꞌen caw ecꞌbal cꞌul yoc xeꞌo n̈a. ");
INSERT INTO jacNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Huneꞌ tuꞌ, haꞌ Comam Dios watxꞌen̈e yuxin caw chicꞌay cocꞌul jilni, ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yet istxumnilo ebnaj yahawil con̈ob tato yin̈ ebnaj yal Comam huneꞌ yechel tuꞌ, yoche ebnaj yakꞌacto Comam yul preso. Yajaꞌ xiw ebnaj tet anma, yuxin isbejcano ebnaj Comam, ispaxto ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lahwi tuꞌ ischejlaxto haywan̈ ebnaj fariseo yeb huntekꞌan ebnaj ayco yin̈ ispartido naj Herodes tzotelo tet Comam yun̈e yilni ebnaj ta ay bay chiaycꞌay Comam yin̈ hunu tzotiꞌ, cat yoc ebnaj akꞌocꞌule yin̈ Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yapni ebnaj iscꞌatan̈ Comam, iskꞌamben ebnaj: —Mam cuywawom, caw johtajan̈ tato isyelaln̈eticꞌa tzet chawala, mach xin hawoc yin̈ tzet chal anma, yuto lahan yelapno anma sunil yul hasat. Chacuynipaxo anma isyijen yin̈ hacaꞌ choche Comam Dios, yuxin chicokꞌambehan̈ tawet: ¿Cꞌulmi jakꞌni cotohlabal tet naj jahaw ay bey Roma, mato machoj? ¿Chitom isje jakꞌni chꞌen, mato matxa? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wal Comam xin yohtaxa tato txꞌoj nabil yu ebnaj, yuxin yal Comam: —¿Tzet yin̈ xin chexoc quinheyilweꞌan? Iweti hunu chꞌen melyu tuꞌ wilaꞌan nan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Isyeni ebnaj huneꞌ chꞌen melyu, hayet yilni Comam chꞌen, iskꞌamben Comam tet ebnaj: —¿Mac najil ayco yechel sat yeb isbi yin̈ chꞌen? ẍi Comam. Istakꞌwi ebnaj: —Yechel sat naj jahaw ay Roma, yeb xin isbi naj ayco yin̈ chꞌen, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yuxin yal Comam: —Ta hac tuꞌ, akꞌwe tet naj jahaw baytet yet naj yehi, cat heyakꞌni tet Comam Dios baytet yet Comam yehi, ẍi Comam. Caw xin cꞌayilo iscꞌul ebnaj yaben yin̈ tzet yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lahwi tuꞌ yapni huntekꞌan ebnaj saduceo tzotelo tet Comam. Ebnaj saduceo tuꞌ chal ebnaj tato mach chiitzitzbican̈ camom, yuxin iskꞌambe ebnaj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mam cuywawom, tzꞌibn̈ebilcano yu naj Moisés tato chicam yichamil hunu ix ix, mach xin yuninal naj yeb ix, yilal yikꞌni ix yuẍta naj camom tuꞌ haxinwal ay yuninal naj yuẍtaj naj tuꞌ yeb ix, cat yoc yuninalo naj camom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yet hunel, ay hujwan̈ ebnaj yuẍtan̈e isba. Naj babel mohyi naj, yaj cam naj, machi xin yuninal naj yeb yixal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yuxin mohyi naj iscab yeb ix, yajaꞌ campaxo naj, machipaxo xin yuninal naj yeb ix. Hacticꞌapax tuꞌ yu naj yox. ");
INSERT INTO jacNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hac tuꞌ yu yikꞌni ebnaj ix ishujwan̈il, iscamto ebnaj, machi xin hunu yuninal ebnaj yeb ix; haxa yet islahobalxa xin iscampaxo ix. ");
INSERT INTO jacNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yuxin hayet chiitzitzbican̈ camom yet chiitzitzbican̈ ebnaj tuꞌ, ¿mactaxca ebnaj chioc yichamilo ix, yuto ishujwan̈il ebnaj mohyi yeb ix? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Istakꞌwi Comam: —Hex tiꞌ caw cꞌaynajextoj, yuto mach heyohtajo tzet tzꞌibn̈ebilcano yul Yum Comam Dios, yeb xin mach heyohtapaxo hanta yip Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yet chiitzitzbican̈ anma camnaxa matxa chikꞌ ebnaj winaj yixal, matxa chikꞌpaxo ebix ix yichamil, yuto anma chiitzitzbican̈ lahanxa chꞌelico hacaꞌ ebnaj ángel ay satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Tzet yin̈ xin mach cheyayto yul heyanma ta chiitzitzbican̈ camom? ¿Tom maẍto cheyil yul Yum Comam Dios bay tzꞌibn̈ebilcano yu naj Moisés yin̈ tzet yu istzotel Comam tet naj xol hun hoban teꞌ txꞌix ayco kꞌaꞌ yin̈, yet yalni Comam tet naj hacaꞌ tiꞌ?: “Hanintiꞌan isDiosal naj Abraham, naj Isaac yeb naj Jacob,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Yuto Comam Dios mach isDiosalo camom yehi to isDiosal anma itzitz ye Comam! Yuxin hex tiꞌ caw maẍtaj haꞌ heyecoj, caw mach chitxumcha huneꞌ tiꞌ heyu, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yet yaben huneꞌ naj cuywawom yin̈ isley naj Moisés tato caw cꞌul yu ispajtzen Comam Jesús iskꞌambebal ebnaj saduceo, yoc naj iskꞌambeno tet Comam hacaꞌ tiꞌ: —Mamin, xol sunil chejbanile akꞌbilcano jet, ¿baytet ecꞌbal yelapno yehi? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Istakꞌwi Comam tet naj: —Haꞌ chejbanile ecꞌbal yilal yehi haꞌ huneꞌ tiꞌ: “Abewe hex Israel, haꞌ Comam Dios haꞌ coDiosal, han̈cꞌan̈e Comam haꞌ Jahawil. ");
INSERT INTO jacNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ochewe Comam yin̈ sunil hecꞌul, yin̈ sunil heyanma, yin̈ sunil henabal yeb yin̈ sunil heyip,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Walpaxo huneꞌ iscab chejbanile chal hacaꞌ tiꞌ: “Xahan cheyil heyet anmahil, hacaꞌ chu heyaꞌiln̈en heba,” ẍiayoj. Matxa hunuxa chejbanil ecꞌbal yelapno ye sata huntekꞌan tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hayet yaben naj yalni Comam hacaꞌ tuꞌ, istakꞌwi naj: —Mam cuywawom, caw yel chawala, han̈cꞌan̈e Comam Dios Jahawil, haꞌ coDiosal, matxa hunuxa Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yuxin tato chijoche Comam Dios yin̈ sunil janma, yin̈ sunil conabal yeb yin̈ sunil jip, cat xin coxahann̈e jet anmahil hacaꞌ chu coyaꞌiln̈en coba, ecꞌbal yilal yelapno ye sata ispotxꞌlax no nokꞌ cat isn̈uslax tet Comam Dios, maca isn̈uslax hunuxa tzet ye tuꞌ yin̈ xahanbalil, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hayet yaben Comam tato cꞌul yu istakꞌwi naj, yalni Comam tet naj: —Hach tiꞌ cawilxa haweco hawoc yul iskꞌab Comam Dios, ẍi Comam. Matxa hunuxa mac kꞌamben hunuxa tzet ye tuꞌ tet Comam yuto machi mac yihti yanma yin̈ iskꞌamben tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hunel yet lan̈an iscuywa Comam Jesús yul yatut Comam Dios, iskꞌamben Comam: —¿Tzet yin̈ xin chal ebnaj cuywawom yin̈ isley naj Moisés tato yin̈ naj rey David chitit naj Cristo, naj echmabil yuli? ");
INSERT INTO jacNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yajaꞌ haꞌ naj David tuꞌ halni yu yip Comam Espíritu Santo hacaꞌ tiꞌ: Yal Comam Dios tet Wahawilan: “Ayan̈ tzꞌon̈an yin̈ inwatxꞌkꞌabtiꞌan masanto chiwacojan ebnaj ayco ishowal tawin̈ yalan̈ hawoj,” ẍi Comam, ẍi naj David. ");
INSERT INTO jacNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tato yin̈ naj David tuꞌ titna naj Cristo, ¿tzet yin̈ xin yal naj David naj Cristo Yahawiloj? ẍi Comam. Caw hantan̈e anma iscutxbaco isba bey tuꞌ, caw xin sunil mac yoche yabeꞌ yin̈ tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yet lan̈an iscuywa Comam Jesús, yalni hacaꞌ tiꞌ: —Caw cheyil heba tet ebnaj cuywawom yin̈ isley naj Moisés, yuto ebnaj tuꞌ caw choche ebnaj yakꞌaco huntekꞌan xilkꞌape nimej ishojo istel, yeb yochebal ebnaj caw nanxa islow chu istioẍli anma tet ebnaj yet chiecꞌ ebnaj yulaj txon̈bal. ");
INSERT INTO jacNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chissaynipaxilo ebnaj huntekꞌan tzꞌon̈obal caw ay yelapno ye yulaj iscapilla ebnaj Israel yeb bay chiawtelax ebnaj waꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chanipaxico ebnaj lekꞌtiꞌal chinilo ebnaj yatut ebix hunix, yajaꞌ yun̈e mach isyelo isba istxꞌojal chiswatxꞌe ebnaj tuꞌ cꞌul yub ebnaj, nimej chute ebnaj yoj istxah. Ebnaj tuꞌ caw ecꞌbal niman isyaꞌtajil chiay yiban̈ ebnaj yu Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hunel, tzꞌon̈anayo Comam Jesús iscawilal caẍa bay chayto anma yofrenda tet Comam Dios, yilni Comam yanayto anma tuꞌ yofrenda. Caw txꞌiꞌal ebnaj kꞌalom yayto yet, caw xin txꞌiꞌal chꞌen yayto ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lan̈antoticꞌa xin yapni huneꞌ ix hunix caw mebaꞌ, yanayto ix cabeb chꞌen melyu niẍchꞌan sat yul caẍa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yet yilni Comam huneꞌ tuꞌ, yawten Comam ebnaj iscuywom, yalni Comam: —Yin̈ caw yeli chiwalan teyet, huneꞌ ix hunix tiꞌ caw ecꞌbal mayakꞌ ix sata sunil ebnaj mayakꞌ yofrenda tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yuto ebnaj kꞌalom tiꞌ iskꞌalxan̈e chayto ebnaj, wal ix tiꞌ xin caw mebaꞌ ix, yaj cꞌuxan mayayto ix ismelyu chilokꞌni tzet chiocnico yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yet lan̈an yelti Comam Jesús yul yatut Comam Dios, yalni huneꞌ naj iscuywom Comam: —Mamin, ¡ilcꞌanab huntekꞌan chꞌen chꞌen yeb huntekꞌan nimeta n̈a tiꞌ lah! ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Istakꞌwi Comam: —Huntekꞌan nimeta n̈a tiꞌ chiuchcꞌalaxtoj, matxa hunu chꞌen chꞌen latzꞌbil tiꞌ chican yiban̈ yet chꞌenal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lahwi tuꞌ xin, isto Comam Jesús yeb ebnaj iscuywom yin̈ istzalanil won̈an Olivo ayco yetcꞌulal satacꞌtiꞌ yatut Comam Dios; yay tzꞌon̈no Comam bey tuꞌ. Iskꞌamben naj Pedro, naj Juan yeb naj Andrés tet Comam yet ischuquilxan̈e: ");
INSERT INTO jacNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Mamin, hal jetan̈ bakꞌin chihul huntekꞌan chawal tiꞌ, ¿tzettaxca yechel chiyu yet chijni isba? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Istakꞌwi Comam: —Caw cheyil heba, machojab mac chexakꞌni subchahoj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yuto caw txꞌiꞌal ebnaj chuli cat isbalnico ebnaj inbihan yin̈, cat yalni ebnaj hacaꞌ tiꞌ: “Hanintiꞌan Cristo hinan,” ẍi ebnaj. Caw xin txꞌiꞌal mac chisubcha yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hayet cheyabeni ta ay howal hecawilal maca nahata, mach chexxiwi yuto yilal yuni huntekꞌan tiꞌ, cat iswejchacan̈ anma, yajaꞌ maẍto istan̈balo huneꞌ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chakꞌlecan̈ howal ej txꞌotxꞌ nimeta con̈ob yeb huntekꞌanxa txꞌotxꞌ nimeta con̈ob, cat yanipaxico howal huneꞌ con̈ob yin̈ huneꞌxa con̈ob. Caw xin txꞌiꞌal bay chiecꞌ chixcab yeb wahil, yajaꞌ huntekꞌan tuꞌ yichebaniln̈e isyaꞌtajil. ");
INSERT INTO jacNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Caw cheyil heba yuto chexálaxico sata ebnaj yahaw con̈ob, cat hemakꞌlax yulaj capilla. Chexalaxpaxico sata ebnaj gobernador yeb sata ebnaj rey, yu ayexxaco yul inkꞌaban. Hac tuꞌ xin chu quinheyalnilojan tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yet maẍto chitan̈ilo yul yiban̈kꞌinal tiꞌ, yilal ispujbalaxicꞌo Tzotiꞌ cꞌul yet colbanile yulajla txꞌotxꞌ nimeta con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hayet chexalaxico sata ebnaj yahaw con̈ob tuꞌ, mach cheyaco yin̈ hecꞌul yin̈ tzet cheyala; wal xin haꞌ tzet chihallax teyet yu Comam Dios haꞌ cheyala, yuto maẍtajex chextzoteli, to haꞌ Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Haꞌ yin̈ huneꞌ tiempohal tuꞌ, ay ebnaj chaco yuẍta yul iskꞌab camical, ay mame miꞌe chaco yuninal yul iskꞌab camical, aypaxo ebnaj uninale chiyaco howal yin̈ ismam yeb ismiꞌ cat yakꞌni camoj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Caw sunil anma chioc ishowal teyin̈ yuto ayexico yul inkꞌaban, yajaꞌ mac chitecha yu masanto yet islahobal, chicolchahi. ");
INSERT INTO jacNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tzꞌibn̈ebilcano yu huneꞌ ischejab Comam Dios chiyij Daniel, tato yilal yul naj chietanto yatut Comam Dios yu istxꞌojal chiswatxꞌe. Haꞌ mac chiilni huneꞌ tiꞌ txumchahojabilo yu. Yin̈ huneꞌ tzꞌayic tuꞌ, mac hex ayex bey Judea tiꞌ, chexelcan̈ cat heto iswiꞌla witz. ");
INSERT INTO jacNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mac ayahto yiban̈ yatut xin matxahojab chiayti yikꞌalti hunu tzet ye tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wal mac ayto xol ismunil, matxahojab chimeltzo yikꞌalti xil iskꞌap yul yatut. ");
INSERT INTO jacNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Caw cꞌanchꞌan ebix ix ayxa tzet yehi, yeb ebix chito txutxwi niẍte yunin yin̈ huneꞌ tiempohal tuꞌ! ");
INSERT INTO jacNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kꞌanwe tet Comam Dios haxinwal maẍtaj yin̈ n̈abil chihul huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuto caw chiecꞌyaꞌ yanma anma yin̈ huneꞌ tiempohal tuꞌ. Huntekꞌan isyaꞌtajil tuꞌ maẍto hunelo chuhi yichitax iswatxꞌen Comam Dios huneꞌ yul sat yiban̈kꞌinal tiꞌ, matxa xin bakꞌinal chuhi yet chilahwi yunicanoj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta mach chiscꞌotzba Comam Dios Jahawil yoj huneꞌ tiempohal tuꞌ, machi hunu mac chicolchahi, wal xin chiscꞌotzba Comam yuto xahan ay yuninal Comam yu, huntekꞌan sicꞌbilxaloj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yuxin ta ay mac chihalni teyet: “Haꞌ bey tiꞌ ay naj Cristo lah,” maca ta “Haꞌ bey tuꞌ ay naj lah,” ta ẍi, mach cheyayto yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yuto caw txꞌiꞌal ebnaj lekꞌtiꞌwom chisbalico isba Cristohal. Aypaxo ebnaj chisbalico isba ischejabo Comam Dios cat isyeni ebnaj cꞌaybalcꞌule yeb yechel yip naj matzwalil yun̈e issubcha anma yu ebnaj. Etza xin chisubchapaxo ebnaj sicꞌbilxa yu Comam Dios yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Caw cheyil heba xin! Yalan̈to chiwalnicanojan huntekꞌan tiꞌ teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hayet chilahwi yecꞌcano huntekꞌan isyaꞌtajil tuꞌ, chikꞌejholilo yoj tzꞌayic, matxa chimujlipaxo ixahaw, ");
INSERT INTO jacNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","cat istitcꞌay ej txꞌumel ay satcan̈, cat xin isbilipaxo sunil tzet ay yip ay yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lahwi tuꞌ cat yillax wulan xol moyan, Hanin Akꞌbilintijan texol yu Comam Dios. Chinhulan yeb sunil iskꞌakꞌal wipan, ");
INSERT INTO jacNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","cat inchejni wángelan iscutxbanoco sunil mac sicꞌbilxalo wuhan yul sat yiban̈kꞌinal tiꞌ, sunil baytajtuꞌwal ay anma bay chiecꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Txumwecꞌanab yin̈ teꞌ higuera: Yet chielilo ischon iskꞌab teꞌ cat yul xaj teꞌ, cheyohtan̈eloj ta toxa chioc haꞌ n̈ab. ");
INSERT INTO jacNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hac tuꞌ ye huntekꞌan chiwaltiꞌan. Hayet cheyilni yijni isba huntekꞌan tuꞌ, yilal heyohtan̈eni tato cawilxa yeti bay chinhulan. ");
INSERT INTO jacNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yin̈ caw yeli chiwalan teyet; sunil huntekꞌan tiꞌ chiyu yalan̈to maẍto chicam huntekꞌan anma tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Haꞌ satcan̈ yeb txꞌo txꞌotxꞌ tiꞌ chitan̈iloj, wal Intzotiꞌan xin mach chiecꞌto yet yijni isba tzet chala. ");
INSERT INTO jacNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yajaꞌ wal yin̈ tzet tzꞌayical yeb tzet orahil chinhulan machi hunu mac ohtan̈e nitam ebnaj ángel ay yul satcan̈. Mach wohtapaxojan, Hanin Iscꞌahol Comam Dios intiꞌan; wal xin han̈cꞌan̈e Inmaman ohtan̈e. ");
INSERT INTO jacNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yuxin caw nann̈e heyu, majwan̈wej yuto mach heyohtajo tzet orahil chinhulan. ");
INSERT INTO jacNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lahan hacaꞌ yet chito hunu naj yahaw n̈a yin̈ hunu isbel caw nahat. Yalan̈to maẍto chito naj chalnicano naj tzettaj munilal chu hunun ischejab, cat yalnicano naj tet naj tan̈em pulta tato caw chil naj istiꞌ pulta tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ebnaj chejab tuꞌ, mach yohtajo ebnaj bakꞌin chimeltzo naj yahaw n̈a, mach yohtajo ebnaj tato hayet yahbal akꞌbal chul naj, maca yin̈ chuman akꞌbal, maca yet chiokꞌ noꞌ chiyo, maca yet sahab sacꞌayal. Haquexpax tuꞌ mach heyohtajo bakꞌin chinhulan, yuxin majwahan̈wej, ");
INSERT INTO jacNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","tajca tona nahul ayex cat wul lemnahan. ");
INSERT INTO jacNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Huntekꞌan tiꞌ, maẍn̈etaj teyet chiwalan, to chiwalpaxojan tet sunil anma. ¡Caw majwahan̈wej! ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yet cabexan̈e kꞌin̈ Pascua, yet chiwahlax ixim pan machi yan̈al chialaxicoj, yichico ebnaj yahawil yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés issayni yin̈ tzet chu yaycꞌay Comam yin̈ hunu istxꞌojal; yun̈e istzabnayo ebnaj cat ispotxꞌni ebnaj Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xol ebnaj tuꞌ ay ebnaj halni: —Mach chicotzabayo naj yin̈ kꞌin̈ yuto ahta wejna anma sunil jin̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yet ay Comam Jesús bey con̈ob Betania, isto Comam bey yatut naj Simón, naj ayticꞌaco yabil lepra yin̈. Yet ayco Comam waꞌo sat meẍa yapni huneꞌ ix iscꞌatan̈ Comam, ikꞌbil huneꞌ an̈ caw xukꞌ sam yu ix ayayto yul huneꞌ chꞌen limeta alabastro isbi. Nardo isbi huneꞌ an̈ tuꞌ caw ay istohol. Iscꞌutznilto ix isnukꞌ chꞌen limeta tuꞌ, isjobnayo ix huneꞌ an̈ caw xukꞌ sam tuꞌ yiban̈ iswiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Xol mac ayicto bey tuꞌ, ay huntekꞌan ebnaj tit ishowal, yalni ebnaj tet hunun: —¿Tzet yin̈ xin ton̈e chietalaxto huneꞌ an̈ caw xukꞌ sam tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Estam matxon̈laxtoj, ecꞌbalmi oxeb ciento denario chiakꞌlax yin̈, cat ispohlaxcan̈ istohol yin̈ anma mebaꞌ, ẍi ebnaj. Caw xin oc ebnaj buchwal yin̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yajaꞌ xin yal Comam: —¿Tzet yin̈ xin cheyakꞌ hetiꞌ yin̈ ix? Mach checach ix yuto huneꞌ maswatxꞌe ix win̈tiꞌan caw cꞌul. ");
INSERT INTO jacNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Haꞌ anma mebaꞌ ayn̈eticꞌaco texol yin̈ sunilbal tiempo, tzijxan̈e tiempohal chu hecolwa yin̈; wal inpaxojan xin mach sunilbal tiempo ayinicꞌojan texol. ");
INSERT INTO jacNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ix tiꞌ, haꞌ tzet chikꞌoji ix iswatxꞌeni, haꞌ maswatxꞌe ix win̈an. Mayan̈tecano ix innimanilan yalan̈to maẍto chinmujlaxan. ");
INSERT INTO jacNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yin̈ caw yeli chiwalan teyet; bay-xan̈e-tuꞌwal chihallaxicꞌo Tzotiꞌ cꞌul yet colbanile, chihallaxpaxo huneꞌ maswatxꞌe ix tiꞌ win̈an, cat yakꞌlax binaho ix, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wal naj Judas Iscariote, naj ayco istzꞌajo ebnaj cablahon̈wan̈ iscuywom Comam Jesús, to naj yilaꞌ ebnaj yahawil yin̈ ebnaj sacerdote yun̈e yanico naj Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hayet yaben ebnaj huneꞌ tuꞌ caw tzalacan̈ ebnaj, yalten ebnaj melyu tet naj. Yichico naj Judas tuꞌ issayni yin̈ tzet chu yanico naj Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Haxa yayilo babel tzꞌayic kꞌin̈ Pascua, yet chiwahlax ixim pan machi yan̈al chialaxicoj, yeb yet chipotxꞌlax noꞌ meꞌ xahanbalil; iskꞌamben ebnaj iscuywom Comam tet: —Mamin, ¿baytuꞌwal chawoche chicowatxꞌehan̈ tzet chicolo yin̈ kꞌin̈ Pascua tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ischejnito Comam cawan̈ ebnaj iscuywom, yalni Comam tet ebnaj: —Asiꞌwe yul con̈ob, hayet chexapno bey tuꞌ cheyilno huneꞌ naj ikꞌbil huneꞌ tzꞌahab haꞌ yu, chexoco tzujno yinta naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Haꞌ bay chꞌapni naj xin chekꞌambe tet naj yahaw n̈a tuꞌ: “¿Baytuꞌwal ay huneꞌ cuarto bay chiwaꞌ yaꞌ cuywawom yeb iscuywom yin̈ kꞌin̈ Pascua?” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Haꞌ naj xin chiyeno huneꞌ cuarto caw nimajal teyet, ayco yin̈ iscab piso, caw cꞌulxa yehi. Haꞌ bey tuꞌ xin chewatxꞌe tzet chicolo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lahwi tuꞌ, isto ebnaj cawan̈ tuꞌ yul con̈ob Jerusalén, yilcha yu ebnaj hacaꞌticꞌa yu yalni Comam. Yoc ebnaj iswatxꞌeno tzet chilolax yin̈ kꞌin̈ Pascua tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Haxa yet lan̈anxa yay numna xin yapni Comam yeb ebnaj cablahon̈wan̈ iscuywom yul huneꞌ cuarto tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yet ayxaco Comam waꞌo sat meẍa yeb ebnaj iscuywom xin, yalni Comam: —Yin̈ caw isyelal chiwalan teyet, haꞌ huneꞌ mac chinanicojan yul iskꞌab camical, ayco naj waꞌo coxol tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hayet yaben ebnaj iscuywom Comam huneꞌ tuꞌ, caw oc biscꞌulal yin̈ yanma ebnaj, yoc ebnaj iskꞌambeno yin̈ hununtajil tet Comam: —Mamin, ¿tom haninan? ẍi hunun ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Istakꞌwi Comam: —Huneꞌ mac texol hex cablahon̈wan̈ hex tiꞌ, naj chislabayto ispan yul insecꞌan, haꞌ naj chinanicojan yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hanin Akꞌbilintijan texol yu Comam Dios yilal wecꞌan yin̈ camical hacaꞌ yalni yul Yum Comam, yajaꞌ cꞌanchꞌan naj chinanicojan yul iskꞌab camical. Ayxicꞌa mach pitzcꞌana naj yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hayet lan̈an iswaꞌ Comam, yinican̈ ixim pan, yakꞌni yuchꞌandiosal tet Comam Dios, lahwi tuꞌ iskꞌaxponayo ixim, yakꞌni Comam ixim tet ebnaj, yalni Comam: —Chahwej, cat hewahni. Huneꞌ tiꞌ yechel innimanilan yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lahwi tuꞌ yinipaxocan̈ Comam chꞌen vaso, yakꞌnipaxo Comam yuchꞌandiosal tet Comam Dios. Lahwi tuꞌ xin yakꞌni Comam chꞌen tet ebnaj iscuywom, caw xin sunil ebnaj ucꞌni. ");
INSERT INTO jacNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yalni Comam: —Huneꞌ tiꞌ yechel inchiqꞌuilan chimalto yu iscꞌulal yin̈ txꞌiꞌal anma. Hac tuꞌ chu yijni isba huneꞌ acꞌ trato chakꞌ Comam Dios teyet. ");
INSERT INTO jacNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yin̈ caw yeli chiwalan; matxa chiwucꞌan yal sat teꞌ uva masanto chioc Comam Dios Yahawiloj, catto wucꞌnihan yin̈ yacꞌtohal hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lahwi isbitnicano Comam Jesús yeb ebnaj iscuywom, isto Comam yeb ebnaj bey won̈an Olivo, ");
INSERT INTO jacNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","yalni Comam tet ebnaj: —Yin̈ huneꞌ akꞌbal tiꞌ, caw hesunil cheyikꞌalo heyanma win̈an, yuto hac tuꞌ yu istzꞌibn̈elaxcano yul Yum Comam Dios bay chala: “Chinpotxꞌcamojan naj tan̈em meꞌ, cat issaj lemito noꞌ meꞌ tuꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yajaꞌ yet chinitzitzbican̈an chinbabitojan bey Galilea tesataj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yalni naj Pedro tet Comam: —Mamin, waxan̈ca sunil mac chiinilo yanma tawin̈, walinan machoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yalni Comam tet naj: —Pedro, yin̈ caw yeli chiwalan tawet; yin̈ticꞌa huneꞌ akꞌbal tiꞌ, yalan̈to maẍto chiokꞌ noꞌ icham chiyo yin̈ iscayel, oxelxa chawala ta mach quinhawohtajojan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Islahnico naj Pedro, yalni: —Waxan̈ca chinakꞌlax camojan tawintaj yajaꞌ mach chiwalan ta mach cachwohtajojan, ẍi naj tet Comam. Sunil xin ebnaj iscuywom Comam halni hacaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lahwi tuꞌ, isto Comam Jesús yeb ebnaj iscuywom bey huneꞌ peyab chiyij Getsemaní, yalni Comam tet ebnaj: —Canan̈wecano tzꞌon̈no bey tiꞌ, chintohan txahloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Han̈e xin naj Pedro, naj Jacobo yeb naj Juan yito Comam. Caw yabe Comam isyaꞌil biscꞌulal yin̈ yanma. ");
INSERT INTO jacNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yalni Comam tet ebnaj: —Caw chiwabehan isyaꞌil isbiscꞌulal camical yin̈ wanmahan. Canan̈wecano bey tiꞌ, mach chexwayi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ishitzilo Comam hanicꞌxa sata ebnaj, yay jahno Comam, yay xulno sat txꞌotxꞌ, yoc Comam iskꞌanni tet Comam Dios ta ay tzet chu yecꞌto huneꞌ isyaꞌtajil chul yiban̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yalni Comam yin̈ istxah: —Mam, machi hunu tzet ye tuꞌ yaꞌta yul hasat. Colinan tet huneꞌ isyaꞌtajil chul wiban̈tiꞌan, yajaꞌ mach hacaꞌ chiwochehan to hacaꞌojab tzet chal hacꞌul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lahwi tuꞌ xin, ismeltzo Comam bay cancano ebnaj oxwan̈, yalni Comam tet naj Pedro: —¿Tom wayo chawu? ¿Tom mach chu hawinilo hawayan̈ hunu orahil? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yalnipaxo Comam tet ebnaj: Iwelo hewayan̈, txahlan̈wej, haxinwal mach chexaycꞌay yul iskꞌab istxꞌojal, wal heyanma caw hinan isyijen tzet chal Comam Dios, yajaꞌ wal henimanil xin mach chitecha ilwebal yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Istopaxo Comam txahlo hunelxa, hacaꞌticꞌa tzet yal Comam yet babelal, hac tuꞌ yute yalnipaxo yin̈ iscayel. ");
INSERT INTO jacNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Haxa yet ismeltzopaxo Comam iscꞌatan̈ ebnaj xin, wayan̈ chupaxo ebnaj, yuto mach chitecha naj wayan̈ yu ebnaj. Yuxin matxa chitxumcha yu ebnaj yin̈ tzet chu istakꞌwi tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Haxa yet ismeltzo Comam iscꞌatan̈ ebnaj yin̈xa yoxel isbeycꞌo txahloj, yalni Comam tet ebnaj: —¿Tom yexn̈eto hewayi yeb hexewi? ¡Yetzanxa! Wal xin Hanin Akꞌbilintijan texol yu Comam Dios tiꞌ maapni yorahil walaxicojan yul iskꞌab anma mulum. ");
INSERT INTO jacNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ahan̈wewanoj, ton̈wej; lan̈an yul naj chinanicojan yul iskꞌab camical, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yet lan̈an istzotel Comam Jesús tuꞌ, yapni naj Judas, naj ayco istzꞌajo ebnaj cablahon̈wan̈ iscuywom Comam. Caw xin hantan̈e anma tzujan yinta naj. Ay mac ikꞌbil yespada, aypaxo mac ikꞌbil isteꞌ yu. Chejbil ebnaj yu ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb yu ebnaj cuywawom yin̈ isley naj Moisés, yeb yu ebnaj ichamta winaj iswiꞌehal con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naj Judas chianico Comam yul iskꞌab ebnaj tuꞌ halbilxa tet ebnaj yu naj hacaꞌ tiꞌ: “Haꞌ naj chintzꞌohoꞌan iskꞌotx, haꞌ naj chetzabayoj, cat heyinito naj; mach xin chebejtzo naj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuxin apnin̈e naj, ishitzico naj iscꞌatan̈ Comam, yalni naj: —Mam cuywawom, ẍi naj. Istzꞌohni naj iskꞌotx Comam, ");
INSERT INTO jacNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","yoc bulna ebnaj yin̈ Comam, istzabnayo ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yajaꞌ ay huneꞌ naj iscuywom Comam yihti yespada yul yatut, ispitnilto naj istxiquin ischejab naj yahawil yin̈ ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yalni Comam tet ebnaj apni tzabnoyo tuꞌ: —¿Tom elkꞌominan teyet yuxin ikꞌbil heyespada yeb heteꞌ win̈an chexhul quinhetzabnoyojan? ");
INSERT INTO jacNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hunun tzꞌayic inbeyan cuywal yul yatut Comam Dios texol, yajaꞌ mach quinhetzabayojan. Wal tinan̈ yilal yuni huneꞌ tiꞌ yun̈e yijni isba tzet tzꞌibn̈ebilcano win̈an yul Yum Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wal ebnaj iscuywom Comam, elcan̈ ebnaj sunil, yanicano ebnaj Comam ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ay xin huneꞌ naj tzeh oc tzujno yinta Comam, han̈e huneꞌ kꞌap sábana ayco xilo iskꞌap naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Istzablaxayo naj yu ebnaj inito Comam, yajaꞌ xin iscolilo isba naj, iscancano kꞌap sábana yul iskꞌab ebnaj tuꞌ; tꞌilanxa naj yet yelcan̈ naj yin̈ an̈e. ");
INSERT INTO jacNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lahwi tuꞌ yinito ebnaj Comam Jesús sata naj yahawil yin̈ ebnaj sacerdote. Iscutxbanico isba ebnaj iswiꞌehal yin̈ ebnaj sacerdote, yeb ebnaj cuywawom yin̈ isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wal naj Pedro nahat tzujan isto naj yinta Comam, yapni naj yamakꞌil yatut naj yahawil yin̈ ebnaj sacerdote tuꞌ, yoc tzꞌon̈no naj kꞌaẍno xol ebnaj chitan̈en yatut Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj iswiꞌehal yin̈ lahtiꞌ xol ebnaj Israel, oc ebnaj issayaꞌ hunu tzet chioc ismulo Comam yun̈e iscawxenico ebnaj camical yiban̈ Comam yalni, yajaꞌ machi hunu tiꞌ cawxico ismulo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Caw txꞌiꞌal ebnaj hobnican̈ lekꞌtiꞌal yin̈ Comam, yajaꞌ nanantan̈e tzet chal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ay xin huntekꞌan ebnaj ah lin̈noj, yalni ebnaj lekꞌtiꞌal yin̈ Comam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jabehan̈ yalni naj: “Huneꞌ yatut Comam Dios tiꞌ chiwuchcꞌayojan, oxebn̈e xin tzꞌayic chiwacan̈an selel, yajaꞌ mach anmaho chiwatxꞌencan̈,” ẍi naj tiꞌ, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yajaꞌ maẍticꞌa ocpaxo huneꞌ tuꞌ ismulo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Lahwi tuꞌ, yah lin̈no naj yahawil yin̈ ebnaj sacerdote, yalni naj tet Comam: —¿Tzet yin̈ xin mach chachtakꞌwi? ¿Tzet ye huntekꞌan chal ebnaj tawin̈ tiꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yajaꞌ xin maẍticꞌa takꞌwi Comam tet naj. Iskꞌambenpaxo naj tet Comam: —¿Tom hach tiꞌ Cristo, Iscꞌahol Comam Dios, Comam chihallax cꞌulal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Istakꞌwi Comam: —Hoꞌ, hanintonan. Hex tiꞌ cheyilaꞌ woc tzꞌon̈nojan yin̈ iswatxꞌkꞌab Comam Dios caw aycano yip, cat heyilni wulpaxojan xol moyan yul satcan̈, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hayet yaben naj yahawil ebnaj sacerdote yin̈ tzet yal Comam tuꞌ, istzilnilo naj xil iskꞌap yu isyenilo naj ta txꞌoj chabe naj yin̈ tzet yal Comam. Lahwi tuꞌ, yalni naj: —Wal tinan̈ matxa yilalo chicokꞌan mac chihalni ismul naj tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hex caw hex maxeyabe istxꞌojal istzotel naj yin̈ Comam Dios. ¿Tzet cheyute heyalni yin̈ naj? ẍi naj. Sunil xin ebnaj halni tato yilal iscam Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ay xin ebnaj tzublico yin̈ sat Comam, ismajchenpaxo ebnaj sat, ismakꞌnipaxo ebnaj, chiskꞌamben ebnaj tet Comam: —Haliloj mac chachmakꞌni, ẍi ebnaj. Hacpax tuꞌ ebnaj chitan̈en yatut Comam Dios ocpaxo ebnaj ispakꞌalto sat Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wal naj Pedro ayayto naj yamakꞌil teꞌ n̈a tuꞌ yet yapni ix ischejab naj yahawil yin̈ ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hayet yilni ix iskꞌaẍni naj Pedro, yoccano tꞌan̈no ix yin̈ naj, yalni ix: —Hach tiꞌ hawetbi haba yeb naj Jesús, naj ah Nazaret, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Istakꞌwi naj Pedro: —Tzimi chawal hach tiꞌ, mach wohtajojan naj chawal tuꞌ, ẍi naj. Lahwi tuꞌ isto naj istiꞌ huneꞌ niman pulta, lan̈antoticꞌa xin yokꞌcan̈ huneꞌ noꞌ icham chiyo. ");
INSERT INTO jacNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hayet yilnipaxo ix naj Pedro, yalni ix tet ebnaj ayayto bey tuꞌ: —Huneꞌ naj tiꞌ yetbi isba naj yeb naj Jesús, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yajaꞌ xin yalpaxo naj ta mach yohtajo naj Comam. Hunepixto xin yalni ebnaj ayayo bey tuꞌ: —Yin̈ caw yeli, hach tiꞌ hawetbi haba yeb ebnaj chiecꞌ yinta naj Jesús, yuto ah Galilea hach, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yajaꞌ oc naj Pedro istzꞌactiꞌn̈e isba, yalni naj: —Caw chabe Comam Dios mach wohtajojan huneꞌ naj cheyal tiꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lan̈antoticꞌa yalni naj hacaꞌ tuꞌ yokꞌcan̈ noꞌ icham chiyo yin̈ iscayel. Hac tuꞌ yu isnaniti naj Pedro yin̈ tzet yal Comam tet naj, yet yalni hacaꞌ tiꞌ: “Yalan̈to maẍto chiokꞌ noꞌ icham chiyo yin̈ iscayel, oxelxa chawala ta mach quinhawohtajojan,” ẍi Comam. Hayet istit yul iscꞌul naj yin̈ tzet yal Comam tuꞌ, yoc naj okꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Haxa yet issajbilo xin iscutxban isba ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj ichamta winaj iswiꞌehal con̈ob yeb ebnaj cuywawom yin̈ isley naj Moisés, yeb ebnaj iswiꞌehal yin̈ lahtiꞌ, iscꞌalnayo ebnaj Comam, yinito ebnaj Comam yin̈ sat naj Pilato. ");
INSERT INTO jacNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Iskꞌamben naj Pilato tet Comam: —¿Tom yeli Yahawil anma Israel hawehi? ẍi naj. Istakꞌwi Comam: —Hoꞌ, yel hacaꞌ hawalni tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yajaꞌ wal ebnaj iswiꞌehal yin̈ ebnaj sacerdote caw ayco ebnaj yalni txꞌiꞌal tzet ye tuꞌ ismulo Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yuxin iskꞌambe naj Pilato tet Comam: —¿Tzet yin̈ xin mach chachtakꞌwi? ¿Tom mach chawabe hanta tzet chisbalcan̈ ebnaj hamuluj? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wal Comam xin mach takꞌwi Comam, yuxin caw cꞌayilo iscꞌul naj Pilato tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yin̈ hunun kꞌin̈ Pascua chi-ticꞌa-isbejtzo naj Pilato hunun ebnaj presowom, yajaꞌ macticꞌa chal iscꞌul anma haꞌ chibejtzolaxi. ");
INSERT INTO jacNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ay xin huntekꞌan ebnaj anico howal yin̈ naj yahaw con̈ob, aypaxo xin anma ispotxꞌ ebnaj yuxin ayco ebnaj preso. Xol ebnaj presowom tuꞌ ayco huneꞌ naj, Barrabás isbi. ");
INSERT INTO jacNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iscutxbanico isba anma, yoc anma iskꞌanno tet naj Pilato ta chisbejtzo naj hunu naj presowom hacaꞌticꞌa chute naj yin̈ hunun kꞌin̈ Pascua. ");
INSERT INTO jacNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Istakꞌwi naj tet anma tuꞌ: —¿Chimisje hecꞌul chinbejtzohan naj Yahawil Israel? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hac tuꞌ yute yalni naj, yuto yohta naj ta ton̈e chichiwaco iscꞌul ebnaj yahawil sacerdote tuꞌ yin̈ Comam, yuxin yaco ebnaj Comam yul iskꞌab naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wal ebnaj yahaw ebnaj sacerdote oc ebnaj akꞌocꞌule tet anma ta haꞌ naj Barrabás chisbejtzo naj Pilato. ");
INSERT INTO jacNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iskꞌamben naj Pilato tet anma: —¿Tzet wal wutenan naj isreyal Israel tiꞌ, chal tuꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Istakꞌwi anma tuꞌ: —¡Camojab naj yin̈ culus! ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Iskꞌamben naj Pilato: —¿Tzet xin istxꞌojal iswatxꞌe naj? ẍi naj. Yajaꞌ ah wejna anma tuꞌ, yalni hunelxa: —¡Camojab naj yin̈ culus! ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wal naj Pilato, yun̈e istzala iscꞌul anma yin̈ naj yuxin isbejtzo naj naj Barrabás. Ischejni naj hatelaxo Comam, yanico naj Comam yul iskꞌab ebnaj soldado yu yalaxcan̈ Comam yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lahwi tuꞌ yinilto ebnaj soldado Comam yamakꞌil palacio, iscutxbanpaxico ebnaj huntekꞌanxa ebnaj soldado. ");
INSERT INTO jacNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ishucbanico ebnaj huneꞌ kꞌap kꞌap caj jilni yin̈ Comam. Isbakꞌonayo ebnaj huneꞌ teꞌ txꞌix, yanahto ebnaj coronahil yin̈ iswiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yichico ebnaj yahwi yalni yin̈ caw ip hacaꞌ tiꞌ: —¡Tzalajon̈we yin̈ naj yahawil anma Israel tiꞌ! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chismakꞌnipaxico ebnaj huneꞌ teꞌ ah yin̈ iswiꞌ Comam, istzublipaxico ebnaj yin̈, yeb xin chiay jahno ebnaj sata Comam, cat yay xulno ebnaj sat txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lahwi istzebicano ebnaj yin̈ Comam, yinilo ebnaj huneꞌ kꞌap kꞌap ishucbaco yin̈ Comam, yanico ebnaj xil iskꞌap Comam. Lahwi tuꞌ yinito ebnaj Comam yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ay xin huneꞌ naj ah Cirene, Simón isbi, ismam naj Alejandro yeb naj Rufo ye naj, ispeto xin naj munil. Hayet yecꞌto naj sata ebnaj ikꞌn̈e Comam tuꞌ, istzabnayo ebnaj naj, yinito naj isculus Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yinito ebnaj Comam bey huneꞌ txꞌotxꞌ chiyij Gólgota, chaliloj Isbajil Wiꞌe. ");
INSERT INTO jacNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yakꞌni ebnaj vino sombil yeb huntekꞌan teꞌ telaj chiyij mirra yucꞌuꞌ Comam, yajaꞌ mach isje Comam yucꞌuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Lahwi tuꞌ yanican̈ ebnaj Comam yin̈ culus, yoc ebnaj soldado yilweno isba yin̈ xil iskꞌap Comam yun̈e yilni ebnaj mac chiinitoj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yin̈ chꞌen balon̈eb yet yalan̈ chuman yanican̈ ebnaj Comam yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ispahnico ebnaj huneꞌ nichꞌan akꞌinteꞌ ahto yiban̈ iswiꞌ Comam yin̈ culus bay tzꞌibn̈ebilicoj tzet yin̈ xin akꞌlax camoj, ẍi hacaꞌ tiꞌ: “Haꞌ naj tiꞌ Yahawil anma Israel,” ẍicoj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ay xin cawan̈ ebnaj elkꞌom ah yin̈ culus yinta Comam, huneꞌ naj ah yin̈ iswatxꞌkꞌab Comam, huneꞌxa naj yin̈ ismeckꞌab. ");
INSERT INTO jacNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hac tuꞌ yu yijni isba tzet tzꞌibn̈ebilcano bay chala: “Alaxico naj xol ebnaj caw txꞌoj chiswatxꞌe,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Haꞌ xin anma chiecꞌto bay alaxcan̈ Comam yin̈ culus, chisbile iswiꞌ cat isbuchwa yin̈ Comam, chalni hacaꞌ tiꞌ: —Hach tiꞌ chawuchcꞌayo yatut Comam Dios cat hawanican̈ selel yin̈ oxeb tzꞌayic hawalni, ");
INSERT INTO jacNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","colilo haba yin̈ culus tiꞌ, cat hawaytij, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hacpax tuꞌ ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés, oc ebnaj yalaꞌ tet hunun: —Txꞌiꞌal mac iscol naj, wal naj xin mach chu iscolnilo isba naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ta chiscolilo isba naj yin̈ culus tiꞌ yin̈ cosat, wal tuꞌ chimjayto yul janma ta haꞌ naj Cristo Yahawil Israel, ẍi ebnaj. Hacpax tuꞌ ebnaj aycan̈ yin̈ culus yinta Comam tuꞌ, ocpaxo ebnaj buchwal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Haxa yet yapni yin̈ chumanil iskꞌejholilo sat yiban̈kꞌinal tiꞌ, yin̈xa chꞌen oxeb yin̈ kꞌejbiyal issajbilo hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yin̈ huneꞌ orahil tuꞌ ah yaw Comam, yalni yin̈ caw ip: —Eloi, Eloi, ¿lama sabactani? ẍi Comam. Haꞌ chal yelapnoj: Mamin, Mamin, ¿tzet yin̈ xin chinhanahuln̈etojan? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ay xin huntekꞌan ebnaj ayayo bey tuꞌ aben tzet yal Comam, yalni ebnaj: —Abewecꞌanab tzet chal naj, lan̈an yawten naj naj Elías, ischejab Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Isto huneꞌ naj yin̈ an̈e islabanayto huneꞌ esponja xol teꞌ pahla vino, yanico naj huneꞌ esponja tuꞌ yin̈ iswiꞌ huneꞌ teꞌ ah, yanahto naj yin̈ istiꞌ Comam yun̈e yucꞌni Comam. Yalni naj tet ebnaj ayco iscawilal tuꞌ: —Jilaꞌwej ta chihul naj Elías yikꞌalo naj yin̈ culus tiꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lahwi tuꞌ yah yaw Comam yin̈ caw ip, iscamiloj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wal huneꞌ kꞌap niman kꞌap aycan̈ yictabanil yatut Comam Dios, cab ayico kꞌap. Ichiti istzilbanil kꞌap yin̈ iswiꞌ masanta ayilo yin̈ yojtabanil. ");
INSERT INTO jacNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hayet yilni naj yahawil yin̈ ebnaj soldado tzet yuhi yet iscam Comam tuꞌ, yalni naj: —Caw yelticꞌabani, Iscꞌahol Comam Dios ye huneꞌ naj tiꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ay xin huntekꞌan ebix ix nahat yehilo ilni iscam Comam. Xol ebix tuꞌ ayco ix María ah Magdala yeb ix Salomé, yeb xin ix María ismiꞌ naj José yeb naj Jacobo, naj tzujan unin. ");
INSERT INTO jacNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Huntekꞌan ebix tuꞌ ecꞌ tzujtzun yinta Comam, iscolwapaxo ebix yin̈ Comam yet yecꞌ yul ismajul Galilea. Aypaxo haywan̈ ebix hun yu yapni yeb Comam bey Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Haꞌ yin̈ huneꞌ tzꞌayic tuꞌ xin chiswatxꞌecano anma Israel yin̈ tzettaj chiocnico yu yin̈ hunxa tzꞌayic, yuto hunxa tzꞌayic tuꞌ, tzꞌayic xewilal. Haxa yet lan̈anxa iskꞌejbayoj xin, ");
INSERT INTO jacNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","isto naj José iskꞌanno isnimanil Comam tet naj Pilato; caw mach xiw naj iskꞌanni isnimanil Comam. Naj José tuꞌ ah Arimatea naj, ayco naj xol ebnaj yahawil yin̈ lahtiꞌ xol ebnaj Israel, caw xin ay yelapno naj yul sat ebnaj. Echmabilpaxo yu naj yoc Comam Dios Yahawiloj. ");
INSERT INTO jacNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hayet yaben naj Pilato ta cam Comam, caw cꞌayilo iscꞌul naj, yawten naj naj yahawil yin̈ ebnaj soldado, iskꞌamben naj ta yeli camnaxa Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hayet yalni naj yahawil yin̈ ebnaj soldado ta xacam Comam, ischejni naj Pilato ta chiyiyti naj José tuꞌ isnimanil Comam yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hayet yaben naj xin, isto naj islokꞌno huneꞌ kꞌap sábana caw ay istohol, yinayti naj isnimanil Comam yin̈ teꞌ culus, ispichnico naj huneꞌ sábana tuꞌ yin̈ Comam; lahwi tuꞌ isto naj yanocto isnimanil Comam yul huneꞌ chꞌen chꞌen holbil. Yanicanico naj huneꞌ chꞌen chꞌen ismajilo istiꞌ bay alaxicto Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wal ix María Magdalena yeb ix María ismiꞌ naj José yil ebix bay alaxcanicto isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Haxa yet islahwi istzꞌayical xewilal xin, islokꞌni ix María ah Magdala yeb ix María ismiꞌ naj Jacobo, yeb ix Salomé huntekꞌan an̈ caw xukꞌ sam yu yanico ebix yin̈ isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Haxa yin̈ caw sahab sacꞌayal yin̈ babel tzꞌayic yin̈ semana xin, isto ebix bay mujlax Comam; haꞌ caw yahilo tzꞌayic yapni ebix bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yallen ebix tet hunun: —¿Mactaxca chiinilo chꞌen ayco ismajilo istiꞌ bay ayicto Comam? ẍi ebix. ");
INSERT INTO jacNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Haxa yet yilniti ebix matxa ayoco huneꞌ chꞌen niman chꞌen tuꞌ ismajilo bay alaxicto isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hayet yocto ebix yul chꞌen xin, yilni ebix huneꞌ naj tzeh tzꞌon̈anayo yin̈ cowatxꞌkꞌab yulicto chꞌen, caw sajhopon̈e xil iskꞌap naj aycoj, caw xin nimajal istel yoj xil iskꞌap naj tuꞌ. Caw xiwcan̈ ebix yet yilni ebix naj. ");
INSERT INTO jacNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yalni naj tet ebix: —Mach chexxiwi, wohtajan tato Comam Jesús ah Nazaret chesayicꞌoj, Comam alaxcan̈ yin̈ culus. Xaitzitzbican̈ Comam, matxa Comam bey tiꞌ. Ilwecꞌanab bay alaxicti Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","As halwe tet ebnaj iscuywom Comam yeb tet naj Pedro tato chibabi apno Comam bey Galilea tesataj, haꞌ bey tuꞌ xin cheyil yin̈ Comam hacaꞌticꞌa yu yalnicano teyet, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lahwi tuꞌ xin, yelti lemna ebix bey tuꞌ, isto ebix, toxan̈e xin chiluylun ebix yu xiwquilal. Machi mac tet xin yal ebix, yuto caw xiw ebix. ");
INSERT INTO jacNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hayet yitzitzbican̈ Comam yin̈ caw sahab sacꞌayalil yin̈ babel tzꞌayic yin̈ semana, haꞌ tet ix María ah Magdala bay isye isba Comam babel, ix bay yilo Comam hujwan̈ ischejab naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lahwi tuꞌ, isto ix yalno tet ebnaj ecꞌ tzujtzun yinta Comam ta isye isba Comam tet ix. Haꞌ ebnaj tuꞌ caw biscꞌulal ye ebnaj yeb xin caw chiokꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hayet yaben ebnaj ta itzitzbican̈ Comam yeb ta isye isba tet ix, caw mach yayto ebnaj yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tzujan tuꞌ xin, isyenipaxo isba Comam tet cawan̈ iscuywom yet lan̈an isto bey huneꞌ aldea; nan yu isyenipaxo isba Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Isto ebnaj cawan̈ tuꞌ yalno tet huntekꞌanxa ebnaj iscuywom Comam, yajaꞌ maẍticꞌa yapaxayto ebnaj yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Haxa yin̈ tzujanilxa xin isyeni isba Comam Jesús tet ebnaj hunlahon̈wan̈ iscuywom yet ayco ebnaj waꞌo sat meẍa, iscachlax ebnaj yu Comam yu chicabcon iscꞌul ebnaj; mach yayto ebnaj yul yanma yin̈ tzet yal ebnaj xailni ta xaitzitzbican̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yalnicano Comam tet ebnaj: —Asiꞌwe sunil yul sat yiban̈kꞌinal tiꞌ cat heyalnicꞌo Tzotiꞌ cꞌul yet colbanile tet sunil anma. ");
INSERT INTO jacNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Haꞌ mac chianayto yul yanma cat yahcano haꞌ iswiꞌ, chicolchahi, yajaꞌ wal mac mach chianayto yul yanma, chiay isyaꞌtajil yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Haꞌ huntekꞌan cꞌaybalcꞌule tiꞌ chioc yechelo tet mac chianayto yul yanma, chiyilo ebnaj ischejab naj matzwalil yin̈ anma yin̈ inbihan, cat istzotel ebnaj yin̈ nan abxubal. ");
INSERT INTO jacNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Waxan̈ca chistzab ebnaj noꞌ laba, waxan̈ca chiakꞌlax veneno yucꞌuꞌ ebnaj, matzet chu ebnaj. Hayet chanayo ebnaj iskꞌab yiban̈ anma yaꞌay, cat iscawxicanocan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lahwi yalnicano Comam Jesús sunil huntekꞌan tuꞌ tet ebnaj iscuywom, yilaxto Comam satcan̈, yoc tzꞌon̈no Comam yin̈ iswatxꞌkꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lahwi tuꞌ xin, isto ebnaj iscuywom Comam tuꞌ yalnocꞌo Istzotiꞌ Comam Dios sunil yul sat yiban̈kꞌinal. Caw xin ayco Comam Dios yetbiho ebnaj, yeb caw chioc yip tzotiꞌ chalicꞌo ebnaj tuꞌ yu ej cꞌaybalcꞌule yeb yu yechel yip Comam chisye ebnaj.");
INSERT INTO jacNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Tinan̈ xin, chintzꞌibn̈etojan huneꞌ carta tiꞌ tawet mam Teófilo, yin̈ huntekꞌan tzet ye tuꞌ xayu coxol tiꞌ. Haꞌ ebnaj chihalnicꞌo Istzotiꞌ Comam Jesucristo tinan̈ yil ebnaj yin̈ tzet yu yichicoj, lahwi tuꞌ xin con̈iscuynicanojan̈ ebnaj yin̈ sunil tzet xayu tuꞌ. Caw xin txꞌiꞌal mac xayaco yin̈ iscꞌul istzꞌibn̈encano tzet xayu tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Haquinpaxtuꞌan mam Teófilo, lahwi inkꞌambenan yin̈ nancꞌulal yin̈ sunil caw yichebanil, yoc yin̈ innabalan intzꞌibn̈entojan sunil tiꞌ yin̈ istxolal tawet. ");
INSERT INTO jacNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hac tuꞌ xin caw cꞌul chu hawohtan̈eniloj ta yel chal huntekꞌan xahacuy tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hayet ayco naj Herodes yahawilo txꞌotxꞌ Judea, ay hun majan ebnaj xol anma Israel chꞌakꞌni xahanbal tet Comam Dios, chiyij isbi Abías. Xol ebnaj tuꞌ ayco huneꞌ icham chiyij Zacarías, Elizabet isbi yixal icham. Yichmam ixnam ye icham Aarón. ");
INSERT INTO jacNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Caw cꞌul isbeybal icham yeb yixal yul sat Comam Dios, yeb xin caw yijem iscawan̈il yin̈ sunil ischejbanil Comam. Yuxin machi mac chu yalni tato mach yijemo icham yeb yixal sata Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wal ixnam Elizabet tuꞌ xin, maẍticꞌa yunin, yuxin machi hunu yuninal icham yeb ixnam yet yichambicaniloj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Haꞌ hunel xin, ayilo istiempohal bay oc icham Zacarías yin̈ ismunil yin̈ sacerdotehal yeb ebnaj yetbi yul yatut Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yilwen ebnaj mac yin̈ chꞌoc isbi yocto isn̈usno pom yiban̈ ismeẍahil bay chin̈uslax pom yul yatut Comam hacaꞌticꞌa chute ebnaj. Cꞌuxan xin yiban̈ icham Zacarías apni. ");
INSERT INTO jacNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yet lan̈an isn̈usni icham Zacarías pom tet Comam Dios yul yatut Comam tuꞌ, aycanilto sunil anma txahloj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hayet ayicto icham Zacarías isn̈usno pom tuꞌ, isyenican̈ isba huneꞌ yángel Comam Dios tet icham, yoc lin̈no yin̈ iswatxꞌkꞌab ismeẍahil bay chin̈uslax pom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yet yilni icham naj ángel tuꞌ, isxiwcan̈ icham, iscꞌaycanilo iscꞌul icham. ");
INSERT INTO jacNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yalni naj ángel: —Mam Zacarías, mach chaẍxiwcan̈, caw mayabe Comam Dios tzet maxawal yin̈ hatxah. Yu huneꞌ tuꞌ xin, chiyilaꞌ hawixal Elizabet yin̈ huneꞌ nichꞌan hacꞌahol, Juan chawaco isbihoj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Caw chitzala hacꞌul yin̈, caw niman anma chitzalapaxocan̈ yet chiyaben ispitzcꞌa nichꞌan heyuninal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Huneꞌ heyuninal chipitzcꞌa tuꞌ, caw aycano yelapno chꞌelico yul sat Comam Dios. Maẍticꞌa chucꞌuꞌ vino nitam hunuxa nan uqꞌuehal. Ayxaco Espíritu Santo yin̈ yet chipitzcꞌahi. ");
INSERT INTO jacNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Caw hanta ebnaj israelita chiswatxꞌeꞌco isba yul iskꞌab Comam Dios yu huneꞌ hacꞌahol tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Haꞌ naj Juan tuꞌ chibabito sata Comam Jahawil. Hacaꞌ ishelanil yeb yip yanma naj Elías ischejab Comam Dios yet payat, hac tuꞌ chꞌelico naj. Yu cuybanile chal naj chimeltzoco yanma ebnaj mame yeb ebix miꞌe yin̈ akꞌancꞌulal yeb yuninal. Yebpaxo anma man̈cꞌom chimeltzoco isnabal cat isyijenpaxo tzet chal Comam Dios. Hac tuꞌ chu iswatxꞌen isba anma, cat ischahni Comam, ẍi naj ángel tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Istakꞌwican̈ icham Zacarías tuꞌ: —¿Tzet xin chu wanaytojan yul wanmahan huneꞌ chawal tiꞌ? Yuto hanintiꞌan caw icham inxahan, caw xin ixnamxapaxo wixalan, ẍi icham. ");
INSERT INTO jacNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yalni naj ángel tuꞌ: —Hanintiꞌan Gabriel inan. Haꞌ Comam Dios maquinchejnitijan walnojan huneꞌ chejbanile caw cꞌul tiꞌ tawet. ");
INSERT INTO jacNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wal tinan̈ xin, chimajicano hatiꞌ. Matxa chiyu hatzotel tinan̈ masanto yet chijni isba yapni istiempohal ispitzcꞌa nichꞌan hacꞌahol, yuto machi maxawayto yul hawanma yin̈ tzet mawaltiꞌan, ẍi naj ángel tuꞌ tet icham Zacarías. ");
INSERT INTO jacNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wal anma chiꞌechman yelilo icham Zacarías tuꞌ xin, caw chicꞌay iscꞌul yuto caw ecꞌ istiempo icham yul yatut Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Haxa yet yelilo icham xol anma, caw matxa chu istzotel icham. Isnanilo anma tato ay huno tzet isye Comam Dios tet icham. Caw toxan̈e chisye icham yechel yu iskꞌab yin̈ tzet yelax tet, wal istzotel icham, matxa chuhi. ");
INSERT INTO jacNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hayet islahwi istiempohal ismunil icham yul yatut Comam Dios, ispaxto icham yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hayet isbelwi istzꞌayical tuꞌ xin ispitzcꞌati huneꞌ nichꞌan unin yin̈ ixnam Elizabet. Howeb ixahaw maẍticꞌa bay elto ixnam yul yatut. Chistxumni ixnam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Yu ishelanil Comam Dios yuxin hac tiꞌ wehan, yun̈e mach chiel inpixanan yuto maẍticꞌa huno wuninan, ẍi ixnam ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wajebxa ixahaw xin ischejniti Comam Dios naj ángel Gabriel bey con̈ob Nazaret ayco yul ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yapni naj iscꞌatan̈ huneꞌ ix kꞌopo, María isbi. Wal xin takꞌwebilxa mohyilal yu ix tet huneꞌ naj, José isbi, yichmam naj ye naj rey David. ");
INSERT INTO jacNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hayet yoc apno naj ángel yul n̈a bay ay ix, yalni naj tet ix: —Tzalahan̈ yuto ayco Comam Dios hawetbihoj. Caw niman iscꞌulchꞌanil Comam tawin̈ yuto sicꞌbilachilo xol hawet ixal, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hayet yaben ix tzet yal naj tuꞌ xin, iscꞌayilo iscꞌul ix, yichico ix istxumnilo hacaꞌ tiꞌ: —¿Tzet yelapno ye huneꞌ tiꞌ? ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yalnipaxo naj ángel tet ix: —María, mach chachxiwcan̈, yuto xaꞌilcha iscꞌulal hawu yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wal tinan̈ xin, chipitzcꞌahoti huneꞌ nichꞌan winaj unin tawin̈, haxa yet chipitzcꞌahi Jesús chawaco isbihoj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Caw ay yelapno chꞌelico naj, cat xin yalni anma ta Iscꞌahol Comam Dios ye naj. Haꞌ Iscꞌahol Comam Dios Jahawil tuꞌ chiꞌoco reyalil, hacaꞌ yu yoc naj rey David, yichmam naj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Haꞌ naj tuꞌ chiꞌoc yahawilo anma Israel yin̈ sunilbal tiempo. Machi bakꞌinal chilahwi huneꞌ ismunil naj tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Iskꞌamben ix María tet naj: —¿Tzet chu yijno isba huneꞌ chawal tiꞌ? Hanintiꞌan maẍto wichamilan, ẍi ix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yalni naj ángel tuꞌ tet ix: —Haꞌ Comam Espíritu Santo chiꞌayolo tawiban̈, yebpaxo yip Comam Dios caw ay ismay chiayilo tawiban̈ hacaꞌ hunu moyan. Yuxin haꞌ huneꞌ unin chipitzcꞌa tawin̈ tuꞌ, yet Dios yehi cat yallaxpaxoj ta Iscꞌahol Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hacaꞌ ixnam Elizabet hanoh, caw ixnamxa ixnam, yajaꞌ chiyilaꞌ ixnam yin̈ huneꞌ nichꞌan yunin. Wal xin ohtabil tato maẍticꞌa hunu unin xapitzcꞌati yin̈ ixnam, yaj wal tinan̈ wajebxa ixahaw iscꞌul ixnam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wal xin machi hunu tzet ye tuꞌ mach chu iswatxꞌen Comam, ẍi naj ángel tet ix. ");
INSERT INTO jacNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Istakꞌwican̈ ix María xin: —Hanintiꞌan ischejab Comam Dios Jahawil wehan, yubojab hacaꞌ maxawal tiꞌ, ẍi ix. Lahwi tuꞌ xin, ismeltzoto naj ángel. ");
INSERT INTO jacNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yin̈ huneꞌ tiempohal tuꞌ xin, yin̈ hamataj to ix María bey huneꞌ con̈ob chewal txꞌotxꞌ yul ismajul Judea. ");
INSERT INTO jacNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yapni ix bey yatut icham Zacarías, iskꞌamben ix hanicꞌ ye ixnam Elizabet. ");
INSERT INTO jacNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hayet yaben ixnam Elizabet istzotel ix María tuꞌ, isbili nichꞌan unin ijbilico yu ixnam. Hac tuꞌ yu yoccano ixnam yalan̈ yip Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yuxinto yal ixnam hacaꞌ tiꞌ yin̈ caw ip: —Hach tiꞌ María, caw niman iscꞌulal Comam Dios chakꞌ tawet sata sunil ebix jet ixal. Nimanpaxo iscꞌulal Comam chakꞌ tet huneꞌ hawunin chipitzcꞌaho tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tzet caw yelapno wehan yuxin mahul ismiꞌ Comam Wahawilan quinistucleꞌan? ");
INSERT INTO jacNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yet mawabenan hatzotelcan̈ mabili nichꞌan unin tiꞌ win̈an yu tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sakꞌal hawet yuto hawayto yul hawanma ta chij isba tzet yal Comam Dios, ẍi ixnam Elizabet. ");
INSERT INTO jacNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lahwi tuꞌ xin, yalni ix María: Caw chitzala wanmahan chiwalnihan cꞌulla tzotiꞌ yin̈ Comam Dios Jahawil, Comam caw aycano yip. ");
INSERT INTO jacNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Caw chitzalacano wanmahan yin̈ Comam Dios Incolomalan. ");
INSERT INTO jacNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Waxan̈ca mach nimano welapnojan, yajaꞌ Comam Dios chꞌanayo iscꞌulal wiban̈an. Yuxin chiyalaꞌ anma yin̈ sunilbal tiempo ta caw sakꞌal wetan yu ayayo iscꞌulal Comam wiban̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yuto haꞌ Comam Dios, caw aycano yip, haꞌ chiyenilo cꞌaybalcꞌule win̈an. Caw niman yelapno isbi Comam, caw machi nichꞌano istxꞌojal ayco yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sunilbal tiempo chitzꞌay iscꞌul Comam yin̈ sunil mac chixiw tet. ");
INSERT INTO jacNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Isyelo Comam yip, yuchcꞌanto Comam sunil tzet iswatxꞌe ebnaj chal isba can̈yehal. ");
INSERT INTO jacNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xaꞌel ebnaj yahaw con̈ob yul iscapil yu Comam, haxa ebnaj chewchotan̈e chute isba, yican̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xayakꞌnoho Comam iscꞌul ebnaj chin̈ohchahi, haxa ebnaj kꞌalom xin, occano ebnaj yin̈ man̈tzetal. ");
INSERT INTO jacNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xaꞌoc Comam jetbiho han̈on̈ Israel hon̈ tiꞌ, han̈on̈ ischejab Comam jehi, maẍticꞌa to nahul yu Comam, istzꞌay iscꞌul jin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hac tuꞌ yu yalnicano Comam tet ebnaj jichmam; tet icham Abraham, yeb xin tet huntekꞌanxa ebnaj ichmame titna yin̈ naj, ẍi ix María. ");
INSERT INTO jacNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Etza oxeb ixahaw beyicꞌo ix María iscꞌatan̈ ixnam Elizabet, ismeltzoto ix bey yatut hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hayet yapni istiempohal, ispitzcꞌa nichꞌan iswinaj unin ixnam Elizabet tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","yapni ebix ay iscawilal yatut ixnam yeb yicꞌal ixnam tzalaho yin̈ iscꞌulchꞌanil iscꞌul Comam Dios yakꞌ tet ixnam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yin̈xa iswaxajeb tzꞌayic xin, yet yakꞌlax circuncidar nichꞌan tzꞌul tuꞌ, yalni anma ta Zacarías chij isbi hacaꞌ isbi ismam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yalni ixnam miꞌe tuꞌ tet anma: —Machoj, Juan chiyij isbi naj, ẍi ixnam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yalni anma tet ixnam: —¿Tzet yuxin hac tuꞌ cheyakꞌ yijaꞌ isbi? Wal xol heyicꞌal machi hunu mac hac tuꞌ isbi, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yuxin eqꞌuiꞌco iskꞌab anma iskꞌamben tet icham Zacarías yin̈ tzet biꞌehal chiyakꞌ yijaꞌ iscꞌahol. ");
INSERT INTO jacNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Iskꞌanni icham huneꞌ nichꞌan akꞌinteꞌ, istzꞌibn̈enayo icham hacaꞌ tiꞌ: —Juan chiyij isbi huneꞌ nichꞌan unin tiꞌ, ẍiayoj. Toxan̈e cꞌaycanocan̈ iscꞌul sunil anma yet yabeni. ");
INSERT INTO jacNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lan̈antoticꞌa xin istzotelcan̈ icham Zacarías, yichi yalni icham cꞌulla tzotiꞌ yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iscꞌayilo iscꞌul sunil anma ayayo iscawilal yatut icham, ispujbalaxicꞌo huneꞌ tiꞌ bey sunil chewal txꞌotxꞌ yul ismajul Judea. ");
INSERT INTO jacNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sunil anma aben huntekꞌan tiꞌ chi-la-iskꞌamben tet hunun: —¿Tzettaxca caw chꞌeloco huneꞌ nichꞌan unin tiꞌ? ẍi anma. Hac tuꞌ yute yalni anma yuto ayco Comam Dios yetbiho nichꞌan unin tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wal icham Zacarías, ismam huneꞌ nichꞌan unin tuꞌ, oc icham yalan̈ yip Comam Espíritu Santo, yalni icham tzotiꞌ hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Hallaxojab tzotiꞌ cꞌul yin̈ Comam, Comam coDiosal han̈on̈ Israel hon̈ tiꞌ, yuto xahul Comam con̈iscoloꞌ han̈on̈ iscon̈obon̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yati Comam Dios huneꞌ Cocolomal caw aycano yip, huneꞌ Cocolomal tiꞌ titna yin̈ yuninal jichmam rey David, naj ischejab Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Huneꞌ tiꞌ halbilcano yu Comam Dios tet ebnaj ischejab sicꞌbililo yu yet payat: ");
INSERT INTO jacNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chon̈iscolilo Comam tet macta ayco ishowal jin̈ yeb xin macta chichiwa iscꞌul jin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yalnipaxoj ta chitzꞌay iscꞌul Comam yin̈ ebnaj jichmam, yeb maẍticꞌa chito nahul yu isyijen tzetticꞌa halbilcano tet ebnaj jichmam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Haꞌ huneꞌ tiꞌ halbilcano yu Comam Dios tet jichmam Abraham yetax payat. ");
INSERT INTO jacNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Yal Comam ta chon̈iscolilo yul iskꞌab ebnaj chichiwaco iscꞌul jin̈, haxinwal mach chon̈xiw jakꞌni chejaꞌ coba tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Cꞌulojab chijute cobeybal sata Comam, han̈eꞌojab yin̈ Comam ayco conabal sunilbal tiempo, ẍi icham. ");
INSERT INTO jacNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yalnipaxo icham Zacarías tuꞌ yin̈ iscꞌahol: Walach hach tiꞌ cꞌahol, chachoc ischejabo Comam Dios caw ay yip, yuto hach babel chaẍto sata Comam Jahawil. Yu hawatxꞌen isbeh Comam, haꞌ ton hacuyni yanico anma isnabal yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hach chawakꞌa yabe anma yin̈ tzet chu ischahni iscolbanil yet chꞌakꞌlaxcano tan̈o ismul yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yu caw chitzꞌay iscꞌul Comam Dios jin̈, yuxin hacaꞌ yahilo tzꞌayic, cat comujli yu, hac tuꞌ chu yul huneꞌ Cocolomal chejbilti yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yu yiniti issajilkꞌinal jet han̈on̈ ayico kꞌejholo yin̈ janma, yeb han̈on̈ ayon̈xaco yul iskꞌab naj camical. Haꞌ xin chon̈ijban con̈yanico yin̈ akꞌancꞌulal yeb Comam Dios, ẍi icham Zacarías. ");
INSERT INTO jacNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wal huneꞌ nichꞌan unin tuꞌ xin, hacaꞌticꞌa ischꞌib isnimanil, hacpax tuꞌ ischꞌib yitzꞌatil iswiꞌ yin̈ Comam Dios. Haxa yet istzehbican̈ naj, isto naj bey huneꞌ txꞌotxꞌ desierto, haꞌ tuꞌ ehayo naj masanto apni istiempohal yakꞌni yohtan̈elo isba naj tet con̈ob Israel. ");
INSERT INTO jacNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Haꞌ yin̈ huneꞌ tiempohal tuꞌ, yalni naj Augusto César, yahawil yeco yin̈ txꞌotxꞌ Roma, ta chꞌilaxcan̈ isbisil sunil anma ayco yalan̈ yip txꞌotxꞌ Roma. ");
INSERT INTO jacNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hayet yah huneꞌ babel isbisil anma tiꞌ haꞌ naj Cirenio ayco gobernadoral yul ismajul Siria. ");
INSERT INTO jacNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sunil anma to istzꞌunuꞌ isbi baytajtuꞌwal con̈ob titna yicꞌal. ");
INSERT INTO jacNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuxinto el naj José bey yul con̈ob Nazaret yul ismajul Galilea, isto naj bey Belén yul ismajul Judea, yuto haꞌ tuꞌ pitzcꞌana naj rey David, yichmam naj José tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yuxin to naj José yeb ix María, ix takꞌwebilxa ismohyi yeb naj, istzꞌunuꞌ isbi bey con̈ob Belén. Wal ix María tuꞌ, ayxa tzet ye ix. ");
INSERT INTO jacNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hayet ay naj yeb ix María bey Belén, yayilo istzꞌayical iswatxꞌi iscꞌul ix. ");
INSERT INTO jacNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yuxin haꞌ ta bey tuꞌ pitzcꞌa nichꞌan isbabel unin ix. Ispichnico ix istxow nichꞌan yunin tuꞌ, ishilbanayto ix yul ishucub no nokꞌ, yuto matxa hamanil yul waybal. ");
INSERT INTO jacNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bey iscawilal con̈ob Belén, ay huntekꞌan ebnaj tan̈en meꞌ; chiwayn̈en ismeꞌ sat chekꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Cꞌuxan xin isyecan̈ isba huneꞌ ángel tet ebnaj. Yaypaxo jopla iskꞌakꞌal yip Comam Dios yiban̈ ebnaj, isxiwcanocan̈ ebnaj xin. ");
INSERT INTO jacNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yalni naj ángel tet ebnaj: —Mach chexxiwi yuto ay huneꞌ tzotiꞌ caw cꞌul chinhulan walaꞌan teyet. Haꞌ huneꞌ chiwaltiꞌan istzalabal hecꞌul yeb istzalabal sunil anma. ");
INSERT INTO jacNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bey yul con̈ob Belén, iscon̈ob naj rey David, haꞌ tuꞌ mapitzcꞌa huneꞌ Hecolomal, haꞌ ton Comam Cristo, Comam Jahawil. ");
INSERT INTO jacNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Haꞌ tiꞌ chꞌakꞌno hetxumuloj, pichbilico istxow yin̈, hilanayto yul teꞌ hucub bay chalaxayto istelaj no nokꞌ, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lan̈antoticꞌa xin, isyenican̈ isba hun bulanxa ebnaj ángel iscꞌatan̈ naj babel tuꞌ. Istzabnico ebnaj isbitn̈en isbi Comam, chi-la-yalni ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Jalawe cꞌulla tzotiꞌ yin̈ Comam Dios ay yul satcan̈, ayojab akꞌancꞌulal sat txꞌo txꞌotxꞌ xol anma ochebil yu Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hayet ispaxto ebnaj satcan̈, yichico ebnaj tan̈em meꞌ yalni tet hunun: —Ton̈we bey Belén jilaꞌ huneꞌ mayu tuꞌ, huneꞌ mayakꞌ Comam Dios Jahawil johtan̈elo tiꞌ, ẍile ebnaj tet hunun. ");
INSERT INTO jacNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yin̈ an̈e xin, to ebnaj yilaꞌ. Hayet yapni ebnaj xin, yilchayo ix María yeb naj José, yeb nichꞌan neneꞌ ayayto yul ishucub no nokꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yet yilnico ebnaj yin̈ nichꞌan neneꞌ tuꞌ xin, istzabloco yalni ebnaj tet sunil anma tzet hallax tet ebnaj yu naj ángel yin̈ huneꞌ nichꞌan neneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sunil anma aben huntekꞌan yal ebnaj tan̈em meꞌ tuꞌ, caw cꞌaycanocan̈ iscꞌul anma yabeni. ");
INSERT INTO jacNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wal ix María xin, ton̈e iscꞌubacano ix yul yanma yin̈ huntekꞌan tzet yal ebnaj, chi-la-ecꞌ yin̈ isnabal ix yin̈ tzet caw yehi. ");
INSERT INTO jacNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wal ebnaj tan̈em meꞌ, hayet ispaxto ebnaj yichico ebnaj yanico ismay Comam Dios, yakꞌnipaxo ebnaj yuchꞌandiosal tet Comam yin̈ tzet yabeꞌ ebnaj, yeb xin yu tzet bey ebnaj yilaꞌ, yuto hacaꞌticꞌa yu yallax tet ebnaj hac tuꞌ elicoj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hujebxa tzꞌayic ispitzcꞌa nichꞌan Jesús tuꞌ, yalaxico yechel isnimanil, huneꞌ chiyij circuncisión. Jesús yijcano isbi hacaꞌ yu yalnicano naj ángel tet ix yet maẍto chipitzcꞌati nichꞌan unin yin̈ ix. ");
INSERT INTO jacNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yet yayilo istzꞌayical bay chisajn̈e isba ebix hacaꞌ yalni isley naj Moisés, yinito naj José yeb ix María nichꞌan neneꞌ tuꞌ yelaxo tet Comam Dios bey Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Isyije naj yeb ix hacaꞌ tuꞌ yuto tzꞌibn̈ebilcano yul Yum Comam Dios hacaꞌ tiꞌ: “Haꞌ niẍte winaj unin chibabel pitzcꞌahi, chiꞌakꞌlax tet Comam Dios Jahawil,” ẍi yul Yum Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yinito naj yeb ix isxahanbal hacaꞌ yalni isley naj Moisés bay chala: “Caw yilal yakꞌni cacꞌon̈ noꞌ palamuch maca cacꞌon̈ noꞌ mucꞌ,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yul con̈ob Jerusalén, yin̈ huneꞌ tiempohal tuꞌ, ay huneꞌ icham chiyij isbi Simeón, caw cꞌulcano isbeybal icham, han̈echꞌan tet Comam Dios bay chiyiyo isba. Echmabiln̈eticꞌa yul Iscolomal con̈ob Israel yu icham. Ayco Comam Espíritu Santo yin̈ ichmam. ");
INSERT INTO jacNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Haꞌ chꞌakꞌni nachaholo yu tato maẍto chicami masanto chiyilico yin̈ Comam Cristo, Comam chejbilti yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ayxacto icham Simeón tuꞌ yul yatut Comam Dios yu Comam Espíritu Santo yet yapni naj José yeb ix María yeb nichꞌan Jesús. Apni iscawan̈il yul yatut Comam tuꞌ yu isyijen tzet tzꞌibn̈ebilcano yin̈ ischejbanil ebnaj Israel yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ischelnilo icham Simeón nichꞌan neneꞌ tuꞌ, yalni icham cꞌulla tzotiꞌ tet Comam Dios hacaꞌ tiꞌ: Mamin, hachejab wehan. Wal tinan̈ xin, xayu incaman ");
INSERT INTO jacNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","yuto mayij isba tzet halbilcano hawu wetan. ");
INSERT INTO jacNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yuto mawilicojan yu insatan yin̈ Cocolomalan̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Haꞌ huneꞌ mac tiꞌ chawacanico yin̈ sat sunil anma ay yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Haꞌ xin chꞌakꞌno sajbolo yanma hanta anma mach Israeloj, cat xin isbinahocano con̈ob Israel yu Cocolomalan̈ tiꞌ, ẍi icham Simeón tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Caw xin, cꞌaycan̈ iscꞌul naj José yeb ix María yet yaben sunil tzotiꞌ caw cꞌul yal icham Simeón yin̈ naj neneꞌ tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lahwi tuꞌ xin, iskꞌannicano icham Simeón iscꞌulal iscꞌul Comam Dios yiban̈. Yalni naj tet ix María: —Naj nichꞌan tiꞌ caw ixtan̈xa yehi ta caw hantan̈e anma Israel chicꞌayoꞌto yanma yu naj, yaj caw ixtan̈xa yepaxo tato caw hantan̈e anma Israel chiswatxꞌeꞌpaxo isbeybal yu naj. Haꞌ naj chiyenolo tzet chiyub iscolchaho anma xol istxꞌojal, yaj xin caw ay anma chiyahno naj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hac tuꞌ xin chu yixtan̈wicanilo tzet chꞌecꞌ yul isnabal anma yeb tzet chꞌecꞌ yul yanma anma. Walach hach tiꞌ, chꞌayolo huneꞌ tzꞌayic yet caw chiꞌoco biscꞌulal yin̈ hawanma yu naj neneꞌ tiꞌ. Hacaꞌ isyaꞌil chispolto huno chꞌen espada, hac tuꞌ isyaꞌil chꞌelico hawanma, ẍicano icham Simeón tet ix María. ");
INSERT INTO jacNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bey yul yatut Comam Dios tuꞌ xin, haꞌ tuꞌ ayicto huneꞌ ixnam chitzotel yu yip Comam Dios. Huneꞌ ixnam tuꞌ, Ana isbi, iscutzꞌin naj Fanuel, titna yin̈ yuninal naj Aser. Yet kꞌopo ixnam yikꞌni ixnam yichamil, yaj hujeb chꞌan habil yikꞌle isba naj yeb ix, iscam naj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Caw xin ochenta y cuatro habilxa iscancano ixnam hunixal. Tzꞌayic akꞌbal ayn̈eticꞌacto ixnam yul yatut Comam Dios yu istxahli yeb yu yinayo isba tet Comam. Caw xin chisyijepaxo ixnam huneꞌ yet mach chon̈waꞌi yu cotxahli tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yapni ixnam iscꞌatan̈ naj José yeb ix María, yakꞌni ixnam yuchꞌandiosal tet Comam Dios. Lahwi tuꞌ xin, istzabloco yalnicꞌo ixnam cuybanil yin̈ naj neneꞌ tuꞌ tet sunil anma chꞌechman yul iscolbanil con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hayet islahwi isyijencano naj José yeb ix María yin̈ tzet chal ischejbanil ebnaj Israel yu Comam Dios, ispaxto naj yeb ix bey iscon̈ob Nazaret yul ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wal nichꞌan unin tuꞌ xin, caw sakꞌal ischꞌibi, caw chꞌocpaxo yip isnimanil yeb yitzꞌatil iswiꞌ. Caw xin ayayo iscꞌulchꞌanil iscꞌul Comam yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hunun habil isbeycꞌo ismam ismiꞌ nichꞌan Jesús yul yatut Comam Dios bey con̈ob Jerusalén yin̈ kꞌin̈ Pascua. ");
INSERT INTO jacNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Haxa yet istzꞌajna naj nichꞌan Jesús yin̈ iscablahon̈eb habil, isto naj yinta ismam yeb ismiꞌ yin̈ kꞌin̈ hacaꞌ chu isbeyicꞌo anma yin̈ hunun habil. ");
INSERT INTO jacNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lahwin̈e kꞌin̈ tuꞌ xin, ismeltzoto naj José yeb ix María. Wal naj nichꞌan Jesús, cancano naj bey yul con̈ob Jerusalén, yajaꞌ mach yohtajo ismam naj yeb ismiꞌ naj tato cancano naj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Haꞌ yalni ismam naj yeb ismiꞌ naj ta paxto naj xol anma ilom kꞌin̈. Huneꞌ tzꞌayicxa isbelwito ismam yeb ismiꞌ naj, yoc ismam yeb ismiꞌ naj issaynoyo naj xol yicꞌal yeb xol mac ohtan̈e nichꞌan Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yajaꞌ maẍticꞌa ilcha naj, yuxin meltzoto naj José yeb ix María saywal yin̈ naj bey yul con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Haxa yet yox tzꞌayic xin, yilchati naj nichꞌan tuꞌ yul yatut Comam Dios yu ismam yeb ismiꞌ. Tzꞌon̈anicto naj xol ebnaj ichamta winaj caw yahawil yin̈ iscuyni anma yin̈ isley naj Moisés. Caw ayco naj nichꞌan Jesús tuꞌ yaben tzet chal ebnaj, chiskꞌambenpaxo naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wal xin, caw chicꞌay iscꞌul ebnaj chiꞌaben tzet chiyal naj nichꞌan Jesús tuꞌ yuto caw helan naj, yeb xin caw cꞌul ispaj istzotiꞌ ebnaj chiyakꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Haxa yet yilcha naj yu ismam yeb ismiꞌ, caw cꞌayilo iscꞌul. Yalni ismiꞌ naj tet: —Wunin, ¿tzet yin̈ yuxinto hac tiꞌ chon̈hawutehan̈? Haninan yeb hamam caw biscꞌulal jehan̈ cachcosaynicꞌojan̈, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Istakꞌwican̈ naj nichꞌan Jesús: —¿Tzet yin̈ nan bay chinhesayicꞌojan? ¿Tom mach heyohtajo tato yul yatut Inmaman caw yilal incanan? ẍi naj tet ismiꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wal xin machi txumchalo yu ismam yeb ismiꞌ yin̈ tzet chalilo huneꞌ yal naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lahwi tuꞌ xin, ismeltzo naj yinta ismam yeb ismiꞌ bey yul con̈ob Nazaret. Caw xin yijem naj tet ismam yeb tet ismiꞌ. Ton̈e xin iscꞌuba ismiꞌ naj yin̈ yanma yin̈ huntekꞌan tuꞌ, chistxumni ix yin̈ tzet yelapno yehi. ");
INSERT INTO jacNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Wal naj nichꞌan Jesús tuꞌ xin, hacaꞌ ischꞌib isnimanil, hac tuꞌ ischꞌibpaxo yitzꞌatil iswiꞌ naj. Caw chitzala yanma Comam Dios yin̈ naj, caw chitzalapaxo anma yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ayxaco yin̈ isholan̈eb habil yoc naj Tiberio yahawilo Roma, walpaxo naj Poncio Pilato, haꞌ naj ayco gobernadoral yin̈ txꞌotxꞌ Judea, haxapaxo xin naj Herodes ayco gobernadoral yin̈ txꞌotxꞌ Galilea. Haxa yuẍta naj chiyij Felipe, haꞌ naj ayco gobernadoral yin̈ huneꞌxa txꞌotxꞌ chiyij Iturea yeb txꞌotxꞌ Traconite. Haxa naj Lisanias, ayco naj gobernadoral yin̈ txꞌotxꞌ Abilinia. ");
INSERT INTO jacNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wal naj Anás yeb naj Caifás, haꞌ ebnaj ayco yahawilo yin̈ sacerdote Israel. Hayet huneꞌ tiempohal tuꞌ xin, naj Juan iscꞌahol icham Zacarías, ay naj bey huneꞌ txꞌotxꞌ desierto. Haꞌ tuꞌ xin tzotel Comam Dios tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yu tzet yal Comam Dios tet naj, yuxin to naj bey sunilej txꞌotxꞌ ayco istila haꞌ niman Jordán. Yalni naj tet anma tato caw yilal isbejnicano sunil ismachiswalilal, cat yahcano haꞌ iswiꞌ; hac tuꞌ xin chu yakꞌnicano nimancꞌulal Comam Dios yin̈ ismul anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hac tiꞌ yu yijnicano isba tzet tzꞌibn̈ebil yu naj Isaías, ischejab Comam Dios yet payat, bay chala: Ay huneꞌ naj chiawi yin̈ caw ip bey huneꞌ txꞌotxꞌ desierto, chihalni hacaꞌ tiꞌ: “Watxꞌeweco heyanma, yuto chihul Comam Dios Jahawil. Hacaꞌ chu istoholban̈elax hunu beh yet chihul huno naj yahaw, hac tuꞌ cheyute heyanma. ");
INSERT INTO jacNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hacaꞌ isnohtzelax nimeta hocan, hacaꞌ iskꞌajlaxayo nimeta witz yun̈e yacꞌalbiloj, yeb xin iswon̈quiẍtajil. Hacaꞌ istoholban̈elaxico huntekꞌan beh cótxquiltan̈e yeqꞌui, hacaꞌ chu yacꞌaln̈elax huntekꞌan beh hopquiẍtan̈e, ");
INSERT INTO jacNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","hac tuꞌ cheyute heyanma haxinwal chiillax yu sunil anma ta ay huneꞌ Hecolomal chejbilti yu Comam Dios,” ẍi naj, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Caw niman anma apni iscꞌatan̈ naj Juan tuꞌ yu yah haꞌ iswiꞌ, yalni naj tet anma: —Walex hex tiꞌ, caw hacaꞌtan̈e heyicꞌal heba yeb noꞌ laba. ¿Mac chihalni teyet ta yu chꞌah haꞌ hewiꞌ chexcolcha yalan̈ huneꞌ niman isyaꞌtajil chihul teyiban̈ yu ishowal Comam Dios? ");
INSERT INTO jacNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wal xin bejwecano istxꞌojal, yeb xin caw yilal cꞌul cheyute heba, hac tuꞌ chu heyeniloj ta xahelcha henabal. Tajca chetxum hacaꞌ tiꞌ: “Yin̈ icham Abraham titnajon̈, yuxin xacon̈colchahan̈ yalan̈ isyaꞌtajil chati Comam Dios,” tajca quexchi. Wal xin chisje iswatxꞌenico Comam huntekꞌan chꞌen chꞌen tiꞌ anmahil, cat xin yoc yuninalo icham Abraham heseleloj, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yalnipaxo naj Juan: —Haꞌ huneꞌ niman isyaꞌtajil lan̈an yul teyiban̈, lahan hacaꞌ huno te teꞌ ayxaco chꞌen eche yich xeꞌ yu iskꞌajlaxayoj. Yuto sunil te teꞌ mach cꞌulu sat chiyakꞌa, chitzocꞌlaxcan̈ teꞌ, cat yocto teꞌ yul kꞌaꞌ, ẍi naj Juan tet anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Istakꞌwi anma: —¿Tzet wal juten cobahan̈, chal tuꞌ? ẍi anma tet naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yalni naj xin: —Ta ayex ay cabebo hecamiẍ, akꞌwe hunu tet hunu mac machi yet, yebpaxo xin hacaꞌ hex ay tzet chelo, akꞌwe nichꞌano tet mac machi yet, ẍi naj tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aypaxo xin haywan̈ ebnaj ikꞌomilo tohlabal chꞌen chito bey Roma, apni ebnaj iscꞌatan̈ naj Juan tuꞌ yu yah haꞌ iswiꞌ. Yoc ebnaj iskꞌambeno hacaꞌ tiꞌ: —Mam cuywawom, ¿tzet wal juten cobahan̈ yun̈e cowatxꞌicojan̈ yul sat Comam Dios? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Istakꞌwi naj Juan tuꞌ: —Hayet chexecꞌ heyikꞌalo chꞌen tohlabal yin̈ anma, hacaꞌticꞌa yalni ley, hac tuꞌ cheyiloj, ẍi naj Juan tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yapnipaxo huntekꞌan ebnaj soldado iskꞌamben ebnaj: —Haxapaxo han̈on̈tiꞌan̈, ¿tzet wal juten cobahan̈? ẍi ebnaj. Istakꞌwi naj Juan tuꞌ xin: —Mach chebalcan̈ tzotiꞌ yiban̈ anma, mach cheyelkꞌalo tzettaj ay yul iskꞌab anma. Tzalahojab hecꞌul yin̈ hetohol chꞌakꞌlaxi, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Haꞌ anma apni abeno tuꞌ xin, ichico isnanonico iscꞌul yin̈ naj Juan cꞌuxan ta haꞌ naj chiyij Cristo echmabil yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yalni naj tet sunil anma: —Wal intiꞌan, yin̈ caw yeli cachann̈e chiwacan̈an haꞌ hewiꞌ, yajaꞌ wintajan chihul huneꞌ naj chiyacan̈ naj haꞌ hewiꞌ yaj yu iskꞌakꞌal yip Comam Espíritu Santo. Caw xin ecꞌbalcano yip naj insatajan, yuxin caw mach chu wocan inpuhnolojan istxꞌan̈al isxan̈ab naj chiwabehan, ẍi naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yalnipaxo naj: —Naj chihul tuꞌ, lahan naj hacaꞌ huno naj chixunilo iskꞌal ixim trigo, nan chakꞌcano naj yoj ixim, haxa ixim sat xin chiscꞌubato naj ixim yul iscꞌun̈a. Haxa ixim yoj trigo tuꞌ xin, chiskꞌojto naj ixim xol kꞌa kꞌaꞌ mach istan̈bal, ẍi naj tet sunil anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Caw txꞌiꞌal cuybanil yakꞌcano naj Juan tet anma, hac tuꞌ yu yalnicꞌo naj Tzotiꞌ cꞌul yet colbanile. ");
INSERT INTO jacNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Caw cachwa naj Juan yin̈ naj Herodes, ayco gobernadoral bey tuꞌ yuto yikꞌcan̈ naj ix Herodías, yixal yuẍtaj, haꞌ ton naj Felipe, yebpaxo xin yu sunil istxꞌojal iswatxꞌe naj. ");
INSERT INTO jacNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yajaꞌ maẍn̈etaj huntekꞌan istxꞌojal iswatxꞌe naj Herodes tiꞌ, to yapaxicto naj naj Juan yul preso. ");
INSERT INTO jacNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hayet maẍto chꞌocto naj Juan yul preso, yet yah haꞌ iswiꞌ anma yu naj ahpaxo haꞌ iswiꞌ Comam Jesús yu naj. Hayet lan̈an istxahli Comam tuꞌ, ishajni isba satcan̈, ");
INSERT INTO jacNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","yayilo Comam Espíritu Santo yiban̈ Comam hacaꞌ hunu noꞌ palamuch. Lan̈antoticꞌa xin yabelax huneꞌ yul nukꞌe satcan̈, yalni hacaꞌ tiꞌ: —Hach tiꞌ hach Incꞌaholan, caw xahan ayach wuhan. Caw chintzalahan tawin̈, ẍiaytij. ");
INSERT INTO jacNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lahon̈ebxa iscawinah habil Comam Jesús yet yichico ismunla yin̈ Istzotiꞌ Comam Dios. Iscꞌahol naj José ye Comam chute yalni anma. Hac tiꞌ caw ye istxolal yichmam Comam hacaꞌ tiꞌ: naj José, naj Elí, ");
INSERT INTO jacNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","naj Matat, naj Leví, naj Melqui, naj Jana, naj José, ");
INSERT INTO jacNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","naj Matatías, naj Amós, naj Nahum, naj Esli, naj Nagai, ");
INSERT INTO jacNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","naj Maat, naj Matatías, naj Semei, naj José, naj Judá, ");
INSERT INTO jacNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","naj Joana, naj Resa, naj Zorobabel, naj Salatiel, naj Neri, ");
INSERT INTO jacNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","naj Melqui, naj Adí, naj Cosam, naj Elmodam, naj Er, ");
INSERT INTO jacNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","naj Josué, naj Eliezer, naj Jorim, naj Matat, ");
INSERT INTO jacNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","naj Leví, naj Simeón, naj Judá, naj José, naj Jonán, naj Eliaquim, ");
INSERT INTO jacNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","naj Melea, naj Mainán, naj Matata, naj Natán, ");
INSERT INTO jacNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","naj David, naj Isaí, naj Obed, naj Booz, naj Salomón, naj Naasón, ");
INSERT INTO jacNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","naj Aminadab, naj Admin, naj Aram, naj Esrom, naj Fares, naj Judá, ");
INSERT INTO jacNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","naj Jacob, naj Isaac, icham Abraham, naj Taré, naj Nacor, ");
INSERT INTO jacNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","naj Serug, naj Ragau, naj Peleg, naj Heber, naj Sala, ");
INSERT INTO jacNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","naj Cainán, naj Arfaxad, naj Sem, naj Noé, naj Lamec, ");
INSERT INTO jacNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","naj Matusalén, naj Enoc, naj Jared, naj Mahalaleel, naj Cainán, ");
INSERT INTO jacNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","naj Enós, naj Set, naj Adán. Haꞌ naj Adán tuꞌ xin, Comam Dios watxꞌen̈e naj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Lahwi yah haꞌ iswiꞌ Comam Jesús, yel Comam istiꞌ haꞌ niman Jordán. Ayco Comam yalan̈ yip Comam Espíritu Santo yet isto Comam bey huneꞌ txꞌotxꞌ desierto. ");
INSERT INTO jacNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Haꞌ tuꞌ ehayo Comam cawina tzꞌayic, maẍticꞌa xin waꞌi. Lahwi tuꞌ xin yoc naj matzwalil yilweno Comam yun̈e yanico ismul yuto caw xan̈ohcha Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yalni naj matzwalil tet Comam: —Tato Iscꞌahol Comam Dios hawehi, hal tet huneꞌ chꞌen chꞌen tiꞌ meltzojabico chꞌen wahil, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Istakꞌwican̈ Comam tet naj matzwalil tuꞌ xin: —Yul Yum Comam Dios tzꞌibn̈ebilcanoj: “Maẍn̈etaj yu tzet chicolo yuxin ay cokꞌinal, to yupaxo Istzotiꞌ Comam,” ẍiayoj, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lahwi tuꞌ xin, yilaxto Comam yu naj matzwalil bay caw nahat yecanocan̈, lembiln̈e xin isyeni naj sunilej txꞌotxꞌ nimeta con̈ob ay yul sat yiban̈kꞌinal tiꞌ yeb iskꞌalomal txꞌotxꞌ tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lahwi tuꞌ xin yalni naj matzwalil tet Comam: —Chachwakꞌacojan yahawo sunil huntekꞌan txꞌotxꞌ con̈ob tiꞌ yeb yin̈ iskꞌalomal. Haꞌ huntekꞌan tiꞌ akꞌbilico yul inkꞌaban, yuxin chisje wakꞌnihan tet mac bay choche incꞌulan. ");
INSERT INTO jacNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ta chachay jahno insatajan, cat hawinayo haba wetan, chiwakꞌaꞌan sunil huntekꞌan tiꞌ tawet, cat yoccano hawu, ẍi naj matzwalil tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Istakꞌwican̈ Comam Jesús tet naj matzwalil tuꞌ: —Chal Comam Dios yul Yum hacaꞌ tiꞌ: “Han̈echꞌan wetan chu heyinayo heba, yuto heyahawil yeb heDiosalpaxo wehan, yeb han̈echꞌan wetan cheyije,” ẍiayoj, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lahwi tuꞌ xin, yilaxto Comam yul con̈ob Jerusalén yu naj matzwalil. Yinahto naj Comam yin̈ iswiꞌ yatut Comam Dios, yalni naj: Ta caw yeli Iscꞌahol Comam Dios hawehi, kꞌojayto haba bey tiꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","yuto chal Comam Dios yul Yum: Chiwakꞌaꞌtojan ebnaj ángel cachistan̈eꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yun̈e mach chachischayo ebnaj sat txꞌotxꞌ yun̈e mach chilahwi hawoj yin̈ chꞌen chꞌen, ẍiayoj, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Istakꞌwican̈ Comam tet naj: —Yaj halbilpaxo yul Yum Comam Dios: Mach chinheyacojan yin̈ ilwebal yuto heyahawil wehan, yeb xin heDiosal wepaxojan, ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yet yilni naj matzwalil ta matxa hunuxa tzet bay chu issubcha Comam Jesús yu naj, isbejnicano naj Comam hanicꞌ tiempohal. ");
INSERT INTO jacNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lahwi tuꞌ xin ismeltzopaxto Comam Jesús bey Galilea, ayco Comam yalan̈ yip Comam Espíritu Santo. Sunil yul ismajul Galilea tuꞌ pujnacan̈ yabelaxilo Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iscuyni Comam anma yul hunun con̈ob yul iscapilla ebnaj Israel, caw sunil anma halni cꞌulla tzotiꞌ yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lahwi tuꞌ xin, isto Comam Jesús bey con̈ob Nazaret bay chꞌibcan̈. Hayet istzꞌayical xewilal yocto Comam yul iscapilla ebnaj Israel hacaꞌticꞌa chu isbey Comam yin̈ hunun tzꞌayic xewilal. Yah lin̈no Comam bay chꞌoc lin̈no ebnaj ijbalon̈ chꞌilni Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yakꞌlax teꞌ hum tet Comam, teꞌ hum tzꞌibn̈ebilcano yu naj Isaías, huneꞌ ischejab Comam Dios yet payat. Isholnito Comam teꞌ xin, yilchalo yu Comam bay chal hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ayco Yespíritu Comam Dios Jahawil win̈an, sicꞌbil incan̈an yu walnihan tzotiꞌ cꞌul tet anma matzet ayco yipo yanma. Akꞌbilintijan yu Comam yu walnihan colbanile tet macta ayicto yul preso, yeb yu wakꞌnipaxojan issajilkꞌinal yilaꞌ macta mach chu yilni, yeb yu inbejtzonan mac ayco yalan̈ isyaꞌtajil. ");
INSERT INTO jacNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Quinyatijan walaꞌan ta chꞌayilo istiempohal iscolnilo Comam Dios iscon̈ob, ẍiayoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lahwi tuꞌ xin, ischulnipaxcanayo Comam Jesús teꞌ hum tuꞌ, yakꞌni Comam teꞌ tet naj ay ismunil yul iscapilla ebnaj Israel tuꞌ, yay tzꞌon̈no Comam. Sunil anma ayicto bey tuꞌ, occano tꞌan̈no yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yichico Comam yalnilo tet anma hacaꞌ tiꞌ: —Haꞌ yin̈ huneꞌ tzꞌayic tiꞌ, yin̈ hesat mayijcano isba tzet tzꞌibn̈ebilcano yin̈ teꞌ hum tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wal xin sunil anma caw cꞌul istzotel yin̈ Comam Jesús. Caw cꞌayilo iscꞌul yuto cꞌulchꞌan istzoteli. Yichico anma yalni tet hunun: —¡Yaj iscꞌahol naj José ye naj tiꞌ! ¿Tzet xin chu yalni naj hacaꞌ ti? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yuxin yal Comam tet anma: —Hex tiꞌ, ¿chimheyalaꞌ wetan yin̈ huneꞌ tzotiꞌ chal anma?: “Hach an̈tem anma, an̈tecano haba,” ẍi. Chimheyalpaxoj: “Jabehan̈ tzettaj ye tuꞌ hawatxꞌe bey Capernaum, yuxin watxꞌe huneꞌ tuꞌ yul hacon̈ob tiꞌ,” quexchimi wetan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yalnipaxo Comam: —Yin̈ caw isyelal chiwalan teyet, machi huno ischejab Comam Dios xahan chiꞌillax yu yet con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Naweti yin̈ istiempohal naj Elías, ischejab Comam Dios payat. Caw yicta yox habil machi yakꞌ n̈ab, yuxin hul huneꞌ niman wahil yiban̈ anma sunil. Yet huneꞌ tiempohal tuꞌ, tzetcꞌa ebix hunix jet Israelal, ");
INSERT INTO jacNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yaj maẍtaj yin̈ ebix tuꞌ alaxti naj Elías colwal yu Comam wal xin han̈echꞌan yin̈ huneꞌ ix mach Israeloj, huneꞌ ix ay bey con̈ob Sarepta yul ismajul Sidón. ");
INSERT INTO jacNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nawepaxti yin̈ huneꞌxa ischejab Comam Dios chiyij Eliseo. Yin̈ istiempohal naj, tzetcꞌa jet con̈ob Israel tzabchati yu huneꞌ yabil chiyij lepra; yaj machi hunu ebnaj tuꞌ yakꞌ cawxo naj Eliseo. Han̈echꞌan huneꞌ naj mach Israeloj chiyij Naamán ay yul ismajul Siria, han̈echꞌan naj tuꞌ yakꞌ cawxo naj, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hayet yaben ebnaj ayicto yul capilla tuꞌ yin̈ tzet yal Comam, caw tit ishowal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yah lin̈no ebnaj, yoc tzabno ebnaj yin̈ Comam, yinito ebnaj Comam yin̈ istxam con̈ob yin̈ iswiꞌ huneꞌ witz bay ayco con̈ob tuꞌ yu istennicanto ebnaj Comam sat huneꞌ pahaw yalni. ");
INSERT INTO jacNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yaj wal Comam Jesús palan̈ yecꞌto Comam xolbal ebnaj, isto Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lahwi tuꞌ xin, isto Comam Jesús yul con̈ob Capernaum yul ismajul Galilea. Iscuyni Comam anma yin̈ hunun tzꞌayic xewilal yul iscapilla ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Caw xin chicꞌay iscꞌul anma yaben iscuywa Comam, yuto caw haban isyenilo isba ta caw akꞌbil yip yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yul capilla tuꞌ ayicto huneꞌ naj ayco ischejab naj matzwalil yin̈, yah yaw naj yin̈ caw ip, yalni naj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Tzet hawoc jin̈an̈ ach Jesús ah Nazaret? ¿Tom chaẍhul con̈hatan̈tzelojan̈ hawalni? Wohtajan mac anmahilach hach tiꞌ, machi nino istxꞌojal ayco tawin̈, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iscachwa Comam yin̈ ischejab naj matzwalil tuꞌ: —¡Cach hatiꞌ, elan̈ yin̈ naj! ẍi Comam. Lahwi tuꞌ xin, iskꞌojlaxayo naj sat txꞌotxꞌ yu ischejab naj matzwalil sata sunil anma. Yel ischejab naj matzwalil yin̈ naj, yaj machi islahwilal naj oqui yet iskꞌojlaxayo naj. ");
INSERT INTO jacNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Caw cꞌayilo iscꞌul sunil anma yilni, yalob tan̈en anma tet hunun: —¿Tzet tzotiꞌal mayal naj tiꞌ? ¡Caw aycano yip istzotiꞌ naj! ¡Caw chiyijelax tzet chal naj, yet chalni naj ta chꞌel ischejab naj matzwalil yin̈ anma, yin̈ an̈e chꞌel ebnaj! ẍi anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sunil yul ismajul huneꞌ con̈ob tuꞌ yeb ej ishoyanil, pujnacꞌo isbi ta ay yip Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hayet yelti Comam Jesús yul capilla tuꞌ, isto Comam yatut naj Simón. Caw ay kꞌaꞌ yin̈ ismiꞌ yixal naj, yuxin kꞌanlax tet Comam ta chakꞌ cawxo Comam ixnam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ishitzico Comam iscꞌatan̈ ixnam, yinilo Comam huneꞌ kꞌaꞌ tuꞌ yin̈ ixnam, iscawxican̈ ixnam. Hunepixto xin yahwano ixnam, iswatxꞌen ixnam tzet chislo Comam yeb iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hayet lan̈an isto tzꞌayic xin, sunil anma beycꞌo yakꞌaꞌcano isyawub tet Comam, tzitamlah yabilal ayco yin̈. Hayet chanayo Comam iskꞌab yiban̈ anma yaꞌay tuꞌ, cat iscawxicanocan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tzetcꞌa anma ayco ischejab naj matzwalil yin̈ cawxican̈, toxan̈e chꞌel yaw ebnaj yet chꞌelcano ebnaj yin̈ anma, chalni ebnaj hacaꞌ tiꞌ: —Hach tiꞌ, Iscꞌahol Comam Dios hawehi, ẍi ebnaj. Yaj cachlax ebnaj yu Comam. Machi chahlax tzotelo ebnaj yuto yohta ebnaj ta haꞌ Comam Jesús tuꞌ, haꞌ ton Comam Cristo, echmabil yul yu ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hayet issajbilo hunxa tzꞌayic xin, isto Comam Jesús istxam con̈ob bay machi anma chꞌeqꞌui. Istopaxo anma saywal yin̈ Comam. Hayet yapni anma bay ay Comam tuꞌ xin, yelico yaw anma yin̈ Comam ta mach chito Comam hunuxa con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yalni Comam tet anma: —Yilal wecꞌan walnocꞌojan Tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios yul huntekꞌanxa con̈ob, yu huneꞌ tuꞌ yuxin Akꞌbilintijan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hac tuꞌ yu yecꞌ Comam iscuyno anma yulajla con̈ob yul hunun iscapilla ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hayet hunel, yet isto Comam Jesús istiꞌ haꞌ lago Genesaret, tzetcꞌa anma iscutxba isba iscꞌatan̈ Comam bey tuꞌ. Caw iswitzꞌayo isba anma iscꞌatan̈ Comam yuto yoche anma yabeꞌ Istzotiꞌ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yilnito Comam cabeb teꞌ barco istiꞌ haꞌ tuꞌ. Machi mac ayicto yul teꞌ yuto lan̈an istxꞌahni ebnaj yahaw teꞌ ishacꞌ chiinahti noꞌ cay. ");
INSERT INTO jacNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yahto Comam yul isbarco naj Simón, yalni Comam tet naj tato chishitzto naj hanicꞌoxa teꞌ yiban̈ haꞌ. Lahwi tuꞌ xin, yay tzꞌon̈no Comam yul teꞌ, yichico Comam iscuywacꞌti yin̈ anma ayayo istiꞌ haꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hayet lahwi iscuywa Comam yin̈ anma xin, yalni Comam tet naj Simón: —Hitzweto teꞌ bay caw nahat yehayto yich haꞌ. Haꞌ bey tuꞌ cheyakꞌayto hehacꞌ ikꞌomati cay, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Istakꞌwi naj xin: —Mam cuywawom, sunilbal akꞌbal macon̈munlahan̈, yaj maẍticꞌa noꞌ matzabcha juhan̈. Yaj yu ach chawala, chijaytojan̈ txꞌan̈ hacꞌ tiꞌ hunelxa, ẍi naj Simón tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Haxa yet yanayto ebnaj ishacꞌ tuꞌ xol haꞌ yin̈ noꞌ, caw tzetcꞌacano noꞌ oc yul txꞌan̈. Etza xin tꞌijmoto iswaꞌ txꞌan̈ yu yalil noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yecꞌ iskꞌab ebnaj yawtenti huntekꞌanxa ebnaj yetbi chimunla yul hunxa teꞌ barco. Yul ebnaj colwal isn̈icꞌnoti txꞌan̈. Iscolwapaxo ebnaj isnohtzeno teꞌ cabeb barco tuꞌ yu noꞌ. Etzaxan̈e xin to teꞌ yich haꞌ yu yalil noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hayet yilni naj Simón Pedro huneꞌ tuꞌ, yay jahno naj sata Comam Jesús, yalni naj: —Mamin, hanintiꞌan caw muluminan, yuxin hitzan̈ilo incꞌatan̈an, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yal naj hac tuꞌ yuto caw xiw naj sicꞌlebil yeb ebnaj aycꞌo iscꞌatan̈ tuꞌ, caw cꞌaycan̈ iscꞌul ebnaj yilni noꞌ cay ahti xol haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hacpax tuꞌ naj Jacobo yeb naj Juan, iscꞌahol icham Zebedeo, ebnaj apni colwal yinta naj Simón, caw cꞌaypaxocan̈ iscꞌul ebnaj. Yalni Comam tet naj Simón Pedro tuꞌ: —Mach chachxiwi, yuto tinan̈ matxa chachmunla yin̈ ikꞌoti cay, wal xin haxa anma chachoc hawikꞌatij cat yoc yul inkꞌaban, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lahwi tuꞌ xin, yinilo ebnaj isbarco yeb ismunlabal istiꞌ haꞌ, isbejnicano ebnaj sunil, yoccano tzujno ebnaj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yet hunel yet ayicꞌo Comam Jesús yul huneꞌ con̈ob, yapni huneꞌ naj ayco lepra yin̈ iscꞌatan̈ Comam, caw xin yaꞌay naj yu huneꞌ yabil tuꞌ. Hayet yilni naj Comam, yay jahno naj sata Comam, yay xulno naj sat txꞌotxꞌ, iskꞌanni naj tet Comam: —Mamin, ta chisje hacꞌul chu hawinilo huneꞌ yabil tiꞌ win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yanayo Comam iskꞌab yiban̈ naj, yalni hacaꞌ tiꞌ: —Hoꞌ, chiwochehan ta chiꞌel huneꞌ yabil tiꞌ tawin̈, ẍi Comam tet naj. Yin̈n̈ena tuꞌ, yel huneꞌ lepra tuꞌ yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lahwi tuꞌ xin, yalnipaxo Comam tet naj: —Tajca ay bay chawalicꞌo huneꞌ tiꞌ. As ye haba tet naj sacerdote Israel, cat hawakꞌni haxahanbal tet Comam Dios hacaꞌ yalnicano isley naj Moisés. Hac tuꞌ xin chu hawilchaloj tato xacachsajbicanoj, ẍi Comam Jesús tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Haxa yet yabelaxilo huneꞌ tuꞌ, ispujnacan̈ iskꞌumal Comam xol anma, yuxin caw tzetcꞌa anma apni abeno tzet chal Comam, apnipaxo anma yun̈e iscawxicanocan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wal Comam xin, chibey Comam txahlo bay machi anma chieqꞌui. ");
INSERT INTO jacNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yet hunel, yet lan̈an iscuywa Comam Jesús yin̈ anma, ay huntekꞌan ebnaj fariseo yeb huntekꞌanxa ebnaj chicuyni anma yin̈ isley naj Moisés apni tzꞌon̈no bay ay Comam. Sunil hunun con̈ob yul ismajul Galilea yebpaxo yul ismajul Judea tit ebnaj, aypaxo ebnaj tit bey yul con̈ob Jerusalén. Caw isyelo Comam Dios yip yin̈ Comam Jesús yet iscawxican̈ anma yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yapni xin huntekꞌan ebnaj ikꞌn̈e huneꞌ naj camnajilo isnimanil sat batxteꞌ. Yoche ebnaj ocoto iscꞌatan̈ Comam yul n̈a yu yanayo ebnaj naj yaꞌay tuꞌ sata Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yajaꞌ machi bay octo ebnaj yuto tenanicto anma iscꞌatan̈ Comam. Yuxinto ahto ebnaj yiban̈ iswiꞌ teꞌ n̈a tuꞌ, isholnican̈ ebnaj hayeb txꞌotxꞌ texa, yanayto ebnaj naj mach chibili isnimanil tuꞌ sat teꞌ batxteꞌ sata Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hayet yilni Comam Jesús tato ayco yin̈ yanma ebnaj ta chicawxican̈ naj yaꞌay tuꞌ, yalni Comam tet naj yaꞌay: —Hach wet anmahil, tinan̈ maꞌocna nimancꞌulal yin̈ hamul, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hayet yaben ebnaj cuywawom yin̈ isley naj Moisés yeb ebnaj fariseo huneꞌ tuꞌ, istxum ebnaj hacaꞌ tiꞌ: “¿Mac anmahil huneꞌ naj tiꞌ yuxinto chal naj yakꞌaꞌco isba selelo Comam Dios? Wal xin caw txꞌoj istzotel naj yin̈ Comam. Machi hunu mac chu yakꞌni nimancꞌulal yin̈ mule yuto han̈echꞌan Comam Dios chisje yu.” ẍi ebnaj yul yet ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Istxumnilo Comam tzet chꞌecꞌ yin̈ isnabal ebnaj, yalni Comam: —¿Tzet yin̈ xin chꞌecꞌ yin̈ henabal hacaꞌ tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Baytet hunu caw subuta walnihan: “Maꞌakꞌlax nimancꞌulal yin̈ hamul,” mato: “Ahan̈wanoj, cat hapaxtoj?” ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yalnipaxo Comam: —Tinan̈ xin chinyehan heyilaꞌ Hanin Akꞌbilintijan texol yu Comam Dios tato ay wipan wakꞌni nimancꞌulalan yin̈ ismul anma yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. Lahwi tuꞌ xin, yalni Comam tet naj yaꞌay tuꞌ: —Hanintiꞌan chiwalan tawet, ¡ahan̈wanoj! Ican̈ habatxteꞌ tiꞌ, paxan̈to hawatut, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yin̈n̈ena tuꞌ xin, yah lin̈no naj yin̈ sat anma, yoc naj yalno cꞌulla tzotiꞌ yin̈ Comam Dios. Yinican̈ naj isbatxteꞌ, ispaxto naj yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Caw xin cꞌaycanilo iscꞌul anma yilni huneꞌ tuꞌ, yalnipaxo anma cꞌulla tzotiꞌ yin̈ Comam Dios, yalni anma hacaꞌ tiꞌ: —Yin̈ huneꞌ tzꞌayic tiꞌ, caw hanta cꞌaybalcꞌule majila, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lahwi tuꞌ xin, isto Comam Jesús, yilnito Comam huneꞌ naj ikꞌomilo tohlabal chito bey Roma, Leví isbi naj. Tzꞌon̈anayo naj bay chiꞌel chꞌen tohlabal yin̈ anma. Yoc tꞌan̈no Comam yin̈ naj, yalni Comam tet naj: —Ocan̈ tzujno wintajan incuywomojan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yah lin̈no naj xin, isbejnicano naj ismunil, yoc tzujno naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naj Leví tuꞌ, yecꞌtze naj huneꞌ niman kꞌin̈ bey yatut yuto caw chitzala naj yin̈ Comam. Txꞌiꞌal ebnaj ikꞌomilo tohlabal yeb huntekꞌanxa anma oc waꞌoj sat meẍa yeb Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wal ebnaj fariseo yeb ebnaj chicuyni anma yin̈ isley naj Moisés ichico buchwal yin̈ ebnaj iscuywom Comam. Yalni ebnaj: —¿Tzet yin̈ yuxin chexwaꞌ xol ebnaj ikꞌomilo tohlabal yeb huntekꞌanxa ebnaj txꞌoj isbeybal? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Istakꞌwi Comam Jesús tet ebnaj: —Haꞌ anma mach yaꞌo ay, matzet chꞌocnico naj an̈lom yu, to haꞌ anma yaꞌay, haꞌ ton chꞌocnico naj an̈lom yu. ");
INSERT INTO jacNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mach hulnajojinan wawteꞌan anma chalni ta caw cꞌul yecoj, to haꞌ anma mulum, haꞌ hulnajinan wawteꞌan yu isbejnicano iswatxꞌen istxꞌojal. ");
INSERT INTO jacNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lahwi tuꞌ xin, yalni huntekꞌan anma tet Comam Jesús: —Haꞌ ebnaj iscuywom naj Juan anican̈ haꞌ iswiꞌ anma, yebpaxo ebnaj chicuywi yin̈ ebnaj fariseo, nawn̈e chisyijen ebnaj huneꞌ yet mach chon̈waꞌi yu cotxahli tet Comam Dios. Wal ebnaj chicuywi tawinta tiꞌ, mach chisyije ebnaj huneꞌ tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Istakꞌwi Comam tet ebnaj xin: —Kꞌinaloj ta ay huno mohyilal, ¿tom chu heyalni tet anma awtebil yin̈ mohyilal tuꞌ ta chiyijle wahil yet ayco naj mohyom xol anma awtebil? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wal xin, hato yet chiꞌapni istiempohal yilaxilo naj mohyom tuꞌ, cat yichico anma yijlen wahil yu istxahli, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yalnipaxo Comam huneꞌxa yechel tiꞌ: —Kꞌinaloj ta chicobuj hunu camiẍe xilxa, yaj yin̈ hunu camiẍe acꞌto chijilo isbujil kꞌap xilxa tuꞌ, mach cꞌulu chꞌelicoj, yuto mach chischah isba kꞌap acꞌto yeb kꞌap xilxa, yeb xin nabn̈e chijetato kꞌap acꞌto tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ay hunxa yechel tiꞌ, mach chu heyanayto vino acꞌto yul hunu noꞌ tzꞌum xilxa, yuto chilin̈mo noꞌ yet chihowbican̈ vino, cat yetaxto iscab majanil. ");
INSERT INTO jacNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yuxin haꞌ yul noꞌ acꞌla tzꞌum chialaxayto teꞌ vino acꞌto, hac tuꞌ xin mach chietaxto iscab majanil. ");
INSERT INTO jacNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yebpaxo xin, haꞌ mac xaucꞌni vino payxa watxꞌi, ¿tom chito yoche yucꞌuꞌ teꞌ acꞌ vino lan̈anto iswatxꞌi? ¡Machoj! Yuto chal ebnaj: “Haꞌ teꞌ vino payxa watxꞌi, ecꞌna caw cꞌul,” ẍi ebnaj, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yet huneꞌ tzꞌayical xewilal ecꞌ Comam Jesús yeb ebnaj iscuywom yul huneꞌ nichꞌan beh xol ixim trigo. Yinilo ebnaj hayeb iswiꞌ ixim, ischilnilo ebnaj ixim iscꞌuxuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iskꞌamben huntekꞌan ebnaj fariseo tet ebnaj: —¿Tzet yin̈ xin chexmunlahi, cheyinilo tzet chelo yin̈ huneꞌ tzꞌayic xewilal tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yalni Comam Jesús tet ebnaj fariseo tuꞌ: —¿Tom maẍto cheyil yul Yum Comam Dios yin̈ tzet yakꞌle naj rey David hunel yu n̈ohchahilal yeb ebnaj tzujan yinta naj tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Octo naj yul yatut Comam Dios, yinican̈ naj ixim pan akꞌbilxa tet Comam. Yoc naj iswahno ixim, yakꞌnipaxo naj ixim tet ebnaj tzujan yintaj. Yaj wal isley naj Moisés chala ta han̈cꞌan̈e ebnaj sacerdote Israel chu iswahni ixim pan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wal xin Hanin Akꞌbilintijan texol yu Comam Dios, chu walnihan yin̈ tzet cheyu yin̈ istzꞌayical xewilal, ẍi Comam tet ebnaj fariseo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yin̈ hunxa tzꞌayic xewilal, octo Comam Jesús yul iscapilla ebnaj Israel, yichico Comam iscuyni anma tuꞌ. Ay xin huneꞌ naj camnajilo iswatxꞌkꞌab ayicto xol anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wal ebnaj cuywom yin̈ isley naj Moisés yeb ebnaj fariseo, ayco ebnaj yechmani ta chakꞌ cawxo Comam iskꞌab naj yin̈ huneꞌ tzꞌayical xewilal tuꞌ, yuto choche ebnaj ta chiꞌilchalo hunu tzet ye tuꞌ chiꞌoc ismulo Comam, cat yoc ebnaj akꞌocꞌule yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yaj xin yohtaxa Comam tzet chꞌecꞌ yin̈ isnabal ebnaj, yuxin yal Comam tet naj camnajilo iskꞌab tuꞌ: —Ahan̈wanoj, cat xin hawoc lin̈no coxoltiꞌan̈, ẍi Comam tet naj. Yah lin̈no naj. ");
INSERT INTO jacNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lahwi tuꞌ xin, yalni Comam Jesús tet ebnaj: —Ay huneꞌ tzet chinkꞌambehan teyet, ¿baytet hunu chisje cowatxꞌen yin̈ istzꞌayic xewilal cheyabe, ham iscꞌulal mato istxꞌojal? ¿Chimyu jakꞌni cawxo anma mato jakꞌni camoj? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hayet lan̈an yecꞌ tꞌan̈tꞌon Comam yin̈ sat sunil anma tuꞌ, yalni Comam tet naj camnajilo iskꞌab tuꞌ: —Toholban̈elto hakꞌab, ẍi Comam. Istoholban̈enilto naj iskꞌab, iswatxꞌicaniloj. ");
INSERT INTO jacNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yaj caw tit ishowal ebnaj cuywawom yin̈ ley yeb ebnaj fariseo tuꞌ yin̈ Comam. Yichico ebnaj iskꞌamben tet hunun tzet wal yuten ebnaj Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yet hunel tuꞌ, to Comam Jesús yin̈ istzalanil huneꞌ won̈an txahloj, sunilbal akꞌbal txahli Comam tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Haxa yet issajbilo yin̈ hunxa tzꞌayic xin, yawtenti Comam ebnaj iscuywom iscꞌatan̈. Xol ebnaj tuꞌ issiqꞌuilo Comam cablahon̈wan̈ ebnaj yu yoc ebnaj ischejabo Comam yin̈ ismunil. ");
INSERT INTO jacNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hac tiꞌ isbi hunun ebnaj hacaꞌ tiꞌ: naj Simón, Pedro yijcano isbi naj yu Comam, naj Andrés, yuẍta naj Simón, naj Jacobo yeb naj Juan, naj Felipe yeb naj Bartolomé. ");
INSERT INTO jacNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Naj Mateo yeb naj Tomás, yeb naj Jacobo, iscꞌahol icham Alfeo, naj Simón ayico yin̈ huneꞌ partido Cananista, ");
INSERT INTO jacNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yeb naj Judas, iscꞌahol icham Jacobo yeb xin naj Judas Iscariote, naj anico Comam yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yet ispaxayti Comam Jesús yin̈ huneꞌ won̈an yeb ebnaj chicuywi yintaj, yayilo Comam sat huneꞌ chekꞌan̈. Caw tzetcꞌacano anma chi-ticꞌa-cuywi yinta Comam cutxico bey tuꞌ. Ay anma ispeto ismajul Judea yeb yul con̈ob Jerusalén, yebpaxo anma ispeto istila haꞌ mar Mediterráneo yul ismajul Tiro, yeb yul ismajul Sidón. Apni anma yabeꞌ cuybanile chal Comam yeb xin apni yun̈e yakꞌni cawxo Comam macta ayco yabil yin̈, yeb xin macta chꞌecꞌyaꞌ yu naj matzwalil, yu iscawxicanocan̈ yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sunil anma choche tzabno Comam, yuto hayet chistzabni anma Comam chicawxicanocan̈, yuto ay yip Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Istꞌan̈xito Comam Jesús yin̈ ebnaj chicuywi yinta tuꞌ, yalni Comam hacaꞌ tiꞌ: —Sakꞌal heyet hex mebaꞌ hex tiꞌ, yuto ayco Comam Dios yipo heyanma, yuxin heyet heyoc yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sakꞌal heyet hex chexn̈ohchahi, yuto chꞌakꞌlaxo noho hecꞌul. Sakꞌal heyet hex chexokꞌi, yuto chechab tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Caw sakꞌal heyet, yet chexisyahni anma wuhan, yebpaxo yet chexistzumbenilo anma xol, yeb yet chexbuchlax yu anma, yeb yet chexhallax machiswalilal yuto tzujanex wintajan, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ta hac tuꞌ chexutelaxi tzalahan̈we sicꞌlebil yuto chꞌakꞌlax ispaj teyet bey satcan̈. Hacaꞌ chexutelax tuꞌ, hac tuꞌ utelax ebnaj ischejab Comam Dios yet payat yu yichmam anma tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Walex kꞌalomex tiꞌ, ¡caw cꞌanchꞌanex! yuto xaquextzalahi. ");
INSERT INTO jacNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Walex nohna hecꞌul tinan̈, ¡caw cꞌanchꞌanex! yuto chul huneꞌ tiempohal bay cheyakꞌle wahil. Haxa hex chextzebi tinan̈, ¡caw cꞌanchꞌanex! yuto chexokꞌo yu biscꞌulal. ");
INSERT INTO jacNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Cꞌanchꞌanex! hex chꞌalaxico hewinajil, yuto cꞌul chihallax teyin̈ tinan̈; hac tuꞌ hallax yin̈ ebnaj lekꞌtiꞌwom isbalico isba ischejabo Comam Dios yet payat, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yalnipaxo Comam Jesús: —Chiwalan teyet maquex lan̈an heyaben tzet chiwaltiꞌan, cꞌulchꞌan cheyute heyanma yin̈ anma chichiwa iscꞌul teyin̈. Cꞌul cheyute heba yin̈ mac chꞌutenico ecꞌnajilal teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kꞌanwe iscꞌulal Comam Dios yiban̈ macta chextzꞌactiꞌn̈eni, cat hetxahlipaxo yin̈ anma chibuchwa teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta ay mac chipakꞌnilto hesat, meltzopaxto kꞌaxepxa tet. Ta ay mac chitzicnilo hechumpa, matzet cheyala ta chipaxto hecamiẍ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ta ay mac chikꞌanni hunu tzet ye tuꞌ teyet, akꞌwe tet. Ta ay mac chiꞌinilo hunu tzet ye tuꞌ teyet, mach chekꞌan meltzoho tet. ");
INSERT INTO jacNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta cheyoche cꞌulchꞌan chute isba anma teyin̈, hex babel cꞌul cheyute heba yin̈ anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tato han̈cꞌan̈e anma xahan chexilni, haꞌn̈e xahan cheyilpaxoj, ¿chimilchalo iscꞌulal Comam teyin̈ hacaꞌ tuꞌ? ¡Machoj! Yuto haꞌ anma txꞌoj yecoj, hac tuꞌ chisbeybaln̈e. ");
INSERT INTO jacNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta han̈cꞌan̈e anma cꞌul iscꞌul teyin̈, haꞌ bay cꞌul cheyutepaxo heba, ¿baytet iscꞌulal hecꞌul hacaꞌ tuꞌ? Yuto hac tuꞌ chute isba anma mach tꞌin̈ano yecoj. ");
INSERT INTO jacNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta han̈echꞌan tet anma chꞌakꞌni ispaj selel teyet cheyabe, han̈echꞌan bay cheyakꞌa, ¿bay ay iscꞌulal hecꞌul hacaꞌ tuꞌ? Yuto hac tuꞌ chutepaxo anma mach ohtan̈eho Comam Dios, chechma ispaj selel. ");
INSERT INTO jacNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yajaꞌ chiwalan teyet, xahan cheyil anma mach xahano chexilni. Cꞌul cheyute hecꞌul yeb xin cheyakꞌ tzet ye tuꞌ cꞌamil tet anma tuꞌ, yajaꞌ mach cheyechma yakꞌlax iscꞌambanil teyet. Ta hac tuꞌ cheyute, caw tzetcꞌa ispaj chechah tet Comam Dios, hac tuꞌ xin chu heyenilo tato lahan iscꞌulal hecꞌul yeb Comam Dios caw aycano yip, yuto cꞌul iscꞌul Comam yin̈ anma mulum yeb xin yin̈ anma mach chꞌakꞌni yuchꞌandios tet. ");
INSERT INTO jacNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tzꞌayojab hecꞌul yin̈ heyet anmahil, hacaꞌ istzꞌay iscꞌul Comam ay yul satcan̈ jin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yalnipaxo Comam Jesús: —Mach comono chexoc heyilaꞌ tzet ye hunu heyet anmahil, haxinwal mach chiocpaxo Comam Dios yilaꞌ tzet heyehi. Mach chetzꞌactiꞌn̈e anma, haxinwal mach chexistzꞌactiꞌn̈epaxo Comam. Akꞌwe nimancꞌulal yin̈ ismul heyet anmahil haxinwal chakꞌpaxo Comam Dios nimancꞌulal yin̈ hemul. ");
INSERT INTO jacNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Akꞌwe tet heyet anmahil. Ta hac tuꞌ cheyute, chakꞌpaxo Comam Dios huneꞌ ismalil caw cꞌul teyet, caw nohnaj, caw chitin̈laxi masan chimaltoj. Ta hac tuꞌ cheyute heyakꞌni tet heyet anmahil, hac tuꞌ chiyute yakꞌnipaxo Comam Dios teyet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yanipaxico Comam huneꞌ yechel tiꞌ: —Kꞌinalo ta ay hunu naj mach chu yilni, ¿tom chu isxecnicꞌo naj hunuxa naj mach chu yilni? ¡Machoj! Chisn̈icꞌleto isba ebnaj iscawan̈il yul xab. ");
INSERT INTO jacNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hac tuꞌ xin machi hunu naj lan̈anto iscuywi chipalcꞌonna yiban̈ naj chicuywa tuꞌ. Hayet xalahwi iscuywi naj, wal tuꞌ lahanxa chꞌelico naj yeb naj chicuywa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yebpaxo kꞌinalo ta ay hunu hawuẍta ayicto iskꞌal teꞌ chꞌim yul sat, walachpaxo xin, aypaxicto hunu teꞌ patzab yul hasat, ta mach chawilti te teꞌ ayicto yul hasat tuꞌ, ¿haꞌ tom xin huneꞌ iskꞌal teꞌ chꞌim ayicto yul sat huneꞌ hawuẍta tuꞌ, chu hawiniltij? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yaj ta mach chawilti teꞌ patzab ayicto yul isbakꞌ hasat, chimyu hawalni tet hawuẍtaj: “Wikꞌacaniltijan iskꞌal teꞌ chꞌim ayicto yul isbakꞌ hasat,” ta cachi. Ta hac tuꞌ chawute ¡lekꞌtiꞌ hach! Wal xin, icanilti teꞌ patzab yul hasat babel, haxinwal chu hawinilti iskꞌalemal teꞌ chꞌim ayicto yul isbakꞌsat hawuẍta tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yalnipaxo Comam Jesús: —Haꞌ te teꞌ caw cꞌul, machi hunu sat teꞌ machiswalil chakꞌa. Hacpax tuꞌ te teꞌ maẍticꞌa cꞌuluj, machi hunu sat teꞌ cꞌul chakꞌa. ");
INSERT INTO jacNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yu sat te teꞌ chiyakꞌa, yuxinto chicotxumilo tzet teꞌal teꞌ. Kꞌinalo teꞌ txꞌix tinan̈, ¿tom higo sat teꞌ chakꞌa? ¡Machoj! Hacaꞌpaxo teꞌ uva, mach chu yakꞌni teꞌ sat teꞌ txꞌix. ");
INSERT INTO jacNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Haꞌ anma cꞌul, cꞌul cꞌuwan yul yanma yuxin cꞌul tzet chala. Walpaxo anma txꞌoj, txꞌoj cꞌuwan yul yanma, yuxin txꞌoj tzet chala. Hac tuꞌ xin, haꞌ tzet cꞌuwan yul yanma haꞌ chiyala, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yalnipaxo Comam Jesús tet anma tuꞌ: —¿Tzet yin̈ cheyal win̈an, “Mamin, Mamin,” quexchi, yajaꞌ mach cheyijepaxo tzet chiwalan? ");
INSERT INTO jacNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tinan̈ xin chiwalan teyet yin̈ mac chꞌaben tzet chiwalan, cat isyijeni. ");
INSERT INTO jacNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lahan mac tuꞌ hacaꞌ huneꞌ naj iswatxꞌecan̈ yatut, iskꞌajahti naj txꞌotxꞌ masanto chaloti chꞌen chꞌen yu naj, yanayo naj xeꞌ teꞌ n̈a tuꞌ. Lahwi yah teꞌ xin, istit huneꞌ niman n̈ab, yapni elomaꞌ yich teꞌ, yajaꞌ maẍticꞌa lowto yich teꞌ yu haꞌ, yeb xin maẍticꞌa bili teꞌ, yuto caw cꞌul yehayto xeꞌ teꞌ yiban̈ chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yajaꞌ mac chꞌaben tzet chiwalan, mach chisyijepaxoj, lahan hacaꞌ huneꞌ naj yiban̈n̈e txꞌotxꞌ yichecan̈ islocꞌal yatut, mach nahato yayto isxeꞌal yatut yul txꞌotxꞌ. Haxa yakꞌni huneꞌ niman n̈ab xin, yapni haꞌ elomaꞌ ismakꞌnoco isba yich teꞌ, yaycꞌay teꞌ, yuchcꞌacanto teꞌ xin, ẍi Comam tet anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hayet lahwi istzotel Comam Jesús tet anma tuꞌ isto Comam bey con̈ob Capernaum. ");
INSERT INTO jacNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Haꞌ bey tuꞌ, ay huneꞌ naj capitán, ah con̈ob Roma. Ay huneꞌ ischejab naj caw xahan ay yu, caw txꞌoj ye iscꞌul, lan̈anxa iscami. ");
INSERT INTO jacNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yabe naj capitán tuꞌ iskꞌumal Comam, yuxin yato naj huntekꞌan ebnaj iswiꞌehal yin̈ ebnaj Israel iskꞌanno tet Comam ta chitit Comam yakꞌaꞌ cawxo ischejab naj capitán tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hayet yapni ebnaj iscꞌatan̈ Comam tuꞌ, yalni ebnaj tet Comam: —Ay huneꞌ naj capitán caw cꞌul iscꞌul, yilal hato nino colwal yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wal xin caw xahan ayon̈ han̈on̈ Israel hon̈ tiꞌ yu naj. Yacan̈ naj huneꞌ cocapillahan̈, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yuxin to Comam Jesús yinta ebnaj. Yajaꞌ haxa yet hanicꞌxan̈e yapni ebnaj yeb Comam bey yatut naj, ischejnipaxti naj capitán haywan̈xa yamigo yalno tet Comam: —Chal naj capitán tawet hacaꞌ tiꞌ: “Mamin, mach chaweta hacꞌul hatit watuttiꞌan, yuto mach intzanojan hawocto yul watutan chiwabehan. ");
INSERT INTO jacNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yeb xin mach intzanojan intohan cachwilnojan. Wal xin tzotelan̈tij, cat iscawxican̈ naj inchejabtiꞌan hawu. ");
INSERT INTO jacNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wohtajan huneꞌ tiꞌ yuto ay ebnaj wahawan chinchejnihan, aypaxo ebnaj insoldadohan chinchejpaxojan. Ta chiwalan tet hunu naj: ‘Asiꞌ,’ ta quinchiyan, cat isto naj. ‘Cata bey tiꞌ,’ ta quinchiyan, cat istit naj. Chiwalnipaxojan tet hunxa naj: ‘Ocan̈ hawatxꞌe huneꞌ tiꞌ,’ ta quinchiyan, cat yoc naj iswatxꞌeni,” ẍi naj capitán, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hayet yaben Comam hacaꞌ tuꞌ, caw cꞌaycan̈ iscꞌul yabeni. Istꞌan̈xito Comam yin̈ anma tzujan yinta tuꞌ, yalni Comam: —Caw chiwalan yin̈ isyelal teyet, maẍto hunu mac ay bey Israel xawilan yanico yanma yin̈ Comam Dios hacaꞌ huneꞌ naj tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ispaxto ebnaj yamigo naj capitán bey yatut naj. Hayet yapni ebnaj yilni ebnaj tato xacawxinacan̈ ischejab naj yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lahwi tuꞌ xin, isto Comam Jesús bey huneꞌ con̈ob chiyij Naín yeb ebnaj chicuywi yinta Comam tuꞌ. Caw tzetcꞌa anma oc tzujnu yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hayet yapni Comam istiꞌ ispultahil con̈ob tuꞌ, yilnito Comam lan̈an yilaxto huneꞌ camom mujlaxoj, yunin huneꞌ ix hunix; caw xin han̈cꞌan̈e huneꞌ yunin ix tuꞌ. Caw hanta anma tzujan yinta ix yeb iscamom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hayet yilnito Comam ix hunix tuꞌ, istzꞌaycan̈ iscꞌul Comam yin̈ ix, yalni Comam: —Mach chaẍokꞌi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ishitzico Comam iscꞌatan̈ naj camom tuꞌ, yanico Comam iskꞌab yin̈ teꞌ batxteꞌ, islin̈ban isba ebnaj ikꞌn̈e naj. Yalni Comam tet naj camom tuꞌ: —Ach nichꞌan tzeh, chiwalan tawet, ahan̈wanoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lahwi tuꞌ xin, yah tzꞌon̈no naj camom tuꞌ, yichico naj istzotelcan̈, yanico Comam naj tet ismiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hayet yilni anma huneꞌ tuꞌ, caw xiwcan̈ anma sunil. Yalni anma cꞌulla tzotiꞌ yin̈ Comam Dios hacaꞌ tiꞌ: —Haꞌ huneꞌ ischejab Comam Dios ischejti coxol tiꞌ, caw niman yelapno yehi, ẍi anma. Yalnipaxo anma: —Caw mahul Comam Dios colwal jin̈, han̈on̈ iscon̈obon̈ tiꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Huneꞌ iswatxꞌe Comam Jesús bey tuꞌ, caw ecꞌ isbi sunil yul ismajul Judea yebpaxo huntekꞌanxa con̈ob hoyanico yin̈ iscawilal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yapni iskꞌumal huntekꞌan tiꞌ tet naj Juan anican̈ haꞌ iswiꞌ anma, yeb ebnaj cuywina yinta naj Juan tuꞌ. Yawtenti naj cawan̈ ebnaj iscuywom tuꞌ iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yalni naj tet ebnaj ta chito ebnaj iskꞌambe tet Comam Jesús hacaꞌ tiꞌ: —¿Tom hach tiꞌ bay tzꞌibn̈ebilcanoj ta chaẍhuli, mato ayto hununxa naj chijechmahan̈ yuli? quexchi, ẍi naj Juan tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yapni ebnaj ischejab naj Juan tuꞌ, ishitzico ebnaj iscꞌatan̈ Comam, yalni ebnaj: —Macon̈ischejtijan̈ naj Juan cokꞌambehan̈ tawet, ¿ham hach tiꞌ Cristo tzꞌibn̈ebilcanoj tato chihuli, mato chijechmahan̈ yul hunuxa maca? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hayet yapni ebnaj, cꞌuxan lan̈an yakꞌni cawxo Comam anma chꞌecꞌyaꞌ yanma yu yabil, yeb xin macta ayco ebnaj ischejab naj matzwalil yin̈. Ishajnipaxo Comam isbakꞌsat macta mach chu yilni. ");
INSERT INTO jacNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Istakꞌwi Comam tet ebnaj xin: —As halwe tet naj Juan tzet maquexhul heyilaꞌ, yeb tzet maxeyabe. Cheyal tet naj tato mahajlocano sat mac mach chu yilni, mabelwican̈ mac maẍticꞌa chu yeqꞌui. Haꞌ mac ayco lepra yin̈, maan̈chacanoj. Mac majanticꞌa istxiquin, mahajlohi, ay camom anma mahulcanocan̈ iscꞌul, cat yallaxpaxo Tzotiꞌ cꞌul yet colbanile tet anma matzet ayco yipo yanma. ");
INSERT INTO jacNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sakꞌal yet mac mach chicabcon yanma win̈an, quexchi tet naj Juan tuꞌ, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lahwi ismeltzoto ebnaj ischejab naj Juan tuꞌ, yichico Comam istzotel tet anma yin̈ naj Juan, yalni Comam hacaꞌ tiꞌ: —¿Tzet quexbey heyilaꞌ bey txꞌotxꞌ desierto, tom hacaꞌ huneꞌ teꞌ ah machi yip chiꞌecꞌ yu jakꞌekꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mato haꞌ huneꞌ naj nime winaj caw nanxa islow yeco xil iskꞌap? Hex tiꞌ heyohtaj macta caw chiskꞌaptze isba, yeb chakꞌ tzet choche iscꞌul, yuln̈e yatut ebnaj rey chijil huntekꞌan anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wal xin ¿mac quexbey heyilaꞌ? ¿Ham huneꞌ ischejab Comam Dios quexbey heyilaꞌ? Yin̈ caw isyelal chiwalan teyet, huneꞌ naj quexbey heyilaꞌ tuꞌ, caw ecꞌbalto ismunil naj sata sunil ischejab Comam Dios ecꞌlena yet payat. ");
INSERT INTO jacNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yin̈ naj Juan tuꞌ tzꞌibn̈ebilcano yul Yum Comam Dios bay chal hacaꞌ tiꞌ: Chinchejtojan huneꞌ inchejaban babel tasataj yun̈e iswatxꞌen habeh yalan̈to maẍto chaẍapni, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chiwalan teyet tato xol anma yul sat yiban̈kꞌinal tiꞌ maẍto hunu mac ecꞌbal yelapno yiban̈ naj Juan tuꞌ, yaj wal xol anma ayxaco yul iskꞌab Comam Dios tinan̈, waxan̈ca machi yelapno yehi, ecꞌbalto iscꞌulal chil sata naj Juan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Haꞌ comon anma, yebpaxo ebnaj ikꞌomilo tohlabal yin̈ anma, chꞌen chito bey Roma, yet yalan̈tocanoj yabe ebnaj tzet yal naj Juan, yahcano haꞌ iswiꞌ, haꞌ ebnaj tuꞌ chitxumcha yu ta caw cꞌul Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yaj wal ebnaj fariseo yeb ebnaj chicuyni anma yin̈ isley naj Moisés, mach chisje ebnaj yah haꞌ iswiꞌ yu naj Juan, haꞌ xin halniloj tato isyah ebnaj huneꞌ iscꞌulal Comam Dios yoche yakꞌaꞌ tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yalnipaxo Comam Jesús tet anma: —¿Mac yeb lahan anma yin̈ huneꞌ tiempohal tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wal xin lahan anma hacaꞌ niẍte unin chiay tzꞌon̈no yul txon̈bal, cat issajchi. Chawtenti yetbi iscꞌatan̈ hacaꞌ tiꞌ: “Naban̈e majeta cobahan̈ jokꞌtzenan̈ teꞌ suꞌ, machi xin maquexcan̈alwi. Yebpaxo xin, naban̈e macobitn̈ehan̈ huntekꞌan bit tzꞌabalcꞌule tan̈e yoqui, maẍticꞌa xin maquexokꞌpaxoj,” ẍi niẍte unin tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yet yulicꞌo naj Juan anican̈ haꞌ iswiꞌ anma, mach waꞌ naj yeb anma, yuxin yal anma tato ayco huneꞌ ischejab naj matzwalil yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lahwi tuꞌ xin, wulan Hanin Akꞌbilintijan texol yu Comam Dios, yaj hanintiꞌan chinwaꞌan xol anma yuxin cheyalpaxo hacaꞌ tiꞌ win̈an: “Wal naj Jesús tuꞌ, waꞌon̈eticꞌa chu naj, yeb ucꞌu-vino-n̈eticꞌa chu naj. Yamigopaxo isba naj yeb ebnaj ikꞌomilo tohlabal chꞌen chito bey Roma, yebpaxo ebnaj txꞌoj chiswatxꞌe,” quexchi win̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yaj wal anma ayco ishelanil Comam Dios yin̈, haban isyenilo isba yin̈ tzettaj cꞌul chi-la-iswatxꞌe, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hayet hunel, apni huneꞌ naj fariseo, Simón isbi, awtelo yin̈ Comam Jesús ta chito Comam waꞌo yatut naj. Hayet yapni Comam xin, yoc tzꞌon̈no Comam waꞌo sat meẍa. ");
INSERT INTO jacNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haꞌticꞌa yul huneꞌ con̈ob tuꞌ xin, ay huneꞌ ix caw mulum. Hayet yaben ix tato apni Comam waꞌo bey yatut naj fariseo tuꞌ, yapni ix yeb huneꞌ islimeta, alabastro isbi, caw nohna yu aceite caw xukꞌ sam sicꞌlebil. ");
INSERT INTO jacNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yet yapni ix iscꞌatan̈ Comam Jesús yichi yokꞌ ix. Yay jahno ix yich yoj Comam, istxꞌahni ix yoj Comam yu yal sat. Lahwi tuꞌ xin, issunni tajo ix yoj Comam yu xil iswiꞌ, istzꞌohnipaxo ix yoj Comam. Tzujan tuꞌ xin, istobnico ix huneꞌ an̈ caw xukꞌ sam tuꞌ yin̈ yoj Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hayet yilni naj fariseo huneꞌ tuꞌ, istxumni naj hacaꞌ tiꞌ: “Ta yelticꞌa ischejab Comam Dios ye huneꞌ naj tiꞌ, chimtxumchalo yu naj tzet ixal huneꞌ ix chitzabni yoj naj tiꞌ. Chimtxumcha yu naj ta caw mulum ix,” ẍi naj ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yalni Comam tet naj: —Simón, ay hanicꞌ tzet chiwoche walaꞌan tawet, ẍi Comam. Istakꞌwi naj: —Hal mam cuywawom tzet chawoche chawal wetan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yalni Comam tet naj: —Kꞌinalo ta ay hunu naj chꞌanilto chꞌen melyu cꞌamil tet cawan̈o ebnaj. Ta quiniento denario chiscꞌamn̈e huneꞌ naj, haxa hunxa naj xin, cincuenta denarion̈e chiscꞌamn̈e. ");
INSERT INTO jacNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yajaꞌ ta machi bay chito ebnaj yikꞌati selel chꞌen, chisbutni tan̈o naj iscꞌas ebnaj, ¿tzet xin chawute hawalni yin̈ ebnaj cawan̈ tuꞌ? ¿Mac xin ecꞌna chitzalahi yin̈ naj chibutnitan̈o iscꞌas ebnaj? ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Istakꞌwican̈ naj Simón: —Haꞌ yul wetan, ham naj tzetcꞌa iscꞌas tan̈tzelax yiban̈, ẍi naj. Istakꞌwi Comam xin: —Hoꞌ, caw yel chawala, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lahwi tuꞌ xin istꞌan̈xito Comam yin̈ ix, yalni Comam tet naj Simón tuꞌ: —¿Mamxawil huneꞌ maswatxꞌe ix tiꞌ? Hayet maquinoctijan yul hawatut tiꞌ, machi maxatxꞌah wojan, yaj wal ix tiꞌ xin, mastxꞌahilo ix wojan yu yal sat. Malahwi tuꞌ xin, massuni tajo ix wojan yu xil iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Machi maxatzꞌoh inkꞌotxan, yajaꞌ huneꞌ ix tiꞌ, hataxticꞌa yet manoquilojan yul hawatut tiꞌ maꞌichico ix istzꞌohni wojan. ");
INSERT INTO jacNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Machi nichꞌan yan̈al xil inwiꞌan maxawahtoj, yaj wal ix tiꞌ, mastobayo ix huneꞌ an̈ caw xukꞌ sam sicꞌlebil yiban̈ wojtiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yuxin chiwalan tawet, huneꞌ ix tiꞌ caw chitzala ix win̈an yuto caw maakꞌlaxcano tan̈o sunil ismul ix. Walpaxo mac hanicꞌchꞌan nimancꞌulal chꞌakꞌlax yin̈, caw hanicꞌchꞌanpaxo tzalahilal chisye, ẍi Comam tet naj Simón tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lahwi tuꞌ, yalni Comam tet ix: —Tinan̈ xin chitan̈cano hamul tawiban̈, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wal ebnaj awtebil waꞌo yeb Comam tuꞌ xin, yalle ebnaj tet hunun hacaꞌ tiꞌ: —¿Mac anmahil huneꞌ naj tiꞌ yuxin chisje isbutni tan̈o naj mule? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yalnipaxo Comam tet ix: —Macachcolcha tinan̈ yuto maquinhawaytojan yul hawanma, paxan̈to yin̈ akꞌancꞌulal, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lahwi tuꞌ xin yecꞌ Comam Jesús yulaj con̈ob yeb yulaj aldea yalnicꞌo tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. Haꞌ hun ebnaj ischejab Comam tuꞌ tzujan yintaj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tzujanpaxo huntekꞌan ebix ix bay yilo Comam ischejab naj matzwalil, yeb huntekꞌanxa ebix nan yabilal ayticꞌaco yin̈, cawxican̈ yu Comam. Xol ebix tuꞌ ayco ix María ah Magdala, ix bay yilo Comam hujwan̈ ischejab naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yeb ix Juana, yixal naj Chuza, naj yahaw yeco yin̈ ismunil naj Herodes, yebpaxo ix Susana, yeb huntekꞌanxa ebix, colwa ebix yin̈ Comam Jesús yeb yin̈ ebnaj ischejab Comam, yin̈ tzet ay yul iskꞌab. ");
INSERT INTO jacNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tzetcꞌa anma yul hunun con̈ob hul ilno Comam Jesús. Lahwi iscutxban isba anma xin, yalni Comam huneꞌ yechel tet anma: ");
INSERT INTO jacNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ay huneꞌ naj to txiho trigo. Hayet lan̈an istxihni naj ixim trigo tuꞌ, ay ixim apni cꞌatna yul beh. Haꞌ ixim tuꞌ ton̈e xan̈laxto ixim yu anma. Haxa xin noꞌ chꞌic hul sicꞌnocan̈ ixim. ");
INSERT INTO jacNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aypaxo ixim apni cꞌatna xolaj chꞌen chꞌen. Hayet yahilo ixim yin̈ an̈e tajilo ixim yuto mach ischacꞌanil sat txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aypaxo xin ixim aycꞌay xol yin̈atil teꞌ txꞌix. Hayet ischꞌibcan̈ ixim, ischꞌibpaxocan̈ teꞌ. Hac tuꞌ xin yu istzꞌonbayo ixim. ");
INSERT INTO jacNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Haxa hunmajanxa ixim ay xol txꞌo txꞌotxꞌ caw cꞌul. Hayet ischꞌibcan̈ ixim, caw cꞌul yul ixim yakꞌa, ay ixim huneꞌ ciento yuteco sat yin̈ hunun iswiꞌ, ẍi Comam. Lahwi tuꞌ, yalni Comam yin̈ caw ip: —Maquex cheyabe huneꞌ tiꞌ, akꞌwe heyanma hetxumniloj, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iskꞌamben ebnaj chicuywi yinta Comam tuꞌ yin̈ tzet chal yelapno huneꞌ yechel yakꞌ Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yalni Comam tet ebnaj: —Teyetn̈e chakꞌ Comam Dios heyohtan̈elo tzet ewan yehi yu heyoc yul iskꞌab Comam, yaj tet anma comon yecheln̈e bay tzotel Comam tet. Waxan̈ca hajan isbakꞌsat, mach chu yilni, waxan̈ca chabe, yaj mach chitxumcha yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yalnipaxo Comam Jesús: —Wal xin, chiwalan teyet yin̈ tzet chalilo huneꞌ yechel mawaltiꞌan. Haꞌ ixim hin̈at trigo, yechel Istzotiꞌ Comam Dios ye ixim. ");
INSERT INTO jacNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Haꞌ ixim hin̈at apni cꞌatna yul beh chitzotel yin̈ huntekꞌan anma, hayet chilahwi yaben Istzotiꞌ Comam Dios, cat yul naj matzwalil yin̈, cat yinilo naj Istzotiꞌ Comam Dios yul yanma yun̈e mach chaco yanma anma yin̈, hac tuꞌ xin mach chicolcha anma yu. ");
INSERT INTO jacNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Haꞌ ixim apni cꞌatna xolaj chꞌen chꞌen, chitzotel huneꞌ tiꞌ yin̈ anma caw chitzala yaben Istzotiꞌ Comam Dios, yaj mach huneln̈eho chucanico Istzotiꞌ Comam yul yanma. Hanicꞌn̈e tiempohal chistzꞌun yul yanma, yuxin hayet chul ilwebal yin̈, cat yinilo isba yin̈ tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Haꞌ ixim apni xol teꞌ hin̈at txꞌix, yechel huneꞌ tuꞌ yin̈ anma chiꞌaben Istzotiꞌ Comam Dios, yaj hayet chibelwito tiempo yiban̈ xin, cat ismajayto ishakꞌo anma yin̈ Comam, yu ecꞌna chaco tzet ye tuꞌ ay yul sat yiban̈kꞌinal tiꞌ yin̈ yanma, maca yu yochento kꞌalomal, maca yu yochen tzet ay yul sat yiban̈kꞌinal tiꞌ. Hac tuꞌ xin chu yinilo Istzotiꞌ Comam Dios yin̈ yanma. Yuxin lahan anma tuꞌ yeb ixim trigo machi satni. ");
INSERT INTO jacNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Walpaxo ixim txihlaxayo sat txꞌotxꞌ caw kꞌej, yeb yax yalan̈, yechel anma chichahni yabe Istzotiꞌ Comam Dios yin̈ sunil yanma, yeb xin chakꞌ yanma yohtan̈eniloj cat isyijeni, mach chicabcon yanma, hac tuꞌ xin chitecha yu, lahan anma tuꞌ yeb ixim caw tzetcꞌa sat chakꞌa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hayet chicotzujbanico kꞌaꞌ yin̈ hunu cantil, mach chicon̈ohbaco hunu tzet ye tuꞌ yiban̈, mach chijapaxicto yalan̈ txꞌat, wal xin nahat chijacan̈ yun̈e yilni anma chiꞌocto yul n̈a tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hacpax tuꞌ xin sunil tzet ewan yehi chiixtan̈wiloj, yeb xin sunil tzet ye tuꞌ mach ohtabiloj chiohtan̈elaxiloj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yuxin chi-cam-walan heyabeꞌ, haꞌ mac choche istxumuloj, caw chiꞌakꞌlax yohtan̈eloj. Walpaxo mac mach chiyoche istxumulo huntekꞌan tiꞌ, haꞌ nichꞌan tzet etza chinachalo yu, chiꞌilaxilo tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Apni ismiꞌ Comam Jesús yeb ebnaj yuẍta Comam bay aycꞌo Comam tuꞌ, yajaꞌ machi yu yocto ebnaj yeb ismiꞌ Comam tuꞌ iscꞌatan̈, yuto caw witzꞌan yehico anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yuxin hallax tet Comam yu anma ayco iscꞌatan̈ tuꞌ: —Mamin, aycꞌo hamiꞌ yeb ebnaj hawuẍta istin̈a, tolab choche cachyilaꞌ, ẍi anma tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Istakꞌwi Comam tet anma: —Macn̈eticꞌa chiꞌaben Istzotiꞌ Comam Dios cat isyijeni, haꞌ ton huntekꞌan tuꞌ hacaꞌ inmiꞌan yehi, haꞌ hacaꞌ wuẍtajan yepaxoj, ẍi Comam tet anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ay huneꞌ tzꞌayic xin octo Comam Jesús yul teꞌ barco yeb ebnaj chicuywi yinta Comam. Yalni Comam tet ebnaj: —Ton̈we bey iskꞌaxepicꞌto haꞌ lago tiꞌ, ẍi Comam. Isto ebnaj yeb Comam xin. ");
INSERT INTO jacNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hayet lan̈an yecꞌto ebnaj yiban̈ ha haꞌ yul teꞌ barco tuꞌ, iswaycan̈ Comam yul teꞌ. Istit huneꞌ niman jakꞌekꞌ sicꞌlebil, ismakꞌnicto jakꞌekꞌ ha haꞌ yul teꞌ. Etza xin tocano teꞌ yich haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yuxin oc ebnaj yikꞌalo iswayan̈ Comam. Yalni ebnaj tet Comam: —Mam cuywawom, Mam cuywawom, lan̈anxa coto yich haꞌ, ẍi ebnaj tet Comam. Yaben̈e Comam tzet yal ebnaj xin, yahwano Comam, yalni Comam tet jakꞌekꞌ yeb tet ha haꞌ ta chislin̈ba isba, ispaxtzꞌin̈na xin. ");
INSERT INTO jacNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yalni Comam tet ebnaj: —¿Tzet yin̈ xin mach cheyaco Comam Dios yipo heyanma? ẍi Comam. Caw xiw ebnaj, iscꞌayilo iscꞌul ebnaj, yallen ebnaj tet hunun: —¿Tzet yelapno ye huneꞌ naj winaj tiꞌ? Caw chisyije jakꞌekꞌ yeb ha haꞌ tzet chal naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lahwi tuꞌ xin yecꞌ apno ebnaj iskꞌaxepicꞌto haꞌ lago yul ismajul Gadara yetcꞌulal Galilea. ");
INSERT INTO jacNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hayet yel Comam Jesús yul teꞌ barco istiꞌ haꞌ tuꞌ, yapni huneꞌ naj ay yul con̈ob tuꞌ iscꞌatan̈ Comam, ayco ischejab naj matzwalil yin̈ naj. Txꞌiꞌalxa tiempo istzabchati naj, matxaticꞌa chaco naj xil iskꞌap, matxa xin choche naj chicancano naj yul hunu n̈a, haxan̈e xolaj panteón yul camposanto chꞌecꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hayet yilnito naj Comam Jesús, yah yaw naj, isjahbanoyo isba naj sata Comam, yalni naj yin̈ caw ip: —¿Tzet hawoc win̈an Jesús, Iscꞌahol Comam Dios caw aycano yip? Chinkꞌanan tawet mach chawakꞌ ecꞌoyaꞌ wanmahan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yal naj huneꞌ tuꞌ yuto ischejilo Comam ebnaj ischejab naj matzwalil yin̈ naj. Txꞌiꞌalxa el chietalax naj yu ebnaj ischejab naj matzwalil tuꞌ. Chꞌalaxico chꞌen cadena yin̈ iskꞌab naj yu anma, cat iscꞌalbalax yoj naj yu chꞌen cadena tuꞌ yun̈e machi bay chito naj, yaj chislin̈to naj chꞌen, cat yijbalaxto naj yu ischejab naj matzwalil bey txꞌotxꞌ desierto. ");
INSERT INTO jacNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iskꞌamben Comam tet naj: —¿Tzet habi? ẍi Comam. Istakꞌwican̈ naj tet Comam: —Legión inbihan, ẍi naj tet Comam. Hac tuꞌ yute yalni naj tet Comam yuto caw tzetcꞌa ebnaj ischejab naj matzwalil ayco yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yalni ebnaj ischejab naj matzwalil tet Comam ta machi chalaxto ebnaj yu Comam bey yul huneꞌ niman xab. ");
INSERT INTO jacNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cꞌuxan xin tzetcꞌa noꞌ txitam lan̈an islo yin̈ iscꞌul witz iscawilal istiꞌ haꞌ lago tuꞌ. Yalni ebnaj ischejab naj matzwalil tet Comam ta chichejlaxto ebnaj yin̈ noꞌ txitam tuꞌ. Ishehla Comam tet ebnaj xin. ");
INSERT INTO jacNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hac tuꞌ xin yu yel ebnaj ischejab naj matzwalil yin̈ naj, yapnicano ebnaj yin̈ noꞌ txitam. Iskꞌojnito isba noꞌ sat pahaw, yay apno noꞌ yul haꞌ lago tuꞌ, ishikꞌnito noꞌ haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hayet yilni ebnaj tan̈em txitam huneꞌ tuꞌ, yelcan̈ ebnaj yin̈ an̈e, yalnicꞌo ebnaj yul con̈ob yeb xin tet macta pujanto yatut xolaj telaj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yuxin sunil anma apni ilno tzet yu tuꞌ. Hayet yapni anma bay ay Comam, yilni anma naj ayticꞌaco ischejab naj matzwalil yin̈, tzꞌon̈anayo naj yich yoj Comam. Ayxaco xil iskꞌap naj, caw tohol anmaxa naj, yuxin sunil anma tuꞌ caw xiwcan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Haꞌ ebnaj ilni huntekꞌan tzet iswatxꞌe Comam Jesús tuꞌ, haꞌ ebnaj halni tet huntekꞌanxa anma apni ilno yin̈ tzet yu iscawxican̈ naj bay ayico ischejab naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yu huneꞌ tzet yu tuꞌ yuxin sunil anma ay bey yul ismajul Gadara tuꞌ oc halno tet Comam ta chiꞌel Comam yul ismajul Gadara tuꞌ, yuto caw xiw ebnaj yin̈ tzet yuhi. Yocto Comam yul teꞌ barco, ispaxto Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iskꞌanto isba naj bay el ischejab naj matzwalil tuꞌ yinta Comam. Yalni Comam tet naj ta chican naj bayticꞌa ay tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Yalnicano Comam tet naj: —Meltzan̈to hawatut, cat hawalnicꞌo iscꞌulal mayu Comam Dios tawin̈, ẍi Comam tet naj. Isto naj xin, ispujbanicꞌo naj yul con̈ob tzet yu iscawxican̈ naj yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lahwi tuꞌ xin ispaxto Comam Jesús bey iskꞌaxepicꞌto haꞌ lago. Hayet yapni Comam, caw chitzala anma sunil yuto caw echmabil Comam yu anma. ");
INSERT INTO jacNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ay huneꞌ naj iswiꞌehal yeco yijbali yin̈ iscapilla ebnaj Israel, Jairo isbi naj. Apni naj iscꞌatan̈ Comam Jesús, yay jahno naj yich yoj Comam. Iskꞌanni naj tet Comam tato chito Comam bey yatut naj, ");
INSERT INTO jacNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yuto ay hunpilan iscutzꞌin naj caw lan̈anxa iscami, cablahon̈ebxa habil ix. Hayet isto Comam Jesús yinta naj, caw chiswitz isba anma isto bulbon yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Xol anma tuꞌ xin, ayco huneꞌ ix yaꞌay, cablahon̈ebxa habil mach chilin̈i yay istxꞌahwobal ix. Wal xin xaꞌiscꞌaytzelo ix sunil tzet aya yu yan̈chahi, yaj maẍticꞌa huno mac kꞌoji yan̈ten ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tzujanico ix xol anma ayco yinta Comam, ishitzico ix iscꞌatan̈ Comam, ispitni ix istiꞌ xil iskꞌap Comam. Lan̈antoticꞌa xin islin̈ina yay istxꞌahwobal ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iskꞌambenilo Comam tet anma: —¿Mac anmahil huneꞌ manpitnihan? ẍi Comam. Yaj yal anma sunil ta machi mac pitni Comam. Yalni naj Pedro tet Comam: —Mamin, ¿tom mach chawila ta witzꞌan yehico anma tawin̈? Tzetcꞌa mac chistenico isba tawin̈, cat xin hakꞌambenpaxoj, ¿mac maquinpitnihan? cachi, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yalni Comam xin: —Tzicꞌanab yin̈ machi mac heyalni, wal xin ay mac maquinpitnihan yuto mawabehan ta ay huneꞌ anma macawxinacan̈ yu wipan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hayet yilni ix ta mach chu yebanayo ix huneꞌ tuꞌ, toxan̈e chicꞌarla yah ix, yay jahno ix sata Comam. Yalnilo ix yin̈ sat sunil anma tuꞌ tzet yin̈ yuxin ispit ix Comam, yeb tzet yu yan̈cha ix yin̈ an̈e. ");
INSERT INTO jacNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yalni Comam tet ix: —Miyay, macachcawxican̈ yuto maxawayto yul hawanma win̈an. ¡Paxan̈toj! Maꞌoc hawanma yul yehobal, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lan̈antoticꞌa istzotel Comam tet ix xin, yapni huneꞌ naj ispeto bey yatut naj Jairo, yalni tet naj: —Wal ix hacutzꞌin, macamna ix. Nabxan̈e chito Comam cuywawom tiꞌ, ẍi naj tet naj Jairo. ");
INSERT INTO jacNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hayet yaben Comam huneꞌ tuꞌ, yalni Comam tet naj Jairo: —Mach cachxiwi. Haꞌ huneꞌ wal hawuteni, ayto Comam Dios yul hawanma haxinwal chicawxocan̈ hacutzꞌin, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hayet yapni Comam bey yatut naj Jairo tuꞌ, machi huno mac ischacto Comam yul n̈a, han̈cꞌan̈e naj Pedro, yeb naj Juan, yeb naj Jacobo yebpaxo ismam yeb ismiꞌ ix nichꞌan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Toxan̈e chihan̈cha anma yokꞌ yin̈ ix nichꞌan tuꞌ, caw chitzay iscꞌul anma yin̈ ix. Yalni Comam xin: —Mach chexokꞌi. Mach camnajo ix nichꞌan tiꞌ, wal xin ton̈e chiway ix, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Toxan̈e chitzebi anma yin̈ Comam yuto yohtaxa anma tacamnaxa ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yoc tzabno Comam yin̈ iskꞌab ix. Yalni Comam yin̈ caw ip: —Ahan̈wano tzꞌul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lan̈antoticꞌa xin yulcan̈ iscꞌul ix yu Comam, yahwano ix. Yalni Comam ta chiꞌakꞌlax waꞌo ix. ");
INSERT INTO jacNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Caw cꞌayilo iscꞌul ismam yeb ismiꞌ ix yin̈ tzet iswatxꞌe Comam Jesús. Yalnicano Comam xin ta machi bay chihallaxicꞌo tzet yu yulcan̈ iscꞌul ix. ");
INSERT INTO jacNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yet hunel, yawte Comam Jesús ebnaj cablahon̈wan̈ iscuywom iscꞌatan̈. Yakꞌnicano Comam ishelanil yeb yip ebnaj yinilo sunil ischejab naj matzwalil yin̈ anma, yebpaxo xin yakꞌni cawxo ebnaj anma yin̈ tzettaj yabil ayco yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ischejlaxto ebnaj yu Comam yu ispujbanicꞌo ebnaj yin̈ tzet chu yoc anma yul iskꞌab Comam Dios, cat yakꞌnipaxcano cawxo ebnaj anma yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yalni Comam tet ebnaj: —Matzet cheyito yin̈ hebel; mach cheyikꞌ hekꞌojoch, mach cheyikꞌ hetzꞌispa, mach cheyikꞌpaxo heyoch yeb hemelyu, mach cheyipaxto hehelbal. ");
INSERT INTO jacNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Haꞌ teꞌ n̈a bay chexapni wayoj, han̈e bey tuꞌ xin chexcancanoj, mach chehel bay chexwayi masanto yet chexto hunuxa con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yaj ta ay hunu con̈ob bay mach chexchahlaxi, chexel yul huneꞌ con̈ob tuꞌ cat hetzicnicanilo pojoj yin̈ heyoj, hac tuꞌ xin chu heyeniloj ta matxa heyoc yin̈ anma tuꞌ, ta txꞌoj chꞌelico yul sat Comam Dios, ẍi Comam Jesús tet ebnaj ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lahwi tuꞌ xin isto ebnaj sunil yulajla con̈ob yeb yulajla aldea. Yecꞌ ebnaj ispujbanicꞌo Tzotiꞌ yet colbanile tet anma. Yakꞌnipaxo cawxo ebnaj macta yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naj Herodes, naj yahaw yeco yin̈ ismajul Galilea, yabe naj iskꞌumal sunil tzettaj ye tuꞌ iswatxꞌe Comam Jesús, issomchacan̈ yul iswiꞌ naj yuto ay anma chalni hacaꞌ tiꞌ: —Haꞌ huneꞌ naj chiwatxꞌen huntekꞌan tzet yetu tuꞌ, haꞌ ton naj Juan anican̈ haꞌ iswiꞌ anma, hulcan̈ iscꞌul xol camom, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aypaxo anma chihalni: —Haꞌ naj Elías chihul isyeb isba hunelxa, ẍi anma. Ay xin anma chalnipaxoj: —Etza haꞌ huno ebnaj ischejab Comam Dios ecꞌlena yet payat, haꞌ hulcan̈ iscꞌul xol camom, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yalni naj Herodes tuꞌ: —Yaj hanintiꞌan, walan yuxin tzocꞌlaxilto iswiꞌ naj Juan tuꞌ. ¿Mac xin anmahil huneꞌ naj chal ebnaj iskꞌumal tuꞌ? ẍi naj. Wal xin caw yoche naj Herodes tuꞌ yilaꞌ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lahwi ismeltzo ebnaj ischejab Comam Jesús, yoc ebnaj yalno tet Comam yin̈ej tzet ye tuꞌ iswatxꞌe ebnaj. Lahwi tuꞌ isto Comam iscawilal con̈ob Betsaida, han̈cꞌan̈e xin ebnaj iscuywom Comam tuꞌ yito yintaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hayet yaben anma ta to Comam bey tuꞌ, istopaxo anma iscꞌatan̈ Comam. Caw cꞌul yu ischahlax anma yu Comam, yoc Comam iscuyno anma yin̈ tzet chu yoc anma yul iskꞌab Comam Dios. Yakꞌnipaxo cawxo Comam macta yaꞌay. ");
INSERT INTO jacNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hayet lan̈anxa isto tzꞌayic xin, ishitzico ebnaj cablahon̈wan̈ iscꞌatan̈ Comam, yalni ebnaj xin: —Chejto anma tiꞌ issayaꞌ tzet chislo yeb xin bay chiwayi, tojab yulaj aldea yeb xin xolaj wayan̈bal yuto machi teꞌ n̈a iscawilal bay ayon̈ tiꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yalni Comam tet ebnaj: —Akꞌwe waꞌo anma hex tiꞌ, ẍi Comam. Yalnipaxo ebnaj xin: —Yaj han̈echꞌan howeb pan yeb cacꞌon̈ noꞌ cay coxol tiꞌ. ¿Tom xin chon̈tohan̈ colokꞌoꞌan̈ tzet chislo sunil anma tiꞌ? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wal xin aymi howebo mil isbisil ebnaj winaj ayicꞌo bey tuꞌ, yalni xin Comam Jesús tet ebnaj ischejab: —Halwe tet anma ayojab tzꞌon̈no yin̈ hunta bulan, cincuenta isbisil yin̈ hunun bulan, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hac tuꞌ xin yute ebnaj ischejab Comam tuꞌ, yal ebnaj tet sunil anma ta chiay tzꞌon̈noj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Lahwi tuꞌ xin, yinican̈ Comam ixim howeb pan yeb noꞌ cacꞌon̈ cay, istꞌan̈xican̈ Comam satcan̈, yakꞌni Comam yuchꞌandiosal tet Comam Dios. Iskꞌaxponayo Comam ixim, yakꞌni Comam ixim yeb noꞌ cay tet ebnaj ischejab tuꞌ. Yoc ebnaj yitxkꞌanto ixim yeb noꞌ cay tuꞌ yin̈ anma. ");
INSERT INTO jacNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sunil anma waꞌi hantaticꞌa yoche iscꞌul. Lahwi tuꞌ xin yoc ebnaj ischejab Comam tuꞌ iscꞌutxbanocan̈ ixim matxa lahwi yu anma, caw xin cablahon̈ebto motx ixim matxa lahwi yu anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yet hunel xin isheqꞌuilo isba Comam Jesús yu istxahli, yet ischuquil Comam yeb ebnaj iscuywom tuꞌ xin, iskꞌamben Comam tet ebnaj: —¿Mac anmahilinan yalni anma? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Istakꞌwi ebnaj tet Comam: —Ay mac chalni ta hach tiꞌ haꞌ ton naj Juan anican̈ haꞌ iswiꞌ anma, aypaxo mac chalni tato Elías hach. Aypaxo mac xin chalni tato cꞌuxan ta hach tiꞌ ischejab Comam Dios ecꞌlena yet payat tiempo xahulcan̈ iscꞌul xol camom, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Lahwi tuꞌ xin, iskꞌamben Comam tet ebnaj: —Haxaca hex tiꞌ, ¿mac anmahilinan heyalni? ẍi Comam. Istakꞌwi naj Pedro: —Hach tiꞌ, Cristo hach, akꞌbil hamunil yu Comam Dios, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yaj caw cam yalcano Comam Jesús tet ebnaj ta machi hunu mac bay challax huneꞌ tzet yal naj Pedro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yalnipaxo Comam Jesús tet ebnaj iscuywom: —Hanin Akꞌbilintijan texol yu Comam Dios, caw yilal chiwilaꞌan isyaꞌtajil, cat quinyintan̈encaniltojan ebnaj ichamta winaj ijbalom yul con̈ob, yeb xin yu ebnaj yahawil yin̈ ebnaj sacerdote, yebpaxo xin ebnaj cuywawom yin̈ isley naj Moisés. Haꞌ ebnaj tuꞌ xin, chinakꞌni camojan, yajaꞌ yin̈ yet yoxeb tzꞌayic, cat witzitzbican̈an, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lahwi tuꞌ xin, yalni Comam tet sunil anma: —Ta ay hunu mac chiyoche chioc tzujno wintajan, caw yilal ta matxa yeto isba ischuquil. Hinanojab yaben isyaꞌtajil yin̈ sunilbal tiempo, waxan̈ca chiꞌalaxico yin̈ camical. Ta hinan yetan yanma hacaꞌ tuꞌ, ecꞌojab tzujtzun cuywo wintajan. ");
INSERT INTO jacNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yuto haꞌ mac mach hinano iscam wintajan yul sat yiban̈kꞌinal tiꞌ, chiscꞌayto iskꞌinal mach istan̈bal. Wal mac hinan iscam wintajan xin chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kꞌinalo ta ay mac chikꞌoji ismajnicꞌo sunil tzet ay yul sat yiban̈kꞌinal tiꞌ, yajaꞌ ta chitocano yanma huneꞌ mac tuꞌ yin̈ isyaꞌtajil yin̈ huneln̈e, ¿aymi iscꞌulal chischab huneꞌ mac tuꞌ? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta ay mac chitxꞌixwi quinischahnihan yul yanma yeb yin̈ tzet chiwalan, Hanin Akꞌbilintijan texol yu Comam Dios, chintxꞌixwipaxojan yin̈ anma tuꞌ yet chinhulan Yahawoj yeb iskꞌakꞌal wipan, yeb iskꞌakꞌal yip Inmaman, yeb xin yip ebnaj yángel Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Caw chiwalcanojan yin̈ isyelal teyet, ay haywan̈ mac texol hex tiꞌ maẍto chicami, haꞌ chiꞌilni yoccano Comam Dios Yahawiloj, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Waxajebxa tzꞌayic yalni Comam Jesús huntekꞌan tuꞌ xin, yijbanahto Comam naj Pedro yeb naj Jacobo yeb naj Juan iswiꞌ huneꞌ witz yu istxahli tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hayet lan̈an istxahli Comam tuꞌ, ishelni isba yillax sat Comam, wal xil iskꞌap Comam xin, caw sajhopon̈e elicoj, toxan̈e chitzejtzoni. ");
INSERT INTO jacNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yin̈ hamataj isyecan̈ isba naj Moisés yeb naj Elías, yoc ebnaj tzotelo yeb Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hoyanico iskꞌakꞌal yip Comam Dios yin̈ ebnaj yet chitzotel ebnaj yeb Comam yin̈ tzet chiyu yijni isba iscamical Comam bey Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wal naj Pedro yeb ebnaj cawan̈xa yetbi, caw tit iswayan̈ ebnaj, yaj yilo ebnaj iswayan̈, yilni ebnaj iskꞌakꞌal yip Comam yeb cawan̈ ebnaj ayico iscꞌatan̈ Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hayet lan̈anxa ishecꞌnilo isba cawan̈ ebnaj iscꞌatan̈ Comam tuꞌ, yalni naj Pedro tet Comam: —Mam cuywawom, caw sakꞌal ta wal je bey tiꞌ. Etza cꞌul ta chicowatxꞌecan̈an̈ oxebo pat. Hunu hawet, hunu yet naj Moisés, yeb xin hunu yet naj Elías, ẍi naj tet Comam. Yal naj huneꞌ tuꞌ yuto mach chitxumcha yu naj tzet chala. ");
INSERT INTO jacNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lan̈antoticꞌa yalni naj Pedro huneꞌ tiꞌ, yul huneꞌ moyan yen̈elo ebnaj. Caw xiwcan̈ ebnaj iscuywom Comam tuꞌ yet yoc hoyno huneꞌ moyan yin̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Haꞌ xol huneꞌ moyan tuꞌ yabe ebnaj huntekꞌan tzotiꞌ hacaꞌ tiꞌ: —Haꞌ naj tiꞌ Incꞌaholan sicꞌbililo wuhan, abewe tzet chal naj, ẍi. ");
INSERT INTO jacNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lahwi yallax huneꞌ tzotiꞌ tuꞌ, yilni ebnaj ta ischuquilxan̈e Comam Jesús aycꞌoj. Yin̈ huneꞌ tiempohal tuꞌ, machi mac tet yalilo ebnaj yin̈ huneꞌ tzet yil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hayet huneꞌxa tzꞌayical yet ispaxayti ebnaj bey yin̈ iswiꞌ huneꞌ witz tuꞌ, caw tzetcꞌa anma apni chahno Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Haꞌ xol anma tuꞌ xin, elcan̈ yaw huneꞌ naj yin̈ caw ip, yalni naj tet Comam: —Mamin, chinkꞌanan tawet, chawil nino tzet ye huneꞌ nichꞌan incꞌaholtiꞌan, caw hunpilanchꞌan naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuto ay huneꞌ naj ischejab naj matzwalil chꞌetan naj. Caw chiꞌel yaw naj yet chꞌoc naj matzwalil yetano naj. Caw chitzicobtan̈elax naj, cat istit hujuy yul istiꞌ naj. Caw chichacꞌobtan̈elax isnimanil naj, cat ispaxlona naj xin, caw lan̈oxan̈e chisbejtzocano naj matzwalil tuꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mawakꞌle walnihan tet ebnaj hacuywom tiꞌ ta chiyilo ebnaj ischejab naj matzwalil yin̈ naj, yajaꞌ machi yu yu ebnaj, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yalni Comam Jesús tet anma: —Haꞌ ta hex tiꞌ chijala, caw mach cheyaco heyanma yin̈ Comam Dios. Caw hipexcano sicꞌlebil. ¡Caw nimanxa tiempo yichi wecꞌan yeb hex! ¿Bakꞌincꞌanab chexcuychahi? Caw chiwabehan isyaꞌil yul wanmahan, ẍi Comam. Yalni Comam tet naj ay iscꞌahol tuꞌ: —Iti naj hacꞌahol tuꞌ, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yaj hayet ishitzico naj nichꞌan tuꞌ iscꞌatan̈ Comam, iskꞌojlaxayo naj sat txꞌotxꞌ yu naj matzwalil ayco yin̈ naj. Yichico islow huneꞌ yaxcamic yin̈ naj, yajaꞌ haxa Comam Jesús, cachwa yin̈ naj matzwalil tuꞌ, iscawxican̈ naj nichꞌan tuꞌ yu Comam. Yalaxcanico naj yul iskꞌab ismam yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sunil anma tuꞌ cꞌayilo iscꞌul yilni tato caw niman yelapno yip Comam Dios. Hayet cꞌayna iscꞌul anma yilni yin̈ tzet iswatxꞌe Comam Jesús, yalni Comam tet ebnaj iscuywom: ");
INSERT INTO jacNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Caw cheyabecano yin̈ tzet chiwalcanojan teyet, tajca chicꞌayto heyu, yuto Hanin Akꞌbilintijan texol yu Comam Dios, chinalaxicojan yul iskꞌab anma, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yajaꞌ machi nachalo yu ebnaj yin̈ tzet yal Comam tet ebnaj yuto machi akꞌlax istxumuꞌ ebnaj, xiwpaxo ebnaj iskꞌambenilo tet Comam yin̈ tzet chal yelapnoj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lahwi tuꞌ xin, yoc ebnaj iscuywom Comam tzotelo yin̈ mac caw niman yelapno ye xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yajaꞌ xin yohta Comam Jesús tzet chiecꞌ yin̈ isnabal ebnaj, yuxin isxectiꞌ Comam huneꞌ nichꞌan unin iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yalni Comam tet ebnaj: —Haꞌ mac chichahni hunu nichꞌan unin yuto wetan yehi, Haninan chinischahan. Hac tuꞌ xin mac chinchahnihan, chischahpaxo Mac an̈eintijan. Haꞌ mac chiyo isba texol, haꞌ ecꞌbal yelapno ye yul insatan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yalni naj Juan tet Comam Jesús: —Mam cuywawom, jilan̈ yinilo huneꞌ naj ischejab naj matzwalil yin̈ anma, habi yawte naj yin̈, yajaꞌ cocachan̈ naj yuto mach jetbiho naj, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Istakꞌwi Comam: —Mach checach naj, yuto haꞌ mac mach ayoco ishowal jin̈ jetbi coba yebi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hayet lan̈anxa yapni istiempohal ispaxto Comam Jesús satcan̈, yanico Comam yin̈ iscꞌul isto bey con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yulxa beh ayco Comam xin, yanito Comam ischejab yul huneꞌ aldea yul ismajul Samaria iskꞌanno bay chiway Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yajaꞌ machi chahlax ebnaj yu anma ay bey Samaria tuꞌ, yuto yohta anma tato bey Jerusalén chito Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hayet yilni naj Jacobo yeb naj Juan huneꞌ tuꞌ, yalni ebnaj tet Comam: —Mam cuywawom, ¿chimisje hacꞌul chicokꞌanayti kꞌa kꞌakꞌ satcan̈, cat istan̈tzelaxilo huntekꞌan anma tiꞌ hacaꞌ iswatxꞌe naj Elías yet payat? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yajaꞌ tꞌan̈xico Comam yin̈ ebnaj, iscachlax ebnaj yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lahwi tuꞌ xin, isto Comam yeb ebnaj bey yul huneꞌxa aldea. ");
INSERT INTO jacNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hayet lan̈an isbelwito ebnaj yul beh, ay huneꞌ naj halni tet Comam Jesús: —Mamin, bajxan̈etuꞌwal chaẍtohi, chinoc tzujnojan tawintaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yalni Comam tet naj hacaꞌ tiꞌ: —Noꞌ wech, ay isn̈achꞌen noꞌ bay chiwayi, yeb xin noꞌ chꞌic, ay yatut noꞌ, yajaꞌ wal Hanin Akꞌbilintijan texol yu Comam Dios, caw machi watutan bay chinxewninojan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lahwi tuꞌ xin, yalni Comam tet hunxa naj: Ecꞌan̈ tzujtzun wintajan cat hacuywi, ẍi Comam tet naj. Istakꞌwi naj tet Comam: —Mamin, estam chawakꞌ inhamanilan, chito inmujcanto Inmaman babelal, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yalni Comam tet naj xin: —Haꞌ mac camom yul sat Comam Dios haꞌ chimujni yet camomal tuꞌ, walach hach tiꞌ as halicꞌo yin̈ tzet chu yoc anma yalan̈ ischejbanil Comam Dios, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lahwi tuꞌ xin, yalni hunxa naj tet Comam: —Mamin, chinoc tzujnojan tawintaj, yaj chiwochehan ta chawakꞌ inhamanilan chintohan takꞌlocano tet mac ay bey watutan babel, lahwi tuꞌ xin cat woc tzujnojan tawintaj, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yalni Comam tet naj: —Kꞌinalo ta ay hunun mac chimunla yeb noꞌ wacax, cat yoc tzabno yin̈ te teꞌ n̈icꞌbil yu noꞌ bay ayco chꞌen tꞌocom txꞌotxꞌ, tzujan tuꞌ cat istopaxo tꞌan̈no naj yintaj. Ta ay mac hac tuꞌ, mach chu yoc munil yin̈ yet Comam Dios, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lahwi tuꞌ xin, issicꞌlenilo Comam Jesús setentaxa ebnaj iscuywom. Catawan̈ xin yu yanito Comam ebnaj yul hunun con̈ob yeb xol wayan̈bal bayejtuꞌal bay chi-caw-yecꞌpaxo Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hayet maẍto chito ebnaj, yalni Comam tet ebnaj: —Lahan anma yeb ixim trigo xakꞌanbiloj. Yeli caw txꞌiꞌal anma tuꞌ, yajaꞌ haywan̈n̈e mac chalni Istzotiꞌ Comam Dios xol anma. Yuxin txahlan̈we tet Comam Yahaw munil tiꞌ, hac tuꞌ xin chischejti Comam ismunlawom chul inocan̈ anma, cat yanico isba yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Asiꞌwe xin, hacaꞌ noꞌ meꞌ chito xol noꞌ oj, hac tuꞌ chexwute wanitojan xol anma. ");
INSERT INTO jacNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Machica xin cheyito hetzꞌispa yeb xin hetxꞌuy bay ayayto hemelyu, yebpaxo hehelbal xan̈ab. Mach chexocpaxo lin̈no tzotelo yeb huno mac anmahil yulaj beh. ");
INSERT INTO jacNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hayet chexapni bey hunu n̈a, halwe yin̈ babelal hacaꞌ tiꞌ: “Yakꞌabayo Comam Dios akꞌancꞌulal tet huneꞌ n̈ahil anma tiꞌ,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta ay anma chꞌochen huneꞌ akꞌancꞌulal tuꞌ, chꞌakꞌlax tet hacaꞌ cheyute hekꞌanni tet Comam Dios. Ta ay mac mach chiochenpaxo xin, mach chu ischahni. ");
INSERT INTO jacNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Haꞌticꞌa bey huneꞌ n̈a bay chꞌochelax akꞌancꞌulal tuꞌ, haꞌ tuꞌ chexcancanoj. Mach chehecꞌ bay chexwayi. Sunil tzet chꞌakꞌlax helob, chelo cat heyucꞌnipaxo tzet chꞌakꞌlax yiban̈ heyoch, yuto haꞌ naj munlawom chꞌakꞌlax tzet chislo naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hayet chexapni yul hunun con̈ob bay chexchahlaxi, chelo tzet chaꞌkꞌlax teyet. ");
INSERT INTO jacNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cheyakꞌnipaxo cawxo anma yaꞌay, cat heyalni tet sunil anma hacaꞌ tiꞌ: “Istiempohalxa heyanico heba yalan̈ yip Comam Dios tinan̈,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ta ay hunu con̈ob bay mach chexchahlaxi hayet chexpaxtij cheyalnicano yulaj iscallehal con̈ob tuꞌ hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Wal ispojojal hecon̈ob maꞌoc yin̈ jojan̈ chicomakꞌilojan̈ yin̈ hesat! Haꞌ xin chalniloj tato matxa jocan̈ teyin̈ tan̈e xin chijalcanojan̈ teyet, ta ayxaco yip Comam Dios hecawilal,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chiwalpaxojan teyet tato hayet chꞌapni istzꞌayical bay chul Comam Dios, cat yilni tzet chꞌelico anma, haꞌ huneꞌ con̈ob tuꞌ ecꞌbal isyaꞌtajil chischah sata con̈ob Sodoma, ẍi Comam Jesús tet ebnaj ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yalnipaxo Comam Jesús: —Hex ay bey con̈ob Corazín, ¡cꞌanchꞌanex! ¡Cꞌanchꞌanexpaxo ay bey con̈ob Betsaida! Ta haꞌ yul con̈ob Tiro yeb con̈ob Sidón yelax huntekꞌan cꞌaybalcꞌule hacaꞌ chu texol tiꞌ, caw yin̈ an̈emi isbejcano anma istxꞌojal, yamahto anma tan̈ yin̈ iswiꞌ, yamipaxico xil iskꞌap chiyenilo biscꞌulal tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hayet chiꞌayilo istzꞌayical bay chil Comam Dios yin̈ tzet chielico anma, caw ecꞌnaxa niman isyaꞌtajil chechah sata con̈ob Tiro yebpaxo con̈ob Sidón. ");
INSERT INTO jacNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Haxa hex ah Capernaum, ¿ham heyalni ta chexilaxcan̈ satcan̈? ¡Machoj! Wal xin chexkꞌojlaxto xol camom, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yalni Comam tet ebnaj ischejab tuꞌ: —Haꞌ mac chꞌaben tzet cheyala, chabepaxo tzet chiwalan. Yajaꞌ haꞌ mac chiyahni tzet cheyala chinisyahpaxojan. Haꞌ mac chinyahnituꞌan, haꞌ yin̈ Comam Dios chiyahwahi yuto Comam an̈eintijan, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Caw yin̈ tzalahilal meltzo ebnaj setenta ischejab Comam Jesús, yalni ebnaj tet Comam: —Mamin, sunil ischejab naj matzwalil yijen tzet jalan̈ yet jakꞌni binahojan̈ habi, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Istakꞌwi Comam tet ebnaj: —Caw yel cheyala, wilan istitcꞌay naj matzwalil satcan̈ hacaꞌ isjebla hunu cꞌuh. ");
INSERT INTO jacNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yajaꞌ Haninan wakꞌan heyip hebelwicꞌo yiban̈ noꞌ laba yeb xin yiban̈ noꞌ cꞌolotx. Wakꞌnipaxojan heyip hekꞌoji yin̈ naj matzwalil, naj chichiwaco iscꞌul jin̈. Hac tuꞌ xin mach chu quexyetan naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chiwalan teyet mach chextzalahi yuto chiꞌel ischejab naj matzwalil yin̈ anma heyu, tzalahan̈wej yuto tzꞌibn̈ebilxa hebi yul satcan̈, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Caw tzala yanma Comam Jesús yu yip Comam Espíritu Santo, yalni Comam: —Mam, Yahaw hach satcan̈, Yahaw hachpaxo yin̈ huneꞌ sat yiban̈kꞌinal tiꞌ, chiwalan cꞌulla tzotiꞌ tawin̈ yuto chayelo tet ebnaj mach iscuyu huntekꞌan ewan ye hawu tet ebnaj caw ay iscuyu yeb caw ay tzet yohtaj. Hawute hac tuꞌ Mamin, yuto hac tuꞌ el yin̈ hacꞌul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lahwi tuꞌ xin, yalni Comam tet anma: —Sunil akꞌbilxa yul inkꞌaban yu Inmaman. Machi mac ohtan̈e hanin Cꞌahole intiꞌan, cachann̈e Comam ohtan̈e hinan. Machi mac ohtan̈e Inmaman, haninn̈ehan Iscꞌahol intiꞌan wohtajan. Chiwakꞌpaxojan ohtan̈elaxo Inmaman tet mac chiwochehan. ");
INSERT INTO jacNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lahwi tuꞌ xin yalni Comam tet ebnaj iscuywom ischuquil: —Sakꞌal yet mac chꞌilni huntekꞌan cheyil tiꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuto caw txꞌiꞌal ebnaj ischejab Comam yet payat yeb ebnaj rey ecꞌlena payxa tuꞌ, yoche yilaꞌ huntekꞌan cheyil tiꞌ, yaj mach yil ebnaj. Yoche yabeꞌpaxo ebnaj hacaꞌ hex tiꞌ, yaj machi yabe ebnaj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ay huneꞌ naj cuywawom yin̈ isley naj Moisés apni tzotelo tet Comam Jesús, yaj yun̈e yilwen naj Comam, yuxin yal naj hacaꞌ tiꞌ: —Mam cuywawom, ¿tzet wal wuten inbahan yun̈e inchahnihan huneꞌ kꞌinal mach istan̈bal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Istakꞌwican̈ Comam tet naj: —¿Hawohtami tzet tzꞌibn̈ebilcano yin̈ isley naj Moisés? ¿Tzet cuybanilehal chawikꞌa yet chawilni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Istakꞌwi naj: —Oche Comam Dios Jahawil yeb sunil hawanma yeb sunil hacꞌul yeb sunil hanabal, yebpaxo sunil hawip. Xahan chawil hawet anmahil hacaꞌ chu hayaꞌiln̈en haba, ẍiayoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yalni Comam tet naj: —Caw cꞌul mayu hawalni. Ta chayije tzet chala, ay hakꞌinal mach istan̈bal, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yajaꞌ huneꞌ naj cuywawom tuꞌ, yoche naj challax naj cꞌulal yin̈ sat anma, yuxin yal naj tet Comam Jesús: —¿Mac xin wet anmahilan hawalni? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yalni Comam tet naj: —Yet hunel ay huneꞌ naj winaj lan̈an isto yul isbelal Jerusalén chiꞌapni bey con̈ob Jericó, ay huntekꞌan ebnaj elkꞌom elilo yin̈ naj yul beh tuꞌ. Yinilo ebnaj sunil tzet ikꞌbil yu naj, yinipaxilo ebnaj xil iskꞌap naj. Ismakꞌni taho ebnaj naj, etza cam naj yu ebnaj, lahwi tuꞌ yelcan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Cꞌuxan xin yecꞌto huneꞌ naj sacerdote Israel yul huneꞌ beh tuꞌ, hayet yilnico naj naj, ishecꞌnilo isba naj tet naj, isto naj yin̈ isbel. ");
INSERT INTO jacNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yecꞌpaxto huneꞌ naj levita yul huneꞌ beh tuꞌ, ton̈e yilpaxico naj yin̈ naj, ishecꞌnipaxo isba naj, isto naj xin. ");
INSERT INTO jacNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yaj ay huneꞌ naj ah Samaria ecꞌpaxo yul huneꞌ beh tuꞌ. Hayet yilnico naj yin̈ naj etza cam tuꞌ, caw tzꞌaycan̈ iscꞌul naj yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ishitzico naj iscꞌatan̈ naj, yan̈ten naj islahwilal naj tuꞌ yu aceite yeb vino. Ispichnico naj kꞌap yin̈ islahwilal naj tuꞌ. Yanahto naj naj yiban̈ ischeh. Yinito naj naj bey huneꞌ waybal, yoc naj yilno naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Haxa yin̈ hunxa tzꞌayic yet ispaxto naj, yakꞌni naj cabeb chꞌen melyu denario tet naj yahaw waybal tuꞌ, yalni naj xin: —Chawilcano huneꞌ naj tiꞌ inkꞌanaꞌan. Ta ayto tzet chacꞌay yin̈ naj, chintohlahan yet chinhulan hunelxa, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iskꞌamben Comam Jesús tet naj cuywawom yin̈ isley naj Moisés hacaꞌ tiꞌ: —Xol ebnaj oxwan̈ tuꞌ, ¿mac caw yet anmahil naj etza cam yu ebnaj elkꞌom tuꞌ chute hawalni? ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Istakꞌwican̈ naj cuywawom tuꞌ: —Haꞌ naj tzꞌay iscꞌul yoc colwal yin̈ naj, ẍi naj. Yalni Comam Jesús: —Wal tinan̈ xin, haꞌ tzet iswatxꞌe naj tuꞌ, hacojab tuꞌ chawute, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isto Comam Jesús yin̈ isbel, yapni Comam bey huneꞌ aldea. Haꞌ bey tuꞌ xin ay huneꞌ ix, Marta isbi. Ischahni ix Comam yul yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aypaxo huneꞌ isnoh ix, María isbi. Ix María tuꞌ, ay tzꞌon̈no ix yich yoj Comam Jesús yu yaben ix tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Walpaxo ix Marta, caw haꞌ iswatxꞌen ix ismunil ayco yin̈ iscꞌul. Yuxin hitzico ix iscꞌatan̈ Comam Jesús, yalni ix: —Mamin, ¿tzet yin̈ ton̈e chawila chinisbejnicanojan ix innohtiꞌan munil inchuquilan? Hal tet ix colwaojab nino ix win̈an, ẍi ix Marta tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Istakꞌwican̈ Comam xin: —Marta, Marta, caw yin̈n̈e hamunil ayco hanabal. Caw machi akꞌancꞌulal yul hawanma. ");
INSERT INTO jacNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yaj huneꞌn̈e tzet caw yilal yehi, haꞌ ton bay ayco yanma ix María tiꞌ, yuxin machi mac chu yinilo tet ix, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ay hunel xin txahli Comam Jesús bey huneꞌ txꞌotxꞌ, yet lahwi istxahli Comam tuꞌ, yalni huneꞌ iscuywom Comam tet: —Mamin, cuyon̈an̈ cotxahlihan̈ hacaꞌ yu iscuyni naj Juan ebnaj iscuywom istxahli tet Comam Dios, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yalni Comam tet ebnaj: —Hayet chextxahli, hac tiꞌ cheyute heyalni: Hach Comam, hach coDios, ayach yul satcan̈, nimanojab yelapno habi yul sat anma. Hulan̈ cat hawoc Yahawilo yul sat yiban̈kꞌinal tiꞌ. Yijab isba tzet chawoche sat txꞌo txꞌotxꞌ tiꞌ, hacaꞌ yijni isba tzet chawoche yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mamin, chicokꞌanan̈ tawet, akꞌ tzet chicolohan̈ hunun tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Akꞌ nimancꞌulal yin̈ sunil cotxꞌojalan̈, hacaꞌ chiyu jakꞌnihan̈ nimancꞌulal yin̈ anma chiwatxꞌen istxꞌojal jin̈an̈. Mach chon̈hachayojan̈ xol ilwebal, caw cólon̈ilojan̈ yul iskꞌab naj matzwalil, quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yalnipaxo Comam tet ebnaj iscuywom tuꞌ: —Kꞌinalo ta ay hunujex hex tiꞌ chexto yet chuman akꞌbal bey yatut hunu heyamigo cat heyalni: “Hach wamigo, akꞌ hanicꞌo tzet chalo inhelaꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","To ay huneꞌ wamigohan lan̈anto yapni yin̈ isbel bey watutan, yaj matzet wal wakꞌnihan tet naj,” ta quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yaj ta chiyal naj yulicto yatut tuꞌ hacaꞌ tiꞌ: “Ayxaco istel inpultahan, mach chaẍhul hawikꞌalo inwayan̈an tinan̈. Lan̈an inwayan yeb niẍte wuninalan sat txꞌat, yuxin mach chu wahwanojan wakꞌnojan tzet chakꞌanaꞌ,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wal xin chiwalan teyet, chiahwano naj yakꞌaꞌ tzet chekꞌana, yaj maẍtaj yu caw heyamigo ye naj, wal xin chiahwano naj yuto caw huneꞌn̈e haꞌ yelicꞌto heyaw, cat yakꞌni naj tzet chekꞌanaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yuxin chiwalan teyet: Kꞌanwe tet Comam Dios, cat yakꞌni Comam teyet. Saywej, cat yilchaho heyu, elojabico heyaw yin̈ sat pulta cat ishajlax teyet. ");
INSERT INTO jacNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yuto haꞌ mac chikꞌanni chischah, haꞌ mac chisayni chiꞌilcha yu. Haꞌ mac chiꞌelico yaw sat pulta, chihajlax tet. ");
INSERT INTO jacNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hacaꞌ hex mame hex tiꞌ, ta chiskꞌan heyuninal hunu noꞌ cay teyet, ¿tom cheyakꞌ huno noꞌ laba tet? ");
INSERT INTO jacNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Maca, ta chiskꞌan huno noꞌ hos teyet, ¿tom cheyakꞌ huno noꞌ cꞌolotx tet? ");
INSERT INTO jacNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Waxan̈ca txꞌojex, yaj heyohta heyakꞌni iscꞌulal tet heyuninal, hajxam Comam Dios ay yul satcan̈, to chakꞌ Comam Comam Espíritu Santo tet mac chikꞌanni, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ay huneꞌ naj ayco ischejab naj matzwalil yin̈, yuxin mach chu istzotel naj. Haxa yet yapni Comam Jesús, yinilo Comam ischejab naj matzwalil yin̈ naj, istzotelcan̈ naj. Yuxin caw cꞌaycanocan̈ iscꞌul anma yilni. ");
INSERT INTO jacNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yajaꞌ ay mac halni: —Haꞌ naj Beelzebú, naj yahawil yeco yin̈ ebnaj ischejab naj matzwalil, haꞌ chiꞌakꞌni yip naj tiꞌ yinilo ischejab naj matzwalil yin̈ anma, ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ay huntekꞌanxa ebnaj ton̈e yoche yilweꞌ ta yip Comam Dios ayco yin̈ Comam Jesús, yuxin iskꞌan ebnaj yilaꞌ hunu cꞌaybalcꞌule tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yaj yohtan̈elo Comam tzet chꞌecꞌ yin̈ isnabal ebnaj, yuxin yal Comam hacaꞌ tiꞌ: —Kꞌinaloj ta ay hunu niman con̈ob ay ebnaj yahawil howal chispohle isba, cat ispaqꞌuico ebnaj yin̈ hunun, yin̈ hamataj chitan̈ilo huneꞌ niman con̈ob tuꞌ. Hac-ticꞌa-pax tuꞌ ta ay hunu n̈ahil anma chispohle isba yu howal, chitan̈paxilo huneꞌ n̈ahil anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hacmi tuꞌ chꞌelico naj matzwalil, ta chispoh isba naj yeb ischejab, cat ispaqꞌuico ebnaj yin̈ hunun. ¿Tzicꞌanab chu yoc yip naj chiyute heyalni? Chiwalan huneꞌ tiꞌ teyet yuto hex tiꞌ cheyala ta hanintiꞌan chiwilojan ischejab naj matzwalil yin̈ anma yu yip naj Beelzebú. ");
INSERT INTO jacNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wal xin ¡machoj! Ta hac tuꞌ, ¿mac xin chꞌakꞌni yip ebnaj chicuywi teyintaj yinilo ischejab naj matzwalil heyalni? Yuxin haꞌ hun ebnaj tuꞌ chiyenilo ta hex tiꞌ caw cꞌaynajexto yin̈ tzet cheyal win̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wal hanintiꞌan chiwilojan ischejab naj matzwalil yu yip Comam Dios, haꞌ hun tiꞌ chihalniloj ta xaꞌapni istiempohal heyoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kꞌinalo ta ay hunu naj winaj caw ay yip ayco chꞌen yet howal yul iskꞌab, cat istan̈en naj yatut, machi mac chu yelkꞌanoti tzet ay naj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yaj ta ay hunuxa mac chuli, ecꞌnaxapaxo yip sata naj, chiꞌaycꞌay naj yu naj, cat yilaxilo chꞌen yet howal tet naj bay ayco yanma naj tuꞌ; yeb sunil tzet ayco yul iskꞌab naj chꞌoccano yu naj chikꞌoji yin̈ naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Haꞌ mac mach ayoco yin̈ tzet chiwalan, chichiwa iscꞌul win̈an. Yeb xin, haꞌ mac mach chicolwa win̈an iscutxbanti anma wetan, haꞌ ton chitzumbenilo anma yul inkꞌaban, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kꞌinalo ta ay hunu ischejab naj matzwalil chꞌel yin̈ hunu naj winaj, lahwi tuꞌ cat isto ischejab naj matzwalil tuꞌ bey txꞌotxꞌ desierto issayno bay chixewi. Yaj ta mach chiꞌilcha yu naj bay chixew tuꞌ, cat yalni naj hacaꞌ tiꞌ: —Caw cꞌulmi inmeltzohan bayticꞌa titnajinan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Haxa yet ismeltzo ischejab naj matzwalil tuꞌ xin, yilni naj ta hacaꞌ hunu n̈a caw tzꞌisbilxalto kꞌalem yul yeb watxꞌebil, hac tuꞌ ye yul yanma naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yuxin yin̈ an̈e chito naj ischejab naj matzwalil tuꞌ yawteti hujwan̈oxa yetbi caw ecꞌnaxa istxꞌojal sata naj, cat yocto ebnaj yul yanma huneꞌ naj winaj tuꞌ. Caw xin ecꞌbalxa istxꞌojal chielico naj sata yet yalan̈tocanoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hayet lan̈an yalni Comam Jesús huntekꞌan tuꞌ, yah yaw huneꞌ ix xol anma, yalni ix tet Comam: —Caw sakꞌal yet ix ix cachuninn̈eni, yeb cachakꞌni chꞌiboj, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Istakꞌwi Comam: —Ecꞌbalto sakꞌal yet anma chiꞌaben Istzotiꞌ Comam Dios cat isyijeni, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yet iscꞌutxban isba anma iscꞌatan̈ Comam Jesús, yalni Comam xin: —Haꞌ anma yin̈ huneꞌ tiempohal tiꞌ machiswalil isnabal yuto chiskꞌan yilaꞌ cꞌaybalcꞌule chiyeni yip Comam Dios, yajaꞌ huneꞌchꞌan chꞌakꞌlax yilaꞌ; huneꞌ hacaꞌ isye Comam Dios yin̈ naj Jonás, naj ischejab Comam yet payat. ");
INSERT INTO jacNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Huneꞌ isye Comam Dios yin̈ naj Jonás tuꞌ, yechel yip Comam isye tet anma yul con̈ob Nínive yet payat. Hac tuꞌ wehan, Hanin Akꞌbilintijan texol yu Comam Dios. yechel yip Comam Dios wehan xol anma yin̈ huneꞌ tiempohal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hayet chꞌapni istzꞌayical yilni Comam Dios yin̈ tzet chꞌelico sunil anma, chitakꞌwican̈ ix reina ay bey Sabá, cat yalni ix istxꞌojal anma yin̈ huneꞌ tiempohal tiꞌ yuto caw nahat txꞌotxꞌ bay tit ix yabeno hanta yitzꞌatil iswiꞌ naj rey Salomón. Yaj xin hanintiꞌan, ecꞌbal welapnojan sata naj rey Salomón tuꞌ, yajaꞌ mach chabeto anma tiꞌ tzet chiwalan. ");
INSERT INTO jacNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yin̈ huneꞌ tzꞌayical tuꞌ, chitakꞌwipaxocan̈ anma ah Nínive, cat yalnipaxo istxꞌojal anma yin̈ huneꞌ tiempo tiꞌ, yuto hayet yecꞌ naj Jonás yalno Istzotiꞌ Comam Dios tet anma tuꞌ, isbejnicano anma istxꞌojal, iswatxꞌenico isba sata Comam. Yaj wal hanintiꞌan ecꞌbal welapnojan sata naj Jonás tuꞌ, yaj machi mac tiꞌ chꞌaben tzet chiwalan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Machi huno mac chaco kꞌaꞌ yin̈ iscantil cat yebanto yalan̈ hunu teꞌ almuh maca yalan̈ hunuxa tzet ye tuꞌ, machoj, to nahat chꞌahi haxinwal cꞌul yilni anma chꞌoc apno yul n̈a. ");
INSERT INTO jacNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Isbakꞌ cosat, cantil yeco yin̈ conimanil. Yuxin ta han̈cꞌan̈e iscꞌulal choche yilaꞌ cosat tiꞌ, sunil conimanil ayco yin̈ issajilkꞌinal. Yajaꞌ ta yin̈n̈e istxꞌojal bay ayco cosat xin, sunil conimanil ayco yin̈ kꞌejholo. ");
INSERT INTO jacNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yuxin nann̈eojab heyu, haxinwal haꞌ huneꞌ issajilkꞌinal ayco teyin̈, machojab chꞌoc kꞌejholohal. ");
INSERT INTO jacNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yuxin tato ayco issajilkꞌinal yul heyanma, yebpaxo machi nichꞌano kꞌejholo ayco teyin̈, hacaꞌ xol issajilkꞌinal ayexxacoj. Yuxin lahanex hacaꞌ hunu cantil nahat chiapni ismujli iskꞌakꞌal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hayet lahwi istzotel Comam Jesús yeb anma tuꞌ, yawtento huneꞌ naj fariseo Comam waꞌo bey yatut. Yapni Comam yul yatut naj, yoc tzꞌon̈no Comam yin̈ meẍa. ");
INSERT INTO jacNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yet lan̈an yoc Comam waꞌoj, cꞌayilo iscꞌul naj fariseo yet yilni naj ta mach istxꞌah iskꞌab Comam hacaꞌ iscuybanil ebnaj fariseo yet chꞌoc ebnaj waꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yuxin yal Comam tet naj: —Hex fariseo hex tiꞌ, caw cꞌul chu hetxꞌahni yinta hevaso yeb hesecꞌ hacaꞌ yalni hecuybanil, wal yul henabal han̈cꞌan̈e elekꞌ nabil yu, haxapaxo yul heyanma xin, nohna yu sunil istxꞌojal chewatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Caw wiꞌe excanoj! ¿Tom mach heyohtajoj tato haꞌ Comam watxꞌen̈e sunil tzettaj chijilico yin̈, yebpaxo sunil mach chijilico yin̈? ");
INSERT INTO jacNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yuxin haꞌ wal heyuten heba, aweco heyanma yul iskꞌab Comam, ta hac tuꞌ chisajbicano heyanma yu Comam, haxinwal cheyakꞌ tet mac matzet aya yin̈ tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Cꞌanchꞌanex fariseo hex tiꞌ! cheyakꞌ isdiezmohal teꞌ alawena yeb teꞌ ruda yeb sunil teꞌ niẍte itah tet Comam Dios, yajaꞌ mach chewatxꞌe istoholal yin̈ heyet anmahil, yebpaxo xin machi iscꞌulchꞌanil iscꞌul Comam Dios yul heyanma. Haꞌ huntekꞌan tuꞌ caw yilal heyijeni, machi xin chebej heyakꞌni hediezmo tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Cꞌanchꞌanex hex fariseo, hex tiꞌ! Hexn̈e cheyoche hemajalo huntekꞌan chꞌem caw ay yelapno yul capilla. Ay heyalaꞌ ta nanxa yoc chute istioẍli anma teyet yet chexecꞌ yulaj beh. ");
INSERT INTO jacNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Cꞌanchꞌanex hex fariseo, hex tiꞌ! Caw txꞌoj heyanma, lahanex hacaꞌ bay mujan camom matxa ixtan̈o jilni yecꞌlenal; chꞌecꞌ xan̈xon anma yiban̈, mach xin yohtajo tzet ayayto yalan̈ txꞌotxꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yalni huneꞌ naj cuywawom yin̈ isley naj Moisés tet Comam: —Mamin, hayet chawalni huntekꞌan tiꞌ, han̈-hun-on̈an̈ chawakꞌpaxo taco cocꞌulan̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Istakꞌwi Comam tet naj: —¡Cꞌanchꞌanexpaxo, hex cuywawom yin̈ isley naj Moisés! Yuto caw ay huntekꞌan chejbanile caw yaꞌta cheyakꞌ tet anma hacaꞌ hunu ijatz caw al, machi mac chikꞌoji yinican̈. Walexpaxo xin, maẍticꞌa nichꞌano yiximal hekꞌab chehitzico yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Cꞌanchꞌanex yuto checayen̈e hewatxꞌencan̈ bay mujan ebnaj ischejab Comam Dios potxꞌbil yu heyichmam yet payat. ");
INSERT INTO jacNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hac tuꞌ xin chu heyenilo yin̈ tzet chewatxꞌe tiꞌ tato chextzala yin̈ tzet iswatxꞌe heyichmam tuꞌ. Haꞌ ebnaj potxꞌni ebnaj ischejab Comam Dios, walexpaxo xin, chewatxꞌecan̈ bay mujan ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yuxin halbilcano yu Comam Dios yu ishelanil: “Chiwakꞌatojan ebnaj inchejaban yeb huntekꞌanxa ebnaj chihalnocꞌo Intzotiꞌan texol. Ay ebnaj chemakꞌ camoj, ay ebnaj chetzumbelo yul con̈ob,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yalnipaxo Comam Jesús: —Huntekꞌan anma tiꞌ chitohlano sunil isyaꞌtajil iswatxꞌecano yichmam yin̈ ebnaj ischejab Comam Dios makꞌbil camo yettax yichico yul yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Caw tzetcꞌa ebnaj ischejab Comam makꞌbil camoj, chiꞌichicanti yin̈ iscamical naj Abel masanta yin̈ iscamical naj Zacarías, yet ismakꞌlax camo naj xolbal bay chin̈uslax xahanbal yeb yatut Comam Dios. Yaj haninan chiwalan teyet ta Comam Dios chiꞌaniti isyaꞌtajil yiban̈ anma tiꞌ yu iscamical ebnaj tuꞌ, ẍi Comam Jesús tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yalnipaxo Comam Jesús: —¡Cꞌanchꞌanex hex checuy isley naj Moisés! Caw yahaw hex heyakꞌni isnabal anma yin̈ Istzotiꞌ Comam Dios, yajaꞌ mach cheyaco henabal yin̈, yebpaxo ta ay mac choche chaco isnabal yin̈, mach chechacto anma yul ispultahil, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yin̈ huneꞌ tiempohal tuꞌ xin caw oc ishowal ebnaj fariseo yeb ebnaj cuywawom yin̈ isley naj Moisés yin̈ Comam Jesús. Yichico ebnaj buchwal yin̈ Comam, caw txꞌiꞌal tzet iskꞌambelo ebnaj tet Comam, ");
INSERT INTO jacNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","yun̈e yaycꞌay Comam yin̈ hunu lekꞌtiꞌal, cat yoc ebnaj akꞌocꞌule yin̈ Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wal xin caw ismilalxa anma iscutxba isba yaben tzet chal Comam Jesús, toxan̈e chistenle isba anma. Yalni Comam Jesús tet ebnaj iscuywom: —Cheyil heba tet ebnaj fariseo, yuto chal isba ebnaj cꞌulal. Wal xin haꞌ iscuybanil ebnaj lahan hacaꞌ nichꞌan yan̈al ixim pan chꞌoc xol ixim harina, sunil ixim chisipcꞌa yu. ");
INSERT INTO jacNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yuto sunil tzet ebabil chꞌelo yen̈el, yebpaxo sunil tzet ewan yehi chꞌixtan̈wilo sata anma. ");
INSERT INTO jacNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yuxin yin̈ caw yel chiwalan teyet, sunil tzet cheyal xol kꞌejholo chiꞌabelaxo yu anma yet tzꞌayical, yebpaxo sunil tzotiꞌ chihallax yin̈ nancꞌulal yul hunu n̈a, chihallaxo yin̈ caw ip istin̈a. ");
INSERT INTO jacNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Walex wamigo hextiꞌan, chiwalan teyet mach chexxiw tet ebnaj chu ispotxꞌni camo henimanil, yuto matxa hunuxa tzet wal quexyuten ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yaj chiwalan teyet, mac tet bay wal hexiwi, haꞌ ton tet Comam Dios, Comam chu quexyakꞌni camoj, chilahwi tuꞌ aypaxo yip quexyanito xol kꞌa kꞌaꞌ mach istan̈bal. Haꞌ ton tet Comam tuꞌ chexiwi. ");
INSERT INTO jacNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Chisje hetxumnilo yin̈ noꞌ niẍte chꞌic, hocꞌon̈ noꞌ yin̈ cab centavo, yaj machi hunu noꞌ chito nahul yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hajxamex hex tiꞌ, caw niman hayelapno sata noꞌ. ¿Tom mach cheyohtajoj ta sunil xil hewiꞌ bisbil yin̈ hununtajil yu Comam? Yuxin chiwalan teyet, mach chexxiwi. ");
INSERT INTO jacNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chiwalan teyet, macn̈eticꞌa mach chitxꞌixwi yalnilo isba sata anma ta wetan yehi, Hanin Akꞌbilintijan texol yu Comam Dios, chiwalan ta wetan anma tuꞌ sata ebnaj yángel Comam ay bey satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yajaꞌ mac chitxꞌixwi yalni sata anma ta wetan yehi, chiwalpaxojan sata ebnaj yángel Comam Dios tato mach wetojan ye anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Macta chibuchwahi cat yalni hunu tzotiꞌ txꞌoj win̈an, Haninan Akꞌbilintijan texol yu Comam Dios, ayto nimancꞌulal yin̈, yaj mac chihalni txꞌoj tzotiꞌ yin̈ Comam Espíritu Santo, matxa nimancꞌulal yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hayet chexilaxto sata ebnaj yahawil yeco yin̈ iscapilla ebnaj Israel, maca sata ebnaj juez, maca satapaxo ebnaj alcal, mach chꞌoc yin̈ hecꞌul yin̈ tzet chu hecolni heba, yeb tzet chu hepajtzen istzotiꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yuto hayet chiꞌapni istiempohal heyilaxto sata ebnaj, haꞌ Comam Espíritu Santo chakꞌni hehelanil hetzoteli, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xol anma tuꞌ, ay huneꞌ naj halni tet Comam Jesús hacaꞌ tiꞌ: —Mam cuywawom, hal tet wuẍtatiꞌan inkꞌanaꞌan yakꞌaꞌab naj inmajulan yin̈ tzet akꞌbilcano jetan̈ yu comaman̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yaj yal Comam tet naj: —Hach wet anmahil, hanintiꞌan mach alcalo wecojan texol, cat inpohnitojan tzet ye tuꞌ teyin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yalni Comam tet anma xin: —Nann̈e heyu, caw cheyil heba, mach chetzꞌunico heyanma yin̈ kꞌalomal, yuto iskꞌinal anma mach chipitzcꞌati yin̈ tzettaj ay yul iskꞌab, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yalni Comam huneꞌ yechel tiꞌ tet anma: —Ay huneꞌ naj winaj caw kꞌalom, caw niman sat istzꞌunub yakꞌa. ");
INSERT INTO jacNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yuxinto yal naj kꞌalom tuꞌ ischuquil hacaꞌ tiꞌ: “¿Tzet wal wuten inbahan? Caw matxa chabe bay chincꞌubahan sat intzꞌunubtiꞌan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Istit yin̈ isnabal naj, yalni naj hacaꞌ tiꞌ: “Wohtaxahan tzet chinwatxꞌeꞌan. Chiwuchcꞌayojan huntekꞌan incꞌun̈atiꞌan, cat inwatxꞌenojan huntekꞌanxa caw nimej chu, haxinwal cꞌuxan yocto sunil sat intzꞌunubtiꞌan yul yeb sunil tzet ayinan. ");
INSERT INTO jacNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chilahwi tuꞌ xin cat inxewan yuto ay tzet ayinan yin̈ sunilbal tiempo. Chinxewan yeb chinwaꞌan, cat wakꞌnihan tzet choche wanmahan, cat wakꞌni tzalaho incꞌulan,” ẍi naj tet yanma. ");
INSERT INTO jacNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tzujan tuꞌ xin, yalni Comam Dios tet naj: “¡Caw machi hawiꞌ! Yin̈ huneꞌ akꞌbal tiꞌ chaẍcamoj. ¿Mac tet xin chicanocano huntekꞌan cꞌubabil hawu tiꞌ hawalni?” ẍi Comam Dios tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hacaꞌ ton huneꞌ naj winaj tiꞌ, hac tuꞌ ye anma yin̈n̈eticꞌa kꞌalomal chaco yanma, yuxin yul sat Comam Dios caw mebaꞌ huntekꞌan anma tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Lahwi tuꞌ xin, yalni Comam Jesús tet ebnaj iscuywom: —Chiwalan teyet, mach cheyaco yin̈ hecꞌul yin̈ tzet chelo yebpaxo yin̈ bay chitit istohol xil hekꞌap cheyacoj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Heyohtaj tato haꞌ Comam Dios chꞌakꞌni cocawil, ¿hatocꞌanab tzet chicolo mach chakꞌ Comam heyalni? Haꞌ Comam akꞌnipaxo huneꞌ conimanil tiꞌ ¿tom mach chakꞌapaxo Comam xil cokꞌap heyalni? ");
INSERT INTO jacNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chisje hetxumni yin̈ noꞌ hoh, machi yawal noꞌ chacoj, mach chihatxꞌwipaxo noꞌ, machipaxo iscꞌun̈a noꞌ, yajaꞌ Comam Dios chiꞌakꞌni tzet chislo noꞌ. Hajexxam hex tiꞌ, to caw ecꞌbal heyelapno sata noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Aymi hunujex tiꞌ yu caw cheyaco yin̈ hecꞌul chihitzto nichꞌanoxa hecawil yul sat yiban̈kꞌinal tiꞌ? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yuxin ta mach chexkꞌoji hewatxꞌen tzet ye tuꞌ niẍchꞌan, ¿tzet yin̈ xin cheyaco yin̈ hecꞌul? ");
INSERT INTO jacNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilwecꞌanab teꞌ caj, mach chimunla teꞌ, mach chichemlipaxo teꞌ, yaj chiwalan teyet naj rey Salomón yet payat, waxan̈ca caw kꞌalom naj, yajaꞌ machi apni iskꞌaptzen isba naj hacaꞌ iscꞌulchꞌanil teꞌ caj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Walca caw cꞌulchꞌan jilni isxumaquil teꞌ caj tuꞌ tinan̈, yaj wal yet hecal cabe chin̈uslaxto teꞌ yul horno. Ta chakꞌ Comam iscꞌulchꞌanil teꞌ caj, ¿hatocꞌanab xil hekꞌab mach chakꞌ Comam? hex tiꞌ machi caw chicawxi hecꞌul yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wal xin mach cheyaco yin̈ hecꞌul bay chi-caw-istit tzet chelo. ");
INSERT INTO jacNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wal anma mach ohtan̈e Comam Dios, caw chaco huntekꞌan tzet ye tuꞌ tiꞌ yin̈ iscꞌul, yajaꞌ walex hex tiꞌ, ay huneꞌ Hemam yohtaxa tzet chꞌocnico heyu. ");
INSERT INTO jacNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yuxin aweco heyanma heyijen yin̈ tzet chal Comam Dios babel, haxa huntekꞌanxa chꞌocnico heyu, chiꞌakꞌlaxo teyet, ẍi Comam Jesús tet ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yalnipaxo Comam Jesús tet ebnaj iscuywom: —Mach chexxiw hex xahan ay wutiꞌan. Caw haywan̈exchꞌan, yajaꞌ xaꞌel yin̈ iscꞌul Comam ay bey satcan̈ quexyanico yuninaloj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Txon̈weto tzet ayex, cat heyakꞌni istohol tet anma matzet aya, hac tuꞌ chu hewatxꞌen huneꞌ istxꞌuyal hekꞌalomal mach chikꞌato bey satcan̈. Huntekꞌan kꞌalomal tuꞌ machi bakꞌinal chitan̈iloj yuto haꞌ bey tuꞌ machi elkꞌom, machipaxo noꞌ ih chiꞌetanotoj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wal xin haꞌ bay ay hekꞌalomal haꞌ tuꞌ ayco heyanma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yalnipaxo Comam: —Caw helanojab cheyute heba hacaꞌ hunu naj soldado caw watxꞌebilico xil iskꞌap, yeb aypaxico kꞌaꞌ yin̈ iscantil. ");
INSERT INTO jacNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Lahanojab cheyute heba hacaꞌ ebnaj chejab chismaj yul ispatrón chibey yin̈ hunu mohyilal. Hayet chꞌapni naj bey yatut cat yahwi naj. Caw yin̈ an̈e xin chishaj ebnaj pulta tet naj patrón tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Caw sakꞌal yet ebnaj chejab elna iswayan̈ yet chꞌapni ispatrón tuꞌ. Chiwalan teyet, caw yin̈ an̈e chishelilo xil iskꞌap naj patrón, cat yawten naj ebnaj waꞌo sat meẍa; haꞌ caw naj chibatxnicꞌo tzet chislo ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yuxin waxan̈ca yin̈ chuman akꞌbal, maca yet lan̈anxa issajbiloj, cat yapni naj patrón tuꞌ, caw sakꞌal yet ebnaj chejab ta elna iswayan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nachaojabilo heyu huntekꞌan tzet chiwaltiꞌan teyet: Hacaꞌ hunu naj yahaw n̈a, kꞌinalo ta yohta naj tzet orahil chꞌapni naj elkꞌom yin̈ yatut, caw chimmajwa naj, machim chischacto naj naj yul yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Haꞌ quexpax tuꞌ hex tiꞌ, helan cheyute heba. Haꞌ taxca yet mach nano heyu, cat wulan, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam tet ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iskꞌamben naj Pedro tet Comam: —Mamin, ¿han̈em jetan̈ chawal huneꞌ yechel tiꞌ, mato tet sunil anma? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yalni Comam: —Huneꞌ tiꞌ chiwalan yin̈ huneꞌ naj ilom munil caw yijem yeb caw ay isnabal, akꞌbilico yu naj yahaw munil yul yatut yu yakꞌni tzet chislo ebnaj munlawom hacaꞌ yalni naj yahaw tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Caw sakꞌal yet naj ta lan̈an isyijen naj hacaꞌ tzet halbilcano tet yet chꞌapni naj yahaw munil. ");
INSERT INTO jacNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yin̈ caw isyelal chiwalan teyet: Naj yahaw munil tuꞌ chaco naj naj yijem tuꞌ yahawo yin̈ sunil tzet aya. ");
INSERT INTO jacNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yaj ta chal naj ischuquil: “Wal yaꞌ wahawan, ¿bakꞌin tam chul yaꞌ?” ta ẍi naj, cat yoc naj ismakꞌni ebnaj chejab yeb ebix chejab, yeb xin han̈cꞌan̈e yin̈ waꞌo chaco yanma naj, yeb xin yin̈ tzet chucꞌ naj, cat yoccano naj ucꞌu teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Haxa yet istzꞌayical mach echmabilo yahaw naj yu caw tona nahul ay naj, cat yul lemna naj yahaw tuꞌ, hac tuꞌ xin caw chꞌakꞌlax ecꞌoyaꞌ yanma naj xol isyaꞌtajil cat yalaxto naj xol ebnaj mach yijemo chute isba. ");
INSERT INTO jacNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kꞌinalo ta ay hunu naj chejab yohta tzet choche yahaw, yajaꞌ mach chaco naj yin̈ iscꞌul iswatxꞌeni, yeb xin mach chisyijepaxo naj tzet chal naj yahaw tuꞌ, haꞌ huneꞌ naj chejab tuꞌ niman isyaꞌtajil chischah naj. ");
INSERT INTO jacNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Walpaxo naj chejab, mach yohtajo ta txꞌoj tzet chiswatxꞌe, haꞌ naj tuꞌ hanicꞌn̈echꞌan tzꞌum chꞌakꞌlax yijaꞌ. Haꞌ mac niman tzet akꞌbilcano tet, nimanpaxo chikꞌanlax tet, yebpaxo mac niman tzet akꞌbilico yul iskꞌab, ecꞌbalxa niman chu iskꞌanlaxayo tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yalnipaxo Comam Jesús: —Hanintiꞌan hulnajinan wakꞌacojan huneꞌ hacaꞌ kꞌaꞌ yul yiban̈kꞌinal tiꞌ. Ay walaꞌan ta chiah xaj huneꞌ kꞌaꞌ tuꞌ tinan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ay huneꞌ niman isyaꞌtajil chihul wiban̈an, haꞌ ton huneꞌ tuꞌ ayco yin̈ wanmahan, caw xin chꞌecꞌyaꞌ wanmahan masanto chijaꞌ isba huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ham heyalni ta yu wanicojan akꞌancꞌulal xol anma yuxin quinhulan? Machoj, to yu ispohlen isba. ");
INSERT INTO jacNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wal tinan̈ istzabloxaco huneꞌ tiꞌ xol anma. Kꞌinalo ta ay howan̈o yul hunu n̈a, oxwan̈ chꞌoc howal yin̈ cawan̈, haxa cawan̈ tuꞌ chꞌoc howal yin̈ oxwan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Naj mame, chꞌoc naj howal yin̈ iscꞌahol, naj cꞌahole chꞌoc howal yin̈ ismam, ix miꞌe chꞌoc ix howal yin̈ yunin, ix unine chꞌoc ix howal yin̈ ismiꞌ. Wal ixnam alibe chꞌoc ixnam howal yin̈ yalib, cat yocpaxo ix alibe howal yin̈ ixnam alibe tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yalni Comam Jesús tet anma: —Hayet cheyilni moyan bay chito tzꞌayic, caw an̈e chenaloj cat heyalni: “Chakꞌaꞌ n̈ab tinan̈,” quexchi. Caw xin chij isba tzet cheyala. ");
INSERT INTO jacNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hayet cheyaben istit jakꞌekꞌ yin̈ sur, cheyalpaxoj: “Caw chixobxonoj,” quexchi. Hac tuꞌ xin chu yijni isba. ");
INSERT INTO jacNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hex cheyal heba cꞌulal tiꞌ, caw helanex hetxumni yin̈ tzet chute isba txꞌo txꞌotxꞌ tiꞌ, yeb tzet ye tuꞌ cheyil satcan̈ yet chishelni isba tiempo, yaj mach chinacha heyu tzet yelapno ye huneꞌ tiempo bay ayexico tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yalnipaxo Comam: —¿Tzet yin̈ yuxin caw mach chewatxꞌelo hunu tzet ye tuꞌ texol hechuquil yin̈ caw istoholal? ");
INSERT INTO jacNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kꞌinalo ta ay hunu mac chachawten sata naj alcal, haꞌojab yet lan̈an isto naj yul beh, cat hakꞌanni nimancꞌulal tawin̈ tet naj yin̈ akꞌancꞌulal. Ta mach xin, yet chaẍapni sata naj alcal, chaẍalaxico yul iskꞌab naj mayor, cat cachyanicto naj yul teꞌ preso. ");
INSERT INTO jacNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chiwalan tawet mach chaẍelti yul preso tuꞌ tato mach tzꞌajano chawakꞌ hamulta, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Haꞌ yin̈ huneꞌ tiempohal tuꞌ ay huntekꞌan ebnaj apni halno tet Comam Jesús yin̈ tzet yu ispotxꞌlax huntekꞌan ebnaj ah Galilea yu ischejbanil naj Pilato. Ismalto ischiqꞌuil ebnaj xol ischiqꞌuil no nokꞌ lan̈an yakꞌlax xahanbalil tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yalni Comam Jesús tet ebnaj: —¿Ham heyalni ta ecꞌbal ismul ebnaj cam tuꞌ sata huntekꞌanxa ebnaj ay bey Galilea tuꞌ? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wal xin, chiwalan teyet, ta mach chebejcano hetxꞌojal, chexcam hacaꞌ ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hacaꞌpaxo ebnaj waxajlahon̈wan̈ cam bey Siloé yet yaycꞌay huneꞌ torre yiban̈ ebnaj, ¿tom caw ecꞌbal ismul ebnaj tuꞌ sata huntekꞌanxa anma bey con̈ob Jerusalén, heyalni? ");
INSERT INTO jacNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Machoj! Haquexpax tuꞌ hex tiꞌ, ta mach chexmeltzoco yul iskꞌab Comam Dios, chexcampaxoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yalni Comam Jesús hunxa yechel tiꞌ tet anma: —Ay huneꞌ naj, ay huneꞌ teꞌ higuera sat istxꞌotxꞌ. Isto naj yilno ta ay sat teꞌ, yajaꞌ haxa yet yapni naj yilno teꞌ, machi huno sat teꞌ ilcha yu naj. Isto naj yalno tet naj chitan̈en istxꞌotxꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yalni naj tet naj: “Oxebxa habil chilan wulicꞌojan wilnojan ta ay sat huneꞌ teꞌ higuera tiꞌ, yajaꞌ caw machi huno sat teꞌ chakꞌa. Wal tinan̈ xin, tzocꞌcan̈ teꞌ, naban̈e majbililo txꞌotxꞌ yu teꞌ,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Istakꞌwican̈ naj chitan̈en istxꞌotxꞌ naj tuꞌ: “Mamin, acano teꞌ huneꞌxa habil tiꞌ. Chintꞌocoꞌan txꞌotxꞌ yich teꞌ, cat wanicojan yabonohal teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta chiyakꞌa sat teꞌ, cꞌul chal tuꞌ, ta mach xin, cat hatzocꞌnican̈ teꞌ,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yin̈ huneꞌ tzꞌayical xewilal yet iscuywa Comam yul iscapilla ebnaj Israel, ");
INSERT INTO jacNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ayicto huneꞌ ix ix waxajlan̈ebxa habil yoc huneꞌ yabil yin̈ yu huneꞌ ischejab naj matzwalil, caw cꞌon̈anxa ye ix yu, maẍticꞌa xin chu istoholban̈en isba ix. ");
INSERT INTO jacNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hayet yilnito Comam Jesús ix, yawtenti Comam ix iscꞌatan̈, yalni Comam tet ix: —Hach tiꞌ miyay, macachcolchalo yul iskꞌab huneꞌ yabil tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lahwi tuꞌ xin yanayo Comam iskꞌab yiban̈ ix. Hac tuꞌ yu istoholban̈en isba ix. Yichico ix yalni cꞌulla tzotiꞌ yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yajaꞌ caw tit ishowal naj yahawil yin̈ capilla, yuto cawxican̈ huneꞌ ix tuꞌ yu Comam yin̈ istzꞌayical xewilal. Yalni naj tet anma: —Caw wajeb tzꞌayic chon̈munla yul semana, yuxin yulbal wajeb tzꞌayic tuꞌ hulan̈we heyakꞌaꞌ an̈te heba, yaj maẍtaj yin̈ istzꞌayical xewilal, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Istakꞌwican̈ Comam: —Hex cheyal heba cꞌulal tiꞌ, ta ay hunu hewacax maca to hunu hecheh xecan yin̈ istzꞌayical xewilal, ¿tom mach chepuhilo noꞌ, cat heto heyakꞌno ucꞌu haꞌ noꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wal huneꞌ ix ix tiꞌ, yichmam ix ye icham Abraham, waxajlan̈ebxa habil istzabloti ix yu huneꞌ yabil akꞌbilico yu ischejab naj matzwalil tiꞌ. ¿Tom xin yu istzꞌayical xewilal yuxin mach chu iscolcha ix yin̈ huneꞌ isyaꞌtajil ayco yin̈ tiꞌ, heyalni? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hayet yalni Comam hacaꞌ tuꞌ, sunil ebnaj ayco ishowal yin̈ Comam txꞌixwican̈ ebnaj yet yaben huneꞌ tuꞌ. Wal sunil anma xin, caw chitzala iscꞌul yilni sunil nimeta cꞌaybalcꞌule iswatxꞌe Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yalnipaxo Comam Jesús: —¿Tzet chu ischꞌib isbisil anma chꞌoc yul iskꞌab Comam Dios, heyalni? ¿Baytet yeb cꞌul inlahbanan? ");
INSERT INTO jacNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anma chaco isba yul iskꞌab Comam Dios, lahan yeb hunu nichꞌan yin̈atil teꞌ mostaza chistzꞌun hunu naj sat istxꞌotxꞌ. Chichꞌibcan̈ teꞌ, cat yoc teꞌ nime teꞌal, hac tuꞌ xin chu yapni noꞌ chꞌic iswatxꞌenoco yatut xol iskꞌab teꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yalnipaxo Comam: —Chiwalan huneꞌxa yechel tiꞌ teyet yin̈ tzet chu ischꞌib isbisil anma chaco isba yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lahan hacaꞌ nichꞌano yan̈al ixim pan chaco hunu ix ix xol oxeb mal ixim harina. Caw xin chisipcꞌacan̈ sunil ixim yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hayet isto Comam Jesús yul beh chiꞌapni bey Jerusalén, ay huntekꞌan con̈ob yeb huntekꞌan aldea bay ecꞌ Comam cuywal. ");
INSERT INTO jacNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ay xin huneꞌ naj kꞌamben tet Comam: —Mamin, ¿tom haywan̈chꞌann̈e mac chicolchahi? ẍi naj. Istakꞌwi Comam: ");
INSERT INTO jacNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Akꞌwe heyanma heyocto yul huneꞌ pulta nichꞌan chꞌan sat. Wal xin chiwalan teyet, caw txꞌiꞌal mac choche chiꞌoctoj, yaj mach chu yu. ");
INSERT INTO jacNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wal xin hanintiꞌan lahaninan hacaꞌ hunu yahaw n̈a. Yet akꞌbalil xin chinpebaltijan ispultahil teꞌ. Lahwi tuꞌ, hex chexcancano istin̈a chꞌelicto heyaw sat pulta, cheyalni: “Mamin, hajon̈icꞌtojan̈,” quexchi. Yaj chintakꞌwihan teyet: “Mach quexwohtajojan,” quinchiyan. ");
INSERT INTO jacNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yet ayex istin̈a tuꞌ, cheyalnictoj: “Caw huneꞌn̈e con̈waꞌi, con̈hacuynipaxojan̈ yulajla beh,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Cat xin intakꞌwipaxojan teyet: “Mawalan teyet ta mach quexwohtajojan. ¡Elan̈we incꞌatan̈an hex istxꞌojaln̈e chewatxꞌe!” quinchiyan teyet yin̈ huneꞌ tzꞌayical tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hac tuꞌ xin chu heyoc okꞌoj, cat isn̈etxꞌla heyeh yu isyaꞌtajil yet cheyilni icham Abraham yeb naj Isaac yeb naj Jacobo yeb sunil ebnaj ischejab Comam Dios ayco iscꞌatan̈ Comam. Walex hex tiꞌ, mach chexchahlaxictoj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wal xin chitit anma yulajla con̈ob yul sat yiban̈kꞌinal tiꞌ, cat iscutxico iscꞌatan̈ Comam Dios, cat iswaꞌ sat meẍa iscꞌatan̈ Comam Dios Yahawil. ");
INSERT INTO jacNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ay mac machi yelapno yul sat anma tinan̈, yaj caw ay yelapno ye yul sat Comam Dios, haꞌ caw cꞌul chꞌelcanico yet bakꞌin. Aypaxo anma, caw ay yelapno ye tinan̈ yul sat anma, yaj mach cꞌulu chꞌeloco yet bakꞌin, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Haꞌticꞌa yin̈ huneꞌ tzꞌayic tuꞌ, apni huntekꞌan ebnaj fariseo iscꞌatan̈ Comam Jesús, yalni ebnaj: —Mamin, elan̈ yul cocon̈obtiꞌan̈ yuto choche naj Herodes cachispotxꞌoꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Istakꞌwi Comam: —As halwe tet huneꞌ naj lekꞌtiꞌ tuꞌ hacaꞌ noꞌ wech ta huneꞌ tzꞌayic tiꞌ yebpaxo hecal chiwakꞌ cawxojan anma yaꞌay, yebpaxo xin chiwilojan ischejab naj matzwalil yin̈ anma, haꞌ to yet cabe chilahwi inmuniltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yuto yilal inlahnihan huneꞌ inbeltiꞌan tinan̈ yeb hecal, yet cabe xin chinapnihan bey Jerusalén, yuto sunil ischejab Comam Dios yilal iscam bey Jerusalén tuꞌ, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yalnipaxo Comam: —Hex ah Jerusalén hex tiꞌ, chepotxꞌ camo ebnaj ischejab Comam Dios, chekꞌojni camo ebnaj chejbilti texol yu Comam. Caw txꞌiꞌal el quexwawtecojan yul inkꞌaban, hacaꞌ chu yawtenico noꞌ miꞌe chiyo niẍte yunin yalan̈ xicꞌ, yajaꞌ machi heje. ");
INSERT INTO jacNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wal tinan̈ chiwalcanojan teyet, huneꞌ bay ayex tiꞌ chibejlaxcanoj. Chiwalnipaxcanojan teyet tato matxa chinheyilan masanto chꞌapni yorahil bay cheyalaꞌ: “Jalawe tzotiꞌ cꞌul yin̈ Mac chul coxol yin̈ isbi Comam Dios,” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Haꞌ yin̈ huneꞌ tzꞌayical xewilal, to Comam Jesús waꞌo bey yatut huneꞌ naj iswiꞌehal yin̈ ebnaj fariseo. Aypaxicꞌo xin huntekꞌanxa ebnaj yet fariseohal naj tuꞌ, yaben tzet chu yaycꞌay Comam yin̈ huno tzotiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yapni huneꞌ naj sata Comam, chimal yoj yeb isnimanil. ");
INSERT INTO jacNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iskꞌamben Comam tet ebnaj cuywawom yin̈ isley naj Moisés, yeb tet ebnaj fariseo: —¿Chimisje jan̈ten hunu anma yaꞌay yin̈ istzꞌayical xewilal, mato mach chuhi? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yajaꞌ maẍticꞌa takꞌwi ebnaj. Yoc tzabno Comam yin̈ iskꞌab naj yaꞌay tuꞌ, iscawxican̈ naj xin. Lahwi tuꞌ ischejlaxtopaxo naj yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yalni Comam tet ebnaj: —Kꞌinalo ta chitohcꞌay hunu heyuninal maca hunu hewacax yul hunu cꞌuh, ¿tom mach cheyihti yin̈ an̈e, walca istzꞌayical xewilal? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yaj xin maẍticꞌa yu istakꞌwi ebnaj yin̈ tzet yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hayet yilni Comam Jesús anma awtebil tuꞌ issaynilo anma huntekꞌan tzꞌon̈obal ayco yin̈ meẍa caw ay yelapno yehi, yalni Comam huneꞌ cuybanil tiꞌ tet anma: ");
INSERT INTO jacNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Hayet chexawtelax yin̈ hunu mohyilal, mach chexay tzꞌon̈no yul chꞌem caw ay yelapno yehi. Yuto ta chꞌapni hunu naj ecꞌbal yelapno ye tesataj, ");
INSERT INTO jacNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","cat yapni naj awten̈e hex tuꞌ, cat yalni naj teyet: “Acano huneꞌ tzꞌon̈obal tet naj tiꞌ,” ta ẍi naj, cat heto yin̈ txꞌixwilal bey huneꞌ comon chꞌem. ");
INSERT INTO jacNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wal xin hayet chexawtelaxi, saywe huntekꞌan comon tzꞌon̈obal bay chextzꞌon̈i, haxinwal yet chꞌapni naj quexawten tuꞌ, cat yalni naj teyet: “Hex wamigo ecꞌanweti yul tzꞌon̈obal bay caw ay yelapno ye tilah,” ẍi naj. Haxinwal chꞌoc hewinajil sata ebnaj ayco tecꞌatan̈ sat meẍa tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yuto haꞌ mac chiyican̈ isba, chiꞌilaxayoj, wal mac chiyiyo isba, chiꞌilaxcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yalnipaxo Comam tet naj awten tuꞌ: —Hayet chawawten anma waꞌo tacꞌatan̈, mach han̈cꞌan̈eho hawamigo chawawte yeb hawuẍtaj yeb hawicꞌal yeb anma kꞌalom ay hacawilal, yuto haꞌ ebnaj tuꞌ, chakꞌ ebnaj selel tawet yet chaẍyawtenpaxo ebnaj waꞌo iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wal xin ta ay hunu hakꞌin̈ chawecꞌtze, cat hawawten anma waꞌoj, awte anma mebaꞌ, anma mach tzꞌajano ye isnimanil, anma mach chu yeqꞌui, yebpaxo anma mach chu yilni. ");
INSERT INTO jacNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta hac tuꞌ chawute, sakꞌal hawet chal tuꞌ, yuto chachah ispaj selel yin̈ huneꞌ tzꞌayical bay chiitzitzbican̈ anma ayxaco yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hayet yabelax huneꞌ tuꞌ yu anma ayco sat meẍa tuꞌ, yalni huneꞌ naj tet Comam: —¡Sakꞌal yet anma chiwaꞌ iscꞌatan̈ Comam Dios yet huneꞌ tzꞌayical tuꞌ! ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yuxin yal Comam Jesús hacaꞌ tiꞌ: —Yet hunel ay huneꞌ naj winaj ecꞌtzen huneꞌ niman kꞌin̈. Caw xin txꞌiꞌal anma yawte naj waꞌo iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hayet lan̈anxa yapni yorahil yoc wah tuꞌ, ischejnito naj iscꞌamteꞌ yalno tet ebnaj awtebil tuꞌ hacaꞌ tiꞌ: “Ton̈wej yuto cꞌulxa ye tzet chelo,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hayet yaben ebnaj tzet yal naj cꞌamteꞌ tuꞌ, yalni naj babel: “Lan̈anto inlokꞌnihan huneꞌ intxꞌotxꞌan, haꞌ txꞌotxꞌ chintohan wilaꞌan tinan̈, yuxinto akꞌ nimancꞌulal win̈an, mach chu wapnojan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Haꞌ hunxa naj xin halni hacaꞌ tiꞌ: “Lan̈anto inlokꞌnihan lahon̈cꞌon̈ inwacaxan yet munil, yuxin haꞌ noꞌ chinto wilwehan ismunla tinan̈. Caw akꞌ nimancꞌulal win̈an, mach chu intohan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yalnipaxo hunxa naj: “Caw tolto quinmohyihan, caw mach chu intohan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hayet ismeltzo naj cꞌamteꞌ tuꞌ, yalni naj sunil tzet yal ebnaj awtebil tuꞌ tet naj yahaw tuꞌ. Caw xin tit ishowal naj, yalni naj tet iscꞌamteꞌ hunelxa: “Wal tinan̈, asiꞌ yulaj nime beh, yeb yulaj niẍte beh, cat hawiniti sunil anma mebaꞌ, anma caw yan̈yon̈e, anma mach chu yilni yeb xin anma txꞌoj ye yoj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hunepixto xin ismeltzo naj cꞌamteꞌ tuꞌ, yalni naj: “Mamin, manyijehan inbeycꞌojan wawteꞌan anma maxawal wetan, yaj caw aytopaxo hamanil lah,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yalnipaxo naj yahaw tuꞌ: “Asiꞌpaxo yulaj niẍte beh yebpaxo yulaj nimeta beh, cat hachejniti anma bey watuttiꞌan, haxinwal nohnaxa yul watuttiꞌan, cat istzabloco huneꞌ kꞌin̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yuxinto chiwalan teyet: Sunil ebnaj awtebil babel tuꞌ, machi hunu ebnaj chiwaꞌo sat inmeẍatiꞌan,” ẍi naj yahaw tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Caw hantan̈e anma oc tzujno yinta Comam Jesús. Hayet hunel tuꞌ, ismeltzo isba Comam, yalni tet anma: ");
INSERT INTO jacNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ta ay mac choche chiꞌoc inchejabojan yaj ta ecꞌbal chaco yanma yin̈ ismam yeb ismiꞌ insatajan, maca yin̈ yixal, yuninal, yuẍtaj, yanab maca chisyaꞌiln̈e isba insatajan, ta hac tuꞌ mach chu yoc inchejabojan. ");
INSERT INTO jacNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Haꞌ mac hinan yaben isyaꞌtajil walca chꞌakꞌlax camo yin̈ culus, haꞌ chu yoc inchejabojan. ");
INSERT INTO jacNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kꞌinaloj ta ay hunujex cheyoche heyakꞌacan̈ hunu heyatut caw nimajal chu, ¿tom mach babelo chexoc tzꞌon̈noj, cat hetxumni hanta checꞌay yin̈, yu heyilni ta chexkꞌoji, mato machoj? ");
INSERT INTO jacNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yajaꞌ ta ton̈e niman cheyayo xeꞌ matxa chexkꞌoji helahni teꞌ, chꞌoc anma tzebo teyin̈ yet chilni huneꞌ tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","cat yalni: “Huneꞌ naj tiꞌ, ton̈e yicheco naj huneꞌ yatut tiꞌ, yaj machi makꞌoji naj islahni,” ẍim anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Macato ta ay hunu naj rey lan̈an isto akꞌo howal yin̈ hunxa naj rey, yajaꞌ lahon̈ebn̈e mil issoldado naj. ¿Mataxca mach babelo chꞌoc tzꞌon̈no naj, cat yilni naj ta chu iskꞌoji naj yin̈ hunxa naj rey ay huncꞌal mil issoldado? ");
INSERT INTO jacNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yajaꞌ ta chistxum naj ta mach chikꞌoji naj chabe, yet nahatto ayto hunxa naj rey tuꞌ, cat yanito naj ischejab iskꞌanno tzet chu yoc yin̈ akꞌancꞌulal yeb naj. ");
INSERT INTO jacNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yuxin, haquexpax tuꞌ hex tiꞌ, ta cheyoche oco tzujnu wintajan, caw yilal quinheyanicojan babel sata sunil tzet ayex, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hac tuꞌ xin, caw cꞌul atzꞌam atzꞌam yocnico ju, yajaꞌ ta chicꞌayto iscꞌachiꞌal atzꞌam, ¿tzet chu yoc iscꞌachiꞌal hunelxa? ");
INSERT INTO jacNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Matxa tzet chꞌocnico atzꞌam tuꞌ, nitam cosomnito xol txꞌo txꞌotxꞌ, maca xol kꞌalem yu yoc abonohal. Wal xin toxan̈e chitirlaxtoj. Txumwelo tzet chalilo huneꞌ chiwaltiꞌan, ẍi Comam tet anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Haꞌ ebnaj chiinilo chꞌen tohlabal chito bey Roma, yeb ebnaj mach cꞌulo tzet chiswatxꞌe, haꞌ ebnaj hitzico yaben tzet chal Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yu huneꞌ tuꞌ xin oc ebnaj fariseo yeb ebnaj cuywawom yin̈ isley naj Moisés buchwal yin̈ Comam, yalni ebnaj: —Wal naj Jesús tiꞌ, caw chischah naj ebnaj mulum, cat iswaꞌpaxo naj yeb ebnaj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yuxin yal Comam huneꞌ yechel tiꞌ tet ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Kꞌinaloj ta ay hunu naj ay cien ismeꞌ, yajaꞌ ta chicꞌayico hunu noꞌ, ¿mataxca mach chacano naj noꞌ noventa y nueve bay chilowi, cat isto naj issayno noꞌ cꞌaynato tuꞌ masanto chiꞌilcha noꞌ yu naj? ");
INSERT INTO jacNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hayet chiꞌilcha noꞌ yu naj, caw chitzalacan̈ iscꞌul naj, cat yanahto naj noꞌ yiban̈ iswixicꞌ, cat istit naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Haxa yet chꞌapni naj yatut, cat iscutxbanico naj yamigo yeb anma ayayo iscawilal naj, cat yalni naj: “Tzalahan̈we wintajan yuto maꞌilcha huneꞌ inmeꞌan cꞌaynatoj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yuxin chiwalpaxojan teyet, hayet chꞌoc huneꞌ anma mulum yul iskꞌab Comam Dios, ay tzalahilal yul satcan̈ satapaxo yin̈ noventa y nueve anma chisna ta machi ismul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yalnipaxo Comam Jesús: —Kꞌinaloj ta ay hunu ix ix ay lahon̈eb ismelyu, yajaꞌ ta chiscꞌayto ix hunu chꞌen, ¿mataxca mach chistzujba ix kꞌaꞌ yin̈ iscantil, cat istzꞌisni ix yul yatut, cat issayni ix yin̈ nan̈cꞌulal masanto chiꞌilcha chꞌen yu ix? ");
INSERT INTO jacNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Lahwi yilcha chꞌen yu ix xin, cat iscutxbanayo ix iswalix yeb anma ayayo iscawilal, cat yalni ix: “Tzalahan̈we wintajan, yuto maꞌilcha inmelyuhan cꞌaynatoj,” ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yuxin chiwalan teyet, hac tuꞌ yul satcan̈, caw ay tzalahilal xol ebnaj yángel Comam Dios yu huneꞌ naj mulum chisna isba cat yoc yul iskab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yalnipaxo Comam Jesús: —Ay huneꞌ naj mame cawan̈ iscꞌahol. ");
INSERT INTO jacNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yajaꞌ naj tzujan winaj tuꞌ yal naj tet ismam: “Mam, akꞌcano inmajulan tinan̈,” ẍi naj. Yuxin ispohto naj mame tuꞌ tzet ay yin̈ ebnaj iscawan̈il. ");
INSERT INTO jacNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hayebixto tzꞌayic xin iscutxbanayo naj istohol ismajul akꞌlax tet, isto naj bey huneꞌ con̈ob nahat, yoc naj iscꞌaytzenolo ismelyu yin̈ istxꞌojal. ");
INSERT INTO jacNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hayet xaistan̈tzelo naj sunil ismelyu tuꞌ, yichico huneꞌ niman wahilal bey huneꞌ con̈ob tuꞌ. Niẍtejal xin yoc naj yijlen wahil yu man̈tzetal. ");
INSERT INTO jacNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yuxin to naj iskꞌanaꞌ yet munil tet huneꞌ naj ay yul con̈ob tuꞌ. Ischejlaxto naj tan̈e txitam sat istxꞌotxꞌ naj yahaw noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yu n̈ohchahilal xin yoche naj islob sat teꞌ txꞌalib chiꞌakꞌlax islob noꞌ txitam, yuto machi mac chꞌakꞌni tzet chislo naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lahwi tuꞌ xin, istit yin̈ isnabal naj, yalni naj ischuquil: “Sunil iscꞌamteꞌ inmaman caw ay tzet chislo, wal inpaxojan xin, lan̈an incaman yu wahil bey tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wal tinan̈ meltzohoj intohan bey yatut inmamtuꞌan, cat walnihan tet yaꞌ: ‘Mam, caw mawaco inmulan yul sat Comam Dios yebpaxo yul hasat. ");
INSERT INTO jacNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Matxa chu wocan hacꞌaholoj, to hacꞌamteꞌxa chiwucojan,’ quinchin̈eticꞌahan,” ẍi naj ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lahwi tuꞌ xin, ispaxto naj bey yatut ismam. Ayto yapni naj xin, yillaxto naj yu ismam; caw tzꞌaycan̈ iscꞌul ismam naj yilni. Isto lemna naj mame tuꞌ ischahno naj. Yoc lakꞌno naj yin̈ iscꞌahol tuꞌ, istzꞌohnipaxo naj iskꞌotx naj yu tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yalni naj tet ismam: “Mam, caw mawaco inmulan yul sat Comam Dios, yebpaxo tawet. Matxa chu wocan hacꞌaholoj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yalni naj mame tuꞌ tet ebnaj ischejab: “As iwelti yin̈ an̈e hunu xilkꞌape caw cꞌul, cat yoc yin̈ incꞌaholtiꞌan, cat heyanico isjolkꞌab naj yeb isxan̈ab naj, ");
INSERT INTO jacNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","cat hetopaxo heyinoti hunu noꞌ wacax caw bakꞌich, cat hepotxꞌni camo noꞌ, yuto chijecꞌtze hunu kꞌin̈, cat cowaꞌwej. ");
INSERT INTO jacNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yuto haꞌ huneꞌ incꞌaholtiꞌan hacaꞌtan̈e camnaxa, yajaꞌ hacaꞌtan̈e mahulcan̈ iscꞌul naj. Hacaꞌ ta cꞌaynaxato naj, yaj tinan̈ maꞌilcha naj,” ẍi naj mame tuꞌ. Lahwi tuꞌ xin yecꞌtzelax huneꞌ kꞌin̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yet ayco ebnaj yin̈ huneꞌ kꞌin̈ tuꞌ, yul naj babel cꞌahole yin̈ ismunil. Yajaꞌ ayto yapni naj bey yatut yaben naj huneꞌ kꞌin̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yawten naj huneꞌ ischejab ismam, iskꞌamben naj: “¿Tzet yin̈ yuxin ayco huneꞌ kꞌin̈ tuꞌ?” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yalni naj chejab tuꞌ tet naj: “To hawuẍta mahuli, yuxin mayal hamam ta chipotxꞌlax camo hunu noꞌ wacax caw bakꞌich yuto cawn̈e mayu yul naj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yajaꞌ caw tit ishowal naj, yuxin mach isjecto naj yul yatut ismam. Haxa yet yaben naj mame tuꞌ, yelti naj, yay sat naj tet iscꞌahol tuꞌ ta chꞌocto naj yul n̈a. ");
INSERT INTO jacNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yalni naj tet ismam tuꞌ: “Mam, caw hawohtaj hantaxa tiempo wichicojan inmunlahan tawintaj. Machi hunelo chinman̈cꞌohan tzet chawala, yaj nitam hunu noꞌ nichꞌan chiw chawakꞌ wetan cat wecꞌtzenan hunu kꞌin̈ yeb ej wamigohan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“¿Tom yu mahul huneꞌ hacꞌahol tiꞌ yuxin maxapotxꞌ camo noꞌ wacax caw bakꞌich? Naj ton̈e etanto hamelyu yin̈ ebix ix txꞌoj ye iswiꞌ,” ẍi naj tet ismam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Istakꞌwi naj mame tuꞌ: “Cꞌahol, hach tiꞌ, ayachticꞌaco incꞌatan̈an sunilbal tiempo, yeb sunil tzet ayinan hawetpaxo yehi. ");
INSERT INTO jacNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yajaꞌ tinan̈ caw yilal yoc huneꞌ kꞌin̈ tiꞌ cat jakꞌni tzala cocꞌul, yuto huneꞌ hawuẍta tiꞌ hacaꞌtan̈e camnaxa, yaj mahulcan̈ iscꞌul hunelxa. Hacaꞌ ta cꞌaynaxato naj, yaj tinan̈ xin maꞌilcha naj,” ẍi naj mame tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yalnipaxo Comam Jesús huneꞌxa yechel tiꞌ tet ebnaj iscuywom: —Ay huneꞌ naj kꞌalom, ay xin huneꞌ naj ayco yahawo ismunil naj. Yajaꞌ yabelo naj patrón tuꞌ ta lan̈an iscꞌaynilo naj ilom munil tuꞌ tzet ay naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yuxinto yawte naj patrón naj ilom munil tuꞌ, yalni naj tet naj: “Mahul hallaxo wetan tato ach tiꞌ lan̈an hacꞌaynilo tzet ayinan. Wal tinan̈ xin, caw yilal tzꞌajan chawakꞌcano sunil tzet ayco yul hakꞌab wuhan, yuto chaẍwilojan yin̈ inmuniltiꞌan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yalni naj ilom munil tuꞌ yin̈ isnabal: “¿Tzet chiwute inbahan, yuto chiyikꞌalo inpatronan inmuniltiꞌan? Yaj matxa kꞌaynajo innimaniltiꞌan yin̈ munil caw yaꞌtaj. Chintxꞌixwipaxojan wecꞌan kꞌano tzet ye tuꞌ matanil tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wal tinan̈ wohtaxahan tzet chiwute inbahan, waxan̈ca machi inmunilan ay mac chinchahnihan bey yatut,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Lahwi tuꞌ xin, yichico naj yawten ebnaj ay iscꞌas tet ispatrón tuꞌ yin̈ hununtajil. Iskꞌamben naj tet naj babel: “¿Hanta hacꞌas tet inpatronan?” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yalni naj xin: “Huneꞌ cien barril teꞌ aceite incꞌasan,” ẍi naj. Yalni naj ilom munil tuꞌ: “Tinan̈ xin, ay yumal hacꞌas lah. Ayan̈ tzꞌon̈noj, cincuenta xan̈e chawuteco hacꞌas yin̈ huneꞌ hum tiꞌ yin̈ an̈e,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lahwi tuꞌ xin, iskꞌamben naj tet hunxa naj: “¿Hanta hacꞌas tet inpatronan?” ẍi naj. Istakꞌwi naj: “Huneꞌ cien mal ixim trigo,” ẍi naj. Yalni naj ilom munil tuꞌ: “Ay yumal hacꞌas lah, ochenta xan̈e chawuteco hacꞌas yin̈ teꞌ,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cꞌayilo iscꞌul naj patrón tuꞌ yin̈ naj ilom munil tuꞌ, waxan̈ca txꞌoj isnabal naj, yaj caw helan naj iscolni isba. Yuxin chiwalan teyet, caw biscꞌulal, yuto haꞌ anma mach ohtan̈e Comam Dios, caw helan iswatxꞌen istxꞌojal. Wal ebnaj yet Comam yehi, caw mach helano ebnaj iswatxꞌen tzet choche Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chiwalan teyet, haꞌ chꞌen melyu chu iswatxꞌen chꞌen istxꞌojal; walex hex tiꞌ xin, yin̈n̈eojab iscꞌulal cheyaco hemelyu, haxinwal ay mac chaco isba yul iskꞌab Comam Dios. Ta hac tuꞌ, hayet matxa tzet chꞌocnico chꞌen melyu heyu, Comam Dios chexchahni bey huneꞌ heyatut satcan̈ yin̈ huneln̈e. ");
INSERT INTO jacNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Haꞌ mac cꞌul chute isba yin̈ nichꞌan chꞌakꞌlax yul iskꞌab, caw cꞌulpaxo chute isba yin̈ niman chꞌakꞌlax tet. Hac tuꞌ xin, haꞌ mac machiswalil chute isba yin̈ nichꞌan chꞌakꞌlax tet, caw machiswalil chutepaxo isba yin̈ niman chꞌakꞌlax yul iskꞌab. ");
INSERT INTO jacNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yuxin ta mach cꞌulo cheyute heba yin̈ hekꞌalomal yul sat yiban̈kꞌinal tiꞌ, ¿haꞌ tom xin huneꞌ iskꞌalomal satcan̈ chiꞌakꞌlax teyet? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hac tuꞌ xin ta mach cꞌulo cheyute heba yin̈ tzet ye tuꞌ mach heyeto yehi, ¿hato cꞌanab huneꞌ heyetticꞌa yehi chiakꞌlax teyet? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Machi hunu naj munlawom chu ismunla yinta cawan̈ patrón, yuto ta choche naj naj babel, chisyah naj naj iscab. Yebpaxo ta yijem chute isba naj tet naj babel, chisman̈cꞌo naj tzet chal naj iscab. Hac tuꞌ xin mach chu coyijen tzet chal Comam Dios ta ayco janma yin̈ kꞌalomal, ẍi Comam Jesús tet ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Haxa yet yaben ebnaj fariseo tzet yal Comam Jesús, yoc ebnaj buchwal yin̈ Comam, yuto caw ayco yanma ebnaj yin̈ ismelyu. ");
INSERT INTO jacNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yalni Comam tet ebnaj: —Hex tiꞌ, satan̈e anma caw cꞌul cheyute heba, yaj Comam Dios yohta tzet ayayto yul heyanma. Haꞌ tzet ye tuꞌ caw niman yelapno ye yul sat anma, machi yelapno yul sat Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yalnipaxo Comam Jesús: —Yalan̈to maẍto chul naj Juan anican̈ haꞌ iswiꞌ anma, cuylax isley naj Moisés yeb tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat. Yin̈xa istiempohal naj Juan tuꞌ xin, ichico ispujbalaxicꞌo tzotiꞌ cꞌul yin̈ tzet chu yoc anma yul iskꞌab Comam Dios, haꞌ anma tuꞌ chakꞌ yip yanma yoc yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Huneꞌ satcan̈ tiꞌ yeb txꞌo txꞌotxꞌ chitan̈iloj, wal isley Comam Dios, machi hunu cuybanil chꞌecꞌto yet yijni isba sunil, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yalnipaxo Comam Jesús: —Ta ay hunu naj winaj chispole isba yeb yixal, cat ismohyi yeb hunuxa ix, chaco naj ismul yul sat Comam Dios. Yebpaxo naj chiꞌikꞌni ix pohlebil isba yeb yichamil tuꞌ, chapaxico ismul naj yul sat Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yalnipaxo Comam Jesús huneꞌxa cuybanile hacaꞌ tiꞌ: —Yet hunel ay huneꞌ naj winaj caw kꞌalom, han̈cꞌan̈e kꞌap xilkꞌape caw cꞌul, caw ay istohol chaco naj yin̈. Checꞌtzen naj nimeta kꞌin̈ yul yatut hunun tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Aypaxo huneꞌ naj caw mebaꞌ, Lázaro isbi; chiay tzꞌon̈no istiꞌ ispultahil yatut naj kꞌalom tuꞌ, caw choche naj yakꞌaꞌ noho iscꞌul yu iskꞌal istiꞌ naj kꞌalom chiꞌaycꞌayti sat meẍa. Caw xin yaꞌay naj yu txꞌac, chꞌapni xin metx txꞌiꞌ islekꞌaꞌ istxꞌac naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yaj hul huneꞌ tzꞌayic bay cam naj Lázaro tuꞌ, yilaxto yanma naj yu ebnaj yángel Comam Dios bey huneꞌ ehobal chꞌij paraíso iscꞌatan̈ icham Abraham. Iscampaxo naj kꞌalom tuꞌ, ismujlax naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Haxa yet ayxa naj kꞌalom yul cambal, lan̈an xin yecꞌyaꞌ yanma naj bey tuꞌ, istꞌan̈xito naj yilnito naj naj Lázaro iscꞌatan̈ icham Abraham. ");
INSERT INTO jacNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yah yaw naj kꞌalom tuꞌ, yalni naj hacaꞌ tiꞌ: “Mam Abraham, tzꞌayojab hacꞌul win̈an. Chejti naj Lázaro incꞌatan̈an inkꞌanaꞌan, islabaꞌab naj iswiꞌ yiximal iskꞌab xol ha haꞌ, cat yul yakꞌno chewbo naj wakꞌan, yuto caw chꞌecꞌyaꞌ wanmahan xol huneꞌ kꞌa kꞌaꞌ tiꞌ,” ẍi naj kꞌalom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Istakꞌwi icham Abraham tuꞌ: “Hach wet anmahil tijab yul hacꞌul yet ayach yul sat yiban̈kꞌinal, caw cꞌulchꞌann̈e ecꞌ hawilaꞌ, wal naj Lázaro tiꞌ, caw isyaꞌtajiln̈e bey naj yilaꞌ. Yajaꞌ tinan̈, lan̈an yakꞌni tzalaho iscꞌul naj, walach xin, lan̈an hawaben isyaꞌtajil. ");
INSERT INTO jacNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yebpaxoj, ay huneꞌ niman xab coxol, walca ta ay mac choche chꞌecꞌto bay ayex tuꞌ, mach chuhi, yebpaxo ta ay mac bay ayex tuꞌ choche chꞌecꞌti bey tiꞌ, mach chupaxoj,” ẍi icham Abraham tuꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yalnipaxo naj kꞌalom tuꞌ: “Ta hac tuꞌ xin, Mam Abraham, caw chinkꞌanan tawet ta chachejto naj Lázaro tuꞌ bey yatut inmaman, ");
INSERT INTO jacNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","cat yalni naj yabeꞌ howan̈ wuẍtajan ay bey tuꞌ, haxinwal mach chul ebnaj yetaꞌ yanma bay ay intiꞌan,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Yalnipaxo icham Abraham tuꞌ: “Wal ebnaj hawuẍta tuꞌ, ayco tzet tzꞌibn̈ebil yu naj Moisés yeb tzet tzꞌibn̈ebil yu ebnaj ischejab Comam Dios tet ebnaj. ¡Isyijeojab ebnaj tzet chala!” ẍi icham. ");
INSERT INTO jacNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Istakꞌwican̈ naj kꞌalom tuꞌ: “Hoꞌ, yeli Mam Abraham, yajaꞌ ta ay hunu naj camnaxa chiitzitzibican̈, cat isto yalno tet ebnaj wuẍtatuꞌan chimisbejaꞌcano ebnaj istxꞌojal,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yalnipaxo icham Abraham: “Tato mach choche ebnaj yabe tzet yalcano naj Moisés yeb tzet halbilcano yu ebnaj ischejab Comam Dios, waxan̈ca ay hunu naj camnaxa chiitzitzbican̈ xol camom, cat isto yalno tet ebnaj, maẍticꞌam chahpaxico ebnaj yin̈ iscꞌul,” ẍi icham Abraham tet naj, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yalni Comam Jesús tet ebnaj iscuywom: —Ayn̈eticꞌa istxꞌojal bay chꞌaycꞌay anma yul sat yiban̈kꞌinal tiꞌ, ¡yajaꞌ cꞌanchꞌan mac chꞌakꞌni aycꞌayo hunu maca! ");
INSERT INTO jacNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Haꞌ huneꞌ mac tuꞌ, cꞌulojab iscꞌallaxico hunu niman chꞌen yin̈ isnukꞌ, cat istirlaxto xol haꞌ mar sata ta chakꞌ aycꞌayo yin̈ istxꞌojal hunu mac uninto win̈an, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yalnipaxo Comam: —¡Nann̈eojab heyu hex tiꞌ! Ta ay hunu heyuẍta maca hunu heyanab chaco ismul teyet, cachwan̈we yin̈. Yaj ta chishel isbeybal, akꞌwe nimancꞌulal yin̈, ");
INSERT INTO jacNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","waxan̈ca hujel chaco ismul teyet yin̈ huneꞌ tzꞌayic, yaj ta hujel chꞌapni iskꞌanaꞌ nimancꞌulal teyet, yilal heyakꞌni nimancꞌulal yin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iskꞌanni ebnaj ischejab Comam Jesús tet hacaꞌ tiꞌ: —Akꞌ yip janmahan̈ yin̈ Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Istakꞌwi Comam tet ebnaj: —Ta caw cheyaco heyanma yin̈ Comam Dios, waxan̈ca chiichico hacaꞌ hunu teꞌ nichꞌan hin̈at mostaza, wal tuꞌ chu heyalni tet hunu teꞌ kꞌebtaj morera hacaꞌ tiꞌ: “Hocꞌati haba bey tiꞌ, cat hato hatzꞌunnayto haba xol haꞌ mar,” ta quexchi, chisyije teꞌ tzet cheyala, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yalni Comam: —Ta ay hunu hemunlawom ispeto tꞌoco txꞌotxꞌ, maca ilo wacax, mataxca cheyal tet naj: “Ocan̈, ayan̈ tzꞌonoj cat hawaꞌi,” ¿Tom quexchi xin? ");
INSERT INTO jacNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Machoj! To haꞌ cheyal tet naj: “Watxꞌe tzet chinlohan, chilahwi tuꞌ, cat hawoc habatxꞌnicꞌo tzet chiwochehan, chilahwo inwaꞌcanojan xin, cat hawaꞌo hach tiꞌ,” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Tom xin cheyakꞌ yuchꞌandiosal tet naj yu chisyijen naj tzet cheyala? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hacaꞌ huneꞌ naj munlawom tuꞌ, haquex tuꞌ hex tiꞌ. Lahwi hewatxꞌen sunil baytet chejbil hewatxꞌe yu Comam Dios, cat heyalni hacaꞌ tiꞌ: “Wal xin caw ismunlawom Comam Dios jecanojan̈ yuxin caw yilal coyijenan̈ tzet chal Comam Dios,” quexchiojabi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yet lan̈an isto Comam Jesús yul isbelal Jerusalén, yecꞌto Comam xolbal ismajul Samaria yeb ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hayet yapni Comam bey huneꞌ aldea, yelilo lahon̈wan̈ ebnaj winaj ischahno Comam. Ayco yabil lepra yin̈ ebnaj, yuxin nahat cancano lin̈no ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Istzabnico ebnaj yahwi tet Comam: —Mam Jesús, Mam cuywawom, caw tzꞌayojab hacꞌul jin̈an̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hayet yilni Comam Jesús ebnaj, yalni Comam tet ebnaj: —As yewe heba sata ebnaj sacerdote Israel, ẍi Comam tet ebnaj. Hayet lan̈an isbelwi ebnaj tuꞌ, yelcano huneꞌ yabil tuꞌ yin̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Huneꞌ naj xol ebnaj tuꞌ, hayet yilni naj ta caw cꞌulxa ye isnimanil, ismeltzoti naj yin̈ caw tzalahilal yalni cꞌulla tzotiꞌ yin̈ Comam Dios yin̈ caw ip. ");
INSERT INTO jacNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hayet yapni naj iscꞌatan̈ Comam Jesús, yay jahno naj sata Comam yu yakꞌni naj yuchꞌandiosal tet Comam. Huneꞌ naj tuꞌ, ah Samaria naj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Lahwi tuꞌ, yalni Comam Jesús: —Yaj lahon̈wan̈ ebnaj mael huneꞌ yabil tiꞌ yin̈, ¿baytuꞌwal ayco balon̈wan̈xa ebnaj? ");
INSERT INTO jacNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tom han̈cꞌan̈e huneꞌ naj nan con̈obal tiꞌ mahul akꞌno yuchꞌandios tet Comam Dios? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yalni Comam tet naj: —Ahan̈lin̈noj, cat hapaxtoj. Yu maxawaco hawanma yin̈ Comam Dios, yuxin macachan̈chahi, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ay huntekꞌan ebnaj fariseo kꞌamben tet Comam Jesús bakꞌin chihul istiempohal yet chꞌoc Comam Dios Jahawiloj. Istakꞌwi Comam: —Hayet chꞌoc Comam Dios heyahawiloj, mach chu jilni yu cosat. ");
INSERT INTO jacNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yuxin machi mac chu yalni: “Haꞌ bey tiꞌ aya,” maca to “Haꞌ bey tuꞌ aya,” mach ẍioj. Yuto haxa yul yanma anma chꞌoc Comam Dios Yahawoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lahwi tuꞌ xin, yalni Comam tet ebnaj iscuywom: —Chiꞌayilo huneꞌ tiempohal bay cheyala: Ayxicꞌa chul Comam Akꞌbilti coxol yu Comam Dios hunelxa, waxan̈ca huneꞌn̈e tzꞌayic quexchi, yaj maẍticꞌa chinheyilaꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yuxin, waxan̈ca ay anma chihalni teyet: “Ay Comam bey tiꞌ lah,” maca to aypaxo anma chihalni: “Haꞌ tuꞌ ay Comam bey tuꞌ lah,” waxan̈ca ẍi, caw mach chexoc tzujnu yinta ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yuxin chiwalcanojan teyet, hacaꞌ chu yah jepla cꞌuh yin̈ sunil satcan̈, hac tuꞌ chu wulan, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yajaꞌ yin̈ babel caw chiakꞌlax ecꞌoyaꞌ wanmahan yu anma cat quinyintan̈encaniltojan yin̈ huneꞌ tiempohal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hacaꞌ yu anma yin̈ istiempohal naj Noé, hac tuꞌ chiyupaxo anma yet chinhulan yin̈ iscayelal, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yin̈ istiempohal naj Noé tuꞌ, ay ebnaj waꞌo chu, aypaxo ebnaj ucꞌu teꞌ, ay mac lan̈an ismohyi. Haꞌ huntekꞌan tuꞌ lan̈an iswatxꞌen anma yet yocto naj Noé yul teꞌ niman barco. Lahwi yocto naj Noé tuꞌ, istit huneꞌ niman yaxn̈ab, iscamilo sunil anma yu haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hac tuꞌ yupaxo anma yin̈ istiempohal naj Lot. Caw matzet chal iscꞌul anma, sakꞌal iswaꞌi yeb chiꞌuqꞌuipaxoj. Chilokꞌwi cat istxon̈wi. Chistzꞌunni istzꞌunub, chahnipaxocan̈ yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yajaꞌ yet yelti naj Lot yul con̈ob Sodoma tuꞌ, hacaꞌ xan̈e yay n̈ab, hac xan̈e tuꞌ yayilo kꞌaꞌ yeb asufre satcan̈. Iscamilo anma sunil yu huneꞌ kꞌaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hacaꞌ yu anma yet huneꞌ tiempohal tuꞌ, hac tuꞌ chu anma yin̈ huneꞌ tzꞌayical bay chinhulan, Hanin Akꞌbilintijan texol yu Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yet huneꞌ tzꞌayical tuꞌ, haꞌ mac ayahto yiban̈ yacꞌalil yatut mach chu yayti yinolti iskꞌuybe yul yatut, yeb mac ayto xol ismunil, matxa chu ispaxti yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tijab yul hecꞌul yin̈ yixal naj Lot. ");
INSERT INTO jacNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Haꞌ mac chꞌokꞌ yanma yin̈ tzet aya, mach chischah iskꞌinal yin̈ huneln̈e. Haxa mac hinan iscꞌul isbejnicano tzet ye tuꞌ win̈an, chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Chiwalan teyet, ta ay cawan̈ anma chiway sat istxꞌat yet huneꞌ akꞌbal tuꞌ, huneꞌ chiꞌilaxtoj, huneꞌ chicancanoj. ");
INSERT INTO jacNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cawan̈ ebix ix huneꞌn̈e lan̈an iscawni, huneꞌ ix chiꞌilaxtoj, huneꞌxa ix chicani. ");
INSERT INTO jacNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cawan̈ ebnaj huneꞌn̈e chimunlahi, huneꞌ naj chiꞌilaxcan̈, huneꞌxa naj chicani, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iskꞌamben ebnaj iscuywom Comam: —Mamin ¿baytuꞌwal chub huneꞌ tuꞌ? ẍi ebnaj. Istakꞌwi Comam tet ebnaj: —Caw haban huneꞌ tuꞌ, haꞌ bayticꞌa pacꞌanayo hunu camom, haꞌ tuꞌ chiscutxba isba noꞌ usmij, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yalnipaxo Comam Jesús huneꞌ yechel tiꞌ tet ebnaj iscuywom yu istxumni ebnaj ta caw yilal istxahli yin̈ sunil yanma tet Comam Dios yin̈ sunilbal tiempo. ");
INSERT INTO jacNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yalni Comam tet ebnaj: —Yet hunel ay huneꞌ naj alcal yul huneꞌ con̈ob. Caw mach chixiw naj tet Comam Dios, yebpaxo machi yelapno ye anma yul sat naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yulticꞌa huneꞌ con̈ob tuꞌ ay huneꞌ ix hunix. Hunun tzꞌayic isbeycꞌo ix iskꞌanno tet naj alcal tuꞌ, chalni ix hacaꞌ tiꞌ: “Ay huneꞌ mac ay ismul wetan, yuxin chinkꞌanan tawet ta chawatxꞌeayo yin̈ caw istoholal,” ẍi ix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Txꞌiꞌal el beycꞌo ix, yaj mach chisje naj iswatxꞌe huneꞌ howal tuꞌ. Lahwi tuꞌ xin yalni naj yul yet ischuquil: “Mach chinxiwan tet Dios, machipaxo hunu anma ay yelapno yul insatan, ");
INSERT INTO jacNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yaj wal tinan̈ xin caw yilal inwatxꞌenan tzet chal huneꞌ ix tiꞌ yun̈e isbejni ix yuli, ta machoj chitibayo wuhan yulicꞌo ix incꞌatan̈an,” ẍi naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yalnipaxo Comam: —Abewe tzet yute yalni naj alcal mach chixiw tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hajxam Comam Dios, ¿tom mach iscol Comam macta sicꞌbililo yu ta ayn̈eticꞌaco iskꞌanni tzꞌayic akꞌbal tet Comam? ¿Mataxca kꞌahan yechman anma tuꞌ tzet chiskꞌan tet Comam? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Chiwalan teyet machi nahatli iscollax huntekꞌan anma tuꞌ yu Comam. Yaj yet chinhulan hunelxa, Hanin Akꞌbilintijan texol yu Comam Dios, ¿ay tom anma chicawxo iscꞌul yin̈ Comam Dios? Matxam caw maca, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yalnipaxo Comam Jesús huneꞌxa yechel tiꞌ tet anma chal isba cꞌulal, yeb chiyahnipaxo yet anmahil. ");
INSERT INTO jacNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yalni Comam hacaꞌ tiꞌ: —Ay cawan̈ ebnaj beycꞌo txahlo yul yatut Comam Dios, huneꞌ naj fariseo, huneꞌxa naj ikꞌomilo tohlabal chito bey Roma. ");
INSERT INTO jacNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Haꞌ naj fariseo, lin̈an naj chitxahli naj hacaꞌ tiꞌ: “Mamin, chiwakꞌan yuchꞌandiosal tawet yuto hanintiꞌan manlahanojan yeb anma elkꞌom, yeb anma txꞌoj isbeybal, yeb ebnaj ixlom; yebpaxo manlahanojan yeb huneꞌ naj ikꞌomilo tohlabal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Walinan, cayel mach chinwaꞌan yul semana yu intxahlihan tawet, cat wakꞌnihan isdiezmohal yin̈ tzet chiwikꞌan,” ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wal naj ikꞌomilo tohlabal tuꞌ, nahat lin̈anti naj, xulanayo naj chitxahli yu yinayo isba tet Comam. Chistin̈nico naj istxam iscꞌul yu biscꞌulal yu ismul, chalni naj tet Comam: “Mamin, akꞌ nimancꞌulal win̈an, caw muluminan,” ẍi naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yalnipaxo Comam: —Chiwalan teyet, huneꞌ naj ikꞌomilo toholabal tuꞌ, meltzo naj yatut yin̈ caw tzalahilal yuto akꞌlaxcano nimancꞌulal yin̈ ismul naj yu Comam. Wal naj fariseo tuꞌ, mach chischah naj iscꞌulal sata Comam, yuto haꞌ mac chiyican̈ isba, chiꞌilaxayoj, haxa mac chiyiyo isba sata Comam chiꞌilaxcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yet hunel ay mac initi niẍte yuninal tet Comam Jesús yu yanayo iskꞌab Comam yiban̈ iswiꞌ. Yajaꞌ yet yilni ebnaj iscuywom Comam huneꞌ tuꞌ, iscachni ebnaj anma. ");
INSERT INTO jacNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yawten xin Comam ebnaj, yalni Comam tet ebnaj: —Mach checach istit niẍte unin incꞌatan̈an, yuto haꞌ mac chute isnabal hacaꞌ niẍte unin tiꞌ haꞌ chu yoc yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yuxin chiwalan yin̈ isyelal teyet, haꞌ mac mach chichahni Comam Dios Yahawoj hacaꞌ yeco yanma nichꞌan unin yin̈ ismam ismiꞌ, mach chu yoc yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ay huneꞌ naj iswiꞌehal con̈ob kꞌamben tet Comam Jesús: —Mam cuywawom, caw cꞌulach. ¿Tzet wal wuten inbahan cat inchahnihan huneꞌ kꞌinale mach istan̈bal? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Istakꞌwi Comam tet naj: —¿Tzet yin̈ xin chinhawalan cꞌulal? Machi huno mac cꞌul, cachann̈e Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hach tiꞌ hawohta huntekꞌan cuybanile chalni hacaꞌ tiꞌ: “Mach chaẍixli, mach chaẍpotxꞌwahi, mach chaẍelkꞌawi, mach chahobcan̈ lekꞌtiꞌal yin̈ hunuxa anma, ayojab yelapno ye hamam hamiꞌ yul hasat,” ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Istakꞌwi naj tet Comam: —Sunilal huntekꞌan chawal tiꞌ chinyijehan yichitax inchꞌibtijan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hayet yaben Comam huneꞌ tuꞌ, yalni Comam tet naj: —Ayto huneꞌxa caw yilal hawatxꞌeni. Txon̈to sunil tzet ayach, cat hawitxkꞌanto istohol yin̈ anma mebaꞌ, haxinwal caw ay hakꞌalomal satcan̈. Lahwi tuꞌ, cat hawoc tzujno wintajan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hayet yaben naj huneꞌ tuꞌ, caw occano biscꞌulal yin̈ yanma naj yuto caw kꞌalom naj sicꞌlebil. ");
INSERT INTO jacNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hayet yilni Comam ta caw oc biscꞌulal yin̈ iscꞌul naj, yalni Comam: —Tzet isyaꞌtajil yoc anma kꞌalom yul iskꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kꞌinaloj hunu noꞌ camello, ¿tom subuta yecꞌto noꞌ yul isholanil hunu chꞌen acuẍa? Hac tuꞌ ye anma kꞌalom, caw yaꞌta yoc yul iskꞌab Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Haꞌ anma aben tzet yal Comam tuꞌ, iskꞌamben hacaꞌ tiꞌ: —Ta hac tuꞌ, ¿mac taxca hunu chu iscolchahi? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Istakꞌwi Comam: —Haꞌ tzet caw yaꞌta yul sat anma, mach yaꞌtajo yul sat Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yalni naj Pedro tet Comam: —Mamin, wal on̈tiꞌan̈ sunil tzet ayon̈an̈ bejbilcano juan̈ yu joc tzujnojan̈ tawintaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yalni Comam Jesús: —Haꞌ mac chaco yanma yin̈ yet Comam Dios babel, tzujanxa tuꞌ cat yanico yanma yin̈ yatut, yixal, ismam, ismiꞌ, yuẍtaj, yanab, yuninal, ");
INSERT INTO jacNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","haꞌ ton huntekꞌan anma tuꞌ, caw niman ispaj chischah tet Comam Dios yul sat yiban̈kꞌinal tiꞌ, cat ischahnipaxo iskꞌinal mach istan̈bal yin̈ islahobal tzꞌayic, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yawtelo Comam Jesús ebnaj cablahon̈wan̈ iscuywom ischuquil, yalni Comam tet ebnaj: —Wal tinan̈ jahweto bey Jerusalén. Haꞌ bey tuꞌ chijaꞌcano isba sunil tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat win̈an, Hanin Akꞌbilintijan texol yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chinalaxicojan yul iskꞌab ebnaj mach Israeloj. Chitzebo ebnaj win̈an, cat isbahwaho ebnaj win̈an, cat istzubloco ebnaj win̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chinmakꞌlaxojan yu ebnaj, chilahwo tuꞌ cat quinyakꞌnicamojan ebnaj, yajaꞌ yin̈ yox tzꞌayic cat witzitzbican̈an xol camom hunelxa, ẍi Comam tet ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yaj maẍticꞌa tzet nachalo yu ebnaj, yebpaxo maẍticꞌa yohtan̈elo ebnaj baytet yin̈ tzotel Comam, yuto ewanto ye yul sat ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yet lan̈anxa yapni Comam Jesús bey con̈ob Jericó, ay huneꞌ naj mach chu yilni, tzꞌon̈anayo istiꞌ beh kꞌanno melyu. ");
INSERT INTO jacNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hayet yaben naj ta caw hantan̈e anma chꞌecꞌto sata naj, iskꞌamben naj tzet chu anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yallax tet naj tato haꞌ Comam Jesús ah Nazaret lan̈an yecꞌtoj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hayet yaben naj huneꞌ tuꞌ, yah yaw naj yin̈ caw ip, yalni naj: —Mam Jesús, hach titnajach yin̈ jichmam David, tzꞌayojab hacꞌul win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yajaꞌ anma babelicꞌo sata Comam cachwa yin̈ naj yun̈e isbejni naj yel yaw. Yaj caw ecꞌbalto islahico naj yel yaw, yalni naj: —Mamin hach titnajach yin̈ jichmam David, caw tzꞌayojab hacꞌul win̈an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hayet yaben Comam Jesús yel yaw naj yoc lin̈no Comam, yalni Comam ta chiꞌilaxti naj iscꞌatan̈. Hayet yapni naj, iskꞌamben Comam tet naj: ");
INSERT INTO jacNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tzet chawoche chinwatxꞌehan? ẍi Comam. Istakꞌwi naj: —¡Mamin! chiwochehan chawakꞌ hajlo insatan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yalni Comam tet naj: —Hajlojab hasat yuto maxawaco hawanma win̈an, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yaln̈ena Comam huneꞌ tuꞌ, ishajlo sat naj. Yoc tzujno naj yinta Comam, yakꞌni naj yuchꞌandiosal tet Comam Dios. Sunil anma ilni huneꞌ tuꞌ yalpaxo cꞌulla tzotiꞌ yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hayet yapni Comam Jesús bey Jericó, yecꞌ Comam yul con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Haꞌ bey tuꞌ, ay huneꞌ naj winaj caw kꞌalom, Zaqueo isbi. Yahaw yeco naj yin̈ ebnaj ikꞌomilo tohlabal chito bey con̈ob Roma. ");
INSERT INTO jacNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naj Zaqueo tuꞌ, yoche naj yila Comam Jesús, yaj mach chiyu yilni naj yuto hantan̈e anma tzujanico yinta Comam, yebpaxo yu caw nichꞌan chꞌan istel naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yuxin babicꞌo naj sata anma, yahto naj yin̈ iskꞌab huneꞌ teꞌ sicómoro aycan̈ istiꞌ beh, yu yilni naj Comam yet chꞌecꞌto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hayet yecꞌto Comam yich teꞌ, istꞌan̈xahto Comam yin̈ naj, yalni Comam tet naj: —Zaqueo, ayan̈ti yin̈ an̈e, yuto haꞌ bey hawatut chincanojan huneꞌ akꞌbal tiꞌ, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hayet yaben naj Zaqueo huneꞌ tuꞌ, yin̈ an̈e ayti naj, isto naj. Caw xin chitzala iscꞌul naj yet ischahni naj Comam yul yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hayet yilni anma huneꞌ tuꞌ, yichico anma buchwal yin̈ Comam yuto cancano Comam bey yatut huneꞌ naj mulum. ");
INSERT INTO jacNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Haꞌ naj Zaqueo tuꞌ, ah lin̈no naj, yalni naj tet Comam: —Mamin, wal tinan̈ chiwakꞌan yicta tzet ayinan tet anma mebaꞌ, yeb xin ta ay mac ecꞌbal wutelojan ismelyu, can̈elto ecꞌbal selel chiwakꞌan tet, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yalni Comam: —Mahul huneꞌ colbanile bey huneꞌ n̈a tiꞌ tinan̈; naj Zaqueo tiꞌ caw yuninalpaxo icham Abraham ye naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wal xin Hanin Akꞌbilintijan texol yu Comam Dios, hulnajinan insayaꞌan yeb incolnihan anma cꞌaynato yu ismul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yet lan̈an yaben anma yin̈ tzet chal Comam Jesús tuꞌ, lan̈anxa xin yapni Comam bey Jerusalén yoc yin̈ isnabal anma ta lan̈anxa yapni istiempohal bay chꞌoc Comam Dios Yahawilo anma, yuxin yicheco Comam yalni huneꞌ yechel tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yalni Comam: —Yet hunel ay huneꞌ naj caw cꞌulticꞌa yin̈bal. Awtelax naj yul huneꞌ niman con̈ob yu ischahni naj yoc yahawilo yul iscon̈ob yet chimeltzohi. ");
INSERT INTO jacNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yet maẍto chito naj, yawte naj lahon̈wan̈ ebnaj chimunla yintaj, yakꞌnicano naj niman melyu tet hunun ebnaj yu ismunla ebnaj yeb chꞌen. Lahan yutecano naj isbisil chꞌen yin̈ ebnaj. Yalnicano naj tet ebnaj: “Munlahan̈we yeb chꞌen inmelyutiꞌan masanto yet chinhulan, cat heyakꞌni chꞌen yeb yal wetan,” ẍi naj, isto naj xin. ");
INSERT INTO jacNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yajaꞌ wal ebnaj yet con̈ob naj xin, caw chichiwa iscꞌul ebnaj yin̈ naj, yuxin yet isto naj, tzujanticꞌa yu isto huntekꞌan ebnaj akꞌocꞌule yin̈ naj tet naj awten naj tuꞌ, yalni ebnaj tet naj caw yahaw tuꞌ hacaꞌ ti: “Haꞌ huneꞌ naj tiꞌ caw mach chijochehan̈ chꞌoc naj yahawilo yul cocon̈oban̈,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yaj caw akꞌlaxticꞌa huneꞌ ismunil naj yoc yahawo iscon̈ob tuꞌ. Haxa yet ayxa naj yul iscon̈ob hunelxa, yawten naj ebnaj lahon̈wan̈ bay yakꞌ naj ismelyu tuꞌ yu iskꞌamben naj hantaxa yal chꞌen yikꞌ hunun ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yapni huneꞌ naj babel, yalni naj: “Mamin, haꞌ chꞌen hamelyu hawacano yul inkꞌaban, lahon̈ebto chꞌen wikꞌan yu chꞌen,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Istakꞌwi naj yahaw tuꞌ tet naj: “Hach tiꞌ, caw cꞌul yu hamunla yin̈ hanicꞌchꞌan wacanojan tawet, yuxinto chaẍwacanicojan yahawo lahon̈eb con̈ob,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lahwi tuꞌ xin, yapni hunxa naj munlawom, yalni naj hacaꞌ tiꞌ: “Mamin, haꞌ chꞌen hamelyu hawakꞌcano yul inkꞌaban, howeb to chꞌen wikꞌan yin̈ chꞌen,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yalni naj yahaw tuꞌ tet naj: “Hach tiꞌ, chaẍwacanicojan yahawilo howeb con̈ob,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lahwi tuꞌ xin yapni hunxa naj, yalni naj tet naj yahaw tuꞌ hacaꞌ tiꞌ: “Mamin, ay hamelyu lah. Cꞌubabil chꞌen yul huneꞌ payuꞌe tiꞌ wuhan. ");
INSERT INTO jacNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Caw quinxiwan intzabnihan hamelyu tiꞌ, yuto wohtajan ta caw how ach, yebpaxo toxan̈e chachah tzet ye tuꞌ maẍtajach watxꞌen̈e, yeb ton̈e chahatxꞌ tzet ye tuꞌ maẍtajach tzꞌunn̈e,” ẍi naj tet naj yahaw. ");
INSERT INTO jacNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yalni naj yahaw tuꞌ tet naj: “Walach hach tiꞌ, caw machiswalil yu hamunlahi, yu tzet maxawal wettiꞌan yuxin chaẍwacanicojan yin̈ isyaꞌtajil. ");
INSERT INTO jacNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tzet yin̈ yuxin mach hawakꞌ inmelyutiꞌan cꞌamil tet anma, haxinwal yet manhultiꞌan ayxa yal chꞌen chikꞌa?” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yalni xin naj yahaw tuꞌ tet ebnaj ayco iscꞌatan̈ hacaꞌ tiꞌ: “Iwelo chꞌen melyu tet naj tiꞌ, cat heyakꞌni chꞌen tet naj ikꞌni chꞌen lahon̈eb to,” ẍi naj yahaw tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yalni ebnaj: “Mamin, yaj huneꞌ naj chawal tuꞌ, caw lahon̈ebxa chꞌen ecꞌbal ikꞌbil yu naj,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Istakꞌwi naj yahaw tuꞌ xin: “Haꞌ mac ay yet, chꞌakꞌlax yakꞌbil tet, haꞌ mac machi yet, haꞌ nichꞌan ay yul iskꞌab tuꞌ, chiꞌilaxolo tet. ");
INSERT INTO jacNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yebpaxo xin, ebnaj ayco ishowal win̈an mach choche chinocan yahawilo yul con̈ob tiꞌ, iweti ebnaj bey tiꞌ, cat hepotxꞌni camo ebnaj yin̈ insatan,” ẍi naj yahaw tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lahwi yalni Comam Jesús huntekꞌan tuꞌ xin, isto Comam bey Jerusalén yeb ebnaj iscuywom. ");
INSERT INTO jacNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hayet ayco Comam yin̈ istzalanil won̈an Olivo, xolbal con̈ob Betfagé yeb con̈ob Betania, ischejnito Comam cawan̈ ebnaj iscuywom, yalni Comam tet ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Asiwe bey huneꞌ aldea cosatacꞌto tiꞌ. Yet chexapno bey tuꞌ, cheyilaꞌ huneꞌ noꞌ burro xecan, maẍto hunu mac chiꞌahto yiban̈ noꞌ. Chepuholo noꞌ, cat heyinoti noꞌ wetan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yalnipaxo Comam: —Ta ay mac chikꞌamben teyet, “¿Tzet yin̈ xin chepuhilo noꞌ?” ta ẍi, cheyalaꞌwe hacaꞌ tiꞌ: “Ay chꞌocnico noꞌ yu Comam Jesús,” quexchi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Isto ebnaj iscuywom tuꞌ, yilcha noꞌ yu ebnaj hacaꞌticꞌa yu yalni Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yet lan̈an ispuhnilo ebnaj noꞌ yapni ebnaj ay yet noꞌ tuꞌ, yalni ebnaj: —¿Tzet yuxin chepuhilo noꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Istakꞌwi ebnaj: —To ay chꞌocnico noꞌ yu Comam Jesús, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lahwi tuꞌ xin yinito ebnaj noꞌ tet Comam, yanahto ebnaj huntekꞌan xil iskꞌap yiban̈ noꞌ, tzujan tuꞌ xin iscolwa ebnaj yanahto Comam yiban̈ noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hayet lan̈an yecꞌto Comam xin, islitxꞌbanayo anma xil iskꞌap yul beh sata Comam yu chitzala iscꞌul anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hayet lan̈anxa yapni Comam yin̈ isxulanil won̈an Olivo tuꞌ, yah yaw sunil anma tzujan yinta Comam yu tzalahilal. Yalni anma cꞌulla tzotiꞌ yin̈ Comam Dios yu sunil cꞌaybalcꞌule xayil anma. ");
INSERT INTO jacNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Chalni anma hacaꞌ tiꞌ: —Jalaꞌwe cꞌulla tzotiꞌ yin̈ Jahawil chul coxol yu Comam Dios. Ayojab akꞌancꞌulal yul satcan̈, caw jakꞌaweco ismay Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ay xin huntekꞌan ebnaj fariseo ayco xol anma tuꞌ, halni tet Comam: —Mam cuywawom, cach huntekꞌan anma chꞌel yaw tiꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yalni Comam Jesús tet ebnaj: —Chiwalan teyet, ta chisbejaꞌ anma yelo yaw, haxam chꞌen chꞌen chiꞌaho yaw selelo anma tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Haxa yet lan̈anxa yapni Comam iscawilal con̈ob Jerusalén, yokꞌcan̈ Comam yilni con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yalni Comam hacaꞌ tiꞌ: —Tinan̈ xin, hex ah Jerusalén, majaltam yet huneꞌ tzꞌayic tiꞌ chinachalo heyu yin̈ huneꞌ mac chu yakꞌni akꞌancꞌulal yul heyanma, yaj wal xin mach chinachalo huneꞌ tiꞌ heyu yuto caw ewan ye yul hesat. ");
INSERT INTO jacNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cꞌanchꞌanex, ay huneꞌ tiempo bay chihulo isyaꞌtajil teyiban̈ yu anma ayco ishowal teyin̈. Chihoylaxayo hecon̈ob tiꞌ, hacaꞌ xan̈e peyab chuco ebnaj soldado, cat yanico ebnaj howal teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chitan̈tzelaxilo huneꞌ con̈ob tiꞌ. Matxa hunu chꞌen chꞌen chicancano yiban̈ yet chꞌenal, cat ispotxꞌlax camo sunil anma yuto mach hechah huneꞌ Mac Akꞌbilti texol Hecolomalo yu Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lahwi tuꞌ xin, yocto Comam Jesús yul yatut Comam Dios, istzumbenilti Comam anma chitxon̈wi bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yalni Comam tet anma: —Tzꞌibn̈ebilcano yul Yum Comam Dios hacaꞌ tiꞌ: “Haꞌ watutan yet txah yehi,” ẍicanoj. Yaj hex tiꞌ hacaꞌ hunu isn̈achꞌen elkꞌom ye heyu, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hunun tzꞌayic isbey Comam Jesús cuywal yul yatut Comam Dios. Yajaꞌ ebnaj yahawil yeco yin̈ ebnaj sacerdote, yeb ebnaj cuywawom yin̈ isley naj Moisés, yebpaxo ebnaj yahaw yeco yin̈ con̈ob, caw issay ebnaj tzet chute yakꞌni camo Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yajaꞌ mach chitxumcha yu ebnaj tzet chu ispotxꞌlax Comam, yuto caw ayco yanma sunil anma yaben tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ay huneꞌ tzꞌayical tiꞌ yet lan̈an iscuywa Comam Jesús yul yatut Comam Dios, yet chalni Comam cuybanile yet colbanile, yapni ebnaj yahawil yin̈ ebnaj sacerdote yebpaxo ebnaj cuywawom yin̈ isley naj Moisés, yeb ebnaj ichamta iswiꞌehal yin̈ con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iskꞌamben ebnaj tet Comam: —¿Mac cachchejni hawatxꞌen huntekꞌan tiꞌ? yebpaxo ¿mac akꞌni hawip? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Istakꞌwi Comam Jesús tet ebnaj: —Haquinpaxtuꞌan, ay huneꞌ inkꞌambebalan chiwakꞌan teyet. Pajtzewe wetan, ");
INSERT INTO jacNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿mac chejniti naj Juan anican̈ haꞌ iswiꞌ anma, Comam Dios mato haꞌ anma? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yichico ebnaj iskꞌamben tet hunun: —¿Tzet xin chijute jalni tet naj tiꞌ? Ta chijalaꞌ ta Comam Dios chejn̈eti naj Juan tuꞌ, chalaꞌ naj jet: “¿Tzet yin̈ yuxin machi heyayto yul heyanma yin̈ tzet yal naj?” ẍim naj jet. ");
INSERT INTO jacNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Macato ta chijalaꞌpaxo ta maẍtaj Comam Dios an̈eti naj, chitij ishowal anma jin̈, cat con̈iskꞌojno camoj, yuto haꞌ naj Juan tuꞌ caw ischejab Comam Dios ye naj yul sat anma, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yuxin yal ebnaj tet Comam: —Mach johtajojan̈ mac akꞌni ismunil naj Juan tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yuxinto yal Comam Jesús tet ebnaj: —Hac intuꞌan, mach chiwalpaxilojan teyet mac akꞌn̈e huneꞌ wiptiꞌan inwatxꞌenan huntekꞌan tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lahwi tuꞌ xin, yichico Comam Jesús yalni huneꞌxa yechel tiꞌ tet anma: —Ay huneꞌ naj winaj tzꞌunni teꞌ uva sat istxꞌotxꞌ. Lahwi tuꞌ xin yanito naj istzꞌunub comonal tet huntekꞌan ebnaj munlawom. Isto naj niman tiempo bey huneꞌ txꞌotxꞌ caw nahat. ");
INSERT INTO jacNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yet yapni istiempohal yuxlax teꞌ uva, ischejnito naj yahaw txꞌotxꞌ huneꞌ ischejab ischabaꞌ ismajul tet ebnaj munlawom tuꞌ. Hayet yilni ebnaj yapni naj, yoc ebnaj ismakꞌno naj. Maẍticꞌa xin tzet akꞌlax tet naj, ischejlaxtopaxo naj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lahwi tuꞌ xin, ischejnipaxto naj yahaw tuꞌ huneꞌxa ischejab. Hayet yapni naj, yoc ebnaj munlawom tuꞌ iscajno naj, ismakꞌnipaxo ebnaj naj. Maẍticꞌa tzet akꞌlaxpaxo tet naj, istzumbelaxto naj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lahwi tuꞌ xin, yanipaxto naj yahaw txꞌotxꞌ tuꞌ huneꞌxa ischejab yet yoxel. Hayet yapni naj tuꞌ, yocpaxo ebnaj munlawom tuꞌ ismakꞌno taho naj, istzumbelaxpaxti naj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yuxinto yal naj yahaw txꞌotxꞌ hacaꞌ tiꞌ: “¿Tzet wal wutenan tinan̈? Wal xin chinchejtojan huneꞌ incꞌaholtiꞌan caw ochebil wuhan, etzan̈em chixiw ebnaj tet naj,” ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hayet yilni ebnaj yapni naj cꞌahole tuꞌ, yalni ebnaj tet hunun: “¡Ilwecꞌanabtoj! Lan̈an yul naj cꞌahole lah. Haꞌ tet naj chicancano istxꞌotxꞌ ismam tiꞌ. Wal tinan̈ xin comakꞌaꞌwe camo naj haxinwal jetxa chuboco huneꞌ txꞌotxꞌ tiꞌ,” ẍi ebnaj munlawom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lahwi tuꞌ xin yilaxilto naj yintalto peyab tuꞌ, haꞌ bey tuꞌ akꞌlax camo naj, ẍi Comam. Iskꞌamben Comam tet anma: —¿Tzet xin chiutelax ebnaj munlawom yu naj yahaw tzꞌunub tuꞌ, heyalni? ");
INSERT INTO jacNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wal xin haꞌ naj caw yahaw tuꞌ, chitij cat istan̈tzencanilo naj ebnaj munlawom tuꞌ, cat yanito naj istzꞌunub comonal tet hunuxa majan ebnaj munlawom, ẍi Comam. Hayet yaben anma huneꞌ tuꞌ yalni: —Machojab bakꞌinal chu hacaꞌ chawal tiꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yuxinto oc tꞌan̈no Comam Jesús yin̈ anma, yalni Comam: —¿Yaj tzettaxca chalilo huneꞌ tzꞌibn̈ebilcano yul Yum Comam Dios heyalni bay chal hacaꞌ tiꞌ?: Haꞌ huneꞌ chꞌen chꞌen istirilo ebnaj watxꞌem n̈a, haꞌ chꞌen caw ecꞌbal cꞌul yoc xeꞌo n̈a, ẍicanoj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yaj macn̈eticꞌa chiꞌaycꞌay yiban̈ huneꞌ chꞌen tuꞌ chikꞌahtoj, yaj ta haꞌ chꞌen chꞌaycꞌay yiban̈ huneꞌ mac tuꞌ, chiquechmoto yalan̈ chꞌen, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yuxin ebnaj yahawil yin̈ ebnaj sacerdote yeb ebnaj cuywawom yin̈ isley naj Moisés, yet hunep tuꞌ yoche ebnaj istzabayo Comam Jesús, yuto nachalo yu ebnaj ta haꞌ ebnaj chal huneꞌ cuybanile yal Comam, yaj chixiw ebnaj istzabnayo Comam yu anma ayicto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yuxin haꞌ ebnaj yahaw yin̈ ebnaj sacerdote yeb ebnaj chicuyni anma yin̈ isley naj Moisés istohla ebnaj huntekꞌan ebnaj to ilno ta chꞌaycꞌay Comam yin̈ hunu lekꞌtiꞌal. Cꞌul yub ebnaj cꞌulchꞌan istzotel ebnaj tet Comam yun̈e yaycꞌay Comam yin̈ hunu tzotiꞌ, cat yanico ebnaj Comam yul iskꞌab naj gobernador. ");
INSERT INTO jacNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yalni ebnaj tet Comam: —Mam cuywawom, caw johtajan̈ ta tzet chawala yeb tzet chacuyu caw toholcanoj, yebpaxo lahan yelapno ye anma yul hasat. Chacuypaxo yin̈ caw isyelal tzet chu cowatxꞌen yin̈ tzet choche Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yuxin chicokꞌambehan̈ tawet: ¿Cꞌulmi jakꞌni cotohlabal tet naj jahaw ay bey Roma, naj César, mato machoj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yajaꞌ yohtaxa Comam ta txꞌoj nabil yu ebnaj, yuxin yal Comam tet ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Yewe hunu chꞌen melyu wilaꞌan nan̈. ¿Mac najil ayco yechel sat yeb isbi yin̈ chꞌen? ẍi Comam. Istakꞌwi ebnaj: —Yechel sat naj jahaw ay bey Roma yeb isbi naj ayco yin̈ chꞌen, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yalni Comam tet ebnaj xin: —Akꞌwe tet naj César tuꞌ baytet yet naj yehi, cat heyakꞌni tet Comam Dios baytet yet Comam yehi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yajaꞌ maẍticꞌa hunu tzotiꞌ txꞌoj ilchalo yin̈ Comam yu ebnaj yin̈ tzet yal Comam sata anma. Ton̈e cꞌaycanocan̈ iscꞌul ebnaj yu ispaj istzotiꞌ ebnaj yakꞌ Comam. Yuxin matxa tzet yal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lahwi tuꞌ xin yapni huntekꞌan ebnaj saduceo ilwal yin̈ Comam Jesús. Ebnaj saduceo tuꞌ, chal ebnaj tato matxa chiitzitzbi anma chicami. Iskꞌamben ebnaj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Mam cuywawom, tzꞌibn̈ebilcano yu naj Moisés tato chicam yichamil hunu ix ix, mach xin yuninal naj yeb ix, yilal yikꞌni ix yuẍta naj camna tuꞌ, haxinwal ay yuninal naj yeb ix, cat yoc yuninalo naj camna tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yaj ay hunel ay hujwan̈ ebnaj yuẍtan̈e isba. Naj babel mohyi naj yeb huneꞌ ix, yaj cam naj, machi xin hunu yuninal naj yeb ix. ");
INSERT INTO jacNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hacpax tuꞌ naj iscab, mohyi naj yeb ix, iscampaxo naj, machipaxo yuninal naj yeb ix. ");
INSERT INTO jacNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ismohyipaxo naj yox yeb ix. Hac tuꞌ xin yu ismohyilo ebnaj hujwan̈ tuꞌ yeb ix, yaj ton̈e la-cam ebnaj sunil. Maẍticꞌa xin hunu yuninal ebnaj yeb ix. ");
INSERT INTO jacNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Islahobal xin, iscampaxo ix. ");
INSERT INTO jacNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yuxin hayet chiapni istzꞌayical yet chiitzitzbican̈ anma camnaxa, ¿mac xin ebnaj hujwan̈ tuꞌ chꞌoc yichamilo ix yuto mohyina ebnaj hujwan̈ tuꞌ yeb ix? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Istakꞌwican̈ Comam Jesús: —Bey yul sat yiban̈kꞌinal tiꞌ ebnaj winaj chiyikꞌ ebnaj yixal, yeb ebix ix chikꞌ ebix yichamil. ");
INSERT INTO jacNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yajaꞌ anma yetticꞌa satcan̈ yehi, yet chiitzitzbocan̈ xol camom, matxa yixal naj winaj, matxapaxo yichamil ix ix. ");
INSERT INTO jacNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Matxa chicam anma tuꞌ yuto lahanxa chꞌelico yeb ebnaj yángel Comam Dios. Chiꞌoc yuninalo Comam Dios bey satcan̈ yet chiitzitzbican̈. ");
INSERT INTO jacNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Naj Moisés, yakꞌcano naj johtan̈eloj tato chiitzitzbican̈ anma camnaxa, bay tzꞌibn̈ebilcano yin̈ yet yilni naj yoc kꞌaꞌ yin̈ hun hoban teꞌ txꞌix yet istzotelilti Comam Dios xol kꞌa kꞌaꞌ tet naj. Yalni Comam: —Haninan isDiosal icham Abraham, isDiosal naj Isaac yebpaxo isDiosal naj Jacob, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Waxan̈ca camnaxa ebnaj, yaj itzitz ebnaj yul sat Comam Dios, yuto mach isDiosalo camom ye Comam. Yuxin yul sat Comam Dios sunil anma itzitz, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yalni huntekꞌan ebnaj chicuyni anma yin̈ isley naj Moisés tet Comam: —Mam cuywawom caw cꞌul maxawute hapajtzen huneꞌ tiꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lahwi tuꞌ xin matxa hunu ebnaj yakꞌ iskꞌambebal tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yalni Comam Jesús tet anma ayco iscꞌatan̈ tuꞌ: —¿Tzet yin̈ yuxin chihallaxi tato yin̈ naj David titna Comam Cristo? ");
INSERT INTO jacNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yajaꞌ yalcano naj David yin̈ Salmos hacaꞌ tiꞌ: Yal Comam Dios tet Wahawilan: “Ayan̈ tzꞌon̈no yin̈ inwatxꞌkꞌabtiꞌan, ");
INSERT INTO jacNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","masanto chiwacojan anma ayco ishowal tawin̈ yalan̈ hawoj,” ẍi naj David. ");
INSERT INTO jacNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Tzet yin̈ yuxin yal naj David Wahawan yin̈ Comam Cristo, tato yin̈ naj titna Comam? ẍi Comam Jesús tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yet ayco anma yaben tzet chal Comam Jesús tuꞌ, yalni Comam tet ebnaj iscuywom: ");
INSERT INTO jacNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Caw cheyil heba haxinwal mach chexcꞌayto yu iscuybanil ebnaj chicuyni anma yin̈ isley naj Moisés, yuto ton̈eticꞌa choche ebnaj yecꞌ hucxi yeb huntekꞌan nime xilkꞌape chaco yin̈. Chochepaxo ebnaj ta nanxa islow chu istioẍli anma tet ebnaj yet chiecꞌ ebnaj yulaj txon̈bal. Chisaypaxo ebnaj huntekꞌan tzꞌon̈obal caw ay yelapno yul iscapilla ebnaj Israel, yebpaxo yet chꞌawtelax ebnaj waꞌo yin̈ kꞌin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chelkꞌanpaxilo ebnaj sunil tzet ay ebix hunix. Yun̈e yallax ebnaj cꞌulal yuxin caw nime chute ebnaj yoj istxah. Yaj hanan chiwalan ta caw niman isyaꞌtajil chul yiban̈ ebnaj, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yet hunel ayicto Comam Jesús yul yatut Comam Dios, yilni yanayto ebnaj kꞌalom yofrenda yul caẍa bay chayto anma yofrenda. ");
INSERT INTO jacNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yilnipaxo Comam yanayto huneꞌ ix hunix caw mebaꞌ cabeb chꞌen melyu. ");
INSERT INTO jacNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yalni Comam hacaꞌ tiꞌ: —Yin̈ caw isyelal chiwalan teyet, haꞌ huneꞌ ix hunix tiꞌ, caw mebaꞌ ix, yajaꞌ caw ecꞌbal mayakꞌ ix sata sunil mac mayayto yofrenda tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yuto haꞌ ebnaj tiꞌ, iskꞌal xan̈e chakꞌ ebnaj tet Comam. Wal huneꞌ ix tiꞌ, caw mebaꞌ ix, yajaꞌ caw cꞌuxan mayayto ix ismelyu chilokꞌni tzet chiocnico yu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ay huntekꞌan ebnaj cuywom tiꞌ lan̈an yalni ta caw cꞌulchꞌan jilni yatut Comam Dios yu huntekꞌan chꞌen chꞌen caw cꞌulchꞌan ayco yin̈, yebpaxo yu issabehal anma ayco yelawiloj. Yuxinto yal Comam Jesús: ");
INSERT INTO jacNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Sunil huntekꞌan cheyil tiꞌ, chul istiempohal bay chiuchcꞌalaxayoj. Matxa huno chꞌen chꞌen latzꞌbil tiꞌ chican yiban̈ yet chꞌenal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iskꞌamben ebnaj iscuywom Comam: —Mamin, ¿bakꞌin chu huneꞌ chawal tiꞌ? ¿Tzet chiyenilo yet chul huneꞌ tiempohal tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yalni Comam: —Caw cheyil heba haxinwal machi mac chexakꞌni subchahoj yuto caw ay mac chuli, cat yalni hacaꞌ tiꞌ: “Hanintiꞌan Cristo hinan, maꞌayilo huneꞌ istiempohal tiꞌ,” ẍi ebnaj. Yaj mach chexoc tzujno yinta tzet chal ebnaj tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hayet cheyabeni ta ay howal, yebpaxo yet chꞌah wejna anma howal yin̈ ebnaj yahaw txꞌotxꞌ nime con̈ob, mach chexxiwcan̈ yuto yilal yul huntekꞌan tuꞌ babel, yaj maẍto istan̈balo yiban̈kꞌinal tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yalnipaxo Comam: —Chakꞌle howal huneꞌ txꞌotxꞌ nime con̈ob yeb hunxa txꞌotxꞌ nime con̈ob, yebpaxo huntekꞌanxa con̈ob chakꞌlecan̈ howal yeb huntekꞌanxa. ");
INSERT INTO jacNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chulpaxo nimeta chixcab, cat yul wahil, yebpaxo yabil caw how yulajla con̈ob yul sat yiban̈kꞌinal tiꞌ. Ay huntekꞌan xiwbalcꞌule yeb nimeta cꞌaybalcꞌule chu satcan̈, caw chixiw anma yilni. ");
INSERT INTO jacNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yajaꞌ yet maẍto chul huntekꞌan tuꞌ, chextzablaxayoj, cat hetzumbelaxicꞌoj. Chexilaxto yulajla iscapilla ebnaj Israel cat heyilwelaxi, cat heyalaxico preso, cat heyilaxto sata ebnaj rey yeb sata huntekꞌanxa ebnaj yahawil, sunil huntekꞌan isyaꞌtajil tiꞌ chechah yu ayexxaco yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hac tuꞌ xin chu quinheyalnilojan tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yaj mach cheyaco yin̈ hecꞌul yin̈ tzet cheyal sata ebnaj yu hecolni heba yin̈ tzet chal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hanintiꞌan chiwakꞌan hehelanil hetzoteli, haxinwal haꞌ ebnaj ayco ishowal teyin̈, mach chikꞌoji ebnaj yin̈ ispaj hetzotiꞌ, yeb matxa tzet tzꞌaj yalaꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ayex chexalaxico yul iskꞌab ebnaj yahaw yu hemam, hemiꞌ, yu heyuẍtaj, yu heyicꞌal yebpaxo yu heyamigo. Ayex chexakꞌlax camoj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sunil anma chꞌoc ishowal teyin̈ yuto ayco heyanma win̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wal xin mach chexxiwi yuto Comam Dios chexcolni. Machi hunu xil hewiꞌ chicꞌaytoj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tohol cheyute heba haxinwal chexcolchahi. ");
INSERT INTO jacNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hayet hoyanxaco ebnaj soldado yin̈la Jerusalén tiꞌ, cheyohtan̈eweloj ta toxa chiuchcꞌalaxayoj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Haꞌ mac ay yul sunil ismajul Judea tiꞌ tojab yebaꞌ isba iswiꞌla witz. Haxa mac ay yul con̈ob Jerusalén tiꞌ, elojabcan̈. Yebpaxo haꞌ mac ayto xol ismunil, matxaojab chimeltzo yul con̈ob tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yuto hayet huneꞌ tiempohal tuꞌ, chul isyaꞌtajil yiban̈ anma ay yul huneꞌ con̈ob tiꞌ, haꞌ ton ispaj sunil istxꞌojal tzet xaꞌiswatxꞌe, cat yijnicano isba tzet tzꞌibn̈ebilcano yul Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yaj cꞌanchꞌan ebix ix ayxa tzet ye yin̈ huneꞌ tiempohal tuꞌ, yeb ebix chito txutxwi yunin yin̈. Yuto chitit ishowal Comam Dios yiban̈ anma tiꞌ, cat yul isyaꞌtajil yiban̈ huneꞌ txꞌotxꞌ con̈ob tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Caw txꞌiꞌal anma chicam xol howal, cat yilaxto anma yulajla nan con̈obal, cat yoccano con̈ob Jerusalén yalan̈ yoj anma mach Israeloj masanto chꞌapni istzꞌayical bay halbil yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ay huntekꞌan yechel chisyecan̈ isba yin̈ tzꞌayic yeb yin̈ ixahaw, yeb yin̈ txꞌumel. Wal anma ay sat yiban̈kꞌinal tiꞌ, chisomchaocan̈ iscꞌul yu xiwquilal yaben ishuccha haꞌ mar yet chismakꞌnican̈ isba haꞌ, yuto caw ayxa ismay chute haꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chipaxilo yip anma yu xiwquilal yu isnani tzet chu yul sat yiban̈kꞌinal tiꞌ. Yebpaxo sunil tzet caw ay yip satcan̈ chitzicobtan̈elaxi. ");
INSERT INTO jacNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chilahwi tuꞌ xin, cat yilni anma wayilojan xol moyan Hanin Akꞌbilintijan texol yu Comam Dios. Chinhulan yeb sunil iskꞌakꞌal wipan. ");
INSERT INTO jacNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hayet lan̈an istzabnico yuni huntekꞌan chiwaltiꞌan, cheyaweco yip heyanma, cat hetꞌan̈xiwecan̈ satcan̈ yuto toxa chexcolchahi, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yanipaxico Comam hunxa yechel tiꞌ: —Chisje hetxumnilo yin̈ teꞌ higuera yeb hunuxa teꞌ comon kꞌeptaj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hayet cheyilni yelilo xaj teꞌ, chinachalo heyu ta toxa chꞌoc n̈ab. ");
INSERT INTO jacNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hacpax tuꞌ, yet chiyuni huntekꞌan tiꞌ cheyohtan̈eweloj tato toxa chꞌoc Comam Dios Yahawiloj. ");
INSERT INTO jacNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yin̈ caw yeli chiwalan teyet, chul huntekꞌan chiwaltiꞌan yet maẍto chilahwilo iscam huntekꞌan anma Israel tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Haꞌ satcan̈ yeb txꞌo txꞌotxꞌ tiꞌ chitan̈iloj, yaj wal Intzotiꞌan xin mach chꞌecꞌto yet yijni isba tzet chala. ");
INSERT INTO jacNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Caw nann̈e heyu, machojab cheyakꞌ cawxolo henabal yu pekꞌal, yu ucꞌu teꞌ, yeb yin̈ tzettaj ye tuꞌ bay cheyaco heyanma yul yiban̈kꞌinal tiꞌ, haxinwal yet chul huneꞌ tzꞌayic tuꞌ, mach tona nahul ayex. ");
INSERT INTO jacNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yuto hacaꞌ hunu latzꞌab, hac tuꞌ chu yul huneꞌ tzꞌayic tuꞌ yiban̈ anma ay yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yuxin caw majwan̈wej, txahlan̈we yin̈ sunilbal tiempo, haxinwal chu hecolni heba yalan̈ huntekꞌan tzet chihul tuꞌ, haxinwal mach chexxiw yet chexoc lin̈no insatajan, Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yet tzꞌayical chicuywa Comam Jesús yul yatut Comam Dios, haxa yet akꞌbalil xin, chibey Comam bey huneꞌ won̈an Olivo isbi. ");
INSERT INTO jacNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wal xin, hunun sacꞌayal yapni anma yul yatut Comam Dios yaben tzet chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yet lan̈anxa yayilo kꞌin̈ Pascua, yet chiwahlax ixim pan machi yan̈al chialaxicoj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yoc ebnaj yahawil sacerdote yeb ebnaj chicuyni anma yin̈ isley naj Moisés issayaꞌ yin̈ tzet chu ispotxꞌni ebnaj Comam Jesús; yaj yin̈ ewantajil, yuto chixiw ebnaj tet anma. ");
INSERT INTO jacNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yayto naj matzwalil yul yanma naj Judas, chihallaxpaxo Iscariote, naj ayco istzꞌajo ebnaj cablahon̈wan̈ iscuywom Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuxin, to naj iscꞌatan̈ ebnaj yahawil yin̈ ebnaj sacerdote yeb iscꞌatan̈ ebnaj chitan̈en yatut Comam Dios, yu istzotel yin̈ tzet chu yanico naj Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Caw tzalacan̈ ebnaj yaben huneꞌ tuꞌ, yuxinto yalte ebnaj melyu tet naj Judas. ");
INSERT INTO jacNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hac tuꞌ xin yu iswatxꞌencanayo ebnaj istzotiꞌ; yuxinto oc naj Judas issayaꞌ tzet chu yanico naj Comam yul iskꞌab ebnaj yin̈ ewantajil. ");
INSERT INTO jacNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hayet yayilo istzꞌayical bay chiwahlax ixim pan machi yan̈al chialaxicoj, yeb yet chipotxꞌlax noꞌ meꞌ xahanbalil yin̈ kꞌin̈ Pascua, ");
INSERT INTO jacNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yalni Comam Jesús tet naj Pedro yeb naj Juan: —Asiwe hewatxꞌeꞌ tzet chicolo yin̈ kꞌin̈ Pascua tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iskꞌamben ebnaj tet Comam: —¿Baytuꞌwal chawoche chon̈tohan̈ cowatxꞌeꞌan̈ hawalni? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yalni Comam tet ebnaj xin: —Hayet chexapno bey yul con̈ob tuꞌ, cheyilaꞌ huneꞌ naj ikꞌbil huneꞌ tzꞌajab haꞌ yu. Chexocowe tzujno yinta naj masanto yul n̈a bay chiocto naj, ");
INSERT INTO jacNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","cat heyalno tet naj yahaw n̈a tuꞌ: “Haꞌ yaꞌ cuywawom macon̈chejnitijan̈, ẍi yaꞌ hacaꞌ tiꞌ: ‘¿Baytuꞌwal ay huneꞌ cuarto bay chinwaꞌojan yin̈ kꞌin̈ Pascua yeb ebnaj incuywoman?’” ẍi yaꞌ, quexchi. ");
INSERT INTO jacNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Haꞌ naj chiyeno huneꞌ niman cuarto yin̈ iscab piso cꞌulxa yehi. Haꞌ bey tuꞌ xin chewatxꞌeꞌ tzet chicolo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hac tuꞌ xin yu isto ebnaj. Yilcha yu ebnaj hacaꞌticꞌa yu yalni Comam. Yoc ebnaj iswatxꞌeno tzet chilolax yin̈ kꞌin̈ Pascua. ");
INSERT INTO jacNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hayet yapni yorahil, yoc Comam yeb ebnaj ischejab sat meẍa. ");
INSERT INTO jacNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yalni Comam tet ebnaj: —Hayeltaxam chiwochehan chiwecꞌtzehan huneꞌ wah yin̈ kꞌin̈ Pascua tiꞌ yeb hex yet yalan̈to maẍto chincaman. ");
INSERT INTO jacNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chiwalan teyet, matxa chiwecꞌtzehan huneꞌ kꞌin̈ tiꞌ masanto chij isba tzet yelapno ye huneꞌ tiꞌ yet chꞌoc sunil yalan̈ yip Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lahwi tuꞌ xin, yinican̈ Comam chꞌen copa, bay ayayto yal teꞌ uva, yakꞌni yuchꞌandiosal tet Comam Dios, yalni Comam hacaꞌ tiꞌ: —Chahwej lah, ucꞌwej, awecꞌo teyin̈ hununex. ");
INSERT INTO jacNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Caw chiwalcanojan teyet, matxa chiwucꞌan yal sat teꞌ uva masanto yet chꞌoc sunil yalan̈ yip Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lahwi tuꞌ xin, yinican̈ Comam ixim pan, yakꞌni Comam yuchꞌandiosal tet Comam Dios, iskꞌaxpon Comam ixim, yakꞌni Comam ixim tet ebnaj, yalni Comam: —Haꞌ huneꞌ tiꞌ yechel innimanilan chiwakꞌan yin̈ camical yu hecolchahi. Wawej, yu quinhenanitijan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lahwi iswaꞌilo Comam yeb ebnaj yinipaxocan̈ Comam chꞌen copa, yalni Comam: —Haꞌ huneꞌ ayayto yul copa tiꞌ haꞌ chakꞌni henab yin̈ huneꞌ acꞌ trato akꞌbil yu Comam Dios, chij isba yet chimalto inchiqꞌuilan yu hecolchahi, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yajaꞌ naj chinanicojan yul iskꞌab ebnaj chichiwa iscꞌul win̈an, ayco naj sat meẍa coxol tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hanin Akꞌbilintijan texol yu Comam Dios, yilal wecꞌan yin̈ camical hacaꞌ halbil yu Comam Dios, yajaꞌ cꞌanchꞌan naj chinanicojan yul iskꞌab camical, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hayet yaben ebnaj huneꞌ tuꞌ, yichico ebnaj iskꞌamben tet hunun yin̈ mac chꞌanico Comam yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lahwi tuꞌ xin, yichico ebnaj iscuywom iscajlen isba yin̈ mac ecꞌbal yelapno ye xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yalni Comam Jesús tet ebnaj: —Haꞌ ebnaj ayco yahawo txꞌotxꞌ nime con̈ob ay yip ebnaj yiban̈ anma. Ebnaj ayco yahawilal tuꞌ xin chihallax cꞌulal yin̈ ebnaj yu anma. ");
INSERT INTO jacNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wal xin mach haco tuꞌ cheyute heba. Ta ay hunujex caw ay heyelapno cheyabe, iweyo heba hacaꞌ huno mac mach yelapno yehi. Yebpaxo haꞌ mac caw iswiꞌehal yeco texol chabe yakꞌabico isba hacaꞌ hunu chejab. ");
INSERT INTO jacNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kꞌinalo ta ay huneꞌ niman wah chioqui, ¿mactaxca caw niman yelapno ye heyalni? ¿Tom haꞌ naj ayco sat meẍa, mato haꞌ naj chibatxnicꞌo itah? Wal xin, haꞌ ton naj ayco sat meẍa caw niman yelapnoj. Yajaꞌ walinan, ayinicojan texol hacaꞌ naj chibatxnicꞌo itah. ");
INSERT INTO jacNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Hex tiꞌ, caw ayexn̈eticꞌaco yet yul isyaꞌtajil wiban̈an. ");
INSERT INTO jacNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chexwacojan yahawiloj, hacaꞌ wocan yahawilo yu Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hex tiꞌ, chexwaꞌ sat inmeẍahan bay chinocan Yahawiloj, cat heyay tzꞌon̈no yul hecapil hununex, cat heyoc yahawil yiban̈ cablahon̈eb majan ebnaj Israel, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yalni Comam Jesús tet naj Pedro: —Simón, Simón xaiskꞌan naj matzwalil tet Comam Dios ta chexyilwe naj hacaꞌ chu istxayelax ixim trigo. ");
INSERT INTO jacNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yaj xaꞌinkꞌanan tet Comam Dios haxinwal mach chabej iscawxi hawanma yin̈ Comam. Yajaꞌ yet chawanico hawanma win̈an hunelxa, chawiptze sunil ebnaj hawuẍta xayaco yanma win̈an, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yalni naj Pedro tuꞌ tet Comam: —Mamin, caw hinaninan intohan tawintaj, waxan̈ca yul preso maca yin̈ camical, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yalni Comam Jesús tet naj xin: —Pedro, chiwalan tawet, yalan̈to maẍto chiꞌokꞌ noꞌ icham chiyo, oxelxa chawala ta mach quinhawohtajojan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iskꞌamben Comam Jesús tet ebnaj iscuywom: —Yet quexinchejnitojan yet walnihan teyet ta mach cheyito hetzꞌispa yeb hemelyu, yeb hexan̈ab, ¿aymi tzet mach yabe yul hekꞌab? ẍi Comam. Istakꞌwi ebnaj: —Matzet, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yalnipaxo Comam tet ebnaj: —Wal tinan̈ xin, maquex ay hetzꞌispa yeb hemelyu, iwetoj. Haꞌ mac mach yespada, istxon̈abto ischumpa cat islokꞌni yet. ");
INSERT INTO jacNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yuxinto chiwalan teyet, yilal yijnicano isba sunil tzet tzꞌibn̈ebilcano win̈an yu ebnaj ischejab Comam bay chala: “Hacaꞌ chꞌutelax ebnaj caw xiwquilta ismul, hac tuꞌ chꞌutelaxo naj,” ẍiayoj. Yuxinto yilal yijni isba sunil, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yalni ebnaj tet Comam: —Mamin, ay cabeb chꞌen espada ikꞌbil juan̈ lah, ẍi ebnaj. Yalni Comam: —Cꞌuxanxa xin, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lahwi tuꞌ, yelti Comam Jesús yul n̈a, isto bey huneꞌ won̈an Olivo isbi, bayticꞌa chibeycꞌo Comam. Istopaxo ebnaj iscuywom Comam yintaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hayet yapni Comam bey tuꞌ, yalni Comam tet ebnaj: —Txahlan̈wej, haxinwal mach chexaycꞌay yul iskꞌab istxꞌojal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lahwi tuꞌ xin, yel Comam iscꞌatan̈ ebnaj hacaꞌmi xol bay chꞌapni hunu chꞌen chꞌen chikꞌojlaxtoj. Haꞌ tuꞌ xin, ay jahno Comam txahloj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yalni Comam yin̈ istxah: Mamin, ta choche hacꞌul, colinnilojan yin̈ huneꞌ isyaꞌtajil chul wiban̈tiꞌan, yaj machojab hacaꞌ chiwochehan, to hacaꞌojab tzet chal hacꞌul, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lahwi tuꞌ xin, yayilo huneꞌ naj yángel Comam Dios yul satcan̈, yakꞌno yip yanma Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Caw occano niman isyaꞌil yin̈ yanma Comam, yuxin caw islahico Comam istxahli yin̈ sunil yanma. Caw xin chꞌel haꞌ yin̈ Comam hacaꞌ nimeta tuꞌan chicꞌ yaycꞌay sat txꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yet islahwi istxahli Comam, isto bay cancano ebnaj iscuywom. Hayet yapni Comam iscꞌatan̈ ebnaj, caw wayan̈ chu ebnaj yu biscꞌulal. ");
INSERT INTO jacNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yalni Comam tet ebnaj: —¿Tzet yin̈ xin chexwayi? Ahan̈wewanoj, txahlan̈wej haxinwal mach chexaycꞌay yul iskꞌab istxꞌojal, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lan̈anto yalni Comam Jesús huneꞌ tuꞌ yapni hun bulan ebnaj; babelico naj Judas sata ebnaj, naj ayco istzꞌajo ebnaj cablahon̈wan̈ ischejab Comam. Ishitzico naj Judas tuꞌ iscꞌatan̈ Comam yun̈e istzꞌohni naj iskꞌotx Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yalni Comam tet naj: —Judas, yet chatzꞌohnilo inkꞌotxtiꞌan, ¿tom hac tuꞌ chu quinhawanicojan yul iskꞌab camical? Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hayet yilni ebnaj iscuywom Comam Jesús tzet lan̈an yul yiban̈ Comam, iskꞌamben ebnaj: —Mamin, ¿chimisje jakꞌnihan̈ chꞌen espada yin̈ ebnaj tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ay xin huneꞌ naj xol ebnaj iscuywom Comam tuꞌ, pitnilto istxiquin huneꞌ naj ischejab naj yahawil yin̈ ebnaj sacerdote, huneꞌ istxiquin naj yin̈ iswatxꞌkꞌab. ");
INSERT INTO jacNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yalni Comam Jesús: —¡Bejwej! Mach cheyute hacaꞌ tuꞌ. Istzabnico Comam istxiquin naj, iswatxꞌiloj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Haꞌ ebnaj beycꞌo tzabnoti Comam, haꞌ ton ebnaj yahawil yin̈ ebnaj sacerdote, yeb ebnaj yahawil yilomal yatut Comam Dios, yeb ebnaj ichamta winaj iswiꞌehal con̈ob; yalni Comam tet ebnaj: —¿Tom elkꞌominan teyet yuxin ikꞌbil heyespada yeb heteꞌ, cat heyul quinhetzabnotojan? ");
INSERT INTO jacNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hunun tzꞌayic ayinicꞌtojan yul yatut Comam Dios, yajaꞌ mach quinhetzabayojan. Yaj wal tinan̈ maꞌapni yorahil quinisbejtzonicojan Comam Dios yul hekꞌab yeb tet naj yahawil kꞌejholo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lahwi tuꞌ xin, istzabnayo ebnaj Comam, yilaxto Comam bey yatut naj yahaw yin̈ ebnaj sacerdote. Wal naj Pedro xin, nahat tzujan naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yanico xin ebnaj tuꞌ iskꞌaꞌ yictabal yamakꞌil teꞌ n̈a, yoc tzꞌon̈no ebnaj kꞌaẍnoj. Ocpaxo tzꞌon̈no naj Pedro kꞌaẍno xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ay xin huneꞌ ix munlawom bey tuꞌ, ilni naj Pedro yet tzꞌon̈anico naj yin̈ kꞌaꞌ. Yoc tꞌan̈no ix yin̈ naj, yalni ix: —Huneꞌ naj tiꞌ, yetbi isba naj yeb naj Jesús, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hayet yaben naj Pedro huneꞌ tuꞌ, yalni naj: —Mach wohtajojan naj chawal tuꞌ, ẍi naj tet ix. ");
INSERT INTO jacNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hunepixto xin, yillax naj Pedro yu huneꞌ naj, yalni naj tet naj: —Hach tiꞌ hawetbi haba yeb ebnaj tuꞌ, ẍi naj. Istakꞌwi naj Pedro: —Machoj, mach wetbiho inbahan yeb ebnaj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ayxam hunu orahil xin, ischilban yalni huneꞌxa naj yin̈ naj Pedro tuꞌ: —Yin̈ caw yeli, haꞌ naj tiꞌ yetbi isba naj yeb naj Jesús tiꞌ, yebpaxo ah Galilea naj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yalni naj Pedro: —Mach wohtajan huneꞌ tzet chawal tiꞌ, ẍi naj. Yet lan̈an yalni naj Pedro huneꞌ tuꞌ xin, yokꞌcan̈ huneꞌ noꞌ icham chiyo. ");
INSERT INTO jacNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Istꞌan̈xito Comam yin̈ naj Pedro tuꞌ. Hac tuꞌ xin yu isnaniti naj Pedro tzet yal Comam tet naj: “Oxelxa chawala ta mach quinhawohtajojan yet chiꞌokꞌcan̈ noꞌ icham chiyo,” ẍi Comam Jesús tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hac tuꞌ xin yu yelto naj, yoc naj okꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wal ebnaj ayco tan̈eno Comam Jesús tuꞌ, oc ebnaj tzebo yin̈ Comam, ismakꞌnipaxo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yoc ebnaj ismajcheno sat Comam, chi-la-iskꞌamben ebnaj tet Comam: —Halilo mac macachmakꞌni, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hantato buchwal tzotiꞌ yal ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hayet issajbilo xin, iscutxbanico isba ebnaj ichamta winaj yin̈ con̈ob Israel, yeb ebnaj yahawil yin̈ ebnaj sacerdote, yeb ebnaj chicuywa yin̈ isley naj Moisés; ischejni ebnaj ilaxoti Comam Jesús sataj. Iskꞌamben ebnaj tet Comam: ");
INSERT INTO jacNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Hal jetan̈, ¿tom yeli hach tiꞌ Cristo hach? ẍi ebnaj. Istakꞌwican̈ Comam: —Ta chiwalan teyet ta Haninan Cristo hinan, mach cheyakꞌayto yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Taca ay tzet chinkꞌambepaxojan teyet, mach chepajtzepaxo wetan. ");
INSERT INTO jacNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yaj wal tinan̈ Hanin Akꞌbilintijan texol yu Comam Dios chinoctzꞌon̈nojan yin̈ iswatxꞌkꞌab Comam Dios; Comam caw aycano yip, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yuxinto sunil ebnaj oc kꞌambeno tet Comam: —¿Tom Iscꞌahol Comam Dios hawe chal tuꞌ? ẍi ebnaj. Istakꞌwi Comam Jesús: —Hoꞌ, Iscꞌahol Comam Dios wehan hacaꞌ cheyute heyalni tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yalni ebnaj: —Tinan̈ matxa yilalo chicokꞌan anma chihalni ismul naj tiꞌ, to han̈-caw-on̈ majabe tzet chal naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sunil ebnaj ah wejnahi, yinito ebnaj Comam Jesús sata naj Pilato. ");
INSERT INTO jacNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yoc ebnaj akꞌocꞌule yin̈ Comam tet naj Pilato hacaꞌ tiꞌ: —Machalo huneꞌ naj tiꞌ juan̈, sunil anma chisomchato isnabal yu naj, cat iscachni naj anma ta mach chakꞌ istohlabal tet naj César, naj jahaw ay bey Roma, cat yalnipaxo isba naj Cristohal, haꞌ chalilo jahawil, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iskꞌamben naj Pilato tet Comam: —¿Tom yahawil anma Israel hawehi? ẍi naj. Istakꞌwi Comam: —Hoꞌ, yeli hacaꞌ hawalni tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yuxinto yal naj Pilato tet ebnaj yahawil yeco yin̈ ebnaj sacerdote, yeb tet sunil anma cutxanico tuꞌ: —Haꞌ huneꞌ winaj tiꞌ, machi hunu mule chiꞌilchalo yin̈ wuhan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ischilban ebnaj, yalni yin̈ caw ip: —Lan̈an issomchato isnabal sunil anma yu cuybanile chakꞌ naj. Ichiti naj iscuyni anma bey Galilea, tinan̈ xin hac tuꞌ chutepaxo naj bey Judea tiꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hayet yaben naj Pilato huneꞌ tuꞌ, iskꞌamben naj ta ah Galilea Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hayet yaben naj ta ah Galilea Comam, yanito naj Comam yul iskꞌab naj Herodes, yuto naj Herodes tuꞌ ayco yahawilo bey Galilea. Cꞌuxan xin aycꞌo naj Herodes bey Jerusalén yet yuni huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hayet yilni naj Herodes Comam, caw tzalacan̈ naj yuto payxa ichi yochen naj yilaꞌ Comam. Caw xin txꞌiꞌalxa bay chabe naj yin̈ Comam. Caw xin choche naj yilaꞌ iswatxꞌen Comam hunu cꞌaybalcꞌule. ");
INSERT INTO jacNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Caw txꞌiꞌal tzet iskꞌambe naj tet Comam, yajaꞌ maẍticꞌa takꞌwi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wal ebnaj iswiꞌehal yin̈ ebnaj sacerdote yeb ebnaj chicuyni anma yin̈ isley naj Moisés, caw ischilba ebnaj yoc akꞌocꞌule yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Naj Herodes yeb ebnaj issoldado tuꞌ oc ebnaj isbuchuꞌ Comam. Yanico ebnaj huneꞌ xilkꞌape yin̈ Comam hacaꞌ chaco ebnaj rey yun̈e yoc ebnaj tzebo yin̈ Comam. Lahwi tuꞌ xin, yanipaxto naj Herodes tuꞌ Comam yul iskꞌab naj Pilato hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yin̈ticꞌa huneꞌ tzꞌayical tuꞌ, naj Pilato yeb naj Herodes oc ebnaj amigohal, yaj wal yet yalan̈to caw ayleco ishowal ebnaj yin̈ hunun. ");
INSERT INTO jacNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iscutxbanico naj Pilato ebnaj iswiꞌehal yin̈ ebnaj sacerdote, yeb ebnaj yahaw con̈ob, yebpaxo sunil anma yul con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yalni naj tet ebnaj: —Haꞌ huneꞌ naj maxeyiti wettiꞌan cheyala ta lan̈an issomchancan̈ naj isnabal sunil anma. Wal xin tesata mankꞌambehan tet naj, yajaꞌ caw machi hunu ismul naj chiꞌilchalo wuhan hacaꞌ cheyute heyalni tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mawatojan naj yul iskꞌab naj Herodes, yajaꞌ mach ismul naj mailcha yu naj, yuxin mayapaxti naj Herodes tuꞌ naj hunelxa wetan. Wal xin, mach ismul naj chꞌakꞌni camoj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ton̈e xin chiwakꞌ hatelaxojan naj, cat inbejtzonan naj, ẍi naj Pilato tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","yuto yin̈ hunun kꞌin̈ Pascua chibejtzolax hunun ebnaj presowom. ");
INSERT INTO jacNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Yaj sunil anma cutxanico bey tuꞌ, ah yaw yin̈ caw ip: —¡Ilo huneꞌ naj tiꞌ yin̈ cosatan̈, cat hebejtzon naj Barrabás! ẍixan̈e anma. ");
INSERT INTO jacNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yaj naj Barrabás tuꞌ, ayco naj preso yu huneꞌ howal yicheco naj yul con̈ob tuꞌ, yebpaxo potxꞌom anma naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wal naj Pilato, caw yoche naj isbejtzoꞌ Comam Jesús, yuxinto tzotelilti naj xol anma hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yajaꞌ anma tuꞌ, caw ecꞌbalto ah yaw, yalni hacaꞌ tiꞌ: —¡Camojab naj yin̈ culus! ¡Camojab naj yin̈ culus! ẍixan̈e anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yalni naj Pilato yin̈ yoxel tet ebnaj: —¿Tzet yu? ¿Tzet istxꞌojal iswatxꞌe naj heyalni? Mach hunu ismul naj chiꞌilchalo yin̈ wuhan chꞌakꞌni camoj. Wal xin ton̈e chinchejan hatelaxo naj, cat inbejtzonan naj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ischilban ebnaj yel yaw yin̈ caw ip, iskꞌanni camo ebnaj Comam yin̈ teꞌ culus. Yu caw chꞌel yaw ebnaj yuxinto akꞌlax tzet choche ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yuxinto isyije naj Pilato tzet iskꞌan ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wal xin, haꞌ naj ayco preso yu howal yeb yu potxꞌwal, haꞌ naj isbejtzoto naj Pilato hacaꞌ yu iskꞌanni ebnaj. Yanico naj Pilato Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yet lan̈an yilaxto Comam Jesús bay chꞌalaxcan̈ yin̈ culus, istzabnayo ebnaj huneꞌ naj, Simón isbi. Lan̈an yocto naj yul con̈ob tuꞌ, haꞌ bey txꞌotxꞌ Cirene ay naj. Yalaxico isculus Comam yiban̈ naj, yoc tzujno naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Caw hantan̈e anma oc tzujno yinta Comam; xol anma tuꞌ ay huntekꞌan ebix caw chꞌokꞌ yu biscꞌulal yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Istꞌan̈xiti Comam yin̈ ebix, yalni Comam tet ebix: —Hex ix ah Jerusalén tiꞌ, mach chexokꞌ win̈an. Okꞌan̈we teyin̈ yeb yin̈ niẍtej heyunin. ");
INSERT INTO jacNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yuto chihul istzꞌayical bay chihallax hacaꞌ tiꞌ: “Sakꞌal yet ebix ix maẍticꞌa yunin, yeb ebix maẍticꞌa unin chitxutxwi yin̈,” ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yet huneꞌ tiempohal tuꞌ, chal anma hacaꞌ tiꞌ: “Majaltam chititcꞌay witz tiꞌ jiban̈, cat comujicano yalan̈,” ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta hanintiꞌan, lahaninan hacaꞌ hunu teꞌ kꞌepta caw yax, yaj chꞌecꞌyaꞌ wanmahan yu anma, hajxamex hex tiꞌ, lahanex yeb teꞌ tajin teꞌ caw niman isyaꞌtajil cheyila, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aypaxo cawan̈xa ebnaj caw xiwquilta ismul, ilaxto camo yin̈ culus yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hayet yapni ebnaj bey huneꞌ txꞌotxꞌ chij Calavera, chalilo Isbajil Wiꞌe, yalaxcan̈ Comam yin̈ culus. Hac tuꞌ utelax cawan̈ ebnaj xiwquilta ismul tuꞌ, huneꞌ naj ah yin̈ iswatxꞌkꞌab Comam, hunxa naj yin̈ ismeckꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hayet aycan̈ Comam yin̈ culus tuꞌ, yalni hacaꞌ tiꞌ: —Mamin, akꞌ nimancꞌulal yin̈ anma tiꞌ, yuto mach chinachalo yu ta txꞌoj tzet chiswatxꞌe, ẍi Comam. Yoc ebnaj soldado yilweno isba yin̈ mac chiinito xil iskꞌap Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sunil anma tuꞌ tꞌan̈anico yilni tzet chuhi; yoc ebnaj yahaw con̈ob buchwal yin̈ Comam, yalni ebnaj: —Ta haꞌ naj tiꞌ Cristo sicꞌbililo yu Comam Dios, iscolabayti isba naj, hacaꞌ yu iscolwa naj yin̈ anma, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hacpax tuꞌ ebnaj soldado, oc ebnaj buchwal yin̈ Comam, yakꞌni ebnaj pahla vinagre yucꞌuꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yalni ebnaj: —Ta yeli yahaw anma Israel hawehi, colayti haba, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yin̈ iswiꞌ isculus Comam tzꞌibn̈ebilico hayeb tzꞌib, chalni hacaꞌ tiꞌ: “Haꞌ naj tiꞌ, yahawil anma Israel,” ẍicoj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Xol ebnaj cawan̈ alaxcan̈ yin̈ culus yinta Comam, ay huneꞌ naj txꞌoj istzotel tet Comam, yalni naj tet Comam: —Ta hach tiꞌ Cristo hach, colayto haba, cat con̈hacolnipaxaytojan̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Haxa huneꞌxa yetbi naj cachwa yin̈ hacaꞌ tiꞌ: ¿Tom mach chaxiw tet Comam Dios? ¿Tom mach chawila tato lahan jeco yin̈ isyaꞌtajil yeb yaꞌ? ");
INSERT INTO jacNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wal han̈on̈ tiꞌ, lan̈an yecꞌyaꞌ janma yu cotohlan istxꞌojal cowatxꞌe, wal yaꞌ tiꞌ, machi nino istxꞌojal iswatxꞌe yaꞌ, ẍi naj tet yetbi tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yalni naj tet Comam: —Mam Jesús, chinhanabaꞌtijan yet chaẍhul cat hawoc yahawil, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yalni Comam tet naj: —Yin̈ caw isyelal chiwalan tawet, haꞌticꞌa tinan̈ chaẍapno incꞌatan̈an bey huneꞌ ehobal chij Paraíso, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yet chuman xin iskꞌejholilo yul yiban̈kꞌinal tiꞌ masanto yin̈ chꞌen oxeb yin̈ kꞌejbiyal issajbipaxiloj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Istzilmopaxayo huneꞌ kꞌap kꞌap aycan̈ yul yatut Comam Dios, cab ayico kꞌap. ");
INSERT INTO jacNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yah yaw Comam yin̈ caw ip, yalni: —Mam, yul hakꞌab chiwacanicojan wanmatiꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hayet yilni naj yahawil ebnaj soldado ah Roma huneꞌ tuꞌ, yoc naj yalno cꞌulla tzotiꞌ yin̈ Comam Dios, yalni naj: —Yin̈ caw yeli, huneꞌ winaj tiꞌ mach ismul, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sunil anma cutxanico bey tuꞌ, hayet yilni tzet yuhi, cawtoxan̈e chistin̈ anma istxam iscꞌul yu biscꞌulal yet ispaxto yatut. ");
INSERT INTO jacNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wal sunil anma yohta isba yeb Comam Jesús, yeb huntekꞌan ebix tit yinta Comam bey Galilea, nahat lin̈anti yilni tzet chuhi. ");
INSERT INTO jacNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ay huneꞌ naj José isbi, ay bey con̈ob Arimatea, yul ismajul Judea; naj tuꞌ, caw cꞌul iscꞌul naj, caw cꞌulpaxo isbeybal naj. Ayco naj xol ebnaj iswiꞌehal yin̈ lahtiꞌ yul con̈ob Israel. ");
INSERT INTO jacNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yajaꞌ mach yaco isba naj yin̈ istxꞌojal iswatxꞌe ebnaj yetbi tuꞌ yin̈ Comam Jesús, yuto chechma naj yoc Comam Dios Yahawiloj. ");
INSERT INTO jacNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Isto naj José tuꞌ iskꞌanno isnimanil Comam tet naj Pilato. ");
INSERT INTO jacNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Lahwi tuꞌ xin, isto naj yinoyti isnimanil Comam yin̈ teꞌ culus, ispichnico naj huneꞌ sábana caw cꞌul yin̈. Isto naj yanocto isnimanil Comam yul huneꞌ chꞌen chꞌen holbil yul, caw xin maẍto hunu camom chiꞌalaxicto yul chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Haꞌ yin̈ huneꞌ tzꞌayical tuꞌ chiskꞌuy isba anma Israel yin̈ tzet chislo yin̈ tzꞌayic xewilal. Lan̈anxa xin isto tzꞌayic cat yichico tzꞌayic xewilal. ");
INSERT INTO jacNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Haꞌ ebix ix tit yinta Comam bey Galilea, topaxo ebix mujwal yin̈ Comam, yilni ebix chꞌen chꞌen bay alaxicto Comam, yilnipaxo ebix tzet yucanicto isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lahwi ispaxto ebix, iswatxꞌen ebix cab majan an̈ caw xukꞌ sam chꞌoc yin̈ isnimanil Comam. Lahwi tuꞌ xin yichico tzꞌayic xewilal, yuxin xew ebix hacaꞌticꞌa yalni isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yet babel tzꞌayic yin̈ semana caw sahab to ebix bay alaxicto isnimanil Comam, ikꞌbil huntekꞌan an̈ caw xukꞌ sam watxꞌebil yu ebix. ");
INSERT INTO jacNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hayet yapni ebix bey tuꞌ, yilni ebix ta elnaxa chꞌen chꞌen ayco ismajilo bay alaxicto isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yocto ebix yul chꞌen, yilni ebix ta matxa isnimanil Comam ayictoj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Caw cꞌayilo iscꞌul ebix yu huneꞌ tuꞌ. Haxa yet yilniti ebix xin lin̈anxacan̈ cawan̈ ebnaj yángel Comam Dios, toxan̈e chitzejtzon xil iskꞌap ebnaj ayco yin̈. ");
INSERT INTO jacNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Caw xiwcan̈ ebix, yay xulno ebix sat txꞌotxꞌ, yalni ebnaj tet ebix: —¿Tzet yin̈ yuxin haꞌ bay chimujlax camom chesayicꞌo huneꞌ mac itzitzxa? ");
INSERT INTO jacNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Matxa Comam ayicti bey tiꞌ, to xaitzitzbican̈. Naweti tzet yal teyet yet aycꞌo bey Galilea, ");
INSERT INTO jacNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","yet yalni hacaꞌ tiꞌ: “Hanin Akꞌbilintijan texol yu Comam Dios, caw yilal walaxicojan yul iskꞌab ebnaj txꞌoj, cat walaxcan̈an yin̈ culus, yajaꞌ yin̈ yox tzꞌayic cat witzitzbican̈an,” ẍi Comam, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hac tuꞌ xin yu isnaniti ebix tzet yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Isto ebix yalno tzet yabe tuꞌ tet ebnaj hunlahon̈wan̈ ischejab Comam, yeb tet huntekꞌanxa ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haꞌ huntekꞌan ebix bey halno tuꞌ, haꞌ ton ix María ah Magdala, ix Juana, yeb ix María, ismiꞌ naj Jacobo, yeb huntekꞌanxa ebix. ");
INSERT INTO jacNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wal ebnaj ischejab Comam tuꞌ, ton̈em chal ebix, yalni ebnaj; yuxin maẍticꞌa yayto ebnaj yul yanma yin̈ tzet chal ebix. ");
INSERT INTO jacNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wal naj Pedro xin, to naj yin̈ an̈e yilaꞌ bay alaxicto isnimanil Comam tuꞌ. Hayet yaycꞌon̈no naj yilnicto naj, haꞌxan̈e kꞌap sábana aycanayoj. Caw cꞌaycan̈ iscꞌul naj, ispaxto naj bay aya. ");
INSERT INTO jacNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Haꞌticꞌa yin̈ huneꞌ tzꞌayical tuꞌ, ay cawan̈ ebnaj iscuywom Comam Jesús, to bey huneꞌ aldea Emaús. Aymi oxebo legua yelo yin̈ con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yet ayco ebnaj yin̈ isbel tuꞌ, chitzotel ebnaj yin̈ tzet yakꞌle Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hayet lan̈an istzotel ebnaj yin̈ huneꞌ tuꞌ, yapni Comam iscꞌatan̈ ebnaj, hunxa xin yu isto Comam yeb ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Waxan̈ca yil ebnaj yin̈ Comam, yaj ay huneꞌ tzet machi chahni yohtan̈elo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iskꞌamben Comam tet ebnaj: —¿Tzet tzotiꞌal ayco heyu yul beh tiꞌ? ẍi Comam. Caw xin biscꞌulal jilni sat ebnaj, ");
INSERT INTO jacNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","istakꞌwi huneꞌ naj chiyij Cleofas: —Sunil anma ohtan̈e tzet yu yul con̈ob Jerusalén yin̈ huntekꞌan tzꞌayic tiꞌ. ¿Tom hach xan̈e yul con̈ob tiꞌ mach hawohtajoj? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iskꞌamben Comam tet ebnaj: —¿Tzet huneꞌ yu tuꞌ? ẍi Comam. Yalni ebnaj: —Ay huneꞌ yaꞌ Jesús, ah Nazaret, ischejab Comam Dios, haꞌ tzet iswatxꞌe yeb tzet yala caw niman yelapno yul sat Comam Dios yeb yul sat anma. ");
INSERT INTO jacNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yaj haꞌ ebnaj yahaw yin̈ ebnaj sacerdote, yeb ebnaj iswiꞌehal con̈ob, haꞌ ebnaj anico yaꞌ yul iskꞌab camical, yalaxcan̈ yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Haꞌ yaꞌ ayco yipo janmahan̈ yoc colnolo con̈ob Israel tiꞌ yul iskꞌab ebnaj romano. Yaj tinan̈ oxebxa tzꞌayic yuni huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ay xin huntekꞌan ebix jetbi cobahan̈ yebi caw sahab mabeycꞌo bay alaxicto isnimanil yaꞌ. Caw macꞌayilo cocꞌulan̈ yu tzet mayal ebix. ");
INSERT INTO jacNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yuto hayet maapni ebix, matxa isnimanil yaꞌ ayictoj. Yuxin hayet mameltzo ebix, mayalni ebix jetan̈ ta mayil ebix huntekꞌan ebnaj ángel, mayalni ebnaj ta itzitz yaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ay xin huntekꞌan ebnaj jetbihan̈ mabey ilno bay alaxicto isnimanil yaꞌ. Caw xin matxa isnimanil yaꞌ ayicto hacaꞌticꞌa mayu yalni ebix jetan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yalni Comam Jesús tet ebnaj: —Caw yaꞌta istxumchalo heyu yeb caw lan̈o cheyayto yul heyanma yin̈ tzet halbilcano yu ebnaj ischejab Comam Dios yet payat. ");
INSERT INTO jacNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tom mach heyohtajo ta naj Cristo yilal yecꞌyaꞌ yanma hacaꞌ mayu tuꞌ, lahwi tuꞌ cat yoc naj Yahawil? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yoc Comam yalno yin̈ caw haban yin̈ sunil tzet tzꞌibn̈ebilcanayo yin̈ Comam Cristo yul Yum Comam Dios. Ichico bay tzꞌibn̈ebilcano yu naj Moisés, masanta apni yin̈ sunil tzet tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat. ");
INSERT INTO jacNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hayet lan̈an yapni ebnaj yul aldea tuꞌ, isyenilo Comam ta palan̈ istohi. ");
INSERT INTO jacNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yajaꞌ mach ischato ebnaj Comam. Yalni ebnaj: —Canan̈cano cocꞌatan̈an̈, yuto caw kꞌejbixa lah, ẍi ebnaj. Hac tuꞌ xin yu iscan Comam iscꞌatan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hayet ayxaco Comam sat meẍa yeb ebnaj, yinican̈ Comam ixim pan. Lahwi yakꞌni Comam yuchꞌandios tet Comam Dios, iskꞌaxponayo ixim, yakꞌni Comam ixim tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yin̈ haꞌmataj tuꞌ xin, hacaꞌtan̈e hajcha sat ebnaj, isnachalo Comam Jesús yu ebnaj. Wal Comam xin, cꞌaycan̈ Comam yin̈ sat ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yalni ebnaj tet hunun: —¡Toꞌan yuxin caw matzalacan̈ janma yet macon̈iscuyni Comam yin̈ Istzotiꞌ Comam Dios yul beh! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lahwin̈ena tuꞌ xin, ismeltzoto ebnaj bey Jerusalén, isto ebnaj bay cutxanico ebnaj hunlahon̈wan̈ yeb huntekꞌanxa iscuywom Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yalni ebnaj tet ebnaj cawan̈ tuꞌ: —Yin̈ caw yeli, maitzitzbican̈ Comam, masye isba tet naj Simón Pedro, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yalnipaxo ebnaj cawan̈ tuꞌ yin̈ tzet yu isyenican̈ isba Comam yul beh tet ebnaj, yeb tzet yu yohtan̈enilo ebnaj Comam yet iskꞌaxpon ixim pan. ");
INSERT INTO jacNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hayet lan̈an istzotel ebnaj yin̈ huneꞌ tuꞌ, yilniti ebnaj xin lin̈anxayo Comam Jesús yictabal ebnaj, yalni Comam tet ebnaj: —Ayojab akꞌancꞌulal texol, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Caw xiw ebnaj, iscꞌaycan̈ iscꞌul ebnaj yuto ispixan camommi chil ebnaj yalni. ");
INSERT INTO jacNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yajaꞌ yal Comam tet ebnaj: —¿Tzet yin̈ yuxin chexxiwi yeb chicabcon heyanma? ");
INSERT INTO jacNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilwecꞌanab inkꞌaban yeb wojan bay to chꞌen lawuẍ. ¡Caw hanintonan! Tzabinwecꞌanaban cat heyohtan̈eniloj ta haninan. Wal hacaꞌ hunu ispixan camom, machi ischibehal, machipaxo isbajil hacaꞌ chu quinheyilnitiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hayet yalni Comam huneꞌ tuꞌ isyeni Comam iskꞌab yeb yoj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yajaꞌ yu xatzalahilal yeb yu chicꞌay iscꞌul ebnaj yilni, yuxin machi caw yayto ebnaj yul yanma ta haꞌ Comam. Yuxin iskꞌambe Comam tet ebnaj: —¿Aymi nichꞌano tzet chicolo aycꞌo heyu? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yakꞌni ebnaj kꞌaxep noꞌ txobil cay tet Comam, yeb nichꞌan noꞌ cab. ");
INSERT INTO jacNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ischahnilo Comam noꞌ, iswaꞌ Comam yin̈ sat ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yalni Comam tet ebnaj: —Haꞌ huntekꞌan isyaꞌtajil mawakꞌletiꞌan, haꞌ ton walan teyet yet ayintocꞌojan texol, ta yilal yijni isba hacaꞌ tzet tzꞌibn̈ebilcano win̈an yu naj Moisés, yebpaxo yu ebnaj ischejab Comam Dios yet payat, yebpaxo xin yin̈ Salmos, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hac tuꞌ yu yakꞌni Comam Jesús yohtan̈elo ebnaj yin̈ tzet tzꞌibn̈ebilcanayo yul Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yalnipaxo Comam: —Tzꞌibn̈ebilcanayoj ta yilal yecꞌyaꞌ wanmahan, cat incaman, Hanin Cristo intiꞌan. Lahwi tuꞌ xin, cat witzitzbican̈an yin̈ yox tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Caw xin, yilal yallaxicꞌo Intzotiꞌan babel yul Jerusalén tiꞌ, yebpaxo sunil yul sat yiban̈kꞌinal tiꞌ, ta yilal yanico isba anma yul iskꞌab Comam Dios cat isbejnicano istxꞌojal, haxinwal chꞌakꞌlax nimancꞌulal yin̈ ismul. ");
INSERT INTO jacNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hex tiꞌ, cheyakꞌaco heba heyalnolo huntekꞌan tiꞌ, yuto hex cawex heyilaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tinan̈ xin, wal heye bey Jerusalén tiꞌ masanto chechah yip Espíritu Santo chinchejtijan bey satcan̈; huneꞌ halbilcano yu Inmaman, ẍi Comam tet ebnaj ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lahwi tuꞌ yinito Comam Jesús ebnaj ischejab yul ismajul Betania. Yinican̈ Comam iskꞌab, iskꞌanni Comam iscꞌulal Comam Dios yiban̈ ebnaj ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lan̈antoticꞌa tuꞌ xin, yilaxto Comam satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yoc ebnaj yalno cꞌulla tzotiꞌ yin̈ Comam, ispaxto ebnaj bey Jerusalén yin̈ caw tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hunun tzꞌayic xin iscutxban isba ebnaj yul yatut Comam Dios, chalni ebnaj cꞌulla tzotiꞌ yin̈ Comam Dios. ¡Hacojab tuꞌ!");
INSERT INTO jacNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yet yalan̈tocanoj, yet maẍto hunu tzet watxꞌinaxa, ayxaticꞌa Comam Tzotiꞌ isbi. Haꞌ Comam Tzotiꞌ tuꞌ huneꞌn̈e ye yeb Comam Dios, caw Diospaxo yehi. ");
INSERT INTO jacNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yet caw yichebanil ayxaticꞌa Comam tuꞌ yeb Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yu Comam Tzotiꞌ tuꞌ, yuxin iswatxꞌe Comam Dios Mame sunil tzettaj ay yul sat yiban̈kꞌinal tiꞌ yeb satcan̈. Machi hunu tzet ye tuꞌ watxꞌinaj ta mach yuho Comam Tzotiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yin̈ Comam Tzotiꞌ tuꞌ, chipitzcꞌati kꞌinale, haꞌ ton xin chiakꞌni issajilkꞌinal tet yanma anma. ");
INSERT INTO jacNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Huneꞌ issajilkꞌinal tiꞌ chimujli xol kꞌejholo. Haꞌ kꞌejholo tuꞌ xin, mach chikꞌoji isbutnitan̈oj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ay xin huneꞌ naj ischejab Comam Dios, Juan isbi. ");
INSERT INTO jacNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hulicꞌo naj tzotelo yin̈ huneꞌ issajilkꞌinal tuꞌ yun̈e yanayto sunil anma huneꞌ issajilkꞌinal yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Haꞌ naj Juan tuꞌ xin, maẍtaj naj huneꞌ issajilkꞌinal tuꞌ, caw ton̈e hul naj tzotelo yin̈ issajilkꞌinal. ");
INSERT INTO jacNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wal Comam yin̈ caw yeli issajilkꞌinal tuꞌ, hulicꞌo yul sat yiban̈kꞌinal tiꞌ yu yakꞌni Comam issajilkꞌinal yul yanma sunil anma. ");
INSERT INTO jacNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Waxan̈ca iswatxꞌe Comam Dios sunil yul sat yiban̈kꞌinal tiꞌ yu Comam Tzotiꞌ tuꞌ, yajaꞌ yet yulicꞌoj maẍticꞌa ohtan̈elax Comam yu anma. ");
INSERT INTO jacNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hulicꞌo Comam yul iscon̈ob, yaj machi ischah anma Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yaj wal sunil mac chahni Comam, yanayto yul yanma yin̈ tzet chala, haꞌ ton huntekꞌan tuꞌ yakꞌ Comam yip yoccano yuninalo Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yet chꞌoc yuninalo Comam Dios, mach lahano hacaꞌ chu ispitzcꞌa yuninal anma yul sat yiban̈kꞌinal tiꞌ, yeb mach hacaꞌo chal iscꞌul naj winaj, to hacaꞌ chiel yin̈ iscꞌul Comam Dios, hac tuꞌ chu yoc anma yuninalo Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Comam Tzotiꞌ tuꞌ, yaco isba anmahil. Hulicꞌo coxol isyeni isyelal jet, yebpaxo iscꞌulal iscꞌul Comam Dios. Jilnipaxo iskꞌakꞌal yip Comam ischah tet Ismam. Wal xin han̈cꞌan̈e hunpilan Iscꞌahol Comam Dios tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hacpax tuꞌ naj Juan yal naj yin̈ Comam tuꞌ yin̈ caw ip hacaꞌ tiꞌ: —Haꞌ ton huneꞌ naj tiꞌ walan teyet ta tzujan yul wintajan yeb ta caw ecꞌbal yelapno ye insatajan, yuto ayxaticꞌa naj yet yalan̈to maẍto chinpitzcꞌahan, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Haꞌ Comam chiwaltiꞌan, caw cosunil chicochah iscꞌulal iscꞌul, yaj xin mach huneln̈eho chicochah, chilann̈eticꞌa cochahni. ");
INSERT INTO jacNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yul iskꞌab naj Moisés yakꞌ Comam Dios huneꞌ chejbanile caw how yakꞌni naj jet, haxa Comam Jesucristo xin, hul akꞌno sunil iscꞌulal iscꞌul yeb xin isyelal Comam Dios jet. ");
INSERT INTO jacNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Caw maẍto hunu mac xailni yin̈ Comam Dios, hachcachann̈e hunpilan Iscꞌahol Comam Dios, haꞌ ton Comam Jesucristo ayn̈eticꞌa iscꞌatan̈, haꞌ Comam hul yeno jet tzet ye Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yet hunel xin ebnaj yahawil con̈ob Israel ay bey Jerusalén, ischejto ebnaj huntekꞌan ebnaj sacerdote yeb huntekꞌan ebnaj levita iskꞌambeno tet naj Juan hacaꞌ tiꞌ: —¿Mac hach anmahil hach tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yalnilo naj yin̈ caw isyelal tet ebnaj, matzet yebacano naj, yalni naj hacaꞌ tiꞌ: —Maẍtajinan chiwijan Cristohal, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iskꞌambenpaxo ebnaj hunelxa: —¿Mac hach anmahilach, chal tuꞌ? ¿Tom hach tiꞌ Elías? ẍi ebnaj. —Machoj, maẍtajinan, ẍi naj. —¿Mato hach tiꞌ ischejab Comam Dios echmabil yul juhan̈? ẍi ebnaj tet naj. —Machoj, ẍipaxo naj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iskꞌambenpaxo ebnaj hunelxa: —¿Mac ach anmahil, chal tuꞌ? Halilo jetan̈ yun̈e jinitojan̈ ispaj istzotiꞌ ebnaj chejn̈eon̈tijan̈. ¿Tzet caw chawute hawalni jetan̈ tawin̈? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Istakꞌwi naj Juan tuꞌ xin, yalni naj: —Hanintiꞌan yal naj Isaías, huneꞌ naj ischejab Comam Dios yet payat, yet istzꞌibn̈encano naj: Ay huneꞌ mac chiawi bey txꞌotxꞌ desierto, chalni: “Hacaꞌ chu ishamlax hunu beh, cat istoholban̈elaxi yet chul naj jahaw, hac tuꞌ chu hewatxꞌenico heyanma, yuto chihul Comam Dios Jahawil,” ẍicano naj Isaías tuꞌ, ẍi naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ebnaj chejlaxto tzotelo tet naj Juan yu ebnaj fariseo, ");
INSERT INTO jacNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","iskꞌambe ebnaj tet naj: —¿Tzet yin̈ yuxinto chawacan̈ haꞌ iswiꞌ anma tiꞌ tato maẍtajach tiꞌ Cristo hach? ¿Mach Elíaspaxo hach? ¿Maẍtajachpaxo ischejab Comam Dios echmabil yul juhan̈? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yalni naj Juan tuꞌ tet ebnaj: —Wal hanintiꞌan han̈e ha haꞌ chiwakꞌan yahbalo haꞌ iswiꞌ anma, yaj coxol tiꞌ ayco huneꞌ mac caw maẍto heyohtajoj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tzujan yul naj wintajan, yaj caw ecꞌbal naj insatajan, yuxin mach chu inpuhnilojan istxꞌan̈al isxan̈ab naj chiwabehan, ẍi naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Haꞌ bey huneꞌ txꞌotxꞌ chiyij Betania, iskꞌaxepicꞌto haꞌ niman Jordán, bay yacan̈ naj Juan haꞌ iswiꞌ anma, haꞌ tuꞌ beycꞌo ebnaj iskꞌambeꞌ huntekꞌan tiꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Haxa yet hunxa tzꞌayical xin, yilnito naj Juan tato lan̈an yapni Comam Jesús iscꞌatan̈, yalni naj hacaꞌ tiꞌ: —Ilwecꞌanabi lah, haꞌ huneꞌ mac lan̈an yul tiꞌ, haꞌ akꞌbilti jet yu Comam Dios coxahanbaloj, hacaꞌ chiyu yoc noꞌ meꞌ xahanbalil. Haꞌ naj chiinilo comul jiban̈ cosunil han̈on̈ ayon̈ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Haꞌ ton yin̈ naj tiꞌ quintzotelan yet walnihan teyet: “Ay huneꞌ naj tzujan yul wintajan, caw ecꞌbal yelapno insatajan, yuto ayxaticꞌa naj yet maẍto chinpitzcꞌahan yul sat yiban̈kꞌinal tiꞌ,” quinchiyan teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yet yalan̈tocanoj, caw maẍticꞌa wohtajojan mac Cocolomal, yaj wahcan̈an haꞌ iswiꞌ anma yun̈e yohtan̈elaxilo Comam yu anma Israel tiꞌ, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yalnipaxo naj Juan: —Caw wilan yayilo Comam Espíritu Santo yul satcan̈ yiban̈ naj. Hacaꞌ chiyu yay lalon hunu noꞌ palamuch, hac tuꞌ yu yay yiban̈. ");
INSERT INTO jacNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yet yalan̈tocano tuꞌ, caw maẍto wohtajojan naj, yaj Comam Dios chejn̈eintijan wanocan̈an haꞌ iswiꞌ anma tiꞌ, haꞌ Comam chalni wetan: “Haꞌ huneꞌ mac chawil yay Comam Espíritu Santo yiban̈, haꞌ ton huneꞌ tuꞌ chiakꞌni Comam Espíritu Santo tet anma,” ẍi Comam Dios wetan. ");
INSERT INTO jacNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Caw ilbilxa wuhan, yuxin chiwalicꞌojan tato caw Iscꞌahol Comam Dios ye naj tiꞌ, ẍi naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yet huneꞌxa tzꞌayical xin, aypaxicꞌo naj Juan bey tuꞌ yeb cawan̈xa ebnaj iscuywom iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hayet yilni naj Juan yecꞌto Comam Jesús, yalni naj tet ebnaj cawan̈ tuꞌ: —Ilwecꞌanabi lah, haꞌ naj tuꞌ akꞌbil jet coxahanbalo yu Comam Dios hacaꞌ chiyu yoc noꞌ meꞌ xahanbalil ju, ẍi naj Juan tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hayet yaben ebnaj cawan̈ tuꞌ tzet yal naj Juan, isto ebnaj yinta Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Istꞌan̈xito Comam Jesús yintaj, yilni Comam tato tzujan ebnaj cawan̈ tuꞌ yinta Comam. Iskꞌamben Comam tet ebnaj: —¿Tzet chesaya? ẍi Comam. —Rabí, ¿baytuꞌwal ayach? ẍi ebnaj. (Huneꞌ tzotiꞌ rabí, cuywawom chaliloj.) ");
INSERT INTO jacNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Istakꞌwi Comam xin: —Catawej cat heyilni, ẍi Comam. Hac tuꞌ yu isto ebnaj yilno baytuꞌwal ay Comam. Iscancano ebnaj huneꞌ akꞌbal tuꞌ yuto kꞌejbixa. ");
INSERT INTO jacNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ebnaj cawan̈ aben tzet yal naj Juan occano tzujno ebnaj yinta Comam. Huneꞌ naj Andrés isbi, yuẍta isba naj yeb naj Simón Pedro. ");
INSERT INTO jacNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yet lahwi istzotel naj Andrés tuꞌ yeb Comam Jesús, yin̈ hamataj to naj saywal yin̈ yuẍtaj, yalni naj tet naj: —Caw machahloyo Comam Mesías juhan̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hac tuꞌ xin yu yijbanto naj Andrés tuꞌ naj Simón iscꞌatan̈ Comam Jesús. Yoc tꞌan̈no Comam yin̈ naj Simón tuꞌ, yalni Comam tet naj: —Simón, iscꞌahol naj Jonás, wal tinan̈ Cefas chioccano habihoj, ẍi Comam tet naj. (Yin̈ huneꞌ yabxubal ebnaj tuꞌ, huneꞌ bihe Cefas chal yelapnoj Pedro.) ");
INSERT INTO jacNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yet huneꞌxa tzꞌayic xin yoc yin̈ isnabal Comam Jesús isto bey yulaj ismajul txꞌotxꞌ Galilea. Ischahni isba Comam yeb naj Felipe, yalni Comam tet naj: —Ocan̈ tzujno wintajan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Caw xin yet con̈ob isba naj Felipe tuꞌ yeb naj Andrés yebpaxo naj Simón Pedro; ah con̈ob Betsaida ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lahwi tuꞌ xin, isto naj Felipe saywal yin̈ naj Natanael. Yet ischahlo naj Natanael tuꞌ yu naj, yalni naj tet naj: —Machahlo Comam tzꞌibn̈ebilcanayo yul Hum yet ley akꞌbilcano yu naj Moisés, yeb tzꞌibn̈ebilcano yu huntekꞌanxa ebnaj ischejab Comam Dios yet payat; haꞌ naj Jesús ah Nazaret, iscꞌahol naj José, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yalni naj Natanael tuꞌ: —¿Tom xin ay hunu mac cꞌul chielti xol ebnaj ay bey con̈ob Nazaret tuꞌ? ẍi naj. Istakꞌwi naj Felipe xin: —Ton̈cꞌanab jilaꞌ cat hawilni, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yet yilnito Comam Jesús yapni naj Natanael iscꞌatan̈ tuꞌ xin, yalni Comam: —Haꞌ huneꞌ naj lan̈an yul tiꞌ, caw Israel naj yul sat Comam Dios, caw machi nino lekꞌtiꞌal ayco yin̈ naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iskꞌamben naj Natanael tet Comam: —¿Tzet xin chu quinhawohtan̈enilojan? ẍi naj. Yalni Comam tet naj: —Macachwilan yet maẍto chachyawte naj Felipe tiꞌ, yet ayach yich teꞌ higuera, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Istakꞌwi naj Natanael tuꞌ: —Mam cuywawom, yin̈ caw yeli hach tiꞌ Iscꞌahol Comam Dios, Yahawil con̈ob Israel hawehi, ẍican̈ naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yalnipaxo Comam tet naj: —Chawayto yul hawanma win̈an yuto mawalan ta macachwilan yich teꞌ higuera, wal xin caw ecꞌnato cꞌaybalcꞌule chito hawilaꞌ sata tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yalnipaxo Comam hacaꞌ tiꞌ: —Yin̈ caw isyelal chiwalan teyet, cheyilaꞌ ishajni isba satcan̈, cat heyilni yahtoj yeb yayilo ebnaj yángel Comam Dios wiban̈an Hanin Akꞌbilintijan texol yu Comam Dios, ẍi Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Haxa yet yoxihalxa xin, yoc huneꞌ mohyilal bey yul con̈ob Caná ay yul ismajul Galilea. Ayco ismiꞌ Comam Jesús xol huneꞌ mohyilal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Awtebilpaxo Comam Jesús yeb ebnaj iscuywom yin̈ huneꞌ kꞌin̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yajaꞌ xin lahwilo isvino ebnaj ay ismohyilal tuꞌ, yuxin yal ismiꞌ Comam tet: —Caw malahwi isvino ebnaj, ẍi ismiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Istakꞌwi Comam xin: —¿Tzet yin̈ wetan chawal huneꞌ tiꞌ, miꞌ? Wal xin maẍto chiapni istiempohal inyenilo wipan tet anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lahwi tuꞌ xin, yalni ismiꞌ Comam tet ebnaj chejab yin̈ kꞌin̈ tuꞌ: —Yijewe hewatxꞌen sunil tzet chal naj teyet, ẍi ismiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Haꞌ bey tuꞌ xin ayayo wajeb nimeta chꞌen moc tzꞌahab. Aymi oxebo maca can̈ebo nimeta tzꞌahab haꞌ chiayto yul hunun. Yul huntekꞌan moc tuꞌ chiayto ha haꞌ chiocnico yu ebnaj Israel istxꞌahni iskꞌab hacaꞌ yalni ischejbanil ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yalni Comam tet ebnaj chejab yin̈ kꞌin̈ tuꞌ: —Nohtzewe huntekꞌan moc tiꞌ yu ha haꞌ, ẍi Comam tet ebnaj. Hac tuꞌ xin yu yoc ebnaj isnohtzenoj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yet nohnaxa huntekꞌan chꞌen moc tuꞌ xin, yalni Comam tet ebnaj: —Iwelti haꞌ yul moc tuꞌ tinan̈, cat xin heyinito tet naj chiꞌilni yoc anma sat meẍa, ẍi Comam. Hac tuꞌ yute ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yablen naj chiꞌilni yoc anma sat meẍa tuꞌ ha haꞌ oc vinohal, caw xin mach yohtajo naj baytuꞌwal caw istitico huntekꞌanxa vino tuꞌ. Wal ebnaj chejab tuꞌ xin, yohta ebnaj tzet yehi, yuto haꞌ ebnaj inilti ha haꞌ yul chꞌen moc tuꞌ. Hayet yablen naj chiꞌilni yoc anma sat meẍa, huneꞌ vino tuꞌ, yawten naj naj mohyom tuꞌ, ");
INSERT INTO jacNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yalni naj tet naj: —Haꞌ chute anma, to babel chiꞌalaxicꞌo vino caw cꞌul tet anma awtebil, yet chilahwi yucꞌni anma teꞌ vino caw cꞌul tuꞌ, cat xin yalaxicꞌo huntekꞌan mach lahano iscꞌulal. Wal hach tiꞌ yin̈xa islahobal chawakꞌ vino caw cꞌul, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Haꞌ xin bey yul con̈ob Caná ayco yul ismajul Galilea, haꞌ bey tuꞌ isye Comam Jesús babel cꞌaybalcꞌule. Hac tuꞌ yu isyeni Comam ishelanil yip, wal ebnaj chicuywi yinta Comam xin, caw yacanayto ebnaj yul yanma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lahwi tuꞌ xin, isto Comam bey yul con̈ob Capernaum; istopaxo ismiꞌ Comam yeb yuẍta Comam, yebpaxo xin ebnaj chicuywi yintaj. Haꞌ tuꞌ xin ehayo hayeb tzꞌayical. ");
INSERT INTO jacNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yet toxa chiꞌayilo kꞌin̈ Pascua, iskꞌin̈ anma Israel, isto Comam Jesús bey yul con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yet yocto Comam yul yatut Comam Dios, yilni Comam tato ayicto ebnaj txon̈om wacax, yeb ebnaj txon̈om meꞌ, yeb ebnaj txon̈om palamuch. Aypaxo xin ebnaj helom melyu tzꞌon̈anicto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hayet yilni Comam huneꞌ tuꞌ, iswatxꞌenayo Comam huneꞌ tzꞌum yin̈ huntekꞌan lasu, yoc Comam istzumbenilti ebnaj txon̈om wacax yeb ebnaj txon̈om meꞌ. Istiẍnipaxcanto Comam ismelyu ebnaj helom melyu. Ispacꞌchancanocan̈ Comam ismeẍa ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yalni xin Comam tet ebnaj txon̈om palamuch hacaꞌ tiꞌ: —Iwelto huntekꞌan noꞌ chꞌic tiꞌ bey tiꞌ, mach chu heyakꞌaco yatut Inmaman txon̈balil, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hac tuꞌ xin, yu isnaniti ebnaj chicuywi yinta Comam Jesús tzotiꞌ tzꞌibn̈ebilcanayo yul Hum yu ischejab Comam Dios yet payat, bay chal hacaꞌ tiꞌ: “Yu caw xahan ay hawatut wuhan, yuxin caw yaꞌ chuco yin̈ wanmahan,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iskꞌamben xin ebnaj yahawil Israel tet Comam: —¿Tzet hunu chawakꞌ yechelo jetan̈ yun̈e johtan̈enilojan̈ tato ay hawip hawatxꞌen huntekꞌan tiꞌ? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Istakꞌwi Comam tet ebnaj: —Uchcꞌaweyo huneꞌ yatut Comam Dios tiꞌ, cat xin wahnican̈an selel yin̈ oxeb tzꞌayic, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yalni xin ebnaj yahawil yin̈ anma Israel tuꞌ tet Comam: —Huneꞌ yatut Comam Dios tiꞌ, caw cuarenta y seis habil yitoj yet yahi. ¿Caw xin oxebn̈echꞌan tzꞌayic chawutecan̈ selel hawalni? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yaj caw maẍticꞌa txumchalo yu ebnaj baytet huneꞌ n̈a bay chitzotel Comam tuꞌ, ton̈ca xin haꞌ Comam bay chitzoteli. ");
INSERT INTO jacNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yuxin hayet yitzitzbican̈ Comam xol anma camom, isnaniti ebnaj chicuywi yinta Comam tato halbilcano huneꞌ tuꞌ yu Comam. Yanayto ebnaj yul yanma yin̈ tzet tzꞌibn̈ebilcano yul Hum yu ischejab Comam Dios yet payat, yeb yin̈ tzet yal Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yet aycꞌo Comam Jesús yul con̈ob Jerusalén yin̈ kꞌin̈ Pascua, caw hantan̈e anma chahnayto Comam yul yanma yu cꞌaybalcꞌule iswatxꞌe Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yajaꞌ machi cawxi iscꞌul Comam yin̈ anma, yuto caw yohta Comam anma sunil. ");
INSERT INTO jacNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach yechelto ay mac chihalni tet Comam tzet ye anma, yuto caw yohta Comam tzet ye yanma hunun anma. ");
INSERT INTO jacNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xol ebnaj fariseo ay huneꞌ naj, Nicodemo isbi, caw niman yelapno naj xol ebnaj yahawil con̈ob Israel. ");
INSERT INTO jacNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yet akꞌbalil xin, apni naj yilaꞌ Comam Jesús, yalni naj tet Comam: —Mam cuywawom, caw johtajan̈ tato haꞌ Comam Dios an̈e hachti con̈hacuyuꞌan̈, yuto machi mac chiyu iswatxꞌen cꞌaybalcꞌule hacaꞌ chawatxꞌe tiꞌ ta mach ayoco Comam Dios yetbihoj, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yalni Comam Jesús tet naj: —Yin̈ caw yeli chiwalan tawet, macn̈eticꞌa mach chipitzcꞌa yin̈ iscayelal mach chu yoc yul iskꞌab Comam Dios, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iskꞌamben naj Nicodemo tuꞌ xin: —¿Tzettaxca chu ispitzcꞌa hunu anma yin̈ iscayelal tato ichamxa? ¿Tom chito yu ismeltzoco yin̈ ismiꞌ hunelxa cat xin ispitzcꞌa, hawalni? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Istakꞌwi Comam tet naj: —Caw yel chiwalcanojan tawet, macn̈eticꞌa mach chipitzcꞌa yu ha haꞌ yeb xin yu Yespíritu Comam Dios, caw mach chiyu yoc yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hayet chon̈pitzcꞌa yin̈ comiꞌ, yeli ay huneꞌ iskꞌinal conimanil chabil ju tet comiꞌ, yaj caw yilal copitzcꞌa yu Yespíritu Comam Dios yun̈e cochahni iskꞌinal Espíritu Santo jin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mach chicꞌay hacꞌul yuto chiwalan tawet ta yilal chipitzcꞌa sunil anma yin̈ iscayelal. ");
INSERT INTO jacNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hacaꞌticꞌa jakꞌekꞌ tinan̈, caw ton̈e chijabe yeqꞌui, yaj caw mach johtajoj baytuꞌwal chi-caw-istita, caw mach johtajopaxoj baytuꞌwal chi-caw-istopaxicoj. Hac ton tuꞌ xin yet anma chipitzcꞌa yu Yespíritu Comam Dios, yin̈ yesalil chipitzcꞌahi, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iskꞌamben naj hunelxa tet Comam: —¿Tzet xin chu yijni isba huneꞌ tuꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yalni Comam tet naj: —Hach tiꞌ, caw cuywawom hawehico xol ebnaj Israel, yaj ¿tzet yin̈ caw mach hawohtajo huneꞌ tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yin̈ caw yeli haꞌ tzet ohtabil juhan̈ haꞌ chijalan̈, cat jalnipaxojan̈ tzet ilbil juhan̈. Walex caw mach cheyayto yul heyanma yin̈ tzet chijalan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yet chiwalnihan teyet tzet yelapno ye tzettaj ay yul sat yiban̈kꞌinal tiꞌ, caw mach cheyayto yul heyanma, hajxam ta chiwalan teyet yin̈ tzettaj ay yul satcan̈ chal tuꞌ, caw maẍticꞌam cheyapaxayto yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wal xin, caw maẍto hunu mac xabeyahto yul satcan̈ tuꞌ, hachcachann̈e Hanin Akꞌbilintijan texol yu Comam Dios, titnajinan yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Hacaꞌ yu yanican̈ naj Moisés huneꞌ yechel noꞌ laba yin̈ te teꞌ bey txꞌotxꞌ desierto, caw yilal hac tuꞌ chiyu wahlaxcan̈an yin̈ teꞌ culus, yuxinto macn̈eticꞌa chinchahnihan yul yanma, mach chicꞌaytoj, wal xin chischah huneꞌ iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wal xin, caw xahancano ay anma ay yul sat yiban̈kꞌinal tiꞌ yu Comam Dios, yuto yati Comam hunpilan Iscꞌahol coxol, yuxinto macn̈eticꞌa chichahni yul yanma, mach chicꞌaytoj, to caw chischah huneꞌ iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hanintiꞌan caw Iscꞌahol Comam Dios wehan. Akꞌbilintijan yu Comam yul sat yiban̈kꞌinal tiꞌ, maẍtaj yu wulan wanocojan isyaꞌtajil yiban̈ anma, machoj, to yu incolnihan yalan̈ ismul. ");
INSERT INTO jacNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Macn̈eticꞌa chinchahnihan yul yanma, mach chiay isyaꞌtajil yiban̈, wal mac mach chinchahnihan yul yanma xin caw chitocano ismul yiban̈ yuto mach chayto yul yanma win̈an, haninn̈echꞌan Iscꞌahol Comam Dios intiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hulnajinan bey yul sat yiban̈kꞌinal tiꞌ yun̈e wanicojan anma xol issajilkꞌinal, yaj xin caw ay anma mach chiocheni. Hacn̈e tuꞌ xin caw chicawxico ismul yiban̈ yu istxꞌojal chiswatxꞌe anma tuꞌ, yuto yet kꞌejholo yehi. ");
INSERT INTO jacNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sunil huntekꞌan anma chiwatxꞌen ismachiswalilal, mach chiyoche huneꞌ issajilkꞌinal tiꞌ. Mach chisjepaxti xol, yuto mach chiyoche iscꞌul tato chꞌel yen̈el sunil istxꞌojal chi-la-iswatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yajaꞌ wal mac chiyijen cuybanile akꞌbilcano yu Comam Dios xin, chaco isba xol issajilkꞌinal yun̈e yiẍtan̈wiloj ta haꞌ tzet chiswatxꞌe, lahan hacaꞌ tzet choche Comam Dios, ẍi Comam tet naj Nicodemo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lahwi tuꞌ, isto Comam Jesús yeb ebnaj iscuywom bey yul ismajul Judea. Haꞌ tuꞌ xin ehayo Comam hanicꞌ tiempohal yeb ebnaj; chiyanican̈ ebnaj haꞌ iswiꞌ anma. ");
INSERT INTO jacNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wal naj Juan xin, ayco naj yanican̈ haꞌ iswiꞌ anma bey Enón iscawilal Salim, yuto caw txꞌiꞌal ha haꞌ bey tuꞌ. Haꞌ tuꞌ xin chiapni anma iscꞌatan̈ naj yu yahcano haꞌ iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yu huntekꞌan tiꞌ yet maẍto chialaxico naj preso. ");
INSERT INTO jacNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yet hunel tuꞌ xin, oc ebnaj chicuywi yinta naj Juan isteyele isba yeb huneꞌ naj israelita yin̈ tzet chiyu cosajn̈en coba yin̈ isbeybal Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Isto ebnaj yalno tet naj Juan: —Mam cuywawom, naj ayco tacꞌatan̈ yet ayach bey haꞌ niman Jordán, naj hawal jetan̈, lan̈an yahnican̈ naj haꞌ iswiꞌ anma. Caw xin hantan̈e anma chioccano tzujno yinta naj, ẍi ebnaj tet naj Juan. ");
INSERT INTO jacNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Istakꞌwi naj Juan tet ebnaj: —Caw machi hunu mac chiwatxꞌen huneꞌ munil tiꞌ tato maẍtaj Comam Dios chiakꞌni tet. ");
INSERT INTO jacNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Walex hex tiꞌ, xaheyabe tzet walan teyet tato maẍtajinan Cristo hinan. Wal xin caw babel quinchejlaxtijan yalan̈to yet maẍto chihul Comam Cristo yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kꞌinalo ta ay hunu mohyilal tinan̈, haꞌ naj chimohyi tuꞌ, haꞌ naj chiꞌikꞌni ix ix, wal naj yamigo naj ayco iscꞌatan̈, chitzala naj yaben istzotel naj chimohyi tuꞌ. Hac tuꞌ xin istzala wanmahan wabenan yapni anma iscꞌatan̈ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yuxin caw yilal niẍtejal yoccano yip ismunil Comam, walinan xin, niẍtejal islahwipaxcano wettiꞌan, ẍi naj Juan tet ebnaj chicuywi yintaj. ");
INSERT INTO jacNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Haꞌ Comam tit yul satcan̈, haꞌ caw ecꞌbal jiban̈ cosunil. Wal han̈on̈ tiꞌ yet sat txꞌotxꞌal jehi, yuxin han̈e tzet ay yul sat yiban̈kꞌinal tiꞌ haꞌ chijala. Wal huneꞌ Mac ecꞌbal cosataj, haꞌ ton Comam ispeto yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yuxin haꞌ tzet ilbil yu, yeb xin tzet abebil yu, haꞌ chiyala, yaj xin machi mac chiyayto yul yanma yin̈ tzet chiyala. ");
INSERT INTO jacNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yaj tato ay mac chichahni tzet chal Comam tuꞌ yul yanma, huneꞌ mac tuꞌ chaco isba yalniloj ta haꞌ tzet chal Comam Dios caw yeli. ");
INSERT INTO jacNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Huneꞌ Comam akꞌbilti yu Comam Dios, haꞌ Istzotiꞌ Comam Dios chalicꞌoj, yuto caw nohnan̈eticꞌaco Comam Espíritu Santo yin̈ yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Caw xahan ay Iscꞌahol Comam Dios tuꞌ yu, yuxinto caw yaco Comam Dios Mame sunil tzettaj ye tuꞌ yul iskꞌab Iscꞌahol tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hac tuꞌ xin, macxan̈eticꞌa chichahni Iscꞌahol Comam yul yanma, chischah huneꞌ iskꞌinal mach istan̈bal, yaj wal mac mach chichahni Comam yul yanma xin, caw mach chischah iskꞌinal mach istan̈bal, to haꞌ isyaꞌtajil chischah yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yaben ebnaj fariseo ta chiyapaxocan̈ Comam Jesús haꞌ iswiꞌ anma yeb xin ta caw ecꞌnaxa anma tzujan yinta Comam satapaxo naj Juan; ");
INSERT INTO jacNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Waxan̈ca maẍtaj caw Comam chianican̈ haꞌ iswiꞌ anma tuꞌ, wal xin haꞌ ebnaj chicuywi yinta Comam, haꞌ ebnaj chianican̈ haꞌ iswiꞌ anma.) ");
INSERT INTO jacNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hayet yabenilo Comam Jesús ta yabe ebnaj fariseo huneꞌ tuꞌ, yel Comam yul ismajul Judea, ismeltzoto bey yul ismajul Galilea, ");
INSERT INTO jacNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","yajaꞌ xin, caw yilal yecꞌ Comam yul ismajul Samaria. ");
INSERT INTO jacNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yapni Comam bey huneꞌ con̈ob chiyij Sicar ayco yul ismajul Samaria tuꞌ, iscawilal huneꞌ txꞌo txꞌotxꞌ akꞌbilcano yet payat yu naj Jacob tet iscꞌahol, haꞌ ton naj José. ");
INSERT INTO jacNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Haꞌ bey tuꞌ xin, ay huneꞌ cꞌuh watxꞌebil yu naj Jacob. Caw xin xasiqui Comam isbelwi, yuxin oc tzꞌon̈no Comam istiꞌ huneꞌ cꞌuh tuꞌ yet lan̈anxa yoc chuman. ");
INSERT INTO jacNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wal ebnaj chicuywi yinta Comam tuꞌ xin, to ebnaj yul con̈ob islokꞌo tzet chilolaxi. Hayet ayto ebnaj lokꞌwo tuꞌ xin, yapni huneꞌ ix ah Samaria ikꞌoti haꞌ yul huneꞌ cꞌuh tuꞌ, yalni Comam tet ix: —Akꞌ nino hawaꞌ tuꞌ wucꞌuꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Istakꞌwi ix tet Comam: —Walach hach tiꞌ, caw ah con̈ob Israel hach, ¿tom caw mach hawohtajoj tato ah con̈ob Samaria inan? ¿Tzet yin̈ chakꞌanpaxo ha haꞌ hawucꞌu wetan? ẍi ix tet Comam. (Yal ix hacaꞌ tuꞌ, yuto haꞌ anma Israel mach chischahle tzotelo isba yeb anma ah Samaria.) ");
INSERT INTO jacNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yalni Comam Jesús tet ix xin: —Kꞌinalo ta hawohta huneꞌ mac chikꞌanni haꞌ tawet tiꞌ, yeb xin ta hawohta iscꞌulal iscꞌul Comam Dios chiyakꞌ jet, chimhakꞌanpaxo hawaꞌ wetan, catmi wakꞌnihan haꞌ chiakꞌni kꞌinale machi istan̈bal tawet, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yalnipaxo ix tet Comam: —Mamin, caw nahat yehayto haꞌ yul cꞌuh lah, caw xin machi hanet chiinahti haꞌ. ¿Bay xin chaẍto hawikꞌati haꞌ chiakꞌni kꞌinale chawakꞌ wettuꞌan hawalni? ");
INSERT INTO jacNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naj Jacob, jichmam yettax payat tiempo, haꞌ naj an̈ecano huneꞌ cꞌuh tiꞌ jetan̈. Ha haꞌ yul huneꞌ cꞌuh tiꞌ xin yucꞌ naj yeb sunil yuninal, yebpaxo sunil isnokꞌ. ¿Tom xin caw ecꞌbal hachto satapaxo naj Jacob tuꞌ? ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Istakꞌwican̈ Comam tet ix: —Sunil mac chiucꞌni huneꞌ ha haꞌ tiꞌ chititpaxo istajintiꞌal hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wal mac chiucꞌni ha haꞌ chiwakꞌtiꞌan xin, matxa bakꞌin chitaj istiꞌ, yuto huneꞌ ha haꞌ chiwakꞌtiꞌan lahan hacaꞌ hunu isnukꞌ ha haꞌ chiahilo toptoni cat isbelwi, haꞌ chakꞌni kꞌinale mach istan̈bal tet, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yalni ix tet Comam xin: —Mamin, akꞌ huneꞌ haꞌ chawal tiꞌ wucꞌuꞌan haxinwal matxa chitaj intiꞌan, matxa chinhulan ikꞌo haꞌ bey tiꞌ, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yalni Comam tet ix: —As awteti hawichamil cat heyul bey tiꞌ, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Machi wichamilan, ẍi ix tet Comam. Yalni Comam tet ix: —Caw yel chawala, machi hawichamil. ");
INSERT INTO jacNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yaj howan̈xa ebnaj chawikꞌle, walpaxo naj ikꞌbil hawu tinan̈ xin, mach hawichamilo naj. Yuxin caw yel chawala, machi hawichamil, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hayet yaben ix huneꞌ tuꞌ xin, yalni ix tet Comam. —Mamin, wal tinan̈, caw chitxumchalo wuhan tato caw ischejab Comam Dios hawehi. ");
INSERT INTO jacNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ebnaj jichmaman̈, haꞌ tiꞌ hulicꞌo ebnaj iswiꞌ huneꞌ witz tiꞌ yikꞌayo isba tet Comam Dios, walexpaxo israelita hex tiꞌ, caw cheyala ta cachann̈echꞌan yul con̈ob Jerusalén chiyu coto jinoyo coba tet Comam Dios, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yalni Comam tet ix: —Hach ix ach tiꞌ, ayto sunil tzet chiwaltiꞌan yul hawanma. Chiapni huneꞌ istiempohal yet matxa chexhul heyikꞌayo heba tet Comam Dios bey huneꞌ witz tiꞌ, yeb matxa yilalo chextopaxo bey Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hex ah con̈ob Samaria hex tiꞌ, cheyiyo heba tet Comam Dios heyalni, yaj xin mach heyohtajo Comam, walon̈ Israel on̈tiꞌan̈ xin, johtajan̈ Comam Dios bay chijiyo cobahan̈, yuto coxolan̈ chiel Iscolomal anma. ");
INSERT INTO jacNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wal xin lan̈an yapni istiempohal, haꞌ ton tinan̈, yet chiyinayo isba anma yin̈ istoholal. Caw xin chíyo isba tet Comam Dios yin̈ sunil yanma yeb xin yin̈ caw isyelal, yuto hac tuꞌ choche iscꞌul Comam ta chiyiyo isba anma tet. ");
INSERT INTO jacNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wal Comam Dios, caw Espíritu ye Comam, yuxin macn̈eticꞌa chiyiyo isba tet Comam, caw yilal chiyiyo isba yin̈ sunil yanma yeb xin yin̈ caw isyelal, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yalni ix tet Comam: —Caw wohtajan tato chul huneꞌ naj Mesías, haꞌ ton Comam Cristo Cocolomal, yu Comam Dios. Hayet chihul naj tuꞌ xin, haꞌ naj chi-cam-halni yin̈ tzet caw yelapno ye sunil, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yalni Comam xin: —Hanintonan huneꞌ chawal tiꞌ, huneꞌ lan̈an istzotel tawet tiꞌ, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hayet lan̈an istzotel Comam tuꞌ xin, yapni ebnaj iscuywom. Caw cꞌayilo iscꞌul ebnaj yilni istzotel Comam yeb huneꞌ ix ix tuꞌ. Wal xin caw machi hunu ebnaj kꞌambeni tzet yin̈ xin tzotel Comam yeb ix, yeb xin tzet chal Comam yeb ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Lahwi tuꞌ xin, isbejnicano ix istzꞌahab istiꞌ cꞌuh tuꞌ, isto ix yalno tet anma yul iscon̈ob hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Catawej, ton̈we jilaꞌ huneꞌ mac mahalni wetan yin̈ sunil tzet wehicojan. ¿Cꞌuxan tato haꞌ naj tuꞌ Cristo? ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hayet yaben anma huneꞌ tuꞌ, istit anma yilno Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yet maẍto chiapni anma iscꞌatan̈ Comam, yalni ebnaj iscuywom Comam: —Mam cuywawom, waꞌan̈, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Istakꞌwi Comam tet ebnaj: —Ay huneꞌ tzet chinlohan caw mach heyohtajoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yoc ebnaj iscuywom Comam tuꞌ yalno tet hunun hacaꞌ tiꞌ: —¿Tocꞌanab xin ay mac mahulicꞌo akꞌno tzet chislo Comam tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yalni Comam xin: —Wal xin, haꞌ tzet choche Comam chejn̈eintijan, haꞌ chiwochehan chinwatxꞌehan, cat xin inlahnihan ismunil akꞌbilcano yul inkꞌaban. Yuxin hayet chinwatxꞌenan ismunil tiꞌ, caw lahan yeb hacaꞌ yet lan̈an inwaꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hex tiꞌ cheyala ta can̈ebto ixahaw bay chicꞌuplaxcan̈ ixim trigo. Caw hacticꞌam tuꞌ, yaj chiwalan teyet: ¡Tꞌan̈xan̈wetoj lah, naweloj! Caw maayilo istiempohal iscutxbalaxico anma wetan, hacaꞌ chiyu iscutxbalax ixim trigo yet chikꞌanbilo ixim. ");
INSERT INTO jacNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Haꞌ naj chicꞌupnican̈ ixim trigo chischah naj istohol, yechel naj ye naj chiinito anma iscꞌatan̈ Comam yu ischahni iskꞌinal chiyakꞌ Comam. Yuxin naj chitzꞌunni ixim yeb naj chicꞌupnican̈ ixim, lahan istzala iscꞌul ebnaj iscawan̈il. ");
INSERT INTO jacNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hacaꞌ yalni anma chijabe: “Nan naj chitxihni ixim trigo, nanxapaxo naj chicꞌupnican̈ ixim,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yuxin chexinchejtojan xol anma, hacaꞌ ebnaj chicꞌupnican̈ ixim trigo tuꞌ, nan ebnaj babel munlanahi hacaꞌ yin̈ istxihnayo ixim, hex tiꞌ xin caw toxan̈e chexecꞌ hecꞌupuꞌcan̈ ixim, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Caw txꞌiꞌal anma yul huneꞌ con̈ob ay yul ismajul Samaria tuꞌ chahnicano Comam yul yanma yuto caw wiyom yalni ix hacaꞌ tiꞌ: “Mayalilo naj wetan yin̈ sunil tzet xale inwatxꞌehan,” ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yuxin hayet yapni anma tuꞌ iscꞌatan̈ Comam, yalni anma tet Comam tato chicancano Comam yul con̈ob tuꞌ. Hac tuꞌ xin yu iscancano Comam cab tzꞌayical bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Caw xin hantan̈eto anma chahnicano Comam yul yanma yet yaben iscuywacanto Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yalni anma tet ix tzotel tet Comam hacaꞌ tiꞌ: —Wal tinan̈, caw chijaytojan̈ yul janmahan̈, yaj maẍn̈etaj yu tzet maxawal jetan̈, to yu han̈-caw-on̈an̈ majabehan̈ tzet chal Comam, yuxinto caw johtajan̈ ta haꞌ Comam tiꞌ Cristo, haꞌ Cocolomal cosunil yul sat yiban̈kꞌinal tiꞌ, ẍi anma tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yet islahwi cab tzꞌayic yecꞌ Comam Jesús bey ismajul Samaria tuꞌ xin, isto Comam bey yul ismajul Galilea. ");
INSERT INTO jacNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caw xin halbilxaticꞌa yu Comam tuꞌ tato caw machi hunu ebnaj ischejab Comam Dios xahan chiillax yul iscon̈ob. ");
INSERT INTO jacNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hayet yapni Comam bey Galilea tuꞌ xin, caw cꞌul yu ischahlax Comam yu anma, yuto yil anma tzettaj iswatxꞌe Comam yet yecꞌ kꞌin̈ Pascua bey Jerusalén, yet isbeycꞌo anma yin̈ kꞌin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yapni Comam Jesús bey yul con̈ob Caná bay elico ha haꞌ vinohal yu Comam. Haꞌ bey yul con̈ob Capernaum xin, ay huneꞌ naj niman yelapno ismunil chimunla yinta naj rey, ay xin huneꞌ iscꞌahol naj caw txꞌoj ye iscꞌul yu yabil. ");
INSERT INTO jacNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yet yaben naj tato tit Comam Jesús bey Judea yapni bey ismajul Galilea tuꞌ, isto naj yilno Comam. Iskꞌanni naj tet Comam tato chito Comam yilaꞌ huneꞌ iscꞌahol naj caw how yehico yabil yin̈, lan̈anxa iscami. ");
INSERT INTO jacNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yalni xin Comam tet naj hacaꞌ tiꞌ: —Wal hex tiꞌ, tato mach cheyil sunil wipan yeb ej cꞌaybalcꞌule chinwatxꞌehan, caw maẍticꞌam chinhechahan yul heyanma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yalni naj tet Comam: —Mamin, ton̈ yin̈ an̈e yakꞌ isba maẍto chicam incꞌaholan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yalni Comam tet naj: —Paxan̈to hawatut, cawxa naj hacꞌahol, ẍi Comam tet naj. Hac tuꞌ yu yanayto naj yul yanma yin̈ tzet yal Comam, ispaxto naj yatut. ");
INSERT INTO jacNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yet ayco naj yin̈ isbel bey con̈ob Capernaum tuꞌ, yapni huntekꞌan ebnaj ismunlawom naj chahwal yin̈ yul beh, yalni ebnaj tet naj: —Cawxa naj hacꞌahol, ẍi ebnaj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iskꞌambenilo naj mame tuꞌ tet ebnaj ismunlawom: —¿Hanicꞌ mawatxꞌilo iscꞌul incꞌaholtuꞌan? ẍi naj. Yalni ebnaj: —Ewitax yin̈ chꞌen hujeb yel kꞌaꞌ yin̈ naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Istxumni naj mame tuꞌ ta hacaꞌticꞌa orahil chal ebnaj ismunlawom naj tuꞌ, hac tuꞌ orahil yet yalni Comam Jesús tet naj hacaꞌ tiꞌ: “Cawxa naj hacꞌahol tuꞌ tinan̈,” ẍi Comam. Hac tuꞌ xin yu ischahnicano naj Comam Jesús yul yanma yeb sunil mac ay bey yul yatut naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Haꞌ huneꞌ cꞌaybalcꞌule tiꞌ iswatxꞌe Comam yul ismajul Galilea lahwi isbey Comam yin̈ kꞌin̈ bey Judea. Haꞌ xin iscab cꞌaybalcꞌule tiꞌ iswatxꞌe Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lahwi tuꞌ xin, istopaxo Comam Jesús yul con̈ob Jerusalén yin̈ huneꞌ iskꞌin̈ anma Israel chiecꞌ yul con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bey yul con̈ob Jerusalén tuꞌ xin, iscawilal ispultahil bay chꞌocto noꞌ meꞌ, haꞌ tuꞌ ay huneꞌ ha haꞌ ton̈e etxan. Yul abxubal hebreo Betesda isbi huneꞌ haꞌ tuꞌ. Istiꞌla haꞌ tuꞌ xin, aycan̈ howeb n̈a machi yich. ");
INSERT INTO jacNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Caw xin txꞌiꞌal anma yaꞌay hilanejayo yul huntekꞌan n̈a tuꞌ. Ay mac mach chu yilni, ay xin mac mach chu yeqꞌui, aypaxo mac mach chibili isnimanil. Huntekꞌan anma yaꞌay tuꞌ ayco yechman isbilican̈ haꞌ, ");
INSERT INTO jacNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yuto caw yin̈n̈e istiempohal chihulayti huneꞌ naj ángel isbile haꞌ, macn̈eticꞌa babel chiayto yet chibilican̈ haꞌ xin, haꞌ chian̈chahi, cat yel tzettaj yabilal ayco yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Xol anma yaꞌay tuꞌ ayayo huneꞌ naj treinta y ocho habilxa yoc yabil yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Hayet yilni Comam Jesús ta hilanayo naj bey tuꞌ, istxumnilo Comam tato caw payxa ichico naj, yalni Comam tet naj: —¿Chimhawoche chaẍan̈chahi? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yalni naj tet Comam hacaꞌ tiꞌ: —Mamin, caw machi hunu mac chinanaytojan xol haꞌ tiꞌ yet chibilican̈ haꞌ. Hayet chinaytojan xol haꞌ walnihan, nan mac chibabayto insatajan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yalni Comam tet naj xin: —Ahan̈wanoj, ican̈ hawaybal tiꞌ, cat hatohi, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yin̈n̈ena tuꞌ iscawxican̈ naj, yoc naj yinocan̈ iswaybal, isto naj xin. Hayet yan̈chacano naj tuꞌ, cꞌuxan istzꞌayical xewilal, ");
INSERT INTO jacNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","yuxinto yal ebnaj yahawil yin̈ con̈ob Israel tet naj hacaꞌ tiꞌ: —Wal tinan̈, caw istzꞌayical xewilal, caw mach chu hawijnicꞌo hawaybal tiꞌ, ẍi ebnaj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Istakꞌwican̈ naj cawxican̈ tuꞌ: —Haꞌ mac maquinakꞌni cawxojan, haꞌ mahalni wetan hacaꞌ tiꞌ: “Ican̈ hawaybal, cat xin hatohi,” ẍi wetan, ẍi naj tet naj yahawil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Iskꞌamben ebnaj tet naj: —¿Mac xin najil mahalni tawet, ta chawican̈ hawaybal cat xin hatohi? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wal xin caw mach yohtajo naj mac akꞌni cawxo tuꞌ, yuto caw hantan̈e anma bey tuꞌ, caw xin pet cꞌaycan̈ Comam Jesús xol anma. ");
INSERT INTO jacNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lahwi tuꞌ xin, ischahnayo Comam Jesús naj yul yatut Comam Dios, yalni Comam tet naj: —Wal tinan̈, caw macachcawxiloj. Matxa chawaco yakꞌbil hamul haxinwal matxa hunuxa isyaꞌtajil caw txꞌoj chul tawiban̈, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lahwi tuꞌ xin, isto naj yalno tet ebnaj yahawil yeco yin̈ con̈ob Israel tato haꞌ Comam Jesús akꞌni cawxo naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hac tuꞌ xin, yu yoccano ebnaj yanoco ishowal yin̈ Comam isyayil yakꞌ cawxo Comam huneꞌ naj yin̈ istzꞌayical xewilal. ");
INSERT INTO jacNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yalni Comam Jesús xin: —Inmaman, maẍticꞌa chisbej ismunlahi, yuxin haquintuꞌan, maẍticꞌa chinbejcanojan inmunlahan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hac tuꞌ xin, caw yacanico ebnaj yahawil con̈ob Israel tuꞌ yin̈ iscꞌul yakꞌni camo Comam Jesús, yuto mach isyije Comam huneꞌ tzꞌayic xewilal. ");
INSERT INTO jacNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yalni Comam Jesús tet ebnaj: —Yin̈ caw isyelal chiwalcanojan teyet, caw Iscꞌahol Dios wehan, yuxin haꞌ huntekꞌan chinwatxꞌetiꞌan caw mach wetojan inchuquilan. Haꞌ tzet chakꞌ Inmaman inwatxꞌehan, haꞌ chiwuhan, yuxinto sunil tzet chiswatxꞌe Inmamtuꞌan, caw chiyupaxo wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wal hanintiꞌan, Iscꞌahol Dios wehan, caw xin xahan ayinan yu Inmamtuꞌan. Sunil tzet chinwatxꞌehan Inmamtuꞌan chiyeni wetan. Ayto xin huntekꞌan tzet caw ay yelapno chisye Inmamtuꞌan wetan cat inwatxꞌenan, hac tuꞌ xin chicꞌay hecꞌul heyilni. ");
INSERT INTO jacNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wal Inmamtuꞌan chiyu yakꞌni itzitzbocan̈ camom, cat xin yakꞌnipaxo iskꞌinal mach istan̈bal. Haquinpaxtuꞌan chiwakꞌan kꞌinale tet mac bay choche incꞌulan chiwakꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Machi hunu anma chiyil Inmaman yin̈ tzet chielicoj, walxinto haninan akꞌbil wipan yu Inmaman yu wilnihan yin̈ tzet chielico anma. ");
INSERT INTO jacNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Caw yul inkꞌaban ayco huntekꞌan tiꞌ yu Inmaman yun̈e lahann̈e chꞌoc inmayan yeb Inmaman. Yaj tato ay anma machi welapnojan yul sat, caw machipaxo yelapno Inmaman yul sat chal tuꞌ, yuto Inmamtuꞌan chejn̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yin̈ caw isyelal chiwalan teyet, macn̈eticꞌa chꞌaben tzet chiwaltiꞌan, cat yanayto yul yanma yin̈ Inmaman chejn̈eintijan, chischah iskꞌinal mach istan̈bal. Hac tuꞌ xin mach chicawxico ismul yiban̈, caw wiyom yel yul iskꞌab naj camical, cat ischahnicano iskꞌinal yin̈ huneln̈e. ");
INSERT INTO jacNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wal hanin Iscꞌahol Comam Dios wetiꞌan, caw chiwalcanojan teyet tato chihul istiempohal, haꞌ ton tinan̈ yet chaben anma camom wawihan; haꞌ mac chiaben tzet chiwaltiꞌan xin chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wal Inmaman, haꞌticꞌa ikꞌn̈e iskꞌinal, haquinpaxtuꞌan win̈an ayco inkꞌinalan yu Inmaman. Hacaꞌ chu yakꞌni Inmaman iskꞌinal anma, hac tuꞌ chu wakꞌnipaxojan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chakꞌnipaxo Inmaman wipan yul inkꞌaban wilnihan yin̈ tzet chielico anma, ta cꞌul maca txꞌoj tzet chiswatxꞌe. Ay huneꞌ wiptiꞌan yuto Hanin Akꞌbilintijan texol yu Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Caw mach cheyakꞌ cꞌayo hecꞌul yin̈ huntekꞌan tzet chiwalcanojan teyet tiꞌ. Wal xin caw chiapni istiempohal yet chaben sunil anma camomxa yul innukꞌan, cat xin yitzitzbican̈. ");
INSERT INTO jacNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Macn̈eticꞌa cꞌul tzet iswatxꞌe yul sat yiban̈kꞌinal tiꞌ, chiitzitzbican̈ cat ischahni huneꞌ iskꞌinal mach istan̈bal, walpaxo anma caw istxꞌojaln̈eticꞌa hulicꞌo iswatxꞌe yul sat yiban̈kꞌinal tiꞌ, chiitzitzbican̈ cat xin ischahni isyaꞌtajil, ẍicano Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yalnipaxo Comam Jesús tet ebnaj yahawil yeco yin̈ con̈ob Israel: —Wal hanintiꞌan, caw machi hunu tiꞌ chinwatxꞌehan yul wetan inchuquilan. Hacaꞌ halbil wetan yu Inmaman hac tuꞌ chu wilnihan yin̈ tzet chielico anma, yajaꞌ chiwilan yin̈ tzet chielico yin̈ caw istoholal. Yuxin haꞌ tzet chal iscꞌul Inmaman an̈eintijan, haꞌ chinwatxꞌehan, maẍtaj tzet chiwochehan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tato han-caw-inan chinocan tzotelo yin̈ sunil tzet chinwatxꞌehan, caw matzet chalilo chal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yajaꞌ ay huneꞌ mac caw chakꞌ isba istzotel win̈an, caw xin wohtajan ta sunil tzet chala caw yeli. ");
INSERT INTO jacNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yet hechejnito hechejab tet naj Juan hekꞌambeno tzet caw yelapno ye naj, caw isyelal yal naj teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yaj maẍtaj yu wikꞌni wipan yin̈ tzet chal anma yuxin chiwalan huneꞌ tiꞌ teyet, machoj, walxinto yu hecolchahi. ");
INSERT INTO jacNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Naj Juan tuꞌ, caw lahan naj hacaꞌ hunu cantil ayco kꞌaꞌ yin̈, nahat chimujli iskꞌakꞌal. Caw hac tuꞌ yu yulicꞌo naj, yuxinticꞌa quextzalacan̈ yu naj hanicꞌ tiempohal. ");
INSERT INTO jacNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yajaꞌ ay huneꞌ tzet caw ecꞌbal yelapno ye sata tzet yal naj Juan tuꞌ win̈an, sunilej cꞌaybalcꞌule yakꞌ Inmaman inwatxꞌehan, haꞌ chitzotel win̈an. Haꞌ xin chiyeniloj tato haꞌ Inmaman quinanitijan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Haꞌ Inmaman an̈eintijan haꞌ chitzotel win̈an, walex hex tiꞌ caw maẍto bay cheyabe istzoteli, caw maẍto chetxumilo mac caw Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Caw maẍto Istzotiꞌ Inmamtuꞌan yul heyanma, yuto mach cheyayto yul heyanma win̈an, wal xin haꞌ Comam Dios an̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Hex tiꞌ caw cheyil hecuyni Istzotiꞌ Comam Dios, yuto chꞌecꞌ yin̈ henabal ta yin̈ tuꞌ chiilchalo hekꞌinal mach istan̈bal. Yajaꞌ waxan̈ca Istzotiꞌ Comam Dios tuꞌ chitzotel win̈an, yajaꞌ mach chisje hecꞌul chexoc tzujno wintajan yun̈e hechahni hekꞌinal mach istan̈bal chiwakꞌtiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Maẍtaj yu yalaxico inmayan yu anma yuxin chiwalan huntekꞌan tzotiꞌ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wal hacaꞌ quexwilnitiꞌan, caw mach cheyoche Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Hanintiꞌan caw chejbilintijan yu Inmaman, yaj caw mach cheyabe tzet chiwalan. Wal tato hunuxa naj comon anma chihul yeb yet, wal tuꞌ caw sakꞌal heyijen sunil tzet chal naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Tzetticꞌa chu heyanayto yul heyanma tato hemay cheyaco hununex, wal helanil chitit tet Comam Dios, caw mach chicam hecꞌul hesayniloj? ");
INSERT INTO jacNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tajca cheyala tato hanintiꞌan chinocan akꞌocꞌule yin̈ hemul tet Inmaman, walxinto haꞌ caw naj Moisés chioc akꞌocꞌule teyin̈, naj bay chicawxi hecꞌul. ");
INSERT INTO jacNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wal xin tato cheyayto yul heyanma yin̈ tzet tzꞌibn̈ebilcano yu naj Moisés, chimheyapaxayto yul heyanma win̈an, yuto win̈an chitzotel huntekꞌan tzet tzꞌibn̈ebilcano yu naj. ");
INSERT INTO jacNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yajaꞌ tato mach cheyayto yul heyanma yin̈ tzet tzꞌibn̈ebilcano win̈an yu naj tuꞌ, tzicꞌanab chiyu heyanayto yul heyanma yin̈ sunil tzet chiwaltiꞌan, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lahwi tuꞌ xin, isto Comam Jesús iskꞌaxepicꞌto haꞌ lago Galilea, chiyijpaxo Tiberias. ");
INSERT INTO jacNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Caw xin hantan̈e anma oc tzujno yinta Comam, yuto yil anma tuꞌ iswatxꞌen Comam cꞌaybalcꞌule yet iscawxi anma yaꞌay yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Isto Comam Jesús iswiꞌ huneꞌ won̈an yeb ebnaj chicuywi yintaj, yay tzꞌon̈no Comam yeb ebnaj bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Toxa xin chiichico kꞌin̈ Pascua, iskꞌin̈ ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yet yilni Comam xin ta caw hantan̈e anma apni iscꞌatan̈, yalni Comam tet naj Felipe: —¿Baytuꞌwal chicolokꞌ tzet chislo sunil anma tiꞌ? ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yal Comam huneꞌ tiꞌ yun̈e yaben Comam tzet chiyute yalni naj Felipe. Wal Comam xin, caw yohtaxa tzet chiyu yakꞌni waꞌo sunil anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Istakꞌwi naj: —Waxan̈ca ay cabo ciento denario comelyu chilokꞌni tzet chilolaxi, caw maẍticꞌam chabe yikꞌni anma hunta txꞌinano yet, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ay xin huneꞌ naj chicuywi yinta Comam tuꞌ, yuẍta isba yeb naj Simón Pedro, Andrés isbi. Haꞌ naj halni: ");
INSERT INTO jacNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ay huneꞌ naj nichꞌan coxol tiꞌ, ay cacꞌon̈ noꞌ cay ikꞌbil yu naj yeb xin howeb ixim pan cebada, yajaꞌ ¿tzet chakꞌ hanicꞌ tiꞌ yin̈ sunil anma? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yalni Comam tet ebnaj iscuywom tuꞌ: —Halwe tet sunil anma ayojab tzꞌon̈noj, ẍi Comam. Caw xin chekꞌanla sat txꞌotxꞌ bey tuꞌ, yuxin hacn̈e tuꞌ yu yay tzꞌon̈no anma sunil. Aymi howebo mil isbisil ebnaj winaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yinican̈ Comam ixim pan tuꞌ. Yet lahwi yakꞌni Comam yuchꞌandiosal yin̈ ixim tet Comam Dios, yitxkꞌanto Comam ixim yin̈ anma tzꞌon̈an tuꞌ. Hacticꞌapax tuꞌ yute Comam yin̈ noꞌ cay, yakꞌ Comam hantaticꞌa caw choche anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hayet lahwi isnohcano iscꞌul anma tuꞌ xin, yalni Comam tet ebnaj chicuywi yintaj: —Cutxbaweyo sunil ixim matxa malahwi yu anma tiꞌ, haxinwal machi ixim chietaxtoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hac tuꞌ xin yu iscutxbanico ebnaj ixim, caw xin cablahon̈ebto motx ixim matxa lahwi yu anma tuꞌ yin̈ ixim howeb pan cebada. ");
INSERT INTO jacNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yet yilni anma huneꞌ cꞌaybalcꞌule iswatxꞌe Comam Jesús tuꞌ, yalni anma hacaꞌ tiꞌ: —Yin̈ caw yeli, haꞌ huneꞌ naj tiꞌ ischejab Comam Dios halbilcanoj tato chihul coxol bey yul sat yiban̈kꞌinal tiꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Isnanilo Comam Jesús tato chꞌecꞌ yin̈ isnabal anma yinito Comam cat yanico anma Comam yahawiloj, yuxinto el Comam xol anma, isto Comam iswiꞌ won̈an ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yet yay numnahi yapni ebnaj iscuywom Comam Jesús istiꞌ haꞌ lago. ");
INSERT INTO jacNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lahwi tuꞌ xin yocto ebnaj yul huneꞌ teꞌ barco yun̈e yecꞌ apno ebnaj iskꞌaxepxacꞌto haꞌ lago cat yapni ebnaj yul con̈ob Capernaum. Caw xaay numnahi, maẍtoticꞌa xin chiapni Comam iscꞌatan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yet bel chu isbarco ebnaj yiban̈ haꞌ tuꞌ, istzabnico yecꞌ huneꞌ niman jakꞌekꞌ. Caw nahat chiꞌah haꞌ isbilen jakꞌekꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ayxam xin yictajo iscab legua chito isbarco ebnaj yiban̈ haꞌ lago tuꞌ, yilni ebnaj Comam Jesús belwo chu yiban̈ haꞌ. Lan̈an xin ishitzico Comam iscꞌatan̈ teꞌ barco bay ayicto ebnaj tuꞌ, isxiwcan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yalni Comam tet ebnaj: —Haninan, mach chexxiwcan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yuxinto caw tzalacan̈ ebnaj ischahnicto ebnaj Comam yul barco tuꞌ iscꞌatan̈. Hunepixto xin, yapni ebnaj iskꞌaxepicꞌto haꞌ bay nabilto yu yapni. ");
INSERT INTO jacNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Haxa yin̈ hunxa tzꞌayic xin, yet aytocꞌo anma sunil istiꞌ haꞌ lago tuꞌ, isnaniti anma tato xato ebnaj iscuywom Comam yul huneꞌ teꞌ barco ayayo bey tuꞌ, han̈e xin teꞌ ayayoj. Isnanipaxti anma ta machi to Comam yinta ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ay xin huntekꞌan teꞌ barco ispeto yul con̈ob Tiberias apni iscawilal bay iswah anma ixim pan yet yakꞌni Comam yuchꞌandiosal yin̈ ixim tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yet yilni anma tato matxa Comam Jesús bey tuꞌ yeb ebnaj chicuywi yintaj, yocto anma yul huntekꞌan teꞌ barco apni bey tuꞌ, isto anma saywal yin̈ Comam kꞌaxepxacꞌto haꞌ bey yul con̈ob Capernaum. ");
INSERT INTO jacNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yet yecꞌ apno anma iskꞌaxepicꞌto haꞌ lago tuꞌ yilcha Comam yu anma. Iskꞌamben anma tuꞌ tet Comam: —Mam cuywawom, ¿hanicꞌ hawul bey tiꞌ? ẍi anma tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Istakꞌwi Comam tet anma: —Yin̈ caw isyelal chiwalan teyet, walex hex tiꞌ, chinhesayilojan yuto caw noh hecꞌul yu ixim pan wakꞌan hewab. Maẍtaj yu matxumchalo heyu yin̈ tzet chal yelapno ye huneꞌ cꞌaybalcꞌule inwatxꞌetuꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yalnipaxo Comam: —Maẍn̈etaj tzet chelo cheyaco yin̈ hecꞌul hesayniloj yuto huneꞌ tuꞌ chilahwi. Wal xin ay huneꞌxa hacaꞌ tzet chicolo mach chitan̈iloj, haꞌ huneꞌ tuꞌ chiakꞌni hekꞌinal mach istan̈bal. Haꞌ huneꞌ tuꞌ wal heyanico yin̈ heyanma hesayniloj. Hanin Akꞌbilintijan texol yu Inmaman, haninan chiwakꞌan huneꞌ itah, haꞌ ton kꞌinale mach istan̈bal, yuto xaisyelo Comam Dios tato haninan sicꞌbilintijan yu, ẍi Comam Jesús tet anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iskꞌamben anma tet Comam: —¿Tzet xin wal juten cobahan̈ yun̈e cowatxꞌenan̈ sunil tzet choche iscꞌul Comam Dios? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Istakꞌwi Comam: —Haꞌ huneꞌ chiyoche Comam Dios to cheyayto yul heyanma win̈an, yuto haꞌ Comam chejn̈eintijan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yalnipaxo anma tet Comam: —¿Tzet xin hunu cꞌaybalcꞌulehal chaye jilaꞌan̈, yun̈e cachcochahnihan̈ yul janmahan̈? ¿Tzet hunu chawatxꞌe? ");
INSERT INTO jacNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ebnaj jichmaman̈ yet payat, ay huneꞌ cꞌaybalcꞌule ilbil yu ebnaj yet isloni ebnaj maná bey txꞌotxꞌ desierto. Hacaꞌ yalni Istzotiꞌ Comam Dios bay chal hacaꞌ tiꞌ: “Yati Comam Dios huneꞌ itah satcan̈ islob sunil anma,” ẍiayoj, ẍi anma tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yalni Comam tet anma: —Yin̈ caw isyelal chiwalan teyet, maẍtaj naj Moisés akꞌn̈e huneꞌ itah satcan̈il tuꞌ tet ebnaj jichmam yet payat tiempo tuꞌ. Wal xin itah tit yul satcan̈ tuꞌ yechel yin̈ huneꞌ wah caw yeli chakꞌ Inmaman teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Huneꞌ wah chakꞌ Comam tiꞌ, yul satcan̈ titnaj, haꞌ xin chiakꞌni kꞌinale mach istan̈bal tet anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yalni anma tet Comam: —Mamin, akꞌ huneꞌ wah tuꞌ jetan̈ yin̈ sunilbal tiempo, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yalni Comam tet anma: —Hanintonan huneꞌ wah tuꞌ, yuto chiwakꞌan kꞌinale mach istan̈bal. Macn̈eticꞌa chaco isba yul inkꞌaban, matxa bakꞌinal chin̈ohchahi, yeb xin macn̈eticꞌa chianayto yul yanma win̈an, matxa bakꞌinal chitajpaxo istiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Caw xaticꞌa walan teyet, waxan̈ca caw cheyilico win̈an, yajaꞌ caw mach cheyaco heba yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wal xin, sunil mac chahti Inmaman wetan, chul yul inkꞌaban, yuxin mac chihul yul inkꞌabtuꞌan caw chinchahan, mach chinman̈cꞌotojan. ");
INSERT INTO jacNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wal hanintiꞌan, quintitan yul satcan̈, yaj maẍtaj yu inwatxꞌenan tzet chal incꞌulan, wal xin titnajinan yun̈e inwatxꞌenan tzet chal iscꞌul Inmaman chejn̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Haꞌ tzet choche iscꞌul Comam chejn̈eintijan yin̈ sunil macta chiyaco yul inkꞌaban, ta machi hunu mac chicꞌayto wuhan, to chiwakꞌ itzitzbocan̈an yet chiapni islahobal tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Haꞌ choche iscꞌul Inmaman, to haꞌ mac chinilnihan ta haninan Iscꞌahol Dios wehan, cat yanayto yul yanma win̈an, chischah iskꞌinal mach istan̈bal. Haxa yet chiapni islahobal tzꞌayic, cat wakꞌni itzitzbocan̈an xol camom, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yet yaben ebnaj yahawil yin̈ ebnaj Israel yin̈ tzet chal Comam tuꞌ, yoc ebnaj buchwal yin̈ Comam yuto yal Comam hacaꞌ tiꞌ: “Hanintiꞌan huneꞌ wah titna yul satcan̈,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yalni ebnaj hacaꞌ tiꞌ: —¿Tom maẍtaj naj tiꞌ naj Jesús, iscꞌahol naj José? Caw johta mac ismam naj yeb ismiꞌ naj. ¿Tzet yin̈ yuxinto chal naj tato yul satcan̈ titna naj? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yalni Comam tet ebnaj: —Bejwe hetzotel win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Caw machi hunu mac chihul yul inkꞌaban tato maẍtaj Inmaman chichejniti wetan, Comam an̈eintijan. Haninan xin chiwakꞌ itzitzbocan̈an yet islahobal tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tzꞌibn̈ebilcano yu ebnaj ischejab Comam Dios yet payat hacaꞌ tiꞌ: “Sunil mac chicuylax yu Comam Dios,” ẍiayoj. Yuxin sunil mac chiaben tzet chal Comam Dios tuꞌ, chitxumchalo yu yin̈ tzet chala, haꞌ xin chihul yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Caw maẍto hunu mac iln̈e yin̈ Comam Dios Mame hachcachann̈e inan, yuto yul satcan̈ titnajinan, yuxinto caw wohtajan Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yin̈ caw isyelal chiwalan teyet, macn̈eticꞌa chinchahnihan yul yanma, caw chischah huneꞌ iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hanintiꞌan haꞌ ton huneꞌ wah chiakꞌni kꞌinale mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Haꞌ ebnaj heyichmam yet payat tuꞌ, iswah ebnaj huntekꞌan maná bey txꞌotxꞌ desierto, yaj xin sunil ebnaj xa-le-camtoj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yajaꞌ mac chiwahni huneꞌ wah titna yul satcan̈, chiwaltiꞌan xin, machi bakꞌinal chicami. ");
INSERT INTO jacNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Hanintonan huneꞌ wah itzitz titna yul satcan̈, yuxin macn̈eticꞌa chiwahni huneꞌ wah tiꞌ, caw itzitzn̈eticꞌa yin̈ sunilbal tiempo. Haꞌ huneꞌ wah chiwakꞌtiꞌan, haꞌ ton innimanilan chiwakꞌan yun̈e ischahni anma iskꞌinal, ẍi Comam Jesús tet anma. ");
INSERT INTO jacNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hayet yaben anma Israel huntekꞌan tiꞌ, istzabnico anma isteyelen isba yin̈ tzet yal Comam. Le-yalni anma hacaꞌ tiꞌ: —¿Tzet chu yakꞌni naj tiꞌ isnimanil cocꞌuxuꞌ? ẍi anma tet hunun. ");
INSERT INTO jacNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yalni Comam xin: —Yin̈ caw isyelal chiwalan teyet, hacaꞌ tato mach checꞌux innimaniltiꞌan, Hanin Akꞌbilintijan texol yu Comam Dios, yeb xin hacaꞌ ta mach cheyucꞌ inchiqꞌuilan, mach chechah hekꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yuxin macn̈eticꞌa chicꞌuxni innimaniltiꞌan, cat yucꞌni inchiqꞌuiltiꞌan, caw chischah iskꞌinal mach istan̈bal. Hayet islahobal tzꞌayic xin chiwakꞌ itzitzbocan̈an xol anma camom. ");
INSERT INTO jacNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yuto innimaniltiꞌan lahan hacaꞌ wah, haꞌ chiakꞌni kꞌinale mach istan̈bal, hacpax tuꞌ xin inchiqꞌuilan hacaꞌ tzet chiucꞌlaxi. ");
INSERT INTO jacNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Macn̈eticꞌa chicꞌuxni innimanilan cat xin yucꞌni inchiqꞌuilan, caw hunxan̈e chiwucanojan yebi. ");
INSERT INTO jacNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Comam Dios caw itzitz yin̈ sunilbal tiempo, haꞌ Comam tuꞌ quinchejnitijan, yuxin itzitz inn̈eticꞌapaxojan. Hac ton tuꞌ xin, mac chicꞌuxni innimaniltiꞌan, caw itzitzn̈eticꞌapaxo wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hanintonan, huneꞌ wah titna yul satcan̈, yaj mach hacaꞌo maná islo ebnaj jichmam, yuto waxan̈ca islo ebnaj huntekꞌan maná tuꞌ, yaj cam ebnaj. Wal mac chiwahni huneꞌ wah chiwaltiꞌan xin, caw ay iskꞌinal mach istan̈bal, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sunil huntekꞌan tiꞌ yakꞌ Comam Jesús iscuyuꞌ anma yul iscapilla ebnaj Israel bey yul con̈ob Capernaum. ");
INSERT INTO jacNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yet yaben anma chicuywi yinta Comam Jesús huntekꞌan cuybanile yakꞌ Comam tuꞌ, txꞌiꞌal ebnaj halni tet hunun: —Caw yaꞌta cochahni huntekꞌan chal naj tiꞌ. ¿Mactaxca chikꞌoji isyijeni? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wal Comam xin, caw yohtaxa tzettaj chal ebnaj tuꞌ, yuxin yal Comam hacaꞌ tiꞌ: —¿Tom caw chicabconcan̈ hecꞌul yin̈ tzet chiwaltiꞌan? ");
INSERT INTO jacNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wal Hanin Akꞌbilintijan texol yu Comam Dios tiꞌ, tato cheyil inmeltzohan yul satcan̈ bay titnajinan, ¿tzixam chi-la-heyalaꞌ? ");
INSERT INTO jacNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Haꞌ Yespíritu Comam Dios haꞌ chiakꞌni kꞌinale mach istan̈bal, wal conimanil matzet chakꞌa. Huntekꞌan cuybanile xawalan teyet tuꞌ, yin̈ caw yeli yet Espíritu yehi, haꞌ chiakꞌni kꞌinale mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yajaꞌ ayexto hex tiꞌ, maẍto cheyayto yul heyanma yin̈ tzet chiwaltiꞌan, ẍi Comam. Yal Comam hacaꞌ tuꞌ yuto caw yohtaxa Comam yet caw yalan̈tocanoj macta mach chianayto yul yanma yin̈ tzet chal Comam. Caw xin yohtaxapaxo Comam mac chianico yul iskꞌab ebnaj ayco ishowal yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yuxinto yalpaxo Comam hacaꞌ tiꞌ: —Caw chiwalan teyet tato caw machi hunu mac chaco isba yul inkꞌaban tato maẍtaj Inmaman chichejniti wetan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yet yaben anma tzet yal Comam tuꞌ xin, txꞌiꞌal anma bejnicano yecꞌ yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yuxinto iskꞌambe Comam tet ebnaj cablahon̈wan̈ iscuywom: —Haxa hex tiꞌ, ¿chimheyoche chextopaxoj? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Istakꞌwi naj Simón Pedro, tet Comam: —Mamin, maccꞌanab yinta chon̈oc tzujnojan̈, yuto han̈cꞌan̈e hatzotiꞌ chiakꞌni kꞌinale mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wal han̈on̈tiꞌan̈, caw xajaytojan̈ yul janmahan̈ tawin̈. Caw xin johtajan̈ tato ach tiꞌ Cristo hach, Iscꞌahol Comam Dios caw itzitz, ẍi naj Pedro tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yalni Comam tet naj: —Wal xin quexinsayilojan hecablahon̈wan̈il, yaj ay huneꞌ hex tiꞌ ayayto naj matzwalil yul yanma, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yet yalni Comam hacaꞌ tuꞌ, yin̈ naj Judas, iscꞌahol naj Simón Iscariote yal Comam. Yuto waxan̈ca ayco naj yetbiho ebnaj cablahon̈wan̈, yaj xin haꞌ naj anico Comam yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lahwi tuꞌ xin, istzabnico Comam Jesús yecꞌ yul ismajul Galilea. Matxa isje iscꞌul Comam ehoyo yul ismajul Judea yuto caw chiyoche ebnaj yahawil yin̈ ebnaj Israel yakꞌaꞌ camo Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Toxa xin chiichico huneꞌ kꞌin̈ Poy telaj isbi, huneꞌ iskꞌin̈ anma Israel, ");
INSERT INTO jacNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","yalni ebnaj yuẍta Comam tuꞌ tet: —Mach chaẍcan bey tiꞌ, wal xin asiꞌ bey Judea bay caw ay anma chicuywi tawintaj, haxinwal chil anma cꞌaybalcꞌule chi-la-hawatxꞌe tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yuto ta ay hunu mac choche chiohtan̈elaxi mach chiswatxꞌe hunu tzet ye tuꞌ bay ewan, yuxin yilal hayeni sunil cꞌaybalcꞌule chi-la-hawatxꞌe tiꞌ yin̈ sat anma, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hac tuꞌ yute yalni ebnaj yuto mach chayto ebnaj yul yanma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yuxinto yal Comam tet ebnaj hacaꞌ tiꞌ: —Maẍto chiapni istzꞌayical inyenilo inbahan tet anma, wal hex tiꞌ, tzijxan̈e tzꞌayical cꞌul heyenilo heba. ");
INSERT INTO jacNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Anma yul sat yiban̈kꞌinal tiꞌ mach chexisyaha, walinan xin caw caj chinillaxan, yuto chiwalan tato caw machiswalil sunil tzet chiswatxꞌe anma. ");
INSERT INTO jacNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Asiꞌwe hex tiꞌ yin̈ kꞌin̈ tuꞌ, walinan mach chintohan, yuto maẍto chiapni istiempohal inyenilo inbahan tet anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yet lahwi yalni Comam huntekꞌan tiꞌ tet ebnaj xin, iscancano Comam bey Galilea. ");
INSERT INTO jacNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yet xato ebnaj yuẍta Comam Jesús tuꞌ yin̈ kꞌin̈ istopaxo Comam, yaj yin̈ ewantajil. ");
INSERT INTO jacNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Caw xin chissayicꞌo ebnaj iswiꞌehal ebnaj Israel tuꞌ Comam Jesús yin̈ kꞌin̈ tuꞌ, chalni ebnaj: —¿Baytaxca tuꞌ ay huneꞌ naj winaj tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Caw xin nanantaxan̈e chal anma yin̈ Comam, ay anma chalni: “Caw cꞌulcano huneꞌ naj tuꞌ,” ẍi. Aypaxo anma chihalni: “Caw machiswalil huneꞌ naj tuꞌ, caw ton̈e chiyakꞌ subchaho naj anma,” ẍipaxoj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yajaꞌ xin caw ewanta chitzotel anma tuꞌ yuto caw chixiw anma tet ebnaj yahawil yin̈ anma Israel. ");
INSERT INTO jacNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hayet caw niman kꞌin̈ tuꞌ, yocto Comam Jesús yul yatut Comam Dios, istzabnico Comam iscuyni anma. ");
INSERT INTO jacNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Caw xin chicꞌay iscꞌul ebnaj Israel tuꞌ yaben tzet chal Comam. Chi-la-yalni ebnaj hacaꞌ tiꞌ: —¿Tzet chute huneꞌ naj tiꞌ yohtan̈enilo sunil huntekꞌan tiꞌ? Yaj mach cuywina naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Istakꞌwican̈ Comam tet ebnaj: —Haꞌ cuybanile chiwalan teyet tiꞌ mach wetojan inchuquilan, yet Comam chejn̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tato ay mac chiyoche chisyije tzet chal Comam Dios, caw yilal istxumniloj tato yet Comam ye cuybanile tiꞌ. Yohtapaxoj ta maẍtaj yul inwiꞌan inchuquilan chiwitijan cat xin walnihan teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Macn̈eticꞌa yul iswiꞌ chiyiti tzet chiyakꞌ iscuyuꞌ anma, chiyute huneꞌ tuꞌ yun̈e yoc iswinajil sata anma. Wal hanin chejbilintijan yu Comam Dios, haꞌ yalaxico ismay Comam yu anma haꞌ chinsayan, yuxin caw isyelal sunil tzet chiwaltiꞌan, caw machi lekꞌtiꞌal yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Caw akꞌbil isley Comam Dios teyet yu naj Moisés, yajaꞌ machi hunujex cheyije tzet chal huneꞌ ley tuꞌ. ¿Tzet yin̈ yuxinto chinhepotxꞌan heyalni? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Istakꞌwi ebnaj xin, yalni ebnaj tet Comam: —Etzan̈em ay hunu ischejab naj matzwalil ayco tawin̈. ¿Mac chachakꞌni camo hawalni? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yalnipaxo Comam tet ebnaj: —Yu huneꞌ cꞌaybalcꞌule inwatxꞌehan yin̈ huneꞌ tzꞌayical xewilal caw hesunil chicꞌayilo hecꞌul yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hatax ebnaj heyichmam ichencanocan̈ huneꞌ circuncisión, haꞌ xin naj Moisés chihalni tato caw yilal isyijelaxi. Yuxinto waxan̈ca yin̈ istzꞌayical xewilal, cheyakꞌ circuncidar niẍte unin winaj semanahil ixto ispitzcꞌahi. ");
INSERT INTO jacNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Walex hex tiꞌ, istzꞌayicalojab xewilal masan cheyakꞌ circuncidar niẍte unin yun̈e mach cheman̈cꞌo isley naj Moisés heyalni. Tato caw hac tuꞌ cheyute, ¿tzet yin̈ yuxinto caw chichiwa hecꞌul win̈an yuto yet istzꞌayical xewilal wakꞌni cawxojan huneꞌ naj? ");
INSERT INTO jacNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mach ton̈eho chexoc heyilaꞌ yin̈ tzet chiswatxꞌe anma. Tato cheyoche chexoc heyilaꞌ tzet yehi, ilwe yin̈ caw istoholal, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ay xin huntekꞌan ebnaj ah Jerusalén halni hacaꞌ tiꞌ: —¿Machmi taj naj tiꞌ chal ebnaj ispotxꞌoꞌ? ");
INSERT INTO jacNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Caw yin̈ sat anma lan̈an istzotel naj lah, yaj machi hunu mac chicachni naj istzoteli. ¿Mato xayayto ebnaj jahawil tiꞌ yul yanma tato haꞌ naj tiꞌ Cristo? ");
INSERT INTO jacNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yet chul Comam Cristo tuꞌ, machi hunu mac ohtan̈e baytuꞌwal chi-caw-istiticoj. Wal naj tiꞌ xin caw johtaj baytuꞌwal titnaco naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yet yaben Comam yalni ebnaj hacaꞌ tuꞌ, haꞌ ton yet lan̈an iscuywa Comam yul yatut Comam Dios, yalni Comam yin̈ caw ip: —Caw quinheyohtajan heyalni, yeb xin heyohtaj baytuꞌwal titnaj inpaxojan. Yajaꞌ caw maẍtajinan witi inbahan inchuquilan, wal xin chejbilintijan yu Comam Dios, Comam caw isyelaln̈eticꞌa chala, yaj mach heyohtajo Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wal intiꞌan caw wohtajan Comam tuꞌ, yuto yin̈ Comam titnajinan, haꞌ quinanitijan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yet lan̈an yalni Comam huneꞌ tuꞌ xin, ay huntekꞌan ebnaj yoche inoto Comam yul teꞌ, yaj xin machi hunu mac tzabnayo Comam, yuto maẍto chiapni istiempohal bay chicami. ");
INSERT INTO jacNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Caw xin hantan̈e mac chanayto yul yanma yin̈ Comam, chi-la-yalni hacaꞌ tiꞌ: —Yet chihul Comam Cristo tuꞌ, ¿tom caw ecꞌbalto cꞌaybalcꞌule chisye sata sunil tzet chisye naj tiꞌ jet? ẍi anma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yet yaben ebnaj fariseo tzet yal anma yin̈ Comam Jesús tuꞌ, iscutxbanayo isba ebnaj yeb xin ebnaj yahawil sacerdote, ischejnito ebnaj ebnaj mayor chitan̈en yatut Comam Dios yu istzabnayo ebnaj Comam, cat yanicto Comam yul preso. ");
INSERT INTO jacNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yalni Comam hacaꞌ tiꞌ: —Hanicꞌxan̈echꞌan tiempohal ayinicꞌojan texol, cat xin inpaxtojan iscꞌatan̈ Comam chejn̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hex tiꞌ chexoc saywal win̈an, yaj matxa chinilchahan heyu, yuto mach chu heyapni bay chinapnituꞌan, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yichico ebnaj yahawil con̈ob Israel tuꞌ iskꞌamben tet hunun hacaꞌ tiꞌ: —¿Baytaxca tuꞌ chito naj tiꞌ, yuxin chal naj tato matxa chiilcha naj ju? Ay ebnaj jet con̈ob pujanto xol ebnaj griego, ¿ham tuꞌ chito naj cuywal xol ebnaj, cat yoc naj iscuyno ebnaj griego tuꞌ yalni? ");
INSERT INTO jacNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tzet caw chalilo huneꞌ chal naj tiꞌ: “Chinhesayaꞌan, yaj matxa chinilchahojan heyu, yuxinto mach chiyu heyapni bay chinapnituꞌan?” ẍi naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Haꞌ islahobal tzꞌayic kꞌin̈ tuꞌ, haꞌ caw ay yelapno ye yul sat anma Israel. Yin̈ huneꞌ tzꞌayic tuꞌ xin, ah lin̈no Comam Jesús, yalni Comam yin̈ caw ip hacaꞌ tiꞌ: —Maquex chitaj hetiꞌ titan̈we incꞌatan̈an, cat heyucꞌni huneꞌ ha haꞌ chiwakꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hacaꞌ yalni yul Yum Comam Dios bay chala: “Haꞌ mac chianayto yul yanma win̈an, hacaꞌ chiyu ispitzcꞌa isnukꞌ ha haꞌ chiel yojomal, hac tuꞌ chiyu ispitzcꞌa isnukꞌ haꞌ yet kꞌinale yul yanma,” ẍiayoj, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yal Comam Jesús huneꞌ tiꞌ yin̈ Comam Espíritu Santo chischah macta chianayto yul yanma yin̈ Comam. Yet huneꞌ tiempohal tuꞌ xin, maẍto chiayilo Comam Espíritu Santo isyayil maẍto chiilaxto Comam yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yet yaben anma cutxanico tuꞌ yin̈ tzet yal Comam Jesús, ay anma halni hacaꞌ tiꞌ: —Yin̈ caw yeli, haꞌ naj tiꞌ ischejab Comam Dios halbilcanoj ta chuli, ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aypaxo mac halni hacaꞌ tiꞌ: —Haꞌ ton naj tiꞌ Cristo, echmabil yul ju, ẍi. Aypaxo huneꞌxa majan anma halni: —Naj Cristo tuꞌ, ¿tom Galilea chitit naj heyalni? ");
INSERT INTO jacNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chal yul Yum Comam Dios tato haꞌ bey yul con̈ob Belén, yul iscon̈ob naj rey David chipitzcꞌa naj Cristo tuꞌ, yuto yuninal yuninal naj rey David ye naj, ẍi hunmajanxa anma. ");
INSERT INTO jacNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hac tuꞌ yu ispohnito isba anma yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aypaxo ebnaj xin etza inito Comam yul preso, yaj machi hunu mac yaco iskꞌab yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Haxa yet ismeltzo ebnaj chitan̈en yatut Comam Dios iscꞌatan̈ ebnaj fariseo, iskꞌamben ebnaj tet ebnaj: —¿Tzet yin̈ yuxinto machi maxeyiti naj Jesús tuꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yalni ebnaj chitan̈en yatut Comam Dios tuꞌ hacaꞌ tiꞌ: —Caw machi hunu mac caw helan istzotel hacaꞌ istzotel naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yalni xin ebnaj fariseo tuꞌ tet ebnaj: —¿Tom haꞌ hunex cheyakꞌ subchaho heba tet huneꞌ naj tuꞌ? ");
INSERT INTO jacNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Tom ay hunu ebnaj yahawil chianayto yul yanma yin̈ tzet chal naj, maca hunujon̈an̈ han̈on̈ fariseo on̈tiꞌan̈? ");
INSERT INTO jacNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Han̈cꞌan̈e huntekꞌan anma caw mach yohtajo isley naj Moisés, haꞌ chisubcha yu naj, yajaꞌ xin chiay isyaꞌtajil yiban̈ huntekꞌan anma tuꞌ yu Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ay xin huneꞌ naj fariseo Nicodemo isbi, naj beycꞌo tzotelo tet Comam yin̈ huneꞌ akꞌbalil, haꞌ naj xin halni tet ebnaj yetbi tuꞌ: ");
INSERT INTO jacNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Haꞌ chiyute yalni coley tato mach chu iscawxico ismul hunu naj yiban̈ yalan̈to maẍto chijabe tzet chal naj, yun̈e johtan̈eniloj tzet iswatxꞌe naj, ẍi naj Nicodemo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yuxinto yal ebnaj yetbi naj tuꞌ tet: —¿Tom ah Galilea hachpaxoj? Wal xin say yul Istzotiꞌ Comam Dios cat hawilni tato ay hunu ischejab Comam Dios chitit bey Galilea tuꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Lahwi tuꞌ xin, ispaxto ebnaj yatut. ");
INSERT INTO jacNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wal Comam Jesús xin to Comam bey huneꞌ won̈an, Olivo isbi. ");
INSERT INTO jacNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yin̈ huneꞌxa tzꞌayical xin, yapni Comam hunelxa yul yatut Comam Dios yin̈ caw sahab sacꞌayal. Caw xin hantan̈e anma apni iscꞌatan̈ Comam. Lahwi tuꞌ xin, yay tzꞌon̈no Comam istzabnico iscuyni anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hunepixto xin yiniti ebnaj fariseo yeb ebnaj chicuyni anma yin̈ isley naj Moisés huneꞌ ix ix tet Comam. Caw cꞌuxan ischahlo ix yin̈ ismul yu ebnaj. Yalaxico ix xol anma cutxanico iscꞌatan̈ Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yalni ebnaj tet Comam: —Mam cuywawom, machahlo huneꞌ ix tiꞌ juhan̈ iscꞌatan̈ iswinaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wal xin, chal isley naj Moisés tato ebix ix txꞌoj ye iswiꞌ hacaꞌ huneꞌ ix tiꞌ, yilal iskꞌojlax camo ebix, yajaꞌ ¿tzimi chawute hawalnipaxo hach tiꞌ? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yal ebnaj hacaꞌ tuꞌ yun̈e yilwen ebnaj Comam, yeb yun̈e yaycꞌay Comam yin̈ hunu istxꞌojal, cat xin yoc ebnaj akꞌocꞌule yin̈ Comam, chute yalni. ");
INSERT INTO jacNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaj xin ton̈e ay cꞌon̈no Comam, istzabnico istzꞌibli sat txꞌotxꞌ yu yiximal iskꞌab. Ayn̈eticꞌaco xin ebnaj iskꞌamben tet Comam tzet caw chielcanico ix, yuxinto ah tꞌan̈no Comam, yalni hacaꞌ tiꞌ: —Macn̈eticꞌa caw machi nichꞌano ismul texol, haꞌojab babel chꞌakꞌni chꞌen kꞌojbal yin̈ ix, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lahwi tuꞌ yaypaxo cꞌon̈no Comam, istzabnico istzꞌibli sat txꞌotxꞌ hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yet yaben ebnaj tzet yal Comam tuꞌ, istxumni isba yanma ebnaj ta machi hunu ebnaj cꞌul, yuxin hununtajil yu yel ebnaj iscꞌatan̈ Comam. Babel el ebnaj ecꞌna ichamtaxa, lahwi tuꞌ istopaxo ebnaj tzehtaj. Hac tuꞌ yu iscancano Comam ischuquil yeb ix tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lahwi tuꞌ xin, yah lin̈no Comam, iskꞌamben Comam tet ix: —Ix, ¿baytuꞌwal ay ebnaj chiakꞌwi cꞌule tawin̈? ¿Tom caw machi hunu ebnaj macachkꞌojnican̈ yu chꞌen chꞌen? ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Macho Mamin, machi hunu maca, ẍi ix tet Comam. —Haquinpaxtuꞌan, mach chiwalan ta chaẍkꞌojlax camo yu hamul. Asiꞌ xin, matxa chawaco hamul hunelxa, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yalnipaxo Comam tet anma hunelxa: —Wal hanintiꞌan, caw hacaꞌ issajilkꞌinal wehayojan xol anma yul sat yiban̈kꞌinal tiꞌ. Macn̈eticꞌa chꞌoc tzujno wintajan chiwakꞌan issajilkꞌinal yul yanma. Yu huneꞌ issajilkꞌinal tiꞌ xin, chischah iskꞌinal mach istan̈bal. Matxa xin chiecꞌ xol kꞌejholo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yalni ebnaj fariseo xin: —Caw matzet chalilo tzet chawal tiꞌ, yuto hach tiꞌ, hach caw chachtzotel tawin̈, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Istakꞌwi Comam: —Waxan̈ca caw han-caw-inan chiwalan yin̈ tzet wehan, yaj caw isyelal sunil tzet chiwalan. Yuto hanintiꞌan wohtajan baytuꞌwal titnajinan, caw wohtapaxojan baytuꞌwal chi-caw-intocojan. Walex hex tiꞌ, caw mach heyohtajo baytuꞌwal titnajinan, yeb baytuꞌwal chintopaxojan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Walex hex tiꞌ, caw comonn̈eticꞌa chexoc heyilaꞌ tzet ye anma, yaj walinan mach ton̈eticꞌaho chinocan wilaꞌan tzet chielico anma. ");
INSERT INTO jacNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yajaꞌ yet chiwilnihan yin̈ tzet chielico anma, chiwilan yin̈ caw istoholal, yuto mach inchuquilojan chiwilan tzet chielico anma, to haꞌ hun Inmaman an̈eintijan, haꞌ chiilni tzet chielico anma wintajan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chal hecuybanil tato ay cawan̈o testigo lahan yalni yin̈ hunu tzet ye tuꞌ, caw yel huneꞌ tuꞌ chal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ilwecꞌanab xin, ay cawan̈ mac chakꞌ testigohal. Caw testigo wehicojan win̈an, yeb xin Inmaman an̈eintijan haꞌ chitzotel win̈an, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lahwi tuꞌ xin iskꞌamben ebnaj tet Comam: —¿Baytuꞌwal ay hamam tuꞌ xin? ẍi ebnaj. Istakꞌwi Comam tet ebnaj: —Hex tiꞌ, mach quinheyohtajojan, caw xin mach heyohtajo Inmamtuꞌan. Kꞌinalo tato quinheyohtajan, heyohtapaxo Inmaman, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hayet iscuywa Comam Jesús yul yatut Comam Dios yalnicano Comam huntekꞌan tiꞌ, iscawilal bay chibey anma yakꞌaꞌcano yofrenda. Yaj xin machi hunu mac tzabnayo Comam, yuto maẍto chiapni istzꞌayical bay chicami. ");
INSERT INTO jacNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yalnipaxo Comam Jesús hunelxa: —Hanintiꞌan chintohan, wal xin chinhesayaꞌcojan yajaꞌ mach chinilchahan heyu, yuto mach chu heto bay chintotuꞌan. Walex hex tiꞌ yin̈ hemul chexcamcantoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yuxin yal ebnaj yahawil yin̈ con̈ob Israel: —¿Tom xin chispotxꞌ isba naj, yuxinto chal naj tato caw mach chu japni bay chiapni naj tuꞌ? ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yalnipaxo Comam tet ebnaj: —Walex hex tiꞌ, caw yet sat txꞌotxꞌal heyehi, wal intiꞌan yet satcan̈ wehan, caw yet yul sat yiban̈kꞌinal tiꞌ heyehi, wal inpaxojan mach yeto sat yiban̈kꞌinal tiꞌ wehan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yuxinto caw chiwalan teyet tato yin̈ hemul chexcami, yuto mach chechayto yul heyanma tato haninan huneꞌ hacaꞌ chiwute walnihan teyet, yuxinto caw yin̈ hemul chexcamtoj, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iskꞌambenpaxo ebnaj tet Comam: —¿Mac hach anmahil chal tuꞌ? ẍi ebnaj. Yalni Comam tet ebnaj: —Halbilxaticꞌa teyet wuhan yet yalan̈tocanoj mac anmahilinan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Caw hantan̈e tzet chiwalan teyin̈ yet chiwilnihan yin̈ tzet chexelicoj. Yaj Comam an̈eintijan texol tiꞌ, caw yin̈ isyelal chitzoteli. Yuxinto haꞌ tzet halbil wetan yu, haꞌ chiwalpaxojan tet anma ay yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yaj xin caw maẍticꞌa txumchalo yu ebnaj tato haꞌ Comam Dios chal Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yuxinto yal Comam tet ebnaj: —Hayet chinheyanican̈an yin̈ teꞌ culus, haꞌ to tuꞌ chitxumchalo heyu tato Hanin Akꞌbilintijan texol yu Comam Dios, cat xin heyohtan̈eniloj tato mach wetojan inchuquilan sunil tzet chiwaltiꞌan. Wal xin haꞌ tzet chal Inmaman wetan, haꞌ chiwalan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Haꞌ Comam an̈eintijan, haꞌ ayco wetbihojan. Caw mach chinisbejcanojan inchuquilan, yuto han̈cꞌan̈e tzet choche iscꞌul chinwatxꞌehan yin̈ sunilbal tiempo, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yet yalni Comam huntekꞌan tuꞌ, caw hantan̈e anma chahni Comam yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yalni Comam Jesús tet anma Israel chahni Comam yul yanma: —Tato caw huneln̈e cheyayto yul heyanma yin̈ tzet chiwalan, yin̈ caw yeli incuywoman heyehi. ");
INSERT INTO jacNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hac tuꞌ xin chu heyohtan̈enilo isyelal; haꞌ isyelal tuꞌ xin, haꞌ chexcolnicanoj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yalni ebnaj tet Comam: —Han̈on̈tiꞌan̈ jichmaman̈ ye icham Abraham, caw machi hunelo con̈txon̈laxan̈ tet anma. ¿Tzet yin̈ yuxinto chawala “chexcolchacanoj?” cachi, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Istakꞌwi Comam tet ebnaj: —Yin̈ caw yeli chiwalan teyet, mac caw mach chisbejcano yanico ismul, caw txon̈bil isba tet mule. ");
INSERT INTO jacNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kꞌinalo hunu naj txon̈bil chejabo tet huno yahaw tinan̈, mach chiyu yoc naj yetbiho yuninal naj yahawil tuꞌ yin̈ huneln̈e. Wal hacaꞌ naj cꞌahole xin, caw yetbiticꞌa isba naj yeb ismam yeb ismiꞌ yeb ej yuẍtaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yuxin tato haninan chexincolilojan yin̈ hemul, yin̈ caw yeli chexcolchacanoj yuto caw Iscꞌahol Dios wehan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Caw wohtajan tato heyichmam icham Abraham, yaj caw cheyoche quinhepotxꞌoꞌan, yuto mach cheyoche heyabeꞌ cuybanile chiwakꞌtiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Haꞌ tzet wilan bey Inmamtuꞌan, haꞌ chiwalan teyet, walex hex tiꞌ caw nan hemam, yuxinto haꞌ tzet chal hemam tuꞌ haꞌ chewatxꞌe, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Istakꞌwipaxo ebnaj: —Wal han̈on̈tiꞌan̈, comaman̈ jichmam Abraham, ẍi ebnaj. Istakꞌwi Comam: —Tato caw yel cheyala hemam ye icham Abraham tuꞌ, ham tzet iswatxꞌe icham, haꞌ chewatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wal xin waxan̈ca haꞌ caw isyelal halbil wetan yu Comam Dios haꞌ chiwalan teyet, yaj caw cheyoche quinheyakꞌaꞌ camojan. Wal icham Abraham cheyal tiꞌ, machi hunelo yute isba icham hacaꞌ hex tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Haꞌticꞌa tzet chiswatxꞌe hemam, haꞌ cheyupaxoj, ẍi Comam tet ebnaj. Yuxinto yal ebnaj: —Wal han̈on̈tiꞌan̈, mach matn̈ebilon̈an̈, wal xin huneꞌchꞌan comaman̈, haꞌ ton Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yalnipaxo Comam: —Tato yeli hemam Comam Dios tuꞌ, xahanmi chinheyilan, yuto haꞌ bay ay Comam Dios titnajinan yet wulan bey tiꞌ, Maẍtajinan witi inbahan inchuquilan, haꞌ Comam Dios chejn̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tzet yin̈ xin mach chitxumchalo tzet chiwaltiꞌan heyu? ");
INSERT INTO jacNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Walex hex tiꞌ, haꞌ naj matzwalil, haꞌ naj caw hemam, yuto hatzet choche iscꞌul naj, haꞌ caw choche hecꞌul hewatxꞌeꞌ. Naj matzwalil tuꞌ, caw potxꞌom anma naj yichtaxticꞌa yul naj sat yiban̈kꞌinal tiꞌ. Caw maẍticꞌa isyelal yin̈ naj, yuxin sunil tzet chiahti yul istiꞌ naj mach yeloj. Hayet chanico naj lekꞌtiꞌal, haꞌ tzet ye naj haꞌ chal naj, yuto caw lekꞌtiꞌ naj; caw ismam lekꞌtiꞌwom naj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wal hanintiꞌan, haꞌ caw isyelal chiwalan, yuxinto caw mach cheyayto yul heyanma tzet chiwaltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Mac hunujex tiꞌ tinan̈ chiyu heyalnico yin̈ insatan tato ay inmulan? Wal xin, caw isyelal sunil tzet chiwaltiꞌan, yaj ¿tzet yin̈ xin mach cheyayto yul heyanma? ");
INSERT INTO jacNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Haꞌ mac yet Comam Dios yehi, caw choche yabeꞌ Istzotiꞌ Comam. Walex hex tiꞌ xin, mach yeto Comam Dios heyehi, yuxinto mach chiyoche hecꞌul heyabeꞌ Istzotiꞌ Comam, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yalni ebnaj yahawil yehico yin̈ anma Israel tuꞌ tet Comam Jesús: —Haꞌ ye juhan̈ chijalnihan̈ ta ah Samaria hach, yeb ta ayco huneꞌ ischejab naj matzwalil tawin̈, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Istakꞌwi Comam Jesús xin: —Machoj, machi huno ischejab naj matzwalil ayco win̈an, walxinto haꞌ wanicojan ismay Inmaman haꞌ chiwuhan, walex hex tiꞌ chinhehincaniltojan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wal hanintiꞌan, maẍtaj yalaxico inmayan chinsayan; waxan̈ca ay huneꞌ Mac chianico inmayan, haꞌ huneꞌ tuꞌ xin chihalnoj Mac caw yel chala. ");
INSERT INTO jacNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yin̈ caw isyela chiwalan teyet, macn̈eticꞌa chiyijen tzet chiwaltiꞌan, machi bakꞌinal chicami, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Yalni ebnaj: —Wal xin caw yel chijalan̈ tato ayco hunu ischejab naj matzwalil tawin̈. Icham Abraham yebpaxo xin ebnaj ischejab Comam Dios yet payxa, sunil ebnaj camnatoj. Wal chawute hawalnipaxo xin: “Macn̈eticꞌa chiyijen tzet chiwalan maẍticꞌa chicamtoj,” cachi. ¿Tom caw ecꞌbal hach to sata jichmam Abraham tuꞌan̈ yeb sunil ebnaj ischejab Comam Dios ecꞌlena yet payat tiempo tuꞌ? ¿Tzet yelapno hawe hawalni? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yuxinto yalpaxo Comam tet ebnaj: —Tato han-caw-inan chiwican̈ inbahan, caw matzet chalilo huneꞌ tuꞌ, yaj wal xin haꞌ caw Inmaman chianico inmayan. Haꞌ Inmamtuꞌan xin, haꞌ cheyal heDiosaloj. ");
INSERT INTO jacNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yaj hex tiꞌ, mach heyohtajo Inmamtuꞌan, walinan, caw wohtajan. Yaj tato chiwalan ta mach wohtajojan Inmamtuꞌan, lahanmi inlekꞌtiꞌalan yeb hex chal tuꞌ. Wal xin caw chiwalan caw wohtajan Inmaman, yuxinto sunil tzet chal Inmaman wetan chinyijehan. ");
INSERT INTO jacNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Icham heyichmam Abraham tuꞌ, caw tzala iscꞌul icham yet yabeni ta chinhulan. Hayet isyelax tet icham xin, caw tzalacanocan̈ iscꞌul icham sicꞌlebil, ẍi Comam tet ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yalnipaxo ebnaj tet Comam: —Hach tiꞌ, maẍto hach yin̈ cincuenta habil, cat xin hawalni ta hawil icham Abraham tuꞌ: ");
INSERT INTO jacNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yalni Comam: —Yin̈ caw isyelal chiwalan teyet, yettax yalan̈to maẍto chipitzcꞌa icham Abraham tuꞌ, ay inxaticꞌahan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hac tuꞌ xin, yu yinican̈ ebnaj chꞌen chꞌen yun̈e iskꞌojni camo ebnaj Comam yalni. Yaj yebato isba Comam tet ebnaj, yelti Comam yul yatut Comam Dios tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yet yecꞌ Comam Jesús yin̈ isbel hunel, yilni Comam huneꞌ naj caw maẍticꞌa chu yilni yettaxticꞌa ispitzcꞌahi. ");
INSERT INTO jacNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iskꞌamben ebnaj chicuywi yinta Comam tuꞌ: —Mam cuywawom, ¿tzet yin̈ yuxin mutzꞌan sat huneꞌ naj tiꞌ yet ispitzcꞌa naj? ¿Tom yu ismul ismam naj mato yu ismul naj? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yalni Comam xin: —Maẍtaj yu ismul ismam naj yeb ismiꞌ naj, maẍtajpaxo yu ismul naj yuxinto hac tuꞌ ye naj. Wal xin Comam Dios caw choche iscꞌul chisyelo yip yin̈ naj, yuxinto hac tuꞌ ye naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Caw yilal inwatxꞌenan ismunil Comam an̈eintijan yakꞌ isba tzꞌayical to yucꞌaꞌ chiah akꞌbal yet matxa chu comunlahi. ");
INSERT INTO jacNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yakꞌ isba ay intocꞌojan yul sat yiban̈kꞌinal tiꞌ caw hacaꞌ issajilkꞌinal wehayojan xol sunil anma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yet lahwi istzotel Comam xin, istzublayo Comam sat txꞌotxꞌ, issomni Comam nichꞌan tzꞌotzꞌew yu iskꞌab, lahwi tuꞌ xin ismasnico Comam yin̈ isbakꞌsat naj mutzꞌan sat tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yalni Comam tet naj: —Asiꞌ bey haꞌ Siloé, huneꞌ haꞌ etxan, cat xin hatxꞌahnilo hasat, ẍi Comam tet naj. (Siloé chiyal yelapnoj Akꞌbiltij.) Hac tuꞌ xin yu isto naj bey haꞌ Siloé tuꞌ, istxꞌahni naj sat xol haꞌ. Haxa yet ispaxti naj xin, xayu yilni naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yuxin haꞌ anma ayayo yatut iscawilal naj yeb huntekꞌanxa anma ohtan̈e naj, yal hacaꞌ tiꞌ: —¿Cochan haꞌ naj tiꞌ chiecꞌ tzꞌon̈la kꞌano melyu? ẍi anma tuꞌ yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ay mac xin halni: —Hoꞌ, haꞌ naj tiꞌ, ẍi anma. Aypaxo mac halni: —Machoj, maẍtaj naj, yaj etza hac tiꞌ jilni naj, ẍipaxoj. Wal naj xin yal naj: —Hoꞌ, hanin-ton-an, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yoc anma iskꞌambeno tet naj: —¿Tzet xin mayu ishajlo hasat? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yalni naj xin: —Huneꞌ yaꞌ, Jesús isbi, haꞌ yaꞌ somni nichꞌan tzꞌotzꞌew, ismasnico yaꞌ yin̈ insatan. Lahwi tuꞌ xin, yalni yaꞌ wetan: “Asiꞌ bey haꞌ Siloé, cat hatxꞌahnilo hasat xol haꞌ,” ẍi yaꞌ wetan. Hac tuꞌ yu intohan intxꞌahnolojan insattiꞌan; lahwi tuꞌ xin ishajlo insatan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iskꞌamben ebnaj tet naj: —¿Baytuꞌwal xin ay naj tinan̈? ẍi ebnaj. —Caw mach wohtajojan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lahwi tuꞌ xin, yilaxto naj mutzꞌanticꞌa sat tuꞌ tet ebnaj fariseo. ");
INSERT INTO jacNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yet iswatxꞌen Comam nichꞌan tzꞌotzꞌew yun̈e ishajlo sat naj tuꞌ, caw cꞌuxan istzꞌayical xewilal. ");
INSERT INTO jacNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yuxinto ocpaxo ebnaj fariseo tuꞌ iskꞌambeꞌ tet naj hunelxa: —¿Tzet yu ishajlo hasat tiꞌ? ẍi ebnaj tet naj. Istakꞌwi naj: —Yaꞌ Jesús masnico nichꞌan tzꞌotzꞌew yin̈ insatan, lahwi tuꞌ xin intohan intxꞌahnolojan; hac tuꞌ xin yu ishajlo insatan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ay xin ebnaj fariseo halni: —Huneꞌ naj tuꞌ, caw mach yeto Comam Dios ye naj yuto mach chisyije naj istzꞌayical xewilal, ẍi ebnaj yin̈ Comam. Yaj ay ebnaj halnipaxoj: —Yaꞌ Jesús tuꞌ, mach mulumo yaꞌ. Wal xin tato mulum yaꞌ, ¿tom chiyu isyeni yaꞌ hunu cꞌaybalcꞌule hacaꞌ chisye tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yocpaxo ebnaj fariseo iskꞌambeno tet naj maẍticꞌa chiyu yilni tuꞌ: —Haxa hach tiꞌ, ¿tzet chawute hawalni yin̈ naj akꞌni hajlo hasat tiꞌ? ẍi ebnaj. Yalni naj hacaꞌ tiꞌ: —Haꞌ huneꞌ chiwute walnihan, to caw ischejab Comam Dios ye yaꞌ, ẍipaxo naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yaj caw maẍticꞌa yaco ebnaj yahawil con̈ob Israel tuꞌ yin̈ iscꞌul tato hajlo sat huneꞌ naj tuꞌ yu Comam. Haꞌ yute isnani ebnaj to caw cꞌulticꞌa ye sat naj, yuxinto awtelax ismam naj yeb ismiꞌ naj yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iskꞌamben ebnaj tet ismam naj yeb ismiꞌ naj hacaꞌ tiꞌ: —¿Ham naj tiꞌ, heyuninal cheyala tato caw maẍticꞌa chu yilni yet ispitzcꞌahi? ¿Tzet yu ishajlo sat naj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Istakꞌwi ismam naj yeb ismiꞌ naj: —Caw yeli juninalan̈ naj, caw yelpaxoj maẍticꞌa chiyu yilni naj yet ispitzcꞌa naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yaj caw mach johtajojan̈ tzet yu ishajlo sat naj, yeb xin mach johtapaxojan̈ mac akꞌni hajloho sat naj. ¡Kꞌambewe tet naj yuto ichamxa naj, chiyu yalni naj teyet! ẍi ismam naj yeb ismiꞌ naj tet ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wal xin, hac tuꞌ yute yalni ismam naj yeb ismiꞌ naj yuto caw chixiw tet ebnaj yahawil yehico yin̈ con̈ob Israel, yuto halbil yu ebnaj hacaꞌ tiꞌ: “Macn̈eticꞌa chihalni tato haꞌ naj Jesús tiꞌ Cristo, matxa chicochacti yul capilla tiꞌ,” ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yuxinto hac tuꞌ yute yalni ismam naj yeb ismiꞌ naj: “Kꞌambewe tet naj, ichamxa naj, xayu yalni naj teyet,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lahwi tuꞌ xin, yawtenpaxti ebnaj naj hajlo sat tuꞌ hunelxa, iskꞌamben ebnaj tet naj: —Caw chabe Comam Dios caw halilo isyelal jetan̈, wal xin caw johtajan̈ ta caw mulum huneꞌ naj chawal tiꞌ, ẍi ebnaj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yalni naj xin: —Hanintiꞌan, caw mach wohtajojan tato mulum yaꞌ maca machoj, yuxin mach chiyu walnihan teyet; hachcachann̈e wohtajan to maẍticꞌa chiyu wilnihan yet yalan̈tocanoj, wal tinan̈ xin xayu wilnihan, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iskꞌamben ebnaj hunelxa: —¿Tzet caw caẍyute naj? ¿Tzet caw yu ishajlo hasat tiꞌ yu naj? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yalni naj xin: —Caw mawalan teyet, yaj to caw mach cheyaco yin̈ hecꞌul. ¿Tzet yin̈ xin cheyoche chiwalan teyet hunelxa? ¿Mato cheyoche chexocpaxo cuywo yinta yaꞌ? ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yet yalni naj hacaꞌ tuꞌ, istzabnico ebnaj isbahni naj, yalni ebnaj tet naj: —Hach tiꞌ, ayachxaco yinta naj, wal han̈on̈tiꞌan̈ yinta iscuybanil naj Moisés tzujanon̈an̈. ");
INSERT INTO jacNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Walon̈tiꞌan̈ caw johtajan̈ tato haꞌ caw Comam Dios anicano cuybanile tet naj Moisés tuꞌ. Wal naj chawal tiꞌ, caw mach johtajojan̈ baytuꞌwal titnaco naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Istakꞌwican̈ naj tet ebnaj xin: —Caw chicꞌay incꞌulan yuto cheyala tato mach heyohtajo bay titnaco yaꞌ, yajaꞌ caw cheyila hajlo insatan yu yaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Caw johtaj tato mach chabe Comam Dios tzet chiskꞌan anma mulum, hachcachann̈e anma caw ayco yanma yin̈ Comam, cat yinayo isba tet, hachcachann̈e huntekꞌan anma tuꞌ chakꞌ Comam ispaj tzet chiskꞌanaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wal xin, caw maẍto bay chijabe iskꞌumal tato ay huno mac chiyu yakꞌni hajloho sat hunu anma maẍticꞌa chiyu yilni yettaxticꞌa ispitzcꞌahi. ");
INSERT INTO jacNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tato maẍtaj Comam Dios an̈eti yaꞌ tiꞌ, caw machim nino tzet chiyu iswatxꞌen yaꞌ, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Istakꞌwi ebnaj tet naj: —Walach hach tiꞌ, caw mulumach yettaxticꞌa hapitzcꞌahi. ¿Tom chaẍoc con̈hacuyuꞌan̈ hawalni? ẍi ebnaj tet naj, hac tuꞌ yu istennilti ebnaj naj tuꞌ yul capilla. ");
INSERT INTO jacNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yabe Comam Jesús tato tenlaxilti naj hajlo sat tuꞌ yul capilla, haxa yet ischahloyo naj yu Comam, yalni Comam tet naj hacaꞌ tiꞌ: —¿Chimhawayto yul hawanma yin̈ Hanin Akꞌbilintijan texol yu Comam Dios? ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Iskꞌamben naj tet Comam: —Mamin, ¿mac huneꞌ chawal tuꞌ? Hal wetan cat xin wanico wanmahan yin̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yalni Comam tet naj: —Caw xahawil yin̈; Hanintonan huneꞌ mac bay lan̈an hatzotel tiꞌ, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yet yaben naj hacaꞌ tuꞌ, yay jahno naj yin̈ sat Comam, yalni naj: —Caw chiwaco wanmahan tawin̈ Mam, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yalni Comam tet naj: —Wal hanintiꞌan, hulnajinan bey yul sat yiban̈kꞌinal tiꞌ yun̈e wilnihan tzettaj chiꞌelico anma, yuto ay anma tiꞌ caw mach chiyu yilni, yaj xin haninan chiwakꞌ hajlohojan sat. Aypaxo anma caw cꞌul yilni, yaj chimutzꞌicano sat wuhan yun̈e matxa chiyu yilni, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ay xin huntekꞌan ebnaj fariseo ayco iscꞌatan̈ Comam, yet yaben ebnaj yin̈ tzet yal Comam tuꞌ, yalni ebnaj: —¿Tom xin haꞌ hunon̈an̈ mach chiyu jilnihan̈ hawalni? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Istakꞌwi Comam tet ebnaj: —Kꞌinalo tato mach chiyu heyilni tzettaj ye tuꞌ yet Comam Dios yehi, caw machim hemul. Yaj cheyala tato caw chiyu heyilni tzettaj ye tuꞌ yet Comam Dios, yaj mach cheyijepaxoj, yuxinto caw ay hemul, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yalnipaxo Comam Jesús: —Kꞌinaloj ta ay hunu ispeyabil noꞌ meꞌ, cat yocto hunu naj yul, nan bay xin chisholicto isba naj; yin̈ caw isyelal chiwalan teyet, caw elkꞌom huneꞌ naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wal naj chiꞌocto yul ispultahil ispeyab noꞌ tuꞌ, haꞌ ton naj tuꞌ chitan̈en noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Haꞌ naj chiwayn̈en noꞌ xin chishaj naj ispultahil ispeyabil noꞌ tet naj, cat yocto naj iscꞌatan̈ noꞌ. Caw sunil noꞌ kꞌayna yaben yul isnukꞌ naj. Caw hununtajil yawtenilti naj noꞌ, yuto ay isbi hunun noꞌ yu naj, hac tuꞌ xin chiyu ishajnilti naj noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yet chilahwi yinilti naj ismeꞌ tuꞌ, cat xin isbabi naj sata noꞌ, cat yoc tzujno noꞌ yinta naj, yuto caw yohta noꞌ yul isnukꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yajaꞌ wal ta hunu naj comon, mach chꞌoc tzujno noꞌ yinta naj; chixiwilo noꞌ tet naj yuto mach kꞌaynajo noꞌ yaben yul isnukꞌ naj, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yal Comam huneꞌ yechel tiꞌ tet ebnaj, yaj maẍticꞌa txumchalo yu ebnaj tzet caw yelapno yehi. ");
INSERT INTO jacNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yalnipaxo Comam Jesús: —Yin̈ caw yeli chiwalan teyet, hanintiꞌan hacaꞌ ispultahil ispeyab noꞌ meꞌ, caw hac tuꞌ wehan. ");
INSERT INTO jacNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yet yalan̈to yet maẍto chinhulan, ay ebnaj hulicꞌo yanico isba ebnaj hecolomaloj. Haꞌ huntekꞌan ebnaj tuꞌ xin, caw lahan ebnaj hacaꞌ hunu naj elkꞌom chiocto yul ispeyabil noꞌ meꞌ tuꞌ, yaj wal anma caw yetticꞌa Comam Dios ye xin, caw maẍticꞌa ishajba istxiquin yin̈ tzet yal ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hanintiꞌan, lahaninan hacaꞌ ispultahil ispeyabil noꞌ meꞌ, macn̈eticꞌa chiocto yul huneꞌ peyab tiꞌ chicolchahi. Hacaꞌticꞌa hunu noꞌ meꞌ chielti lowoj cat yapnipaxo yul ispeyab, hac tuꞌ xin ye huntekꞌan mac tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ay ebnaj hacaꞌ elkꞌom chiyu yuli, ton̈e chihul elekꞌ yeb xin yakꞌni camo anma. Yaj walinan, hulnajinan wakꞌaꞌan kꞌinale mach istan̈bal tet anma chiyaco isba yul inkꞌaban. Huntekꞌan anma tuꞌ, caw niman chiyu ischahni iscꞌulal iscꞌul Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Wal hanintiꞌan, caw lahaninan hacaꞌ hunu naj tan̈em meꞌ caw cꞌul. Huneꞌ naj tan̈em meꞌ caw cꞌul tuꞌ, caw hinan yanma naj yakꞌni camo isba yin̈ ismeꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wal tato ton̈e chitohlalax hunu naj chitan̈en noꞌ meꞌ tuꞌ, maẍtaj xin naj yahaw noꞌ tuꞌ chitan̈eni. Hayet chiyilni naj yapni noꞌ oj, chisbejcano naj noꞌ cat yelcan̈ naj, yuto mach yeto naj noꞌ, cat yoc noꞌ oj tuꞌ istzabnayo noꞌ, cat xin ispujnacan̈ noꞌ sunil. ");
INSERT INTO jacNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chielcan̈ naj chitan̈en noꞌ, yuto yin̈n̈e istohol naj ayco yanma. Caw mach chicam iscꞌul naj yin̈ noꞌ yuto mach yeto naj noꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Wal hanintiꞌan, caw lahaninan yeb naj tan̈em meꞌ caw cꞌul, haxa mac chaco isba yul inkꞌaban lahan hacaꞌ noꞌ meꞌ. Caw ohtabilinan yu Inmaman, wohtapaxojan Inmamtuꞌan, hac tuꞌ xin wepaxojan yeb macta chaco isba yul inkꞌaban, caw johta cobahan̈ yebi. Yin̈ ton huntekꞌan mac tuꞌ chiwakꞌ camo inbahan. ");
INSERT INTO jacNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aypaxo huntekꞌan anma chinchahnihan yul yanma, ton̈e xin caw mach jet con̈oboj. Caw yilal winitijan cat xin yoc isyijeno cuybanile chiwaltiꞌan, caw xin hunxan̈e chucanoj yeb hunxan̈e mac chitan̈eni. ");
INSERT INTO jacNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Caw xahan ayinan yu Inmaman yu caw chiwakꞌ camo inbahan yin̈ anma, yaj chinchahpaxojan inkꞌinalan hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Chiwakꞌ camo inbahan yuto hac tuꞌ chiel yin̈ incꞌulal. Wal xin, caw machi hunu mac chiyu quinispotxꞌni camojan tato mach chisje incꞌulan. Caw machi hunu mac chincachnihan wakꞌni inbahan yin̈ camical, aypaxo wipan inchahnihan inkꞌinalan hunelxa, yuto hac tuꞌ inchejbanilan yu Inmaman, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yet yaben anma Israel yin̈ tzet yal Comam tuꞌ, ispohnipaxto isba hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ay hun majan anma halni: —¿Tzet yuxin cheyabeto tzet chal naj tiꞌ? Wal huneꞌ naj tiꞌ, caw chabil locohal yu naj, ayco huneꞌ ischejab naj matzwalil yin̈ naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ay hunxa majan anma halnipaxoj hacaꞌ tiꞌ: —Tato ayco hunu ischejab naj matzwalil yin̈ naj, ¿tom hac tuꞌ istzotelo naj? Yalnipaxo ebnaj: —¿Tom chu yu hunu ischejab naj matzwalil ishajni sat hunu naj caw maẍticꞌa chiyu yilni? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yin̈ istiempohal n̈abil chiecꞌtzelax iskꞌin̈ Yatut Comam Dios bey yul con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yet lan̈an yecꞌ Comam Jesús istiꞌ yatut Comam Dios tuꞌ, huneꞌ chiyij Yamakꞌil naj rey Salomón, ");
INSERT INTO jacNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","yoc hoyno ebnaj Israel yin̈ Comam, yalni ebnaj hacaꞌ tiꞌ: —¿Caw bakꞌin chon̈hawilojan̈ yin̈ huneꞌ cabcꞌulal tiꞌ? ¿Mac caw anmahilach? Yin̈ caw yeli, tato hach tiꞌ Cristo hach, caw makꞌbil hawalnilo jetan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Istakꞌwican̈ Comam tet ebnaj: —Caw xawalan teyet, yaj caw mach cheyayto yul heyanma. Sunil cꞌaybalcꞌule chinwatxꞌehan yu yip Inmaman, haꞌ caw chiyeniloj mac anmahilinan. ");
INSERT INTO jacNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Walex hex tiꞌ, caw mach chinhechaytojan yul heyanma, yuto caw maẍticꞌa wetojan heyehi hacaꞌ walnihan yalan̈tocanoj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Macta caw wetan yehi, caw chishajba istxiquin yin̈ tzet chiwalan; caw xin wohtapaxojan huneꞌ mac tuꞌ. Hacaꞌticꞌa chiyu yoc tzujno noꞌ meꞌ yinta istan̈emal, hacpax tuꞌ chiyu yoc tzujno wintajan. ");
INSERT INTO jacNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wal xin, hanan chiwakꞌan iskꞌinal mach istan̈bal, machi bakꞌinal chicami, machi hunu mac xin chiyu yinilo yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wal xin haꞌ Inmaman, caw ecꞌbalcano sata sunil maca, haꞌ akꞌn̈e anma tiꞌ wetan. Caw machi hunu mac chiyu yinilo huntekꞌan tiꞌ yul iskꞌab Inmamtuꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Hanintiꞌan yeb Inmaman, caw huneꞌn̈e jehan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hac tuꞌ yu istzabnipaxico ebnaj yahawil con̈ob Israel tuꞌ issicꞌnican̈ ischꞌen yun̈e iskꞌojni camo ebnaj Comam yalni. ");
INSERT INTO jacNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yalni Comam Jesús tet ebnaj: —Yu ishelanil Inmaman, yuxin caw hantan̈e tzet caw cꞌul chinwatxꞌehan texol. ¿Baytet yin̈ yuxin chinhekꞌoj camojan heyalni? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Istakꞌwi ebnaj yahawil yin̈ ebnaj Israel tuꞌ: —Mach chaẍcokꞌojcan̈an̈ yu hunu iscꞌulal chawatxꞌe, wal xin yu chachbuchwa yin̈ Comam Dios, yuto hach tiꞌ caw comon anma hach, yaj chawalico haba Diosal, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yalni Comam Jesús: —Istzotiꞌ Comam Dios tzꞌibn̈ebilcano yet payat akꞌbilcano teyet, chal hacaꞌ tiꞌ: “Haninan chiwalan tato dios hex,” ẍicanoj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Caw xin mach chiyu coman̈cꞌon tzet tzꞌibn̈ebilcanoj, yuto caw Comam Dios tuꞌ haln̈ecanoj diosal yin̈ mac bay akꞌbilcano Istzotiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Haꞌ Comam Dios an̈eintijan yul sat yiban̈kꞌinal tiꞌ, yajaꞌ ¿tzet yin̈ xin cheyalpaxoj tato buchwal chiwuhan yin̈ Comam Dios yet chiwalnihan tato caw Iscꞌahol Dios wehan? ");
INSERT INTO jacNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tato mach chinyijehan chejbanile akꞌbil wetan yu Inmaman, mach cheyayto yul heyanma win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wal xin hatzet chal Inmaman, haꞌ chinwatxꞌehan. Waxan̈ca caw mach chinhechaytojan yul heyanma, chahwe yul heyanma tzet chinwatxꞌetiꞌan. Hac tuꞌ xin chiyu heyohtan̈eniloj tato caw ayco Comam Dios wetbihojan, ayinpaxicojan yin̈ Comam, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Caw xin yoche ebnaj istzabayo Comam, yaj iscolilo isba Comam yul iskꞌab ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Lahwi tuꞌ xin, istopaxo Comam kꞌaxepxacꞌto haꞌ niman Jordán, bay ah haꞌ iswiꞌ anma yu naj Juan yet yalan̈tocanoj, haꞌ bey tuꞌ xin cancano Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Caw hantan̈e anma apni ilno Comam bey tuꞌ, yalni hacaꞌ tiꞌ: —Yin̈ caw yeli waxan̈ca machi hunu cꞌaybalcꞌule isye yaꞌ Juan jet, yaj sunil tzet yalcano yaꞌ yin̈ yaꞌ Jesús tiꞌ caw yeli, ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Caw xin hantan̈e anma anayto yul yanma yin̈ Comam Jesús bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Bey con̈ob Betania ay huneꞌ naj chiyij Lázaro yaꞌbi ay, haꞌ bey tuꞌ xin aypaxo cawan̈ yanab naj, María isbi huneꞌ ix, huneꞌxa ix xin Marta isbi. Ix María tuꞌ, haꞌ ix anico aceite caw xukꞌ sam yin̈ yoj Comam Jesús, lahwi tuꞌ, issuni tajo ix yoj Comam yu xil iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ebix cawan̈ yanab naj Lázaro tuꞌ xin, yato ebix tzotiꞌ tet Comam Jesús hacaꞌ tiꞌ: —Mamin, caw txꞌoj ye iscꞌul conohan̈, naj caw xahan ay hawu, ẍito ebix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yet yaben Comam huneꞌ chejbanil tuꞌ, yalni Comam: —Huneꞌ yabil tuꞌ, mach chitan̈cano yin̈ camical. Wal xin haꞌ chiyenilo yip Comam Dios, haꞌ xin bay chiixtan̈wipaxilo wipan, hanin Iscꞌahol Comam Dios intiꞌan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Waxan̈ca caw xahan ay ix Marta yeb ix María yeb naj Lázaro yu Comam Jesús, yaj yet yallaxi tato caw yaꞌay naj Lázaro tuꞌ, caw cabto tzꞌayic ecꞌ Comam bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lahwi tuꞌ xin yalni Comam tet ebnaj iscuywom: —Ton̈wepaxo ismajul Judea hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yalni xin ebnaj iscuywom Comam tuꞌ tet: —Mamin, caw tolto yoche ebnaj yahawil con̈ob Israel cachiskꞌojoꞌ camoj. ¿Tom xin chaẍtopaxo hunelxa hawalni? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yalni Comam tet ebnaj: —Caw johtaj tato caw cablahon̈eb hora ikꞌbil yu huneꞌ tzꞌayic, yuxin tato tzꞌayical chon̈belwi, mach comono chon̈txakꞌmohi, yuto sajkꞌinal. ");
INSERT INTO jacNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yaj tato xol kꞌejholo chon̈ecꞌ xin, wal tuꞌ chon̈txakꞌmohi yuto mach sajkꞌinal, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lahwi tuꞌ xin, yalni Comam: —Caw mawaycan̈ jamigo Lázaro, wal tinan̈ xin chintohan wikꞌalojan iswayan̈ naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yalni ebnaj iscuywom Comam Jesús tuꞌ: —Mamin, yaj tato wayan̈ chu naj, chicawxocan̈ naj chal tuꞌ, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yajaꞌ xin yin̈ iscamical naj Lázaro yal Comam, wal ebnaj chicuywi yinta Comam tuꞌ xin, ton̈e chiway naj, yalni Comam, chute yalni ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yuxinto caw yal Comam yin̈ caw haban tet ebnaj: —Naj Lázaro macam naj, ");
INSERT INTO jacNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","yaj caw chintzalahan yuto machijinan yet iscam naj, yu iscꞌulalo teyin̈ yun̈e caw heyanico heyanma win̈an. Ton̈we jilaꞌ naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yalni naj Tomás, naj chihallax tioẍ uninal, tet huntekꞌanxa ebnaj chicuywi yinta Comam: —Ton̈we yinta Comam haxinwal hun cocam yebi, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yet yapni Comam Jesús bey tuꞌ xin, yaben Comam tato can̈ebxa tzꞌayic ismuji naj Lázaro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Haꞌ con̈ob Betania tuꞌ, ayn̈em yictajo legua yehilo yin̈ con̈ob Jerusalén. ");
INSERT INTO jacNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuxinto caw txꞌiꞌal anma ah Jerusalén beycꞌo yakꞌa isnimanbal iscꞌul ix Marta yeb ix María yu iscamical isnoh tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hayet yaben ix Marta tato lan̈an yapni Comam Jesús bey tuꞌ, istit ix ischahno Comam, wal ix María xin cancano ix yul n̈a. ");
INSERT INTO jacNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yalni ix Marta tuꞌ tet Comam yet ischahni isba ix yebi: —Mamin, tato ayachicꞌo bey tiꞌ, caw machim cam innohan. ");
INSERT INTO jacNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yaj xin caw wohtajan tato sunil tzet chakꞌan tet Comam Dios chiyakꞌ Comam tawet, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Istakꞌwi Comam tet ix: —Wal hanoh tuꞌ, chiitzitzbocan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yalni ix: —Hoꞌ Mamin, caw wohtajan tato chiitzitzbican̈ innohtuꞌan yet chiitzitzbican̈ sunil anma yet islahobal tzꞌayic, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yalni Comam xin: —Hanintiꞌan chiwakꞌ itzitzbocan̈an anma camnaxa, yeb xin haninan chiwakꞌan iskꞌinal mach istan̈bal. Yuxinto macn̈eticꞌa chinchahnihan yul yanma, waxan̈ca chicami chiitzitzbican̈. ");
INSERT INTO jacNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yebpaxo xin sunil anma itzitzto chinchahnihan yul yanma, mach chicam yin̈ huneln̈e. ¿Chimhawayto yul hawanma yin̈ tzet chiwalan? ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hoꞌ Mamin, caw chiwaytojan yul wanmahan tato hach tiꞌ Cristo hach. Caw Iscꞌahol Comam Dios hawehi, halbilcanoj ta chachhul yul sat yiban̈kꞌinal tiꞌ, ẍi ix Marta tuꞌ tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lahwi yalni ix Marta hacaꞌ tuꞌ, isto ix yawtenoti isnoh, yalni ix tet ix yin̈ ewantajil: —Aycꞌo Comam cuywawom bey tiꞌ, chachyawte Comam, ẍi ix tet ix María. ");
INSERT INTO jacNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Yaben̈e ix María tzet yal isnoh tuꞌ xin, yah lemna ix, isto ix yilno Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maẍto xin chiapni Comam Jesús yul con̈ob, haꞌ bay ischah isba ix Marta yeb Comam, haꞌ to tuꞌ xin ay Comam yet yapni ix María. ");
INSERT INTO jacNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wal anma ah Judea ayco yakꞌni isnimanbal iscꞌul ebix yet yilni anma yah lemna ix María tuꞌ isto ix, yoc tzujno anma yinta ix yuto istxum anma tato chito ix okꞌo bay mujan isnoh tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yet yapni ix María iscꞌatan̈ Comam Jesús xin, yay jahno ix yich yoj Comam, yalni ix hacaꞌ tiꞌ: —Mamin, tato ayachicꞌo bey tiꞌ, machim cam conohtiꞌan̈, ẍi ix tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yet yilni Comam Jesús yokꞌcan̈ ix María yeb anma ah Judea tzujan yinta ix tuꞌ, yoc biscꞌulal yin̈ iscꞌul Comam, istzꞌaycan̈ iscꞌul Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iskꞌamben Comam xin: —¿Baytuꞌwal mujan naj heyu? ẍi Comam. —Mamin, ton̈ jilaꞌ, ẍi ix María yeb anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yokꞌcan̈ Comam xin. ");
INSERT INTO jacNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yet yilni anma ah Judea yokꞌcan̈ Comam, yalni hacaꞌ tiꞌ: —Caw yeli xahan ay naj yu yaꞌ, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aypaxo hunmajanxa anma halni: —Haꞌ yaꞌ tiꞌ akꞌni hajloho sat naj mutzꞌan sat, ¿tom xin mach an̈cha naj Lázaro tiꞌ yu yaꞌ? Hac tuꞌ xin machim cam naj, ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Caw ecꞌna oc biscꞌulal yin̈ iscꞌul Comam yet yapni bay ayicto naj Lázaro tuꞌ. Haꞌ huneꞌ bay mujan naj tuꞌ, n̈achꞌen yehi, ayco huneꞌ chꞌen niman chꞌen ismajiloj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yalni Comam Jesús xin: —Iwelo ismajil chꞌen, ẍi Comam. Yalni ix Marta, yanab naj Lázaro tuꞌ: —Mamin, con̈itax cam naj tinan̈, caw ayxam sam naj, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Istakꞌwi Comam Jesús: —¿Tom machi mawalan tawet xin tato chawayto yul hawanma yin̈ tzet chiwalan, caw chawilaꞌ ishelanil yip Comam Dios? ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lahwi tuꞌ xin, yilaxilo ismajil chꞌen bay mujan naj tuꞌ, istꞌan̈xican̈ Comam Jesús satcan̈, yalni hacaꞌ tiꞌ: —Mamin, caw chiwakꞌan yuchꞌandios tawet yu maxawabe tzet mawalan. ");
INSERT INTO jacNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wohtajan Mam ta sunilbal tiempo chawabe tzet chiwalan, yaj xin chiwalan hunel tiꞌ tawet yu sunil anma cutxanico tiꞌ, yun̈e yanayto yul yanma ta hach tiꞌ an̈eintijan, ẍi Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yet lahwi yalni Comam huneꞌ tiꞌ xin, yah yaw Comam yin̈ caw ip: —Lázaro, elan̈tij, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hac tuꞌ xin yu yelti naj Lázaro tuꞌ, becꞌbilico kꞌap yin̈ isnimanil naj, pichbilpaxto sat naj yu huneꞌ kꞌap. Yalni Comam xin: —Holwelo kꞌap yin̈ naj, cat isto naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Anma ah Judea apni ilwal yin̈ ix María, caw yilpaxo tzet iswatxꞌe Comam Jesús bey tuꞌ, yuxinto caw hantan̈e anma anayto yul yanma yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aypaxo huntekꞌan ebnaj to halno tet ebnaj fariseo yin̈ tzet iswatxꞌe Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hac tuꞌ xin yu yoc ebnaj fariseo islahtiꞌn̈en isba yeb ebnaj yahawil yehico yin̈ ebnaj sacerdote yeb xin ebnaj yahaw con̈ob. Yalni ebnaj: —¿Tzet wal juten tinan̈, huneꞌ naj tuꞌ caw txꞌiꞌal cꞌaybalcꞌule chisyecano naj? ");
INSERT INTO jacNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tato ton̈e chijila chislahnico naj, caw sunil jet con̈ob tiꞌ chakꞌayto yul yanma yin̈ naj. Hac tuꞌ xin chiyu yulo ebnaj yahawil con̈ob Roma, cat xin yuchcꞌanayo ebnaj yatut Comam Dios, cat xin yetanto ebnaj cocon̈ob tiꞌ, ẍi ebnaj tet hunun. ");
INSERT INTO jacNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ay xin huneꞌ naj, Caifás isbi, iswiꞌehal yehico naj yin̈ ebnaj sacerdote yin̈ huneꞌ habil tuꞌ. Haꞌ naj halni: —Hex tiꞌ caw matzet heyohtaj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Caw mach chitxumchalo heyu tato ecꞌbal cꞌul iscam naj tiꞌ selelo sunil anma, hac tuꞌ xin matxa chitan̈ilo cocon̈ob tiꞌ chal tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wal xin mach yal naj Caifás huneꞌ tuꞌ yul yet ischuquil, yuto haꞌ naj yahawil yehico yin̈ ebnaj sacerdote huneꞌ habil tuꞌ, yuxinto haꞌ Comam Dios akꞌni yalaꞌ naj tato chicam Comam Jesús selelo sunil anma ah Israel. ");
INSERT INTO jacNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yaj maẍn̈etaj yin̈ con̈ob Israel chicam Comam Jesús, wal xin chicampaxo Comam yun̈e iscutxbanico sunil yuninal Comam Dios pujanto yul sat yiban̈kꞌinal tiꞌ, yun̈e hunxan̈e chiyute isba. ");
INSERT INTO jacNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yin̈ huneꞌ tzꞌayic tuꞌ, islahtiꞌn̈e isba ebnaj yahawil con̈ob Israel tato chakꞌ camo ebnaj Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yuxin matxa ecꞌ Comam Jesús xol anma bey ismajul Judea, wal xin to Comam bey yul huneꞌxa con̈ob chiyij Efraín, huneꞌ con̈ob ayco iscawilal txꞌotxꞌ desierto. Haꞌ tuꞌ xin ehayo Comam yeb ebnaj chicuywi yintaj. ");
INSERT INTO jacNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wal yul con̈ob Jerusalén xin, toxa chiichico kꞌin̈ Pascua, huneꞌ kꞌin̈ tuꞌ iskꞌin̈ anma Israel. Caw xin txꞌiꞌal anma yul hunun con̈ob apni bey Jerusalén tuꞌ, yu isyijen yakꞌni sajbo isba yet yalan̈to maẍto chiichico kꞌin̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chi-xin-ecꞌ anma tuꞌ saywal yin̈ Comam Jesús. Yet cutxanico anma yul yatut Comam Dios, chiskꞌamben anma tet hunun hacaꞌ tiꞌ: ¿Tzet quexchi? ¿Chimhulu yaꞌ Jesús yin̈ kꞌin̈ tiꞌ mato machoj? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ebnaj fariseo yeb xin ebnaj iswiꞌehal yeco yin̈ ebnaj sacerdote, yalilto ebnaj xol anma tato macn̈eticꞌa yohta baytuꞌwal ay Comam Jesús, chihallax tet ebnaj yun̈e istzabnayo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wajebto tzꞌayic yichico kꞌin̈ Pascua, yapni Comam Jesús bey Betania, bay ay yatut naj Lázaro, naj itzitzbican̈ xol camom yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yet yapni Comam bey tuꞌ, yoc huneꞌ niman wah yu tzalahilal yin̈ Comam. Haꞌ hun naj Lázaro oc sat meẍa iscꞌatan̈ Comam, haꞌ xin ix Marta chianayo itah sat meẍa. ");
INSERT INTO jacNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wal ix María xin, aymi hunu libra an̈ caw xukꞌ sam ikꞌbil yu ix, naba nardo caw xin aycan̈ istohol. Yanico ix yin̈ yoj Comam, lahwi tuꞌ xin issuni tajo ix yoj Comam yu xil iswiꞌ. Hac tuꞌ xin, caw sunil yul n̈a tuꞌ pujnacan̈ sunil isxukꞌal sam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Wal naj Judas Iscariote, iscꞌahol icham Simón, naj ayco yetbiho ebnaj chicuywi yinta Comam, naj chianico Comam yul iskꞌab camical, haꞌ naj halni hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Huneꞌ an̈ caw xukꞌcano sam tiꞌ, caw oxebmi ciento denario istohol. Estam matxon̈laxtoj, cat ispohlaxto istohol yin̈ anma caw mebaꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Matolo yu chitzꞌay iscꞌul naj yin̈ anma mebaꞌ yuxinto yal naj hacaꞌ tiꞌ, machoj. Walxinto haꞌ naj ikꞌn̈e istxꞌuyal chꞌen melyu, caw xin kꞌayna naj yelkꞌanilo chꞌen melyu chiscꞌuba tuꞌ, yuto caw elkꞌom naj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yalni Comam Jesús tet naj: —¡Mach chacach ix! Wal xin caw yan̈ebil huneꞌ an̈ tiꞌ yu ix, yun̈e yanico ix yin̈ innimanilan yet yalan̈to maẍto chinmujlaxan. ");
INSERT INTO jacNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wal anma mebaꞌ chawal tiꞌ, caw ayn̈eticꞌaco texol, yaj walinan xin, mach ton̈eticꞌa ay inicojan texol, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Caw txꞌiꞌal anma Israel abeniloj tato aycꞌo Comam Jesús bey Betania; isto anma yilno Comam, yeb chiyoche anma yilaꞌpaxo naj Lázaro itzitzbican̈ xol anma camom yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Yu naj Lázaro tuꞌ, caw niman anma Israel yayto yul yanma yin̈ Comam Jesús; matxa xin chisje iscꞌul anma tuꞌ isyijeꞌ tzettaj chal ebnaj sacerdote. Yu huneꞌ tuꞌ, yuxinto islahtiꞌn̈e isba ebnaj yahawil yehico yin̈ ebnaj sacerdote tato chakꞌ camo ebnaj naj Lázaro. ");
INSERT INTO jacNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Caw hantan̈e anma apni yin̈ kꞌin̈ Pascua bey yul con̈ob Jerusalén. Yet huneꞌxa tzꞌayic xin, yaben anma tato lan̈an yapni Comam Jesús bey yul con̈ob tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yuxin yilo anma xaj teꞌ chꞌib, yinito anma teꞌ yun̈e isto anma ischahno Comam. Chi-la-el yaw anma yin̈ caw ip, chalni: —¡Caw niman yelapno Comam Dios! ¡Jalaꞌwe tzotiꞌ caw cꞌul yin̈ Mac akꞌbilti coxol yu Comam Dios Jahawil. Jakꞌaꞌwe tzalaho cocꞌul yin̈ Jahawil, han̈on̈ Israel hon̈ tiꞌ! ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ay xin huneꞌ noꞌ nichꞌan burro ilcha yu Comam. Yahto Comam yiban̈ noꞌ hacaꞌticꞌa yalni Comam Dios bay tzꞌibn̈ebilcanoj: ");
INSERT INTO jacNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Hex ah con̈ob Sión, mach chexxiwi. Ilwecꞌanabi lah, chihul Heyahawil, ayahto yiban̈ huneꞌ noꞌ burro, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yet huneꞌ tzꞌayical tuꞌ xin caw maẍticꞌa txumchalo yu ebnaj iscuywom Comam Jesús yin̈ tzet chalilo huneꞌ tuꞌ. Hato yet istocano Comam yul satcan̈, hato tuꞌ xin isnaniti ebnaj tato tzꞌibn̈ebilcano huneꞌ tuꞌ yin̈ Comam, yuxinto hac tuꞌ yuhi. ");
INSERT INTO jacNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wal anma aycꞌo iscꞌatan̈ Comam Jesús yet yawtenilti Comam naj Lázaro yul panteón, yet yitzitzbican̈ naj yu Comam, haꞌ anma tuꞌ halnicꞌo yin̈ tzet yuhi. ");
INSERT INTO jacNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Caw txꞌiꞌal anma to chawal yin̈ Comam, yuto yabe anma iskꞌumal yin̈ huneꞌ cꞌaybalcꞌule iswatxꞌe Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wal ebnaj fariseo xin, yal ebnaj tet hunun: —Ilwecꞌanabi lah, caw matzet wal juteni yuto caw sunil anma tzujan yinta naj, ẍi ebnaj yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xol sunil anma apni yikꞌayo isba tet Comam Dios yin̈ kꞌin̈ tuꞌ, ayco huntekꞌan ebnaj griego. ");
INSERT INTO jacNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Apni ebnaj tiꞌ iscꞌatan̈ naj Felipe ay bey con̈ob Betsaida ayco yul ismajul Galilea, yalni ebnaj tet naj: —Mamin, caw chijochehan̈ chijilan̈ yin̈ Comam Jesús, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hac tuꞌ xin yu isto naj Felipe tuꞌ yalno tet naj Andrés, iscawan̈ilxa xin ebnaj to halno tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yalni Comam tet ebnaj: —Wal Hanin Akꞌbilintijan texol yu Comam Dios, lan̈an yapni yorahil isyelaxilo inhelanilan. ");
INSERT INTO jacNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Caw isyelal chiwalan teyet, kꞌinalo tato mach chitzꞌunlax hunu hin̈at trigo sat txꞌotxꞌ cat iskꞌato ixim, machom chul iscꞌul ixim. Yaj tato chikꞌato ixim, wal tuꞌ chihul iscꞌul ixim, caw xin niman sat ixim chakꞌa. ");
INSERT INTO jacNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mac mach hinano yaben isyaꞌtajil win̈an, chiscꞌayto iskꞌinal mach istan̈bal. Wal mac hinan yanma yaben isyaꞌtajil win̈an, caw chischah iskꞌinal mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tato ay mac chiyijen tzet chiwalan, ocojab tzujno wintajan. Yuxinto haꞌ bay ayinan, haꞌ tuꞌ chiehpaxo mac caw yijem chute isba wettiꞌan; haꞌ xin Inmaman chihalni iscꞌulal yin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Lahwi tuꞌ xin, yalni Comam Jesús: —Wal tinan̈, caw biscꞌulal ye wanmahan, yajaꞌ ¿tzet chiwute walnihan? ¿Tom chiwalan tet Comam Dios hacaꞌ tiꞌ? “Mam, colinilojan yul iskꞌab huneꞌ isyaꞌtajil lan̈an yul wiban̈tiꞌan,” ¿Tom quinchiyan? ¡Machoj! Yu ton huneꞌ tiꞌ, yuxinto hulnajinan yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mam, yeloj tato caw aycano yelapno hawehi, ẍi Comam. Lahwi tuꞌ xin yabelax huneꞌ yul nukꞌe satcan̈, yalni hacaꞌ tiꞌ: —Caw xainyelojan tato caw aycano yelapno wehan, yaj chinyelojan hunelxa, ẍiayti yul satcan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sunil anma cutxanico bey tuꞌ, aben huneꞌ yul nukꞌe tuꞌ, yalni anma hacaꞌ tiꞌ: —Cꞌuh man̈irlahi, ẍi anma. Aypaxo mac halni: —Huneꞌ naj ángel matzotel tet naj, ẍipaxoj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yalni Comam Jesús tet ebnaj: —Mach wuhojan xin to mahallaxayti huntekꞌan tzotiꞌ tiꞌ, machoj, to heyu. ");
INSERT INTO jacNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wal tinan̈ xin, yilchaxati anma ay yul sat yiban̈kꞌinal tiꞌ yu Comam Dios yin̈ tzet chi-la-iswatxꞌe, cat yinilo Comam naj yahawil yehico yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wal intiꞌan, yet chinilaxcan̈an sat txꞌotxꞌ tiꞌ yin̈ teꞌ culus, sunil anma chiwitijan incꞌatan̈an, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yal Comam huneꞌ tuꞌ yu isyeniloj tzet camical chiikꞌni camoj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Istakꞌwi anma tet Comam: —Chal Istzotiꞌ Comam Dios yin̈ ley aycano jet, tato yaꞌ Cristo chiehocꞌo yaꞌ yin̈ sunilbal tiempo. ¿Tzet yin̈ yuxinto chawal hacaꞌ tiꞌ?: “Wal Hanin Akꞌbilintijan texol yu Comam Dios, caw yilal chinilaxcan̈an,” cachi. ¿Mac xin huneꞌ Akꞌbilti coxolan̈ yu Comam Dios tuꞌ? ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yalni Comam tuꞌ xin: —Yin̈xan̈e hanicꞌ tiempohal ayinicꞌojan texol tiꞌ, caw chiwacanicojan issajilkꞌinal yin̈ heyanma, yuxinto watxꞌeweco heba yin̈ caw istoholal yakꞌ isba ay intocꞌojan texol. Ta machoj, chissomchahocan̈ cheyila, cat xin heyoco hacaꞌ anma chiecꞌ xol kꞌejholo, caw mach chiyu yilni bay caw chitocoj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wal hanintiꞌan, caw lahaninan hacaꞌ issajilkꞌinal, yuxinto chahweinan yul heyanma yakꞌ isba ay intocꞌojan texol, cat xin wanicojan issajilkꞌinal tiꞌ yul heyanma yin̈ caw huneln̈e, ẍi Comam. Lahwi yalni Comam tuꞌ xin, isto Comam yebanto isba tet anma. ");
INSERT INTO jacNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Caw hantan̈e cꞌaybalcꞌule isye Comam Jesús tet anma tuꞌ, yaj caw maẍticꞌa ischah anma Comam yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hac tuꞌ xin yu yijnicano isba yin̈ tzet tzꞌibn̈ebilcano yu naj Isaías, ischejab Comam Dios yet payat, bay chala: Mamin, ¿mac chahnayto yul yanma yin̈ tzettaj jalan̈? Waxan̈ca caw xahaye hawip tet anma, yajaꞌ caw maẍticꞌa mac chahn̈e hach yul yanma, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Caw maẍticꞌa ischayto anma Comam yul yanma, hac tuꞌ yu istzꞌibn̈encano naj Isaías: ");
INSERT INTO jacNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Comam Dios majchencano sat anma, yakꞌnipaxo cawbolo Comam yanma anma yun̈e matxa chiyu yilni, yeb xin mach chitxumchalo yu. Caw mach chisbejcano anma ismachiswalilal, yuxin mach chian̈cha anma yin̈ ismul yu Comam, ẍicano naj Isaías tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yalcano naj Isaías huntekꞌan tiꞌ, yuto ilbilxa ishelanil Comam Jesús yu naj. ");
INSERT INTO jacNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Waxan̈ca hac tuꞌ yute yalnicano naj Isaías, yajaꞌ caw hantan̈e ebnaj yahawil yin̈ ebnaj Israel chahnicano Comam yul yanma. Yaj to caw mach chisyelo ebnaj, machi bay chalpaxicꞌo ebnaj yuto caw chixiw ebnaj tet ebnaj fariseo. Tato chiyabecan̈ ebnaj fariseo tuꞌ, caw matxa chichahlaxicto ebnaj yul capilla. ");
INSERT INTO jacNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hac tuꞌ yute ebnaj yun̈e iscan ebnaj cꞌulal yul sat anma, sata iscanpaxo ebnaj cꞌulal yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yalni Comam Jesús yin̈ ip tet anma: —Haꞌ mac chinchahnaytojan yul yanma, maẍn̈etajinan chinischahan, to haꞌ hun Inmaman chischahpaxoj, yuto haꞌ quinanitijan. ");
INSERT INTO jacNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yeb mac chinilnihan, caw lan̈an yilnipaxico yin̈ Inmaman quinanitijan. ");
INSERT INTO jacNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wal intiꞌan, hulnajinan wakꞌaꞌan sajilkꞌinal yul yanma anma ay yul sat yiban̈kꞌinal tiꞌ, yuxin macn̈eticꞌa chinchahnihan yul yanma mach chican xol kꞌejholo. ");
INSERT INTO jacNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yajaꞌ haꞌ mac chiaben tzet chiwaltiꞌan, mach xin chisyijepaxoj, maẍtajinan chincawxecojan ismul yiban̈. Walinan maẍtaj yu incawxenicojan ismul anma yiban̈ yuxinto hulnajinan yul sat yiban̈kꞌinal tiꞌ; to yu incolnihan anma yuxin quinhulan. ");
INSERT INTO jacNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Macta chinyahnihan, yeb xin mach chisyije tzet chiwalan, ay huneꞌ chicawxenico ismul tuꞌ yiban̈, haꞌ ton tzotiꞌ xawalan xol anma. Haꞌ tzotiꞌ tuꞌ xin, chicawxenico ismul tuꞌ yiban̈ yet islahobal tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wal xin, sunil tzet chiwalan, caw mach wetojan inchuquilan, haꞌ Inmaman an̈eintijan, haꞌ chejn̈einan yin̈ tzettaj chiwalan yeb tzettaj chiwakꞌan iscuyuꞌ anma. ");
INSERT INTO jacNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Caw xin wohtajan tato haꞌ ischejbanil Inmamtuꞌan, haꞌ chiakꞌni kꞌinale mach istan̈bal tet anma; yuxin hacaꞌ yu yalni wetan, hac tuꞌ chiwute walnicanojan teyet, ẍi Comam tet anma. ");
INSERT INTO jacNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yet hecalxan̈e chiichico kꞌin̈ Pascua, caw yohtaxa Comam Jesús tato apni istiempohal bay chiyacano Comam huneꞌ yul sat yiban̈kꞌinal tiꞌ, cat isto Comam iscꞌatan̈ Comam Dios. Caw xahan yil Comam macta yaco isba yul iskꞌab yul sat yiban̈kꞌinal tiꞌ. Wal tinan̈ xin caw chisyecanilo Comam tato caw xahan ay sunil anma tuꞌ yu. ");
INSERT INTO jacNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Wal naj matzwalil xin, xaꞌaynato naj yul yanma naj Judas Iscariote, iscꞌahol icham Simón, yin̈ yanico naj Comam yul iskꞌab camical. Wal Comam Jesús caw yohtaj tato iscꞌatan̈ Comam Dios titna Comam, yuxinto iscꞌatan̈ Comam Dios tuꞌ chitopaxo hunelxa. Caw yohtapaxo Comam tato yul iskꞌab yacanico Comam Dios sunil tzettaj ye tuꞌ. Yet lan̈an iswaꞌ Comam yeb ebnaj chicuywi yinta tuꞌ, yahwano Comam yinilo Comam huneꞌ xil iskꞌap hucanico yiban̈ iscamiẍ, iscꞌalnico Comam huneꞌ pixe yin̈ yictaj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yanayto Comam ha haꞌ yul pechꞌan, istzabnico Comam istxꞌahni yoj ebnaj chicuywi yinta tuꞌ, issuni tajo Comam yu huneꞌ pixe ayco yin̈ yicta tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yet lan̈an istzabnico Comam istxꞌahni yoj naj Simón Pedro, yalni naj tet Comam: —Mamin, ¿tom chachoc hatxꞌahaꞌ wojtiꞌan hawalni? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Istakꞌwi Comam tet naj: —Tinan̈ caw mach chitxumchalo hawu tzet chinwatxꞌetiꞌan, yaj yet tzujanxa cat istxumchalo hawu, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yalni naj tet Comam: —¡Machoj Mamin! Caw maẍticꞌa chu hatxꞌahnilo wojtiꞌan, ẍi naj. Yalni Comam: —Wal xin tato mach chisje hacꞌul chintxꞌahan hawoj tiꞌ, caw mach ayachoco yetbiho ebnaj ayxaco yul inkꞌaban, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yalni naj Pedro tet Comam: —Ta hac tuꞌ chal tuꞌ Mamin, maẍn̈eojabtaj wojtiꞌan chatxꞌaha, wal xin yilal hatxꞌahnipaxo inkꞌaban yebpaxo xin inwiꞌan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Istakꞌwi Comam tet naj: —Kꞌinalo tato ay hunu mac lan̈anto yaẍniloj, matxa yilalo istxꞌahlax sunil isnimanil, han̈cꞌan̈e yoj, yuto caw sajto ye isnimanil tuꞌ. Yuxinto caw lahan hex tiꞌ yeb anma lan̈anto yaẍniloj; caw saj ye heyanma, yaj mach hesuniloj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wal xin, caw yohtaxa Comam mac chianico yul iskꞌab camical, yuxinto yal hacaꞌ tiꞌ: “Yaj mach hesunilo saj ye heyanma,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yet lahwi istxꞌahni Comam yoj ebnaj xin, yanipaxico Comam huneꞌ xil iskꞌap hucan ye tuꞌ. Yaypaxo tzꞌon̈no Comam iscꞌatan̈ ebnaj, yalni hacaꞌ tiꞌ: —¿Chimtxumchalo heyu tzet manwatxꞌetiꞌan? ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yalnipaxo Comam: —Walex hex tiꞌ, chinheyalan hecuywawomal yeb xin heyahawiloj. Wal xin caw yel cheyala, istꞌin̈anil ton huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hanintiꞌan hecuywawom wehan, Heyahawil wepaxojan, yaj mantxꞌahan heyoj, yuxin hex tiꞌ hac tuꞌ wal heyuni teyin̈ hununex. ");
INSERT INTO jacNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wal xin manwatxꞌehan huneꞌ tiꞌ yun̈e inyenicanojan tato hac tuꞌ wal heyuteni. ");
INSERT INTO jacNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yin̈ caw isyelal chiwalan teyet, hacaꞌ hunu naj cꞌamteꞌ, mach ecꞌbalo naj sata naj bay chimunla tuꞌ, hacticꞌapax tuꞌ naj chejab, mach ecꞌbalo naj sat naj chichejni. ");
INSERT INTO jacNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tato chitxumchalo huntekꞌan tiꞌ heyu, cat xin heyijeni, caw sakꞌal heyet. ");
INSERT INTO jacNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Maẍtaj teyin̈ hesunil chiwalan huneꞌ tiꞌ, wal xin wohtajan macta sicꞌbililo wuhan, yajaꞌ xin yilal yijni isba yin̈ tzet tzꞌibn̈ebilcanayo yin̈ Istzotiꞌ Comam Dios bay chala: “Haꞌ huneꞌ mac caw hun chinwaꞌan yebi, haꞌ chipaqꞌuico win̈an,” ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yalan̈to chiwalnicanojan huneꞌ tiꞌ teyet haxinwal yet chiyijno isba, caw cheyayto yul heyanma tato haninan Cristo hinan. ");
INSERT INTO jacNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yin̈ caw isyelal chiwalan teyet, macn̈eticꞌa chichahni hunu inchejaban, haninan chinischahpaxojan. Hacpax tuꞌ xin macn̈eticꞌa chinchahnihan, chischahpaxo Mac chejn̈eintijan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yet lahwi yalnicano Comam huntekꞌan tiꞌ xin, yoc huneꞌ niman biscꞌulal yin̈ iscꞌul Comam, yalni Comam yin̈ caw haban: —Yin̈ caw isyelal chiwalan teyet, texol tiꞌ ayco huneꞌ mac chinanocojan yul iskꞌab camical, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yet yaben ebnaj iscuywom Comam tuꞌ xin, toxan̈e chi-la-tꞌan̈xico ebnaj yin̈ sat hunun, yuto mach yohtajo ebnaj mac yin̈ yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ay xin huneꞌ naj iscuywom Comam caw xahan ay yu, iscawilal xin Comam ayco naj yet chiwaꞌi. ");
INSERT INTO jacNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yakꞌni naj Simón Pedro yechel tet naj, yun̈e iskꞌambenilo naj mac huneꞌ chal Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kꞌehan xin naj iscawilal istxam iscꞌul Comam Jesús, iskꞌamben naj tet Comam: —Mamin, ¿mac najil huneꞌ chawal tiꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Istakꞌwi Comam tet naj: —Haꞌ mac bay chiwakꞌatojan ixim pan chinlabahan, haꞌ huneꞌ tuꞌ, ẍi Comam tet naj. Lahwi tuꞌ xin islaban Comam ixim pan tuꞌ, yakꞌni Comam ixim tet naj Judas Iscariote, iscꞌahol icham Simón. ");
INSERT INTO jacNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yet ischahni naj ixim pan tuꞌ, yaynato naj matzwalil yul yanma naj, yalni Comam tet naj: —Haꞌ tzet nabil hawu hawatxꞌeni, watxꞌe yin̈ an̈e, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wal ebnaj chiwaꞌ sat meẍa yeb Comam tuꞌ xin, caw machi hunu ebnaj txumchalo yu tzet yin̈ yuxinto yal Comam hacaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Naj Judas tuꞌ xin haꞌ naj ikꞌn̈e istxꞌuyal chꞌen melyu, yuxin ay ebnaj txumni ta chischejto Comam naj islokꞌo tzet chiocnico yin̈ kꞌin̈ tuꞌ, maca yu ispohnito naj hanicꞌo chꞌen melyu tuꞌ yin̈ anma mebaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yet lahwi iswahni naj Judas ixim pan tuꞌ, yelti naj bey tuꞌ, caw xin xaꞌay numnahi. ");
INSERT INTO jacNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lahwi istocano naj Judas tuꞌ, yalni Comam Jesús hacaꞌ tiꞌ: —Wal tinan̈ chisyelo isba wipan Hanin Akꞌbilintijan texol yu Comam Dios, cat xin isyenipaxilo isba yip Comam Dios win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tato chinyelojan yip Comam Dios, chisyepaxilo Comam wipan, caw xin lan̈anxa isyeniloj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hex caw xahan ayex wutiꞌan, caw hanicꞌxan̈e tiempo ayinicꞌojan texol. Chinhesayaꞌcꞌojan, yaj caw mach chiyu heto bay chintotuꞌan. Hacaꞌticꞌa wute walnihan tet anma Israel, hac tuꞌ chiwute walnipaxojan teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chiwakꞌcanojan huneꞌ acꞌ chejbanile tiꞌ teyet, xahan cheyil heba hununex. Hacaꞌ isxahanil ayex wuhan, hac tuꞌ cheyutepaxo heba. ");
INSERT INTO jacNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tato caw xahancano cheyil heba hununex, hac tuꞌ chiyu yohtan̈enilo anma tato quexincuywoman, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Iskꞌamben naj Simón Pedro tet Comam: —Mamin, ¿baytuꞌwal xin chaẍtohi? ẍi naj. Istakꞌwi Comam: —Bay chintotuꞌan mach chu hato wintajan. Chaẍoco tzujno wintajan, yaj maẍto tinan̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yalnipaxo naj Pedro tuꞌ tet Comam: —Mamin, ¿tzet yin̈ yuxin mach chu woc tzujnojan tawintaj? Caw hinaninan wakꞌni camo inbahan tawin̈, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Istakꞌwi Comam: —¿Caw yelmi chawala? ¿Caw hinan hachmi hawakꞌni camo haba win̈an? Wal xin yin̈ isyelal chiwalan tawet, caw oxelxa chawala tato mach quinhawohtajojan yalan̈to maẍto chiokꞌcan̈ noꞌ icham chiyo, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yalni Comam Jesús tet ebnaj iscuywom: —Caw mach chicabcon hecꞌul, aweco heyanma yin̈ Comam Dios cat xin heyanipaxico heyanma win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bey yatut Inmaman caw ay hamanil bay wal jehi; kꞌinalo ta machi hamanil tuꞌ xamwalan teyet. Wal xin caw aya, yuxinto chintohan inwatxꞌeꞌan huneꞌ bay chexapni tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yetxa lahwi inwatxꞌenan bay chexapni, cat xin wulan hunelxa quexwinotojan, haxinwal bay chinehan, haꞌ tuꞌ chexehpaxoj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Haꞌ bay chintotuꞌan, caw heyohtaxa, yeb xin heyohtapaxo isbelal, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yalni naj Tomás tet Comam: —Mamin, caw mach johtajojan̈ baytuꞌwal chaẍtohi. ¿Tzet xin chiyu johtan̈enilojan̈ isbehal? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Istakꞌwi Comam: —Hanintonan huneꞌ beh chiwalan teyet tiꞌ, yuto haninn̈ehan chiyu quexwinitojan iscꞌatan̈ Inmaman. Haninan isyelal, yeb xin haninn̈ehan chiwakꞌan kꞌinale mach istan̈bal. ");
INSERT INTO jacNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tato quinheyohtaj inxahan, caw heyohtaxa Inmaman. Wal tinan̈ xin, caw heyohtaxa Inmaman, yuto xaheyilico yin̈, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yalni xin naj Felipe tet Comam: —Mamin, ye Hamam tuꞌ jilaꞌan̈, cꞌuxanojtamna tuꞌ, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yalni Comam tet naj: —Felipe, ayxa istiempohal wehicꞌojan texol. ¿Tom caw maẍto quinhawohtajan? Macn̈eticꞌa chinilnihan, lan̈an yilnipaxo yin̈ Inmaman. ¿Tzet yin̈ yuxinto chawalpaxoj?: “Ye Hamam tuꞌ jilaꞌan̈,” cachi. ");
INSERT INTO jacNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tom caw maẍto chawayto yul hawanma tato wetbi inbahan yeb Inmaman, yetbipaxo Inmaman wehan? Yuxinto sunil tzet chiwalan teyet mach wetojan inchuquilan, haꞌ Inmaman ayico wetbihojan, haꞌ chiwatxꞌen ismunil. ");
INSERT INTO jacNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aweyto yul heyanma ta wetbi inbahan yeb Inmaman, aypaxico Inmamtuꞌan win̈an. Tato mach cheyayto yul heyanma yin̈ tzet chiwaltiꞌan, aweyto yul heyanma yu ej cꞌaybalcꞌule chinyehan teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yin̈ caw isyelal chiwalan teyet, macn̈eticꞌa chinchahnihan yul yanma, chiswatxꞌepaxo hacaꞌ tzet chinwatxꞌetiꞌan. Aypaxo tzet ecꞌbalto chiswatxꞌeꞌ, yuto iscꞌatan̈ Inmaman chintohan. ");
INSERT INTO jacNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tzijxan̈e tzet chekꞌana yu ayexxaco yul inkꞌaban chiwakꞌan. Hanin Iscꞌahol Comam Dios intiꞌan, chinyelojan yip Inmamtuꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuxin chiwalan teyet, tzijxan̈e ye tuꞌ chekꞌan yin̈ inbihan chiwakꞌan teyet, yuto caw wetxahan heyehi. ");
INSERT INTO jacNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tato xahan ayinan heyu, yijewe tzet chiwaltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Haninan chinkꞌanan tet Inmaman cat yaniti Comam Espíritu Santo colwal teyin̈, haꞌ Comam tuꞌ isyelaln̈eticꞌa chala. Haꞌ xin chihul texol yin̈ sunilbal tiempo. Wal anma yet yul sat yiban̈kꞌinal tiꞌ xin, caw mach chiyu ischahni huneꞌ Espíritu tuꞌ yuto mach ohtabilo yu anma, machi xin chitxumchalo yu. Walex hex tiꞌ xin, caw heyohtaxa, caw xin chiꞌehayo texol cat yehpaxico teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Wal intiꞌan mach chexinbejcanojan hechuquil, chinhulpaxojan tecꞌatan̈ hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Caw hanicꞌxan̈e tiempohal ayinicꞌojan, lahwi tuꞌ xin matxa chinillaxojan yu anma. Walex hex tiꞌ, chi-ticꞌa-heyilaꞌpaxo win̈an, yuto caw itzitz inn̈eticꞌahan yin̈ sunilbal tiempo. Haquexpax tuꞌ, itzitz hexn̈eticꞌapaxoj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yet ayxaco Comam Espíritu Santo teyin̈, cat istxumchaholo heyu ta wetbi inbahan yeb Inmaman. Haquexpax tuꞌ, ayexpaxico win̈an, ay inpaxicojan teyin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Macta chiaben tzet chiwalan, cat xin isyijeni, haꞌ huntekꞌan tuꞌ caw chon̈ochenan̈. Yuxin macn̈eticꞌa chinochenan, caw xahan ay yu Inmaman, xahan aypaxo wuhan, cat xin inyenilo inbahan tet, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yalni naj Judas, yaj maẍtaj naj Judas Iscariote: —Mamin, ¿tzet yin̈ yuxinto jetn̈ehan̈ chayelo haba? Wal tet anma yet yul sat yiban̈kꞌinal tiꞌ mach chayelo haba tet, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yalni Comam xin: —Haꞌ mac chinochenan, chisyije tzet chiwalan, caw xin xahan chꞌillaxo yu Inmaman. Hac tuꞌ xin chu julan̈ cat joccanojan̈ yetbihoj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Haꞌ mac mach chinochenan, mach chisyije tzet chiwalan. Wal huneꞌ cuybanil lan̈an heyaben tiꞌ caw mach wetojan, yet Inmaman an̈eintijan texol. ");
INSERT INTO jacNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Caw chiwalcanojan huntekꞌan tiꞌ teyet yakꞌ isba ayintocꞌojan texol. ");
INSERT INTO jacNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Chati Inmamtuꞌan Comam Espíritu Santo texol; haꞌ chihul inselelojan cat iscolwa teyin̈, cat xin quexiscuyni yin̈ sunil tzettaj ye tuꞌ. Haꞌ xin chiakꞌni henabati sunil tzet xa-le-hecuycano wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Wal tinan̈ xin, chiwacanojan akꞌancꞌulal yul heyanma. Huneꞌ akꞌancꞌulal chiwakꞌtiꞌan caw cꞌul, mach hacaꞌ akꞌancꞌulal chakꞌ anma yet yul sat yiban̈kꞌinal tiꞌ. Wal xin mach chicabcon hecꞌul, mach chexxiwpaxoj. ");
INSERT INTO jacNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Caw xawalan teyet ta chintohan, yaj xin chinhulpaxojan hunelxa tecꞌatan̈. Ta caw yeli chinheyochehan, caw chimquextzala heyabeni tato chintohan iscꞌatan̈ Inmaman, yuto caw ecꞌbalto Inmamtuꞌan insatajan. ");
INSERT INTO jacNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yalan̈tocanoj chiwalnicanojan teyet yin̈ huntekꞌan tiꞌ, haxinwal yet chijni isba, cat heyanayto yul heyanma yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Matxa caw tzet chiwalan teyet, yuto caw lan̈an yul naj matzwalil, naj yahawil yeco yin̈ huneꞌ yul sat yiban̈kꞌinal tiꞌ. Waxan̈ca ay yip naj, yaj mach chikꞌoji naj wiban̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yaj to caw yilal yecꞌyaꞌ wanmatiꞌan yun̈e yohtan̈enilo sunil anma tato caw chiwochehan Inmaman, cat inyenilojan tato caw chinyijehan chejbanil akꞌbil wetan yu. Wal tinan̈ xin, ahan̈wewanoj, elojon̈we bey tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yalni Comam Jesús tet ebnaj iscuywom: —Wal hanintiꞌan, caw lahaninan yeb xin hunu yoj teꞌ uva caw cꞌul, wal Inmaman xin, caw lahan yeb hunu mac chiilni teꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kꞌinaloj tato ayej teꞌ iskꞌab mach chisatni, chitzocꞌlaxilto teꞌ yu naj chitan̈en teꞌ. Wal teꞌ iskꞌab caw cꞌul issatni xin, chiyilo naj istajinal iskꞌab teꞌ, hac tuꞌ xin caw chisatni teꞌ sicꞌlebil. Hacaꞌ iswatxꞌencan̈ naj teꞌ uva tuꞌ, caw hac tuꞌ chiyute istan̈en Inmaman macta ayxaco yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Walex hex tiꞌ, caw sajxa ye heyanma yu cuybanile akꞌbilxa teyet wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ayojab exn̈eticꞌaco win̈an, cat wehicꞌojan yul heyanma. Caw hacaꞌ hunu iskꞌab teꞌ uva tzocꞌbililto yin̈ yoj, matxa chisatni, caw hac tuꞌ heyehi tato machijex win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wal hanintiꞌan, caw lahaninan yeb xin yoj teꞌ uva. Wal hexpaxo xin, caw lahanex hacaꞌ teꞌ iskꞌab. Yuxin ta ayexn̈eticꞌaco win̈an, ay inpaxicꞌojan teyin̈, lahanex hacaꞌ hunu iskꞌab teꞌ uva caw cꞌul issatni. Wal tato machijinan teyin̈, caw machi hunu tiꞌ chiyu hewatxꞌen hechuquil. ");
INSERT INTO jacNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wal mac mach chiehicꞌo win̈an xin, caw lahan chiutelax hacaꞌ teꞌ iskꞌab mach chiyakꞌ sat, chitzocꞌlaxiloj cat istajiloj. Chilahwi istajilo teꞌ xin, cat iscutxbalaxcan̈ teꞌ, cat yalaxto teꞌ yul kꞌaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tato hacn̈eticꞌa tuꞌ heyehico win̈an, machi xin checꞌayto heyijen cuybanile chiwalcanotiꞌan, kꞌanwe tzet choche hecꞌul chiakꞌlaxo teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta hacaꞌ teꞌ iskꞌab caw satnom tuꞌ haquex tuꞌ, wal tuꞌ cheyeloj tato caw yeli incuywoman heyehi. Hac tuꞌ xin chiyu heyinican̈ isbi Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hacaꞌ isxahanil ayinan yu Inmamtuꞌan, hac tuꞌ isxahanil chexwilpaxojan. Yuxin xahann̈ehojabn̈eticꞌa cheyil heba, hacaꞌ isxahanil ayex wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tato cheyije chejbanile chiwakꞌcanojan teyet tiꞌ, chexahann̈e heba, hacaꞌ isxahanil ayex wuhan. Yuto hac tuꞌ wehan yeb xin Inmaman, caw xahan chexwilan, hacaꞌ iscꞌulchꞌanil iscꞌul Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Caw chiwalan huntekꞌan tiꞌ teyet yun̈e hacaꞌ istzala incꞌultiꞌan, hac tuꞌ heyabenpaxo tzalahilal wintajan; haxinwal caw chitzꞌajnacano huneꞌ tzalahilal tuꞌ yul heyanma. ");
INSERT INTO jacNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Haꞌ huneꞌ chejbanile tiꞌ chiwalcanojan teyet, caw xahanojab cheyil heba hununex hacaꞌ isxahanil chexwilan. ");
INSERT INTO jacNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hac tiꞌ chiyu coyeniloj tato caw xahan aycano hunu jamigo ju, tato hinanon̈ jakꞌni camo coba yin̈. ");
INSERT INTO jacNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tato cheyije tzet chiwaltiꞌan, caw wamigohan heyehi. ");
INSERT INTO jacNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Walex hex tiꞌ, caw matxa chexwalan inchejabojan, yuto hunu naj chejab caw mach yohtajo naj tzet chiswatxꞌe yahaw, wal xin chexwalan wamigohojan, yuto xawalan teyet sunil tzet halbil wetan yu Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Maẍtajex quinhesayilojan, haninan quexinsayilojan, quexwanicojan yin̈ hemunil yun̈e lahan chexelico hacaꞌ hunu teꞌ satnom teꞌ caw niman sat chakꞌa, haꞌ xin sunil huntekꞌan chewatxꞌe tuꞌ ayn̈eticꞌa yin̈ sunilbal tiempo. Hac tuꞌ xin tzijxan̈e ye tuꞌ chekꞌan tet Inmaman yin̈ inbihan, chiakꞌlax teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yuxinto caw chiwalcanojan teyet, caw xahan cheyille heba hununex. ");
INSERT INTO jacNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yalnipaxo Comam Jesús: —Tato chexcajlax yu anma ay yul sat yiban̈kꞌinal tiꞌ, nawetij tato caj quinyilpaxojan anma. ");
INSERT INTO jacNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kꞌinalo tato ayextoco xol tzet chiswatxꞌe anma tiꞌ, caw xahanmi chexyila, hacaꞌ isxahanil chil isba. Wal xin caw haninan quexinsiquꞌilojan xol anma, yuxinticꞌa chexiscaj anma, yuto matxa ayexoco xol tzet chiswatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tijab yul hecꞌul yet walnihan teyet hacaꞌ tiꞌ: “Naj cꞌamteꞌ caw mach ecꞌbalo naj sata ispatrón,” yuxin tato caw quincajlaxan yu anma, haꞌ quexpax tuꞌ chal tuꞌ, chexcajlaxpaxo yu anma. Wal tato isyije anma intzotiꞌan walan tet xin, haquex pax tuꞌ, chisyije anma cuybanile cheyala. ");
INSERT INTO jacNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Caw chexecꞌoyaꞌ yu anma isyayil ayexico yul inkꞌaban. Chiyute anma huneꞌ tuꞌ yuto caw mach yohtajo anma tuꞌ Mac an̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kꞌinalo tato caw mach quinhulan walaꞌan cuybanile tet anma, caw machmi ismul anma yin̈. Wal tinan̈ xin, caw matxa tzet tzꞌaj yalaꞌ yu iscolni isba yin̈ ismul tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Macn̈eticꞌa chincajnihan, chiscajpaxo Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sunil tzet inyehan xol anma, caw maẍto hunu mac chiyeni yilaꞌ anma hacaꞌ tuꞌ. Kꞌinalo tato machi cꞌaybalcꞌule inyehan xol anma, caw machim ismul anma, chal tuꞌ. Wal xin, waxan̈ca caw yil anma huntekꞌan tuꞌ, yaj to caw chiniscajan, chiscajpaxo Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yajaꞌ caw chu huntekꞌan tiꞌ, yun̈e yijnicano isba sunil tzet tzꞌibn̈ebilcano yin̈ Istzotiꞌ Comam Dios bay chala: Caw machi inmulan tet anma, yaj to caw yaco ishowal win̈an, ẍiayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yaj ay huneꞌ Comam chicolwa teyin̈ chitit bey Inmaman, haꞌ ton xin Comam Espíritu Santo, Comam han̈e isyelal chala. Haninan chintohan inchejaꞌtijan Comam tuꞌ. Yet ay Comam texol chitzotelo win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Haquexpax tuꞌ hex tiꞌ, caw chextzotelo win̈an yuto caw huneꞌn̈eticꞌa hetzujico wintajan yettaxticꞌa wichicojan walnihan istzotiꞌ Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Caw chiwalcanojan huntekꞌan tiꞌ teyet, yun̈e mach chebej iscawxi hecꞌul win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wal xin, caw matxa chexchahlaxicto yul iscapilla ebnaj Israel; chiapni huneꞌ tiempohal bay chexyakꞌa camo ebnaj, cat xin isnano ebnaj tato lan̈an isyijen ebnaj tzet chal Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chiswatxꞌe ebnaj huntekꞌan tiꞌ, yuto caw mach yohtajo ebnaj Inmaman, yeb xin mach quinyohtajojan ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Caw chiwalcanojan huntekꞌan tiꞌ teyet, haxinwal yet chiapni istzꞌayical chitit yul hecꞌul tato halbilxaticꞌa teyet wuhan. Yalnipaxo Comam Jesús: —Caw machi walan huntekꞌan tiꞌ teyet yet yalan̈tocanoj yuto ayinicꞌojan texol. ");
INSERT INTO jacNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yajaꞌ wal tinan̈ xin, caw chinpaxtojan iscꞌatan̈ Inmaman an̈eintijan, yaj xin machi hunujex chekꞌambe: “¿Baytuꞌwal chaẍtohi?” quexchi. ");
INSERT INTO jacNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wal xin, caw chioc biscꞌulal yin̈ hecꞌul yu chiwalan huntekꞌan tiꞌ teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yin̈ caw yeli chiwalcanojan teyet, caw ecꞌna cꞌul tato chintohan, yuto ta mach chintohan caw mach chihul Comam chicolwa teyin̈. Wal xin caw chintohan cat inchejnitijan Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yet chihul Comam tuꞌ, haꞌ chiakꞌni yohtan̈elo anma tato mulum. Haꞌ Comam tuꞌ chiakꞌni yohtan̈elo anma tuꞌ ta caw istoholal quinhulicꞌojan inwatxꞌeꞌan, yeb ta chil Comam Dios yin̈ tzet chielico anma. ");
INSERT INTO jacNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Haꞌ Comam Espíritu tuꞌ, chiakꞌni yohtan̈elo anma tato caw mulum, yuto maẍticꞌa isje iscꞌul quinischabaꞌan yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Haꞌ Comam chiakꞌnipaxo yohtan̈elo anma tato caw istoholal quinhulicꞌojan inwatxꞌeꞌan, yuxin chinpaxtojan iscꞌatan̈ Comam Dios, matxa xin bay chiillax win̈an. ");
INSERT INTO jacNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chakꞌnipaxo Comam yohtan̈elo anma tato haꞌ Comam Dios chiilni yin̈ tzet chielico anma, yuto xacawxico ismul naj yahawil yul sat yiban̈kꞌinal tiꞌ yiban̈ yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Caw hantan̈e tzet chiwochehan chiwalan teyet, yaj tinan̈ maẍto chexkꞌoji hetxumniloj. ");
INSERT INTO jacNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yajaꞌ yet chihul Comam Espíritu Santo isyelal chala, haꞌ Comam xin chexcuyni yin̈ sunil isyelal. Yaj xin mach yeto tzet chakꞌ hecuyuꞌ tuꞌ to tzet abebil yu, haꞌ chal teyet, cat yakꞌni heyohtan̈elo tzettaj ye tuꞌ chito yub. ");
INSERT INTO jacNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Haꞌ xin chianico inmayan, yuto chohtan̈e baytet wetan yehi cat xin yalnolo teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sunil tzettaj ye tuꞌ yet Inmaman caw wetpaxojan, yuxinto chiwalcanojan teyet; sunil tzettaj ye tuꞌ wetan yehi caw challaxo teyet yu Comam Espíritu Santo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yalnipaxo Comam tet ebnaj iscuywom: —Hanicꞌxan̈e bay matxa cheyilaꞌ win̈an, hanicꞌxan̈e cat heyilnipaxo win̈an hunelxa yuto chintohan bey Inmaman, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Lahwi yalni Comam hacaꞌ tuꞌ xin, istzabnico ebnaj iscuywom Comam iskꞌamben tet hunun: —¿Tzet chal yelapno huneꞌ chiyal Comam tiꞌ? “Caw hanicꞌxan̈e bay matxa cheyilaꞌ win̈an, hanicꞌxan̈e xin cat heyilni win̈an hunelxa yuto chintohan iscꞌatan̈ Inmaman,” ẍi Comam, ẍi ebnaj tet hunun. ");
INSERT INTO jacNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yalnipaxo ebnaj: —¿Tzet caw yelapno ye huneꞌ chiyal Comam tiꞌ, “caw hanicꞌxan̈e”? ẍi Comam. Caw mach chitxumchalo ju tzet chal yelapnoj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isnanilo Comam Jesús tato caw choche ebnaj iskꞌambeꞌ tet Comam, yuxinto yal Comam tet ebnaj: —Caw xawalan teyet: “Caw hanicꞌxan̈e bay matxa cheyilaꞌ win̈an, hanicꞌxan̈e xin cat heyilnipaxo win̈an hunelxa,” quinchiyan. ¿Tom haꞌ huneꞌ mawaltiꞌan, haꞌ caw chekꞌambe teyet hunujex? ");
INSERT INTO jacNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yin̈ caw yeli chiwalan teyet; chioc biscꞌulal yin̈ heyanma cat heyokꞌi. Wal anma yet yul sat yiban̈kꞌinal tiꞌ xin, caw chitzalahocan̈. Chiayo biscꞌulal teyiban̈, yaj huneꞌ hebiscꞌulal tuꞌ xin caw chipaqꞌuico yin̈ tzalahilal. ");
INSERT INTO jacNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kꞌinalo hacaꞌ hunu ix ix, yet chiapni yorahil iswatxꞌi iscꞌul caw biscꞌulal chulo yanma ix yu isyaꞌil chul yiban̈ ix. Yajaꞌ yet xapitzcꞌa nichꞌan istzꞌul ix tuꞌ xin matxa chisnati ix isyaꞌtajil tuꞌ yu tzalahilal yin̈ nichꞌan unin xapitzcꞌa yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hac tuꞌ cheyakꞌle hex tiꞌ, caw chioc biscꞌulal yin̈ hecꞌul tinan̈, yaj xin yet cheyilnopaxo win̈an hunelxa, caw choco huneꞌ icham tzalahilal yin̈ hecꞌul. Machi hunu mac chiyu yinilo huneꞌ tzalahilal tuꞌ teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yet huneꞌ tiempohal tuꞌ xin, matxa yilalo ay tzet chekꞌambe wetan. Yin̈ caw isyelal chiwalcanojan teyet, tzijxan̈e ye tuꞌ chekꞌan tet Inmaman yin̈ inbihan, chiyakꞌ Comam teyet. ");
INSERT INTO jacNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wal tinan̈ xin, caw maẍto hunu tzet chekꞌan yin̈ inbihan tet Inmaman. Kꞌanwej cat yakꞌlax teyet, haxinwal caw tzꞌajan chucanico tzalahilal yul heyanma, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yalni xin Comam Jesús: —Huntekꞌan cuybanile xawalan teyet tiꞌ, yecheln̈e yu walnihan. Yaj xin chiapni yorahil yet matxa chiwalan teyet yin̈ yecheln̈e, walxinto caw yin̈xa haban chiwalan teyet tzet caw ye Inmaman. ");
INSERT INTO jacNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yet huneꞌ tiempohal tuꞌ xin, chekꞌan tzet choche hecꞌul tet Inmaman yin̈ inbihan. Matxa yilalo chintzotelan teyin̈ tet Inmamtuꞌan, ");
INSERT INTO jacNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yuto caw xahan ayex yu Inmaman. Caw xahan ayex yu Comam tuꞌ yuto caw xahan ayinan heyu yeb xin yu xaheyayto yul heyanma tato iscꞌatan̈ Comam titnajinan. ");
INSERT INTO jacNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iscꞌatan̈ Inmaman quintitan yet wulan yul sat yiban̈kꞌinal tiꞌ. Wal tinan̈ xin chinelan yul sat yiban̈kꞌinal tiꞌ, cat intohan iscꞌatan̈ Inmaman hunelxa, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yalni ebnaj iscuywom Comam tuꞌ tet: —Wal tinan̈, caw habanxa hatzoteli, yu matxa chaẍtzotel yin̈ yecheln̈e. ");
INSERT INTO jacNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tinan̈ xin, caw chinachalo juhan̈ tato sunil caw hawohtaj; yuxin chijaytojan̈ yul janmahan̈ tato iscꞌatan̈ Comam Dios titnajach; matxa yilalo chicokꞌambehan̈ tawet, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yalni Comam tet ebnaj: —¿Mataxca caw yeli chechayto yul heyanma win̈an? ");
INSERT INTO jacNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wal xin, caw lan̈an yul istiempohal bay chexpujnahocantoj, nananta bay xin chextocanicoj. Hac tuꞌ xin chu quinhebejnicanojan inchuquilan, yaj xin mach chincanan inchuquilan yuto caw ayco Inmaman wetbihojan. ");
INSERT INTO jacNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Caw chiwalcanojan sunil huntekꞌan tiꞌ teyet yun̈e yoccano akꞌancꞌulal yin̈ heyanma wuhan. Yul sat yiban̈kꞌinal tiꞌ cheyilaꞌ isyaꞌtajil, yaj aweco yip heyanma yuto hanintiꞌan xaquinkꞌojihan yin̈ sunil isyaꞌtajil ay yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yet lahwi yalnicano Comam Jesús huntekꞌan tiꞌ xin, istꞌan̈xican̈ Comam satcan̈, yalni Comam: —Mam, maapni yorahil hayenilo yip Hacꞌahol tiꞌ, cat isyenipaxilo Hacꞌahol hawip. ");
INSERT INTO jacNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wal xin caw ayxaco anma yalan̈ wipan hawu, yun̈e wakꞌnihan kꞌinale mach istan̈bal tet anma xahawakꞌ yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kꞌinale mach istan̈bal chaliloj, to chaẍyohtan̈elo anma ta hachn̈echꞌan caw Dios yin̈ caw isyelal, cat xin quinyohtan̈enilojan anma tato haninan Cristo hinan, hach an̈einpaxtijan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Caw xainyelojan hawip yul sat yiban̈kꞌinal tiꞌ, yuto xainlahan munil hawakꞌ inwatxꞌehan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wal tinan̈ xin Mam, yepaxilo wipan tawintaj, huneꞌ wipan ikꞌbilticꞌa wuhan yet ayinan tacꞌatan̈ yet yalan̈to maẍto chiwatxꞌi huneꞌ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Huntekꞌan mac xahasiqꞌuilo xol anma yul sat yiban̈kꞌinal tiꞌ, hawati yul inkꞌaban, xacachwakꞌan yohtan̈elo ebnaj. Huntekꞌan ebnaj tiꞌ xin caw hawetxaticꞌa yehi, caw xin chisyije ebnaj tzet chawala. ");
INSERT INTO jacNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wal tinan̈ xin caw yohtaxa tato sunil tzet akꞌbil wetan hawu, tacꞌatan̈ titnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cuybanile hawakꞌ wetan, caw xawalan yabeꞌ ebnaj, ischahni ebnaj yul yanma. Yuxinto caw yohta ebnaj tato caw yeli tacꞌatan̈ titnajinan. Caw ischayto ebnaj yul yanma tato hach an̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Caw chiwaben̈ecanojan ebnaj yul hakꞌab, maẍtaj anma yet yul sat yiban̈kꞌinal tiꞌ chiwaben̈etojan yul hakꞌab, to han̈cꞌan̈e ebnaj hawakꞌ wetan, yuto caw hawet ye ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Macta chiwalan wetojan, caw hawetpaxoj, yeb xin macta caw hawet, wetpaxojan, yin̈ xin chiilchalo sunil wipan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Caw hanicꞌxan̈e tiempohal ayinicꞌojan yul sat yiban̈kꞌinal tiꞌ, cat xin inpaxtojan tacꞌatan̈. Walpaxo ebnaj tiꞌ xin, chicancano ebnaj bey tiꞌ. Walach hach tiꞌ Mam, caw cꞌul hachn̈eticꞌa. Macta xahawakꞌ wetan, chawil yu hahelanil, haxinwal hunxan̈e chute isnabal, hacaꞌ je han̈on̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yet ayinicꞌojan xol ebnaj bey yul sat yiban̈kꞌinal tiꞌ, caw ilbil ebnaj wuhan, yu hawip ayco ebnaj yul inkꞌaban. Ebnaj hawakꞌ wetan, caw xin machi hunu mac cꞌaytoj, cachann̈e huneꞌ naj tꞌin̈anxaticꞌa yetanto isba; yun̈e yijni isba tzet aycanayo yul Hatzotiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Wal tinan̈ Mam, chinpaxtojan tacꞌatan̈, yaj yet ayintocꞌojan ninoxa yul sat yiban̈kꞌinal tiꞌ, chiwalcanojan huntekꞌan tiꞌ haxinwal hacaꞌticꞌa yehico tzalahilal yin̈ wanmatiꞌan, hac tuꞌ chupaxico tzalahilal yin̈ yanma ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Caw xawalan hatzotiꞌ yabeꞌ ebnaj, yaj wal anma yet yul sat yiban̈kꞌinal tiꞌ, caw chichiwa iscꞌul yin̈ ebnaj yuto caw matxa yeto yul sat yiban̈kꞌinal tiꞌ ye ebnaj. Hacaꞌ inpaxojan mach yeto yul sat yiban̈kꞌinal tiꞌ wehan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wal xin mach chinkꞌanan tawet ta chawilo ebnaj yul sat yiban̈kꞌinal tiꞌ, han̈cꞌan̈e chinkꞌanan tawet ta chacꞌuba ebnaj tet naj matzwalil. ");
INSERT INTO jacNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Caw mach yeto yul sat yiban̈kꞌinal tiꞌ wehan, hacpax tuꞌ ebnaj, caw mach yeto yul sat yiban̈kꞌinal tiꞌ ye ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Watxꞌeco isnabal ebnaj tawin̈ yu hahelanil, Hatzotiꞌ xin, haꞌ ton isyelal. ");
INSERT INTO jacNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hacaꞌ yu quinhawanitijan xol anma ay yul sat yiban̈kꞌinal tiꞌ, hac tuꞌ chiyu wanipaxtojan ebnaj xol anma. ");
INSERT INTO jacNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yu ebnaj hawaco yul inkꞌaban, yuxin chiwaco inbahan yin̈ munil hawakꞌ wetan; hac tuꞌ xin chiwatxꞌico ebnaj yul hakꞌab yu isyelal. ");
INSERT INTO jacNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Maẍn̈etajpaxo yin̈ ebnaj tiꞌ chinkꞌanan hacꞌulal, caw chinkꞌanpaxojan hacꞌulal yin̈ sunil anma chinchahnihan yul yanma yu Hatzotiꞌ chalaꞌco ebnaj tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Wal tinan̈ xin Mam, caw chinkꞌanan tawet tato caw hunn̈ehojab chiyute isnabal ebnaj. Hacaꞌticꞌa je han̈on̈ tiꞌ, hawetbi wehan, wetbipaxojan hawehi. Hac tuꞌ Mam, chiwochehan tato caw hunxan̈ehojab chucano isnabal ebnaj. Hac ton tuꞌ xin chiyu yanayto anma yul yanma tato hach an̈eintijan yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Haꞌ iscꞌulchꞌanil hawakꞌ wetan xawakꞌpaxojan tet ebnaj tuꞌ, yun̈e caw lahanxan̈e chiyucano isnabal hacaꞌticꞌa je han̈on̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Caw wetbi inbahan yeb ebnaj, caw xin jetbipaxo coba. Hac tuꞌ xin caw hunxan̈e chucano ebnaj. Hac ton tuꞌ xin chiyu istxumchalo yu anma ay yul sat yiban̈kꞌinal tiꞌ tato caw hach quinhachejtijan, cat xin isnachalo yu tato caw hacaꞌ isxahanil ayinan hawu, hac tuꞌ isxahanil aypaxo anma ayxaco yul inkꞌabtiꞌan hawu. ");
INSERT INTO jacNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mam, ebnaj ayxaco yul inkꞌabtiꞌan hawu, caw chiwochehan tato bay chinehan haꞌ tuꞌ xin chiehpaxo ebnaj incꞌatan̈an yun̈e yilni ebnaj wipan akꞌbil wetan hawu, yuto caw xahan ayinan hawu yalan̈to yet maẍto huneꞌ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Walach hach tiꞌ Mam, caw toholcano sunil tzet chawatxꞌe. Wal anma ay yul sat yiban̈kꞌinal tiꞌ, caw mach cachyohtajoj. Walinan xin, caw ohtabilach wuhan, caw xin yohtapaxo ebnaj ayco yul inkꞌabtiꞌan tato hach an̈eintijan. ");
INSERT INTO jacNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Caw xacachinyelojan tet ebnaj, yuxin chachyohtan̈elo ebnaj, yaj chito cam cachwakꞌaꞌan yohtan̈elo ebnaj. Yun̈e hacaꞌ isxahanil ayinan hawu, hac tuꞌ isxahanil aypaxo ebnaj hawu, haxinwal hun chiwupaxojan yeb ebnaj, ẍi Comam Jesús tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lahwi yalnicano Comam Jesús huntekꞌan tzotiꞌ tuꞌ xin, isto Comam yeb ebnaj iscuywom iskꞌaxepicꞌto huneꞌ haꞌ nichꞌan haꞌ chiyij Cedrón, bey yul huneꞌ peyab xol huntekꞌan teꞌ tzꞌunub, haꞌ tuꞌ xin octo Comam yeb ebnaj iscuywom tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wal naj Judas, chianico Comam yul iskꞌab camical, caw yohta naj huneꞌ peyab tuꞌ, yuto caw txꞌiꞌal el beycꞌo Comam yeb ebnaj iscuywom bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuxin hac tuꞌ yu isbey naj Judas tuꞌ issaynoyo Comam. Tzujan xin hun bulan ebnaj soldado yinta naj, yeb huntekꞌan ebnaj chitan̈en yatut Comam Dios chejlaxti yu ebnaj fariseo yeb ebnaj iswiꞌehal yin̈ ebnaj sacerdote. Yetbi ebnaj tuꞌ istah, yeb iscantil, yeb chꞌen chꞌen chiocnico yin̈ howal. ");
INSERT INTO jacNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wal xin, caw yohtaxa Comam Jesús tzet lan̈an yul yiban̈, yuxinto elto Comam chahwal yin̈ ebnaj, iskꞌambeni: —¿Mac chesaya? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Istakꞌwi ebnaj xin: —Naj Jesús nazareno chicosayicꞌojan̈, ẍi ebnaj. —Hanintonan, ẍi Comam tet ebnaj. Aypaxico naj Judas xol ebnaj, naj chianico Comam yul iskꞌab camical. ");
INSERT INTO jacNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yet yalni Comam hacaꞌ tiꞌ: Hanintonan, ẍi Comam, isto tecton ebnaj yintaj, yaycꞌay ebnaj xin. ");
INSERT INTO jacNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lahwi tuꞌ xin, iskꞌambenpaxo Comam: —¿Mac chesaya? ẍi Comam. —Haꞌ naj Jesús nazareno chicosayan̈, ẍipaxo ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yalni Comam xin: —Yaj caw chiwalan teyet tato haninan chinhesayicꞌojan, bejwecano ebnaj tiꞌ, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hac tuꞌ xin yu yijni isba tzet yal Comam tet Comam Dios yet yalni: “Sunil ebnaj hawakꞌ yul inkꞌaban, machi hunu ebnaj chicꞌayto wuhan,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wal naj Simón Pedro, yihti naj yespada yul yatut, ispitnilto naj istxiquin ischejab naj yahawil ebnaj sacerdote, Malco isbi. Haꞌ huneꞌ istxiquin naj yin̈ iswatxꞌkꞌab haꞌ ispitilto naj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yalni Comam tet naj: —Ayto hawespada yul yatut. ¿Tom mach yilalo wakꞌni inbahan yul iskꞌab isyaꞌtajil nabilico win̈an yu Inmaman? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lahwi tuꞌ xin, istzablaxayo Comam Jesús yu ebnaj soldado, yeb naj yahawil yeco yin̈ ebnaj, yeb yu ebnaj chitan̈en yatut Comam Dios chejbilti yu ebnaj yahawil yin̈ ebnaj Israel; iscꞌalnayo ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Babel yito ebnaj Comam bey yatut naj Anás, ismam yixal naj Caifás. Haꞌ naj Caifás, caw yahawil yeco yin̈ ebnaj sacerdote yin̈ huneꞌ habil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Haꞌ naj Caifás tuꞌ halni tet ebnaj yahawil yin̈ ebnaj sacerdote tato ecꞌna cꞌul iscam hunu anma selelo sunil anma ay yul con̈ob Israel tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yet yilaxto Comam Jesús, caw nahat tzujan isto naj Pedro yinta Comam, yeb huneꞌxa naj iscuywom Comam. Huneꞌ naj tiꞌ xin, caw yohta isba naj yeb naj yahawil yehico yin̈ ebnaj sacerdote, yuxinto octo naj istiꞌ yatut naj yinta Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wal naj Pedro tuꞌ xin, cancano naj sat huneꞌ pulta ayco istiꞌ beh, yaj xin elti naj iscuywom Comam yohta isba yeb naj yahawil yin̈ ebnaj sacerdote, yalni naj tet ix chitan̈en pulta tuꞌ ta chiocto naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yalni ix chitan̈en yocto anma yul huneꞌ pulta tuꞌ tet naj Pedro: —¿Tom maẍtaj hunach chaẍcuywi yinta huneꞌ naj tiꞌ? ẍi ix tet naj. Istakꞌwi naj Pedro tuꞌ tet ix: —Machoj, maẍtajinan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yet huneꞌ tiempohal tuꞌ caw chew, yuxin yaco ebnaj chejab yeb ebnaj chitan̈en yatut Comam Dios kꞌaꞌ, yoc ebnaj kꞌaẍnoj. Sunil ebnaj tuꞌ oc lin̈no yin̈ kꞌaꞌ, haꞌ hun naj Pedro tuꞌ oc lin̈no kꞌaẍno yin̈ kꞌaꞌ xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lahwi tuꞌ xin, iskꞌamben naj yahawil ebnaj sacerdote huntekꞌan kꞌambebal tet Comam Jesús: —¿Mac ebnajil chicuywi tawintaj? ¿Tzettaj ye tuꞌ chawakꞌ iscuyuꞌ ebnaj? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Istakꞌwi Comam tet naj: —Yet incuywahan yin̈ anma, caw sajsatil quincuywahan. Caw incuyan anma yulaj capilla yeb xin yul yatut Comam Dios bay chi-la-iscutxba isba anma Israel. Yuxinto caw machi hunu tzet ye tuꞌ tiꞌ walan yin̈ caw ewantajil. ");
INSERT INTO jacNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tzet yin̈ yuxinto wetan chakꞌambe? Kꞌambe tet anma bay quincuywahan, haꞌ anma chihalni tawet tzet wakꞌan iscuyuꞌ. Wal xin caw yohta anma tuꞌ tzet halbilcano tet wuhan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yet yalni Comam tet naj hacaꞌ tuꞌ, ispakꞌlaxilto sat Comam yu huneꞌ naj chitan̈en yatut Comam Dios, yalni naj: —¿Tzet yin̈ yuxinto hac tuꞌ hatakꞌwi tet naj yahawil sacerdote tiꞌ? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Istakꞌwican̈ Comam tet naj: —Tato ay hunu txꞌoj mawalan chawabe, halilo tinan̈ baytet. Ta cꞌul xin, ¿tzet yin̈ yuxinto chinhamakꞌan? ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iscꞌallaxto Comam tet naj Caifás yu naj Anás, naj yahawil yin̈ ebnaj sacerdote. ");
INSERT INTO jacNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wal naj Pedro xin, kꞌaẍno chu naj xol ebnaj chejab yeb ebnaj chitan̈en yatut Comam Dios, yoc ebnaj iskꞌambeno tet naj: —¿Walach hach tiꞌ, hawetbimi haba yeb naj Jesús tiꞌ? ẍi ebnaj tet naj. Yaj caw maẍticꞌa yalilo naj, yalni naj hacaꞌ tiꞌ: —Machoj, caw mach wetbiho inbahan yeb naj, ẍi naj Pedro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hunepixto xin, iskꞌamben huneꞌ ischejab naj yahawil yin̈ ebnaj sacerdote ayto yu isba yeb naj elto istxiquin yu naj Pedro tuꞌ: —Yaj caw cachwilan xol teꞌ tzꞌunub yeb naj Jesús tiꞌ, ẍi naj tet naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yanipaxico naj Pedro tuꞌ lekꞌtiꞌal tato mach yohtajo naj Comam, hunepixto xin, yokꞌcan̈ noꞌ icham chiyo. ");
INSERT INTO jacNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yet issajbilo xin, yilaxilti Comam Jesús yul yatut naj Caifás, yilaxto Comam sata naj gobernador Poncio Pilato. Yaj mach octo ebnaj Israel yul capil bay ayicto naj gobernador tuꞌ, yuto txahul yocto ebnaj hacaꞌ yalni isley ebnaj. Tato chiocto ebnaj tuꞌ, matxa chiyu isloni ebnaj itah chilolax yin̈ kꞌin̈ Pascua. ");
INSERT INTO jacNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yuxinto elti naj gobernador tzotelo istiꞌ capil, iskꞌamben naj tet ebnaj: —¿Tzet ismul huneꞌ naj tiꞌ heyalni? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Istakꞌwi ebnaj tet naj: —Tato mach xiwquilta ismul naj tiꞌ, machim majitijan̈ naj tawet, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yalni naj Pilato tuꞌ tet ebnaj: —Iweto naj, cat xin heyilni tzet chielico naj hacaꞌ chiyute yalni heley, ẍi naj tet ebnaj. Istakꞌwi ebnaj Israel tuꞌ: —Yaj wal han̈on̈ Israel on̈tiꞌan̈, caw mach chiyu jakꞌni camojan̈ hunu anma, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hac tuꞌ xin yu yijni isba tzet halbilcano yu Comam Jesús yin̈ tzet chiyu iscami. ");
INSERT INTO jacNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yocpaxto naj Pilato tuꞌ yul capil hunelxa. Yawtenicto naj Comam Jesús iscꞌatan̈, iskꞌamben naj tet Comam: —¿Tom yahawil anma Israel hawehi? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Istakꞌwi Comam xin: —¿Yulmi hawiꞌ chawiti chawalni huneꞌ tiꞌ, mato ay mac haln̈e tawet? ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Istakꞌwi naj Pilato tuꞌ xin: —¿Tom Israel inan hawalni? Haꞌ ebnaj hawet con̈ob, yeb xin ebnaj yahawil yehico yin̈ ebnaj sacerdote, haꞌ ebnaj macachiniti wetan, ¿tzet hamul? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yalni Comam: —Wal hanintiꞌan, maẍtaj yul huneꞌ sat yiban̈kꞌinal tiꞌ chinocan Yahawil. Tato yul sat yiban̈kꞌinal tiꞌ yahaw inan, sunilmi anma ayxaco yul inkꞌaban chiscutxba isba cat xin istzabnico howal yun̈e quiniscolnihan yul iskꞌab ebnaj yahawil con̈ob Israel. Wal xin maẍtaj yul sat yiban̈kꞌinal tiꞌ chinocan Yahawil, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yalni naj Pilato tuꞌ: —¿Tom yelticꞌa yahawil hach, chal tuꞌ? ẍi naj. —Hoꞌ Yahawil wehan hacaꞌ hawalni tiꞌ. Quinpitzcꞌahan yul sat yiban̈kꞌinal tiꞌ yun̈e walnihan isyelal. Yuxin macn̈eticꞌa yetxaticꞌa isyelal yehi chiyabe tzet chiwalan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Iskꞌamben naj Pilato tuꞌ: —¿Tzet yelapno huneꞌ isyelal tuꞌ? ẍi naj tet Comam. Yet lahwi iskꞌamben naj Pilato tet Comam hacaꞌ tuꞌ xin, yelpaxti naj istiꞌ capil, yalni naj tet ebnaj Israel cutxanico tuꞌ: —Walinan, caw machi mule chiilchalo yin̈ naj tiꞌ wuhan. ");
INSERT INTO jacNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yaj hex tiꞌ, caw hunun habil hekꞌannilto hunun ebnaj presowom yet chiecꞌ kꞌin̈ Pascua tiꞌ. ¿Chimheyoche tato chinbejtzohan huneꞌ naj heyahawil tiꞌ? ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yet yaben ebnaj yalni naj Pilato hacaꞌ tuꞌ, yah wejla ebnaj, yalni yin̈ caw ip: —¡Machoj! Maẍtaj naj chabejtzo, haꞌ naj Barrabás, haꞌ naj chabejtzo, ẍi ebnaj. Wal naj Barrabás tuꞌ xin, elkꞌom naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lahwi tuꞌ xin, yinito naj Pilato tuꞌ Comam Jesús, ischejni naj hatelaxo Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Isbakꞌonayo ebnaj soldado huntekꞌan teꞌ txꞌix coronahil, yanahto ebnaj yin̈ iswiꞌ Comam, yanipaxico ebnaj huneꞌ xilkꞌape yin̈ Comam, hucan yehi, cajmutzꞌmun̈e jilni. ");
INSERT INTO jacNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lahwi tuꞌ xin, ishitzico ebnaj iscꞌatan̈ Comam, yalni ebnaj hacaꞌ tiꞌ: —Jakꞌaꞌco iswinajil naj yahawil con̈ob Israel, ẍi ebnaj chetan ebnaj Comam. Chi-la-ispakꞌnilto ebnaj sat Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lahwi tuꞌ xin, yelpaxti naj Pilato tuꞌ istiꞌ iscapil, yalni naj tet ebnaj Israel tuꞌ: —Ilwecꞌanabi lah, chiwiltijan naj heyilaꞌ yun̈e caw heyabencanoj tato caw machi nichꞌano ismul naj chiilchalo yin̈ wuhan, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lahwi tuꞌ xin, yelilo Comam istiꞌ capil, ayahto huneꞌ corona txꞌix tuꞌ yin̈ iswiꞌ Comam, hucanpaxico huneꞌ kꞌap yin̈ Comam cajmutzꞌmun̈e. Yalni naj Pilato tuꞌ tet ebnaj: —Ilwecꞌanabi, ay naj lah, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hayet yilni ebnaj yahawil yin̈ ebnaj sacerdote yeb ebnaj chitan̈en yatut Comam Dios, yah yaw ebnaj, yalni ebnaj yin̈ caw ip: —Ahojab naj yin̈ culus, ahojab naj yin̈ culus, ẍixan̈e ebnaj sunil. —Yuxinto yal naj Pilato tuꞌ tet ebnaj: —Ta hac tuꞌ chal tuꞌ, iweto naj cat heyanican̈ naj yin̈ culus tuꞌ hechuquil, yuto caw machi nino ismul naj chiilchalo yin̈ wuhan, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yalni xin ebnaj Israel tuꞌ tet naj: —Wal coleyan̈ xin, chala tato caw yilal iscam naj, yuto caw chalico isba naj Iscꞌaholo Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Yet yaben naj Pilato huneꞌ tiꞌ xin, ecꞌna caw xiwcan̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yuxinto meltzopaxicto naj yul capil tuꞌ hunelxa, iskꞌamben naj tet Comam: —¿Baytuꞌwal titnajachicoj? ẍi naj. Caw xin maẍticꞌa takꞌwi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yuxinto yal naj tet Comam: —¿Tzet yin̈ yuxinto mach chaẍtakꞌwi wetan? ¿Tom mach hawohtajoj tato ay wipan cachinbejtzonan, maca xin cachwanican̈an yin̈ culus? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Istakꞌwi Comam tet naj: —Caw machim hawip win̈an tato maẍtaj Comam Dios akꞌn̈e huneꞌ hawip tiꞌ yul hakꞌab. Wal xin, haꞌ naj quinanicojan yul hakꞌab tiꞌ, haꞌ naj caw ecꞌna ay ismul tasataj, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yet yaben naj yalni Comam huneꞌ tuꞌ, issayni naj tzet caw chiyu iscolcha Comam, yaj caw ip yahcan̈ yel yaw ebnaj Israel tuꞌ, chalni ebnaj: —¡Tato chabejtzo naj, caw chacaj naj jahaw ay bey Roma chal tuꞌ, yuto macn̈eticꞌa chal isba jahawil, caw chiscaj naj jahaw ay bey Roma! ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yet yaben naj Pilato huneꞌ tuꞌ, yalni naj tato chiillaxilti Comam Jesús. Lahwi tuꞌ xin, yay tzꞌon̈no naj yul ischem bay chiillaxi tzet chielico anma ay ismul. Huneꞌ lugar tuꞌ, Gabata isbi yul abxubal hebreo. Gabata tuꞌ chal yelapnoj latzꞌbilcan̈ chꞌen chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chumanil xin yet hecalxan̈e chiichico kꞌin̈ Pascua, yalni naj tet ebnaj Israel tuꞌ: —Ay heyahawil tiꞌ lah, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yahpaxo wejna ebnaj yalni yin̈ caw ip: —¡Camojab naj, camojab naj, acan̈ naj yin̈ culus! ẍi ebnaj yin̈ Comam. Istakꞌwipaxo naj: —¿Tom chiwacan̈an naj heyahawil tiꞌ yin̈ culus, chal tuꞌ? ẍi naj tet ebnaj. Istakꞌwi ebnaj yahawil yin̈ ebnaj sacerdote: —Wal han̈on̈tiꞌan̈, mach hunuxa jahawilan̈ cachann̈e naj jahawil ay bey Roma, ẍi ebnaj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hac tuꞌ xin yu yanico naj Pilato Comam yul iskꞌab ebnaj yun̈e yanican̈ ebnaj yin̈ culus. Hac tuꞌ xin yu yinito ebnaj Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yet yelto Comam Jesús yul con̈ob Jerusalén tuꞌ, yinito Comam isculus yiban̈ iswixicꞌ bay chialaxicoj. Yilaxto Comam bey huneꞌ txꞌotxꞌ chiyij Gólgota. Huneꞌ tzotiꞌ Gólgota tuꞌ, chal yelapnoj Isbajil Wiꞌe yin̈ abxubal hebreo. ");
INSERT INTO jacNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Haꞌ tuꞌ xin alaxcan̈ Comam yin̈ culus. Aypaxo xin cawan̈xa ebnaj alaxcan̈ yin̈ culus yinta Comam. Huneꞌ naj ah yin̈ iswatxꞌkꞌab Comam, huneꞌxa naj ah yin̈ ismeckꞌab. ");
INSERT INTO jacNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Istzꞌibn̈en naj Pilato hayeb tzꞌib, ischejni naj yalaxoco yiban̈ iswiꞌ Comam yin̈ culus, chalni hacaꞌ tiꞌ: Naj Jesús ah Nazaret, Yahawil anma Israel, ẍi hayeb tzꞌib tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Caw hantan̈e ebnaj Israel ilni huntekꞌan tzꞌib tuꞌ, yuto caw istxam con̈ob Jerusalén alaxcan̈ Comam yin̈ culus. Haꞌ huntekꞌan tzꞌib tuꞌ xin, ayico yin̈ abxubal hebreo yeb xin yin̈ abxubal griego, yeb xin yin̈ huneꞌxa abxubal chiyij latín. ");
INSERT INTO jacNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yuxinto yal ebnaj yahawil yin̈ ebnaj sacerdote tet naj Pilato tuꞌ: —Majaltam tiꞌ, mach yahawilo ebnaj Israel maxawutecoj, hacoj tiꞌ maxawutecoj lah, naj chiyal isba yahawil ebnaj Israel, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Istakꞌwi naj Pilato tet ebnaj: —Baytetticꞌa toxa mantzꞌibn̈ecojan hac tuꞌ chiyucanoj, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yet lahwi yanican̈ ebnaj soldado Comam Jesús yin̈ culus tuꞌ, yinican̈ ebnaj xil iskꞌap Comam, ispohnicanto ebnaj yin̈. Caw can̈eb elico kꞌap, hunun litxꞌan yet hunun ebnaj. Wal huneꞌ kꞌap chishucbaco Comam yiban̈ xil iskꞌap xin, machi istzilbanil kꞌap, yuto huneꞌn̈e ye ischembanil kꞌap sunil masanta chiayilo yin̈ yojtabanil. ");
INSERT INTO jacNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yuxinto yal ebnaj soldado tuꞌ tet hunun: —Mach chicotzilto huneꞌ tiꞌ, wal xin jilwe coba yin̈ mac chiinitoj, ẍi ebnaj tet hunun. Hac tuꞌ xin yu yijnicano isba yin̈ tzet tzꞌibn̈ebilcano yul Yum Comam Dios bay chala: “Istzilayo ebnaj xil inkꞌapan yin̈, yilwenpaxo isba ebnaj yin̈ mac chiinito xil inkꞌapan hucan yehi,” ẍicanayoj. Yaj xin caw yeli, hac tuꞌ yute ebnaj soldado tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iscawilal bay aycan̈ Comam yin̈ culus tuꞌ xin, lin̈ancan̈ ismiꞌ Comam yeb xin isnoh ismiꞌ, yeb xin ix María yixal naj Cleofas, yeb xin ix María ah Magdala. ");
INSERT INTO jacNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iscꞌatan̈ ismiꞌ Comam tuꞌ xin, lin̈ancan̈ huneꞌ naj iscuywom Comam caw ochebil yu. Yet yilni Comam ismiꞌ tuꞌ, yalni Comam: —Miꞌ, naj lin̈ancan̈ tacꞌatan̈ tuꞌ, hacaꞌ hawunin chiyucanico naj, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yalnipaxo Comam tet naj iscuywom tuꞌ: —Inmiꞌtiꞌan, caw hacaꞌ hamiꞌ chiyucanicoj, ẍi Comam tet naj. Hac tuꞌ xin yu yoc naj yilno ismiꞌ Comam bey yatut. ");
INSERT INTO jacNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lahwi tuꞌ xin, yohtan̈enilo Comam Jesús tato caw yijcano isba sunil tzet yilal iswatxꞌeni, yuxinto yal hacaꞌ tiꞌ: —Caw chitaj intiꞌan, ẍi Comam. Yal Comam huneꞌ tiꞌ yun̈e yijnicano isba tzet tzꞌibn̈ebilcano yin̈ Istzotiꞌ Comam Dios yet payat. ");
INSERT INTO jacNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bey tuꞌ xin, ayayo huneꞌ ẍalu vinagre, islabanayto ebnaj huneꞌ esponja xol, yanico ebnaj huneꞌ esponja tuꞌ yin̈ iswiꞌ huneꞌ teꞌ hisopo, yanahto ebnaj yin̈ istiꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yet lahwi yucꞌni Comam vinagre tuꞌ xin, yalni hacaꞌ tiꞌ: —Mayijcano isba sunil tinan̈, ẍicano Comam. Lahwi tuꞌ xin, yay xulna iswiꞌ Comam, iscamiloj. ");
INSERT INTO jacNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Caw xin hecalxan̈e kꞌin̈ Pascua yeb xin istzꞌayical xewilal, yuxinto mach chisje iscꞌul ebnaj Israel tato chicancano isnimanil ebnaj aycan̈ yin̈ culus bey tuꞌ, yuto caw aycano yelapno huneꞌ tzꞌayic xewilal tuꞌ yul sat ebnaj. Yuxinto bey ebnaj iskꞌanaꞌ tet naj Pilato tato chischej naj kꞌahlaxoto isbajil yoj Comam yeb ebnaj alaxcan̈ yin̈ culus yinta Comam tuꞌ, yun̈e iscamilo yin̈ an̈e cat xin yilaxayo isnimanil yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yuxin apni ebnaj soldado iskꞌahalto yoj naj babel yeb xin naj iscab. ");
INSERT INTO jacNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yet yapni ebnaj yin̈ Comam Jesús xin, yilni ebnaj tato xacamnalo Comam, yuxinto matxa iskꞌahilto ebnaj yoj Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yaj xin ay huneꞌ naj soldado hopchan ismotx Comam yu islanza, yelilo chicꞌ yeb ha haꞌ yul ismotx Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wal xin haninan caw wilan hun tiꞌ yuxinto chiwalan teyet, caw chiwalan isyelal teyet yun̈e heyanayto yul heyanma tato caw hac tuꞌ yuhi. Caw wohtajan tato caw isyelal tzet chiwaltiꞌan. ");
INSERT INTO jacNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Matxa kꞌahlaxilto yoj Comam yun̈e yijnicano isba tzet tzꞌibn̈ebilcano yul Yum Comam Dios yet payat bay chal hacaꞌ tiꞌ: “Machi hunu isbajil chikꞌahlaxtoj,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chalpaxo hacaꞌ tiꞌ yin̈ Istzotiꞌ Comam Dios: “Chiillax huneꞌ naj hopchabil yu chꞌen lanza,” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ay xin huneꞌ naj José isbi, ah Arimatea. Haꞌ naj tuꞌ xin tzujanticꞌa yin̈ tzet chal Comam Jesús, ton̈e xin mach chisyelo naj yuto caw chixiw naj tet ebnaj yahawil yeco yin̈ anma Israel. Isbey naj iskꞌanno tet naj Pilato ta chiyiyo naj isnimanil Comam yin̈ culus. ");
INSERT INTO jacNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Haꞌ hun naj Nicodemo, naj beycꞌo ilno Comam yet akꞌbalil yet yalan̈tocanoj, apni naj bey tuꞌ, ikꞌbil oxeb arroba huntekꞌan an̈ caw xukꞌ sam yu naj; mirra isbi, sombil yeb huntekꞌan an̈ chiyij áloes. ");
INSERT INTO jacNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lahwi tuꞌ xin, yinito ebnaj isnimanil Comam, ispichnico ebnaj kꞌap yeb an̈ caw xukꞌ sam tuꞌ yin̈ isnimanil Comam; yuto hac tuꞌ chiyute anma Israel yin̈ iscamom yet chimujlaxi. ");
INSERT INTO jacNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iscawilal bay alaxcan̈ Comam yin̈ culus tuꞌ, ay huneꞌ peyab yet tzꞌunub, haꞌ tuꞌ xin ay huneꞌ chꞌen chꞌen holbil yul bay chialaxicto camom. Caw xin acꞌto chꞌen, caw maẍto hunu camom chialaxicto yul chꞌen. ");
INSERT INTO jacNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yu yichixa tzꞌayic xewilal, yeb xin yu cawil yeco huneꞌ chꞌen chꞌen tuꞌ, yuxin haꞌ tuꞌ yacanicto ebnaj isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Haxa yet babel tzꞌayic yin̈ semana, caw ayto issajbiloj isto ix María ah Magdala bay alaxicto isnimanil Comam. Yilni ix ta matxa chꞌen chꞌen ayco ismajilo istiꞌ bay alaxicto Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hac tuꞌ xin yu ispaxto ix yin̈ an̈e yalno tet naj Simón Pedro yeb xin tet huneꞌxa naj iscuywom Comam, naj caw xahan ay yu. Yalni ix María ah Magdala tuꞌ tet ebnaj: —Caw maꞌilaxilti isnimanil Comam Jesús bayticꞌa ayictoj; baymituꞌwal mailaxto isnimanil Comam, caw mach johtajoj, ẍi ix tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yet yaben naj Pedro yeb huneꞌxa naj caw ochebil yu Comam tuꞌ, isto ebnaj bay alaxicoto Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Caw xin an̈e yakꞌ ebnaj iscawan̈il, yaj xin babico huneꞌxa naj tuꞌ sata naj Pedro, yuxin babel apni naj sata naj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Apnin̈e naj xin yay cꞌon̈no naj, istꞌan̈xicto naj bay alaxicto isnimanil Comam. Yilni naj xin tato haxan̈cꞌan̈e kꞌap kꞌap pichlaxico yin̈ Comam wojanayoj, yajaꞌ xin machi octo naj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Lahwi tuꞌ xin, yapni naj Simón Pedro, beh xin yocto naj yilnoj, yilni naj xin tato caw haxan̈cꞌan̈e kꞌap kꞌap wojancanayoj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wal kꞌap payuꞌe cꞌaln̈e iswiꞌ Comam, chulbilayo kꞌap. Mach hunu yehayo kꞌap yeb kꞌap pichlaxico yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","Lahwi tuꞌ xin, yocto huneꞌxa iscuywom Comam tuꞌ, naj babel apni, yilni naj xin tato matxa Comam ayicto yul chꞌen, yanayto naj yul yanma. Yajaꞌ wal xin caw maẍto chitxumchalo yu ebnaj tzet tzꞌibn̈ebilcano yul Yum Comam Dios bay chala tato caw yilal ispitzcꞌacan̈ Comam Jesús xol camom. ");
INSERT INTO jacNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lahwi tuꞌ xin, ispaxti ebnaj bay aya. ");
INSERT INTO jacNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wal ix María ah Magdala, cancano lin̈no ix okꞌo istiꞌ bay alaxicto Comam, yay n̈ohno ix istꞌan̈xicto ix. ");
INSERT INTO jacNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yilnicto ix cawan̈ ebnaj ángel, caw saj jilni xil iskꞌap ebnaj ayco yin̈, tzꞌon̈ayo ebnaj bay ecꞌlena isnimanil Comam tuꞌ, huneꞌ naj yin̈ iswiꞌtaj huneꞌxa naj yin̈ yojtaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lahwi tuꞌ xin, iskꞌamben ebnaj tet ix: —¿Tzet chawokꞌte? ẍi ebnaj. Istakꞌwi ix: —Chinokꞌan yuto maꞌilaxto isnimanil Wahawilan, caw mach wohtajojan baytuꞌwal ma-bey-alaxocanoj, ẍi ix tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hunepixto tuꞌ xin, istꞌan̈xito ix yintaj, yilni ix xin lin̈anxacan̈ Comam Jesús iscꞌatan̈ ix, yaj mach istxumilo ix tato haꞌ Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iskꞌamben Comam tet ix: —¿Tzet yin̈ yuxinto chachokꞌi? ¿Mac chasaya? ẍi Comam. Haꞌ yute isnani ix tato haꞌ naj chitan̈en huneꞌ tzꞌunub tuꞌ chitzotel tet ix, yuxinto yal ix: —Mamin, tato hach maxawitoj, halilo wetan baytuꞌwal macachbey hawakꞌaꞌcanoj, cat winitojan, ẍi ix. ");
INSERT INTO jacNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yalni Comam tet ix: —¡María! ẍi Comam. Hac tuꞌ xin yu ismeltzoto ix yintaj, istꞌan̈xico ix yin̈ Comam, yalni ix yin̈ abxubal hebreo: “Raboni,” ẍi ix. Maestro, haꞌ chaliloj huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yalni Comam tet ix: —Bejtzoinan, mach chinhatzaban yuto maẍto chinapnihan iscꞌatan̈ Inmaman. Wal tinan̈ xin, as hal tet ebnaj wuẍtajan tato chinpaxtojan iscꞌatan̈ Inmaman, haꞌ Hemampaxoj, inDiosalan, heDiosalpaxoj, ẍi Comam tet ix. ");
INSERT INTO jacNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yuxin to ix María ah Magdala tuꞌ yalaꞌ tet ebnaj iscuywom Comam, yalni ix hacaꞌ tiꞌ: —Caw mawilan yin̈ Comam Jesús, ẍi ix. Lahwi tuꞌ yalni ix tet ebnaj yin̈ tzet yal Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yet babel tzꞌayic yin̈ semana tuꞌ yet lan̈an yah akꞌbal cutxanico ebnaj iscuywom Comam. Caw caw yecano ispulta ebnaj yu, yuto caw chixiw ebnaj tet ebnaj yahawil yin̈ ebnaj Israel. Yoc apno Comam bey tuꞌ, yoc lin̈no Comam yictabal ebnaj, yalni Comam tet ebnaj: —Ayojab akꞌancꞌulal texol, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yet lahwi yalni Comam huneꞌ tuꞌ, isyeni Comam iskꞌab tet ebnaj yeb ismotx bay to chꞌen lanza. Hayet yilni ebnaj Comam tuꞌ xin, caw occano huneꞌ niman tzalahilal yin̈ yanma ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yalni Comam tet ebnaj hunelxa: —Ayojab akꞌancꞌulal texol. Hacaꞌ yu walaxtijan yu Inmaman, hac tuꞌ xin chiyu quexwanitojan, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lahwi tuꞌ xin, yanilto Comam xob istiꞌ, yalni Comam: —Chahwecano Espíritu Santo, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Haꞌ mac chitan̈cano ismul yiban̈ heyu, chitan̈cano ismul yiban̈ yu Comam Dios. Wal mac mach chitan̈cano ismul yiban̈ heyu xin, caw mach chitan̈paxo ismul yiban̈ yu Comam Dios, ẍi Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ay xin huneꞌ naj xol ebnaj cablahon̈wan̈ iscuywom Comam Jesús tuꞌ, Tomás isbi, naj chihallax “Tioẍ uninal.” Machi naj ayco xol ebnaj iscuywom Comam tuꞌ yet isyeni isba Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yuxinto yal ebnaj tet naj Tomás tuꞌ: —Caw majilan̈ yin̈ Comam, ẍi ebnaj. —Istakꞌwi naj: —Tato mach chiwilan bay tona chꞌen lawuẍ yul iskꞌab Comam cat wanicto yiximal inkꞌaban yul, yeb ta mach chintzaban bay tona chꞌen lanza yul ismotx Comam, caw mach chiwaytojan yul wanmahan, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Semanahilxa tuꞌ xin, iscutxbanpaxo isba ebnaj hunelxa yul n̈a, ayicto xin naj Tomás tuꞌ xol ebnaj, caw xin cꞌul yecanico ispultahil teꞌ n̈a bay ayicto ebnaj tuꞌ. Yoc apno Comam bey tuꞌ, yoc lin̈no Comam yictabal ebnaj, yalni Comam: —Ayojab akꞌancꞌulal texol, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lahwi tuꞌ xin yalni Comam tet naj Tomás: —Tomás, acto yiximal hakꞌab yul isholanil inkꞌabtiꞌan lah, cat hawanipaxicto yul isholanil inmotxan. Mach chicabcon hacꞌul, ayto yul hawanma win̈an, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lahwi tuꞌ xin, yalni naj Tomás tuꞌ tet Comam: —¡Hach Wahawil, hach inDiosalan! ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yalni Comam Jesús tet naj xin: —Caw mato xawilico win̈an maxawanayto yul hawanma. Wal xin, aytam sakꞌal yet anma mach yechto chinyilan cat xin quinyanaytojan yul yanma, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Caw xin txꞌiꞌalto cꞌaybalcꞌule isye Comam Jesús yilaꞌ ebnaj iscuywom mach tzꞌibn̈ebilayo yul huneꞌ hum tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yajaꞌ tzꞌibn̈ebilcano huntekꞌan tiꞌ yun̈e heyanayto yul heyanma tato haꞌ Comam Jesús, haꞌ ton Cristo, Iscꞌahol Comam Dios. Haxinwal yet cheyanayto yul heyanma, chechah hekꞌinal mach istan̈bal yin̈ isbi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lahwi tuꞌ xin, isyenipaxocan̈ isba Comam Jesús hunelxa tet ebnaj iscuywom yet ay ebnaj istiꞌ haꞌ lago Tiberias. Hac tiꞌ xin yu isyeni isba Comam tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Istiꞌ haꞌ lago tuꞌ ayayo naj Simón Pedro, yeb naj Tomás, naj chihallax tioẍ uninal, yeb xin naj Natanael ah Caná ay yul ismajul Galilea, yeb xin cawan̈ ebnaj iscꞌahol icham Zebedeo, yebpaxo xin cawan̈xa ebnaj iscuywom Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yalni naj Simón Pedro: —Chintohan tzabo cay, ẍi naj. Yalnipaxo huntekꞌanxa ebnaj tuꞌ: —Chon̈tohan̈ tawintaj, ẍi ebnaj. Hac tuꞌ xin yu isto ebnaj. Yocto ebnaj yul huneꞌ teꞌ barco, yajaꞌ xin maẍticꞌa hunu noꞌ cay istzab ebnaj yin̈ huneꞌ akꞌbal tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yet lan̈anxa issajbilo xin, lin̈anxacan̈ Comam Jesús istiꞌ haꞌ. Wal ebnaj iscuywom Comam tuꞌ xin, caw maẍticꞌa txumchalo Comam yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yalni Comam tet ebnaj: —¡We ach! ¿Tom caw maẍto noꞌ chiahti heyu? ẍi Comam. Istakꞌwi ebnaj: —Caw machi noꞌ, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yalni Comam tet ebnaj: —Aweyto hehacꞌ yin̈ hewatxꞌkꞌab, haxinwal cheyikꞌ noꞌ, ẍi Comam tet ebnaj. Hac tuꞌ xin yu yanayto ebnaj ishacꞌ tuꞌ xol haꞌ hunelxa, haxa yet yinahti ebnaj txꞌan̈ xol haꞌ xin, caw matxa chikꞌoji ebnaj yinahti txꞌan̈ yu yalil noꞌ nohayto yul txꞌan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Haꞌ xin naj iscuywom Comam caw xahan ay yu, yal naj tet naj Pedro: —¡Haꞌ Comam huneꞌ tiꞌ! ẍi naj. Yaben̈e naj Pedro tato haꞌ Comam huneꞌ tuꞌ, yanico naj xil iskꞌap, yuto yuln̈e kꞌap ayco yin̈ naj. Caw xin yin̈ an̈e isbejtzoto isba naj xol haꞌ, isto naj yilno Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yuxin haxa huntekꞌanxa ebnaj n̈icꞌniti teꞌ barco istiꞌ haꞌ lago tuꞌ. Hatxbil xin txꞌan̈ hac tuꞌ yu ebnaj, nohna txꞌan̈ yu noꞌ cay tuꞌ. Can̈ebn̈em xin txꞌan̈il yehicꞌto teꞌ yin̈ istiꞌ haꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yet yapni ebnaj istiꞌ haꞌ tuꞌ xin, yilni ebnaj huneꞌ kꞌa kꞌaꞌ, batxanayo huneꞌ noꞌ cay yiban̈ tzakꞌakꞌ. Aypaxayo ixim pan iscꞌatan̈. ");
INSERT INTO jacNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yalni Comam tet ebnaj: —Iweti haycꞌon̈o noꞌ cay maxeyikꞌ tuꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hac tuꞌ xin yu yahto naj Pedro tuꞌ yul teꞌ barco, ispuhnilo naj txꞌan̈, ishatxnilo naj txꞌan̈ istiꞌ haꞌ. Waxan̈ca caw nohna txꞌan̈ yu noꞌ cay tuꞌ, yaj caw maẍticꞌa lin̈moto txꞌan̈; caw xin ciento cincuenta y tres noꞌ yikꞌ ebnaj yin̈ sunil. ");
INSERT INTO jacNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lahwi tuꞌ xin, yalni Comam tet ebnaj: —Catawej, waꞌan̈wej, ẍi Comam. Caw xin machi hunu ebnaj kꞌamben mac anmahil Comam, yuto caw yohta ebnaj tato haꞌ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Lahwi tuꞌ xin, isto Comam yinocan̈ ixim pan, yakꞌni Comam ixim tet ebnaj. Hacticꞌa tuꞌ yutepaxo Comam yin̈ noꞌ cay. ");
INSERT INTO jacNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Haꞌ yin̈ hunel tuꞌ xin, tzꞌajna yoxel isyeni isba Comam tet ebnaj iscuywom yet xaitzitzbican̈ Comam xol camom. ");
INSERT INTO jacNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Lahwi iswaꞌ ebnaj xin, yalni Comam Jesús tet naj Simón Pedro: —Simón, iscꞌahol naj Juan, ¿caw xahanmi ayinan hawu sata ebnaj tiꞌ? ẍi Comam. Istakꞌwi naj Pedro: —Hoꞌ Mamin, caw hawohtaj tato xahan ayach wuhan, ẍi naj tet Comam. —Ta hac tuꞌ chal tuꞌ, hacaꞌ chute hunu naj tan̈em meꞌ islotzen noꞌ niẍte yunin, hac tuꞌ chawute hacuyni macta chiyaco isba yul inkꞌaban, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Lahwi tuꞌ xin, yalni Comam yin̈ iscayel: —Simón, iscꞌahol naj Juan, ¿caw xahanmi ayinan hawu? ẍipaxo Comam tet naj. —Hoꞌ Mamin, caw hawohtaj tato caw xahan ayach wuhan, ẍipaxo naj Pedro tuꞌ. Yalni Comam tet naj xin: —Ta hac tuꞌ chal tuꞌ, hacaꞌ chiyute istan̈en hunu naj tan̈em meꞌ ismeꞌ, hac tuꞌ chawute hawilni anma chiyaco isba yul inkꞌaban, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yalnipaxo Comam yet yoxel tet naj: —Simón, iscꞌahol naj Juan, ¿caw yelmi xahan ayinan hawu? ẍi Comam tet naj. Hac tuꞌ xin yu yoc biscꞌulal yin̈ iscꞌul naj Pedro yuto yetxa yoxel iskꞌamben Comam tet naj tato yeli xahan ay Comam yu naj. Yuxinto yal naj: —Mamin, walach hach tiꞌ, caw sunil tzet hawohtaj, caw xin hawohtaj tato caw yeli xahan ayach wuhan, ẍi naj tet Comam. Istakꞌwi Comam: —Ta hac tuꞌ chal tuꞌ, caw hacaꞌ chiyute hunu naj tan̈em meꞌ islotzen noꞌ niẍte yunin, hac tuꞌ chawute hacuyni macta chaco isba yul inkꞌaban. ");
INSERT INTO jacNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yin̈ caw isyelal chiwalan tawet, yet caw tzehach to, caw chawatxꞌeco iscꞌalil hawictaj. Haꞌ cawxencan̈ haba, hasaynito haba bayticꞌa chal hacꞌul. Wal yet chachichambi xin, toxan̈e chawican̈ hakꞌab, nanxa mac chꞌanico xil hakꞌap, cat hawilaxto bay mach isjeto hacꞌul, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yal Comam hacaꞌ tiꞌ tet naj Pedro tuꞌ yun̈e yohtan̈enilo naj yin̈ tzet chiyu iscami, cat xin isyenilo isba yip Comam Dios yin̈ iscamical naj Pedro tuꞌ. Lahwi tuꞌ xin yalni Comam: —Ocan̈ tzujno wintajan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lahwi tuꞌ xin, istꞌan̈xiti naj Pedro yintaj, yilni naj tato tzujanpaxo naj iscuywom Comam caw ochebil yu, naj tzꞌon̈an iscawilal Comam yet iswaꞌ yeb iscuywom, naj kꞌamben tet Comam hacaꞌ tiꞌ: “Mamin, ¿mac chaẍanico yul iskꞌab camical?” ẍi. ");
INSERT INTO jacNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yet yilni naj Pedro tato tzujan naj xin, iskꞌamben naj tuꞌ tet Comam Jesús: —Mamin, ¿haxaca naj tzujan jinta tiꞌ, tzet chiyub iscamopaxo naj? ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Istakꞌwi Comam: —Tato chiwochehan ayton̈eticꞌacꞌo naj yet chinhulan hunelxa, wal xin machi hawoc yin̈. Hachcachann̈e chachoc tzujno wintajan, ẍi Comam tet naj Pedro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hac tuꞌ xin yu yelto iskꞌumal xol ebnaj ayxaco yul iskꞌab Comam tato mach chicam huneꞌ naj iscuywom Comam tuꞌ, yaj mach yal Comam tato mach chicam naj, wal xin yal Comam: “Tato chiwochehan ayton̈eticꞌacꞌo naj tiꞌ yet chinhulan, caw machi hawoc yin̈,” ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Huneꞌ naj iscuywom Comam tiꞌ, haꞌ naj caw chihalni sunil huntekꞌan tiꞌ, haꞌ xin tzꞌibn̈encanoj. Yuxinto caw johtaj tato caw yel tzet tzꞌibn̈ebilcano tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Caw hantan̈eto tzet iswatxꞌe Comam Jesús tuꞌ. Kꞌinalo tato caw hununtajil le-yu istzꞌibn̈elaxcanoj, caw machim chiyabe huneꞌ yul sat yiban̈kꞌinal tiꞌ yu teꞌ hum tato tzꞌibn̈elaxi. ¡Hacojab tuꞌ!");
INSERT INTO jacNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hanin Lucas intiꞌan, chintzꞌibn̈etojan huneꞌ hum tiꞌ tawet mam Teófilo. Wal xin yul huneꞌxa hum tzꞌibn̈ebilxato tawet wuhan yet yalan̈tocanoj, waltojan tawet tzettaj ye tuꞌ iswatxꞌe Comam Jesús, yeb xin yin̈ sunil cuybanile yakꞌ Comam iscuyuꞌ anma yichtax istzabnico Comam iscuywa xol anma, ");
INSERT INTO jacNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","masanta yet yapni istzꞌayical ispaxcanto Comam yul satcan̈. Yet maẍto chipaxto Comam tuꞌ, yalnicano Comam ischejbanil ebnaj ischejab sicꞌbililo yu, yu yip Comam Espíritu Santo. ");
INSERT INTO jacNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hayet lahwi iscam Comam xin, yitzitzbipaxocan̈ Comam xol camom, caw txꞌiꞌalto el isye isba Comam tet ebnaj ischejab. Yulbal cuarenta tzꞌayic isye isba yun̈e istxumnilo ebnaj tato caw yeli itzitzbican̈ Comam. Istzotel Comam tet ebnaj yin̈ tzet chu yoc anma yul iskꞌab Comam Dios yun̈e yoc Comam Yahawilo anma. ");
INSERT INTO jacNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yet aytocꞌo Comam xol ebnaj ischejab tuꞌ, yalnicano Comam tet ebnaj: —Canan̈wecano yul con̈ob Jerusalén tiꞌ, echmawe yul huneꞌ tzet halbilcano teyet yu Inmaman hacaꞌ wute walnihan teyet. ");
INSERT INTO jacNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wal naj Juan, caw yeli han̈e ha haꞌ yakꞌ naj yahbalo haꞌ iswiꞌ anma, walex tiꞌ xin, yulbal hayebxan̈echꞌan tzꞌayic cat hechahni Comam Espíritu Santo yul heyanma hacaꞌ yahbalo haꞌ hewiꞌ, ẍicano Comam Jesús tet ebnaj ischejab tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yet cutxantoco ebnaj ischejab Comam Jesús iscꞌatan̈, iskꞌambenilo ebnaj tet Comam hacaꞌ tiꞌ: —Mamin, ¿ham tinan̈ chacolcanilti ebnaj jet con̈ob Israel tiꞌ yalan̈ yip bay ayon̈ico tiꞌ? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yalni Comam tet ebnaj: —Mach heyeto heyohtan̈enilo istzꞌayical yeb xin istiempohal yin̈ tzet ye tuꞌ han̈cꞌan̈e Comam Dios ay yoc yin̈ yalnilo tzet yehi. ");
INSERT INTO jacNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yaj xin chiyakꞌ Comam Dios yip teyet hununex yet chul Comam Espíritu Santo yul heyanma. Chilahwi tuꞌ xin, cat heyanico heba heyalnilo intzotiꞌan yul con̈ob Jerusalén tiꞌ, yebpaxo yul sunil ismajul Judea, yeb xin yulaj ismajul Samaria masanto chiabchalo yu sunil anma ay yul sat yiban̈kꞌinal tiꞌ, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yet lahwi yalnicano Comam Jesús huntekꞌan tuꞌ, yilaxto Comam yul satcan̈. Caw xin tꞌan̈ancanahto ebnaj ischejab Comam tuꞌ yet iscꞌaycanocan̈ Comam xol moyan. ");
INSERT INTO jacNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yet tꞌan̈anahto ebnaj yilni isto Comam satcan̈, isyenican̈ isba cawan̈ ebnaj ángel caw sajhopon̈e xil iskꞌap, yoc lin̈no ebnaj iscꞌatan̈ ebnaj ischejab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yalni ebnaj ángel tet ebnaj hacaꞌ tiꞌ: —Hex ah Galilea, ¿tzet yin̈ xin to tꞌan̈anex ahto satcan̈? Haꞌ Comam Jesús tiꞌ, maꞌilaxilo texol yu ispaxto Comam satcan̈. Hacaꞌticꞌa mayu heyilni isto Comam tiꞌ, hac tuꞌ xin chu yulpaxo Comam, ẍi ebnaj ángel tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lahwi tuꞌ xin, ispaxayti ebnaj ischejab Comam Jesús bey huneꞌ won̈an chiyij Olivo, ismeltzo ebnaj bey yul con̈ob Jerusalén. Etza yicta legua yelo won̈an tuꞌ yin̈ con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lahwi yapni ebnaj yul con̈ob, yahto ebnaj yul huneꞌ cuarto yin̈ iscab piso bay ay isposada ebnaj. Haꞌ ton xin naj Pedro, naj Jacobo yeb naj Juan, naj Andrés, naj Felipe, naj Tomás, naj Bartolomé, naj Mateo, yeb naj Jacobo, iscꞌahol icham Alfeo, yebpaxo xin naj Simón, naj ayticꞌaco yin̈ huneꞌ partido chiyij Cananista. Aypaxo xin huneꞌxa naj chiyij Judas, iscꞌahol naj Jacobo. ");
INSERT INTO jacNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hununn̈eticꞌa tzꞌayic xin, iscutxban isba ebnaj sunil yeb yuẍta Comam Jesús yu istxahli ebnaj tet Comam Dios. Aypaxo huntekꞌan ebix chitxahli yinta ebnaj. Xol ebix tuꞌ, ayco ix María, ismiꞌ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Haꞌ yin̈ huneꞌ tiempohal tuꞌ, aymi hunu ciento veinte anma ayco yul iskꞌab Comam cutxanico bey tuꞌ. Lahwi tuꞌ xin, yah lin̈no naj Pedro xol ebnaj tuꞌ, yalni naj: ");
INSERT INTO jacNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Hex wuẍtaj, hex wanab, caw yilal yijni isba hacaꞌ yu istzꞌibn̈encano naj rey David yet payxa yu Comam Espíritu Santo yin̈ naj Judas, naj yewa tet ebnaj tzabnayo Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Naj Judas tuꞌ, ayco naj jetbiho yet yalan̈tocanoj, huneꞌn̈e comunil yeb naj. ");
INSERT INTO jacNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yu istohol istxꞌojal iswatxꞌe naj yin̈ Comam, islokꞌ naj huneꞌ txꞌotxꞌ. Lahwi tuꞌ xin istit xulna naj, ispohto iswiꞌ naj, hac tuꞌ yu yelti chꞌitna yul iscꞌul naj, istan̈ilo naj. ");
INSERT INTO jacNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sunil anma ay yul con̈ob Jerusalén aben iskꞌumal huneꞌ tiꞌ, yuxinto Acéldama occano isbiho huneꞌ txꞌotxꞌ tuꞌ yin̈ yabxubal anma. Haꞌ chal yelapnoj txꞌotxꞌ lokꞌbil yu istohol chicꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yuto hac tuꞌ yalni yul Yum Comam Dios yin̈ Salmos: Canojabcano huneꞌ yatut naj tuꞌ ischuquil, machojab mac xin chꞌoc yahawoj, ẍi. Chalnipaxoj: Ocojab hunoxa mac selelo yin̈ ismunil, ẍicano yul Hum tuꞌ, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yalnipaxo naj Pedro: —Yuxin cosayaꞌwelo hunuxa mac chioc selelo naj Judas tuꞌ, cat yoc yalnocꞌo xol anma tato caw yeli itzitzbican̈ Comam Jesús. Haꞌ hunu mac chicosayilo tuꞌ yilal xaecꞌ tzujtzun jinta yet yah haꞌ iswiꞌ Comam Jesús yu naj Juan masanta yet istocano Comam yul satcan̈, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yuxin issayilti ebnaj cawan̈ ebnaj tuꞌ. Huneꞌ naj chiyij Matías, huneꞌxa naj José Barsabás isbi, chiyijpaxo Justo. ");
INSERT INTO jacNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lahwi tuꞌ xin, istxahli ebnaj sunil hacaꞌ tiꞌ: —Mamin, caw hawohtaj tzet ye yanma hunun anma, yuxin ye jetan̈ mac huno ebnaj cawan̈ tiꞌ sicꞌbilxalo hawu. ");
INSERT INTO jacNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yun̈e ischahni hamunil bejbilcano yu naj Judas, yet istocano naj bayticꞌa caw tꞌin̈an istohi, ẍi ebnaj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lahwi tuꞌ yilwen ebnaj mac chicancano yin̈ huneꞌ munil tuꞌ. Cꞌuxan xin yapni yin̈ naj Matías. Hac tuꞌ xin yu yoccano naj yetbiho ebnaj hunlahon̈wan̈ ischejab Comam Jesucristo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yet yayilo istzꞌayical kꞌin̈ Pentecostés, huneꞌn̈e bay cutxanico sunil ebnaj yeb ebix ayxaco yul iskꞌab Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Caw hunepixto xin yaben ebnaj tuꞌ isbili istit huneꞌ hacaꞌ jakꞌekꞌ yul satcan̈ yin̈ caw ip chieqꞌui. Isbilipaxo sunil yul n̈a bay ayicto yuninal Comam Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lahwi tuꞌ xin yilni ebnaj yayilo hacaꞌ xaj kꞌa kꞌaꞌ, ispujnacan̈ yiban̈ iswiꞌ hunun tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sunil ebnaj yeb ebix tuꞌ occano yalan̈ ischejbanil Comam Espíritu Santo yoc tzotelo yin̈ nananta abxubal yu yip Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yin̈ huneꞌ tiempohal tuꞌ, caw txꞌiꞌal anma Israel ayco yanma yin̈ Comam Dios, cutxanico yul con̈ob Jerusalén tuꞌ. Caw nananta bay titico anma tuꞌ yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yet yaben anma isbili huneꞌ hacaꞌ jakꞌekꞌ tuꞌ, iscutxbanico isba anma bey huneꞌ n̈a tuꞌ. Caw cꞌaycan̈ iscꞌul anma yaben istzotel macta ayxaco yul iskꞌab Comam yul yabxubal hunun anma tuꞌ. Yuto sunil yabxubal anma yal ebnaj yeb ebix ayxaco yul iskꞌab Comam Jesucristo. ");
INSERT INTO jacNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Caw cꞌaycan̈ iscꞌul anma yoc tꞌan̈no yin̈ ebnaj chitzotel tuꞌ. Yalni anma hacaꞌ tiꞌ: —Wal huntekꞌan ebnaj yeb ebix chitzotel tiꞌ, caw ah Galilea sunil. ");
INSERT INTO jacNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tzimi yin̈ xin chijabe istzotel ebnaj yul jabxubal bay pitzcꞌanajon̈ hununon̈? ");
INSERT INTO jacNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wal xin coxol han̈on̈ tiꞌ ay anma titna yul ismajul Partia, aypaxo anma ah Media, ay anma ah Elam. Aypaxo anma ah Mesopotamia, aypaxo anma ah Judea, yeb Capadocia yeb Ponto, yeb anma ay yul ismajul Asia. ");
INSERT INTO jacNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aypaxo anma ah Frigia, yeb anma ah Panfilia, yeb anma ah Egipto. Aypaxo anma titna yul ismajul Africa bey iscawilal Cirene, yeb xin aypaxo anma ah con̈ob Roma. Xol sunil anma tiꞌ xin, ay anma jet Israelal, yebpaxo xin mac xayaco isba hacaꞌ bay ayon̈ico han̈on̈ Israel hon̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aypaxo anma ah Creta, yebpaxo anma ah Arabia, yajaꞌ cosunil han̈on̈ tiꞌ chijabe istzotel ebnaj yeb ebix yul jabxubal yin̈ iscꞌulal iscꞌul Comam Dios, ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Caw toxan̈e chicꞌay iscꞌul sunil anma, issomchalo yul iswiꞌ, yuxin iskꞌambele anma tet hunun hacaꞌ tiꞌ: —¿Tzet chalilo huntekꞌan chijabe tiꞌ? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aypaxo huntekꞌanxa anma chibuchwahi, le-yalni hacaꞌ tiꞌ: —Haꞌ huntekꞌan ebnaj yeb ebix tiꞌ, caw ucꞌum ebnaj, ẍi anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yuxin ah lin̈no naj Pedro yeb ebnaj hunlahon̈wan̈xa yetbi tuꞌ, istzablo istzotel naj xol sunil anma yin̈ caw ip hacaꞌ tiꞌ: —Hex ay bey yul ismajul Judea, yeb xin sunilex nananta con̈obal aycꞌo yul con̈ob Jerusalén tiꞌ, caw chiwakꞌan heyohtan̈eloj tzet yelapno ye huneꞌ tiꞌ. Wal xin, haj hetxiquin yin̈ tzet chiwalan. ");
INSERT INTO jacNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Han̈on̈tiꞌan̈ mach ucꞌumojon̈an̈ hacaꞌ cheyute hetxumni jin̈an̈, yuto sahab sacꞌayal ayon̈ tinan̈ yin̈ chꞌen balon̈eb. ");
INSERT INTO jacNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wal xin, lan̈an yijni isba tzet halbilcano yul Yum Comam Dios yu naj Joel, ischejab Comam Dios yet payat, ");
INSERT INTO jacNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","bay yalcano hacaꞌ tiꞌ: Yet chꞌapni islahobal tzꞌayic, chiwatijan Wespírituhan yiban̈ anma yul sat yiban̈kꞌinal tiꞌ. Yuxin haꞌ ej hecꞌahol yebpaxo ej hecutzꞌin, haꞌ chalnolo Intzotiꞌan. Chinyehan huntekꞌan cuybanile tet ebnaj tzehtaj yin̈ sajsatil. Yebpaxo ebnaj ichamtaj chintzotelan tet ebnaj yul iswayic. ");
INSERT INTO jacNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yet huneꞌ tiempohal tuꞌ chiwaco Wespírituhan yin̈ sunil anma chiyakꞌ chejaꞌ isba wetan, ebnaj winaj yeb ebix ix, cat yalnicꞌo ebnaj yeb ebix Intzotiꞌan tet anma. ");
INSERT INTO jacNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chinyehan cꞌaybalcꞌule yul satcan̈ tet anma, cat iscꞌayilo iscꞌul yilni. Yeb xin bey yul sat yiban̈kꞌinal tiꞌ, chinyehan huneꞌ tzet chiyenilo wipan tet anma. Haꞌ huntekꞌan tiꞌ xin, haꞌ ton chicꞌ yeb kꞌa kꞌaꞌ, yeb huneꞌ niman n̈ub hacaꞌ moyan, ẍi Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chiꞌoc kꞌejholo yin̈ sat tzꞌayic, wal yin̈ ixahaw xin, caw cajpon̈pon̈e chucoj hacaꞌ chicꞌ. Haꞌ huntekꞌan tiꞌ babel chiyu yet maẍto chihul huneꞌ istzꞌayical bay chul Comam Dios Yahawil. Huneꞌ tzꞌayic tuꞌ, caw niman yelapno yehi, yebpaxo aytam sakꞌal. ");
INSERT INTO jacNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Haꞌ yin̈ huneꞌ tzꞌayic tuꞌ xin, haꞌ mac chiawten Comam Yahawoj chicolchahi, ẍicanoj. ");
INSERT INTO jacNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hex wet con̈ob Israel, hajba hetxiquin yin̈ tzet chalilo huneꞌxa chiwalan teyet tiꞌ: —Caw xaꞌisyelo Comam Dios ismunil Comam Jesucristo ah Nazaret jet cosunil, yet iswatxꞌen Comam Jesús iscꞌulal yeb cꞌaybalcꞌule yeb yechel yip Comam Dios. Wal xin caw heyohtaxa sunil tiꞌ yuto haꞌ coxol yuhi. ");
INSERT INTO jacNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wal xin alaxico Comam Jesucristo yul hekꞌab yuto hac tuꞌ yoche iscꞌul Comam Dios. Caw xin yohtaxa Comam Dios yettax payat yin̈ tzet chihul yiban̈ Comam Jesucristo. Walex hex tiꞌ xin, hekꞌan iskꞌab ebnaj txꞌoj yu yanican̈ ebnaj Comam yin̈ teꞌ culus. Hac tuꞌ xin yu iscam Comam heyu. ");
INSERT INTO jacNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wal xin itzitzbican̈ Comam yu Comam Dios. Iscolnilo yul iskꞌab camical yuxin machi yu iskꞌoji huneꞌ camical tuꞌ ismajchenayo Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Naj rey David yet payat, yalcano naj huntekꞌan Tzotiꞌ yal Comam Jesucristo hacaꞌ tiꞌ: Sunilbal tiempo wohtajan tato ay Comam Dios incꞌatan̈an. Ayn̈eticꞌaco Comam yin̈ inwatxꞌkꞌaban, hac tuꞌ xin machi mac chiakꞌni cabconcan̈ wanmahan, cat waycꞌayan. ");
INSERT INTO jacNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yuxin caw chitzala wanmahan, chintzotelan yin̈ caw tzalahilal. Waxan̈ca chicam innimaniltiꞌan, yaj chicawxi incꞌulan yin̈ Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mamin, mach chahincꞌuln̈e wanmahan xol anma camom, mach chawakꞌ kꞌajoꞌto innimanilan xol anma camom tuꞌ, hanin sicꞌbil incan̈an hawu. ");
INSERT INTO jacNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xahaye huneꞌ beh chꞌakꞌni kꞌinale ayn̈eticꞌa sunilbal tiempo wetan. Caw chawakꞌ tzalaho wanmahan yet chinapnihan tacꞌatan̈, ẍi Comam Jesús. Hac tuꞌ yu istzꞌibn̈encano naj rey David yin̈ tzet yal Comam Jesucristo, ẍi naj Pedro tet anma bey Jerusalén tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yalnipaxo naj Pedro: —Hex wet con̈ob, yin̈ caw isyelal chiwalan teyet, naj jichmam David tuꞌ, caw johtaj tato cam naj, ismujlaxpaxo naj. Haꞌ bay mujan naj tuꞌ xin, caw ixtan̈to coxol tinan̈. ");
INSERT INTO jacNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wal naj rey David tuꞌ, ischejab Comam Dios ye naj. Caw xin yohta naj tato haltebilcano yu Comam Dios tet naj tato yin̈ yuninal yuninal naj chipitzcꞌa Comam Cristo, cat yoccano Jahawo isselelo naj. ");
INSERT INTO jacNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yuxin yet caw yalan̈tocano tuꞌ, akꞌlax yohtan̈elo naj, yuxin yalcano naj tato chiitzitzbican̈ Comam Jesucristo. Yalnipaxo naj tato mach chicancano yanma Comam xol camom anma, machi xin chichahlax kꞌajoꞌto isnimanil Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Haꞌ xin Comam Dios akꞌni itzitzbocan̈ isnimanil Comam Jesucristo tuꞌ. Cosunilan̈ chijakꞌ cobahan̈ testigohal yin̈ huneꞌ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Haꞌ Comam Dios inito Comam Jesucristo yul satcan̈ yu yoc tzꞌon̈no Comam yin̈ iswatxꞌkꞌab Comam Dios. Yakꞌni Comam Dios Comam Espíritu Santo tet Comam Cristo hacaꞌ yu yalnicanoj. Yuxin haꞌ Comam Jesús aniti tzet lan̈an heyilni tiꞌ, yeb huneꞌ cheyabe tiꞌ. Hac tuꞌ chu isyenicanilo isba yulbal Comam Espíritu Santo jiban̈an̈. ");
INSERT INTO jacNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Naj David tuꞌ, mach beyahto naj yul satcan̈ yaj xin yalpaxo naj hacaꞌ tiꞌ: —Yal Comam Dios Jahawil tet wahawilan: “Ayan̈ tzꞌon̈no yin̈ inwatxꞌkꞌabtiꞌan, ");
INSERT INTO jacNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","masanto chiwacojan anma ayco ishowal tawin̈ yalan̈ hawoj,” ẍi Comam Dios, ẍi naj rey David. ");
INSERT INTO jacNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tinan̈ xin, yilal heyabencano yin̈ caw ishabanil hex wet con̈ob Israel. Waxan̈ca xaheyacan̈ Comam Jesús yin̈ teꞌ culus, yaj haꞌ Comam Dios anico Comam Jesús Yahawiloj, yeb xin yin̈ Cristohal, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yet yaben anma Israel sunil tzet yal naj, cꞌayilo iscꞌul anma, yoc biscꞌulal yin̈ yanma anma tuꞌ. Iskꞌamben anma tet naj Pedro yeb xin tet huntekꞌanxa ebnaj ischejab Comam Jesucristo: —Hex wet con̈ob, ¿tzet wal juten cobahan̈ tinan̈ heyalni? ẍi anma. ");
INSERT INTO jacNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Istakꞌwican̈ naj Pedro tet anma hacaꞌ tiꞌ: —Bejwe hewatxꞌen istxꞌojal, cat yahcano haꞌ hewiꞌ hununex yin̈ isbi Comam Jesucristo, cat yakꞌlaxcano nimancꞌulal yin̈ hemul. Hac tuꞌ xin chu hechahnicano Comam Espíritu Santo yul heyanma hununex. ");
INSERT INTO jacNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Huneꞌ tiꞌ hallax jet yeb tet juninal yeb tet sunil anma nahat aya, sunil huntekꞌan mac chawte Comam Dios, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wal xin, txꞌiꞌalto tzet yal naj, yoc naj yiptzeno anma tuꞌ, yalni naj hacaꞌ tiꞌ: —Colwelo heba tet isyaꞌtajil chihul yiban̈ anma txꞌoj chiswatxꞌe, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Caw hanta mac chahni Comam yul yanma yu tzet yal naj Pedro, yahcano haꞌ iswiꞌ anma tuꞌ. Haꞌ yin̈ huneꞌ tzꞌayic tuꞌ xin, aymi oxebo mil anma occano yetbiho ebnaj ayxaco yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hac tuꞌ xin chilann̈eticꞌa iscutxꞌban isba ebnaj yeb ebix yaben iscuywa ebnaj ischejab Comam. Huneꞌn̈e xin yute yanma ebnaj, chiswahni ebnaj ixim pan, chitxahlipaxo ebnaj tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sunil anma cꞌayilo iscꞌul yin̈ huntekꞌan cꞌaybalcꞌule yeb xin yechel yip Comam Dios isye ebnaj ischejab Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Haꞌ anma chahnicano Comam Jesús yul yanma tuꞌ, caw huneꞌxan̈e anma elico sunil, yebpaxo xin caw huneꞌxan̈e yutecanayo ebnaj tzettaj aya. ");
INSERT INTO jacNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ay ebnaj txon̈nito istxꞌotxꞌ yeb tzettaj aya, haxa istohol tuꞌ xin, ispohcan̈ ebnaj yin̈ anma hataticꞌa hanta chiꞌocnico yu hunun. ");
INSERT INTO jacNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Caw hunun tzꞌayic iscutxban isba ebnaj yul yatut Comam Dios, yuto huneꞌxan̈e isnabal ebnaj. Wal yulaj yatut ebnaj xin, chispohcan̈ ebnaj ixim pan, cat iswahni ebnaj ixim yin̈ caw tzalahilal, yeb xin caw cꞌulchꞌan chiyute iscꞌul ebnaj yin̈ hunun. ");
INSERT INTO jacNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Chisbitn̈en ebnaj Comam Dios, caw xin chitzala sunil anma yin̈ ebnaj. Yeb xin caw hunun tzꞌayic ischꞌibcan̈ isbisil yuninal Comam Jesús yu anma chaco isba yul iskꞌab Comam yun̈e iscolchahi. ");
INSERT INTO jacNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yet hunel yin̈ chꞌen oxeb yin̈ kꞌejbiyalil to naj Pedro yeb naj Juan yul yatut Comam Dios, yuto yin̈ huneꞌ orahil tuꞌ chitxahli ebnaj Israel yul yatut Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ay huneꞌ naj tiꞌ xin, caw mach chu isbelwi yichitax ispitzcꞌahi. Caw xin hunun tzꞌayic isbey yalaxocano naj istiꞌ ispultahil yatut Comam tuꞌ, huneꞌ chiyij Cꞌulchꞌan Jilni, yu iskꞌanni naj ismelyu tet anma chiocto bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hayet yilni naj yocto naj Pedro yeb naj Juan yul pulta tuꞌ, iskꞌanni naj melyu tet ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yoc tꞌan̈no naj Pedro yeb naj Juan tuꞌ yin̈ naj, yalni naj Pedro hacaꞌ tiꞌ: —Ocan̈ tꞌan̈no jin̈an̈, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yoc tꞌan̈no naj yin̈ ebnaj cawan̈ tuꞌ, haꞌ yute istxumni naj to melyu chiakꞌlax tet naj yu ebnaj cawan̈ tuꞌ yalni. ");
INSERT INTO jacNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yalni naj Pedro: —Wal hanintiꞌan, mach inmelyuhan, yaj wal huneꞌ ikꞌbil wuhan chiwakꞌan tawet. Yu yip Comam Jesucristo ah con̈ob Nazaret, ahan̈wanoj cat xin habelwi, ẍi naj Pedro tuꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yoc tzabno naj Pedro tuꞌ yin̈ iswatxꞌkꞌab naj, isxecnican̈ naj naj. Caw xin yin̈ an̈e occano yip yoj naj, yikꞌnipaxcanocan̈ yip isnukꞌ yoj naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yah lin̈no naj xin, istzabnico naj isbelwi, yocto naj yul yatut Comam Dios yinta ebnaj cawan̈ tuꞌ. Caw chitꞌujla yah naj yu tzalahilal, yalni naj tzotiꞌ cꞌul yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wal sunil anma ilni isbelwi naj, yeb yaben yalni naj tzotiꞌ cꞌul yin̈ Comam Dios, ");
INSERT INTO jacNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","caw cꞌayilo iscꞌul yeb caw xiwpaxo anma yilni huneꞌ tuꞌ, yuto yohta anma tato caw hunun tzꞌayic yay tzꞌon̈no naj iskꞌanno ismelyu tet anma istiꞌ ispultahil yatut Comam Dios chiyij Cꞌulchꞌan Jilni. ");
INSERT INTO jacNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Haꞌ naj cawxican̈ tuꞌ, hunelxan̈e istzabico naj yin̈ iskꞌab naj Pedro yeb naj Juan yet ay ebnaj istiꞌ yatut Comam Dios, huneꞌ chiyij Yamakꞌil Salomón. Yapni bulna anma yilno naj mach chu yecꞌ yet yalan̈tocanoj. Caw xin cꞌaycan̈ iscꞌul anma yilni naj. ");
INSERT INTO jacNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yet yilni naj Pedro yapni anma tuꞌ, yalni naj xin: —Hex wet con̈ob Israel, ¿tzet yin̈ yuxinto caw chicꞌaycan̈ hecꞌul yu huneꞌ tiꞌ? ¿Tzet yin̈ yuxin caw tꞌan̈anexico jin̈an̈? ¿Ham henani ta yu cohelanilan̈ maca yu jipan̈ yuxin mabelwican̈ huneꞌ naj tiꞌ? ");
INSERT INTO jacNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Machoj, to haꞌ Comam Dios, isDiosal jichmam Abraham yeb jichmam Isaac yeb jichmam Jacob, haꞌ Comam tuꞌ yeni iskꞌakꞌal yip yin̈ Comam Jesucristo, Iscꞌahol Comam Dios. Haꞌ Comam Jesús tuꞌ, heyaco yul iskꞌab naj Pilato. Yoche naj Pilato tuꞌ isbejtzoꞌ Comam, yaj machi heje hex tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Caw Dios ye Comam Jesús, caw machi nino istxꞌojal yin̈ Comam, caw toholcanoj, yaj walex tiꞌ, maẍticꞌa heje ta chibejtzolax Comam. Wal xin haꞌ huneꞌ naj potxꞌom anma hebejtzo selelo Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yaj heyakꞌ camo Comam, Comam chu yakꞌni cokꞌinal; yaj itzitzbipaxocan̈ Comam xol anma camom yu yip Comam Dios. Yin̈ huneꞌ tiꞌ xin, caw chijakꞌ cobahan̈ testigohal. ");
INSERT INTO jacNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wal huneꞌ naj cheyil tiꞌ, caw heyohta naj, haꞌ Comam Jesús maꞌakꞌni yip yoj naj, yuxin mawatxꞌilo naj. Yuto yu ayco janmahan̈ yin̈ Comam yuxin mawatxꞌicanilo yoj naj yin̈ hesat. ");
INSERT INTO jacNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wal tinan̈ hex wet con̈ob, wohtajan ta hayet iscam Comam Jesús heyu, hewatxꞌe huneꞌ tuꞌ yu hesucal. Hacpax tuꞌ ebnaj yahaw con̈ob, mach yohtajo ebnaj tzet iswatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yajaꞌ hac tuꞌ yu yijni isba yu Comam Dios tzet yal Comam yul Yum yet payat yu sunil ebnaj ischejab Comam, tato yilal chiꞌecꞌyaꞌ yanma Comam, Comam akꞌbil ismunil yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yuxin bejwecano istxꞌojal. Aweco haba yul iskꞌab Comam, cat istan̈tzelaxcanilo hemul. Tato cheyije hacaꞌ tuꞌ, chihul huneꞌ tiempohal bay chiyakꞌ Comam Dios tzalahilal jet han̈on̈ Israel hon̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hac tuꞌ xin chati Comam Dios yakꞌlobal hecꞌul haꞌ ton Comam Jesús, huneꞌ haltebilcano jet yet payat. ");
INSERT INTO jacNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yajaꞌ yilal iscancano Comam yul satcan̈ masanto chꞌapni istiempohal bay chiswatxꞌencano Comam Dios yin̈ caw istoholal sunil tzet ay yul sat yiban̈kꞌinal tiꞌ. Hacaꞌ yu yalnicano Comam yet payat yu ebnaj ischejab Comam ecꞌlena yet payat tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yalpaxo naj Moisés tet ebnaj jichmam hacaꞌ tiꞌ: —Comam Dios Jahawil chisayni hunu ischejab texol, hacaꞌ yu quinyanicojan Comam texol. Yuxin caw yilal cheyabe sunil tzet chal naj teyet. ");
INSERT INTO jacNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wal sunil huntekꞌan anma mach ishajba istxiquin yaben tzet chal huneꞌ ischejab Comam Dios chihul tuꞌ, makꞌbil istan̈tzelaxcanilo xol anma jet con̈ob tiꞌ, ẍicano naj Moisés yul Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sunil ebnaj ischejab Comam Dios ecꞌlena yet payat tuꞌ, ichicanti yin̈ istiempohal jichmam Samuel, sunil ebnaj tuꞌ halnicano yin̈ tzet chiyu yin̈ huneꞌ tiempohal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Walex hex tiꞌ, yuninalto ebnaj jichmam ischejab Comam Dios heyehi. Yet iswatxꞌen Comam Dios istrato yeb ebnaj jichmam yet payat tuꞌ, iswatxꞌenpaxcano Comam istrato jet, han̈on̈ tiꞌ. Hac tiꞌ yu iswatxꞌencano Comam istrato yeb jichmam Abraham hacaꞌ tiꞌ: —Sunil anma yul sat yiban̈kꞌinal tiꞌ chischab iscꞌulal yu ej yuninal hawuninal, ẍicano Comam Dios tet jichmam Abraham tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yuxin hayet yitzitzbican̈ Comam Jesucristo, Iscꞌahol Comam Dios, haꞌ jet babel chejlaxtij, yu cochahnicano iscꞌulal, cat cobejnicano cotxꞌojal hununon̈, ẍi naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hayet lan̈an istzotel naj Pedro yeb naj Juan xol anma tuꞌ, yapni ebnaj sacerdote yin̈ anma Israel, yeb xin ebnaj caw yahawil yeco istan̈en yatut Comam Dios, yebpaxo ebnaj saduceo; apni huntekꞌan ebnaj tuꞌ sunil yin̈ ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Caw tit ishowal ebnaj yin̈ ebnaj yuto cuywa ebnaj yin̈ anma tato yeli chiitzitzbican̈ anma camom hacaꞌ yu yitzitzbican̈ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yuxin tzablaxayo ebnaj cawan̈ tuꞌ, yalaxicto ebnaj yul preso yu ebnaj. Yajaꞌ yu kꞌejbiyalxa yuxin toxan̈e maji ebnaj masanto yet ishajcha capil yin̈ hunxa tzꞌayic. ");
INSERT INTO jacNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yajaꞌ caw xin hantan̈e anma aben Istzotiꞌ Comam Dios, yanayto anma Istzotiꞌ Comam Jesús yul yanma. Caw xin ahcan̈ isbisil yuninal Comam Dios hanicꞌxan̈e mach howebo mil isbisil ebnaj winaj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Haxa yet huneꞌxa tzꞌayic xin, iscutxbanico isba ebnaj yahawil yin̈ anma Israel bey con̈ob Jerusalén, yeb ebnaj ichamta winaj ay ismunil xol anma tuꞌ, yebpaxo xin haꞌ hun ebnaj chicuyni anma yin̈ isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xol ebnaj tuꞌ xin ayco huneꞌ naj chiyij Anás, yahaw yeco yin̈ ebnaj sacerdote yin̈ anma Israel, aypaxicto naj Caifás, yeb naj Juan yeb huneꞌxa naj chiyij Alejandro, yeb sunil mac ay bey yatut naj yahaw yeco yin̈ ebnaj sacerdote yin̈ anma Israel tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ischejni ebnaj yilaxoti naj Pedro yeb naj Juan sata ebnaj. Hayet yapni ebnaj sata ebnaj tuꞌ, iskꞌamben ebnaj tet ebnaj cawan̈ tuꞌ hacaꞌ tiꞌ: —¿Mac akꞌni heyip heyakꞌni cawxo yoj naj tuꞌ? yebpaxo xin, ¿mac yin̈ isbi hewatxꞌe huntekꞌan tiꞌ? ẍi ebnaj tet ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wal naj Pedro tuꞌ xin, ayco naj yalan̈ ischejbanil Comam Espíritu Santo, yuxin yal naj tet ebnaj hacaꞌ tiꞌ: —Hex iswiꞌehal con̈ob, yeb hex ichamta winaj yul con̈ob Israel tiꞌ, ");
INSERT INTO jacNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","caw cheyakꞌ hekꞌambebal jetan̈ yin̈ huneꞌ iscꞌulal cowatxꞌehan̈ yin̈ huneꞌ naj maẍticꞌa chiyu isbelwi tiꞌ yuto cheyoche heyohtan̈eloj yin̈ tzet yu iscawxican̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yuxin chijalan̈ huneꞌ tiꞌ yu chijochehan̈ chiyohtan̈elo sunil ebnaj jet con̈ob Israel tato haꞌ naj aycꞌo cocꞌatan̈ tiꞌ, cachann̈e yu yip Comam Jesucristo ah Nazaret, yuxin cawxican̈ naj. Haꞌ Comam Jesús tuꞌ xin heyacan̈ yin̈ teꞌ culus, yaj itzitzbican̈ Comam xol anma camom yu Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hex tiꞌ, lahanex hacaꞌ huno naj watxꞌem n̈a, haxa Comam Jesús xin, lahan Comam hacaꞌ huno chꞌen chꞌen machi ocnico yin̈ ismunil heyu, yajaꞌ huneꞌ chꞌen tuꞌ, haꞌ chꞌen caw ay yelapno yoc xeꞌo n̈a. ");
INSERT INTO jacNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Machi hunoxa mac chiyu con̈iscolni, yuto matxa hunoxa mac yul sat yiban̈kꞌinal tiꞌ akꞌbil yip yu Comam Dios yu yakꞌni cocolbanil; caw han̈cꞌan̈e Comam Jesús chiyu con̈iscolni, ẍi naj Pedro tet ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hayet yilni ebnaj iswiꞌehal yin̈ lahtiꞌ yin̈ con̈ob Israel tuꞌ tato caw mach chixiw naj Pedro yeb naj Juan istzoteli, waxan̈ca mach iscuyu ebnaj cawan̈ tuꞌ yebpaxo caw comon anma ebnaj, yuxin caw cꞌaycan̈ iscꞌul ebnaj yin̈ ebnaj cawan̈ tuꞌ. Isnanipaxo ebnaj tato ecꞌ tzujtzun ebnaj yinta Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Waxan̈ca caw chichiwa iscꞌul ebnaj yin̈ ebnaj cawan̈ tuꞌ, yaj matzet tzꞌaj yalaꞌ ebnaj yin̈ ebnaj yuto haꞌ hun naj cawxican̈ tuꞌ lin̈anico iscꞌatan̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yuxin yal ebnaj yahawil con̈ob tuꞌ tato chꞌel naj Pedro yeb naj Juan tuꞌ xol ebnaj, iscancano ebnaj yahawil tuꞌ tzotelo ischuquil. ");
INSERT INTO jacNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Yalni ebnaj tet hunun: —¿Tzet wal juten ebnaj cawan̈ tuꞌ heyalni? Caw sunil anma yul con̈ob Jerusalén tiꞌ ohtan̈e huneꞌ cꞌaybalcꞌule iswatxꞌe ebnaj, yuxin mach chu jalni tato lekꞌtiꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tinan̈ xin, matxahojab chispujbacꞌo ebnaj huneꞌ tiꞌ xol anma, yuxin coxibteꞌwe iscꞌul ebnaj, haxinwal matxa chiyalicꞌo ebnaj iscuybanil naj Jesús tuꞌ xol anma, ẍi ebnaj yahawil tuꞌ yin̈ ebnaj cawan̈. ");
INSERT INTO jacNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lahwi tuꞌ xin, yawtelaxpaxto ebnaj cawan̈ tuꞌ hunelxa, yalni ebnaj hacaꞌ tiꞌ: —Matxa cheyalicꞌo iscuybanil naj Jesús tuꞌ tet anma, yeb matxa checuy anma yin̈ tzet yelapno ye naj, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Istakꞌwi naj Pedro yeb naj Juan tet ebnaj: —Yul sat Comam Dios, ¿cꞌulmi tato chicoyijehan̈ tzet cheyala mato coyijehan̈ tzet chiyal Comam? ");
INSERT INTO jacNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wal xin, caw mach chu cobejnicanojan̈ jalnihan̈ tzettaj jilan̈ yeb xin tzet abebil juhan̈, ẍi ebnaj tet ebnaj cutxanico tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ton̈e oc ebnaj yahawil con̈ob tuꞌ isxibteꞌ ebnaj, yajaꞌ bejtzolaxto ebnaj. Machi xin txumcha yu ebnaj tzet wal isbalnican̈ ebnaj yin̈ ebnaj cawan̈ tuꞌ yun̈e yay isyaꞌtajil yiban̈ ebnaj, yuto sunilxa anma caw cꞌul istzotel yin̈ Comam Dios yu huneꞌ iscꞌulal iswatxꞌe ebnaj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wal huneꞌ naj watxꞌilo yoj yu yip Comam Jesús tuꞌ, ecꞌbalxa cuarenta ishabilal naj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Haxa yet bejtzobilxa naj Pedro yeb naj Juan tuꞌ, isto ebnaj iscꞌatan̈ huntekꞌanxa yetbi. Yalni ebnaj sunil tzet hallax tet ebnaj yu ebnaj yahawil sacerdote yeb yu ebnaj ichamta winaj yin̈ anma Israel tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yet yaben ebnaj sunil tzet yal ebnaj cawan̈ tuꞌ, istxahli ebnaj tet Comam Dios, yalni ebnaj yin̈ istxah hacaꞌ tiꞌ: —Mamin, hach coDiosal, caw hach hawatxꞌe satcan̈ yeb sunil tzet ay bey tuꞌ, yeb txꞌo txꞌotxꞌ yeb haꞌ mar, yeb sunil tzet ay xol haꞌ, yeb sunil tzet ay yul sat yiban̈kꞌinal tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yu yip Comam Espíritu Santo hawakꞌ yalaꞌ jichmam David hachejab yet yalni naj hacaꞌ tiꞌ: ¿Tzet yin̈ yuxinto chihawejna ej con̈ob yin̈ Comam? ¿Tzet yin̈ yuxin chisnapaxo anma iswatxꞌen huntekꞌan tzet mach cꞌulu yin̈ Comam? ");
INSERT INTO jacNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wal xin iscutxba isba ebnaj iswiꞌehal xol anma yeb ebnaj yahaw con̈ob yu yanico ebnaj howal yin̈ Comam Dios Jahawil, yeb yin̈ Mac Akꞌbilxa Ismunil yu, ẍi naj David tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mamin, caw yeli naj Herodes, yeb naj Poncio Pilato, yeb anma yulajla con̈ob, yeb ebnaj Israel iscutxbaco isba ebnaj yul huneꞌ con̈ob tiꞌ yu yanico ebnaj ishowal yin̈ Hacꞌahol Jesucristo, huneꞌ Mac Akꞌbilxa Ismunil yul iskꞌab hawu. ");
INSERT INTO jacNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Caw yij isba yu ebnaj sunil tzet halbilcano hawu yet payxa, yuto el yin̈ hacꞌul ta hac tuꞌ chiyute isba. ");
INSERT INTO jacNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wal tinan̈ Mamin, caw ilcꞌanab tzet yal ebnaj jetan̈, yuxin akꞌ yip janmahan̈ haxinwal mach chon̈xiwan̈ jalnicꞌojan̈ hatzotiꞌ, yuto caw hachejab jehan̈. ");
INSERT INTO jacNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yuhojab hawip chicawxican̈ anma yaꞌay juhan̈, cat hayeni yechel hawip, yeb cꞌaybalcꞌule yu yip Comam Jesús hachejab, Comam caw toholcanoj, ẍi ebnaj yin̈ istxah tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yet lahwi istxahli ebnaj xin, istzictzoncan̈ huneꞌ n̈a bay cutxanico ebnaj tuꞌ yu yip Comam Dios. Yoccano sunil ebnaj tuꞌ yalan̈ yip Comam Espíritu Santo. Caw xin, matxa chixiw ebnaj ispujbanicꞌo Istzotiꞌ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Caw lahanxan̈e isnabal sunil anma ayxaco yul iskꞌab Comam tuꞌ, caw hunxan̈echꞌan yute isba, machi huno mac chiyalico huno tzet ye tuꞌ yeto ischuquil yuto caw hun ye sunil tzettaj ay ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wal ebnaj ischejab Comam Jesús tuꞌ, caw islahico ebnaj yalnicꞌoj tato itzitzbican̈ Comam Jesús xol camom. Caw xin, aypaxayo iscꞌulal Comam Dios yiban̈ sunil anma tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Caw machi huno mac yaꞌta chꞌecꞌ yilaꞌ xol ebnaj tuꞌ, yuto haꞌ mac ay istxꞌotxꞌ maca yatut, chistxon̈toj, cat isbey yakꞌno istohol tet ebnaj ischejab Comam Jesús, haxa ebnaj chiixkꞌanto yin̈ mac matzet aya. ");
INSERT INTO jacNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ay huneꞌ naj tiꞌ chiyij José, yajaꞌ xin Bernabé occano isbiho naj yu ebnaj ischejab Comam Jesús, yuto huneꞌ bihe Bernabé, chal yelapnoj Akꞌomico Yakꞌlobal Iscꞌul Anma. Naj Bernabé tuꞌ, yuninalto naj jichmam Leví ye naj, pitzcꞌana naj bey con̈ob Chipre. ");
INSERT INTO jacNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ay xin huneꞌ istxꞌotxꞌ naj istxon̈toj, yapni naj yakꞌno istohol yul iskꞌab ebnaj ischejab Comam Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ay huneꞌ naj chiyij Ananías, Safira isbi yixal naj, istxon̈to naj huneꞌ istxꞌotxꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yet ischahni naj istohol istxꞌotxꞌ tuꞌ, islahtiꞌn̈en isba naj yeb yixal, yinicano naj hanicꞌ istohol txꞌotxꞌ yuxin matxa tzꞌajano yakꞌ naj istohol txꞌotxꞌ tet ebnaj ischejab Comam Jesús. Haxa yute yalni naj tet ebnaj ischejab Comam tuꞌ to tzꞌajan chahcanicꞌo naj istohol txꞌotxꞌ yalni. ");
INSERT INTO jacNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yalni xin naj Pedro tet naj Ananías: —Ach wuẍta Ananías, ¿tzet yin̈ yuxin chawaco naj matzwalil yul hawanma? Chawanico lekꞌtiꞌal tet Comam Espíritu Santo yet maxawinicano hanicꞌ istohol hatxꞌotxꞌ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yet maẍto chatxon̈to txꞌotxꞌ, caw hawet txꞌotxꞌ, yeb xin yet maxatxon̈to txꞌotxꞌ, caw hawetpaxo istohol txꞌotxꞌ. ¿Tzet yin̈ yuxinto maxana hawuten huneꞌ istxꞌojal tiꞌ? Wal xin caw mach anmaho huneꞌ bay maxawaco lekꞌtiꞌal tiꞌ, haꞌ caw tet Comam Dios bay maxawaco lekꞌtiꞌal, ẍi naj Pedro tuꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lahwi yaben naj Ananías huneꞌ tiꞌ yaycꞌay naj, iscamilo naj xin. Sunil anma aben iskꞌumal huneꞌ tzet yu tuꞌ, caw xiwcan̈. ");
INSERT INTO jacNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lahwi tuꞌ xin, yapni huntekꞌan ebnaj tzehtaj, ispichnico ebnaj huneꞌ kꞌap yin̈ isnimanil naj Ananías tuꞌ, isbey ebnaj ismujnoꞌcano naj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ayxam oxebo hora iscam naj Ananías tuꞌ yapni yixal naj, yaj xin mach yohtajo ix tato xacam yichamil ix. ");
INSERT INTO jacNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Iskꞌamben naj Pedro tuꞌ tet ix: —¿Yelmi chal hawichamil tato hac tiꞌ yij istohol txꞌo txꞌotxꞌ hetxon̈toj? ẍi naj tet ix. Istakꞌwi ix: —Hoꞌ, caw hac tuꞌ istohol txꞌotxꞌ, ẍi ix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yalni naj Pedro tuꞌ tet ix: —¿Tzet yin̈ yuxinto maxelahtiꞌn̈e heba heyoc heyilweno Comam Espíritu Santo? Lan̈an yul ebnaj mabey mujnocano hawichamil, wal tinan̈ xin hachxa chito ebnaj cachismujuꞌcanoj, ẍi naj Pedro tuꞌ tet ix. ");
INSERT INTO jacNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yin̈n̈ena tuꞌ xin, yaycꞌay ix yin̈ sat naj Pedro, iscamilo ix. Haxa yet yapni ebnaj tzehta tuꞌ xin, yilni ebnaj tato camnaxapaxo ix yixal naj Ananías, yinipaxto ebnaj ix mujuj iscꞌatan̈ yichamil. ");
INSERT INTO jacNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yu huneꞌ yu tuꞌ, yuxin occano huneꞌ niman xiwquilal yin̈ sunil anma ayxaco yul iskꞌab Comam, yeb sunil anma aben huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Caw ay cꞌaybalcꞌule iswatxꞌe ebnaj ischejab Comam Jesús xol anma, caw isyecanilo ebnaj yip Comam Dios tet anma. Bey huneꞌ yamakꞌil istiꞌ yatut Comam Dios chiyij Pórtico de Salomón, haꞌ tuꞌ chiscutxba isba sunil mac ayxaco yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wal anma mach ayoco yul iskꞌab Comam xin, waxan̈ca cꞌul istzotel anma yin̈ ebnaj ayxaco yul iskꞌab Comam tuꞌ, yaj yet chiscutxban isba ebnaj chixiw anma isto xol ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wal xin, caw ay ebnaj winaj yeb ebix ix yaco yanma yin̈ Comam Dios, hac tuꞌ yu ischꞌib isbisil yuninal Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chiyinilti anma isyawub yulaj beh. Ay anma chiinilti isyawub yiban̈ txꞌat, aypaxo anma, sat pop chisbatxilti isyawub, yun̈e hayet chiecꞌto naj Pedro cat yay yen̈el naj yiban̈ anma yaꞌay tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Caw ay anma titpaxo yulajla con̈ob bey iscawilal Jerusalén tuꞌ. Ay anma ikꞌbil isyawub yu, yeb anma ayco ischejab naj matzwalil yin̈, caw xin cawxilo sunil anma yu ebnaj ischejab Comam Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yaj wal naj yahawil yehico yin̈ ebnaj sacerdote xol ebnaj Israel yeb sunil yetbi naj, ebnaj ayco yin̈ huneꞌ partido chiyij saduceo, caw chichiwa iscꞌul ebnaj yin̈ cawan̈ ischejab Comam Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yuxin oc ebnaj istzabayo ebnaj cawan̈ tuꞌ, yalaxicto ebnaj yul preso. ");
INSERT INTO jacNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Haxa yet akꞌbalil xin, yapni huneꞌ yángel Comam Dios ishajaꞌ istiꞌ teꞌ preso tuꞌ, yilaxilti ebnaj yu naj ángel, yallax tet ebnaj hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Asiꞌwe helin̈ba heba yul yatut Comam Dios cat heyalni sunil cuybanile yin̈ huneꞌ acꞌ kꞌinale tiꞌ, ẍi naj ángel tuꞌ tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yuxin haxa yet issajbilo yin̈ hunxa tzꞌayic, isyijen ebnaj cawan̈ tuꞌ tzet yal naj ángel, isto ebnaj yul yatut Comam Dios, yoc ebnaj iscuyni anma. Wal naj yahawil yeco yin̈ ebnaj sacerdote yeb yetbi tuꞌ, yawte ebnaj sunil ebnaj ichamta iswiꞌehal yin̈ lahtiꞌ xol ebnaj Israel yu islahtiꞌn̈en isba. Ischejnito ebnaj haywan̈ ebnaj chitan̈en yatut Comam Dios, ikꞌwal yin̈ ebnaj cawan̈ ischejab Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Haxa yet yapni ebnaj yul teꞌ preso xin, matxa ebnaj ischejab Comam tuꞌ ayictoj, yuxin meltzo ebnaj yalaꞌ tet ebnaj yahawil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Yalni ebnaj: —Yet macon̈apnihan̈, caw cꞌul yehico ismajil teꞌ preso tuꞌ, lin̈anpaxico ebnaj tan̈em preso tuꞌ istiꞌ teꞌ, yajaꞌ hayet macohajnihan̈ teꞌ xin, matxa ebnaj ayictoj, ẍi ebnaj tet ebnaj caw yahawil tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yet yaben naj yahawil yin̈ ebnaj sacerdote yeb ebnaj yetbi, yebpaxo naj yahaw yin̈ ebnaj chitan̈e yatut Comam Dios tuꞌ, caw cꞌayilo iscꞌul ebnaj yabeni. Caw maẍticꞌa chitxumcha yu ebnaj tzet chielcanico huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hunepixto tuꞌ xin, yapni huneꞌ naj yalno tet ebnaj hacaꞌ tiꞌ: —Ebnaj heyacto yul preso, ayicto ebnaj yul yatut Comam Dios tinan̈, caw ayco ebnaj iscuynicanto anma, ẍi huneꞌ naj tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hayet yaben ebnaj huneꞌ tuꞌ, isto naj yahaw yin̈ ebnaj chitan̈en yatut Comam Dios yeb ebnaj chimunla yinta ebnaj yinoꞌti ebnaj cawan̈ tuꞌ; yajaꞌ yin̈ akꞌancꞌulal yuto chixiw ebnaj tet anma; cꞌuxanta chikꞌojlaxcan̈ ebnaj yu anma. ");
INSERT INTO jacNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apnin̈e ebnaj ischejab Comam Jesús tuꞌ sata sunil ebnaj yahawil tuꞌ. Yalni naj yahaw sacerdote tuꞌ tet ebnaj: ");
INSERT INTO jacNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Caw xajalan̈ teyet tato matxa cheyalicꞌo iscuybanil naj Jesús tuꞌ, ¿tom caw mach cheyije tzet chijalan̈? Caw xapujnacan̈ sunil tzet chi-la-heyakꞌ iscuyuꞌ anma sunil yul con̈ob Jerusalén tiꞌ. Cheyanipaxico iscamical naj Jesús tuꞌ jiban̈an̈, ẍi ebnaj tet ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Istakꞌwican̈ naj Pedro yeb huntekꞌanxa ebnaj ischejab Comam Jesús tuꞌ, yalni ebnaj hacaꞌ tiꞌ: —Caw yilal haꞌ tzet chiyal Comam Dios, haꞌ chicoyijehan̈. Walpaxo tzet chiyal anma, ta mach chischah isba yin̈ tzet chal Comam mach chicoyijehan̈, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Walex hex tiꞌ, heyaco Comam Jesús yul iskꞌab camical, heyanican̈ yin̈ teꞌ culus. Comam isDiosal ebnaj jichmam, haꞌ Comam Dios tuꞌ xin, akꞌni itzitzbocan̈ Comam Jesús xol camom. ");
INSERT INTO jacNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Haꞌ Comam Dios akꞌni yip Comam Jesús yin̈ iswatxꞌkꞌab yul satcan̈. Hac tuꞌ xin yu yoccano Comam tuꞌ Jahawiloj yeb Cocolomalopaxoj. Hac tuꞌ yu yakꞌni Comam hamanil jet, han̈on̈ Israel hon̈ tiꞌ, yun̈e cotxumniloj tato txꞌoj jecoj, yuxin yilal comeltzoco yul iskꞌab Comam, cat istan̈tzencanilo Comam comachiswalilal jiban̈. ");
INSERT INTO jacNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wal han̈on̈tiꞌan̈, caw testigo jehicojan̈ yin̈ huntekꞌan tzet ye tuꞌ xayu tuꞌ, yebpaxo xin testigo yeco Comam Espíritu Santo, huneꞌ xayakꞌ Comam Dios jetan̈ yeb tet sunil anma chiyijen tzet chal Comam, ẍi ebnaj tet ebnaj cutxanico tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yet yaben ebnaj iswiꞌehal yin̈ lahtiꞌ yul con̈ob Israel huneꞌ tuꞌ, yah lemla ebnaj yu ishowal yin̈ ebnaj tuꞌ. Caw yoche ebnaj yakꞌa camo ebnaj ischejab Comam Jesús tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Xol sunil ebnaj tuꞌ ay huneꞌ naj fariseo chiyij Gamaliel. Caw cuywawom naj yin̈ isley naj Moisés. Caw nime anmapaxo naj yul sat anma. Yah lin̈no naj xol ebnaj, ischejnilto naj ebnaj ischejab Comam Jesús istin̈a hunep. ");
INSERT INTO jacNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hayet ayilto ebnaj istin̈a tuꞌ, yalni naj hacaꞌ tiꞌ: —Hex wet con̈ob Israel, txumwe yin̈ caw istoholal yin̈ tzet wal heyuten ebnaj tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cotxumuꞌwe yin̈ naj Teudas yet payxa, caw yalico isba naj yahawilo xol anma, aymi can̈ebo ciento anma oc tzujno yinta naj. Haxa yet ispotxꞌlax camo naj xin, ispujnacanto anma oc yinta naj tuꞌ, istan̈ilo huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lahwi tuꞌ xin, ay huneꞌxa naj chiyij Judas ah Galilea. Yaco isba naj yahawilo yet yilaxcan̈ isbisil anma, caw hantan̈e anma ocpaxo yinta naj. Haxa yet ispotxlax camo naj xin, ispujnacanto sunil anma yaco isba yinta naj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yuxin chiwalan teyet, cobejaꞌwecano huntekꞌan ebnaj tiꞌ, yilaꞌxam ebnaj. Tato yet ebnaj ischuquil huneꞌ chiswatxꞌe tiꞌ, chitan̈oloj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yaj tato yet Comam Dios xin, maẍticꞌa chiyu cotan̈tzeniloj. Conabawe tzet chicowatxꞌe cꞌuxanta yin̈ Comam Dios chijakꞌ howal, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wal ebnaj yahawil tuꞌ caw yabeꞌ ebnaj yin̈ tzet yal naj Gamaliel, yawtelaxicto ebnaj ischejab Comam Jesús tuꞌ hunelxa ishatelax ebnaj. Iscachlaxpaxo ebnaj hunelxa tato matxa chiyalicꞌo ebnaj Istzotiꞌ Comam Jesús. Lahwi tuꞌ, isbejtzolax ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Hayet yelti ebnaj ischejab Comam sata ebnaj yahawil con̈ob tuꞌ, caw chitzala iscꞌul ebnaj, yuto yu ischejab Comam Jesús ye ebnaj yuxinto caw chꞌay isyaꞌtajil yiban̈ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hunun tzꞌayic iscuyni ebnaj anma yul yatut Comam Dios yebpaxo yulaj n̈a. Chalnicꞌo ebnaj Istzotiꞌ Comam Jesucristo, tato haꞌ Comam Iscolomal anma. ");
INSERT INTO jacNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yet huneꞌ tiempohal tuꞌ xin caw yin̈ an̈e chꞌibcan̈ isbisil ebnaj juẍtaj yeb ebix janab, yaj ebnaj griego ayxaco yul iskꞌab Comam iscajlecan̈ isba ebnaj yeb huntekꞌanxa ebnaj chihalni abxubal arameo, yuto yet chiakꞌlax huntekꞌan colwal yin̈ hunun tzꞌayic yin̈ ebix hunix, mach tzꞌajano chꞌakꞌlax tet ebix hunix griego. ");
INSERT INTO jacNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yuxin cutxbalaxico sunil ebnaj ayxaco yul iskꞌab Comam yu ebnaj cablahon̈wan̈ ischejab Comam Jesús tuꞌ, yalni ebnaj tet ebnaj: —Mach cꞌuloj tato chicobejan̈ jalnicꞌojan̈ Istzotiꞌ Comam Dios, cat jocan̈ jilnihan̈ tzettaj chiocnico yu ebix janab hunix tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wal tinan̈ hex wuẍtaj, saywelo hujwan̈o ebnaj juẍta texol, caw cꞌul tzet chiswatxꞌe, yeb ay ishelanil yeb ayco yalan̈ yip Comam Espíritu Santo, cat yoccano ismunil yilni huneꞌ munil tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wal han̈on̈tiꞌan̈ caw chicolahicojan̈ cotxahlihan̈ yeb jalnicꞌojan̈ Istzotiꞌ Comam Dios, ẍi ebnaj cablahon̈wan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wal xin, caw tzalacan̈ iscꞌul sunil ebnaj ayxaco yul iskꞌab Comam yet yaben ebnaj huneꞌ tuꞌ. Hac tiꞌ xin isbi ebnaj sicꞌlaxilo tuꞌ; naj Esteban, naj juẍta tuꞌ caw ayco yanma naj yin̈ Comam Dios, yebpaxo caw ayco naj yalan̈ yip Comam Espíritu Santo. Huneꞌxa naj chiyij Felipe, yebpaxo naj Prócoro, yeb naj Nicanor yeb naj Timón, yeb naj Parmenas, yeb naj Nicolás, naj ah Antioquía, naj yaco isba yet yalan̈tocanoj yin̈ isreligión ebnaj Israel. ");
INSERT INTO jacNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yet lahwi issicꞌlaxilo ebnaj tuꞌ, yilaxto ebnaj sata ebnaj ischejab Comam Jesús, istxahli ebnaj ischejab Comam yin̈ ebnaj, yanayo ebnaj iskꞌab yiban̈ iswiꞌ ebnaj yu isyeniloj ta ischah ebnaj hujwan̈ tuꞌ ismunil yin̈ yet Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wal Istzotiꞌ Comam xin, caw pujnacan̈ xol anma. Caw ecꞌna chꞌibcanocan̈ isbisil ebnaj ayxaco yul iskꞌab Comam bey yul con̈ob Jerusalén tuꞌ. Xol anma tuꞌ caw txꞌiꞌal ebnaj sacerdote yin̈ ebnaj Israel yaco isba yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wal naj Esteban, caw ayayo iscꞌulal Comam Dios yiban̈ naj, caw aypaxico yip Comam yin̈ naj, yuxin caw hantan̈e cꞌaybalcꞌule yeb yip Comam Dios isyecanilo naj xol sunil anma. ");
INSERT INTO jacNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yaj ay hun majan ebnaj Israel chiscutxba isba yul huneꞌ capilla chihallax yetxa isba ischuquil. Xol huntekꞌan tuꞌ xin ay ebnaj ah Cirene yeb ebnaj ah con̈ob Alejandría, aypaxo ebnaj ah Cicilia, yeb ebnaj ay bey Asia. Istzabnico ebnaj tuꞌ isteyelen isba yeb naj Esteban. ");
INSERT INTO jacNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yaj machi kꞌoji ebnaj yin̈ istzotiꞌ naj Esteban tuꞌ yuto haꞌ Comam Espíritu Santo chiakꞌni ishelanil naj. ");
INSERT INTO jacNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yuxin istohla ebnaj huntekꞌan ebnaj yun̈e yalni ebnaj tato caw txꞌoj istzotel naj Esteban yin̈ naj Moisés hacaꞌ tiꞌ: —Caw jabehan̈ isbahwa naj Esteban tiꞌ yin̈ naj jichmam Moisés, yeb xin yin̈ Comam Dios, ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hac tuꞌ xin yu yakꞌni somchahoto ebnaj isnabal sunil anma, yeb ebnaj ichamta winaj akꞌbil ismunil xol ebnaj Israel, yebpaxo ebnaj chicuyni anma yin̈ isley naj Moisés. Yapni bulna ebnaj yin̈ naj Esteban, istzablaxayo naj yu ebnaj, yilaxto naj sata ebnaj yahaw con̈ob Israel. ");
INSERT INTO jacNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Lahwi tuꞌ xin, issayni ebnaj haywan̈ ebnaj nanican̈ lekꞌtiꞌal yin̈ naj Esteban, yalni ebnaj hacaꞌ tiꞌ: —Naj Esteban tiꞌ, caw mach chisbej nino naj isbahwa yin̈ yatut Comam Dios, huneꞌ caw yet Comam yehi. Yeb xin chibahwapaxo naj yin̈ isley naj Moisés. ");
INSERT INTO jacNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jabenpaxojan̈ yalni naj hacaꞌtiꞌ: —Naj Jesús ah Nazaret, chiyuchcꞌayo naj huneꞌ yatut Dios tiꞌ, cat ishelni naj cobeybal akꞌbilcano yu naj Moisés, ẍi ebnaj isnanican̈ ebnaj lekꞌtiꞌal yin̈ naj Esteban tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hayet istꞌan̈xico ebnaj iswiꞌehal yin̈ lahtiꞌ yin̈ naj Esteban tuꞌ, yilni ebnaj tato caw lahan yillax sat naj Esteban tuꞌ hacaꞌ jilni sat hunu yángel Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Naj yahawil ebnaj sacerdote Israel, oc naj iskꞌambeꞌ tet naj Esteban: —¿Yelmi sunil tzet challax tawin̈ tiꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istakꞌwi naj Esteban xin: —Hex wet con̈ob yeb hex iswiꞌehal yeco yin̈ con̈ob Israel tiꞌ, abewe tzet chiwalan. Wal Comam Dios, caw aycano yip Comam, isye isba Comam tet jichmam Abraham yet aytocꞌo icham bey ismajul Mesopotamia, yet maẍto chito icham bey con̈ob Harán. ");
INSERT INTO jacNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yalnicano Comam Dios tet icham hacaꞌ tiꞌ: —Bejcano hatxꞌotxꞌ tiꞌ yeb sunil hawicꞌal, cat hato bey huneꞌ txꞌotxꞌ chinyecanojan tawet, ẍi Comam tet icham. ");
INSERT INTO jacNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Lahwi tuꞌ xin isto icham yul ismajul txꞌotxꞌ Caldea, yapni icham yul con̈ob Harán, haꞌ tuꞌ xin ehayo icham. Haxa yet iscam ismam icham xin, yilaxti icham yu Comam Dios sat txꞌotxꞌ bay ayon̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Machi nino istxꞌotxꞌ icham akꞌlax tet yu Comam bey tiꞌ, yaj xin yal Comam tet icham hacaꞌ tiꞌ: —Chiwakꞌan huneꞌ hatxꞌotxꞌ, yajaꞌ yet chaẍcami cat iscancano txꞌotxꞌ yul iskꞌab hawuninal, ẍi Comam tet icham. ");
INSERT INTO jacNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yalnipaxo Comam Dios tet icham hacaꞌ tiꞌ: —Wal hawuninal chipohchacan̈ xin, chitocano ebnaj yul huneꞌxa nan con̈obal, chioc ebnaj ischejabo anma tuꞌ. Caw can̈eb ciento habil chiyakꞌle ebnaj isyaꞌtajil. ");
INSERT INTO jacNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yaj chiwatijan isyaꞌtajil xol anma nan con̈obal bay chꞌoc ebnaj chejaboj. Chilahwi tuꞌ xin cat winilojan ebnaj yul huneꞌ con̈ob tuꞌ, yun̈e yinayo isba ebnaj wetan sat huneꞌ txꞌo txꞌotxꞌ tiꞌ, txꞌotxꞌ chiwakꞌan tet ebnaj, ẍicano Comam Dios tet icham Abraham. ");
INSERT INTO jacNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yakꞌnipaxcano Comam Dios istrato tet icham Abraham, yalnicano Comam tet icham tato chioc yechel isnimanil icham. Huneꞌ yechel tuꞌ, haꞌ ton huneꞌ chiyij circuncisión, yuxin hayet ispitzcꞌa huneꞌ iscꞌahol icham Abraham chiyij Isaac, waxajebxa tzꞌayic ispitzcꞌahi, yoccano yechel isnimanil. Hacpax tuꞌ xin yet ispitzcꞌa iscꞌahol naj Isaac chiyij Jacob, ocpaxo yechel tuꞌ yin̈ naj. Wal naj Jacob tuꞌ xin, cablahan̈wan̈ iscꞌahol naj yocpaxo huneꞌ yechel isnimanil ebnaj. Wal ebnaj cablahon̈wan̈ tuꞌ xin, caw ichmame yeco ebnaj jin̈, han̈on̈ Israel hon̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ebnaj cablahon̈wan̈ tiꞌ xin, ay huneꞌ yuẍtaj ebnaj chiyij José; caw yaco ebnaj ishowal yin̈ naj José tuꞌ. Yapni huneꞌ tzꞌayical xin, yet istxon̈nito ebnaj huneꞌ yuẍta tuꞌ bey Egipto. Yaj xin caw ayco Comam Dios yetbiho naj José. ");
INSERT INTO jacNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Comam Dios coln̈elo naj xol sunil isyaꞌtajil ecꞌle yiban̈, caw yakꞌ Comam ishelanil tet naj, yebpaxo xin caw ayco Comam yetbiho naj, yuxin caw cꞌul isbeybal naj sata naj rey Faraón. Yu iscꞌulal naj tuꞌ yuxinto oc naj gobernadoral yin̈ txꞌotxꞌ Egipto yu naj Faraón, Yocpaxo naj yahawil yin̈ sunil tzet ay naj Faraón tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lahwi tuꞌ xin yapni huneꞌ tiempohal yet yay huneꞌ wahil yiban̈ ebnaj ah Egipto yeb ebnaj ah Canaán. Caw xin oc yin̈ iscꞌul ebnaj yin̈ huneꞌ wahil tuꞌ, matxaticꞌa bay chiyikꞌ ebnaj tzet chislo. ");
INSERT INTO jacNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yet yaben naj Jacob tato ay ixim trigo bey Egipto, ischejnito naj ebnaj iscꞌahol ikꞌo trigo; haꞌ ton ebnaj tuꞌ xin, jichmam. Hac tuꞌ yu isbeycꞌo ebnaj islokꞌoꞌ ixim babelal. ");
INSERT INTO jacNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Haxa yet ischejlaxtoj ebnaj yet iscayel xin, isyenilo isba naj José tet ebnaj tato caw yuẍta isba ebnaj. Hac tuꞌ yu yohtan̈enilo naj Faraón mac anmahil naj José yu ebnaj yuẍta naj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ischejniti naj José tuꞌ yilaxoti ismam, haꞌ ton icham Jacob yeb sunil yuẍta naj José tuꞌ, yebpaxo yixal ebnaj, yeb sunil yuninal ebnaj. Yin̈ sunil mac tuꞌ caw setenta y cinco isbisil. ");
INSERT INTO jacNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hac tuꞌ yu yapnicano icham Jacob bey Egipto. Haꞌ bey tuꞌ xin camto ebnaj jichmam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hayet payxa tuꞌ xin, ilaxto isnimanil ebnaj jichmam tuꞌ bey yul con̈ob Siquem. Haꞌ tuꞌ occanto isnimanil ebnaj yul huneꞌ chꞌen chꞌen holbil lokꞌbilcano yu icham Abraham yet yalan̈tocanoj tet yuninal naj Hamor ay bey txꞌotxꞌ Siquem. ");
INSERT INTO jacNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yet toxa chꞌapni istiempohal yijni isba tzet yal Comam Dios tet icham Abraham, ispohcan̈ yuninal icham bey Egipto tuꞌ. Hac tuꞌ yu ischꞌibcan̈ isbisil ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yet huneꞌ tiempohal tuꞌ xin, oc huneꞌxa naj reyal yin̈ txꞌotxꞌ Egipto tuꞌ, yaj matxa ohtabilo naj José tuꞌ yu naj, yuto caw payxa camto naj José. ");
INSERT INTO jacNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Caw xin etalax ebnaj jichmam yu huneꞌ naj rey tuꞌ. Yalni naj tet sunil ebnaj israelita tuꞌ tato sunil niẍte iscꞌahol chipitzcꞌahi chisbejcano ebnaj yun̈e iscamiloj, haxinwal matxa chipohcha ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yulbal huneꞌ tiempohal tuꞌ xin, pitzcꞌa naj Moisés. Caw cꞌulchꞌancano huneꞌ naj nichꞌan tuꞌ yul sat Comam Dios. Yulbal oxeb ixahaw akꞌlax chꞌibo naj yu ismiꞌ yeb yu ismam. ");
INSERT INTO jacNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lahwi tuꞌ xin, yebalaxilo naj yu ismam yeb yu ismiꞌ tuꞌ tet huneꞌ ley ayco yu naj rey tuꞌ. Haxa ix iscutzꞌin naj rey tuꞌ bey ilchanoti naj nichꞌan tuꞌ, yanico ix naj yuninoj, yakꞌlax chꞌibo naj yu ix. ");
INSERT INTO jacNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yuxin caw cuylax naj Moisés yin̈ sunil tzet yohta ebnaj ah Egipto tuꞌ. Yuxinto caw helan elcanico naj yin̈ sunil tzet chala yeb yin̈ tzet chiswatxꞌe. ");
INSERT INTO jacNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Yet ayxaco naj Moisés yin̈ cuarenta habil, yoc yin̈ iscꞌul naj isto yilno ebnaj yet con̈ob Israel ay bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Haxa yet yilni naj ta lan̈an yetalax huneꞌ naj jet con̈ob yu huneꞌ naj ah Egipto, yoc naj iscolnilo naj jet con̈ob tuꞌ, ismakꞌnicano camo naj huneꞌ naj ah Egipto tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Haꞌ yute isnani naj Moisés tuꞌ to txumchalo yu ebnaj jet con̈ob tuꞌ tato haꞌ Comam Dios an̈eco naj yun̈e iscolnilo naj ebnaj yul iskꞌab isyaꞌtajil, yaj maẍticꞌa txumchapaxilo yu ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Haxa yet huneꞌxa tzꞌayical xin, yilni naj Moisés yakꞌlen howal cawan̈xa ebnaj jet con̈ob, yu yoche naj yakꞌaco ebnaj yin̈ akꞌancꞌulal yuxin yal naj hacaꞌ tiꞌ tet ebnaj: —¿Tzet yin̈ yuxin cheyakꞌle howal? Caw heyet con̈ob heba, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Istenlaxilo naj Moisés yu huneꞌ naj lan̈an yakꞌlen howal yeb hunxa naj tuꞌ, yalni naj tet naj Moisés: —¿Mac macachanico jahawilojan̈ yuxin chaẍhul cachwal jin̈an̈? ");
INSERT INTO jacNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tom chawoche chinhamakꞌ camojan hacaꞌ hawute naj ah Egipto yet ewi hawalni? ẍi naj tet naj Moisés tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yet yaben naj Moisés yalni naj hacaꞌ tiꞌ, yelcan̈ naj. Isto naj xol ebnaj nan con̈obal bey huneꞌ txꞌotxꞌ chiyij Madián. Haꞌ bey tuꞌ xin, pitzcꞌa cawan̈ iscꞌahol naj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta habilxa yapni naj bey txꞌotxꞌ Madián, isyenican̈ isba huneꞌ naj ángel tet naj xol xaj kꞌa kꞌaꞌ yin̈ huneꞌ teꞌ txꞌix bey txꞌotxꞌ desierto yich witz Sinaí. ");
INSERT INTO jacNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yet yilnito naj huneꞌ tuꞌ, caw cꞌaycan̈ iscꞌul naj yu. Haxa yet ishitzico naj iscawilal teꞌ, yaben naj istzotel Comam Dios Jahawil hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","—Haninan isDiosal sunil ebnaj hawichmam, isDiosal naj Abraham, yeb naj Isaac, yebpaxo naj Jacob, ẍi Comam tet naj. Caw xin cꞌayilo iscꞌul naj Moisés tuꞌ yu xiwquilal, yuxin matxa tꞌan̈xico naj yin̈ huneꞌ kꞌaꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yalni Comam Dios tet naj: —Ilo haxan̈ab yin̈ hawoj, yuto huneꞌ bay ayayo hawoj tiꞌ caw txahul, yuto haꞌ bey tiꞌ lan̈an intzotelan tawet. ");
INSERT INTO jacNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ebnaj incon̈oban ay bey Egipto, chiwilan tato caw ayco ebnaj yin̈ isyaꞌtajil, yuxin manayilojan walaꞌan tawet tato chincolilojan ebnaj xol isyaꞌtajil tuꞌ. Wal xin asiꞌ, haninan chaẍinchejtojan bey Egipto, ẍi Comam Dios tet naj Moisés tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Waxan̈ca isyah ebnaj naj Moisés yet yalni ebnaj tet naj hacaꞌ tiꞌ: —¿Mac macachanico jahawilojan̈? ẍi ebnaj. Yaj xin Comam Dios anico naj yahawilo ebnaj Israel tuꞌ, yeb xin yu iscolwa naj Moisés tuꞌ yin̈ ebnaj yu yip naj ángel isyecan̈ isba tet naj xol kꞌaꞌ kꞌaꞌ yin̈ teꞌ txꞌix tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Haꞌ naj Moisés inilti jichmam sat txꞌotxꞌ Egipto, yakꞌnipaxo cꞌaybalcꞌule yilaꞌ ebnaj bey Egipto, yeb bey haꞌ mar Rojo, yebpaxo sat txꞌotxꞌ desierto yin̈ cuarenta habil. ");
INSERT INTO jacNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yal naj Moisés tuꞌ tet ebnaj jet con̈ob Israel hacaꞌ tiꞌ: —Chissiqꞌuilo Comam Dios huneꞌ ischejab xol ebnaj jet con̈ob tiꞌ, hacaꞌ yu quinissicꞌnilojan Comam tiꞌ. Caw xin chehajba hetxiquin yin̈ tzet chal naj, ẍicano naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yet yecꞌle naj Moisés tuꞌ xol ebnaj jet con̈ob Israel tuꞌ bey txꞌotxꞌ desierto, ay huneꞌ naj ángel isye isba tet naj, bey iswiꞌ witz Sinaí. Haꞌ tet naj Moisés tuꞌ yakꞌ naj ángel cuybanile yet cokꞌinal mach istan̈bal yu Comam Dios, haxa naj Moisés an̈ecano jet han̈on̈ tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yaj machi yoche iscꞌul ebnaj jichmam tuꞌ isyije tzet yal naj Moisés, yuxin yilo ebnaj naj yul yanma, yu huneꞌ tuꞌ xin yoche paxoꞌto isba ebnaj hunelxa bey txꞌotxꞌ Egipto. ");
INSERT INTO jacNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yalni ebnaj tet naj Aarón: —Watxꞌe ej cotioẍalan̈ cat yoc cosatajan̈, yuto haꞌ naj Moisés con̈iniltijan̈ sat txꞌotxꞌ Egipto, mach johtajojan̈ tzet yucanto naj, ẍi ebnaj tet naj Aarón tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yoc ebnaj iswatxꞌeno yechel huneꞌ yunin wacax; haꞌ huneꞌ yechel yunin wacax tuꞌ yalico ebnaj isDiosaloj. Ispotxꞌni camo ebnaj huntekꞌan no nokꞌ yanico ebnaj xahanbalil tet chꞌen wacax tuꞌ, yecꞌtzen ebnaj huneꞌ kꞌin̈ tet istioẍ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yu huneꞌ tuꞌ, yuxinto yilo isba Comam Dios xol ebnaj. Isbejlaxcano ebnaj ischuquil yu Comam yun̈e yinayo isba ebnaj tet ej txꞌumel. Hacaꞌ yu istzꞌibn̈encano huneꞌ naj ischejab Comam Dios bay chala: Hex ah Israel, cuarenta habil hepotxꞌ no nokꞌ yin̈ xahanbalil bey txꞌotxꞌ desierto, yajaꞌ ¿tom wetan heyakꞌ noꞌ xahanbalil? ¡Machoj! ");
INSERT INTO jacNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Walxinto haꞌ tet huneꞌ hetioẍ cheyijicꞌoj, huneꞌ chiyij Moloc, yeb huneꞌ yechel txꞌumel yeb hediosal chiyij Renfán. Tet huntekꞌan yechel hewatxꞌe tuꞌ, haꞌ tet caw heyiyo heba; yu huneꞌ tuꞌ yuxinto chexwilojan sat huneꞌ txꞌo txꞌotxꞌ tiꞌ, cat quexwanitojan yintato txꞌotxꞌ Babilonia, ẍicano Comam Dios yul Hum tzꞌibn̈ebilcano tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yaj yet yecꞌ ebnaj jichmam sat txꞌotxꞌ desierto tuꞌ, yetbicꞌo ebnaj huneꞌ kꞌap mantiado, watxꞌebilayo n̈ahil, chiyeniloj ta ayco Comam Dios yetbiho ebnaj. Watxꞌebil huneꞌ mantiado tuꞌ yu naj Moisés hacaꞌticꞌa yu isyeni Comam yechel tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Haꞌ huneꞌ mantiado tuꞌ, akꞌlaxcano yul iskꞌab huntekꞌanxa ebnaj jichmam, ikꞌbil xin huneꞌ mantiado tuꞌ yu ebnaj yet iskꞌoji ebnaj yin̈ huntekꞌan con̈ob yu naj Josué. Haꞌ anma ay yul huntekꞌan con̈ob tuꞌ, istzumbelo Comam Dios yun̈e yanicano ebnaj huntekꞌan con̈ob tuꞌ tet ebnaj jichmam; huneꞌ mantiado tuꞌ ikꞌbilto yu ebnaj masanto oc naj David reyal. ");
INSERT INTO jacNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Naj rey David tuꞌ xin, tzalacano Comam Dios yin̈ naj. Iskꞌanni naj tet Comam Dios ta chiswatxꞌe naj huneꞌ yatut Comam bay chiyiyo isba anma titna yin̈ jichmam Jacob. ");
INSERT INTO jacNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yaj xin haxa naj Salomón watxꞌen huneꞌ yatut Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Comam Dios, Comam caw aycano yip, machi ehayo yul huno n̈a chiwatxꞌelax yu anma. Hac tuꞌ yute yalni Comam tet huneꞌ ischejab yet payxa yet yalnicano Comam hacaꞌ tiꞌ: ");
INSERT INTO jacNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yul satcan̈, haꞌ tuꞌ ay incapilan yeb intzꞌon̈obalan, haxa yul sat yiban̈kꞌinal tiꞌ, isbatxobal wojan yehi yuto ayco yalan̈ wipan. Yuxin ¿tzet n̈ahil cheyacan̈ wetan heyalni? ¿Aymi hunu bay cꞌul inxewan? Machoj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Tom maẍtajinan watxꞌen̈e sunil tzettaj ye tuꞌ xin? ẍicano Comam Dios, tet naj Isaías. ");
INSERT INTO jacNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yalnipaxo naj Esteban tet ebnaj tuꞌ: —Walex hex tiꞌ, caw hip yecanilo heyanma hacaꞌ yanma anma mach ohtan̈eho Comam Dios. Caw ay hetxiquin yaj mach cheyabe tzet chal Comam. Ton̈eticꞌa cheman̈cꞌo tzet chal Comam Espíritu Santo, yuxin caw lahanex yeb heyichmam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ebnaj ischejab Comam Dios yet payxa, caw etalax ebnaj yu ebnaj heyichmam tuꞌ, ispotxꞌlaxpaxo ebnaj yu ebnaj. Haꞌ ebnaj ischejab Comam halnicano tato chihul huneꞌ naj caw toholcano yanma, haxa yet yul huneꞌ naj tuꞌ xin, hesaynican̈ lekꞌtiꞌal yin̈ naj yu heyakꞌnipaxo camoj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Waxan̈ca yakꞌcano naj ángel huneꞌ ischejbanil Comam Dios teyet, yaj caw mach heyije tzet chala, ẍi naj Esteban tuꞌ tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yet yaben ebnaj sunil tzet yalcano naj Esteban tuꞌ, caw chin̈etxꞌla yeh ebnaj yu ishowal. ");
INSERT INTO jacNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yaj naj Esteban tuꞌ, caw occano naj yalan̈ yip Comam Espíritu Santo, yah tꞌan̈no naj satcan̈, yilni naj iskꞌakꞌal yip Comam Dios, yilni naj tato lin̈anico Comam Jesús yin̈ iswatxꞌkꞌab Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yalni naj hacaꞌ tiꞌ: —Ilwecꞌanabi lah, hajan yul satcan̈. Caw chiwilan yin̈ Comam Jesucristo, Comam Akꞌbilti coxol yu Comam Dios, lin̈anico Comam yin̈ iswatxꞌkꞌab Comam Dios, ẍi naj Esteban tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hayet yaben ebnaj huneꞌ tuꞌ yah wejna ebnaj yel yaw yin̈ caw ip, ismajchen ebnaj istxiquin, isto bulna ebnaj yin̈ naj Esteban tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Yinito ebnaj naj istxam con̈ob, wal ebnaj balnican̈ tzotiꞌ yin̈ naj Esteban yet yalan̈tocanoj, haꞌ ebnaj kꞌojnico chꞌen chꞌen yin̈ naj. Yet maẍto chiskꞌoj camo ebnaj naj Esteban tuꞌ, yacano ebnaj huntekꞌan xilkꞌape chishucbaco yiban̈ xil iskꞌap istan̈eꞌ huneꞌ naj tzeh chiyij Saulo. ");
INSERT INTO jacNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hayet lan̈an iskꞌojni camo ebnaj naj Esteban tuꞌ, istxahli naj tet Comam Dios hacaꞌ tiꞌ: —Mam Jesús, chachabaꞌ wanmatiꞌan, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yaypaxo jahno naj, istxahlipaxo naj yin̈ caw ip hacaꞌ tiꞌ: —Mamin, mach chawaco huneꞌ tiꞌ ismulo ebnaj, ẍi naj. Yet lahwi yalnicano naj huneꞌ tiꞌ, iscamilo naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Caw tzalacano iscꞌul naj Saulo yin̈ iscamical naj Esteban. Yin̈ huneꞌ tzꞌayic tuꞌ xin ichico huneꞌ niman isyaꞌtajil yin̈ macta ayxaco yul iskꞌab Comam bey yul con̈ob Jerusalén, hac tuꞌ xin yu ispujnato ebnaj. Ay ebnaj tocano yulaj ismajul txꞌotxꞌ Judea, aypaxo ebnaj tocano yulaj ismajul txꞌotxꞌ Samaria, cachanxan̈e ebnaj ischejab Comam Jesús cancano bey yul con̈ob Jerusalén tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ay xin huntekꞌan ebnaj ayco yanma yin̈ Comam caw cꞌul iscꞌul, haꞌ ebnaj tuꞌ inito isnimanil naj Esteban mujuj. Caw chꞌokꞌcanico ebnaj yin̈ isnimanil naj Esteban tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wal naj Saulo, caw islahcanico naj istan̈tzenilo ebnaj ayxaco yul iskꞌab Comam. Caw beh yoc naj yulaj n̈a, cat istarnilti naj ebnaj winaj yeb ebix ix yul yatut, cat yilaxto preso yu naj Saulo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","5","Haꞌ ebnaj ayxaco yul iskꞌab Comam xiwilo bey yul con̈ob Jerusalén tuꞌ, nanantaxan̈e bay tocanico ebnaj. Haꞌ bay chi-la-ecꞌ ebnaj tuꞌ xin chiyalicꞌo ebnaj Tzotiꞌ cꞌul yet colbanile. Xol ebnaj tuꞌ, ay huneꞌ naj Felipe isbi. Haꞌ naj tuꞌ apni yul huneꞌ niman con̈ob ay yul ismajul Samaria. Istzabnico naj yalnicꞌo Istzotiꞌ Comam Cristo xol anma bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Caw yabe anma sunil tzettaj chal naj Felipe tuꞌ. Yilnipaxo anma huntekꞌan cꞌaybalcꞌule isye naj xol anma. ");
INSERT INTO jacNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Caw hantan̈e anma ayco ischejab naj matzwalil yin̈ cawxicaniloj. Hayet chielcano ebnaj yin̈ anma tuꞌ caw chiel yaw. Caw ay anma camnajilo isnimanil, yeb anma mach chu isbelwi, caw watxꞌican̈ yu naj Felipe tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yu tzet iswatxꞌe naj Felipe, caw tzalacan̈ iscꞌul sunil anma yul huneꞌ niman con̈ob tuꞌ yul ismajul Samaria. ");
INSERT INTO jacNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ay huneꞌ naj yul con̈ob tuꞌ chiyij Simón, nawal naj; payxa ichiti yakꞌni subchaho naj anma, caw ay yelapno ye naj yalni. ");
INSERT INTO jacNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Caw xin chiyaco yanma anma yin̈ naj, cat yabelax tzet chal naj. Sunil anma machi yelapno yehi yeb anma caw ay yelapno yehi, chalni yin̈ naj hacaꞌ tiꞌ: —Haꞌ naj Simón tiꞌ, haꞌ naj huneꞌ niman yip Comam Dios, ẍi anma yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Caw chahcanico anma yanma yin̈ naj Simón tuꞌ, caw xin payxa ichico naj yetan anma, chalni anma tato caw tzꞌajan iscꞌul naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yalni naj Felipe Istzotiꞌ Comam Jesucristo xol anma. Haxa yet yalni naj yin̈ tzet chu yoc anma yul iskꞌab Comam Dios caw txꞌiꞌal ebnaj winaj yeb ebix ix yayto yul yanma yin̈ tzet chal naj. Lahwi tuꞌ xin, yahcano haꞌ iswiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yaj xin yapaxayto naj Simón tuꞌ yul yanma yin̈ tzet yal naj Felipe tuꞌ, yahcano haꞌ iswiꞌ naj. Lahwi yahcano haꞌ iswiꞌ naj, yoc tzujno naj yinta naj Felipe. Ay xin huntekꞌan nimeta cꞌaybalcꞌule isye naj Felipe, caw cꞌaycan̈ iscꞌul naj Simón tuꞌ yet yilni naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yet yaben ebnaj ischejab Comam Jesús bey Jerusalén tato ay anma bey yul con̈ob Samaria chahni Istzotiꞌ Comam Dios yul yanma, ischejnito ebnaj naj Pedro yeb naj Juan istucleno ebnaj ayxaco yul iskꞌab Comam bey yul ismajul Samaria tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yet yapni ebnaj cawan̈ tuꞌ, yoc ebnaj txahlo yeb anma ayxaco yul iskꞌab Comam yun̈e ischahnicano Comam Espíritu Santo yul yanma, ");
INSERT INTO jacNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yuto maẍto huno ebnaj chichahni Comam Espíritu Santo, cachann̈e yin̈ isbi Comam Jesucristo ahcano haꞌ iswiꞌ ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yanayo naj Pedro yeb naj Juan tuꞌ iskꞌab yiban̈ iswiꞌ ebnaj yet istxahli ebnaj. Hac tuꞌ yu ischahnicano ebnaj Comam Espíritu Santo yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Yet yilni naj Simón tato yet chiyanayo ebnaj iskꞌab yiban̈ iswiꞌ ebnaj ayxaco yul iskꞌab Comam tuꞌ, cat ischahnicano ebnaj Comam Espíritu Santo, yalten naj Simón melyu tet ebnaj ischejab Comam tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Yalni naj hacaꞌ tiꞌ: —Akꞌwecano huneꞌ heyip tiꞌ wetan haxinwal macxan̈eticꞌa hunu mac chiwahto inkꞌaban yin̈ iswiꞌ, cat ischahnicano Comam Espíritu Santo, ẍi naj tet ebnaj cawan̈ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yalni naj Pedro: —Hunn̈ehojab chu hatan̈ilo yeb hamelyu tiꞌ yuto chatxumu tato hunu tzet chiyakꞌ Comam Dios jet chiyu colokꞌni. ");
INSERT INTO jacNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Caw mach chu hawoc yin̈ huneꞌ tzet chijutiꞌan̈, yuto haꞌ ismachiswalil chiꞌecꞌ yul hawanma yul sat Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wal tinan̈ na haba, bejcano huneꞌ hamachiswalilal tiꞌ. Kꞌan nimancꞌulal tawin̈ tet Comam Dios, yuto aytotaxca nimancꞌulal yu Comam tawin̈ yin̈ tzet chꞌecꞌ yul hawanma tiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yuto chiwilan tato caw chichiwaco hacꞌul hawilni yin̈ tzet chicowatxꞌetiꞌan̈, haꞌ ton xin huneꞌ istxꞌojal tiꞌ cꞌaln̈e hachayoj, ẍi naj Pedro tuꞌ tet naj Simón. ");
INSERT INTO jacNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Istakꞌwi naj Simón tuꞌ: —Caw chinkꞌanan teyet, kꞌanwe nimancꞌulal win̈an tet Comam Dios, haxinwal machi huno isyaꞌtajil chihul wiban̈an yu Comam, ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lahwi yalnicꞌo naj Pedro yeb naj Juan yin̈ej tzettaj ye tuꞌ ilbilcano yu ebnaj yin̈ tzet iswatxꞌe Comam Jesucristo, yeb cuybanil yin̈ Comam, ispaxto ebnaj Jerusalén; caw hantan̈e yaldeahil Samaria bay ecꞌ ebnaj yalaꞌcꞌo Istzotiꞌ Comam Jesús. ");
INSERT INTO jacNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ay huneꞌ yángel Comam Dios halni tet naj Felipe hacaꞌ tiꞌ: —Asiꞌ bey sur, cat hato yul beh chitit bey Jerusalén, huneꞌ chiapni yul con̈ob Gaza, ẍi naj ángel tet naj. Huneꞌ beh tuꞌ xin chiecꞌ sat txꞌotxꞌ desierto. ");
INSERT INTO jacNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yoc naj Felipe yin̈ isbel isto naj. Istzujcha huneꞌ naj ah Etiopía yul beh yu naj. Haꞌ huneꞌ naj tuꞌ eunuco naj, yahawil yeco naj yu huneꞌ ix reina chiyij Candace, yin̈ iscꞌuban ismelyu ix. Ispeto naj yul con̈ob Jerusalén yu yinayo isba tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ayahto naj yul iscaret, lan̈an xin yilni naj cuybanile tzꞌibn̈ebilcano yu naj Isaías, huneꞌ naj ischejab Comam Dios yet payat. ");
INSERT INTO jacNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yalni Comam Espíritu Santo tet naj Felipe hacaꞌ tiꞌ: —Hitzan̈ico iscꞌatan̈ huneꞌ teꞌ caret tuꞌ, ẍi tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Isto naj yin̈ an̈e. Yet yapni naj iscꞌatan̈ teꞌ caret tuꞌ yaben naj tato lan̈an yilni naj huntekꞌan cuybanile tzꞌibn̈ebilcano yu naj Isaías. Yalni naj Felipe tuꞌ tet naj: —¿Chimtxumchalo hawu tzet lan̈an hawilni tiꞌ? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yalni naj ah Etiopía tuꞌ xin: —¿Tzet chu intxumnilojan tato machi hunu mac chihalni wetan tzet chaliloj? Ahan̈ti yul caret incꞌatan̈tiꞌan, cat xin hawalni wetan tzet chaliloj, ẍi naj eunuco tet naj Felipe. ");
INSERT INTO jacNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hac tiꞌ chute yalni teꞌ Hum bay lan̈an yilni naj: Hacaꞌ hunu noꞌ meꞌ chiilaxto camoj, hac tuꞌ chiyu yilaxotoj. Hacaꞌ chu hunu noꞌ nichꞌan meꞌ matzet chala yet chiilaxilo xil, hac tuꞌ chiyuteꞌ isba, machi huno tzotiꞌ chiahti yul istiꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Caw txꞌixobal chꞌutelaxi, machi hunu mac chiwatxꞌen istoholal yin̈. Machi hunu mac chu yalni hanta istxꞌojal anma yet aycꞌo naj yul sat yiban̈kꞌinal tiꞌ, ẍi Yum Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lahwi tuꞌ xin iskꞌambenilo naj ah Etiopía tet naj Felipe: —Hal wetan, ¿mac yin̈ chitzotel huneꞌ naj ischejab Comam Dios tiꞌ? ¿Tom yin̈ naj Isaías tiꞌ chitzoteli, mato nan mac bay chitzotel tiꞌ? ẍi naj tet naj Felipe. ");
INSERT INTO jacNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yichico naj Felipe yalnilo mac yin̈ chitzotel huneꞌ Hum tuꞌ. Yalni naj ta yin̈ Tzotiꞌ cꞌul yet Comam Jesucristo chitzoteli. ");
INSERT INTO jacNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hayet ayco ebnaj yin̈ isbel tuꞌ xin, yapni ebnaj bey huneꞌ ha haꞌ, yuxin yal naj ah Etiopía tuꞌ tet naj Felipe hacaꞌ tiꞌ: —Ay huneꞌ haꞌ bey tiꞌ lah, ¿cꞌulmi yahcano haꞌ inwiꞌan tinan̈? ẍi naj tet naj Felipe tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Yalni naj Felipe tuꞌ: —Chuhi tato caw yeli chawayto yul hawanma, ẍi naj. Istakꞌwican̈ naj: —Caw chiwayto yul wanmahan tato caw yeli Iscꞌahol Comam Dios ye Comam Jesucristo tuꞌ, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lahwi tuꞌ xin, ischejni naj ah Etiopía islin̈balax iscaret. Yayto ebnaj iscawan̈il xol haꞌ, yah haꞌ iswiꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yet lahwi yahcanti ebnaj xol haꞌ tuꞌ, yin̈ hamataj yilaxto naj Felipe yu Comam Espíritu Santo, maẍticꞌa yil naj ah Etiopía tuꞌ baytuꞌwal caw istoco naj Felipe. Toxan̈e caw chitzala naj yet yoc naj yin̈ isbel hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hayet yilniti naj Felipe tuꞌ, haxa yul huneꞌ con̈ob chiyij Azoto ay naj. Istzabnico naj ispujbanicꞌo Tzotiꞌ cꞌul yet colbanile yulajla con̈ob masan apni naj yul con̈ob Cesarea. ");
INSERT INTO jacNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yet huneꞌ tiempohal tuꞌ, maẍticꞌa isbej naj Saulo issayni ebnaj ayxaco yul iskꞌab Comam Jesús, chal naj ispotxꞌoꞌ camo ebnaj. Isto naj islahtiꞌn̈eno isba yeb ebnaj yahawil yin̈ ebnaj sacerdote ah Israel. ");
INSERT INTO jacNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Iskꞌanni naj huneꞌ carta yun̈e yoc naj yulaj iscapilla ebnaj Israel bey con̈ob Damasco yun̈e istzabniti naj sunil ebnaj ayxaco yin̈ huneꞌ acꞌ cuybanile. Sunil ebnaj winaj yeb ebix ix xayaco yanma yin̈ Comam Jesús, beh yinito naj yul preso bey yul con̈ob Jerusalén yalni. ");
INSERT INTO jacNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hac tuꞌ yu isto naj bey Damasco tuꞌ. Yet ayco naj yin̈ isbel tuꞌ xin, yet lan̈anxa yapni naj yayilo jopla huneꞌ issajilkꞌinal yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Caw yin̈ an̈e xin aycꞌay naj sat txꞌotxꞌ, yaben naj huneꞌ yul nukꞌe halni hacaꞌ tiꞌ: —Saulo, Saulo, ¿tzet yin̈ yuxin chinhatzumbecꞌojan? ẍi. ");
INSERT INTO jacNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Iskꞌamben naj: —Mamin, ¿mac anmahil hach? ẍi naj Saulo tuꞌ. Istakꞌwi huneꞌ yul nukꞌe tuꞌ tet naj: —Hanintiꞌan Jesús inan, caw ayachico quinhatzumbenicꞌojan, yaj ton̈e chawakꞌ lahwo haba hacaꞌ chu islahwi hunu noꞌ wacax chixan̈wa yin̈ hunu te teꞌ kꞌakꞌiꞌ iswiꞌ, ẍi huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Caw xin chiluylun naj Saulo tuꞌ yu xiwquilal, yalni naj xin: —Mamin, ¿tzet chawoche chinwatxꞌehan? ẍi naj. Yalni Comam tet naj: —Ahan̈wanoj cat hato yul con̈ob tuꞌ, haꞌ tuꞌ chihallaxo tawet tzet wal hawuni, ẍi Comam Jesús tuꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wal ebnaj yetbi naj Saulo tuꞌ, caw sucbicanilo iscꞌul ebnaj yuto caw yabe ebnaj istzotel huneꞌ yul nukꞌe tuꞌ, yaj mach hunu mac yilico ebnaj yin̈. ");
INSERT INTO jacNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Lahwi tuꞌ xin, yahwano naj Saulo tuꞌ. Yet ishajni sat naj matxa yu yilni naj, yuxin haxa ebnaj yetbi naj tuꞌ oc xecnoto naj yul con̈ob Damasco. ");
INSERT INTO jacNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yet yapni naj bey tuꞌ, oxeb tzꞌayic mach chu yilni naj, mach waꞌ naj, matzet yucꞌpaxo naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yul con̈ob Damasco tuꞌ xin, ay huneꞌ naj ayxaco yul iskꞌab Comam, chiyij Ananías. Yalni Comam Dios yul iswayic naj yin̈ sajsatil hacaꞌ tiꞌ: —Ananías, ẍi Comam. —¿Tzet chawal Mamin? ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yalni Comam: —Ahan̈wanoj cat hato yul huneꞌ beh, Tohol isbi. Hayet chaẍapno bey yatut naj Judas, cat hakꞌamben naj Saulo ah con̈ob Tarso, lan̈an istxahli naj bey tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ay huneꞌ tzet manyehan yilaꞌ naj tato chaẍapno iscꞌatan̈ naj, cat hawanayo hakꞌab yiban̈ iswiꞌ naj. Hacn̈e tuꞌ chiyu ishajchaho sat naj, ẍi Comam tet naj Ananías. ");
INSERT INTO jacNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yalni naj Ananías hac tiꞌ: —Mamin, yaj txꞌiꞌal tzet xawabehan yin̈ naj Saulo tuꞌ. Caw hanta anma ayco yul hakꞌab bey Jerusalén, caw chꞌecꞌyaꞌ yanma yu naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tinan̈ xin, xahul naj bey tiꞌ, xaakꞌlax hum yul iskꞌab naj yu naj yahawil ebnaj sacerdote yin̈ ebnaj Israel. Chul naj istzabaꞌto anma ayxaco yul hakꞌab, ẍi naj tet Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yalnipaxo Comam tet naj: —Asiꞌ iscꞌatan̈ naj Saulo tuꞌ yuto sicꞌbilxalo naj wuhan. Haꞌ naj chihalnocꞌo intzotiꞌan xol anma mach Israeloj, yeb tet ebnaj yahawil ebnaj, yeb tet ebnaj Israel hawet con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yeb chinyehan yilaꞌ naj hanta isyaꞌtajil chakꞌle naj yu yalni Intzotiꞌan, ẍi Comam tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hac tuꞌ yu isto naj Ananías bey huneꞌ n̈a tuꞌ. Yet yapni naj yocto naj yul n̈a, yanayo iskꞌab naj yiban̈ iswiꞌ naj Saulo, yalni naj hacaꞌ tiꞌ: —Wal tinan̈ wuẍta Saulo, Comam Jesucristo isyecan̈ isba yul habeh bay macachtita, haꞌ maquinchejnitijan tacꞌatan̈ yun̈e ishajlo hasat tiꞌ hunelxa, cat xin hachahnicano Comam Espíritu Santo yin̈ hawanma, ẍi naj tet naj Saulo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hunepixto xin yaycꞌay huntekꞌan hacaꞌ ismelyaẍil istzꞌumal noꞌ cay ayco yen̈elo sat naj Saulo tuꞌ, hac tuꞌ yu yilnipaxocan̈ naj hunelxa. Lahwi tuꞌ xin, yahcano haꞌ iswiꞌ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iswaꞌpaxocan̈ naj, yikꞌni yip naj hunelxa. Txꞌiꞌalto tzꞌayic cancano naj iscꞌatan̈ ebnaj ayxaco yul iskꞌab Comam bey yul con̈ob Damasco tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lahwi tuꞌ xin, yecꞌ naj Saulo yalnocꞌo yulajla iscapilla ebnaj Israel, chalni naj tato caw yeli Iscꞌahol Comam Dios ye Comam Jesucristo. ");
INSERT INTO jacNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Haꞌ anma aben tzet chal naj, caw cꞌaycanocan̈ iscꞌul yabeni. Yalni hacaꞌ tiꞌ: —¿Tom maẍtaj naj tiꞌ chitan̈tzenilo anma chichahni Comam Jesucristo yul yanma, bey yul con̈ob Jerusalén? ¿Tom maẍtaj naj tiꞌ chihul cꞌalnoto ebnaj ayxaco yul iskꞌab Comam, cat yinito naj tet ebnaj yahawil sacerdote? ẍi anma tuꞌ yin̈ naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Caw ahcanocan̈ naj Saulo tuꞌ yalni Istzotiꞌ Comam yun̈e yohtan̈enilo anma tato caw yeli haꞌ Comam Jesús haꞌ ton Cristo echmabil yuli. Yuxin ebnaj Israel ay yul con̈ob Damasco tuꞌ, mach chitxumcha yu ebnaj yin̈ tzet chiyu ispajtzen ebnaj tet naj Saulo. ");
INSERT INTO jacNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lahwi yecꞌto hayeb tzꞌayic xin iscutxban isba ebnaj yahawil ebnaj Israel, islahtiꞌn̈en isba ebnaj tato chipotxꞌlax camo naj Saulo tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Caw hunun tzꞌayic yeb hunun akꞌbal ismajni ebnaj naj Saulo yul ispultahil chꞌen cꞌub hoyanico yin̈ con̈ob tuꞌ yun̈e ispotxꞌlax camo naj, yaj xin yabelo naj Saulo huneꞌ tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yuxin haꞌ ebnaj ayxaco yul iskꞌab Comam inilti naj yet akꞌbalil, alaxayto naj yul huneꞌ niman motx, lahwi tuꞌ xin yalaxilto naj yul isventanahil huneꞌ niman cꞌub tuꞌ. Hac tuꞌ xin yu iscolcha naj Saulo. ");
INSERT INTO jacNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Haxa yet yapni naj Saulo yul con̈ob Jerusalén, yoche naj ishunba isba yeb ebnaj ayxaco yul iskꞌab Comam yul con̈ob tuꞌ, yaj caw xiwcan̈ ebnaj tet naj. Yuto maẍticꞌa yayto ebnaj yul yanma tato yeli ayxaco naj Saulo tuꞌ yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Haxa naj Bernabé, inito naj Saulo iscꞌatan̈ ebnaj ischejab Comam Jesús, yalni naj tet ebnaj: —Caw yeli naj Saulo tiꞌ yil naj Comam Jesús yul beh, istzotel Comam tet naj. Yuxin caw machi xiw naj yalnicꞌo Istzotiꞌ Comam Jesús yul con̈ob Damasco, ẍi naj Bernabé tuꞌ tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hac tuꞌ yu iscancano naj Saulo yeb ebnaj ayxaco yul iskꞌab Comam ay bey yul con̈ob Jerusalén. Chi-xin-ecꞌ naj yinta ebnaj, chalnicꞌo naj Istzotiꞌ Comam Jesús yin̈ sunil yanma yul con̈ob. ");
INSERT INTO jacNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Caw cuywacanto naj yin̈ ebnaj Israel chihalni tzotiꞌ chiyij griego, cat xin isteyelen isba naj yeb ebnaj. Yaj caw ay yalaꞌ ebnaj tiꞌ tzet chu iscam naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yet yaben ebnaj ayxaco yul iskꞌab Comam huneꞌ tuꞌ, yinito ebnaj naj Saulo bey yul huneꞌ con̈ob chiyij Cesarea. Tzujan tuꞌ xin, ischejlaxcanto naj yu ebnaj bey yul con̈ob Tarso. ");
INSERT INTO jacNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yin̈ huneꞌ tiempohal tuꞌ xin akꞌancꞌulalxan̈e ye macta ayxaco yul iskꞌab Comam Jesús ay yul ismajul Judea yeb xin bey Galilea yebpaxo bey Samaria. Caw yikꞌcanocan̈ yip ebnaj yu colwa Comam Espíritu Santo yin̈ ebnaj, yeb xin caw ay yelapno ye Comam yul sat ebnaj. Caw ahcanocan̈ ischꞌib isbisil macta chaco isba yul iskꞌab Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yet huneꞌ tiempohal tuꞌ ecꞌ naj Pedro yul huntekꞌan con̈ob, hac tuꞌ yu istuclen naj ebnaj ayxaco yul iskꞌab Comam bey yul huneꞌ con̈ob chiyij Lida. ");
INSERT INTO jacNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yul huneꞌ con̈ob tuꞌ xin apni naj Pedro iscꞌatan̈ huneꞌ naj chiyij Eneas. Caw waxajebxa habil isto naj Eneas tuꞌ sat txꞌat yuto caw yan̈yon̈e isnimanil naj yu huneꞌ yabil. ");
INSERT INTO jacNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yalni naj Pedro tuꞌ tet naj: —Eneas, Comam Jesucristo chaẍakꞌni cawxoj, yuxin ahan̈wano tinan̈, ican̈ hawaybal tiꞌ, ẍi naj Pedro tuꞌ tet naj. Hac tuꞌ xin yu yahwano naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sunil anma ay yul con̈ob Lida, yeb sunil anma ay yul huneꞌxa con̈ob chiyij Sarón ilni huneꞌ tuꞌ yet iscawxican̈ naj, hac tuꞌ yu yanicanico isba anma yul iskꞌab Comam Jesucristo. ");
INSERT INTO jacNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yul con̈ob Jope, haꞌ tuꞌ ay huneꞌ ix ayxaco yul iskꞌab Comam chiyij Tabita, haꞌ yin̈ abxubal griego, Dorcas isbi ix. Txꞌiꞌal tzettaj ye tuꞌ cꞌul iswatxꞌe ix, caw xin colwa ix yin̈ anma mebaꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yaj ay huneꞌ yabil caw how oc yin̈ ix, iscam ix. Yet camomxa ix tuꞌ, yaẍn̈elaxcano ix, yilaxahto ix yul huneꞌ cuarto yin̈ iscab piso. ");
INSERT INTO jacNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Huneꞌ con̈ob chiyij Jope tuꞌ, iscawilal Lida aycoj. Yet yaben ebnaj ayxaco yul iskꞌab Comam tato haꞌ bey Lida ay naj Pedro ischejnito ebnaj cawan̈ ebnaj yalno tet naj: —Ton̈ jintajan̈ bey yul con̈ob Jope tinan̈ yaj yin̈ an̈e, ẍi ebnaj tet naj Pedro tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Isto naj Pedro yinta ebnaj. Yet yapni naj xin, yilaxahto naj yul huneꞌ cuarto tuꞌ bay ay isnimanil ix Dorcas. Ay huntekꞌan ebix hunix aycꞌo iscꞌatan̈ ix camom tuꞌ, caw chꞌokꞌcanico ebix yin̈ ix. Ay xil iskꞌap ebix sabil yu ix Dorcas tuꞌ, chi-la-isye ebix tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Lahwi tuꞌ xin, ischejlaxayti sunil anma yul huneꞌ cuarto yu naj Pedro. Yay jahno naj istxahli naj tet Comam Dios. Lahwi istxahli naj tuꞌ xin, yalni naj tet ix Dorcas hacaꞌ tiꞌ: —Tabita, ahan̈wanoj, ẍi naj tet ix. Yet lahwi yalni naj tuꞌ xin, ishajni sat ix, hayet yilni ix naj Pedro tuꞌ, yah tzꞌon̈no ix. ");
INSERT INTO jacNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yoc tzabno naj yin̈ iskꞌab ix, yah lin̈no ix. Yawtenahto naj Pedro sunil ebnaj ayxaco yul iskꞌab Comam ay bey tuꞌ yebpaxo ebix hunix. Isyeni naj tet sunil anma ta hulcan̈ iscꞌul ix Dorcas tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Caw sunil anma ay bey Jope tuꞌ aben iskꞌumal huneꞌ tuꞌ, yuxin txꞌiꞌal anma chahni Comam Jesucristo yul yanma. ");
INSERT INTO jacNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wal naj Pedro cantocano naj hayebxa tzꞌayical yul con̈ob Jope tuꞌ bey yatut huneꞌ naj watxꞌemilo tzꞌum, Simón isbi. ");
INSERT INTO jacNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yin̈ huneꞌ tiempohal tuꞌ, ay huneꞌ naj chiyij Cornelio bey yul con̈ob Cesarea. Caw yahawil yeco naj yin̈ huneꞌ majan ebnaj soldado chiyij Italiano. ");
INSERT INTO jacNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Huneꞌ naj tuꞌ mach Israelo naj, yaj ayco yanma naj yin̈ Comam Dios yeb sunil mac ay bey yatut, caw chiyo isba tet Comam Dios. Caw niman tzettaj ye tuꞌ chissah naj tet anma mebaꞌ Israel. Chi-ticꞌa-txahli naj tet Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yet huneꞌ tzꞌayical yin̈ chꞌen oxeb yin̈ kꞌejbiyalil yilni naj yoc apno huneꞌ naj yángel Comam Dios iscꞌatan̈ hacaꞌtan̈e yul wayique. Yalni naj ángel tuꞌ: —¡Cornelio! ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hayet yoc tꞌan̈no naj yin̈ naj ángel, isxiwcan̈ naj, istakꞌwi naj: —¿Tzet chawal Mamin? ẍi naj. Yalni naj ángel tuꞌ xin: —Caw chabe Comam Dios hatxah, caw chilpaxo Comam hacolwal chawakꞌ tet anma mebaꞌ. Mach chicꞌayto huntekꞌan tiꞌ yu Comam. ");
INSERT INTO jacNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wal tinan̈ chejto haywan̈o ebnaj bey yul con̈ob Jope, ikꞌwal yin̈ naj Simón, naj chiyij Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ay naj bey yatut huneꞌxa naj chiyij Simón, naj watxꞌemilo tzꞌum, ay bey istiꞌ haꞌ mar. Haꞌ naj Pedro tuꞌ chihulo halno tawet tzet wal hawuten haba, ẍi naj ángel tet naj Cornelio tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yet istocano naj ángel tuꞌ xin, yawtenti naj cawan̈ iscꞌamteꞌ yeb huneꞌ naj issoldado chicolwa yin̈. Huneꞌ naj tiꞌ aypaxo yanma naj yin̈ Comam Dios. ");
INSERT INTO jacNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sunil tzet hallax tet naj yu naj ángel, yal naj tet ebnaj. Ischejlaxto ebnaj bey yul con̈ob Jope tuꞌ xin. ");
INSERT INTO jacNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yet huneꞌxa tzꞌayic yin̈mi chuman, yet lan̈anxa yapni ebnaj iscawilal con̈ob Jope tuꞌ, yahto naj Pedro txahlo yiban̈ yacꞌalil iswiꞌ teꞌ n̈a bay aya. ");
INSERT INTO jacNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yet ayahto naj txahlo bey tuꞌ, isn̈ohchacan̈ naj. Lan̈an xin iswatxꞌelax tzet chislo naj, yin̈n̈ena tuꞌ xin, isyelax yin̈ sajsatil tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ishajni isba satcan̈, yilni naj huneꞌ niman sábana leyanayti yin̈ sat naj, ximbilayo can̈eb istxiquin kꞌap. ");
INSERT INTO jacNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yul huneꞌ sábana tuꞌ, ayayto sunil no nokꞌ; noꞌ can̈eb yoj, noꞌ chishatxicꞌo iscꞌul, yeb noꞌ chꞌic. ");
INSERT INTO jacNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yet yayilo huneꞌ sábana tuꞌ, yaben naj Pedro yul huneꞌ nukꞌe, halni tet hacaꞌ tiꞌ: —Pedro, ahan̈wanoj, potxꞌcamo huntekꞌan no nokꞌ tiꞌ cat hacꞌuxni noꞌ, ẍi huneꞌ yul nukꞌe tuꞌ. ");
INSERT INTO jacNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yalni naj hacaꞌ tiꞌ: —Mamin, machoj, yuto caw maẍto hunelo chincꞌuxan huno noꞌ comon nokꞌ tiꞌ, maca hunuxa tzet ye tuꞌ mach sajoj hacaꞌ yalni isley naj Moisés, ẍi naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yuxin yal huneꞌ yul nukꞌe tuꞌ hunelxa tet naj: —Sunil tzet sajxa ye yu Dios, mach chawal tzꞌilal, ẍi. ");
INSERT INTO jacNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Caw xin oxel yu hacaꞌ tuꞌ. Lahwi tuꞌ yilaxto huneꞌ sábana tuꞌ yul satcan̈ hunelxa. ");
INSERT INTO jacNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Haxa yet yapni ebnaj ischejab naj Cornelio yul con̈ob Jope, iskꞌambelo ebnaj tet anma baytuꞌwal ay yatut naj Simón. Caw aytoco naj Pedro istxumni yin̈ tzet chal yelapno huneꞌ yil tuꞌ, yet yapni ebnaj istiꞌ ispultahil teꞌ n̈a bay ay naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yet ayxa ebnaj bey tuꞌ, iskꞌamben ebnaj: —¿Ham tiꞌ aycꞌo naj Simón, naj chiyij Pedro? ẍi ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Caw aytoco yin̈ iscꞌul naj tzet caw chalilo huneꞌ yil naj tuꞌ, yalni Comam Espíritu Santo tet naj hacaꞌ tiꞌ: —Pedro, ay oxwan̈ ebnaj chaẍsaynicꞌoj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ahan̈wanoj, ayan̈toj cat hato yinta ebnaj tinan̈ yuto haninan chejn̈eti ebnaj tacꞌatan̈ tiꞌ, ẍi Comam Espíritu Santo tuꞌ tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yayti naj xin, yapni naj iscꞌatan̈ ebnaj ischejab naj Cornelio tuꞌ, yalni naj: —Haninan chinhesayicꞌojan. ¿Tzet hechejbanil wetan? ẍi naj tet ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yalni ebnaj hacaꞌ tiꞌ xin: —Ay huneꞌ naj chiyij Cornelio, yahawil yeco yin̈ huntekꞌan ebnaj soldado, haꞌ naj macon̈chejnitijan̈. Caw toholcano isbeybal naj, caw chiyo isba naj tet Comam Dios, yeb xin caw cꞌulcano naj yul sat anma Israel. Yaj xin ay huneꞌ yángel Comam Dios apni halno tet naj tato yilal hato yatut naj yu yabencano naj tzet chawala, ẍi ebnaj chejab tuꞌ tet naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yilaxicto ebnaj yul n̈a yu naj Pedro tuꞌ, haꞌ tuꞌ way ebnaj. Haxa yet sahab sacꞌayalil yin̈ huneꞌxa tzꞌayic isto naj Pedro yinta ebnaj; aypaxo haywan̈ ebnaj juẍtaj ah Jope tuꞌ to yinta ebnaj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Haxa yet huneꞌxa tzꞌayic xin, yapni ebnaj yul con̈ob Cesarea. Caw echmabil yapni ebnaj yu naj Cornelio tuꞌ, cutxanxaco yicꞌal naj yu, yeb mac ay yul yatut naj tuꞌ, yeb yamigo naj awtebil yu. ");
INSERT INTO jacNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Yet yapni naj Pedro bey tuꞌ, yelti naj Cornelio ischahno naj, yay jahno naj sata naj Pedro. ");
INSERT INTO jacNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yaj ilaxcan̈ naj yu naj Pedro, yalni naj xin: —Ahan̈wanoj yuto caw lahan anma hon̈, ẍi naj tet naj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Caw xin tzotelo chu naj Pedro yeb naj yet yocto ebnaj yul n̈a. Hac tuꞌ xin yu yilni naj Pedro ta caw hantan̈e anma cutxanicoj. ");
INSERT INTO jacNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yalni naj tet anma hacaꞌ tiꞌ: —Caw heyohtaj tato han̈on̈ Israel on̈tiꞌan̈ cachbilon̈an̈ yu isley naj Moisés cohunban cobahan̈ yeb hunuxa anma 