﻿USE sofia;
DROP TABLE IF EXISTS sofia.jaa_vpl;
CREATE TABLE jaa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jaa_vpl WRITE;
INSERT INTO jaa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yama yana kani ya Teoso yama nafi hiri nematamonaka, neme hiri wami hiri, nari. ");
INSERT INTO jaa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Wami honaremetemoneke, e winahaba watari karo. Wami bari kanehemetemoneke faha ehebote ya kowiharo kasiro ya. Yama soki faha ehebote bari kanehemetemoneke. Teoso kanamori yoyobi tohematamonaka faha neme ya. ");
INSERT INTO jaa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Teoso ati yana nematamonaka. \"Yama wehe tasi tonahi\", ati nematamonaka. Yama wehe tasi tonehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yama wehe amosamone ati nematamonaka. Faya ebe hikanemetemoneke. Ha ya yama wehe toha, ha ya yama soki toha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Teoso yama inibone nawatematamonaka. Yama wehe inimetemone amake, yama wehe. Yama soki inimetemone amake, yama soki. Yama soki naba manakobisa yama warisemetemoneke fahi. Yama wehe taitimetemone amake haro. ");
INSERT INTO jaa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Teoso ati yana tasehimatamonaka. \"Haha faha ebe kanahi famahabana\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Fare Teoso ati nima yama nemetemoneke. Faha ebe kanehimatamonaka famahabonehe: one bofe ya toha one neme ya toha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Haha yama ebe kani ini Teoso nawatematamonaka, neme. Yama soki naba manakobisa yama warisemetemoneke fahi. Yama wehe taiti nowati ka yama wehemetemoneke haro. ");
INSERT INTO jaa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Teoso ati yana tasehimatamonaka. \"Bofe ka faha nafi yoro tokowamahi wami tasi tobeya\", ati nematamonaka. Wami tasi tonehemetemoneke waha fare ati ya. ");
INSERT INTO jaa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Inibone Teoso hinawatemetemoneke, wami. Manakobisa haha faha yoro hikaniwama inimetemone amake, faha ehebote. Teoso yama hiri hina amosamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Faya ati yana tasehimatamonaka. \"Wami ya yama yanahaboneke, yama nafi, yama noki na, awa boni na naro\", ati nematamonaka. Fare Teoso ati nima yama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Wami ya yama yanehemetemoneke, yama nafi, yama noki na awa boni na naro. Teoso yama hiri hina amosamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Yama soki naba manakobisa yama warisemetemoneke tasa. Yama wehe famaha nowati ka yama wehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Teoso ati yana tasehimatamonaka. \"Neme ka yama oyeba nahabanake, yama wehe kaba toha, yama soki kaba toha naro. Faha fowe na, yama hiwe na, nabanake, afa yama oye famaha ihi. ");
INSERT INTO jaa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Haha yama oye neme ya oyaha wami firi kanahabanake\", ati nematamonaka. Fare ati nima yama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Teoso yama oye famaha hiri nematamonaka fotaharo, haha nafiha yama wa toni ka toha, one yama soki ka toha nabana. Amowa mera hiri, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Teoso yama oye nawanematamonaka neme ya, wami firi kanahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Haha yama oye yama wa toni ka toha yama soki ka toha nabone hinehemetemoneke. Teoso yama hiri hina amosamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Yama soki naba manakobisa yama warisemetemoneke tasa. Yama wehe terei na nowati ka yama wehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Manakobisa Teoso ati yana tasehimatamonaka. \"Faha abe nahaboneke tamaharo, yoro tokanaro. Neme ka bani me na naboneke, me afe wataha mati, me toki watoha mati neme ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Makoni Teoso faha abe fotaha hiri, faha abe yoro tokana hiri, nematamonaka, tamaharo. Bani mera hiri, nematamonaka me afe wataha mati. Teoso yama hiri hina amosamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yama amosa nahabone Teoso ati nematamonaka faha ehebote aberawa ya. Ati e nematamonaka ahi: \"Te totamabone teke, faha ehebote ka me te. Bani mati, te totama, nabone teke, te efe wataha te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Yama soki naba yama warisemetemoneke tasa. Yama wehe kowato na nowati ka yama wehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Teoso ati yana tasehimatamonaka. \"Haha wami ya bani me tamaha me yanahaboneke tabora ka me toha, yama kabani ka me toha, hine me horo na me toha, na mati, me yoro tokana mati\", ati nematamonaka. Fare ati nima yama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Teoso bani mera hiri nematamonaka me yoro tokana mati tabora ka bani me toha, yama kabani ka me toha, hine me horo na me toha, na mati wami ya. Teoso yama hiri hina amosamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ati yana tasehimatamonaka. \"Hima e meba e hiri naba eke, fara e nima me na mati, e awi nima me awi na mati. Me ka hiti me tohahaboneke, aba mati, bani me afe naha mati, tabora ka bani mati, yama kabani ka bani mati, hine me horo na me toha na mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Makoni Teoso e hiri nematamonaka. Fare Teoso awi nima me awi nemetemoneke Teoso ehene. Makiti hiri fanawi hiri nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yama amosa nahabone ati nematamonaka me ni ya, ati e nari ahi: \"Te kahiwahi, mata ya. Te winakanikima nabone teke. Wami nafi ka hiti te tohahabone teke owati ihi. Aba me ka hiti me te toha, bani me afe wataha me ka hiti me te toha, hine me horo na me ka hiti me te toha, nabone teke. ");
INSERT INTO jaa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Yama te kabahaba ta onahabana oke. Yama noki naha toha awa boni naha toha na ta onahabana oke, te kabahabana. ");
INSERT INTO jaa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Yama kabani ka bani me ta yama afe me kababisahaboneke, bani me afe wataha me toha, hine me horo na me toha, na me ya me tabaha mati\", ati nematamonaka. Fare Teoso ati nima yama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Faya Teoso yama hiri hina amosi mati tohahamone ati nematamonaka, yama nafi. Yama soki naba manakobisa yama warisatasemetemoneke. Yama wehe siko na nowati ka yama wehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Faya neme wami ya famaha hiri ni ahabemetemoneke. Neme ka yama toha, wami ka yama toha nemetemoneke, nafi. ");
INSERT INTO jaa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Yama wehe sei na ahabi ya Teoso ka yama hiri ni ahabemetemoneke yama nafi. Manakobisa afa yama wehe nowati ka yama wehe ya Teoso hasi nematamonaka, hinaka yama ahi ni ahabi karo. ");
INSERT INTO jaa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Afa yama wehe amosamone Teoso ati nematamonaka, hinaka yama wehe tohi karo. Afa yama wehe ya hasi nematamonaka, yama nafi hiri ni ahabe karo. ");
INSERT INTO jaa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yama hiri ni e nemetemoneke ahi Teoso hiri hinaharo, neme hiri, wami hiri nari. ");
INSERT INTO jaa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Neme ya wami famaha Teoso hiri ne ya masiri watarihi, yama koro na watarihi nemetemoneke mata, Teoso faha yosere karo mata, e winahaba watarihi ni karo yama koro na kakatomahabana. ");
INSERT INTO jaa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Faha tasi tomatemetemoneke wami ya, wami soro nabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Manakobote makititeba Teoso hiri nematamonaka, wami hobokori ya. Teoso witi fo hinise hasi ni yana tonematamonaka. Faya yati nematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Manakobisa Teoso awa boti amosa koro nematamonaka Etehi ka yama ya, bahi kakamaki ya. Faya makiti nawinematamonaka fahi, hiri ni hawa hinihari. ");
INSERT INTO jaa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Teoso ehene awa yoro tokana yanehemetemoneke fahi, amosaro, boni kabaharo. Afa awa baikani ya awa one wehemetemoneke, ihi e sawi fara tohatibone karo, boni e kabi ya. Awa one wa nemetemoneke, boni e kabi ya yama amosa e wato, yama hiyara e wato, ti karo. ");
INSERT INTO jaa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Etehi ka yama ya faha yanehemetemoneke, afa awa boti soro naro. Manakobisa Etehi ka awa boti ya faha kariwaha hine ebe nemetemoneke, kowato kanahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Faha kowato kana one ini amake Biso tohaharo, moto kawaharo Hafira ka yama ya, oro nati ka yama. ");
INSERT INTO jaa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Hafira ka oro amosate amake kasiro ya, oro hinama tohaharo. Hafira ka awa atahone na, te amake mahi amosaro. Yati amosa na, te amake fahi. ");
INSERT INTO jaa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Faha kowato kana one ini amake Sio tohaharo, moto kawaharo Kosi ka yama ya. Sio momoto kawate amake Kosi ka wami ya. ");
INSERT INTO jaa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Faha kowato kana one ini amake Tikiri, towakaro, Asiria beheri ya, bahi kakamaki nokosi ya. Faha kowato kana one ini amake Eofarati. ");
INSERT INTO jaa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Teoso makiti nawinematamonaka Etehi ka awa boti ya, awa kakatoma, yama koro, nebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Manakobote Teoso maki warabo kaminematamonaka. Teoso ati e nematamonaka ahi, he narabo nima nari: \"Awa nafi boni kabahaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Awa oharia ta boni tikabarabone tike, yama amosa e wato, yama hiyara e wato, tibone ka awa, boni e kabi ya. Afa awa boni tikabi ya tihababone tike. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Manakobisa Teoso ati yana tasehimatamonaka. \"Yama amosakere, makiti ohari ka yama. Owaba hiri onehibanaka he narifebana, tesene yokanabana\". ");
INSERT INTO jaa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wami ya Teoso bani me nafi hiri nematamonaka, yama kabani ka bani me toha, bani me afe wataha me toha, na mati. Faya bani mera towakamematamonaka maki ni ya me inibone hinawatahabone mati me ini hinawati ya fara me ini ya me ini toharawabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Me ini hinawatemetemoneke. Bani me afe wataha me ini nawata bani tabora ka me ini nawata bani yama kabani ka me ini nawata nematamonaka. Atao nanarifaba ta watarematamonaka tesene yokanabonaha. ");
INSERT INTO jaa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Manakobisa Teoso maki amo nimatamonaka. Nokobisa koro hikanematamonaka. Amo nematamonaka kasiro ya. Faya amo ne ya Teoso tahari hitibasehimatamonaka. Manakobote tahari hihiya ni hinamosamematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Hahi tahari Teoso hinihawahe fanawi tohehemetemoneke. Manakobisa hekamehemetemoneke maki ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Faya maki ati yana nematamonaka. \"Hima waha. Haha ime oko ime amake. Haha tone oko tone amake. Iniba amake haro, Teoso hitibasi karo makiti ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Makoni makiti bati kakosa mati kakosa nebonaka fati ya fami oharibonaha. E oharia nima me naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Maki fati ya famehi ni ya yama kokoma naba wataremetemoneke me kori tohaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Teoso ehene maka hiri ni ya bani me hiri ni kataba maka ka yama wato fiya tonehemetemoneke bani me ka yama wato ya. Fanawi aate nemetemoneke. \"Keye amarini? Teoso tera yosehino awa, awa boni te kabarabone te Etehi ka awa boni?\" ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Fana ati wara hinehemetemoneke. \"Awa boni ota kabahabone ati nareka awa boni nafi. ");
INSERT INTO jaa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Awa baikani ya awa oharia waha afa awa boni ota kabarabone Teoso ota warabo kamine otake. Ota boyorihi naboneke. Ota ehene e ni ya ota ahababone otake\". ");
INSERT INTO jaa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Faya maka ati e nemetemoneke ahi: \"Te ahabarahabone teke. Keye amake. ");
INSERT INTO jaa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Teoso ati e ne ati boti e neno awaka ahi: 'Afa awa boni me kabi ya me noki fata tokanaboneke. Fara owa nima me naboneke, yama amosa me wato yama hiyara me wato na mati', ati boti ati neno awaka. Makoni ati amaka\", maka ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Fanawi awa awehemetemoneke awa awi amosaro. \"Awa boni kabi amosa awineke. Yama owato ya yama amosaboneke owa ni ya\", ati nemete awineke. Faya awa boni itibasa awa boni kabehemetemoneke. Maki hekawe awa boni kaba nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Afa yama ya me fami noki fata tokanemetemoneke. Hine me awehemetemoneke me kori tohaha mati. Faya fiko afe me tasi kanehemetemoneke, me hikabonehe hine me bari kibone karo. ");
INSERT INTO jaa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Afa yama wehe ka bahi toke ya boni hafofo nake maki fati ya famehi Teoso ati me mitehemetemoneke yaka nari awa boti ya. Faya me kawahiyehemetemoneke awa boti ya. ");
INSERT INTO jaa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Manakobisa Teoso maki ha nematamonaka aate hinehibonaha. \"Hibaka tihari?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Maki ati wara hinehimatamonaka. \"Tiwati omita oke, yaka tina tiwa awa boti ya. Owato oke oko korone tohi karo. Makoni owahiyahara oke\". ");
INSERT INTO jaa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Faya Teoso aate hinehimatamonaka. \"Hibake atino amara tika korone tohahamone ati nari? Awa boni tikabinihi aya te kabarabone onaharo?\" ");
INSERT INTO jaa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Maki ati e nematamonaka ahi: \"Aya fana ta tinaharo otesenebone tinaharo afa owa kakawarake awa boni ya. Okobarake\". ");
INSERT INTO jaa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Faya Teoso fana aate nematamonaka. \"Himataba tiwehene e rini ahi?\" ati nematamonaka. \"Maka owa keyehara oke. Makoni awa boni okobara oke\", fana ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Manakobisa Teoso ati yana nematamonaka maka ni ya. \"Tiwehene hiyara hiri tinahani yama hiyara nahaba amake tiwa ni ya, e naro ahi: yaka tinahaba ama tike bofe ya tiwa horo tina tiwa, wami hobokori tikaba tiwa. Tiwahariha yama e na hiri tinahabone tike. Bani me one hiri hirahaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Fana ya te famaha te abe nofateraba te amake. Tika noti fana ka noti me na me abe nofarihi tehaba me amake. Hinaka noti titati tai nisatehiba amaka. Hinaka noti teme yotofi wai titehiba amaka\". ");
INSERT INTO jaa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Teoso ati e nematamonaka ahi fana ni ya: \"Owati ihi yama nawaha hiri tinabone tike tinabati weye ni ya. Tikatao me ihiba ya tinabati kome kitahaba ama tike. Yama nawaha hiri tikene tika yibote ya fami tinofasa tinahabone tike. Tika yibote tiwa yosebisehiba amaka\". ");
INSERT INTO jaa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Atao ni ya Teoso ati e nematamonaka ahi: \"Tika yibote ati ya tiwehene tohaha awa boni tikabani tike aya te kabarabone onaharo. Tiwehene e na ihi wami hiyaraba amake owati ihi. Yama koro tinahabone tike titefebonehe. Tika yama ahi ni nafihaba ama tike fara yama tohaha ya, yama koro tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Fatara ka yama tikababone tike. Yama nawaha naboneke tiwa ni ya, fatara mohi mono tini ya. ");
INSERT INTO jaa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Yama nawaha hiri tinahabone tike, yama ahi ni tinafiha tiwa, yama koro tina tiwa, titefebonehe. Faya wete tinamaba ama tike wami ya wami hiri ni tiha tiwa. Makoni wami tihamatasahaba ama tike\", Teoso ati nematamaonaka. ");
INSERT INTO jaa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Maki fati ini nawatematamonaka. Efa tohehemetemoneke e nafi ka ami tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Teoso makari hiri nematamonaka bani ataro tohaharo, Atao fati ya famehi me boribonehe. ");
INSERT INTO jaa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Manakobisa Teoso ati yana tasehimatamonaka. \"Hibayata ya Atao e nima me nawahake, yama amosa me wato, yama hiyara me wato ni karo. Era hihiri nama ka awa boni me kabariyahi. Me ihi e na me winariyahi fara yama tohateha ya. ");
INSERT INTO jaa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Makoni Teoso Atao mera toyosemehimatamonaka, me winamarabone mati Etehi ya. Wami me wi nabone me hinehemetemoneke, yama me koro nabone mati, fara wami hiri ni me toha mati, Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Teoso mera toyoseme Etehi witi ya kerobini mera nanahomatamonaka, bahi kakamaki ya. Yimawa ehebote nawa nematamonaka, yama hiri ni tohaharo, oye kari naro, me tokiyomaribone karo awa era hihiri nama wai ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Atao Efa ahi nematamonaka fara fati. Nabati weye nemetemoneke. Biti watehimatamonaka fahi. Ati e nemetemoneke ahi: \"Teoso owa narifaka, makoni okatao naka makiti biti\". Ino hinawatematamonaka, inomatamona amaka Kai. ");
INSERT INTO jaa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Manakobisa biti owa nehimatamonaka. Inomatamona amaka Abeo, Kai nisori. Abeo ofeya me nanarifa toha, Kai yama kokoro toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Manakobisa yama toyabo ka yama wehe one ya Kai fatara ka yama ta nematamonaka Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeo yama ta nematamonaka bisa. Hinaka ofeya biti taiti nabowe kote amose ta nematamonaka Teoso ni ya. Abeo ehene amosemona Teoso hinehimatamonaka, yama ta hinaha nofahari. ");
INSERT INTO jaa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kai ta nofarematamonaka, yama ta hina nofarari. Kai hamamisehimatamonaka kasiro ya. Noko yawakanikimehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Manakobisa Teoso ati e nematamonaka ahi: \"Himataba tihamine tiri? Himataba tiyawine tiri? ");
INSERT INTO jaa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tiwehene amosemenehe, haha tinehene ama tike. Tiwehene hiyarara tike. Makoni yama hiyara nineke nokobi ya, tiwa noki naro tiwa yosehabonehe. Tikasawarihaboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Faya Kai ati e nematamonaka Abeo ni ya, fare nisori: \"Hima ahi e towakahi yama kabani ya\". Faya yama kabani ya me teme na Kai Abeo fito kanematamonaka fare nisori. Faya hinabowematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bahi toke ya Teoso Kai aate nematamonaka. \"Hibaka Abeo tohara niso?\" \"Owato okara\", Kai ati nematamonaka. \"Ha owa okaniso kakakatoma oha owa awine o?\" ");
INSERT INTO jaa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Faya Teoso ati e nematamonaka ahi: \"Himataba tiwehene e rini ahi? Wami ya niso emene ha naka, ha ni kitahari, manakone tabiyo awahari. ");
INSERT INTO jaa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Makoni yama hiyara kakehaboneke tiwa ni ya. Yama koro tinamarabone tike wami ya. Niso tinabowi ya afa wami inohoti ebe kanaharake niso emene fawahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wami hawa tinihi ya yama koro tini ya, yama yanaraboneke. Yaka tiwaharehaba ama tike yama nafi ya. Ma tirahaba ama tike. Fawa rima tinahaba ama tike fara yama wehe nima\". ");
INSERT INTO jaa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kai ati e nematamonaka ahi: \"Teoso yama nawahake faro. Okitamaraba ama oke. ");
INSERT INTO jaa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hibayata ya owa tiyosema tike, owinamarabone owa haha wami ya, yama nafi ya yaka owaharehabone owa, fara yama we nima fawa rima onahaba owa, tiwa owahiyahaba owa. Bara owa me kobo ni ya owa me nabowahabone me ati naba me awineke\". ");
INSERT INTO jaa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","\"Yama e na wataraboneke fahi. Hahi tiwa nabowehi me one ahababoneke me seti na mati, tika manakonebonehe\", Teoso ati nematamonaka. Faya Teoso Kai ka yamabone nawanematamonaka, bare kobo hine ya bare hinabowarebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Manakobisa Kai winamarehimatamonaka Teoso taboro ya. Winawematamonaka Noti ka wami ya, Etehi beheri ya, bahi kakamaki ka ya. ");
INSERT INTO jaa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kai fati ya famehi me ka inamatewe nehimatamonaka. Ino me hinawatematamonaka. Inomatamona amaka Enoki. Manakobisa yama toyabo ya Kai sitati hiri nematamonaka. Ini hinawatemetemoneke. Inimetemone amake Enoki, fare biti ino. ");
INSERT INTO jaa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki Irati batimatamonaka. Irati Meosaeo batimatamonaka. Meosaeo Metosaeo batimatamonaka. Metosaeo Rameki batimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rameki fati famarawehemetemoneke. One inimetemone amake Ata. One inimetemone amake Sira. ");
INSERT INTO jaa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ata biti nehimatamonaka. Inomatamona amaka Sabao. Bowi me nanayana me ka itimatamona amaka Sabao, me wina mati yobe makari tohehi ya. ");
INSERT INTO jaa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Sabao nisori nehimatamonaka. Inomatamona amaka Sobao. Ayaka hihiri me ka itimatamona amaka, Sobao, yama me fo, rira me teo, na mati, fiorao nima naro. ");
INSERT INTO jaa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sira biti nabisehimatamonaka. Inomatamona amaka Tobaokai. Feho hihirimatamonaka. Yama hihiri tohehimatamonaka, feho hiri ni tohaharo. Yama one hiri, nematamonaka borosi hiri ni tohaharo. Tobaokai hinakasima nehemetemoneke inimetemone amake Naama. ");
INSERT INTO jaa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Yama we one ya Rameki ati yana nematamonaka fatirawa ni ya: \"Ata ya Sira te famaha, owati te mitahi. Rameki fatirawa owati te kamitahi, e naro ahi: E ka owa owa noho tonihe onabowara oke. Yetene owa katome onahabihara oke. ");
INSERT INTO jaa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hahi Kai nabowehi me one ahababonemoneke me 7 na mati, manakonebonaha. Ha owa owa nabowehi me one ahababoneke, 77 me tohaha mati\". ");
INSERT INTO jaa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atao fati ya famehi me ka inamatewe owa nehimatamonaka. Ati e nemetemoneke ahi: \"Teoso okatao owabona ta namakitasaka Abeo taboro ya, Kai hinabowahari\". Ino hinawatematamonaka. Seti tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti biti nehimatamonaka. Inomatamona amaka Enosi. Afa yama tohi ya Teoso me ha na Teoso ino Yeofa tohahi ino me itihemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Atao ka noti me ini e nemetemoneke ahi: Eteba hiri ni Teoso yana kane ya fare Teoso nima e nemetemone eke ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Teoso maki hiri, fana hiri, nematamonaka. Yama amosa ta nematamonaka me ni ya. Me inibone itihimatamonaka e toaharo. ");
INSERT INTO jaa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Atao ka ano 130 tohi ya biti nehimatamonaka, fare he nima nari, fare he awi ya awi tohahari. Ino hinawatematamonaka. Inomatamona amaka Seti. ");
INSERT INTO jaa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Biti me one na, bite narawa, nemetemoneke. Hinaka ano 800 tohamakehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ahabematamonanaka hinaka ano 930 tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti ka ano 105 tohi ya biti nehimatamonaka Enosi. ");
INSERT INTO jaa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Manakobisa Seti biti me one na, bite narawa, nemetemoneke. Hinaka ano 807 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ahabematamonaka hinaka ano 912 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi ka ano 90 tohi ya, biti nehimatamonaka Kaina. ");
INSERT INTO jaa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Manakobisa Enosi ka ano 815 tohamakehemetemoneke. Biti me one na, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ahabematamonaka hinaka ano 905 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kaina ka ano 70 tohi ya, biti nehimatamonaka Marareo. ");
INSERT INTO jaa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Manakobisa Kaina biti me one na, bite narawa, nemetemoneke. Hinaka ano 840 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ahabematamonaka hinaka ano 910 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Marareo ka ano 65 tohi ya biti nehimatamonaka Sareti. ");
INSERT INTO jaa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Manakobisa Marareo biti me one na, bite narawa, nemetemoneke. Hinaka ano 830 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ahabematamonaka hinaka ano 895 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sareti ka ano 62 tohi ya biti nehimatamonaka Enoki. ");
INSERT INTO jaa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Manakobisa Sareti biti me one na, bite narawa, nemetemoneke. Hinaka ano 800 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ahabematamonaka hinaka ano 962 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoki ka ano 65 tohi ya biti nehimatamonaka Matosare. ");
INSERT INTO jaa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Manakobisa Enoki ka ano 300 tohamakehemetemoneke. Enoki Teoso owa totoha tohehimatamonaka, he ya famahari. Biti me one na, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoki ka ano 365 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Teoso ya fafama tohe yama we one ya fawa nematamonaka, Teoso hekamahari. ");
INSERT INTO jaa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matosare ka ano 187 tohi ya biti nehimatamonaka Rameki. ");
INSERT INTO jaa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Manakobisa Matosare biti me one na, bite narawa, nemetemoneke. Hinaka ano 782 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ahabematamonaka hinaka ano 969 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Rameki ka ano 182 tohi ya biti nehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ati e nematamonaka ahi: \"Wami hiyakere, Teoso ati ehenemata. Makoni e ni ya yama ahi ni nafike. Manakobisa hahi hinamatewe era kasomebona eke e hasi nabone e\". Rameki biti ino nawatematamonaka. Nowe tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Manakobisa Rameki biti me one na, bite narawa, nemetemoneke. Hinaka ano 595 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ahabematamonaka hinaka ano 777 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowe ka ano 500 tohi ya, biti me nehemetemoneke. Me famaha me ka owa oharimakimatamonaka. Me ini amake haro Se, Ka, Safe. ");
INSERT INTO jaa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Faya me totama me tokakanikima nemetemoneke yama nafi ya wami nafi ya. Fana bite na narawemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Neme ka fanawi me awarawehemetemoneke, awi amosarawaro. Faya me hinofarawa me hiyabarawemetemoneke me ka yiboterawabonehe, neme ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Faya Teoso ati yana nematamonaka. \"Me sawi fara tohahaba wataraboneke, me ahabateha mati. Makoni me ka ano yowatehaboneke waha, 120 tohaha ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Neme ka e fanawiri me ahi narawa me ka matehe narawemetemoneke. Me kitehemetemoneke, me fotaha mati, me me hikahiyara mati. Me sawi nemetemoneke afa yama nowati ya bisa. ");
INSERT INTO jaa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Faya Teoso me ihi awehimatamonaka yama me nima na mati yama hiyararo yama hiyara me hiri nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Teoso yawehimatamonaka kasiro ya. Mera hiri ne ehenemata nofamarehimatamonaka, bofe ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yawe ati e nematamonaka ahi: \"Me hiri ona me fawa onihabana oke, me sawimarabone mati wami ya. Bani me toha naboneke, hine me horo na me toha, me afe naha me toha, na mati. Me hiri onahamaro owehene onofama okere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nowe ehene ta Teoso nonofa tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowe tamine e nematamonaka ahi: Nowe ehene aamosa tohehimatamonaka. Oharimatamonaka, ehene hiyareba watarari. Teoso ya fafama tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowe biti me famaha me ka owa oharimaki nematamonaka. Me inimetemone amake haro: Se, Ka, Safe me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Teoso ni ya me one nafi ihi hiyara nafihemetemoneke, me abe waka na mati tabora nafi ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Me nafi ihi hiyara me ihi Teoso awehimatamonaka, bofe ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Faya Teoso ati yana nematamonaka, Nowe hiyarari. \"Me nafi fawa onihabone oke, me abe waka ni fawa ri karo. Me fawa oniha, wami fawa oniha, onahabone oke. ");
INSERT INTO jaa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Awa amosa tiwahi hiri tinahabana, tika fotowati ehebotebana. Fotowati tori ka yama bari ni kote hiri ni titamabone tike. Tori moya, mese ka moya, tinahaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tomi kani e naboneke ahi: yowi ka metoro 113 tohahaboneke. Enoki ka metoro 22 toha, bari fori ka metoro 13 toha, naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Baribone hiri tinahaboneke. Bari ifi hoti ka metoro kote tohahaboneke hasi naro. Fotowati ka nokobibone hiri tinahabone tike ohariharo, wanahabonehe beheri one ya. Fotowati bari ka fori terei naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Faha oyosehabone oke, faha fowe nafihabonehe, wami abe nafi ahabibone karo, me hasi naba me wataribone karo. ");
INSERT INTO jaa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ha tiwa ta tiwa owakatomabone oke. Owati okominahabone oke tiwa ni ya, tiwa owakatomabone ona owati. Tikiyomahabone tike fotowati tori ya. Tikatao me toha, tika yibote toha, tika koma toharawa naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Bani me tekiyoma tinahabone tike fotowati tori ya, me hasi tinihabone mati, tiwa ya me tabi ya, me fafama mati. Bani owa fana ya fama, owa fana ya fama nebonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Afa me kakehaboneke tiwa ni ya, me hasi nabone mati, me fafamaha mati, bani me nafi. Bani me afe wataha me toha, hine me horo na me toha, naboneke, me nafi tohaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Yamata yoro tokana tinihabone tike, te kaba, bani me hikaba, hinahabonehe\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Faya fare Teoso ati nafi nima Nowe ehene nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Manakobisa Teoso ati yana tasematamonaka Nowe hiyarari. \"Tikiyomahi fotowati ya, ha tiwa tika yibote te na, te nafi. Ha tiwa tiwehene owi onofa ama oke. Fara tiwaharine tike yama amosa hiri tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bani me amosa me tekiyomahi, me 7 na mati, me ka yiboteba ya me fafamaha mati. Haha bani me ka yiboteba ya me fafama nahi haro me hiyara mati, bani bara mati. ");
INSERT INTO jaa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Bani me afe wataha me tekiyoma tinahi haro, me 7 na mati, me ka yiboteba ya me fafama mati, me hasi nibone karo yama nafi ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Haha yama amo ni 7 na ahabi ya faha oyosebone oke kakehabonehe. Kaki ka yama wehe 40 toha, yama soki 40 toha naboneke. Yama e naboneke ahi me nafi onahabihibone karo me yati na mati me hiri onahamaro mati. ");
INSERT INTO jaa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Fare Teoso ati nafi nima Nowe ehene nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe 600 ano tohe ya faha fowe ehebote kakehemetemoneke, wami nafi fawa niharo. ");
INSERT INTO jaa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tokiyomehimatamonaka fotowati ya, biti me ya tabahari, fa fowe ihi me toharabone mati. Fati toha nemetemoneke. Hinaka koma toharawa nemetemoneke biti me ka yiboterawaha. ");
INSERT INTO jaa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Bani me kakehemetemoneke Nowe ni ya, me tokiyomahabani mati fotowati tori ya, me fafamaha mati. Fare Teoso ati nima me nemetemoneke, aya Nowe narabo nima nari. Bani me amosa me toha, me hiyara me toha, me afe wataha me toha, hine me horo na me toha, nemetemoneke, me fafamaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yama amo ni seti na nowati ya, faha kaki kitaha wami fawa nihemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Haha amo ni ya Nowe ka ano 600 tohehemetemoneke. Faha kaki nafiha yana tonehemetemoneke abariko taiti nowati ka abariko ya, yia 17 ya. Faha nafiha kimisa nemetemoneke wami boti ka faha. ");
INSERT INTO jaa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Faha kakehemetemoneke ahi wami ya. Kaki ka yama wehe 40 toha, yama soki 40 toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Afa yama wehe ya Nowe fati ya famehi tokiyomehimatamonaka fotowati tori ya biti me ya tabahari. Se toha Ka toha Safe toha me ka yibote toharawa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Me tokiyomehemetemoneke bani me ya me tabaha mati. Bani tabora ka me toha bani yama kabani ka me toha haha hine me horo na me toha bofe ya bani me afe wataha me toha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bani me nafi tokiyomehemetemoneke Nowe ya me tabaha mati, me fafamaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bani me tokiyomehemetemoneke, me fafamaha mati. Owa fati ya fama, owa fati ya fama, me nemetemoneke, fare Teoso ati nima me na mati, aya Nowe narabo nima ne ati. Faya Teoso nokobi boko nawahamehimatamonaka fahi, fotowati ka nokobi. ");
INSERT INTO jaa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Faha kaki ka 40 amo ni tohehemetemoneke. Faha kimisemetemoneke. Fotowati itihemetemoneke fahi. Fotowati tafo tonehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Faha kimisemetemoneke. Fotowati tafo tosa nemetemoneke faha ya. ");
INSERT INTO jaa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Faha kimisasa nemetemoneke. Kimisi ka atami nemeharawa nafi fawa kanehemetemoneke faha ihi. ");
INSERT INTO jaa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Manakobisa kimisi forima nemetemoneke mata ya. Tomi kani ka 7 metoro tohamakemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yama abe nafi ahabemetemoneke. Bani me afe wataha me toha, tabora ka bani me toha, yama kabani ka bani me toha, nemetemoneke. E ahaba nemetemoneke bisa, e nafi. ");
INSERT INTO jaa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Me nafi ahabemetemoneke me naha mati ahi wami ya, me yati tohaha mati me hasi na mati fara e hasi ni nima. ");
INSERT INTO jaa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Fotowati tori ya me kibeha me ta me hasi nemetemoneke, Nowe ya me taba mati. Me one ahabemetemoneke me nafi. E toha, bani tabora ka me toha, bani yama kabani ka me toha, haha hine me horo na me toha, bani me afe wataha me toha nemetemoneke, me ahaba mati, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Faya yama amo ni 150 tohaha nowati ya faha sai yana tonehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Afa yama ya Teoso Nowe wati nawahematamonaka bani me tamaha me ya tabahari fotowati ya. Teoso ati ehene boni yama fo towitiemetemoneke, wami ka yama. Makoni faha sai yana tonehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Faha kaki fawa nemetemoneke, neme ka nokobi Teoso boko kawahame karo. Wami boti ka faha kimisi fawa, nemetemoneke, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","150 yama amo ni tohaha nowati ya faha sai yana tonehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Fotowati ma tonehemetemoneke Ararati ka yati si tonaha mese ya, abariko 5 ne ahabe nowati ya. ");
INSERT INTO jaa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Faha saisa nemetemoneke. Atami tati boni awihinamemetemoneke abariko fame owa kote ya. ");
INSERT INTO jaa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","40 yama amo ni tohaha nowati ya Nowe nokobi bite naha kanehimatamonaka afa aya hiri hinehemete wanaharo fotowati ya. ");
INSERT INTO jaa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Faya bani biti sa tosematamonaka. Bani biti ino amaka hari kofo, owinari nima nari. Sa hise tokehimatamonaka. Yobi nawaharematamonaka, yama noki nari wami hokowai tabiyo. ");
INSERT INTO jaa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Manakobisa Nowe bani biti owa okoko tohe sa tosatasehimatamonaka yama awehibonaha wami hokowai tabiyo. ");
INSERT INTO jaa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Okoko yama wasirematamonaka taborobana warisaba karo. Wami wataremetemoneke. Faha nasa nemetemoneke wami neme ya. Makoni Nowe mano ta tonehimatamonaka, okoko wara tonehibonaha. Hibemematamonaka fotowati ya. ");
INSERT INTO jaa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowe yama noki nematamonaka amo ni 7 tohamakeharo. Faya okoko sa tosehimatamonaka tasa. ");
INSERT INTO jaa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Fari namehimatamonaka bahi toke ya. Yama kakamematamonaka bono ya awa afe kini tatati naro. Awa inimetemone amake haro orifa. Faya Nowe yama watohimatamonaka fahi faha saiharo. ");
INSERT INTO jaa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yama noki nematamonaka amo ni 7 namakiharo tasa. Faya okoko sa tosehimatamonaka tasa kamarebanoho waha. ");
INSERT INTO jaa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Manakobisa Nowe ka ano 600 tohi ya faha watamaremetemoneke abariko taiti ka yama wehe taiti ya. Wami tohamemetemoneke saiharo. Nowe fotowati bari itibase yama awehimatamonaka wami hokowaharo faha watamari karo. ");
INSERT INTO jaa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Wami nafi hokowemetemoneke abariko taiti nowati ka abariko ya, 27 yama amo ni tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Faya Teoso ati yana nematamonaka, Nowe hiyarari. ");
INSERT INTO jaa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","\"Tasi tinahi fotowati ya tika yibote ya te famaha te. Tikatao me toha, tika koma toharawa nahi. ");
INSERT INTO jaa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tiwehene e na ahi: bani me nafi tasisi nahi tiwehene aya me ya titabi karo, bani me afe wataha mati, bani tabora ka mati, bani yama kabani ka mati haro hine me horo na mati bofe ya, me kahiwabone mati, me totamabone mati, wami nafi ya me winaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Faya Nowe fati ya famehi me tasi tokanemetemoneke fotowati ya. Biti me toha, hinaka koma toharawa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bani me nafi tasisi nemetemoneke bisa, me afe wataha me toha, hine me horo na me toha na mati, fara hinama me tohabisa mati. ");
INSERT INTO jaa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Manakobisa Nowe tana hiri nematamonaka, bani mera ta nebonaha Teoso ni ya. Bani me afe wataha me toha, bani me one toha na mera waka nematamonaka, me kabateha mati, me tabasi hinahabani mati. ");
INSERT INTO jaa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bani me mahi amosa me mahi Teoso hisi ne ati boti e nematamonaka ahi: \"Yama me nima hina hiyatera amake, me nafi, matehe toha, me fotaha me toha na mati. Me ihi hiyara me ihi owa okene yama hiyara e na oyosematerabana oke wami ya. Me nafi tohaha bani me ya me tabaha me onahabihamaterabone oke. ");
INSERT INTO jaa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Wami tohasa ni ya yama wehe fawa rihi, yama soki fawa rihi, naboneke, owati ihi. Yama hiwaha toha, yama siriha toha, faha fowe toha, yama hiwe toha, naboneke. Yama me koro, yama boni me bata, naboneke fara ano ya\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Faya Teoso Nowe me ka yama amosabone ta nebona ati nematamonaka. \"Tikatao me ka matehe tamatehaboneke. Tika noti me tamahabone tike me tokakanikima nabone mati yama nafi ya wami nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bani me nafi kitaraba me amake te ehene. Tera me nakomehaba me amake, yama kabani ka me toha, me afe wataha me toha, hine me horo na me toha, ma ka aba me toha na mati, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Afa me te kabahabone teke waha. Hibati ya yama koro na te kabahabone onahamaro ama oke. Bani me toha naboneke waha. ");
INSERT INTO jaa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bani me ame me kihaha me ta me te kabarabone teke. Me ame ahabi ya me te kabahaboneke, me ahabi forima na mati. ");
INSERT INTO jaa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Era me waka na me ahaba naboneke. Bani era nabowe ahabebonaka. E ka owa era nabowe ahaba nebonaka. ");
INSERT INTO jaa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","E hiri onahamaro ama oke, me e nabone mati owa nima. E ka owa era nabowe hahi ehene itihi ahabebonaka bisa. Bare hinabowebonaka bisa. ");
INSERT INTO jaa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tikatao me ka matehe tamatehaboneke. Tika noti me tamahabone tike me tokakanikima nabone mati yama nafi ya wami nafi ya\". ");
INSERT INTO jaa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Faya Teoso ati yana tasehimatamonaka, Nowe biti me ya tabehi ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","\"Owati okominahabone oke, tera owakatomabone ona owati, te ka noti me owakatoma onahabone owa, te watamari ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Bani me nafi owakatoma onahabone oke, aya me tasisi na mati fotowati ya, me ya titabi ka mati, me afe wataha me toha, tabora ka me toha, yama kabani ka me toha, na mati, me nafi wina mati wami ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tera owakatomahabone oke. Me nafi ahabiba watamateraba me amake faha fowe nafiha ihi. Faha fowe nafiha wami nafi nahabimateraba amake. ");
INSERT INTO jaa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yama onamoabana oke, owati te watoba karo, tera owakatomatehabone ona owati. Tera owakatoma, bani me nafi owakatoma, te ka noti me owakatoma, otehabone oke, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yama onawara oke neme ya, maka tohaharo, te awehibonaha, owati te watohabone te, tera owakatomabone ona owati, wami ka me te. ");
INSERT INTO jaa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yama noki yawari nafiha ni ya maka owa oni ya ");
INSERT INTO jaa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","owati wati owahamabone oke, tera owakatomabone ona owati, bani me ya te tabaha te, me yoro tokana mati. Faha fowe nafiha te nafi nahabimateraba amake. ");
INSERT INTO jaa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Maka hine namo ya neme noki yawari boti ya, owati wati owahabone oke aya okominaharo, tera owakatomabone ona owati, bani me ya te tabaha te. ");
INSERT INTO jaa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Maka owati kaminaka, wami ka me nafi owakatomabone ona owati\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowe biti me inimetemone amake haro, me tasisi na mati fotowati ya: Se, Ka, Safe. (Kanaha batimatamona amaka, Ka.) ");
INSERT INTO jaa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Afa Nowe biti memetemone me amake, me terei na mati. Me ka noti me tokakanikima nemetemoneke yama nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe yama kokoromatamona amaka. Ofa kokoro taitimatamona amaka. ");
INSERT INTO jaa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Yama we one ya Nowe fi fawi nafihimatamonaka. Hanohimatamonaka kasiro ya. Tokiyomame amo nematamonaka hinaka yobe bani me atari tohe wehi toro ya, korone tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaha bati Ka tohe bati awehimatamonaka, korone tohahari. Tokome faya bati kaminematamonaka, anoti me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Manakobisa Se ya Safe me famaha makari ibe me totimemetemoneke. Me hibariemetemoneke me iyori ya. Me towakamehemetemoneke me yaka kani me bari ka ya. Faya me ka abi me yoto kanehemetemoneke makari ibe ya korone tohahari, me noki toha mati ha ya. Me ihi e nemetemoneke me ka abi me awarabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Manakobisa Nowe tafime ya hanohi hano fawa ne kitame ya, hiyara mitehimatamonaka biti yoto ke tohe hiwahari korone. ");
INSERT INTO jaa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nowe ati yana nematamonaka. \"Yama hiyara kakehaboneke Kanaha ni ya. Anoti me ka yama aahiteba amaka\". ");
INSERT INTO jaa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nowe ati e nematamonaka ahi tasa: \"Teoso e kahiyarahi, Se ka Teoso. Se me ka yama aahi Kanaha me tohatehaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Safe me ka wami nafihaboneke, Teoso ati ehene. Safe me winatehaboneke Se me tabori ya, Se me me nofaha mati. Safe me ka yama aahi Kanaha me tohatebisaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Manakobisa faha fowe ehebote nowati ya Nowe ka ano 350 tohamakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ahabematamonaka hinaka ano 950 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowe ka noti me inimetemone amake haro, biti me ka matehe, Se, Ka, Safe me na mati. Me ka matehe watehemetemoneke faha fowe ehebote nowati ya. ");
INSERT INTO jaa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Safe biti memetemoneke haro, Kome, Makoki, Matai, Safa, Tobao, Meseki, Tirasi me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kome biti memetemoneke haro, Asikenasi, Rifati, Tokama me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Safe ka noti me tohate me amake haro, Erisa ka me toha, Esibaya ka me toha, Sibiri ka me toha, Rotisi ka me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Afa Safe ka noti me tohate me amake. Ma witi ya me one wina, wami itakosaha ya me one wina, te me amake. Fara me ati me hiri te me amake, me ati hiyaya na mati. Me abe ebe nemetemoneke tabora tamaha ya me winakanikima nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ka biti memetemoneke haro, Kosi, Esito, Ribia, Kanaha me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kosi biti memetemoneke haro, Seba, Hafira, Sabita, Rama, Sabiteka me na mati. Rama biti memetemoneke haro, Saba, Teta me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kosi Niroti batimatamona amaka hari Niroti me nafi tabori iihawa taiti tohehimata. ");
INSERT INTO jaa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Teoso hinarife yama yeyete tohehimatamonaka. Makoni me ati e te me amake ahi, \"Niroti nima tinahabone tike, yama yeyete tohehimata, Teoso hinarifahari\", me ati te me amake. ");
INSERT INTO jaa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Taiti ya sitati terei na ka me ka towisawamatamona amaka, Babironia, Ereki, Akati naro, wami Sina tohaha ka sitati. ");
INSERT INTO jaa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Manakobisa tokehimatamonaka Asiria ka wami ya, sitati one hiri nebanoho, Ninifi, Reoboti, Kara, ");
INSERT INTO jaa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Rese naro. Ninifi ya Kara famaha basa kani ya Rese tohate amake, Kara sitati ehebote tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Esito ka noti me tohate me amake haro, Ritia ka me toha, Ana ka me toha, Reabi ka me toha, Nafito ka me toha, ");
INSERT INTO jaa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Batorosi ka me toha, Kasiro ka me toha, Kereta ka me toha na mati. Kereta ka me ka noti me one amake, Firisia ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaha biti me famehemetemoneke haro, Sito taiti toha, Heti toha, nari. ");
INSERT INTO jaa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaha ka noti me tohate me amake haro, sebo me toha, amo me toha, kikasi me toha, ");
INSERT INTO jaa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","hifi me toha, aki me toha, si me toha, ");
INSERT INTO jaa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arifati me toha, sema me toha, hamati me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaha ka me ka wami yowehemetemoneke, bahi kakamaki beheri ya, Sito ya. Yowa nemetemoneke bahi kakamaki beheri owa ya, Sera ya, Kasa yabori ya. Yowa nemetemoneke bahi kakamaki ya Sotoma, Komoha, Atima, Sebowi na ya, Rasa yabori ya. ");
INSERT INTO jaa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Afa Ka ka noti me tohate me amake. Fara me ati me hiri te me amake, me ati hiyaya na mati. Me abe ebe nemetemoneke tabora tamaha ya me winakanikima nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Safe anoti Se tohe ebereo me nafi ka itimatamona amaka. ");
INSERT INTO jaa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Se biti memetemoneke haro, Erao, Aso, Ahabasati, Roti, Ara me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ara biti memetemoneke haro, Osi, Ho, Kete, Masi me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ahabasati Sera batimatamona amaka. Sera Ebe batimatamona amaka. ");
INSERT INTO jaa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe biti me famehemetemoneke, Bereki ya Sokita famahari. Bereki sawi ka yama ya me nafi abe ebe kanehemetemoneke. Makoni me abe ebe kani Bereki ino kaminaka. ");
INSERT INTO jaa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Sokita me ka abimatamona amaka, Aomota, Serefi, Hasamafe, Sera, ");
INSERT INTO jaa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Atonirao, Osao, Tikara, ");
INSERT INTO jaa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obao, Abimayeo, Saba, ");
INSERT INTO jaa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi, Hafira, Sobabi me na mati, Sokita biti me toha mati, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Me winate me amake wami ini Mesa tohaha ya, Mesa beheri ka wami toha na ya. Me tabori yowate me amake sitati Sefa tohaha ya, yati nemeha si toni ka yama ya, bahi kakamaki ya. ");
INSERT INTO jaa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Afa Se ka noti me tohate me amake. Fara me ati me hiri te me amake, me ati hiyaya na mati. Me abe ebe nemetemoneke tabora tamaha ya me winakanikima nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Afa Nowe ka noti me tohate me amake. Faha fowe webote nowati ka tabora nafi ka Nowe ka noti hinama me amake. ");
INSERT INTO jaa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hibati ya me ati fara oohari tohehemetemoneke, me nafi. Me ati hihiya naba wataremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bahi kakamaki ya me wina me one yana tona me kakehemetemoneke Sina ya, yama homi amosa ya, atami kihararo, me winahabani mati fahi. ");
INSERT INTO jaa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Me wina faya yama wehe one ya me abe hiyaremetemoneke. \"Hima tisoro kahi e hiri nahi\". Faya yobe tisoro tohe hiri ni me yana tonehemetemoneke, moya naro bisi ya. Yobe yati hiri ni tohehi hiri ni me nofamaremetemoneke, moya nari simeto ya. ");
INSERT INTO jaa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Me ati yana tasehemetemoneke. \"Sitati e hiri nahi, yobe nemehe kihaharo, kobo tomisebana neme baki ya. Manakobisa era me kahiyaraboneke. E toka nawaharerihi nabone eke yama nafi ya\". ");
INSERT INTO jaa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Manakobisa Teoso kakehimatamonaka ahi bofe ya, me ka sitati awehibonaha, yobe nemehe toha nari, hawa toharari mata. ");
INSERT INTO jaa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ati yana nematamonaka. \"Fara me ati oharineke, me wini oharia mati. Me ihi nafike, owaharo. Yama one ya me ihi fotamisahaboneke mata ya. Fara yama me hinofa me hiri naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hima e tokisahi bofe ya. Me ati e tonahiyabone eke, me ati hiyaya naba mati, me abe ati watomaribone karo\". ");
INSERT INTO jaa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Faya Teoso mera ebe nematamonaka, me tokarikosabone mati wami nafi ya. Sitati me hiri namaremetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Sitati ini me nawatemetemoneke Babeo tohahabonehe. Babeo ini yama kaminineke haro, yama e tonahiyi karo. Ini mera kaminineke, me ati Teoso hinahiya mati, me ebe hinahabone mati, me nafi, me tokarikosabone mati wami nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Se ka noti me e nemetemoneke ahi. Faha fowe ehebote ahaba nowati ka faha fowe famamake nowati ya Se ka ano 100 tohi ya biti nehimatamonaka Abasati tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Manakobisa Se ka ano 500 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Manakobisa Abasati ka ano 35 tohi ya biti nehimatamonaka Sera tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Manakobisa Abasati ka ano 403 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Faya Sera ka ano 30 tohi ya biti nehimatamonaka, Ebe tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Manakobisa Sera ka ano 403 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Faya Ebe ka ano 34 tohi ya biti nehimatamonaka, Bereki tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Manakobisa Ebe ka ano 430 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Faya Bereki ka ano 30 tohi ya biti nehimatamonaka, Reo tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Manakobisa Bereki ka ano 209 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Manakobisa Reo ka ano 32 tohi ya biti nehimatamonaka Seroki tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Manakobisa Reo ka ano 207 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Faya Seroki ka ano 30 tohi ya biti nehimatamonaka Nao tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Manakobisa Seroki ka ano 200 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Manakobisa Nao ka ano 29 tohi ya biti nehimatamonaka Tera tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Manakobisa Nao ka ano 119 tohamakehemetemoneke. Biti me one namake, bite narawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Manakobisa Tera ka ano 70 tohi ya biti me nehemetemoneke, me terei na mati, Abarao, Nao, Hara me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ka noti me e nemetemone me amake ahi. Me ka abimatamona amaka, Abarao, Nao, Hara me na mati. Ro batimatamona amaka Hara. ");
INSERT INTO jaa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera biti Hara tohe ahabematamonaka wami Babironia ya, sitati O tohaha ya, watamatamona ka sitati ya. Tera sawisa nematamonaka biti ahabi nowati ya. ");
INSERT INTO jaa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abarao Sarai itihimatamonaka. Nao Mioka iti nematamonaka. Hara biterawametemoneke, Mioka ya Isika famaharo. ");
INSERT INTO jaa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai biti me wataremetemoneke. Nabati weye hinaterabonemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Babironia ya Tera wine yana tonehimatamonaka, tokehibonaha wami ini Kanaha tohaha ya. Mera towakematamonaka, biti Abarao toha, hinaka noti Ro toha, nematamonaka, Hara biti. Hinaka koma Sarai tohaha towaka, nematamonaka, haro Abarao fati. Sitati Hara ya me ma nama me winehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Faya Tera ahabematamonaka Hara ya, hinaka ano 205 tohi ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Hara ya Abarao wine yama wehe one ya Teoso ati yana nematamonaka Abarao hiyarari. \"Abarao tiwinamarabone tike titaboro ya. Te one me ya titabamarabone tike, abi ka mati. Tikahabone tike wami one ya. Afa wamibone yofi okanabone oke tiwa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tika noti me tamatehaba ama tike kasiro ya. Me wini tamatehaba me amake. Tika yama amosatehaba ama tike owehene. Tiwa me kahiyaratehaba me amake. Me one ka yama amosatehaba me amake tiwehene. ");
INSERT INTO jaa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Tiwa onofabone me ati na me onofa onahabone oke. Tiwa onofarahabone me ati na me onofarahabone oke bisa. Oyahabone oke tabora nafi ka me ni ya tiwehene\". ");
INSERT INTO jaa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Fare Teoso ati nima Abarao ehene nematamonaka, yana tonahari Hara ya. Hinaka ano 75 tohehemetemoneke yana tonahari. He ya Ro famehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abarao fati Sarai toha towaka, anoti biti Ro tohe towaka, hinaka yama aahi mera towaka, hinaka yama nafi towaka nematamonaka. Hara ya wiwina tohe yama aahi me tamaha mera kanika, yama tamaha kiha, nawahematamonaka. Wami Kanaha tohaha ya kobo ne ");
INSERT INTO jaa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","kariwematamonaka Kanaha baikani ya. Faya kobo tasehimatamonaka tabora Sike tohaha ya. Awa ehebote ini More tohaha wehemetemoneke Sike ya. Afa yama ya Kanaha ka me winasa nemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Faya Teoso kakehimatamonaka Abarao ni ya. Ati yana nematamonaka. \"Abarao afa wami ta otehabone oke haro tika noti me ni ya\". Afa tabora ya Abarao tana yati toha hiri nematamonaka, bani ta nebonaha Teoso ni ya, Teoso awe karo fahi. ");
INSERT INTO jaa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Manakobisa Abarao tokehimatamonaka sitati Beteo beheri ka yama ya, yati si toni ka yama ya, bahi kakamaki ya. Hinaka yobe kabirito kone kowi tohehi si nirimatamonaka fahi. Sitati Ai tohehemetemoneke bahi kakamaki ya. Tana yati toha hiri tasematamonaka, bani ta nebonaha Teoso ni ya, Teoso ha nari. ");
INSERT INTO jaa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Manakobisa yaka nawaharematamonaka Kanaha ka wami ya, tokahari bahi kakamaki beheri ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Afa yama ya me fimi yana tonehemetemoneke Kanaha ka mati, yama kabahaba watamari karo. Makoni Abarao tokehimatamonaka winehibonaha mata ahi Esito ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Esito yabori ya me bori nake Abarao fati Sarai hiyarematamonaka. \"Owati timitahi. Ha tiwa fana amosawi ama tike. ");
INSERT INTO jaa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Esito ka tiwa me awi ya me ati e naba me awineke ahi: 'Efe fati amake', me ati naba me awineke. Faya owa me nabowahaboneke, ha tiwa ta tiwa me hasi niha mati. ");
INSERT INTO jaa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tiwati e nabone tike ahi: okasimamone tiwa tinihabana tike. Faya tiwehene owa me nabowarabanake. Owa me nofahaboneke fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Faya Esito ya Abarao kobo ne fati Sarai Esito ka me hiwa awi amosamone me hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Esito ka towisawa ya tataba me hiwa hinehemetemoneke. Tamine me hikaminehemetemoneke towisawa ni ya, amosamonehe. Makoni me hekamehemetemoneke towisawa ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai ihi towisawa Abarao nofehimatamonaka. Yama tamaha ta nematamonaka he ni ya, ofeya me toha, bowi me toha, someto me toha, yama aahi me toha, yama aahi fanawi toharawa, someto fana toharawa, kamero me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sarai ihi Teoso towisawa mera narabikehimatamonaka yama kome kitaha yosehari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Makoni towisawa Abarao ino hiri nematamonaka. Ati yana nematamonaka. \"Abarao himataba tiwehene e rini owa ni ya? Tika yiboteni tikaminehene ama tike owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Asimamone tina otiharake. Tika yibote titimahi. Te towakamahi\". ");
INSERT INTO jaa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Manakobote towisawa ati ehene Abarao me me towakamehemetemoneke, towisawa ka saotato mati, me winamarabone mati Esito ya. Fati toha, hinaka yama nafi toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abarao winamarehimatamonaka Esito ya. Tokomematamonaka Kanaha kote ya, bahi kakamaki beheri ya, hinaka yama nafi towakari, fati ya famahari. Biti owa Ro tohe toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abarao honehimatamonaka kasiro ya. Hinaka bowi me tama, barata nafiha kiha, oro nafiha kiha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Yaka nawahare faya kobo nematamonaka Beteo ya. Tokomatase ma tonamematamonaka Beteo ya Ai fama basakani ya. Afa tabora ya winibematamonaka baha. ");
INSERT INTO jaa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Kobo tonamematamonaka fara hinaka tana ya, hiri hinaharo baha. Faya Teoso ha nematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ro Abarao me ya tabehi ka bowi me tama, ofeya me tama, hinaka me tama, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ro Abarao me fama me ka bani me tami ka me taboribone wataremetemoneke, masiri nafiri karo, bani me tafebana. ");
INSERT INTO jaa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Faya me abe mono nemetemoneke, Abarao ka bani me nanarifa me ya Ro ka bani me nanarifa me tabaha mati. Afa yama ya Kanaha ka me winasa nemetemoneke, Berisi ka me ya me tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Faya yama wehe one ya Abarao ati yana nematamonaka, Ro hiyarari. \"Ota one me te amake. E abe mono rabone eke. Era nanarifa me abe mono rihi nabone eke. ");
INSERT INTO jaa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","E abe ebe kanahabone eke. Wami tiwahi. Wami nafike. Aya tiki ya ahi yasoka ya okahabana oke kanihina ka ya. Aya tiki ya kanihina ya oka onahabana oke yasoka ka ya\". ");
INSERT INTO jaa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ro wami ki nematamonaka. Sotao ka faha witi ka yama awehimatamonaka, yowaharo sitati Soa ya. Faha kihahamone ati nematamonaka. Teoso ka awa boti nima namone ati nematamonaka, Esito ka wami nima, naro. Sotao witi ka yama e nemetemoneke ahi, sitati Sotoma ya Komoha fama Teoso nahabire ya mata. ");
INSERT INTO jaa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Faya Sotao witi ka yama Ro ihehibona ati nematamonaka. Faya tokehimatamonaka bahi kakamaki ya. Abarao ya Ro me fama me abe ebe kanehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abarao ta winasa nematamonaka Kanaha ka wami ya. Ro ta tokomematamonaka, winehibonaha Sotao witi ka sitati ya. Yaka ne kobo nematamonaka Sotoma ya. ");
INSERT INTO jaa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Yama hiyara hihiri me tohehemetemoneke, afa mati, Sotoma ka mati. Me ihi hihiya toharemetemoneke kasiro ya Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Manakobisa Ro toke nowati ya Teoso ati yana tasehimatamonaka, Abarao hiyarari. \"Abarao yama nafi tiwahi. Bahi kakamaki ka yama tiwa, bahi totoka ka yama tiwa, bahi kakamaki beheri ka yama tiwa, bahi totoka beheri ka yama tiwa, tinahi. ");
INSERT INTO jaa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Wami nafi tiwaha ta onahabone oke tiwa ni ya, tika noti me toha na me ni ya. Te taboroboneke, te winahabone te fara yama tohateha ya. ");
INSERT INTO jaa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tika noti me tamatehaba me amake, wami hobokori nima me na mati, owehene. Wami hobokori tomi kani e watotera e amake. Wami hobokori nima me naboneke, me tomi kani e watora mati. ");
INSERT INTO jaa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tikahi Kanaha ka wami nafi ya. Yaka tiwaharehabone tike wami nafi tohaha ya. Afa wami nafi ta onahabone oke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Faya Abarao yobe me tisa me tokehemetemoneke sitati Heboro ya. Me winawehemetemoneke Manere ka awa ehebote boti yabori ya. Faya Abarao tana yati tohaha hiri tasehimatamonaka, bani ta nebonaha Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Afa yama ya Sina ka towisawa Arafeo tohehimatamonaka. Erasa ka towisawa Arioki toha, Erao ka towisawa Ketoraome toha, Kowi ka towisawa Titao toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Afa towisawa me kowato na towisawa me one me mowa nemetemoneke haro, Sotoma ka towisawa Bera toha, Komoha ka towisawa Bisa toha, Atima ka towisawa Sinabi toha, Sebowi ka towisawa Semebe toha, Bera ka towisawa toha, me na mati. Bera ini one amake haro, Soa tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Afa towisawa me siko na me ka saotato me me yoro tokaniwamemetemoneke Siti ka faha witi ka yama ya, faha ehebote Mohoto iti ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Towisawa Ketoraome mera yoyose tohehimatamonaka baha, hinaka yinerobona me ta hinehibonaha ano 12 tohaha ya. Faya yinero ta ni me nofamara yinero ta ni me fawa nemetemoneke Ketoraome ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Faya ano oharia nowati ya Ketoraome towisawa me one ya tabehi kakehimatamonaka mera mowa nebonaha. Me me mowa nemetemoneke refa mati, Asiteroti-Kanai ya. Me me mowa, nemetemoneke sosi mati, Ha ya. Me me mowa, nemetemoneke emi mati, Safe-Kiriatai ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Me me mowa, nemetemoneke, ho mati, Sei ka yati nemeha si tonaha ya. Faya me me kiyoha me me sa tosehemetemoneke Eobara ya, yama honara yowi ka yama ya. Me nafi kitaremetemoneke Ketoraome me ihi. ");
INSERT INTO jaa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Faya Ketoraome me wete namehemetemoneke Katisi ya, me one me me mowa nabone mati. Hibati ka inimetemone amake Emisibati, Katisi tohaharo. Amareki me tabori nafi me ihawehemetemoneke. Faya amo me me mowa nemetemoneke, me wina mati Asasao-Tama ya. Amo me kitaremetemoneke me ihi. ");
INSERT INTO jaa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Manakobisa towisawa me ka saotato me ya me tabaha me tokehemetemoneke Siti ka faha witi ya, Sotoma ka towisawa toha, Komoha ka toha, Atima ka toha, Sebowi ka toha, Bera ka toha, me na mati, towisawa me siko na mati. Me toka towisawa me one kowato na me me mowa nabone me ati nemetemoneke, Erao ka towisawa toha, Kowi ka toha, Sina ka toha, Erasa ka toha, me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siti ka faha witi ya hoti tamehemetemoneke, bisi kihaharo. Me abe mowa na towisawa me kowato na me ihi Sotoma ka towisawa ya Komoha ka towisawa me fama me kitara me tokomabone me foro nemetemoneke hoti ya. Me tabi ka towisawa me one ta kana ni tokomemetemoneke yati nemeha si tonaha ya, me hasi nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Towisawa me kowato na Sotoma ya Komoha famaha ka yama nafi me ihehemetemoneke, yamata toha, yama manakone fotaha toha naro. Faya me tokomemetemoneke, yama me towakama mati. ");
INSERT INTO jaa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abarao biti owa Ro tohe Sotoma ya wine me hiwate me hekamehimatamonaka. Hinaka yama nafi me hekama hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Sotoma ka me ka owa hasi ne tokomakehimatamonaka Abarao ebereo tohe ni ya, yama kaminebonaha Abarao ni ya. Abarao winehimatamonaka Manere ka awa ehebote boti yabori ya, Manere Amo ka me ka owa. Manere Abarao tesene me tohehemetemoneke, nisori me ya tabahari, Esiko toha Ane toha me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abarao biti owa towakami tamine mite hinaka saotato mera yoro tokaniwamematamonaka, me yanateha mati taboro ya. 318 me tohehemetemoneke. Abarao me ya tabe towisawa me kowato na me me kiyohemetemoneke. Faya me kobo nemetemoneke sitati Ta tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abarao ka saotato mera ebe kanehimatamonaka, ha ya me one toha, ha ya me one toha nabone mati, towisawa me kowato na me me mowa nabone mati. Yama soki ya me me mowa na towisawa me kowato na me kitaremetemoneke. Me tokoma me me hikiyoemetemoneke. Faya me tokomemetemoneke Hoba ya, Tamasiko kowani ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Faya Sotoma ka me ka yama nafi me hiyabamakiemetemoneke towisawa me kowato na me ni ya. Abarao biti owa Ro tohe kakama nematamonaka, hinaka yama nafi toha, me fanawiri toharawa, Sotoma ka me nafi toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Manakobote Ketoraome me mowa ni nowati ya Abarao kame hawi enoki ya Sotoma ka towisawa kakehimatamonaka Abarao kobo nebonaha, Safe ka faha witi ya. Yama ini one amake haro, Towisawa ka Faha Witi tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Meokiseteki Abarao kobo, nematamonaka, Sare ka towisawa tohahari, Teoso me nafi ka Hiti Teoso tohehi ka sasetoti tohahari. Meokiseteki bao kakama, fi kakama nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Meokiseteki Abarao nofehimatamonaka. Teoso Abarao kakatomehibona ati nematamonaka, ati e nari ahi: \"Teoso me nafi ka hiti Teoso tohe Abarao kakatomehibonaka. Efe Teoso wami nafi hiri, neme hiri, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Teoso me nafi ka hiti Teoso tohe e kahiyarahi, ehene tikita tiwa yawa mowa tinaha tiwa\". Faya yama Abarao hekama kote bite tesimo tohaha ta nematamonaka Meokiseteki ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Manakobote Sotoma ka towisawa Abarao hiyarematamonaka. \"Hine ya me aboni ta tinahabone tike owa ni ya. Me ka yama ta tohahaboneke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abarao ati hinahabihematamonaka. \"Omano yana nabone oke Teoso hiwahabonehe, Teoso me nafi ka hiti tohahari, neme hiri, wami nafi hiri, nemata. ");
INSERT INTO jaa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Teoso ino oti oke, owati mitehibonaha, owati e naro ahi: Tika yama onofa okere. Makari ake oharia onofarihi, sataya mati oharia onofarihi oke. Tiwati yana riyahi, tiwati e na tiwa ahi: 'Owehene Abarao honehimari amaka', tiriyahi. ");
INSERT INTO jaa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Oko yamabone onofa okere, fara owa. Hine ya oko saotato yamata me kabaharake. Ane, Esiko, Manere me na oko tataba me tohaha me ta yama kote me ihahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Manakobote Abarao yama awehimatamonaka Teoso hinamoaro. Teoso Abarao hiyarematamonaka. \"Abarao watorima tinahi. Tiwa owakatomabone oke, yama yofina wataribone karo tiwa ni ya. Tika yama amosaba ta onahabana oke\". ");
INSERT INTO jaa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abarao Teoso ati mite ati yana nematamonaka. \"Teoso oko Hiti, yama amosa ta tini ya owa ni ya yayai orahabone oke, okatao watare karo. Oko nanarifa Eriese tohe Tamasiko ka tohe oko yama nafi ihawatebonaka ohabi ya, okatao watare karo. ");
INSERT INTO jaa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Okataoba ta titera ama tike. Makoni owa nanarifa me ka owa otaboro ya yanatehi oko yama ihawatehibonaka\". ");
INSERT INTO jaa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Faya Teoso ati yana namatasehimatamonaka. \"Tiwa nanarifa Eriese tohe tika yama ihawaterebonaka. Tikatao ta tika yama ihawebonaka\". ");
INSERT INTO jaa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Faya Teoso Abarao towakamematamonaka yama winakosi ya yobe beheri ya. \"Neme tiwahi. Neme ka amowa me tomi kani tiwatorabone tike. Amowa me tomi kani nima tika noti me tomi kani tehaboneke, tamabote me tohaha mati\". ");
INSERT INTO jaa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Faya Abarao Teoso ati mite ati hinofematamonaka. Makoni Teoso ka me ka owa hinihematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Teoso ati yana namatasehimatamonaka. \"Teoso ama oke. Yeofa ama oke. Owati ihi tikehamaro ama tike, Babironia ya yana tina tiwa, sitati O ya. Tiwa owakakehamaro ama oke ahi, afa wami ta onahabone ona owa tika wamibonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","\"Yeofa oko Teoso, himata nima oko yama wato naba ama ori, afa wami ohahaba owa?\" Abarao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","\"Bowi fana tekama, kabirito tekama, ofeya tekama, tinahabone tike, me ka ano terei na mati. Monowi toha, okoko toha, me naboneke\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Faya Abarao bani mera towakamehimatamonaka Teoso ni ya. Bani mera waka ne me bobi hinehemetemoneke. Me beheri one ha ya toha, me beheri one ha ya toha nemetemoneke. Bani biti me ta mera bobi rematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Faya boko kisarawehemetemoneke bani mera kabarawabonehe. Faya Abarao e hiniharawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Yama sokirisi ya Abarao nokobisa koro hikane amo ni yokana tohehimatamonaka. Hibati ya kakomekabote nematamonaka. Kakakome ihi tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Faya Teoso ati yana nematamonaka. \"Abarao yama tiwatohabone tike haro. Tika noti me winatehaboneke bara me tabori ya. Ano 400 tohaha ya yama hiyara me karimaboneke bara me ihi, bara me ka yama aahi me toha mati. ");
INSERT INTO jaa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Manakobisa yama hiyara oyosebone oke bara me ni ya fahi. Faya tika noti me yana tonahaba me amake, me winamarabone mati bara me tabori ya, bara me ka yama aahi me tohamara mati. Me honahaba me amake, yama manakone fotaha me kakama mati. ");
INSERT INTO jaa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ha tiwa tika bote tohi amosaba ama tike. Tika ahabi amosa naba ama tike. Tiwa me kamohaba ama tike. Faya iti me ya titababone tike e abohi taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tika noti me ka noti me kamatehaba me amake ahi. Amo me oyosemarabone oke mata. Me ka yama hiyara kitamisi ya mata ya faya me okatomatehabone oke fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Faya yama sokihemetemoneke fahi. Hibati ya yifo witi tasi tona, yifo nakasiri wiye tasi tona, nemetemoneke. Yifo hasawiri kimisemetemoneke yifo nakasiri wiye ya. Yifo witi ya yifo nakosiri wiye famaha yaka nemetemoneke bani me beheri baikani ya. ");
INSERT INTO jaa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Afa yama ya Teoso ya Abarao me famaha me abe nofatibone ka yama me hiri nemetemoneke, Teoso ati ehene. Ati e nematamonaka ahi: \"Abarao afa wami ta otehabana oke tika noti me ni ya. Owati tohawahaba wataraba ama oke. Me ka wami yowatehaba amake Esito ya. Yowa, tehaba amake Eofarati ka faha ya. ");
INSERT INTO jaa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Me nafi ka wami tika noti me ihawatehaba me amake. Ke me toha, kenisi me toha, kitimo me toha, ");
INSERT INTO jaa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heti me toha, berisi me toha, hefa me toha, ");
INSERT INTO jaa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amo me toha, kanaha me toha, kikasi me toha, sebo me toha, me na me ka wami me ihawatehaba me amake, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abarao fati Sarai tohaha kahiwaremetemoneke, Abarao biti nehibonaha. Sarai yama aahi fanawi toha kihehemetemoneke, Esito ka fanawi tohaharo. Inimetemone amake Aka. ");
INSERT INTO jaa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Yama wehe one ya Sarai ati yana nemetemoneke Abarao hiyararo. \"Teoso ati ehene okahiwa okere. Makoni oko yama aahi ahi tinahabone tike, biti ne ya biti ohehibonaha, okataobonaha\". Sarai ati amosemetemoneke Abarao ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Faya Aka ta nemetemoneke Abarao ni ya, Abarao ahi hinahabonehe, biti nebonaha. Fati yokana amaremetemoneke. Sarai Aka kahabani ka yama ya Abarao wine ka ano 10 tohehemetemoneke Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aka Abarao ahi hina nabati weye nemetemoneke. Nabati weye ni watoha hiti Sarai toha nofamarehemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Faya Sarai ati yana nemetemoneke, Abarao hiyararo. \"Tiwehene Aka owa nofamakere. Okahabanarake tiwa ni ya fara owa. Faya nabati weye ni watohani owa nofamakere. Teoso e ehene watoka hiyararo. Tiwehene tohi ya tiwehene toha, owehene tohi ya owehene toha na awineke. E ehene Teoso watohibonaka e fami\". ");
INSERT INTO jaa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","\"E, siba kere. Fara tika yama aahi amake, Aka. Tiyosete amake. Fara yama tinofa hiri tinahabone tike he ni ya\". Faya Aka katomi Sarai yana hinehemetemoneke. Tokomemetemoneke hasi nabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yama honara ya yaka na Teoso nanarifa kobo hinehemetemoneke, So hawi ya, faha bite iti yabori ya. ");
INSERT INTO jaa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Aate hinehemetemoneke. \"Aka Sarai ka yama aahi tihaha hibaka ya tikerini? Hibaka ya tika ribe?\" Teoso nanarifa ati nematamonaka. \"Oko hiti owa nofamara okomara oke, hasi onahabone owa\". ");
INSERT INTO jaa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Faya Teoso nanarifa hiyosemehemetemoneke. \"Tikamahi tika hiti ni ya. Fara ati nafi nima tiwehene nabone tike\". ");
INSERT INTO jaa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Teoso nanarifa ati yana namatasehimatamonaka. \"Owati ihi tika noti me tamatehaba me amake. Me tomi kanihina teraboneke, me tami karo. ");
INSERT INTO jaa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tinabati weye na tikatao watehibonaka. Ino tinawatehibonaka. Isimayeo tohehibonaka. Isimayeo ino yama kaminaka haro, Teoso e ati mite ka yama. Yama hiyara tikarima tiwati Teoso mite ka Isimayeo tohehibonaka. ");
INSERT INTO jaa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Efe tikatao yama kabani ka someto nima tehibonaka. Me nafi mowa ne ya me nafi mowa, hinehibonaka. Me one ya tabaterebonaka. Winatehibonaka yama yabo ya\". ");
INSERT INTO jaa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Faya Aka Teoso ino tonihawahemetemoneke, Teoso era awe tohehibonaha. Ati e nemetemoneke ahi: \"Teoso owa hiyarareka. Hahi owa awe owe awane? Keye amarini?\" ati naro. ");
INSERT INTO jaa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Makoni afa faha ini e te amake ahi: Hahi yati ne owa awe ka faha amake. Itate amake hawi ya. Katisi ha ya toha, Bereti ha ya toha nineke. ");
INSERT INTO jaa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aka biti watehimatamonaka, Abarao bitibonaha. Bati ino hinawatehimatamonaka, Isimayeo tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Isimayeo wate ya Abarao ka ano 86 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Manakobote Abarao ka ano 99 tohi ya Teoso hine namohimatamonaka Abarao ni ya. \"Abarao Teoso kitabote ama oke. E famatehabone eke. Fara yama onofa hiri tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","E abe nofatibone ka yama e hiri nabone eke. Tika noti me tamatehaba me amake owati ihi\". ");
INSERT INTO jaa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Faya Abarao itarisehimatamonaka iso yobati ya. Noko towarisehimatamonaka bofe ya. Teoso ati yana nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","\"E abe nofatibone ka yama e hiri ni ya yama e naboneke ahi: tika noti me yoro tokatehaba me amake, me winakanikima na mati tabora tamaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tiwini yatibone onawatahabone oke. Abarao tihamarahabone tike. Abaraao tihawahabone tike waha. Me tamaha me ka abi ino Abaraao ino kaminaka. Owati ihi tika noti me yoro tokatehaba me amake, me winakanikima na mati tabora tamaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tika noti me tamatehaba me amake owati ihi. Me one towisawa me tohatehaba me amake. ");
INSERT INTO jaa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","E abe nofatibone ka yama e hiri nineke. Ha owa oha, ha tiwa tiha, e nineke, e abe nofatibone ka yama e hiri na e, tika noti meteba me ya titaba tiwa. E abe nofatibone ka yama e naboneke ahi: tika Teoso oha, tika noti me ka Teoso oha, otehaba ama oke. ");
INSERT INTO jaa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanaha ka wami ya tiwina bare ama tike mata. Afa wami ta onahabone oke tiwa ni ya, tika noti me toha na me ni ya. Kanaha nafi tika noti me tabori tohatehaba amake owati ihi. Me ka Teoso ohatehaba ama oke\". ");
INSERT INTO jaa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Teoso hiyarasa nematamonaka. \"Abaraao ha tiwa e abe nofatibone ka yama yama hikamina hiri ni fawa titerabone tike. Tika noti me toha, tehaba me amake, e abe nofatibone ka yama yama hikamina hiri ni me fawa ra mati, fara yama tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","E abe nofatibone ka yama e hiri nineke, ha owa oha, ha tiwa tiha, tika noti meteba me toha, na e. E abe nofatibone ka yama ati e naboneke ahi: te makiti nafi me sowiri atari wisi naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Te sowiri ataro kote wisi ni ya e abe nofatibone ka yama me watohaba me amake, bara mati. ");
INSERT INTO jaa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Te ka matehe sowiri atari kote wisi ni yana tonahaboneke hibayata ya. Matehe makiti ka yama wehe owito ni ya me sowiri atari kote wisi naboneke. Te ka matehe toha, te ka yama aahi me ka matehe toha, naboneke me wataha mati te ni ya. Bara me ka yama aahi me toha, naboneke, me te kanika mati. ");
INSERT INTO jaa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Matehe nafi sowiri atari kote wisi naboneke, me hasi naba me watara mati. Bara te abono me awi ya e abe nofatibone ka yama me watohaba me amake, e abe nofatibone ka yama ahabiba watararo fara yama tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Me sowiri atari kote wisi ra me winaraboneke te ni ya, e abe nofatibone ka yama me nofari karo\". ");
INSERT INTO jaa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Faya Teoso Abaraao hiyarasa nematamonaka. \"Tika yibote ini Sarai tohamaraboneke. Ini Sara tinihaboneke waha. ");
INSERT INTO jaa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Oyahabone oke he ni ya. Owati ihi kahiwaboneke, tikataobonaha. Onofi ka hinaka noti me tamatehaba me amake, me yoro tokana mati, me winakanikima na mati tabora tamaha ya. Hinaka noti me one towisawa me tohatehaba me amake\". ");
INSERT INTO jaa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Faya Abaraao iso yobati ya itarisehimatamonaka. Noko towarisehimatamonaka bofe ya. Haha ni yana tone ati boti e nematamonaka ahi: \"E ka owa ka ano 100 tohaha kahiweba ama? Sara ka ano 90 tohaha kahiwaba ama?\" ");
INSERT INTO jaa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Faya Abaraao ati yana nematamonaka, Teoso aate nari. \"Tiyahabone tike Isimayeo ni ya. Oko yama nafi Isimayeo ihehibonaka ohabi ya\". ");
INSERT INTO jaa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","\"Isimayeo okomina okere. Owati e nara oke ahi: Sara kahiwabone onahara oke, tikataobonaha. Ino tinawatehibanaka, Isaki tohahari. Tihabi ya e abe nofatibone ka yama tohasa naboneke, ota abe nofatibone ka yama tohaharo, Isaki ya ota famaha ota. Afa e abe nofatibone ka yama ahabateraboneke. Hiri onamaboneke tika noti me ya otaba owa. ");
INSERT INTO jaa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tiwati omita onahara oke, Isimayeo tikamina tiwati. Oyahabone oke he ni ya. Biti me tama, hinaka noti me tama, tehaba me amake. Me kitatehaba me amake. Me one towisawa me tohatehaba me amake, me 12 na mati. ");
INSERT INTO jaa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Isaki ta ya ota famahabone otake ota abe nofatibone ka yama ota hiri na ota. Efe Sara nawataboneke afa yama ya ano one ya\". ");
INSERT INTO jaa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Faya Abaraao hiyari Teoso hawa tohe tokomematamonaka neme ya, Abaraao kakosahari. ");
INSERT INTO jaa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Afa yama wehe ya Teoso yama hikamina Abaraao hiri nematamonaka. Biti Isimayeo sowiri ataro kote wisi nakosematamonaka. Me makiti nafi toha, nemetemoneke, taboro ka mati. Hinaka yama aahi me toha, nemetemoneke me watehemete mati taboro ya. Hinaka yama aahi me one toha nemetemoneke, me hikanika mati bara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abaraao sowiri ataro kote wisi nakose ka ano 99 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Biti Isimayeo tohehi ka ano 13 nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Fara yama wehe oharia ya me sowiri atari kote wisi nemetemoneke, me fami. ");
INSERT INTO jaa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abaraao ka yama aahi me nafi toha nemetemoneke, me watehemete mati taboro ya. Hinaka yama aahi me one toha nemetemoneke, me hikanika mati bara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yama wehe one ya Teoso hiwa namohimatamonaka Abaraao ni ya, Manere ka awa ehebote boti ya. Abaraao itarimatamonaka hinaka yobe kabirito kone kowi tohehi nokobirine ya. Bahi nokorise hiwene kitehimatamonaka kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Noko tokomise bara me terei na mera awehimatamonaka, me nahoha mati he nokosi ya. Mera awe fito towitimatamonaka, mera kobo nebonaha. Iso witi ya itarise noko towarisehimatamonaka bofe ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ati yana nematamonaka. \"Oko hiti mati, owa te nofi ya oko yobe te fiya karahabone teke. Owa te yaka nabone onahara oke. ");
INSERT INTO jaa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Owati ihi faha me kakamaboneke, te teme te soko nibone karo. Faya te hasi nabone teke ahi awa bofe ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yamata isi ni owakama onahabone oke, te kababonehe, te kitibone karo hawi ya. Owa te yaka na yayai oke. Makoni tera okasomahabone onahara oke\". \"E, tiwati amosake\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Faya Abaraao tokomibote nematamonaka yobe toro ya. Sara hiyarematamonaka. \"Tikitahi. Tiriko tiyabahi, kiro 10 naro. Bao hiri tibeya\". ");
INSERT INTO jaa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Manakobote tokomakehimatamonaka bowi me tabori ya. Bowi biti iti bowi biti towakamehimatamonaka he nanarifa ni ya. Bowi nabowe ya bowi hawa tonihakabote nebona hinehimatamonaka, me tafebonehe. ");
INSERT INTO jaa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Faya Abaraao yamata ta nematamonaka me yaka na me ni ya, awa bofe ya. Reiti imakia toha, reiti aboni toha, bowi ime toha nematamonaka. Fare Abaraao yamata sawa nematamonaka, me tafebonehe. Me tafa wehimatamonaka ayata ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Faya Abaraao me aate nemetemoneke. \"Tika yibote Sara tohaha e ri?\" \"Tohaharake yobe toro ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Me ka owa ati yana nematamonaka. \"Ano one ya tiwa yaka onamabone oke. Afa yama ya tika yibote Sara tohaha biti nehibonaka\". Sara warehemetemoneke yobe nokobirine ya, bare bari ya, he ati kamitaro. ");
INSERT INTO jaa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abaraao ya Sara me famaha bote me tohehemetemoneke. Sara ka ano fiya tonehemetemoneke, biti nehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Makoni ati boti haha nemetemoneke. \"Okatao nehimanaha yayai onehene ama oke. Okatao watareba awaka, oko yibote ya ota famaha bote me ota toha ota\", ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Faya Teoso ati yana nematamonaka, Abaraao aate nari. \"Abaraao himataba Sara haha nineri? Himataba ati e nineri ahi, kahiwarabone ati naro, bote tohi karo? ");
INSERT INTO jaa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yama nihina ra nahaba ama Teoso ni ya? Fara owati nima yama naboneke, e naro ahi: ano one ya tiwa yaka onamabone oke. Afa yama ya Sara biti nawataboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara bare ati mita kori kasehemetemoneke. Faya hine kamini nofaremetemoneke. \"Haha okere\", ati nemetemoneke. \"Keye hiri tine tike\", Teoso ati nematamonaka. \"Haha tinahara tike\". ");
INSERT INTO jaa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Manakobisa me yaka na me yana tonemetemoneke. Sotoma me awahabone me ati na me tokehemetemoneke. Atami ya me tokomisahabone me ati nemetemoneke Sotoma me awahabone mati yama yabo ya. Abaraao me ya tabehimatamonaka, hawi yofi kanehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Faya Teoso ati boti e nematamonaka ahi: \"Yama okehemorabana oke Abaraao ni ya, hiri onahabana. ");
INSERT INTO jaa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Hinaka noti me tamatehaba me amake. Me kitatehaba me amake, me wini tamaha mati. Ehene oyahatebone oke me yoro tokana me ni ya, me wina mati tabora nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Owasiareka, biti mera yosehibonaha, owati nima me ihi nabone mati, me ihi amosa mati. Hinaka noti me toha, tehaboneke. Owati me tokatabi ya yama okomina nafi hiri onabone oke Abaraao ni ya, owati tohawarabone ona owa\". ");
INSERT INTO jaa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Faya Teoso ati yana nematamonaka Abaraao hiyarari. \"Sotoma ya Komoha famaha ya me wina me ihi hiyaramoneke mata ya. ");
INSERT INTO jaa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Me tamine omita okisabone oke, me ihi owatoabone owa. Me ihi hiyara ni ya na, me ihi hiyara watari ya watarihi, naboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Manakobote me yaka na me one famaha me towakemetemoneke, me towakamakiabone mati Sotoma ya. Abaraao ya Teoso me famaha me ta me teme nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abaraao tokomakehimatamonaka ayata ya Teoso beheri ya. Teoso aate nematamonaka. \"Me ihi amosa me ahababa me ama tiwehene, me ihi hiyara me ya me tabaha mati? ");
INSERT INTO jaa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Me ihi amosa 50 me tohaha me ni ya sitati tinahabihaba ama ti? Tiwati somawamaribana, me ihi amosa 50 me tohaha me tinofa tiwa? ");
INSERT INTO jaa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Me ihi amosa me tinahabihaba ama ti, me ihi hiyara me ya me tabaha mati? Me ihi amosa me one nima me kere, me ihi hiyara watara mati. Tiwehene e rabone tike fahi. Me nafi ihi manakone tiwahabone tike. Me ihi amosa me tinahabihi ya yama hiyara hiri tinahabone tike. Yama hiyara hiri tiriyahi\", Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","\"Sotoma ya me ihi amosa 50 me toha me owasi ya owati somawamabone oke sitati nafi hasi oniha owa, afa me ihi\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abaraao ati yana namatasehimatamonaka. \"Obo bayiha owa titohirabone tike, tiwa hiyari fawa ora owa, onafira owa, e oha owa. Teoso ama tike ha tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Me ihi amosa 50 me toha me watari ya, 45 me toha me ni ya, sitati tinahabihaba ama ti, me siko na me watara me ihi?\" Faya Teoso ati yana namatasehimatamonaka. \"45 me toha me owasi ya sitati onahabiharabone oke\". ");
INSERT INTO jaa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abaraao Teoso aate tasehimatamonaka. \"Me ihi amosa 40 me toha ni ya sitati tinahabihaba ama ti?\" \"Afa 40 me tohaha me onofa me ihi sitati onahabiharabone oke\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","\"Teoso tiyawariyahi owati fawa ra owehene. Me ihi amosa 30 me toha ni ya sitati tinahabihaba ama ti?\" \"Me ihi amosa 30 me toha ni ya, owati somawamabone oke sitati ka me ni ya\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abaraao ati fawa rematamonaka. \"Obo bayiha owa tikakoriyahi. Me ihi amosa 20 me toha ni ya sitati tinahabihaba ama ti?\" \"Afa 20 me tohaha me onofa me ihi sitati onahabiharabone oke\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Faya Abaraao ati yana ni oharimatasematamonaka fahi. \"Teoso tiyawariyahi owehene. Owati yana namakiabone oharike hasi naro. Me ihi amosa 10 me toha ni ya sitati tinahabihaba ama ti?\" \"Afa me 10 tohaha me ihi sitati onahabiharabone oke\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Faya Abaraao hiyari Teoso ahabe tokomematamonaka. Abaraao tokomabisematamonaka fare taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yama sokirisi ya Teoso nanarifa me fama me kobo kanemetemoneke Sotoma ya. Ro itarimatamonaka sitati ka nokobi wani yabori ya. Teoso nanarifa mera awe yana ne tokehimatamonaka mera ha nebonaha. Iso witi ya itarise noko towarisehimatamonaka bofe ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Faya mera hiyarematamonaka. \"Oko hiti mati, tera onarifahabone oke. Tera ha onahabone onahara oke, te kasawiabone te otaboro ya. Te teme te soko ni ya te amo kanabone teke fahi. Yama wamini ya te bosa kani ya te towakaba teke fara te towakibone ka tabora ya\". Me ati yana nemetemoneke. \"Ota amo karabone otake titaboro ya. Ota amo kanabone otake sitati ka yama kori ya\". ");
INSERT INTO jaa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ro ati fawa re ka me ati amosemetemoneke fahi. Faya Ro ya me tabaha me tokomakehemetemoneke Ro taboro ya. Ro ati ehene yamata me wasihemetemoneke, yobe ka mati. Bao me hiri, nemetemoneke fehemeto kiharari, Ro ati ehene. Faya me yaka kana me tafehemetemoneke yama soki ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Me amo kari ya mata Sotoma ka me makitiri nafi kakehemetemoneke, bote me ya yetene me kataba mati. Ro ka yobe me karafemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ro me ha nemetemoneke. \"Me makiti famaha me e ri, me towakiyoma mati tika yobe ya yama soki ya? Me tekiyomamahi ota ni ya, me ota ahi nabone mati\". ");
INSERT INTO jaa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Ro kiyomamematamonaka mera hiyarebonaha. Nowati ka nokobi boko kanehimatamonaka kita ya. \"Oko one mati, tera aate okibone. Yama hiyara e na te hiri riyahi. ");
INSERT INTO jaa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Owati te mitahi. Okoto famarawake, atona tohasa narawaro. Me owakiyomamahabana oke te ni ya. Faya yama te nofa te hiri nabone teke famarawa ni ya. Me makiti famaha ta te ahi rabone teke. Oko yobe ya me kasawi ka me okayawa oke\". ");
INSERT INTO jaa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ro ati me nofaremetemoneke. \"Tikamahi. Otara bari tikariyahi\". Me abe hiyaremetemoneke. \"Efe bare tohe era yosehibona ati naka\". Faya Ro nokosi ya me nahomake Ro me hiyaratasemetemoneke. \"Me fama me ota ahi nabone ota ati nibaha ha tiwa ta tiwa ota katomabone otake waha mata ya\", me ati nemetemoneke. Faya Sotoma ka Ro me fito kanehemetemoneke. Nokobi me itibasahabone nokobi ya me bori tonamemetemoneke ayata ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Manakobisa haha me yaka kana Ro me totimakehemetemoneke. Faya nokobi me boko kanamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Manakobisa me famaha me ati ihi me nahokosa me noki awamaremetemoneke hibati ya, bote me ya yetene me tabaha mati, me nafi. Makoni nokobi wani ka yama me wasiremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Faya me yaka kana Ro me hiyaremetemoneke. \"Te one me na me awine ahi Sotoma ya? Me hima tinahi, tikatao mati, tikotorawaha, tika koma mati, te one me nafi, te tokomabone te. Te nahoriyahi haha sitati ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Sitati ota nahabihabone otake. Sitati ka me tamine Teoso mitahareka, me ihi hiyara mati kasiro ya. Makoni otara yosekiareka, Sotoma ota nahabihabone ota\". ");
INSERT INTO jaa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ro tokomakehimatamonaka hinaka koma me ni ya, mera hiyarebonaha. \"Te ka yama te hawa tonihahi hibati ya. Te tokomahi. Teoso sitati nahabihibonaka\". Ro ati me nofaremetemoneke. Siwa ne atimona me hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Faya yama soki enoki ya Ro me kasiro kanehemetemoneke, Teoso nanarifa mati. \"Tera te hawa tonihakabote nahi hibati ya. Tika yibote toha, tikoto toharawa na tekamarawahi. Te ahabariyahi sitati ahabi ya\". ");
INSERT INTO jaa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ro nawahe ka mano me wara hinehimatamonaka, Teoso nanarifa mati. Ro fati toha, bite toharawa, na mani me wara hirawemetemoneke. Me me towakamehemetemoneke sitati witi ya, Teoso Ro aawawa ne karo. ");
INSERT INTO jaa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Me ka owa Ro hiyarematamonaka. \"Kana tiwahahi, hasi tinabone tiwa. Tinokowahamariyahi tinowati ya. Ma tinamarabone tike faha witi ya. Tikamisahi yati nemeha si tona mese ya. Tihabariyahi\". ");
INSERT INTO jaa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","\"Oko hiti tiwehene e rima nahi owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Owa hasi tinihara tike, owa aawawa tina tiwa. Tokomi onofa okere yati nemeha si toni ka yama ya, yama yabo karo. Kobo ni owatorabone oke. Kobo ori ya ohababone oke. ");
INSERT INTO jaa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Sitati bite tiwara tiwa awine ti yaboraro? Sitati bite ya okabone oke, hasi onahabone owa. Sitati bite amake, nafiraro\". ");
INSERT INTO jaa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Teoso nanarifa ati yana nematamonaka. \"Tiwati amosake owa ni ya. Afa sitati onahabiharabone oke. ");
INSERT INTO jaa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tikahi fahi hibati ya. Kobo tini ya sitati one onahabihabone oke. Owa bao oke\". Sitati bitemone Ro hini ka ini me hinawatehemetemoneke Soa toaharo, sitati bite ini weye naro. ");
INSERT INTO jaa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bahi kamaki ya Ro kobo nematamonaka Soa ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kobo ne faya Teoso ati ehene yama hiri ni ya yati hatiha famaha kakehemetemoneke neme ya, Sotoma ya Komoha famaha ya. Faha kaki nima yama kaki nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Sitati famaha Teoso nahabimatamonaka. Faha witi ka yama nafi nahabi nematamonaka, me winaha me kihi. Afa wami ka awa nafi nahabi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Faya Ro fati yama awahabone tonokowahama tohiyemetemoneke, yati saha hiri ni tohaha tohawaharo. ");
INSERT INTO jaa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Faya yama sirimaki ya Abaraao bosa ne tokehimatamonaka fare Teoso hiyare ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Faya Sotoma ya Komoha famaha tohi ka yama ya yama kakatome yama hasawiri fotaha awehimatamonaka kimisaro. Faha witi ka yama toha nemetemoneke. Yama nafiha hime tona awi nima yama awi nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Fa witi ka sitati ahabi e nemetemoneke ahi, Teoso hinahabiharo. Abaraao ta nofehimatamonaka. Ro hasi, nematamonaka Teoso ati ehene, wine ka sitati ahabi ya Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ro watohi wini nofarematamonaka Soa ya. Faya tokomisehimatamonaka yati nemeha si toni ka yama ya, bite famarawa ya tabahari. Me terei na me winehemetemoneke yati hoti ya. ");
INSERT INTO jaa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yama wehe one ya Ro bite one ati yana nemetemoneke, hinakasima hiyararo. \"E ka abi botoka. Me makiti watakere ahi, e ka yibote meba mati. Makoni e fanaraba e awineke, e kahiwaba e. Me one nima e naba yama nihinakere e ni ya, yama nafi ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hima, e ka abi e nafawahi fi ya, hanohibana. Manakobote he ya e tabahaba eke, e kahiwabone e, biti meba mati\". ");
INSERT INTO jaa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Afa yama soki ya me ka abi me nafawemetemoneke fi ya. Bite taiti he ya famehemetemoneke yama soki ya. Hano ka yama watorematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yama wehe one ya ati yana nemetemoneke hinakasima hiyararo. \"Ota famaha otake yama soki ya. E nafawatasehibanaka yama soki ya, hanohibonaha tasa. Faya te famibanake. E ehene e ni ya e kahiwabone eke, biti mebone mati. Biti me watari ya yama hiyaraboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Afa yama soki ya me hinafawatasehimatamonaka fi ya. He ya bite yoto ka famehemetemoneke. Hano ka yama watorematamonaka tasa. ");
INSERT INTO jaa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Makoni Ro bite famarawa nabati weye nikimarawemetemoneke fare me ka abi ehene. ");
INSERT INTO jaa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bite taiti biti ihehimatamonaka. Ino hinawatematamonaka Moabi tohahari. Moabi ka me ka itimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Bite yoto ka biti iha nematamonaka. Ino hinawatehimatamonaka Beami tohahari. Amo ka me ka itimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Manakobisa Abaraao Manere kakosehimatamonaka. Tokehimatamonaka Kanaha kote ya, bahi kakamaki beheri ka yama ya, yama honara ini Nekefi tohaha ya. Katisi ya So famaha basa kani ya winehimatamonaka, sitati Sera tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Wine Sara hinakasimamone ati nematamonaka Sera ka me ni ya. Abimereki Sera ka towisawa tohe Sara ini hiri nematamonaka, me hekamahabonehe hinaka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Faya yama soki ya Teoso watari awehimatamonaka. Teoso ati yana nematamonaka watari ya. \"Tiwati ihi fanawi me hekama maki naka. Makoni tihababone tike owati ihi, yama hiyara hiri tini karo\". ");
INSERT INTO jaa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimereki Sara ahi namatare ka ati yana nematamonaka. \"Teoso yama hiyara hiri okere. Owa tinahabihibana? Ota nafi ahabibana tiwati ihi? ");
INSERT INTO jaa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Fare Abaraao ati amaka, hinakasimamone ati nari. Hinakasimamone ati, narake. Yama owatora ini hiri onaharake, owehene hiyara watara owa\". ");
INSERT INTO jaa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Teoso ati yana tasehimatamonaka wata ya. \"Tiwa owato oke, yama tiwatora tiwa. Makoni tiwa bari okanara oke, boyo tirahabonehe, tiwehene hiyara wataribone karo owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Fanawi ta tinamabone tike hibati ya maki ni ya. Faya owa aate nebonaka, tihabarabone ati nari. Owati kakamina amaka. Fanawi ta tinamari ya tihababone tike. Te one me ahaba nabisaboneke. Keye amakere\". ");
INSERT INTO jaa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yama wamini ya Abimereki bosa nematamonaka. He nanarifa mera ha ne yama kaminematamonaka me ni ya. Faya me kori kasehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Manakobisa Abaraao ha nematamonaka, hihiyarebonaha. \"Abaraao tiwehene hiyakere. Tiwa ni ya owehene hiyara watara Teoso owa kakona amaka, yama hiyara nafiha hiri oni ya. Yama e na e hiri tera e amake e ka owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Himataba tiwehene e na hiri tina ama tiri owa ni ya?\" ");
INSERT INTO jaa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abaraao ati yana nematamonaka. \"Te taboro ka Teoso me nofaramone ona ama oke. Owa te nabowi ya oko yibote te itiwahabone ona ama oke. ");
INSERT INTO jaa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Keye hiri okere, Sara okomina owa. Okasima amake, okobi bite tohaharo. Okomi bite amara otihamaro amake. ");
INSERT INTO jaa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Teoso ati ehene okobi me owakanakosamaro ama oke, bara me tabori ya yaka onahabone owa, ati ehene. Faya Sara ohiyaramaro ama oke. 'Sara fara e yaka ni ka tabora ya ayomona owa tinahabone tike owa tinofi ya', onamaro ama oke, Sara ohiyara owa\". ");
INSERT INTO jaa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Manakobote Abimereki Sara ta tonamematamonaka Abaraao ni ya. Faya ofeya mera ta, bowi mera ta, yama aahi mera ta, yama aahi fanawi ta narawa nematamonaka Abaraao ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ati yana nematamonaka. \"Abaraao oko wami tiwahi. Tiwinahi fara yama tinofa ya\". ");
INSERT INTO jaa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sara hiyara, nematamonaka ati e nari ahi: \"Barata ka kiro 15 tohaha ta okibone ayo ni ya, me nafi tiwa watobone karo, tiwehene hiyara watara tiwa. Oko yobe ya tisawiha yama hiyara hiri tirahara tike\". ");
INSERT INTO jaa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimereki ka yobe ya Abaraao fati Sara tohaha sawi ya hinaka yobe ka fanawi nafi kahiwi watomarawaremetemoneke Teoso ati ehene. Faya Abaraao Teoso aate nematamonaka, Abimereki kasomebonaha. Teoso hikasomehimatamonaka. Fati hikasoma, hinaka yama aahi fanawi mera kasomarawa, nematamonaka, me kahiwamabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Teoso yahehimatamonaka Sara ni ya, fara yama hikaminaharo nima ehene nari. ");
INSERT INTO jaa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nabati weye na Abaraao biti nawatemetemoneke, Abaraao bote tohahari. Biti watehimatamonaka fara yama Teoso hikaminaharo ya. ");
INSERT INTO jaa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Faya Abaraao ino hinawatehimatamonaka, ino Isaki tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaki amo ni owito ne ya sowiri ataro kote Abaraao wisi hisehimatamonaka, fare Teoso atiri nima ehene nari. ");
INSERT INTO jaa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isaki wate ya Abaraao ka ano 100 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Faya Sara ati yana nemetemoneke. \"Teoso yama hiri hina ihi haha onahara oke. Hiyara me miti ya me haha nabisaboneke fara owa nima\". ");
INSERT INTO jaa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hiyarasa nemetemoneke. \"Abaraao me hiyaraba me ati watararoke, Sara inamatewe nafawabone me ati na mati. Bote tohe biti onawatahareka\". ");
INSERT INTO jaa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Inamatewe yane yowa fawamarehimatamonaka. Yowa fawamare ka amo ni ya Abaraao marina ehebote hiri nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Yama we one ya Abaraao biti Isimayeo tohe Sara biti Isaki tohe haha kanehimatamonaka. Esito ka fanawi Aka tohaha bitimatamona amaka, Isimayeo. ");
INSERT INTO jaa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara mera awa ati yana nemetemoneke, Abaraao hiyararo. \"Haha yama aahi fanawi toha tiyosemahi, biti ya famaharo. Tihabi ya okatao ya famarebonaka, tika yama me ihawahaba mati. Okatao ta tika yama ihehibonaka ohariari\". ");
INSERT INTO jaa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abaraao kokoriri nematamonaka, Isimayeo Abaraao biti tohe kari bisa. ");
INSERT INTO jaa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Faya Teoso ati yana nematamonaka, Abaraao hiyarari. \"Abaraao inamatewe tikayawarabone tike. Tika yama aahi fanawi toha tikayawarihi tinahabone tike. Fara Sara ati nima tiwehene nabone tike. Tika noti me Isaki ka noti me tohahaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Yama aahi fanawi toha biti tikatao amaka bisa. Makoni hinaka noti me tamatehaba me amake, me kita na mati owati ihi\". ");
INSERT INTO jaa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yama wamini ya Abaraao bosa nematamonaka yama sirimaki ya. Aka ka yamatabone ta, faha ta, nematamonaka hinaka fahabonehe, kawitaro. Weyeye hiniha hiyosemehemetemoneke. Aka tokoma yaka nemetemoneke Beseba ka yama honara ya, tokiba ka yama watoraro. ");
INSERT INTO jaa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yama wiye ka faha ahabi ya awa bite bofe ya Aka inamatewe nawita hekanakosematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tokaha 100 metoro yama tohi ya itehemetemoneke. Ati boti e nemetemoneke ahi: \"Yama nawahaboneke owa ni ya, okatao ahabi owi ya\", ati boti ati nemetemoneke. Itaha ni ya inamatewe ohi ni yana nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Faya inamatewe ohi ni Teoso mitehimatamonaka. Neme ya Teoso nanarifa Aka ha nematamonaka. \"Aka himataba kokoriri tine tiri? Kori tikasarabone tike. Fare inamatewe ite ya ohi ni Teoso himitareka. ");
INSERT INTO jaa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hima. Inamatewe mano wara tinahi. Tinawamisaho. Hinaka noti me tamatehaba me amake, me kita na mati, owati ihi\". ");
INSERT INTO jaa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Faya Aka noki awehemetemoneke Teoso ati ehene. Faha hoti awehemetemoneke. Toka faha wiye mo kanihemetemoneke. Isimayeo nafawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Manakobisa inamatewe yanehimatamonaka, Teoso hekatomahari. Isimayeo wiwina tohehimatamonaka Bara ka yama honara ya. Wati sa ni watohimatamonaka fahi kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Fatibone mati hiwasiemetemoneke, Esito ka fanawi one tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Afa yama tohi ya Abimereki tokomakehimatamonaka Abaraao hiyarebonaha. Hinaka saotato me yoyose Fiko tohehi ya famehimatamonaka. Abimereki ati yana nematamonaka, Abaraao hiyarari. \"Fara yama hiri tina amosake, Teoso ya te fami karo. ");
INSERT INTO jaa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Makoni haha tabora ya tiwati omitabone oke. Tiwehenebone tikaminahabone tike Teoso nokosi ya. Owa tikeyeterabone tinahabone tike. Okatao me tikeyerihi, okanoti me tikeyerihi titehabone tike. Owatiba watatera ama oke, tiwa okeyeha owa. Tiyahatehabone tike ota ni ya, ota winaha ota ahi\". ");
INSERT INTO jaa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","\"Yama tikamina yokana hiri onahabone oke. Owati Teoso mitaka\", Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Faya Abaraao Abimereki nanarifa me ihimone hora kanehimatamonaka Abimereki ni ya. Abaraao me ka faha hoti one oharia me ihawahamone Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","\"Yama omitatera amake haro. Yama owatotera amake. Me ihi tikaminatera ama tike owa ni ya. Me ini owato okere, me ihi e na mati\", Abimereki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Faya Abaraao ofeya me toha, bowi me toha na mera ta nematamonaka Abimereki ni ya. Me abe nofatibone ka yama me hiri nemetemoneke, me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ofeya biti me seti na mera Abaraao tonihawawitimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Faya Abimereki aate hinehimatamonaka. \"Himataba ofeya biti me seti na me tinihawahawitia tiwa awine tiri?\" ");
INSERT INTO jaa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","\"Tiwa owakawahabone onahara oke ofeya biti me seti na me ya. Ofeya biti me wara tini ya tiwati e nabone tike ahi: afa faha hoti wi onahamone tinahabone tike, ha owa\". ");
INSERT INTO jaa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Makoni afa tabora Beseba tohehemetemoneke, me abe nofatibone ka yama ini weye naro, me hiri hinaharo, me famaha mati, Teoso nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Manakobote Beseba ya me abe nofatibone ka yama hiri ni me ahabi ya me towakamemetemoneke Firisia ya, Abimereki ya Fiko me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abaraao awa oharia koro nematamonaka Beseba ya. Afa tabora ya Teoso ha nematamonaka, Teoso fare tohe tohatehari. ");
INSERT INTO jaa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abaraao wini toyabomatamonaka Firisia ya. ");
INSERT INTO jaa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ano one ya Teoso Abaraao totomi nematamonaka. \"Abaraao\", Teoso ati nematamonaka. \"Oha oke ahi\", Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","\"Tikatao ohari tinofe Isaki tohe tekamabone tike Moria ka wami ya. Yati nemeha si tonaha onamoabone oke, te towakimisibone karo fahi. Te towakimisi ya yati mese ya te yoro ni ya tikatao tinabowabone tike. Sari tikanebonaka, ta tinehibonaha owa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Faya yama wamini ya Abaraao bosa ne hinaka someto enoki ya sera kanawiti hawa tohehimatamonaka. Yifo ti nematamonaka, Isaki yiforinebonaha. Yana tonehimatamonaka, tokehibonaha yama Teoso hikaminaha ya. Isaki sawi, he nanarifa me fama me kasawi, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Yama wehe famaha nowati ya yama Teoso hikamina awehimatamonaka, yama yabo ya. ");
INSERT INTO jaa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","He nanarifa mera yosehimatamonaka. \"Te yoro nahi ahi, someto ya te tabaha te. Yetene ya ota fama ota towakiba ahi, Teoso ota ha nabone ota. Ota kakami kerewe rabone otake\". ");
INSERT INTO jaa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abaraao yifo yabe Isaki weyeye nimatamonaka yifo ya. Yimawa iti, yama oye tama kana, nematamonaka. Faya me towakemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Me yaka kana Isaki ati yana nematamonaka. \"Abi\". \"Himata amari bese?\" \"Yifo na, yama oye na, na ofeya biti e ra, e nabowebana, e ta nebana Teoso ni ya?\" ");
INSERT INTO jaa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","\"Bese yama hasi na Teoso ta nebonaka. Ofeya biti ta nebonaka, e nabowebonaha, e ta nebonaha he ni ya\". Faya me yaka kasa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yama Teoso hikamina ya me kobo kana Abaraao tana hiri nematamonaka, yati hiri ni tohaharo. Yifo so nirimatamonaka tana mese ya. Isaki wete ne hibarimatamonaka yifo mese ya. ");
INSERT INTO jaa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Yimawa itihimatamonaka, Isaki nabowebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hinabowebona Teoso nanarifa ha ni yana nematamonaka neme ya. \"Abaraao, Abaraao\". \"Oha oke ahi\". ");
INSERT INTO jaa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","\"Awaraba tinaho. Noho tiniharayaho. Tiwa owato oke waha, Teoso ati tokatabi tinofa tiwa, tikatao ohari tikayawara tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abaraao yama kakatome kanero awehimatamonaka, warabo ewene kawasihari yama kabani taha ya. Faya Abaraao tokomake kanero iti kanero nabowe ta hinehimatamonaka Teoso ni ya, biti taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Manakobisa Abaraao yama ini nawatematamonaka. Teoso yama hasi na ta nebonaka, yama ini tohehemetemoneke, ini Abaraao hinawataharo. Makoni me ati e te me amake ahi: \"Teoso ka yati nemeha si tonaha ya yama hasi na ta nebonaka\", me ati te me amake. ");
INSERT INTO jaa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Manakobisa Teoso nanarifa ati yana namatasehimatamonaka neme ya, Abaraao ha nari. ");
INSERT INTO jaa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","\"Tiwehene amosara tike, tikatao ohari tikayawara tiwa, ta tinehibona tinahari owa ni ya. Makoni owati e nara oke ahi, Teoso oha owa: Oyahabone oke kasiro ya tiwa ni ya. Owati tohawahaba watarabone onahara oke, fara owini otiha owa. ");
INSERT INTO jaa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Tika noti me tamatehaba me amake owati ihi. Neme ka amowa me nima me naboneke, me tomi kani. Ma witi ka siki boni tomi kani nima me tomi kani naboneke. Me kakako me kitaraba me amake me ihi. ");
INSERT INTO jaa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Me ihi oyahabone oke tabora nafi ka me ni ya, owati tikatabi karo, tiwa oyoseha owa\". ");
INSERT INTO jaa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Faya Abaraao kamehimatamonaka he nanarifa me yoro na me ni ya. Me nafi tokomemetemoneke Beseba ya. Abaraao winehimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ano one ya Abaraao hiyara mitehimatamonaka, nisori Nao me tamine. Nao fati ya fame biti me owito nemetemoneke. Fati inimetemone amake Mioka. ");
INSERT INTO jaa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Taiti Osi toha, Bosi toha, Kemoweo toha, nematamonaka, Ara bati tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseti toha, Haso toha, Biota toha, Sitarafi toha, Betoweo toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Efe Betoweo Hebeka bati tohehimatamonaka. Abaraao nisori Nao tohe biti me e nemetemoneke me owito na mati, Mioka me hinawata mati. ");
INSERT INTO jaa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nao biti me one nehemetemoneke, Reoma biti mati, Nao fati one tohaharo, fati yokana amararo. Teba, Ka, Tasi, Maka, me nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara wini ka ano 120 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ahabemetemoneke sitati Heboro tohaha ya, Kanaha ya. Heboro ini one amake, Kiriati-Aba. Abaraao yawe ohi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sara kamomatare ya tokomakehimatamonaka heti mera hiyarebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","\"Bare oha owina oke te ni ya. Wami kote okanikahabone onahara oke yinero ya te ni ya, oko yibote okomoabone owa\". ");
INSERT INTO jaa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Abaraao ati heti me mitaha me ati e nemetemoneke ahi: ");
INSERT INTO jaa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Owati timita. Towisawa kitehi tihamone ota ati ke. Tika yibote tikamoabone tike ota ka tama ya. Ota ka owa tama amosa kihe ya aate tine ya tama ta nebonaka tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Faya Abaraao waremise mowi nisehimatamonaka heti me nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ati yana nematamonaka. \"Te taboro ya oko yibote okomoabone te ati ni ya Soa biti Eforo tohe te aate nabone teke, ");
INSERT INTO jaa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yati hoti ini Makabera tohaha ta nebonaha owa ni ya yinero ya. Makabera ka yati hoti tohake Eforo ka wami yowi ka yama ya. Yati hoti manakone nafi ta onahabone oke, tama okihabone owa te taboro ya\". ");
INSERT INTO jaa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efe Eforo sawihimatamonaka me ka heoniao ya, sitati ka nokobi beheri ya. Itari ati yana nematamonaka, ati kitahari, ati me himitebonaha, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","\"Abaraao tiwati onofa okere haro. Owati timita. Yati hoti beheri ka wami ta onahabone oke hinita, yati hoti kihi. Ota one owati me mitake, wami ta onahabone ona owa, hinita, tika yibote tikamoabone tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Faya Abaraao mowi nisehimatamonaka tasa heti me nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Eforo hiyarematamonaka, ati kitahari, ati me himitebonaha, me nafi. \"Owati timita. Tiwa aate one oke. Tika wami okanikahabone onahara oke yinero ya. Manakone tikamini ya manakone onahabihaboneke. Manakobisa oko yibote okomoabone oke fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","\"Owati timita\", Eforo ati nematamonaka. \"Wami manakone amake haro, barata ka kiro kowato na kote tohaharo. Manakone nafira awineke, e famaha e ni ya. Tika yibote tikamoabanake fahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abaraao ati amosematamonaka fahi. Barata ka kiro kowato na kote tohaha tomi kanehimatamonaka. Afa manakone Eforo hikaminehemetemoneke, me nafi nokosi ya. Abaraao barata tomi kanehimatamonaka me ka barata tome ya. ");
INSERT INTO jaa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Makoni Eforo ka wami kote Abaraao ihawehimatamonaka, yati hoti kihi. Awa boti toha nemetemoneke, si tonaharo afa wami ya. Makabera ka wamimetemoneke, Manere beheri karo, bahi kakamaki karo. ");
INSERT INTO jaa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abaraao wami kanike ehene me nafi hiwehimatamonaka, me sawiha mati heoniao ya, heti mati. ");
INSERT INTO jaa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Manakobisa Abaraao Sara kamohimatamonaka, Makabera ka yati hoti ya, Manere beheri ka yama ya, bahi kakamaki karo, Kanaha ya. Ini one amake haro, Heboro tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Makoni heti me ka wami kote Abaraao ihawehimatamonaka, yati hoti kihi, tamabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abaraao bote tohehimatamonaka. Hinaka yama nafi amosemetemoneke Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Yama wehe one ya he nanarifa me ka hiti ha nematamonaka. Efe Abaraao ka yama nafi kakakatoma tohehimatamonaka. \"Timano yoko tinahi ofanako bofe ya. Teoso ino titi ya yama okomina hiri tinahabone tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Okatao Isaki tohe fane ya Kanaha ka fanawi itirebonaka tiwati ihi. Kanaha ya owini ka me ka fanawi itirebonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Otaboro bote ya tikahabone tike, ota ka fanawi tiwasiabone tiwa Isaki fatibonehe. Afa yama hiri tinahabone tinahabone tike, Teoso ino titiha tiwa, tiwati Teoso mitehibonaha. Efe Teoso neme hiri, wami nafi hiri, nematamonaka\", Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","\"Fanawi owasi ya owa ya famami nofari ya himata nima owehene ribe? Tikatao owakamibana titaboro bote ya?\" Abaraao nanarifa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","\"Okatao tokomarebonaka otaboro bote ya, tiwati ihi\", Abaraao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","\"Hibati ya neme ka Teoso owa kakamemarika ahi, osawimarabone ati nari, okobi me ni ya, ota one me ni ya. Kanaha ta nebona ati nemarika okanoti me ni ya, ati tohaweba watarebona ati nari. He nanarifa yosehibonaka tiwa narifebonaha. Ati ehene okatao fatibone tiwasihabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tiwasi ya tiwa ya famami nofari ya hine na naboneke. Ota ka fanawi itireba awaka fahi. Yama hiyara wataraboneke tiwa ni ya. Tekama tirehibonaka otaboro bote ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Faya Abaraao nanarifa mano yoko tonehimatamonaka Abaraao fanako bofe ya, Abaraao yama hikamina hiri nebona ati nari, Teoso ino itihari. ");
INSERT INTO jaa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Manakobisa Abaraao ka kamero me 10 na mera weyeye nihimatamonaka yama manakone fotaha ya, Abaraao me one kakawebonaha. Tokehimatamonaka Nao taboro bote ka sitati ya, Mesobotamia ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kobo ne ya kamero mera nanahorisematamonaka me isi yobati ya faha hoti beheri ya, sitati witi ya. Bahi tokehimatamonaka. Efe bahi ya me fanawiri kakama toharawemetemoneke faha nakamarawabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Teoso ha nematamonaka, ati e nari ahi: \"Oko hiti Abaraao ka Teoso, yama owa kasawarihaba wataraboneke tiwati ihi. Afa yama wehe amake haro. Tiyahabone tike oko hiti ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Oha oke ahi faha hoti wai yabori ya. Afa faha hoti ya sitati ka atonarawa kamaterawa awineke, faha nakamarawabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Atona one aate onahabone onahara oke, owati e na owa ahi: 'Tika boti tinawarisahi, faha isi ni ofibeya', onahabone oke. Ati e ni ya ahi: 'Faha tifahi. Tika kamero me onafawa, onahabone oke', ati ni ya afa atona tiwa nanarifa Isaki tohe fatibani toha awineke, tiwasiharo. Afa yama owi ya yama owatohabone oke, tiyahi ka yama oko hiti ni ya\", ati nematamonaka, Teoso ha nari. ");
INSERT INTO jaa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Teoso ha ni ahabamatare ya Hebeka kakehemetemoneke, boti tiwa naro iyori ya. Betoweo bitemetemone amake, haro, Nao Abaraao nisori tohe biti bite. Nao fati inimetemone amake, Mioka, Betoweo mati. ");
INSERT INTO jaa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Hebeka awi amosemetemoneke. Atonametemone amake, me makiti ahi hiteraro. Faha hoti ya tokisa boti mo kanihemetemoneke. Faya kimisamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Faya Abaraao nanarifa fito hikanemetemoneke. \"Oko faha isi nibone ta tinahabone onahara oke, tika boti karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","\"E, faha tifahi\", ati nemetemoneke. Faya boti nawarisehemetemoneke. Boti ma kana faha fawehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","He nafawi hawa tohi ya ati yana nemetemoneke. \"Faha one onakamahabone oke, tika kamero me onafawahabone owa. Faha nafiha ta onahabana oke me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hibati ya faha sika nisehemetemoneke faha fafawa wiye ya. Faya faha hoti ya yobi nemetemoneke kana naro, kamero me ka fahabone iso naro. ");
INSERT INTO jaa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abaraao nanarifa hekatomemetemoneke, ati watarari. Yama watohibona ati nematamonaka. \"Afa atonaba tohi ya yama amosa awineke, oki karo ahi yama yabo ya. Teoso yahe awaka. Afa atonaba tohari ya Teoso ehene toharihi, ne awaka\", ati boti ati nemata awaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Faha fawi kamero me hawa tohi ya Abaraao nanarifa yama atori oro hiri ni tohaha iti hinawinehemetemoneke atona witi ya. Yama atori ka karama sei nemetemoneke. Hekawa, hinemetemoneke ye tabi atoribone ya, kafamaro, oro hiri ni tohaharo. Ye tabi oharia atori ka karama 60 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Faya aate hinemetemoneke. \"Tiwati yana nabone onahara oke, abi ino tikamina tiwa. Me ya otaba ota aamoba na awine abi taboro ya?\" ");
INSERT INTO jaa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","\"Betoweo bite ama oke, Nao biti tohahari. Nao fati Mioka toha biti amaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ota taboro ya te aamobone na, kamero me tafebone na, narake, tamaharo, yoro tokanaro\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Faya Abaraao nanarifa itarisehimatamonaka iso yobati ya. Teoso kahiyarehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","\"Teoso okahiyarine oke, oko hiti Abaraao ka Teoso. Teoso yahahareka he ni ya, owa narifari, hinaka one me tabori yofi kanahari owa ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Atona kana ni tokomemetemoneke mati ka yobe ya. Yama hiwaha kaminemetemoneke mati ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Hebeka anoti Rabao tohe atori hiwehemetemoneke. Witi atori hiwa, ye tabi atori hiwa, hinehemetemoneke. Ati himita, hinehemetemoneke, Abaraao nanarifa atimona kaminaro. Rabao kana ni tokomematamonaka, Abaraao nanarifa tonakamahari. Hiwasimehimatamonaka wahari kamero me beheri ya, faha hoti yabori ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Rabao ati yana nematamonaka. \"Hima e tofamamabone eke. Teoso yahe awaka tiwa ni ya. Himataba tiwine tiri ahi? Te aamobone hawa onihara oke, kamero me taboribone toha naro\". ");
INSERT INTO jaa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Manakobisa Abaraao nanarifa tokiyomehimatamonaka yobe ya. Rabao kamero yama me weye hina yabe kamero me tafebone ta nematamonaka yoro tokanaro. Faya faha kakamematamonaka, Abaraao nanarifa me ya tabe me tame me soko nibone karo. ");
INSERT INTO jaa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Me tafebone me kakama Abaraao nanarifa ati yana nematamonaka. \"Otafarabone oke, yama okominara owa te ni ya baha\". \"Yama tikaminibeya\", Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","\"Abaraao nanarifa ama oke ha owa. ");
INSERT INTO jaa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Oko hiti ka yama amosarake Teoso yahe karo he ni ya. Honaka. Ofeya mera kiha, kabirito mera kiha, bowi mera kiha, barata kiha, oro kiha, yama aahi mera kiha, fanawi yama aahi kiharawa, kamero mera kiha, someto mera kiha, te amaka, Teoso hekawahari. ");
INSERT INTO jaa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Fati Sara tohaha bote tohakene biti na nemari amaka, oko hiti bitibonaha. Efe biti bati ahabe ya hinaka yama nafi hihawahaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Oko hiti yama hikamina hiri onahabone ati nareka, Teoso ino otiha owa, oko hiti ati ehene. Ati e nareka ahi: 'Kanaha ya owina okatao Isaki tohe fane ya Kanaha ka fanawi itirebonaka tiwati ihi. ");
INSERT INTO jaa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Otaboro bote ya tikahabone tike, ota ka fanawi tiwasiabone tiwa okatao fatibonehe', ati nareka. ");
INSERT INTO jaa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Faya aate onahareka. 'Fanawi owasi ya owa ya famami nofari ya himata nima owehene ribe?' onahara oke. ");
INSERT INTO jaa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","\"Fare Teoso ati nima owehene te ama oke. He nanarifa yosehibonaka tiwa ya famehibonaha. Ati ehene okatao fatibone tiwasihabone tike. Okatao fatibone tiwasiabone tike ota ka fanawi tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ota one me tihiyari ya me ati hiyari ya hine na naboneke. Ota ka fanawi itireba awaka fahi\", oko hiti ati nareka\". ");
INSERT INTO jaa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Manakobisa okeha faha hoti ya kobo ona Teoso ohiyarara oke. \"Oko hiti Abaraao tohehi ka Teoso tihaha tiwa aate one oke, yama owa kasawarihaba wataribone karo. ");
INSERT INTO jaa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Owa oke faha hoti beheri ya. Atona one faha nakami ya aate onahabanake, owa nafawabana hinaka boti ka faha ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ati amosi ya oko kamero mera nafawa nabone ati ni ya afa atona oko hiti biti fati tohahaba awineke, tiwasiharo', onahara oke, Teoso ha ona owa. ");
INSERT INTO jaa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Owati watara owati boti ati ya Teoso ohiyarasa oni ya Hebeka kamakiarake, boti tiwa naro iyori ya. Faha hoti ya tokifiwaha faha tonakamarake. Faya ohiyararake. 'Owa tinafawahabone onahara oke faha isi ni ya', onahara oke. ");
INSERT INTO jaa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Faya hinaka boti nawarisarake hibati ya. 'Faha tifahi. Tika kamero me onafawa onahabone oke', ati narake. Faha ofa kamero mera nafawa narake. ");
INSERT INTO jaa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Faya aate onamatasarake. 'Abi ino ra?' ona 'Betoweo bite ama oke. Nao biti amaka, okobi. Nao fati Mioka biti amaka', ati narake. Faya witi atoribone onawina, ye tabi atoribone okanawitikima onaharake. ");
INSERT INTO jaa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Faya owisi yobati ya owitarisara oke, Teoso onofa owa. Oko hiti Abaraao tohehi ka Teoso okahiyara oke. Abaraao me one yofi kanareka, nisori ka noti owakamahabone owa, Abaraao biti hitihabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Faya te ati omitabone onahara oke hibati ya. Te yahibana oko hiti ni ya? Te keyeharabana? Te ati amosi ya amosa, te ati hiyari ya hiyarihi, nabone teke. Te ati hiyari ya te ati omita onahabone oke, owehenebone wati owahabone owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Rabao ya Betoweo me famaha me ati yana nikimemetemoneke. \"Yama tikamina nafi Teoso ehene amaka. Makoni ota ati amosa yana rihi, ota ati hiyara yana rihi, nabone otake, fara ota ati. ");
INSERT INTO jaa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hebeka wara tinahi, tekamabana. Tika hiti biti hitihaboneke, Teoso ati ehene\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Me ati Abaraao nanarifa mite itarisehimatamonaka iso yobati ya. Noko towarisehimatamonaka bofe ya, Teoso nofahari. ");
INSERT INTO jaa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Manakobisa yama amosa yabe Hebeka kakawematamonaka yama yoro tokana ya, barata hiri ni toha, oro hiri ni toha, makari toha naro. Hebeka anoti kakawa, mati hekawa, hinemetemoneke, yama manakone fotaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Faya he ya tataba me ya tabe me tafa, yama me fawa, nemetemoneke. Me amo nemetemoneke fahi. Yama wamini ya me tafia Abaraao nanarifa mera hiyarematamonaka. \"Okomabone onahara oke oko hiti taboro ya\". ");
INSERT INTO jaa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hebeka anoti ya mati me famaha me ati hiyaremetemoneke. \"Te amo ni tatama nabone teke te sawiha te ota ni ya. Te amo ni 10 tohi ya te tokomaba te awineke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Me ati Abaraao nanarifa nofarematamonaka. \"Owa te bari kariyahi. Okeha oko hiti biti fatibone owasiara oke, Teoso ati ehene. Okomabone onahara oke oko hiti taboro ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","\"Hebeka e ha nahi, ati e mitibeya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Faya Hebeka me ha hina me aate hinehemetemoneke. \"He ya te tofamamibana?\" \"E, ota tofamamiboneke\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Faya me ati ihi Abaraao nanarifa me ya totabamehemetemoneke. Fanawi Hebeka nanayana tohaha sawi, nemetemoneke, me ati ihi. ");
INSERT INTO jaa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Faya me ati yana nemetemoneke, Hebeka ka yama amosabone me ati na mati, me ati e na mati ahi: \"Ota ka asima tihaha me tamaha me ka ami tihatehaba ama tike. Tika noti me kitatehaba me amake, me ka kakako me ka sitati tamaha me ihawa mati\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Manakobisa Hebeka he nanarifa me ya tabaha hine me hawa tonihemetemoneke. Kamero me mese ya me naoria me yaka kanaha Abaraao nanarifa nowati ya me tokomakehemetemoneke. Me tokomemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kanaha ka bahi kakamaki beheri ka yama ya Isaki wine kakehimatamonaka yama honara ya faha itaha ya, ini Hahi yati ne owa awe ka faha ini tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bahi toke ya yaka nematamonaka kabina ya. Faya kamero mera awehimatamonaka, me kakeha mati. ");
INSERT INTO jaa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Hebeka yama ki nabisa Isaki awa kisehemetemoneke kamero mese ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Faya Abaraao nanarifa aate nemetemoneke. \"Hike amara hari, kakehari yaka nari kabina ya?\" ati nemetemoneke. \"Oko hiti amaka\", ati nematamonaka. Faya makari ibe e noko yoyoto kana tohaha itiha noki yoto kanehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Abaraao nanarifa yama nafi hiri hina kaminematamonaka Isaki ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Faya Isaki Hebeka towakiyomematamonaka mati Sara tohaha tabori ya, Sara watamaraharo. Hitihemetemoneke. Hebeka nofehimatamonaka. Mati ahaba ihi yawe yawi fawa nematamonaka waha. ");
INSERT INTO jaa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abaraao fana one ini Ketora tohaha itiwehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketora biti me inimetemone amake haro, Abaraao biti me toha mati: Sinira, Yokisa, Meta, Mitiha, Isibaki, Soa me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisa biti memetemone me amake haro, Seba toha, Teta toha nari. Teta ka noti memetemone me amake haro, aso me toha, retosi me toha, reo me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mitiha biti memetemone me amake haro: Efa, Efe, Enoki, Abita, Eota me na mati. Ketora ka noti memetemone me amake. ");
INSERT INTO jaa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abaraao ahabe ya hinaka yama nafi Isaki hihawabone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Biti me one ni ya yama one ta nematamonaka, fati onerawa ka biti mati. Isaki ya me tabarabone ati nematamonaka, biti me one. Winasa ne ya mera toyosemematamonaka, me winahabone mati bahi kakamaki ka tabora ya yama yabo ya. ");
INSERT INTO jaa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abaraao wine ka ano 175 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ahabematamonaka bote tohahari. Ahabe tokomakehimatamonaka e abohi taboro ya, hinakiti me ya tabebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Faya biti me hikamomatamonaka Makabera ka yati hoti ya. Wate amake Manere yabori ya, bahi kakamaki ya. Heti me ka owa Eforo tohe ka wamimetemone amake, Soa biti. ");
INSERT INTO jaa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Afa wamimetemone amake, Abaraao hikanikehemetemonehe heti me ni ya. Abaraao ya Sara me famaha me me kamohemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abaraao ahabe nowati ya Teoso yahehimatamonaka biti Isaki tohe ni ya. Isaki wiwina tohehimatamonaka faha itaha yabori ya, ini Hahi yati ne owa awe ka faha ini tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Abaraao biti owa Isimayeo tohehimatamonaka, Aka biti tohahari. Sara ka yama aahimetemone amake, Aka, Esito ka me ka fanawi tohaharo. Isimayeo biti me e nemetemoneke ahi: ");
INSERT INTO jaa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Taiti Nebaioti toha, Keta toha, Abiteo toha, Mibisao toha, ");
INSERT INTO jaa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima toha, Toma toha, Masa toha, ");
INSERT INTO jaa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hatati toha, Tema toha, Seto toha, Nafisi toha, Ketema toha, nematamonaka, yoto kari. ");
INSERT INTO jaa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Afa memetemone me amake, Isimayeo biti mati, me 12 na mati. Me ka wami fara me ini weye nemetemoneke, me tabori toha naro. Afa me 12 na towisawa memetemone me amake, fara me ate ka towisawa me me tohaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimayeo ahabe ka ano 137 tohehemetemoneke. Faya tokehimatamonaka e abohi taboro ya, hinakiti me ya tabebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimayeo ka noti me wiwina tohehemetemoneke Esito yabori ya, bahi kakamaki ya. Me wini ka wami witi one Hafira toha, witi one So toha, nemetemoneke. Asiria hawi tohehemetemoneke me ka wami ya. Abaraao biti me one me ya me tabaremetemoneke, me wina mati. ");
INSERT INTO jaa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isaki tamine e nematamonaka ahi, Abaraao biti tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaki ka ano 40 tohi ya Hebeka itihimatamonaka. Hebeka Betoweo bitemetemone amake, Rabao hinakasima tohaharo. Arami ka memetemone me amake, me wina mati Mesobotamia ya. ");
INSERT INTO jaa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Hebeka kahiwi watora ihi Isaki Teoso ha nematamonaka, he kasomebonaha. Isaki ati Teoso mite Hebeka nabati weye nemetemoneke Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hebeka nabati ya biti me famehemetemoneke. Me abe mono nemetemoneke, me fama mati. Ati boti e nemetemoneke ahi: \"Himata ihi yama e na hiri one ori?\" ati boti ati nemetemoneke. Faya Teoso aate nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Hebeka ati Teoso mite ati e nematamonaka ahi: \"Tinabati ya matehe famaha me ka iti meba me amake, me tamaha mati. Me tinawati ya me tamaha me yaro tikanabone tike, me winakanikima naba mati tabora tamaha ya. Me ka noti me e tehaba me amake ahi: Owa ka noti me ta me kitatehaba me amake. Yoto ka ka noti me me yosetehaba me amake, taiti ka noti mati\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Yama amo ni kobo nemetemoneke, Hebeka tori watibone karo. Biti makiti me famehemetemoneke, me hinawata mati. ");
INSERT INTO jaa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Taiti mese mamawa nematamonaka. Konehimatamonaka bani ataro kokona ne e weye na nima. Makoni ino me hinawatematamonaka, Esao tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nisori wati yotohi Esao teme yotofi tama kanematamonaka, yehe oharia ya. Makoni ino me hinawatematamonaka, Yako tohahari. Me famaha me kawati ya Isaki ka ano 60 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Me famaha me kakayana tohehemetemoneke. Esao toki nonofa tohehimatamonaka yama kabani ya. Yama yete ni wawato tohehimatamonaka. Yako ta toki nofare iita tohehimatamonaka tabora ya. ");
INSERT INTO jaa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaki Esao ta nofehimatamonaka, ehene kabi hinofe kari. Hebeka Yako ta nonofa tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yama wehe one ya Yako yama kawari Esao kobo namehimatamonaka, tokahari yama kabani ya. Ma tohe ");
INSERT INTO jaa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ati yana nematamonaka. \"Yako ofimi oke kasiro ya. Tika yamata mamawa na okobabone onahara oke\". (Makoni Esao ino owa weye nematamonaka Eto tohahari.) ");
INSERT INTO jaa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yako ati amosematamonaka. \"E, tikababa awineke. Hiba. Tiwati yana nahi hibati ya, tiweheneba tikamina tiwa, e ka abi ahabe ya hinaka yama tamaha ihawai tinofamarabone tina tiwa, hinaka yama tamaha ohawahaba owa ha owa. Tiwati e na omiti ya yama tikababone tike\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","\"Siba kere. Ahabinima oke fimi ihi. Okobi biti taiti oha hinaka yama tamaha ihi onofarabone oke, oko fimi kasomaribone karo\", Esao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","\"Tiwati e na Teoso ino titihabone tike, tiwati mitehibonaha\", Yako ati nematamonaka. Faya Esao Teoso ino itihimatamonaka, hinaka yamabone ta nari nisori ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Faya Yako yama hikawareha ta, bao ta, nematamonaka Esao ni ya. Esao yama kaba, yama fawa, ne tafi hawa tohe yana ne tokomematamonaka. Yama e na hiri ne hinaka yamabone nofamarehimatamonaka, bati biti taiti ka yamabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Isaki me wini ka yama ya me fimi yana tonehemetemoneke, me tafe watamari karo. Abaraao yama me hiri hinehemete nima yama nemetemoneke, Isaki me hiri hinaharo tasa. Makoni Isaki tokehimatamonaka sitati Sera tohaha ya, Abimereki wine ka sitati, Firisia ka me ka towisawa tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Faya Teoso hiwa namohimatamonaka Isaki ni ya. \"Isaki tikarabone tike Esito ya. Tiwinibone ka tabora yofi okanabone oke tiwa ni ya. Tikahabone tike fahi. ");
INSERT INTO jaa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Afa tabora ya tiwinabone tike mata. Te ni ya osawiabone oke, oyaha owa te ni ya. Afa wami nafi ta onahabone oke tika noti me ni ya, fara owatimaro nima owehene na owa, abi Abaraao ohiyara owa, fara owini otiha owa, owati tohawarabone ona owa. ");
INSERT INTO jaa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Owati ihi tika noti me tamatehaba me amake, neme ka amowa me tomi kani nima me tomi kani na mati. Wami nafi ta, onahabone oke me ni ya. Me ihi oyahabone oke tabora nafi ka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Owati nafi Abaraao tokatabe ka yama e na hiri onahabone oke. Abaraao oyose fara owati nima ehene nemari amaka. Okanawane ya yama okomina hiri nemari amaka\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Makoni Isaki wiwina tohehimatamonaka Sera ya, tokarari tabora bara ya. ");
INSERT INTO jaa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Firisia ka Hebeka me kamina Isaki me aate na hinakasimamone ati nematamonaka. Hebeka awi amosemetemoneke. Isaki mera nakome ka atiba yana rematamonaka fatimone ati neba ati. \"Oko yibotemone oni ya owa me nabowariyahi, Hebeka me itihabone me ati ni ya\", ati boti ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaki wini toyabomatamonaka fahi. Yama we one ya Abimereki Firisia ka me ka towisawa tohe nokobi bite ya yama kakatome Isaki awehimatamonaka, fati Hebeka toha tatamo nari. ");
INSERT INTO jaa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Faya Abimereki Isaki ino hiri nematamonaka. Ati ehene Isaki kakehimatamonaka. \"Keye hiri tiriyahi. Tika yibote amarini? Himataba asimamone tina tiwa awine tiri?\" Abimereki ati nematamonaka. \"'Oko yibote okomini ya owa te nabowabone owati boti ati nara oke\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","\"Himataba tiwehene e na ama tiri ahi? Ota ka owa ahi hinemenehe otara yokohina amaka, asimamone hinaharo\". ");
INSERT INTO jaa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Faya Abimereki me nafi narabi nima nematamonaka, Sera ka mati. \"Isaki fati ya me fama hahi mera nofare ahabebonaka owati ihi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Afa ano ya Isaki yama koro nematamonaka. Hinaka yama amosemetemoneke Teoso ati ehene. Yama ate oharia boni 100 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Honene totamematamonaka. Hinaka yama tamehemetemoneke kasiro ya. Kita, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Isaki ka ofeya me tama, hinaka kabirita me tama, hinaka bowi me tama, hinaka yama aahi me tama ni ka hinaka yama me aawawa hinehemetemoneke, Firisia ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Makoni Abaraao ka faha hoti nafi me tofa nemetemoneke wami ya, Abaraao nanarifa me hiri hinehemete, Abaraao sawisa ne ya, Isaki bati. ");
INSERT INTO jaa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Manakobote Abimereki ati yana nematamonaka, Isaki hiyarari. \"Isaki te tokomabone teke tabora bara ya. Tika kiti nafimisa ihi ota kitamakere tiwehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Faya sitati ya yana tone tokehimatamonaka Sera yabori ka yama ya, faha witi ya. Winehimatamonaka yobe kabirita kone kowi tohehi ya. ");
INSERT INTO jaa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abaraao ka faha hoti namosamehimatamonaka, tamaharo, Firisia ka me tofa hinaharo Abaraao ahabe nowati ya. Faha hoti ini Isaki nawatematamonaka, fara ini weye hinehemete ini weye nawamabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yama we one ya Isaki nanarifa faha hoti me namosa faha me wasihemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sera ka bani nanarifa Firisia ka me tohaha Isaki ka bani me nanarifa me me hora nemetemoneke, me ka fahamone me ati na mati. Makoni faha hoti ini Isaki hinawatemetemoneke, Me abe hora na ini tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Yama we one ya Isaki nanarifa faha hoti one me namosa me me hora nemetemoneke tasa, Firisia ka mati. Makoni faha hoti ini Isaki nawatematamonaka, Me me kakoa ini tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Faya Isaki tokehimatamonaka tabora bara ya. Faha hoti one namosematamonaka fahi. Firisia ka me hora ni ati watara ihi faha hoti ini Isaki nawatematamonaka tasa, Wami ehebote ini tohahabonehe, ati e nari ahi: \"E ka wami ehebotebone Teoso ta nareka waha, e wini amosibone karo\", ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Manakobisa Isaki tokehimatamonaka Beseba ka tabora ya. ");
INSERT INTO jaa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Afa yama soki ya Teoso hiwa namohimatamonaka he ni ya. \"Abi Abaraao ka Teoso ama oke. Kokoriri tirahabone tike, e tabi karo. Oko nanarifa Abaraao tohe ehene oyahabone oke tiwa ni ya. Tika noti me tamateba me amake owati ihi\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaki tana yati hiri ni tohaha hiri nematamonaka fahi, Teoso ha nebonaha. Hinaka yobe kabirita kone kowi tohehi nawehimatamonaka fahi. Afa tabora ya he nanarifa faha hoti one me wi nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yama we one ya Sera ya Abimereki yana tone kakehimatamonaka Isaki hiyarebonaha. Me terei nemetemoneke, he ya tataba Aosati toha, Fiko toha, nari, Abimereki ka saotato mera yoyose tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaki mera aate nematamonaka. \"Himataba te kakineri owa ni ya, owa te hiyarabone te ati nani te? Owa te kakoa teke, owinamarabone te ati na te te taboro ya\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","\"Teoso ota watowaha otake, sawihari tiwa ni ya. Makoni e abe nofatibone ka yama e hiri nabone ota ati na otake. E abe nofatibone ka yama e hiri ni ya Teoso ino e hiri nabone eke, e ati tohawarabone e ati na e. E ati e nabone eke ahi: ");
INSERT INTO jaa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Otara tikatomarabone tinahabone tike e abe nofatibone ka yama ya. Tiwa ota katomara otake. Ota yaha otake tiwa ni ya. Ota taboro ya yana tina tika tokomi amosara tike ota ehene, tiwa ota katomara ota. Tiwa ota watowaha otake waha, Teoso yahe karo tiwa ni ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Faya Isaki mera mari nematamonaka. Me tafa, yama me fawa, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yama wamini ya me bosa na me abe nofatibone ka yama me hiri nemetemoneke fahi. Me nafi ati yana nemetemoneke, Teoso ati me hiri na mati, me ati tohawaba watarabone me ati na mati. Me tokomi ya Isaki ati amosematamonaka, he ya tataba memone mera ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Afa yama wehe ya Isaki nanarifa hiyara me kaminemetemoneke he ni ya. Faha hotibone me wi na faha me wasihamone me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Makoni faha hoti ini Isaki nawatematamonaka, ini Seba tohahabonehe. Manakobisa yama we one ya sitati inibone me nawatemetemoneke, Beseba tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esao ka ano 40 tohi ya Sotiti Beheri bite tohaha iti, Basemati Ero bite tohaha iti, nematamonaka. Heti me fanawirimetemone amake. ");
INSERT INTO jaa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Esao fati famarawa Isaki ya Hebeka me famaha me me nofaremetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaki bote tohehimatamonaka. Noko awamarihi nematamonaka. Yama we one ya biti Esao ha nematamonaka. \"Bese\". \"Abi oha oke ahi\", Esao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","\"Owa tiwa tike, bote oha owa\", bati ati nematamonaka. \"Yama we one ya ohababone oke. ");
INSERT INTO jaa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tika wati tama tikana tikahabone tike yama kabani ya, yama yete tinabone tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Bani amose hawa tinihabone tike, tekamebonaha owa ni ya. Hawa tonihi tiwatohibonaka, kabi onofebonaha. Oko tafi ahabi ya owati yana nabone oke, tika yama amosabone ona owa, ohabari ya mata\", bati ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaki ati Hebeka mitehemetemoneke, me hiwatoraro. Faya Esao toke nowati ya ");
INSERT INTO jaa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Yako hiyaremetemoneke. \"Abi ya ayo Esao me fama me abe hiyara me ati omitara oke hibayata ya. Abi ati e nareka ahi: ");
INSERT INTO jaa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Tikahi, yama yete tibeya. Bani amose hawa tinihabone tike, okobebonaha. Oko tafi ahabi ya owati yana nabone oke, tika yama amosabone ona owa, ohabari ya mata', ati nareka. ");
INSERT INTO jaa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Bese owati miti titaminabone tike, tiwa oyoseha owa, owati e na owa ahi: ");
INSERT INTO jaa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tikamakehi e ka bani me tabori ya. Kabirita me famaha me amosa me tekamabone tike. Bani me hawa onihabone oke, abi me hikababone mati. Me hawa tonihi owatohabone oke, me kabi hinofabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Bani me tekamabone tike abi ni ya, me hikababone mati. Faya ati yana nebonaka, tika yama amosabone ati nari, ahabare ya mata\", Hebeka ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","\"Okoyo konaka. Okona okere ha owa. ");
INSERT INTO jaa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Okobi owa boyo ne ya owa watohibonaka. Okeyehemona ati nebonaka. Faya oko yama amosabone ati re ya oko yama hiyarabone ati nebonaka\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","\"Bese yama hiyara kakeraboneke tiwa ni ya. Yama hiyara abi kamine ya yama hiyara kakehi owa ni ya fara owa. Yama okomina hiri tinahabone tike. Kabirita me tekamahi owa ni ya\", mati ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yako kabirita mera tonakamaki kabirita mera kakamematamonaka mati ni ya. Hebeka kabirita mera hawa tonihemetemoneke, Isaki me hikababone mati. Me amosemetemoneke, Isaki me kabi hinofabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Faya Esao ka makari amosabote tonakemetemoneke, Yako hikahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yako yehe toha, namiti toha ne Hebeka yoto kanehemetemoneke kabirita me atari ya, konehibonaha, kone watarari. ");
INSERT INTO jaa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Faya yamata amosa ta, bao ta, nemetemoneke Yako ni ya, hiri hinaharo. ");
INSERT INTO jaa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Faya Yako tokomakehimatamonaka bati ni ya. \"Abi\", ati nematamonaka. \"Oha oke ahi\", bati ati nematamonaka. \"Bese hike ama tiri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","\"Esao ama oke. Tikatao taiti ama oke\", Yako ati nematamonaka. \"Yama tikamina hiri onahara oke. Yana tinahi, tiwitaribeya. Yama kabani ka bani onabowe tikabaho. Manakobisa tiwati yana nabone tike, oko yama amosabone tina tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaki aate hinehimatamonaka. \"Bese himata nima tiwehene rini, bani wasi kerewe tira tiwa?\" ati nematamonaka. \"Tika Teoso owa narifareka\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","\"Tikama ahi ayata ya, tiwa boyo obeya. Tiwa owatohabone onahara oke, Esao tihi ya tiha, Esao tihari ya tiharihi tina tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Faya Yako tokomematamonaka Isaki beheri yokana ya. Faya boyo hinehimatamonaka fahi. \"Tiwati yana ni Yako ati amaka. Tiye ta Esao ye nima nineke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Makoni Isaki Yako watorematamonaka, Yako yehe konahari Esao yehe kone nima. Faya ati yana nematamonaka fahi, Yako ka yama amosabone ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aate ni tai hihehimatamonaka baha. \"Okatao efe yokana ama ti, Esao tiwa?\" \"E, efe ama oke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Faya bati ati yana namatasehimatamonaka. \"Oko baniba tekamahi aya yete tinahari okobebana. Manakobisa tika yama amosabone onahabone oke\". Faya Yako bati natafematamonaka. Fi kakama nematamonaka bati hifabonehe. Isaki tafa, yama fawa nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Faya ati yana nematamonaka. \"Bese tikama ahi. Onoko baki komi tinakibeya\". ");
INSERT INTO jaa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Faya Yako tokomematamonaka bati ni ya. Faya noko bako komi hinakimatamonaka. Esao ka makari Yako hikaha mahi Isaki hisi ne ati yana nematamonaka, Yako ka yama amosabone ati nari, ati e nari ahi: \"Hahi okatao maho amosaka hari, yama kabani mahi weye nari, yama kabani amosabone Teoso hinehemete. ");
INSERT INTO jaa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Bese tika yama tanafaribone Teoso ta tehibonaka, neme karo, tika fatara ka yama yani amosatibone karo. Tika tiriko tama, tika ofa tama, teboneke, tika fibonehe. ");
INSERT INTO jaa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Haha me yoro tokana me tiyosetehabone tike, me winakanikima na mati yama nafi ya. Tiwa me kahiyaratehaboneke afa mati. Te one me tiyose titehabone tike. Ami ka noti tiwa me kahiyaratehaboneke. Tiwa me kako ya hine me yokohaboneke. Haha tiwa me nofa me ni ya yama amosa na naboneke\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yako ka yamabone Isaki kamini hawa tohe faya Yako tokome nowati ya Esao kobo namematamonaka, yama yete nari. ");
INSERT INTO jaa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Yamata kabi amosa hawa toniha nematamonaka, hekamabanihi bati ni ya. \"Yana timisahi. Tiwitarehi, titafibeya. Bani onabowe tikabahi. Tika tafi ahabi ya tiwati yana nabone tike oko yama amosabone tina tiwa\", Esao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","\"Hike ama tiri ha tiwa?\" Isaki ati nematamonaka. \"Esao ama oke tikatao taiti owa\". ");
INSERT INTO jaa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Faya Isaki ero ne hoyahoya kana nematamonaka. \"Hibake amarano, yama yete nenoho, bani kakamari owa ni ya? Okobareka hibati ya tikamari ya mata. Efe hinaka yama amosabone hawa toharake owehene. Efebona amaka\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esao yama mite yawi nafihi ha ni kitematamonaka. \"Abi oko yama amosa nabone tinahabone tike bisa\". ");
INSERT INTO jaa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaki ati hiyarematamonaka. \"Niso kamehino owa keyehenoka, tika yama amosabone kahitiari\". ");
INSERT INTO jaa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Hahi owa keyehibemari owa keyehatasaka. Yama amosake haro, ino te nawatamata karo, Yako tohahari, era kekeyeha tohahari. Hibati ya owa keyehemari amaka, oko yama tamahabone ihawebonaha tihabi ya, tikatao taiti ka yamabonehe. Faya oko yama amosabone tinahabone afa kahitiareka tasa. Abi yama hasi naba watamara awine, oko yama amosabone tiba karo?\" Esao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yama hawa toharake hibati ya. Yako tiwa yosetehiba amaka owati ihi. Yako me narifateboneke Yako me one mati, owati ihi. Hinaka tiriko tama, hinaka fi tama tehaboneke, onahara oke. Yama hasi naba watamakere, tikabana bese\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esao ati fawa rematamonaka. \"Yama amosa ohariani ama, titihabana? Oko yama amosa nabone tinahabone tike bisa abi\". Faya Esao ohi ni yana tonehimatamonaka ohi ni kitahari. ");
INSERT INTO jaa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tiwinatehaba ama tike yama yabo ya wami amosa amara ya, neme ka yama tanafari watari ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tiwehene iti tamatehaba ama tike. Niso ka yama ahi titehaba ama tike. Niso narifi tinofamari ya bete tikasatehaba ama tike\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Faya Esao Yako kakomatamonaka, Yako ka yama amosabone Isaki hinahari. \"Okobi ahabi kerewe reba awaka\", ati boti ati nematamonaka. \"Ahabe ahabi nowati ya me nafi yawa me yawi fawa ni ya okaniso onabowabana oke fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Hebeka yama watohemetemoneke hibati ya, Esao nisori wati kane ka yama. Yako ino hiri nemetemoneke. Kame \"Owati timitamata. Ayo tiwa wati kanaka. Tiwa nabowebona ati nemonaka. ");
INSERT INTO jaa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Makoni owati timitabone tike bese. Tikahi okoyo Rabao tohe taboro ya, winahari Hara ya. ");
INSERT INTO jaa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tisawibeya mata Rabao me ni ya. Ayo ati somawame ya tikamabana tike. ");
INSERT INTO jaa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ati katamoba awaka tiwehene ya. Ati somawame owe ya tiwa me tonakamakiabana tike owati ihi. Okatao me fami ahabariyahi yama wehe oharia ya\", Hebeka ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Manakobisa Hebeka tokomemetemoneke Isaki hiyarabonehe. \"Yama nawahake owa ni ya haha me fanawi ihi, Esao hiyabarawaro, heti me ka fanawi. Fanawi e na Yako ititase ya ahabi onofabone oke\". ");
INSERT INTO jaa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Faya Isaki Yako ati nematamonaka. Faya Yako tokomematamonaka Isaki ni ya. Yako ka yama amosabone Isaki ati nematamonaka. Yako yose nematamonaka. \"Kanaha ya e winaha Kanaha ka me ka fanawi titirabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tiwa hawa tinihahi. Tikibeya Mesobotamia ya. Tisawiabone tike iti Betoweo taboro ya. Koko bite one titihabone tike, Rabao bite. ");
INSERT INTO jaa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Tika yama amosa natebone tike Teoso kitabote ehene. Tika noti me tama teboneke efe ehene, me yoro tokana mati, me winakanikima na mati yama nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tika yama amosabone Teoso ati, tika noti me ka yama amosa tehabone Teoso ati, nebonaka. Fare Abaraao ka yama amosabone Teoso hikaminehemete nima tika yama amosi nabone tike. Kanaha Teoso ta nematamonaka Abaraao ni ya. Kanaha ta, nebonaka tiwa ni ya, tika noti me toha na me ni ya. Bare tiha tiwina tike Kanaha ya mata. Yama toyabo ya Kanaha hiti me te tohatehabone teke, Teoso ati ehene\", Isaki ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yama e nemetemoneke ahi Isaki Yako yose ka yama, Yako winehibonaha Mesobotamia ya, Rabao taboro ya. Rabao Betoweo bitimatamona amaka, Betoweo Arami ka me ka owa tohahari. Hahi Betoweo Hebeka anotimatamona amaka, Hebeka Esao ya Yako me famaha me ka ami. ");
INSERT INTO jaa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esao Yako tamine mitehimatamonaka, hinaka yama amosabone Isaki hinaharo. Tamine himita hinehimatamonaka, Isaki hiyosehari fanehibonaha Mesobotamia ya. Tamine himita hinehimatamonaka, Kanaha ka fanawi itirebona Isaki hinahari. ");
INSERT INTO jaa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tamine himita hinehimatamonaka, tokahari Mesobotamia ya, bati ya mati me famaha me ati tokatabahari. ");
INSERT INTO jaa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esao yama watohimatamonaka haro, Kanaha ka me fanawi bati nofare ka yama. ");
INSERT INTO jaa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Makoni tokehimatamonaka ahi Isimayeo taboro ya, Isimayeo Abaraao biti. Faya Isimayeo bite Marati tohaha itihimatamonaka, Marati Nebaioti hinakasima. ");
INSERT INTO jaa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yako yana tonematamonaka Beseba ya, tokehibonaha Hara ya. ");
INSERT INTO jaa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Bai toke ya kobo towitimatamonaka Teoso taboro owa ya. Amo nebona ati nematamonaka fahi. Faya yati ibe itihimatamonaka, tati mama kanabonaha. Homarisematamonaka amo nebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Faya watamimatamonaka. Kikisama watari awehimatamonaka, wami ya kawaha towakimisamaharo neme ya. Afa kikisama ya Teoso nanarifa me one tokomisama me one kisama na me watari awehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Teoso sawihimatamonaka Yako beheri ya. Faya ati yana nematamonaka. \"Ha owa Yeofa ama oke. Iti Abaraao ka Teosomari ama oke, abi Isaki ka Teoso oha ona owa. Tihomi ka wami ta otehabana oke tiwa ni ya tika noti me toha na me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tika noti me tamatehaba me amake, wami boni tomi kani nima me tomi kani na mati. Me winakanikimatehaba me amake, wami nafi ya, bahi kakamaki toha, bahi totoka toha, bahi kakamaki beheri toha, bahi totoka beheri toha ne ya. Oyahatebone oke tabora nafi ka me ni ya, tiwehene, tika noti me toha na me ihi. ");
INSERT INTO jaa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Osawihabone oke tiwa ni ya, tiwa owakatoma owa fara tiki ka yama ya, yama yofina wataribone karo tiwa ni ya. Yama toyabo ya wete tinamabone tike ahi owehene. Tiwa owakanakosarabone oke. Fara yama okomina nima owehene nabone oke\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Faya Yako tafihi ati yana nematamonaka. \"Keye amakere. Teoso taborono amaka hari, owatorahari\". ");
INSERT INTO jaa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kakomehimatamonaka fahi. \"Yama yofinake haro. Teoso taboro tohe awaka. Neme noki bori wana awineke ahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yako bosa ne yati itihimatamonaka, he tati mama kana toaharo. Faya hinawehemetemoneke wakosabonehe. Orifa yehe sika nisematamonaka yati mese ya, Teoso ka yatimone hinaharo. ");
INSERT INTO jaa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Afa yama ya sitati nehemetemoneke. Inimetemone amake Rosi tohaharo. Yako ini hinihawahemetemoneke Beteo tohawabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Afa yama ya Yako ehenebona kaminematamonaka Teoso ni ya. \"Yeofa tiha oko Teoso tihahabone tike owa tekatomi ya. Owa ni ya tisawi, yaka ona owa hasi tiniha, oko boronebone ta, otefeba ta, tini ya oko Teoso tihahabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Otaminaha wete onami ya okobi taboro ya faya oko Teoso tihahabone tike, Yeofa tiha tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Haha yati onawaha tika yobebona amaka. Oko yamabone ta tina kote bite tesimo tohaha ta owahamaboneke tiwa ni ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Beteo ya Yako yana tone tokatase kobo nematamonaka bahi kakamaki ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yako yama awibote nematamonaka faha hoti, yama kabani baikani ya. Fa hoti beri ya bani me nanarifa me terei na me nahohemetemoneke, me ka bani me ya me taba mati, ofeya me toha, kabirita me toha na mati. Haha faha me kakabi tohehemetemoneke, me ka bani me hifabonehe. Haha faha hoti noki bori yati ibe tohehemetemoneke yati ibe nafiharo. ");
INSERT INTO jaa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bani me nanarifa me ka bani me ya me tabaha me nafi tohi ya fa noki bori me iiti tohehemetemoneke, me kabi hinahabonehe me ka bani me ka fahabonehe. Faya faha noki bori me boboko kanama tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yako kobo ne mera aate nematamonaka. \"Hibaka ya te kakerini oko one mati?\" \"Hara ka me ota amake\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","\"Rabao te awatehani te ama Nao ka noti?\" \"E, ota awate amaka\". ");
INSERT INTO jaa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","\"Tamine awa?\" \"E, taminaka. Tiwa haro bite kamakiaro hinaka bani me ya tabaharo\". ");
INSERT INTO jaa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","\"Yama e na amosa awineke ahi bani me te nafawakabote ni ya, me te towakaba mati yama kabani ya, masiri me kabamatasabone mati. Faya me te towakamaboneke fahi tabora ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","\"Yama e na hiri ni ota nofakere. Bani me one ota noki namatabone otake. Bani me nafi kobo ni ya fa noki bori ota iti ya bani me ota nafawabone otake me nafi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yako mera hiyarasa ne ya Hakeo kobo namakiemetemoneke bati ka bani mera kakamakeharo, ofeya me ya kabirita me taba mati, bati ka bani mera nanarifa toaharo. ");
INSERT INTO jaa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Hakeo bani me ya tabaha awehimatamonaka kokori Rabao ka bani mati. Hibati ya tokome fa noki bori itihimatamonaka. Faya bani mera nafawematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Manakobote Yako Hakeo komi nake ati boti kamoniri yana ne ohi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","\"Abi me ka owa yokana ama oke. Hebeka biti ama oke\", ati nematamonaka. Faya Hakeo kana ni tokomemetemoneke bati ni ya yama kaminabonehe, Yako tamine. ");
INSERT INTO jaa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Rabao hinaka bitimi tamine mite tasi tone kana ni tokomematamonaka. Yako kobo ne faya hitiri hinehimatamonaka. Komi hinaki hine hekamematamonaka taboro ya. Faya Yako yama nafi kaminematamonaka he ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","\"E, keye amakere. Ota ka owa yokana ama tike\", ati nematamonaka. Yako abariko naharihimatamonaka sawihari kokori taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Faya Rabao ati yana nematamonaka. \"Tisawiha oko yama ahi tina haha ota ka owa tihi ka yama ahi ni manakone ta orara oke. Yama e na amosakere. Himata tinofaribe, yama ahi ni manakonebonehe?\" ");
INSERT INTO jaa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Rabao bite famarawemetemoneke. Taiti Reya toha, yoto ka Hakeo toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Reya awi aamosaraba na Hakeo ta amosemetemoneke. Noki awi amosa, aboni awi amosa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yako Hakeo nofehimatamonaka kasiro ya. Makoni ati e nematamonaka ahi: \"Ano seti na ya tika yama ahi oni ya tikoto Hakeo toha tikahabanabone tike otihabonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","\"Okoto okahabanabone oke titihabonehe. Bare hiti ya yama amosarehene amake. Tisawihi owa ni ya\", Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Makoni Yako yama ahi nematamonaka ano seti na ya, Hakeo itihibonaha. Yama nawahaba wataremetemoneke Yako ni ya, ano seti na karimari. Ano seti na yama wehe tamara nima nemetemoneke he ni ya, Hakeo nofe karo kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ano seti na ahabi ya Yako Rabao aate nematamonaka. \"Tikoto tikahabanabone tike waha, otihabonehe. Yama amo nibone e kaminaro ahabake. Otihaboneke hibayata ya\". ");
INSERT INTO jaa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Rabao ayaka hiri nematamonaka me fanibone ka ayaka. Faya mera ha nematamonaka me nafi, me sawihabone mati ayaka ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Afa yama soki ya Rabao Yako nafamematamonaka Reya ya. Faya Yako Reya amo kanematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Rabao ka yama aahi fanawi Sioba toha ta nematamonaka Reya ka yama aahibonehe. ");
INSERT INTO jaa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Manakobote Yako Reya wasiminehimatamonaka, amo hikananihi. Makoni tokomematamonaka Rabao hora nebonaha. \"Himataba tiwehene e rini ahi owa ni ya? Yama ahi onara oke Hakeo ota famahabone ota. Himataba owa tikeyerini?\" ");
INSERT INTO jaa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ota ni ya yama nihinakere ahi, fanawi yoto ka fani tai toiba ka yama. Fanawi taiti ta fani tai toaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hiba yama noki timatahi. Ayaka amo ni ahababoneke semana oharia ya. Manakobisa tiwati yana nabone tike oko yama ahi tinabone tina tiwa ano seti na ya tasa. Faya Hakeo okahabanaboneke, titihabonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yako ati amosematamonaka. Ayaka amo ni ahabi ya Rabao bite Hakeo toha kahabanehimatamonaka, Yako hitihabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Rabao ka yama aahi fanawi Bira toha ta nematamonaka Hakeo ka yama aahibonehe. ");
INSERT INTO jaa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yako Hakeo amo kana nematamonaka. Yako Hakeo nofi mati tohehimatamonaka, Reya nonofarama nari. Faya Rabao ka yama ahi nematamonaka seti ano tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Teoso Yako awehimatamonaka Reya nofarari. Makoni Reya kahiwemetemoneke Teoso ati ehene. Hakeo ta kahiwaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Reya nabati weye na biti watehimatamonaka. Ino hinawatehimatamonaka, Hobi tohehibonaha. Ino hikaminematamonaka ati e naro ahi: \"Oyawa Teoso owa awe oko yibote owa nofawebonaka\", mati ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Reya nabati weye namakitasa biti owa watatasematamonaka. Ino hinawatehimatamonaka, Simiao tohehibonaha. Ati yana nemetemoneke. \"Owa me nofaramone otamine Teoso mitehinoka. Makoni okatao owabona ta namakiareka\". ");
INSERT INTO jaa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Reya nabati weye namakitasa biti owa watatasehimatamonaka. Ino hinawatematamonaka, Refi tohebonaha. Ati yana namatasemetemoneke. \"Oko yibote ota famahaba ota amake waha ayata ya, biti mebone me onawata owa, me terei na mati\". ");
INSERT INTO jaa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Reya nabati weye namakitasa biti owa watehimatamonaka. Ino hinawatematamonaka, Yota tohebonaha. Ati yana namatasemetemoneke. \"Haha yama ya Teoso okahiyarabone oke waha\". Manakobisa kahiwamaremetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hakeo hine watohemetemoneke kahiwaraharo. Faya ati boti e nemetemoneke ahi: \"E onahabone onofa ama oke okati Reya nima, kahiwaro\". Faya maki hiyaremetemoneke. \"Okatao mebone me naboneke tiwehene. Okatao me watari ya ohababone oke\". ");
INSERT INTO jaa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Hakeo ati Yako mite yawe ati yana nematamonaka. \"Teosomona owa tina tiwa awine ti? Teoso ehene amaka, tikahiwara tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","\"Oko yama aahi Bira tohaha te famahi. Kahiwi ya biti okatao tohebonaka. Okatao nehibonaka ihi\", Hakeo ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Faya Hakeo ka yama aahi Bira toha kahabanemetemoneke Yako ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bira nabati weye na biti watehimatamonaka Yako biti. ");
INSERT INTO jaa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Faya Hakeo ati yana nemetemoneke. \"Hahi inamatewe ino e nebonaka ahi: Ta tohehibonaka, Teoso yama amosa hiri ne karo owa ni ya. Ha one owati mite owa kakawareka okataobona ya\". ");
INSERT INTO jaa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bira nabati weye namatasa biti owa watatasehimatamonaka Yako biti owa. ");
INSERT INTO jaa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","\"Hahi inamatewe ino Nafitari tohehibanaka. Okati mono ona okati kitararake owehene\", Hakeo ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Reya hine watohemetemoneke kahiwamararo. Hinaka yama aahi Sioba toha kahabanemetemoneke, Yako ya famabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Sioba biti watematamonaka, Yako biti. ");
INSERT INTO jaa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","\"Yama amosake haro. Inamatewe ino Kati tohehibonaka\", Reya ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Manakobisa Sioba biti owa watamaketasehimatamonaka, Yako biti owa. ");
INSERT INTO jaa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","\"Yayai oke kasiro ya. Yayai onahamone me fanawi one ati naboneke waha. Makoni inamatewe ino Ase tohehibonaka\", Reya ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yama we one ya tiriko babata ka yama ya Hobi tokehimatamonaka yama kabani ya. Faya yama wasihimatamonaka matakora toaharo. Hekamehemetemoneke mati ni ya Reya ni ya. Hakeo yama kakami awa Reya hiyaremetemoneke. \"Oko matakoraba ta tibana, aya tikatao hekamaharo?\" ");
INSERT INTO jaa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","\"Oko yibote titimakehamaro ama tike. Oko matakora titimake tinabone tine ti, okatao ta hinaharo owa ni ya?\" Reya ati nemetemoneke. \"Yama e nabanake ahi: e abe kakawikimahaba eke. Matakora ya owa tekawi ya tiwa owakawabisabone oke Yako ya, amo tikanebana yama soki ya\", Hakeo ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Bahi toke ya Reya Yako kobo nemetemoneke kamahari. Faya ati yana nemetemoneke. \"Haha yama soki ya e amo ni famahabone eke. Tika manakonebone ta ni hawa ohahara oke matakora ta ona owa, okatao hiwasianihi\". Faya Yako amo hikanemetemoneke fahi yama soki ya. ");
INSERT INTO jaa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Reya Teoso ha na ati Teoso himita nabati weye namatasehemetemoneke. Biti watamake biti me siko nemetemoneke waha, Yako biti mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Faya Reya ati yana nemetemoneke. \"Inamatewe ino Isaka tohehibonaka. Aya oko yama aahi okahabana oko yibote ya Teoso owa kakawareka yama amosa ya\". ");
INSERT INTO jaa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Manakobisa Reya nabati weye namatasa biti owa watamakehimatamonaka tasa. Faya biti me sei nemetemoneke waha, Yako biti mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Reya ati yana namatasemetemoneke. \"Teoso owa kakawareka yama amosi mati tohaha ya. Oko yibote ya ota famawahaba ota amake waha, okatao me sei ni karo, biti mebone mati\". Makoni inamatewe ino nawatemetemoneke, Seboro tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Manakobisa Reya bite watamakehemetemoneke. Ini hinawatemetemoneke, Tina tohabonehe. Faya Reya kahiwamaremetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Manakobote Teoso Hakeo wati nawahematamonaka. He ha na ati himita kahiwawahemetemoneke Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Faya nabati weye na biti watehimatamonaka. Ati yana nemetemoneke. \"Okatao watare ehene kokoma onibaha kokoma onama okere waha, Teoso owa kasome owa. ");
INSERT INTO jaa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Okatao owabona Teoso ta namakibona onareka\". Makoni inamatewe ino nawatemetemoneke, Yose tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yose wati nowati ya Yako Rabao hiyarematamonaka. \"Okomabone onahara oke okobi me tabori ya. 'E, tikamahi', tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Owehene tiwato tike, tika yama ahi ni onafiha owa. Okomabone onahara oke. Oko yibote owakamarawahabone onahara oke, aya ta tirawaro yama ahi ni manakone. Okatao me toha naboneke, me owakamabone mati. Tiwati amosabone tike, me owakamabone ona owati timita tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","\"Hine e famake. Owati tikatabahi. Me inamati aate ona tiwa me kaminarake. Teoso oko yamabone ta nemona me ati narake tiwehene. ");
INSERT INTO jaa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tiwati yana nahi. Tika yama ahi ni manakoneba tikaminahi. Fara yama ahi ni manakone tikamina ta onabone oke tiwa ni ya\", Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","\"Owehene tiwato tike, yama ahi ni onafiha owa. Owa tiwato tike tika bani me narifi onatamina owa. ");
INSERT INTO jaa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Okematari ya tika yama tamaremete tike. Manakobisa tika yama totamawahake waha. Tika yama amosabone Teoso ta nareka, fara osawi ka yama ya. Hibayata ya oko yibote toharawa okatao me toha na me narifi onofa oke waha\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","\"Tika yama ahi ni manakonebone tikaminahi\", Rabao ati nematamonaka tasa. \"Yama manakone onofa okere. Yama e naboneke ahi: owati yana na timiti ya tiwati amosi ya tika bani me onarifasa onabana oke. ");
INSERT INTO jaa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Owati e nara oke ahi: tika bani me nafi owabana oke. Oko meba me onihawawitiabanake, ofeya me sokiki na me toha, kabirita me hani kobobo na me toha na mati. Afa oko yama ahi ni manakoneboneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yama toyabo ya yama nihinahaboneke tiwa ni ya, owehene tiwatoaba tiwa. Oko bani me tiwahabone tike. Ofeya me sokiki na me amara me toha, kabirita me hani watara me toha na me tiwi ya owehene hiyara tiwatoabone tike. Tika bani me obotihamone tinahabone tike fahi\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","\"E, tiwati amosake owa ni ya\", Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Fara yama wehe ya Rabao bani mera tonihawahawitimatamonaka, ofeya me sokiki na me toha, kabirita me hani kobobo na me toha na mati, fara hinaka mebone mati. Ati ehene biti bani me me narifemetemoneke, afa mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Faya Rabao Yako kakose tokehimatamonaka. Yaka ne ka yama wehe terei nemetemoneke kobo nebonaha yama kabani one ya. Yako bani me one narifematamonaka Rabao ka bani me one, me tohakosa mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Faya Yako awa ini afe kiha baka nematamonaka, sobo toha, ametoera toha, baratano toha naro. Atari mese sosowe karaba hina hani nehemetemoneke sasawa naro. ");
INSERT INTO jaa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Awa ini taba nematamonaka bani me ka faha fafawa beheri ya, bani me nokosi ya. Bani faha me fawa me kahiwa ni ka Yako ehene e nematamonaka ahi. ");
INSERT INTO jaa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Awa ini nokosi ya bani me kahiwi ka me ka matehe wataha me hani nehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Bani mera ebe kanematamonaka, ha ya bani fana toharawa ha ya bani makiti me toha nabone mati. Bani me hani naha mera nanahomatamonaka haha bani fana nokosirawa ya, me hiwarawabonehe. Faya me ka matehe wataha me hani nabisemetemoneke. Bani me hani naha mera tonihawahawitimatamonaka, Rabao ka bani me ya me tabarabone mati, hinaka mebone mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Bani me kita me nokosi ya Yako awa ini taba nematamonaka me ka faha fafawa beheri ya. Faya me kahiwemetemoneke awa ini wati beheri ya me kita mati. ");
INSERT INTO jaa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Haha bani me kitara me nokosi ya awa ini taba rematamonaka. Makoni bani me kitara Rabao mera iha, bani me kitaha mera Yako iha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ehene e ne honawematamonaka. Hinaka ofeya me tama, hinaka kabirita me tama, hinaka yama aahi me tama, hinaka yama aahi fanawi tamarawa, hinaka kamero me tama, hinaka someto me tama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yako Rabao biti me ati tamine mitehimatamonaka, me ati e na mati ahi: \"Yako e ka abi ka yama nafi ihawaka waha. Yako honawaka e ka abi ka yama ihawahari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yako Rabao ehene awehimatamonaka bisa, he nofi yokana tohamarahari. ");
INSERT INTO jaa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Manakobote Teoso Yako hiyarematamonaka. \"Tikamahi abi me tabori ya, tika one me wini ya. Osawiabana oke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Faya Yako fati ati narawematamonaka, Hakeo ya Reya famaharo, towakamakirawabonehe he ni ya yama kabani ya. Hinaka bani me ya tabematamonaka yama kabani ya, ofeya me toha, kabirita me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Faya towakamakirawemetemoneke fahi. Kobo karawa ati yana nematamonaka. \"Te ka abi owahara oke owa nofi yokana tohamarahari. Teoso ta sawi fare tohaka owa ni ya, okobi ka Teoso. ");
INSERT INTO jaa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Owehene te watoke, yama ahi ni onafia owa, te ka abi ka yama. ");
INSERT INTO jaa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Owa keyehi tamaka. Oko yama ahi ni manakonebone tonihawahi tama, ka. Yama nawaha ya owa hiri kanebona ati ne yama nawaha kakerarake owa ni ya Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Taiti ya ati e nemari amaka ahi. 'Bani me hani kobobo na tika yama ahi ni manakonebone me amake'. Faya bani me ka matehe wataha me hani kobobo namaro me amake, me nafi. Manakobisa yama one ya ati tohawemarika, 'Bani me hani kawaha tika yama ahi ni manakonebone me amake', ati nari. Faya bani me ka matehe wataha me hani kawahamaro me amake, me nafi. ");
INSERT INTO jaa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Yama e na ihi te ka abi ka bani me ohawahara oke Teoso ehene\". ");
INSERT INTO jaa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","\"Yama wehe one ya bani me kahiwi ka yama ya owatamihara oke. Bani me makiti owahara oke, me kahiwa mati, me hani kobobo na mati. ");
INSERT INTO jaa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Teoso nanarifa owa ha nareka owini itihari. 'Oha oke ahi', onahara oke. ");
INSERT INTO jaa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","'Yama tiwahi. Bani me nafi hani kobobo ke, me makiti, me kahiwa mati. Owehene amake ha owa, Rabao ehene owi karo, yama nawaha ya tiwa hiri kanebona ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Teoso ama oke. Efe ama oke aya okehamaro owa tiwa ni ya ahi Beteo ya. Yati tinawamaro ama tike fahi oko yatibonehe. Yati mese ya orifa fehe sika tinisamaro ama tike. Tiwehenebone tikaminahamaro ama tike fahi. Tika yama hawa tinihahi, tikamibeya fara tiwati ka tabora ya. Tisawimarabone tike ahi', Teoso nanarifa ati nareka oko wata ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","\"Yama hasi naba wataraboneke ota ka abi ahabe ya, ota ka yamabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bara me fanawi nima ota na otake he ni ya. Otara ta nemari amaka yama manakonebonehe. Yama manakone wara tone yama manakone katomareka. ");
INSERT INTO jaa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ota ka abi ka yama Teoso yabareka tamaharo. Afa yama ota ka amake, ota ka matehe ya ota tabaha ota. Makoni Teoso yama hikamina nafi hiri tinahabone tike\", me ati nemetemoneke, Hakeo ya Reya me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yako yama hawa tonihematamonaka tokomebonaha Kanaha ya, bati Isaki taboro ya. Ati ehene fati toharawa biti me toha na me naoriemetemoneke kamero me mese ya. Hinaka yama nafi hikiha yoro tokaniwame yana tone tokomematamonaka. Hinaka bani me nafi towakama nematamonaka me hihaha mati, yama ahi ni manakone, sawihari Mesobotamia ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Hakeo bati Rabao tohe sawihimatamonaka yama one ya, hinaka ofeya me kone sowe nari. Yama one ya tohe hinaka yobe ka yama kanamori Hakeo hibotiemetemoneke, teoso me one kanamori. ");
INSERT INTO jaa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yama e nemetemoneke ahi. Yako Rabao warabo kaminare tokomematamonaka Rabao keyehari, Rabao Arami ka me ka owa toahari. ");
INSERT INTO jaa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yako Rabao ya fami nofamare tokomematamonaka hinaka yama nafi towakamahari. Kariwematamonaka faha ini Eofarati tohaha ya, tokomebonaha Siriati ka yati nemeha si toni ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yama wehe terei na ahaba nowati ya Yako tokome tamine Rabao mitehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Rabao me one yoro tokaniwame Yako tonakamakimatamonaka. Yama amo ni seti ni ya Yako towasimakimatamonaka ahi Siriati ka yati nemeha si toni ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Afa yama soki ya Teoso hiwa namohimatamonaka Rabao watari ya, Rabao Arami ka me ka owa. \"Tiwa tekatomahi. Yama hiyara ya Yako hiri tikarabone tike\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Siriati ka yati nemeha si toni ka yama ya Yako ma toname winehino Rabao hiwasimakimatamonaka. Faya Rabao me one ya tabe wina nematamonaka Yako me wini beheri ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","\"Himataba owa tikeyerini? Himataba okoto tekamarawarini, yama e mowa na me fanawi e towakamaha nima tina tiwa? ");
INSERT INTO jaa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Himataba owa tikeyerini tikamaba owa tihiyarara tiwa? Owa tihiyaremenehe ayaka hiri onehene ama oke, tikamiba ka ayaka. E yayai nene e amake, e ayaka e, batero teo ni moni toha, rira ati toha na ya e ayaki tabaha e. ");
INSERT INTO jaa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Himata nima tiwehene rini owa ni ya? Okanoti me komi onakirihi okoto me komi onakirihi onahara oke tikamani tiwehene. Yama e watora ehene nima tiwehene nineke. ");
INSERT INTO jaa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tera okatomehene ama oke. Haha yama soki ya abi ka Teoso owa hiyare ati e nareka ahi: 'Tiwa tekatomahi. Yama hiyara ya Yako hiri tikarabone tike', ati nareka. ");
INSERT INTO jaa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tiwa owatoara oke, titaboro wati tiwaha tikama tiwa. Himataba oko yama kanamori tibotirini oko yobe ka teoso me kanamori?\" Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","\"Tiwa onakomehara oke. Tikoto tiyabamakirawabone onahara oke owa ni ya. Makoni tiwa hiyari onofarara oke. ");
INSERT INTO jaa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tika yama kanamori tiwasi ya ota ka owa ni ya efe yama kanamori tama neno ahabebonaka. Tika yamani siba tinahi. Tiwa ota kakatomabone otake. Tika yamani tiwasi ya tekamaboneke\", Yako ati nematamonaka. Hakeo ihi Yako watorematamonaka, bati ka yama kanamori botihanihi. ");
INSERT INTO jaa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Rabao tokiyomematamonaka Yako ka yobe toro ya. Tokiyoma nematamonaka Reya ka yobe toro ya. Tokiyoma nematamonaka Reya me ka yama aahirawa ka yobe toro ya. Yama kanamori wasirematamonaka. Faya tokiyomematamonaka Hakeo ka yobe toro ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Yama nafi ya yama siba ne yama kanamori wasirematamonaka. Hakeo yama kanamori nakibiemetemoneke fara iitari ya kamero mese ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","\"Abi owa tikakorabone tike yana ora owa owa owama owa\", Hakeo ati nemetemoneke. Makoni Rabao yama kanamori siba ne yama kanamori wasirematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Faya Yako Rabao hora nematamonaka fahi. \"Himata yama hiyara amari hiri onaharo? Himata nima owehene rini, owa tikiyo karo, owa tikakoa tiwa? ");
INSERT INTO jaa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Oko yama nafi siba tina tika yama tiwasiha tiwa awine ti? Tiwasi ya tinamoaboneke e nafi nokosi ya, oko one me hiwa, tika one me hiwa, hinabonehe. Era me watowahaboneke. Owati amosi ya amosa, tiwati amosi ya amosa namone me ati naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tika yama ahi oni ka ano 20 namaro amake. Afa yama ya bani biti ahabeba wataremari amaka mati tori ya, tika bani mati. Tika ofeya okobarihi onamaro ama oke. ");
INSERT INTO jaa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Yama kabani ka bani tika bani me me waka na me abohi owakamatera ama oke tiwa ni ya. Oko bani me ta onamaro ama oke tika bani me tabori ya. Tika bani me me boti ya oko bani me ta onabone tinamaro ama tike tika bani me tabori ya. Yama soki ya me me hiboti, yama wa toni ya me me hiboti hina me ihi oko bani me ta onabone tinamaro ama tike. ");
INSERT INTO jaa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yama e na hiri onamaro ama oke ahi. Yama wa toni ya yama hiwe okarima, yama soki ya yama siririne okarima onamaro ama oke. Yama soki tamaha ya amo orihi onamaro ama oke. ");
INSERT INTO jaa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tiwa ni ya osawi ka ano 20 namaro amake. Oko yama ahi ni ka ano 14 namaro amake, tikoto famarawa manakonebonehe. Oko yama ahi ni one ka ano sei namaro amake, oko bani mebone me okihabone owa. Oko yama ahi ni manakonebone tonihawahi titama tinamaro ama tike. ");
INSERT INTO jaa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Teoso sawihimari amaka owa ni ya, okiti me ka Teoso, Abaraao ka Teoso toahari, Isaki ati hikataba hinahari. Owa ni ya Teoso sawiremanaha oko hinita tokomene ama oke owa tiyosemi ya. Oko yama nawaha Teoso awa, oko yama ahi ni amosa awa, ne ka yama hawa tonihareka yama soki ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","\"Haha okotorawa amake haro. Haha okanoti me amake bisa. Haha oko bani me amake. Yama tiwaha oko yama nafi amake. Yama owato oke, okotorawa kasawimarawariba ka yama owa ni ya. Me ka matehe sawimarihi naboneke owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Makoni e abe nofatibone ka yama e hiri nabone eke e famaha e. Yati ibe e ta toniharehaba eke haha yama e kamina e wati nawahatibone karo yama toyabo ya\", Rabao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Faya Yako yati ibe nemeha nawehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Faya ati ehene hinaka one yati ibe me iso nawahamehemetemoneke, me ta hiniharehabonehe. Afa beheri ya me mari nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Rabao yama inibone nawatematamonaka, Seka-Satota tohahabonehe. Yako ini hinawatemetemoneke bisa Kareheti tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","\"Haha yati e ta tonihareha e awi ka e famaha e abe nofatibone ka yama e wati nawatehabone eke\", Rabao ati nematamonaka. Makoni yama inimetemone amake Kareheti tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ini one Misiba toha nemetemoneke Rabao ati kaminaro, ati e nari ahi: \"Teoso era awehibonaka e abe ebe kana e. ");
INSERT INTO jaa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Okoto me hiri tikarabone tike yama hiyara ya. Fanawi one titirihi tinahabone tike. Yama e na hiri tini ya tiwa owarabone oke. Teoso ta tiwa awebonaka. Tiwati katamoriyahi Teoso ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Yati ibe wa, yati one ta tore narake owehene. Afa kowani one ya tiwina, kowani one ya owina onabone oke. ");
INSERT INTO jaa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Yati ibe wa yati ibe one ta tore na e awi ka e abe nofatibone ka yama e wati nawahatehabone eke. Afa yati ibe fiya okarabone oke tiwa mowa onahaba owa. Yati ibe fiya tikarihi tinabone tike owa mowa tinahabone tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abaraao ya Nao famehi ka Teoso e ehene awehibonaka, e ehene amosi kaminebonaha\", Rabao ati nematamonaka. Faya Yako ati yana nematamonaka Teoso ino itihari, ati tohawarebona ati nari, efe Teoso ati Isaki hikatabehimata. ");
INSERT INTO jaa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yako bani nabowe bani ta nematamonaka Teoso ni ya afa atami ya. Hinaka one mera ha nematamonaka me mari nabone mati. Afa yama soki ya me tafa me amo nemetemoneke atami ya. ");
INSERT INTO jaa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Yama wamini ya Rabao bosa nematamonaka. Bite komi nakikimarawa hinaka noti mera komi nake nematamonaka. Teoso yahehibona ati nematamonaka afa me ni ya. Faya tokomematamonaka fare taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yako tokomawahe Teoso nanarifa me kobo hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yako Teoso nanarifa mera awe ati yana nematamonaka. \"Haha yama Teoso wini amaka\". Makoni ini hinawatehemetemoneke Mahanai tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yako mera yosehimatamonaka Sei ya, Esao me kobo ni ya he ati me kaminabone mati. Sei ini onemetemone amake Eto tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He ati me kamina me ati e nabone ati nematamonaka ahi: \"Yako ama oke. Tiwati yana ni ya tiwa onarifabone oke. Ano tamaha ya owinamaro ama oke Rabao taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yama tamaha okiha oke, bowi mati, someto mati, ofeya mati, kabirita mati, yama aahi mati, yama aahi me fanawi tohaha me toha na mati. Owati me kaminabone me oyosehara oke owa tinofibone karo\". ");
INSERT INTO jaa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Esao me kobo na me kamehemetemoneke Yako ni ya. Yama me kaminemetemoneke Yako ni ya. \"Esao ota kobo na otake, efe ayo. Kamakiareka tiwa kobo nebonaha, me makiti 400 me tohaha me ya tabahari\". ");
INSERT INTO jaa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yako me ati mite kokoriri nematamonaka. Faya mera ebe kanehimatamonaka, ha ya me tohikimahabone mati, bani me ya me kataba mati, ofeya me toha, kabirita me toha, bowi me toha, kamero me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yako ati boti e nematamonaka ahi: \"Esao kamaki ya haha mera nahabi ya haha me hasi naboneke, me one\". ");
INSERT INTO jaa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Manakobisa Yako Teoso ha nematamonaka. \"Teoso owati timitahi, okiti Abaraao ka Teoso tiwa, okobi Isaki ka Teoso tiha tina tiwa. Owa tiyosemahara tike okomabone owa ahi otaboro ya, oko one me tabori ya. Oko yama amosabone tinahara tike. ");
INSERT INTO jaa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tiwa nanarifa ama oke. Owa ni ya tiyahate ama tike, owehene amosaba watara owa. Owa ni ya tiwehene amosa fawa tera ama tike. Sotao ya okariwaha awa ta tama ni owaharihamaro ama oke. Okoma me tamaha me ya otabawaha oke, me tohikima mati, bani me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Teoso owa hasi tinihahi. Esao owa nabowarayaho, kamaki ya. Me fanawi waka matehe waka rayaho. ");
INSERT INTO jaa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Teoso tiwati wati tiwahabone tike, oko yama amosabone tina tiwa. Okanoti me tamatehabone tinahara tike, siki boni nima me na mati, me tomi kanihinara mati\", Yako ati nematamonaka, Teoso ha nari. ");
INSERT INTO jaa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Afa yama soki ya Yako amo nematamonaka fahi. Faya bani mera wasihi bani mera tonihawahawitimatamonaka me ta hinahabone mati Esao ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Kabirita fana 200 toharawa, maki 20 me toha, ofeya fana 200 toharawa, maki 20 me toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kamero fana 30 toharawa nemetemoneke biti me ya katabarawaro yoa fehe me fawasa na mati. Bowi fana 40 toharawa, maki 10 me toha, someto fana 20 toharawa, maki 10 me toha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Afa bani mera Yako ebe nematamonaka ha ya me tohakanikima nabone mati. Hinaka yama aahi me oohariki na mera ebe nematamonaka bani me ya me tababone mati. Faya mera yosehimatamonaka. \"Te tai toamahi bani me ya te tabaha te. Te ka owa bani me ya tabe tai toe owa yotoba nebonaka, bani me one ya tabahari. Fara me nima me one naboneke me yotoha mati\". ");
INSERT INTO jaa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Taiti tohehibona Yako hihiyarematamonaka. \"Okoyo Esao tiwa kobo ne ya tiwa aate neba amaka. 'Hike amara tika hiti? Hibaka tikaribe? Hibake ka bani me amari, me tekama mati?' ati neba amaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Faya tiwati e nabone tike ahi: 'Tiwa nanarifa Yako tohehi ka bani me amake. Me ta hinahabone me hinarake hinaka hiti Esao ni ya. Kamakiareka hike ya', tinahabone tike\". ");
INSERT INTO jaa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Faya hinaka yama aahi me one hiyara nematamonaka, bani me one ya me taba mati. \"Esao te kobo ni ya fare taiti ati nima te ati nabisabone teke. ");
INSERT INTO jaa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Te ati katamorabone teke yama te kaminabone te e naro ahi: 'Tiwa nanarifa Yako tohehi kamakiareka hike ya', te ati nabone te\". Yako ati boti e nematamonaka ahi: \"Bani me ta ona onokosi ya me tai toa Esao mera awe ati somawameba awaka. Faya owa kobo ne ya owa kakomareba awaka\". ");
INSERT INTO jaa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yako ati e ne bani mera tai tonihamematamonaka, me ta hinahabone mati Esao ni ya. Fare wai ka yama ya amo tasehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Afa yama soki ya Yako yana tone kariwematamonaka faha Saboki tohaha ya. Fati famarawa towaka, fati one famarawa towaka, biti me 11 na mera towaka nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Faya ati ehene hinaka bani me nafi me towakemetemoneke fa kowani ya. ");
INSERT INTO jaa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ohari yotohimatamonaka. Inamati kake mono hinehimatamonaka yama soki ya. Mono ni kawahematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Inamati Yako kasawarihibona ati ne Yako kasawari watore he fanako nabowehimatamonaka. Faya fanako tone fiya tonehimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Faya inamati ati yana nematamonaka. \"Owa sa tisahi. Yama we kamakike\". \"Tiwa sa tosi onofa okere. Tiwati yana ni ya oko yama amosabone tini ya tiwa sa osabana oke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","\"Tiwinira?\" inamati ati nematamonaka. \"Yako ama oke\". ");
INSERT INTO jaa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","\"Yako tiwini tohamarabana tike. Teoso mono, tika one me mono, tina tiwehene me kitararake. Makoni tiwiniboneke haro Ihayeo tohaharo\", inamati ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","\"Tiwinira ha tiwa?\" Yako ati nematamonaka. \"Himataba owini miti tabiyo tiwa?\" inamati ati nematamonaka. Faya Yako ka yama amosabone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Faya Yako ati yana nematamonaka. \"Teoso noko owa, onoko awa, ne ohaba okere. Yati oke\". Makoni yama ini nawatematamonaka Benieo tohabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bahi kamaki ya Benieo ya Yako yana tone tokehimatamonaka. Nowa nematamonaka fanako tone fiya tone ehene, inamati fanako hinabowahari. ");
INSERT INTO jaa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Makoni ihayeo me nafi bani fanako ime me kabatera me amake, Yako fanako inamati nabowamatamona karo. ");
INSERT INTO jaa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Faya Yako Esao awehimatamonaka kakehari ayata ya, makiti 400 me tohaha me ya tabahari. Faya biti mera ebe kanematamonaka. Reya fara biti me ya taba, Hakeo biti ya fama, me ka yama aahirawa ka matehe ya tabarawa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Me ka yama aahirawa ka matehe ya tabarawa me tai toa me nowati ya Reya biti me ya tabaha yotoha nowati ya Hakeo Yose ya fama yoto nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Manakobote Yako fiya tonamake tai toawamematamonaka me nafi nokosi ya. Yaka ne iso yobati ya itarise itarisi 7 nematamonaka, noko bako towarisahari wami ya. Faya kobo nematamonaka Esao wai yabore ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esao noki hirehimatamonaka. Kana ni kakehimatamonaka Yako kobo nebonaha. Faya Esao Yako hitiri nematamonaka. Mano kawitematamonaka he namiti ya. Komi hinaki hinehimatamonaka. Me fami ohi nikimehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Faya Esao noko tokikime me fanawi awa, matehe awa nematamonaka. Faya ati yana nematamonaka. \"Hibake me amari haro me ya titabi ka mati?\" \"Haha okatao me amake, Teoso yahe me ta hina mati owa ni ya, tiwa nanarifa oha owa\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Faya yama aahi biti me ya tabarawa Esao nokosi ya me mowi kanisarawemetemoneke ayata ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Faya Reya biti me ya tabaha me mowi kanisatasemetemoneke Esao nokosi ya. Faya Yose mati Hakeo ya fame me mowi kanisa nemetemoneke Esao nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","\"Haro bani mati. Hibake ka bani me amari me kobo ona mati hawi ya?\" Esao ati nematamonaka. \"Afa bani me ihi owa tinofabone onara oke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","\"Niso oko yama tamabisake. Tika yama hine tikihabisa tike\", Esao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yako Esao ati nofarematamonaka. \"Tiwati e rima na fahi. Owa ni ya yayai tini ya bani me wara tinahabone tike. Tinoko owa Teoso noko owaha nima one oke, tiyahi karo owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Owati nima tinahi. Bani me wara tinahi, me owakama mati, me ta onabone mati tiwa ni ya. Owa ni ya Teoso yahe ka oko yamabone ta nareka onofaro\", Yako ati nematamonaka. Yako ati fawa re ehene Esao ati amosematamonaka waha. ");
INSERT INTO jaa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Faya Esao ati yana namatasematamonaka. \"Hima e tokomahi. Tai oamabone oke\". ");
INSERT INTO jaa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","\"Oko hiti matehe kitara me tiwato tike. Bani me wati owaha one oke, me ka matehe fotara mati, ofeya me toha, bowi me toha na mati. Me yaka ni kitahabone me e ati ni ya me ahabariyahi me nafi. Me kitaraboneke yama wehe oharia ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yama amosaboneke oko hiti tai toame ya, onokosi ya tiwa nanarifa oha owa. Bani me toha matehe toha na ya otaba yayaka tosi onabone oke tinowati ya. Faya yama totoyabo kawahi ya ota kobo nabone otake titaboro ya Eto ya\". ");
INSERT INTO jaa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","\"E, amosake. Oko yama aahi me one osekosabana oke tiwa ya me tababone mati\", Esao ati nematamonaka. \"Me ya ota tabarabone otake. Owa nofi oko hiti oharibonaka\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Fara yama wehe ya Esao tokomematamonaka fare nowati ya Eto ya. ");
INSERT INTO jaa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yako tokabisehimatamonaka Sokoti ya. Hinaka yobebona hiri nematamonaka fahi. Bowi me taboribone hiri nematamonaka. Makoni yama ini me nawatemetemoneke Sokoti tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Faya Mesobotamia ya Yako yana tone kamematamonaka Kanaha ya. Kobo nami amosematamonaka sitati Sike ya. Faya hinaka yobebona hiri nematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Manakobote wami kote kanikematamonaka Amo biti me ni ya, Amo Sike bati tohahari. Faya hinaka yobebona hiri nematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Faya tana yati hiri ni tohaha hiri nematamonaka. Tana ini nawatematamonaka Eo tohahabonehe. Ihayeo me ka teoso ino Eo tohe ino tana weye nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yama we one ya Tina Yako ya Reya me fama me ka inamate tohaha mera yaka nemetemoneke afa tabora ka atonarawaha. ");
INSERT INTO jaa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ifi ka towisawa Amo tohe biti inomatamona amaka Sike. Sike Tina awe hiwata ahi hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Awi taminemetemoneke he ni ya. Makoni hinofemetemoneke. He nofahabone hinehemetemoneke bisa. ");
INSERT INTO jaa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Faya bati hiyarematamonaka. \"Abi Yako aate tinabone onara oke bite kahabanehibonaha, otihabonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yako Sike tamine mitehimatamonaka, Sike yama hiyara hiri nari Yako bite ni ya, Tina toaharo. Biti bani me ya me tabaha yama kabani ya me naho ka ati watarematamonaka mata. Mera noki nematamonaka me kamahabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sike bati Amo tohe kake nematamonaka Yako hiyarebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yako biti me kobo nama hiyara me mita me hamehemetemoneke kasiro ya. Sike Yako bite ahi ne yama hiyara hiri nematamonaka ihayeo me ni ya. E ehene e na e hiri rabone eke ahi. ");
INSERT INTO jaa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amo ati yana nematamonaka. \"Okatao Sike tohe te ka inamatewe nofaka kasiro ya. Te kahabanahaboneke hitihabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","E yoro tokanaba eke waha. Ota ka one me te tohahaba teke waha. Te ka matehe ota yaba, ota ka matehe te yaba, nabisaba teke. ");
INSERT INTO jaa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Te sawihi ahi ota ni ya. Te winahabone teke ahi. Wami te nofa te kanikabone teke. Yama te ta, yama te kanika, nabone teke ota ni ya\", Amo ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sike ati yana nabisematamonaka Tina bati ni ya, Tina anoti me toha na me ni ya. \"Owati nima te nabone teke. Yama te nofaha ta onahabone oke te ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Yama te nofaha ini te kaminabone teke. Atona manakonebone te itihabone teke, manakone ta onabonehe. Te ati hiyara watarabone teke. Te kahabanahaboneke, otihabonehe\", Sike ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yako biti me ka asima ni ya Sike yama hiyara hiri ne ka me me keyehemetemoneke, me me hiyara mati, Sike bati ya famahari. ");
INSERT INTO jaa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","\"Ota ka asima ota ta nene ota amake. Hahi sowiri ataro kote wisi nakosare ota ka asima itirebonaka. Yama e na kokoma kihake ota ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Te makiti nafi sowiri ataro kote wisi ni ya ota nima te ni ya ota ati amosabone otake fahi. ");
INSERT INTO jaa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ota ka matehe te yaba, te ka matehe ota yaba nabone otake fahi. Faya ota winahabone otake te ni ya, e yoro tokana e. ");
INSERT INTO jaa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Te ati hiyari ya te sowiri ataro kote wisi ni te nofari ya ota tokomabone otake, ota ka asima ota towakama ota\" Yako biti me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Faya me ati amosemetemoneke Amo biti ya famahari. ");
INSERT INTO jaa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Hibati ya Sike sowiri ataro kote me wisi nakosemetemoneke, Yako bite nofahari kasiro ya. Sike me nonofa hihehimatamona amaka mata ya sitati ka mati, Amo biti me one me me nonofa raba na mati. ");
INSERT INTO jaa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Manakobisa Amo biti ya fame me towakamehemetemoneke sitati ka nokobi wani ka yama ya, me ka heoniao hihiri ka yama ya. Me one me me hiyaremetemoneke sitati ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","\"Haha otara me nofake. Me e nawinabanake e taboro ya, yama me ta, yama me kanika, na mati. Me taboribone nake, me ka wamibonehe. Me ka matehe e yaba, e ka matehe me yaba, nabisaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Me ati e narake ahi: e ka makiti sowiri atari kote wisi naboneke, fara me nima e nabone e. Yama e na e hiri ni ya me winaboneke e ni ya, e nafi yoro tokana e. ");
INSERT INTO jaa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Me ka bowi me nafi e ihawahaba me awineke, me ka yama nafi toha naro. E ati amosi ya me winahaboneke e ni ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Faya me ati amosemetemoneke. Me sowiri atari kote wisi nemetemoneke, me hohorawa raba na mati. ");
INSERT INTO jaa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Faya yama we terei na ahaba nowati ya yama komasa nemetemoneke me ni ya. Faya Yako biti me famaha me towakiyomemetemoneke sitati ya, me me hiwara mati, Simiao ya Refi me fama mati, Tina anoti mati. Yimawa ehebote me tama nikima me makiti nafi me me waka nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Amo ahaba Sike ahaba nematamonaka. Faya Simiao ya Refi me famaha Tina me totimakemetemoneke Sike ka yobe ya. Faya me tokomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Me nahabi nowati ya Yako biti me one yama me botihemetemoneke yama manakone fotaharo sitati ka yama, me ka asima manakone me awa mati. ");
INSERT INTO jaa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bani me me towakamemetemoneke, ofeya me toha, kabirita me toha, bowi me toha, someto me toha na mati. Yama nafi me towakama nemetemoneke sitati ka yama, sitati beheri ka yama toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Yobe ka yama nafi me yabehemetemoneke yama manakone fotaharo. Me fanawi me wata, matehe me wata na me me towakamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Manakobote Yako Simiao ya Refi me fama mera hiyarematamonaka. \"Owa te yokohaba te amake. Te ehene owa me kakoaboneke, Kanaha ka me toha, berisi me toha, me one toha na mati, me winaha mati ahi, me nafi. E tamakere. Me nafi yoro tokana me kaki ya era me mowa ni ya e nafi ahababone eke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","\"Ota ka asima hiri karaboneke yama hiyara ya. Me ihi hiyara nafike mata ya\". ");
INSERT INTO jaa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Teoso Yako hiyarematamonaka. \"Hawa tihahi. Tikamahi Beteo ya tiwinabone tiwa fahi. Beteo ya tana hiri tinahabone tike, oko tanabonehe, efe Teoso oha owa, owa onamoamaro owa tiwa ni ya, Esao ehene kana tiwaha tiwa\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Faya Yako mera hiyarematamonaka, fara hinaka mati. Me one toha nemetemoneke, he ya me taba mati. \"Teoso bara me kanamori te kiha te were towitihi. Tera te namosahi. Makari bise watara te akahi. ");
INSERT INTO jaa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tera te hawa tonihahi, e tokomabone e Beteo ya. E kobo ni ya tana hiri onabone oke, Teoso ka tanabonehe. Efe Teoso owa kasomemari amaka yama nawaha hiri ona owa. Sawi fare tohate amaka owa ni ya fara oki ka yama ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Faya me ka teoso bara me kanamori me ta nemetemoneke. Me warabi atori toha nemetemoneke. Yako hikamoemetemoneke awa bofe ya awa waharo Sike yabori ya. ");
INSERT INTO jaa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Me yana tona me tokoma Teoso ehene me kakomehemetemoneke haro, me wina mati Sike yabori ka sitati ya. Makoni Yako me me kiyoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Manakobisa Yako me ya tabe me kobo nemetemoneke Rosi ya. Rosi ini onemetemone amake Beteo toaharo. Kanaha ka sitatimetemone amake. ");
INSERT INTO jaa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Faya tana hiri nematamonaka. Yama ini nawatematamonaka Beteo ka Teoso tohahabonehe. \"Teoso hiwa namohimarika kana owahimaro ka yama ya okoyo ehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Afa tabora ya Tebora ahabemetemoneke, Hebeka ka nanawatametemonehe. Me hikamoemetemoneke awa bofe ya, awa waharo Beteo yabori ya bahi kakamaki beheri ya. Yama ini me nawatemetemoneke awa tohahabonehe, e noko fehene ahabi ka awa. ");
INSERT INTO jaa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Faya Yako Mesobotamia ya yana tone Kanaha ya kame Teoso hiwa namotasehimatamonaka he ni ya. Hinaka yama amosabone Teoso hinehimatamonaka, ");
INSERT INTO jaa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ati e nari ahi: \"Yako tihate ama tike. Tiwini tohawabone tike. Tiwiniboneke haro, Ihayeo toaharo\". Teoso ati e ne he ino nawatematamonaka Ihayeo tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Teoso yama one kamina nematamonaka. \"Teoso Kitabote ama oke ha owa. Tikatao me tama, tika noti me tama tehaba ama tike. Tika noti me ate nahaba me amake. Tika noti me one na naba me amake, me yoro tokana mati, me winakanikima na mati tabora tamaha ya. Tika noti me one towisawa me me tohatehaba me amake. ");
INSERT INTO jaa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tika wamibone ta onabone oke, afa wami ta onahamaroho Abaraao ya Isaki me fama me ni ya. Afa wami ta otehaba ama oke tika noti me ni ya\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Yako hiyari Teoso hawa tohe tokomise fawa nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Faya Yako yati ibe iti yati ibe nawematamonaka fare Teoso hihiyare ka yama ya. Teoso ka yatibone ati ne fi sika nisa orifa fehe sika nisa nematamonaka yati mese ya. ");
INSERT INTO jaa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Faya yama ini nawatematamonaka Beteo tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Beteo ya Yako me yana tona me tokehemetemoneke. Efarata yabori ya Hakeo tori kome yana tonemetemoneke. Yama nawaha hiri nemetemoneke inamatewe watakabote re karo. ");
INSERT INTO jaa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tori kome kitamisa fanawi matehe hohoka tohaha ati yana nemetemoneke. \"Yama nakomerima tinahi. Tikatao owa namakebonaka makiti toahari\". ");
INSERT INTO jaa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hasi ni fawa nisa ahabinima na ati yana nemetemoneke, inamatewe inobona nawataro, Benoni tohehibonaha. Inobona bati hinawatabisematamonaka, Besami tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hakeo ahabi e nemetemoneke ahi. Me hikamoemetemoneke Efarata hawi beri ya. Ini one amake Bere tohaharo waha. ");
INSERT INTO jaa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yako yati ibe nawehimatamonaka Hakeo tame mese ya. Yati sawisa ke, Hakeo tame yofi kanaharo. ");
INSERT INTO jaa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Faya Yako yana tone toke hinaka yobe nawamatasematamonaka Ete ka yobe nemehe wari kowani ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yako winasa nematamonaka afa yama ya. Yama we one ya biti Hobi tohe Bira Yako fati one toha ahi nematamonaka. Yako Hobi tamine mite hamehimatamonaka kasiro ya. Yako biti me 12 nemetemoneke, me e na mati ahi: ");
INSERT INTO jaa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Reya biti taiti Hobi toha, Simiao toha, Refi toha, Sota toha, Isaka toha, Seboro toha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Hakeo biti memetemone amake haro Yose ya Besami me fama mati. ");
INSERT INTO jaa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Hakeo ka yama aahi Bira toha biti memetemone me amake, Ta toha, Nafitari toha nari, Yako biti mati. ");
INSERT INTO jaa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Reya ka yama aahi Sioba tohaha biti memetemone me amake, Kati toha, Ase toha nari, Yako biti mati. Haha Yako biti me watemetemoneke Mesobotamia ya. ");
INSERT INTO jaa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yako tokome towinamematamonaka bati taboro ya, Isaki. Sitati inimetemoneke Manere tohaharo. Ini onemetemone amake, Aba toaharo, wataharo Heboro yabori ya Abaraao ya Isaki me fama me winimete ka tabora. ");
INSERT INTO jaa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaki ka ano 180 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Bote tohe ahabematamonaka. Tokehimatamonaka e abohi taboro ya, hinakiti me ya tabebonaha. Biti me hikamomatamonaka, Esao ya Yako me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esao ka noti me e nemetemone me amake ahi. Ino owamatamona amaka Eto tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esao Kanaha ka fanawi famarawa yabarawehimatamonaka. Ata toha, Oribama toha nemetemoneke. Ata Ero bitemetemone amake, Ero ka me ka owa. Oribama Ana bitemetemone amake, Sibiao ka noti tohaharo, Sibiao heti me ka owa. ");
INSERT INTO jaa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esao Basemati iti nematamonaka, Isimayeo bite tohaharo. Isimayeo bite onemetemone amake Nebaioti toaharo. ");
INSERT INTO jaa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ata bitimatamona amaka Erifasi. Basemati bitimatamona amaka Heoweo. ");
INSERT INTO jaa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oribama biti memetemone me amake, Seosi toha, Saraha toha, Kora toha nari. Afa memetemone me amake, Esao biti mati, me wataha mati Kanaha ya, Esao winahari Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Manakobote Esao tokehimatamonaka yama one ya hinaka me ya tabahari, fati toharawa, biti me toha, bite toharawa, hinaka yobe ka me one toha na mati. Nisori Yako wini ya wini famamarematamonaka tokahari yama one ya. Hinaka yama nafi towakematamonaka hiwasiaro Kanaha ya, ofeya me toha, kabirita me toha, bowi me toha, yama one toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esao ya Yako me famaha me ka bowi me tami ka me wini famamarabone me ati nemetemoneke, yama kabani nafiri karo. Makoni Esao banehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esao toke winehimatamonaka Sei ka yati nemeha si toni ka yama ya. Esao ino owamatamona amaka Eto tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esao ka noti me e nemetemone me amake ahi: Eto ka me ka itimatamona amaka Esao, me wina mati Eto ka yati nemeha si toni ka yama ya. Eto ini onemetemone amake Sei tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esao fati Ata tohaha bitimatamona amaka Erifasi tohahari. Erifasi biti me siko nemetemoneke, Tema toha, Oma toha, Sefo toha, Kaeta toha, Kenasi toha nari. Erifasi fati one fati yokana amara bitimatamona amaka Amareki tohahari. Esao fati one Basemati toha bitimatamona amaka Heoweo tohahari. Heoweo biti me kowato nemetemoneke, Nahati toha, Sera toha, Sama toha, Misa toha nari. ");
INSERT INTO jaa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esao fati onemetemone amake Oribama tohaharo. Oribama Ana bitemetemone amake, Sibiao ka noti tohaharo. Oribama biti memetemone amake, Seosi toha, Saraha toha, Kora toha nari. ");
INSERT INTO jaa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esao ka noti me ate inimete amake haro, Temaha toha, Oma toha, Sefo toha, Kenasi, Kora, Kaetaha, Amareki toha naro. Afa Esao biti taiti Erifasi tohe ka noti me ate inimetemone amake. Esao fati Ata tohaha ka noti memetemone me amake. ");
INSERT INTO jaa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reoweo ka noti me ate inimetemone amake haro, Nahati toha, Sera toha, Sama toha, Misa toha naro. Afa Esao fati one Basemati tohaha ka noti memetemone me amake. ");
INSERT INTO jaa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esao fati one Ana bite Oribama tohaha ka noti me ate inimetemone amake haro, Seosi toha, Saraha toha, Kora toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Afa Esao ka noti me ate nafi inimetemone amake. ");
INSERT INTO jaa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Eto ya ho me wiwina tohehemetemoneke baha. Ho me ka owa inomatamona amaka Sei tohahari. Sei biti me inimetemone amake haro, Rotaha toha, Sobao toha, Sibiao toha, Ana toha, Tiso toha, Ese toha, Tisa toha nari. Afa me ka noti me ate ka me wiwina tohehemetemoneke Eto ya. ");
INSERT INTO jaa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Hori ka noti me toha, Homaha ka noti me toha na me wiwina tohehemetemoneke Eto ya. Rotaha ka noti memetemone me amake, Hori toha, Homaha toha nari. ");
INSERT INTO jaa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Arafaha ka noti me toha, Manahati ka noti me toha, Ebao ka noti me toha, Sefo ka noti me toha, Onaha ka noti me toha na me wiwina tohehemetemoneke Eto ya. Afa Sobao ka noti memetemone me amake. ");
INSERT INTO jaa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiao biti me famehemetemoneke, Ayasi ya Ana me fama mati. Efe Ana faha hiwaha wasihimatamonaka yama honari ka yama ya, bati ka someto mera narifari. ");
INSERT INTO jaa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana biti inomatamona amaka Tiso tohahari. Tiso ka noti me inimetemone amake haro, Henetaha toha, Esibaha toha, Itaraha toha, Kera toha nari. Afa me ka noti me wiwina tohehemetemoneke Eto ya. Ana bite inimetemone amake Oribama tohaharo bisa. ");
INSERT INTO jaa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ese ka noti memetemone me amake Biraha toha, Sahafa toha, Akaha toha nari. Afa me ka noti me wiwina tohehemetemoneke Eto ya. ");
INSERT INTO jaa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tisaha ka noti memetemone me amake, Osi ya Araha me fama mati. Afa me ka noti me wiwina tohehemetemoneke Eto ya. ");
INSERT INTO jaa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ho me ate inimetemone amake haro, Rotaha toha, Sobao toha, Sibiao toha, Ana toha, Tiso toha, Ese toha, Tisaha toha naro. Afa me ka noti me wiwina tohehemetemoneke Eto ya. ");
INSERT INTO jaa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Eto ka towisawa me e nemetemone me amake ahi, me me yoseha mati, ihayeo me ka towisawa me watari ya mata. Towisawa me tohawa nemetemone me amake. Bera taiti tohematamonaka, Beo biti tohahari. Sitati Tinaba kamatamona amaka. Manakobisa Sobabi tohamakehimatamonaka, Sera biti tohahari. Bosira kamatamona amaka. Hosaha tohamaketasematamonaka, Temaha kari. Hatati tohamakematamonaka Betati biti tohahari. Sitati Abiti kamatamona amaka. Mitiha ka mera mowa ne mera nahabimatamonaka Moabi ya. Samara tohamakematamonaka, sitati Masereka ka tohahari. Sao tohamake nematamonaka Heoboti ka tohahari, faha Eofarati toha witi ka Heoboti. Bahao-Hanaha tohamake nematamonaka, Akibo biti tohahari. Hatati tohamake nematamonaka sitati Bao kari. Efe fati inimetemone amake Metabeo tohaharo. Metabeo Matereti bitemetemone amake, Mesahabi ka noti tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esao ka noti me ate inimetemone amake haro: Timina toha, Aofa toha, Sateti toha, Oribama toha, Era toha, Bino toha, Kenasi toha, Temaha toha, Mibisa toha, Makitieo toha, Irao toha naro. Afa ka me wiwina tohehemetemoneke Eto ya. Fara me ate ini nima Eto ka wami kote ini nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yako wiwina tohehimatamonaka Kanaha ya, fare bati wiwina tohamatamona ka Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yako me taminemetemone amake haro. Yose ka ano 17 tohi ya bani mera narifematamonaka, ofeya me toha, kabirita me toha na mati. Anoti me ya tabehimatamonaka bani me me narifa mati, Bira biti me toha, Sioba biti me toha na mati, bati fatirawaha. Yose anoti me ihi hiyaramone me ihimone kakamina tohehimatamonaka bati ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yako bote tohe ya Yose watehimatamona amaka. Makoni Yose nofehimatamonaka mata ya, biti me one nonofa rama nari. Yako ati ehene makari me hiri nemetemoneke Yose ka makaribonehe, yaboharo, mani kayabo naro. ");
INSERT INTO jaa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yako Yose nofi mati tohe me awehemetemoneke mera nonofa rama nari. Makoni Yose me nofamarehemetemoneke. Me hihiyarehimatamonaka katoma ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Yama we one ya Yose watami watari kaminematamonaka anoti me ni ya. \"Owati te kamitahi. Oko wata okominibeya. E watari owahara oke e nahoha e fatara ya. Tiriko tabi e soki na oko tiriko tabi waharake. Te ka tiriko tabi moto kawahamarake oko tiriko beheri ya. Te ka tiriko tabi mowi kanisarake oko tiriko tabi waha nokosi ya\", Yose ati nematamonaka. Yose ati me mita me hami kitamisehemetemoneke mata ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yose me aate nemetemoneke. \"Ota ka towisawa tihatehabone tiwa tine ti, otara tiyosetehabone tiwa? Afa ama?\" Faya kako me hikitematamonaka kasiro ya. Watari me hinofarihi, ati me hinofarihi hinehimatamonaka, watari kaminari. ");
INSERT INTO jaa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yama we one ya Yose watamitase watari kaminatasehimatamonaka anoti me ni ya. \"Owatamitasahara oke. Bahi toha abariko toha, amowa me 11 na me toha na me mowi kanisarake onokosi ya oko wata ya\". ");
INSERT INTO jaa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yose bati toha anoti me toha na me ni ya watari kamine bati hora hinehimatamonaka. \"Tika wata himata kaminineri? Ota iso yobati ya ota nahorisahaba ota ama tinokosi ya, ami toha, ayo me toha, ha owa oha ota na ota? Ota noko tokowarisahaba ota ama wami ya tinokosi ya?\" Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yose anoti me yawehemetemoneke hinaka yama nima me ka yama ra mati. Yako ta yama nima nematamonaka, Yose watari wati nawahari. ");
INSERT INTO jaa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yama we one ya Yose anoti bani me me towakemetemoneke Sike yabori ka yama ya, ofeya me toha, kabirita me toha na mati, masiri me kabahabone mati fahi. ");
INSERT INTO jaa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Faya Yako Yose hiyarematamonaka. \"Tikama mata. Tiwa oyosehabone oke Sike ya ayo me ni ya, bani me me narifa mati fahi\". \"E, okomakehabana oke\". ");
INSERT INTO jaa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","\"Tikamakehi. Ayo me tiwamakibeya bani me toha na mati. Me tamine tikaminamibeya me amosi tamine\", Yako ati nematamonaka. Heboro yabori ka yama ya Yose yana tone tokomakehimatamonaka Sike ya, Yako ati ehene. Kobo ne ");
INSERT INTO jaa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","yaka ne bare hiwe aate hinehimatamonaka. \"Himata siba tine tiri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","\"Okoyo me siba one oke. Me nahohamoneke ahi haha yama ya, bani me me narifa mati, ofeya me toha, kabirita me toha na mati. Me tokini ka yama tiwatorini?\" ");
INSERT INTO jaa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","\"Me nahomakere ahi. Me tokabone me ati narake Totaha ya, me ati omita mati\", bare ati nematamonaka. Faya Yose tokomake anoti mera siba ne mera wasihimatamonaka Totaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yose me awaba nemetemoneke kamakihari. Kobo namakimatare ya me abe hiyaremetemoneke, Yose me wati kana mati. ");
INSERT INTO jaa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","\"Te awa ha kamakihari wawatami. ");
INSERT INTO jaa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hima e nabowaho hibati ya. Abohi e koro nisehibanaka hoti ya faha hoti hinita ya. E kamine ya e ati e naba e ke ahi: 'Yama kabani ka bani hinabowe hikabenoka', e ati naba eke. Faya watari yama hikamina wataraba awineke\", Yose anoti me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Hobi nisori me ati mite Yose hasi nihibona ati nematamonaka, me hinabowarebonaha. \"E nabowarebonaka. ");
INSERT INTO jaa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Te ehene itirabone teke. Koro nisi te nofe ya te koro nisaho hoti ya ahi yama kabani ya. Te noho toniharebonaka\", Hobi ati nematamonaka. Hobi ati e ne Yose hasi nihibona ati boti ati nematamonaka, me hinabowarebonaha. Hiyosemehibona hinematamonaka me ka abi ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yose kobo namaki hinaka makari anoti me sota hinehemetemoneke, makari yaboharo, mani kayabo naro. ");
INSERT INTO jaa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Faya me hiwate me koro hinisematamonaka faha hoti hinita ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Faya me tafahabone me nahorisemetemoneke. Me tafa kamero me me awehemetemoneke me yaka na mati. Isimayeo ka noti me ka kamero memetemoneke, Siriati ya me yana tonahani mati me tokahabone mati Esito ya, yama ta nabone me weye na mati, befomi toha, yama tehe toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Faya Yota ati yana nematamonaka nisori mera hiyarari. \"E ka niso e nabowarabone eke. E nabowe ya abohi e kehemo ya himata e iharibe? ");
INSERT INTO jaa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","E nabowarebonaka. E ta nebanaka haha me ni ya Isimayeo ka noti me ni ya, yinero manakonebana. E nabowehiba e ka nisobisa amaka\", Yota ati nematamonaka. Faya me ati amosemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mitiha ka yama tata me yaka na Yose hoti ya foye anoti me hiti me ta hinehimatamonaka Isimayeo ka noti me ni ya. Manakone me ta hinehimatamonaka barata boni 20 naro. Faya Isimayeo ka noti me hekamehimatamonaka Esito ka ya. ");
INSERT INTO jaa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Manakobote Hobi tokome faha hoti towame Yose fawa ni wasihimatamonaka. Hinaka makari sibi nematamonaka yawahari. ");
INSERT INTO jaa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nisori me ni ya tokome mera hiyarematamonaka. \"Yetene foyi watamarahareka faha hoti ya. Himata hiri oribe waha?\" ");
INSERT INTO jaa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Faya kabirito me nabowa kabirito emene ya Yose ka makari me kiyo nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Makari me towakamehemetemoneke me ka abi ni ya. Faya me hihiyarehimatamonaka. \"Ota wasiharake haro. Tikatao ka makari amarini?\" ");
INSERT INTO jaa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yako hiwatohemetemoneke. \"E, okatao ka makari amake. Yama kabani ka bani hinabowehino hikabe awaka\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Faya Yako yawe hinaka makari sibi nematamonaka. Makari one akehimatamonaka, e yawaha ka makari. Yawi fawa rematamonaka biti tabiyo yawahari. ");
INSERT INTO jaa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Biti me ya bite tabarawa yawi me fawa hinihebona me hine ati hiyarematamonaka. Ati e nematamonaka ahi: \"Oko yawi fawa rabone oke. Oyawasa onahabone oke okatao kobo oni ya e abohi taboro ya\", Yako ati nematamonaka. Faya yawi fawa rematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Manakobisa Mitiha ka Esito ya me kobo na Yose me ta nemetemoneke Botifa ni ya. Botifa Esito ka towisawa ya fafamamatamona amaka, towisawa ka saotato mera yoyose tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Afa yama ya Yota yana tone tokehimatamonaka sitati Atora ya. Nisori me ya tabamarehimatamonaka. Winehimatamonaka Atora ka me ka owa taboro ya, Hira tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Atora ya wine Kanaha ka fanawi awe hitihemetemoneke, Soa bite tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Biti watehimatamonaka. Inomatamona amaka E. ");
INSERT INTO jaa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nabati weye namatasa biti owa watamakehimatamonaka. Ino hinawatehimatamona amaka Onaha tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Manakobisa biti owa watamaketasematamonaka. Ino hinawatehimatamonaka Sera tohehibonaha. Yota winehimatamonaka Kesibi ya. Faya Sera watehimatamonaka fahi Kesibi ya. ");
INSERT INTO jaa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yota biti taiti E tohe kahabanehimatamonaka Tama itihibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","E yama hiyara hihiri tohe Teoso hinabowematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Faya Yota ati yana nematamonaka, biti Onaha tohe narabo nima nari. \"Ayo fati ahi tinahi, ayo ahabari. Tiwehene e ni ya ayo fati tinarifahabone tike. Ayo biti nebonaka tiwehene\". ");
INSERT INTO jaa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onaha ati boti e nemata awaka ahi: \"Hahi inamatewe wate ya okatao amarebona me ati naboneke\", ati boti ati nemata awaka. Makoni anoti fati ahi ne sokene nanahabi tohematamonaka ha ya, anoti biti watarebonaha ehene. ");
INSERT INTO jaa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Teoso ehene hinofare hinabowematamonaka tasa. ");
INSERT INTO jaa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Faya Yota ati yana nematamonaka, Tama hiyarari, biti fati. \"Tikamamatabana tike abi taboro ya. Yama noki tinahabone tike mata. Okatao Sera tohe nafi ya titihibonaka\". Yota ati e ne ati boti e nemata awaka ahi: Sera ahabarayaho tasa, fara anoti me nima. Makoni Tama tokomemetemoneke bati taboro ya winabonehe fahi mata. ");
INSERT INTO jaa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Yama toyabo ya Yota fati ahabemetemoneke. Yota yawehimatamonaka fahi. Yawe ka abariko ahabe ya yawi fawa nematamonaka. Faya tokomakehimatamonaka Timinati ya, hinaka ofeya me kone me sowe na me ni ya. He ya fafama Hira tohehi ya famehimatamonaka, hari Atora kari. ");
INSERT INTO jaa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tama Yota tamine mitehemetemoneke tokomakehari Timinati ya, hinaka ofeya me kone sowe nebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Faya fanawi wawaha ka makari sota tona makari one akawemetemoneke. Makari e noko yoyoto kana ya noki yoto kanehemetemoneke, me hiwatorahabonehe. Faya tokomake sitati Enai ka nokobi wani ka yama ya itariemetemoneke. Timinati hawi ka sitatimetemone amake Enai tohaharo. Tama ihi e nemetemone amake ahi, Sera watoharo, yani hawa tohe Yota hikahabanarahari he itihibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Timinati hawi ya Yota yaka ne Tamani awehi fanawi hine ya me ka aahimone ati nematamonaka, noki yoto kani karo. ");
INSERT INTO jaa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Hihiyaremetemoneke hawi beheri ya, hinaka komani watorari. \"E amo ni famibana?\" ati nematamonaka. \"Yama manakone e na ta tiribe owa ni ya?\" ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","\"Tika kabiritaba ta onahabana oke yama wehe one ya, oko kabirita me ka owa\", ati nematamonaka. \"E, amosake. Tika yama tisekosahi mata, kabirita ta tinehibona kaminabana\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","\"Himata yama tinofari, osekosahabonehe?\" ati nematamonaka. \"Tika kasaro onofa oke, aneo kihi, tiwini kihaharo. Tika awa toha naboneke era tataba kana\", ati nemetemoneke. Faya hinaka yama tosekosehimatamonaka he ni ya. Ahi hina faya yama toyabo ya nabati weye nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tama tokoma noki yoto kani ka makari sota tona fanawi wawaha ka makari akawamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yama we one ya he ya tataba Hira tohe yosehimatamonaka, kabirita towakamehibonaha, aya yama hisekosa kakama nebonaha. Fanawi wasirematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Enai ka mera hiyarematamonaka. Fanawi me ka aahi tohaha me kaminabone ati nematamonaka, iitari tohahamonehe hawi beheri ya. \"Fanawi me ka aahi tohaha watatera amake ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hira kame Yota hiyarematamonaka. \"Fanawi owasirara oke. Enai ka me aate ona fanawi me ka aahi tohaha watateramone me ati narake fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","\"Hine oko yama tohake he ni ya. Era me haha kariyahi. Owati ihi kabirita tekama fanawi tiwasirahamone tinara tike\", Yota ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Abariko terei ne ahabe ya hiyara me kaminemetemoneke Yota ni ya. \"Tika koma yama hiyara hiri namoneke, fanawi me ka aahi hine tonihanihi, nabati weye nawaharo\". \"Te towakamahaboneke sitati beri ya, te sari kanahabonehe, ahababonehe\", Yota ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Faya me hiwata me hekama ati yana nemetemoneke. \"Te ati e nabone teke ahi oko koko ni ya. 'Hahi ehene onabati weye ona efe hinaka yama amake haro. Kasaro te awahi, aneo kihi. Awa te awa nahi, era tataba kana. Hike ka yama amari?' te ati nabone teke oko koko ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yota ni ya Tama ati me kamina hinaka yamamone ati nematamonaka. \"Ihi amosa awineke. Owehene ta hiyara owa awine oke. Okatao Sera okahabanabone ona okahabanarareka, hitihibonaha\", ati nematamonaka. Faya Yota ahi hinamarehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Manakobisa Tama tori watibone ka yama yabokiri ya me hiwatohemetemoneke biti me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Matehe wataha owa tai tohe mano ta tokanematamonaka. Fanawi matehe hohoka toha yehe himatomatamonaka mato mamawa na ya. \"Taiti amaka hari\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tai tohebona mano horo tonamematamonaka. Owa ta tai tohehimatamonaka. Fanawi matehe hohoka toha ati yana namatasehemetemoneke. \"Ayobona tikahitihara tike\". Faya inobona me hinawatehimatamonaka, Berisi tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Faya owa watamakehimatamonaka, yehe matohari mato mamawa na ya. Ino me hinawatehimatamonaka Isera tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yose me towakamehemetemoneke Esito ya. Isimayeo ka noti me ta hinehimatamonaka Botifa ni ya, Esito ka me ka owa. Hahi Botifa towisawa nanarifamatamona amaka. Towisawa ka yobe ka saotato me ka hitimatamona amaka. ");
INSERT INTO jaa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Teoso sawihimatamonaka Yose ni ya. Hinaka hiti ka yobe ya wine hinaka yama ahi ni nafi amosemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yose ka hiti yama watohimatamonaka, Teoso sawi ka yama, Yose ni ya. Yama wato nematamonaka Yose ka yama ahi ni nafi amosi ka yama, Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yose ehene Botifa awehi hinofematamonaka kasiro ya. Faya Yose ha nematamonaka he nanarifabonaha. Botifa ati ehene hinaka yobe ka yama nafi Yose kakatomehimatamonaka, hinaka yama nafi toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Botifa ka yama Yose kakatome hinaka yama nafi amosemetemoneke Teoso ehene, hinaka yobe ka yama toha, hinaka bani me ka yama toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Botifa ka yama nafi Yose kakatomematamonaka. Fare hinaka yama ahi namarematamonaka, Yose ehene. Hine ya tafehimatamonaka. Yose awi amosematamonaka. Yaha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Yama totoyabo ni ya Yose ka hiti fati he nofi yana tonehemetemoneke. Yama we one ya ha hinehimatamonaka. \"Tikamahi e famibeya kama ya\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yose ati hiyarematamonaka. \"Owati timitamata. Oko hiti fare hinaka yobe ka yama ahi kara, hinaka yama owakatomi karo. Hinaka yama nafi owakatomahabone owa yosehareka. ");
INSERT INTO jaa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","He nima one oke, hinaka yobe ka me oyose owa. Hinaka yama nafi tohahaboneke owa ni ya. Ha tiwa ta tiharabone tike owa ni ya, oko hiti fati tiha tiwa. Makoni yama hiyara e na hiri oriyahi, Teoso hinofaraharo\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Fara yama we nima ati nemetemoneke, he ha naro, he ya famehibonaha kama ya. Yose fare ati tohehimatamonaka ati hiyarari. Hikemeyerihi hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Yose totokiyoma tohehimatamonaka yobe toro ya yama ahi nebonaha. Yama we one ya tokiyome me one wataremetemoneke Botifa nanarifa me one. ");
INSERT INTO jaa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Faya Botifa fati Yose ka makari wara tonehemetemoneke. \"Tikamahi e famibeya kama ya\", ati nemetemoneke. Hasi nematamonaka. Kana nawahematamonaka. Tokomematamonaka yobe beri ya. Hinaka makari tohakosehemetemoneke Botifa fati ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yose ka makari tohakosa awaha ");
INSERT INTO jaa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Botifa nanarifa me one ha nemetemoneke. \"Yama te awahi haro. Ebereo oko yibote hekame otara hiri kanareka yama hiyara ya. Kiyomakehareka oko aamo tori ya, owa ahi nebona ati nari. Kiya okanara oke kita ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Oko kiya kani yana toni ya tokomareka. Hinaka makari tohakosarake oko aamo tori ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yose ka makari tonihemetemoneke, yofi hikanabonehe Yose ka hiti kame ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kame ni ya hiyara kaminemetemoneke. Fara yama hikamina kaminemetemoneke. \"Yama aahi ebereo tohehi tekamehino kiyomamakiareka oko aamo tori ya, owa ahi nebona ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Faya kiya okanara oke kita ya. Kiya okani ya tokomareka. Hinaka makari tohakosarake oko aamo tori ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tika yama aahi owa hiri kanahareka yama hiyara nafiha ya\", ati nemetemoneke. Yose ka hiti hiyara mite hamehimatamonaka kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Faya Yose wate hibehimatamonaka towisawa ka kateya ya. Faya foyehimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Foye Teoso sawihimatamonaka he ni ya. Hinaka yama amosemetemoneke Teoso ehene. Kateya kakakatoma ehene hiwe hinofematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yose ha nematamonaka kateya ya me kibeha mera kakatomehibonaha. Kateya ka yama nafi kakatomehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kateya kakakatoma ati boti e nematamonaka ahi: \"Owa ni ya yama nawahaba wataraba amake, Yose ehene amose karo\", ati boti ati nematamonaka. Teoso sawihimatamonaka Yose ni ya. Hinaka yama ahi ni nafi amosemetemoneke Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Yama totoyabo kawahi ya, Esito ka towisawa nanarifa me fama mera te nematamonaka kateya ya, me ihi hiyara mati he ni ya. Owa towisawa ka fi tata me ka hiti toha, owa towisawa ka bao hihiri me ka hiti toha nematamonaka, me kibeha mati towisawa ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Me famaha me ihi towisawa nofare hamehi ");
INSERT INTO jaa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ati ehene me te nemetemoneke kateya ya, fara Yose foye ka kateya ya. Afa kateya tohehemetemoneke saotato me ka hiti ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Me kasawi toyabohemetemoneke kateya tori ya. Saotato me ka hiti ati ehene Yose mera kakatomehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Yama soki one ya towisawa ka fi tata watami, towisawa ka bao hihiri watami, nematamonaka. Haha wata yama nahaba kaminemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yama wamini ya Yose kake mera awe me kokoriri namone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","\"Himataba te awi kokoriri nineri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Me ati yana nemetemoneke. \"Ota watamikima otake. Ota ka wata me kaminaba me watakere ahi\". \"Teoso amaka, era kanawanahari wata kamini e watohabone e. Hima te ka wata te kaminahi owa ni ya\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Faya towisawa ka fi tata watari kaminematamonaka. \"Ofa ate owahara oke oko wata ya, ");
INSERT INTO jaa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mani terei naro. Afe yati yanaharake. Mowaharake hibati ya. Mowe boni tohawaharake. Boni hataharake fahi. ");
INSERT INTO jaa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Towisawa ka kobo tama onahara oke oyehe ya wata ya. Ofa hati tima okana tafa onakiharake, kobo ya. Faya towisawa owakawahara oke kobo ya\". ");
INSERT INTO jaa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Faya Yose ati yana nematamonaka. \"Tika wata yama nahaba kaminineke e naro ahi: Ofa mani terei na yama wehe terei na kaminineke. ");
INSERT INTO jaa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Yama we terei na ahabi ya towisawa ati ehene tasi tinahabone tike. Yama ahi tinamatasabone tike, towisawa ka fibone ta tina tiwa. Taiti ka tiwehene nima tiwehene nabone tike tasa. ");
INSERT INTO jaa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Titamini ya fahi owa wati tiwahabone tike. Yama amosa ya owa hiri tikanabone tike, owa tikamina tiwa towisawa ni ya. Tiwehene e ni ya owa hasi tinihaba tiwa awine tike, tasi onahabone owa. ");
INSERT INTO jaa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kateya ya ofoya owehene hiyara watatera ama oke. Hibati ya ebereo me tabori ya osawiha owa me itikosakia owa me kakamamaro me amake ahi Esito ya. Manakobisa yama toyabo ya ofoyamaro ama oke kateya ya, owehene hiyaraba watara owa\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Faya towisawa ka bao hihiri yama kamini mite yama kamini amosamone ati ne ati yana nematamonaka. \"Owatamihara oke bisa. Bao wiyene terei ne tiwa okanara oke otati ya wata ya. ");
INSERT INTO jaa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Bao wiyene kemese ya yamata kahi yoro tokana narake. Afa yamata bao hihiri me hiri te me amake towisawa tefebonaha. Neme ka bani me kakeha yamata me kabaharake\", ati nematamonaka wata kaminari. ");
INSERT INTO jaa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","\"Tika wata yama nahaba kaminineke. Bao wiyene terei ne yama wehe terei nabone kaminaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Yama wehe terei na ahabi ya tasi tinahabone tike towisawa ati ehene. Faya ati ehene titati me ti nakosabone tike. Tika abohi me nawinabone tike awa waha ya. Neme ka bani me kakeha tika ime me kabahabone tike\", Yose ati nematamonaka, bao hihiri watari kaminari. ");
INSERT INTO jaa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Yama we terei na ahaba nowati ya towisawa marina hiri nematamonaka hinaka anifesari ka marinabonehe. He nanarifa me nafi ha nematamonaka me mari hinahabone mati. Ati ehene me me tasisi nihemetemoneke kateya ya, towisawa ka fi tata toha, towisawa ka bao hihiri toha, nari, me sawihabone mati marina ya, ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","22","Fare Yose ati nima yama nemetemoneke. Towisawa ati ehene fi tata towisawa ka yama ahi namatasehimatamonaka. Hahi bao hihiri ta me nabowahabone towisawa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Manakobisa fi tata ati katamomatamonaka Yose ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ano famaha ahaba nowati ya Yose foyasa nematamonaka kateya ya. Yama soki one ya Esito ka towisawa watamimatamonaka. Wehimatamonaka faha Niro witi ya wata ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","We bowi me seti na me kimisakehemetemoneke me amosa mati, me imaha mati. Faya fa witi ka masiri me kabehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Faya bowi me one seti na me kimisake nemetemoneke, me awi amosara mati, me imara mati. Faya bowi me one tai toha me ni ya me tokomakehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Faya bowi me imara me one imaha me me kabehemetemoneke, me me yome na mati. Faya towisawa tafihimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Faya amo toname watamitasehimatamonaka. Tiriko ate oharia boni seti na awehimatamonaka, wata ya, boni amosaro. ");
INSERT INTO jaa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Manakobisa tiriko boni one seti na awatasehimatamonaka awi hiyararo, waya tokanaro, boni hiwaha ihi, yama honara ka boni. ");
INSERT INTO jaa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Faya tiriko boni waya tokana tiriko boni one amosa yome nemetemoneke. Faya towisawa tafihimatamonaka. Hine ya watamone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Yama wamini ya towisawa kokoriri nematamonaka. Makoni mera ha nematamonaka, Esito ka yama wawato mati me nafi. Watari kamine wata yama hikaminaha kamini me watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Faya towisawa ka fi tata me ka hiti ati yana nematamonaka towisawa hiyarari. \"Owehene hiyara okomina okibone, owati katamoani owa e ka owa okominahabone ona owa tiwa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yama e naro amake ahi: Ota fama otara tikakoa ota te naro ota amake kateya ya tiwati ihi, saotato me ka hiti ka yobe ka kateya ya. Tika bao hihiri me ka hiti ya ota famaro otake ota te na ota. ");
INSERT INTO jaa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yama soki one ya ota famaha ota watamiharo otake. Ota watari yama nahabani kaminete amake. ");
INSERT INTO jaa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kateya ya ebereo me ka owa yetene tohe sawihirika fahi, saotato me ka hiti ka yama aahi tohahari. He ni ya ota ka wata ota kamina ota ka wata yama hikamina kamineri amaka ota ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Fare ati nima yama naroke. Oko yama ahi onamatasa bao hihiri ta ahaba nerika, me hinawinahari awa ya\", towisawa ka fi tata ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fi tata ati towisawa mite ati ehene Yose me tonakamehemetemoneke, me hitimebonaha kateya ya. Faya Yose bono kone sowe ne makari akawe kamehimatamonaka towisawa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faya towisawa ati yana nematamonaka. \"Owatamiha oko wata yama hikamina kamini me watorarake me nafi. Titamine omitara oke wata kamini tiwatohamone tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","\"Towisawa yama owatotera ama oke fara owa. Teoso yama kaminebonaka tiwa ni ya, tika yama amosabone tiwa\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","\"Owahara oke faha Niro witi ya oko wata ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Bowi me seti na me kimisakeharake me amosa mati, me imaha mati. Faya faha witi ka masiri me kabaharake. ");
INSERT INTO jaa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Faya bowi me one seti na me kimisake narake, me awi amosara mati, me imara mati. Bowi me e na me owatera me amake Esito ya, me awi hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Faya bowi me imara me one imaha me me yome nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Me me yome na me awi tohawararake, fara me tohasa na mati me imara mati. ");
INSERT INTO jaa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Manakobisa owatamitasahara oke. Tiriko ate oharia boni seti na owahara oke, boni amosaro. ");
INSERT INTO jaa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Manakobisa tiriko boni one seti na owatasahara oke awi hiyararo, waya tokanaro, boni hiwaha ihi, yama honara ka boni. ");
INSERT INTO jaa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Faya tiriko boni waya tokana tiriko boni one amosa yome narake. Yama wawato me ni ya oko wata okomina yama hikaminaha kamini me watorarake me nafi\", towisawa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Faya Yose ati yana nematamonaka. \"Tika wata famaha fara yama oharia kaminineke. Teoso yama hiri hinahabone kaminaka tika wata ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bowi me imaha me seti na me toha tiriko oharia boni seti na amosa toha na ano seti nabone kaminineke. Tika wata famaha fara yama oharia kaminineke. ");
INSERT INTO jaa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bowi me imara me seti na me toha tiriko waya tokana seti na toha na ano seti nabone kaminineke, yamata nafimaribone ka ano. ");
INSERT INTO jaa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Yama okominahara oke baha owati e na owa ahi: Teoso yama hiri hinahaba kaminareka tiwa ni ya towisawa. ");
INSERT INTO jaa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ano seti na ya yamata nafihaba amake Esito ka yama nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Manakobisa ano seti na ya yamata watamarahaba amake. ");
INSERT INTO jaa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Me fimihaba me amake kasiro ya. Yamata tami ka ano me wati nawamaraba me amake, me fimiha mati. ");
INSERT INTO jaa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Fainama wata famaha yama kaminineke e naro ahi: Teoso yama hiri hinahaba hawa tonihareka. Yama hiri nebonaka hibati ya\". ");
INSERT INTO jaa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yose hiyarasa nematamonaka. \"Towisawa yama amosaboneke e naro ahi: e ka owa tiwasihabone tike yama wato mati tohahari, Esito ka mera yosehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Me one tiwasi tinahabone tike, me yaka nabone mati Esito ka yama nafi ya, fatara ka yamata kote me yabahabone mati, ano seti na ya, yamata tami ka ano. ");
INSERT INTO jaa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yamata tami ka ano seti na ya tiriko tamaha me yoro tokaniwamaboneke afa mati, me hinihabonehe yama totoniha ka yobe ya sitati tamaha ya. Me nafi ihi tiwabone tike afa mati. ");
INSERT INTO jaa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Te ehene e ni ya te ahabarahaba te amake, yamata watamari ka ano seti na ya, yamata te toniha te kabaha te fahi. Te ahabarahaba te amake fimi ihi, Esito ka me te\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yose ati amosematamonaka towisawa ni ya, he nanarifa me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faya towisawa ati yana nematamonaka. \"E ka owaba watare awaka e nari Yose nima. Teoso Kanamori sawi awaka he ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faya Yose hiyarematamonaka. \"Afa yama nafi Teoso namo awaka tiwa ni ya. E ka owa watare awaka yama watohari tiwa nima nari. ");
INSERT INTO jaa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Oko yobe ka yama nafi tekatomabone tike. Me nafi tiyoseha tiwati nima me naboneke. Owa tiyoserabone tike ha owa owahariha owa Esito ka towisawa oha owa. ");
INSERT INTO jaa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Esito ka me nafi yoyose tihahabone tike owati ihi hibayata ya\", towisawa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faya towisawa ka aneo soba towitimatamonaka he ino kihaharo. Yoko hinehemetemoneke Yose yehe ya. Manakobisa ati ehene Yose me akaka nihemetemoneke makari amosa riyo tohaha ya. Faya Yose weyeye kanihematamonaka kasaro oro tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ati ehene Yose foyematamonaka Esito ka kofenato ka kaho ya. Faya ati ehene he nanarifa me tai tohehemetemoneke kaho nokosi ya me ha ni kitaha mati, me ati e na mati ahi: \"Te nahowahi\", me ati na mati. Faya Esito nafi ka kofenato Yose tohawematamonaka towisawa ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","\"Towisawa oha owa nima tinabone tike, Esito ka me nafi tiyoseha tiwa. Esito ka yama tiyoseraba wataraba amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Yose ino owabona towisawa nawatematamonaka, Safenati Baneya tohehibonaha. Hikahabanematamonaka, Asenati itihibonaha, Botifera bite. Sitati Heriobori ka sasetotimatamona amaka Botifera. Yose ka ano 30 tohaha towisawa ka yama ahi ni yana tonehimatamonaka. Faya toke yaka nematamonaka Esito ka yama nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yamata tami ka ano seti na ya fatara ka yamata tamehemetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yose yamata yoro tokani yamata tonihematamonaka yama totoniha ka yobe ya. Fara sitati nima yobe nematamonaka sitati beheri ka fatara ka yamata totonihabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yamata tami ka Yose yama tomi namarematamonaka. Baraya ka siki boni nima yamata nemetemoneke tomi kanihina raro. ");
INSERT INTO jaa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yamata watamari ka ano yana tori ya mata Yose fati ya me famaha me ka matehe famehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Biti taiti wate ino hinawatehimatamonaka Manase tohehibonaha, ati e nari ahi: \"Oko yama nawaha wati owahamarine oke Teoso ehene. Okobi me wati owahamarihi one oke Teoso ehene\". ");
INSERT INTO jaa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Biti yoto ke wate ino hinawatehimatamonaka Efarai tohehibonaha, ati e nari ahi: \"Esito ya osawiha yama nawaha hiri onahamaro okatao me nake waha Teoso ehene\". ");
INSERT INTO jaa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Manakobote yamata tami ka ano seti na ahabemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Aya Yose yama hikamina yana tonehemetemoneke, yamata watamaribone ka ano seti naro. Esito beheri ka bara me tabori ka yamata watamara me fimihemetemoneke, bara mati. Esito ta ya yamata nehemetemoneke, Esito nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Esito ka me fimi yana tona me kakehemetemoneke towisawa ni ya, yamata me kanikabone mati. Ati e nematamonaka ahi: \"Te tokahi Yose ni ya. Fara Yose yama hikamina nima te ehene nabone teke\". ");
INSERT INTO jaa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Fimi nafimisa ihi Yose yobe nafi naha nematamonaka, yamata totoniha ka yobe. Faya yamata ta nematamonaka Esito ka me ni ya yinero manakone. ");
INSERT INTO jaa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bara me one kake nemetemoneke Esito ya yamata me kanikabone mati Yose ni ya, yamata watamari karo tabora nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yako hiyara mitehimatamonaka, Esito ya yamata nahamone tamine mitahari. Faya biti mera hiyarematamonaka. \"Himataba te nahoneri? ");
INSERT INTO jaa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yamata nahamone me ati narake Esito ya, me ati omita mati. Te tokahi fahi yamata te kanikibeya. E ahabariyahi fimi ihi\". ");
INSERT INTO jaa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Faya Yose anoti me tei na me tokehemetemoneke Esito ya yamata me kanikabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yako biti Besami tohe kayawematamonaka. Me ya tabarebona hinehimatamonaka, yama yofina kobo rabonehe he ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaha ka me one ya Yako biti me tabehemetemoneke, yamata watamari karo Kanaha ka yama nafi ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Esito ka kofenato Yose tohe yamata tata tohehimatamonaka tabora one ka me kakeha me ni ya. Yose anoti me kobo na me isi yobati ya me nahorisemetemoneke Yose nokosi ya, me tati tokowarisa mati wami ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yose anoti mera awe mera watohimatamonaka hibati ya. Yose mera awarama nematamonaka, e abe watora nima nari. Mera aate nematamonaka kita ya. \"Ha te hibaka te kakineri?\" \"Ota kakineke Kanaha ya, yamata ota kanikabone ota\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yose anoti mera wato me hiwatorehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Faya Yose watarimari wati nawahematamonaka, mebone mera awe ka watari. \"Te kakeha te awineke Esito ya, Esito ka yama kitara te awahabone te, otara te mowa nabone te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","\"Yama e kere fahi. Tiwa nanarifa me ota amake. Ota kakineke yamata ota kanikabone ota. ");
INSERT INTO jaa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ota ka abi ohari biti me ota amake. Ota kakekere Esito ka yama ota awahaba ota. Keye ota hiri kere\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","\"Keye te hiri namone one oke. Te kakeha te awineke Esito ka yama kitara te awahabone te\", Yoseno ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","\"Ota winake Kanaha ya. Ota ka abi biti me ota amake, ota 12 na ota. Ota ka owa ohari fawa nemari amaka. Ota ka niso yoto ke sawika ota ka abi ni ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","\"Keye hiri okere. Te kakeha te awineke Esito ka yama te awahabone te. ");
INSERT INTO jaa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Yama siba onahabone onahara oke, keye amara ka yama. Te ka niso kakehibonaka ahi. Kakere ya te tokomarahabone teke. Owati tohawarabone onahara oke, towisawa ino otiha owa. ");
INSERT INTO jaa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Te ka owa ohari te ka niso tonakamehibonaka. Te one me kibehabone teke ahi. Yama te kamina e watohabone eke fahi. Keye tohi ya te kakeha te awineke Esito ka yama te awahabone te. Owati tohawarabone onahara oke, towisawa ino otiha owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ati ehene me kibehemetemoneke kateya ya yama we terei na ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Yama we famaha ahabi ya Yose mera hiyarematamonaka. \"Teoso ati onofa oke. Tera onahabiharabone oke, owati nima te ehene ni ya. Te ehene e nabone teke ahi: ");
INSERT INTO jaa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","te ka owa ohari foyehibonaka kateya ya. Te one me tokomaboneke yamata me towakamahabone mati, te nafi fimimarabone te. Yama te kamina keye tohari ya ");
INSERT INTO jaa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","te ka niso te kakamabone teke ahi. Faya tera owatohabone oke, keye te hiri ra te. Keye tohi ya owati ihi tera me nahabihabone teke\" Yoseno ati nematamonaka. Faya me ati amosemetemoneke Yose ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Me abe hiyaremetemoneke. \"Yama nawaha e hiri nineke, e ka niso e nofarimaro karo. Noko e awehimari amaka yawahari, era aate nari, e aawawa nebona ati nari. Ati e nofaremarika. Makoni yama nawaha e hiri nineke waha\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","\"Owati yana namaro ama oke, yetene te hiri karabone ona owa yama hiyara ya. Owati miti te nofaramaro teke. Makoni ahabi manakone e karimaka waha\", Hobi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yose nokosi ya me nahoha Yose me ati watoremona me hinehimatamonaka. Yose abono mera hiyararematamonaka. Yose nanarifa he ati kaminematamonaka me ni ya. Me ati kamina nematamonaka Yose ni ya. Faya me abe hiyara Yose me ati watohino me hiwatorehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Faya Yose yana ne tokomematamonaka. Me ni ya sawimare ohi ni yana tonehimatamonaka. Ohi ni fawa ne amosawame kamehimatamonaka. Simiao tonihawahawiti ati ehene Simiao me wete nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yose ati ehene he nanarifa yamata me te nemetemoneke anoti me ka sako ya. Faya yinero me te, nemetemoneke ati ehene, fara anoti me ka yinero. Ati ehene yamata one me ta, nemetemoneke me hikababonehe hawi ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Yose anoti someto me weyeye nihemetemoneke yamata ya, me hikanikaharo. Faya me tokomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Hawi enoki ya me amo nabone me ma tonama faya me ka owa yamata naha kanehimatamonaka, someto tefebonaha. Sako naha kane hinaka yinero awehimatamonaka kibehari sako tori ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Faya ati yana nematamonaka. \"Te awa ha. Oko yinero foyakeno sako tori ya. Me ta hiname awaka\". Faya me ero nemetemoneke. Me hoyahoya kana nemetemoneke. Me abe hiyaremetemoneke. \"Himata nima yama nineri e ni ya Teoso ehene?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanaha ya me kobo tonama yama nafi me kaminemetemoneke me ka abi ni ya Yako ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","\"Esito ka kofenato otara katomareka. Ota tokahamone ati nareka Esito ka yama kitara ota awahabone ota, me e mowa nabone e ati namone ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ota ati e na otake ahi: \"Ota kakeha otake yamata ota kanikabone ota. Keye ota hiri kere. Ota kakera otake Esito ka yama ota awahaba ota. ");
INSERT INTO jaa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ota ka abi ohari biti me ota amake ota 12 na ota. Ota ka owa ohari fawa nemari amaka. Ota ka niso yoto ke sawika ota ka abi ni ya Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Faya kofenato ati e nareka ahi: 'Yama siba onahabone onahara oke, keye amara ka yama. Te ka owa ohari sawihibonaka owa ni ya. Te one me tokomaboneke yamata me towakamahabone mati, te nafi fimimarahabone te. ");
INSERT INTO jaa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Te ka niso yoto ke te kakamabone teke owa ni ya. Te ehene e ni ya keye te hiri ramone onahabone oke. Faya te ka owa tasi onihabone oke te ya tabamebonaha. Faya yama te kanikamatasabone teke', ati nareka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Manakobisa me ka sako me naha na me ka yinero me wasirawehemetemoneke me nafi, ihahari sako bite ya, yamata ya tabahari. Yinero me awa me watohemetemoneke. Me ka abi wato nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Faya Yako ati yana nematamonaka. \"Okatao me nafi fawawa nabone te ati nine? Yose watamarihi, Simiao watamarihi nareka waha. Manakobote Besami te towakamahabone te ati, nineke. Yama nawaha hiri one oke ha owa, okatao me fawa na me ihi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Faya Hobi ati yana nematamonaka. \"Abi Besami owakatomabone onahara oke ha owa. Ota tokoma owakamebonaka tasa. Owakamare ya okatao me famaha me waka tinahabone tike\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","\"Okatao sawi onofa okere te ni ya. Anoti Yose ahabemata oharika Besami. Te tokomi ya te towakame ya yama hiyara ni ya he ni ya ohababone oke yawa ihi te ehene\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Me fimi fawa remetemoneke Kanaha ka mati. ");
INSERT INTO jaa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yamata me hekama Yako me tonafiyoha faya Yako biti mera hiyarematamonaka. \"Te tokomahi tasa Esito ya, yamata one te kanikabone te, e tefebonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Faya Yota ati yana nematamonaka. \"Esito ka me ka owa ati e nerika ahi: ota ka niso ota towakamari ya otara hiyararebona ati nerika. Ati tohawarebona ati nerika. ");
INSERT INTO jaa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tiwati ihi Besami ya ota tabi ya tika yamatabone ota kanikabone otake. ");
INSERT INTO jaa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tiwati hiyari ya ota tokomarahabone otake. Esito ka me ka owa ati e nerika ahi: 'Te ka niso te kakami ya tera ohiyaramatasabone oke. Te ka niso sawire ya tera ohiyaramarabone oke', ati nerika\". ");
INSERT INTO jaa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","\"Himataba owa te yokoha te awineri? Himataba te ka niso te kaminete te amari bare ni ya?\" Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","\"Bare otara aate ni kasirorika, e nafi tamine mitehibonaha. Ati e nerika ahi: 'Te ka abi sawisa ne awa? Te ka niso ne awa?' ati nerika. Ota ati watari ya yama hiyaraboneke. Atibona ota watorerika, ota ka niso ino hiri nari, ota kakamebonaha\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Faya Yota ati yana tasehimatamonaka. \"Okaniso owakatomabone oke. Ota tokomabone otake hibati ya, e ahabaribone karo fimi ihi, ota toha, tiha, ota ka matehe toha, na e. ");
INSERT INTO jaa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Besami owakatomabone oke. Amosare ya owakamare ya owehenemone owa tinabone tike. Owehene hiyara fawa terabone oke owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Yama noki ni nawahake e ni ya. Ota tokomakabote ni ya yamata kaniki ota famehenero ota amake\", Yota ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Faya me ka abi ati yana nematamonaka. \"E ahabariyahi fimi ihi. Te ehene e nabone teke ahi: yama amosa te te nabone teke te ka sako ya te towakamabonehe bare ka yamabonehe. E taboro ka yama amosa te towakamabone teke, wami toha, abiya me fehe toha, yamata tehe toha, awa boni toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Yinero te towakamabone teke, yamata manakonebonehe. Aya yinero te kakameri toha naho, te ta tonamebonaha. Yama me awarete me awineke te ka yinero me ta namehete mati. ");
INSERT INTO jaa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Te ka niso te towakama te tokomakabote nahi, bare te kobo namatasabone te. ");
INSERT INTO jaa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Teoso kitabote ati ehene bare tera aawawa neba awaka. Ati ehene Besami ya Simiao me fama me kakamaba me awineke. Okatao me fama me fawa kani ya hine me fawa kanahaba me awineke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Faya Yako biti me tokomemetemoneke Esito ya, Besami me towakama, kofenato ka yamabone me towakama, yinero famehi me towakama na mati. Me kobo tonama hibati ya me tokomakehemetemoneke Yose ni ya, me hihiyarehibonaha. ");
INSERT INTO jaa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Me tokomake Yose mera awe Besami awehimatamonaka me ya tabahari. Hinaka yobe kakakatoma tohe hiyarematamonaka. \"Haha me tekamahi otaboro ya. Bani tinabowahi, marina tafebonehe. Me mari onahabone oke bahi nokorise ya\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Faya Yose ati ehene mera towakamehimatamonaka Yose taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Me kobo na me watohemetemoneke. Me abe hiyaremetemoneke. \"Yinero ehene tohe awaka aya e wasihari e ka sako ya kibehinoho. Era me katomaba me awineke, e ka someto me me ihawahaba mati. Me ati ihi yama aahi me e tohahaba e amake, me ka yama e ahi nabone e\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yose ka yobe wari yabore ya me ati yana nemetemoneke, yobe kakakatoma me aate na mati. ");
INSERT INTO jaa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","\"Ota ati timitamata. Ota kakibaharo ota amake baha, yamata ota kanikabone ota. ");
INSERT INTO jaa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Hawi enoki ya ota amo nabone ota ma tonama ota ka sako ota naha na yinero ota wasiharo otake aya ota ta nari, yamata manakonebonehe. Yinero nafi tohehirika ota ta nari. Efe yinero ota kakamatasa otake. ");
INSERT INTO jaa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Yinero toha nareka ota kakamari, yamata one manakonebonehe. Me ota watokere, yinero me te nani mati ota ka sako ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yobe kakakatoma ati yana nematamonaka. \"Te watorima nahi. Te ka Teoso te ka abi ka Teoso tohe ehene tohehino awaka, yinero te nari te ka sako ya. Te ka yinero te ta ne wara onareka\", ati nematamonaka. Faya Simiao kakamematamonaka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Faya mera towakiyomame me ka fahabone ta nematamonaka me tame me soko nibone karo. Someto mera natafa nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yama me hawa tonihemetemoneke me ta hinahabonehe Yose ni ya, yama amosa me hekamaharo. Yama wato me hawa tohemetemoneke me tafahabone mati bahi nokorise ya. ");
INSERT INTO jaa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Faya Yose taboro ya kobo name yama me ta nemetemoneke he ni ya. Me isi yobati ya me nahorisa me tati tokowarisemetemoneke wami ya. ");
INSERT INTO jaa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","\"Te taminini?\" Yose ati nematamonaka. \"Te ka abi bote amose awa, aya te kaminari owa ni ya? Sawisa ne awa?\" ");
INSERT INTO jaa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","\"Ota ka abi tiwa nanarifa tohe sawisa ka. Amosaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Faya Yose yama nafi awi moto nawahe Besami awehimatamonaka, nisori yokana tohahari, fara me famaha me ka abi ohari me ka ami ohari na mati. \"Efe te ka niso yoto kemona ama, aya te kaminari? Yetene Teoso yahebonaka tiwa ni ya\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yose nisori awe ati kamoniri yana ne ohi nima nematamonaka. Faya fare aamo ya tokome ohi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Faya ohi ni fawa ne hiwa nataminawame noko soko nawahe kamehimatamonaka. \"Yamata te sawa nahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yamata me sawa na Yose itarimatamonaka mesa one ya. Anoti me nahori nemetemoneke mesa one ya. Esito ka me sawiha me nahori nemetemoneke mesa one ya tasa. Me ka teoso me ati ihi ihayeo me katafi me nofaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yose anoti me nahoria me kanakokehemetemoneke he ni ya. Yose nanarifa ati ehene taiti tohe itari owa itari owa itari nematamonaka. Besami yoto ke tohe itarimatamonaka me nahori yowi ya. Afa yama me awaha me abe aawikima na \"Ka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Fara yamata me sawa hina Yose ni ya me sawa nemetemoneke anoti me ni ya. Besami ohari ta ni ya yamata nafiha me sawa nemetemoneke, sawa ni siko naro. Yose ya me taba yama me fawa me hahano raba nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Manakobote Yose ka yobe kakakatoma yosehimatamonaka, ati e nari ahi: \"Afa me ka sako mo tinihahi mata ya yamata ya. Faya yinero me ta hine te tinahabone tike me nafi ka sako tori ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Yoto ke ta ka sako tori ya oko kobo tibehabone tike, barata hinama tohaharo, hinaka yinero ya tabahabonehe, yinero yamata manakone tohahari\". Fare Yose ati nafi nima hinaka yobe kakakatoma ehene nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Faya hiba yama wa ni ya Yose anoti me yana tonehemetemoneke, me tokomabone mati, me ka someto me ya me taba mati. ");
INSERT INTO jaa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Me tokoma me yaka ni yabori ya sitati beheri ya me tohasa ni ya Yose ka yobe kakakatoma narabo nima nematamonaka. \"Tokomakekabote tinahi afa me ni ya. Me tiwasimaki ya tiwati e nabone tike ahi: 'Himata te ebe na te ehene hiyarineri ota ni ya, ota ehene amosa ota te ni ya? ");
INSERT INTO jaa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Himataba oko hiti ka kobo te botirini, barata hiri ni tohaharo? Afa kobo ya yama fawa, yama me hiwatora kamina, te amaka. Te ehene hiyakere kasiro ya', tinahabone tike me ni ya\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Faya tokomake mera towasimaki mera aate nematamonaka, yama Yose hikamina kaminari. ");
INSERT INTO jaa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","He ati me mita me ati yana nemetemoneke. \"Himataba tiwati e nineri ahi? Yama e naba ota hiri terabone otake. ");
INSERT INTO jaa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Hibati ya Kanaha ya ota ka yinero ota wasihiri ota ka sako tori ya efe ota kakamareka ota ta tonamebonaha te ni ya. Tika hiti ka yama manakone fotaha ota botirabone otake. ");
INSERT INTO jaa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tika hiti ka kobo siba tina ota ka owa ni ya tiwasi ya efe ahabebonaka te ehene. Te ka yama aahi me ota tohawahabone otake ota nafi bisa\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","\"Te ati amosake. Te nafi amaraboneke. Hine ya te ka owa ohari oko hiti ka kobo kihe oko yama aahi tohawebonaka. Te one me tokomabone teke\", Yose ka yobe kakakatoma ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Faya me nafi ka sako me yabehemetemoneke someto me ni ya, me si hinihabonehe bofe ya. Sako me se narawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Faya yama siba nematamonaka sako nafi ya. Taiti ka sako siba ni tai tohe taiti nowati ka me ka sako siba ne yoto ke ka sako siba ni yotohimatamonaka. Faya hiti ka kobo wasihimatamonaka Besami ka sako ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Faya Yose anoti me yawaha me ka makari me sibi nemetemoneke. Sako ya someto me me weyeye nima me fari tonamemetemoneke sitati ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yose ka yobe ya Yota me kobo nama Yose tohasa nematamonaka. Faya Yose nokosi ya me isi yobati ya me nahorisa me tati tokowarisehemetemoneke wami ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yose mera aate nematamonaka. \"Himataba yama e na te hiri nani te awineri? Owa te watora te awine, yama me hikehemoha owatoha owa?\" ");
INSERT INTO jaa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yota ati yana nematamonaka. \"Ota ka hiti yama ota kaminaba ota watokere, ota ehene hiyara wataramone te ati nabone te. Ota ehene hiyatera Teoso namoka. Ota ka owa tika kobo kihehi ya ota tabahabone otake, tika yama aahi me ota tohawahabone ota\". ");
INSERT INTO jaa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yose ati hiyarematamonaka. \"Yama e na hiri orahabone oke. Hahi oko kobo kihe ohari oko yama aahi tohawehibonaka. Te one hine me tokomaboneke te ka abi taboro ya\". ");
INSERT INTO jaa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Faya Yota tokomematamonaka ayata ya Yose itari yabore ya. Ati e nematamonaka ahi: \"Ota ka hiti tiwati amosi ya yama nafi okominahabone oke tiwa ni ya. Tiyawariyahi. Esito ka towisawa nima tine tike. ");
INSERT INTO jaa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tiwati e naro ama tike ahi: 'Te ka abi sawisa ne awa? Te ka niso owa ne awa?' tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ota ati e naro ota amake ahi: 'Ota ka abi sawisa ka, bote tohahari. Ota ka niso na naka, watehimarihi ota ka abi bote tohe ya. Efe anoti ahabemataka. Oharika hasi nari, mati biti tohahari. Bati hinofa hika kasiro ya', ota ati naro otake. ");
INSERT INTO jaa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Faya ota ka niso nafire ino hiri tinaharo ama tike, ota kakamebonaha, tiwehibona tinahari. ");
INSERT INTO jaa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ota ati e naro ota amake tiwa ni ya: 'Ota ka niso kamakirebonaka. Bati kakose ya bati ahabebonaka', ota ati naro ota amake. ");
INSERT INTO jaa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Faya tiwati e naro ama tike ahi: ota ka niso kamakire ya otara tihiyaramarabone tinaharo ama tike\". ");
INSERT INTO jaa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","\"Ota tokoma ota taboro ya ota kobo tonama tiwati nafi ota kaminaro ota amake ota ka abi ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Manakobote hibayata ya otara yosemareka tasa, yamata one ota kanikabone ota. ");
INSERT INTO jaa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ota ati e na otake he ni ya: 'Ota tokomarabone otake. Ota ka niso ota ya tabare ya Esito ka owa otara hiyararebonaka. Ota ka niso ota ya tabe ya ota tokomabone otake. Ota ya tabare ya ota tokomarabone otake', ota ati na otake. ");
INSERT INTO jaa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Faya ota ka abi ati e nareka ahi: 'Yama te watoke haro. Oko yibote Hakeo tohaha biti me famamaro me amake, okatao mati. ");
INSERT INTO jaa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Owa watamaremari amaka owa ni ya, owamarahari. Yama kabani ka bani me hinabowemata awaka. ");
INSERT INTO jaa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Owa hasi ne te ehene owa kakose ya he ni ya yama hiyara kaki ya ohababone oke te ehene, bote oha owa', ati nareka\". ");
INSERT INTO jaa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yota hiyarasa nematamonaka. \"Ota ka hiti owati timitahi. Okobi ni ya okomi ya okaniso nafire owakamari ya okobi yama wato ya ahabebonaka hibati ya. Okaniso ahabe ya okobi ahababisebonaka. Okaniso watamare ya okobi yawe ahabebonaka ota ehene, bote tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yama nasa ke kaminabonehe tiwa ni ya. Okaniso nafire owakatomabone onahara oke, okobi ohiyara owa. Owati e nara oke ahi: 'Okaniso nafire owakamari ya owehene hiyara fawa terabone oke tinokosi ya', onahara oke. ");
INSERT INTO jaa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Makoni tiwa aate one oke, owati e na owa ahi: tika yama aahi ohawahabone onahara oke okaniso nafire taboro ya, tokomebonaha, anoti me ya tabahari, tiwati amosi ya. ");
INSERT INTO jaa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Okomariyahi otaboro ya, okaniso nafire owakamara owa. Okobi ahabi awi onofa okere, yawa ihi\", Yota ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yose hiwa kasawarimarehimatamonaka, ohi nima ne karo he nanarifa me nokosi ya. Makoni ha nematamonaka, \"Te nafi tokomahi\", ati nari. Me tokoma me watamari ya Yose hiwa kaminematamonaka waha anoti me ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ohi ne ohi ni kite ka ohi ni me himitematamonaka Esito ka mati. Tamine me himitematamonaka towisawa ka yobe ka mati bisa. ");
INSERT INTO jaa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yose anoti mera hiyarematamonaka. \"Yose ama oke. Okobi winasa ne awa?\" Yose ati anoti me mitaha me ero ni ka me ati yana ni watomarehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","\"Te kamahabone onahara oke ayata ya owa ni ya\". He ni ya me tokoma mera hiyarematamonaka. \"Yose ama oke. Efe te ka niso ama oke, te ta nemarihi, me hekamebonaha Esito ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Te yawariyahi, te ehenemaro te wati nawaha te. Tera te kakoriyahi, owa te ta namaro te me ni ya, owa me kakamabone mati ahi. Teoso ehenemari amaka. Teoso owa yosekimari ama oke ahi te nokosibone ya, tera okasomahabone owa. ");
INSERT INTO jaa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","E fimi ka yama ahabakere mata, tabora nafi ka me fimi ka yama. E fimi ka ano fama ano siko na hasi nasa ke, e fimibone ka ano. Yama me koro rihi, yama boni me bata rihi, naba me amake ano siko na ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Teoso owa yosekimari ama oke ahi te nokosibone ya, tera kasomebonaha Esito ya, te ka noti me nibone karo. Teoso ehene amosaka kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Te ehene amaramaro amake. Teoso ehenemari amaka, owa yosekihari. Teoso ehene towisawa nanarifa taiti ohawa oke. Towisawa ka yobe owakatoma, Esito nafi ka kofenato oha, ote ama oke\". ");
INSERT INTO jaa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","\"Owati te mitahi. Te tokomakabote nahi te taboro ya. Owa te kaminiyahi okobi ni ya, okobi biti oha owa, Yose oha owa. Owati te kaminiyahi he ni ya, owati e na owa ahi: 'Esito nafi ka kofenato oha oke Teoso ati ehene. Tikamakehi hibati ya owa tiwahabone tiwa. Yama nawaha hiri tiriyahi. ");
INSERT INTO jaa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tiwinabone tike Kose ka yama ya, oko wini yabori ya. Ha tiwa, tikatao mati, tika noti mati, tika ofeya mati, tika kabirita mati, tika bowi mati, tika yama nafi toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","E fimi ka yama tohasa naboneke ano siko na ya. Kose ya te wini ya yamata tamaha ta onabone oke tiwa ni ya, te nafi ni ya, te ka bani me toha na me ni ya. Yama hasi naba wataraboneke te ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yose hiyarasa nematamonaka. \"Tera ohiyara owa te awake, Yose oha owa. Okaniso Besami owa awa ka, Yose oha owa. ");
INSERT INTO jaa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Owa te kaminiyahi okobi ni ya, okitamone owa ahi Esito ya. Yama nafi te awaha te kaminiyahi he ni ya. Te tokomakabote nahi, okobi te kakamabone te\". ");
INSERT INTO jaa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yose nisori Besami hitiri ne ohi ni yana tonehimatamonaka. Besami ohi, nematamonaka, Yose hitiri nari. ");
INSERT INTO jaa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Faya Yose anoti me nafi hitiri nematamonaka, mera kokomi nakehari, ohi nasa nari. Manakobisa anoti me ati yana nemetemoneke, he me hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yose anoti me sawihamone me tamine me mitehemetemoneke, towisawa ka yobe ka mati. Faya towisawa yayai nematamonaka, he nanarifa me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Towisawa Yose hiyarematamonaka. \"Ayo me narabi nima tinahabone tike, me ka someto me me weyeye nimi ya me tokomabone mati Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Me ka abi me kakamiyahi owa ni ya, me nafi toha na mati. Esito ka wami amosi mati tohaha ta onahabone oke me ni ya, Esito ka yamata amosi mati tohaha me kabahabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Esito ka kaho me towakamaboneke Kanaha ya, me ka yibote me me kakamarawabone mati, me ka matehe toha, me ka abi toha nari. ");
INSERT INTO jaa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kanaha ya me ka yama me kakosi ya me yawaraboneke. Esito ka yama amosi mati tohaha me ihawahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Fare towisawa ati nima me ihi nemetemoneke, Yako biti mati. Towisawa ati ehene Yose kaho ta nematamonaka me ni ya. Yamata ta, nematamonaka, me hikababonehe hawi ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Makari yati ta, nematamonaka me ni ya. Besami ta ni ya makari siko na ta, barata ta, nematamonaka, boni 300 tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yama tamaha Yose ta nematamonaka bati ka yamabonehe. Esito ka yama amosi mati tohaha someto me 10 na me weye nemetemoneke Yose ati ehene, bati ka yamabonehe. Someto me one me 10 na yamata me weyeri nemetemoneke. Tiriko toha, bao toha, yamata one toha nemetemoneke, me hikababonehe hawi ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Manakobote Yose anoti me yana tona me tokomabone Yose me narabi nima nematamonaka, \"Te abe hora riyahi hawi ya\", ati nari. ");
INSERT INTO jaa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Esito ya me yana tona me tokoma me kobo tonamemetemoneke Kanaha ya. Me tokehemetemoneke me ka abi Yako tohe taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Me hihiyarehimatamonaka. \"Yose ahabarehimataka. Sawihareka. Esito nafi ka kofenato amaka\". Keye tohahamone Yako ati ne ahabakosinima nematamonaka, me ati mitahari. ");
INSERT INTO jaa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Manakobisa he ni ya Yose ati nafi me kamina yayai nematamonaka waha, kaho awa nari, me hekamabona ka kaho Esito ya. ");
INSERT INTO jaa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ati yana nematamonaka. \"Hima. Okatao Yose sawikano. Owehibonaka ohabara owa mata\". ");
INSERT INTO jaa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yako tokomakehimatamonaka Beseba ya, bani mera ta nebonaha bati Isaki ka Teoso ni ya. Hinaka yama nafi towaka, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yama soki ya Teoso hihiyarehimatamonaka wata ya, he ha nari, \"Yako, Yako\", ati nari. \"Oha oke ahi\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","\"Teoso ama oke, abi ka Teoso ohamaro owa. Watorima tinahi. Tikahi Esito ya. Owati ihi tika noti me tamatehaba me amake fahi. Me kitatehaba me amake. ");
INSERT INTO jaa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Esito ya tiki ya e famahabone eke. Yama toyabo ya tika noti me kamatehaba me amake ahi owati ihi. Tihabi ya Yose sawihibonaka fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Manakobisa Yako yana tonehimatamonaka Beseba ya. Yako biti me me towakamehemetemoneke kaho ya, Esito ka towisawa ta hinahari, me ka abi toha, me ka yibote toharawa, me ka matehe bite toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yako me nafi tokehemetemoneke Esito ya. Me ka bani me me towaka, me ka yama nafi me towaka, nemetemoneke, me hihehemete Kanaha ya. ");
INSERT INTO jaa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yako biti mera towaka, hinaka noti mera towaka, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ihayeo me e nemetemone me amake ahi, me toka mati Esito ya, Yako mati: Hobi toha, Yako biti taiti tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Hobi biti me toha, Enoki, Baro, Hesiro, Kami me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yako biti owa Simiao toha, Simiao biti me toha, Semoweo, Sami, Owati, Saki, Soa me na mati. Simiao biti owa Sao toha, Kanaha ka fanawi biti tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yako biti owa Refi toha, Refi biti me toha, Seso, Kowati, Merari me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yako biti owa Yota toha, Yota biti me toha, Sera, Berisi, Isera me na mati. (Me ka ayo me ahabemetemoneke Kanaha ya, E ya Onaha me fama mati.) Beresi biti me toha, Hesiro ya Hamo me fama mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yako biti owa Isaka toha, Isaka biti me toha, Tora, Bowa, Sasobi, Siniro me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yako biti owa Seboro toha, Seboro biti me toha, Sereti, Ero, Sareo me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Afa Yako biti memetemone me amake, Reya biti mati, me wataha mati Mesobotamia ya, bite Tina toha naro. 33 me tohehemetemoneke, Yako biti mati, Reya famahari. ");
INSERT INTO jaa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Yako biti owa Kati toha, Kati biti me toha, Sifiao, Hakowi, Soni, Esibo, Eri, Aroti, Areri me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yako biti owa Ase toha, Ase biti me toha, Imina, Isifa, Isifi, Beriasi me na mati, bite Sera toha naro. Beriasi biti me toha, Hebe ya Marakieo me fama mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","16 me tohehemetemoneke, Yako biti mati, Sioba ya famahari, Reya ka yama aahi tohaharo, Rabao ta hinaharo bite Reya ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yako fati Hakeo tohaha biti me famemetemoneke, Yose ya Besami me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yose biti me famehemetemoneke, Manase ya Efarai me fama mati, fati Asenati toha biti mati, me wataha mati Esito ya. Botifera sitati Heriobori ka sasetoti tohe bitemetemone amake, Asenati. ");
INSERT INTO jaa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Besami biti me toha, Bera, Beke, Asibeo, Yera, Nama, Ei, Roso, Mobi, Hobi, Ariti me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","14 me tohehemetemone me amake, Yako biti mati, Hakeo ya famahari. ");
INSERT INTO jaa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yako biti owa Ta toha, Ta biti Hosi toha. ");
INSERT INTO jaa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Yako biti owa Nafitari toha, Nafitari biti me toha, Saseo, Koni, Sese, Sire me na mati. ");
INSERT INTO jaa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Me seti nemetemone me amake, Yako biti mati, Bira ya famahari, Hakeo ka yama aahi tohaharo, Rabao ta hinaharo bite ni ya Hakeo tohaharo. ");
INSERT INTO jaa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","66 me tohehemetemone me amake, Yako biti mati, me toka mati Esito ya. Biti me ka yibote toharawa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yose biti me watehemetemoneke Esito ya. Makoni 70 me tohehemetemoneke Yako me nafi, me tokaha mati Esito ya. ");
INSERT INTO jaa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yako ati ehene Yota tai tohehimatamonaka, Yose aate nebonaha, kamakibonaha, mera kobo nebonaha ahi Kose ka yama ya. Kose ya me kobo na ");
INSERT INTO jaa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yose he nanarifa yosehimatamonaka, hinaka kaho hawa tonihebona hinahari. Faya kamakimatamonaka Kose ya bati kobo nebonaha. Kobo hine hitiri hinehimatamonaka. Hitiri ni hiyabomatamonaka, ohi nari. ");
INSERT INTO jaa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Faya Yako ati yana nematamonaka. \"Tiwa owi ka hawa oha oke waha, ohababone owa. Yayai oke, tisawi karo, tihabarehemete tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Faya Yose ati yana nematamonaka Yako me nafi hiyarari. \"Esito ka towisawa ohiyarabone oke, owati e na owa ahi: 'Okoyo me toha, okobi me nafi toha na Kanaha ya me wina me kamakiharake, me winahabone mati owa ni ya', onahabone oke. ");
INSERT INTO jaa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Bani me nanarifa me te tohahamone onahabone oke, ofeya me toha, kabirita me toha, bowi me toha na mati. Te ka bani me te kakamamone onahabone oke, te ka yama nafi toha naro. ");
INSERT INTO jaa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Towisawa tera aate neba awaka. 'Himata yama te ahi tehani te amari?' ati neba awaka. ");
INSERT INTO jaa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Te ati e nabone teke ahi: ofeya me nanarifa me te tohatehamone te ati nabone teke, te ka iti bote me nima te namone te, yama ahi ni oneba te hiri ra te. Te ati e ni ya te winahabone teke Kose ka yama ya ati ehene. Esito ka ofeya me nanarifa me me nofatera me amake\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Manakobote Yose tokomematamonaka towisawa hiyarebonaha. \"Towisawa okobi toha okoyo me toha na me kakeharake Kanaha ka mati. Me sawike Kose ka yama ya, me ka bani me ya me taba mati, ofeya me toha, kabirita me toha, bowi me toha na mati, me ka yama nafi toha naro\". ");
INSERT INTO jaa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yama we one ya anoti me siko na mera towakematamonaka towisawa ni ya, towisawa me hiwahabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Towisawa mera aate nematamonaka. \"Himata yama te ahi tehani te amari?\" \"Ota ka hiti ofeya me nanarifa me ota tohate ota amake, ota ka iti bote me nimetema ota na ota. ");
INSERT INTO jaa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ota kakeha otake ahi ota winahabone ota. Kanaha ka masiri watamakere, bani me tafebana. Me nafi fimike kasiro ya fahi. Tiwa ota aate nineke, ota winahabone ota Kose ka yama ya tiwati amosi ya\". ");
INSERT INTO jaa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faya towisawa Yose hiyarematamonaka. \"Abi toha, ayo me toha na me kakeha me awineke tiwa ni ya, tiwa ya me tabahabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Me winahaboneke fara Esito kote me hinofa ya. Kose ka yama ta tinahabone tike me ni ya, me winahabone mati fahi. Kose ka yama amosi mati tohake. Esito kote one Kose nima na watakere. Me one bani me narifi wato yokana me toha me tiwasi ya oko bani me nanarifa me yoyose me tohahaboneke tiwati ihi bisa\". ");
INSERT INTO jaa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Manakobote Yose bati towakama nematamonaka towisawa ni ya, towisawa hiwehibonaha. Towisawa ka yama amosabone Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Towisawa aate hinehimatamonaka. \"Tika ano e na ama tiri?\" ");
INSERT INTO jaa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","\"Towisawa oko ano 130 tohake. Oko yobi ni fawa tera ama oke. Oko ano tofiyo kerewe rarake. Oko ano one tamake, yama nawaha hiri oni ka ano. Okiti bote me ka yama nawaha tamehemetemoneke bisa. Me ka ano ta fiya tonehemetemoneke oko ano ya, oko ano tamari karo\". ");
INSERT INTO jaa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Towisawa ka yama amosabone Yako ati ne faya tokomematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Faya Yose wami kote ta nematamonaka Yako me ni ya, fare towisawa ati nima ehene nari. Esito kote amosi mati tohehemetemoneke, sitati Ramesesi yabori ka wami tohaharo. Yako me ka wami tohawehemetemoneke, me winahabone mati fahi. ");
INSERT INTO jaa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Me wina Yose bati me tafebone tata tohehimatamonaka. Fara yamata me hinofa nafi ta nematamonaka me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tabora nafi ka yamata wawatama biti remetemoneke. Me fimi nafimisehemetemoneke. Esito ka me toha, Kanaha ka me toha na me kiti fawa nemetemoneke, fimi ihi. ");
INSERT INTO jaa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Esito ka towisawa ka yamata me ninika tohehemetemoneke. Yinero me ta na me ka yinero Yose yoro tokaniwame yinero towakamehimatamonaka towisawa ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Manakobisa yinero nafi ahabematamonaka, Esito ya Kanaha famaha ka yinero. Faya Esito ka me tokomakehemetemoneke Yose ni ya, me hihiyarebonaha. \"Ota ka hiti tiwa ota aate nineke, ota tefebone ta tinahabone tiwa. Ota ahabariyahi yinero ota kihamara ota\". ");
INSERT INTO jaa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Me ati Yose mite ati yana nematamonaka. \"Yinero te kihamara te ka bani me te kakamahi, yamata manakonebonehe\". ");
INSERT INTO jaa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Faya Esito ka me ka bani me me towakamehemetemoneke, yamata manakonebonehe. Kafaro me toha, ofeya me toha, kabirita me toha, bowi me toha, someto me toha nemetemoneke. Faya me ka bani me nafi tofiyohemetemoneke ano oharia ya. ");
INSERT INTO jaa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ano oharia ahaba ano one ya Yose me aate namatasehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","\"Ota ka hiti otara tiwato tike, ota ka yinero watamarihi, ota ka bani me watamarihi na ota, me nafi tihawa mati. Yama ta naba ota kihamakere, yamata manakonebonehe. Ota ahabariyahi tiwehene. Ota ka wami ota ta, ota abono ota ta, nabone ota ati na otake, yamata manakonebonehe. Ota ka wami toha ota abono toha na tihahabone tike. Towisawa ka yama aahi me ota tohawahabone otake. Ota ka wami ihawa nebonaka. Ota ka yamatabone ta tinahabone tike, ota ahabaribone karo. Yama noki ta, tinahabone tike, ota koro nabonehe, wami yama honara tohawaribone karo\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Manakobote Yose Esito ka wami nafi ihawematamonaka, towisawa ka wamibonehe. Esito ka me nafi ka wami me ta nemetemoneke, fimi kiti karo. Faya Esito ka wami nafi towisawa ihawematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yama aahi me tohawa nemetemoneke, Esito ka me nafi, Yose ati ehene. ");
INSERT INTO jaa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sasetoti me ta me hasi nemetemoneke, me ka wami me ta ra mati. Towisawa yamata tata tohehimatamonaka afa me ni ya, me tafebonehe. ");
INSERT INTO jaa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Manakobisa Yose mera hiyarematamonaka tasa. \"Te ka wami toha te abono toha na towisawa ihawareka waha, okanikaharo, hinakabonehe. Yama noki te nakamahi owa ni ya, te koro nabonehe fatara ya. ");
INSERT INTO jaa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Yama te koro na yana boni te bata ni ya boni isi ni kito tohaha te ta nabone teke towisawa ni ya. Kote one hasi na te koro, te kaba, nabone teke, te nafi wina te tefebonehe, te ka matehe toha naro\". ");
INSERT INTO jaa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Faya me yayai nemetemoneke. \"Ota ka hiti ota hasi na otake tiwehene. Yama amosake ota ni ya. Towisawa ka yama aahi me ota amake\". ");
INSERT INTO jaa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Haha yama towisawa hiri hiteha sawisa ke afa yama ya, e naro ahi: yama me koro na boni me bata na isi ni kito tohaha me ta te me amake towisawa ni ya towisawa ati ehene, Esito nafi ya. Sasetoti me ka wami ta towisawa ihawarehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ihayeo me wiwina tohehemetemoneke Esito ya, Kose ka yama ya, wami me kanika mati. Me kakahiwa toha me ka matehe totamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yako wine ka ano 17 tohehemetemoneke Esito ya. Hinaka ano 147 tohehemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ahabibona wato biti Yose ino hiri nematamonaka. Yose kamaki bati hihiyarehimatamonaka. \"Tiwa aate one oke, owati e na owa ahi: owa tikamorahabone tike ahi Esito ya. Tiwati omitabone oke, timano yoko tina tiwa ofanako bofe ya, Teoso ino titiha tiwa, keye hiri tiramone tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ohabi ya oko abohi sawirabone oke Esito ya. Owa tekamahabone tike, owa tikamohabone tiwa okiti me tame ya, hasi onahabone owa okiti me ya otaba owa\". \"E, yama tikamina hiri onahabone oke\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","\"Tiwati omitibeya, Teoso ino titiha tiwa, keye hiri tirahamone tina tiwa\". Faya Yose Teoso ino itihimatamonaka, keye hiri remona ati nari. Manakobisa Yako kama ya boko tonihe Teoso ha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yama totoyabo ni ya Yako yama kome awehi tamine me hikaminematamonaka Yose ni ya. Faya Yose bati yaka nematamonaka, biti me fama mera towakamahari, Efarai ya Manase me famaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yose kobo ne tamine me hikaminehimatamonaka Yako ni ya. \"Tikatao Yose tohe kakehareka tiwa yaka nebonaha\". Faya Yako kiti nafi tonihe hiwa itimise itarimatamonaka kama ya. ");
INSERT INTO jaa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yose hiyarematamonaka. \"Teoso kitabote hiwa namohimari amaka owa ni ya, sitati Rosi ya, Kanaha ya. Oko yama amosabone ati nemari amaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ati e nemarika ahi: 'Tikatao me tamahaboneke owati ihi. Tika noti me tamatehaboneke, me yoro tokana mati, me winakanikima na mati yama nafi ya. Haha wami ta otehabone oke tika noti me ni ya. Me ka wamiteboneke haro fara yama tohaha ya'\". ");
INSERT INTO jaa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yako Yose hiyarasa nematamonaka. \"Tikatao me fama okatao me nima me nineke, Efarai ya Manase me fama mati. Okatao Hobi toha, Simiao toha me na me nima me nineke, tikatao mati, me watemete mati Esito ya, okomakeri ya mata ahi. ");
INSERT INTO jaa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tikatao me one ni ya tika mebisa mebone me amake, okatao me nima me ra mati. Efarai ya Manase me fama tika yama me ihawai ya afa yama kote me ihahaba me amake, tikatao me one. ");
INSERT INTO jaa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Oyawamaro ama oke ami Hakeo ahaba ihi. Mesobotamia ya ota yana tona Kanaha ya ota kama ahabamaro amake Efarata yabori ya. Okomohamaroke hawi beheri ya fahi. (Efarata ini Bere tohawaineke.) ");
INSERT INTO jaa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Faya Yako Yose biti mera awe aate hinehimatamonaka. \"Hibake me amari ha?\" ");
INSERT INTO jaa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","\"Okatao me amake, Teoso me ta hinahamaro mati owa ni ya ahi Esito ya\", Yose ati nematamonaka. \"Me tekamahi ayata ya obeheri ya. Me ka yama amosabone onahabone oke\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yako bote tohe noko awi yokana tohamarehimatamonaka. Yose biti mera towakamematamonaka ayata ya bati beheri ya. Faya mera hitiri, mera komi nake, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ati yana nematamonaka, Yose hiyarari. \"Tiwa owamarahabone onahamaro ama oke. Tiwa owa, tikatao me owa, one oke, Teoso ati ehene\". ");
INSERT INTO jaa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Faya me famaha Yose mera yabame itarisematamonaka iso yobati ya, noko towarisahari bofe ya. ");
INSERT INTO jaa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Manakobisa hinaka kanihina ya Efarai wara tona, hinaka yasoka ya Manase wara tona ne mera towakamehimatamonaka ayata ya, Yako beheri ya tasa. Makoni Efarai warehimatamonaka Yako ka yasoka ka ya. Manase ware nematamonaka Yako ka kanihina wani ka ya. ");
INSERT INTO jaa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yako mano kafori mano fito kawahematamonaka. Faya mano kanihina forematamonaka Efarai tati ya. Mano yasoka fore nematamonaka Manase tati ya. Manase taiti toha Efarai yoto ke toha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Faya Yose ka yama amosabone Yako ati nematamonaka, ati e nari ahi: \"Teoso, efe Teoso ama tike, okiti Abaraao okobi Isaki me na tiwa me narifemete tiwa. Owa tekatomate ama tike fara yama tohaha ya, bani me nanarifa hinaka bani mera narife nima tina tiwa. Afa yetene me tekatomabone tike. ");
INSERT INTO jaa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Tiwa nanarifa owa kasomate ama tike, yama yofina owa boyo ribone karo. Tiwa nanarifa mera kakatomebonaka me fama mati. Yama toyabo ya afa me ihi owini me nafi wati nawahaboneke. Okiti Abaraao okobi Isaki me na me ini toha naboneke, me nafi me ini wati hiwahabone mati, afa me ihi. Me ka matehe me tama, me ka noti me tama tehaboneke tabora nafi ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yako ehene Yose nofarematamonaka, hinaka kanihina foreharo Efarai tati ya. Makoni mano tama hine mano hitihibona hinehimatamonaka, mano hibaribonaha Manase tati ya. ");
INSERT INTO jaa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ati yana nematamonaka. \"Abi tiwehene e rabone tike ahi. Owa taiti tohe tati ya tika kanihina forehaboneke hari\". ");
INSERT INTO jaa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","\"Bese owato oka hari. Manase ka noti me tamatehaboneke bisa, me kitaha mati. Nisori me ta me kiti mati tohahaboneke. Hinaka noti me tamatehaboneke, me yoro tokana mati, me winakanikima na mati tabora tamaha ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Afa yama wehe ya me ka yama amosabone Yako ati nematamonaka, ati e nari ahi: \"Yama toyabo ya ihayeo me one ka yama amosabone me ati na te ino me itihaba me amake, me ati e na mati ahi: 'Teoso tiwa kakatomehibonaka, fara Efarai ya Manase me fama mera kakatomi nima', me ati na mati\", Yako ati nematamonaka. Yako ehene e ne Efarai tai tonihematamonaka. Manase ta yotohimatamonaka ehene. ");
INSERT INTO jaa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yose hiyarematamonaka tasa. \"Owa tiwa tike, ohababone owa. Teoso te ya tabehibonaka. Tera towakamebonaka te ka iti bote me tabori ya. ");
INSERT INTO jaa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sike ka yama ta one oke tiwa ni ya. Ayo me ni ya Sike ta orahabone oke. Sike ka yama ohawahamaro ama oke amo me ni ya, me mowa ona owa oko yimawa ya oko wati famehi ya\", Yako ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yako biti mera ha nematamonaka, mera hiyarebonaha. \"Te kamahi ayata ya obeheri ya. Te ka yama natehaba okominibeya. ");
INSERT INTO jaa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yako biti mati, te nafi tohahi obeheri ya. Te ka abi Ihayeo tohe ati te mitibeya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","\"Hobi okatao taiti ama tike. Oko kiti ama tike. Okita owehenemaro ama tike. Tiwa tikahiyara tike, tikita tiwa mata ya. ");
INSERT INTO jaa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Faha kisi kitaha nima tine tike, katoma hiri tina tiwa. Tikita tika kiti me fiya kanahaba me amake, niso mati, yama hiyara hiri timete karo owa ni ya, oko yibote one oko yibote yokana amara amo tikana tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","\"Simiao, Refi te famaha me te, te ka ami fara oharike. Te ehene itike, te yehe honene ya. ");
INSERT INTO jaa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Me te wati kani ya osawirabone oke te ni ya. Te ya otabarahabone oke te ka heoniao ya. Me te waka nemete teke, te hamaha te. Te siwa na bowi me isi kowisari te ka nemete teke, me yaka namaribone karo. ");
INSERT INTO jaa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Teoso tera katomebonaka, te hamaha me te katoma te. Te ka noti me ebe onabone oke, me winakanikima nabone mati ihayeo me one baikani ya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","\"Yota niso tiwa me kahiyaraboneke, me mowi kanisa mati tinokosi ya. Tika kakako me kitaraba me amake tiwehene. ");
INSERT INTO jaa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Riyao biti ehene itihi nima okatao Yota te amaka. Itarisate amaka riyao nima. Homarisa te amaka riyao fana nima. Me ahi hireba me watakere, me hinakomehe kari. ");
INSERT INTO jaa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yota towisawa tohehibonaka. Hinaka noti me me yosetehaba me amake, me one. Yama me kakia yama me ta naba me amake he ni ya, tabora bara ka mati. Ati me hikatabehibonaka. ");
INSERT INTO jaa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ofa amosi mati toha ate ya hinaka someto matoka. Hinaka makari soko naka fi ya. Makari mese ka soko naka fi mamawa na ya, ama nima naro. ");
INSERT INTO jaa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Fi fawe ka noko mamawa ka. Ino sasawa ka, reiti fawe karo\". ");
INSERT INTO jaa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","\"Seboro winehibonaka ma witi ya, faha kabine ka yama ya, nafiyo sisi tona ka yama ya. Hinaka wami yowaboneke Sito ya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","\"Isaka someto kitehi nima naka. Someto homarisaka, yama weye nebonaha. Beheri owa ya yama one wa, beheri owa ya yama one wa nineke, weye hinabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wami amosamone ati nareka, hasi nebonaha. Faya homarisahareka, me weyeye hinihebonaha. Yama aahi tohe me ka yama ahi naka, hora neba watarari\". ");
INSERT INTO jaa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","\"Ta fara me one yosehibonaka. Fara ihayeo me ate ihi nima ehene nebonaka. ");
INSERT INTO jaa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ta e nebonaka maka nima, itaharo hawi beheri ya. Maka komaha hawi ya itaha kafaro tame wai naboneke. Ihi e ka owa kafaro weye hine tosamebonaka bari ka ya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","\"Oko Teoso tiwa noki oke, owa tikasomabone tiwa\". ");
INSERT INTO jaa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","\"Kati me mono hineba amaka yama boboti mati. Manakobisa mera kiyohiba amaka fahi\". ");
INSERT INTO jaa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","\"Ase ka wami amosa ka yama boni amosaboneke kasiro ya. Boni towisawa me hinofaboneke\". ");
INSERT INTO jaa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","\"Nafitari bato nima tine tike, kana nafarari yama kabani ya. Tika noti me amosaboneke, bato biti me nima\". ");
INSERT INTO jaa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","\"Yose tabora ka yama nima tine tike, yanaharo faha witi ya. Tokomisaboneke yama bari kani ya. Boni tamaboneke. ");
INSERT INTO jaa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tika noti me ka kakako me me mowa naboneke. Me me kiyohaboneke, me me tisa nabone mati. ");
INSERT INTO jaa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Titisa tama ni tikitabone tike, tika titisa tama ni fawa ra tiwa, timano kiti fawa ra tiwa, Teoso kite ehene, Yako ka Teoso. Teoso tiwa narifebonaka, bani me nanarifa nima nari. Tiwa bari kanehibonaka yati ehebote nima, tiwa me boyo ribone karo. ");
INSERT INTO jaa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yose bati ka Teoso Yose kasomebonaka. Yose ka yama amosaboneke Teoso kitabote ehene. Neme ka faha ta nebonaka. Wami boti ka faha na naboneke ehene. Yose ka bani me tama, hinaka matehe tama, naboneke. ");
INSERT INTO jaa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tika yama amosaboneke mata ya, Teoso ehene. Yati nemeha bote si tona ka yama aamosa raba ke. Teoso ka yama amosa kakehaboneke Yose ni ya, Teoso hiwasihari anoti me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","\"Besami robo hamehi nima naka. Mera mowa nebonaka, robo ehene kabe nima nari, yama wamini karo. Mera mowa ne bahi toke ya me ka yama ebe nebonaka\". ");
INSERT INTO jaa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Afa ihayeo me ate tohate me amake, me ate 12 na mati. Yako atimatamona amaka, biti me ka yama amosa natehabone ati nari. Fara me nafi tohaha me oohariki na mera kaminematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Manakobote Yako biti mera yosehimatamonaka. \"Ohaba okibone. Okiti bote me ya otababone oke e abohi taboro ya. Owa te kamohabone teke okiti bote me tame ya. Me tame tohate me amake yati hoti ya, Eforo ka wami ya, heti me ka owa tohahari. ");
INSERT INTO jaa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Tohate amake Makabera ya, Manere beheri ya, bahi kakamaki ya, Kanaha ya. Afa yati hoti Abaraao kanikematamonaka Eforo ni ya, afa beheri ka wami toha naro, me tame taboribonehe. ");
INSERT INTO jaa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Afa yama ya Abaraao fati Sara me fama me me hikamo, Isaki fati Hebeka me fama me me hikamo, Reya okomo onahamaro oke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Yati hoti beheri ka wami tabaha me kanikemetemoneke heti me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yako biti mera yose ati hawa tohe kama ya toforime faya ahabematamonaka fahi. Faya tokomakematamonaka hinakiti bote me ni ya me ya tabehibonaha e abohi taboro ya. ");
INSERT INTO jaa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yose bati abowi fito tokanamehimatamonaka, ohi nari, bati noko komi nakehari. ");
INSERT INTO jaa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yose ati ehene hinaka metiko Yako abowi me karafemetemoneke, batarebonaha. ");
INSERT INTO jaa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Karafe ka yama amo ni 40 tohemetemoneke me ihi. Fara Esito ka me abowi nafi amo ni nima amo ni nematamonaka. Esito me nafi yawehemetemoneke, Yako ahabe ehene, me yawi ka me amo ni 70 tohaha mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yawa amo ni fawa ni ya Yose mera hiyarematamonaka, towisawa ya tataba mati. \"Tera aate one oke, owati te kamina te towisawa ni ya, owati e na owa ahi: ");
INSERT INTO jaa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Okobi ahababona ya owa yosehareka, okomobonaha Kanaha ya, fare temenebona ya, temenebona hawa tonihemata hibati ya. Ati ehene yama hiri onahabone onahara oke, Teoso ati otiha owa, keye hiri orahamone ona owa. Tiwa aate one oke, okobi owakamahabone ona owa, okomobonaha. Okomo ya okomabone oke ahi\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","\"E, tikamahi. Tikamobonaka. Fara tiwati nima tiwehene nabone tike, yama hiri tinahabone tina tiwa abi ni ya, ati ehene\", towisawa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Manakobote Yose tokomematamonaka bati kamobonaha. He ya me tabehemetemoneke, towisawa ya tataba mati, Esito ka me ka hiti me nafi toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yose me nafi toha, anoti me nafi toha, nemetemoneke. Kose ka yama ya me one ta tohakosemetemoneke, mateherawaha, ofeya me toha, kabirita me toha, bowi me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Esito ka me sawi nemetemoneke, kafaro me me weyeri hina mati, me one yaka kana na mati kaho ya. Makoni me tamehemetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Atati ya me kobo ni ya Sotao kowani ya me ayakemetemoneke, e kamo tahi me hiri na mati, tiriko nanamosa ka yama ya. Me ohi ni amo ni seti nemetemoneke, me ohi ni kita mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Esito ka me ohi ni Kanaha ka me mita me ati yana nemetemoneke. \"Esito ka me ohi ni nafike\". Makoni yama ini me nawatemetemoneke, Abeo-Misirai tohahabonehe. ");
INSERT INTO jaa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Fare Yako ati ya me ihi tohehemetemoneke, biti mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Abowi me hekamematamonaka Kanaha ya. Makabera ya me kobo tonama yati hoti ya me hikamomatamonaka, tohaharo Manere beheri ya, bahi kakamaki ya. Abaraao hikanikemetemoneke heti me ka owa Eforo ni ya, me tamebonehe. ");
INSERT INTO jaa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yako kamo nowati ya Yose tokomematamonaka Esito ya, anoti me ya tabahari, me nafi toha na mati. ");
INSERT INTO jaa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yako ahabi nowati ya Yose anoti me abe hiyaremetemoneke. \"Yose era kakoba awaka. Manakone awehiba awaka aya yama hiyara e hiri nimaro karo he ni ya\". ");
INSERT INTO jaa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Faya Yose anoti me me yosehemetemoneke Yose ni ya, me atimone me kaminabone mati, me ati e namone mati ahi: \"Abi ahababona ka yama ya ");
INSERT INTO jaa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","otara yosehareka tiwa ota aate nabone ota, ota ati e na ota ahi: 'Tiwa ota aate nineke, tiwati somawamibone karo ota ni ya. Ota ehenemaro wati tiwahamarabone tike, yama hiyara ota hiri namaro ota tiwa ni ya, ayo me ota', ota ati nabone ati nareka. Makoni tiwati somawamabone tike ota ni ya, ota ehene hiyaramaro ota tiwa ni ya. Abi ka Teoso nanarifa me ota amake\", me ati nemetemoneke Yose ni ya, anoti me atimone me kamina mati. Faya Yose me ati mite ohi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Manakobote Yose anoti me aboni tokomakemetemoneke Yose ni ya. Me mowi kanisa me ati yana nemetemoneke. \"Ota tohake ahi. Tika yama aahi me ota amake\". ");
INSERT INTO jaa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","\"Te watorima nahi. Teoso ama okere, tera okatomahaba owa. ");
INSERT INTO jaa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tera owato oke, yama hiyara te hiri namaro te owa ni ya. Yama hiyara te hiri nabone te ati na Teoso yama amosa hiri nemari amaka. Teoso ehene te awake, tera kasomari, te ahabarahabone te fimi ihi, te tamaha te. ");
INSERT INTO jaa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Te watorima nahi. Tera owakatomabone oke, te ka matehe ya te tabaha te\", Yose ati nematamonaka. Yose ati e ne mera nofehimona ati ne ehene me yehe namisemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yose wiwina tohehimatamonaka Esito ya, anoti me ya tabahari. Hinaka ano 110 tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Winasa ne ya Efarai ka noti mera awehimatamonaka. Hinaka noti Maki tohe biti itarimatamonaka Yose behe toro ya, Maki Manase biti tohehi biti. Maki biti Yose fare biti tonihematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yama wehe one ya Yose anoti mera hiyarematamonaka tasa. \"Ohaba okibone. Yama owato oke, Teoso tera kasomabona ka yama. Hibati ya Teoso ati e nematamonaka ahi e ka iti bote me ni ya, Abaraao, Isaki, Yako me na mati. Wami ta nebona ati nematamonaka me ni ya, fare ino itihari, keye hiri remona ati nari. Makoni tera kasomebonaka, tera towakamebonaha afa wami ya\", Yose ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Faya Yose yama kaminematamonaka, me hiri hinahabonehe. Teoso ino me itihabone ati nematamonaka, yama hikamina me hiri nabone me ati na mati, keye me hiri ramone me ati na mati. Ati e nematamonaka ahi: \"Yama owato oke, Teoso tera kasomabona ka yama. Teoso tera kasome ya te tokomi ya oko abowi te towakamahabone teke\". ");
INSERT INTO jaa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yose ahabematamonaka, hinaka ano 110 tohi ya. Abowi me hikarafehimatamonaka. Faya abowi me hibehimatamonaka kasao ya Esito ya.");
INSERT INTO jaa_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Seowaki Sota ka towisawa tohe ka ano famaha nowati ya Babironia ka towisawa Nabokotonoso tohe kakehimatamonaka Serosarei ya, hinaka saotato me ya tabahari. Serosarei me moto kanehemetemoneke, me me mowa nabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Me abe mowa na Sota ka towisawa Seowaki tohe kitarematamonaka, hinaka saotato me ya tabahari, Teoso ati ehene. Teoso ka teboro ka yama one manakone fotaha Nabokotonoso me towakama nemetemoneke Babironia ya, Teoso ati ehene. Teboro ka yama me towakama me hinawatehemetemoneke me ka teoso ka teboro ya Babironia ya. Yama kibewemetemoneke yama manakone fotaha tabori ya me ka teoso ka teboro toro ya. ");
INSERT INTO jaa_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Faya Nabokotonoso he nanarifa me ka hiti Asibenaisi tohe yosehimatamonaka, Ihayeo me yetene ha nebonaha, Nabokotonoso nanarifa mebone mati. Me one Sota ka towisawa ka bareti me toha, me one Sota ka yama me kihaha me toha, nemetemoneke, me ha hina mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","Nabokotonoso ati e nematamonaka ahi, Asibenaisi yosehari. \"Me e naboneke ahi. Me hiyaya ni watarihi, me awi amosa, yama aberete ni me amosa, yama wato me nafi, Babironia ka yama kakatomi me wato, naboneke. Ota ati ya me tikanawana, ota ka yama hani nafi ya me tikanawana, tinahabone tike\", Nabokotonoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Fare towisawa ka yamata hikaba me kaba, fara fi hifaha me fawa, nabone ati nematamonaka. Me kanawani ka ano terei nabone ati nematamonaka. Me kanawani hawa tohi ya Babironia ka yama kakatomi me yana tonahabone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Me ate Sota tohaha me one sawi nemetemoneke, me me hikanawanabone me ni ya. Tanieo, Anania, Misaeo, Asaria, me nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Asibenaisi me inibone nawatematamonaka. Tanieo Beotesasa toha, Anania Sataraki toha, Misaeo Mesaki toha, Asaria Abetineko toha nawahematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Tanieo ati boti e nematamonaka ahi. \"Towisawa ka yamata okoba, hinaka fi ofawa, oni ya ohiyarahabone oke Teoso ni ya\". Faya Asibenaisi aate nematamonaka, towisawa ka yamata kabarihi, hinaka fi hifarihi, hinabonehe, tohiyarehibonaha Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Teoso ati ehene Asibenaisi Tanieo nofehimatamonaka. Tanieo aate hine ati amosebona taiti ya he narabo nima nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","Ati e nematamonaka ahi. \"Tanieo owati e nabone ona towisawa onakomeha oke. Towisawa oko hiti tohe ati ehene hinaka yamata te kaba, hinaka fi te fawa, nabone ati nareka. Te imamari ya towisawa tera awarayaho, me yetene one nima te ra te. Te ehene ohabariyahi towisawa ati ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Manakobisa Tanieo saotato hiyarematamonaka hari, efe saotato Asibenaisi hiyosehari mera kakatomehibonaha, Tanieo, Anania, Misaeo, Asaria me na mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","\"Hiba mata, otara totomi timatabana tike yama wehe 10 na ya. Hine ya yama koro na boni ta tinahabone tike ota kabahabonehe. Hine ya faha ota fawa, nabone otake. ");
INSERT INTO jaa_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Yama wehe 10 na ahabi ya otara tiwa, me yetene one tiwa, tinahabone tike, towisawa ka yamata me kabaha mati. Me awi nima ota awi ni ya tiwati amosa, me awi nima ota awi ri ya tiwati hiyarihi nabone tike ota ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Tanieo ati amosematamonaka saotato ni ya. Faya yama wehe 10 na ya mera totomi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Yama wehe 10 na nowati ya me 4 na me awi amosemetemoneke. Me yetene one towisawa ka yamata me kaba me awi amosi me fifiya nemetemoneke, Tanieo mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Faya towisawa ka yamata me kabamarihi, hinaka fi me hifamarihi hinabone saotato ati nematamonaka, me 4 na mati. Hine ya yama koro na boni me kabahabone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Me yetene 4 na yama nafi me watowahemetemoneke Teoso ati ehene. Yama hani nafi me wato nemetemoneke. Tanieo wata kamini wato, yama Teoso hinamoa kamini wato nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Ano terei na ahabi ya yama amo ni towisawa hikaminaha ya Asibenaisi me yetene nafi towakamehimatamonaka towisawa nokosi ya, towisawa narifi me yana tonahabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Faya towisawa mera hiyarematamonaka. Me yetene 4 na me fiya tonemetemoneke me yetene one ni ya towisawa ati nematamonaka, Tanieo, Anania, Misaeo, Asaria me na mati. Faya ati ehene he narifi me yana tonehemetemoneke waha, me 4 na mati. ");
INSERT INTO jaa_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Afa mera aate ne yama me hikamina amosemetemoneke he ni ya, yama me watohamone ati nari. Me ka yama wato mati tohahamone ati nematamonaka mata ya. Me ka yama wato fiya tonahamone ati nematamonaka Babironia ka yama wawato me nafi ka yama wato ya. ");
INSERT INTO jaa_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Tanieo sawi toyabomatamonaka Babironia ya. Sawisa nematamonaka Siro towisawa tohe ka ano taiti ya. ");
INSERT INTO jaa_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Nabokotonoso towisawa tohe ka ano taiti nowati ka ano ya watamimatamonaka. Watari hikanakomematamonaka. Makoni amo ni watorematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Faya mera ha nematamonaka, yama wawato me toha, inawa me toha na mati, me yoro tokana mati, me nafi, watari me hikaminebonaha he ni ya. Me kake towisawa nokosi ya me naoria ");
INSERT INTO jaa_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","ati yana nematamonaka. \"Owatamihara oke. Owatamiha oko wata owa kanakomehara oke. Oko wata yama hikamina owatora yama hikamina owatoabone onaharake\". ");
INSERT INTO jaa_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Towisawa ati me mita me ati yana nemetemoneke. \"Towisawa tihabateriyahi fara yama tohaha ya. Tika nanarifa me ota amake. Tika wata tikamini ya ota ni ya yama hikamina ota kaminaboneke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Towisawa me ati mite ati e nematamonaka ahi. \"Oko wata te kaminahi owa ni ya. Wata yama hikaminaha te kamina, nabone teke. Yama te kaminari ya te ahababa te amake. Tera me ti nabone teke owati ihi, te kote hinama tohahabone te. Te ka yobe me nahabi, nabone teke owati ihi, hasabote tohehibonaha. ");
INSERT INTO jaa_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Oko wata te kamini ya yama hikamina te kamina ni ya yama tamaha ta onahabana oke te ni ya manakone fotaharo. Tera onofamone onahabone oke me nafi ni ya bisa. Owati tohawaba watarabone oke owati e na owa. Makoni oko wata te kamina, yama hikamina te kamina, nahi owa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Me ati e namatasehemetemoneke ahi. \"Towisawa tika nanarifa me ota amake. Tika wata tikamini ya ota ni ya yama hikamina ota kaminaboneke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Towisawa ati yana namatasematamonaka. \"Te nawahabone te ati na te awineke, owa te watoa te, owati tohawarabone ona owa. ");
INSERT INTO jaa_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","Oko wata te kaminari ya te ahababa teke. Te ati hiyakere owa ni ya. Te abe hiyarani keye te hiri nineke owa ni ya. Te nawahabone te ati nani te awineke, owati tohawahabone te ati na te. Oko wata aboni te kaminahi. Wata aboni te kamini ya, keye te hiri ramone onahabone oke, wata yama hikamina te kamina ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Towisawa ati me mita me ati yana namatasemetemoneke, yama wawato mati. \"Towisawa yama e na me hiri naba me watakere, tikaminaha nima naro. Towisawa me kitakene me ati e naba watatera me amake, yama wawato me me yoseha mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Yama tikaminaha hiri hinakere. Afa yama teoso me ta me hiwatote amake. Tiwa ni ya teoso yama me kaminaba me winakere e ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Faya towisawa yawe hamawematamonaka kasiro ya. Mera kahabanehimatamonaka me me waka hinahabone mati Babironia ka yama wawato mati, me nafi toha mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","Towisawa ati ehene yama hani me rawi nemetemoneke, me waka nibone kaminaro. Faya Tanieo me me siba, nemetemoneke, towisawa nanarifa mati, me me waka, hinahabone mati, Tanieo mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Ariokimatamonaka, Babironia ka yama wawato mera nahabihibona ati nari, saotato me ka hiti tohahari, towisawa kakakatoma mati. Tanieo ati yana nematamonaka Arioki aate nari. ");
INSERT INTO jaa_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","\"Himataba towisawa ati kitara?\" ati nematamonaka, towisawa nanarifa aate nari. Faya Arioki yama kaminematamonaka Tanieo ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Manakobisa tokomakehimatamonaka towisawa ni ya. Towisawa aate nematamonaka, yama nonoki kawahebona hinahari mata, Tanieo watari hikaminebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Tanieo tokomematamonaka fare hinaka yobe ya. Kobo toname ya yama kaminematamonaka fara me one ni ya, Anania, Misaeo, Asaria, me na mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","Neme ka Teoso me ha nabone ati nematamonaka, mera aawawa nebonaha, yama namohibonaha me ni ya. \"E ahabariyahi, Babironia ka yama wawato me one ahabi ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Afa yama soki ya Tanieo yama awehimatamonaka Teoso hinamoaro, towisawa watari kaminari. Faya Teoso kahiyarehimatamonaka, ");
INSERT INTO jaa_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","ati e nari ahi: \"Teoso e kahiyaratebone eke fara yama tohaha ya. Teoso yama wato, kita, te amaka. ");
INSERT INTO jaa_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Efe yama tonihawahate amaka. Yama hiwe tonihawaha, faha fowe tonihawaha, te amaka. Hahi towisawa hinofe nawana, hahi towisawa hinofare itibasa, nebonaka. Yama wato ta te amaka yama wawato me ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","Yama watohinara kaminate amaka. Yama soki ya yama sawiha watote amaka. Yama oye sawineke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Faya amake one oke, okiti me ka Teoso tiha tiwa ni ya. Tiwa okahiyarine oke. Oko yama watobone ta tinahara tike. Okita onara oke tiwehene. Yama ota aate na ta tinahara tike, yama owato karo waha tiwehene. Towisawa watari ota watowahake, otara tikanawana tiwa\". ");
INSERT INTO jaa_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Faya Tanieo tokomaketasematamonaka Arioki ni ya, efe Babironia ka yama wawato mera nahabibona ati nari, towisawa ati ehene. Ati yana nematamonaka. \"Babironia ka yama wawato me tinahabiharabone tike. Towisawa ni ya owa tekami ya towisawa watari okominahabone oke he ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Faya Arioki Tanieo towakamehimatamonaka hibati ya towisawa ni ya. Ati yana nematamonaka. \"E ka owa owasihara oke, tika wata kamini watohibonaha towisawa. Sota ka me ka owa amaka, me te kakamaro mati, yama mowa ni nowati ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Towisawa Tanieo aate nematamonaka, hari ino owa Beotesasa tohahari. \"Oko wata aboni kamini tiwatobana? Yama hikaminaha tikamina tibana?\" ");
INSERT INTO jaa_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Tanieo towisawa ati mite ati yana nematamonaka. \"Yama wawato me watatera me amake, yama e na me watohaba mati, tikaminaharo, yama nihinararo. ");
INSERT INTO jaa_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","Neme ka Teoso ta yama nafi namo watote amaka. Yama namohinoka tiwa ni ya towisawa Nabokotonoso, yama natehabana. Tika wata e nineke ahi, tiwahanihi: ");
INSERT INTO jaa_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","Towisawa tika kama ya tiforia tiwati boti yama kaminani tiwa awine tike, yama natehabonehe. Teoso yama e watora kakamina tohahi yama namohinoka tiwa ni ya, yama natehabonehe. ");
INSERT INTO jaa_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Yama e watora Teoso kaminareka owa ni ya, oko yama wato fiya tora owa me one ka yama wato ya. Yama tiwatohabone Teoso ati nareka towisawa, wata tiwahanihi, tiwati boti ya yama kakehanihi\". ");
INSERT INTO jaa_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","\"Towisawa yama tekatoma yama kanamori tiwahani tike, nafiharo mata ya, waharo tinokosi ya oya kanaharo, yofinaro. ");
INSERT INTO jaa_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","Tati oro hinama toha, baki mani fami barata toha, nabati fanaki fami borosi toha, ");
INSERT INTO jaa_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","isi fami feho toha, nanike. Tame fami kote feho toha, kote atabo toha, nanike. ");
INSERT INTO jaa_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Yama tekatoma yati kote ehebote ti nakosanike atami ya, e ehene amararo. Yati sonaha yama kanamori tame kinahanike, hinahabihabanihi. ");
INSERT INTO jaa_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Hibati ya yama kanamori ahabanike nafi, feho toha, atabo toha, borosi toha, barata toha, oro toha naro. Homokori tohawanike, tiriko homokori nima, hasi naro, yama hiwe ya, tiriko e koho ni ya. Yama kanamori homokori toha boni hekanike, homokori itahaba watamaraharo. Yati ta hasi na yanaha atami ehebote tohawanike, tabora nafi nahabihabanihi\". ");
INSERT INTO jaa_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","\"Afa tika wata amake. Okominahaboneke tiwa ni ya mata, tiwatohabonehe. ");
INSERT INTO jaa_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","Towisawa ehebote ama tike. Towisawa me one e naba me watakere, tiwa nima me naba mati. Teoso neme ka ehene towisawa tihine tike. Tikita, tika amosi na, te ama tike Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","Tabora nafi ka me tiyosete ama tike Teoso ati ehene, bani me nafi toha na mati, wami ka me toha, neme ka me toha na mati. Yama kanamori tati oro toha ama tike\". ");
INSERT INTO jaa_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","\"Tinowati ya towisawa me one natehaba me amake, tiwa nima me ra mati, me kikita raba na mati. Afa me nowati ya towisawa me one na, tehaba me amake, borosi nima me na mati, tabora nafi ka me me yoseha mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","Afa towisawa me nowati ya towisawa me one natehaba me amake, feho nima me na mati kitaharo. Feho yama nafi nahabite amake kitaharo. Feho nima me tehaba me amake, towisawa me one me waka na mati, me nafi. ");
INSERT INTO jaa_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","Yama kanamori tame tiwahani tike, tame bite ya tabaharo, atabo hiri ni ya feho hiri ni tabaharo. Afa yama nima towisawa me tehaba me amake, me ebe kana mati. Me ebe kana me kiti yokana tohamara me kiti nasa tehaba me amake, feho kiti nima naro, atabo ya tabaharo. ");
INSERT INTO jaa_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","Yama kanamori tame bite feho hiri ni ya atabo hiri ni tabaha nima me tehaba me amake, me one kita me one kitarihi na mati. ");
INSERT INTO jaa_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","Feho ya atabo tabaha tiwahani tike. Feho ya atabo tabatera amake. Afa nima me na me natehaba me amake, me ebe kana mati, me abe nofara mati\". ");
INSERT INTO jaa_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","\"Afa towisawa me tohi ka yama ya neme ka Teoso mera yosi yana totehiba amaka, mera yosi fawa terebana. Afa towisawa me me yosemateraba me amake, me kitara mati Teoso ehene. Towisawa tohi fawa tereba amaka. ");
INSERT INTO jaa_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","Yati kote ehebote atami ya ti nakosani tiwahani afa yama kaminineke, yama nahabiharo, feho toha, borosi toha, atabo toha, barata toha, oro toha, naro, ahababonehe nafi\". \"Teoso kitatehi yama namoka tiwa ni ya towisawa, yama natehabana. Tika wata keye amakere. Yama wata hinamoa okomina owati tosawariaba watakere\". ");
INSERT INTO jaa_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Faya Nabokotonoso sonarisematamonaka Tanieo nokosi ya, tobokorisahari, Tanieo amosabote tohemona ati nari. Bani me nabowabone ati nematamonaka, me ta hinehibonaha Tanieo ni ya. Wami me sari kanabone ati, nematamonaka, Tanieo ka yama mahi amosaba nahabonehe. ");
INSERT INTO jaa_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","Faya Tanieo hiyarematamonaka. \"Keye amakere haro. Teoso me one e naba watakere tika Teoso nima, kiti mati tohahari. Towisawa me nafi ka towisawa tohate amaka. Yama e watora namote amaka. Makoni oko wata tikaminine tike owa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Manakobisa towisawa ati ehene Tanieo me ka hiti tohawematamonaka. Yama manakone nafiha ta, nematamonaka Tanieo ni ya, tamaharo. Babironia ka tabora nafi ka mera yosewehibona hinehimatamonaka waha. Babironia ka yama wawato me nafi ka hiti tohawebona ati, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Faya Tanieo towisawa aate nematamonaka, Babironia ka tabora ka me ka towisawa me tohahabone mati, he ya tataba mati, Sataraki, Mesaki, Abetineko me na mati, Nabokotonoso ati ehene. Ati amosematamonaka. Tanieo ta sawihimatamonaka towisawa taboro ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Towisawa Nabokotonoso mera yosehimatamonaka, yama kanamori me hiri nabone mati, oro hiri ni tohaharo. Ati ehene yama kanamori me nawehemetemoneke Tora ka yama amosa ya, sitati Babironia yabori ya. Wai ka tome 27 metoro toha, enoki tome 2 metoro 70 toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Yama wehe one ya mera ha nematamonaka, me ka hiti mati, yama kanamori yati me awahabone mati. Berefeto me toha, kofenato me toha, sowisi me toha, me ka hiti me one toha, nemetemoneke, me yoro tokana mati. Yama kanamori namohibona ati nematamonaka me nafi ni ya, me hikahiyarabonehe. ");
INSERT INTO jaa_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Me ka hiti me nafi me kakeha me nahohemetemoneke towisawa Nabokotonoso ka yama kanamori nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","Faya towisawa nanarifa ati yana nematamonaka kita ya. \"Te nafi ehene e nabone teke ahi, tabora nafi ka me te, te ati yoro tokana te: ");
INSERT INTO jaa_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Yama me hori, yama me teo, ni ya ayaka yoro tokana ati te miti ya te naorisahabone teke te iso yobati ya towisawa Nabokotonoso ka yama kanamori oro hiri ni tohaha nokosi ya, yama kanamori te nofaha te, towisawa ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Hahi iso yobati ya itarisare yama kanamori nofare fare bahi ya me koro hiwitibanaka yifo hiri ni ya, ahabebonaha, towisawa ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Faya yama me hori, yama me teo, na ayaka yoro tokana ati me mita me naorisemetemoneke me isi yobati ya hibati ya, towisawa Nabokotonoso ka yama kanamori oro hiri ni tohaha me nofaha mati. Me nafi tohehemetemoneke, tabora nafi ka mati, me ati yoro tokana mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Afa yama tohi ya yama wawato me one ati yana nemetemoneke, soteo me me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Towisawa Nabokotonoso me hiyaremetemoneke. \"Towisawa tika sawi fara tohatehabone tike fara yama tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Tiwati e namone tike ahi: Yama me hori, yama me teo, ni ya ayaka yoro tokana ati me miti ya me naorisahaboneke me isi yobati ya yama kanamori oro hiri ni tohaha nokosi ya, yama kanamori me nofaha mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","Hahi iso yobati ya itarisare yama kanamori nofare me koro hiwitibanaka yifo hiri ni ya, ahabebonaha, tiwati ihi. ");
INSERT INTO jaa_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Soteo me naharake, tiwati me nahabiha mati towisawa. Afa tiwati ihi Babironia ka me me yosi nofa me amake, Sataraki, Mesaki, Abetineko me na mati. Tika teoso me me narifarihi, tika yama kanamori oro hiri ni tohaha me nofarihi nofa me amake\". ");
INSERT INTO jaa_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Faya Nabokotonoso hamawematamonaka kasiro ya. Mera ati nematamonaka, Sataraki, Mesaki, Abetineko me na mati. Me me hekamehemetemoneke, me nahohabani mati towisawa nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Faya Nabokotonoso mera aate nematamonaka. \"Sataraki, Mesaki, Abetineko, keye me hiri ra me awine, tera me kamina mati? Oko teoso me te narifarini? Oko yama kanamori oro hiri ni tohaha te nofarihi nini? ");
INSERT INTO jaa_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","Owati e nara oke ahi. Yama me hori, yama me teo, na ayaka yoro tokana ati te miti ya te iso yobati ya te naorisa oko yama kanamori te nofi ya yama amosaboneke te ni ya. Te nofari ya tera me were towitiaboneke yifo hiri ni ya hibati ya. Teoso tera kasomeba neba ama? Teoso owa kasawarihiba neba ama, tera onahabiharaba owa?\" ");
INSERT INTO jaa_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Faya me ati yana nemetemoneke, Sataraki, Mesaki, Abetineko me na mati. \"Towisawa Nabokotonoso ota ati watarabone otake tiwa ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Yifo hiri ni ya otara me were towiti ya Teoso ota narife otara kasomeba awaka, otara tinahabiharahaba tiwa. Efe Teoso kitate amaka, era kasomebana yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Otara kasomi nofare ya yama tiwatohi fahi towisawa: Tika teoso me ota narifarabone otake. Tika yama kanamori oro hiri ni tohaha ota nofarihi nabone otake\". ");
INSERT INTO jaa_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Faya Nabokotonoso hami kite katoma hiri nematamonaka me ni ya, Sataraki, Mesaki, Abetineko me na mati. Ati ehene yifo me yokamakemetemoneke mata ya hiwe kitahabonehe. Hiwe kitamisi 7 nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Hinaka saotato me one kitabote me tohaha mera yosehimatamonaka, me me wete nabone mati, Sataraki, Mesaki, Abetineko me na mati, me me were hiwitiabone mati yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Faya me me wete na me me were nemetemoneke yifo hiri ni ya, me ka makari kihi, makari mese, makari isi, sabeo, makari one naro. ");
INSERT INTO jaa_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","Towisawa ati kite ati me hikatabe ka yifo hiwe kitehemetemoneke mata ya. Yifo hiwe kiti ka saotato me ahabemetemoneke, me me were towitia mati yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","Faya me foro nemetemoneke yifo hiri ni baikani ya, Sataraki, Mesaki, Abetineko me na mati, me wete na mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Faya Nabokotonoso noko awe waremisehimatamonaka hibati ya. He ya tataba mera aate nematamonaka. \"Me terei rani me awine, me me wete hina mati, me me were hiwitia mati yifo hiri ni ya?\" \"Ee towisawa\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","\"Me te awa ha, me 4 na mati, me owaha mati, me yaka na mati yifo baikani ya, me wete ra mati, me noho tora mati. Me terei na me ya tabehi teoso me ka owa awi tohaka\". ");
INSERT INTO jaa_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Faya Nabokotonoso tokomakehimatamonaka yifo beheri ya. Ati yana nematamonaka. \"Sataraki, Mesaki, Abetineko, teoso me nafi ka Hiti nanarifa mati. Te tasisi nahi. Te kamahi ahi\". Me terei na me tasisi nemetemoneke yifo ya, Sataraki, Mesaki, Abetineko me na mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Hibati ya me kakehemetemoneke me terei na me beheri yokana ya, me me awahabone mati, berefeto me toha, kofenato me toha, towisawa ya tataba me toha na mati. Faya me me awehemetemoneke, me noho tora mati yifo ihi. Me tati kone hatirihi, me ka makari hatirihi, yifo hasawiri mahi me weye rihi, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Nabokotonoso ati yana tasehimatamonaka. \"Me ka Teoso e kahiyarahi, Sataraki, Mesaki, Abetineko me na me ka Teoso. He nanarifa yosehi he nonofa mera kasomareka. Efe mera kasomebona me hine towisawa ati me kasawariharake. Teoso me one me me nofara me me narifarabone me ati narake. Me ka Teoso ohari ta me narifabone me ati narake. Me ahabi ya me ahaba nabone me ati narake, me ahabi me nakomera mati. ");
INSERT INTO jaa_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Makoni owati e nabone oke ahi: Sataraki, Mesaki, Abetineko me na me ka Teoso hiyaremona me ati na me atiba wataraboneke, me nafi, tabora nafi ka mati, me ati yoro tokana mati. Hahi ati e ne ne ya me ti hinehibonaka owati ihi, kote hinama tohehibonaha. Hinaka yobe me hinahabiha hinehibonaka owati ihi, hasabote tohehibonaha. Teoso owa me ka Teoso nima neba watakara, era kasomari. ");
INSERT INTO jaa_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Faya towisawa ati ehene Babironia ka me ka hiti ehebote me tohawehemetemoneke, Sataraki, Mesaki, Abetineko me na mati. ");
INSERT INTO jaa_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","\"Towisawa ama oke Nabokotonoso owa. Te ka yama hanibone amake haro, tabora nafi ka me te, te ati yoro tokana te, te winaha te yama nafi ya. Te taminahi. ");
INSERT INTO jaa_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Yama okominahabone onahara oke te ni ya, yama fotaha Teoso hiri hinaharo owa ni ya, teoso me nafi ka Hiti. ");
INSERT INTO jaa_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Yama hinamoa fotate amake. Yama hiri hina kita te amake. Towisawa tohi ahabatereba amaka. Era yosi fawa tere amaka. ");
INSERT INTO jaa_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Nabokotonoso oha towisawa ka yobe ya owina otaminamaro ama oke, oko kokoriri ni watara owa. ");
INSERT INTO jaa_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Faya yama soki one ya owatamiha oko wata owa kanakomehamaro ama oke. Oko kama ya oforiha wata ya yama yofina owaha kokoriri onamaro ama oke. ");
INSERT INTO jaa_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Faya owati ihi Babironia ka yama wawato me nafi kakehamaro me amake owa ni ya, oko wata yama hinamoa me kaminabone me ona mati owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Yama wawato me toha, inawa me toha, me na me yoro tokana me kakeha me ni ya oko wata okominahamaro ama oke. Yama hinamoa kamini me watoramaro me amake. ");
INSERT INTO jaa_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Manakobisa Tanieo kamakimari amaka fahi owa ni ya, oko wata okominabani owa he ni ya. (Efe Tanieo ino owa Beotesasa tohaka, oko teoso ino weye nari. Teoso me kitaha me kanamori sawiha me awineke he ni ya.) ");
INSERT INTO jaa_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","Owati e namaro ama oke he ni ya: 'Beotesasa yama wawato me ka hiti tihaha tiwa owato oke, teoso me kitaha me kanamori sawi karo tiwa ni ya. Yama e watora tiwato tike ha tiwa ta. Yama tiwatorahaba wataramone onara oke. Oko wata okominabone oke tiwa ni ya. Faya yama hinamoa tikaminabone tike owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","Oko kama ya oforiha oko wata e nara oke ahi owaharo. Wata ya yama owakatoma awa owahara oke waharo wami baikani ya, nemeharo mata ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","Awa yanaharake. Kitaharake. Awa ini tati biri kobo tomisarake neme ya. Tabora nafi ka me hiwaharake yama yabo ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","Awa afe amosa, boni tama, narake, me nafi hikababonehe. Ini baforine ya yama kabani ka bani me wina, ini ya neme ka bani me wina narake. Bani me nafi hikabarake, boni'. ");
INSERT INTO jaa_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","'Kama ya oforiha owatamiha wata ya yama owakatoma Teoso ka owa owahara oke, Teoso nanarifa, kakehari neme ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","Ha ni kitareka. \"Awa te ka nahi. Ini te ti, afe te bata, boni te were towiti nahi. Bani me watamariyahi ini baforine ya. Bani me one watamarihi niyahi ini ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","Mate ta ahabariyahi, habi ya tabaharo, wete naro feho borosi ya famaha ya. Mate habi ya tabaha tohasa naboneke wami ya, masiri baikani ya\". \"Efe winehibonaka yama kabani ya, bani me ya tabahari. Afa me nima nebonaka, mese afahari yama tanafari ihi. ");
INSERT INTO jaa_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","Hinaka yama nima ni e namaraboneke mata, e ka yama nima ni nima. Bani me ka yama nima ni nima hinaka yama nima ni nawahaboneke, Teoso ati ehene. Bani nima ne ka faha fowe 7 naboneke\". ");
INSERT INTO jaa_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","\"Efe yama hiyara hiri nemona Teoso hinareka. Teoso ati e ne ati he nanarifa me kaminineke, Teoso ka one mati. Tabora nafi ka me winaha me hiwatobonaka waha, teoso me nafi ka Hiti, tabora nafi ka mera yosehari. Owa amosiba watakarana towisawa tohi Teoso hinofe ya towisawa tohehibonaka ati ehene\"'. ");
INSERT INTO jaa_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","'Towisawa Nabokotonoso oha afa oko wata amake. Beotesasa wata yama hinamoa tikaminahi waha owa ni ya. Babironia ka yama wawato yama kamini me watohaba me watakere. Ha tiwa kamini tiwatoaboneke, teoso me kanamori sawi karo tiwa ni ya'. ");
INSERT INTO jaa_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","Manakobisa Tanieo Beotesasa tohe yama wati nawahe kokoriri nemari amaka. Towisawa hihiyaremarika. \"Beotesasa kokoriri tirahabone tike wata ihi, yama wata hinamoa ihi toha naro'. Beotesasa ati yana nemarika. 'Oko hiti yama wata hinamoa hiyakere. Yama hiyara kakehaboneke tiwa ni ya. Afa yama hiyara kakerene kakehaba amake tiwa ni ya. Tokehene amake tiwa me nofara me ta me ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","22","Wata ya awa tiwahani ama tike towisawa. Awa e nanike ahi: Awa yanaha kitahanike. Ini tati biri kobo tomisanike neme ya. Tabora nafi ka me hiwahanike yama yabo ya. Afe amosa, boni tama, nanike, me nafi hikababonehe. Ini baforine ya yama kabani ka bani me wina, ini ya neme ka bani me tabori na, nanike. Afa awa ama tike. Towisawa ehebote ama tike, tikita tiwa. Kobo timisa tike neme ya, tika amosi nafiha tiwa. Tabora nafi ka me tiyose tike, yama yabo ka tabora ka me toha na mati'. ");
INSERT INTO jaa_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","'Towisawa Teoso ka owa tiwahani tike, Teoso nanarifa, kakehari neme ya, ati saihari, ati e nari ahi: \"Awa te ka nahi, ahababonehe. Mate ta ahabariyahi, wete naro feho borosi ya famaha ya, tohasa nabonehe masiri baikani ya. Habi tohasa naboneke wami boti ya. Mese afehibonaka yama tanafari ihi. Winehibonaka yama kabani ya bani me ya tabahari, faha fowe 7 na ya\"'. ");
INSERT INTO jaa_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","'Towisawa tika wata yama hinamoa e nineke ahi: Yama hiyara hiri tinahamone teoso me nafi ka Hiti ati nareka. ");
INSERT INTO jaa_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","Makoni ati ehene me ya titabamarabone tike. Tiwinawahabone tike yama kabani ya bani me ya titaba tiwa. Masiri tikababone tike bowi me nima, timese afaha tiwa yama tanafari ihi. Tika faha fowe 7 nabone tike, tiwati e nabone tiwa ahi: \"Teoso me nafi ka Hiti tohe tabora nafi ka towisawa mera yosete amaka. Towisawa tohi me hinofi ya towisawa me hinihaboneke, fare ati ya\", tinahabone tiwa. Tiwati e ni ya tika yama nawaha ahababone tike fahi'. ");
INSERT INTO jaa_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","'Awa mate habi ya tabaha ahabarahabone Teoso nanarifa hinahani yama nateba namoke tiwa ni ya, e naro ahi: Yama toyabo ya towisawa tihamatasabone tike, tiwati e ni ya ahi, \"Neme ka Teoso e nafi yosete amaka\", tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","Makoni owati e nabone oke tiwa ni ya towisawa: Tika yama hiyara fawa tinihabone tike, yama amosa hiri tinahabone tiwa. Yama hiyara ya me hiri tikanamarabone tike, tiyahawaha tiwa me ni ya. Tiwehene e ni ya afa yama hiyara kakeraba awineke tiwa ni ya'. ");
INSERT INTO jaa_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","Wata yama hikamina nima na nemetemoneke towisawa Nabokotonoso ni ya, e naro ahi: ");
INSERT INTO jaa_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Faha fowe oharia ahaba nowati ya towisawa Babironia ya sawi hinaka yobe bari ya yaka ne ati yana nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","'Afa Babironia ka sitati amosake kasiro ya. Owehene amake, oko winibone hiri onamaroho, towisawa kitabote oha owa, oko amosi me nafi awahabone owa, owa me kahiyarabone owa'. ");
INSERT INTO jaa_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","Hiyarasa ne ya yama ati saihemetemoneke neme ya. 'Towisawa Nabokotonoso tiwehene hiyarineke. Makoni yama hiyara kakehaboneke tiwa ni ya Teoso ati ehene, e naro ahi: Towisawa tihamarabone tike mata Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","Ati ehene me ya titabamarabone tike. Tiwinawahabone tike yama kabani ya bani me ya titaba tiwa. Masiri tikababone tike bowi me nima. Tika faha fowe 7 nabone tike, tiwati e nabone tiwa ahi: \"Teoso me nafi ka Hiti tohe tabora nafi ka towisawa mera yosete amaka. Towisawa tohi me hinofi ya towisawa me hinihaboneke, fare ati ya\", tinahabone tiwa. Tiwati e ni ya tika yama nawaha ahababone tike fahi'. ");
INSERT INTO jaa_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Hibati ya Nabokotonoso afa yama Teoso nanarifa hikamina hiri ni yana tonehimatamonaka, Teoso ati ehene. Me ya tabamarehimatamonaka. Mese nafi afehimatamonaka yama tanafari ihi. Tati kone yane tati kone yabohimatamonaka sibiri efe nima. Yehe ataro yabo nematamonaka neme ka bani me ye atari nima. ");
INSERT INTO jaa_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","Faha fowe 7 na ahabi ya Nabokotonoso oha onokomisaro ama oke neme ya. Faya oko rabiki fawa naro ama oke. Faya teoso me ka Hiti okahiyararo ama oke, sawi fare tohatehari. Amosabote tohehimona onehiri amaka. Towisawa tohi ahabatereba amaka. Era yosi fawa tere amaka. ");
INSERT INTO jaa_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","Tabora nafi ka me kitakere ehene. Fara yama hinofa hiri te amaka, neme ka mera yosehari, bofe ka mera yose nari. He me kasawarihaba me watakere. Me watarihi ke, he me aate naba mati, 'Himata ebe tina ama tiri?' me ati naba mati. ");
INSERT INTO jaa_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","Teoso ati ehene oko rabiki fawa na oko yama amosi Teoso ta nameri amaka owa ni ya, owa me kahiyarabone owa towisawa oha owa. Oko nanarifa owa me siba naro me amake. Faya me ati ihi towisawa ohamatasaro ama oke. Oko yama amosi fiya tonaro amake waha mata ya. ");
INSERT INTO jaa_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","Faya towisawa Nabokotonoso oha neme ka towisawa okahiyarine oke waha, amosabote tohehimona onahari, ehene nafi amosari, ehene hiyareba watarari. Era e kahiyari ya yama watohibonaka era hiri kabona ka yama, e kokoma nabone e, ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Towisawa Beosasa he ya tataba me honaha mera mari nematamonaka, mio me toha mati. Marina ya me sawiha me ya tabe fi fawehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Fi fawe faya mera yosehimatamonaka, kobo me kakamabone mati, one oro hiri ni toha, one barata hiri ni toha naro, Serosarei ka teboro ka kobo, bati Nabokotonoso tohe hiyabemete fahi. Afa kobo ya fi fawehibona ati nematamonaka, me ya tabahari, he ya tataba me toha, fati toharawa, haha hine ya hikanahiwarawa toharawa naro, fati amarawararo. ");
INSERT INTO jaa_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","Faya kobo oro hiri ni tohaha me kakamemetemoneke, Serosarei ka teboro ka kobo, afa kobo ya towisawa fi fawehibanoho, me ya tabahari, he ya tataba me toha, fati toharawa, fati hine ka toharawa naro. ");
INSERT INTO jaa_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Fi me fawaha teoso bara me me kahiyaremetemoneke, me kanamori oro hiri ni toha, barata hiri ni toha, borosi hiri ni toha, feho hiri ni toha, awa hiri ni toha, yati hiri ni toha na mati. ");
INSERT INTO jaa_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Hibati ya e yehe fotokia yama hani rawi ni yana tonehemetemoneke towisawa ka yobe ka yama bari kani tori mese ya, nabarina tabori kawari yabori ya. E yehe yama hani rawi na towisawa hekatomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","Faya noko toba tonehimatamonaka. Yama nakome fanako fawa tokane hoyahoya kana nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","Faya towisawa yama wawato me ini hiri nematamonaka me yoro tokana mati, inawa me toha na mati, Babironia ka yama wawato mati. Me kobo namakia mera hiyarematamonaka. \"Hahi yama hani kawana ati watohi ati hikamini ya owa ni ya owakawehibonaka yama amosa ya. Owati ihi makari mamawa na weye, kasaro oro hiri ni toha weye, me nafi ka hiti tohawa, nebonaka, towisawa me famaha me ka owa tohawahari\". ");
INSERT INTO jaa_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Yama wawato me nafi kake yama hani ati me watoremetemoneke. Ati kamini me hiwatorihi hinehemetemoneke towisawa ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","Faya towisawa Beosasa kakome nafimisehimatamonaka. Noko toba toni kitamisa nematamonaka. He ya me tabaha me honaha me ihiba me watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","Faya towisawa mati towisawa me ati mitahani kakehemetemoneke marina tabori ya. \"Towisawa tihabateriyahi fara yama tohaha ya\", ati nemetemoneke. \"Kakomerima tinahi. Tinoko toba toni fawa nahi. ");
INSERT INTO jaa_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","E ka owa e taboro ya winaka, he ni ya teoso me kitaha me kanamori sawi kari. Abi sawi ka yama ya me hiwasimatamonaka, yama wato nafihari, fara teoso me ka yama wato nima hinaka yama wato naro. Abi towisawa Nabokotonoso tohe ati ehene yama wawato me ka hiti tohawematamonaka, yama wawato me yoro tokana me ka hiti. ");
INSERT INTO jaa_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","Abi ehene e nematamonaka, Tanieo ka yama wato nafi karo, e ka wata kamini wato, yama nihina ra kamini wato, ne karo. Tanieo tohe towisawa ino hinawatematamonaka, Beotesasa tohebonaha. Tanieo ino hiri tinahi, kakehibana. Yama hani ati kamini watohibonaka. Ati hikaminaboneke tiwa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Faya Tanieo me kakamemetemoneke towisawa ni ya. Towisawa hihiyarematamonaka. \"Efe Tanieo ama ti, Sota ka me ka owamata tiwa, me me hekamemete mati, yama mowa ni nowati ya? ");
INSERT INTO jaa_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","Tiwa me kaminarake owa ni ya. Teoso me kanamori sawihamone me ati narake tiwa ni ya. Makoni tika yama wato nafihamone me ati narake. ");
INSERT INTO jaa_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","Yama wawato me me kakamarake owa ni ya, yama hani kawana ati me watohabone mati, ati me hikaminabonehe owa ni ya. Yama hani mera kasawariharake. ");
INSERT INTO jaa_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Yama kamini tiwatohamone me ati narake, yama nihina ra kamini tiwato tinamone tiwa. Yama hani kawana ati tiwato ya ati tikamina tini ya owa ni ya owati ihi makari mamawa na weye, kasaro oro hiri ni toha weye, me nafi ka hiti tihawa, tinahabone tike, towisawa me famaha me ka owa tihawaha tiwa\". ");
INSERT INTO jaa_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Towisawa ati Tanieo mite ati yana nematamonaka. \"Tika yama manakone fotaha hine tohake tiwa ni ya. Me one ta tekawabone tike. Tika yama onofara yama hani ati oyababone oke, ati okominabonehe tiwa ni ya towisawa\". ");
INSERT INTO jaa_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","\"Towisawa abi Nabokotonoso tohe kitabote tohehimarika, hinaka yama amosi nafi naro, teoso me nafi ka Hiti tohe ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","Efe Teoso ati ehene towisawa ehebote tohehimarika. Makoni tabora nafi ka me hinakomehemarika, me ati yoro tokana mati. Haha me ahababone towisawa me hina me ahaba, haha me hasi nabone me hina me hasi, namaroke. Haha me hinawatabone me hina me hinawata, haha me hiyababone me hina me hiyaba, hinamaroke, fare ati ya. ");
INSERT INTO jaa_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","Manakobisa yama one ya hiwa kahiyare towisawa tohamarebona Teoso hinehimarika. Hinaka yama amosi fawa namaroke Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Me ni ya winamarebona Teoso hinehimarika. E ka yama nima ni nima hinaka yama nima ni namara, bani me ka yama nima ni nima hinaka yama nima ni nawahemeteke Teoso ati ehene. Yama kabani ka someto me ya tabawemataka, masiri kabahari bowi me nima. Mese afa nemataka yama tanafari ihi. Faya yama toyabo ya rabiki fawa nemataka fahi, ati yana nawahari, ati e nari ahi: 'Teoso me nafi ka Hiti tohe tabora nafi ka towisawa mera yosete amaka. Towisawa tohi me hinofi ya towisawa me hinihaboneke, fare ati ya', ati nari\". ");
INSERT INTO jaa_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","\"Ha tiwa Beosasa tiwa efe biti tihaha taminemata tiwato tikana tiwa tikahiyara kokoma tikere. ");
INSERT INTO jaa_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","Tika amosi fiya tonamone tine tike neme ka Hiti amosi ya. Tiwati ihi hinaka teboro ka kobo me kakamanike, afa kobo ya fi tifawabone tiwa, me ya titaba tiwa, tiwa ya tataba me toha, tika yibote toharawa, tika yibote hine ka toharawa naro. Teoso bara me tikahiyarani tike, me kanamori oro hiri ni toha, barata hiri ni toha, borosi hiri ni toha, feho hiri ni toha, awa hiri ni toha, yati hiri ni toha na mati. Afa teoso yama me awarihi, yama me mitarihi, yama me watorihi ke. Afa teoso me tikahiyara Teoso yokana ta tikahiyararani tike. Yama hiri tinaha nafi efe Teoso ehene amaka. Tika ahabi nofe ya tihaba, tika hasi ni nofe ya hasi, tinahabone tike, ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","Makoni ati ehene e yehe yama hani rawi kananike yama bari kani ya\". ");
INSERT INTO jaa_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","''Yama hani ati e nineke ahi: Mene, mene, tekeo, baresi\". ");
INSERT INTO jaa_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","\"Afa kamini amake haro. Mene ati e nineke ahi: Towisawa tihi ka yama amo ni Teoso tomi kanaka. Towisawa tihi ka yama amo ni ahabakibone Teoso ati ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","\"Tekeo ati e nineke ahi: Tiwehene amosiba watakere Teoso hiwaharo. Yama kanahari nafira nima tine tike, kanahari me tomi hikanaro barasa ya\". ");
INSERT INTO jaa_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","\"Beresi ati e nineke ahi: Towisawa tihi ka tabora me ebe kanahabanake. Me hihahabanake Metia ka me ya Besia ka me tabaha mati, Teoso ati ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Faya Beosasa ati ehene Tanieo me weyeye nihemetemoneke makari mamawa na ya. Namiti ya kasaro oro hiri ni tohaha ya me weyeye hikani, me nafi ka hiti tohawa, nematamonaka Beosasa ati ehene, towisawa me famaha me ka owa tohawahari. ");
INSERT INTO jaa_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Afa yama soki ya Beosasa Babironia ka towisawa tohe me nahabiemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Tario Metia ka tohe Babironia ka towisawa tohawematamonaka, hinaka ano 62 tohaharo. ");
INSERT INTO jaa_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Towisawa Tario tohe kofenato mebone 120 me tohaha mera wasimatamonaka, tabora nafi ka yama me kakatomahabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","Kofenato me ka hiti mebone me terei na Tario mera wasi, nematamonaka. Afa me terei na me ka owamatamona amaka Tanieo. Kofenato fara me ihi me kaminabone towisawa ati nematamonaka me ka hiti me terei na me ni ya, towisawa ka yama kakatomi me amosabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Faya Tanieo ehene aamosa tohehimatamonaka, me ihi kakatomahari. Makoni me nafi ka hiti Tanieo tohawebona towisawa ati nematamonaka waha. ");
INSERT INTO jaa_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Towisawa Tanieo nofe ati tamine me one mita yama me nofarabone me ati nemetemoneke, kofenato me toha, me ka hiti me famaha me toha na mati. Tanieo ehene hiyare me siba nemetemoneke, towisawa ka yama kakatomahari. Ehene hiyare me hiwasi ya me hora hikanebona me hinehimatamonaka towisawa ni ya, me ka hiti tohamarebonaha. Tanieo ehene hiyare me siba na yama me hikasawariemetemoneke, Tanieo ehene hiyareba watare karo. Me ka yinero iharihi, hinaka yama ahi ni hiyaraba watarihi, nemetemoneke, towisawa ka yama kakatomahari. ");
INSERT INTO jaa_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Tanieo ehene hiyare me wasira faya me ati yana nemetemoneke. \"Tanieo ehene e hora kanehiba e wasirabone eke, towisawa ka yama kakatomahari. Ehene owa e siba nebanaka, hinaka teoso narifari, teoso bare nofahari\". ");
INSERT INTO jaa_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Faya kofenato me toha, me ka hiti me famaha me toha na me tokomakemetemoneke towisawa ni ya, towisawa me hiyarabone mati. \"Towisawa Tario tihabateriyahi fara yama tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","Ota abe hiyara ota nafi ati e nineke ahi, kofenato mati, kofenato me ka hiti mati, berefeto mati, e ka hiti me one toha na me ota. Tiwati ka yama hani me rawi naboneke tiwati ihi, ati e naro ahi: Yama wehe 30 tohaha ya me nafi tiwa aate naboneke tiwaharia tiwa towisawa. Teoso me one me aate rihi, e one me me aate rihi, naboneke. Hahi me one aate ne ya me koro hinisebonaka riao me hoti ya, riao me hikabebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","Towisawa afa yama tikaminabone tike, tiwati hani me rawi nibone karo. Towisawa tihaha tiwati ihi tiwati hani me rawi ni ya yama tohawahaba wataraboneke. Metia ka me ya Besia ka me tabaha me e tohaha e ka towisawa ati hano tohawatere amaka\". ");
INSERT INTO jaa_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Towisawa Tario me ati nofe afa yama hani me rawi kanabone ati nematamonaka. Yama hani hawa tohehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Towisawa ka yama hani tamine Tanieo mite tokomematamonaka fare hinaka yobe ya. Tokomisematamonaka fare hinaka kowahato ya, hinaka yobe bari ka owa towitaremisehi ya. Kowahato ka nokobi bite wanehemetemoneke Serosarei tohi ka yama ka ya. Nokobi se kane iso yobati ya itaririse Teoso haha tohehimatamonaka, \"Faya amake\" ati nari, ha ni terei hinahari fara yama wehe oharia ya. Fare ehene totoha tohe ehene tohasa nematamonaka, towisawa ka yama hani tamine mite ya. ");
INSERT INTO jaa_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Afa Tanieo kakako me toha me tokomake Tanieo me towasimakiemetemoneke Teoso ha nari, aate hinahari, he kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","Faya me tokomemetemoneke towisawa ni ya me aate hinehibonaha, hinaka yama hani me kamina mati. \"Tiwati ka yama hani na awineke, ati e naro ahi: Yama wehe 30 tohaha ya me nafi tiwa aate naboneke tiwaharia tiwa towisawa. Teoso me one me aate rihi, e one me me aate rihi, naboneke. Hahi me one aate ne ya me koro hinisebonaka riao me hoti ya, riao me hikabebonaha, tika yama hani ati na awineke\". \"Keye amakere\", towisawa ati nematamonaka. \"Oko yama hani ati amake. Yama tohawahaba wataraboneke. Metia ka me ya Besia ka me tabaha me e tohaha e ka towisawa ati hano tohawatere amaka\". ");
INSERT INTO jaa_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Faya me ati yana tasehemetemoneke. \"Tanieo tika yama hani ati nofakara towisawa, efe Tanieo Sota ka me ka owa, me me hekamehemete mati yama mowa ni nowati ya. Tiwati nofare awaka, fare Teoso ha ni tohasa nari, ha ni terei hinahari fara yama wehe ya\". ");
INSERT INTO jaa_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Towisawa me ati mite yawi nafihimatamonaka. Faya Tanieo kasomebona ati nematamonaka. Tanieo kasomibona siba ne yama hikasawari bahi tokamatematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Faya me tokomaketasemetemoneke towisawa Tario ni ya. \"Towisawa yama wati tiwahahi ahi. Towisawa tihaha tiwati ihi tiwati hani me rawi ni ya yama tohawahaba wataraboneke. Metia ka me ya Besia ka me tabaha me e tohaha e ka towisawa ati hano tohawatere amaka\". ");
INSERT INTO jaa_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Faya towisawa mera yosehimatamonaka Tanieo me tonakamabone mati. Tanieo me kakama me koro hinisematamonaka riao me hoti ya. Towisawa Tanieo hiyarematamonaka. \"Tika Teoso tiwa kasomaho, narifi fare tihahari\". ");
INSERT INTO jaa_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","Yati ehebote me kakama riao me hoti noki bori me bari kanemetemoneke. Faya nokobi towisawa moya kanematamonaka fara hinaka aneo ya, he ya tataba me ka aneo toha na ya, Tanieo me kasomaba me wataribone karo. ");
INSERT INTO jaa_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Faya towisawa tokomematamonaka hinaka yobe ya. Yama soki ya amo ni watorematamonaka. Tafarihi nematamonaka. Me yayai hinihebona mera nofarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","Yama hiba wa ni ya towisawa yana ne tokomakabote nematamonaka riao me hoti ya. ");
INSERT INTO jaa_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Yaka toname riao me hoti yabori ya Tanieo ha nematamonaka, ati kokoriri nari. \"Tanieo Teoso yati ne nanarifa tihaha tika Teoso tiwa kasomi watohino awa riao me ni ya, narifi fare tihahari?\" ");
INSERT INTO jaa_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Faya Tanieo ati yana nematamonaka. \"Towisawa tihabateriyahi fara yama tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","Oko Teoso he nanarifa yosekiareka, riao me inohoti boko nebonaha. Owa me noho tonihararake, owehene hiyara watari karo Teoso ni ya. Owehene hiyara watarihi ke tiwa ni ya towisawa\". ");
INSERT INTO jaa_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Towisawa yayai ni nafihimatamonaka. Mera yosehimatamonaka, Tanieo me itihabone mati hoti ya. Me hitihi me hiwe hihiya neba watarematamonaka, Teoso hekatomebona ati ne karo. ");
INSERT INTO jaa_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Manakobisa towisawa ati ehene me me kakamemetemoneke, Tanieo me yokoha mati. Ati ehene me me were nisemetemoneke riao me hoti ya, me ka yiboterawa ya me tabaha mati, me ka matehe toha na mati. Wami ya me foro ri ya mata riao me me warara hinehemetemoneke, me tone nafi me baka hina mati. ");
INSERT INTO jaa_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Manakobote towisawa Tario ati ehene yama hani me rawi kanemetemoneke he ati kaminabonehe me nafi ni ya, tabora nafi ka mati, me ati yoro tokana mati. Yama hani ati e nemetemoneke ahi: \"Te taminahi. ");
INSERT INTO jaa_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Towisawa oha owati e nineke ahi: Tanieo ka Teoso me nakome, me hinofa, hinehibonaka, me nafi, tabora nafi ka mati. Efe Teoso yati te amaka. Ahabaterebonaka fara yama tohaha ya. Era yosi fawa terebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","Era kasomate amaka. Yama fotaha hiri te amaka, neme ka yama toha, bofe ka yama toha naro. Tanieo kasomenoka, riao me kitaha me hinabowarebonaha\". ");
INSERT INTO jaa_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","Faya Tanieo sawi amosematamonaka Tario towisawa tohe ka yama ya, Siro towisawa tohe ka yama toha na ya, Siro Besia kari. ");
INSERT INTO jaa_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","Yama soki one ya Beosasa Babironia ka towisawa tohe ka ano taiti tohi ya Tanieo fare hinaka kama ya forehi watamimatamonaka. Watari ya Teoso yama namohimatamonaka. Tafihi yama hani rawi kanehimatamonaka yama watari hiwaha kaminari. ");
INSERT INTO jaa_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","Afa amake haro rawi hinehemete: \"Haha yama soki ya owatamiha boni kitaha watari owahara oke kakirawaro yama nafi ya, faha rike hiri naro ma nafiha ya. ");
INSERT INTO jaa_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","Faya yama fotarawaha katafirawa kimisarawarake hibati ya ma ya yama 4 narawaro, awi hiyaya narawaro, one awi ya awi toharawararo. ");
INSERT INTO jaa_vpl VALUES ("DN7_4","028_7_4","DAN","7","4","4","Tai toha riao awi nima awi narake, sibiri efe nima afe naro. Yama owakatoma mani me soba hiwitikimaharake. Me hinawamisa isi ya yaka narake, e yaka ni nima. E ati boti nima ati boti nawaharake\". ");
INSERT INTO jaa_vpl VALUES ("DN7_5","028_7_5","DAN","7","5","5","\"Afa ketebe ka one awi e narake oso awi nima. Isi ya wamisa bani tahari tone terei ne mo kanahareka inohoti ya. Yama barabisa ati yana narake ati e naro ahi: 'Yana tinahi bani me ime tamaha me ime tikabibeya', ati naro he ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN7_6","028_7_6","DAN","7","6","6","\"Afa nowati ya yama one owatasahara oke, yome awi ya awi tohaharo, tati 4 na bari ka mani afe 4 tokaha naro, bani biti efe nima afe naro. Haha yama Teoso ati ehene me nafi yoyosebone amake\". ");
INSERT INTO jaa_vpl VALUES ("DN7_7","028_7_7","DAN","7","7","7","\"Yama terei narawa nowati ya yama one yotoha Teoso hinamoa awi yofini mati tohaharake. Kitaharake kasiro ya. Ini yaboharake ini feho tohaharo. Era kabi ya era sibi naboneke. Yama hikaba hasi na baro naboneke mani ya hinahabihabonehe. Haha yama hihiya nabisarake. Haha terei narawa awi ya awi tohara warabi awe 10 tokaharake. ");
INSERT INTO jaa_vpl VALUES ("DN7_8","028_7_8","DAN","7","8","8","Warabi awe owakatoma warabi awe one yanamakeharake, nafiraro. Fara warabi awe one basakani ya kawariarake. Warabi awe terei kana me bore hikanarake warabi awe yotoha nafira taboribonehe, noki naharo, e noko nima. Warabi awe yotoha ati saiharake fara inohoti ya hine kahiyaraha ati\". ");
INSERT INTO jaa_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","\"Yama owakatomasa ona yama owahara oke towisawa me nanahori me si hikaniharo. Towisawa iitari owa ya itaririsareka, fara yama tohateha ya tohahari, borone sawahari neme sabi nima, tati kone sasabohi nari ofeya kone nima. Iitari kakaroro kana kihi awi e narake yifo hiri ni awi nima. ");
INSERT INTO jaa_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","Iitari ka yama ya faha yifo hiri ni toaha tokisarake. Me tamaha me hikahiyarareka itariari iitari ya. Me tami mati toha me isi ya me naoharake he nokosi ya, he ya me tabaha mati, he nanarifa mati. Faya me nafi ihi manakone nahabi yana tonaharake fahi. Yama hani me se narawarake\". ");
INSERT INTO jaa_vpl VALUES ("DN7_11","028_7_11","DAN","7","11","11","\"Yama owakatomasa oni ya yama warabi awe nafira ati fara tohasa narake era e kahiyara e ati hiri naro. Faya aya yama yotoha me nabowarake, owaharo, warabi awe nafira kihi. Abohi kote me sibi hina me were hinarake yifo ya. ");
INSERT INTO jaa_vpl VALUES ("DN7_12","028_7_12","DAN","7","12","12","Yama one terei narawa kiti me fawa hiniha me waka hirawararake mata. Sawi totoyabo kawaharawaboneke Teoso ati ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","\"Aya Teoso yama hinamoa ahi afa yama soki ya e nima ne owahara oke, kakehari neme sabi ya. Tokomakehareka hahi fara yama tohateha ya tohehi ni ya. Me hikaminareka me hinamoari he ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Teoso hekawareka towisawa kitibona ya. Me hikahiyarebona Teoso hinareka, me ka towisawa tohe kari. Mera yosehibona Teoso hinareka, me ka towisawa tohe kari. Makoni me nafi hinarifebonaka, tabora nafi ka mati, me ati yoro tokana mati. Kiti ahabihinaterebonaka. Mera yosi fawa rihi tehibonaka\". ");
INSERT INTO jaa_vpl VALUES ("DN7_15","028_7_15","DAN","7","15","15","\"Yama Teoso hinamoa owa ero nihara oke. Kokoriri onahara oke yama owaha ihi. ");
INSERT INTO jaa_vpl VALUES ("DN7_16","028_7_16","DAN","7","16","16","Haha me naoha me ka owa ni ya okomakehara oke aate onebanoho, yama owaha kaminebonaha. Yama kamine ati e nareka ahi: ");
INSERT INTO jaa_vpl VALUES ("DN7_17","028_7_17","DAN","7","17","17","'Haha yama fotarawa 4 narawa nima towisawa me tehaboneke, bofe ka me nafi me me mowa tehabone mati, me tabori me ihawatehabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN7_18","028_7_18","DAN","7","18","18","Manakobisa yama toyabo ya me me yosemateraboneke. Teoso kiti mati tohehi ka me ta me me yosetehaboneke Teoso ati ehene. Afa me me yosetehaboneke fara yama tohaha ya', ati nareka\". ");
INSERT INTO jaa_vpl VALUES ("DN7_19","028_7_19","DAN","7","19","19","\"Haha yama yotoha tamine miti tabiyo owara oke, hihiya nabisaro, awi yofini mati tohaharo, ini feho toha, ye atari borosi toha, naro, era kabi ya era sibi naro, yama hikaba hasi na tai naro tame ya, ahababonehe. ");
INSERT INTO jaa_vpl VALUES ("DN7_20","028_7_20","DAN","7","20","20","Afa tamine kamini tabiyo owa, onara oke, warabi awe 10 naro, warabi awe one yanamakeharo. Warabi awe terei na tabori warabi awe oharia ihawarake. Warabi awe one kiti ya kiti fiya tona awineke, awi. Noki naha, fara inohoti ya ati sai, narake hine kahiyaraha ati. ");
INSERT INTO jaa_vpl VALUES ("DN7_21","028_7_21","DAN","7","21","21","Yama owakatoma afa yama warabi awe yama mowa ni yana tonaharake, Teoso ka mera mowa naro. Mera kasawari yana tona ");
INSERT INTO jaa_vpl VALUES ("DN7_22","028_7_22","DAN","7","22","22","hahi fara yama tohateha ya tohehi kobo namareka. Mera kasomareka, Teoso kiti mati tohehi ka mati. Me amo ni kobo namone Teoso ati nareka me nafi yosi me yana tonahabone me amo ni\". ");
INSERT INTO jaa_vpl VALUES ("DN7_23","028_7_23","DAN","7","23","23","\"Me ka owa ati e tasareka ahi, yama kaminatasahari: 'Haha yama yotoha towisawa me amake. Me yosi ka yama hihiya naboneke. Me nafi me mowa ni ya me kitaraboneke me ihi. Faya me nafi tabori me ihawahaboneke. Tabora nafi ka yama nafi me nahabiaboneke. Me ka yama watamaraboneke. ");
INSERT INTO jaa_vpl VALUES ("DN7_24","028_7_24","DAN","7","24","24","Haha yama warabi awe 10 tokaha towisawa me 10 na metebone mera kaminineke, afa me ka towisawa mati. Afa me 10 na me nowati ya towisawa owa natehibonaka, haha towisawa me tai toha me ihi ya ehene toharari. Towisawa me terei na me kitateraboneke ehene. ");
INSERT INTO jaa_vpl VALUES ("DN7_25","028_7_25","DAN","7","25","25","Teoso kitehi hiyaremona ati tebonaka. Teoso ka mera hiri kitebonaka yama hiyara ya. Teoso ati ka yama hani ati hinihawahabone hitehaboneke. Teoso ka me ka marina amo ni tonihawahebona ati, tebonaka. Teoso ka mera yosetehibonaka ano terei na one kote tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("DN7_26","028_7_26","DAN","7","26","26","Afa yama nowati ya ehene amosi tabiyo sowisi siba hine ehene hiyaremona hitehibonaka. Yama e na ihi mera yosemarebonaka. Kiti fawa tehibonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("DN7_27","028_7_27","DAN","7","27","27","Manakobisa Teoso ati ehene Teoso kitehi ka me me yosetehaboneke waha. Ati ehene me kitatehaboneke. Ati ehene me me hikahiyara hitehaboneke. Tabora nafi ka me me yosetehaboneke, me yosi me fawa ra mati. Bara me hinarifatehibonaka. Ati bara me hikatabebonaka'\". ");
INSERT INTO jaa_vpl VALUES ("DN7_28","028_7_28","DAN","7","28","28","\"Yama kamini yowineke haro. Tanieo oha oko kokoriri ni fara tohasa nara oke owati boti ya, onoko baki toba tonaha owa. Yama kamini onofarihi onara oke\". ");
INSERT INTO jaa_vpl VALUES ("DN8_1","028_8_1","DAN","8","1","1","Beosasa towisawa tohe ka ano famaha nowati ka ano ya yama one Teoso hinamotasa owahamaro oke. ");
INSERT INTO jaa_vpl VALUES ("DN8_2","028_8_2","DAN","8","2","2","Orai ka faha witi ya osawihemete owa awine oke, sitati Sosaha ya, Erao ka sitati. Sosaha ka yama bari kani nate amake. ");
INSERT INTO jaa_vpl VALUES ("DN8_3","028_8_3","DAN","8","3","3","Faya kanero warabo ewene yabokime owibote onahamaro oke faha kaya ni yabori ya. Warabo ewene yani yotohino yabo mati tohemarika. ");
INSERT INTO jaa_vpl VALUES ("DN8_4","028_8_4","DAN","8","4","4","Kanero warabo ewene ya yama saka nemarika, bahi totoka toha, bahi kakamaki beheri toha, bahi totoka beheri toha na ya. Bani me toha, e toha na mera katomemarika. He me kasawarihaba me watarihi, me hasi naba me watarihi namaroke. Fara yama hinofa hiri nemarika kiti nafimisahari mata ya. ");
INSERT INTO jaa_vpl VALUES ("DN8_5","028_8_5","DAN","8","5","5","Afa yama wati owaha kabirito owahamaro oke kana ni kakehari bahi totoka ya. Kana ni kite ka ye ataro kawaremarika bofe ya. Warabo ewene oharimarika, yaboharo, noko basakani ya wanaharo. ");
INSERT INTO jaa_vpl VALUES ("DN8_6","028_8_6","DAN","8","6","6","Kana ni tokomakemarika kanero wai ka yama ya, aya owibahari faha kaya ni yabori ya, warabo ewene famahari, he fito kanebanoho kita ya tokahari. ");
INSERT INTO jaa_vpl VALUES ("DN8_7","028_8_7","DAN","8","7","7","Kabirito owehi hami kitehimarika, kanero fito kanahari, he warabo ewene famehi baka kasahari. Kanero kitiba wataremarika he kasawarihibana. Kabirito kanero nasohimarika bofe ya. Kanero tai nareka. Me wataramaroke kanero me kasomaba mati, kabirito hami ehene. ");
INSERT INTO jaa_vpl VALUES ("DN8_8","028_8_8","DAN","8","8","8","Kiti nafimisemarika. Kiti nafi ya warabo ewene me baka hise taboro ya warabo ewene owa kowato ne yanamakemarika, yaboharo. Hahi warabo ewene kowato ne bahi kakamaki ka ya yana, bahi totoka ka ya one yana, bahi kakamaki beheri ka ya one yana, bahi totoka beheri ka ya one yana namaroke. ");
INSERT INTO jaa_vpl VALUES ("DN8_9","028_8_9","DAN","8","9","9","Efe warabo ewene kowato ne owa ya warabo ewene nafire yanamakemarika. Bahi totoka beheri ya kiti nafimisa, bahi kakamaki ya kiti nafimisa, wami taminabote Ihayeo tohaha ya kiti nafimisa nemarika, warabo ewene. ");
INSERT INTO jaa_vpl VALUES ("DN8_10","028_8_10","DAN","8","10","10","Warabo ewene yani kitehi kobo nemarika amowa me tabori ya, amowa neme ka saotato mati. Amowa me one were nisemarika bofe ya, me tai hinahabani mati. ");
INSERT INTO jaa_vpl VALUES ("DN8_11","028_8_11","DAN","8","11","11","Warabo ewene amowa me ka hiti mowa nebona ati nemarika. Ehene bani me me ta namaramaroke fara yama wehe ya amowa me ka hiti ni ya. Amowa me ka hiti ka teboro katomemarika. ");
INSERT INTO jaa_vpl VALUES ("DN8_12","028_8_12","DAN","8","12","12","Neme ka saotato me ihi hiyari ka Teoso bani me ta ni fawa nimarika fara yama wehe ya bani me me ta namarabone mati. Faya warabo ewene ati ehene yama irabori me ta nawahamaroke. Teoso yokana ati nofi fawa nimarika. Kiti nafimisemarika, he me kasawarihaba me watari karo. ");
INSERT INTO jaa_vpl VALUES ("DN8_13","028_8_13","DAN","8","13","13","Manakobisa Teoso nanarifa me famaha me abe hiyara me ati omitamaro oke. Owa aate ne ati e nemarika ahi: \"Yama Teoso hinamoa himata yama tohi ya fawa naba amari? Himata yama tohi ya yama irabori ta ni fawa naba amari, me ta hinaharo bani me tabori ya? Himata yama tohi ya teboro katomi fawa neba amara? Himata yama tohi ya neme ka saotato me kiti yana namahaba me amari?\" ");
INSERT INTO jaa_vpl VALUES ("DN8_14","028_8_14","DAN","8","14","14","Owa yama kaminemarika owa ni ya, ati e nari ahi: \"Haha yama nafi hinamoa kakehaboneke, yama wehe 2300 tohaha ya. Afa yama ya bani me me ta namaraboneke. Afa yama amo ni ahabi ya teboro me namosamaboneke, amosamebonaha, Teoso hihiyara taborobonaha\". ");
INSERT INTO jaa_vpl VALUES ("DN8_15","028_8_15","DAN","8","15","15","Yama owaha wato tabiyo owaha owa ni ya yama kakehamaroke e awi ya awi tohaharo. ");
INSERT INTO jaa_vpl VALUES ("DN8_16","028_8_16","DAN","8","16","16","E ati omitamaro oke ati kakeharo faha Orai tohaha ya. Ha ni e nemarika ahi: \"Kabirieo yama Teoso hinamoa tikaminahi hahi ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN8_17","028_8_17","DAN","8","17","17","Kabirieo kakehimarika hari ya owa ni ya. Kake ehene ero onamaro oke. Owisi yobati ya owitarisa onoko towarisahamaro oke bofe ya. Faya ati yana nemarika. \"Ha tiwa e tihaha yama Teoso hinamoa tiwatoabone tike. Yama yowatibone ka yama yama kaminineke\". ");
INSERT INTO jaa_vpl VALUES ("DN8_18","028_8_18","DAN","8","18","18","Ati saisa ne ohabakosa osahamaro oke. Ohomamaro oke boko oniha owa. Omano wara tone owa nawamisamemarika. ");
INSERT INTO jaa_vpl VALUES ("DN8_19","028_8_19","DAN","8","19","19","Ati yana nemarika. \"Yama okomina okibone yama natehabonehe, Teoso hami nowati ya. Yama Teoso hinamoa yama kaminineke, yama nafi yowibone ka yama. Afa yama wehe Teoso ati ehene amaka. ");
INSERT INTO jaa_vpl VALUES ("DN8_20","028_8_20","DAN","8","20","20","Aya kanero tiwehi warabo ewene famehi towisawa metebone mera kaminaka, Metia ka towisawatebona toha, Besia ka towisawatebona toha nari. ");
INSERT INTO jaa_vpl VALUES ("DN8_21","028_8_21","DAN","8","21","21","Kabirito Keresia ka towisawatebona kaminaka. Warabo ewene yabohi Keresia ka towisawa taititebona kaminaka. ");
INSERT INTO jaa_vpl VALUES ("DN8_22","028_8_22","DAN","8","22","22","Warabo ewene taiti ahabe warabo ewene kowato ne yanamake Keresia ka towisawa metebone mera kaminaka. Towisawa ohari tai tohe ka yama towisawa me yotomakeha me ebe naboneke, me kowato na mati. Towisawa me kowato na me kitaraboneke hahi tai tohe nima me ra mati\". ");
INSERT INTO jaa_vpl VALUES ("DN8_23","028_8_23","DAN","8","23","23","\"Afa towisawa me amo nibone tofiyo ya me ka yama hiyara nafimisi ya towisawa owa kakehibonaka, hamahari, era kekeyeha toha nari. ");
INSERT INTO jaa_vpl VALUES ("DN8_24","028_8_24","DAN","8","24","24","Kiti nafimisebonaka, kiti amare hiri nari, yama nanahabi tohahari, me kitaha mera nahabi, Teoso ka mera nahabi nari, fara hinofa hiri nari. Kiti nafimisebonaka, he me kasawarihaba me watari karo. ");
INSERT INTO jaa_vpl VALUES ("DN8_25","028_8_25","DAN","8","25","25","Me nafi keyehe ka kiti nafimisebonaka. Hiwa kahiyarebonaka fare. Amosemona me hinehi mera waka nebonaka. Teoso mowa nebona ati nebonaka waha, hari Teoso towisawa me nafi ka towisawa tohahari. Ahabebonaka e amara ehene\". ");
INSERT INTO jaa_vpl VALUES ("DN8_26","028_8_26","DAN","8","26","26","Kabirieo ati yowe ka yama e namaroke ahi: \"Yama yokana kamini timitara tike, Teoso ni ya bani me me ta hina me tamine, bai weo tone ya, yama wamini toha na ya. Yama okomina tikaminarabone tike, Teoso yama hinamoa okomina owa. Ano tamaha ahaba nowati ya yama kaketeboneke. Makoni yama tikaminarabone tike\". ");
INSERT INTO jaa_vpl VALUES ("DN8_27","028_8_27","DAN","8","27","27","Tanieo oha oko amo ni tamahamaro oke, kiya ona owa, okitara owa. Manakobisa okitama kofeno ka yama ahi ni yana onamamaro oke. Yama owaha wati nawahi fawa oramaro oke, kokoriri ona owa, yama owatori karo. ");
INSERT INTO jaa_vpl VALUES ("DN9_1","028_9_1","DAN","9","1","1","Tario Sesi biti tohe Metia ka tohe Babironia ka me ka towisawa tohawemarika. ");
INSERT INTO jaa_vpl VALUES ("DN9_2","028_9_2","DAN","9","2","2","Towisawa tohe ka ano taiti ya yama we one ya Teoso ka yama hani ati oyabamaro ama oke. Tanieo oha yama wati owahamaro ama oke, Teoso ati kakamina Seremia tohe ati ka yama hani owaha owa. Seremia ati e nematamonaka ahi, Teoso ati kaminari: \"70 ano tohi ya Serosarei ka yama katomi so kanikimatehaba amake\", Seremia ka yama hani ati ke. ");
INSERT INTO jaa_vpl VALUES ("DN9_3","028_9_3","DAN","9","3","3","Oyawa owitamaro ama oke yama homokori mese ya, makari kitaha okaha owa, owa onafimiha owa. Teoso ha onamaro ama oke kita ya, yama aate ona owa he ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN9_4","028_9_4","DAN","9","4","4","Oko Teoso Yeofa tohe ha ona owati e namaro ama oke ahi, ota ehene hiyara okomina owa: \"Oko Hiti Teoso nafihi tihate ama tike, tikita tiwa. Kotarato hiri tina fara tiwati nima tiwehene te ama tike. Tiwa me nofa tiwati me tokataba me ni ya tiwehene amosa tinamote ama tike. Afa me tinofi ka yama tinamo, tite ama tike me ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN9_5","028_9_5","DAN","9","5","5","Ota ehene ta hiyatera ota amake, tiwati ota tokatabara ota. Yama hiyara ota hiri na tiwati tokatabi ota nofatera ota amake. Ota tosawarite ota amake, yama hani ka tiwati ota nofara ota. ");
INSERT INTO jaa_vpl VALUES ("DN9_6","028_9_6","DAN","9","6","6","Tiwati kakamina tiwa nanarifa me tohaha me ati miti ota nofatera ota amake, tiwati me kamina mati, ota ka towisawa me ni ya, ota ka hiti me toha, ota ka iti me toha, ota nafi toha, na ota ni ya, Ihayeo me ota. ");
INSERT INTO jaa_vpl VALUES ("DN9_7","028_9_7","DAN","9","7","7","Ota ka Hiti tiwehene hiyaraba watatera ama tike. Ota kokoma ke, ha ota, tika me ota, ota winamaro ota Soteya ya, Serosarei toha, Ihayeo ka yama nafi toha, na ya, tiwehene ota winakanikima na ota, ayata ka tabora toha, yama yabo ka tabora toha, na ya. Tiwehene e nemete ama tike, tiwa ota nofari karo. ");
INSERT INTO jaa_vpl VALUES ("DN9_8","028_9_8","DAN","9","8","8","Ota ka Hiti, ota ehene hiyatera ota amake, ota ka towisawa me toha, ota ka hiti me toha, ota ka iti me toha, na ota, ota nafi. Makoni ota kokoma ke. ");
INSERT INTO jaa_vpl VALUES ("DN9_9","028_9_9","DAN","9","9","9","Tiwati tokatabi ota nofakerene tiyahate ama tike ota ni ya. Tiwati somawamate ama tike. ");
INSERT INTO jaa_vpl VALUES ("DN9_10","028_9_10","DAN","9","10","10","Ota ka Hiti Teoso otara tiyoseha tiwati ota totokataba toharamaro ota amake. Tiwati kakamina tiwa nanarifa me tohaha ota ni ya tiwati me kamina tiwati nima ota ehene ramaro ota amake. ");
INSERT INTO jaa_vpl VALUES ("DN9_11","028_9_11","DAN","9","11","11","Ota tosawarite ota amake, ota nafi, Ihayeo me ota. Tiwati miti ota nofatera ota amake. Ota ehene hiyatera ota amake. Makoni tiwehene yama hiyara kakehamaroke ota ni ya. Mowisei tiwa nanarifa tohehi afa yama hiyarateba kaminematamonaka hinaka yama hani ya. Mowisei tiwati kaminematamonaka, otara tikahabanatehabone tinahamone tiwa. ");
INSERT INTO jaa_vpl VALUES ("DN9_12","028_9_12","DAN","9","12","12","Ota ka hiti me ya ota taba otara tikahabanabone tinehemete fara tiwati nimetema tiwehene namaro ama tike. Otara tikatomamaro ama tike. Serosarei ka yama awi hiyara nafihamaroke tiwehene. Yama hiyara Serosarei ka me hikarima nafihamaroke mata ya. Tabora one ka yama hiyara e naba watatera amake Serosarei ka yama hiyara nima nabana. ");
INSERT INTO jaa_vpl VALUES ("DN9_13","028_9_13","DAN","9","13","13","Afa yama hiyarateba Mowisei kaminematamonaka hinaka yama hani ya. Afa yama hiyara ota awakene yama tinofa yokana hiri ni ota nofakere. Ota ka Hiti Teoso yama tikamina yokana hiri ni ota nofakere. Tiwati miti ota nofarihi ke. ");
INSERT INTO jaa_vpl VALUES ("DN9_14","028_9_14","DAN","9","14","14","Makoni afa yama hiyara tiyosehamaro ama tike ota ni ya. Ota ka Teoso Yeofa ama tike. Tiwehene hiyaraba watatera ama tike ha tiwa, otara tiyoseha tiwati miti ota nofara ota. ");
INSERT INTO jaa_vpl VALUES ("DN9_15","028_9_15","DAN","9","15","15","Ota ka Hiti Teoso tika kiti tinamoemete ama tike, tika me titimake tiwa Esito ya. Tikitamone me nafi ati nasa ke, afa tiwehene me wati nawaha mati. Ota ehene ta hiyakere ha ota, yama hiyara ota hiri na ota\". ");
INSERT INTO jaa_vpl VALUES ("DN9_16","028_9_16","DAN","9","16","16","\"Ota ka Hiti otara kakasoma tihehemete ama tike. Makoni Serosarei tikakomarabone tike. Tika sitati amake, Serosarei tohaharo, tika atami. Yama yabori ka me winaha Serosarei me haha kineke, otara me haha kana mati, tika me ota toha ota, ota ehene hiyara me wati nawaha mati, ota ka iti me ihi hiyara toha na ota. ");
INSERT INTO jaa_vpl VALUES ("DN9_17","028_9_17","DAN","9","17","17","Ota ka Teoso owati timitahi, tiwa ha ona owati. Tiwa aate ona owati nima tinahi, tiwa nanarifa oha owa. Ota ka Hiti tika teboro tekanakose hiri tinamabone tike, me nafi tiwa watobone karo, Teoso tiha tiwa. ");
INSERT INTO jaa_vpl VALUES ("DN9_18","028_9_18","DAN","9","18","18","Oko Teoso owati timitahi. Owati tikatabahi, tiwa ha ona owa. Tinoko awahi. Tika sitati tiwahi, tekanakosaharo. Ota amosi ehene amara tiwa ota aate nineke. Otara aawawa tini ka tiwa ota aate nineke. ");
INSERT INTO jaa_vpl VALUES ("DN9_19","028_9_19","DAN","9","19","19","Ota ka Hiti ota ati timitahi. Tiwati somawamahi ota ni ya. Otara tiwahi. Otara tinarifahi. Oko Teoso otara kasomi kerewe tirabone tike, me nafi tiwa watobone karo, Teoso tiha tiwa. Tika me ota amake. Serosarei tika sitati amake\". ");
INSERT INTO jaa_vpl VALUES ("DN9_20","028_9_20","DAN","9","20","20","Teoso ha osa onamaro ama oke, owehene hiyara okomina owa, ota one me ihi hiyara okomina ona owa, Teoso aate ona owa, hinaka atami Serosarei tohaha kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN9_21","028_9_21","DAN","9","21","21","Teoso ha osa oni ya Kabirieo kakehimarika neme ya, kaki kitahari, warehibanoho obeheri ya, efe Kabirieo owahari wata ya. Bai weo tonemarika, bani me me tata ka bahi nima nari. ");
INSERT INTO jaa_vpl VALUES ("DN9_22","028_9_22","DAN","9","22","22","Kabirieo ati yana nemarika. \"Tanieo okehara oke yama okominabone owa, tiwaharo, Teoso hinamoaro. ");
INSERT INTO jaa_vpl VALUES ("DN9_23","028_9_23","DAN","9","23","23","Hiba Teoso haha tina Teoso tiwati mite ati amosareka. Teoso tiwa nofi nafi ka owa yosehareka, yama tiwaha okominabone owa, Teoso hinamoaro tiwa ni ya. Tinarabo hawihi, owati tiwatoabone tiwa. ");
INSERT INTO jaa_vpl VALUES ("DN9_24","028_9_24","DAN","9","24","24","Tanieo Teoso ka sitati ka yama nawaha ahababoneke ano 490 tohi ya. Afa ano tohi ya Teoso me nofara Teoso kako me fawa, naboneke, yama hiyara hiri ni me fawa na mati. Afa yama ya Teoso ati somawamebonaka te one me ni ya. Yama hiyara nafi Teoso fawa nihibonaka, yama nafi amosabonehe. Yama e naboneke yama tiwaha nima, Teoso hikaminaharo. Teoso ka teboro hiri nami hawa tohebonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("DN9_25","028_9_25","DAN","9","25","25","Tanieo tiwarabo hawi ya yama tiwatoabone tike. Teoso ati ehene Serosarei me hiri namaboneke. Mera yosi yana tone ya ano 49 tohaha yana tonahaboneke. Ano 49 tohaha ahabi ya Teoso ka towisawa kobo nebonaka, Teoso hiwasiari. Serosarei ka howa yati toha, yama bari kani yati toha, na ka ano 434 tohatehaboneke, ahabaraharo. Afa yama ka yama nawaha nafihaboneke. ");
INSERT INTO jaa_vpl VALUES ("DN9_26","028_9_26","DAN","9","26","26","Ano 434 tohaha ahabi ya Teoso ka towisawa ahabebonaka fahi, me hinabowahari, he kasomeba watarari. Manakobisa towisawa owa kobo nebonaka, hinaka saotato me ya tabahari. Serosarei me nahabihaboneke, teboro toha nari. Serosarei ahabi e naboneke fa fowe kimisi nima, kimisi kitaharo. Yama mowa ni tama, yama ahabi tama, naboneke Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN9_27","028_9_27","DAN","9","27","27","Hahi towisawa kotarato hiri nebonaka, tabora nafi ka me ya tabahari. Haha kotarato ka ano 7 naboneke. Ano 3 na kote tohi ya kotarato ka yama enoki ya teboro ka yama ta ni fawa nibonaka, bani me sari kanamaribone karo, yamata me ta namarihi nibone karo teboro ya. Teboro tati ya yama habosia me nawariaboneke. Ware wari ahababoneke, towisawa me nabowi ya, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN10_1","028_10_1","DAN","10","1","1","Siro Besia ka towisawa tohehimarika. Towisawa tohi ka ano famaha nowati ka ano ya Tanieo oha Beotesasa oha ona owa ni ya Teoso ati yana nemarika. Teoso ati omite ati fiya tonakara. Ati nihinabisaremarika owa ni ya. Manakobisa yama we one ya yama owatowahamahamaro ama oke, yama Teoso hinamoa owaharo. ");
INSERT INTO jaa_vpl VALUES ("DN10_2","028_10_2","DAN","10","2","2","Teoso ati omiti ka oyawamaro ama oke. Oyawi ka semana 3 namaroke. ");
INSERT INTO jaa_vpl VALUES ("DN10_3","028_10_3","DAN","10","3","3","Haha yama ya yamata kabi amosa okobaramaro oke. Bani okobarihi onahamaro oke. Fi ofarihi, otati kone siri orihi, onahamaro oke. ");
INSERT INTO jaa_vpl VALUES ("DN10_4","028_10_4","DAN","10","4","4","Abariko taiti ka yia 24 ya owabasahamaro oke faha ehebote Tikiri tohaha witi ya. ");
INSERT INTO jaa_vpl VALUES ("DN10_5","028_10_5","DAN","10","5","5","Teoso nanarifa owibote onahamaro oke makari riyo tohaha weye nari, tosi atori oro amosabote toahari. ");
INSERT INTO jaa_vpl VALUES ("DN10_6","028_10_6","DAN","10","6","6","Yati oya kana nima mese nemarika, oya kanahari. Bahi yebe kani nima noko bako nemarika. Noko e nemarika, yama hiri ni isi wataha nima. Mano toha, iso toha ne oya kani e nemarika, borosi oya kani nima. Ati yana ne me tamaha me ati nima ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("DN10_7","028_10_7","DAN","10","7","7","Me ya otaba yama owahamaro oke owaharia owa. Owa ya me taba yama me awara me kakomehamaroke. Me kana ni tokomamaroke, me wahiyabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN10_8","028_10_8","DAN","10","8","8","Owaharikosamaro oke, yama nafiha owaha owa, Teoso hinamoaro. Toba onahamaro oke, owakomeha owa. Oko kiti fawa namaro oke. ");
INSERT INTO jaa_vpl VALUES ("DN10_9","028_10_9","DAN","10","9","9","Teoso nanarifa ati omita ohabakosa osahamaro oke onokosi ya. ");
INSERT INTO jaa_vpl VALUES ("DN10_10","028_10_10","DAN","10","10","10","Mano ya owa itimisame owahamaro oke owisi yobati ya, omano kawaha owa. ");
INSERT INTO jaa_vpl VALUES ("DN10_11","028_10_11","DAN","10","11","11","Teoso nanarifa ati yana nemarika. \"Tanieo Teoso tiwa nofi nafi ka owa yosehareka tiwa ohiyarabone owa. Tiwahi tiwisi ya, owati timitibeya\", ati nemarika. Owahamaro oke, hoyahoya kana ona owa oko nafi. ");
INSERT INTO jaa_vpl VALUES ("DN10_12","028_10_12","DAN","10","12","12","Ati yana namatasemarika. \"Tanieo watorima tinahi. Teoso ha ni yana timaro ka tiwati nafi Teoso mitate amaka, titaminaramone tina tiwa Teoso nokosi ya, tika yama watobone Teoso ta nebona tina tiwa. Okehara oke, Teoso tiwati mite ehene. ");
INSERT INTO jaa_vpl VALUES ("DN10_13","028_10_13","DAN","10","13","13","Hinamati Besia ka mera nanarifa tohe owa mono nareka, semana terei na ya. Owaharihara oke mata, Besia ka towisawa owa me mono na owa. Faya Mikeo Teoso nanarifa me ka hiti owa tohe kakehareka owa kasomebanoho. ");
INSERT INTO jaa_vpl VALUES ("DN10_14","028_10_14","DAN","10","14","14","Faya okehara oke yama okominabone owa tiwa ni ya, yama natehabonehe te one me ni ya. Haha yama tiwaha Teoso hinamoa yama natehaba kaminineke\". ");
INSERT INTO jaa_vpl VALUES ("DN10_15","028_10_15","DAN","10","15","15","Owa hiyare owati watara onokorisamaro oke bofe ya. ");
INSERT INTO jaa_vpl VALUES ("DN10_16","028_10_16","DAN","10","16","16","Teoso nanarifa e nima ne obono boyo nemarika fahi. Faya owati yana namaro oke Teoso nanarifa ohiyara owa, wahari onokosi ya. \"Oko hiti haha yama owaha ihi kori okasara oke, oko kiti fawa na owa. ");
INSERT INTO jaa_vpl VALUES ("DN10_17","028_10_17","DAN","10","17","17","Himata nima owati ribe, tiwa ni ya, onafira owa, tinafiha tiwa. Oko kiti fawa nara oke. Oko hasi ni fawa nima nara oke\". ");
INSERT INTO jaa_vpl VALUES ("DN10_18","028_10_18","DAN","10","18","18","Faya owa boyo namatasemarika. Oko kiti kamahamaro oke fahi. ");
INSERT INTO jaa_vpl VALUES ("DN10_19","028_10_19","DAN","10","19","19","Ati yana namemarika. \"Teoso tiwa nofaka. Makoni tiwatorabone tike. Teoso tiwa kakatomehibonaka. Tikitahi. Tibo bayihi\". Oko kiti nafimisa owati yana namaro oke fahi. \"Tiwati saihi. Tiwehene oko kiti nafike waha\". ");
INSERT INTO jaa_vpl VALUES ("DN10_20","028_10_20","DAN","10","20","21","Ati yana namatasemarika. \"Yama tiwatoni haro oki karo, tiwa ohiyarabone owa? Okehara oke, yama hani ati okominabone owa tiwa ni ya, Teoso ka yama hani ati, ati fiya tonahaba watararo. Hiba, hinamati Besia ka mera nanarifa tohe mono onahabone oke mata. Afa yama mowa ni hawa tohi ya inamati owa Keresia ka mera nanarifa tohe tohamakebonaka. Me mowa ona owa kasomeba watakara. Mikeo ta oharika, owa kasomari, Ihayeo mera nanarifa tohahari\". ");
INSERT INTO jaa_vpl VALUES ("DN11_1","028_11_1","DAN","11","1","1","Onarifa, okasoma onemarika towisawa Tario Metia ka tohe ka ano taiti ya\". ");
INSERT INTO jaa_vpl VALUES ("DN11_2","028_11_2","DAN","11","2","2","Teoso nanarifa ati yana namatasemarika. \"Yama keye tohara okominabone oke mata tiwa ni ya. Tario nowati ya Besia ka towisawa me 3 namakiaboneke. Afa me nowati ya towisawa owa ohari tohamakebonaka, honahari mata ya. Honehi kitehibonaka. Hinaka saotato mera yoro tokaniwamebonaka, me me mowa nabone mati, Keresia ka mati\". ");
INSERT INTO jaa_vpl VALUES ("DN11_3","028_11_3","DAN","11","3","3","\"Efe nowati ya towisawa owa kakehibonaka hamahari kasiro ya. Tabora nafi ka towisawa tohebonaka. Fara yama hinofa hiri nebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN11_4","028_11_4","DAN","11","4","4","Hiba kiti nanafimisa ne ya manakobisa hinaka yama me hinahabihaboneke nafi. Faya hinaka tabora me ebe naboneke, towisawa me 4 na mati. Efe towisawa hinaka noti me amaraboneke. Kiti nima me kiti raboneke. ");
INSERT INTO jaa_vpl VALUES ("DN11_5","028_11_5","DAN","11","5","5","Afa me 4 na me ka owa Esito ka towisawa tohe kiti nafimise kiti fawa nebonaka hinaka saotato me ka hiti owa ehene, kiti nafihari mata ya\". ");
INSERT INTO jaa_vpl VALUES ("DN11_6","028_11_6","DAN","11","6","6","\"Afa me 4 na me ka owa Siria ka towisawa tohehibonaka. Fa fowe tamara nowati ya Esito ka towisawa ya Siria ka towisawa me famaha kotarato me hiri naboneke. Kotarato me hiri ni ya Esito ka towisawa bite kahabanebonaka, Siria ka towisawa hitihabonehe, me abe mowa ribone karo. Yama me kasawariaboneke. Me one me waka hinahaboneke, towisawa bite toha, maki toha, biti toha, me nanarifa me toha na mati\". ");
INSERT INTO jaa_vpl VALUES ("DN11_7","028_11_7","DAN","11","7","7","\"Faha fowe one ya towisawa bite me ka owa towisawa tohawebonaka. Hinaka saotato me ya tabe tokehibonaka Siria ka mera mowa nebonaha. Yama bari kani ya tokiyomebonaka, mera nahabibanoho. ");
INSERT INTO jaa_vpl VALUES ("DN11_8","028_11_8","DAN","11","8","8","Siria ka me ka teoso me kanamori towakamebonaka Esito ya. Yama one towakama nebonaka, oro hiri ni toha, barata hiri ni toha naro, manakone fotaharo. Faya Esito ka towisawa Siria ka towisawa wati kani fawa nebonaka faha fowe tatama ni ya\". ");
INSERT INTO jaa_vpl VALUES ("DN11_9","028_11_9","DAN","11","9","9","\"Faha fowe tatama na ahaba nowati ya Siria ka towisawa tokehibonaka, Esito ka mera mowa nebonaha. Yama me hikasawaria me wete tonamaboneke Siria ya. ");
INSERT INTO jaa_vpl VALUES ("DN11_10","028_11_10","DAN","11","10","10","Siria ka towisawa biti hine me yoro tokanihaboneke, me me mowa nabone mati. Saotato me tamaha me me yoro tokani naboneke. Me tokahaboneke Esito ka me me mowa nabone mati. Yama nafi me fawa nihaboneke. Fa fowe yama nafi fawa niha nima me naboneke. Me tokomakehaboneke Esito ya, Esito ka towisawa ka yama bari kani me nahabiabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN11_11","028_11_11","DAN","11","11","11","Esito ka towisawa hamamisehibonaka fahi. Hinaka saotato me ya tabe me tasi tonahaboneke, Siria ka saotato me me fito kanabone mati. Siria ka me tamakene me kitaraboneke Esito ka me ihi. ");
INSERT INTO jaa_vpl VALUES ("DN11_12","028_11_12","DAN","11","12","12","Esito ka towisawa mera kasawari hiwa kahiyarebonaka, me tamaha mera nahabihari. Kitehi kiti yaborebonaka\". ");
INSERT INTO jaa_vpl VALUES ("DN11_13","028_11_13","DAN","11","13","13","\"Manakobisa ano tamara ya Siria ka towisawa saotato mera yoro tokanihibonaka, me tamaha mati mata ya. Tokomatasehibonaka hinaka saotato me ya tabahari, me ye hone tamaha mati, Esito ka me me mowa nabone mati tasa. ");
INSERT INTO jaa_vpl VALUES ("DN11_14","028_11_14","DAN","11","14","14","Esito ka towisawa tabora one ka mera yoyose tohehi me hinofamarebonaka waha, tabora tamaha ka mati. Afa me ni ya Ihayeo me one nahaboneke, era wawaka me toha mati. Yama yama hinamoa me awi ka Esito ka towisawa ati me nofamaraboneke, mera yosemarehibonaha. Faya me kitaraboneke Esito ka towisawa ehene. ");
INSERT INTO jaa_vpl VALUES ("DN11_15","028_11_15","DAN","11","15","15","Siria ka towisawa hinaka saotato me ya tabehi tokomatasebonaka, me me mowa nabone mati, Esito ka mati. Sitati yama bari kani kihaha ya me tokiyomabone me ati na wami me mata naboneke yama bari kani beheri ya, me kariwabone mati. Makoni Esito ka me kitaraboneke me ihi. Esito ka saotato me kitakene me ati raboneke. ");
INSERT INTO jaa_vpl VALUES ("DN11_16","028_11_16","DAN","11","16","16","Siria ka fara yama me hinofa me hiri naboneke. Me me ma hinihaba me wataraboneke. Wami Teoso ta hinahabone hinehemete ya me tokahaboneke, me hihawabonehe. Me hihawahaboneke nafi\". ");
INSERT INTO jaa_vpl VALUES ("DN11_17","028_11_17","DAN","11","17","17","\"Faya Siria ka towisawa hinaka saotato mera hawa tonihebonaka, Esito ka me me mowa nabone mati. Kotarato hiri nebona ati ne bite ta nebonaka Esito ka towisawa hitihabonehe. Ehene Esito ka me kitarabone ati ne yama hikasawaribonaka. ");
INSERT INTO jaa_vpl VALUES ("DN11_18","028_11_18","DAN","11","18","18","Faya Siria ka towisawa sitati tamaha mowa nebonaka, ma witi ka sitati. Tamaha ihawehibonaka. Bara me ka saotato me ka hiti ehene kokoma nebonaka, hiwa kahiyari fawa nari\". ");
INSERT INTO jaa_vpl VALUES ("DN11_19","028_11_19","DAN","11","19","19","\"Siria ka towisawa wete tonamebonaka fara Siria ya. Fara Siria ka sitati yama bari kani kihaha fito kanebonaka. Yama hikasawari ya me hinabowebonaka. Tamine kamini watamarebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN11_20","028_11_20","DAN","11","20","20","Efe taboro ya towisawa owa tohawebonaka. He nanarifa yosehibonaka tabora bara ya, me ka yinero aate nebonaha, hihawebonaha, honehibonaha. Afa yama nowati yokana ya me hinabowebonaka yama mowa ni ihi amararo, nabowi me hiwarari\". ");
INSERT INTO jaa_vpl VALUES ("DN11_21","028_11_21","DAN","11","21","21","\"Siria ka towisawa owa tohawebonaka. Hahi yama hiyara hihiri tohebonaka. Towisawa tohaba ka amosi watare mera keyehebonaka. Ehenebona me hiwatore towisawa tohawebonaka towisawa owa taboro ihawahari. ");
INSERT INTO jaa_vpl VALUES ("DN11_22","028_11_22","DAN","11","22","22","Tabora nafi ka me ka saotato me kitaraboneke ehene. Sasetoti ehebote nabowa nebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN11_23","028_11_23","DAN","11","23","23","Me ya tabe kotarato me hiri na mera keyehebonaka. Hinaka saotato me tamara kiti nafimisebonaka mata ya. ");
INSERT INTO jaa_vpl VALUES ("DN11_24","028_11_24","DAN","11","24","24","Mera bata kanebonaka mera mowa nebonaha, tabora honaha ka mati. Yama habosia kiha hiri nebonaka, me hiri hiteraro. Tabora one ka yama ihawe yama ebe nebonaka hinaka saotato me ni ya, yama manakone fotaharo. Yama totoyabo raba na ya yama wati kanebonaka, sitati yama bari kani kihaha mowa nebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN11_25","028_11_25","DAN","11","25","25","Kitehimona ati, habo bayimona ati, ne hinaka saotato me tamaha me ya tabe me tokahaboneke Esito ka me me mowa nabone mati. Esito ka towisawa hinaka saotato me ya tabehibonaka, me kitaha mati, me tamaha mati. Me me mowa na Esito ka towisawa kitarebonaka, ");
INSERT INTO jaa_vpl VALUES ("DN11_26","028_11_26","DAN","11","26","26","he ya tataba me hikeyehari. Afa me ihi hiwa yokohibonaka. Esito me kitaraboneke Siria ka me ihi. Saotato me tamaha me ahababoneke, Esito ka mati. ");
INSERT INTO jaa_vpl VALUES ("DN11_27","028_11_27","DAN","11","27","27","Faya towisawa me famaha me abe kobo naboneke, me abe hiyarabone mati. Fara me famaha keye me hiri naboneke, me abe kakoani mati. Owa ni ya yama hiyara hiri nebona ati, owa yama hiyara hiri nebona ati, nebonaka he ni ya bisa. Me abe kasawariaboneke mata, yama amo ni kobo ri karo mata\". ");
INSERT INTO jaa_vpl VALUES ("DN11_28","028_11_28","DAN","11","28","28","\"Manakobisa Siria ka towisawa wete tonamebonaka fare taboro ya, yama manakone fotaha towakamahari, hihawaharo yama mowa ni ya. Ihayeo me ka Teoso ha ni nahabihibona ati nebonaka. Fara yama hinofa hiri nebonaka me ni ya. Faya wete tonamebonaka fare taboro ya. ");
INSERT INTO jaa_vpl VALUES ("DN11_29","028_11_29","DAN","11","29","29","Yama amo ni kobo ni ya hinaka saotato me ya tabe me tokomaboneke Esito ka me me mowa nabone mati tasa. Taiti ya me kitibaha me kitamaraboneke haha yama mowa ni ya. ");
INSERT INTO jaa_vpl VALUES ("DN11_30","028_11_30","DAN","11","30","30","Nafio ya saotato me one kakiaboneke bahi totoka ka yama ya, me me fito kanabone mati. Yawahi yama mowa ni nofamarebonaka\". \"Hamamise Ihayeo mera fito kanamebonaka. Fara yama hinofa hiri nebonaka tasa me ni ya. Soteo me one Teoso nofamara me ati mite me ati nima ehene nebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN11_31","028_11_31","DAN","11","31","31","Hinaka saotato me tokiyomaboneke teboro toro ya. Me ka bani me ta ni me fawa nihaboneke, teboro ya bani me me ta na mati Teoso ni ya fara yama wehe nima. Yama habosia me nawariaboneke teboro toro ya, teboro tohiyebonaha. ");
INSERT INTO jaa_vpl VALUES ("DN11_32","028_11_32","DAN","11","32","32","Soteo me one Teoso me nofamara Siria ka towisawa me narifaboneke, me amosamone me hini karo. Teoso me nofaha me ta fara me tohaha me tohasa naboneke. Siria ka towisawa me mono naboneke. ");
INSERT INTO jaa_vpl VALUES ("DN11_33","028_11_33","DAN","11","33","33","Yama wawato soteo me ihibone me kaminaboneke. Ano tamara ya afa yama wawato yama nawaha me hiri naboneke mata, me one ihi. Me one me waka hinaboneke yimawa ya. Me one me waka, naboneke yifo hiri ni ya. Me one me me hiwata me me hekamaboneke bara me tabori ya. Me one me ka yama nafi me hihawahaboneke. ");
INSERT INTO jaa_vpl VALUES ("DN11_34","028_11_34","DAN","11","34","34","Afa yama nawaha me hiri na bara me one me me hikasomaboneke, Teoso ka mati. Me one me me hikasomaboneke, me me hinofi karo. Me one ta me me hinofa me me hikasomaboneke, yama ihi tabiyo. ");
INSERT INTO jaa_vpl VALUES ("DN11_35","028_11_35","DAN","11","35","35","Yama wawato me one me me waka hinaboneke. Afa yama nawaha Teoso ka me hiri ni ya me ihi amosi nafimisahaboneke Teoso ati ehene\". \"Afa yama tohasa ni ka yama ya yama amo ni kobo naboneke fahi, yama nafi ahabi ka yama amo ni, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("DN11_36","028_11_36","DAN","11","36","36","Siria ka towisawa yama hinofa nafi hiri nebonaka. Hiwa kahiyarebonaka, teoso me nafi fiya kanehimona ati nari. Teoso yokana hiyaremona ati nebonaka, yama me hikaminatera itihari. Ehene e ne hiri ne manakobisa yama toyabo ya Teoso hikatomehibonaka fahi. Teoso yama amo nibone wato hawa tohaka, hikatomabona ka amo ni. ");
INSERT INTO jaa_vpl VALUES ("DN11_37","028_11_37","DAN","11","37","37","Hahi towisawa hinakiti ka teoso mera nofarebonaka. Me fanawi ka teoso nofarihi, teoso me one nofarihi nebonaka, teoso me nafi fiya kanehimona ati nari. ");
INSERT INTO jaa_vpl VALUES ("DN11_38","028_11_38","DAN","11","38","38","Teoso ohari ta nofehibonaka, sitati yama bari kani kihaha ka teoso, sitati ka mera bari kanahari. Efe teoso hinakiti me watotera me amake. Efe teoso ni ya yama manakone fotaha ta nebonaka, oro toha, barata toha, yati amosa toha, yama one toha naro. ");
INSERT INTO jaa_vpl VALUES ("DN11_39","028_11_39","DAN","11","39","39","Me one bara me ka teoso me nofaha towisawa me narifaboneke, hinaka sitati yama bari kani kihaha ahabaribone karo, yama mowa ni ihi. Hinaka me hinofe mera kakawebonaka me ka wamibone ya. Mera tonihawaha nebonaka, he nanarifa mebone mati, me one me yosehabone mati\". ");
INSERT INTO jaa_vpl VALUES ("DN11_40","028_11_40","DAN","11","40","40","\"Yama amo ni kobo ni ya Esito ka towisawa Siria ka towisawa fito kanehibonaka. Siria ka towisawa tokehibonaka mera mowa nebonaha, hinaka saotato me tamaha me ya tabahari, me ye hona mati. Me ka kaho sawi, me ka kafaro me sawi, me ka nafio sawi nebonaka yama mowa ni ya. Fa fowe kimisa nima me naboneke me tokiyoma mati Esito ya. ");
INSERT INTO jaa_vpl VALUES ("DN11_41","028_11_41","DAN","11","41","41","Wami Teoso ta hinahabone hinehemetemone ya toka nebonaka. Me tamaha mera nahabihibonaka. Bara me ta me hasi naboneke, Eto toha, Mowabi toha, Amo toha na ka mati. Amo ka me tamara me ahababisaboneke. ");
INSERT INTO jaa_vpl VALUES ("DN11_42","028_11_42","DAN","11","42","42","Me tabori tamaha ihawehibonaka hinaka saotato me ihi, Esito ka me tabori toha naro. ");
INSERT INTO jaa_vpl VALUES ("DN11_43","028_11_43","DAN","11","43","43","Esito ka me ka yama me towakamaboneke, oro toha, barata toha, yama one toha naro, manakone fotaharo. Ribia ka me tabori toha, Etiobia ka me tabori toha na me ihawahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("DN11_44","028_11_44","DAN","11","44","44","\"Manakobisa hiyara kakehaboneke, bara me tabori ka hiyara, me winaha mati bahi kakamaki ya, bahi kakamaki beheri ka me toha na mati. Afa hiyara ihi Siria ka towisawa kakomebonaka. Hamamise yana tonehibonaka me tamaha mera nahabibona ati nari, hinaka saotato me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("DN11_45","028_11_45","DAN","11","45","45","Saotato mera yoro tokaniwamebonaka, me hawa tohabone mati, me one me me mowa nabone mati. Yama me karawatoha me nahohaboneke baikani ya, ma toha Serosarei toha na baikani ya. Faya ahabebonaka fahi, he me kasomaba me watari karo\". ");
INSERT INTO jaa_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Faya Teoso nanarifa ati yana namatasemarika. \"Afa yama tohi ya Mikeo kakehibonaka, Teoso ka mera babari kana tohahari. Yama nawaha nafiha nahaboneke afa yama ya. E ka yama nawaha e naba watatera amake. Afa yama ya Teoso mera kasomebonaka, hinaka mati, me ini naha mati Teoso ka yama hani ya. ");
INSERT INTO jaa_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Me tamaha me ahaba me kitamaboneke. Me one sawi fara tohatehaba me amake Teoso ya me taba mati. Me one ta mera Teoso katomebonaka, me ka yama nawaha fawa terabone mati. ");
INSERT INTO jaa_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Yama wawato me oya kanahaboneke neme ka amowa me oye nima, me me kanawani karo, yama amosa me hiri nabone mati. Me oya kani fawa teraboneke, yama wawato mati\". ");
INSERT INTO jaa_vpl VALUES ("DN12_4","028_12_4","DAN","12","4","4","\"Tanieo ha tiwa yama okomina tikaminarabone tike me ni ya. Yama hani rawi tikana rofi tikawa moya tikanahi, me naha hikarabana. Yama toyabo ya naha kanabanake yama amo ni kobo ni ya. Me yobi naboneke, yama wato tabiyo me awa mati\". ");
INSERT INTO jaa_vpl VALUES ("DN12_5","028_12_5","DAN","12","5","5","Manakobisa Teoso nanarifa me fama me owamaro oke. Faha kowani ya owa wa, faha kowani one ka ya owa wa nemarika. ");
INSERT INTO jaa_vpl VALUES ("DN12_6","028_12_6","DAN","12","6","6","Haha me famaha owa ati yana nemarika, Teoso nanarifa aate nari, wahari tokatimi ya, makari riyo toha akahari. \"Yama amosa amo ni e ni ya nahaba amari?\" ");
INSERT INTO jaa_vpl VALUES ("DN12_7","028_12_7","DAN","12","7","7","Mano yana kane ati yana nemarika, Teoso ino itihari. \"Teoso ka me ka yama nawaha ahabi ya afa yama nahaboneke, ano terei na kote tohi ya. Keye amakere. Teoso owati mitaka\". ");
INSERT INTO jaa_vpl VALUES ("DN12_8","028_12_8","DAN","12","8","8","Yama miti yokana oharamaro oke haro. Makoni aate onemarika. \"Owati timitahi. Afa yama nafi ahabi ya himata nima yama naba amari?\" ");
INSERT INTO jaa_vpl VALUES ("DN12_9","028_12_9","DAN","12","9","9","\"Tanieo tikamabone tike waha. Afa yama nafi me watoraboneke. Yama toyabo ya me hiwatoaboneke, yama nafi ahabi ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("DN12_10","028_12_10","DAN","12","10","10","Teoso me tamaha mera totomi nabona ka yama nawaha me hiri naboneke. Yama nawaha me hiri na me amosi nafimisahaboneke, me kitamisa mati. Yama hiyara hihiri fara me tohasa naboneke, yama hiyara me hiri na mati. Afa yama kaki ya me hiwatoraboneke. Yama wawato me ta me hiwatoaboneke. ");
INSERT INTO jaa_vpl VALUES ("DN12_11","028_12_11","DAN","12","11","11","Me ka bani me ta ni me fawa ni yama habosia me nawari ni ya teboro ya, yama amo ni 1290 tohahaboneke teboro tohiye amo ni. ");
INSERT INTO jaa_vpl VALUES ("DN12_12","028_12_12","DAN","12","12","12","Yama amo ni 1335 tohaha ya Teoso nofi fara me tohasa ni ya, Teoso mera nofebonaka. ");
INSERT INTO jaa_vpl VALUES ("DN12_13","028_12_13","DAN","12","13","13","Tanieo ha tiwa tika kiti fara tohasa nabone tike. Tihababone tike. Yama amo ni kobo ni ya tiwamisamabone tike, yati tinama tiwa, Teoso tiwa kakawebona tiwa yama amosa ya\".");
INSERT INTO jaa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sesowi Kirisito hinakiti memetemoneke haro. Abarao ka noti Tafi tohehi ka notimatamona amaka, Sesowi. ");
INSERT INTO jaa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarao Isaki batimatamona amaka. Isaki Yako batimatamona amaka. Yako Yota me ka abimatamona amaka, nisori me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yota biti Beri toha Sera toha ne me ka ami inimetemone amake Tama. Esiro batimatamona amaka Beri. Arao batimatamona amaka Esiro. ");
INSERT INTO jaa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminatabi batimatamona amaka Arao. Naso batimatamona amaka Aminatabi. Saomo batimatamona amaka Naso. ");
INSERT INTO jaa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Bowasi batimatamona amaka Saomo. Mati ini Haabi toha nemetemoneke. Obeti batimatamona amaka, Bowasi. Mati inimetemone amake Hoti. Sese batimatamona amaka Obeti. ");
INSERT INTO jaa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tafi batimatamona amaka Sese. Saromao batimatamona amaka Tafi. Saromao mati Oria fati tohibehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hobowao batimatamona amaka Saromao. Abiasi batimatamona amaka Hobowao. Asa batimatamona amaka Abiasi. ");
INSERT INTO jaa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sosafa batimatamona amaka Asa. Sorao batimatamona amaka Sosafa. Osiasi batimatamona amaka Sorao. ");
INSERT INTO jaa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yotao batimatamona amaka Osiasi. Akasi batimatamona amaka Yotao. Esekiasi batimatamona amaka Akasi. ");
INSERT INTO jaa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manase batimatamona amaka Esekiasi. Amo batimatamona amaka Manase. Sosia batimatamona amaka Amo. ");
INSERT INTO jaa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sekonia batimatamona amaka Sosia, nisori me ya tabahari. Sekonia me sawi ka yama ya Ihayeo me me towakamehemetemoneke Babironia ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babironia ka me me towakami hawa tohi ya Saratieo batimatamona amaka Sekonia. Sorobabeo batimatamona amaka Saratieo. ");
INSERT INTO jaa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abioti batimatamona amaka Sorobabeo. Eriaki batimatamona amaka Abioti. Aso batimatamona amaka Eriaki. ");
INSERT INTO jaa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Satoki batimatamona amaka Aso. Aki batimatamona amaka Satoki. Erioti batimatamona amaka Aki. ");
INSERT INTO jaa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriaso batimatamona amaka Erioti. Mata batimatamona amaka Eriaso. Yako batimatamona amaka Mata. ");
INSERT INTO jaa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yose batimatamona amaka Yako. Maria Yose fatimetemone amake. Sesowi Maria bitimatamona amaka, ino Kirisito me hinihatehari. ");
INSERT INTO jaa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abarao tohaba nematamonaka, mata ya. Abarao nowati ya Tafi hinakiti me tamehemetemoneke 14 me toha mati. Tafi tohaba nematamonaka. Babironia ya me toka me ka iti me 14 tohemetemoneke, Tafi nowati ya. Babironia ya me toka me tohaba nemetemoneke. Kirisito hinakiti me tamehemetemoneke 14 me toha mati, Babironia ya me toka me nowati ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sesowi Kirisito wate wati e nematamonaka ahi. Sesowi mati Maria tohaha Yose hitihabone hinehemetemoneke. Yose Maria ahi rematamonaka mata. Maria hine watohemetemoneke nabati weye naro, Teoso Kanamori ehene. ");
INSERT INTO jaa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yose yahe ka fatibone kamini nofarematamonaka me one ni ya, nabati weye naro. Hine ya hiyosemahabone hinehemetemoneke, ati watarari. ");
INSERT INTO jaa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yose ati boti yama nima ne amo ne Teoso nanarifa watari awehimatamonaka. Teoso nanarifa ati yana nematamonaka. \"Yose Tafi ka noti watorima tinahi. Maria iti nakomerima tinahi, nabati weye naro Teoso Kanamori ehene. ");
INSERT INTO jaa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Biti watehibonaka. Ino tinawatehibanaka. Sesowi tohehibanaka, hinaka mera kasomatehibana. Sesowi mera kasomatehiba amaka me ihi hiyara mati, me ahabarahabone mati\", Teoso nanarifa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hibati ka Teoso ati kakamina atimatamona nima Sesowi wati nematamonaka. Teoso ati kakamina ati e nematamonaka ahi: ");
INSERT INTO jaa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","\"Fana atona me makiti ahi hiraha nabati weye tehaboneke. Biti watatehibonaka. Ino me hinawatatehiba amaka. Emanoweo tohatehiba amaka. E ati ka amake haro, Teoso e ni ya sawika ati naro\". ");
INSERT INTO jaa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yose watami hiba yama wa ni ya tafihimatamonaka. Fare Teoso nanarifa ati nima Yose ehene nematamonaka, Maria itihari. Me famawemetemoneke Yose taboro ya. ");
INSERT INTO jaa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hitiha ahi hirehemetemoneke mata biti watamatare ya. Wate inobona Yose hinawatehimatamonaka. Sesowi tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sesowi watehimatamonaka Bere ya Soteya ya. Eroti towisawa tohibehimatamonaka. Bara yama wawato me tohaha me kakehemetemoneke Serosarei ya, wami one ka mati, bahi kakamaki ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Me ati yana nemetemoneke. \"Hibaka inamatewe tohara watehimonaha soteo me ka towisawa tohatehibonaha? Maya ota awa otake hinaka maya, kimisari. Ota kakeha otake ota nahorisahabone ota he nokosi ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Towisawa Eroti tohehi me ati mitehi kokoriri nematamonaka. Serosarei ka me nafi kokoriri, nabisemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eroti mera yoro tokaniwamematamonaka, me nafi, sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, na mati, mera aate nebonaha. \"Kirisito watabona ka tabora ini te kaminahi owa ni ya, ini me hikaminehemete hibati ka mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","\"Watatehibona me hinehimatamonaka, Bere ya Soteya ya. Teoso ati kakamina ka yama hani ati e narake ahi: ");
INSERT INTO jaa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Bere Yota ka tabora tihaha Yota ka me ka towisawa taiti me ka owa ama tike. Oko me Ihayeo me tohaha me ka towisawa watehiba amaka tiwa ni ya, Ihayeo mera yosehibana', ati nematamonaka\", me ati nemetemoneke, Teoso ati kakamina ati me kamina mati Eroti ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eroti mera ha nematamonaka bara mati, mera aate nebonaha me hiwatorahari, me one. Maya me awi ka me amo ni watohibona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mera yosehimatamonaka Bere ya. \"Te tokomakehi. Me te aate nibeya, inamatewe me kaminaba mati. Inamatewe te wasi ya te kaminebanaka owa ni ya. Okomakehabana oke. Owabisehibanaka, owitarisaba owa bisa he nokosi ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Towisawa ati me mitaha me tokomakehemetemoneke. Hibati ya fare maya me tabori ya me hiwehi me hiwatasehimatamonaka. Maya tai toehimatamonaka me nokosi ya. Ma towitimatamonaka fare inamatewe sawi ka tabora neme ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Maya me awaha me yayai nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Me kobo towitia me tokiyomemetemoneke yobe toro ya. Inamatewe me awehemetemoneke mati ya famahari Maria. He nokosi ya me nahorisa me nahohemetemoneke, me mowi kanisa mati inamatewe nokosi ya. Me ka sakora noki me se na hinaka yamabone me hiyaba me ta hinehemetemoneke. Oro me ta, miha atahone toha, wami one toha, nemetemoneke, me ta hinaharo, manakone fotaharo. ");
INSERT INTO jaa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Me amo na Teoso ati watari me awehemetemoneke Eroti ni ya me tokomarahabone ati nari. Faya me tokomemetemoneke hawi one ka ya, me tabori ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Me tokoma me nowati ya Yose Teoso nanarifa awehimatamonaka wata ya. \"Yana tinahi. Tokomakabote tinahi. Inamatewe toha, mati toha, na te tokomahi Esito ya, te hasi nabone te. Te sawi ya tera ohiyarahaba owa awine oke tasa. Eroti inamatewe siba nebona ati nareka hinabowehibonaha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Faya yama soki enoki ya yana tone inamatewe toha mati toha na me tokehemetemoneke Esito ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Me sasawi tohehemetemoneke Esito ya. Manakobisa Eroti ahabe ya me yana tonehemetemoneke. Fare Teoso ati kakamina atimatamona nima me ihi nemetemoneke. Ati e nematamonaka ahi: \"Okatao ha onahara oke yana tonehibonaha Esito ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eroti mera watohimatamonaka, tabora one ka mati me hikeyehari. Hamehimatamonaka kasiro ya. Mera yosehimatamonaka Bere ka matehe nafi me waka nabone mati, me ka faha fowe famamatara mati. Bere yabori ka matehe toha nemetemoneke. Afa fa fowe me kaminemetemoneke Eroti ni ya, tabora one ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Fara yama Teoso ati kakamina Seremia tohe hikaminehemetemoneke, ati e nari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","\"Me ka one fanawi ohi na ohi ni saihemetemoneke, Hama ya ohi ni kitaharo. Hakeometemoneke matehe tabiyo, yawaha ohi naro. Ohi ni me fawa hinihabone ohi ni fawa hinaremetemoneke, matehe ahabi karo\", ati nematamonaka Seremia. ");
INSERT INTO jaa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manakobisa Eroti ahabe ya Yose Teoso nanarifa watari awehimatamonaka Esito ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","\"Aya inamatewe me nabowabone me ati namaro me ahabarake. Te tokomakabote nahi. Inamatewe toha mati toha na te tokomahi Ihayeo me tabori ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Me yana tokanakabote na inamatewe me towakamehemetemoneke, mati ya famahari Ihayeo ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yose kobo toname Eroti biti Akerao tohehi tamine mitehimatamonaka towisawa tohawahari bati taboro ya. Hinakomehematamonaka. Teoso hihiyarematamonaka wata ya. Faya Soteya fiya toname tokomematamonaka Karireya ya. ");
INSERT INTO jaa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sitati Nasare ya winawehimatamonaka. Fara yama Teoso ati kakamina hikaminehemetemone nima ehene nematamonaka, ati e nari ahi. Nasare kamona me hinehibona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Afa yama ya Yowao Batisita mera kanawani yana tonehimatamonaka, Soteya ka yama honara ya, ati e nari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","\"Te ka yama hiyara te nofamarahabone teke. Teoso ka towisawa kamakikabote nebonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Fare Teoso ati kakamina Isaiya tohe atimatamona nima Yowao Batisita ehene nematamonaka. \"E ka owa ati yana nebonaka yama honara ya, ati e nari ahi: 'Teoso hawinebona te namosahi. Hawi te yai tonihahi, Teoso hawinebonaha'\", Isaiya ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowao ka makari kamero kone tohehemetemoneke. Tosi matone bani ataro toha nematamonaka. Habise mera kaba, abiya me fehe fawa, na tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Serosarei ka me nafi tokomakehemetemoneke he ni ya. Soteya ka me toha, Sotao ka faha yabori ka me toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mera iibofarisematamonaka Sotao ya, me ihi hiyara me ihi me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseo me toha, satoseo me toha na me tokomakehemetemoneke he ni ya, me hihibofarisabone mati. Mera awehi ati yana nematamonaka. \"Ha te maka biti me te amake, maka komaharo. Hike te narabo nima rano, te kana nawahabone te, Teoso tera kosi rebona te? Teoso te watoha te awineke, mera kosi nebona ati nari, me ihi hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Te ehene hiyara te nofamaramone te ati na, yama amosa te hiri nawahahi waha. ");
INSERT INTO jaa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te ati boti e rima nahi ahi: 'Abarao ka noti me ota amake', te ati rima nahi. Abarao ka noti mebone mera Teoso nofe ya Abarao ka noti mebone mera hiri nebonaka yati ya, so tosaharo ahi. ");
INSERT INTO jaa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Teoso bari tama ni hawa toe awa ka nebonaka hibayata ya, awa boni hiyararo. Ka hini ya koro hiwitiaboneke yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ha owa tera oobofarisine oke faha ya, te ehene hiyara te nofamara te. Owa onowati ya kamakibonaka, kiti mati tohahari. Okita okere, ha owa. Hahi narifi owato okara, owehene amosara owa. Hinaka sataya tama ni owato okere, owehene amosara owa. Tera batisa neba amaka Teoso Kanamori ya. Tera batisa, neba amaka yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tiriko kekero kana tama naka, hinaka tiriko namosebona ati nari. Hinaka tiriko nafi namosebonaka, hobokori nafi ahababonehe. Tiriko namosi ahabe ya tiriko tonihebonaka yobe ya. Hobokori sari hikana hinaboneke yifo ya, yifo owihinateraro\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Afa yama ya Sesowi yana tonematamonaka Karireya ya. Tokomematamonaka Sotao ya, Yowao hibofarisebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yowao ibofarisi hinofarehimatamonaka. \"Himataba tikamakine tiri owa ni ya, tiwa obofarisabone tina tiwa? Owa tibofarisabone onahara oke, ha tiwa ta\". ");
INSERT INTO jaa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sesowi ati yana nematamonaka. \"E ehene e na ahi mata. E ehene e ni ya e ehene amosaba amake Teoso ni ya\", ati nematamonaka. Faya Yowao ati amosematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sesowi ibofarisematamonaka. Manakobisa faha ya Sesowi wamisame neme hine naha kanaha ya Teoso Kanamori awehimatamonaka kisahari. Okoko nima ne kakehi kobo nematamonaka he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Neme ya Teoso ati saihimatamonaka. \"Okatao amaka hari, onofari, ehene amosari owa ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Teoso Kanamori ati ehene Sesowi tokehimatamonaka yama honara ya, Satanaisi totomi hinehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Amo ni 40 yia tohaha ya hiwa nafimimatamonaka. Manakobisa fimi hiwasimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satanaisi era totomi tohahi kakehimatamonaka he ni ya. \"Teoso biti ama ti? Keye amarini? Teoso biti tihi ya yati tinihawahahi, bao tohahabana\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sesowi ati yana nematamonaka. \"Teoso ka yama hani ati e te amake ahi: 'Bao kabi e ohari ya e amosatera amake. E amosate amake, Teoso ati nafi e kamitaro', ati te amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Faya Satanaisi hekamematamonaka Teoso ka sitati ya, Serosarei ya. Hinawarematamonaka teboro tati nemehe ya. ");
INSERT INTO jaa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","\"Teoso biti ama ti? Keye amarini? Teoso biti tihi ya yora tinisahi bofe ya. Yama hani ati e te amake ahi, me rawi hinehemete: 'Teoso he nanarifa mera yosehibonaka, tiwa me kakatomahabone mati. Tiwa me itimisahaboneke, titeme karimarahabone tiwa yati ya'\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sesowi ati yana namatasehimatamonaka. \"Yama hani one na narake, ati e naro ahi: 'Tika Teoso e ka Hiti tohe totomi tirahabone tike'\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Faya Satanaisi hekamatasehimatamonaka tasa, atami nemeha ya. Me nafi ka wami namohimatamonaka. Towisawa me nafi ka yinero namo, me ka yama nafi namo, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","\"Owa tinofi ya onokosi ya tisi ya me nafi ka yama ta onahabana oke tiwa ni ya. Wami nafi ka me ka towisawa tihawabana tike\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sesowi ati yana namatasehimatamonaka. \"Satanaisi tikamahi. Teoso ka yama hani ati e te amake ahi: 'Teoso ohari nokosi ya te foro nabone teke. Teoso narifi te ohari nabone teke'\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Faya Satanaisi tokomematamonaka fahi. Teoso nanarifa me kamakabote nemetemoneke, he me narifabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Faya Sesowi Yowao tamine mitehimatamonaka, foyahari kateya ya. Tokomematamonaka Karireya ya. ");
INSERT INTO jaa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Winamarehimatamonaka Nasare ya. Winawehimatamonaka Kafanao ya, faha ehebote witi ya. Seboro ya Nafitari famaha ka sitatimetemone amake, Kafanao. ");
INSERT INTO jaa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaiya atimatamona nima Sesowi ehene nematamonaka. Isaiya ati e nematamonaka ahi: ");
INSERT INTO jaa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","\"Haha rako hawi ya me winaha Sotao kowani ya, yama soki ya me sawiha yama oye me awaharake, oye kitaharo. Me ahabinima na me ni ya yama oye tasi nakeharake me baikani ya, me winaha mati Seboro ya, Nafitari famaharo, bara me ka Karireya ya\", Isaiya ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sesowi Teoso ati kamini yana tonehimatamonaka. \"Te ehene hiyara te nofamarahabone teke. Teoso ka towisawa kobo nima ka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Karireya ka faha witi ya yaka ne me famaha mera awehimatamonaka, Simao Betiro tohehi toha, nisori Atere toha, ne mati, tahafa me were nifeha mati rako ya, faha kiki me toha mati. ");
INSERT INTO jaa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mera aate nematamonaka. \"Owa ni ya te kasawihi. Owati ihi e ka one me te ki naba teke waha\". ");
INSERT INTO jaa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Me ka tahafa me kakosehemetemoneke hibati ya. Faya Sesowi ya me tabehemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sesowi tokawehi me famaha mera awehimatamonaka, Tiako Sebeteo biti toha, nisori Yowao toha nari, me kawita mati kanawa ehebote ya, me ka abi ya me tabaha mati, Sebeteo, tahafa me sako namaha mati. Sesowi me hima hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kanawa me kakosa, me ka abi me kakosa, nemetemoneke hibati ya. Faya Sesowi me ya tabawematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yaka nawaharehimatamonaka Karireya ya, mera kanawanahari sinakoka ya, soteo me hihiyara ka yobe ya, Teoso ati me kamina mati. Sinakoka ya hiyara amosa kaminematamonaka, Teoso ka towisawa kaminari. Me kiya na mera kasoma nematamonaka, yama kome yoro tokana me kiha mati. ");
INSERT INTO jaa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria ka me nafi tamine himitematamonaka waha. Me kiya na me me kakiemetemoneke me nafi, yama kome yoro tokana me kiha mati. Me one me me kaki nemetemoneke, me rabika me toha, hine me wiwiyi tona me toha, me yana ni watora me toha na mati. Mera kasomematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Me tamaha me ya tabehimatamonaka. Karireya ka me toha, Tekabori ka sitati ka me toha, Serosarei ka me toha, Soteya ka me toha, Sotao kowani ka me toha, na mati. ");
INSERT INTO jaa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sesowi me tamaha mera awehi tokomisehimatamonaka atami ya. Itarimatamonaka. He ya tataba me tokomakehemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mera kanawanehimatamonaka, ati e nari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"Teoso mera nofate amaka, yama tamaha me nofara mati, Teoso ta me nofaha mati. Teoso ka towisawa ya me tabatehaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","\"Me ohi na Teoso mera nofaka. Mera yayai nibonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","\"Teoso mera nofate amaka, me amosamone me atiba yana ra mati. Me ka wamibone Teoso ta hinahaboneke, wami nafi\". ");
INSERT INTO jaa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","\"Teoso mera nofate amaka, yama amosa me hiri nabone me ati na mati. Mera narifebonaka, yama amosa me hiri nabone mati\". ");
INSERT INTO jaa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","\"Teoso mera nofate amaka, me one me aawawa na mati. Mera aawawa nebonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","\"Me ati boti amosa Teoso mera nofate amaka. Teoso me awahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","\"Teoso mera nofate amaka, me abe mono na me me ebe kanaha mati. Me one Teoso biti memone me me tonihaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","\"Me ihi amosa me one me hinofara Teoso me hinofate me amake. Teoso ka towisawa ya me tabatehaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","\"Owa te nofaha me one tera me nofara tera me hora kana Teoso tera nofate amaka. Keye me hiri na te ehene hiyaramone me ati na Teoso tera nofate amaka. ");
INSERT INTO jaa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Te ni ya me ihi e na te yayai nabone teke. Teoso tera kakawebonaka yama amosa tamaha ya neme ya. Hibati ka me ihi e nemetemoneke ahi, Teoso ati kakamina me me kakoa mati\". ");
INSERT INTO jaa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","\"Saha nima te nineke. Bani e ketehate e amake saha ya, ahabarehibonaha. Saha ihi amosate amake. Bofe ka saha te tohate te amake, yama amosa te hiri na te. Saha sinari watamari ya himata nima e ribe, saha sinari kamiba karo?. E sika towitiaboneke. Me one tai hinahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","\"Yama oye nima te nineke, yama nafi firi kanaharo. Sitati e awate e amake, e nafi, atami ya naharo. Sitati e na kehemotera amake. ");
INSERT INTO jaa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nabarina e sari kani ya e boko kanisatera amake boti tori ya. Nabarina e kawatarete amake neme ya fara nabarina tabori ya, yobe nafi firi kanahabana, me nafi noki awibone karo\". ");
INSERT INTO jaa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","\"Yama oye nima te ehene nineke, te ehene amosaro. Yama amosa te hiri ni ya te ehene me awi ya te ka abi me kahiyarahaboneke, winahari neme ya\". ");
INSERT INTO jaa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","\"Te ati e riyahi ahi. 'Mowisei ati Sesowi nahabihibona ati nareka', te ati riyahi. 'Teoso ati kakamina me ati Sesowi nahabihibona ati nareka', te ati rihi nabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Haha me ati nahabi onofa okere. Fara yama Mowisei hikaminehemete hiri onahabone onahara oke. Haha yama nafi hikaminehemete kaketehaba amake. Yama hasi naba watateraba amake, kaketehabone Mowisei hikaminehemete. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Haha me hikaminaha hiri tiri ya, tiwehene nima me one ihi nabone tini ya, Teoso ka towisawa tera nonofa raba neba amaka. Haha me hikaminaha hiri tini ya, tiwehene nima me one ihi nabone tini ya, Teoso ka towisawa tiwa nofehiba amaka mata ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mowisei ati kakamina me ya fariseo me tabaha me ihi nima tiwehene ni ya Teoso ka towisawa tiwa nofareba amaka. Tiwehene amosi mati tohi ya Teoso ka towisawa tiwa nofehiba amaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","\"Me tamine te mitate te awineke hibati ka mati, yama tamine me mitehemetemone mati, tamine e naro ahi: 'Te ka owa tinabowarabone tike. Te ka owa tinabowi ya tiwa me nabowaba me amake, sowisi ati ehene', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Owati e nineke ahi: Te ka owa tikako ya tiwa me nabowaba me amake, sowisi ati ehene. 'Tihiya tikere', tini ya e ka Hiti me ati ihi tihababone tike. 'Titati hiyara awineke', tini ya tikamakehabone tike yama hiyara ya, yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Teoso ni ya yama ta tinahabone tina teboro ya tikamake, yama hiyara hiri tinaha wati tiwahi ya tika owa ni ya, ");
INSERT INTO jaa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Teoso ka yamabone ta tirahabone tike mata. Yama tohahaboneke mata teboro ya, tana nokosi ya. Tikamakehabone tike tika owa ni ya, tiwehene hiyara tinofamarabone tina tiwa he ni ya, tiwa kakomarebonaha. Faya teboro ya wete tinamabone tike, Teoso ka yamabone ta ni tinataminabone tiwa waha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","\"Tika owa tiwa towakame ya sowisi ni ya, yama manakone kote tinahabihabone tike hawi enoki ya. Yama manakone tinahabihari ya tiwa towakamebonaka sowisi ni ya. Sowisi tiwa ta towahawitiba amaka saotato ni ya, tiwa ibebonaha kateya ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tasi toni tinofi ya yama manakone nafi tinahabihabone tike. Yama manakone nafi tinahabihari ya tasi tirahaba ama tike kateya ya. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","\"Me ati tamine te mitate te amake, me ati e na mati ahi: 'Tifana tika yibote amara ahi tirahabone tike', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Owati e nineke ahi: Fana ahi ni tinofi ya tiwati boti ya, ahi tinaharake tiwati boti ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tinoko ihi yama hiyara hiri tini ya tinoko soba tiwitihi. Koro tiwitihi. Tika abono nafi Teoso koro towitirayaho yama hiyara ya, yifo hiri ni ya. Tinoko oharia fawa ni ka amosake. ");
INSERT INTO jaa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tika kanihina ihi yama hiyara hiri tini ya ti tisi ya koro tiwitihi. Tika abono nafi Teoso koro towitirayaho yama hiyara ya, yifo hiri ni ya. Timano oharia fawa ni ka amosake\". ");
INSERT INTO jaa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","\"Me ati tamine one e nemetemoneke ahi: 'Tika yibote tinofamari ya hinaka yama haniba ta tinahi, tokomabana', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Owati e nineke ahi: tika yibote maki owa ahi hina toyosemi tinofi ya tokomabanake. Maki owa ahi hira tiyosemaraboneke. Tiyosemi ya me one noko hinihaba amake. Tiyosemi ya e ka owa hitiwahi ya yama hiyara hiri neba amaka, tika yibote ahi nari\". ");
INSERT INTO jaa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","\"Me ati tamine te mitaha te awineke, me ati e naro ahi: 'Teoso ino hiri tini ya keye hiri tirahabone tike', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Owati e nineke ahi: Keye hiri tirahabana tike. Yama hiri tinahabone tina tiwati e nabone tike ahi: 'Yama hiri onahabone oke', tinahabone tike. Yama hiri tirahabone tina tiwati e nabone tike ahi: 'Yama hiri orahabone oke', tinahabone tike. Fara tiwatiboneke. Yama one kamini tinofi ya Satanaisi yama hinofa hiri tine tike. Neme ini hiri tirahabone tike. Afa neme Teoso taboro amaka. Wami ini hiri tirihi, tinahabone tike. Fara Teoso ka wami amake. Serosarei ini hiri tirihi, tinahabone tike. Serosarei Teoso ka towisawa amose taboro amaka. Titati ini hiri tirihi tinahi. Afa titati Teoso ka amake. E ehene amara e tati kone wiyo te amake. Fare Teoso ati ehene amaka. E tati kone wiyo na e tati kone e tonihawahamatera amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","\"Me ati tamine one amake haro, te mitaharo, me ati e na mati ahi: 'Tinoko one me nahabi ya me noki tinahabihabisaba ama tike, tinoko manakone. Tiwini one me nahabi ya me ini tinahabihabisaba ama tike, tiwini manakone', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Owati e nineke ahi. Tiwa ni ya tika owa ehene hiyare ya tiwehene hiyara watarabone tike he ni ya. Tinoko baki me tao kani ya tinoko baki one behe tiwahamahi, me tao hikanabana tasa. ");
INSERT INTO jaa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sowisi ni ya tiwa me kamini ya sowisi ati ehene tika makari boti ka me ati ni ya, tika makari mese ka ta tinamakehaba ama tike. ");
INSERT INTO jaa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Saotato tiwa yose ya hinaka yama weye tinahaba ama tike, kirometoro oharia ya. Hinaka yama tekama tinahaba ama tike tasa kirometoro one ya. ");
INSERT INTO jaa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Me one tika yama aate ni ya me ka yamaba ta tinahi. Yinero tabiyo me one tiwa aate ni ya me ka yineroba ta tinahi\". ");
INSERT INTO jaa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","\"Me ati tamine one nake, ati e naro ahi: 'Tika one me tinofabone tike. Tika one me amara me tinofarahabone tike'. ");
INSERT INTO jaa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Owati e nineke ahi: Tiwa me nofara me tinofabone tike. Yama hiyara me hiri ni ya tiwa ni ya, me ora tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te ehene e ni ya ahi te e naba teke, te ka abi neme ke nima. Me ihi amosa me ni ya hinaka bahi hiwene ta, me ihi hiyara me ni ya hinaka bahi hiwene ta, te amaka. Me ihi amosa me ni ya faha kake, me ihi hiyara me ni ya faha kake, te amake, ati ehene. ");
INSERT INTO jaa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tiwa nonofa me nofi tiwahariha Teoso ka yama manakone wara titeraba ama tike. Yinero yayaba me ihi e te me amake ahi, mera nonofa me me nofaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te one me hiyari tiwahariha yama amosa hiri tirine tike. Bara me ihi e te me amake ahi. ");
INSERT INTO jaa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Te ka abi ehene nima te ehene nabone teke, yama amosi mati tohaha te hiri na te. Te ka abi neme ya winate amaka, yama amosi mati tohaha hiri nari\". ");
INSERT INTO jaa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","\"Yama amosa hiri rima tinahi te one me nokosi ya, tiwehene amosa me awahabone tiwa. Tiwehene e ni ya ahi tiwehene manakone tikihateraba ama tike abi ni ya, winahari neme ya\". ");
INSERT INTO jaa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","\"Yinero me kihara me ni ya yinero ta tini ya tiwehene tikaminarabone tike me one ni ya. Me one ati boti hiyara me ihi e te me amake ahi, sinakoka ya me sawiha mati, howa ya me naho na mati. Me ihi amosa me ihi me one hiwahabone me ati te me amake, me amosamone me me hinahabone mati. Teoso ni ya yama manakone me wara toteraba me amake. Me amosamone me one me me hina me ihi manakone me ihaharake hibati ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yinero me kihara me ni ya yinero ta tini ya tiwehene tikaminarabone tike me one ni ya, tiwehene amosa me watoribone karo. ");
INSERT INTO jaa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yama me hiwara abi hiwate amake. Tiwa awe ya tika manakone nahabihiba amaka tasa\". ");
INSERT INTO jaa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","\"Teoso ha tina tiwehene e rabone tike ahi, me ati boti hiyara me ihi nima. Sinakoka toro ya me ora te me amake, me nahoria mati. Howa batori ya me ora, te me amake, me ihi me hiwahabone me ati na mati. Teoso ni ya yama manakone me wara toteraba me amake. Yama manakone me wara tonaharake hibati ya, me ihi amosa me ihi me one hiwi karo. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ora tini ya tikiyomamabone tike tika yobe bari kani baikani ya, nokobi boko tikana tiwa. Abi ha tinahi, e awarari. Abi ka yama manakone wara tinahaba ama tike. Me one tiwa awara tiwa awehibonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","\"Ora tini ya bara me nima tirahabana tike. Fara me ati me hiri hina me hiri namarima te me amake, me ati e na mati ahi: 'Fara owati hiri onaha hiri namarima oni ya Teoso owati mitehiba awaka', me ati te me amake. ");
INSERT INTO jaa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Me ihi nima tiwehene rabone tike. Yama tinofa abi hiwatote amake, tiwati watamatari ya\". ");
INSERT INTO jaa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","\"Te ora ni e na ahi: 'Ota ka abi Teoso tiwinate ama tike neme ya. Me nafi tiwa kahiyarahi. ");
INSERT INTO jaa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tika towisawateba kakeho ota ni ya. Yama tinofa me hiri nahi, bofe ya me winaha mati, neme ka me ihi nima me ihi nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Haha yama wehe ka ota tefebone ta tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ota ehene hiyara ota ehene sa tisahabone tike. Ota ka one me ihi hiyara me ihi ota sa tosa na otake. ");
INSERT INTO jaa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanaisi otara totomi rayaho tiwati ihi', te ati nabone teke, te ora na te. ");
INSERT INTO jaa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Te ka one me ihi hiyara te fawa niha te ehene hiyara te ka abi neme ka fawa nihibonaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te ka one me ihi hiyara te fawa niri ya te ka abi neme ka te ehene hiyara fawa nirebonaka bisa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","\"Tiwa tinafimi ya tiwehene e rabone tike, me ati boti hiyara me ihi nima. Me tafi fawa na me yayai namatera me amake. Me noki me soko namatera me amake, me ihi me one me hiwahabone mati, me tafi fawa na mati. Yama manakone me wara tonaharake hibati ya, me one ni ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tiwa tinafimi ya tinoko soko tinahabone tike. Titati kone tikete tinahabone tike orifa fehe ya, amosabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tiwehene me watoraba me amake, tiwa tinafimiha tiwa. Abi ta tiwehene watoka. E aware era awate amaka. Tiwa kakawebonaka yama amosa ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","\"Yinero te tonihariyahi ahi, bofe ya. Yama abe yama kabate amake ahi. Yama wirabako na yama nahabi, te amake. Yama boboti tokiyomate amaka e ka yobe ya, yama botihibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yinero te tonihahi neme ya. Neme ya yama abe yama kabatera amake. Yama wirabako na yama nahabirihi, te amake. Yama boboti tokiyomarihi, te amaka e ka yobe ya, yama botihibana neme ya. ");
INSERT INTO jaa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bofe ka yama tamaha te nofi ya bofe ka yama te wati nawahaba te amake. Neme ka yama te nofi ya Teoso yama hinofa te hiri nabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","E ka owa yinero noko tonihe ehene e ati e te amake ahi: 'Noko hiyakara hari', e ati te amake. E noko e te amake ahi, yama oye nima, e abono firi kanaharo. Tinoko amosi ya tika abono nafi firi kanahaboneke. ");
INSERT INTO jaa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tinoko hiyari ya tika mese nafi sokihaba ama tike. Tika oyene watari ya tika mese sokihaba ama tike. ");
INSERT INTO jaa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","E ka hiti meba me famihinakere, me e narifikimaba mati. Owa e nofe ya hahi e nofamarehibonaka hari. Ha ita e nofe ya hahi e nofamarehibonaka hari. Yinero noko e toniha Teoso e nofatera e amake\". ");
INSERT INTO jaa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","\"Makoni owati e nineke ahi: Te kokoriri rabone teke, te ka yamabone te wati nawaha te. Te ati boti e riyahi ahi: 'Himata okobaribe? Himata ofaribe? Himata okaribe?' te ati rabone teke. E hasi ni ya e yayai nabone eke, yamata tamaha noko e toniharaharo. E abono tamini ya e yayai nabone eke, makari tamaha noko e toniharaharo. ");
INSERT INTO jaa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bani me te awa ha, me kakeha mati neme ya. Fatara ya yama me koro rihi, yamata me tonakarihi, yamata me toniharihi, te me amake yobe ya. Te ka abi neme ya winehi me tafebone ta tehi amaka. Teoso bani mera nonofa raba ne tera nofi mati tohate amaka, ha te ta. ");
INSERT INTO jaa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yama tamaha te wati nawaha te kokoriri kene te ahababone teke fara te ahabi amo nibone ya\". ");
INSERT INTO jaa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","\"Himataba te ka makaribone te wati nawahineri? Yama kabani ka yama mowe te awa ha, mowe amosaro. Yama mowe amosa fara ihi amakere, boribone hiri raro. ");
INSERT INTO jaa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Saromao borone aamosa raba nematamonaka. Yama kabani ka yama mowe ta amosi mati tohake. ");
INSERT INTO jaa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yama kabani ka yama mowe amosa Teoso ehene amake. Yama kabani ka yama ahabi kerewe raboneke, me sari hikari ya. Yama kabani ka yama manakone yokana tohakere. Ha te ta te manakone nafike. Teoso te boronebone ta nebonaka. Himataba te ati boti e na te awineri ahi: 'Teoso owa kakaweba ama oko yamaba ya?' te ati na te?\" ");
INSERT INTO jaa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","\"Te kokoriri rabone teke, te ka yamaba te wati nawaha te. Te ati e rabone teke ahi: 'Himata okobaribe? Himata ofaribe? Himata okaribe?' te ati rabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Haha yama bara noko me tonihate me amake. Te ka abi neme ya winehi te ka yamabone te nofaha watote amaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Teoso ka yamabone te ahi nabone teke, Teoso yama hinofa te hiri na te. Te ehene e ni ya ahi haha yama te nofaha ya tera kakawebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Te kokoriri rabone teke, yama te wati nawaha te, yama wamini ka yamabana. Fara hibayata ka yama wehe ka yamabone te wati nawahabone teke. Yama wehe oharia ka yama hiyara fayaboneke ahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","\"Me tikakorabone tike. Me tikako ya Teoso tiwa kakobisebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tiwehene e ni ya me ni ya Teoso ehene e nabisebonaka tiwa ni ya fara tiwehene nima. ");
INSERT INTO jaa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tika owa noko ebene biti foyehi tiwini? Tinoko tiwahi. Awa ibe foyake tinoko ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tiwati e narake ahi tika owa ni ya: 'Hiba tinoko abe bite foyaha soba onamibeya', tinahara tike. Awa ibe foyaha tiwa tikere tinoko ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tiwati boti hiyarara tike. Tinoko ka awa ibe foyaha soba towiti tai tohahaboneke. Tinoko ka awa ibe foyaha soba tiwiti ya tinoko awi amosabone tike, tika owa noko ebene soba tiwitibone karo\". ");
INSERT INTO jaa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","\"Teoso ka yama te ta rabone teke yome me ni ya. Kasaro amosa te koro towitirihi nabone teke boroko me nokosi ya. Kasaro me tai riyahi. Kasaro me tai ni ya tiwa me fito kanahaba me amake, tiwa me nabowahaba mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","\"Yama tinofa ha tikanabone tike Teoso ni ya. Tika yamabone ta nebonaka. Yama siba tini ya tiwasiabanake. Nokobi teo tikani ya Teoso se hikanaboneke. ");
INSERT INTO jaa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","E ka one Teoso me aate ni ya ati amosebonaka me nafi ni ya. Yama me siba hina me hiwasiaboneke, me nafi. Nokobi me teo kana me ni ya Teoso nokobi se kanehibonaka, me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tiwa ni ya tikatao bao aate ne ya hinaka yatiba ta tinahaba ama? ");
INSERT INTO jaa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tiwa ni ya tikatao aba aate ne ya hinaka makaba ta tinahaba ama? ");
INSERT INTO jaa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yama hiyara hihiri me te tohaha yama amosa te ta teha te amake te ka matehe ni ya. E ka abi neme ya winehi ehene amose hinama tohate amaka. Yama amosa ta nebonaka te aate ne ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","\"Fara yama me hiri hinahabone tinaha tiwa ni ya, afa yama hiri tinahabone tike me ni ya. Tiwehene e ni ya ahi, fara Mowisei hikaminehemete hiri tine tike. Fara Teoso ati kakamina hikaminehemete hiri, tine tike\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","\"Hawi famate amake. Hawi one nafi, hawi one nafirihi, te amake. Hawi nafiha ka nokobi nafi, hawi nafira ka nokobi nafirihi, te amake. Me tamaha me tokiyomatehaba me amake nokobi nafiha ya. Me tamara me tokiyomatehaba me amake nokobi nafira ya. Ha tiwa tikiyomahabone tike nokobi nafira ya. Hawi nafiha ya yaka tini ya tihababa ama tike. Hawi nafira ya yaka tini ya tihabarahaba ama tike\". ");
INSERT INTO jaa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","\"Tera te kakatomiyahi. Me natehaba me amake, Teoso ati kakamina memone me ati na mati, Teoso ati kakamina me amara mati. Me yahahamone me ati na me ati boti hamate me amake. Ofeya me awi nima me awi na robo me tohate me amake. ");
INSERT INTO jaa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Me ihi te awi ya me te watohaba te amake, me ati boti hiyara mati. Ofa boni kobobo tera amake atiwa ete ya. Fiko boni kobobo rihi te amake atiwa ete ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Awa boni amosa kobobo te amake awa amosa ya. Awa boni hiyara kobobo te amake awa hiyara ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Awa boni hiyaraba watatera amake, kobobo naro awa amosa ya. Awa boni amosaba watatera amake, kobobo naro awa hiyara ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Haha awa boni hiyara me ka hite amake, me koro hiwitiabonehe yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Me te watohaba te amake, yama me hiri hina te awi ya\". ");
INSERT INTO jaa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","\"'Ota ka Hiti owa tikasomahi', tini ya Teoso yama hinofa hiri tiri ya tiwati omitaterabone oke, tiwa okasomahabone owa. Teoso neme ya winehi te famahabone tini ya Teoso yama hinofa hiri tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Afa yama amo ni ya me tamaha me natehaba me amake, me ati e na mati ahi: 'Ota ka Hiti tiwati ihi Teoso ati ota kaminamaro otake. Me rabika me ota kasomamaro otake, tiwini ota hiri na ota. Yama fotaha ota namohamaro otake, tamaharo, tiwini ota hiri na ota'. ");
INSERT INTO jaa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Me ni ya owati e tehaba ama oke ahi. 'Tera owatera ama oke. Te watarabone teke owa ni ya, te ehene hiyara te', otehaba ama oke\". ");
INSERT INTO jaa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","\"Owati timiti ya yama okominaha hiri tini ya e ka owa yama watohi nima tinahabone tike, yobe ewene si tonihemata yati mese ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yobe hawa tohe ya faha kaki nafihemetemoneke. Faha fowe kimisemetemoneke. Boni kita nemetemoneke. Yobe sonarematamonaka, warehari yati mese ya\". ");
INSERT INTO jaa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","\"Owati timita yama okominaha hiri tiri ya hahi yama watore nima tinahaba ama tike, yobe ewene si tonihemata siki mese ya. ");
INSERT INTO jaa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yobe hawa tohe ya faha kaki nafihemetemoneke. Faha fowe kimisemetemoneke. Boni kita nemetemoneke. Faya yobe sone ahabematamonaka nafi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Me tamaha Sesowi ati me kamitemetemoneke. Manakobisa hiyari ahabe ya 'Hika', me ati nemetemoneke, he ati me mitaha mati, ");
INSERT INTO jaa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mowisei ati kakamina me ati nima Sesowi ati re karo. Mowisei ati kakamina me one ati me kamina Sesowi ta fare ati kaminematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sesowi atami ya yana tone kisamematamonaka. Me tamaha me ya tabehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Me ka owa mese hiyare tokomakehimatamonaka he ni ya. Sonehimatamonaka he nokosi ya. \"Ota ka Hiti owa kasomi tiwatoa tiwa awine tike. Owa kasomi tinofini?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sesowi bori hikanematamonaka yehe ya. \"Tiwa kasomi onofa oke. Tikitamahabone tike hibati ya\". Mese amosawahamibote nematamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sesowi hihiyarehimatamonaka. \"Owehene tikaminariyahi me ni ya. Tikamahi sasetoti ni ya, tiwa tinamobeya sasetoti ni ya. Mowisei yama hikaminehemete ta tinahabone tike Teoso ni ya, tiwa me watobone karo, titaminawaha tiwa\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sesowi tokomematamonaka Kafanao ya. Kobo toname Homa ka saotato kamakimatamonaka he ni ya. Saotato mera yoyosematamona amaka, saotato 100 me tohaha mera yoyose tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Saotato ati yana nematamonaka. \"Ota ka Hiti oko yama aahi forehareka kama ya, yobe ya, yana ni watorari, yama kome awi kitahari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sesowi ati yana nematamonaka. \"Okomakehabana oke. Okasomehibanaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Saotato ati yana namatasehimatamonaka. \"Ota ka Hiti tikamarabone tike oko yobe ya, titaminaha tiwa. Otamina okere ha owa. Hine ya tiwati yana ni ya oko yama aahi kitamebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tiwa nima one oke, me one oyoseha owa. Saotato me oyosete ama oke. 'Tikamakehi', oni ya saotato tokomakehibonaka. 'Tikamahi', owa ni ya oni ya kamehibonaka. Oko yama aahi me oyose ote ama oke. 'Yama e na hiri tinahi', oni ya oko yama aahi hiri hinahaboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sesowi ati himite \"Hika\", ati nematamonaka. Mera hiyarematamonaka he ya me tabaha mati. \"Hahi bare nima me naba me watakere, Ihayeo mati, Teoso kitehimona ati nari. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Me tamaha me kaketehaba me amake, yama nafi ka mati, Abarao Isaki Yako me na me tafi ya me tafi tabahabone mati, Teoso ka towisawa amo ni kobo ne ya. ");
INSERT INTO jaa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Fara Teoso ka towisawa taboro ka me ta me me were hiwititehaba me amake yama sokiha ya. Me ohi tehaba me amake fahi, me ini yiki tokana mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sesowi saotato hiyaramatasehimatamonaka. \"Tikamahi tika yobe ya. Fara tiwati nima yama naboneke\". Fare bahi ya hinaka yama aahi kitamematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sesowi tokomakehimatamonaka Betiro ka yobe ya. Kobo tonamake tokiyomamake Betiro hinakaso foreha awehimatamonaka, kama ya, yama kome awaharo. ");
INSERT INTO jaa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mani boyo hinaha yama kome fawa nemetemoneke. Yana namisama he narifemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bahi toke ya me kakehemetemoneke, me tamaha me me kakia mati, me rabika mati. Inamati mera toyosemehimatamonaka fare ati ya. Mera kasoma nematamonaka, yama kome me awaha me nafi. ");
INSERT INTO jaa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fara yama Teoso ati kakamina Isaiya tohe hikaminehemetemoneke hibati ya, Teoso ati kaminari, ati e nari ahi: \"Era kasomareka, e ka yama kome fawa nihari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sesowi me tamaha mera awehi he ya tataba mera yosehimatamonaka, he me towakabone mati rako kowani ka ya. ");
INSERT INTO jaa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mowisei ati kakamina owa kamakimatamonaka he ni ya. \"Borofeso osawiabana oke tiwa ni ya, yama nafi ya, fara tika toki nima\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sesowi ati yana nematamonaka. \"Kawara me hoti nate me amake. Bani biti me tabori na, teha me amake. Neme ka Owa taboro watatere amaka, aamo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","He ya tataba me ka owa he aate nematamonaka. \"Ota ka Hiti e tabahabone wete onamamatabana oke mata, otaboro ya, okobi okomoaba owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sesowi ati yana nematamonaka. \"Hine e tabake. Me ahaba me abohi hine me one me me hikamoaboneke fara me one ahaba mati\". ");
INSERT INTO jaa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sesowi itarimatamonaka kanawa tori ya. He ya tataba me kibemakemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Me kariwa me ni ya yama noki yawari kimisemetemoneke. Kanawa bokinima nemetemoneke faha rike ihi. Sesowi amo nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Me hinatafihimatamonaka. \"Ota ka Hiti e ahabakibone. Era tikasomahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","\"Himataba yama te nakomeneri? Teoso tamine te watorini, kitahari?\" ati nematamonaka. Waremise boni ya faha rike famaha fawa nihimatamonaka. Yama nafi amosawahemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","\"Hika\", me ati nemetemoneke. \"Hiketeno amara, boni ati hikataba, faha rike ati hikataba, hinahari?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Me kobo kanehemetemoneke kowani ya, wami ini Katara tohaha ya. Me famaha me rabikatehani me kakiemetemoneke Sesowi ni ya, me kasawitehani mati tama tabori ya. Me yofinemetemoneke. Makoni me fiya tonami me nonofa hiharemetemoneke, me one. ");
INSERT INTO jaa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Me ati kitehemetemoneke kasiro ya. \"Teoso biti himata hiri tiribe ota ni ya? Himata ebe tina tikine tiri ota ni ya? Tikine ti, otara tikatomahabone tiwa, ota amo ni kobo ra ota mata?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yama yabo ya boroko me tamaha me nehemetemoneke, me tafaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hinamati me aate hinehimatamonaka. \"Otara toyosemi tinofi ya otara tiyosemahi boroko me ni ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","\"Te tokomahi\", ati nematamonaka. Me yana tona me tokomemetemoneke boroko me ni ya. Boroko me kana nawahemetemoneke hibati ya, me nafi. Atami ya me tokifiwaha me bokehemetemoneke rako ya. Me ahabemetemoneke faha ihi. ");
INSERT INTO jaa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Boroko me nanarifa me tokomemetemoneke. Sitati ya me kobo tonama me nafi ni ya hiyara me kaminemetemoneke. Haha me famaha me rarabika toha me tamine me kamina, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sitati ka me kamakiemetemoneke Sesowi ni ya, me nafi. Me kobo namakia Sesowi me aate nemetemoneke, tokomebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sesowi tofoyame me kariwama me kobo nemetemoneke fara hinaka sitati ya. ");
INSERT INTO jaa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Me ka owa kama ya forehi me kakamemetemoneke he ni ya, yana ni watorari. Me ihi Sesowi hiwaha me ati boti hiwatoemetemoneke, \"Teoso kitate amaka\", me ati boti ati na mati. Ati yana nematamonaka. \"Okatao yayai tinahi. Teoso tiwehene hiyara fawa nika\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mowisei ati kakamina Sesowi ati me mitaha me ati boti yama nima nemetemoneke. \"Yama hiyara kaminareka, Teosomona ati nari\", me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yama me wati nawaha Sesowi me hiwatoemetemoneke. \"Himataba yama hiyara te wati nawahineri te ati boti ya? ");
INSERT INTO jaa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Owati e nara oke ahi: 'Tiwehene hiyara Teoso fawa nika', onahara oke. 'Yana tinahi, yaka tibeya', onehene ama oke. Fara owati famineke. ");
INSERT INTO jaa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Owa te watowahaba te amake waha, me ihi hiyara me ihi fawa ni owatoa owa ahi, bofe ya, Teoso ati ehene\". Faya me ka owa forehi hiyarematamonaka. \"Yana timisamahi. Tika fofore titihi. Tikamahi titaboro ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yana namisame tokomematamonaka fare taboro ya. ");
INSERT INTO jaa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Me nafi hiwehi \"Hika\", me ati nemetemoneke. Teoso me kahiyaremetemoneke. \"Me ihi hiyara me ihi e ka one me fawa nineke waha, Teoso ati ehene\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sesowi tokome me ka owa awehimatamonaka, itariari yobe ya, me ka yinero yayaba ka yobe ya, Mateo tohahari. \"Tisawihi owa ni ya\", Sesowi ati nemarika. Yana namise he ya famehimari amaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Me tokoma Mateo ka yobe ya Sesowi tafehimari amaka, me ya tabahari, me tamaha mati, me ka yinero yayaba mati, me ya me one tabaha mati, yama hiyara hihiri mati. He ya tataba me toha, namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseo Sesowi me awaha Sesowi ya tataba me me aate namaroke. \"Himataba te ka borofeso me tafi ya tafi tabara, me yoro tokana mati, yinero yayaba me ya yama hiyara hihiri me tabaha mati?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Me ati Sesowi mite ati yana nemarika. \"Yama kome e awara metiko era narifatere amaka, e taminaro. Me kiya na me ta metiko mera narifate amaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Teoso ati te watora te awineke, ati e nari ahi: 'Haha yama onofa okere haro, yama kahi te ta nabonehe owa ni ya. Me one ta te narifabone teke', Teoso ati nematamonaka. Me ihi amosa me ha orahabone okehara oke. Okehara oke, me ihi hiyara me ta me ha onahabone owa\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yowao ya tataba me kamakiamaroke Sesowi ni ya. \"Otara ota nafimirima nineke. Fariseo hine me nafimirima, nineke bisa. Himataba tika tataba hine me nafimirineri?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sesowi ati yana nemarika. \"E ka owa fanehiba ya tataba me ya tabehi ehene me yayai naboneke. Me ohi raboneke. Yama we one ya me one hitimakehibonaka. Faya he ya tataba hine me nafimiaboneke fahi. ");
INSERT INTO jaa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Makari bote e nawanamatera amake makari ibe yati ya. Makari yati e nawani ya makari sibi tonamatasahaba amake, bote tohi karo. Makari hoti tonafihaba amake mata ya. ");
INSERT INTO jaa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Fi yati e tonihatera amake yama atari bote yama wiye tohaha ya. Yama atari sibi toni ya fi ahababa amake. Yama atari ahaba, naba amake. Fi yati e tonihate amake yama wiye yati ya. Fi fawa teraboneke, yama wiye toha naro\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sesowi hiyare ni ya sinakoka owa hiti kakehimarika. He nokosi ya sonarise ati yana nemarika. \"Okoto ahabarake hibayata ya. E tofamamahabone eke otaboro ya. Tiye tekibaribeya he ni ya, kitamabana\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sesowi yana tone he ya tofamamemarika. Sesowi ya tataba me toha, namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sesowi yaka ne me ka one kamakiemetemoneke he nowati ya. Sesowi ka makari tati boni bori kanemetemoneke. Fanawi ka ano 12 nemetemoneke, hinaka ama fawa raro. ");
INSERT INTO jaa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ati boti e nemetemoneke ahi: \"Hinaka makari boyo oni ya okitamahaba ama oke\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sesowi ki nawahame he awe ati yana nematamonaka. \"Okoto yayai tinahi. Titaminawa tike waha, tiwati boti e ni karo ahi, 'Owa kasomebanaka, kitahari', tini karo\", Sesowi ati nematamonaka. Fanawi amosawahamehemetemoneke, hibati ya. ");
INSERT INTO jaa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sesowi kobo tonamake tokiyomamakehimatamonaka sinakoka hiti ka yobe ya. Me tamehemetemoneke, me yobiri na mati, me ati komeha mati. Me one nabisemetemoneke, hohori me hori na mati. Sesowi mera awehi ");
INSERT INTO jaa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ati yana nematamonaka. \"Te tokomahi. Inamatewe ahabakere. Amo nineke hine ya\", ati nematamonaka. He ati me mitaha he me haha kanehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ati ehene me tokomemetemoneke. Tokiyomamakehi inamatewe yehe wara hikana yana namisemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hiyara me kaminemetemoneke, Sesowi ehene me awaha mati, tabora yabora ka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sesowi tokomematamonaka. Me noki awatera me famaha Sesowi nowati ya me towakamakiemetemoneke, he me ha na mati. \"Tafi ka noti otara aawawa tinahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yobe ya Sesowi tokiyome nowati ya me towakiyomamakiemetemoneke. Sesowi mera aate nematamonaka. \"Tera kasomi owatowahamone te ati nine?\" ati nematamonaka. \"Ota ka Hiti ee, otara kasomi tiwatoamone ota ati nineke\". ");
INSERT INTO jaa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Me noki boyo hina me hihiyarehemetemoneke. \"Fara te ati boti nima, yama naboneke, Teoso kitehimona te ati ni karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Me noki awawemetemoneke. Sesowi me narabi nima hinehemetemoneke. \"Tera te kakatomiyahi. Yama te kaminariyahi me ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Me towaka Sesowi ehene me kaminemetemoneke tabora nafi ya, yaboraro. ");
INSERT INTO jaa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Me towakamemetemoneke. Me ka owa me kakiyomamemetemoneke he ni ya, ati yana ni watorari, inamati ehene. ");
INSERT INTO jaa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sesowi ati ehene inamati tokomematamonaka. Faya ati yana namehimatamonaka. Me one Sesowi ya me tabaha \"Hika\", me ati nemetemoneke. \"Yama e na watatera amake Ihayeo me ni ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo me ta Sesowi ehene me nofaremetemoneke. \"Fare inamati me ka towisawa ati ehene tohe awaka. Makoni inamati mera toyosemaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sesowi yaka nemarika tabora nafi ya, sitati nafi ya, mera kanawanahari sinakoka ya. Hiyara amosa kaminemarika, Teoso ka towisawa tamine kaminari. Mera kasoma nemarika, yama kome yoro tokana me awaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Me tamaha me ya tabehimarika. Mera awehi mera aawawa nemarika, ofeya me nima me na mati, me nanarifa watara mati, me kokoriri na me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","He ya tataba mera hiyaremarika. \"Yamata tamake fatara karo. Me tamakere, yamata me yabahaba mati. ");
INSERT INTO jaa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Fatara Hiti te aate nahi, mera yosehibana, yama me ahi naba mati, hinaka yamata me hiyababana\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sesowi mera ha nemarika, me 12 na mati, he ya tataba mati, mera hiyarebonaha. \"Owati ihi inamati me kitaraba me amake waha, me te toyosema mati. Yama kome yoro tokana me awaha me te kasoma, nabone teke owati ihi\". ");
INSERT INTO jaa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Me inimaro amake haro, Sesowi ya tataba mati. Simao tai tohehimarika, Betiro tohahari. Nisori Atere toha, Tiako toha, Sebeteo biti. Tiako nisori Yowao toha, ");
INSERT INTO jaa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firibi toha, Batoromeo toha, Tome toha, Mateo toha, yinero yayaba tohatehari. Tiako Afeo biti toha, Tateo toha, ");
INSERT INTO jaa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simao toha, Homa ka mera momono tohatehari. Yota Isikarioti toha, nemarika, Sesowi ta tehibana. ");
INSERT INTO jaa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sesowi mera yosehimarika, me tokahabone mati, me 12 na mati, afa mati. \"Bara me tabori ya te tokaraba teke. Samaria me ka sitati ya te tokarihi naba teke. ");
INSERT INTO jaa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Te toki ohariabone teke Ihayeo me ni ya, ofeya me tosawariha me nima me na mati. ");
INSERT INTO jaa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te ati e naba teke ahi me ni ya: 'Teoso ka towisawatebona kobo kabona ayata ya', te ati naba teke. ");
INSERT INTO jaa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yama kome me awaha me te kasoma, me ahaba me te nakitama, me mese hiyara me te kasoma, me rabika me te kasoma, naba teke, me ka yinero te aate ra te. Te ka yinero aate orihi ote ama oke, tera okanawana owa. ");
INSERT INTO jaa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Oro te towakarihi, barata te towakarihi, kobiri te towakarihi, naba teke te tosi matone ya kibeharo. ");
INSERT INTO jaa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sakora te weye rihi, makari famaha te towakarihi, sataya te towakarihi, awa te tamarihi naba teke, te yaka na te. Te tefebone me ta naboneke, me kasomi manakone. ");
INSERT INTO jaa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Manakobisa me tabori ya te kobo ni ya te ati e naba teke ahi: 'Hibake amosara ahi?' te ati naba teke. Me ka owa ino me itihaba me awineke, ehene amosari, hinaka yobe ya te sawiba karo. Me one ka yobe ya te tokaraba teke. ");
INSERT INTO jaa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yobe ya te tokiyomami ya te ati e naba teke ahi: 'Teoso tera kakatomehibonaka', te ati niyahi. ");
INSERT INTO jaa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yobe ka me ihi amosi ya Teoso mera kakatomehibonaka. Me ihi hiyari ya te ati e naba teke ahi: 'Teoso tera kakatomareba amaka', te ati nabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Haha tera me nofari ya te tokomaba teke. Te ati kamiti me nofari ya te tokoma, naba teke tabora one ya. Te tokoma te teme hobokori te nahabihaba teke, me tabori ka wami hobokori wataribone karo te ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Haha sitati ka me kokoriri ni nafitehaba me amake, Teoso yama manakone nahabihibona ka amo ni kobo ne ya. Keye amakere. Sotoma ya Komoha famaha ka me kokoriri ni nanafi raba tehaba me amake haha yama ya\". ");
INSERT INTO jaa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","\"Tera oyosehabana oke me ihi hiyara me baikani ya. Ofeya me nima te nabone teke, te sawiha te robo me ni ya. Maka nima te nabone teke, yama te watoha te. Tera me keyehariyahi. Te yahahabone teke, okoko me nima. ");
INSERT INTO jaa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tera te kakatomiyahi. Tera me te naba te amake, tera me ta naba te, me ka sitati me ka hiti me ni ya. Tera me kosi naba me amake sinakoka toro ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tera me namohaba te amake kofenato me ni ya, owa te nofa owehene. Tera me namo naba te amake, kofenato me toha, towisawa me toha, na me ni ya. Owa te kaminabone teke me ni ya. Owa te kaminabone teke me ni ya. Owa te kamina nabone teke bara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tera me ta ni ya te ati boti e raboneke ahi: 'Himata nima owati ribe?' te ati rabone teke. Te atiba Teoso kamineba awaka te ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Te ati amaraboneke. Te ka abi Kanamori ati yana neba awaka te ni ya\". ");
INSERT INTO jaa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","\"E ka owa anoti ta neba amaka, me one hinabowehibana. Owa hinaka matehe ta neba amaka me one ni ya, me me hinahabihaba mati. Owa bati ya mati me famaha mera kakoba amaka. Mera ta neba amaka, me one me me waka hinahaba mati. ");
INSERT INTO jaa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Me nafi tera kakoaboneke, owa te nofi karo. Owa nofi te fawa ri ya Teoso tera kasomebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sitati ka tera me nofari ya sitati one ya te tokahaba teke. Neme ka Owa kamebonaka, Ihayeo me ka sitati nafi te itiri ya mata. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","\"E ka borofeso ka yama wato nima e ka yama wato naboneke. E ka yama wato amosi mati tohahaba wataraboneke. Yama aahi e tohaha e fiya torahabone eke e ka hiti ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Inamati me ka hitimona owa me toniharake, Beosebo tohahari. Beosebo memone tera me toniha naboneke. Beosebomona ya yobe hiti me tonihi ya Beosebo memone ya yobe ka me me toniha, naba me amake\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","\"Makoni me te nakomerabone teke. Yama me kehemoha me ka yama awihinahaba amake. Me hiwatohaba amake nafi. ");
INSERT INTO jaa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Te ka yamabone okominine oke ha te ta te ni ya mata. Owati te kaminabone teke me nafi ni ya. Yama okominine oke te warabo ya mata. Owati te kaminabone teke, te ati kitaha te, yobe bari ya te nahoria te. ");
INSERT INTO jaa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tera me waka nabone me ati na me te nakomerabone teke. Te abono me nabowaboneke. Te kanamori ta me nabowaraboneke. Teoso ta te nakomehabone teke. Teoso ta ati ehene me ahabate me amake yifo hiri ni ya yama hiyara ya. Me aboni ahaba me kanamori ahaba naboneke Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Te watorima nahi. Teoso tera kakatomaka. Bani biti manakone nanafi raba te amaka. Bani biti ohari ahabe ahabi Teoso watote amaka. Yama watote amaka, bani me ka yama, me nafi. Te manakone e nabone teke ahi, bani biti me tamaha me manakone nima. E tati kone oohariki na nafi Teoso watoka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","\"Owa te nofahamone te ati ni ya me nokosi ya te hiyari ya, okobi ohiyarahabana oke winahari neme ya, tera onofamone ona owa. ");
INSERT INTO jaa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Owa te nofaramone te ati ni ya me nokosi ya te hiyari ya, okobi ohiyarahabana oke winahari neme ya, tera onofarahamone ona owa\". ");
INSERT INTO jaa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","\"Oke ama oke, me abe mono ni fawa nihiba ama ora owa. Oke ama oke me abe mono ni yaro okanabone owa. ");
INSERT INTO jaa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Owehene e ka owa bati mono nebonaka. E ka one mati mono, naboneke. Hinakaso mono, naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Me abe mono naboneke, me winaha mati yobe ohari ya. ");
INSERT INTO jaa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Abi nofi mati tihi ya owa nonofa raba tinahamone tini ya, tiwa onofarahabone oke. Tika matehe nofi mati tihi ya owa nonofa raba tinahamone tini ya tiwa onofarahabone oke. ");
INSERT INTO jaa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","E fami tinofi ya tiwehene e nabone tike ahi: tika ewenebone tiwa tikanabone tike, owa tinofi ka yama nawaha hiri tinahabone tinakomehara tiwa. Tisawi tinahabone tike owa ni ya fara oko toki nima. Tiwehene e ri ya e famarabone eke. ");
INSERT INTO jaa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tiwa tikayawi ya tihababone tike. Owa tinofi ka tihabi ya tika kasomi nahabone tike\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","\"E ka owa tiwa narife ya owa narife awaka. Owa narife ya Teoso narifa naka, owa yosehari. ");
INSERT INTO jaa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Teoso ati kakamina Teoso ati kamine ka tinarife ya tika yama manakone Teoso ta nebonaka, Teoso ati kakamina ka yama manakone nima naro. E ka owa ehene amose ka tinarife ya, tika yama manakone Teoso ta nebonaka, e ka owa ehene amose ka yama manakone nima naro. ");
INSERT INTO jaa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Owa ya tataba matehe nima me na me ya otabi ka me ka fahaba ta tini ya, Teoso tiwa kakawebonaka, yama amosa ya, faha siriha ta tini ya kobo kahariharo. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sesowi he ya tataba me 12 na mera yosi ahabe ya yana tone tokomematamonaka Teoso tamine kaminebonaha me ka sitati ya, mera kanawanahari. ");
INSERT INTO jaa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yowao kateya ya foyehi Kirisito ehene tamine mitehimatamonaka. Mera yosehimatamonaka he ya tataba mati, Sesowi me aate nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","\"Efemata ama ti, kaketehibona me hinehimata? Owa ta ota noki nabana?\" me ati namaroke, Yowao ati me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sesowi ati yana nemarika. \"Te wete tokanamahi Yowao ni ya. Yama te mitaha te kaminibeya he ni ya. Yama te awa te kamina, nabone teke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Me noki awatera me noki awake waha. Me yaka ni watotera me yaka nawahineke waha. Me mese hiyatera me mese amosawahineke waha. Me warabi hawitera me warabi hawiwake waha. Me ahaba me kitama, narake waha. Me honara me ni ya hiyara amosa okominine oke. ");
INSERT INTO jaa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Owehene me awi ya owehene me nofi ya Teoso me hekatomaboneke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sesowi ati me mitaha me tokomamaroke. Me tokoma Sesowi me one hiyaremarika, me moto kawahamaha mati, Yowao tamine kaminari. \"Himataba te tokomake te awineri yama honara ya? Yama isi afe te awahabone te ati na te awine, feo kanaharo boni ihi? ");
INSERT INTO jaa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Himata yama te awahabone te ati rini? E ka owa te awahabone te ati ninihi, makari amosa akahari? Makari amosa me weye na me watakere ahi yama honara ya. Me winate me amake towisawa me ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Himata te awahabone te ati rini? Teoso ati kakamina owa te awahabone te ati ninihi? Ee, Teoso ati kakamina amaka. Yowao ehene ta amosi mati tohaka. ");
INSERT INTO jaa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Efe amaka hibati ka me hikaminehimata, yama hani ya, me ka yama hani ati e na mati ahi: 'Owati kaminebona tinokosi ya tai tohehibonaka, oyose kari. Tika hawibone namosebonaka tinokosi ya', yama hani ati ke. ");
INSERT INTO jaa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yowao Batisita amosi mati tohaka. E fanawiri ni ya me wataha me one ihi aamosa raba te me amake. Teoso ka towisawa ya me tabaha me ta me amosate me amake mata ya, me nafi. Yowao aamosa raba te amaka. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yowao yana tone ya me yana tona, narake, me one me mowa na mati, Teoso ka towisawa ka yama yana tonahabone me ati na mati. Me sawisa narake, me one me mowa nasa na mati. ");
INSERT INTO jaa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yowao watamatare ya Mowisei ati yana nematamonaka, Teoso ka towisawa kaminari. Teoso ati kakamina me hikamina, hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eria me kamina nemetemoneke, kamatehibonaha. Owati miti tinofi ya owati timitahi. Yowao amaka, Eria, one oke. ");
INSERT INTO jaa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Te narabo naha owati te mitahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","\"Himata nima e ka one me nineri? Matehe nima me nineke me nahoria mati mekato ya, me abe ha na mati, me ati e na mati ahi: ");
INSERT INTO jaa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Hohori ota hori na te sere kara teke. E abe kamoha tahi ota hiri na te ohi rihi na teke', me ati te me amake. ");
INSERT INTO jaa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yowao kakehita amaka, bao kabarari, fi fawa rihi nari. 'Rabike awaka', te ati na teke. ");
INSERT INTO jaa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Neme ka Owa kakehimari amaka, yamata nafi kabahari, fi fawa nari. 'Te awa hari, tafi nafihari, fi fawi nafi nari mata ya', te ati na te awineke. 'Yinero yayaba me ya tabaka, mera nofahari. Yama hiyara hihiri me ya taba, ka', te ati na te awineke. Owehene amosi ka yama Teoso watoka hiri onaharo. Yowao ehene amose ka yama Teoso wato, naka, hiri hinaharo. Ota ehene amosamone me nafi ati naba me amake\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Faya Sesowi mera hora nemarika, sitati ka mati, me tamaha mera kasome ka sitati. Me ihi hiyara me ihi fawa ramaroke makoni mera hora nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sesowi ati yana nemarika. \"Korasi ya te winaha te kokoriri tehaba te amake kasiro ya. Ha te Betesaita ya te winaha te kokoriri tehaba te amake kasiro ya. Teoso yama tamaha yofi kanaka kitaharo kasiro ya te ni ya, yama hiri onaha te awaha te. Tiro ka me toha, Sito ka me toha, na owehene me awehemenehe, me ihi hiyara me ihi me nofamarehenemete me amake hibati ya, makari mese kitaha me weye na mati, yifo hobokori ya me tati me mata kana mati, me yawa mati. ");
INSERT INTO jaa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Owati e nineke ahi: Teoso yama manakone nahabihibona ka amo ni kobo ne ya te kokoriri ni nafitehaba te amake. Tiro ya Sito famaha ka me kokoriri ni nanafi raba tehaba me amake haha yama ya. ");
INSERT INTO jaa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ha me te Kafanao ka me te, Teoso tera towakimisebona te ati na te awineke, neme ya. Teoso tera towakimisamareba amaka neme ya. Te tokisaba te amake e abohi taboro ya. Sotoma ka owehene me awehemenehe, me ka sitati ahabarehenemete amake. ");
INSERT INTO jaa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Owati e nineke ahi: Teoso yama manakone nahabihibona ka amo ni kobo ne ya te kokoriri ni nafitehaba te amake. Sotoma ka me ta me kokoriri ni nanafi raba tehaba me amake haha yama ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sesowi ati yana namatasehimarika. \"Abi neme Hiti ama tike. Wami Hiti tiha tite ama tike. Tiwehene amosara tike, haha yama tikehemoha tiwa, yama wawato me ni ya, haha yama me awarabone mati. Matehe fotara me ni ya yama yofi tikanara tike. ");
INSERT INTO jaa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Abi, tiwehene e na ama tike, fara yama tinofa ya tiwehene tohaha tiwa\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","\"Okobi yama nafi ta naka owa ni ya. Okobi ohari biti watote amaka. Biti fare ohari bati wato, tehi amaka. Fare biti hinamo hite amaka me ni ya, me nafi amararo. Bati yofi kani oharite amaka fara me hikatikaha me ni ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","\"Ma tihi ya tikamahi owa ni ya. Kokoriri tini ya tikama tinahi owa ni ya. Tiwa onarifibeya. ");
INSERT INTO jaa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tera okanawanabone onahara oke, e ka owa bowi nananakowa ne nima, wami ime towitawahawitiahabone ati nari. Oyaha oke. Tera hora orahabana oke. Te ati boti ya te hasi naba teke, owati ihi. ");
INSERT INTO jaa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Oko yama te ahi na nihinaboneke te ni ya\". ");
INSERT INTO jaa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabato one ya Sesowi kariwemarika fatara ya. He ya tataba me fimiha tiriko boni me bata namaroke. Me hikabamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sesowi ya tataba me ihi fariseo me awaha Sesowi me aate namaroke. \"Me ihi tiwa ha, tika tataba mati. Sabato ya yama e na e hiri tera amake ahi\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sesowi ati yana nemarika. \"Yama hani te awaterani te ama, Tafi tamine kaminaro? Tafi he ya tataba me ya tabehi me fimiha ");
INSERT INTO jaa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tafi tokiyomehimatamonaka Teoso ka yobe ya. Teoso ka bao me kabehemetemoneke. Bao hehi e kabatere amaka. Sasetoti me ta me hikabate amaka. ");
INSERT INTO jaa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mowisei ka yama hani te awaterani te awine, sabato kaminaro? Sabato ya sasetoti yama me ahi te me amake, teboro toro ya, yama hiyara me hiri ra mati. ");
INSERT INTO jaa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Owati e nineke ahi: Teoso ati yati amosi mati tohaka. Teboro ka yama aamosa raba te amake. ");
INSERT INTO jaa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Teoso ati e nematamonaka ahi: 'Owa ni ya yama kahi te ta nabone te ati na yama onofa okere. Yama onofa oke haro, me one te narifibone karo', Teoso ati nematamonaka. Teoso ati te wato ya te ati watarene te amake, owa ya tataba yama hiyara me hiri namone te ati na te. ");
INSERT INTO jaa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Neme ka Owa sabato Hiti tohate amaka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yana tone tokiyomehimarika me ka sinakoka ya. ");
INSERT INTO jaa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Me ka owa sawihimarika, mano kamo namahari. Sesowi me aate namaroke. \"E abe kasomatehani ama, sabato ya?\" me ati namaroke. Me ka owa nakitame ya ehene me hikaminebona me hinehimatamonaka me one ni ya, sabato ya yama ahi nemona me hinahari, ehene hiyaremona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sesowi ati yana nemarika. \"Tika ofeya hoti ya sone ya sabato ya titimakehiba awaka hoti ya. ");
INSERT INTO jaa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ofeya manakone nafitere amaka. E ka owa ta manakone nafite amaka. Makoni e ka one me e narifabone eke sabato ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Me ka owa hiyaremarika. \"Timano yai tinihahi\". Mano yai tonihemarika. Mano amosawahamemarika, fara one nima naro. ");
INSERT INTO jaa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseo me tokomamaroke. Heoniao me hiri nemetemoneke, me abe hiyarabone mati. Sesowi ino me hiri nemetemoneke, me hinabowebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sesowi fariseo me ati watohimatamonaka, me hinabowehibona me hinahari. Makoni tokomemarika. Me tamaha me ya tabehimarika. Mera kasomemarika, me nafi. ");
INSERT INTO jaa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Me narabi nima nemarika, ehene me hiwehi ehene me hikaminarebonaha me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Fare Isaiya Teoso ati kakamina atimatamona nima yama namaroke, Teoso ati kaminari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"Oko nanarifa tiwahi, owasiari. Onofareka kasiro ya owati boti ya. Oko Kanamori sawihabone oke he ni ya oyoseharo. Bara mera hiyarebonaka, ati e nari ahi: 'Teoso mera kasomebonaka hibayata ya', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Me ni ya ati kitarebonaka. Mera mono rihi nebonaka. Ati me himitarehibonaka howa ya. ");
INSERT INTO jaa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Me kitara me ni ya yahehibonaka. Yama isi kekero toraba na baka nakosarebonaka. Nabarina owinima na nawirihi nebonaka. Mera kasomebonaka, me kitara mati. ");
INSERT INTO jaa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bara me ati e naba me amake ahi: 'Era kasomeba amaka', me ati naba me amake, Isaiya ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Me ka owa me kakiamaroke Sesowi ni ya, inamati ehene noko awaterari, ati yana rihi tehari, inamati ehene. Sesowi hikasomehimarika. Manakobisa ati yana, yama awa, nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sesowi ya me tabaha \"Hika\", me ati namaroke. \"Efe amare, Tafi ka notibonamatamonaha?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo Sesowi ehene tamine me mitaha me ati yana nemetemoneke. \"Me inamati toyosemahareka, fare Beosebo ati ehene, inamati me ka towisawa, Teoso ati ehene amarari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sesowi me ati boti watohi mera hiyaremarika. \"Fara e abe mowa ni ya e ahababone eke. Sitati ka me abe mowa ni ya me ahaba naboneke, me nafi. Yobe ohari ka me winaha me abe mono ni ya, me ahaba naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanaisi fara me one toyoseme ya, Satanaisi me abe mono na me awineke. Me ahababa me awineke. ");
INSERT INTO jaa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Me inamati oyosemahamone te ati na te awineke, Beosebo ati ehene. Manakobisa te ka tataba inamati me me toyosema Beosebo ati ehene ama? Beosebo ati ehene amare awaka. Yama hiri ona Beosebo ati ehene amakara bisa. ");
INSERT INTO jaa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hinamati me oyosemine oke Teoso Kanamori ati ehene. Faya Teoso ka towisawa kobo nareka ahi. ");
INSERT INTO jaa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","E ka owa nima one oke, tokiyomahari owa ka yobe ya, hinaka yama hibotiabonehe. Yobe hiti kitehi wete nareka. Yobe hiti kitehi wete re ya yobe hiti ka yama botirebonaka. E ote ama oke bisa ahi. Satanaisi wete onahara oke, me okasomahabone owa, me rabika mati. ");
INSERT INTO jaa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Owa ni ya tisawiri ya owa tinofara tiwa awine tike. Tiriko boni e bata na e famari ya tiriko boni mata tikawite tiwa awine tike. ");
INSERT INTO jaa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Owati e nara oke ahi: Teoso yama hiyara nafi fawa nite amaka. Yama hiyara oharia ta Teoso fawa nirebonaka. Teoso Kanamori yama hiyara hiri nemona tini ya tika yama hiyara Teoso fawa nirebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Neme ka Owa tinofaramone tini ya tika yama hiyara Teoso fawa nibonaka. Teoso Kanamori ta tinofaramone tini ya tika yama hiyara Teoso fawa nirebonaka. Hibayata ya tika yama hiyara fawa nirihi, amo ni kobo ne ya tika yama hiyara fawa nirihi nebonaka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","\"Awa amosa boni amosate amake. Awa hiyara boni hiyatera amake. Awa boni e awi ya awa e watohabone eke. ");
INSERT INTO jaa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ha te maka biti me te amake. Yama amosa kamini te watokere, te hiyara te. Yama hiyara te kaminate te amake, te ati boti hiyara te. ");
INSERT INTO jaa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","E ka owa amose yama amosa kaminate amaka, ati boti amosari. E ka owa hiyare yama hiyara kaminate amaka, ati boti hiyarari. ");
INSERT INTO jaa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Owati e nineke ahi: Tiwati yana na tiwa tekatomahi. Yama hiyara tikamini ya yama manakone tinahabihaba ama tike, Teoso amo ni tohe ya, yama manakone nahabihibona ka amo ni. ");
INSERT INTO jaa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tiwati amosa hiri tini ya titaminamone Teoso ati neba amaka. Tiwati hiyara hiri tini ya tihiyaramone Teoso ati neba amaka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mowisei ati kakamina fariseo me ya me taba me one Sesowi aate namaroke. \"Ota ka borofeso ota ka yamaba tinamohi Teoso ka yama\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sesowi ati yana nemarika. \"Teoso ka yama te awahabone te ati nineke, te hiyari karo, Teoso te nofari karo. Hine ya Teoso ka yama oharia te awahaba teke, yama Yona hiri hinemete nima naro, Yona Teoso ati kakamina. ");
INSERT INTO jaa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona ehenematamona nima Neme ka Owa ehene nebonaka. Yona amo ni terei nematamonaka aba ehebote nabati ya foyahari. Neme ka Owa amo ni terei nebonaka wami boti ya sawihari. ");
INSERT INTO jaa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninifi ka me toha, naba me amake. Te ehene hiyaramone me ati, naba me amake afa yama ya, Teoso nokosi ya. Me ni ya Yona Teoso ati kamine me ihi hiyara me nofamarehemetemoneke. Yona yama wawato raba nematamonaka. Ha owa ta yama wato mati ohaha owati kamiti te nofarineke. ");
INSERT INTO jaa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yama toyabo ya Teoso yama nafi manakone nahabi ya towisawa fana Saromao yaka nemete te ya tabahaboneke. Te ehene hiyaramone ati naboneke, ihi nima te ehene ra te. Kakehemetemoneke yama yabo ya Saromao ati mitahabonehe Saromao yama wato kari. Ha owa ta yama wato mati ohaha owati kamiti te nofakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","\"E ka owa ni ya inamati sawihi inamati tokome ya faha watari ka yama ya kariwate amaka, taborobona siba nari, taborobona wasirari. ");
INSERT INTO jaa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ati e nebonaka ahi: 'Wete onamabana oke fara osawi ka yobe ya', ati nebonaka. Wete name yobe wasimebonaka, hinita tohahari, amosari, me yowi hiwahari, me hinamosamari. ");
INSERT INTO jaa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Me 7 na mera ha nebonaka, me hiyari mati tohaha mati, me ya tabawehibonaha fahi, me winaha mati. E ka owa ka yama nawaha kitamisahaboneke waha, inamati me ihi. Hahi nima te nabone teke, yama hiyara te hiri na te\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sesowi mera hiyare ni ya mati nisori mati me na me kamakiemetemoneke. Yobe beheri ya me nahobasahamaroke, Sesowi ino me hiri na mati, me hihiyarehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Me ka owa ha hinehimarika. \"Sesowi ami niso me na me nahobasaharake yobe beheri ya, tiwa me hiyarabone me ati na mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sesowi aate hinehimarika. \"Hibaka okomi? Hibake okaniso?\" ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mera yofi kanehimarika he ya tataba mati yehe ya. \"Me te awa haro. Okomi nima me nineke. Okaniso me nima, me nineke. ");
INSERT INTO jaa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Okaniso toha, okasima toha, okomi toha, na nima me nineke, e ka one mati, okobi neme ya winehi yama hinofa me hiri na mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Afa yama wehe ya, Sesowi yana tonehimarika yobe ya. Tokomakehi itabasehimarika rako witi ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Me tamaha me kakeha me ihi tofoyawiti itarimarika kanawa tori ya. Me one nahobasahamaroke faha witi ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mera kanawanehimarika yama tamaha ya, hiyara kaminari. \"Owati te kamitahi. E ka owa tokehimatamonaka yama noki koro nebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yama noki were kane noki one kasohemetemoneke hawi beheri ya. Bani biti me kakeha yama noki me kabehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yama noki one kasohemetemoneke wami yati kihaha mese ya. Wami bayiri ka tiriko yani kerewe remetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Manakobisa bahi kamaki ehene tiriko waya tokanemetemoneke, habi fotari karo. ");
INSERT INTO jaa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yama noki one kasohemetemoneke atiwa baikani ya. Atiwa yanehi ehene tiriko yani watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wami amosa ya yama noki one kasoha yanaha bonohemetemoneke. Noki oharia koro na boni 100 toha, noki one ka boni 60 toha, noki one ka boni 30 toha nemetemoneke, hiyabamatehabana. ");
INSERT INTO jaa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Te warabo naha owati te mitahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","He ya tataba me kamahamaroke he ni ya, he me aate nabone mati. \"Himataba hiyara tikaminine tiri me ni ya?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sesowi ati yana nemarika. \"Me ka hiyarabone okominine oke, owati miti yokana me toharabone mati. Teoso ka towisawa ka yama wato yokana te tohahabone Teoso ati nareka, ha te ta. Teoso ka towisawa ka yama wato yokana me toharabone Teoso ati nareka, me one. ");
INSERT INTO jaa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","E ka owa yama kihe ya hinaka yamabone Teoso ta hinamakehaboneke. Manakobote hinaka yama tamawahaboneke. Hahi e ka owa yama kihare hinaka yama Teoso hiyabamakiaboneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Makoni me ka hiyarabone okominine oke. Me noki awaha yama awi yokana me tohakere. Me warabi hawiha yama me mitakere, Teoso ati miti yokana me tohara mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiya me tamine kaminematamonaka ahi: 'Yama te mitaha te watoraba te amake. Yama te awaha te watorihi, naba te awineke. ");
INSERT INTO jaa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te ati boti yama watorihi, te narabo naha yama miti yokana te toharihi, te noko amo kana nineke. Te noko yama awi ya te narabo yama mita, te ati boti yama wato ni ya te ehene hiyara te nofamarehene te amake. Te ehene hiyara te nofamari ya tera okasomehene ama oke', Isaiya ati nematamonaka, Teoso ati kaminari. ");
INSERT INTO jaa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Teoso tera nofaka, ha te ta. Yama awi yokana te toha, yama miti yokana te toha, nineke. ");
INSERT INTO jaa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Me tamehemetemoneke, Teoso ati kakamina me toha, yama amosa hihiri me toha, na mati, yama te awaha me awahabone me ati na yama me awara mati. Haha yama te mitaha me mitahabone me ati na yama me mitaremetemoneke. Keye amakere\". ");
INSERT INTO jaa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","\"Owati te kamitamatahi. E ka owa tamine okominahabone oke, tiriko koro nematamonaha, te watohabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tiriko noki one kasohemetemoneke hawi beheri ya. E ka one me nima nineke, Teoso ka towisawa tamine me mita mati, Teoso hikaminahari, Teoso ati me watora mati, Satanaisi Teoso ati totimake kari me ati boti ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yama noki one kasohemetemoneke wami yati kihaha mese ya. Afa nima me nineke, Teoso ati me mitaha ati nofi me kerewe ri karo, me yayai na mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tiriko habi watara nima me nineke, Teoso ati me nofamara mati. Teoso ati me nofaha me one me me hinofamara Teoso ati nofi me fawa te me amake. Yama nawaha me hiri na Teoso ati nofi me fawa, te me amake, me one. ");
INSERT INTO jaa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Atiwa baikani ya yama noki one kasohemetemoneke. Afa nima me nineke, Teoso ati me mitaha yama amosa me hiri ra mati, yama tamaha me nofa mati, yinero tamehi me nofa, na mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yama noki one wami amosa ya kasohemetemoneke. Afa nima me nineke, Teoso ati me mitaha mati, me ihi amosa mati, Teoso ati wato yokana me tohaha mati. Owa ehene manakone 100 toha, owa ehene manakone 60 toha, owa ehene manakone 30 toha, naka, amosari\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sesowi hiyara one kaminemarika tasa me ni ya. \"E ka owa hinaka fatara ya tiriko noki amosa koro ne nima Teoso ka towisawa tamine naka. ");
INSERT INTO jaa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","E ka owa tiriko koro ne amo ne ya he me nofara me kakeha yama noki bara me koro nemetemoneke, tiriko baikani ya. Faya me tokomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tiriko yanaha fotawaha bonohemetemoneke. Yama kabani yana, nemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","\"Yobe hiti ka yama aahi me aate hinehimatamonaka. 'Bataro, yama noki amosa koro tirinihi tika fatara ya? Himataba yama kabani yana nineri?' me ati nemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","\"Ati yana nematamonaka. 'Owa me nofara me ihi tohaha me awineke', ati nematamonaka\". \"'Ota kanamosibana?' me ati nemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","\"'Te kanamosarabanake. Yama kabani mohi te bore ni ya tiriko ahabariyahi. ");
INSERT INTO jaa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiriko hine yanake yama kabani ya tabaharo. Manakobisa hati ya me oyosehabana oke, tiriko me bata naba mati. Owati e nabana oke ahi: Yama kabani te tai tonihahi. Te soki naki ya te sari kanahabanake. Manakobote tiriko te bata ni ya tiriko te tonihabone teke tiriko totoniha ka yobe ya', ati nematamonaka\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sesowi hiyara one kaminatasehimarika me ni ya. \"Mositata noki nima Teoso ka towisawa kaki te amaka. E ka owa mositata noki koro nematamonaka hinaka fatara ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mositata noki iisi kabote na yanate amake. Yanawahi ya awa tohate amake. Fatara ka yama one ta fotakere. Mositata yanaha ini ya bani biti me winate me amake\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hiyara one kaminemarika tasa. \"Teoso ka towisawa kaki e te amaka fehemeto fanawi hinatabaha nima, tiriko ya, tiriko fowamisarawaharo, nafi, tiriko nafiharo, 30 kiro tohaharo\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sesowi hiyara kamini oharimarika me ni ya, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Teoso ati kakamina fara meteba mera kaminematamonaka, Teoso ati kaminari, ati e nari ahi: \"Hiyara okomina okibone. Haha yama me hiwatotera okominaboneke, Teoso hikehemoharo\", Teoso ati kakamina ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sesowi mera toyosememarika, me tamaha mati, me tokomabone mati. Wete namehimarika fare hinaka yobe ya. He ya tataba me aate hinehimarika. \"Yama kabani ka hiyara ya otara tikanawanahi, ota wato forima nabonehe\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sesowi ati yana nemarika. \"E ka owa tiriko noki amosa koro nematamonaka. Efemata nima Neme ka Owa naka. ");
INSERT INTO jaa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","E ka owa ka fataramete nima, me nineke, me nafi. Tiriko noki nima me nineke, Teoso ka towisawa ka mati. Yama kabani nima me nineke, Satanaisi ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","E ka owa me nofari ka yama noki bara me koro nemetemoneke. Afa me nima Satanaisi naka. Tiriko me bata ni ka yama nima Teoso amo ni naka. Tiriko me bata na me nima me nineke, Teoso nanarifa mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yama kabani mohi me bore nemetemoneke, me sari hikanabonehe. Afa nima, yama tehaboneke Teoso amo ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neme ka Owa hinaka nanarifa mera yosehibonaka, me me yabahabone mati, yama hiyara me hiri na mati, fare hinaka me ni ya me sawiha mati. Me me hiyaba hinahaboneke, me yoyose mati, yama hiyara me hiri nabone me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Me me were hiwitiaboneke yifo hiwe kitaha ya. Me ohi tehaboneke, me ini yiki tokana mati. ");
INSERT INTO jaa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yama amosa hihiri me ta me oye kitatehaboneke, bahi oyene nima naro, me sawiha mati me ka abi taboro ya. Te narabo naha owati te mitahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","\"Teoso ka towisawa kaki e te amaka, yinero nafihi nima, me hikehemobahari wami boti ya. E ka owa yinero wasihimatamonaka. Hikamomematamonaka tasa. Yayai ne hinaka yama nafi ta nematamonaka, yinero manakonebonaha. Yinero tama ne wami kote kanikematamonaka, fare yinero kamo ka wami\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","\"Teoso ka towisawa kaki e te amaka ahi, e ka owa nima, berora amosa kakanika tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yama we one ya berora wasihimatamonaka amosaro mata ya. Hinaka yama nafi ta nematamonaka berora kanikebonaha, amosaro mata ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","\"Teoso ka towisawa kaki e te amaka tahafa nima. Tahafa me koro nifeha aba me yoro tokana me me nawasiemetemoneke. Me me horo hikanake ");
INSERT INTO jaa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tahafa mo kanehemetemoneke. Me me horo hikamisehemetemoneke faha witi ka siki ya. Me nahorisa aba me amosa me me te nemetemoneke yama wiye ya. Aba me hiyara me me were towiti nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Afa yama nima yama tehaba amake, Teoso amo ni karo. Teoso nanarifa me me yabatehaboneke, me ihi hiyara mati, me ihi amosa me baikani ya. ");
INSERT INTO jaa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Me me were hitehaboneke yifo hiwe kitaha ya. Me ohi tehaba me amake, me ini yiki tokana mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","\"Owati nafi te watoha te awine?\" ati nemarika. \"Ee, tiwati nafi ota watoha otake\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","\"E ka owa Mowisei ati kakamina tohe Teoso ka towisawa nonofa tohawe ya e ka owa yama kihe ehene nima ehene nebonaka, yama manakone amosa kihahari, yama yati yama bote ya tabaharo\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sesowi hiyara kamini ahabe ya tokomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kobo tonamemarika fara hinaka sitati ya. Mera kanawanehimarika sinakoka ya. He ati me mitaha \"Hika\", me ati namaroke. \"Hibake hikanawanatehino amara, yama nafi watohari, mera kasoma nari? ");
INSERT INTO jaa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Awa hihiri biti amare? Mati amarini, Maria? Nisori me amarini, Tiako, Yose, Simao, Yota me na mati? ");
INSERT INTO jaa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hinakasima sawi nofarawara ama e ni ya, nafirawaha? Himataba yama nafi watora?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sesowi ati me nofaramaroke. Sesowi ati yana nemarika. \"Teoso ati kakamina ati me hinofate amaka, tabora bara ka mati. Ati me hinofatere amaka, fare taboro ka mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ati me hinofare me tamara mera kasomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Eroti me ka tetaraka tohe Sesowi tamine mitehimatamonaka, afa yama ya. ");
INSERT INTO jaa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","He nanarifa mera aate nematamonaka. \"Yowao Batisita amare, kitamenoho? Makoni yama watohi awaka mata ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yowao ahabibehimatamonaka Eroti ati ehene. Eroti ati ehene Yowao me hiwate me wete hine me hibehimatamonaka kateya ya. Ehene e nematamonaka Erotia hiyosehari, fare fati. Taiti ya Eroti anoti Firibi tohehi fatimetemoneke, Erotia. Erotia Firibi kakosaha Eroti itiwemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yowao ati e nematamonaka ahi. \"Eroti yama hiyara hiri tine tike, Erotia titiwaha tiwa\", ati nematamonaka. Makoni hibehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroti Yowao nabowehibona ati nematamonaka. Nabowi hinofarehimatamonaka mata, me tamaha me hinofe kari. Yowao Teoso ati kakaminamona me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yama wehe one ya Eroti ayaka hiri nematamonaka, hinaka anifesario. Ayaka ya Erotia bite ayakemetemoneke me nokosi ya. Eroti hinofemetemoneke, toki amosaro. ");
INSERT INTO jaa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ati yana nematamonaka, hinaka yamabone ta hinahabonehe, fara yama hinofaro. \"Keye amakere. Teoso owati mitaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mati hiyoseha ati e nemetemoneke ahi: \"Yowao Batisita tati ta tinahabone tike owa ni ya, barato ehebote tori ya tati foyahari\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eroti Yowao ahabi nofare mera yosehimatamonaka, Yowao me nabowahabone mati, keye hiri nemona me hirabona karo. Ayaka ka me nafi tohaha ati me himitematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ati ehene Yowao me nabowehemetemoneke kateya tori ya, tati me ti hisahari. ");
INSERT INTO jaa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tati me hekamehimatamonaka, barato ehebote tori ya tati itarihari. Tati me ta hikanamehimatamonaka atona ni ya. Mati ni ya tati ta hikanamehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yowao ya tataba abohi me hekamehimatamonaka, me hikamobonaha. Sesowi ni ya me tokoma Yowao tamine me kaminamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sesowi me ati mite tofoyawitimarika kanawa ya. Towakamehimarika ohariari yama honari ya. Sitati one ka tamine me himite me hinakamakimatamonaka, me yaka na mati, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sesowi kanawa ya foyehi kisehi me tamaha mera awehimarika. Mera aawawa ne ka me one yama kome awaha mera kasomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bahi toke ya he ya tataba me aate hinehimarika. \"Sesowi tabora watakere ahi. Bahi tokaka. Me tiyosemahi, me tafeba me kanikaba mati tabora ya\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sesowi ati yana nemarika. \"Me tokomarahabanake. Me tafeba te ta nahi fara me te\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","\"E ka yamata tamamakere. Bao 5 toha, aba me fama, narake\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","\"Yamata owa te kakawahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sesowi mera yosehimarika, me naorisahabone mati masiri mese ya. Bao 5 ne wara tokanemarika. Aba me fama na mera wara tokane neme awehi ati yana nemarika, \"Teoso faya amake\", ati nari. Bao ebe ne he ya tataba mera kakawemarika, he ya tataba me ta hinehibonaha me one ni ya, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Me nafi tafaha me akaramaroke. Yamata isi ni hasi na me kayabamaroke. Isiri 12 namaroke, mo naro. ");
INSERT INTO jaa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Me makiti 5000 me tohahamaroke, me tafaha mati. Me fanawi toha, matehe toha, namaroke, me tafaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hibati ya Sesowi he ya tataba mera yosehimarika, me kibehabone mati kanawa ya, me tai toamabone mati kowani ya. Towitakosebona ati nemarika, mera toyosemahari. ");
INSERT INTO jaa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mera toyosemi hawa tohe ya tokomisehimatamonaka atami ya, ohariari, Teoso hiyarebonaha. Bahi tokinima ne ya wasa nematamonaka neme ya, ohariari. ");
INSERT INTO jaa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kanawa tohahamaroke faha baikani ya. Boni kitaha kakeha kanawa wasihamaroke. Faha reko ni kitaha kanawa banahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yama sirimaki ya Sesowi kamakimarika yaka nari faha baki ya. ");
INSERT INTO jaa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Me hiwehimarika yaka nari. Yaka ne me hiwehi me ha namaroke, me kakomeha mati. \"Hinamati amare?\" me ati namaroke, me kokoriri na mati. ");
INSERT INTO jaa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sesowi ati yana nibote nemarika. \"Te kokoriri rima nahi. Owa amake. Te watorima nahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Betiro ati yana nemarika. \"Ota ka Hiti afa tiwa yokana ama? Tiwa yokana tohi ya owa tiyosehi, yaka onahaba owa, okibeya tiwa ni ya faha baki ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","\"Tikehi\", Sesowi ati nemarika. Betiro kanawa tori ya kisehi yaka nemarika faha baki ya, tokomakebonaha Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Boni kitaha awe kokoriri ne tokisinima ne ha nemarika. \"Sesowi owa tikasomahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sesowi hitimisehimarika hibati ya. \"Himataba Teoso wati tiwaharine tiri? Tiwati boti ya tiwati e nene amake ahi: 'Teoso owa narifebonaka', tinehene ama tike\". ");
INSERT INTO jaa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Me te tonami ya boni fawa nisahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Haha kanawa tori ya me kibeha me mowi kanisamaroke Sesowi nokosi ya. \"Teoso biti ama tike. Keye amakere\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Me kariwaha me kobo namaroke Senisare ka wami ya. ");
INSERT INTO jaa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Haha Sesowi me awaha Sesowi me watohamaroke. Sesowi tamine me kaminemetemoneke tabora yabora ka me ni ya, tabora nafi. Tamine me himite me me kakiamaroke, me kiya na mati, me nafi, Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sesowi me aate namaroke, hine ya hinaka makari tati boni me boyo hinahabonehe. Hinaka makari me boyo hina ihi me kitamamaroke, me nafi. ");
INSERT INTO jaa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseo Mowisei ati kakamina me ya me taba Sesowi me aate namaroke, Serosarei ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"Tiwa ya tataba yama hiyara me hiri narake, yama me hiri ra mati, e ka iti me hikaminehemete, me yehe me soko ra mati, me tafiba ya. Himataba me ihi e nineri ahi?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sesowi ati yana nemarika. \"Yama hiyara te hiri nabisa teke bisa, te ka iti me ati nima te ehene na te, Teoso yama hinofara te hiri na te. ");
INSERT INTO jaa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Teoso ati e nematamonaka ahi: 'Abi tinofa, ami tinofa, tinahabone tike', ati nematamonaka. Ati owa e nematamonaka ahi: 'E ka owa bati ni ya ati hiyara hiri ne ya te naboweba amaka. Mati ni ya ati hiyare hiri, ne ya te nabowa neba amaka', ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yama bara te kaminineke, Teoso ati nima raro, te ati e na te ahi: 'Teoso ka yamabone ta tinahabone tinaha afa yama ta tinamarahabone tike abi ya ami me famaha me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Abi ya ami me famaha me tinofamarabone tike', te ati nineke. Teoso ati te nahabineke, te ka iti me ati te nofi karo. ");
INSERT INTO jaa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Te ati boti hiyakere. Isaiya keye hiri remata awaka, tera kaminari, ati e nari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Owa me nofahamone me ati na owa me nofakere me ati boti ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Owa me kahiyara kene. Me one me me kanawanate me amake fara me ati ya, owati amararo', Isaiya ati nematamonaka, Teoso ati kaminari\". ");
INSERT INTO jaa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sesowi me one ha nemarika, me tamaha mati, me hihiyarahabone mati. \"Owati te kamita. Owati te watohi. ");
INSERT INTO jaa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yamata e inohoti ya e kabaha era tonahiyaraboneke Teoso ni ya. Teoso ni ya e tohiyate amake, e ati hiyara e hiri naro e inohoti ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","He ya tataba me aate hinehimarika. \"Fariseo tiwati me mitaha tiwa me kakoarake. Me tiwatorini?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sesowi ati yana nemarika. \"Fatara ka yama okobi koro hiraha bore hinaboneke, were hiwitiabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hine me hamake. Me noki awakere, me one noki awara me me towakama mati hawi ya. Noko aware owa hawi ya towakame ya me fami kasohaboneke hoti ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Betiro ati yana nemarika. \"Hiyara tikaminaha tikaminamatasahi. Tiwati wato yokana ota tohibeya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","\"Owati wato yokana te toharini mata? ");
INSERT INTO jaa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E tafi ya yamata e inohoti ya e kabaha e nabati ya tokisa e mi nisate amake, sawimarahabonehe e toro ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","E ati hiyara e inohoti ya e hiri na kakete amake e ati boti ya. E ati hiyara e tohiyate amake Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yama hiyara tamaha kakete amake e ati boti ya. Yama hiyara e wati nawahate e amake e ati boti ya. E ka owa nabowi e nofa, e ka owa fati yori ni e nofa, e ka yibote amara yori ni e nofa, e ka owa ka yama boti e nofa, keye hiri ni e nofa, Teoso hiyaremona e ati, te e amake e ati boti ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Haha yama e hiri na e tohiyate amake Teoso ni ya. E yehe e soko ra e tafi ya e tohiyarabone eke Teoso ni ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sesowi tokomemarika Tiro yabori ya, Sito ya famaharo. ");
INSERT INTO jaa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanaha ka me ka fanawiri afa tabora ya winaha kamakiamaroke Sesowi ni ya, he ha naro. \"Ota ka Hiti, Tafi ka noti, owa tikasomahi. Okoto hiyarara oni hinamati ehene\", ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sesowi ati wataremarika. He ya tataba me aate hinehimarika. \"Tiyosemahi, tokomabana, tiwa ha ni fawa rabana\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sesowi ati yana nemarika. \"Bara me ni ya okobi owa yoserare oke. Okobi owa yosehare oke Ihayeo me ka ofeya me okasomahabone owa, me tosawariha mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sonarisamaroke he nokosi ya. \"Oko Hiti owa tikasomahi\", ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","\"Matehe tafe e were kariyahi yome me ni ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","\"Keye amakere oko Hiti. Yamata homokori yome me kabate me amake foro naro mesa bofe ya, me ka hiti me tafaha mati\", ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","\"Fanawi Teoso tinofa tike mata ya, tiwati boti e na tiwa ahi, 'Teoso kitate amaka. Owa kasomebonaka', tina tiwa awine tike tiwati boti ya. Fara tiwati nima yama naboneke tiwa ni ya\", Sesowi ati nemarika. Bite amosamehemetemoneke fare bahi ya. ");
INSERT INTO jaa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sesowi tokomatasehi wete tonamemarika Karireya ka faha witi ya. Yati nemeha mese ya tokomisehi itarimarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Me tamaha me kamakiamaroke he ni ya, me kiya na me me kakia mati, me yaka ra me toha, me noki awara me toha, me mani hiyara me toha, me ati yana ni watora me toha, me one tamaha me toha, na mati. Me kiya na me me hinanahohamaroke Sesowi beheri ya, me hikasomahabone mati. Mera kasome ");
INSERT INTO jaa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","\"Hika\", me one ati namaroke, me kiya na me amosamaha me me awaha mati. Me ati yana ni watora me ati yana, me mani hiyara me mani amosawaha, me yaka ra me yaka, me noki awara me noki awawaha, namaroke. Ihayeo me ka Teoso me kahiyarahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sesowi he ya tataba mera ha nemarika, mera hiyarebonaha. \"Me aawawa oke. Me amo ni 3 ke, owa ni ya me sawiha mati. Me tafe watakere. Me fimiha me toyosemi onofa okere. Me kitaraboneke, hawi ya me yaka na mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","\"Tabora watakere ahi. Hika ya bao e kanikaribe, me hikabebana? Me tamake\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","\"Te ka bao e ra?\" ati nemarika. \"Bao 7 ka. Aba me tamarihi\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mera yosehimarika, me nahorisahabone mati bofe ya, me nafi. ");
INSERT INTO jaa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bao 7 ne wara tokana, aba mera wara tokana, ne \"Faya amake\", ati nemarika Teoso ni ya. Yamata ebe ne he ya tataba mera kakawemarika, me one ni ya me ta hinahabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Me nafi tafaha me akaramaroke. Yamata isi ni hasi na ka isiri 7 namaroke, mo naro. ");
INSERT INTO jaa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Me makiti 4000 me tohahamaroke, me tafa mati. Me fanawi toha, matehe toha namaroke, me tafaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sesowi mera toyosememarika. Kanawa ya tofoyawiti towakame kobo tonamemarika Makata ya. ");
INSERT INTO jaa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo satoseo me na me kamakiamaroke Sesowi ni ya, Sesowi me totomi nabone me ati na mati. Yama namohibona me hinehimarika, Teoso ka yama. ");
INSERT INTO jaa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sesowi ati yana nemarika. \"Bai toke ya neme mawa tona te awaha te ati e teha amake ahi: 'Yama wamini ya yama amosaba amake', te ati teha te amake. ");
INSERT INTO jaa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Neme mawa tonamina te awaha te ati e te te amake ahi: 'Yama noki yawa kanikimake. Yama hiyaraba amake', te ati te te amake. Neme te awi ya yama yana tonahaba te watoteha te awineke. Himataba Teoso yama hiri hinahaba te watotera te amari? ");
INSERT INTO jaa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yama awi te nofa te awineke Teoso ka yama. Yama te awaraboneke Teoso ka yama, te ati boti hiyara te, Teoso te nofara te. Hine ya Teoso ka yama oharia te awahaba teke, yama Yona hiri hinemete nima naro\", Sesowi ati nemarika. Sesowi tokomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sesowi me kobo kanamaroke wara kowani ya. Sesowi ya tataba me ati katamoemeteke bao ya. ");
INSERT INTO jaa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sesowi ati yana nemarika. \"Tera te kakatomahi, fariseo satoseo me na me ka fehemeto ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sesowi ya tataba me abe hiyaramaroke. \"Himataba ati e nara ahi, fehemeto kaminari? Ati e ne awaka ahi: Bao watare ehene ati tohe awaka\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Me abe hiyarani Sesowi me ati watohimatamonaka. \"Himataba te ati e nineri, bao ino te hiri na te? Yama te watora te awineke, Teoso era kakatomabona karo. ");
INSERT INTO jaa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Te ati katamoa te awine, bao 5 ne 5 mio me tohaha me hikabari? Te ati katamoa te awine, isiri tamaha mo na ya, yamata hasi na ihi? Haha yama te watomatakere. ");
INSERT INTO jaa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te ati katamoa te awine, bao 7 ne 4 mio me tohaha me hikabari? Te ati katamoa te awine, isiri tamaha mo na ya, yamata hasi na ihi? Haha yama te watomatarihi ke. ");
INSERT INTO jaa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Owati te watora te awineke. Bao tamine amare okominahara oke. Tera te kakatomahi fariseo satoseo me na me ka fehemeto ya, onahara oke\". ");
INSERT INTO jaa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yama me watowahamaroke, Sesowi hikaminaharo waha. Bao ka fehemeto kaminarehimataka. Fariseo satoseo me na me ati ya hine me kakatomabone ati nemataka he ya tataba mati. ");
INSERT INTO jaa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sesowi kobo nemarika sitati Firibi ka Sesareya yabori ya. He ya tataba mera aate nemarika. \"Hibake Neme ka Owa tohehimona me one ati nineri?\" Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","\"Yowao Batisitamona me one tiwa ati narake. Eriamona me one tiwa ati, Seremiamona me one tiwa ati, Teoso ati kakamina me ka owamona me one tiwa ati, narake\", me ati namaroke, Sesowi ya tataba mati. ");
INSERT INTO jaa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","\"Hibakemona owa te ati ri, ha te?\" ati nemarika, mera aate nari. ");
INSERT INTO jaa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simao Betiro ati yana nemarika. \"Kirisito ama tike ha tiwa. Teoso yati tohehi biti ama tike ha tiwa\", Betiro ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","\"Simao Yona biti Teoso tiwa nofe awaka. Afa yama tikamina me ati ihi amakere. Okobi neme ya winehi ati ehene amaka. ");
INSERT INTO jaa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Betiro ama tike. Yati ini weye tine tike. Afa yama tikamina yati ehebote nima te amake. Yobe hiri onahabana oke afa yati mese ya. Hahi yobe oko me tohatehaboneke, me ahabateraba mati. ");
INSERT INTO jaa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Teoso ka towisawa ka safi ta onahabone oke tiwa ni ya. Tiwati hiyari ya Teoso ati hiyabisareba amaka. Tiwati amosi ya Teoso ati amosabisebonaka\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sesowi me kaminarahabone Sesowi ati nemarika Kirisito tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sesowi he ya tataba mera hiyarawahematamonaka, yama hiri hinahaba kamini yana tonahari. Tokomebona ati nemarika Serosarei ya. Me ka hiti me toha, sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, na me hikatomebona ati nemarika Serosarei ya. Me one hinabowehibona ati nemarika. Ahabe amo ni fame ya wamisamebona ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Betiro ya Sesowi me fami ohariabone Betiro ati nemarika, ati himitebonaha. Betiro Sesowi hora nematamonaka. \"Teoso tiwa kasomeba awaka. Haha yama tikaminaha nima tirahabone tike\", Betiro hora ni ati nematamonaka, Sesowi ahabi nofarari. ");
INSERT INTO jaa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Betiro ati Sesowi mitehi ki nawahame ati yana nematamonaka. \"Satanaisi tiyotowamahi onowati ka ya. Yama hiyara hiri onahabone tine tike, Teoso ati amare tikamina tiwa. Fara tiwati amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sesowi he ya tataba mera hiyaremarika. \"E tabibone te ati nine? Fara yama tinofa hiri tirahabone tike. E famahabone tina tika ewenebone tiwa tikanabone tike, tihabibone ka awa. ");
INSERT INTO jaa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tiwa tikayawi ya tihababone tike. Owa tinofi ka tihabi ya tika kasomi nahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yama amosaba ama, tika kanamori fawa ni karo, yama nafi tikiha tiwa? Himata ya tika kanamori tikanikamaba ama tiri? ");
INSERT INTO jaa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Neme ka Owa kamakabote nebonaka Teoso nanarifa me ya tabahari, bati oyene nima oyene nari. Me ihi hiyara me ihi manakone nahabibonaka. Me ihi amosa me ta mera kakawebonaka yama amosa ya. ");
INSERT INTO jaa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Te one me yati nasa na me nahaba me amake, Neme ka Owa tohahi kamabona ka yama ya. Te awehibonaka kamahari, towisawa tohawahari. Keye amakere\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yia 6 na ahabi ya Sesowi Betiro mera ha nematamonaka, Tiako, nisori Yowao me na mati. Mera towakimisematamonaka atami nemeha ya, me ya tabi ohariari. ");
INSERT INTO jaa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Me nokosi ya hihiya nawahematamonaka. Bahi noko nima noko nematamonaka oye kitaharo. Hinaka makari hikaha tosawemetemoneke, rabata oye nima naro. ");
INSERT INTO jaa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mowisei ya Eria me famaha hine me kanafotokiemetemoneke, Sesowi me hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Betiro Sesowi hiyarematamonaka. \"Ota ka hiti yama amosake haro, e tabi karo. Yobe biti terei ne hiri onahabana oke tinofe ya. Tikaba ohari, Mowisei kaba ohari, Eria kaba ohari, nebanaka\", Betiro ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Betiro hiyarasa ne neme sabi me bari hikawamemetemoneke, neme sabi sawi kitaharo kasiro ya. E ati kakehemetemoneke neme sabi boti ya. \"Okatao amaka hari, onofari. Ehene nafi amosabote amaka owa ni ya. Ati te kamitaho\". ");
INSERT INTO jaa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sesowi ya tataba Teoso ati me mitaha me kakomeha me foro na me boko tokanihemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sesowi kame Betiro mera boyo nematamonaka yehe ya. \"Te nahomisamahi. Te watorima nahi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yama me aawa na me watamaremetemoneke Sesowi ya me taba mati. Sesowi ohariwahamehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Atami ya me kisamemetemoneke. Sesowi me ha hina me narabi nima hinehemetemoneke. \"Haha yama te awaha te kaminarabone teke mata. Neme ka Owa ahabe wamisame nowati ya haha yama te awaha te kaminabone teke\", Sesowi ati nematamonaka, Betiro mera hiyarari. ");
INSERT INTO jaa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sesowi he ya tataba he me aate nemetemoneke. \"Eria kamatebona Mowisei ati kakamina me hite amaka Teoso ka towisawa kakebona ka yama ya. Himataba me ati e teha me amari ahi?\" me ati nemetemoneke, Sesowi me aate na mati. ");
INSERT INTO jaa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","\"Keye amakere. Eria kamehibonaka yama nafi namosebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Owati amake haro: Eria kamahareka hibati ya. Me hiwatorehino me hikatomehinoka. Efe nima Neme ka Owa nebonaka me ihi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sesowi he ya tataba he ati me watohemetemoneke Yowao Batisita tamine kaminari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Me tamaha Sesowi me noki namaroke. Me nahoha me nokosi ya Sesowi kame Sesowi nokosi ya me ka owa iso yobati ya itarisehimarika. ");
INSERT INTO jaa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"Sesowi okatao tikasomahi. Rabiki fawa nofare amaka. Rabikame ya kikiki kawahe ya soni nofe amaka yifo noki ya. Boka, nofe amaka faha ya. ");
INSERT INTO jaa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Owakamakiareka tiwa ya tataba me ni ya. Me hikasomebona kasomi me hiwatorahareka\", inamatewe bati ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sesowi ati yana nemarika. \"Te ati boti hiyara awineke. Teoso kitehi kiti te watora te awineke. Yama nawahake e tabiba ka yama. Tekamaho ahi owa ni ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Me hekamemarika Sesowi ni ya. Sesowi hinamati hora nemarika. Ati ehene hinamati tokomemarika. Inamatewe amosawamemarika hibati ya. ");
INSERT INTO jaa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sesowi ohariwahame he ya tataba me aate hinehimarika. \"Sesowi himataba hinamati otara kasawarira, ota toyosemehibonaha?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sesowi ati yana nemarika. \"Te ati boti e ra te awineke ahi: 'Teoso kitate amaka', te ati ra te. Teoso kiti te wati nawaha Teoso wati nawahi te nafiri ya yama amosabote te hiri tehabone teke. Te ati e ni ya ahi: 'Yati nemeha waha tokomaboneke', te ati ni ya yati tokomaboneke. Fara te ati nima yama naboneke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","22","Yama we one ya Sesowi he ya tataba mera ha nemarika, Karireya ya, mera hiyarebonaha. \"Hibati ya Neme ka Owa me ta towitiaboneke me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Me hinabowe ya yama we famaha ya kitamebonaka Teoso ati ehene\", ati nemarika. Me yawahamaroke Sesowi ati me mitaha mati, ahabebona hiwa kaminari. ");
INSERT INTO jaa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kafanao ya me kobo tonama me one Betiro aate nemetemoneke, tarakama ka moweta famehi ta nebonaha teboro ka mowetabonaha. \"Te ka hiti tarakama ka moweta famehi ta tehino ama, teboro ka mowetabana?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","\"Ee, ta hite amaka\", Betiro ati nematamonaka. Yobe ya Betiro fari name Sesowi aate hinibematamonaka. \"Simao tiwati miti onofa oke. Hike me amari towisawa me me hiyoseha mati, yinero me baka nabone mati? Bara me me yosete me ama? Fara me one me yosete me ama?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","\"Bara yinero me ta te me amake towisawa me ni ya\", Betiro ati nematamonaka. \"Fara me tabori tohi ka yinero me ta raba me awineke towisawa me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Me ihi hiyara me awineke era me yoseha mati, yinero e ta nabone me ati na mati, teboro ka yinerobonaha. Me onayawarabone oke. Tikamabone tike wara ya, kabi kana koro tikanabone tiwa faha ya. Aba nawasi tai tiehi inohoti ebe tikanabone tike. Moweta tiwasiabone tike aba inohoti ya, tarakama 4 ne ka moweta. Yinero tekamiyahi. Teboro manakonebona amaka, tika toha, oko toha, nari\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Faya Sesowi he ya tataba he me aate tasahamaroke. \"Teoso ka towisawa kake ya hike nofi mati tohehiba amara ohariari?\" ");
INSERT INTO jaa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sesowi inamatewe ha nemarika. Inamatewe nawarimarika me baikani ya. ");
INSERT INTO jaa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ati e nemarika ahi: \"Te ati boti hiyara naha awineke. Matehe nima te nabone teke. Matehe nima te ri ya Teoso ka towisawa ya te tabarabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te ati boti e nabone teke ahi: 'Onafi okere mata. Inamatewe biti nima one oke', te ati nabone teke. Te ati e ni ya ahi Teoso ka towisawa tera nofi mati tohehibonaka. ");
INSERT INTO jaa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Owa te nofi ka matehe te narifa owa te narifa, nabone teke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","\"Matehe owa nofaha me ihi hiyaraba wataraboneke te ehene. Tihabiba ka yama amosa awineke, haha yama hiri tirahabone tiwa matehe ni ya. Yama amosa awineke, yati ehebote ya mato wanaha ya tinamiti me mato ya tiwa me koro nifi ya, tihabibone karo ma boti ya. ");
INSERT INTO jaa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","E ehene e ka owa yama hiyara hiri ne ka yama hiyakere haro. Fare Teoso ati ehene amaka. E ehene e ka owa yama hiyara hiri ne era e yokohabone eke. ");
INSERT INTO jaa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tiye ihi yama hiyara hiri tinamone tini ya tiye ti tisa koro tiwitiabone tike. Titeme ihi yama hiyara hiri tinahamone tini ya titeme ti tisa, tinahabone tike, koro tiwitiabonehe bisa. Tiye oharia tikamaketehaba ama tike Teoso taboro ya, tiwinabone tiwa Teoso ya tifama tiwa. Tiye famaha tiwa me koro towiti riyahi yifo hiri ni owitera ya. Titeme famaha tiwa me koro towiti riyahi yifo hiri ni owitera ya. ");
INSERT INTO jaa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tinoko ihi yama hiyara hiri tinahamone tini ya tinoko soba tinaki ya koro tiwitiabanake. Tinoko oharia tikamaketehaba ama tike Teoso taboro ya, tiwinabone tiwa Teoso ya tifama tiwa. Tinoko famaha tiwa me koro towiti riyahi yifo hiri ni ya yama hiyara ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","\"Matehe te tohirima nahi. Owati te mitahi. Me ka Teoso nanarifa me sawike neme ya, okobi noko me kakatomaha mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","\"Te ati omitahi. E ka owa ka ofeya me 100 na hinaka ofeya ohari tosawari hahi ofeya fawa ne siba neba awaka, ofeya me one 99 me tohaha mera kakanakosari yama kabani ya. ");
INSERT INTO jaa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Siba hine hiwasi ya ehene yayai ni kitehiba amaka. Ofeya me one me fawa ra me ihi ta yayai ni yokana tohareba amaka. ");
INSERT INTO jaa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hahi ofeya mera kihehi nima te ka abi te amaka, winahari neme ya. Hinaka matehe me ka owa ohari fawa rebona ati nareka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","\"Tiwa ni ya te ka owa yama hiyara hiri ne ya tihiyarehibonaka, te fami oharia te. Hora tinehibonaka. Tiwati mite ya te abe nofawamahabone teke. ");
INSERT INTO jaa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tiwati mitare ya me ha tinahi. Te fami ya te fama, te terei ni ya te terei na te toha, na te hiyarebonaka. Teoso ka yama hani ati e teha amake ahi: 'Te ka owa ohari ati yana ne owa yama hiyara hiri nemona ati ne ati te nofarabone teke. Me fami ya me fama me terei ni ya me terei, toha na yama me awahamone me ati na me ati ta te nofahabone teke', Teoso ka yama hani ati te amake. ");
INSERT INTO jaa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te ka owa te ati mitare ya me te ha nahi, Teoso ka mati, me nafi. Te ya tabe ya te hiyarebanaka. Te nafi ati mitare ya te tabamarehibonaka. Bara me nima nawahebonaka. Kofeno ka yinerobona wawarara me ka owa nima nawahebonaka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","\"Me ni ya te ati amosi ya Teoso ati amosa, nebonaka. Me ni ya te ati hiyari ya Teoso ati hiyareba amaka. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Te famaha Teoso te aate na tika owa ati nima tiwati ni ya okobi neme ya winehi fara yama te aate na ta nebonaka te ni ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te fama, te terei na heoniao te hiri ni ya owini te hiri na te ni ya osawiabone oke e tabaha e\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Betiro aate hinehimarika. \"Sesowi owa ni ya e ka owa yama hiyara hiri ne hinaka yama hiyara hiri hina fawa onihaba ama o, yama hiyara tamaha hiri nari? Hinaka yama hiyara hiri hina 7 na fawa onihaba ama?\" Betiro ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sesowi ati yana nemarika. \"Hinaka yama hiyara hiri ni 7 na tinahabihabone tike. Hinaka yama hiyara hiri ni 77 tohaha tinahabiha, tinahaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","\"E ka owa towisawa tohe ka yama nima Teoso ka towisawa kaki tehi amaka. Towisawa hinaka yama aahi mera ha nematamonaka, me ka yama manakone me nahabihabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hinaka yama aahi owa ha ni tai toehimatamonaka barata 500 mio kiro tohaha manakone nahabihibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yinero kiharemona ati nematamonaka, hinaka yama manakone nahabihibonaha. Towisawa me one yosehimatamonaka, hinaka yama aahi ka yama me ta nabone mati, hinaka yinero manakonebonaha. Fati toha, biti me toha, na me me ta nabone towisawa ati nematamonaka, hinaka yinero manakonebonaha\". ");
INSERT INTO jaa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","\"Hinaka yama aahi he ati mitehi he nokosi ya sonehimatamonaka, he aate nari. 'Yama noki timatahi. Yama manakone nafi onahabihaba awineke, yama we one ya', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","\"Towisawa ni ya hinaka kota baka rebona hinehimatamonaka waha, aawawa hinahari\". ");
INSERT INTO jaa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","\"Hinaka yama aahi tokomematamonaka. Tokome towisawa ka yama aahi owa kobo nematamonaka moweta tenario 100 ne tefe nari he ni ya\". \"Namiti wara hine namiti niki hikanematamonaka. 'Oko yama manakone tinabihahi', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","\"Towisawa ka yama aahi owa sonehimatamonaka he nokosi ya aate hinahari. 'Yama noki timatahi. Tika yama manakone onahabihabana oke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","\"Ati hiyarematamonaka. Faya tokomematamonaka. Me one hibehibona hinehimatamonaka kateya ya, hinaka yama manakone nahabihibonaha. Yama manakone nafi nahabire ya tasi torehibona hinehimatamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","\"Towisawa ka yama aahi ehene me hiwe me hinofarematamonaka fara me one. Me tokoma ehene me hikaminehimatamonaka towisawa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","\"Towisawa ha hitasematamonaka, fare. 'Tiwehene hiyakere. Owa aate tina kota baka tinamarahabone onahara oke. ");
INSERT INTO jaa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Oyahara oke tiwa ni ya. Himataba tika owa tika kota baka nebona tine tiri, tiyahara tiwa?' towisawa ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","\"Towisawa hamehimatamonaka. Ati ehene me one hibehibona hinehimatamonaka kateya ya, hinaka kota manakone nafi nahabihibonaha\". ");
INSERT INTO jaa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","\"Te one me ni ya te ati somawamari ya okobi neme ya winehi ati somawamarebonaka te ni ya fare towisawa okomine nima\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sesowi mera hiyari fawa ne Karireya ya yana tone tokomemarika Soteya kote ya, Sotao faha tohaha kowani ya. ");
INSERT INTO jaa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Me tamahamaroke me kakeha mati he ni ya. Sesowi mera nakitamemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseo me aate hinehimarika, me totomi hinehibonaha. \"Himataba e ka yibote e toyosematehani e amari, tokomabana? E ka yibote yama hiyara yokana hiri ra e toyosematehani ama?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sesowi ati e nemarika ahi: \"Teoso ka yama hani ati te watoha te awineke. Hibati ya Teoso yama nafi hiri ne ya Teoso makiteba hiri, fanawiteba hiri, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Teoso ka yama hani ati e teha amake ahi: 'Makoni maki bati ya mati famaha mera kakosate amaka, fati ya famahari. Faya me famaha e abono oharia nima me naboneke', Teoso ka yama hani ati te amake. ");
INSERT INTO jaa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","E famaha nima me raboneke, e oharia nima me na mati. Teoso me hinawanikimaharake. Fare Teoso ehene amaka. Me famaha me abe kakosaraboneke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Me aate hitasemarika. \"Himataba Mowisei ati ehene maki fati toyosemehiba amara? Mowisei ati e nematamonaka ahi: 'Tika yibote tokomabone tini ya hinaka yama haniba ta tinahabone tike, tokomabonehe', Mowisei ati nematamonaka\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sesowi ati yana tasemarika. \"Teoso ati te kasawari ka Mowisei ati e nemata awaka ahi te ni ya. Te ka yibote te toyosemahabone ati nematamonaka. Teoso ati taiti e tere amaka ahi. ");
INSERT INTO jaa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Owati amake haro. Tika yibote maki owa ahi hina tinofamaramone tina tiyosemahaboneke, toyosemi tinofi ya, tifanawahabone tina tiwa. Tika yibote maki owa ahi hira tifanawaharabone tike\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","He ya tataba me ati yana namaroke. \"Makoni e fanaha ka yama hiyara awineke. E fanaraba e awineke\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sesowi ati e nemarika ahi: \"Haha yama te kamina me watokere, me tamaha mati. Me tamakere, haha yama me watoha mati. Teoso mera kanawane ya me hiwatoaboneke. Me one haha yama me watoraba me amake, Teoso mera kanawanare karo. ");
INSERT INTO jaa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","E makiti one fanihinatera amake, me tane rabika mati, hiba me wata na mati. E makiti one me tane hiyatera amake me one ihi. Me one fanatera me amake, Teoso ka towisawa narifi me ohariabone mati. Owati watohina tini ya owati tiwatoa tiwa awine tike\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Matehe me kakamamaroke Sesowi ni ya, yehe kakibarehibonaha matehe mese ya, Teoso ha nari. He ya tataba me me hora namaroke, me me kakamarahabone mati Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sesowi ati e nemarika ahi. \"Matehe hine kamake owa ni ya. Me te ma nikiriyahi. Teoso ka towisawa kobo nake ya haha matehe nima me naboneke me ha hina mati, he ya me tabahabone mati\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Faya yehe kakibaremarika matehe mese ya. Tokomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yama we one ya me ka owa horawe Sesowi aate nemarika. \"Borofeso himata nima yama na hiri oribe amosaro, oko wini fara tohatehabone owa Teoso taboro ya, ati ehene?\" ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","\"Himataba yama amosa tabiyo owa aate tine tiri? Amosate amaka hari, ohariari. Teoso taboro ya tikamaketehabone tina fare Mowisei atimatamona nima tiwehene nabone tike\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","\"Himata nima yama na hiri oribe, Mowisei hikaminehemete?\" me ka owa ati nemarika. \"Te ka owa tinabowarabone tike. Tifana tika yibote amara ahi tirahabone tike. Te one me ka yama tibotirihi, keye hiri tirihi, tinahabone tike, te ka one me ihimone tikamina tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Abi tinofa, ami tinofa, me one tinofa, tinahabone tike. Fara tiwa tinofa tiwa nofi nima te one me nofi tinahabone tike\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","\"Yama nafi e na hiri ote ama oke. Yama one hiri onaba naha awine?\" me ka owa ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","\"Yama nafi Teoso hinofa hiri tinahabone tina tika yama nafi ta tinahi, yinero manakonebana. Yinero wara tikani ya ta tinehibonaka, me honara me ka yinerobonaha. Tiwehene e ni ya tika yinerobona tamehi nehibonaka neme ya. Yinero ta ni hawa tihi ya tikamabone tike owa ni ya, e famawahabone e\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Me ka owa Sesowi ati mite faya tokomemarika, kokoriri nari, hinaka yama ta ni nofarari, yama tamaha kihahari. ");
INSERT INTO jaa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sesowi he ya tataba mera hiyaremarika. \"Yama nihinakere haro, e ka owa honehi ka yama, Teoso ka towisawa ya famehibana. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E nebonaka ahi, kamero nima. Kamero ka yama nihinakere, tokiyomaba karo akoye hoti ya. Yama nawahi mati toha awineke, e ka owa honehi Teoso ka towisawa ya famaba karo\". ");
INSERT INTO jaa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sesowi ati me mita \"Hika\", me ati namaroke. \"Teoso me hikasomahaba me watateraba me awineke\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sesowi mera kakatome mera hiyaremarika. \"Yama nihinakere e ni ya. Yama nihinaraba watatera amake Teoso ni ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Betiro ati yana nemarika. \"Sesowi ota ka yama ota kakosa otake, yama nafi, e tabawaibone karo. Himata Teoso ta neba amara ota ni ya?\" ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","\"Yama nafi yati tohawai ya, Neme ka Owa towisawa tohawe ya, towisawa ka katera ya itari ya, te nahoriabone teke towisawa ka katera ya bisa, e tabaha e. Ihayeo me ate 12 na me nahoritehaboneke te nokosi ya. Me ihi tamine te mitatebone teke, me ka yama hiyara tamine toha, me ka yama amosa tamine toha, naro. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te ka yobe te kakosa, te ka niso te kakosa, te ka asima, te ka abi, te ka ami, te ka matehe, te ka yobe taboro te kakosa, na Teoso tera kakawebonaka yama amosi mati tohaha ya. Te wini fara toha, tehaba teke Teoso taboro ya, ati ehene\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","\"Me tamaha me tai toa me yotowamatehaba me amake. Me tamaha me yotoha me tai tohawamatehaboneke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","\"Teoso ka towisawa kaki e nebonaka, fatara hiti ka yama nima. E ka owa yobe hiti tohe bosa ne tokehimatamonaka yama hiba wa ni ya, mera ha nebonaha, yama me ahi nabone mati hinaka ofa wati ya. ");
INSERT INTO jaa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Moweta ohari tenario tohe ta nebona ati nematamonaka, yama ahi ni manakone. Ati me hinofematamonaka. Faya mera yosehimatamonaka, yama me ahi nabone mati ofa wati ya. ");
INSERT INTO jaa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nofi ora tohe ya tokatase me one awehimatamonaka, mekato ya me nahoha mati\". ");
INSERT INTO jaa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","\"Mera hiyarematamonaka. 'Me ya te tabahabone teke yama te ahi na te oko ofa wati ya. Te ka yama ahi ni manakone amosaba ta onahabana oke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","\"Me tokomakehemetemoneke. Bai nokorise ya tokatasa, bai weo tone ya tokatasa, nematamonaka, fara yama hiri hina hiri nari\". ");
INSERT INTO jaa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","\"Siko ora tohe ya tokatase me one awehimatamonaka, me nahoha mati. 'Himataba yama te ahi rineri, hine ya te naoha te?' ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","\"'Otara me ha kere, yama ota ahi naba ota', me ati nemetemoneke\". \"'Hima, me ya te taba yama te ahi nibeya oko ofa wati ya', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","\"Bahi toke ya fatara hiti he nanarifa me ka hiti hiyarematamonaka. 'Yama me ahi na me ha tinahi, me ka yama ahi ni manakone tinahabihaba tiwa. Me yotoha me baka ni tai tohaboneke. Me tai toha me baka ni yotowamaboneke'\". ");
INSERT INTO jaa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","\"Tenario ohari ya mera baka nematamonaka, me kobo namaki yotowamaha mati, siko ora tohe ya\". ");
INSERT INTO jaa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","\"Me tai toha mera baka nebona ati ne me ati boti e nemetemoneke ahi: 'Ota ka yama ahi ni manakone nafihaba awineke mata ya', me ati nemetemoneke\". \"Tenario ohari ta nematamonaka me ni ya, fara me one ka yama ahi ni manakone nima\". ");
INSERT INTO jaa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","\"Me ka tenario me awaha me hora hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Haha me yotoha me ka yama ahi ni bahi ohari tohehi ota ka yama ahi ni manakone nima me ka yama ahi ni manakone nineke, baka tinaharo. Bahi hiwene ota karima otake yama we oharia ya, yama ota ahi na ota', me ati nemetemoneke'\". ");
INSERT INTO jaa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'\"Me ka owa ohari hiyarematamonaka. 'Oko amiko tiwa okeyerara oke. Tenario ohari baka onahabone ona owati amosara oke tiwa ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tika yinerobona ta onahara oke hibati ya. Tikamahi hibati ya. Tika yinerobona nima owa yotohi ka yinerobona nebona onahareka. ");
INSERT INTO jaa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Oko yinero amaka. Ta one ya ta, ta ore ya ta orihi onehiba awaka. Yinero tamehi tinofa tiwa awine tike, owa tiwaha tiwa, oyahamone tina tiwa', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","\"E tehaba amake ahi, me ka yama nima. Me yotoha me tai toawama, me tai toha me yotowama, tehaba me amake\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sesowi yana tonehimarika, tokehibonaha Serosarei ya. Hawi ya me tokoma he ya tataba me 12 na mera ha nemarika, mera hiyari oharibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"E tokomakehaba eke Serosarei ya. Neme ka Owa me ta naboneke sasetoti me ka hiti me ni ya, Mowisei ati kakamina me ya me taba mati. Me hikahabanebonaka, ahabebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Me ta hinehibonaka bara me ni ya. Bara me kosi hinehibonaka, me haha hikanari. Faya me hinawanehibonaka awa ya, ahabebonaha. Manakobisa yama wehe famaha ahaba nowati ya kitamebonaka Teoso ati ehene\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebeteo biti me ka ami kamakiamaroke Sesowi ni ya, biti me ya tabaharo. Itarisehemetemoneke isi yobati ya, Sesowi nokosi ya, Sesowi aate naro. ");
INSERT INTO jaa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","\"Himata tinofari?\" Sesowi ati nematamonaka. \"Towisawa tohi yana tini ka yama ya okatao me yoro narehaboneke tibeheri ya fahi, tiwati ihi. Tika kanihina ya owa itari, tika yasoka ya owa itari, nebonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","\"Haha yama te kamina te watokere. Fara kobo okofawahabone te kafawibana? Okofawaboneke hibayata ya\". \"Fara kobo ota kafawaboneke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","\"Fara kobo okofawahabone te kafawaboneke bisa. Owati ihi amaraboneke, e ka owa itaribona karo obeheri ya. Okobi oharibonaka, e ka owa kaminari, itaribonaha obeheri ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sesowi ya tataba me one Sebeteo biti me ati tamine me mita me yawahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sesowi mera ha nemarika, mera hiyarebonaha. \"Bara me ihi te watote me amake. Me ka towisawa me ati e te me amake ahi: 'Ha owa ta me ka hiti ama oke', me ati te me amake. Me ka hiti me me yose, te me amake. ");
INSERT INTO jaa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Me ihi nima te ehene rabone teke ha te ta. Titaminahabone tina te one me tinarifahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tika one me ka hiti tohi tinofi ya me nanarifa tihahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Neme ka Owa nima tinahabone tike. Neme ka Owa kakehareka, me one narifebonaha. Me hinarifarebona ati nareka. Kakehareka, ahabebona ati nari, me manakonebone nahabibonaha\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Seriko ya yana tone me tamaha me ya tabehimarika, tokomari. ");
INSERT INTO jaa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Me famaha me noki awatera me teme narehamaroke hawi beheri ya. Sesowi tamine me mitehemetemoneke, kakehari. Me ha ni yana namaroke. \"Ota ka Hiti, Tafi ka noti, otara aawawa tinahi\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","\"Te ati watarima nahi\", me one ati na me ati kitamisahamaroke. \"Ota ka Hiti, Tafi ka noti, otara aawawa tinahi\", me ati namaroke tasa. ");
INSERT INTO jaa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sesowi ma towiti me ha hinahamaroke. \"Himata te nofari, hiri onahabana te ni ya?\" Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","\"Ota ka Hiti ota noko tikasomahi\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sesowi me aawawa hinaha he yehe ya me noki boyo hinahamaroke. Me noki amosawahamaroke hibati ya. Faya Sesowi ya me tabawamaroke waha. ");
INSERT INTO jaa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Me kobo namaroke orifa boti ka atami ya, Betifase ya, Serosarei yabori ya. Sesowi he ya tataba me famaha mera yosehimarika, me tai tokahabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","\"Te towakahi tabora ya, fa kowani ka tabora. Tabora ya te kobo ki ya someto te awibote nabone teke, biti ya famaharo, me yati na mati. Me te tisiyahi, me te kakamibeya owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Me ati hiyari ya te ati e nabone teke ahi: 'Ota ka Hiti hinahareka', te ati naba teke. Me ati amosaba me amake te ni ya hibati ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Teoso ati kakamina yama hikaminehemete nima yama namaroke, ati e nari ahi: ");
INSERT INTO jaa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","\"Te ati e naba teke ahi, Serosarei ka me ni ya: 'Te ka towisawa te awa ha. Kakehiba amaka ahi, someto ya yaka kanahari. Yahehi yaka kanaka someto biti ya,'\" Teoso ati kakamina ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Haha Sesowi hikaminaha me hiri hinahamaroke, he ya tataba me fama mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Someto me me kakama someto bari ya me ka makari me so nirihamaroke, Sesowi itaribona karo. ");
INSERT INTO jaa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Me tamaha makari me so tonihamaroke hawi ya. Me one awa ini me ti na me so hikanihamaroke hawi ya. ");
INSERT INTO jaa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Me tamaha Sesowi nokosi ya me tai toha me one yoto namaroke he nowati ya, me tamaha mati. Me ha namaroke. \"Tafi ka noti titamina tike. Teoso ati ehene tikehara tike. Teoso tiwa nofaka. Haha neme ka me winaha 'Teoso amosaka', me ati naboneke\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Serosarei ya Sesowi tokiyome ya sitati nafi ka me abe hiyaramaroke. \"Hibake amara ha?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","\"Sesowi amaka hari, Teoso ati kakamina tohahari, Karireya ka Nasare kari\", me ati namaroke, Sesowi ya me tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sesowi tokiyomemarika teboro wari ka yama ya. Mera awehimarika, yama me ta na mati. Me hiyosemahamaroke, me tokomabone mati. Yama me nikaha mera toyosema nemarika. Moweta me toroka na me ka mesa bebehe kawahemarika. Monowi me ta na me ka katera bebehe kawaha nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ati yana nemarika. \"Teoso ka yama hani ati e teha amake ahi: 'Oko yobe Teoso hihiyaramona me hinehiba amaka', yama hani ati te amake. Yama boboti me tabori Teoso ka yobe tohawaka te ehene\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Me noki awatera me toha, me yaka ni hiyaya na me toha, na me kakehamaroke Sesowi ni ya, me hikasomahabani mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sasetoti me ka hiti me ya Mowisei ati kakamina me tabaha Sesowi mera kasome me awaha ehene me hinofarehimarika. Matehe ha namaroke teboro wari ka yama ya, \"Tafi ka noti hosana\", me ati na mati. Sasetoti me ka hiti me ya Mowisei ati kakamina me tabaha matehe me awaha me ihi me hinofarahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sesowi me hiyaramaroke. \"Matehe ati timitarini?\" me ati namaroke. \"Matehe ati omita oke. Teoso ka yama hani te watora te awine, ati e naro ahi? 'Teoso tiwati ihi matehe ya matehe bite fotara kataba tiwa me kahiyarake', yama hani ati te amake, Teoso ka yama hani\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sesowi tokehimarika Betania ya, amo towitibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hiba yama wa ni ya tokamatasehimarika Serosarei ya. Hawi ya fimi hiwasimarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Fiko awehimarika. Fiko wai ya toke fiko boni siba ne fiko boni wataramaroke. Ati yana nemarika. \"Tibonomaterabone tike\", ati nemarika. Fiko waya nisahamaroke hibati ya. ");
INSERT INTO jaa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","He ya tataba me hiwa \"Hika\", me ati namaroke. \"Fiko himata ebe na waya nisineri hibati ya?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sesowi mera hiyaremarika. \"Te ati boti e nabone teke ahi: 'Teoso kitaka', te ati nabone teke. Te ati e ni ya ahi, te ehene e nabone teke owehene nima, fiko onahabiha owa. Yama bara te hiri nabone teke bisa. Te ati e nabone teke ahi: 'Yati nemeha yana tinahabone tike, fara tiwa koro tifehabone tiwa ma ya', te ati nabone teke. Te ati e ni ya fara te ati nima yati naboneke. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te ora na 'Teoso kitaka', te ati na fara te ati nima yama naboneke, Teoso ati ehene\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sesowi tokiyomehimarika teboro wari ka yama ya. Mera kanawanehimarika. Sasetoti me ka hiti mati, me nafi ka hiti mati, me na Sesowi me aate namaroke. \"Hike ati eheneno yama e na hiri tine tiri?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sesowi ati yana nemarika. \"Tera aate okibone bisa ha owa. Yama te kamini ya owa okominahabone oke te ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hibake ati ehene Yowao mera iibofariseta amara? Teoso ati eheneta ama? Fare ati eheneta ama?\" ati nemarika. Faya me abe hiyaramaroke. \"Teoso ati ehenetemona e ati ni ya ati e neba awaka ahi: 'Himataba ati te nofareta amara?' ati neba awaka. ");
INSERT INTO jaa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Fare Yowao ati ehenetemona e ati ni ya me tamaha me e nakomeke. Me tamaha Yowao Teoso ati kakaminamona me ati teha me amake\", me ati nemetemoneke, me abe hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sesowi me hiyaramaroke. \"Yowao ota watokere\", me ati namaroke. Sesowi ati yana nemarika bisa. \"Yowao kamini te nofari ka owa yosehi kamini onofabisa okara\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","\"Te ati miti onofa oke. E ka owa biti me famehemetemoneke. Biti owa narabo nima nematamonaka. 'Okatao yama ahi tinahabone tike oko ofa wati ya', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","\"'Yama ahi ni onofa okere', biti ati nematamonaka. Faya bahi owa ya ati hiyawe tokomakehimatamonaka, yama ahi nebonaha\". ");
INSERT INTO jaa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","\"Biti owa hiyaratasehimatamonaka. Fara yama hikaminaha kaminematamonaka tasa biti owa ni ya, hiyosehari. 'Yama ahi onahabana oke', ati ne yama ahi rematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","\"Hehi bati ati tokatabemata ama hari? Owa bati ati tokatabemata ama?\" Sesowi ati nemarika. \"Hehi aate ni tai tohe bati ati tokatabehimata awaka\", me ati namaroke Sesowi ni ya. \"Fanawi me ka aahi toharawa yinero yayaba me toha na me e nineke hehi nima, aate ni tai tohahari. Teoso ka towisawa ya me tabatehaba me amake. Ha te ta te e nineke, hahi aate ni yotohi nima. Teoso ka towisawa ya te tabateraba te amake. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Te ni ya Yowao hawi amosa tamine kamine ati te nofarete teke. Fanawi me ka aahi toharawa yinero yayaba me toha na Yowao ati me nofaharo me amake. Yowao ati me nofa me ihi te awakene Yowao ati te nofarete te amake\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","\"Owati te kamitahi, hiyara one okominahabone owa. E ka owa yama kihe ofa tamaha koro nematamonaka. Yama bari kanehimatamonaka, ofa wati bari kanahari. Hoti wi nematamonaka, ofa boni me natabobone karo, fehe me hiri hinahabonehe. Yati hiri ni nemeha nawehimatamonaka, hinaka owa iitaribonaha, ofa kakatomehibonaha. He ni ya ofa me heta nemetemoneke ati ehene, ofa boni me ebe nabone mati. Faya tokehimatamonaka yama bara ya\". ");
INSERT INTO jaa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","\"Ofa boni hahata ka yama ya hinaka yama aahi mera yosemematamonaka, ofa me ahi na me narabi me nima nabone mati, ofa me ebe kanahabone mati\". ");
INSERT INTO jaa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","\"Hinaka yama aahi me me hiwatemetemoneke. Owa me baro, owa me hinabowa, owa me hibana, hinehimatamonaka yati ibe ya, ahabebonaha\". ");
INSERT INTO jaa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","\"Faya hinaka yama aahi me one tatama na yosemakehimatamonaka. Fara me me hiri kani ka yama ya me me hiri hikanemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","\"Manakobisa biti yosemakehimatamonaka me ni ya waha. 'Okatao me kakorahaba me awineke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","\"Biti kamaki kobo namaki me hiwe me abe hiyaremetemoneke. 'Efe biti amaka hari. Ofa hiti ahabe ya hinaka yama hihawaboneke waha. Hima e nabowaho. Hinaka yama e ihawaibeya', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Me hiwate me hekamematamonaka ofa wati beheri ya. Me hinabowematamonaka fahi\". ");
INSERT INTO jaa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","\"Ofa hiti kame ya himata nima ati neba amara me ni ya?\" Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sesowi ati me mita me ati yana namaroke. \"Ofa hiti mera nahabihiba amaka, me ihi hiyara mati. Faya ati ehene me one ofa heta naboneke. Ofa hati ya me ebe hinaboneke, ofa hiti kabonehe, isi ni\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sesowi ati yana nemarika. \"Teoso ka yama hani te awatera ama, ati e naro ahi: 'Yobe me hiri na yati one me hinofara afa yati yobe ewene taiti tohineke waha. Teoso ati ehene amaka. Afa yama amosate amake mata ya e ni ya', yama hani ati te amake, Teoso ka yama hani\". ");
INSERT INTO jaa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","\"Makoni owati e nara oke ahi: Teoso ka towisawa tera nofamarehiba te amake. Me one ha neba amaka, bara mati, yama hinofa me hiri nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Haha yati mese ya tisi ya bakaka tinahabone tike. Timese ya yati soni ya titabohabone tike\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sasetoti me ka hiti me ya fariseo me tabaha Sesowi ati me mita he ati me watohemetemoneke, mera kaminari hiyara ya. ");
INSERT INTO jaa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sesowi me watahabone me ati na Sesowi me wataremetemoneke, me tamaha me ihi, me me nakome karo, Teoso ati kakaminamona me hine kari. ");
INSERT INTO jaa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sesowi ati yana namatasehimarika, hiyara kaminari. ");
INSERT INTO jaa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"Teoso ka towisawa e te amaka, towisawa owa biti fanehibona nima. Towisawa marina hiri nebona ati nematamonaka, biti fanabona ka marina. ");
INSERT INTO jaa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hinaka yama aahi mera yosehimatamonaka, me me ha nabone mati, marina ya me sawihabone mati. Marina ya sawi me nofaremetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","\"Faya hinaka yama aahi me one yosetasematamonaka. Ati e nematamonaka ahi me ni ya: 'Me te hiyariyahi, me ha ona mati. Marina yana tonakibone. Bowi me nabowaharake. Bowi one me nabowa narake, bowi imaharo. Yama hawa tohaharake. Te kamakabote nabone teke, okatao fanabona ka marina ya', te ati nabone teke me ni ya'\". ");
INSERT INTO jaa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","\"Hinaka yama aahi me tokomake me me hiyara me ati miti me hinofarehemetemoneke. Marina me nofara me tokomemetemoneke yama one ya. Me ka owa ohari tokehimatamonaka hinaka fatara ya. Owa toka nematamonaka yama ta nebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Me one me me hiwatemetemoneke. Me me baro hinehemetemoneke, me me hinahabihabone mati, hinaka yama aahi mati\". ");
INSERT INTO jaa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","\"Towisawa hamamisehimatamonaka. Hinaka saotato mera yosehimatamonaka, me tamaha mati. Ati ehene saotato me me nahabihemetemoneke, towisawa ka yama aahi me me nahabiha mati. Me ka sitati me sari hikana hinehemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","\"Faya hinaka yama aahi mera hiyaratasehimatamonaka. 'Marina hawa tohake. Me watakere. Me ha onaha me ihi hiyakere. Me tafaraba me amake marina ya. ");
INSERT INTO jaa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Me te tonakamakiabone teke waha, me yaka na mati hawi ya, me te ha nabone te, me sawihabone mati marina ya'. ");
INSERT INTO jaa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Faya hawi ya me tokoma me me ha nemetemoneke, me yoro tokana mati. Me tamawahemetemoneke marina ya\". ");
INSERT INTO jaa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","\"Towisawa tokiyomematamonaka marina tabori ya. Mera awehimatamonaka marina ya. Me ka owa awehimatamonaka, makari amosa kiharari. ");
INSERT INTO jaa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ati yana nematamonaka. 'Habai, himataba tikiyomakine tiri, tika makari amosara tiwa?' ati nematamonaka\". \"Ati watarematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","\"Towisawa he nanarifa mera hiyarematamonaka. 'Mano te kamato, teme te wete kasa ne ya te koro towitiho yama soki ya. Yama soki ya me sawiha me ohi naba me amake. Me ini yiki tokanaba me amake, me yawa mati', towisawa ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","\"Me tamaha Teoso mera ha neba amaka. Me tamara me ya tabebonaka\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseo me tokomemetemoneke, me abe hiyarabone mati. Sesowi me aate nabone me ati nemetemoneke. Ati tosawarihibona me hinehimatamonaka. Ati tosawari ya me hinabowebona me hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Me ya tataba me me yosehemetemoneke Sesowi ni ya. Eroti ya tataba me ya me tabahamaroke. Sesowi me aate namaroke. \"Borofeso tiwa ota watoke, me one tikeyera tiwa. Me tikanawanate ama tike Teoso ka hawi yokana ya. Fara tiwati tohanawi te ama tike me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tiwati ota mitahabone ota ati na otake haro: E ka yinero Sesa yabehibona ati ne Sesa ka yinerobona e ta nibana?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sesowi mera watohimatamonaka, me ati boti hiyara mati. \"Himataba owa te totomi nineri? Te ati boti hiyara te awineke. ");
INSERT INTO jaa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moweta te namohi owa ni ya, kofeno e baka nibone ka moweta\", ati nemarika. Moweta tenario tohe me kakamemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","\"Hibake kanamori amara hari, moweta kari? Hibake ino amara ha, moweta kari?\" ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","\"Sesa ino amaka, Sesa kanamori ya famahari\", me ati namaroke. \"Fare Sesa ka yama te ta nabone teke fare Sesa ni ya. Fara Teoso ka yamabisa te ta nahi fare Teoso ni ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sesowi ati me mita \"Hika\", me ati na me tokomamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Afa yama wehe ya satoseo me kakehemetemoneke Sesowi ni ya. E ahaba Teoso era nakitamarebona satoseo me ati te me amake. Sesowi me aate namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","\"Borofeso Mowisei ati e nematamonaka ahi: E ka owa kahiware ahabe nisori fati hitiwaboneke, kahiwawahabonehe, anoti bitibonaha, Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","E ka owa biti me 7 nemetemoneke. Biti taiti fanehi ahabematamonaka, kahiwarahari. Fati nisori hitiwemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ahabamaki nematamonaka, biti watarari. Fara me nima me ka niso me nemetemoneke tasa, me nafi. ");
INSERT INTO jaa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Fana ahaba, nemetemoneke me nowati ya. ");
INSERT INTO jaa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Teoso ati ehene me kitami ya hike fati tohahaba amari, me nafi yabaharo?\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sesowi mera hiyarematamonaka. \"Te ati hiyakere. Teoso ka yama hani te watotera te amake. Teoso te watorihi, ke, kitahari. ");
INSERT INTO jaa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","E ahaba e kitama e abe itimatera amake. E e nabone eke, Teoso nanarifa me nima. ");
INSERT INTO jaa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E ahaba e kitamarabone te ati na te ati ta hiyakere. Teoso ati te watora te awine, hinaka yama hani karo? Teoso ati e nematamonaka te ni ya: ");
INSERT INTO jaa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Abarao Isaki Yako me na me ka Teoso ama oke', Teoso ati nematamonaka. E abohi ka Teoso amakara. E yati na ka Teoso amaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Me one Sesowi mera kanawane ati me mitaha \"Hika\", me ati nemetemoneke, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseo satoseo me tamine me mitaha me abe yoro tokaniwama me tokomakemaroke Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me ka owa Mowisei ka yama hani wawato tohe Sesowi aate nematamonaka, totomi hinehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","\"Borofeso, himata yama amosi mati tohari e hiri nabana, Mowisei hikaminehemete?\" ");
INSERT INTO jaa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sesowi ati yana nematamonaka. \"'Tika Teoso tinofabone tike, tiwati boti ya kasiro ya, tika Hiti tohahari', Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Afa yama amosi mati tohake, Mowisei hikaminaharo. ");
INSERT INTO jaa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Haha yama nima yama one nineke, hikamina hinehemete, e naro ahi: 'Fara tiwa tinofa tiwa nofi nima te one me nofi tinahabone tike', Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Haha yama famaha okominaha nima Mowisei ati naka, ati nafi. Fara nima Teoso ati kakamina me ati nineke haro, me ati nafi\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yama we one ya fariseo me nafi Sesowi ya me tabaha Sesowi mera aate nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","\"Kirisito te kaminahi owa ni ya. Hike ka noti amara?\" \"Tafi ka noti tohatehiba amaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","\"Tafi ati e nematamonaka ahi, Teoso Kanamori ati kaminari: 'Teoso ati e nareka ahi oko Hiti ni ya: \"Tiwitarehi oko kanihina ka ya. Tiwa me nofara me kitaraba me amake tiwehene, owati ihi. Tiwariabone tike me mese ya, me tai tikana tiwa\"', Tafi ati nematamonaka, Teoso ati kaminari. ");
INSERT INTO jaa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kirisito Tafi Hiti hinihematamonaka. Kirisito Tafi ka Hiti tohe ya himataba hinaka noti tohehiba amara?\" Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Me ati wataremetemoneke. Sesowi aate ni me fawa nemetemoneke waha, me habi bayimari karo. ");
INSERT INTO jaa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sesowi ati yana namatasemarika, he ya tataba mera hiyarari, me one ya me tabaha mati, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","\"Mowisei ati kakamina me ya fariseo me tabaha Mowisei taboro ya me wanawaha Mowisei ati me kaminate me amake. ");
INSERT INTO jaa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Makoni fara me hikaminaha te hiri naboneke. Me ihi ta nima te ehene rabone teke. Yama me hikamina me hiri tera me amake, fara mati. ");
INSERT INTO jaa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sakora me mo kanihate me amake, kanaharo, me one me me weyeye nihabone mati. Me me narifatera me amake, sakora weye ni amosibone karo. ");
INSERT INTO jaa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Fara yama amosa me hiri hina me hiri hite amake, me one nokosi ya, me ihi me hiwibone karo. Yama hani ehebote me kanawanate me amake me ate ya, Teoso ati ka yama hani, me me hiwahabone mati. Yama mati yaboha me kanawinate me amake me ka makari tamerabi ya, Teoso me nofahamone me ati na mati kasiro ya, me me hiwahabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nahori me nofate me amake marina hiti beheri ya. Nahori me nofa, te me amake me one nokosi ya, sinakoka ya. ");
INSERT INTO jaa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yama me hinofate amake haro, mekato ya me sawiha 'Afa ama ti?' me one ati na ka yama me ni ya. Me hinofa hite amake haro, 'Habi', me ati ni ka yama, me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","\"Habi tera me toniharaboneke, ha te. Te ka Hiti oharite amaka. Fai hinama te tohate te amake. ");
INSERT INTO jaa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ka owa te ka abi te toniharabone teke, sawihari bofe ya. Te ka abi oharite amaka, winahari neme ya. ");
INSERT INTO jaa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te ka owa te ka borofeso te toniharihi nabone teke. Te ka borofeso ohari, te amaka, Kirisito tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te ka owa te ka hiti tohe te ka one mera narifa nebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tiwa tikahiyari ya tihiyaramone me ati naboneke. Tihiyaramone tini ya tiwa me kahiyarabone tike\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","\"Mowisei ati kakamina mati, fariseo mati. Tera te yokohaba te amake, te ati boti hiyari karo. Nokobi te boko kanake, me tokiyomaribone karo Teoso ka towisawa taboro ya. Teoso ka towisawa ya te tabarabone teke. Me one Teoso ka towisawa ya me tabarihi, naboneke te ehene\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","\"Mowisei ati kakamina mati, fariseo mati. Tera te yokohaba te amake, te ati boti hiyari karo. Yama yabo ya te tokate te amake, hawi toha, ma toha na ya, bara me te kanawanahabone te, yama te kamina te ati me nofahabone te. Me te kanawana me tokatehaba me amake yama hiyara ya, fara te nima\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","\"Tera te yokohaba te amake. Te noko awara hawi te yofi kanahabone te ati te te amake me one ni ya. Te ati e teha te amake ahi: 'Tika yama ta tinahabone tina teboro ino hiri tina yama ta tiri ya Teoso tiwa kakorebonaka. Yama ta tinahabone tina teboro ka oro ini hiri tina yama ta tiri ya Teoso tiwa kakobonaka. Haha yama ta tinahabone tike, Teoso tiwa kakorabona karo', te ati teha te amake. ");
INSERT INTO jaa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yama te watokere. Te noko awakere. Teboro ta amosaka. Teboro ka oro aamosa raba ke. Teboro ka oro Teoso ka yama amake, Teoso ka teboro tohe karo. ");
INSERT INTO jaa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te ati e teha te amake ahi: 'Teoso ka yamabone ta tinahabone tina teboro ka tana ini hiri tina yama ta tiri ya Teoso tiwa kakorebonaka. Teoso ka yamabone ta tinahabone tina tana ka bani ino hiri tina yama ta tiri ya Teoso tiwa kakobonaka. Haha yama ta tinahabone tike, Teoso tiwa kakorabona karo', te ati teha te amake. ");
INSERT INTO jaa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Te noko awakere. Teboro ka tana ta amosake. Bani aamosa raba ka, kawahari tana ya. Teoso ka bani amaka, kawahari teboro ka tana ya, Teoso ka teboro tohe karo. ");
INSERT INTO jaa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bani ino hiri tina tana ini hiri tina tiwa awine tike. ");
INSERT INTO jaa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Teboro ino hiri tini ya Teoso ino hiri tina tiwa awine tike, wine kari teboro ya. ");
INSERT INTO jaa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Neme ini hiri tini ya Teoso taboro ino hiri tina tiwa awine tike, Teoso ino hiri tina tiwa\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","\"Mowisei ati kakamina mati, fariseo mati. Tera te yokohaba te amake, te ati boti hiyari karo. Yamata tehe kote te ta teha te amake Teoso ni ya, Teoso yama hinofa yokana te hiri ra te. E ka one me e narifabone Teoso ati te amaka. Teoso e nofahabone ati, te amaka. Yamata tehe kote e ta na Teoso ni ya afa yama aamosa raba te amake. Teoso yama hinofa yokana e hiri na amosate amake mata ya. ");
INSERT INTO jaa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Te noko awara me one ka hawibone te yofi kanahabone te ati nineke. E ka owa nima te nineke, yama abe itihari faha ya, yome hinisarabonehe. Kamero nafihi ta te yome tonisate te amake\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","\"Mowisei ati kakamina mati, fariseo mati. Tera te yokahaba te amake, te ati boti hiyari karo. E ka owa hine ya yama wiye mese soko hina nima te nineke. Te boti ta hiyasa kere mata. Makoni yinero tamehi te nofineke, te ka one me ka yama yabi te nofaha te. ");
INSERT INTO jaa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo mati. Te noko awakere. Kobo tori ta soko ni te tai tohi ya yama amosake. Kobo tori te soko ni ya mese amosaboneke\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","\"Mowisei ati kakamina mati, fariseo me te toha na te. Tera te yokohaba te amake, te ati boti hiyari karo. Tama nima te nineke, keteharo tita sasawa na ya. Tama mese amosa boti ta hiyakere, e tone ni karo, yama bisaha toha na ihi. ");
INSERT INTO jaa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Te ehene amosa me one awaha te taminamone me ati te me amake. Te taminakere, te ati boti hiyara ihi, Teoso yama hinofa hiri ni te nofara te. Hine ya te amosamone me ati nabone te ati te te amake\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","\"Mowisei ati kakamina mati, fariseo mati. Tera te yokohaba te amake, te ati boti hiyara ihi. Teoso ati kakamina me tamebone te hiri teha te amake, amosaro. Me ihi amosa me tame te kanahatote te amake atoribone ya, amosabonehe, ");
INSERT INTO jaa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","te ati e ni ya ahi: 'E ka iti bote me ya e tabi ya, Teoso ati kakamina me e waka renemete e amake', te ati te te amake. ");
INSERT INTO jaa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tera te kaminineke fara me te, me ka noti me te tohaha te, Teoso ati kakamina me me nahabihemete me ka noti me te. ");
INSERT INTO jaa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Fara te ka iti bote me ihimete nima te ehene nineke. ");
INSERT INTO jaa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Makarawa nima te nineke, maka biterawaha, komarawaharo. Te hasi raba te amake, te tokaha te inamati me tabori ya\". ");
INSERT INTO jaa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","\"Owati te kamitahi. Teoso ati kakamina me oyosehabana oke te ni ya. Era kakanawana me toha, me one toha, naboneke, yama me watoha mati. Me one te waka naba me amake. Me one te si tokanihaba te amake awa era nanabowa ya. Me one te kosi naba me amake te ka sinakoka ya. Me te kiyo nawarehaba te amake sitati nafi nima. ");
INSERT INTO jaa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Me ahaba me manakone te nahabihaba me amake, me ihi amosa mati. Tai tohehimatamonaka hari, Abeo, yama amosa hiri ne ahabari. Yotohimatamonaka hari, Sakaria, Barakia biti. Te nabowematamonaka, kobo tonamakematare ya teboro ya, teboro wai ka yama baikani ya. Me one tamehemetemoneke me te waka na mati. ");
INSERT INTO jaa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Haha te ka iti bote me hiri hinehemete manakone nafi te nahabihaba te amake. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","\"Serosarei, Serosarei. Teoso ati kakamina me te waka teha te amake. Te ni ya Teoso mera yosehi me te waka, teha me amake, yati ibe ya me te banaha mati. Tera okasomabone ote ama oke. Arakawa fana nima onahabone onahara oke, biti mera kasomaro he bofe ya, biti mera bari kanaharo. Tera okasomahabone onaha owa ni ya te ati hiyakere. ");
INSERT INTO jaa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Owati te mitahi. Teoso tera kakosehibonaka. ");
INSERT INTO jaa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Owati e nara oke ahi: Owa te awamarahaba te amake mata. Manakobisa owa te awamatasatehaba te amake, te ati e ni ya ahi: 'Kakehareka Teoso ati ehene. Teoso hinofa hika', te ati tehaba te amake\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Teboro wari ka yama ya Sesowi yana tone tokomemarika. He ya tataba yama me yofi kanahamaroke, teboro ka yama, hiwahabonehe, amosaro. ");
INSERT INTO jaa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ati yana nematamonaka. \"Te awaha awine, nafi? Hahi yobe nafi me nabowaba me amake. Yama bari kani hasi naba watamarahaba amake. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sesowi tokomemarika orifa wati ka atami ya. Itari he ya tataba me ya tabi ohari me aate hinehimarika. \"Yama amo ni e ni ya natehaba amari, afa yama? Tikamibone ka yama ya himata yama ota awahaba ota amari, Teoso hinamoaro, yama nafi ahabibone ka yama ya?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sesowi ati yana nemarika. \"Tera me keyehariyahi. ");
INSERT INTO jaa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Me tamaha me kakehaba me amake, owamone hine me toniha mati. Me ati e naba me amake ahi: 'Kirisito ama oke', me ati naba me amake, me tamaha me me keyeha mati. ");
INSERT INTO jaa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yama mowa ni tamine te mitahaba te amake. Me tamine te mita, naba te amake, me abe mowa nabone me ati na mati. Te watorabone teke. Afa yama kakehaba amake, Teoso ati ehene. Yama nafi ahabaraba amake mata. ");
INSERT INTO jaa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bara me abe mowa naba me amake. Towisawa me toha naba me amake, me abe mowa na mati. Me tafeba watamaraboneke. Wami behe naba amake tabora nafi ya. ");
INSERT INTO jaa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yama nafi ahabarahaba amake mata. Yama hiyara yana tobone ka yamabone amake haro. Yama hiyara one nafisa naba amake mata\". ");
INSERT INTO jaa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","\"Tera me watahaba me amake, tera me katomabone mati. Tera me waka naba me amake. Bara me nafi tera me kakoaboneke, owa te nofi karo. ");
INSERT INTO jaa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Me tamaha Teoso nofi me fawa naba me amake, me ihi hiyara mati. Me abe ta naba me amake me one ni ya, me abe nofara mati\". ");
INSERT INTO jaa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Teoso ati kakamina memone me ati naba me amake, me tamaha mati, keye me hiri na mati. Me me keyehaba me amake, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yama hiyara me hiri naba me amake kasiro ya. Makoni me one nofi me fawa naba me amake, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Me one Teoso nofi me fawa ra me ta Teoso me hikasomahaba me amake. ");
INSERT INTO jaa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hiyara amosa me kaminaba me amake tabora nafi ka me ni ya, Teoso ka towisawa me kamina mati. Faya yama nafi ahabatehaba amake waha\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","\"Tanieo Teoso ati kakamina yama hikaminehemete te awi ya, te tokomaba te amake yati nemeha ya, Soteya ka tabora ya te sawiha te. Tanieo yama habosia kaminematamonaka, wareharo teboro toro ya\". (Oko yama hani te ki na yama okominaha te watohi.) ");
INSERT INTO jaa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","\"Yobe bari ya tiwariha tikamabana tike hibati ya. Tikisami ya tikiyomamarabana tike yobe ya, tika yama tinakamahaba tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Fatara ya yama ahi tina tokomakabote tinahabone tike. Tikamarabone tike tabora ya, tika makari tinakamahaba tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Me fanawi nabati weyeri narawa kokoriri narawaboneke. Me fanawi one matehe yoari fehe hifarawaha kokoriri narawa naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Teoso te aate niyahi, haha yama wehe sabato toharibone karo. Teoso te aate, niyahi, sire yama toharibone karo. ");
INSERT INTO jaa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yama e naba watatera amake, hiyararo, haha nima naro. Yama e naba watamaterihi naba amake, hiyararo. ");
INSERT INTO jaa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Haha yama Teoso sene nimehibonaka, hinaka me ihi, me hikatikaha mati. Ehene e re ya me nafi ahabene me amake\". ");
INSERT INTO jaa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","\"Haha yama tohi ya me ati e naba me amake ahi: 'Hahi Kirisito amaka', me ati naba me amake. 'Efe amaka hari', me one ati, naba me amake. Me ati te nofariyahi. ");
INSERT INTO jaa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Me one Kirisitomona me ati naba me amake, keye me hiri na mati. Me one Teoso ati kakamina memone me ati, naba me amake, keye me hiri na mati. Yama me namohaba me amake, fotaharo, me hiwatoharo. Me tamaha me me keyehaba me amake. Haha Teoso me hikatika me me keyehene me amake fahi. ");
INSERT INTO jaa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Te ati katamoriyahi, haha yama okominaha ya. Yama kamini tai ohine oke, te watobahabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Me ati e naba me awineke ahi: 'Te awa ha, sawihari yama honara ya', me ati naba me amake. Te tokomakeriyahi he ni ya. 'Te awa ha, yobe owa boti ya sawihari', me one ati, naba me amake. Me ati te nofariyahi\". ");
INSERT INTO jaa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","\"Neme ka Owa kami e tehiba amaka ahi, yama yebe kana nima. Yama yebe kana tokate amake neme kowani ya, oyaharo. ");
INSERT INTO jaa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Neme ka Owa kame ya me nafi hiwatoba amaka. Bani ahabe ya boko me hiwasiba amaka\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","\"Afa yama nawaha ahabi ya bahi owihiba amaka. Abariko oyamarihi neba amaka. Amowa me foro naba me amake. Neme nafi hihiya nawahaba amake. ");
INSERT INTO jaa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Faya neme ka yama fotokiaba amake, Neme ka Owa kamabona ka yama yabori ka yama ya. Bara me nafi ohi naba me amake. Faya Neme ka Owa me awahaba me amake kamahari, sawihari neme sabi boti ya, kitahari, oya kanikimahari kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hohori ati saihaba amake, Teoso he nanarifa mera yose karo. Haha me hikatikaha me me yoro tokaniwamaba me amake, me sawiha mati yama nafi ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","\"Yama te watohaba te amake, fiko ka yama nima naro. Fiko afe yati kitara afe yanaha te awaha yama te watote te amake, yama hiwe ka yama, yabokiraharo. ");
INSERT INTO jaa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Fiko ka yama nima Neme ka Owa ka yama naboneke, kamahari. Haha yama okominaha te awi ya yama te watohaba te amake, Neme ka Owa kamabona ka yama, yabokiraharo. ");
INSERT INTO jaa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Te one me sawisa naboneke haha yama okominaha nafi kaki ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hine ya neme ahaba, wami ahaba, tehaba amake. Owati ta ahabateraba amake\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","\"Teoso biti kamabona ka yama wehe e watotera e amake. Teoso nanarifa me hiwatorihi, Teoso biti hiwatorihi, hite amake. Okobi ta hiwato hike, ohariari. ");
INSERT INTO jaa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowe ka yama nima Neme ka Owa kami ka yama naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Teoso ati ehene fa fowe nafihabone ati ne ati me hinofarehimatamonaka. Fara me tafi toha, fara me abe yabi toha, nemetemoneke. Faya Nowe tokiyomehimatamonaka hinaka fotowati ehebote tori ya. ");
INSERT INTO jaa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Fara yama tohahamone me ati na fa fowe nafiha mera bata kanehemetemoneke, mera nahabihabanihi, me nafi. Afa yama nima Neme ka Owa kami neba amaka. ");
INSERT INTO jaa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","E naboneke ahi: Me famaha fatara ya yama me ahi na owa Teoso hekama, owa toakosa, nebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Fana famarawa tiriko ahi narawa one Teoso hekama, one toakosa, naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Te ati katamoriyahi. Te ka Hiti kamaba ka yama te watokere. ");
INSERT INTO jaa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Te ehene e riyahi, e ka owa ehene nima, yobe kihahari. Yama boboti yobe nahoti tokiyomehimatamonaka yama soki ya, yobe hiti hiwatorahari. Yama boboti kakiba ka yama watohimanaha, hikarawatonamata amaka, tonokoari, yama soki ya. Yama boboti tokiyomarenamata amaka, ehene. ");
INSERT INTO jaa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Te e nabisabone teke ahi, te ati katamoraha te. Neme ka Owa tera bata karayaho\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","\"Te e nibana, e ka owa ka yama aahi nima, yama watohari, hinaka yama ahi ni amosaro? E ka owa ka yama aahi amose ya hinaka hiti yama hikaminaha yokana hiri nebonaka. Hiti yana tone yama yabo ya tokome ya hinaka yama aahi yosehibonaka, hinaka yobe kakatomehibonaha. Hinaka yama aahi me one tafebone ta nebonaka ati ehene, yobe ka me nafi, fara yama we nima. ");
INSERT INTO jaa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hiti kame ya yama hikaminaha yokana hinaka yama aahi hiri ne ya, hinaka yama aahi nofehibonaka. ");
INSERT INTO jaa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ha hinehibonaka, hiyosebonaha, hinaka yama nafi kakakatomabonaha waha. ");
INSERT INTO jaa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hiyare ya hinaka hiti yana tone ya ati boti e nebonaka ahi: 'Oko hiti kamakabote kara', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yobe ka me one kosi nebonaka. Hine ya tafa, fi fawa, hano, nebonaka, me one ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hiti kame ya bata hikanamehibonaka, he noki rari. ");
INSERT INTO jaa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hiti kosi hinehibonaka, ehene hiyarari. Hiti hibehibonaka, me one ya tabahari, yama hiyara me hiri na mati. Me ini yiki tokana, me ohi, te me amake fahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","\"Teoso ka towisawa ka me e nineke, atonarawa nima, 10 narawaro. Me ka owa fanehibona ati ne kamaki he noki narawabone ati narawemetemoneke. Nabarina bokori karawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","5 narawa yama watorawa, 5 narawa yama watorawarihi, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Yama watorawa yama wiye one ya nabarina fehe tama karawemetemoneke. Onerawa ta nabarina fehe tama karawaremetemoneke, yama wiye one ya, yama watorawari karo. ");
INSERT INTO jaa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Me ka owa kamakikabote rematamonaka, fanehibonaha, atona noki hirawari. Nokobisa hiwasirawa amo narawemetemoneke, nafirawaha\". ");
INSERT INTO jaa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","\"Yama soki enoki ya me one ha ni yana nemetemoneke. 'Te awa hari, kamakiari. Te kobo naho', me ati nemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","\"Atonarawa tafirawaha nabarina ka bafi namosamarawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abe hiyararawemetemoneke. 'Ota ka nabarina owinima narawineke. Nabarina fehe isi ni te ta nahi ota ni ya', ati narawemetemoneke, nabarina fehe kihamarawaraharo, yama watorawari karo\". ");
INSERT INTO jaa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","\"'Nabarina fehe ta ni ota nofakere. Ota ka nabarina fehe ota ta ni ya nabarina fehe watamarahaba amake, ota kabana. Te ka nabarina feheba te kanikahi', one ati narawemetemoneke, yama watorawaharo\". ");
INSERT INTO jaa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","\"Tokomarawemetemoneke, nabarina fehebone kanikarawabonehe. Nowatirawa ya maki fanebona kobo nakematamonaka. Atonarawa nabarina fehe kiharawa he ya tabarawaha tokiyomarawemetemoneke marina ka yobe ya. Faya nokobi me bari hikawamemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","\"Nowati ya atona onerawa kamarawemetemoneke. 'Nokobi se tikanahi, ota tokiyomamakibone karo', ati narawemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","\"Me ka owa fanehibona ati yana nematamonaka. 'Tera owatera ama oke. Keye amakere', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","\"Makoni te ati katamoriyahi. Neme ka Owa kamabona ka yama te watorineke\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","\"Hiyara one okominabone oke, Teoso ka towisawa ka me okomina owa. E ka owa yana tone tokomebona ati nematamonaka tabora bara ya, yama yabo ya. Hinaka yama aahi mera ha nematamonaka, me hekawabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Barata kote 5 na ta nematamonaka hinaka yama aahi owa ni ya, yama wato yokana tohahari. Owa yama wawato raba ne ni ya barata kote famaha ta nematamonaka. Kote oharia ta, nematamonaka owa ni ya, yama wato nafirari\". \"Tokomematamonaka tabora bara ya. ");
INSERT INTO jaa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","He nanarifa owa barata kote 5 na kihe yana ne yama ahi ne hinaka barata totamemetemoneke. Hinaka barata kote 10 nawahemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","He nanarifa owa barata kote famaha kihibehi ka barata nafimisa 4 nawahemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","He nanarifa owa barata kote oharia kihe yana ne hoti wi ne yinero kehemomatamonaka hoti ya\". ");
INSERT INTO jaa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","\"Yama toyabo ya me ka hiti kamehimatamonaka. Hinaka yinero me ta hikanamehibona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","He nanarifa owa barata kote 5 na kihibe barata 10 na kakamematamonaka. 'Oko hiti barata kote 5 na ta tina nafimisa kote 10 nawahake waha, oko yama ahi ni ihi. Barata tiwa haro, tamaharo, tika baratabonehe', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","\"Hiti ati yana nematamonaka. 'Tiwehene amosake. Tiwa onofa oke. Yama tamara ta ona kakatomi tinatamina tiwa awine tike. Yama tamaha ta owahabana oke, tekatomabana waha. Yayai tinahi. E mari nabone eke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","\"He nanarifa owa barata kote famaha kihibe kamakimatamonaka. 'Oko hiti barata kote famaha ta tina nafimisa 4 tohawake waha, oko yama ahi ni ihi. Barata tiwa haro, tika baratabonehe', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","\"'Tiwehene amosake. Tiwa onofa oke. Yama tamara ta ona kakatomi tinatamina tiwa awine tike. Yama tamaha ta otasabana oke, tekatomabana. Yayai tinahi. E mari nabone eke', hiti ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","\"He nanarifa owa barata kote oharia kihibe kamakimatamonaka. 'Oko hiti tihamamone onaha ama oke. Tiwati ihi me one yama me koro na me ka yama me koro hinaha boni hataha tikabatemone ama tike, yama koro tira tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Owatoa ama oke. Tika barata okehemoha ama oke wami hoti ya. Tika yinero amaka hari', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","\"'Tiwehene hiyakere, yama ahi ni tinofara tiwa. Me one ka yamata okobatehamone tinaha tiwa awine ti, me koro hinaharo, owati ihi? ");
INSERT INTO jaa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Owa tiwatoa oko yinero tinihene ama tike bako ya, nafimisehibana', hiti ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","\"Me one hiyarematamonaka. 'Hinaka barata te yabahi, te ta nabana owa ni ya, barata 10 na kihahari. ");
INSERT INTO jaa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","E ka owa yama tamaha kihe hinaka yamabone tamaha ta onamakehabone oke. E ka owa yama tamara kihe hinaka yama oyabamakiabone oke. ");
INSERT INTO jaa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Oko yama aahi ehene hiyare te koro towitiho yama soki ya. Me ohi naboneke fahi, me ini yiki tokana mati', ati nematamonaka\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","\"Neme ka Owa kamehiba amaka, oyene kitahari, Teoso nanarifa me ya tabahari, me nafi tohaha mati. Kame ya itaribonaka towisawa ka katera ya. ");
INSERT INTO jaa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tabora nafi ka me nahoriaba me amake nokosi ya. Mera ebe kanebonaka. Ofeya nanarifa ehene nima ehene nebonaka, mera ebe kanahari, ha ya ofeya me toha, ha ya kabara me toha, nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ati ehene ofeya me nahoriaba me amake hinaka kanihina wani ka ya. Kabara me ta me nahoriaba me amake hinaka yasoka ka ya, ati ehene. ");
INSERT INTO jaa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Faya towisawa mera hiyareba amaka, me nahoria mati hinaka kanihina ka ya, ati e nari ahi: 'Te kamahi owa ni ya. Okobi tera nofaka. Hibati ya okobi yama nafi hiri ne tera wati nawahematamonaka. Ati ehene me one te yosetehaba te amake, e tabaha e. ");
INSERT INTO jaa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ofimiha otefebone te ta, bakasi owaha oko fahabone te ta, na te amake. Bara me tabori ya osawia owa te ha na te amake, amo onahabone owa te ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Makari okihara oko makaribone te ta, na te amake. Yama kome owa ona owa te narifa na te amake. Kateya ya ofoya owa te nakamake na te amake', towisawa ati neba amaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","\"Afa me ihi amosateha me ati yana naba me amake. 'Ota ka Hiti, himata yama ya titefebone ota ta nani ota amari? Tiwa ota watora ota awineke, tifimiha tiwa. Himata yama ya tiwa ota nafawani ota amari? Tiwa ota watora ota awineke, bakasi tiwaha tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Himata yama ya tiwa ota ha nani ota amari, amo tinahabone tiwa ota ka yobe ya? Bara me tabori ya tisawia tiwa ota watora ota amake. Himata yama ya tika makaribone ota ta nani ota amari? Tiwa ota watora ota amake, makari tikihara tiwa. ");
INSERT INTO jaa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Himata yama ya tiwa ota narifani ota amari, yama kome tiwaha tiwa? Himata yama ya tiwa ota tonakamakiani ota amari, tifoya tiwa kateya ya?' me ati naba me amake\". ");
INSERT INTO jaa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","\"Faya towisawa ati yana tasehiba amaka. 'Me te narifa te amake haro, owa me nofaha mati, yama me kihara mati. Me ka owa ohari te narifa owa te narifa na te amake. Keye amakere', ati nebonaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","\"Faya me one hiyareba amaka, me nahoria mati hinaka yasoka ka ya. 'Te tokomahi ha te. Teoso tera nofakara. Yifo hiri ni ya te tokomaba teke, owiteraro. Teoso yifo hiri nematamonaka, Satanaisi toborobonaha, he nanarifa me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ofimiha otefeba te ta rihi, bakasi owaha oko fahaba te ta rihi, na te amake. ");
INSERT INTO jaa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bara me tabori ya osawia owa te ha rihi na te amake, amo onahabone owa te ka yobe ya. Makari okihara oko makaribone te ta rihi na te amake. Yama kome owaha owa te nakamakerihi na te amake. Kateya ya ofoya owa te nakamakerihi na te amake', towisawa ati neba amaka\". ");
INSERT INTO jaa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","\"Me ati yana naba me amake. 'Ota ka Hiti himata yama ya tiwa ota narifarahani ota amari? Tiwa ota watora ota awineke, tifimi, bakasi tiwa, bara me tabori ya tisawi, makari tikarihi, yama kome tiwa, kateya ya tifoya, tina tiwa', me ati naboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","\"Ati yana tasehiba amaka. 'Me te narifara te amake, owa me nofa mati, yama me kihara mati. Me ka owa ohari te narifara owa te narifarihi na te amake', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Manakobisa me tokomaba me amake yama hiyara ya, ahabihinateraro. Me ihi amosateha me ta me tokomakehaba me amake Teoso taboro ya, me winahabone mati Teoso ya me taba mati fara yama tohaha ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mera kanawani hawa tohehimarika haha yama ya. He ya tataba mera hiyaremarika tasa. ");
INSERT INTO jaa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"Yama te watoke haro, Basikowa yana tobone karo yama wehe famaha nowati ya. Neme ka Owa me ta naba me amake me one ni ya, me hinabowebonaha, me hinawanahari awa ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sasetoti me ka hiti me ya me ka hiti me tabaha heoniao me hiri nemetemoneke Kaifa ka yobe ehebote ya, sasetoti ehebote tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Me abe hiyara Sesowi me keyehabone me ati nemetemoneke, me hiwatebonaha, me hinabowebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wati me hinofarematamonaka Basikowa ka ayaka tohi karo, me tamaha me me nakome karo. Me me mono rabone me ati nemetemoneke, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sesowi sawihimarika Betania ya, Simao mese hiyare ka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Fanawi kamakiamaroke Sesowi ni ya, esitarato tama kanaharo yama wiye yati yama ni tohaha ya, manakone nafiharo. Mesa ya Sesowi tafehi itari tati ya esitarato sika nisahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","He ya tataba ihi me awati me yawahamaroke. \"Himataba esitarato katomineri, manakone nafiharo? ");
INSERT INTO jaa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yama amosene amake, esitarato ta ni ya, yinero manakonebana, yinero e ta nibone karo me honara me ni ya\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sesowi me ati hiwatoemetemoneke. Ati yana nematamonaka. \"Himataba fana ihi e na ihi te hora kineri? Ihi amosake owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Me honara me sawi fawa teraba me amake te ni ya. Ha owa ta oko sawi fawa nabone oke te ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Fana owa ketehineke esitarato ya, oko kamobone ayata tohi karo. ");
INSERT INTO jaa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yama toyabo ya, hiyara amosa yama nafi ya me kamini ya, fana ihi me kamina, tehaba me amake. Ihi me wati hiwahatehaba amake. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Faya me 12 na me ka owa Yota tohe tokomakehimatamonaka sasetoti me ka hiti mera hiyarebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'Yinero e neba amara, te ta nari owa ni ya, ta one ya te ni ya?' ati nematamonaka. Moweta barata tohehi 30 ne me tomi kanehemetemoneke, me ta hinehibanoho Yota ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Faya ati boti yama nima nematamonaka, Sesowi ta nabona ka yama, me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Basikowa yana toni ka yama wehe tai toaha ya Sesowi he ya tataba me aate hinehimarika. \"Hika ya Basikowa ka marina tafeba ota wasiribe, e tafibone karo?\" me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","\"Sitati ya te tokiyomi ya e ka owa te aate niyahi, te ati e na te ahi: 'Borofeso ati e nareka ahi: Oko amo nibone yabokikere. Owa ya tataba me ya otaba Basikowa ka marina tafe ota kabahabone otake tika yobe ya', te ati nabone teke\". ");
INSERT INTO jaa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sesowi yama hikamina me hiri namaroke, Basikowa ka marina tafebone me wasiha mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yama soki ya he ya tataba me ya tabehi tafehimarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Me tafaha Sesowi ati yana nemarika. \"Te ka owa owa ta neba amaka me one ni ya. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Me yawaha me oohariki na Sesowi me aate namaroke. \"Ota ka Hiti owaba ama ha owa?\" me ati narawamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","\"Te ka owa owa ta nebonaka, ota fami bao sa nifikimi kari. ");
INSERT INTO jaa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neme ka Owa e nebonaka, fara yama me hikaminehemete nima, Teoso ka yama hani ya. E ka owa hiwa yokohiba amaka, Neme ka Owa ta ne ya. He ni ya yama amosenemete awineke, watare ya\", Sesowi ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yota aate hinehimarika, ta hinehibona ati nari. \"Habi owaba ama ha owa?\" ati nemarika. \"Ee, tiwaboneke, fara tiwa tikamina tiwa\". ");
INSERT INTO jaa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Me tafaha Sesowi bao itihi ati yana nemarika, \"Teoso faya amake tiwehene\", ati nari. Bao ebe ne mera kakawemarika he ya tataba mati. \"Bao te warara nahi, te kabehibana. Hahi oko ime amaka hari\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kobo tama ne ati yana namatasehimarika, \"Teoso faya amake\", ati nari. Kobo ya mera kakawemarika. \"Te nafi fawahi. ");
INSERT INTO jaa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Haha fi oko emene nima nineke haro. Ohabi ya Teoso te ya tabe kotarato yati hiri nebonaka. Ohababone oke, me ka yama hiyara Teoso fawa nibona karo. ");
INSERT INTO jaa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ofa fehe ofamaraba ama oke mata. Ofamateba amake, te ya otaba owa, towisawa ohi ya, okobi ati ehene. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Teoso tahi me hiri na me tokomamaroke orifa wati ka atami ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sesowi mera hiyaremarika. \"Te nafi owa kakosabone oke. Afa yama sokibone amake haro. Teoso ka yama hani ati e te amake ahi: 'Ofeya me nanarifa onahabihe ya ofeya me tokarikosahaba me amake', Teoso ka yama hani ati te amake. ");
INSERT INTO jaa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ohaba okitamahaba ama oke. Tai owamaba ama oke Karireya ya, te nokosi ya\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Betiro ati yana nemarika. \"Me nafi tiwa me kakosi ya tiwa owakanakosarabone oke, ha owa. E famahabone eke, ha owa\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sesowi ati yana nemarika. \"Haha yama soki ya owa tiwateramone tinahabone tike me one ni ya. Tiwati yana ni terei nabone tike, tiwati e na tiwa, arakawa ha namatare ya mata. Keye amakere\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","\"Owati yana rabone oke, tiwa owateramone ona owa. Keye amakere. E fama me one era nabowabone me ati na tiwa owakanakosarabone oke\", Betiro ati nemarika. Sesowi ya tataba me nafi ati e namaroke, Betiro ati nima. ");
INSERT INTO jaa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sesowi me ya tabehi me tokomamaroke awa boti Ketisemani yama ini tohaha ya. Sesowi mera hiyaremarika. \"Okomabana oke, ora onahaba owa hike ya. Te naorihi ahi\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Betiro ohari Sebeteo biti me famaha me ya Sesowi tabehi me tokomamaroke. Faya Sesowi kokoriri nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","\"Owati boti kokoriri ke. Ahabinima one oke, kokoriri oni karo. Te nahori ahi, te tonokoa te, owa te noki nabone te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hike ya toka ne sonarisehimatamonaka, boko tonihe ora nari. \"Abi haha kobo okofawarabone onahara oke. Okofawahabone tini ya okofawahaboneke. Yama onofa ya owehene toharabone oke. Fara yama tinofa ta hiri onahabone oke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kame he ya tataba me terei na mera wasimematamonaka, me amo nani mati. Betiro hiyarematamonaka. \"Te kitara te awineke. Bahi te nahariha owa te noki nabone ona te tonokokere. ");
INSERT INTO jaa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Te tonokohi, te ora na te, te ehene hiyara wataribone karo, inamati tera totomi ne ya. Te ati boti amosa yama amosa te hiri nabone te ati na yama tera kasawarineke, te kitara te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tokatase ora tasehimatamonaka. \"Abi oko hasi ni tinofari ya hasi orihi onahaba owa awine oke. Fara yama tinofa hiri onahaba ama oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kamatase mera wasimatasehimatamonaka, me amo nani mati, nokobisa me koro hikanani mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tokatase ora tasematamonaka, fara yama hikamina kaminatasahari. ");
INSERT INTO jaa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kamatasehimatamonaka he ya tataba me ni ya. \"Te amo tasine? Te hasi nine? Te tafihi. Oko amo nibone amake haro. Neme ka Owa me ta kabote naboneke me ihi hiyara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Te nahomisahi. Hima, te awa hari, kamakiari, owa ta nebonaha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","He ya tataba mera hiyarasa ne ni ya Yota kobo namakimarika, me 12 na me ka owa. Me tamaha me ya tabehimarika, yimawa toha, mata toha ne me bokori na mati. Sasetoti me ka hiti mati, me nafi ka hiti mati, me na me me yosehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yota mera hiyaribehimatamonaka, Sesowi me watohabone mati. \"Efebonaka, noko bako komi onakihari. Noko bako komi onaki ya te watehibonaka, efe\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Me kobo namakia Yota towanawitimarika Sesowi ni ya, hibati ya. \"Habi afa ama ti?\" ati nemarika, he noko bako komi nakehari. ");
INSERT INTO jaa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sesowi ati yana nemarika. \"Habai fara tiwati nima tinahabone tike\", ati nemarika. Me one kamakia Sesowi me watahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Faya Sesowi ya tataba me ka owa yimawa soba towiti sasetoti ehebote ka yama aahi owa narabo ra tari nabasemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","\"Tika yimawa yoko tinamahi. Yimawa ya me tinahabi ya tihababisaba ama tike, yimawa ihi bisa. ");
INSERT INTO jaa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yama tiwatorini? Okobi aate onehemenehe, he nanarifa me tamaha mera yosehina amaka, owa me kasomaba mati, me tama kanikimaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Teoso owa kasome ya Teoso ka yama hani ya yama hikaminemete hiri orehene ama oke\", ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sesowi me tamaha mera hiyaremarika. \"Te kamakine owa ni ya, yimawa toha, mata toha ne te bokori na te, owa te watahabone te ati na te? Kofeno mono onahamone te ati na te awineke. Yama we nafi ya owitarehara oke teboro wari ka yama ya, me okanawana owa. Owa te watara teke fahi. ");
INSERT INTO jaa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Te ehene e na Teoso ati ehene amaka. Te ehene e nineke, Teoso ati kakamina me ati nima, Teoso ka yama hani ka me ati\", ati nemarika. Faya he ya tataba me nafi kana nawaha me hekanakosehimarika. ");
INSERT INTO jaa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sesowi me hiwate me hekamehimatamonaka Kaifa ni ya, sasetoti ehebote tohahari. Mowisei ati kakamina me ya me ka hiti me tabehemetemoneke, Kaifa ya me tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Betiro yotoba nematamonaka hike ya. Tokiyomehimatamonaka sasetoti ehebote ka yobe taboro ya. Sasetoti ehebote nanarifa me ya tabehi itarimatamonaka, yama watohibonaha, Sesowi me hiri kani ka yama. ");
INSERT INTO jaa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sasetoti me ka hiti me ya soteo me ka hiti me nafi me tabaha Sesowi ahabebona me ati nemetemoneke. Me one me siba nemetemoneke, Sesowi me kaminabone mati, ehene hiyaremona me ati nabone mati, keye me hiri na mati. ");
INSERT INTO jaa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Me tamaha keye me hiri kene yama ati remetemoneke, mera kasawariharo. Yama totoyabo kawahi ya me famaha me ati yana kanehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","\"Hahi ati e nareka ahi: 'Teoso ka teboro nahabi onofe ya onahabiha onehibonaka. Teboro onahabihe nowati ya hiri onamatasehibonaka yama wehe terei na ya', ati nareka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sasetoti ehebote yana namise Sesowi aate nematamonaka. \"Tiwati watarine? Keye me hiri na me awine, tiwatimone me kamina tiwa?\" sasetoti ehebote ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sesowi ati watarematamonaka. Sasetoti ehebote ati yana tasehimatamonaka. \"Tiwati yana nahi, tiwa tikamina tiwa, Teoso yati ne nokosi ya. Kirisito ama ti? Teoso biti ama ti?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sesowi ati yana nematamonaka. \"Ee, fara tiwati nima yama nineke. Owati e nara oke ahi: Neme ka Owa te awatehaba te amake, itariari Teoso kitehi ka kanihina ka ya, kamahari neme sabi boti ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sasetoti ehebote yawehi fara hinaka makari sibi karematamonaka. \"Ati hiyarareka Teoso ni ya. Me e ha namarabone eke, he me kaminaba mati e ni ya, ehene hiyaremona me ati na mati. Ati te mitahareka fara te, ati hiyarari Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Himata nima te ati ri?\" ati nematamonaka. \"Ahabebonaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Faya noko me firo hine noko me koho hiwiti noko bako me tao hikana, hinematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","\"Kirisito otara tikaminahi, Teoso ati kakaminamona tiwa. Hike tinoko koho towitira?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Betiro itarimatamonaka yobe beheri ya. Mera nanarifarawa me ka one oharia kakehemetemoneke he ni ya. \"Sesowi Karireya ka tohe te famaha te awineke\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Betiro ati hiyarematamonaka me nafi nokosi ya. \"Tiwati owato okere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Betiro yana ne tokomematamonaka nokobi wani ya. Fanawi one hiwe me one hiyaremetemoneke. \"Hehi Sesowi ya famahareka hari, Sesowi Nasare kari\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Betiro ati hiyatasarematamonaka, Teoso ino itihari. \"Hehi owatotere amaka hari\", Betiro ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bahi owa ya Betiro beheri ya me naoha Betiro me hiyaremetemoneke. \"Me ka owa ama tike. Keye amakere. Tiwa ota watoha otake. Karireya ka me ati tima tiwati nineke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Betiro ati yana tasematamonaka, Teoso ino itihari. \"Hehi owatotere amaka hari\", ati nematamonaka. Keye hiri ne ya Teoso hinabowebona ati nematamonaka. Hibati ya arakawa ha nibote nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Faya yama wati nawahematamonaka, aya Sesowi hikaminaharo. \"Arakawa ha namatare ya tiwati yana ni terei nabone tike, owa tiwateramone tinaha tiwa\". Betiro yana tone tokiyomame ohi nematamonaka kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hiba yama wa ni ya sasetoti me ka hiti mati, me nafi ka hiti mati, me na me abe hiyaremetemoneke, Sesowi nabowibona me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mano me hikamato me heke me ta hiwitimatamonaka kofenato Birato ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Faya Yota Sesowi awe ati boti yama kamine \"Sesowi ahabeba awaka, me ati ihi\", ati nematamonaka. Ehene nofamare moweta 30 barata tohehi ta tonamatasematamonaka sasetoti me ka hiti me ni ya, me ka hiti me ya me tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","\"Owehene hiyarara oke. Ta onahareka ahabebonaha, ehene hiyareba watarari\", ati nematamonaka. \"Ota ehene amakere. Fara tiwehene amake\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yota moweta 30 ne koro tonamematamonaka teboro ya. Faya tokomematamonaka. Fare hine nabowematamonaka, namiti sako tone yora towitiari. ");
INSERT INTO jaa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sasetoti me ka hiti moweta me yabehemetemoneke. \"Hahi moweta ya teboro ka yinero e yoro tokanirabone eke. Hahi moweta e ka owa me hinabowehi manakone amaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Me abe hiyara wami kote me kanikabone me ati nemetemoneke hehi moweta ya. Boti hihiri ka wamimetemoneke. Tama taboribone me hiri nemetemoneke haha wami ya, bara me abowi taboribonehe. ");
INSERT INTO jaa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Makoni wami e emene ino ya ini me hinawatemetemoneke. Fara wami ini tohasa nineke. ");
INSERT INTO jaa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Seremia Teoso ati kakamina tohe hikaminehemetemoneke, ati e nari ahi: \"Moweta 30 ne me wara tona wami manakone me nahabiharake, boti hihiri ka wami. Teoso owa hiyare ati nima me ihi narake. E ka owa manakone amaka, me ati narake, Ihayeo mati\", Seremia ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sesowi warehimatamonaka kofenato nokosi ya. Kofenato aate hinehimatamonaka. \"Soteo me ka towisawa ama ti, ha tiwa?\" ati nematamonaka. \"Ee, fara tiwati nima yama nineke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sasetoti me ka hiti mati, me nafi ka hiti mati, me na Sesowi me kaminemetemoneke, ehene hiyaremona me ati na mati, Birato ni ya. Sesowi ati yana rematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Birato aate hinehimatamonaka. \"Me ati timitarini? Tiwa me kaminara tike, yama hiyara tamaha hiri tinahamone tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sesowi ati yayanabiti rematamonaka. \"Hika\", kofenato ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kofenato soteo me ka owa ohari fifito toniha tohehimarika, fara Basikowa ka marina nima, me kibeha mati kateya ya. Mera aate ne me ka owa ino me hitihi yokana fito toniha tohehimarika. ");
INSERT INTO jaa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Afa yama ya me ka owa Bahaba tohe foyehimatamonaka kateya ya. Me nafi hiwatomarika, ehene hiyarari. ");
INSERT INTO jaa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Birato nokosi ya me me yoro hikaniwama faya Birato mera hiyaremarika. \"Bahaba fito onihabone te ati nine? Sesowi ta fito onihabone te ati nine, Kirisitomonaha?\" ati nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Me ka hiti Sesowi me ta na mera watohimatamonaka, me one tamaha Sesowi me nofi karo. ");
INSERT INTO jaa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Birato itarimarika sowisi ka katera ya. Itari fati ati ihi me ka owa kakehimatamonaka he ni ya, ati hikaminabonehe, ati e naro ahi: \"Hine naka. Hinaka yama hiyaraba watara awineke. Yama soki ya watari owehi kokoriri onahara oke kasiro ya\", ati namone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sasetoti me ka hiti mati, me nafi ka hiti mati, me na me tamaha me me hiyaramaroke, \"Bahababonaka\", me ati nabone mati. Birato Sesowi nabowehibona me tamaha me ati nabone me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kofenato ati yana nemarika. \"Hike te nofari, tasi onihebana te ni ya?\" ati nemarika. \"Bahaba\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","\"Himata nima Sesowi oniheba amara, Kirisitomonaha?\" ati nemarika. \"Te ba kanaho awa ya, ahabebana\", me nafi ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","\"Himatabana? Himata hiri rano hiyararo?\" ati nemarika. Hine ya me ha ni kitamisahamaroke, \"Te ba kanaho awa ya\", me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yama nihinaremetemoneke Birato ni ya, me ati e ni karo. He me mowa nima nabone me hinehemetemoneke. Ati ehene faha me kakama yehe soko nemarika me nokosi ya. \"Owati ihi amaraboneke, hehi ahabe ya. Te ati eheneboneke\". ");
INSERT INTO jaa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","\"Ee, ota ati eheneboneke. Ota ehene hiyara tohi ya yama hiyara manakone ota nahabihaba ota amake, fara me ota. Ota ka matehe manakone hinahabiha hinahaba amake\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Faya Bahaba tasi tonihemarika me ni ya. Ati ehene saotato Sesowi me kosi nemetemoneke. Faya saotato mera yosehimatamonaka, Sesowi me ba kanahabone mati awa ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kofenato ka saotato Sesowi me towakamehemetemoneke kofeno ka yobe Beretorio tohehi ya. Saotato me nafi me yoro tokaniwamemetemoneke, Sesowi me katomabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hinaka makari me sota hina makari mamawa na ya me weyeye hinihematamonaka, towisawa ka makari. ");
INSERT INTO jaa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tati boronebona me hikowemataka, atine kihaharo, towisawa tati borone nima naro, me weyeye hinihebanoho. Sesowi ka kanihina me tamama nihemetemoneke awa ya, towisawa ka awa nima naro. Faya Sesowi nokosi ya me isi yobati ya me naoha he me haha kanehemetemoneke. \"Soteo me ka towisawa, titaminahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Me firo hine hinaka awa me wara hina tati ba nari me hitamematamonaka, fara awa tama hinaha ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Faya haha kani me hawa hihe ya makari mamawa na me sota na fara hinaka makari ya me weyeye hinihamematamonaka. Me hekamematamonaka, awa ya me ba hikanebonaha. ");
INSERT INTO jaa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hawi ya me tokoma me ka owa me yosehamaroke, Sesowi ewenebona tiwa kanebonaha. Sireni kamatamonaka, Simao tohahari. ");
INSERT INTO jaa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Me tokoma me kobo tonamakehamaroke, yama ini Kokota tohaha ya. E tati tone ino amake Kokota. ");
INSERT INTO jaa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hinaka fibone me ta hinahamaroke, fi yoro tokanaro, yama bitari kitaha ya. Totomi hina fawi hinofarahamaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Awa ya me ba hikane hinaka makari me ebe hinahamaroke. Yama me were namaroke, makari me ebe nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Me naoha me hekatomemarika. ");
INSERT INTO jaa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yama hani me kanawanahamaroke Sesowi tati neme ya, hinaka yama hiyaramone kaminaro, ati e naro ahi: \"Sesowi amaka, soteo me ka towisawa\", yama hani ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yama boboti me famaha me me kanawikimamaroke Sesowi beheri ya. Hinaka kanihina ya owa kawa, hinaka yasoka ya owa kawa, nemarika. ");
INSERT INTO jaa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hawi ya me yaka na me haha hikanemarika, me tati me weori na mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","\"Fara tiwa tikasomahi, teboro tinahabihabone tina tiwa, hiri tinamebonaha yama wehe terei na ya. Teoso biti tihi ya tikisamahi awa ya\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sasetoti me ka hiti me ya Mowisei ati kakamina me tabaha me haha hikana hinematamonaka, me ka hiti me ya me tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"Me one ta kasome hiwa kasomi watore awaka fare. Ihayeo me ka towisawa amare? Awa ya kisamaho, ati e nofawabaya waha. ");
INSERT INTO jaa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Teoso hikasomebona ati nareka. Teoso hinofe ya Teoso hikasomehiba awaka hibayata ya. Ati e nareka ahi: 'Teoso biti ama oke', ati nareka\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yama boboti he ya me tabaha me ati yana, namaroke, he me hora na mati, awa ya me kawana mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bai nokorise ya yama kayomamaroke, yama nafi. Manakobisa yama soki fawa namaroke bai weo towawiti ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bahi weo towahawiti ya Sesowi ha nemarika kasiro ya. \"Teoso, oko Teoso, himataba owa tinaharikosine tiri?\" ati nemarika. Fara me atibisa amake haro: \"Eri, eri, rema sabakitani?\" ati naro. ");
INSERT INTO jaa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Me one naoha ati mitati me ati yana namaroke. \"Eria ino hiri ne awaka\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Me ka owa ohari kana ni tokome esibosa tonakamehimarika. Finakiri ya esibosa sa hife awa tati boni ya hinawana ta hikamisamakemaroke, Sesowi hifahabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ehene me one hinofarehimarika. \"Hine naka. Eria kake ya Eria hikasome ya kasomi e awehibanaka\", me ati namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sesowi ha tasehimarika kita ya. Faya ahabemarika fahi. ");
INSERT INTO jaa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hibati ya teboro boti ka yama babari kana makari tohaha sibi karehemetemoneke. Neme ya sibi kari yana na sibi kari kisa sibi kari kobo nisehemetemoneke bofe ya. Wami kiha nemetemoneke. Yati bakaka nemetemoneke wami kiha na ihi. ");
INSERT INTO jaa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Me ahaba me tame se nemetemoneke. Me tamaha me ahaba me kitamatasemetemoneke, Teoso ka mati. ");
INSERT INTO jaa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tama ya me tasi tona Sesowi kitame ya me tokiyomemetemoneke Serosarei ya. Me tamaha me me hiwehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Saotato me ka hiti ya saotato me tabaha Sesowi me kakatoma wami me awehemetemoneke, kiha naro, wami mera behe kanaharo. Yama one me awa, nemetemoneke. Yama me awaha me kakomeha me ati yana nemetemoneke. \"Hehi Teoso biti tohe awaka hari. Keye amakere\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Me fanawi tamaha Sesowi ya tabarawa hike ya nanaho nama narawamaroke, Sesowi kakatomarawaharo. Karireya ya Sesowi ya tabarawa kakerawamaroke, he narifarawaro. ");
INSERT INTO jaa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Matarena toha, Maria Tiako ya Yose me fama me ka ami toha, Sebeteo biti me ka ami toha, one toharawa, namaroke. ");
INSERT INTO jaa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bahi tokarise ya Yose kakehimarika. Yose Arimateya kamarika, yama kihahari. Sesowi nonofamarika. ");
INSERT INTO jaa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yose Birato aate nematamonaka, Sesowi abohi ta namehibonaha Yose ni ya. Birato ati amosematamonaka. Birato hinaka saotato mera yosehimatamonaka, Sesowi abohi me ta tonamabone mati Yose ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yose Sesowi abohi wara tone rofi hiwahematamonaka makari riyo tohaha ya, amosaro. ");
INSERT INTO jaa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yose Sesowi abohi ibarimatamonaka tama yati hiri ni tohaha ya, yati naro. Ati ehene me wi hinemetemoneke hibayata ya. Yati nafiha karoro towahame tama noki bori bari kawahamematamonaka yati ya. Faya tokomematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Matarena Maria one famaha me teme narehemetemoneke, tama beheri ya. ");
INSERT INTO jaa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yama we yotoha ya, sabato ya, sasetoti me ka hiti me ya fariseo me tabaha me tokomakehemetemoneke Birato ni ya, me aate hinehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","\"Ota ka hiti hehi keye hihiri tohehi ati e nareka ahi, sawisa ne ya mata: 'Owamisamaba ama oke yama wehe terei na ya', ati nareka. ");
INSERT INTO jaa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Saotato me tiyosehi, tama hoti me kakatomahaba mati, yama wehe famaha ya. He ya tataba abohi me hibotirayaho. Abohi me hiboti ya me ati e naba me amake ahi: 'Ahabe ahabawahakara. Kitamareka', me ati naba me amake. Sesowi ka keye fotaha me ka keye nanafi nama naba me amake mata ya, me ati e na mati ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","\"Te ka saotato meba me ta onahabana oke, me te yosehaba mati, tama me kakatomahaba mati. Te ati ehene yama kakatomi me amosaboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Me ati ihi Sesowi temene saotato me kakatomehemetemoneke. Tama noki bori yama atahone ya me moya hikanemetemoneke, nokobi me se karibone karo. Nokobi me one ahi ni ya tama moya kani ka yama atahone baka tona me awi ya me ati e naboneke ahi: \"Tama noki bori me itiha me awineke\", me ati naboneke. ");
INSERT INTO jaa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabato ahaba nowati ya tomiko ya Maria Matarena ya Maria one famaha hiba yama wa ni ya towakamarawemetemoneke, Sesowi temene towamarawabonehe. ");
INSERT INTO jaa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wami kiha nemetemoneke kasiro ya, Teoso nanarifa neme ya kisaki ehene, tokomakehari Sesowi temene ya. Yati tama noki bori tohaha hitiha yoko hiwahawitiemetemoneke. Teoso nanarifa itarimatamonaka yati mese ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oyene kitehimatamonaka, yama yebe kani nima naro. Hinaka makari sawi kitehemetemoneke, fa boni foro na nima naro. ");
INSERT INTO jaa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Saotato Sesowi temene me kakatoma me kakome kitehemetemoneke, me hoyahoyari kana na mati. Me ahabinima nemetemoneke, me foro na mati. ");
INSERT INTO jaa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Teoso nanarifa fanawi hiyararawematamonaka. \"Te kakomerabone teke. Tera owato oke, Sesowi te siba na te, me ba hikanari awa ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Watamakara ahi. Kitamatasahareka, fara yama hikamina nima nari. Te kakamahi ahi, fore ka taboro te awabaya. ");
INSERT INTO jaa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Te tokomakabote nahi, he ya tataba me te hiyaribeya, te ati e na te ahi: 'Kitamenoka. Tai tohamebonaka Karireya ya, te nokosi ya. Te awehibonaka fahi', te ati nabone teke. Okominahareka te ni ya\", Teoso nanarifa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kakomerawa yayai narawa towakamarawemetemoneke hibati ya. Kana kawarawemetemoneke, Sesowi tamine kaminarawabonehe Sesowi ya tataba me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hawi ya Sesowi kobo hirawemetemoneke. \"Afa me te ama?\" ati nematamonaka. Nokosi ya foro narawa he teme tama karawemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","\"Te kakomerima nahi. Te towakamakihi oko one me ni ya, otamine te kaminibeya me ni ya. Me te yosiyahi Karireya ya, owa me awahaba mati fahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Towakamarawa saotato me one tokoma nemetemoneke sitati ya, yama me awaha me tokaminamabone mati sasetoti me ka hiti me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Heoniao me hiri nemetemoneke, me ka hiti me ya me tabaha mati. Me abe hiyara yinero nanafi raba ne me ta nemetemoneke saotato me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","\"Te ati e nabone teke ahi: 'He ya tataba yama soki ya me kakeha Sesowi abohi me itihanike, ota amo na ota ni ya', te ati naba te amake. ");
INSERT INTO jaa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kofenato te tamine mite ya narabo ota nima nebonaka, tera me nahabirabone te\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yinero me wara tona fara yama sasetoti me ka hiti yama me hikamina me hiri nemetemoneke. Haha hiyara soteo me kaminate me amake, saotato me hikaminehemete. ");
INSERT INTO jaa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sesowi ya tataba me 11 na me tokomamaroke Karireya ya, atami ya, Sesowi hikaminaharo. ");
INSERT INTO jaa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Me tokoma me hiwehi nokosi ya me foro namaroke. Efe amaremona me one hinehimarika. ");
INSERT INTO jaa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sesowi mera hiyaremarika. \"Me nafi oyose okibone waha, Teoso ati ehene, neme ka me toha, bofe ka me toha, na mati. ");
INSERT INTO jaa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Makoni tabora nafi ka me te hiyarabone teke, owa nonofa me tohawahabone mati. Me te iibofarisaboneke, e ka abi ino, biti ino, Teoso Kanamori ino ne ya. ");
INSERT INTO jaa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Me te kanawanahabone teke, fara yama okomina me hiri nabone mati. Oko sawi fawa teraba ama oke te ni ya. Yama nafi ahabi ya osawisa otehaba ama oke te ni ya\", ati nemari amaka.");
INSERT INTO jaa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hiyara amosa yana kanake haro, Sesowi Kirisito kaminaro. ");
INSERT INTO jaa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yama hani e te amake ahi, Teoso ati kakamina Isaiya ka yama hani ya: \"Owati kaminebona tinokosi ya tai tohehibonaka, oyose kari. Tika hawibone namosebonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","E ka owa ati yana nebonaka yama honara ya, ati e nari ahi: 'Teoso hawinebona te namosahi. Hawi te yai tonihahi, Teoso hawinebonaha'\", Isaiya ka yama hani ati ke. ");
INSERT INTO jaa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yowao Batisita kake mera iibofarisematamonaka, yama honara ya. Me narabi nima nematamonaka. \"Te ehene hiyara te ehene te nofamarahaba teke. Te batisa, nabone teke, Teoso ati somawamabona karo\". ");
INSERT INTO jaa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Me nafi yoro tokanemetemoneke, Soteya ka mati, Yowao ni ya. Serosarei ka me nafi toha, nemetemoneke. Mera iibofarisematamonaka Sotao ka faha ya, me ihi hiyara me ihi me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kamero kone hiri ni makari tohaha weweye tohehimatamonaka. Bani ataro wata, na tohehimatamonaka tosi ya. Habise mera kaba, abiya me fehe fawa, na tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mera hiyarematamonaka. \"Owa onowati ya kamakibonaka, kiti mati tohahari. Okita okere, ha owa. Hahi narifi owato okara, owehene amosara owa. Teme borone katisi owato okara ha owa, owehene amosara owa ");
INSERT INTO jaa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tera obofarisi onofa ama oke, faha ya hine ya. Hahi tera batisa neba amaka Teoso Kanamori ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yama wehe one ya Sesowi yana tonehimatamonaka, Nasare ya, Karireya ya. Tokomakehimatamonaka Yowao ni ya. Kobo ne Yowao hibofarisematamonaka, Sotao ka faha ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sesowi wamisame neme awehimatamonaka. Neme hine ebe kanaha ya Teoso Kanamori awehimatamonaka, kakehari he ni ya, okoko nima nari, Teoso kanamorinoho. ");
INSERT INTO jaa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Teoso ati saihimatamonaka neme ka ya. \"Okatao ama tike. Tiwa onofa oke. Tiwehene amosi nofa ama tike owa ni ya\", Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Teoso Kanamori hekematamonaka yama honara ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Amo ni 40 ne ya Satanaisi ati yayana tohehimatamonaka, Sesowi yosehari, Sesowi yama hiyara hiri nebona ati nari. Sesowi bani me ya tataba tohehimatamonaka, Teoso nanarifa me hekatomari. ");
INSERT INTO jaa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yama wehe one ya Yowao me ibehemetemoneke kateya tori ya. Yowao foye ya Sesowi tokomematamonaka Karireya ya, hiyara amosa kaminebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","\"Afa Teoso ka yama tohake waha. Teoso ka towisawa kobo nima ka. Te ehene hiyara fawa nahi. Hiyara amosa te nofahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yama wehe one ya Sesowi yaka nematamonaka Karireya ka faha webote witi ya. Yaka ne mera awehimatamonaka, Simao nisori ya famahari, Atere. Tahafa me were nifehemetemoneke faha ya, faha kiki me toha mati. ");
INSERT INTO jaa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mera aate nematamonaka. \"Owa ni ya te kasawihi. Owati ihi e ka one me te ki naba teke waha\". ");
INSERT INTO jaa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Me ka tahafa me kakosehemetemoneke hibati ya. Faya Sesowi ya me tabehemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Totokoma kawahe Tiako mera awehimatamonaka, Sebeteo biti, nisori ya famahari, Yowao. Me nahoriemetemoneke, tahafa me sako namaha mati kanawa ehebote tori ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sesowi mera ha ne he ya me totabamehemetemoneke. Sebeteo me hekanakose foyehimatamonaka kanawa tori ya he nanarifa me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Me tokomemetemoneke Sesowi ya me tabaha mati, tabora Kafanao ya. Sabato ya Sesowi tokiyomehimatamonaka sinakoka toro ya, mera kanawanehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mera kanawane ati me himite 'Hika', me ati nemetemoneke, Mowisei ati kakamina me ati nima Sesowi ati re karo. Mowisei ati kakamina me one ati me kamina Sesowi ta fare ati kaminematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sesowi mera kanawane me ka owa kiya kanehimatamonaka kasiro ya, rabikari. ");
INSERT INTO jaa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Sesowi Nasare ka tihaha himataba otara ahi tine tiri? Otara tinahabihaba tiwa awine ti? Tiwa owato oke. Teoso tiwa yosehino ama tike, me tikasomahabone tiwa. Efemata ama tike, Teoso hikaminehimata hibati ya\", me ka owa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","\"Tiwati watarima nahi. Sa tisaho\", Sesowi hora ni ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Inamati hose hine sa hisehimatamonaka. Inamati kiya kanehimatamonaka kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Me ka owa Sesowi hikasomehi kitame me awaha Sesowi me kahiyarehemetemoneke yama watohari, inamati toyosemahari. \"Himata amari?\" me ati nemetemoneke. \"Hiyara yati amake. Yama watote amaka kasiro ya. Te aware awa inamati toyosemahari?\" me ati nemetemoneke, ");
INSERT INTO jaa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sesowi tamine me kamina nawahareha mati Karireya ka tabora ya, fara Karireya ka tabora nafi nima. ");
INSERT INTO jaa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sesowi kiyomamehimatamonaka sinakoka ya. Tiako ya Yowao me famaha me ya tabe me tokomemetemoneke Simao ya Atere me famaha me tabori ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simao fati mati yama kome awaha tamine me kaminemetemoneke Sesowi ni ya, foreharo kama ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sesowi tokomakehimatamonaka he ni ya. Mani wara hina hinawaremisaha hinaka yama kome fawa nemetemoneke. Kitama mera narifemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bahi toke ya me me kakiemetemoneke Sesowi ni ya, me tamaha mati, yama kome me awaha mati. Me rabika me toha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sitati ka me nafi yoro tokanemetemoneke nokobi beheri ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Me tamaha mera Sesowi kasomematamonaka, yama kome nafi me awaha mati. Me rabika mera kasoma nematamonaka. Inamati me ati wataremetemoneke, Sesowi ati ehene, Sesowi me watoha mati. ");
INSERT INTO jaa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yama warisi ya Sesowi kise ohari tokehimatamonaka, Teoso ha nebonaha yama honara ya. ");
INSERT INTO jaa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simao Sesowi me siba nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Me hiwasimatamonaka. \"Sesowi me tamaha tiwa me siba nara tike\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","\"Hima e tokahaba eke tabora ayata ka ya, Teoso ati okominabone owa fahi. Okine oke Teoso ati okominabone owa\", ati ne ");
INSERT INTO jaa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","faya me toka me yobi nawaharehemetemoneke tabora nafi ya, Karireya ka me tabori ya. Sesowi mera kanawanehimatamonaka sinakoka toro ya. Mera kasomematamonaka me rabika mati. ");
INSERT INTO jaa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Me ka owa mese hiyare kakehimatamonaka, Sesowi aate nebonaha. Sesowi aate ne sonarisehimatamonaka iso yobati ya Sesowi nokosi ya. \"Sesowi owa kasomi tiwatoa tiwa awine tike. Owa kasomi tinofini?\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sesowi wati hiwahematamonaka hinofari. Sesowi bori hikanematamonaka yehe ya. \"Tiwa kasomi onofa oke. Tikitamahabone tike hibati ya\", ati ne ");
INSERT INTO jaa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","hibati ya yama kome fawa nemetemoneke. Mese amosamehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sesowi hiyoseme tokomematamonaka. Narabo nima hinehimatamonaka, ");
INSERT INTO jaa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Sesowi ehene kaminarehibonaha me one ni ya. \"Tikamahi sasetoti me ni ya, tiwa tinamobeya sasetoti me ni ya. Mowisei ati e nematamonaka ahi: E mese amosamaha bani e ta te e amake Teoso ni ya, tabasi nebonaha. Mowisei ati namatama tiwehene nahi, tiwa me watobone karo, titaminawaha tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tokomematamonaka. Sesowi ati kasawari hiwa kaminematamonaka me nafi ni ya. Ehene Sesowi tokomihinarematamonaka, sitati nafi nima. Wehimatamonaka yama honara ya. Tabora nafi ka me hinakematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wete namehimatamonaka Kafanao ya. Yama wehe one ya Sesowi tamine me mitehemetemoneke kobo namahari taboro ya. ");
INSERT INTO jaa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Me kamakia me tamaha me ihi yobe mo kanehimatamonaka. Me one kamakihina remetemoneke nokobi beheri ya, me tamaha me ihi. Sesowi Teoso ati kaminematamonaka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Me one kamakitasehemetemoneke, me ka owa yana ni watore me tiwa kana mati. Me fama me fama na me hekamakimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sesowi ni ya me hekamakibona towakamaki me hiwatorehimatamonaka, me tamaha me ihi. Faya yobe bari ya me tokomisa Sesowi itari ka yama ya yama me kanahotihemetemoneke. Me hikanakisakehimatamonaka, forehari, Sesowi itari beheri ya. ");
INSERT INTO jaa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Me ati boti Sesowi hiwatoemetemoneke, \"Teoso kitate amaka\", me ati boti ati na mati. Me ka owa hiyarematamonaka. \"Okatao Teoso tiwehene hiyara fawa nika\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Me sawihemetemoneke, Mowisei ati kakamina mati. Me ati boti yama nima nemetemoneke, Sesowi ati me mitaha mati. ");
INSERT INTO jaa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"Himata nima ati nara? Yama hiyara kaminareka, Teosomona ati nari. Yama hiyara e hiri teha Teoso fawa nite amaka, fare Teoso ati ehene. E ati ehene amakere\", me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sesowi me ati boti watohimatamonaka. \"Himataba yama e na te wati nawahineri ahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","\"Owati e nara oke ahi: 'Tiwehene hiyara Teoso fawa nika', onahara oke. Owati e nene ama oke ahi: 'Yana tinahi. Tika kama wara tinahi. Yaka tibeya', onehene ama oke. Fara owati famineke. ");
INSERT INTO jaa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Owa te watowahaba te amake waha, me ihi hiyara me ihi fawa ni owatoa owa ahi, bofe ya, Teoso ati ehene\". Faya me ka owa hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"Owati timitahi. Yana timisamahi. Tika fofore titihi. Tikamahi titaboro ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Waremisame hinaka kama wara tonehimatamonaka hibati ya. Tokomematamonaka, me nafi hiwahari. \"Hika\", me ati nemetemoneke, me hiyara mati, Teoso me kahiyara mati. \"Yama e na owatera ama oke ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Faya Sesowi tokome yaka nabasematamonaka tasa, faha webote witi ya. Me tamaha me kamakiemetemoneke. Mera kanawanehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Faya yaka ne noko awehimatamonaka. Refi awehimatamonaka, Afeo biti, itariari yobe ya, me ka yinero yayaba ka yobe ya.\"Tisawihi owa ni ya\", Sesowi ati nematamonaka. Yana namise he ya famehimari amaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Me tokoma Sesowi ya tataba me ya tabehi me tafehemetemoneke Refi ka yobe ya. Me ya me tabehemetemoneke, me tamaha mati, me ka yinero yayaba mati, me ya me one tabaha mati, yama hiyara hihiri mati. Afa me tamehemetemoneke, Sesowi ya me tataba toha mati. ");
INSERT INTO jaa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Haha me ya Sesowi tabehi tafehi me one ati yana nemetemoneke, Mowisei ati kakamina me toha, fariseo me toha, na mati. Sesowi ya tataba me me aate nemetemoneke. \"Himataba Sesowi me tafi ya tafi tabara, me yoro tokana mati, yinero yayaba me ya yama hiyara hihiri me tabaha mati?\", Mowisei ati kakamina me ati nemetemoneke, fariseo me ya me taba mati. ");
INSERT INTO jaa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Me ati Sesowi mite ati yana nematamonaka. \"Yama kome e awara metiko era narifatere amaka, e taminaro. Me kiya na me ta metiko mera narifate amaka. Me ihi amosa me ha orahabone okehara oke. Okehara oke, me ihi hiyara me ta me ha onahabone owa, yama hiyara me hiri namaribone karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yama wehe one ya Yowao ya tataba hine me nafimi, fariseo hine me nafimi nabisemetemoneke. Me one kamakiemetemoneke, Sesowi me aate nabone mati. \"Sesowi himataba tiwa ya tataba hine me nafimirineri?\" me ati nemetemoneke. \"Yowao ya tataba me toha, fariseo me ya tataba me toha, na me nima me kere, hine me nafimira mati\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","\"E ka owa fanehibona ya tataba hine me nafimibana, sawi ka ayaka ya? Hine me nafimiraboneke sawisa ne kari me ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","\"Yama we one ya me one hitimakehibonaka. Faya he ya tataba hine me nafimiaboneke fahi\". ");
INSERT INTO jaa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","\"Makari bote e nawanamatera amake makari ibe yati ya. Makari yati e nawani ya makari sibi tonamatasahaba amake, bote tohi karo. Makari hoti tonafihaba amake mata ya. ");
INSERT INTO jaa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Fi yati e tonihatera amake yama atari bote yama wiye tohaha ya. Fi nafimisaha ihi yama wiye bosi tokanaba amake, kitaharo, bote tohaharo. Yama atari sibi toni ya fi ahababa amake. Yama atari ahaba, naba amake. Fi yati e tonihate amake yama wiye yati ya. Fi nafimisi ya ahabarahaba amake, yama wiye kitari karo, yati tohaharo\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabato one ya Sesowi kariwematamonaka fatara ya, he ya tataba me ya tabahari. He ya tataba tiriko boni me bata nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo me ati yana nemetemoneke, Sesowi me hiyara mati. \"Sesowi me tiwa ha. Himata me ebe na tiriko me bata nineri? Sabato ya yama e na e hiri tera amake ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","\"Yama hani te awaterani te ama, Tafi tamine kaminaro?\" Sesowi ati nematamonaka. \"Tafi he ya tataba me ya tabehi me fimihemetemoneke, yamata watari karo. ");
INSERT INTO jaa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tafi tokiyomehimatamonaka Teoso ka yobe ya. Abiata sasetoti ehebote tohehimatamonaka. Tafi tokiyome bao kabehimatamonaka, Teoso ka bao. Hahi bao e kabatere amaka. Sasetoti me ta me hikabate amaka. Efe bao Tafi kaba he ya tataba me hikaba hinehimatamonaka, Tafi ta hinahari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Teoso sabato hiri nematamonaka e ka iti boteri me ka sabatobonehe. Sabato ka me amarabone memetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Neme ka Owa sabato Hiti tohate amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yama we one ya Sesowi tokiyomatasematamonaka sinakoka ya. Me ka owa sawihimatamonaka sinakoka toro ya, mano kamo namahari. ");
INSERT INTO jaa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sesowi me kakatomehemetemoneke, yama hiri hinahabone me awahabone mati. Me ka owa nakitame ya ehene me hikaminebona me hinehimatamonaka me one ni ya, sabato ya yama ahi nemona me hinahari, ehene hiyaremona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sesowi me ka owa ha nematamonaka, mano kamo namahari. \"Tikamahi, tiwaribeya ahi me nafi nokosi ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Faya Sesowi mera aate nematamonaka. \"Sabato ya e abe kasomaterani ama? Sabato ya e abe kakotehani ama? Sabato ya e abe nakitamaterani ama? E abe nabowatehani ama?\" Sesowi ati nematamonaka. Me ati yana remetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Me nafi kakatomehimatamonaka, yawamisahari, noko yawakanikimahari, me ka owa me nofari karo. \"Timano yai tinihahi\", Sesowi ati nematamonaka. Faya mano yai tonihe yehe amosawahamehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Faya fariseo me tokomemetemoneke, Eroti me one me hiyarabone mati. Faya me abe hiyaremetemoneke. \"Himata nima nabowi e neba amara?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Faya Sesowi he ya tataba mera hima nematamonaka. \"Hima e tabi oharihi\", ati nematamonaka. Me tokomemetemoneke Karireya ka faha witi ya. Karireya ka me tamaha me kamakiemetemoneke Sesowi ni ya. Soteya ka me toha, ");
INSERT INTO jaa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Serosarei ka me toha, Itomeya ka me toha, Sotao kowani ka me toha, Tiro ka me toha, Sito ka me toha, me tamaha me kakehemetemoneke, Sesowi ni ya, Sesowi ehene tamine me mitaha mati. ");
INSERT INTO jaa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Me tamaha me ihi Sesowi ati ehene kanawa me kakamemetemoneke, Sesowi foyabona karo, me tai hiwaharehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sesowi me boyo nabone me nafi kakehemetemoneke, me kiya na mati, Sesowi tamine me mitaha mati, me tamaha mera nakitamahari. ");
INSERT INTO jaa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sesowi nokosi ya me inamati foro nemetemoneke, me kikiya kanaha mati. \"Teoso biti ama tike\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Me narabi nima nematamonaka, ehene me hiwehi ehene me hikaminarebonaha me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Faya tokomisehimatamonaka yati waha mese ya. Mera ha nematamonaka he ya tataba mebone mati. ");
INSERT INTO jaa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Faya mera kakatikehimatamonaka me tosi na mati, me ya tabehibonaha, mera yosehibonaha, Teoso ati me kaminabone mati, me one ni ya, ");
INSERT INTO jaa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","yama me watohabone mati, me rabika me me kasomabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simao ino owamatamona amaka, Betiro, Sesowi ino hinawatawahari. ");
INSERT INTO jaa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiako Sebeteo biti. Yowao Tiako nisorimatamonaka. Tiako nisori ya me famaha me ka haha amake haro, Bowanesi tohaharo, Sesowi hitiharo, bahi ati nima me na mati. ");
INSERT INTO jaa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Atere, Firibi, Batoromeo, Mateo, Tome, Tiako Aofeo biti, Tateo, Simao, Homa ka mera momono tohatehari. ");
INSERT INTO jaa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yota Isikarioti, Sesowi ta tehibana me one ni ya. Sesowi kamehimatamonaka fare taboro ya. ");
INSERT INTO jaa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Me tamamatasehemetemoneke. Sesowi me tafahabone me tafihinaremetemoneke, me tamaha me ihi. ");
INSERT INTO jaa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sesowi tamine Sesowi me one mitaha Sesowi me totimakehabone me ati nemetemoneke. \"Sesowi tati rabike awaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Serosarei ya Mowisei ati kakamina me kakeha me ati e nemetemoneke ahi, Sesowi me kamina mati: \"Beosebo me ka owa tohe awaka, Sesowi. Fare inamati me ka towisawa ati ehene tohe awaka. Makoni inamati mera toyosemaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mera ha nematamonaka, hiyara kaminebonaha me ni ya. \"Fare Satanaisi hiwa nahabitere amaka. Fare Satanaisi mera kasome ya hiwa nahabitehiba amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","\"Saotato me abe mowa ni ya, me kiti watamaraboneke. Towisawa owa ka saotato me tabori me hinabihaboneke, me ka sitati. ");
INSERT INTO jaa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hahi yobe ohari ka me abe mono ni ya me abe nahabihaba me amake. ");
INSERT INTO jaa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanaisi me abe mono ni ya Satanaisi ahabeba amaka\". ");
INSERT INTO jaa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sesowi hiyara one kaminematamonaka. \"E ka owa kitehi ka yama e botihabone e ati na e ka owa ka yobe ya e tokiyomaha e ka owa e wete te e amake. E wete re ya hinaka yama botihina raboneke\". ");
INSERT INTO jaa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","\"Teoso yama hiyara nafi fawa nite amaka. Teoso te kakoamone te ati ni ya Teoso ati somawamatehiba amaka. Yama hiyara oharia ta Teoso fawa nirebonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Teoso Kanamori ta hiyaremona te ati ni ya Teoso ati somawamatereba amaka. E ehene e na hiyakere mata ya, Teoso ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hinamati ati ehene mera kasomemona me himako ati yana nematamonaka, Teoso Kanamori me kakoamone ati ne karo. ");
INSERT INTO jaa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Me kakeha me nahokiemetemoneke. Sesowi mati toha, nisori me toha, hinakasima toharawa, nemetemoneke. Me nahokosa Sesowi ino me hiri nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Me tamaha me moto kawahamaha me ya Sesowi tabehimatamonaka. \"Sesowi ami, niso mati, asimarawaha, me na me nahobasaharake ahi yobe beheri ya, tiwa me ati na mati\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","\"Hibaka okomi tohari? Hibaka okaniso me tohari?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Me nafi noki awehimatamonaka, me moto kawahama mati. \"Me te awa haro. Okomi nima me nineke. Okaniso me nima, me nineke. Okaniso toha, okasima toha, okomi toha, na nima me nineke, e ka one mati, Teoso yama hinofa me hiri na mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sesowi mera kanawani yana tonehimatamonaka faha webote witi ya. Me tamaha me kakeha me ihi tofoyawiti itarimarika kanawa tori ya. Me one nahobasahamaroke faha witi ya. ");
INSERT INTO jaa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mera kanawanehimatamonaka. Hiyara tamaha ya mera kanawane ati e nematamonaka ahi: ");
INSERT INTO jaa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"Owati te kamitahi. E ka owa tokehimatamonaka yama noki koro nebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yama noki were kane noki one kasohemetemoneke hawi beheri ya. Bani biti me kakeha yama noki me kabehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yama noki one kasohemetemoneke wami yati kihaha mese ya. Wami bayiri ka tiriko yani kerewe remetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Manakobisa bahi kamaki ehene tiriko waya tokanemetemoneke, habi fotari karo. ");
INSERT INTO jaa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yama noki one kasohemetemoneke atiwa baikani ya. Atiwa yanehi ehene tiriko yani watoremetemoneke. Bonoremetemoneke faro. ");
INSERT INTO jaa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wami amosa ya yama noki one kasoha yanaha bonohemetemoneke. Noki oharia koro na boni 30 toha, noki one ka boni 60 toha, noki one ka boni 100 toha, nemetemoneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","\"Te warabo naha owati te mitahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Me one tokoma me tamara Sesowi ya me taba Sesowi me aate nemetemoneke, hiyara me mitahabone mati, me hiwatoabonehe, Sesowi hikaminaharo. Me 12 na me toha, me one toha, me tamara mati. ");
INSERT INTO jaa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","\"Teoso ka towisawa ka yama wato yokana te tohahabone Teoso ati nareka, ha te ta. Me one yama watoraba me amake. Hine ya hiyara me mitahaba me amake, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Teoso ka yama me awaha me narabi hawiha Teoso ka yama me watoraba me amake. Teoso ka yama me wato ya me ihi hiyara me ihi me nofamarehene me amake, Teoso ati somawamebonaha\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","\"Hiyara te watoramone te ati nine? Hiyara one te watoraba te awineke, oko hiyara\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","\"Fara yama koro na nima Teoso ati te amaka. E ka owa yama koro ne ka yama koro ni nima Teoso ati kamini te amaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","E ka one Teoso ati me mitaha me nima wami nemetemoneke, hawi beheri karo. Teoso ati me mitaha Satanaisi Teoso ati totimakehi ehene Teoso ati sawimatere amaka me ati boti ya\". ");
INSERT INTO jaa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","\"Yama noki one kasohemetemoneke wami yati kihaha mese ya. Afa nima me nineke, Teoso ati me mitaha ati nofi me kerewe ri karo, me yayai na mati. ");
INSERT INTO jaa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tiriko habi watara nima me nineke, Teoso ati me nofamara mati. Teoso ati me nofaha me one me me hinofamara Teoso ati nofi me fawa te me amake. Yama nawaha me hiri na Teoso ati nofi me fawa, te me amake, me one\". ");
INSERT INTO jaa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","\"Atiwa baikani ya yama noki one kasohemetemoneke. Afa nima me nineke, Teoso ati me mitaha ");
INSERT INTO jaa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yama amosa me hiri ra mati, yama tamaha me nofa mati, yinero tamehi me nofa, na mati\". ");
INSERT INTO jaa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","\"Yama noki one wami amosa ya kasohemetemoneke. Afa nima me nineke, Teoso ati me mitaha mati, Teoso ati me nofaha mati, me ihi amosa mati. Owa ehene manakone 30 toha, owa ehene manakone 60 toha, owa ehene manakone 100 toha, naka, amosari\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","\"Nabarina hiri ni e boko kanisawahamate ama, boro ya? Nabarina hiri ni e yoko tokatehani ama kama bofe ya? Nabarina e kawatarete amake neme ya fara nabarina tabori ya. ");
INSERT INTO jaa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","E ehene e kehemoha e ehene awihinatehaba e amake. ");
INSERT INTO jaa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te warabo naha owati te mitahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","\"Owati te mitahi. Owati miti titamini ya Teoso ati nafi tiwatotehabone tike, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","E ka owa yama kihe ya hinaka yamabone Teoso ta hinamakehaboneke. Hahi e ka owa yama kihare hinaka yama Teoso hiyabamakiaboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","\"E e te amake ahi, Teoso ya e tabaha e: Yama noki e koro na ");
INSERT INTO jaa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","e kamate e amake. Yama soki ya e aamo toha, yama wamini ya e tatafi toha, na yama e aawa naminate amake, yanahanihi. ");
INSERT INTO jaa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hine ya wami ihi yanatehani amake, e watoraro. Manakobisa yama totoyabo ni ya bonoha boni kini toha manakobisa ");
INSERT INTO jaa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","abariko owa ya boni hati ya me one e yosete e amake, yama me ti nabone mati, hibati ya hataharo. E ehene nima Teoso ehene te amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","\"Hiyara one okominahabone oke, yama te watohabone te, Teoso ya e tabi karo. Mositata noki isisi kabote na noki nima Teoso ka yama te amake, ");
INSERT INTO jaa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","nafiraro. ");
INSERT INTO jaa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Fatara ya koro na yanaha nanafi na ini kanafiaha ini ya bani biti me winati amake yama bafo ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sesowi hiyara tamaha kaminematamonaka mera kanawanahari Teoso tamine ya. Yama me wawato raba nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hine ya hiyara kaminematamonaka me tamaha me ni ya. Ohari me ya totabakosematamonaka mera kanawani forima nebonaha, he ya tataba mati, yama nafi me watohabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bahi fawa nise ya ati e nematamonaka ahi: \"Hima e kariwahi kowani ka ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Me one tonohokosa he ya tataba me hekematamonaka, fara foye ka kanawa ya. Kanawa one nehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Boni kakehemetemoneke kitaharo. Faha rike nafihemetemoneke. Faha rike kitaha ihi faha foyehemetemoneke kanawa tori ya. Kanawa bokinima nemetemoneke faha rike ihi. ");
INSERT INTO jaa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sesowi amo ni foyehimatamonaka kanawa tori ya, kanawa mate ka ya, bako mese ya. Me mowa hinehimatamonaka amo nari. Tafihi me aate hinehimatamonaka. \"Sesowi e ahababa e awineke. Hine e ahabake tine ti?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sesowi waremise boni ya faha rike famaha fawa nihimatamonaka. Boni fawa, faha rike fawa, nemetemoneke. Faha winawina nemetemoneke. Mera hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","\"Himataba te kokoriri nineri? Teoso tamine te mitaterinihi era kasomari?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Faya me abe hiyaremetemoneke, me watoha mati. \"Hiketeno amara, boni ati hikataba, faha rike ati hikataba, hinahari?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sesowi me kobo tokowitehemetemoneke faha webote kowani ya Keraseno me tabori ya, ");
INSERT INTO jaa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","inamati ehene me ka owa rabikatehino wano ya, tama taboriteni ya, wete hinaterenoho koheti ya fare koheti bebete kasa tehinoho. ");
INSERT INTO jaa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Feho ya temerabo me hikamato, koheti ya ye tabo me hikamato, hinehi koheti bete kasarima nematamonaka, kite kari, me himato ka koheti kitakene ati terari. Me nafi kitaremetemoneke ehene, kitahari. ");
INSERT INTO jaa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yobi nematamonaka yama nafi ya, yama soki ya wa naba, yama wa toni ya wa nati, nari, tama si toni ya yati nemeha si toni ya. Ha ne hiwa nohoho nimatamonaka, yati ibe ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sesowi me kobo towitiemetemoneke. Sesowi kisehimatamonaka. Sesowi awaba nematamonaka yama yabo ya. Yana ne kakehimatamonaka he kobo nebonaha. Kana ni kakehimatamonaka. Sonarise itarisehimatamonaka Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","\"Inamati, sa tisaho\", Sesowi ati nematamonaka. \"Sesowi Teoso biti kiti mati tihaha himata hiri tiribe owa ni ya? Teoso ino hiri ona tiwa aate oke, owa tikatomarabone tiwa\", kiya kani ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","\"Tiwini e na ama tiri?\" Sesowi ati nematamonaka. \"Owini amake haro, Me Tamake ama oke, ota tami karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sesowi aate nematamonaka kita ya, Sesowi mera toyosemarebonaha yama yabo ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Boroko me tamaha me tafaha me nahohemetemoneke yama atamiri ka ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Me inamati Sesowi aate nemetemoneke. \"Otara tiyosemahi boroko me ni ya, ota sawihabone ota\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sesowi ati amosematamonaka. Me tokomemetemoneke boroko me ni ya. Faya boroko me tokifiwahemetemoneke atami ya, me kana ni. Me bokehemetemoneke faha ya. Me ahabemetemoneke faha boti ihi, me tamaha mati kasiro ya, 2000 me toha mati. ");
INSERT INTO jaa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Boroko me nanarifa me tokomemetemoneke. Hiyara me kaminemetemoneke me nafi ni ya, sitati ka me toha, tabora one ka me toha na me ni ya. Me one kamakiemetemoneke Sesowi ehenemona me awamakehabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Me one kamakiemetemoneke Sesowi ni ya. Me ka owa rabikatehi me awehemetemoneke itariari, makari akahari waha. Hibati ya inamati me ihi totoha tohehimatamona amosawahamehimatamonaka. Me hiwehi me kakomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sesowi ehene me awaha Sesowi ehene me kaminibemetemoneke me ka owa rabike kasomari. Boroko me me kamina nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sesowi tokomebona me aate hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sesowi tofoyamehimatamonaka kanawa ya. Me ka owa kitame Sesowi aate nematamonaka, me ya tabehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sawi Sesowi hinofarehimatamonaka. \"Tikamahi titaboro ya. Titamine tikaminiyahi tika one me ni ya titaminawamaha tiwa. Teoso tikaminahabone tike me ni ya, ehene amosari, tiwa ni ya, tiwa nofahari\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Faya tokome Sesowi ehene kaminematamonaka me one ni ya me wina mati sitati Tekabori ya. Tekabori ka sitati 10 nemetemoneke. Me nafi ati boti yama nima nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sesowi me tokariwahamehemetemoneke tasa faha kowani ya. Wabasehimatamonaka. Me tamaha me kakehemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sinakoka ka towisawa Sairo tohe kakehimatamonaka. Sesowi awe sonarise itarisehimatamonaka Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","He aate nematamonaka kasiro ya. \"Okoto ahabinima narake. Tikamakehi hibati ya okoto ni ya. Tiye tekibaribeya he ni ya, kitamabana. Ahabariyahi\", Sairo ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sesowi he ya tofamamehimatamonaka. Me tamaha me yaka na me ya tabehi me hitayomatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Me ka one ama kihateha kakehemetemoneke, hinaka ama fawa ni watoteraro. Ama kihi ka hinaka ano 12 nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Metiko me hikasomahabone metiko me haha tohehemetemoneke. Hinaka yinero nafi tata tohehemetemoneke kitamihinararo. Rabiki yehekosehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sesowi tamine mitaha kakehemetemoneke he ni ya. Kamakiemetemoneke Sesowi nowati ya, me yotoha me baikani ya. Tokomake Sesowi ka makari bori kanemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ati boti e nemetemoneke ahi: \"Hinaka makari boyo oni ya okitamahaba ama oke\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hinaka ama fawa nemetemoneke hibati ya. Kasomi watohemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sesowi hiwa watohimatamonaka kiti tokahari. Sesowi nokowame ati yana nematamonaka me baikani ya. \"Hibake oko makari bori kana?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","He ya tataba me ati yana nemetemoneke he ni ya. \"Himata ebe tina tiwati e nineri ahi, 'Hibake owa boyo nara', tina tiwa? Me tamaha me tiwara tiwa awine ti, tiwa me koba na mati?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Noko totokikima nematamonaka, he koba kanehi tabiyo hiwehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fanawi kokoriri na hoyahoya kana nemetemoneke kitami awaharo. Sesowi ni ya kake sonarisa itarisehemetemoneke he nokosi ya. Ihi kaminemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sesowi hihiyarehemetemoneke. \"Okoto tikitama tike tiwati e na tiwa ahi, tiwati boti ya, 'Owa kasomebanaka, kitahari', tini karo. Watorima tinahi. Tikamahi. Haha yama kome tiwa wasimateraba ama tike\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sesowi me ka one hiyare ni ya Sairo me one kamakia me ati yana nemetemoneke. \"Sairo tikoto ahabarake hibati ya. Borofeso hine naka waha\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sesowi me ati mitehi Sairo hiyarematamonaka. \"Watorima tinahi. Tiwati e nahi ahi tiwati boti ya: 'Teoso hikasomahaba amake', tinahi\". ");
INSERT INTO jaa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Me tamaha me ya tabi nofarematamonaka. Betiro, Tiako, Yowao, me na me ya tabi oharimatamonaka, Yowao Tiako nisori. ");
INSERT INTO jaa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Me kobo tonamemetemoneke Sairo ka yobe ya. Mera awehimatamonaka, me yawa me ohi na mati, me ati komeha mati. ");
INSERT INTO jaa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tokiyomamake ati yana nematamonaka. \"Himata te ebe nani te yawa te ohi nineri? Inamatewe ahabakere. Hine ya amo nineke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ati me haha hikanematamonaka. Mera toyosemehimatamonaka, me nafi, yobe ka mati. Mera hima nematamonaka. Inamatewe bati ya mati fama, Tiako ya Yowao fama, Betiro ya Sesowi fama ne me tokiyomehemetemoneke inamatewe fori ya. ");
INSERT INTO jaa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sesowi inamatewe yehe wara tokane inamatewe ha nematamonaka. \"Inamatewe tiwamisamahi\", ati nematamonaka. Fare ati kabisa amake haro, \"Tarita komi\". ");
INSERT INTO jaa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Inamatewe hibati ya wamisama yaka nibote nemetemoneke. Hinaka ano 12 nemetemoneke. Sesowi ehene me kahiyara me abe hiyaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mera hora kasehimatamonaka kasiro ya, ehene me hikaminarebonaha, me one ni ya, tabora one ka mati. Me narabi nima nematamonaka, inamatewe me natafabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sesowi yana tone tokomematamonaka fara hinaka sitati ya. He ya tataba me ya tabehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabato ya mera kanawanehimatamonaka sinakoka ya, me tamaha mati. Ati me hikamite \"Hika\", me ati na, \"Hika hibake hikanawanatehino amara?\" me ati nemetemoneke me abe hiyara mati. \"Himata nima ne yama nafi watora, era kasomi wato nari? ");
INSERT INTO jaa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Efe amare awa hihiri, Maria biti? Ota ka one me ka ayo amare, Tiako, Yose, Yota, Simao me na me ka ayo? Hinakasima sawi nofarawara ama e ni ya?\" me ati nemetemoneke, Sesowi ati me nofara mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sesowi ati e nematamonaka ahi me ni ya: \"E ka owa Teoso ati kakamina tohe fare taboro ka mera hiyare ati kamiti me hinofatere amaka. Manakobisa tabora one ya tokehi mera hiyare ati kamiti me hinofate amaka. Fara me one hinofatere amaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Haha tabora ka mera kasomihinarematamonaka. Hine ya mera kasomematamonaka me tamara mati, yehe kakakibarehari me tati ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","\"Hika, era kasomi owatorahamone me ati na me awineke\", ati nematamonaka. Moto nawahematamonaka mera kanawanahari tabora one ka mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mera ha nematamonaka, me 12 na mati, mera hiyarebonaha. \"Te towakaba teke te famaha te. Me famaha me towaka, me famaha me towaka, nabanake. Me rabika me te nakitamahaba teke, owati ihi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ati ehene awa me tama nemetemoneke hawi ya awa ohariaro. Bao me weye karihi, sakora me weye karihi, yinero me kiharihi, ");
INSERT INTO jaa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","me ka makari famarihi, me ka sataya ta na, nabone ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","\"Tabora one ya te kobo ni ya te sawihaba teke yobe ohari ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Haha tera me nofari ya te tokomaba teke. Te ati kamiti me nofari ya te tokoma, naba teke tabora one ya. Te yana toni ya te teme te wisa tokanaba teke, hobokori bo tonahabana, te teme ka wami hobokori, me hiwahabana, te yawaha te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Me tokaha me narabi me nima nemetemoneke me ihi hiyara me ihi me nofamarabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Me rabika me me kasomemetemoneke me tamaha mati. Me kiya na me me kasoma nemetemoneke, orifa fehe ya me keketeha mati me tati. ");
INSERT INTO jaa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Towisawa Eroti me ihi tamine mitehimatamonaka, me nafi Sesowi ino hiri ni karo, waha. \"Yowao Batisita tohe awaka, kitamenoho. Makoni yama watohi awaka mata ya\", me ati nemetemoneke Sesowi me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Me one ati e nemetemoneke ahi: \"Eria amare?\" me ati nemetemoneke. \"Teoso ati kakamina tohe awaka. Hibati ka me nimetema ne awaka\", me one ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eroti tamine himite he ati yana nihimatamonaka. \"Yowao tati ota ti nakoseri kitamatasehita awaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eroti ati ehene Yowao me watibemetemoneke foyebonaha kateya tori ya, fati ati ihi. Eroti nisori Firibi fati itiwe Yowao hora hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yowao ati e nematamonaka ahi: \"Eroti haha yama hiri tinaha tiwehene Teoso nofakara. Himataba niso fati titiwahine tiri?\" Yowao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Faya Yowao foyehimatamonaka kateya ya Eroti ati ehene, Erotia hikako hinabowehibona hinahari. Erotia hinabowehibona hine nabowi hiwatorehimatamonaka, ");
INSERT INTO jaa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eroti hikayawahari. Yowao ehene amose Eroti hiwatomatamonaka. Eroti hinakomehematamonaka. Eroti Yowao narabo nima hine ati boti yama nima nematamonaka. Yowao ati miti fawa rihi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erotia yama amo ni noki hina amo ni kobo nemetemoneke waha. Yama we one ya Eroti ayaka hiri nematamonaka, Karireya ka me ka ayakabonehe. Mera ha nematamonaka, me sawihabone mati, hinaka anifesario ya. He nanarifa me toha, saotato mera yoyose me toha, yama me kiha me toha, na mera ha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Me ka ayakabone hiri ne Erotia bite kake sere nemetemoneke me nokosi ya. Eroti me one sere ni hinofemetemoneke kasiro ya. Eroti atona hiyarematamonaka. \"Tiwati yana nahi. Yama tinofa ini titi ya yama ta onahabana oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","\"Otaboro kote tinofi ya otaboro kote ta onahabana oke, kote ehebote. Keye amakere. Teoso owati mitaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yana na tokoma mati aate nemetemoneke. \"Ami himata okanikaribone?\" ati nemetemoneke. \"Yowao Batisita tati tikanikahabone tike\", mati ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Faya kama Eroti aate namehemetemoneke hibati ya. \"Afa yamabani ama ha, Yowao Batisita tati ta tiba karo tati foyahari barato ehebote tori ya hibati ya\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eroti yawi nafihimatamonaka kasiro ya. Yowao ahabi nofare Yowao tati ta nebona ati nematamonaka, me tamaha me ihi, he ati me mitaha mati, keye hiri nemona me hirabona karo. ");
INSERT INTO jaa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Saotato toyosemehimatamonaka Yowao tati kakamebonaha. Tokomematamonaka kateya ya Yowao nabowebonaha, tati ti hisehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kamehimatamonaka Yowao tati tama kanahari tati itariari barato ehebote ya. Tati ta hikawitematamonaka me ka atonari ni ya. Atona tati ta hikanamehimatamonaka fara mati ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yowao ahabe tamine he ya tataba me mitaha me kamakiemetemoneke, me hekamehibonaha. Me hekame me hibehimatamonaka temenebona ya, yati hoti ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manakobisa me kamehemetemoneke Sesowi ni ya, me hiyosebaha mati. Me ihi me kaminamehemetemoneke Sesowi ni ya. Me ati me kamina nemetemoneke, tabora one ka me me hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","\"Hima yama one ya. Yama honara ya te hasi nibeya mata\", Sesowi ati nematamonaka. Me tamaha me yobi na me ihi Sesowi me tafihinaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sesowi ya he ya tataba me tabi oharia me kibehemetemoneke kanawa ya. Me towakemetemoneke yama honari ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Me one me hiwaha me yaka ni tai tohehemetemoneke hawi ya, tabora tamaha ka mati. Me kobo towitiemetemoneke, Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sesowi kisehimatamonaka kanawa ya foyahari. Me tamaha mera awehi mera aawawa nematamonaka, ofeya me nima me na mati, me nanarifa watara mati. Mera kanawanehimatamonaka yama tamaha ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bahi tokehimatamonaka. \"Sesowi bahi tokaka\", me ati nemetemoneke, he ya tataba mati. \"Tabora watakere ahi. ");
INSERT INTO jaa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Me tiyosemahi me tokomaba mati yamata me kanikaba mati tabora yabora ya, me hikababana\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","\"Me tafeba te ta nahi fara me te\", ati nematamonaka. \"Bao tamehi ota kanikene ota amake. Abariko 8 ne ka yama ahi ni manakone ya bao manakone tohehina amaka, me ka baobana, me tami karo\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","\"Te ka bao e ra, te tama kanahari? Bao te tomi kanahi\", ati nematamonaka. Faya bao me tomi kanehemetemoneke. \"Bao 5 toha, aba me fama, ke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mera yosehimatamonaka me nahohabone mati masiri mese ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Me abe ebe nemetemoneke tabora one ka mati. Me 100 na me toha, me 50 na me toha, me na me nahohemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sesowi bao 5 ne wara tokanematamonaka. Aba me fama na mera wara tokane neme awehi ati yana nematamonaka, \"Teoso faya amake\", ati nari. Faya bao ebe ne bao ta nematamonaka he ya tataba me ni ya, me ta hinehibonaha me one ni ya. Aba mera ebe, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Me nafi tafaha me akaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Me tafi hawa toha bao me awehemetemoneke hasi nari. Aba me toha nemetemoneke, me hasi na mati. Yamata isi ni hasi na me kayabemetemoneke. Isiri 12 na mo nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","5000 me tohehemetemoneke, me tafa mati, me makiti. ");
INSERT INTO jaa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hibati ya Sesowi he ya tataba mera yosehimatamonaka, me kibehabone mati kanawa ya, me tai toamabone mati kowani ya. Towitakosebona ati nematamonaka, mera toyosemahari. ");
INSERT INTO jaa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Me tokoma faya tokomisehimatamonaka, atami ya, Teoso hiyarebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yama kayomemetemoneke, me kafowasa ni ya faha baikani ya. Sesowi ohari toakosematamonaka, faha witi ya. ");
INSERT INTO jaa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mera awehimatamonaka, me nokosi ya boni kakeha ihi me ori ni kitamisa mati. Yama sirimaki ya Sesowi kamakimatamonaka, me ni ya, yaka nari, faha baki ya. Mera fiya towitinima ne ");
INSERT INTO jaa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","me hiwehimatamonaka, yaka nari, faha mese ya. Inamati ama nikani me ati na me eri kanehemetemoneke, ");
INSERT INTO jaa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","me kokoriri na mati kasiro ya. Sesowi ati yana nematamonaka me ni ya. \"Te kokoriri rima nahi. Owa amake. Te watorima nahi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tokehimatamonaka, kanawa beheri ya. Tofoyamisematamonaka, kanawa ya. Faya boni fawa nisehemetemoneke. Sesowi ehene me awaha he me kahiyarehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sesowi bao tonatamehi ehene me awibaha Sesowi kiti me watoremetemoneke, me ati boti yama watora mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Me towakariwa me kobo kanehemetemoneke, Senisare ya. Kanawa me matoha ");
INSERT INTO jaa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","me kisehemetemoneke, kanawa ka mati. Hibati ya Sesowi me awaha Sesowi me watohemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Me yana tona me tokomemetemoneke, me kana ni, me one narabi me nima nabone mati, tabora one ka mati. Fare Sesowi sawi nima me me tiwari kawahari nemetemoneke, me kiya na mati. ");
INSERT INTO jaa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Fare Sesowi kobo ne ka tabora ya me me hekamakia me me hinanahohemetemoneke, yama kori ya. Sesowi me aate nemetemoneke, hinaka makari tati boni me boyo hinahabonehe, hine ya. Faya hinaka makari me boyo hina ihi me kitamemetemoneke, me nafi. ");
INSERT INTO jaa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Serosarei ya fariseo me yana tona me tokehemetemoneke, Sesowi me awahabone mati. Mowisei ati kakamina me toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sesowi ya tataba me me awehemetemoneke, me tafahabone me yehe me soko ra mati. ");
INSERT INTO jaa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseo me ihi e te me amake ahi: Me tafahabone me yehe soko ni me tai tohate me amake, me ka iti me ati ihimetemonehe. Soteo me nafi ihi e tebisa me amake ahi. ");
INSERT INTO jaa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Soteo yamata me kanika me kamaha yobe ya me kobo nama yamata me wasiha yamata me soko kite me amake, me hikababonehe. Me ka kobo me soko, te me amake. Me ka faha wiye me soko nawaha, te me amake. Me ka yiwaha me soko nawaha, me ka katera me nanahori me soko, me ka mesa me soko, te me amake, me ka iti me ati ihimetemonehe. Yama one me hiri, te me amake. Fara me ka iti me ihimete ya me ihi tohate me amake, me ka iti me ati ihimetemonehe. ");
INSERT INTO jaa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sesowi me aate nemetemoneke, fariseo me toha, Mowisei ati kakamina me toha, me na mati. \"Sesowi himataba tiwa ya tataba me yehe me soko rineri, me tafahaba mati? E ka iti me atimete tika tataba me nofamara me awineke, me yehe me soko ra mati\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","\"Te ati boti hiyakere. Isaiya keye hiri remata awaka, tera kaminari, ati e nari ahi: 'Owa me nofahamone me ati na owa me nofakere me ati boti ya', Teoso ati nareka. ");
INSERT INTO jaa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","\"Owa me kahiyara kene. Me one me me kanawanate me amake fara me ati ya, owati amararo\", Teoso ati nareka', Isaiya ati nematamonaka. Isaiya ati amosaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","\"Teoso ati te nofamara te awineke. Te ka iti boteri me atimete ta te weye na te awineke. ");
INSERT INTO jaa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yama hiyara te hiri nineke, te ka iti me atimete te weye na te, sawiwamabana, fare Teoso ati sawi ka yama ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","\"Mowisei ati e nematamonaka ahi: 'Abi tinofa, ami tinofa, tinahabone tike'. Mowisei ati owa e nematamonaka ahi: 'E ka owa bati ni ya ati hiyara hiri ne ya te naboweba amaka. Mati ni ya ati hiyare hiri, ne ya te nabowa neba amaka', Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Te ati ta e na teke ahi, te ka iti me ati te kamina te: 'Teoso ka yamabone me ta nabone me ati na Teoso ka yamabone me ta ni ya ");
INSERT INTO jaa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","me ka abi ka yamabone me ta raboneke. Me ka ami ka yamabone me ta rihi naboneke', te ati nineke, te ka iti me ati te kamina te. ");
INSERT INTO jaa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Teoso ati te nahabineke, te ka iti me ati te nofi karo. Yama one hiri ni te nofa nineke, e naro ahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sesowi mera ha nematamonaka, tasa, me one, fara me one. \"Owati te kamita. Owati te watohi, e naro ahi: ");
INSERT INTO jaa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yamata e kabaha era tonahiyatera amake, Teoso ni ya. E ati hiyara ta era tonahiyate amake, Teoso ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sesowi tokiyomehimatamonaka yobe ya, me tamaha me ihi. Sesowi tokiyome me aate hinehimatamonaka, ati me hiwatobonaha, he ya tataba mati. ");
INSERT INTO jaa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","\"Ha te owati te watorihi nine?\" Sesowi ati nematamonaka. \"Haha yama kakeha e boti ya tokiyomaha ihi e tohiyatera e amake, Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yamata e kabaha e ati boti ya sawira e mi na era tonahiyatera amake, Teoso ni ya\", ati nematamonaka. Sesowi ati e nemata awaka ahi: Yamata nafi e kabatehabone amake, ati nemata awaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","\"E ati boti hiyara e ni ya sawiha ihi e ati hiyatera amake, Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yama hiyara tamaha kakete amake e ati boti ya. Yama hiyara e wati nawahate e amake e ati boti ya\", ati nematamonaka. \"E fanawi fanara e yori, e ka owa ka yama e boti, e ka owa e nabowa, ");
INSERT INTO jaa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","e ka owa fanehi fati e yori, yama tamaha e nofa, e ka owa ni ya yama hiyara e hiri, keye e hiri, e ka owa nokosi ya e ehene hiyarihi, e ka owa ka yama e aawawa, e ka owa e kako, e amosamone e ati, e ka owa ati e nofarihi, yama e na e hiri te e amake, e ati boti hiyari ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","E ati boti hiyara era tonahiyate amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sesowi yana tone tokehimatamonaka sitati Tiro ka ya. Kobo ne sawihimatamonaka me ka yobe ya. Me hiwarebona ati ne me one hiwehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Me ka one tamine himitematamonaka. Hinakamaki tokomakeha sonarisehemetemoneke he nokosi ya, bite karabikaharo, inamati ehene. ");
INSERT INTO jaa_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","He aate nemetemoneke, bite hikasomahabonehe. Siria kametemoneke, Keresia ka me ati ya ati tohaharo. ");
INSERT INTO jaa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sesowi ati e nematamonaka ahi he ni ya: \"Matehe hine tafi tai tohake. Matehe tafe e were kariyahi yome me ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","\"Matehe tafe homokori foro na yome me kaba kibone, mesa karo\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","\"Tiwati amosake owa ni ya. Tikamahi. Tikoto kitamake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Faya yana tona tokomemetemoneke fara tabori ya. Tokoma kama ya bite foreha towasimehemetemoneke bite amosawahamanihi. ");
INSERT INTO jaa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Faya Sesowi yana tonehimatamonaka Tiro ya. Tokomematamonaka. Sito fiya kanehimatamonaka. Tokomematamonaka Karireya ka faha witi ya ahi, Tekabori ka ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Me ka owa narabo hawitere me kakiehemetemoneke he ni ya, ati nihinarihi tehari. Sesowi me aate ba nemetemoneke, he boyo nebonaha, yehe ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hekamehimatamonaka. Me fami ohariemetemoneke. Narabo tofa hikanikimematamonaka yehe ya. Yehe firo kase ebete boyo hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Faya neme awehi hasi towiti ati yana nematamonaka. \"Fata tikanahi\", ati nematamonaka. \"Efata\", ati nematamonaka, fare ati ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Narabo fata tokanematamonaka fahi. Ebete amosawahe ya ati amosawahematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Me narabi nima hinehemetemoneke, he ehene me kaminarahabone mati. Me narabi nima ni hinatamina he me kaminemetemoneke fara me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Faya Sesowi ehene me kahiyarehemetemoneke. Me ati e nemetemoneke ahi: \"E narabo hawitera kasoma, e ati yana ni watotera kasoma, tehi amaka. Ehene amosaka, ehene nafi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yama wehe one ya me tamatasehemetemoneke. Yama kabahaba me kiharemetemoneke. Sesowi he ya tataba mera ha nematamonaka, mera hiyarebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Me aawawa oke\", ati nematamonaka, \"owa ni ya me sawiha mati. Me tafe watakere. ");
INSERT INTO jaa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me oyosemi ya me tokomi ya me kitaraboneke, hawi ya me yaka na mati, fimi ihi. Me one tabori hawi yaboha awineke\". ");
INSERT INTO jaa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","\"E awakere\", he ya tataba me ati nemetemoneke. \"Tabora watakere ahi. Hika ya bao e kanikaribe, me hikabebana?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sesowi me aate hinehemetemoneke. \"Te ka bao e ra?\" ati nematamonaka. \"Bao 7 ka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sesowi mera yosehimatamonaka, me nahorisahabone mati, me nafi. Bao wara tokane Teoso ha nematamonaka, \"Teoso faya amake\", ati nari. Bao ebe ne he ya tataba me ni ya bao ta nematamonaka, me ta hinehibonaha, me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aba me toha, nemetemoneke, me tamara mati. Teoso ha tasehimatamonaka. Mera hiyarematamonaka, he ya tataba mati. \"Aba me te ebe namakihi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Me tafa me nahohemetemoneke fahi. Me akaremetemoneke. Yamata isi ni hasi na ka isiri 7 nemetemoneke, mo naro. ");
INSERT INTO jaa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","4000 me tohehemetemoneke. Sesowi me hiyosema me tokomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sesowi me kibehemetemoneke kanawa ya, he ya tataba me ya tabahari. Me towaka me kobo kanehemetemoneke, Taomanota ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Me kobo kana me ni ya fariseo me kakehemetemoneke, ati me himitebonaha, me totomi hinehibonaha. Me hihiyarehimatamonaka, yama namohibonaha, Teoso ka yama, me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sesowi me ati mitehi hasi towitimatamonaka. \"Himataba Teoso ka yama te awahabone te ati nineri? Owati e nineke ahi: Yama te awateraba te amake, Teoso ka yama, Teoso ati ehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Me yana tona me tokibimehemetemoneke kanawa ya. Me towakariwamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Me ka bao oharimatamonaka, me tama hinahari, kanawa tori ya. Me ati katamoemetemoneke, bao ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sesowi me narabi nima nematamonaka. \"Tera te kakatomahi, fariseo Eroti me na me ka fehemeto ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Me abe hiyaremetemoneke. Me ati e nemetemoneke ahi: \"Sesowi himata ebe ne fehemeto kaminara? E ka bao watare ehene ati tohe awaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Me abe hiyarani Sesowi me ati watohimatamonaka. \"Himataba te ati kakineri, bao wataremona te ati na te? Owati te watomatarine? Owati te mitarini? ");
INSERT INTO jaa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Te noko naha yama te awakere. Te narabo naha hawira awineke. Bao 5 ne ebe onaharo ama oke, 5000 me tohaha me hikabebonaha. Yama te watomara te awine? Isiri e rite, yamata hasi na karo, mo naro?\" Sesowi ati nematamonaka. \"Isiri 12 naroke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","\"Aya bao 7 ne ebe onahara oke, 4000 me tohaha me hikabebonaha. Hinaka isiri e ri, hasi naro?\" ati nematamonaka. \"Isiri 7 narake\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","\"Afa owehene te watora te awine?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tabora Betisaita ya me kobo nemetemoneke. Me kobo na Sesowi ni ya me kakehemetemoneke, me ka owa noko awatere me kakia mati. Me aate hinehimatamonaka, me ka owa boyo nebonaha, yehe ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sesowi mano wara hine hekamehimatamonaka, tabora witi ya. Noko firo hikasematamonaka. Faya noko boyo hinehimatamonaka, yehe ya. Faya Sesowi aate hinehimatamonaka. \"Yama tiwini waha?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yama aawa nematamonaka, neme ya. \"Me owa oke, me yaka na mati. Awa nima me nineke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sesowi noko boyo hinamatasehimatamonaka, yehe ya. Yama awi amosematamonaka waha. Yama nafi awehimatamonaka waha. ");
INSERT INTO jaa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sesowi hiyosemematamonaka, tokomebonaha, fare hinaka yobe ya. \"Tokomarima tinahi, haha tabora ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sesowi me tokehemetemoneke, Firibi ka Sesareya yabori ka tabora ya. Hawi enoki ya Sesowi mera hiyarematamonaka. \"Owa me kamina me ati e na me awineri? Hibakemona owa me ati na me awineri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","\"Yowao Batisitamona me one tiwa ati narake. Eriamona me one tiwa ati, Teoso ati kakamina me ka owamona me one tiwa ati, narake\", me ati nemetemoneke, Sesowi ya tataba mati. ");
INSERT INTO jaa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Faya mera aate nematamonaka. \"Hibakemona owa te ati ri, ha te?\" Betiro ati yana nematamonaka. \"Kirisito ama tike. Ota ka towisawabona ama tike, Teoso hikaminehimata hibati ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sesowi me narabi nima nematamonaka, he me kaminarahabone mati, fara me one ni ya, Kirisito tohahari. ");
INSERT INTO jaa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Faya Sesowi hiyari yana tonehimatamonaka fahi, hiwa kaminari, me one ihi tohatehibona ati nari, Neme ka Owa tohahari. Me hikakotebona ati nematamonaka. Sasetoti me ka hiti mati, me nafi ka hiti mati, Mowisei ati kakamina mati, me nabone ati nematamonaka, me hikakotebana, me hinabowatebana. Faya ahabe ya kitamatebona ati nematamonaka, amo ni terei ne ya. ");
INSERT INTO jaa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yama kamini yokana Sesowi tohehimatamonaka waha. Betiro ya Sesowi me fami ohariabone Betiro ati nematamonaka, ati himitebonaha. Betiro Sesowi hora nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sesowi tonokowahame he ya tataba mera awehimatamonaka. Betiro hora kasehimatamonaka. \"Satanaisi tiyotowamahi onowati ka ya\", ati nematamonaka, Betiro hora nari. \"Teoso ati amare tikaminine tike. Fara tiwati amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sesowi he ya tataba mera ha, me one ha, nematamonaka, mera hiyarebonaha. \"E tabibone te ati nine? Fara yama tinofa hiri tirahabone tike. E famahabone tina tika ewenebone tiwa tikanabone tike, tihabibone ka awa. ");
INSERT INTO jaa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tiwa tikayawi ya tihababone tike. Owa tinofi ka tihabi ya tika kasomi nahabone tike. Hiyara amosa tinofi ka tihaba tini ya tika kasomi nahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","38","Kokoma tirahabone tike me nokosi ya, me ihi hiyara mati, Teoso me nofamara mati. Me nokosi ya owini hiri ni tinofari ya, owati kamini tinofarihi tini ya Neme ka Owa tiwini kaminatereba amaka kame ya, Teoso nanarifa me ya tabahari, kitahari Teoso ati ehene. Yama amosaba ama, tika kanamori fawa ni karo, yama nafi tikiha tiwa? Himata ya tika kanamori tikanikamaba ama tiri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sesowi mera hiyarematamonaka, he ya tataba mati. \"Te one me yati nasa na me nahaba me amake, Teoso ka towisawa kamabona ka yama ya. Te awehibonaka kamahari, e nafi ka towisawa tohawahari. Keye amakere\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yama wehe one ya yia 6 na ahabi ya Sesowi mera towakimisematamonaka, atami nemeha ya. Betiro toha, Tiako toha, Yowao toha, me na Sesowi mera towakimisematamonaka, neme ya, me ya tabi ohariari. Me nokosi ya hihiya nawahematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hinaka makari sawi kitehemetemoneke. Haha makari e awatera amake haro, e naro. ");
INSERT INTO jaa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eria ya Mowisei me famaha hine me kanafotokiemetemoneke, Sesowi me hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Betiro Sesowi aate nematamonaka. \"Habi yama amosake haro, e tabi karo. Yobe biti terei ne ota hiri naba otake. Tikaba ohari, Mowisei kaba ohari, Eria kaba ohari nebanaka\", Betiro ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hiyarebona atibona watore hine ya hiyarematamonaka, me kokoriri ni karo. ");
INSERT INTO jaa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Neme sabi kisaha mera moto kanehemetemoneke. E kakehemetemoneke neme sabi boti ya. \"Okatao amaka, onofari. Ati te kamitaho\". ");
INSERT INTO jaa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yama me kakatoma yama honaremetemoneke. Sesowi me awehemetemoneke, ohariari, me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Faya me kisamemetemoneke, atami ya. Sesowi me warabi nima nematamonaka. \"Haha yama te awaha te kaminarabone teke mata. Neme ka Owa ahabe wamisame nowati ya haha yama te awaha te kaminabone teke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Faya yama me kaminarehemetemoneke me ni ya. Hine ya me abe hiyaremetemoneke. Me ati e nemetemoneke ahi: \"Himata amari, Sesowi hikaminaharo, 'Owamisamabone oke', ati nari?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sesowi me aate nemetemoneke. \"Eria kamatebona Mowisei ati kakamina me hite amaka Teoso ka towisawa kakebona ka yama ya. Himataba me ati e teha me amari ahi?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","\"Keye amakere. Eria kamehibonaka yama nafi namosebonaha. Hibati ya otamine me kaminemete ama oke bisa, yama hani ya, me ati e na mati ahi: 'Neme ka Owa me wati kanahaba me amake, me hinofarahari', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Owati amake haro: Eria kamahareka hibati ya. Me hikatomehinoka. Me ihi e na me kaminemetemoneke, yama hani ya,\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sesowi he ya tataba me one ni ya me kobo na me me awehemetemoneke, me nahoha mati, me me hihiyarahani mati, me moto namahani mati. Me me hora hinehemetemoneke, Mowisei ati kakamina mati. ");
INSERT INTO jaa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Me nafi Sesowi awaha Sesowi me kahiyarehemetemoneke. Me nafi kana nawahemetemoneke. \"Sesowi afa ama ti?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sesowi ati yana nematamonaka. \"Himataba te abe hora nineri?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Me ka owa Sesowi ya tataba amare ati yana nematamonaka. \"Sesowi okatao owakamakine oke, tiwa ni ya. Ati yana ni wato nofare amaka, inamati ehene. ");
INSERT INTO jaa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Inamati ehene soni nofe amaka, bofe ya. Inohoti sabone toki nofe amaka, ino yaki kanahari, abono kitahari. Okominahareka tiwa ya tataba me ni ya, me hikasomehibonaha. Kasomi me hiwatorahareka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sesowi ati yana nematamonaka. \"Teoso kitehi kiti te watora te awineke\", ati nematamonaka. \"Yama nawahake e tabiba ka yama. Tekamaho owa ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Me hekamehimatamonaka, Sesowi ni ya. Inamati Sesowi awehino ehene inamatewe hiwa wiyi tonehimatamonaka. Sonehimatamonaka, inohoti sabone tokahari. Sone homehimatamonaka, hiwa karoro nari. ");
INSERT INTO jaa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","\"Hike nima tikatao ne ya yama kome awehimata amara?\" Sesowi ati nematamonaka. \"Nafire ya yama kome awehimari amaka. Fara yama nafi nima nofe amaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yifo witi ya sonarima nofe amaka, inamati ehene. Fara yama nafi nima bokarima nofe amaka, faha ya, ahabebonaha, inamati ehene. Otara kasomi tiwato ya otara tikasoma, tinahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sesowi ati yana nematamonaka. \"Himataba tiwati e nineri ahi, 'Yama tiwatoa ama ti?' tina tiwa? Owati tinofi ya yama ni hinara watateraboneke, tiwa ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Inamatewe bati ati yana kabote nematamonaka. \"Tiwati onofa oke. Owa kanawani yokana tihi ya tiwati miti forima onahabana oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sesowi mera awehimatamonaka, me tamaha mati, me kakeha mati, he ni ya. Inamati hora nematamonaka. \"Sa tisaho, warabo hawihibana waha, inohoti ati yana nama nebana. Tikamahi. Inamatewe tinarabikamarabana tike\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Inamati e kanehimatamonaka. Inamatewe hiwa wiyi tonehimatamonaka, inamati ehene, inamati sa hisahari. \"Ahabe awaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sesowi mano wara hine hinawamise wehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sesowi tokiyomamakehimatamonaka yobe toro ya. He ya tataba me aate hinehimatamonaka, me one watari ya. \"Himataba hinamati otara kasawarira, ota toyosemehibonaha?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sesowi ati yana nematamonaka. \"Hahi inamati era kasawarite amaka, Teoso e ha ri ya\". ");
INSERT INTO jaa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Me yana tona me tokomemetemoneke Karireya kowani ya. Sesowi me one hiwarebona ati nematamonaka, ");
INSERT INTO jaa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","he ya tataba mera kanawanehibona ati nari. Ati e nematamonaka ahi: \"Neme ka Owa me ta towitiaboneke me one ni ya. Me hinabowe ya yama we terei na ya kitamebonaka Teoso ati ehene\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ati me hiwatorehimatamonaka. Me aate hirihi hinematamonaka, me hinakomehe kari. ");
INSERT INTO jaa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Me tokomemetemoneke Kafanao ya. Yobe toro ya me kibeha Sesowi mera aate nematamonaka. \"Himata te ebe na te abe hora nineri hawi ya?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sesowi ati me mita me ati wataremetemoneke. Hawi ya me abe hora nibehemetemoneke, fara hine me kakatikaha mati, me ka towisawa mebone mati. ");
INSERT INTO jaa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sesowi itaririse mera ha nematamonaka, mera hiyarebonaha, me 12 na mati. Sesowi ati yana nematamonaka. \"Towisawa tohi tinofi ya me tinarifahabana tike, me nafi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Inamatewe ha ne inamatewe nawarimatamonaka me baikani ya. Hitimisehi tiwa himisematamonaka. Inamatewe tiwa ne mera hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Owa te nofi ka matehe te narifi ya owa te narifa te awineke. Owa te narifi ya Teoso te narifa te awineke. Teoso owa yosehi ama oke, okehabone owa ahi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yowao ati yana nematamonaka, Sesowi aate nari. \"Sesowi e ka owa inamati toyoseme ota awa otake, tiwini hiri nari. Ota ati hiyara otake he ni ya, e ni ya sawire karo\", Yowao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","\"Te hora rayaho. Owini ya mera kasome ya owa kakorehibonaka. ");
INSERT INTO jaa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Era me mono ra era me nofa me awineke. ");
INSERT INTO jaa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te ka fahabone me ta nabone me ati na Kirisito nonofa me te tohahamone me ati na me ihi Teoso awe ya Teoso mera kakawebonaka yama amosa ya. Keye amakere\". ");
INSERT INTO jaa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","\"Matehe owa nofaha me ihi hiyaraba wataraboneke te ehene. Tihabiba ka yama amosa awineke, haha yama hiri tirahabone tiwa matehe ni ya. Yama amosa awineke, yati ehebote ya mato wanaha ya tinamiti me mato ya tiwa me koro nifi ya, tihabibone karo ma boti ya\". ");
INSERT INTO jaa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","\"Tiyehe ihi yama hiyara hiri tini ya tiye ti tisahabone tike, tikamakehabone tiwa Teoso taboro ya, tiyehe oharia tiwa. Tikamakeriyahi yama hiyara ya, tiye famaha tiwa. Yifo hiri ni fawa tera amake fahi. ");
INSERT INTO jaa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Titeme ihi yama hiyara hiri tini ya titeme ti tisahi. Faya tikamakiyahi Teoso taboro ya, nowa tina tiwa. Tiwa me koro towitiriyahi yama hiyara ya, titeme famaha tiwa. Yifo hiri ni fawa tera amake fahi. ");
INSERT INTO jaa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tinoko ihi yama hiyara hiri tini ya tinoko soba tiwitihi. Tikamakibeya, Teoso taboro ya, tinoko oharia tiwa. Yama hiyara ya tiwa me koro towitiriyahi, tinoko famaha tiwa. ");
INSERT INTO jaa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yama abe tiwa kabarawariyahi. Yama abe fawa terawara amake fahi. Yifo hiri ni fawa rihi te amake fahi\". ");
INSERT INTO jaa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","\"Owa tinofi ya yifo hiri ni tiwa namosabone tike. Yamata nima tinahabone tike, amosaro, saha kihaharo. ");
INSERT INTO jaa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Saha amosate amake. Saha sinari watamari ya himata nima e ribe, saha sinari kamiba karo? Saha te kihahi. Te abe mono rima nahi. Te abe nofahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sesowi yana tone tokehimatamonaka tabora one ya ahi, Soteya ya. Toka, nematamonaka, Sotao kowani ya. Me tamaha me kakehemetemoneke tasa he ni ya. Mera kanawanehimatamonaka tasa. ");
INSERT INTO jaa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseo me hinakematamonaka, me aate hinehibonaha, me totomi hinehibonaha. Me ati e nemetemoneke ahi: \"E fanaha e ka yibote e nofamaraha e ka yibote e toyosematehani ama?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","\"Himata nima Mowisei ati ramatamona?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","\"Mowisei ati e nematamonaka ahi, e ka owa fati nofamarehibona tamine kaminari: E ka yibote e nofamarahaba e ati tohaha yama hani e rawi kite amake, e ka yibote ka yama hanibonehe, tokomabonehe\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","\"Teoso ati te kasawari ka Mowisei yama hani e na rawi kanehimatamonaka ahi. ");
INSERT INTO jaa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hibati ya Teoso yama nafi hiri ne ya Teoso makiteba hiri, fanawiteba hiri, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Makoni maki bati ya mati famaha mera kakosate amaka, fati ya famahari. ");
INSERT INTO jaa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Faya me famaha e abono oharia nima me naboneke. E famaha nima me raboneke, e oharia nima me na mati. ");
INSERT INTO jaa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Teoso me hinawanikimaharake. Fare Teoso ehene amaka. Me famaha me abe kakosaraboneke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yobe ya me sawimi ya me aate hitasematamonaka, he ya tataba mati, ati me hiwatowahebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ati e nematamonaka ahi: \"Tika yibote tekanakosa fanawi bara titiwai ya yama hiyara hiri tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tika yibote tiwa kakanakosa maki bare itiwai ya yama hiyara hiri naboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Matehe me kakamemetemoneke Sesowi ni ya, yehe kakibarehibonaha, matehe ni ya. He ya tataba me me hora nemetemoneke, me me kakamarahabone mati Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sesowi me ihi awe yawamisehimatamonaka. \"Matehe hine kamake owa ni ya. Me te ma nikiriyahi. Teoso ka towisawa kobo nake ya haha matehe nima me naboneke me ha hina mati, he ya me tabahabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Teoso ka towisawa tabi te nofi ya matehe nima te nabone teke. Matehe nima te ri ya Teoso ka towisawa ya te tabarabone teke. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sesowi matehe tiwari namise mera besa nematamonaka, yehe kakibarehari matehe mese ya, Teoso matehe kakatomehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sesowi yana tone tokomematamonaka hawi ya. Me ka owa kana ni kakehimatamonaka Sesowi ni ya. Iso yobati ya wehimatamonaka, Sesowi aate nari. \"Ota ka borofeso titaminate ama tike. Himata hiri oribe, oko wini fara tohatehabone owa Teoso taboro ya, ati ehene?\" ");
INSERT INTO jaa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sesowi ati yana nematamonaka. \"Himataba otaminahamone tine tiri? Teoso ta oharika, taminari. ");
INSERT INTO jaa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hibati ya Teoso ati yana nematamonaka, ati tiwatowahari. Ati e nematamonaka ahi: 'Te ka owa tinabowarabone tike. Tifana tika yibote amara ahi tirahabone tike. Te one me ka yama tibotirihi, keye hiri tirihi, tinahabone tike, te ka one me ihimone tikamina tiwa. Te ka owa tikeyerahabone teke, hinaka yama titihabonehe. Abi tinofa, ami tinofa, tinahabone tike', Teoso ati nematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","\"Owehene nafi e teha ama oke, onafira owa\". ");
INSERT INTO jaa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sesowi hekatome hinofematamonaka. \"Tika yama oharia hasi ke, hiri tinahabonehe. Tikamahi, tika yama ta tibeya, yinero manakonebana. Faya yinero ebe tinahi, me honara me ni ya. Tika yinero nafihibonaka fahi, neme ya. Yinero ta ni hawa tihi ya tikamabone tike owa ni ya, e famawahabone e\". ");
INSERT INTO jaa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sesowi ati mite tokomematamonaka, kokoriri nari, yama kihahari. ");
INSERT INTO jaa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sesowi nonokowa ne mera hiyarematamonaka, he ya tataba mati. \"Yama nihinakere haro, e ka owa honehi ka yama, Teoso ka towisawa ya famehibana\". ");
INSERT INTO jaa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sesowi ya tataba he ati me mita \"Hika\", me ati nemetemoneke. Sesowi ati yana namatasehimatamonaka. \"Matehe, yama nihinakere, Teoso ka towisawa ya e tabiba ka yama. ");
INSERT INTO jaa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E ka owa honehi e nebonaka ahi, kamero nima. Kamero ka yama nihinakere, tokiyomaba karo akoye hoti ya. Yama nawahi mati toha awineke, e ka owa honehi Teoso ka towisawa ya famaba karo\". ");
INSERT INTO jaa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Me abe hiyaremetemoneke, Sesowi ati me kahiyara mati kasiro ya waha. \"Teoso me hikasomahaba me watateraba me awineke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sesowi mera kakatome mera hiyarematamonaka. \"Yama nihinakere e ni ya. Teoso ni ka yama nihinake. Yama nihinaraba watatera amake Teoso ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Betiro ati yana nematamonaka. \"Sesowi ota ka yama ota kakosa otake, yama nafi, e tabawaibone karo\", Betiro ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sesowi ati yana nematamonaka. \"Te ka yobe te kakosini, e tabawaibone karo? Te ka niso me te kakosini, hiyara amosa te kaminibone karo? Te ka ami toharawa, te ka abi me toha, te ka asima toharawa, te ka matehe toha, te ka fatara toha, na te kakosini? ");
INSERT INTO jaa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Teoso te ka yamabone ta nebonaka ahi, bofe ya, yama tamaharo mata ya. Te ka yobebona toha, te ka niso mebone me toha, te ka asimarawabone toharawa, te ka amirawabone toharawa, te ka matehebone toha, te ka fatarabone toha, naboneke. Me one tera kakoaba amake. Yama toyabo ya te wini fara toha, tehaba teke Teoso taboro ya, ati ehene. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Me tamaha me tai toa me yotowamatehaba me amake. Me yotoha me tai tohawamatehaboneke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Serosarei hawi ya me tokomemetemoneke. Sesowi tai tohamematamonaka. He ya tataba \"Hika\", me ati nemetemoneke. Me one yotoha me kokoriri nemetemoneke. Mera ha nematamonaka tasa, me 12 na mati tasa, mera hiyari oharibonaha. Me one kaminematamonaka, he me kakoamone mati. ");
INSERT INTO jaa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","\"E tokomakehaba eke Serosarei ya. Neme ka Owa me ta naboneke sasetoti me ka hiti me ni ya, Mowisei ati kakamina me ya me taba mati. Me hikahabanebonaka, ahabebonaha. Me ta hinehibonaka bara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Me haha hikanebonaka, me firo hinahari. Me kosi hinehiba amaka. Me hinabowawaha hinehiba amaka. Manakobisa yama wehe terei ni ya wamisameba amaka yati tohawamari tasa\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tiako ya Yowao me famaha Sebeteo biti me tohaha Sesowi ni ya me kakiehemetemoneke, Sesowi me aate nabone mati. \"Sesowi fara ota ati nima tinahabone tike\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","\"Himata nima oribe te ni ya? Himata ta oribe te ni ya?\" ");
INSERT INTO jaa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","\"Towisawa tohi yana tini ka yama ya ota fami ka owa itaribonaka fahi, tika kanihina ya. Ota fami ka owa itari, nebonaka tika yasoka ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","\"Haha yama te kamina te watokere\", Sesowi ati nematamonaka. \"Fara kobo okofawahabone te kafawibana? Okofawaboneke hibayata ya. Oko batisa niteba nima te batisa ni naba te ama? Owa nima te tehaba te ama, owa me nabowabone owa?\" ati nematamonaka, ahabitebona kaminari. ");
INSERT INTO jaa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","\"Ee\", me ati nemetemoneke. \"Fara kobo okofawahabone te kafawaboneke. Oko batisa niteba nima te batisa ni nabone teke. ");
INSERT INTO jaa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Owati ihi amaraboneke, e ka owa itaribona karo obeheri ya. Teoso oharibonaka, e ka owa kaminari, itaribonaha obeheri ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sesowi ya tataba me one hiyara me mita Tiako ya Yowao me famaha me atimone me nofaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sesowi mera ha nematamonaka, mera hiyarebonaha. \"Bara me ihi te watote me amake. Me ka towisawa memone me ati e te me amake ahi: 'Ha owa ta me ka hiti ama oke', me ati te me amake. Me ka hiti me me yose, te me amake. ");
INSERT INTO jaa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Me ihi nima te ehene rabone teke ha te ta. Titaminahabone tina te one me tinarifahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tika one me ka hiti tohi tinofi ya me nafi nanarifa tihahabone tike. ");
INSERT INTO jaa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Neme ka Owa nima tinahabone tike. Neme ka Owa kakehareka, me one narifebonaha. Me hinarifarebona ati nareka. Kakehareka, ahabebona ati nari, me manakonebone nahabihibonaha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Me kobo tonamemetemoneke sitati Seriko ya. Sesowi he ya tataba me toha, me tamaha me toha, nemetemoneke. Seriko ya me tasi tonama Batimeo itarino ati yana nematamonaka hawi beheri ya. Timeo bitimatamona amaka Batimeo, noko awarari, yinero haha toahari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sesowi Nasare ka kakehimona me ati na me ati Batimeo mite ati yana nematamonaka, kita ya. \"Sesowi Tafi ka noti owa aawawa tinahi\", ati nematamonaka, Sesowi ha nari. ");
INSERT INTO jaa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Me tamaha me hora hikasematamonaka, ha ni fawa nebonaha. Ha ni fawa rematamonaka. Ha ni kitamisehimatamonaka mata ya. \"Sesowi Tafi ka noti owa aawawa tinahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sesowi ma nake mera hiyarematamonaka. \"Te ha naho\", ati nematamonaka. Me ha hinehimatamonaka, noko awaterari. \"Yayai tinahi. Tiwamisahi. Tiwa ha ka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Makari koro tose yora namise kakehimatamonaka Sesowi ni ya. Sesowi aate hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","\"Himata hiri onahabone tiri tiwa ni ya?\" ati nematamonaka. \"Habi, yama awi onofa oke\", Batimeo ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","\"Yayaka. Titaminawamabana tike waha, okitamone tini karo\", ati nematamonaka. Yama awamematamonaka hibati ya. Faya Sesowi me ya tabehimatamonaka, hawi ya. ");
INSERT INTO jaa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Me kobo namehemetemoneke, tabora Betifase ya Betania famaha ya orifa boti ka atami waha ya, Serosarei yabori karo. Me kobo nami ya he ya tataba mera yosehimatamonaka, me fama mati. ");
INSERT INTO jaa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","\"Te towakahi tabora ya, fa kowani ka tabora. Te towakiyomawiti ya tabora ya someto biti te wasihaba teke matohari, era weye namatarahari mata. Te tise ya te kakamebonaka ahi. ");
INSERT INTO jaa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Me ati yana ni ya 'Himataba te tisara?' me ati ni ya te ati e naba teke ahi: 'Ota ka Hiti hinahareka. Ta hinamebonaka hibati ya', te ati nabone teke\". ");
INSERT INTO jaa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Me towaka someto biti me awehemetemoneke, wahari hawi ya, matohari nokobi awe ya. Me hitisematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Me one nahoha me ati yana nemetemoneke. \"Himataba someto biti te tisineri?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sesowi ati me kamini ya me ati amosemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sesowi ni ya someto biti me kakama me ka makari me so nirihemetemoneke asometo bari ya. Sesowi itarimatamonaka, someto bari ya waha. ");
INSERT INTO jaa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Me tamaha me ka makari me so tonihemetemoneke hawi ya, hawinebonaha. Me one awa ini afe kihaha me baka nemetemoneke, me so hikanihabonehe hawi ya. ");
INSERT INTO jaa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Me one tai toha, me one yoto, nemetemoneke, me ha ni kitaha mati. \"Kakehareka Teoso ati ehene. Teoso hinofa hika. Teoso amosaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E ka iti Tafi hinaka noti towisawa tohawebonaka waha, fare Tafi nima. Teoso hinofa hika. Haha neme ka me winaha 'Teoso amosaka', me ati naboneke\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sesowi tokiyomematamonaka, Serosarei ya. Tokiyomehimatamonaka teboro wari ka yama ya. Teboro ka yama nafi ki nematamonaka. Fari tonamematamonaka Betania ya, he ya tataba me ya tabahari, me 12 na mati, bai toke ehene. ");
INSERT INTO jaa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yama wamini ya Betania ya me yana tona me tokoma Sesowi fimihimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fiko awaba nematamonaka, afe kihaharo. \"Fiko boni naha awineke\", ati ne tokehimatamonaka, fiko awehibonaha. Kobo towiti hiwa boni wataremetemoneke. Afe hinama tohehemetemoneke, fiko bobono amari ka yama tohi karo. ");
INSERT INTO jaa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ati yana nematamonaka. \"Fiko tibonomaraba ama tike\", ati nematamonaka. He ya tataba ati me himitematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Serosarei ya me kobo tonamemetemoneke. Tokiyomematamonaka teboro wari ka yama ya. Mera awehimatamonaka, yama me ta na mati. Me hiyosememetemoneke, me tokomabone mati. Yama me nikaha mera toyosema nematamonaka. Moweta me toroka na me ka mesa bebehe kawahematamonaka. Monowi me ta na me ka katera bebehe kawaha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","\"Yama te kakimaraba teke teboro wari ka yama ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mera kanawanehimatamonaka. \"Teoso ka yama hani ati e teha amake ahi: 'Oko yobe Teoso hihiyaramona me hinehiba amaka, tabora nafi ka owa me ha nabone mati', Teoso ati nematamonaka. Haha yama hani te watoke. Yama boboti me tabori tohawake te ehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, na Sesowi ati me mita me abe hiyaremetemoneke. \"Himata nima e nabowi neba amara?\" me ati nemetemoneke, me hinakomehari, me one Sesowi ati kahiyara me ihi, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bai toke ya me yana tona me tokomemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yama wamini ya me kama fiko me fiya tonamemetemoneke, waya tonaharo, nafi. ");
INSERT INTO jaa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Betiro yama wati nawahe ati yana nematamonaka. \"Ota ka borofeso fiko tiwa ha, fiko hora tinaharo. Waya tonake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","\"Teoso kiti te watowahi waha. ");
INSERT INTO jaa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yati nemeha waha hine koro nifehabone te ati ni ya ma ya, yati hine koro nifehaboneke ma ya, te ati ehene, Teoso kiti te wato ya, Teoso ati amosemona te ati boti ati ni ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Makoni owati e nara oke ahi: Teoso te ha ne yama ta nebona te ati ne ya, fara te ati nima yama naboneke, Teoso ati amosemona te ati ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Teoso ha tini ya me ihi hiyara fawa tinihabone tike. Me ihi fawa tinihi ya tiwehene hiyara neme ya te ka abi winehi tiwehene fawa nibonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Me tokomemetemoneke Serosarei ya. Me kobo tonama Sesowi yaka nematamonaka teboro wari ka yama ya. Sesowi yaka ne ni ya me kakehemetemoneke, sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, me ka hiti me toha, na mati. ");
INSERT INTO jaa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Me aate hinehimatamonaka. \"Hike ati eheneno yama e na hiri tine tiri?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","\"Tera aate okibone bisa ha owa. Yama te kamini ya owa okominahabone oke te ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","\"Hibake ati ehene Yowao mera iibofariseta amara? Teoso ati eheneta ama? Fare ati eheneta ama? Te ati yana nahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Faya me abe hiyaremetemoneke. \"Teoso ati ehenetemona e ati ni ya ati e neba awaka ahi: 'Himataba ati te nofareta amara?' ati neba awaka. ");
INSERT INTO jaa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Fare Yowao ati ehenemona e ati rabone eke bisa\", me ati nemetemoneke. Me one me nakomehemetemoneke, Yowao Teoso ati kakamina tohehimona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Me ati e nemetemoneke ahi: \"Yowao ota watokere\", me ati nemetemoneke. \"Yowao kamini te nofari ka owa yosehi kamini onofabisa okara\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sesowi hiyara kaminematamonaka me ni ya. \"E ka owa ofa tamaha koro nematamonaka. Yama bari kanehimatamonaka, ofa wati bari kanahari. Hoti wi nematamonaka, ofa boni me natabobone karo, fehe me hiri hinahabonehe. Yati hiri ni nemeha nawehimatamonaka, hinaka owa iitaribonaha, ofa kakatomehibonaha. He ni ya ofa me heta nemetemoneke ati ehene, ofa boni me ebe nabone mati. Faya tokehimatamonaka yama bara ya\". ");
INSERT INTO jaa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","\"Ofa boni hahata ka yama ya hinaka yama aahi yosemematamonaka ofa me ahi na me narabi nima nebonaha, ofa me ebe kanahabone mati\". ");
INSERT INTO jaa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","\"Ofa hiti ka yama aahi me hiwate me baro hine me hiyosemehimatamonaka, hinita tohahari\". ");
INSERT INTO jaa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","\"Hinaka yama aahi owa yosematasehimatamonaka. Tati me ba hirehimatamonaka. 'Tihiya tikere', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hinaka yama aahi owa yosematasehimatamonaka, me hinabowebanoho. Hinaka yama aahi me one tatama na yosemakehimatamonaka. Me one me baro, me one me waka, na tohehemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","\"Biti ya famasa nematamonaka, biti hinofari. Biti yosemakehimatamonaka me ni ya waha. 'Okatao me kakorahaba me awineke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","\"Faya biti kamaki kobo namaki me hiwe me abe hiyaremetemoneke. 'Efe biti amaka hari. Ofa hiti ahabe ya hinaka yama hihawaboneke waha. Hima e nabowaho. Hinaka yama e ihawaibeya', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Me hiwate me hekamematamonaka ofa wati beheri ya\". ");
INSERT INTO jaa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","\"Himata nima ofa hiti neba amara waha? Kame ya mera nahabihiba awaka afa mati. Hinaka ofa tabori totimake ya ta hiwahawitiaba amake me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Teoso ka yama hani te awatera ama, ati e naro ahi: 'Yobe me hiri na yati one me hinofara afa yati yobe ewene taiti tohineke waha. ");
INSERT INTO jaa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Teoso ati ehene amaka. Afa yama amosate amake mata ya e ni ya'\", Sesowi ati nematamonaka, Teoso ka yama hani ati kaminari. ");
INSERT INTO jaa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sesowi me watahabone me ati nemetemoneke. Sesowi mera kaminemona me ati boti ati nemetemoneke, haha hiyara kaminari. Sesowi me watahabone me ati na Sesowi me watara me tokomemetemoneke, me one me nakomeha mati. ");
INSERT INTO jaa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fariseo me toha, Eroti me one toha, na me tokomakehemetemoneke Sesowi ni ya Sesowi me aate nabone mati. Sesowi me aate ni ya Sesowi ati hiyarebona me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Me kamakia Sesowi me hiyaremetemoneke. \"Ota ka borofeso ama tike. Borofeso tiwa ota watoke, me tinakomehara tiwa. Yama nafi tikaminate ama tike me nafi ni ya. Keye hiri titera ama tike. Otara tikanawanate ama tike, Teoso ka hawi yokana ya. Tiwati ota mitahabone ota ati na otake. Sesa ni ya yinero e ta te ama? Himata nima tiwati ribe?\" ");
INSERT INTO jaa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sesowi me keyehabone me ati na Sesowi me hiwatoemetemoneke. \"Himataba owa te totomi nineri? Oko mowetaba te kakamahi, owehibana, tenario\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Me hekamehimatamonaka. \"Hibake kanamori amara hari, moweta kari? Hibake ino amara ha, moweta kari?\" Sesowi ati nematamonaka. \"Sesa ino amaka, Sesa kanamori ya famahari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","\"Fare Sesa ka yama te ta nabone teke fare Sesa ni ya. Fara Teoso ka yamabisa te ta nahi fare Teoso ni ya\", ati nematamonaka. 'Hika', me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Manakobisa satoseo me one kakehemetemoneke Sesowi me aate nabone mati. E ahaba Teoso era nakitamarebona satoseo me ati te me amake. ");
INSERT INTO jaa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"Borofeso Mowisei ka yama hani ati e teha amake ahi e ni ya: E ka owa ahabe fati kahiwara haro nisori fati hitiwahaboneke, biti nawahabonehe, hahi ahabe biti nawabona kari, Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","E ka owa biti me 7 nemetemoneke. Taiti fanehi kahiware ahabematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nisori fati hitiwa nisori ahaba, nematamonaka, kahiwarahari tasa. Nisori owa toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nisori me one ahaba, nemetemoneke, me kahiwaraha mati. Fana ahaba, nemetemoneke me nowati ya. ");
INSERT INTO jaa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Teoso ati ehene me kitami ya hike fati tohahaba amari, me nafi yabaharo?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","\"Te ati hiyakere\", Sesowi ati nematamonaka. \"Teoso ka yama hani te watotera te amake. Teoso te watorihi, ke, kitahari. ");
INSERT INTO jaa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","E ahaba e kitama e abe itimatera amake. E e nabone eke, Teoso nanarifa me nima\". ");
INSERT INTO jaa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","\"Afa yama e kaminaboneke, e wamisami karo. Mowisei ka yama hani te awarini, ati e naro ahi? Mowisei Teoso hihiyarehimona ati nematamonaka awa bite wai ya. Teoso ati e nematamonaka ahi: 'Abarao, Isaki, Yako, me na me ka Teoso ama oke', ati nematamonaka, me sawisa ni karo he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E ahaba ka Teoso amakara. E yati tohaha e sawiha ka Teoso amaka. Te ati e na hiyakere mata ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Me hiyarani me ka owa Mowisei ati kakamina tohehi kakehi me ati mitehimatamonaka. Sesowi ati mite Sesowi ati amosematamonaka he ni ya. Sesowi aate nematamonaka. \"Himata yama amosa Teoso nofate amara kasiro ya?\" ");
INSERT INTO jaa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"Teoso ati e te amaka ahi: 'Owati te kamitamatahi, Ihayeo me te tohaha te. Teoso e ka Hiti oharite amaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tika Hiti Teoso tinofabone tike tiwati boti ya kasiro ya, tika kiti ya tabaharo', Mowisei ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Teoso ati owa e te amaka ahi: 'Fara tiwa tinofa tiwa nofi nima te one me nofi tinahabone tike'. E ehene e na Teoso hinofate amake ahi kasiro ya. Teoso ati famate amaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","\"Ota ka borofeso tiwati amosake\", Mowisei ati kakamina ati nematamonaka. \"Tiwati e narake ahi: 'Teoso owa watatere amaka. Teoso oharite amaka', tinahara tike. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Teoso e nofatehabone Teoso ati te amaka e ati boti ya kasiro ya. Fara era e nofa era nofi nima e one me nofi e nabone Teoso ati te amaka. E ehene e na Teoso nofate amaka ahi, kasiro ya. Bani e tabasi na Teoso ni ya bani e ta na e aamosa raba te amake Teoso ni ya. Teoso era nonofa raba te amaka, yama one e ta ni ya he ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sesowi ati himite yama watohimona hinehimatamonaka. \"Ha tiwa Teoso ya te faminima ke\", Sesowi ati nematamonaka. Sesowi aate ni me fawa nemetemoneke waha, me habi bayimari karo. ");
INSERT INTO jaa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sesowi mera kanawanehimatamonaka teboro wari ka yama ya. \"Kirisito Tafi hinaka noti tohatehibona Mowisei ati kakamina me ati nofa me amake. Himata me ebe na me ati e nineri ahi? ");
INSERT INTO jaa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Fare Tafi ati e nematamonaka ahi: 'Teoso ati e nareka ahi oko Hiti ni ya: \"Tiwitarehi oko kanihina ka ya. Tiwa me nofara me kitaraba me amake tiwehene, owati ihi. Tiwariabone tike me mese ya, me tai tikana tiwa\"', Tafi ati nematamonaka, Teoso ati kaminari, Teoso Kanamori ati ehene. Kirisito Tafi ka Hiti tohehimona Tafi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kirisito Tafi Hiti hinihematamonaka. Kirisito Tafi ka Hiti tohe ya himataba hinaka noti tohehiba amara?\", Sesowi ati nematamonaka. Me nafi Sesowi ati kamitemetemoneke. Ati me hinofematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mera kanawanehimatamonaka. \"Tera te kakatomahabone teke, Mowisei ati kakamina me ni ya. Me yaka teha me amake sitati ya, makari yaboha me akaha mati. Mekato ya me sawiha me one ati yana ni me nofate me amake, 'Afa ama ti?' me ati na mati me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sinakoka ya me sawiha nahori me nofateha me amake me one nokosi ya. Ayaka ya me sawiha nahori me nofateha me amake ayaka hiti beheri ya. ");
INSERT INTO jaa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","E fanawiri makiti kihamarawara yinero ta narawabone me hirawa yinero kiharawara yobe ta narawabone me ati te me amake. Afa me ihi yobe kihamaterawara amake. Fara me ora ni yaboteha me amake, me one me ati me himitibone karo, me me kahiyaribone karo. Teoso mera kosi tehiba amaka mata ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sesowi itaribasematamonaka yinero kafori beheri ya, mera kakatomahari, yinero me te na mati fare yinero wiyene ya, teboro ka yinero wiyene. Me tamaha yinero me kihaha yinero me were nemetemoneke, yinero tamahari. ");
INSERT INTO jaa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Me ka one kamakiemetemoneke honararo, maki ahabemata. Hinaka moweta famehi te nemetemoneke, fotarari. ");
INSERT INTO jaa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sesowi he ya tataba mera ha nematamonaka, mera hiyarebonaha. \"Ihi te awa haro, maki watamarahari, honararo. Hahi yinero fanawi honara ta hinehi nafi mati tohaka. Me one yinero ta hinehi ta fotakara. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Haha me honaha me ka yinero hasi ne me ta hinareka. Fanawi honara hinaka yinero nafi ta narake, tafeba kanikaraharo mata\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sesowi me kiyomamehemetemoneke teboro wari ka yama ya. Sesowi ya tataba owa ati yana nematamonaka. \"Ota ka borofeso yati tiwa ha teboro karo. Teboro taboro ka yobe tiwa ha, yobe ehebote\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","\"Yobe te awe awa, amosari?\" Sesowi ati nematamonaka. \"Hahi yobe nafi me nabowaba me amake. Yama bari kani hasi naba watamarahaba amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sesowi tokomisehimatamonaka, orifa wati ka atami waha ya. Itarimatamonaka, teboro kakatomahari hike ya. He ya tataba me ya tabi oharimatamonaka. Betiro, Yowao, Atere, Tiako, Sesowi me aate nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"Yama amo ni e ni ya natehaba amari, afa yama? Himata nima yama na ota awibaribe, Teoso hinamoaro?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","\"Tera te kakatomahi. Tera me keyehariyahi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","\"Me tamaha me kakehaba me amake, owamone hine me toniha mati. Me ati e naba me amake ahi: 'Efe ama oke', me ati naba me amake, me tamaha me me keyeha mati. ");
INSERT INTO jaa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yama mowa ni tamine te mitahaba te amake. Me tamine te mita, naba te amake, me abe mowa nabone me ati na mati. Te watorabone teke. Afa yama kakehaba amake, Teoso ati ehene. Yama nafi ahabaraba amake mata. ");
INSERT INTO jaa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bara me abe mowa naba me amake. Towisawa me toha naba me amake, me abe mowa na mati. Me tafeba watamaraboneke. Wami behe naba amake tabora nafi ya. Yama nafi ahabarahaba amake mata. Yama hiyara yana tobone ka yamabone amake haro. Yama hiyara one nafisa naba amake mata\". ");
INSERT INTO jaa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","\"Tera te kakatomiyahi. Tera me te naba te amake, tera me ta naba te, me ka sitati me ka hiti me ni ya. Tera me kosi naba me amake sinakoka toro ya. Tera me namohaba te amake kofenato me ni ya, owa te nofa owehene. Tera me namo naba te amake, kofenato me toha, towisawa me toha, na me ni ya. Owa te kaminabone teke me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Teoso ati ehene hiyara amosa kaminatehiba amaka tabora nafi nima. ");
INSERT INTO jaa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tera me towakami ya me one ni ya tera me ta ni ya, 'Himata nima owati ribe?' te ati boti ati raba te amake. Afa yama ya te ka yama te kaminaba Teoso ta neba amaka. Te ati amaraboneke. Teoso Kanamori atiba amaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","\"E ka owa anoti ta neba awaka, me one hinabowehibana. Owa hinaka matehe ta neba amaka me one ni ya, me me hinahabihaba mati. Owa bati ya mati me famaha mera kakoba amaka. Mera ta neba amaka, me one me me waka hinahaba mati. ");
INSERT INTO jaa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Me nafi tera kakoaboneke, owa te nofi karo. Owa nofi te fawa ri ya Teoso tera kasomebonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yama habosia te awahaba te amake, wareharo tabori amara ya\". (Oko yama hani te ki na yama okominaha te watohi.) \"Soteya ka tabora ya te sawiha te tokomaba te amake yati nemeha ya. ");
INSERT INTO jaa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yobe bari ya tiwariha tikamabana tike hibati ya. Tikisami ya tikiyomamarahabone tike yobe toro ya, tika yama tinakamahabone tiwa. ");
INSERT INTO jaa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Fatara ya yama ahi tina tokomakabote tinahabone tike. Tikamarabone tike tabora ya, tika makari tinakamahaba tiwa. ");
INSERT INTO jaa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Me fanawi nabati weyeri narawa kokoriri narawaboneke. Me fanawi one matehe yoari fehe hifarawaha kokoriri narawa naboneke. ");
INSERT INTO jaa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Teoso te aate, niyahi, sire yama toharibone karo. ");
INSERT INTO jaa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yama e naba watatera amake, hiyararo, haha nima naro. Yama e naba watamaterihi naba amake, hiyararo. ");
INSERT INTO jaa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Haha yama Teoso sene nimehibonaka, hinaka me ihi, me hikatikaha mati. Ehene e re ya me nafi ahabene me amake\". ");
INSERT INTO jaa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","\"Haha yama tohi ya me ati e naba me amake ahi: 'Hahi Kirisito amaka', me ati naba me amake. 'Te awa fari', me one ati, naba me amake. Me ati te nofariyahi. ");
INSERT INTO jaa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Me one Kirisitomona me ati naba me amake, keye me hiri na mati. Me one Teoso ati kakamina memone me ati, naba me amake, keye me hiri na mati. Yama me namohaba me amake, fotaharo, me hiwatoharo. Me tamaha me me keyehaba me amake. Haha Teoso me hikatika me me keyehene me amake fahi. ");
INSERT INTO jaa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Te ati katamoriyahi. Yama kamini tai ohine oke, te watobahabonehe, nafi\". ");
INSERT INTO jaa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","\"Afa yama nawaha ahabi ya bahi owihiba amaka. Abariko oyamarihi neba amaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Amowa me foro naba me amake. Neme nafi hihiya nawahaba amake. ");
INSERT INTO jaa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Faya Neme ka Owa me awahaba me amake, kamahari, sawihari neme sabi boti ya, kitahari, oya kanikimahari kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ati ehene he nanarifa me me yoro tokaniwamaba me amake, me hikatika mati, me sawiha mati yama nafi ya\". ");
INSERT INTO jaa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","\"Yama te watohaba te amake, fiko ka yama nima naro. Fiko afe yati kitara afe yanaha te awaha yama te watote te amake, yama hiwe ka yama, yabokiraharo. ");
INSERT INTO jaa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Fiko ka yama nima Neme ka Owa ka yama naboneke, kamahari. Haha yama okominaha te awi ya yama te watohaba te amake, Neme ka Owa kamabona ka yama, yabokiraharo. ");
INSERT INTO jaa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Te one me sawisa naboneke haha yama okominaha nafi kaki ya. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hine ya neme ahaba, wami ahaba, tehaba amake. Owati ta ahabateraba amake. ");
INSERT INTO jaa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Teoso biti kamabona ka yama wehe e watotera e amake. Teoso nanarifa me hiwatorihi, Teoso biti hiwatorihi, hite amake. Okobi ta hiwato hike, ohariari\". ");
INSERT INTO jaa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","\"Te ati katamoriyahi. Te amo riyahi. Neme ka Owa kamabona ka yama te watorineke. ");
INSERT INTO jaa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","E ka owa nima yama naboneke, tokahari tabora one ya, hinaka yama aahi mera yosehari, hinaka yama me hekatomabonehe. Hinaka yama aahi owa yama koro, hinaka yama aahi owa yamata wasi, owa nokobi ya ware, nematamonaka, yama kakatomahari. Amo rebona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Te ati katamoriyahi bisa. Te ka Hiti amo ni te watokere, kamehibonaha. Bahi toke ya kame ya kama, yama soki ya kame ya kama, yama soki enoki ya kame ya kama, yama we kamaki ya kame ya kama, neba awaka. ");
INSERT INTO jaa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Te amo ni bata karayaho. ");
INSERT INTO jaa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Te tonokoyahi. Me one toha, te toha, na te narabo nima one oke\". ");
INSERT INTO jaa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yama wehe famaha hasi kanehemetemoneke, bao fehemeto kihare ka ayaka me hiri nibone karo, Basikowa tohaharo. Sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, na Sesowi me watahabone me ati nemetemoneke, me one me me hiwara mati, me hinabowebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wati me hinofarematamonaka Basikowa ka ayaka tohi karo, me tamaha me me nakome karo. Me me mono rabone me ati nemetemoneke, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sesowi sawihimatamonaka Simao mese hiyare ka yobe ya, Betania ya. Sesowi tafehi itari ni ya fanawi kakehemetemoneke, yama tama kanaharo, yama wiye yati yama ni tohaha ya, esitarato kafoyini karo, nato hinita. Yama waka kana yama sika nisehemetemoneke, Sesowi tati ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ihi nofati me amara me abe hiyaremetemoneke, me one. \"Himataba esitarato katomineri, manakone nafiharo, ");
INSERT INTO jaa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","fa fowe oharia ka yama ahi ni manakone ya manakone tohaharo? Yama amosene amake, esitarato ta ni ya, yinero manakonebana, yinero e ta nibone karo me honara me ni ya\", me ati nemetemoneke. Faya fanawi me hora nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","\"Hine hikatoma hike\", Sesowi ati nematamonaka. \"Himataba ihi e na ihi te hora kineri? Ihi amosake owa ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Me honara me sawi fawa teraboneke te ni ya. Fara me kasomi te nofi nima te nabone teke. Ha owa ta oko sawi fawa nabone oke te ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Fara ihi hiri nineke. Ohabamatara owa ketehineke esitarato ya, oko kamobone ayata tohi karo. ");
INSERT INTO jaa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yama toyabo ya, hiyara amosa yama nafi ya me kamini ya, fana ihi me kamina, tehaba me amake. Ihi me wati hiwahatehaba amake. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yota Isikarioti tokomakematamonaka sasetoti me ka hiti me ni ya, Sesowi ta nebona ati nari me ni ya. Me 12 na me ka owamatamona amaka, Yota. ");
INSERT INTO jaa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ati mitati me yayai nemetemoneke. Yinero me ta nabone me ati nemetemoneke Yota ni ya. Faya ati boti yama nima nematamonaka, Sesowi ta nabona ka yama, me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Basikowa ka ayaka yana tonehemetemoneke, bao fehemeto kihare ka ayaka. Ayaka yana toni ka yama wehe ya ofeya me me wawaka tohehemetemoneke. Sesowi he ya tataba me aate hinehimatamonaka. \"Hika ya Basikowa ka marina tafeba ota wasiribe, e tafibone karo?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Me fama mera yosehimatamonaka. \"Sitati ya te towakahi. E ka owa te kobo nabone teke, faha tiwa kanahari boti ya. Efe nowati ya te kayotoabone teke. ");
INSERT INTO jaa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yobe ya tokiyomame ya yobe hiti te aate niyahi, te ati e na te ahi: 'Borofeso ati e nareka ahi: \"Hibaka ya yama bari kani tori ya otafaribe Basikowa tafe okoba owa, oko tataba me ya otaba owa?\" ati nareka', te ati nabone teke. ");
INSERT INTO jaa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yama yofi kanehibonaka, yama bari kani tohamisamakeharo, tori nafiharo, mesa kihaharo, hawa tohaharo. E ka marinabone te hawa tonihabone teke fahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Faya me towakemetemoneke sitati ya. Fare Sesowi ati nima yama nemetemoneke. Faya Basikowa tafebone me wasihemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bai toke ya kobo namakimatamonaka me 12 na me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mesa ya me tafa me nahoria me ni ya Sesowi ati yana nematamonaka. \"E taba e tafaha te ka owa owa ta neba amaka me one ni ya. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me yawaha me oohariki na Sesowi me aate nemetemoneke. \"Sesowi owaba ama ha owa?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","\"Te 12 na te ka owabonaka. E tabaha bao e taba nineke haro. ");
INSERT INTO jaa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Neme ka Owa e nebonaka, fara yama me hikaminehemete nima, Teoso ka yama hani ya. E ka owa hiwa yokohiba amaka, Neme ka Owa ta ne ya. He ni ya yama amosenemete awineke, watare ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Me tafaha Sesowi bao itihi ati yana nematamonaka, \"Teoso faya amake tiwehene\", ati nari. Bao ebe ne mera kakawematamonaka. \"Bao te warara nahi. Hahi oko ime amaka hari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kobo tama ne ati yana namatasehimatamonaka, \"Teoso faya amake\", ati nari. Kobo ya mera kakawe me hifehemetemoneke fahi. ");
INSERT INTO jaa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","\"Haha fi oko emene nima nineke haro. Ohabi ya Teoso te ya tabe kotarato yati hiri nebonaka. Ohababone oke, me tamaha me okasomabone owa. ");
INSERT INTO jaa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ofa fehe ofamaraba ama oke mata. Ofamateba amake, te ya otaba owa, towisawa ohi ya, Teoso ati ehene. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Teoso tahi me hiri na me tokomemetemoneke orifa wati ka atami ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sesowi me narabi nima nematamonaka. \"Te nafi owa kakosabone oke. Teoso ka yama hani ati e te amake ahi: 'Ofeya me nanarifa onahabihe ya ofeya me tokarikosahaba me amake', yama hani ati ke. ");
INSERT INTO jaa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ohaba okitamahaba ama oke. Tai owamaba ama oke Karireya ya, te nokosi ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Betirobisa ati yana nematamonaka. \"Me nafi tiwa me kakosi ya tiwa owakanakosarabone oke, ha owa. E famahabone eke, ha owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","\"Haha yama soki ya owa tiwateramone tinahabone tike me one ni ya. Tiwati yana ni terei nabone tike, tiwati e na tiwa, arakawa ha ni famahi ha ni watare ya mata. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Betiro Sesowi hora kasehimatamonaka kasiro ya. \"Owati yana rabone oke, tiwa owateramone ona owa. Keye amakere. E fama me one era nabowabone me ati na tiwa owakanakosarabone oke\", ati nematamonaka. Me nafi ati e nemetemoneke, Betiro ati nima. ");
INSERT INTO jaa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Me tokehemetemoneke Ketisemani ya. Awa wati ka yama inimetemone amake, Ketisemani. Sesowi he ya tataba mera hiyarematamonaka. \"Teoso ha omatibe. Te naorihi ahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Betiro toha, Tiako toha, Yowao toha, me na me ya tabe mera towakematamonaka. Faya ati boti yawamisehimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mera hiyarematamonaka. \"Owati boti kokoriri ke. Ahabinima one oke, kokoriri oni karo. Te nahori ahi, te tonokoa te\". ");
INSERT INTO jaa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hike ya toka ne sonarisehimatamonaka, Teoso ha nari. \"Aba abi tiwati amosi ya ohabarahabone onahara oke. ");
INSERT INTO jaa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Abi yama nihinaraba watakere tiwa ni ya. Kobo tekitimakehi, onofa okere. Yama onofa ya owehene toharabone oke. Fara yama tinofa ta hiri onahabone oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kame he ya tataba me terei na mera wasimematamonaka, me amo nani mati. \"Simao, amo tine ti? Tikitarini? Tikitara tiwa awine tike, tinokoaba tiwa, bahi ohari ya\", ati nematamonaka, Betiro hiyarari. ");
INSERT INTO jaa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","\"Te tonokohi, te ora na te, te ehene hiyara wataribone karo, inamati tera totomi ne ya. Te ati boti amosa yama amosa te hiri nabone te ati na yama tera kasawarineke, te kitara te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tokatase ora tasehimatamonaka. Fara yama hikaminaha kaminamatasehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kamatase mera wasimatasehimatamonaka, me amo nani mati, nokobisa me koro hikanani mati. Kamehi ehene me tafiha me ati wataremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tokomatase kamatasehimatamonaka. \"Te amo tasine? Te hasi nine? Fayawa amake. Oko amo nibone amake haro. Neme ka Owa me ta kabote naboneke me ihi hiyara me ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Te nahomisahi. Hima, te awa hari, kamakiari, owa ta nebonaha\". ");
INSERT INTO jaa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","He ya tataba mera hiyarasa ne ni ya Yota kobo namakimatamonaka, me 12 na me ka owa. Me one ya tabehimatamonaka, yimawa toha, mata toha ne me bokori na mati. Sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, me ka hiti me toha, me na me me yosehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yota mera hiyaribehimatamonaka, Sesowi me watohabone mati. \"Efe noko toma onaki ya te wate ya te towakamehibanaka. Te hasi nirayaho\", ati nibehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Me kobo namakia Yota towanawitimarika Sesowi ni ya, hibati ya. \"Habi\", ati nematamonaka, he noko bako komi nakehari. ");
INSERT INTO jaa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sesowi me watehemetemoneke, me hekamebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Me ka owa ohari yimawa soba towiti sasetoti ehebote ka yama aahi owa narabo ra tari nabasematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sesowi ati yana nematamonaka. \"Te kamakine owa ni ya, yimawa toha, mata toha ne te bokori na te, owa te watahabone te ati na te? Kofeno mono onahamone te ati na te awineke. ");
INSERT INTO jaa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Owa te awi nofa te amake me okanawana owa teboro ka yama ya fara yama we nima. Himataba owa te wati nofara te amari, teboro wari ka yama ya? Teoso ka yama hani ya yama me hikaminehemete nima te ehene nineke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sesowi ya tataba me nafi kana nawaha me hekanakosehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ohari yotohimatamonaka, hine ya makari riyo tohaha weye nari, bofe ka watararo. Me hiwatematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Me tama hine hinaka makari sota tonaha tasi tone tokomematamonaka, korone tohahari. ");
INSERT INTO jaa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sesowi me towakamehemetemoneke sasetoti ehebote ni ya. Sasetoti me ka hiti me nafi me me yoro tokaniwamemetemoneke. Me ka hiti me toha, Mowisei ati kakamina me toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Betiro yotoba nematamonaka hike ya. Me kobo tonamemetemoneke, sasetoti ehebote ka yobe ya. Betiro wakosehimatamonaka yobe beheri ya, yifo hiwa nari, saotato me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sasetoti me ka hiti me ya soteo me ka hiti me nafi me tabaha Sesowi ahabebona me ati nemetemoneke. Me one me siba nemetemoneke, Sesowi me kaminabone mati, ehene hiyaremona me ati nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Keye me hiri na Sesowi ehene hiyaremona me ati nama nemetemoneke, me tamaha mati. Keye me hiri kene yama ati remetemoneke, mera kasawariharo. Owa ati yana, owa ati yana, nematamonaka, me ati hihiyanikima mati. ");
INSERT INTO jaa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Me one nahomisa Sesowi yama hiyara hiri nemona me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Ati e ne ati ota mitahareka ahi: 'Hehi teboro me hiri hinehi onasonahabone oke. Yama wehe terei na ya teboro hiri onahabana oke, me ihi amarari', ati nareka\", me ati nama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Me one ta ati hihiya nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Me baikani ya sasetoti ehebote wamise Sesowi aate nematamonaka. \"Tiwati watarine? Keye me hiri na me awine, tiwatimone me kamina tiwa?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sesowi ati watarematamonaka. Sasetoti ehebote ati yana namatasehimatamonaka. \"Kirisito ama ti, Teoso ota kahiyaratehi biti?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","\"Efe ama oke. Neme ka Owa te awatehaba te amake, itariari Teoso kitehi ka kanihina ka ya, kamahari neme sabi boti ya\". ");
INSERT INTO jaa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sasetoti ehebote yawehi fara hinaka makari sibi karematamonaka. \"Me e ha namarabone eke, he me kaminaba mati e ni ya, ehene hiyaremona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Fare abono ati te mitawahaka waha, Teoso nima nemona ati nari. Himata nima te ati ri?\" ati nematamonaka. Sesowi ahabebona me nafi ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Me one Sesowi firo nemetemoneke. Me one noko hikarafe noko me koho hiwitimatamonaka. \"Tiwati yana nahi. Hike tinoko tao kanara?\" me ati nemetemoneke. Saotato noko me tao hikanematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Betiro wabasehimatamonaka yobe beheri ya. Sasetoti ehebote nanarifa kakehemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yifo hiwa ne hiwehi hekatomematamonaka. \"Tisawi tina ama tike Sesowi ni ya, Nasare kari\". ");
INSERT INTO jaa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Betiro ati hiyarematamonaka. \"Yama owato okere, tikaminaharo\", ati nematamonaka. Nokobi wani yabori ya yaka toname ya arakawa ha ni yana nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sasetoti ehebote nanarifa hiwe yofi hikanematamonaka. \"Efe owa amaka hari\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ati hiyatasarematamonaka. Yama totoyabo kawahi ya me aate hinehimatamonaka, me nahoha mati he beheri ya. \"Me ka owa ama tike. Keye amakere. Tiwa ota watoha otake. Karireya ka me ka owa ama tike\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Betiro ati yana tasematamonaka, Teoso ino itihari. \"E ka owa hahi owatotere te kaminineke\", ati nematamonaka. Keye hiri ne ya Teoso hinabowebona ati nematamonaka, ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Arakawa ha namatasematamonaka. Faya Betiro yama wati nawahematamonaka, aya Sesowi hikaminaharo, he hiyarari. \"Tiwati yana ni terei nabone tike, arakawa ha namatasare ya mata, owa tiwateramone tina tiwa\". Betiro ati boti yawe ohi nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hiba yama wa ni ya me ati yana tonehemetemoneke, Sasetoti me ka hiti me toha, soteo me nafi ka hiti me toha, Mowisei ati kakamina me toha, na me nafi yoro tokana mati, me ka hiti me nafi. Sesowi mano me hikamato me heke me ta hiwitimatamonaka Birato ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Birato aate hinehimatamonaka. \"Soteo me ka towisawa ama ti, ha tiwa?\" ati nematamonaka. \"Ee, fara tiwati nima yama nineke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sasetoti me ka hiti Birato me hiyaremetemoneke, yama hiyara tamaha Sesowi hiri nemona me ati nama na mati. ");
INSERT INTO jaa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Birato Sesowi aate namatasehimatamonaka. \"Tiwati yana rine? Me ati timitahi, yama hiyara tamaha hiri tinahamone me ati na mati\", Birato ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sesowi ati yana namarematamonaka. \"Hika\", Birato ati boti ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Birato soteo me ka owa ohari fifito toniha tohehimatamonaka, fara Basikowa ka marina nima, me kibeha mati kateya ya. Mera aate ne me ka owa ino me hitihi yokana fifito toniha tohehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Me ka owa foyehi inomatamona amaka, Basaba. Basaba me one ya tabehi Homa ka me me mowa na me ihi itiha me me hiwata me me te hinehemetemoneke kateya ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Soteo me kamakia Birato me aate nemetemoneke, me ka owa fito tonihebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","\"Efe soteo me ka towisawamona fito onihibana te ni ya?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sasetoti me ka hiti Sesowi me ta na mera watohimatamonaka, me one tamaha Sesowi me nofi karo. ");
INSERT INTO jaa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Basaba Birato fito tonihebona me ati nemetemoneke, sasetoti me ka hiti me ati ihi. ");
INSERT INTO jaa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","\"Himata nima oniheba amara, soteo me ka towisawamonaha?\" Birato ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","\"Te ba kanaho awa ya, ahabebana\", me ha ni ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","\"Himatabana? Himata hiri rano hiyararo?\" Birato ati nematamonaka. Hine ya me ha ni kitamisehemetemoneke, \"Te ba kanaho awa ya\", me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Birato Basaba tasi tonihematamonaka, me yawi ya he me kakoribone karo. Ati ehene saotato Sesowi me kosi nemetemoneke. Faya saotato mera yosehimatamonaka, Sesowi me ba kanahabone mati awa ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Saotato Sesowi me towakamehemetemoneke kofeno ka yobe Beretorio tohehi ya. Saotato me nafi me ha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Makari mamawa na ya me weyeye hinihematamonaka. Tati boronebona me hikowemataka, atine kihaharo, towisawa tati borone nima naro, me weyeye hinihebanoho. ");
INSERT INTO jaa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Me haha hinehimatamonaka. \"Soteo me ka towisawa, titaminahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tati me baba hirehimatamonaka. Me firo hinehimatamonaka. Me isi yobati ya me naoha me boboko tokanihemetemoneke, he me haha kana mati. ");
INSERT INTO jaa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Faya haha kani me hawa hihe ya makari mamawa na me sota na fara hinaka makari ya me weyeye hinihamematamonaka. Me hekamematamonaka, awa ya me ba hikanebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Me yaka na Sireni ka owa me awehemetemoneke, kobo nakehari, Serosarei ya, kakehinoho Serosarei yabori kari. Inomatamona amaka, Simao, Aresatiri ya Hofo me famaha me ka abi. Me hiyosematamonaka, Sesowi ka awa tiwa kanehibonaha. ");
INSERT INTO jaa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sesowi me towakemetemoneke yama ini Kokota tohaha ya. E tati tone ino amake, Kokota. ");
INSERT INTO jaa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Miha atahone ya fi me ketehemetemoneke, Sesowi hifahabonehe, hifarabanihi. ");
INSERT INTO jaa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Awa ya me ba hikanematamonaka. Sesowi ka makari me ebe nemetemoneke. Yama me were nemetemoneke, makari me ebe nabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Me hinawanehimatamonaka bahi 9 ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Awa baki ya yama hani me rawi kana Sesowi tati neme ya awa me nawanemetemoneke, Sesowi ka yama hiyara hiri hina me watohabone mati. \"Soteo me ka towisawa amaka\", yama hani ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Yama boboti me famaha me me kanawikimemetemoneke Sesowi beheri ya. Hinaka kanihina ya owa kawa, hinaka yasoka ya owa kawa, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Hawi ya me yaka na me haha hikanematamonaka, me tati me weori na mati. \"Ahi\", me ati nemetemoneke. \"Fara tiwa tikasomahi, teboro tinahabihabone tina tiwa, hiri tinamebonaha yama wehe terei na ya. Tikisamahi awa ya\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sasetoti me ka hiti me toha, Mowisei ati kakamina me toha, na me abe hiyaremetemoneke, Sesowi me haha kana mati. \"Me one ta kasome hiwa kasomi watore awaka fare\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","\"Kirisitomona amaka, Ihayeo me ka towisawa. Kikisama naho, kisami e awabaya, ati e nofawabaya\", me ati nemetemoneke. He ya me tabaha me ati yana, nemetemoneke, he me hora na mati, awa ya me kawana mati. ");
INSERT INTO jaa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bai nokorise ya yama kayomemetemoneke, yama nafi. Manakobisa yama soki fawa nemetemoneke bai weo towawiti ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bai terei ne ya Sesowi ha nematamonaka kasiro ya. \"Teoso, oko Teoso, himataba owa tinaharikosine tiri?\", ati nematamonaka. Fara me atibisa amake haro: \"Erowi, erowi, rema sabakitani?\" ati naro. ");
INSERT INTO jaa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Haha me naho yabora ati me himitematamonaka. \"Ati te mitaho, Eria ino ha nari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Owa kana ni tokome finakiri towakitimematamonaka. Faya esibosa sa nife hinawanehemetemoneke, awa tati boni ya. Faya ta hikamisamakehemetemoneke, Sesowi hifahabonehe. \"Hine naka. Eria kake ya Eria hiti ya iti e aawa nebanaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sesowi ha ni kite ya ahabematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Teboro boti ka yama babari kana makari tohaha sibi karehemetemoneke. Neme ya sibi kari yana na sibi kari kisa sibi kari kobo nisehemetemoneke bofe ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Saotato me ka hiti waki Sesowi awehimatamonaka, ahabari. \"Hehi Teoso biti tohe awaka hari. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Me fanawi naho nemetemoneke hike ya, Sesowi me kakatoma mati. Maria Matarena toha, Sarome toha, Maria Tiako ya Yose me famaha me ka ami toha, Tiako yati. ");
INSERT INTO jaa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","He ya tataba toharawehemetemoneke Karireya ya, he narifarawaro. Me fanawi one toharawa nemetemoneke, he ya tabakirawaro Serosarei ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabato nokosi ka yama wehemetemoneke. Bahi tokehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yose kake kobo nakehimatamonaka, Yose Arimateya kari, me ka hiti me ka owa tohahari, yama kihahari. Teoso ka towisawa kakibona ka yama Yose nonoki tohehimatamonaka. Habo bayihi Birato aate nematamonaka, Sesowi abowi ta nebonaha he ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Keyemone Birato ati boti ati nematamonaka, Sesowi ahabamataremona ati nari. Saotato mera yoyose aate nematamonaka, Sesowi kaminebonaha. ");
INSERT INTO jaa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Saotato mera yoyose ati mite ati amosematamonaka, Sesowi abowi Yose itibasehibona ati nari. ");
INSERT INTO jaa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yose makari riyo tohaha kanike Sesowi itibase Sesowi rofi kawahematamonaka, makari ya. Hibehimatamonaka yati hoti me wi hinaha ya. Yati nafiha karoro towahame tama noki bori bari kawahamematamonaka yati ya. ");
INSERT INTO jaa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Matarena ya Maria Yose mati famaha yama me awehemetemoneke, Sesowi foye ka yama. ");
INSERT INTO jaa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabato nowati ya Maria Matarena toha, Maria Tiako mati toha, Sarome toha, me na e abowi tehene me kanikemetemoneke. Me hekamakiabone me ati nemetemoneke, Sesowi abowi me ketehabone mati. ");
INSERT INTO jaa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tomiko ya me bosa na hiba bahi kamaki ne ya me tokehemetemoneke Sesowi temene ya. ");
INSERT INTO jaa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Me abe hihiyara tosi nemetemoneke. \"Hike yati itiraba, e tokiyomiba karo?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Me kobo tonama yama me aawa na nokobi howa tokana me awehemetemoneke. Yati nafihemetemoneke, tama noki bori. ");
INSERT INTO jaa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Me tokiyoma yetene itari me awehemetemoneke, kanihina ka ya, makari sawawa akahari. \"Hika\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ati yana nematamonaka. \"'Hika', te ati rima nahi. Sesowi Nasare ka te siba na te awineke, Sesowi me ba hikanari awa ya. Watamakara ahi. Kitamatasahareka. Yama te aawa nahi, taboro, me hibari karo. ");
INSERT INTO jaa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Te tokomahi Betiro me ni ya, te tokominamabaya. Tai tohamebonaka te nokosi ya Karireya ya. Te awehibanaka fahi. Fare ati narima nebonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Faya tama ya me tasisi na me kana ni tokomemetemoneke, me hoyahoyari kana na mati, yama me kahiyara mati. Yama kamini me watoremetemoneke, me kakome karo. ");
INSERT INTO jaa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sesowi yati tohamematamonaka tomiko ya, yama hiba wa ni ya. Maria Matarena hiwibehimatamonaka. Afa hikasomehemetemoneke, hinamati me 7 na me ihi tohaharo. ");
INSERT INTO jaa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tokoma he ya tataba mera towasimemetemoneke, me ohi na mati, me yawaha mati. ");
INSERT INTO jaa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Faya hikaminehimatamonaka me ni ya, kitamari. Hiwehimona hinehimatamonaka. He ati me mitaha he ati me nofaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yama we one ya hinaka me one famaha sitati beheri ya yaka kanaha me ni ya kobo nematamonaka, noko awi hihiya nawahari. ");
INSERT INTO jaa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Me kakama hiyara me kamina me ati me hinofaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yama we one ya he ya tataba me 11 na me tafaha me ni ya kobo nematamonaka. Mera hora nematamonaka, me one ati me nofara mati, he kitami me awa mati. ");
INSERT INTO jaa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ati e nematamonaka ahi: \"Te tokahaba teke tabora bara ya yama nafi ya, hiyara amosa te kaminaba te, me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Haha owa nonofa me tohawaha me te iibofarisahabone teke, Teoso me hikasomahabone mati. Te ati me nofara Teoso me hikakohaboneke. ");
INSERT INTO jaa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Owa nonofa me tohaha yama me namohaboneke fotaharo. Inamati me toyosemaboneke, owini me hiri ni ya. Me ati hihiya naba me amake. ");
INSERT INTO jaa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Maka me wataha me tama ni ya, maka kome wataraboneke me ni ya, mera wai naro. Yama komaha me fawi ya yama kome watarihi naboneke me ni ya. Yama kome me awaha me mese ya me mani me kakibari ya me amosamaboneke\". ");
INSERT INTO jaa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","E ka Hiti Sesowi Kirisito hiyari fawa ne ya Teoso hekimisamematamonaka neme ya. Tokome itarimatamonaka Teoso ka kanihina wani ka ya. ");
INSERT INTO jaa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Me tokehemetemoneke yama nafi ya, Teoso ati me kaminabone mati. E ka Hiti ati ehene yama me namohemetemoneke fotaharo, he ati me kamina mati. Yama me awaha yama me hikamina me watohemetemoneke, keye amararo.");
INSERT INTO jaa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teofiro tiwa onofa oke, kasiro ya. Yama hani rawi okine oke, tiwahabonehe. Yama hani tiwaha yama hani tiwi ya tiwati e nabone onahara oke ahi: \"Hiyara omitaha amosa awineke\", tinahabone tike, oko yama hani tiwaha tiwa. \"Keye me hiri ra me awineke, Sesowi me kamina mati\", tinahabone tike. Me one yama hani rawi narawa me amake, Sesowi tamine, me tamaha mati. Me hiwehimata me hikaminate amaka, ota ni ya. Sesowi me awehemete Teoso ati me kakamina tohineke. Me ohiyarahara oke, yama owatoabone owa, oko yama hani amosabone owa. ");
INSERT INTO jaa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sasetoti me ka owa Sakaria tohe wiwina tohehimatamonaka, Soteya ya. Soteya ka towisawa inomatamona amaka Eroti. Sakaria Abatia ka notimatamona amaka. Sakaria fati inimetemone amake Isabeo. Isabeo hinakiti inomatamona amaka Arao. ");
INSERT INTO jaa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaria fati ya famehi me ihi aamosa tohehemetemoneke, fare Teoso ati nima me ihi nabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Me kakahiwa toharemetemoneke. Isabeo kahiwihina na toharemetemoneke. Me fami botokimehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Abariko owa ya Abatia ka noti sasetoti me tohaha Teoso ka yama me ahi nemetemoneke teboro ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yama wehe one ya me ati ihi Sakaria tokiyomehimatamonaka teboro baikani ya, wami sari kanehibonaha, Teoso ka wamibonehe. ");
INSERT INTO jaa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sasetoti wami sari kanehimatamonaka. Wami sari kane haha me nahokosa me tamaha Teoso me ha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Faya Teoso nanarifa kakehimatamonaka Sakaria ni ya. Wehimatamonaka, fara wami sasari kana beheri ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Teoso nanarifa Sakaria awe habo si tonehimatamonaka. Teoso nanarifa nakomehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Teoso nanarifa ati yana nematamonaka. \"Sakaria kakomerima tinahi. Tiwati Teoso mitehimona ati nareka, ha tinahari. Teoso ati ehene Isabeo inamatewe nawataboneke, tikataobonaha. Ino ha tinehibonaka, Yowao tohehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yayai tinahabone tike. Me one yayai, naboneke, inamatewe wate karo, me tamaha mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Inamatewe Teoso hinofatehiba amaka. Fi fawarihi, kasasa fawarihi, tehibonaka. Teoso Kanamori kitehibonaka he ni ya, foyasa ne ya mati tori ya, watehibanoho. Teoso Kanamori kitehi sawitehibonaka he ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Me ati boti namosawahamehiba amaka, me tamaha mati, Ihayeo mati. Faya Teoso me nofawaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tokehibonaka, Teoso nokosi ya. Fare Eriyamatamona nima nebonaka, kitahari, Teoso Kanamori ehene. Ati me himite ka me makiti matehe me nofawaboneke. Me ihi hiyara me one ati me kamitaboneke waha, me ihi amosa me ati. Mera hawa tonihebonaka, Teoso ka me tohawabone mati\", Teoso nanarifa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria ati yana nematamonaka. \"Keye amarini? Ota kahiwaba ota ama?\" ati nematamonaka. \"Bote ama oke. Oko yibote bote tohinima ke bisa\". ");
INSERT INTO jaa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","\"Kabirieo ama oke\", Teoso nanarifa ati nematamonaka. \"Teoso ya fafama ama oke. Teoso owa yosehi okine oke, tiwa ni ya, tiwa ohiyarahabone owa, hiyara amosa tiwatoabone tiwa. ");
INSERT INTO jaa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Owati timitahi haro. Owati tikasawaria tiwati yana ni watomarahabone tike mata. Manakobisa tikatao wate ya tiwati yana ni watomatasahaba ama tike. Owati amosate ama oke. Yama owatote ama oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Me nahokosaha Sakaria me noki nemetemoneke. \"Himata ebe ne kamakabote rara?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakaria kiyomame mera hiyarebona ati yana ni watorematamonaka. \"Sakaria inamati awehino tohe awaka, teboro baikani ya\", me ati nemetemoneke. Sakaria ati yana ni watore hine ya yama yofi nematamonaka, yehe ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yama wehe one ya Sakaria yama ahi ni hawa tohematamonaka, teboro ya mata. Tokomematamonaka, fare taboro ya mata. ");
INSERT INTO jaa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yama wehe one ya Isabeo nabati weye nemetemoneke. Nabati weye na wawahiya tohehemetemoneke, yobe toro ya. Hinaka abariko siko nematamonaka, wahiyaro, yobe toro ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","\"Teoso ati ehene onabati weye one oke, Teoso owa nofe kari. Owa me haha kanamarahabone oke\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabeo nabati weye ni ka abariko 6 ne ya Kabirieo Teoso hiyose tokehimatamonaka, Maria tabori ya ahi Nasare ya. Karireya ka sitatimetemone amake Nasare. ");
INSERT INTO jaa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yose fatibonemetemone amake, Maria. Yose hitihabone hina ati amosemetemoneke, Kabirieo ati watare ya mata. Yose Tafi ka notimatamona amaka. Maria atonametemone amake, me ahi hiraharo. ");
INSERT INTO jaa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kabirieo tokiyome ati yana nematamonaka. \"Maria afa ama ti? Maria Teoso tiwa nofaka. Teoso sawika tiwa ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria Teoso nanarifa ati mitaha ati boti yama nima nemetemoneke. \"Himata nima ati nara?\" ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","\"Maria watorima tinahi, Teoso tiwa nofehi tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","\"Maria owati timitahi haro. Tinabati weye naba ama tike. Tikatao nehiba ama tike. Ino te nawatebonaka, Sesowi tohehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kitatehibonaka. 'Okatao amaka', Teoso ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ihayeo me ka towisawabona amaka, Teoso ati ehene. Fare Tafi namatamona nima nebonaka. Tafi Ihayeo me ka towisawa tohibehimatamona nima nebonaka. Yako ka noti me ka towisawa tohatehiba amaka. Ihayeo mera kakatomi fawa rihi tehiba amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ati e nemetemoneke ahi: \"Owa me ahi nofara ama oke. Himata nima onaha okatao nehiba ama ori?\" ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","\"Teoso Kanamori kisehibonaka tiwa ni ya. Teoso kiti baforine ya tiwahabone tike. 'Inamatewe Teoso biti tohe awaka. Fare Teoso nima te amaka', me ati naba me amake. ");
INSERT INTO jaa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maria owati timitamata. Ati hine ka Isabeo bote tohaha nabati weye narake. Me ati e nibaha me amake ahi, 'Isabeo kahiwateraba amake', me ati na me amake. Nabati weye ni ka abariko 6 tohaka waha. ");
INSERT INTO jaa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Teoso yama nafi watote amaka, kitahari\", Kabirieo ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","\"Ee fara tiwati nima onahabana oke\", Maria ati nemetemoneke. \"Teoso nanarifa ama oke\", ati nemetemoneke. Faya Teoso nanarifa fawa nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yama wehe one ya Maria yana tona tokomakekabote nemetemoneke, sitati one ya, Yota ka sitati ya, seha ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria kobo towitia tokiyomehemetemoneke, Sakaria ka yobe ya. Faya Isabeo haha nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria ati Isabeo mitaha nabati inamatewe tai hinehemetemoneke. Teoso Kanamori kitehimatamonaka, Isabeo ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Isabeo ati kitehemetemoneke. \"Maria Teoso tiwa nofaka, ha tiwa ta. Me fanawi one Teoso nonofa raba ka. Teoso inamatewe nofa, naka hari, tinawatehibonaha. ");
INSERT INTO jaa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ha owa yama owatora owa ni ya tikine tike, Teoso tiwa yosehino tiwa. Oko Hiti mati ama tike. ");
INSERT INTO jaa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aya tiwati omiti ya inamatewe onabati tai ne amaka, yayai nari. ");
INSERT INTO jaa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Teoso tiwa nofaka, tiwati amosani tiwa, Teoso ati tamine timitani tiwa\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria ati e nemetemoneke ahi: \"Owati boti e ke ahi: 'Teoso amosaka', onaha ");
INSERT INTO jaa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","owati boti yayai nineke, Teoso owa kasome owa. ");
INSERT INTO jaa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ohonaraha otaminahamone me ati naboneke waha Teoso ati ehene. Me ati e naboneke ahi: 'Teoso hinofa hikeni', me ati naboneke. 'Teoso hinofemete amake', me ati tehaboneke, me yanamakeha mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Owa kasomaka, kitahari, e nima rari. ");
INSERT INTO jaa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Teoso ehene e tehi amaka ahi: Teoso ati e nonofa era nofate amaka. Teoso yahi fawa tere amaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E ka one yama me watohamone me ati na Teoso mera katomareka, kitahari. Me kana ni tokarikosaharake, me kitamara mati, Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E ka one towisawa me tohaha towisawa me tohamaraboneke, Teoso ati ehene. Me one yama me watora yama me watoaboneke, Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Me fimiha me tafebone Teoso ta nareka. Me one ta yama me kihaha Teoso ni ya yama me kanika me ka yamabone Teoso ta rareka. ");
INSERT INTO jaa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ihayeo mera kasomareka waha. Ihayeo Teoso nanarifa me amake. Mera kasomareka, hibati ka atimata fawa nire kari. ");
INSERT INTO jaa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hibati ya e ka iti boteri mera hiyarematamonaka. Abarao hiyara, me one hiyara, nematamonaka. Ati e nematamonaka ahi: 'Tera owakatomatehaba ama oke. Te ka noti me owakatoma, otehaba ama oke', Teoso ati nematamonaka\", Maria ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ka abariko terei nematamonaka, Isabeo tabori ya. Manakobisa Maria tokomemetemoneke, fara tabori ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yama totoyabo kawahi ya Isabeo tori kome yana tona biti watehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sakaria wini yabore ka me toha, fara me one toha na, hiyara me mitaha me ati e nemetemoneke ahi: \"Teoso Isabeo nofe awaka\", me ati nemetemoneke. Isabeo yayai, me one yayai, nemetemoneke, me winaha mati, Isabeo wini yabori ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yama wehe 8 ni ya me kakehemetemoneke, Sakaria ka yobe ya, inamatewe sowiri ataro kote me wisi nakosabone mati. Inamatewe inobona me nawatabone me ati nemetemoneke. \"Sakaria tohehibanaka. Fare bati ino ya ino tohehibanaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mati ati hiyaremetemoneke. \"Sakaria toharebanaka. Yowao tohehibanaka\", mati ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","\"Te one me ka owa ino e neba watakara ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Faya bati me aate hinehimatamonaka, ati me himitebonaha. Me ati wataremetemoneke, hine ya yama me yofi nemetemoneke, me yehe ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yama hani rawi kabona ka awa baki ati nematamonaka. Yama hani rawi kane ati e nematamonaka ahi: \"Yowao amaka\", ati nematamonaka. \"Hika\", me ati nemetemoneke, Yowao ino me nofara mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakaria yama hani rawi kane ya ati yana namehimatamonaka tasa, Teoso ati ehene. Ati yana ne Teoso kahiyarehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Me kakomehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hiyara me kaminemetemoneke me one ni ya, me wina mati, sitati yabori ya. Hiyara me mita me ati boti yama kaminemetemoneke. \"Himata nima Sakaria biti ehene neba amara, Teoso ya famahari?\" me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Teoso Kanamori kitehi sawihimatamonaka, Sakaria ni ya. Makoni ati yana nematamonaka, Teoso ati kaminari. ");
INSERT INTO jaa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Ihayeo me ka Teoso amosaka kasiro ya, era kasomari. ");
INSERT INTO jaa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Teoso ati ehene e ka owa kakehinoka, era kasomebonaha, Tafi ka noti. ");
INSERT INTO jaa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Teoso ati kakamina me hikaminehimatamona amaka hibati ya, Teoso ati me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Era me nofara mera mowa nebona ati nematamonaka, era kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E ka iti boteri mera hiyarematamonaka. Ihayeo mera kasomatehibona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","\"Fara owati nima owehene te ama oke. Keye amakere\", Teoso ati nematamonaka, Abarao mera hiyarari, e ka iti boteri mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Teoso era kasomatehibona ati nematamonaka. Teoso era kasome ya yawa e nakomeri ya Teoso e narifawahatehabone Teoso ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","E amosawahatehabone eke, Teoso ni ya. Fare Teoso nima e nawahatehabone Teoso ati nematamonaka, fara yama wehe nima\", Sakaria ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","\"Okatao Teoso ati kakamina tihatehaba ama tike. Tai tihahabone tike Teoso nokosi ya, hawi tinamosahabone tiwa, Teoso hawinebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tiwati me miti ya me ati e naboneke ahi: 'Teoso era kasomaka. Teoso ati somawamaka waha', me ati naboneke, yama hiyara me hiri na mati. ");
INSERT INTO jaa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Teoso yahehibonaka, e ni ya, e kawahi ya, fara Teoso ka yama wehe ya. ");
INSERT INTO jaa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Teoso ka yama wehe kamaki ya yama soki ya me nahoha me nahohaboneke yama wehe ya. Me ahabinima na me kitamawahaboneke. Hawi amosa yofi kanehibonaka, e amosawahibone karo\", Sakaria ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yowao yanawahe yama watohi wiwina tohehimatamonaka yama honara ya, yama noki nari, hiwa namohibonaha Ihayeo me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Me nafi ka towisawamatamona amaka, Sesa Akosto. Mera yosehimatamonaka, me nafi ini me rawi narawabone mati, ");
INSERT INTO jaa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","me me tomi hikanabone mati, me nafi ini watara mati mata, babeo ya. Kirino Siria me ka towisawa tohehimatamonaka, Sesa ati ehene. ");
INSERT INTO jaa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Me tokomarawemetemoneke, fara me ka iti me taborimetemone ya, me ini me rawi nabone mati fahi. ");
INSERT INTO jaa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yose yana tonehimatamonaka, Nasare ya Karireya ka sitati ya. Tokehimatamonaka, Berei ya. Soteya ka sitatimetemone amake, Berei. Tafi taboromatamona amaka, Berei. Yose Tafi hinaka noti tohe ka Yose tokehimatamonaka, Berei ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yose Maria ya famehi me towakemetemoneke, Berei ya. Maria Yose fatibone nabati weye nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Berei ya me kobo tokowitia tori kome yana tonehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Faya biti watehimatamonaka, biti taiti. Rofi hikawe hibehimatamonaka, bowi me tafe wiye ya, yobe me kihari karo, me tamaha me ihi, Berei ya me kakehani mati. ");
INSERT INTO jaa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bere yabori ya me nahohemetemoneke, ofeya me kakatomarawaha mati, kabo ya, masiri boti ya, yama soki ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Faya Teoso nanarifa kakehimatamonaka me ni ya. Teoso ka yama oye firi nisehemetemoneke, fara me naho ka yama ya. Me kakomemetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","\"Te kakomeriyahi. Hiyara amosa te mitahi\", ati nematamonaka. \"Hiyara te ka one me miti ya me yayai naba me amake, me nafi. ");
INSERT INTO jaa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hiyara amake haro: Kirisito watahareka, Tafi taboromatamona ya. Te ka towisawatebona amaka. Tera kasomatehiba amaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te towasiwitiba amaka, forehari, bowi me tafe wiye ya, rofi kawahari makari ibe ya. Bowi me tafe wiye ya forehi te towasiwiti ya 'Efe amaka hari', te ati naba teke\", Teoso nanarifa ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ohari kakibehi manakobisa me tamaha me ya tabawehimatamonaka. Teoso me kahiyaremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Me ati e nemetemoneke ahi: \"'Teoso amosaka', ota ati na otake, neme ya. Teoso amosabisaka te ni ya, bofe ya te winaha te bisa. Teoso tera nofaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Faya Teoso nanarifa me tokomemetemoneke neme ya. Ofeya nanarifa me abe hiyararawemetemoneke. \"Hima e tokomibeya Berei ya. Yama e awibeya, me hikaminaharo, Teoso ati ehene\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Faya me tokomemetemoneke kita ya. Maria me wasihemetemoneke Yose ya famaharo. Inamatewe forehimatamonaka bowi me tatafa ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Inamatewe me awaha Teoso nanarifa me ati me kaminemetemoneke, inamatewe me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ofeya nanarifa me ati me mita \"Hika\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ta yama wati nawahemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ofeya nanarifa me fari tonamemetemoneke, Teoso me kahiyara mati kasiro ya. \"Fare inamati ati nima yama naharake, e awaharo\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yia 8 na ahabi ya inamatewe sowiri ataro kote me wisi nemetemoneke. Ino me hinawatehimatamonaka. Sesowi tohehimatamonaka. Maria nabati weye namatari ya inamatewe inobona Teoso nanarifa hitihi fare ino tohasa nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yama totoyabo raba ni ya me hekematamonaka Serosarei ya, me hinamobonaha Teoso ni ya. Monowi me me tabasi nemetemoneke, me me ta hina mati Teoso ni ya, me amosawahamibone karo Teoso ni ya, inamatewe wati nowati ya. Mowisei ati e te amaka hinaka yama hani karo. ");
INSERT INTO jaa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Teoso Mowisei yosehimatamonaka, yama hani e nabone ati nari ahi: \"Te ka matehe makiti taiti Teoso ka meboneke\". ");
INSERT INTO jaa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Monowi me famaha me me ta nabone me ati nemetemoneke, me me tabasi hinahabone mati, Teoso ka mebone mati, Teoso ka yama hani ati ihi. ");
INSERT INTO jaa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Me ka owa Simiao tohehi winehimatamonaka Serosarei ya. Ehene aamosa tohehimatamonaka. Teoso noki nematamonaka Ihayeo mera kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Teoso Kanamori sawihimatamonaka he ni ya. Teoso Kanamori aate hinibehimatamonaka. Teoso ka Kirisito awatehibona hinehimatamonaka, ahabamatare ya afa yama ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Teoso ati ehene tokiyomehimatamonaka teboro wari ka yama ya. Tokiyome Sesowi bati me hekamakimatamonaka efe yobe ya, Simiao sawi ka yobe. Haha yama Mowisei hikamina me hiri nabone me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiao Sesowi tiwa nematamonaka. Teoso amosemona Simiao ati nematamonaka. Ati e nematamonaka ahi: ");
INSERT INTO jaa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"Teoso yayai oke waha. Tiwati ihi okomabone oke ohababa owa. ");
INSERT INTO jaa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Owahareka, otara kakasomabonaha. ");
INSERT INTO jaa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tiwati ihi me hiwatehiba amaka, me nafi. ");
INSERT INTO jaa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Efe yama oye nima tehiba amaka, tika yama me awibone karo, me nafi, soteo me amara mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Faya bati mati me na Simiao ati me mita \"Hika\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Teoso mera kakatomehibona Simiao ati nematamonaka. Faya Maria hiyarematamonaka. \"Maria hehi inamatewe yanehi nafi ya ati ehene Ihayeo me one amosaba me amake, me tamaha mati. Ihayeo me one ta me ni ya yama hiyara kakehaba amake, ehene. Efe Teoso ati kamine ya me tamaha me hikakotehiba amaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ha tiwa bisa kokoriri tinahaba ama tike kasiro ya. Mera kaminatehiba amaka, me tamaha me ati boti me wati nawaha mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Fana one Teoso ati kakamina tohahani kobo nakehemetemoneke, Ana tohaharo, me ni ya. Ana ate Ase tohehemetemoneke. Bati inomatamona amaka Fanoweo. Ana bote tohehemetemoneke, hinaka ano 84 tohehemetemoneke. Fani ka hinaka ano 7 nemetemoneke, maki ya fami karo. ");
INSERT INTO jaa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Winawemetemoneke ohariaro. Hinaka ano tamehemetemoneke, oharia winaharo. Fara sawi totoha tohehemetemoneke teboro wari ka yama ya, ayakaro, Teoso tahi hiri naro. Hine nafimirima na Teoso haha tohehemetemoneke. Yama wehe ya sawi fara toha, yama soki ya fara sawi toha, nemetemoneke teboro wari ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana kamakia Sesowi awaha ati yana nemetemoneke. \"Teoso faya amake\", ati nemetemoneke, Sesowi ehene. Faya fara Sesowi tamine kamini totoha tohehemetemoneke, fara me one ni ya, Teoso me noki na mati, Serosarei ka mera kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Faya me hawa tohehemetemoneke, yama nafi me hiri na mati, Teoso hikaminaharo hinaka yama hani ya. Faya me kamehemetemoneke Karireya ya, fara me ka sitati ya Nasare ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Faya inamatewe yanawe kitawematamonaka. Yama nafi watohimatamonaka. Amosematamonaka Teoso ehene. ");
INSERT INTO jaa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Fara ano nima Sesowi bati mati me na me tokomaki fara totoha tohehemetemoneke Serosarei ya, Basikowa ka ayaka ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sesowi ka ano tosi na me tokomatasemetemoneke ayaka ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ayaka ahabi ya me kama Sesowi tosawikosematamonaka Serosarei ya. Me hiwatorematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sawihimona me hinehimatamonaka fara me one ni ya. Me yaka kana bahi toke ya Sesowi me siba nemetemoneke fara me one me baikani ya. ");
INSERT INTO jaa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Me hiwasirematamonaka. Me fari tokanamemetemoneke Serosarei ya, Sesowi me siba nabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yama wehe famaha ahabi ya me hiwasimatamonaka, sawihinoho teboro wari ka yama ya. Itarimatamonaka borofeso me baikani ya. Me ati kamitematamonaka, mera aate nari. ");
INSERT INTO jaa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ati me himite \"Yama watoka kasiro ya\", me ati nemetemoneke, me nafi. ");
INSERT INTO jaa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Faya Sesowi bati mati toha na me hiwe \"Hika\", me ati nemetemoneke. Mati ati yana nemetemoneke. \"Okatao himata hiri tine tiri hiyararo ota ni ya? Abi ya ota fama tiwa ota siba nineke, fawa tina tiwa\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","\"Himataba owa te siba rini? Owa te watorani te awine, osawia owa okobi ka yobe ya?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sesowi ati me watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sesowi ya me totabamehemetemoneke Nasare ya. Fara hiri hinahabone me hinaha nima ehene nematamonaka. Mati wati hiwahematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sesowi yanehi yama watohimatamonaka. Teoso hinofematamonaka. Me nafi Sesowi me nofehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yowao winehimatamonaka me winari ka yama ya, Teoso ati wasihari. Homa ka towisawa inomatamona amaka Tiberio Sesa. Tiberio towisawa tohe ka ano 15 na Yowao Teoso ati wasihimatamonaka. Soteya ka kofenato Bosio Birato tohehimatamonaka. Karireya ka towisawa Eroti tohehimatamonaka. Itoreya ya Tarakoniti famaha ka towisawa Firibi tohehimatamonaka, Eroti nisori. Abireni ka towisawa Risanio toha, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anania ya Kaifa me famaha sasetoti ehebote memetemone me amake. Yowao Sakaria biti tohahi Teoso ati wasihimatamonaka, yama honara ya. ");
INSERT INTO jaa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaka nawaharehimatamonaka faha Sotao toha witi ka yama ya, me nafi hiyarari. \"Te ehene hiyara te ehene te nofamarahaba teke. Te batisa, nabone teke, Teoso ati somawamabona karo\", ati nematamonaka, me narabi nima nari. ");
INSERT INTO jaa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yama hani ati e te amake ahi, Teoso ati kakamina Isaiya tohehi ka yama hani karo: \"E ka owa ati yana nebonaka yama honara ya, ati e nari ahi: 'Teoso hawinebona te namosahi. Hawi te yai tonihahi, Teoso hawinebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yama nafi ka wami kokowawa na kamowamaboneke, homi amosabana. Yati nafi nemehamarawaraba amake. Hawi kehoho kawaha yai tokanaba amake waha. Hawi hoti naha isohaba amake. ");
INSERT INTO jaa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Me nafi Teoso mera kasome me me awahaba me amake', ati nareka\", Isaiya ka yama hani ati te amake. ");
INSERT INTO jaa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yowao ni ya me tokomemetemoneke, me hihibofarisabone mati. He ni ya me kamaha me aate hinehemetemoneke. \"Ha te maka biti me te amake, maka komaharo. Hike te narabo nima rano, te kana nawahabone te, Teoso tera kosi rebona te? Teoso te watoha te awineke, mera kosi nebona ati nari, me ihi hiyara mati. ");
INSERT INTO jaa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Te ehene hiyara te nofamaramone te ati na, yama amosa te hiri nawahahi waha. Te ati boti e rabone teke ahi: 'Abarao ka noti me ota amake', te ati rima nahi. Abarao ka noti mebone mera Teoso nofe ya Abarao ka noti mebone mera hiri nebonaka yati ya, so tosaharo ahi. ");
INSERT INTO jaa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Teoso bari tama ni hawa toe awa ka nebonaka hibayata ya, awa boni hiyararo. Ka hini ya koro hiwitiaboneke yifo hiri ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yowao he ya tataba me amara he me aate nemetemoneke. \"Yowao himata ota hiri ribe?\" ");
INSERT INTO jaa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","\"E ka owa makari famaha kihehi owa hora kasarebonaka. E ka owa yamata kihehi yamata kayawarihi, nebonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Me one kamakiemetemoneke he ni ya me hihibofarisa hinahabone mati, yinero yayaba mati, yinero me ta nabone mati Homa ka me ka yinerobonaha. Himata ota hiri ribe? me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","\"Yinero te fiya toniharahabone teke te yabahari. Fare yowabona me hine ka yama ya yowehibonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Saotato me kamakia me aate hinehimatamonaka. \"Himata ota hiri ribe ha ota?\" me ati nemetemoneke. \"Me te keyeharahabone teke, me ihi hiyaramone me kibehabone te ati na te. Me one ka yinero te yabarabone teke, te hamaha te. Te ka yama ahi ni manakone faya tohahaboneke fahi\". ");
INSERT INTO jaa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Me abe hiyaremetemoneke, me nafi. \"Yowao Kirisito tohe awane?\" me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yowao mera hiyarematamonaka, me nafi. \"Ha owa tera oobofarisine oke faha ya hine ya. Owa onowati ya kamakibonaka, kiti mati tohahari. Okita okere, ha owa. Hehi narifi owato okara, owehene amosara owa. Teme borone katisi owato okara ha owa, owehene amosara owa. Tera batisa neba amaka Teoso Kanamori ya. Tera batisa, neba amaka yifo hiri ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tiriko kekero kana tama naka, hinaka tiriko namosebona ati nari. Hinaka tiriko nafi namosebonaka, hobokori nafi ahababonehe. Tiriko namosi ahabe ya tiriko tonihebonaka yobe ya. Hobokori sari hikana hinaboneke yifo ya, yifo owihinateraro\". ");
INSERT INTO jaa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yama tamaha kaminematamonaka me ni ya, mera hiyarari, hiyara amosa kaminari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Efe Eroti hora nematamonaka, yama hiyara hiri nari, anoti fati Erotia tohaha ihawahari. Eroti ka yama hiyara tamaha ihi Yowao hora, hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eroti ati ehene Yowao foyehimatamonaka. Afa yama Eroti hiri hina hiyaremetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Me nafi iibofarisi ya Sesowi ibofarisi sawi nematamonaka. Me iibofarisi nowati ya Sesowi ibofarise Teoso ha ne ya neme hine naha kanemetemoneke. Neme hine naha kanaha ya ");
INSERT INTO jaa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Teoso Kanamori kisehimatamonaka Sesowi ni ya. Kobo nematamonaka okoko nima nari. Neme ya Teoso ati saihimatamonaka. \"Okatao ama tike. Tiwa onofa oke. Tiwehene amosake owa ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sesowi ka ano 30 toha Teoso ati kamini yana tonehimatamonaka. Sesowi Yose bitimona me hinehimatamonaka. Yose batimatamona amaka, Eri. ");
INSERT INTO jaa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eri batimatamona amaka, Mataha. Mataha batimatamona amaka, Refi. Refi batimatamona amaka, Meoki. Meoki batimatamona amaka, Yanai. Yanai batimatamona amaka, Yose. ");
INSERT INTO jaa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yose batimatamona amaka, Matatia. Matatia batimatamona amaka, Amosi. Amosi batimatamona amaka, Naho. Naho batimatamona amaka, Esiri. Esiri batimatamona amaka, Nakai. ");
INSERT INTO jaa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai batimatamona amaka, Mahati. Mahati batimatamona amaka, Matatia. Matatia batimatamona amaka, Semei. Semei batimatamona amaka, Yose. Yose batimatamona amaka, Yota. ");
INSERT INTO jaa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota batimatamona amaka, Yowanaha. Yowanaha batimatamona amaka, Hesa. Hesa batimatamona amaka, Sorobabeo. Sorobabeo batimatamona amaka, Saratieo. Saratieo batimatamona amaka, Neri. ");
INSERT INTO jaa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri batimatamona amaka, Meoki. Meoki batimatamona amaka, Ati. Ati batimatamona amaka, Kosaha. Kosaha batimatamona amaka, Eomataha. Eomataha batimatamona amaka, Eo. ");
INSERT INTO jaa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eo batimatamona amaka, Sesowe. Sesowe batimatamona amaka, Eriesa. Eriesa batimatamona amaka, Sorihi. Sorihi batimatamona amaka, Mataha. Mataha batimatamona amaka, Refi. ");
INSERT INTO jaa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Refi batimatamona amaka, Simiao. Simiao batimatamona amaka, Yota. Yota batimatamona amaka, Yose. Yose batimatamona amaka, Yonaha. Yonaha batimatamona amaka, Eriaki. ");
INSERT INTO jaa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriaki batimatamona amaka, Meria. Meria batimatamona amaka, Mena. Mena batimatamona amaka, Matata. Matata batimatamona amaka, Nataha. Nataha batimatamona amaka, Tafi. ");
INSERT INTO jaa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tafi batimatamona amaka, Sese. Sese batimatamona amaka, Obeti. Obeti batimatamona amaka, Bowasi. Bowasi batimatamona amaka, Sara. Sara batimatamona amaka, Nahasoho. ");
INSERT INTO jaa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasoho batimatamona amaka, Aminatabi. Aminatabi batimatamona amaka, Atimihi. Atimihi batimatamona amaka, Ahini. Ahini batimatamona amaka, Esiroho. Esiroho batimatamona amaka, Faresi. Faresi batimatamona amaka, Yota. ");
INSERT INTO jaa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yota batimatamona amaka, Yako. Yako batimatamona amaka, Isaki. Isaki batimatamona amaka, Abarao. Abarao batimatamona amaka, Terahi. Terahi batimatamona amaka, Nakoho. ");
INSERT INTO jaa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakoho batimatamona amaka, Seroki. Seroki batimatamona amaka, Hakao. Hakao batimatamona amaka, Fareki. Fareki batimatamona amaka, Ebe. Ebe batimatamona amaka, Sara. ");
INSERT INTO jaa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sara batimatamona amaka, Kainaha. Kainaha batimatamona amaka, Ahafakisati. Ahafakisati batimatamona amaka, Sehe. Sehe batimatamona amaka, Nowe. Nowe batimatamona amaka, Rameki. ");
INSERT INTO jaa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rameki batimatamona amaka, Metosarehe. Metosarehe batimatamona amaka, Enoki. Enoki batimatamona amaka, Sareti. Sareti batimatamona amaka, Marerehe. Marerehe batimatamona amaka, Kainaha. ");
INSERT INTO jaa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainaha batimatamona amaka, Enosi. Enosi batimatamona amaka, Seti. Seti batimatamona amaka, Atao. Atao batimatamona amaka, Teoso, Teoso hiri hine kari. ");
INSERT INTO jaa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sesowi ni ya Teoso Kanamori nafihimatamonaka waha. Sotao ya yana tone tokomematamonaka. Teoso Kanamori ati ehene tokehimatamonaka yama honara ya, ");
INSERT INTO jaa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","wehibonaha fahi. Satanaisi fare hiyari hihehimatamonaka yama hiyara hiri nebonaha. Amo ni 40 tohehimatamonaka we karo me winari ka tabora hinita ya, tafarihi, nari. Yama wehe 40 na ahabi ya fimi hiwasimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","\"Teoso biti ama ti? Keye amarini? Teoso biti tihi ya yati tinihawahahi, bao tohahabana\", Satanaisi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sesowi ati yana nematamonaka. \"Teoso ka yama hani ati e te amake ahi: 'Bao kabi e ohari ya e amosatera amake', ati te amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satanaisi Sesowi towakamematamonaka yama nemeha ya. Yama nemeha ya hekame hinamomatamonaka me nafi ka tabora ya. Wami nafi namohimatamonaka Sesowi ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","\"Me nafi ka towisawa tihahabana tike owati ihi. Me yoyose tiha, me ka yama nafi tihawa, tinahabana tike, owati ihi. Keye amakere, oko yama nafi amake. Ta ni onofi ya ta onahaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Owa tinofi ya me nafi ka towisawa tihahabana tike. Owa tinofi ya tika yama haha nahaboneke me ka yama\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","\"Teoso ka yama hani ati e te amake ahi: 'Teoso ohari nokosi ya te foro nabone teke. Teoso narifi te ohari nabone teke', ati te amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Faya hekamematamonaka Serosarei ya. Hekame hinawarehimatamonaka teboro tati nemehe ya. \"Teoso biti ama ti? Keye amarini? Teoso biti tihi ya yora tinisahi bofe ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yama hani ati e te amake ahi, me rawi hinehemete: 'Teoso he nanarifa mera yosehibonaka, tiwa me kakatomahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tiwa me itimisahaboneke, titeme karimarahabone tiwa yati ya', ati te amake\", Satanaisi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","\"Yama hani nake ati e naro ahi: 'Tika Teoso e ka Hiti tohe totomi tirahabone tike', ati te amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sesowi totomi ni fawa ne ya Satanaisi tokomematamonaka mata. ");
INSERT INTO jaa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Teoso Kanamori nafihimatamonaka Sesowi ni ya. Tokomematamonaka Karireya ya. Sesowi tamine me kaminemetemoneke haha me nafi winaha me ni ya, yama yabori ka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mera kanawanematamonaka sinakoka ya. Me abe hiyara amosemona me hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tokomematamonaka Nasare ya, fare yanamatamona ka tabora ya. Fara sabato nima tokomi nematamonaka sinakoka ya. Nasare ya kobo toname ya tokoma, nematamonaka sinakoka ya sabato ya. Warematamonaka, yama hani ati yabebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaiya ka yama hani me ta nemetemoneke he ni ya. Yama hani se kawahe siba hinemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ati hiyaba ati e nemetemoneke ahi: \"Teoso Kanamori ehene ohi ka hiyara amosa okominahabone oke me honara me ni ya. Haha me kibeha me kibemarabone onahabone ati nareka. Ati ehene me noki awatera me ohiyarahabone oke me noki awamibone karo. Haha me one me hinofara me onarifahabone oke, ati ehene. ");
INSERT INTO jaa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Owati e nabone ati nareka ahi: Afa ano ya Teoso amoseba amaka e ni ya\", Sesowi ati nematamonaka, yama hani ati yabahari. ");
INSERT INTO jaa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yama hani boko kawahame yama hani ta tokanamematamonaka tasa. Itaririsematamonaka. Me nafi hekatomematamonaka, ati me himitebonaha. Kakatomi me hinofematamonaka, ati me noki hinahari. ");
INSERT INTO jaa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hiyari yana tonematamonaka hibayata ya. \"Afa yama amake haro, yama hani kaminimete ka yama\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Me nafi hikahiyarematamonaka. \"Hika\", me ati nemetemoneke. \"Ati amosate amaka hari mata ya. Yose biti amare?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","\"Te ati e naba te awineke ahi, ata te hiri na te. 'Metiko ama tirini? Fara tiwa tikasomahi', te ati naba te awineke. 'Kafanao ya fara yama hiri tinaha hiri tinahabone tike ahi, fara titaboro ya tasa', te ati naba te awineke. ");
INSERT INTO jaa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","E ka owa Teoso ati kakamina tohe me one ati hinofatere amaka, fare taboro ka mati. Keye amakere. ");
INSERT INTO jaa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hibati ya faha kaki fawa nemetemoneke. Hinaka ano terei nemetemoneke kote ya. Me nafi fimihemetemoneke, yamata watari karo, kabahabana. Teoso Eria yosehimatamonaka Sito ka me ka fanawi ni ya, sitati Sarebita ya, haha fana maki watamarahari. ");
INSERT INTO jaa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Teoso hiyoserematamonaka fanawi ni ya Ihayeo tohaharo. Me fanawiri tamehemetemoneke Ihayeo me fanawiri, me makiti watamara mati. ");
INSERT INTO jaa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Teoso ati kakamina Ariseo tohe Nama nakitama, nematamonaka, Teoso ati ehene, ataro komene awahari. Nama Siria kamatamonaka. Ihayeo me tamehemetemoneke, me atari kome me awaha mati. Me ta Teoso mera nakitamarematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sesowi ati me mita me nafi hamehemetemoneke, me kibeha mati sinakoka toro ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Me nahorimisa Sesowi me towakamemetemoneke sitati beheri ya, atami beheri ya, me koro hinisehibonaha bofe ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Me koro hinisebona me hine fari namehimatamonaka me baikani ya. Tokomematamonaka, mera fiya tonamari. ");
INSERT INTO jaa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tokomematamonaka Kafanao ya, Karireya ka sitati ya. Sabato one ya mera kanawanematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","\"Hika\", me ati nemetemoneke, Sesowi ati me mita mati, me one ati nima ati re karo. Me one ati me kamina Sesowi ta ati kaminematamonaka, fare. ");
INSERT INTO jaa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Me ka owa sinakoka toro ya itari kiya kanematamonaka inamati ehene. ");
INSERT INTO jaa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"Hika, Sesowi Nasare ka tihaha himataba otara ahi tine tiri? Otara tinahabihaba tiwa awine ti? Tiwa owato oke. Teoso tiwa yosehino ama tike, me tikasomahabone tiwa. Efemata ama tike, Teoso hikaminehimata hibati ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sesowi ati ehene ati fawa nematamonaka. \"Tiwati watarima nahi. Sa tisaho\", ati nematamonaka. Hinamati sa hise sonehimatamonaka bofe ya, me baikani ya. Hihiya niba watarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Me nafi ati boti yama kaminemetemoneke, me abe hiyara mati. \"Himata amari? Ati kite awane. Makoni me inamati tokomineni, ati ehene\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Faya tamine me hikamina hiwaharehimatamonaka haha tabora nafi ya. ");
INSERT INTO jaa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sesowi tasi tonematamonaka sinakoka ya. Tokomematamonaka Simao ka yobe ya. Simao fati mati yama kome awaha ihi Sesowi me aate nemetemoneke, he kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sesowi tokomakematamonaka afa ni ya. Yama kome Sesowi e nihimatamonaka. Yama kome fawa nemetemoneke, ati ehene. Hibati ya yana namisamemetemoneke, mera narifabanihi. ");
INSERT INTO jaa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bahi tokarise ya me me kakirawemetemoneke, yama kome me awaha mati, me nafi, Sesowi ni ya, yama kome yoro tokana me kihaha mati. Sesowi mera bobori kanematamonaka, yehe ya. Me kitamemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Me inamati me one me me sasa tosemetemoneke. Mera sa tosa ati yana nemetemoneke. \"Teoso biti ama tike\", me inamati ati nemetemoneke, me kikiya kana mati. Me ati fawa nimatamonaka, me hikaminarebonaha, me hiwatohari, Kirisito tohahari, Teoso ka towisawa. ");
INSERT INTO jaa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yama hiba wa ni ya tokehimatamonaka yama honara ya. Me one siba hine me hinakamakimatamonaka, tokomi me hinofarahari. ");
INSERT INTO jaa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","\"Hiyara amosa okominahabone onahara oke, Teoso ka towisawa tamine, sitati one ka me ni ya. Hiyara okominabone oke Teoso ati ehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mera hiyarematamonaka Soteya ka tabora tamaha ka sinakoka ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yama wehe one ya Sesowi yaka nematamonaka rako Senisare beheri ya. He beheri ya me ihabasa Teoso ati me kamitemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanawa howe famaha yoro na awehimatamonaka faha witi ya. Faha kiki me yoro hinamanihi tahafa me soko nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sesowi tofoyawitimatamonaka kanawa tori ya, Simao ka kanawa ya. Simao aate nematamonaka, kanawa yoyoko tonamaraba nebonaha, Sesowi kawitabona karo. Sesowi mera kanawanematamonaka, me nahobasa mati faha witi ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mera kanawani hawa tohe ya Simao yosehimatamonaka, kanawa towakamehibonaha faha kokowi nama na ya. \"Tahafa te koro nifehi, aba me te nawasibeya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","\"Sesowi faha ota ki naba aba me ota nawasira otake. Tiwati ihi tahafa ota koro nifekibone\", Simao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tahafa me koro nifemetemoneke. Tahafa tokisa aba mera nawasiemetemoneke. Aba me tamaha me me horo kamisemetemoneke, tahafa kihi. Tahafa bete kasinima nemetemoneke, aba me tamaha me ihi. ");
INSERT INTO jaa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Me one me ha nemetemoneke, kanawa one ka me kawita mati, me me hikasomahabone mati. Me kakamake kanawa fami mo kanikimehemetemoneke aba me ihi. Kanawa bokinima nemetemoneke aba me kanahari ihi. ");
INSERT INTO jaa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aba me tamaha Betiro mera awehi sonarisehimatamonaka Sesowi nokosi ya. \"Ota ka Hiti totowanama tinahi. Owehene hiyatera ama oke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Betiro yama wati nawahematamonaka, aba me tamaha mera awahari, me me hinawasiha mati. ");
INSERT INTO jaa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Me one yama wati nawaha nemetemoneke. Tiako Sebeteo biti memetemoneke Yowao ya me famaha mati, Simao ya tataba mati. Sesowi ati yana nematamonaka. \"Simao tiwatorahabone tike. Hibayata ya te one me ki tiwahabone tike waha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanawa me towakamehemetemoneke faha witi ya. Me one me kakosehemetemoneke. Yama nafi me kakosa, nemetemoneke. Sesowi ya me tabehemetemoneke waha. ");
INSERT INTO jaa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yama we one ya tabora one ya me ka owa mese hiyare Sesowi awehimatamonaka. Sonarisehimatamonaka Sesowi nokosi ya. Sesowi aate nematamonaka. \"Ota ka Hiti owa kasomi tiwatoa tiwa awine tike. Owa kasomi tinofini?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sesowi bori hikanematamonaka yehe ya. \"Tiwa kasomi onofa oke. Tikitamahabone tike hibati ya\", ati nematamonaka. Yama kome fawa kabote nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sesowi narabo nima hinehimatamonaka, kasomi tamine kaminarehibonaha me one ni ya. \"Tikamahi sasetoti me ni ya, tiwa tinamobeya sasetoti me ni ya. Mowisei ati e nematamonaka ahi: E ataro amosamaha bani e ta te e amake Teoso ni ya, tabasi nebonaha. Mowisei ati namatama tiwehene nahi, tiwa me watobone karo, titaminawaha tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Me nafi Sesowi tamine mitehemetemoneke waha. Me tamaha me kamakiemetemoneke he ati me mitahabone mati. Me one sawi narawemetemoneke Sesowi me hikasomahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sesowi tokawehimatamonaka yama honara ya, Teoso ha nebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yama we one ya Sesowi mera kanawane fariseo me toha, Mowisei ati kakamina me toha, na me nahoriemetemoneke ayata ya. Karireya ka tabora nafi ka me toha, Soteya ka tabora nafi ka me toha, Serosarei ka me toha, nemetemoneke, me kakeha mati. Teoso kiti sawihimatamonaka Sesowi ni ya, makoni mera nakitamehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Me ka owa me kakiemetemoneke forehari, me tiwa hikanari, yana ni watorari. Me hekiyomakehibona me hinehimatamonaka, forehibonaha Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Me hekiyomakerematamonaka, me tamaha me ihi. Me hekimisehimatamonaka yobe bari ka ya. Hoti me wi nemetemoneke yobe bari ka ya. Me hikanakisematamonaka me baikani ya Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Me ati boti Sesowi hiwatoemetemoneke, \"Teoso kitate amaka\", me ati boti ati na mati. Ati yana nematamonaka. \"Habai Teoso tiwehene hiyara fawa nika\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fariseo Mowisei ati kakamina me ya me tabaha me ati boti yama nima nemetemoneke, Sesowi ati me nofara mati. \"Yama hiyara kaminareka, Teosomona ati nari. Yama hiyara e hiri teha Teoso fawa nite amaka, fare Teoso ati ehene. E ati ehene amakere\", me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yama me wati nawaha Sesowi me hiwatoemetemoneke. \"Himataba yama e na te wati nawahineri te ati boti ya? ");
INSERT INTO jaa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Owati e nara oke ahi: 'Tiwehene hiyara Teoso fawa nika', onahara oke. 'Yana tinahi, yaka tibeya', onehene ama oke. Fara owati famineke. ");
INSERT INTO jaa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Owa te watowahaba te amake waha, me ihi hiyara me ihi fawa ni owatoa owa ahi, bofe ya, Teoso ati ehene\". Faya me ka owa forehi hiyarematamonaka. \"Owati timitahi. Yana timisamahi. Tika fofore titihi. Tikamahi titaboro ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yana kabote nematamonaka me nokosi ya. Fofore itikabote ne tokomematamonaka, Teoso ehene kahiyarahari. ");
INSERT INTO jaa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","\"Hika\", me nafi ati nemetemoneke. Teoso me kahiyarehemetemoneke. \"Yama e na e awatera e amake ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sesowi tokomematamonaka. Me ka owa awehimatamonaka itariari kofeno ka yinero taboro ya. Yinero yayaba tohehimatamonaka, kofeno ka yinerobonaha. Inomatamona amaka Refi. \"Tisawihi owa ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sesowi ati mite hinaka yama nofamarehimatamonaka. Yana ne Sesowi ya famehimatamona amaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Refi marina nafiha hiri nematamonaka hinaka yobe ya, Sesowi mera mari nari. Me tamaha me tafehemetemoneke, yinero yayaba me ya me one tabaha mati. ");
INSERT INTO jaa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseo Mowisei ati kakamina me ya me taba Sesowi ya tataba me me hora nemetemoneke. \"Himataba me ya te tabaha te tafineri, me yoro tokana mati, yinero yayaba me ya yama hiyara hihiri me tabaha mati?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sesowi ati yana nematamonaka. \"Yama kome e awara metiko era narifatere amaka, e taminaro. Me kiya na me ta metiko mera narifate amaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me ihi amosa me ha orahabone okehara oke. Okehara oke, me ihi hiyara me ta me ha onahabone owa, yama hiyara me hiri namaribone karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sesowi me aate nemetemoneke. \"Sesowi himataba tiwa ya tataba me tafi fara tohi nofa me amari? Yowao ya tataba me nima me kere. Yama we one ya Yowao ya tataba hine me nafimi nofa me amake, Teoso me ha nabone mati. Fariseo me ya tataba me ihi e, te amake ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sesowi ati e nematamonaka ahi: \"E ka owa fanehibona ya tataba hine me nafimiabone e ati rabone eke, me ni ya sawi kari hinaka ayaka ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yama we one ya me one hitimakehibonaka. Faya he ya tataba hine me nafimiaboneke fahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sesowi mera kanawanehimatamonaka tasa. \"Makari yati e sibi naretera amake, ibe e nawanamiba karo makari bote ya. Makari yati hiyaraba amake. Makari yati ibe amosaraba amake wanaharo makari bote ya. ");
INSERT INTO jaa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Fi yati e tonihatera amake yama atari bote yama wiye tohaha ya. Fi yati nafimisaha ihi yama wiye bosi tokanaba amake, kitaharo, bote tohaharo. Yama atari sibi toni ya fi ahababa amake. Yama atari ahaba, naba amake. ");
INSERT INTO jaa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Fi yati e tonihate amake yama wiye yati ya. Fi nafimisi ya ahabarahaba amake, yama wiye kitari karo, yati tohaharo. ");
INSERT INTO jaa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Fi bote e fawi ya fi yati fawi e nofatera amake. E ati e te amake ahi: 'Fi bote amosake', e ati te amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabato one ya Sesowi kariwematamonaka fatara ya. He ya tataba tiriko boni me bata nemetemoneke. Me kikiyo hikawa noki me hikabemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseo me one ati yana nemetemoneke. \"Himataba te ehene e nineri ahi? Sabato ya yama e na e hiri tera amake ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sesowi ati e nematamonaka ahi: \"Yama hani te awaterani te ama, Tafi tamine kaminaro? Tafi he ya tataba me ya tabehi me fimiha ");
INSERT INTO jaa_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tafi tokiyomehimatamonaka Teoso ka yobe ya. Bao yabehimatamonaka, Teoso ka bao. Hahi bao e kabatere kabehimatamonaka, sasetoti me ta me hikabatehari. He ya tataba me hikaba hinehimatamonaka, ta hinahari me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Neme ka Owa sabato Hiti tohate amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabato one ya Sesowi tokiyomematamonaka sinakoka ya, mera kanawanehibonaha. Me ka owa sawihimatamonaka, mano kamo namahari, hinaka kanihina. ");
INSERT INTO jaa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mowisei ati kakamina fariseo me ya me taba me hekatomematamonaka, ehene me hiwehibonaha. Me ka owa nakitame ya ehene me hikaminebona me hinehimatamonaka me one ni ya, sabato ya yama ahi nemona me hinahari, ehene hiyaremona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sesowi me ati boti watohimatamonaka hibati ya. Me ka owa ha nematamonaka, mano kamo namahari. \"Yana tinahi, tiwaribeya ahi me nafi nokosi ya\", ati nematamonaka. Yana ne warehimatamonaka fahi. ");
INSERT INTO jaa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sesowi mera aate nematamonaka. \"Te ati omitabone oke. Sabato ya e abe kasomaterani ama? Sabato ya e abe kakotehani ama? Sabato ya e abe nakitamaterani ama? E abe nabowatehani ama?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Me nafi noki awehimatamonaka, me nahoria mati. \"Timano yai tinihahi\", ati nematamonaka. Mano yai tonihe ya amosawahamematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Me hamawemetemoneke waha. Me abe hiyaremetemoneke. \"Himata nima e ribe Sesowi ni ya?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yama we one ya Sesowi tokomisehimatamonaka Teoso ha nebonaha yati waha mese ya. Teoso ha nematamonaka yama soki oharia ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yama warisi ya mera ha nematamonaka, he ya me tabaha mati. Me 12 na mera ha nematamonaka, me hiyosehabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simao ha nematamonaka, ino hinawatahari, Betiro tohahari. Atere toha, Simao nisori. Tiako, Yowao, Firibi, Batoromeo, ");
INSERT INTO jaa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tome, Tiako Afeo biti, Simao, Homa ka mera momonotemona me hitehari. ");
INSERT INTO jaa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yota Tiako biti, Yota Isikarioti toha, Sesowi ta tehibana. ");
INSERT INTO jaa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mera kakisamematamonaka yama homi amosa ya. Me tamaha me ya tabehimatamonaka, he ati me mitahabone mati. Me one nakitamebona me ati, nemetemoneke. He nonofa me tama, Soteya nafi ka me tama, Serosarei ka me toha, ma beheri ka me toha, nemetemoneke, Tiro ya Sito fama ka mati. ");
INSERT INTO jaa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","19","Me kamakia Sesowi me boyo na Teoso kiti ehene me kitamemetemoneke. Me tamaha Sesowi me boyo narawemetemoneke. Inamati me ihi me rabikateha mera kasoma, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sesowi ya tataba mera awehimatamonaka. Mera hiyarematamonaka. \"Teoso tera nofaka, te honara te. Te winaba te amake Teoso taboro ya\". ");
INSERT INTO jaa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","\"Teoso tera nofaka, te fimiha te. Te tefebone ta nebonaka\". \"Teoso tera nofaka, te ohi na te. Te haha naba te amake, te yayai na te\". ");
INSERT INTO jaa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","\"Teoso tera nofaka, tera me kakoa te. Te ya tabi me nofaraba me amake, Neme ka Owa te nofi karo. Te hiyaramone me ati naba me amake, te ino me nofamaraha mati. ");
INSERT INTO jaa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Te ni ya me ihi e na te yayai nabone teke. Te yora kanahabone teke te yayai ni karo. Teoso tera kakawebonaka yama amosa tamaha ya neme ya. Fara me ka iti me ihi nimetema me te me amake. Me ka iti Teoso ati kakamina me me nofaremetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","\"Ha te ta yama tamaha te kihaha te ni ya yama hiyara kakehaba amake. Yama amosa te kihake hibati ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Te nabati fotaha Teoso tera nofakara. Te fimihaba te amake. Te haha na Teoso tera nofareba amaka. Te ohi naba te amake, te yawaha te. ");
INSERT INTO jaa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Teoso tera nofamareba amaka, me one tera nofaha te. Hibati ka Teoso ati kakamina memone me me nofehemetemoneke, keye me hiri na mati, Teoso ati amare me kamina mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"Owati e nara oke ahi, te kamitaro. Tera me nofara me te nofahaba teke. Tera me kakoa te ehene amosabone teke me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tera me hifo kani ya me te ha kanahabone teke, Teoso mera nofabona karo. Tera me kako ya me te ha kanahaba te amake Teoso ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tinoko baki me tao hiki ya one behe tiwahamahi, me tao hikanabana tasa. Tika makari mese ka me sota ni ya tika makari boti ka tikayawarabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te ka yama me nofi ya te ta naboneke me ni ya. Te ka yama me boti ya te ati watarabone teke, yama me ta namahabone te ati na te. ");
INSERT INTO jaa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Haha yama me hiri hinahabone te ati na te ni ya afa yama te hiri nabone teke me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","\"Tera nonofa me nofi te oharia te ehene amosarahaboneke Teoso ni ya. Me hiyara me ihi e te me amake bisa, mera nonofa me me nofaha mati. ");
INSERT INTO jaa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tera me kasoma me kasomi te oharia te ehene amosarahaboneke Teoso ni ya. Me hiyara me ihi e te me amake bisa. ");
INSERT INTO jaa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yama hine ya te ta na me ta hiwamabone te ati na te ehene amosarahaboneke Teoso ni ya. Me hiyara me abe kakawate me amake, yama me ta nawahamaba mati me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tera me kakoa me te nofahaba teke. Te ka yama te kayawaraba teke, tera me aate ni ya. Te ati e rabone teke ahi: 'Yama me ta nawahamaraba me amake', te ati rabone teke. Yama te ta ni ya Teoso tera nofehiba amaka, Teoso ehene nima te ehene ni karo. Me hiyara Teoso mera nofaka, yama me ta nawahamara mati\". ");
INSERT INTO jaa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","\"Te yahahabone teke fare e ka abi ehene nima. ");
INSERT INTO jaa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Me te kakorabone teke. Me te kako ya Teoso tera kakobisebonaka. Te ni ya yama hiyara me hiri ni ya me ni ya te ati somawamabone teke, Teoso ati somawamabona karo te ni ya bisa, te ka yama hiyara nafi wati nawahamarari. ");
INSERT INTO jaa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Me ni ya yama nafi te ta ni ya yama nafi Teoso ta neba amaka te ni ya. Te ka yama wiye mo naba amake yamata ihi. Yamata mo kanaha yoko tinisabone tike, tokisabonehe. Yama wiye kisa tikani ya foro naba amake mo kani karo. Fara te ehene nima Teoso ehene nebonaka te ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sesowi hiyara kaminematamonaka me ni ya. \"E ka owa noko awatere owa towakameba ama hawi ya, noko awarari? Me fami kasohaba me amake hoti ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Borofeso nanarifa he nima neba amaka, borofeso ka yama wato nima, borofeso ati kamiti nafi ya. Borofeso nanarifa he fiya karehiba amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","\"Tika owa noko ebene biti foyehi tiwini? Tinoko tiwahi. Awa ibe foyake tinoko ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tiwati e narake ahi tika owa ni ya: 'Habai tinoko abe bite foyaha soba onamibeya', tinahara tike. Awa ibe foyaha tiwa tikere tinoko ya. Tiwati boti hiyarara tike. Tinoko ka awa ibe foyaha soba towiti tai tohahaboneke. Tinoko ka awa ibe foyaha soba tiwiti ya tinoko awi amosabone tike, tika owa noko ebene soba tiwitibone karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","\"Awa amosa boni hiyaraba watatera amake. Awa hiyara boni amosaba watarihi te amake. ");
INSERT INTO jaa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Awa boni e awi ka e watote amake. Fiko boni watatera amake atiwa ete ya. Ofa boni watarihi te amake atiwa ete ya. ");
INSERT INTO jaa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","E amosa yama amosa kaminate amake, e ati boti amosaro. E hiyara yama hiyara kaminate amake, e ati boti hiyari karo. E ati boti hiyari nafi ya e ati hiyatera amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"Himataba 'Ota ka Hiti' te ati nofa te amari, owati te nofara te? ");
INSERT INTO jaa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Owa ni ya tikami ya owati tikamiti ya yama okomina hiri tini ya ");
INSERT INTO jaa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","e tinahabone tike, e ka owa nima, yobe amose hiri nari. Hoti wi ne yobe ewene si tonihematamonaka yati mese ya, wami boti karo. Faha kakeha ihi fa fowe kimisa ihi yobe waifimatamonaka fa boti ya. Yobe sonarematamonaka kite karo\". ");
INSERT INTO jaa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","\"Owati timiti ya yama okomina hiri tiri ya e tinahabone tike e ka owa nima, yobe hiyare hiri nari. Yobe hiri nematamonaka bofe ya ewene watarari. Faha kakeha ihi fa fowe kimisa ihi yobe waifi ahabematamonaka nafi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sesowi hiyare hiyari me himite ya hiyari ahabe ya tokomematamonaka Kafanao ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Homa ka saotato me ka towisawa owa Sesowi tamine mite ati ehene soteo me ka hiti me tokomakemetemoneke Sesowi ni ya, towisawa ka yama aahi rabike tamine me kaminabone mati Sesowi ni ya. Ahabinima nemona me ati nemetemoneke. Towisawa ka yama aahi nofehimatamonaka kasiro ya. Sesowi tokomakebona me ati nemetemoneke, towisawa ka yama aahi kasomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Me kamakia Sesowi hiyari me noko tonihemetemoneke. \"Towisawa ati nima tinahi, me ati nemetemoneke. Hibati ya amosate amaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","E nafi nofate amaka. Ota ka sinakokabona hiri nemari amaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sesowi me ya totabamematamonaka. Yobe wari yabore ya towisawa ya tataba me one me me kobo nemetemoneke, towisawa ati ehene. Towisawa ati me kaminemetemoneke. \"Sesowi tikerabone tike oko yobe ya, titaminaha tiwa. Otamina okere ha owa. ");
INSERT INTO jaa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Otaminari ka okomakerara oke tiwa ni ya. Hine ya tiwati yana ni ya owa nanarifa kitamebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tiwa nima one oke, me one oyoseha owa. Saotato me oyosete ama oke. 'Tikamakehi', oni ya saotato tokomakehibonaka. 'Tikamahi', owa ni ya oni ya kamehibonaka. Oko yama aahi me oyose ote ama oke. 'Yama e na hiri tinahi', oni ya oko yama aahi hiri hinahaboneke\", me ati nemetemoneke towisawa ati me kamina mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sesowi atimona himite \"Hika\", ati nematamonaka. Tonokowamematamonaka fara me one ni ya, mera hiyarebonaha. \"Hahi bare nima me naba me watakere, Ihayeo mati, Teoso kitehimona ati nari. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Towisawa ya tataba me wete tonama me kobo tonami ya towisawa ka yama aahi me awehemetemoneke kitamari. ");
INSERT INTO jaa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sesowi tokomematamonaka sitati one ya Nai tohaharo. He ya tataba me toha me one toha, nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sitati ka nokobi wani yabori ya me kakehemetemoneke, me ka owa me tiwa kana mati, ahabari. Mati toha nemetemoneke, fare biti oharimata, maki ahabemata. Me tamaha me ya me tabehemetemoneke, sitati ka mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sesowi hiwi ya yawehimatamonaka. \"Ohi rima tinahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tokomake awa wara tonehimatamonaka, me tiwa hikane ewene. Me ma tonehemetemoneke, yetene abowi me tiwa kana mati. \"Yetene tiwamisamahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Abowi itarimise hiyari yana nematamonaka. Sesowi ta hinamematamonaka fare mati ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Me nafi kakomehemetemoneke. Teoso me kahiyaremetemoneke. \"Teoso ati kakamina e ni ya kakehareka yama watohari\", me ati nemetemoneke. \"Teoso era kasomaka\", me one ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sesowi ehene tamine me kaminemetemoneke Soteya ka me nafi ni ya. Soteya beheri ka me winaha Sesowi ehene tamine me mita nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yowao ya tataba Sesowi tamine me kaminemetemoneke Yowao ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yowao me famaha mera ha nematamonaka, me kakamabone mati he ni ya, me hiyosehabone mati Sesowi ni ya, Sesowi me aate nabone mati. \"Te ati e nabone teke ahi: 'Efemata ama ti, kaketehibona me hinehimata? Owa ta ota noki nabana?'\". ");
INSERT INTO jaa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Me towakamakiemetemoneke Sesowi ni ya. \"Sesowi Yowao Batisita otara yose otake tiwa ota aate nabone ota. Ati e nareka ahi: 'Efemata ama ti, kaketehibona me hinehimata? Owa ta ota noki nabana?'\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Afa yama ya Sesowi mera kasomematamonaka, me tamaha mati. Yama kome me awaha me toha, me rabika me toha, me noki awara me toha, nemetemoneke, me hikasomaha mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yowao ya tataba Sesowi mera hiyarematamonaka. \"Te wete tokanamahi Yowao ni ya. Yama te mitaha te kaminibeya he ni ya. Yama te awa te kamina, nabone teke he ni ya. Me noki awatera me noki awake waha. Me yaka ni watotera me yaka nawahineke waha. Me mese hiyatera me mese amosawahineke waha. Me warabi hawitera me warabi hawiwake waha. Me ahaba me kitama, narake waha. Me honara me ni ya hiyara amosa okominine oke. ");
INSERT INTO jaa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Owehene me awi ya owehene me nofi ya Teoso me hekatomaboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Faya me towakami ya Yowao ni ya, Sesowi me one hiyarematamonaka, me moto kawahamaha mati, Yowao tamine kaminari. \"Himataba te tokomake te awineri yama honara ya? Yama isi afe te awahabone te ati na te awine, feo kanaharo boni ihi? ");
INSERT INTO jaa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Himata yama te awahabone te ati rini? E ka owa te awahabone te ati ninihi, makari amosa akahari? Makari amosa me weye na me watakere ahi yama honara ya. Me winate me amake, towisawa me tabori ya, yama tamaha me kiha mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Himata te awahabone te ati rini? Teoso ati kakamina owa te awahabone te ati ninihi? Ee, Teoso ati kakamina amaka. Yowao ehene ta amosi mati tohaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Efe amaka hibati ka me hikaminehimata, yama hani ya, me ka yama hani ati e na mati ahi: 'Owati kaminebona tinokosi ya tai tohehibonaka, oyose kari. Tika hawibone namosebonaka tinokosi ya', yama hani ati ke. ");
INSERT INTO jaa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yowao amosi mati tohaka. E fanawiri ni ya me wataha me one ihi aamosa raba te me amake. Teoso ka towisawa ya me tabaha me ta me amosate me amake mata ya, me nafi. Yowao aamosa raba te amaka. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sesowi ati me mitaha Teoso yama hinofa amosamone me ati nemetemoneke, Yowao me hihibofarisa mati, me nafi, yinero yayaba me toha na mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mowisei ati kakamina me toha, fariseo me toha, na Teoso yama hinofa hiri ni me nofaremetemoneke, Yowao me hihibofarisara mati. ");
INSERT INTO jaa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","\"Himata nima me naba me amari hibayata ka mati? Hibake me nima me naba me amari? ");
INSERT INTO jaa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Matehe nima me nineke me nahoria mati mekato ya, me abe ha na mati, me ati e na mati ahi: 'Hohori ota hori na te sere kara teke. E abe kamoha tahi ota hiri na te ohi rihi na teke', matehe ati te amake. ");
INSERT INTO jaa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yowao Batisita kakehita amaka, bao kabarari, fi fawa rihi nari. 'Rabike awaka', te ati na teke. ");
INSERT INTO jaa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Neme ka Owa kakehimari amaka, yamata nafi kabahari, fi fawa nari. 'Te awa hari, tafi nafihari, fi fawi nafi nari mata ya', te ati na te awineke. 'Yinero yayaba me ya tabaka, mera nofahari. Yama hiyara hihiri me ya taba, ka', te ati na te awineke. ");
INSERT INTO jaa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yowao ya ota famaha ota ehene amosamone me ati naba me amake. Teoso otara watoka, ota ehene amosa ota\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo me ka owa Sesowi ha nematamonaka, me ya tafi tabehibonaha. Tokiyomehimatamonaka fariseo ka yobe toro ya. Forehimatamonaka mesa beheri ya tafehibonaha. ");
INSERT INTO jaa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haha sitati ka fana yama hiyara hiri teha Sesowi tamine mitaha kakehemetemoneke he ni ya, esitarato tama kanaharo yama wiye yati yama ni tohaha ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","He nowati ya waremakehemetemoneke ohi naro. He teme soko nemetemoneke noki fehe ya. He teme namosemetemoneke tati kone ya. He teme komi nemetemoneke. He teme soko nemetemoneke esitarato ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fana ihi fariseo awehi ati boti e nematamonaka ahi: \"Teoso ati kakamina tohehimanaha fana ihi watohina amaka. Fana ihi watohina amaka, ihi hiyateraro\", ati boti ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sesowi ati yana nematamonaka. \"Simao tiwa ohiyarabone oke\", ati nematamonaka. \"Ee, owa tihiyarahi\", Simao ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","\"Me famaha me ka owa me tefe nemetemoneke. Owa 500 moweta tohe tefe, owa 50 moweta tohe tefe, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yinero me kiharemetemoneke, me ka kota me nahabihaba mati. 'Hine tohawake', ati nematamonaka. Hike hinofeba amara mata ya?\" Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","\"Hahi yama tefe ni nafihi ta hinofeba amaka, mata ya\", Simao ati nematamonaka. \"Tiwati amosake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sesowi ki towahamematamonaka fana ni ya. Simao hiyarematamonaka. \"Simao fana tiwini haro? Tika yobe ya okiyomaha faha tekamarara tike oteme soko tiba karo. Oteme afi toniharake noki fehe ya. Oteme nahokowaharake tati kone ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Owa komi tinakirara tike. Okiyomaha oteme komi ni yana tona oteme komi ni fawa rarake haro. ");
INSERT INTO jaa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Otati kone kiyo tiwaharara tike orifa fehe ya. Oteme soko nawaharake esitarato ya. ");
INSERT INTO jaa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Owati timitahi. Yama hiyara hiri hiteha tamake. Yama hiyara hiri hiteha Teoso fawa hiniha owa nofake waha kasiro ya. Me one ka yama hiyara yokana tohara Teoso me nonofa raba te me amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Fana hiyarematamonaka. \"Tika yama hiyara Teoso fawa nika waha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Me one mesa ya me nahoria me ati boti e nemetemoneke ahi: \"Hike teno amara hari, me ka yama hiyara fawa nihari?\" me ati boti ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sesowi fana hiyarematamonaka. \"Tikamahi. Teoso ati tinofi ka tiwa kasomareka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sesowi yaka nematamonaka sitati nafi ya, tabora nafi ya. Hiyara amosa kaminematamonaka me ni ya, Teoso ka towisawa tamine, he ya tataba me 12 na me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Me fanawi toha nemetemoneke he ni ya, mera kasomari, me inamati ihi me one rabika mati, me one kiya, na mati. Maria toha, nemetemoneke hinaka inamati me tokoma inamati mera kihamaraharo, me inamati 7 na mati. Ini onemetemone amake Matarena. ");
INSERT INTO jaa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yowana toha, nemetemoneke, Kosa fati, Eroti nanarifa. Sosana toha, nemetemoneke. One toharawa, nemetemoneke tamarawaharo, yinero ta narawaro, yamata manakonebonehe, Sesowi me tafe manakonebonehe, he ya tataba me ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Me tamehemetemoneke me yoro tokana me kakerawaha mati tabora nafi ka mati Sesowi ni ya. Faya hiyara kaminematamonaka. Mera kanawanehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"E ka owa tokehimatamonaka yama noki koro nebonaha. Yama noki were kane noki one kasohemetemoneke hawi beheri ya. Me tai hinaha bani biti me kakeha me hikabemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Noki one kasohemetemoneke wami yati kihaha mese ya. Yanaha waya tokanemetemoneke bai hiwene ehene. ");
INSERT INTO jaa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Noki one kasohemetemoneke atiwa baikani ya. Atiwa yanehi ehene noki yani watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wami amosa ya noki one kasoha yanaha bonohemetemoneke. Noki oharia koro na boni 100 tohehemetemoneke, hiyabamatehabana. Te narabo naha owati te mitahi\", Sesowi ha ni ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","He ya tataba ati me hiwatorehimatamonaka, yama hikaminaharo. Makoni me hihiyarehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","\"Teoso ka towisawa ka yama wato yokana te tohahabone Teoso ati nareka, ha te ta, tera okanawani ya. Me one kanawani forima orahabone oke. Hine ya hiyara okominahabone oke me one ni ya. Owa me awa, owati me mita, na owati me watoraba me amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"Haha hiyara te watohi. Haha yama noki tamine nima Teoso ati tehi amaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Haha yama noki hawi beheri ya kasoha e ka one me nima nemetemoneke, Teoso tamine me mitaha mati, me boti ka Teoso ati Satanaisi hitimakeha mati. Afa mera Teoso kasomaterebonaka, he ati me nofara mati. ");
INSERT INTO jaa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Haha yama noki wami yati kihaha mese ya kasoha hine ya me yayai na me nima nemetemoneke, Teoso ati me mitaha mati, Teoso ati me tokatabaha mati, me yayai na mati, yama totoyabo kawahi ya Teoso ati me nofamarawara mati, yama habi watara nima me na mati. Inamati me totomi hinaha me Teoso ati me nofamatera me amake. ");
INSERT INTO jaa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Haha yama noki atiwa baikani ya kasoha nima me naboneke, Teoso ati me nofaha yama tamaha me nofa na mati. Afa yama yani yokana tohara boni hati watara nima me te me amake. ");
INSERT INTO jaa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Haha yama wami amosa ya kasoha Teoso ati me mitaha Teoso ati me tokatabaha me nima nemetemoneke, me ihi amosi mati tohaha mati mata ya, fare Teoso ati nima me ihi na mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"Nabarina e sari kanaha nabarina hiri ni e yoko tokatehani ama kama bofe ya? Boti tori ya hiri ni e boko karihi teha amake. Nabarina e kawatarete amake fara nabarina tabori ya kawitarehabana. E ka owa tokiyome ya nabarina hiri ni awehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","E ehene e tebisahabone eke ahi. E ehene e kehemoterabone eke. Teoso oyene e ehene namotehiba amaka, e hiri naro. ");
INSERT INTO jaa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Owati te miti forima namata. Tika yama tamaha onebone me ta namakitasaboneke mata ya tiwa ni ya. Haha yama tamara tikihamone tina me toyabamakiaboneke\". ");
INSERT INTO jaa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sesowi mati Sesowi nisori mati me na me kobo namakiemetemoneke. Me hihiyarehibona me hinehimatamonaka. Ayata ya me kamakiaba me kakamaki watoremetemoneke, me tami karo. ");
INSERT INTO jaa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Me one ati e nemetemoneke ahi he ni ya: \"Ami niso me na me nahobasaharake yobe beheri ya, tiwa me hiyarabone me ati na mati\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","\"Teoso ati me mitaha he ati me tokatabaha afa me amake, okomi toharawa, okaniso me toha na mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yama we one ya me kibehemetemoneke kanawa webote ya, he ya tataba me ya tabahari. \"Hima e kariwaibeya wara kowani ya\", ati nematamonaka. Faya me yana tokanemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Me towakemetemoneke. Amo nematamonaka fahi. Faya yama yana tonaha boni kitaha kakehemetemoneke. Kanawa bokinima nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sesowi me natafiemetemoneke. \"Sesowi, Sesowi, e ahabakibone\". Faya waremisehimatamonaka, boni fawa nihibanoho, faha rike fawa ni, nebanoho, ati ya. Boni fawa, faha rike fawa, nemetemoneke. Faha winawina nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ati yana nematamonaka. \"Himataba Teoso ati te kasawarineri?\" ati nematamonaka. Me watohemetemoneke. Me abe hiyaremetemoneke, Sesowi ya tataba mati. \"Hibake tohe awaraya, kitahari, boni fawa ni wato, faha rike fawa ni wato, nari, boni ati hikasawaririhi, faha toha, naro?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Me kakariwaha me kobo tokowitehemetemoneke Katara ka wami ya. Katara tohehemetemoneke wara kowani ya, fara Karireya tonoko yokana ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sesowi tokomisehimatamonaka wami ya. Faya Katara ka me ka owa kakehimatamonaka he ni ya. Sitati kamatamona winamarehimatamonaka sitati ya. Wiwinawa tohehimatamonaka tama tabori ya. Makari kiharematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Sesowi awehi kiya kane sonehimatamonaka he nokosi ya. Sesowi inamati hora nematamonaka, he sa tosehibonaha. Ati yana nematamonaka ati kitahari. \"Sesowi Teoso biti kiti mati tihaha himata hiri tiribe owa ni ya? Tiwa aate oke, owa tikatomarabone tiwa\", ati nematamonaka. Inamati kakatoma hihehimatamonaka. Me one wewete hihehimatamonaka, koheti ya feho famaha ya. Koheti bebete tohehimatamonaka. Inamati ehene wawa nawahare tohehimatamonaka yama honara ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sesowi aate hinehimatamonaka. \"Tiwini e na ama tiri?\" ati nematamonaka. \"Owini amake haro, Me Tamake ama oke\", ati nematamonaka. Ati e nematamonaka ahi, me inamati tamaha me ya tabe ka atimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sesowi me aate ba nemetemoneke mera yoserebonaha hoti ya, hoti kowi mati tohaharo. ");
INSERT INTO jaa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Boroko me tamaha me nahohemetemoneke ahi ayata ya atami ya masiri me kabaha mati. Me inamati Sesowi aate nemetemoneke mera toyosemehibonaha, me tokomabone mati boroko me baikani ya. Sesowi me hiyosememetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hahi maki ni ya me inamati fito tona me tokomemetemoneke boroko me ni ya. Boroko me kana ni tokifiwahemetemoneke atami ya. Me bokehemetemoneke faha ya. Me ahabemetemoneke faha boti ihi. ");
INSERT INTO jaa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Boroko nanarifa boroko me ahabi me awaha me tokomemetemoneke. Boroko me me kaminemetemoneke me nafi ni ya, sitati ka me toha, tabora one ka me toha na me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Me ati me mitaha me kamehemetemoneke yama me awamabone mati. Me kamehemetemoneke Sesowi ni ya. Me hiwehimatamonaka itariari Sesowi nokosi ya, hinaka inamati me tokoma mati, amosawahame makari akawahari waha. Me hinakomehematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Me hiwehimatamonaka Sesowi hinakitamari. Me hikaminehimatamonaka me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Faya Katara ka me nafi Sesowi me hiyaremetemoneke, tokomebonaha me watoha mati kasiro ya. Faya tofoyame wete kanamematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Me ka owa kitame Sesowi aate nematamonaka, me ya tabehibonaha. Tokomebona Sesowi hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","\"Tikamahi fara titaboro ya. Yama tikaminibeya te one me ni ya Teoso hiri hinaharo tiwa ni ya\", ati nematamonaka. Faya tokome hiwa kaminematamonaka sitati ka me nafi ni ya fare Sesowi hiri hikane ka yama. ");
INSERT INTO jaa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sesowi wete name me tamaha me hikarawatomatamonaka. Me yayai nemetemoneke he me siba ni karo. ");
INSERT INTO jaa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Me ka owa Sairo tohehi sinakoka owa hiti tohehi kakehimatamonaka Sesowi ni ya. Sonarisehimatamonaka Sesowi nokosi ya. He hiyarematamonaka. Tokomakehibona hinehimatamonaka hinaka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Fara bite oharia ahabinima nemetemoneke. Hinaka ano 12 nemetemoneke. Sesowi tokomakehimatamonaka. Me tamaha me yaka na me ya tabehimatamonaka. Me kita tokahemetemoneke he ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Me ka one kamakiemetemoneke he nowati ka ya. Hinaka makari tati boni bori kanehemetemoneke, hinaka ama fawa ri ka ano 12 naro, kasomi tabiyo metiko mera baka teharo, hinaka yinero tonafiyoteharo, kitamihinateraro. Fara Sesowi borone bori kani ka yama ya hinaka ama fawa nemetemoneke hibati ya. ");
INSERT INTO jaa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sesowi ati yana nematamonaka. \"Hibake owa bori kana?\" ati nematamonaka. Me nafi ati yana narawemetemoneke me bori hikana hikara. Betiro me ya tabehi me ati yana nemetemoneke. \"Sesowi himataba tiwati e nineri ahi, otara aate tinaha tiwa? Me tamaha me tiwarini, me kita tokaha mati tiwa ni ya?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","\"Me ka owa owa bori kanaka. Owa owato oke oko kiti tokaha owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hine kaminarabone ati na Sesowi hiwato ka hine kaminemetemoneke waha. Kamakiemetemoneke hoyahoya kana naro. He ni ya sonarisa itarisehemetemoneke he nokosi ya. Hine kaminemetemoneke Sesowi ni ya me tamaha me nokosi ya, he bori kanaharo, kitamabonehe. Hibati ya kitamakabote namone ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","\"Okoto tikitama tike tiwati e na tiwa ahi, tiwati boti ya, 'Owa kasomebanaka, kitahari', tini karo. Watorima tinahi. Tikamahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sesowi me ka one hiyare ni ya Sairo ka yobe ka owa kamaki ati yana nematamonaka. \"Sairo tikoto ahabarake hibati ya. Borofeso hine naka waha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Efe ati Sesowi mite ati yana nematamonaka. \"Watorima tinahi. Tiwati e nahi ahi tiwati boti ya: 'Teoso hikasomahaba amake', tinahi. Tiwati e ni ya kitamaba amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tokiyomamakehimatamonaka yobe toro ya. Mera nakiyomamaki nofarematamonaka. Ha ita mera tonakiyomamakimatamonaka Betiro, Tiako, Yowao, atona bati, mati, me na mati. ");
INSERT INTO jaa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Me nafi ohi nemetemoneke atona ihi. \"Te ohi rima nahi. Ahabakere. Hine ya amo nineke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Me haha hikanematamonaka, atona ahabi me watoha mati. ");
INSERT INTO jaa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sesowi me nafi toyosemehimatamonaka me tokiyomamabone mati. Faya yehe wara hikana ha hinehemetemoneke. \"Atona tiwamisahi\", ha ni ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Atona kanamori kamakabote nemetemoneke he ni ya. Wamisamakabote nemetemoneke. Sesowi me narabi nima nematamonaka he tefebone me ta nabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bati ya mati me famaha \"Hika\", me ati nemetemoneke. Me narabi nima nematamonaka. \"Yama te kamina riyahi\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yama we one ya Sesowi he ya tataba me 12 na mera ha nematamonaka, me kitibone ta nebonaha, me inamati nafi me toyosemahabone mati, me kiya na me nakitama nabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Me ati e nabone ati nematamonaka me ni ya: Teoso ka towisawa kamakabote nebonaka. Ati ehene me me nakitamahaboneke, me kiya na mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","\"Te honarabone teke. Yama sawiraboneke te ni ya\", ati nematamonaka. \"Era tataba kana awa tohaha te kiharihi, sakora te kiharihi, bao te kiharihi, yinero te kiharihi, nabone teke. Te ka makari oohariabone teke, te akaharo. ");
INSERT INTO jaa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sitati ya te kobo ni ya yobe ohari ya te sawihabone teke. Yobe owa ya te tokarabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te hiyari kamiti me nofari ya te tokahaba teke. Te yana toni ya te teme te wisa tokanaba teke, hobokori bo tonahabana, te teme ka wami hobokori, me hiwahabana, te yawaha te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Me yana tona me tokehemetemoneke tabora nafi ya. Hiyara amosa me kaminemetemoneke. Me kiya na me me nakitama nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eroti me ka tetaraka tohe hiyara mitehimatamonaka, Sesowi mera nakitamehi me kamina mati. Ati boti yama nima nifakohimatamonaka, me ati mitahari, Yowao kitamemona me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Me one ati e nemetemoneke ahi: \"Eria kamatasahareka\". Me one ati e nemetemoneke ahi: \"Hibati ka Teoso ati kakamina me kitamarawatasa me awineke\". ");
INSERT INTO jaa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eroti ati yana nematamonaka. \"Yowao onabowe tati ti osehiri amaka. Hahi hibake amara hari, tamine omitari?\" ati nematamonaka. Sesowi awehibona ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","He ya tataba aya me tokaha me wete namaha me ihi me kaminamehemetemoneke, Sesowi ni ya. Mera hima nematamonaka me ya totabawitibonaha, me tokahabone mati sitati Betesaita ya, me one me ya me tabamarahabone mati. Me tamehemetemoneke kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Me one tamaha me me watohemetemoneke, me sawiha mati tabora one ya. Me tokomakehemetemoneke. Me kobo tonamake Sesowi yawarematamonaka. Mera hiyarematamonaka, Teoso ati kaminari. Me kiya na mera nakitama, nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bahi tokehimatamonaka. Sesowi ya tataba me 12 na me kamehemetemoneke Sesowi ni ya, he me hiyarabone mati. \"Sesowi me tiyosemahi, me tokomaba mati ahi, tabora yabora ya, me amo naba mati, me tafa, naba mati. Tabora watakere ahi\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","\"Me tafeba te ta nahi fara me te\", ati nematamonaka. \"E ka yamata nafikere. Bao 5 toha, aba me fama, ke. Me nafi tafeba ota kanikibana?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Haha makiti 5000 me tohehemetemoneke. Sesowi he ya tataba mera hiyarematamonaka, me me ebe nabone mati, 50 me toharawa me nahohabone mati wami ya, me tafahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Fare Sesowi ati nima me ihi nemetemoneke. Me nafi nahorisehemetemoneke, me tafahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bao 5 ne wara tokanematamonaka. Aba me fama na mera wara tokane neme awehi ati yana nematamonaka, \"Teoso faya amake\", ati nari. Faya yamata ebe ne yamata ta nematamonaka he ya tataba me ni ya, me me natafabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Me tafaha me akaremetemoneke, me nafi. Yamata isi ni hasi na me kayabemetemoneke. Isiri 12 na mo nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yama we one ya Sesowi Teoso ha nematamonaka. He ya tataba me ya tabi oharimatamonaka. Mera aate nematamonaka. \"Hibakemona owa me ati ri?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","\"Yowao Batisitamona me one tiwa ati narake. Eriamona me one tiwa ati, hibati ka Teoso ati kakamina me ka owamona me one tiwa ati, narake, kitamari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","\"Ha te hibakemona owa te ati ri, ha te?\" ati nematamonaka. Betiro ati yana nematamonaka. \"Ha tiwa Kirisito ama tike, Teoso ka tiwa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sesowi me narabi nima nematamonaka, me hikaminarebonaha me one ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","\"Neme ka Owa kokoriri tehiba amaka. Sasetoti me ka hiti mati, me nafi ka hiti mati, Mowisei ati kakamina mati, me na me hikakoteba amaka. Me one hinabowehiba amaka. Ahabe amo ni fame ya wamisamebonaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mera hiyara nematamonaka me nafi. \"E tabibone te ati nine? Fara yama tinofa hiri tirahabone tike. E famahabone tina tika ewenebone tiwa tikanabone tike, tihabibone ka awa, fara yama we nima. ");
INSERT INTO jaa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tiwa tikayawi ya tihababone tike. Owa tinofi ka tihabi ya tiwa tikasomahabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yama amosaba ama, fawa tini karo, yama nafi tikiha tiwa? ");
INSERT INTO jaa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Owini hiri ni tinofari ya me nokosi ya owati kamini tinofarihi tini ya Neme ka Owa tiwini kaminatereba amaka kame ya. Kame ya oya kitehiba amaka Teoso oyene ehene, Teoso nanarifa me oye ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Te one Teoso ka towisawamona me awatehaba me amake, me ahabara mati mata. Keye amakere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Semana oharia ahaba nowati ya mera ha nematamonaka, Betiro, Yowao, Tiako me na mati, me tokomisahabone mati atami ya, Teoso me ha nabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Teoso ha ne noko bako awi hihiya nawahematamonaka. Hinaka makari awi oya kanehemetemoneke, sasawa naro. ");
INSERT INTO jaa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Me makiti famaha kafotokehemetemoneke, Mowisei ya Eria me famaha mati. Me oya kanikimehemetemoneke. Sesowi me hiyaremetemoneke. Ahababona ka yama me kaminemetemoneke Serosarei ya, Teoso ati ehene. ");
INSERT INTO jaa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Betiro nokobisa me awehemetemoneke kasiro ya. Me tafiha Sesowi oya kanehi me awehemetemoneke. Me famaha Sesowi ya me tabaha me me awa nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Haha me famaha me yana tokani ya Betiro Sesowi hiyarematamonaka. \"Sesowi yama amosake haro, e tabi karo. Yobe biti terei ne ota hiri naba otake. Tikaba ohari, Mowisei kaba ohari, Eria kaba ohari nebanaka\", ati nematamonaka. Hiyarebona atibona watore hine ya hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Betiro hiyarasa ne ya neme sabi kisaha mera moto kanehemetemoneke. Neme sabi boti me nakomehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","E ati kakehemetemoneke neme sabi boti ya. \"Okatao amaka hari, oyosehari. Ati te kamitaho\". ");
INSERT INTO jaa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ati fawa ne ya Sesowi towaharikosehimatamonaka. Betiro me ati wataremetemoneke, me one me ni ya mata. ");
INSERT INTO jaa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yama wamini ya me kisamemetemoneke atami ya. Sesowi kisame me tamaha me kobo hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Me ka owa ha ni kitehi ha nematamonaka. \"Otara kakanawana okatao tiwamatahi. Okatao fare oharite amaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Inamati sawi fare tohi nofe amaka he ni ya. Ha ni fare tohi nofe amaka, rabikari, inamati ehene. Hiwa were ne inohoti sabone kawati nofe amaka. Hiyahiyaya nofe amaka, mese, inamati ehene. Inamati totokomi nofe amaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tiwa ya tataba me hikasomehibona onehi kasomi me hiwatorahareka\". ");
INSERT INTO jaa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sesowi hihiyarehimatamonaka. \"Te ati boti hiyara awineke. Teoso kitehi kiti te watora te awineke. Yama nawahake e tabiba ka yama. Tikatao tekamahi owa ni ya\". ");
INSERT INTO jaa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Inamatewe me hekame sonehimatamonaka bofe ya inamati ehene, katomari hiri nari. Sesowi inamati hora nematamonaka. Inamatewe kasome inamatewe ta tonamematamonaka inamatewe bati ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Me nafi ati yana nemetemoneke. \"Teoso kitabote amaka\", me ati nemetemoneke. Me nafi ati tohehemetemoneke, Sesowi ehenemona me hiyara mati. Sesowi he ya tataba mera hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Owati te mitahi. Neme ka Owa me ta towitiaboneke me one ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yama me watoremetemoneke, Sesowi hikaminaharo, Teoso ati ehene. Sesowi me aate rihi nemetemoneke, me hinakomehe kari. ");
INSERT INTO jaa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yama we one ya he ya tataba me abe hora nemetemoneke, me ka towisawabona me siba na mati. ");
INSERT INTO jaa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sesowi me ati mitare me ati boti watohimatamonaka, yama me wati hiwaharo. Inamatewe nawamise inamatewe nawehimatamonaka beheri ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mera hiyarematamonaka. \"Owa tinofi ka inamatewe tinarifi ya owa tinarifa tiwa awine tike. Owa tinarifi ya, hahi owa yosehimari tinarifa tiwa awine tike. Te ka owa inamatewe nima ne te ka towisawa tohatehiba amaka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowao Sesowi hiyarematamonaka. \"Sesowi e ka owa inamati toyoseme ota awa otake, tiwini hiri nari. Ota ati hiyara otake he ni ya, e ni ya sawire kari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","\"Te hora rayaho. Tera kakore ya te ka owa tohehibonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Neme ya Sesowi tokomisabona ka yama amo ni yabokirimakoni tokomakehibona ati nematamonaka waha Serosarei ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mera toyosewitimatamonaka, me tai toawitehabone mati Samaria ka me tabori one ya, me me hiyarabone mati, Sesowi me amo nihabone mati me tabori ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Me tabori me kayawemetemoneke, Sesowi tokomebona ati ne karo Serosarei ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sesowi ya tataba me one me ati tamine me mitaha me Tiako ya Yowao me famaha Sesowi me aate nemetemoneke. \"Teoso ota ha nabone tina tiwa awine ti, yama oye yosehibonaha, mera nahabihibana?\" me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sesowi tonokowahame mera hora nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Faya me tokawehemetemoneke tabora one ya. ");
INSERT INTO jaa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hawi ya me yaka ni ya me ka owa Sesowi hiyarematamonaka. \"Osawiabana oke tiwa ni ya, yama nafi ya, fara tika toki nima\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sesowi ati e nematamonaka ahi: \"Kawara me hoti nate me amake. Bani biti me tabori na, teha me amake. Neme ka Owa taboro watatere amaka, aamo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sesowi me ka owabisa hiyarematamonaka. \"E tabahi\", ati nematamonaka. \"Ota ka Hiti e tabahabone wete onamamatabana oke mata, otaboro ya, okobi okomoaba owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sesowi hikayawehimatamonaka. \"Me ahaba me abohi hine me one me me hikamoaboneke fara me one ahaba mati. Ha tiwa ta, Teoso ka towisawa tikaminahabana tike\". ");
INSERT INTO jaa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Owa Sesowi hiyaratasehimatamonaka. \"Sesowi e tabawahaba eke. Wete onami ya otaboro ka me aate onami ya e tabawahaba eke waha\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sesowi ati hiyarematamonaka. \"Bowi yama horo kanaha nowati ya e yotoha yama e tama kanaha e ki towahamatera e amake e nowati ya. E tini ya Teoso ka towisawa ya te famaraba te amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yama we one ya e ka Hiti mera kakatikehimatamonaka, 72 me makiti tohaha mati, mera yosehibonaha, me fama me fama na mati, me tokahabone mati sitati nafi ya, fare tokabona ka yama ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mera hiyarematamonaka. \"Yamata tamake fatara karo. Me tamakere, yamata me yabahaba mati. Fatara Hiti te aate nahi, mera yosehibana, yama me ahi naba mati, hinaka yamata me hiyababana. ");
INSERT INTO jaa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Te yana tonahi. Tera oyose oke me ihi hiyara me baikani ya. Ofeya me nima te nabone teke, te sawiha te robo me ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yinero borone te kakibirihi, sakora te weye karihi, sataya te kiharihi, nabone teke. Me te hiyararahabone teke hawi ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yobe ya tikiyomawiti ya tiwati e nabone tike ahi: 'Teoso tera kakatomehibonaka hahi yobe ka me te', tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yobe hiti tera nofe ya Teoso mera kakatomehibonaka fahi. Yobe hiti tera nofare ya Teoso mera kakatomarebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Efe yobe ya te sawi ohariyahi, me ya te tabaha te tafaha te. E ka owa era nanarifa yinero warara ne nima te naba teke, yama te ahi ni karo. Te tokaraba teke yobe owa ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sitati ya tikiyomi ya tiwa me nofi ya me tafe tikababone tike. Yamata one tikanikamakerabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Me kiya na me te nakitamahaba teke, me ka mati. Te ati e niyahi ahi me ni ya: 'Teoso ka towisawa kobo nima ka te ni ya', te ati niyahi. ");
INSERT INTO jaa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sitati ya te tokiyomaha tiwa me nofari ya tiwakosahabone tike howa ya. Tiwati e na yana nabone tike ahi: ");
INSERT INTO jaa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Oteme wisa okine oke, te taboro ka wami hobokori tira toba karo, oyawi karo. Owati te mitamata, ha owa. Teoso ka towisawa kobo nima ka', tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Haha sitati ka me kokoriri ni nafitehaba me amake, Teoso yama manakone nahabihibona ka amo ni kobo ne ya. Sotoma ka me ta me kokoriri ni nanafi raba tehaba me amake haha yama ya\". ");
INSERT INTO jaa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","\"Korasi ya te winaha te kokoriri tehaba te amake kasiro ya. Ha te Betesaita ya te winaha te kokoriri tehaba te amake kasiro ya. Teoso yama tamaha yofi kanaka kitaharo kasiro ya te ni ya, yama hiri onaha te awaha te. Tiro ka me toha, Sito ka me toha, na owehene me awehemenehe, me ihi hiyara me ihi me nofamarehenemete me amake hibati ya, makari mese kitaha me weye na mati, yifo hobokori ya me tati me mata kana mati, me yawa mati. ");
INSERT INTO jaa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Teoso yama manakone nahabihibona ka amo ni kobo ne ya te kokoriri ni nafitehaba te amake. Tiro ya Sito famaha ka me kokoriri ni nanafi raba tehaba me amake haha yama ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ha me te Kafanao ka me te, Teoso tera towakimisebona te ati na te awineke, neme ya. Teoso tera towakimisamareba amaka neme ya. Te tokisaba te amake e abohi taboro ya\". ");
INSERT INTO jaa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","\"Te ati me kamiti ya owati me kamita me awineke. Tera me nofari ya owa me nofara me awineke. Owa me nofari ya okobi me nofara me awineke, owa yosehari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yama we one ya 72 me tohaha me wete namehemetemoneke, me yayai na mati. \"Sesowi fara ota ati nima me inamati ihi narake, tiwini ota hiri na ota\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","\"Satanaisi sonehi soni owahara oke neme ya, bahi yebe kane nima nari. ");
INSERT INTO jaa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Owati te mitamata. Maka mese te tai nare, yomasa mese te tai nare na tera noho toniharawarahabone teke, owati ihi. Me inamati tera boyo rabone teke, owati ihi. ");
INSERT INTO jaa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Te yayai rima nahi mata, me inamati kitara me ihi. Te yayai nabone teke, te ino sawihani te, Teoso ka yama hani ya, sawihanihi neme ya, Teoso ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yayai nematamonaka Teoso Kanamori ehene. Ati yana nematamonaka. \"Abi neme Hiti ama tike. Wami Hiti tiha tite ama tike. Tiwehene amosara tike, haha yama tikehemoha tiwa, yama wawato me ni ya, haha yama me awarabone mati. Matehe fotara me ni ya yama yofi tikanara tike. Abi, tiwehene e na ama tike, fara yama tinofa ya tiwehene tohaha tiwa\". ");
INSERT INTO jaa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","\"Okobi yama nafi ta naka owa ni ya. Okobi ohari biti watote amaka. Biti fare ohari bati wato, tehi amaka. Fare biti hinamo hite amaka me ni ya, me nafi amararo. Bati yofi kani oharite amaka fara me hikatikaha me ni ya\". ");
INSERT INTO jaa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sesowi mera hiyarematamonaka mata, he ya tataba mati. \"Teoso tera nofaka, ha te ta, haha yama hiri onaha te awaha te. ");
INSERT INTO jaa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Me tamehemetemoneke, towisawa mati, Teoso ati kakamina mati, yama te awaha me awahabone me ati na yama me awara mati. Haha yama te mitaha me mitahabone me ati na yama me mitaremetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","E ka owa Mowisei ka yama hani wawato tohehi Sesowi aate nematamonaka, totomi hinehibonaha. \"Borofeso himata nima owehene ribe, oko wini fara tohatehabone owa Teoso taboro ya, ati ehene?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sesowi aate hinehimatamonaka: \"Himata nima Mowisei ka yama hani atitehani amari, ati tiyabaro?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","\"Ati e nematamonaka ahi: 'Tika Hiti Teoso tinofabone tike tiwati boti ya kasiro ya, tika kiti ya tabaharo. Te one me tinofa tinahi. Fara tiwa tinofa tiwa nofi nima me nofi tinahabone tike', Teoso ka yama hani ati te amake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","\"Tiwati amosake. Tiwehene e ni ya Teoso ya te famatehaba teke taboro ya, tihabamateraba tiwa\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hahi amosemona Sesowi hinehibona ati ne Sesowi aate namatasehimatamonaka. \"Hibake me amari, e ka one mati, me e nofahaba mati?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sesowi ati e nematamonaka ahi: \"E ka owa Serosarei ya yana ne tokome yama boboti mera kobo nemata awaka, Seriko hawi ya. Hinaka yama nafi me hekamehemetemoneke. Me baro hine me hekanakosehimatamonaka, korone tohahari. Ahabinima nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sasetoti me ka owa kamakimatamonaka hawi ya. Hiwehimatamonaka homahari. Hekitikosawematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Refita me ka owa kamaki hiwatasehimatamonaka. Hekitikosawatasehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria ka me ka owa kamaki hiwehi hinofematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hiketehimatamonaka hihiya ni, fi ya, orifa fehe ya. Hihiya ni hikarafehimatamonaka makari ibe ya. Hibarimisematamonaka hinaka bani mese ya. Fore hekamehimatamonaka oteo ya, hinarifahari. ");
INSERT INTO jaa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yama wamini ya moweta tenario tohehi famehi itikimehimatamonaka, fare hinakari, ta hinehibonaha oteo hiti ni ya. Ati e nematamonaka ahi: 'Tekatomebonaka. Tenario famehi tinafiyomaki ya tiwa baka onamaketasahabone oke wete onami ya', ati nematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sesowi aate hinehimatamonaka. \"Teoso atimatamona ya hibake ehene toharamatamona? Sasetoti ama namatamona? Refita me ka owa ama namatamonaha? Samaria ka me ka owa ama namatamonaha?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","\"Hahimatamonaka hari, he kasomari\", ati nematamonaka. \"Tiwehene e nabisabone tike ahi, hahi ehene nima\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Me yana tona me tokehemetemoneke me tabori ya. Me ka one Mahata tohaha Sesowi ha nemetemoneke sawihibonaha hinaka yobe ya. ");
INSERT INTO jaa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mahata hinakasimametemone amake Maria. Maria itariemetemoneke Sesowi beheri ya, he ati kamitaro. ");
INSERT INTO jaa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mahata yamata wasi fara tohehemetemoneke me tafe. Yamata hinahatohemetemoneke, hinaka yama ahi ni tamaharo. Wehemetemoneke Sesowi beheri ya. He hiyaremetemoneke. \"Sesowi okasima owa kasomakere. Owahariha yamata owasi oke. Tinofa awine ihi e naro ahi? Narabi nima tinahi, owa kasomabana\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","\"Mahata, Mahata, yama ahi ni tamaha tiwa nahatoke. ");
INSERT INTO jaa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Fara yama amosa oharineke. Haha yama Maria wasineke, yama amosi mati tohaharo. Haha ihi hine tohake\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yama we one ya Sesowi Teoso ha nematamonaka yama one ya. Teoso ha ni hawa tohe ya he ya tataba me ka owa aate hinehimatamonaka. \"Sesowi otara tikanawanabone tike Teoso ota ha nabone ota atibone ya, fare Yowao namatamona nima he ya tataba mera kanawanahari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","\"Te ora ni ya te ati e naba teke ahi: 'Abi, me nafi tiwa kahiyarahi. Tika towisawateba kakeho ota ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fara yama we nima ota tefebone ta tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yama hiyara wati tiwahamariyahi, ota hiri teharo. Ha ota bisa me one ka yama hiyara ota nahabibisahaba otake, otara me hiri kani ka yama hiyararo. Satanaisi otara totomi rayaho tiwati ihi', te ati nabone teke, Teoso te ha na te\". ");
INSERT INTO jaa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","\"Himata nima owa ati neba amara, hinaka habai kamaki ya he ni ya yama soki enoki ya. Hinaka habai ati e tehi amaka ahi: 'Habai oko baoba ta timatahi, terei nari. ");
INSERT INTO jaa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Oko habai owa kobo namakiareka, yaka nari. Tefeba okiha okara, yamata'. ");
INSERT INTO jaa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ati e neba awaka ahi: 'Hine owa oke. Tikamahi. Nokobi boko okanara oke hibati ya. Oko matehe ya otaba oke kama ya. Yana orahaba ama oke, yama ta onahaba owa, tika yamabana', ati neba awaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Efe hinaka habai toha kana yana rebonaka, bao ta nebana. Nokobi teo kani fawa re ya yana neba amaka, bao ta nebana waha, nokobi teo ni fawa re kari. Fara yama hinofa nafi ta neba amaka\". ");
INSERT INTO jaa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","\"Makoni yama tinofa ha tikanabone tike Teoso ni ya. Tika yamabone ta nebonaka. Yama siba tini ya tiwasiabanake. Nokobi teo tikani ya Teoso se hikanaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","E ka one Teoso me aate ni ya ati amosebonaka me nafi ni ya. Yama me siba hina me hiwasiaboneke, me nafi. Nokobi me teo kana me ni ya Teoso nokobi se kanehibonaka, me nafi ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","E one maka me ta narawaba me ama, me ka matehe ni ya, matehe aba me me ati na mati? E ehene e naba wataraboneke te ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tikatao bani hifene ati ne ya yomasa ta tibana? Yomasa ta tirahaba tiwa awine tike. ");
INSERT INTO jaa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yama hiyara hihiri me te tohaha yama amosa te ta teha te amake te ka matehe ni ya. E ka abi neme ya winehi ehene amose hinama tohate amaka. Teoso Kanamori te ha ni ya Teoso Kanamori ta nebonaka te ni ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yama we one ya Sesowi me ka owa nakitamehimatamonaka inamati famahari, inamati ehene ati yana ni watorari. Sesowi inamati toyosemehimatamonaka. Faya ati yana nawahematamonaka. Me tamaha me hiwehimatamonaka. Me ati e nemetemoneke ahi: \"Himata amari?\" me ati na mati. ");
INSERT INTO jaa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Me one ati e nemetemoneke ahi: \"Fare Beosebo ati ehene tohe awaka. Makoni inamati mera toyosemaka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Me one Sesowi hiyaremetemoneke yama yofi kanehibonaha Teoso ka yama me ni ya, me totomi hine kari. ");
INSERT INTO jaa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sesowi me ati boti watohi mera hiyarematamonaka. \"Saotato me abe mowa ni ya, me kiti watamaraboneke. Towisawa owa ka saotato me tabori me hinabihaboneke, me ka sitati. Hahi yobe ohari ka me abe mono ni ya me abe nahabihaba me amake. ");
INSERT INTO jaa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te ati e na teke ahi: Me inamati tokomamone te ati na teke Beosebo ehene. Haha keye amake haro. Satanaisi hinaka inamati mera mono tere amaka, hinaka me tohi karo. Me hinamati ka towisawa amaka. Inamati me abe mono ni ya inamati me abe nahabihaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Me inamati oyosemahamone te ati na te awineke, Beosebo ati ehene. Manakobisa te ka tataba inamati me me toyosema Beosebo ati ehene ama? Beosebo ati ehene amare awaka. Yama hiri ona Beosebo ati ehene amakara bisa. ");
INSERT INTO jaa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hinamati me oyosemine oke Teoso ati ehene. Faya Teoso ka towisawa kobo nareka ahi\". ");
INSERT INTO jaa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","\"E ka owa kitehi hinaka yobe hekatome ya ye honahari hinaka yama me hibotirahaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Owa kiti mati tohehi kamaki ya he ye honene totimakehibonaka. Kitarebonaka hahi ehene. Faya hinaka yama hiyababoneke fahi. Hinaka yama me ebe hinahaboneke fare me one ya tabahari. ");
INSERT INTO jaa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Owa ni ya tisawiri ya owa tinofara tiwa awine tike. Tiriko boni e bata na e famari ya tiriko boni mata tikawite tiwa awine tike\". ");
INSERT INTO jaa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","\"E ka owa ni ya inamati sawihi inamati tokome ya faha watari ka yama ya kariwate amaka, taborobona siba nari, taborobona wasirari. Ati e nebonaka ahi: 'Wete onamabana oke fara osawi ka yobe ya', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wete name yobe wasimebonaka, amosari, me yowi hiwahari, me hinamosamari. ");
INSERT INTO jaa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Me 7 na mera ha nebonaka, me hiyari mati tohaha mati, me ya tabawehibonaha fahi, me winaha mati. E ka owa ka yama nawaha kitamisahaboneke waha, inamati me ihi\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sesowi hiyare ya me ka one me baikani ya waha ati kitaha ati yana nemetemoneke. \"Teoso ami nofe tiwa awine tike\", ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sesowi ati yana nematamonaka. \"Teoso mera nofate amaka he ati tamine me kamita mati fara Teoso me hiyose ka yama ya me ihi tohaha mati\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Me tamaha Sesowi me moto kanehemetemoneke. Me totama nemetemoneke. Ati yana nematamonaka. \"Te boti hiyara te awineke, Teoso ka yama yofi okanabone te ati na te, te ni ya. Yama te awaraboneke Teoso ka yama. Hine ya Teoso ka yama oharia te awahaba teke, yama Yona hiri hinemete nima naro. ");
INSERT INTO jaa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Teoso Yona yofi kanehimatamonaka Ninifi ka me ni ya. E naboneke fahi, Teoso hinamoaro Neme ka Owa namohari te ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yama toyabo ya Teoso yama nafi manakone nahabi ya towisawa fana Saromao yaka nemete te ya tabahaboneke. Te ehene hiyaramone ati naboneke, ihi nima te ehene ra te. Kakehemetemoneke yama yabo ya Saromao ati mitahabonehe Saromao yama wato kari. Ha owa ta yama wato mati ohaha owati kamiti te nofakere. ");
INSERT INTO jaa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninifi ka me toha, naba me amake. Te ehene hiyaramone me ati, naba me amake afa yama ya, Teoso nokosi ya. Me ni ya Yona Teoso ati kamine me ihi hiyara me nofamarehemetemoneke. Yona yama wawato raba nematamonaka. Ha owa ta yama wato mati ohaha owati kamiti te nofarineke\". ");
INSERT INTO jaa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","\"E ka owa nabarina sari kane ya hikanawitaraboneke yobe bofe ya. Hekiberihi hinaboneke boti tori ya. Kawitarete amake neme ya fara nabarina tabori ya yama firi kanahabana yobe toro. E ka owa kiyomake ya yobe ya yama awi amosebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nabarina nima e noko te amake, e abono nafi fifiri kana. E noko amosi ya e abono nafi firi kanaboneke. E noko rabiki ya e abono nafi yoma kanahaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te boti ka yama oye yoma kariyahi. ");
INSERT INTO jaa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Te abono nafi firi kani ya, yama yoma kanahaba watari ya, firi kanahabanake, nafi. Fara e nima naboneke, yama era firi kanaha e\". ");
INSERT INTO jaa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sesowi hiyari ahabe fariseo me ka owa ha hinehimatamonaka tafehibonaha me tabori ya. Yobe ya tokiyome tokomakehimatamonaka e tatafa ya mesa ya. ");
INSERT INTO jaa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sesowi tafehiba yehe soko re fariseo hiwe \"Hika\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sesowi ati yana nematamonaka. \"Ha te fariseo me te te ka kobo te soko barato te soko nineke, mese. Te ati boti ta hiyara te awineke, yinero tamehi te nofaha te. ");
INSERT INTO jaa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yama te watokere. Teoso yama mese hiri ne yama tori boti ka hiri nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Te ka barato tori yamata kihaha te ta kanahaba teke me honara me ni ya. Te ehene e ni ya yama bisahaba wataraboneke te ni ya\". ");
INSERT INTO jaa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","\"Fariseo mati yama hiyara kakehaba amake te ni ya. Fatara ka yamata isi ni te ta te te amake Teoso ni ya. Yamata isi ni te te na te ka one me kasomi yokana te tohatera te amake, Teoso te nofara te. Te ehene e ni ya amosene amake ahi. Yamata isi ni te ta, Teoso te nofa, nabone teke. Te ehene e ni ya amosabanake\". ");
INSERT INTO jaa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","\"Fariseo mati yama hiyara kakehaba amake te ni ya. Sinakoka ka katera taiti ya nahori te nofateha te amake. Mekato ya te sawi ya 'Afa ama ti,' me one ati nabone te ati na te awineke te ni ya\". ");
INSERT INTO jaa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","\"Fariseo mati, yama hiyara kakehaba amake te ni ya. E ahaba temene nima te nineke yofi karaharo. Me tai hinaboneke, me hiwatori karo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Teoso ka yama hani wawato me ka owa Sesowi aate nematamonaka. \"Era kakanawana me hora tina tiwati e na otara hora tine tike bisa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sesowi ati yana nematamonaka. \"Yama hiyara kake, naba amake te ni ya, Teoso ka yama hani wawato me te. Me te yoseteha te amake, yama kanaha me tiwa nabone mati. Me te kasomatera te amake, yama kanaha me tiwa na mati. ");
INSERT INTO jaa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yama hiyara kakehaba amake te ni ya. Teoso ati kakamina me tame te nataminateha te amake. Fara te ka iti me me waka hinehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Me tame te nataminaha tera te kaminineke fara me te, te ka iti me ihimete te nofaha te, Teoso ati kakamina me me waka na mati. ");
INSERT INTO jaa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Teoso yama watotehi ati e nareka ahi: 'Owati kakamina me toha, oko yoyose me toha, na me oyosehabana oke me ni ya. Me ni ya me oyose me me waka hinahaba me amake. Me one me me hikatomahaba me amake'. ");
INSERT INTO jaa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Me ahabi manakone te tohahaba te amake, Teoso ati ehene, me nafi manakone, hibati ka Teoso ati kakamina mati. ");
INSERT INTO jaa_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abeo tai tohe manakobisa Sakaria yotoyotokosa nematamonaka. Me hinabowehimatamonaka tana ya Teoso ka yobe famehi hawine baikani ya. Me nafi me me waka hinehemetemoneke. Me ahabi manakone te tohahabone teke, me nafi manakone. ");
INSERT INTO jaa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yama hiyara kakehaba amake te ni ya, Teoso ka yama hani wawato me te. Safi te itihani teke, nokobi naha kibone ka safi, Teoso me watobone karo. Safi te itiha te tokiyomara teke. Me one tokiyomarihi narake te ehene\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sesowi tokomematamonaka. Mowisei ati kakamina me toha, fariseo me toha, na Sesowi me kakoemetemoneke waha. Aate ni me hikasirohimatamonaka waha. ");
INSERT INTO jaa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Me hikeyehibona me hinehimatamonaka, ati tosawaribonaha. ");
INSERT INTO jaa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Me tamaha me kakehemetemoneke Sesowi ati me mitahabone mati. Me tami ka me abe tayohemetemoneke. Sesowi fara hinaka tataba mera hiyari oharimatamonaka. \"Tera te kakatomahi fariseo me ka fehemeto ya, me one me me keyeha mati, me ka keye e na mati fehemeto nima. ");
INSERT INTO jaa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Fara e ehene e kehemoha yoto kanamaraboneke, me hiwatoabonehe. ");
INSERT INTO jaa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Haha yama tikaminaha yama soki ya me hikaminaboneke yama wa toni ya. Tika owa ya te famaha yobe toro beheri ya te towakiyoma te abe basa kana yama te kamina me kaminaboneke me ati kitaha mati, me naoria mati yobe neme ka ya\". ");
INSERT INTO jaa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","\"Owati te mitahi. Me e nakomerabone eke, era me nabowahabone e. Hine ya e abono me nabowaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yama okomina okibone, te nakomehabonehe. Teoso te nakomehabone teke, era nahabitehibana. Era nahabi nowati ya era were tehibonaka yama hiyara ya. Te nakomehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bani biti me manakone moweta fotare famehibonaka. Bani biti me manakone fotara ya Teoso ati katamobiti watatere amaka, mera kakatomahari. ");
INSERT INTO jaa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te watorabone teke. Te manakone e nabone teke ahi, bani biti me tamaha me manakone nima. Teoso era kakatomaka. E tati kone oohariki na nafi watoka\". ");
INSERT INTO jaa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","\"Owati te mita mata. Owa te nofahamone te ati ni ya me nokosi ya te hiyari ya Neme ka Owa hiyarabisebonaka Teoso nanarifa me nokosi ya, tera nofehimona ati nari. ");
INSERT INTO jaa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Owa te nofaramone te ati na me nokosi ya te hiyari ya Neme ka Owa hiyarabisebonaka, Teoso nanarifa me nokosi ya tera nofaremona ati nari. ");
INSERT INTO jaa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Neme ka Owa ehene hiyaremona te ati ni ya Teoso te ehene fawa nibona teke. Teoso Kanamori ehene hiyaremona te ati ni ya Teoso te ehene fawa nirebona teke. ");
INSERT INTO jaa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tera me nakibitehaba me amake kateya ya. Tera me yofi kana, tehaba me amake sinakoka ka me ni ya. Tera me yofi kana, tehaba me amake towisawa me ni ya. Me ihi e ni ya te atibone te wati nawateraba teke, tera te kamina te. ");
INSERT INTO jaa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Afa yama yokana ya Teoso Kanamori tera kanawanatehiba amaka, te atibone ya\". ");
INSERT INTO jaa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sesowi beheri ya me moto kawahamaha me ka owa ati yana nematamonaka. \"Era kakanawana okaniso narabo nima tinahi, okobi ka yinero ota ebe kanahabone ota, ota fami, okobi ahabari\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sesowi ati hinahabihematamonaka. \"Owati yana rabone oke te ni ya. Owa me yosehaba me watakere, owati yana naba owa, me abe mono ni fawa onihaba owa\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sesowi me hiyaremetemoneke. \"Tera te kakatomahi. Yama tamaha te nofarabone teke. Te kanamori te ka yama nima kere\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Me ka hiyarabone kaminematamonaka. \"E ka owa honene tamahi fatara kihe hinaka fatara tafe hatehemete awineke, yamata tamaha kihahari. ");
INSERT INTO jaa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ati boti e nemata awaka ahi: 'Himata hiri oribe waha, oko tiriko taboriba watamara owa, tiriko tami karo? ");
INSERT INTO jaa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Owehene e nabana oke ahi: yobe tiriko tabori tohehi otisabana oke. Yobe nanafi nama ne hiri owahabana oke, oko tiriko onawata, oko yama onawata, oba karo. ");
INSERT INTO jaa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Faya owati e nabana oke ahi owa ni ya. Oko yama tamaha onawataha tohi ya oko yama ahabateraba amake, fa fowe tamaha ya. Hasi owahabana oke fahi. Ayaka hiri onahabana oke, yayai onaha owa, onahabone oke', ati nemata awaka, e ka owa honahari\". ");
INSERT INTO jaa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","\"Teoso hihiyarehibonaka. 'Yama tiwato tikere. Haha yama soki ya tihababa ama tike, owati ihi. Hike ni ya tika yama toharibe waha?' Teoso ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Haha yama tamaha me toniha hahi ehene nima me ihi te me amake, Teoso yama hinofa ya me ihi tohara mati\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sesowi he ya tataba mera hiyarematamonaka. \"Te kokoriri rabone teke, te ka yamabone te wati nawaha te. Te ati boti e riyahi ahi: 'Himata okobaribe? Himata ofaribe? Himata okaribe?' te ati rabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","E hasi ni ya e yayai nabone eke, yamata tamaha noko e toniharaharo. E abono tamini ya e yayai nabone eke, makari tamaha noko e toniharaharo. ");
INSERT INTO jaa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bani biti fatara me kihatera me amake. Yamata me toniharihi, teha me amake yobe ya. Me tafebone Teoso ta hite me amake. Ha te ta te manakone nanafi, bani biti me manakone yokana tohakere. ");
INSERT INTO jaa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yama tamaha te wati nawaha te kokoriri kene te ahababone teke fara te ahabi amo nibone ya. ");
INSERT INTO jaa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Te ehene amaraba amake, ha te. Te kokoriri rabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yama kabani ka yama mowe te awa ha, mowe amosaro. Yama mowe amosa fara ihi amakere, boribone hiri raro. Saromao borone aamosa raba nematamonaka. Yama kabani ka yama mowe ta amosi mati tohake. ");
INSERT INTO jaa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yama kabani ka yama mowe amosa Teoso ehene amake. Yama kabani ka yama ahabi kerewe raboneke, me sari hikani ya. Yama kabani ka yama manakone yokana tohakere. Ha te ta te manakone nafike. Teoso te boronebone ta nebonaka. Himataba te ati boti e na te awineri ahi: 'Teoso owa kakaweba ama oko yamaba ya?' te ati na te? ");
INSERT INTO jaa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Te kokoriri rabone teke, te tefebone te wati nawaha te. ");
INSERT INTO jaa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Haha yama bara noko me tonihate me amake. Te ka abi neme ya winehi te ka yamabone te nofaha watote amaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Teoso ka yamabone te ahi nabone teke, Teoso yama hinofa te hiri na te. Te ehene e ni ya ahi haha yama te nofaha ya tera kakawebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Te watoraba teke. Teoso ka ofeya me te amake, te ka abi tohahari. Tera kakatomehiba amaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Te ka yama te ta nahi, yama me kihara me ni ya. Te ehene e na yinero borone te hiri na te awineke, ahabaterebana. Te ka yinero tamatehiba amaka neme ya. Neme ya yama boboti yama me botiteraba me amake. Yama abe yama nahabirawarihi, tehaba amake. ");
INSERT INTO jaa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bofe ka yama tamaha te nofi ya bofe ka yama te wati nawahaba te amake. Neme ka yama te nofi ya Teoso yama hinofa te hiri nabone teke\". ");
INSERT INTO jaa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","\"Te tonokohi. Te ati katamoriyahi. Te ka rabiao owiriyahi. ");
INSERT INTO jaa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","E ka owa ayaka ya sawihi kamehi nokobi teo kane ya hinaka yama aahi me naha hikanebonaka, hibati ya, me tonokoa mati. Hinaka yama aahi me ihi nima, te ehene nabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Me tonokoa makari akawame mera natafebonaka. Me amo ni ya mera natafarebonaka. Me tonoko ka me yayai naboneke. ");
INSERT INTO jaa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yama soki enoki ya kobo name ya me tonokosa na me yayai naboneke\". ");
INSERT INTO jaa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","\"Te ehene e riyahi, e ka owa ehene nima, yobe kihahari. Yama boboti yobe nahoti tokiyomehimatamonaka yama soki ya, yobe hiti hiwatorahari. Yama boboti kakiba ka yama watohimanaha, hikarawatonamata amaka, tonokoari, yama soki ya. Yama boboti tokiyomarenamata amaka, ehene. ");
INSERT INTO jaa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Te e nabisabone teke ahi, te ati katamoraha te. Neme ka Owa tera bata karayaho\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Betiro ati yana nematamonaka. \" Sesowi haha hiyara tikamina tikamina awine ota ni ya? Tikaminaha awine me nafi ni ya?\" ");
INSERT INTO jaa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","\"Te e nibana, e ka owa ka yama aahi nima, yama watohari, hinaka yama ahi ni amosaro? E ka owa ka yama aahi amose ya hinaka hiti yama hikaminaha yokana hiri nebonaka. Hiti yana tone yama yabo ya tokome ya hinaka yama aahi yosehibonaka, hinaka yobe kakatomehibonaha. Hinaka yama aahi me one tafebone ta nebonaka ati ehene, yobe ka me nafi, fara yama we nima. ");
INSERT INTO jaa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hiti kame ya yama hikaminaha yokana hinaka yama aahi hiri ne ya, hinaka yama aahi nofehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ha hinehibonaka, hiyosebonaha, hinaka yama nafi kakakatomabonaha waha. ");
INSERT INTO jaa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hiyare ya hinaka hiti yana tone ya ati boti e nebonaka ahi: 'Oko hiti kamakabote kara', ati nebonaka. Faya mera mono ni yana tokanebonaka fahi. Me makiti kosi, me fanawi kosi, nebonaka. Tafi nafi, fi fawa, hano, nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hiti kame ya bata hikanamehibonaka, he noki rari. Hiti kosi hinehibonaka, ehene hiyarari. Hiti hibehibonaka, me one ya tabahari, yama hinofa me hiri ra mati\". ");
INSERT INTO jaa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","\"E ka owa ka yama aahi yama watohi ati kasawari ya kosi ni me hinafibonaka, hiti ati watohari. ");
INSERT INTO jaa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hahi yama watore ehene hiyare kosi ni me hinafirebonaka, hiti ati watorari. Teoso tiwa kakawi nafi ya Teoso kakawi tinafiabone tike bisa. Teoso tiwa kakawi nafihi kakawi fiya tinehibonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","\"Okehara oke, yama sari onahabone owa bofe ya. Sari okanene amake hibati ya. ");
INSERT INTO jaa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Batisa okibone. Oko batisa ni kerewe rabone onahara oke, kokoriri onaha owa. ");
INSERT INTO jaa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yama mowa ni fawa onihabone okehamone te ati na te awine? Keye amake. Oke ama oke, yama mowa ni yaro okanabone owa. ");
INSERT INTO jaa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yobe ka me 5 na me famaha me terei na me me mono naboneke. Yama we one ya aya me terei na afa me famaha me me mono nawahamahaboneke, me terei na mati. ");
INSERT INTO jaa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","E ka owa biti mono nebonaka. Manakobisa owa bati mono nebonaka. Fanawi bite mono naboneke. Manakobisa one mati mono naboneke. Fanawi hinaka koma mono naboneke. Manakobisa one hinakaso mono naboneke\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sesowi ati yana tasehimatamonaka ahi, me moto kawahamaha mera hiyarari, me tamaha mati. \"Bahi totoka ya neme sabi kakeha te awi ya te ati yana naba te amake. 'Faha kakehaba amake', te ati ni ya fara te ati ya faha kakehaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yama hiwe tohi ka ya boni kakeha te awi ya te ati yana naba te amake. 'Yama hiwawahaba amake', te ati ni ya fara te ati ya yama hiwawahaboneke. ");
INSERT INTO jaa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wami neme famaha te watoha yama amo ni te watoramone te ati nineke, keye te hiri na te\". ");
INSERT INTO jaa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","\"Yama oharia okominamake okibone. Owati fiya torahamone te ati nabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tiwehene hiyaramone e ka owa ati ne sowisi ni ya tiwa towakamebona ati ne aate tosi tinehibonaka. Yinero kote ta tinahabone tinahabone tike, tiwa towakamarabona karo sowisi ni ya. Sowisi ni ya tiwa towakame ya sowisi tiwa ta towitibonaka saotato ni ya. Manakobisa saotato tiwa ibehibonaka kateya ya. ");
INSERT INTO jaa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tasi toni tinofi ya yama manakone nafi tinahabihabone tike. Yama manakone nafi tinahabihari ya tasi tirahaba ama tike kateya ya. Keye amakere\". ");
INSERT INTO jaa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Me tamine me kaminemetemoneke Sesowi ni ya, Karireya ka mati, Birato me hinahabiha mati, bani me me ta na mati Teoso ni ya, bani me ame ya me ame kataba mati. ");
INSERT INTO jaa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sesowi mera hiyarematamonaka. \"Me ihi hiyari ka me ahabamone te ati na te awine? Me ihi hiyara fiya tonahamone te ati na te awine? Karireya ka me one ihi hiyara ihamamone te ati, na te awine? ");
INSERT INTO jaa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Keye amake. Fara me ahabi nima te ahabi tehaba te amake, te ehene hiyara te nofamari ya. ");
INSERT INTO jaa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yama te watoha te awineke, 18 me tohaha mera yobe nemehe kinehimatamonaha, tabora Sirowe ka yobe. Me ihi hiyara fiya tonahamone te ati na te awine? Serosarei ka me one ihi hiyara ihamamone te ati na te awine? ");
INSERT INTO jaa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Keye amake. Fara me ahabi nima te ahabi tehaba te amake, te ehene hiyara te nofamari ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sesowi hiyara hiwasia kaminematamonaka me ni ya. \"E ka owa ofa tamaha kihehimatamonaka. Ofa baikani fiko wehemetemoneke. Fiko boni bata nebona toke fiko boni wasirematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hinaka fatara ka yama kakakatoma narabo nima nematamonaka. 'Fiko ka tinahi. Faha fowe terei na ya fiko yobi okana boni owasitera amake. Yama bara ta koro nawahabanake fiko tabori ya'. ");
INSERT INTO jaa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Fatara ka yama kakakatoma ati yana nematamonaka. 'Hiba fiko hine wamatahabanake fa fowe oharimakia ya. Mate wi kani moto owahamahabanake, bowi yoti mata onahaba owa. ");
INSERT INTO jaa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Fa fowe one ya bonohaba awineke. Bonori ya ka tinahabanake', ati nematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sesowi mera kanawanehimatamonaka sabato ya sinakoka ya. ");
INSERT INTO jaa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Me ka one inamati ehene wai momowi nemetemoneke, wai yai nisararo. Hinaka fa fowe 18 nemetemoneke, wai momowi naro. ");
INSERT INTO jaa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sesowi hiwaha haha hinehemetemoneke. \"Kiki, fanawi Teoso tiwa kasomareka\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yehe kakibarehimatamonaka mese ya. Wamisa wai yai nisakabote nemetemoneke hibati ya. Faya Teoso kahiyarehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sinakoka ka hiti yawehimatamonaka, me ka one Sesowi kasome karo sabato ya. Sinakoka ka mera hiyarematamonaka. \"Yama e ahi te amake yama we 6 na ya. Afa yama we ya te kamakiaba teke, te kasomabone te. Te kakerabone teke sabato ya, te kasomaba te\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sesowi ati yana nematamonaka. \"Me te keyehineke. Te ka bani me te narifate te amake sabato ya, te ka bowi me toha, te ka someto mati. Te ka bani me te tisi ya me te towakaboneke faha me fawahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haha fanawi Abarao ka noti amake haro. Satanaisi wete hini ka hinaka fa fowe 10 na hinaka fa fowe 8 namakitasaharake. Amosa awineke e ka owa hitisaro sabato ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Me ati fawa kanehemetemoneke, Sesowi nonofa me amara mati, me nafi, Sesowi mera kasawari kari. Me one sinakoka ya me sawiha me yayai nemetemoneke yama amosa Sesowi hiri hinaha ihi. ");
INSERT INTO jaa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sesowi ati yana namatasehimatamonaka. \"Teoso ka towisawa kakehi sawi ya himata nima yama ribe? ");
INSERT INTO jaa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mositata noki nima yama naboneke, e ka owa koro hinaharo, fatara ya. Noki nafira yanaha awa tohaharake. Bani biti me winaharake ini ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sesowi hiyaratasehimatamonaka. \"Himata nima yama ribe? ");
INSERT INTO jaa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Fehemeto nima yama te amake, fehemeto fanawi hinatabaha nima, tiriko ya, tiriko fowamisarawaharo, nafi, tiriko nafiharo, 30 kiro tohaharo\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sesowi tokomematamonaka Serosarei ya. Mera kanawana tonamaitimatamonaka, sitati ka mati, tabora fotara ka mati. ");
INSERT INTO jaa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Me ka owa aate hinehimatamonaka. \"Sesowi me tamara me kasomatehaba me ama?\" ati nematamonaka. Sesowi ati yana nematamonaka, mera hiyarari. ");
INSERT INTO jaa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"Yama amosa tamaha te hiri nabone teke, te tokiyomahabone te, nokobi babati na ya. Me tamaha me tokiyomahabone me ati ni ya yama nihinaraboneke. ");
INSERT INTO jaa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yobe hiti waremise nokobi boko nawahamehibonaka. Nokobi bari ya te nahoha nokobi te teo ni ya te ati e naba teke ahi: 'Ota tokiyomahabone otake', te ati naba teke. Ati e nebonaka ahi: 'Tera owatera ama oke. Hibaka ya te kakehani te amari?' ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'E tabaha e tafa, ota taboro ka ota ka one me tikanawana, tite ama tike', te ati nabone teke. ");
INSERT INTO jaa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ati yana namehibonaka tasa. 'Tera owatera ama oke. Te taboro owarihi ote ama oke. Te tokomahi, yama hiyara hihiri me te, te nafi', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Me te awahabone teke, Abarao, Isaki, Yako, Teoso ati kakamina mati, me na mati, Teoso ka towisawa ya me tabaha mati. Tera me were towitiaba te amake, ha te ta. Te ohi naba te amake. Te ino yiki tokanaba te amake. ");
INSERT INTO jaa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Me te awahaba te amake yama nafi ka mati, me tafa mati, Teoso ka towisawa ya me taba mati. Bahi kakamaki ka me kake, bahi totoka ka me kake, yama enoki ka me kake, kowani ka me kake, naba me amake. ");
INSERT INTO jaa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Me tai toakia me toyotowahama haha me yotomakeha me tai toawamaboneke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sesowi hiyare ni ya fariseo me kakehemetemoneke he ni ya. Me ati yana nemetemoneke. \"Tikamahi ahi. Eroti tiwa nabowehibona ati nareka\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","\"Eroti riao tohare kawara tohe awaka. Eroti ni ya te tokomi ya te ati e niya ahi he ni ya: 'Haha yama wehe ya yama wamini ya me inamati oyosema, me kiya na me okasoma, onahabana oke. Yama wamini nowati ya hawa ohahabana oke', te ati nabone teke he ni ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","\"Yaka onahabone oke, haha yama wehe ya. Yaka onamina, onahabone oke, yama wamini ya. Yama wamini nowati ka yama ya kobo onahabone oke Serosarei ya. Kobo onahabone ama oke Serosarei ya. Teoso ati kakamina me nafi ahabemetemoneke Serosarei ya. Ohababisabone oke Serosarei ya, Teoso ati kakamina ohi karo\". ");
INSERT INTO jaa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","\"Serosarei, Serosarei. Teoso ati kakamina me te waka teha te amake. Te ni ya Teoso mera yosehi me te waka, teha me amake, yati ibe ya me te banaha mati. Tera okasomabone ote ama oke. Arakawa fana nima onahabone onahara oke, biti mera kasomaro he bofe ya, biti mera bari kanaharo. Tera okasomahabone onaha owa ni ya te ati hiyakere. ");
INSERT INTO jaa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Owati te mitahi. Teoso tera kakosehibonaka. Owati e nara oke ahi: Owa te awamarahaba te amake mata. Manakobisa owa te awamatasatehaba te amake, te ati e ni ya ahi: 'Kakehareka Teoso ati ehene. Teoso hinofa hika', te ati tehaba teke\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabato one ya Sesowi tokiyomehimatamonaka fariseo me ka hiti owa ka yobe ya, hikatafehibonaha. Me one kakatoma nawi hinehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Me ka owa yama kome kihehi nafi fowehi itarimatamonaka Sesowi nokosi ya. ");
INSERT INTO jaa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sesowi fariseo mera aate nematamonaka, Teoso ka yama hani wawato me ya me tabaha mati. \"Sabato ya e ka owa e nakitamaha yama hiyara e hiri tehani ama?\" ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Me ati yana remetemoneke. Sesowi me ka owa wara tone hikasomehi hiyosemematamonaka, tokomebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sesowi ati yana namatasehimatamonaka. \"Hoti ya tikatao sone ya sabato ya himata hiri tiribe? Hoti ya tika bowi sone ya himata hiri tiribe? Titimakehiba awaka sabato ya\", ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Me atibone me watoremetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sesowi mera awehimatamonaka, me sawiha mati marina ya, nahori me nofaha mati ayaka hiti itari beheri ya. Faya hiyara kaminematamonaka hiwasiaro. ");
INSERT INTO jaa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","\"E ka owa tera ha ne ya te sawi ya ayakabone ya tiwitaribarabone tike ayaka hiti beheri ya. Ayaka hiti beheri ya tiwaribai ya ati e neba awaka ahi tiwa ni ya, hahi owa amose ha hine, sawihibonaha ayaka ya. Yana tinahi, hahi taborobona amaka, ati nebonaka. Tiwitaremabone tike hike ya, kokoma tina tiwa. ");
INSERT INTO jaa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kobo tinamaki ya ayaka ya towitareba tinahabone tike. Ayaka hiti tiwa awe ya kamakibonaka tiwa ni ya, ati yana nebonaha. 'Habai tiwitarehabone tike ahi obeheri ya', ati nebonaka. Haha ayaka ka me nafi titaminahamone me ati naboneke. ");
INSERT INTO jaa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tiwa tikahiyari ya tihiyaramone me ati naboneke. Tihiyaramone tini ya tiwa me kahiyarabone tike\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sesowi ayaka hiti hiyara, nematamonaka. \"Ayaka hiri tiba ya tika habai me ha tirihi, niso me ha tirihi, te one me ha tirihi, te taboro ka me honaha me ha tirihi, tinahabone tike. Me ha tini ya tiwa me ha nabisaboneke, me ha ni manakone. ");
INSERT INTO jaa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ayaka hiri tiba ya me honara me ha, me yaka ni yokana tohara me ha, me tame kotete na me ha, me noki awara me ha, tinahabone tike. ");
INSERT INTO jaa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Teoso tiwa nofehibona tike, tiwa me kanamakorabone tiwa. Teoso tiwa kakawatebonaka, e amosa ahaba yati tohawami ya\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Me ka owa marina ya sawihi Sesowi ati mite ati yana nematamonaka. \"Teoso ka towisawa kake ya he ya me taba me tafa me yayai naboneke\". ");
INSERT INTO jaa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sesowi ati e nematamonaka ahi he ni ya: \"E ka owa marina webote hiri nebona me tamaha mera ha nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Marina yana nibone ka bahi ya hinaka yama aahi yosehimatamonaka mera ha nebonaha, me ha hina mati. 'Hima, marina hawa tohake', ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tokomaki me nofaremetemoneke me nafi. Me ka owa ohari ati yana nematamonaka. 'Yobe taborobona okanikahara oke. Owahabone onaharake. Tika hiti yawarebonaka', ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Owa ati e nematamonaka ahi: 'Bowi me 10 okanikahara oke. Me owahabone onahara oke. Tika hiti yawarebonaka', ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Owa ati e nematamonaka ahi: 'Ofanara oke. Tokomaki onofa okere'\". ");
INSERT INTO jaa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","\"Ayaka hiti ka yama aahi wete name me ati kaminamematamonaka. Ayaka hiti yawehi ati yana nematamonaka. 'Tokomakabote tinahi howa ya, sitati ka howa. Me honara me tekamiyahi ahi. Me yaka ni yokana tohara me toha, me noki awara mati, me tame kotete na mati, me na tekama tinahi, me sawihaba mati ayaka ya', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","\"Hinaka yama aahi tokomatase wete name 'Tiwati nima onahara oke. Yama hasi nasa ke', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","\"Ayaka hiti ati yana namatasematamonaka. 'Tikamatasahi sitati beheri ka me ha tinamibeya, oko yobe mo kabaya. ");
INSERT INTO jaa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aya me ha oniba marina tafe me kabaraboneke me nafi', ati nematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sesowi yana tone toke yaka nematamonaka, me tamaha me ya tabahari. Sesowi nokowame mera hiyarematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"E ka owa owa ni ya kamaki owa ya famehibona ati ne bati mera nofamarebonaka. Fati toha, biti me toha, nisori me toha, hinakasimarawaha, na mera nofamarihi, nebonaka. Hiwa nofamarihi, nebonaka. Ehene e re ya owa ya famarebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","E fami tinofi ya tiwehene e nabone tike ahi: tika ewenebone tiwa tikanabone tike, owa tinofi ka yama nawaha hiri tinahabone tinakomehara tiwa. Tisawi tinahabone tike owa ni ya fara oko toki nima. Tiwehene e ri ya e famarabone eke\". ");
INSERT INTO jaa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","\"E ka owa yobe nafihi hiri nebona itaribonaka, ati boti yama nima nari. 'Himata nima yati manakone na awineriya, yobebonaha? Oko yinero nafihi awane?' ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ehene e re ya yobe hawa toniharehibonaka. Yobe bofe ka hiri nibe ya hinaka yinero tofiyoba amaka. Me one hiwe ya me haha hikaneba amaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Hari yobe hiri ni yana kane yobe hawa toniharahareka', me ati naboneke\". ");
INSERT INTO jaa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","\"Towisawa towisawa owa mono nebona itaribonaka, ati boti yama nima nebonaha. 'Owa ka saotato me kakeha 20.000 me tohake. Oko saotato 10.000 me tohake. Oko saotato me okahabani ya oko saotato me me hikasawariaba me amani?' ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mono ni nofare ya he nanarifa mera yosehibonaka, towisawa owa ni ya, tohasa nari hike ya, he nanarifa me ati e nabone mati ahi: 'Ota ka towisawa yinero ta nebonaka, mono tirebonaha', me ati naboneke. ");
INSERT INTO jaa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te e nineke ahi, ha me nima. Te ka yama te nofi ya e tabaterabone eke\". ");
INSERT INTO jaa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","\"Saha amosate amake. Saha sinari watamari ya himata nima e ribe, saha sinari kamiba karo? ");
INSERT INTO jaa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Saha hiyakere haro, sinari watamaraharo. Sika towitiaboneke. Te narabo naha owati te mitahi\". ");
INSERT INTO jaa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yama hiyara hihiri me tamaha me kakehemetemoneke Sesowi ni ya, he ati me kamitabone mati. Yinero wawarara me toha, nemetemoneke, kofeno nanarifa mati. ");
INSERT INTO jaa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mowisei ati kakamina me ya fariseo me tabaha me me hora hinehemetemoneke. \"Yama hiyara hihiri mera nofaka, mera katafari\", me ati nemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sesowi hiyara kaminematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"E ka owa ka ofeya 100 me tohaha hinaka ofeya ohari fawa ne ehene e neba awaka ahi. Ofeya 99 me tohaha mera kakanakosebonaka kabina ya. Hahi ofeya fawa ne siba nebonaka, hiwasibonaha. ");
INSERT INTO jaa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hiwasi ya yayai nebonaka. Faya tiwa hinehibonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kobo name ya me one ha nebonaka. 'Hima e yayai nabone eke. Aya ofeya fawa ne owasiara oke', ati nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yama e naboneke ahi neme ka yama. E ka owa ohari yama hiyara hihiri tohe ehene nofamare ya me yayai naboneke neme ka mati. 99 me tohaha me ihi me yayai ni yokana toharaboneke, me ihi hiyaraba watara mati\". ");
INSERT INTO jaa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","\"E ka one hinaka moweta barata tohehi 10 ne ohari fawa ne himata nima ihi ribe? Nabarina sari kani ya yama yowi naboneke yobe toro ya, moweta siba naro. Siba ni fawa hirehibonaka, hiwasibonaha. ");
INSERT INTO jaa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hiwasi ya me one ha naboneke, me winaha mati ayata ya. Ati e naboneke ahi: 'Hima e yayai nibeya. Oko moweta fawa ne owasiara oke', ati naboneke. ");
INSERT INTO jaa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Neme ka yama e nineke ahi. E ka owa ohari yama hiyara hihiri ehene nofamare ya Teoso nanarifa me yayai teha me amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sesowi ati yana namatasehimatamonaka. \"E ka owa biti me famehemetemoneke. ");
INSERT INTO jaa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Biti yoto ke aate hinehimatamonaka. 'Abi tika yinero kote ohahabone onahara oke hibati ya, tihabamatara tiwa'. Faya yinero kote kane biti kakawematamonaka, yinero kote ya. ");
INSERT INTO jaa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Biti yoto ke hinaka yama nafi ta nematamonaka, yinero manakonebonaha. Amo ni totamakosare ya yana tone tokehimatamonaka yama yabo ya. Hinaka yinero nafi tonafiyobote nematamonaka fahi\". ");
INSERT INTO jaa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","\"Hinaka yinero tonafiyo nowati ya faha kakemarehemetemoneke. Makoni yama kabaha tofiyoemetemoneke. Faya fimihimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yama ahi ni yana tonehimatamonaka, bare taboro ya. Faya hiyosematamonaka boroko mera towakebonaha me tafahabone mati. ");
INSERT INTO jaa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Awa boni kabinima nematamonaka boroko me hikabaro, me hinatafare karo. ");
INSERT INTO jaa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Taboro wati nawahematamonaka. 'Okobi nanarifa me tafe nanafi nama na me awineke. Ha owa ahabinima one oke fimi ihi. ");
INSERT INTO jaa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yana onahabana oke okomaba owa okobi ni ya. Owati e nabana oke ahi he ni ya: \"Abi owehene hiyarara oke Teoso ni ya. Owehene hiyarihi nara oke tiwa ni ya. ");
INSERT INTO jaa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Owa okatao tinamarahabana tike, owehene hiyara owa. Hine tiwa onarifabana oke, tiwa nanarifaba owa\", onahabana oke', ati boti ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","\"Yana tone tokomematamonaka bati ni ya. Hike ya kamasa ne ya bati hiwehimatamonaka. Bati aawawa hine ka bati kana ni tokehimatamonaka. Kobo hine hitiri hine hikarabatematamonaka, noko komi hinakihari\". ");
INSERT INTO jaa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","\"Ati yana nematamonaka. 'Abi owehene hiyarara oke Teoso ni ya. Owehene hiyarihi, nara oke tiwa ni ya. Owa okatao tinamarahabana tike, owehene hiyara owa'\". ");
INSERT INTO jaa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","\"Faya hinaka yama aahi mera yosehimatamonaka. 'Makari amosi mati tohaha te tonakamahi, te weyeye nibaya. Hinaka aneoba te tonakama nahi, yehe kabana. Hinaka satayabana, he teme kabana. Hibati ya! ");
INSERT INTO jaa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bowi biti te kakama nahi, te naimi nofahari, te nabowehibana. Hima e ayakibeya, e yayai na e. ");
INSERT INTO jaa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hahi okatao ahabe yati tohawamaka. Tosawarihi owasiwahama oka', ati nematamonaka. Faya ayaka yana tonemetemoneke\". ");
INSERT INTO jaa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","\"Biti taiti kamehimatamonaka tokahari fatara ya. Yobe wari yabomare ya yaka name me ayaki mitehimatamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bati nanarifa ha nematamonaka, aate hinehibonaha, yama mitahari. ");
INSERT INTO jaa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Niso sawimaka hari, kobo namahari. Abi bowi biti nabowahareka, watakari, biti kobo name kari, amosari', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","\"Yawamise tokiyomami nofarematamonaka. Bati kiyomame hiyosemematamonaka tokiyomamebonaha. ");
INSERT INTO jaa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tokiyomami nofarematamonaka. 'Owati timitamata. Faha fowe tamaha ya yama ahi ote ama oke, tiwa onarifa owa. Fara tiwati nima owehene te ama oke, owa tiyoseha tiwa. Owa tekawatera ama tike, kabara yetene ya, ayaka hiri oba karo, ota one me ya otaba owa. ");
INSERT INTO jaa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hahi tikatao kobo namaka hari, tika yinero nafi tonafiyohari, me fanawi ahi ni ihi. Kobo namehi hinaka bowi biti watakebona tinabowine tike', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","\"Bati ati yana namatasematamonaka. 'Okatao tisawi tike owa ni ya. Oko yama nafi tika yama amake. ");
INSERT INTO jaa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ayaka ota hiri na ota yayai nineke, niso ahabe yati tohawame karo. Tosawarihi e wasiwamaka', ati nematamonaka\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sesowi he ya tataba mera hiyaramatasehimatamonaka. \"E ka owa honehi tesene nehimatamonaka hinaka yama kakakatoma toahari. Ehene me one hikaminehimatamonaka hinaka bataro ka yama kakatomi forima remonaha. Bataro ka yama tofiyoamone me ati nemetemoneke ehene\". ");
INSERT INTO jaa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","\"Bataro ha hinehimatamonaka. 'Tiwehene hiyi nofaramone me ati narake. Yama hani tinamoabana tike, owa ni ya, yama hani tiwehene kaminaro, oko yama tekatoma tiwa. Oko yama tekatomamarabana tike oko yama', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","\"Faya he nanarifa ati boti yama nima nematamonaka. 'Bataro owa toyosemehiba awaka, onarifamarehibana. Himata hiri oribe waha? Himata okobaribe? Fatara ka yama ahi ni owato okere, oko yinerobana, okitamari karo. Yamata niki onofa okere me ka yamata. ");
INSERT INTO jaa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Owehene e nabana oke ahi: oko bataro ka ferekesi me okasomahabana oke, onarifasa one ya mata. Yama totoyabo ni ya onarifamare ya owa me kasomaba me amake bisa', ati boti ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","\"Faya ferekesi bataro me tefe na mera ha nematamonaka, me oohariki na mati. Tai tohaki ra hiyarematamonaka. 'Tika yama tefe tinaha manakone e na awineri oko bataro ni ya?' ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Boti 100 kanaha tefe oke, orifa yehe', ati nematamonaka. 'Boti 50 kanaha ta tinamibote tini ya haha boti 50 kanaha manakone watamarabanake. Yama hani tama okine oke haro, tika yama tefe tinaha hani. Tiwati hani tikanawanahi, boti 50 kanaha ta tinamibote tinahabone tina tiwa', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","\"Owa ra hiyaratasehimatamonaka. 'Tika yama manakone e ri, ha tiwa, oko bataro tefe tini karo?' ati nematamonaka. 'Tiriko miti kani 100 tohaha tefe oke', ati nematamonaka. 'Tika yama hani nineke haro. Tiwati hani tikanawanahi, tiriko miti kani 80 na ta tinamibote tinahabone tina tiwa', ati nematamonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","\"Bataro nanarifa ehene hiyare bataro hora hirehimatamonaka. Yama watohimona hikahiyarematamonaka. Bofe ka me tohaha yama me watote me amake, me one me kasoma mati. Haha Teoso ka yama oye ka me ta yama me watotera me amake\". ");
INSERT INTO jaa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","\"Owati te mitahi. Tika yinero hiyare tinafiyohabone tike, te one tiwa me kasomibone karo. Manakobisa tika yinero watamare ya tiwa me ha naba me amake, me ya titababone tiwa yobe amose ya, ahabaterebana. ");
INSERT INTO jaa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hahi yama bite kakatomi watohi yama nafiha kakatomi watohibonaka. Hahi yama bite kakatomi watore yama nafiha kakatomi watorihi nebonaka. ");
INSERT INTO jaa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bofe ka yinero hiyare kakatomi tiwatori ya hibake tiwa kakaweba ama tiri yinero yokana ya, neme ka yinero? ");
INSERT INTO jaa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Me ka yama kakatomi tiwatori ya, hibake tiwa kakaweba ama tiri, tika yama yokanaba ya? ");
INSERT INTO jaa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","E ka hiti meba me famihinakere, me e narifikimaba mati. Owa e nofe ya hahi e nofamarehibonaka hari. Ha ita e nofe ya hahi e nofamarehibonaka hari. Yinero noko e toniha Teoso e nofatera e amake\", Sesowi ati nematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo ati me hikamitehimatamonaka haha yama nafi kamine ati. Me haha hikanematamonaka, yinero me nofi karo kasiro ya. ");
INSERT INTO jaa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sesowi mera hiyarematamonaka. \"Te ehene me awaha te amosamone me ati nabone te ati na te ati boti hiyara Teoso watoka. Te ehene amosamone tera me kahiyara te ehene Teoso nofakara, te hiri naro\". ");
INSERT INTO jaa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","\"Hibati ka Mowisei ati me watohemetemoneke. Teoso ati kakamina me ati me wato, nemetemoneke, Yowao watamatare ya mata. Yowao hiyara amosa kamini tai tohibehimatamonaka, Teoso ka towisawa kaminari. Faya me nafi ota ha nineke, waha, Teoso ka towisawa ya me tabahabone mati\". ");
INSERT INTO jaa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","\"Neme ya wami famaha ahabi ya Mowisei ati ta ahabatereba amaka, yama hani karo, ati nafi nafi. ");
INSERT INTO jaa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tika yibote tekanakosa fanawi bara titiwai ya yama hiyara hiri tinahabone tike. Tika yibote tekanakosaha bare hitiwai ya ehene hiyarebonaka\". ");
INSERT INTO jaa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","\"E ka owa honehi okominahabone onahara oke, makari amosa aki nofahari manakone nafiharo. Ayaka hiri ni fawa rematamonaka. ");
INSERT INTO jaa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hinaka yobe ka nokobi beheri ya Rasaro fofore tohehimatamonaka, me hekamahari, honarari, m