﻿USE sofia;
DROP TABLE IF EXISTS sofia.izz_vpl;
CREATE TABLE izz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES izz_vpl WRITE;
INSERT INTO izz_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Lẹ mbụlembu bẹ Chileke meru igwe bya emee eliphe. ");
INSERT INTO izz_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ọphu eliphe enwedu ụgbugba; ọphu ọ dụdu iphe, nọ iya nụ. Ọ bụerupho mini echiphe l'ẹkameka; tẹme eli mini ono nọdu agbakọta ọchii. Unme Chileke nọdu erwuphe l'eli mini ono kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ọo ya bụ; Chileke sụ: “Gìphóró dụ.” Ìphóró bya adụ. ");
INSERT INTO izz_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Chileke bya elee ẹnya hụma l'ìphóró ono dụ ree. Ọ bya edokaha ìphóró ono yẹe ọchii. ");
INSERT INTO izz_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Chileke bya agụa ìphóró ono “eswe”; bya agụa ọchii ono “ẹnyashi”. Nchi jihu bya abọhu. Ono bụru mbọku kẹ mbụ. ");
INSERT INTO izz_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ọo ya bụ; Chileke sụ: “G'ìphè nọdu l'echilabọ mini; nọ-buha mini ono ẹbo.” ");
INSERT INTO izz_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tọbudu iya bụ; Chileke bya emee ìphè dobe; ọ nọ-buha mini ọphu nọ l'imeli yẹe ọphu nọ l'alị ẹbo. Ọ dụ g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Chileke woru ìphè ono gụa “akpaminigwe”. Nchi jihu bya abọhu. Ono bụru mbọku k'ẹbo. ");
INSERT INTO izz_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Chileke sụ: “Gẹ mini ọphu nọ lẹ mkpula akpaminigwe nọkobe l'ẹkalanu; g'ẹka kpọhuru nkụ gbafụta ìphè.” Ọ dụ g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Chileke gụa ẹka ono, kpọhuru nkụ ono “alị”; bya agụa mini phọ “eze-ẹnyimu”. Chileke bya elee ya ẹnya bya ahụma l'ọ dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Chileke sụ: “G'alị fushia iphe, dzụ ndzụ: iphe, amị mebyi; yẹe oshi-ọmi g'ọphu nọnu fushigbaa g'ọ dụ l'ụgbugba nkiya.” Ọ dụ g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Alị bya efushia iphe, dzụ ndzụ; ẹphe bya amịshia mebyi; ọphu nọnu nọdu amịshigbaa g'ọ dụ l'ụgbugba nkiya. Chileke bya elee ya ẹnya bya ahụma l'ọ dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nchi jihu bya abọhu. Ono bụru mbọku k'ẹto. ");
INSERT INTO izz_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Chileke sụ: “G'iphe, echí echíchí dụ l'akpaminigwe g'o dokahajẹ eswe yẹe ẹnyashi. Tẹme ẹphe egoshije teke bụ ògè iphe; waa mbọku; waa teke bụ apha agbaru. ");
INSERT INTO izz_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Tẹme g'iphe ono, echí echíchí ono, dụ l'akpaminigwe ono chije lẹ mgboko.” Ọ dụ g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Chileke bya emee iphe, echí echíchí labọ, parụ ẹka apaa. Ọphu ka shii bẹ o meru g'o chije l'eswe; ọphu ka alwa alị bẹ o meru g'o chije l'ẹnyashi. Ọ bya emefụkwapho kpokpode. ");
INSERT INTO izz_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Chileke bya eworu phẹ dobe l'akpaminigwe g'ẹphe mee g'ìphóró dụ lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","G'ẹphe chije l'eswe yẹe ẹnyashi; tẹme waa g'ẹphe dokaha ìphóró yẹe ọchii. Chileke bya elee ya ẹnya bya ahụma l'ọ dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nchi jihu bya abọhu. Ono bụru mbọku k'ẹno. ");
INSERT INTO izz_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Chileke bya asụ: “Gẹ mini kpofuta anụ, dụ igwerigwe g'o buru lẹ mini; ẹnu awata ephe l'eliphe lẹ mkpula akpaminigwe.” ");
INSERT INTO izz_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ọo ya bụ; Chileke mee eze anụ, bugbaa l'eze-ẹnyimu; mẹkpoo iphe, dzụ ndzụ, awụ awụwu; o buru lẹ mini l'ụdu iya l'ụdu iya; waa ẹnu, ephe l'eli g'ẹphe ha; ọphu nọnu l'ụgbugba nkiya. Chileke bya ahụma l'iphemiphe ono dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Noo ya; Chileke bya agọru ọnu-ọma nụ phẹ; sụ: “Unu zụ̀a azụ̀zù zụ-jia mini, nọgbaa l'eze-ẹnyimu; ẹnu azụa ji mgboko ejiji.” ");
INSERT INTO izz_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nchi jihu bya abọhu. Ono bụru mbọku k'ise. ");
INSERT INTO izz_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Chileke bya asụ: “G'eliphe kpofuta iphe, dzụgbaa ndzụ l'ụdu iya l'ụdu iya. G'anụ, bụ iphe-edobe kpofuta; waa anụ ọphu awụ l'ẹpho; waa anụ, bu l'ẹgbudu. G'ọphu nọnu kpofutagbaa l'ụgbugba nkiya.” Ọ dụ g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Chileke mee anụ, bu l'ẹgbudu l'ụdu iya l'ụdu iya; mẹ anụ, bụ iphe-edobe l'ụdu nkiya; mekwaphọ anụ ọphu awụ l'ẹpho l'ụdu nkiya kwaphọ. Chileke bya elee ya ẹnya bya ahụma l'ọ dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tọbudu iya bụ; Chileke sụ: “G'anyi bya emee nemadzụ g'o yee anyi; mbụ g'ọ dụ g'anyi dụ. G'ọ bụru onye-ishi; g'ẹma, nọ l'eze-ẹnyimu; yẹe ẹnu, ephe l'eli; yẹe anụ, bụ iphe-edobe; yẹe eliphe l'ophu; waa iphe, bụkpoo anụ, akpụ wuruwuru l'alị nọdu iya l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ọo ya bụ; Chileke woru nemadzụ mee; o yee ya; ọ bụru gẹ Chileke dụ bụ g'o meru iya; ọ dụ. Ọ bụru nwoke lẹ nwanyị bẹ o meru. ");
INSERT INTO izz_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Chileke bya agọru ọnu-ọma nụ phẹ; sụ phẹ: “Unu zụ̀a azụ̀zù kabaa shii; unu zụ̀-jia mgboko kapyabẹ iya ẹnya. Unu abụru ishi: ẹma, bu lẹ mini; yẹe ẹnu, ephe l'eli; yẹe iphemiphe, bụ iphe, dzụ ndzụ, akpụ wuruwuru l'alị anọdu unu l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Noo ya; Chileke sụ: “Iphe, bụ iphe, aakọ̀ akọ̀kò lẹ mgboko; waa iphe, bụ oshi, amị amịmi l'ophu bẹ mu nụkotaru unu g'unu rije; g'ọ bụru unu nri. ");
INSERT INTO izz_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Anụ, nọkota lẹ mgboko-a; waa ẹnu, ephekọta l'eli; mẹkpoo iphemiphe, awụkota l'ẹpho; mbụ iphemiphe, dzụ ndzụ g'ẹphe ha bẹ mu nụkotaru irwu ẹswa g'ọ bụru nri phẹ.” Iphemiphe dụkota g'o pfuru. ");
INSERT INTO izz_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Chileke bya elee ẹnya hụma iphemiphe, o meru. Ẹphe dụebekota rengurengu shii. Nchi jihu bya abọhu. Ono bụru mbọku k'ishii. ");
INSERT INTO izz_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Noo g'e gude mee igwe; yẹe eliphe; mẹ iphemiphe, nọ iya nụ. ");
INSERT INTO izz_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tọbudu iya bụ; o betashia lẹ mbọku k'ẹsaa; Chileke jeẹbekotawaa ozi ono, o shi eje ono. Ọ bụru lẹ mbọku k'ẹsaa ono bẹ ọ tụtaru unme ozi, o jekọtaru. ");
INSERT INTO izz_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Chileke gọru ọnu-ọma nụ mbọku k'ẹsaa ono; bya emee ya; ọ dụ nsọ; kẹle ọo mbọku ono bẹ ọ tụtaru unme eme iphemiphe, o meshiru ono. ");
INSERT INTO izz_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Waa g'e gude mee igwe; yẹe eliphe; teke e meru iya baa. Teke Chipfu, bụ Chileke meru eliphe; yẹe igwe bẹ ");
INSERT INTO izz_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","o to nwedu iphe, aakọ̀ akọ̀kò shiwaa dụ l'alị; ọphu ọ dụdu irwu, erwuje l'ẹgu ọphu kpọ-futawaru nụ; noo kẹle Chipfu, bụ Chileke te eshidu mewaa g'igwe dzeje mini l'eliphe. Tẹme ọphu o toko nweduru onye a-kọje alị. ");
INSERT INTO izz_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ọ bụru iji bẹ o shi anọduje akwa gude agba alị l'ophu mini. ");
INSERT INTO izz_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ọo ya bụ; Chipfu, bụ Chileke bya egude ẹja, shi l'alị kpụa nemadzụ; bya ekuru unme ndzụ ye iya l'imi; onye ono bya abụru onye dzụ ndzụ. ");
INSERT INTO izz_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Chipfu, bụ Chileke bya eworu mgbabu gbaa l'ụzo ẹnyanwu-awawa lẹ Édẹnu; bya eworu nemadzụ-a, o meru-a dobe l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Chipfu, bụ Chileke mee g'oshi, dụlaje iche iche fushia l'alị ono. Oshi, dụ ree ele ẹnya; bya atsọ ụtso eriri. Ọ bụru l'echi mgbabu ono bẹ oshi, emeje g'a nọdu ndzụ nọ; waa oshi, emeje g'a maru iphe, dụ ree; yẹe ẹjo-iphe. ");
INSERT INTO izz_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ọ bụru l'alị Édẹnu bẹ nggele, agba mini lẹ mgbabu ono shi asọshi. Nggele ono bya agbaa ẹno lẹ mgbabu ono. ");
INSERT INTO izz_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ẹpha nggele kẹ mbụ bu Pishọnu; o shijaru echilabọ alị Havila l'ophu; ẹka mkpọla-ododo nọ. ");
INSERT INTO izz_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mkpọla-ododo, nọ l'alị ono dụ ree. Etse, eshi mkpọ, bụ iya bụ bedelọmu nọdu iya; tẹme mkpuma, aswa dụ, bụ ónìkùsù nọdukwa iya phọ. ");
INSERT INTO izz_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ẹpha nggele k'ẹbo bụ Gihọnu. O shijaru echilabọ alị Kushi l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ẹpha nggele k'ẹto bụ Tigirisu; yẹbedua sọru shia ụzo ẹnyanwu-awawa l'ibiya kẹ Asiriya. Ẹpha nggele k'ẹno bụru Yufurétisu. ");
INSERT INTO izz_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Chipfu, bụ Chileke bya eduta onye ono je edobe lẹ mgbabu Édẹnu g'o jeje iya ozi letajẹ iya ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","No iya; Chipfu, bụ Chileke bya atụaru nemadzụ ekemu sụ ya: “Rijekwa akpụru oshi, nọkota lẹ mgbabu-a m'ọ dụ ngu ree; ");
INSERT INTO izz_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ọle nanụ ọphu i tii rijedu bụ oshi ono, emeje g'a maru iphe, dụ ree yẹe ẹjo-iphe; kẹle mbọku, i riru iya bẹ ịi-nwụhukwa.” ");
INSERT INTO izz_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Noo ya; Chipfu, bụ Chileke sụ: “Ọ tọ dụkwa ree gẹ nwoke ono nọdu nwẹkinyi iya. Mu e-metaru iya onye n-yemẹka, gbaru iya nụ.” ");
INSERT INTO izz_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ọo ya bụ; Chipfu, bụ Chileke gudechaa ẹja, shi l'alị mee anụ; waa ẹnu, ephe l'eli bya achịtaru iya Ádamu gẹ ya maru iphe ọo-gụshi phẹ. Ọ bụru iphe, Ádamu kuru iphemiphe ono, dzụ ndzụ ono bẹ ẹphe watarụ azaza. ");
INSERT INTO izz_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ọo ya bụ; Ádamu bya eworu ẹpha gụshia iphe-edobe l'ophu; mẹ ẹnu, ephe l'eli; mẹ anụ-ẹgbudu g'ọ ha. Obenu lẹ Ádamu te enwedu onye n-yemẹka, gbaru iya nụ, a chọ-vuru iya. ");
INSERT INTO izz_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ọo ya bụ Chipfu, bụ Chileke bya emee oke mgbẹnya tụ Ádamu. Ọ nọdu eku mgbẹnya ono; ọ bya ahata iya ọkpu-ẹgara; bya egude anụ-ẹhu rwachita iya. ");
INSERT INTO izz_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tọbudu iya bụ; Chipfu, bụ Chileke bya egude ẹgara ono, ọ hatarụ l'ẹhu nwoke ono mee nwanyị; bya edutaru iya nwoke ono. ");
INSERT INTO izz_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nwoke ono sụ: “Onye ọwa-a bụ ọkpu ọphu shi l'ọkpu mu; bya abụru ogwẹhu, shi l'ogwẹhu mu. Iphe, ee-ku iya bụ ‘nwanyị’; noo kẹle e shi l'ẹhu nwoke wofuta iya.” ");
INSERT INTO izz_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Noo iphe, meru g'o gude nwoke je l'ahajẹ nna iya; haa ne iya; ẹphe lẹ nyee ya atụgba; bụru ogwẹhu lanụ. ");
INSERT INTO izz_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nwoke ono yẹe nyee ya ono tụko gbaru ọto; ọphu iphere adụdu phẹ. ");
INSERT INTO izz_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Agwọ bụ anụ, shi kakọta ẹregede l'anụ-ẹgbudu, Chipfu, bụ Chileke meshiru l'ophu. Noo ya; ọ sụ nwanyị ono: “Chileke ?ọ sụkpooru g'ọ tọ dụshi akpụru oshi, nọ lẹ mgbabu-a, unu e-rije tọo?” ");
INSERT INTO izz_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nwanyị ono sụ agwọ ono: “Anyi e-rijekwa-a akpụru, shi l'oshi, nọgbaa lẹ mgbabu-a. ");
INSERT INTO izz_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ọ kwa akpụru oshi ọphu nọ l'echi mgbabu bẹ Chileke sụru g'anyi te erishi; mbụ g'anyi te emekwa iya ẹka ememe ophu; l'anyi -denyi iya ẹka bẹ anyi a-nwụhukwa.” ");
INSERT INTO izz_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Agwọ ọbu sụ nwanyị ono: “Ọ tọ dụkwa anwụhu, unu anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ọ chịa lẹ Chileke maru lẹ unu -ria ya; ẹnya asahụ unu; unu adụ gẹ Chileke; maru iphe, dụ ree waa ẹjo-iphe.” ");
INSERT INTO izz_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nwanyị ono bya elee ẹnya l'akpụru oshi ono; bya ahụma l'ọ dụ ree k'eriri; bya amakwaphọ mma ele ẹnya; tẹme ọ nọdu agụkwa iya phọ ẹgu g'o ria akpụru oshi ono maru iphe. Ọ wọta iya ria bya anụkwapho ji iya, ẹphe l'iya tụko nọdu l'ẹka ono; o rikwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ẹnya tụko sahụchaa ẹphenebo; ẹphe maru l'ẹphe gba ọto. Ẹphe dzụkobe ẹkwo oshi fịgu nmarụ. ");
INSERT INTO izz_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ẹphe nụma ụkporo Chipfu, bụ Chileke lẹ g'oojephe lẹ mgbabu ono lẹ gẹ phẹrephere ụzenyashi ezi; ẹphe je eworu onwophẹ woharụ Chipfu, bụ Chileke l'azụ oshi, nọgbaa lẹ mgbabu ono. ");
INSERT INTO izz_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Chipfu, bụ Chileke bya ekua Ádamu; sụ iya: “?Bụ awe bẹ ị nọ?” ");
INSERT INTO izz_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ádamu sụ iya: “Mu nụmakwaru ụkporo ngu lẹ mgbabu ono; mu je eworu onwomu domia l'ẹka ndzụ agụ mu; kẹle mu gba ọto.” ");
INSERT INTO izz_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ọ sụ iya: “?Bụ onye sụru ngu l'ị gba ọto? ?Ti riakwaru nụ akpụru oshi-a, mu sụru g'i ti rishi-a?” ");
INSERT INTO izz_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ádamu sụ iya: “Ọ kwa nwanyị-a, i doberu mu l'iya l'ẹka-a bẹ woru akpụru, shi l'oshi ono nụ mu; mu ria.” ");
INSERT INTO izz_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Chipfu, bụ Chileke bya ajịa nwanyị ono sụ iya: “?Dẹnu g'ọ nwụru i meru iphe, dụ nno?” Nwanyị ono sụ: “Ọ kwa agwọ gbabẹru mu ẹregede; mu je erinaa ya.” ");
INSERT INTO izz_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Chipfu, bụ Chileke sụ agwọ: “Eshinu i meru iphe-a bẹ “Iphe, bụkota iphe-edobe; mẹ anụ-ẹgbudu l'ophu bụepho gụbedua bẹ a tụru ọnu. Ịi-wata awụ l'ẹpho. Ọ bụru ẹja, shi l'alị bẹ ii-rije gbiriri jasụ g'ịi-nọ-beru. ");
INSERT INTO izz_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mu e-me g'unu lẹ nwanyị-a bụru ọhogu; awa nkengu yẹe kẹ nwanyị-a a-bụkwarupho ọhogu. Ọo-zọpya ngu ishi; gụbedua emeka iya iphe l'ichirupfu ọkpa.” ");
INSERT INTO izz_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nwanyị ono bẹ ọ sụru: “Mu e-me g'iphe-ẹhuka, dụru ngu l'apa ẹpho-ime ka shii. Ii-jeje iphe-ẹhuka tẹme l'ị nwụa nwa. Ji ngu a-nọduje agụ ngu ẹgu; ọ bụru iya bẹ ịi-nọdu l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ọ sụ nwoke ono: “Eshi ọphu i kwetarụ ngabẹru nyee ngu nchị je eria akpụru oshi ono, mu sụru g'i ti rikwa ono bẹ I meakwaru; alị bụwaru iphe, mu tụru ọnu. Ii-jeje ozi mkpọnwu ẹhu tẹme l'i seta nri, ii-ri. Ọ bụru g'ii-je iya bụ ono gbiriri jasụ g'ịi-nọ-beru. ");
INSERT INTO izz_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Alị a-wata efushiru ngu ẹjo ẹswa; waa obvu; tẹme ọ bụru akpụru-iphe, mịtaru l'ẹgu a-bụjeru ngu nri. ");
INSERT INTO izz_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ịi-kụta ẹphuru phee tẹme l'i ria nri; gbiriri jasụ ị laphu azụ l'alị; eshi ọphu ọ bụ ẹja shi l'alị bẹ i shi. Ọo ẹja shi l'alị bẹ ị bụ; ọ bụkwarupho l'ẹja shi l'alị ono bẹ ịi-laphu azụ.” ");
INSERT INTO izz_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tọbudu iya bụ; nwoke ono gụa nyee ya ono Ivu; noo kẹle ọo-bụru ne ọha l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Chipfu bụ Chileke bya eworu akpọ-anụ mee ẹkwa nmabẹ Ádamu yẹe nyee ya. ");
INSERT INTO izz_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Noo ya; Chipfu, bụ Chileke bya epfua sụ: “Nta-a bẹ nemadzụ dụwaa g'anyịbedua; mbụ ọ mawaru iphe, dụ ree; bya amaru iphe, bụ ẹjo-iphe. G'ọ tọ wọtafuanu akpụru oshi, emeje g'a nọdu ndzụ ria nọdu ndzụ ojejoje.” ");
INSERT INTO izz_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ọo ya bụ; Chipfu bụ Chileke chịfu iya lẹ mgbabu Édẹnu; g'o je ejeahaa ozi l'alị, bụ ẹka e shi wota ẹja kpụa ya. ");
INSERT INTO izz_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ọ chịfuchaepho nemadzụ lẹ mgbabu ono; ọ bya eje l'ụzo ẹnyanwu-awawa kẹ mgbabu Édẹnu ono; bya eworu ojozi-imigwe, bụ Chierobu dobe iya; bya edobe iya ogu-echi, charụ gbarara; tẹme ọ nọdu egbu swịiswiiswii iphu l'azụ g'o chee ụzo, e shi eje l'oshi ndzụ phọ nche. ");
INSERT INTO izz_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ádamu bya ejepfu nyee ya, bụ Ivu; ọ tsụta ime; bya anwụa Kénu. Ivu sụ: “Chipfu yewaru mu ẹka; mu nwụa nwa nwoke.” ");
INSERT INTO izz_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","E mechaa; ọ bya anwụa nwune iya, bụ Ebẹlu. Ebẹlu bụru onye nweru atụru; waa eghu; Kénu bụru onye akọ opfu. ");
INSERT INTO izz_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","A nọnyaa; Kénu hata mebyi iphe, shi l'alị gude je g'ọ nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Obenu lẹ Ebẹlu hatarụ atụru ivuzọ, atụru iya nwụshiru gbua; bya ebuta iya ẹka ọ tsụru ẹba; je anụ Chipfu. Ebẹlu yẹe iphe, ọ nụru dụ Chipfu ree; ọ nata iya. ");
INSERT INTO izz_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ọ jịka Kénu yẹe iphe, ọ nụru iya. Ẹhu ghuahaa Kénu eghu; o woru iphu gbanwụbe. ");
INSERT INTO izz_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Chipfu sụ Kénu: “?Bụ gụnu kparụ iphe, ẹhu eghu ngu eghu? ?Bụ gụnu meru g'o gude ị gbanwụbe iphu? ");
INSERT INTO izz_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ọ -bụru l'i meru iphe, dụ ree; ?taa natadụ ngu tọ? Obenu; l'ọ -bụru l'i ti medụru iphe, dụ ree; makwarụ l'iphe-ẹji pfụwaru l'ọnu mgbo ngu; ọ nọdu agụ iya ẹgu g'o nweru ngu. Ọle ọ bụ; kapyabẹkwa iya ẹnya!” ");
INSERT INTO izz_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tọbudu iya bụ; Kénu sụ nwune iya Ebẹlu: “G'anyi je l'ẹgu.” Ẹphe jeshia; ẹphe rwuẹpho l'ẹgu; Kénu zụpyabe nwune iya Ebẹlu gbua. ");
INSERT INTO izz_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Noo ya; Chipfu sụ Kénu: “?Dẹnu nwune ngu Ebẹlu?” Ọ sụ: “Mu ta amakwa. ?Mu echekwanụ nwune mu nche?” ");
INSERT INTO izz_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Chipfu sụ iya: “?Bụ gụnu bẹ o gude i mee ẹgube ẹjo-iphe ọwa-a? Gebekwa! Mee nwune ngu ono gbẹkwa l'alị echiku mu lẹ mkpu. ");
INSERT INTO izz_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E -shi ntanụ-a bẹ ị bụwaa onye a tụru ọnu. Alị ono, sarụ ọnu ngụa mee nwune ngu ono jịkawa ngu. ");
INSERT INTO izz_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ị -kọo alị bẹ ọ tọ dụdu iphe, iimeta iya. Ịi-nọduepho agba ọso-ndzụ aghaphe phururugbada lẹ mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kénu sụ Chipfu: “Iphe-ẹhuka ono, ị sụru gẹ mu jee ono karikwaru mu ẹka. ");
INSERT INTO izz_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nta-a, g'ịichifuwa mu l'alị-a; k'ọphu bụ l'eedomiwa mu edomi l'iphu ngu-a; tẹme mu bụru onye agba ọso-ndzụ aghaphe phururugbada lẹ mgboko-a; bẹ onye hụmaru mu nụ e-wokwaru mu gbua.” ");
INSERT INTO izz_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Chipfu sụ iya: “Ọ tọ dụdu nno; ọ -dụru onye gburu gụbe Kénu; eewota iphe, e meru ngu mee onye ọbu mgbo ẹsaa.” Chipfu bya eworu iphe-ọhubama mee Kénu; k'ọphu ọ tọ dụdu onye hụmaru iya nụ eje iya egbugbu. ");
INSERT INTO izz_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ọo ya bụ; Kénu tụgbua lụfu l'iphu Chipfu; je eburu l'alị Nodu, nọ l'ụzo ẹnyanwu-awawa Édẹnu. ");
INSERT INTO izz_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kénu bya ejepfu nyee ya; ọ tsụta ime nwụa Inọku. Kénu nweru mkpụkpu, ọokpu teke ono; o woru mkpụkpu ono kua ẹpha nwa iya ono, bụ Inọku. ");
INSERT INTO izz_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inọku nwụta Iradu; Iradu bụru nna Mehujiẹlu; Mehujiẹlu bụru nna Metushẹlu; Metushẹlu bụru nna Lamẹku. ");
INSERT INTO izz_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamẹku lụa ụnwanyi labọ; onye lanụ aza Ada; onye ọphuu nọdu aza Zila. ");
INSERT INTO izz_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada bya anwụta Jiabalu; ọ bụru iya bụ nna ndu ebujeru l'ụlo-ẹkwa; bya abụru ndu ese akanya iphe-edobe. ");
INSERT INTO izz_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ẹpha nwune iya bụ Jiubalu; yẹbedua bụ nna ndu akpọje ogumogu; bya aphụ ụpyi. ");
INSERT INTO izz_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila bya anwụtakwapho nwa nwoke; ẹpha iya bụ Tubalu-Kénu. Yẹbedua bụ onye gude ope yẹe ígwè kpụshia ngwa, dụ igwerigwe. Tubalu-Kénu bẹ nwune iya nwanyị bụ Nama. ");
INSERT INTO izz_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Noo ya; Lamẹku sụ unyomu iya: “Ada; waa Zila; unu gebekpọdapho! Unubẹ unyomu Lamẹku; unu nụma opfu mu! Mu gburu nemadzụ; kẹle o mekarụ mu iphe. Ọo nwokorọbya, gburu mu ọ́nyá bẹ mu gburu. ");
INSERT INTO izz_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ọ -bụru lẹ Kénu bẹ a gwataru ụgwo-ọchi iya ugbo ẹsaa; gẹ kẹ yẹbe Lamẹku bụruro ụkporo ugbo ẹto l'ugbo ẹsaa!” ");
INSERT INTO izz_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Noo ya bụ; Ádamu byakwa bya ejepfu nyee ya ọzo; ọ bya anwụa nwa nwoke; bya eworu iya gụa Sẹtu sụ: “Chileke nụwaru mu nwa nwoke ọzo, a-nọ-chi ẹnya Ebẹlu; eshi ọphu Kénu gburu onye k'ono.” ");
INSERT INTO izz_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sẹtu bya anwụtakwapho nwa nwoke; bya eworu iya gụa Ẹnoshi. E shi teke ono ndiphe wata eku ẹpha Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ọwa-a bụ g'e gude deshia ẹpha ndu bụ oshilọkpa Ádamu; waa iphe, ẹphe meshiru. Teke Chileke meru nemadzụ bẹ o meru iya ọ dụ gẹ Chileke dụ. ");
INSERT INTO izz_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","O meru nwoke yẹe nwanyị. G'o mecharu phẹ bẹ ọ byaru agọru ọnu-ọma nụ phẹ bya ekua phẹ “nemadzụ”. ");
INSERT INTO izz_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ádamu nọchaepho ụkporo apha ishii l'apha iri; ọ nwụta nwa nwoke, yeru iya nụ; bya adụ g'ọ dụ. O woru iya gụa Sẹtu. ");
INSERT INTO izz_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A nwụchaa Sẹtu; Ádamu bya anọfua ụnu apha labọ. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Sẹtu. ");
INSERT INTO izz_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mkpakọ apha, Ádamu nọru bụru ụnu apha labọ l'ụkporo apha ishii l'apha iri; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sẹtu bya anọo ụkporo apha ise l'apha ise; bya abụru nna Ẹnoshi. ");
INSERT INTO izz_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ọ nwụchaa Ẹnoshi; bya anọfua ụnu apha labọ l'apha ẹsaa. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Ẹnoshi. ");
INSERT INTO izz_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mkpakọ apha, Sẹtu nọru bụru ụnu apha labọ l'ụkporo apha ise l'apha iri l'ẹbo; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ẹnoshi bya anọo ụkporo apha ẹno l'apha iri; bya abụru nna Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ọ nwụchaa Kénanu; bya anọfua ụnu apha labọ l'apha iri l'ise. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mkpakọ apha, Ẹnoshi nọru bụru ụnu apha labọ l'ụkporo apha ise l'apha ise; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénanu bya anọo ụkporo apha ẹto l'apha iri; bya abụru nna Mahalalẹlu. ");
INSERT INTO izz_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ọ nwụchaa Mahalalẹlu; bya anọfua ụnu apha labọ l'ụkporo apha labọ. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Mahalalẹlu. ");
INSERT INTO izz_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mkpakọ apha, Kénanu nọru bụru ụnu apha labọ l'ụkporo apha ise l'apha iri; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalẹlu bya anọo ụkporo apha ẹto l'apha ise; bya abụru nna Jiaredi. ");
INSERT INTO izz_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ọ nwụchaa Jiaredi; mbụ Mahalalẹlu; bya anọfua ụnu apha labọ l'apha iri. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Jiaredi. ");
INSERT INTO izz_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mkpakọ apha, Mahalalẹlu nọru bụru ụnu apha labọ l'ụkporo apha ẹno l'apha iri l'ise; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jiaredi bya anọo ụkporo apha ẹsato l'apha labọ; bya abụru nna Inọku. ");
INSERT INTO izz_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ọ nwụchaa Inọku; bya anọfua ụnu apha labọ. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Inọku. ");
INSERT INTO izz_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mkpakọ apha, Jiaredi nọru bụru ụnu apha labọ l'ụkporo apha ẹsato l'apha labọ; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inọku bya anọo ụkporo apha ẹto l'apha ise; bya abụru nna Metusela. ");
INSERT INTO izz_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ọ nwụchaa Metusela; yẹe Chileke bya aswịa ọswi ụkporo apha iri l'ise. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Metusela. ");
INSERT INTO izz_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Mkpakọ apha, Inọku nọru bụru ụkporo apha iri l'ẹsato l'apha ise. ");
INSERT INTO izz_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inọku bẹ yẹe Chileke swịru ọswi. A nọnyaa; a hụma-buhu iya; ọ bụru Chileke kutaru iya. ");
INSERT INTO izz_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela bya anọo ụkporo apha tete l'apha ẹsaa; bya abụru nna Lamẹku. ");
INSERT INTO izz_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ọ nwụchaa Lamẹku; bya anọfua ụnu apha l'ụkporo apha iri lẹ tete l'apha labọ. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Lamẹku. ");
INSERT INTO izz_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mkpakọ apha, Metusela nọru bụru ụnu apha labọ l'ụkporo apha iri l'ẹsato l'apha tete; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamẹku bya anọo ụkporo apha iri lẹ tete l'apha labọ; bya anwụta nwa nwoke. ");
INSERT INTO izz_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ọ gụa ya Nuwa sụ: “Ọo-dụ anyi obu l'akanya ẹgu-a, anyi ese l'alị-a, Chipfu tụru ọnu-a.” ");
INSERT INTO izz_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ọ nwụchaa Nuwa; bya anọfua ụnu apha l'ụkporo apha tete l'apha iri l'ise. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Nuwa. ");
INSERT INTO izz_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mkpakọ apha, Lamẹku nọru bụru ụnu apha l'ụkporo apha iri l'ẹsato l'apha iri l'ẹsaa; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuwa bya anọo ụnu apha l'ụkporo apha ise; bya abụru nna Shemu; waa Hamu; waa Jiafẹti. ");
INSERT INTO izz_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nemadzụ nọdu aka shii eje lẹ mgboko; a nọdu anwụshiru phẹ ụnwada. ");
INSERT INTO izz_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ụnwu Chileke hụma ụnwada nemadzụ l'ẹphe ama mma; bya atụgbua je alụgbaa phẹ. ");
INSERT INTO izz_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Chipfu sụ: “Unme mu ta anọduhedu l'ime nemadzụ jasụru; noo kẹle ọ bụepho anụ-ẹhu mmanụ. E -shi nta-a bẹ iphe, nemadzụ a-nọje bụ ụkporo apha ishii.” ");
INSERT INTO izz_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ndu gbarụ oke mkparawa nọ lẹ mgboko lẹ teke ono; bya anọkwaru iya rọ kwasẹru; mbụ lẹ teke ụnwu Chileke jepfuru ụnwada nemadzụ; ẹphe bya anwụshiaru phẹ ụnwegirima. Ẹphe bụ ndu e shi maru ẹpha phẹ teke ndiche l'ọkpehu, shi dụ phẹ nụ. ");
INSERT INTO izz_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Chipfu bya elee ẹnya hụma g'ẹjo-ememe nemadzụ habewa shi lẹ mgboko; l'iphe, obu phẹ anọdujeepho arị bụ g'ẹphe e-shi mee ẹjo-iphe tekenteke. ");
INSERT INTO izz_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ọ bụru aphụ tsọru Chipfu lẹ ya meru nemadzụ lẹ mgboko; tẹme ọ nọdu eghu iya eghu l'ime ọkpoma. ");
INSERT INTO izz_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Chipfu sụ: “Mu e-meẹpho gẹ nemadzụ, mu meru dobe l'eliphe chịhu. Nemadzụ a-chịhu; mẹ anụ; mẹ iphe, awụ l'ẹpho; waa ẹnu, ephe l'eli; kẹle ọ bụwaa aphụ tsọru mu lẹ mu meru phẹ dobe.” ");
INSERT INTO izz_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Obenu lẹ Nuwa bẹ dụ Chipfu l'obu. ");
INSERT INTO izz_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Waa oshilọkpa Nuwa. Nuwa bụ onye bụe ya phọ bụ onye pfụberu-ẹka-ọto; ọphu ụta adụdu iya l'ẹhu lẹ ndu teke ono; tẹme ẹphe lẹ Chileke swịa ọswi. ");
INSERT INTO izz_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuwa ono nwụtaru ụnwegirima unwoke ẹto, ẹpha phẹ bụ Shemu; yẹe Hamu; waa Jiafẹti. ");
INSERT INTO izz_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Teke ono bẹ mgboko mebyishihuwaru l'atatiphu Chileke; bya abụru iwashị jiru iya. ");
INSERT INTO izz_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Chileke hụma gẹ mgboko mebyihubewaru; noo kẹle ndu bu lẹ mgboko mebyishibẹbewaru onwophẹ. ");
INSERT INTO izz_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ọo ya bụ; Chileke sụ Nuwa: “Mu abyawaa eme gẹ nemadzụ l'ophu chịhu; noo kẹle iphe, jiru mgboko bụ iwashị; ọ bụru phẹ kparụ iya. Sụ-a; mu abyawaa phẹ emebyishi; mebyishikwaphọ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ọo ya bụ; je egude oshi gofa kụa ụgbo; tubushia ya ọmulo ọmulo l'ime iya; gude ụ̀nwù dachishia ya ime; yẹe azụ. ");
INSERT INTO izz_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Waa g'ii-gude kụa ya baa: ụgbo ono a-dụ ụkporo nkwo-ẹka iri l'ise l'ogologo; ọsa iya abụru ụkporo nkwo-ẹka labọ lẹ nkwo-ẹka iri; l'ọ bya adụ ụkporo nkwo-ẹka lẹ nkwo-ẹka iri l'eli. ");
INSERT INTO izz_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","L'ị bya akụ-chia eli ụgbo ono akụ-chi g'ọ dụ nkwo-ẹka lanụ a -gbẹ l'igburọnu iya. L'ị bya eworu mgbo ye lẹ mgburẹku ụgbo ono; tẹme l'ị kụa ya g'ọ dụ mkpopfu ẹto. ");
INSERT INTO izz_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mu e-gude utso bya lẹ mgboko bya erigbushikọta iphe, dzụ ndzụ, nọ igwe lẹ mkpula; mbụ iphemiphe, e meru ememe, atụ unme. Iphemiphe, nọ l'eliphe a-bụru mkpurupyata. ");
INSERT INTO izz_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Obenu lẹ gụbedua bẹ mu lẹ ngu a-gba ndzụ; l'ịibahu l'ụgbo ono; unu l'ụnwu ngu; waa nyee ngu; waa unyomu ụnwu ngu. ");
INSERT INTO izz_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","L'ị bya ahọo iphemiphe, dzụ ndzụ ẹbo ẹbo; okee lẹ nyee; dobe ndzụ l'ẹka ị nọ. ");
INSERT INTO izz_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ẹnu, ephe l'eli a-dụ ẹbo ẹbo dụ l'ụdu iya l'ụdu iya byapfuta ngu; ụnwu anụ; yẹe anụ, awụ l'ẹpho adụkwapho ẹbo ẹbo byapfutakọta ngu g'i dobe phẹ ndzụ. ");
INSERT INTO izz_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ịibya ahọo nri l'asa iya l'asa iya dobe g'ọ bụru nri, unu l'ẹphe e-rije.” ");
INSERT INTO izz_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuwa bya atụkoepho iphemiphe ono mekọta gẹ Chileke sụru g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E mechaa; Chipfu sụ Nuwa: “Bahụ l'ụgbo ono; unu lẹ ndibe ngu l'ophu; noo kẹle ọo gụbedua kpoloko bẹ mu hụmaru bụ onye pfụberu-ẹka-ọto l'ọgbo-a. ");
INSERT INTO izz_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Họta anụ, a ta sọdu nsọ ẹsaa ẹsaa; okee lẹ nyee. L'ị họta anụ, aasọ nsọ ẹbo ẹbo; okee lẹ nyee. ");
INSERT INTO izz_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","L'ị bya ahọta ẹnu ẹsaa ẹsaa; okee lẹ nyee; dobe phẹ ndzụ lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","A -nọepho ujiku ẹsaa nta-a bẹ mu e-dze mini lẹ mgboko ụkporo abalị labọ eswe l'ẹnyashi; gude mebyishikọta iphemiphe, dzụ ndzụ, mu meru dobe lẹ mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuwa bya atụko iphemiphe, Chipfu sụru g'o mee mekọta. ");
INSERT INTO izz_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuwa ono nọwaru ụnu apha l'ụkporo apha iri teke utso ono byaru lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuwa; yẹe ụnwu iya; waa nyee ya; waa unyomu ụnwu iya bya abahụ l'ụgbo ono; g'ẹphe gbalarụ utso ono. ");
INSERT INTO izz_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Anụ ẹbo ẹbo l'ọphu a ta sọdu nsọ; mẹ ọphu aasọ nsọ; mẹ ẹnu; mẹkpoo iphe, awụ l'ẹpho; ");
INSERT INTO izz_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","okee lẹ nyee byapfuta Nuwa bya abahụ l'ụgbo ono, bụ iya bụ gẹ Chileke pfuru iya. ");
INSERT INTO izz_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A nọchaepho ujiku ẹsaa ono; utso bya lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","O be l'apha, kwe Nuwa ụnu apha l'ụkporo apha iri; lẹ mbọku, ọnwa k'ẹbo dụepho l'abalị iri l'ẹsaa; ọgba mini ime alị gbafushihu; tẹme a gụhashia ẹnya mini k'akpaminigwe. ");
INSERT INTO izz_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Igwe dzee mini lẹ mgboko ụkporo abalị labọ eswe l'ẹnyashi. ");
INSERT INTO izz_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ọ bụru mbọku ono gẹdegede bẹ Nuwa; yẹe ụnwu iya, bụ Shemu; waa Hamu; yẹe Jiafẹti; yẹe nyee ya; waa unyomu ụnwu iya ẹphe n'ẹto tụkoru bahụ l'ụgbo ono. ");
INSERT INTO izz_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Anụ-ẹgbudu, dụlaje l'ụdu iya l'ụdu iya; mẹ anụ, bụ iphe-edobe, dụlaje l'ụdu iya l'ụdu iya; mẹ iphemiphe, bụ iphe, awụ l'ẹpho, dụlaje l'ụdu iya l'ụdu iya; mẹ ẹnu, dụlaje l'ụdu iya l'ụdu iya; mbụ iphemiphe, furu ǹkù bẹ ẹphe l'ẹphe tụkoru bahụ l'ụgbo ono. ");
INSERT INTO izz_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Iphemiphe, e meru ememe, dzụ ndzụ dụ ẹbo ẹbo byapfuta Nuwa; bya abahụ l'ụgbo ono. ");
INSERT INTO izz_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anụ, wụbakotaru l'ụgbo ono bụkotaerupho okee lẹ nyee iphemiphe, dzụ ndzụ; ẹgube ono, Chileke sụru Nuwa l'ọo-dụ ono. E mechaa; Chipfu gụ-chia ụgbo ono gụ-buru phẹ ye l'ime iya. ");
INSERT INTO izz_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ụkporo abalị labọ bẹ utso ono byakọtaru lẹ mgboko; mini ono nọdu aka shii eje; ọ nọdu apalị ụgbo ono ephekerephe lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mini ono nọdu abyaẹpho kẹ kụlakula lẹ mgboko; ụgbo ono nọdu ese eli l'eli mini. ");
INSERT INTO izz_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Utso ono byaa shii lẹ mgboko; bya atụko úbvú, nọ igwe lẹ mkpula gbamikọta. ");
INSERT INTO izz_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mini ono byaa shii; k'ọphu o gude nkwo-ẹka iri l'ise kakọta úbvú l'eli. ");
INSERT INTO izz_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Iphemiphe, eme ụkporo lẹ mgboko lakọta l'iyi. Mbụ ẹnu; waa anụ, bụ iphe-edobe; waa anụ-ẹgbudu; iphe, kụkotaru lẹ mgboko; yẹe nemadzụ. ");
INSERT INTO izz_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Iphemiphe, nọ l'eli mgboko, dzụ ndzụ, atụ unme l'imi nwụshikota. ");
INSERT INTO izz_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Iphemiphe, nọkota lẹ mgboko bẹ e mebyishikọtaru. Nemadzụ; me anụ; mẹ iphe, awụ l'ẹpho; mẹ ẹnu bẹ e mebyishikọtaru lẹ mgboko. Ọ bụerupho Nuwa yẹe iphemiphe ono, ẹphe l'iya tụkoru nọdu l'ụgbo ono wafụru. ");
INSERT INTO izz_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Utso ono dọru lẹ mgboko nọo ụkporo abalị ẹsaa l'abalị iri. ");
INSERT INTO izz_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Obenu lẹ Chileke nyatarụ-a Nuwa; waa anụ-ẹgbudu; mẹ anụ, bụ iphe-edobe, ẹphe l'iya tụkoru nọdu l'ụgbo ono. Ọ bya emee gẹ phẹrephere wata ezizi lẹ mgboko; mini ono wata alala. ");
INSERT INTO izz_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","A zachishia ọgba mini ime alị phọ; bya aguchishia ẹnya mini akpaminigwe phọ. E buchia mini, shi l'igwe mee; igwe dzebuhu mini. ");
INSERT INTO izz_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mini ono nọdu alakpọepho lẹ mgboko. A nọepho ụkporo abalị ẹsaa l'abalị iri; mini ono lawaa shii. ");
INSERT INTO izz_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ọnwa k'ẹsaa dụepho abalị iri l'ẹsaa; ụgbo ono je je ebvuru l'úbvú Araratu. ");
INSERT INTO izz_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mini ono nọdu alakpọepho jasụ l'ọnwa k'iri. Ọ bụru lẹ mbọku mbụ l'ọnwa k'iri ono bẹ e beberu hụmaahaa mkpakpọnu úbvú. ");
INSERT INTO izz_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","A nọekwapho ụkporo abalị labọ; Nuwa bya agụhaa windo, o yeru l'ụgbo ono; ");
INSERT INTO izz_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bya atụfu okpoko-ọ́hà. O je etsoru rwupheahaa l'eli; gbiriri jasụ mini tashịhu lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ọ bya atụfu ndo g'ọ maru ?mini ono tahụgbuwaru l'eli alị? ");
INSERT INTO izz_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ọphu ndo ono ahụmaduru ẹka ọo-zọbe ọkpa; noo kẹle mini nọkwadu l'eli mgboko. Ọo ya bụ; ọ lapfu Nuwa l'ụgbo ono ọzo. Nuwa machịa ẹka nwụta ndo ono ye l'ime ụgbo ono ọzo. ");
INSERT INTO izz_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ọ bya anọkwaa ujiku ẹsaa; bya agbẹkwa l'ụgbo ono tụfu ndo ono ọzo. ");
INSERT INTO izz_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ndo ono lwatashịa l'ụzenyashi; ọ takpụru ẹkwo oshi olivu ọ̀phúú gude lwa. Nuwa maru lẹ mini tahụwaru l'eliphe. ");
INSERT INTO izz_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ọ nọkwaa ujiku ẹsaa ọzo; bya atụfukwa ndo ono ọzo. O -rwua l'ọgiya ono; ọphu ọ lwaẹduru azụ lwapfuta iya. ");
INSERT INTO izz_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","O be gẹ Nuwa nọrwuerupho ụnu apha l'ụkporo apha iri l'apha lanụ; lẹ mbọku, ọnwa mbụ dụ l'abalị mbụ; mini ono tashịhuwaa l'alị. Nuwa bya ewofu iphe, e gude kuchia ụgbo ono; bya ahụma l'eli alị kpọhuwaru nkụ. ");
INSERT INTO izz_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","O rwua lẹ g'ọnwa k'ẹbo dụ l'ụkporo abalị l'abalị ẹsaa; alị kpọhukotawaa nkụ. ");
INSERT INTO izz_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ọo ya bụ; Chileke sụ Nuwa: ");
INSERT INTO izz_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Unu lụfuta l'ụgbo ono; gụ lẹ nyee ngu; waa ụnwu ngu; waa unyomu ụnwu ngu. ");
INSERT INTO izz_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","L'ịichifuta iphemiphe, dzụ ndzụ, unu l'iya nọ l'ẹka ono: ẹnu; mẹ anụ; mẹwaro iphemiphe, awụ ẹpho l'alị; g'ẹphe bya azụa azụ̀zù zụ-jia mgboko; ẹphe anwụshi ụnwu aka igwerigwe l'ime iya.” ");
INSERT INTO izz_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ọo ya bụ; Nuwa bya afụta; yẹe ụnwu iya; yẹe nyee ya; waa unyomu ụnwu iya. ");
INSERT INTO izz_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Anụ l'ophu; mẹwaro iphemiphe, awụ ẹpho l'alị; mẹ ẹnu l'ophu; mbụ iphemiphe, eme ụkporo lẹ mgboko shikọta l'ụgbo ono fụtagbaa l'ụdu iya l'ụdu iya. ");
INSERT INTO izz_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuwa bya akpụaru Chipfu ọru-ngwẹja; bya ahata anụ; yẹe ẹnu ndu k'ọphu a ta sọdu nsọ; bya egude gwee ngwẹja-akpọ-ọku nụ Chipfu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Chipfu nụmaepho ishishi iya, atsọ ntụmatu; o pfua l'ime obu iya sụ: “Mu ta abyaẹdu egude opfu ẹhu nemadzụ tụbaa alị ọnu; kẹle iphe, nemadzụ anọdujekpoepho arị l'obu iya e -shi lẹ nwata bụepho ẹjo-iphe. Ọphu mu abyaẹdu emebyishibaa iphemiphe, mu meru ememe, dzụ ndzụ; ẹgube-a, mu meru-a. ");
INSERT INTO izz_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Jasụ gẹ mgboko a-nọ-beru bẹ teke akọbe iphe l'alị a-dụ; teke akpata iya akpata adụ. Teke oyi atsụ a-dụ; teke okpomọku dụ; adụkwapho. Ọnanwu a-dụ; udzumini adụkwapho. Eswe a-dụ; ẹnyashi adụkwapho; ọphu ọ dụ-buhubaẹdu.” ");
INSERT INTO izz_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Chileke bya agọru ọnu-ọma nụ Nuwa yẹe ụnwu iya; sụ phẹ: “Unu zụ̀a azụ̀zù; kabaa igwerigwe; unu azụa zụ-jia mgboko. ");
INSERT INTO izz_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ụnwu anụ, nọkota l'eliphe; waa ẹnu, ephe l'eli; waa iphemiphe, awụ l'ẹpho; waa ẹma, bu lẹ mini l'ophu bẹ ndzụ unu a-nọdu agụkota; ẹphe atsụ unu ebvu. G'ẹphe ha a-nọdukota unu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iphemiphe, dzụ ndzụ eme ụkporo a-bụkotaru unu nri. Ọo gẹ mu nụkotaru unu oshi-ọmi l'ophu bụ gẹ mu nụkotakwarupho unu iphemiphe l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ọle g'unu ta atajẹkwa anụ mẹ mee ndzụ nọdukwadu iya l'ime ẹhu. ");
INSERT INTO izz_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mee ndzụ unu bẹ mu a-jị ajị iya. Teke o shi anụ l'ẹka mu ajịkwaa ya phọ ajị iya. Nemadzụ -gburu nwibe iya bẹ mu a-jịkwapho ajị iya. ");
INSERT INTO izz_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Onye gburu nemadzụ bụkwapho nemadzụ bẹ e-gbu yẹbedua. Noo kẹle Chileke meru nemadzụ; ọ dụ g'ọ dụ. ");
INSERT INTO izz_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A -bya l'ẹhu kẹ gụbedua; unu jaa àjàjà ka l'ọtu; unu azụa azụ̀zù zujia mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tọbudu iya bụ; Chileke sụ Nuwa; yẹe ụnwu iya, ẹphe l'iya tụkoru nọdu l'ẹka ono: ");
INSERT INTO izz_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nta-a bẹ mu l'unu waa oshilọkpa unu ndu ọphu nọ l'iphu gbawaru ndzụ. ");
INSERT INTO izz_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tẹme anyi l'iphe, dzụ ndzụ, unu l'iya shi tụko nọdu gbakwaphọ ndzụ; mbụ ẹnu; waa anụ, bụ iphe-edobe; waa anụ-ẹgbudu; iphemiphe ono, unu l'iya tụkoru shi l'ụgbo fụta ono; mbụ iphemiphe ono, bu l'eliphe ono. ");
INSERT INTO izz_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mu l'unu gbaakwaru ndzụ. E tee gudebaẹkwa utso erigbushi nemadzụ l'ophu ọzobaa. Ọphu utso, e-mebyishibaa mgboko-a l'ophu abyaẹdu agbabaa.” ");
INSERT INTO izz_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Chileke sụ: “Waa iphe, egoshi ọgbandzu ono, mu l'unu; waa iphe, dzụ ndzụ, unu l'ẹphe tụkoru nọdu l'ẹka ono; waa ọgbo ọphu nọ l'iphu agba bụ ọwa-a. ");
INSERT INTO izz_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mu wowaru ẹko-mini mu dobe l'akpaminigwe; tẹme ọo-bụjeerupho iphe, egoshi ọgbandzu mu lẹ mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Teke igwe rwuru erwurwu; ọ gbaa ẹko-mini ono; ");
INSERT INTO izz_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mu a-nyata ọgbandzu mu l'unu; waa iphe, dzụ ndzụ l'ophu, dụlaje l'ụdu iya l'ụdu iya. Mbụ lẹ mini ta abyabaẹdu abya utso bya erigbushia iphe, nọ ndzụ ọzo. ");
INSERT INTO izz_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Iphe, bụkpoo teke ẹko-mini gbaru l'urwukpu; mu a-hụma iya nyata ọgbandzu ojejoje ono, Chileke yẹe iphe, nọ ndzụ, dụlaje l'ụdu iya l'ụdu iya, nọ lẹ mgboko gbaru ono.” ");
INSERT INTO izz_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ọ bụru iya bụ Chileke sụ Nuwa: “Ọo iphe-a bụ iphe, egoshi ọgbandzu ono, mu l'iphemiphe, dzụ ndzụ, nọ l'eliphe gbaru ono.” ");
INSERT INTO izz_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ụnwu Nuwa, shi l'ụgbo ono lụfuta bụ Shemu; waa Hamu; waa Jiafẹti. Ọ bụru Hamu bụ nna Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ọ bụru shita l'ụnwu Nuwa unwoke ẹto-a bẹ nemadzụ shiru dzuru mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noo ya; Nuwa bụ onye emebe iphe l'alị; bya eworu opfu-vayịnu kọo. ");
INSERT INTO izz_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","O rwua ujiku lanụ; ọ ngụa mẹe, shi l'akpụru vayịnu iya ono. Ọ wata iya atsụtsu k'ọphu ọ gba ọto je azẹe l'ụlo-ẹkwa iya. ");
INSERT INTO izz_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, bụ nna Kénanu je ahụma nna iya ẹka ọ gba ọto; bya eje epfuaru iya unwune iya ẹphenebo ọphu nọ l'etezi. ");
INSERT INTO izz_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shemu; waa Jiafẹti bya achịta ẹkwa kobegbaa onwophẹ l'ukuvu je l'azụ l'azụ je aphukpute nna phẹ ono, gba ọto ono. Ẹphe woru iphu ghaa l'ibe iya ọzo g'ẹphe ta ahụma nna phẹ l'ẹka ọ gba ọto. ");
INSERT INTO izz_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","O be teke mẹe tsubuhuru Nuwa; o tehu bya anụma iphe ono, nwa iya kẹ nwata meru iya ono; ");
INSERT INTO izz_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ọ sụ: “Kénanu bẹ bụakwaa onye a tụru ọnu. Ọo-bụru ohu ndu bụ ohu l'ẹka unwune iya.” ");
INSERT INTO izz_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ọ sụkwapho: “G'e tua Chipfu, bụ Chileke kẹ Shemu ẹpha! Gẹ Kénanu bụkwaru ohu Shemu! ");
INSERT INTO izz_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gẹ Chileke mee gẹ Jiafẹti jaa àjàjà! Gẹ Jiafẹti buru l'ụlo-ẹkwa Shemu! Gẹ Kénanu bụfukwarupho ohu iya!” ");
INSERT INTO izz_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","G'utso ono byachaaru bẹ Nuwa nọfuaru ụkporo apha iri l'ẹsaa l'apha iri. ");
INSERT INTO izz_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mkpakọ iphe, Nuwa nọru bụru ụnu apha labọ l'ụkporo apha ẹsaa l'apha iri; bya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Waa oshilọkpa ụnwu Nuwa, bụ Shemu; waa Hamu; waa Jiafẹti baa. Mbụ l'a nwụshiru phẹ ụnwegirima lẹ g'utso ono lachaaru. ");
INSERT INTO izz_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ụnwu Jiafẹti bụ Goma; waa Magọgu; waa Madayi; waa Jiavanu; waa Tubalu; waa Mẹsheku; waa Tirasu. ");
INSERT INTO izz_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ụnwu kẹ Goma bụru Ashikenazu; waa Rifatu; waa Togarama. ");
INSERT INTO izz_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ụnwu kẹ Jiavanu bụ Elisha; waa Tashishi; waa ndu Kitimu; waa ndu Rodu. ");
INSERT INTO izz_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ndu ono bụ phẹ bụ eri Jafẹti. Ọ bụru phẹ bẹ iphe, bụkpoo ọha, bukube eze-ẹnyimu gbẹ l'ẹka jakashịa. Ọha ono g'ẹphe hakọta nwegbaarụ oke alị yẹe opfu-alị nkephẹ; waa ipfu ipfu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ụnwu Hamu bụ Kushi; waa Ijiputu; waa Putu; waa Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ụnwu kẹ Kushi bụru Seba; waa Havila; waa Sabuta; waa Rama; waa Sabuteka. Ụnwu Rama bụ Sheba; waa Dedanu. ");
INSERT INTO izz_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi bụ nna Nimurọdu, bụ onye mechaarụ bya abụru eze ojọgu l'eliphe. ");
INSERT INTO izz_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ọ bụ onye ike dụ l'achị nta l'iphu Chipfu; noo iphe, meru g'o gude a nọdu anmajẹ ẹtu sụ: “Onye-a dụ gẹ Nimurọdu onye ike dụ l'achị nta l'iphu Chipfu.” ");
INSERT INTO izz_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ẹka o gbuberu ishi abụru eze iya bụ lẹ Babẹlu; waa Ẹreku; waa Akadu; waa Kalune, nọ l'ime alị Shịna. ");
INSERT INTO izz_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","O shi l'ẹka ono wata àjàjà jarwua alị Asiriya, bụ ẹka ọ nọ meta mkpụkpu Ninive. O metakwaphọ mkpụkpu Rehobotu-Iye; waa mkpụkpu Kala; ");
INSERT INTO izz_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","waa mkpụkpu Resenu. Resenu ono nọ lẹ mgbaka Ninive waa Kala. Ọ bụru iya bụ oke mkpụkpu ono. ");
INSERT INTO izz_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ijiputu bụ nna ndu Ludu; waa ndu Anamu; waa ndu Lehabu; waa ndu Nafutu; ");
INSERT INTO izz_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","waa ndu Paturọsu; waa ndu Kasuluhu. Ndu Kasuluhu ono bụ iya bụ ẹka ndu Filisitayinu shi. Ijiputu bụkwarupho nna ndu Kafụto. ");
INSERT INTO izz_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kénanu bụ nna Sayịdonu. Ọ bụru Sayịdonu ono bụ ọkpara iya. Kénanu bụkwarupho nna ndu Hetu; ");
INSERT INTO izz_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","waa ndu Jiebusu; waa ndu Amọru; waa ndu Gigashi; ");
INSERT INTO izz_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","waa ndu Hevu; waa ndu Akụ; waa ndu Sini; ");
INSERT INTO izz_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","waa ndu Avadi; waa ndu Zemaru; waa ndu Hamatu. E mechaa; ọkpa-ipfu ndu Kénanu bya ajakashịa. ");
INSERT INTO izz_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Oke alị Kénanu gbẹ lẹ mkpụkpu Sayịdonu; mẹ a -nọdu eje mkpụkpu Jira; nọo jasụ lẹ mkpụkpu Gaza. Ọ gbẹkwapho lẹ Gaza l'ẹka ono; mẹ a -nọdu eje mkpụkpu Sọdomu yẹe Gọmóra; yẹe Adama; yẹe Zebowimu; nọo jasụ lẹ mkpụkpu Lesha. ");
INSERT INTO izz_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ọ bụru ọha ono bụkota ụnwu Hamu; g'ẹphe hakọta nwegbaarụ ipfu ipfu nkephẹ; yẹe opfu-alị yẹe oke alị nkephẹ. ");
INSERT INTO izz_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu nwụshikwarupho ụnwegirima unwoke. Nwune Jiafẹti k'ọgerenya bụ Shemu. Ọ bụru Shemu bụ ochochoroche ụnwu Eba l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ụnwu Shemu bụ Elamu; waa Ashuru; waa Afakusadu; waa Ludu; waa Arámu. ");
INSERT INTO izz_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ụnwu kẹ Arámu bụru Uzu; waa Hulu; waa Geta; wafụa Mashu. ");
INSERT INTO izz_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afakusadu bụ nna Shela. Shela bya abụru nna Eba. ");
INSERT INTO izz_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba nwụta unwoke labọ. Ẹpha onye lanụ bụ Pẹlegu; noo kẹle a nwụru iya teke mgboko kekashịhuru. Ẹpha nwune iya bụru Jiọkutanu. ");
INSERT INTO izz_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jiọkutanu bụ nna Alumodadu; waa Shịlefu; waa Hazamaveti; waa Jera; ");
INSERT INTO izz_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","waa Hadoramu; waa Uzalu; waa Dikila; ");
INSERT INTO izz_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","waa Obalu; waa Abimẹlu; waa Sheba; ");
INSERT INTO izz_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","waa Ofi; waa Havila; wafụa Jiobabu. G'ẹphe ha bụkota ụnwu Jiọkutanu. ");
INSERT INTO izz_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ẹka ẹphe bu shi lẹ Mesha phobe rwua Sefa l'ụzo ọha úbvú l'ụzo ẹnyanwu-awawa. ");
INSERT INTO izz_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ọ bụru ọha ono bụkota ụnwu Shemu; g'ẹphe hakọta nwegbaarụ ipfu ipfu nkephẹ; yẹe opfu-alị yẹe oke alị nkephẹ. ");
INSERT INTO izz_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ọha ono g'ẹphe ha bụkota oshilọkpa ụnwu Nuwa; g'ẹphe ha nwegbaarụ ipfu ipfu nkephẹ. Ọ bụru phẹ bẹ ọhamoha shi l'ẹka dzuru eliphe l'ophu g'utso gbacharu. ");
INSERT INTO izz_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ụnwu-eliphe l'ophu shi epfukọta opfu-alị lanụ, a nụ-dzuru. ");
INSERT INTO izz_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Noo ya; o be teke ndiphe kwasẹru ụzo ẹnyanwu-awawa; ẹphe je ahụma nsụda lẹ Shịna; ẹphe je ebukọbe l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ẹphe sụ nwibe phẹ: “Unu bya g'anyi kpụa ẹja hụa ya l'ọku hụ-ghee ya ahụ-ghe.” Ọ bụru ẹja akpụkpu bẹ nọ-chiru phẹ ẹnya mkpuma; ẹphe wụa ya korota g'ọ bụru ọtu-paa. ");
INSERT INTO izz_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ẹphe sụ: “Unu bya g'anyi metaru onwanyi mkpụkpu; g'anyi kpụa ụlo-eli, e-je asupfuru l'igwe. Ọo ya bụ; g'anyi abụru ndu aa-maru ẹpha phẹ; g'anyi te je agbakashịhu dzuru mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tọbudu iya bụ; Chipfu bya enyizeta g'ọ hụma mkpụkpu ono; yẹe ụlo-eli ono, ụnwu-eliphe akpụ ono; ");
INSERT INTO izz_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","bya asụ: “Ndu-a bụkwa nanụ; bya epfukọta opfu-alị lanụ; ẹphe wata eme iphe, dụ ẹgube-a. O to nwekwa iphe, ẹphe chịru idzu ememe g'ẹphe te emegha iya. ");
INSERT INTO izz_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Unu g'anyi nyizeta je aghaa phẹ olu-opfu; g'iphe, nwibe phẹ epfu te edojehẹ phẹ ẹnya.” ");
INSERT INTO izz_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ọo ya bụ; Chipfu bya achịkashia phẹ; ẹphe dzuru mgboko; ẹphe parụ akpụ mkpụkpu ono haa. ");
INSERT INTO izz_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Noo iphe, meru g'o gude e kua ya Babẹlu; noo kẹle ọo ẹka ono bẹ Chipfu ghashịru opfu ụnwu-eliphe l'ophu. O shi l'ẹka ono chịkashia phẹ; ẹphe dzuru mgboko. ");
INSERT INTO izz_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Waa oshilọkpa Shemu. A nọepho mgbarapha labọ g'utso byachaaru ono; Shemu nwụta Afakusadu. Teke ono bẹ Shemu nọwaru ụkporo apha ise tẹme ọ nwụta Afakusadu ono. ");
INSERT INTO izz_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ọ nwụchaa Afakusadu; bya anọfua ụnu apha l'ụkporo apha ise. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Afakusadu. ");
INSERT INTO izz_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Afakusadu bya anọo ụkporo apha l'apha iri l'ise; bya abụru nna Shela. ");
INSERT INTO izz_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ọ nwụchaa Shela; bya anọfua ụnu apha l'apha ẹto. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Shela. ");
INSERT INTO izz_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela bya anọo ụkporo apha l'apha iri; bya abụru nna Eba. ");
INSERT INTO izz_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ọ nwụchaa Eba; bya anọfua ụnu apha l'apha ẹto. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Eba. ");
INSERT INTO izz_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eba bya anọo ụkporo apha l'apha iri l'ẹno; bya abụru nna Pẹlegu. ");
INSERT INTO izz_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ọ nwụchaa Pẹlegu; bya anọfua ụnu apha l'ụkporo apha l'apha iri. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Pẹlegu. ");
INSERT INTO izz_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pẹlegu bya anọo ụkporo apha l'apha iri; bya abụru nna Rewu. ");
INSERT INTO izz_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ọ nwụchaa Rewu; bya anọfua ụkporo apha iri l'apha tete. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Rewu. ");
INSERT INTO izz_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rewu bya anọo ụkporo apha l'apha iri l'ẹbo; bya abụru nna Sérugu. ");
INSERT INTO izz_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ọ nwụchaa Sérugu; bya anọfua ụkporo apha iri l'apha ẹsaa. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Sérugu. ");
INSERT INTO izz_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sérugu bya anọo ụkporo apha l'apha iri; bya abụru nna Nahọ. ");
INSERT INTO izz_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ọ nwụchaa Nahọ; bya anọfua ụkporo apha iri. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Nahọ. ");
INSERT INTO izz_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahọ bya anọo ụkporo apha l'apha tete; bya abụru nna Tera. ");
INSERT INTO izz_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ọ nwụchaa Tera; bya anọfua ụkporo apha ise l'apha iri lẹ tete. Ọ nwụshikwapho unwoke yẹe ụnwanyi tsobe Tera. ");
INSERT INTO izz_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera bya anọo ụkporo apha ẹto l'apha iri; bya abụru nna Ebiramu; waa Nahọ; waa Haranu. ");
INSERT INTO izz_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Waa oshilọkpa Tera. Tera bụ nna Ebiramu; waa Nahọ; waa Haranu. Haranu bụru nna Lọtu. ");
INSERT INTO izz_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Nna iya, bụ Tera nọdukwadu ndzụ; Haranu nwụhu lẹ mkpụkpu Uru l'alị Kaludiya, bụ ẹka a nwụru iya. ");
INSERT INTO izz_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebiramu yẹe Nahọ bya atụko lụa nwanyị. Ẹpha nyee Ebiramu bụ Serayi; ẹpha nyee kẹ Nahọ bụru Milika. Onye nwụru Milika bụ Haranu; ọ bụkwarupho Haranu ono nwụru Isuka. ");
INSERT INTO izz_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ọphu Serayi anwụtaduru nwa; noo kẹle ọ tọo tsụdu ime. ");
INSERT INTO izz_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Noo ya bụ; Tera duta nwa iya, bụ Ebiramu; waa nwanwa iya, bụ Lọtu, bụ nwatibe Haranu; bya edutakwaphọ nyee nwa iya, bụ Serayi; bụ iya, bụ nyee Ebiramu. Ẹphe tụko swịru shi lẹ Uru, nọ l'alị Bábilọnu jeshia Kénanu. Obenu l'ẹphe rwuẹrupho Haranu; ẹphe buru l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera nọepho ụkporo apha iri l'apha ise; ọ nwụhu lẹ Haranu. ");
INSERT INTO izz_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Chipfu sụru Ebiramu: “Haa alị ngu; yẹe ndibe unu; mẹ ọkpoku ibe nna ngu; lashịa alị, mu e-goshi ngu. ");
INSERT INTO izz_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Mu e-me ngu l'ịi-bụru ọha, parụ ẹka apaa; tẹme mu ekebekwa ngu phọ l'ọma. Mu emee g'ẹpha ngu paa ẹka; tẹme l'ịiburu onye mu e-shi l'ẹhu iya ekebe ndu ọzo l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mu a-gọru ọnu-ọma nụ ndu gọru ọnu-ọma nụ ngu; ndu tụru ngu ọnu bẹ mu a-tụ ọnu. Tẹme ndu mgboko l'ophu bẹ ee-gude iswi ẹhu ngu kebe l'ọma.” ");
INSERT INTO izz_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ọo ya bụ; Ebiramu tụgbuna, bụ iphe, Chipfu pfuru iya. Lọtu tsoru iya. Ebiramu nọwaru ụkporo apha ẹto l'apha iri l'ise teke o shi Haranu tụgbua. ");
INSERT INTO izz_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tọbudu iya bụ; Ebiramu bya atụko ẹku, ẹphe kpatarụ akpata rwuta; bya eduta nyee ya, bụ Serayi; waa Lọtu, bụ nwa nwune iya; mẹkpoo ndu ẹphe shi lẹ Haranu gude; ẹphe wụfu; ọ bụru phẹ ala alị Kénanu. Ẹphe je jasụ ẹphe jerwua ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebiramu phẹ kwasẹru alị ono gbiriri jasụ ẹphe rwua ẹka eze oshi More nọ lẹ mgboru mkpụkpu Shẹkemu. Ọ bụru ndu Kénanu bu l'alị ono teke ono. ");
INSERT INTO izz_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ọle Chipfu byapfutaru Ebiramu bya asụ iya: “Ọ kwa oshilọkpa ngu bẹ mu a-nụkota alị-a.” Ebiramu bya akpụaru Chipfu ono, byapfutaru iya nụ ono ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ebiramu phẹ gbẹ l'ẹka ono kwasẹru ụzo ẹnyanwu-awawa úbvú Bẹtelu; je akpọbe ụlo-ẹkwa phẹ l'ẹka Bẹtelu nọ l'ụzo ẹnyanwu-arịba. Eyayi nọdu l'ụzo ẹnyanwu-awawa. Ebiramu rwukwaa ẹka ono bya akpụaru Chipfu ọru-ngwẹja; bya anọdu l'ẹka ono kpọ-ku ẹpha iya. ");
INSERT INTO izz_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Noo ya; Ebiramu phọkata ụlo-ẹkwa iya tụgbua kwasẹru ụzo echiẹgu ndọhali. ");
INSERT INTO izz_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tọbudu iya bụ; eze ẹgu wata ememe l'alị onoya; Ebiramu phẹ lashịa alị Ijiputu g'ẹphe je ebutọta l'ẹka ono; noo kẹle ẹgu ono eme shii. ");
INSERT INTO izz_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ẹphe bya l'abahụ l'alị Ijiputu; Ebiramu sụ nyee ya, bụ Serayi: “Mu maru l'ị bụ nwanyị, manụkaru mma. ");
INSERT INTO izz_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lẹ ndu Ijiputu -hụma ngu; bẹ ẹphe a-sụkwa l'ị bụ nyee mu. Ẹphe eworu mu gbua; haa ngu g'ị nọdu ndzụ. ");
INSERT INTO izz_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sụjekwa lẹ mu lẹ ngu bụ nwune; ọo ya bụ g'eemekwanaru mu ree l'iswi ẹhu ngu; tẹme l'iishikwaphọ nno mee g'ishi mu kpọ-pfuru.” ");
INSERT INTO izz_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ebiramu phẹ bya abahụ alị Ijiputu. Ndu Ijiputu hụma lẹ Serayi bụ nwanyị, ama ntụmatu. ");
INSERT INTO izz_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ndu nọ l'oke ọkwa Fero hụmae ya phọ; bya eje atụa ọnu iya l'iphu Fero. A bya eduta iya lashịa ibe Fero. ");
INSERT INTO izz_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero meeru Ebiramu ree l'opfu ẹhu Serayi; bya akpẹe ya atụru; kpẹe ya eswi; kpẹkwaa ya phọ oke lẹ nyee nkapfụ-ịgara; bya eduru unwoke yẹe ụnwanyi, a-nọdu ejeru iya ozi nụ iya. Ọ bya akpẹkwaa ya phọ ịnya-kamẹlu. ");
INSERT INTO izz_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tọbudu iya bụ; Chipfu bya alọru ẹjo iphe-ememe tụ Fero yẹe ndibe iya; opfu l'o dutaru nyee Ebiramu, bụ Serayi. ");
INSERT INTO izz_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Noo ya; Fero kua Ebiramu sụ iya: “?Dẹnu g'o gude i mee mu ẹgube iphe ọwa-a? ?Bụ gụnu bẹ ị tị kajẹduru mu l'ọo nyee ngu? ");
INSERT INTO izz_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","?Bụ gụnu meru iphe, ị sụru l'ọo nwune ngu nwanyị; ị haa; mu bya alụta iya lụaha? Ọle g'ọ dụhabe; waa nyee ngu baa; duta iya tụgbua!” ");
INSERT INTO izz_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fero bya asụ gẹ ndu-ozi iya chịfu Ebiramu. Ẹphe chịfu yẹle nyee ya; waa iphemiphe, o nweru. ");
INSERT INTO izz_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Noo ya; Ebiramu; waa nyee ya; waa iphemiphe, o nweru; yẹe Lọtu, ẹphe l'iya swị shi l'alị Ijiputu tụgbua lashịa echiẹgu ndọhali. ");
INSERT INTO izz_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ebiramu nwewaru iphe-edobe; waa mkpọla-ọchaa; waa mkpọla-ododo shii. ");
INSERT INTO izz_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ẹphe shi l'echiẹgu ndọhali jekpọepho; ẹphe -shi l'ẹka-a; ẹphe ejerwua l'ẹka-a; ẹphe -shi l'ẹka; ẹphe ejerwua l'ẹka-a; gbiriri jasụ ẹphe jerwua l'ụzo isheli mkpụkpu Bẹtelu; mbụ ẹka ono, nọ lẹ mgbaka Bẹtelu yẹle mkpụkpu Eyayi ono, bụ iya bụ ẹka ẹphe kpọbejehawaru ụlo-ẹkwa phẹ-a; ");
INSERT INTO izz_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tẹme ọ bụru ẹka Ebiramu vuru ụzo kpụa ọru-ngwẹja. Ọ nọdu l'ẹka ono kpọ-kuahaa Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Noo ya; Lọtu-a, yẹle Ebiramu swị-a nwekwarụpho atụru, dụ igwerigwe; waa eswi, dụ igwerigwe; waa ụlo-ẹkwa, dụkwapho igwerigwe. ");
INSERT INTO izz_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ọphu alị ono asụedu ẹphenebo ebubu; kẹle iphe-edobe phẹ kwatakpọo paa ẹka apaa; k'ọphu bụ l'ẹphe ta adụedu ike anọkota l'ẹka lanụ. ");
INSERT INTO izz_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ọo ya bụ; ụswo daru ndu echeru Ebiramu iphe-edobe; yẹe ndu echeru Lọtu nkiya. Ndu Kénanu yẹe ndu Pẹ́rezu shikwaphọ buru l'alị ono teke ono. ");
INSERT INTO izz_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","A nọnyaa; Ebiramu sụ Lọtu: “G'ụswo ta adashịnuru mu lẹ ngu; ọphu ọ dashịnuru ndu echeru ngu iphe-edobe; yẹle ndu echeru mbẹdua nkemu; eshinu mu lẹ ngu bụ abụbu. ");
INSERT INTO izz_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ị tụkoerupho alị ọbu l'ophu hụma-gbua. G'anyi ta akwọpfuheru l'ẹka lanụ. Hatakpọepho ẹkiya ọphu ịi-la je eburu. Ị -nọdu ala l'ẹka-ịcha; mbẹdua ala l'ẹka-ụtara; teke ịila l'ẹka-ụtara; mbẹdua ala l'ẹka-ịcha.” ");
INSERT INTO izz_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lọtu palia ẹnya imeli bya ahụma lẹ nsụda ẹnyimu Jiọ́danu, nọru kpaa lẹ mkpụkpu Zowa bẹ nggele dụ shii; ọ dụepho gẹ mgbabu Chipfu ono; ọzoo gẹ alị Ijiputu. Teke ono bẹ Chipfu teke emebyidu Sọdomu yẹe Gọmóra. ");
INSERT INTO izz_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tọbudu iya bụ; Lọtu gude ẹka iya hata nsụda ẹnyimu Jiọ́danu l'ophu; bya egweta lashịa ụzo ẹnyanwu-awawa. Ọ bụru iya bụ l'ụmadzu labọ ono ekekaha; ");
INSERT INTO izz_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebiramu buru l'alị Kénanu; Lọtu je ebukube mkpụkpu, nọgbaa lẹ nsụda ono. O woru ụlo-ẹkwa iya je akpọbe lẹ mgboru Sọdomu gẹdegede. ");
INSERT INTO izz_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Noo ya; ndu Sọdomu nọdu eme ẹjo-iphe; bya abụru ndu menụkaru Chipfu iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tọbudu iya bụ; Lọtu lụfuchaepho; Chipfu sụ Ebiramu: “Gbẹ l'ẹka ị nọ palia ẹnya lee l'ụzo isheli; waa l'ụzo ọhali. L'iile l'ụzo ẹnyanwu-awawa; lekwaphọ l'ụzo ẹnyanwu-arịba. ");
INSERT INTO izz_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Alị ono, ị hụmakotaru ono mgburugburu bẹ mu a-nụkota gụ l'awa ngu g'unu nweru jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mu e-me awa ngu g'ẹphe ha g'ẹja, nọ l'alị. K'ọphu bụ l'ọo onye dụru ike gụta ẹja, nọ l'alị bẹ a-dụ ike gụta awa ngu. ");
INSERT INTO izz_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Jephekọta alị ono maru ẹka o jeberu l'ogologo; l'ịimaru g'ọ habe ọsa. Noo kẹle mu a-nụkota ngu iya.” ");
INSERT INTO izz_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ọo ya bụ; Ebiramu phụta ụlo-ẹkwa iya bya eje ebukube eze oshi ndu Mamure, dọkoberu lẹ Hẹburonu. Ọ nọdu l'ẹka ono kpụaru Chipfu ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ọ bụru teke ono bẹ Amurafẹlu, bụ eze ndu Shịna; mẹ Ariyọku, bụ eze ndu Elasa; mẹ Kedolawoma, bụ eze ndu Elamu; waa Tidalu, bụ eze ndu Goyimu chịtaru ndibe phẹ tụgbua jeshia ọgu. ");
INSERT INTO izz_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ọ bụru Bira, bụ eze ndu Sọdomu; mẹ Birisha, bụ eze ndu Gọmóra; mẹ Shayinabu, bụ eze ndu Adama; mẹ Shimiba, bụ eze ndu Zebowimu; waa eze Bela, bụ iya bụ Zowa bẹ ẹphe jeru etso ọgu ọbu. ");
INSERT INTO izz_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ndu k'ikpazụ-a bya edzukọbe chịta ndibe phẹ jepfushia phẹ ọgu lẹ nsụda Sidimu, mechaarụ bụru Eze-ẹnyimu Únú. ");
INSERT INTO izz_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ọ bụru iphe, kparụ ọgu ono bụ l'ẹphe nọkotaru apha iri l'ẹbo l'ẹka Kedolawoma; o rwua lẹ k'iri l'ẹto; ẹphe kwefu ike. ");
INSERT INTO izz_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","O rwua l'apha k'iri l'ẹno; Kedolawoma yẹe ndu eze ono, wupfutaru iya nụ ono tụko je anọdu lẹ Asheterotu Kaneemu lwụ-kpee ndu Rafa; bya anọdu lẹ Hamu lwụ-kpee ndu Zuzu; bya anọdukwapho lẹ Shave-Kiriyatayimu lwụ-kpee ndu Emu. ");
INSERT INTO izz_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ẹphe bya eje anọdu l'ọhu úbvú ndu Siye lwụ-kpee ndu Họru; lwụa phẹ jasụ lẹ Ẹlu-Paranu, nọ lẹ mgboru echiẹgu. ");
INSERT INTO izz_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ẹphe bya alwaphuta azụ bya eje anọdu lẹ Ẹnu-Mishipati, bụ iya bụ Kadẹshi; lwụtakota alị Amalẹku l'ophu; bya alwụ-kpee ndu Amọru, bu lẹ Hazezọnu-Tama. ");
INSERT INTO izz_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tọbudu iya bụ; eze ndu Sọdomu; mẹ eze ndu Gọmóra; mẹ eze ndu Adama; mẹ eze ndu Zebowimu; wafụa eze Bela, bụ iya bụ Zowa; wụfuta bya eje akwakaa k'ọgu lẹ nsụda Sidimu; ");
INSERT INTO izz_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kwabẹru Kedolawoma, bụ eze ndu Elamu; mẹ Tidalu, bụ eze ndu Goyimu; mẹ Amurafẹlu, bụ eze ndu Shịna; waa Ariyọku, bụ eze ndu Elasa. Ọo ya bụ; lẹ ndu eze ẹno l'etso ndu eze ise ọgu. ");
INSERT INTO izz_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nsụda Sidimu ono bẹ iduma iduma, e bvutagbaru korota dụ igwerigwe. Obe teke ndu eze Sọdomu waa Gọmóra ono; mẹ ndibe phẹ tụkoru gbalaaha agbala; o nweru ndibe phẹ ndu ọphu harụ dalahụ iya nụ. Ndu ọphu phọduru nụ gbaru laa l'úbvú úbvú. ");
INSERT INTO izz_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ndu eze ẹno ono bya atụko ẹku Sọdomu, yẹle Gọmóra; mẹ nri phẹ gweta tụgbua. ");
INSERT INTO izz_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ẹphe kpụtakwapho Lọtu, bụ nwa nwune Ebiramu yẹle ẹku iya; eshinu o bu lẹ Sọdomu. ");
INSERT INTO izz_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Onye lanụ l'ime ndu gbalarụ nụ bya epfuaru iya Ebiramu onye Hiburu. Ebiramu bu lẹ mgboru eze oshi ndu Mamure. Mamure bụkwanu onye Amọru bya abụru nwune Ẹshukolu waa Ana. Ndu ono bẹ ẹphe lẹ Ebiramu tụgbaru bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ebiramu nụmaepho l'abụbu iya bẹ a lwụtaru l'ọgu; o kua unwoke iya ụkporo ụmadzu iri l'ise l'ụmadzu iri l'ẹsato, a nwụru l'ibe iya, e ziru g'aalwụje ọgu. Ẹphe chịpyabe phẹ gbapfu phẹ lẹ Danu. ");
INSERT INTO izz_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","O -rwua l'ẹnyashi; Ebiramu bya ekekashịa unwoke iya gude tsoo phẹ ọgu; lwụ-kpee phẹ; chịa phẹ gbiriri jasụ ẹphe gbarwua Hoba, bụ isheli Damasụkosu. ");
INSERT INTO izz_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ọ natakọta phẹ ivu ono, ẹphe shi gweta ono; bya edulata abụbu iya, bụ Lọtu yẹe ẹku nkiya; waa ụnwanyi; mẹwaro ndu ọzo, ẹphe shi rwuta. ");
INSERT INTO izz_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ebiramu lwụ-kpechaa Kedolawoma yẹe ndu eze, ẹphe l'iya swị bya alwatashịa; eze ndu Sọdomu gba iya ndzuta lẹ nsụda Shave, bụ iya bụ nsụda, aza Nsụda Eze. ");
INSERT INTO izz_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Noo ya bụ; Melikizedeku, bụ eze ndu Salẹmu gude buredi; waa mẹe byapfuta phẹ. Melikizedeku ono bụ onye uke Chileke, bụ Ọkalibe-kakọta-shii. ");
INSERT INTO izz_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ọ bya agọru ọnu-ọma nụ Ebiramu sụ: “Gẹ Chileke, bụ Ọkalibe-kakọta-shii kebe gụbe Ebiramu l'ọma! Mbụ Chileke ọphu bụ iya meru igwe bya emee eliphe. ");
INSERT INTO izz_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","G'e tua Chileke, bụ Ọkalibe-kakọta-shii ẹpha! Mbụ onye ono, woru ndu ọhogu ngu ye ngu l'ẹka!” Ebiramu nụ iya oke-lanụ-l'ụzo-iri l'iphemiphe ono, o gwephutaru azụ ono; ọ nata iya. ");
INSERT INTO izz_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Eze Sọdomu sụkwanu Ebiramu g'ọ haarụ yẹbedua ndu ọphu bụ nemadzụ; gwetawarọ ọphu bụ ivu nworu. ");
INSERT INTO izz_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ebiramu sụ eze ndu Sọdomu: “Mu paliakwaru ẹka riaru Chipfu angụ; mbụ Chileke ọphu bụ Ọkalibe-kakọta-shii; onye meru igwe bya emee eliphe; ");
INSERT INTO izz_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","l'ọ tọ dụdu iphe, bụ iphe ngu, mu a-nata; mbụ m'obeta ọ bụru oghu; ọzo eri akpọkpa; g'ọ tọ dụ teke ịi-sụ l'ọo ngu meru Ebiramu; ọ baa eze. ");
INSERT INTO izz_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ọ tọ dụdu iphe, mu a-nata gbahaa ọphu ndu mu l'iya swị riwaru eriri; waa oke-iphe ọphu rwuberu ndu tso mu jee; mbụ-a; gẹ Ana; waa Ẹshukolu; waa Mamure ria oke, rwuberu phẹ nụ.” ");
INSERT INTO izz_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","E mechaa; Ebiramu nụma Opfu Chipfu l'ọphulenya. Ọ sụ iya: “Gẹ ndzụ ba agụshi ngu Ebiramu. Ọo mbẹdua bụ onye egbobutaje ngu nụ; bya abụru obunggo ngu, parụ ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ebiramu sụ: “Gụbe Nnajịuphu, bụ Chipfu; ?bụ gụnu ọzo bẹ ịi-nụ mu gẹ mu ta nwụtaduru nwa-a; tẹme onye e-mecha nwekọtaru ẹku mu bụru Eliyéza-a, bụ onye Damasụkosu-a?” ");
INSERT INTO izz_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ebiramu bya asụkwapho: “Nta-a, g'ị tị nụduru mu nwa-a bụnu ohu, a nwụru l'ibe mu e-mecha ria iphe mu.” ");
INSERT INTO izz_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tọbudu iya bụ; Chipfu sụ iya: “Onye ono ta abụkwa iya e-ri iphe ngu. Ọ kwa nwa nwoke ọphu shi ngu l'ẹhu e-ri iphe ngu ọbu.” ");
INSERT INTO izz_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ọ bya eduta iya lụfu etezi bya asụ iya: “Palia ẹnya lee l'akpaminigwe gụa kpokpode, nọ iya nụ ọgu; m'ọ bụru l'ịi-dụ ike gụkota iya.” Sụ iya: “Noo g'awa ngu a-ha bụ ono.” ");
INSERT INTO izz_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebiramu kweta iphe, Chipfu pfuru. Ọ gụaru iya ya l'apfụbe-ẹka-ọto. ");
INSERT INTO izz_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ọ sụkwa iya phọ: “Ọo mbẹdua, bụ Chipfu duru ngu dufuta lẹ mkpụkpu Uru, nọ l'alị Kaludiya gẹ mu bya anụ ngu alị-a g'ọ bụru oke alị ngu.” ");
INSERT INTO izz_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ebiramu sụ: “Jiko Nnajịuphu, bụ Chipfu; ?dẹnu gẹ mu e-shi maru lẹ mu e-nweru iya?” ");
INSERT INTO izz_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Chipfu sụ iya: “Wotaru mu ada eswi; waa ada eghu; waa ebili, gbacharu apha ẹto ẹto; tẹme waa kparaka; waa ndupfu.” ");
INSERT INTO izz_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ebiramu tụko iphe ono wotaru iya; bya asụchaa ya ibe; bya ewocharu ibiribe iya ono dobegbaa g'ọ ghaaru nwibe iya iphu. Ọphu ọ sụduru ndu ọphu bụ ẹnu ibe. ");
INSERT INTO izz_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ẹnu, erije anụ phezetagbaa g'ẹphe vụka anụ ono; Ebiramu chịfu phẹ. ");
INSERT INTO izz_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ẹnyanwu nyịhujeepho; oke mgbẹnya tụ Ebiramu. Ọchii sọ-kputa iya. Ọchii ono agba ntụmatu; tẹme ọ nọdu anyị ishi ẹdzu. ");
INSERT INTO izz_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Chipfu bya asụ iya: “G'o doo ngu ẹnya ree l'oshilọkpa ngu bẹ e-mecha bụru nlwamụlwa l'alị, abụdu nkephẹ; l'eemee phẹ ohu kpaa phẹ ẹhu l'ẹka ono ụnu apha. ");
INSERT INTO izz_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","E -mechaa ẹphe evuru ẹku, ha shii lwa. Ọle ọha ono, ẹphe shi ejeru ozi ono bẹ mu a-nụkwanu aphụ. ");
INSERT INTO izz_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Obenu lẹ gụbedua bẹ a-ka nka kaghekpọo ya akaghe. L'ịilapfu nna ngu phẹ l'ẹhu-guu; l'eelia ngu elili. ");
INSERT INTO izz_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","O -rwua l'ọgbo k'ẹno bẹ oshilọkpa ngu a-lwaphuta azụ l'ẹka-a; kẹle nta-a bẹ ẹjo-iphe, ndu Amọru eme teke ebuhudu.” ");
INSERT INTO izz_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ẹnyanwu nyịhuchaepho lẹ g'ọchii byawaru; ite, a kpọberu ọku, akpụ tụutuutuu; yẹe orọku, enwu phoophoophoo bya aghaja ibe anụ ono. ");
INSERT INTO izz_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ọ bụru lẹ mbọku ono bẹ Chipfu yẹe Ebiramu gbaru ndzụ. Ọ sụ: “Oshilọkpa ngu bẹ ya nụru alị-a; e -shi lẹ nggele Ijiputu jasụ lẹ Yufurétisu. ");
INSERT INTO izz_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Alị ọbu bụ alị ndu Kénu; mẹ kẹ ndu Kenazu; mẹ kẹ ndu Kadụmonu; ");
INSERT INTO izz_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mẹ kẹ ndu Hetu; mẹ kẹ ndu Pẹ́rezu; mẹ kẹ ndu Rafa; ");
INSERT INTO izz_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mẹ kẹ ndu Amọru; mẹ kẹ ndu Kénanu; mẹ kẹ ndu Gigashi; mẹ kẹ ndu Jiebusu.” ");
INSERT INTO izz_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tọbudu iya bụ; ọphu Serayi, nyee Ebiramu anwụtaduru iya nwa. Ọle Serayi nweru nwamgbọko, shi Ijiputu, ọ gbaru ohu, aza Hega. ");
INSERT INTO izz_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ọo ya bụ; Serayi sụ Ebiramu: “Gẹ Chipfu mewaru ọphu mu anwụtaduru nwa-a bẹ ii-jepfukwa ohu mu g'a maru ?mu e-shi iya l'ẹka nweru ụnwegirima?” Ebiramu kweta bya emee iphe, Serayi pfuru. ");
INSERT INTO izz_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ọ bụru gẹ Ebiramu buwaru l'alị Kénanu apha iri bẹ Serayi, bụ nyee ya kutaru nwamgbọko Ijiputu ono, bụ ohu iya ono kee ya; ọ lụru. ");
INSERT INTO izz_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ebiramu yẹle Hega kwaa; ọ bụru iya atsụta ime. Ọ maẹrupho lẹ ya dụwaa ime bya akpọo nwanyị, nwe iya nụ ẹbo l'afụ. ");
INSERT INTO izz_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Serayi sụ Ebiramu: “Ọ kwa gụbedua bẹ iphe-ẹhuka-a, mu eje-a shi l'ẹka. Gẹ mu kuru ohu mu kee ngu; ọ maẹrupho l'ọ dụ ime bya akpọahaa mu ẹbo l'afụ. Ọ kwa Chipfu e-kpe ikpe mu lẹ ngu.” ");
INSERT INTO izz_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ebiramu sụ Serayi: “Ohu ngu nọkwa l'ọbochi-ẹka ngu; mee ya iphe, dụ ngu ree.” Serayi kpọnwuahana Hega mkpọnwu; ọ gbalana gbafụru iya. ");
INSERT INTO izz_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tọbudu iya bụ; Ojozi Chipfu hụma Hega lẹ mgboru ọgba, nọ l'echiẹgu. Ọgba ono bụ ọgba, nọ l'agụga ụzo, shiru jeshia Shuru. ");
INSERT INTO izz_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ọ sụ: “Hega; ohu Serayi; ?i shi awe eje awe?” Hega sụ: “Mu agbalarụ onye nwe mu nụ, bụ Serayi.” ");
INSERT INTO izz_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ọo ya bụ; ojozi ono sụ iya: “La azụ lapfu onye nwe ngu nụ je ewoze onwongu alị meje iphe, ọ sụru g'i mee.” ");
INSERT INTO izz_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ojozi ono sụkwapho: “Mu e-me g'awa ngu dụ igwerigwe; k'ọphu ẹphe a-bụru agụta agụta.” ");
INSERT INTO izz_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ojozi Chipfu ono sụkwa iya phọ: “Ime ono, ị dụ ono bẹ ịi-nwụ nwa nwoke. Iphe, ịi-gụ iya bụ ‘Ishimẹlu’. Noo kẹle Chipfu nụmawaru ẹkwa ịira k'iphe-ẹhuka, iije. ");
INSERT INTO izz_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ọo-bụru onye agirigo. Ọo-nọdu etso onyemonye opfu; onyemonye etsokwa iya phọ opfu. Ẹphe l'unwune iya eburu l'ụkukanyi.” ");
INSERT INTO izz_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","O kua ẹpha Chipfu, bụ onye shi epfu eyeru iya nụ sụ: “Ị bụ Ẹlu-rọwi, bụ iya bụ Chileke ẹnya iya dụ l'ẹka mu nọ.” Noo kẹle Hega sụru: “Nta-a bẹ mu hụmawaru onye ẹnya iya dụ l'ẹka mu nọ.” ");
INSERT INTO izz_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Noo iphe, e gude gụa wẹlu ono “Bee-lahayi-rọwi,” bụ iya bụ, “ọ-dzụ-ndzụ-ele-mu-ẹnya.” Wẹlu ono nọ lẹ mgbaka Kadẹshi yẹe Bẹredu byasụ nta-a. ");
INSERT INTO izz_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E mechaa; Hega nwụaru Ebiramu nwa nwoke. Ebiramu gụa nwata ọbu “Ishimẹlu”. ");
INSERT INTO izz_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ebiramu nọwaru ụkporo apha ẹno l'apha ishii teke Hega nwụtaru iya Ishimẹlu. ");
INSERT INTO izz_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ebiramu nọepho ụkporo apha ẹno l'apha iri lẹ tete; Chipfu byapfuta iya bya asụ: “Ọ kwa mbẹdua bụ Chileke, bụ Ọkwoolemkpa. Nọdunu mu ntse g'ụta ta adụ lẹ ndzụ ngu. ");
INSERT INTO izz_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mu e-me g'ọgbandzu mu lẹ ngu vuru ire. Mu emee g'unu dụ igwerigwe shii.” ");
INSERT INTO izz_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebiramu daa kpube iphu l'alị. Chileke sụ iya: ");
INSERT INTO izz_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“A bya lẹ mbẹdua; waa iphe, mu e-me l'ọgbandzu mu lẹ ngu. Ịi-bụru nnajịoha, dụ igwerigwe. ");
INSERT INTO izz_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","E te ekubaẹdu ngu Ebiramu. Ẹpha ngu a-bụru Ébirihamu; noo lẹ mu mewaru ngu nnajịoha, dụ igwerigwe. ");
INSERT INTO izz_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mu e-me ngu g'ị zụ̀a azụ̀zù shii; mu eshi l'awa ngu mee ọha, dụ iche iche; tẹme ndu eze eshi l'awa ngu fụta. ");
INSERT INTO izz_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mu e-me ọgbandzu mu ono g'ọ bụru ọgbandzu, a-nọ ojejoje; mbụ g'ọ bụru ọgbandzu mu lẹ ngu; waa ndu a-bụru oshilọkpa ngu l'ọgbo ọphu nọ l'iphu; k'ọphu mu a-bụru Chileke ngu; waa Chileke oshilọkpa ngu. ");
INSERT INTO izz_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Alị Kénanu l'ophu; mbụ ẹka unu bụ nlwamụlwa nta-a bẹ mu a-nụ gụ l'oshilọkpa ngu; g'ọ bụru okiphe unu jasụru asụru; tẹme mu abụru Chileke phẹ.” ");
INSERT INTO izz_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Chileke sụ Ébirihamu: “A bya lẹ gụbedua; dobekwa ọgbandzu mu ono. Gụbedua l'onwongu; unu lẹ ndu a-bụru oshilọkpa ngu l'ọgbo ọphu nọ l'iphu. ");
INSERT INTO izz_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Waa iphe, gụbedua e-me gude dobe ọgbandzu mu lẹ ngu; waa oshilọkpa ngu bụ ọwa-a: Gẹ ndibe ngu ọphu bụ unwoke g'ẹphe ha bukọtaje úbvù. ");
INSERT INTO izz_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Gụbedua e-bu úbvù g'ọ bụru iphe-ọhubama, nọ l'ọgbandzu mu lẹ ngu. ");
INSERT INTO izz_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","A -gbẹkpoo nta-a bẹ iphe, bụkpoo nwa nwoke, a nwụru l'ibe ngu; ọ nọwa ujiku ẹsato bẹ ee-buje úbvù; mẹ lẹ ndu bụ awa ngu; mẹ lẹ ndu shi ọhozo, bụ ndu e gude okpoga zụta; mbụ ndu abụdu awa ngu; ");
INSERT INTO izz_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","mẹ a nwụru phẹ l'ibe ngu-o; ọzoo l'i gude okpoga ngu zụ̀a phẹ-o; g'e bufutajẹ phẹ úbvù. Ọgbandzu mu ono, iphe-ọhubama iya nọ ngu l'ogwẹhu ono a-bụru ọgbandzu ọphu a-nọ jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nwoke, bụ akpapyị; mbụ onye ebuduru úbvù; gẹ ndibe phẹ bufu iya; kẹle o mebyiru ọgbandzu mu.” ");
INSERT INTO izz_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Chileke sụkwapho Ébirihamu: “Nyee ngu, bụ Serayi ta azaẹdu Serayi. Ẹpha iya a-bụru Sera. ");
INSERT INTO izz_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mu e-kebe iya l'ọma mee ya g'ọ nwụtaru ngu nwa nwoke. Mu ekebe iya l'ọma g'ọ bụru ne, nwụru ọha, dụ iche iche; tẹme ndu eze ndiphe e-shi iya l'ẹka fụta.” ");
INSERT INTO izz_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ébirihamu kpube iphu l'alị chịa ọchi bya asụ onwiya: “?Nwoke, nọwaru ụkporo apha ise bẹ aa-nwụtaru nwa nwoke nta-a? Tọo ?Sera, nọwaru ụkporo apha ẹno l'apha iri a-gbẹkwadu nta-a nwụta nwa nwoke?” ");
INSERT INTO izz_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ébirihamu sụ Chileke: “Jiko g'ẹnya ngu dụ nụ lẹ ndzụ Ishimẹlu!” ");
INSERT INTO izz_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Chileke sụ: “Mu maru-a. Ọle nyee ngu, bụ Sera bẹ a-nwụtaru ngu nwa nwoke. Iphe ịi-gụ iya bụ Áyizaku. Mu l'iya; waa oshilọkpa iya, etso iya l'azụ bẹ mu l'ẹphe a-gba ndzụ, a-nọ ojejoje. ");
INSERT INTO izz_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ọ -bụru kẹ Ishimẹlu bẹ mu nụmawaru iphe, i pfuru. Mu kebefụtaje iya l'ọma mee ya g'ọ zụshia ka l'ọtu. Ọo-bụru nna ndu-ishi iri l'ẹbo; tẹme mu emee ya g'ọ bụru ọha, parụ ẹka. ");
INSERT INTO izz_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ọle ọgbandzu mu bụkwanu mu lẹ Áyizaku bẹ a-gba iya nụ; mbụ onye ọphu Sera a-nwụtaru ngu ẹgube nta-a apha ọzo.” ");
INSERT INTO izz_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Chileke pfuẹbechaaru Ébirihamu iphe, o pfuru iya; ọ parụ iya haa tụgbua. ");
INSERT INTO izz_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Lẹ mbọku ono gẹdegede bẹ Ébirihamu dutaru nwa iya nwoke, bụ Ishimẹlu; mẹ ndu ọzo, a nwụru l'ibe iya; mẹ ndu ọphu o gude okpoga iya zụta bushia úbvù. Iphe, bụkota unwoke, bu l'ibe iya bẹ o bukọtaru úbvù; gẹ Chileke sụru g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ébirihamu nọwaru ụkporo apha ẹno l'apha iri lẹ tete teke o buru úbvù; ");
INSERT INTO izz_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","nwa iya, bụ Ishimẹlu nọwa apha iri l'ẹto. ");
INSERT INTO izz_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","A tụko Ébirihamu; waa nwa iya, bụ Ishimẹlu bukọta úbvù l'ujiku lanụ ono. ");
INSERT INTO izz_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Unwoke, bukọta l'ibe Ébirihamu l'ophu; mẹ lẹ ndu ọphu a nwụru anwụnwu l'ibe iya; mẹ lẹ ndu ọphu a zụtaru azụta l'ẹka ndu ọhozo; bẹ yẹ l'iya tụkokwarupho bua úbvù ọbu. ");
INSERT INTO izz_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Noo ya; Chipfu bya abyapfuta Ébirihamu lẹ mgboru eze oshi ndu Mamure; lẹ g'ọ nọ anọo l'ọnu ụlo-ẹkwa iya l'echi eswe. ");
INSERT INTO izz_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ébirihamu palia ẹnya bya ahụma unwoke ẹto, pfụru l'atatiphu iya. Ọ hụmae phẹ phọ bya ezilihu l'ọnu ụzo iya gbapfushia phẹ. Ọ gbapfu phẹ bya ephozetaru phẹ. ");
INSERT INTO izz_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ọ sụ: “Jiko Nnajịuphu mu; teke mu dụ ngu l'obu; ta aghatashịnu ibe mụbe onye-ozi ngu. ");
INSERT INTO izz_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","G'e kutanụ nwa mini g'unu kwọo ọkpa tụta unme lẹ mkpula oshi-a. ");
INSERT INTO izz_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Gẹ mu chọoru unu nri g'unu ria; g'ike adụ unu; unu ejeshiwarọ iphe, unu eje; eshi ọphu unu batawaru ibe mụbe onye-ozi unu.” Ẹphe sụ iya: “Ọ dụ ree; mee g'i pfuru.” ");
INSERT INTO izz_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ébirihamu bya emee ẹgwegwa bahụ l'ụlo-ẹkwa gbapfu Sera; je asụ iya: “Ngwa; mee ẹgwegwa tụta ogbongu ukpokutu iphe, eegudeje eme buredi; tụta iya ogbongu ẹto gwọ-phube gude mee buredi.” ");
INSERT INTO izz_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ọ bya agbaru je l'ẹka eswi iya dọru; bya ahọta nwada eswi, anụ iya dụ bẹlebele je akpẹe onye-ozi iya; onye-ozi ono kpụru iya je egbua bọshia. ");
INSERT INTO izz_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ọ bya apata ẹra-eswi; yẹe manụ, e gude ẹra-eswi mee; waa nweswi ono, a bọshiru ono dobe phẹ l'atatiphu. Ẹphe nọdu eri nri ono; ọ nọ-kube phẹ lẹ mkpula oshi ono. ");
INSERT INTO izz_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ẹphe sụ iya: “?Dẹnu nyee ngu, bụ Sera?” Ọ sụ: “Ọ nọkwa l'ụlo-ẹkwa anyi l'ẹka phọ.” ");
INSERT INTO izz_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Chipfu sụ iya: “Ẹgube nta-a apha ọzo bẹ mu lwafụtajekwa azụ; ọzo bụ lẹ nyee ngu, bụ Sera bẹ a-nwụ nwa nwoke.” Sera nọ l'ọnu ụlo-ẹkwa, Chipfu gharu okotazụ ngabẹ nchị. ");
INSERT INTO izz_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ébirihamu yẹe Sera bẹ bụwaa ọgerenya bya akahụkpowaa shii; tẹme Sera nọghawa teke ogogo atsụ ime. ");
INSERT INTO izz_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sera chịa ọchi l'ime obu sụ: “?Gẹ mu gbirihucharu egbirihu; tẹme nnajịuphu mu kahụwa g'ọ kahụru phọ bẹ mu a -gbẹ nta laaru iya l'ụlo?” ");
INSERT INTO izz_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Chipfu sụ Ébirihamu: “?Bụ gụnu bẹ Sera gude chịa ọchi sụ: ‘Ya a-nwụtakwadu-a nwa nta-a; gẹ ya kahụwaru ẹgube-a?’ ");
INSERT INTO izz_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","?O nweru iphe, kpọru Chipfu ẹka ememe? Mu a-byakwa teke ono, mu tụru ọnu l'apha ọzo ono; ọzo bụ lẹ Sera e-nweru nwa nwoke.” ");
INSERT INTO izz_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ndzụ gụahaa Sera; ọ tụa ẹgo sụ: “Mu ta chịkwaru ọchi.” Ọ sụ iya: “Waawaa; ị chịcharu-a ọchi.” ");
INSERT INTO izz_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Unwoke ono gbẹshiepho alala; bya eshia ụzo Sọdomu. Ébirihamu tsoru phẹ g'o durịberu phẹ. ");
INSERT INTO izz_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Chipfu sụ: “?Mu a-nọdu awachiru Ébirihamu iphe, mu eje ememe tọo? ");
INSERT INTO izz_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Eshi ọphu Ébirihamu e-mecha bụru eze ọha, ọkpehu dụ; tẹme ọhamoha, nọ lẹ mgboko bẹ ee-gude iswi ẹhu iya kebe l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Noo kẹle mu họtawaru iya g'ọ bụru onye a-kpọ-ziru ụnwu iya ụzo; ẹphe lẹ ndibe iya ndu ọphu a-nọdu etso iya l'azụ; g'ẹphe meje iphe, mu sụru g'ẹphe meje, bụ iya bụ g'ẹphe meje iphe, pfụru ọto; waa iphe, gbaru phẹ nụ. Ọo ya bụ gẹ mu emekwanaaru Ébirihamu iphe, mu kweru iya ukwe iya.” ");
INSERT INTO izz_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ọo ya bụ; Chipfu sụ: “E chikuwaru iya lẹ mkpu shii l'iphe-ẹji ndu Sọdomu yẹe Gọmóra bẹ panụkaru ẹka. ");
INSERT INTO izz_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mu nọdu eje gẹ mu maru ?iphe-ẹji phẹ kabẹ dụ-be ẹji g'e pfuru l'ọ dụ-be? Teke ọ tọ dụdu; mu amakwarụpho.” ");
INSERT INTO izz_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Unwoke ono ghachi kwasẹru ụzo Sọdomu; obenu lẹ Ébirihamu pfụkwaduru l'iphu Chipfu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ébirihamu bya akpịritaru iya ntse bya asụ iya: “?Ii-mebyishi ndu ẹjo-iphe yẹe ndu pfụberu-ẹka-ọto tọo? ");
INSERT INTO izz_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","?Ọ -bụru lẹ ndu pfụberu-ẹka-ọto rwuru ụkporo ụmadzu labọ l'ụmadzu iri lẹ mkpụkpu ono? ?Ii-mebyishikwa iya phọ? ?Tii gudedu iswi ẹhu ụkporo ụmadzu labọ l'ụmadzu iri, pfụberu-ẹka-ọto, nọ iya nụ phọ haa ya? ");
INSERT INTO izz_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","A maru-a l'ị tịi tụdu ama eme iphe, dụ nno; mbụ g'i gbua ndu pfụberu-ẹka-ọto yẹe ndu ẹjo-iphe; ọzoo mee ndu pfụberu-ẹka-ọto g'i meru ndu ẹjo-iphe. A makwarụ-a l'i tịi tụdu ama eme iphe, dụ nno; mbụ gẹ gụbedua, bụ Onye-ikpe kẹ mgboko-a l'ophu te eme iphe, pfụru nhamụnha.” ");
INSERT INTO izz_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Chipfu sụ: “Ọ -bụru lẹ mu hụmaru ụkporo ụmadzu labọ l'ụmadzu iri, bụ ndu pfụberu-ẹka-ọto lẹ mkpụkpu Sọdomu bẹ mu e-gudekwa iswi ẹhu phẹ hakọta mkpụkpu ono l'ophu.” ");
INSERT INTO izz_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ébirihamu pfukwa ọzo sụ: “Eshinu mu gbẹnu kerebewanụ k'epfu anụ Nnajịuphu l'ẹbe adụ iphe, mu bụ gbahaa urwuku yẹle ntụ; ");
INSERT INTO izz_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","?ọ -bụkwanuru lẹ ndu ono te erwuduru ụkporo labọ l'iri; mbụ ọ -bụru l'ẹphe phọduru ụmadzu ise; tẹme ẹphe erwua ẹgube ono-ee?” Chipfu sụ: “Mu -hụma ụkporo ụmadzu labọ l'ụmadzu ise l'ẹka ono bẹ mu te emebyikwa iya.” ");
INSERT INTO izz_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ébirihamu bya epfua ọzo sụ: “?Ọ -bụkwanuru ụkporo labọ damu bẹ ị hụmaru-ee?” Ọ sụ: “Mu egude nụ iswi ẹhu ụkporo ụmadzu labọ ono haa ya ememe.” ");
INSERT INTO izz_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ébirihamu sụ: “Jiko g'ẹhu te eghukwa gụbe Nnajịuphu eghu; gẹ mu pfubarọ: ?ọ -bụkwanuru ụkporo ụmadzu l'ụmadzu iri bẹ a hụmaru l'ẹka ono-ee?” Ọ sụ: “Mu te emebyikwa iya mẹ mu hụma ụkporo ụmadzu l'ụmadzu iri l'ẹka ono.” ");
INSERT INTO izz_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ébirihamu sụ: “Eshinu mu gbẹnu kerebewanụ k'epfu eyeru Nnajịuphu; ?ọ -bụkwanuru ụkporo ụmadzu kpoloko bẹ a hụmaru l'ẹka ono-ee?” Ọ sụ: “Mu egude iswi ẹhu ụkporo ụmadzu ono haa ya emebyi.” ");
INSERT INTO izz_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ébirihamu sụ: “Jiko Nnajịuphu; g'ẹhu te eghukwa ngu eghu; gẹ mu jịfua nwa ajị lanụ: ?ọ -bụkwanuru ụmadzu iri kpoloko bẹ a hụmaru l'ẹka ono-ee?” Ọ sụ: “Mu egude iswi ẹhu ụmadzu iri ono haa ya emebyi.” ");
INSERT INTO izz_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Chipfu yẹle Ébirihamu pfughechaẹpho ọ tụgbua; Ébirihamu lashịa unuphu. ");
INSERT INTO izz_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ojozi labọ ono jerwua Sọdomu l'ụzenyashi. Ẹphe jeshia; Lọtu nọdu anọo l'ọnu-abata mkpụkpu ono. Ọ hụmae phẹ phọ bya agba phẹ ndzuta; bya ephozetaru phẹ woru iphu kpube l'alị. ");
INSERT INTO izz_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ọ sụ phẹ: “Nnajịuphu mu; mu arwọ unu g'unu batarọ l'ụlo mụbe onye-ozi unu; bya akwọo ọkpa unu; unu akwaa ibe mu; o -rwua l'ụtsu; unu atụgbuwaro jeshia iphe, unu eje.” Ẹphe sụ waawaa; l'ẹphe a-kwa l'ụzo l'ẹnyashi ono. ");
INSERT INTO izz_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ọ rwọo phẹ rwọshia phẹ ike gbiriri jasụ ẹphe tsoru iya bahụ ibe iya. Ọ bya akwaaru phẹ eze ẹbyaa; mbụ gheeru phẹ buredi, e yedụru iphe, ekoje buredi; ẹphe taa. ");
INSERT INTO izz_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ẹphe bya ala l'ụlo; unwoke, shigba l'ẹkameka lẹ mkpụkpu Sọdomu; ẹgirima mẹ ọgerenya; bya asọ-phee ụlo ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ẹphe bya ekua Lọtu sụ iya: “?Dẹnu unwoke, bataru ibe ngu l'ụzenyashi-a? Chịfuta phẹ chịtaru anyi g'anyi l'ẹphe kwaa!” ");
INSERT INTO izz_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọtu bya alụfu etezi bya eworu ụzo gụ-chia jepfushia phẹ bya asụ: ");
INSERT INTO izz_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Jiko ndu mu; unu ta akabẹshinu mee ẹjo-iphe ọwa-a! ");
INSERT INTO izz_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Unu hụma lẹ mu nweru ụnwumgboko labọ, ẹphe l'unwoke teke akwaswee; gẹ mu chịfutachiaru phẹ unu; g'unu mee phẹ iphe, dụ unu ree; g'unu haa unwoke-a; l'ẹphe bụ ẹbyaa mu.” ");
INSERT INTO izz_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ẹphe sụ iya g'ọ gbalẹshikwaru phẹ l'ụzo; sụ: “Ọo gụbe nlwamụlwa a-bya atụaharu anyi ekemu; anyi e-mekwa ngu ọphu ka nkephẹ njọ.” Ẹphe nwuribẹru Lọtu; bya akpịritaru g'ẹphe gbajaa mgbo ono. ");
INSERT INTO izz_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Unwoke labọ ono machịepho ẹka lọbata Lọtu l'ụlo; bya eworu ụzo ono gụ-chia. ");
INSERT INTO izz_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ẹphe mee; ndu ono, pfụru l'ọnu mgbo ono tsụahaa ishi; ẹgirima mẹ ọgerenya; k'ọphu ẹphe ta ahụmaeduru ọnu mgbo ono. ");
INSERT INTO izz_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Unwoke labọ ono sụ Lọtu: “?O nweru onye ọzo, i nweru l'ẹka-a? ?O nweru ndu i keru nwanyị; ọzoo ụnwu ngu k'unwoke; ọzoo ụnwanyi; ọzokwanu l'ọ dụru ndu ọzo, bu lẹ mkpụkpu-a, bụ ndu gụ l'ẹphe bụ? Tụkokwa phẹ dufuta l'ẹka-a! ");
INSERT INTO izz_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Noo kẹle anyi abyakwa emebyi ẹka-a. E chikuwaru Chipfu lẹ mkpu shii l'ẹjo-iphe ndu ẹka-a pawaru ẹka; o zia anyi g'anyi bya emebyishia ya.” ");
INSERT INTO izz_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ọo ya bụ; Lọtu tụgbunaa bya eje epfuchaaru iya ndu ẹphe l'iya gba l'ọgo, bụ ndu abya alụ ụnwada iya; sụ phẹ: “Unu medụpho ẹgwegwa fụta lẹ mkpụkpu-a; noo lẹ Chipfu abyakwa iya emebyishi.” Ọle ndu ọgo iya rịru l'ọo mgbọnu bẹ ọogbaru phẹ. ");
INSERT INTO izz_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","O be lẹ gẹregere nchi-abọhu; ojozi ono lwụaharu Lọtu ụlwu sụ iya: “Mee ẹgwegwa duta nyee ngu; waa ụnwumgboko labọ ibe ngu, bụ ndu ọphu nọ l'ẹka-a! Ọdumeka bẹ unu a-lakwa l'iyi teke aa-nụ mkpụkpu-a chịipfuu.” ");
INSERT INTO izz_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","O jeshia abyịbyibe; unwoke ono kpụta iya l'ẹka; bya akpụta nyee ya; yẹle ụnwumgboko ibe iya ẹphenebo; kpụfu lẹ mkpụkpu ono; noo kẹle Chipfu aphụru phẹ obu-imemini. ");
INSERT INTO izz_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ẹphe kpụfutachae phẹ phọ; onye lanụ sụ phẹ: “Unu gbaa ọso ndzụ unu! Unu ta aghakwa ẹnya l'azụ; ọphu unu ejekwa apfụru apfụru lẹ nsụda! Unu gbakwarụ laa l'úbvú! Ọdumeka bẹ unu a-lakwa l'iyi!” ");
INSERT INTO izz_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lọtu sụ phẹ: “Waawakwa; jikonu nnajịuphu mu phẹ! ");
INSERT INTO izz_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Eshi ọphu mụbe onye-ozi unu dụ unu l'obu; unu goshiwa l'unu yeru mu obu ọkpobe eyeye; k'ọphu unu dzọru ndzụ mu; gẹ mu te jeshinu agba ala l'úbvú! Ọdumeka bẹ ẹjo iphe-ẹhuka ono a-byapfutakwa mu; mu anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Unu lekpọdapho! O nweru mkpụkpu, nọ-a lẹ mgboru ẹka-a, dụa ntse k'ọphu mu a-gbaru laa ya; tẹme ọ ha nwanshịi. ?Unu te eledu ẹnya lẹ mkpụkpu ọbu ta abadu ishi? Gẹ mu gbanụru laa ẹka ono; k'ọphu mu a-nọdu ndzụ.” ");
INSERT INTO izz_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ọ sụ iya: “Ọ dụepho ree; mu e-kwetaẹpho iphe, ị rwọru; mu te emebyishidu mkpụkpu k'ono, iipfu opfu iya ono. ");
INSERT INTO izz_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ọle ọ bụ; gbaru laa ẹka ono ẹgwegwa! Noo kẹle o to nwedu iphe, mu e-me gbiriri jasụ l'i jerwua ẹka ono.” Noo iphe ono meru g'o gude e kua mkpụkpu ono Zowa. ");
INSERT INTO izz_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lọtu gbarwushia Zowa; ẹnyanwu nọdu aawatakpoẹpho awata. ");
INSERT INTO izz_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Chipfu dzee ọku nshị-egbe gẹ mini lẹ Sọdomu yẹle Gọmóra; mbụ o shi l'ẹka Chipfu ọphu nọ l'imigwe. ");
INSERT INTO izz_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ọ bya atụko mkpụkpu ono; mẹ nsụda ono l'ophu mebyishikọta; bya emebyishikwaphọ iphe, bụ ndu bukọta lẹ mkpụkpu ono; mẹ iphe, futaru efuta, dzụ ndzụ l'alị ono. ");
INSERT INTO izz_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nyee Lọtu ghaa ẹnya l'azụ; ọ ghọo obvudu únú. ");
INSERT INTO izz_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","L'ọnmewa ụtsu mbọku ono Ébirihamu tehu; bya ejeshia l'ẹka o shi pfụru l'atatiphu Chipfu phọ. ");
INSERT INTO izz_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ọ gbẹ l'ẹka ono lee ẹnya lẹ Sọdomu yẹle Gọmóra; bya elekọta ẹnya lẹ nsụda ono l'ophu. Ọ bụerupho iphe, ọ hụmaru bụ ẹnwuru-ọku, akpụ kẹ tụutuutuu g'ẹka ọku enwu phoophoophoo. ");
INSERT INTO izz_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ọo ya bụ; lẹ gẹ Chileke mebyishiru mkpụkpu ono, nọ lẹ nsụda ono bẹ ọ nyatarụ Ébirihamu bya edufuta Lọtu lẹ mkpụkpu, o shi buru teke o meru gẹ mkpụkpu ono bụru ọla l'iyi. ");
INSERT INTO izz_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lọtu yẹ l'ụnwada iya nọnyaa bya ahaa Zowa je eburu l'úbvú; noo kẹle ndzụ ebu lẹ Zowa nọnyaru gụahaa ya. Ẹphe l'ụnwada iya ono ẹphenebo tụgbua je eburu l'ime ọgba. ");
INSERT INTO izz_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","O -rwua ujiku lanụ; onye k'ọgerenya sụ onye kẹ nwata: “Nta-a bẹ nna anyi kahụwaru; ọphu ọ bụdu l'ọ dụru nwoke, bu l'uswe iya-a, anyi l'iya a-kwa, bụ g'eemeje iya lẹ mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","G'anyi chee nna anyi mẹe; g'anyi eje g'anyi l'iya kwaa; g'anyi shi l'ẹhu nna anyi mee g'awa anyi phọdu.” ");
INSERT INTO izz_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","L'ẹnyashi ono bẹ ẹphe cheru nna phẹ mẹe; onye k'ọgerenya je azẹe ẹphe l'iya kwaa; ọphu ọ madụ teke ọ byaru azẹ-kube iya; tẹme ọphu ọ makwaphọ teke ọ gbẹshiru. ");
INSERT INTO izz_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","O -rwua lẹ nchitabọhu iya; onye k'ọgerenya sụ onye kẹ nwata: “L'ẹnyashi ụnyaphu bẹ mu lẹ nna mu kwawaru. G'anyi chebakwaa ya mẹe ọzo l'ẹnyashi-a; g'i je g'unu l'iya kwaa. Ọo ya bụ g'anyi eshi l'ẹhu nna anyi mee g'awa anyi phọdu.” ");
INSERT INTO izz_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ẹphe bya echekwaphọ nna phẹ mẹe ọzo l'ẹnyashi ono. Onye kẹ nwata je; ẹphe l'iya kwa; ọphu ọ makwaphọ teke ọ byaru bya azẹ-kube iya; ọzoo teke ọ gbẹshiru. ");
INSERT INTO izz_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tọbudu iya bụ; Lọtu yee ụnwu iya nwanyị ono ẹphenebo ime. ");
INSERT INTO izz_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Onye k'ọgerenya bya anwụa nwoke; o woru iya gụa Mówabu. Ọ bụru iya bụ nna ndu Mówabu ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Onye kẹ nwata nwụtakwapho nwoke; o woru iya gụa Benu-Ami; ọo ya bụ nna ndu Amọnu ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ébirihamu shi l'ẹka o bu tụgbua shia ụzo echiẹgu, nọ l'ọhali; bya eje eburu lẹ mgbaka Kadẹshi yẹe Shuru; o je ebutọta lẹ Gera. ");
INSERT INTO izz_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ọ bụru l'ẹka ono bẹ Ébirihamu nọ sụ lẹ nyee ya, bụ Sera bụ nwune iya kẹ nwanyị. Abimẹleku, bụ eze ndu Gera zia; e je edutaru iya Sera. ");
INSERT INTO izz_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Obenu lẹ Chileke byapfutaru Abimẹleku lẹ nrwọ l'ẹnyashi ujiku lanụ; bya asụ iya: “Ị bụakwaa maa. Ọ bụru iphe, kparụ iya nụ bụ nwanyị ono, i dutaru ono. Nwanyị ọbu bụkwa nyee nemadzụ.” ");
INSERT INTO izz_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ọle Abimẹleku bẹ ẹphe l'iya teke akwadụ. Ọo ya bụ ọ sụ: “Nnajịuphu; ?ii-mebyishikwaphọ ọha, adụdu iphe, ẹphe meru? ");
INSERT INTO izz_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","?To pfunuru mu-a l'onwiya sụ l'ọo nwune iya nwanyị? Tọo nwanyị l'onwiya; ?ta asụnuru mu-a l'ọ kwa nwune iya kẹ nwoke? Obu gụkwaru mu ìphóró l'iphe, mu meru; tẹme iswi dụkwa mu phọ mma.” ");
INSERT INTO izz_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Chileke sụ iya lẹ nrwọ ono: “Ọ bụ eviya; mu makwarụ-a l'imeru iya l'obu, gụru ìphóró. Ọ bụru iphe ono, meru g'o gude ọphu mu ekwedu g'i meswee mu. Mbụ l'ọo iphe ono meru iphe, mu ekwedu g'i denyi iya ẹka. ");
INSERT INTO izz_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngwa; dulaaru nwoke ono nyee ya; kẹle ọ bụkwa onye mpfuchiru. Oo-pfuru-a nụ mụbe Chileke l'iswi ẹhu ngu g'ị nọdu ndzụ. Teke i ti duladuru iya; makwarụ lẹ gụbedua; unu lẹ ndibe ngu bụakwaa maa.” ");
INSERT INTO izz_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","O -rwua l'ọnmewa ụtsu Abimẹleku bya ekukọ ndu-ozi iya g'ẹphe ha; bya akọkotaru phẹ iphemiphe, nwụru nụ. Ẹphe nụmae ya phọ; ndzụ rwuta phẹ. ");
INSERT INTO izz_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimẹleku kua Ébirihamu; ọ bya; ọ sụ iya: “?Bụ gụnu bẹ i meru anyi ẹgube-a? ?Bụ awe bẹ mu mesweru ngu meru g'o gude i mee g'a taa mu ụta, ha ẹgube-a; mbụ mbẹdua mu lẹ ndu nọ l'alị-eze mu? I mekwarụ mu iphe, i tigi kabẹdu mee mu!” ");
INSERT INTO izz_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimẹleku bya ajịa Ébirihamu sụ: “?Bụ gụnu kpakpọru iphe, i meru iphe ono?” ");
INSERT INTO izz_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ébirihamu sụ: “Mu rịru l'eshinu o to nwedu ndu atsụ Chileke ebvu, bu l'ẹka-a bẹ ẹphe e-gbu mu l'opfu ẹhu nyee mu. ");
INSERT INTO izz_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ọzo bụkponu lẹ-a; l'ọ kwa nwune mu gẹdegede; kẹle ọ bụkwa-a nna mu nwụru iya; ọle mu l'iya te shikwanụ lẹ ne lanụ; ọle mu alụkwanu iya alụlu. ");
INSERT INTO izz_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Chileke meẹpho gẹ mu shi l'ọkpoku nna mu bya awata aghaphe aghaphe-a; mu sụ nyee mu ono: ‘Waa g'ii-gude goshi l'i yeru mu obu baa: Iphe, bụkpoo ẹkameka anyi jeru; sụjekwa lẹ mu bụ nwune ngu.’ ” ");
INSERT INTO izz_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimẹleku bya achịta atụru; rwuta eswi; chịta ohu; unwoke mẹ ụnwanyi; tụko chịru nụ Ébirihamu; bya edulatakwaru iya phọ Sera, bụ nyee ya. ");
INSERT INTO izz_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ọ bya asụkwa iya phọ: “Wakwa alị mu baa; je eburu l'ẹka dụ ngu ree.” ");
INSERT INTO izz_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sera bẹ ọ sụru: “Mu nụakwaru nwune ngu ẹkpa mkpọla-ọchaa iri; noo iphe, mu gude mezia emeswe, e mesweru ngu l'atatiphu ndu unu l'ẹphe swị. Iswi dụkotakpo ngu mma.” ");
INSERT INTO izz_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ébirihamu pfuru nụ Chileke; Chileke bya emee Abimẹleku; mẹ unyomu iya; mẹ ụnwumgboko ndu ọphu bụ ohu iya g'ẹphe nwụshiaha ụnwu ọzobaa; ");
INSERT INTO izz_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kẹle Chipfu shi mechia ụnwanyi ibe Abimẹleku ẹkpa-nwa; ọ bụru l'iswi ẹhu nyee Ébirihamu, bụ Sera. ");
INSERT INTO izz_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Chipfu bya emeeru Sera eze-iphe-ọma, bụ g'o pfuru. Mbụ l'o meru Sera iphe, o kweru iya ukwe iya. ");
INSERT INTO izz_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sera tsụta ime bya anwụaru Ébirihamu nwa nwoke lẹ nka. Ọ bụerupho teke Chileke kweru iya ukwe iya gẹdegede bẹ a nwụru iya. ");
INSERT INTO izz_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ébirihamu woru nwa nwoke ono, Sera nwụtaru iya ono gụa Áyizaku. ");
INSERT INTO izz_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nwa iya ono, bụ Áyizaku nọepho ujiku ẹsato; Ébirihamu woru úbvù bua ya, bụ iya bụ gẹ Chileke sụru g'o meje iya. ");
INSERT INTO izz_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ébirihamu bụ iphe, ọ nọru bụ ụkporo apha ise teke a nwụru iya Áyizaku. ");
INSERT INTO izz_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sera sụ: “Chileke meakwaru gẹ mu chịa ọchi; tẹme iphe, bụkpoo onye nụmaru iya nụ bẹ mu l'iya a-tụko chịa ọchi.” ");
INSERT INTO izz_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ọ bya asụfukwapho: “?Bụ onye gege asụ Ébirihamu lẹ mu e-mecha chee nwa ẹra? Ọle mu mechalẹru-a nwụtaru iya nwa nwoke lẹ g'ọ kahụwaru akahụ-a.” ");
INSERT INTO izz_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nwata ono bya evuta; a mịfu iya ọnu l'ẹra. Ọ bụru mbọku ono, a mịfuru iya ọnu l'ẹra ono bẹ Ébirihamu shiru nri, ha shii. ");
INSERT INTO izz_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sera hụma lẹ nwa nwoke, Hega, bụ nwanyị Ijiputu nwụru Ébirihamu bẹ epfuru iya nụ. ");
INSERT INTO izz_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ọ sụ Ébirihamu: “Jekwa achịfu nwanyị-a, bụ ohu-a yẹle nwa iya; noo kẹle nwa nwanyị ono, bụ ohu ono; yẹle nwa mu, bụ Áyizaku ta agbakwarụ mgba l'ẹku ngu.” ");
INSERT INTO izz_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Iphe ono bụru aphụ tsọru Ébirihamu; kẹle ọ bụ opfu ẹhu nwa iya bẹ eepfu. ");
INSERT INTO izz_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Obenu lẹ Chileke sụru iya: “Gẹ kẹ nwata-okoro ono yẹ l'ohu ngu nwanyị ono ta abụshiru aphụ tsọru ngu. Jekwa emee iphe, Sera pfuru ngu; noo kẹle ọo Áyizaku bẹ awa ngu e-shi l'ẹka jaa. ");
INSERT INTO izz_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mu e-mekwaphọ nwatibe ohu ngu ono g'ọ bụru ọha ẹka iya; eshinu ọ bụ iphe, shi ngu l'ẹhu.” ");
INSERT INTO izz_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","O -rwua l'ọnmewa ụtsu nchita-abọhu iya; Ébirihamu bya ewota nri; bya ekuru mini ye l'akpọ, eeyeje mini woru nụ Hega. O woru iya tukobe iya l'ukuvu bya achịfu iya; ẹphe lẹ nwata-okoro ono. Ẹphe tụgbua je etsoru echiẹgu Biye-Sheba ghapheaha. ");
INSERT INTO izz_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mini, nọ l'ẹda-akpọ ono -bvụepho; o woru nwata ono nyebe lẹ mkpula irwu lanụ l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ọ tụgbua je anọdu iche lẹ mgboru ẹka ono; l'ẹka bụ; a -gbaa apfụ l'oojerwua ya. Noo kẹle ọ rịru sụ lẹ ya taa nọdudu ele nwata ono ẹnya g'ọ nwụhu. O nọdu lẹ mgboru ẹka ono bya awata ara ẹkwa. ");
INSERT INTO izz_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Chileke nụma olu nwata ono l'ẹka ọora ẹkwa. Ojozi Chileke shi l'imigwe kua Hega; bya asụ iya: “?Bụ gụnu Hega? Gẹ ndzụ ba agụshi ngu; noo lẹ Chileke nụmaru olu nwata ono lẹ g'ọ zẹ l'ẹka ono ara ẹkwa. ");
INSERT INTO izz_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Gbẹshi kulia nwata ono ekuli; gudeshia ya ẹka; kẹle mu e-me iya g'ọ bụru ọha, parụ ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Chileke bya emee; ẹnya sahụ iya; ọ hụma wẹlu, mini dụ. Ọ bya eje eworu mini kujia l'ẹda-akpọ ono; bya echebe nwata ono. ");
INSERT INTO izz_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Chileke nọ-kube nwata ono lẹ g'oovukpọepho. O buru l'echiẹgu; jasụ ọ bụru ọ-gba-apfụ. ");
INSERT INTO izz_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ọ bụru g'o bu l'echiẹgu Paranu bẹ ne iya jeru alụtaru iya nwanyị l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lẹ teke ono bẹ Abimẹleku; waa Fayịkolu, bụ onye-ishi ndu ojọgu iya sụru Ébirihamu: “Chileke nọ-kubekwa ngu l'iphemiphe, iime. ");
INSERT INTO izz_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Rinaaru mu nte l'atatiphu Chileke l'ẹka-a l'ị tị byadu agbaru mu ẹregede; ọphu ịigbaduru iya ụnwegirima ibe mu; ọzoo oshilọkpa mu. Ọ bụchia g'i goshi l'i yeru mu obu; bya eye mkpụkpu-a obu; mbụ mkpụkpu-a, ị lwarụ alwalwa-a; ẹgube ono, mu goshiru lẹ mu yeru ngu ono.” ");
INSERT INTO izz_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ébirihamu sụ: “Mu e-ri-a nte ọbu.” ");
INSERT INTO izz_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ébirihamu bya epfuaru Abimẹleku kẹ wẹlu mini, ndu-ozi Abimẹleku natarụ iya. ");
INSERT INTO izz_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimẹleku sụ: “Mu ta amakwa onye meru iya nụ; ọphu i tiki pfusweru mu iya; mu teke anụma-swekwaa ya abụdu ntanụ-a.” ");
INSERT INTO izz_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ébirihamu bya achịta atụru; rwuta eswi bya achịe Abimẹleku; ẹphenebo bya eworu ndzụ gbaa. ");
INSERT INTO izz_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ébirihamu bya ahọta ada-atụru ẹsaa l'igwe atụru iya dobe iche. ");
INSERT INTO izz_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimẹleku sụ Ébirihamu: “?Bụ gụnu meru g'o gude ị họta ada-atụru ẹsaa ono dobe iche?” ");
INSERT INTO izz_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ọ sụ: “Nggẹ ada-atụru ẹsaa-a, shi l'ẹka mu-a g'ọ bụru iphe, agba ekebe l'ọo mu tụru wẹlu-a.” ");
INSERT INTO izz_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","E woru ẹka ono gụbe Biye-Sheba; kẹle ẹka ono bẹ ụmadzu labọ ono riru nte. ");
INSERT INTO izz_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ẹphe gbachaẹpho ndzụ ono lẹ Biye-Sheba; Abimẹleku; waa Fayịkolu, bụ onye-ishi ndu ojọgu iya laphushia azụ l'alị ndu Filisitayinu. ");
INSERT INTO izz_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ébirihamu bya eworu oshi tamarisuku dzaa lẹ Biye-Sheba; bya anọdu l'ẹka ono kpọ-ku Chiojejoje, bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ébirihamu bukpọoru l'alị ndu Filisitayinu nọo ọdu. ");
INSERT INTO izz_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","E mechaa Chileke bya ahụa Ébirihamu ama. O kua ya sụ: “Ébirihamu!” Ọ za iya ẹnu. ");
INSERT INTO izz_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Chileke sụ: “Duta nwa ngu; mbụ mkpakọ nwa ngu, bụ Áyizaku, bụ onye i yeru obu gude je l'alị Moriya. Gude iya gwee ngwẹja-akpọ-ọku l'úbvú lanụ, mu e-goshi ngu.” ");
INSERT INTO izz_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ọnmewa ụtsu nchita-abọhu iya Ébirihamu gbẹshi bya edozichaa nkapfụ-ịgara iya ree. O duta ndu-ozi iya ụmadzu labọ; waa nwa iya, bụ Áyizaku. Ọ wataẹpho nkụ, sụru iya egude gwee ngwẹja-akpọ-ọku ono vuru tụgbua; ọ bụru phẹ eje ẹka ono, Chileke pfuru iya opfu iya ono. ");
INSERT INTO izz_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","O -rwua mbọku, kwe phẹ ẹto; Ébirihamu jenyaa bya apalia ẹnya hụma ẹka ono ụzenya. ");
INSERT INTO izz_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ọ sụ ndu-ozi iya ono: “Unu nọdukwa l'ẹka-a; unu lẹ nkapfụ-ịgara ono; gẹ mu lẹ nwa mu jeribẹbaaru ẹka phọ je abaarụ Chipfu ẹja lwaphuta azụ byapfuta unu.” ");
INSERT INTO izz_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ébirihamu bya apata nkụ, ee-gude gwee ngwẹja-akpọ-ọku ono woru boo nwa iya, bụ Áyizaku; yẹbedua gude ọku; yẹle mma. Ẹphenebo swịru tụgbua. ");
INSERT INTO izz_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ẹphe jenyaa; Áyizaku sụ nna iya, bụ Ébirihamu: “Nnana!” Ébirihamu sụ: “Owee nwa mu!” Áyizaku sụ: “Nkụ yẹe ọku dụwaa; obenu ?dẹnuhunu atụru, ee-gude gwee ngwẹja-akpọ-ọku ono?” ");
INSERT INTO izz_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ébirihamu sụ iya: “Nwa mu; Chileke a-nụ-a atụru, ee-gude gwee ngwẹja-akpọ-ọku ono.” Ẹphenebo kwasẹru; ọ bụru phẹ atụgbu. ");
INSERT INTO izz_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ẹphe rwuẹpho ẹka ono, Chileke pfuru iya opfu iya ono; Ébirihamu kpụa ọru-ngwẹja l'ẹka ono; bya eworu nkụ doo ya. Ọ bya ekee nwa iya, bụ Áyizaku ẹgbu bya eworu iya tụ-kobe l'eli nkụ ono. ");
INSERT INTO izz_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ọ machịa ẹka bya ewota mma g'o gude gbua nwa iya ono, bụ Áyizaku. ");
INSERT INTO izz_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ojozi Chipfu gbẹ l'imigwe kua ya oku sụ: “Ébirihamu! Ébirihamu!” Ọ za iya ẹnu. ");
INSERT INTO izz_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ọ sụ: “Te ebyikwa nwata ono ẹka! Ta adụkwa iphe, ii-me iya. Nta-a bẹ mu maru l'ịitsu Chileke ebvu; noo kẹle i ti sephuduru nwa ngu azụ; mbụ nwa ngu lanụ kpoloko.” ");
INSERT INTO izz_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ébirihamu bya apalia ẹnya; bya ahụma ebili, mpu iya kwagaru l'iphe. O je akpụta ebili ono gbua gude gwee ngwẹja-akpọ-ọku ono; parụ nwa iya ono haa. ");
INSERT INTO izz_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ọo ya bụ; Ébirihamu woru ẹka ono gụbe: “Chipfu, bụ Ọkwoolemkpa.” Gbiriri byasụ mẹ ntanụ-a bẹ aasụje: “L'eli úbvú Chipfu bẹ aa-kwọ ngu lẹ mkpa.” ");
INSERT INTO izz_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ojozi Chipfu bya eshi l'imigwe kua Ébirihamu k'ugbo ẹbo bya asụ iya: ");
INSERT INTO izz_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Mu gudeakwa onwomu ria nte. Eshi ọphu i meru iphe-a; mbụ eshi ọphu i ti sephuduru nwa ngu azụ; mbụ nwa ngu lanụ kpoloko; ");
INSERT INTO izz_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","bẹ mu kebefụtaje ngu l'ọma; bya emee g'awa ngu dụ igwerigwe gẹ kpokpode, dụ l'akpaminigwe; waa g'ẹja, dụ l'agụga-ẹnyimu. Oshilọkpa ngu bẹ l'a-nata mkpụkpu ndu ọhogu phẹ; ");
INSERT INTO izz_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","tẹme ọ bụru eri ngu bẹ ee-shi kebe ọhamoha, nọkota lẹ mgboko-a l'ọma; noo kẹle ị ngabẹru mu nchị.” ");
INSERT INTO izz_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ébirihamu bya abyapfuta ndu-ozi iya; ẹphe tụko lashịa azụ lẹ Biye-Sheba. Ébirihamu buwarurọ lẹ Biye-Sheba. ");
INSERT INTO izz_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","E mechaa; a bya epfuaru Ébirihamu sụ iya: “Milika nwụshikwaru nwune ngu, bụ Nahọ ụnwegirima unwoke. ");
INSERT INTO izz_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ọo Uzu, bụ ọkpara; Buzu bụru nwune iya nwoke; waa Kemẹlu. Kemẹlu ono mechaa bụru nna Arámu. ");
INSERT INTO izz_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","A nwụa Kẹsedu tsobe Kemẹlu; waa Hazọ; waa Piludashu; waa Jidulafu; waa Betuwẹlu.” ");
INSERT INTO izz_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwẹlu ono mechaa bya abụru nna Ribeka. Ọ bụru ụnwegirima ẹsato ono bẹ Milika nwụshiru nwune Ébirihamu, bụ Nahọ. ");
INSERT INTO izz_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Onye ọphu ọ tọo lụdu ọkpobe alụlu, ẹpha iya bụ Ruma bẹ nwụtakwaru iya phọ ụnwegirima. Ẹpha phẹ bụ Teba; waa Gahamu; waa Tahashu; waa Maka. ");
INSERT INTO izz_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera nọru ụkporo apha ishii l'apha ẹsaa. ");
INSERT INTO izz_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ọ nwụhu lẹ Kiriyatu-Araba, bụ iya bụ Hẹburonu, nọ l'alị Kénanu. Ébirihamu kwaa Sera; raa ẹkwa iya. ");
INSERT INTO izz_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ébirihamu bya agbẹshi l'agụga nyee ya ono, nwụhuru nụ ono; bya ejepfu ndu Hetu; je asụ phẹ: ");
INSERT INTO izz_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mu bụkwa nlwamụlwa; mbụ onye shi ọhozo lwapfuta unu. Jiko unu renaa mu alị; gẹ mu lia odzu nyee mu-a.” ");
INSERT INTO izz_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ndu Hetu sụ Ébirihamu: ");
INSERT INTO izz_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nnajịuphu; anyi sụru-a: ị bụkwa ọnyibe, parụ ẹka l'echilabọ anyi. Hatakpọepho ilu ndu anyi ọphu kachaa ngu ree je elia nyee ngu. O to nwedu onye ndu anyi, a-jịka sụ g'i ti lishi iya l'ilu nkiya.” ");
INSERT INTO izz_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ébirihamu bya agbalihu bya ephozeru ndu alị ono, bụ iya bụ ndu Hetu. ");
INSERT INTO izz_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ọ sụ phẹ: “Ọ -bụru l'ọ dụ unu gẹ mu lia odzu nyee mu bẹ mu sụru-a: g'unu je arwọoru mu Ẹfuronu, bụ nwatibe Zoha; ");
INSERT INTO izz_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","g'o ree mu ọgba Makupela iya phọ, nọ l'ishi alị iya ono. Unu sụ iya g'o ree mu iya ọkpobe aswa iya; g'ọ bụru ẹka ee-lije odzu l'ibe unu.” ");
INSERT INTO izz_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ẹfuronu ono, bụ onye Hetu ono bẹ ẹphe lẹ ndu ndu phẹ tụkokwaru-a nọdukota l'ẹka ono l'ọnu-abata mkpụkpu ono. Ọ raa ya arara k'ọphu ndu Hetu, byakọtaru ẹka ono nụmakotaru iya; sụ Ébirihamu: ");
INSERT INTO izz_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nnajịuphu; waawakwa! Mu sụru-a: mu pfụru l'atatiphu ndu alị mu epfu sụ g'i nwokọtaru alị ono l'ophu; nworu ọgba, nọ iya nụ. Je elia ya rọ odzu nyee ngu!” ");
INSERT INTO izz_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ébirihamu bya ephozetakwa ọzo l'atatiphu ndu alị ono; ");
INSERT INTO izz_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","bya asụ Ẹfuronu; mbụ pfua ya ndu alị ono nụma-dzuru; sụ iya: “Mu sụru-a; ọ -bụru l'ịi-nụ mu alị ọbu bẹ mu a-pfụ ngu-a okpoga l'aswa alị ọbu. Natanụ mu aswa iya; k'ọphu mu e-je elia odzu nyee mu l'ẹka ono.” ");
INSERT INTO izz_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ẹfuronu sụ Ébirihamu: ");
INSERT INTO izz_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mu sụru-a nnajịuphu; alị ono sụkwaru ụnu mkpọla-ọchaa. Ọle ọ bụ; ?bụ gụnu bụ iphe ono bụ lẹ mgbaka mu lẹ ngu? Je elia ya rọ odzu nyee ngu.” ");
INSERT INTO izz_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ébirihamu kweta iphe, Ẹfuronu hụru iya; bya eworu aswa alị ono, ọ hụru l'iphu ndu Hetu ono pfụa ya. Iphe, ọ pfụru iya bụ ụnu mkpọla-ọchaa, a tụru l'ẹkpa, e gude azụ aswa teke ono. ");
INSERT INTO izz_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ọo ya bụ; e woru alị Ẹfuronu, nọ lẹ Makupela ree Ébirihamu. Makupela ọbu nọ-kube Mamure. E reru iya alị ọbu; yẹe ọgba, nọ iya nụ; mẹcha oshi, nọ je akpaa l'oke iya. ");
INSERT INTO izz_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Iphe, bụ ndu Hetu l'ophu, bụ ndu dọru l'ọnu-abata mkpụkpu ono nọkota hụma teke e reru Ébirihamu alị ono g'ọ bụru alị iya. ");
INSERT INTO izz_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E mechaa; Ébirihamu lia nyee ya, bụ Sera l'ọgba ono, nọ l'alị Makupela ono; nọ-kubekwapho Mamure, bụ iya bụ Hẹburonu ono, nọ l'alị Kénanu ono. ");
INSERT INTO izz_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ọ bụru iya bụ lẹ ndu Hetu woru alị ọbu; yẹ l'ọgba, nọ iya nụ; bvuaru Ébirihamu; ọ bụru alị iya bya abụru ẹka ee-lije odzu. ");
INSERT INTO izz_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ébirihamu kahụwaru bụru ọgerenya shii; tẹme Chipfu kebewa iya l'ọma l'ụzomuzo. ");
INSERT INTO izz_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ọ bya ekua onye ọphu bụ onye-ishi lẹ ndu-ozi iya; mbụ onye ọphu eletakọta iphemiphe, o nweru ẹnya; bya asụ iya: “Dẹe mu ẹka l'ehe. ");
INSERT INTO izz_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Gude ẹpha Chipfu, bụ Chileke ọphu bu l'imigwe; bya eburu l'eliphe; ria nte l'ị tịi lụtaduru nwa mu Áyizaku nwanyị, shi l'ibe ndu Kénanu, anyi l'ẹphe bu l'ẹka-a. ");
INSERT INTO izz_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","L'ii-je l'alị mu; mbụ l'ibe abụbu mu gẹdegede je alụtaru nwa mu, bụ Áyizaku nwanyị.” ");
INSERT INTO izz_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Onye-ozi iya ono sụ iya: “?Ọ -bụkwanuru lẹ nwanyị ọbu te ekwedu l'ootsoru mu alwa ẹka-e; ?mu duta nwa ngu gude lashịa alị ono, i shi ono tọo?” ");
INSERT INTO izz_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ébirihamu sụ iya: “Be dutakwaphọ nwa mu laa alị ẹka ono ọzo! ");
INSERT INTO izz_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Chipfu, bụ Chileke k'imigwe, bụ onye dufutaru mu l'ọkpoku ibe nna mu; waa l'alị, a nwụru mu anwụnwu; mbụ onye pfuru yeru mu nụ; bya ekwee mu ukwe-iphe ribua ya l'angụ sụ l'awa mu bẹ ya a-nụ alị-a; Chileke ono e-zia ojozi iya g'unu l'iya swịru; k'ọphu ịi-lụta nwanyị l'ẹka ono dulataru nwa mu. ");
INSERT INTO izz_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ọ -bụru lẹ nwanyị ọbu te ekwedu ngu etsoru; ẹvu ngu ogodogo. Ọo ẹpho g'i ti dukwaru nwa mu laa alị ẹka ono ọzo!” ");
INSERT INTO izz_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ọo ya bụ; onye-ozi iya ono bya eye nnajịuphu iya ẹka l'ehe; bya eria angụ l'opfu ono. ");
INSERT INTO izz_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Onye-ozi iya ono bya achịta anụ-ije, bụ ịnya-kamẹlu nnajịuphu iya iri gude tụgbua. Nnajịuphu iya ono hakwarụpho nụ iya iphe, dụgbaa ree; o gude; ọ bụru iya eje alị Mesopotémiya. O jerwua bya abahụ mkpụkpu ẹka Nahọ bu. ");
INSERT INTO izz_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","O mee g'ịnya-kamẹlu ono g'ẹphe ha gbushichaa ikpere lẹ mgboru wẹlu, nọ l'azụ mkpụkpu ono k'ọphu ọ-nyizeta. Teke ono bụwaa ụzenyashi; bya abụru teke ụnwanyi awụfuje lẹ mkpụkpu je eseta mini. ");
INSERT INTO izz_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Tọbudu iya bụ; onye-ozi Ébirihamu ono pfuru nụ Chileke sụ: “Jiko Chipfu, bụ Chileke kẹ nnajịuphu mu, bụ Ébirihamu. Menaa g'ije mu ntanụ-a nweru ishi! Goshinu l'i yeru nnajịuphu mu, bụ Ébirihamu obu! ");
INSERT INTO izz_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mbụ-a; ọ kwa wẹlu bẹ mu nọ-kube-a; tẹme ụnwumgboko shi lẹ mkpụkpu-a wụfuta abya eseta mini. ");
INSERT INTO izz_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Menaa g'ọ bụru; teke o nweru ụnwumgboko ono onye ọphu mu sụru: ‘Jiko phozetanu ite ngu gẹ mu ngụta mini’; o -kweta chebe mu iya; bya asụ lẹ ya e-jekwa echebefua ịnya-kamẹlu mu; g'onye ono bụkwaru onye ị họtaru onye-ozi ngu, bụ Áyizaku. Noo iphe, l'e-me gẹ mu maru l'i yeru nnajịuphu mu, bụ Ébirihamu obu.” ");
INSERT INTO izz_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ọ nọdu epfukwadu anụ Chileke ono; Ribeka nọdu abyawaa yẹ l'ite, ọ nmako l'ukuvu. Ọ bụru nwatibe Bituwẹlu. Bituwẹlu bụkwanuru nwatibe Milika, bụ nyee Nahọ. Nahọ ono bụkwanuru nwune Ébirihamu. ");
INSERT INTO izz_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nwamgbọko ono nọdu ama ntụmatu; tẹme o dobe onwiya ọ̀rù; kẹle o to nwedu nwoke, yẹe ya kwajẹwaru. Ọ bya eje lẹ wẹlu ono je esejia ite iya mini nmakoru lụfuta. ");
INSERT INTO izz_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Onye-ozi ono bya emee ẹgwegwa bya agbapfu iya sụ iya: “Jiko chebenu mu mini l'ite ngu ono nwanshịi gẹ mu ngụa.” ");
INSERT INTO izz_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ọ sụ: “Ngụaro nnajịuphu mu!” Ọ bya ezia ite ono ẹgwegwa bya apata iya l'ẹka gude chebe iya mini ono. ");
INSERT INTO izz_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","O chebechaa ya mini ọbu ọ sụ: “Mu e-setafụkwaru ịnya-kamẹlu ngu g'ẹphe ngụa jasụ ẹphe angụ-dzuru iya.” ");
INSERT INTO izz_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","O mee ẹgwegwa bya awụfu mini l'ite iya ono woru ye l'iphe, eeyejeru anụ mini; bya agbaphu azụ lẹ wẹlu je esetaba mini ọzo. O seẹ ya phọ gbiriri jasụ ọ sụ-dzuru ịnya-kamẹlu ono angụngu. ");
INSERT INTO izz_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ọphu onye-ozi ono epfukpọdaru mẹ akpụru opfu lanụ. Ọ nọdu egekpọe ya phọ g'ọ maru ?Chipfu kabẹ mewaa ije iya; o nweru ishi tọo? ");
INSERT INTO izz_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ịnya-kamẹlu ono ngụghechaepho mini ọbu; nwoke ono bya achịfuta eregede-imi, e gude mkpirikpu mkpọla-ododo mee; waa mgbalẹka labọ, e gude mkpọla-ododo, ẹrwa iya dụ shẹkelu iri mee woru chiẹ ya. ");
INSERT INTO izz_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ọ jịa nwamgbọko ono sụ iya: “?Ị bụ nwatibe onye? Jiko mu sụru-a: ?o nweru ẹka anyi a-zẹ l'ibe nna ngu g'anyi je akwaa l'ẹnyashi-a?” ");
INSERT INTO izz_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ọ sụ iya: “Mu bụkwa nwatibe Bituwẹlu; nwa, Milika yeru Nahọ.” ");
INSERT INTO izz_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ọ bya epfufua ya sụ: “Anyi nweru ẹswa oyii; yẹle k'ọkponku shii; waa ụlo, ịi-kwa l'ẹnyashi-a.” ");
INSERT INTO izz_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nwoke ono bya ephureta bya abaarụ Chipfu ẹja sụ: ");
INSERT INTO izz_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“G'ajaja bụru kẹ Chipfu, bụ Chileke kẹ nnajịuphu mu, bụ Ébirihamu. Mbụ Chipfu ahadụru Ébirihamu; o yeẹ ya phọ obu g'o yeru iya ya; bya apfụshikwapho ike l'iphe, oomeru iya. A bya lẹ mbẹdua bẹ Chipfu duwaru ije durwuta ibe abụbu nnajịuphu mu phẹ.” ");
INSERT INTO izz_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nwamgbọko ono bya agbaru laa unuphu je atụko iphemiphe ono kọkotaru ndu bu l'ụlo ne iya. ");
INSERT INTO izz_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribeka nweru nwune nwoke, aza Lebanụ. Lebanụ gbagbụa jeshia nwoke ọbu ndzuta lẹ wẹlu l'ẹka ono; ");
INSERT INTO izz_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","kẹle ọ hụmaru eregede-imi phọ; waa mgbalẹka, nwune iya nwanyị gba l'ẹka; bya anụmakwapho iphe ono, Ribeka pfuru sụ l'ọo iphe, nwoke ono pfuru iya ono. Ọ tụgbua jepfushia nwoke ọbu; o jeshia ọ pfụwaru pfụ-kube ịnya-kamẹlu iya lẹ mgboru wẹlu ono. ");
INSERT INTO izz_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Tọbudu iya bụ; Lebanụ sụ iya: “Bata abata-o! Gụbe onye Chipfu gọru ọnu-ọma nụ! ?Ọ nwụru ịnwu-agha bẹ i jeru apfụru l'ẹka ono? Mu doziakwaru ngu ụlo; bya edoziwaa ẹka ịnya-kamẹlu ngu a-dọru.” ");
INSERT INTO izz_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ọo ya bụ; nwoke ono bahụ l'ụlo ono. Lebanụ bya atọshia ịnya-kamẹlu iya iphe, o shi vuru. Ọ bya achịtaru ịnya-kamẹlu ono g'ẹphe ha ẹswa oyii; waa k'ọkponku; bya apataru yẹbedua yẹe unwoke, ẹphe l'iya swị mini g'ẹphe kwọo ọkpa. ");
INSERT INTO izz_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A bya akwata nri doberu iya l'atatiphu. Ọ sụ lẹ ya te erikwa nri jasụ teke ya pfuadaru iphe, ya byaru. Lebanụ sụ iya: “Ngwanụ; pfunaa ya!” ");
INSERT INTO izz_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ọo ya bụ; ọ sụ: “Mu bụkwa onye-ozi Ébirihamu. ");
INSERT INTO izz_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Chipfu mewaru nnajịuphu mu iphe-ọma, parụ ẹka. Ọ bụwaru onye nweru iphe ntụmatu. Ọ nụru iya atụru; waa eswi; waa mkpọla-ọchaa; yẹle mkpọla-ododo; waa ohu, dụ igwerigwe; unwoke mẹ ụnwanyi; waa ịnya-kamẹlu; waa nkapfụ-ịgara. ");
INSERT INTO izz_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nyee nnajịuphu mu, bụ Sera nwụtaru iya nwa lẹ nka. Ébirihamu wowaru iphemiphe, o nweru nụkota nwata ọbu. ");
INSERT INTO izz_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nnajịuphu mu ono mee; mu riaru iya nte kweta lẹ mu ta alụtaduru nwa iya ono nwanyị, shi l'alị ono, o bu ono, bụ iya bụ alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","“Lẹ mu e-je l'ẹnya unuphu ibe nnajịuphu mu ono; mbụ l'ọkpa-ipfu iya gẹdegede; je alụtaru nwa iya ono nwanyị. ");
INSERT INTO izz_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mu jịa nnajịuphu mu ono sụ iya: ‘?Ọ -bụkwanuru lẹ nwanyị ọbu te ekwedu l'ootsoru mu alwa ẹka ono-e?’ ");
INSERT INTO izz_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ọ sụ lẹ Chipfu ono, bụ onye ono, yẹ l'iya l'anọ ono bẹ e-duru-a ojozi iya ye gẹ mu l'iya swịru; k'ọphu oo-me g'ije mu nweru ishi. Ọo ya bụ; k'ọphu mu a-lụta nwanyị, shi l'ọkpa-ipfu phẹ; waa l'ẹnya unuphu phẹ gẹdegede dulataru nwa iya nwoke. ");
INSERT INTO izz_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Lẹ mu -jekpọwaa l'ọkpa-ipfu phẹ; ọ bụru l'ẹphe jịkaru bẹ ẹnwa iya te egudehẹdu mu; l'ọoburu ẹvu mu ogodogo. ");
INSERT INTO izz_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ọ bụru iya bụ; mu byarwuta lẹ wẹlu-a ntanụ-a; mu sụ: ‘Jiko gụbe Chipfu, bụ Chileke kẹ nnajịuphu mu, bụ Ébirihamu; ọ -bụru l'ọ dụ ngu ree; jiko menaa g'ije-a, mu byaru-a nweru ishi. ");
INSERT INTO izz_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nta-a bẹ mu pfụru lẹ mgboru wẹlu-a; ọ -bụru l'o nweru nwamgbọko, byaru eseta mini; mu sụ iya: “Jiko gẹ mu ngụtanu nwa mini, ha nwanshịi l'ite ngu ono!” ");
INSERT INTO izz_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ọ -bụru l'o kwetarụ chebe mu iya; bya asụ lẹ ya e-jekwa echebefua ịnya-kamẹlu mu; g'onye ono bụkwaru onye gụbe Chipfu họtaru nwatibe nnajịuphu mu.’ ");
INSERT INTO izz_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Mu nọdu epfukwadu anụ Chileke ono l'ime obu; Ribeka nọdu abyawaa yẹ l'ite, ọ nmako l'ukuvu. Ọ bya eje lẹ wẹlu ono je eseta mini. Mu sụ iya: ‘Jiko chebenu mu mini!’ ");
INSERT INTO izz_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“O mee ẹgwegwa pazeta ite ono, ọ pa l'ukuvu ono; bya asụ mu: ‘Nggẹ; ngụa; gẹ mu je esetafụaru ịnya-kamẹlu ngu g'ẹphe ngụa.’ ");
INSERT INTO izz_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mu jịa ya sụ iya: ‘?Ị bụ nwatibe onye?’ “Ọ sụ lẹ ya bụ nwatibe Betuwẹlu, bụ iya bụ nwatibe Nahọ; onye ọphu Milika nwụtaru iya. “Mu bya eworu eregede-imi ye iya l'imi; bya agbabẹ iya echi-ẹka. ");
INSERT INTO izz_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mu bya ephureta bya abaarụ Chipfu ẹja; bya ajaa Chipfu, bụ Chileke kẹ nnajịuphu mu, bụ Ébirihamu ajaja; mbụ Chipfu, onye duru mu; mu shia ọkpobe ụzo byarwuta ẹka mu hụmaru nwamgbọko, bụ nwanwa nwune nnajịuphu mu, mu a-lụta dularu nwatibe nnajịuphu mu. ");
INSERT INTO izz_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ọ -bụru l'unu e-goshi l'unu yeru nnajịuphu mu obu; l'ọ gbaru g'o gude ire unu ẹka; unu pfunaa ya gẹ mu nụma. Teke ọ dụdu; unu pfukwaphọ; gẹ mu maru ọphu mu e-shi eshishi.” ");
INSERT INTO izz_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lebanụ yẹe Betuwẹlu yeru iya ọnu sụ: “Ọ kwa Chipfu du ngu bya; ọphu anyi enweẹkwa ọnu opfu k'asụ l'ọwa-a meru; ọphu ọwa-a emeduru. ");
INSERT INTO izz_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Wakwa Ribeka baa; duta iya gude laa g'o je alụru nwatibe nnajịuphu ngu; eshinu ọ bụ gẹ Chipfu sụru l'ọo-dụ bụ ono.” ");
INSERT INTO izz_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Onye-ozi Ébirihamu nụmaepho ọnu, ẹphe yeru; o phozetaru Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ọ bya egwefuta ngwa, e gude mkpọla-ododo; yẹe mkpọla-ọchaa mee bya achịe Ribeka; bya achịekwaa ya phọ ẹkwa. Ọ nụkwapho nwune iya; ẹphe lẹ ne iya iphe, vu oke aswa. ");
INSERT INTO izz_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ẹphe lẹ ndu ẹphe l'iya swị gbẹ teke ono bya atụko ria nri; bya angụa iphe, angụngu; bya akwaa ẹka ono l'ẹnyashi ono. Ẹphe tehuẹpho lẹ nchita-abọhu iya onye-ozi ono sụ: “Unu dukwa mu gẹ mu lashịa lapfushia nnajịuphu mu.” ");
INSERT INTO izz_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nwune nwamgbọko ono; yẹle nene iya sụ: “Kabẹnu haa g'anyi lẹ nwada anyi ọbu nọfua nwujiku iri; tẹme unu alashịwaro.” ");
INSERT INTO izz_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ọ sụkwanu phẹ: “?Unu esedekwadụ mu kẹ gụnu; l'ẹka Chipfu gbẹ mewaa ije mu; o nweru ishi? Unu hanaa gẹ mu lashịa lapfu nnajịuphu mu!” ");
INSERT INTO izz_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ẹphe sụ g'ẹphe kua nwamgbọko ono jịa ya g'o yee ọnu. ");
INSERT INTO izz_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ẹphe kua Ribeka bya ajịa ya sụ: “?Ii-tsoru nwoke-a?” Ọ sụ ee; lẹ ya e-tsoru iya-a. ");
INSERT INTO izz_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ọo ya bụ; ẹphe duru nwune phẹ nwanyị, bụ Ribeka nụ iya; ẹphe lẹ nwanyị, eleta iya ẹnya. Onye-ozi Ébirihamu ono; yẹle ndu ẹphe l'iya swị duta iya; ẹphe lashịa. ");
INSERT INTO izz_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ẹphe bya ala; ndu nwe Ribeka gọru ọnu-ọma nụ iya; sụ iya: “Nwune anyi nwanyị; jaa àjàjà ka l'ọtu! Mbụ g'awa ngu bụru agụta agụta! G'awa ngu natajẹkwa ọguzo ndu ọhogu phẹ!” ");
INSERT INTO izz_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ọo ya bụ; Ribeka yẹle ndu-ozi iya kwakọbe bya enyita ịnya-kamẹlu phẹ tsoru onye-ozi Ébirihamu ono; o duru phẹ; ọ bụru iya alala. ");
INSERT INTO izz_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Teke ono bẹ Áyizaku shiwaa lẹ Ọgba Ọ-dzụ-ndzụ-ele-mu-ẹnya abya; kẹle ẹka o bu ebubu bụ l'echiẹgu ndọhali. ");
INSERT INTO izz_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","O -rwua ụzenyashi ujiku lanụ o tsoru ọma ẹgu aghaphe. O jeshia ele ẹnya bya ahụma ịnya-kamẹlu, awụ abya nụ. ");
INSERT INTO izz_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribeka bya apalikwaphọ ẹnya hụma Áyizaku; bya eshi l'eli ịnya-kamẹlu iya pfụ-zeta. ");
INSERT INTO izz_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ọ jịa onye-ozi ono sụ iya: “?Nwoke ono, shi lẹ mgbẹgu eje abya nụ ono bụ onye?” Onye-ozi ono sụ iya: “Ọ kwa nnajịuphu mu bẹ ọ bụ.” Ọ chịta ẹkwa-ishi iya gude kpuchia onwiya. ");
INSERT INTO izz_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Onye-ozi ono bya akọkotaru Áyizaku gẹ ya gude mee ya. ");
INSERT INTO izz_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Áyizaku bya eduta iya duba l'ụlo-ẹkwa ne iya, bụ Sera. Ọ bụru iya bụ l'e kewaru iya Ribeka; ọ lụru. O yee ya obu shii. Ọ bụru iya bụ l'obu abyahụkwa bya ejizeta Áyizaku lẹ kẹ ne iya, nwụhuru nụ-a. ");
INSERT INTO izz_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ébirihamu bya alụta nwanyị ọzo, ẹpha iya bụ Ketura. ");
INSERT INTO izz_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ọ nwụtaru iya Zimuranu; waa Jiọkushanu; waa Midanu; waa Midiyanu; waa Ishibaku; waa Shuwa. ");
INSERT INTO izz_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jiọkushanu bụ nna Sheba; waa Dedanu. Ndu bụ oshilọkpa Dedanu bụ ndu Ashuru; waa ndu Letushi; waa ndu Leyumu. ");
INSERT INTO izz_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ụnwu Midiyanu bụ Ifa; waa Ife; waa Inọku; waa Abida; waa Ẹludaa. G'ẹphe hakọta tụkoru bụru ụnwu Ketura. ");
INSERT INTO izz_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ébirihamu hakọtaru Áyizaku iphemiphe, o nweru. ");
INSERT INTO izz_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ọle g'ọ nọkwadu ndzụ bẹ ọ hatarụ iphe hẹe ụnwu, ẹphe nwụtaru iya; mbụ ụnwanyi, ndu ọphu abụ-zidu unyomu iya; bya edufu phẹ; ẹphe lashịa ụzo alị ẹnyanwu-awawa; k'ọphu yẹe Áyizaku te ebuduru l'ẹka lanụ. ");
INSERT INTO izz_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iphe, Ébirihamu kpakọtaru nọo bụ ụkporo apha ẹsato l'apha iri l'ise. ");
INSERT INTO izz_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ébirihamu tụa unme ikpazụ iya bya anwụhu lẹ g'ọ kahụchawaru lịbaliba; k'ọphu ọ bụkpoo nwoke ọgerenya, apha, ọ nọru ndzụ jiru ẹpho; tẹme ọ lapfushia ndiche phẹ. ");
INSERT INTO izz_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ụnwu iya; mbụ Áyizaku yẹe Ishimẹlu lia ya l'ọgba Makupela, nọ l'alị Ẹfuronu, bụ nwatibe Zoha, onye Hetu. Ọgba ono nọ-kube Mamure. ");
INSERT INTO izz_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Alị ono bụ alị, Ébirihamu zụru ndu Hetu; ọ bụru ẹka ono bẹ e liru Ébirihamu; lia nyee ya, bụ Sera. ");
INSERT INTO izz_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ébirihamu nwụhuchaepho Chileke bya ekebekpọo Áyizaku l'ọma ẹka o bukube wẹlu Ọ-dzụ-ndzụ-ele-mu-ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Waa oshilọkpa Ishimẹlu nwa Ébirihamu; onye nwanyị, shi Ijiputu, bụ ohu Sera, ẹpha iya bụ Hega nwụtaru Ébirihamu baa: ");
INSERT INTO izz_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ọwaa bụ ụnwu Ishimẹlu lẹ g'e deru ẹpha phẹ g'a nwụru phẹ. Nebayotu bụ ọkpara Ishimẹlu. Ndu ọzo bụru Keda; waa Adụbelu; waa Mibusamu; ");
INSERT INTO izz_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","waa Mishima; waa Duma; waa Masa; ");
INSERT INTO izz_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","waa Hadadu; waa Tema; waa Jieturu; waa Nafishi; waa Kedema. ");
INSERT INTO izz_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","G'ẹphe ha tụkoru bụru ụnwu Ishimẹlu; ọ bụru phẹ bụgbaa ndu-ishi ọkpa-ipfu phẹ ono ẹphe n'iri l'ẹbo. Tẹme ọ bụru ẹpha phẹ bẹ a gụbegbaaru mkpụkpu lẹ mkpụkpu phẹ. ");
INSERT INTO izz_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Mkpakọ iphe, Ishimẹlu nọru bụ ụkporo apha ishii l'apha iri l'ẹsaa; bya atụa unme ikpazụ iya nwụhu; lapfu ndiche phẹ. ");
INSERT INTO izz_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Oshilọkpa iya shi lẹ Havila bua jasụ Shuru, nọ-kube oke alị Ijiputu; mẹ ị nọdu eje ụzo Asiriya. Ẹphe l'ụnwunna phẹ g'ẹphe ha tụko dụru l'opfu. ");
INSERT INTO izz_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Waa oshilọkpa Áyizaku, nwa Ébirihamu. Ébirihamu bụ nna Áyizaku; ");
INSERT INTO izz_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Áyizaku nọepho ụkporo apha labọ bya alụa Ribeka, nwada Betuwẹlu, onye Arámu; ẹka o shi bụ Padanu-Arámu; tẹme Ribeka ono bụru nwune Lebanụ, onye Arámu kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","A nọnyaa; Áyizaku bya epfuru nụ Chipfu l'iswi ẹhu nyee ya; noo kẹle ọ tọo tsụdu ime. Chipfu nụma epfupfu, o pfuru nụ iya; bya emee nyee ya, bụ Ribeka tsụta ime. ");
INSERT INTO izz_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ụnwegirima ono nọdu akpa onwophẹ mkpa l'ime ẹpho iya. A nọnyaa; ọ sụ: “?Bụ gụnu bẹ iphe-a l'anwụru mu ẹgube-a?” O jeshia l'ajị l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Chipfu sụ iya: “Ọ kwa mkpụkpu labọ nọ ngu l'ẹpho; mbụ l'ọha labọ e-shi ngu l'ẹhu kekahaa onwophẹ. Onye lanụ a-ka onye ọphuu ike; tẹme ọ bụru onye k'ọgerenya bẹ a-nọdu ejeru onye kẹ nwata ozi.” ");
INSERT INTO izz_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ọ gbabeẹ ya phọ l'ezeda; ọ nwụa ejima; ọ bụchaaru nwoke. ");
INSERT INTO izz_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Onye ọphu vuru ụzo fụta dụ uswe-uswe; ẹhu iya l'ophu duẹpho g'uwe-adzụ. Ọo ya bụ; ẹphe woru iya gụa Ịso. ");
INSERT INTO izz_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Anwụnwu, aanwụ iya; nwune iya nọdu etso iya; wọru iya ẹka l'ichirupfu ọkpa. Ọo ya bụ; ẹphe gụa ya Jiékọpu. Áyizaku nọwaru ụkporo apha ẹto teke Ribeka nwụtaru iya ụnwegirima ono. ");
INSERT INTO izz_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ụnwegirima ono bya evuta. Ịso bụru onye maru ẹnya nta-a; onye anọduje aghaphe l'ọma ẹgu. Jiékọpu bụkwanuru onye eme gelee; tẹme ọ nọdu anọduje anọo l'unuphu. ");
INSERT INTO izz_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Eshinu Áyizaku bụ onye anụ, shi l'ẹgbudu atsọje ntụmatu; o yee Ịso obu; Ribeka yekwanaa Jiékọpu obu. ");
INSERT INTO izz_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","O -rwua ujiku lanụ; Jiékọpu nọdu agwọ ine. Ịso shi nta-a bata; m̀bà nọdu atụ iya atụtu. ");
INSERT INTO izz_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","O sụ Jiékọpu g'ọ kọo ya ọ-cha-pfụu iphe ono, o shiberu ono ẹgwegwa; lẹ m̀bà atụkwa iya atụtu! (Noo iphe, meru g'o gude a wata iya eku Edọmu bụ ono.) ");
INSERT INTO izz_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jiékọpu sụ iya: “Ọo m'ọ bụru lẹ mu a-bụru ngu ọgerenya!” ");
INSERT INTO izz_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ịso sụ g'o lenu lẹ ya anwụhukwa anwụhu. ?Ya gude abụru ọgerenya eme gụnu? ");
INSERT INTO izz_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jiékọpu sụ iya g'o riadanaru iya angụ. Ọ bya eria angụ lẹ ya hawaru gẹ Jiékọpu bụru iya ọgerenya. ");
INSERT INTO izz_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jiékọpu bya awata buredi nụ iya; bya ekuta ine azamụ ono, ọ gwọru ono nụkwa iya phọ; o ria. O richaa ya bya angụa iphe, aangụ angụngu; ọ bụru iya atụgbu. Ọo ya bụ lẹ Ịso ta agụbeduru abụru ọgerenya iya iphe. ");
INSERT INTO izz_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A nọnyaa; ẹgu bya l'alị ono; a -gụfukwa ọphu byajẹru teke Ébirihamu nọ. Áyizaku lapfu Abimẹleku, eze ndu Filisitayinu lẹ Gera. ");
INSERT INTO izz_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chipfu byapfuta Áyizaku bya asụ iya: “Te ejekwa ala alị Ijiputu. Bukwaru l'alị ono, mu a-sụ ngu g'i buru ono! ");
INSERT INTO izz_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Butọtanu l'alị-a; hụma lẹ mu a-nọdu swiru ngu eswiru; tẹme mu ekebekwa ngu phọ l'ọma. Kẹle ọo gụbedua; gụ l'awa ngu bẹ mu a-nụkota alị-a l'ophu. Ọzo bụ l'iphemiphe, mu riru Ébirihamu nte lẹ mu e-meru iya bẹ mu e-mekọtakwa. ");
INSERT INTO izz_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mu e-me awa ngu g'ẹphe ha l'ọtu gẹ kpokpode, nọ l'akpaminigwe. Mu abya anụ phẹ alị-a l'ophu. Tẹme ọ bụru oshilọkpa ngu bẹ ee-shi l'ẹka kebe ọhamoha, nọkota lẹ mgboko l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ọ bụru iphe, kparụ iya nụ bụ lẹ Ébirihamu meru olu mu; mbụ l'o meru opfu mu. Ọ bụru iphe, mu sụru g'o mee bẹ o meru; mbụ iphe, mu tọru ọkpa iya; bya edobekọta ekemu mu.” ");
INSERT INTO izz_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ọ buru iya bụ lẹ Áyizaku eburu lẹ Gera. ");
INSERT INTO izz_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Unwoke ndu ẹka ono bya akpaahaa ya ishi nyee ya. Ọ sụ phẹ l'ẹphe l'iya bụkwa nwune. Iphe, o gude pfua nno bụ lẹ ndzụ agụ iya asụ l'ọo nyee ya. Ọ rịru lẹ ndu ẹka ono e-gbu iya nata iya Ribeka; kẹle Ribeka manụkaru mma. ");
INSERT INTO izz_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Áyizaku buẹpho ẹka ono nọo ọdu; Abimẹleku, eze ndu Filisitayinu bya epyofu ẹnya lẹ windo hụma Áyizaku ẹka yẹle nyee ya, bụ Ribeka ebvu oke ebvu. ");
INSERT INTO izz_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimẹleku bya ekua Áyizaku sụ iya: “?Ọ kwa lẹ nwanyị ono bẹ ịilu ọkpobe alụlu? ?Bụ gụnu meru g'o gude ị sụ l'ọ bụ nwune ngu?” Áyizaku sụ iya: “?Tị madụ lẹ mu arị lẹ ndzụ mu e-tuphahụ l'opfu ẹhu iya?” ");
INSERT INTO izz_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ọo ya bụ; Abimẹleku sụ iya: “?Ẹgube iphe ọwa-a, i meru anyi-a bụ gụnu? Ọme unwoke ndu anyi onye lanụ jekwanụru je ejepfu nyee ngu onoya; mẹ iishi ẹgube ono mee g'a taa anyi ụta.” ");
INSERT INTO izz_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ọo ya bụ; Abimẹleku bya atụaru ndu ẹka ono g'ẹphe ha ekemu sụ: “Onye chọru nwoke-a; ọzoo nyee ya opfu bẹ ee-gbukwa egbugbu!” ");
INSERT INTO izz_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Áyizaku bya akọbe iphe l'alị ono; bya akpata iphe, ha g'iphe, ọ kọberu l'alị apha ono mgbo ụkporo ise; noo kẹle Chipfu keberu iya l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ọ bya enweru iphe; ẹku wata iya abyaru; jasụ ọ bụru ọbaba. ");
INSERT INTO izz_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","O nweru atụru, dụ igwerigwe; bya enweru eswi; bya agbashịa ohu dobe. A nọnyaa; ndu Filisitayinu jiaharu iya ijiẹnya. ");
INSERT INTO izz_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ọo ya bụ; iphe, bụkpoo wẹlu iya, shirọ teke nna iya, bụ Ébirihamu nọ; bụ wẹlu, ohu nna iya phẹ tụshiru doberu iya; ndu Filisitayinu bya atsuchishichaa ya; mbụ gude ẹja nwuchishichaa ya. ");
INSERT INTO izz_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ọo ya bụ; Abimẹleku sụ Áyizaku: “Kwata lụfuru anyi; noo kẹle ị kariwaru anyi ẹka shii!” ");
INSERT INTO izz_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ọ bụru iya bụ lẹ Áyizaku akwafụ je akpọbe ụlo-ẹkwa iya lẹ nsụda Gera; je eburu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Áyizaku bya etsoru tụkwachaa wẹlu ono, a tụru teke nna iya, bụ Ébirihamu nọ ndzụ ono; mbụ wẹlu ono, ndu Filisitayinu nwuchishiru lẹ gẹ nna iya nwụhucharu ono. Ọ bya agụkwachaa ya ẹpha ono, nna iya shi gụshia ya ono. ");
INSERT INTO izz_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ndu ozi Áyizaku bya ebvua wẹlu lẹ nsụda ono; bya ebvuvu mini, doru risaa. ");
INSERT INTO izz_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Obenu lẹ ndu eche iphe-edobe ndu Gera; ẹphe lẹ ndu eche kẹ Áyizaku watarụ adzọ wẹlu ọbu. Ẹphe sụ lẹ mini ono bụ mini ẹphebe ndu Gera. Áyizaku woru wẹlu ono gụa Isẹku; kẹle a swọru iya ụswo. ");
INSERT INTO izz_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ẹphe bya atụa wẹlu ọzo; ndu Gera dzọpfukwaru iya phọ. Áyizaku gụa ono Sitina. ");
INSERT INTO izz_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ọ gbẹshi l'ẹka ono je atụa wẹlu ọzo; ọphu o nweẹdu onye dzọbaru ono. Ọ gụa ya Rehobotu sụ: “Nta-a bẹ Chipfu mewaru g'anyi sụsaa onwanyi l'alị-a; nọdu iya mịa amịmi g'oshi-ọmi.” ");
INSERT INTO izz_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ọ gbẹ l'ẹka ono; ọ lashịa Biye-Sheba. ");
INSERT INTO izz_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","O -rwua l'ẹnyashi ono; Chipfu byapfuta iya bya asụ iya: “Ọ kwa mbẹdua bụ Chileke kẹ nna ngu, bụ Ébirihamu. Gẹ ndzụ ta agụshi ngu; kẹle mu nọ-kube ngu. Mu e-gude iswi ẹhu onye-ozi mu, bụ Ébirihamu kebe ngu l'ọma; mee g'awa ngu ka l'ọtu.” ");
INSERT INTO izz_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Áyizaku bya akpụa ọru-ngwẹja l'ẹka ono; bya akpọ-ku ẹpha Chipfu. O woru ụlo-ẹkwa iya kpọbe. Ndu ozi iya bya eworu wẹlu tụa. ");
INSERT INTO izz_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ọ bụru teke ono bẹ Abimẹleku shi lẹ Gera kpapfuta iya; ẹphe lẹ Ahụzatu, onye agbaziru iya olu; waa Fayịkolu, onye-ishi ndu ojọgu iya. ");
INSERT INTO izz_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Áyizaku jịa phẹ sụ: “?Bụ gụnu meru iphe, unu abya ibe mu; l'ẹka mu dụ unu ashị; unu chịa mu l'alị unu-a?” ");
INSERT INTO izz_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ẹphe sụ iya: “Anyi hụmaru lẹ Chipfu nọ-kube ngu. Noo ya; anyi sụ l'ọ gbaru g'anyi lẹ ngu ria nte. G'anyi lẹ ngu gbaa ndzụ; ");
INSERT INTO izz_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","g'ọ tọ dụ iphe, ii-me anyịbe ndu Gera; ẹgube ono, adụdu iphe, anyi meru ngu ono; ọ chịa l'anyi meru ngu odoo; bya edufu ngu; ị lashịa lẹ nchị-odoo. Ọ bụru iya bụ lẹ Chipfu abya nta-a bya ekebe ngu l'ọma.” ");
INSERT INTO izz_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Áyizaku bya eshiaru phẹ nri, ha shii; ẹphe bya eria bya angụa iphe, aangụ angụngu. ");
INSERT INTO izz_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","O -rwua lẹ nchita-abọhu iya l'ọnmewa ụtsu; unwoke ono bya eworu nte ria. Áyizaku dufu phẹ; ẹphe tụgbua; ọ bụru phẹ alala lẹ nchị-odoo. ");
INSERT INTO izz_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ọ bụru mbọku ono bẹ ndu-ozi Áyizaku byaru bya epfuaru iya kẹ wẹlu phọ, ẹphe tụru phọ sụ iya l'ẹphe hụmakwaru mini. ");
INSERT INTO izz_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ọ gụa ya Sheba. Ẹpha mkpụkpu ono bụru Biye-Sheba byasụ ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ịso nọepho ụkporo apha labọ; o je alụa Jiuditu, nwada Beri, onye Hetu; bya alụkwapho Basumatu, nwada Elọnu, onye Hetu kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ẹphe bụru aphụ tsọru Áyizaku yẹle Ribeka. ");
INSERT INTO izz_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Áyizaku bụerupho ọgerenya; k'ọphu ọophuwa ragaraga; o kua Ịso, bụ ọkpara iya sụ iya: “Nwa mu!” Ọ za iya ẹnu. ");
INSERT INTO izz_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ọ sụ iya: “Nta-a bẹ mu bụakwaa nwoke ọgerenya; ọphu mu amakwa mbọku, mu a-nwụhu. ");
INSERT INTO izz_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ngwa; wota iphe, iigudeje achị nta-a; mbụ ẹda-apfụ waa apfụ ngu; gude je l'ẹgbudu je egbuaru mu anụ! ");
INSERT INTO izz_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","L'ịibya egude iya shiaru mu nri, atsọ ụtso, bụ ọphu adụje mu ree; pataru mu; gẹ mu ria gọru ọnu-ọma nụ ngu; tẹmanu mu anwụhu!” ");
INSERT INTO izz_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribeka ngabẹkpoepho nchị gẹ Áyizaku epfu eyeru nwa iya, bụ Ịso. Ịso tụgbuepho jeshia l'ẹgbudu gẹ ya gbua anụ palata; ");
INSERT INTO izz_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribeka sụ nwa iya, bụ Jiékọpu: “Mu sụru-a; mu nụmakwaru teke nna ngu shi epfu eyeru nwune ngu, bụ Ịso ");
INSERT INTO izz_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","sụ iya g'o je egbua anụ-ẹgbudu gude shiaru iya nri, atsọ ụtso gẹ ya ria; k'ọphu ya a-nọdu l'atatiphu Chipfu gọru ọnu-ọma nụ iya; tẹme ya anwụhu. ");
INSERT INTO izz_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nta-a bụ lẹ-a; nwa mu; ngabẹkpoepho nchị ree; mee iphe, mu a-sụ g'i mee! ");
INSERT INTO izz_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ngwa; je l'ẹka atụru yẹ l'eghu dọru; je ahọta ada eghu labọ, dụ ree; gẹ mu gude shiaru nna ngu nri, atsọ ụtso. Mu e-shiẹ ya phọ g'ọo-dụ iya ree. ");
INSERT INTO izz_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","L'ịikwata iya je anụ nna ngu g'o ria; k'ọphu ọo-gọru ngu ọnu-ọma iya; tẹmanu l'ọonwuhu.” ");
INSERT INTO izz_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jiékọpu sụ Ribeka, bụ ne iya: “Obenu lẹ nwune mu, bụ Ịso gbaru ẹ́jí; mbẹdua bụru onye ẹhu akwọ akwọkwo. ");
INSERT INTO izz_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","?Ọ bụkwanuru lẹ nna mu rwaru mu ẹka-e? L'ọohuma l'ọo ẹregede bẹ mu agbaru iya; l'ooworu ọnu tụa mu; mẹ ọ lashịa ọphu ọo-gọru ọnu-ọma nụ mu.” ");
INSERT INTO izz_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ne iya sụ iya: “Nwa mu; gẹ mu vutarọ ọnu ono m'ọ tụa ngu iya! Ọo ẹpho g'i mee iphe, mu sụru g'i mee-a; tụgbua je akpụtaru mu iya!” ");
INSERT INTO izz_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ọo ya bụ; ọ tụgbua je akpụtaru ne iya eghu ọbu. Ne iya bya egude iya shia nri, atsọ ụtso; shiẹ ya phọ g'ọoduje nna Jiékọpu ono ree. ");
INSERT INTO izz_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ribeka bya ewota uwe Ịso, bụ nwune Jiékọpu k'ọgerenya; mbụ uwe iya ọphu kakọta ama mma l'uwe, Ịso koberu l'ụlo iya; bya eworu yee nwa iya ke nwata, bụ Jiékọpu. ");
INSERT INTO izz_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ọ bya eworu akpọ eghu phụa ya l'ẹka; bya aphụa ya ya l'olu, bụ ẹka akwọ iya akwọkwo. ");
INSERT INTO izz_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ọ bya eworu nri ono, atsọ ụtso ono pẹe Jiékọpu; bya apẹe ya buredi, o gheru ye iya. ");
INSERT INTO izz_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jiékọpu bya aparu iya jepfu nna iya bya asụ iya: “Nnana!” Ọ za iya: “Owee nwa mu! ?Ị bụ onye?” ");
INSERT INTO izz_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jiékọpu sụ nna iya: “Ọ kwa mbẹdua, bụ Ịso; bya abụru ọkpara ngu. Mu meakwaru g'i ziru mu. Gbẹshikwa nọdu anọo taa anụ ọbu, mu gburu ọbu; g'ịigoru ọnu-ọma nụ mu.” ");
INSERT INTO izz_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Áyizaku bya ajịa ya sụ: “?Dẹnu g'i shiru gbukebewa iya ẹgwegwa ẹgube ono nwa mu?” Jiékọpu sụ iya: “Ọo Chipfu, bụ Chileke ngu meru mu; o nweru ishi.” ");
INSERT INTO izz_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Áyizaku sụ Jiékọpu: “Kpịritaekwaru gẹ mu rwaa ngu ẹka; gẹ mu maru ?ị bụ-a nwa mu Ịso tọo tị bụdu iya?” ");
INSERT INTO izz_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jiékọpu bya ejekube nna iya, bụ Áyizaku ntse. Ọ bya arwachaa ya ẹka bya asụ: “Olu-opfu ngu bụ olu Jiékọpu; obenu l'ẹka ngu bụ ẹka Ịso.” ");
INSERT INTO izz_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ọphu ọ tọ hụbeduru iya ama; noo kẹle ẹka iya dụ ẹji ẹji gẹ kẹ nwune iya, bụ Ịso. Ọ gọru ọnu-ọma nụ iya. ");
INSERT INTO izz_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ọ jịadaa ya sụ iya: “?Ị bụ-a nwa mu, bụ Ịso tọo?” Ọ sụ iya: “Ee. Mu bụkwa iya-a.” ");
INSERT INTO izz_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ọo ya bụ; ọ sụ iya: “Ngwanụ nwa mu; patanụru mu anụ, i gburu shia nri ọbu gẹ mu ria; k'ọphu mu a-gọru ọnu-ọma nụ ngu!” Jiékọpu bya apajẹru iya ya; o ria; ọ bya apataru iya mẹe; ọ ngụa. ");
INSERT INTO izz_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nna iya, bụ Áyizaku sụ iya: “Bya ẹka-a nwa mu; bya etsutsua mu ọnu!” ");
INSERT INTO izz_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ọo ya bụ; o jekube iya ntse je etsutsua ya ọnu; Áyizaku nụmaepho mkpọ, uwe iya eshi; ọ gọru ọnu-ọma nụ iya sụ iya: “Mkpọ, nwa mu eshi dụ gẹ mkpọ ẹgu, Chipfu keberu l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gẹ Chipfu shi l'imigwe kwaaru ngu iji; l'ọonu ngu ẹka mgboko kakọta ree; l'oomee g'i nweru nri yẹle mẹe nweru k'etsutsu iya. ");
INSERT INTO izz_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","G'ọha, dụ igwerigwe jeru ngu ozi! Gẹ ndiphe phozejeru ngu! L'ịiburu onye a-bụru onye-ishi unwune ngu! G'ụnwu, ne ngu nwụtaru phozejeru ngu! Gẹ ndu tụru ngu ọnu bụkwaru ndu a tụru ọnu! Ndu gọru ọnu-ọma nụ ngu abụkwanuru ndu a gọru ọnu-ọma nụ!” ");
INSERT INTO izz_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Áyizaku gọ-ghechaẹrupho Jiékọpu ọnu-ọma ono; o shiẹpho l'atatiphu nna iya tụgbua jeribẹru nwanshịi; nwune iya, bụ Ịso shi nta-a bata. ");
INSERT INTO izz_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ọ bya eshikwaphọ nri, atsọ ụtso pataru nna iya bya asụ iya: “Nnana; gbẹshi bya ataa anụ-a, mu gburu shiaru ngu-a g'ịigoru ọnu-ọma ngu nụ mu.” ");
INSERT INTO izz_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nna iya, bụ Áyizaku bya ajịa ya sụ: “?Ị bụ onye?” Ọ sụ iya: “Mu bụkwa nwa ngu nwoke; mbụ ọkpara ngu, bụ Ịso.” ");
INSERT INTO izz_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Áyizaku phụhu mebyikpọo kẹ kpaakpaakpaa bya asụ: “?Bụhunu onye gburu anụ wotaru mu; mu righeru lẹ mgboru g'ịibya-a? Mu gọakwaru ọnu-ọma nụ onye ono; mbụ l'onye ono bụakwaa onye e keberu l'ọma.” ");
INSERT INTO izz_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ịso nụmaepho opfu nna iya; ọ tụkpoo ẹkwa; chiahaa mkpu sụ nna iya: “Gọfunaaru mu ọnu-ọma; jikonu nna!” ");
INSERT INTO izz_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Áyizaku sụ iya: “Nwune ngu gudeakwa ẹregede bya anata ọnu-ọma ngu ọbu.” ");
INSERT INTO izz_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ịso sụ: “Ọo ẹpho Jiékọpu, a gụru iya bẹ gbaru iya nụ. Ọwa-a kwewa mgbo labọ, ọ ghọ-gbutaru mu. Ọ natarụ mu ọkpara, mu bụ. Ọ bya nta-a bya anatafụa mu ọnu-ọma mu.” Ọ jịa nna iya sụ iya: “?To nwekpọdaa ọnu-ọma ono ọphu i doberu mu mẹ nanụ?” ");
INSERT INTO izz_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Áyizaku sụ Ịso: “Mu meakwaru Jiékọpu g'ọ bụru nnajịuphu ngu; mu bya emekọtaakwaa ndu ẹphe l'iya bụ g'ẹphe bụru ndu-ozi iya; bya agọakwarupho ọnu-ọma nụ iya lẹ nri; waa lẹ mẹe. Nta-a bẹ o to nweẹkwa iphe, mu a-dụ ike meeru ngu nwa mu.” ");
INSERT INTO izz_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ịso nọdu epfukpọekwarupho nna iya sụ iya: “Nna; ti nwekpọdaa g'ọ ka mma l'ọo akpụru ọnu-ọma lanụ, ịi-gọru mu? Gọfunaaru mu ọnu-ọma; jikonu nna!” Ọ wata ara ẹkwa. ");
INSERT INTO izz_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nna iya, bụ Áyizaku bya eyeeru iya ọnu sụ iya: “I tii budu l'ẹka mgboko kakọta ree; ọphu i budu l'ẹka Chipfu shi l'imigwe akwa iji. ");
INSERT INTO izz_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ọo egbu mma bẹ ii-gude buru; tẹme nwune ngu bẹ ịi-nọdu ejeru ozi. Ọle a -nọnyakwanaa ọ dụ ngu ẹnyiru; L'iikwefuru iya ike; unu l'iya edokaha.” ");
INSERT INTO izz_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ịso bya akpọo Jiékọpu ashị; kẹle ọo ọnu-ọma, nna iya gege agọru nụ iya bẹ ọ gọru nụ Jiékọpu. Ọ rịa l'ime onwiya sụ: “?Ọ kwa l'oorwuwa teke aa-kwa nnana? E -mechaa bẹ mu e-woru Jiékọpu, bụ nwune mu-a gbua.” ");
INSERT INTO izz_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","E pfuẹrupho Ribeka iphe, nwa iya k'ọgerenya, bụ Ịso pfuru; o zia g'e je ekua nwa iya kẹ nwata, bụ Jiékọpu. Ọ bya; ọ sụ iya: “Lekwa lẹ nwune ngu, bụ Ịso bụkwa iphe, o gude adụ onwiya obu bụ lẹ ya e-mecha gbua ngu. ");
INSERT INTO izz_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ọo ya bụ lẹ-a; nwa mu; mekwaa iphe, mu abya epfupfu; gbalakwa ẹgwegwa lapfu nwune ne ngu, bụ Lebanụ lẹ Haranu! ");
INSERT INTO izz_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Je anọtota l'ẹka ono g'ẹhu ghubuhuada nwune ngu eghu! ");
INSERT INTO izz_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ọ -bụru l'iphe, i meru nwune ngu ghubuhuẹru iya phọ eghu; ọ zọhaa ya; mu ezia ozi sụ g'i shi l'ẹka ono lwatashịa. Kẹle mu ta ahadụ gẹ ndzụ unu n'ẹbo tuphashịhu l'eswe ujiku lanụ.” ");
INSERT INTO izz_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Noo ya bụ; Ribeka bya ejepfu Áyizaku je asụ iya: “Anọdu ndzụ dụkwaa mu ẹnyiru; ọ bụru ụnwanyi ndu Hetu-a kparụ iya. Ọ -bụru lẹ Jiékọpu lụtafuaru ụnwanyi ndu alị-a; mbụ ụnwanyi ndu Hetu, dụ gẹ ndu ọwa-a; bẹ ?mu a-nọdukwadu ndzụ eme gụnu?” ");
INSERT INTO izz_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ọ bụru iya bụ lẹ Áyizaku bya ekua Jiékọpu; bya agọru ọnu-ọma nụ iya; bya atụaru iya ekemu sụ iya: “Ta alụnupho nwanyị Kénanu! ");
INSERT INTO izz_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tụgbuekwapho jeshia Padanu-Arámu jepfu ndibe nna ngu oche, nwụru ne ngu, bụ Betuwẹlu; je alụtaru onwongu nwanyị l'ẹka ono; lụta nwada Lebanụ, bụ nwune ne ngu! ");
INSERT INTO izz_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gẹ Chileke, bụ Ọkwoolemkpa kebe ngu l'ọma; mee ngu g'ị nwụshia ụnwu; bya emee g'ị jaa àjàjà gbiriri jasụ ịiburu nna ọha, dụ igwerigwe. ");
INSERT INTO izz_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Gẹ Chileke mee g'ọnu-ọma ono, ọ gọru nụ Ébirihamu ono; ree l'ẹhu ngu mẹ l'awa ngu. Ọo ya bụ; k'ọphu ii-nweru alị ono, ị bụ nlwamụlwa ono; mbụ alị ono, Chileke nụru Ébirihamu ono.” ");
INSERT INTO izz_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ọo ya bụ; Áyizaku bya edufu Jiékọpu; ọ tụgbua jeshia Padanu-Arámu. Ọ bụru ibe Lebanụ bẹ ooje, bụ iya bụ nwatibe Betuwẹlu, onye Arámu. Lebanụ ono bụ nwune Ribeka, bụ ne Jiékọpu yẹle Ịso. ");
INSERT INTO izz_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","E mechaa; Ịso bya amaru lẹ Áyizaku gọwaru ọnu-ọma nụ Jiékọpu; bya edufuwa iya g'ọ laa Padanu-Arámu; je alụta nwanyị l'ẹka ono; tẹme lẹ teke ono, ọ gọru ọnu-ọma nụ iya ono bẹ ọ tụru iya ekemu sụ g'ọ tọ lụkwa nwanyị Kénanu; ");
INSERT INTO izz_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","tẹme waa lẹ Jiékọpu mewaru iphe, ne iya yẹle nna iya pfuru iya bya ejeshiwa Padanu-Arámu. ");
INSERT INTO izz_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ọ gbẹ teke ono bya edoo Ịso ẹnya l'ọ dụ nna iya, bụ Áyizaku ẹji; mbụ ụnwanyi, shi l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ọ tụgbua je l'ibe Ishimẹlu; bya alụa Mahalatu, bụ nwune Nebayotu; bya abụru nwada Ishimẹlu, bụ nwatibe Ébirihamu; je eyekọberu ụnwanyi ọphu o shi alụhawa. ");
INSERT INTO izz_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Tọbudu iya bụ; Jiékọpu shi lẹ Biye-Sheba tụgbua; ọ bụru iya eje mkpụkpu Haranu. ");
INSERT INTO izz_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","O jenyaa; nchi jipfu iya l'ẹka lanụ. Ọ pfụshi l'ẹka ono gẹ ya kwaa akwakwa. O je apata mkpuma lanụ l'ẹka ono bya eswibe l'ishi zezeta; mgbẹnya tụ iya. ");
INSERT INTO izz_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ọ bya arwọo nrwọ bya ahụma obebe, a sụberu ọkpa iya l'alị; o je eberu l'imigwe. Ụnwu ojozi Chileke nọdu enyi iya godogodo; ndu enyihu enyihu; ndu enyizeta enyizeta. ");
INSERT INTO izz_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Chipfu pfụru l'ọnonu iya pfua sụ: “Ọ kwa mu bụ Chipfu; bya abụru Chileke kẹ nna ngu, bụ Ébirihamu; yẹle Áyizaku. Alị ono, ị zẹ l'eli iya ono bẹ mu a-nụ unu l'awa ngu. ");
INSERT INTO izz_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Oshilọkpa ngu a-dụ igwerigwe g'ẹja, nọ l'alị. Unu e-bucha burwua ụzo ẹnyanwu-arịba; bya eburwua ụzo ẹnyanwu-awawa; unu ebua jasụ l'ụzo isheli; bua jasụ ụzo ọhali. Mu e-shi unu l'awa ngu l'ẹka kebe ndiphe l'ophu l'ọma. ");
INSERT INTO izz_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tẹme; hụmakpodapho; mu swikwaru ngu eswiru; mu a-nọdukpoepho eleta ngu ẹnya l'iphe, bụkpoo ẹkameka iije; ọzo bụ lẹ mu e-duphuta ngu azụ l'alị-a. Mu ta abyadụ aha ngu jasụ mu emekọta iphe, mu kweru ukwe iya.” ");
INSERT INTO izz_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jiékọpu shiẹpho lẹ mgbẹnya tehu; bya asụ: “Aha! ?Bụ iya bụ lẹ Chipfu nọ l'ẹka-a; ọphu mu eshidu maru?” ");
INSERT INTO izz_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ndzụ nọdu agụ iya. Ọ sụ: “Ẹka-a bẹ akpabiri iya dụkwa! Ẹka-a te nwekwa iphe ọzo, ọ bụ; abụdu ụlo Chileke. Ọ kwa ẹka-a bụ ẹka eeshije bahụ l'imigwe!” ");
INSERT INTO izz_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","O -rwua l'ọnmewa ụtsu lẹ nchita-abọhu iya; Jiékọpu bya ewota mkpuma ono, o shi swibe l'ishi ono; bya akpọbe g'itso; o woru manụ wụshi iya l'eli. ");
INSERT INTO izz_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ọ gụa ẹka ono Bẹtelu; obenu iphe, e shi ekuje iya bụ Luzu. ");
INSERT INTO izz_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jiékọpu bya eribua nte sụ: “Chileke -swikpọwaru mu eswiru; eleta mu ẹnya l'ije-a, mu eje-a; bya anụkota mu nri; yẹ l'iphe, eeye l'ẹhu; mẹ k'anma l'upfu; ");
INSERT INTO izz_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","k'ọphu bụ lẹ mu lwarụ l'ibe nna mu l'ẹhu-guu; bẹ mu e-mekwa Chipfu g'ọ bụru Chileke mu! ");
INSERT INTO izz_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mkpuma-a, mu pfụberu g'itso-a bẹ a-bụru ụlo Chileke; tẹme iphemiphe, gụbe Chipfu nụkotaru mu bẹ mu a-nụje ngu oke-lanụ-l'ụzo-iri.” ");
INSERT INTO izz_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jiékọpu tụgbukwa jeshia iphe, ooje; o jee gbiriri jasụ o jerwua alị ndu ụzo ẹnyanwu-awawa. ");
INSERT INTO izz_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","O -rwua l'ẹka ono; ọ hụma wẹlu, nọ l'ọma ẹgu; waa ikpo atụru ẹto, dọru lẹ mgboru iya; noo kẹle atụru ono angụje mini lẹ wẹlu ono. Mkpuma, e gude swichia ọnu wẹlu ono ha shii. ");
INSERT INTO izz_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ọ nọdu abụjeru; atụru ono -dzukọepho l'ẹka ono; ndu eche iya nụ abya atụko swifu mkpuma ono l'ọnu wẹlu ono seta mini doberu atụru ono. Ẹphe -mechaa; ẹphe abya eswita mkpuma ono dobe l'ẹka o shi dụ l'ọnu wẹlu ono. ");
INSERT INTO izz_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jiékọpu bya ajịa ndu eche atụru ono sụ: “Unwune mu; ?bụ awe bẹ unu shi?” Ẹphe sụ iya l'ẹphe shikwa Haranu. ");
INSERT INTO izz_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ọ sụ phẹ: “?Unu maru Lebanụ, nwanwa Nahọ?” Ẹphe sụ ee; l'ẹphe makwarụ iya. ");
INSERT INTO izz_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jiékọpu sụ phẹ: “?Ẹhu dụ iya-a ree?” Ẹphe sụ iya: “Ee; ẹhu dụkwa iya-a ree; tẹme l'ọ kwa nwada iya, bụ Rechiẹlu chị atụru abya phọ.” ");
INSERT INTO izz_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ọ sụ phẹ: “?Unu te eledu l'ẹnyanwu dụkwadu shii? L'o toko rwudu teke aachịkobeje atụru. Unu setanụ mini doberu atụru ọbu g'ẹphe ngụa; g'unu achịru phẹ jebaa lẹ nri!” ");
INSERT INTO izz_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ẹphe sụ iya: “Anyi ta adụkwa ike. Ọ kwa a -chịkobechaa atụru ono g'ọ ha; l'aabya eswifu mkpuma l'ọnu wẹlu ono; tẹmanu l'aawata eche atụru mini teke ono.” ");
INSERT INTO izz_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ọ nọdukwadu epfu eyeru phẹ; Rechiẹlu chịru atụru ibe nna iya gude bya; noo kẹle ọ bụ nwamgbọko, eche atụru. ");
INSERT INTO izz_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jiékọpu hụmaepho Rechiẹlu, bụ nwada Lebanụ, onye bụ nwune ne iya; waa atụru Lebanụ; ọ tụgbua je eswifu mkpuma ono l'ọnu wẹlu ono; bya eseta mini doberu atụru nwune ne iya ono; ọ ngụa. ");
INSERT INTO izz_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jiékọpu bya etsutsua Rechiẹlu ọnu; bya awata arashị ẹkwa ike. ");
INSERT INTO izz_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ọ bya epfuaru Rechiẹlu l'ẹphe lẹ nna iya bụkwa; mbụ lẹ ya bụkwa nwatibe Ribeka. Rechiẹlu gbagbụa je akọoru iya nna iya. ");
INSERT INTO izz_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lebanụ nụmaepho kẹ Jiékọpu, bụ nwa nwune iya; ọ gbapfushia ya. Ọ bya etsutsua ya ọnu; bya eduta iya lashịa ibe iya. E rwua ibe iya; Jiékọpu woru iphemiphe kọkotaru iya. ");
INSERT INTO izz_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lebanụ sụ iya “Mu lẹ ngu bụkwa mee lanụ.” Tọbudu iya bụ; ẹphe lẹ Jiékọpu nọepho ọnwa ophu; ");
INSERT INTO izz_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lebanụ sụ iya: “Ọ tọ bụdu lẹ mu lẹ ngu bụ abụbu bụ iphe, a-kpata g'i jejeru mu ozi kẹ mmanụ. Kọoru mu iphe, mu a-pfụje ngu aswa ozi ngu!” ");
INSERT INTO izz_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Noo ya; Lebanụ nwụtaru ụnwumgboko labọ. Ẹpha onye k'ọgerenya bụ Lii; ẹpha onye kẹ nwata bụ Rechiẹlu. ");
INSERT INTO izz_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lii bẹ ẹnya dụ rogoro rogoro; Rechiẹlu nọdu ama mma bya adụ ùbvù l'ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jiékọpu yeru Rechiẹlu obu. Ọo ya bụ; ọ sụ Lebanụ: “Gẹ mu jenaaru ngu ozi apha ẹsaa; g'i kee mu nwada ngu, bụ Rechiẹlu.” ");
INSERT INTO izz_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lebanụ sụ iya: “Ọ kabakwanụ ree lẹ mu keru ngu iya eme lẹ mu woru iya kee akataka onye ọzo. Ngwa; g'anyi lẹ ngu bunuru.” ");
INSERT INTO izz_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ọo ya bụ; Jiékọpu bya ejee ozi apha ẹsaa g'e kee ya Rechiẹlu. Apha ẹsaa ono dụe ya phọ gẹ nwujiku olemole; noo kẹle o yeru Rechiẹlu obu shii. ");
INSERT INTO izz_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ọo ya bụ; Jiékọpu bya asụ Lebanụ: “Ngwa; dewaa mu rọ nyee mu. Mu nọ-dzuwaru apha ẹsaa ọbu. Ọ nọdu agụwa mu ẹgu gẹ mu l'iya kwaa.” ");
INSERT INTO izz_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ọo ya bụ; Lebanụ bya ekukọbe ndu ẹka ono bya eshiaru phẹ nri. ");
INSERT INTO izz_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","O be l'ụzenyashi; ọ bya eduta nwada iya, bụ Lii; bya eduru nụ Jiékọpu; ẹphe lẹ Jiékọpu kwaa. ");
INSERT INTO izz_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lebanụ bya eye ẹka l'ohu iya duta nwamgbọko lanụ, ẹpha iya bụ Zilipa duru nụ nwada iya ono g'o jejeru iya ozi ụlo. ");
INSERT INTO izz_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nchi bọhuepho; Jiékọpu hụma l'ọo Lii bẹ e deru iya. Jiékọpu sụ Lebanụ: “?Bụ gụnu bẹ i meru mu iphe, dụ ẹgube-a? ?Tọbudu Rechiẹlu bẹ mu jeru ngu ozi iya? ?Bụ gụnu meru g'o gude ị gbaaru mu ẹgube ẹregede-a?” ");
INSERT INTO izz_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lebanụ sụ iya: “?Tị madụ lẹ g'omelalị dụ bụ l'anyi te ekejedu onye kẹ nwata l'ẹba abụ l'ekewaru onye k'ọgerenya?” ");
INSERT INTO izz_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Sụ iya: “Taa nshi meghekpọadaa ekele onye ọwa-a idzu-a. E -mechaa; mu ekefua ngu onye kẹ nwata; ọle ii-jekwanụru mu ozi iya apha ẹsaa ọzo.” ");
INSERT INTO izz_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jiékọpu mee ya nno. O mee ekele Lii idzu ophu. Lebanụ bya ekefua ya nwada iya, bụ Rechiẹlu; ọ lụfuaru. ");
INSERT INTO izz_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lebanụ bya eye ẹka l'ohu iya duta nwamgbọko lanụ, ẹpha iya bụ Biliha duru nụ nwada iya ono, bụ Rechiẹlu g'o jejeru iya ozi ụlo. ");
INSERT INTO izz_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jiékọpu ẹphe lẹ Rechiẹlu bya akwakwaphọ. Ọ ka eye Rechiẹlu obu eme lẹ Lii. Ọ bya ejeeru Lebanụ ozi apha ẹsaa ọzo. ");
INSERT INTO izz_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Chipfu hụmaepho lẹ Lii bẹ e te eyeduru obu; o ghebe ẹkpa-nwa iya ọnu; ọphu Rechiẹlu atsụdu ime. ");
INSERT INTO izz_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lii bya atsụta ime bya anwụa nwa nwoke. O woru iya gụa Rúbẹnu; kẹle ọ sụru: “Chipfu hụmawaru iphe-ẹhuka, mu eje. Nta-a bẹ mu maru lẹ nnajịuphu mu e-ye mu obu.” ");
INSERT INTO izz_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ọ bya atsụta ime ọzo bya anwụkwapho nwa nwoke. Ọ sụ: “Ọ kwa lẹ Chipfu nụmaru l'e te eyeduru mu obu meru g'o gude ọ nụkwa mu phọ onye ọwa-a.” O woru iya gụa Simiyọnu. ");
INSERT INTO izz_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ọ byakwa atsụta ime ọzo; o zedakwaphọ nwụa nwa nwoke ọzo. Ọ sụ: “Nta-a bẹ mu maru lẹ nnajịuphu mu a-gharu mu iphu; noo kẹle mu nwụtawaru iya unwoke ẹto.” Ọo ya bụ; o woru iya gụa Lívayi. ");
INSERT INTO izz_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ọ bya atsụta ime ọzo; nwụa nwa nwoke. Ọ sụ: “Ọgiya-a bẹ mu e-tu Chipfu ẹpha.” O woru iya gụa Jiuda. Ọ nwụchaa onye k'ono; ọ pfụru apfụru. ");
INSERT INTO izz_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rechiẹlu hụmaepho lẹ ya ta anwụtaduru Jiékọpu mẹ nwa lanụ; o koaharụ nwune iya okophoo. Ọo ya bụ; ọ sụ Jiékọpu: “Yekwaa mu ime; ọdumeka mu anwụhukwa!” ");
INSERT INTO izz_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Opfu iya ono ghua Jiékọpu eghu. Ọ sụ iya: “?Bụ mbẹdua bụ Chileke, kpọshiru ngu anwụta nwa?” ");
INSERT INTO izz_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ọ sụ iya: “Duta ohu mu-a, bụ Biliha gẹ gụ l'iya kwajẹ g'ọ nwụtaru mu ụnwegirima; k'ọphu mu e-shi iya l'ẹka nweru awa.” ");
INSERT INTO izz_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ọo ya bụ; ọ bya ekuta ohu ono, bụ Biliha nụ iya; ọ lụru. Biliha yẹle Jiékọpu bya akwaa; ");
INSERT INTO izz_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ọ bya atsụta ime nwụaru iya nwa nwoke. ");
INSERT INTO izz_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Noo ya; Rechiẹlu sụ: “Nta-a bẹ Chileke hawaru mu enge. Ọ ngabẹwaru nchị nụma iphe, mu rwọru iya; bya anụ mu nwa nwoke.” Eshinu ọ dụ ẹgube ono; ọ gụa ya Danu. ");
INSERT INTO izz_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A nọnyakwa; ohu Rechiẹlu ono, bụ Biliha bya atsụta ime ọzo; bya anwụaru Jiékọpu nwa nwoke k'ẹbo. ");
INSERT INTO izz_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rechiẹlu sụ: “Mu lẹ nwune mu kpaakwaru ẹnya shii; ọle nta-a bẹ mu kaakwanaa ya ẹnya.” Ọo ya bụ; o woru nwata ọbu gụa Nafụtali. ");
INSERT INTO izz_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lii hụmaepho lẹ ya pfụru apfụru; o duta ohu nkiya, bụ Zilipa nụ Jiékọpu g'ọ lụru. ");
INSERT INTO izz_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ohu Lii ono, bụ Zilipa bya anwụtaru Jiékọpu nwa nwoke. ");
INSERT INTO izz_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lii sụ: “Ọwa-a bụkwa iphe-ekweru.” Ọo ya bụ; ọ gụa ya Gadu. ");
INSERT INTO izz_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ohu Lii ono, bụ Zilipa bya anwụta nwa nwoke k'ẹbo. ");
INSERT INTO izz_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ọo ya bụ; Lii sụ: “Ẹhu atsọshikwa mu ụtso ike; nta-a bẹ ụnwanyi a-nọdu eku mu onye a gọru ẹhu-ụtso nụ.” O woru nwata ọbu gụa Asha. ");
INSERT INTO izz_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","O be teke ebuje witi; Rúbẹnu tụgbua je l'ẹgu; ọ hụma akpụru mandureku; ọ wọta iya je anụ ne iya, bụ Lii. Rechiẹlu sụ Lii: “Jiko hẹnaa mu akpụru mandureku, nwa ngu wọtaru ngu.” ");
INSERT INTO izz_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Obenu l'ọ sụru iya: “?Ji mu ọphu ị natarụ mu teke asụduru ngu; ị nọdu emefụa g'ị nata mu akpụru mandureku, nwa mu nụru mu?” Rechiẹlu sụ iya: “Ọ dụ ree; g'ọ larụ ngu l'ụlo l'ẹnyashi-a l'ụgwo akpụru mandureku nwa ngu ọbu.” ");
INSERT INTO izz_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ọo ya bụ; Jiékọpu shiẹpho l'ẹgu lwa l'ụzenyashi mbọku ono; Lii gba iya ndzuta je asụ iya: “Lwakwaru mu l'ụlo l'ẹnyashi-a! Mu gudeakwa akpụru mandureku nwa mu zụ̀a ngu!” Ọo ya bụ; ọ lwarụ iya l'ụlo l'ẹnyashi ono. ");
INSERT INTO izz_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Chileke ngabẹru Lii nchị; ọ tsụta ime bya anwụtaru Jiékọpu nwa nwoke k'ise. ");
INSERT INTO izz_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ọo ya bụ; Lii sụ: “Chileke buakwaru mu nggo; kẹle mu kutaru ohu mu kee Jiékọpu; ọ lụru.” O woru nwata ọbu gụa Isaka. ");
INSERT INTO izz_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lii tsụta ime ọzo; bya anwụtaru Jiékọpu nwa nwoke k'ishii. ");
INSERT INTO izz_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lii bya asụ: “Chileke meakwaru mu iphe-ọma, parụ ẹka. Nta-a bẹ mu mawaru lẹ ji mu a-kwabẹje mu-a ùbvù; eshinu mu nwụtaru iya ụnwu-okoro ishii.” Ọo ya bụ; o woru iya gụa Zebulọnu. ");
INSERT INTO izz_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","E mechaa; ọ bya anwụa nwamgbọko bya eworu iya gụa Dayina. ");
INSERT INTO izz_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Chileke bya anyata Rechiẹlu; bya angabẹru iya nchị bya eworu iya ẹkpa-nwa ghebe ọnu. ");
INSERT INTO izz_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ọ tsụta ime; bya anwụa nwa nwoke bya asụ: “Chileke nafụwaru mu iphe-iphere ono.” ");
INSERT INTO izz_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ọ gụa ya Jiósẹfu; kẹle ọ sụru: “Gẹ Chipfu yekwakwaru mu nwa nwoke ọzo l'ọwa-a.” ");
INSERT INTO izz_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rechiẹlu nwụchaepho Jiósẹfu; Jiékọpu sụ Lebanụ: “Dua mu gẹ mu laa ibe nna mu. ");
INSERT INTO izz_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","L'ị haarụ mu unyomu mu phẹ; waa ụnwegirima mu, bụ ndu mu jeru ngu ozi l'ishi phẹ-a; gẹ mu gude lashịa. L'ị mawaru gẹ mu jeberu ngu ozi.” ");
INSERT INTO izz_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lebanụ sụ iya: “Ọ -bụru lẹ mu dụ ngu l'obu eviya; jiko nọbanaa! Lẹ mu lewaru ẹnya g'iphe, aanwụ; mu maru l'ọo iswi ẹhu ngu meru g'o gude Chipfu kebe mu l'ọma ẹgube-a.” ");
INSERT INTO izz_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ọ sụkwa iya phọ: “Pfua iphe, mu a-pfụje ngu gẹ mu apfụje ngu iya.” ");
INSERT INTO izz_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jiékọpu sụ iya: “Ị makpọwaru-a gẹ mu jeberu ngu ozi; waa g'iphe-edobe ngu gude zụ-beru gẹ mu eletaru ngu iya ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nwiphe nshịi ono, i shi nweru tẹme mu bya ono bẹ hawa shii ẹgube-a. Kẹle ọobujeru; ibiya ọphu mu shiru Chipfu ekebe ngu l'ọma. Nta-a bụru; ?dẹnuhunu teke mu a-gba mkpu ẹhu mu lẹ ndibe mu?” ");
INSERT INTO izz_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lebanụ sụ iya: “?Bụ gụnu bẹ mu a-pfụjekwanu ngu?” Jiékọpu sụ iya: “Ta pfụshi mu ụgwo; ọ chịa ọ -bụru l'i kwetarụ iphe, mu abya epfupfu-a; mu echebaaru ngu atụru ngu. ");
INSERT INTO izz_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Gẹ mu jephekọta l'ẹka atụru ngu kụru ntanụ-a; je ahọshikota atụru, tụkashiru iphe oji; ọzoo ọphu dekashịru iphe; waa iphe, bụ nwatụru, jigburu uji; yẹ l'eghu, tụkashiru ụcha; ọzoo ọphu dekashịru iphe. Ndu k'ono a-bụru aswa ozi mu. ");
INSERT INTO izz_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mbụ l'ii-mechaa maru lẹ mu bụ onye ire-lanụ. Lẹ-a; teke ọ bụ l'e mecharu ị bya ele ẹnya lẹ ndu k'ono, i gude pfụa mu ụgwo ono; ị -hụma iya eghu, atụkashiduru ụcha; ọphu o dekashịduru iphe; ọzoo l'ọo nwatụru, ata bụdu k'ojii; l'iikua mu onye-oshi.” ");
INSERT INTO izz_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lebanụ kweta bya asụ iya: “G'ọ dụekwapho g'i pfuru.” ");
INSERT INTO izz_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Lẹ mbọku ono gẹdegede bẹ ọ tụgburu je ahọshikota mkpi, dekashịru iphe; waa ndu ọphu tụkashiru ụcha; waa ne eghu mmanụ ndu ọphu tụkashiru ụcha; yẹle ndu ọphu dekashịru iphe; waa atụru, jikọtaru uji g'ẹphe ha. Ndu k'ono bẹ ọ chịru nụ ụnwegirima ibe iya g'ẹphe cheje. ");
INSERT INTO izz_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ọ chịta phẹ je ije ujiku ẹto je edobe phẹ l'ẹka ono dokaha yẹbedua, bụ Lebanụ l'onwiya yẹle Jiékọpu. Jiékọpu nọdu eche ndu ọphu ọ chị-phodoru. ");
INSERT INTO izz_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jiékọpu bya egbuta ẹkali-oshi oyi; ẹkali-oshi pọpula; waa oshi alumọndu; waa oshi pulenu. Ọ bya aswabọtachaa ẹkali-oshi ono ẹgbo; mee ya; ọ dụ g'o dekashịru iphe ọchaa. ");
INSERT INTO izz_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ọ bya ewota ẹkali-oshi ono, ọ swashịru ẹgbo ono dobechaa l'iphe, eeyejeru iphe-edobe ono mini; ọo ya bụ k'ọphu ẹphe a-nọdujeepho iphe-edobe ono l'atatiphu nhamụnha; m'ẹphe byatashịa angụta mini. Ọ nọdu abụjeru; iphe-edobe ono -nọdu ana okee; ẹphe -bya angụta mini; ");
INSERT INTO izz_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ẹphe awata eshi okee l'atatiphu ẹkali-oshi ono. Ẹphe bya anwụshi nwa; ẹphe anwụshia ụnwu, dekashịru iphe; waa ọphu tụkashiru iphe. ");
INSERT INTO izz_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jiékọpu bya ahọshia ụnwu iphe-edobe ono bya edobe iche; bya eworu ndu ọphuu chịru yeru ndu ọphu dekashịru iphe yẹle k'ojii phọ, bụ kẹ Lebanụ phọ. O shi ẹgube ono nweaharu iphe-edobe k'ẹka iya; ọphu ọochikobejeedu iya lẹ kẹ Lebanụ. ");
INSERT INTO izz_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ndu ọphu bụ nyee ya, gbashịru ike -najẹepho okee; Jiékọpu eje eworu ẹkali-oshi ono ye l'iphe, eeyejeru iphe-edobe mini ono dobe l'atatiphu phẹ; k'ọphu ẹphe e-shi okee lẹ mgboru ẹkali-oshi ono. ");
INSERT INTO izz_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","O -rwua l'anụ ọphu dụ nyẹgenyege; o too dobeduru iya ẹkali-oshi ono. Ọo ya bụ; e shi ẹgube ono iphe-edobe ono, ndu ọphu dụ nyẹgenyege laaru Lebanụ; ndu ọphu shihuru ike laaru Jiékọpu. ");
INSERT INTO izz_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jiékọpu shi ẹgube ono kwatakpọo nweru iphe mebyi enweru; bya enweru igwe iphe-edobe; gbashịa ohu; ụnwanyi mẹ unwoke; bya enweru ịnya-kamẹlu; yẹle nkapfụ-ịgara. ");
INSERT INTO izz_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Noo ya; a nọnyaa; Jiékọpu nụaha l'ụnwu Lebanụ bẹ epfu l'ọ tụkowaru iphe, nna phẹ nweru chịtachaa. L'iphemiphe ono, o nweru ono g'ọ ha bẹ bụkota ẹku nna phẹ bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tẹme Jiékọpu hụmakwapho l'ọ tọ bụedu gẹ Lebanụ shi emeru iya umere bụ g'oomekwadu. ");
INSERT INTO izz_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ọo ya bụ; Chipfu sụ Jiékọpu: “Tụgbua lashịa ibe nna ngu phẹ. Sụ-a; lapfu ndibe unu lẹ mu nọ-a swiru ngu.” ");
INSERT INTO izz_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ọ bụru iya bụ; Jiékọpu bya ezia g'e je ekuaru iya Rechiẹlu waa Lii; ẹphe byapfuta iya l'ẹgu l'ẹka anụ, bụ iphe-edobe iya dọru. ");
INSERT INTO izz_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ọ sụ phẹ: “Mu elekwa ẹnya l'ọ tọ bụedu gẹ nna unu shi emeru mu umere bụ g'oomekwadu; ọle Chileke kẹ nna mu phẹ nọekwapho swiru mu. ");
INSERT INTO izz_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Unu makọtaru lẹ mu gude ike mu g'ọ ha jekọtaru nna unu ozi. ");
INSERT INTO izz_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Obenu lẹ nna unu riru mu urwu; gbanwee aswa ozi mu ugbo iri. Ọle Chileke te ekwekwanụ g'o meka mu iphe. ");
INSERT INTO izz_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ọ -bụru l'ọ sụru l'ọo ndu ọphu tụkashiru iphe, bụ aswa ozi mu; iphe-edobe ono awataẹpho anwụshi ụnwu, tụkashiru iphe. Teke ọ bụ l'ọ sụru l'ọo ndu ọphu dekashịru iphe, a-bụru aswa ozi mu; iphe-edobe ono awataẹpho anwụshi ụnwu, dekashịru iphe. ");
INSERT INTO izz_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ọo ya bụ l'ọo Chileke l'onwiya chịtaru iphe-edobe nna unu chịru nụ mu. ");
INSERT INTO izz_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Lẹ teke anụ anajẹ okee bẹ mu rwọjeru nrwọ gẹ mu hụmaru l'iphe-edobe ono ndu ọphu eshi okee bẹ ndu ọphu dekashịru iphe dụ iya; ndu ọphu tụkashiru iphe dụkwa iya phọ. ");
INSERT INTO izz_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ojozi Chileke bya ekua mu oku lẹ nrwọ ono sụ: ‘Jiékọpu!’ Mu za iya: ‘Owee!’ ");
INSERT INTO izz_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ọ sụ: ‘Palikpọdapho ẹnya apali hụma l'iphe-edobe ono ndu ọphu eshi okee bẹ ndu ọphu dekashịru iphe dụ iya; ndu ọphu tụkashiru iphe dụkwa iya phọ. Noo kẹle mu hụmakotawaru iphe, Lebanụ emekọtaje ngu. ");
INSERT INTO izz_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ọ kwa mbẹdua bụ Chileke kẹ Bẹtelu. Bẹtelu bụ ẹka ono, ị wụru manụ l'eli mkpuma ono; mbụ ẹka ono, ị nọ kwee ukwe-iphe ono. Sụ-a; gbẹshikwa lụfu l'alị-a nta-a nta-a; lashịa ẹka a nwụru ngu.’ ” ");
INSERT INTO izz_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tọbudu iya bụ; Rechiẹlu yẹe Lii bya eyeeru iya ọnu sụ iya: “?Ọ dụru teke anyi e-ketakwadu oke l'iphe, shi l'ibe nna anyi? ");
INSERT INTO izz_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","?Nna anyi te ekuada anyi ndu ọhozo; mbụ l'ọ tọ bụdaa l'o reru anyi erere; obenu l'o mephushichawaru okpoga, a pfụru iya l'ishi anyi g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","O doru ẹnya l'ẹku ono l'ophu, Chileke natarụ nna anyi ono bụkotawa k'anyi; bya abụru k'ụnwu anyi. Ngwanụ; menaa iphe, Chileke sụru g'i mee!” ");
INSERT INTO izz_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ọo ya bụ; Jiékọpu bya eworu ụnwu iya; yẹe unyomu iya kuru ye l'eli ịnya-kamẹlu. ");
INSERT INTO izz_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ọ bya achịru iphe-edobe iya g'ọ ha dobe l'ivuzọ; yẹe iphemiphe, o setakọtaru lẹ Padanu-Arámu. O gude phẹ lashịa ibe nna iya, bụ Áyizaku l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lebanụ jerurọ ebushi atụru iya ẹji. Rechiẹlu tụgbushia bya akpaswata obu-nshi ibe nna iya ono, bụ Lebanụ. ");
INSERT INTO izz_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Tẹmanu; ọ bụkwarupho ezita bẹ Jiékọpu zitaru onwiya ala l'ẹbe epfuru Lebanụ ono, bụ onye Arámu ono lẹ ya alawa. ");
INSERT INTO izz_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ọ chịta iphemiphe, o nweru gude gbalaa; je adaghaa ẹnyimu Yufurétisu; kwasẹru ụzo, shijaru ọha úbvú Giladu lashịa. ");
INSERT INTO izz_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","O -rwua mbọku k'ẹto; e pfuaru Lebanụ lẹ Jiékọpu phẹ gbalaakwarụ. ");
INSERT INTO izz_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ọ chịta ndibe iya; ẹphe chịa phẹ ujiku ẹsaa; bya agbapfu phẹ l'ọha úbvú Giladu. ");
INSERT INTO izz_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Chileke byapfuta Lebanụ, onye Arámu lẹ nrwọ l'ẹnyashi bya asụ iya: “Letanụpho ẹnya! Ba adụkwa iphe, ii-pfuru nụ Jiékọpu! Be pfukwaru iya opfu ọma; ọphu i pfukwaru iya ẹjo opfu!” ");
INSERT INTO izz_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ọo ya bụ; Lebanụ bya agbapfu Jiékọpu. Ọ bụru l'ọha úbvú Giladu bẹ Jiékọpu kpọberu ụlo-ẹkwa iya teke ono. Lebanụ yẹe ndu ẹphe l'iya swị bya akpọbekwapho nkephẹ l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lebanụ sụ Jiékọpu: “?Bụ gụnu bẹ i meru ẹgube-a? ?Dẹnu g'o gude i zita onwongu ezita tụgbua gẹ mu ba ma; chịta ụnwada mu gẹ ndu a kpụru lẹ ndzụ l'ẹgu ọgu? ");
INSERT INTO izz_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","?Bụ gụnu bẹ o gude ị nọdu agbala lẹ mpya; i zita onwongu tụgbua gẹ mu ba ma; ọphu i pfuduru mu iya; k'ọphu mu e-gude ẹhu-ụtso; gude ebvu, aakụ nkwa yẹe une eye; gude bya edua unu? ");
INSERT INTO izz_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ọphu i kwekpọdanu gẹ mu tsutsua ụnwu nwanwa mu; waa ụnwada mu ọnu; gude sụ phẹ tọkwa ẹhu. I meru umere onye-eswe. ");
INSERT INTO izz_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mu gege emerwụkwa ngu ẹhu; ọme ọ tọ bụ lẹ Chileke kẹ nna ngu byapfutaru mu lẹ nrwọ l'ẹnyashi bya asụ mu: ‘Letanụpho ẹnya! Ba adụkwa iphe, ii-pfuru nụ Jiékọpu! Be pfukwaru iya opfu ọma; ọphu iipfukwaru iya ẹjo opfu!’ ");
INSERT INTO izz_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nta-a bẹ ị tụgburu ala opfu l'oghoroko ibe nna ngu dụ ngu. Obenu ?bụ gụnu kparụ iphe, i zitaru iteshi mu?” ");
INSERT INTO izz_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jiékọpu sụ Lebanụ: “Ọ kwa ndzụ shi agụ mu; kẹle mu rịru l'ịi-nata mu ụnwu ngu k'ẹhuka. ");
INSERT INTO izz_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Obenu l'ọ -bụru l'ị hụmaru onye gude iteshi ngu bẹ onye ono ta anọdukwa ndzụ. Ngwa; nọdu l'iphu ndu anyi l'ẹphe bụ-a; gude ẹka ngu chọo g'ị maru ?o nweru iphe ngu, mu gude? O -nweru ọphu ị hụmaru; wota iya!” Gẹ Jiékọpu epfu nno bẹ ọ tọ bụkpoodanu l'ọ maru l'ọo Rechiẹlu bẹ zitaru obu iteshi ọbu. ");
INSERT INTO izz_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ọo ya bụ; Lebanụ bya abahụ l'ụlo-ẹkwa Jiékọpu; waa kẹ Lii; waa lẹ k'ụnwanyi ohu labọ ono je achọkota iya; ọphu ọ dụdu iphe, ọ hụmaru. Ọ lụfutaepho l'ụlo-ẹkwa Lii; bya abahụ l'ụlo-ẹkwa Rechiẹlu. ");
INSERT INTO izz_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ama lẹ Rechiẹlu woru obu-nshi ono nwua l'iphe, aanọduje anọo l'eli ịnya-kamẹlu; nọpyabe iya anọo. Lebanụ bya atụko iphe, nọ l'ụlo-ẹkwa ono chịghashia; ọphu ọ dụdu iphe, ọ hụmaru. ");
INSERT INTO izz_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rechiẹlu sụ nna iya: “G'ẹhu te eghukwa ngu eghu; nnana; lẹ mu ta agbalihuduru agbalihu lẹ g'ị byaru-a; l'ọ kwa nsọ nwanyị eme mu.” O kwe iya hm; bya achọo obu-nshi ono nta-a; chọo imo; ọphu ọ hụmaduru iya. ");
INSERT INTO izz_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ẹhu ghushiaha Jiékọpu eghu ike; o tsopyabẹ Lebanụ ụswo sụ iya: “?Bụkpoo gụnu bụ ẹjo-iphe ọbu, mu meru ọbu? ?Bụ iphe-ẹji gụnu bẹ mu meru kparụ iphe, ịichi mu kpabẹkpabe nno? ");
INSERT INTO izz_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nta-a, ị tụkoru ivu mu vọghashicha-a; ?bụ gụnu bẹ ị hụmaru, bụ nkengu? Wofuta iya l'atatiphu ndibe anyi lẹ ngu-a; g'ẹphe pfua onye ọphu achọ opfu! ");
INSERT INTO izz_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Mu lẹ ngu buwaru ụkporo apha nta-a. Ọphu atụru yẹe eghu ngu adụdu ọphu kwojeru nwa; ọphu mu atsọjeduru ọnu l'ebili, shi l'atụru ibe ngu; ");
INSERT INTO izz_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ọphu mu apalatajẹduru ngu odzu iphe-edobe ngu, anụ-ẹgbudu gburu; ọ chịa mbẹdua bẹ oobutajẹchia; ị nọdu asụje gẹ mu pfụa ngu ụgwo iphe ọphu iphuru zitaru l'eswe; ọzoo l'ẹnyashi. ");
INSERT INTO izz_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lenaa g'o shi adụjeru mu. L'eswe bẹ anwụ shi egheje mu egheghe. O -rwua l'ẹnyashi; mu anọkota l'ogoyi abalị; ọphu mgbẹnya abyadụ eshita mu ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Noo gẹ mu jekọtaru iya l'ụkporo apha ono, mu bukọtaru l'ibe ngu ono. Mu jeru ngu ozi apha iri l'ẹno l'ishi ụnwada ngu; bya echeru ngu iphe-edobe apha ishii. Ị ghazia ụgwo mu mgbo iri. ");
INSERT INTO izz_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ọme Chileke kẹ nna mu; mbụ Chileke kẹ Ébirihamu; waa onye Áyizaku atsụ ebvu; ọme ọ tọ nọ-kube mu; mẹ iimechaa gbabẹghaa mu ẹka ọto chịa mu. Obenu lẹ Chileke hụmaru iphe-ẹhuka mu; waa gẹ mu eseberu akanya; bya abaarụ ngu mba l'ẹnyashi-a, larụ nụ-a.” ");
INSERT INTO izz_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lebanụ sụ Jiékọpu: “Ụnwanyi-a bụkwa ụnwada mu; ụnwegirima-a bụru ụnwegirima mu; iphe-edobe-a bụru mu nwe iya. Iphemiphe-a g'ọ ha bụkota nkemu. Ọle ?bụkwanu gụnu bẹ mu e-me l'ẹhu ụnwada mu ọbu; ọzoo l'ẹhu ụnwegirima-a, ẹphe nwụshiru-a? ");
INSERT INTO izz_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ngwa; bya gẹ mu lẹ ngu gbaa ndzụ g'ọ bụru iphe, a-bụru ekebe mu lẹ ngu!” ");
INSERT INTO izz_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ọo ya bụ; Jiékọpu bya apata mkpuma kpọbe; ọ dụ g'itso. ");
INSERT INTO izz_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ọ sụ ndu ono, ẹphe l'iya bụ ono g'ẹphe pakọo mkpuma. Ẹphe bya apakọo mkpuma ono kụkobe l'ẹka lanụ. Ẹphe nọdu lẹ mgboru ikpo mkpuma ono rigba nri. ");
INSERT INTO izz_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lebanụ kua ẹka ono Jiga Sahaduta; Jiékọpu kua ya Giladu. ");
INSERT INTO izz_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lebanụ sụ: “Ikpo mkpuma-a bụ ekebe mu lẹ ngu ntanụ-a.” Noo iphe, kparụ iphe, a gụru iya Giladu. ");
INSERT INTO izz_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","E kukwaru iya phọ Mizupa; noo kẹle ọ sụru: “Gẹ Chipfu tụkokwa mu lẹ ngu chee nche; mẹ anyi gbakashịhuchaa; tụgbua. ");
INSERT INTO izz_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Teke ọ bụ l'i meru ụnwada mu-a ẹji; ọzoo l'i jeru alụa ụnwanyi ọzo; agụfu ẹphebedua; a makwarụ-a l'ọ tọ dụdu onye anyi l'iya tụko nọdu l'ẹka-a; ọle g'ị nyatakwa lẹ Chileke bụ onye-ekebe mu lẹ ngu.” ");
INSERT INTO izz_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lebanụ sụkwapho Jiékọpu: “Waa ikpo mkpuma-a; tẹme waa itso mkpuma-a, mu kpọberu l'echilabọ mu lẹ ngu. ");
INSERT INTO izz_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ikpo mkpuma-a bụ ekebe; tẹme itso mkpuma-a bụkwarupho ekebe lẹ mu ta abyadụ aghata iya; bya l'ibiya nkengu bya ngu emeka iphe. Ọphu gụbedua abyadụ aghata iya abya ibiya nkemu abya mu emeka iphe. ");
INSERT INTO izz_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Gẹ Chileke kẹ Ébirihamu, bụ Chileke kẹ Nahọ; bya abụru Chileke kẹ nna phẹ kpee ikpe mu lẹ ngu!” Ọo ya bụ; Jiékọpu bya egude ẹpha Chileke, bụ Onye nna iya, bụ Áyizaku atsụ ebvu riaru iya nte. ");
INSERT INTO izz_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ọ bya egwee ngwẹja l'eli úbvú l'ẹka ono; bya ezia abụbu iya g'ẹphe bya lẹ nri. Ẹphe richaa nri bya akwaa l'ẹka ono l'ẹnyashi ono. ");
INSERT INTO izz_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","O -rwuẹpho l'ọnmewa ụtsu; Lebanụ bya etsutsua ụnwu nwanwa iya; yẹe ụnwada iya ọnu; bya agọru ọnu-ọma nụ phẹ; bya adakọbe; ọ bụru iya ala unuphu. ");
INSERT INTO izz_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jiékọpu tụgbukwapho nkiya; ọ bụru iya alala. O jenyaa; ụnwu ojozi Chileke wụ-pfuta iya. ");
INSERT INTO izz_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jiékọpu hụmae phẹ phọ; ọ sụ: “Ha! Ndu ọwa-a bụkwa ndu ojọgu kẹ Chileke!” Ọ gụa ẹka ono “Mahanayimu” bụ iya bụ ọdu labọ. ");
INSERT INTO izz_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jiékọpu zia ndu-ozi g'ẹphe vuru iya ụzo jepfu nwune iya, bụ Ịso l'alị Siye, bụkwapho alị ndu Edọmu. ");
INSERT INTO izz_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ọ bya ezia phẹ sụ: “Waa iphe, unu e-pfuru nnajịuphu iya, bụ Ịso. Unu sụ iya l'onye-ozi iya, bụ Jiékọpu sụkwaru l'ọo l'ibe Lebanụ bẹ ya shi teke ono butaru; ọ bụru ẹka ono bẹ ya bu byasụ nta-a. ");
INSERT INTO izz_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ya nweru eswi; bya enweru nkapfụ-ịgara; nweru atụru; yẹe eghu; nweru ohu; unwoke mẹ ụnwanyi. Ya ezi ndu-ozi iya-a g'ẹphe byapfuta nnajịuphu iya g'a maru ?ya a-dụ iya l'obu?” ");
INSERT INTO izz_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ndu ozi ono jechaa bya alwaphuta azụ lwapfuta Jiékọpu sụ iya: “Ẹphe jepfukwaru nwune ngu ọbu, bụ Ịso. Nta-a bẹ o gudekwa ụnu ụmadzu gude abya ngu ndzuta.” ");
INSERT INTO izz_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ndzụ gụahaa Jiékọpu; meji tọfu iya. Ọ bya ekee ndu ẹphe l'iya swị ụzo labọ; bya ekekwaphọ atụru waa eghu iya; kee eswi iya; mẹ ịnya-kamẹlu iya ụzo ẹbo ẹbo kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ọ rịa sụ: “Ọ -bụru lẹ Ịso tsoru ndu kẹ mbụ ọgu; oke lanụ ọphuu, ghuduru nụ phọ agbalakpọnu.” ");
INSERT INTO izz_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jiékọpu bya epfuru nụ Chileke sụ: “Gụbe Chileke kẹ nna mu oche, bụ Ébirihamu; Chileke kẹ nna mu, bụ Áyizaku; gụbe Chipfu; onye sụru mu gẹ mu laphu azụ l'alị, a nwụru mu; lapfu abụbu mu phẹ; l'ii-me-a gẹ mu barahụ. ");
INSERT INTO izz_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Obu ono, i goshiru l'i yeru mu ono; waa ememe, i meru mu iphe, i pfuru ono be ta agbakwarụ mu. Teke mu daru ẹnyimu Jiọ́danu-a bụ oshi-mpalẹka bẹ mu pa kpoloko; obenu lẹ nta-a bẹ mu nwewaru iphe; k'ọphu mu tsukaharu iya ẹbo. ");
INSERT INTO izz_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mu epfu anụ ngu g'ị dzọo mu l'ẹka nwune mu, bụ Ịso. Kẹle ndzụ agụ mu l'oo-tso mu ọgu; tsoo ụnwanyi ibe mu yẹe ụnwegirima phẹ ọgu kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Obenu l'i pfuru sụ l'i mee mu gẹ mu barahụ; l'iimee g'awa mu ha g'ẹja, nọ l'eze-ẹnyimu; mbụ g'ẹphe bụru agụta agụta.” ");
INSERT INTO izz_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ọ kwaa l'ẹka ono l'ẹnyashi ono; bya eshi l'iphe, o nweru họta iphe, oo-gude meeru Ịso iphe-ọma. ");
INSERT INTO izz_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Iphe, ọ họtaru bụ ụkporo ne eghu iri; yẹe ụkporo mkpi; waa ụkporo ne atụru iri; yẹe ụkporo ebili; ");
INSERT INTO izz_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","bya ahọtakwapho ne ịnya-kamẹlu yẹe ụnwu iya ụkporo l'iri; waa ụkporo ne-eswi labọ; yẹe oke-eswi iri; waa ụkporo ne nkapfụ-ịgara; yẹe okee ya iri. ");
INSERT INTO izz_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ọ dokọta anụ ono iche iche; bya eyekọta ndu-ozi iya g'ẹphe leta iya ẹnya iche iche. Ọ sụ ndu-ozi iya ono: “Unu vuru mu ụzo! Unu edoo onwunu iche iche gẹ ndu eche anụ ọphuu ta tụkobekwa onwophẹ lẹ ndu eche ọphuu!” ");
INSERT INTO izz_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ọ sụ ndu ọphu vu ụzo: “Ọ -bụru l'unu lẹ nwune mu, bụ Ịso dzuru; ọ jịa; sụ: ‘?Unu bụ ndibe onye?’ tẹme ‘?Bụ awe bẹ unu eje?’ tẹme ‘?Bụ onye nwekọta anụ ono, awụ l'atatiphu unu ono?’ ");
INSERT INTO izz_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Iphe, unu e-pfu bụ: ‘Ọ kwa onye-ozi ngu, bụ Jiékọpu nwe iya. Ọle ọo iphe, ọ nụru g'e wotaru nnajịuphu iya, bụ Ịso; lẹ yẹbedua, bụ Jiékọpu etsokwa phẹ-a l'azụ.’ ” ");
INSERT INTO izz_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","O pfuaru ndu k'ẹbo; waa ndu k'ẹto; mẹ iphe, bụkpoo g'ẹphe hakọta, etso iphe-edobe ono; sụ phẹ: “Ọ kwaphọ iphe ono, mu pfuru ono bẹ unu e-pfujeru Ịso; mẹ unu l'iya dzuda. ");
INSERT INTO izz_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ọle g'unu nyatajẹkwa sụ l'onye-ozi iya, bụ Jiékọpu bẹ etsokwa unu.” Iphe, Jiékọpu gude pfua nno bụ l'ọ rịru sụ l'ee-gude iphe ono, ya nụru e gude vuru ụzo ono mee g'obu jidata iya. Sụ: “?A maru; ?ọo-nata mu-a; mẹ mu hụmae ya phọ?” ");
INSERT INTO izz_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ọo ya bụ; e rwutanụ ẹku ono, Jiékọpu chiẹru g'a chiẹ Ịso ono vuru ụzo; yẹbedua, bụ Jiékọpu kwaa l'ẹka ono l'ẹnyashi ono. ");
INSERT INTO izz_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","L'ẹnyashi ono bẹ Jiékọpu dutaru unyomu iya ẹphenebo; waa ụnwanyi labọ ono, bụ ohu iya ono; waa ụnwu iya ẹphe n'iri lẹ nanụ je adaghaa nggele Jiabọku l'ụzo ẹka eerwuje iya erwurwu. ");
INSERT INTO izz_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","O dughachaẹ phẹ phọ lẹ nggele ono; ọ bya alaphu azụ bya achịfukota iphemiphe, o nweru l'azụ iya ọphuu kwaphọ. ");
INSERT INTO izz_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ọ bụwaru Jiékọpu nwẹkinyi iya nọ l'ẹka ono. Ẹphe lẹ nwoke lanụ gbaẹpho mgba gbiriri jasụ l'ụzo ụtsu. ");
INSERT INTO izz_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A nọnyaa; nwoke ono maẹrupho l'o to gudedu iya; ọ rwụa Jiékọpu ẹka l'ishi nka; nka kpọkafu iya g'ẹphe lẹ nwoke ono agba mgba ono. ");
INSERT INTO izz_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nwoke ono sụ iya: “Haa mu gẹ mu laa; lẹ nchi abọhuwaa!” Jiékọpu sụkwanu: “Mu taa hakwa ngu g'ị laa; abụdu l'ị gọru ọnu-ọma nụ mu.” ");
INSERT INTO izz_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nwoke ono sụ iya: “?Bụ gụnu bụ ẹpha ngu?” Ọ sụ iya: “Ọo Jiékọpu.” ");
INSERT INTO izz_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ọo ya bụ; nwoke ono sụ iya: “Ẹpha ngu taa bụeduru Jiékọpu; ọo Ízurẹlu bẹ ọo-bụru; noo kẹle unu lẹ Chileke; waa nemadzụ gharu iya; ị lwụ-kpee.” ");
INSERT INTO izz_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jiékọpu sụ iya: “Jiko; kọnaaru mu ẹpha ngu.” Ọ sụ iya: “?Bụ gụnu meru iphe, ịikpa ishi ẹpha mu?” Ọ gọru ọnu-ọma nụ Jiékọpu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ọo ya bụ; Jiékọpu gụa ẹka ono Peniyẹlu sụ: “Noo lẹ mu hụmaru Chileke iphu l'iphu; bya anọdukwadu ndzụ.” ");
INSERT INTO izz_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jiékọpu bya l'aghata Peniyẹlu; ẹnyanwu wawaa. Ọ nọdu ete ọkpa; ọ bụru nka ono, kpọkafuru iya nụ ono kparụ iya. ");
INSERT INTO izz_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Noo iphe, kparụ iphe e -shi teke ono rwua ntanụ-a bẹ ndu Ízurẹlu ta atajẹdu anụ, nmọpfuru lẹ nka. Noo kẹle ọo l'ẹka ono bẹ a rwụru Jiékọpu ẹka ọbu. ");
INSERT INTO izz_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jiékọpu jeshia ele ẹnya; ọ hụma Ịso ẹka ẹphe l'ụnu ụmadzu, ọ chị, eje abya. Ọ bya eworu ụnwegirima iya keeru Lii; yẹe Rechiẹlu; yẹe ụnwanyi labọ ọphuu, bụ ohu iya ono. ");
INSERT INTO izz_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","O duru ụnwanyi labọ ono, bụ ohu ono; yẹe ụnwu phẹ dobe l'ivuzọ. O dotsota phẹ Lii yẹe ụnwu iya; bya eworu Rechiẹlu yẹe Jiósẹfu dobe l'ikpazụ. ");
INSERT INTO izz_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yẹbedua vuta ụzo jeru jepfushia nwune iya ono; bya ephozeru iya ishi mgbo ẹsaa lẹ g'ooje ejepfu iya ono. ");
INSERT INTO izz_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Noo ya; Ịso gbapfu Jiékọpu je anmata iya akpa. Ọ bya eworu ẹka gbakụa ya l'olu bya etsutsua ya ọnu. Ẹphe tụko wa ẹkwa. ");
INSERT INTO izz_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ịso jeshia apali ẹnya imeli; bya ahụma ụnwanyi ono; yẹe ụnwegirima ono; bya ajịa ya sụ: “?Bụ ndu ole bẹ unu l'ẹphe swị ono?” Jiékọpu sụ iya: “Ọ kwa ụnwegirima, Chileke nụru mụbe onye-ozi ngu shita l'eze-iphe-ọma nkiya.” ");
INSERT INTO izz_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ụnwanyi ono, bụ ohu ono; yẹe ụnwegirima phẹ bya abyarwuta; bya ephozeru iya ishi. ");
INSERT INTO izz_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lii yẹe ụnwegirima ibe iya bya abyarwuta bya ephozeru iya ishi. O -rwua l'ikpazụ iya; Jiósẹfu yẹe Rechiẹlu bya ephozekwaru iya phọ ishi. ");
INSERT INTO izz_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ịso jịa sụ: “?Bụ gụnu bẹ ndu k'ọphuu, ẹphe l'iya dzuru l'ụzo phọ bụ?” Ọ sụ iya: “Ọ bụ nụpho iphe, mu nụru ngu gude eme gẹ mu tụba gụbe nnajịuphu mu l'obu.” ");
INSERT INTO izz_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Obenu lẹ Ịso sụru iya: “Waawaa. Nworurọ iphe ngu; ọphu mu nweru dụ-a shii.” ");
INSERT INTO izz_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jiékọpu sụ: “E phokwarọ! Ọ -bụru lẹ mu dụ ngu l'obu; jiko natanụ iphe ono, mu nụru ngu ono! Ahụma iphu ngu dụ g'onye eje ahụma iphu Chileke; eshinu i gude obu-ọma nata mu. ");
INSERT INTO izz_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jiko natarọ iphe ono, e wotaru ngu ono; noo kẹle Chileke meru mu eze-iphe-ọma; mu nwekọtaru iphe, mkpa iya dụru mu.” Jiékọpu rwọnyakpoepho; Ịso nata iya. ");
INSERT INTO izz_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ịso sụ: “Unu g'anyi je! G'anyi l'unu tụko swịru!” ");
INSERT INTO izz_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jiékọpu sụ iya: “Nnajịuphu; ị maru l'ụnwegirima-a bẹ ọkpu teke eshihudu ike. Tẹme mu emekwaphọ gẹ mu chịkobe atụru waa eswi mu, nwụshiru nwa k'ọ̀phúú. Ọ -bụru l'a chịru phẹ l'ẹhuka bụ-a ujiku ophu bẹ ẹphe a-nwụshihukota. ");
INSERT INTO izz_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ọo ya bụ; nnajịuphu; vururọ onye-ozi ngu ụzo! Mu a-tọkpoepho nwẹhu etso ndu ono, nọ l'ivuzọ achị iphe-edobe ono; waa ụnwegirima gbiriri jasụ mu abyapfuta ngu lẹ Siye.” ");
INSERT INTO izz_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ịso sụ: “Gẹ mu haphoduru ngu unwoke mu g'unu l'ẹphe swịru.” Jiékọpu jịa sụ: “?Bụkwanu gụnu bẹ iijerọ eme nno? Ọ bụ-a gẹ mu maru eviya lẹ mu dụ nnajịuphu mu l'obu.” ");
INSERT INTO izz_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ọo ya bụ; Ịso gbẹshi mbọku ono; ọ bụru iya ala Siye. ");
INSERT INTO izz_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jiékọpu swịa ụzo Sukọtu; o jerwua Sukọtu bya akpụa unuphu l'ẹka ono; bya atụaru iphe-edobe iya m̀kpù. Noo iphe, kparụ iphe, a gụberu ẹka ono Sukọtu. ");
INSERT INTO izz_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jiékọpu shiẹpho Padanu-Arámu; lwarwuta lẹ nchị-odoo lẹ mkpụkpu Shẹkemu l'alị Kénanu; bya eburu l'atatiphu mkpụkpu ono. ");
INSERT INTO izz_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","O gude ụkporo mkpọla-ọchaa ise zụta ụnwu Hamọ; mbụ nna Shẹkemu alị ẹka ọ kpọberu ụlo-ẹkwa iya. ");
INSERT INTO izz_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ọ bya eworu ọru-ngwẹja kpụa l'ẹka ono; kua ya “Chileke, bụ Chileke kẹ ndu Ízurẹlu.” ");
INSERT INTO izz_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Noo ya; Dayina, bụ nwada, Lii nwụtaru Jiékọpu; kpapfushia ụnwanyi ndu alị ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shẹkemu, bụ nwatibe Hamọ onye Hevu, bụ eze ndu ọnu ẹgu ono hụmae ya phọ; o duta iya; ẹphe l'iya kwaa; ọ pharwụshia ya. ");
INSERT INTO izz_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Dayina; mbụ nwada Jiékọpu la iya l'ẹhu; o yee ya obu; bya emeaharu iya ẹmereme. ");
INSERT INTO izz_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shẹkemu sụ nna iya, bụ Hamọ g'ọ lụtaru iya nwamgbọko ono g'ọ bụru nyee ya. ");
INSERT INTO izz_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jiékọpu nụma lẹ nwada iya, bụ Dayina bẹ a pharwụshiwaru; ọphu ọ dụdu iphe, o meru jasụ ndibe iya lwa; kẹle teke ọ nụmaru iya bẹ ẹphe nọ l'ẹgu eche iphe-edobe iya. ");
INSERT INTO izz_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ọo ya bụ; Hamọ, bụ nna Shẹkemu je g'ẹphe lẹ Jiékọpu pfugbabẹ. ");
INSERT INTO izz_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ụnwu Jiékọpu nụmaepho iphe, nwụru nụ bya alwatashịa. Aphụ yẹe ẹhu-eghu ji phẹ obu; noo kẹle Shẹkemu meru iphe-iphere kpua ndu Ízurẹlu; kẹle o jepfuru nwada Jiékọpu, bụ iphe, agbadụru g'ọ nwụa. ");
INSERT INTO izz_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamọ sụ phẹ: “Nwa mu, bụ Shẹkemu bẹ obu iya dụ lẹ nwada unu-a. Jiko unu kenaa ya ya g'ọ lụru. ");
INSERT INTO izz_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","G'anyi l'unu lụgbaru nwanyị. Unu keje anyi nwada unu; unu alụtaje k'anyi. ");
INSERT INTO izz_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Unu eburu l'echilabọ anyi. Alị dabyikpọerupho ìphóró nọduru unu. Unu eburu iya; anyi l'unu azụgba aswa; unu anọdu iya kpata ẹku.” ");
INSERT INTO izz_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ọo ya bụ; Shẹkemu sụ nna Dayina; yẹe unwune iya: “Unu kwenu lẹ mu dụ unu l'obu; iphe, unu sụkpoerupho gẹ mu nụ unu bẹ mu a-nụ unu. ");
INSERT INTO izz_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Unu hụa aswa nwada unu; yẹe iphe-ọma, mu e-meru unu jasụ g'ọo-dụ-be unu ree. Iphe, bụ iphe, unu sụru gẹ mu kwaa bẹ mu a-kwarụ unu. Ọo ẹpho g'unu kee mu nwamgbọko-a gẹ mu lụru.” ");
INSERT INTO izz_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Eshinu a pharwụshiwaru Dayina apharwụshi bẹ ụnwu Jiékọpu yeru Shẹkemu; yẹe nna iya ọnu ẹregede. ");
INSERT INTO izz_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ẹphe sụ phẹ: “Tụswekwa! Anyi ta abyakwa eme iphe, dụ nno. Anyi te ewokwaru nwada anyi eke nwoke, ebuduru úbvù. Ọo-bụkwaru anyi iphe-iphere. ");
INSERT INTO izz_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Iphe, e-meẹpho; anyi ekweta bụ g'unu dụ g'anyi dụ; mbụ g'iphe, bụ nwoke lẹ ndu unu bushikọta úbvù. ");
INSERT INTO izz_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ọo ya bụ; anyi ekee unu nwada anyi; anyịbedua alụtaaha nwada unubẹdua. Anyi l'unu ebua ẹghirigha; bya abụru iphe lanụ. ");
INSERT INTO izz_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Obenu l'ọ -bụru l'unu te ekwedu l'unu e-bushi úbvù; anyi eduta nwada anyi; tẹme anyi alakwaphọ.” ");
INSERT INTO izz_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Iphe ono, ẹphe pfuru ono dụ Hamọ yẹle nwa iya, bụ Shẹkemu ree. ");
INSERT INTO izz_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ọphu nwokorọbya ono, bụ iya bụ onye a kakọta akwabẹ ùbvù l'ibe nna iya l'ophu ono akpọduru ụpfu eme iphe ono, ẹphe pfuru ono. Kẹle nwada Jiékọpu dụ iya l'obu. ");
INSERT INTO izz_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ọo ya bụ; ẹphe tụgbua; mbụ Hamọ yẹe nwa iya, bụ Shẹkemu jeshia l'ọguzo mkpụkpu phẹ; g'ẹphe je epfuaru iya unwoke, bu lẹ mkpụkpu ono. ");
INSERT INTO izz_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ẹphe jerwua bya asụ phẹ: “Ndu-a bẹ umere phẹ dụkwa ree. Aa-hakwa phẹ g'ẹphe buru l'alị anyi; nọdu iya agba nghọ; eshinu alị, ha ọsa nọduru phẹ. Anyi a-nọdu alụ ụnwada phẹ; ẹphe alụ k'anyi. ");
INSERT INTO izz_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ọle tẹme ndu ono ekwe buru l'echilabọ anyịbe ndu Shẹkemu bụ m'ọ bụru l'unubẹ unwoke kwetarụ bushia úbvù; dụ g'ẹphebedua dụ. ");
INSERT INTO izz_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","?Unu ta amadụ l'iphe-edobe waa ẹku phẹ; waa iphe, bụ anụ, ẹphe nweru enweru a-bụru k'anyi? Ọo ya bụ; unu g'anyi kweta iphe, ẹphe pfuru g'ẹphe eburu l'echilabọ anyi.” ");
INSERT INTO izz_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Unwoke, lụfutakotaru l'ọguzo mkpụkpu ono kwetakọta iphe, Hamọ yẹe nwa iya pfuru. Unwoke, bu lẹ mkpụkpu ono bya ebushikọta úbvù g'ẹphe ha. ");
INSERT INTO izz_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A nọepho ujiku ẹto, ẹphe buru úbvù ono; g'ẹphe anyakwadu ọ́nyá úbvù ono; ụnwu Jiékọpu ẹbo, ndu ọphu yẹle Dayina shi lẹ ne lanụ, bụ iya bụ Simiyọnu; waa Lívayi gbẹshi bya amịta ogu-echi phẹ bahụ lẹ mkpụkpu ono je atụko unwoke mkpụkpu ono g'ẹphe ha gbuẹbe l'ọtulupfu. ");
INSERT INTO izz_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ẹphe gbua Hamọ; yẹe nwa iya, bụ Shẹkemu; bya eduta Dayina l'ụlo ibe Shẹkemu tụgbua; ọ bụru phẹ alala. ");
INSERT INTO izz_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ụnwu Jiékọpu bya adajaa l'echi odzu ono; bya akwata iphe, ndu mkpụkpu ono, pharwụshiru nwune phẹ ono l'ọkwata. ");
INSERT INTO izz_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ẹphe kpụta atụru waa eghu phẹ; waa eswi phẹ; waa nkapfụ-ịgara phẹ; bya atụko iphemiphe, bụkota kẹ ndu mkpụkpu ono gwetakọta; mbụ gwetachaa ndu ọphu nọ l'ọma mkpụkpu; mẹ ndu ọphu nọ l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ẹphe gwetakọta ẹku phẹ; waa ụnwanyi phẹ; yẹe ụnwegirima phẹ; bya atụko iphemiphe, nọkota l'ụlo phẹ gweta. ");
INSERT INTO izz_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tọbudu iya bụ; Jiékọpu sụ Simiyọnu; yẹe Lívayi: “Ẹgube iphe-ẹhuka ọphu unu wobatakwanụru mu nta-a! Nta-a bẹ unu meru gẹ mu bụru onye eshi ndu Kénanu; yẹe ndu Pẹ́rezu ishi; mbụ ndu bu l'alị-a. ?Ọ kwa l'unu maru-a l'anyi parụ nwanshịi? Ọ -bụru l'ẹphe chigbabẹru onwophẹ byapfuta mu ọgu bẹ mu lẹ ndibe mu a-bụkwaru mkpurupyata!” ");
INSERT INTO izz_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ẹphe sụ: “?Ọ gbakwanụru g'ẹphe mee nwune anyi nwanyị gẹ nwanyị-ovuọba?” ");
INSERT INTO izz_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ọo ya bụ; Chileke sụ Jiékọpu: “Kwalita lashịa mkpụkpu Bẹtelu je eburu. I -rwua l'ị kpụaru mụbe Chileke ọru-ngwẹja; mbụ mụbe Chileke ono, byapfutaru ngu l'ẹka ono; teke ịigbalaru nwune ngu, bụ Ịso-a.” ");
INSERT INTO izz_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ọ bụru iya bụ; Jiékọpu sụ ndibe iya; waa ndu ẹphe l'iya bu: “Unu lwụa iphe, bụkpoo agwa, unu gude; unu emee onwunu g'unu dụ nsọ; unu agbanwee uwe unu. ");
INSERT INTO izz_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ọo ya bụ; unu agbẹshi g'anyi je Bẹtelu gẹ mu je akpụaru Chileke ọru-ngwẹja l'ẹka ono, bụ iya bụ onye ono, nụmaru olu mu teke mu nọ l'aphụ; bya abụru onye ono, nọ-kuberu mu l'ẹkameka ono, ya jekọtaru ono.” ");
INSERT INTO izz_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Noo ya; ẹphe tụko agwa ono, ẹphe gude ono; yẹe iphe-nchị, ẹphe yeru lẹ nchị yeshia chịru nụ Jiékọpu; o likọta lẹ mkpula akpụrata, nọ lẹ mgboru mkpụkpu Shẹkemu. ");
INSERT INTO izz_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ẹphe gweta tụgbua; ndzụ-agụgu, shi l'ẹka Chileke rwupyabẹ mkpụkpu ọphu nọ-phegbaaru phẹ mgburugburu; k'ọphu bụ l'ọ tọ dụdu g'ẹphe ha, jeru achị ndibe Jiékọpu ono ọso. ");
INSERT INTO izz_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jiékọpu yẹe ndu ẹphe l'iya swị bya ejerwua mkpụkpu Luzu, bụ iya bụ Bẹtelu, nọ l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ọ bụru l'ẹka ono bẹ ọ kpụru ọru-ngwẹja; bya agụa ẹka ono Elu Bẹtelu. Noo l'ọo ẹka ono bẹ Chileke goshiru iya onwiya lẹ g'ọogbalaru nwune iya. ");
INSERT INTO izz_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","No iya; Debora, bụ onye shi eleta Ribeka ẹnya nwụhu; e lia ya lẹ mkpula upfu akpụrata lẹ nsụda Bẹtelu. Ọo ya bụ; a gụa ẹka ono Alọnu Bakutu. ");
INSERT INTO izz_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jiékọpu shichaẹpho Padanu-Arámu lwa; Chileke byapfuta iya ọzo bya agọru ọnu-ọma nụ iya. ");
INSERT INTO izz_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Chileke sụ iya: “Ẹpha ngu bụ Jiékọpu; ọle ẹpha ngu ta abụheduru Jiékọpu; ẹpha ngu a-bụru Ízurẹlu.” Ọo ya bụ; ọ gụa ya Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Chileke sụ iya: “Ọo mbẹdua bụ Chileke, bụ Ọkwoolemkpa. Unu zụ̀a azụ̀zù ka l'ọtu. L'iimeta ndu a-bụru ọha ẹka phẹ; bya emetakwaphọ ọhamoha ọzo yekọberu phẹ. Ndu eze eshi ngu l'ẹhu fụta. ");
INSERT INTO izz_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Alị ono, mu nụru Ébirihamu; waa Áyizaku bẹ mu nụkwaru ngu phọ; tẹme mu nụkwa iya phọ ụnwu nwanwanwaranwa ngu.” ");
INSERT INTO izz_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Chileke shi l'ẹka ọ nọ pfuru yeru iya ono tụgbua ephekerephe. ");
INSERT INTO izz_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jiékọpu bya apalia mkpuma pfụbe l'ẹka ono, Chipfu nọ pfuru yeru iya ono; bya ekpua ya mẹe l'eli; kpua ya manụ gude gwaa Chileke. ");
INSERT INTO izz_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jiékọpu gụa ẹka ono, Chileke nọ pfuru yeru iya ono Bẹtelu. ");
INSERT INTO izz_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ẹphe shi lẹ Bẹtelu tụgbua. Ẹphe rwujeẹpho mgboru Ifurata; ime meahaa Rechiẹlu. Ezeda iya kwatakpọo tsụahaa ya l'ẹhu. ");
INSERT INTO izz_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Lẹ teke ono, iphe shihụru ike g'oome zeda ono bẹ nwanyị, eswi iya ime sụru iya: “Gẹ ndzụ ba agụshi ngu. Ọ kwa nwa nwoke ọzo bẹ ị nwụru.” ");
INSERT INTO izz_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ọ bya l'atubuhu unme k'anwụhu; ọ gụa nwa iya nwoke ono Benoni. E mechaa; nna iya gụa ya Benjiaminu. ");
INSERT INTO izz_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Noo ya; Rechiẹlu nwụhu; e lia ya l'ụzo Ifurata, bụ iya bụ Bẹtulehemu. ");
INSERT INTO izz_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jiékọpu swita mkpuma pfụbe l'eli ilu iya. Mbụ byasụ ntanụ-a bẹ mkpuma ono nọekwapho l'ẹka ono egoshi l'ọo ilu Rechiẹlu. ");
INSERT INTO izz_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ízurẹlu tụgbukwa ọzo; bya eje akpọbe ụlo-ẹkwa iya l'azụ ụlo-ephekerephe, bụ Eda. ");
INSERT INTO izz_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ọ bụru lẹ teke Ízurẹlu bu l'alị ẹka ono bẹ Rúbẹnu jepfuru nyee nna iya, nna iya ta alụdu ọkpobe alụlu, bụ Biliha. Nna iya, bụ Ízurẹlu nụma iya. Jiékọpu nwụtaru unwoke iri l'ẹbo. ");
INSERT INTO izz_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ụnwu kẹ Lii bụ: Rúbẹnu, bụ iya bụ ọkpara Jiékọpu; waa Simiyọnu; waa Lívayi; waa Jiuda; waa Isaka; tẹme waa Zebulọnu. ");
INSERT INTO izz_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ụnwu kẹ Rechiẹlu bụru Jiósẹfu waa Benjiaminu. ");
INSERT INTO izz_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ụnwu kẹ Biliha, bụ ohu Rechiẹlu bụru Danu waa Nafụtali. ");
INSERT INTO izz_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ụnwu kẹ Zilipa, bụ ohu Lii bụru Gadu waa Asha. Ọ bụru ndu ono g'ẹphe ha bụ ụnwu, a nwụshikotaru Jiékọpu l'alị Padanu-Arámu. ");
INSERT INTO izz_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jiékọpu lwapfuta nna iya, bụ Áyizaku lẹ Mamure, nọ lẹ mgboru Kiriyatu-Araba, bụ iya bụ Hẹburonu; l'ẹka Ébirihamu yẹe Áyizaku shi tụko buru. ");
INSERT INTO izz_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Áyizaku nọru ụkporo apha tete. ");
INSERT INTO izz_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ọo ya bụ; ọ tụa unme ikpazụ iya; ọ bụru iya anwụhu. Ọ lapfu ndiche phẹ lẹ g'ọ kahụcharu; bya anọo apha, dụ igwerigwe. Ụnwu iya, bụ Jiékọpu yẹe Ịso woru iya lia. ");
INSERT INTO izz_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Waa oshilọkpa Ịso, bụ iya bụ Edọmu baa: ");
INSERT INTO izz_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ịso lụru ụnwanyi ndu Kénanu. Ẹpha phẹ bụ Ada, bụ nwada Elọnu, onye Hetu; waa Oholibama, bụ nwada Ana; bya abụru nwanwa Zibiyọnu, onye Hevu; ");
INSERT INTO izz_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","wakwaphọ Basumatu, bụ nwada Ishimẹlu; bya abụru nwune Nebayotu. ");
INSERT INTO izz_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nwụtaru Ịso Elifazu; Basumatu nwụtaru iya Ruwẹlu; ");
INSERT INTO izz_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nwụtaru iya Jiwushi; waa Jielamu; waa Kora. Ndu ono bụkota ụnwu Ịso; ọ bụru l'alị Kénanu bẹ a nọ nwụshiru iya ya. ");
INSERT INTO izz_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ịso bya eduta unyomu iya; waa ụnwu iya unwoke; yẹe kẹ nwanyị; mẹkpoo iphe, bụkota ndibe iya g'ẹphe hakọta; tẹme waa iphe-edobe iya; waa anụ iya ndu ọzo; mẹkpoo ẹku, ọ kpatakọtaru lẹ Kénanu g'ọ ha; gude lashịa alị ẹka dụ ẹnya; mẹ a -gbẹ l'ẹka nwune iya Jiékọpu bu. ");
INSERT INTO izz_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ẹku phẹ pawaru ẹka; k'ọphu ọ daghawaru g'ẹphe atụko buru l'ẹka lanụ. Kẹle iphe-edobe phẹ ono meru; ọphu alị ẹka ono asụedu phẹ ebubu. ");
INSERT INTO izz_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ọo ya bụ; Ịso, bụ iya bụ Edọmu je eburu l'ọha úbvú Siye. ");
INSERT INTO izz_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Wa oshilọkpa Ịso, bụ nna ndu Edọmu l'ọha úbvú Siye baa: ");
INSERT INTO izz_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Waa ẹpha ụnwu Ịso baa: Elifazu, bụ iya bụ nwa nwoke, Ada, bụ nyee Ịso nwụtaru iya; waa Ruwẹlu, bụ iya bụ nwa nwoke, Basumatu, bụkwapho nyee Ịso nwụtaru iya. ");
INSERT INTO izz_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ụnwu nwa nwoke kẹ Elifazu bụ Temanu; waa Omaru; waa Zefo; waa Getamu; tẹme waa Kenazu. ");
INSERT INTO izz_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Nwa Ịso; mbụ Elifazu nweru nyee ya ọphu ọ tọo lụdu ọkpobe alụlu, ẹpha iya bụ Timuna. Nwanyị ono nwụtaru iya nwa nwoke, aza Amalẹku. Ndu ono bụkota ụnwu nwanwa Ada, bụ nyee Ịso. ");
INSERT INTO izz_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ụnwu nwa nwoke kẹ Ruwẹlu bụ: Nehatu; waa Zera; waa Shama; tẹme waa Miza. Ndu ono bụkota ụnwu nwanwa Basumatu, bụ nyee Ịso. ");
INSERT INTO izz_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ụnwu Oholibama, bụ nyee Ịso; mbụ nwada Ana bya abụru nwanwa Zibiyọnu nwụtaru Ịso bụ: Jiwushi; waa Jielamu; tẹme waa Kora. ");
INSERT INTO izz_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Waa ndu-ishi l'oshilọkpa Ịso baa. Ọkpara Ịso, bụ Elifazu nwụru ndu-ishi, bụ: Temanu; waa Omaru; waa Zefo; waa Kenazu; ");
INSERT INTO izz_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","waa Kora; waa Getamu; tẹme waa Amalẹku. Ndu ono bụ ndu-ishi alị Edọmu, shi l'eri Elifazu. Ẹphe bụ ụnwu nwanwa Ada. ");
INSERT INTO izz_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ruwẹlu, bụ nwa Ịso, nwụru ndu-ishi, bụ Nehatu; waa Zera; waa Shama; tẹme waa Miza. Ndu ono bụ ndu-ishi alị Edọmu ndu ọphu shi l'eri Ruwẹlu. Ẹphe bụ ụnwu nwanwa nyee Ịso, bụ Basumatu. ");
INSERT INTO izz_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Oholibama, bụ nyee Ịso nwụru ndu-ishi, bụ Jiwushi; Jielamu; tẹme waa Kora. Ndu ono bụ ndu-ishi ndu ọphu shi l'eri nyee Ịso, bụ Oholibama, bụ nwatibe Ana. ");
INSERT INTO izz_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","G'ẹphe hakọta ono bụ ụnwu Ịso, bụ iya bụ Edọmu; bya abụru phẹ bụ ndu-ishi phẹ. ");
INSERT INTO izz_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Waa ụnwu Siye, onye Họru, bụ onye nwe alị ono baa: Lotanu; waa Shobalu; waa Zibiyọnu; tẹme waa Ana; ");
INSERT INTO izz_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","waa Dishọnu; waa Eza; tẹme waa Dishanu. Ụnwu Siye ono, bu l'alị Edọmu ono bụ ndu-ishi ndu Họru. ");
INSERT INTO izz_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ụnwu Lotanu bụ Hori; waa Homamu. Timuna bụ nwune Lotanu kẹ nwanyị. ");
INSERT INTO izz_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ụnwu Shobalu bụ Aluvanu; waa Manahatu; waa Ebalu; waa Shefo; tẹme waa Onamu. ");
INSERT INTO izz_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ụnwu Zibiyọnu bụ Aya; waa Ana. Ana k'ọwa-a bụ onye ọphu hụmaru nggele, ekpo ọku l'echiẹgu teke o shi eche nkapfụ-ịgara nna iya, bụ Zibiyọnu. ");
INSERT INTO izz_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ụnwu Ana bụ Dishọnu; waa Oholibama, bụ nwada iya. ");
INSERT INTO izz_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ụnwu Dishọnu bụru Hẹmudanu; waa Ẹshubanu; waa Ituranu; tẹme waa Keranu. ");
INSERT INTO izz_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ụnwu Eza bụ Bilihanu; waa Zevanu; tẹme waa Ekanu. ");
INSERT INTO izz_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ụnwu Dishanu bụ Uzu; waa Eranu. ");
INSERT INTO izz_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ndu bụ ndu-ishi ndu Họru bụ: Lotanu; waa Shobalu; waa Zibiyọnu; waa Ana; ");
INSERT INTO izz_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","waa Dishọnu; waa Eza; tẹme waa Dishanu. Ọo ẹphebedua bụ ndu-ishi ndu Họru; e -shi lẹ g'ẹphe gude kekashịa onwophẹ l'alị Siye ọbu. ");
INSERT INTO izz_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ọwa-a bụ ndu vuadaru ụzo bụru eze ndu Edọmu; tẹme o nwejeru onye shi lẹ Ízurẹlu bya abụru eze: ");
INSERT INTO izz_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, bụ nwatibe Beyọ bẹ bụ eze ndu Edọmu. Mkpụkpu iya aza Dinuhaba. ");
INSERT INTO izz_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela nwụhuepho; Jiobabu, bụ nwatibe Zera, bụ onye shi Bọzura bya abụru eze l'ọnodu iya. ");
INSERT INTO izz_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jiobabu nwụhuepho; Hushamu, bụ onye shi l'alị Temanu bya anọ-chia ẹnya iya bụru eze. ");
INSERT INTO izz_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu nwụhuepho; Hadadu, bụ nwatibe Bedadu, bụ onye lwụ-kperu ndu Midiyanu l'alị Mówabu; bya abụru eze l'ọnodu iya. Mkpụkpu nkiya aza Avitu. ");
INSERT INTO izz_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadu nwụhuepho; Samụla, bụ onye shi Masureka bya anọ-chia ẹnya iya bụru eze. ");
INSERT INTO izz_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samụla nwụhuepho; Shawulu, bụ onye shi Rehobotu, nọ l'ụzo ọnu ẹnyimu Yufurétisu; bya abụru eze nọ-chia ẹnya iya. ");
INSERT INTO izz_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawulu nwụhuepho; Belu-hananu, bụ nwatibe Akụbo bya abụru eze l'ọnodu iya. ");
INSERT INTO izz_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Belu-hananu, bụ nwatibe Akụbo nwụhuepho; Hadadu bya abụru eze l'ọnodu iya. Ẹpha mkpụkpu iya bụru Pawu; ẹpha nyee ya bụru Mehetabẹlu, bụ nwada Maturedi. Maturedi bụkwanuru nwada Mezahabu. ");
INSERT INTO izz_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Waa ẹpha ndu-ishi l'oshilọkpa Ịso baa; wakwaphọ ọkpa-ipfu; yẹe ọhamoha, ẹphe shigbaa, l'azagbaa ẹpha phẹ baa. Timuna; waa Aluva; waa Jietẹtu; ");
INSERT INTO izz_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","waa Oholibama; waa Ela; waa Pinọnu; ");
INSERT INTO izz_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","waa Kenazu; waa Temanu; waa Mibiza; ");
INSERT INTO izz_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","waa Magudẹlu; tẹme waa Iramu. Ndu-a g'ẹphe ha bụ ndu-ishi ndu Edọmu; lẹ g'ẹphe gude bua l'alị ono, ẹphe lwarụ ono. Ẹphe bụ ndibe Ịso, bụ nna ndu Edọmu. ");
INSERT INTO izz_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ọo ya bụ; Jiékọpu buru l'alị ono, nna iya shi buru, bụ iya bụ alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Waa oshilọkpa Jiékọpu. Gẹ Jiósẹfu nọerupho apha iri l'ẹsaa bẹ o shi etsojeru ụnwunna iya eche atụru; mbụ ụnwu nyee nna iya, bụ Biliha; waa Zilipa. O dooru nna phẹ ẹjo-iphe, ụnwunna iya ndu ọphuu anọduje eme. ");
INSERT INTO izz_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","No iya; Ízurẹlu ka eye Jiósẹfu obu eme lẹ g'o yeru ụnwu iya ndu ọphuu. Iphe, kparụ iya nụ bụru l'ọo nwa, a nwụru iya lẹ nka. Ọ bya akwaaru Jiósẹfu ẹguru uwe, ama ntụmatu, chịkashiru mkpọ. ");
INSERT INTO izz_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ụnwunna iya maẹrupho lẹ nna phẹ ka iya eye obu eme lẹ g'o yeru ẹphebedua; ẹphe kpọo ya ashị; ọphu ẹphe epfujehẹduru opfu ọma eyeru iya. ");
INSERT INTO izz_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tọbudu iya bụ; Jiósẹfu rwọo nrwọ bya ezeeru ụnwunna iya ono nrwọ ono. O mee; ọ kabakpọo phẹ rọ adụ ashị. ");
INSERT INTO izz_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ọ sụru phẹ: “Unu gebe gẹ mu zeeru unu nrwọ, mu rwọru. ");
INSERT INTO izz_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Anyi esweshi upfu ereshi esweshi l'ẹgu. A nọnyaa; upfu ereshi nkemu gbalihu pfụru nhamụnha; upfu iya k'unu bya anophee nkemu mgburugburu phozegbaaru iya.” ");
INSERT INTO izz_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ụnwunna iya sụ iya: “?Ịiri l'ii-mechaa bụru eze anyi tọo? Mbụ-a; ?bụwaa ngu e-mecha bụru onye-ishi anyi?” Nrwọ ono, ọ rwọru ono; yẹe opfu ono, o pfuru ono mee; ọ kabakpọo phẹ rọ adụ ashị. ");
INSERT INTO izz_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","No iya; ọ byakwa arwọo nrwọ ọzo; bya ezeeru ụnwunna iya ono ọzo. Ono bẹ ọ sụru phẹ: “Unu gebe gẹ mu zeeru unu nrwọ ọzo, mu rwọru. Ọgiya-a bẹ mu rwọru g'ẹnyanwu; waa ọnwa; waa kpokpode iri lẹ nanụ bya ephozeru mu ishi.” ");
INSERT INTO izz_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","O zeẹru iya phọ nna iya g'o zeru iya ụnwunna iya; nna iya baarụ iya mba sụ iya: “?Iphe ọwa-a, ịirwo ọwa-a bụ gụnu? ?Bụ lẹ ne ngu; waa mbẹdua, bụ nna ngu; waa ụnwunna ngu bẹ e-mecha bya ephozeru ngu tọo?” ");
INSERT INTO izz_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ụnwunna iya jiaharu iya ijiẹnya; obenu lẹ nna iya kwakọberu iphe ono l'ọkpoma. ");
INSERT INTO izz_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Noo ya; ụnwunna iya chịta atụru nna phẹ jeshia echeche lẹ mgboru mkpụkpu Shẹkemu. ");
INSERT INTO izz_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ọo ya bụ; Ízurẹlu sụ Jiósẹfu: “Eshi ọphu ị maru l'ụnwunna ngu eche atụru lẹ mgboru Shẹkemu bụkwa g'ị bya gẹ mu zia ngu g'i je agbaphe phẹ.” Jiósẹfu sụ nna iya l'ọ dụ ree. ");
INSERT INTO izz_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ọo ya bụ; ọ sụ iya: “Jiko jenụ je agbaphee ụnwunna ngu phẹ; yẹe atụru phẹ; maru ?ẹhu dụchaa phẹ-a ree? L'ịilwa bya akaru mu g'ọ dụ.” Ọ bụru lẹ nsụda Hẹburonu bẹ ọ nọ zia ya ozi ọbu. Ọ tụgbua jeshia; bya ejerwua Shẹkemu. ");
INSERT INTO izz_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","O nweru nwoke hụmaru iya l'ẹka ọogha-phe l'ẹgu ẹka ono; bya ajịa ya sụ: “?Bụ gụnu bẹ ịicho?” ");
INSERT INTO izz_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ọ sụ iya: “Mu elekwa ẹnya ụnwunna mu. Ọ -bụru l'ị maru ẹka ẹphe nọ eche atụru phẹ; jiko tụnuru mu ọnu iya.” ");
INSERT INTO izz_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nwoke ono sụ iya: “Ẹphe shiakwa l'ẹka-a tụgbuwa. Mu nụmakwaru teke ẹphe shi epfu sụ g'ẹphe je Dotanu.” Ọo ya bụ; Jiósẹfu chọoru ụnwunna iya jeshia; je ahụma phẹ lẹ mgboru Dotanu. ");
INSERT INTO izz_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ẹphe levukpọo ya rọ teke ọ nọkwadu ụzenya; bya awata achị idzu g'ẹphe e-shi gbua ya. ");
INSERT INTO izz_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ẹphe sụ nwibe phẹ: “Ọ-rwọ-nrwọ-a abyajẹ-o! ");
INSERT INTO izz_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Unu bya nta-a g'anyi gbua ya chie lẹ nsụ lanụ l'ẹka-a. E -mechaa; anyi asụ l'ọo anụ-ẹgbudu gburu iya. G'anyi mawarụro gẹ nrwọ iya ono e-me vụa.” ");
INSERT INTO izz_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rúbẹnu nụmae ya phọ bya emeahaa g'ọ gbafụta iya. Ọ sụ phẹ: “Unu g'anyi te egbushi iya egbugbu. ");
INSERT INTO izz_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","G'anyi be gbushi ọchi. G'anyi chiechia ya lẹ nsụ lanụ l'echiẹgu l'ẹka-a; g'anyi te edenyikwa iya ẹka.” Iphe, Rúbẹnu gude pfua ya bụ g'ọ dzọo ya duta iya duphuru nna iya azụ ọzo. ");
INSERT INTO izz_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jiósẹfu byarwutaẹpho ẹka ụnwunna iya ono nọ; ẹphe gude iya yefụ iya ẹguru uwe ono, o yeru ono, chịkashiru mkpọ ono; ");
INSERT INTO izz_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bya akpụta iya je echie lẹ nsụ. Nsụ ọbu ta adụdu iphe, dụ iya nụ; ọphu mini adụdu iya. ");
INSERT INTO izz_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ẹphe nọ-zetaẹpho anọo wata eri nri; ẹphe jeshia ele ẹnya bya ahụma ndu ije, shi l'eri Ishimẹlu; ẹka ẹphe shi l'alị Giladu; ẹphe l'ịnya-kamẹlu phẹ; vuru manụ, eshi mkpọ; waa ụ̀nwù, eshikwaphọ mkpọ; waa àrwụ̀, bụ mẹru eje ala alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Jiuda sụ ụnwunna iya: “?Bụ urwu gụnu bẹ anyi e-rita iya m'ọ bụru l'anyi gburu nwanna anyi bya eworu mee ya domia? ");
INSERT INTO izz_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Unu g'anyi ree ya oshilọkpa Ishimẹlu. G'ọ tọ dụkwa iphe, anyi e-je iya ememe; eshi ọphu ọ bụ nwanna anyi; tẹme anyi bụru mee lanụ.” Ụnwunna iya kweta. ");
INSERT INTO izz_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ndu Midiyanu ono, agba nghọ ono ghatashịepho; ụnwunna Jiósẹfu bya ekufuta iya lẹ nsụ ono; woru iya ree oshilọkpa Ishimẹlu ono ụkporo ẹkpa-ego mkpọla-ọchaa. Ẹphe kpụta iya lashịa Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rúbẹnu byaẹpho lẹ nsụ ono bya ahụma lẹ Jiósẹfu ta nọedu iya; o gude ẹhu-eghu woru uwe iya gbajaa. ");
INSERT INTO izz_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","O jepfu ụnwunna iya phẹ je asụ phẹ: “Nwata ono ta nọekwa l'ẹka e chieru iya. ?Bụkpoo awe bẹ mu e-dobe iphu?” ");
INSERT INTO izz_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Noo ya; ẹphe bya achịta uwe Jiósẹfu bya egbua eghu; woru uwe Jiósẹfu ono tsẹe lẹ mee ya. ");
INSERT INTO izz_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ẹphe chịta uwe ono, chịkashiru mkpọ ono chiphuru nna phẹ azụ; sụ iya: “Anyi hụmakwaru iphe-a l'ụzo; lekwaa ya ẹnya g'ị maru ?bụ kẹ nwa ngu tọo tọ bụdu iya?” ");
INSERT INTO izz_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jiékọpu bya elee ẹnya; ọ bụru iya. Ọ sụ: “Ọ kwa uwe nwa mu-o! Ọ dụkwa g'ọ bụ anụ-ẹgbudu gburu iya. Oowaa! Nta-a bẹ Jiósẹfu bẹ anụ-ẹgbudu lajashịakwaru nanụ nanụ!” ");
INSERT INTO izz_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jiékọpu woru uwe iya gbajaa; bya achịta uwe aphụ yee onwiya; bya araa ẹkwa nwa iya ono ujiku olemole. ");
INSERT INTO izz_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ụnwu iya k'unwoke; mẹ ụnwada iya bya g'ẹphe dụa ya obu. Ọphu o kwedu g'a dụta iya. O pfua sụ: “Mu a-gụkwa aphụ nwa mu-a jasụ mu alapfu iya lẹ maa.” Ọ bụru ẹgube ono bụ gẹ nna iya gude gụa aphụ iya. ");
INSERT INTO izz_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","No iya; ndu Midiyanu ono woru Jiósẹfu ree Potifa l'alị Ijiputu. Potifa ono bụ onye lanụ l'ime ndu Fero nụru oke-ọkwa; kẹle ọ bụ ishi ndu ojọgu, eche Fero nche. ");
INSERT INTO izz_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Lẹ teke ono bẹ Jiuda harụ ụnwunna iya je; ẹphe lẹ nwoke Adulamu, aza Hira buru. ");
INSERT INTO izz_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ọ bụru l'ẹka ono bẹ Jiuda nọ hụma nwada nwoke Kénanu, ẹpha iya bụ Shuwa. Ọ lụta iya; ẹphe l'iya kwaa. ");
INSERT INTO izz_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ọ tsụta ime; bya anwụa nwa nwoke a gụru Ẹru. ");
INSERT INTO izz_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ọ tsụta ime ọzo; bya anwụa nwa nwoke; bya agụa ya Ọnanu. ");
INSERT INTO izz_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ọ bya anwụfua nwa nwoke lanụ; bya agụa ya Shela. Ọ bụru lẹ Kezibu bẹ ọ nọ nwụa ya. ");
INSERT INTO izz_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Jiuda bya alụtaru ọkpara iya bụ Ẹru, nwanyị. Ẹpha nwanyị ono bụ Tema. ");
INSERT INTO izz_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Obenu lẹ Ẹru, bụ ọkpara Jiuda bụ onye eme ẹjo-iphe l'ẹnya Chipfu. Ọo ya bụ; Chipfu woru iya gbua. ");
INSERT INTO izz_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ọo ya bụ; Jiuda sụ Ọnanu: “Duta nyee nwune ngu g'unu l'iya kwaa. Lụru iya g'iishi nno tọgboru nwune ngu akọ lẹ mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Obenu lẹ Ọnanu maru lẹ nwa, nwanyị ono a-nwụta ta abụduru nkiya. Ọ nọdu abụjeru; yẹe nyee nwune iya -nọdu akwa; l'ọogboshia ụnwuda l'alị g'eeshi gẹ nwune iya ta tọgbo akọ. ");
INSERT INTO izz_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Iphe ono, oomeje ono bụru ẹjo-iphe l'iphu Chipfu; o wokwaru iya phọ gbua. ");
INSERT INTO izz_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","E mechaa; Jiuda sụ nyee nwa iya, bụ Tema g'ọ laa ibe nna iya je eburu eburu kwabẹ jasụ teke Shela, bụ nwa iya evuta. Kẹle ọ rịru sụ: “?A maru ?onye k'ono ta anwụhudunu g'unwune iya ndu ọphuu nwụhuru.” Tema kwe hm laa ibe nna iya je eburu. ");
INSERT INTO izz_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A nọnyakpoepho; nyee Jiuda, bụ nwada Shuwa nwụhu. Jiuda rọkotachaepho ike l'anwụhu nyee ya ono; bya ejeshia Timina; l'ẹka eebushiru iya atụru iya ẹji. Ọ̀nyà iya, bụ Hira, onye Adulamu tsoru iya. ");
INSERT INTO izz_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A bya edooru iya Tema lẹ nna ji iya ejekwa Timina je ebushi atụru iya ẹji. ");
INSERT INTO izz_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","O kweẹpho doo yefụ uwe nwanyị, nọ l'ụlo-maa, o yeru; bya eworu gẹrebe gẹrebe ẹkwa phụa onwiya l'iphu g'a ta hụbe iya ama; bya eje anọdu l'ọnu-abata, e shi abahụ Enému, bụkwapho ụzo, e shi eje Timina. Kẹle ọ maru lẹ Shela vutawaru; obenu l'e te kuduru iya g'ọ bya g'ọ lụpyabe iya gẹ ya bụru nyee ya. ");
INSERT INTO izz_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Jiuda hụma Tema; bya arịa l'ọo nwanyị-ovuọba; noo kẹle ọ phụ-chiru onwiya iphu; ");
INSERT INTO izz_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ọphu ọ madụ l'ọo nyee nwa iya. O duta iya je l'agụga gbororo bya asụ iya g'ọ bya g'ẹphe l'iya je akwaa. Ọ jịa ya sụ: “?Bụ gụnu bẹ ịi-nụ mu g'anyi lẹ ngu kwaa ọbu?” ");
INSERT INTO izz_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ọ sụ iya: “Mu e-shi l'iphe-edobe mu kpẹe ngu ada-eghu.” O kwe iya hm; bya asụ iya: “?Ii-yekwanụru mu iphe l'itumo; gẹ mu gude jasụ l'ịikputaru mu iya?” ");
INSERT INTO izz_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ọ sụ iya: “?Bụ gụnu bẹ mu e-yeru ngu l'itumo ọbu?” O sụ iya: “Ọo iphe, agba l'ẹka ngu, eegudeje hụbe ngu ama; waa eri, tso iya nụ; waa oshi-mpalẹka ngu ono, i gude l'ẹka ono.” Ọ chịru iya nụ iya; ẹphe l'iya je akwaa; o woru ime yee ya. ");
INSERT INTO izz_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ọ tụgbuepho bya eje aphụfu ẹkwa ono, o shi phụa l'iphu ono; bya eje eworu uwe nwanyị, nọ l'ụlo-maa, o shi yee woru yephu azụ. ");
INSERT INTO izz_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E mechaa; Jiuda bya akpụta ada-eghu ono kpẹe ọ̀nyà iya, onye Adulamu g'o je akpẹe nwanyị ono; chịtaru iya iphe, o yeru iya l'itumo ono. O jee ọphu ọ hụmaeduru nwanyị ọbu. ");
INSERT INTO izz_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ọ jịa ndu bu l'ẹka ono sụ: “?Dẹnu nwanyị-ovuọba, shi nọdu l'agụga ụzo Enému-a?” Ẹphe sụ iya: “Nwanyị-ovuọba ta nọjekwaru l'ẹka-a.” ");
INSERT INTO izz_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ọo ya bụ; ọ laa je asụ Jiuda lẹ ya ta ahụmakwaru iya. Tẹme ọzo bụ lẹ ndu bu l'ẹka ono sụkwaru lẹ nwanyị-ovuọba ta nọjeduru l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Jiuda sụ: “G'a hakwaa ya g'o nwowarụro iphe, o gude; a -nọnyaa; e gude iya gbaaharu anyi mgbọnu. Eshi ọphu mu kpẹru ngu ada-eghu, i gude je achọkota iya; ọphu ị hụmaduru iya.” ");
INSERT INTO izz_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","A nọepho iphe, rwuru ọnwa ẹto; a bya asụ Jiuda: “Tema, bụ nyee nwa ngu bẹ bụakwaa nwanyị-ovuọba; mbụ lẹ-a; ọ dụkwaa ime. Ọ bụru l'ovuọba ono bẹ o vutarụ iya.” Jiuda sụ: “Unu kpụfuta iya g'e kegbua ya l'ọku!” ");
INSERT INTO izz_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A kpụfutashia ya; o zia ozi g'e je ezia nna ji iya ono sụ iya l'ọ kwa onye nwe iphe-a bẹ yeru iya ime ono. Sụ iya: “Maẹshikwaru ?ịi-dụ ike maru onye nwe iphe, agba l'ẹka eegudeje ahụbe nemadzụ ama-a; waa eri, tso iya nụ; waa oshi-mpalẹka-a?” ");
INSERT INTO izz_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Jiuda hụma iphe ono bya amaru l'ọo nkiya bya asụ: “Ha! Nwanyị-a kakwa mu apfụbekoto; eshi ọphu mu sụcharu lẹ mu e-kuru iya nụ nwa mu, bụ Shela g'ọ lụru. E mechaa; ọphu ẹphe l'iya alụeduru.” ");
INSERT INTO izz_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","O rwuẹ ya phọ l'ezeda; a maru l'ụnwu ono dụ iya ẹbo l'ẹpho. ");
INSERT INTO izz_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Lẹ g'oozeda bẹ onye lanụ wofutarụ ẹka. Nwanyị, eswije ime bya ewota ẹba oghu, dụ uswe-uswe libe iya lẹ nkwo-ẹka; bya asụ l'ọo onye ọwa-a bụ ivuzọ. ");
INSERT INTO izz_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","O wobaẹpho ẹka ono; nwune iya kwofuta. Nwanyị, eswi ime ono sụ: “?Bụ g'i shiru kpakata ụzo baa?” A gụa ya Pẹ́rezu. ");
INSERT INTO izz_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ọo ya bụ; nwune iya onye ọphuu, a gbabẹru ẹba oghu, dụ uswe-uswe lẹ nkwo-ẹka ono lụfuta; a gụa ya Zera. ");
INSERT INTO izz_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tọbudu iya bụ; e gude Jiósẹfu jerwua alị Ijiputu. Ọ bụru Potifa onye Ijiputu zụru iya ndu oshilọkpa Ishimẹlu ono, gude iya jerwua alị Ijiputu ono. Potifa ono tso lẹ ndu nọ l'oke-ọkwa. Yẹbedua bụ onye-ishi ndu ojọgu, anọduje eche Fero nche. ");
INSERT INTO izz_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Chipfu nọ-kube Jiósẹfu; ọ bụru onye iphe ejehuru. O buru l'ụlo nnajịuphu iya, bụ nwoke Ijiputu ono. ");
INSERT INTO izz_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nnajịuphu iya ono hụmaepho lẹ Chipfu nọ-kube iya; tẹme lẹ Chipfu emeje g'iphemiphe, Jiósẹfu ono eme vuru ire; ");
INSERT INTO izz_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Jiósẹfu dụ iya l'obu. O woru Jiósẹfu mee onye-ozi iya; mbụ mee ya onye elekọta unuphu ibe iya l'ophu ẹnya; tẹme o wokwarụpho iphemiphe, o nweru yekọta iya l'ẹka g'o leta ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Eshi teke ono, o woru unuphu ibe iya l'ophu; yẹe iphemiphe, o nweru enweru yekọta Jiósẹfu l'ẹka g'o leta ẹnya ono bẹ Chipfu bya ekebeahaa nwoke Ijiputu ono l'ọma shita l'ẹhu Jiósẹfu. Chipfu kebeahaa ya l'ọma l'iphemiphe, o nweru enweru; je akpaa lẹ ndu ọphu nọ l'unuphu; mẹ lẹ ndu ọphu nọ l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ọo ya bụ; ọ hakọtaru Jiósẹfu ẹku iya l'ophu g'o leta ẹnya. Ọphu ọ dụedu iphe, o nweru, ọokpajekwadu ishi iya. Iphe, ọ maẹrupho kpoloko bụ g'o ria nri. Jiósẹfu gbaru mkparawa bya amashị mma ike. ");
INSERT INTO izz_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","A nọepho nwanshịi; Jiósẹfu gụahaa nyee nnajịuphu iya ono; ọ sụ iya g'ọ bya g'ẹphe l'iya je akwa. ");
INSERT INTO izz_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Obenu lẹ Jiósẹfu jịkaru bya asụkwapho nyee nnajịuphu iya ono: “A -gbẹ teke nnajịuphu mu meru mu onye-ishi iphemiphe, o nwekọtaru bẹ ọ tọ dụedu iphe, eeme l'unuphu-a, ọokpajekwadu ishi iya. Iphemiphe, o nweru g'ọ ha bẹ o yekọtawaru mu l'ẹka gẹ mu leta ẹnya. ");
INSERT INTO izz_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ọphu ọ tọ dụdu onye kabaa mu shii l'ụlo-a. Ọphu ọ dụkwapho iphe, oowoharu mu ewoha gbahaa gụbedua; kẹle ị bụ nyee ya. ?Dẹnu gẹ mu e-shi mee ẹjo-iphe, dụ ẹgube ono; mbụ mee Chileke iphe-ẹji onoya?” ");
INSERT INTO izz_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ọ nọdu anọdujekpoepho epfuru iya Jiósẹfu mbọkumboku; obenu lẹ Jiósẹfu te ekwedu g'ẹphe l'iya kwaa; mbụkponu g'ẹphe l'iya nọ-kube ntse. ");
INSERT INTO izz_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","O be ujiku lanụ; Jiósẹfu bahụ l'ụlo gẹ ya je ozi, dụru iya nụ. Teke ono bẹ ọ tọ dụdu ndu-ozi ụlo ono l'ophu m'onye lanụ, nọ l'ime ụlo ono; ");
INSERT INTO izz_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","o gude iya l'uwe sụ iya g'ọ bya g'ẹphe l'iya kwaa. Jiósẹfu yefụ uwe iya ono haa ya l'ẹka gbado ụlo ono gbafụ etezi. ");
INSERT INTO izz_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ọ maẹrupho lẹ Jiósẹfu yefuru uwe iya haa ya l'ẹka gbafụ etezi; ");
INSERT INTO izz_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","o kua ndu-ozi ụlo iya ndu ọphuu; sụ phẹ: “Unu lenu! Nwọphu shi l'alị ndu Hiburu-a bẹ e dutaru dobe; g'ọ bya anyi eme iphe-iphere. Ọ bataru l'ẹka-a bya g'anyi l'iya kwaa; mu chishia mkpu. ");
INSERT INTO izz_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ọ nụmaepho lẹ mu chiaharu mkpu; ọ gbadoo mu uwe iya l'ẹka gbala gbafụ etezi.” ");
INSERT INTO izz_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","O gude uwe ono gbiriri jasụ nnajịuphu Jiósẹfu bata. ");
INSERT INTO izz_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ọ bya eworu iya pfuaru iya sụ: “Nwohu ono, ị zụtaru, bụ onye Hiburu ono bẹ shi eme g'o mee mu iphe-iphere ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mu wataẹpho echi mkpu; ọ gbadoo mu uwe iya l'ẹka gbala gbafụ etezi.” ");
INSERT INTO izz_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nnajịuphu Jiósẹfu nụmaepho iphe ono, nyee ya pfuru iya ono sụ l'onoo g'ohu iya meru iya ya bụ ono; ọ vụru ọku wụa ẹhu. ");
INSERT INTO izz_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ọ kpụta Jiósẹfu jeye l'ọka-mkpọro, eze atụ-chije ndu mkpọro iya. Ọle Jiósẹfu nọ lẹ mkpọro ono; ");
INSERT INTO izz_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Chipfu nọ-kube iya bya egoshi iya lẹ ya yeru iya obu. O mee; Jiósẹfu dụ onye eche ọka-mkpọro ono nche l'obu. ");
INSERT INTO izz_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Onye eche ọka-mkpọro ono woru Jiósẹfu mee ishi ndu nọkota l'ọka-mkpọro ono. Iphemiphe, eemekọta l'ẹka ono bụru yẹbe Jiósẹfu bẹ e yeru iya l'ẹka. ");
INSERT INTO izz_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Iphe, nọwa Jiósẹfu l'ẹka bẹ onye eche ọka-mkpọro ono ta akpajẹedu ishi g'ee-me iya; noo kẹle Chipfu nọ-kube Jiósẹfu bya emee; iphemiphe, oome nọdu evujeru ire. ");
INSERT INTO izz_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","O nweru teke a nọnyaru; onye etsujeru eze ndu Ijiputu ọnu lẹ mẹe; yẹe onye eghejeru iya buredi meswee nnajịuphu phẹ, bụ eze ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ụmadzu labọ ono, ejeru iya ozi ono, bụ onye-ishi ndu etsujeru iya ọnu lẹ mẹe; waa onye-ishi ndu eghejeru iya buredi phọ mee; ẹhu ghuahanaa Fero ọbu eghu. ");
INSERT INTO izz_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","O ye phẹ l'ọka-mkpọro l'ibe onye-ishi ndu ojọgu, anọduje eche Fero nche, bụ ẹka a tụ-chikwarụpho Jiósẹfu. ");
INSERT INTO izz_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Onye-ishi ndu ojọgu, anọduje eche Fero nche woru phẹ ye l'ẹka Jiósẹfu; ọ nọdu eleta phẹ ẹnya. Ẹphe nọnyaepho l'ẹka ono; ");
INSERT INTO izz_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","unwoke labọ ono; mbụ onye etsujeru eze ndu Ijiputu ọnu lẹ mẹe; yẹe onye eghejeru iya buredi, bụ ndu tụko nọdu lẹ mkpọro ono bya atụko rwọo nrwọ l'ẹnyashi ujiku lanụ. Nrwọ ono nwecharu iphe, ọ fụtaru iche iche. ");
INSERT INTO izz_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Jiósẹfu bya l'ụtsu iya bya ahụma l'ẹphe adzụ iphu. ");
INSERT INTO izz_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ọo ya bụ; ọ jịa ndu ono, bụ ndu nọ l'oke-ọkwa Fero, a tụkoru ẹphe lẹ yẹbe Jiósẹfu tụ-chia l'ibe nnajịuphu iya ono; sụ phẹ: “?Bụ gụnu kparụ iphe, unu adzụ iphu kẹ ntanụ?” ");
INSERT INTO izz_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ẹphe sụ l'ẹphenebo ono tụko rwọo nrwọ; ọphu ọ dụdu onye a-kọru phẹ iphe, nrwọ ono fụtaru. Jiósẹfu sụ phẹ: “?Tọbudu Chileke bu onye akọje iphe, a rwọru lẹ nrwọ? Jiko unu zeẹshikwaru mu nrwọ ono, unu rwọru ono.” ");
INSERT INTO izz_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ọo ya bụ; onye-ishi ndu etsujeru Fero ọnu lẹ mẹe bya ezeeru Jiósẹfu nrwọ nkiya; sụ iya: “Mu rwọru nrwọ gẹ mu hụmaru vayịnu l'atatiphu mu. ");
INSERT INTO izz_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Vayịnu ono nweru ẹkali ẹto. Ọ tụchaa ige; bya ajaa àjàjà; bya amịshia kẹ wọgalaa; bya achashịa. ");
INSERT INTO izz_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mu gude okoro Fero l'ẹka; bya ewota akpụru vayịnu ono pyịru ye l'okoro Fero; bya eworu iya nụ iya.” ");
INSERT INTO izz_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jiósẹfu sụ iya: “Waa iphe, nrwọ ono bụ baa. Ẹkali-oshi ẹto ono bụ ujiku ẹto. ");
INSERT INTO izz_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","A -nọepho ujiku ẹto; Fero abya edufuta ngu l'ẹka-a; bya edobe ngu l'ọnodu, i shi nọdu; l'ịibya agbaaharu Fero mẹe ẹgube ono, i shi emeje teke ono, i shi bụru onye etsujeru iya ọnu lẹ mẹe phọ. ");
INSERT INTO izz_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Teke iphemiphe adụeru ngu phọ lẹ ree; jiko nyatakwa mu. Iphe-ọma, ii-meru mu bụ g'i pfuaru Fero opfu ẹhu mu dufuta mu l'ọka-mkpọro-a; ");
INSERT INTO izz_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","kẹle ọ kwa ezita bẹ e zitaru mu l'oshi l'alị ndu Hiburu. O rwukwaa l'ẹka-a; a bya atụa mu mkpọro l'ẹbe adụ iphe, mu meru.” ");
INSERT INTO izz_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Onye-ishi ndu ọphu eghejeru Fero buredi phọ hụmaepho lẹ Jiósẹfu kọwaru nrwọ ono ree; ọ sụ Jiósẹfu: “Mbẹdua rwọkwarupho nrwọ gẹ mu vu nkata buredi ẹto. ");
INSERT INTO izz_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Lẹ nkata k'eli iya bẹ e yeru iphe, dụ iche iche, e gheshiru Fero. Ẹnu pheru bya eberu lẹ nkata k'eli iya ono; bya awata avụka iphe, nọ lẹ nkata ono, mu vu l'ishi ono.” ");
INSERT INTO izz_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jiósẹfu sụ iya: “Waa iphe, ọ bụ baa; nkata ẹto ono bụ ujiku ẹto. ");
INSERT INTO izz_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","A -nọepho ujiku ẹto; Fero abya akpụfuta ngu; je eworu ngu swigbua l'eli oshi. Ẹnu abya avụka anụ ngu.” ");
INSERT INTO izz_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","O beẹpho mbọku k'ẹto ono, gbaru l'eswe a nwụru Fero. Ọ bya eshiaru ndu-ozi iya g'ẹphe ha nri ọbo-iphe. O bya edufuta onye-ishi ndu etsujeru iya ọnu lẹ mẹe; yẹe onye-ishi ndu eghejeru iya buredi dobe l'atatiphu ndu-ozi iya. ");
INSERT INTO izz_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ọ bya eworu onye-ishi ndu etsuje ọnu lẹ mẹe dophu azụ l'ọkwa iya ọzo. Ọ bya agbaaharu Fero mẹe g'o shi agbaru iya. ");
INSERT INTO izz_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ọ bya eworu onye-ishi ndu eghejeru iya buredi phọ swị-gbua l'eli oshi. Ọ nwụkotaepho gẹ Jiósẹfu sụru phẹ l'ọo-nwụ. ");
INSERT INTO izz_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Obenu l'onye-ishi ndu etsuru Fero ọnu lẹ mẹe ono ta nyataẹduru Jiósẹfu; ọ zọhaa ya. ");
INSERT INTO izz_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","A nọepho apha labọ sụgbaa ishi; Fero rwọo nrwọ. Ọ gbẹ pfụru l'agụga ẹnyimu Nayịlu. ");
INSERT INTO izz_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A bya ele ẹnya; eswi ẹsaa, dụ ùbvù l'ẹnya bya adụ okporokpo shi l'ẹnyimu Nayịlu ono rwufutagba; bya anọdugba l'agụga ẹka ono taaha nri. ");
INSERT INTO izz_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E mechaa; eswi ẹsaa ọzo, dụ ẹji bya ajọ ẹhu shikwaphọ l'ẹnyimu ono rwufuta bya anọ-kube ọphuu l'agụga ẹnyimu ono l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eswi ẹsaa ọphu dụ ẹji bya ajọ ẹhu phọ bya atụko eswi ẹsaa ọphu dụ ùbvù l'ẹnya bya adụ okporokpo phọ lwekọta. O mechaa nno; Fero tehu. ");
INSERT INTO izz_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A nọnyakwaa; mgbẹnya tụ iya ọzo; ọ rwọo nrwọ k'ẹbo. K'ọgiya ono bẹ ọ rwọru nrwọ g'ishi akpe ẹsaa, dụ okporokpo bya adụ ree phọtaru l'oshi akpe lanụ. ");
INSERT INTO izz_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","E mechaa; ishi akpe ẹsaa ọzo, dụ mgbapya mgbapya, phẹrephere ụzo ẹnyanwu-awawa mebyishiru bya aphọshia l'oshi akpe ọzo. ");
INSERT INTO izz_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ishi akpe ẹsaa ọphu dụ mgbapya mgbapya phọ bya atụko ishi akpe ẹsaa ọphu dụ okporokpo bya aphọ aphọpho phọ lwekọta. Ọo ya bụ; Fero tehu; bya amaru l'iphemiphe ono bụ lẹ nrwọ bẹ o shi anwụkota. ");
INSERT INTO izz_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A fụta l'ụtsu; iphe ono nọdu atsụ iya l'ẹhu shii. O zia g'e je ekuaru iya ndu jibya; waa ndu mmamiphe ndu Ijiputu. Fero bya ezeeru phẹ nrwọ ono. Ọphu ọ dụdu onye dụru ike kọoru iya iphe, nrwọ ono bụ. ");
INSERT INTO izz_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Onye-ishi ndu etsujeru Fero ọnu lẹ mẹe sụ Fero: “Ntanụ-a bẹ mu nyatakwarụ iphe, mu meru, adụdu ree. ");
INSERT INTO izz_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","O nweru teke ẹhu ghujeru gụbe Fero eghu l'ẹka anyịbe ndu-ozi ngu nọ; ị tụa mu l'onye-ishi ndu eghejeru ngu buredi phọ mkpọro l'ụlo ibe onye-ishi ndu ojọgu, echeje gụbe Fero nche. ");
INSERT INTO izz_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","O -rwua ẹnyashi ujiku lanụ; anyi n'ẹbo tụko rwọo nrwọ; nrwọ ono ẹphenebo nwecharu iphe, ọ bụgbaa. ");
INSERT INTO izz_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","O nweru nwokorọbya Hiburu, bụ onye ohu onye-ishi ndu ojọgu, echeje gụbe Fero nche, anyi l'iya tụko nọdu l'ẹka ono. Anyi zeeru iya nrwọ ono; ọ kọoru anyi iphe, ọ bụgbaa. Onyenọnu bẹ ọ kọchaaru iphe, nrwọ nkiya bụ. ");
INSERT INTO izz_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E mechaa; iphemiphe ono nwụkotaerupho anyi g'o pfuru. Mbẹdua bẹ e kuphuru azụ l'ọkwa mu; e woru onye ọphuu je aswị-gbua.” ");
INSERT INTO izz_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ọo ya bụ; Fero zia g'e je ekua Jiósẹfu; a bya atụfuta iya l'ụlo-mkpọro ono. Ọ kpụchaa ishi bya agbanwee uwe iya bya ejeshia l'atatiphu Fero. ");
INSERT INTO izz_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fero sụ Jiósẹfu: “Mu rwọru nrwọ; ọphu ọ dụdu onye dụru ike kọoru mu iphe, nrwọ ọbu bụ. Obenu lẹ mu nụmaru l'ọobujeru; teke e zeru ngu nrwọ; l'ị kọoru onye ono iphe, ọ bụ.” ");
INSERT INTO izz_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jiósẹfu sụ Fero: “Ọ tọ bụkwa mbẹdua akọje iphe, nrwọ bụ. Ọ kwa Chileke bẹ a-kọru gụbe Fero iphe, nrwọ ono bụ lẹ g'oo-ji ngu ẹpho.” ");
INSERT INTO izz_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Fero sụ Jiósẹfu: “Mu rwọru nrwọ gẹ mu pfụru lẹ mgboru ẹnyimu Nayịlu; ");
INSERT INTO izz_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","mu hụma eswi ẹsaa, dụ okporokpo bya adụ ùbvù l'ẹnya g'o shi lẹ mini ono rwufuta bya anọdu l'agụga mini l'ẹka ono taaha nri. ");
INSERT INTO izz_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ẹphe fụtachaa; eswi ẹsaa ọzo, dụ ẹji bya ajọ ẹhu dụ garanyọngu bya erwufutakwaphọ. Mbụ lẹ mu teke ahụma-swee eswi, dụ-be ẹji ẹgube ono l'alị Ijiputu! ");
INSERT INTO izz_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eswi ẹsaa k'ono, dụ garanyọngu ono bya ajọ ẹhu ono bya atụko eswi ẹsaa kẹ mbụ phọ, dụ okporokpo phọ takọta lwee. ");
INSERT INTO izz_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ẹphe taẹbechaa phẹ; ẹphe dụkwapho njọ adụdu g'ẹphe dụ; k'ọphu bụ l'ọ tọ dụdu onye e-kweta l'ọo phẹ tarụ eswi ono. Mu tehu lẹ mgbẹnya ono. ");
INSERT INTO izz_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mu byakwa ekuru mgbẹnya ọzo; mu watakwa arwọ nrwọ. O be k'ọgiya ono; mu hụma ishi akpe ẹsaa, phọru aphọpho bya adụ ree g'ọ phọtakotaru l'oshi akpe lanụ. ");
INSERT INTO izz_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","E mechaa; mu hụmakwapho ishi akpe ẹsaa ọzo, dụchaa mgbapya mgbapya; bya adụchaa kẹ zịtazita; tẹme phẹrephere ụzo ẹnyanwu-awawa zipyashịa ya; ọ nwụlwashihu anwụlwashihu; g'ọ phọtakwarupho. ");
INSERT INTO izz_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ishi akpe k'ono, dụ mgbapya mgbapya ono bya atụko ndu ọphu dụ ree phọ lwekọta. Mu bya ezeeru iya ndu jibya; ọphu ọ dụdu onye dụru ike kọoru mu iphe, nrwọ ọbu bụ.” ");
INSERT INTO izz_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Noo ya; Jiósẹfu sụ Fero: “Nrwọ labọ ono bụkwa iphe lanụ bẹ ọ bụ. Chileke meru g'ọ kọoru gụbe Fero iphe, ya abya ememe. ");
INSERT INTO izz_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Eswi ẹsaa phọ, dụ ree phọ bụ apha ẹsaa; tẹme ishi akpe ẹsaa phọ, dụ ree phọ bụkwarupho apha ẹsaa. Ọo ya bụ lẹ nrwọ ono tụkoru bụru nrwọ lanụ. ");
INSERT INTO izz_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Eswi ẹsaa ọphu dụ ẹji bya ajọ ẹhu, fụtaru nụ gẹ ndu ọphuu fụtachaerupho phọ bụ apha ẹsaa. Tẹme ishi akpe ẹsaa phọ, dụ mgbapya mgbapya; phẹrephere, shi ụzo ẹnyanwu-awawa zipyashịru; ọ nwụlwashihu anwụlwashihu phọ bụru apha ẹsaa, ẹgu e-me. ");
INSERT INTO izz_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ọ kwa-a iphe, mu pfuhawaru gụbe Fero-a bẹ ọ bụ. Ọ kwa Chileke goshiru ngu iphe, yẹbe Chileke abya ememe. ");
INSERT INTO izz_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sụ-a; l'ime apha ẹsaa bẹ nri a-kwatakpọo dụ shii l'alị Ijiputu mgburugburu. ");
INSERT INTO izz_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ọle e -mechaa; apha ẹsaa ọphu ẹgu e-meshi ike etsota iya. L'aatụko apha ẹsaa phọ, nri shi dụ shii l'alị Ijiputu phọ zọhakota. Ẹgu ono abya atụko alị ono nmaa swọkoswoko. ");
INSERT INTO izz_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Apha, nri shi paa ẹka l'alị ono-a te enweẹdu onye anyata iya nụ; noo kẹle ẹgu ono a-bụru ẹjo iphe-ẹhuka. ");
INSERT INTO izz_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Iphe, meru g'o gude gụbe Fero rwọo nrwọ ono mgbo labọ bụ iphe ọbu bẹ bụ lẹ Chileke chịpyawaru iya rengurengu lẹ ya e-me iya; tẹme ọphu ọ dụedu g'aa-nọ-beru; Chileke emee ya. ");
INSERT INTO izz_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nta-a bụkwa gẹ gụbe Fero lee ẹnya họta onye iphe edoje ẹnya bya abụru onye maru iphe mee ya g'ọ bụru ishi l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tẹme l'ị họtakwapho ndu-ozi, a-nọ-tsota onye-ishi alị Ijiputu phọ; g'ẹphe keje iphe, ndu Ijiputu kpatarụ l'opfu ụzo ise wota oke lanụ. ");
INSERT INTO izz_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","G'ẹphe nakọbe nri ono g'ọ ha l'apha k'ono, nri dụ ono. Teke ẹphe nakọbecharu iya; ẹphe egude ẹpha gụbe Fero je edobegbaa ya l'ụlo ẹka eedobeje nri, nọgbaa lẹ mkpụkpu lẹ mkpụkpu. ");
INSERT INTO izz_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","L'e woru nri ono doberu ndu alị-a kwabẹru apha ẹsaa k'ẹgu phọ, a-bya lẹ Ijiputu-a. Ọo ya bụ g'ẹgu ete egbuchidu alị-a.” ");
INSERT INTO izz_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iphe ono dụ Fero yẹe ndu-ozi iya l'ophu ree. ");
INSERT INTO izz_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ọo ya bụ; Fero jịa phẹ sụ: “?Anyi a-dụ ike ahụmaba onye ọzo, a-dụ gẹ nwoke-a; mbụ onye unme Chileke bu l'ẹhu ẹgube-a?” ");
INSERT INTO izz_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Noo ya; Fero sụ Jiósẹfu: “Eshi ọphu Chileke meru g'ị makọtaru iphemiphe-a bẹ o to nweẹkwa onye ka ngu abụru onye iphe edoje ẹnya; ọphu o nwẹkwa onye ka ngu amaru iphe. ");
INSERT INTO izz_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ọo gụbedua bẹ a-bụru ishi l'ibe mu; tẹme ọ bụru iphe, i pfuru bẹ onyemonye e-meje l'alị-eze mu. Iphe, mu e-gude ka ngu shii kpoloko bụepho l'ọo mbẹdua bẹ bụ eze.” ");
INSERT INTO izz_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Noo ya; Fero sụ Jiósẹfu: “Nta-a bụakwaa ngu bẹ mu yekọtaru alị Ijiputu l'ophu l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ọo ya bụ; Fero gbata echi-eze iya woru gbabẹ Jiósẹfu lẹ mkpụshi-ẹka; bya eyee ya akpawuru-uwe; nyabẹ iya iphe-olu, e gude mkpọla-ododo mee. ");
INSERT INTO izz_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ọ bya anụ iya ụgbo-ịnya iya k'ẹbo; ọ nọdu agba. Ndu ọzo vuta ụzo agbọ ọgboo ekpu iya asụje: “Unu phozeru iya!” Ọ bụru iya bụ lẹ Fero eworu alị Ijiputu l'ophu woru yekọta Jiósẹfu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fero sụ Jiósẹfu: “Ọ kwa mbẹdua bụ Fero; mbụ lẹ-a; ọ -bụru l'i ti pfuduru l'ọwa-a iphe, ee-me baa; te enwekwa onye nweru iphe, ọ byaru eme l'alị Ijiputu l'ophu.” ");
INSERT INTO izz_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fero gụa Jiósẹfu Zafunatu-Paneya bya eduta Asenatu, nwada Potifera onye uke ndu Ọnu kee ya g'ọ bụru nyee ya. Jiósẹfu bya ejedzuru alị Ijiputu l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jiósẹfu nọwaru ụkporo apha l'apha iri tẹme ọ wata ejeru Fero, bụ eze ndu Ijiputu ozi. Jiósẹfu shi l'iphu Fero tụgbua; bya ejedzuru alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","L'apha ẹsaa ono, nri dụ ono bẹ alị meshikpọoru kẹ nri ree ike. ");
INSERT INTO izz_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jiósẹfu bya atụko nri, a kọtaru l'alị Ijiputu l'apha ẹsaa ono, nri dụ ono kwakọkota; dobegbaa lẹ mkpụkpu lẹ mkpụkpu l'alị Ijiputu. Ọobujeru; ọ -bya lẹ mkpụkpu k'ọwa-a l'ọ kwakọo nri, a kọtaru l'ẹgu, nọ-pheru iya mgburugburu doo ya. ");
INSERT INTO izz_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jiósẹfu kwakọepho ereshi, e metaru l'opfu jasụ ọ kụta l'ikpo, ha g'evevee, nọ l'agụga eze-ẹnyimu. Nri ọbu kwatakpọo paa ẹka k'ọphu a nọnyaru; ọphu e dejeẹdu iya l'ẹkwo. Noo kẹle ọ bụwaa agụta agụta. ");
INSERT INTO izz_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","O rwutashịa apha ọkpa-nri ono; Asenatu, nwada Potifera, onye uke ndu Ọnu nwụtawaru iya ụnwegirima unwoke labọ. ");
INSERT INTO izz_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jiósẹfu gụa onye ọphu bụ ọkpara iya Manásẹ; noo kẹle ọ sụru: “Chileke mewaru; mu zọhaa aphụ, tsọru mu nụ; bya azọhaa ọkpoku ibe nna mu.” ");
INSERT INTO izz_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Onye k'ẹbo bẹ ọ gụru Ifuremu sụ: “Ọo Chileke bụ onye meru gẹ ya jaa àjàjà l'alị, ya shi nọdu eje iphe-ẹhuka.” ");
INSERT INTO izz_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Apha ẹsaa, nri dụ shii l'alị Ijiputu phọ bya abvụ. ");
INSERT INTO izz_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Apha ẹsaa k'ẹgu phọ bya awata; mbụ ọ nwụepho gẹ Jiósẹfu pfuru ono; ọkpa-nri bya lẹ mgboko mgburugburu; ọ bụerupho alị Ijiputu bụ ẹka nri dụ. ");
INSERT INTO izz_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ẹgu meahaẹpho ndu Ijiputu; ẹphe je araaru Fero kẹ nri. Fero sụ ndu Ijiputu l'ophu: “Unu jepfuje Jiósẹfu. Iphe, ọ sụkpooru g'unu mee; unu emee ya!” ");
INSERT INTO izz_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ọkpa-nri ono jedzuẹrupho alị ono; Jiósẹfu tụhashia ụlo ẹka eedobeje nri reaha ndu Ijiputu nri; noo kẹle ẹgu ono emeshikpọ ike l'ẹkameka l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ọhamoha l'ophu nọdu abyajẹ l'alị Ijiputu bya azụta Jiósẹfu nri; noo kẹle ẹgu ono emeshikpọ ike lẹ mgboko mgburugburu. ");
INSERT INTO izz_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jiékọpu nụmaepho lẹ nri dụ l'alị Ijiputu; ọ sụ ụnwu iya: “?Bụ gụnu kparụ iphe, unu a-nọdu elegbaa nwibe unu ẹnya?” ");
INSERT INTO izz_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ọ sụkwapho: “Mu nụmakwaru lẹ nri dụ l'alị Ijiputu. Unu jekwa ẹka ono je azụtaru anyi nri ilile. Ọo ya bụ; g'anyi anọdu ndzụ; g'ẹgu te egbushi anyi.” ");
INSERT INTO izz_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ụnwunna Jiósẹfu ụmadzu iri bya atụgbunaa jeshia azụta nri l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ọphu Jiékọpu ekwedu gẹ nwune Jiósẹfu, bụ Benjiaminu tsoru phẹ. Noo kẹle ndzụ agụ iya l'iphe-kpanganga e-me iya. ");
INSERT INTO izz_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ọ bụru iya bụ l'ụnwu Ízurẹlu yị lẹ ndu jeru azụta nri ọbu; kẹle ọkpa-nri ono dụkwapho l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Noo ya; ọ bụru Jiósẹfu bụ ọchi-ọha ndu Ijiputu ono; tẹme ọ bụru iya anọduje ere ndu alị ono l'ophu nri. Ọo ya bu; unwune Jiósẹfu byarwutaẹpho bya eworu iphu kpube l'alị baarụ iya ẹja. ");
INSERT INTO izz_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ahụma, Jiósẹfu ahụma ụnwunna iya; ọ hụbe phẹ ama; bya awatarọ eme umere g'ọ tọ madụ ndu ẹphe bụ; bya epfuaharụ phẹ opfu ẹhuka ẹhuka. Sụ phẹ: “?Bụ awe bẹ unu shi?” Ẹphe sụ l'ẹphe shikwa alị Kénanu bya azụta nri. ");
INSERT INTO izz_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jiósẹfu hụbeepho ụnwunna iya ono ama; obenu l'ẹphebedua ta ahụbeduru yẹbedua ama. ");
INSERT INTO izz_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ọ bya anyata nrwọ, o rwọjeru k'ẹhu phẹ phọ; bya asụ phẹ: “Unu bụ ndu ngge; unu byaru g'unu hụma ẹka alị anyi dụ nyẹgenyege!” ");
INSERT INTO izz_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ẹphe sụ iya: “Waawakwa nnajịuphu; anyịbe ndu-ozi ngu bụkwa nri bẹ anyi byaru azụta. ");
INSERT INTO izz_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","G'anyi haa shikwa lẹ nna lanụ. Anyịbe ndu-ozi ngu epfukwa ire-lanụ; anyi ta abụkwa ndu ngge.” ");
INSERT INTO izz_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ọ sụ phẹ: “Ọo ụka; unu byacharu-a g'unu hụma ẹka alị anyi dụ nyẹgenyege!” ");
INSERT INTO izz_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ẹphe sụ iya: “Anyịbe ndu-ozi ngu dụkwa iri l'ẹbo tụko shi lẹ nna lanụ buru l'alị Kénanu. Onye kẹ nwata bẹ ẹphe lẹ nna anyi nọkwa l'unuphu; onye lanụ ta anọedu ndzụ.” ");
INSERT INTO izz_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jiósẹfu sụ phẹ: “Ọo gẹ mu pfuru unu-a bụ g'ọ dụ; unu bụ ndu ngge! ");
INSERT INTO izz_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Waa g'ee-shi hụta unu ama baa: Ọ -bụru-a lẹ Fero nọ ndzụ g'ọ nọ iya-a bụ g'iphe, mu epfu-a bụ eviya l'unu ta abyadụ ahata ọkpa l'ẹka-a tụgbua; abụdu lẹ nwune unu kẹ nwata bẹ e dutaru bya l'ẹka-a! ");
INSERT INTO izz_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Unu zia onye lanụ l'ime unu g'o je eduta nwune unu ono; unubẹ ndu ọphuu g'unu ha bẹ a-nọdukota lẹ mkpọro. Ọo ya bụ l'ee-shi nno hụa unu ama; maru mẹ ọ bụ-a ire-lanụ bẹ unu epfu. Teke ọdumeka l'aamaru l'ọo g'o doru ẹnya lẹ Fero nọ ndzụ bụ g'ọ bụ eviya; l'ọo ndu ngge bẹ unu bụ.” ");
INSERT INTO izz_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ọ tụko g'ẹphe ha je atụ-chishikota lẹ mkpọro; ẹphe nọo ujiku ẹto. ");
INSERT INTO izz_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","O -rwua lẹ mbọku k'ẹto; Jiósẹfu sụ phẹ: “Unu -mewaa iphe-a, mu abya epfupfu-a; mu ahaa unu g'unu nọdu ndzụ; kẹle mu bụ onye atsụ Chileke ebvu. ");
INSERT INTO izz_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Unu -sụ l'unu bụ ndu ire-lanụ; unu haa onye lanụ lẹ g'unu ha g'ọ nọdu lẹ mkpọro; unubẹ ndu ọphuu egude nri wojeru ndibe unu, nọ l'unuphu, ẹgu eme. ");
INSERT INTO izz_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ọle unu dutafụtajekwaru mu nwanna unu kẹ nwata ọbu; g'e shi ẹgube ono maru l'unu epfu ire-lanụ; g'e te egbukwanu unu.” Ẹphe kweta l'ẹphe e-me iya nno. ");
INSERT INTO izz_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ẹphe nọdu epfugbaru nwibe phẹ sụ: “Ọ kwa iphe, anyi meru nwune anyi bẹ aanụ anyi aphụ iya. Anyi hụmaru ẹgube aphụ, ọ gụru kpua anyi teke ọorwo anyi g'anyi dobe iya ndzụ; obenu l'anyi te eyeduru iya ọnu. Ọ kwa iphe ono meru g'o gude ẹjo aphụ, dụ ẹgube-a byapfuta anyi ntanụ-a.” ");
INSERT INTO izz_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rúbẹnu sụ: “?Mu ta asụduru unu g'ọ tọ dụshi iphe, unu e-me nwata ono; ọphu unu eyeduru ọnu? Nta-a bẹ ishi ọchi iya tụ-konụru anyi l'ishi.” ");
INSERT INTO izz_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ẹphe dobesụ l'eshi ọphu a gbanweru Jiósẹfu opfu agbanwe bẹ ọ tọ nụmaduru iphe, ẹphe epfu. ");
INSERT INTO izz_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","O wofu iphu l'ẹka ẹphe nọ kwashịa ẹnya-mini bya aghachikwaru phẹ iphu ọzo; bya awata abọ ụja eyeru phẹ ọzo. O zia; a kpụfuta Simiyọnu l'echilabọ phẹ; kee ya ẹgbu l'atatiphu phẹ l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jiósẹfu bya asụ g'e yejishicharu phẹ nri l'ẹda phẹ; tẹme l'eeyephucharu phẹ okpoga phẹ azụ l'ẹda phẹ; tẹme l'aanụ phẹ nri, ẹphe e-ri l'ụzo. A bya emeẹbecharu phẹ iphemiphe ono; ");
INSERT INTO izz_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ẹphe bya apata ẹda nri ono nmakobechaa l'eli nkapfụ-ịgara phẹ bya atụgbua; ọ bụru phẹ alala. ");
INSERT INTO izz_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","O -rwua l'ẹka ẹphe nọ-zetaru k'akwakwa; onye lanụ bya atọhashia ẹda iya gẹ ya hata nri nụ nkapfụ-ịgara iya; okpoga iya nọduwaa l'ọnu ẹda ono. ");
INSERT INTO izz_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ọ sụ unwune iya: “Iyii; okpoga mu bẹ a gbẹkwa yephuru mu azụ! Wakwa iya nọ l'ẹda mu-a!” Meji tsukahụ phẹ; tẹme ẹhu nọdu aphụkwa phẹ phọ aphụphu. Ẹphe sụ nwibe phẹ: “?Bụ gụnu bẹ Chileke meru anyi ẹgube-a?” ");
INSERT INTO izz_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ẹphe lwapfuta nna phẹ Jiékọpu l'alị Kénanu; ẹphe tụko iphemiphe, nwụru phẹ nụ kọkotaru iya; sụ iya: ");
INSERT INTO izz_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Onye bụ nnajịuphu l'alị ono bẹ pfukwaru anyi opfu ẹhuka ẹhuka; bya emee anyi gẹ ndu byaru ngge l'alị phẹ. ");
INSERT INTO izz_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Obenu l'anyi sụru iya l'anyi bụkwa ndu e gude ire phẹ ẹka; l'anyi ta abụkwa ndu ngge. ");
INSERT INTO izz_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Anyi dụkwa unwoke iri l'ẹbo, shi lẹ nna lanụ. Onye lanụ ta nọedu; onye kẹ nwata bẹ ẹphe lẹ nnana anyi nọ l'unuphu lẹ Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Noo ya; nnajịuphu ndu alị ono sụ anyi: ‘Waa-a gẹ mu e-shi maru mẹ unu bụ ndu ire-lanụ baa. G'anyi haa nwanna anyi onye lanụ g'ọ nọdu l'ẹka ono; anyịbe ndu ọphuu e-wota nri wojeru ndibe anyi, nọ l'unuphu, ẹgu eme. ");
INSERT INTO izz_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ọle g'anyi dutaru iya nwanna anyi kẹ nwata phọ. Ọo ya bụ; ya amaru l'anyi ta abụdu ndu byaru ngge; l'anyi bụ ndu e gude ire phẹ ẹka eviya. Ọo ya bụ; ya eduru nwanna anyi ono nụ-phu anyi azụ; anyi ejeahawarọ g'ọ dụ anyi l'alị-a.’ ” ");
INSERT INTO izz_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ẹphe nọdu awụfu nri ono l'ẹda phẹ; ẹphe hụma ẹkpa okpoga phẹ g'ọ nọgbaa l'ẹda phẹ. Ẹphe lẹ nna phẹ bya atụkocha hụma ẹkpa okpoga ono; ndzụ rwuta phẹ. ");
INSERT INTO izz_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nna phẹ Jiékọpu sụ phẹ: “?Unu eme g'ụnwu mu bvuẹbe? Jiósẹfu ta nọhedu; ọphu Simiyọnu anọedu; tẹme unu nọdu emefụkwaapho g'unu natafụa mu Benjiaminu. Mbẹdua bụkpowa oshi ụkpara-ẹhu.” ");
INSERT INTO izz_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rúbẹnu sụ nna iya: “Gbua ụnwegirima ibe mu-a ẹphenebo; m'ọ bụru lẹ mu te eduphutadụru ngu Benjiaminu azụ. Woru iya ye mu l'ẹka; mu e-duphutaru ngu iya azụ.” ");
INSERT INTO izz_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jiékọpu sụ phẹ: “Nwa mu te etsodu unu eje-o; kẹle nwune iya nwụhuwaru; ọ bụwaru iya nwẹkinyi iya. O -nweru ẹjo-iphe, meru iya l'iphe ọzo ọbu, unu eje ọbu; unu emee gẹ mu gụa aphụ laa maa l'ishi ẹwó mu-a.” ");
INSERT INTO izz_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ẹgu ono nọdukwapho eme l'alị Kénanu g'oome. ");
INSERT INTO izz_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ndibe Jiékọpu rigbuẹpho nri phọ, ẹphe shi l'alị Ijiputu gude phọ; nna phẹ sụ phẹ: “Unu jebanaa je azụtabaaru anyi nri!” ");
INSERT INTO izz_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Jiuda sụ iya: “Nwoke ono pfukwaru iya pfushia ya ike sụ l'anyi ta abyakwa ahụmaba iphu iya; abụdu l'anyi lẹ nwanna anyi ọbu swị. ");
INSERT INTO izz_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ọ -bụru l'i kweru haarụ anyi nwanna anyi ono g'o tsoru anyi bẹ anyi e-jekwa-a je azụtaru ngu nri. ");
INSERT INTO izz_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ọ -bụkwanuru l'i ti kwedu g'o je; bẹ anyi te ejekwa; noo kẹle nwoke ono sụru l'anyi ta ahụmabaedu iphu iya; m'ọ bụdu l'anyi lẹ nwanna anyi ono swị.” ");
INSERT INTO izz_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ízurẹlu sụ: “?Dẹnu g'ọ nwụru unu tụgburu je epfuaharụ nwoke ọbu l'unu nweru nwanna ọzo; shi nno mee; oke iphe-ẹhuka-a byapfuta mu?” ");
INSERT INTO izz_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ẹphe sụ: “?Tọbudu nwoke ono jịkpaaharu anyi ọnu lẹ k'ẹhu anyi; waa k'unuphu ibe anyi? Ọ jịru sụ: ‘?Nna unu nọkwadu ndzụ? ?Unu nwebaaru nwune ọzo?’ Anyi kwenu ‘Ee’ bya eyeeru iya ọnu l'iphe, ọ jịru. ?Anyi makwanụru l'ọo-sụ g'anyi duta nwanna anyi ọbu bya?” ");
INSERT INTO izz_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Noo ya; Jiuda sụ Ízurẹlu, bụ nna iya: “Denaa mu nwata-a g'anyi l'iya swịru; g'anyi agbẹshi jeshia; k'ọphu anyịbedua; waa gụbedua; waa ụnwu anyi a-tụko nọdu ndzụ; g'anyi ta nwụhushi. ");
INSERT INTO izz_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ọo mbẹdua l'a-nọduru ngu iya lẹ mkpalẹka. Ọ bụru mu bẹ ịi-kpa ishi iya. Teke mu te eduphutadụru ngu iya azụ; bya apfụbe ngu l'atatiphu; g'ọ bụru mu bẹ aa-nọdu ata ụta iya jasụwaruro. ");
INSERT INTO izz_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ọme anyi te eshi teke-a nọduta; mẹ anyi ejeakwa mgbo labọ lwachawa.” ");
INSERT INTO izz_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nna phẹ, bụ Ízurẹlu sụ phẹ: “Ọ -bụkpowaru l'ọo ẹgube ono bụ g'e mefụtaje iya bụkwa iphe, unu e-me bụ g'unu wota mebyi iphe, kachaa ree, shi l'alị-a yee l'ẹda unu, unu a-nụ nwoke ono. Unu meta nwa manụ bamu; waa nwa manụ-ẹnwu; waa etse; waa manụ mẹru; waa akpụru oshi pisutasho; waa akpụru oshi alụmondu. ");
INSERT INTO izz_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Unu wota okpoga mkpọla-ọchaa, ha g'ọphu unu gude ọgiya ọphuu ugbo labọ; kẹle unu e-je anụ-phu phẹ ọphuu, e yeru l'ọnu ẹda unu phọ azụ. ?A maru ?tọ bụdu nụ emeswe bẹ ẹphe mesweru iya? ");
INSERT INTO izz_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ngwa; unu duta nwune unu ọbu gude jepfu nwoke ọbu! ");
INSERT INTO izz_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Gẹ Chileke, bụ Ọkwoolemkpa mee gẹ nwoke ono phụaru unu obu-imemini; k'ọphu oo-kwe gẹ nwune unu ọphuu; waa Benjiaminu tụko swịru lwa. Ọ -bụru kẹ mbẹdua; ọ -bụru l'ọo aphụ a-tsọru mu; g'ọ tsọwaru mu rọ.” ");
INSERT INTO izz_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ọo ya bụ; unwoke ono bya egweta iphe-anụnu ono; bya ewota okpoga mkpọla-ọchaa ugbo labọ; bya eduta Benjiaminu; ẹphe jeshia alị Ijiputu. Ẹphe rwua bya apfụru l'iphu Jiósẹfu. ");
INSERT INTO izz_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Jiósẹfu hụmaepho l'ẹphe lẹ Benjiaminu swị; ọ sụ onye-ozi ụlo iya: “Duta ndu ono gude la ibe mu. Unu aphụa anụ tẹerii gude shia ite; kẹle mu l'unwoke-a e-rigbakwa nri-eswe.” ");
INSERT INTO izz_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nwoke ono bya emee gẹ Jiósẹfu pfuru; bya eduta phẹ lashịa l'ụlo Jiósẹfu. ");
INSERT INTO izz_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ndzụ wata agụ unwoke ono; kẹle e dutaru phẹ je edobe l'ụlo Jiósẹfu. Ẹphe sụ: “Iphe, e gude chịru anyi bya edobe l'ẹka-a a-bụkwaru-a k'okpoga mkpọla-ọchaa phọ, e yephuru anyi azụ l'ẹda lẹ mbọku kẹ mbụ phọ, anyi byaru phọ. Ọ kwa iphe, ọocho bụ iphe, ọo-sụ l'anyi meru kobe anyi opfu; mee anyi ohu iya; anyi lẹ nkapfụ-ịgara anyi.” ");
INSERT INTO izz_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Noo ya; ẹphe jepfu onye-ozi Jiósẹfu l'ọnu mgbo ụlo ono bya asụ iya: ");
INSERT INTO izz_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Jiko nnajịuphu; g'anyi byaru ọgiya ọphuu bya azụta nri; ");
INSERT INTO izz_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","bẹ anyi lashịaru bya ejerwua l'ụlo ndu ije; anyi jeshia atọha ẹda anyi; bya ejeshia ele ẹnya; okpoga onyemonye nọdugbawa l'ọnu ẹda iya. Mbụ; okpoga anyi ọbu hachaẹpho g'ọ ha. Nta-a bẹ anyi gudekwa iya wophuta azụ. ");
INSERT INTO izz_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Anyi gudefụkwapho okpoga ọzo, anyi e-gude zụtaba nri. Anyi ta amakwa onye woru okpoga anyi ono yephuru anyi azụ l'ẹda.” ");
INSERT INTO izz_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ọ sụ phẹ: “G'ẹhu dụkwa unu guu! Gẹ ndzụ ta agụshi unu! Ọo Chileke unu; waa kẹ nna unu bẹ yeru okpoga l'ẹda unu. Mu natakwaru-a okpoga unu ọgiya ono.” O je atụfuta Simiyọnu duta byapfuta phẹ. ");
INSERT INTO izz_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Onye-ozi Jiósẹfu duta ndu ono je edobe l'ụlo Jiósẹfu ono; bya ekee phẹ mini; ẹphe kwọo ọkpa; bya anụ nkapfụ-ịgara phẹ nri. ");
INSERT INTO izz_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ẹphe bya akwakọbe iphe, ẹphe gude, ẹphe a-nụ Jiósẹfu-a; mbụ iphe, ẹphe a-nụ iya mẹ ọ lwaẹpho l'eswe; kẹle ẹphe nụmaru l'ọo l'ẹka ono bẹ ẹphe e-ri nri. ");
INSERT INTO izz_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Jiósẹfu lwaẹpho unuphu; ẹphe wota iphe, ẹphe shi l'unuphu gude, ẹphe a-nụ iya woru nụ iya; ẹphe buaru iya iphu l'alị gude phozeru iya. ");
INSERT INTO izz_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ọ bya ajịebekpo phẹ g'ẹphe dụ sụ phẹ: “?Dẹnu gẹ nna unu nwoke ọgerenya-a, unu pfuru mu opfu iya-a dụ? ?Ọ dzụkwadu-a ndzụ?” ");
INSERT INTO izz_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ẹphe sụ iya: “Onye-ozi ngu, bụ nna phẹ bẹ nọkwa-a ndzụ; tẹme ẹhu dụkwa iya phọ ree.” Ẹphe bya ephoze ishi baarụ iya ẹja. ");
INSERT INTO izz_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ọ bya apalia ẹnya bya ahụma nwune iya, bụ Benjiaminu, onye ọphu nene iya nwụkpooru gẹdegede. Ọ sụ: “?Bụ nwune unu kẹ nwata, unu pfuru mu opfu iya ọbu baa?” Ọ sụ iya: “Nwa mu; gẹ Chileke meeru ngu eze-iphe-ọma!” ");
INSERT INTO izz_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Imemini nwune iya ono dụ iya. Jiósẹfu tụgbua ẹgwegwa; je achọ ẹka ọo-nọdu raa ẹkwa. Ọ bahụ lẹ mkpulabọ iya je anọdu raa ẹkwa ọbu. ");
INSERT INTO izz_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ọ swachaẹpho iphu; ọ lụfuta ọzo; bya egude ẹka l'obu sụ g'e wotaru phẹ nri-a. ");
INSERT INTO izz_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","E doberu Jiósẹfu nkiya iche; bya edoberu ụnwunna iya phẹ nkephẹ iche; bya edoberu ndu Ijiputu, ẹphe l'iya erigba nri nkephẹ iche; noo kẹle ndu Ijiputu bẹ ẹphe lẹ ndu Hiburu te erigbabẹjedu nri; kẹle ọ bụ ẹbyi l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ndu ono bẹ e doru; ẹphe gharu Jiósẹfu iphu; doo phẹ g'ọgerenya phẹ becharu. A -gbẹ l'ọkpara jasụ l'onye ọphu bụcha nwata. Ẹphe ghachaa ẹnya lee nwibe phẹ gude goshi g'ọ dụ-be phẹ biribiri. ");
INSERT INTO izz_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","E shiẹpho lẹ teburu kẹ Jiósẹfu hẹe phẹ iphe. Oke-iphe kẹ Benjiaminu gude ụzo oke ise kachaa kẹ ndu ọphuu shii. Ẹphe tụko tsoru Jiósẹfu ria nri; bya angụa g'ọ dụ phẹ. ");
INSERT INTO izz_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Noo ya; Jiósẹfu sụ onye-ozi ụlo iya: “Je akwajishichaaru ndu ono nri l'ẹda phẹ; ọo ẹpho g'ẹphe a-dụ ike vuru bẹ ii-yeru phẹ; tẹme l'iiyephuchaaru onyemonye okpoga iya azụ l'ọnu ẹda iya. ");
INSERT INTO izz_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","L'iiwota okoro mkpọla-ọchaa mu ono woru ye l'ọnu ẹda onye kẹ nwata; tẹme wakwaphọ okpoga, o gude bya azụta nri.” O bya emee gẹ Jiósẹfu pfuru iya. ");
INSERT INTO izz_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nchi bọhuepho; ndu ono tụgbua lashịa; yẹe nkapfụ-ịgara phẹ. ");
INSERT INTO izz_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ẹphe shi lẹ mkpụkpu ono tụgbua; ọle ẹphe teke atụgbu-mihudu lẹ teke Jiósẹfu sụru onye-ozi iya: “Chịpyabe ndu ono nta-a; teke ị gbapfuẹru phẹ phọ; sụ phẹ: ‘?Dẹnu g'ọ nwụru unu gude ẹjo-iphe pfụa ụgwo iphe-ọma, e meru unu? ");
INSERT INTO izz_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","?Tọbudu okoro, nnajịuphu mu angụje mini; tẹme ọ nọdu egudeje iya aphụ ọphulenya bẹ unu gude nno? Iphe ono, unu meru ono bụkwa ẹjo-iphe bẹ unu meru!’ ” ");
INSERT INTO izz_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ọ gbapfu phẹ bya eworu iphe ono pfushikọtaru phẹ. ");
INSERT INTO izz_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ẹphe sụ iya: “?Dẹnu g'ọ nwụru gụbe nnajịuphu anyi pfuru iphe, dụ nno? Tụswekwa! Anyịbe ndu-ozi ngu ta adụkwa onye tụru ama eme iphe, dụ nno! ");
INSERT INTO izz_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tẹme anyi shi l'alị Kénanu wolatakwarụro unu okpoga, anyi hụmaru l'ọnu ẹda anyi. ?Dẹnu g'anyi e-shi zita mkpọla-ododo; ọzoo k'ọcha l'ụlo ibe nnajịuphu ngu? ");
INSERT INTO izz_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ọ -bụru l'ọ dụru onye lanụ l'ime anyịbe ndu-ozi ngu, a hụmaru iya l'iphe iya; g'e gbua onye ọbu egbugbu; anyịbe ndu ọphuu abụkpooruro ohu gụbe nnajịuphu anyi.” ");
INSERT INTO izz_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ọ sụ phẹ: “Ọ dụ ree; g'ọ dụ g'unu pfuru. Onye a hụmaru, gude iya nụ bẹ a-bụru ohu mu; unubẹ ndu ọphuu ta adụkwa onye bya ata unu ụta.” ");
INSERT INTO izz_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Onyenọnu bya ezia ẹda iya l'alị ẹgwegwa; bya atọhaa ya. ");
INSERT INTO izz_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Onye-ozi ono bya awata iya achọcho; shi l'onye ọphu bụcha ọgerenya jasụ l'onye ọphu bụcha nwata. A hụma okoro ono l'ẹda Benjiaminu. ");
INSERT INTO izz_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ẹphe woru uwe phẹ gbajashịa bya ebogbaa nkapfụ-ịgara phẹ ivu phẹ; bya adakọbe laphushia azụ lẹ mkpụkpu ono. ");
INSERT INTO izz_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jiósẹfu nọdukwadu l'ụlo teke Jiuda yẹe ụnwunna iya bataru; bya azẹepho kẹ bẹe l'atatiphu iya. ");
INSERT INTO izz_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jiósẹfu sụ phẹ: “?Dẹnu g'ọ nwụru unu meru iphe, dụ nno? ?Unu ta amadụ l'onye gbaru gẹ mu aphụje ọphulenya?” ");
INSERT INTO izz_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Jiuda sụ: “?Bụ gụnu bẹ anyi a-dụ ike pfuaru gụbe nnajịuphu mu? ?Dẹnu g'anyi e-shi sụ l'anyi pfụberu-ẹka-ọto? Chileke mewaru g'ẹjo-iphe ndu-ozi ngu gbafụta iphe. Anyi bụwaa ohu gụbe nnajịuphu anyi; anyịbedua; waa onye a hụmaru okoro ono l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Obenu lẹ Jiósẹfu sụru: “Tụswekwa! Mu ta abyakwa eme iphe, dụ nno; ọo onye a hụmaru okoro ono l'iphe iya bẹ a-bụru ohu mu. Unubẹ ndu ọphuu lashịkporo lẹ chịriri werere lapfu nna unu.” ");
INSERT INTO izz_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Noo ya; Jiuda bya ejepfu iya bya asụ iya: “Gụbe nnajịuphu mu; kwenu gẹ mụbe onye-ozi ngu pfuru nwakpụru opfu lanụ ye gụbe nnajịuphu mu lẹ nchị. Ọo eviya l'unu lẹ Fero bụwaa iphe lanụ; ọle jiko nụ; g'umere mụbe onye-ozi ngu te emeshi nụ g'ẹhu ghua ngu eghu. ");
INSERT INTO izz_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Gụbe nnajịuphu mu jịru anyịbe ndu-ozi ngu sụ: ‘?Unu nweru nna; waa nwune ọzo tọo?’ ");
INSERT INTO izz_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Anyi sụ gụbe nnajịuphu mu lẹ nna anyi bụkwa nwoke ọgerenya; tẹme l'o nweru nwata okoro, a nwụru iya lẹ nka. Nwune iya nwụhuwaru; ọ bụwaru yẹbedua nwẹkinyi iya ghuduru l'ẹpho ne iya; tẹme nna iya ye iya obu shingushingu. ");
INSERT INTO izz_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Tọbudu iya bụ; ị sụ anyịbe ndu-ozi ngu g'anyi dutaru ngu iya g'ị hụma. ");
INSERT INTO izz_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Anyi sụ gụbe nnajịuphu anyi lẹ nwata ono ta atụgbujekwa atụgbu l'ẹka nna iya nọ. Ọ -bụru l'ọ tụgburu bẹ nna iya a-nwụhukwa. ");
INSERT INTO izz_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Obenu l'ị sụru anyịbe ndu-ozi ngu: ‘Ọ -bụru lẹ nwune anyi kẹ nwata te etsoduru anyi bya ẹka-a bẹ anyi ta ahụmabaedu iphu ngu.’ ");
INSERT INTO izz_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Anyi laphuẹpho azụ lapfu onye-ozi ngu, bụ nnana anyi. Anyi bya epfuaru iya iphe, gụbe nnajịuphu anyi pfuru. ");
INSERT INTO izz_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Noo ya; nna anyi sụ: ‘Unu tụgbua je azụtaba nri!’ ");
INSERT INTO izz_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Anyi sụ iya: ‘Anyi te ejekwa; abụdu lẹ nwanna anyi kẹ nwata bẹ anyi ẹya swị; ọo ya bụ anyi eje; kẹle anyi ta ahụmabaedu iphu nwoke ono; abụdu l'anyi lẹ nwanna anyi kẹ nwata swị.’ ");
INSERT INTO izz_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Onye-ozi ngu, bụ nna anyi sụ anyi: ‘?Ọ kwa l'unu maru-a lẹ nyee ya bụ ụnwegirima unwoke labọ b'ọ nwụtaru. ");
INSERT INTO izz_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ọphu onye lanụ anọedu; mu sụ l'anụ-ẹgbudu lajashịwaru iya; e -shi teke ono ọphu mu ahụmabaeduru iya. ");
INSERT INTO izz_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ọ -bụru l'unu dutafụaru onye ọwa tụgbua; iphe-kpanganga -mee ya bẹ unu e-mekwa g'ishi ẹwó mu gude aphụ kpuba l'alị.’ ");
INSERT INTO izz_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ọo ya bụ; ọ -bụru lẹ nwata ono te etsodu anyi laphu azụ jepfu onye-ozi ngu, bụ nna anyi; tẹme ọ -bụru lẹ nna anyi, bụ onye wotawaru ndzụ nkiya tụswia lẹ kẹ nwata-a ");
INSERT INTO izz_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","hụmaru l'anyi lẹ nwata ono ta aswịdu bẹ ọo-nwụhukwa. Anyịbe ndu-ozi ngu e-shi nno mee gẹ nna anyi gụru aphụ gude ishi ẹwó iya kpuba l'alị; ");
INSERT INTO izz_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","kẹle mụbe onye-ozi ngu nọ-dokwaru nwata ono l'itumo l'ẹka nna mu. Mbụ lẹ mu sụru nna mu lẹ teke mu te eduphutadụru iya ya azụ; g'ọ bụru mu bẹ aa-nọdu ata ụta iya jasụwaruro. ");
INSERT INTO izz_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ọo ya bụ; jiko gẹ mụbe onye-ozi ngu nọ-chinuru nwata ono l'ẹka-a bụru ohu ngu. Haa nwata ono g'ẹphe l'unwune iya ndu ọphuu swịru lashịa; ");
INSERT INTO izz_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","kẹle-a; ?dẹnu gẹ mu e-shi lapfu nna mu; m'ọ bụru lẹ nwata ono bẹ anyi l'iya ta aswịdu? Jiko te ekwekwa gẹ mu je ahụma ẹgube aphụ, a-tsọru nna mu!” ");
INSERT INTO izz_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Noo ya; ọphu Jiósẹfu adụedu ike sede onwiya ọzo l'atatiphu iphe, bụ ndu-ozi iya, pfụ-kuberu iya nụ. O chia mkpu; sụ: “Unu mee g'onyemonye tụgbua lụfu l'atatiphu mu!” A tụko wụfu; ọphu ọ dụedu onye ẹphe l'iya nọkwadu l'ẹka ono. Tọbudu iya bụ; Jiósẹfu gbẹ teke ono bya emee g'ụnwunna iya maru onye ya bụ. ");
INSERT INTO izz_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ọ bya arashịkpo ẹkwa ike k'ọphu ndu Ijiputu nụmaru iya; tẹme ndibe Fero nụmakwa iya phọ. ");
INSERT INTO izz_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jiósẹfu sụ ụnwunna iya ono: “Ọ kwa mbẹdua bụ Jiósẹfu ọbu! Mbụ-a; ?nna mu nọkwadu ndzụ tọo?” Ọphu ụnwunna iya adụdu ike ye ọnu yeru iya; noo kẹle ndzụ rwupyabẹru phẹ l'atatiphu iya. ");
INSERT INTO izz_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Noo ya; Jiósẹfu sụ ụnwunna iya: “Unu jiko kpịritaru mu ntse!” Ẹphe kwe hm bya akpịritaru iya ntse. Ọ sụ phẹ: “Ọ kwa mbẹdua bụ nwanna unu, bụ Jiósẹfu; onye ọphu unu reru; e gude iya lashịa alị Ijiputu-a. ");
INSERT INTO izz_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ọle g'aphụ te jishi unu obu; ọphu ẹhu anọdushi eghu unu eghu l'unu reru mu; noo kẹle ọo gẹ mu dzọo unu ndzụ meru g'o gude Chileke zia mu gẹ mu vuru unu ụzo. ");
INSERT INTO izz_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ọkpa-nri mewaru apha labọ l'alị-a; tẹme l'ime apha ise, abya nụ bẹ ọ tọ dụdu onye a-kọbe iphe l'alị; ọphu ọ bụro k'akpata iphe, shi iya nụ. ");
INSERT INTO izz_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Obenu lẹ Chileke ziru mu gẹ mu vuru unu ụzo; k'ọphu mu e-me g'awa unu phọdu lẹ mgboko; waa gẹ mu a-dzọta ndzụ unu l'ụzo, dụ biribiri. ");
INSERT INTO izz_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ọo ya bụ lẹ-a; ọ tọ bụkwa unubẹdua ziru mu gẹ mu bya l'ẹka-a; ọ kwa Chileke. Tẹme ọ bụru iya meru mu onye akpọ-zijeru Fero ụzo; bya emee mu onye elekọta ibe iya l'ophu; waa onye-ishi ndu Ijiputu l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nta-a bụkwa g'unu tụgbua ẹgwegwa lapfu nna mu je asụ iya lẹ mụbe nwa iya, bụ Jiósẹfu sụkwaru lẹ Chileke mewaru mu nnajịuphu ndu Ijiputu l'ophu. G'ọ lwatashikwa lwapfuta mu; g'o to jekwa akpọ ụpfu; ");
INSERT INTO izz_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","l'ẹka oo-buru bụ l'alị Goshẹnu; l'ẹka ọo-nọ-kube mu ntse; yẹbedua yẹe ụnwegirima ibe iya; waa ụnwu nwanwa iya; waa atụru iya; waa eswi iya; mẹwaro iphemiphe, o nwekpọru enweru g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","L'oo-buru l'ẹka ono; mu a-zụ iya; noo kẹle apha ise, ẹgu e-mefụa nọkwadu l'iphu. Ọdumeka bẹ ọkpa-nri a-dapfukwa yẹbedua yẹe ndibe iya l'ophu; waa iphemiphe, o nwekpọru enweru g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Unubẹdua hụmawaru l'onwunu; tẹme nwune mu Benjiaminu hụmakwapho l'ọo mbẹdua epfu opfu eyeru unu eviya. ");
INSERT INTO izz_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Unu kọkotaru nna mu k'ẹgube ùbvù, a kwabẹru mu l'alị Ijiputu; tẹme waa k'iphemiphe, unu hụmakotaru l'onwunu. Unu je ẹgwegwa je edutaru mu nna mu!” ");
INSERT INTO izz_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Noo ya; ọ gbakụa nwune iya, bụ Benjiaminu ẹka l'olu bya awaa ẹkwa; Benjiaminu bya azụkobe iya wata ara ẹkwa nkiya. ");
INSERT INTO izz_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ọ bya etsutsua unwune iya ono ọnu g'ẹphe ha; bya araru ẹkwa kpua phẹ. E mechaa; ẹphe l'unwune iya ono wata abọ ụja. ");
INSERT INTO izz_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Noo ya; nzi ono rwuẹpho l'ibe Fero l'ụnwunna Jiósẹfu byaru; ẹhu tsọo Fero yẹe ndu-ozi iya g'ẹphe ha ụtso. ");
INSERT INTO izz_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fero sụ Jiósẹfu: “Pfuaru ụnwunna ngu sụ phẹ g'ẹphe wota ivu phẹ tukobe l'eli anụ phẹ gude lashịa alị Kénanu ");
INSERT INTO izz_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","je eduta nna phẹ; waa ndibe phẹ l'ophu gude lwapfuta iya. Mu a-nụ phẹ alị Ijiputu ẹka kachaa ree. Mbụ l'ọo ẹguru iphe, shi l'alị ono bẹ ẹphe a-nọdu eri. ");
INSERT INTO izz_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tẹme l'ịisukwa phẹ phọ g'ẹphe pata ụgbo-ịnya ndu Ijiputu gude pata ụnwegirima phẹ; yẹe unyomu phẹ; waa nna phẹ gude bya. ");
INSERT INTO izz_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Sụ phẹ g'ẹphe ta ayọshi ọshi k'ẹku phẹ; noo kẹle iphe, kachaa ree l'alị Ijiputu bụ nkephẹ.” ");
INSERT INTO izz_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ụnwu Ízurẹlu bya emee nno. Jiósẹfu bya anụ phẹ ụgbo-ịnya, dụ gẹ Fero pfuru; bya anụkwa phẹ phọ nri, ẹphe e-ri l'ije ono. ");
INSERT INTO izz_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ọ bya anụchaa phẹ uwe ọ̀phúú. O be lẹ Benjiaminu; ọ nụ iya ẹkpa mkpọla-ọchaa ẹto; waa ụzo uwe ise. ");
INSERT INTO izz_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iphe, ọ nụru g'a nụ nna iya bụ: Nkapfụ-ịgara iri, e dojiru iphe, kachaa ree lẹ Ijiputu edoji; tẹme waa ne nkapfụ-ịgara iri, e dojiru ereshi; waa buredi; mẹwaro iphe ọzo, bụ iphe, nna iya e-rije l'ụzo teke ọo-nọdu abya. ");
INSERT INTO izz_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ọo ya bụ; o zia ụnwunna iya ono g'ẹphe tụgbua lashịa. Ọ sụ phẹ g'ẹphe ta swọkwa ụswo l'ụzo. ");
INSERT INTO izz_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ọo ya bụ; ẹphe shi l'alị Ijiputu tụgbua lapfushia nna phẹ, bụ Jiékọpu l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ẹphe sụ iya: “Jiósẹfu nọkwa ndzụ! Mbụ l'ọo yẹbedua bụ onye-ishi ndu Ijiputu l'ophu.” Ọ tụfu Jiékọpu ẹhu; ọphu o kwetadụru l'ọo eviya. ");
INSERT INTO izz_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Obenu l'ẹphe bya atụkoepho iphemiphe, Jiósẹfu pfuru phẹ pfushikọta; ọ hụmaepho ụgbo-ịnya, Jiósẹfu nụru g'e gude bya apata iya; unme lwa nna phẹ azụ l'ọru iya. ");
INSERT INTO izz_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ọ sụ: “Nta-a bẹ mu kwetawaru lẹ nwa mu Jiósẹfu nọkwadu ndzụ. Mu e-je ahụma iya ẹnya tẹme mu anwụhu.” ");
INSERT INTO izz_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Noo ya; Ízurẹlu bya egweta iphe, bụ nkiya tụgbua. Ọ rwuẹpho mkpụkpu Biye-Sheba bya egweeru Chileke nna iya, bụ Áyizaku ngwẹja. ");
INSERT INTO izz_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Noo ya; Chileke bya epfuru opfu yeru Ízurẹlu l'ẹnyashi shita l'ọphulenya sụ iya: “Jiékọpu! Jiékọpu!” Ọ za iya ẹnu. ");
INSERT INTO izz_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","O sụ iya: “Ọo mbẹdua bụ Chileke; mbụ Chileke kẹ nna ngu phẹ.” Sụ: “Gẹ ndzụ ala Ijiputu ta agụshi ngu; noo kẹle mu e-me ngu g'ị bụru ọha, parụ ẹka l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mu e-tsoru ngu je alị Ijiputu; tẹme mu eduphutakwa ngu phọ azụ ọzo. Tẹme ọo Jiósẹfu ono gẹdegede a-nọdukpo swiru ngu teke ịi-nwụhu.” ");
INSERT INTO izz_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Noo ya; Jiékọpu parụ Biye-Sheba haa tụgbua. Ụnwu Ízurẹlu bya apata nna phẹ, bụ Jiékọpu; waa ụnwu phẹ; waa unyomu phẹ l'ụgbo-ịnya ono, Fero nụru g'e gude pata iya ono. ");
INSERT INTO izz_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ẹphe rwutakwaphọ iphe-edobe phẹ; waa ẹku, ẹphe setarụ l'alị Kénanu. Jiékọpu yẹe oshilọkpa iya l'ophu lashịa Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ọ bya edutakwaphọ ụnwu iya nwoke; waa ụnwu nwanwa iya nwoke; waa ụnwu iya nwanyị; waa ụnwu nwanwa iya nwanyị. Ọ tụko iphe, bụkota awa iya l'ophu rwuta gude lashịa Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Waa ẹpha ụnwu Ízurẹlu, larụ alị Ijiputu baa; mbụ Jiékọpu; yẹe oshilọkpa iya: Rúbẹnu, bụ ọkpara Jiékọpu. ");
INSERT INTO izz_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ụnwu kẹ Rúbẹnu bụ Hanọku; waa Palu; waa Hẹzuronu; waa Kami. ");
INSERT INTO izz_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ụnwu kẹ Simiyọnu bụ Jimẹlu; waa Jiaminu; waa Ohadu; waa Jiakinu; waa Zoha; tẹme waa Shawulu; onye ọ nwụru; mbụ nwanyị, shi l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ụnwu kẹ Lívayi bụ Geshọnu; waa Kohatu; tẹme waa Merari. ");
INSERT INTO izz_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ụnwu kẹ Jiuda bụ Ẹru; waa Ọnanu; waa Shela; waa Pẹ́rezu; waa Zera. Ẹru waa Ọnanu tụko nwụshihuwa l'alị Kénanu. Ụnwu Pẹ́rezu bụ Hẹzuronu; waa Hamulu. ");
INSERT INTO izz_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ụnwu kẹ Isaka bụ Tola; waa Puwa waa Jiobu; tẹme waa Shimurọnu. ");
INSERT INTO izz_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ụnwu kẹ Zebulọnu bụ Sẹredu; waa Elọnu; tẹme waa Jahulẹlu. ");
INSERT INTO izz_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ndu ono g'ẹphe ha bụ ụnwu, Lii nwụtaru Jiékọpu lẹ Padanu-Arámu; a -gụfukwa Dayina, bụ nwa iya nwanyị. Ụnwu nwa nwoke iya ono yẹe kẹ nwanyị dụ ụmadzu ụkporo l'iri l'ẹto mkpakọta iya. ");
INSERT INTO izz_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ụnwu kẹ Gadu bụ Zefọnu; waa Hagi; waa Shuni; waa Ẹzubonu; waa Eri; waa Arodi; tẹme waa Areli. ");
INSERT INTO izz_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ụnwu kẹ Asha bụ Imuna; waa Ishiva; waa Ishivi; tẹme waa Beraya. Nwune phẹ kẹ nwanyị bụ Sera. Ụnwu Beraya bụ Heba; waa Malukẹlu. ");
INSERT INTO izz_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ndu ono bụ ụnwu, Zilipa, nwụtaru Jiékọpu; mbụ onye Lebanụ kuru nụ nwa iya nwanyị, bụ Lii g'ọ bụru ohu iya. Iphe, ẹphebedua tụkoru dụ bụ ụmadzu iri l'ishii. ");
INSERT INTO izz_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ụnwu, Rechiẹlu, nyee Jiékọpu bụ Jiósẹfu yẹe Benjiaminu. ");
INSERT INTO izz_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","L'alị Ijiputu bẹ Jiósẹfu nọ nwụta Manásẹ waa Ifuremu. Ọ bụru nwanyị, nwụru Jiósẹfu ụnwegirima ono bụ Asenatu, bụ nwada Potifera onye ishi-uke ndu Ọnu. ");
INSERT INTO izz_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ụnwu kẹ Benjiaminu bụ Bela; waa Beka; waa Ashịbelu; waa Gera; waa Nemanu; waa Ehi; waa Roshi; waa Mupimu; waa Hupimu; tẹme waa Arudu. ");
INSERT INTO izz_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ndu ono bụ ụnwu, Rechiẹlu nwụtaru Jiékọpu. Ẹphe dụ ụmadzu iri l'ẹno lẹ mkpakọta iya. ");
INSERT INTO izz_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nwa kẹ Danu bụ Hushimu. ");
INSERT INTO izz_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ụnwu kẹ Nafụtali bụ Jiahuzẹlu; waa Guni; waa Jieza; tẹme waa Shilemu. ");
INSERT INTO izz_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ndu ono bụ ụnwu, Biliha, nwụtaru Jiékọpu; mbụ onye Lebanụ kuru nụ nwa iya nwanyị, bụ Rechiẹlu g'ọ bụru ohu iya. Ẹphe dụ ụmadzu ẹsaa lẹ mkpakọta iya. ");
INSERT INTO izz_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ndu tso Jiékọpu laa Ijiputu; a -gụfukwa unyomu ụnwu iya; mbụ ndu ọphu bụ oshilọkpa iya gẹdegede dụ ụmadzu ụkporo ẹto l'ụmadzu ishii. ");
INSERT INTO izz_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A -bya eyekọbe iya ụnwu labọ kẹ Jiósẹfu, a nwụtaru Jiósẹfu lẹ Ijiputu; oshilọkpa Jiékọpu, larụ Ijiputu dụ ụmadzu ụkporo ẹto l'iri lẹ mkpakọta iya. ");
INSERT INTO izz_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Noo ya; Jiékọpu bya ezifụ Jiuda g'o vuru ụzo jepfu Jiósẹfu; je eduta iya g'ẹphe dzuda l'alị Goshẹnu. Ẹphe jee jasụ l'alị Goshẹnu ọbu; ");
INSERT INTO izz_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jiósẹfu byanụ edozichaa ụgbo-ịnya iya; bya ejeshia alị Goshẹnu gẹ yẹle nna iya, bụ Ízurẹlu dzuda. Ọ bya egoshi iya onwiya bya agbakụa ya ẹka l'olu; kụkua ya l'olu l'ẹka ono wata ẹkwa; raa ya nọo ọdu. ");
INSERT INTO izz_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ízurẹlu sụ Jiósẹfu: “Gẹ mu nwụhuwaro nta-a; eshi ọphu mu gudewaa ẹnya mu ẹphenebo hụma l'ị nọkwadu-a ndzụ!” ");
INSERT INTO izz_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Noo ya; Jiósẹfu sụ ụnwunna iya; waa ndibe nna iya l'ophu: “Mu e-jepfu Fero je asụ iya l'ụnwunna mu; waa ndibe nna mu l'ophu, shi buru l'alị Kénanu bẹ lwapfutawaru mu nụ. ");
INSERT INTO izz_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ndu ono bụ ndu eche atụru; mbụ l'ẹphe bụ ndu azụ iphe-edobe; tẹme waa l'ẹphe tụkowa iphe phẹ; mẹcha atụru phẹ; mẹ eswi phẹ; mẹkpoo iphe phẹ g'ọ ha rwuta. ");
INSERT INTO izz_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Teke Fero kuru unu bya asụ: ‘?Bụ gụnu bụ akanya, unu maru esese?’ ");
INSERT INTO izz_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Unu sụkwa iya l'unubẹ ndu-ozi iya shikwa teke unu bụ nwata bụru ndu azụ iphe-edobe; ẹgube gẹ nna unu oche phẹ shihawaa bụtaru iya. Ọo ya bụ l'eekwe g'unu buru l'alị Goshẹnu; noo kẹle ndu eche atụru dụ ndu Ijiputu ashị.” ");
INSERT INTO izz_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jiósẹfu bya ejepfu Fero je asụ iya: “Nna mu yẹe ụnwunna mu; waa atụru phẹ; waa eswi phẹ; yẹe iphe, ẹphe nweru enweru g'ọ ha bẹ shiakwa l'alị Kénanu byarwuta Goshẹnu.” ");
INSERT INTO izz_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ọ bya ahọta ụnwunna iya ono ụmadzu ise; bya eduru phẹ jepfu Fero. ");
INSERT INTO izz_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fero bya ajịa ụnwunna Jiósẹfu sụ phẹ: “?bụ gụnu bụ akanya, unu maru esese?” Ẹphe sụ Fero: “Anyịbe ndu-ozi ngu bụkwa ndu eche atụru. Ọ kwaphọ ẹgube ono bụ gẹ nna anyi oche phẹ shi bụkwaru iya phọ.” ");
INSERT INTO izz_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ẹphe sụkwa iya phọ: “Anyi byaru ebutọta l'ẹka-a; noo kẹle ọkpa-nri parụ ẹka l'alị Kénanu; ọphu atụru anyịbe ndu-ozi ngu enwedu ẹka ọo-tajẹ nri. Jiko hanaa g'anyịbe ndu-ozi ngu buru l'alị Goshẹnu.” ");
INSERT INTO izz_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fero sụ Jiósẹfu: “Nna ngu; waa ụnwunna ngu byapfutaakwaru ngu. ");
INSERT INTO izz_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tẹme alị Ijiputu bụwaru ngu bẹ ọ nọ l'ẹka. Hata ẹka kachaa ree l'alị-a woru nụ nna ngu; yẹe ụnwunna ngu g'ẹphe buru. Mbụ-a; woru alị Goshẹnu nụ phẹ g'ẹphe buru. Ọ -bụru l'ị maru ndu ọphu ejeshi ozi ike l'echilabọ phẹ l'iimee phẹ ndu a-nọduje echeru mu iphe-edobe nkemu.” ");
INSERT INTO izz_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Noo ya; Jiósẹfu bya eduta nna iya, bụ Jiékọpu; bya eduru jepfu Fero. Jiékọpu bya agọru ọnu-ọma nụ Fero; ");
INSERT INTO izz_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Noo ya; Fero bya asụ Jiékọpu: “Ị nọwaru apha ole?” ");
INSERT INTO izz_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jiékọpu sụ Fero: “Apha, mu nọwaru lẹ mgboko bẹ rwuakwaru ụkporo apha ishii l'apha iri. Apha, mu nọwaru hakwa nwanshịi; ọle ọo ẹpho iphe-ẹhuka bẹ mu gude ejeje; ọ nọdu eme gẹ mu ta nọ-rwu gẹ ndiche mu phẹ nọ-rwuru lẹ mgboko.” ");
INSERT INTO izz_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jiékọpu bya agọru Fero ọnu-ọma; bya abụru iya atụgbu. ");
INSERT INTO izz_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ọo ya bụ; Jiósẹfu bya emee gẹ nna iya; waa ụnwunna iya buru lẹ Ijiputu. Ọ nụ phẹ alị Ijiputu ẹka kachaa ree g'ẹphe buru, bụ iya bụ alị Ramesẹsu, bụ ẹgube Fero sụru g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jiósẹfu nọdu azụkwapho nna iya; waa ụnwunna iya; waa iphe, bụkota ndibe nna iya l'ophu lẹ nri. Ọo ẹpho g'ụnwegirima phẹ habe bụ g'ọonu-bejeru phẹ nri. ");
INSERT INTO izz_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nri bvụkotawa l'alị ono mgburugburu; noo kẹle ẹgu ono parụ ẹka. Alị Ijiputu mẹ alị Kénanu tụko gbajọshihu; ọ bụru shita l'ọkpa-nri ono. ");
INSERT INTO izz_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ndu Ijiputu; yẹe Kénanu tụko okpoga, nọ l'alị phẹ gude pfụ-gbua Jiósẹfu aswa nri, ẹphe zụtaru. Jiósẹfu vutakọta okpoga ono je akụbe l'ụlo Fero. ");
INSERT INTO izz_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Okpoga ndu Ijiputu yẹe Kénanu -bvụepho; ndu Ijiputu lwapfuta Jiósẹfu bya asụ iya: “Nụ anyi nri! ?Dẹnu g'ọ nwụru anyi a-nọdu l'atatiphu ngu nwụshihu? Okpoga anyi bẹ anyi kpagbuakwaru lẹ nri.” ");
INSERT INTO izz_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jiósẹfu sụ phẹ: “Eshi ọphu okpoga unu bvụwaru; unu kpụtajenuru mu iphe-edobe unu; gẹ mu gude ree unu nri.” ");
INSERT INTO izz_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ọo ya bụ; ẹphe nọdu akpụtajeru Jiósẹfu iphe-edobe phẹ; mbụ ịnya phẹ; mẹ atụru phẹ; mẹ eghu phẹ; mẹ eswi phẹ; mẹ nkapfụ-ịgara phẹ. Ọ nọdu egudeje nri gbanweta phẹ iphe-edobe phẹ; shi nno zụkota phẹ apha ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Apha k'ono -bvụepho; ẹphe byapfuta iya l'apha ọphu tsotaru iya nụ bya asụ iya: “Anyi te ewohakwaru gụbe nnajịuphu anyi iphe l'eshi ọphu okpoga anyi bvụwaru; tẹme iphe-edobe anyi bụkotawaru nkengu; nta-a te nwehẹkwa iphe, anyi e-gude pfụa gụbe nnajịuphu anyi; abụdu ishi onwanyi; waa alị anyi kpoloko. ");
INSERT INTO izz_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","?Dẹnu g'ọ nwụru anyi a-nọdu l'atatiphu ngu nwụshihu; anyịbedua l'ishi onwanyi; waa alị anyi? Zụ̀a alị anyi; waa ishi onwanyi; g'ị nụje anyi nri. G'alị anyi bụwaruro kẹ Fero. Tẹme anyịbedua l'ishi onwanyi abụkwarupho ohu iya. Nụ anyi akpụru iphe-akụku; g'anyi ta nwụhushi; k'ọphu alị-a ta abụduru echiẹgu.” ");
INSERT INTO izz_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Noo ya; Jiósẹfu bya azụtakotaru Fero alị Ijiputu l'ophu. Ndu Ijiputu g'ẹphe ha rekọta alị phẹ; noo kẹle ẹgu ono shi menụka phẹ. Alị ono bụkotaru kẹ Fero. ");
INSERT INTO izz_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jiósẹfu mee ndu Ijiputu; shita l'ishi iya ọphuu jasụ l'ishi iya ọphuu ohu. ");
INSERT INTO izz_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Alị lanụ, ọ zụduru l'alị ono l'ophu bụ alị ndu-uke; noo kẹle ọo Fero anụ phẹ nri. Tẹme nri k'ono, Fero eketajẹ nụ phẹ ono nọdu asụjeru phẹ. Noo iphe, meru g'o gude ọphu ẹphe ereduru nkephẹ. ");
INSERT INTO izz_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jiósẹfu sụ phẹ: “Eshinu mu zụru unu; waa alị unu ntanụ-a nụ Fero; wakwa akpụru-iphe, unu a-kọbe l'alị baa. ");
INSERT INTO izz_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ọle unu -kpatachaẹ ya phọ; unu keje iya ụzo ise nụ Fero oke lanụ. Ụzo ẹno k'ọphuu bẹ unu e-dobe g'ọ bụru ọphu unu a-kọ-phu azụ l'alị. Tẹme ọ bụkwaru iya phọ bẹ unu; waa ndu unu l'ẹphe bu; waa ụnwegirima ibe unu e-rije.” ");
INSERT INTO izz_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ẹphe sụ iya: “Ị dzọru anyi ndzụ! Jiko g'anyi dụ gụbe nnajịuphu anyi l'obu! Anyi a-bụkpooruro ohu Fero.” ");
INSERT INTO izz_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jiósẹfu bya eworu ekemu tụa l'alị Ijiputu. Tẹme ekemu ono bẹ eemekwa byasụ ntanụ-a. Ọ sụru l'oke lanụ l'ụzo ise l'iphe, a kpatarụ l'opfu bẹ aa-nụje Fero. Ọ bụepho alị ndu-uke bẹ ta abụdu kẹ Fero kpoloko. ");
INSERT INTO izz_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ndu Ízurẹlu bya eburu l'alị Ijiputu l'alị Goshẹnu. Ẹphe buru l'ẹka ono daa ẹku; bya azụa ka l'ọtu. ");
INSERT INTO izz_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jiékọpu bua l'alị ndu Ijiputu mgbarapha iri l'ẹsaa; jasụ teke ọ nọ-rwuru mgbarapha ụkporo ẹsaa l'apha ẹsaa. ");
INSERT INTO izz_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","O rwujeẹpho Ízurẹlu l'anwụhu; o kua nwa iya, bụ Jiósẹfu bya asụ iya: “Ọ -bụru l'i yeru mu obu; jiko chịnuru ẹka ye mu l'ehe riaru mu angụ; l'ii-goshi mu l'i yeru mu obu bya abụru onye apfụshije ike l'iphe, i pfuru; l'i tii lidu mu l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mu -nwụhuepho lapfu nna mu oche phẹ; patakwa mu pafụ l'alị Ijiputu je elia mu l'ẹka e liru ẹphebedua!” Jiósẹfu sụ iya: “Mu e-mekọta g'i pfuru.” ");
INSERT INTO izz_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ọ sụ iya g'o riaru iya nte l'oo-me iya. Jiósẹfu bya eriaru iya nte ọbu. Jiékọpu zẹ l'iphe-azẹe ya phoze ishi gude baarụ Chileke ẹja. ");
INSERT INTO izz_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Noo ya; o be ujiku lanụ; g'iphemiphe ono mechaarụ; a bya ezia Jiósẹfu lẹ nna iya bẹ iphe emekwa. O duta ụnwu iya ẹphenebo; Manásẹ; waa Ifuremu gude jeshia. ");
INSERT INTO izz_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","A sụepho Jiékọpu: “Ọ kwa Jiósẹfu nwa ngu byapfutaru ngu nta-a.” Ọ rọkota ike; bya agbẹshi nọdu anọo l'iphe, ọo zẹje azẹe. ");
INSERT INTO izz_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jiékọpu sụ Jiósẹfu: “Chileke, bụ Ọkwoolemkpa byapfutakwaru mu lẹ Luzu, nọ l'alị Kénanu; bya agọru ọnu-ọma nụ mu l'ẹka ono; ");
INSERT INTO izz_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","sụ mu: ‘Lekwa; mu e-me ngu g'ị zụ̀a azụ̀zù; bya emee g'unu dụ l'ọtu. Mu e-me ngu g'ị bụru ọha ẹka ngu; tẹme mu anụ ngu alị-a g'ọ bụru oke-iphe oshilọkpa ngu jasụ lẹ tuutuutuu lẹ mịimiimii.’ ” ");
INSERT INTO izz_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jiékọpu sụ iya: “Ụnwegirima labọ, ị nwụtaru l'alị Ijiputu tẹme mu bya phọ; mbụ Ifuremu waa Manásẹ bẹ mu wotaru g'ụnwu, mu nwụru l'onwomu; ẹgube Rúbẹnu; waa Simiyọnu bụ ụnwu mu ono. ");
INSERT INTO izz_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ụnwu ọzo, aa-gbẹ nta-a nwụtaru ngu a-bụru ụnwu nkengu. Oke alị ọphu ẹphebedua a-hata bẹ e-shi l'ẹka unwune phẹ, bụ Ifuremu; waa Manásẹ. ");
INSERT INTO izz_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Gẹ mu shi alị Padanu alwa bẹ aphụ jiru mu obu teke Rechiẹlu nwụhuru l'alị Kénanu g'anyi nọkwadu lẹ gbororo lẹ mgboru alị Ifurata. Mu woru iya lia l'agụga ụzo; l'alị Ifuratu, bụ iya bụ Bẹtulehemu.” ");
INSERT INTO izz_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ízurẹlu hụma ụnwu Jiósẹfu bya asụ iya: “?Bụ ndu ole baa?” ");
INSERT INTO izz_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jiósẹfu sụ nna iya: “Ọ kwa ụnwu, Chileke nụru mu.” Ízurẹlu sụ iya: “Dutaru mu phẹ gẹ mu gọru ọnu-ọma nụ phẹ.” ");
INSERT INTO izz_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Teke ono bẹ Ízurẹlu aphụwaa ragaraga; kẹle ọ kahụwaru. Ọ tọo phụ-rweẹdu aphụ-rwe. Jiósẹfu duritaru iya ụnwu iya ono ntse; nna iya bya etsutsua phẹ ọnu; bya anmata phẹ akpa. ");
INSERT INTO izz_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ízurẹlu sụ Jiósẹfu: “Mu te eshikwa arịkwadu lẹ mu e-mecha hụmaba ngu akpụru-ẹnya ọzobaa; Chileke mechaa bya ahaa mu; mu hụmafua ụnwu ngu yekọbe iya.” ");
INSERT INTO izz_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jiósẹfu bya eduritaru phẹ lẹ mgboru ikpere nna iya; bya ephureta kpube iphu l'alị. ");
INSERT INTO izz_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Noo ya; Jiósẹfu bya esekputa ẹphenebo l'ẹka. Ifuremu bẹ o sekpu l'ẹkutara; ọ nọdukwanu Ízurẹlu l'ẹkicha; o sekpuru Manásẹ l'ẹkicha; ọ nọdu Ízurẹlu l'ẹkutara. O gude phẹ ẹgube ono byakube Ízurẹlu ntse. ");
INSERT INTO izz_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Obenu lẹ Ízurẹlu byaru l'agọru ọnu-ọma nụ phẹ; ọ gbanga ẹka iya ẹphenebo; woru ẹkutara iya byabẹ Ifuremu, bụ onye kẹ nwata l'ishi; bya atụ-kobe Manásẹ, bụ ọkpara ẹkicha. ");
INSERT INTO izz_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ọ bya agọru Jiósẹfu ọnu-ọma sụ: “Gẹ Chileke ono, nna mu oche phẹ, bụ Ébirihamu; waa Áyizaku tsoru ụzo iya ono kebe ụnwegirima-a l'ọma. Mbụ Chileke ono, bụ Onye-nche mu e -shi teke a nwụru mu byasụ nta-a. ");
INSERT INTO izz_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ọo ya bụ Ojozi-imigwe ono, dzọtakotaru mu nụ l'ẹka iphe, bụ ẹjo-iphe, byapfutaru mu nụ ono. G'e kujekwa ẹpha ụnwegirima-a laa l'ẹpha mu; waa lẹ kẹ nna mu oche phẹ, bụ Ébirihamu; waa Áyizaku. Tẹme ẹphe adụkwapho l'ọtu lẹ mgboko-a.” ");
INSERT INTO izz_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jiósẹfu hụmaepho lẹ nna iya woru ẹkutara tụ-kobe Ifuremu l'ishi; ẹhu gbangahụ iya. O je azụ nna iya l'ẹka; g'ọ lọfu iya ẹka l'ishi Ifuremu lọta tụ-kobe l'ishi kẹ Manásẹ. ");
INSERT INTO izz_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Jiósẹfu sụ nna iya: “Waawakwa nna; ọ kwa onye k'ọgerenya baa! Wokwaru ẹkutara byabẹ yẹbedua l'ishi!” ");
INSERT INTO izz_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nna iya jịka sụ iya: “Mu maru-a nno nwa mu; mu maru-a lẹ yẹbedua bẹ a-jaakwaphọ bụru ọha ophu; tẹme ọha ono apakwaaphọ ẹka. Obenu lẹ nwune iya kẹ nwata bẹ a-ka iya shii; tẹme oshilọkpa nkiya bẹ a-bụru ikpoto ọha.” ");
INSERT INTO izz_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ọ gọru ọnu-ọma nụ phẹ mbọku ono sụ: “Ndu Ízurẹlu e-gudeje ẹpha ngu gọo ọnu-ọma sụ: ‘Gẹ Chileke mekwaa ngu g'ị dụ gẹ Ifuremu yẹe Manásẹ.’ ” O shi ẹgube ono mee; Ifuremu ka Manásẹ shii. ");
INSERT INTO izz_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ízurẹlu sụ Jiósẹfu: “Mu abyaakwaa anwụhu; ọle Chileke bẹ a-nọ-kubekwa unu duphu unu azụ l'alị nna unu. ");
INSERT INTO izz_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ọzo bụ lẹ-a; mu nụwaru ngu oke alị lanụ g'i gude kangoo ụnwunna ngu ndu ọphuu. Alị ono bẹ mu gude ogu-echi waa apfụ lwụta l'ẹka ndu Amọru.” ");
INSERT INTO izz_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Noo ya; Jiékọpu bya ekua ụnwu iya; sụ phẹ: “Unu dzukọbe gẹ mu kọoru unu iphe, a-nwụru unu l'atatiphu! ");
INSERT INTO izz_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Unu dzukọbe bya angabẹ nchị; unubẹ ụnwu Jiékọpu! Unu ngabẹru nna unu, bụ Ízurẹlu nchị! ");
INSERT INTO izz_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rúbẹnu; ọo gụbedua bụ ọkpara mu; bya abụru ike mu; mbụ l'ị bụ nwa ivuzọ, mu nwụru teke ike dụ mu. Ọo ngu bẹ a kachaa akwabẹ ùbvù; bya abụru ngu bẹ kakọta ọkpehu. ");
INSERT INTO izz_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Eshinu ịinoduje atụ kpereree g'akpara-mini l'eme iphe, erwubeduru ngu nụ; bẹ ị tịi kaẹdu ndu ọphuu shii; noo kẹle ị zẹru l'iphe-azẹe nna ngu; mbụ je eworu iphe, mu azẹje azẹe merwua. ");
INSERT INTO izz_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyọnu; waa Lívayi bụ unwune. Ẹphe egudeje ogu-echi phẹ emekpa ndu ọzo ẹhu. ");
INSERT INTO izz_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mu ta abyakwa ayịru l'ìdzù, ẹphe achị; ọphu mu abyakwa anọdu l'echilabọ phẹ; noo kẹle ẹphe gude ẹhu-eghu gbushia nemadzụ; bya egbubushia oke-eswi akwara azụ ọkpa k'iwashị. ");
INSERT INTO izz_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","G'ẹhu-eghu phẹ vuru ọnu; noo kẹle ooghughajẹru phẹ ẹka. G'obu-ọku phẹ vuru ọnu; noo kẹle ọopanukaje phẹ ẹka l'ẹhu. Mu a-chịkashi-dzuru phẹ l'alị Jiékọpu; mbụ dokashidzuru phẹ l'alị Ízurẹlu l'ophu. ");
INSERT INTO izz_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jiuda; ụnwunna ngu a-nọduje ekele ngu ekele. Ẹka ngu a-zụchaa ndu ọhogu ngu l'ẹkpiri kẹ pfụurii. Ụnwunna ngu g'ẹphe ha ephozeru ngu. ");
INSERT INTO izz_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Gụbe Jiuda bụ nwa oduma ẹgbara. Gụbe nwa mu; i shiwaa l'ẹka i gbushiru iphe, i riru lwa. Nta-a bẹ o gbushiwaru ikpere zẹ azẹe g'oduma; mbụ g'akahụ oduma; ?bụ onye sụru iya ekute? ");
INSERT INTO izz_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Jiuda ta abụ-buhuduru eze abụ-buhu; ọphu mgbọro-eze ono abyadụ alụfu iya alụfu lẹ mgbaka ọkpa; gbiriri jasụ teke onye ọ kụru ishi l'ẹka a-bya. Ọ -byaẹpho bẹ ọha l'ophu a-ngabẹru iya nchị. ");
INSERT INTO izz_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nkapfụ-ịgara iya bẹ oo-libeje lẹ vayịnu. Nwa nkapfụ-ịgara iya bẹ oo-libeje l'ẹkali vayịnu ono ọphu mịshiru mebyi kẹ wọgalaa. Ọo-sajẹ uwe iya lẹ mini akpụru vayịnu. Akpụru vayịnu ono, enwuje kẹ pfụu gẹ mee ono bẹ oo-gudeje asa akpawuru-uwe iya. ");
INSERT INTO izz_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mẹe e-me; ẹnya achaa ya vaa. Ẹra-eswi emee; eze acha iya phuuphuu. ");
INSERT INTO izz_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulọnu bẹ e-buru lẹ mgboru eze-ẹnyimu. Agụga ẹnyimu iya a-bụru ọdu ụgbo-mini. Oke alị iya e-jerwu Sayịdonu. ");
INSERT INTO izz_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka bụ nkapfụ-ịgara, ọkpehu dụ; mbụ gude ẹda labọ, a nmakoberu iya l'okpurukpu zẹ azẹe. ");
INSERT INTO izz_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ọ hụmaepho g'ẹka oodzu ike dụ-be ree; waa g'alị iya ono dụ-be guu; o phozeta nmakota ivu-ẹrwa iya jikoru l'ukuvu; bya ejeahaa ozi, e kebutaru iya g'o je. ");
INSERT INTO izz_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Danu bẹ a-nọduje ekpe ndu nkiya ikpe, pfụru ọto; mbụ ẹgube ono, ọkpa-ipfu Ízurẹlu ndu ọphuu ekpeje iya phọ. ");
INSERT INTO izz_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Danu a-dụ g'agwọ, nọ l'agụga ụzo; mbụ g'ogiji, nọ l'agụga gbororo, abụjeru: Ọ -taa ịnya l'ichirupfu ọkpa l'ọ tụfu onye agba iya nụ l'azụ. ");
INSERT INTO izz_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Gụbe Chipfu; mu ele ẹnya teke ịi-dzọta mu. ");
INSERT INTO izz_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadu bẹ ndu ọ-lwụa-ọlaa a-dapfu; ọle ọoghakobe chịpyabe phẹ. ");
INSERT INTO izz_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asha bẹ a-nọdu akọ ọkpobe nri. Nri, ọo-nọdu akọ bụ nri, atsọ ụtso, gbaru ndu eze l'eriri. ");
INSERT INTO izz_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafụtali bụ ele, agbaphe g'ọ dụ iya. Ọonwuje nwa, ama ntụmatu. ");
INSERT INTO izz_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jiósẹfu bụ vayịnu, amịje ntụmatu; ọ bụ vayịnu, nọ-kube mgboru ẹka mini dụ, amịje mebyi shii. Ẹkali iya baa ụba tụko igbulọ sweta. ");
INSERT INTO izz_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ndu ọgba-apfụ gude ẹhu-eghu byapfuta iya ọgu. Ẹphe gbaru iya apfụ; shi nno mekpaa ya ẹhu. ");
INSERT INTO izz_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ọle apfụ iya keẹrupho jịngujingu g'o keru; tẹme e mee ọkpu ẹka iya; o shihu ike. Ọ bụru shita l'ike k'onye bụ Ọkalibe kẹ Jiékọpu; mbụ onye ono, bụ onye-nche; waa onye mgbobuta kẹ Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Onye ike ono shi l'ẹka bụ Chileke kẹ nna gụbe Jiósẹfu, bụ onye eyejeru ngu ẹka; mbụ onye ono, bụ Ọkwoolemkpa, bụ onye emejeru ngu iphe-ọma. Oomejeru ngu iphe-ọma ọphu shi l'imigwe; bya emejekwaru ngu phọ iphe-ọma ọphu shi lẹ mini ime-alị. Tẹme ọ bụru iya bụ onye egudeje nwa; waa eche nwa ẹra meeru ngu iphe-ọma. ");
INSERT INTO izz_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ọnu-ọma ọphu nna ngu gọru ngu kakwa k'oke-úbvú ndiche shii; mbụ l'ọ kakwa iphe-ọma ọphu úbvú, shi teke ndiche nọduta anụje shii. G'iphe-ọma ono g'ọ hakọta bụkwaru kẹ Jiósẹfu; mbụ g'ọ bụkotakwaru kẹ yẹbe onye ono, a họfutaru l'echilabọ unwune iya dobe iche ono. ");
INSERT INTO izz_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjiaminu bụ ẹjo-nkụta-ọswa, ẹgu alabushi akụrepho. O -rwua l'ụtsu l'o gbua iphe taa. O -rwua l'ụzenyashi l'o kee iphe, ọ lwụtaru l'ọgu.” ");
INSERT INTO izz_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ndu ono bụkota ọkpa-ipfu Ízurẹlu ẹphe n'iri l'ẹbo. Tẹme iphe ono bụkotaru iphe, nna phẹ pfuru yeru phẹ teke o gọru phẹ ọnu-ọma. Ọ gọerupho onyenọnu ọnu-ọma, rwuberu iya nụ. ");
INSERT INTO izz_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Noo ya; ọ bya ekeru ekpe nụ phẹ sụ: “Mu abyawaa alapfu ndiche mu phẹ. Unu likwa mu l'ẹka e liru nna mu phẹ l'ọgba, nọ l'alị Ẹfuronu, bụ onye Hetu. ");
INSERT INTO izz_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ọgba ono yẹle alị ono nọ l'alị Makupela ono, nọ lẹ mgboru Mamure l'alị Kénanu; bẹ Ébirihamu zụtaru l'ẹka Ẹfuronu onye Hetu dobe; g'ọ bụru ẹka ee-lije odzu. ");
INSERT INTO izz_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ọ bụru ẹka ono bẹ e liru Ébirihamu; yẹe nyee ya, bụ Sera; tẹme e likwaphọ Áyizaku; yẹe nyee ya, bụ Ribeka l'ẹka ono; tẹme mu bya elia Lii l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Alị ono yẹe ọgba, nọ iya nụ bẹ a zụru ndu Hetu.” ");
INSERT INTO izz_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jiékọpu keghechaẹpho ekpe nụ ụnwu iya; bya azẹ-zeta azẹe; tụa unme ikpazụ; ọ bụru iya alapfu ndiche iya phẹ. ");
INSERT INTO izz_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jiósẹfu bya apata onwiya tụa l'eli nna iya; kwarụ ẹkwa kpua ya; bya etsutsukwaa ya phọ ọnu. ");
INSERT INTO izz_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Noo ya; Jiósẹfu bya ezia ndu dọkinta, ejeru iya ozi g'ẹphe dozia odzu nna iya, bụ Ízurẹlu g'o to rehu. Ndu dọkinta ono bya edozia odzu ono ẹgube ono. ");
INSERT INTO izz_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ọ bụru ụkporo abalị labọ bẹ ẹphe gude dozia odzu ono; tee ya mmanụ, g'o to rehu. E mechaa; ndu Ijiputu bya akwaa ẹkwa iya ụkporo abalị ẹto l'abalị iri. ");
INSERT INTO izz_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Eswe akwakwa iya -bvụepho; Jiósẹfu sụ ndu-ozi Fero: “Ọ -bụru lẹ mu dụ unu l'obu; unu pfuaru Fero sụ iya ");
INSERT INTO izz_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","lẹ nna mu mekwarụ; mu riaru iya nte sụ lẹ ya abyawaa anwụhu; ọle gẹ mbẹdua jekwa elia ya l'ilu, ọ tụru doberu onwiya l'alị Kénanu. Ọo ya bụ gẹ mu jenụ je elia nna mu; gẹ mu alwaphuta azụ.” ");
INSERT INTO izz_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fero sụ iya: “Tụgbua je elia nna ngu l'ẹka o pfuru g'i riaru iya nte l'ii-je elia ya.” ");
INSERT INTO izz_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ọo ya bụ; Jiósẹfu tụgbuna jeshia eli nna iya. Ndu ozi Fero g'ẹphe ha tụko wụfu tsoru iya. Ndu bụ ọgerenya l'ibe Fero; waa ndu bụ ọgerenya Ijiputu l'ophu; ");
INSERT INTO izz_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","tẹme waa ndibe Jiósẹfu l'ophu; waa ụnwunna iya; mẹ ndu bụkpoo kẹ nna iya g'ẹphe hakọta. Ụnwegirima ibe phẹ mẹ iphe-edobe phẹ bẹ ẹphe hakọtaru l'alị Goshẹnu. ");
INSERT INTO izz_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ụgbo-ịnya; mẹ ndu agba l'ịnya bẹ ẹphe l'ẹphe swịkwapho. Ẹphe dụkpoo igwerigwe tụko swịru. ");
INSERT INTO izz_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ẹphe rwua ẹka eechije balị lẹ Atadu, nọ lẹ mgboru ẹnyimu Jiọ́danu; ẹphe raa ẹkwa iya rashịa ya ike. Jiósẹfu bya anọdu l'ẹka ono kwaa nna iya ono ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ndu Kénanu, bu l'ẹka ono nụmaepho ẹkwa aphụ, aara lẹ mgboru ẹka eechije balị lẹ Atadu; ẹphe sụ: “Ndu Ijiputu ataswịbejekwa ọkpoma raa ẹkwa aphụ.” Noo iphe ono meru g'o gude e kua ẹka ono, nọ-kube ẹnyimu Jiọ́danu ono “Abẹlu-mizuremu”. ");
INSERT INTO izz_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Noo ya; ụnwu Jiékọpu mee g'ọ sụru g'ẹphe mee. ");
INSERT INTO izz_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ẹphe pata iya je l'alị Kénanu je elia ya l'ọgba, nọ l'alị Makupela lẹ mgboru Mamure, bụ ẹka Ébirihamu zụtaru Ẹfuronu onye Hetu g'ọ bụru ẹka ee-lije odzu; yẹe alị, tso iya nụ. ");
INSERT INTO izz_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","E lichaẹpho nna iya; Jiósẹfu lwaphuta azụ l'alị Ijiputu; yẹe unwune iya; mẹwaro ndu ọzo, tso iya je eli nna iya ono. ");
INSERT INTO izz_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ụnwunna Jiósẹfu hụmaepho lẹ nna phẹ nwụhuwaru; ẹphe sụ: “Ọ -bụru lẹ Jiósẹfu bẹ iphe, anyi meru iya-a eghukwadu eghu bẹ ọo-pfụkwa anyi ụgwo iya.” ");
INSERT INTO izz_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Noo ya; ẹphe zia ozi g'e je ezia Jiósẹfu sụ iya: “Nna ngu byakwa l'anwụhu bya atụa ekemu-a sụ: ");
INSERT INTO izz_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Unu e-pfuru Jiósẹfu lẹ mu arwọkwa iya arwọrwo g'ọ gụkwaaru ụnwunna iya nvụ l'ẹka ẹphe mesweru iya; yẹ l'iphe-ẹji, ẹphe meru; kẹle ọ kwa ẹjo-iphe bẹ ẹphe meru iya.’ Ọ bụkwanuru iphe, anyi arwọ ngu nta-a bụ g'ị gụnaa nvụ l'emeswe, anyịbe ndu-ozi Chileke nna ngu mesweru ngu.” Ẹphe zichaẹpho Jiósẹfu ozi ono; ọ wata ẹkwa. ");
INSERT INTO izz_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ụnwunna iya tụgbukwapho wụ-pfu iya je adaa kpurumu l'atatiphu iya bya asụ: “Iilenaa l'anyi tụkoakwaru bụru ohu ngu.” ");
INSERT INTO izz_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","No iya; Jiósẹfu sụ phẹ: “Gẹ ndzụ ta agụshi unu; kẹle ọ tọ bụdu mu bụ Chileke. ");
INSERT INTO izz_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ọ bụ eviya l'unu chịru idzu g'unu mee mu ẹjo-iphe; obenu lẹ Chileke meru iya; ọ bya abụru iphe-ọma; k'ọphu e shi ẹgube ono dzọta ndzụ ndu dụ igwe, bụ iya bụ iphe, nwụru nụ-a. ");
INSERT INTO izz_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ọo ya bụ gẹ ndzụ ta agụshi unu. Mu a-nọdua anụ unu nri; unu l'ụnwegirima unu.” Ọ bya emee ya; o doo phẹ ẹnya l'ẹhu te eghudu iya eghu; bya epfuru opfu-ọma yeru phẹ. ");
INSERT INTO izz_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jiósẹfu buru l'alị Ijiputu; yẹe ndibe nna iya l'ophu. Ọ nọru ụkporo apha ise l'apha iri; ");
INSERT INTO izz_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","bya ahụma nwanwa ụnwu Ifuremu. Tẹme Jiósẹfu hetakwaphọ ụnwu Makiya, bụ nwatibe Manásẹ l'ụtapfu iya teke a nwụru phẹ. ");
INSERT INTO izz_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Noo ya; Jiósẹfu sụ ụnwunna iya: “Mu abyaakwaa anwụhu. Ọle mu maru lẹ Chileke e-mecha bya eyeru unu ẹka dufuta unu l'alị-a; duta unu laphu azụ l'alị, Chileke kweru Ébirihamu; waa Áyizaku; waa Jiékọpu ukwe iya ono; bya eria nte yeru phẹ iya ono.” ");
INSERT INTO izz_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jiósẹfu mee g'ụnwu Ízurẹlu riaru iya nte. Ọ sụ phẹ: “Mu maru lẹ Chileke e-mecha bya eyeru unu ẹka. O -rwua teke ono; unu chịtakwa ọkpu mu gude lụfu l'ẹka-a.” ");
INSERT INTO izz_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ọo ya bụ; Jiósẹfu nwụhu g'ọ nọchaerupho ụkporo apha ise l'apha iri. E dozia odzu iya g'o to rehu; bya eye iya l'okpoko-odzu dobe l'alị Ijiputu.");
INSERT INTO izz_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Waa ẹpha ụnwu Ízurẹlu, tso Jiékọpu laa alị ndu Ijiputu baa. Onyemonye dutaru ndibe iya lashịa ẹka ono. ");
INSERT INTO izz_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rúbẹnu; waa Simiyọnu; waa Lívayi; waa Jiuda; ");
INSERT INTO izz_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","waa Isaka; waa Zebulọnu; waa Benjiaminu; ");
INSERT INTO izz_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","waa Danu; waa Nafụtali; waa Gadu; waa Asha. ");
INSERT INTO izz_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Oshilọkpa Jiékọpu tụkoru dụ ụkporo ụmadzu ẹto l'ụmadzu iri. Jiósẹfu nọhawaa anọno l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tọbudu iya bụ; Jiósẹfu yẹe ụnwunna iya g'ẹphe ha; waa ọgbo k'ono tụkowa nwụshihukota. ");
INSERT INTO izz_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ọle ndu Ízurẹlu azụshiele-a; bya abarahụ. Ẹphe zụshiru kwatakpọo paa ẹka apaa; k'ọphu ẹphe tụkoerupho alị ono sweta. ");
INSERT INTO izz_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Noo ya; onye eze ọ̀phúú, bụ onye ta amadụ kẹ Jiósẹfu amama ophu bya abụru eze lẹ Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Noo ya; ọ sụ ndu alị iya: “Unu lenu lẹ ndu Ízurẹlu akaakwa anyi shii k'ọphu ẹphe e-mechaa ka anyi ọkpehu. ");
INSERT INTO izz_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Unu byakwa g'anyi kwabẹru phẹ ẹnya. Ọdumeka bẹ ẹphe a-kabakwa evuvu. Ọ -bụru l'a nọnyaru; ọgu daa bẹ ẹphe e-tsokwaru ndu ọhogu anyi bya etsoo anyi ọgu; gbado ẹka-a lashịa.” ");
INSERT INTO izz_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ọo ya bụ; ndu Ijiputu bya ahọta nemadzụ; mee phẹ udumalị; sụ g'ẹphe kebutajẹ ndu Ízurẹlu g'ẹphe je ozi mkpọnwu-ẹhu. Ẹphe bya akpụa mkpụkpu Pitọmu; waa mkpụkpu Ramesẹsu g'ọ bụru mkpụkpu ẹka Fero e-dobeje iphe. ");
INSERT INTO izz_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","A -ka phẹ akpa ẹhu; ẹphe agbẹ ka azụshi ka l'ọtu dzuru ẹkameka. Ndu Ijiputu kabakpọoro atsụ ndu Ízurẹlu ebvu; ");
INSERT INTO izz_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","bya akabakpọoro eme g'ẹphe jeje ozi mkpọnwu-ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ẹphe kpabẹ phẹ ozi; gude mee ndzụ phẹ bụru phẹ aphụ; mee g'ẹphe yọshi ẹja bụloku. Tẹme ẹphe aghakwa phọ ẹja mini; mẹwaro ozi, nọ-gbua l'ẹgu phẹ. Iphe, bụkota ozi, ndu Ijiputu kebutaru phẹ g'ẹphe je bụkotaru ozi mkpọnwu-ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Eze ndu Ijiputu sụ ụnwanyi, eswije ndu Hiburu ime, ẹpha phẹ bụ Shifura; waa Puwa: ");
INSERT INTO izz_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Unu -nọdu eswi ụnwanyi ndu Hiburu ime m'ẹphe nọdu anwụ nwa; ẹphe -nwụe ya phọ; unu nyoje phẹ. Ọ -bụru nwoke; unu gbuje iya; teke ọ bụ nwata nwanyị; unu hajẹkwa iya g'ọ nọdu ndzụ!” ");
INSERT INTO izz_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Obenu lẹ ndu eswije ime ono atsụ Chileke ebvu; ọphu ẹphe emejedu iphe ono, eze Ijiputu ziru phẹ ono. Ẹphe nọdu ahajẹ nwa-nwoke; ẹphe anọdu ndzụ. ");
INSERT INTO izz_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Noo ya; Eze ndu Ijiputu bya ekukọo ndu eswije ime ono; bya asụ phẹ: “?Bụ gụnu bẹ unu meru iphe, dụ ẹgube-a? ?Bụ gụnu kparụ iphe unu ahajẹ ụnwegirima unwoke; ẹphe anọdu ndzụ?” ");
INSERT INTO izz_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ụnwanyi eswije ime ono sụ Fero: “Tị madụ l'ụnwanyi Hiburu ta adụdu gẹ kẹ ndu Ijiputu. Ọkpehu dụ phẹ. Ọ nọdu abụjeru; ndu eswije ime -bya abyarwuta ẹka ono; ẹphe ezedawaa.” ");
INSERT INTO izz_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ọo ya bụ; Chileke meeru ndu eswije ime ono iphe-ọma. Ndu Ízurẹlu nọdu evu; bya akakpọro aka l'ọtu. ");
INSERT INTO izz_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Chileke mekwaphọ g'ụnwu ndu eswije ime ono ka l'ọtu; kẹle ẹphe atsụ iya ebvu. ");
INSERT INTO izz_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Noo ya; Fero bya atụaru ndu nkiya g'ẹphe ha ekemu sụ: “Ọ -bụru lẹ ndu Hiburu nwụru nwa; ọ -bụru nwoke; g'e jeje echie ya l'ẹnyimu Nayịlu! Teke ọ bụ nwanyị l'a haa ya g'ọ nọdu ndzụ!” ");
INSERT INTO izz_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Noo ya; nwoke, shi l'ọnulo Lívayi bya alụta nwanyị, shikwaphọ l'ọnulo Lívayi. ");
INSERT INTO izz_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nwanyị ono bya atsụta ime; bya nwụa nwa nwoke. Ọ hụmaepho lẹ nwata ono manụkaru mma; o hee ya l'edomi ọnwa ẹto. ");
INSERT INTO izz_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ọ nọnyaa; ọphu o dụedu ike domikọta iya edomi. Ọ bya egbuta èjì gude kpaarụ iya nkata; bya echia ya ụrwa mbekee. Ọ bya ekuru nwata ono ye l'ime nkata ono; pata je edobe l'agụga ẹnyimu Nayịlu ẹka èjì zeru. ");
INSERT INTO izz_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nwune iya nwanyị bya eje apfụru ụzenya g'ọ maru iphe, l'e-eme nwata ono. ");
INSERT INTO izz_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Noo ya; nwa Fero kẹ nwanyị jeshia awụ ẹhu l'ẹnyimu Nayịlu ono. Yẹle ụnwumgboko, ejeru iya ozi swịru tụko eje l'agụga ẹnyimu ono. Ọ hụma nkata ono g'ọ nọ l'ime èjì ono; bya ezia ohu iya nwamgbọko g'o je ewotaẹduru iya ya. ");
INSERT INTO izz_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","O kpuhaa ya; bya ahụma nwata ono. Nwata ono nọdu ara ẹkwa; imemini iya dụ iya. Ọ sụ: “Ọ kwa nwa onye Hiburu bẹ ọ bụ!” ");
INSERT INTO izz_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nwune nwata ono kẹ nwanyị sụ nwatibe Fero ono: “?Bụ gẹ mu je ekuaru ngu nwanyị Hiburu, e-heru ngu nwata ono?” ");
INSERT INTO izz_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ọ sụ iya ngwa; g'o jenụ. Nwamgbọko ono tụgbua je ekua nene nwata ono. ");
INSERT INTO izz_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nwada Fero sụ ne nwata ono g'o kuta nwata ono je ehefutaru iya; gẹ ya pfụa ya ụgwo. Noo ya; nwanyị ono bya ekuta nwata ono je eheahaa. ");
INSERT INTO izz_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nwata ono vutaẹpho; o duta iya dulaaru nwatibe Fero ono; ọ bụru nwa iya. O woru iya gụa Mósisu; kẹle ọ sụru l'ọo nwata, ya gụtaru lẹ mini. ");
INSERT INTO izz_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Noo ya; o rwua ujiku lanụ gẹ Mósisu vutachaaru; o jeshia ahụma ndu nkiya l'ẹka ono, ẹphe eje ozi mkpọnwu-ẹhu ono. Ọ hụma onye Ijiputu ẹka oochi onye Hiburu iphe, bụ onye lanụ l'ụnwunna iya. ");
INSERT INTO izz_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ọ bya achịka ẹnya ibe k'ẹbo ẹbo; ọphu ọ dụdu onye ọ hụmaru. O chigbua onye Ijiputu ono bya egude ẹja kpamia ya. ");
INSERT INTO izz_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","O -rwua lẹ nchitabọhu iya; ọ tụgbukwa ọzo je ahụma ndu Hiburu ụmadzu labọ ẹka ẹphe alwụ ọgu. Ọ sụ onye ọphu achọ opfu: “?Dẹnu g'ọ nwụru iichi onye Hiburu ibe ngu iphe?” ");
INSERT INTO izz_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Onye k'ono sụ iya: “?Bụ onye meru ngu onye-ishi; waa onye-ikpe anyi? Tọo ?iimewaa g'i gbua mu g'i gburu onye Ijiputu phọ?” Noo ya; ndzụ gụahaa Mósisu; ọ rịa sụ: “Iphe-a, mu meru-a bẹ a -gbẹ madzuchawaru nụ.” ");
INSERT INTO izz_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Fero nụmaepho iphe ono bya emeahaa g'o gbua Mósisu. Mósisu gbafụ l'ibe Fero gbaru lashịa alị ndu Midiyanu je eburu. O jerwua bya anọdu anọo l'agụga wẹlu. ");
INSERT INTO izz_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Noo ya; onye uke ndu Midiyanu nweru ụnwumgboko ẹsaa. Ẹphe bya lẹ wẹlu ono bya ekuta mini ye l'iphe, eeyejeru anụ mini g'atụru ibe nna phẹ ngụa. ");
INSERT INTO izz_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","O nweru ndu ọzo, eche atụru, byaru bya achịfu phẹ. Noo ya; Mósisu gbalihu bya eyetaru phẹ ẹka; kuta mini doberu atụru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ụnwumgboko ono lapfuẹpho nna phẹ, bụ Ruwẹlu; ọ sụ phẹ: “?Dẹnu g'ọ nwụru unu lwarụ ẹgwegwa ẹgube-a ntanụ-a?” ");
INSERT INTO izz_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ẹphe sụ iya l'o nwekwarụ nwoke Ijiputu, nafụtaru phẹ l'ẹka ndu eche atụru ndu ọphuu. Tẹme ọ bya esetafụkwapho mini doberu atụru phẹ; ọ ngụa. ");
INSERT INTO izz_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ọ sụ ụnwada iya: “?Dẹnuhunu nwoke ọbu? ?Bụ gụnu kparụ iphe, unu parụ iya haa? Unu je ekua ya g'ọ bya eria nri.” ");
INSERT INTO izz_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mósisu kweta; yẹe nwoke ono buru. Nwoke ono bya ekuru nwa iya nwanyị, bụ Zipora kee Mósisu; ọ lụru. ");
INSERT INTO izz_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora bya eyeru iya nwa nwoke. Mósisu gụa ya Geshọmu; noo kẹle Mósisu sụru: “Mu bụ onye lwarụ alwalwa l'alị ndu ọhozo.” ");
INSERT INTO izz_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A nọnyakpoepho; eze ndu Ijiputu nwụhu. Ndu Ízurẹlu nọdu atsụ pfụpfupfu; echi mkpu; ara g'e yeru phẹ ẹka l'iphe-ẹhuka ono, ẹphe eje l'abụbu ono, ẹphe bụ ohu ono. Ẹkwa ono, ẹphe ara ono rwua Chileke nchị. ");
INSERT INTO izz_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Chileke nụma ude ono, ẹphe atsụ ono; bya anyata ọgbandzu ẹphe lẹ Ébirihamu; waa Áyizaku; waa Jiékọpu. ");
INSERT INTO izz_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Chileke bya aghaa ẹnya; lee ndu Ízurẹlu; bya arịahaa ọriri ẹhu phẹ. ");
INSERT INTO izz_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","No iya; Mósisu nọdu eche atụru Jieturo, bụ nna nyee ya; bya abụru onye uke ndu Midiyanu. O -rwua ujiku lanụ; ọ chịta atụru ono gude jeshia ẹka dụ ẹnya l'echiẹgu. O jee jasụ o jerwua l'úbvú Horẹbu, bụ iya bụ úbvú Chileke. ");
INSERT INTO izz_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ọ bụru l'ẹka ono bẹ Ojozi Chipfu gude ọku, enwu l'irwu oshi hee ya l'atatiphu. Mósisu hụma l'ọku ono enwu l'irwu oshi ono; obenu l'o to tsupyashịdu iya. ");
INSERT INTO izz_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ọo ya bụ; Mósisu sụ: “Gẹ mu bya ejekubeẹkwa iphe ọwa-a ntse; mbụ iphe ọwa-a, tụfuru ẹhu, anwụ nụ-a; gẹ mu maẹkwaru iphe, kparụ iphe, ọku ono te etsupyashịdu irwu ono.” ");
INSERT INTO izz_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Chipfu hụmaepho l'ọ kpịritawaru ntse g'o lerweta ẹnya; Chileke shi l'irwu ono kua ya oku sụ: “Mósisu! Mósisu!” Mósisu za ẹnu; sụ: “Wakwa mu nọ l'ẹka-a.” ");
INSERT INTO izz_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Chileke sụ iya: “Ta kpịritabaekwaru ntse ọzobaa! Yefụ akpọkpa ngu; noo kẹle ẹka ono, ị pfụru ono bụ alị, dụ nsọ.” ");
INSERT INTO izz_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Sụ iya: “Ọ kwa mbẹdua bụ Chileke kẹ nna ngu; bụru Chileke kẹ Ébirihamu; bụru Chileke kẹ Áyizaku; bya abụru Chileke kẹ Jiékọpu.” Mósisu nụmae ya phọ; o wohaa iphu; kẹle ndzụ ele Chileke ẹnya watarụ iya agụgu. ");
INSERT INTO izz_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","To bụdu iya bụ; Chipfu sụ: “Mu hụmawaru iphe-ẹhuka, ndibe mu eje l'alị ndu Ijiputu. Mu nụmawa mkpu, ẹphe echi sụ g'a dzọta phẹ l'ẹka ndu udumalị; tẹme iphe-ẹhuka, ẹphe eje rwuwa mu l'ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ọo ya bụ lẹ mu byawaru gẹ mu nafụta phẹ l'ẹka ndu Ijiputu; duru phẹ laa l'alị, dụ ree; bya adụ shii; mbụ alị mini ẹra-eswi; waa manụ-ẹnwu jiru kẹ pyịmu pyịmu; mbụ l'alị ndu Kénanu; waa ndu Hetu; waa kẹ ndu Amọru; waa kẹ ndu Pẹ́rezu; waa kẹ ndu Hevu; tẹme waa kẹ ndu Jiebusu. ");
INSERT INTO izz_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nta-a bẹ mkpu, ndu Ízurẹlu echi rwuwaru mu lẹ nchị; tẹme mu hụmawaa gẹ ndu Ijiputu gude akpa phẹ ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ọo ya bụ; lẹ nta-a bẹ mu ezi ngu g'i jepfu Fero je edufuta ndibe mu, bụ ndu Ízurẹlu l'alị Ijiputu!” ");
INSERT INTO izz_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mósisu sụ Chileke: “?Bụ onye bẹ mu bụ k'eje apfụru Fero l'iphu; je edufuta ndu Ízurẹlu l'alị Ijiputu?” ");
INSERT INTO izz_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Chileke sụ iya: “Mu e-swiru ngu eswiru. Tẹme waa iphe-ọhubama, ii-gude maru l'ọo mbẹdua ziru ngu ono baa: I -dufutaẹpho ndu ono lẹ Ijiputu bẹ unu a-barụ mụbe Chileke ẹja l'úbvú-a.” ");
INSERT INTO izz_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mósisu sụ Chileke: “Ọ -bụkwanuru lẹ mu jepfuru ndu Ízurẹlu je asụ phẹ: ‘Chileke kẹ nna unu phẹ zikwaru mu gẹ mu byapfuta unu.’ Ẹphe -jịkwanua mu sụ: ‘?Ẹpha ngu aza gụnu?’ ?Bụ gụnu bẹ mu e-yeru phẹ ọnu?” ");
INSERT INTO izz_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Chileke sụ Mósisu: “Mu bụ onye mu bụ. Iphe, ii-pfuru ndu Ízurẹlu bụ l'ọo mbẹdua, bụ Chipfu ziru ngu g'ị byapfuta phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Chileke sụkwapho gẹ Mósisu sụ ndu Ízurẹlu: “Ọo Chipfu, bụ Chileke kẹ nna unu phẹ; mbụ onye bụ Chileke kẹ Ébirihamu; bụru Chileke kẹ Áyizaku; bya abụru Chileke kẹ Jiékọpu bẹ ziru ngu g'ị byapfuta phẹ. Noo ẹpha mu bụ ono jasụ lẹ tuutuutuu lẹ mịimiimii. Ẹpha ono bẹ ọgbo mẹ ọgbo e-gude maru mu.” ");
INSERT INTO izz_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tụgbua je ekukọo ndu bụ ọgerenya lẹ Ízurẹlu; sụ phẹ lẹ Chipfu, bụ Chileke kẹ nna unu phẹ; byapfutaru ngu; mbụ onye ono, bụ Chileke kẹ Ébirihamu; bụru Chileke kẹ Áyizaku; bya abụru Chileke kẹ Jiékọpu. Waa iphe o pfuru baa: ‘Mu lewaru unu ẹnya; hụma ẹgube iphe, eeme unu lẹ Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mu kwewaa ukwe lẹ mu e-dufuta unu l'iphe-ẹhuka, unu eje lẹ Ijiputu; duru unu laa alị ndu Kénanu; waa kẹ ndu Hetu; waa kẹ ndu Amọru; waa kẹ ndu Pẹ́rezu; waa kẹ ndu Hevu; tẹme waa kẹ ndu Jiebusu; alị, mini ẹra-eswi; waa manụ-ẹnwu asọ gborogboro.’ ");
INSERT INTO izz_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ndu bụ ọgerenya Ízurẹlu bẹ a-ngabẹru ngu-a nchị. Ọo ya bụ; gụbedua unu lẹ ndu bụ ọgerenya atụko swịru jepfu eze ndu Ijiputu je asụ iya: ‘Chipfu, bụ Chileke ndu Hiburu bẹ byapfutakwaru anyi. Hanaa anyi g'anyi jee ije ujiku ẹto; lụfu l'echiẹgu je agwaa Chipfu, bụ Chileke anyi.’ ");
INSERT INTO izz_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ọle mu makwarụ-a l'eze ndu Ijiputu te ekwedu g'unu je; gbahaa l'e meru iya l'ọkpehu. ");
INSERT INTO izz_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ọo ya bụ lẹ mu a-machị ẹka mu; gude iphe, dụ biribiri, mu e-me lẹ Ijiputu nụa phẹ chịipfuu. Iphe ono -mechaẹpho bẹ oo-kwechaa haa unu g'unu lashịa. ");
INSERT INTO izz_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Mu e-me gẹ ndu Ízurẹlu-a dụ ndu Ijiputu l'obu; k'ọphu bụ; unu -lashịepho; unu ta agbadụru ẹka. ");
INSERT INTO izz_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nwanyị, nọnu a-sụ onye obutobu iya; ọzoo nwanyị, bu l'ụlo iya g'ọ nụ iya iphe, e meru lẹ mkpọla-ọchaa; waa ọphu e meru lẹ mkpọla-ododo; waa uwe, unu e-ye ụnwegirima unu. Ọo ya bụ unu eshi nno kwaa iphe ndu Ijiputu l'ọkwata gude lashịa.” ");
INSERT INTO izz_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mósisu sụ: “?Ọ -bụkwanuru l'ẹphe te kwetadụru iphe, mu pfuru; ọzoo l'ẹphe te ekwedu ngabẹru mu nchị; sụ l'ọo ụka lẹ Chipfu ta abyapfutaduru mu-e?” ");
INSERT INTO izz_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ọo ya bụ; Chipfu jịa ya; sụ: “?Bụ gụnu bẹ i gude l'ẹka ono?” Ọ sụ iya l'ọ kwa mgbọro. ");
INSERT INTO izz_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Chipfu sụ iya: “Tọgboedu iya l'alị!” Ọ tọgbo iya. Ọ ghọo agwọ. O ye ọkpa l'ọso. ");
INSERT INTO izz_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Chipfu sụ iya: “Machịa ẹka gude iya lẹ mgbọdzu!” Mósisu bya amachịa ẹka; zụ agwọ ono. Ọ nọdu iya l'ẹka; ghọ-zia bụru mgbọro g'o shi bụru. ");
INSERT INTO izz_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Chipfu sụ iya: “Mee iphe-a gude mee g'ẹphe kweta lẹ Chipfu, bụ Chileke kẹ nna phẹ; mbụ onye ono, bụ Chileke kẹ Ébirihamu; bụru Chileke kẹ Áyizaku; bya abụru Chileke kẹ Jiékọpu bẹ byapfutaru ngu nụ.” ");
INSERT INTO izz_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chipfu byakwa asụ Mósisu ọzo: “Nwua ẹka lẹ mkputẹpho ngu!” Mósisu bya eworu ẹka ye lẹ mkputẹpho. O wofutashịa ẹka; ekpenta nmawa iya ẹka swọkoswoko; ẹka chahụwa iya roboo. ");
INSERT INTO izz_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Chileke sụ iya: “Ngwa; yephu iya azụ lẹ mkputẹpho ngu!” Tọbudu iya bụ; Mósisu bya eyephu ẹka iya azụ lẹ mkputẹpho iya ono. O wofutashịa ya; ekpenta ono mishihuwa; mbụ ẹka dụkotawa iya g'ẹhu iya ibe iya ọphuu dụ. ");
INSERT INTO izz_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Noo ya; Chipfu sụ: “Ọ -bụru l'ẹphe te ekwetadu nkengu; ọzoo l'ẹphe ta angabẹduru ngu nchị l'iphe-ọhumalenya kẹ mbụ phọ bẹ ẹphe e-kweta-a k'ẹbo-a. ");
INSERT INTO izz_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Obenu ọ -bụru l'ẹphe te ekwetaduru; ọzoo l'ẹphe ta angabẹduru ngu nchị l'iphe-ọhumalenya labọ-a; je ekuta mini l'ẹnyimu Nayịlu; bya awụshi l'alị ọkponku. Mini ono, i kutaru l'ẹnyimu ono a-ghọ mee l'alị ẹka ono.” ");
INSERT INTO izz_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mósisu sụ Chipfu; “Oowaa Nnajịuphu; mu ta amakwa g'aasajẹ opfu. Eshikpọo lẹ mbụ bya adụru nta-a, iipfu eyeru mụbe onye-ozi ngu-a bẹ mu bụepho onye epfu dẹneshii bya abụru onye epfu l'ọnu ọku.” ");
INSERT INTO izz_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Chipfu sụ iya: “?Bụ onye meru ọnu nemadzụ? ?Bụ onye emeje nemadzụ l'ọoda nkụchi; ọzo ọnu kpụrukudukuu? ?Bụ onye emeje nemadzụ l'ọophu ụzo; ọzoo g'ọ tsụa ishi? ?Tọbudu mbẹdua, bụ Chipfu? ");
INSERT INTO izz_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ngwa je! Mu e-yetarụ ngu-a ẹka g'i pfua opfu; bya ezikwa ngu phọ iphe, ii-pfu.” ");
INSERT INTO izz_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Obenu lẹ Mósisu sụru: “Jiko Nnajịuphu mu; zia ya rọ onye ọzo g'o jee.” ");
INSERT INTO izz_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Noo ya; Mósisu mee; ẹhu ghuahaa Chipfu eghu. Ọ sụ Mósisu: “?Nwune ngu, bụkwanu Erọnu, bụ oshilọkpa Lívayi-e? Mu maru lẹ yẹbedua maru g'eepfu opfu. Ọ nọakwa l'ụzo ẹka ọobya ngu ndzuta. Ọzo bụ l'obu a-tsọ iya ụtso shii mẹ ọ -hụma ngu. ");
INSERT INTO izz_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ii-pfuje yeru iya; karụ iya iphe, oo-pfu. Mu a-nọdua eyeru unu n'ẹbo ẹka l'epfu opfu; tẹme ọ bụru mbẹdua a-nọdu ezije unu iphe, unu e-meje. ");
INSERT INTO izz_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ọo Erọnu bẹ e-pfuchitajeru ngu opfu l'atatiphu ndu Ízurẹlu. Mbụ l'ọo-dụepho g'ọ bụ yẹbedua bụ ọnu ngu. Tẹme l'ị dụe ya phọ g'ị bụ Chileke. ");
INSERT INTO izz_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ọle ọo g'i gude mgbọro-a, i gude l'ẹka-a; k'ọphu ii-gude iya meje iphe-ọhumalenya-a.” ");
INSERT INTO izz_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ọo ya bụ; Mósisu bya ejepfu Jieturo, bụ ọgo iya bya asụ iya g'ọ haa ya gẹ ya jepfu ndibe phẹ l'alị ndu Ijiputu je amaru ?ẹphe nọ-dzukwaduru-a ndzụ? Jieturo kweta bya asụ iya g'ọ tọkwa ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Teke ono bẹ Chipfu nọhawa l'alị ndu Midiyanu; sụ Mósisu: “Tụgbua laphu azụ l'alị ndu Ijiputu; noo kẹle iphe, bụ ndu ono, shi achọ ndzụ ngu ono nwụshihuchawaru.” ");
INSERT INTO izz_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ọo ya bụ; Mósisu bya eduta nyee ya; waa ụnwu iya; ẹphe nọ-koru l'eli nkapfụ-ịgara. Ọ bya ewota mgbọro Chileke ono gude l'ẹka; ọ bụru phẹ ala alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Chipfu sụ Mósisu: “Ị -laẹpho Ijiputu; tụkokwa iphe, dụ biribiri ono, mu yeru ngu l'ẹka g'i mee ono mekọta l'iphu Fero. Ọle mu a-kpọchi iya ọkpoma akpọ-chi; k'ọphu o too kwedu aha ndu ono g'ẹphe la. ");
INSERT INTO izz_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Iphe, ii-pfuru Fero bụ lẹ mụbe Chipfu sụru l'ọo Ízurẹlu bụ ọkpara mu. ");
INSERT INTO izz_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mu pfuwaru ngu sụ g'ị haa ọkpara mu ono g'ọ tụgbua; k'ọphu oo-je abarụ mu ẹja. Ị -jịka l'ị tịi hadụ iya g'ọ tụgbua bẹ mu e-gbukwa ọkpara nkengu.” ");
INSERT INTO izz_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Noo ya; o rwua l'ụzo ẹka ẹphe kwarụ; Chipfu byapfuta Mósisu bya emeahaa g'o gbua ya. ");
INSERT INTO izz_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Zipora wota mkpuma, atsụ nkọ; bya ebuta akpapyị nwa iya bya edenyi Mósisu l'ọkpa sụ iya: “Nta-a bẹ anyi lụwaru l'ẹhu mee.” ");
INSERT INTO izz_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ọo ya bụ; Chipfu haa ya. Teke ono, Zipora sụru l'ẹphe lụwaru l'ẹhu mee bẹ iphe, ọorwu ẹka bụ k'ebu úbvù. ");
INSERT INTO izz_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Chipfu sụ Erọnu g'o je l'echiẹgu je agba Mósisu ndzuta! Ọo ya bụ; Erọnu gbapfu Mósisu l'úbvú Chileke; je anma iya akpa. ");
INSERT INTO izz_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mósisu bya akọkotaru Erọnu iphemiphe, Chipfu ziru iya g'o je epfua; wakwaphọ k'iphe-ọhumalenya ono, Chileke sụru g'o meshia ono. ");
INSERT INTO izz_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mósisu yẹe Erọnu bya ekukọta ndu bụ ọgerenya Ízurẹlu g'ẹphe ha. ");
INSERT INTO izz_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Erọnu bya atụko iphemiphe, Chipfu pfushiru Mósisu pfukọtaru phẹ. Ọ bya emee iphe-ọhumalenya ono l'iphu ndu Ízurẹlu; ");
INSERT INTO izz_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ẹphe kweta. Ọo ya bụ; ẹphe nụmaepho lẹ Chipfu akpa ishi phẹ; tẹme waa l'ọ hụmawaru iphe-ẹhuka, ẹphe eje; ẹphe phozeta baarụ Chileke ẹja. ");
INSERT INTO izz_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","E mechaa; Mósisu yẹe Erọnu jepfu Fero bya asụ iya: “Waa iphe, Chipfu, bụ Chileke kẹ Ízurẹlu epfu baa: ‘Haa ndibe mu g'ẹphe je abọoru mu iphe l'echiẹgu!’ ” ");
INSERT INTO izz_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fero sụ: “?Bụ onye bụ Chipfu k'ọphu mu a-ngabẹru iya nchị; haa ndu Ízurẹlu g'ẹphe tụgbua? Sụ: Mu ta amakwa Chipfu; ọphu mu ahakwa ndu Ízurẹlu g'ẹphe tụgbua.” ");
INSERT INTO izz_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ẹphe sụ iya: “Chileke ndu Hiburu byapfutakwaru anyi. Jiko hanaa g'anyi wụru je l'echiẹgu jee ije ujiku ẹto je egweeru Chipfu, bụ Chileke anyi ngwẹja. Ọdumeka bẹ oo-gudekwa iphe-ememe; ọzoo ogu-echi gbushia anyi.” ");
INSERT INTO izz_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Obenu l'eze ndu Ijiputu kuru Mósisu yẹe Erọnu; sụ phẹ: “?Bụ gụnu kparụ iphe unu jeru je achịfuta ndu ono l'ozi, ẹphe eje? Ngwa; unu tụgbua laphu azụ l'ozi unu!” ");
INSERT INTO izz_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ọ sụkwapho: “Unu lewarọ ya! Nta-a bẹ ndu Ízurẹlu hawaa igwerigwe; tẹme unu gbẹ bya akpọshiaha phẹ ozi, ẹphe eje!” ");
INSERT INTO izz_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ọ bụru mbọku ono kwaphọ bẹ Fero kuru ndu udumalị; waa ndu-ishi l'ozi ndu Ízurẹlu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Unu ta anụjehe ndu Ízurẹlu ẹswa, ẹphe e-gude yọo ẹja! G'ẹphe jeje achọ ẹswa chịta l'onwophẹ! ");
INSERT INTO izz_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ọle g'unu mekwaa phẹ g'ẹphe yọtaje iya g'o dzua ole, ẹphe shiwaa ayọtaje iya. Unu te egbubọtakwa iphe l'ẹja ole, ẹphe shi ayọtaje. Ẹphe bụ ndu ẹnyiru; ọ bụru iphe ono meru g'o gude; ẹphe nọdu echi mkpu sụ g'a haa phẹ g'ẹphe je egweeru Chileke phẹ ngwẹja. ");
INSERT INTO izz_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Unu kabaa phẹ akpabẹ ozi; k'ọphu ụzo k'eje angabẹ nchị l'asụlasu ta adụeduru phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tọbudu iya bụ; ndu udumalị; waa ndu-ishi l'ozi ono bya asụ ndu Ízurẹlu: “Waa iphe, Fero pfuru baa. Ọ sụru g'a ta nụjehe unu ẹswa. ");
INSERT INTO izz_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","G'unu jeje achịta iya l'onwunu l'ẹka unu hụmaru iya. Ọle ozi unu bẹ e tee gbubọtakwa iphe mẹ nanụ.” ");
INSERT INTO izz_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ọo ya bụ; ndu Ízurẹlu gbakashịhu tsoru alị ndu Ijiputu l'ophu chọlahaa ẹswa, ẹphe e-vuta gude bya ayọ ẹja ọbu. ");
INSERT INTO izz_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ndu udumalị chịahaa phẹ kpabẹkpabe; sụ phẹ: “Ngwa! Unu yọta-dzua ẹja ole, unu shi ayọtaje ujiku lanụ teke phọ, e shi evutajẹru unu ẹswa phọ!” ");
INSERT INTO izz_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ndu udumalị Fero bya echiahaa ndu-ishi l'ozi ndu Ízurẹlu ono iphe; mbụ ndu ono, ẹphe họtaru dobe g'ẹphe letajẹ ndu Ízurẹlu ẹnya ono; sụ phẹ: “?Bụ gụnu kparụ iphe, unu ta ayọ-dzuduru ẹja unu ụnyaphu waa ntanụ-a; g'unu shi ayọ-dzujehawa iya?” ");
INSERT INTO izz_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ndu-ishi l'ozi ndu Ízurẹlu ono bya awụru jepfu Fero; sụ iya: “?Bụ gụnu bẹ iime anyịbe ndu-ozi ngu ẹgube-a? ");
INSERT INTO izz_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ndu ozi ngu bẹ e te vutajẹeduru ẹswa; tẹme a sụkwapho g'anyi yọo ẹja. A nọdu echi ndu-ozi ngu iphe; l'ẹka ọ gbẹ bụru ndu nkengu bẹ o shi l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fero sụ: “Ọo kẹ mmanụ ono, unu nọ ono meru iphe; unu pfuaharu g'a haa unu g'unu je egweeru Chipfu ngwẹja. ");
INSERT INTO izz_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ngwa! Unu tụgbua nta-a je eje ozi, unu eje. E tee vutabaẹduru unu ẹswa. Ọle mkpakọ bụkwa g'unu yọta-dzujee ẹja ole, unu shi ayọtaje!” ");
INSERT INTO izz_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ndu-ishi l'ozi ndu Ízurẹlu gbẹ teke ono maru l'ẹphe nmarụ l'agaga g'ẹphe nụmachaaru l'e tee gbubọtaduru iphe l'ẹja ole, ẹphe shi ayọtaje ujiku ophu. ");
INSERT INTO izz_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ẹphe lụfutaepho l'ibe Fero; ẹphe hụma Mósisu; waa Erọnu l'ẹka ẹphe pfụru echeru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ẹphe sụ: “Gẹ Chipfu lekwa ẹnya l'iphe-a, unu meru-a; kpee unu ikpe iya! Kẹle unu kpatarụ; anyi dụchawanu Fero yẹe ndu-ozi iya ashị. Nta-a bẹ unu wowaru mma ye phẹ l'ẹka g'ẹphe gbushia anyi.” ");
INSERT INTO izz_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mósisu jepfu Chipfu bya asụ iya: “Oowaa Nnajịuphu! ?Bụ gụnu kparụ iphe, iime gẹ ndu-a jee ẹgube iphe-ẹhuka-a? ?Bụ iphe, i zidoru mu baa? ");
INSERT INTO izz_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Eshi teke mu jepfucharu Fero je egude ẹpha ngu pfuru yeru iya bẹ o wotaru iphe-ẹhuka, dụ ẹgube-a nmakobe phẹ l'ishi. Ọphu ọ tọ dụdu iphe, i meru mẹ nanụ gude dzọta ndu nkengu.” ");
INSERT INTO izz_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Noo ya; Chipfu sụ Mósisu: “Nta-a bẹ ịi-hụmanu-a iphe, mu e-me Fero. Kẹle ọo ọkpehu mu bẹ mu e-gude mee l'ọ haa phẹ; mbụ l'ọo ọkpehu mu bẹ mu e-gude mee l'ọ chịfu phẹ l'alị iya.” ");
INSERT INTO izz_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Chileke sụkwapho Mósisu: “Ọo mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mu heru l'iphu Ébirihamu; bya ehee l'iphu Áyizaku; hekwaaphọ l'iphu Jiékọpu; karụ phẹ l'ẹpha mu bụ Chileke, bụ Ọkalibe-kangokọtaru-nụ. Obenu l'ẹpha mu ono, bụ Chipfu bẹ mu te emeduru g'ẹphe maru. ");
INSERT INTO izz_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Anyi l'ẹphe bya agbaa ndzụ lẹ mu a-nụ phẹ alị ndu Kénanu ẹka ẹphe shi buru gẹ ndu lwarụ alwalwa. ");
INSERT INTO izz_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ọzo bụ lẹ mu nụmawaru ude, ndu Ízurẹlu atsụ; mbụ ndu ono, ndu Ijiputu meru ohu ono. Mu nyata ọgbandzu mu ono. ");
INSERT INTO izz_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Ọo ya bụ; unu sụ ndu Ízurẹlu lẹ-a: Ọo mbẹdua bụ Chipfu; ọo mu a-nafụta unu l'ozi mkpọnwu-ẹhu ono, ndu Ijiputu meru; unu nọdu eje ono. Mu e-me g'unu nweru onwunu; g'unu ta abụheru ohu phẹ. Mu a-machị ẹka mu dzọta unu; bya emeshia iphe, dụ biribiri gude nụa phẹ aphụ. ");
INSERT INTO izz_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mu e-me; unu abụru ndibe mu; mu abụru Chileke unu. Ọo ya bụ g'unu amaru l'ọo mbẹdua, bụ Chipfu bụ Chileke unu; bya abụru onye nafụtaru unu l'ozi mkpọnwu-ẹhu ono, ndu Ijiputu meru; unu nọdu eje ono. ");
INSERT INTO izz_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mu e-duta unu je l'alị ono, mu paliru ẹka mu imeli ria nte lẹ mu a-nụ Ébirihamu; waa Áyizaku; waa Jiékọpu ono. Mu a-nụ iya unu g'ọ bụru okiphe unu. Ọo mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mósisu bya eje ezia ya ndu Ízurẹlu; obenu l'ẹphe te eyeduru iya ọnu; noo kẹle meji tọfuwaru phẹ; tẹme ozi mkpọnwu-ẹhu, ẹphe eje l'ẹka ono mewaru; ọ rẹfu phẹ l'ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Je epfuaru Fero, eze ndu Ijiputu g'ọ haa ndu Ízurẹlu g'ẹphe tụgbua lụfu l'alị iya.” ");
INSERT INTO izz_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mósisu sụ Chipfu: “Ọ -bụru lẹ ndu Ízurẹlu ta angabẹduru mu nchị; ?bụ ishi gụnu bẹ Fero e-gude ngabẹru mu nchị gẹ mu bụ onye epfu l'ọnu ọku-a?” ");
INSERT INTO izz_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Noo ya; Chipfu bya epfuaru Mósisu yẹe Erọnu opfu ẹhu ndu Ízurẹlu; waa opfu ẹhu Fero, bụ eze ndu Ijiputu; sụ phẹ g'ẹphe dufuta ndu Ízurẹlu l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Waa ndu-ishi l'ẹnya-unuphu ibe nna phẹ. Ụnwu kẹ Rúbẹnu, bụ ọkpara Ízurẹlu bụ Hanọku; waa Palu; waa Hẹzuronu; waa Kami. Ndu k'ono bụkota ọkpa-ipfu Rúbẹnu. ");
INSERT INTO izz_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ụnwu kẹ Simiyọnu bụ Jiemẹlu; waa Jiaminu; waa Ohadu; waa Jiakinu; waa Zoha; tẹme waa Shawulu, nwa, nwanyị shi Kénanu nwụtaru. G'ẹphe ha bụkota ọkpa-ipfu Simiyọnu. ");
INSERT INTO izz_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ẹpha ụnwu Lívayi lẹ g'e deru phẹ l'ẹkwo bụ: Geshọnu; waa Kohatu; tẹme waa Merari. Lívayi nọru ụkporo apha ishii l'apha iri l'ẹsaa. ");
INSERT INTO izz_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ụnwu Geshọnu l'ẹnya-unuphu l'ẹnya-unuphu phẹ bụ Libuni; waa Shimeyi. ");
INSERT INTO izz_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ụnwu Kohatu bụ Amụramu; waa Izuha; waa Hẹburonu; waa Uzẹlu. Kohatu nọru ụkporo apha ishii l'apha iri l'ẹto. ");
INSERT INTO izz_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ụnwu Merari bụ Mahuli; waa Mushi. Ono bụ ọkpa-ipfu Lívayi lẹ g'e deru iya l'ẹkwo. ");
INSERT INTO izz_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amụramu bya alụa nwune nna iya, bụ Jiokebẹdu. Ọ nwụtaru iya Erọnu; waa Mósisu. Amụramu nọru ụkporo apha ishii l'apha iri l'ẹsaa. ");
INSERT INTO izz_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ụnwu Izuha bụ Kora; waa Nẹfegu; tẹme waa Zikiri. ");
INSERT INTO izz_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ụnwu Uzẹlu bụ Mishẹlu; waa Ẹluzafanu; tẹme waa Sitiri. ");
INSERT INTO izz_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Erọnu bya alụa Elisheba, bụ nwatibe Amínadabu kẹ nwanyị; bụkwarupho nwune Náshọnu kẹ nwanyị. Elisheba ono nwụtaru iya Nadabu; waa Abihu; waa Eleyaza; tẹme waa Itama. ");
INSERT INTO izz_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ụnwu Kora bụ Asiru; waa Ẹlukana; tẹme waa Abiyasafu. Ndu k'ono bụ oshilọkpa Kora l'ipfu l'ipfu. ");
INSERT INTO izz_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyaza nwa Erọnu bya alụa onye lanụ l'ime ụnwegirima ụnwanyi ibe Putẹlu; ọ bya nwụtaru iya Finehasu. Ndu ono bụkota ndu-ishi unuphu ibe Lívayi l'ipfu l'ipfu. ");
INSERT INTO izz_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ọo bụru Erọnu; yẹe Mósisu ono bẹ Chipfu sụru g'ẹphe dufuta ndu Ízurẹlu g'ẹphe hakọta l'alị Ijiputu! ");
INSERT INTO izz_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ọ bụkwaru phẹ phọ bẹ bụ ndu pfuru Fero, bụ eze ndu Ijiputu k'edufuta ndu Ízurẹlu l'alị ndu Ijiputu. Ọo kwaphọ Mósisu yẹe Erọnu lanụ ono bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Noo ya; teke ono, Chipfu pfuru yeru Mósisu l'alị ndu Ijiputu ono ");
INSERT INTO izz_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","bẹ ọ sụru iya: “Ọo mbẹdua bụ Chipfu. Zikọta Fero, bụ eze ndu Ijiputu iphemiphe, mu ziru ngu.” ");
INSERT INTO izz_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Obenu lẹ Mósisu sụru Chipfu: “Eshi ọphu mu epfu l'ọnu ọku; ?dẹnu gẹ Fero e-mekwanụ ngabẹru mu nchị?” ");
INSERT INTO izz_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ọo ya bụ; Chipfu sụ Mósisu: “Hụma lẹ mu mewaru ngu; ị dụ Fero gẹ Chileke. Nwune ngu Erọnu bụ onye a-nọduje epfuchiru ngu opfu. ");
INSERT INTO izz_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Pfukọtakwa iphemiphe, mu pfuru ngu. Nwune ngu Erọnu bụ iphe, oo-pfuru Fero bụ g'ọ haa ndu Ízurẹlu g'ẹphe lụfu l'alị iya. ");
INSERT INTO izz_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Obenu lẹ mu a-kpọ-chi Fero ọkpoma. Mu e-mee iphe-ọhumalenya; waa iphe-ọhubama, dụ igwerigwe l'alị Ijiputu; ");
INSERT INTO izz_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ọle ọ tọ byadu angarụ unu nchị. Ọ bụru teke ono bẹ mu e-byi ndu Ijiputu ẹka l'ẹhu; meshia iphe, dụ biribiri gude nụa phẹ aphụ; dufuta ndibe mu, bụ ndu Ízurẹlu g'ẹphe hakọta lẹ Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ndu Ijiputu bẹ a-maru l'ọo mbẹdua bụ Chipfu mẹ mu machịepho ẹka mu byia Ijiputu; bya edufuta ndu Ízurẹlu l'echilabọ phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mósisu yẹe Erọnu bya emee gẹ Chipfu ziru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mósisu nọwaru ụkporo apha ẹno; Erọnu nọwa ụkporo apha ẹno l'apha ẹto teke ẹphe jeru je epfuru opfu nụ Fero. ");
INSERT INTO izz_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Chipfu sụ Mósisu yẹe Erọnu: ");
INSERT INTO izz_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ọ -bụru lẹ Fero sụru unu g'unu mee iphe-ọhumalenya gude goshi iphe, unu epfu; l'ị sụ Erọnu g'o woru mgbọro iya tọgbo l'atatiphu Fero! Ọ -tọgboe ya phọ; l'ọ ghọo agwọ.” ");
INSERT INTO izz_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ọo ya bụ; Mósisu yẹe Erọnu bya ejepfu Fero je emekọta gẹ Chipfu ziru phẹ. Erọnu tọgbo mgbọro iya ono l'iphu Fero; yẹe ndu-ozi iya; ọ ghọo agwọ. ");
INSERT INTO izz_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Fero bya ekukọo ndu mmamiphe; waa ndu emeje ọmamanshi. Ndu jibya ndu Ijiputu ono shi l'ọmamanshi ẹphe emeje mekwaaphọ nno. ");
INSERT INTO izz_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","G'ẹphe ha byaru atọgbochaa mgbọro nkephẹ l'alị; ọ ghọshia agwọ; ọle kẹ Erọnu bya atụko mgbọro nkephẹ lwekọta. ");
INSERT INTO izz_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ọle obu Fero kpọ-chilẹru-a; ọphu o kwedu ngabẹru phẹ nchị; gẹ Chipfu pfuru phọ. ");
INSERT INTO izz_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Noo ya; Chipfu sụ Mósisu: “Fero bẹ ọkpoma kpọakwaru mkpọlanu. Ọ jịkaakwaru lẹ ya ta ahadụ ndu Ízurẹlu g'ẹphe tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Jepfu Fero l'ụtsu m'o jeje l'ẹnyimu. Nọdu l'agụga Nayịlu kwabẹru iya; l'i wota mgbọro ono, shi ghọo agwọ phọ gude l'ẹka. ");
INSERT INTO izz_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","L'ị sụ iya lẹ Chipfu, bụ Chileke kẹ ndu Hiburu zikwaru ngu g'ị bya asụ iya g'ọ haa ndibe iya g'ẹphe tụgbua; je a-barụ iya ẹja l'echiẹgu. Ọphu i kwedu byasụ nta-a. ");
INSERT INTO izz_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","L'ị sụ iya: ‘Wakwa iphe, Chipfu pfuru baa: “Shita l'iphe-a, bẹ ii-shi maru l'ọo yẹbedua bụ Chipfu. Mụbe Mósisu e-woru mgbọro ono, mu gude l'ẹka ono chia lẹ mini Nayịlu. Mini ono agbanwee bụru mee. ");
INSERT INTO izz_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ẹma, nọkota lẹ Nayịlu a-nwụshihukota. Ẹnyimu ono eshihu kẹ swịswiswi. Ndu Ijiputu ta adụdu ike angụ mini, shi iya nụ.” ’ ” ");
INSERT INTO izz_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Chipfu sụ Mósisu: “Pfuaru Erọnu g'o wota mgbọro ono, o gude l'ẹka machịa lẹ mini, nọkota l'alị ndu Ijiputu. G'ọ maa ya l'ẹnyimu ẹnyimu; waa lẹ nggele nggele; waa l'okpuru okpuru; waa l'iphe, bụ o-che-mini g'ẹphe tụkochaa gbanwee bụru mee. Mee a-tụkoru ẹkameka sweta l'alị Ijiputu; mbụ lụfuchaa l'iphe, bụ iphe, aadọ mini; ndu ọphu a pyịru apyịpyi; mẹ ndu ọphu a kpụru akpụkpu.” ");
INSERT INTO izz_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mósisu yẹe Erọnu bya emeẹpho gẹ Chipfu ziru phẹ. Ọ bya eworu mgbọro iya malia l'atatiphu Fero; yẹe ndu-ozi iya; bya echia ya l'ẹnyimu Nayịlu. Mini, dụ l'ẹnyimu ono tụkoepho gbanwee bụru mee. ");
INSERT INTO izz_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ẹma, nọkota lẹ Nayịlu nwụshihukota. Mini ono shihuẹpho kẹ swịswiswi; k'ọphu bụ lẹ ndu Ijiputu ta adụdu ike ngụa mini, shi iya nụ. Mee ono tụko ẹkameka sweta l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ndu jibya ndu Ijiputu ono shi l'ọmamanshi ẹphe emeje mekwaaphọ nno. Ọo ya bụ; Fero kpọ-chile-a obu iya g'ọ kpọ-chiru iya. Ọphu ọ tọ ngabẹduru Mósisu yẹe Erọnu nchị; mbụ ẹgube ono, Chipfu pfuhawaru ono. ");
INSERT INTO izz_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ọ ghakọbe bya alaphushia azụ l'ibe iya. Ọphu iphe ono erwukpọdaru iya nụ l'ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ndu Ijiputu bya agwọshia obvu l'agụga Nayịlu; ẹka ẹphe achọ mini, ẹphe a-ngụ. Noo kẹle mini ẹnyimu ono ta adụdu k'angụngu. ");
INSERT INTO izz_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","A nọepho ujiku ẹsaa e -shi teke Chipfu byiru ẹka l'ẹnyimu Nayịlu; ");
INSERT INTO izz_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Chipfu sụ Mósisu: “Jepfu Fero je asụ iya: Wakwa iphe, Chipfu epfu baa: Haa ndibe mu g'ẹphe laa; k'ọphu ẹphe a-barụ mu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ọ -bụru l'ị jịkaru g'ẹphe ta lashị; mu egude mbara bya ọgu l'alị ngu l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mbara a-tụko ẹnyimu Nayịlu sweta; kposhihu bya akụru l'ibe ngu; kụru l'ime ẹka ịikwaje; kụru l'ọma iphe-azẹe ngu; kụru l'ụlo ndu-ozi ngu; kụru l'ibe ndu alị ngu l'ophu; kụru l'ọnu epfu, eeshijeru ngu ite; waa l'ochi, eegudeje agwọ iphe, e gude emeru ngu buredi. ");
INSERT INTO izz_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mbara ono a-nọduje apfụ-kogbaa ngu l'ẹhu; waa l'ẹhu ndu alị ngu; mẹ l'ẹhu ndu-ozi ngu l'ophu.” ");
INSERT INTO izz_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Chipfu sụ Mósisu: “Pfuaru Erọnu g'o wolia mgbọro iya ono; maa l'ẹnyimu ẹnyimu; waa lẹ nggele nggele; waa l'okpuru okpuru; mee gẹ mbara dzuru alị Ijiputu.” ");
INSERT INTO izz_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","No iya; Erọnu bya amachịa ẹka lẹ mini, nọkota l'alị ndu Ijiputu. Mbara wụfuta bya edzuru alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ndu jibya ono shi l'ọmamanshi ẹphe emeje mekwaaphọ nno. Ẹphe mekwarụpho; mbara wụbata l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fero kua Mósisu waa Erọnu bya asụ: “Unu pfuru yeru Chipfu g'o wofuru mu lẹ ndu alị mu l'ophu mbara-a; gẹ mu ahaa ndibe unu g'ẹphe je agwaa Chipfu.” ");
INSERT INTO izz_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mósisu sụ Fero: “Ùbvù, mu akwabẹ ngu bụ g'i pfua teke mu e-pfuru nụru ngu Chileke; waa ndu-ozi ngu; waa ndu alị ngu; k'ọphu mbara ta adụedu ngu l'ẹhu; mẹ l'ibe ngu; a -gụfu ndu ọphu nọ l'ẹnyimu Nayịlu.” ");
INSERT INTO izz_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fero sụ: “Ọo echele.” Mósisu sụ: “G'ọ dụ g'i pfuru; ọo ya bụ; g'i shi nno maru l'ọ tọ dụdu onye dụ gẹ Chipfu, bụ Chileke anyi. ");
INSERT INTO izz_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mbara ono a-ha ngu; haa ibe ngu; haa ndu-ozi ngu; haa ndu alị ngu. Ẹka ẹphe a-phọduepho kpoloko bụ l'ẹnyimu Nayịlu.” ");
INSERT INTO izz_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ọo ya bụ; Mósisu yẹe Erọnu lụfuepho l'iphu Fero; Mósisu bya araku Chipfu lẹ kẹ mbara ono, o meru; ọ bya ọgu l'alị-eze Fero ono. ");
INSERT INTO izz_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Chipfu bya emeeru Mósisu iphe, ọ rwọru iya. Mbara ono nwụshihukota l'ụlo; waa l'ọma-unuphu; waa l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","A bya akụa phẹ l'ikpo l'ikpo. Alị ono l'ophu shihu kẹ swịswiswi. ");
INSERT INTO izz_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Obenu lẹ Fero hụmaerupho lẹ mbara ono ta adụedu; o woru ọkpoma iya kpọ-chia. Ọphu o to kweẹdu angabẹru Mósisu yẹe Erọnu nchị gẹ Chipfu pfuru ono. ");
INSERT INTO izz_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ọo ya bụ; Chipfu sụ Mósisu g'o pfuaru Erọnu g'ọ machịa mgbọro iya chia l'urwuku, nọ l'alị; k'ọphu urwuku ono a-ghọ mkpụruumkpu; dzuru alị Ijiputu l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ẹphe mee nno. Erọnu bya amachịa mgbọro ono chia l'urwuku, nọ l'alị. Mkpụruumkpu bya erikpute nemadzụ ẹhu; yẹe anụ. Urwuku, nọkota l'alị Ijiputu ono mgburugburu bụkotaru mkpụruumkpu. ");
INSERT INTO izz_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ndu jibya bya emeahaa g'ẹphe shi l'ọmamanshi phẹ mekwaaphọ nno. Ọphu ẹphe adụedu ike. Mkpụrumkpu ono tụko ẹhu nemadzụ yẹe anụ ripyabẹ aata. ");
INSERT INTO izz_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ndu jibya ono sụ Fero: “Iphe-a bẹ ẹka Chileke dụkwa.” Obenu lẹ Fero kpọ-chilerua obu iya. Ọphu o to kwedu ngabẹ nchị gẹ Chipfu pfuru ono. ");
INSERT INTO izz_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ọo ya bụ; Chipfu sụ Mósisu g'o tehu l'ọnmewa ụtsu; jepfu Fero mẹ o -jejeẹpho l'ẹnyimu; sụ iya l'ọwa-a iphe, mụbe Chipfu pfuru baa: “Haa ndibe mu g'ẹphe laa; je abaarụ mu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ọ -bụru l'ị tịi hadụ ndibe mu g'ẹphe tụgbua bẹ mu e-zikwa ijiji g'o tsuru duuduuduu; wụ-pfuta ngu; wụ-pfuta ndu-ozi ngu; wụ-pfuta ndu alị ngu; mẹkwapho l'ụlo ngu l'ophu. Ụlo ndu Ijiputu bẹ ijiji e-jikọta; etsu duuduuduu; mbụ mẹchaa l'alị ẹka ẹphe azọje ọkpa. ");
INSERT INTO izz_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Obenu lẹ mbọku ono bẹ mu e-me g'alị Goshẹnu dụ iche. Mbụ l'ẹka ndibe mu bu bẹ ọ tọ dụdu ijiji, e-tsu duuduuduu l'ẹka ono; k'ọphu ịi-maru lẹ mbẹdua, bụ Chipfu nọ l'alị-a. ");
INSERT INTO izz_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mu a-kpa oke l'ẹka ndibe mu yẹe ndibe ngu nọ. Iphe-ọhumalenya-a e-me echele.” ");
INSERT INTO izz_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Chipfu bya emee iphe ono. Ijiji tsuru duuduuduu wụbata l'ibe Fero; mẹ l'ụlo ndu-ozi iya; mẹ l'alị Ijiputu l'ophu. Ijiji ono tụkoepho alị Ijiputu l'ophu mebyishikọta. ");
INSERT INTO izz_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Fero bya ekua Mósisu yẹe Erọnu bya asụ phẹ: “Unu je agwaa Chileke unu ọbu l'alị ẹka-a!” ");
INSERT INTO izz_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Obenu lẹ Mósisu sụru: “Ọ tọ dụdu ree nno; noo kẹle iphe, anyi egudeje agwa Chipfu, bụ Chileke anyi bụ ndu Ijiputu ẹbyi. Ọ -bụru l'anyi gude iphe, bụ ẹbyi l'ẹnya nkephẹ gwee ngwẹja; bẹ ẹphe a-tụ-gbukwa anyi lẹ mkpuma! ");
INSERT INTO izz_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Anyi e-jekwa ije ujiku ẹto jerwua l'echiẹgu je egweeru Chipfu, bụ Chileke anyi ngwẹja l'ẹka ono; ẹgube ọ tụru ekemu sụ g'anyi mee.” ");
INSERT INTO izz_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fero sụ: “Mu a-ha unu g'unu je egweeru Chipfu, bụ Chileke unu ngwẹja l'echiẹgu. Ọle g'unu te ejenukakwa ẹka dụ ẹnya. Ngwa; unu pfuru nụru mu Chileke!” ");
INSERT INTO izz_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mósisu sụ iya: “Mu -lụfuepho l'atatiphu ngu; mu epfuru nụ Chipfu; k'ọphu ijiji ono, etsu gbiigbiigbi ono a-ha gụbe Fero; waa ndu-ozi ngu; tẹme waa ndu alị ngu. Ọle gẹ gụbe Fero te egudenụpho ẹregede ọzo mee gẹ ndu Ízurẹlu te je abarụ Chipfu ẹja!” ");
INSERT INTO izz_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mósisu shi l'atatiphu Fero tụgbua; je epfuru nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Chipfu bya emee iphe, Mósisu rwọru iya. Ijiji ono parụ Fero; waa ndu-ozi iya; waa ndu alị iya haa. Ọphu ọ tọ dụdu mẹ ijiji lanụ, ghuduru nụ. ");
INSERT INTO izz_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Fero bya akpọ-chikwaphọ obu iya ọzobaa. Ọphu o to kwedu gẹ ndu Ízurẹlu tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Noo ya; Chipfu sụ Mósisu: “Jepfu Fero je asụ iya: Waa iphe, Chipfu, bụ Chileke ndu Hiburu pfuru baa: ‘Haa ndibe mu g'ẹphe tụgbua; je abaarụ mu ẹja!’ ");
INSERT INTO izz_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ọ -bụru l'ị jịkaru g'ẹphe ta tụgbushi; bya esede phẹ ");
INSERT INTO izz_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","bẹ Chipfu e-gudekwa ẹka iya zia ẹjo iphe-ememe; l'ọ bya atụko iphe-edobe unu gbushia. Mbụ l'oo-gbushi ịnya unu; waa nkapfụ-ịgara unu; waa ịnya-kamẹlu unu; tẹme waa eswi unu; waa atụru yẹe eghu unu. ");
INSERT INTO izz_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ọle Chipfu a-kpa oke l'ẹka iphe-edobe ndu Ízurẹlu; waa l'ẹka kẹ ndu Ijiputu nọ; k'ọphu bụ l'o to nwedu anụ kẹ ndu Ízurẹlu mẹ nanụ a-nwụhu nụ.” ");
INSERT INTO izz_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Chipfu bya epfua teke oo-me iphe ono; sụ: “Echele bẹ mụbe Chipfu e-me iphe ono l'alị-a.” ");
INSERT INTO izz_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","O -rwua lẹ nchitabọhu iya; Chipfu mee ya. Iphe-edobe ndu Ijiputu tụko nwụshihukota. Obenu l'o to nwedu kẹ ndu Ízurẹlu mẹ nanụ, nwụhuru nụ. ");
INSERT INTO izz_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fero zia ndu jeru je ahụma l'ọ tọ dụdu iphe-edobe ndu Ízurẹlu mẹ nanụ, nwụhuru nụ. Obenu lẹ Fero kpọ-chileru-a ọkpoma; ọphu o to kwedu gẹ ndu Ízurẹlu tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ọo ya bụ; Chipfu sụ Mósisu waa Erọnu: “Unu kpota ntụ, jiru mkpoji ẹka l'ovokọku; gẹ Mósisu phekashịa ntụ ono l'imeli l'atatiphu Fero. ");
INSERT INTO izz_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Oo-phekashịhu dzuru alị Ijiputu l'ophu g'urwuku; l'o mee; ẹjo-onwo aphọkashiaha nemadzụ l'ẹhu yẹe anụ, bu l'alị ono l'ophu. Ẹjo-onwo ono efushihu; baaha phẹ ọ́nyá.” ");
INSERT INTO izz_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ẹphe bya ekpota ntụ l'ovokọku; bya apfụru l'atatiphu Fero. Mósisu woru ntụ ono phekashịa l'imeli. Ẹjo-onwo bya atụko nemadzụ; yẹe anụ wata aphọkashi; baahaa phẹ ọ́nyá. ");
INSERT INTO izz_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ọphu ndu jibya adụdu ike pfụru l'atatiphu Mósisu; kẹle ẹjo-onwo ono phọkwaru phẹ phọ g'ọ phọru ndu Ijiputu ndu ọphu g'ẹphe ha. ");
INSERT INTO izz_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Obenu lẹ Chipfu kpọ-chiru Fero obu; ọphu ọ tọ ngabẹduru Mósisu yẹe Erọnu nchị; gẹ Chipfu pfuru Mósisu ono. ");
INSERT INTO izz_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ọo ya bụ; Chipfu sụ Mósisu: “Nmaa ẹwa l'ụtsu je apfụru l'atatiphu Fero; sụ iya: Waa iphe, Chipfu, bụ Chileke kẹ ndu Hiburu pfuru baa: ‘Haa ndibe mu g'ẹphe tụgbua; je a-barụ mu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ọdumeka bẹ ọgiya bẹ mu e-me g'ẹjo iphe-ẹhuka, l'a-lọ ngu ẹka lẹ meji byapfuta ngu; gụ lẹ ndu-ozi ngu; yẹe ndu alị ngu. Ọo ya bụ g'ị maru l'ọ tọ dụdu onye dụ gẹ mbẹdua lẹ mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Noo kẹle mu gege amachịhawa ẹka mu gude ẹjo iphe-ememe gbushia gụ lẹ ndu alị ngu; unu achịhu lẹ mgboko-a. ");
INSERT INTO izz_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Obenu l'iphe, kparụ iphe, mu gude haa ngu bụ k'ọphu mu e-goshi ngu g'ọkpehu mu habe shii. Ọo ya bụ g'eepfukashị-dzuru ẹpha mu lẹ mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Obenu l'iigude opfu ẹhu ndibe mu eku onwongu; jịka l'ị tịi hadụ phẹ g'ẹphe la. ");
INSERT INTO izz_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ẹgube nta-a echele bẹ mu a-tụ ẹjo akamini ẹgube teke atụ-swee l'alị Ijiputu e -shi teke o beberu dụ byasụ ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Zikwaa ozi nta-a g'e je achịbata iphe-edobe ngu l'ẹka iphe e-gbobuta iya; noo kẹle akamini ono a-tụ-gbushikọta nemadzụ; yẹe iphe-edobe, nọ l'ẹgu, a chịbataduru unuphu; ẹphe anwụshihukota.’ ” ");
INSERT INTO izz_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ndu-ozi Fero ndu ọphu atsụ Opfu Chipfu ebvu bya emee ẹgwegwa chịbata ohu phẹ; waa iphe-edobe phẹ l'ime ụlo. ");
INSERT INTO izz_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Obenu lẹ ndu agụbeduru Opfu Chipfu iphe bẹ harụ ohu phẹ; waa iphe-edobe phẹ l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ọo ya bụ; Chipfu sụ Mósisu g'ọ machịa ẹka l'akpaminigwe g'akamini awata adashị l'alị ndu Ijiputu tụ-gbushia nemadzụ mẹ iphe-edobe; waa irwu, dụkotakpo l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mósisu machịepho mgbọro iya l'akpaminigwe; Chipfu zia egbigwe; yẹe akamini; ọ wata adada. Ebemu nọdu alọ l'akpaminigwe. Chipfu dzee akamini l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Akamini yẹe ọku-egbigwe tụko ghaa ẹghirigha nọdu atụ gbaagbaa. Ẹjo oke phẹrephere, ha shii; nọdu ezi. Mbụ l'ọo phẹrephere ono kakọta shii lẹ phẹrephere, zijekpọoru l'alị ndu Ijiputu e -shi teke e beberu alị ndu Ijiputu dụ. ");
INSERT INTO izz_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","L'alị ndu Ijiputu mgburugburu bẹ akamini ono tụ-gbushikọtaru iphemiphe, nọkota l'ẹgu; nemadzụ mẹ iphe-edobe. Ọ tụpyashia iphemiphe, futaru l'ẹgu; bya ezijashicha iphe, bụ oshi, dụ l'ẹgu ezijashị. ");
INSERT INTO izz_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ẹka ọ tụduru akamini ono kpoloko bụ l'alị Goshẹnu, bụ ẹka ndu Ízurẹlu bu. ");
INSERT INTO izz_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Noo ya; Fero zia g'e je ekua Mósisu yẹe Erọnu; bya asụ phẹ: “Mu mewaru iphe-ẹji. Ọo Chipfu bẹ iswi dụ maa; mbẹdua, bụ Fero; waa ndibe mu achọ opfu. ");
INSERT INTO izz_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pfuru nụ Chipfu; noo kẹle egbigwe ono; yẹe akamini ono tụta-shiwaru. Mu je a-ha unu g'unu laa; ọ tọ gbaẹduru g'unu nọdukwadu.” ");
INSERT INTO izz_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mósisu sụ: “Mu -lụfuepho lẹ mkpụkpu-a; mu achị-lia ẹka imeli; pfuru nụ Chipfu. Egbigwe adabuhu; igwe atụ-buhu akamini. Ọo ya bụ g'ị maru lẹ mgboko-a bụ kẹ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Obenu lẹ mu maru-a lẹ gụbedua waa ndu-ozi ngu ta atsụadaa Chipfu, bụ Chileke ebvu.” ");
INSERT INTO izz_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Owu fulakusu; waa balị bẹ akamini ono mebyishichaaru; noo kẹle balị eyeshiwa mebyi; owu fulakusu bụkwaduru ige bẹ ọotu. ");
INSERT INTO izz_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Obenu lẹ witi; waa supélutu bẹ o to mebyishiduru; noo l'ọ tọ bụdu teke ono bẹ ọomije. ");
INSERT INTO izz_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mósisu parụ Fero haa; shi lẹ mkpụkpu ono tụgbua. Ọ bya apaliaru Chipfu ẹka imeli. Egbigwe; waa akamini tụkoru bụru kẹ nyọo; igwe dzebuhu mini l'alị ono. ");
INSERT INTO izz_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fero hụmaepho lẹ mini; waa akamini; waa egbigwe ono bụwaa kẹ nyọnyoronyo; o mekwaa iphe-ẹji ọzo. Yẹbedua yẹe ndu-ozi iya kpọ-chikwa obu phẹ ọzo. ");
INSERT INTO izz_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ọkpoma Fero bya akpọ-chikwa; ọphu o kwedu aha ndu Ízurẹlu g'ẹphe tụgbua, bụ iya bụ gẹ Chipfu shihawaa l'ọnu Mósisu pfua ya. ");
INSERT INTO izz_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Noo ya; Chipfu sụ Mósisu: “Jepfu Fero; noo kẹle mu kpọ-chiru iya obu; kpọ-chia kẹ ndu-ozi iya; k'ọphu mu e-meshigbaa oke iphe-ọhumalenya, dụgbaa biribiri l'echilabọ phẹ; ");
INSERT INTO izz_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","k'ọphu unu a-kọru ụnwu unu; mẹ ụnwu nwanwa unu gẹ mu gude kpaa ndu Ijiputu ẹhu; tẹme waa gẹ mu gude mee oke iphe-ọhubama nụ phẹ. Ọo ya bụ g'unu amaru l'ọo mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ọo ya bụ; Mósisu yẹe Erọnu bya ejepfu Fero sụ iya: “Waa iphe, Chipfu, bụ Chileke ndu Hiburu pfuru baa: ‘?Bụ teke ole bẹ ịijika-beru ewoze onwongu alị l'atatiphu mu? Haa ndibe mu g'ẹphe la; k'ọphu ẹphe e-je abaarụ mu ẹja! ");
INSERT INTO izz_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ọ -bụru l'ị jịkaru g'ẹphe ta tụgbushi bẹ mu e-gude igube bata l'alị ngu echele. ");
INSERT INTO izz_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ọo-bya atụko alị unu nyịnwua; k'ọphu bụ l'ọ tọ dụdu ẹka aahụma ụzo l'alị ono. L'ọ tụko iphe, akamini mebyishiphodoru tapyashịkota; mẹchaa iphe, bụ oshi, pfụru l'ẹgu unu. ");
INSERT INTO izz_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ẹphe abya atụko ụlo ngu; mẹ ụlo ndu-ozi ngu; mẹkpoo alị Ijiputu l'ophu sweta. Iphe ono bụ iphe, nna ngu; mẹ nna ngu oche phẹ teke ahụma-swee l'alị-a; e -shi teke ẹphe lwarụ ẹka-a byasụ nta-a.’ ” Mósisu dakọbe; parụ Fero haa; ọ bụru iya atụgbu. ");
INSERT INTO izz_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ndu ozi Fero sụ Fero: “?Bụ teke ole bẹ nwoke-a a-chị-beru anyi ọkpu akpọhu? Haa ndu-a g'ẹphe tụgbua je abaarụ Chipfu, bụ Chileke phẹ ẹja. ?Tị madụ l'alị ndu Ijiputu bụwaa mkpurupyata?” ");
INSERT INTO izz_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Noo ya; a bya eduphuta Mósisu yẹe Erọnu azụ l'iphu Fero. Ọ sụ: “Unu je abaarụ Chileke unu ẹja! Ọle ọ bụ; ?bụlaje ndu ole e-je?” ");
INSERT INTO izz_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mósisu sụ: “Anyi l'ụnwegirima anyi; waa ndu bụ ọgerenya anyi; waa ụnwu anyi kẹ nwoke; waa kẹ nwanyị a-tụkokwa swịru; anyi atụko atụru anyi; waa eswi anyi rwuta. Noo kẹle anyi a-bọru Chipfu anyi ọbo-iphe.” ");
INSERT INTO izz_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Fero sụ phẹ: “Gẹ Chipfu swikwaru unu eswiru ọme ọo kẹ gẹ mu haa unu g'unu l'ụnwegirima unu swịru tụgbua! Nta-a bẹ mu makpọoru l'ọo ẹjo-iphe bẹ unu arị k'ememe. ");
INSERT INTO izz_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Waawakwa-o; g'ọ bụru ndu k'unwoke kpoloko bẹ unu e-rwuta gude je abarụ Chipfu ẹja; eshi ọphu ọ bụ iphe ono bẹ unu shi teke-a rwọta!” Noo ya; a chịfu Mósisu yẹe Erọnu l'iphu Fero. ");
INSERT INTO izz_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chipfu sụ Mósisu: “Machịa ẹka maa l'alị Ijiputu; g'igube wụbata l'alị ono bya atụko iphe, futaru l'ẹgu l'alị ono tapyashịkota; mbụ iphe, akamini mebyishiphodoru.” ");
INSERT INTO izz_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ọo ya bụ; Mósisu bya eworu mgbọro iya maa l'alị ndu Ijiputu. Chipfu bya emee; phẹrephere shi l'ụzo ẹnyanwu-awawa wata ezizi. Phẹrephere ono zikọta l'alị ono eswe l'ẹnyashi. A fụtashia l'ụtsu; phẹrephere ono vubatawa igube l'alị ono. ");
INSERT INTO izz_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Igube tụko Ijiputu sweta; bya anọepho l'ẹkameka l'alị ono kẹ nyịmunyimu. Igube teke ekpofutaswe ẹgube ono; tẹme ọphu ọ byadu awụbataba l'ọtu ẹgube ono ọzo. ");
INSERT INTO izz_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ẹphe nyịnwuepho alị ono l'ophu; k'ọphu bụ l'ẹkameka jihukọtaru kẹ kpakpalu. Ẹphe bya atụko iphe, phọduru nụ g'akamini byachaaru tapyashịkota; mbụ iphe, rwutakpọoru irwu l'ẹgu; mẹchaa akpụru oshi. Ẹkwo oshi; mẹ k'iphe, a kọru l'ẹgu te nwedu mẹ nanụ, phọduru nụ l'alị Ijiputu l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Fero bya ekua Mósisu yẹe Erọnu ẹgwegwa; sụ phẹ: “Mu meswewaru Chipfu, bụ Chileke; bya emeswee unu. ");
INSERT INTO izz_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Jiko gụfuaru mu nvụ ugbo lanụ ọwa-a; je epfuru nụ Chipfu, bụ Chileke unu g'o wofuru mu ẹjo iphe-ẹhuka-a!” ");
INSERT INTO izz_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mósisu parụ Fero haa; lụfu je epfuru nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ọo ya bụ; Chipfu bya agbanwee phẹrephere ono; mee ya; ọ bụru eze phẹrephere, ha shii, shi l'ụzo ẹnyanwu-arịba bya ezikotachaa igube ono g'ọ ha je achịru ye lẹ Eze-ẹnyimu Uswe-uswe. Ọphu ọ tọ dụdu mẹ igube lanụ, ghuduru l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ọle Chipfu kpọ-chilerua obu Fero; ọphu o kwedu haa ndu Ízurẹlu g'ẹphe tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Noo ya; Chipfu sụ Mósisu g'ọ machịa ẹka maa l'akpaminigwe; g'ọchii bya asọ-kpute ẹkameka l'alị ndu Ijiputu. Ọchii, e-me g'ẹkameka gbahụ kẹ tsụkiribaa. ");
INSERT INTO izz_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ọo ya bụ; Mósisu bya amachịa ẹka maa l'akpaminigwe. Alị ndu Ijiputu l'ophu gbahụkota tsụrikitiki; nọ abalị ẹto. ");
INSERT INTO izz_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ọphu ọ dụdu onye hụmaru nwibe iya; tẹme ọphu ọ dụdu onye hụmaru ụzo kẹ g'o shi l'ẹka o bu kpụriberu; jasụ abalị ẹto ono. Obenu lẹ ndu Ízurẹlu bẹ ìphóró dụ l'ẹka ẹphe bu. ");
INSERT INTO izz_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Noo ya; Fero kua Mósisu bya asụ: “Unu je abaarụ Chipfu ẹja! Unu dutachaa ụnwanyi mẹ ụnwegirima unu g'unu swịru! Iphe, unu a-ha kpoloko bụ atụru; waa eswi unu.” ");
INSERT INTO izz_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Obenu lẹ Mósisu sụru iya: “Ịi-hafụkwapho anyi g'anyi gude iphe, anyi e-gude nụ Chipfu, bụ Chileke anyi ngwẹja-akpọ-ọku; waa ngwẹja mmanụ ọzo. ");
INSERT INTO izz_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ọo ya bụ l'anyi e-rwuta iphe-edobe anyi. A taa hakwa g'ọ ka mma l'ọo ichiripfu ọkpa eswi; k'ọphu anyi a-harụ iphe-edobe ono hata gude baarụ Chipfu, bụ Chileke anyi ẹja. Anyi ejerwuduru ẹka ono bẹ anyi ta amadụ ndu ọphu anyi e-gude baarụ Chileke ẹja.” ");
INSERT INTO izz_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ọle Chipfu kpọ-chilerua obu Fero; ọphu o kwedu haa ndu Ízurẹlu g'ẹphe tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fero sụ Mósisu: “Makwarụ onwongu! Gbẹshi mu l'iphu! Gẹ mu ta ahụmabaekwa ngu ọzo l'atatiphu mu. Mbọchi, ị byabaaru apfụru mu l'iphu bẹ ịi-nwụhukwa!” ");
INSERT INTO izz_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mósisu sụ iya: “G'ọ dụ nụ g'i pfuru. Mu ta abyabaẹdu ngu apfụru l'iphu ọzobaa.” ");
INSERT INTO izz_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Noo ya; Chipfu sụ Mósisu: “Mu e-gudefụa oke iphe-ẹhuka lanụ byapfuta Fero; yẹle ndu Ijiputu. E -mechaẹpho bẹ oo-kwechaa g'unu wụfu l'ẹka-a. Tẹme o -kweẹpho ono bẹ ọo-chịfukota unu g'unu ha. ");
INSERT INTO izz_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pfuaru ndu Ízurẹlu; g'unwoke phẹ; waa ụnwanyi phẹ; jepfu ndu obutobu phẹ je asụ phẹ g'ẹphe nụ phẹ iphe, e meru lẹ mkpọla-ọchaa; waa ọphu e meru lẹ mkpọla-ododo!” ");
INSERT INTO izz_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Chipfu bya emee; ndu Ízurẹlu tụba ndu Ijiputu l'obu; mekwaaphọ gẹ ndu-ozi Fero; waa ndu Ijiputu l'ophu kwabẹ Mósisu l'onwiya eze ùbvù, ha shii. ");
INSERT INTO izz_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ọo ya bụ; Mósisu sụ: “Wakwa iphe, Chipfu epfu baa. Ọ sụru lẹ ya e-gude ụzo echi abalị jedzuru alị Ijiputu l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Iphe, bụkota ndu bụ ọkpara lẹ nwoke l'alị Ijiputu bẹ a-nwụshihukota nụ; a -gbẹ l'ọkpara Fero, bụ onye nọ l'aba-eze; je akpaa l'ọkpara nwanyị, bụ ohu, bụ onye egwejeru iya iphe; mẹkwapho iphe-edobe, e vuru ụzo nwụa l'ẹpho ne iya. ");
INSERT INTO izz_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Oke ụzu-ẹkwa, parụ ẹka a-tụ l'alị Ijiputu l'ophu. Mbụ ụzu-ẹkwa, ẹtu iya adụjeduru; ọphu ọ byadu l'a-dụbaa. ");
INSERT INTO izz_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Obenu l'ẹka ndu Ízurẹlu bu bẹ ọ tọ dụdu g'ọ ka mma l'ọo nkụta bya agbọ ire kpua nemadzụ; ọzoo anụ. Ọo ya bụ g'unu amaru lẹ Chipfu kparụ oke; dokaha Ijiputu yẹe Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","No teke ndu-ozi ngu-a a-wụ-pfuta mu bya ephozeru mu bya asụ mu: ‘Unu tụgbuwaro-o! Tụkokpoo ndu ndu-unu l'ophu rwuta tụgbua-o!’ Ọ -nwụchaepho nno; mu atụgbua.” No iya; Mósisu gude ẹhu-eghu lụfu-shia l'iphu Fero. ");
INSERT INTO izz_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tọbudu iya bụ; Chipfu bya asụ Mósisu: “Fero te ekwekwa angabẹru ngu nchị; gẹ mu eshi nno meshia igwerigwe iphe-ọhumalenya l'alị Ijiputu.” ");
INSERT INTO izz_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Noo ya; Mósisu yẹe Erọnu bya emeshikọta iphe-ọhumalenya ono l'iphu Fero. Obenu lẹ Chipfu kpọ-chileru-a Fero obu; ọphu o to kwedu haa ndu Ízurẹlu g'ẹphe shi l'alị iya wụfu lashịa. ");
INSERT INTO izz_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Chipfu sụ Mósisu yẹe Erọnu l'alị ndu Ijiputu: ");
INSERT INTO izz_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ọnwa-a, a nọ-a; a-bụjeru unu ọnwa mbụ l'apha. ");
INSERT INTO izz_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pfuaru ndu Ízurẹlu g'ẹphe ha l'o -rwua mbọku, ọnwa-a a-dụ l'abalị iri gẹ nwoke, nọnu kpụta nwatụru lanụ dobe kẹ yẹe ndibe iya. ");
INSERT INTO izz_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ọ -bụru lẹ ndibe onye ọbu hanụkaru nwanshịi; k'ọphu bụ lẹ nwatụru ophu parụ phẹ ẹka; ẹphe ejepfu ndu kachaa phẹ ebukube ntse; g'ẹphe gbarụ mgba lẹ nwatụru lanụ; m'ẹphe gụchaa onwophẹ maru ole, ẹphe dụ. Unu lee ẹnya lẹ g'onyemonye a-taberu. ");
INSERT INTO izz_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Anụ, unu a-họta l'a-bụru anụ, gbaru apha; bụru okee ya; bya abụru ọphu adụdu ẹka iphe mebyiru iya. Unu -eshidu l'atụru họta iya; unu ahọta iya l'eghu mmanụ. ");
INSERT INTO izz_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Unu leta iya ẹnya gbiriri jasụ mbọku, ọnwa-a l'a-dụ l'abalị iri l'ẹno. Noo mbọku, ndu Ízurẹlu l'ophu e-gbushikọta iya g'ọ ha l'ụzenyashi iya. ");
INSERT INTO izz_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ẹphe aharu mee ya nata techaa l'agụga mgbo; waa l'eli oshi-mgbo, nọkota l'ụlo, ẹphe nọ ata anụ nwatụru ono. ");
INSERT INTO izz_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ẹnyashi ono bẹ ẹphe a-ta anụ nwatụru, a hụru ahụhu l'ọku; yẹe ẹkwo oshi, atsọ ilu; waa buredi, e yedụru iphe, ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Unu te eshikwa anụ ono eshishi; ẹbe unu atakwa iya l'oyii. Ọo ẹpho g'unu hụshia ya l'ọku; mbụ ishi iya; mẹ ọkpa iya; mẹchaa iphe-ẹpho iya. ");
INSERT INTO izz_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","G'o to nwekwa ọphu unu a-ha g'ọ bọo nchi. Ọ -bụru l'o nweru ọphu a harụ; ọ nọo fụta ụtsu; unu akpọo ya ọku. ");
INSERT INTO izz_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Waa g'unu e-gude taa ya baa: Unu gude akpọ tubuta uwe unu; unu eye akpọkpa unu l'ọkpa; bya ewota mgbọro unu parụ l'ẹka. Unu ataa ya wobuwobuwobu; kẹle ọo ọbo Ojeghata kẹ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ẹnyashi ono kwaphọ bẹ mu e-jedzuru alị Ijiputu; gbushigbua iphe, bụ ọkpara nemadzụ mẹ iphe-edobe. Iphe, bụkpoo agwa ndu Ijiputu l'ophu bẹ mu a-nụkota chịipfuu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mee ono a-bụru iphe-ọhubama, e-goshije ụlo ọphu unu nọ. Ọo ya bụ; mu -hụmaepho mee ono; mu aghata unu. O to nwedu ẹjo iphe-ememe, e-byi unu ẹka teke mu a-nọdu egbushi ndu Ijiputu ono. ");
INSERT INTO izz_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Mbọku ono l'a-bụru unu mbọku ọbo-iphe, unu e-gudeje nyata iphe-a. E shi l'ọgbo sweru ọgbo bẹ unu a-bọje iya g'ọ bụru ọbo-iphe kẹ Chipfu. Ekemu ono a-dụ jasụ lẹ tuutuutuu lẹ mịimiimii. ");
INSERT INTO izz_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ujiku ẹsaa bẹ unu a-ta buredi, e yedụru iphe, ekoje buredi. Mbọku mbụ bẹ unu e-wofukọta iphe, ekoje buredi l'ụlo unu. Noo kẹle iphe, bụkpoo onye tarụ iphe, e yeru iphe, ekoje buredi; a -gbẹ lẹ mbọku mbụ ono jasụ lẹ mbọku k'ẹsaa ono bẹ ee-bufu lẹ Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mbọku kẹ mbụ bẹ unu e-nweru ndzukọ, dụ nsọ; bya enwekwarụpho ọzo mbọku k'ẹsaa. G'ọ tọ dụkwa iphe, unu e-je l'ujiku labọ ono; gbahaẹpho nri, unu e-ri bẹ unu e-shije. Noo iphe, unu e-meje bụ ono kpoloko. ");
INSERT INTO izz_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Unu bọo ọbo-iphe buredi, ekoduru ekoko; noo kẹle ọo mbọku ono gẹdegede bẹ mu dufutaru unu g'unu hakọta l'alị Ijiputu. Unu bọje mbọku ono ọbo-iphe; g'ọ bụru ekemu, a-nọ jasụ l'ojejoje; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","L'ọnwa mbụ phọ bẹ unu a-tajẹ buredi, e yedụru iphe, ekoje buredi; a -gbẹ l'ụzenyashi mbọku, ọnwa ono dụ l'abalị iri l'ẹno jasụ l'ụzenyashi mbọku, ọ dụ l'ụkporo abalị l'abalị lanụ. ");
INSERT INTO izz_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ujiku ẹsaa bẹ a ta abyadụ ahụma iphe, ekoje buredi l'ụlo unu. Onye rikpọoru iphe, e yeru iphe ekoje buredi bẹ ee-bufu lẹ ndu Ízurẹlu; m'onye ono bụ nlwamụlwa; ọzoo onye a nwụru anwụnwu l'alị ono. ");
INSERT INTO izz_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","G'o tọ dụkwa iphe, e yeru iphe, ekoje buredi, unu e-de ọnu. Ẹka unu e-buhabẹ; unu taa buredi, ekoduru ekoko!” ");
INSERT INTO izz_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tọbudu iya bụ; Mósisu bya ekukọo ndu bụ ọgerenya Ízurẹlu g'ẹphe ha; bya asụ phẹ: “Unu tụgbua nta-a nta-a; je ahọta anụ ọphu unu lẹ ndibe unu e-gbu gude bọo ọbo Ojeghata k'unu. ");
INSERT INTO izz_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Unu ewota ẹkwo ịsopu, dụ jipfujipfu tsẹe lẹ mee anụ phọ, a nakọberu lẹ gbamụgbamu phọ tee l'eli oshi-mgbo ono; waa l'agụga iya ibe k'ẹbo ẹbo. G'o to nwekwa g'unu ha onye a-lụfu etezi jasụ l'ụtsu. ");
INSERT INTO izz_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ọo ya bụ; Chipfu -jeshiẹpho egbushi ndu Ijiputu; l'ọ hụma mee, e teru l'eli oshi-mgbo waa l'agụga iya ono; l'ọ ghata ọnu mgbo k'ono. O too kwedu gẹ mgbugbụmadzu ono bata l'ụlo unu bya egbushia unu. ");
INSERT INTO izz_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Unu mejekwa iphe-a g'ọ bụru nsọ, a-dụru unu l'oshilọkpa unu jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Unu -bahụepho l'alị ono, Chipfu a-nụ unu ono, bụ iya bụ iphe, o kweru ukwe iya ono; unu mejekwa omelalị ono. ");
INSERT INTO izz_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ọ -bụru l'ụnwu unu jịru unu sụ: ‘?Bụ gụnu bẹ unu emedojeru omelalị ono?’ ");
INSERT INTO izz_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","unu asụ phẹ: ‘Ọo ngwẹja egbu anụ ọbo Ojeghata, eegweru Chipfu, bụ onye ghataru ụlo ndu Ízurẹlu l'alị ndu Ijiputu je egbushia ndu Ijiputu; mbụ onye harụ unuphu ibe anyi; ọphu o gbuduru ndibe anyi.’ ” Ndu Ízurẹlu -nụmaepho iphe ono; ẹphe phozeta; baarụ Chipfu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ndu Ízurẹlu bya emee iphe ono; gẹ Chipfu tọru Mósisu yẹle Erọnu ọkpa iya; ọ bụru ẹgube ono bụ g'ẹphe meru iya. ");
INSERT INTO izz_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","O -rwua l'echi-abalị; Chipfu bya egbushia ọkpara ndu Ijiputu l'ophu; a -gbẹ l'ọkpara Fero, bụ onye nọ l'aba-eze; jasụ l'ọkpara onye mkpọro, a tụ-chiru l'ọka-mkpọro; wakwaphọ nwa ivuzọ iphe-edobe. ");
INSERT INTO izz_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Fero; yẹe ndu-ozi iya g'ẹphe ha; waa ndu Ijiputu l'ophu tehu l'ẹnyashi. Ụzu-ẹkwa nọdu atụwaa l'alị Ijiputu; noo kẹle o to nwedu ụlo, nọ l'alị ono l'ophu, nemadzụ ata nwụhuduru. ");
INSERT INTO izz_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Fero bya ekua Mósisu yẹe Erọnu l'ẹnyashi ono; sụ phẹ: “Unu gbẹshi; unu lẹ ndu Ízurẹlu; jewarọ. Unu parụ ndu alị mu haa; tụgbuwaro je abaarụ Chipfu ẹja, bụ iya bụ iphe, unu epfukpọo. ");
INSERT INTO izz_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Unu rwuta atụru unu; waa eswi unu gude tụgbua, bụ iphe, unu epfu. Ọle unu gọkwaaru mu ọnu-ọma.” ");
INSERT INTO izz_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ndu Ijiputu nọdu alwụru ndu Ízurẹlu ụlwu g'ẹphe mee ẹgwegwa lụfu l'alị ẹka ono; kẹle ẹphe sụru l'ọdumeka bẹ ẹphebe ndu Ijiputu a-nwụshihukotakwa. ");
INSERT INTO izz_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ẹphe kpota iphe, eegudeje eghe buredi kpojia ochi buredi; gude uwe phẹ kechia ya; nmakobe iya l'ukuvu; ọphu ẹphe eyeduru iya iphe, ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ndu Ízurẹlu mee gẹ Mósisu ziru phẹ; bya arwọkoo ndu Ijiputu iphe, e meru lẹ mkpọla-ọchaa; waa mkpọla-ododo; waa uwe. ");
INSERT INTO izz_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Chipfu mee; ndu Ízurẹlu tụba ndu Ijiputu l'obu; k'ọphu ẹphe nụru phẹ iphemiphe, ẹphe rwọru phẹ. Ẹphe shi nno kwaa iphe ndu Ijiputu l'ọkwata gude tụgbua. ");
INSERT INTO izz_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ndu Ízurẹlu shi lẹ mkpụkpu Ramesẹsu jeshia mkpụkpu Sukọtu. Unwoke ndu ọphu gude ọkpa eje rwuru ụkporo ụnu mgbo ụkporo ẹto; l'ụkporo ụnu ugbo iri l'ise; a -gụfukwa ụnwanyi waa ụnwegirima. ");
INSERT INTO izz_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ndu ọzo, dụkwapho igwerigwe tsokwaru phẹ phọ; wakwaphọ ikpoto iphe-edobe; mbụ atụru mẹ eswi. ");
INSERT INTO izz_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Iphe, eegheje buredi, ẹphe shi l'alị Ijiputu gude bẹ ẹphe gude ghee akara, e yedụru iphe, ekoje buredi. Iphe meru g'o gude ọphu iphe, ekoje buredi adụdu iya bụ l'a chịfuru phẹ achịfu l'alị Ijiputu; ọphu ụzo k'akwakọbe kẹ nri, ẹphe e-ri adụduru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Iphe, ndu Ízurẹlu nọru l'alị Ijiputu bụ ụnu apha l'apha ụkporo l'iri. ");
INSERT INTO izz_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","O -rwuẹpho lẹ mbọku, ụnu apha l'apha ụkporo l'iri ono bvụru gẹdegede; ndibe Chipfu g'ẹphe ha, bụ iya bụ ndu Ízurẹlu; wụfukota l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Eshi ọphu Chipfu nwụru ẹnya l'ẹnyashi ono g'oo-me dufuta phẹ lẹ Ijiputu bẹ ẹphebe ndu Ízurẹlu g'ẹphe ha a-nwụjekwarupho Chipfu ẹnya l'ẹnyashi ono gude kwabẹ iya ùbvù; e shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Chipfu sụ Mósisu waa Erọnu: “Waa g'unu e-meje k'ọbo Ojeghata baa: “G'o to nwekwa nlwamụlwa, l'a-tajẹ anụ ọbo-iphe ono. ");
INSERT INTO izz_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ohu, unu gbatarụ agbata bẹ unu e-bujeada úbvù; tẹme l'ọ taa ya. ");
INSERT INTO izz_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ọle g'onye, byaru abyabya; ọzoo onye e beru ozi ba atajẹkwa iya. ");
INSERT INTO izz_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Aa-nọduje l'ime ụlo lanụ taa ya. G'o to nwekwa anụ ọbu; ọphu ee-gude lụfuta etezi. Ọphu ọ dụkwa ọkpu iya mẹ nanụ, unu a-nyakwo anyakwo. ");
INSERT INTO izz_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ndu Ízurẹlu g'ẹphe ha bẹ a-tụkoje bọo ọbo-iphe ono. ");
INSERT INTO izz_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ọ -bụru l'onye lwarụ alwalwa, bu lẹ ndunu bẹ ọ dụ gẹ ya yịru l'ọbo Ojeghata kẹ Chipfu ono; g'o bushikọta ndibe iya ndu k'unwoke úbvù g'ẹphe ha. Ọo ya bụ l'ọ yịwaruro bọaha ya g'onye a nwụru l'alị ono. G'o to nwekwa nwoke, ebuduru úbvù, a-ta iya nụ. ");
INSERT INTO izz_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ọo ekemu lanụ-a dụru onye a nwụru anwụnwu l'alị-a; bya adụru onye lwarụ alwalwa; unu ẹya tụko buru.” ");
INSERT INTO izz_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ndu Ízurẹlu g'ẹphe ha bya emekọta iphe, Chipfu pfuru Mósisu yẹe Erọnu. ");
INSERT INTO izz_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ọ bụru lẹ mbọku ono gẹdegede bẹ Chipfu dufutaru ndu Ízurẹlu g'ẹphe hakọta l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Doberu mu ọkpara unu iche. Iphe-mbụ, vu-kpọoru ụzo waa ẹkpa-nwa l'ẹpho ne iya lẹ Ízurẹlu: mẹ nemadzụ mẹ iphe-edobe; bụ nkemu.” ");
INSERT INTO izz_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Noo ya; Mósisu sụ ndu Ízurẹlu: “Unu nyata ntanụ-a; mbụ mbọku, unu wụfutaru lẹ Ijiputu, bụ ẹka unu shi bụru ohu. Ntanụ-a bụ mbọku, Chipfu gude ọkpehu iya dufuta unu. G'ọ tọ dụkwa onye a-ta iphe, e yeru iphe, ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ọo ntanụ-a l'ime ọnwa Abibu-a bẹ unu atụgbu. ");
INSERT INTO izz_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Teke Chipfu durwuẹrupho unu l'alị ndu Kénanu; waa kẹ ndu Hetu; waa kẹ ndu Amọru; waa kẹ ndu Hevu; tẹme waa kẹ ndu Jiebusu; alị ono, o riburu nna unu oche phẹ angụ lẹ ya a-nụ unu; alị, mini ẹra-eswi waa manụ-ẹnwu jiru kẹ pyịmu pyịmu; unu dobejekwa omelalị-a l'ọnwa-a. ");
INSERT INTO izz_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ujiku ẹsaa bẹ unu a-takọta buredi, e yedụru iphe, ekoje buredi. O -rwua lẹ mbọku k'ẹsaa; unu abọoru Chipfu ọbo-iphe. ");
INSERT INTO izz_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unu takọtaje buredi, e yedụru iphe, ekoje buredi l'ime ujiku ẹsaa ono. G'o to nwekwa iphe, e yeru iphe, ekoje buredi, aa-hụma l'echilabọ unu. Tẹme g'ọ tọ dụkwa iphe, ekoje buredi, aa-hụma l'alị unu. ");
INSERT INTO izz_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mbọku ono bẹ unu a-sụ ụnwu unu l'iphe, kparụ iphe, unu gude eme iya bụ iphe, Chipfu meru unu mbọku, unu lụfutaru l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","G'omelalị ono bụkwaru iphe-ọhubama, e byiru unu gẹ mbo l'ẹka; dee ya unu g'uri l'iphu; g'e gude nyatajẹru unu l'ekemu Chipfu bụ iphe, unu a-kpụjeru l'ọnu; kẹle ọo Chipfu ono gude ọkpehu iya dzọta unu l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Unu meje ekemu-a mẹ o -rwuẹpho teke emeje iya; apha g'apha. ");
INSERT INTO izz_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Chipfu -durwuchaẹpho unu alị Kénanu ono; bya anụ ẹya phọ unu g'o riburu iya unu lẹ nna unu oche phẹ lẹ nte; ");
INSERT INTO izz_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bụkwa g'unu nụje Chipfu iphe-mbụ, vukpọoru ụzo waa ẹkpa-nwa l'ẹpho ne iya. Anụ mbụ, bụ okee ya, vuru ụzo waa ẹkpa-nwa l'ẹpho ne iya l'iphe-edobe unu a-bụru kẹ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Iphe, bụ nkapfụ-ịgara, vuru ụzo waa ẹkpa nwa l'ẹpho ne iya bẹ unu e-gudeje nwatụru gbata. Ọ -bụru l'unu ta agbatadu iya agbata; unu aswịkwoo ya olu aswịkwo. Iphe, bụ ọkpara unu lẹ nwoke bẹ unu a-gbatajẹkwapho agbata. ");
INSERT INTO izz_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“O -be l'atatiphu; ụnwu unu -jịa unu sụ: ‘?Bụ gụnu bẹ eemedojeru iphe-a?’ Unu sụ phẹ: ‘Chipfu gude ọkpehu iya dufuta anyi l'alị ndu Ijiputu; mbụ dufuta anyi l'ẹka ono, anyi shi bụru ohu ono. ");
INSERT INTO izz_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lẹ teke Fero kpọ-chiru obu jịka lẹ ya ta ahadụ anyi g'anyi tụgbua bẹ Chipfu gbushiru ọkpara l'alị ndu Ijiputu; nemadzụ mẹ iphe-edobe. Noo iphe, meru g'o gude anyi nọdu akpụtaje anụ, bụ okee ya, vuru ụzo waa ẹkpa-nwa l'ẹpho ne iya; gbuaru Chipfu; bya egude iphe gbata ndu bụ ọkpara l'ẹpho ne phẹ lẹ nemadzụ.’ ");
INSERT INTO izz_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","G'omelalị ono bụkwaru iphe-ọhubama, e byiru unu gẹ mbo l'ẹka; dee ya unu g'uri l'iphu; gude goshi lẹ Chipfu gude ọkpehu iya dufuta unu l'alị Ijiputu.” ");
INSERT INTO izz_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Fero haẹpho ndu Ízurẹlu; ẹphe tụgbua; ọphu Chipfu eduduru phẹ shia ụzo alị ndu Filisitayinu; a makwarụ-a l'ono bẹ ka ntse. Noo kẹle Chipfu sụru: “?A maru ?ẹphe -vubaa ọgu bẹ ẹphe ta agbanwedu nụ egomunggo; lashịa azụ l'alị Ijiputu?” ");
INSERT INTO izz_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ọo ya bụ; Chipfu duru ndu Ízurẹlu gbaa mgburugburu; shia ụzo echiẹgu l'ibe iya k'ụzo Eze-ẹnyimu Uswe-uswe. Ndu Ízurẹlu ono shi l'alị Ijiputu wụru tụgbua; kwakọbe onwophẹ k'ọgu. ");
INSERT INTO izz_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mósisu bya achịta ọkpu Jiósẹfu gude; noo kẹle Jiósẹfu meru ụnwu Ízurẹlu; ẹphe riaru iya nte l'ẹphe e-me nno. Ọ sụru: “Mu maru lẹ Chileke be e-mechaa bya eyeru unu ẹka. Ọle g'unu chịtakwa ọkpu mu l'ẹka-a mẹ unu tụgbushia.” ");
INSERT INTO izz_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ẹphe wụfuta lẹ Sukọtu; je akpọbe ụlo-ẹkwa phẹ lẹ Etamu l'agụga echiẹgu. ");
INSERT INTO izz_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","O -rwua l'eswe; Chipfu egude urwukpu, kpụru oronmono edu phẹ ụzo. O -rwua l'ẹnyashi l'ọ nwụberu phẹ ọku, kpụru oronmono g'ẹphe gude hụma ìphóró; k'ọphu ẹphe a-nọduje eje ije: eswe l'ẹnyashi. ");
INSERT INTO izz_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Urwukpu ono, kpụru oronmono ono, oogudeje edu phẹ l'eswe; waa ọku ono, kpụru oronmono ono, oogudeje edu phẹ l'ẹnyashi ta alụfujedu alụfu l'atatiphu ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ọo ya bụ; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Pfuaru ndu Ízurẹlu g'ẹphe laphu azụ je akpọbe ụlo-ẹkwa phẹ lẹ mgboru mkpụkpu Pi-Hahirọtu, nọ lẹ mgbaka mkpụkpu Mịgudolu yẹe eze-ẹnyimu. Ẹphe akpọbe ụlo-ẹkwa phẹ ono l'agụga eze-ẹnyimu; g'ọ gha iphu lẹ mkpụkpu Belu-Zefọnu nhamụnha. ");
INSERT INTO izz_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ọo ya bụ lẹ Fero a-sụ l'unubẹ ndu Ízurẹlu nmawaru l'agaga; l'unu kwawaru l'echiẹgu. ");
INSERT INTO izz_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mu a-kpọ-chia Fero obu; l'ọ chịpfuru phẹ. Obenu l'ee-shi l'iphe, a-nwụ l'ẹhu Fero; yẹe ndu ojọgu iya; kwabẹ mu ùbvù. Ọo ya bụ; ndu Ijiputu amaru l'ọo mbẹdua bụ Chipfu.” Noo ya; ndu Ízurẹlu mee nno. ");
INSERT INTO izz_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","A bya epfuaru eze ndu Ijiputu lẹ ndu Ízurẹlu gbalaakwarụ; Fero yẹe ndu-ozi iya gbanwee obu phẹ l'ẹka ẹphe nọ; sụ: “?Bụ gụnu bẹ anyi meru ẹgube-a? ?Anyi gbẹ haa ndu Ízurẹlu g'ẹphe tụgbua parụ ozi, ẹphe eje haa?” ");
INSERT INTO izz_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ọo ya bụ; a bya edoziaru Fero ụgbo-ịnya iya ree; o duta ndu ojọgu yeru onwiya. ");
INSERT INTO izz_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ọ chịta ụgbo-ịnya, kachaa ree ụnu l'ụkporo iri; mẹwaro ụgbo-ịnya Ijiputu g'ọ hakọta. Ọ byakwaphọ eworu ndu-ishi ojọgu yegbachaa l'ụgbo-ịnya ono. ");
INSERT INTO izz_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Chipfu kpọ-chia obu Fero, bụ eze ndu Ijiputu; ọ chịpyabe ndu Ízurẹlu g'ẹphe azọ garamu garamu; awụfu. ");
INSERT INTO izz_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ịnya Fero l'ophu; waa ụgbo-ịnya iya; waa ndu agba l'ịnya; waa ikpoto ndu ojọgu iya; mbụ ndu Ijiputu l'ophu chịpyabe ndu Ízurẹlu bya agbapfu phẹ l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ l'agụgu eze-ẹnyimu; lẹ mgboru Pi-Hahirọtu, gharu iphu lẹ Belu-Zefọnu nhamụnha. ");
INSERT INTO izz_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Fero nọdu akpịritaru ntse; ndu Ízurẹlu palia ẹnya imeli; ọ bụwaru ndu Ijiputu bẹ etso phẹ nụ. Ndzụ rwuta phẹ; ẹphe bya araku Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ẹphe sụ Mósisu: “?Bụ l'ilu ta adụdu l'alị Ijiputu meru g'o gude i dufuta anyi g'anyi bya anwụshihu l'echiẹgu? ?Bụnua gụnu meru; g'o gude i dufuta anyi l'alị Ijiputu? ");
INSERT INTO izz_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","?Anyi ta asụduru ngu l'alị Ijiputu g'ị parụ anyi haa; g'anyi jerurọ ndu Ijiputu ozi? ?Togọ kadụru anyi mma l'anyi ejeru ndu Ijiputu ozi; eme l'anyi nwụshihuru l'echiẹgu?” ");
INSERT INTO izz_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mósisu sụ phẹ: “Gẹ ndzụ ba agụshi unu! Unu pfụru pfụshia ike; g'unu ahụma iphe, Chipfu e-me gude dzọta unu ntanụ-a. Ndu Ijiputu ono, unu ele ẹnya ntanụ-a bẹ unu ta ahụmabaekwa ọzo. ");
INSERT INTO izz_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Unu nọdu nggujingguji; Lẹ Chipfu a-lwụ-chiru-a unu ọgu!” ");
INSERT INTO izz_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ọo ya bụ; Chipfu sụ Mósisu: “?Bụ gụnu bẹ ịiraku mu? Karụ ndu Ízurẹlu g'ẹphe tụgbua jeshia iphe, ẹphe eje. ");
INSERT INTO izz_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Wolia mgbọro ngu; maa l'eze-ẹnyimu ono g'o kekaha mini ono ẹbo; k'ọphu ndu Ízurẹlu e-gude ọkpa phẹ jee ije l'alị ọkponku l'ọma ẹnyimu ono; wụghaa. ");
INSERT INTO izz_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mu akpọ-chia obu ndu Ijiputu; k'ọphu ẹphe e-tsopyabẹ phẹ. Ọo ya bụ; l'e shi l'iphe, a-nwụru Fero; yẹe ndu ojọgu iya; waa ụgbo-ịnya iya; mẹ ndu agba l'ịnya; kwabẹ mụbe Chipfu ùbvù. ");
INSERT INTO izz_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ọo ya bụ gẹ ndu Ijiputu eshi nno maru lẹ mu bụ Chipfu; mbụ teke ee-shi l'iphe, a-nwụru Fero; yẹe ndu ojọgu iya; waa ụgbo-ịnya iya; mẹ ndu agba l'ịnya; kwabẹ mu ùbvù.” ");
INSERT INTO izz_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Noo ya; Ojozi Chileke, shi vuru ụzo edu ndu Ízurẹlu phọ bya atsụlaa azụ bya etsoaha phẹ etsotso. Urwukpu phọ, kpụru oronmono phọ bya eshikwaphọ l'atatiphu laa l'azụ; je anọdu phẹ l'okotazụ; ");
INSERT INTO izz_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","je anọkaha ndu ojọgu ndu Ijiputu; waa ndu Ízurẹlu. L'ẹnyashi ono mgburugburu bẹ urwukpu ono gbakọtaru ọchii l'ẹka lanụ bya acha ọku l'ẹka lanụ. Iphe ono mee; ọphu ọ dụdu ndu ọphu jekuberu nwibe phẹ ntse l'ẹnyashi ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tọbudu iya bụ; Mósisu bya amachịa ẹka iya l'eli eze-ẹnyimu ono. Ẹnyashi ono l'ophu bẹ Chipfu gude oke phẹrephere, shi l'ụzo ẹnyanwu-awawa ziphu eze-ẹnyimu ono azụ; ọ bya aghọo alị ọkponku. Mini ono kekaha ẹbo. ");
INSERT INTO izz_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ndu Ízurẹlu bya azọo ọkpa l'alị ọkponku gude wụghaa eze-ẹnyimu ono. Mini eze-ẹnyimu ono kpụa g'igbulọ; nọdu phẹ l'ẹkutara; waa l'ẹkicha teke ẹphe awụgha. ");
INSERT INTO izz_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ndu Ijiputu chịpyabe phẹ. Ịnya Fero; waa ụgbo-ịnya iya; waa ndu agba l'ịnya tụko tsoru phẹ wụba l'ime eze-ẹnyimu ono. ");
INSERT INTO izz_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","O -rwua l'ụzo nchi-abọhu; Chipfu shi l'ọku; waa l'urwukpu ono, kpụru oronmono ono lee ndu ojọgu ndu Ijiputu ẹnya; bya atụ phẹ ẹberebete. ");
INSERT INTO izz_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","O mee; ọkpa ụgbo-ịnya phẹ wata agbaphe mgburugburu; k'ọphu agbagba iya tsụahaaru phẹ l'ẹhu. Ndu Ijiputu sụ: “G'anyi halẹkwaa ndu-a; laphu azụ; kẹle ọ kwa Chipfu l'etso anyi ọgu l'iswi ẹhu phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ọo ya bụ; Chipfu sụ Mósisu g'ọ machịa ẹka maa l'eze-ẹnyimu ono gẹ mini ono bya asọ-kpute ndu Ijiputu; waa ụgbo-ịnya phẹ; waa ndu agba l'ịnya phẹ. ");
INSERT INTO izz_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mósisu bya amachịa ẹka; maa l'eze-ẹnyimu ono. O -rwua l'ụtsu; mini ono sọahaa g'o shi asọ. Ndu Ijiputu nọdu agba g'ẹphe nahụ mini ono; Chipfu zarụ phẹ ye l'eze-ẹnyimu ono. ");
INSERT INTO izz_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mini ono bya asọgbabe; rikọta ụgbo-ịnya ono; yẹe ndu agba l'ịnya. Mbụ lẹ ndu ojọgu Fero, chịpyaberu ndu Ízurẹlu chịa phẹ jasụ l'eze-ẹnyimu ono ta adụdu g'ọ ka mma l'ọo onye lanụ, lwarụ nụ. ");
INSERT INTO izz_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Obenu lẹ ndu Ízurẹlu jeru ije l'alị ọkponku ghaa eze-ẹnyimu ono. Mini eze-ẹnyimu ono kpụa g'igbulọ; nọdu phẹ l'ẹkutara; mẹ l'ẹkicha. ");
INSERT INTO izz_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mbọku ono bẹ Chipfu dzọtaru ndu Ízurẹlu l'ẹka ndu Ijiputu. Ndu Ízurẹlu hụma ndu Ijiputu g'ẹphe nwụshihuru dabyichaaru l'agụga mini. ");
INSERT INTO izz_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ndu Ízurẹlu hụma ike-ọkpu, Chipfu gude lwụ-kpee ndu Ijiputu; ẹphe tsụahaa Chipfu ebvu; bya ekweta nkiya; waa k'onye-ozi iya, bụ Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Noo ya; Mósisu; waa ndu Ízurẹlu gụa ebvu-a nụ Chipfu sụ: Mu a-gụ ebvu nụ Chipfu; kẹle o goshiwaru l'ọ parụ ẹka. Ịnya mẹ ndu agba iya nụ bẹ o nwuru ye l'eze-ẹnyimu. ");
INSERT INTO izz_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Chipfu bụ ọkpehu mu bya abụru onye mu agụ-ku l'ebvu. Ọ bụru yẹbedua bụ onye dzọtaru mu nụ. Ọo ya bụ Chileke mu; mu a-nọdu aja iya ajaja. Ọ bụru iya bụ Chileke nna mu; mu a-nọdu ekutse ẹpha iya. ");
INSERT INTO izz_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Chipfu bụ ojọgu. Ọo Chipfu bụ ẹpha iya. ");
INSERT INTO izz_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ụgbo-ịnya Fero yẹe ndu ojọgu iya bẹ o nwuru ye l'eze-ẹnyimu. Ndu kachaa ree lẹ ndu-ishi ụgbo-ịnya Fero bẹ mini riru lẹ Eze-ẹnyimu Uswe-uswe ");
INSERT INTO izz_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ogbumini riru phẹ; ẹphe bụru tụbukungu l'ọhu-mini gẹ mkpuma. ");
INSERT INTO izz_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ẹkutara gụbe Chipfu bẹ ọkpehu, dụ iya nụ dụ biribiri. Ẹkutara gụbe Chipfu bẹ gwerụ ndu ọhogu ngu uji. ");
INSERT INTO izz_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I gude ọdu-biribiri ngu, parụ ẹka kwatsushia ndu wụ-lihuru etso ngu opfu. Ị haa oke ẹhu-eghu ngu, enwu g'ọku; ọ bya etsua phẹ g'ọku, etsu ẹswa ọkponku. ");
INSERT INTO izz_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ọo unme bẹ i ziru l'imi; eze-ẹnyimu kọo obvudu. Utso ono pfụru rọo g'igbulọ. Ogbumini hụkoo l'ọhu eze-ẹnyimu. ");
INSERT INTO izz_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ndu ọhogu sụru: “Anyi a-chị phẹ ọso gude. Anyi a-kwa iphe phẹ l'ọkwata; kee; gude phẹ mee iphe, agụ anyi ẹgu ememe. Anyi a-mịta ogu-echi anyi; tụko phẹ gbushia.” ");
INSERT INTO izz_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Obenu l'ị tụru unme; eze-ẹnyimu tụko phẹ rigbushikọta. Ẹphe bụru tụbukungu l'eze-ẹnyimu g'ọta-njele. ");
INSERT INTO izz_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","?Dẹnu agwa, atụru gụbe Chipfu? ?Bụ onye dụ gẹ ngu? G'ị dụ-be nsọ bẹ dụ biribiri. G'ị dụ-be akpabiri dụkwapho ebvu. Iimeje iphe, dụgbaa biribiri. ");
INSERT INTO izz_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ẹkutara ngu bẹ ị machịru; mgboko bya atụko ndu ọhogu anyi lwee. ");
INSERT INTO izz_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ndu ị gbafụtaru bẹ ii-gude n-yemobu ngu; dua. Ọ bụru ẹka ono, i bu, dụ nsọ ono bẹ ii-gude ọkpehu ngu durwua phẹ. ");
INSERT INTO izz_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ọhamoha, nụmaru iya nụ bẹ ndzụ e-rwuta. Ndzụ e-rwuta ndu Filisitayinu. ");
INSERT INTO izz_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ndu-ishi ndu Edọmu bẹ meji a-tọfu. Ẹhu anmaa ndu-ishi Mówabu anmanma. Ndu Kénanu erwushihu. ");
INSERT INTO izz_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ndzụ-agụgu; waa ẹhu-anmanma e-gude phẹ. Ọ bụru ọkpehu, dụ ngu l'ẹkutara bẹ ii-gude mee g'ẹphe dabyichaaru gẹ mkpuma; gbiriri jasụ ndibe gụbe Chipfu wụghata; mbụ ndu ono, ị gbafụtaru l'ohu, ẹphe shi bụru ono. ");
INSERT INTO izz_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ii-dubata phẹ; bya eye phẹ l'eli úbvú nkengu; mbụ ẹka gụbe Chipfu họtaru g'ọ bụru ibe ngu; mbụ ụlo, dụ nsọ ọphu i gude ẹka ngu kpụa. ");
INSERT INTO izz_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ọo gụbe Chipfu a-bụru eze jasụ lẹ tuutuutuu lẹ mịimiimii. ");
INSERT INTO izz_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Teke ịnya Fero; waa ụgbo-ịnya iya; waa ndu agba l'ịnya bahụru l'eze-ẹnyimu ono bẹ Chipfu vutaru mini ono sọ-kpute phẹ. Obenu lẹ ndu Ízurẹlu jeru ije l'alị ọkponku ghaa eze-ẹnyimu ono. ");
INSERT INTO izz_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Noo ya; Miriyamu, nwanyị, epfuchiru Chileke, bụ nwune Erọnu bya ewota nkwa; ụnwanyi l'ophu wụ-tsoru iya; akụ nkwa bya ete iya etete. ");
INSERT INTO izz_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyamu nọdu agụru phẹ ebvu ono; asụje: Unu gụa ebvu nụ Chipfu; noo kẹle o goshiwaru l'ọ parụ ẹka. Ịnya yẹe ndu agba iya nụ bẹ o nwuru ye l'echi eze-ẹnyimu. ");
INSERT INTO izz_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Tọbudu iya bụ; Mósisu dua ndu Ízurẹlu gbẹ lẹ Eze-ẹnyimu Uswe-uswe duru phẹ bahụ l'echiẹgu Shuru. Ẹphe jee ije ujiku ẹto l'echiẹgu; ọphu ẹphe ahụmaduru mini. ");
INSERT INTO izz_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ẹphe rwua Mara; ọphu ẹphe adụdu ike ngụa mini iya; noo kẹle mini ono atsọ ilu. Noo iphe ono, kparụ iphe, a gụru ẹka ono Mara. ");
INSERT INTO izz_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ẹphe gụaharu Mósisu aphụ; sụ: “?Bụ gụnu bẹ anyi a-ngụ?” ");
INSERT INTO izz_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Noo ya; Mósisu raku Chipfu. Chipfu bya egoshi iya mkpirikpu oshi. O wota iya chie lẹ mini ono. Mini ono tsọahaa ụtso mini. Ọ kwa l'ẹka ono bẹ Chipfu tụru ekemu nụ phẹ; bya atọoru phẹ ọkpa iya. Ọ bụkwarupho l'ẹka ono bẹ ọ nọ hụa phẹ ama. ");
INSERT INTO izz_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Chipfu sụ phẹ: “Ọ -bụru l'unu ngabẹru nchị l'opfu mụbe Chipfu, bụ Chileke unu; bya eme iphe, pfụru ọto l'ẹnya mu; ọ -bụru l'unu anga nchị l'iphe, mu sụru g'unu meje; bya etsoẹpho iphe, mu tọru ọkpa sụ g'unu tsoje; bẹ ọ tọ dụdu ẹjo iphe-ememe ono, mu gude byapfuta ndu Ijiputu ono, mu bya egude byapfuta unu. Noo kẹle ọo mbẹdua bụ Chipfu onye emeje unu g'unu ka mma l'iphe-ememe.” ");
INSERT INTO izz_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","E mechaa; ẹphe bya ejerwua Elimu; ẹka ọgba-mini iri l'ẹbo nọ; waa upfu mpfụ ụkporo ẹto l'iri. Ẹphe bya akpọbe ụlo-ẹkwa phẹ lẹ mgboru mini ono. ");
INSERT INTO izz_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ndu Ízurẹlu g'ẹphe ha wụfu lẹ Elimu; bya erwua echiẹgu Sinu, nọ lẹ mgbaka Elimu yẹe úbvú Sayịnayi lẹ mbọku, ọnwa k'ẹbo dụ l'abalị iri l'ise g'ẹphe shichaẹpho l'alị ndu Ijiputu fụta. ");
INSERT INTO izz_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","G'ẹphe ha gụru aphụ kpua Mósisu yẹe Erọnu l'echiẹgu ono; ");
INSERT INTO izz_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","sụ phẹ: “Ọme Chipfu gude ẹka iya gbushia anyi l'alị Ijiputu; m'ẹhu akakwa anyi guu! Ẹka ono, anyi shi anọ-pheje ite-anụ mgburugburu; eriji ẹpho. Obenu l'unu chịfutaru anyi bya edobe l'echiẹgu l'ẹka-a g'unu kpọ-gbushia anyịbe igwe ọha-a l'ẹgu.” ");
INSERT INTO izz_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chipfu sụ Mósisu: “Mu e-shi l'imigwe dzeeru unu nri gẹ mini. Gẹ ndu Ízurẹlu lụfutaje mbọkumboku bya ekpota ọphu a-sụru phẹ eriri kẹ mbọku ono. Gẹ mu eshi ẹgube ono hụa phẹ ama; maru; ?ẹphe e-kweta-a meje iphe, mu tụru phẹ ekemu iya. ");
INSERT INTO izz_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","O -rwua lẹ mbọku k'ishii; ẹphe eshia nri ọphu ẹphe kpotaru. Mbọku ono bẹ ẹphe e-kpota iya g'ọ ha g'ọphu ẹphe ekpotajehawa mbọku ọzo ugbo labọ.” ");
INSERT INTO izz_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ọo ya bụ; Mósisu yẹe Erọnu sụ ndu Ízurẹlu g'ẹphe ha: “Ụzenyashi-a bẹ unu a-hụma l'ọo Chipfu bụ onye dufutaru unu l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","O -rwua l'ụtsu bẹ unu a-hụma ọdu-biribiri Chipfu; noo kẹle ọ nụmawaru aphụ, unu agụ ekpu iya. ?Bụ onye bẹ anyịbedua bụ; ọphu unu a-nọdu agụru anyi aphụ?” ");
INSERT INTO izz_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mósisu sụkwapho: “Unu a-maru l'ọ bụ Chipfu eviya. Ọo-nụ unu anụ, unu a-ta l'ụzenyashi-a; waa nri, a-sụru unu eriri l'ụtsu; noo kẹle ọ nụmawaru aphụ, unu gụru kpua ya. ?Bụ onye bẹ anyi bụ? Unu ta agụkwaru anyi aphụ; ọ kwa Chipfu bẹ unu agụru iya!” ");
INSERT INTO izz_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mósisu sụ Erọnu: “Sụ ndu Ízurẹlu g'ẹphe ha; g'ẹphe tụko bya l'atatiphu Chipfu. Kẹle ọ nụmawaru aphụ, ẹphe agụ.” ");
INSERT INTO izz_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Erọnu nọdukwadu epfu eyeru ndu Ízurẹlu g'ẹphe ha; ẹphe ghaa ẹnya l'echiẹgu; bya ahụma ọdu-biribiri Chipfu g'o nwuru kẹ phoo l'urwukpu ono, kpụru oronmono ono. ");
INSERT INTO izz_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mu nụmawaru aphụ, ndu Ízurẹlu agụ. Pfuaru phẹ l'ẹphe a-ta anụ lẹ nchi-ejihu. O -rwua l'ụtsu l'e gude nri zụ-jia phẹ ẹpho. Ọo ya bụ g'ẹphe amaru l'ọo mbẹdua bụ Chipfu, bụ Chileke phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","O -rwua l'ụzenyashi ono; ọ̀kwà bya atụko ẹka ẹphe kpọberu ụlo-ẹkwa phẹ dzuru. A fụtashia l'ụtsu; iji kwashịwaa ike; kwaphee ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Iji ono phosahuẹpho; o nweru nwa iphe, wụshiru l'alị l'echiẹgu ono, dụgbaa yẹgeyege; bya adụ g'iji, oyi meru; ọ hụko ahụko. ");
INSERT INTO izz_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ndu Ízurẹlu hụmae ya phọ; ẹphe sụ nwibe phẹ: “?Bụ gụnu baa?” Noo kẹle ẹphe te eshidu maru iphe ọbu. Mósisu sụ phẹ: “Ọo nri, Chipfu nụru unu g'unu ria. ");
INSERT INTO izz_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Waa ekemu, Chipfu tụru baa: ‘G'onyenọnu kpotajẹ ọphu a-sụru iya eriri. Ndu bu l'ụlo-ẹkwa unu bẹ unu e-kpotajẹru ogbongu lanụ ogbongu lanụ.’ ” ");
INSERT INTO izz_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ndu Ízurẹlu mee g'e pfuru phẹ. O nweru ndu ọphu kpotaru shii; o nweru ndu ọphu kpotaru nwanshịi. ");
INSERT INTO izz_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E mechaa; ẹphe gude ogbongu gbaa ya; ọphu ndu kpotaru shii; ekpotanụkaduru; ọphu ndu kpotaru nwanshịi; ekpopeteduru. Onyenọnu kpotaẹrupho ọphu sụru iya nụ. ");
INSERT INTO izz_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mósisu sụ phẹ: “G'o to nwekwa onye e-dobe nkiya g'ọ fụta l'ụtsu.” ");
INSERT INTO izz_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ọle o nwelẹru-a ndu ọphu angabẹduru Mósisu nchị, haphodoru nkephẹ dobe; ọ nọdu fụta l'ụtsu. A fụtashia l'ụtsu; ẹka jiwa iya ejiji; tẹme ọ nọdu eshiakwaphọ ishi. Ẹhu-eghu iphe ono, ẹphe meru ono ghuahaa Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ụtsu mbọkumboku; onyenọnu ekpota ọphu a-sụru yẹe ndibe iya eriri. Teke anwụ chishijeẹru phọ ike; ọphu phọduru l'alị azashịhu. ");
INSERT INTO izz_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","O -rwua mbọku k'ishii; ẹphe kpota ọphu ha g'ọphu ẹphe ekpotajẹ mgbo labọ. Ogbongu labọ bẹ ẹphe kpotaru onye lanụ. Ndu-ishi ndu Ízurẹlu bya epfuaru iya Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ọ sụ phẹ: “Waa ekemu, Chipfu tụru baa: ‘Echele bụ eswe Sabatụ; mbụ eswe-atụta-unme, dụ nsọ kẹ Chipfu. Ọo ya bụ; unu ghee iphe, dụ unu k'egheghe; shia, iphe dụ unu k'eshishi ntanụ-a. Unu edobe ọphu ghuduru nụ jasụ l'ụtsu.’ ” ");
INSERT INTO izz_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ẹphe haa ya; ọ bọo nchi, bụ iphe, Mósisu pfuru; ọphu o shiduru ishi; ọphu ẹ̀kà aladụru iya. ");
INSERT INTO izz_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mósisu sụ phẹ: “Unu ria ono ntanụ-a! Noo kẹle ntanụ-a bụ eswe-atụta-unme kẹ Chipfu; ọphu ọ tọ dụdu nri, unu a-hụma l'etezi ntanụ-a. ");
INSERT INTO izz_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Unu e-kpotajẹ nri ono ujiku ishii; ọle o -rwua mbọku k'ẹsaa, bụ eswe-atụta-unme bẹ ọ tọo dụdu.” ");
INSERT INTO izz_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ọle o nwelẹru-a ndu tụgburu lẹ mbọchi k'ẹsaa jeshia ekpota nri; obenu l'o to nwedu ọphu ẹphe hụmaru. ");
INSERT INTO izz_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Chipfu sụ Mósisu: “?Bụ teke ole bẹ unu a-jịkaberu eme ekemu mu; waa opfu mu? ");
INSERT INTO izz_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nyatakwa l'ọo Chipfu bẹ nụru unu eswe-atụta-unme. Noo iphe, meru g'o gude ọ nọdu abụjeru: o -rwua mbọku k'ishii; l'ọ nụ unu nri, a-sụru unu ujiku ẹbo. O -rwua mbọku k'ẹsaa; g'onyemonye nọdujeepho l'ẹka ọ nọ. G'o to nweshiru onye a-lụfuje alụfu.” ");
INSERT INTO izz_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ọo ya bụ; ndu ono dzua ike lẹ mbọku k'ẹsaa. ");
INSERT INTO izz_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ndu Ízurẹlu kua nri ono mana. Ọocha ụcha g'akpụru koriyanda; tẹme ọ nọdu atsọje g'ẹcha mbekee, e gude manụ-ẹnwu mee. ");
INSERT INTO izz_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mósisu sụ: “Wakwa iphe, Chipfu epfu baa: ‘Unu kpota ogbongu mana lanụ doberu ọgbo ọphu nọ l'iphu. Ọo ya bụ g'ẹphe ahụma nri, mu nụru unu; unu ria l'echiẹgu; teke mu dufutaru unu l'alị Ijiputu.’ ” ");
INSERT INTO izz_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ọo ya bụ; Mósisu sụ Erọnu: “Wota ite; kporu ogbongu mana lanụ ye iya. Dobe iya l'atatiphu Chipfu; g'e doberu iya ọgbo ọphu nọ l'iphu.” ");
INSERT INTO izz_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Erọnu woru iya dobe l'atatiphu okpoko ono, e yeru ẹkwo ekemu Chipfu ono; k'ọphu ee-dobe iya; gẹ Chipfu pfuru Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ndu Ízurẹlu ria mana ụkporo apha labọ; gbiriri jasụ ẹphe jerwua alị ẹka e bu ebubu. Mbụ l'ẹphe riru mana gbiriri jasụ ẹphe rwua l'oke alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ogbongu lanụ bụ oke-lanụ-l'ụzo-iri l'iphe, jiru nkwẹka. ");
INSERT INTO izz_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ndu Ízurẹlu g'ẹphe ha bya wulihu l'echiẹgu Sinu tụgbua; ẹphe -gbẹ l'ibe iya ọphuu; ẹphe abahụ l'ibe iya ọphuu; ọ bụerupho gẹ Chipfu ziru phẹ bụ gẹ ẹphe eje iya. Ẹphe je akpọbe ụlo-ẹkwa phẹ lẹ Refidimu. Obenu lẹ mini, ẹphe a-ngụ ta adụdu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ọo ya bụ; ẹphe baaharụ Mósisu mba sụ: “Nụ anyi mini g'anyi ngụa!” Mósisu sụ: “?Bụ gụnu bẹ unu abarụ mu mba? ?Bụ gụnu kparụ iphe unu ahụ Chipfu ama?” ");
INSERT INTO izz_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Obenu lẹ ndu Ízurẹlu bẹ ẹgu mini agụshi ike; ẹphe nọdu agụru Mósisu aphụ; sụ: “?Bụnua gụnu kparụ iphe i dufutaru anyi; waa ụnwu anyi; waa iphe-edobe anyi l'alị Ijiputu bya edobe g'ẹgu mini gbushia?” ");
INSERT INTO izz_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ọo ya bụ; Mósisu raku Chipfu sụ: “?Dẹnu gẹ mu e-me ndu-a? Ẹphe a-byaakwa mu atụ-gbu lẹ mkpuma.” ");
INSERT INTO izz_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Chipfu sụ Mósisu: “Vuta ụzo gẹ ndu Ízurẹlu tso ngu l'azụ. L'ị harụ ndu bụ ọgerenya Ízurẹlu duta; l'i wota mgbọro ono, i chiru l'ẹnyimu Nayịlu ono gude jeshia. ");
INSERT INTO izz_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mu a-pfụru ngu l'atatiphu lẹ mkpuma Horẹbu. I -rwua ẹka ono; chia mgbọro ngu lẹ mkpuma ono. Mini, ndu Ízurẹlu a-ngụ e-shi iya lwashịhu.” Mósisu bya emee nno l'atatiphu ndu bụ ọgerenya ndu Ízurẹlu ono. ");
INSERT INTO izz_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ọ bya agụa ẹka ono “Masa”; gụkwaa ya phọ “Meriba”; noo kẹle ndu Ízurẹlu barụ mba; bya ahụa Chipfu ama; sụ: “?Chipfu nọa l'echilabọ anyi tọo tọ nọdu iya?” ");
INSERT INTO izz_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ndu Amalẹku bya etso ndu Ízurẹlu ọgu lẹ Refidimu. ");
INSERT INTO izz_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mósisu sụ Jioshuwa: “Harụ unwoke anyi họta g'unu je awọta ndu Amalẹku ọgu. Echele bẹ mu e-gude mgbọro Chipfu l'ẹka je apfụru l'eli úbvú.” ");
INSERT INTO izz_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ọo ya bụ; Jioshuwa bya awọta ndu Amalẹku ọgu, dụ gẹ Mósisu ziru iya. Mósisu; waa Erọnu; waa Huru bya enyihu eli úbvú; je anọdu lẹ mkpakpọnu iya. ");
INSERT INTO izz_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ọ nọdu abụjeru; Mósisu -chiliẹpho ẹka imeli; ndu Ízurẹlu alwụ-kpeahaa. Teke ọ chizetaru ẹka; ndu Amalẹku alwụ-kpeahaa. ");
INSERT INTO izz_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","A nọnyaa; ẹka tsụhu Mósisu mẹe; ẹphe pata mkpuma; bya edoberu iya; ọ nọdu anọo. Erọnu; waa Huru bya apalia ya ẹka imeli; onye lanụ l'ẹkutara; onye ọphuu l'ẹkicha. Ọo ya bụ; ẹka nọdue ya phọ l'imeli ẹgube ono gbiriri jasụ nchi jihu. ");
INSERT INTO izz_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ọo ya bụ; Jioshuwa phẹ lwụ-kpee ndu Amalẹku. ");
INSERT INTO izz_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Noo ya; Chipfu sụ Mósisu: “Dee iphe-a l'ẹkwo g'o bụru iphe, ee-gudeje nyata iya. Tẹme l'i mekwaaphọ gẹ Jioshuwa nụma lẹ mu e-me gẹ ndu Amalẹku chịhu lẹ mgboko; g'a ta nyatabahẹ phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mósisu bya akpụa ọru-ngwẹja; bya agụa ya “Ọ kwa Chipfu bụ onye emeje g'ẹka mu kangoo l'ọgu”. ");
INSERT INTO izz_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ọ sụ: “Iphe, meru iphe, mu gụru iya nno bụ l'a chị-liru ẹka pfuru nụ Chipfu l'aba-eze iya. Chipfu a-nọduepho etso ndu Amalẹku ọgu; e -shi l'ọgbo sweru ọgbo.” ");
INSERT INTO izz_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Noo ya; Jieturo, onye uke ndu Midiyanu, bụkwapho nna nyee Mósisu; bya anụmakota iphemiphe, Chileke mekọtaru Mósisu waa ndu nkiya, bụ Ízurẹlu; tẹme waa gẹ Chipfu gude dufuta ndu Ízurẹlu l'alị ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Teke Mósisu dutaru nyee ya, bụ Zipora dulaa ibe Jieturo, bụ nna nyee ya ono; bẹ Jieturo ono nabataru nyee Mósisu ọbu; ");
INSERT INTO izz_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","waa ụnwu iya unwoke labọ. Onye lanụ bẹ ẹpha iya bụ Geshọmu; noo kẹle Mósisu sụru: “Mu bụ onye lwarụ alwalwa l'alị ndu ọhozo.” ");
INSERT INTO izz_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ẹpha onye ọphuu bụru Eliyéza; noo kẹle ọ sụru: “Ọo Chileke nna mu bụ onye yeru mu ẹka. Ọ dzọtaru mu gẹ Fero te egbu mu.” ");
INSERT INTO izz_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jieturo, bụ nna nyee Mósisu duru ụnwu Mósisu; waa nyee Mósisu ọbu byapfuta iya l'echiẹgu l'ẹka ọ kpọberu ụlo-ẹkwa lẹ mgboru úbvú Chileke. ");
INSERT INTO izz_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jieturo zihawaru g'e je asụ iya: “Mụbe Jieturo, bụ nna nyee ngu bẹ dukwa nyee ngu; waa ụnwegirima ibe ngu abya.” ");
INSERT INTO izz_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ọo ya bụ; Mósisu gba iya ndzuta bya ephozeru iya ishi; bya anma iya akpa. Ẹphe kelechaa; bya bahụ l'ụlo-ẹkwa Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mósisu kọkotaru nna nyee ya ono iphemiphe, Chipfu meru Fero waa ndu Ijiputu l'iswi ẹhu ndu Ízurẹlu; tẹme waa iphe-ẹhuka, ẹphe jekọtaru l'ụzo; waa gẹ Chipfu gude dzọta phẹ. ");
INSERT INTO izz_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ẹhu tsọo Jieturo ụtso g'ọ nụmaru k'iphe, dụ ree, Chipfu mekọtaru Ízurẹlu; dzọta phẹ l'ẹka ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ọ sụ: “G'ajaja bụru kẹ Chipfu, bụ onye nafụtaru ngu l'ẹka ndu Ijiputu; yẹle ẹka Fero; mbụ onye nafụtaru ndu Ízurẹlu l'ẹka ndu Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nta-a bẹ mu maru lẹ Chipfu bẹ kakọta agwa l'ophu shii. Noo kẹle ọo ndu nmarụ ndu Ízurẹlu phulaphula bẹ o meru iphe-a.” ");
INSERT INTO izz_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Noo ya; Jieturo, bụ nna nyee Mósisu bya egweeru Chipfu ngwẹja-akpọ-ọku; gwekwaarụ iya phọ ngwẹja ọzowaro. Erọnu duta ndu bụ ọgerenya Ízurẹlu bya g'ẹphe lẹ Jieturo ria nri l'atatiphu Chileke. ");
INSERT INTO izz_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","O -rwua nchitabọhu iya; Mósisu bya eje anọdu l'ẹka ọonoduje; kpeaharụ ndu Ízurẹlu ikpe. Ẹphe shi l'ụtsu nọ-phee ya mgburugburu jasụ l'ụzenyashi. ");
INSERT INTO izz_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nna nyee Mósisu bya ahụma iphe, Mósisu emeru ndu Ízurẹlu; ọ sụ: “?Bụ gụnu bẹ iimeru ndu Ízurẹlu ẹgube ono? ?Bụ gụnu kparụ iphe, ọ bụ gụbedua nwẹkinyi ngu a-nọduje ekperu ndu ono ikpe; kẹ g'ẹphe shije l'ụtsu nọ-phee ngu mgburugburu jasụ l'ụzenyashi?” ");
INSERT INTO izz_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mósisu sụ iya: “Ọ kwa phẹ abyajẹ mu akpata ishi iphe, bụ uche Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Teke ọ bụ l'ọo opfu adaru phẹ; ẹphe ewotaru mu iya; mu edoshiaru phẹ iya; bya akaru phẹ iphe, Chipfu tọru ọkpa sụ g'e tsoje; waa ekemu iya.” ");
INSERT INTO izz_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nna nyee Mósisu sụ iya: “Iphe, iime ta adụdu ree. ");
INSERT INTO izz_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ọo egbugbu bẹ gụbedua; waa ndu ono, awụ-pfutajẹ ngu nụ ono egbu onwunu. Ozi ono kariru ngu ẹka; i tii jekọtadu iya nwẹkinyi ngu. ");
INSERT INTO izz_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ngabẹ nchị gẹ mu kpọ-ziaru ngu ụzo g'ii-meje iya. Gẹ Chipfu swikwaru ngu. Ọo gụbedua a-nọchi ẹnya ndu-a l'atatiphu Chileke. Ii-wotajẹ iphe, adaru phẹ nụ dooru iya. ");
INSERT INTO izz_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Zia phẹ iphe, Chipfu tọru ọkpa sụ g'e tsoje; waa ekemu iya; bya egoshi phẹ ụzo, ẹphe e-tsoru; waa iphe, gbaru phẹ l'ememe. ");
INSERT INTO izz_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","L'ị bya eshi l'ime ndu Ízurẹlu g'ẹphe ha họta ndu ike dụ; mbụ ndu atsụ Chileke ebvu, bụ ndu e gude ire phẹ ẹka; bya abụru ndu te eridu ụphalazu. Họta phẹ g'ẹphe bụru ndu-ishi ụnu ụmadzu labọ l'ụkporo iri iri; waa ndu-ishi ụmadzu ụkporo ise ise; waa ndu-ishi ụmadzu ụkporo ẹbo l'iri iri; tẹme waa ndu-ishi ụmadzu iri iri. ");
INSERT INTO izz_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Họta phẹ g'ẹphe doshikọtajeru ndu Ízurẹlu opfu tekenteke. Ọle g'ẹphe wotajẹru ngu opfu ọphu shihuru ike. Ẹphe edoshije opfu ọphu dụ nphe nwẹka phẹ. Ono e-me g'ivu ngu ka nphe; noo kẹle unu l'ẹphe tụkoru evu iya. ");
INSERT INTO izz_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","I -mee ya nno; ọ -bụru uche Chileke; bẹ ịi-dụkwa ike vua ivu-ẹrwa ono; tẹme ndu ono -nọdu ala unuphu; ẹphe egude ẹhu-ụtso ala.” ");
INSERT INTO izz_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mósisu ngabẹru nna nyee ya ono nchị; bya emekọta iphemiphe, o pfuru. ");
INSERT INTO izz_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ọ bya ahọta ndu ọkpehu dụ l'echilabọ Ízurẹlu l'ophu; bya emee phẹ ndu-ishi ndu dụ ụnu labọ l'ụkporo iri iri; waa ndu-ishi ndu dụ ụkporo ise ise; waa ndu-ishi ndu dụ ụkporo ẹbo l'iri iri; tẹme waa ndu-ishi ndu dụ iri iri. ");
INSERT INTO izz_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ẹphe nọdu anọduje edoshikọtaru ndu Ízurẹlu opfu. Opfu ọphu shihuru ike bẹ ẹphe ewotajẹru Mósisu. Opfu ọphu dụ nphe bẹ ẹphe edoshije nwẹka phẹ. ");
INSERT INTO izz_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Noo ya; Mósisu haa nna nyee ya ono; ọ lashịa alị iya. ");
INSERT INTO izz_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","O be mbọku, kwe ndu Ízurẹlu ọnwa ẹto gẹdegede, ẹphe wụfuru l'alị Ijiputu; ẹphe byarwuta echiẹgu Sayịnayi. ");
INSERT INTO izz_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ẹphe shi lẹ Refidimu bya erwua echiẹgu Sayịnayi, bya akpọbe ụlo-ẹkwa phẹ l'ẹka ono l'ọkpa úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mósisu nyihu eli úbvú ono nyipfu Chileke. Chipfu bya agbẹ l'úbvú ono kua ya sụ: “Waa iphe, ii-zi ndu ọnu-ụlo Jiékọpu baa; mbụ iphe, ii-pfuru ndu Ízurẹlu: ");
INSERT INTO izz_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Unubẹdua l'onwunu hụmaru iphe, mu meru ndu Ijiputu; waa gẹ mu gude hee unu g'ugo, he nwa iya; hepfuta onwomu. ");
INSERT INTO izz_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ọ -bụru l'unu ngabẹru mu nchị; bya edobe ọgbandzu mu bẹ unu a-bụru okiphe, dụru mu iche l'echilabọ ọhamoha. A makwarụ-a lẹ mgboko l'ophu bụ nkemu; ");
INSERT INTO izz_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ọle unu a-bụru mu alị-eze ndu-uke; waa ọha, dụ nsọ.’ Noo iphe, ii-pfuru ndu Ízurẹlu bụ ono.” ");
INSERT INTO izz_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ọo ya bụ: Mósisu bya alaphu azụ; bya ekukọo ndu bụ ọgerenya ndu Ízurẹlu; bya atụko iphemiphe ono, Chipfu ziru iya g'o pfua ono; pfukọtaru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ndu Ízurẹlu tụko zụ̀a mgbede sụ: “Iphemiphe, Chipfu pfuru bẹ anyi e-mekọta.” Ọo ya bụ; Mósisu bya egude ọnu, ẹphe yeru jepfu Chipfu ọzo. ");
INSERT INTO izz_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Chipfu sụ Mósisu: “Mu a-nọdu l'urwukpu, jihuru kpakpalu byapfuta ngu; k'ọphu ndu Ízurẹlu a-nọdu anụ ẹka mu epfu eyeru ngu; g'ẹphe a-chịru ụpfu kwẹwaro l'ẹka ị nọ.” Ọo ya bụ; Mósisu bya epfuaru Chipfu ọnu, ẹphe yeru. ");
INSERT INTO izz_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Chipfu sụ Mósisu: “Jepfu ndu Ízurẹlu je edoo phẹ nsọ ntanụ-a; waa echele. G'ị pfuaru phẹ g'ẹphe saa uwe phẹ asasa. ");
INSERT INTO izz_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","O -rwutashịa mbọku k'ẹto; g'ẹphe kwakọbe-ghewa; noo kẹle mbọku ono bẹ Chipfu e-nyizeta bya anọdu l'úbvú Sayịnayi; ndu Ízurẹlu ahụmakota iya g'ẹphe ha. ");
INSERT INTO izz_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kpaarụ phẹ oke l'úbvú ono mgburugburu. Pfuaru phẹ g'ẹphe letakwa ẹnya g'ọkpa phẹ te jekubekwa mgboru úbvú ono ejekube; ọphu ọ bụro k'enyihu iya enyihu. Onye ẹhu iya rwutaru l'úbvú ono bẹ ee-gbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","G'a tụgbua ya lẹ mkpuma; ọzo gbagbua ya l'apfụ; g'e te denyikwa iya ẹka. Ọ -bụ nemadzụ; ọzoo anụ; g'e te kwekwa g'ọ nọdu ndzụ. Ọ bụepho teke a nọnyaru; e gbua opu bẹ ẹphe e-bebe jekube úbvú ọbu.” ");
INSERT INTO izz_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mósisu shichaẹpho l'eli úbvú ono nyizeta byapfuta ndu Ízurẹlu. Ọ bya edoo phẹ nsọ g'ẹphe dụru Chileke iche; ẹphe bya asashịa uwe phẹ. ");
INSERT INTO izz_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ọ sụ phẹ: “O -rwutashịa mbọku k'ẹto; unu kwakọbechaakwa onwunu! Unu hakwaa ejepfu nwanyị!” ");
INSERT INTO izz_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","O belephọ l'ụtsu mbọku k'ẹto ono; ebemu-igwe wata akụ kẹ phoophoophoo; egbigwe nọdu ada; tẹme urwukpu, jihuru kpakpalu sọ-kputa eli úbvú ono. Opu, adashị ọda ike shi l'úbvú ono ada. Onyemonye, nọ l'ụlo-ẹkwa iya phụhu kẹ kpaakpaakpaa. ");
INSERT INTO izz_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mósisu bya edufuta phẹ l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ g'o duru phẹ byapfuta Chileke. Ẹphe bya tụko pfụru l'ọkpa úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ẹnwuru-ọku tụko úbvú Sayịnayi sweta; noo kẹle Chipfu gude ọku nyizeta l'úbvú Sayịnayi ono. Ẹnwuru-ọku ono nọdu akpụ kẹ tụutuutuu zelihu g'ẹnwuru shi l'ọku, enwu phoophoophoo. Úbvú ono l'ophu nọdu anmakọta jiijiijii ẹhuka ẹhuka. ");
INSERT INTO izz_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ọda opu ono nọdu aka shii eje. Mósisu nọdu epfu opfu; a nọdu anụkwapho olu Chileke ẹka oopfu eyeru Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ọ bụru iya bụ lẹ Chipfu enyizeta l'eli úbvú Sayịnayi; bya ekua Mósisu g'o nyipfuta iya lẹ mkpakpọnu úbvú ono. Mósisu nyihu eli úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Chipfu sụ iya: “Nyizeta l'alị je anmaaru ndu Ízurẹlu ọkwa g'ẹphe ta akpahẹ ụzo g'ẹphe hụma Chipfu; ọdumeka bẹ ẹphe a-dụkwa igwerigwe laa l'iyi. ");
INSERT INTO izz_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Mbụkponu ndu-uke, eme g'ẹphe byakube mụbe Chipfu ntse bẹ e-do onwophẹ nsọ g'ẹphe dụru mu iche; ọdumeka mu anụa phẹ aphụ.” ");
INSERT INTO izz_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mósisu sụ Chipfu: “Ndu Ízurẹlu te enyitakwa úbvú Sayịnayi; noo kẹle ị tụru anyi ekemu sụ g'anyi dobe úbvú ono nsọ; tẹme anyi akpaa ya oke gbaphee mgburugburu.” ");
INSERT INTO izz_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Chipfu sụ: “Nyizeta l'alị je eduta Erọnu g'unu l'iya swịru. Ọle gẹ ndu-uke; waa ndu Ízurẹlu ọphu ta akpaghatakwa oke ono byapfuta mụbe Chipfu; ọdumeka bẹ mu a-nụkwa phẹ aphụ.” ");
INSERT INTO izz_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mósisu nyizeta bya epfuaru ndu Ízurẹlu iphe, Chipfu pfuru. ");
INSERT INTO izz_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Chipfu bya epfukọta iphemiphe-a; sụ: ");
INSERT INTO izz_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ọo mbẹdua bụ Chipfu, bụ Chileke unu, bụ onye dufutaru unu l'alị Ijiputu; mbụ alị ẹka ono, unu shi bụru ohu ono. ");
INSERT INTO izz_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Unu ta adụkwa iphe, unu a-bajẹru ẹja; gbahaa mụbe Chileke kpụrumu. ");
INSERT INTO izz_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Unu te emetakwaru onwunu ntẹkpe, e meru; o yee iphe, nọ l'imigwe; ọzoo iphe, nọ lẹ mgboko-a; mẹ iphe, bu lẹ mini-ime-alị. ");
INSERT INTO izz_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Unu ta abajẹkwaru phẹ ẹja; ọphu unu ejejekwaru phẹ ozi. Noo kẹle mụbe Chipfu, bụ Chileke unu eko okophoo. Mu nọdu anụje ndu mu dụ ashị aphụ k'iphe, dụ ẹji, ẹphe meru mu; gude iya nụa ụnwu phẹ aphụ; mẹ ụnwu nwanwa phẹ; mẹ ụnwu nwanwanwaranwa phẹ. ");
INSERT INTO izz_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Obenu l'iphe, bụkpoo ndu yeru mu obu bya emeje iphe, mu pfuru bẹ mu emejekwanụ gẹ n-yemobu mu bụru o-je-lẹ-nwanwa l'ẹhu phẹ. ");
INSERT INTO izz_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Unu te ekujekwa ẹpha mụbe Chipfu, bụ Chileke unu l'ụzo, apfụduru-ọto. Noo kẹle mụbe Chipfu ta ahakwa ndu eme nno; gẹ mu ta nụ phẹ aphụ. ");
INSERT INTO izz_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Unu nyatajẹ mee mbọku Sabatụ, bụ eswe-atụta-unme g'ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ọo ujiku ishii bẹ unu e-seje akanya; jekọta ozi unu; ");
INSERT INTO izz_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Obenu lẹ mbọku k'ẹsaa bụ eswe atụta-unme kẹ Chipfu, bụ Chileke unu. G'ọ tọ dụkwa ozi, unu e-jeje mbọku onoya. Ọphu unu ekwekwa gẹ nwa unu; m'onye unu gbaru ohu; mẹ iphe-edobe unu; m'onye lwarụ alwalwa, bu l'ibe unu; jee ozi mbọku ono. ");
INSERT INTO izz_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Noo kẹle ọo ujiku ishii bẹ mụbe Chipfu meru igwe; bya emee eliphe; yẹe eze-ẹnyimu; mẹ iphemiphe, dụkota iya nụ. O be lẹ mbọku k'ẹsaa; mu tụta unme. Ọ bụru iphe ono kparụ iphe, mụbe Chipfu gọru ọnu-ọma nụ eswe-atụta-unme; bya emee ya; ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Unu kwabẹjekwa ne unu mẹ nna unu ùbvù. Ọo ya bụ g'unu enweru ndzụ ogologo; buru l'alị ono, Chipfu, bụ Chileke unu abya unu anụnu ono. ");
INSERT INTO izz_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Unu te egbujekwa ọchi. ");
INSERT INTO izz_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Unu te erijekwa ogori. ");
INSERT INTO izz_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Unu te ezijekwa iphuru. ");
INSERT INTO izz_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Unu ta adzụjekwa ụka kpua nemadzụ ibe unu. ");
INSERT INTO izz_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“G'ụlo nwibe unu; mẹ nyee ya; mẹ ohu, ọ gbatarụ agbata; mẹ iphe-edobe iya; mẹkpoo iphe, o nweru enweru g'ọ ha ta adụjekwa unu g'a sụ l'ọo unu nwe iya.” ");
INSERT INTO izz_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ndu Ízurẹlu hụmaepho egbigwe; waa ebemu; bya anụma opu; bya ahụma g'úbvú ono akpụshi ẹnwuru-ọku; ẹphe nmahụ kẹ rwuurwuu lẹ ndzụ-agụgu. Ẹphe pfụru ụzenya; ");
INSERT INTO izz_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","sụ Mósisu: “Pfujeru yeru anyi gụbedua; anyi a-ngabẹ-a nchị. Gẹ Chileke te epfuhẹkwa opfu yeru anyi l'onwiya; ọdumeka bẹ anyi a-nwụshihukwa.” ");
INSERT INTO izz_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mósisu sụ ndu Ízurẹlu: “Gẹ ndzụ ba agụshi unu. Chileke byaru g'ọ hụa unu ama; k'ọphu unu a-nọdu atsụje iya ebvu; haa eme iphe-ẹji.” ");
INSERT INTO izz_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ndu Ízurẹlu pfụru ụzenya; Mósisu bya ejekube ọchii ono ntse, bụ ẹka Chileke nọ. ");
INSERT INTO izz_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Chipfu sụ Mósisu: “Sụ ndu Ízurẹlu lẹ-a: Unu hụmawaru l'onwunu lẹ mu shi l'imigwe pfuru yeru unu. ");
INSERT INTO izz_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","G'ọ tọ dụkwa agwa, unu e-meta swikube mu. Unu te egudekwa mkpọla-ọchaa; ọzoo mkpọla-ododo meta agwa doberu onwunu. ");
INSERT INTO izz_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Ọ bụru ẹja, shi l'alị bẹ ee-gudeje kpụaru mu ọru-ngwẹja, bụ ẹka ee-gbuje atụru; waa eghu; waa eswi; gude gweeru mu ngwẹja-akpọ-ọku; waa ngwẹja-ẹhu-guu. Ẹkameka mu meru g'a nọduje; nyata ẹpha mu bẹ mu a-byapfutajẹ unu bya ekebe unu l'ọma. ");
INSERT INTO izz_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ọ -bụru l'unu gude mkpuma akpụru mu ọru-ngwẹja; unu te egudekwa mkpuma, a rwaru arwarwa. Noo kẹle unu -kụa ya ọngu bẹ unu tụrwuwaru iya. ");
INSERT INTO izz_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ọphu unu akpụkwa ọru-ngwẹja ono g'ọ dụ l'eli; tụa ya ocho k'ọphu ee-nyihuje iya enyihu; a nọnyaa; unu jịa onwunu uwele l'ọru-ngwẹja ono.” ");
INSERT INTO izz_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Waa ekemu, ii-zi phẹ baa: ");
INSERT INTO izz_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ọ -bụru l'ị gbaru onye Hiburu ohu bẹ iphe, oo-jeru ngu ozi bụ apha ishii. O -be l'apha k'ẹsaa l'o nweru onwiya; a taa pfụdu ụgwo l'ishi iya. ");
INSERT INTO izz_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Teke ọ bụ l'ọ swị nwẹkinyi iya teke ọ byaru; l'ọ laa nwẹkinyi iya. Ọ -bụkwanuru lẹ yẹe nyee ya swị teke ọobya; nyee ya ono etsoru iya mẹ ọ lashịa. ");
INSERT INTO izz_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Teke ọ bụ lẹ nnajịuphu iya lụtaru iya nwanyị; ọ nwụtaru iya ụnwegirima; nyee ya ono mẹ ụnwegirima iya ono a-tụko bụru kẹ nnajịuphu iya. Ọ bụerupho nwoke a-la nwẹkinyi iya. ");
INSERT INTO izz_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Obenu ọ -bụru l'ohu ono sụru lẹ ya yeru nnajịuphu iya obu; bya eye nwanyị ono, ọolu ono; waa ụnwegirima iya; ọphu ya alụfudu eje enweru onwiya; ");
INSERT INTO izz_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","g'onye nwe iya nụ duru iya je l'iphu ndu-ikpe. L'o duru iya je l'ọnu-mgbo; ọzo l'ọkpa mgbo; je egude oji kpọ-fua ya nchị. L'ọ bụru ohu iya jasụ g'ọo-nọ-beru.” ");
INSERT INTO izz_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ọ -bụru lẹ nwoke reru nwa iya nwanyị g'ọ bụru ohu; a ta abyadụ aha iya g'ọ laa g'aahajẹ unwoke phọ. ");
INSERT INTO izz_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Teke e reru iya onye arị kẹ g'ọ lụru iya; a nọnyaa; ọphu ọ dụedu iya ree; g'ọ hakwaa g'a gbata iya. Ọ tọ gbakwarụ gẹ nnajịuphu iya ono ree ya ndu ọhozo; noo kẹle o to meẹduru ohu iya ọbu iphe, o kweru ukwe iya. ");
INSERT INTO izz_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ọ -bụru l'ọo nwa iya nwoke bẹ ọ zụ-doru iya g'ọ lụru; g'o mejekwa nwamgbọko ọbu gẹ nwa, ọ nwụru anwụnwu. ");
INSERT INTO izz_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ọ -bụru lẹ nwoke lụtaru nwanyị ọzo; g'ọ nụjekwa nyee ya kẹ mbụ nri; nmajẹru iya ẹkwa; emeru iya iphemiphe, eemejeru nwanyị, aalụ alụlu. ");
INSERT INTO izz_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","O -bụru l'o too medụru iya ụzo iphe ẹto ono; gẹ nwanyị ono lụfu; ọle g'ọ tọ dụkwa mẹ afụ, aa-pfụ nwoke ono.” ");
INSERT INTO izz_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Onye chiru nemadzụ iphe chigbua ya; g'ọ lakwaa l'ọchi iya. ");
INSERT INTO izz_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ọle ọ -bụru l'o to lekebedụru ẹnya chigbua ya; ọ -bụru l'ọo Chileke harụ iya g'ọ nwụa nno; bẹ o nweru ẹka mu e-goshi unu g'onye dụ nno gbajẹru laa. ");
INSERT INTO izz_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Obenu; ọ -bụru lẹ nemadzụ lekeberu ẹnya; gude ẹregede gbua nemadzụ ibiya; unu kpụta onye ọbu kpụru lụfu l'ọru-ngwẹja mu; je egbua l'ẹka ọzo.” ");
INSERT INTO izz_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Onye tsoru ne iya; ọzoo nna iya ọgu bẹ ee-gbu egbugbu.” ");
INSERT INTO izz_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Onye parụ nwibe iya je eree; ọzoo l'ọ nọkwadu iya l'ẹka teke e guderu iya; g'e gbua onye ọbu egbugbu.” ");
INSERT INTO izz_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Onye phuru ne iya iphu; ọzoo nna iya; g'e gbukwaa onye ono egbugbu.” ");
INSERT INTO izz_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ọ -bụru l'unwoke labọ bẹ opfu adaru; onye lanụ tụa onye ọphuu mkpuma; ọzoo l'ọ pfụpfuberu ẹka tsua ya; ọphu onye ono anwụhuduru anwụhu; ọ bụru iphe bẹ o mekarụ iya; ọ zẹeru iya azẹe; g'ọ tọ dụkwa iphe, ee-me onye ono, mekarụ iya iphe ono; ");
INSERT INTO izz_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","m'ọ bụru l'onye ono mechaarụ-a; ọ nọdu adụje ike gude mgbọro ejephe l'etezi. Ọle onye ọphu mekarụ iya iphe, a-pfụkwanu iya ụgwo azẹe ono, o shi zẹe kẹ mmanụ ono; bya aghakwaa ya phọ jasụ l'ọ kaẹbe mma ree.” ");
INSERT INTO izz_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ọ -bụru l'o nweru onye chiru ohu iya iphe; m'ọ bụ ohu iya kẹ nwoke; ọzo kẹ nwanyị; ohu ono shi l'iphe ono, e chiru iya ono nwụhu; g'a nụ̀kwaa onye ono, chigburu iya nụ ono aphụ̀. ");
INSERT INTO izz_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Obenu l'ọ -bụru l'ohu ono nọru ujiku ẹbo; ọzoo ẹto bya ewekọrohu; g'ọ tọ dụkwa iphe, ee-me onye chiru iya iphe; eshinu ohu ono bụ ẹku iya bẹ ọ bụ.” ");
INSERT INTO izz_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ọ -bụru l'o nweru unwoke, alwụ ọgu; ẹphe meka nwanyị, dụ ime iphe; mee k'ọphu ẹpho lụfuru iya; ọphu ọ dụdu ẹka a kwatarụ meka iya iphe ọzo; g'e retakwaa onye ọphu mekarụ iya iphe ọbu nre lẹ g'ọodu ji nwanyị ono ree; waa gẹ ndu-ikpe kpeburu. ");
INSERT INTO izz_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Obenu; ọ -bụru l'e mekarụ iya iphe shii; gẹ ndzụ laaru ndzụ; ");
INSERT INTO izz_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","g'ẹnya laaru ẹnya; eze alaaru eze; ẹka alaaru ẹka; ọkpa alaaru ọkpa. ");
INSERT INTO izz_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ọ -bụru ọku bẹ ọ hụru iya; l'a hụlata iya. Teke o mefuru iya ọ́nyá l'ẹhu; l'e melata iya. Teke o tsuru mkpụkpu-mee ye iya l'ẹhu; l'e tsukwarụpho mkpụkpu-mee ye yẹbedua l'ẹhu.” ");
INSERT INTO izz_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ọ -bụru l'o nweru onye chiru ohu iya iphe l'ẹnya; k'ọphu o chipyaru iya ẹnya lanụ; g'onye ono hakwaa ohu ono g'ọ laa; je enweru onwiya; g'ọ bụru ụgwo ẹnya ono, o chipyaru iya ono. ");
INSERT INTO izz_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ọ -bụru l'o chikwofuru iya eze lanụ; g'ọ hakwaa ohu ono g'ọ laa je enweru onwiya; g'ọ bụru ụgwo eze iya ono.” ");
INSERT INTO izz_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ọ -bụru l'oke-eswi gude mpu dụ-gbua nemadzụ; g'a tugbua eswi ono lẹ mkpuma; tẹme g'a ta takwa anụ iya atata; ọle g'ọ tọ dụkwa iphe, ee-me onye nwe iya nụ. ");
INSERT INTO izz_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Obenu; ọ -bụru l'oke-eswi ọbu eme ẹna; e pfuhawaru iya onye nwe iya nụ; ọphu ọ tọ kpọ-chiduru iya l'ọka; ọo ya bụ; ọ -bụru l'ọ dụ-gburu nemadzụ; l'a tugbua eswi ono lẹ mkpuma; onye nwe iya nụ alaa l'ọchi onye ọ dụ-gburu. ");
INSERT INTO izz_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ọle ọ -bụru l'ọ dụ ndu ono g'ẹphe gbuaru onye nwe eswi ono nre; g'ọ pfụkotakwa iphemiphe, e gbuburu iya; shi nno gbata onwiya. ");
INSERT INTO izz_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ekemu ono bụkwapho iphe lanụ m'ọ -bụru l'oke eswi dụ-gburu nwokoro; ọzoo nwamgbọko. ");
INSERT INTO izz_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ọ -bụru l'oke-eswi ono bẹ dụ-gburu ohu; g'onye nwe eswi ono pfụa onye nwe ohu ono okpoga mkpọla-ọchaa, ẹrwa iya rwuru ụkporo shẹkelu lẹ shẹkelu iri; tẹme l'a tụ-gbukwaaphọ eswi ono lẹ mkpuma.” ");
INSERT INTO izz_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ọ -bụru lẹ nemadzụ kpufuru iphe lẹ nsụ; ọzoo l'onye ono tụru nsụ; ghebe ọnu; oke-eswi; ọzoo nkapfụ-ịgara je adalahụ iya; nwụhu; ");
INSERT INTO izz_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","g'onye nwe nsụ ono pfụkwaa ụgwo anụ ono. Mbụ-a; g'onye ono pfụkwaa onye nwe anụ phọ dalahụru lẹ nsụ phọ ụgwo iya; patawarọ ono, nwụhuru nụ ono. ");
INSERT INTO izz_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ọ -bụru lẹ nemadzụ bẹ oke-eswi iya dụ-gburu oke-eswi onye ọzo; g'ụmadzu labọ ono gbarụ mgba ree oke-eswi ọphu dzụ ndzụ; kee aswa iya ẹnya-nhamụnha. Ẹphe ekekwaaphọ anụ iya ọphu nwụhuru anwụhu ẹnya-nhamụnha. ");
INSERT INTO izz_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ọle ọ -bụru l'onye nwe oke-eswi ono maru l'oke-eswi iya eme ẹna; ọphu ọ tọ kpọ-chiduru iya l'ọka; g'onye nwe oke-eswi ono kpẹe onye ọphuu oke-eswi ọzo; pata ọphu nwụhuru nụ phọ.” ");
INSERT INTO izz_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Teke o nweru onye kpụru eswi; ọzoo atụru onye ọzo l'oshi; gbua; ọzoo l'o reru iya erere; g'o gude eswi ise pfụa ụgwo eswi ono. Ọ -bụru atụru; l'ọ bụru atụru ẹno. ");
INSERT INTO izz_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ọ -bụru l'a hụmaru iphuru l'ẹka ootsukpọ ụlo onye ọzo gẹ ya bahụ; e meka iya iphe; o shi nno nwụhu; bẹ onye ono, gburu iya nụ ono te egbuduru ọchi. ");
INSERT INTO izz_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Obenu; ọ -bụru l'iphe ono nwụru g'ẹnyanwu wachaaru bẹ onye chigburu iya nụ gbukwaru ọchi. “Onye oshi pfụfutaje ụgwo iphe, o zitaru. Teke ọ bụ l'o to nwedu iphe, o nweru; l'e ree yẹbedua l'onwiya; gude aswa iya pfụa ụgwo iphe, o zitaru. ");
INSERT INTO izz_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ọ -bụru l'iphe ono, o zitaru ono bẹ a hụmaru iya l'ẹka; iphe ọbu nọdukwadua ndzụ; ọ bụ oke-eswi-o; ọzoo nkapfụ-ịgara; mẹ atụru; g'onye ono pfụa ụgwo iya mpfụkwase. ");
INSERT INTO izz_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ọ -bụru lẹ nemadzụ chịru iphe-edobe iya ye; o je ataa iphe e meberu l'opfu onye ọzo; ọzoo opfu-vayịnu onye ọzo; ọzoo l'ọ harụ iya ẹka; o je ataa iphe e meberu l'opfu onye ọzo; g'onye nwe iphe-edobe ono gude iphe, kachaa ree, shi l'opfu iya; ọzoo opfu-vayịnu iya; gude pfụa onye ọphuu ụgwo iphe iya. ");
INSERT INTO izz_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ọ -bụru l'ọku nahụru laa l'ẹgbudu; k'ọphu o tsuru ereshi, e gburu egbugbu; ọzoo ọphu pfụru apfụru; ọzoo l'o tsugburu opfu ono l'ophu; g'onye tụru ọku ono pfụa ụgwo iya. ");
INSERT INTO izz_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ọ -bụru l'o nweru onye nụru onye ọzo okpoga; ọzoo iphe ọzo g'o doberu iya; a bya ezita iya l'ụlo ibe onye ono; ọ -bụru l'e guderu onye-oshi ono; l'ọ pfụa ụgwo iya mpfụkwase. ");
INSERT INTO izz_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Teke ọ bụkwanu l'e te egudeduru iphuru ọbu; g'onye nwe ụlo ono fụta l'atatiphu ndu-ikpe; bya egude ẹpha Chipfu gụa ẹnwa g'a maru l'ọ tọ bụdu iya kpamiru iya. ");
INSERT INTO izz_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ọ -bụru l'ọ dụru iphe, tuphahụru etuphahụ; a hụma iya onye ọzo l'ẹka; mbụ iphe, dụ g'eswi; ọzoo nkapfụ-ịgara; ọzoo atụru; ọzoo iphe eye l'ẹhu; mbụ iphe, bụkpoo iphe, eenwejeru enweru; l'e duta ụmadzu labọ, adzọ iphe ono bya l'atatiphu ndu-ikpe. Onye ọphu ikpe nmarụ l'ọ pfụa onye ọphuu mpfụkwase. ");
INSERT INTO izz_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ọ -bụru l'o nweru onye kpẹru onye ọzo nkapfụ-ịgara; ọzoo oke-eswi; ọzoo atụru; mẹwaro anụ ọzo g'o doberu iya; ọ nwụhu; ọzoo l'e mekarụ iya iphe; ọzoo l'o tuphahụru; ọphu ọ dụdu onye maru iphe, meru iya nụ; ");
INSERT INTO izz_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","g'ee-shi doshia opfu ono bụ g'onye ono bya l'atatiphu Chipfu je agụa ẹnwa l'ọ tọ makwa iphe, meru ẹku onye ọphuu. G'onye nwe iya nụ kwetakwa nno; g'a ta pfụkwa iya ụgwo iya. ");
INSERT INTO izz_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ọle ọ -bụkwanuru l'a kpụru iya k'iphuru l'ibe onye ono, e doberu iya ono; g'onye ono pfụkwaa onye nwe iya nụ ụgwo iya. ");
INSERT INTO izz_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ọ -bụru l'ọo anụ-ẹgbudu gburu iya; l'o wota anụ iya ọphu ọ taphodoru je egoshi; g'a maru l'ọo anụ-ẹgbudu gburu iya. G'a ta asụkwa g'ọ pfụa ụgwo iya. ");
INSERT INTO izz_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ọ -bụru l'o nweru onye rwọtaru iphe-edobe onye ọzo; iphe-ẹhuka meka iya; ọzoo l'ọ nwụhuru teke onye nwe iya nụ ta nọdu l'ẹka ono; g'onye rwọtaru iya nụ pfụkwaa ụgwo iya. ");
INSERT INTO izz_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Obenu; ọ -bụru l'onye nwe iya nụ nọ l'ẹka ono teke ono; g'onye jeru arwọta iya nụ ta pfụshi ụgwo iya. Teke ọ bụ l'ọ pfụru ụgwo; ngụta eswi ono; g'okpoga ono, a pfụru ono nọ-chiwarọ uburu ọbu.” ");
INSERT INTO izz_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ọ -bụru l'o nweru onye kparụ nwamgbọko, nwoke teke ejepfuswee; ọphu ọ dụdu onye ejewa iya alụlu; ẹphe l'iya kwaa; g'ọ kwarụ aswa nụ ndibe phẹ; duta iya je alụru. ");
INSERT INTO izz_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ọ -bụru lẹ nna nwamgbọko ono jịkaru sụ lẹ ya te ekedu iya ya; g'ọ kwaakwaphọ aswa, aakwajẹ l'ishi nwamgbọko, nwoke teke ejepfuswee; nụ nna iya. ");
INSERT INTO izz_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Unu ta ahajẹkwa nwanyị, eme ọmamanshi g'ọ nọdu ndzụ. ");
INSERT INTO izz_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Onye jepfuru anụ; ẹphe l'iya kwaa bẹ ee-gbuje egbugbu. ");
INSERT INTO izz_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Onye gwerụ ngwẹja nụ iphe ọzo, abụdu mbẹdua, bụ Chipfu nwẹkinyi mu bẹ ee-gbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Unu ta akpajẹkwa ndu lwarụ alwalwa ẹhu; ọphu unu emejekwa phẹ ewere; noo kẹle unu shi bụru ndu lwarụ alwalwa l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Unu te emejekwa ụnwanyi, ji phẹ anọedu; waa ụnwu-ogbee ewere. ");
INSERT INTO izz_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Teke unu meru phẹ ewere; ẹphe -wolia olu; raku mụbe Chipfu bẹ mu a-nụmakwa olu phẹ. ");
INSERT INTO izz_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ẹhu a-watakwa mu eghushi eghu ike; mu egude ọgu bya atụko unu gbuẹbe. Unyomu unu abụru ụnwanyi, ji phẹ anọedu; ụnwegirima unu abụru ndu enweẹdu nna. ");
INSERT INTO izz_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ọ -bụru l'unu jieru ndu kẹ mụbe Chipfu, mkpa byaru ụgwo l'echilabọ unu; unu te emekwa gẹ ndu ejịeje ụgwo-ntụkwase. Unu ta asụkwa g'ẹphe tụkwase iya iphe. ");
INSERT INTO izz_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ọ -bụru lẹ nwibe unu yeru unu uwe l'itumo; unu wolaaru iya ya tẹmanu ẹnyanwu arịba. ");
INSERT INTO izz_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Noo kẹle ọo uwe ono bụ iphe, oogudeje gbobuta ẹhu iya. ?Bụhunu gụnu bẹ oo-gude kuru mgbẹnya? Ọ -raku mụbe Chipfu bẹ mu a-nụmakwa olu iya. Noo kẹle mu aphụje obu-imemini. ");
INSERT INTO izz_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Unu ta anmakwa Chileke phulaphula; ọphu unu ephukwa ndu bụ ndu-ishi alị unu iphu. ");
INSERT INTO izz_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Unu ta ahakwa egweru mụbe Chipfu ngwẹja, shi l'akpụru iphe, unu kpatarụ l'opfu; waa ọphu shi lẹ mẹe, unu pyịtaru apyịta. “Unu kujeru ọkpara unu nwoke nụ mu. ");
INSERT INTO izz_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Unu mekwaaphọ eswi unu; waa atụru unu nno. Unu hajẹ phẹ g'ẹphe nọo l'ẹhu ne phẹ ujiku ẹsaa. O -rwua mbọku k'ẹsato; unu akpụta iya wotaru mu. ");
INSERT INTO izz_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Unu a-bụru ndu dụru mu nsọ. Unu ta atajẹkwa iphe, anụ-ẹgbudu gburu. Unu tọgbojeru iya nkụta.” ");
INSERT INTO izz_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ta asụjekwa asụlasu. Ta agbajẹkwa ẹjo ekebe gude eyeru ẹjo nemadzụ ẹka. ");
INSERT INTO izz_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Te etsojekwaru igwe-ọha ye ẹka l'eme iphe, adụdu ree. Teke ị pfụru l'iphu ndu-ikpe; te egudekwa l'iime g'i pfua iphe l'a-dụ ọha ree; woru ikpe nma onye iswi dụ mma. ");
INSERT INTO izz_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Te egudekwa lẹ nemadzụ bụ onye ụkpa; gbaaru iya ọdzori l'iphu ndu-ikpe. ");
INSERT INTO izz_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ọ -bụru l'ị hụmaru oke-eswi; ọzoo nkapfụ-ịgara onye ọhogu ngu ẹka ootuphahụwa etuphahụ; kpụta iya kpụ-jeru iya. ");
INSERT INTO izz_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ọ -bụru l'ị hụmaru nkapfụ-ịgara onye ị dụ ashị ẹka ivu, o vu nyị-tsutarụ iya; ta ahakwa iya. Tụgbukwaa je eyeru iya ẹka. ");
INSERT INTO izz_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ta jịkakwa ekperu onye ụkpa ikpe, pfụru ọto l'ụlo-ikpe. ");
INSERT INTO izz_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","G'a ta anmajẹkwa onye e boru ibo ikpe; tẹme ọphu eemegbujekwa onye pfụberekoto, adụdu iphe, o meru. Noo kẹle onye meru ẹjo-iphe, dụ nno bẹ mu ta ahadụ gẹ mu ta anma iya ikpe. ");
INSERT INTO izz_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ta anatajẹkwa iphe-ụphalazu; kẹle iphe-ụphalazu emejekwa g'a tụa ẹnya mkpu l'iphe, e gege ahụma; tẹme ọ nọdu emeje g'a nmaa onye pfụberekoto ikpe. ");
INSERT INTO izz_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Unu ta akpajẹkwa ndu lwarụ alwalwa ẹhu; kẹle unu maru g'ọ dụje onye lwarụ alwalwa; noo kẹle unu shiwaa bụru ndu lwarụ alwalwa l'alị Ijiputu.” ");
INSERT INTO izz_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Apha ishii bẹ unu a-kọje alị unu; kpata iya iphe, e meberu iya. ");
INSERT INTO izz_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","O -be l'apha k'ẹsaa; unu ahaa alị ono g'ọ tọ dụkwa iphe, unu a-kọ iya; k'ọphu ndu Ízurẹlu ndu ọphu akpa nri e-je akpa l'ẹka ono; tẹme anụ-ẹgbudu erifufuwarọ ughudu iya. Unu mekwaphọ opfu-vayịnu; waa ẹgu olivu unu nno. ");
INSERT INTO izz_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ujiku ishii bẹ unu e-jeje ozi; o -be lẹ mbọku k'ẹsaa; unu te ejekwa ozi. Ọo ya bụ g'oke-eswi unu; waa nkapfụ-ịgara unu edzutajẹ ike; tẹme waa g'ohu, a nwụru l'ibe unu; m'onye lwarụ ibe unu alwalwa a-tụtakwapho unme. ");
INSERT INTO izz_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Unu kwabẹkwa ẹnya mekọta iphemiphe-a, mu pfushiru unu-a. Unu ta adụkwa iphe, bụ iphe, aagwa agwagwa, unu a-kpọ-kuje. Unu te ephotajẹkwa ẹpha iya ephota ophu.” ");
INSERT INTO izz_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ugbo ẹto l'apha bẹ unu a-bọjeru mu ọbo-iphe. ");
INSERT INTO izz_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Unu bọo ọbo-iphe buredi, ekoduru ekoko. Ujiku ẹsaa bẹ unu a-tajẹ buredi, e yedụru iphe, ekoje buredi, bụ iphe, mu tụru unu l'ekemu. Unu meje iya teke ono, aabọje ọbo-iphe ono l'ọnwa Abibu; noo kẹle ọo l'ọnwa ono bẹ unu lụfutaru l'alị Ijiputu. “G'o to nwekwa onye a-gbajẹru ẹka bya l'atatiphu mu. ");
INSERT INTO izz_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Unu gudeje mebyi-iphe-mbụ, iphe unu meberu l'alị mịtaru; gude bọo Ọbo Mebyi-iphe-mbụ. “Unu bọo Ọbo-M̀kpù l'ishi apha; mẹ unu metajẹepho iphe, unu meberu l'alị. ");
INSERT INTO izz_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ugbo ẹto l'apha bẹ unwoke unu g'ẹphe ha a-tụkoje bya l'atatiphu Nnajịuphu, bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Unu ta adụkwa iphe, e yekọberu iphe, ekoje buredi, unu e-yekọbe lẹ mee anụ, unu gude egweru mu ngwẹja. Ọphu ọ dụkwa ẹba-anụ ono, e gude abọ ọbo-iphe ono, aa-ha g'ọ bọo nchi. ");
INSERT INTO izz_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Iphe-mbụ, vuru ụzo kaa l'opfu unu bẹ unu e-gudeje bya l'ụlo Chipfu, bụ Chileke unu. “Unu te egudejekwa mini-ẹra ne eghu shia nwa iya.” ");
INSERT INTO izz_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Unu hụma lẹ mu e-zi ojozi-imigwe g'o vutaru unu ụzo; eche unu nche; waa g'o dua unu durwua ẹka ono, mu kwakọbewaru akwakọbe ono. ");
INSERT INTO izz_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Unu ngabẹjeru ojozi-imigwe ono nchị; mee iphemiphe, ọ sụru g'unu mee. Unu te kwefukwaru iya ike; kẹle ọ tọo gụkwaru unu nvụ; eshinu ọ bụ ẹpha mu bẹ o gude eje. ");
INSERT INTO izz_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ọ -bụru l'unu jikpọerupho obu oyi; ngabẹ nchị l'iphemiphe, o pfuru; bya emekọta iphe, mu sụru g'unu meje; mu abụru ọhogu ndu ọhogu unu; ẹphe adụ mu ashị; mbụ ndu unu dụ ashị. ");
INSERT INTO izz_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ojozi mu e-vuta ụzo duru unu bahụ l'alị ndu Amọru; waa kẹ ndu Hetu; waa kẹ ndu Pẹ́rezu; waa kẹ ndu Kénanu; waa kẹ ndu Hevu; waa kẹ ndu Jiebusu; tẹme mu atụkoepho ndu ono mee g'ẹphe chịhu l'alị ono. ");
INSERT INTO izz_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Unu te ephozejekwaru iphe, bụ iphe, aagwa agwagwa; ọphu unu abajẹkwaru iya ẹja; ophu unu etsojekwaru phẹ mee omelalị phẹ. Unu mebyishia agwa phẹ; unu etsukpọshia mkpuma, ẹphe doberu l'ọru-ngwẹja phẹ. ");
INSERT INTO izz_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Unu bajẹru mụbe Chipfu, bụ Chileke unu ẹja. Mu e-meru unu iphe-ọma lẹ nri waa lẹ mini; bya ewofu iphe-ememe l'echilabọ unu. ");
INSERT INTO izz_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","L'alị unu te enwedu nwanyị, ẹpho bya alụfu; ọzoo onye ata atsụdu ime. Mu e-me g'unu kajẹ nka ọkpobe akaka. ");
INSERT INTO izz_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Mu e-me g'a tsụje unu ebvu. Iphe, bụ ọhamoha, unu l'ẹphe alwụ ọgu bẹ mu e-meje g'ẹphe mehu bọtorii. Mu emee ndu ọhogu unu g'ẹphe ghakọbeje; gbaaru unu ọso. ");
INSERT INTO izz_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mu e-ye evu g'o vuru ụzo je je agbaa ndu Hevu; yẹe ndu Kénanu; yẹe ndu Hetu gbakashịa phẹ g'ẹphe gbẹshiru unu. ");
INSERT INTO izz_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ọle mu ta achịfu-gbudu phẹ l'apha lanụ; noo kẹle alị ono a-bya bụru okorobo-ẹgu; tẹme anụ-ẹgbudu apanụkaru iya unu ẹka. ");
INSERT INTO izz_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mu a-tọkpoepho nwẹhu achịshi phẹ; gbiriri jasụ unu aka igwerigwe; dụ ike nwekọtaru alị ono. ");
INSERT INTO izz_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mu emee g'oke alị unu gbẹ lẹ Eze-ẹnyimu Uswe-uswe je akpaa l'eze-ẹnyimu ndu Filisitayinu; l'ọ bya agbẹ l'echiẹgu nọo jasụ l'ẹnyimu Yufurétisu. Mu eworu ndu bu l'alị ono ye unu l'ẹka; g'unu chịfu phẹ l'atatiphu unu. ");
INSERT INTO izz_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","G'unu l'ẹphe; ọzoo agwa phẹ ta agbakwa ndzụ. ");
INSERT INTO izz_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Unu te ekwekwa g'ẹphe buru l'alị unu; ọdumeka bẹ ẹphe a-kpatakwa; unu emee iphe-ẹji meswee mụbe Chipfu. Noo kẹle unu -baarụ agwa phẹ ẹja bẹ unu nmalahụakwaru l'ọ́nyà.” ");
INSERT INTO izz_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ọo ya bụ; Chipfu sụ Mósisu: “Gẹ gụbedua; waa Erọnu; waa Nadabu; waa Abihu; waa ndu bụ ọgerenya Ízurẹlu ụkporo ụmadzu ẹto l'ụmadzu iri nyipfuta mụbe Chipfu; bya anọdu ụzenya; baarụ mu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ọo Mósisu nwẹkinyi iya bụ onye a-byapfuta mụbe Chipfu; gẹ ndu ọphuu be ejekwa mu akpịritaru ntse; ọphu ndu Ízurẹlu etsokwa Mósisu nyikota imeli.” ");
INSERT INTO izz_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mósisu bya eje epfukọtaru ndu Ízurẹlu iphe, Chipfu pfushiru; waa ekemu iya. Ẹphe tụko gude olu lanụ zụ̀a; sụ: “Iphemiphe, Chipfu pfuru bẹ anyi e-mekọta.” ");
INSERT INTO izz_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mósisu bya atụko iphemiphe, Chipfu pfuru dekọta l'ẹkwo. Ọ gbẹshi l'ọnmewa ụtsu; bya akpụa ọru-ngwẹja l'ọkpa úbvú; bya apfụbe mkpuma iri l'ẹbo, nọ-chiru ẹnya ọkpa-ipfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ọo ya bụ; ọ bya ezia ụnwokorobya ndu Ízurẹlu; ẹphe je egwee ngwẹja-akpọ-ọku nụ Chipfu; bya egbushikwaaphọ ụnwu oke-eswi gude gwee ngwẹja-ẹhu-guu nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mósisu bya ekee mee anụ ono ẹbo woru nanụ wụru ye lẹ gbamụgbamu; bya ewota ọphuu phee l'ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ọ bya ewota Ẹkwo Ọgbandzu ono gụaru ndu Ízurẹlu. Ẹphe zụ̀a mgbede sụ: “Iphemiphe, Chipfu pfuru bẹ anyi e-mekọta; mbụ l'anyi e-mekọtajekpoepho iphemiphe, o pfuru.” ");
INSERT INTO izz_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mósisu bya ewota mee ono phee ndu Ízurẹlu l'ẹhu bya asụ: “Waa mee, egoshi ọgbandzu, Chipfu meru; unu l'iya gbaa lẹ k'opfu, o pfuru-a.” ");
INSERT INTO izz_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mósisu; yẹe Erọnu; waa Nadabu; yẹe Abihu; waa ndu bụ ọgerenya Ízurẹlu ụkporo ụmadzu ẹto l'ụmadzu iri bya enyihu eli úbvú ono; ");
INSERT INTO izz_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","bya ahụma Chileke ndu Ízurẹlu. Iphe, ọ pfụru l'eli iya bụru iphe, e meru lẹ mkpuma, aswa dụ, bụ sáfàyà; o doẹpho rịsaa g'akpaminigwe. ");
INSERT INTO izz_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ọphu ọ dudu iphe, Chileke meru ndu bụ ọgerenya Ízurẹlu; ẹphe hụma Chileke; bya eria nri; ngụa iphe, aangụ angụngu. ");
INSERT INTO izz_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Chipfu sụ Mósisu: “Nyipfuta mu l'úbvú-a bya anọdu l'ẹka-a gẹ mu nụ ngu mkpuma, dụ bachịbachi, mu deru ekemu; waa iphe, mu sụru g'ẹphe meje, a-nọduje akpọ-ziru phẹ ụzo.” ");
INSERT INTO izz_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Noo ya; Mósisu; yẹe Jioshuwa, bụ onye eyejeru iya ẹka gbalihu swịru; je enyihu úbvú Chileke. ");
INSERT INTO izz_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mósisu sụ ndu bụ ọgerenya ono: “Unu nọdu l'ẹka-a ngabẹru anyi gbiriri jasụ teke anyi a-byapfuta unu ọzo. Erọnu yẹe Huru bẹ unu l'ẹphe nọ l'ẹka-a; onye opfu dapfutaru; g'o jepfuje phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mósisu nyihuẹpho úbvú ono; urwukpu sọ-kpute iya. ");
INSERT INTO izz_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ogbunwịinwii Chipfu bya atụko úbvú Sayịnayi ono sweta. Urwukpu ono nọkota l'úbvú ono ujiku ishii. O be lẹ mbọku k'ẹsaa; Chipfu gbẹ l'urwukpu ono kua Mósisu oku. ");
INSERT INTO izz_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ogbunwịinwii Chipfu ono duẹpho ndu Ízurẹlu g'ọku, enwu enwunwu l'eli úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mósisu nọdu enyiribẹbaaru l'úbvú ono; ọ nọdu abahụba l'ime urwukpu ono. Ọ nọo l'eli úbvú ono ụkporo abalị labọ eswe l'ẹnyashi. ");
INSERT INTO izz_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Pfuaru ndu Ízurẹlu g'ẹphe shi l'iphe, ẹphe nweru enweru hata iphe bya anụ mu. Iphe, ịi-natajẹ bụ iphe, onye gude obu iya wota bya anụ. ");
INSERT INTO izz_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Iphe, ẹphe a-nụ bụ mkpọla-ododo; waa mkpọla-ọchaa; waa onyirubvu; ");
INSERT INTO izz_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","waa owu urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; waa ọkpobe owu ọchaa; waa ẹji eghu; ");
INSERT INTO izz_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","waa akpọ ebili, a tsẹru l'uswe; waa akpọ umoro-ẹnyimu; waa oshi akesha; ");
INSERT INTO izz_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","waa manụ olivu, ee-gudeje anwụ ọku; waa iphe, eeyeje lẹ manụ k'awụ l'ishi g'o shia mkpọ; mẹ ọphu eeyeje l'ụ̀nwù-isẹnsu g'o shia kwẹekweekwee; ");
INSERT INTO izz_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","waa mkpuma ónìkùsù; mẹwaro mkpuma ọzo, aswa dụgbaa. Mkpuma ono bẹ ee-mechaa gbapyabẹ l'uwe-ukuvu onye-ishi ndu-uke; yẹle uwe-ọkpoma iya. ");
INSERT INTO izz_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Pfuaru phẹ g'ẹphe kpụaru mụbe Chipfu ụlo, dụ nsọ; gẹ mu eburu l'echilabọ phẹ. ");
INSERT INTO izz_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Unu mekwa ụlo-ẹkwa ono; yẹe iphemiphe, a-nọdukota l'ime iya g'ọ dụepho gẹ mu e-goshi unu g'e mee ya.” ");
INSERT INTO izz_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“G'ẹphe gudekwa oshi akesha kụa okpoko. G'ogologo iya dụ nkwo-ẹka labọ lẹ mkpirikpu iya. Ọsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpu iya. Eli iya adụkwapho nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","L'ị wụa ọkpobe mkpọla-ododo l'ime iya; waa l'azụ iya. L'i gudekwaphọ mkpọla-ododo wụ-phee mgburẹku iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","L'ị kpụta echi mkpọla-ododo ẹno depfubegbaa l'ọkpa iya ẹphen'ẹno; mbụ g'i wota ẹbo depfube l'ibe lanụ; wota ẹbo k'ọphuu depfube l'ibe iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","L'i gude oshi akesha pyịta mgbọro labọ; wụa ya mkpọla-ododo. ");
INSERT INTO izz_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","L'i woru mgbọro ono ẹphenebo pyochaa l'echi ono, e depfubegbaaru lẹ mgburẹku okpoko ono g'ọ bụru iphe, ee-gudeje apa iya. ");
INSERT INTO izz_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mgbọro ono a-nọduwaro l'echi okpoko ono. G'e te wofubaẹkwa iya ewofu. ");
INSERT INTO izz_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","L'i woru iphe, e deru ekemu mụbe Chipfu, bụ iphe, mu e-mechaa nụ unu dobe l'ime okpoko ono. ");
INSERT INTO izz_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“L'i gude ọkpobe mkpọla-ododo meta opfu okpoko; ẹka aapfụje ụgwo iphe-ẹji, nemadzụ meru. G'ogologo iya dụ nkwo-ẹka labọ lẹ mkpirikpu iya. Ọsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","L'i gude mkpọla-ododo mee chierobu labọ, a-nọduchaa l'ishi opfu okpoko ono. G'ọ bụru mkpọla-ododo, e tsusaru etsusa bẹ ii-gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","L'i woru chierobu lanụ dobe l'ishi ibe lanụ; woru ọphuu dobe l'ishi iya ọphuu. L'i mee gẹ chierobu labọ ono, nọgbaa l'ishishi okpoko ono ẹphenebo yẹle okpoko ono bụru iphe lanụ. ");
INSERT INTO izz_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Chierobu ono bẹ ee-me g'ọ jashịa ǹkù l'ụzo imeli; k'ọphu ǹkù iya ono e-kpuchite opfu okpoko ono. G'ẹphe ghagbabẹ iphu tụko lee ẹnya l'eli okpoko ono kwaphọ. ");
INSERT INTO izz_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","L'i wota opfu okpoko ono kpuchia ya; woru iphe ono, e deru ekemu mu ono, bụ iphe, mu e-mechaa nụ unu ono; yekwaphọ l'ime okpoko ono. ");
INSERT INTO izz_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ọ bụru l'eli opfu okpoko ono; mbụ lẹ mgbaka chierobu labọ ono, nọ l'eli okpoko ono, bụ iya bụ ẹka ono, e doberu iphe, e deru ekemu mu ono bẹ mu a-byapfuta ngu bya akaru ngu iphemiphe, ndu Ízurẹlu e-meje.” ");
INSERT INTO izz_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Gude oshi akesha meta teburu. G'ogologo iya dụ nkwo-ẹka labọ. Ọsa iya adụ nkwo-ẹka lanụ. Eli iya adụ nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","L'ị wụa ya ọkpobe mkpọla-ododo; bya egudekwaphọ mkpọla-ododo wụ-phee lẹ mgburẹku iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","L'i wota wẹrere oshi, ọsa iya ha g'ọbochi-ẹka wụ-phee mgburẹku iya mgburugburu; bya egudekwaphọ mkpọla-ododo kpụ-phee oshi ono. ");
INSERT INTO izz_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kpụta echi mkpọla-ododo ẹno depfubegbaa lẹ mgburẹku ọkpa teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Echi ono a-nọ-kubechakwaa wẹrere oshi phọ; k'ọphu ọo-dụkwanu ike gudeshia mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","L'i gude oshi akesha pyịshia mgbọro ono; wụa ya mkpọla-ododo g'ọ bụru mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","L'i gude ọkpobe mkpọla-ododo meshia gbamụgbamu; waa ite; waa okoro; mẹ nkwẹka ee-gudeje gweeru mu ngwẹja-mẹe. Iphemiphe ono bụ iphe, aa-tụ-kobeje l'eli teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","G'e dobeje buredi l'iphu mu. Ọ bụru l'eli teburu ono bẹ aa-tụ-kobeje iya; k'ọphu ọo-dụje l'iphu mu tekenteke.” ");
INSERT INTO izz_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Gude ọkpobe mkpọla-ododo, e tsusaru etsusa mee iphe, aapfụbeje orọku. Mee ya g'o nweru oshi; waa ẹkali. L'o nweru ochi; nweru nkwo iya; nweru iphe, dụ gẹ nwopu okoko; waa iphe, dụ g'okoko, jawaru àjàjà. Tụkokwa iphemiphe ono mee gẹ yẹle iphe ono, aapfụbeje orọku ono dzepfua bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Oshi iya ono e-nweru ẹkali ishii. G'ẹkali ẹto nọdu lẹ mgburẹku iya lanụ; ẹto k'ọphuu anọdu lẹ mgburẹku iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","G'ẹkali iya lanụ nwejeru okoro ẹto. Okoro ono bẹ ee-mechaa g'ọ dụgbaa g'okoko oshi alụmondu. L'e mekwaaphọ nwopu okoko ye iya; yẹe okoko ọphu jawaru àjàjà. Noo g'ọo-dụkota l'ẹkali iya ono ẹphe n'ishii, dzepfugbaaru l'oshi iya ono. ");
INSERT INTO izz_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","G'oshi iya ono nwekwarụ okoro ẹno, e meru; ọ dụ g'okoko oshi alụmondu. L'o nwekwarụpho iphe, e meru; ọ dụ gẹ nwopu okoko; yẹe iphe, dụ g'okoko ọphu jawaru àjàjà. ");
INSERT INTO izz_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nwopu okoko lanụ bẹ ee-me g'ọ nọdu lẹ mkpula ẹkali iya labọ ono, nọ l'ụzo alị iya. K'ẹbo anọdu lẹ mkpula ẹkali iya labọ k'echi. K'ẹto anọdu lẹ mkpula ẹkali iya labọ k'ụzo eli. Mbụ l'ọo-nọduchaa lẹ mkpula ẹkali iya ono ẹphe n'ishii. ");
INSERT INTO izz_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nwopu okoko iya ono; yẹe ẹkali iya ẹkali iya ono bẹ ee-me gẹ yẹle oshi iya tụko dzepfuru. Ọ bụru ọkpobe mkpọla-ododo, e tsusaru etsusa bẹ ee-gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“L'ị bya emeta orọku ẹsaa pfụbegbaa l'eli iphe ono, aapfụbeje orọku ono. G'e dobekwa iya k'ọphu ìphóró iya a-ngakọtaje iphu ẹka ọ nọ. ");
INSERT INTO izz_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Akpaa ya; waa iphe, aagụjeru ọku iya ye bụkwa ọkpobe mkpọla-ododo bẹ ee-gude mekwaa ya phọ. ");
INSERT INTO izz_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Iphe, aapfụbeje orọku ono; yẹe ngwa iya g'ọ hakọta bụ ọkpobe mkpọla-ododo, ẹrwa iya dụ talẹntu lanụ bẹ ee-gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Letakwa ẹnya g'e mee iphemiphe ono g'ọ dụ g'e goshiru ngu iya l'eli úbvú ono.” ");
INSERT INTO izz_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ọzoo bụ lẹ-a; ii-meta ụlo-ẹkwa. Gude owu ọchaa, a swịru ụdo; waa ọphu dụ urwukpu-urwukpu; waa ọphu dụ uswe-uswe; yẹe ọphu eke mee-mee; kwee ẹkwa kweta iya upfu ẹkwa iri. G'onye maru eme ọna gude owu ono kwee chierobu ye l'upfu ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","G'upfu ẹkwa ono tụkokwa harụ ẹnya nhamụnha. G'ogologo iya dụ nkwo-ẹka ụkporo l'ẹsato. Ọsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO izz_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","L'i wota upfu ẹkwa ono ise gbagbabẹ g'ọ bụru nlọchiru lanụ; l'i wotakwaphọ ụzo ise ọphuu gbagbabẹ nanụ. ");
INSERT INTO izz_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Nlọchiru iya ono kẹ mbụ bẹ ii-gude owu, dụ urwukpu-urwukpu yeshia ya nkoloba l'igburọnu upfu ẹkwa iya ono k'ikpazụ. L'ị bya emekwaaphọ nno l'upfu ẹkwa k'ikpazụ lẹ nlọchiru iya k'ẹbo. ");
INSERT INTO izz_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Nkoloba ụkporo labọ l'iri bẹ ii-ye l'ishishi nlọchiru lanụ; l'i yekwaphọ nkoloba ụkporo labọ l'iri l'ishishi nlọchiru lanụ ọphuu. Nkoloba ono a-tụko ghagbabẹ iphu. ");
INSERT INTO izz_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Gude mkpọla-ododo meta iphe, kweru nko ishi labọ ụzo ụkporo labọ l'iri. L'i gude iya dzegbabẹ nlọchiru ẹkwa ono ẹphenebo g'ọ tụko bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“L'ị bya egude ẹji eghu kwee ẹkwa; kweta iya upfu ẹkwa iri lẹ nanụ, ee-gude phụ-chite eli ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","G'upfu ẹkwa ono ẹphe n'iri lẹ nanụ tụkokwa harụ ẹnya nhamụnha. G'ogologo iya dụ nkwo-ẹka ụkporo l'iri. Ọsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO izz_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","L'ị bya achịta upfu ẹkwa ono ise gbagbabẹ g'ọ bụru nlọchiru lanụ; chịta ụzo upfu ẹkwa ishii ọphuu gbagbabẹkwapho nanụ. Upfu ẹkwa lanụ ọphu meru nlọchiru lanụ; ọ dụ upfu ishii phọ bẹ ịi-pyaji ẹbo dobe g'o gboru l'atatiphu ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Nkoloba ụkporo labọ l'iri bẹ ii-ye l'ishishi nlọchiru lanụ; l'i yekwaphọ nkoloba ụkporo labọ l'iri l'ishishi nlọchiru lanụ ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","L'i gude onyirubvu meta iphe, kweru nko ishi labọ ụzo ụkporo labọ l'iri. L'i gude iya kotagbaa nkoloba nlọchiru ẹkwa ono ẹphenebo; gude iya dzegbabẹ ụlo-ẹkwa ono g'ọ bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A bya l'upfu ẹkwa, tsufuru l'ụlo-ẹkwa ono; mbụ nkeru-ẹbo upfu ẹkwa ono bẹ ee-me g'ọ wụ-zeta l'azụ ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Nlọchiru upfu ẹkwa ono, e gude phụ-chite nlọchiru k'ime iya phọ bẹ e-gudekọta nkwo-ẹka lanụ ka k'ime iya phọ ọsa lẹ mgburẹku iya ibekẹboebo. Ndu k'ono bẹ aa-ha g'ọ wụ-zeta l'ụzo alị iya g'e gude iya kwechia mgburẹku iya. ");
INSERT INTO izz_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","L'i wota akpọ ebili, a tsẹru l'uswe mee iphe, ee-gude phụ-chia eli ụlo-ẹkwa ono ọzo. L'ị bya egudekwaphọ akpọ umoro-ẹnyimu mee iphe, ee-gude kwechite eli akpọ k'ebili ono. ");
INSERT INTO izz_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Gude oshi akesha metachaa oshi, ee-gudeje kpọbe ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Oshi ono bẹ aa-rụchaa g'ọ dụgbaa nkwo-ẹka iri l'eli. Ọsa iya adụ nkwo-ẹka lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Oshi ono bẹ aa-pyịtachaa ọkpa labọ ye l'ibekẹboebo. Ọ bụru ẹgube ono bẹ ii-mekọta oshi ụlo-ẹkwa ono g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","A bya l'ụlo-ẹkwa ono ibiya ọphu gharu iphu l'ụzo ọhali; bụ ụkporo oshi bẹ ịi-rụta yegbaa ya. ");
INSERT INTO izz_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","L'i gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye. L'i meta iya ụzo ụkporo labọ. Iphe, bụ oshi ono g'ọ ha e-nweru ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A bya l'ibiya ọphuu; mbụ ibiya ọphu gharu iphu l'ụzo isheli; bụkwapho ụkporo oshi bẹ ịi-rụta; yeshia ya. ");
INSERT INTO izz_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye. L'i meta iya ụzo ụkporo labọ. Iphe, bụ oshi ono g'ọ ha e-nweru ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","A bya l'okotazụ ụlo-ẹkwa ono; mbụ ibiya ọphu gharu iphu l'ụzo ẹnyanwu-arịba bụ oshi ishii bẹ ịi-rụta; yeshia ya. ");
INSERT INTO izz_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","L'ị metachaa oshi ẹbo ẹbo; yechaa lẹ mgburẹku mgburẹku ụlo-ẹkwa ono l'ụzo okotazụ iya ono. ");
INSERT INTO izz_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Oshi labọ ono, ee-yechaa lẹ mgburẹku iya ono bẹ a-dụgbaa nkwegba ẹbo ẹbo. Oo-shi l'ụzo alị dụ nkwegba ẹbo jasụ l'imeli. Tẹme ọ bụru echi lanụ bẹ aa-kụbe iya. Ẹphenebo a-tụko dụkota nno. ");
INSERT INTO izz_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ọo ya bụ l'ọo-dụ oshi ẹsato l'ụzo okotazụ ụlo-ẹkwa ono. L'e gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye ụzo iri l'ishii. Iphe, bụ oshi ono g'ọ ha e-nwegbaarụ ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Gude oshi akesha rwashịa oshi, dụgbaa gbẹrere, ee-gude swebushia l'oshi ono. Ụzo ise bẹ ii-swebe l'oshi mgburẹku ụlo-ẹkwa ono ibe lanụ; ");
INSERT INTO izz_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","l'i swebekwaphọ ụzo ise ọzo lẹ mgburẹku ibe iya ọphuu. Ụzo ise ọzo abụru k'okotazụ ụlo-ẹkwa ono; ibiya ọphu gharu iphu l'ụzo ẹnyanwu-arịba. ");
INSERT INTO izz_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Oshi ọphu ee-swebe l'echi iya bẹ aa-rwa g'ọ gbẹ l'ishi lanụ lụfu l'ishi iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","L'ị wụkota mkpọla-ododo l'oshi ono, eegudeje kpọbe ụlo-ẹkwa ono. L'i gudekwaphọ mkpọla-ododo meshia echi, e-gudeshigbaa oshi ono, dụgbaa gbẹrere ono. Tẹme l'ị wụkwapho mkpọla-ododo lẹ gbẹrere oshi ono. ");
INSERT INTO izz_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Rụkwaa ụlo-ẹkwa ono g'a tụru ngu ọnu iya l'eli úbvú Sayịnayi. ");
INSERT INTO izz_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“L'i gude owu, dụ urwukpu-urwukpu; waa ọphu dụ uswe-uswe; waa ọphu eke mee-mee; yẹe owu ọchaa, a swịru ụdo; kwee ẹkwa. G'onye maru eme ọna gudekwa owu ono kweshia chierobu ye l'ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","L'i gude oshi akesha rwaa itso ẹno; wụa ya mkpọla-ododo. L'i woru itso ono kpọbechaa l'ẹnya ẹka e meshiru lẹ mkpọla-ọchaa. L'i gude iphe, kweru nko, e gude mkpọla-ododo mee kobe ẹkwa ono l'itso ono ");
INSERT INTO izz_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","lẹ mkpula iphe phọ, kweru nko ishi labọ phọ, e gude dzegbabẹ nlọchiru ẹkwa phọ, e gude phụ-chite eli ụlo-ẹkwa ono. L'i woru okpoko-ekemu ono sụbe l'ẹka ono, e kobutaru ẹkwa ono. Ẹkwa ono bẹ ee-gude kekahaa ẹka-dụ-nsọ; yẹle ẹka-kakọta-adụ-nsọ. ");
INSERT INTO izz_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","L'e woru opfu okpoko ono, bụ ẹka aapfụje ụgwo iphe-ẹji, nemadzụ meru ono; kpube l'eli okpoko-ekemu ono, a sụberu l'ẹka-kakọta-adụ-nsọ ono. ");
INSERT INTO izz_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","L'ị pata teburu phọ sụbe l'iphu ẹkwa ono, e gude kobuta ẹka-kakọta-adụ-nsọ ono. Ẹka aa-sụbe iya bụ l'ime ụlo-ẹkwa ono l'ibiya ọphu gharu iphu l'ụzo isheli. L'i woru iphe phọ, aapfụbeje orọku phọ sụbe l'ibiya ọphu gharu iphu l'ụzo ndọhali; g'ẹphe lẹ teburu phọ ghagbabẹ iphu. ");
INSERT INTO izz_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“G'onye gude ngga ekwe ẹkwa gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; yẹe owu ọchaa, a swịru ụdo; kwee ẹkwa, ee-gudeje kochite ọnu-abata ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","L'i gude mkpọla-ododo meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso. L'i gude oshi akesha rwata itso ise; wụkwaa ya phọ mkpọla-ododo; gude onyirubvu kpụshia ẹnya ẹka aa-kpọbegba itso ono ẹphe n'ise. ");
INSERT INTO izz_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Gude oshi akesha rụta ọru-ngwẹja. G'eli iya dụ nkwo-ẹka ẹto. G'ogologo iya waa ọsa iya tụkokwa harụ ẹnya nhamụnha. Iphe, ọo-dụchaa bụ nkwo-ẹka ise ise. ");
INSERT INTO izz_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","L'ị rụtachaa mpu mobechaa l'ishi ishi mgburẹku iya ẹphen'ẹno. Gẹ mpu ono; yẹe ọru-ngwẹja ono rwagbakwaa bụru nanụ. I -mechaa ya nno; l'i woru onyirubvu wụa ya. ");
INSERT INTO izz_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","L'i gude onyirubvu meshia iphemiphe, ee-gudeje eje ozi l'ọru-ngwẹja ono, bụ iya bụ ite ekpo ntụ; waa iphe, eegudeje ekpo ntụ eye l'ite ono; waa gbamụgbamu; waa oji; mẹ iphe, aagụje ọku. ");
INSERT INTO izz_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","L'i gude onyirubvu meta iphe, dụ nggafu-nggafu g'ụgbu; bya enweru mgburẹku ẹno. L'i gudekwaphọ onyirubvu meta echi ẹno hebechaa lẹ mgburẹku iphe ono. ");
INSERT INTO izz_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","L'i wota iphe ono kwechia ụzo alị mgburẹku ọru-ngwẹja ono. G'a gbẹ l'ụzo alị iya kwechia ya jasụ l'echilabọ iya. ");
INSERT INTO izz_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","L'i gude oshi akesha pyịta mgbọro labọ, ee-gudeje apa iya. L'ị wụkwapho mgbọro ono onyirubvu. ");
INSERT INTO izz_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","L'e wochaaru mgbọro ono nwua l'ẹnya echi phọ ibekẹboebo. Mgbọro ono ẹphenebo a-nọdujecha lẹ mgburẹku iya ẹphenebo mẹ a -nọdu apa iya. ");
INSERT INTO izz_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Gudekwa ibiribe oshi mee ọru-ngwẹja ono g'ụzo dụ iya l'echi. Mee ya g'ọ dụ gẹ mu goshiru ngu iya l'eli úbvú ono.” ");
INSERT INTO izz_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Meeru ụlo-ẹkwa ono ọma-unuphu. Gude owu ọchaa, a swịru ụdo; kwee ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo; g'e gude gebuta ibiya ọphu ọma-unuphu ono gharu iphu l'ụzo ndọhali. ");
INSERT INTO izz_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","L'i gude onyirubvu meta ụkporo itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono. L'i gude mkpọla-ọchaa meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebe l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ụzo isheli iya bụkwapho ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo bẹ ee-kwe; gude gebuta iya. Itso, aa-kpọbe l'ụzo isheli ono; yẹe ẹnya ẹka aa-kpọbe itso ono a-dụchaa ụkporo ụkporo. Ọ bụkwarupho onyirubvu bẹ ee-gude metachaa ya. Ọ bụkwanuru mkpọla-ọchaa bẹ ee-gude meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebe l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“A -bya l'ọsa ọma-unuphu ono l'ụzo ẹnyanwu-arịba iya; bụkwa ẹkwa, dụ ụkporo nkwo-ẹka labọ lẹ nkwo-ẹka iri l'ogologo bẹ ee-kwe; gude gebuta iya. G'e meta itso iri, aa-kpọbe l'ụzo ẹnyanwu-arịba ono; metakwaphọ ẹnya ẹka aa-kpọbechaa itso ono ụzo iri. ");
INSERT INTO izz_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ọsa ọma-unuphu ono l'ụzo ẹnyanwu-awawa iya a-dụkwapho ụkporo nkwo-ẹka labọ lẹ nkwo-ẹka iri l'ogologo. ");
INSERT INTO izz_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","L'e kwee ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo; gude gebuta agụga ọnu-abata ọma-unuphu ono ibe lanụ. Itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono a-dụchaa ẹto ẹto. ");
INSERT INTO izz_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A -bya l'ẹka agụga ọnu-abata ọma-unuphu ono ibe iya ọphuu; bụkwapho ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo bẹ ee-kwe; gude gebuta iya. Itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono a-dụchakwapho ẹto ẹto. ");
INSERT INTO izz_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“L'e gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa k'uswe-uswe; yẹe owu ọchaa, a swịru ụdo; gude kwee ẹkwa, dụ nkwo-ẹka ụkporo l'ogologo; gude gebuta ọnu-abata ọma-unuphu ono. G'ọ bụkwaru onye maru egude ngga kwee ẹkwa bẹ e-me iya nụ. Ọnu-abata iya ono bẹ ee-metaru itso ẹno; waa ẹnya ẹka aa-kpọbechaa itso ẹno ono. ");
INSERT INTO izz_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Iphe, ee-swebegbaa l'itso, ee-gude kpọ-buta ọma-unuphu ono mgburugburu; yẹe iphe, kweru nko, ee-gudechaa kobe ẹkwa ono l'itso ono bụkota mkpọla-ọchaa bẹ ee-gude meta iya. Tẹme ẹnya ẹka aa-kpọbechaa itso ono bẹ ee-gude onyirubvu mekọta. ");
INSERT INTO izz_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ọma-unuphu ono a-dụ ụkporo nkwo-ẹka ise l'ogologo; dụ ụkporo nkwo-ẹka labọ l'iri l'ọsa. Ee-gude ẹkwa, e kweru l'owu ọchaa, a swịru ụdo; gebuta iya. Eli ẹkwa ono a-dụ nkwo-ẹka ise. Tẹme l'a wụkota onyirubvu l'ẹnya ẹka aa-kpọbechaa itso iya. ");
INSERT INTO izz_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Iphemiphe ọzo, ee-gudejekpọ eje ozi l'ụlo-ẹkwa ono; m'obeta ọ bụru gụnu bẹ e gude iya eme; je akpaa lẹ nggu, ee-libegbaa eri ụlo-ẹkwa ono; mẹkwapho k'ọma-unuphu ono; bẹ ee-gude onyirubvu mekọta.” ");
INSERT INTO izz_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Pfuaru ndu Ízurẹlu g'ẹphe wotaru ngu ọkpobe manụ olivu, a tsụru l'ikwe, ee-yeje l'orọku; g'ọku orọku ono nwuje mkpụrumkpuru. ");
INSERT INTO izz_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Gẹ Erọnu; yẹle ụnwu iya yeje ọku l'orọku ono l'atatiphu Chipfu l'ime ụlo-ẹkwa-ndzukọ ono; mbụ l'okotazụ ẹkwa phọ, e gude kobuta okpoko-ekemu phọ. G'ẹphe mejekwa orọku ono g'o shije l'ụzenyashi nwuje jasụ l'ụtsu. Gẹ ndu Ízurẹlu dobekwa ekemu-a; a -gbẹ l'ọgbo sweru ọgbo.” ");
INSERT INTO izz_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“G'e shi l'echilabọ ndu Ízurẹlu dufutaru ngu nwune ngu, bụ Erọnu; yẹle ụnwu iya, bụ Nadabu; yẹe Abihu; waa Eleyaza; yẹe Itama; g'ẹphe bụru ndu-uke; jejeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","L'a kwaaru nwune ngu, bụ Erọnu uwe, dụ nsọ; g'e shi nno mee ya g'ọ dụ akpabiri l'ẹnya; k'ọphu aa-kwabẹje iya ùbvù. ");
INSERT INTO izz_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Pfuaru ndu maru eme ọna; mbụ ndu mu meru g'ẹphe nweru mmamiphe g'ẹphe maru eme iphe, dụ nno; g'ẹphe kwaaru Erọnu uwe, ee-gude doo ya nsọ; k'ọphu ọo-bụru onye uke; jejeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Wakwa ẹgube uwe, ẹphe a-kwagbaaru iya bụ ọwa-a: uwe-ọkpoma; yẹe uwe-ukuvu; waa uwe-mgbalanụ; yẹe uwe ime-ẹhu; waa okpu-ẹkwa; yẹe ẹkwa-atụ-buta-l'upfu. G'ẹphe kwaaru nwune ngu, bụ Erọnu; waa ụnwu iya; uwe ono, dụ nsọ; k'ọphu ẹphe a-bụru ndu-uke; jejeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Iphe, ẹphe e-gude kwee ẹkwa uwe ono bụ owu, e meru lẹ mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa k'uswe-uswe; yẹe owu ọchaa, a swịru ụdo. ");
INSERT INTO izz_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“G'onye maru eme ọna gude ẹkwa, e kweru l'owu mkpọla-ododo; waa owu, eke urwukpu-urwukpu; waa ọphu eke mee-mee; waa k'uswe-uswe; waa k'ọchaa, a swịru ụdo; kpaa uwe-ukuvu. ");
INSERT INTO izz_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","G'a kwaa uwe ukuvu ono; woru wẹrere ẹkwa labọ yechaa ya l'ishi ukuvu iya ibe ẹka ẹbo. L'e gudeje wẹrere ẹkwa ono ẹphenebo lita k'atatiphu yẹe k'azụ. ");
INSERT INTO izz_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","L'e kwekwaphọ wẹrere ẹkwa, ee-gudeje tụ-buta iya l'upfu ye iya. Wẹrere ẹkwa ono bẹ yẹe uwe-ukuvu ono a-tụko bụru iphe lanụ. Iphe, ee-gude kwaa ya bụ owu, e meru lẹ mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe k'uswe-uswe; yẹe owu ọchaa, a swịru ụdo. ");
INSERT INTO izz_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Wota mkpuma ónìkùsù labọ; deshia ẹpha ụnwu Ízurẹlu l'eli iya. ");
INSERT INTO izz_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Deshia ẹpha ono lẹ g'e gude nwụshia phẹ. Ẹpha ishii bẹ ii-de lẹ mkpuma lanụ. L'i dee ẹpha ishii ọphuu lẹ mkpuma k'ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ọo g'onye apyịje mkpuma, vu oke aswa akashịje iya ẹpha; gude mee ya iphe-ọhubama-a bụ g'ịi-kakọta ẹpha ụnwu Ízurẹlu l'ophu l'eli mkpuma labọ ono. L'ị wụa mkpọla-ododo l'igburọnu mkpuma ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","L'ị dzụpyabe mkpuma labọ ono l'eli uwe-ukuvu phọ ẹphenebo; k'ọphu mụbe Chipfu e-gudeje iya nyata ụnwu Ízurẹlu. Ẹpha ụnwu Ízurẹlu ono a-dụ l'ukuvu Erọnu ẹphenebo g'ọ bụru iphe, mu e-gudeje nyata phẹ. ");
INSERT INTO izz_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","L'ị wụa mkpọla-ododo l'igburọnu mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","L'i gude owu ọkpobe mkpọla-ododo swịta ụdo gwọgirigwo labọ. L'i woru gwọgirigwo ono ẹphenebo lipfubechaa lẹ mkpọla-ododo ono, a wụru l'igburọnu mkpuma ono.” ");
INSERT INTO izz_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“G'onye maru eme ọna kwee uwe-ọkpoma, ee-gudeje achọ iphe, bụ uche mụbe Chipfu. G'e gude iphe ono, e gude kwee uwe-ukuvu ono kwee ya, bụ iya bụ owu, e meru lẹ mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; yẹe ọphu eke mee-mee; waa k'uswe-uswe; waa owu ọchaa, a swịru ụdo. ");
INSERT INTO izz_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","G'e kwekwaa ya g'o nweru mgburẹku ẹno; dụ nkwegba labọ. Gẹ mgburẹku iya ono ẹphen'ẹno tụkokwa harụ ẹnya nhamụnha. G'ogologo iya dụ nkwo-ẹka lanụ; ọsa iya adụkwapho nkwo-ẹka lanụ. ");
INSERT INTO izz_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","“Dzụpyabe mkpuma, vu oke aswa g'ọ kpọo giriri ụzo ẹno l'ẹkwa ono. Mkpuma, a-nọdu l'ogiri kẹ mbụ bụ rubi; yẹe tópàzù; waa bérìlù. ");
INSERT INTO izz_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","O -be l'ogiri k'ẹbo; bụ tọ̀kwásù; yẹe sáfàyà; waa émèràlụ̀dú bẹ ee-do iya. ");
INSERT INTO izz_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","O -bekwa l'ogiri k'ẹto; l'e doo ya jiásìntù; yẹe ágètù; waa ámìtìsùtù. ");
INSERT INTO izz_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Teke o beru l'ogiri k'ẹno; l'e doo ya kìrísòlàyìtù; yẹe ónìkùsù; waa jiásùpà; l'a wụa mkpọla-ododo l'igburọnu mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Iphe, ọo-dụ bụ mkpuma iri l'ẹbo. G'ẹphe ha nanụ nanụ nọ-chichaa ẹnya ụnwu Ízurẹlu. G'e dechaa ẹpha ụnwu Ízurẹlu ono lẹ mkpuma ono g'ọ dụ g'iphe-ọhubama nọchia ẹnya ọkpa-ipfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“L'i gude ọkpobe mkpọla-ododo swịshia ụdo gwọgirigwo, ee-lipfubegbaa l'uwe-ọkpoma ọbu. ");
INSERT INTO izz_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","L'i gude mkpọla-ododo meta echi labọ; yechaa l'ishi uwe-ọkpoma ono. ");
INSERT INTO izz_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","L'i woru gwọgirigwo phọ libechaa l'echi ono, e yegbaaru l'ishi uwe-ọkpoma ono. ");
INSERT INTO izz_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","L'e wota ishi gwọgirigwo ono ishi iya ọphuu lipfubekwaphọ lẹ mkpọla-ododo phọ, a wụru l'igburọnu mkpuma labọ phọ, e lipfuberu l'eli uwe-ukuvu phọ. ");
INSERT INTO izz_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","L'i gude mkpọla-ododo meta echi labọ ọzo; lipfube l'ishi uwe-ọkpoma phọ l'ụzo alị iya. Lipfubekwa iya l'ime uwe-ọkpoma ọbu; ibiya ọphu tukoru l'eli uwe-ukuvu ono. ");
INSERT INTO izz_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","L'i gude mkpọla-ododo metafua echi labọ ọzo; libechaa l'ishishi wẹrere ẹkwa labọ phọ l'ụzo alị iya; mbụ wẹrere ẹkwa ono, e liberu l'eli uwe-ukuvu ono. Libekwa iya l'eli ẹka ono, a nmarụ wẹrere ẹkwa, a tụ-butaru l'upfu uwe-ukuvu ono. ");
INSERT INTO izz_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Echi k'uwe-ọkpoma phọ bẹ ee-gude eri, e gude owu, dụ urwukpu-urwukpu swịa; libechaa l'echi uwe-ukuvu ọbu; k'ọphu ọo-nọdu lẹ mgboru wẹrere ẹkwa, atụ-buta l'upfu phọ; g'uwe-ọkpoma phọ ta nọdujeshi akụ pẹepee l'eli uwe-ukuvu ono. ");
INSERT INTO izz_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Ọo ya bụ; g'ọ bụru teke Erọnu abahụ l'ẹka-dụ-nsọ; ẹpha ụnwu Ízurẹlu anọdu iya l'obu; mbụ l'ẹpha ono a-nọdu l'uwe-ọkpoma, eegudeje achọ iphe, bụ uche Chileke; shi nno mee gẹ Chipfu gudeje iya nyata phẹ tekenteke. ");
INSERT INTO izz_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","L'i yekọbefukwapho ido, Urimu waa Tumimu l'uwe-ọkpoma ọbu; g'ọ tụ-kojeru Erọnu l'obu l'iphe, bụkpoo teke ọobya l'atatiphu Chipfu. Noo gẹ Erọnu e-gudeje parụ iphe, eegudeje achọ iphe, bụ uche Chileke l'ẹhu ndu Ízurẹlu bya l'atatiphu Chipfu tekenteke bụ ono.” ");
INSERT INTO izz_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Gude ẹkwa, dụ urwukpu-urwukpu kwee uwe mgbalanụ, ee-yeje uwe-ukuvu ono l'eli iya. ");
INSERT INTO izz_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kwekwaa ya g'ẹka, eepyoje iya ishi nọdu iya l'echilabọ. L'i swia igburọnu iya ọnu g'eeswije olu uwe-a; g'ọ tọ lakahụ. ");
INSERT INTO izz_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe ọphu dụ uswe-uswe; kpachaaru akpụru itorokuma; dophee ọnu uwe ono mgburugburu. L'i gudekwaphọ mkpọla-ododo meshia ọkunmengu dokahajẹ iya l'echilabọ. ");
INSERT INTO izz_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","G'ọkunmengu mkpọla-ododo ono; waa itorokuma ono; nọ-phekwaa igburọnu uwe ono mgburugburu. L'e dongakọta phẹ edonga l'ọnu uwe ono. ");
INSERT INTO izz_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Gẹ Erọnu yeje iya m'ọ nọdu eje ozi l'atatiphu Chipfu; g'ọ tọ nwụhu. Ọda ọkunmengu ono bẹ aa-nọduje anụ m'ọ nọdu abahụ l'ẹka-dụ-nsọ ono; waa m'ọ lụfutashia. ");
INSERT INTO izz_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Gude ọkpobe mkpọla-ododo meta iphe, dụ g'okwekpu; dee ya iphe g'eedeje gude mee iphe-ọhubama-a. Iphe, ee-de iya bụ: Onye-a dụru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","L'i wota eri, e gude owu, dụ urwukpu-urwukpu swịa; libe l'iphe ono, dụ g'okwekpu ono; woru iya lipyabẹ l'atatiphu okpu-ẹkwa phọ. ");
INSERT INTO izz_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Erọnu -kpuru okpu-ẹkwa ono; g'ọ nọdu iya l'egedegee ọnu-iphu; g'ọ bụru yẹbedua bẹ ọo-tụ-koru l'ishi; mbụ atụrwu, a atụrwuru iphe, ndu Ízurẹlu doberu Chipfu nsọ; m'obeta ọ bụru iphe, dụ ịdu-agha bẹ ẹphe doberu mu nsọ ọbu. Iphe ono, dụ g'okwekpu ono a-nọdujeepho Erọnu l'egedegee ọnu-iphu; g'iphe ono, e doberu nsọ ono adụkwanu mụbe Chipfu ree k'anata. ");
INSERT INTO izz_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“L'i gude owu ọchaa kwee uwe ime-ẹhu phọ; yẹe okpu-ẹkwa phọ. G'ọ bụkwaru onye maru egude ngga kwee ẹkwa bẹ e-me ẹkwa-atụ-buta-l'upfu phọ. ");
INSERT INTO izz_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","A -bya l'ẹhu ụnwu Erọnu; kweeru phẹ uwe-ime-ẹhu; yẹe ẹkwa-atụ-buta-l'upfu; waa okpu ndu-uke; g'e shi nno mee phẹ g'ẹphe dụ akpabiri l'ẹnya; k'ọphu aa-kwabẹje phẹ ùbvù. ");
INSERT INTO izz_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I -yechaẹpho nwune ngu Erọnu; waa ụnwu iya uwe ono; l'ị wụa phẹ manụ l'ishi; gude mee g'ẹphe bụru ndu-uke. L'i dobe phẹ iche g'ẹphe bụru ndu-uke; jejeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“L'i gude ẹkwa ọchaa metaru phẹ nwịba, ẹphe e-yeje. G'ẹphe yeje iya g'ọ gbẹ ẹphe l'upfu rwua phẹ l'ụtapfu. ");
INSERT INTO izz_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Gẹ Erọnu; yẹe ụnwu iya yejekwa nwịba ono m'ẹphe nọdu abahụ l'ụlo-ẹkwa-ndzukọ ono; ọzoo l'ẹphe eje ejeru mụbe Chipfu ozi l'ọru-ngwẹja, nọ l'ẹka-dụ-nsọ; k'ọphu ẹphe tee metadu iphe-ụta kpua onwophẹ; shi nno nwụshihu. “G'ekemu ono dụkwaru Erọnu; yẹe awa iya jasụ lẹ tuutuutuu lẹ mịimiimii.” ");
INSERT INTO izz_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Waa iphe, ii-me gude dobe phẹ nsọ; k'ọphu ẹphe a-bụru ndu-uke; jejeru mu ozi bụ ọwa-a: Kpụta nwa oke-eswi lanụ; waa ebili labọ, enwedu ẹka ntụcha dụ iya l'ẹhu; ");
INSERT INTO izz_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","l'i gude ukpokutu iphe, e yedụru iphe, ekoje buredi; gude ghee buredi. Hatakwa iya phọ gwọo lẹ manụ; gude ghee akara. L'i gudekwa iya phọ ghee ẹcha-mbekee, a gbashịru manụ. ");
INSERT INTO izz_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","L'ị tụko iya gwerụ ye lẹ nkata pataru mu; ẹphe l'oke-eswi phọ; yẹe ebili labọ phọ. ");
INSERT INTO izz_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","E -mechaa nno; l'i duta Erọnu; yẹe ụnwu iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ; gude mini wụa phẹ ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","L'ị chịta uwe ndu-uke phọ yee Erọnu. Vuru ụzo yee ya uwe ime-ẹhu phọ; tẹme l'i yee ya uwe mgbalanụ phọ, ee-ye uwe-ukuvu l'eli iya phọ. L'ị gbẹ teke ono yee ya uwe-ukuvu ono l'onwiya; mẹfua uwe-ọkpoma phọ. L'i gude wẹrere ẹkwa phọ, e kweru g'e gudeje tụ-buta uwe-ukuvu ono; gude tụ-buta iya. ");
INSERT INTO izz_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","L'i wota okpulishi-ẹkwa phọ kpube iya; wota iphe, dụ g'okwekpu phọ, e doberu nsọ phọ libe l'okpulishi ono. ");
INSERT INTO izz_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","L'i wota manụ, aawụje l'ishi wụa ya l'ishi gude mee ya onye uke. ");
INSERT INTO izz_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","L'i duta ụnwu iya yeshia phẹ uwe mgbalanụ; ");
INSERT INTO izz_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","bya ewochaaru okpu ndu-uke kpubegbaa phẹ l'ishi. L'i wotakwaphọ ẹkwa-atụ-buta-l'upfu phọ; webegbaa Erọnu; yẹe ụnwu iya l'upfu. Ekemu, mụbe Chipfu tụru phẹ bụkwa g'ẹphe bụru ndu-uke jasụ lẹ tuutuutuu lẹ mịimiimii. Nokwa g'ii-gude mee Erọnu; yẹe ụnwu iya g'ẹphe bụru ndu-uke bụ ono. ");
INSERT INTO izz_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“E -meẹbechaa nno; l'ị kpụta oke-eswi phọ gude bya l'ọnu-abata ụlo-ẹkwa-ndzukọ ono. Gẹ Erọnu; yẹe ụnwu iya byabẹ iya ẹka l'ishi; ");
INSERT INTO izz_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","l'ị nọdu l'iphu Chipfu gbua ya l'ọnu-abata ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","L'i meta mee oke-eswi ono gude mkpụshi-ẹka ngu tee ya lẹ mpu, nọgbaa l'ọru-ngwẹja ono. L'i woru ọphu ghuduru nụ wụshia l'ọkpali ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tụko ẹba, nọkota l'iphe-ẹpho iya g'ọ ha heta. L'ị bọtakwapho anya iya; waa àkpụrù iya ẹphenebo; yẹe ẹba, nọkota iya nụ; kpọo ọku l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Anụ oke-eswi ono; waa akpọ iya; yẹe nshị iya bẹ ii-gude je akpọo ọku l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“L'ị kpụta ebili phọ nanụ gude bya gẹ Erọnu yẹe ụnwu iya byabẹ iya ẹka l'ishi; ");
INSERT INTO izz_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","l'i gbua ya; nakọbe mee ya; pata mee ya ono phedzuru lẹ mgburẹku ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","L'i bushia anụ ebili ono iphiriba iphiriba; chịta iphe-ẹpho iya; yẹe ọkpa iya; saa asasa. L'i woru iphe-ẹpho iya ono; yẹe ọkpa iya ono; chịkobe l'ishi iya; yẹe iphiriba iphiriba iya phọ. ");
INSERT INTO izz_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","L'ị tụko anụ ebili ono g'ọ ha kpọo ọku l'ọru-ngwẹja ono. G'ọ bụru ngwẹja, a kpọru ọku nụ Chipfu; mkpọ iya dụ iya ree. ");
INSERT INTO izz_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“L'ị kpụta ebili ọphuu gude bya gẹ Erọnu yẹe ụnwu iya byabẹkwa iya phọ ẹka l'ishi; ");
INSERT INTO izz_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","l'i gbua ya; harụ mee ya meta; tee Erọnu; yẹe ụnwu iya l'atakpa-nchị ẹkutara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; waa lẹ mkpụshi-ọkpa ezeke-ọkpa ẹkutara. L'i woru mee ono phedzuru lẹ mgburẹku ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","L'i meta mee ono, sụru l'ọru-ngwẹja ono; metakwaphọ manụ awụ l'ishi phọ phedzuru Erọnu l'ẹhu; phekọta iya l'uwe iya; phedzukwaru iya phọ ụnwu Erọnu; mẹ l'uwe phẹ. Noo g'ee-shi mee gẹ Erọnu; yẹe ụnwu iya; waa uwe phẹ; dụ nsọ bụ ono. ");
INSERT INTO izz_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ebili ono bẹ ii-heshikọta ẹba; hetachaa ẹba, dụ l'upfumọdzu iya; waa ẹba, nọkota l'iphe-ẹpho iya g'ọ ha; bọtakwapho anya iya; waa àkpụ̀rù iya ẹphenebo; yẹe ẹba, nọkota iya nụ. L'i wota ụtapfu ọkpa ẹkutara iya tụkwase iya. Ebili ono bụkwa ọphu e gude eme Erọnu yẹe ụnwu iya g'ẹphe bụru ndu-uke. ");
INSERT INTO izz_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","L'i je lẹ nkata ono, e yeru buredi, e gudedu iphe, ekoje buredi ghee ono, nọwaa l'iphu Chipfu ono; hata iya ishi buredi lanụ; hatakwaphọ ishi akara lanụ l'akara ono, a gwọru lẹ manụ ghee ono; waa ẹcha-mbekee lanụ. ");
INSERT INTO izz_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","L'ị tụko iphemiphe ono g'ọ ha dẹe Erọnu; yẹe ụnwu iya l'ẹka g'ẹphe woru iya maa l'atatiphu Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","E -mechaa nno; l'ị nata phẹ iphemiphe ono; l'ị tụko yẹle ngwẹja-akpọ-ọku phọ kpọo ọku l'ọru-ngwẹja ono; g'ọ bụru ngwẹja, a kpọru ọku; nụ Chipfu; mkpọ iya dụ iya ree. ");
INSERT INTO izz_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","E -mechaa; l'i wota ǹdụ́ ebili ono, e gude mee Erọnu g'ọ bụru onye uke ono; woru maa l'iphu Chipfu g'ọ bụru ngwẹja-amama. Ono a-bụru oke iya nkengu. ");
INSERT INTO izz_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Anụ ebili ono, e gude mee Erọnu g'ọ bụru onye uke ono bẹ ii-do nsọ; mbụ ẹka ono, rwuberu Erọnu; yẹe ụnwu iya ono, bụ iya bụ ǹdụ́ iya phọ, a màru amàmà phọ; waa ụtapfu iya phọ, e doberu mụbe Chipfu phọ. ");
INSERT INTO izz_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ndu Ízurẹlu -gude iphe ngwẹja bya; gẹ ǹdụ́ iya; waa ụtapfu iya bụjekwaru oke, aa-hẹje Erọnu yẹe ụnwu iya. Ono bụ okiphe ọphu ndu Ízurẹlu e-dobejeru mụbe Chipfu iche m'ẹphe bya egwe ngwẹja-ẹhu-guu. ");
INSERT INTO izz_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Uwe, dụ nsọ kẹ Erọnu ono bẹ a-bụkwarupho k'awa iya. Ọ bụru uwe ono bẹ ẹphe e-yeje teke aawụ phẹ manụ gude eme phẹ g'ẹphe bụru ndu-uke. ");
INSERT INTO izz_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Gẹ nwa Erọnu onye ọphu eeme g'ọ nọchia ẹnya iya l'ọkwa uke; jeje l'ụlo-ẹkwa-ndzukọ; je ejee ozi l'ẹka-dụ-nsọ; yejekwa uwe ono ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Wota anụ ebili ono, e gude mee Erọnu; ọ bụru onye uke ono; je eshia l'ẹka dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Gẹ Erọnu yẹe ụnwu iya nọdu l'ọnu-abata ụlo-ẹkwa-ndzukọ taa anụ ebili ono; waa buredi phọ, e yeru lẹ nkata phọ. ");
INSERT INTO izz_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ọ kwa ẹphebedua a-ta anụ ngwẹja ono, e gude pfụa ụgwo iphe-ẹji phẹ; teke aawụ phẹ manụ l'ishi; e shi nno dobe phẹ nsọ g'ẹphe bụru ndu-uke. G'ọ tọ dụkwa onye ọzo, a-ta iya nụ; noo kẹle ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ọ -bụru l'ọ dụru anụ ebili ono, e gude mee Erọnu; ọ bụru onye uke ono; ọzoo buredi phọ; ọphu a taphodoru; ọ kwaa akwakwa fụta l'ụtsu; g'e jekwa akpọo ya ọku. G'o tọ dụkwa onye a-ta iya nụ; kẹle ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Sụ-a; mekwaaru Erọnu yẹe ụnwu iya iphe, mu tụru ngu ekemu sụ g'i meeru phẹ-a. Gude ujiku ẹsaa mee phẹ g'ẹphe bụru ndu-uke. ");
INSERT INTO izz_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Gbujekwa oke-eswi mbọkumboku l'ime ujiku ẹsaa ono g'ọ bụru ngwẹja-iphe-ẹji, e gude apfụ ụgwo iphe-ẹji. Nokwaphọ g'ii-gwe ngwẹja-iphe-ẹji gude pfụa ụgwo iphe-ẹji; shi nno safụ emeswe, dụ l'ọru-ngwẹja ono. Tẹme l'ị wụkwaa ya phọ manụ gude mee ya g'ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Gude ujiku ẹsaa gwee ngwẹja, e gude apfụ ụgwo iphe-ẹji; shi nno safụ ntụrwu, dụ l'ọru-ngwẹja ono; k'ọphu ọo-dụ nsọ. Ọo ya bụ g'ọ dụ nsọ shii; k'ọphu iphemiphe, rwuru iya nụ a-dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Mbọkumboku bụ iphe, ii-gudeje gwee ngwẹja ono l'ọru-ngwẹja ono bụ nwatụru labọ, nọgbaaru mgbarapha. ");
INSERT INTO izz_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Gbua nanụ l'ụtsu; l'i gbua nanụ ọphuu l'ụzenyashi. ");
INSERT INTO izz_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Atụru kẹ mbụ phọ bẹ ii-yekọbeje ukpokutu iphe je egwee; mbụ ụzo lanụ l'ime nkwẹka ukpokutu iphe, e keru ụzo iri; gwọo lẹ manụ, a tsụru l'ikwe; manụ, e-ji eze ekpemu ẹno. L'i wotakwaphọ nkeru-ẹno ọtu-lupfu otumu mẹe; ye iya g'ọ bụru ngwẹja-mẹe. ");
INSERT INTO izz_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","O -be l'ụzenyashi; l'ị kpụta atụru ọphuu gbua. L'i yekọbekwa iya phọ ngwẹja-nri; waa ngwẹja-mẹe g'e yeru lẹ k'ụtsu phọ; g'ọ bụru ngwẹja, a kpọru ọku nụ Chipfu; mkpọ iya dụ iya ree. ");
INSERT INTO izz_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“G'e gwejekwa ngwẹja-akpọ-ọku-a tekenteke l'ọnu-abata ụlo-ẹkwa-ndzukọ, bụ iya bụ l'atatiphu mụbe Chipfu; e -shi l'ọgbo sweru ọgbo. Ọo l'ẹka ono bẹ mu a-byapfuta ngu bya epfuru yeru ngu. ");
INSERT INTO izz_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ọ bụkwarupho ẹka ono bẹ mu a-byapfuta ndu Ízurẹlu; ogbunwịinwii mu emee ẹka ono l'ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Noo gẹ mu e-shi mee g'ụlo-ẹkwa-ndzukọ ono; yẹe ọru-ngwẹja ono; dụ nsọ; mekwaphọ gẹ Erọnu; yẹe ụnwu iya; dụ nsọ; bụru ndu-uke; jejeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Teke ono; mu eburu l'echilabọ ndu Ízurẹlu bụru Chileke phẹ. ");
INSERT INTO izz_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ọo ya bụ g'ẹphe amaru l'ọo mbẹdua bụ Chipfu, bụ Chileke phẹ; onye dufutaru phẹ l'alị Ijiputu gẹ mu eburu l'echilabọ phẹ. Ọo mbẹdua bụ Chipfu, bụ Chileke phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Gude oshi akesha kụa ọru-ngwẹja, bụ ẹka aa-kpọje ụ̀nwù-isẹnsu ọku. ");
INSERT INTO izz_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","G'ogologo iya waa ọsa iya tụkokwa harụ ẹnya nhamụnha. Iphe, ọo-dụchaa bụ nkwo-ẹka lanụ. Eli iya adụ nkwo-ẹka labọ. Gẹ mpu iya; yẹe ọru-ngwẹja ono rwagbakwaa bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Wụkotakwa eli iya; yẹe mgburẹku iya; waa mpu iya ọkpobe mkpọla-ododo. L'i gudekwaphọ mkpọla-ododo kpụ-phee mgburẹku iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","L'i meta echi mkpọla-ododo ẹbo ẹbo yegbaa lẹ mgburẹku iya ibekẹboebo. Yekwa iya g'ọ nọduchaa lẹ mkpula iphe ono, a kpụ-pheru iya mgburugburu ono. Ọ bụru l'echi ono bẹ ee-yeje mgbọro, ee-gudeje apa iya. ");
INSERT INTO izz_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gude oshi akesha pyịta mgbọro ono; wụa ya mkpọla-ododo. ");
INSERT INTO izz_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","L'i dobe ọru-ngwẹja ono l'iphu ẹkwa phọ, e gude kochite okpoko-ekemu; mbụ opfu okpoko phọ, aa-nọduje apfụ ụgwo iphe-ẹji phọ, e gude kpuchia okpoko-ekemu. Ọo ẹka ono bụ ẹka mu a-byapfutajẹ ngu. ");
INSERT INTO izz_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Gẹ Erọnu kpọjekwa ụ̀nwù-isẹnsu, eshi mkpọ ọku l'ọru-ngwẹja ono l'ụtsu mẹ o -jeshia emezi orọku phọ. ");
INSERT INTO izz_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","G'ọ kpọjekwapho ụ̀nwù-isẹnsu ọku l'ọru-ngwẹja ono l'ụzenyashi mẹ o -jeshia eye ọku l'orọku ono; k'ọphu ọku ụ̀nwù-isẹnsu a-nọduje enwu l'atatiphu Chipfu; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","G'ọ tọ dụkwa ụ̀nwù-isẹnsu ọzo, gbaru iche, ee-gudeje bya akpọo ọku l'ọru-ngwẹja ono. Ọphu e gudejekwa ngwẹja-akpọ-ọku; ọzoo ngwẹja-nri; ọzoo ngwẹja-mẹe bya l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ugbo lanụ l'apha bẹ Erọnu e-teje mee lẹ mpu ọru-ngwẹja ono gude pfụa ụgwo iphe-ẹji. Ọ bụru mee anụ ngwẹja-iphe-ẹji, e gude apfụ ụgwo iphe-ẹji; bẹ ee-teje lẹ mpu ono aphagapha. G'e mejekwa iya nno; e -shi l'ọgbo sweru ọgbo. Ẹka ono bụkwa ẹka kachaa adụru mụbe Chipfu nsọ.” ");
INSERT INTO izz_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Teke ịi-gụ ndu Ízurẹlu ọgu g'ị maru g'ẹphe ha; g'onyenọnu pfụjekwa mụbe Chipfu aswa ishi onwiya gude gbata onwiya; mẹ a gụe ya phọ. Ọo ya bụ g'ọ tọ dụ ẹjo iphe-ẹhuka, a-byapfuta phẹ nụ teke aa-gụ phẹ ọgu ọbu. ");
INSERT INTO izz_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","G'onye a gụru pfụjekwa okpoga mkpọla-ọchaa, ẹrwa iya rwuru nkeru-ẹbo shẹkelu; tẹme l'o jepfu ndu ọphu a gụwaru. G'ẹrwa shẹkelu ono, onye ono a-nụ ono bụkwaru iphe, eegudeje atụ̀ ẹrwa iphe l'eze-ụlo mụbe Chileke bẹ ee-gude tụ̀a ya. Ẹrwa shẹkelu lanụ bụ ụkporo gera. Ọ bụru nkeru-ẹbo ẹrwa shẹkelu ono bẹ a-bụru iphe, ee-doberu mụbe Chipfu iche. ");
INSERT INTO izz_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Iphe, bụ onye a gụru ọgu; a -gbẹ l'onye nọru ụkporo apha kwasẹru bẹ a-nụ mụbe Chipfu iphe. ");
INSERT INTO izz_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Gẹ ndu nweru iphe ta nụghatakwa nkeru-ẹbo ẹrwa shẹkelu ono; ọphu ndu ụkpa anụ-petekwanụ iya; mẹ unu -nọdu anụ mụbe Chipfu iphe unu gude pfụa ụgwo iphe-ẹji, unu meru. ");
INSERT INTO izz_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nata okpoga ndu Ízurẹlu ono, e gude apfụ ụgwo iphe-ẹji phẹ ono; gude jee ozi l'ụlo-ẹkwa-ndzukọ ono. Ono bụ iphe, mụbe Chipfu e-gude anyata ndu Ízurẹlu; bya abụru iphe, ee-gude pfụa ụgwo iphe-ẹji, ẹphe meru.” ");
INSERT INTO izz_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Gude onyirubvu mee eze gbamụgbamu, ee-gudeje wụa ẹhu. Gudekwa iya phọ mee ọkpa iya. L'ị sụbe iya lẹ mgbaka ụlo-ẹkwa-ndzukọ ono; yẹe ọru-ngwẹja ono; kuru mini ye iya. ");
INSERT INTO izz_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Gẹ Erọnu; yẹe ụnwu iya kwọje ẹka yẹe ọkpa lẹ mini ono. ");
INSERT INTO izz_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ẹphe -nọdu abahụ l'ụlo-ẹkwa-ndzukọ ono; ọzoo l'ẹphe ejekube ọru-ngwẹja ono eje anụ mụbe Chipfu ngwẹja, aakpọ ọku; g'ẹphe kwọshijekwa onwophẹ mini; k'ọphu ẹphe ta anwụshihudu. ");
INSERT INTO izz_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Mbụ-a; g'ẹphe kwọjekwaa ẹka yẹe ọkpa; k'ọphu ẹphe ta anwụshihudu. Ono bụ ekemu, a-dụru Erọnu; yẹe awa iya; e -shi l'ọgbo sweru ọgbo.” ");
INSERT INTO izz_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Wota ọkpobe iphe, eshi mkpọ gude bya. Iphe, ii-wota bụ: Mẹru mini ọphu ẹrwa iya dụ ụnu shẹkelu l'ụkporo shẹkelu ise; waa sịnamonu, eshi mkpọ ọphu ẹrwa iya dụ ụkporo shẹkelu iri l'ẹbo lẹ shẹkelu iri, bụ iya bụ nkeru-ẹbo mẹru phọ; waa oshi ọmanko, eshi mkpọ ọphu ẹrwa iya dụ ụkporo shẹkelu iri l'ẹbo lẹ shẹkelu iri; ");
INSERT INTO izz_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","waa kashiya ọphu ẹrwa iya dụ ụnu shẹkelu l'ụkporo shẹkelu iri. G'ọ ha bụkwaru iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo mụbe Chileke bẹ ee-gude tụa ya. L'i wotakwaphọ manụ olivu, jiru eze ekpemu ẹno. ");
INSERT INTO izz_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","G'onye maru eme manụ-mbeleke tụko iphemiphe ono gwakọbe g'ọ bụru manụ, dụ nsọ bya eshi mkpọ, aawụje l'ishi. Ọo-bụru manụ, dụ nsọ, aa-wụje l'ishi. ");
INSERT INTO izz_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","L'i gude manụ ono wụ-dzuru ụlo-ẹkwa-ndzukọ; waa okpoko-ekemu; ");
INSERT INTO izz_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","waa teburu; yẹe iphemiphe, nọkota iya nụ; waa iphe, aapfụbeje orọku; yẹe ngwa iya g'ọ ha; waa ọru-ngwẹja ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","waa ọru-ngwẹja, bụ ẹka ee-gweje ngwẹja-akpọ-ọku; yẹe ngwa iya g'ọ ha; waa eze gbamụgbamu; yẹe ọkpa iya. ");
INSERT INTO izz_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tụko iphemiphe ono doo nsọ; g'ọ bụru iphe, kakọta nsọ; g'ọ bụru iphe, rwutakpọru iya nụ; l'ọ dụkwapho nsọ. ");
INSERT INTO izz_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Wụa Erọnu; yẹe ụnwu iya manụ l'ishi; doo phẹ nsọ; k'ọphu ẹphe a-abụru ndu-uke jeahaarụ mụbe Chipfu ozi. ");
INSERT INTO izz_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Pfuaru ndu Ízurẹlu l'ọwa-a bụ manụ mu, dụ nsọ, aa-wụje l'ishi; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","G'a ta wụjekwa iya nemadzụ mmanụ; tẹme ọphu agwajẹkwa manụ ọzo g'ọ dụ g'ọwa-a. Ọ kwa manụ, dụ nsọ. Ọo ya bụ g'e dobeje iya nsọ. ");
INSERT INTO izz_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ọ -dụru onye gwarụ manụ ọzo; ọ dụ gẹ manụ ọwa-a; ọzoo l'ọ wụru iya nemadzụ mmanụ l'ishi, abụdu onye uke; g'e bufukwa iya lẹ ndu nkiya.” ");
INSERT INTO izz_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Noo ya; Chipfu sụ Mósisu: “Wota iphe, eshi mkpọ gude bya. Iphe ii-wota bụ: etse; yẹe onika; waa galubanumu; yẹe ọkpobe furankisẹnsu. Tụa ya l'iphe, eegudeje atụ ẹrwa iphe g'ọ tụko harụ ẹnya nhamụnha. ");
INSERT INTO izz_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","G'onye maru eme manụ-mbeleke tụko iphemiphe ono gwakọbe g'ọ bụru ụ̀nwù-isẹnsu, eshi mkpọ. G'a pyashị iya únú. G'ọ bụkwaru iphe ono, a gụshiru ono kpoloko bẹ ee-gude mee ụ̀nwù-isẹnsu ọbu. Ọo-bụru ụ̀nwù-isẹnsu, dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Harụ iya gwee egwegwe dobe l'atatiphu okpoko-ekemu, nọ l'ụlo-ẹkwa-ndzukọ, bụ iya bụ ẹka ono, mu a-byapfuta unu ono. G'ọ bụkwaru unu ụ̀nwù-isẹnsu, kakọta adụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Unu te emekwa ụ̀nwù-isẹnsu k'unu g'ọ dụ g'ọwa-a. Unu doberu iya mụbe Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ọ -dụru onye meru ụ̀nwù-isẹnsu ọzo, dụ g'ọwa-a; doberu onwiya gẹ manụ-mbeleke; g'e bufukwa iya lẹ ndu nkiya.” ");
INSERT INTO izz_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Lenu; mu họtawaru Bezalẹlu nwa Uri, bụ nwanwa Huru; onye ọkpa-ipfu Jiuda; ");
INSERT INTO izz_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","bya emewaa; unme mụbe Chileke ji iya ẹhu; g'o nweru mmamiphe; yẹe nkwamẹnya; g'iphe edoje iya ẹnya ree; k'ọphu ọo-makọtaru g'eemema iphemiphe emema; ");
INSERT INTO izz_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","g'ọ maru g'eemeje iphe-ẹrengete lẹ mkpọla-ododo; yẹe mkpọla-ọchaa; waa onyirubvu; ");
INSERT INTO izz_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","makwarụpho g'aawa mkpuma, aswa dụ; waa g'aawụje mkpọla-ododo l'igburọnu iya; bya amakwarụpho g'aapyịje iphe apyịpyi; mẹwaro g'eeshije eme ọna ọzo, dụgbaa iche iche. ");
INSERT INTO izz_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tẹme mu họtafuakwaru Oholiyabu nwa Ahisamaku; onye ọkpa-ipfu Danu; g'o yeru iya ẹka; bya anụkotakwapho ndu maru eme ọna g'ẹphe ha ike g'ẹphe mekọta iphemiphe, mu sụru g'unu mee. ");
INSERT INTO izz_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Iphe, ẹphe e-me bụ: ụlo-ẹkwa-ndzukọ; waa okpoko-ekemu; yẹe opfu okpoko ono, aanọduje apfụ ụgwo iphe-ẹji ono; mẹwaro iphemiphe ọzo, eegudeje eje ozi l'ime ụlo-ẹkwa ono; ");
INSERT INTO izz_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","dụnaa gẹ teburu; yẹe iphemiphe, nọkota iya nụ; waa iphe, aapfụbeje orọku, e meru l'ọkpobe mkpọla-ododo; yẹe ngwa iya g'ọ ha; waa ọru-ngwẹja ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","waa ọru-ngwẹja-akpọ-ọku; yẹe ngwa iya g'ọ ha; waa eze gbamụgbamu; yẹe ọkpa iya; ");
INSERT INTO izz_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","wafụa uwe, e kweru ekwekwe; mbụ uwe, dụ nsọ, Erọnu, bụ onye uke e-yeje; waa uwe, ụnwu iya e-yeje gude eje ozi ndu-uke; ");
INSERT INTO izz_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","waa manụ awụ l'ishi; waa ụ̀nwù-isẹnsu, eshi mkpọ k'ẹka-dụ-nsọ. Ọ bụepho g'ẹphe mee ya g'ọ dụ gẹ mu sụru ngu g'e mee ya.” ");
INSERT INTO izz_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Waa iphe ii-pfuru ndu Ízurẹlu baa: Unu ba adụkwa iphe unu e-jeje l'eswe-atụta-unme kẹ mụbe Chipfu. Ọwaa a-bụru iphe-ọhubama, a-nọdu l'echilabọ mu l'unu; e -shi l'ọgbo sweru ọgbo. Ọo ya bụ g'unu amaru l'ọo mbẹdua bụ Chipfu, bụ onye eme unu g'unu dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Unu nyatajẹ eswe-atụta-unme; noo kẹle mbọku ono dụru unu nsọ. Ọ -dụru onye dakaru iya nụ; g'e gbukwaa onye ọbu egbugbu. Iphe, bụ onye jeru ozi mbọku ono bẹ ee-bufu ebufu lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ọo ujiku ishii bẹ unu e-gudeje jee ozi unu. Mbọku k'ẹsaa bụ eswe Sabatụ, bụ iya bụ eswe-atụta-unme; bya abụru mbọku, dụru mụbe Chipfu nsọ. Ọ -dụru onye jeru ozi l'eswe-atụta-unme; g'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Gẹ ndu Ízurẹlu dobeje eswe-atụta-unme; mee ekemu iya; e -shi l'ọgbo sweru ọgbo; g'ọ bụru iphe, a-nọdu egoshi ọgbandzu mu l'unu jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ọo-bụru iphe-ọhubama, a-nọdu lẹ mgbaka mu lẹ ndu Ízurẹlu jasụ lẹ tuutuutuu lẹ mịimiimii; noo kẹle ọo ujiku ishi bẹ mụbe Chipfu gude mee igwe; yẹe alị. O -rwua lẹ mbọku k'ẹsaa; mu haa ozi; tụta unme.” ");
INSERT INTO izz_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Noo ya; Chipfu pfughechaẹpho opfu nụ Mósisu l'eli úbvú Sayịnayi; bya anụ iya bachịbachi mkpuma labọ, e deru Ekemu. Mkpuma ono bụ Chileke gude mkpụshi-ẹka iya dee ya iphe nwẹkiya. ");
INSERT INTO izz_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ndu Ízurẹlu nọnyaa bya asụ lẹ Mósisu anọnukawa ọdu l'eli úbvú ono; ẹphe bya edzukọbe gbaphee Erọnu mgburugburu bya asụ iya: “Ngwa; metaru anyi Chileke, a-nọdu edu anyi! Ọ -bụru Mósisu-a, dufutaru anyi l'alị ndu Ijiputu-a bẹ anyi ta amakwa iphe, meru iya nụ.” ");
INSERT INTO izz_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Erọnu sụ phẹ: “Unu yeshia iphe-nchị mkpọla-ododo, unyomu unu; waa ụnwu unu unwoke; mẹ k'ụnwanyi unu yeru lẹ nchị; chịtaru mu!” ");
INSERT INTO izz_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Noo ya; ndu ono g'ẹphe ha bya eyeshia iphe-nchị phẹ bya achịjeru Erọnu. ");
INSERT INTO izz_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ọ bya achịta iphe ono, ẹphe nụru iya ono gude meta agwa; bya akpụa ya; ọ dụ gẹ nweswi; bya egude ngwa ọru mee ya ọna. Noo ya; ẹphe sụ: “Unubẹ ndu Ízurẹlu; waa Chileke unu baa; mbụ onye dufutaru unu l'alị Ijiputu!” ");
INSERT INTO izz_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Noo ya; Erọnu hụmaepho iphe ono bya akpụa ọru-ngwẹja l'atatiphu nweswi ono bya araa sụ: “Echele bẹ a-bọ Chipfu!” ");
INSERT INTO izz_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ọo ya bụ; o rwua nchitabọhu iya; ndu Ízurẹlu tehu l'ọnma-ẹwa-ụtsu; bya egwee ngwẹja-akpọ-ọku; bya egweeru iya ngwẹja-ẹhu-guu. E -mechaa; ẹphe bya anọshia ria nri; bya angụa mẹe; bya awụ-lihu meahaa ẹmereme. ");
INSERT INTO izz_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Noo ya; Chipfu sụ Mósisu: “Nyize l'alị; noo kẹle ndu nkengu ono; mbụ ndu i dufutaru l'alị ndu Ijiputu ono bẹ merwushiwaru onwophẹ. ");
INSERT INTO izz_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ẹphe meru ẹgwegwa gbado ekemu ono, mu tụru phẹ ono; bya emetawaru onwophẹ agwa, ẹphe kpụru; ọ dụ gẹ nweswi. Ẹphe phozewaru ishi baarụ iya ẹja; bya agwawaa ya agwagwa sụ: ‘Unubẹ ndu Ízurẹlu; waa Chileke unu, bụ onye dufutaru unu l'alị Ijiputu baa!’ ” ");
INSERT INTO izz_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Chipfu sụ Mósisu: “Mu hụmawaru lẹ ndu-a bụnukaru ndu ẹjo-ọkpoma. ");
INSERT INTO izz_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nta-a bụkwa g'ị haa mu gẹ mu gude oke ẹhu-eghu mu dapfu phẹ bya emebyishia phẹ. Mu eworu gụbe Mósisu mee ọha, parụ ẹka.” ");
INSERT INTO izz_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mósisu rwọahaa Chipfu, bụ Chileke iya sụ: “Jiko Chipfu; g'ẹhu te eghunụkashi nụ ngu eghu nno l'opfu ẹhu ndu nkengu ono, i gude ọkpehu ngu dufuta l'alị Ijiputu ono nọ! ");
INSERT INTO izz_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gẹ ndu Ijiputu ta asụ l'iphe, kparụ iphe, i gude dufuta ndu nkengu bụ g'ị bya egbushia phẹ l'úbvú úbvú-a g'ẹphe chịhu lẹ mgboko. Jiko gbanaa mini l'obu; parụ haa; te emebyishishi nụ ndu nkengu. ");
INSERT INTO izz_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nyatanụ ndu-ozi ngu, bụ Ébirihamu; waa Áyizaku; waa Ízurẹlu, bụ ndu i gude ẹpha ngu riaru nte sụ l'ii-me awa phẹ g'ẹphe ha gẹ kpokpode, nọ l'igwe; tẹme l'ị nụ awa phẹ alị-a, i kwekọtaru phẹ ukwe iya-a; l'ọ bụwa okiphe phẹ jasụ lẹ tuutuutuu lẹ mịimiimii.” ");
INSERT INTO izz_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Noo ya; egomunggo lwa Chipfu azụ; o woru ẹjo iphe-ẹhuka ono, o shi epfu l'oo-gude byapfuta phẹ ono parụ haa. ");
INSERT INTO izz_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mósisu bya aghachi nyizetashịa l'eli úbvú ono; yẹe mkpuma labọ ono, dụ bachịbachi, e deru ekemu ono, o gude l'ẹka ono. Mkpuma ono bẹ e deru iphe l'iphu; dee ya l'azụ. ");
INSERT INTO izz_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mkpuma ono bụ Chileke gude ẹka iya mee ya. Iphe ono, e deru iya ono, bụru Chileke gude ẹka iya dee ya l'eli mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Noo ya; Jioshuwa nụmaepho ụzu, ndu Ízurẹlu atụ; ọ sụ Mósisu: “Aatụkwa ụzu ọgu l'ẹka anyi kpọberu ụlo-ẹkwa anyi.” ");
INSERT INTO izz_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mósisu sụ iya: “Ọ tọo dakwa g'ụzu ndu lwụ-kperu l'ọgu; ọphu ọ tọo dakwanụ g'ụzu ndu a lwụ-kperu. Iphe, mu anụ bụkwa ụzu ebvu.” ");
INSERT INTO izz_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mósisu bya erwua lẹ mgboru ẹka a kpọberu ụlo-ẹkwa ono; bya ahụma nweswi ono; waa ndu ete ebvu ono. Ẹhu kwatakpọo ghushia ya eghu ike; o woru mkpuma ono, ọ gude l'ẹka ono tụkposhia l'ọkpa úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ọ bya ewota nweswi ono, ẹphe kpụru ono tsua ọku bya egwee ya; ọ dụ gẹ ntụ; bya awụru iya ye lẹ mini; mee ndu Ízurẹlu; ẹphe ngụa ya. ");
INSERT INTO izz_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ọ sụ Erọnu: “?Bụ gụnu bẹ ndu-a kabẹkpoo mee ngu; meru g'o gude i duru phẹ ye l'eme iphe-ẹji, habe ẹgube-a?” ");
INSERT INTO izz_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Erọnu sụ iya: “Jiko g'ẹhu te eghukwa ngu eghu; nnajịuphu mu. Ị mahawarụ gẹ ndu-a bụ-be ndu gharu iphu l'eme ẹjo-iphe. ");
INSERT INTO izz_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ẹphe sụru gẹ mu metaru phẹ Chileke, a-nọdu edu phẹ nụ! Kẹle Mósisu, bụ onye dufutaru phẹ l'alị Ijiputu bẹ ẹphe ta amakwa iphe, meru iya nụ. ");
INSERT INTO izz_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ọo ya bụ; mu sụ phẹ: ‘G'onye nwekpọoru iphe, e meru lẹ mkpọla-ododo; yefụta iya.’ Noo ya; ẹphe chịtaru mu mkpọla-ododo ono; mu chịru iya ye l'ọku; iphe, shi iya nụ fụta bụru nweswi-a.” ");
INSERT INTO izz_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mósisu bya ahụma lẹ ndu Ízurẹlu zụwaru onwophẹ l'ẹka nafụ; lẹ Erọnu mewaru phẹ; ọphu ẹphe ekweẹdu g'a chịkobe phẹ; ẹphe nọdu emewaa phukuphuku l'iphu ndu ọhogu phẹ; ");
INSERT INTO izz_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ọ bya apfụru l'ọnu-abata ẹka a kpọberu ụlo-ẹkwa ono bya asụ: “Onye bụ kẹ Chipfu byapfuta mu!” Ndu Lívayi g'ẹphe ha wụ-pfuta iya. ");
INSERT INTO izz_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Noo ya; ọ sụ phẹ: “Waa iphe, Chipfu, bụ Chileke kẹ ndu Ízurẹlu pfuru baa: ‘G'onyenọnu kebe onwiya ogu-echi iya l'upfu; jee l'okotazụ; waa l'atatiphu; mẹkpoo l'ẹkameka l'ẹka a kpọberu ụlo-ẹkwa ono. G'onyenọnu gbushia nwanna iya; waa ọ̀nyà iya; mẹ obutobu iya.’ ” ");
INSERT INTO izz_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Oshilọkpa Lívayi bya emee gẹ Mósisu ziru phẹ. Ndu nwụshihuru nụ mbọku ono bẹ rwuru iphe, dụ g'ụnu ụmadzu ẹsaa l'ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Noo ya; Mósisu sụ: “A họtawaru unu doberu Chipfu iche ntanụ-a; noo kẹle unu tsoru ụnwu unu; mẹ unwune unu ọgu. Tẹme ọ gọwaru ọnu-ọma nụ unu ntanụ-a.” ");
INSERT INTO izz_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","O -rwua nchitabọhu iya; Mósisu sụ ndu Ízurẹlu: “Unu mekwarụ eze iphe-ẹji, parụ ẹka. Nta-a bẹ mu ejepfuwa Chipfu. ?A maru; mu a-dụ ike rwọ-buta iya g'ọ gụaru unu nvụ l'iphe-ẹji ono, unu meru ono?” ");
INSERT INTO izz_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ọo ya bụ; Mósisu bya ejepfu Chipfu bya asụ: “Oowaa! Iphe-ẹji, ndu-a meru kwatakwa paa ẹka! Ẹphe gudewaa mkpọla-ododo metaru onwophẹ agwa. ");
INSERT INTO izz_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ọle jiko gụaru phẹ rọ nvụ l'iphe-ẹji ono; teke ọ dụdu hufukwa ẹpha mu l'ẹkwo, i deru ẹpha ndu nkengu.” ");
INSERT INTO izz_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Chipfu sụ Mósisu: “Ọo onye mesweru mu nụ bẹ mu e-hufu ẹpha iya l'ẹkwo mu. ");
INSERT INTO izz_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ngwa; tụgbua nta-a je edurwua ndu Ízurẹlu ẹka mu pfuru opfu iya ono; lẹ Ojozi mu a-nọdu edu unu. Ọle o -rwuẹpho teke mu a-nụ phẹ aphụ; mu anụa phẹ iya k'iphe-ẹji phẹ.” ");
INSERT INTO izz_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Chipfu bya egude ẹjo iphe-ememe byapfuta ndu Ízurẹlu; k'iphe ono, ẹphe gude nweswi ono, Erọnu kpụru ono mee. ");
INSERT INTO izz_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ọo ya bụ; Chipfu sụ Mósisu: “Unu tụgbua l'ẹka-a; unu lẹ ndu ono, i dufutaru l'alị ndu Ijiputu ono! Tụgbua jeshia l'alị ono, mu kweru ukwe bya eriru nte yeru Ébirihamu; waa Áyizaku; waa Jiékọpu sụ: ‘Mu a-nụ iya awa unu.’ ");
INSERT INTO izz_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mu e-zi ojozi g'o duru unu je; je achịshiaru unu ndu Kénanu; waa ndu Amọru; waa ndu Hetu; waa ndu Pẹ́rezu; waa ndu Hevu; waa ndu Jiebusu. ");
INSERT INTO izz_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Unu tụgbua jeshia l'alị ono, bụ alị, mini ẹra-eswi; waa manụ-ẹnwu asọ gborogboro. Ọle mu te etsoduru unu; noo kẹle unu bụnukaru ndu ẹjo-ọkpoma; kẹle ọ -bụru gẹ mu tsoru unu bẹ o nwekwarụ g'ọo-dụ; mu emebyishia unu l'ụzo.” ");
INSERT INTO izz_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ndu Ízurẹlu nụmaepho njọ-nzi ono; ẹphe waa ẹkwa; ọphu ọ dụdu onye kwarụ onwiya akwa. ");
INSERT INTO izz_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Noo kẹle Chipfu sụru Mósisu: “Pfuaru ndu Ízurẹlu l'ẹphe bụnukaru ndu ẹjo-ọkpoma. Mbụ l'ọ -bụru gẹ mu tsoru unu hata mẹ ntụ-ọkpa lanụ bẹ o nwekwarụ g'ọo-dụ; mu emebyishia unu. Ngwa; unu kwashịa onwunu akwa, unu kwarụ gẹ mu chịa ìdzù iphe, mu e-me unu.” ");
INSERT INTO izz_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Noo ya; ndu Ízurẹlu woru akwa phẹ kwashịa l'úbvú Horẹbu. ");
INSERT INTO izz_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mósisu shi aphụtaje ụlo-ẹkwa je akpọbe ụzenya l'azụ ẹka ndu Ízurẹlu kpọbechaaru ụlo-ẹkwa nkephẹ; kua ya “ụlo-ẹkwa-ndzukọ.” Iphe, bụ onye eje akpata ishi l'iphu Chipfu nọdu ejeje l'ụlo-ẹkwa-ndzukọ ono, nọ l'azụ ẹka ndu Ízurẹlu nọ ono. ");
INSERT INTO izz_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ọ nọdu abụjeru; Mósisu -gbalihu jeshia l'ụlo-ẹkwa-ndzukọ ono; ndu Ízurẹlu g'ẹphe ha awulihu je apfụgbaaru l'ọnu-abata ụlo-ẹkwa nkephẹ elekpọepho Mósisu ẹnya; gbiriri jasụ l'ọobahu l'ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ọ nọdu abụjeru; Mósisu -bahụchaepho l'ụlo-ẹkwa ono; urwukpu ono, kpụru oronmono ono alwazeta bya anọ-chia ọnu-abata teke Chipfu epfu anụ Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ndu Ízurẹlu hụmaepho urwukpu ono, kpụru oronmono ono g'ọ nọ l'ọnu-abata ụlo-ẹkwa ono; ẹphe atụko gbẹshi baarụ Chipfu ẹja. Onyenọnu nọdu anọduje l'ọnu-abata ụlo-ẹkwa nkiya baarụ Chipfu ẹja ono. ");
INSERT INTO izz_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Chipfu nọdu epfuje eyeru Mósisu l'iphu l'iphu gẹ nemadzụ yẹe ọ̀nyà iya anọduje abọ ụja-a. Teke e mechaarụ; Mósisu alwaphuta azụ l'ẹka ndu Ízurẹlu nọ; ọphu nwokorọbya ono, bụ onye n-yemẹka iya ono, bụ Jioshuwa nwa Nunu alụfujedu alụfu l'ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mósisu sụ Chipfu: “I shiẹpho teke-a pfutaru mu gẹ mu dua ndu-a; ọle i tiki mekpọdaa gẹ mu maru onye ii-yeru mu gẹ mu l'iya swịru. Ị sụru l'ị maru ẹpha mu; tẹme mu dụ ngu l'obu. ");
INSERT INTO izz_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ọ -bụru phọ lẹ mu dụ ngu l'obu k'eviya; goshinu mu ụzo ngu; k'ọphu mu a-maru ngu; tẹme mu adụ ngu l'obu kwasẹru. Nyatakwa l'ọha-a bụ ndu nkengu.” ");
INSERT INTO izz_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Chipfu sụ iya: “Mu e-tsoru-a unu l'onwomu; tẹme mu emee gẹ meji nmapfuru ngu.” ");
INSERT INTO izz_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","No iya; Mósisu sụ iya: “Ọ -bụru l'i tii tsoduru anyi l'onwongu; te emekwa g'anyi hata ọkpa ahata tụgbua l'ẹka-a! ");
INSERT INTO izz_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","?Dẹnu g'ee-shi maru lẹ mbẹdua; waa ndu nkengu dụ ngu l'obu; abụdu l'i tso anyi? ?Bụ gụnu ọzo e-goshi lẹ mbẹdua waa ndu nkengu dụ iche l'ẹka ndu mgboko l'ophu nọ?” ");
INSERT INTO izz_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ọo ya bụ; Chipfu sụ Mósisu: “Mu e-meẹpho iphe ono, ị sụru gẹ mu meeru ngu ono. Noo kẹle ị dụ mu l'obu; tẹme mu maru ẹpha ngu.” ");
INSERT INTO izz_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mósisu sụ iya: “Jiko goshinu mu ogbunwịinwii ngu.” ");
INSERT INTO izz_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Tọbudu iya bụ; Chipfu sụ iya: “Mu e-me g'ị hụma gẹ mu dụ-be ree; tẹme mu anọdu l'atatiphu ngu kua onwomu iphe, mu aza. Onye ọ dụ mu gẹ mu meeru eze-iphe-ọma; mu emeeru iya ya; onye ọ dụ mu gẹ mu phụaru obu-imemini; mu aphụaru iya ya. ");
INSERT INTO izz_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ọle ị tịi hụmadu iphu mu; noo kẹle o to nwedu onye gude ẹnya iya hụma mu, a-nọdu ndzụ.” ");
INSERT INTO izz_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Chipfu sụ: “O nweru ẹka nọ-kube mu nụ, ịi-pfụru lẹ mkpuma. ");
INSERT INTO izz_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Teke ogbunwịinwii mu ghatajẹerupho; mu eworu ngu dobe lẹ mgbaka agbara-mkpuma; bya egude ẹka mu gbobuta ngu; gbiriri jasụ mu aghata-gbua. ");
INSERT INTO izz_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mu agbẹ teke ono wofu ẹka; l'ị hụma mu okpurukpu. Ọ -bụru iphu mu bẹ a taa hụmajekwa ahụma.” ");
INSERT INTO izz_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Chipfu sụ Mósisu: “Je awata bachịbachi mkpuma labọ ọzo, a-dụ gẹ kẹ mbụ phọ. Gẹ mu dekwaa ya iphe, shi nọdu lẹ kẹ mbụ phọ, ị tụkporu phọ. ");
INSERT INTO izz_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kwakọbe l'ụtsu echele; nyikota úbvú Sayịnayi; bya egoshi mu onwongu l'eli úbvú ono. ");
INSERT INTO izz_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","G'o to nwekwa onye e-tsoru ngu nụ; ọzo onye aa-hụma l'úbvú ono l'ophu l'ophu; g'o to nwekwa atụru; ọzoo eswi, a-nọdu ata nri l'atatiphu úbvú ono.” ");
INSERT INTO izz_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Noo ya; Mósisu mee gẹ Chipfu ziru iya; bya awata bachịbachi mkpuma labọ ọzo, dụkwa phọ gẹ kẹ mbụ phọ; bya egude nyihu úbvú Sayịnayi l'ọnmewa ụtsu. Ọ parụ bachịbachi mkpuma labọ ono l'ẹka. ");
INSERT INTO izz_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Noo ya; Chipfu bya anọdu l'urwukpu nyizeta; bya araa ya arara l'ẹpha iya bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ọ bya aghata l'atatiphu Mósisu etushi onwiya ẹpha sụ: “Ọo mu bụ Chipfu; ọo mu bụ Chipfu; bya abụru Chileke k'obu-imemini; bya abụkwarupho Chileke k'eze-iphe-ọma. Onye ẹhu ete eghujedu eghu ẹgwegwa; onye n-yemobu iya; waa apfụshi ike iya parụ ẹka. ");
INSERT INTO izz_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ụnubuku ụnwu-eliphe bẹ mu anọduje egoshi lẹ mu yeru obu. Mu agụjeru phẹ nvụ l'ẹjo-iphe, ẹphe meru; mẹ l'atụpya, ẹphe tụpyaru mu; waa l'iphe-ẹji, ẹphe meru mu. Ọle mu ta ahajẹkwanu onye-ikpe nmarụ gẹ mu ta ahụ̀ iya ahụ̀hù. Ndu ẹjo-iphe bẹ mu ahụ̀je ahụ̀hù k'ẹjo-iphe, ẹphe meru mu; hụ-rwua ya l'ẹka ụnwu nwanwa phẹ nọ; waa l'ẹka nwanwanwaranwa phẹ nọ; hụ-rwua phẹ l'ọgbo k'ẹno.” ");
INSERT INTO izz_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mósisu bya ephoze iphu l'alị teke ono teke ono bya abaarụ Chipfu ẹja. ");
INSERT INTO izz_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ọ sụ: “Gụbe Chipfu; ọ -bụru lẹ mu dụ ngu l'obu eviya; jiko gẹ gụbe Chipfu tsonụru anyi. A makwarụ-a lẹ ndu-a bụnukaru ndu ẹjo-ọkpoma; ọle jiko gụnaru anyi nvụ l'ẹjo-iphe; waa iphe-ẹji anyi; wotarọ anyi g'anyi bụru okiphe ngu.” ");
INSERT INTO izz_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tọbudu iya bụ; Chipfu sụ: “Anyi lẹ ngu a-gba ndzụ. L'atatiphu ndu nkengu l'ophu bẹ mu e-me oke iphe, dụ biribiri, mu teke emeswe l'ọhamoha, nọ lẹ mgboko l'ophu. Ndu ono, unu bu l'echilabọ phẹ ono a-hụmakota g'iphe, mụbe Chipfu e-mekọta dụ-be ebvu. ");
INSERT INTO izz_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Unu ngabẹ nchị mee ekemu-a, mu atụru unu ntanụ-a. Mu a-chịfuru unu ndu Amọru; waa ndu Kénanu; waa ndu Hetu; waa ndu Pẹ́rezu; waa ndu Hevu; tẹme waa ndu Jiebusu. ");
INSERT INTO izz_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ọle g'unu kwabẹ ẹnya g'unu lẹ ndu bu l'alị ono, unu ala ono ta agba ndzụ; ọdumeka bẹ ẹphe e-mechakwaa bụru ọ́nyà nmata unu. ");
INSERT INTO izz_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Unu gbukpọshia ọru-ngwẹja phẹ; tẹme unu etsukpọshia mkpuma, ẹphe doberu nsọ. Tẹme unu aphọkashikwapho itso, e doberu agwa phẹ, bụ Ashera. ");
INSERT INTO izz_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Unu ta adụkwa iphe ọzo, unu a-bajẹru ẹja gbahaa mụbe Chipfu kpụrumu. Noo kẹle mụbe Chipfu, ẹpha iya bụ Okophoo bẹ bụkwa Chileke, ekoje okophoo. ");
INSERT INTO izz_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Unu kwabẹkwa ẹnya g'ọ tọ dụshi ndu bu l'alị ono, unu l'ẹphe a-gba ndzụ. Noo kẹle ẹphe -nọdu agwa agwa phẹ ono; bẹ ẹphe e-zi unu lẹ nri; unu eje eria iphe, ẹphe gude gwaa iphe ono. ");
INSERT INTO izz_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ọ -bụru l'unu harụ ụnwada phẹ lụtaru ụnwu unu g'ẹphe bụru unyomu phẹ; ndu ono nọdu agwa agwa phẹ ono bẹ ẹphe e-dukwarụpho ụnwu unu; ẹphe eje emee nno. ");
INSERT INTO izz_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Unu ta akpụkwa ntẹkpe! ");
INSERT INTO izz_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Unu bọje ọbo-iphe buredi, ekoduru ekoko. Ujiku ẹsaa bẹ unu a-tajẹ buredi, e yedụru iphe, ekoje buredi ẹgube ono, mu sụru g'unu meje iya. Unu bọje ọbo-iphe ono teke ono, e doberu iya ono l'ọnwa Abibu; noo kẹle ọo l'ọnwa ono bẹ unu shi l'alị ndu Ijiputu wụfuta. ");
INSERT INTO izz_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Iphe-mbụ, vuru ụzo waa ẹkpa ne iya bụ kẹ mụbe Chipfu. Iphe, bụ nwa mbụ iphe-edobe unu nwụru, bụ oke ya yịchakwaa ya; m'ọ bụ eswi; ọzoo atụru; ọzoo eghu. ");
INSERT INTO izz_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Unu gudeje nwatụru gbata nkapfụ-ịgara, bụ kẹ mbụ l'ẹpho ne iya. Obenu l'ọ -bụru l'unu ta agbataduru iya agbata; unu aswịkwoo ya olu. “G'o to nwekwarụ onye a-gbajẹru ẹka bya l'atatiphu mu. ");
INSERT INTO izz_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ujiku ishii bẹ unu e-jeje ozi unu; o -rwua mbọku k'ẹsaa; unu edzua ike. Unu te ejejekwa ozi lẹ mbọku k'ẹsaa; m'obeta ọ bụru aakọ ọkoro; ọzoo teke aakpata iphe, e meberu l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Witi-mbụ, unu vuru ụzo kpata bẹ unu e-gudeje bọo Ọbo-Idzu. Unu abọo ọbo-iphe, a kpatarụ l'opfu lẹ mbvụcha apha. ");
INSERT INTO izz_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Ugbo ẹto l'apha bẹ unwoke unu g'ẹphe ha a-kpakọje bya l'atatiphu Nnajịuphu, bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mu a-chịshiru unu ọhamoha; bya emee g'alị unu kabaa shii. Ọphu ọ dụdu onye bya eme g'ọ nata unu alị unu ono; mẹ unu jeje l'iphu Chipfu, bụ Chileke unu; mbụ ọphu unu ejeje ụgbo ẹto l'apha. ");
INSERT INTO izz_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Unu ta adụkwa iphe e yekọberu iphe ekoje buredi, unu e-yekọbe lẹ mee anụ, unu gude egweru mu ngwẹja. “Tẹme ọphu ọ dụkwa anụ ngwẹja ono, e gude abọ ọbo Ojeghata, aa-ha g'ọ bọo nchi. ");
INSERT INTO izz_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Iphe-mbụ, vuru ụzo kaa l'opfu unu bẹ unu e-gudeje bya l'ụlo Chipfu, bụ Chileke unu. “Unu te egudejekwa mini-ẹra ne eghu shia nwa iya.” ");
INSERT INTO izz_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Noo ya; Chipfu sụ Mósisu: “Dekọta opfu ono g'ọ ha l'ẹkwo. Noo kẹle ọo opfu ono bẹ mu lẹ gụbedua; mẹ ndu Ízurẹlu gude gbaa ndzụ.” ");
INSERT INTO izz_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mósisu bẹ yẹe Chipfu nọru l'ẹka ono ụkporo abalị labọ; eswe l'ẹnyashi; ọphu o riduru nri; ẹbe ọ ngụtaduru mẹ mini. Ọ bya edee opfu ọgbandzu ono, bụ iya bụ ekemu iri ono, shi l'ẹka Chileke ono l'eli bachịbachi mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mósisu shiẹpho l'úbvú Sayịnayi nyizeta; yẹe bachịbachi mkpuma labọ ono, e deru ekemu Chipfu ono, o gude l'ẹka; ọphu ọ madụ l'iphu egbu iya nwịinwii; noo kẹle ẹphe lẹ Chipfu bọgbaberu ụja. ");
INSERT INTO izz_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Erọnu; yẹe ndu Ízurẹlu g'ẹphe ha hụma Mósisu g'iphu egbu iya nwịinwii; ndzụ ejekube iya ntse gụahaa phẹ. ");
INSERT INTO izz_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mósisu bya ekua phẹ; ọo ya bụ; Erọnu; yẹe ndu-ishi ọha ono g'ẹphe ha gbẹ teke ono bya ejekube iya ntse; ọ bya epfuru yeru phẹ. ");
INSERT INTO izz_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","E mechaa; ndu Ízurẹlu g'ẹphe ha byakube iya ntse; ọ bya atụshikotaru phẹ ekemu, Chipfu nụru iya l'úbvú Sayịnayi. ");
INSERT INTO izz_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mósisu pfughechaaru phẹ opfu bya aphụ-chia ẹkwa l'atatiphu. ");
INSERT INTO izz_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ọ nọdu abụjeru; teke Mósisu bahụru l'ụlo-ẹkwa l'atatiphu Chipfu gẹ yẹle iya bọgba; l'ọ phụfu ẹkwa ono l'atatiphu iya gbiriri jasụ l'ọ futa. Ọ -fụtaepho l'ọobya epfukọtaru ndu Ízurẹlu iphe, e ziru iya; ");
INSERT INTO izz_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ẹphe ahụma l'iphu egbu iya kẹ nwịinwii. Ọo ya bụ; Mósisu abya ewota ẹkwa phụ-chia iphu ọzo gbiriri jasụ o jeshia gẹ yẹle Chipfu bọgbabe. ");
INSERT INTO izz_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mósisu bya ekukọbe ndu Ízurẹlu g'ẹphe ha; sụ phẹ: “Wakwa iphe, Chipfu sụru g'unu mee bụ ọwa-a: ");
INSERT INTO izz_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ọ sụru l'ọo ujiku ishii bẹ unu e-jeje ozi unu; o -be lẹ mbọku k'ẹsaa; unu edobe iya nsọ; g'ọ bụru eswe-atụta-unme kẹ Chipfu. Ọ dụru onye jeru ozi mbọku ono; g'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","G'ọ tọ dụkwa onye a-phụ-nwu ọku l'ibe iya l'eswe-atụta-unme.” ");
INSERT INTO izz_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mósisu sụ ndu Ízurẹlu g'ẹphe ha: “Wakwa iphe, Chipfu sụru g'e mee bụ ọwa-a: ");
INSERT INTO izz_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Unu shi l'iphe, unu nweru hata iphe bya anụ yẹbe Chipfu. Onye oohe ihee g'ọ nụ yẹbe Chipfu iphe bẹ iphe, oo-gude bya anụ iya bụ mkpọla-ododo; waa mkpọla-ọchaa; waa onyirubvu; ");
INSERT INTO izz_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","waa owu urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; waa owu ọchaa; waa ẹji eghu; ");
INSERT INTO izz_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","waa akpọ ebili, a tsẹru l'uswe; waa akpọ umoro-ẹnyimu; waa oshi akesha; ");
INSERT INTO izz_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","waa manụ olivu, ee-gudeje anwụ ọku; waa iphe, eeyeje lẹ manụ k'awụ l'ishi g'o shia mkpọ; mẹ ọphu eeyeje l'ụ̀nwù-isẹnsu g'o shia kwẹekweekwee; ");
INSERT INTO izz_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","waa mkpuma ónìkùsù; mẹwaro mkpuma ọzo, aswa dụgbaa. Mkpuma ono bẹ ee-mechaa gbapyabẹ l'uwe-ukuvu onye-ishi ndu-uke; yẹle uwe-ọkpoma iya. ");
INSERT INTO izz_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“G'iphe, bụkpoo ndu maru eme ọna l'echilabọ unu fụta bya emekọta iphemiphe, Chipfu tụru ọnu g'e mee-a; ");
INSERT INTO izz_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","mbụ ụlo-ẹkwa ono; waa ẹkwa, aa-phụshi l'eli ụlo-ẹkwa ono; waa iphe iya ono, nweru nkoloba ishi labọ ono; waa mgbo ono, ee-gude kụ-chite ụlo-ẹkwa ono; waa oshi ono, ee-gudegbaa swebushia lẹ mgbo ono; waa itso iya ono; waa ẹnya ẹka aa-kpọgbaaru iya ye; mbụ itso ono; yẹe ọkpa mgbo ono; ");
INSERT INTO izz_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","waa okpoko ono; yẹe mgbọro ono, ee-gudeje apa iya ono; waa opfu okpoko ono, aa-nọduje apfụ ụgwo iphe-ẹji ono; waa ẹkwa ono, ee-gude kochite iya; ");
INSERT INTO izz_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","waa teburu ono; yẹe mgbọro ono, ee-gudeje apa iya ono; yẹe ngwa iya; yẹe buredi ono, ee-dobeje l'iphu Chipfu ono; ");
INSERT INTO izz_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","waa iphe ono, aapfụbeje orọku ono, e-meje g'ìphóró dụ; yẹe ngwa iya; waa orọku iya ono; mẹ manụ ono, ee-gudeje anwụ ọku ono; ");
INSERT INTO izz_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","waa ọru-ngwẹja-ụ̀nwù-isẹnsu ono; yẹe mgbọro ono, ee-gudeje apa iya ono; waa manụ ono, aa-wụ l'ishi ono; yẹe ụ̀nwù-isẹnsu ono, eshi mkpọ ono; waa ẹkwa ono, ee-kochite ọnu-abata ụlo-ẹkwa ono; ");
INSERT INTO izz_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","waa ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono; yẹe iphe iya ono, dụ g'ụgbu, ee-gude onyirubvu mee ono; waa mgbọro ono, ee-gudeje apa ọru-ngwẹja ono; yẹe ngwa iya g'ọ ha; yẹkwapho eze gbamụgbamu ono, ee-gude onyirubvu mee ono; yẹe ọkpa iya; ");
INSERT INTO izz_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","waa ẹkwa ono, ee-gude gebuta ọma-unuphu ụlo-ẹkwa ono; waa itso ọma-unuphu ono; yẹe ẹnya ẹka aa-kpọbegba itso ono; waa ẹkwa ono, ee-gude gechite ọnu-abata ọma-unuphu ono; ");
INSERT INTO izz_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","waa nggu ụlo-ẹkwa ono; yẹe k'ọma-unuphu iya; mẹ eri iya; ");
INSERT INTO izz_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","waa uwe ono, e kweru ekwekwe, ee-yeje gude eje ozi l'ụlo-nsọ ono; mbụ uwe, e doberu nsọ kẹ Erọnu, bụ onye uke; yẹe k'ụnwu iya, ẹphe e-yeje gude eje ozi gẹ ndu-uke.” ");
INSERT INTO izz_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ndu Ízurẹlu wụkahu l'atatiphu Mósisu. ");
INSERT INTO izz_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Iphe, bụkpoo onye oohe ihee; waa onye o rwuru l'ẹhu g'ọ nụ Chipfu iphe; gudegbaa iphe bya anụ iya; mbụ iphe, ee-gude mee ụlo-ẹkwa-ndzukọ; mẹwaro iphe, ee-gude eje ozi l'ime iya; mẹkwapho ọphu ee-gude kwee uwe, dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Iphe, bụkpoo onye oohe ihee; unwoke mẹ ụnwanyi; gudegbaa iphe, e gude mkpọla-ododo mee bya anụ; mbụ iphe, dụgbaa gẹ ngga agbabẹ; mẹ eregede-nchị; mẹ iphe-ẹka; mẹwaro iphe ọzo, dụgbaa ẹgube ono. Ẹphe gudegbaa mkpọla-ododo phẹ ono bya anụ Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ndu nweru owu wotagbaakwaru iya phọ; mbụ owu, dụ urwukpu-urwukpu; ọzoo ọphu eke mee-mee; ọzoo ọphu dụ uswe-uswe; ọzoo owu ọchaa; ọzoo ẹji eghu; ọzoo akpọ ebili, a tsẹru l'uswe; ọzoo k'umoro-ẹnyimu. ");
INSERT INTO izz_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ndu dụ ike nụ mkpọla-ọchaa; ọzoo onyirubvu; nụkwaru iya phọ Chipfu. Ndu nweru oshi akesha, nweru ẹka ee-gude iya jee ozi ono nụkwa iya phọ. ");
INSERT INTO izz_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Iphe, bụkpoo nwanyị, maru eme ọna gbaa owu bya anụ. Ọ dụru ndu bụ owu urwukpu-urwukpu bẹ ẹphe gbaru; ndu bụ owu, eke mee-mee; dụru ndu bụ owu uswe-uswe; ndu abụru owu ọchaa bẹ ẹphe gbaru gude bya. ");
INSERT INTO izz_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ụnwanyi, oohe ihee; tẹme ẹphe je adụ ike mekọta iya; bụ ẹji eghu bẹ ẹphe gude gbaa owu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ndu-ishi wotagbaaru mkpuma ónìkùsù; mẹwaro mkpuma ọzo, aswa dụgbaa; g'a gbapyabẹ l'uwe-ukuvu onye-ishi-uke; yẹle uwe-ọkpoma iya. ");
INSERT INTO izz_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ẹphe nụfukwapho iphe, eshi mkpọ; waa manụ olivu, ee-gudeje anwụ ọku; waa k'ọphu ee-yeje lẹ manụ awụ l'ishi; waa k'ụ̀nwù-isẹnsu, eshi mkpọ. ");
INSERT INTO izz_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ndu Ízurẹlu l'ophu; unwoke mẹ ụnwanyi; mbụ ndu oohe ihee wotaru Chipfu iphe, ẹphe tụru obu phẹ onyo nụ g'e gude meeru Chipfu iphe ono, o shi l'ọnu Mósisu pfua sụ g'e meeru iya ono. ");
INSERT INTO izz_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Noo ya; Mósisu sụ ndu Ízurẹlu: “Unu maru lẹ Chipfu họtawaru Bezalẹlu nwa Uri, bụ nwanwa Huru, onye ọkpa-ipfu Jiuda; ");
INSERT INTO izz_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","bya emewaa; unme yẹbe Chileke ji iya ẹhu; g'o nweru mmamiphe; yẹe nkwamẹnya; g'iphe doje iya ẹnya ree; k'ọphu ọo-makọtaru g'eemema iphemiphe emema; ");
INSERT INTO izz_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","g'ọ maru g'eemeje iphe-ẹrengete lẹ mkpọla-ododo; yẹe mkpọla-ọchaa; waa onyirubvu; ");
INSERT INTO izz_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","makwarụpho g'aawa mkpuma, aswa dụ; waa g'aawụje mkpọla-ododo l'igburọnu iya; bya amakwarụpho g'aapyịje iphe apyịpyi; mẹwaro g'eeshije eme ọna ọzo, dụgbaa iche iche. ");
INSERT INTO izz_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Tẹme ọ nụkwapho yẹe Oholiyabu nwa Ahisamaku, onye ọkpa-ipfu Danu mmamiphe g'ẹphe zia ndu ọzo g'eeme ọna ọbu. ");
INSERT INTO izz_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","O mekwarụ gẹ mmamiphe k'eme iphe-ẹrengete ji phẹ ẹhu; mbụ g'ẹphe maru eme ọna; waa g'ẹphe maru g'eegudeje owu urwukpu-urwukpu; yẹe ọphu eke mee-mee; waa k'uswe-uswe; waa owu ọchaa dengashịa iphe edengashị. Ẹphenebo bụ ndu tụkoru makọtaru g'eemeje iphe ọna g'ọ maa mma. ");
INSERT INTO izz_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ọo ya bụ; Bezalẹlu; yẹe Oholiyabu; waa iphe, bụkpoo ndu maru iphe, Chipfu nụru mmamiphe; yẹe iphe edo ẹnya g'ẹphe maru g'eeme iphemiphe, larụ lẹ k'akpụ ụlo-nsọ ono bụekwapho g'ẹphe mee ya gẹ Chipfu pfuru sụ g'e meeru iya ya.” ");
INSERT INTO izz_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Tọbudu iya bụ; Mósisu kua Bezalẹlu; yẹe Oholiyabu; waa iphe, bụkpoo onye maru iphe, Chipfu nụru mmamiphe; ọ nọdu ehekwa iya phọ ihee g'o jee ozi ono. ");
INSERT INTO izz_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mósisu chịru iphe, ndu Ízurẹlu tụtaru g'e gude kpụa ụlo-nsọ ono nụ phẹ. Ndu Ízurẹlu nọdu atụkokpoepho iphe ono l'ụtsu mbọku anwụta anwụta g'ẹphe atụ iya. ");
INSERT INTO izz_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ndu maru eme ọna, akpụ ụlo-nsọ ono tụko g'ẹphe ha parụ iphe, ẹphe eme haa; ");
INSERT INTO izz_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","tụgbua je asụ Mósisu: “Ndu-a tụtaakwaru iphe, sụru egude mee iphe, Chipfu sụru g'e mee; atụwa k'etsutsu iya eye iya.” ");
INSERT INTO izz_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mósisu tụa ekemu sụ: “G'ọ tọ dụkwa nwoke; ọzoo nwanyị, a-kpataba iphe akpakpa bya anụ sụ l'ọo iphe, o gude eyeta ẹka k'ụlo-nsọ ono.” E woru iphe ono, Mósisu pfuru ono pfudzuru l'ụlo-ẹkwa ndu Ízurẹlu l'ophu. E shi nno kpọshia ndu Ízurẹlu g'ọ tọ dụhe iphe, ẹphe e-wotaba; ");
INSERT INTO izz_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","noo kẹle iphe, a tụtawaru g'e gude jee ozi ụlo ono sụwaru g'ee-gude iya jee ozi ono; l'o tsufu etsufu. ");
INSERT INTO izz_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Iphe, bụ ndu ọphu maru iphe lẹ ndu-ozi ono gude owu ọchaa, a swịru ụdo; waa ọphu dụ urwukpu-urwukpu; waa ọphu dụ uswe-uswe; yẹe ọphu eke mee-mee; kwee ẹkwa kweta iya upfu ẹkwa iri. Onye maru eme ọna gude owu ono kwee chierobu ye l'upfu ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Upfu ẹkwa ono tụkokwa harụ ẹnya nhamụnha. Ogologo iya dụ nkwo-ẹka ụkporo l'ẹsato; ọsa iya dụ nkwo-ẹka ẹno. ");
INSERT INTO izz_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ẹphe wotaru upfu ẹkwa ono ise gbagbabẹ; ọ bụru nlọchiru lanụ; bya ewotakwaphọ ụzo ise ọphuu gbagbabẹ nanụ. ");
INSERT INTO izz_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ishimishi-ophoko-ẹkwa ono kẹ mbụ bẹ ẹphe gude owu, dụ urwukpu-urwukpu yeshia ya nkoloba l'igburọnu iya. Ẹphe bya emekwaaphọ nno l'ishimishi-ophoko-ẹkwo ono k'ẹbo. ");
INSERT INTO izz_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Nkoloba ụkporo labọ l'iri bẹ ẹphe yeru l'ishishi nlọchiru lanụ; ẹphe yekwaphọ nkoloba ụkporo labọ l'iri l'ishishi nlọchiru lanụ ọphuu. Nkoloba ono tụko ghagbabẹ iphu. ");
INSERT INTO izz_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ẹphe gude mkpọla-ododo meta iphe, kweru nko ishi labọ ụzo ụkporo labọ l'iri; gude iya dzegbabẹ nlọchiru ẹkwa ono ẹphenebo; ọ tụko bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ẹphe bya egude ẹji eghu kwee ẹkwa; kweta iya upfu ẹkwa iri lẹ nanụ, ee-gude phụ-chite eli ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Upfu ẹkwa ono ẹphe n'iri lẹ nanụ tụko harụ ẹnya nhamụnha. Ogologo iya dụ nkwo-ẹka ụkporo l'iri. Ọsa iya dụ nkwo-ẹka ẹno. ");
INSERT INTO izz_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ẹphe bya achịta upfu ẹkwa ono ise gbagbabẹ; ọ bụru nlọchiru lanụ; chịta ụzo upfu ẹkwa ishii ọphuu gbagbabẹkwapho nanụ. ");
INSERT INTO izz_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Nkoloba ụkporo labọ l'iri bẹ ẹphe yeru l'ishishi nlọchiru lanụ; yekwaphọ nkoloba ụkporo labọ l'iri l'ishishi nlọchiru lanụ ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ẹphe gude onyirubvu meta iphe, kweru nko ishi labọ ụzo ụkporo labọ l'iri; gude iya kotagbaa nkoloba nlọchiru ẹkwa ono ẹphenebo; gude iya dzegbabẹ ụlo-ẹkwa ono; ọ bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E mechaa; ẹphe gude akpọ ebili, a tsẹru l'uswe; mee iphe, ee-gude phụ-chia eli ụlo-ẹkwa ono ọzo; bya egudekwaphọ akpọ umoro-ẹnyimu mee iphe, ee-gude kwechite eli akpọ k'ebili ono. ");
INSERT INTO izz_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ẹphe gude oshi akesha meta oshi, ee-gudeje kpọbe ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Oshi ono bẹ e mekọtaru; ọ dụgbaa nkwo-ẹka iri iri l'eli. Ọsa iya dụgbaa nkwo-ẹka lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Oshi ono bẹ ẹphe pyịtachaaru ọkpa labọ ye l'ibekẹboebo. Ọ bụru ẹgube ono bẹ ẹphe mekọtaru oshi ụlo-ẹkwa ono g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A bya l'ụlo-ẹkwa ono ibiya ọphu gharu iphu l'ụzo ndọhali; bụ ụkporo oshi bẹ ẹphe rụtaru yegbaa ya. ");
INSERT INTO izz_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ẹphe gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye; meta iya ụzo ụkporo labọ. Iphe, bụ oshi ono g'ọ ha nweru ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A bya l'ibe iya ọphuu; mbụ ibiya ọphu gharu iphu l'ụzo isheli; bụkwapho ụkporo oshi bẹ ẹphe rụtaru; yeshia ya. ");
INSERT INTO izz_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ẹphe gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye; meta iya ụzo ụkporo labọ. Iphe, bụ oshi ono g'ọ ha nweru ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","A bya l'okotazụ ụlo-ẹkwa ono; mbụ ibiya ọphu gharu iphu l'ụzo ẹnyanwu-arịba bụ oshi ishii bẹ ẹphe rụtaru; yeshia ya; ");
INSERT INTO izz_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","bya emetacha oshi ẹbo ẹbo; yechaa lẹ mgburẹku mgburẹku ụlo-ẹkwa ono l'ụzo okotazụ iya ono. ");
INSERT INTO izz_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Oshi labọ ono, ee-yechaa lẹ mgburẹku iya ono bẹ dụgbaa nkwegba ẹbo ẹbo. O shi l'ụzo alị dụ nkwegba ẹbo jasụ l'imeli. Tẹme ọ bụru echi lanụ bẹ a kụberu iya. Ẹphenebo tụko dụkota nno. ");
INSERT INTO izz_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ọo ya bụ l'ọ dụ oshi ẹsato l'azụ ụlo-ẹkwa ono. E gude mkpọla-ọchaa meshia ẹnya ẹka aa-kpọgbaaru ọkpa oshi ono ye ụzo iri l'ishii. Iphe, bụ oshi ono g'ọ ha nwegbaarụ ẹnya ẹka labọ, aa-kpọjeru ọkpa iya ye. ");
INSERT INTO izz_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ẹphe gude oshi akesha rwashịa oshi, dụgbaa gbẹrere, ee-gude swebushia l'oshi ono. Ụzo ise bẹ ẹphe sweberu l'oshi mgburẹku ụlo-ẹkwa ono ibe lanụ; ");
INSERT INTO izz_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","swebekwaphọ ụzo ise ọzo lẹ mgburẹku ibe iya ọphuu. Ụzo ise ọzo bụru k'okotazụ ụlo-ẹkwa ono; ibiya ọphu gharu iphu l'ụzo ẹnyanwu-arịba. ");
INSERT INTO izz_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Oshi ọphu ee-swebe l'echi iya bẹ ẹphe rwaru g'ọ gbẹ l'ishi lanụ lụfu l'ishi iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ẹphe wụkota mkpọla-ododo l'oshi ono, eegudeje kpọbe ụlo-ẹkwa ono; bya egudekwaphọ mkpọla-ododo meshia echi, e-gudeshigbaa oshi ono, dụgbaa gbẹrere ono. Ẹphe bya awụkwapho mkpọla-ododo lẹ gbẹrere oshi ono. ");
INSERT INTO izz_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ẹphe gude owu, dụ urwukpu-urwukpu; waa ọphu dụ uswe-uswe; waa ọphu eke mee-mee; yẹe owu ọchaa, a swịru ụdo; kwee ẹkwa. Onye maru eme ọna bya egude owu ono kweshia chierobu ye l'ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ẹphe gude oshi akesha rwaa itso ẹno; bya awụa ya mkpọla-ododo; bya egudekwaphọ mkpọla-ododo meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono. Ẹphe bya egude mkpọla-ọchaa kpụshia ẹnya ẹka aa-kpọbe itso ono ụzo ẹno. ");
INSERT INTO izz_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ẹphe gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; yẹe owu ọchaa, a swịru ụdo; kwee ẹkwa, ee-gudeje kochite ọnu-abata ụlo-ẹkwa ono. Ọ bụru ndu gude ngga ekwe ẹkwa meru iya. ");
INSERT INTO izz_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ẹphe gude oshi akesha rwata itso ise; bya emekwaphọ iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono. Ẹphe bya awụa ishi itso ono; waa iphe, ee-swebe l'itso ono mkpọla-ododo; bya egude onyirubvu kpụshia ẹnya ẹka aa-kpọbegba itso ono ẹphe n'ise. ");
INSERT INTO izz_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalẹlu gude oshi akesha kụa okpoko. Ogologo iya dụ nkwo-ẹka labọ lẹ mkpirikpu iya. Ọsa iya dụ nkwo-ẹka lanụ lẹ mkpirikpu iya. Eli iya dụkwapho nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ọ wụa ọkpobe mkpọla-ododo l'ime iya; waa l'azụ iya. O gudekwaphọ mkpọla-ododo wụ-phee mgburẹku iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ọ kpụta echi mkpọla-ododo ẹno depfubegbaa l'ọkpa iya ẹphen'ẹno; mbụ wota ẹbo depfube l'ibe lanụ; wota ẹbo k'ọphuu depfube l'ibe iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","O gude oshi akesha pyịta mgbọro labọ; wụa ya mkpọla-ododo. ");
INSERT INTO izz_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","O woru mgbọro ono ẹphenebo pyochaa l'echi ono, e depfubegbaaru lẹ mgburẹku okpoko ono g'ọ bụru iphe, ee-gudeje apa iya. ");
INSERT INTO izz_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","O gude ọkpobe mkpọla-ododo meta opfu okpoko; ẹka aapfụje ụgwo iphe-ẹji, nemadzụ meru. Ogologo iya dụ nkwo-ẹka labọ lẹ mkpirikpu iya. Ọsa iya dụ nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","O gude mkpọla-ododo mee chierobu labọ, a-nọduchaa l'ishi opfu okpoko ono. Ọ bụru mkpọla-ododo, e tsusaru etsusa bẹ o gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","O woru chierobu lanụ dobe l'ishi ibe lanụ; woru ọphuu dobe l'ishi iya ọphuu; bya emee; chierobu labọ ono, nọgbaa l'ishishi okpoko ono ẹphenebo yẹle okpoko ono bụru iphe lanụ. ");
INSERT INTO izz_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubimu ono bẹ o meru; ọ jashịa ǹkù l'ụzo imeli; ǹkù iya ono kpuchite opfu okpoko ono. Ẹphe ghagbabẹ iphu; tụko ele ẹnya l'eli okpoko ono kwaphọ. ");
INSERT INTO izz_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ẹphe gude oshi akesha meta teburu. Ogologo iya dụ nkwo-ẹka labọ. Ọsa iya dụ nkwo-ẹka lanụ. Eli iya dụ nkwo-ẹka lanụ lẹ mkpirikpu iya. ");
INSERT INTO izz_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ẹphe wụa ya ọkpobe mkpọla-ododo; bya egudekwaphọ mkpọla-ododo wụ-phee eli iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ẹphe wota wẹrere oshi, ọsa iya ha g'ọbochi-ẹka wụ-phee mgburẹku iya mgburugburu; bya egudekwaphọ mkpọla-ododo kpụ-phee wẹrere oshi ono. ");
INSERT INTO izz_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ẹphe kpụta echi mkpọla-ododo ẹno depfubegbaa lẹ mgburẹku ọkpa teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Echi ono nọ-kubechaa wẹrere oshi phọ; k'ọphu ọo-dụkwanu ike gudeshia mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO izz_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mgbọro, ee-gudeje apa teburu ono bụ oshi akesha bẹ ẹphe gude pyịshia ya; bya awụa ya mkpọla-ododo. ");
INSERT INTO izz_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ẹphe gude ọkpobe mkpọla-ododo meshia ngwa, aa-tụ-kobeje l'eli teburu ono; mbụ gbamụgbamu; waa ite; waa okoro; mẹ nkwẹka ee-gudeje gweeru Chipfu ngwẹja-mẹe. ");
INSERT INTO izz_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ẹphe gude ọkpobe mkpọla-ododo, e tsusaru etsusa mee iphe, aapfụbeje orọku. Ẹphe meru iya; o nweru oshi; waa ẹkali. Ọ bya enweru ochi; nweru nkwo iya; nweru iphe, dụ gẹ nwopu okoko; waa iphe, dụ g'okoko, jawaru àjàjà. Ẹphe tụko iphemiphe ono mee gẹ yẹle iphe ono, aapfụbeje orọku ono dzepfua bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Oshi iya ono nweru ẹkali ishii. Ẹkali ẹto nọdu lẹ mgburẹku iya lanụ; ẹto k'ọphuu nọdu lẹ mgburẹku iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ẹkali iya lanụ nweru okoro ẹto. Okoro ono bẹ e mechaarụ; ọ dụgbaa g'okoko oshi alụmondu. E mekwaaphọ nwopu okoko ye iya; yẹe okoko ọphu jawaru àjàjà. Noo g'ọ dụkota l'ẹkali iya ono ẹphe n'ishii, dzepfugbaaru l'oshi iya ono. ");
INSERT INTO izz_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Oshi iya ono nweru okoro ẹno, e meru; ọ dụ g'okoko oshi alụmondu. O nwekwarụpho iphe, e meru; ọ dụ gẹ nwopu okoko; yẹe iphe, dụ g'okoko ọphu jawaru àjàjà. ");
INSERT INTO izz_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nwopu okoko lanụ bẹ e meru; ọ nọdu lẹ mkpula ẹkali iya labọ ono, nọ l'ụzo alị iya. K'ẹbo nọdu lẹ mkpula ẹkali iya labọ k'echi. K'ẹto nọdu lẹ mkpula ẹkali iya labọ k'ụzo eli. Mbụ l'ọ nọchaa lẹ mkpula ẹkali iya ono ẹphe n'ishii. ");
INSERT INTO izz_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nwopu okoko iya ono; yẹe ẹkali iya ẹkali iya ono bẹ e meru; yẹle oshi iya tụko dzepfuru. Ọ bụru ọkpobe mkpọla-ododo, e tsusaru etsusa bẹ e gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ẹphe gudekwaphọ ọkpobe mkpọla-ododo meta orọku ẹsaa, aa-pfụbegbaa l'eli iphe ono, aapfụbeje orọku ono; bya emetakwaphọ ákpà iya; waa iphe, aagụje ọku iya. ");
INSERT INTO izz_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Iphe, aapfụbeje orọku ono; yẹe ngwa iya g'ọ hakọta bụ ọkpobe mkpọla-ododo, ẹrwa iya dụ talẹntu lanụ bẹ e gude mee ya. ");
INSERT INTO izz_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ẹphe gude oshi akesha kụa ọru-ngwẹja, bụ ẹka aa-kpọje ụ̀nwù-isẹnsu ọku. Ogologo iya waa ọsa iya tụko harụ ẹnya nhamụnha. Iphe, ọ dụchaa bụ nkwo-ẹka lanụ. Eli iya dụ nkwo-ẹka labọ. Mpu iya; yẹe ọru-ngwẹja ono tụko rwagbabẹ bụru nanụ. ");
INSERT INTO izz_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ẹphe wụkota eli iya; yẹe mgburẹku iya; waa mpu iya ọkpobe mkpọla-ododo. Ẹphe gudekwaphọ mkpọla-ododo kpụ-phee mgburẹku iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ẹphe meta echi mkpọla-ododo ẹbo ẹbo depfubegbaa lẹ mgburẹku iya ibekẹboebo. Ẹphe depfuberu iya; ọ nọduchaa lẹ mkpula iphe ono, a kpụ-pheru iya mgburugburu ono. Ọ bụru l'echi ono bẹ ee-yeje mgbọro, ee-gudeje apa iya. ");
INSERT INTO izz_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ẹphe gude oshi akesha pyịta mgbọro ono; wụa ya mkpọla-ododo. ");
INSERT INTO izz_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ẹphe mekwaaphọ manụ ono, dụ nsọ bya eshi mkpọ, aawụje l'ishi ono; waa ọkpobe ụ̀nwù-isẹnsu ono, eshi mkpọ ono. Ọ bụru ndu maru eme manụ-mbeleke meru iya. ");
INSERT INTO izz_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ẹphe gude oshi akesha kụta ọru-ngwẹja. Eli iya dụ nkwo-ẹka ẹto. Ogologo iya waa ọsa iya tụko harụ ẹnya nhamụnha. Iphe, ọ dụchaa bụ nkwo-ẹka ise ise. ");
INSERT INTO izz_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ẹphe rụtachaa mpu mobechaa l'ishi ishi mgburẹku iya ẹphen'ẹno. Mpu ono; yẹe ọru-ngwẹja ono rwagbaa bụru nanụ. Ẹphe mechaa ya nno; bya eworu onyirubvu wụa ya. ");
INSERT INTO izz_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ẹphe gude onyirubvu meshia iphemiphe, ee-gudeje eje ozi l'ọru-ngwẹja ono, bụ iya bụ ite; waa iphe, eegudeje ekpo ntụ; waa gbamụgbamu; waa oji; mẹ iphe, aagụje ọku. ");
INSERT INTO izz_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ẹphe gude onyirubvu meta iphe, dụ nggafu-nggafu g'ụgbu; bya enweru mgburẹku ẹno. Ẹphe woru iya kwechia ụzo alị mgburẹku ọru-ngwẹja ono. A -gbẹ l'ụzo alị iya kwechia ya jasụ l'echilabọ iya. ");
INSERT INTO izz_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ẹphe gudekwaphọ onyirubvu meta echi ẹno hebechaa lẹ mgburẹku iphe ono, dụ nggafu-nggafu g'ụgbu ono, e meru l'onyirubvu ono; g'ọ bụru ẹnya ẹka ee-pyocha mgbọro, ee-gudeje apa ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ẹphe gude oshi akesha pyịta mgbọro labọ; wụa ya onyirubvu; ");
INSERT INTO izz_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","wochaaru mgbọro ono nwua l'ẹnya echi phọ ibekẹboebo. Mgbọro ono ẹphenebo a-nọdujechaa lẹ mgburẹku iya ẹphenebo mẹ a -nọdu apa iya. Ẹphe gude iberibe oshi mee ọru-ngwẹja ono; ụzo dụ iya l'echi. ");
INSERT INTO izz_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ẹphe gude onyirubvu mee eze gbamụgbamu; yẹe ọkpa iya. Onyirubvu ono, ẹphe gude mee ya ono shi l'onyo ụnwanyi, anọduje eje ozi l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ẹphe bya emee ọma-unuphu. Ẹphe gude owu ọchaa, a swịru ụdo; kwee ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo; g'e gude gebuta ibiya ọphu ọma-unuphu ono gharu iphu l'ụzo ndọhali. ");
INSERT INTO izz_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ẹphe gude onyirubvu meta ụkporo itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono; bya egude mkpọla-ọchaa meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebe l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ụzo isheli iya bụkwapho ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo bẹ e kweru gude gebuta iya. Itso, aa-kpọbe l'ụzo isheli ono; yẹe ẹnya ẹka aa-kpọbe itso ono dụchaa ụkporo ụkporo. Ọ bụkwarupho onyirubvu bẹ e gude metachaa ya. Ọ bụkwanuru mkpọla-ọchaa bẹ e gude meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebe l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A bya l'ọsa ọma-unuphu ono l'ụzo ẹnyanwu-arịba iya; bụkwa ẹkwa, dụ ụkporo nkwo-ẹka labọ lẹ nkwo-ẹka iri l'ogologo bẹ e kweru; gude gebuta iya. Ẹphe bya emeta itso iri, aa-kpọbe l'ụzo ẹnyanwu-arịba ono; metakwaphọ ẹnya ẹka aa-kpọbechaa itso ono ụzo iri. Ẹphe bya egude mkpọla-ọchaa meshia iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebe l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ọsa ọma-unuphu ono l'ụzo ẹnyanwu-awawa iya dụkwapho ụkporo nkwo-ẹka labọ lẹ nkwo-ẹka iri l'ogologo. ");
INSERT INTO izz_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ẹphe bya ekwee ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo g'e gude gebuta agụga ọnu-abata ọma-unuphu ono ibe lanụ. Itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono dụchaa ẹto ẹto. ");
INSERT INTO izz_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A bya l'ẹka agụga ọnu-abata ọma-unuphu ono ibe iya ọphuu; bụkwapho ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo bẹ ẹphe kweru g'e gude gebuta iya. Itso, aa-kpọbe iya; yẹe ẹnya ẹka aa-kpọbechaa itso ono dụchakwapho ẹto ẹto. ");
INSERT INTO izz_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Iphe, bụ ẹkwa, ee-gude gebuta ọma-unuphu ono mgburugburu bụkota owu ọchaa, a swịru ụdo bẹ ẹphe gude kwee ya. ");
INSERT INTO izz_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ẹnya ẹka aa-kpọbechaa itso, ee-gude kpọ-buta ọma-unuphu ono mgburugburu bụ onyirubvu bẹ ẹphe gude meshia ya. Iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; yẹe iphe, ee-swebegbaa l'itso ono bụkwanuru mkpọla-ọchaa bẹ ẹphe gude meshia ya. Ishi itso ono bẹ ẹphe wụru mkpọla-ọchaa. Iphe, ee-swebechaa l'itso ono, ee-gude kpọ-buta ọma-unuphu ono mgburugburu ono bụ mkpọla-ọchaa bẹ ẹphe gude meshia ya. ");
INSERT INTO izz_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ẹphe gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa k'uswe-uswe; yẹe owu ọchaa, a swịru ụdo; gude kwee ẹkwa, dụ nkwo-ẹka ụkporo l'ogologo; g'e gude gechite ọnu-abata ọma-unuphu ono. Ọ bụru ndu gude ngga ekwe ẹkwa meru iya. ");
INSERT INTO izz_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ẹphe gude onyirubvu metaru ọnu-abata iya ono itso ẹno; waa ẹnya ẹka aa-kpọbechaa itso ẹno ono. Iphe, kweru nko, ee-gude kobe ẹkwa ono l'itso ono; waa iphe, ee-swebechaa l'itso ono bẹ ẹphe mekọtaru lẹ mkpọla-ọchaa. Ẹphe wụkotakwapho mkpọla-ọchaa l'eli itso ono. ");
INSERT INTO izz_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Iphe, bụ nggu, ee-libegbaa eri ụlo-ẹkwa ono; mẹkwapho k'ọma-unuphu ono bẹ ẹphe gude onyirubvu mekọta. ");
INSERT INTO izz_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ọwaa bụ mkpakọ iphe, e gude mee ụlo-ẹkwa ọbu; mbụ ụlo-ẹkwa Ekemu ono. Ọo Mósisu sụru gẹ ndu oshilọkpa Lívayi dekọta iphemiphe ono l'ẹkwo. Onye-ishi phẹ bụ Itama nwa Erọnu, bụ onye uke. ");
INSERT INTO izz_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalẹlu nwa Uri, bụ nwanwa Huru, bụ oshilọkpa Jiuda mekọta iphemiphe gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Onye ẹphe l'iya tụko mee ya bụ Oholiyabu nwa Ahisamaku; oshilọkpa Danu; bụ onye maru eme ọna; yẹe ẹrengete; bya abụru onye maru g'eegudeje owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; waa owu ọchaa dengashịa iphe edengashị. ");
INSERT INTO izz_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ẹrwa mkpọla-ododo, a tụtaru lẹ ngwẹja-amama, a nụru g'e gude mee ụlo ono, dụ nsọ ono dụ ụkporo talẹntu lẹ talẹntu tete; waa ụnu shẹkelu; l'ụkporo shẹkelu iri l'ishii; lẹ shẹkelu tete. G'ọ ha bụkwa iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. ");
INSERT INTO izz_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ẹrwa mkpọla-ọchaa, ndu Ízurẹlu tụtaru teke ono, a gụru phẹ ọgu ono dụ ụkporo talẹntu ise; waa ụnu shẹkelu ẹno; l'ụkporo shẹkelu ẹsato; lẹ shẹkelu iri l'ise. G'ọ ha bụkwa iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. ");
INSERT INTO izz_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Iphe, mkpọla-ọchaa ọbu gbaru phẹ l'ẹhu l'ẹhu bụ mkpọla-ọchaa, ẹrwa iya bụ nkeru-ẹbo shẹkelu. G'ọ ha bụkwa iphe, eegudeje atụ̀ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụ̀a ya. Ndu a gụru teke ono, a gụru ndu Ízurẹlu ọgu ono bụ; a -gbẹ lẹ ndu nọru ụkporo apha kwasẹru. Iphe, ẹphe dụ bụ ụkporo ụnu nemadzụ ugbo ụkporo ẹto l'iri l'ise; l'ụnu nemadzụ ẹsato; l'ụkporo ụmadzu iri l'ẹsaa; l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Mkpọla-ọchaa ono, ẹrwa iya dụ ụkporo talẹntu ise ono bẹ e gude kpụshigbaa ẹnya ẹka aa-kpọbegba ọkpa mgbo ono, ee-gude kụ-chite ụlo-ẹkwa ono ụzo ụkporo ise. Mkpọla-ọchaa, ẹrwa iya dụ talẹntu lanụ bẹ eegudeje kpụa ẹnya iya lanụ. ");
INSERT INTO izz_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ẹphe gude ụnu shẹkelu mkpọla-ọchaa ẹno; l'ụkporo shẹkelu ẹsato; lẹ shẹkelu iri l'ise kpụshia iphe, nweru nkoloba, ee-gude kobe ẹkwa ono l'itso ono; bya egudekwa iya phọ wụkota l'ishi itso ono; bya egude iya mekwaphọ iphe, ee-swebegbaa l'itso ono. ");
INSERT INTO izz_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ẹphe tụtakwarupho onyirubvu, ẹrwa iya dụ ụkporo talẹntu ẹto lẹ talẹntu iri; waa ụnu shẹkelu ishii lẹ ngwẹja-amama ono. ");
INSERT INTO izz_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ẹphe gude iya kpụa ẹnya ẹka aa-kpọbegba itso k'ọnu-abata ụlo-ẹkwa-ndzukọ ono; bya egudekwa iya phọ kpụa ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono; yẹe iphe ono, dụ g'ụgbu ono; waa ngwa ọru-ngwẹja ono g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ẹphe gudekwa iya phọ kpụa ẹnya ẹka aa-kpọbegba itso, ee-gude kpọ-buta ọma-unuphu ono; wakwaphọ k'ọnu-abata iya; waa nggu, ee-libegbaa eri ụlo-ẹkwa ono; mẹkwapho k'ọma-unuphu iya. ");
INSERT INTO izz_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ẹphe gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe ọphu dụ uswe-uswe; kweeru ndu-uke uwe, ẹphe e-yeje gude eje ozi l'ụlo-ẹkwa ono. Ẹphe kwekwarụpho Erọnu uwe, dụ nsọ, bụ iya bụ gẹ Chipfu sụru Mósisu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ẹphe gude owu mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; waa ọphu dụ uswe-uswe; waa owu ọchaa, a swịru ụdo; kwee uwe-ukuvu. ");
INSERT INTO izz_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ẹphe woru mkpọla-ododo tsusaa etsusa; mee ya; ọ dụ phẹripheri; woru iya washịa agwara; gude agwara ono tsokọta lẹ mgbaka owu urwukpu-urwukpu phọ; yẹe ọphu eke mee-mee; yẹe ọphu dụ uswe-uswe; waa owu ọchaa, a swịru ụdo phọ. Ọ bụru onye maru eme ọna meru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ẹphe woru wẹrere ẹkwa labọ libechaa l'uwe-ukuvu ono ibekẹboebo; g'a nyajẹ iya l'ukuvu; g'e gudeje wẹrere ẹkwa ono ẹphenebo lita k'atatiphu yẹe k'azụ. ");
INSERT INTO izz_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ẹphe bya ekwekwaphọ wẹrere ẹkwa, ee-gudeje tụ-buta iya l'upfu ye iya. Wẹrere ẹkwa ono bẹ yẹe ifọdu ono tụko bụru iphe lanụ. Iphe, e gude kwee ya bụ owu mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe k'uswe-uswe; yẹe owu ọchaa, a swịru ụdo, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mkpuma ónìkùsù phọ bẹ ẹphe wụru mkpọla-ododo l'igburọnu iya. Ọ bụru ẹgube ono, onye apyịje mkpuma, vu oke aswa akashịje ẹpha lẹ mkpuma; gude mee ya iphe-ọhubama ono bụ g'ẹphe kakọtaru ẹpha ụnwu Ízurẹlu lẹ mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ẹphe bya adzụpyabe mkpuma labọ ono l'eli uwe-ukuvu phọ ẹphenebo; k'ọphu Chipfu e-gudeje iya nyata ụnwu Ízurẹlu, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ẹphe bya ekwee uwe-ọkpoma phọ, ee-gudeje achọ iphe, bụ uche Chipfu phọ. Ẹphe kweru iya; ọ dụ g'uwe-ukuvu phọ, e kweru l'owu mkpọla-ododo; yẹe owu, dụ urwukpu-urwukpu; yẹe ọphu eke mee-mee; waa k'uswe-uswe; waa owu ọchaa, a swịru ụdo. Ọ bụru onye maru eme ọna meru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","O nweru mgburẹku ẹno; dụ nkwegba labọ. Mgburẹku iya ono ẹphen'ẹno tụkokwa harụ ẹnya nhamụnha. Ogologo iya dụ nkwo-ẹka lanụ; ọsa iya dụkwapho nkwo-ẹka lanụ. ");
INSERT INTO izz_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ẹphe bya adzụpyabe mkpuma, vu oke aswa l'ogiri l'ogiri ụzo ẹno l'ẹkwa ono. Mkpuma, nọ l'ogiri iya kẹ mbụ bụ rubi; yẹe tópàzù; waa bérìlù. ");
INSERT INTO izz_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ogiri iya k'ẹbo; bụ tọ̀kwásù; yẹe sáfàyà; waa émèràlụ̀dú bẹ ẹphe doru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","O be l'ogiri iya k'ẹto; ọ bụru jiásìntù; yẹe ágètù; waa ámìtìsùtù bẹ ẹphe doru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Teke o beru l'ogiri k'ẹno; bụ kìrísòlàyìtù; yẹe ónìkùsù; waa jiásùpà bẹ ẹphe doru iya. Ẹphe bya awụa mkpọla-ododo l'igburọnu mkpuma ono. ");
INSERT INTO izz_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Iphe, ọ dụ bụ mkpuma iri l'ẹbo. G'ẹphe ha nanụ nanụ nọ-chichaaru ẹnya ẹpha ụnwu Ízurẹlu. Ẹphe bya edechaa ẹpha ụnwu Ízurẹlu ono lẹ mkpuma ono; ọ dụ g'iphe-ọhubama nọchia ẹnya ọkpa-ipfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ẹphe gude owu ọkpobe mkpọla-ododo swịshia gwọgirigwo, ee-lipfubegbaa l'uwe-ọkpoma ọbu; mbụ swịshia ya; ọ dụ g'onye swịru ụdo. ");
INSERT INTO izz_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ẹphe gude mkpọla-ododo meta echi labọ; yechaa l'ishi uwe-ọkpoma ono; ");
INSERT INTO izz_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","bya eworu gwọgirigwo phọ libechaa l'echi ono, e yegbaaru l'ishi uwe-ọkpoma ọbu. ");
INSERT INTO izz_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ẹphe bya ewota ishi gwọgirigwo ono ishi iya ọphuu lipfubekwaphọ lẹ mkpọla-ododo phọ, a wụru l'igburọnu mkpuma labọ phọ, e lipfuberu l'eli uwe-ukuvu phọ. ");
INSERT INTO izz_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ẹphe bya egude mkpọla-ododo meta echi labọ ọzo; lipfube l'ishi uwe-ọkpoma ọbu l'ụzo alị. Ẹphe lipfuberu iya l'ime uwe-ọkpoma ọbu; ibiya ọphu tukoru l'eli uwe-ukuvu phọ. ");
INSERT INTO izz_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ẹphe bya egude mkpọla-ododo metafua echi labọ ọzo; libechaa l'ishishi wẹrere ẹkwa labọ phọ l'ụzo alị iya; mbụ wẹrere ẹkwa ono, e liberu l'eli uwe-ukuvu ono. Ẹphe liberu iya tẹmanu l'e rwua ẹka ono, a nmarụ wẹrere ẹkwa, a tụ-butaru l'upfu uwe-ukuvu ono. ");
INSERT INTO izz_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Echi k'uwe-ọkpoma phọ bẹ ẹphe gude eri, e gude owu, dụ urwukpu-urwukpu swịa; litachaa l'echi uwe-ukuvu ọbu; k'ọphu ọo-nọdu lẹ mgboru wẹrere ẹkwa, atụ-buta l'upfu phọ; g'uwe-ọkpoma phọ ta nọdujeshi akụ pẹepee l'eli uwe-ukuvu ọbu, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ẹphe gude ẹkwa, dụ urwukpu-urwukpu mee uwe mgbalanụ, ee-yeje uwe-ukuvu ono l'eli iya. Ọ bụru onye maru ekwe ẹkwa ree kweru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ẹphe kweru iya; ẹka eepyoje iya ishi nọdu iya l'echilabọ; bya eswia igburọnu iya ọnu g'eeswije olu uwe-a; g'ọ tọ lakahụ. ");
INSERT INTO izz_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ẹphe gude owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe ọphu dụ uswe-uswe; waa owu ọchaa, a swịru ụdo; metachaa iphe, dụgbaa g'akpụru itorokuma; dophee ọnu uwe ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ẹphe bya egude ọkpobe mkpọla-ododo meshia ọkunmengu dophee igburọnu uwe ono mgburugburu lẹ mgbaka iphe ono, dụgbaa g'akpụru itorokuma ono. ");
INSERT INTO izz_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ọkunmengu ono; waa iphe ono, e meru; ọ dụ g'akpụru itorokuma ono; nọ-phee igburọnu uwe ono mgburugburu. E dongakọtaru phẹ edonga l'ọnu uwe ono, ee-yeje ejeru Chipfu ozi ono, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ẹphe gude owu ọchaa kweeru Erọnu; yẹe ụnwu iya uwe mgbalanụ. Ọ bụru onye maru ekwe ẹkwa ree kweru iya. ");
INSERT INTO izz_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ẹphe gudekwaphọ owu ọchaa kwee okpulishi-ẹkwa ono; waa okpu ndu-uke ono; gude owu ọchaa, a swịru ụdo kwee nwịba ono. ");
INSERT INTO izz_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ẹphe gude owu ọchaa, a swịru ụdo; waa owu, dụ urwukpu-urwukpu; waa ọphu eke mee-mee; yẹe ọphu dụ uswe-uswe kwee ẹkwa-atụ-buta-l'upfu ono. Ọ bụru onye maru ekwe ẹkwa kweru iya; bya abụru gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ẹphe gude ọkpobe mkpọla-ododo meta iphe, dụ g'okwekpu; dee ya iphe g'eedeje l'iphe-ọhubama-a. Iphe, ẹphe deru iya bụ: IPHE, DỤRU CHIPFU NSỌ. ");
INSERT INTO izz_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ẹphe bya ewota eri, e gude owu, dụ urwukpu-urwukpu swịa; libe l'iphe ono, dụ g'okwekpu ono; woru iya lipyabẹ l'atatiphu okpulishi-ẹkwa, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nta-a bẹ ụlo-ẹkwa ono; mbụ ụlo-ẹkwa-ndzukọ ono bẹ e meghewaru. Ndu Ízurẹlu tụkoeru iya phọ mekọta gẹ Chipfu sụru Mósisu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Noo ya; ẹphe chịta iphe ụlo-ẹkwa ono g'ọ ha chịtaru Mósisu; mbụ ụlo-ẹkwa ono; mẹ ngwa iya, dụ g'iphe iya ono, nweru nkoloba ono; waa mgbo ono, ee-gude kụ-chite ụlo-ẹkwa ono; waa oshi ono, ee-gudegbaa swebushia lẹ mgbo ono; waa itso iya ono; yẹe ẹnya ẹka aa-kpọbechaa itso ono; waa ọkpa mgbo ono. ");
INSERT INTO izz_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ẹphe chịtakwarupho akpọ ebili ono, a tsẹru l'uswe, ee-gude kpua ụlo-ẹkwa ono; waa akpọ umoro-ẹnyimu ono; waa ẹkwa ono, ee-gude kobuta ẹka-kakọta-adụ-nsọ ono; ");
INSERT INTO izz_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","waa okpoko-ekemu ono; yẹe mgbọro ono, ee-gudeje apa iya ono; waa opfu okpoko ono, aa-nọduje apfụ ụgwo iphe-ẹji ono; ");
INSERT INTO izz_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","waa teburu ono; yẹe ngwa iya; waa buredi ono, ee-dobeje l'iphu Chipfu ono; ");
INSERT INTO izz_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","waa iphe ono, aapfụbeje orọku ono, e meru l'ọkpobe mkpọla-ododo ono; waa orọku iya ono; yẹe ngwa iya; waa manụ ono, ee-gudeje anwụ ọku ono; ");
INSERT INTO izz_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","waa ọru-ngwẹja ono, e meru lẹ mkpọla-ododo ono; waa manụ ono, aa-wụ l'ishi ono; waa ụ̀nwù-isẹnsu ono, eshi mkpọ ono; waa ẹkwa ono, ee-kochite ọnu-abata ụlo-ẹkwa ono; ");
INSERT INTO izz_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","waa ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono, e gude onyirubvu mee ono; waa iphe iya ono, dụ g'ụgbu ono; waa mgbọro iya; yẹe ngwa iya g'ọ ha; waa eze gbamụgbamu ono; yẹe iphe ono, aa-sụbeje iya ono; ");
INSERT INTO izz_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","waa ẹkwa ono, ee-gude gebuta ọma-unuphu ono; yẹe itso iya; waa ẹnya ẹka aa-kpọbechaa itso ono g'ọ ha; waa ẹkwa, ee-gude gechite ọnu-abata ọma-unuphu ono; waa eri iya; yẹe nggu iya; yẹe iphemiphe, ee-gude eje ozi l'ụlo-ẹkwa ono; mbụ ụlo-ẹkwa-ndzukọ ono; ");
INSERT INTO izz_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","waa uwe ono, e kweru ekwekwe, ee-yeje gude eje ozi l'ụlo-nsọ ono; mbụ uwe, dụ nsọ kẹ Erọnu, bụ onye uke; yẹe k'ụnwu iya, ẹphe e-yeje m'ẹphe nọdu eje ozi uke phẹ. ");
INSERT INTO izz_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ndu Ízurẹlu tụkoepho iphemiphe ono mekọta gẹ Chipfu tụru Mósisu ọnu iya. ");
INSERT INTO izz_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mósisu bya elee ẹnya l'ozi ono; hụma l'ẹphe jekọtaeru iya phọ gẹ Chipfu sụru g'e mee ya. Ọo ya bụ; ọ bya agọru ọnu-ọma nụ phẹ; gude kele phẹ ekele ozi ono, ẹphe jeru ono. ");
INSERT INTO izz_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Noo ya; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kpọbe ụlo-ẹkwa ono; mbụ ụlo-ẹkwa-ndzukọ; lẹ mbọku, ọnwa mbụ fụerupho. ");
INSERT INTO izz_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Parụ okpoko-ekemu ono sụbe iya l'ime; l'i wota ẹkwa ono gude kobuta iya. ");
INSERT INTO izz_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","L'ị pabata teburu ono; yẹe ngwa iya. L'ị pabatakwapho iphe ono, aapfụbeje orọku ono; dozichaa orọku, dụ iya nụ. ");
INSERT INTO izz_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","L'ị patakwaphọ ọru-ngwẹja-ụ̀nwù-isẹnsu ono, e meru lẹ mkpọla-ododo ono; sụbe l'atatiphu okpoko-ekemu ono; gude ẹkwa ono kobuta ọnu-abata ụlo-ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“L'ị sụbe ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono l'atatiphu ọnu-abata ụlo-ẹkwa ono; mbụ ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","L'ị pata eze gbamụgbamu ono sụbe lẹ mgbaka ụlo-ẹkwa-ndzukọ ono; yẹe ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono; kuru mini ye iya. ");
INSERT INTO izz_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","L'ị chịta ẹkwa ọma-unuphu ono gude kobuta ọma-unuphu mgburugburu; wotakwaphọ ẹkwa ọnu-abata ọma-unuphu ono kochite ọnu-abata iya. ");
INSERT INTO izz_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","L'i wota manụ ono, aa-wụ l'ishi ono; wụa l'ụlo-ẹkwa ono; yẹe iphemiphe, nọkota iya nụ; shi nno doo yẹe iphemiphe, nọ iya nụ nsọ; g'ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","L'ị wụkwapho ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono manụ; yẹe ngwa iya g'ọ ha; shikwaphọ nno doo ya nsọ; g'ọ bụru iphe, dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","L'ị wụkwapho eze gbamụgbamu ono; yẹe ọkpa iya manụ; shi nno doo ya nsọ. ");
INSERT INTO izz_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“L'i duta Erọnu; yẹe ụnwu iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ ono; wụa phẹ ẹhu. ");
INSERT INTO izz_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","L'ị chịta uwe ono, dụ nsọ ono yee Erọnu; wụa ya manụ l'ishi gude doo ya nsọ; k'ọphu ọo-bụru onye uke; jeeru mu ozi. ");
INSERT INTO izz_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","L'i dutakwaphọ ụnwu iya yeshia phẹ uwe mgbalanụ phẹ. ");
INSERT INTO izz_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","L'ị wụa phẹ manụ l'ishi g'ị wụru nna phẹ; g'ẹphe bụru ndu-uke jeeru mu ozi. Manụ ono, ịi-wụ phẹ l'ishi ono e-me phẹ; g'ẹphe bụru ndu-uke; e -shi l'ọgbo sweru ọgbo.” ");
INSERT INTO izz_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mósisu tụko iphemiphe mekọta gẹ Chipfu tụru iya ọnu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","O be l'apha k'ẹbo lẹ mbọku, ọnwa mbụ fụru; e woru ụlo-ẹkwa ono kpọbe. ");
INSERT INTO izz_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mósisu woru ẹnya ẹka aa-kpọbechaa mgbo ụlo-ẹkwa ono; waa itso iya; pfụbegbaa; bya akpọbe iya mgbo ono; bya eye iya iphe ono, ee-gude swebushia lẹ mgbo ono; bya kpọbekwa iya phọ itso ono; shi nno kpọbe ụlo-ẹkwa ono teke ono. ");
INSERT INTO izz_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","O wota ẹkwa ono phụshi l'eli ụlo-ẹkwa ọbu; bya achịta iphe phụ-chite ụlo-ẹkwa ono, bụ iya bụ gẹ Chipfu sụru g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ọ pata ekemu ono ye l'ime okpoko ono; woru mgbọro iya ono pyochaa l'okpoko ono; bya apata opfu okpoko ono, aa-nọdu apfụ ụgwo iphe-ẹji ono; sụbe iya l'eli. ");
INSERT INTO izz_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ọ gbẹ teke ono pata okpoko ono pabata l'ụlo-ẹkwa ono; bya eworu ẹkwa ono kobuta okpoko-ekemu ono, bụ iya bụ gẹ Chipfu tụru iya ọnu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mósisu bya apata teburu ono sụbe l'ụlo-ẹkwa-ndzukọ ono l'ụzo isheli; l'okotazụ ẹkwa, e gude kobuta ẹka-kakọta-adụ-nsọ ono. ");
INSERT INTO izz_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","O woru buredi ono dobe l'atatiphu Chipfu, bụ iya bụ gẹ Chipfu tụru iya ọnu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ọ pata iphe ono, aapfụbeje orọku ono sụbe l'ụlo-ẹkwa-ndzukọ ono l'ụzo ndọhali; yẹle teburu ono ghagbabẹ iphu; ");
INSERT INTO izz_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","bya anọdu l'iphu Chipfu l'ẹka ono mezichaa orọku, dụ iya nụ, bụ iya bụ gẹ Chipfu tụru iya ọnu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ọ patakwaphọ ọru-ngwẹja ono, e meru lẹ mkpọla-ododo ono sụbe l'atatiphu ẹkwa ono, e gude kobuta ẹka-kakọta-adụ-nsọ ono; ");
INSERT INTO izz_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","bya akpọ ụ̀nwù-isẹnsu ọku l'ọru-ngwẹja ono, bụ iya bụ gẹ Chipfu ziru iya g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","O wota ẹkwa ono gude kochite ọnu-abata ụlo-ẹkwa ono; ");
INSERT INTO izz_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","bya eworu ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono sụbe lẹ mgboru ọnu-abata ụlo-ẹkwa-ndzukọ ono; bya egweeru Chipfu ngwẹja-akpọ-ọku; yẹe ngwẹja-nri l'ọru-ngwẹja ono, bụ iya bụ gẹ Chipfu tụru iya ekemu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ọ bya apata eze gbamụgbamu ono sụbe lẹ mgbaka ụlo-ẹkwa-ndzukọ ono; yẹe ọru-ngwẹja ono, bụ ẹka ee-gweje ngwẹja-akpọ-ọku ono. ");
INSERT INTO izz_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ọ bụru eze gbamụgbamu ono bẹ Erọnu yẹe ụnwu iya; waa Mósisu gude kwọo ẹka; yẹe ọkpa. ");
INSERT INTO izz_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ọ nọdu abụjeru; ẹphe -mee g'ẹphe bahụ l'ụlo-ẹkwa-ndzukọ ono; ọzoo g'ẹphe kpịritaru ntse l'ọru-ngwẹja ono, bụ ẹka eegweje ngwẹja-akpọ-ọku ono; ẹphe akwọadaa ẹka yẹe ọkpa, bụ iya bụ gẹ Chipfu tụru phẹ ekemu g'ẹphe meje iya. ");
INSERT INTO izz_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mósisu bya achịtakwapho ẹkwa ọma-unuphu ono gude kobuta ọma-unuphu ụlo-ẹkwa ono yẹle ọru-ngwẹja ono mgburugburu; wotakwaphọ ẹkwa ọnu-abata ọma-unuphu ono kochite ọnu-abata iya. Ọ bụru iya bụ lẹ Mósisu ejeghee ozi ọbu. ");
INSERT INTO izz_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Noo ya; urwukpu ono bya asọ-kpute ụlo-ẹkwa-ndzukọ ono; akpabiri Chipfu bya eji ụlo-ẹkwa ono ejiji. ");
INSERT INTO izz_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ọphu Mósisu adụkpodanu ike ye ishi l'ụlo-ẹkwa-ndzukọ ono; noo kẹle urwukpu sọ-kputeru iya; tẹme akpabiri Chipfu ji ụlo-ẹkwa-ndzukọ ono ejiji. ");
INSERT INTO izz_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ndu Ízurẹlu nọdu abụjeru; teke urwukpu ono wụkahuru l'eli ụlo-ẹkwa ono; ẹphe akwalia. ");
INSERT INTO izz_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Teke urwukpu ono atụgbuduru; ẹphe anọdu l'ẹka ẹphe nọ gbiriri jasụ mbọku, urwukpu ono a-tụgbu. ");
INSERT INTO izz_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ọo ya bụ; urwukpu Chipfu, nọ asọ-kputajẹ ụlo-ẹkwa ono l'eswe; teke o beru l'ẹnyashi l'o nwuahaa g'ọku l'atatiphu ndu Ízurẹlu. Ọ bụru g'o mekọtaru bụ ono jasụ ndu Ízurẹlu jeghee ije phẹ ono.");
INSERT INTO izz_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Chipfu gbẹ l'ụlo-ẹkwa-ndzukọ kua Mósisu oku bya epfuru yeru iya; sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Waa opfu, ii-pfuru nụ ụnwu Ízurẹlu baa: Ọ -dụru g'unu ha onye gude ngwẹja abya anụ Chipfu; g'onye ono jejekwa l'ẹka eswi; ọzoo atụru mẹ eghu iya dọru je akpụta nanụ gude bya anụ iya. ");
INSERT INTO izz_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Ọ -bụru onye bụ eswi bẹ o gude abya egweru mu ngwẹja-akpọ-ọku; g'onye ono kpụtakwa oke-eswi, adụdu ẹka iphe mebyiru iya; bya anụ l'ọnu-abata ụlo-ẹkwa-ndzukọ; k'ọphu Chipfu a-natakwanụ iya. ");
INSERT INTO izz_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","G'onye ono byabẹ anụ ono, ọ nụru g'ọ bụru ngwẹja-akpọ-ọku ono ẹka l'ishi. Aa-nata iya g'ọ nọchia ẹnya onye ono; bụru iphe, ee-gude pfụa ụgwo iphe-ẹji, onye ono meshiru. ");
INSERT INTO izz_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","G'onye ono nọdu l'iphu Chipfu gbua oke-eswi ono. Ụnwu Erọnu, bụ ndu-uke egude mee oke-eswi ono phephee ọru-ngwẹja mgburugburu; mbụ l'ọnu-abata ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","G'ọ swakwaa anụ ono akpọ; bushia anụ iya iphiriba iphiriba. ");
INSERT INTO izz_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ụnwu Erọnu ono, bụ onye uke ono abya akpọbe ọku l'ọru-ngwẹja ono; bya eworu nkụ doo byẹmubyemu l'ọku ono. ");
INSERT INTO izz_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ndu uke ono, bụ iya bụ ụnwu Erọnu ono abya eworu iphiriba iphiriba anụ ono; mẹkpoo ishi iya; yẹe ẹ̀bà iya doo lẹ nkụ ono, e doru l'ọku ono, a kpọberu l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Iphe-ẹpho iya; waa ẹka iya; mẹ ọkpa iya bẹ onye ono e-gude mini saa asasa. E -mechaa; onye uke atụko iphemiphe ono kpọo ọku l'ọru-ngwẹja ono; g'ọ bụru ngwẹja-akpọ-ọku; mbụ ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Ọ -bụru l'onye ọbu bụ eghu; ọzoo atụru bẹ o gude bya egwe ngwẹja-akpọ-ọku; g'ọ bụkwaru iphe, oo-wota bụ okee ya, adụdu ẹka iphe mebyiru iya. ");
INSERT INTO izz_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","G'onye ono gha iphu l'ụzo isheli woru iphe-ngwẹja ono gbua lẹ mgburẹku ọru-ngwẹja ono l'atatiphu Chipfu. Ụnwu Erọnu, bụ ọgbo-uke eworu mee anụ ono phephee mgburugburu ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Onye ono eworu anụ ngwẹja ono bushia iphiriba iphiriba. Onye uke abya achịru yẹle ishi iya; yẹe ẹ̀bà iya doo byẹmubyemu l'eli nkụ ono, nọ l'ọku ono, a kpọberu l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Iphe-ẹpho iya; waa ẹka iya; yẹe ọkpa iya bẹ onye ono e-gude mini saa asasa. Onye uke atụko iphemiphe ono kpọo ọku l'ọru-ngwẹja ono; g'ọ bụru ngwẹja-akpọ-ọku; mbụ ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Ọ -bụru l'ọo iphe furu ǹkù bẹ onye ọbu gude bya egweru Chipfu ngwẹja-akpọ-ọku ọbu; g'ọ bụkwaru ndo; ọzoo kparaka bẹ oo-gude bya. ");
INSERT INTO izz_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Onye uke anwụta iya bya l'ọru-ngwẹja ono; bya aswị-bufu iya ishi woru iya kpọo ọku l'ọru-ngwẹja onoya. L'ọ haa mee ya g'ọ lashịa l'agụga ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","L'ọ bya achịfuta iya ọkpa-nri; bya anmashịa ya ẹba bya eworu iya wụshi l'ibiya k'ụzo ẹnyanwu-awawa ọru-ngwẹja ono; mbụ l'ụzo ẹka ono, aawụshije ntụ ono. ");
INSERT INTO izz_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","L'ọ gbẹ lẹ ǹkù ẹnu ono lajaa ya ẹbo g'o gheru ọnu; ọle g'ọ tọ lajahashị iya ẹbo g'ọ nọdu iche iche. Onye uke abya eworu iya kpọo ọku l'ọru-ngwẹja; mbụ l'eli nkụ ono, e doru l'eli iya ono; g'ọ bụru ngwẹja-akpọ-ọku; mbụ ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree.” ");
INSERT INTO izz_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Ọ -bụru onye gude ngwẹja-nri abya agwa Chipfu; g'onye ono gude ukpokutu iphe gude bya. L'ọ gbashị iya manụ; yekwa iya phọ ụ̀nwù-isẹnsu. ");
INSERT INTO izz_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","O -mechaa ya nno l'o woru iya nụ ụnwu Erọnu, bụ ndu-uke. G'onye uke woru ukpokutu iphe ọphu jiru mkpoji-ẹka a gbashịru manụ; bya eworu iphe, bụ ụ̀nwù-isẹnsu, e yeru iya kpọo ọku l'ọru-ngwẹja ono; g'ọ nọchia ẹnya ngwẹja-nri ono; g'ọ bụru iphe, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ngwẹja-nri ono ọphu ghuduru nụ a-bụwaro kẹ Erọnu yẹe ụnwu iya. Ọ dụ nsọ shii kẹle o shi lẹ ngwẹja, aakpọ ọku anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Teke ọ bụ ngwẹja-nri, e gheru lẹ ntụ-ọku bẹ i wotaru; g'ọ bụkwaru akara, e yedụru iphe, ekoje buredi, e meru l'ukpokutu witi, a gwọru lẹ manụ; ọdumeka l'ọ bụru ẹcha-mbekee, e yedụru iphe, ekoje buredi, a gwọru lẹ manụ. ");
INSERT INTO izz_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Teke ọ bụ lẹ ngwẹja ngu bụ ngwẹja-nri ọphu e gheru lẹ mbeji; g'ọ bụkwaru ukpokutu ereshi, a gwọru lẹ manụ; mbụ ereshi, e yedụru iphe, ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Gwepyashịa ya egwepyashị; l'ị bya agbashị iya manụ l'eli; kẹle ọ bụkwa ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Teke ọ bụ lẹ ngwẹja ngu bụ ngwẹja-nri, e shiru l'ite; g'ọ bụkwaru ukpokutu ereshi, e yeru manụ bẹ ii-gude mee ya. ");
INSERT INTO izz_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ọ bụru ngwẹja-nri, dụgbaa ẹgube ono bẹ unu e-gudeje byapfuta Chipfu. Teke e gwetarụ iya bya anụ onye uke; l'o gude iya bya l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Onye uke ono e-wota ọphu a-nọ-chi ẹnya ngwẹja ono je akpọo ọku l'ọru-ngwẹja; g'ọ bụru ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ngwẹja-nri ono ọphu phọduru nụ bụwaa kẹ Erọnu yẹe ụnwu iya. Ọ dụ nsọ shii kẹle o shi lẹ ngwẹja, aakpọ ọku anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“G'ọ tọ dụkwa ngwẹja-nri, unu gude abya agwa Chipfu, unu e-yeje iphe, ekoje buredi. Mbụ-a; g'ọ tọ dụkwa iphe, e yeru iphe, ekoje buredi; ọzoo manụ-ẹnwu, unu e-ye lẹ ngwẹja, unu akpọ ọku anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unu e-yekọbeje iya lẹ ngwẹja akpụru mbụ, iphe, unu kọru l'opfu unu mịtaru abya anụ Chipfu. Obenu lẹ-a; g'a ta kpọkwa iya ọku l'ọru-ngwẹja g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","G'onye gude ngwẹja-nri abya agwa Chipfu yejekwa iya únú. Ọphu i kwejekwa g'únú ọgbandzu Chileke ngu ono ta adụ lẹ ngwẹja-nri ngu. Mbụ-a; yejekwa únú l'iphe, bụkpoo ngwẹja, iigwekpọo egwegwe. ");
INSERT INTO izz_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Ọ -bụru l'unu gude akpụru mbụ, iphe, unu kọru l'opfu unu mịtaru gude abya egweru Chipfu ngwẹja-nri; unu gbutakwa ishi ereshi, dụkwadu oyii; hụa ahụ̀hù gude gwee ngwẹja-nri ọbu; unu tsukwaa ya etsutsu. ");
INSERT INTO izz_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Unu gbashịkwa iya manụ; yekwa iya phọ ụ̀nwù-isẹnsu; kẹle ọ bụkwa ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","G'onye uke hata nwọphu a-nọ-chi ẹnya ngwẹja ono kpọo ọku; mbụ iphe, shi l'ereshi ono, e tsuru etsutsu gbashị iya manụ ono; mẹkpoo iphe, bụ ụ̀nwù-isẹnsu, e yeru iya. Ọ bụakwaa ngwẹja, aakpọ ọku anụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Ọ -bụru onye gude ngwẹja-ẹhu-guu abya agwa Chipfu; ọ -bụru oke-eswi; ọzoo ne iya bẹ o gude abya agwa Chipfu ọbu; g'onye ono gudekwa ọphu adụdu ẹka iphe mebyiru iya. ");
INSERT INTO izz_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","G'onye ono woru ẹka byabẹ iphe ngwẹja ono l'ishi. O -mechaa nno l'o woru iya gbua l'ọnu-abata ụlo-ẹkwa-ndzukọ. E -gbuchaa ya; ụnwu Erọnu, bụ ndu-uke egude mee-iphe ono je ephephee ọru-ngwẹja mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","L'ọ gbẹ l'iphe ngwẹja-ẹhu-guu ono bọta anụ, aa-kpọ ọku nụ Chipfu. Iphe, aa-bọta bụ ẹba, kwechiru iphe-ẹpho iya; waa ọphu nọkota l'iphe-ẹpho iya l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","L'ọ bọtakwapho àkpụ̀rù iya ẹphenebo yekọbe iya; waa ẹba, dụ iya nụ, bụ ọphu nọ l'ụzo ose iya. G'ọ tụko anya iya ẹphe l'àkpụ̀rù iya ono bọfuchaa. ");
INSERT INTO izz_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","G'ụnwu Erọnu woru iya kpọo ọku l'ọru-ngwẹja l'eli ngwẹja-akpọ-ọku ono, nọ l'eli nkụ, e doru l'ọku ono; g'ọ bụru ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Ọ -bụru onye bụ atụru; ọzoo eghu bẹ o gude abya anụ Chipfu ngwẹja-ẹhu-guu; ọ -bụ okee ya-o; ọzoo nyee ya-o; g'ọ nụkwa ọphu adụdu ẹka iphe mebyiru iya. ");
INSERT INTO izz_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ọ -bụru nwatụru bẹ onye ono kpụ bya anụ kẹ ngwẹja ọbu; g'ọ kpụkwaru iya bya l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","G'onye ono woru ẹka byabẹ iphe ngwẹja ono l'ishi; woru iya gbua l'ọnu-abata ụlo-ẹkwa-ndzukọ. E -mechaa; ụnwu Erọnu egude mee anụ ono je ephephee ọru-ngwẹja mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Onye ono abya agbẹ l'anụ ngwẹja-ẹhu-guu ono buta anụ, ee-gude gweeru Chipfu ngwẹja, aa-kpọ ọku nụ iya. Ẹba iya g'ọ ha bẹ ee-hetagbu; tẹme l'a gbẹ lẹ mgboru ọkpu okpurukpu iya gbujita upfumọdzu iya l'ophu, bụ ẹka ẹba adụje ono. Ẹba, kwechiru iphe-ẹpho iya; waa ọphu nọkota l'iphe-ẹpho iya bẹ ee-hetafua. ");
INSERT INTO izz_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","L'ọ bọtakwapho àkpụ̀rù iya ẹphenebo yekọbe iya; waa ẹba, dụ iya nụ, bụ ọphu nọ l'ụzo ose iya. G'ọ tụko anya iya; ẹphe lẹ àkpụ̀rù iya ono bọfuchaa. ");
INSERT INTO izz_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Onye uke ewota iya je akpọoru Chipfu ọku l'ọru-ngwẹja; kẹle ọ bụ nri; mbụ ngwẹja, aakpọ ọku anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Ọ -bụru onye bụ eghu bẹ ọ kpụ bya egwe ngwẹja ọbu; g'onye ono kpụtakwa iya phọ bya l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","G'onye ono wokwarụpho ẹka byabẹ eghu ono l'ishi; woru iya gbua l'atatiphu ụlo-ẹkwa-ndzukọ. Ụnwu Erọnu eworu mee ya je ephephee l'ọru-ngwẹja mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Iphe, oo-wofuta l'anụ ono gude gweeru Chipfu ngwẹja, aakpọ ọku bụ ẹba, kwechiru iphe-ẹpho iya; mẹ ọphu nọkota l'iphe-ẹpho iya. ");
INSERT INTO izz_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","L'ọ bọtakwapho àkpụ̀rù iya ẹphenebo yekọbe iya; waa ẹba, dụ iya nụ, bụ ọphu nọ l'ụzo ose iya. G'ọ tụko anya iya ẹphe l'àkpụ̀rù iya ono bọfuchaa. ");
INSERT INTO izz_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Onye uke ewota iya je akpọo ọku l'ọru-ngwẹja; g'ọ bụru nri, e gwerụ ngwẹja, aakpọ ọku, mkpọ iya dụ Chipfu ree. Ẹba anụ l'ophu bụkota kẹ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ekemu-a bụ ekemu, a-nọ; e -shi l'ọgbo sweru ọgbo l'ẹka bụkpoo ẹka unu bu: Unu ta atajẹkwa ẹba-iphe; ọzoo mee ya.” ");
INSERT INTO izz_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Tọbudu iya bụ; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Waa iphe, ii-pfuru ndu Ízurẹlu baa: Teke ọ dụru onye meru iphe-ẹji l'amagama; mee iphe, Chipfu tụru ekemu sụ g'e te emeshi. ");
INSERT INTO izz_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Ọ -bụru onye uke, a wụru manụ l'ishi meru iphe-ẹji ọbu; shi nno meta ikpe-anmanma kpua ọha l'ophu; g'onye ono kpụtakwa oke-eswi, adụdu ẹka iphe mebyiru iya; gude bya ewotaru Chipfu g'ọ bụru ngwẹja-iphe-ẹji k'iphe-ẹji ono, o meru ono. ");
INSERT INTO izz_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","G'onye ono kpụta oke-eswi ono gude bya l'iphu Chipfu l'ọnu-abata ụlo-ẹkwa-ndzukọ. L'o woru ẹka byabẹ oke-eswi ono l'ishi; gbua ya l'iphu Chipfu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","G'onye uke ono, a wụru manụ l'ishi ono harụ meta mee oke-eswi ono gude bahụ l'ime ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","L'ọ tsẹe mkpụshi-ẹka lẹ mee ono phee mgbo ẹsaa l'atatiphu Chipfu; mbụ l'atatiphu ẹkwa ono, dụ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Onye uke ono abya emetakwaphọ mee anụ ono wụru ye lẹ mpu phọ, e mobegbaaru l'ọru-ngwẹja ụ̀nwù-isẹnsu; mbụ ọru-ngwẹja ono, nọ l'atatiphu Chipfu l'ụlo-ẹkwa-ndzukọ. L'ọ pata mee ọphu phọduru nụ je awụru ye l'ọkpali ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku, nọ l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","“L'ọ bya eheshikọta iphe, bụ ẹba, dụ l'oke-eswi ono, e gude egwe ngwẹja-iphe-ẹji ono; mbụ ẹba, kwechiru iphe-ẹpho iya; mẹkpoo ẹba, kweru iphe-ẹpho iya ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","L'ọ bya abọfu iya àkpụ̀rù iya ẹphenebo; bya eheshikọta iya ẹba, dụ iya nụ, bụ ọphu nọ l'ụzo ose iya. G'ọ tụko anya iya; ẹphe l'àkpụ̀rù iya ono bọfuchaa. ");
INSERT INTO izz_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ọo ẹgube ono, eeheshije ẹba l'oke-eswi, e gude egwe ngwẹja-ẹhu-guu ono bụ g'ee-heshikwaphọ ọwa. E -mechaa ya nno; onye uke ono ewota iya je akpọo ọku l'ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Akpọ oke-eswi ono; mẹ anụ iya l'ophu; je akpaa l'ishi iya; mẹ ẹka iya; mẹ ọkpa iya; waa iphe-ẹpho iya; mẹ nshị iya; ");
INSERT INTO izz_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mbụ anụ eswi ono g'ọ hakọta bẹ oo-gude lụfu l'ẹka ndu Ízurẹlu kpọbegbaaru ụlo-ẹkwa phẹ. G'o gude iya je l'ẹka e te merwushiduru emerwụshi; mbụ l'ẹka aawụshije ntụ ono; je akpọo ya ọku l'eli ntụ ono. ");
INSERT INTO izz_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Teke ọ bụ l'ọo ndu Ízurẹlu l'ophu meru iphe-ẹji l'amagama; shi nno mee iphe, Chipfu tụru ekemu sụ g'e te emeshi; obeta ọ bụru l'ẹphe ta amadụ iphe, meru nụ; bẹ ikpe nmakwaru phẹ. ");
INSERT INTO izz_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Teke ọ bụkwanu l'iphe, ẹphe meru bẹ ẹphe byaru amaru; gẹ ndu Ízurẹlu kpụtakwa nwa oke-eswi gude bya l'iphu ụlo-ẹkwa-ndzukọ bya egweeru Chileke ngwẹja-iphe-ẹji ono. ");
INSERT INTO izz_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Gẹ ndu bụ ọgerenya ndu Ízurẹlu byabẹ oke-eswi ono ẹka l'ishi l'atatiphu Chipfu; l'e woru nwa oke-eswi ono gbua l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","G'onye uke, a wụru manụ l'ishi meta mee oke-eswi ono gude bahụ l'ụlo-ẹkwa-ndzukọ; ");
INSERT INTO izz_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","tsẹe mkpụshi-ẹka lẹ mee anụ ono; phee mgbo ẹsaa l'atatiphu Chipfu; mbụ l'iphu ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","“L'o metakwaphọ mee ono wụru ye lẹ mpu, e moberu l'ọru-ngwẹja; mbụ ọru-ngwẹja ono, nọ l'atatiphu Chipfu l'ụlo-ẹkwa-ndzukọ ono. L'ọ pata mee ono ọphu phọduru nụ je awụru ye l'ọkpali ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku, bụ ọphu nọ l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ẹba anụ ono l'ophu bẹ oo-heshikọta kpọo ọku l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ọo ẹpho g'o meru oke-eswi ono, e gude gwee ngwẹja-iphe-ẹji ono bụ g'oo-mekọta oke-eswi ọwa-a. Ọo ẹgube ono bụ g'onye uke ono e-shi pfụaru phẹ ụgwo iphe-ẹji ọbu, ẹphe meru ọbu; k'ọphu aa-gụkwanuru phẹ nvụ. ");
INSERT INTO izz_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","L'ọ pata anụ oke-eswi ono gude lụfu l'azụ ẹka ndu Ízurẹlu kpọbegbaaru ụlo-ẹkwa phẹ je akpọo ọku g'a kpọru oke-eswi k'ivuzọ phọ. Ono abụru ngwẹja-iphe-ẹji ọha l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Ọ -bụru onye-ishi meru iphe-ẹji l'amagama; mbụ mee iphe, Chipfu, bụ Chileke iya tụru ekemu sụ g'e te emeshi; bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ọ -bụru l'iphe-ẹji ono, o meru bẹ e meru; ọ maru; iphe, oo-wota bụ mkpi, adụdu ẹka iphe mebyiru iya g'ọ bụru ngwẹja iya. ");
INSERT INTO izz_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","L'ọ byabẹ mkpi ono ẹka l'ishi woru iya gbua l'ẹka eegbuje anụ, e gude egwe ngwẹja-akpọ-ọku l'atatiphu Chipfu. Ọ kwa ngwẹja-iphe-ẹji bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","G'onye uke tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpu, e mobegbaaru l'ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku. L'ọ bya eworu mee ono, phọduru nụ ono wụru ye l'ọkpali ọru-ngwẹja ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ẹba anụ ono l'ophu bẹ oo-heshikọta kpọo ọku l'ọru-ngwẹja; g'a kpọru kẹ ngwẹja-ẹhu-guu phọ. Onye uke eshi nno pfụa ụgwo iphe-ẹji ọbu, onye ono meru ọbu; g'eeshi nno gụkwanaaru onye ono nvụ l'iphe-ẹji iya ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Ọ -bụru l'ọ dụru onye Ízurẹlu mmanụ ọzo, meru iphe-ẹji l'amagama; mbụ mee iphe, Chipfu tụru ekemu sụ g'e te emeshi; bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ọ -bụru l'iphe-ẹji ono, o meru ono bẹ e meru; ọ maru; iphe, oo-wota bụ nyee eghu, adụdu ẹka iphe mebyiru iya; g'ọ bụru ngwẹja k'iphe-ẹji ono, o meru ono. ");
INSERT INTO izz_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","G'ọ byabẹ ẹka l'ishi anụ ono; woru iya gbua l'ẹka eegbuje anụ, e gude egwe ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","G'onye uke tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpu, e mobegbaaru l'ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku. L'ọ bya eworu mee ono, phọduru nụ ono wụru ye l'ọkpali ọru-ngwẹja ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","L'ọ bya eheshikọta ẹba, nọ l'anụ ono; mbụ ẹgube ono, eemeje kẹ ngwẹja-ẹhu-guu ono. Onye uke akpọo ya ọku l'ọru-ngwẹja; g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree; g'o shi nno pfụa ụgwo iphe-ẹji, onye ọbu meru; k'ọphu aa-gụkwanuru iya nvụ. ");
INSERT INTO izz_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Teke ọ bụ atụru bẹ onye ono gude bya anụnu kẹ ngwẹja-iphe-ẹji ọbu; g'onye ono gudekwa ada atụru, adụdu ẹka iphe mebyiru iya. ");
INSERT INTO izz_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","G'o wokwarụpho ẹka byabẹ l'ishi anụ ono; woru iya gbua; g'ọ bụru ngwẹja-iphe-ẹji. Ẹka ọo-nọdu gbua ya bụ ẹka eegbuje anụ, e gude egwe ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","G'onye uke tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpu ono, e mobegbaaru l'ọru-ngwẹja ẹka eegweje ngwẹja-akpọ-ọku. L'ọ bya eworu mee ono, phọduru nụ ono wụru ye l'ọkpali ọru-ngwẹja ọbu. ");
INSERT INTO izz_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","L'ọ bya eheshikọta ẹba, nọ l'anụ ono; mbụ ẹgube ono, eemeje kẹ ngwẹja-ẹhu-guu ono. Onye uke akpọo ya ọku l'ọru-ngwẹja; g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree; g'o shi nno pfụa ụgwo iphe-ẹji, onye ọbu meru; k'ọphu aa-gụkwanuru iya nvụ.” ");
INSERT INTO izz_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Ọ -bụru lẹ nemadzụ meru iphe-ẹji; kẹle ọ hụmaru iphe, nwụru nụ; ọzoo l'e meru ọ maru iphe, nwụru nụ; a raarụ iya ọha arara g'onye hụmaru nụ bya agbaa ekebe; ọphu o jeduru agba ekebe ọbu; bẹ ẹjo-iphe ono, o meru ono tukowaru onye ono l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Ọzoo l'ọ dụru onye denyiru ẹka l'iphe, aasọ nsọ; mbụ l'iphe, dụ g'odzu anụ-ẹgbudu, aasọ nsọ; ọzoo l'ọo odzu iphe-edobe, aasọ nsọ; ọzoo l'odzu iphe, akpụ wuruwuru l'alị, aasọ nsọ; bẹ onye ọbu bụakwaa onye aasọ nsọ; m'obeta ọphu ọ tọ madụ l'o denyiru iya ẹka; bẹ ọ bụakwaa onye ikpe nmarụ. ");
INSERT INTO izz_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Ọzoo l'o denyiru ẹka l'iphe, aasọ nsọ, shi nemadzụ l'ẹhu; g'iphe, aasọ nsọ ọbu adụhabe, bụ iphe, emeje gẹ nemadzụ bụru onye aasọ nsọ; m'obeta ọphu ọ madụ l'o denyiru iya ẹka; bẹ ọo-bụkwaru onye ikpe nmarụ mẹ ọ maẹrupho. ");
INSERT INTO izz_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Onye arịduru iphe ọriri; ọ pfụ-bilihuẹpho rịa angụ sụ lẹ ya e-me iphe; m'ọ bụ iphe, dụ ree; m'ọ bụ ẹjo iya; ọ tọ dụkpodaa m'obeta ọ bụru ẹgube gụnu bẹ onye ọbu riru angụ ememe; l'ẹbe o vuadaru ụzo rịa ya ọriri; bẹ ikpe nmaakwaru iya; m'ọ maẹrupho. ");
INSERT INTO izz_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Ọ -bụru l'ọ dụru onye meru iphe-a, a gụshiru-a; shi nno mee; ikpe nma iya; g'onye ono pfukwaa iphe, o meru. ");
INSERT INTO izz_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","G'onye ono, mesweru nụ ono shi l'ẹka eghu iya mẹ atụru iya dọru; kpụta ada atụru; ọzoo ada eghu bya anụ Chipfu g'ọ bụru ngwẹja-iphe-ẹji. Onye uke eshi nno pfụa ụgwo iphe-ẹji ọbu, onye ono meru ọbu. ");
INSERT INTO izz_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ọ -bụru l'ẹka onye ọbu te erwuduru lẹ nwatụru; l'o wotaru Chipfu ndo labọ; ọzoo kparaka labọ k'iphe-ẹji ono, o meru ono. Gẹ nanụ bụru kẹ ngwẹja-iphe-ẹji; ọphuu abụru kẹ ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","G'onye ono chịru ụnwu-ẹnu ono je achịe onye uke. Onye uke ono evuru ụzo gwee ọphu bụ ngwẹja-iphe-ẹji. Ọo-swịkwo iya olu; ọle g'o to bufukwa iya ishi. ");
INSERT INTO izz_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","L'o meta mee ngwẹja-iphe-ẹji ono phee lẹ mgburẹku ọru-ngwẹja ono; haa mee ya ọphu phọduru nụ g'ọ lwashịa l'ọkpali ọru-ngwẹja ono. Ọ kwa ngwẹja-iphe-ẹji bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","L'ọ bya eworu ẹnu k'ẹbo gwee ngwẹja-akpọ-ọku; mee ya g'eemeje iya; shi nno gude iya pfụa ụgwo iphe-ẹji, onye ọbu meru; l'a gụaru iya nvụ. ");
INSERT INTO izz_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Ọle ọ -bụkwanuru l'onye ono bẹ ta adụdu ike gbata ndo labọ; ọzoo kparaka labọ; g'onye ono wota nkeru-iri nkwẹka ukpokutu ereshi; g'ọ bụru ngwẹja-iphe-ẹji k'iphe-ẹji ono, o meru. G'o to yekwa iya manụ; ọphu o yekwa iya ụ̀nwù-isẹnsu; kẹle ọo ngwẹja-iphe-ẹji bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","G'onye ono gude iya wojeru onye uke. G'onye uke hata iya ọphu jiru mkpoji-ẹka g'ọ nọchia ẹnya ngwẹja ono; l'ọ kpọo ya ọku l'eli ọru-ngwẹja; l'eli ngwẹja, aakpọ ọku anụ Chipfu; kẹle ọo ngwẹja-iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ọ bụru; e -mee ya nno; l'ọ bụru iya bụ l'onye uke apfụa ụgwo iphe-ẹji, onye ọbu meshiru; l'a gụaru iya nvụ. Iphe-ngwẹja ono ọphu phọduru nụ abụru k'onye uke ono; ẹgube eemeje kẹ ngwẹja-nri ono.” ");
INSERT INTO izz_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ọ -dụru onye mesweru iphe; mbụ l'o meru iphe-ẹji l'amagama; ọphu ọ nụduru Chipfu iphe, gbaru iya nụ; g'onye ono shi l'ẹka eghu iya mẹ atụru iya dọru; kpụta ebili, adụdu ẹka iphe mebyiru iya; bya anụ Chipfu g'ọ bụru ngwẹja-apfụ-ụgwo. G'e gudekwa ẹrwa shẹkelu k'eze-ụlo Chileke maru aswa ebili ono. Ọo ngwẹja-apfụ-ụgwo bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","G'onye ono mezia iphe ono, o mesweru ono; kẹle ọ tọ nụduru Chipfu iphe, gbaru iya nụ; l'o yekwakwa iya phọ oke lanụ l'ụzo ise l'iphe ono; tụko iya chịru nụ onye uke. Onye uke ono egude ebili phọ gwee ngwẹja-apfụ-ụgwo; shi nno pfụa ụgwo iphe-ẹji, onye ono meru; l'a gụaru iya nvụ. ");
INSERT INTO izz_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ọ -dụru onye meru iphe-ẹji; mbụ l'o meru iphe, Chipfu tụru ekemu sụ g'e te mejeshi; m'obeta ọphu ọ madụ; bẹ ikpe nmaakwaru iya; tẹme ẹjo-iphe ono tukoru onye ono l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","G'onye ono shi l'ẹka eghu iya mẹ atụru iya dọru; kpụtakwa ebili, adụdu ẹka iphe mebyiru ya; g'ọ bụru ngwẹja-apfụ-ụgwo. G'e gudekwa mkpọla-ọchaa k'eze-ụlo Chileke maru aswa ebili ono. G'ọ nụ iya onye uke g'o gude iya pfụa ụgwo amagama ono, bụ iphe ono, o meru; ọphu ọ madụ ono; l'a gụaru iya nvụ. ");
INSERT INTO izz_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ọ kwa ngwẹja-ikpe-anmanma bẹ ọ bụ; kẹle ikpe nmarụ onye ono l'iphu Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ọ -dụru onye meru iphe-ẹji; shi nno meswee Chipfu; mbụ l'ọ dzụru nemadzụ ibiya ụka l'iphe, a nụru iya sụ g'o dobe; ọzoo g'o leta ẹnya; ọzoo l'ọ narụ nwibe iya nfụ; ọzoo l'o riru nwibe iya urwu; ");
INSERT INTO izz_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ọzoo l'ọ tụrutaru iphe, tuphahụru etuphahụ; ọphu o kwedu lẹ ya hụmaru iya; ọzoo l'onye ono kpapyabẹru iphe, o meru gụa ẹnwa; ọzoo l'onye ono meru iphe, dụgbaa ẹgube ono; shi nno mee iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","onye ono, meru iphe-ẹji ono; shi nno meta iphe, ikpe nmarụ iya; bụ iphe, oo-me bụ g'o wolata iphe, ọ natarụ lẹ nfụ; m'ọ bụ ọphu o ritaru l'urwu; m'ọ bụ ọphu a nụru iya g'o leta ẹnya; o ria ya; m'ọ bụ iphe onye ọzo, tuphahụru nụ; ọ tụruta iya; ");
INSERT INTO izz_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","m'ọ bụ iphe, dụgbaa ẹgube ono, o meru; ọ kpapyabẹ iya gụa ẹnwa. G'onye ono pfụkwaa ụgwo iphe ono g'ọ ha; tẹme l'o wotafụa ọphu ha g'e kee iphe ono ụzo ise; tukobe iya woru nụ onye nwe iphe ono. Mbọku, ọo-tụko iphemiphe ono nụ bụ mbọku ono, oo-gude ngwẹja-apfụ-ụgwo gude bya anụ ono. ");
INSERT INTO izz_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ngwẹja-apfụ-ụgwo, oo-gweru Chipfu bẹ oo-wotaru onye uke. G'o shi l'ẹka eghu iya mẹ atụru iya dọru kpụta ebili, adụdu ẹka iphe mebyiru iya. G'e gudekwa mkpọla-ọchaa k'eze-ụlo Chileke maru aswa ebili ono. ");
INSERT INTO izz_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Onye uke ono eshi ẹgube ono nọdu l'atatiphu Chipfu pfụa ụgwo iphe-ẹji, onye ono meru; l'a gụkotaru iya nvụ l'iphemiphe ono, o meru; ikpe iya nmarụ iya ono.” ");
INSERT INTO izz_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Noo ya; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Waa ekemu ịi-tụru Erọnu yẹe ụnwu iya bụ ọwa: Ekemu ọwa-a bụ kẹ ngwẹja-akpọ-ọku bẹ a tụ-doru iya sụ: Gẹ ngwẹja-akpọ-ọku nọkotajekwa l'ọku, dụ l'ọru-ngwẹja ẹnyashi ophu; jasụ gẹ nchi bọhu. Ọku, nọ l'ọru-ngwẹja ono enwuẹ ya phọ l'eli. ");
INSERT INTO izz_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Teke o rwuru l'ụtsu; g'onye uke ono chịta uwe iya ono yee; mbụ uwe ono, e meru l'oghu ọchaa ono. L'ọ chịtakwapho nwịba phọ yeada l'ime ẹhu. L'ọ bya ekpota ntụ, shi lẹ ngwẹja-akpọ-ọku ono, bụ ọphu ọku kepyashịru l'ọru-ngwẹja ono; je asụbe lẹ mgburẹku ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","L'ọ bya eyefu uwe iya ono; bya achịta uwe ọzo yee; pata ntụ ono lụfu l'azụ ẹka ndu Ízurẹlu kpọbegbaaru ụlo-ẹkwa phẹ; je asụbe l'ẹka e merwuduru emerwụ. ");
INSERT INTO izz_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","G'ọku ono, nọ l'ọru-ngwẹja ono nwuẹkwapho g'oonwu l'eli iya; g'e te menyikwa iya emenyi. G'onye uke yejekwa iya nkụ l'ụtsu mbọkumboku. L'ọ bya eworu anụ ngwẹja-akpọ-ọku doo giriri l'eli iya; l'ọ kpọkwapho ẹba, shi l'anụ ngwẹja-ẹhu-guu ọku l'eli iya. ");
INSERT INTO izz_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","G'ọku ono nwujeẹpho l'eli ọru-ngwẹja ono mkpụrumkpuru; g'ọ tọ nyịhujekwa anyịhu.” ");
INSERT INTO izz_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Waa ekemu lẹ g'ee-gudeje egwe ngwẹja-nri baa: Ọo ụnwu Erọnu a-nọduje l'iphu Chipfu gwee ngwẹja ono; l'iphu ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","G'onye uke hata ukpokutu ereshi ono, a gwọru lẹ manụ ono ọphu jiru mkpoji-ẹka; wotakwaphọ iphe, bụ ụ̀nwù-isẹnsu, e yeru lẹ ngwẹja-nri ono; je akpọo ọku l'ọru-ngwẹja ono g'ọ nọchia ẹnya ngwẹja ono; bụru ngwẹja, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","E -mechaa; gẹ Erọnu yẹe ụnwu iya ria ọphu ghuduru nụ; ọle g'ẹphe te eyekwa iya iphe, ekoje buredi; tẹme g'ẹka ẹphe a-nọdu ria ya bụkwaru ẹka dụ nsọ. G'ẹphe nọdukwa l'ọma-unuphu ụlo-ẹkwa-ndzukọ ria ya. ");
INSERT INTO izz_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","G'e te eyekọbejekwa iya iphe, ekoje buredi; mẹ a -nọdu eghe iya. Ono bẹ mu nụru phẹ g'ọ bụru oke iya nkephẹ lẹ ngwẹja, aakpọ ọku ono. Ọ kakọta nsọ gẹ kẹ ngwẹja-iphe-ẹji; waa kẹ ngwẹja-apfụ-ụgwo. ");
INSERT INTO izz_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Onyemonye, bụ nwoke l'oshilọkpa Erọnu bẹ e-rije iya nụ. Ọ bụru g'ee-meje iya bụ ono jasụ l'ojejoje l'ọgbo unu; mbụ g'ee-meje iphe, bụkpoo ngwẹja, aakpọ ọku anụ Chipfu. Onyemonye, denyiru ẹka lẹ ngwẹja ono a-dụkwa nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ọwa-a bụ ngwẹja, oshilọkpa Erọnu e-gudeje gweeru Chipfu mbọku, a wụru iya manụ l'ishi: Iphe, ẹphe e-gudeje bụ nkeru-iri nkwẹka ukpokutu ereshi; g'ọ bụru ngwẹja-nri ono, eegweje mkpụrumkpuru ono. Nkerẹbo iya bẹ ee-gwe l'ụtsu; nkeru-ẹbo iya ọphuu bụru l'ụzenyashi. ");
INSERT INTO izz_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","G'e ye iya lẹ mbeji; gwọo ya lẹ manụ ree; woru iya ghee egheghe pabata. L'ị bya eworu iya gwepyashịa egwepyashị; gude bya egweeru Chipfu; g'ọ bụru ngwẹja-nri, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ọ bụru onye ono, bụ oshilọkpa Erọnu ono, a wụru manụ g'ọ nọchia ẹnya iya bụru onye uke ono bẹ e-gwe ngwẹja ono l'onwiya. Iphe ono bụ iphe, a tọru ọkpa iya g'e meje iya jasụ l'ojejoje. G'a kpọkotajekwa iya ọku g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Mbụ l'iphe, bụkpoo ngwẹja-nri, onye uke gwerụ bẹ aa-kpọ ọku l'ophu; g'e te rikwa iya eriri.” ");
INSERT INTO izz_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Waa iphe, ii-pfuru yeru Erọnu yẹe ụnwu iya baa: Ọwaa bụ ekemu kẹ ngwẹja-iphe-ẹji. Ọo l'ẹka ono, eegbuje anụ e gude egwe ngwẹja-akpọ-ọku ono bụkwapho ẹka ee-gbuje anụ, e gude egwe ngwẹja-iphe-ẹji; mbụ l'aa-nọduje l'atatiphu Chipfu gbua anụ ọbu. Ọ kwa ngwẹja, dụ nsọ shii bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","G'onye uke, bụ iya gwerụ ngwẹja-iphe-ẹji ono rikwaa ya. Ọo l'ẹka dụ nsọ bẹ ọo-nọdu ria ya. Ẹka ọo-nọdu ria ya bụ l'ọma-unuphu ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Onyemonye, denyiru ẹka l'anụ ono a-dụkwa nsọ. Ọ -bụru lẹ mee anụ ono daru l'uwe; g'a nọdukwa l'ẹka dụ nsọ saa uwe ọbu. ");
INSERT INTO izz_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ọ -bụru ite, a kpụru l'ụrwa bẹ e gude shia anụ ono; g'a tụkpokwaa ite ono; teke ọ bụ ite-igwe; g'e huchakwaa ya ehucha; tẹme l'a saa ya asasa. ");
INSERT INTO izz_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ndu bụ nwoke lẹ ndibe onye uke g'ẹphe ha l'e-rikọta iya. Ọ kwa ngwẹja, dụ nsọ shii bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ọle-a; g'e te rikwa anụ ngwẹja-iphe-ẹji, bụ ọphu e gude mee ya woba l'ụlo-ẹkwa-ndzukọ g'e gude pfụa ụgwo iphe-ẹji l'ẹka-dụ-nsọ. G'a kpọkotakwa iya ọku.” ");
INSERT INTO izz_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ọwaa bụ ekemu kẹ ngwẹja-apfụ-ụgwo. Ọ kwa iya bụ ngwẹja, dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ọo l'ẹka eegbuje anụ, e gude egwe ngwẹja-akpọ-ọku bẹ ee-gbuje anụ, e gude egwe ngwẹja-apfụ-ụgwo. L'e phephee mee ya l'ọru-ngwẹja mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ẹba anụ ono l'ophu bẹ ee-gude gwekọtaru Chileke; mbụ ẹba, shi l'upfumọdzu iya; mẹ ọphu kwechiru iphe-ẹpho iya; ");
INSERT INTO izz_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","waa àkpụ̀rù iya ẹphenebo; yẹe ẹ̀bà, nọ l'ụzo ose iya; waa anya iya bẹ aa-tụko yẹe àkpụ̀rù iya phọ wota. ");
INSERT INTO izz_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","G'onye uke tụkokwa iya kpọo ọku l'ọru-ngwẹja; g'ọ bụru ngwẹja, aakpọ ọku anụ Chipfu. Ọ kwa ngwẹja-apfụ-ụgwo bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Iphe, bụkpoo onye bụ nwoke lẹ ndu bụ uke l'e-rije iya. Ọ bụru l'ẹka dụ nsọ bẹ aa-nọduje ria ya; noo kẹle ọ bụ ngwẹja, dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“G'ọ bụkwarupho ẹgube ono, a tụru ọnu g'e meje iphe ngwẹja-iphe-ẹji ono bụ g'ee-meje kẹ ngwẹja-onye-ikpe-nmarụ. Ọ bụru onye uke, gude iya apfụ ụgwo iphe-ẹji ono bẹ e-nweru iya nụ. ");
INSERT INTO izz_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ọ bụru onye uke, gwerụ nemadzụ ngwẹja-akpọ-ọku bẹ e-nworu akpọ iya. ");
INSERT INTO izz_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Iphe, bụ ngwẹja-nri, e gheru lẹ ntụ-ọku; ọzoo ọphu e shiru l'ite; ọzoo ọphu e gheru lẹ mbeji bụkwa onye uke, gwerụ iya nụ nwe iya. ");
INSERT INTO izz_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tẹme iphe, bụkpoo ngwẹja-nri ọphu a gwọru lẹ manụ; mẹ k'ọkponku; tụkokwarupho bụkotaru k'ụnwu Erọnu g'ẹphe ha. G'ẹphe kejekwa iya ẹnya nhamụnha.” ");
INSERT INTO izz_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ọwaa bụ ekemu kẹ ngwẹja-ẹhu-guu, nemadzụ gude bya anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ọ -bụru l'onye ọbu anụ iya g'o gude iya kele Chipfu ekele; bẹ iphe, onye ono e-gude tsoru iphe ngwẹja ono bụ akara, a gwọru lẹ manụ; ọphu e yedụru iya iphe, ekoje buredi; waa ẹcha-mbekee, e meru manụ; ọphu e yedụru iya iphe, ekoje buredi; waa akara, e meru l'ukpokutu ereshi, a gwọru lẹ manụ rengurengu. ");
INSERT INTO izz_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Iphe oo-gwerụ yekọbe lẹ ngwẹja-ẹhu-guu ono, o gude ekele Chipfu ono bụ akara, e yekọberu iphe ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","L'ooshije lẹ ngwẹja ono wota nggụru akara lanụ l'iphe ngwẹja ono iche iche woru gwee g'ọ bụru ngwẹja, e gwerụ nụ Chipfu. Ọ bụru onye e-ri iya nụ bụ onye uke ono, pheru mee ngwẹja-ẹhu-guu phọ. ");
INSERT INTO izz_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Anụ ngwẹja-ẹhu-guu ono, o gude bya ekele Chipfu ekele ono bẹ aa-takọta lẹ mbọku, a nụru iya Chipfu. G'ọ tọ dụkwa ọphu aa-ha g'ọ kwaa akwakwa fụta ụtsu. ");
INSERT INTO izz_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Ọle ọ -bụkwanuru lẹ ngwẹja onye ọbu bụ ngwẹja, o gude eme iphe, o riburu angụ ememe; ọzoo ngwẹja, ọ tụru obu iya onyo abya egwegwe; l'a taa anụ ono mbọku, a nụru iya. Ọ -bụru l'a ta tagbuduru iya; g'a tafụfua ya lẹ nchitabọhu iya. ");
INSERT INTO izz_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Teke ọ bụ l'ọ phọdukwarupho lẹ mbọku k'ẹto; g'a kpọo ya ọku. ");
INSERT INTO izz_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ọ -bụru l'ọ dụru anụ ngwẹja-ẹhu-guu ono ọphu a tarụ lẹ mbọku k'ẹto bẹ aa-jịkakwa ngwẹja ọbu; ọphu aagụduru iya eyeru onye gwerụ iya nụ. Ọo-bụru ẹbyi bẹ o meru; tẹme onye rikwanụru iya nụ bẹ ẹjo-iphe, o meru a-tụ-koru l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Anụ ono ọphu rwuru l'iphe, aasọ nsọ; g'a ta takwa iya atata; g'e wokwaru iya kpọo ọku. Ọle ọ -bụkwanuru l'ọo anụ ọzo; g'onye a ta sọdu nsọ taa ya. ");
INSERT INTO izz_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ọ -dụru onye aasọ nsọ, tarụ anụ ngwẹja-ẹhu-guu kẹ Chipfu; g'e bufukwa iya lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ọ -bụkwarupho l'ọ dụru onye denyiru ẹka l'iphe, aasọ nsọ; dụ g'iphe, aasọ nsọ, shi nemadzụ l'ẹhu; ọzoo anụ, aasọ nsọ; ọzoo iphe ọzo, bụgbaa iphe, aasọ nsọ; o -mechaa bya ataa anụ ono, e gude gweeru Chipfu ngwẹja-ẹhu-guu ono; g'e bufukwa onye ọbu lẹ ndu nkiya.” ");
INSERT INTO izz_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Pfuaru ndu Ízurẹlu sụ phẹ-a: Unu ta adụkwa ẹba iphe, unu a-tajẹ, dụ g'ẹba eswi; ọzoo ẹba atụru; ọzoo ẹba eghu. ");
INSERT INTO izz_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Teke ọ bụ ẹba-anụ, nwụhuru l'onwiya; ọzoo ọphu anụ-ẹgbudu gburu bẹ ọ -dụ unu ree; unu gudejekwa iya mee iphe; ọle g'unu ba tsọkwa iya ọnu. ");
INSERT INTO izz_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Iphe, bụ onye tarụ ẹba-anụ, e gude gwee ngwẹja, aakpọ ọku anụ Chipfu; g'e bufukwa iya lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Obetakpọo unu laa awe je eburu; unu te erijekwa mee-iphe; mbụ mee ẹnu; ọzoo mee anụ. ");
INSERT INTO izz_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Onye riru mee-iphe; unu bufukwa onye ono lẹ ndu nkiya.” ");
INSERT INTO izz_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Pfuaru ndu Ízurẹlu sụ phẹ-a: Onye gude ngwẹja-ẹhu-guu abya egweru nụ Chipfu; g'o wotakwa ẹka iya ọphu rwuberu Chipfu gweeru iya; ");
INSERT INTO izz_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","mbụ g'o gude ẹka iya wota ngwẹja, aa-kpọ ọku nụ Chipfu. L'o wota ẹba iya; waa ǹdụ́ iya bya anụ Chipfu; woru ǹdụ́ iya ono maa amama l'iphu Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Onye uke ewota ẹba iya ono kpọo ọku l'ọru-ngwẹja. Ọle ǹdụ́ iya bụ kẹ Erọnu yẹe ụnwu iya. ");
INSERT INTO izz_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","G'unu kwata ụtapfu ọkpa ẹkutara anụ ngwẹja-ẹhu-guu unu ono woru nụ onye uke ono g'ọ bụru ụtu, a tụru iya. ");
INSERT INTO izz_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ụnwu Erọnu onye ọphu gude mee anụ ono; yẹe ẹba iya je egwee ngwẹja-ẹhu-guu ọbu bẹ aa-nụ ụtapfu ọkpa ẹkutara iya ono g'ọ bụru oke iya nkiya; ");
INSERT INTO izz_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","kẹle mu shiwaa lẹ ngwẹja-ẹhu-guu ono, ndu Ízurẹlu egwejeru nụ mu ono wota ǹdụ́ iya ono, aamajẹ amama ono; yẹe ụtapfu iya ono, a tụru l'ụtu ono; woru nụ Erọnu yẹe ụnwu iya; g'ọ bụru okiphe, ẹphe e-ketajẹ l'ẹka ndu Ízurẹlu jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ọwaa bụ okiphe, shi lẹ ngwẹja, aakpọje ọku anụ Chipfu, bụ ọphu e doberu g'a nụje Erọnu yẹe ụnwu iya; eshi mbọku, a họfutaru phẹ iche; g'ẹphe bụru ndu-uke jejeru Chipfu ozi. ");
INSERT INTO izz_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Mbọku ono, a wụru phẹ manụ l'ishi ono bẹ Chipfu tụru ekemu sụ gẹ ndu Ízurẹlu nụje phẹ ẹka ono g'ọ bụru okiphe phẹ; tẹme ọ bụkwarupho g'aa-nụje iya ụnwu phẹ bụ ono; e -shi l'ọgbo sweru ọgbo jasụ l'ojejoje.” ");
INSERT INTO izz_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ọo ekemu-a bẹ ee-tsoje mẹ a -nọdu egwe ngwẹja-akpọ-ọku; waa ngwẹja-nri; waa ngwẹja-iphe-ẹji; waa ngwẹja-apfụ-ụgwo; waa ngwẹja, e gude eme nemadzụ g'ọ bụru onye uke; waa ngwẹja-ẹhu-guu; ");
INSERT INTO izz_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","bụ iya bụ ekemu ono, Chipfu tụru nụ Mósisu l'úbvú Sayịnayi lẹ mbọku ono, ọ sụru gẹ ndu Ízurẹlu wotaru yẹbe Chipfu ngwẹja l'echiẹgu Sayịnayi ono. ");
INSERT INTO izz_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu; sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Duta Erọnu yẹe ụnwu iya; l'ị chịta uwe ndu-uke ono; bya ewota manụ awụ l'ishi ono; l'ị kpụta oke-eswi ono, ee-gude gwee ngwẹja-iphe-ẹji ono; waa ebili labọ ono; bya apata nkata buredi ono, e yedụru iphe, ekoje buredi ono. ");
INSERT INTO izz_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","L'ị bya ekukọ ndu Ízurẹlu g'ẹphe ha g'ẹphe dzukọbe l'ọnu-abata ụlo-ẹkwa-ndzukọ.” ");
INSERT INTO izz_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Tọbudu iya bụ; Mósisu bya emekọta gẹ Chipfu ziru iya g'o mee; ndu Ízurẹlu bya edzukọbe l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mósisu bya asụ ndu Ízurẹlu ono: “Wakwa iphe, Chipfu sụru g'e mee baa.” ");
INSERT INTO izz_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mósisu bya eduta Erọnu; yẹe ụnwu iya lụfuta; bya egude mini wụa phẹ ẹhu. ");
INSERT INTO izz_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","O wota uwe ime-ẹhu ono yee Erọnu; bya egude ẹkwa-atụ-buta-l'upfu ono kebuta iya. Ọ bya ewota uwe mgbalanụ ono yepyabẹ iya; bya ewota uwe-ukuvu ono yechite l'uwe mgbalanụ ono; gude wẹrere ẹkwa ono, ee-gude tụ-buta uwe-ukuvu ono l'upfu ono; gude tụ-buta iya. ");
INSERT INTO izz_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","O wota uwe-ọkpoma ono yekwaa ya phọ; bya ewota ido Urimu; waa Tumimu ye l'uwe-ọkpoma ono. ");
INSERT INTO izz_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ọ bya eworu okpulishi-ẹkwa ono kpube iya; bya eworu iphe ono, dụ g'okwekpu, e meru lẹ mkpọla-ododo ono; mbụ okpu ono, dụ nsọ ono; libe l'okpulishi-ẹkwa ono l'ụzo atatiphu, bụ iya bụ gẹ Chipfu tụru Mósisu ekemu sụ g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Noo ya; Mósisu bya ewota manụ awụ l'ishi ọbu; bya awụkota l'ụlo-ẹkwa ono; mẹ iphemiphe, nọkota iya nụ; shi nno mee ya; ọ dụkota nsọ. ");
INSERT INTO izz_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","O meta manụ ono phee mgbo ẹsaa l'ọru-ngwẹja ono; mẹkpoo ngwa iya g'ọ ha; mẹkpoo eze gbamụgbamu ono; yẹe ọkpa iya; shi nno mee ya; ọ dụkota nsọ. ");
INSERT INTO izz_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ọ bya ewota manụ awụ l'ishi ono wụa Erọnu l'ishi gude mee ya; ọ dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","No iya; Mósisu byakwaphọ bya eduta ụnwu Erọnu fụta; bya eworu uwe mgbalanụ yee phẹ; bya egude ẹkwa-atụ-buta-l'upfu webegbaa phẹ; bya ewota okpu ndu-uke kpubegbaa phẹ l'ishi, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ọ bya akpụta oke-eswi ono, ee-gude gwee ngwẹja-iphe-ẹji ono bya; Erọnu yẹe ụnwu iya woru ẹka byabẹ oke-eswi ono l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mósisu woru oke-eswi ono gbua; bya emeta mee ya gude mkpụshi-ẹka iya tee ya lẹ mpu, nọgbaa l'ọru-ngwẹja ono; shi nno swafụ ntụrwu, dụ iya nụ. O woru ọphu ghuduru nụ wụa l'ọkpali ọru-ngwẹja ono; gude mee ya; ọ dụ nsọ; pfụa ụgwo iphe-ẹji; shi nno swafụ ntụrwu, dụ iya nụ. ");
INSERT INTO izz_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mósisu bya eheshikọta ẹba, nọ l'iphe-ẹpho iya g'ọ ha; bọtakwapho anya iya; waa àkpụ̀rù iya ẹphenebo; yẹe ẹba, nọkota iya nụ; woru kpọo ọku l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ọ bụru anụ oke-eswi ono; waa akpọ iya; yẹe nshị iya bẹ o gude je akpọo ọku l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ, bụ iya bụ gẹ Chipfu sụru Mósisu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ọ bya akpụta ebili ono, ee-gude gwee ngwẹja-akpọ-ọku ono; Erọnu yẹe ụnwu iya bya eworu ẹka byabẹ ebili ono l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mósisu gbua ebili ono; nakọbe mee ya; pata mee ya ono phedzuru lẹ mgburẹku ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","O gbubushia anụ ebili ono mkpirikpu mkpirikpu; mbụ Mósisu; bya eworu ishi iya yẹe mkpirikpu mkpirikpu iya ono; mẹ ẹba iya kpọkota ọku. ");
INSERT INTO izz_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","O gude mini saa iphe-ẹpho iya; waa ẹka iya; yẹe ọkpa iya asasa; bya atụko anụ ebili ono kpọo ọku l'ọru-ngwẹja ono; ọ bụru ngwẹja-akpọ-ọku, a nụru Chipfu; mbụ ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ iya ree, bụ iya bụ gẹ Chipfu tụru Mósisu ekemu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ọ bya akpụta ebili ọphuu. Ebili k'ono bụ ọphu ee-gude mee Erọnu; yẹe ụnwu iya g'ẹphe bụru ndu-uke. Erọnu yẹe ụnwu iya je eworu ẹka byabẹ iya l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mósisu gbua ebili k'ono; harụ mee ya meta; tee Erọnu l'atakpa-nchị ẹkutara; mẹ lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; waa lẹ mkpụshi-ọkpa ezeke-ọkpa ẹkutara. ");
INSERT INTO izz_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mósisu dufutakwaphọ ụnwu Erọnu; bya etekwa phẹ phọ mee ono l'atakpa-nchị ẹkutara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; waa lẹ mkpụshi-ọkpa ezeke-ọkpa ẹkutara. Mósisu bya eworu mee ono phedzuru lẹ mgburẹku ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ọ bya eheta ẹba iya; hetachaa ẹba, dụ l'upfumọdzu iya; waa ọphu nọkota l'iphe-ẹpho iya g'ọ ha; bọtakwapho anya iya; waa àkpụ̀rù iya ẹphenebo; yẹe ẹba, nọkota iya nụ; wota ụtapfu ọkpa ẹkutara iya tụkwase iya. ");
INSERT INTO izz_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","O je lẹ nkata ono, e yeru buredi ono, e gudedu iphe, ekoje buredi ghee ono, nọ l'atatiphu Chipfu ono; bya ahata ishi buredi lanụ; hatakwaphọ ishi akara lanụ l'akara ono, a gwọru lẹ manụ ghee ono; waa ẹcha-mbekee lanụ. O wota iya yekọbe l'ẹba iya phọ; yẹe ụtapfu ọkpa ẹkutara iya phọ. ");
INSERT INTO izz_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ọ tụko iphemiphe ono g'ọ ha dẹe Erọnu yẹe ụnwu iya l'ẹka; ẹphe bya eworu iya maa amama l'iphu Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mósisu bya anata phẹ iphemiphe ono; tụko yẹle ngwẹja-akpọ-ọku phọ kpọo ọku l'ọru-ngwẹja ono; ọ bụru ngwẹja, e gude mee nemadzụ g'ọ bụru onye uke; mbụ ngwẹja, aakpọ ọku anụ Chipfu, mkpọ iya dụ iya ree. ");
INSERT INTO izz_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","O wotakwaphọ ǹdụ́ iya, bụ iya bụ oke, a hẹru Mósisu l'ebili ono, e gude mee Erọnu phẹ g'ẹphe bụru ndu-uke ono; makwaphọ amama l'iphu Chipfu; g'ọ bụru ngwẹja-amama, bụ iya bụ gẹ Chipfu tụru Mósisu l'ekemu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Noo ya; Mósisu bya emeta manụ awụ l'ishi ono; bya emetakwaphọ mee ono, nọ l'ọru-ngwẹja ono; bya eworu phee Erọnu yẹe ụnwu iya l'ẹhu; waa l'uwe phẹ. Ọo ya bụ; o mee Erọnu yẹle uwe iya; waa ụnwu iya yẹle uwe nkephẹ; ẹphe tụko dụkota nsọ. ");
INSERT INTO izz_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mósisu sụ Erọnu yẹe ụnwu iya: “Unu je eshia anụ ono l'ọnu-abata ụlo-ẹkwa-ndzukọ. Unu anọdu l'ẹka ono taa ya; yẹle buredi ono, nọ lẹ nkata ono, e yeru ngwẹja, e gude mee unu g'unu bụru ndu-uke ono, bụ iya bụ iphe, mu tụru ekemu sụ gẹ Erọnu yẹe ụnwu iya rije. ");
INSERT INTO izz_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Anụ ono yẹe buredi ono ọphu phọduru nụ bẹ unu e-woru je akpọo ọku. ");
INSERT INTO izz_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Unu ta tụgbukwa l'ọnu-abata ụlo-ẹkwa-ndzukọ ono jasụ unu anọ-rwua ya ujiku ẹsaa; mbụ jasụ l'e meghee k'eme unu g'unu bụru ndu-uke ono; noo kẹle ọo ujiku ẹsaa ono bẹ ee-gude mekọta k'eme unu g'unu bụru ndu-uke ono. ");
INSERT INTO izz_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Iphe, e meru ntanụ-a bụ iphe, Chipfu tụru ekemu sụ g'e mee; gude pfụa ụgwo iphe-ẹji, unu meru. ");
INSERT INTO izz_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Noo g'o gude unu je l'anọdu l'ọnu-abata ụlo-ẹkwa-ndzukọ eswe l'ẹnyashi nọo ya ujiku ẹsaa; shi nno mee iphe, Chipfu sụru g'e meje; g'ọnwu te egbu unu; kẹle ọ kwa g'a tụru mu ekemu iya bụ ono.” ");
INSERT INTO izz_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Noo ya; Erọnu yẹe ụnwu iya mekọta iphe, Chipfu shi l'ọnu Mósisu sụ g'ẹphe mee. ");
INSERT INTO izz_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","O be lẹ mbọku k'ẹsato; Mósisu kua Erọnu; yẹe ụnwu iya; waa ndu bụ ọgerenya Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ọ sụ Erọnu-a: “Kpụta nwa oke-eswi, ii-gude gwee ngwẹja-iphe-ẹji; yẹe ebili, ii-gude gwee ngwẹja-akpọ-ọku; mbụ ọphu adụdu ẹka iphe mebyiru iya; kpụru iya bya l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Pfuaru ụnwu Ízurẹlu sụ phẹ: Unu kpụta mkpi g'e gude gwee ngwẹja-iphe-ẹji; unu akpụta nweswi yẹe nwatụru; ẹphenebo a-bụcharu ọphu nọwaru mgbarapha; ọphu ọ dụdu ẹka iphe mebyiru iya; gude je g'e gwee ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Unu akpụtakwapho oke-eswi; waa ebili, ee-gude gwee ngwẹja-ẹhu-guu; g'e gude gwee ngwẹja l'iphu Chipfu; mẹkwapho ngwẹja-nri, a gwọru lẹ manụ; kẹle ntanụ-a bẹ Chipfu e-goshikwa unu onwiya.” ");
INSERT INTO izz_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ẹphe gweta iphe ono, Mósisu gụshiru ono; bya l'iphu ụlo-ẹkwa-ndzukọ. Iphe, bụkpoo ndu Ízurẹlu l'ophu wụritaru bya akụru l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Noo ya; Mósisu sụ: “Wakwa iphe, Chipfu sụru g'unu mee baa; gẹ ya egoshikwanụ unu ọdu-biribiri iya.” ");
INSERT INTO izz_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Tọbudu iya bụ; Mósisu sụ Erọnu: “Tụgbua je l'ọru-ngwẹja je egwee ngwẹja-iphe-ẹji ngu ọbu; yẹe ngwẹja-akpọ-ọku ngu ọbu; gude pfụaru onwongu ụgwo iphe-ẹji; yẹe ụgwo iphe-ẹji ndu Ízurẹlu. Gwee ngwẹja ono gude pfụa ụgwo iphe-ẹji phẹ, bụ iya bụ gẹ Chipfu pfuru sụ g'e mee ya.” ");
INSERT INTO izz_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Noo ya bụ; Erọnu bya eje l'ọru-ngwẹja ono; je egbua nwa oke-eswi ono, oo-gude gwee ngwẹja-iphe-ẹji nkiya ono. ");
INSERT INTO izz_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ụnwu iya bya apataru iya mee nwa oke-eswi ono. O gude mkpụshi-ẹka meta mee ono tee lẹ mpu, e mobegbaaru l'ọru-ngwẹja ono; bya eworu mee ono ọphu phọduru nụ; wụru ye l'ọkpali ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ọ bya eworu ẹba-anụ ono, o gude gwee ngwẹja-iphe-ẹji ono; waa àkpụ̀rù iya ẹphenebo; waa anya iya; kpọo ọku l'ọru-ngwẹja ono, bụ iya bụ gẹ Chipfu tụru Mósisu ọnu g'e mee ya ono. ");
INSERT INTO izz_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Anụ iya; waa akpọ iya bẹ ọ kpọru ọku l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹ́kwà phẹ ono. ");
INSERT INTO izz_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Erọnu bya akpụta anụ ono, oo-gude gwee ngwẹja-akpọ-ọku ono gbua. Ụnwu iya bya apataru iya mee anụ ono; ọ bya ephephee ya l'ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ẹphe haa anụ ngwẹja-akpọ-ọku ono nanụ nanụ nụ iya; ẹphe nụchaa ya; nụ iya mẹ ishi iya; ọ tụko iya g'ọ ha kpọo ọku l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","O gude mini saa iphe-ẹpho iya; waa ẹka iya; waa ọkpa iya asasa; bya akpọkwaa ya phọ ọku l'eli ngwẹja-akpọ-ọku ono, nọhawa l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Erọnu gwefuta iphe ngwẹja ndu Ízurẹlu; kpụta eghu ono, oo-gude gwee ngwẹja-iphe-ẹji nkephẹ ono gbua; gude iya gwee ngwẹja-iphe-ẹji; ẹgube ono, o gwerụ kẹ mbụlembu phọ. ");
INSERT INTO izz_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ọ bya akpụta anụ ono, oo-gude gwee ngwẹja-akpọ-ọku ono; bya egude iya gwee ngwẹja ọbu g'a tụru ọnu sụ g'e meje iya. ");
INSERT INTO izz_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","O wotakwaphọ ngwẹja-nri ono; bya ahata iya ọphu jiru mkpoji-ẹka; kpọo ya ọku l'ọru-ngwẹja; a -gụfukwaro ngwẹja-akpọ-ọku, eegweje l'ụtsu. ");
INSERT INTO izz_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ọ bya egbua oke-eswi phọ; yẹe ebili phọ; gude gweeru ndu Ízurẹlu ngwẹja-ẹhu-guu. Ụnwu iya pataru iya mee anụ ono; ọ nata iya phephee ọru-ngwẹja ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ẹphe wotakwaru iya phọ ẹba oke-eswi ono; yẹe k'ebili ono; mbụ ẹba, shi l'upfumọdzu iya; waa ẹba, kwechiru iphe-ẹpho iya; waa àkpụ̀rù iya ẹphenebo; waa anya iya. ");
INSERT INTO izz_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Ẹphe woru ẹba-anụ ono tukobe lẹ ǹdụ́ iya. Erọnu bya eworu ẹba ono kpọo ọku l'ọru-ngwẹja ono; ");
INSERT INTO izz_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ọle ǹdụ́ iya ono; waa ụtapfu ọkpa ẹkutara iya; bẹ o woru maa amama l'iphu Chipfu g'ọ bụru ngwẹja-amama, bụ iya bụ gẹ Mósisu sụru g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Tọbudu iya bụ; Erọnu chilia ẹka imeli l'ụzo ẹka ndu Ízurẹlu nọ; bya agọru ọnu-ọma nụ phẹ; bya eshi l'ẹka o shi egwe ngwẹja-iphe-ẹji phọ; yẹe ngwẹja-akpọ-ọku phọ; mẹ ngwẹja-ẹhu-guu phọ; nyizeta. ");
INSERT INTO izz_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mósisu yẹe Erọnu tụko bahụ l'ime ụlo-ẹkwa-ndzukọ ono. Ẹphe fụtaepho; ẹphe gọru ọnu-ọma nụ ndu Ízurẹlu; Chipfu goshi ndu ono l'ophu ogbunwịinwii ya. ");
INSERT INTO izz_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ọku shi l'iphu Chipfu daa bya ekee ngwẹja-akpọ-ọku ono; yẹe ẹba ono, nọ l'eli ọru-ngwẹja ono. Ndu Ízurẹlu hụmaepho iphe ono, nwụru nụ ono; ẹphe tụshia ụzu ẹhu-ụtso; bya adakọta kpurumu woru iphu bubechaa l'alị. ");
INSERT INTO izz_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ụnwu Erọnu, bụ Nadabu; yẹe Abihu wotachaa iphe, aagụje ọku phẹ l'ẹhu l'ẹhu; bya anwụru ọku ye iya; bya eye iya ụ̀nwù-isẹnsu. Ọ bụru ọku adụdu nsọ bẹ ẹphe gude bya l'iphu Chipfu; bụ iphe ọ sụru g'ẹphe te emejeshi. ");
INSERT INTO izz_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tọbudu iya bụ; ọku shi l'iphu Chipfu bya eworu phẹ tsua; ẹphe nọdu l'iphu Chipfu l'ẹka ono nwụshihu. ");
INSERT INTO izz_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mósisu sụ Erọnu: “Ọ kwa iphe-a bẹ Chipfu pfuru teke ono sụ: ‘Ndu abya mu ntse bẹ mu e-goshije onwomu g'ẹphe maru lẹ mu dụ nsọ; mu emee gẹ ndu Ízurẹlu l'ophu hụma ọdu-biribiri mu.’ ” Erọnu nọduepho nggujingguji. ");
INSERT INTO izz_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mósisu kua Mishẹlu; waa Ẹluzafanu, bụ ụnwu Uzẹlu. Uzẹlu ono bụ nwune nna Erọnu. Ọ sụ phẹ: “Unu kpịritaru ntse bya apata ụnwunna unu pafụ l'ụlo-ẹkwa Chileke; parụ je l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ.” ");
INSERT INTO izz_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","No iya; ẹphe jekube iya; je apata phẹ; ẹphe l'uwe mgbalanụ phẹ ono pafụ l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ ono, bụ iya bụ gẹ Mósisu sụru g'ẹphe mee ya. ");
INSERT INTO izz_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Noo ya; Mósisu sụ Erọnu; yẹe ụnwu iya, bụ Eleyaza; waa Itama: “Unu te emekwa ishi unu njọ ememe; ọphu ọ dukwa onye a-laka uwe iya; kẹle ọ -bụru l'unu meru nno bẹ unu a-nwụhukwa; mbụ Chipfu atukoshi ndu Ízurẹlu l'ophu oke ẹhu-eghu iya. Ọo ụnwunna unu, bụ ndu Ízurẹlu l'ophu a-ra ẹkwa ndu Chipfu gude ọku kegbushia. ");
INSERT INTO izz_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Unu ta lụfukwa alụfu l'ọnu-abata ụlo-ẹkwa-ndzukọ; anọnyakwa unu nwụshihu; noo kẹle Chipfu wụru unu manụ l'ishi.” Ẹphe mekọtaepho iphemiphe, Mósisu sụru g'ẹphe mee. ");
INSERT INTO izz_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Tọbudu iya bụ; Chipfu bya epfuru yeru Erọnu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ta ngụjekwa mẹe; ọphu ị ngụjekwa iphemiphe, atsụ atsụtsu; gụbedua l'onwongu; mẹkpoo ụnwu ngu; teke unu abahụ l'ụlo-ẹkwa-ndzukọ; ọdumeka bẹ unu a-nwụshihukwa. Ọ bụru g'ọo-dụ bụ ono ojejoje l'ọgbo unu; eshi l'ọgbo swewarụro ọgbo. ");
INSERT INTO izz_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ọo ya bụ; g'unu edokahajẹ iphe, dụ nsọ; yẹe iphe, adụdu nsọ; dokaha iphe, aasọ nsọ; yẹe iphe, a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Unu ezije ụnwu Ízurẹlu iphe, bụ ekemu ono g'ọ ha, bụ ọphu Chipfu shi l'ẹka Mósisu tụaru phẹ.” ");
INSERT INTO izz_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Tọbudu iya bụ; Mósisu bya epfuru yeru Erọnu; yẹe ụnwu iya ndu ọphu phọduru nụ, bụ iya bụ Eleyaza yẹe Itama; sụ phẹ: “Unu wota ngwẹja-nri ọphu phọduru nụ lẹ ngwẹja ono, a kpọru ọku nụ Chipfu. Unu woru iya ria lẹ mgboru ọru-ngwẹja ono. Ọle g'unu te eyekwa iya iphe, ekoje buredi. Noo kẹle ọ bụ ngwẹja, dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Unu nọdukwa l'ẹka dụ nsọ ria ya; noo kẹle ọo iphe, rwuberu ngu nụ; bya abụru iphe, rwuberu ụnwu ngu; mbụ ngwẹja ono, aakpọ ọku anụ Chipfu ono; kẹle ọo g'a tụru mu ekemu iya bụ ono. ");
INSERT INTO izz_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Obenu lẹ-a; gụbedua gụ l'ụnwu ngu unwoke; yẹe ụnwu ngu ụnwanyi bẹ a-tajẹ ǹdụ́ anụ ono, e gude gwee ngwẹja-amama ono; yẹe ụtapfu iya ono, a nụru ono. Unu nọdujekwa l'ẹka dụ nsọ taa ya; kẹle ọo iphe, rwuberu ngu nụ; bya abụru iphe, rwuberu ụnwu ngu, shi l'iphe, ụnwu Ízurẹlu gude bya egwe ngwẹja-ẹhu-guu. ");
INSERT INTO izz_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ụtapfu iya ono, a nụru ono; waa ǹdụ́ iya ono, a maru amama ono bẹ ẹphe e-yekọbeje ẹba-anụ ngwẹja ono, aakpọ ọku ono wota; g'a maa amama l'iphu Chipfu g'ọ bụru ngwẹja-amama. Ono abụru nkengu; yẹe k'ụnwu ngu; l'ọ bụru iphe, rwuberu unu jasụ l'ojejoje, bụ iya bụ gẹ Chipfu tụru ekemu sụ g'e meje iya ono.” ");
INSERT INTO izz_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mósisu kpaa ishi g'e meru eghu phọ, e gude gwee ngwẹja-iphe-ẹji phọ; bya amaru l'a kpọru iya ọku. Ẹhu ghuahaa ya eghu l'iphe, ụnwu Erọnu ndu ọphu nọkwadu ndzụ ono meru, bụ iya bụ Eleyaza; yẹe Itama. Ọ bya asụ phẹ: ");
INSERT INTO izz_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“?Bụ gụnu kparụ iphe, unu ta nọdu l'ime ụlo-ẹkwa Chileke taa anụ ono, e gude gwee ngwẹja-iphe-ẹji ono; eshinu ọ bụ iphe, dụ nsọ shii; bya abụru iphe, a nụru unu g'unu gude safụ ẹjo-iphe, ọha l'ophu meru; unu apfụa ụgwo iphe-ẹji phẹ l'iphu Chipfu? ");
INSERT INTO izz_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Eshinu e te egudedu mee anụ ono bahụ l'ẹka-dụ-nsọ bẹ unu gege anọdu l'ụlo-ẹkwa Chileke taa anụ ono, bụ iya bụ gẹ mu sụru g'e meje iya.” ");
INSERT INTO izz_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Erọnu sụ Mósisu: “Ọ kwa ntanụ-a bẹ ẹphe nọ l'iphu Chipfu gwee ngwẹja-iphe-ẹji phẹ; yẹe ngwẹja-akpọ-ọku phẹ; tẹme iphe, dụ ẹgube-a bya anwụjehawaru mu! Ọme mu jeru je ataa anụ ngwẹja-iphe-ẹji ono ntanụ-a; Chipfu ?o gogo nata iya-a?” ");
INSERT INTO izz_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mósisu nụmaepho iphe ono, o pfuru ono; o jiẹ ya phọ ẹpho. ");
INSERT INTO izz_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu yẹe Erọnu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Unu pfuru yeru ndu Ízurẹlu; sụ phẹ-a: Wakwa ụduru anụ, unu a-tajẹ l'iphe, bụ anụ, nọkota lẹ mgboko-a baa: ");
INSERT INTO izz_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Unu tajẹ iphe, bụ anụ, nweru ụjarabvu-ọkpa; tẹme ọ nọdu anwafụtaje nri taphu azụ l'iphe, bụkpoo ụnwu anụ. ");
INSERT INTO izz_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ọ dụkwaru ndu ọphu anwafụtaje nri taphu azụ; ọphu ẹphe enwedu ụjarabvu-ọkpa; bya enwekwarụpho ndu ọphu nweru ụjarabvu-ọkpa; ọphu ẹphe anwafụtajedu nri taphu azụ. Unu ta tajẹkwa ndu k'ono. Ịnya-kamẹlu bẹ anwafụtaje nri taphu azụ; obenu l'o to nwedu ụjarabvu-ọkpa. Ọo ya bụ l'ẹhu unu bẹ ọ bụ anụ, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Unu ta tajẹkwa nchi-ọ̀gbà; kẹle ọonwafutaje nri taphu azụ; obenu l'o to nwedu ụjarabvu-ọkpa. Ọ bụkwaru unu anụ, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Nggamachị bụkwarupho unu anụ, aasọ nsọ; kẹle ọonwafutaje nri taphu azụ; obenu l'o to nwedu ụjarabvu-ọkpa. ");
INSERT INTO izz_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Tẹme g'ezi bụkwarupho unu anụ, aasọ nsọ; noo kẹle o nweru ụjarabvu-ọkpa; obenu l'ọ tọo nwafụtaje nri taphu azụ. ");
INSERT INTO izz_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Unu ta tajẹkwa ẹgube anụ ono; ọphu unu edenyijekwa odzu phẹ ẹka; noo kẹle ẹphe bụkota unu anụ, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Wakwanụ ọphu unu a-tajẹ baa l'anụ, bụ ndu ọphu bu lẹ mini; anụ nweru m̀kpọ́; yẹe ọphu nweru ẹkiri; buru l'eze-ẹnyimu; mẹ lẹ nggele; unu tajẹ ndu k'ono. ");
INSERT INTO izz_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","O -be lẹ ndu ọphu g'ẹphe ha; mbụ ndu ọphu bu l'eze-ẹnyimu; mẹ lẹ nggele; ọphu o to nwedu m̀kpọ́; ọphu o to nwedu ẹkiri; mẹkpoo iphemiphe, bụ iphe, bu lẹ mini; mẹkpoo iphe, bụ iphe, dzụ ndzụ; buru lẹ mini g'ọ ha bụkotakwa unu ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Eshinu ọ bụ unu ẹbyi; unu ta tajẹkwa anụ iya; g'odzu iya bụkwarupho unu ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Mbụ l'iphemiphe, bu lẹ mini, enwedu m̀kpọ́; ọphu o nwedu ẹkiri a-bụkotajekwaru unu ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Waa ẹnu ndu ọphu a-bụru unu ẹbyi baa; ndu k'ono bẹ unu ta atajẹdu anụ iya; kẹle ọ bụ ẹbyi. Ndu k'ono bụ ugo; waa udele; waa udele-ojii; ");
INSERT INTO izz_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","waa égbé; waa ivu l'ụdu iya l'ụdu iya; ");
INSERT INTO izz_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","mẹkpoo okpoko-ọ́hà l'ụdu iya l'ụdu iya; ");
INSERT INTO izz_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","18","waa mgbashị-ujiku l'ụdu iya l'ụdu iya; waa ẹnu gọlu; waa ọkpo-ngwere l'ụdu iya l'ụdu iya; waa ọgu-ịkporo; waa ugo-mini; ");
INSERT INTO izz_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","wakwaphọ eze-ọku-eswi-ụda; waa apyarị-nhọko l'ụdu iya l'ụdu iya; waa ovu; waa ụtsu-nwankụta. ");
INSERT INTO izz_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Iphe, bụkpoo ogu, furu ẹba, bụ iphe, gude ọkpa ẹno eje ije a-bụkotajeru unu ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ọle ọ dụkwaru-a ogu, furu ẹba, egudeje ọkpa ẹno eje ije, unu a-tajẹ. Ọphu unu a-tajẹ bụ ọphu nweru ọgba-kpịi, oogudeje apfụ mpfụ. ");
INSERT INTO izz_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ọphu unu a-tajẹ bụ igube l'ụdu iya l'ụdu iya; waa ọkaka l'ụdu iya l'ụdu iya; waa atsụ-ẹgu l'ụdu iya l'ụdu iya; waa mgbagbaramatsụ l'ụdu iya l'ụdu iya. ");
INSERT INTO izz_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","O be l'iphe, bụkpoo ogu ọzo, furu ẹba bya egude ọkpa ẹno eje ije l'a-tụko bụru unu ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ụnwu iphe ono g'ẹphe ha l'e-me; unu abụru ndu aasọ nsọ. Onye denyikwanụru odzu iya ẹka bẹ aa-nọdu asọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Iphe, bụ onye pataru odzu iya l'a-sa uwe iya asasa; tẹme l'ọ bụru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Iphe, bụkpoo anụ, nweru ụpyi-ọkpa; ọphu o nwedu ụjarabvu-ọkpa; waa ọphu ta anwafụtajedu nri taphu azụ; bụkwaru unu anụ, aasọ nsọ. Iphe, bụkpoo onye denyiru odzu iya ẹka l'a-bụkwarupho onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","G'iphe, bụkpoo anụ, nweru ọkpa ẹno, bụ ndu ọphu akọbeje nvọ eje ije bụkwaru unu anụ, aasọ nsọ. Onye denyiru odzu iya ẹka a-bụkwaru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Onye pataru odzu iya a-sa uwe iya asasa; tẹme l'ọ bụru onye aasọ nsọ jasụ nchi ejihu. Ụnwu anụ ono bụkotaru unu anụ, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“A -bya l'anụ, awụ l'ẹpho; ndu ọwa-a bụ ndu ọphu unu a-nọdu asọ nsọ: uphẹga; waa okerepfu; waa ngwere l'ụdu iya l'ụdu iya; ");
INSERT INTO izz_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","waa agụlo; waa awala; waa okporoko; waa orinvụru; waa oguba. ");
INSERT INTO izz_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ono bụkota anụ, unu a-sọje nsọ l'anụ, awụ l'ẹpho. Onye dụru ọphu o denyiru ẹka l'ẹka ọ nwụhuru anwụhu l'a-bụru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Iphe, bụ iphe, odzu iya ọphu nwụhuru anwụhu dapyabẹru bụakwaa iphe, aasọ nsọ; m'ọ bụ iphe, e gude oshi pyịa; ọzoo uwe; ọzoo akpọ-anụ; mẹ uwe-aphụ; mbụkpoo iphe, bụ ngwa, e gude emekpọo iphemiphe; g'e dekwaa ya lẹ mini; l'ọ nọo bụru iphe, aasọ nsọ jasụ nchi ejihu; l'a tụrwua ya. ");
INSERT INTO izz_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Teke ọ dụru g'ẹphe ha ọphu daru l'ite ụrwa; iphe, bụkpoo iphe, dụ l'ite ono bụkotaakwa iphe, aasọ nsọ; unu tụkpokwaa ite ọbu atụkpo. ");
INSERT INTO izz_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nri, e gude ite, dụ nno kuta mini shibe bụakwaa nri, aasọ nsọ; tẹme iphe, aangụ angụngu shi l'ite, dụ nno bụakwaa iphe-angụngu, aasọkwapho nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Iphe, odzu anụ ono, a gụshiru ono daru bụakwaa iphe, aasọ nsọ. Ọ -bụru l'ọ daru l'ite-ọku; ọzoo l'epfu, eeshi ite g'a phọtakwa iya je atụkposhia. Ẹphe bụwaa iphe, aasọ nsọ; ọo ya bụ; unu mekwaa ya phọ iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ọ -bụru l'ọ daru l'ẹnya ẹka mini eshije anwụshi; ọzoo l'obvu, mini dụ shii bẹ dụebekwa ree; ọle onye denyiru odzu iya ono ẹka bẹ bụakwaa onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ọ -bụru l'ọ dụru odzu anụ ono ọphu daru lẹ mebyi iphe, eemebe l'alị bẹ mebyi iphe ono ta abụkwa iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Obenu; ọ -bụru l'e yewaru mini lẹ mebyi iphe ọbu; odzu anụ ono dalahụ iya bẹ ọ bụakwaa unu iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Ọ -bụru l'ọo anụ ọphu a harụ g'unu tajẹ anụ iya nwụhuru bẹ onye denyiru iya ẹka a-bụkwaru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Onye takwanụru odzu iya l'a-sa uwe iya asasa; bụru onye aasọ nsọ jasụ nchi ejihu. Onye patakpọrunu odzu iya apata l'a-sakwaphọ uwe iya; bụru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Iphe, bụkpoo iphe, awụ awụwu, bụ ọphu akpụ wuruwuru l'alị l'a-bụkotakwaru ẹbyi; ọphu e rijekwa iya eriri. ");
INSERT INTO izz_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Unu ta tajẹkwa iphemiphe, awụ awụwu lẹ mgboko-a; m'ọ bụ ọphu gude ẹpho awụ; ọzoo ọphu gude ọkpa ẹno eje; ọzoo ọphu gude igwe ọkpa eje; kẹle ẹphe tụkoru bụru ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","G'ọ tọ dụkwa iphe, awụ l'ẹpho, unu e-gude mee onwunu ẹbyi. Ọphu unu egudekwa phẹ mee onwunu ndu aasọ nsọ; g'unu te shi l'ẹphe bụru ndu e merwuru emerwụ; ");
INSERT INTO izz_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. Ọo ya bụ; unu sachaa onwunu; unu adụ nsọ; kẹle mbẹdua dụ nsọ; ọphu unu atụrwukwa onwunu l'iphe, awụ awụwu, bụ ọphu akpụ wuruwuru l'alị g'ọ dụhabe; ");
INSERT INTO izz_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","kẹle ọ kwa mbẹdua bụ Chipfu, onye shi l'alị Ijiputu dufuta unu gẹ mu bụru Chileke unu. Ọo ya bụ lẹ-a; unu dụkwa nsọ; kẹle mbẹdua dụkwa nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ono bụ ekemu, a tụru swibe anụ; waa ẹnu; waa iphe, bụ iphe, dzụ ndzụ, bu l'ime mini; mẹkpoo iphe ọzo, bụ iphe, awụ awụwu, bụ ọphu akpụ wuruwuru l'eliphe; ");
INSERT INTO izz_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","g'e gude dokaha iphe, aasọ nsọ; yẹe iphe, a ta sọdu nsọ; dokaha anụ, bụ ọphu ee-rije eriri; yẹe ọphu e te ridu eriri.” ");
INSERT INTO izz_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Pfuru yeru ụnwu Ízurẹlu; sụ phẹ-a: Nwanyị -tsụta ime bya anwụa nwa nwoke; g'ọ bụkwaru onye aasọ nsọ nọo abalị ẹsaa; mbụ l'ọo ẹpho g'aasọ-bejeru iya nsọ mẹ ọ -nọdu anọ nsọ nwanyị-a bụ g'aa-sọ-beru iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","O -be lẹ mbọku k'ẹsato l'e bua nwata ọbu úbvù. ");
INSERT INTO izz_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","E -mechaa; nwanyị ono anọo ụkporo abalị l'abalị iri l'ẹto g'e gude swafụ iya ntụrwu mee, larụ iya nụ. G'ọ tọ dụkwa iphe, e doberu nsọ, oo-denyi ẹka; tẹme ọphu ọ bahụkwa lẹ Ụlo-dụ-nsọ jasụ mbọku, nsọ aswafụ ntụrwu iya a-bvụ. ");
INSERT INTO izz_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Ọ -bụru l'ọo nwa nwanyị bẹ ọ nwụru bẹ nwanyị ọbu a-bụru onye aasọ nsọ ujiku iri l'ẹno; ẹgube ono, aanọduje asọ iya nsọ mẹ ọ -nọdu anọ nsọ nwanyị ono. Iphe, ọo-nọ g'e gude swafụ iya ntụrwu mee alala bụ ujiku ụkporo ẹto l'ishii. ");
INSERT INTO izz_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Teke eswe mbọku aswafụ ntụrwu iya ono bvụerupho; l'onye nwụru nwoke ọzoo nwanyị; gẹ nwanyị ono kpụta nwatụru mgbapha g'e gude gwee ngwẹja-akpọ-ọku. L'ọ nwẹkwapho nwa ndo; ọzoo kparaka; g'e gude gwee ngwẹja-iphe-ẹji. G'o gude iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ bya anụ onye uke. ");
INSERT INTO izz_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Onye uke ono egude iphe ono je egwee ngwẹja nụ Chipfu gude pfụa ụgwo iphe-ẹji iya; l'ọ bya adụebe ree lẹ mee, larụ iya nụ. Noo ekemu, dụru nwanyị, nwụru nwa nwoke; ọzoo nwa nwanyị. ");
INSERT INTO izz_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Teke ọ bụ l'onye ọbu ta adụdu ike agbata nwatụru; g'ọ nwụtaru iya kparaka labọ; ọzoo nwa ndo labọ. L'a nwụta nanụ gude gwee ngwẹja-akpọ-ọku; gude ọphuu gwee ngwẹja-iphe-ẹji. Onye uke egude iya pfụa ụgwo iphe-ẹji iya; l'ọ bya adụebe ree.” ");
INSERT INTO izz_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu yẹe Erọnu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ọ -bụru l'o nweru ọ́nyá, nọ nemadzụ l'ẹhu; ọzoo l'ọo iphe, dụ g'ẹ́kpá; ọzoo l'iphe, tụkashiru iya poopoo l'ẹhu, bụgbaa iphe, nweru g'ọo-dụ; l'ọ ghọo ekpenta; nọdu onye ono l'akpọ-ẹhu; g'e dutakwa onye ọbu duru jepfu Erọnu, bụ onye uke; ọzoo l'e duru iya jepfu onye bụ nwa iya, bụkwapho uke. ");
INSERT INTO izz_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","G'onye uke ono lee ẹnya l'ọ́nyá ono, nọ onye ọbu l'akpọ-ẹhu ono. Teke ọ bụ l'ẹji, futaru l'ẹka ono ghọhuru aghọhu acha ụcha; tẹme ẹka ono dalahụ adalahụ; bẹ ẹka-iphe-nọ ọbu bụakwaa ekpenta; nọdu onye ono l'akpọ-ẹhu. G'onye uke lee ya ẹnya gụa ya l'onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Teke ọ bụ l'ẹka ọbu acha iya ụcha l'akpọ-ẹhu; e lee ya ẹnya ọphu ọ dalahụduru adalahụ; ọphu ẹji, nọ iya nụ aghọhuduru aghọhu acha ụcha; g'onye uke gụ-chia onye ono l'ụlo nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","O -be lẹ mbọku k'ẹsaa; g'onye uke je elebaa onye ọbu ẹnya l'ẹhu; teke ekpenta ono dụ g'ọ dụ; ọphu ọ kadụ asa ọsa; g'onye uke ono gụ-chifua ya l'ụlo ujiku ẹsaa ọzo. ");
INSERT INTO izz_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","O -bekwa lẹ mbọku k'ẹsaa; g'onye uke jekwaphọ elebaa onye ọbu ẹnya l'ẹhu. Ọ -bụru l'ẹka-iphe-nọ iya ọbu dụwaa inchi inchi; ọphu ọ kadụ asa ọsa; g'onye uke gụa ya onye a ta sọdu nsọ. Iphe, ọ bụ bẹ bụ ẹ́kpá mmanụ. G'ọ saa uwe iya asasa; bụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Obenu lẹ-a; teke iphe ono bakahụru ka iya ọsa l'ẹhu; g'onye uke hụmachaaru iya sụ l'a taa sọdu iya nsọ phọ; g'o jekwa egoshibaa onwiya onye uke ono ọzo. ");
INSERT INTO izz_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Teke onye uke ono leru iya ẹnya bya ahụma l'ọosa iya ọsa l'ẹhu; mbụ iphe ono; g'onye uke ono gụkwaa ya l'onye aasọ nsọ; ọ kwa ekpenta eme onye ono. ");
INSERT INTO izz_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ọ -bụru lẹ nemadzụ bẹ iphe eme l'akpọ-ẹhu, bụ iphe, eswe nswe; g'e dukwaru onye ọbu jepfu onye uke. ");
INSERT INTO izz_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","G'onye uke ono lee ya ẹnya; teke o nweru ọ́nyá, nọ onye ono l'ẹhu, acha nmalanmala; o mewaa; ẹji, nọ iya nụ ghọhuwaa aghọhu; tẹme o nweru iphe, dụ g'àjị́, dụ iya nụ; ");
INSERT INTO izz_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","bẹ ọ kwa alagala ekpenta nọ onye ono l'akpọ-ẹhu. G'onye uke gụkwaa ya l'onye aasọ nsọ. G'o to jekwa iya agụ-chi l'ụlo; kẹle ọ bụakwaa onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Teke ọ bụ l'ekpenta ono vọshiru nemadzụ l'akpọ-ẹhu; ọ tụko onye ọbu ẹhu sweta; mbụ shi iya l'ishi vụa ya kpatakpata jasụ l'ọkpa; mbụ iphe, bụkpoo ẹka onye uke ono lekpọru iya ẹnya bụkotaru iya; ");
INSERT INTO izz_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","g'onye uke ono lebakwaa ya ẹnya. Ọ -bụru l'ekpenta ono mewaru iya; kpọhu; ẹka ono nọdu achawa ụcha; g'ọ gụkwaa onye ono l'onye a ta sọdu nsọ; kẹle ọ bụwaa ichii-iphe; ọ tọ bụedu ekpenta. ");
INSERT INTO izz_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ọle ọ -nọnyakwanaa; ájị̀ fụta l'ẹka-iphe-nọ iya ono; l'ọ bụru onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Onye uke ono -hụmaepho ájị̀ ono; g'ọ gụa onye ono l'onye aasọ nsọ; kẹle ájị̀ bụ iphe, aasọ nsọ. Ọ kwa ekpenta eme onye ono. ");
INSERT INTO izz_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ọ -bụru l'ájị̀ ono nọnyaaru gbanwee; bya aghọhu chaahaa ụcha; g'onye ọbu jepfukwa onye uke ọzobaa. ");
INSERT INTO izz_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","G'onye uke ono lee ya ẹnya; ọ -bụru l'ẹka ono iphe shi eme iya ono kpọhuwaru; achawa ụcha; g'onye uke ono pfukwaa l'onye ono, iphe shi eme ono bẹ a taa sọedu nsọ. Teke ono; onye ono abya abụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“A bya l'ẹhu onye bụ ẹjo-onwo shi phọo ya; ọ kawaa mma; ");
INSERT INTO izz_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a bya l'ẹka ono, ẹjo-onwo shi phọo ya ono; ọ -bụru l'ọ byaru ahụta ahụta acha ụcha; ọzoo l'o nweru ẹka acha ụcha bya adụ nwa uswe-uswe; g'e jekwa egoshi iya onye uke. ");
INSERT INTO izz_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","G'onye uke ono lekwaa ya ẹnya; ọ -bụru l'ẹka ono dalahụru adalahụ; tẹme ẹji, futaru l'ẹka ono ghọhuwaa aghọhu acha ụcha; g'onye uke ono gụa ya l'onye aasọ nsọ; kẹle ọ kwa ekpenta larụ onye ono l'ẹka ono, ẹjo-onwo shi phọo ya ono. ");
INSERT INTO izz_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ọle ọ -bụru l'onye uke ono leru ẹka ọbu ẹnya; ọphu ẹji, furu l'ẹka ono aghọhuduru aghọhu; ọphu ọ dalahụduru adalahụ; ọ rwakputewa arwakpute; g'onye uke ono gụ-chia onye ono l'ụlo g'ọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Teke ọ bụ l'ẹka-iphe-nọ iya ọbu kabaa asa ọsa eviya; g'onye uke ono pfukwaa l'ọ bụ onye aasọ nsọ; kẹle ọ bụ ekpenta eme iya. ");
INSERT INTO izz_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Teke ọ bụ l'ẹka-iphe-nọ iya ono dụepho g'ọ dụ; ọphu ọ sadụ ọsa; l'a maru l'ọo ichii ẹjo-onwo phọ bẹ ọ bụ; g'onye uke ono gụa ya l'onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Teke ọ bụ l'ọku hụru nemadzụ l'ẹhu; ẹka ono, ọku hụru iya ono chaahaa ụcha; bya adụkwapho nwa uswe-uswe; ọzoo l'ọocha ụcha; ");
INSERT INTO izz_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","g'onye uke ono lekwaa ya ẹnya; ọ -bụru l'ẹji, futaru l'ẹka ono ghọhuwaru aghọhu acha ụcha; tẹme ẹka ono dalahụ adalahụ; bẹ ọ bụkwa ekpenta larụ onye ọbu l'ẹka ono, ọku hụru iya ono. Ọo ya bụ g'onye uke gụkwaa ya l'onye aasọ nsọ; kẹle ọ kwa ekpenta eme onye ono. ");
INSERT INTO izz_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Obenu lẹ-a; ọ -bụru l'onye uke ono leru iya ẹnya; ọphu ẹji, nọ iya l'ẹka ono aghọhuduru aghọhu acha ụcha; tẹme ọphu ẹka ono adalahụduru adalahụ; tẹme ẹka ono rwakputewa arwakpute; g'onye uke ono gụ-chia ya l'ụlo g'ọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","O -be lẹ mbọku k'ẹsaa g'onye uke ono lebaa ya ẹnya l'ẹhu. Teke ọ kabaa ya asa ọsa l'ẹhu eviya; g'onye uke ono pfukwaa l'ọ bụ onye aasọ nsọ; kẹle ọ kwa ekpenta eme iya. ");
INSERT INTO izz_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ọle ọ -bụkwanuru l'ẹka-iphe-nọ iya ono dụepho g'ọ dụ; ọphu ọ kadụ iya asa ọsa l'ẹhu; ọ gbẹchianu arwakpute arwakpute bẹ ọ bụkwa ọku ono, hụru iya nụ ono switaru iya eswita; g'onye uke ono gụkwaa ya l'onye a ta sọdu nsọ; kẹle ọo ichii ọku phọ bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ọ -bụru lẹ nwoke; ọzoo nwanyị bẹ ọ́nyá dụ l'ishi; ọzoo l'agba; ");
INSERT INTO izz_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","g'onye uke lekwaa ẹnya l'ọ́nyá ọbu. Ọ -bụru l'ọ dalahụru adalahụ; mbụ ọ́nyá ọbu; tẹme ẹ́jí, furu iya nụ dụ manụ-manụ; bya adụ kẹ zịtazita; g'onye uke ono gụkwaa ya l'onye aasọ nsọ; kẹle ọo ẹjo akụruba; mbụ l'ọo ekpenta tụru onye ono l'ishi; ọzoo l'agba. ");
INSERT INTO izz_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ọle ọ -bụru l'onye uke ono lechaaru ẹnya l'ẹjo akụruba ọbu; ọphu ọ dụdu l'ẹnya g'ọ dalahụru adalahụ; tẹme ọphu ẹ́jí, dụ iya nụ ejidu uji; g'onye uke ono gụ-chia onye ono l'ụlo g'ọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","O -be lẹ mbọku k'ẹsaa g'onye uke ono lebaa ẹnya l'iphe-ememe ono; ọ -bụru l'ẹjo akụruba ono ta abakahụduru abakahụ; ọphu ẹ́jí, dụ iya nụ adụdu manụ-manụ; ọphu akụruba ono adụdu l'ẹnya g'ọ dalahụru adalahụ; ");
INSERT INTO izz_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","g'a kpụshia onye ono ishi; kpụ-buru ẹka akụruba ono dụ haa; g'onye uke ono gụ-chifua ya l'ụlo g'ọ nọo ujiku ẹsaa ọzo. ");
INSERT INTO izz_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Teke o rwuru mbọku k'ẹsaa; g'onye uke ono lee ẹnya l'akụruba ono; ọ -bụru l'ọ tọ bakahụduru abakahụ; e lee ya ẹnya; ọphu ọ dalahụduru adalahụ; g'onye uke ono gụa ya l'onye a ta sọdu nsọ. G'onye ono saa uwe iya; bụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Obenu lẹ-a; ọ -bụru l'akụruba ono bakahụru iya l'akpọ-ẹhu eviya g'a gụwaru iya l'onye a ta sọdu nsọ-a; ");
INSERT INTO izz_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","g'onye uke ono lebaa ya ẹnya. Ọ -bụru l'akụruba ono bakahụru iya l'ẹhu; g'onye uke te jeẹkwa ele ẹnya g'a maru ẹ́jí iya; ?ọ dụ manụ-manụ. Onye ono bụakwaa onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ọ -bụru l'akụruba ọbu bẹ dụepho g'ọ dụ l'ẹnya; tẹme ẹ́jí ojii rwutawaa l'ẹka ono bẹ akụruba ọbu kpọhuakwaru; ọ bụakwaru onye a ta sọdu nsọ; g'onye uke gụa ya l'onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ọ -bụru lẹ nwoke; ọzoo nwanyị bẹ iphe-ọchaa tụkashiru poopoo l'ẹhu; achagbaa ụcha; ");
INSERT INTO izz_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","g'onye uke lekwa onye ọbu ẹnya l'ẹhu. Ọ -bụru l'ẹka ọbu ta achadu ọkpobe ụcha; l'a maru l'ọo ụ́gwò bẹ tụkashiru onye ọbu l'ẹhu; l'onye ọbu bẹ a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Ẹgbushi -rishihu onye nwoke l'ishi; bụkwa ishi-ọnmo bẹ ọ bụ; obenu l'a taa sọdu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Teke ọ bụ l'ọo l'ọnu-iphu bẹ ẹgbushi rishihuru iya; bẹ onye ọbu bụkwa ishi ọnmo ọnu-iphu; obenu l'a taa sọdu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ọle ọ -bụru l'ọ dụru ọ́nyá, acha ụcha; bya adụkwapho nwa uswe-uswe, nọ iya l'ishi-ọnmo ọbu; ọzoo l'ishi-ọnmo ọnu-iphu ọbu; bẹ ọ bụakwaa ekpenta bẹ tụru iya l'ishi-ọnmo ọbu; ọzoo l'ishi-ọnmo ọnu-iphu ọbu. ");
INSERT INTO izz_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ọo ya bụ; g'onye uke lee ya ẹnya. Teke ọ bụ l'ọ́nyá, dụ onye ono l'ishi; ọzoo l'ọnu-iphu acha ụcha; bya adụkwapho nwa uswe-uswe; mbụ dụ g'ekpenta ono, eswe nswe, emeje nemadzụ l'akpọ-ẹhu ono; ");
INSERT INTO izz_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ọo ya bụ l'onye ọbu bụ onye ekpenta; ọ bụru onye aasọ nsọ eviya. G'onye uke ono gụa ya l'onye aasọ nsọ; kẹle ekpenta nkiya tụru iya l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“G'onye ekpenta ono lakakwaa uwe iya; haa ẹgbushi iya g'ọ yagashịhu ayagashịhu; woru ẹkwa gbobuta ụgbo-ọnu; chia mkpu sụ lẹ ya bụkwa onye aasọ nsọ; ya bụkwa onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ọo-bụru onye aasọ nsọ jasụ teke ọo-ka mma. G'ọ bụru onye aasọ nsọ je eburu nkịnyi iya l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ọ -bụru l'o nweru uwe, tsụru evu; ọzoo uwe ẹji anụ; ọzoo uwe ọchaa; ");
INSERT INTO izz_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ọzoo ẹkwa, e kweru l'oghu ọchaa; ọzoo ọphu e gude ẹji anụ kwee; ọzoo l'akpọ; ọzoo l'iphe, e meru l'akpọ; ");
INSERT INTO izz_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","teke ọ bụ l'ẹka ono, tsụru evu ono dụ oyingo-oyingo; ọzoo l'ọ dụ uswe-uswe; bẹ ọ bụkwa ekpenta. G'e jekwa egoshi iya onye uke. ");
INSERT INTO izz_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","G'onye uke ono lekwaa ẹnya l'ẹka ono, tsụru evu ono; woru iphe ọbu, tsụru evu ọbu gụ-chia l'ụlo g'ọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","O -be lẹ mbọku k'ẹsaa; g'onye uke ono je elebaa ya ẹnya ọzo. Ọ -bụru l'evu ọbu kabaa asakahụ l'uwe ọbu; g'a makwarụ l'ọ bụ ekpenta. Iphe ono, tsụru evu ono bụakwaa iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","G'onye ono kpọkwaa uwe ono ọku; m'ọ bụ uwe ẹji anụ; ọzoo uwe ọchaa; m'ọ bụ ẹkwa, e kweru l'oghu ọchaa; ọzoo ọphu e gude ẹji anụ kwee; ọzoo l'iphe, e meru l'akpọ, bụ ọphu evu ono dụ; g'a kpọkwaa ya ọku; kẹle ọ bụ ekpenta. ");
INSERT INTO izz_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ọle ọ -bụru l'onye uke ono leru iya ẹnya; ọphu evu ọbu asakahụduru asakahụ l'iphe ono; ");
INSERT INTO izz_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","g'onye uke ono zia g'a saa iphe ono, tsụru evu ono asasa; l'ọ bya agụ-chia ya l'ụlo g'ọ nọo ujiku ẹsaa ọzo. ");
INSERT INTO izz_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","G'onye uke ono lee ẹnya l'iphe ono; mẹ a sachaa ya ono; ọ -bụru l'iphe ọbu ta agbanwedụru ụdudu iya; obetakpọru ọphu ọ sakahụduru asakahụ; bẹ ọ bụkwa iphe, aasọ nsọ; g'a kpọkwaa ya ọku; mẹ evu ọbu; ?ọ nọ iya l'iphu; m'ọ nọ iya l'azụ. ");
INSERT INTO izz_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ọ -bụru l'onye uke ono jeshiaru iya ele ẹnya; ẹka ono, tsụru evu ono rwakputewa arwakpute g'a sachaaru iya ono; g'ọ lakafụkwa ẹka ono, tsụru evu ono; mbụ l'uwe ono; ọzoo l'akpọ ono; ọzoo l'ẹkwa ono, e kweru ekwekwe ono; ọzoo l'ọphu a kparụ akpakpa. ");
INSERT INTO izz_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ọle ọ -bụru l'ọ watawarụ atsụ evu ono ọzo l'uwe ono; ọzoo l'iphe ono, e kweru ekwekwe; ọzoo l'ọphu a kparụ akpakpa; m'ọ bụ l'iphe ono, e meru l'akpọ-anụ ono; l'a maru l'ọ bụ iphe, asakahụ asakahụ. G'a kpọkwaa iphe, bụ iphe, tsụru evu ono ọku. ");
INSERT INTO izz_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Iphe, bụ iphe, tsụru evu, a sawaru asasa; ọphu evu ono adụedu iya; g'a saa ya k'ugbo ẹbo g'ọ bụru iphe, a taa sọhedu nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ono bụ ekemu, dụru iphe, bụ evu, tsụru l'uwe ẹji anụ; ọzoo l'uwe ọchaa; ọzoo l'ẹkwa, e kweru ekwekwe; ọzoo l'ọphu a kparụ akpakpa; ọzoo l'ọphu e gude akpọ-anụ mee; g'a gụa ya iphe, a ta sọdu nsọ; ọzoo l'a gụru iya l'iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ọwaa bụ ekemu, ee-tsoje mbọku, ee-me onye ekpenta shi eme g'a ta sọhe iya nsọ: G'e duru iya dutaru onye uke. ");
INSERT INTO izz_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","G'onye uke ono shikwa l'ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ lụfu je elerwee ya ẹnya ree. Ọ -bụru l'onye ono wekọrohuwaru l'ekpenta ono, shi eme iya l'akpọ-ẹhu ono; ");
INSERT INTO izz_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","g'onye uke ono zia ozi g'e wotaru onye ọbu, eeme g'a ta sọhe nsọ ọbu ẹnu labọ, nọ ndzụ, a ta sọdu nsọ; waa oshi sida; waa ẹkwa uswe-uswe; waa ẹswa ịsopu. ");
INSERT INTO izz_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Onye uke ono asụ g'e gbua ẹnu ono nanụ l'eli ite, a kpụru l'ụrwa, e yeru mini, doru rịsaa. ");
INSERT INTO izz_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ẹnu ọphu nọ ndzụ phọ bẹ ọo-nwụta; wota oshi sida phọ; waa ẹkwa uswe-uswe phọ; waa ẹswa ịsopu phọ; tụko tsẹe lẹ mee ẹnu ono, e gburu l'eli mini ono, dụ ree ono. ");
INSERT INTO izz_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","L'ọ bya ephee ya onye ono ugbo ẹsaa; mbụ onye ono, eeme g'a ta sọhe nsọ l'ekpenta ono, shi eme iya nụ ono. L'ọ bya agụa ya l'onye a ta sọdu nsọ; woru ẹnu k'ono, dzụ ndzụ ono haa g'o pheba l'ẹgu. ");
INSERT INTO izz_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Onye ono, byaru g'e mee ya g'a ta sọhe iya nsọ ono eje eworu uwe iya saa; kpụshikọta ẹji, dụ iya l'ẹhu g'ọ ha; mẹ ẹgbushi iya; woru ẹhu wụa lẹ mini; shi nno bụru onye a ta sọdu nsọ. E -mechaa nno; l'ọ batawarọ l'ime ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ; ọle g'ọ nọkwaa l'azụ ụlo-ẹkwa iya ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ọ -nọchaa ujiku ẹsaa g'ọ kpụshikwaa ẹji, dụ iya l'ẹhu g'ọ ha ọzo. G'ọ kpụshia ishi; yẹe ẹ́jí-agba; waa njibu-ẹnya; mẹwaro ẹji ọzo, dụgbaa ya l'ẹhu. L'ọ saa uwe iya; woru ẹhu wụa lẹ mini; ọo ya bụ; l'ọ bụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Teke o rwuru lẹ mbọku k'ẹsato; g'onye ọbu kpụta ụnwu ebili labọ, adụdu ẹka iphe mebyiru iya; waa ada atụru, gbaru apha, adụdu ẹka iphe mebyiru iya. Tẹme l'o gude ụzo ẹto l'ime nkwẹka ukpokutu ereshi, e keru ụzo ẹto; gwọo lẹ manụ; g'e gude iya gwee ngwẹja-nri. L'o wotakwaphọ manụ, jiru konggo ejiji tukobe iya. ");
INSERT INTO izz_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Onye uke ono, eme iya g'a ta sọhe iya nsọ ono; abya eduta onye ọbu, eeme g'a ta sọhe nsọ ọbu; yẹe iphemiphe ono, o gude bya ono; bya eworu dobe l'iphu Chipfu l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","L'ọ bya akpụta nwa ebili ono nanụ; yẹe konggo, manụ jiru ejiji phọ; gude gwee ngwẹja-apfụ-ụgwo. G'ọ maa ngwẹja ono l'iphu Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","“L'ọ bya eworu nwa ebili ono gbua l'ụlo-dụ-nsọ; mbụ l'ẹka ono, eegbuje anụ, e gude egwe ngwẹja-iphe-ẹji; yẹe ngwẹja-akpọ-ọku. Ọo ẹgube ono, ngwẹja-iphe-ẹji bụ k'onye uke bụkwapho gẹ ngwẹja-apfụ-ụgwo bụkwapho nkiya; tẹme ọ bụru ngwẹja, dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Onye uke ono emeta mee anụ ono, e gude gwee ngwẹja-apfụ-ụgwo ono; ye onye ono, eeme g'a ta sọhe nsọ ono l'atakpa-nchị ẹkutara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; yẹe mkpụshi-ọkpa ezeke-ọkpa ẹkutara iya. ");
INSERT INTO izz_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Onye uke ono abya emeta konggo manụ ono; bya emeru iya ye onwiya l'ọbochi-ẹka ẹkicha; ");
INSERT INTO izz_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","l'ọ bya eworu mkpụshi-ẹka ẹkutara tsẹe lẹ manụ ono; meta iya phee ugbo ẹsaa l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Manụ ọphu ghuduru iya l'ọbochi-ẹka bẹ ọo-tada onye ono, eeme g'a ta sọhe nsọ ono l'atakpa-nchị ẹkutara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; waa mkpụshi-ọkpa ezeke-ọkpa ẹkutara; waa l'eli mee anụ ono, e gude gwee ngwẹja-apfụ-ụgwo ono. ");
INSERT INTO izz_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Manụ ọphu ghuduru nụ bẹ oo-hu onye ono, byaru g'e mee ya g'a ta sọhe iya nsọ ono l'ishi; gude pfụa ụgwo iphe-ẹji onye ono l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Onye uke ono abya egwee ngwẹja-iphe-ẹji ono; gude pfụa ụgwo iphe-ẹji, onye ono meru; mbụ onye ono byaru g'e mee ya g'a ta sọhe iya nsọ ono. E -mechaa; l'o woru anụ ono, ee-gude gwee ngwẹja-akpọ-ọku ono gbua; ");
INSERT INTO izz_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","woru ngwẹja-akpọ-ọku ono; yẹe ngwẹja-nri, tso iya nụ l'ọru-ngwẹja; gude pfụa ụgwo iphe-ẹji onye ono l'ọ bya abụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ọle ọ -bụru l'onye ọbu akpa nri; ọphu ọ dụdu ike anụ iphemiphe ono, a gụshiru ono; g'onye ọbu kpụta nwa ebili lanụ nụ g'ọ bụru kẹ ngwẹja-apfụ-ụgwo; l'e woru iya maa g'ọ bụru ngwẹja-amama, e gude apfụ ụgwo iphe-ẹji. Tẹme l'o wota nkeru-iri nkwẹka ukpokutu ereshi, a gwọru lẹ manụ; g'ọ bụru ngwẹja-nri; waa manụ, jiru konggo; ");
INSERT INTO izz_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","mẹ ndo labọ; ọzoo kparaka labọ; ọphu rwukpọeru iya phọ ẹka. Nanụ bẹ ee-gude gwee ngwẹja-iphe-ẹji; l'e gude ọphuu gwee ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","O -be lẹ mbọku k'ẹsato l'ọ chịru iphemiphe ono byapfuta onye uke g'e gude mee ya g'a ta sọhe iya nsọ; gude iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","G'onye uke ono kpụta nwatụru ono; yẹe konggo, manụ jiru ejiji ono je amaa l'iphu Chipfu g'ọ bụru ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","L'o woru nwatụru ono gbua; meta mee ya tada onye ọbu, eeme g'a ta sọhe nsọ ọbu l'atakpa-nchị ẹkutara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; wakwaphọ lẹ mkpụshi-ọkpa ezeke-ọkpa ẹkutara. ");
INSERT INTO izz_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Onye uke ono abya emeta manụ ono bya emeru ye onwiya l'ọbochi-ẹka ẹkicha; ");
INSERT INTO izz_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","l'o woru mkpụshi-ẹka ẹkutara iya phee manụ ono ugbo ẹsaa l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Onye uke ono abya emeta manụ ono, dụ iya l'ọbochi-ẹka ono tada l'ẹka ono, ọ tadaru mee anụ ono, e gude gwee ngwẹja-apfụ-ụgwo ono, bụ iya bụ l'atakpa-nchị ẹkutara onye ono, eeme g'a ta sọhe iya nsọ ono; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹkutara; waa lẹ mkpụshi-ọkpa ezeke-ọkpa ẹkutara iya. ");
INSERT INTO izz_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Manụ ọphu ghuduru iya l'ọbochi-ẹka bẹ oo-hu onye ono, byaru g'e mee ya g'a ta sọhe iya nsọ ono l'ishi; gude pfụa ụgwo iphe-ẹji iya l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","L'ọ nwụta ndo ono; ọzoo kparaka ono, bụ ọphu onye ono dụru ike gbata; gude gwee ngwẹja. ");
INSERT INTO izz_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nanụ bẹ oo-gude gwee ngwẹja-iphe-ẹji; l'o gude ọphuu gwee ngwẹja-akpọ-ọku; yẹe ngwẹja-nri. Ọo ẹgube ono bụ g'onye uke a-nọdu l'iphu Chipfu pfụa ụgwo iphe-ẹji onye ono, eeme g'a ta sọhe nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ono bụ ekemu, dụru onye oome; mbụ ekpenta ono; ọphu ọ dụdu ike gbata iphe, ee-gude mee g'a ta sọhe iya nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu yẹe Erọnu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Unu -laẹpho alị Kénanu ono, bụ ẹka mu abya anụ unu g'ọ bụru okiphe unu ono; ọ -bụru l'ọ dụru ụlo, nọ l'alị ono, mu meru; o nweru ẹka tsụru evu; ");
INSERT INTO izz_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","g'onye nwe ụlo ono jekwa akọoru onye uke l'ụlo iya gbẹkwa dụ iya g'ọ tsụru evu. ");
INSERT INTO izz_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Onye uke ono a-sụ g'e gweshigbua iphe l'ụlo ono; tẹme l'ọ bahụ jeshia ahụma ẹka tsụru evu ọbu; ọo ya bụ g'ọ tọ tụko ụlo ono; yẹe iphe, nọ iya nụ gụa l'iphe, aasọ nsọ. E -gweshikọtachaa iphe l'ụlo ono; g'onye uke ono bahụ l'ụlo ọbu je elee ya ẹnya. ");
INSERT INTO izz_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","G'o lee ẹnya l'igbulọ ẹka tsụru evu ọbu; teke ọ bụ l'ọ dụ oyingo-oyingo; ọzoo l'ọ dụ uswe-uswe; tẹme ẹka ọbu dalahụ adalahụ; ");
INSERT INTO izz_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","g'onye uke ono lụfuta l'ụlo ono; woru ọnu iya gụ-chia g'ọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","O -be lẹ mbọku k'ẹsaa; g'onye uke laphu azụ je elee ẹnya l'ụlo ọbu ọzo. Ọ -bụru l'evu ọbu sakahụru l'ọma igbulọ ono; ");
INSERT INTO izz_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","l'ọ sụ g'e bvufu mkpuma ono, tsụru evu ono je etuphaa l'ẹka aasọ nsọ l'azụ mkpụkpu. ");
INSERT INTO izz_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","L'e kwoshia igbulọ ime ụlo ono ekwoshi mgburugburu; kpota iphe, e kwoshiru iya je awụshia l'azụ mkpụkpu l'ẹka aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","L'e wota mkpuma ọzo gude tụ-chishia ẹnya iya ọphu e bvukpọfugbaaru phọ; tẹme l'a kụtakwapho ẹpuchi ọzo gude rwaa ụlo ọbu ọzo. ");
INSERT INTO izz_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Teke ọ bụ l'evu ọbu chafụtaru l'ụlo ọbu ọzo g'e bvukpọfuchaaru mkpuma mkpuma phọ; e kwoshichaa ya; bya arwaphu iya azụ ọbu; ");
INSERT INTO izz_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","g'onye uke laphu azụ jee elee ya ẹnya ọzo; teke ọ bụ l'evu ọbu bakahụru l'ụlo ọbu bẹ ọ bụkwa evu, asakahụ asakahụ dụ l'ụlo ono; ọo ya bụ; l'a maru l'ụlo ọbu bụwaa ụlo, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","G'e woru ụlo ọbu gbukaa; vuta mkpuma ụlo ọbu; mẹ oshi iya; waa ẹja, e gude rwaa ya je awụshia l'azụ mkpụkpu l'ẹka aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Onye bahụru l'ụlo ono teke ono, a gụ-chikwaduru iya agụ-chi ono; bẹ a-bụru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Onye zẹru l'ụlo ono kua mgbẹnya; ọzoo ria nri; g'onye ono sakwaa uwe iya asasa. ");
INSERT INTO izz_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ọle ọ -bụru l'onye uke byaru g'o lee ụlo ono ẹnya; ọ hụma l'evu ono ta adụedu ẹka ọ nọba l'ụlo ono g'a rwaphuchaaru iya azụ; g'ọ gụa ụlo ono l'ụlo, a ta sọdu nsọ; noo kẹle evu ọbu ta adụedu. ");
INSERT INTO izz_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Iphe, oo-gude mee ụlo ono g'ọ tọ bụhe ụlo, aasọ nsọ; bụkwa g'ọ nwụta ẹnu labọ; wotakwaphọ oshi sida; waa ẹkwa uswe-uswe; waa ẹswa ịsopu. ");
INSERT INTO izz_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","L'o woru ẹnu lanụ gbua l'eli ite, a kpụru l'ụrwa, e yeru mini, doru rịsaa. ");
INSERT INTO izz_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","L'o wota oshi sida phọ; waa ẹswa ịsopu phọ; waa ẹkwa uswe-uswe phọ; yẹe ẹnu phọ, dzụ ndzụ phọ; tụko tsẹe lẹ mee ẹnu ọphu e gburu egbugbu phọ; yẹle mini phọ, dụ ree phọ; woru iya phee l'ụlo ono akpọ ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Oo-gude mee ẹnu phọ; waa mini phọ, dụ ree phọ; waa ẹnu ọphu nọ ndzụ phọ; waa oshi sida phọ; waa ẹswa ịsopu phọ; waa ẹkwa uswe-uswe phọ mee ụlo ono g'a ta sọhe iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","L'o gude ẹnu k'ọphu nọ ndzụ phọ lụfu azụ mkpụkpu je ahaa ya g'o pheba l'ọma ẹgu. Ọ kwa ẹgube ono bẹ oo-shi pfụa ụgwo iphe-ẹji; shi nno safụ ntụrwu, dụ l'ụlo ono. Ọo ya bụ l'ụlo ọbu abụru ụlo, a ta sọdu nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ono bụ ekemu, g'ee-meje k'ekpenta, dụkpoo l'ụdu iya l'ụdu iya; yẹe ẹjo akụruba; ");
INSERT INTO izz_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","waa k'evu, tụru l'uwe; yẹe ọphu tụru l'ụlo; ");
INSERT INTO izz_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","waa k'onye ọ́nyá dụ l'ẹhu; ọzoo iphe dụ g'ẹ́kpá; ọzoo onye iphe tụkashiru poopoo l'ẹhu; ");
INSERT INTO izz_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","g'e shi ẹgube ono goshi teke iphe, bụ iphe, aasọ nsọ; waa teke ọ bụ iphe, a ta sọdu nsọ. Ono bụ ekemu, g'ee-meje k'ekpenta; waa k'iphe, tsụru evu. ");
INSERT INTO izz_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu yẹe Erọnu: ");
INSERT INTO izz_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Unu pfuru yeru ndu Ízurẹlu; sụ phẹ-a: Ọ -dụru onye nweru iphe, asọshi iya asọshi l'ẹhu; bẹ iphe ono, asọshi iya l'ẹhu ono bụkwa iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Iphe ono meakwaru onye ọbu; ọ bụru onye aasọ nsọ; mẹ iphe ọbu nọdu asọshi g'ọososhi; ọzoo l'ọ dụru iphe, e gude gbobuta iya bẹ ọ bụekwapho iphe, meru; a nọdu asọ iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Iphe, bụkpoo iphe-azẹe, onye ono, iphe asọshi l'ẹhu ono zẹru azẹe bẹ bụakwaa iphe, aasọ nsọ; tẹme iphemiphe, bụ iphe, ọ nọru anọo l'a-bụkwarupho iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","G'onye denyiru ẹka l'iphe-azẹe onye ọbu; sakwaa uwe iya asasa; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Onye nọru anọo l'iphe, onye iphe shi l'ẹhu asọshi shi nọdu anọo; g'onye ono sakwaa uwe iya; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","G'onye denyiru onye iphe shi l'ẹhu asọshi ẹka sakwaa uwe iya; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Onye ono, iphe asọshi l'ẹhu ono -gbụa onye a ta sọdu nsọ ọnu-mini; g'onye ọbu sakwaa uwe iya; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Tẹme iphe, aagbajẹkpo agbagba, onye ono, iphe asọshi ono nọru gbaa bẹ bụakwaa iphe, aasọ nsọ; ");
INSERT INTO izz_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","tẹme onye denyiru ẹka l'iphe, onye ọbu shi nọdu anọo; g'a sọkwaa onye ọbu nsọ jasụ nchi ejihu. Onye wotaru iphe ọbu bẹ a-sakwa uwe iya wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Onye iphe shi l'ẹhu asọshi -denyi onye ọzo ẹka; ọphu ọ kwọduru ẹka; g'onye ono sakwaa uwe iya asasa; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ọ -bụru ite, a kpụru l'ụrwa bẹ onye ọbu denyiru ẹka; g'a tụkpokwaa ya; teke ọ bụ iphe, e gude oshi mee; g'e gudekwa mini saa iphe ọbu asasa. ");
INSERT INTO izz_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Onye ono, iphe asọshi l'ẹhu ono -kaẹpho mma; g'ọ gụtaru onwiya ujiku ẹsaa nọo g'e gude mee ya g'a ta sọhe iya nsọ; l'ọ saa uwe iya; gude mini, doru rịsaa wụa ẹhu; l'ọ bya abụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","O -be lẹ mbọku k'ẹsato l'ọ nwụta kparaka labọ; ọzoo ụnwu ndo labọ gude bya l'atatiphu Chipfu l'ọnu-abata ụlo-ẹkwa-ndzukọ; bya anụ iya onye uke. ");
INSERT INTO izz_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Onye uke anwụta iya gude gwee ngwẹja. Nanụ bẹ oo-gude gwee ngwẹja-iphe-ẹji; l'o gude ọphuu gwee ngwẹja-akpọ-ọku. Noo g'ee-shi bụ ono l'ọ pfụa ụgwo iphe-ẹji onye ono, iphe asọshi l'ẹhu ono l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Teke nwoke gbọshiru ụnwuda; g'ọ wụkotakwa ẹhu iya l'ophu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ẹkwa; ọzoo akpọ, a gbọru ụnwuda kpua bẹ ee-gude mini saa asasa. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Nwoke yẹe nyee ya -kwaa akwakwa; ọ -bụru lẹ nwoke ono gbọru iphe; g'ẹphenebo jekwa awụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu phẹ nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Ọ -bụru lẹ nwanyị bẹ nsọ-nwanyị eme bẹ ọo-bụru onye mmerwu dụ l'ẹhu abalị ẹsaa; tẹme onye denyiru iya ẹka a-bụru onye aasọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Iphe, bụ iphe, ọ zẹkpooru azẹe teke ono, ọono nsọ ono; ọzoo iphe, ọ nọru anọo bẹ tụkoakwaru bụru iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Onye denyiru iphe-azẹe ya ẹka; a-sa uwe iya asasa; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Onye denyiru iphe, ọ nọru anọo ẹka; a-sa uwe iya asasa; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Onye denyiru iphe-azẹe ya ẹka; ọzoo oshi, ọonoje anọo ẹka bẹ bụakwaa onye aa-sọ nsọ jasụ nchi ejihu. ");
INSERT INTO izz_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ọ -bụru lẹ nwoke jepfuru nwanyị, anọ nsọ; mee ono, ala nwanyị ono -rwua ya l'ẹhu; g'a sọkwaa ya nsọ nọo abalị ẹsaa. Tẹme iphe, nwoke ono zẹru azẹe g'ọ ha abụkotaru iphe, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Ọ -bụru lẹ nwanyị bẹ mee larụ ujiku olemole lẹ teke ọ tọo nọdu nsọ; ọzoo lẹ mee ọbu laghataru onye ọbu ujiku ole, ọonoje nsọ; g'a sọkwaa onye ọbu nsọ g'aasọje iya mẹ ọ -nọdu anọ nsọ phọ. ");
INSERT INTO izz_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Iphe, bụkpoo iphe-azẹe, ọ zẹru azẹe l'iphe, bụkpoo mbọku lẹ mbọku ono, mee ono ala iya ono; bẹ aa-sọkwapho nsọ g'a sọru iphe-azẹe, ọozeje mẹ ọ -nọdu anọ nsọ phọ. Iphe, bụ iphe, ọ nọru anọo; g'a sọkwaa ya phọ ẹgube ono, aasọje iya mẹ ọ -nọdu anọ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Iphe, bụ onye denyiru ẹka l'iphe ono bụakwaa onye aasọ nsọ. G'onye ono sakwaa uwe iya; wụa ẹhu. A -nọwaa jasụ nchi jihu bẹ a taa sọhedu iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Obenu lẹ-a; mee ọbu -labuhuẹ ya phọ; g'ọ gụtaru onwiya ujiku ẹsaa nọo. E -mechaa l'ọ bya abụru onye a ta sọdu nsọ ");
INSERT INTO izz_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","O -be lẹ mbọku k'ẹsato g'onye ọbu nwụta kparaka labọ; ọzoo ụnwu ndo labọ; nwụtaru onye uke l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","G'onye uke ono nwụta ẹnu lanụ gude gwee ngwẹja-iphe-ẹji; l'o gude ọphuu gwee ngwẹja-akpọ-ọku. Onye uke ono e-shi nno pfụa ụgwo iphe-ẹji nwanyị ono l'iphu Chipfu lẹ kẹ mee ono, larụ iya nụ ono, shi mee ya; ọ bụru onye aasọ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Noo g'unu e-shije dobe ụnwu Ízurẹlu iche l'iphe, e-me g'ẹphe bụru ndu aasọ nsọ; g'ẹphe ta abụru ndu aasọ nsọ; nwụhu; m'ẹphe tụrwua ụlo-ẹkwa mu ono, nọ l'echilabọ phẹ ono.” ");
INSERT INTO izz_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ono bụ ekemu, a tụru doberu nwoke, iphe asọshi asọshi l'ẹhu; yẹe nwoke, gbọru ụnwuda; shi nno bụru onye aasọ nsọ; ");
INSERT INTO izz_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","bya abụkwarupho kẹ nwanyị, nsọ-nwanyị eme. Ọ bụ k'onye iphe asọshi l'ẹhu; m'ọ bụ nwoke-o; m'ọ bụ nwanyị-o; yẹe k'onye jepfuru nwanyị, aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","O be lẹ g'ụnwu Erọnu dụchaa ẹbo nwụhu; g'ẹphe jekubeẹrupho l'atatiphu Chipfu phọ; Chipfu bya epfuru yeru Mósisu; ");
INSERT INTO izz_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","sụ iya: “Pfuru yeru nwune ngu, bụ Erọnu sụ iya g'ọ tọ bụjekwarupho teke dụ iya ree bẹ ọo-byajẹ l'ẹka-kakọta-adụ-nsọ ono; mbụ l'ẹka ono, e gude ẹkwa kobuta ono, bụ iya bụ l'iphu ẹka aapfụje ụgwo iphe-ẹji, bụ ọphu nọ l'eli okpoko Chileke ono; ọdumeka bẹ ọo-nwụhukwa. Noo kẹle mu anọduje l'urwukpu bya l'eli ẹka aapfụje ụgwo iphe-ẹji ono. ");
INSERT INTO izz_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Waa gẹ Erọnu e-gudeje bahụ l'ẹka-kakọta-adụ-nsọ ono baa: Oo-gude nwa oke-eswi, oo-gude gwee ngwẹja-iphe-ẹji; bya egude ebili, oo-gude gwee ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“L'ọ chịta uwe-ime-ẹhu ọchaa, e doberu nsọ phọ yee; bya eyekwaaphọ nwịba ọchaa, eeyeje l'ime ẹhu; l'o wota ẹkwa-ọchaa atụ-buta-l'upfu gude tubuta onwiya; bya ewota okpu-ẹkwa ọchaa kpuru. Uwe ono g'ọ ha dụkota nsọ; noo g'o gude o je l'a-wụada ẹhu tẹme l'o gude uwe ono kwaa onwiya akwa ono. ");
INSERT INTO izz_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Gẹ ndu Ízurẹlu kpẹe Erọnu mkpi labọ g'o gude gwee ngwẹja-iphe-ẹji; waa ebili lanụ, oo-gude gwee ngwẹja-akpọ-ọku. ");
INSERT INTO izz_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Gẹ Erọnu kpụta oke-eswi phọ gude gwee ngwẹja-iphe-ẹji kẹ nkiya; shi nno pfụa ụgwo iphe-ẹji, o meru; yẹe kẹ ndibe iya l'atatiphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","L'ọ bya akpụta mkpi labọ phọ bya l'atatiphu Chipfu l'ọnu-abata ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Erọnu abya eworu ido tụaru mkpi labọ ono. Ido lanụ a-bụru kẹ Chipfu; ọphuu abụru kẹ Azazẹlu. ");
INSERT INTO izz_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Erọnu abya akpụta mkpi ọphu ido Chipfu daru gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","obenu lẹ mkpi ọphu ido kẹ Azazẹlu daru bẹ aa-kpụta lẹ ndzụ bya l'atatiphu Chipfu g'e gude iya pfụa ụgwo iphe-ẹji; tẹme l'a kpụtawa iya rọ je ahaa l'echiẹgu g'ọ lapfu Azazẹlu. ");
INSERT INTO izz_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Erọnu abya akpụta oke-eswi phọ, oo-gude gwee ngwẹja-iphe-ẹji; gude pfụa ụgwo iphe-ẹji onwiya yẹe kẹ ndibe iya phọ. L'o woru oke-eswi ono gbua g'ọ bụru ngwẹja-iphe-ẹji k'onwiya ono. ");
INSERT INTO izz_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","L'o wota iphe, aagụje ọku; vọta ọku l'ọru-ngwẹja, nọ l'atatiphu Chipfu; vọ-jia ya avọ-ji; bya ahata ụ̀nwù-isẹnsu ọphu e-ji mkpoji ẹka labọ, e gwerụ rwukuru rwukuru; gude bahụ l'ẹka ono, e kobutaru ẹkwa ono. ");
INSERT INTO izz_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","L'ọ bya eworu ụ̀nwù-isẹnsu ono tukobe l'eli ọku ono, nọ l'atatiphu Chipfu ono; k'ọphu ẹnwuru-ọku ụ̀nwù-isẹnsu ono a-kpụ tụuu kpụ-chia ẹka ono, aanọduje apfụ ụgwo iphe-ẹji ono, nọ l'eli okpoko ono, e doberu ekemu ono. Ọo ya bụ k'ọphu ọ tọo nwụhudu. ");
INSERT INTO izz_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","L'o meta mee oke-eswi ono; gude mkpụshi-ẹka phee ya l'eli ẹka ono, aapfụje ụgwo iphe-ẹji ono; l'o gudekwaphọ mkpụshi-ẹka phee mee-iphe ono mgbo ẹsaa l'iphu ẹka ono, aapfụje ụgwo iphe-ẹji ono. ");
INSERT INTO izz_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“L'o woru mkpi phọ, e gude gwee ngwẹja-iphe-ẹji ndu Ízurẹlu phọ; woru gbua egbugbu; gude mee ya bahụ l'ime ẹka ono, e kobutaru ẹkwa ono; woru mee ya ono mee g'o meru mee oke-eswi phọ; mbụ phee ya l'eli ẹka ono, aapfụje ụgwo iphe-ẹji ono; yẹle iphu ẹka ono, aapfụje ụgwo iphe-ẹji ono. ");
INSERT INTO izz_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ọ bụru ẹgube ono bẹ oo-shi pfụa ụgwo iphe-ẹji k'ẹka-kakọta-adụ-nsọ ono; kẹle ndu Ízurẹlu bẹ bụwaa ndu aasọ nsọ; waa kẹle ẹphe meswewaru iphe l'iphe-ẹji, ẹphe mekọtaru g'ọ ha. Ọ bụkwarupho nno bụ g'oo-me iya lẹ k'ụlo-ẹkwa-ndzukọ, bụ ọphu nọ l'echilabọ phẹ teke ono, ẹphe bụ ndu aasọ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","G'ọ tọ dụkwa onye a-nọdu l'ime ụlo-ẹkwa-ndzukọ ono; mẹ Erọnu bahụepho l'ẹka-kakọta-adụ-nsọ ono je anọdu apfụ ụgwo iphe-ẹji; jasụ l'ọ pfụ-ghee ụgwo iphe-ẹji k'onwiya; yẹe kẹ ndibe iya; yẹe kẹ ndu Ízurẹlu l'ophu; lụfuta. ");
INSERT INTO izz_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","E -mechaa l'o jeshia l'ọru-ngwẹja ono, nọ l'atatiphu Chipfu ono; je apfụa ụgwo iphe-ẹji k'ẹka ono. L'o meta mee oke-eswi phọ; yẹe mee mkpi phọ; wụru ye lẹ mpu, e mobegbaaru l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","L'o meta mee ono gude mkpụshi-ẹka iya phee ya l'ọru-ngwẹja ono mgbo ẹsaa; shi nno swafụ iya asọ nsọ kẹ ndu Ízurẹlu; dobe iya nsọ ọzo.” ");
INSERT INTO izz_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Erọnu -pfụchaa ụgwo iphe-ẹji, e meru l'ẹka-kakọta-adụ-nsọ ono; yẹe k'ụlo-ẹkwa-ndzukọ ono; yẹe k'ọru-ngwẹja ono; l'ọ bya akpụfuta mkpi phọ, nọ ndzụ phọ. ");
INSERT INTO izz_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","L'ọ bya eworu ẹka labọ byabẹ mkpi k'ono, nọ ndzụ ono l'ishi; mbụ Erọnu; bya atụko ẹjo-iphe, ndu Ízurẹlu mekọtaru; mẹkpoo emeswe, ẹphe meswekọtaru; yẹe iphe-ẹji, ẹphe mekọtaru g'ọ ha; pfushikọta kpua ya; l'ọ tụko iya byabẹ mkpi ono l'ishi; kpụru iya kpẹe onye a tụru ẹka g'o je ahaa ya l'echiẹgu. ");
INSERT INTO izz_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ọ bụru mkpi ono e-vutakọta ẹjo-iphe phẹ g'ọ ha laa l'ọma-ẹgu; ẹka e budu ebubu; je anọdu. Ọ bụru ẹka oo-je ahaa mkpi ono bụ l'echiẹgu. ");
INSERT INTO izz_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Erọnu abahụ l'ụlo-ẹkwa-ndzukọ je eyefu uwe ọchaa ono, o yeru tẹme ọ bahụshia l'ẹka-kakọta-adụ-nsọ ono. O -yefuchaa ya l'ọ haa ya l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","L'ọ nọdu l'ẹka dụ nsọ wụa ẹhu; woru uwe iya ye; lụfuta bya egwee ngwẹja-akpọ-ọku kẹ nkiya; yẹe kẹ ndu Ízurẹlu; shi nno pfụa ụgwo iphe-ẹji k'onwiya yẹe kẹ ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","L'o woru ẹba-anụ, e gude gwee ngwẹja-iphe-ẹji phọ kpọo ọku l'ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Onye phọ, jeru je ahaa mkpi phọ; g'ọ lapfu Azazẹlu phọ; l'a-sakwaphọ uwe iya; wụa ẹhu; tẹme l'ọ batawarọ l'ime ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Oke-eswi phọ; yẹe mkpi phọ, e gude gwee ngwẹja-iphe-ẹji phọ, bụ ọphu e wobataru mee ya l'ẹka-kakọta-adụ-nsọ g'e gude pfụa ụgwo iphe-ẹji phọ; bẹ aa-parụ lụfu l'azụ ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ; l'e woru akpọ iya; waa anụ iya; mẹkpoo nshị iya kpọo ọku. ");
INSERT INTO izz_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","G'onye ono, jeru akpọo ya ọku ono sakwaa uwe iya asasa; wụa ẹhu; tẹme l'ọ bata l'ime ẹka ndu Ízurẹlu kpọberu ụlo-ẹkwa phẹ.” ");
INSERT INTO izz_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“No iya; g'iphe-a bụkwaru iphe, Chileke tọru ọkpa iya sụ g'e tsoje, unu e-meje jasụ l'ojejoje. Mbụ-a; o -rwuje l'ọnwa ẹsaa; lẹ mbọku, ọnwa ono dụ l'abalị iri; unu aswịje ẹgu. Unu te ejekwa ozi ejeje ophu; mbụ unubẹ ndu a nwụru lẹ Ízurẹlu; mẹ ndu lwarụ alwalwa, bu l'echilabọ unu; ");
INSERT INTO izz_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","kẹle ọo mbọku ono bẹ aa-pfụ ụgwo iphe-ẹji, unu meru; g'e gude sachafụ unu iphe-ẹji, unu meru g'ọ ha; unu abụru ndu a ta sọdu nsọ l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Mbọku ono a-bụru unu eswe Sabatụ, bụ eswe-atụta-unme; unu aswịa ẹgu. Iphe ono bụ iphe, Chileke tọru ọkpa iya sụ g'e tsoje, unu e-meje jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ọ bụru onye uke, a wụru manụ l'ishi dobe nsọ g'ọ bụru onye uke l'ọzori nna iya bụ onye a-pfụ ụgwo iphe-ẹji ọbu. Oo-yeje uwe ọchaa ono, dụ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","L'ọ pfụa ụgwo iphe-ẹji, e meru l'ẹka-kakọta-adụ-nsọ; mẹ k'ụlo-ẹkwa-ndzukọ; mẹ k'ọru-ngwẹja; l'ọ bya apfụa ụgwo iphe-ẹji, ndu-uke meru; mẹ kẹ ndu Ízurẹlu l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ono a-bụwaruro iphe, Chileke tọru ọkpa iya sụ g'e tsoje, unu a-nọdu emewarọ jasụ l'ojejoje; mbụ l'aa-pfụje ụgwo iphe-ẹji, ụnwu Ízurẹlu l'ophu mekọtaru. Ọ bụru mgbo lanụ l'apha bẹ ee-meje iya.” E mekọtaepho iphemiphe gẹ Chipfu sụru Mósisu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Waa iphe, ii-pfuru yeru Erọnu yẹe ụnwu iya; yẹe ụnwu Ízurẹlu l'ophu baa; sụ phẹ-a: Wakwa iphe, Chipfu tụru ekemu iya baa: ");
INSERT INTO izz_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ọ -dụru onye Ízurẹlu gburu eswi; ọzoo nwatụru; ọzoo eghu l'ime ẹka ẹphe kpọbegbaaru ụlo-ẹ́kwà phẹ; ọzoo l'azụ ẹka ono; ");
INSERT INTO izz_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ọphu onye ono egudedu iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ g'e gude gwee ngwẹja nụ Chipfu l'iphu ụlo-ẹkwa Chipfu ono; onye ono bẹ ikpe ọchi nmaakwaru; ọ bụakwaa ọchi bẹ o gburu. G'e bufukwa iya lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Iphe, meru iphe, a tụru ekemu-a bụ g'o mee gẹ ndu Ízurẹlu wotajẹ ngwẹja ono, ẹphe anọduje egwe l'ọma ẹgu ono; bya egweru nụ Chipfu; mbụ g'ẹphe woru iya nụ onye uke l'ọnu-abata ụlo-ẹkwa-ndzukọ; g'o gbua ya g'ọ bụru ngwẹja-ẹhu-guu, e gwerụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Onye uke ono ephee mee anụ ono l'ọru-ngwẹja l'ọnu-abata ụlo-ẹkwa-ndzukọ; bya akpọo ẹba iya ọku g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ẹphe te egweẹduru ngwẹja phẹ anụ agwa, a kpụru; ọ dụ g'eghu; mbụ agwa ono, meru ẹphe dụ ghẹlegheleghele ono. Ono bụ iphe, Chipfu tọru ọkpa iya sụ g'e tsoje, ẹphe a-nọdu eme jasụ l'ojejoje; ẹphe eme iya; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Sụ phẹ lẹ-a: Onye bụ onye Ízurẹlu; ọzoo onye lwarụ alwalwa, ẹphe l'ẹphe bu, bụ onye gwerụ ngwẹja-akpọ-ọku; ọzoo l'ọ dụru ngwẹja ọzo, ọ nụru; ");
INSERT INTO izz_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ọphu o gudedu iya bya l'ọnu-abata ụlo-ẹkwa-ndzukọ bya egweru nụ Chipfu; g'e bufukwa onye ọbu lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Iphe, bụkpoo onye Ízurẹlu; ọzoo onye lwarụ alwalwa l'alị Ízurẹlu, tarụ mee-iphe bẹ mu a-nọduepho achị lẹ njọ; mbụ l'onye ono, tarụ mee-iphe ono; bẹ mu e-bufu lẹ ndu nkemu. ");
INSERT INTO izz_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Noo kẹle ndzụ iphemiphe, e meru ememe dobe bụ lẹ mee bẹ ọ dụ. Ọ kwa mee ono bẹ mu nụru unu g'unu gudeje iya bya apfụa ụgwo iphe-ẹji unu l'ọru-ngwẹja. Ọ bụru mee bẹ eegudeje apfụ ụgwo ndzụ nemadzụ. ");
INSERT INTO izz_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ọo ya kparụ iphe, mu sụru unubẹ ndu Ízurẹlu: G'ọ tọ dụkwa g'unu ha onye a-tajẹ mee-iphe; ọphu ọ dụkwa onye lwarụ alwalwa, unu l'ẹphe bu ebubu, a-tajẹ mee-iphe. ");
INSERT INTO izz_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Ọ -dụru onye Ízurẹlu; ọzoo onye lwarụ alwalwa, unu l'ẹphe bu, akpa l'ẹgbudu; ọ -gbua anụ; ọzoo ẹnu, a ta sọdu nsọ; g'onye ono phụshikwaa mee ya l'alị kpochia ya ẹja. ");
INSERT INTO izz_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Noo kẹle iphemiphe, nọ ndzụ, e meru ememe bụ lẹ mee bẹ ndzụ iya nọ. Ọ bụru iya kparụ, iphe, mu sụru ndu Ízurẹlu: ‘Unu ta adụkwa mee iphe, unu a-tajẹ; kẹle ndzụ iphemiphe, e meru ememe bụkota lẹ mee bẹ ọ nọ; l'onyemonye tarụ iya nụ bẹ ee-bufukwa ebufu.’ ");
INSERT INTO izz_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Onyemonye kpọ; m'ọ bụ onye a nwụru lẹ Ízurẹlu; m'ọ bụ onye lwarụ alwalwa, bụ onye tarụ iphemiphe, bụ iphe, nwụhuru anwụhu; ọzoo iphe, anụ dzugburu; bẹ a-sa uwe iya asasa; wụa ẹhu; l'ọ bụru onye aasọ nsọ jasụ nchi ejihu; tẹme l'ọ bụru onye a ta sọdu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ọle ọ -bụru l'onye ọbu ta saduru uwe iya; ọphu ọ wụduru ẹhu; bẹ ẹjo-iphe ọbu, o meru tukokwaru iya l'ishi.” ");
INSERT INTO izz_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Waa iphe, ii-pfuru yeru ụnwu Ízurẹlu baa; sụ phẹ-a: Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Unu te emekwa g'eemeje lẹ Ijiputu, bụ iya bụ ẹka ono, unu shi buru ono; tẹme ọphu unu emekwa g'eemeje l'alị Kénanu, bụ alị ẹka ono, mu edu unu ala ono. Unu te etsokwa ẹka phẹ. ");
INSERT INTO izz_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Unu mejekwa iphe, mu tụru l'ekemu; waa iphe, mu tọru ọkpa iya sụ g'e tsoje; kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Unu tsojekwa iphe, mu tọru ọkpa iya sụ g'e tsoje; unu emekwaphọ iphe, mu tụru l'ekemu, bụ iphe, onye meru iya nụ e-gude nọdu ndzụ. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“G'ọ tọ dụkwa onye e-jepfu onye ẹphe l'iya bụ ọkpobe abụbu g'ẹphe l'iya kwaa; kẹle ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Te ejekwa g'unu lẹ ne ngu kwaa; shi nno mee nna ngu iphe-iphere; noo kẹle onye ọbu bụ ne ngu. G'unu lẹ ne ngu ta akwakwaa akwakwa nwoke yẹe nwanyị. ");
INSERT INTO izz_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Te jepfukwa nyee nna ngu; kẹle ọ kwa eme nna ngu iphe-iphere. ");
INSERT INTO izz_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Te jepfukwa onye unu l'iya bụ nwune ọzoo nwanna; m'ọ bụ l'unuphu lanụ bẹ e yeru unu; ọzoo l'e yeru iya l'ibe onye ọzo. ");
INSERT INTO izz_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Te jepfukwa nwanwa ngu; m'ọ bụ nwa ngu nwoke nwụru iya; ọzoo nwa ngu nwanyị nwụru iya; kẹle ono bụkwa eme onwongu iphe-iphere. ");
INSERT INTO izz_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Te jepfukwa nwada nyee nna ngu; mbụ onye e yeru nna ngu; noo kẹle ọ bụ nwanna ngu nwanyị. ");
INSERT INTO izz_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Te jepfukwa nwune nna ngu; noo kẹle ẹphe lẹ nna ngu bụ mee lanụ. ");
INSERT INTO izz_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Te jepfukwa nwune ne ngu; noo kẹle ẹphe lẹ ne ngu bụ mee lanụ. ");
INSERT INTO izz_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Te jepfukwa nyee nwune nna ngu; shi nno mee nwune nna ngu ọbu iphe-iphere, noo kẹle ọo nyee nwune nna ngu. ");
INSERT INTO izz_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Te jepfukwa nyee nwa ngu; kẹle ọo nyee nwa ngu bẹ ọ bụ. Be jepfukwa iya. ");
INSERT INTO izz_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Te jepfukwa nyee nwune ngu; kẹle ọ kwa eme nwune ngu iphe-iphere. ");
INSERT INTO izz_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Te jepfukwa nwanyị; yẹe nwa iya; ọphu i jepfukwa nwanwa nwanyị ono; ọzoo onye ọphu nwa iya nwoke nwụru; ọzoo onye nwa iya nwanyị nwụru; noo kẹle ẹphe l'iya bẹ bụ mee lanụ. Onye eme nno eme ẹjo-ememe. ");
INSERT INTO izz_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Te ejekwa alụta nwune nyee ngu g'ẹphe lẹ nwune iya bya anọdu kpaaha ẹnya l'ibe ngu. Tẹme unu l'iya akwaa akwakwa nwoke yẹe nwanyị l'ẹka nyee ngu nọkwadu ndzụ. ");
INSERT INTO izz_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Te jepfukwa nwanyị teke ọono nsọ; mbụ teke aasọkwadu iya nsọ kẹ nsọ-nwanyị ono, eme iya nụ ono. ");
INSERT INTO izz_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Te jepfukwa nyee nwoke obutobu ngu; shi nno merwua onwongu. ");
INSERT INTO izz_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ta adụkwa ụnwu ngu ọphu ii-kwe g'e gude kpọo ọku gude gwaa agwa ono, bụ Molẹku; mbụ-a; te shikwa ẹgube ono merwua ẹpha Chileke ngu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Te jepfukwa nwoke ibe ngu g'unu l'iya kwaa akwakwa nwoke yẹe nwanyị; kẹle ono bụkwa ẹbyi. ");
INSERT INTO izz_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Te jepfukwa anụ; shi nno merwua onwongu. G'ọ tọ dụkwa nwanyị, a-tọgbo onwiya g'anụ jepfu iya; kẹle ono bụkwa ẹjo ahụma bẹ ọ bụ. ");
INSERT INTO izz_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“G'ọ tọ dụkwa iphe ono mẹ nanụ, unu e-gude merwua onwunu; noo kẹle ọo iphemiphe-a bẹ ọhamoha gude merwushia onwophẹ; mbụ ndu-a, mu abya achịfu l'iphu unu-a. ");
INSERT INTO izz_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Umere phẹ ono woru alị ẹka ono merwushia; mu nụa ndu ẹka ono aphụ; alị ono gbọshia ndu bu iya nụ g'onye gbọru ẹgbo. ");
INSERT INTO izz_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ọle-a; unu tsojekwa iphe, mu tọru ọkpa iya sụ g'e tsoje; waa iphe, mu tụru l'ekemu. Ọphu ọ dụkwa onye e-je eme iphe ono, bụ ahụma ono mẹ nanụ. G'onye a nwụru lẹ Ízurẹlu te emekwa iya; ọphu onye lwarụ alwalwa emekwa iya; ");
INSERT INTO izz_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","kẹle ọo ahụma ahụma ono g'ọ ha bẹ ndu alị-a meru; mbụ ndu ono, vuru unu ụzo bua l'ẹka-a; ẹphe merwushia alị-a. ");
INSERT INTO izz_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ọ kwa k'ọphu alị ono ata agbọshidu unu g'onye gbọru ẹgbo; mẹ unu merwushiẹ ya phọ; ẹgube ono, ọ gbọshiru ọha ono, vu unu ụzo ono. ");
INSERT INTO izz_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Kẹle ọ -dụru onye meru ahụma ahụma ono; bẹ ee-bufukwa onye ono lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Noo g'o gude unu je l'emeje iphe, mu sụru g'e meje; g'ọ tọ dụ ẹjo omelalị ono ọphu unu e-meje, bụ ọphu e shi emeje tẹme unu lwa ono; ọphu unu egude iya merwushia onwunu; kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Waa iphe, ii-pfuru yeru ụnwu Ízurẹlu l'ophu baa; sụ phẹ lẹ-a: Unu dụkwa nsọ; kẹle mbẹdua, bụ Chipfu bya abụru Chileke unu dụkwa nsọ. ");
INSERT INTO izz_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","G'onyenọnu l'ime unu kwabẹjekwa ne iya ẹphe lẹ nna iya ùbvù. Unu edobeje ekemu eswe-atụta-unme mu; kẹle ọ kwa mu bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Unu te jejekwa l'agwa; ọphu unu akpụkwa agwa akpụkpu doberu onwunu; kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Unu -nọdu egweru Chipfu ngwẹja-ẹhu-guu; unu gwejekwa iya l'ụzo, ọo-nata iya unu. ");
INSERT INTO izz_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","G'a tajẹkwa iphe ngwẹja ọbu lẹ mbọku, unu gwerụ iya; ọzoo lẹ nchitabọhu iya. Ọ -bụru l'o dụru ọphu phọduru jasụ lẹ mbọku k'ẹto; g'a kpọo ya ọku. ");
INSERT INTO izz_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ọ -bụkwanuru l'a tarụ iya ilile lẹ mbọku k'ẹto ono bẹ ọ bụakwaa ahụma bẹ e meru; ọphu a taa nataẹkwa iya. ");
INSERT INTO izz_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ọo ya bụ l'onyemonye, bụ onye tarụ iya nụ bẹ ẹjo-iphe, o meru a-tukoru l'ishi; kẹle o merwuru iphe, dụru Chipfu iche. Onye ono bẹ ee-bufukwa lẹ ndu nkiya. ");
INSERT INTO izz_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Unu -nọdu akpata iphe, unu meberu l'ẹgu; unu ta akparwujekwa okoke; ọphu unu atụrutajekwa ọphu nashịhuru ndu akparu iya unu daa l'alị. ");
INSERT INTO izz_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Unu te jejekwa mkpakwa akpụru vayịnu l'opfu-vayịnu unu; ọphu unu atụrutajekwa ọphu dashịhuru l'alị. Unu pajẹru ndu k'ono haarụ ndu ụkpa; waa ndu lwarụ alwalwa; noo kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Unu te ezijekwa iphuru; ọphu unu adzụjekwa ụka; ọphu unu aghọjekwaru nwibe unu ụgho. ");
INSERT INTO izz_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Unu ta akpapyabẹjekwa iphe, unu meru gude ẹpha mu gụa ẹnwa; shi nno merwua ẹpha Chileke unu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Te erijekwa nemadzụ ibe ngu urwu; ọphu ị najẹkwa iya nfụ. G'aswa ozi onye i butaru k'ozi ta akwajẹkwa ngu akwakwa l'ẹka fụta ụtsu. ");
INSERT INTO izz_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Te ephujekwa onye ada nkụchi iphu; ọphu i dochijekwa onye ata aphụdu ụzo iphe l'ụzo. Tsụje Chileke ngu ebvu; noo kẹle ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Unu te ekpejekwa ikpe, apfụduru-ọto. Unu te elejekwa onye ụkpa ẹnya l'iphu haarụ iya enge; kẹle ọ bụ onye ụkpa; ọphu unu akwabẹjekwa onye ha shii ùbvù haarụ iya enge; kẹle ọ bụ onye ha shii. G'ikpe, unu e-kpeje nemadzụ ibe unu bụru ikpe, pfụru ọto. ");
INSERT INTO izz_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Te etsokwaru aghaphe asụphe asụlasu; ọphu ị nọdujekwa lẹ mpfụbe g'e gbua nwibe ngu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Gẹ nwune ngu ta adụjekwa ngu ashị l'ime ọkpoma. Gudeje obu ngu baarụ iya mba g'i ti tsoru keta oke l'ẹjo-iphe, onye ọbu meru. ");
INSERT INTO izz_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Te emelatajẹkwa iphe, ụnwu ndibe unu meru ngu; ọphu ọ dụkwa onye ọphu ii-vujeru aphụ l'obu. Ọ chịa g'i yee nemadzụ ibe ngu obu g'i yeru onwongu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Unu mejekwa iphe, mu tọru ọkpa iya sụ g'e tsoje. G'a ta hajẹkwa anụ-ụlo g'o shia ọphu yẹe ya abụdu ụdu anụ lanụ. Ọphu ị kụjekwa uzi iphe labọ l'opfu ngu; ọphu i yejekwa uwe, abụdu ụdu ẹkwa lanụ bẹ e gude kwaa ya. ");
INSERT INTO izz_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Ọ -dụru onye jepfuru nwamgbọko, a gbaru ohu, e kwetawaru l'ee-ke nwoke ọzo; tẹme ọphu ọ bụdu l'a gbafụtawaru iya g'o nweru onwiya; g'e kpekwaa ya ekpekpe nụkwa ndu ọbu aphụ, rwuberu phẹ nụ. Ọle g'e te egbukwa phẹ egbugbu; noo kẹle nwamgbọko ono bụkwadu ohu. ");
INSERT INTO izz_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","G'onye kẹ nwoke kpụtakwa ebili gude bya anụ l'ọnu-abata ụlo-ẹkwa-ndzukọ; g'e gude gweeru iya ngwẹja-apfụ-ụgwo l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Onye uke egude ebili ono, e gude gwee ngwẹja-apfụ-ụgwo ono pfụa ụgwo iphe-ẹji onye ono l'iphu Chipfu; l'a gụaru iya nvụ l'iphe-ẹji ono, o meru ono. ");
INSERT INTO izz_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Unu -bahụepho l'alị ono; unu bya eyeshia ya oshi-ọmi, dụgbaa iche iche, eeri mebyi iya eriri; unu sọjekwa mebyi iya nsọ. G'a sọkwaa ya nsọ ono apha ẹto; g'e te erikwa iya eriri. ");
INSERT INTO izz_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Teke o beẹrupho l'apha k'ẹno g'e doo akpụru, oshi ono mịtaru nsọ; woru gweeru Chipfu ngwẹja-ekele. ");
INSERT INTO izz_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","O -be l'apha k'ise; unu awatawarọ eri akpụru oshi ọbu. Ọ bụru nno bụ g'ee-shi; iphe, unu meberu l'alị emehuaha; eevu aka shii eje. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Unu ta atajẹkwa anụ, mee dụkwadu. Unu te emejekwa ọmamanshi; ọphu unu emejekwa mgbashị. ");
INSERT INTO izz_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Unu ta akpụfubebejekwa ẹgbushi, nọ unu l'ishi; ọphu unu akpụ-byishijekwa ẹ́jí-agba unu akpụbyishi. ");
INSERT INTO izz_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Unu te eyebatajẹkwa onwunu ọ́nyá l'ẹhu opfu lẹ nemadzụ nwụhuru; ọphu unu ebyikashịjekwa onwunu mbo. Ọ kwa mbẹdua bụ Chipfu ọbu. ");
INSERT INTO izz_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Te emekwa nwada ngu g'ọ bụru nwanyị-ovuọba; shi nno merwua nwa ngu ọbu; a -nọnyakwa; ọ bụru ndu agba ụkpara e-sweta ndu unu; ẹjo-ememe eji alị ono bushihu. ");
INSERT INTO izz_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Unu dobeje ekemu eswe-atụta-unme mu; unu akwabẹje ụlo mu ono, dụ nsọ ono ùbvù; kẹle ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Unu te ejejekwa ajị maa l'ibe ndu aphụ ọphulenya; ọzoo ndu jibya; noo kẹle ẹphe e-merwu unu. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Gbẹshijekwaru ndu-ishi-ẹwó l'oshi. Kwabẹje ndu bụ ọgerenya ùbvù; l'ị tsụje Chileke ebvu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Ọ -dụru onye lwarụ alwalwa l'alị unu; unu te emekpakwa iya ẹhu. ");
INSERT INTO izz_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","G'e mejekwa onye lwarụ alwalwa, bu l'alị unu g'eemeje onye a nwụru lẹ Ízurẹlu. Unu yekwaa onye ono obu g'unu yeru onwunu; noo kẹle unubẹdua shikwaphọ bụru ndu lwarụ alwalwa l'alị Ijiputu. Ọ kwa mbẹdua bụ Chipfu bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Unu -nọdu atụ ogologo iphe; ọzoo ẹrwa iphe; ọzoo g'iphe habe l'igwerigwe; unu te emejekwa iya l'ụzo, apfụduru-ọto. ");
INSERT INTO izz_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Unu gudejekwa iphe, darwuru nụ gude mee ya; mbụ iphe, e gude atụ̀ ẹrwa iphe ọphu bụ ọkpobe iya; yẹe ọkpobe nkwẹka; yẹe ọkpobe ekpemu bẹ bụgbaa iphe, unu e-gudeje tụ̀a iphe. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu; onye dufutaru unu l'alị Ijiputu. ");
INSERT INTO izz_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ọo ya bụ lẹ-a; unu tsokọtaje iphe, bụkpoo iphe, mu tọru ọkpa iya sụ g'e tsoje; waa iphe, mu tụru l'ekemu g'ọ ha. Unu meje iya nno; noo kẹle ọ kwa mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Waa iphe, ii-pfuru yeru ụnwu Ízurẹlu baa: Iphe, bụkpoo onye Ízurẹlu; ọzoo onye lwarụ alwalwa bya eburu lẹ Ízurẹlu, kpụtaru nwa iya je anụ Molẹku; g'e gbukwa onye ono egbugbu. Gẹ mkpụkpu ono l'ophu wụfutakwa je atugbua ya lẹ mkpuma. ");
INSERT INTO izz_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mbẹdua l'onwomu a-gbanwụberu onye ono iphu mu; bufu iya lẹ ndu nkiya; kẹle o gude nwa iya gwaa Molẹku; shi nno merwua ụlo mu ono, dụ nsọ ono; bya arwụtoshia ẹpha mu ono, dụ nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ọ -bụru lẹ ndu mkpụkpu ono hụmaru onye kpụtaru nwa iya je anụ Molẹku; ẹphe nyịa nchị manụ; ọphu ẹphe egbuduru onye ọbu; ");
INSERT INTO izz_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","bẹ mu a-gbanwụbekwaru onye ọbu iphu mu; yẹe ndibe iya; bufu phẹ lẹ ndu nkephẹ; mẹkpoo iphe, bụ ndu ono, yẹe ya eshiswe ụzo; jeru; ẹphe lẹ Molẹku nọdu eri ogori ono. ");
INSERT INTO izz_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Onye ejeje ajị maa l'ibe ndu jibya; shi nno dụ ghẹlegheleghele; bẹ mu a-gbanwụbekwa iphu; bufu iya lẹ ndu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Unu dobekwa onwunu iche; unu adụ nsọ; noo kẹle ọo mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Unu dobe iphe, mu tọru ọkpa iya sụ g'e tsoje; meje iya ememe; kẹle ọo mbẹdua bụ Chipfu, emeje unu g'unu dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Onye phuru nna iya; ọzoo ne iya iphu; g'e gbukwaa onye ọbu egbugbu; kẹle ọo nna iya; ọzoo ne iya bẹ o phuru iphu; gẹ mee ya tụ-kokwaru iya l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Ọ -bụru lẹ nwoke jepfuru nyee nwoke ibe iya; ẹphe shi nno ria ogori; g'e gbukwaa nwoke ọbu yẹe nwanyị ọbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ọzo bụ l'onye jepfuru nyee nna iya bụkwa nna iya bẹ o meru iphe-iphere. G'e gbukwaa ẹphenebo egbugbu; ishi ọchi phẹ atụ-koru phẹ l'ishi; mbụ ndu ono, e gburu ono. ");
INSERT INTO izz_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Onye -jepfuru nyee nwa iya; g'a tụko ẹphenebo gbua; noo kẹle iphe, ẹphe meru bụ akpamara. Ishi ọchi phẹ bụkwa onwophẹ bẹ ọ tụ-koru l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ọ -bụru lẹ nwoke jepfuru nwoke ibe iya; ẹphe l'iya kwaa akwakwa nwoke yẹe nwanyị; bẹ ẹphenebo mekwarụ ẹbyi. G'e gbukwaa ẹphenebo egbugbu. Ishi ọchi onwophẹ bụkwa ẹphebedua bẹ ọ tụ-koru l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Onye jeru alụta nwanyị; bya emechaa je alụtafua ne nyee ya ono mekwarụ ẹjo-ememe. G'a kpụtakwaa nwoke ono; yẹe ụnwanyi labọ phọ je akpọo ọku. Ọo ya bụ; g'ẹjo-ememe, dụ ẹgube ono ta adụ l'echilabọ unu. ");
INSERT INTO izz_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Teke ọ bụ lẹ nwoke jepfuru anụ; g'e gbukwaa ya egbugbu; gbukwaphọ anụ ọbu. ");
INSERT INTO izz_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ọ -bụru lẹ nwanyị tọgboru onwiya g'anụ jepfu iya; g'e gbukwaa nwanyị ọbu yẹe anụ ọbu. Ishi ọchi onwophẹ atụ-koru phẹ l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Teke ọ bụ lẹ nwoke lụtaru nwune iya; ọzoo nwanna iya; o -jepfu iya; bẹ ọ bụkwa iphe-iphere. G'a nọdukwa l'edzudzu-ọha ndu nkephẹ bufu phẹ ebufu. Ọ kwa nwune iya bẹ o meru iphe-iphere. Iphe, o meru tụ-koru iya l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Onye jepfuru nwanyị teke ọono nsọ bẹ bvuakwaru ẹnu-mee nwanyị ono; mbụ lẹ yẹbe nwanyị kpuhawarụ ẹnu-mee ya ghebe ọnu. Ọo ya bụ; g'a tụkokwa ẹphenebo bufu ebufu lẹ ndu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Te jepfukwa nwune ne ngu; ọzoo nwune nna ngu; kẹle onye meru nno bụ onye yẹle iya bụ mee lanụ bẹ o meru iphe-iphere. Iphe, unu meru a-tụ-kokwaru unu l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Onye jepfuru nyee nwune nna iya; ọzoo nyee nwune ne iya; bẹ bụkwa nwune nna iya ono; ọzoo nwune ne iya ono bẹ o meru iphe-iphere. G'iphe, ẹphe meru tụ-kokwaru phẹ l'ishi. Ẹphenebo ta abyadụ atọgbo akọ lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Onye tụgburu je alụta nyee nwune iya bẹ mekwarụ iphe, aasọ nsọ; bya emee nwune iya ọbu iphe-iphere. Ẹphe ta abyadụ atọgbo akọ lẹ mgboko. ");
INSERT INTO izz_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Ọo ya bụ lẹ-a; unu tsoje iphe, mu tọru ọkpa iya sụ g'e tsoje g'ọ ha; waa iphe, mu tụru l'ekemu. Unu meje iya ememe; k'ọphu alị ono, mu edu unu ala ono ata agbọdu unu g'onye gbọru ẹgbo. ");
INSERT INTO izz_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Unu te emejekwa iphe, ẹphe emeje; mbụ ọha ono, mu abya achịfu l'iphu unu ono; noo kẹle ọ kwa iphemiphe ono, ẹphe meru ono meru g'o gude mu sọo phẹ oyi. ");
INSERT INTO izz_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mbụ lẹ mu sụru unu-a: Ọ kwa unu e-nworu alị phẹ; mbụ lẹ mu a-nụ iya unu g'ọ bụru okiphe unu; mbụ alị ono, mini ẹra-eswi waa manụ-ẹnwu asọ gborogboro ono. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu, bụ onye họfutaru unu l'echilabọ ndiphe. ");
INSERT INTO izz_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ọo ya bụ; unu mejekwa iya g'o doo ẹnya; mbụ ọdu-iche, dụ l'anụ, aasọ nsọ; yẹe anụ, a ta sọdu nsọ; yẹe ọdu-iche, dụ l'ẹnu, a ta sọdu nsọ; yẹe ẹnu, aasọ nsọ. Unu te egudekwa anụ; ọzoo ẹnu; mẹwaro iphe, awụ l'ẹpho merwua onwunu; mbụ anụ ono; waa ẹnu; mẹwaro iphe ọzo ono, mu gụshiru unu sụ g'unu sọje nsọ ono. ");
INSERT INTO izz_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Unu dụkwaru mu nsọ; noo kẹle mbẹdua, bụ Chipfu dụ nsọ; tẹme mu họfutawa unu l'echilabọ ndiphe g'unu bụru nkemu. ");
INSERT INTO izz_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Nwoke; ọzoo nwanyị, ajị maa; ọzoo onye jibya g'e gbukwaa onye ọbu. G'e gude mkpuma tugbua onye ọ bụ. Ishi ọchi onwiya atụ-koru iya l'ishi.” ");
INSERT INTO izz_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Tọbudu iya bụ; Chipfu bya asụ Mósisu: “Waa iphe, ii-pfuru ndu-uke baa; mbụ ụnwu Erọnu. Sụ phẹ g'ọ tọ dụkwa onye ọphu e-gudeje k'onye nwụhuru anwụhu l'ibe phẹ mee onwiya onye aasọ nsọ; ");
INSERT INTO izz_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","gbahaẹpho l'onye ọbu nwụhuru nụ ọbu bẹ ẹphe l'onye uke ọbu bụ mee lanụ; mbụ l'ọo ne iya; ọzoo nna iya; ọzoo nwa iya nwoke; ọzoo nwa iya nwanyị; ọzoo nwune iya nwoke; ");
INSERT INTO izz_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ọzoo nwune iya nwanyị, eteke alụdu ji; ọ bụru iya bẹ ọ nọ l'ẹka opfu l'ọ tọ lụdu ji; odzu ẹgube onye ono gbakwarụ g'o gude iya mee onwiya onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","G'o to mekwa onwiya onye aasọ nsọ l'ẹka ọ bụ onye-ishi l'echilabọ ndibe phẹ; mbụ shi nno merwua onwiya. ");
INSERT INTO izz_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“G'ẹphe ta akpụshijekwa ishi; ọphu ẹphe akpụ-byishijekwa agụga agụga ẹ́jí-agba phẹ; ọphu ẹphe ebyijekwa mbo l'ẹhu ebyibyi ophu. ");
INSERT INTO izz_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","G'ẹphe dụkwaru Chileke phẹ nsọ; g'ẹphe ta tụrwu ẹpha Chileke phẹ ono; kẹle ngwẹja ono, aakpọje ọku nụ Chipfu ono; mbụ nri ono, aanụje Chileke phẹ ono bẹ bụ phẹ agwajẹ iya. Ọo ya bụ lẹ-a; g'ẹphe bụkwaru ndu dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","G'ẹphe ta lụjekwa nwanyị, gude agba ụkpara merwushiwa onwiya; ọphu ẹphe alụjekwa nwanyị, ji iya chịfuru; noo kẹle onye uke dụru Chileke iya nsọ. ");
INSERT INTO izz_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Unu meje onye uke g'ọ bụru onye dụ nsọ; kẹle ọo yẹbedua l'agwarụ unu Chileke. G'ọ bụkwaru onye dụru unu nsọ; kẹle mbẹdua, bụ Chipfu, bụ onye meru g'unu dụ nsọ bụkwa onye dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ọ -bụru lẹ nwada onye uke watarụ agba ụkpara shi nno merwua onwiya bụakwaa nna iya bẹ o merwuru. G'a kpọkwaa nwamgbọko ono ọku. ");
INSERT INTO izz_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“G'onye bụ onye-ishi uke l'echilabọ unwune iya; mbụ onye ono, a wụru manụ l'ishi; bya abụru onye e meru g'o yeje uwe ndu-uke; g'onye ono ta ahajẹkwa ẹgbushi iya g'ọ dụ yagalayagalayagala; ọphu ọ lakajẹkwa uwe iya alaka. ");
INSERT INTO izz_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","G'onye ono ta abahụjekwa l'ẹka odzu zẹ. G'ọ tọ dụkwa m'obetaru ọ bụru nna iya ọzoo ne iya nwụhuru; l'ọ bahụ ẹka ono je eme onwiya onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","G'ọ tọ lụfujekwa alụfu l'ụlo, dụ nsọ kẹ Chileke; ọphu o merwukwa ụlo ọbu; noo kẹle ọo manụ Chileke iya bẹ a wụru iya l'ishi. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Gẹ nwanyị, ọo-lụ bụru nwanyị, adụdu nwoke jepfujeru iya nụ. ");
INSERT INTO izz_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","G'ọ tọ lụkwa nwanyị, ji iya ta anọedu; ọphu ọ lụkwa nwanyị, a chịfuru achịfu; ọzoo nwanyị, agba ụkpara; shi nno merwua onwiya. Gẹ nwanyị, ọo-lụ bụkwaru onye adụdu nwoke, jepfujeru iya nụ; tẹme ọ bụkwarupho onye Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ọo ya bụ; g'o to shi nno mee oshilọkpa iya g'ẹphe bụru ndu ndibe phẹ asọ nsọ. Ọ kwa mbẹdua, bụ Chipfu bụ onye meru iya; ọ dụ nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Waa iphe, ii-pfuru Erọnu baa; sụ iya: Iphe, bụkpoo onye bụ oshilọkpa ngu; e -shi l'ọgbo sweru ọgbo, bụ onye nweru ẹka iphe mebyiru iya; g'ọ tọ byajẹkwa g'ọ nụ Chileke iya nri. ");
INSERT INTO izz_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","G'iphe, bụ onye nweru ẹka iphe mebyiru iya ta abyakubejekwa Chileke ntse; mbụ onye atsụ ishi; ọzoo onye bụ ẹniyeni; ọzoo onye iphe mebyiru ẹka ọzo; ");
INSERT INTO izz_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ọzoo onye iphe lọnwuru ọkpa lanụ; ọzoo ẹka lanụ; ");
INSERT INTO izz_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ọzoo onye okwebe kweberu; ọzoo onye chịkpirihuru achịkpirihu; ọzoo onye iphe eme l'ẹnya; ọzoo onye iphe eme l'akpọ-ẹhu; ọzoo onye a hárụ aháhá. ");
INSERT INTO izz_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","G'ọ tọ dụkwa oshilọkpa Erọnu, bụ onye uke, dụru ẹka iphe mebyiru iya, a-byajẹ ntse k'abya egweru Chipfu ngwẹja, aakpọ ọku. Eshinu ọ dụru ẹka iphe mebyiru iya g'ọ tọ kpịritakwaru ntse k'anụ Chileke iya nri. ");
INSERT INTO izz_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","G'o rijekwarọ nri, a nụru Chileke iya; mbụ ọphu dụ nsọ; mẹ ọphu dụ nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ọle eshinu ọ dụru ẹka iphe mebyiru iya g'o to jekubejekwa mgboru ẹkwa, e gude kobuta ẹka-kakọta-adụ-nsọ; ọphu oojekubejekwa ọru-ngwẹja; g'o to shi nno merwua ụlo mu ono, dụ nsọ ono; kẹle ọ kwa mbẹdua bụ Chipfu, bụ onye meru phẹ; ẹphe dụ nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Tọbudu iya bụ; Mósisu bya eworu iphemiphe ono kọkotaru Erọnu; waa ụnwu iya; yẹe ndu Ízurẹlu g'ẹphe hakọta. ");
INSERT INTO izz_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Pfuaru Erọnu yẹe ụnwu iya g'ẹphe kwabẹjekwaru iya ẹnya; mbụ iphe ono, ndu Ízurẹlu doberu mu nsọ; g'ẹphe te egude iphe ono merwua ẹpha mu ono, dụ nsọ; kẹle ọ kwa mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","L'ị sụ phẹ-a: “Iphe, bụ onye bụ oshilọkpa unu; e -shi l'ọgbo sweru ọgbo, bụ onye aasọ nsọ, byakuberu iphe, ndu Ízurẹlu doberu mụbe Chipfu nsọ; g'e bufukwa onye ono l'atatiphu mu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ọ -bụru l'o nweru oshilọkpa Erọnu, iphe, eswe nswe eme l'akpọ-ẹhu; ọzoo l'iphe alwashị iya l'ẹhu; g'onye ono te erikwa iphe, dụ nsọ; jasụ teke ọo-dụ iche l'iphe ọbu, eme iya nụ ọbu; bụru onye a taa sọhedu nsọ. Teke ọ bụkwanu l'o nweru onye denyiru iphe, aasọ nsọ ẹka; dụ gẹ l'o meru odzu ẹka; ọzoo nwoke, gbọru ụnwuda; ");
INSERT INTO izz_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ọzoo l'onye ono denyiru iphe, awụ l'ẹpho ẹka bụ iphe, ee-me iya g'ọ bụru onye aasọ nsọ; ọzoo l'o denyiru onye aasọ nsọ ẹka; ọzoo l'ọ dụru iphe ọzo, meru iya; ọ bụru onye aasọ nsọ; bẹ ọ bụakwaa onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Onye denyiru iphe, dụ nno ẹka a-bụru onye aasọ nsọ jasụ nchi ejihu. G'ọ tọ dụkwa iphe, e doberu nsọ, oo-ri; gbahaa l'o gude mini wụa onwiya ẹhu. ");
INSERT INTO izz_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ẹnyanwu -nyịhuepho; bẹ a taa sọhedu onye ọbu nsọ. A -gbẹ teke ono bẹ onye ono a-watawarọ eri iphe, e doberu nsọ; noo kẹle ọo nri iya bụ ono. ");
INSERT INTO izz_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","G'o to rijekwa iphe, nwụhuru anwụhu; ọzoo iphe, anụ-ẹgbudu dzugburu; g'o to shi nno merwua onwiya. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Gẹ ndu-uke mejekwa iphe, mu sụru g'ẹphe meje. Ọ -bụru l'ẹphe te emedu iya; ẹphe emeta iphe-ẹji kpua onwophẹ; tẹme l'o gbukwaa phẹ phọ. Ọ kwa mbẹdua bụ Chipfu, bụ onye meru phẹ; ẹphe dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“G'o tọ dụkwa onye abụdu eri ndu-uke, e-rije iphe, e doberu nsọ. G'onye byaru onye uke ẹbyaa; ọzoo onye o butaru ebuta ozi te erijekwa iphe, dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ọle ọ -bụru l'onye uke gude okpoga iya gbata ohu; ọzoo l'a nwụru iya ohu l'unuphu; gẹ ndu k'ono rijekwa nri ono. ");
INSERT INTO izz_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nwada onye uke -je alụru onye abụdu onye uke; g'onye ọbu te erijeẹkwa iphe ono, dụ nsọ ono, aanụje ndu-uke ono. ");
INSERT INTO izz_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Obenu teke ọ bụ lẹ nwada onye uke bẹ teke anwụtadu nwa; ji iya nwụhu; ọzoo l'a chịfuru iya achịfu; ọ laa ibe nna iya; g'o rijekwa nri ono, bụ nri nna iya ono; g'o shi erije iya teke ọ bụ nwata. Ọle ọ bụ; g'onye abụdu onye oshilọkpa ndu-uke te erikwa iya. ");
INSERT INTO izz_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Onye riru iphe, e doberu nsọ l'amagama; g'onye ono pfụkwaa onye uke ụgwo iya. Ọ -pfụchaa ụgwo iya l'o wota iphe ono ọzo, ha nno; kee ụzo ise woru oke lanụ tukobe l'ono, o gude apfụ ụgwo iya ono. ");
INSERT INTO izz_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Gẹ ndu-uke te emerwụkwa iphe ono, dụ nsọ ono, shi l'ẹka ndu Ízurẹlu ono, bụ ọphu ẹphe nụru Chipfu; ");
INSERT INTO izz_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","shi ẹgube ono mee g'ẹphe bụru ndu ẹjo-iphe tukoru l'ishi; tẹme ẹphe abụru ndu-ikpe nmarụ; kẹle ẹphe riru iphe ono, ẹphe doberu nsọ ono; kẹle ọ kwa mbẹdua bụ Chipfu, bụ onye meru phẹ; ẹphe dụ nsọ.” ");
INSERT INTO izz_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Waa iphe, ii-pfuru Erọnu; yẹe ụnwu iya; yẹe ndu Ízurẹlu l'ophu baa; sụ phẹ-a: Ọ -dụru onye bụ onye Ízurẹlu gẹdegede; ọzoo onye lwarụ alwalwa, bu lẹ Ízurẹlu, gude iphe abya g'e gude iya gweeru Chipfu ngwẹja-akpọ-ọku k'iphe, o kweru ukwe lẹ ya e-me; ọzoo iphe, ọ tụru obu iya onyo anụ; ");
INSERT INTO izz_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","g'onye ono kpụtakwa anụ, bụ okee ya, adụdu ẹka iphe mebyiru iya bya. Iphe, oo-gude bya bụ oke-eswi; ọzoo ebili; ọzoo mkpi; k'ọphu aa-nafụkwanu iya unu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Unu te wotakwa iphe, nweru ẹka iphe mebyiru iya gude bya egwee ngwẹja ọbu; kẹle a taa natakwa iya unu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Onye kpụtaru eswi; ọzoo atụru; ọzoo eghu gude abya egweru Chipfu ngwẹja-ẹhu-guu; shi nno emekọta iphe, o kweru ukwe iya; ọzoo g'ọ bụru iphe, ọ tụru obu iya onyo anụ; g'onye ono wotakwa anụ, adụdu ẹka iphe mebyiru iya; k'ọphu aa-natakwanụ iya ya l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","“Unu ba anụjekwa Chipfu anụ, atsụ ishi; ọzoo ọphu e mekarụ iphe; ọzoo ọphu iphe mebyiru ibe lanụ; ọzoo ọphu iphe alwashị l'ẹhu; ọzoo ọphu iphe eme l'akpọ-ẹhu. Unu te egudekwa anụ, dụ ẹgube ono je akpọru Chipfu ọku l'eli ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ọ -bụru ngwẹja, a tụru obu onyo anụ; g'onye egwe iya nụ nụjekwaro eswi; ọzoo atụru, nweru ẹka iphe mebyiru iya; aa-nafụ iya ya-a l'ẹka. Ọle ọ -bụru ọphu onye ono gude emekọta iphe, o kweru ukwe iya bẹ a taa nafụkwa iya ya l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Unu ta nụjekwa Chipfu anụ, e mekarụ iphe l'akpụru-anwụ; ọzoo ọphu e tsupyaru nkiya etsupya; ọzoo ọphu iphe lajaru nkiya; m'ọ bụ ọphu e bufuru nkiya ebufu. Unu te emejekwa iphe, dụ ẹgube ono l'alị unu-a. ");
INSERT INTO izz_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Unu ta nụjekwa anụ, shi l'ẹka onye ọhozo; g'ọ bụru nri, unu anụ Chileke unu. Eshinu ẹgube anụ ono dụ g'anụ, nweru ẹka iphe mebyiru iya bẹ a taa nafụkwa iya unu l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Nwa eswi, a nwụru k'ọ̀phúú; ọzoo atụru; ọzoo eghu bẹ aa-hajẹkwa gẹ yẹle ne iya nọadaa ujiku ẹsaa. A -gbẹ lẹ mbọku, kwe anụ ono ujiku ẹsato tụgbua; bẹ a -kpụta iya bya anụ g'e gude gweeru Chipfu ngwẹja, aakpọ ọku bẹ aa-natakwa iya-a. ");
INSERT INTO izz_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Unu ta tụkojekwa ne-eswi yẹe nwa iya; m'ọ bụ atụru yẹe nwa iya gbua ujiku lanụ. ");
INSERT INTO izz_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Unu -nọdu egweru Chipfu ngwẹja-ekele; unu mejekwa iya l'ụzo, dụ ree; k'ọphu aa-nata iya unu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","G'a tụkokwa anụ, e gude gwee ngwẹja ọbu takọta mbọku ono; g'ọ tọ dụkwa ọphu aa-ha g'ọ nọo fụta ụtsu. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ọo ya bụ lẹ-a; unu dobekwa ekemu mu; unu emeje iya ememe. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ọphu unu emerwụkwa ẹpha mu ono, dụ nsọ ono; ọ chịkwa gẹ ndu Ízurẹlu dobe ẹpha mu iche l'echilabọ phẹ; kẹle ọ kwa mbẹdua bụ Chipfu, bụ onye meru; unu dụ nsọ; ");
INSERT INTO izz_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","bya abụru onye dufutaru unu l'alị Ijiputu gẹ mu bụru Chileke unu. Ọ kwa mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Tọbudu iya bụ; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Wakwa iphe, ii-pfuru ndu Ízurẹlu baa; sụ phẹ-a: Wakwa ọbo-iphe, mụbe Chipfu doberu baa; mbụ ọbo-iphe, unu a-ra arara l'ọo ya bẹ a-bụru ndzukọ ọphu dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ọo ujiku ishii bẹ unu e-jeje ozi; mbọku k'ẹsaa a-bụru eswe Sabatụ, bụ eswe-atụta-unme. Mbọku ono a-bụru eswe ndzukọ ọphu dụ nsọ. Unu te jejekwa ozi mbọku ono; kẹle ọ bụ eswe-atụta-unme kẹ Chipfu l'ẹkameka unu bukpọ. ");
INSERT INTO izz_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ọwaa bụ ọbo-iphe, Chipfu doberu; mbụ ndzukọ, dụ nsọ, unu e-dzukọbeje m'o -rwua teke e doberu iya.” ");
INSERT INTO izz_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Ọbo Ojeghata Chipfu bụ mbọku, aa-bọje iya bụ mbọku, ọnwa mbụ dụ l'abalị iri l'ẹno l'ụzenyashi. ");
INSERT INTO izz_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","O -be lẹ mbọku k'iri l'ise l'ọnwa ono kwaphọ; bẹ unu a-bọjeru Chipfu Ọbo-Buredi, ekoduru ekoko. Ujiku ẹsaa bẹ unu a-ta buredi, e yedụru iphe, ekoje buredi. ");
INSERT INTO izz_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mbọku mbụ k'ọbo-iphe ono bẹ unu e-nweru ndzukọ, dụ nsọ; g'ọ tọ dụkwa ozi, unu e-je mbọku ono. ");
INSERT INTO izz_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ujiku ẹsaa bẹ unu a-nọduepho egweru Chipfu ngwẹja, aakpọ ọku. Teke o rwuẹrupho lẹ mbọku k'ẹsaa; unu enweru ndzukọ, dụ nsọ; g'ọ tọ dụkwa ozi, unu e-je mbọku ono.” ");
INSERT INTO izz_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Wakwa iphe, ii-pfuru ndu Ízurẹlu baa; sụ phẹ-a: Unu -bahụepho l'alị ono, mu abya anụ unu ono; teke unu kpatarụ iphe, e meberu l'alị ono; unu ewota upfu lanụ l'iphe mbụ, unu e-vuru ụzo kpata je anụ onye uke. ");
INSERT INTO izz_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","G'onye uke ono wota upfu iphe ono maa l'iphu Chipfu. Ọo ya bụ gẹ Chileke anata iya unu l'ẹka. Ọ bụru lẹ nchitabọhu iya; mẹ eswe-atụta-unme -bvụepho bẹ ọo-ma iya ọbu. ");
INSERT INTO izz_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Mbọku ono, unu a-ma upfu iphe ono l'iphu Chipfu ono bẹ unu e-gudekwaphọ nwa ebili, nọwaru apha lanụ, adụdu ẹka iphe mebyiru iya; bya egwee ngwẹja-akpọ-ọku nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ngwẹja-nri, a-yịkwaru iya phọ a-bụru ukpokutu ereshi, a gwọru lẹ manụ, jiru nkwẹka e keru ụzo iri wota uzi labọ, ee-gude gweeru Chipfu ngwẹja, aakpọ ọku, mkpọ iya dụ ree; tẹme l'e yekọbekwa iya phọ mẹe, jiru nkeru-ẹno ọtu-lupfu otumu g'ọ bụru ngwẹja-mẹe. ");
INSERT INTO izz_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ọphu unu adụkwa buredi, unu a-ta; ọphu unu atakwa ereshi, a hụru ahụhu; ọphu unu atakwa ọphu dụ oyii; gbiriri jasụ mbọku ono, unu e-wotaru Chileke unu ngwẹja ono. Ono a-bụru iphe, mu tọru ọkpa iya sụ g'e tsoje jasụ l'ojejoje; mbụ l'oo-shije l'ọgbo sweru ọgbo l'ẹkameka unu bụ.” ");
INSERT INTO izz_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“O -be lẹ nchitabọhu mbọku ono, unu byaru egude upfu iphe gwee ngwẹja-amama ono; mẹ eswe-atụta-unme bvụchaepho; unu agbẹ mbọku ono nọ-dzua idzu ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Teke a nọ-dzuẹrupho ụkporo abalị labọ l'abalị iri; o -rwua lẹ nchitabọhu eswe-atụta-unme k'ẹsaa; unu abyakwa egweeru Chipfu ngwẹja-nri, unu e-gude ereshi ọ̀phúú gwee. ");
INSERT INTO izz_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Unu gbẹ l'ẹka unu bu wota ishi buredi ẹbo, e gheru l'ukpokutu ereshi, jiru nkwẹka e keru ụzo iri wota uzi labọ, e yeru iphe, ekoje buredi; bya anụ g'e gude gwee ngwẹja-amama g'ọ bụru akpụru-iphe-mbụ, a nụru Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Iphe, unu e-wotafụa yekọberu ishi buredi ono bụ ụnwu ebili ẹsaa, nọkotaru mgbarapha; tẹme ọ bụru ọphu adụdu ẹka iphe mebyiru iya; waa nwa oke-eswi lanụ; waa ebili labọ. G'e gude anụ ono g'ọ ha; waa ngwẹja-nri, etso iya nụ; yẹe ngwẹja-mẹe, etso iya nụ; gwee ngwẹja-akpọ-ọku nụ Chipfu; mbụ ngwẹja, aakpọ ọku, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ọo ya bụ; unu abya akpụta mkpi lanụ gude gwee ngwẹja-iphe-ẹji; bya akpụta ụnwu ebili labọ, nọgbaaru mgbarapha gude gwee ngwẹja-ẹhu-guu. ");
INSERT INTO izz_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","G'onye uke ono woru ụnwu ebili labọ ono; waa buredi ono, e meru l'akpụru-iphe-mbụ, a kpatarụ l'opfu ono maa l'iphu Chipfu g'ọ bụru ngwẹja-amama. Iphe ngwẹja ono bụkota ngwẹja, dụ nsọ kẹ Chipfu; ọ bụru onye uke bụ onye e-ri iya nụ. ");
INSERT INTO izz_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mbọku ono kwaphọ bẹ unu e-nweru ndzukọ, dụ nsọ. Unu ta adụkwa ozi, unu e-je mbọku ono l'ophu. Ono a-bụru iphe, a tọru ọkpa iya sụ g'e tsoje jasụ l'ojejoje; mbụ l'oo-shije l'ọgbo sweru ọgbo; unu emeje iya l'ẹkameka unu bukpọ. ");
INSERT INTO izz_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Unu -nọdu akpata iphe, unu meberu l'ẹgu; unu ta akparwujekwa okoke; ọphu unu atụrutajekwa ọphu nashịhuru ndu akparu iya unu daa l'alị. Unu hajẹru ndu ụkpa; yẹe ndu lwarụ alwalwa ọphu daru l'alị. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Wakwa iphe, ii-pfuru yeru ụnwu Ízurẹlu baa; sụ phẹ-a: “Iphe, bụkpoo mbọku mbụ l'ọnwa k'ẹsaa bụkwa unu eswe-atụta-unme; mbụ mbọku, unu a-nọje ndzukọ, dụ nsọ. O -be mbọku ono g'e gbua opu gude karụ onyemonye. ");
INSERT INTO izz_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Unu ta adụkwa ozi, unu e-je mbọku ono l'ophu; iphe, unu e-mejechia bụ l'unu a-nụje Chipfu ngwẹja, aakpọ ọku.” ");
INSERT INTO izz_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Mbọku, ọnwa ẹsaa ono dụ l'abalị iri l'a-bụjeru unu eswe apfụ ụgwo iphe-ẹji. Mbọku ono bẹ unu a-nọje ndzukọ, dụ nsọ; unu a-swị ẹgu; gwee ngwẹja, aakpọ ọku anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Unu ta adụkwa ozi, unu e-je mbọku ono; noo kẹle mbọku ono bụ eswe apfụ ụgwo iphe-ẹji; mbụ mbọku, aa-nọdu l'iphu Chipfu, bụ Chileke unu pfụa ụgwo iphe-ẹji, unu meru. ");
INSERT INTO izz_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Kẹle onyemonye, ta aswịdu ẹgu mbọku ono bẹ ee-bufukwa ebufu lẹ ndu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Teke ọ dụru onye jeru ozi mbọku ono; mu e-me onye ono g'ọ chịhu l'echilabọ ndu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","G'ọ tọ dụkwa ozi g'ọ dụhabe, unu e-je. Ono a-bụru iphe, a tọru ọkpa iya sụ g'e tsoje jasụ l'ojejoje; mbụ l'oo-shije l'ọgbo sweru ọgbo. Unu emeje iya l'ẹkameka unu bu. ");
INSERT INTO izz_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mbọku ono a-bụru unu eswe-atụta-unme. Unu aswịa ẹgu mbọku ono. Unu e-shije l'ụzenyashi mbọku, ọnwa dụ l'abalị tete tụta unme jasụ l'ụzenyashi kẹ mbọku, ọnwa a-dụ l'abalị iri.” ");
INSERT INTO izz_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Wakwa iphe, ii-pfuru yeru ụnwu Ízurẹlu baa; sụ phẹ-a: Teke ọnwa ẹsaa ono dụepho l'abalị iri l'ise g'a bọo Ọbo-M̀kpù kẹ Chipfu. Iphe, aa-bọru iya Chipfu bụ ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mbọku mbụ bẹ unu e-nweru ndzukọ, dụ nsọ; g'ọ tọ dụkwa ozi, unu e-je mbọku ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ujiku ẹsaa ono bẹ unu a-nụje Chipfu ngwẹja, aakpọ ọku. O -be lẹ mbọku k'ẹsato; unu anọje ndzukọ, dụ nsọ; bya anụkwapho Chipfu ngwẹja, aakpọ ọku. Ndzukọ ono bụkwa ndzukọ, dụ nsọ; ọo ya bụ g'ọ tọ dụkwa ozi, unu e-je mbọku ono l'ophu.” ");
INSERT INTO izz_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Ono bụ ọbo-iphe, Chipfu doberu; mbụ ọphu unu a-ra arara g'ọ bụru ndzukọ, dụ nsọ. G'a nụ Chipfu ngwẹja, aakpọ ọku, bụ iya bụ ngwẹja-akpọ-ọku; yẹe ngwẹja-nri; waa ngwẹja-mẹe; mẹwaro ngwẹja ọzo. Iphe, bụ ngwẹja ono bẹ aa-nọdujeepho egwe lẹ mbọku, gbaru iya nụ. ");
INSERT INTO izz_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","A gụfukpokwaru ngwẹja k'eswe-atụta-unme; bya agụfu iphe, unu anụje Chipfu anụnu; gụfu l'onye-a apfụ iphe, o kweru ukwe iya; gụfu iphe-anụnu ọphu unu tụru obu unu onyo anụ, bụ ọphu unu anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“O -rwua mbọku, ọnwa ẹsaa dụepho l'abalị iri l'ise; m'unu kpatachaẹpho iphe, unu meberu l'alị; unu abọoru Chipfu ọbo-iphe ujiku ẹsaa. Mbọku abahụ iya bẹ unu a-tụta unme ozi; unu atụtakwapho unme lẹ mbọku k'ẹsato. ");
INSERT INTO izz_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Mbọku mbụ l'ọbo-iphe ono bẹ unu a-hata akpụru oshi, kachaa ree l'akpụru oshi, unu wọtaru; unu egbuta igu; mẹ ẹkali-oshi, ẹkwo dụ shii; waa ẹkali-oshi wilo. Unu gweta iphe ono gude je anọdu l'iphu Chipfu, bụ Chileke unu tee ẹswa ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Unu bọjekwaru Chipfu ọbo-iphe ono ujiku ẹsaa ono aphagapha. Ono bụ iphe, a tọru ọkpa iya sụ g'e tsoje jasụ l'ojejoje; mbụ l'oo-shije l'ọgbo sweru ọgbo. Ọnwa, aa-bọje iya bụ l'ọnwa ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ọ bụru lẹ m̀kpù bẹ unu e-buru abalị ẹsaa ono; mbụ l'iphe, bụkpoo ndu a nwụru lẹ Ízurẹlu e-bukọtaru lẹ m̀kpù teke ono. ");
INSERT INTO izz_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ọo ya bụ; g'ọgbo l'ọgbo a-maru lẹ mu meru g'ụnwu Ízurẹlu bua lẹ m̀kpù teke ono, mu shi lẹ Ijiputu dufuta phẹ ono. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ọo ya bụ; Mósisu bya atụko ọbo-iphe, Chipfu doberu kakọtaru ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Pfuaru ndu Ízurẹlu g'ẹphe wotaru ngu ọkpobe manụ olivu, a tsụru l'ikwe, ee-yeje l'orọku g'ọku orọku ono nwuje mkpụrumkpuru. ");
INSERT INTO izz_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Gẹ Erọnu; yẹle ụnwu iya yeje ọku l'orọku ono l'atatiphu Chipfu l'ime ụlo-ẹkwa-ndzukọ ono; mbụ l'okotazụ ẹkwa phọ, e gude kobuta okpoko-ekemu phọ. G'ẹphe mejekwa orọku ono g'o nwuje shita l'ụzenyashi jasụ l'ụtsu. Gẹ ndu Ízurẹlu dobekwa ekemu-a; a -gbẹ l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Gẹ Erọnu dozije ọku l'orọku ono l'eli iphe, aapfụbeje orọku ono, e meru lẹ mkpọla-ododo ono; g'o nwuje enwunwu l'atatiphu Chipfu mkpụrumkpuru.” ");
INSERT INTO izz_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Gude ukpokutu ereshi gheta ishi buredi iri l'ẹbo. L'ishi buredi lanụ bẹ ii-yeje ukpokutu ereshi, jiru nkwẹka e keru ụzo iri wota uzi labọ. ");
INSERT INTO izz_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","L'i woru buredi ọbu doo l'ogiri labọ l'eli teburu ono, e gude ọkpobe mkpọla-ododo mee dobe l'atatiphu Chipfu ono. Ishi buredi ishii l'ẹka lanụ; ishi buredi ishii ọphuu l'ẹka iya ọphuu. ");
INSERT INTO izz_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","L'ị bya eworu ọkpobe ụ̀nwù-isẹnsu dokubegbaa ogiri iya ogiri iya ono; g'ọ bụru iphe, nọ-chiru ẹnya buredi ono; tẹme g'e gude iya gweeru Chipfu ngwẹja, aakpọ ọku. ");
INSERT INTO izz_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Iphe, bụkpoo eswe-atụta-unme, a-nwụta anwụta bẹ Erọnu e-dozije iya l'iphu Chipfu. Ọ bụru ndu Ízurẹlu bẹ ọo-nọdu emejeru iya; g'ọ bụru ọgbandzu, a-nọ jasụ l'ojejoje. ");
INSERT INTO izz_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Buredi ono bụ Erọnu yẹe oshilọkpa iya nwe iya. G'ẹphe nọdujekwa l'ẹka dụ nsọ taa ya; kẹle ọ dụ nsọ shii; kẹle ọ bụ oke iya nkephẹ lẹ ngwẹja, aakpọ ọku anụ Chipfu jasụ l'ojejoje.” ");
INSERT INTO izz_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","O nweru nwoke, ne iya bụ onye Ízurẹlu; nna iya bụru onye Ijiputu; ẹphe lẹ ndu Ízurẹlu swịru. A nọnyaa; ọgu daru ẹphe l'onye Ízurẹlu l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Onye ono, ne iya bụ onye Ízurẹlu ono wata epfubyishi ẹpha Chipfu. A kpụta iya kpụjeru Mósisu. Ẹpha ne nwata ono bụ Shelomotu; nwada Dibiri onye bụ oshilọkpa Danu. ");
INSERT INTO izz_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","A kpụta iya je atụ-chia kwabẹru Chipfu g'ọ karụ phẹ iphe, bụ uche iya. ");
INSERT INTO izz_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kpụta onye ono, pfubyiru ẹpha mu ono kpụfu l'azụ ẹka unu kpọberu ụlo-ẹkwa unu. G'iphe, bụkpoo ndu nụmaru teke oopfubyi ẹpha mu ono byabẹ iya ẹka l'ishi; g'ọha wulihu woru iya tugbua lẹ mkpuma. ");
INSERT INTO izz_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Sụ ndu Ízurẹlu: Onye pfubyiru ẹpha Chileke iya bụkwa onye ọbu bẹ iphe-ẹji iya ọbu tụ-koru l'ishi. ");
INSERT INTO izz_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Onye pfubyiru ẹpha Chipfu bẹ ee-gbu egbugbu. G'ọha zefutakwa je atugbua onye ọbu lẹ mkpuma. Onye ọbu -bụru onye lwarụ alwalwa; ọzoo l'ọ bụ onye a nwụru lẹ Ízurẹlu; o pfubyia ẹpha Chipfu ono; g'e gbua onye ọbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Onye gburu nemadzụ ibiya; g'e gbukwaa yẹbedua. ");
INSERT INTO izz_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","G'onye gburu iphe-edobe onye ọzo pfụkwaa ụgwo iya. Ọphu dzụ ndzụ bẹ oo-gude dochia ọphu nwụhuru nụ. ");
INSERT INTO izz_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Onye mebyiru nwibe iya ibe ẹhu lanụ; bụkwapho g'ee-mebyi yẹbedua ibe ẹhu lanụ. ");
INSERT INTO izz_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Onye gbajiru nwibe iya ọkpu g'a gbajilatakwa iya phọ. Teke ọ bụ ẹnya bẹ o meru; ọ pyahụ onye ọbu; g'e mekwaphọ gẹ nkiya pyahụlata. Teke ọ bụ eze bẹ o chikwofuru onye ono; g'e chikwofulatakwa iya phọ eze. Ọo g'o mekaberu onye ọzo iphe, bụ g'ee-mekaberu iya. ");
INSERT INTO izz_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Onye gburu anụ nemadzụ ibiya; g'ọ pfụkwaa ụgwo iya; teke ọ bụ l'ọo nemadzụ bẹ o gburu g'e gbukwaa yẹbedua. ");
INSERT INTO izz_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ekemu-a dụ swiru ndu a nwụru anwụnwu lẹ Ízurẹlu; yẹe ndu lwarụ iya alwalwa. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mósisu pfuchaaru iya ndu Ízurẹlu; ẹphe kpụta onye ono, pfubyiru ẹpha Chipfu ono; kpụfu l'azụ ẹka ẹphe kpọberu ụlo-ẹkwa phẹ je eworu iya tugbua lẹ mkpuma. Ndu Ízurẹlu shi nno mee iphe, Chipfu tụru Mósisu ekemu g'ẹphe mee. ");
INSERT INTO izz_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu l'eli úbvú Sayịnayi sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Wakwa iphe, ii-pfuru yeru ụnwu Ízurẹlu baa; sụ phẹ-a: Teke unu bahụerupho l'alị ono, mu abya anụ unu ono; unu hajẹkwa alị ono g'ọ nọoru Chipfu apha-atụta-unme. ");
INSERT INTO izz_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Unu mebeje iphe l'alị unu apha ishii; unu akọchaje opfu-vayịnu unu akọcha apha ishii; wọo akpụru iya. ");
INSERT INTO izz_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","O -be l'apha k'ẹsaa l'a haa alị ono g'ọ tụta unme. Ono bụ apha-atụta-unme kẹ Chipfu. Unu be mebekwa iphe l'alị unu apha ono; ọphu unu akọchakwa opfu-vayịnu unu. ");
INSERT INTO izz_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Unu te ejekwa akpata iphe, daru ẹda. Teke vayịnu, e mechaduru emecha mịru amịmi; unu ta awọtakwa iya; noo kẹle apha ono bẹ alị ono atụta unme. ");
INSERT INTO izz_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Iphe, alị mịtaru l'apha k'ono, alị atụta unme ono; a-bụru nri unu; waa k'ohu unu; waa ndu-ozi, unu butaru ebuta; mẹ ndu lwarụ alwalwa, bu l'echilabọ unu. ");
INSERT INTO izz_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ọ kwaphọ iphe, daru ẹda l'alị ono a-bụru nri iphe-edobe unu; waa anụ-ẹgbudu, bu l'alị unu.” ");
INSERT INTO izz_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Unu gụa apha-atụta-unme gụta apha ẹsaa; mbụ apha ẹsaa ẹsaa mgbo ẹsaa. Apha-atụta-unme ẹsaa ono bụ iphe, ọo-dụ bụ apha ụkporo labọ l'apha tete. ");
INSERT INTO izz_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ọnwa k'ẹsaa -dụepho l'abalị iri, bụ iya bụ eswe-apfụ-ụgwo-iphe-ẹji; l'i zia g'e gbua opu gude jedzuru l'alị unu ono. ");
INSERT INTO izz_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Unu edoo apha k'ụkporo ẹbo l'iri nsọ; unu epfua g'onyemonye l'alị ono mgburugburu nweru onwiya. Apha ono a-bụru unu apha-ẹhu-ụtso; noo teke onyenọnu a-la alị iya; mbụ l'onyenọnu a-lapfu ndibe iya. ");
INSERT INTO izz_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","G'apha k'ụkporo ẹbo l'iri ono bụkwaru unu apha-ẹhu-ụtso. Unu ta akọbekwa iphe l'alị; ọphu unu ejejekwa akpata ọphu daru ẹda l'apha ono; ọzoo ọphu mịtaru lẹ vayịnu, a kọchaduru akọcha. ");
INSERT INTO izz_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Eshinu apha ono bụru unu apha-ẹhu-ụtso bẹ unu e-dobe iya nsọ. Ọo iphe, daru ẹda l'alị ono bẹ unu e-ri l'apha ono. ");
INSERT INTO izz_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“O -rwua l'apha-ẹhu-ụtso ono; g'onyenọnu lakwaa alị iya. ");
INSERT INTO izz_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ọ -bụru l'ọ dụru iphe, i reru nwibe ngu; ọzoo l'ọ dụru iphe, ị zụtaru l'ẹka nwibe ngu; unu mekwaa ya g'ọ tọ dụ onye e-ri nwibe iya urwu. ");
INSERT INTO izz_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","G'ii-gudeje zụ̀a nwibe ngu iphe, bụ: a -gbẹ lẹ g'a bọcharu ọbo-iphe apha-ẹhu-ụtso. Mbụ l'ọo g'ọo-nọ-beru l'aakpata iphe, e meberu l'alị bụ g'oo-gude ree ngu iphe, ịizu iya. ");
INSERT INTO izz_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Teke ọ bụ l'apha a-dụ igwerigwe nwụa tẹme l'o rwua apha-ẹhu-ụtso; aswa alị ọbu aha shii. Teke ọ bụ l'apha habe nwahabe l'i gbuzeta aswa iya; noo kẹle iphe, ịizu ele ẹnya iya gụbedua l'azụ azụzu bụ iphe i-meta l'alị ọbu. ");
INSERT INTO izz_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","G'ọ tọ dụkwa onye ọphu e-ri nwibe iya urwu; ọ chịa iphe, unu e-meje bụ g'unu tsụje Chileke unu ebvu. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Ọo ya bụ lẹ-a; unu tsojekwa iphe, mu tọru ọkpa iya sụ g'e tsoje; unu emeje iphe, mu tụru l'ekemu; k'ọphu unu e-buru l'alị ono; ọ tọ dụdu iphe, eme unu. ");
INSERT INTO izz_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ọo ya bụ; g'alị emehuaha iphe, a kọberu iya; unu erijiaha ẹpho; buru iya; ọ tọ dụdu iphe, eme unu. ");
INSERT INTO izz_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Unu a-jịkwanu sụ: ‘?Bụ gụnu bẹ anyi e-ri l'apha k'ẹsaa ọbu; m'anyi adụdu iphe, anyi kọru; ọphu ọ dụkwapho iphe, anyi kpatarụ?’ ");
INSERT INTO izz_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ọle mu e-kebe unu l'ọma l'apha k'ishii; k'ọphu apha ono e-mehu iphe; unu enweru akpụru-iphe, a-sụru unu apha ẹto. ");
INSERT INTO izz_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","O -be l'apha k'ẹsato; unu awata akọbe iphe l'alị. Ọ bụru akahụ iphe, unu metaru bẹ unu a-nọdu eri jasụ l'apha kẹ tete; teke unu a-kpata iphe, unu meberu l'alị.” ");
INSERT INTO izz_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“G'ọ tọ dụkwa onye e-rebuje alị iya erebu; noo kẹle alị bụkwa mbẹdua nwe iya. Unubẹdua bụ abyabya bẹ unu byaru; ọ bụru anụnu bẹ mu nụru iya unu g'unu buru. ");
INSERT INTO izz_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Unu sụbeje iphe, ee-gude agbata alị ono, bụ oke alị unu ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ọ -bụru lẹ nwune ngu bẹ ụkpa byaru; k'ọphu ọ harụ alị iya ree; g'onye a-bya agbata alị ono, o reru ono; bụkwaru onye yẹle iya bụ ọkpobe abụbu. ");
INSERT INTO izz_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ọle ọ -bụkwanuru l'onye ọbu te nwedu onye e-je agbafụta iya nụ; obenu lẹ yẹbedua nwewaru iphe k'ọphu ọo-dụ ike gbata iya; ");
INSERT INTO izz_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","g'ọ gbakọo apha, nwụwaru nụ e -shi teke o reru iya; l'ọ pfụa onye o reru alị ono ụgwo apha ọphu o tokọ kọdu alị ọbu; laphu azụ l'alị iya. ");
INSERT INTO izz_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ọle ọ -bụkwanuru l'onye ọbu ta amadụ ụzo, oo-shi gbafụta iya; g'alị ono, o reru ono nọdukwa l'ẹka onye zụru iya nụ jasụ l'apha-ẹhu-ụtso. O -be l'apha-ẹhu-ụtso g'onye zụru iphe ọbu haa ya; g'onye ono, nwe iya nụ ono laphu azụ l'alị ono. ");
INSERT INTO izz_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Ọ -dụru onye reru ụlo-ebubu lẹ mkpụkpu, e gude igbulọ kpụ-phee mgburugburu; g'ọ gbatakwa iya l'ime mgbatapha, o reru iya ono. Ọo l'ime teke ono bẹ ọo-gbata iya. ");
INSERT INTO izz_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ọle ọ -bụru l'ọ tọ gbataduru iya jasụ apha gbaru; ọo ya bụ l'ụlo ono, dụ lẹ mkpụkpu, a kpụ-pheru mgburugburu ono bẹ ee-me g'ọ bụwaruro k'onye zụru iya nụ; e -shi l'ọgbo sweru ọgbo. Ọ tọo kụfukpokwaa ya nụ l'ẹka l'apha-ẹhu-ụtso. ");
INSERT INTO izz_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Obenu l'ụlo, nọgbaa l'ọma mkpụkpu, a kpụ-pheduru igbulọ mgburugburu bụ g'eemeje ọma ẹgu bẹ ee-meje iya. Ẹphebedua dụ k'agbata; tẹme o jee l'akụfu onye zụru iya nụ l'ẹka mẹ o -rwua l'apha-ẹhu-ụtso. ");
INSERT INTO izz_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","O bekwanụ lẹ-a; a bya lẹ mkpụkpu lẹ mkpụkpu kẹ ndu Lívayi; ụlo, nọgbaa l'ọma mkpụkpu, bụ nkephẹ bẹ ndu Lívayi ono a-gbatajẹ teke dụ phẹ ree. ");
INSERT INTO izz_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Teke ọ dụru onye zụru onye Lívayi ụlo; ọphu onye Lívayi ono adụdu ike gbafụta iya; g'ụlo ono, e reru ono, nọ lẹ mkpụkpu ono, bụ phẹ nwe iya ono; laphukwa iya azụ l'ẹka; noo kẹle ụlo ndu Lívayi lẹ mkpụkpu ono, a nụru phẹ ono bụ iphe phẹ l'echilabọ ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","G'ọ tọ dụkwa iphe, e-me g'ẹphe ree alị ẹka ẹphe echeje atụru phẹ; mbụ ọphu nọ lẹ mkpụkpu phẹ; noo kẹle ono bụ okiphe phẹ jasụ l'ojejoje.” ");
INSERT INTO izz_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Ọ -bụru l'onye Ízurẹlu ibe ngu bẹ ụkpa byaru; ọphu ọ dụedu ike azụ onwiya l'obutobu ngu; yejeru iya ẹka ẹgube ono, eeyejeru onye lwarụ alwalwa; ọzoo onye byaru abyabya ono; k'ọphu oo-bukube ngu g'o bukube ngu. ");
INSERT INTO izz_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ta natakwa iya ntụkwase; ọ chịkwa g'ị tsụ Chileke ngu ebvu; k'ọphu nwune ngu ono e-bukube ngu g'o bukube ngu. ");
INSERT INTO izz_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Te jiekwa iya okpoga sụ iya g'ọ tụkwaseru ngu iya iphe; ọphu i lekwa ẹnya urwu lẹ nri, ị nụru iya. ");
INSERT INTO izz_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu, bụ onye dufutaru unu l'alị Ijiputu gẹ mu nụ unu alị Kénanu; tẹme mu abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Ọ -bụru l'onye Ízurẹlu ibe ngu, gụ l'iya bu obutobu bẹ ụkpa byaru; k'ọphu o woru onwiya ree ngu; be mekwa iya g'o jejeru ngu ozi g'ohu. ");
INSERT INTO izz_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ọo g'iimeje onye i beru ozi; ọzoo onye byaru abyabya bụ g'ii-me iya; l'o jeeru ngu ozi nno jasụ l'apha-ẹhu-ụtso. ");
INSERT INTO izz_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","O -rwua teke ono l'ị haa ya; mẹkpoo ụnwu iya; l'ọ laa lapfu ndibe phẹ; lapfu okiphe nna iya. ");
INSERT INTO izz_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kẹle eshinu ndu Ízurẹlu bụ ohu nkemu, mu shi l'alị Ijiputu dufuta bẹ e tee redu phẹ g'ẹphe bụru ohu. ");
INSERT INTO izz_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ta dụkwaru onye Ízurẹlu ibe ngu ẹhuka; l'ị tsụjekwa Chileke ngu ebvu. ");
INSERT INTO izz_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Gẹ ndu unu a-gbajẹ ohu; unwoke mẹ ụnwanyi; bụkwaru ndu shi l'ọhozo, nọ-pheru unu mgburugburu. Nokwa ndu unu a-gbajẹ ohu bụ ono. ");
INSERT INTO izz_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ndu ọzo, unu a-gbajẹfua ohu bụ ndu byaru abyabya, unu l'ẹphe tụko buru; ọzoo ndibe ndu ono, unu l'ẹphe tụkokwapho buru ono, bụ ndu ẹphe nọ l'alị unu nwụshia. Unu -gbaa phẹ ohu; unu enwowarụ phẹ rọ. ");
INSERT INTO izz_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ndu k'ono bẹ unu e-me g'ẹphe buru okiphe, unu ketarụ ụnwu unu, l'etso unu l'azụ; g'ẹphe keta phẹ g'ẹphe bụru ohu phẹ jasụwaruro. O -be l'unwune unu, bụ ụnwu Ízurẹlu; unu ta adụkwaru phẹ ẹhuka. ");
INSERT INTO izz_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Ọ -bụru l'onye lwarụ alwalwa; ọzoo onye byaru abyabya, unu l'iya tụko buru nọnyaru bya enweru iphe; onye Ízurẹlu ibe ngu, yẹe ya bukube -daa ụkpa bya eworu onwiya ree onye lwarụ alwalwa ono, bukube ngu nụ ono; ọzoo l'o woru onwiya ree abụbu onye ono, lwarụ alwalwa ono; ");
INSERT INTO izz_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","e -rechakpọo ya nụ bẹ aa-gbafụtale iya-a; onye lanụ l'ime unwune iya a-gbafụtakpoo ya. ");
INSERT INTO izz_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Gẹ nwune nna onye ọbu; ọzoo nwa nwune nna iya; ọzoo onye ọzo, ẹphe l'iya bụ abụbu jekwaa agbafụta iya. Ọ -bụru l'onye ọbu nọnyaru bya enweru iphe k'ọphu ọo-dụ ike gbafụta onwiya; g'onye ọbu gbafụtakwa onwiya. ");
INSERT INTO izz_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","G'onye reru onwiya; yẹe onye zụru iya nụ; nọdukwa gbakọo maru apha ole, dụ nụ; a -gbẹ l'apha onye ọbu reru onwiya jasụ l'apha-ẹhu-ụtso. G'a gbẹ l'iphe, onye o-gburu-mịta ejetajẹ ujiku lanụ; gbakọo okpoga apha, ghuduru nụ; karụ iya iphe, ọo-pfụ gude gbata onwiya. ");
INSERT INTO izz_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ọ -bụru l'apha, ghuduru nụ hakwadụ shii; g'onye ono keta okpoga ono, o shi gude ree onwiya ono ọphu kwata ka shii pfụa gude gbata onwiya. ");
INSERT INTO izz_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Teke ọ -bụkwanu l'apha, ghuduru nụ habewa nwahabe g'o rwua l'apha-ẹhu-ụtso; g'ẹphe l'iya gbakọo ya; g'ọ pfụa g'apha ole, ghuduru nụ ha gbata onwiya. ");
INSERT INTO izz_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","G'e mejekwa onye ono g'eemeje onye-ozi, e butaru ebuta aphagapha. G'e leta ẹnya g'onye ono, ọ nọ l'ẹka ono ta adụkwaru iya ẹhuka. ");
INSERT INTO izz_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ọ -bụru l'a taa gbafụtadu iya l'ụzo, dụ ẹgube ono; g'a hakwaa yẹe ụnwegirima ibe iya mẹ o -rwuẹpho l'apha-ẹhu-ụtso. ");
INSERT INTO izz_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Noo kẹle ndu Ízurẹlu bụ ohu mu. Ẹphe bụ ohu mu, mu dufutaru l'alị Ijiputu. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“G'ọ tọ dụkwa agwa; ọzoo ntẹkpe, a pyịru apyịpyi; ọzoo mkpuma, a kpọberu g'itso, unu e-dobe l'alị unu. Ọphu ọ dụkwa mkpuma, a pyịru apyịpyi, unu ee-dobe l'alị unu wata abarụ ẹja. Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu. ");
INSERT INTO izz_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Unu dobeje eswe nkemu, bụ eswe-atụta-unme iche; unu akwabẹje ụlo mu, dụ nsọ ùbvù. Ọ kwa mbẹdua bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Unu -nọdu atụkojewa iphe, mu tọru ọkpa iya sụ g'e tsoje etso; bya emekọta iphe, mu sụru g'unu mee; ");
INSERT INTO izz_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","bẹ mu a-nọduepho edzeru unu mini l'orwuberu iya; iphe, e meberu l'alị emehu emehu; tẹme oshi, nọ l'ẹgu amịshigbaa mebyi iya. ");
INSERT INTO izz_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Iphe a-nọdu emehuru unu shii; k'ọphu bụ l'unu a-nọdu echi ereshi jasụ ògè awọ akpụru vayịnu erwua. Unu egude awọ akpụru vayịnu jasụ ògè emebe iphe l'alị erwua ọzo. Unu a-nọdu eri nri eriji ẹpho; unu eburu l'alị ono; ọ tọ dụdu iphe, eme unu. ");
INSERT INTO izz_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Mu e-me g'unu buru l'ẹhu-guu l'alị ono; k'ọphu bụ l'unu a-zẹ pyakọo; ọ tọ dụdu onye eye unu ebvu. Mu emee g'ẹjo anụ-ẹgbudu chịhu l'alị ono; ọphu a byadu alwụ ọgu l'alị unu ono. ");
INSERT INTO izz_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Unu a-chị ndu ọhogu unu gbushia phẹ. ");
INSERT INTO izz_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Unu -dụ ise; unu achịa ụmadzu ụkporo ise; teke unu dụ ụkporo ise; unu achịa ụnu ụkporo l'ise. Unu e-gude ogu-echi unu gbushia ndu ọhogu unu. ");
INSERT INTO izz_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mu a-nọdu eleta unu ẹnya; mee unu g'unu zụ̀a azụ̀zù kabaa l'ọtu. Ọgbandzu mu l'unu bẹ mu e-me g'ọ ngụru angụru. ");
INSERT INTO izz_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ọzo bụ l'unu e-rije akahụ iphe, unu kpatarụ jasụ unu akpata k'ọ̀phúú; mbụ a -nọnyaa unu achịshiaha akahụ iya k'ọphu ee-wobata k'ọ̀phúú. ");
INSERT INTO izz_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Tẹme mu eworu ụlo-ẹkwa mu kpọbe l'echilabọ unu; ọphu unu adụbaedu mu ideyideyi. ");
INSERT INTO izz_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mu a-nọdu ejephe l'echilabọ unu; mu abụru Chileke unu; unu abụru ndibe mu. ");
INSERT INTO izz_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke unu, bụ onye dufutaru unu l'alị Ijiputu; g'unu ta abụheru ohu ndu Ijiputu. Mu mebyiwaa ike ono, ẹphe shi gude mee g'unu bụru ohu phẹ ono; shi nno mee unu g'unu phafụta ishi.” ");
INSERT INTO izz_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ọle ọ -bụru l'unu ta ngabẹduru mu nchị; ọphu unu emedu iphe, mu sụru g'unu meje g'ọ ha; ");
INSERT INTO izz_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","mbụ ọ -bụru l'unu ta agụbeduru iya iphe; mbụ iphe, mu tọru ọkpa iya sụ g'e tsoje; ọzoo l'obu unu woru iphe, mu tụru l'ekemu mee; ọ dụ ideyideyi; k'ọphu bụ l'unu te emejedu iphe, mu sụru g'unu meje g'ọ ha; unu eshi nno woru ọgbandzu, mu l'unu gbaru mebyia; ");
INSERT INTO izz_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","bụkwa iphe, mu e-me unu bụ ọwa: Mu e-me gẹ ndzụ-agụgu rwuta unu; tẹme ụkwaranta eseahaa unu; yẹe ẹjo ẹhu-ọku, e-woru unu ẹnya mebyia; ndzụ unu ala kẹ mmanụ. Unu -kọbe iphe l'alị l'ọ bụru iphe-mmanụ; noo kẹle ọo ndu ọhogu unu e-mechaa ria ya. ");
INSERT INTO izz_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mu a-gharu unu iphu lẹ kẹ njọ; ndu ọhogu unu alwụ-kpee unu l'ọgu. Ndu unu dụ ashị a-bụru ndu-ishi unu; unu agbaaha ọso teke adụdu onye achị unu. ");
INSERT INTO izz_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ọ -bụru lẹ mu mechaarụ unu nno; ọphu unu angabẹduru nchị; mu anụbaa unu aphụ iphe-ẹji unu ono ọphu ha g'ọwa mgbo ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mu e-me g'unu kubuhu onwunu; mbụ mee akpaminigwe, unu vu l'ishi g'ọ dụ gbọrojii gẹ mkpụrukpu-ígwè; bya emee alị, unu zọberu ọkpa g'ọ ha ngerengere g'onyirubvu. ");
INSERT INTO izz_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ọkpehu, unu gude kọo alị a-bụru unu kẹ mmanụ; noo kẹle alị ta adụedu iphe, oo-meta; tẹme oshi-ọmi, pfụru l'alị ono amị-buhu mebyi. ");
INSERT INTO izz_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Teke ọ bụ l'unu emekwaphọ iphe, mu sụru g'unu te emejeshi; k'ọphu bụ l'unu ta angakwaru mu phọ nchị bẹ mu e-gude iphe-ẹhuka, ka iphe-ẹji, unu meru mgbo ẹsaa; nụa unu aphụ. ");
INSERT INTO izz_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mu a-chịru anụ-ẹgbudu ye g'ẹphe bya adakaa unu; bya atụko ụnwegirima unu nakọta unu l'ọkpehu; tụko iphe-edobe unu mebyishichaa; mee; unu ta abaẹdu ishi; eze gbororo unu adabyiru iphoro. ");
INSERT INTO izz_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Teke mu mechakpọoru unu iphemiphe ono; ọphu unu agbanwekwarụpho; unu nọdu emekwaphọ iphe, mu sụru g'unu te emejeshi ");
INSERT INTO izz_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","bẹ mu e-mekwaphọ unu iphe, mu tege emedu unu; mbụ lẹ mu a-nụ unu aphụ iphe-ẹji ono, unu eme ono mgbo ẹsaa. ");
INSERT INTO izz_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mu a-ha g'ọgu dapfu unu; gude iya gwata unu ụgwo ọgbandzu ono, unu mebyiru ono. Unu -dzukọbeepho l'ọma mkpụkpu unu; mu emee g'ẹjo iphe-ememe dapfu unu; shi nno woru unu yee ndu ọhogu unu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Teke mu gbuchiru unu ụzo, eeshije akọta nri ono; bẹ ụnwanyi iri a-dụje ike ghekọta buredi g'unu ha l'ovokọku lanụ. Ẹphe -ghechaa ya; ẹphe egude iphe, eegudeje atụ ẹrwa iphe keeru iya unu. Unu -richaa ya; ẹgu agụroo unu l'ẹka ọogu unu. ");
INSERT INTO izz_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ọle ọ -bụru lẹ mu mechaarụ unu iphemiphe ono; unu nọdu emekwaphọ iphe, mu sụru g'unu te emeshi ");
INSERT INTO izz_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","bẹ mu e-gude ẹhu-eghu mee unu iphe, mu tege emedu unu; mbụ l'ọo mbẹdua l'onwomu e-chi unu iphe mgbo ẹsaa k'iphe-ẹji, unu eme. ");
INSERT INTO izz_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Noo teke unu a-wata eri anụ ụnwu unu unwoke; mbụ richaa ria anụ ụnwu unu ụnwanyi. ");
INSERT INTO izz_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mu e-mebyishi ẹka unu agwajẹ iphe; bya enwutsushia ọru-ngwẹja ẹka unu akpọje ụ̀nwù-isẹnsu ọku. Mu eworu odzu unu tụkaa l'eli nshi unu ono, bụhukwapho odzu l'onwiya ono. Unu adụe mu phọ ideyideyi l'obu. ");
INSERT INTO izz_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mu emee mkpụkpu lẹ mkpụkpu unu g'ọ bụru iphe, dabyigbaaru iphoro. Mu emee ụlo unu, dụ nsọ g'ọ bụru okorobo ụlo. Teke ono bẹ mkpọ ngwẹja, unu gwerụ ta abyaẹdu adụ mu ree. ");
INSERT INTO izz_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Alị ono bẹ mu e-me g'ọ bụru ochobu; k'ọphu bụ lẹ ndu ọhogu unu, bụ ndu e-mechaa buchia ya nụ bẹ ọo-dụ biribiri. ");
INSERT INTO izz_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ọzo bụ lẹ mu a-tụka unu nanụnanu l'alị ndu ọhozo. Ọ bụru ogu-echi bẹ mu a-mịta gude tsoru unu. Alị unu adabyiru iphoro. Mkpụkpu lẹ mkpụkpu unu abụkotaru ochobu. ");
INSERT INTO izz_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Noo teke ẹhu a-wata atsọ alị ono lẹ ya atụta unme; mbụ teke ono, ọ dabyikpọoru iphoro; unubẹdua nọdu l'alị ndu ọhogu unu ono. Teke ono bẹ alị ono a-nọdukpoepho ete ẹswa lẹ ya atụta unme. ");
INSERT INTO izz_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Teke ono, alị ono dabyiru iphoro ono bụ unme bẹ ọotuta; kẹle o to shidu atụtajekwadu unme l'apha-atụta-unme unu teke unu shi buru iya. ");
INSERT INTO izz_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“A bya lẹ ndu ọphu ghuduru nụ l'echilabọ unu; ndu k'ono bẹ mu e-me g'ẹphe dụ ogozi l'ime obu phẹ l'alị ndu ọhogu phẹ; k'ọphu bụ l'ẹkwo, a nmarụ yigayiga l'e-me g'ẹphe ye ọkpa l'ọso; gbalaa gẹ ndu e gude ogu-echi achị. Ẹphe adaa l'ẹbe adụ onye achị phẹ ọso. ");
INSERT INTO izz_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ẹphe e-vukotajẹ nwibe phẹ daa dapyabẹ phẹ gẹ ndu e gude ogu-echi achị l'ẹbe abụ l'ọ dụru onye achị phẹ nụ. Ọphu unu adụbaedu ike apfụru l'iphu ọhogu unu. ");
INSERT INTO izz_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Unu a-nwụshihu l'alị ndu ọhozo. Ọ bụru alị ndu ọhogu unu e-ri ishi unu. ");
INSERT INTO izz_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Tẹme nwa ndu ọphu phọduru nụ l'echilabọ unu bẹ a-nọdu eyifu eyifu l'alị ndu ọhogu unu. Ọ bụru ẹjo-iphe, ẹphe meshiru; waa ọphu nna phẹ oche phẹ meshiru bẹ ẹphe e-gude yifu ono. ");
INSERT INTO izz_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ọle ọ -bụru l'ẹphe pfushiru ẹjo-iphe, ẹphe eme; yẹe ẹjo-iphe, nna phẹ oche meshiru; mẹkpoo emeswe, ẹphe mesweru mu; yẹe ememe, ẹphe emeje iphe, mu sụru g'ẹphe te emeshi, ");
INSERT INTO izz_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","bụ iphe, meru; mu mee phẹ iphe, mu tege emedu phẹ; chịru phẹ jeye l'alị ndu ọhogu phẹ. Ọ -bụru l'ọkpoma phẹ ono, ẹjo-iphe jiru ejiji ono bẹ ẹphe e-woze alị; bya apfụa ụgwo ẹjo-iphe, ẹphe mekọtaru; ");
INSERT INTO izz_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","bẹ mu a-nyatakwa-a ọgbandzu mu lẹ Jiékọpu; yẹe ọgbandzu mu lẹ Áyizaku; mu anyatakwaphọ ọgbandzu mu lẹ Ébirihamu; nyatakwaphọ alị ono. ");
INSERT INTO izz_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Obenu l'alị ono bẹ ẹphe a-ha g'ọ dabyiru iphoro; gude ẹhu-ụtso nyaa ọku. Noo teke ẹphe a-pfụ ụgwo ẹjo-iphe, ẹphe meru; noo kẹle ẹphe ta adụdu iphe, ẹphe gụberu iphe, mu tụru l'ekemu; wafụa l'ẹphe woru iphe, mu tọru ọkpa iya sụ g'e tsoje mee; ọ dụ ideyideyi. ");
INSERT INTO izz_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ọle g'ọ dụhabe bẹ teke ono, ẹphe a-nọdu l'alị ndu ọhogu phẹ ono bẹ mu ta ajịkakwa phẹ; ọphu mu edobekwa phẹ gẹ ndu dụ ideyideyi; kẹ gẹ mu mebyishikọta phẹ kpamu; mebyia ọgbandzu mu l'ẹphe; kẹle ọ kwa mbẹdua bụ Chipfu; bya abụru Chileke phẹ. ");
INSERT INTO izz_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ọle mu e-gude iswi ẹhu phẹ nyata ọgbandzu mu lẹ ndu ndiche phẹ, bụ ndu mu shi l'alị Ijiputu dufuta l'atatiphu ọhamoha; k'ọphu mu a-bụru Chileke phẹ. Ọ kwa mbẹdua bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ono bụ iphe, Chipfu tọru ọkpa iya sụ g'e tsoje; waa iphe, ọ tụru l'ekemu; waa ekemu, Chipfu tụru dobe l'echilabọ ẹphe lẹ ndu Ízurẹlu l'eli úbvú Sayịnayi. Ọ bụru Mósisu bẹ ọ nụru iya g'ọ nụ phẹ. ");
INSERT INTO izz_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Tọbudu iya bụ; Chipfu bya epfuru yeru Mósisu sụ iya: ");
INSERT INTO izz_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Pfuaru ụnwu Ízurẹlu; sụ phẹ-a: Ọ -bụru lẹ nemadzụ rifuru angụ lẹ ya e-woru nemadzụ nụ Chipfu; g'ọ pfụkwaa ụgwo l'ishi onye ọbu: ");
INSERT INTO izz_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","“Ọ -bụru nwoke, nọwaru a -gbẹ l'ụkporo apha rwua ụkporo apha ẹto; bẹ iphe, aa-pfụ l'ishi iya bụ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu labọ lẹ shẹkelu iri. G'ọ bụkwaru iphe, eegudeje atụ̀ ẹrwa iphe l'eze-ụlo Chileke bẹ ee-gude tụ̀a ya. ");
INSERT INTO izz_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","“Ọ -bụru nwanyị; bẹ iphe, aa-pfụ l'ishi iya bụ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu lẹ shẹkelu iri. ");
INSERT INTO izz_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","“Ọ -bụru nwokoro, nọru a -gbẹ l'apha ise jasụ l'ụkporo apha; bẹ iphe, aa-pfụ l'ishi iya bụ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu; ọ -bụru nwanyị; iphe, aa-pfụ l'ishi iya abụru mkpọla-ọchaa, ẹrwa iya dụ shẹkelu iri. ");
INSERT INTO izz_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“Ọ -bụru nwata kẹ nwoke, nọru a -gbẹ l'ọnwa lanụ jasụ l'apha ise; bẹ iphe, aa-pfụ l'ishi iya bụ mkpọla-ọchaa, ẹrwa iya dụ shẹkelu ise. Ọ -bụru nwata kẹ nwanyị; iphe, aa-pfụ l'ishi iya abụru mkpọla-ọchaa, ẹrwa iya dụ shẹkelu ẹto. ");
INSERT INTO izz_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“Nwoke, nọ-ghataru ụkporo apha ẹto bụ mkpọla-ọchaa, ẹrwa iya dụ shẹkelu iri l'ise bẹ aa-pfụ l'ishi iya; teke ọ bụ nwanyị l'a pfụa mkpọla-ọchaa, ẹrwa iya dụ shẹkelu iri. ");
INSERT INTO izz_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Ọ -bụru l'onye ono, riburu angụ ono bẹ akpa nri; k'ọphu bụ l'ọ tọ dụdu ike apfụ iphe, a sụru g'ọ pfụa; g'o duru onye ọbu, o riru angụ iya ọbu; dujeru onye uke. Onye uke ono elee ya ẹnya kọoru iya iphe, ọo-pfụ. Ọ bụru g'ike onye ono, riburu angụ ono habe bụ g'ee-gbuberu iya iphe, ọo-pfụ. ");
INSERT INTO izz_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Teke ọ bụkwanu l'ọo anụ bẹ nemadzụ gude bya anụ Chipfu iphe ngwẹja; mbụ anụ ọphu gbaru g'anụ iya Chipfu; iphe, bụkpoo anụ, a nụru Chipfu ẹgube ono dụkotakwa nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","G'o to wotakwa anụ ọzo dochia ẹnya iya; g'o to wotakwa anụ ọzo ka ẹji; ọzoo ọphu ka ree gude gbanweta anụ k'ono, o riburu angụ l'ọo-nụ ono. Ọ -bụru l'o gude anụ ọzo je agbanweta iya bẹ anụ ọphu o gude je iya agbanweta; yẹe anụ, o jeru agbanweta tụkoakwa bụru anụ, dụru Chileke nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Obenu; ọ -bụru l'iphe, o riburu angụ l'ọo-nụ bụ anụ, aasọ nsọ; mbụ anụ ọphu e tee gudejedu egweru Chipfu ngwẹja; g'a kpụtakwa anụ ọbu kpụjeru onye uke. ");
INSERT INTO izz_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","G'onye uke ono lee ya ẹnya maru m'ọ dụ ree tọo ọ dụ ẹji; ọ bụru iphe, onye uke ono sụkpoerupho g'ọ pfụa bụ iphe, ọo-pfụ. ");
INSERT INTO izz_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ọ -bụru l'onye nwe iya nụ bẹ ọ dụ g'ọ gbata iya; g'onye ono kee aswa iya ụzo ise wota oke lanụ tụkwase l'aswa iya pfụa gude gbata iya. ");
INSERT INTO izz_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Ọ -bụru l'ọ dụru onye woru ụlo iya nụ g'ọ dụru Chipfu nsọ; bụkwa onye uke bẹ ọ dụru epfu l'ụlo ono dụ ree; ọzoo l'ọ dụ ẹji. Ọ bụru iphe, onye uke sụkpoerupho l'ọo aswa iya bụ aswa iya. ");
INSERT INTO izz_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ọ -bụru l'onye woru ụlo ono doberu Chipfu nsọ bẹ ọ dụ g'ọ gbata iya; g'onye ọbu kee aswa iya ụzo ise wota yekọbe l'aswa iya pfụa; tẹme ụlo ọbu abụbaru nkiya. ");
INSERT INTO izz_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Ọ -bụru lẹ nemadzụ butaru alị-ihe iya nụ g'ọ bụru kẹ Chipfu; g'ee-gude maru iphe, bụ aswa iya bụ gẹ mebyi iphe, aa-kọbe l'alị ono habe shii. Alị, aa-kụ-gbu balị, jiru nkwẹka iri bẹ aswa iya bụ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu labọ lẹ shẹkelu iri. ");
INSERT INTO izz_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ọ -bụru l'ọo apha-ẹhu-ụtso bẹ ọ nụru alị iya g'ọ bụru kẹ Chipfu ọbu; bụepho iphe, a sụru g'a pfụa bẹ aa-pfụ. ");
INSERT INTO izz_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ọle ọ -bụru l'apha-ẹhu-ụtso ghatawaru; tẹme o ribua angụ l'oo-woru alị ono doberu Chileke nsọ; g'onye uke gụa apha ole, phọduru nụ; tẹme l'o rwua l'apha-ẹhu-ụtso ọzo; shi nno karụ onye ono iphe, aswa iya bụ. Ọo ya bụ l'ee-gbubọta iphe l'iphe, a sụru g'a pfụa. ");
INSERT INTO izz_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ọ -bụru l'onye woru alị ono doberu Chileke nsọ bẹ ọ dụ g'ọ gbata iya; g'o kekwaa aswa iya ụzo ise woru oke lanụ yekọbe l'aswa iya pfụa gude gbata iya. O -mechaa nno; alị ono abụwaruro nkiya g'o shi bụru iya. ");
INSERT INTO izz_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ọle ọ -bụru l'onye ono ta agbataduru alị ono; o woru iya ree onye ọzo; bẹ alị ọbu kwawaru; ọphu ọ dụedu ike gbata iya. ");
INSERT INTO izz_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","O -rwuẹpho l'apha-ẹhu-ụtso; bẹ alị ono a-dụru Chipfu nsọ; ọ bụru ndu-uke bẹ ọo-dụ l'ẹka; eshinu ọ bụ alị, e dobehawaru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Ọ -dụru onye riburu angụ anụ Chipfu alị, ọ zụru azụzu, abụdu alị iya, shi l'ẹnya unuphu ibe phẹ; ");
INSERT INTO izz_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","g'onye uke gụa apha ole, phọduru nụ; tẹme l'o rwua l'apha-ẹhu-ụtso; shi nno karụ onye ono iphe, aswa iya bụ. Ọ bụru mbọku ono bẹ onye ono a-pfụ aswa iya ọbu g'ọ bụru iphe, dụru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","O -rwua l'apha-ẹhu-ụtso; g'alị ono laphu azụ l'ẹka onye a zụru iya l'ẹka iya; mbụ onye alị ono bụ nkiya gẹdegede. ");
INSERT INTO izz_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“G'iphe, bụkpoo aswa iphe, aapfụkpoo apfụpfu bụkwaru iphe, eegudeje atụ̀ ẹrwa iphe l'eze-ụlo Chileke bẹ ee-gudeje tụa ya; g'a maru shẹkelu ole, ọ dụ. Ẹrwa shẹkelu lanụ bụ ụkporo gera. ");
INSERT INTO izz_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“G'ọ tọ dụkwa onye a-kpụtaje anụ mbụ, vuru ụzo waa ẹkpa ne iya; bya anụ g'e doberu Chileke nsọ; kẹle anụ, vuru ụzo waa ẹkpa ne iya bụkwa kẹ Chipfu; m'ọ bụ eswi; ọzoo atụru; g'ọ ha tụkoru bụru kẹ Chipfu. ");
INSERT INTO izz_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ọ -bụru anụ, aasọ nsọ; g'onye ono pfụa iphe, a sụru g'ọ pfụa gude gbata iya; g'o kekwaphọ aswa iya ụzo ise; wota oke lanụ yekọbe l'aswa iya ono pfụa. Teke ọ bụ l'ọ tọ dụdu ike gbata iya g'e ree ya onye ọzo iphe, a sụru l'ọ bụ aswa iya. ");
INSERT INTO izz_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Ọle g'ọ dụhabe; g'ọ tọ dụkwa iphe, nemadzụ gọru nụ Chipfu, ee-re erere; ọzoo gbata iya agbata. Mbụ iphe, shi l'iphe, nemadzụ nweru enweru; m'ọ bụ nemadzụ; ọzoo anụ; ọzoo alị, bụ iya nwe iya; iphemiphe, a gọru nụ Chipfu dụkwaru Chipfu nsọ shii. ");
INSERT INTO izz_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","G'ọ tọ dụkwa onye e doberu k'egbugbu, aa-gbatajẹ agbata; g'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Oke-lanụ-l'ụzo-iri l'iphe, e metaru l'alị; m'obeta ọ bụru mebyi iphe, a kpatarụ l'iphe, a kọru l'alị; ọzoo akpụru, oshi mịtaru; bụkotakwa kẹ Chipfu; ọ dụru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ọ -dụru onye eme g'ọ gbata oke-lanụ-l'ụzo-iri nkiya; g'onye ono kekwaa iphe, bụ aswa iya ụzo ise; wota oke lanụ yekọbe l'aswa iya ono gude gbata iya. ");
INSERT INTO izz_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","A bya l'oke-lanụ-l'ụzo-iri, shi l'eswi; ọzoo ọphu shi l'eghu mẹ atụru; mẹkpoo ọphu shi l'iphe, bụ anụ, eye ishi l'ọka; g'oke-lanụ-l'ụzo-iri, shi iya nụ dụkotajeru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","G'o to jejekwa iya enyocha kẹ ?a maru ọ dụ ree tọo ọ dụ ẹji; ọphu ọ gbakwa iya inwe. A -gbakwanaa ya inwe agbagba ophu; g'ono yẹe ọphu e gude agbanweta iya tụkokwa bụru iphe, dụ nsọ; ọphu a byadu agbata iya agbata.” ");
INSERT INTO izz_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ono bụ ekemu, Chipfu tụshiru nụ Mósisu l'úbvú Sayịnayi g'o je anụ ndu Ízurẹlu.");
INSERT INTO izz_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Chipfu pfuru opfu yeru Mósisu l'ụlo-ẹkwa-ndzukọ ndu Ízurẹlu lẹ g'ẹphe nọ l'echiẹgu Sayịnayi l'abalị mbụ l'ọnwa k'ẹbo l'apha, kwe ndu Ízurẹlu apha labọ, ẹphe shi l'alị Ijiputu wụfuta. Ọ sụru iya: ");
INSERT INTO izz_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Unu gụa ndu Ízurẹlu g'ẹphe hakọta ọgu. Gụa phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. Unwoke bẹ ii-deshikọta ẹpha phẹ nanụ nanụ. ");
INSERT INTO izz_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Gẹ gụ lẹ Erọnu tụko iphe, bụ unwoke lẹ Ízurẹlu gụkota ọgu; mbụ ndu nọwaru ụkporo apha kwasẹru; bya abụru ndu sụwaru eje ọgu. ");
INSERT INTO izz_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Unu họtachaa nwoke lanụ l'ọkpa-ipfu l'ọkpa-ipfu g'o yetarụ unu ẹka. Ndu unu a-họta bụ ndu-ishi l'ẹnya-unuphu ibe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Waa ẹpha ndu ono, unu a-họta g'ẹphe yeru unu ẹka ọbu baa: “Onye unu a-họta l'ọkpa-ipfu Rúbẹnu bụ Elizuru nwa Shediyọ. ");
INSERT INTO izz_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","“Onye unu a-họta l'ọkpa-ipfu Simiyọnu bụru Shelumẹlu nwa Zurishadayi. ");
INSERT INTO izz_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","“Onye unu a-họta l'ọkpa-ipfu Jiuda bụru Náshọnu nwa Amínadabu. ");
INSERT INTO izz_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","“Onye unu a-họta l'ọkpa-ipfu Isaka bụru Netanẹlu nwa Zuwa. ");
INSERT INTO izz_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","“Onye unu a-họta l'ọkpa-ipfu Zebulọnu bụru Eliyabu nwa Helọnu. ");
INSERT INTO izz_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","“A -bya l'ọkpa-ipfu k'ụnwu Jiósẹfu; onye unu a-họta l'ọkpa-ipfu Ifuremu bụ Elishama nwa Amihudu. Unu ahọta Gamalẹlu nwa Pedazọ l'ọkpa-ipfu kẹ Manásẹ. ");
INSERT INTO izz_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","“Onye unu a-họta l'ọkpa-ipfu Benjiaminu bụru Abidanu nwa Gidiyọni. ");
INSERT INTO izz_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","“Onye unu a-họta l'ọkpa-ipfu Danu bụru Ahiyeza nwa Amishadayi. ");
INSERT INTO izz_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","“Onye unu a-họta l'ọkpa-ipfu Asha bụru Pagẹlu nwa Ọkuranu. ");
INSERT INTO izz_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","“Onye unu a-họta l'ọkpa-ipfu Gadu bụru Ẹliyasafu nwa Diyuwẹlu. ");
INSERT INTO izz_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","“Onye unu a-họta l'ọkpa-ipfu Nafụtali bụru Ahira nwa Enanu.” ");
INSERT INTO izz_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ndu ono bẹ bụ unwoke, a họtaru lẹ Ízurẹlu l'ophu. Ẹphe bụkota ndu-ishi l'ọkpa-ipfu, shi lẹ ndiche phẹ; bya abụchaaru ishi l'ẹnya-unuphu, dụ lẹ Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mósisu yẹle Erọnu bya achịta ndu ono, a gụshiru ẹpha phẹ ono; ");
INSERT INTO izz_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ẹphe kukọbe ndu Ízurẹlu g'ẹphe ha; deshia ẹpha phẹ l'ẹkwo l'abalị mbụ l'ọnwa k'ẹbo ono. Ẹphe deshiru ẹpha onyemonye l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. Iphe, bụkpoo unwoke, nọwaru ụkporo apha kwasẹru bẹ e dekọtaru ẹpha phẹ nanụ nanụ; ");
INSERT INTO izz_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ẹgube ono, Chipfu sụru Mósisu g'o mee ya ono. Ọo ya bụ; Mósisu gụa ndu Ízurẹlu ọgu l'echiẹgu Sayịnayi. ");
INSERT INTO izz_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","A -bya l'oshilọkpa Rúbẹnu, bụ ọkpara Ízurẹlu; iphe, bụkota unwoke, nọwaru ụkporo apha kwasẹru; mbụ ndu sụwaru eje ọgu bẹ a gụkotaru; deshikọta ẹpha phẹ nanụ nanụ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Iphe, a gụtaru l'ipfu Rúbẹnu bẹ bụ ụkporo ụnu nemadzụ mgbo ise l'ụnu iri l'ishii l'ụkporo ụmadzu ise. ");
INSERT INTO izz_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Oshilọkpa Simiyọnu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ nanụ nanụ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Iphe, a gụtaru l'ipfu Simiyọnu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa l'ụnu ẹsato l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Oshilọkpa Gadu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ nanụ nanụ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Iphe, a gụtaru l'ipfu Gadu bẹ dụ ụkporo ụnu nemadzụ mgbo ise l'ụnu iri l'ẹno l'ụmadzu ụkporo labọ l'iri. ");
INSERT INTO izz_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Oshilọkpa Jiuda bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ nanụ nanụ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Iphe, a gụtaru l'ipfu Jiuda bẹ dụ ụkporo ụnu nemadzụ mgbo tete l'ụnu ishii l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Oshilọkpa Isaka bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Iphe, a gụtaru l'ipfu Isaka bẹ dụ ụkporo ụnu nemadzụ mgbo ishii l'ụnu iri l'ishii. ");
INSERT INTO izz_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Oshilọkpa Zebulọnu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Iphe, a gụtaru l'ipfu Zebulọnu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa l'ụnu ẹto l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","A -bya l'oshilọkpa Jiósẹfu; mbụ awa Ifuremu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Iphe, a gụtaru l'ipfu Ifuremu bẹ dụ ụnu nemadzụ ụkporo ise l'ụnu lanụ l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Awa Manásẹ bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Iphe, a gụtaru l'ipfu Manásẹ bẹ dụ ụkporo ụnu nemadzụ mgbo ẹno l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","A -bya l'oshilọkpa Benjiaminu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Iphe, a gụtaru l'ipfu Benjiaminu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹno l'ụnu ẹsato l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Oshilọkpa Danu bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Iphe, a gụtaru l'ipfu Danu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa l'ụnu iri l'ishii l'ụmadzu ụkporo iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Oshilọkpa Asha bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Iphe, a gụtaru l'ipfu Asha bẹ dụ ụkporo ụnu nemadzụ mgbo ise l'ụnu ẹto l'ụmadzu ụkporo iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Oshilọkpa Nafụtali bẹ a gụkotaru iphe, bụ unwoke, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru eje ọgu; bya edeshia ẹpha phẹ l'ẹkwo. E deshiru ẹpha phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Iphe, a gụtaru l'ipfu Nafụtali bẹ dụ ụkporo ụnu nemadzụ mgbo ishii l'ụnu iri l'ẹto l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ndu ono bẹ bụ ndu Mósisu yẹle Erọnu gụru ọgu. Ndu yetarụ phẹ ẹka gụa ọgu ono bụ ndu-ishi ndu Ízurẹlu ụmadzu iri l'ẹbo ono, nọ-chigbaaru ẹnya-unuphu unuphu phẹ ono. ");
INSERT INTO izz_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Iphe, bụ unwoke Ízurẹlu l'ophu, nọwaru ụkporo apha kwasẹru, bụ ndu sụwaru ejeru ndu Ízurẹlu ọgu bẹ a gụkotaru l'ẹnya-unuphu phẹ l'ẹnya-unuphu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Mkpakọ iphe, ẹphe dụ g'ẹphe ha bẹ bụ ụkporo ụnu nemadzụ mgbo ụkporo ẹto l'ụmadzu ụkporo iri l'ise; l'ụnu ụmadzu ẹsato; l'ụmadzu ụkporo iri l'ẹsaa; l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ọle ipfu Lívayi bẹ a ta gụduru teke a gụru ndu Ízurẹlu ọphuna. ");
INSERT INTO izz_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","O noo kẹle Chipfu bẹ sụru Mósisu lẹ-a: ");
INSERT INTO izz_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ndu ị tịi gụdu kpoloko bụ ipfu Lívayi. Ta gụkobekwa phẹ mẹ ị gụje ndu Ízurẹlu ọphuna. ");
INSERT INTO izz_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Iphe, l'ii-mechia bụ g'ị họta ndu Lívayi ono g'ẹphe letajẹ ẹnya l'ụlo-ẹkwa, eedobeje ẹkwo-ekemu Chileke; ẹphe eletajẹ ẹnya l'ivu, dụ iya nụ; mẹ iphemiphe, bụ iphe, adụje l'ụlo-ẹkwa ono. Ọo ẹphebedua bẹ a-nọduje apa ụlo-ẹkwa ono; mẹ iphe, bụ ivu, dụkota iya nụ. Ọ bụru phẹ a-nwụberu iya ẹnya; ẹphe egudeje ụlo-ẹkwa nkephẹ kpọ-phee ụlo-ẹkwa ono mgburugburu. ");
INSERT INTO izz_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Iphe, bụ teke ụlo-ẹkwa ono abya atụgbu; g'ọ bụru ndu Lívayi bẹ a-phọ-tsutajẹ iya. Iphe, bụ teke aakpọbe ụlo-ẹkwa ono; g'ọ bụkwarupho ndu Lívayi bẹ a-kpọbeje iya nụ. Onye ọzo mmanụ, jekuberu iya ntse bẹ ee-gbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ndu Ízurẹlu a-kpọbeje ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo. Iphe, bụ nwoke nọnu a-kpọbeje ụlo-ẹkwa iya l'ọnu-ogo nkephẹ l'ẹka ẹphe kpọberu ẹkwa-ọhubama ipfu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Obenu lẹ ndu Lívayi bẹ e-gude ụlo-ẹkwa nkephẹ kpọ-pheta ụlo-ẹkwa ono, eedobeje ẹkwo-ekemu Chileke mgburugburu; k'ọphu Chileke ẹta atụ-koshidu edzudzu-ọha Ízurẹlu oke ẹhu-eghu iya. Ọo ndu Lívayi bẹ a-nọdu eleta ụlo-ẹkwa ẹka eedobeje ẹkwo-ekemu Chileke ono ẹnya.” ");
INSERT INTO izz_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Tọbudu iya bụ; ndu Ízurẹlu mekọtaepho iphemiphe ono ẹgube ono, Chipfu sụru Mósisu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Chipfu bya epfuaru Mósisu waa Erọnu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Gẹ ndu Ízurẹlu kpọbeje ụlo-ẹkwa phẹ g'ọ gha iphu l'ụlo-ẹkwa-ndzukọ. Ẹphe ebuphee ụlo-ẹkwa-ndzukọ ono mgburugburu. G'onyenọnu kpọbejekwa ụlo-ẹkwa nkiya l'ọnu-ogo nkephẹ l'ẹka ndu ẹnya-unuphu phẹ kpọberu ẹkwa-ọhubama phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Ndu Jiuda bụ ẹphebedua a-kpọbe ụlo-ẹkwa nkephẹ l'ụzo ẹnyanwu-awawa; l'ọnu-ogo l'ọnu-ogo; l'ẹka ipfu ono kpọberu ẹkwa-ọhubama phẹ. Onye a-bụru ishi ndu Jiuda bụ Náshọnu nwa Amínadabu. ");
INSERT INTO izz_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Iphe, a gụtaru l'ipfu Jiuda ono bẹ dụ ụkporo ụnu nemadzụ mgbo tete l'ụnu ishii l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Ndu a-kpọbe ụlo-ẹkwa nkephẹ tsota phẹ bẹ bụ ndu ipfu kẹ Isaka. Onye a-bụru ishi l'oshilọkpa Isaka bụ Netanẹlu nwa Zuwa. ");
INSERT INTO izz_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Iphe, a gụtaru l'ipfu Isaka bẹ dụ ụkporo ụnu nemadzụ mgbo ishii l'ụnu iri l'ishii. ");
INSERT INTO izz_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“Ndu ọzo, a-kpọbe nkephẹ tsota phẹ bẹ bụ ndu ipfu kẹ Zebulọnu. Onye a-bụru ishi l'oshilọkpa Zebulọnu bụ Eliyabu nwa Helọnu. ");
INSERT INTO izz_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Iphe, a gụtaru l'ipfu Zebulọnu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa l'ụnu ẹto l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“Ipfu ono, a họtaru g'ẹphe l'ipfu Jiuda kpọ-kube ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo ono bẹ tụkoru dụ ụkporo ụnu nemadzụ mgbo ụkporo l'ụnu ishii. Ọ bụru ẹphebedua e-vutajẹ ụzo; ndu ọzo etso phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Ndu ọphu a-kpọbe ụlo-ẹkwa ebubu nkephẹ l'ụzo ndọhali bẹ bụ ipfu Rúbẹnu bẹ a-kpọbe iya l'ọnu-ogo l'ọnu-ogo. Onye a-bụru ishi l'oshilọkpa Rúbẹnu bụ Elizuru nwa Shediyọ. ");
INSERT INTO izz_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Iphe, a gụtaru l'ipfu Rúbẹnu bẹ dụ ụkporo ụnu nemadzụ mgbo ise l'ụnu iri l'ishii l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Ndu a-kpọbe ụlo-ẹkwa nkephẹ tsota ipfu Rúbẹnu bẹ bụ ipfu kẹ Simiyọnu. Onye a-bụru ishi l'oshilọkpa Simiyọnu bụ Shelumẹlu nwa Zurishadayi. ");
INSERT INTO izz_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Iphe, a gụtaru l'ipfu Simiyọnu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa l'ụnu ẹsato l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“Ndu ọphu a-kpọbe nkephẹ tsota phẹ bẹ bụ ipfu Gadu. Onye a-bụru ishi l'oshilọkpa Gadu bụ Ẹliyasafu nwa Diyuwẹlu. ");
INSERT INTO izz_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Iphe, a gụtaru l'ipfu Gadu bẹ dụ ụkporo ụnu nemadzụ mgbo ise l'ụnu iri l'ẹno l'ụmadzu ụkporo labọ l'iri. ");
INSERT INTO izz_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“Ipfu ono, a họtaru g'ẹphe l'ipfu Rúbẹnu kpọ-kube ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo ono bẹ tụkoru dụ ụkporo ụnu nemadzụ mgbo iri l'ẹsato l'ụnu iri l'ẹsato; l'ụkporo ụmadzu iri l'ẹbo l'ụmadzu iri. Ọ bụru ẹphebedua bụ ndu k'ẹbo, a-palihuje mẹ a -gbẹshi ije. ");
INSERT INTO izz_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Ọo ya bụ; ndu Lívayi evuta ụlo-ẹkwa-ndzukọ nọdu l'echilabọ ndu ipfu ono tụgbushia. Ọo ẹpho g'ẹphe gude kpọo ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo ono bụ g'ẹphe e-gudeje gbẹshi ije phẹ. Ndu nọnu ẹphe apagbaaru ẹkwa-ọhubama phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Ndu ọphu a-kpọbe ụlo-ẹkwa ebubu nkephẹ l'ụzo ẹnyanwu-arịba bẹ bụ ipfu kẹ Ifuremu; l'ọnu-ogo l'ọnu-ogo. Onye a-bụru ishi l'oshilọkpa Ifuremu bụ Elishama nwa Amihudu. ");
INSERT INTO izz_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Iphe, a gụtaru l'ipfu Ifuremu bẹ dụ ụkporo ụnu nemadzụ mgbo ise; l'ụnu nemadzụ; l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Ndu a-kpọbe ụlo-ẹkwa nkephẹ tsota ipfu Ifuremu bẹ bụ ipfu Manásẹ. Onye a-bụru ishi l'oshilọkpa Manásẹ bụ Gamalẹlu nwa Pedazọ. ");
INSERT INTO izz_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Iphe, a gụtaru l'ipfu Manásẹ bẹ dụ ụkporo ụnu nemadzụ mgbo ẹno; l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“Ndu ọphu a-kpọbe ụlo-ẹkwa nkephẹ tsota phẹ bẹ bụ ndu ipfu kẹ Benjiaminu. Onye a-bụru ishi l'oshilọkpa Benjiaminu bụ Abidanu nwa Gidiyọni. ");
INSERT INTO izz_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Iphe, a gụtaru l'ipfu Benjiaminu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹno; l'ụnu ụmadzu ẹsato; l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“Ipfu ono, a họtaru g'ẹphe l'ipfu Ifuremu kpọ-kube ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo ono bẹ tụkoru dụ ụkporo ụnu nemadzụ mgbo iri l'ẹto; l'ụnu ụmadzu iri; l'ụmadzu ụkporo ise. Ọ bụru ẹphebedua bụ ndu k'ẹto, a-palihuje mẹ a -gbẹshi ije.” ");
INSERT INTO izz_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Ndu ọphu a-kpọbe ụlo-ẹkwa ebubu nkephẹ l'ụzo isheli bẹ bụ ipfu Danu; l'ọnu-ogo l'ọnu-ogo. Onye a-bụru ishi l'oshilọkpa Danu bụ Ahiyeza nwa Amishadayi. ");
INSERT INTO izz_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Iphe, a gụtaru l'ipfu Danu bẹ dụ ụkporo ụnu nemadzụ mgbo ẹsaa; l'ụnu ụmadzu iri l'ishii; l'ụmadzu ụkporo iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Ndu l'a-kpọbe ụlo-ẹkwa nkephẹ tsota ipfu Danu bẹ bụ ipfu Asha. Onye a-bụru ishi l'oshilọkpa Asha bụ Pagẹlu nwa Ọkuranu. ");
INSERT INTO izz_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Iphe, a gụtaru l'ipfu Asha bẹ dụ ụkporo ụnu nemadzụ mgbo ise; l'ụnu ụmadzu ẹto; l'ụmadzu ụkporo iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“Ndu ọphu a-kpọbe ụlo-ẹkwa nkephẹ tsota phẹ bẹ bụ ndu ipfu Nafụtali. Onye a-bụru ishi l'oshilọkpa Nafụtali bụ Ahira nwa Enanu. ");
INSERT INTO izz_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Iphe, a gụtaru l'ipfu Nafụtali bẹ dụ ụkporo ụnu nemadzụ mgbo ishii; l'ụnu ụmadzu iri l'ẹto; l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“Ipfu ono, a họtaru g'ẹphe l'ipfu Danu kpọ-kube ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo ono bẹ tụkoru dụ ụkporo ụnu nemadzụ mgbo iri lẹ tete; l'ụnu ụmadzu iri l'ẹno. Ọ bụru ẹphebedua bẹ e-kpejeru azụ l'ije phẹ ono; pagbaarụ ẹkwa-ọhubama phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ndu ono bẹ bụ ndu Ízurẹlu; g'e gude gụa phẹ ọgu l'ẹnya-unuphu phẹ l'ẹnya-unuphu phẹ. Mkpakọ ndu nọkota l'ẹka a kpọberu ụlo-ẹkwa, bụ ndu a gụru ọgu l'ọnu-ogo l'ọnu-ogo bẹ dụ ụkporo ụnu nemadzụ mgbo ẹto; l'ụkporo ụmadzu iri l'ise; l'ụnu ụmadzu ẹsato; l'ụmadzu ụkporo iri l'ẹsaa; l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ọle ndu Lívayi bẹ a ta gụkobeduru lẹ ndu Ízurẹlu ọphuu; ọ bụru ẹgube ono bẹ Chipfu sụru Mósisu g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ọo ya bụ; ndu Ízurẹlu mekọtaepho iphemiphe, Chipfu tụru Mósisu ekemu iya. Ọ bụru ẹgube ono bẹ ẹphe kpọbechaaru ụlo-ẹkwa phẹ l'ọnu-ogo l'ọnu-ogo; pfụbechaa ya ẹkwa-ọhubama phẹ. Nokwaphọ g'ẹphe eshije gbẹshi tụgbua; ndu ọphu nọnu ẹphe lẹ ndu ọnu-ụlo nkephẹ; mẹ ndu ẹnya-unuphu nkephẹ. ");
INSERT INTO izz_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ọwaa bụ oshilọkpa Erọnu yẹle Mósisu lẹ teke ono, Chipfu pfuru yeru Mósisu l'úbvú Sayịnayi phọ: ");
INSERT INTO izz_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ẹpha ụnwu Erọnu bẹ bụ Nadabu, bụ iya bụ ọkpara iya; waa Abihu; mẹ Eleyaza; waa Itama. ");
INSERT INTO izz_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Noo ẹpha ụnwu Erọnu, bụ ndu a wụru manụ l'ishi; mbụ ndu ono, a họtaru dobe g'ẹphe bụru ndu-uke Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ọle Nadabu yẹle Abihu bẹ daru l'atatiphu Chipfu nwụshihu; kẹle ẹphe gude ọku, ta adụdu nsọ kpọoru Chipfu ngwẹja ọku l'echiẹgu Sayịnayi. Ọphu ẹphe emetadụru ụnwegirima; ọ bụru Eleyaza yẹle Itama bẹ jeahaarụ ozi ndu-uke Chileke lẹ teke ono, nna phẹ, bụ Erọnu nọkwaduro ndzụ. ");
INSERT INTO izz_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ọo ya bụ Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Chịta ipfu Lívayi jeye l'ẹka Erọnu, bụ onye uke Chileke; k'ọphu ẹphe a-nọdu ejebude iya ozi. ");
INSERT INTO izz_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ẹphe a-nọdu ejeru Erọnu ozi; bya ejeru ndu Ízurẹlu l'ophu ozi l'ụlo-ẹkwa-ndzukọ; mbụ l'ẹphe a-nọdu eje ozi, rwuberu phẹ nụ l'ụlo Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ẹphe a-nọduje eleta ivu, dụ l'ụlo-ẹkwa-ndzukọ ono ẹnya; shi nno ejeru ndu Ízurẹlu ozi, rwuberu phẹ nụ l'ụlo Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tụko ndu Lívayi l'ophu ye Erọnu yẹle ụnwu iya l'ẹka; mbụ l'a họfutawaru phẹ g'ẹphe hakọta l'echilabọ ndu Ízurẹlu l'ophu woru ye iya l'ẹka. ");
INSERT INTO izz_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","L'ị tụa Erọnu mẹ ụnwu iya ẹka g'ẹphe bụru ndu-uke Chileke. Iphe, bụ onye ọzo mmanụ, jekuberu mgboru ụlo-nsọ ono bẹ ee-gbu egbugbu.” ");
INSERT INTO izz_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Chipfu byakwa epfuaru Mósisu ọzo sụ iya: ");
INSERT INTO izz_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lenu; mu shiwaa l'echilabọ ndu Ízurẹlu họta ndu Lívayi g'ẹphe nọchia ẹnya iphe, bụ ọkpara; mbụ iphe, bụ nwoke, vu ụzo waa ne iya ẹkpa-nwa lẹ Ízurẹlu. Ọo ya bụ lẹ ndu Lívayi bẹ bụ nkemu; ");
INSERT INTO izz_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","noo kẹle ndu bụkota ọkpara bụ nkemu. Mbọku ono, mu gbushiru ndu bụ ọkpara l'alị Ijiputu ono bẹ mu wotaru iphe, bụ ọkpara ndu Ízurẹlu; doberu onwomu; mbụ e shikpọo lẹ nemadzụ je akpaa l'anụ. Ẹphe a-bụru nkemu. Ọo mbẹdua bẹ bụ Chipfu.” ");
INSERT INTO izz_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","No iya; Chipfu bya epfuru yeru Mósisu l'echiẹgu Sayịnayi sụ iya: ");
INSERT INTO izz_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Gụa ndu Lívayi ọgu; gụa phẹ l'ẹnya-unuphu l'ẹnya-unuphu; mẹ l'ọnulo l'ọnulo. Ndu ịi-gụ bẹ bụ unwoke, nọwaru a -gbẹ l'ọnwa lanụ kwasẹru.” ");
INSERT INTO izz_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Tọbudu iya bụ; Mósisu gụa phẹ ẹgube ono, Chipfu pfuru iya ya ono. ");
INSERT INTO izz_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Waa ẹpha ụnwu Lívayi baa: Geshọnu; mẹ Kohatu; waa Merari. ");
INSERT INTO izz_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ọwaa bụ ẹpha ụnwu Geshọnu l'ẹnya-unuphu phẹ l'ẹnya-unuphu phẹ: Libuni waa Shimeyi. ");
INSERT INTO izz_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ụnwu kẹ Kohatu l'ẹnya-unuphu phẹ l'ẹnya-unuphu phẹ bẹ bụ Amụramu; mẹ Izuha; mẹ Hẹburonu; waa Uzẹlu. ");
INSERT INTO izz_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ụnwu kẹ Merari l'ẹnya-unuphu phẹ l'ẹnya-unuphu phẹ bẹ bụ Mahuli waa Mushi. Ndu ono tụkoru bụru ipfu Lívayi; ẹgube ẹphe dụ l'ẹnya-unuphu l'ẹnya-unuphu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ụnwu Geshọnu bụ ndu ọnu-ụlo Libuni waa ndu ọnu-ụlo Shimeyi. Ọ bụru phẹ bụ ndu ọnu-ụlo Geshọnu. ");
INSERT INTO izz_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Unwoke, nọwaru ọnwa lanụ kwasẹru l'ọnulo Geshọnu bẹ dụ ụnu nemadzụ iri l'ẹsato; l'ụmadzu ụkporo iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ndu ọnu-ụlo Geshọnu bẹ akpọbeje ụlo-ẹkwa ebubu phẹ l'ụzo ẹnyanwu-arịba; l'azụ ụlo-ẹkwa Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Onye bụ ishi l'ọnulo Geshọnu bụ Ẹliyasafu nwa Layẹlu. ");
INSERT INTO izz_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ozi, e yeru ụnwu Geshọnu ono l'ẹka g'ẹphe jeje l'ụlo-ẹkwa-ndzukọ ono bụ eleta ụlo-ẹkwa Chileke ẹnya; waa ẹkwa, e gude kpua ya; mẹ eleta ẹkwa, e gude gbobuta ọnu-abata ụlo-ẹkwa-ndzukọ ono ẹnya; ");
INSERT INTO izz_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","mẹ eleta ẹkwa, e gude gbobuta ọma-unuphu; waa ẹkwa, e gude gbobuta ọnu-abata ọma-unuphu ono, nọ-pheru ụlo-ẹkwa Chileke ono; waa ọru-ngwẹja mgburugburu; mẹ eleta ụdo ẹnya; waa iphe, bụkpoo ozi, gbaru phẹ nụ. ");
INSERT INTO izz_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ụnwu Kohatu bụ ndu ọnu-ụlo Amụramu; mẹ ndu ọnu-ụlo Izuha; mẹ ndu ọnu-ụlo Hẹburonu; mẹ ndu ọnu-ụlo Uzẹlu. Ọ bụru phẹ bụ ndu ọnu-ụlo Kohatu. ");
INSERT INTO izz_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Unwoke, nọwaru ọnwa lanụ kwasẹru lẹ ndu ọnu-ụlo Kohatu bẹ dụ ụkporo ụnu nemadzụ; l'ụnu ụmadzu lanụ; l'ụmadzu ụkporo iri. Ọ bụru phẹ bẹ ọ dụru; mbụ ozi, eeje l'ụlo dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ndu ọnu-ụlo Kohatu bẹ akpọbeje ụlo-ẹkwa ebubu phẹ l'ụzo ndọhali ụlo-ẹkwa Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Onye bụ ishi l'ọnulo Kohatu bụ Elizafanu nwa Uzẹlu. ");
INSERT INTO izz_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ozi, dụru phẹ nụ bụ eleta okpoko Chileke ẹnya; mẹ teburu; mẹ iphe, aapfụbeje orọku; mẹ ọru-ngwẹja; mẹ ivu, dụ l'ụlo-nsọ, ndu-uke egudeje eje ozi; mẹ ẹkwa, e gude gbobuta ẹka-kakọta-adụ-nsọ; waa iphe, bụkpoo ozi ọzo, gbaru phẹ nụ. ");
INSERT INTO izz_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Onye-ishi ndu-ishi ndu Lívayi l'ophu bụ Eleyaza nwa Erọnu, bụ onye uke Chileke. Ọo yẹbedua bẹ a họtaru g'ọ bụru onye-ishi ndu eleta ẹnya l'ụlo-nsọ ono. ");
INSERT INTO izz_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ụnwu kẹ Merari bẹ bụ phẹ bụ ndu ọnu-ụlo Mahuli waa ndu ọnu-ụlo Mushi. Ọ bụru ndu ono bụ ọnu-ụlo Merari. ");
INSERT INTO izz_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Unwoke, nọwaru ọnwa lanụ kwasẹru lẹ ndu ọnu-ụlo Merari dụ ụnu nemadzụ iri l'ise l'ụmadzu ụkporo iri. ");
INSERT INTO izz_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Onye bụ ishi l'ọnulo Merari ono bụ Zuriyẹlu nwa Abihelu. Ndu ọnu-ụlo Merari akpọbeje ụlo-ẹkwa ebubu phẹ l'ụzo isheli ụlo-ẹkwa Chileke. ");
INSERT INTO izz_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ozi, e yeru ụnwu Merari l'ẹka k'ejeje bụ: eleta mgbo ụlo-ẹkwa Chileke ono ẹnya; mẹ oshi, e swebushiru lẹ mgbo ono; mẹ itso iya; mẹ ẹnya ẹka aakpọbeje ọkpa mgbo ono; waa itso ono; mẹ iphe, bụ ngwa, dụkota iya nụ; waa ozi ọzo, gbaru phẹ nụ. ");
INSERT INTO izz_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Ozi ọzo, e yeru phẹ l'ẹka g'ẹphe jeje bụ: eleta ẹnya l'itso, e gude kpọ-pheta ọma-unuphu ono mgburugburu; mẹ ọkpa iya; mẹ nggu, a kpọru l'ụlo-ẹkwa Chileke ono; mẹ eri, e kegbaaru iya. ");
INSERT INTO izz_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ndu bụ phẹ a-kpọbeje ụlo-ẹkwa ebubu nkephẹ l'ụzo ẹnyanwu-awawa ụlo-ẹkwa Chileke; mbụ l'atatiphu ụlo-ẹkwa-ndzukọ ono; bẹ bụ Mósisu; yẹle Erọnu; mẹ ụnwu Erọnu. Ọo phẹ e-jekọtaje iphe, bụ ozi, eeje ejeje l'ụlo Chipfu. Onye ọzo mmanụ, jekuberu mgboru ụlo Chipfu bẹ ee-gbu egbugbu. ");
INSERT INTO izz_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Iphe, bụ ndu a gụru ọgu l'ipfu Lívayi; mbụ ndu Mósisu yẹle Erọnu gụru ọgu l'ọnulo l'ọnulo, bụ gẹ Chipfu sụru g'ẹphe mee ya; mbụ unwoke, nọwaru ọnwa lanụ kwasẹru bẹ dụ ụkporo ụnu nemadzụ mgbo labọ l'ụnu iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Chipfu bya asụ Mósisu: “Gụkota unwoke, bụ ọkpara l'alị Ízurẹlu l'ophu ọgu; mbụ unwoke, nọwaru a -gbẹ l'ọnwa lanụ kwasẹru; woru ẹpha phẹ deshia. ");
INSERT INTO izz_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","L'i woru ndu Lívayi doberu mụbe Chipfu iche; g'ẹphe nọdu l'ụgwo ndu bụ ọkpara l'ụlo l'ụlo lẹ Ízurẹlu. L'i woru anụ, bụ iphe-edobe ndu Lívayi ono doberu mu; g'ẹphe nọdu l'ụgwo anụ, vuru ụzo waa ẹkpa-nwa l'iphe-edobe ndu Ízurẹlu l'ophu.” ");
INSERT INTO izz_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ọo ya bụ; Mósisu gụa iphe, bụ ọkpara l'alị Ízurẹlu l'ophu ọgu; ẹgube ono, Chipfu sụru g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mkpakọ ndu bụ ọkpara l'iphe, bụ unwoke l'alị Ízurẹlu l'ophu; mbụ unwoke, nọwaru a -gbẹ l'ọnwa lanụ kwasẹru bẹ dụ ụkporo ụnu nemadzụ mgbo labọ; l'ụnu iri l'ise; l'ụmadzu ụkporo iri l'ẹto; l'ụmadzu iri l'ẹto. A gụru phẹ ọgu; deshia ẹpha phẹ l'ẹkwo. ");
INSERT INTO izz_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tọbudu iya bụ; Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Woru ndu Lívayi doberu mu iche; g'ẹphe nọdu l'ụgwo ndu bụ ọkpara l'ụlo l'ụlo lẹ Ízurẹlu. L'i woru anụ, bụ iphe-edobe ndu Lívayi ono doberu mu; g'ẹphe nọdu l'ụgwo anụ, vuru ụzo waa ẹkpa-nwa l'iphe-edobe ndu Ízurẹlu l'ophu. Ọ kwa mbẹdua bẹ bụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A -bya abya l'ụkporo ụmadzu iri l'ẹto l'ụmadzu l'iri l'ẹto ono, bụ iphe, ọkpara ndu Ízurẹlu gude ka oshilọkpa Lívayi shii ono; iphe, aa-pfụ gude gbata phẹ bẹ bụ ");
INSERT INTO izz_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","mkpọla-ọchaa, ẹrwa iya dụ shẹkelu ise, bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ẹrwa shẹkelu lanụ bụ ụkporo gera. Ụgwo ono bẹ aa-pfụ l'ishi onye l'onye. ");
INSERT INTO izz_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","L'i woru okpoga ono, ee-gude gbata ụmadzu ole ono, ẹphe gude ka ndu Lívayi shi ono nụ Erọnu yẹle ụnwu iya.” ");
INSERT INTO izz_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ọo ya bụ; Mósisu nakọo okpoga ono, ee-gude gbata ndu ono; l'ẹka ndu ono, a gụru ọgu; ẹphe ka ndu Lívayi shii ono. ");
INSERT INTO izz_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Iphe, Mósisu natakọtaru l'ẹka ndu bụ ọkpara l'alị Ízurẹlu bẹ bụ mkpọla-ọchaa, ẹrwa iya dụ ụnu shẹkelu ẹto; l'ụkporo shẹkelu ẹsato lẹ shẹkelu ise, bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. ");
INSERT INTO izz_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mósisu wota okpoga-agbafụta ono nụ Erọnu yẹle ụnwu iya; ẹgube ono, Chipfu tụru iya ya l'ekemu. ");
INSERT INTO izz_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Chipfu bya epfuru yeru Mósisu yẹle Erọnu; sụ phẹ: ");
INSERT INTO izz_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Unu gụa ụnwu Kohatu, bụ ndu shi l'eri Lívayi ọgu. Unu gụa phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ndu unu a-gụ bẹ bụ iphe, bụ unwoke, nọwaru ụkporo apha l'apha iri je akpaa l'ụkporo apha labọ l'apha iri; mbụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ozi, ụnwu Kohatu a-nọdu eje l'ụlo-ẹkwa-ndzukọ ono bụ: eleta iphe, kakọta adụ nsọ ẹnya. ");
INSERT INTO izz_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ndu Ízurẹlu -nọdu abya aphọta ụlo-ẹkwa phẹ tụgbua; gẹ Erọnu yẹle ụnwu iya bahụ l'ime ụlo-ẹkwa-ndzukọ je atọfuta ẹkwa, eegudeje gbobuta ẹka-kakọta-adụ-nsọ; gude iya phụ-chia okpoko-ekemu. ");
INSERT INTO izz_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ọo ya bụ; ẹphe ewota akpọ umoro-ẹnyimu phụ-kputa iya; gude ẹkwa, dụkota urwukpu-urwukpu phụa ya l'eli; bya eworu mgbọro, eegudeje ẹka apa iya ye iya. ");
INSERT INTO izz_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“L'eli teburu phọ, eedobeje buredi ono, adụje l'iphu Chipfu ono bẹ ee-kwebeje ẹkwa, dụ urwukpu-urwukpu; l'e wota gbamụgbamu tụ-kobe iya l'eli; mẹ ite; mẹ nkwẹka; waa okoro, ngwẹja-mẹe adụje. Aatụ-kobekwa iya phọ buredi ono, adụje l'atatiphu Chileke mkpụrumkpuru ono. ");
INSERT INTO izz_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ẹphe abya eworu ẹkwa uswe-uswe tụsaa l'eli iphemiphe ono; kwechita iya akpọ umoro-ẹnyimu; wota mgbọro, eegudeje ẹka apa iya ye iya. ");
INSERT INTO izz_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ẹphe abya egude ẹkwa, dụ urwukpu-urwukpu kwechia iphe, aatukobeje orọku, e gude anwụ ọku; gude iya kwechia orọku l'onwiya; mẹ iphe, apajẹ oghu iya; mẹ iphe, aagụje ọku; mẹ iphemiphe, eeyeje manụ, e gude anwụ ọku. ");
INSERT INTO izz_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ọo ya bụ; ẹphe egude akpọ umoro ẹnyimu phụ-kputa iphemiphe ono; mẹ ivu, dụkota iya nụ; woru dọbe l'eli iphe, aa-dọbeje iya gude apa iya. ");
INSERT INTO izz_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ẹphe a-phụshi ẹkwa, dụ urwukpu-urwukpu l'eli ọru-ngwẹja ono, e meru lẹ mkpọla-ododo ono; gude akpọ umoro ẹnyimu kwechia ya; woru mgbọro, eegudeje apa iya ye iya. ");
INSERT INTO izz_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ẹphe ewotakọta iphe, bụ ivu, eegudeje eje ozi l'ụlo Chipfu; gude ẹkwa, dụ urwukpu-urwukpu kekọbe iya; bya egude akpọ umoro ẹnyimu kwechita iya; woru iya tukobe l'eli iphe, eegudeje apa iya. ");
INSERT INTO izz_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ẹphe e-kpofu ntụ, nọ l'ọru-ngwẹja ono; woru ẹkwa oruswe oruswe tụsaa l'eli iya. ");
INSERT INTO izz_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Noo ya; ẹphe ewota iphe, bụ ivu, eegudeje eje ozi l'ọru-ngwẹja ono; tukobe l'eli ẹkwa oruswe oruswe ono. Mbụ l'ẹphe a-tukobe iya iphe, aagụje ọku; mẹ oji; mẹ iphe, eegudeje ekpo ntụ; mẹ gbamụgbamu. Iphemiphe ono bẹ ee-kwechita akpọ umoro ẹnyimu; woru mgbọro, eegudeje apa iya ye iya. ");
INSERT INTO izz_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Erọnu yẹle ụnwu iya -kwechishigbuchaẹpho ụlo Chipfu; mẹ ivu, dụ iya nụ; ndu Ízurẹlu -byaẹpho aphọta ụlo-ẹkwa phẹ tụgbua; g'ọ bụru ụnwu Kohatu e-vuta iphe ono. Ọle ọo g'ẹphe te edenyikwa ẹka l'iphe, dụ nsọ; ọdumeka bẹ ẹphe a-nwụhukwa. Ọo ụnwu Kohatu bẹ e-vutajẹ iphe ono, dụ l'ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleyaza nwa Erọnu, bụ onye uke Chileke bẹ kẹ manụ, eegudeje anwụ ọku dụ l'ẹka; mẹ ụ̀nwù-isẹnsu, anọduje eshi mkpọ; mẹ ngwẹja-nri, eegweje mbọkumboku; mẹ manụ, aawụje l'ishi. Ọo yẹbedua bẹ a-nọdu eleta ụlo-ẹkwa Chileke l'ophu ẹnya; mẹ iphemiphe, dụ iya nụ; mbụ ụlo Chipfu; mẹ ivu, dụkota iya nụ.” ");
INSERT INTO izz_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Chipfu sụ Mósisu yẹle Erọnu: ");
INSERT INTO izz_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Unu te ekwekwa g'ọnulo Kohatu chịhu l'ipfu ndu Lívayi. ");
INSERT INTO izz_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Waa iphe, unu e-meru phẹ; k'ọphu ẹphe a-nọdu ndzụ; ẹphe taa nwụhudu m'ẹphe jekube iphe, kakọta-adụ-nsọ ntse baa: G'ọ bụru Erọnu yẹle ụnwu iya a-bahụje l'ime ụlo Chipfu je akaru onyenọnu ozi ọphu oo-je; mẹ ivu, oo-vuta. ");
INSERT INTO izz_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ọle g'oshilọkpa Kohatu ta abahụkwa je ele ẹnya l'iphe, dụ nsọ ono; m'obeta ọ bụru g'ọ chaa ya ẹnya achacha mgbo lanụ; ọdumeka bẹ ẹphe a-nwụshihukwa.” ");
INSERT INTO izz_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gụkwaapho ụnwu Geshọnu ọgu. Gụa phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ndu ịi-gụ bụ iphe, bụ unwoke, nọwaru ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri; mbụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Iphe, a-bụru ozi ndu ọnu-ụlo Geshọnu l'ozi, eeje ejeje l'ụlo-ẹkwa-ndzukọ; mẹ iphe, eevu evuvu bẹ bụ: ");
INSERT INTO izz_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ẹphe e-vutajẹ ẹkwa, e gude mee ụlo-ẹkwa Chileke; mbụ vuta ụlo-ẹkwa-ndzukọ ono, mẹ ẹkwa, e gude kpua ya; mẹ akpọ umoro-ẹnyimu, e gude kwechia ya; mẹ ẹkwa, eegudeje gbobuta ọnu-ụlo-ẹkwa-ndzukọ; ");
INSERT INTO izz_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","mẹ ẹkwa, eekobutajẹ mgburugburu l'ọma-unuphu ono, nọ-pheru ụlo-ẹkwa Chileke ono; mẹ ọru-ngwẹja ono; waa ẹkwa, eekobutajẹ l'ọnuzo; mẹ eri, e gude gebe iya; mẹ iphe, bụkota ngwa, eegudeje eje ozi, dụ iya nụ. Ọo ndu Geshọnu ono bẹ e-gude iphe ono g'ọ ha mee iphe, ọ gbaru g'e gude iya mee. ");
INSERT INTO izz_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Iphe, bụkpoo ozi, ụnwu Geshọnu ejekpọ ejeje; obeta ọ bụru evu ivu; ọzoo eje ozi ọzo; bẹ bụ Erọnu yẹle ụnwu iya bẹ e-goshije g'ẹphe e-je iya. Ọo unubẹdua bẹ e-goshije phẹ ivu, gbaru phẹ l'evuvu. ");
INSERT INTO izz_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Noo ozi, ndu ọnu-ụlo Geshọnu a-nọduje eje l'ụlo-ẹkwa-ndzukọ bụ ono. Iphe, bụ ozi phẹ bẹ bụ Itama nwa Erọnu, bụ onye uke Chileke bẹ a-nọdu egoshije phẹ g'ẹphe e-je iya.” ");
INSERT INTO izz_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“A -bya abya l'ụnwu Merari; gụa phẹ ọgu l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ndu ịi-gụ bụ iphe, bụ unwoke, nọwaru ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri; mbụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Waa iphe, gbaru ụnwu Merari l'ememe teke ẹphe eje ozi l'ụlo-ẹkwa-ndzukọ baa: Ẹphe e-vutajẹ mgbo ụlo-ẹkwa Chileke; mẹ oshi, e swebushiru lẹ mgbo ono; mẹ itso iya; mẹ ọkpa mgbo. ");
INSERT INTO izz_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Ẹphe e-vutajẹkwapho itso, nọ-pheru ọma-unuphu mgburugburu; mẹ ọkpa itso ono; mẹ nggu, a kpọru l'ụlo-ẹkwa ono; mẹ ụdo iya; mẹwaro ivu, etsoje iya nụ g'ọ ha; waa iphemiphe, e gude eje ẹgube ozi ono. Unu ketarụ onyenọnu iphe, gbaru iya l'evuvu. ");
INSERT INTO izz_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","“Noo ozi, ndu ọnu-ụlo Merari a-nọduje eje l'ụlo-ẹkwa-ndzukọ bụ ono. Ọ bụru Itama nwa Erọnu, bụ onye uke Chileke bẹ a-nọduje egoshi phẹ g'ẹphe e-je ozi ono.” ");
INSERT INTO izz_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","No iya; Mósisu yẹle Erọnu; mẹ ndu-ishi ndu Ízurẹlu bya atụko ndu Kohatu gụkota ọgu; gụa phẹ l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ndu bụ unwoke, nọwaru shita l'ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri; mbụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ; ");
INSERT INTO izz_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","mbụ ndu a gụru l'ọnulo Kohatu bẹ dụ ụnu nemadzụ ishii; l'ụmadzu ụkporo iri l'ẹsaa l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Noo mkpakọ unwoke, a gụru ọgu l'ipfu Kohatu bụ ono; mbụ ndu jeru ozi l'ụlo-ẹkwa-ndzukọ. Mósisu yẹle Erọnu gụru ọgu ono ẹgube Chipfu tụru Mósisu ekemu g'ọ gụa ya. ");
INSERT INTO izz_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ụnwu Geshọnu bẹ a gụkwarupho ọgu l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Iphe, bụ unwoke, nọwaru shita l'ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri, bụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ ");
INSERT INTO izz_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","bẹ a gụru ọgu l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu phẹ. Iphe, a gụtaru bẹ dụ ụnu nemadzụ ishii l'ụkporo iri lẹ nanụ l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Noo mkpakọ unwoke, a gụru ọgu l'ọnulo Geshọnu; mbụ ndu sụru eje ozi l'ụlo-ẹkwa-ndzukọ teke Mósisu yẹle Erọnu gụru phẹ ọgu gẹ Chipfu tụru phẹ iya l'ekemu. ");
INSERT INTO izz_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ụnwu Merari bẹ a gụkwarupho ọgu l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Iphe, bụ unwoke, nọwaru shita l'ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri, bụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ ");
INSERT INTO izz_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","bẹ a gụru ọgu l'ọnulo l'ọnulo; gụta ụnu ụmadzu ẹsato damụ. ");
INSERT INTO izz_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Noo mkpakọ unwoke, a gụtaru l'ọnulo Merari bụ ono. Ọ bụerupho gẹ Chipfu pfuru iya Mósisu bụ gẹ Mósisu yẹle Erọnu gụru phẹ ọgu ono. ");
INSERT INTO izz_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ọo ya bụ; Mósisu yẹle Erọnu; mẹ ndu-ishi ndu Ízurẹlu gụkota ndu Lívayi l'ophu ọgu; l'ọnulo l'ọnulo; mẹ l'ẹnya-unuphu l'ẹnya-unuphu. ");
INSERT INTO izz_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ndu ẹphe gụru bẹ bụ iphe, bụ unwoke, nọwaru shita l'ụkporo apha l'apha iri jeye l'ụkporo apha labọ l'apha iri, bụ ndu sụwaru eje ozi l'ụlo-ẹkwa-ndzukọ; mẹ evu ivu. ");
INSERT INTO izz_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Iphe, ẹphe tụkoru dụ bụru ụkporo ụnu nemadzụ; l'ụnu ụmadzu lanụ; l'ụmadzu ụkporo tete. ");
INSERT INTO izz_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","E goshichaa ndu nọnu l'ẹhu l'ẹhu ozi, ẹphe a-nọduje eje; mẹ ivu, ẹphe a-nọduje evu. Ọ bụerupho gẹ Chipfu sụru Mósisu g'o mee ya bụ g'o meru iya. ");
INSERT INTO izz_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Pfuaru ndu Ízurẹlu g'ẹphe chịshia iphe, bụ ndu ekpenta eme l'ẹka ono, ẹphe kpọberu ụlo-ẹkwa ebubu phẹ ono; ẹphe achịshia ndu iphe alwashị alwashị l'ẹhu. Ẹphe achịshikwaapho ndu denyiru ẹka l'odzu; shi nno merwua onwophẹ. ");
INSERT INTO izz_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Unu chịfukota phẹ; unwoke; mẹ ụnwanyi. Unu chịshia phẹ l'ẹka ono, unu kpọberu ụlo-ẹkwa unu g'ẹphe be merwu iya; mbụ l'ẹka ono, mu bu l'echilabọ unu ono.” ");
INSERT INTO izz_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ndu Ízurẹlu mee ya ẹgube ono; bya achịshikota ndu ono l'ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ ono. Ọ bụru gẹ Chipfu pfuru iya Mósisu bụ g'ẹphe meru iya. ");
INSERT INTO izz_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Pfuaru ndu Ízurẹlu lẹ-a: Teke nemadzụ; mbụ nwoke; ọzoo nwanyị mesweru nwibe iya ẹgube ono, ndiphe emeje; mbụ shi nno meswee Chipfu; bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO izz_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Onye ọbu bẹ e-pfu iphe-ẹji ono, o meru ono. L'ọ pfụ-dzukọta ụgwo ẹjo-iphe ọbu, o meru ọbu g'ọ ha; wota ụzo lanụ l'ụzo ise l'iphe iya yekọbe iya nụ onye ono, o mesweru ono. ");
INSERT INTO izz_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ọ -bụru l'onye ono, e mesweru ono te nwedu abụbu, bụ onye aa-pfụ ụgwo iphe ono; ọo ya bụ; ụgwo ono abụru kẹ Chipfu. Onye aa-nụ iya bẹ bụ onye uke Chileke. Aakpụru ebili, e gude apfụ ụgwo iphe-ẹji yekọbe iya. ");
INSERT INTO izz_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Iphe, bụ iphe, ndu Ízurẹlu doberu nsọ g'ẹphe nụ Chipfu, bụ iphe, ẹphe wotaru bya anụ onye uke Chileke bụkota k'onye uke ono. ");
INSERT INTO izz_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Iphe, onye doberu nsọ gẹ ya nụ Chileke bẹ bụ onye uke Chileke bẹ nwe iya nụ. Iphe, bụkpoo iphe, a nụru onye uke Chileke bụru onye uke Chileke ono nwe iya.” ");
INSERT INTO izz_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Tọbudu iya bụ; Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Pfuaru ndu Ízurẹlu; sụ phẹ: Ọ -bụru lẹ nwoke bẹ nyee ya akpa njọ ụri; shi nno emeswe ji iya; ");
INSERT INTO izz_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mbụ; ọ -bụru lẹ yẹle nwoke ọzo kwarụ; o shi nno merwua onwiya; ọphu ji iya ta amadụ; tẹme ọphu egechiduru iya teke oome iya; ọphu ọ dụdu onye gbaru ekebe l'ọo iphe, o meru bụ ono; ");
INSERT INTO izz_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","mbụ; ọ -bụru lẹ nwoke ono bẹ nọnyaaru; o koaharụ nyee ya ono okophoo; leahaa ya ẹnya l'o merwuwaru onwiya; lẹ teke nwanyị ono merwuru onwiya; ọzoo l'a nọnyaaru; o koaharụ nyee ya ono okophoo; leahaa ya ẹnya l'o merwuru onwiya l'ẹbe abụ l'o merwuru onwiya; ");
INSERT INTO izz_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","gẹ nwoke ono duta nyee ya ono jepfu onye uke Chileke. L'o gude ụzo lanụ l'ime nkwẹka ukpokutu balị, e keru ụzo iri, ee-gude gwee ẹja ẹhu nyee ya ono. G'o to yekwa manụ l'ukpokutu balị ono; ọphu o yekwa iya ụ̀nwù-isẹnsu; noo kẹle ọo ngwẹja-nri, e gwerụ lẹ k'okophoo; mbụ ngwẹja, e gude anyata ẹjo-iphe. ");
INSERT INTO izz_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“G'onye uke Chileke duritaru nwanyị ono ntse g'ọ pfụru l'atatiphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ọo ya bụ; onye uke Chileke ono ekuta mini, e doberu nsọ l'ite, a kpụru l'ụrwa; kpota udzu ẹja, shi l'ọma-ụlo ụlo-ẹkwa Chileke wụru ye l'ime mini ono. ");
INSERT INTO izz_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Onye uke Chileke -pfụbechaepho nwanyị ono l'atatiphu Chipfu; l'ọotofu iya iphe, o keberu l'ishi; pata ngwẹja-nri ono, e gude anyata ẹjo-iphe ono nụ iya g'ọ parụ l'ẹka; mbụ ngwẹja-nri ono, e gwerụ lẹ k'okophoo ono. Onye uke Chileke ono l'onwiya aparu mini, atsọ ilu ono, emeje gẹ nemadzụ bụru onye a tụru ọnu ono. ");
INSERT INTO izz_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ọ bụru teke ono bẹ onye uke Chileke a-nụ nwanyị ono nte g'o ria sụ: ‘Ọ -bụru l'ọ tọ dụdu nwoke ọzo, gụ l'iya kwajẹru; ọphu ị tị kpadụru njọ ụri; shiwaa nno merwua onwongu l'ẹhu-nwoke ọzo, gbahakwa ji ngu-a; gẹ mini, atsọ ilu-a, emeje gẹ nemadzụ bụru onye a tụru ọnu-a ta adụkwa iphe, oo-me ngu. ");
INSERT INTO izz_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ọloburu l'ị nọ l'ẹka ji ngu-a; bya akpaa njọ ụri; gụ lẹ nwoke ọzo kwaa gbahakwa ji ngu-a; i shi nno merwua onwongu; ");
INSERT INTO izz_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","gẹ Chipfu mekwaa g'ẹkpa-nwa chihu ngu; mbụ g'ị tị tụ nwa l'ụtapfu; g'ị bụru onye aa-nọduje ephu l'iphu; bya anma l'ẹjo ẹtu l'ibe unu.’ Noo nte, onye uke Chileke ono a-sụ nwanyị ono g'o ria; tụa onwiya ọnu bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","‘Mbụ; gẹ mini, atsọ ilu-a, emeje gẹ nemadzụ bụru onye a tụru ọnu-a kpobakwa ngu l'ẹpho; k'ọphu ẹkpa-nwa e-chihu ngu; g'ị tị tụ nwa l'ụtapfu.’ “Ọo ya bụ; nwanyị ono asụ: ‘G'ọ dụ nụ g'i pfuru. G'ọ dụ nụ g'i pfuru.’ ");
INSERT INTO izz_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Onye uke Chileke ono abya atụko ẹjo ẹnwa ono, ọ gụru ono deshikọta l'ẹkwo; l'ọ bya asaru iphe ono, o deru ono ye lẹ mini, atsọ ilu ono. ");
INSERT INTO izz_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","L'ọ bya eworu mini, atsọ ilu ono, emeje nemadzụ g'ọ bụru onye a tụru ọnu ono nụ nwanyị ono g'ọ ngụa. Ọ -ngụe ya phọ; mini ono anọdu iya l'ẹpho; mee g'ẹjo iphe-ẹhuka, tsọhuru ilu dapfuta iya. ");
INSERT INTO izz_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Lẹ teke ono bẹ onye uke Chileke ono a-nata nwanyị ono ngwẹja-nri ono, e gwerụ lẹ k'okophoo ono, nwanyị ono pa l'ẹka ono; l'ọobya amaa ya amama l'atatiphu Chipfu; woru iya je edobe l'ọru-ngwẹja. ");
INSERT INTO izz_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Onye uke Chileke ono abya ahajia ngwẹja-nri ono mkpoji-ẹka; woru kpọo ọku l'ọru-ngwẹja ono. Ngwẹja ono a-bụru ngwẹja, e gude anyata ẹjo-iphe ono. O -mechaẹpho nno; l'ọ bya anụ nwanyị ono mini ono g'ọ ngụa. ");
INSERT INTO izz_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ọ -bụru l'o merwurwu onwiya; mbụ l'o mesweru ji iya; bẹ bụ teke a nụeru iya phọ mini ono; ọ ngụa; ọ bahụ iya l'ẹpho bẹ oo-me g'ẹjo iphe-ẹhuka, atsọ ilu dapfuta iya. Oo-me g'ẹkpa-nwa chihu iya; g'ọ tọ tụ nwa l'ụtapfu; tẹmanu ọ bụru onye vu ọnu l'ibe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Teke ọ bụ lẹ nwanyị ono bẹ te emerwụduru onwiya; mbụ-a; ọ -bụru lẹ nwanyị ono dụ ree; bẹ ọ tọ dụdu iphe, bya l'e-me iya nụ; ọo-nọdu anwụshi ụnwegirima. ");
INSERT INTO izz_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Noo ekemu, a tụru swiberu nwanyị, ji iya ekoru okophoo; mbụ nwanyị, nọ l'ẹka ji iya; ọ nọdu akpajẹ njọ ụri; emerwụshi onwiya; ");
INSERT INTO izz_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ọzoo l'a nọnyaaru nwoke koaharụ nyee ya okophoo; leahaa ya njọ ẹnya. G'onye uke Chileke pfụbe nwanyị ọbu l'iphu Chipfu mekọta iya iphemiphe ono, a tụru l'ekemu ono. ");
INSERT INTO izz_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Nwoke ono l'onwiya bẹ ta adụkwa ẹjo-iphe, a-tukoru iya l'ishi. Ọo nwanyị ono e-vuru ẹjo-iphe, o metaru kpua onwiya.” ");
INSERT INTO izz_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Pfuru yeru ndu Ízurẹlu sụ phẹ-a: O -nweru nwoke; ọzoo nwanyị, kweru ukwe, gbaru iche sụ lẹ ya a-dụru Chipfu iche; mbụ lẹ ya e-dobe onwiya gẹ ya bụru onye gbaru iche l'ẹnya Chipfu; ");
INSERT INTO izz_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","g'onye ọbu ta ngụjekwa mẹe; ọzoo iphe, aangụ angụngu, atsụ atsụtsu. Ọphu ọ ngụjekwa mẹe-venịga; ọzoo ọphu e meru l'iphe, aangụ angụngu ọzo, atsụ atsụtsu. G'ọ tọ ngụjekwa mini akpụru vayịnu; ọphu o rijekwa akpụru vayịnu oyii; ọzoo ọphu e gheru egheghe. ");
INSERT INTO izz_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","G'o to rijekwa iphe, shi l'oshi vayịnu; m'ọ bụ akpụru vayịnu ọbu l'onwiya; ọzoo ẹgbo vayịnu jeye teke ọo-bụ-beru onye dụru Chipfu iche. ");
INSERT INTO izz_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Akwọ ta abyadụ e-rwu iya l'ishi jeye g'ọo-bụ-beru onye doberu onwiya iche ono. Ọo-dụepho iche g'ọ dụ iya jasụ; teke ono, o doberu onwiya Chipfu iche ono edzua. Ẹgbushi, nọ iya l'ishi bẹ ọo-ha g'o rwuchia erwuchi. ");
INSERT INTO izz_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","L'ògè teke ono, ọ dụru Chipfu iche ono bẹ ọ tọ byadu e-je lẹ mgboru ẹka odzu nọ. ");
INSERT INTO izz_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Mbụ; obeta ọ bụru l'ọo nna iya nwụhuru; ọzoo l'ọo ne iya nwụhuru; ọzoo l'ọo nwune iya kẹ nwoke; ọzoo nwune iya kẹ nwanyị bẹ ọ tọ bụdu iya e-me g'ọ tụrwua onwiya; kẹle abụbu, ọ bụ onye dụru Chileke iche; tukoru iya l'ishi. ");
INSERT INTO izz_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Lẹ teke ono ọo-nọkotakpo bụru onye doberu onwiya iche ono bẹ ọ bụ onye dụru Chipfu nsọ. ");
INSERT INTO izz_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Teke o nweru onye gbabuhuru nwụhu lẹ mgboru ẹka ọ nọ; o shi nno tụrwua onwiya l'abụbu ono, ọ bụ onye dụru Chileke iche ono, bụ ọphu tukoru iya l'ishi ono; g'ọ nọo abalị ẹsaa; o -rwuẹpho lẹ mbọku k'ẹsaa; l'ọ kpụshia ishi; shi nno rọo onwiya ẹhu ọzo. ");
INSERT INTO izz_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","O -be lẹ mbọku k'ẹsato; l'o wota ndo labọ; ọzoo ụnwu kparaka labọ wojeru onye uke Chileke l'ọnu ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ọo ya bụ; onye uke Chileke ono abya ewota nanụ gwee ngwẹja-iphe-ẹji; l'o wota nanụ ọphuu gwee ngwẹja-akpọ-ọku gude pfụa ụgwo iphe-ẹji ono, o meru ono; mbụ l'ọ nọru lẹ mgboru ẹka nemadzụ nwụhuru. Ọ bụru mbọku onokwaphọ bẹ oo-me g'ishi iya dụ-phu nsọ azụ. ");
INSERT INTO izz_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","L'ọ byakwa abụru onye dụru Chipfu iche g'o shi bụru iya. Ọ -nọ-dzua ya; l'ọ kpụta ebili, gbaru apha je anụ g'e gude gweeru iya ngwẹja-apfụ-ụgwo. Ọphu, ọ nọhawaru phọ bẹ a taa gụkwa eye iya; kẹle ọ nọ iya tụrwua onwiya. ");
INSERT INTO izz_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Ọwaa bụ ekemu, dụru onye woru onwiya doberu Chipfu iche; nọo ya nọ-dzua. Ee-duru onye ọbu bya l'ọnu ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ọ bụru l'ẹka ono bẹ ọo-nọdu woru iphe, ọonu Chipfu nụ iya. Ọo-nụ iya ebili, gbaru apha, te nwedu ẹka iphe mebyiru iya g'e gude gwee ngwẹja-akpọ-ọku; l'ọ bya anụ nwada atụru, gbawaru apha, te enwedu ẹka iphe mebyiru iya g'e gude gwee ngwẹja-iphe-ẹji; l'ọ nụ ebili, te enwedu ẹka iphe mebyiru iya g'e gude gwee ngwẹja-ẹhu-guu. ");
INSERT INTO izz_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Iphe ọzo, oo-yekọbe iya bụ nkata buredi, e te yedụru iphe ekoje buredi; waa akara, e meru l'ukpokutu witi, gwọo lẹ manụ; mẹ ẹcha-mbekee, a wụru manụ l'eli; waa ngwẹja-nri; yẹle ngwẹja-mẹe, ayịjeru iya nụ. ");
INSERT INTO izz_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Iphe ono g'ọ ha bẹ onye uke Chileke e-gwerụ nụ Chipfu. L'o gwee ngwẹja-iphe-ẹji ono; waa ngwẹja-akpọ-ọku ono. ");
INSERT INTO izz_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Onye uke Chileke ono bẹ e-woru nkata buredi ono, ekoduru ekoko ono nụ Chipfu; bya egbua ebili phọ gude gwee ngwẹja-ẹhu-guu nụ Chipfu; bya eyekọbekwa iya phọ ngwẹja-nri; yẹe ngwẹja-mẹe, etsoje iya nụ tụko gwee. ");
INSERT INTO izz_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ọ bụru l'ọnu ụlo-ẹkwa-ndzukọ bẹ onye ono, woru onwiya doberu Chipfu iche ono a-nọdu kpụshia ishi ono, o shi doberu Chileke iche ono. L'o kpota ẹgbushi iya ono ye l'ọku, nọ lẹ mkpula ẹka iphe, e gude gwee ngwẹja-ẹhu-guu nọ. ");
INSERT INTO izz_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Onye ono, dụru Chipfu iche ono -kpụshichaepho ishi ono, o doberu iche ono; g'onye uke Chileke wota ẹka ebili ono ọphu e shiru eshishi dẹe ya l'ẹka; l'ọ bya ewotafụa akara lanụ, te koduru ekoko lẹ nkata ono; waa ẹcha-mbekee lanụ, te koduru ekoko nụ iya. ");
INSERT INTO izz_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ọo ya bụ; onye uke Chileke ono abya amaa ya amama l'iphu Chipfu g'ọ bụru ngwẹja amama. Iphe ono bẹ dụ nsọ; ọ bụru onye uke Chileke bẹ nwe iya nụ; yẹle ǹdụ́ ebili ono, a maru amama; mẹ ụtapfu iya ono, a nụru Chipfu ono. E -mechaa nno; onye ono, dụru Chipfu iche ono angụwaro mẹe. ");
INSERT INTO izz_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Ono bụ ekemu dụru onye woru onwiya doberu Chipfu iche; mbụ onye kwetarụ ukwe lẹ ya e-woru onwiya doberu Chipfu iche; wakwaphọ iphe, ọo-nụje Chipfu mẹ ọ nọ-dzuẹ ya phọ; a -gụfukwa iphe ọzo, ọo-dụ ike gbatafụa. Ọle o medzufụtaje iphe, o kweru ukwe iya; lẹ g'ekemu onye dụru Chipfu iche gude dụ.” ");
INSERT INTO izz_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Pfuaru Erọnu yẹle ụnwu iya sụ phẹ g'ẹphe gọjeru ndu Ízurẹlu ọnu-ọma. Waa g'ẹphe epfuje iya baa: ");
INSERT INTO izz_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Gẹ Chipfu gọru ọnu-ọma nụ unu; chee unu. ");
INSERT INTO izz_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Gẹ Chipfu mee g'atatiphu iya gbuaru unu nwịinwii; l'o meeru unu eze-iphe-ọma. ");
INSERT INTO izz_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Gẹ Chipfu ghaaru unu iphu; mee g'ẹhu dụ unu guu.’ ");
INSERT INTO izz_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ọo ya bụ; ẹphe -gude ẹpha mu gọru ọnu-ọma nụ ndu Ízurẹlu; mu agọru ọnu-ọma nụ phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Tọbudu iya bụ; Mósisu bvubechaẹpho ụlo-ẹkwa Chipfu ono; ọ wụa ya manụ; bya edobe iya iche; bya edobekwaphọ iphe, bụ ivu nọ iya nụ g'ọ ha iche. Nokwaphọ g'ọ wụru manụ l'ọru-ngwẹja; dobe iya iche; bya edobekwaphọ iphe, bụ ivu ọru-ngwẹja ono g'ọ ha iche. ");
INSERT INTO izz_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ọo ya bụ; ndu-ishi ndu Ízurẹlu, bụ ndu-ishi l'ẹnya-unuphu l'ẹnya-unuphu; mbụ ndu-ishi l'ipfu l'ipfu, bụ iya bụ ndu ono, bụ ishi ndu ọphu a gụru ọgu ono bya eworu iphe nụ. ");
INSERT INTO izz_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Iphe, ẹphe nụru Chipfu bẹ bụ ọgba-kperekpere ishii, e kpuchiru iphe; mẹ oke-eswi iri l'ẹbo. Ndu-ishi ono bẹ nụchaaru oke-eswi lanụ oke-eswi lanụ l'ẹhu l'ẹhu. Ẹphe dụ ẹbo ẹbo nụcha ọgba-kperekpere lanụ. Noo iphe, ẹphe wotaru bya anụ l'iphu ụlo-ẹkwa Chipfu bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Natakọta phẹ iphe ono, ẹphe nụru; k'ọphu ee-gude iya eje ozi l'ụlo-ẹkwa-ndzukọ. L'i woru iya nụ ndu Lívayi. Onyenọnu bẹ ịi-nụcha ya lẹ g'ozi iya gbaru.” ");
INSERT INTO izz_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ọo ya bụ; Mósisu bya ewota ọgba-kperekpere ono; mẹ oke-eswi ono nụ ndu Lívayi. ");
INSERT INTO izz_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ụnwu Geshọnu bẹ ọ nụru ọgba-kperekpere labọ; waa oke-eswi ẹno g'ẹphe gude jeje ozi, gbaru phẹ nụ. ");
INSERT INTO izz_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ọ nụ ụnwu Merari ọgba-kperekpere ẹno; waa oke-eswi ẹsato g'ẹphe gude jeje ozi, gbaru phẹ nụ. G'ẹphe ha bẹ nọkota l'ẹka Itama nwa Erọnu, bụ onye uke Chileke eje ozi phẹ. ");
INSERT INTO izz_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Obenu l'ọ tọ dụdu ọphu ọ nụru ụnwu Kohatu; kẹle ọo ẹphebedua bẹ evu iphe, dụ nsọ ono l'ukuvu dụru. ");
INSERT INTO izz_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Mbọku, a wụru manụ l'ọru-ngwẹja Chileke g'e gude woru iya ye Chileke l'ẹka bẹ ndu-ishi ono wotagbaaru iphe bya anụ Chileke l'iphu ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Chipfu bya asụ Mósisu: “Gẹ ndu-ishi ono byajẹ nanụ nanụ lẹ mbọku lẹ mbọku bya anụ iphe ngwẹja phẹ g'e gwee l'ọru-ngwẹja ono; shi nno woru iya ye Chileke l'ẹka.” ");
INSERT INTO izz_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Onye wotaru iphe nkiya bya anụ lẹ mbọku kẹ mbụ bẹ bụ Náshọnu nwa Amínadabu, bụ onye-ishi ndu Jiuda. ");
INSERT INTO izz_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","mẹ oke-eswi labọ; waa ebili ise; mẹ mkpi ise; mẹ ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Náshọnu nwa Amínadabu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","O be lẹ mbọku k'ẹbo; Netanẹlu nwa Zuwa, bụ onye-ishi l'ipfu Isaka wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","mẹ oke-eswi labọ; waa ebili ise; waa mkpi ise; mẹ ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Netanẹlu nwa Zuwa wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","O be lẹ mbọku k'ẹto; Eliyabu nwa Helọnu, bụ onye-ishi ndu kẹ Zebulọnu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; mẹ ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Eliyabu nwa Helọnu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","O be lẹ mbọku k'ẹno; Elizuru nwa Shediyọ, bụ onye-ishi, ụnwu Rúbẹnu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Elizuru nwa Shediyọ wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","O be lẹ mbọku k'ise; Shelumẹlu nwa Zurishadayi, bụ onye-ishi ụnwu Simiyọnu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; mẹ nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Shelumẹlu nwa Zurishadayi wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","O be lẹ mbọku k'ishii; Ẹliyasafu nwa Diyuwẹlu, bụ onye-ishi ụnwu Gadu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; mẹ nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Ẹliyasafu nwa Diyuwẹlu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","O be lẹ mbọku k'ẹsaa; Elishama nwa Amihudu, bụ onye-ishi ndu Ifuremu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Elishama nwa Amihudu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","O be lẹ mbọku k'ẹsato; Gamalẹlu nwa Pedazọ, bụ onye-ishi ndu ipfu Manásẹ wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","waa oke-eswi labọ; mẹ ebili ise, waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Gamalẹlu nwa Pedazọ wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","O be lẹ mbọku kẹ tete; Abidanu nwa Gidiyọni, bụ onye-ishi ndu Benjiaminu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Abidanu nwa Gidiyọni wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","O be lẹ mbọku k'iri; Ahiyeza nwa Amishadayi, bụ onye-ishi ndu ipfu Danu wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Ahiyeza nwa Amishadayi wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","O be lẹ mbọku k'iri lẹ nanụ; Pagẹlu nwa Ọkuranu, bụ onye-ishi ndu ipfu Asha wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Pagẹlu nwa Ọkuranu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","O be lẹ mbọku k'iri l'ẹbo; Ahira nwa Enanu, bụ onye-ishi ụnwu Nafụtali wota iphe nkiya bya anụ. ");
INSERT INTO izz_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Iphe, ọ nụru bụ gbamụgbamu mkpọla-ọchaa lanụ, ẹrwa iya dụ ụkporo shẹkelu ishii lẹ shẹkelu iri; bya anụkwapho ochi lanụ, e meru lẹ mkpọla-ọchaa, ẹrwa iya dụ ụkporo shẹkelu ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Ọphu nọnu bẹ e yejishikọtaru ukpokutu ereshi, a gwọru lẹ manụ; g'e gude gwee ngwẹja-nri. ");
INSERT INTO izz_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Iphe ọzo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo, ẹrwa iya dụ shẹkelu iri; iphe, jiru iya nụ bụ ụ̀nwù-isẹnsu; ");
INSERT INTO izz_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Ọ bya anụ nwa oke-eswi lanụ; waa ebili lanụ; waa nwa ebili lanụ, gbaru apha, ee-gude gwee ngwẹja-akpọ-ọku; ");
INSERT INTO izz_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","waa mkpi lanụ, ee-gude gwee ngwẹja-iphe-ẹji; ");
INSERT INTO izz_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","waa oke-eswi labọ; mẹ ebili ise; waa mkpi ise; waa ụnwu ebili ise, gbachaaru apha, ee-gude gwee ngwẹja-ẹhu-guu. Noo iphe, Ahira nwa Enanu wotaru bya anụ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Iphe ono bẹ bụ iphe, ndu-ishi ndu Ízurẹlu wotaru bya anụ g'e gude woru ọru-ngwẹja ono ye Chileke l'ẹka; mbụ teke ono, a wụru iya manụ ono. Iphe, ẹphe nụru bẹ bụ: gbamụgbamu mkpọla-ọchaa iri l'ẹbo; waa ochi mkpọla-ọchaa iri l'ẹbo; waa agọ mkpọla-ododo iri l'ẹbo. ");
INSERT INTO izz_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Gbamụgbamu lanụ bẹ ẹrwa iya adụje ụkporo shẹkelu mkpọla-ọchaa ishii lẹ shẹkelu iri. Ẹrwa ochi lanụ nọdu adụje ụkporo shẹkelu mkpọla-ọchaa ẹto lẹ shẹkelu iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. ");
INSERT INTO izz_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Agọ mkpọla-ododo ono dụ iri l'ẹbo; tẹme e yejishichaa ya ụ̀nwù-isẹnsu. Ẹrwa iya nọdu abụjeru shẹkelu mkpọla-ododo iri iri. G'ọ ha bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. Mkpọla-ododo, e gude mee agọ ono bẹ ẹrwa iya tụko dụ ụkporo shẹkelu mkpọla-ododo ishii. ");
INSERT INTO izz_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Iphe mkpakọ anụ, ee-gude gwee ngwẹja-akpọ-ọku ono dụkota bẹ bụ; ụnwu oke-eswi iri l'ẹbo; waa ebili iri l'ẹbo; waa ụnwu ebili iri l'ẹbo, gbachaaru apha; yẹle ngwẹja-nri tso iya nụ; waa mkpi iri l'ẹbo, ee-gude gwee ngwẹja iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Anụ, ee-gude gwee ngwẹja-ẹhu-guu bẹ tụkoru dụ oke-eswi ụkporo l'ẹno; waa ebili ụkporo ẹto; mẹ mkpi ụkporo ẹto; waa ụnwu ebili ụkporo ẹto, gbachaaru apha. Noo iphe, a nụru g'e gude woru ọru-ngwẹja ono ye Chileke l'ẹka; mbụ teke ono, a wụru iya manụ ono. ");
INSERT INTO izz_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","O be teke Mósisu bahụru gẹ yẹle Chipfu bọgba l'ime ụlo-ẹkwa-ndzukọ ono; ọ nụma olu-opfu, a nọ l'eli opfu okpoko ono; ẹka aapfụje ụgwo iphe-ẹji ono epfu, bụ iya bụ ẹka ono, e doberu ekemu Chipfu ono. Opfu ono bẹ a nọ lẹ mgbaka chierobu labọ phọ epfu eyeru Mósisu. ");
INSERT INTO izz_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Pfuaru Erọnu sụ iya l'ọ -bya adọbe orọku; g'ọ dọbe orọku ẹsaa ono k'ọphu ìphóró iya a-nga atatiphu iphe ono, a tukoberu iya ono.” ");
INSERT INTO izz_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Erọnu mee ya ẹgube ono, a sụru g'o mee ya ono; mbụ dọbe orọku ono; k'ọphu ìphóró iya ngakọtaru atatiphu iphe ono, a tụ-koberu iya ono, bụ iya bụ gẹ Chipfu karụ Mósisu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Waa g'e gude mee iphe ono, aatukobeje orọku ono baa: Ọo mkpọla-ododo, e tsusaru etsusa bẹ e gude mekọta iya shita l'ike iya jeye lẹ nchị iya. Iphe ono, aatukobeje orọku ono bẹ e meẹrupho ẹgube Chipfu goshiru iya Mósisu. ");
INSERT INTO izz_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Chipfu byakwa asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Họta ndu Lívayi l'echilabọ ndu Ízurẹlu; mee phẹ g'ẹphe dụebe ree. ");
INSERT INTO izz_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Waa g'ii-shi mee phẹ g'ẹphe dụebe ree baa: Wota mini ntụrwu phee phẹ l'ẹhu; ẹphe akpụshikota iphe, bụ ẹji, dụ phẹ l'ẹhu; bya asashịkota uwe phẹ shi nno sachaa onwophẹ ree. ");
INSERT INTO izz_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ẹphe ewota nwa oke-eswi; yẹle ngwẹja-nri, ayịru iya nụ, bụ iya bụ ukpokutu ereshi, a gwọru lẹ manụ. L'i wota nwa oke-eswi ọzo, ee-gude gwee ngwẹja-iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","L'i duru ndu Lívayi ọbu je l'iphu ụlo-ẹkwa-ndzukọ; kukọbe iphe, bụ ndu Ízurẹlu l'ophu g'ẹphe dzukọta l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","L'i duru ndu Lívayi ono bya l'atatiphu Chipfu. Ndu Ízurẹlu ebyibe phẹ ẹka l'ishi. ");
INSERT INTO izz_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ọ bụru Erọnu e-woru ndu Lívayi ono ye Chipfu l'ẹka; ẹphe abụru ngwẹja-amama, shi l'ẹka ndu Ízurẹlu; k'ọphu ẹphe a-nọdu ejeru Chipfu ozi. ");
INSERT INTO izz_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ọo ya bụ; ndu Lívayi ono abya ebyibegbaa oke-eswi ono ẹka l'ishi. L'i gude nanụ gwee ngwẹja-iphe-ẹji; gude nanụ gwee ngwẹja-akpọ-ọku nụ Chipfu; shi nno pfụa ụgwo iphe-ẹji ndu Lívayi. ");
INSERT INTO izz_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“L'i mee; ndu Lívayi ono abya atụko pfụru l'iphu Erọnu yẹle ụnwu iya. L'i woru phẹ ye l'ẹka Chipfu g'ẹphe abụru iya ngwẹja-amama. ");
INSERT INTO izz_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Noo g'ii-shi dobe ndu Lívayi iche l'ẹka ndu Ízurẹlu ọphuna nọ bụ ono; mee ndu Lívayi ono g'ẹphe bụru nkemu. ");
INSERT INTO izz_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ị -sachaẹpho ndu Lívayi ono; bya eworu phẹ dobe g'ẹphe dụ gẹ ngwẹja-amama; ẹphe ejeahaa ozi l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ọo ẹphebedua g'ẹphe hakọta bẹ e shi lẹ ndu Ízurẹlu họta ye mu l'ẹka. Mu nata phẹ; mee phẹ; ẹphe bụru nkemu; nọchia ẹnya ndu bụ ọkpara l'alị Ízurẹlu; mbụ iphe, bụkota unwoke mbụ, vu ụzo waa ẹkpa-nwa l'alị Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Iphe, bụ ọkpara l'ophu l'alị Ízurẹlu; nemadzụ-o; mẹ anụ bẹ bụkota nkemu. Lẹ teke ono, mu gbushikọtaru iphe, bụ ọkpara l'alị Ijiputu bẹ mu doberu phẹ iche g'ẹphe bụru nkemu. ");
INSERT INTO izz_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nta-a bẹ mu wowaru ndu Lívayi mee; ẹphe nọchia ẹnya ndu bụ ọkpara l'alị Ízurẹlu l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mbụ lẹ mu shiwaa l'echilabọ ndu Ízurẹlu l'ophu họta ndu Lívayi woru ye Erọnu yẹle ụnwu iya l'ẹka; g'ẹphe jejeru ndu Ízurẹlu ozi l'ụlo-ẹkwa-ndzukọ; ẹphe apfụje ụgwo iphe-ẹji ụnwu Ízurẹlu; k'ọphu mgbu-ọnwu ete egbudu phẹ m'ẹphe jekube ụlo Chipfu ono ntse.” ");
INSERT INTO izz_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mósisu; waa Erọnu; mẹ iphe, bụ ndu Ízurẹlu l'ophu bya emeeru ndu Lívayi ẹgube ono, Chipfu tụru iya Mósisu l'ekemu sụ g'e mee ndu Lívayi. Ọ bụru gẹ ndu Ízurẹlu meru phẹ iya bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ndu Lívayi bẹ safụru onwophẹ ntụrwu; bya asaa uwe phẹ asasa. Ọo ya bụ; Erọnu woru phẹ nụ Chipfu g'ẹphe dụ gẹ ngwẹja amama; bya apfụa ụgwo iphe-ẹji phẹ shi nno safụ phẹ ntụrwu. ");
INSERT INTO izz_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","E mechaa; ndu Lívayi nọdu Erọnu yẹle ụnwu iya l'ẹka wata eje ozi l'ụlo-ẹkwa-ndzukọ. Ọ bụru gẹ Chipfu gude tụaru iya Mósisu l'ekemu bụ g'ẹphe meru ndu Lívayi ono. ");
INSERT INTO izz_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Iphe-a bẹ bụ ndu Lívayi bẹ ọ dụru: Unwoke nọwaru a -gbẹ l'ụkporo apha l'apha ise kwasẹru bẹ a-watajẹ eje ozi l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ẹphe -nọwa ụkporo apha labọ l'apha iri; ẹphe ahaa eje ozi l'ụlo-ẹkwa-ndzukọ ono; ẹphe te ejebaẹdu iya. ");
INSERT INTO izz_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ọle ọ -bụru l'ọ dụ phẹ g'ẹphe yejeru ụnwunna phẹ ẹka l'ozi ụlo-ẹkwa-ndzukọ ono; g'ẹphe yekpọoro ẹka. Obenu l'ẹphebedua l'onwophẹ bẹ l'e-jebuhu ozi. Noo g'ii-shi nụ ndu Lívayi ozi, ẹphe a-nọduje eje bụ ono.” ");
INSERT INTO izz_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","L'ọnwa mbụ l'apha, kwe ndu Ízurẹlu apha labọ, ẹphe shi l'alị Ijiputu lụfuta bẹ Chipfu pfuru yeru Mósisu l'echiẹgu Sayịnayi sụ iya: ");
INSERT INTO izz_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Gẹ ndu Ízurẹlu bọkwaa ọbo Ojeghata teke a bọje iya. ");
INSERT INTO izz_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ọnwa-a -dụepho l'abalị iri l'ẹno; unu bọo ọbo Ojeghata ono teke a bọje iya. Teke unu a-wata iya abọbo bẹ bụ mẹ ẹnyanwu rịbajeepho. Unu bọo iphe ono g'ekemu iya gude dụ waa gẹ nsọ iya gude dụ.” ");
INSERT INTO izz_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ọo ya bụ; Mósisu bya epfuaru ndu Ízurẹlu g'ẹphe bọo ọbo Ojeghata ono. ");
INSERT INTO izz_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ẹphe woru ọbo Ojeghata ono bọo l'echiẹgu Sayịnayi g'ọnwa mbụ ono dụ l'abalị iri l'ẹno; g'ẹnyanwu abyawaa arịba. Ẹphe tụko iphemiphe mekọta gẹ Chipfu sụru Mósisu g'emeje iya. ");
INSERT INTO izz_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ọle o nwekwanụru ndu ọphu ayịdu lẹ ndu bọru ọbo Ojeghata ono mbọku ono. Ishi iya bụ l'ẹphe tụrwuru onwophẹ kẹle ẹphe denyiru onye nwụhuru anwụhu ẹka. Ndu ono byapfuta Mósisu yẹle Erọnu lẹ mbọku ono; ");
INSERT INTO izz_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bya asụ Mósisu: “Nta-a bẹ ntụrwu dụ anyi l'ẹhu kẹle anyi denyiru onye nwụhuru anwụhu ẹka. Ọle-a; ?dẹnu g'o gude ọphu e te ekwedu g'anyi tsoru ndu Ízurẹlu ọphuna nụ Chipfu ngwẹja teke a nụje iya?” ");
INSERT INTO izz_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mósisu sụ phẹ: “Unu ngabẹ; gẹ mu maru iphe, Chipfu l'e-pfu l'opfu ẹhu unu.” ");
INSERT INTO izz_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Tọbudu iya bụ; Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Pfuaru ndu Ízurẹlu sụ phẹ: O -nweru onye shi l'ime unu; ọzoo l'onye ọbu bụ oshilọkpa unu, denyiru ẹka l'odzu; shi nno tụrwua onwiya; ọzoo l'onye ọbu jeru ẹka dụ ẹnya ẹnya; g'onye ono bọlekwa-a ọbo Ojeghata kẹ Chipfu ono. ");
INSERT INTO izz_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Teke ẹphe a-bọ iya bẹ bụ l'abalị iri l'ẹno l'ọnwa k'ẹbo iya; mẹ ẹnyanwu rịbajeepho. Iphe, ẹphe e-gude bọo ya bụ: buredi, ekoduru ekoko; waa mkpẹekwo, atsọgbaa ilu. ");
INSERT INTO izz_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","G'ọ tọ dụkwa iphe ono ọphu ẹphe a-ha g'ọ bọo nchi; ọphu ọ dụkwa ọkpu iya, ẹphe a-nyakwo anyakwo. Ọo g'ekemu ọbo Ojeghata ono dụkota bụ g'ẹphe e-gude bọo ya. ");
INSERT INTO izz_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ọle onye ntụrwu adụdu l'ẹhu; ọphu o jeduru iphe; ọphu onye ọbu abọduru ọbo Ojeghata ono bẹ ee-bufu l'echilabọ ndibe phẹ; noo kẹle ọ tọ nụduru Chipfu ngwẹja iya teke a tụru ọnu iya. Onye ono bẹ iphe-ẹji, o meru a-tukoru l'ishi. ");
INSERT INTO izz_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Onye lwarụ alwalwa; unu l'iya buru; ọ -dụ iya g'o tsoru unu bọo ọbo Ojeghata kẹ Chipfu ono; g'onye ọbu mekwaa ya g'ekemu iya; waa nsọ iya gude dụ. Ọo nsọ lanụ bẹ dụru onye a nwụru anwụnwu l'alị-a waa onye lwarụ alwalwa.” ");
INSERT INTO izz_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Mbọku ono, a kpọberu ụlo-ẹkwa Chipfu, bụ iya bụ ụlo-ẹkwa, ẹka eedobeje ẹkwo ekemu Chipfu ono; bẹ urwukpu sọ-kputeru iya. L'ụzenyashi bẹ urwukpu ono dụepho g'ọku l'eli ụlo-ẹkwa ono; dụepho nno jasụ l'ụtsu. ");
INSERT INTO izz_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ọ bụerupho g'ọ dụ kwasẹru bụ ono. L'eswe bẹ urwukpu ono asọ-kputajẹ ụlo-ẹkwa Chipfu ono; o -be l'ẹnyashi; l'o nwua kẹ phoo g'ọku. ");
INSERT INTO izz_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ọ nọdu abụjeru teke urwukpu ono shi l'eli ụlo-ẹkwa ono palihu imeli imeli; ndu Ízurẹlu awụ-lihu tụgbua ije phẹ. Ẹka ẹphe jeberu; urwukpu ono keshiru; ẹphe akpọbe ụlo-ẹkwa phẹ l'ẹka ono; nọshia. ");
INSERT INTO izz_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ọ nọdu abụjeru Chipfu -sụ ndu Ízurẹlu g'ẹphe wụ-lihu tụgbua; ẹphe awụfu tụgbua. Teke ọ bụ l'ọ sụru phẹ g'ẹphe nọdu; ẹphe akpọbe ụlo-ẹkwa phẹ nọshia. Ọ bụru g'urwukpu ono nọ-beru l'eli ụlo-ẹkwa Chipfu ono bụ g'ẹphe anọ-bejeru l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ ono. ");
INSERT INTO izz_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Teke urwukpu ono nọru ọdu l'eli ụlo-ẹkwa Chileke ono; ndu Ízurẹlu emeẹpho gẹ Chipfu pfuru phẹ; nọpyabe; ẹphe ta atụgbudu. ");
INSERT INTO izz_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Teke ọ bụ l'urwukpu ono nọru l'eli ụlo-ẹkwa Chipfu ono; nọo ya nwujiku olemole; bẹ bụ Chipfu -sụ g'ẹphe nọdu; ẹphe akpọbe ụlo-ẹkwa phẹ nọshia. Teke ọ sụru phẹ g'ẹphe wụ-lihu tụgbua; ẹphe awụfu tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Teke ọ bụ l'urwukpu ono nọru shita l'ụzenyashi jasụ l'ụtsu; o -rwua l'ụtsu ọ palihu imeli imeli; ẹphe awụfu tụgbua. Obetakpọo ọ bụru l'eswe bẹ urwukpu ono palihuru imeli; ọzoo l'ẹnyashi; bẹ bụepho teke ọ palihuru bẹ ndu Ízurẹlu awụfuje tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Obetakpọo urwukpu ono nọdu l'eli ụlo-ẹkwa Chipfu ono nọo ya abalị labọ; ọzoo nọo ya ọnwa ophu; ọzoo l'ọo apha ophu; bẹ ndu Ízurẹlu a-nọdujeepho l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ g'ẹphe nọ iya; ọphu ẹphe ta abyadụ atụgbu atụgbu. Obenu lẹ teke a nọnyaaru urwukpu ono palihu imeli; ẹphe awụfu tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ọ nọdu abụjeru; Chipfu -sụ phẹ g'ẹphe nọdu; ẹphe akpọbe ụlo-ẹkwa phẹ nọshia. Teke ọ sụru phẹ g'ẹphe tụgbua; ẹphe awụfu tụgbua. Iphemiphe, Chipfu pfuru phẹ bẹ ẹphe mekọtaru ẹgube ọ tụru iya Mósisu l'ekemu. ");
INSERT INTO izz_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Gude mkpọla-ọchaa, e tsusaru etsusa meta opu labọ; k'ọphu ii-gudeje iya eku ndu Ízurẹlu g'ẹphe dzukọbe; gudejekwa iya phọ karụ phẹ teke ẹphe a-phụtaje ụlo-ẹkwa phẹ tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Teke a tụkoru opu labọ ono gbua bẹ bụ iphe, oopfu bụ g'iphe, bụ ndu Ízurẹlu l'ophu dzukọbe l'iphu ngu l'ọnu ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ọ -bụru l'ọo opu lanụ kpoloko bẹ e gburu; iphe, oopfu bụ g'iphe, bụ ndu-ishi dzukọbekota l'atatiphu ngu; mbụ ndu bụgbaa ishi ipfu ipfu ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Teke opu ono daru ugbo lanụ; iphe, oopfu bụ g'iphe, bụ ipfu, kpọberu ụlo-ẹkwa phẹ l'ụzo ẹnyanwu-awawa wulihu tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Teke i gburu opu ono k'ugbo ẹbo; gẹ ndu ọphu kpọberu ụlo-ẹkwa nkephẹ l'ụzo ndọhali wulihu tụgbua. Ee-gbuje opu ono g'ọ gbajẹ ama teke ẹphe a-wụfu tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Unu -byaẹpho eku edzudzu-ọha g'ẹphe dzukọbe; unu egbua opu ono; ọle ọo g'ọ tọ dashị g'ọphu e gude agba ama. ");
INSERT INTO izz_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ọo ụnwu Erọnu, bụ iya bụ ndu-uke Chileke bẹ e-gbuje opu ono. Ọo-bụru omelalị, a-dụru unu jasụru asụru; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Teke ọ bụ l'unu eje etso ndu ọhogu unu ọgu l'alị unu; mbụ ndu akpa unu ẹhu; unu gbua opu ono g'ọ dashia ọda ike; k'ọphu Chipfu, bụ Chileke unu a-nyata unu; bya adzọta unu l'ẹka ndu ọhogu unu ono. ");
INSERT INTO izz_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Nokwaphọ g'unu e-gbuje opu mẹ ẹhu nọdu atsọ unu; mẹ teke unu abọ ọbo-iphe, unu abọjegbaa; mẹ teke unu abọ iphe k'ọnwa ọ̀phúú unu; unu -gwechaẹpho ngwẹja-akpọ-ọku; mẹ ngwẹja-ẹhu-guu ono, unu egweje ono; unu egburu opu ye iya; k'ọphu Chileke e-gude iya nyata unu. Ọo mbẹdua bụ Chipfu, bụ Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","O be lẹ g'ọnwa k'ẹbo dụ l'ụkporo abalị; l'apha k'ẹbo iya; urwukpu ono shi l'eli ụlo-ẹkwa Chipfu ono, bụ ẹka ẹkwo ekemu adụje ono palia imeli imeli. ");
INSERT INTO izz_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Tọbudu iya bụ; ndu Ízurẹlu bya eshi l'echiẹgu Sayịnayi ono; ọ bụru phẹ atụgbu. Ẹphe jee jasụ l'echiẹgu Paranu, bụ ẹka urwukpu ono jeberu keshiru. ");
INSERT INTO izz_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Onoya bụ kẹ mbụ, ẹphe tụgburu ije phẹ ono; ẹgube ono, Chipfu tụru iya Mósisu l'ekemu. ");
INSERT INTO izz_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ọ bụru ipfu Jiuda bẹ vutaru ụzo ije ono. Ẹphe dzebe l'ọkpa l'ọkpa; parụ ẹkwa-ọhubama ipfu phẹ wụru tụgbua. Ọ bụru Náshọnu nwa Amínadabu bẹ bụ onye-ishi ipfu Jiuda ono. ");
INSERT INTO izz_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanẹlu nwa Zuwa bụru onye-ishi ipfu Isaka; ");
INSERT INTO izz_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliyabu nwa Helọnu bụru onye-ishi ipfu Zebulọnu. ");
INSERT INTO izz_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ọo ya bụ; a phọ-tsuta ụlo-ẹkwa Chipfu ono; oshilọkpa Geshọnu; mẹ oshilọkpa Merari pata iya; ọ bụru phẹ atụgbu. ");
INSERT INTO izz_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ipfu ọzo, l'etsota l'atụgbu ono bẹ bụ ndu ipfu kẹ Rúbẹnu. Ẹphe dzebekwaphọ l'ọkpa l'ọkpa; gude ẹkwa-ọhubama ipfu phẹ wụru tụgbua. Ọ bụru Elizuru nwa Shediyọ bụ onye-ishi ipfu Rúbẹnu ono. ");
INSERT INTO izz_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumẹlu nwa Zurishadayi bụru onye-ishi ndu ipfu Simiyọnu; ");
INSERT INTO izz_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ẹliyasafu nwa Diyuwẹlu bụru onye-ishi ipfu Gadu. ");
INSERT INTO izz_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Tọbudu iya bụ; ndu Kohatu vuta iphe, dụ nsọ ono gude tụgbushia. Ẹphe jerwushia; a kpọbewa nụ ụlo-ẹkwa Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ipfu ọzo, l'etsota phẹ nụ bụru ndu Ifuremu. Ipfu ọzo, l'etsota l'atụgbu ono bẹ bụ ndu ipfu kẹ Rúbẹnu. Ẹphe dzebekwaphọ l'ọkpa l'ọkpa; gude ẹkwa-ọhubama ipfu phẹ wụru tụgbua. Ọ bụru Elishama nwa Amihudu bụ onye-ishi ndu ipfu Ifuremu ono. ");
INSERT INTO izz_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalẹlu nwa Pedazọ bụru onye-ishi ndu ipfu Manásẹ; ");
INSERT INTO izz_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidanu nwa Gidiyọni bụru onye-ishi ndu ipfu Benjiaminu. ");
INSERT INTO izz_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ipfu ọzo, l'etsota nụ; bya abụru ipfu ọphu ekpejeru azụ l'ije ono bụru ndu Danu. Ipfu ọzo, l'etsota l'atụgbu ono bẹ bụ ndu ipfu kẹ Rúbẹnu. Ẹphebedua dzebekwaphọ l'ọkpa l'ọkpa; gude ẹkwa-ọhubama ipfu phẹ wụru tụgbua. Ọ bụru Ahiyeza nwa Amishadayi bụ onye-ishi ipfu Danu ono. ");
INSERT INTO izz_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagẹlu nwa Ọkuranu bụru onye-ishi ipfu Asha. ");
INSERT INTO izz_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira nwa Enanu bụru onye-ishi ipfu Nafụtali. ");
INSERT INTO izz_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Noo gẹ ndu Ízurẹlu edzebeje l'ọkpa l'ọkpa wụfu m'ẹphe gbẹshi ije phẹ bụ ono. ");
INSERT INTO izz_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mósisu bya epfuaru Hobabu nwa Ruwẹlu, bụ onye Midiyanu; bya abụru ọgo iya sụ iya: “Nta-a bẹ anyi atụgbuwa ala alị ẹka ono, Chipfu pfuru anyi l'ọo-nụ anyi ono. Tsonụru anyi g'anyi je. Anyi e-mekwarụ ngu ree; kẹle Chipfu kweshikwaru ndu Ízurẹlu ukwe-iphe, dụgbaa ree.” ");
INSERT INTO izz_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu sụ iya waawaa; lẹ ya te etsoduru phẹ; lẹ ya alaphuwa azụ l'alị iya; lapfu ndu ẹphe l'iya bụ. ");
INSERT INTO izz_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Obenu lẹ Mósisu sụru iya: “Jiko ta ahashịnu anyi. Eshinu ọbu ngu maru ẹka anyi a-kpọbeje ụlo-ẹkwa anyi l'echiẹgu-a; nọdunu g'ị bụru ẹnya, anyi gude aphụ ụzo. ");
INSERT INTO izz_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","I -tsoru anyi bẹ anyi lẹ ngu a-gbarụ mgba l'iphe, bụkpoo iphe-ọma, Chipfu e-mekọtaru anyi.” ");
INSERT INTO izz_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Noo ya; ẹphe shi l'úbvú Chipfu ono tụgbua; jee ije abalị ẹto. Okpoko ọgbandzu Chipfu vuta ụzo l'ime abalị ẹto ono; g'ọ chọtaru phẹ ẹka ẹphe a-nọdu tụta unme. ");
INSERT INTO izz_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ọ nọdu abụjeru; o -beẹpho l'eswe; urwukpu, shi l'ẹka Chipfu nọ abya atụkoru phẹ l'ishi; mbụ teke ono, ẹphe shi l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ tụgbua ono. ");
INSERT INTO izz_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Teke e vutaẹrupho okpoko ono tụgbua; Mósisu asụ: “Zilihunu gụbe Chipfu. Gẹ ndu ọhogu ngu gbakashịhukwa nanụ nanụ. Gẹ ndu ono, ị dụ ashị shikwa ngu l'iphu gbalachaa.” ");
INSERT INTO izz_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Teke a pazetaru okpoko ono; Mósisu asụ: “Lwaphuta azụ gụbe Chipfu; lwapfuta ụnu-kụru-ụnu ndu Ízurẹlu-a.” ");
INSERT INTO izz_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Tọbudu iya bụ; ndu Ízurẹlu wata akụ photophoto epfu l'ẹphe eje iphe-ẹhuka. Photophoto ono, ẹphe akụ ono bya erwua Chipfu lẹ nchị; ẹhu ghuahaa ya eghu. Ọku shinu l'ẹka Chipfu bya ekegbushikọta ndu Ízurẹlu ndu ọphu kpọberu ụlo-ẹkwa phẹ l'ụzo ishi ishi. ");
INSERT INTO izz_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ndu Ízurẹlu bya araku Mósisu; o pfuru nụ Chipfu; ọku ono nyịshihu. ");
INSERT INTO izz_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ọo ya bụ; e kuahaa ẹpha ẹka ono Tabera, bụ iya bụ “ọku-ekeke”; kẹle ọku, shi l'ẹka Chipfu bya ekegbushia phẹ. ");
INSERT INTO izz_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ikpoto ndu ono, ẹphe lẹ ndu Ízurẹlu gwarụ ọgwaramogwa, bụ ndu tsoru phẹ nụ g'ẹphe gbẹshiru ije ono; wata eze nzeri nri. Ndu Ízurẹlu watanụ ara ẹkwa ọzo sụ: “?Bụ onye a-nụkpo anyi anụ g'anyi taa? ");
INSERT INTO izz_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Anyi nyatarụ teke anyi shi anọduje ata anụ ẹma l'alị Ijiputu; anyi ta apfụdu ụgwo; teke ono bẹ anyi shi anọduje eri ata kukumba; bya eri ashị; eri liku; mẹ alịbasa; waa galiku. ");
INSERT INTO izz_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ọle nta-a bẹ ọ tọ dụedu iphe, agụkwadu anyi ẹgu; ọphu ọ dụdu iphe, anyi ahụmaje ria; gbahaa mana-a!” ");
INSERT INTO izz_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Nri ono, bụ mana bẹ ụgbugba iya dụ g'akpụru koriyanda. I -lee ya ẹnya; l'ọ nyakụ anyakụ; eshi mkpọ g'etse bedelọmu. ");
INSERT INTO izz_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ndu Ízurẹlu nọdu ejeje ekpokọo ya; gwee ya egwegwe; ọzoo tsua ya etsutsu l'ikwe. Ẹphe ahajẹru shia ya eshishi; harụ ghee ya egheghe. Ọonoduje atsọ g'iphe, e gude manụ olivu ghee. ");
INSERT INTO izz_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Teke mana ono adajẹru phẹ bụ teke iji daahaẹrupho l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ l'ẹnyashi. ");
INSERT INTO izz_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mósisu bya anụma gẹ ndu Ízurẹlu wụshigbaaru l'ọnu ụlo-ẹkwa phẹ aragbaa ẹkwa; onyenọnu tụko nọdugbaa l'ọnulo l'ọnulo akwa ntụmatu; ẹhu nọdu eghu Chipfu eghu eghushikpọo ya ya ike. Ọ tsụahaa Mósisu l'ẹhu. ");
INSERT INTO izz_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Noo ya; Mósisu jịahaa Chipfu sụ iya: “?Dẹnu g'o gude ọ bụru mụbe onye-ozi ngu bẹ i meru g'ẹgube iphe-ẹhuka ọwa-a dapfuta? ?Bụ lẹ mu ta adụdu ngu l'obu meru g'o gude ị parụ ivu ẹhu ndu-a l'ophu bo mu? ");
INSERT INTO izz_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","?Bụ mbẹdua bẹ yeru ime ndu-a g'ẹphe ha; tọo mu nwụshiru phẹ; meru g'o gude ị sụ gẹ mu heru phẹ l'ụtapfu gẹ nna he nwa iya, angụkwadu ẹra. Gẹ mu heru phẹ nno jasụ l'alị ono, i riburu nna phẹ oche nte l'ịi-nụ phẹ ono. ");
INSERT INTO izz_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","?Bụ awe bẹ mu a-hụma anụ, mu a-nụgbabe ndu-a; g'ẹphe echiru mu mkpu ọwa-a, ẹphe echi-a; sụ g'a nụ phẹ anụ g'ẹphe taa! ");
INSERT INTO izz_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mu taa dụkwa ike ehekọta ndu-a nwẹkinyi mu; ivu ẹhu phẹ anyị-gbukwa mu anyị-gbu. ");
INSERT INTO izz_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ọ -bụru l'ọo ẹgube-a bẹ ii-mee mu iya; gbuchikwa mu egbugbu nta; m'ọ -bụru lẹ mu dụ ngu-a l'obu; gẹ mu ta anọdukwanu ndzụ gude ẹnya hụma ẹjo ọnodu mu.” ");
INSERT INTO izz_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Chipfu bya eyeeru Mósisu ọnu sụ iya: “Chịta ndu bụ ọgerenya Ízurẹlu ụmadzu ụkporo ẹto l'iri g'ẹphe byapfuta mu; mbụ ndu ị hụberu ama l'ẹphe bụpho ndu bụ ọgerenya; bụru ndu-ishi phẹ. Chịta phẹ gẹ gụ l'ẹphe tụko bya apfụru l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mu e-nyizeta byapfuta ngu l'ẹka ono; mu lẹ ngu epfugba opfu; mu aharu unme, dụ ngu l'ẹhu habọta woru ye ndu ono l'ẹhu nkephẹ; k'ọphu ẹphe e-yeta ẹka vubude ngu ivu ono; g'i ti vuhẹ iya nwẹkinyi ngu. ");
INSERT INTO izz_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Pfuaru ndu Ízurẹlu g'ẹphe dobe onwophẹ iche kwabẹru echele; l'o -rwua echele bẹ ẹphe a-ta anụ; kẹle mụbe Chipfu nụmawaru ẹkwa ono, ẹphe ara sụ: ‘?Bụ onye a-nụ anyi anụ g'anyi taa? Teke anyi shi nọdu lẹ Ijiputu bẹ shikwa karụ anyi lẹ ree.’ Nta-a bẹ Chipfu a-nụ unu anụ g'unu taa. ");
INSERT INTO izz_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Anụ ono bẹ unu ta atagbudu l'ujiku lanụ; ọphu unu atagbudu iya l'ujiku labọ; ọzoo l'ime ujiku ise; ọzoo l'ime ujiku iri; ọzoo l'ime ujiku ụkporo. ");
INSERT INTO izz_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Unu a-ta anụ ono ọnwa ophu; taa ya jasụ l'o bushihu unu l'imi; mbụ jasụ ọo-tụshihu unu ayị; noo kẹle unu jịkaru Chipfu, bụ onye swiru unu; mbụ rarụ ẹkwa kpua ya sụ: ‘?Bụ gụnu meru g'o gude anyi shi l'alị Ijiputu fụta?’ ” ");
INSERT INTO izz_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Tọbudu iya bụ; Mósisu sụ Chipfu: “Ị hụmanuaru-a l'ọo ụkporo ụnu nemadzụ mgbo ụkporo ẹto; l'ụkporo ụnu nemadzụ iri l'ise bẹ mu l'ẹphe gude ọkpa eje ẹgube-a. Ọ bụru phẹ bẹ ị sụru l'ịi-nụ anụ, ẹphe a-ta ọnwa ophu. ");
INSERT INTO izz_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","E -gbushigbua atụru mẹ eswi; ?bụ g'o dzuru phẹ? Mbụ-a; ?bụ g'o dzuru phẹ obetakpọo e gbushikọtaru phẹ ẹma, nọkota l'eze-ẹnyimu?” ");
INSERT INTO izz_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Chipfu sụ Mósisu: “?Bụ l'ẹka mu ta asụdu iya ememe tọo? Nta-a bẹ ịi-hụma; iphe, mu sụru l'oo-meru ngu; ?oo-me tọo too medu?” ");
INSERT INTO izz_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Noo ya; Mósisu bya alụfu je akaru ndu Ízurẹlu iphe, Chipfu pfuru. Ọ chịta ndu bụ ọgerenya ụkporo ẹto l'iri ono; ẹphe bya apfụ-phee ụlo-ẹkwa Chileke mgburugburu. ");
INSERT INTO izz_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ọo ya bụ; Chipfu gude urwukpu nyizeta bya epfuru yeru Mósisu; harụ unme, dụ Mósisu l'ẹhu habọta woru ye ndu bụ ọgerenya ụkporo ẹto l'iri ono l'ẹhu. Unme ono byaẹ phẹ phọ l'ẹhu; ẹphe wata epfuchiru Chileke teke ono; obenu l'ẹphe te epfuchibaẹduru iya ọzobaa. ");
INSERT INTO izz_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ọle o nweru ụmadzu labọ ọzo, nọpyaberu l'ụlo-ẹkwa phẹ. Ẹpha onye lanụ bụ Ẹludadu; ẹpha onye ọphuu bụru Medadu. Ẹphe yị lẹ ndu bụ ọgerenya ono, e deru ẹpha phẹ ono; ọle ẹphe te ejeduru l'ụlo-ẹkwa Chileke ono. Obenu lẹ Unme Chileke byalẹru-a bya eji ẹphebedua ẹhu; ẹphe nọdu l'ụlo-ẹkwa phẹ ono; pfuchiahaaru Chileke. ");
INSERT INTO izz_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Nwata nwokoro lanụ gbagbụa je asụ Mósisu: “Ẹludadu yẹle Medadu nọkwa l'ẹka a kpọberu ụlo-ẹkwa epfuchiru Chileke.” ");
INSERT INTO izz_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jioshuwa nwa Nunu, bụ onye shi teke ọ bụ nwata jetaru Mósisu ozi tụfuekwapho ọnu sụ: “Nnajịuphu mu, bụ Mósisu; pfunụru phẹ g'ẹphe dobe ọnu doo.” ");
INSERT INTO izz_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mósisu sụ iya: “?Bụ ọdzori bẹ ịigbaru mu ẹgube ono tọo? Ọ gege adụ mu ree; ọ -bụ l'ọo gẹ ndu kẹ Chipfu g'ẹphe ha gbẹ bụkotaru ndu mpfuchiru; mbụ gẹ Chipfu gbẹ yekọta phẹ Unme nkiya l'ẹhu.” ");
INSERT INTO izz_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","E mechaa; Mósisu mẹ ndu bụ ọgerenya Ízurẹlu ono laphu azụ l'ẹka ẹphe kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Noo ya; phẹrephere bya eshi l'ẹka Chipfu nọ ziahaa; o shi l'eze-ẹnyimu chịkashia ọ̀kwà; ẹphe bya adabyigbaaru lẹ mgboru ẹka ẹphe kpọberu ụlo-ẹkwa phẹ ono. Ẹphe tụko ẹka ono g'ọ ha dzuru rwua iphe, ha g'ẹka nemadzụ a-dụ ike jee l'ọkpa ujiku ophu. G'ẹphe epheberu l'eli bẹ bụ iphe, rwuru ntụ-ọkpa ẹto mẹ a -gbẹ l'ọmali. ");
INSERT INTO izz_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mbọku ono l'ophu; mẹ ẹnyashi ono l'ophu; mẹkwapho nchitabọhu iya bẹ ẹphe tsoru je anwụko ọ̀kwà ono. Onye nwụtanukaru nwanshịi bẹ nwụ-jiru gbamụgbamu-nkwẹka ụkporo ise. Ẹphe woru iya kpasaaru onwophẹ; ọ tụko ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ ono dzuru mgburugburu. ");
INSERT INTO izz_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ẹphe kpụkwaduru-a anụ ọ̀kwà ono l'ọnu ata; mbụ l'ẹphe teke atagbudu iya; Chipfu watawaa phẹ atụ-koshi oke ẹhu-eghu iya. Ọ lọru ẹjo mgbu-ọnwu tụ phẹ. ");
INSERT INTO izz_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ọo ya bụ; e kuahaa ẹka ono Kiburotu-Hatava, bụ iya bụ “ọchieja ndu ẹkpiri”; kẹle ọo l'ẹka ono bẹ e liru iphe, bụ ndu ono, meru ẹkpiri ono. ");
INSERT INTO izz_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ẹphe shi lẹ Kiburotu-Hatava l'ẹka ono wụfu; je adọru lẹ Hazerotu. ");
INSERT INTO izz_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Tọbudu iya bụ; Miriyamu yẹle Erọnu wata epfubyishi Mósisu lẹ kẹ nwanyị Kushi, ọ lụru. Noo kẹle Mósisu lụtakwanuru onye Kushi. ");
INSERT INTO izz_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ẹphe sụ: “?Bụ Mósisu kpoloko bẹ Chipfu eshije l'ọnu iya pfua opfu? ?To shijedu l'ọnu k'anyịbedua pfukwaphọ opfu?” Chipfu nụmanu iphe ono, ẹphe pfuru ono. ");
INSERT INTO izz_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Sụ-a; nwoke ono, bụ Mósisu bẹ bụnukaru onye eme odoo. Ọo ya kachakpọo eme odoo l'iphe, bụ ndu mgboko l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","G'e jia epfu; Chipfu pfuaru Mósisu; waa Erọnu; mẹ Miriyamu sụ phẹ: “Unu n'ẹto tụko fụta byakọta l'ụlo-ẹkwa-ndzukọ.” Ẹphe n'ẹto ono bya afụta tụgbua jeshia. ");
INSERT INTO izz_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ọo ya bụ; Chipfu nọdu l'urwukpu, kpụru oronmono nyizeta bya apfụru l'ọnu ụlo-ẹkwa-ndzukọ ono; bya ekua Erọnu yẹle Miriyamu oku; ẹphe kpịritaru. ");
INSERT INTO izz_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Chipfu sụ phẹ: “Unu ngabẹ nchị nụma iphe, mu epfuru unu: Ọobujeru; onye mpfuchiru Chipfu -nọdu l'echilabọ unu; mụbe Chipfu egoshi iya onwomu l'ọphulenya; bya epfuru yeru iya lẹ nrwọ. ");
INSERT INTO izz_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Obenu l'ọ tọ dụdu nno l'ẹhu onye-ozi mu, bụ Mósisu. Yẹbedua bẹ mu yekọtaru ndibe mu l'ophu l'ẹka. ");
INSERT INTO izz_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Tẹme mu l'iya nọdu abọgbaje ụja l'iphu l'iphu; mbụ l'anyi l'epfuje opfu doru ẹnya yeru onwanyi; ọ tọ bụdu ẹtu-opfu. Ọohumaje gẹ mụbe Chipfu gbaru ụgbugba. Ọo ya bụ; ?bụ gụnu meru g'o gude ọphu unu atsụdu ebvu; unu nọdu epfutọshi onye-ozi mu ono, bụ Mósisu?” ");
INSERT INTO izz_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Chipfu tukoshi phẹ ẹhu-eghu iya; bya abụru iya atụgbu. ");
INSERT INTO izz_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Urwukpu ono shiẹpho l'eli ụlo-ẹkwa ono palia imeli imeli; a bya l'amarụ; ekpenta nmawaa Miriyamu swọkoswoko. Ẹhu chahụe ya phọ kẹ roboo. Erọnu bya elee Miriyamu ẹnya bya ahụma g'ekpenta tụkoru iya ẹhu sweta. ");
INSERT INTO izz_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Erọnu sụ Mósisu: “Oowaa nnajịuphu mu; ba nụshinu anyi aphụ l'ọo l'anyi gude eme eswe mee iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Te ekweshinụ gẹ nwanyị-a chahụ roboo gẹ nwata, byaru l'afụta l'ẹpho ne iya; ọ nwụhuwaa anwụhu; ibe ẹhu iya rekashịhuwa erekashị.” ");
INSERT INTO izz_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tọbudu iya bụ; Mósisu bya araku Chipfu sụ: “Jiko gụbe Chileke; menaa ya g'o wekọrohu!” ");
INSERT INTO izz_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Chipfu sụ Mósisu: “Ọ -bụ lẹ nna nwanyị-a vụru ọnu-mini kpua ya l'iphu; ?iphere iya tege adụdu abalị ẹsaa tọo? Nwuru iya ye l'azụ ẹka ono, a kpọru ụlo-ẹkwa gụ-buru iya ye g'ọ nọo ujiku ẹsaa; ọ -nọ-chaẹpho ujiku ẹsaa ono; l'e duphuta iya azụ.” ");
INSERT INTO izz_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tọbudu iya bụ; a bya enwufu Miriyamu gụ-buru iya ye l'azụ ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ ono; ọ nọo ujiku ẹsaa. Ọphu ndu Ízurẹlu agbẹshiduru ije jeye teke e duphutaru iya azụ. ");
INSERT INTO izz_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","E mechaa; ẹphe shi lẹ Hazerotu l'ẹka ono lụfu je akpọbe ụlo-ẹkwa phẹ l'echiẹgu Paranu. ");
INSERT INTO izz_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Yefụ ndu e-je alị Kénanu je anwụa ya ngge; mbụ alị ono, mu eme gẹ mu nụ ndu Ízurẹlu ono. Shi l'ipfu l'ipfu, bụ ipfu ndiche phẹ họtachaa onye lanụ, e-je nụ. Ndu ịi-hota bẹ bụ unwoke, bụgbaa ishi l'ipfu, nọnu.” ");
INSERT INTO izz_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mósisu bya ahọo phẹ ẹgube ono, Chipfu pfuru ono; bya ezia phẹ sụ g'ẹphe shi l'echiẹgu Paranu tụgbua jeshia. Ndu ono, o ziru ozi ono bụkotaerupho ndu-ishi ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ọwaa bẹ bụ ẹpha phẹ: Onye shi l'ipfu Rúbẹnu bụ Shamuwa nwa Zaku; ");
INSERT INTO izz_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","onye shi l'ipfu Simiyọnu bụru Shafatu nwa Họru; ");
INSERT INTO izz_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","onye shi l'ipfu Jiuda bụru Kalẹbu nwa Jiefune; ");
INSERT INTO izz_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","onye shi l'ipfu Isaka bụru Igalu nwa Jiósẹfu; ");
INSERT INTO izz_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","onye shi l'ipfu Ifuremu bụru Hosiya nwa Nunu; ");
INSERT INTO izz_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","onye shi l'ipfu Benjiaminu bụru Paliti nwa Rafu; ");
INSERT INTO izz_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","onye shi l'ipfu Zebulọnu bụru Gadiyẹlu nwa Sodi; ");
INSERT INTO izz_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","onye shi l'ipfu Manásẹ, bụ iya bụ ipfu Jiósẹfu bẹ bụ Gadi nwa Susi; ");
INSERT INTO izz_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","onye shi l'ipfu Danu bụru Amiyẹlu nwa Gemali; ");
INSERT INTO izz_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","onye shi l'ipfu Asha bụru Seturu nwa Mayịkelu; ");
INSERT INTO izz_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","onye shi l'ipfu Nafụtali bụru Nahubi nwa Vofusi; ");
INSERT INTO izz_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","onye shi l'ipfu Gadu bụru Geyuwẹlu nwa Maki. ");
INSERT INTO izz_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Noo ẹpha unwoke ono, Mósisu yeru g'ẹphe je anwụa ngge l'alị Kénanu bụ ono. Mósisu woru Hosiya nwa Nunu gụbe Jioshuwa. ");
INSERT INTO izz_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mósisu bya ezia phẹ g'ẹphe jeshia ngge l'alị Kénanu sụ phẹ: “Unu tsoru echiẹgu ndọhali bahụ l'alị úbvú úbvú ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Unu je ahụma g'alị ono gbaru; mẹ gẹ ndu bu iya nụ dụ. Unu maru ?ọkpehu dụ phẹ; tọo ?ẹphe rwụhuru arwụhu? ?Ẹphe ha l'ọtu; tọo ?ẹphe habe ahabe? ");
INSERT INTO izz_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Unu maru ?bụ alị, dụ ree; tọo alị, dụ ẹji? Unu maru mkpụkpu, ẹphe bugbaa: ?bụ mkpụkpu, a ta kpụ-pheduru igbulọ mgburugburu; tọo mkpụkpu, a kpụshiru ike? ");
INSERT INTO izz_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Unu amaru g'alị phẹ dụ. Unu maru ?bụ alị emehuje iphe, e meberu iya; tọo ẹjo alị? Unu amaru ?oshi dụ iya; tọo ?oshi ta adụdu iya? G'obu shihukwa unu ike. Unu egude akpụru oshi, shi l'alị ono lwa.” Teke ono bẹ bụ teke akpụru vayịnu mbụ anọduje achashịgbaa. ");
INSERT INTO izz_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Noo ya; ẹphe tụgbua jeshia je anwụkota alị ono ngge; shita l'echiẹgu Zinu je akpaa lẹ Rehobu; mẹ a -nọdu eje Hamatu. ");
INSERT INTO izz_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ẹphe tsoru echiẹgu ndọhali ono jeye ẹphe rwua mkpụkpu Hẹburonu, bụ ẹka Ahimanu; mẹ Sheshayi; mẹ Talụmayi, bụ ndu shi l'eri Anaku bu ebubu. (A kpụru mkpụkpu Hẹburonu; ọ nọo apha ẹsaa; tẹmanu a kpụa mkpụkpu Zowanu ọphu dụ l'alị Ijiputu.) ");
INSERT INTO izz_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ẹphe jerwuẹpho lẹ nsụda Ẹshukolu; ẹphe gbukwota ẹkali vayịnu lanụ, akpụru wọpfuru awọpfuru. Ụmadzu labọ l'ime phẹ pyokafu iya l'oshi, dụ ogologo parụ; onye lanụ parụ iya l'ishi lanụ; onye ọphuu parụ iya l'ishi lanụ. Ẹphe wọkokwaapho akpụru itorokuma; mẹ akpụru oshi figu wolata. ");
INSERT INTO izz_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","A gụbe ẹka ono nsụda Ẹshukolu, bụ iya bụ “wọpfulaa”; kẹle ọo l'ẹka ono bẹ ndu Ízurẹlu gbukwotaru ẹkali vayịnu, akpụru wọpfuru awọpfuru vulata. ");
INSERT INTO izz_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ẹphe nọru ụkporo abalị ugbo labọ g'ẹphe jeru anwụ ngge l'alị ono; tẹmanu ẹphe lwa. ");
INSERT INTO izz_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ẹphe bya alwapfuta Mósisu mẹ Erọnu; waa ndu Ízurẹlu l'ophu l'echiẹgu Paranu, dụ lẹ mkpụkpu Kadẹshi. Ẹphe bya edooru Mósisu; mẹ Erọnu; waa ndu Ízurẹlu l'ophu g'ẹphe jeru; bya egoshi phẹ akpụru oshi, shi l'alị ono. ");
INSERT INTO izz_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Waa iphe, ẹphe pfuru Mósisu baa: “Anyi jewaru je ahụma alị ono, ị sụru g'anyi je ahụma. Alị ono bụ alị, mini ẹra-eswi yẹe manụ-ẹnwu asọ gborogboro. Waa akpụru oshi, shi l'alị ono baa. ");
INSERT INTO izz_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ọle ndu bu l'alị ono bẹ ọkpehu dụ; mkpụkpu, dụ iya nụ hagbaa shii; bya abụru mkpụkpu, e gude igbulọ kpụ-phee mgburugburu. Anyi hụmacharuro ndu shi l'eri Anaku l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ndu Amalẹku bẹ bu l'echiẹgu ndọhali. Ndu Hetu; mẹ ndu Jiebusu; mẹ ndu Amọru buru l'alị úbvú úbvú ẹka ono; ndu kẹ Kénanu bua kụbe ẹhu l'eze-ẹnyimu; bukwarupho l'agụga ẹnyimu Jiọ́danu.” ");
INSERT INTO izz_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tọbudu iya bụ; Kalẹbu bya emee ndu Ízurẹlu daa jii l'iphu Mósisu; bya asụ phẹ: “Unu g'anyi je alwụta alị ono g'ọ bụru nkanyi; noo kẹle anyi a-dụ ike lwụta iya.” ");
INSERT INTO izz_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Obenu lẹ ndu ono, ẹphe lẹ Kalẹbu swị je ije ono bẹ sụru: “Anyi ta adụkwa ike eje adatso ndu ono ọgu; noo kẹle ẹphe kakwa anyịbedua ọkpehu.” ");
INSERT INTO izz_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ọ bụru ẹjo nzì bẹ ẹphe byaru ezia ndu Ízurẹlu lẹ k'alị ono, ẹphe jeru anwụa ngge ono sụ: “Alị ono, anyi jeru anwụa ngge ono bẹ egbukwa ndu bu iya nụ mgbu-ọnwu. Tẹme ndu anyi hụmakotaru l'ẹka ono bụkotaru ndu hagbaa kẹ phengara phengara. ");
INSERT INTO izz_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Anyi hụmaru ndu gbaru oke mkparawa l'ẹka ono. (Oshilọkpa Anaku ono bụ l'ẹhu ndu ono, gbaru oke mkparawa ono bẹ ẹphe shi fụta.) Anyi dehucharu onwanyi edehu l'ẹnya dụgbaa g'ụnwu ogu; ọ bụru g'anyi dụ ẹphebedua bụ ono.” ");
INSERT INTO izz_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tọbudu iya bụ; ndu Ízurẹlu l'ophu rakọta ẹkwa l'ẹnyashi ono rashịa ya ike. ");
INSERT INTO izz_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ẹphe tụko g'ẹphe ha gụru aphụ kpua Mósisu yẹle Erọnu. Ẹphe nọdu epfugbaa sụ: “O gege akakwaru anyi ree l'anyi nwụshihuru l'alị Ijiputu; ọzoo l'echiẹgu-a! ");
INSERT INTO izz_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","?Bụ gụnu meru g'o gude Chipfu nọdu eme g'o duru anyi je edobe l'alị ono g'ẹphe gbushia anyi? Unyomu anyi phẹ; mẹ ụnwegirima anyi phẹ bẹ a-bya abụru ndu a kpụtacharu lẹ ndzụ. ?To gege akadụru anyi ree g'anyi laphu azụ l'alị Ijiputu?” ");
INSERT INTO izz_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ẹphe pfuaharu nwibe phẹ asụje: “G'anyi họta onye lanụ; mee ya ishi g'o duru anyi laphu azụ l'alị Ijiputu.” ");
INSERT INTO izz_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mósisu yẹle Erọnu daa kpurumu l'atatiphu igwe-ọha ndu Ízurẹlu ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jioshuwa nwa Nunu; yẹe Kalẹbu nwa Jiefune, bụ ndu yị lẹ ndu jeru ngge l'alị Kénanu ono gude ẹhu-eghu lajashịa uwe, ẹphe yeru l'ẹhu; ");
INSERT INTO izz_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","akụ opfu ekpu edzudzu-ọha Ízurẹlu ono sụ phẹ: “Alị ono, anyi jeru aghaphee bya anwụa ya ngge ono bẹ bụkwa alị, dụshikpoo ree ike. ");
INSERT INTO izz_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ọ -bụru l'anyi dụ Chipfu ree bẹ oo-duru anyi bahụ l'alị ono; nụ iya anyi; kẹle alị ono bụ alị, mini ẹra-eswi waa manụ-ẹnwu asọ gborogboro. ");
INSERT INTO izz_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Iphe, dụ iya nụ kpoloko bụepho g'unu te kwefuru Chipfu ike. Iphe ọzo bụru g'unu ba tsụshi ndu alị ono ebvu. Noo kẹle anyi e-ri phẹ gẹ nri. Ẹphe te nwedu onye egbobuta phẹ nụ; obenu l'anyịbedua bẹ Chipfu swiru eswiru. G'anyi ba tsụshinu phẹ ebvu.” ");
INSERT INTO izz_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Obenu l'iphe, bụ ndu Ízurẹlu ono g'ẹphe ha bẹ sụru g'a tụ-gbushia phẹ lẹ mkpuma. Tọbudu iya bụ; ọdu-biribiri kẹ Chipfu bya enwuaru ndu Ízurẹlu g'ẹphe ha kẹ phoo l'ụlo-ẹkwa-ndzukọ ono. ");
INSERT INTO izz_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Chipfu bya asụ Mósisu: “?Bụ teke ole bẹ ndu-a a-kpọ-beru mu ẹbo l'afụ-a? ?Bụkpoo teke ole bẹ ẹphe a-jịka-beru ekweta nkemu; yekwarụ iphe-ọhumalenya ono, mu meshigbabẹru l'ẹka ẹphe nọ ono? ");
INSERT INTO izz_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mu e-gude ẹjo iphe-ememe gbushia phẹ; mee phẹ; ẹphe abụru mkpurupyata. Mu eworu gụbedua mee l'ị bụru ọha l'ophu; ọha, parụ ẹka apaa; bya aka ọkpehu eme l'ẹphebedua.” ");
INSERT INTO izz_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mósisu sụ Chipfu: “Oowaa! Ndu Ijiputu bẹ a-nụmakwa iya mẹ i -mee ya nno. Nyatakwa l'i gude ọkpehu ngu dufuta ndu-a l'ẹka ndu Ijiputu ono. ");
INSERT INTO izz_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ẹphe e-pfukwaru iya ndu bu l'alị-a; kẹle ẹphe nụmakotawaru lẹ gụbe Chipfu swiru phẹ eswiru; nụmawa l'ẹphe egudeje ẹnya phẹ hụma gụbe Chipfu; tẹme l'urwukpu nkengu bẹ anọduje phẹ l'eli; tẹme l'ọobujeru; o -rwua l'eswe; l'i gude urwukpu, kpụru oronmono edu phẹ; o -rwua l'ẹnyashi l'i gude ọku, kpụru oronmono edukwa phẹ phọ. ");
INSERT INTO izz_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ọ -bụru l'i gbushiru ndu-a l'ugbo lanụ nta-a bẹ ọha ono, nụmajewaru ụ́dù ngu ono bẹ a-sụkwa: ");
INSERT INTO izz_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Lẹ gụbe Chipfu ta adụedu ike durwua phẹ l'alị ono, i kweru phẹ ukwe iya; ribua lẹ nte l'ịi-nụ phẹ ono; i woru phẹ gbushia l'echiẹgu.’ ");
INSERT INTO izz_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ọo ya bụ; gụbe Nnajịuphu; mu arwọ ngu g'i goshinu l'ị bụ onye ike parụ ẹka apaa; mbụ ẹgube ono, i pfujehawaru sụ: ");
INSERT INTO izz_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Chipfu bụ onye ẹhu te eghujedu eghu ẹgwegwa; bya abụru onye n-yemobu iya nyịberu anyịbe; bya abụru onye agụje nvụ l'iphe-ẹji; mẹ l'emeswe, e mesweru iya. Obenu l'ọ bụkwapho onye ta ahajẹdu onye-ikpe nmarụ kẹ mmanụ. Ọogwaje ụnwegirima ọchi iphe-ẹji, ndu nwụru phẹ nụ meru jasụ l'ọgbo k'ẹto rwua lẹ k'ẹno.’ ");
INSERT INTO izz_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Iphe, mu arwọ ngu bụ g'i gudenụ obu-imemini ngu ono, nyịberu anyịbe ono gụaru ndu-a nvụ l'ẹjo-iphe, ẹphe meru ngu; mbụ ẹgube ono, i shirọ l'alị Ijiputu gụtaru phẹ nvụ byasụ nta-a ono.” ");
INSERT INTO izz_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Chipfu bya asụ Mósisu: “Mu gụwaru phẹ nvụ ẹgube ono, ị rwọru. ");
INSERT INTO izz_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ọle; eshinu mu nọ ndzụ gẹ mu nọ iya-a; ọdu-biribiri nkemu sweta mgboko g'o swetaru iya-a; ");
INSERT INTO izz_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","bẹ ndu-a, gudewaa ẹnya phẹ hụma ọdu-biribiri mu-a; mẹ iphe-ọhumalenya ono, mu meshiru l'alị Ijiputu ono; mẹ ọphu mu meshiru l'echiẹgu; mbụ ndu ono, mecharu dale mu adale mgbo iri ono; ọphu ẹphe angaduru mu nchị ono; ");
INSERT INTO izz_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","bẹ ọ tọ dụdu onye ọphu byaru egude ẹnya hụma alị ono, mu riburu lẹ nte kwe nna phẹ ukwe iya ono. Ọphu ọ tọ dụdu iphe, bụ ndu ono, kpọru mu ẹbo ẹbo l'afụ ono, byaru ahụma iya nụ. ");
INSERT INTO izz_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ọle a -bya l'ẹhu k'onye-ozi mu ono, bụ Kalẹbu; eshi ọphu ọ bụ onye obu iya gbaru iche; tẹme ọ bụru onye gude obu iya g'ọ ha etso ụzo nkemu bẹ mu e-duru iya bahụ l'alị ono, ọ bahụru je anwụa ngge ono; ọ bụru oshilọkpa iya bẹ e-nweru alị ono. ");
INSERT INTO izz_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ọo ya bụ; eshinu ndu Amalẹku; mẹ ndu Kénanu bu lẹ nsụda nsụda; o -rwuẹpho echele; unu dakọbe shia ụzo echiẹgu ono, dụ l'ụzo, e shi eje Eze-ẹnyimu Uswe-uswe.” ");
INSERT INTO izz_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Chipfu bya asụ Mósisu yẹle Erọnu: ");
INSERT INTO izz_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“?Bụ teke ole bẹ ndu ẹjo-ememe-a a-gụnyaaru mu aphụ gụ-buhu? Mu nụmakotawaru aphụ, ndu Ízurẹlu nọ gụshia kpua mu. ");
INSERT INTO izz_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Unu karụ phẹ lẹ mụbe Chipfu sụru-a: ‘Eshinu mu nọ-a ndzụ gẹ mu nọ iya-a; bẹ mu a-tụkokpoo iphemiphe ono, mu nụmaru, unu pfushiru ono; mee unu. ");
INSERT INTO izz_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ọo l'echiẹgu-a bẹ odzu unu a-wụshiru; mbụ iphe, bụ ndu ono, nọwaru a -gbẹ l'ụkporo apha kwasẹru ono; mbụ ndu a gụru ọgu teke aagụ ọgu, bụ ndu ono, yị lẹ ndu ono, gụru ẹjo aphụ kpua mu ono. ");
INSERT INTO izz_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ọ tọ dụdu m'onye lanụ l'ime unu bya a-bahụ l'alị ono, mu woliru ẹka mu imeli kweta lẹ mu a-nụ unu g'unu buru ono; gbahaẹpho Kalẹbu nwa Jiefune; waa Jioshuwa nwa Nunu. ");
INSERT INTO izz_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ọ bụru ụnwegirima unu ono, unu sụru l'aa-kpụ lẹ ndzụ ono bẹ mu e-duru bahụ l'alị ono; g'ẹphe je amaru alị ono, unu jịkaru ono. ");
INSERT INTO izz_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A -bya l'unubẹdua; ọo l'ọma echiẹgu-a bẹ odzu unu a-wụshiru. ");
INSERT INTO izz_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ụnwegirima unu bẹ a-nọdu awụ-phe l'ọma echiẹgu-a gẹ ndu eche atụru; ghaphee nno nọo ụkporo apha labọ sụgba ishi; jee iphe-ẹhuka k'ekwegekwe unu ono; gbiriri jasụ odzu unu akwashịa l'ọma echiẹgu ono. ");
INSERT INTO izz_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Iphe, unu nọru teke unu jeru anwụ ngge l'alị ono bụ ụkporo abalị labọ. Ọ bụru ụkporo apha labọ bẹ unu e-je iphe-ẹhuka ẹjo-ememe, unu meru ye iya. Ujiku lanụ anwụtaru unu apha ophu. Ọo ya bụ g'unu a-makwanụru iphe, bụ lẹ mu bụ onye opfu unu. ");
INSERT INTO izz_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mụbe Chipfu bẹ pfuakwaru nkemu; mu mefụtajekwa iphemiphe ono l'ẹhu ndu ẹjo-ememe ono; mbụ ndu ono, dọkoberu etso mu opfu ono. Ẹphe a-tụko bụru mkpurupyata l'echiẹgu-a; mbụ l'ọo l'ẹka-a bẹ ẹphe a-tụko nwụshihukota.’ ” ");
INSERT INTO izz_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Noo ya; iphe, bụ ndu ono, Mósisu yeru; ẹphe je anwụa ngge l'alị ono, lwarụ nụ bya atụa ọnu alị ono lẹ njọ ono; mbụ shi nno mee ndu Ízurẹlu gụru aphụ kpua Mósisu ono; ");
INSERT INTO izz_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ndu ono, bụ phẹ tụru ọnu alị ẹji ẹji ono bẹ ẹjo iphe-ememe gbushikọtaru l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ọ bụru Jioshuwa nwa Nunu yẹle Kalẹbu nwa Jiefune bẹ bụ ndu phọduru nụ l'iphe, bụ ndu ono, jeru anwụa ngge l'alị ono. ");
INSERT INTO izz_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mósisu bya eworu iphe ono pfuaru ndu Ízurẹlu l'ophu; o rwua phẹ l'ẹhu; ẹphe kwatakpọo raa ẹkwa onwophẹ. ");
INSERT INTO izz_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","O -rwua l'ọnmewa ụtsu ọphu etsota mbọku ono; ẹphe tụgbua jeshia l'alị úbvú úbvú Kénanu je anọdu asụje: “Anyi mewaru iphe-ẹji. Unu g'anyi wụfukwa jeshia ẹka ono, Chipfu kweru anyi ukwe iya ono.” ");
INSERT INTO izz_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mósisu sụ: “?Bụ gụnu meru iphe unu e-me g'unu mebyia iphe, ekemu Chipfu pfuru? Ọ tọo dụkwaru unu lẹ ree! ");
INSERT INTO izz_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Unu te ejekwa; kẹle Chipfu ta nọkwa swiru unu. Unu -jee bẹ ndu ọhogu unu e-chigbushikwa unu; ");
INSERT INTO izz_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","noo kẹle ndu Amalẹku mẹ ndu Kénanu bẹ nọ unu l'ụzo atatiphu l'ẹka ono. Ẹphe e-gudekwa ogu-echi gbushikọta unu. Chipfu te eswikwaru unu; kẹle unu gbakụtawaru iya azụ.” ");
INSERT INTO izz_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Obenu l'ẹphe ta akpadụruro ishi; ẹphe tụgbua jeshia l'alị úbvú úbvú ono; ọle Mósisu waa okpoko ọgbandzu Chipfu te tsodu phẹ lụfu l'ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tọbudu iya bụ; ndu Amalẹku mẹ ndu Kénanu, bu l'alị úbvú úbvú ono datso phẹ ọgu; lwụ-kpee; chịa phẹ jeye lẹ mkpụkpu Họma. ");
INSERT INTO izz_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Waa iphe, ii-pfuru ndu Ízurẹlu baa: Unu -laẹpho alị ono, unu eje eburu ono, bụ alị ono, mu a-nụ unu ono; ");
INSERT INTO izz_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","unu -gwejeẹpho ngwẹja nụ Chipfu; unu shi l'ikpoto ẹku unu họta anụ gbua kpọo ọku gude gwee ngwẹja ọbu g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree. Unu e-meje iya nno lẹ ngwẹja-akpọ-ọku; mẹ ngwẹja, e gude apfụ ukwe-iphe e kweru; mẹ teke unu anụ iphe, shi unu l'obu; ọzoo teke unu egwe ngwẹja ọbo-iphe. ");
INSERT INTO izz_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Onye wotaru ngwẹja ono e-yekọbeje iya ngwẹja-nri bya anụ Chipfu; mbụ wota uzi lanụ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ, jiru eze ekpemu. ");
INSERT INTO izz_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","“Iphe, bụ nwatụru, e gude egwe ngwẹja-akpọ-ọku; ọzoo ngwẹja mmanụ bẹ unu e-yekọbeje ngwẹja-mẹe; mbụ mẹe, jiru nkeru-ẹno ọtu-lupfu otumu. ");
INSERT INTO izz_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“A bya l'iphe, bụ ebili, e gude egwe ngwẹja; unu yekọbeje iya ngwẹja-nri; mbụ ụzo labọ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ, jiru eze ekpemu lanụ l'úbvù iya. ");
INSERT INTO izz_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ngwẹja-mẹe ono bẹ unu e-gude mẹe, jiru nkerẹto ọtu-lupfu otumu gwee. Unu meje iya g'ọ bụru ngwẹja, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Teke ọ bụ l'ọo nwa oke-eswi bẹ unu gude abya egweru Chipfu ngwẹja-akpọ-ọku; ọzoo ngwẹja, e gude apfụ ukwe-iphe; ọzoo ọphu e gude egwe ngwẹja-ẹhu-guu; ");
INSERT INTO izz_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","g'onye egwe ngwẹja ono yekọbekwa iya ngwẹja-nri; mbụ ụzo ẹto l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ, jiru eze ekpemu labọ. ");
INSERT INTO izz_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Nokwaphọ g'unu e-wota mẹe, jiru nkeru-ẹbo ọtu-lupfu otumu gude gwee ngwẹja-mẹe. Ngwẹja ono bẹ a-bụru ngwẹja, a kpọru ọku, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Ọ bụru ẹgube ono bụ g'unu e-medzujeru iya l'iphe, bụ oke-eswi; ọzoo ebili; ọzoo nwatụru; m'ọ bụ nweghu, unu gude egwe ngwẹja. ");
INSERT INTO izz_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Noo g'unu e-medzujeru iya bụ ono l'iphe, bụ ngwẹja, unu egwekpọ egwegwe; g'ọ hahabẹ igwerigwe. ");
INSERT INTO izz_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Iphe, bụ onye a nwụru anwụnwu lẹ Ízurẹlu bẹ bụ ẹgube ono bẹ oo-meje ngwẹja, oogwe anụ Chipfu; mbụ ngwẹja, a kpọru ọku shi nno mee gẹ mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Shita l'ọgbo k'unu-a je akpaa l'ọgbo ọphu abya l'atatiphu; onye bụ onye lwarụ alwalwa, bu ebubu l'echilabọ unu -wota ngwẹja bya gẹ ya gwerụ nụ Chipfu; mbụ ngwẹja, a kpọru ọku; shi nno mee gẹ mkpọ iya dụ Chipfu ree; g'ọ bụkwaru ẹgube unu emeje bẹ oo-me. ");
INSERT INTO izz_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ọo omelalị lanụ ono dụru unubẹ ndu Ízurẹlu l'ophu; mẹ iphe, bụ ndu lwarụ alwalwa, bu l'echilabọ unu. Omelalị ono a-nọepho shita l'ọgbo unu sweru ọgbo ọphu abya nụ jasụru asụru. Ọo g'unu dụ l'atatiphu Chipfu bụ gẹ ndu lwarụ alwalwa dụkwapho. ");
INSERT INTO izz_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ọ bụru ekemu lanụ; waa omelalị lanụ bẹ dụru unu lẹ ndu lwarụ alwalwa; unu l'ẹphe buru.” ");
INSERT INTO izz_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Waa iphe, ii-pfuru ndu Ízurẹlu baa: Unu -rwuẹpho alị ono, mu edu unu eje ono; ");
INSERT INTO izz_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","unu -rijeẹpho nri, shi l'alị ono; unu ketakwa oke iya bya anụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Unu gude ukpokutu-iphe, shi l'akpụru-iphe-mbụ, unu metaru l'alị ono gheta buredi nụ Chipfu g'ọ bụru ngwẹja, shi l'ẹka eechije balị. ");
INSERT INTO izz_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ngwẹja ukpokutu iphe-mbụ, unu metaru l'alị ono bẹ unu a-nụje Chipfu jasụru asụru; mbụ e -shi l'ọgbo sweru ọgbo.” ");
INSERT INTO izz_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Sụ-a; ọ -bụru l'o nweru onye elekebuduru ẹnya darwụa ekemu-a, Chipfu tụshiru ye Mósisu l'ẹka-a; ");
INSERT INTO izz_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","mbụ ekemu ono, Chipfu shi l'ẹka Mósisu nụkota unu ono; g'ọ ha; mbụ e -shi lẹ mbọku, Chipfu tụru iya nụ unu jasụwaruroya; e -shi l'ọgbo sweru ọgbo; ");
INSERT INTO izz_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","bẹ ọ -bụru lẹ ndu Ízurẹlu te elekebeduru ẹnya darwụa ekemu ono; mbụ l'ọha Ízurẹlu l'ophu ta amadụ teke ẹphe meru iphe-ẹji ono; gẹ ndu Ízurẹlu l'ophu kpụta nwa oke-eswi gude gwee ngwẹja-akpọ-ọku; mbụ ngwẹja, e meru; mkpọ iya dụ Chipfu ree. L'e yekọbekwa iya phọ ngwẹja-nri; mẹ ngwẹja-mẹe, ayịkwaru iya phọ; waa mkpi, ee-gude gwee ngwẹja-iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","G'onye uke Chileke gwee ngwẹja ono gude pfụa ụgwo iphe-ẹji ndu Ízurẹlu ono l'ophu; g'aa-gụaru phẹ nvụ l'iphe-ẹji ono, ẹphe meru ono; kẹle ẹphe te elekebeduru ẹnya mee ya; tẹme ẹphe bya egwewaru ngwẹja nụ Chipfu lẹ k'emeswe ono, ẹphe mesweru ono; mbụ ngwẹja, a kpọru ọku; mẹ ngwẹja-iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ndu Ízurẹlu l'ophu; mẹ ndu lwarụ alwalwa, bu l'echilabọ phẹ bẹ aa-gụkotaru nvụ; noo kẹle ẹphe tụkoru mee iphe-ẹji ono; ọle ẹphe te elekebeduru ẹnya mee ya. ");
INSERT INTO izz_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Ọle-a; ọ -bụru l'ọo onye lanụ bẹ meru iphe-ẹji ono; ọphu o lekebedụru ẹnya mee ya; g'onye ọbu wota nwada eghu, gbaru apha g'e gude gwee ngwẹja-iphe-ẹji ono, o meru ono. ");
INSERT INTO izz_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Onye uke Chileke bẹ a-nọdu l'iphu Chipfu pfụa ụgwo iphe-ẹji ono, onye ono elekebeduru ẹnya mee ono. A -pfụwa ụgwo iphe-ẹji ono, onye ono meru ono; bẹ a gụwaru iya nvụ. ");
INSERT INTO izz_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ọo ekemu lanụ ono bẹ dụru iphe, bụ onye meru iphe-ẹji, o lekebedụru ẹnya mee; m'ọ bụ onye a nwụru anwụnwu lẹ Ízurẹlu; m'ọ bụ onye lwarụ alwalwa.” ");
INSERT INTO izz_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“O bekwanụ l'onye lekeberu ẹnya mee iphe-ẹji; mẹ a nwụru onye ọbu anwụnwu lẹ Ízurẹlu; ọzo l'ọ bụ onye lwarụ alwalwa; bẹ onye ọbu pfubyiakwaru ẹpha Chipfu. Onye dụ nno bẹ ee-bufu ebufu l'echilabọ ndibe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Eshi ọphu onye ono ta adụdu iphe, ọ gụberu Opfu Chipfu; bya emebyiwaa ekemu Chipfu; bẹ ee-bufuje onye ọbu ebufu; iphe-ẹji, o meru atụ-koru iya l'ishi.” ");
INSERT INTO izz_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Lẹ teke ndu Ízurẹlu nọkwadu l'echiẹgu bẹ o nweru nwoke lanụ, e guderu g'ọokpa nkụ l'eswe-atụta-unme. ");
INSERT INTO izz_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ndu hụmaru iya l'ẹka ọokpa nkụ ono kpụta iya kpụ-pfushiaru Mósisu yẹle Erọnu; mẹ ndu Ízurẹlu l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ẹphe kpụta iya tụ-chia atụ-chi; kẹle e teke pfukahadu iphe, ee-me iya. ");
INSERT INTO izz_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ọo ya bụ; Chipfu sụ Mósisu: “Nwoke ono bẹ ee-gbukwa egbugbu. Gẹ ndu Ízurẹlu l'ophu kpụfukwa iya azụ ẹka ẹphe kpọberu ụlo-ẹkwa phẹ je atugbua ya lẹ mkpuma.” ");
INSERT INTO izz_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Tọbudu iya bụ; ndu Ízurẹlu bya akpụta iya kpụfu azụ ẹka ono, ẹphe kpọberu ụlo-ẹkwa phẹ ono; je eworu iya tugbua lẹ mkpuma, bụ gẹ Chipfu sụru Mósisu g'e mee ya. ");
INSERT INTO izz_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Waa iphe, ii-pfuru ndu Ízurẹlu baa: Unu kpajẹru ịyanguyangu ye lẹ mgburẹku uwe mgbalanụ unu ishi ẹno. Iphe, unu e-gudeje kpaa ịyanguyangu ono abụru oghu, dụ urwukpu-urwukpu. Noo g'unu e-meje iya bụ ono; e -shi l'ọgbo sweru ọgbo. ");
INSERT INTO izz_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ịyanguyangu ono bẹ unu e-leje ẹnya gude nyatakọta ekemu mụbe Chipfu; k'ọphu unu a-nọduje eme iya ememe; haa ẹgu ẹjo-iphe ono, anọduje agụgbaa obu unu; mẹ ọphu ẹnya unu ahụmagbabe ono; mbụ ẹjo-iphe ono, unu shi anọduje emegbaa ono. ");
INSERT INTO izz_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ọo ya bụ; k'ọphu unu a-nyatajẹ ekemu; bya eme iya ememe; shi nno dụru Chileke unu nsọ. ");
INSERT INTO izz_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ọo mbẹdua bụ Chipfu; bụru Chileke unu; mbụ onye ono, dufutaru unu l'alị Ijiputu; gẹ mu bụru Chileke unu ono. Ọo mu bụ Chipfu, bụ Chileke unu.” ");
INSERT INTO izz_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","O be teke ono; Kora nwa Izuha, bụ nwanwa Kohatu; onye eri Lívayi; waa Detanu; mẹ Abiramu, bụ ụnwu Eliyabu; mẹ Ọnu nwa Pẹleti, bụ ndu ipfu Rúbẹnu bya achịta nemadzụ yeru onwophẹ; ");
INSERT INTO izz_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ẹphe wulihu tsoahaa Mósisu opfu. Ndu ono, tso phẹ nụ ono bụgbaa ndu a họtaru g'ẹphe bụru ndu-ishi ndu Ízurẹlu; bya abụru ndu a maru ẹpha phẹ lẹ Ízurẹlu l'ophu. Iphe, ẹphe dụ bụ ụkporo ụmadzu iri l'ẹbo l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ẹphe kpakọ onwophẹ byapfutashịa Mósisu yẹle Erọnu bya asụ phẹ: “Unu metawaru iphe ọbu; o tsobe paa! Ndu Ízurẹlu l'ophu bẹ unu maru l'ẹphe dụ nsọ l'ẹhu l'ẹhu; tẹme Chipfu swiru phẹ eswiru. ?Bụ gụnu meru g'o gude unu palia onwunu eli eli dobe doghata ndu kẹ Chipfu l'ophu?” ");
INSERT INTO izz_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mósisu nụmaepho iphe ono, ẹphe pfuru ono; ọ daa kpupyabẹ iphu l'alị. ");
INSERT INTO izz_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ọ sụ Kora yẹle ndu ẹphe l'iya swị: “O -rwua l'ụtsu echele bẹ Chipfu e-goshiwarọ onye ọphu bụ nkiya; waa onye dụ nsọ; onye ọ họtaru bẹ oo-me g'ọ byakube iya ntse. ");
INSERT INTO izz_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Waa iphe, unu l'e-me baa: Gẹ gụbedua, bụ Kora; gụ lẹ ndu etso ngu nụ; wota iphe, aagụje ọku; ");
INSERT INTO izz_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","o -be echele; unu agụru ọku ye iya; bya eye iya ụ̀nwù-isẹnsu l'atatiphu Chipfu. Onye bụ onye Chipfu họtaru bẹ a-bụru onye dụ nsọ. Unubẹ eri Lívayi metawaru iphe ọbu; o tsobe paa!” ");
INSERT INTO izz_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mósisu bya asụkwapho Kora: “Unu ngabẹ nchị; unubẹ eri Lívayi! ");
INSERT INTO izz_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Chileke kẹ Ízurẹlu họtaru unu dobe iche lẹ Ízurẹlu l'ophu; mee g'unu nọdu iya ntse; eje ozi, dụ l'ụlo-ẹkwa kẹ Chipfu; mẹ g'unu pfụjeru l'atatiphu ndu Ízurẹlu l'ophu jeru phẹ ozi; ọphu ono asụdu unu. ");
INSERT INTO izz_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","O meru gẹ gụbedua; mẹ ndu Lívayi ibe ngu phẹ nọdu iya ntse; nta-a bẹ unu achọfua ụzo, unu e-shi bụru ndu-uke Chileke. ");
INSERT INTO izz_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ọ kwa Chipfu bẹ gụ lẹ ndu etso ngu nụ g'ẹphe ha tụkoru etso opfu. ?Bụ onye bẹ Erọnu bụ kẹ g'unu tanyịru iya ntanyị?” ");
INSERT INTO izz_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ọo ya bụ; Mósisu bya ezia g'e je ekua Detanu; mẹ Abiramu, bụ ụnwu Eliyabu. Ẹphe sụ l'ẹphe ta abyadụ. ");
INSERT INTO izz_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Sụ: “?I rwutaru anyi rwufuta l'alị ono, ẹra-eswi waa manụ-ẹnwu asọ gborogboro ono; ọphu ono asụdu ngu. Ị nọdu emefua g'i woru anyi gbushia l'echiẹgu l'ẹka-a; bya emefukwaphọ g'i mee onwongu onye-ishi anyi. ");
INSERT INTO izz_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ọphu ka njọ bụ l'i ti dubaduru anyi l'alị, ẹra-eswi waa manụ-ẹnwu asọ gborogboro; mbụ alị ẹka anyi a-kọbeje iphe; waa ẹka anyi e-me opfu-vayịnu. ?Iime g'i mee ndu-a mkpurukpuru-ẹnya tọo? Waawaa! Anyi ta abyadụ!” ");
INSERT INTO izz_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ọo ya bụ; ẹhu ghushiahaa Mósisu eghu ike; ọ sụ Chipfu: “G'ọ tọ dụkwa ngwẹja, ndu-a gwerụ nụ ngu, ịi-nata. Mu ta natajẹkwaru phẹ g'ọ ka mma l'ọo nkapfụ-ịgara phẹ mẹ nanụ; ọphu mu emekajẹduru phẹ iphe mẹ onye lanụ.” ");
INSERT INTO izz_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mósisu sụ Kora: “Gẹ gụbedua yẹe ndu etso ngu nụ g'ẹphe ha tụko bya l'iphu Chipfu echele. Gẹ gụbedua; waa ẹphebedua; waa Erọnu tụko byakọta. ");
INSERT INTO izz_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","G'onyenọnu gudekwa iphe, aagụje ọku; ye iya ụ̀nwù-isẹnsu gude bya l'atatiphu Chipfu. Iphe, ọo-dụ; mbụ iphe ono, aagụje ọku ono bụ ụkporo iri l'ẹbo l'iri. Gụbedua, bụ Kora l'onwongu e-gudekwaphọ nkengu; Erọnu egude nkiya bya.” ");
INSERT INTO izz_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Tọbudu iya bụ; onyenọnu wota iphe ono, aagụje ọku ono; bya agụru ọku ye iya; ye iya ụ̀nwù-isẹnsu je apfụgbaaru l'ọnu ụlo-ẹkwa-ndzukọ ono. Ẹphe lẹ Mósisu mẹ Erọnu tụko pfụru l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora bya achịkobe ọha Ízurẹlu ono l'ophu; l'ọnu ụlo-ẹkwa-ndzukọ ono g'ẹphe tso Mósisu yẹle Erọnu opfu. No iya; ọdu-biribiri kẹ Chipfu sọpyabe ọha Ízurẹlu ono l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chipfu sụ Mósisu yẹle Erọnu: ");
INSERT INTO izz_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Unu shi l'echilabọ igwe ọha ono fụta gẹ mu bya atụko phẹ mebyishikọta lẹ ntabu ẹnya lanụ.” ");
INSERT INTO izz_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mósisu yẹle Erọnu daa; kpube iphu l'alị chishia sụ: “Oowaa! Gụbe Chileke; mbụ Chileke bụ ishi ndzụ iphe, bụ nemadzụ l'ophu; ?ii-gude k'iphe-ẹji, onye lanụ metaru tụ-koshi ọha l'ophu oke ẹhu-eghu ngu tọo?” ");
INSERT INTO izz_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Pfuaru ọha Ízurẹlu ono l'ophu g'ẹphe kpụriberu l'ibiya ọphu ụlo-ẹkwa Kora; mẹ Detanu; waa Abiramu nọ.” ");
INSERT INTO izz_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mósisu gbalihu; yẹle ndu bụ ọgerenya Ízurẹlu swịru jepfushia Detanu waa Abiramu. ");
INSERT INTO izz_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ọ sụ igwe ọha ono: “Unu lụfutakwa l'ụlo-ẹkwa ndu ẹjo-ememe ono! Unu te edenyikwa ẹka l'iphe, bụ nkephẹ; ọdumeka bẹ Chipfu e-gudekwa k'iphe-ẹji, ẹphe meru woru unu megbushia.” ");
INSERT INTO izz_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ọo ya bụ; onyemonye buru ụbara yeru ụlo-ẹkwa Kora; mẹ kẹ Detanu; waa kẹ Abiramu. Detanu yẹle Abiramu bya afụta pfụru l'ọnu ụlo-ẹkwa phẹ; ẹphe l'unyomu phẹ; mẹ ụnwu phẹ unwoke; waa ụnwegirima phẹ. ");
INSERT INTO izz_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mósisu sụ: “Ọo iphe-a bẹ unu e-gude maru l'ọo Chipfu ziru mu gẹ mu mee iphemiphe ono; l'ọ tọ bụdu iphe, gbatarụ mu l'uche bẹ mu emeje. ");
INSERT INTO izz_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ọ -bụru lẹ ndu-a bẹ nwụhuru gẹ nemadzụ mmanụ anwụhuje; mbụ-a; ọ -bụru l'ọo g'ọonwujeru nemadzụ l'ophu bẹ ọ nwụru phẹ; ọo ya bụ l'ọ tọ bụdu Chipfu ziru mu iphe ono, mu eme ono. ");
INSERT INTO izz_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ọle ọ -bụru lẹ Chipfu meru g'iphe te emejeduru nụ mee; mbụ; alị -saa ọnu lwegbushia phẹ; mẹ iphemiphe, ẹphe nweru enweru; mbụ; ẹphe bụru ndu wụbaru l'alị-maa lẹ ndzụ; ọo ya bụ; unu amaru l'ọ tọ dụdu iphe, ẹphe gụberu Chipfu.” ");
INSERT INTO izz_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Epfughe, Mósisu epfughe opfu ono; alị ono, Detanu phẹ pfụru ono kejaha ẹbo; ");
INSERT INTO izz_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","alị ono saa ọnu lwekọta phẹ; mẹ ndibe phẹ; mẹ ndu kẹ Kora; mẹ ivu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ẹphe wụbakota l'alị-maa lẹ ndzụ; mẹ iphemiphe, ẹphe nweru enweru; alị kpupyabẹ phẹ; ẹphe tụko g'ẹphe ha lakọta l'iyi l'echilabọ ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ọ bụru mkpu, ẹphe chishiru bẹ meru; ndu Ízurẹlu, nọ-pheru ẹka ono mgburugburu ye ọkpa l'ọso; arajẹ sụ: “Alị abyakwa anyi elwelwe-o!” ");
INSERT INTO izz_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Noo ya; ọku, shi l'ẹka Chipfu bya ekegbushikọta ụmadzu ụkporo iri l'ẹbo l'ụmadzu iri phọ, shi akpọ ụ̀nwù-isẹnsu ọku phọ. ");
INSERT INTO izz_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Pfuru Eleyaza, bụ nwa Erọnu; bya abụru onye uke Chileke g'ọ lọshia iphe ono, aagụje ọku l'ime ọku ono; vọshia icheku-ọku, dụ iya nụ tụkaa nanụ nanụ; noo kẹle iphe ono dụ nsọ; ");
INSERT INTO izz_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","mbụ iphe ono, aagụje ọku ono, bụ kẹ ndu ono, meru iphe-ẹji shi nno tuphaa ndzụ phẹ ono. Ọ -lọshichaa ya; g'a kụsaa ya akụsa g'o chisaa echisa g'e kpubeje iya l'eli ọru-ngwẹja Chipfu. Noo kẹle a nụwaru iya Chipfu; ọ bụru iya bụ l'ọ dụwaa nsọ. Iphe ono bẹ a-bụru iphe-ọhubama l'ẹka ndu Ízurẹlu nọ.” ");
INSERT INTO izz_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ọo ya bụ; Eleyaza, bụ onye uke Chileke bya achịkoo iphe ono, aagụje ọku ono, bụ onyirubvu bẹ e gude mee ya ono; mbụ iphe ono, ndu ono, ọku kegbushiru gude bya akpọ ụ̀nwù-isẹnsu ọku ono. A kụsaa ya ọsa k'ọphu ee-kpubeje iya l'eli ọru-ngwẹja Chipfu; ");
INSERT INTO izz_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","g'ọ bụru iphe, ndu Ízurẹlu e-gudeje nyata l'ọ tọ dụdu onye ọzo, bụ onye ta abụdu oshilọkpa Erọnu, a-kpụritajeru bya g'ọ kpọ ụ̀nwù-isẹnsu ọku l'atatiphu Chipfu; ọdumeka bẹ ọo-dụkwaru onye ono ẹgube ono, ọ dụru Kora yẹle ndu tsoru iya nụ; mbụ ẹgube ono, Chipfu shi l'ẹka Mósisu pfua ya ono. ");
INSERT INTO izz_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","O -rwuẹpho nchitabọhu iya; ndu Ízurẹlu l'ophu wata agụru Mósisu yẹle Erọnu aphụ asụje: “Ọ kwa ụnwu Chipfu bẹ unu gbushiru ẹgube ono.” ");
INSERT INTO izz_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Tọbudu iya bụ; ọha Ízurẹlu ono l'ophu bya akpakọbe onwophẹ g'ẹphe wata etso Mósisu yẹe Erọnu opfu. Ẹphe jeshia ele ẹnya l'ụlo-ẹkwa-ndzukọ; urwukpu sọ-kputewa iya; ọdu-biribiri kẹ Chipfu bya enwua kẹ phoo. ");
INSERT INTO izz_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mósisu yẹle Erọnu bya ejeshia l'atatiphu ụlo-ẹkwa-ndzukọ ono; ");
INSERT INTO izz_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Unu shi l'echilabọ igwe ọha ono lụfuta gẹ mu bya atụko phẹ mebyishikọta lẹ ntabu ẹnya lanụ.” Ẹphe daẹpho kpurumu l'iphu Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Tọbudu iya bụ; Mósisu sụ Erọnu: “Wota iphe, ịiguje ọku; shi l'ọru-ngwẹja Chipfu gụta ọku ye iya. L'i woru ụ̀nwù-isẹnsu ye iya mee ẹgwegwa gude jepfu igwe ọha ono g'ị pfụa ụgwo iphe-ẹji phẹ. Noo kẹle oke ẹhu-eghu, shi l'ẹka Chipfu bẹ talihuru nụ; ẹjo iphe-ememe dapfutawa phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ọo ya bụ; Erọnu wota iphe ono ẹgube Mósisu pfuru iya ono; bya agbagbụa bahụ l'echilabọ igwe ọha ono. O jerwushia; ẹjo iphe-ememe ono nọdu egbushiwaa ndu ono. Ọ bya akpọoru Chipfu ụ̀nwù-isẹnsu ono ọku; bya apfụa ụgwo iphe-ẹji ndu ono. ");
INSERT INTO izz_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ọ pfụru l'echilabọ ndu ọphu nwụhuwaru anwụhu; waa ndu ọphu nọ ndzụ; ẹjo iphe-ememe ono bụru bugemu. ");
INSERT INTO izz_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ndu ẹjo iphe-ememe ono gbushiru bẹ dụ ụkporo ụnu ụmadzu; l'ụnu ụmadzu iri l'ishii; l'ụkporo ụmadzu iri l'ise; a -gụfukwa ndu ọphu nwụhuru l'opfu ẹhu Kora. ");
INSERT INTO izz_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Erọnu mechaa bya ejepfushia Mósisu l'ọnu ụlo-ẹkwa-ndzukọ; noo kẹle ẹjo iphe-ememe ono mebuhuwaru. ");
INSERT INTO izz_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Pfuaru ndu Ízurẹlu g'ẹphe chịe ngu mgbọro iri l'ẹbo. Gẹ ndu-ishi l'ipfu, nọnu nụchaa ngu mgbọro nanụ nanụ. L'i deshia ẹpha onyemonye lẹ mgbọro nkiya. ");
INSERT INTO izz_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Onye ii-de ẹpha iya lẹ mgbọro k'ipfu Lívayi bụ Erọnu. Kẹle onyenọnu lẹ ndu-ishi l'ipfu l'ipfu e-nweru mgbọro lanụ. ");
INSERT INTO izz_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","L'ị chịta mgbọro ono je awụshi l'ụlo-ẹkwa-ndzukọ l'iphu okpoko-ekemu, bụ ẹka ono, mu abyapfutajẹ unu ono. ");
INSERT INTO izz_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mgbọro k'onye ọphu mu họtaru bẹ a-kpofuta ome. Ọo ya bụ gẹ mu e-shi nno mee gẹ ndu Ízurẹlu wofu mụbe Chipfu ọnu l'ẹhu l'aphụ ono, ẹphe anọduje agụshi ekpu unu tekenteke ono.” ");
INSERT INTO izz_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Tọbudu iya bụ; Mósisu bya epfuaru iya ndu Ízurẹlu. Ndu-ishi l'ipfu nọnu bya anụgbaa ya mgbọro nanụ nanụ; ọ tụko dụ mgbọro iri l'ẹbo. Mgbọro kẹ Erọnu yịkwaru iya phọ. ");
INSERT INTO izz_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mósisu chịta iya je edobe l'atatiphu Chipfu l'ụlo-ẹkwa l'ẹka ono, okpoko-ekemu Chileke nọ ono. ");
INSERT INTO izz_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","O -rwua nchitabọhu iya; Mósisu bahụ l'ụlo-ẹkwa ẹka ono, okpoko-ekemu Chileke nọ ono; bya ahụma gẹ mgbọro kẹ Erọnu, bụkwanu onye nọ-chiru ẹnya ipfu kẹ Lívayi kpofushiru ome; rwushia irwu; tụshikwapho ige; bya amịshia akpụru alụmondu. ");
INSERT INTO izz_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ọo ya bụ; Mósisu bya achịfuta mgbọro ono g'ọ ha l'atatiphu Chipfu chịjeru ndu Ízurẹlu. Ẹphe lee ya ẹnya; onyenọnu wotachaa mgbọro ọphu bụ nkiya. ");
INSERT INTO izz_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Chipfu sụ Mósisu: “Woru mgbọro kẹ Erọnu dobephu azụ l'iphu okpoko-ekemu ono; g'ọ dụ l'ẹka ono bụru iphe-ọhubama nọduru ndu ono, ekwefuje ike ono; g'ọ bụru iphe, a-nọduje alọ phẹ ẹka lẹ nchị g'ẹphe haa agụ-phe aphụ ekpu mụbe Chipfu; a -nọnyaa ẹphe nwụshihu.” ");
INSERT INTO izz_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ọ bụerupho gẹ Chipfu sụru gẹ Mósisu mee ya bụ g'o meru iya. ");
INSERT INTO izz_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ndu Ízurẹlu sụ Mósisu: “Anyi a-nwụshihuchaakwa! Anyi laakwaru maa! Anyi lakọtaakwaru maa g'anyi ha! ");
INSERT INTO izz_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Onyemonye, jekubekpọoru ụlo-ẹkwa Chipfu ntse bẹ a-nwụhukwa nụ. ?Anwụhu a-tụko anyi gbuẹbe tọo?” ");
INSERT INTO izz_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Chipfu sụ Erọnu: “Gụbedua l'onwongu; waa ụnwu ngu; mẹ iphe, bụ ọnu-ụlo nna ngu l'ophu bẹ ọ tụ-koru l'ishi; mbụ ẹjo-iphe, e meru l'ụlo mu; ọ bụru gụbedua l'onwongu kwaphọ; mẹ ụnwu ngu bẹ ọ tụ-kokwarụpho l'ishi; mbụ ẹjo-iphe, e meru meswee k'abụ uke. ");
INSERT INTO izz_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Duta ụnwunna ngu phẹ, bụ iya bụ eri Lívayi, bụ ipfu nna ngu g'ẹphe yejeru ngu ẹka; gụbedua waa ụnwu ngu phẹ bẹ a-nọdu l'atatiphu ụlo-ẹkwa ẹka okpoko-ekemu Chileke nọ eje ozi. ");
INSERT INTO izz_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ẹphe a-nọdu eje ozi, i ziru phẹ; mẹ ozi, dụkota l'ụlo-ẹkwa. Ọle ọo ẹpho g'ẹphe te jekubekwa mgboru ụlo Chipfu; waa mgboru ọru-ngwẹja Chileke; ọ -dụdu bẹ gụ l'ẹphe a-tụkokwa nwụshihu. ");
INSERT INTO izz_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Gụ l'ẹphe a-tụgba nanụ; ẹphe eje ozi, dụ l'ụlo-ẹkwa-ndzukọ; mbụ iphe, bụkota ozi, dụ l'ụlo-ẹkwa ono. G'onye abụdu onye Lívayi ta abyakubejekwa unu ntse. ");
INSERT INTO izz_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ọo unubẹdua a-nọdu eje ozi, dụ l'ụlo Chipfu; mẹ ozi k'ọru-ngwẹja Chileke; k'ọphu Chileke ata atụ-koshiẹdu ndu Ízurẹlu oke ẹhu-eghu iya ọzo. ");
INSERT INTO izz_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Sụ-a; mu họtawaru ndu Lívayi, bụ ụnwunna unu l'echilabọ ndu Ízurẹlu. Ẹphe bụ ndu e woru nụ unu; bụru ndu e doberu mụbe Chipfu iche g'ẹphe jeje ozi, dụ l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Gụbedua waa ụnwu ngu bẹ a-nọdu eje ozi k'egweru Chileke ẹja; mbụ l'unu a-nọdu ejekọta ozi k'ọru-ngwẹja Chileke; waa ozi, dụ l'ime ẹka ẹkwa-mgbochi nọ. Noo ozi, unu a-nọdu eje bụ ono. Mu yeru unu k'egwe ngwẹja ono l'ẹka g'ọ bụru iphe-ọma, mu meru unu. Onye ọzo, abụdu oshilọkpa Lívayi -byaru lẹ mgboru ụlo Chipfu bẹ a-nwụhukwanu.” ");
INSERT INTO izz_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","No iya; Chipfu sụ Erọnu: “Nta-a bẹ mu woakwaru iphemiphe, bụ iphe, aanụje mu anụnu ye ngu l'ẹka. Iphemiphe, bụ iphe, ndu Ízurẹlu doberu mu nsọ; bụwaa ngu bẹ mu nụkotaru iya g'ọ bụru okiphe ngu; bụru okiphe ụnwu ngu jasụru asụru. ");
INSERT INTO izz_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ọwaa bẹ a-bụfuaru okiphe unu l'iphe, kakọta adụ nsọ ono, bụ ọphu a ta kpọduru ọku: Iphe, ẹphe gudekọta bya egwe ngwẹja nụ mu; mbụ iphe, shi lẹ ngwẹja-nri; mẹ iphe, shi lẹ ngwẹja-iphe-ẹji; mẹ ọphu shi lẹ ngwẹja-apfụ-ụgwo; mbụ iphemiphe ono, ẹphe nụru mu g'ọ bụru ngwẹja, kakọta adụ nsọ ono. Ndu k'ono bẹ bụkota okiphe, rwuberu gụbe Erọnu; waa ụnwu ngu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Unu nọduje l'ẹka kakọta adụ nsọ ria ya. Ọ bụru unwoke kpoloko bẹ e-rije iya nụ. G'ọ bụkwaru unu iphe, dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Iphe, bụ iphe, ndu Ízurẹlu doberu mu iche; mbụ iphe, shikọta lẹ ngwẹja-amama bẹ bụ nkengu. Mu wowaru iya nụ gụ l'ụnwu ngu unwoke; mẹ ụnwada ngu jasụru asụru. Iphe, bụ ndibe ngu, ntụrwu adụdu l'ẹhu bẹ e-tsojeru ria ya. ");
INSERT INTO izz_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Iphe, ndu Ízurẹlu nụru Chipfu l'ọo iphe-mbụ, shi l'iphe, ẹphe metaru l'alị bẹ bụ ngu nwe iya; mbụ iphe, bụ manụ olivu, kakọta ree; mẹ iphe, bụ mẹe ọ̀phúú, kakọta ree; waa iphe, bụ ereshi, kakọta ree. ");
INSERT INTO izz_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Iphe, bụkota iphe, ẹphe wotaru Chipfu l'ọo akpụru-iphe-mbụ, ẹphe metaru l'alị phẹ bụ nkengu. Iphe, bụ ndibe ngu, ntụrwu adụdu l'ẹhu bẹ l'e-tsojeru ria ya. ");
INSERT INTO izz_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Iphe, bụ iphe, e yeru Chipfu l'ẹka l'alị Ízurẹlu bẹ bụkota nkengu. ");
INSERT INTO izz_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Iphe, bụ iphe, vuchakpọo ụzo waa ẹkpa-nwa ne iya; anụ mẹ nemadzụ; mbụ ọphu e woru nụ mụbe Chipfu a-bụkotajeru nkengu. Obenu l'aa-pfụje ụgwo gude gbata iphe, bụ ọkpara, shi l'ẹhu nemadzụ; nokwaphọ g'aa-pfụje ụgwo gude gbata iphe, bụ anụ mbụ, shi l'ẹhu anụ, aasọ nsọ fụta. ");
INSERT INTO izz_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ẹphe -nọwaa ọnwa ophu bẹ aa-pfụje mkpọla-ọchaa, ẹrwa iya dụ shẹkelu ise gude gbata phẹ; mbụ mkpọla-ọchaa, bụ iphe, eegudeje atụ ẹrwa iphe l'eze-ụlo Chileke bẹ e gude tụa ya. ");
INSERT INTO izz_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Obenu lẹ nweswi, ne iya vuru ụzo nwụa; mẹ nwatụru, ne iya vuru ụzo nwụa; mẹ nweghu, ne iya vuru ụzo nwụa bẹ aa-hajẹ agbata. Ndu k'ono bẹ dụ nsọ. Unu gbuje iya; phee mee ya l'eli ọru-ngwẹja ono; unu akpọje ẹba iya ọku gude gwee ngwẹja-akpọ-ọku; mbụ ngwẹja, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Anụ iya a-bụru nkengu; ẹgube ono, ǹdụ́-iphe, e gude gwee ngwẹja-amama; mẹ ụtapfu ọkpa ẹkutara anụ bụ nkengu ono. ");
INSERT INTO izz_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Iphemiphe, Ízurẹlu doberu nsọ g'ẹphe nụ Chipfu bẹ mu nụwaru gụ l'ụnwu ngu unwoke; mẹ ụnwada ngu phẹ g'ọ bụru nkunu jeye lẹ gbururu. Ono bụ nrakụnraku ọgbandzu mu lẹ ngu; mẹ awa ngu l'ophu. Ọgbandzu ono a-nọ jasụru asụru. O to nwedu echihu.” ");
INSERT INTO izz_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Chipfu bya asụ Erọnu: “Gẹ ndu Ízurẹlu te emejekwa alị gbaa unu; ọphu ẹphe ahẹjekwa unu okiphe. Ọ kwa mbẹdua bụ okiphe, unu hatarụ. Ọo mu bụ okiphe, unu ketarụ l'ẹka ndu Ízurẹlu.” ");
INSERT INTO izz_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“A bya abya l'ẹhu ndu Lívayi; eshinu ẹphe eje ozi, dụ l'ụlo-ẹkwa-ndzukọ bẹ mu nụkotawaru phẹ iphe, shi l'oke-lanụ-l'ụzo-iri, ndu Ízurẹlu anụje mu. Ono bụwaa okiphe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Shita nta-a kwasẹru bẹ ọ tọ dụdu onye Ízurẹlu ọzo, e-jekube mgboru ụlo-ẹkwa-ndzukọ; ọdumeka bẹ iphe-ẹji onye ọbu a-tukokwaru iya l'ishi; onye ono a-nwụhukwa. ");
INSERT INTO izz_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ọo ndu Lívayi bẹ eje ozi, dụ l'ụlo-ẹkwa-ndzukọ dụ l'ẹka; ọ bụru phẹ bẹ ẹjo-iphe, e meru l'ẹka ono tukoru l'ishi. Iphe ono, a-bụru nsọ, a-dụ jasụru asụru; mbụ jasụ l'ọgbo sweru ọgbo. Ọ tọ dụdu iphe, ẹphe eketa l'ẹka ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Oke-lanụ-l'ụzo-iri, ndu Ízurẹlu anụje mu; bẹ mu nụwaru ndu Lívayi g'ọ bụru okiphe phẹ. Ọo ya meru g'o gude mu pfua opfu ẹhu phẹ sụ: ‘Ẹphe ta ahatadu okiphe l'ẹka ndu Ízurẹlu.’ ” ");
INSERT INTO izz_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Pfuaru ndu Lívayi sụ phẹ lẹ-a: Ọ -bụru l'unu natarụ ndu Ízurẹlu oke-lanụ-l'ụzo-iri ono, mu nụru unu g'ọ bụru okiphe unu ono; unu shije l'ime iya woru oke-lanụ-l'ụzo-iri nụkwapho Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Iphe, unu nụru bẹ aa-nọduje agụru unu g'ọ bụ ereshi, shi l'ẹka l'eechije ereshi; a gụkwaa ya phọ gẹ mẹe, shi l'ẹka aakụje mẹe. ");
INSERT INTO izz_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ọo ya bụ l'unu e-shije l'oke-lanụ-l'ụzo-iri ono, unu anatajẹ l'ẹka ndu Ízurẹlu ono woru oke-lanụ-l'ụzo-iri iya nụkwapho Chipfu. Ọ bụru l'oke-lanụ-l'ụzo-iri ono bẹ unu e-shi woru kẹ Chipfu nụ Erọnu, bụ onye uke Chileke. ");
INSERT INTO izz_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Unu wojeru iphe, gbaru Chipfu nụ iya l'iphemiphe, a nụru unu; unu shije l'ọphu bụ iya kakọta ree nụ iya ya; mẹ l'ọphu kakọta adụ nsọ. ");
INSERT INTO izz_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ọo ya bụ; pfuaru ndu Lívayi sụ phẹ lẹ teke ẹphe woru iphe, kakọta ree nụ Chipfu ono bẹ aa-gụru phẹ iya g'iphe, shi l'ẹka eechije balị; a gụkwaa ya phọ gẹ mẹe, shi l'ẹka aakụje mẹe. ");
INSERT INTO izz_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Unu lẹ ndibe unu a-nọduje l'ẹka dụ unu ree ria ndu ọphuu; kẹle ọo obunggo ozi, unu eje l'ụlo-ẹkwa-ndzukọ. ");
INSERT INTO izz_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ọ tọ dụdu iphe-ẹji, bya a-tukoru unu l'ishi m'ọ bụru l'unu wotaru iphe ono ọphu kachaa ree nụ mu. Tẹme ọphu unu e-merwudu iphe, ndu Ízurẹlu doberu nsọ g'ẹphe nụ mu; k'ọphu unu ta anwụshihudu.” ");
INSERT INTO izz_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Chipfu bya asụ Mósisu yẹle Erọnu: ");
INSERT INTO izz_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Waa ekemu, Chipfu tụru sụ: Pfuaru ndu Ízurẹlu g'ẹphe kpụtaru ngu nwada eswi, eke uswe-uswe; ọphu ọ dụdu ẹka iphe mebyiru iya; ọphu ọ dụdu ntụji, dụ iya nụ; tẹme ọphu e gudejeada ya jee ozi. ");
INSERT INTO izz_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Unu kpụta nwada eswi ono kpẹe Eleyaza, bụ onye uke Chileke; g'a kpụfu iya l'azụ ẹka a kpọberu ụlo-ẹkwa je egbua l'ẹka Eleyaza nọ. ");
INSERT INTO izz_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Gẹ Eleyaza, bụ onye uke Chileke tsẹe mkpụshi-ẹka lẹ mee ya phee l'ụzo atatiphu ụlo-ẹkwa-ndzukọ ugbo ẹsaa. ");
INSERT INTO izz_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nwada eswi ono bẹ aa-kpọ ọku l'iphu Eleyaza; kpọo akpọ iya ọku; mẹ anụ iya; waa mee ya; mẹ nshị iya. ");
INSERT INTO izz_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Onye uke Chileke ono bẹ e-wota oshi sida; mẹ ẹswa ịsopu; mẹ oghu uswe-uswe chịru ye l'echilabọ ọku ono, e gude akpọ nwada eswi ono ọku ono. ");
INSERT INTO izz_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Teke ono bẹ onye uke Chileke ono e-gude mini saa uwe iya; gude mini wụa ẹhu. O -megheẹ ya phọ nno; l'ọ batawarọ l'ime ẹka ono, a kpọberu ụlo-ẹkwa ono. Ọle ọo-bụru onye aasọ nsọ nọo jasụ l'ụzenyashi mbọku ono. ");
INSERT INTO izz_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onye bụ iya kpọru nwada eswi ono ọku bẹ e-gudekwaphọ mini saa uwe iya; gude mini wụa ẹhu; l'ọ bụkwarupho onye aasọ nsọ nọo jasụ l'ụzenyashi mbọku ono. ");
INSERT INTO izz_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Onye a ta sọdu nsọ bẹ e-kpota ntụ, shi l'ọku ono, e gude kpọo nwada eswi ono ọku. Oo-kpota iya je awụshi l'ẹka ntụrwu ta adụdu; l'azụ ẹka a kpọberu ụlo-ẹkwa. Ọ bụru l'ẹka ono bẹ aa-wụshiru iya ndu Ízurẹlu g'ẹphe gude meje kẹ mini, eegudeje asafụ nemadzụ ntụrwu; gude iya eme k'asafụ iphe-ẹji. ");
INSERT INTO izz_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Onye bụ iya kpotaru ntụ ono bẹ a-sa uwe iya asasa. L'ọ bụru onye aasọ nsọ nọo jasụ l'ụzenyashi mbọku ono. Omelalị ono bẹ a-dụ gbururu jeye lẹ gbururu. Ọo-dụru ndu Ízurẹlu; dụru ndu lwarụ alwalwa; ẹphe l'ẹphe buru.” ");
INSERT INTO izz_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Onye denyiru odzu onye nwụhuru anwụhu ẹka bẹ a-bụru onye aasọ nsọ nọo ujiku ẹsaa. ");
INSERT INTO izz_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Onye ọbu bẹ e-gude mini ono, eegudeje asafụ ntụrwu saa onwiya lẹ mbọku k'ẹto iya; waa lẹ mbọku k'ẹsaa ya; tẹme l'ọo-dụ ree. Ọle ọ -bụru l'ọ tọ sachaduru onwiya lẹ mbọku k'ẹto iya ono; mẹ lẹ mbọku k'ẹsaa ya ono bẹ ọ tọo dụdu ree. ");
INSERT INTO izz_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Iphe, bụ onye meru odzu onye nwụhuru anwụhu ẹka; ọphu onye ọbu ta sachaduru onwiya bẹ bụkwa ụlo-ẹkwa Chipfu bẹ ootụrwu. Onye ọbu bẹ ee-bufu l'ẹka ndu Ízurẹlu nọ. Ọo-bụru onye aasọ nsọ; noo kẹle e te pheduru iya mini, eegudeje asafụ ntụrwu; emeswe ono bẹ dụkwadu iya l'ẹhu g'ọ dụ iya. ");
INSERT INTO izz_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ọwaa bụ ekemu, dụ lẹ k'onye nọ l'ime ụlo nwụhu. Iphe, bụ onye bahụru l'ime ụlo ono teke ono; mẹ iphe, bụ onye nọ iya l'ime teke ono bẹ a-bụru onye aasọ nsọ abalị ẹsaa. ");
INSERT INTO izz_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Iphe, bụ ivu, dụ l'ụlo ono, e gheberu ọnu; ọphu e kpubeduru iya iphe bẹ aa-sọakwapho nsọ. ");
INSERT INTO izz_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Iphe, bụ onye nọ l'ọma ẹgu denyi ẹka l'odzu onye e gburu lẹ mma; ọzoo odzu onye nwụhuru anwụhu mmanụ; ọzoo l'o denyiru ẹka l'ọkpu onye nwụhuru anwụhu; m'ọ bụ l'ilu; bẹ a-bụru onye aasọ nsọ nọo abalị ẹsaa. ");
INSERT INTO izz_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“A -bya lẹ kẹ ndu aasọ nsọ; g'ẹphe kpota ntụ ono, shi l'ọku, e gude kpọo ngwẹja-iphe-ẹji ọku ono ye l'iphe; ẹphe eje l'ẹka mini, doru rịsaa dụ; kuta mini ye iya. ");
INSERT INTO izz_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ọo ya bụ; onye a ta sọdu nsọ ewota ẹswa ịsopu tsẹe l'ime mini ono; phee ya l'eli ụlo-ẹkwa ono; mẹ l'eli ivu, dụ l'ụlo-ẹkwa ono; mẹ l'ẹhu ndu nọ l'ime ụlo-ẹkwa ono. Nokwaphọ g'oo-phe iya iphe, bụkpo onye denyiru ẹka l'ọkpu onye nwụhuru anwụhu; mẹ onye denyiru ẹka l'odzu onye e gburu lẹ mma; ọzoo onye denyiru onye nwụhuru anwụhu mmanụ ẹka; mẹ onye denyiru ẹka l'ilu. ");
INSERT INTO izz_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Onye ọbu, a ta sọdu nsọ ọbu bẹ e-phe onye ono, aasọ nsọ ono mini ono lẹ mbọku k'ẹto; waa lẹ mbọku k'ẹsaa. O -rwua lẹ mbọku k'ẹsaa ono; l'ọ safụ iya ntụrwu ono. Onye ono, a sarụ ono asaa uwe iya asasa; gude mini wụa ẹhu; l'ọ bya adụ ree l'ụzenyashi mbọku ono. ");
INSERT INTO izz_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Obenu l'onye aasọ nsọ; ọphu ọ sachaduru onwiya asacha bẹ ee-bufu l'echilabọ ndu Ízurẹlu; kẹle o merwuwaru ụlo Chipfu. Eshinu e te pheduru iya mini, eegudeje asafụ nemadzụ ntụrwu bẹ ọ bụ onye aasọ nsọ. ");
INSERT INTO izz_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ono bụ ekemu, a-dụru phẹ nụ jasụru asụru. Onye ono, bụ iya epheje mini ono, eegudeje asafụ nemadzụ ntụrwu ono bẹ a-sakwaphọ uwe iya asasa. Onye meru ẹka lẹ mini ono, eegudeje asafụ ntụrwu ono bẹ a-bụru onye aasọ nsọ jeye l'ụzenyashi mbọku ono. ");
INSERT INTO izz_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Iphe, onye aasọ nsọ denyiru ẹka bẹ a tụrwuwaru atụrwu; onye denyiru ẹka l'iphe ọbu bẹ aa-nọdu asọ nsọ jasụ l'ụzenyashi mbọku ono.” ");
INSERT INTO izz_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Tọbudu iya bụ; o rwua l'ọnwa mbụ l'apha; ndu Ízurẹlu l'ophu jerwua echiẹgu Zinu. Ẹphe nọshia lẹ Kadẹshi. Miriyamu nọdu l'ẹka ono nwụhu; e lia ya l'ẹka onokwaphọ. ");
INSERT INTO izz_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Teke ono bẹ mini ta adụdu k'ọphu ndu Ízurẹlu a-ngụ; ẹphe kpakọ onwophẹ tsoahaa Mósisu yẹle Erọnu opfu. ");
INSERT INTO izz_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ẹphe wata abarụ Mósisu mba sụ: “O gege akaru anyi ree; ọ bụ l'anyi nwụshihuru teke phọ ndibe anyi phẹ nwụshihuru l'iphu Chipfu phọ. ");
INSERT INTO izz_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","?Bụ gụnu meru g'o gude ị chịta anyịbe ndu kẹ Chipfu bya awụshi l'echiẹgu l'ẹka-a g'anyi l'iphe-edobe anyi nwụshihu? ");
INSERT INTO izz_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","?Bụ gụnu meru g'o gude i dufuta anyi l'alị Ijiputu bya eduru dobe lẹ mkpọkoro ẹka-a, ta adụdu ereshi, dụ iya nụ; ọphu oshi figu adụdu iya; ọphu vayịnu adụdu iya; ọphu oshi itorokuma adụdu iya; ọphu ọ dụdu mini, anyi a-ngụ, dụ iya nụ?” ");
INSERT INTO izz_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tọbudu iya bụ; Mósisu yẹle Erọnu lụfu l'ẹka ono, ndu Ízurẹlu dọru ono tụgbua jeshia l'ọnu ụlo-ẹkwa-ndzukọ je adaa; kpupyabẹchaa iphu l'alị. O-gbu-nwịinwii kẹ Chipfu nwuaru phẹ kẹ phoo. ");
INSERT INTO izz_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Wota mgbọro phọ gẹ gụ lẹ nwune ngu Erọnu chịkobe ndu Ízurẹlu. Pfuru yeru mkpuma ono l'ẹka ẹphe ele ngu ẹnya gẹ mini shi iya sọfuta. Noo ụzo, ii-shi mee gẹ mkpuma ono sọfutaru phẹ mini bụ ono; k'ọphu ndu Ízurẹlu mẹ iphe-edobe phẹ a-ngụ mini.” ");
INSERT INTO izz_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tọbudu iya bụ; Mósisu bya ewota mgbọro ono l'atatiphu Chipfu l'ẹka ono gude tụgbua; gẹ Chipfu sụru iya g'o mee ya. ");
INSERT INTO izz_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mósisu yẹle Erọnu bya achịkobe ndu Ízurẹlu l'iphu mkpuma ono. Mósisu sụ phẹ: “Unu ngabẹ nchị nta-a unubẹ ndu okwefurike ono. ?Bụ g'anyi kuta mini lẹ mkpuma-a nụ unu tọo?” ");
INSERT INTO izz_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ọo ya bụ; Mósisu halia ẹka iya imeli byia mgbọro ono ugbo labọ l'eli mkpuma ono. Mini shi lẹ mkpuma ono nwụshihu; ndu Ízurẹlu; mẹ iphe-edobe phẹ ngụa ya. ");
INSERT INTO izz_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tọbudu iya bụ; Chipfu sụ Mósisu yẹle Erọnu: “Eshi ọphu unu te kwetadụru nkemu; ọphu unu emeduru mu gẹ mu dụ nsọ l'ẹnya ndu Ízurẹlu bẹ unu te edurwuẹkwa ndu-a alị ono, mu nụru phẹ ono.” ");
INSERT INTO izz_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ọwana bụ mini Meriba, bụ iya bụ “ụswo”; kẹle ọo l'ẹka ono bẹ ndu Ízurẹlu nọ tsoo Chipfu ụswo; Chipfu goshi phẹ lẹ ya dụ nsọ. ");
INSERT INTO izz_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mósisu bya eshi lẹ Kadẹshi zia ozi g'e je zia eze ndu Edọmu sụ: “Ọwaa bụ iphe, Ízurẹlu, bụ nwune ngu pfuru: Unu mawaru ẹgube iphe-ẹhuka, byapfutaru anyi g'ọ ha. ");
INSERT INTO izz_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Unu mawaru gẹ nna anyi oche phẹ gude chịru anyi laa alị Ijiputu; je ebua ẹka ono nọo ọdu. Ndu Ijiputu kpaa nna anyi phẹ ono ẹhu shii; bya akpakwaaphọ anyịbedua. ");
INSERT INTO izz_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Obenu lẹ teke anyi rakuru Chipfu bẹ ọ nụmaru olu anyi; bya ezia ojozi; ọ bya edufuta anyi lẹ Ijiputu. Nta-a bẹ anyi nọwa lẹ Kadẹshi, bụ mkpụkpu, unu l'ẹphe maru oke alị. ");
INSERT INTO izz_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Jiko unu hanaa g'anyi shia alị unu ghata. Anyi te eshidu ẹgu unu aghata; ọzoo ẹka unu gbaru opfu-vayịnu; ọphu ọ dụdu wẹlu unu, anyi bya l'e-kuta mini ngụa. Anyi e-tsoẹrupho ọma oji unu ogologo ghata. Anyi ta abyadụ a-swịba aswịba l'ụzo ẹkutara; ọzoo l'ụzo ẹkicha jasụ anyi aghatakọta l'alị unu.” ");
INSERT INTO izz_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ọle eze ndu Edọmu yeru iya ọnu sụ: “Unu ta aghatakwa l'alị anyi; ọ dụdu bẹ mu e-gudekwa ogu-echi byapfuta unu ọgu.” ");
INSERT INTO izz_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ndu Ízurẹlu sụ iya: “Anyi e-tsoẹrupho ọma oji ghata. Ọ -bụru l'anyi ngụru mini unu; ọzoo l'ọo iphe-edobe anyi ngụru mini unu; anyi apfụa unu ụgwo iya. Unu haarọ g'anyi gude ọkpa ghata; ọ tọ dụkwa iphe ọzo.” ");
INSERT INTO izz_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ọle eze ndu Edọmu bẹ sụru g'ẹphe ta aghatashị. Ọo ya bụ; ndu Edọmu chịta ikpoto unwoke phẹ, bụ ndu ọkpehu dụ jepfushia ndu Ízurẹlu ọgu. ");
INSERT INTO izz_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ọ bụru iya bụ lẹ ndu Edọmu ajịka gẹ ndu Ízurẹlu ta aghatashị. Ẹphe dakọbe shia ibiya ọzo. ");
INSERT INTO izz_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ndu Ízurẹlu l'ophu wụ-lihu lẹ Kadẹshi dzebe; jasụ ẹphe jerwua l'úbvú Họru. ");
INSERT INTO izz_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ọ bụru l'úbvú Họru ono, nọ-kube oke alị Edọmu ono bẹ Chipfu nọ sụ Mósisu yẹle Erọnu: ");
INSERT INTO izz_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Erọnu bẹ abya anwụhu lapfu ndiche ya phẹ. O too jerwudu alị ono, mu nụru ndu Ízurẹlu ono; kẹle unu kwefuru ike l'ekemu, mu tụru lẹ kẹ mini Meriba. ");
INSERT INTO izz_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Duta Erọnu yẹle Eleyaza, bụ nwa iya g'unu nyihu eli úbvú Họru; ");
INSERT INTO izz_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","l'i yeshia Erọnu uwe iya woru yee Eleyaza, bụ nwa iya; noo kẹle Erọnu a-nọdu l'ẹka ono nwụhu lapfu ndiche ya phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mósisu mee iphe, Chipfu sụru g'o mee. Ndu Ízurẹlu nọdu ele phẹ ẹnya; ẹphe nyihu eli úbvú Họru ono. ");
INSERT INTO izz_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mósisu yeshia Erọnu uwe iya woru yee Eleyaza, bụ nwa iya. Erọnu nwụhu l'eli úbvú l'ẹka ono. Mósisu yẹle Eleyaza shi l'eli úbvú ono nyizeta. ");
INSERT INTO izz_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ndu Ízurẹlu l'ophu hụmaepho lẹ Erọnu bẹ nwụhuwaru nụ; iphe, bụ ndu Ízurẹlu l'ophu rakọta ẹkwa iya ụkporo abalị l'abalị iri. ");
INSERT INTO izz_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","O be teke onye Kénanu, bụ eze ndu Aradu; mbụ onye ono, bu l'echiẹgu ndọhali ono nụmaru lẹ ndu Ízurẹlu bẹ shi l'ụzo Atarimu abya; o je etsoo ndu Ízurẹlu ọgu; kpụta ndu ọphu ọ kpụtaru lẹ ndzụ. ");
INSERT INTO izz_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ndu Ízurẹlu ribuaru Chipfu nte sụ: “Ọ -bụru l'ii-woru ndu-a yee anyi l'ẹka bẹ anyi e-woru mkpụkpu phẹ g'ọ ha mebyishikọta.” ");
INSERT INTO izz_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Chipfu ngabẹru ndu Ízurẹlu nchị l'olu; bya eworu ndu Kénanu ye phẹ l'ẹka. Ẹphe mee ndu ono; mẹ mkpụkpu phẹ omeliwe; mbụ ẹphe bụkotaru mkpurupyata. Ọo ya bụ; e kuahaa ẹka ono Họma, bụ iya bụ “mkpurupyata”. ");
INSERT INTO izz_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ndu Ízurẹlu bya eshi l'úbvú Họru tụgbua; ẹphe tsoru ụzo, larụ Eze-ẹnyimu Uswe-uswe; k'ọphu ẹphe e-shi nno jee alị Edọmu mgburugburu. Ẹphe jenyaa l'ụzo ono; ọphu ẹphe adụhedu ike takọta nshi. ");
INSERT INTO izz_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ẹphe wata epfutọshi Chileke yẹle Mósisu sụ: “?Bụ gụnu kparụ iphe, unu dufutaru anyi lẹ Ijiputu bya awụshi l'echiẹgu-a g'anyi nwụshihu? Ẹka nri ta adụdu! Ọphu mini adụdu iya! Njọ nri-a, anyi tsoru eriphe-a bẹ tụhuakwaru anyi ayị!” ");
INSERT INTO izz_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Tọbudu iya bụ; Chipfu bya achịru ẹjo agwọ yeru ndu Ízurẹlu ono. Agwọ ono wata phẹ atagbushi. Ọ tagbua ndu dụkpoo igwerigwe. ");
INSERT INTO izz_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ndu Ízurẹlu byapfuta Mósisu bya asụ iya: “Anyi mewaru iphe-ẹji; kẹle anyi pfutọshiwaru Chipfu; waa gụbedua. Pfunuru nụ Chipfu; k'ọphu oo-wofuru anyi agwọ ono.” Ọo ya bụ; Mósisu bya eworu opfu ẹhu ndu Ízurẹlu ono pfuru nụ Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Chipfu sụ Mósisu: “Meta ẹjo agwọ dobe l'eli itso lanụ; k'ọphu bụ onye agwọ phọ -tarụ ẹru; l'o lee ya ẹnya; dzụru ndzụ.” ");
INSERT INTO izz_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ọo ya bụ; Mósisu gude onyirubvu meta agwọ bya atukobe iya l'eli itso lanụ. Ọ nọdu abụjeru; onye agwọ tarụ; o -lewa ẹnya l'agwọ ono, e meru l'ope ono; l'ọo-dzụru ndzụ. ");
INSERT INTO izz_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ndu Ízurẹlu bya atụgbua; rwua Obotu; ẹphe kpọbe ụlo-ẹkwa phẹ. ");
INSERT INTO izz_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ẹphe gbẹ lẹ Obotu tụgbua; je akpọbe ụlo-ẹkwa phẹ lẹ Iye-Abarimu l'echiẹgu ono, nọ chebe iphu lẹ Mówabu l'ụzo ẹnyanwu-awawa ono. ");
INSERT INTO izz_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ẹphe shi l'ẹka ono tụgbua bya erwua nsụda Zẹredu; bya akpọbe ụlo-ẹkwa phẹ l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ẹphe shikwaphọ l'ẹka ono tụgbua je akpọbe ụlo-ẹkwa phẹ l'azụ ẹnyimu Anọnu azụ iya ọphuu; ẹka ono, nọ l'echiẹgu, nọ kpaa l'oke alị ndu Amọru; noo kẹle ọo ẹnyimu Anọnu bụ oke alị ndu Mówabu; mbụ nọkaharu ndu Mówabu ẹphe lẹ ndu Amọru. ");
INSERT INTO izz_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ọo ya meru g'o gude e pfua l'ẹkwo, e deru k'ọ̀gù, Chipfu lwụru sụ: “Mkpụkpu Wahebu ono, dụ lẹ Sufa; yẹle nsụda nsụda ẹnyimu Anọnu; ");
INSERT INTO izz_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","mẹ lẹ mkpọ-ze mkpọ-ze ono, dụ lẹ nsụda nsụda, nọ je akpaa lẹ mkpụkpu Aru; bya anọdu nno jasụ l'oke alị ndu Mówabu.” ");
INSERT INTO izz_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ẹphe gbalihu l'ẹka ono kwasẹru jerwua Biye, bụ iya bụ wẹlu ono, Chipfu sụru Mósisu: “Chịkobe ndu Ízurẹlu l'ẹka lanụ gẹ mu nụ phẹ mini g'ẹphe ngụa.” ");
INSERT INTO izz_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tọbudu iya bụ; ndu Ízurẹlu gụa ebvu-a sụ: “Nwụfuta mini; gụbe wẹlu! G'a gụru ebvu nụ iya. ");
INSERT INTO izz_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ọo ndu-ishi bvuru wẹlu ono; mbụ l'ọo ndu a maru ẹpha phẹ lẹ Ízurẹlu bẹ tụru iya nụ. Ọ bụru mgbọro ndu eze; mẹ mgbọro ndu a maru ẹpha phẹ bẹ ẹphe gude bvua ya.” Tọbudu iya bụ; ẹphe shi l'echiẹgu jeshia Matana; ");
INSERT INTO izz_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","shi lẹ Matana lụfu lẹ Nahalẹlu; shi lẹ Nahalẹlu lụfu lẹ Bamọtu; ");
INSERT INTO izz_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","shi lẹ Bamọtu lụfu lẹ nsụda, nọ l'alị Mówabu lẹ mgboru úbvú Pisiga, bụ ẹka aagbẹje ele alị, dabyiru mgbegere. ");
INSERT INTO izz_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Tọbudu iya bụ; ndu Ízurẹlu zia ozi g'e je zia Sihọnu, bụ eze ndu Amọru sụ: ");
INSERT INTO izz_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“G'anyi ghatanụ l'alị unu. Anyi ta aswịbakwa l'ẹgu unu; ọphu anyi ta aswịbadu l'opfu-vayịnu unu. Ọphu ọ dụdu wẹlu unu, anyi bya l'e-kuta mini ngụa; ọo ẹpho ọma oji bẹ anyi e-tsoru jasụ anyi aghatagbua l'alị unu.” ");
INSERT INTO izz_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Obenu lẹ Sihọnu te ekwedu gẹ ndu Ízurẹlu ghata l'alị iya. Ọ chịkobe ndu nkiya g'ẹphe ha; ẹphe jepfushia ndu Ízurẹlu ọgu l'echiẹgu. Ẹphe rwuẹpho mkpụkpu Jiahazu; ẹphe datso ndu Ízurẹlu ọgu l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ndu Ízurẹlu gude ogu-echi sụa phẹ pyaapyaa; nata phẹ alị phẹ ono; shita l'ẹnyimu Anọnu je akpaa l'ẹnyimu Jiabọku; jeyewarụro l'alị ndu Amọnu; oke alị ndu Amọnu bẹ a kpụru igbulọ mgburugburu; o shihu ike. ");
INSERT INTO izz_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ndu Ízurẹlu lwụtakota mkpụkpu ndu Amọru g'ọ ha; buchikọta iya; lwụtachaa mkpụkpu Hẹshibonu; mẹ mkpụkpu, nọ-pheru iya mgburugburu. ");
INSERT INTO izz_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hẹshibonu bẹ bụ mkpụkpu Sihọnu, eze ndu Amọru. Yẹle onye shi bụru eze ndu Mówabu lwụjeru ọgu; Sihọnu lwụtakota alị iya je akpaa l'ẹnyimu Anọnu. ");
INSERT INTO izz_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ọo ya meru g'o gude ndu àkàkà ebvu nọdu agụje sụ: “Bya mkpụkpu Hẹshibonu; g'a kpụ-phu iya azụ; mbụ g'a kpụ-phu mkpụkpu Sihọnu azụ; kpụa ya g'o shihu ike. ");
INSERT INTO izz_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Noo kẹle ọku shi lẹ Hẹshibonu kpụfu; mbụ l'ire-ọku shi lẹ mkpụkpu Sihọnu kpụfu. O tsuwaru mkpụkpu Aru kẹ ndu Mówabu; mbụ ndu nwe úbvú, dụgbaa lẹ mgboru ẹnyimu Anọnu. ");
INSERT INTO izz_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Nshịo unubẹ ndu Mówabu! E mebyishiwaru unu; unubẹ ndu anọduje agwa agwa Kemọshi! Ụnwegirima unu unwoke bẹ o mewaru; ẹphe gbalakọta lashịa alị ọzo. Ụnwegirima unu ụnwanyi bẹ o mewaru; ẹphe bụwaru ndu a kpụru lẹ ndzụ nụ Sihọnu, bụ eze ndu Amọru. ");
INSERT INTO izz_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Anyi kwatsuwaru phẹ. Mkpụkpu Hẹshibonu bụwaa mkpurupyata je akpaa lẹ mkpụkpu Dibọnu. Anyi gwewaru phẹ arakabya jasụ lẹ mkpụkpu Nofa; mbụ je akpaa lẹ mkpụkpu Medeba.” ");
INSERT INTO izz_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tọbudu iya bụ; ndu Ízurẹlu buru l'alị ndu Amọru. ");
INSERT INTO izz_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mósisu bya ezia ndu e-je anwụa ngge lẹ mkpụkpu Jiaza; ẹphe jechaẹpho; ndu Ízurẹlu je alwụa mkpụkpu, dụ iya nụ; chịkashia ndu Amọru, shi buru l'ẹka ono. ");
INSERT INTO izz_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ọo ya bụ; ndu Ízurẹlu ghakọbe shia ụzo ọphu shiru jeshia alị Beshanu. Ọgu, bụ eze ndu Beshanu chịta ndu nkiya g'ẹphe ha jepfushia phẹ ọgu lẹ mkpụkpu Edereyi. ");
INSERT INTO izz_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Chipfu sụ Mósisu: “Ta tsụkwa iya ebvu; noo kẹle mu wowaru iya ye ngu l'ẹka; mẹ ndu nkiya; waa alị iya. Mekwaa ya iphe, i meru Sihọnu, bu eze, bu lẹ Hẹshibonu bụru onye-ishi ndu Amọru.” ");
INSERT INTO izz_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","No iya; ndu Ízurẹlu gbua Ọgu; gbushia ụnwegirima iya; mẹ ndu nkiya g'ẹphe ha; k'ọphu bụ l'ọ tọ dụdu onye phọduru nụ l'ime phẹ. Ndu Ízurẹlu nata alị iya nworu. ");
INSERT INTO izz_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ndu Ízurẹlu bya atụgbua jerwua phorokoto alị ndu Mówabu; ẹphe kpọbe ụlo-ẹkwa phẹ l'agụga ẹnyimu Jiọ́danu, nọ chebe iphu lẹ mkpụkpu Jieriko. ");
INSERT INTO izz_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Belaku nwa Zipo hụma iphemiphe, ndu Ízurẹlu meru ndu Amọru. ");
INSERT INTO izz_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ndzụ-agụgu rwuta ndu Mówabu kẹle ndu Ízurẹlu dụ igwerigwe. Ndzụ ndu Ízurẹlu gụshiahaa ndu Mówabu ike. ");
INSERT INTO izz_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ndu Mówabu jepfu ndu bụ ọgerenya ndu Midiyanu je asụ phẹ: “Nta bẹ ikpoto ndu Ízurẹlu-a a-tụko iphe, bụ ndu gbaru anyi mgburugburu lwụkota g'eswi, atụkoje ẹswa, nọ l'ẹgu lwụkota-a.” Teke ono bẹ bụ Belaku nwa Zipo bẹ bụ eze ndu Mówabu. ");
INSERT INTO izz_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ọ bya ezia g'e je ekua Belamu nwa Beyọ, bụ onye nọ lẹ mkpụkpu Petọ l'alị Amawu, dụ lẹ mgboru ẹnyimu Yufurétisu. Iphe, Belaku ziru iya bụ: “O nweru ndu shi l'alị Ijiputu fụta; bya atụko mgboko l'ophu dzuru. Nta-a bẹ ẹphe nọakwa mu lẹ mgboru. ");
INSERT INTO izz_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Iphe, mu arwọ ngu nta-a bụkwa g'ị bya atụaru mu ndu ono ọnu; noo kẹle ẹphe ka mu ọkpehu. ?A maru; mu alwụ-kpe phẹ; chịa phẹ l'alị-a? Noo kẹle mu maru l'onye ị gọru ọnu-ọma nụ bẹ bụwaa onye a gọru ọnu-ọma nụ; onye ị tụru ọnu bụwaru onye a tụru ọnu.” ");
INSERT INTO izz_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ọo ya bụ; ndu bụ ọgerenya ndu Mówabu; mẹ ndu bụ ọgerenya ndu Midiyanu gude ụgwo, aapfụje g'a gbaa ẹja tụgbua jepfushia Belamu; je ezia ya ozi, Belaku ziru iya ono. ");
INSERT INTO izz_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Belamu sụ phẹ: “Unu kwaa l'ẹka-a l'ẹnyashi-a k'ọphu mu a-karụ unu iphe, Chipfu e-pfuru yeru mu.” Ọo ya bụ; Belamu yẹle ndu-ishi Mówabu ono tụko nọdu. ");
INSERT INTO izz_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Chileke bya abyapfuta Belamu bya ajịa ya sụ: “?Bụ ndu ole bẹ gụ l'ẹphe nọ ono?” ");
INSERT INTO izz_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Belamu sụ Chileke: “ọ kwa Belaku nwa Zipo, bụ eze ndu Mówabu bẹ ziru phẹ ozi g'ẹphe bya asụ mu ");
INSERT INTO izz_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","l'o nweru ndu shi l'alị Ijiputu fụta bya atụko mgboko l'ophu dzuru. L'ọo gẹ mu bya atụaru iya ndu ono ọnu; g'a maru ?Ya a-lwụ-kpee phẹ? chịshia phẹ l'alị phẹ.” ");
INSERT INTO izz_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Chileke sụ Belamu: “Te etsokwa phẹ je; ta tụkwa ndu ono ọnu; kẹle ẹphe bụkwa ndu a gọru ọnu-ọma nụ.” ");
INSERT INTO izz_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","O -rwua l'ụtsu iya; Belamu fụta bya epfuaru ndu-ishi ono, ejeru Belaku ozi; sụ phẹ: “Unu lashịa alị unu lẹ Chipfu te ekwedu gẹ mu tsoru unu je.” ");
INSERT INTO izz_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ọo ya bụ; ndu-ishi Mówabu ono tụgbua lashịa je asụ Belaku lẹ Belamu jịkakwaru lẹ ya te etsoduru phẹ. ");
INSERT INTO izz_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Belaku bya ezikwaa ndu-ishi ọzo, kaba igwerigwe; mbụ ndu a ka akwabẹ ùbvù eme lẹ ndu kẹ mbụ phọ. ");
INSERT INTO izz_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ẹphe byapfuta Belamu bya asụ iya: “Waa iphe, Belaku nwa Zipo pfuru baa: ‘Jiko g'ọ tọ dụkwa iphe, ii-kwe g'ọ kpọshia ngu abya ibe mu. ");
INSERT INTO izz_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Noo kẹle mu a-kwabẹ ngu ùbvù, parụ ẹka; bya emeeru ngu iphe, ị sụru gẹ mu meeru ngu. Jiko byanụ atụaru mu ndu-a ọnu.’ ” ");
INSERT INTO izz_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Belamu sụ ndu-ozi Belaku ono: “O -betakpọ Belaku je a-nụ mu ụlo iya ono, mkpọla-ododo waa mkpọla-ọchaa jiru ejiji ono; bẹ mu te emeghatadu iphe, Chipfu, bụ Chileke mu pfuru. Mu te ewofudu iya iphe; ọphu mu te eyekwadu iya iphe. ");
INSERT INTO izz_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Jiko unu kwakwaaphọ akwakwa l'ẹka-a l'ẹnyashi-a gẹ mu maru mẹ o -nweru iphe, Chipfu e-pfubaa yeru mu.” ");
INSERT INTO izz_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Chileke bya abyapfuta Belamu l'ẹnyashi bya asụ iya: “Ọ -bụru l'ọo oku bẹ ndu-a byaru ngu ekuku; gbalihu tsoru phẹ; ọle ọo iphe, mu sụru g'i mee bẹ ii-me kpoloko.” ");
INSERT INTO izz_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Belamu bya agbalihu l'ụtsu dozia nkapfụ-ịgara iya tsoru ndu-ishi Mówabu ono; ẹphe tụgbua. ");
INSERT INTO izz_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ọle ẹhu ghuru Chileke eghu shii g'ọ tụgburu jeshia ono. Ojozi Chipfu je apfụru kwachia ya ụzo. Teke ono bẹ Belamu nọ l'eli nkapfụ-ịgara iya agba eje; yẹle ndu-ozi iya ụmadzu labọ swịru. ");
INSERT INTO izz_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nkapfụ-ịgara ono hụmaepho ojozi Chipfu ono g'ọ pfụru l'ụzo; mịfuta ogu-echi iya gude l'ẹka; ọ haa ụzo swịba l'ẹgbudu. Belamu chiahaa nkapfụ-ịgara ono iphe g'ọ gọ-zia ya g'ọ laphu azụ l'ụzo. ");
INSERT INTO izz_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ojozi Chipfu ono je apfụru l'owere ụzo, nọ lẹ mgbaka opfu-vayịnu labọ, igbulọ nọchaa ibekẹboebo. ");
INSERT INTO izz_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Tọbudu iya bụ; nkapfụ-ịgara ono hụmaepho ojozi Chipfu ono; o je akwaa onwiya l'igbulọ ono; woru Belamu ọkpa hua l'igbulọ ono. Belamu chikwaa ya iphe ọzo. ");
INSERT INTO izz_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ojozi Chipfu ono bya atụgbukwa je apfụru l'ẹka dụ kparagụ. Ẹka ono te nwedu ụzo, ee-shi swịa ẹkutara; ọzoo swịa ẹkicha. ");
INSERT INTO izz_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nkapfụ-ịgara ono hụmaepho ojozi Chipfu ono; ọ nmakpuru lẹ mkpula Belamu; ẹhu ghuahaa Belamu eghu; o chiahaa ya mgbọro iya. ");
INSERT INTO izz_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chipfu kụhaa nkapfụ-ịgara ono ọnu; o pfuru opfu yeru Belamu sụ: “?Bụ gụnu bẹ mu meru ngu; meru g'o gude i nọdu echi mu ẹgube ono? Ọwaa kweakwa ugbo ẹto, i chiru mu iphe-a?” ");
INSERT INTO izz_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Belamu sụ nkapfụ-ịgara ono: “Iphe, mu gude echi ngu ẹgube ono bụ l'iime mu sukusuku. Ọ -bụ lẹ mu gude ogu-echi l'ẹka bẹ mu eworu ngu gbua nta-a.” ");
INSERT INTO izz_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nkapfụ-ịgara ono sụ Belamu: “?Mu ta abụdu nkapfụ-ịgara, i nwe enwenwe tọo? I shihawaa gbata mu byasụ ntanụ-a. ?Mu mejewaru ngu ẹgube-a?” Belamu sụ iya: “Waawaa.” ");
INSERT INTO izz_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Noo ya; Chipfu bya emee g'ẹnya sahụ Belamu; ọ hụma ojozi Chipfu ono g'ọ pfụru l'ụzo; mịfuta ogu-echi iya parụ l'ẹka. Belamu phozeta ishi ephozeta; bya adaa kpube iphu l'alị. ");
INSERT INTO izz_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ojozi Chipfu ono jịa ya sụ: “?Bụ gụnu meru iphe, i chiru nkapfụ-ịgara ngu iphe ugbo ẹto-a? Mu byaru gẹ mu kwachia ngu ụzo; noo kẹle ụzo, i phoberu bẹ dụ gbajọgbajogbajo l'ẹnya nkemu. ");
INSERT INTO izz_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ugbo ẹto bẹ nkapfụ-ịgara-a hụmaru mu; bya agbangochaa mu. Ọ -bụ l'ọ tọ gbango mu; mẹ mu asụwaa ngu pyaapyaa; haa yẹbedua g'ọ nọdu ndzụ.” ");
INSERT INTO izz_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Belamu sụ ojozi Chipfu ono: “Mu mewaru iphe-ẹji; kẹle mu ta amadụ l'i pfụru kwachia mu ụzo. Ọo ya bụ; ọ -bụru l'ọ tọ dụdu ngu ree gẹ mu je; mu a-laphu azụ.” ");
INSERT INTO izz_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ojozi Chipfu ono sụ Belamu: “Tsorurọ ndu ono jeshia; ọle ọo g'ọ bụkwaru iphe, mu sụru g'i pfua bẹ ii-pfu kpụrumu.” Ọo ya bụ; Belamu yẹle ndu-ishi ono, ejeru Belaku ozi ono tụgbua; ọ bụru phẹ ejeje. ");
INSERT INTO izz_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Belaku nụmaepho lẹ Belamu abyawaa; ọ lụfu jeshia ya ndzuta lẹ mkpụkpu, nọ l'alị Mówabu l'oke ẹnyimu Anọnu; mbụ l'ime ime ẹka oke alị ono beru. ");
INSERT INTO izz_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Belaku sụ Belamu: “Mu ziru ozi, dụ ọku-ọku g'a bya ekua ngu g'ị bya. ?Bụhunu gụnu meru iphe, ị tị byakebedụru? ?Bụ lẹ mu ta adụdu ike akwabẹ ngu ùbvù tọo?” ");
INSERT INTO izz_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Belamu sụ Belaku: “Ọ dụ ree; mu byawaru. Ọle ọ bụ; ?ọ dụhunuru iphe, mu adụ ike epfu; abụedupho opfu, Chileke yeru mu l'ọnu gẹ mu pfua.” ");
INSERT INTO izz_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ọo ya bụ; Belamu tsoru Belaku; ẹphe jeshia Kiriyatu-Huzotu. ");
INSERT INTO izz_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Belaku gbushia eswi mẹ atụru gude gwee ngwẹja; bya aharu nụ Belamu yẹle ndu-ishi ono, yẹe ya tụko swịru ono. ");
INSERT INTO izz_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","O bẹ l'ụtsu echele iya; Belaku duta Belamu; ẹphe tụgbua jeshia Bamọtu-Belu; Belamu gbẹ l'ẹka ono harụ hụma ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Belamu sụ Belaku: “Kpụaru mu ọru-ngwẹja ụzo ẹsaa. L'ị kpụtaru mu oke-eswi ẹsaa; waa ebili ẹsaa.” ");
INSERT INTO izz_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Belaku bya emee gẹ Belamu pfuru. Belaku yẹle Belamu gbua oke-eswi; mẹ ebili ono nanụ nanụ l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Belamu sụ Belaku: “Pfụru lẹ mgboru ngwẹja-akpọ-ọku ono gẹ mu kpịribeeshikwaru. G'a maru; ?Chipfu abyapfuta mu? Iphe, bụkpoo iphe, o goshiru mu bẹ mu a-kọru ngu-a.” Ọ tụgbua jeshia l'eli nwubvu, adụdu iphe, dụ iya nụ. ");
INSERT INTO izz_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Chileke byapfuta Belamu. Belamu sụ Chileke: “Mu doziwaru ọru-ngwẹja ụzo ẹsaa; mu gbuwa oke-eswi yẹle ebili nanụ nanụ l'ọru-ngwẹja ono ẹphe n'ẹsaa.” ");
INSERT INTO izz_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Tọbudu iya bụ; Chipfu ye Belamu opfu l'ọnu sụ iya: “Laphu azụ jepfu Belaku je ezia ya ozi-a.” ");
INSERT INTO izz_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","O jepfushia Belaku; bya ahụma iya g'ọ pfụru lẹ mgboru ngwẹja-akpọ-ọku ono; yẹle ndu-ishi Mówabu g'ẹphe ha. ");
INSERT INTO izz_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Belamu pfuahaa sụ: “Belaku bẹ byaru eduta mu l'alị Arámu. Eze ndu Mówabu bya eduta mu l'úbvú úbvú ụzo ẹnyanwu-awawa. Ọ sụru gẹ mu bya atụaru iya ụnwu Jiékọpu ọnu; gẹ mu bya epfubyia ụnwu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","?Dẹnu gẹ mu e-shi bya eworu ọnu tụa ndu Chileke atụduru ọnu? ?Dẹnu gẹ mu e-shi pfubyia ndu Chipfu te epfubyiduru? ");
INSERT INTO izz_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ọo l'eli eze mkpuma bẹ mu anọduje hụma phẹ. Ọ bụru l'eli úbvú bẹ mu anọduje ele phẹ ẹnya; mbụ ndu ono, bu iche ono, adụdu ndu ẹphe l'ẹphe buru ẹghirigha ono. Ẹphe ta agụjeduru onwophẹ yeru ọhozo. ");
INSERT INTO izz_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","?Bụ onye bẹ a-dụ ike gụta ụnwu Jiékọpu l'ọgu; mbụ ndu ha g'urwuku, nọ l'alị. Mbụ-a; ?bụ onye a-dụ ike gụta nkeru-ẹno ụnwu Ízurẹlu l'ọgu? Gẹ mu nwụhukwa anwụhu onye pfụberekoto! Gẹ mu lakwaa gẹ ndu pfụberekoto larụ!” ");
INSERT INTO izz_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Belaku sụ Belamu: “?Bụ gụnu bẹ i meru mu ẹgube ono? Mu sụru ngu g'ị bya atụa ndu ọhogu mu ọnu; ọ gbẹ bụru ọnu-ọma bẹ ị gọru nụ phẹ!” ");
INSERT INTO izz_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Belamu sụ: “?Bụ gẹ mu te epfushi iphe, Chipfu yeru mu l'ọnu gẹ mu pfua?” ");
INSERT INTO izz_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Belaku sụ Belamu: “Tsoru mu g'anyi je l'ẹka ọzo, ịi-nọdu hụma phẹ. Ọo aharu bẹ ịi-harụ phẹ hụma; ị tịi hụma-gbudu phẹ g'ẹphe ha. Gbẹ l'ẹka ono tụaru mu phẹ ọnu.” ");
INSERT INTO izz_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Belaku duta Belamu; ẹphe jeshia l'ẹgu mkpụkpu Zofimu, nọ l'eli úbvú Pisiga; ọ kpụa ọru-ngwẹja ụzo ẹsaa. Ẹphe gbushia oke-eswi yẹle ebili nanụ nanụ l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Belamu sụ Belaku: “Pfụkwaru lẹ mgboru ngwẹja-akpọ-ọku ono gẹ mu jepfu Chipfu l'ẹka phọ.” ");
INSERT INTO izz_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Chipfu byapfuta Belamu; bya eye iya opfu l'ọnu sụ iya: “Jepfu Belaku ọzo je ezia ya ozi-a.” ");
INSERT INTO izz_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Belamu bya ejepfu Belaku; hụma iya g'ọ pfụru lẹ mgboru ngwẹja-akpọ-ọku ono; yẹle ndu-ishi Mówabu, yẹe ya tụko nọdu. Belaku sụ Belamu: “?Bụ gụnu bẹ Chipfu pfuru?” ");
INSERT INTO izz_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Belamu pfushiahaa sụ: “Gụbe Belaku; gbalihu agbalihu ngabẹ nchị! Nụma iphe, mu epfu; gụbe nwa Zipo. ");
INSERT INTO izz_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Chileke ta abụkwa nemadzụ; k'ọphu ọo-bya adzụaha ụka. Ọphu ọ bụdu nwa ndiphe; kẹ g'ọ gbanwee uche iya. ?O pfujewaru opfu; ọphu o medụru g'o pfuru? ?O kwejeru ukwe-iphe; g'o to medzu ukwe-iphe ọbu? ");
INSERT INTO izz_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Sụ-a; ekemu, mu natarụ bụkwa gẹ mu gọoru ndu ono ọnu-ọma. Chileke gọwaru ọnu-ọma nụ phẹ. Ọphu mu ta a-dụkwa ike agbanwe iya. ");
INSERT INTO izz_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ọ tọ dụdu ẹjo-iphe, e levuru l'ẹhu ụnwu Jiékọpu. Ọphu ọ dụdu iphe, ta adụdu ree, ọ hụmaru l'ẹhu ụnwu Ízurẹlu. Chipfu, bụ Chileke phẹ swiru phẹ ọkpobe eswiru. Ẹphe anọduje atụ ụzu l'ọ bụ eze phẹ. ");
INSERT INTO izz_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Chileke bẹ dufutaru phẹ l'alị Ijiputu; bya emee phẹ; ẹphe nweru ọkpehu g'atsụ. ");
INSERT INTO izz_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","A ta abyadụ egude oswe keta ụnwu Jiékọpu. Ọphu a byadu e-shi l'ọmamanshi mekata ụnwu Ízurẹlu. Nta-a bẹ ee-pfu opfu ẹhu ụnwu Jiékọpu; pfua opfu ẹhu ụnwu Ízurẹlu sụ: ‘Lewarọ iphe, Chileke megbabẹru!’ ");
INSERT INTO izz_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Sụ-a; ndu Ízurẹlu angụ-lihuje gẹ ne oduma. Ẹphe anọduje ebu nggada g'oduma; mbụ oduma, ta azẹjedu azẹe jasụ l'ọ labushia anụ eriri iya; mbụ jasụ l'ọ ngụa mee-iphe, o guderu.” ");
INSERT INTO izz_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ọo ya bụ; Belaku sụ Belamu: “Ta atụekwa phẹ ọnu ilile; ọphu ị gọekwaru phẹ ọnu-ọma ililekpọo!” ");
INSERT INTO izz_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Belamu sụ Belaku: “?Mu te epfuduru ngu l'ọo iphe, Chipfu pfuru bẹ mu e-me?” ");
INSERT INTO izz_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Tọbudu iya bụ; Belaku sụ Belamu: “Bya gẹ mu duru ngu je ẹka ọzo. ?G'a maru ọ-dụ Chileke ree g'ị gbẹ l'ẹka ono tụaru mu phẹ ọnu?” ");
INSERT INTO izz_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Belaku duta Belamu; ẹphe nyihu ọnonu úbvú Peyọ; mbụ úbvú ono, nọ chebe iphu l'alị, dabyiru mgbegere. ");
INSERT INTO izz_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Belamu sụ Belaku: “Kpụaru mu ọru-ngwẹja ụzo ẹsaa l'ẹka-a; l'ị kpụtaru mu oke-eswi ẹsaa waa ebili ẹsaa.” ");
INSERT INTO izz_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Belaku mee ya gẹ Belamu sụru g'o mee ya. Ẹphe gbua oke-eswi ono yẹle ebili ono nanụ nanụ l'ọru-ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Belamu bya ahụmaepho l'iphe, dụ Chipfu ree bụ g'a gọru ọnu-ọma nụ ndu Ízurẹlu; ọphu o to jeẹduru l'ajị ẹgube oojejehawa. Iphe, o meru bụ l'o woru iphu ghaa l'ụzo echiẹgu. ");
INSERT INTO izz_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Belamu bya apalia ẹnya imeli hụma ndu Ízurẹlu g'ẹphe kpọbegbaaru ụlo-ẹkwa phẹ l'ipfu l'ipfu. Unme Chileke bya iya l'ẹhu; ");
INSERT INTO izz_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","o pfushiahaa sụ: “Waa iphe, Belamu nwa Beyọ epfu. Ọ kwa opfu, onye ono, e meru; ẹnya sahụ ono epfu. ");
INSERT INTO izz_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Opfu, onye anụmaje opfu, shi l'ọnu Chileke epfu; mbụ onye ono, ahụmaje iphe, Ọkalibe-kangokọtaru-nụ egoshi; daa kpurumu kpupyabẹ iphu; onye ono, e meru; ẹnya dụ sarịmu ono. ");
INSERT INTO izz_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ẹgube g'ụlo-ẹkwa ngu amabe mma; gụbe Jiékọpu; mbụ ẹka gụbe Ízurẹlu bukpọ ebubu! ");
INSERT INTO izz_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ọo gẹ nsụda nsụda adụje-a bụ g'ọ sụsaru asụsa. Ọ dụ gẹ mgbabu, a gbaru l'agụga ẹnyimu. Ọ dụ g'oshi alowe, Chipfu yeru l'onwiya; bya adụ g'oshi sida, bvuru l'agụga ẹnyimu. ");
INSERT INTO izz_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mini e-shije l'ite-mini Ízurẹlu asọshihu asọshihu. Oshilọkpa phẹ bẹ e-nweru mini nweru k'etsutsu iya. Eze phẹ bẹ a-ka eze Agagu shii. Alị-eze phẹ bẹ aa-pali eli. ");
INSERT INTO izz_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Chileke dufutaru phẹ l'alị Ijiputu; bya emee phẹ; ẹphe nweru ọkpehu g'atsụ. Ẹphe a-lwụcha ọhamoha, ẹphe dụ ashị; mbụ kụpyashia ọkpu phẹ yọgiri yọgiri. Ẹphe e-gude arwa phẹ nmafushia phẹ ẹpho. ");
INSERT INTO izz_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ízurẹlu bẹ nmakpuru anmakpuru; bya azẹe l'alị g'oduma. Ẹphe dụ gẹ ne oduma; ?bụ onye a-dụ ike kpatsu phẹ? G'iphe, bụ ndu gọru ụnwu Ízurẹlu ọnu-ọma bụkwaru ndu a gọru ọnu-ọma nụ. G'iphe, bụ ndu tụru unu ọnu bụkwaru ndu a tụru ọnu.” ");
INSERT INTO izz_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tọbudu iya bụ; Belamu mee; ẹhu ghushiaha Belaku eghu ike. Ọ kụa ẹka kpaa; bya asụ Belamu: “Nta-a bẹ mu kuru ngu g'ị bya atụaru mu ndu ọhogu ọnu; ọ bụ-chiaru ọnu-ọma bẹ ị gọcharu nụ phẹ ugbo ẹto-a. ");
INSERT INTO izz_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ngwa; keta ọso tụgbua lashịa ibe ngu ẹgwegwa! Mu shi rịa kẹ gẹ mu kwabẹ ngu ùbvù, parụ ẹka; obenu lẹ Chipfu bẹ nafụwaru ngu ùbvù ọbu.” ");
INSERT INTO izz_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Belamu sụ Belaku: “?Mu te epfuduru iya ndu i ziru g'ẹphe bya ekua mu sụ: ");
INSERT INTO izz_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Obetakpọo Belaku nụ mu ụlo iya ono, mkpọla-ododo mẹ mkpọla-ọchaa jiru pyịmu ono bẹ mu te emeghatakwa iphe, Chipfu sụru gẹ mu mee; ọphu mu egudekwa uche k'onwomu eme iphe, dụ ree; ọzoo iphe, dụ ẹji. Ọo ẹpho iphe, Chipfu pfuru bẹ mu e-pfu.’ ");
INSERT INTO izz_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nta-a bẹ mu alawa; alapfu ndibe mu. Ọle-a; byakwa gẹ mu nmaaru ngu ọkwa; gẹ mu pfuaru ngu iphe, ndu-a e-mechaa mee ndibe unu lẹ teke dụ l'iphu.” ");
INSERT INTO izz_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ọo ya bụ; Belamu pfuahaa sụ: “Waa iphe, Belamu nwa Beyọ epfu. Ọ kwa opfu, onye ono, e meru; ẹnya sahụ ono epfu. ");
INSERT INTO izz_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Opfu, onye anụmaje opfu, shi l'ọnu Chileke epfu; mbụ onye ono, maru iphe, shi Ọkalibe-kakọta-shii l'ẹka; onye ono, ahụmaje iphe, Ọkalibe-kangokọtaru-nụ egoshi; daa kpurumu kpupyabẹ iphu; onye ono, e meru; ẹnya dụ sarịmu ono. ");
INSERT INTO izz_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mu hụmaru onye ono; ọle ọ tọ bụdu nta-a. Mu ele onye ọbu ẹnya; ọle ọ tọ nọdu ntse. Kpokpode bẹ e-shi l'ọnulo Jiékọpu fụta. Mgbọro-eze bẹ a-fụta lẹ Ízurẹlu. Mówabu bẹ ọo-tụko egedegee ọnu-iphu gwee arakabya. L'ọo-tụko ụnwu Sheti l'ophu mebyishikọta. ");
INSERT INTO izz_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ndu Edọmu bẹ aa-lwụta l'ọgu. Nokwaphọ g'aa-lwụta ndu Siye, bụ ndu ọhogu Ízurẹlu. Obenu lẹ ndu Ízurẹlu bẹ a-nọdu aka ike eje. ");
INSERT INTO izz_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Onye-ishi bẹ e-shi l'ọnulo Jiékọpu fụta; bya emebyishia ndu ọphu phọduru nụ lẹ mkpụkpu ono.” ");
INSERT INTO izz_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Belamu bya elee ndu Amalẹku ẹnya bya asụ: “Ndu Amalẹku bẹ bụ ivuzọ l'echilabọ ọhamoha; obenu l'ẹphe a-bụru mkpurupyata l'ikpazụ.” ");
INSERT INTO izz_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ọ bya elee ndu Kénu ẹnya bya asụ: “Ẹka unubẹ ndu Kénu bu ebubu bẹ e meru; o shihu kẹ dụngudungu. Nwamkpu, unu tụru bẹ unu tụru l'eli mkpuma. ");
INSERT INTO izz_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ọle unubẹ ndu Kénu bẹ aa-lwụkwa alwụlwu. Ndu Asiriya bẹ a-kpụko unu lẹ ndzụ.” ");
INSERT INTO izz_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Tọbudu iya bụ; o pfua sụ: “Oowaa! ?Bụ onye a-nọdu ndzụ lẹ teke Chileke a-nọdu eme iphe ono? ");
INSERT INTO izz_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ụgbo-mini e-shi agụga ẹnyimu l'alị Kitimu bya; bya emekpaa ndu Asiriya yẹle ndu Eba ẹhu; obenu l'ẹphebedua bẹ a-bụkwarupho mkpurupyata.” ");
INSERT INTO izz_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Tọbudu iya bụ; Belamu pfuchaa nno bya agbalihu; ọ bụru iya ala ibe iya; Belaku tụgbukwapho lashịa. ");
INSERT INTO izz_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","A nọnyaepho lẹ teke ono, ndu Ízurẹlu bu lẹ nsụda Shitimu ono; ẹphe l'ụnwada ndu Mówabu wata apharwụshi onwophẹ. ");
INSERT INTO izz_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ụnwanyi Mówabu ono wata eku ndu Ízurẹlu ono g'ẹphe tsoru phẹ je agwa agwa phẹ. Ndu Ízurẹlu nọdu erije iphe, e shiru l'agwa ono; bya abaarụ agwa ndu Mówabu ono ẹja. ");
INSERT INTO izz_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","No iya; ndu Ízurẹlu woru onwophẹ tụgbabe l'agwa Balụ-Peyọ. Eshi nno; ndu Ízurẹlu kpatsu Chipfu ẹhu-eghu. ");
INSERT INTO izz_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Chipfu bya asụ Mósisu: “Chịtakota ndu-ishi ndu Ízurẹlu l'ophu megbushia l'atatiphu mu; gbaa phẹ l'anwụ; k'ọphu mu e-wofu ẹhu-eghu mu, ata pfụpfupfu l'ẹhu ndu Ízurẹlu.” ");
INSERT INTO izz_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ọo ya bụ; Mósisu sụ ndu ọgbo-ikpe ndu Ízurẹlu: “G'onyenọnu lẹ g'unu ha l'ẹhu l'ẹhu gbushia ndu nkiya, bụ ndu woru onwophẹ tụgbabe l'agwa Balụ-Peyọ.” ");
INSERT INTO izz_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ndu Ízurẹlu dọkwaduru-a l'ọnu ụlo-ẹkwa-ndzukọ aragbaa ẹkwa. A bya ele ẹnya; onye lanụ l'ụnwu Ízurẹlu duwaru nwanyị Midiyanu bahụ ibe iya l'ẹka Mósisu phẹ tụkoru ele iya ẹnya; mẹ ndu Ízurẹlu l'ophu. ");
INSERT INTO izz_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasu nwa Eleyaza; mbụ nwanwa Erọnu, bụ onye uke Chileke hụmaepho iphe ono; o kwolihu l'ẹka ono, igwe-ọha ono kụru ono; je adụchata arwa iya. ");
INSERT INTO izz_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","O tsopyabẹ nwoke Ízurẹlu ono bahụ l'ime ụlo iya; je eworu arwa ono nmaa ya l'eli nwanyị ono; o shi l'ẹka a nmarụ iya nwoke foo kẹ nwanyị ono l'ẹpho; nkephẹ bvụ. Ọo ya bụ; ẹjo iphe-ememe ono haa ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ọle ndu ẹjo iphe-ememe ono gburu egbugbu bẹ dụ ụkporo ụnu nemadzụ ugbo ẹto. ");
INSERT INTO izz_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasu nwa Eleyaza; mbụ nwanwa Erọnu, bụ onye uke Chileke bẹ mewaru ọphu ẹhu-eghu ndu Ízurẹlu adụeduru mu. Noo kẹle o wotaru okophoo, mu gege ekoru ndu Ízurẹlu kooru phẹ; shi nno mee ọphu mu egudeẹdu okophoo mu ono mee gẹ ndu Ízurẹlu laa l'iyi. ");
INSERT INTO izz_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ọo ya bụ lẹ-a; sụ iya lẹ mu l'iya nọwaa l'ọgbandzu ẹhu-guu. ");
INSERT INTO izz_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ọgbandzu ono a-bụru nkiya waa k'awa iya phẹ, bụ ndu ọphu etso iya etsotso. Ọgbandzu ono bẹ bụ l'ẹphe a-bụru uke jasụwaruroya; kẹle o gude iswi ẹhu Chileke iya koo okophoo; mbụ shi nno pfụa ụgwo iphe-ẹji, ndu Ízurẹlu meru.” ");
INSERT INTO izz_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ẹpha nwoke Ízurẹlu ono, e gburu yẹle nwanyị Midiyanu ono bẹ bụ Zimiri nwa Salu. Nna iya, bụ Salu bẹ bụ onye-ishi l'ẹnya-unuphu, nọ l'ipfu Simiyọnu. ");
INSERT INTO izz_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ẹpha kẹ nwanyị Midiyanu ono, e gbukwarụpho ono bụ Kozubi nwada Zuru. Nna iya, bụ Zuru bẹ bụ onye-ishi l'ẹnya-unuphu ndu Midiyanu. ");
INSERT INTO izz_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Chipfu bya asụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Bụru ọhogu ndu Midiyanu; woru phẹ gbushia. ");
INSERT INTO izz_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Noo kẹle ẹphe gude ẹregede bụru ọhogu unu; deru unu ye l'agwa agwa Balụ-Peyọ ono; waa lẹ kẹ Kozubi, bụ nwada onye-ishi ndu Midiyanu; mbụ nwune ndu Midiyanu kẹ nwanyị, bụ onye ono, e gburu teke ono, kẹ Peyọ meru; ẹjo iphe-ememe bya ono.” ");
INSERT INTO izz_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","O be g'ẹjo iphe-ememe ono lachaaru; Chipfu bya epfuru Mósisu yẹle Eleyaza nwa Erọnu, bụ onye uke Chileke sụ: ");
INSERT INTO izz_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Unu gụa ndu Ízurẹlu l'ophu ọgu l'ẹnya-unuphu l'ẹnya-unuphu; e -shi lẹ ndu nọwaru ụkporo apha kwasẹru; mbụ ndu sụwaru eje ọgu lẹ Ízurẹlu.” ");
INSERT INTO izz_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ọ bụru lẹ baswaa alị Mówabu, nọ l'agụga ẹnyimu Jiọ́danu lẹ mgboru mkpụkpu Jieriko bẹ Mósisu yẹle Eleyaza, bụ onye uke Chileke nọ pfuaru ndu Ízurẹlu sụ: ");
INSERT INTO izz_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Unu gụa ndu Ízurẹlu l'ophu ọgu; e -shi lẹ ndu nọwaru ụkporo apha kwasẹru; mbụ ẹgube ono, Chipfu tụru iya Mósisu l'ekemu.” Waa ndu Ízurẹlu, shi l'alị Ijiputu fụta baa: ");
INSERT INTO izz_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ndu bụ oshilọkpa Rúbẹnu, bụ ọkpara Ízurẹlu bụ: Hanọku, onye metaru ipfu Hanọku; mẹ Palu, onye metaru ipfu Palu; ");
INSERT INTO izz_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","mẹ Hẹzuronu, onye metaru ipfu Hẹzuronu; mẹ Kami, onye metaru ipfu Kami. ");
INSERT INTO izz_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ipfu ono g'ẹphe ha tụkoru bụru oshilọkpa Rúbẹnu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ise l'ụnu tete l'ụkporo ụmadzu ishii l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Nwa Palu kẹ nwoke bụ Eliyabu. ");
INSERT INTO izz_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Ụnwu kẹ Eliyabu unwoke bụru: Nemẹlu; mẹ Detanu; waa Abiramu. Ọo Detanu waa Abiramu-a bẹ a họtajeru g'ẹphe bụru ishi lẹ Ízurẹlu; ẹphe tsoru ndu kẹ Kora kwefuru Mósisu yẹle Erọnu ike; mbụ teke ono, ẹphe kwefujeru Chipfu ike phọ. ");
INSERT INTO izz_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Alị saa ọnu tụko ẹphe lẹ Kora lwekọta; ndu shi etso iya nụ bẹ nwụshihuru nụ; mbụ lẹ teke ono ọku kegbushijeru ụkporo ụmadzu iri l'ẹbo l'ụmadzu iri phọ. Iphe ono bụru iphe alọ ẹka lẹ nchị. ");
INSERT INTO izz_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ọle ụnwu Kora ta anwụshihuduru. ");
INSERT INTO izz_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ndu bụ oshilọkpa Simiyọnu l'ipfu l'ipfu phẹ bụ: Nemẹlu, onye metaru ipfu Nemẹlu; mẹ Jiaminu, onye metaru ipfu Jiaminu; mẹ Jiakinu, onye metaru ipfu Jiakinu; ");
INSERT INTO izz_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","mẹ Zera, onye metaru ipfu Zera; mẹ Shawulu, onye metaru ipfu Shawulu. ");
INSERT INTO izz_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ipfu ono bẹ tụkoru bụru oshilọkpa Simiyọnu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo labọ l'ụnu iri l'ise l'ụkporo ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ndu ọphu bụ oshilọkpa Gadu l'ipfu l'ipfu phẹ bụ: Zefọnu, onye metaru ipfu Zefọnu; mẹ Hagi, onye metaru ipfu Hagi; mẹ Shuni, onye metaru ipfu Shuni; ");
INSERT INTO izz_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","mẹ Ozuni, onye metaru ipfu Ozuni; mẹ Eri, onye metaru ipfu Eri; ");
INSERT INTO izz_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","mẹ Arodi, onye metaru ipfu Arodi; waa Areli, onye metaru ipfu Areli. ");
INSERT INTO izz_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ipfu ono bẹ tụkoru bụru oshilọkpa Gadu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ise l'ụnu nemadzụ; l'ụmadzu ụkporo ise. ");
INSERT INTO izz_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Jiuda bẹ nwụtaru unwoke labọ, ẹpha phẹ bụ Ẹru; waa Ọnanu. Ọle ẹphenebo nwụshihuru l'alị Kénanu. ");
INSERT INTO izz_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ndu bụ oshilọkpa Jiuda l'ipfu l'ipfu phẹ bụ: Shela, onye metaru ipfu Shela; mẹ Pẹ́rezu, onye metaru ipfu Pẹ́rezu; mẹ Zera, onye metaru ipfu Zera. ");
INSERT INTO izz_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ụnwu kẹ Pẹ́rezu bụ: Hẹzuronu, onye metaru ipfu Hẹzuronu; waa Hamulu, onye metaru ipfu Hamulu. ");
INSERT INTO izz_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ipfu ono bẹ tụkoru bụru oshilọkpa Jiuda. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo tete l'ụnu iri lẹ nanụ l'ụkporo ụmadzu ise. ");
INSERT INTO izz_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ndu bụ oshilọkpa Isaka l'ipfu l'ipfu phẹ bụ: Tola, onye metaru ipfu Tola; mẹ Puwa, onye metaru ipfu Puwa; ");
INSERT INTO izz_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","mẹ Jiashubu, onye metaru ipfu Jiashubu; waa Shimurọnu, onye metaru ipfu Shimurọnu. ");
INSERT INTO izz_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ipfu ono bẹ tụkoru bụru oshilọkpa Isaka. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ẹsato l'ụkporo ụmadzu iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ndu bụ oshilọkpa Zebulọnu l'ipfu l'ipfu phẹ bụ: Sẹredu, onye metaru ipfu Sẹredu; mẹ Elọnu, onye metaru ipfu Elọnu; waa Jiahulẹlu, onye metaru ipfu Jiahulẹlu. ");
INSERT INTO izz_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ipfu ono bẹ tụkoru bụru oshilọkpa Zebulọnu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ẹsaa l'ụnu iri lẹ nanụ l'ụkporo ụmadzu ise. ");
INSERT INTO izz_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ndu bụ oshilọkpa Jiósẹfu l'ipfu l'ipfu phẹ bụ: Manásẹ; waa Ifuremu. ");
INSERT INTO izz_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ụnwu kẹ Manásẹ bụ: Makiya, onye metaru ipfu Makiya. Makiya bụ nna Giladu. Giladu meta ipfu Giladu. ");
INSERT INTO izz_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ụnwu Giladu bụ: Iyeza, onye metaru ipfu Iyeza; mẹ Helẹku, onye metaru ipfu Helẹku; ");
INSERT INTO izz_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","mẹ Asụrelu, onye metaru ipfu Asụrelu; mẹ Shẹkemu, onye metaru ipfu Shẹkemu; ");
INSERT INTO izz_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","mẹ Shemida, onye metaru ipfu Shemida; waa Hefa, onye metaru ipfu Hefa. ");
INSERT INTO izz_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehadu, bụ nwa Hefa bẹ ta nwụtaduru unwoke. Ọo ụnwanyi bẹ ọ nwụshiru. Ẹpha ụnwanyi ono, ọ nwụshiru ono bụ Mahula; mẹ Nuwa; mẹ Họgula; mẹ Milika; waa Tịza. ");
INSERT INTO izz_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ipfu ono tụkoru bụru oshilọkpa Manásẹ. Ndu ọphu a gụru ọgu dụ ụkporo ụnu nemadzụ ugbo ishii l'ụnu iri lẹ nanụ l'ụkporo ụmadzu iri l'ise. ");
INSERT INTO izz_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ụnwu kẹ Ifuremu l'ipfu l'ipfu phẹ bụ: Shutela, onye metaru ipfu Shutela; mẹ Beka, onye metaru ipfu Beka; waa Tahanu, onye metaru ipfu Tahanu. ");
INSERT INTO izz_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ụnwu Shutela bụ Eranu, onye metaru ipfu Eranu. ");
INSERT INTO izz_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ipfu ono bẹ tụkoru bụru oshilọkpa Ifuremu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ẹno l'ụnu nemadzụ l'ụkporo ụmadzu ise. Ndu ono bẹ tụkoru bụru oshilọkpa Jiósẹfu l'ipfu l'ipfu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ndu bụ oshilọkpa Benjiaminu bụ: Bela, onye metaru ipfu Bela; mẹ Ashịbelu, onye metaru ipfu Ashịbelu; mẹ Ahiramu, onye metaru ipfu Ahiramu; ");
INSERT INTO izz_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","mẹ Shefufamu, onye metaru ipfu Shefufamu; waa Hufama, onye metaru ipfu Hufamu. ");
INSERT INTO izz_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ụnwu Bela bụ: Arụdu; mẹ Nemanu. Arụdu, bụ iya metaru ipfu Arụdu; Nemanu bụru iya metaru ipfu Nemanu. ");
INSERT INTO izz_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ndu ono bẹ tụkoru bụru oshilọkpa Benjiaminu l'ipfu l'ipfu phẹ. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ise l'ụnu ụmadzu iri l'ẹno. ");
INSERT INTO izz_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ndu bụ oshilọkpa Danu l'ipfu l'ipfu phẹ bụ: Shuhamu, onye metaru ipfu Shuhamu. Ndu ono bẹ tụkoru bụru oshilọkpa Danu l'ipfu l'ipfu phẹ. ");
INSERT INTO izz_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ẹphe tụkoru bụru ipfu Shuhamu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ẹsato l'ụnu nemadzụ lanụ. ");
INSERT INTO izz_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ndu bụ oshilọkpa Asha bụ: Imuna, onye metaru ipfu Imuna; mẹ Ishivi, onye metaru ipfu Ishivi; waa Beraya, onye metaru ipfu Beraya. ");
INSERT INTO izz_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ụnwu Beraya bụ: Heba, onye metaru ipfu Heba; waa Malukẹlu, onye metaru ipfu Malukẹlu. ");
INSERT INTO izz_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ọ bụru nwa nwanyị lanụ bẹ Asha nwụtaru; ẹpha iya bụ Sera. ");
INSERT INTO izz_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ndu ono bẹ tụkoru bụru oshilọkpa Asha. Ndu ọphu a gụru ọgu bẹ dụ ụnu ụkporo ugbo ishii l'ụnu iri l'ẹto l'ụkporo ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ndu bụ oshilọkpa Nafụtali l'ipfu l'ipfu phẹ bụ: Jiahuzẹlu, onye metaru ipfu Jiahuzẹlu; mẹ Guni, onye metaru ipfu Guni; ");
INSERT INTO izz_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","mẹ Jieza, onye metaru ipfu Jieza; waa Shilemu, onye metaru ipfu Shilemu. ");
INSERT INTO izz_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ndu ono bẹ tụkoru bụru oshilọkpa Nafụtali l'ipfu l'ipfu phẹ. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu nemadzụ ugbo ise l'ụnu iri l'ẹto l'ụkporo ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Noo ya; iphe, ndu Ízurẹlu tụkoru dụ bụru ụkporo ụnu nemadzụ ugbo ụkporo ẹto l'ụkporo ụnu ugbo iri l'ise l'ụnu nemadzụ ẹno l'ụkporo ụmadzu ishii l'ụmadzu iri. ");
INSERT INTO izz_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ọo ndu-a bẹ aa-washịru alị ono g'ọ bụru okiphe, ẹphe ketarụ. Ndu nọnu e-keta oke lẹ g'ẹphe ha teke a gụru phẹ ọgu. ");
INSERT INTO izz_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ndu ha shii bẹ ịi-wẹ alị, ha shii; ndu ọphu ha nwanshịi; wẹe phẹ alị, ha nwanshịi. Ndu ọphu nọnu e-keta oke lẹ g'ẹphe ha teke a gụru phẹ ọgu. ");
INSERT INTO izz_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Alị ono bẹ bụ ido bẹ aa-tụ gude washịa ya. Aa-wa iya l'ipfu l'ipfu; ipfu nọnu l'o keta oke iya nkephẹ. ");
INSERT INTO izz_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ọ bụru ido bẹ aa-tụ gude washịaru ndu ọphu ha shii; mẹ ndu ọphu ha nwanshịi alị ono.” ");
INSERT INTO izz_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Waa oshilọkpa Lívayi baa; waa g'e gude gụa phẹ ọgu l'ipfu l'ipfu: Geshọnu, onye metaru ipfu Geshọnu; mẹ Kohatu, onye metaru ipfu Kohatu; waa Merari, onye metaru ipfu Merari. ");
INSERT INTO izz_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ipfu-a bẹ bụkwapho oshilọkpa Lívayi: Ipfu Libuni; mẹ ipfu Hẹburonu; mẹ ipfu Mahuli; mẹ ipfu Mushi; mẹ ipfu Kora. Kohatu bụ nna Amụramu. ");
INSERT INTO izz_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ẹpha nyee Amaramu bẹ bụ Jiekobẹdu, bụ nwada Lívayi. Jiokebẹdu bụ nwa nwanyị, a nwụru Lívayi l'alị Ijiputu. Ndu ọ nwụtaru Amụramu bụ Erọnu; waa Mósisu; mẹ Miriyamu. Miriyamu bụru nwune phẹ kẹ nwanyị. ");
INSERT INTO izz_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Erọnu bụ nna Nadabu; mẹ Abihu; mẹ Eleyaza; waa Itama. ");
INSERT INTO izz_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabu yẹle Abihu bẹ nwụhuru lẹ teke ẹphe gude ọku, adụdu nsọ kpọoru Chipfu ngwẹja ọku. ");
INSERT INTO izz_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ndu a gụru ọgu l'eri Lívayi; mbụ unwoke phẹ, nọwaru shita l'ọnwa lanụ kwasẹru bẹ tụkoru dụ ụkporo ụnu nemadzụ ugbo labọ; l'ụnu ụmadzu iri l'ẹsaa; l'ụkporo ụmadzu iri. Ọphu a gụduru phẹ teke a gụru ndu Ízurẹlu ọphuna; kẹle ẹphe te ketaduru oke l'echilabọ ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ndu ono bẹ bụ ndu Mósisu yẹle Eleyaza, bụ onye uke Chileke gụru ọgu; mbụ ndu ono, gụru ndu Ízurẹlu ọgu lẹ baswaa alị Mówabu l'agụga ẹnyimu Jiọ́danu lẹ mgboru Jieriko. ");
INSERT INTO izz_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ndu ono ta adụdu g'ẹphe ha, yị lẹ ndu ọphu Mósisu yẹle Erọnu, bụ onye uke Chileke gụjeru ọgu teke phọ, ẹphe gụru ndu Ízurẹlu ọgu l'echiẹgu Sayịnayi phọ. ");
INSERT INTO izz_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Noo kẹle Chipfu sụru ndu Ízurẹlu ono l'ẹphe nwụhufutaje l'echiẹgu ono. Ọ tọ dụdu g'ọ ka mma l'ọo onye lanụ, aphọdu nụ l'ime ndu ono; a -gụfuepho Kalẹbu nwa Jiefune; yẹle Jioshuwa nwa Nunu. ");
INSERT INTO izz_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Tọbudu iya bụ; ụnwada Zelofehadu bya atụko je apfụru l'ọnu ụlo-ẹkwa-ndzukọ. Zelofehadu l'onwiya bụ nwa Hefa; Hefa bụru nwa kẹ Giladu; Giladu bụru nwa kẹ Makiya; Makiya bụru nwa kẹ Manásẹ. G'ẹphe ha bụkota oshilọkpa Manásẹ. Manásẹ bụru nwa kẹ Jiósẹfu. Ẹpha ụnwada Zelofehadu ono bụ: Mahula; mẹ Nuwa; mẹ Họgula; mẹ Milika; waa Tịza. ");
INSERT INTO izz_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ụnwada Zelofehadu ono bya apfụru l'atatiphu Mósisu; waa l'atatiphu Eleyaza, bụ onye uke Chileke; mẹ l'atatiphu ndu-ishi; mẹ l'atatiphu ndu Ízurẹlu l'ophu l'ọnu ụlo-ẹkwa-ndzukọ pfuahaa sụ: ");
INSERT INTO izz_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nna anyi bẹ nwụhuru l'echiẹgu. Ọle ọ tọ yịkwa lẹ ndu ono, chịkoberu onwophẹ tsoo Chipfu opfu ono; mbụ ndu ono, tsoru Kora ono. Nna anyi bẹ bụkpoepho iphe-ẹji, o metaru l'onwiya gburu iya; ọphu ọ nwụtaduru nwa nwoke. ");
INSERT INTO izz_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","?Ee-gude kẹle nna anyi ta nwụtaduru nwa-nwoke; ẹpha iya echihu l'ipfu iya? G'a hẹkwa anyi oke l'echilabọ ndibe nna anyi.” ");
INSERT INTO izz_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ọo ya bụ; Mósisu wota opfu ụnwada Zelofehadu ono papfu Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Ụnwada Zelofehadu pfuru iphe, gbaru nụ. Unu shi l'oke alị ndu nna phẹ wẹe phẹ alị; k'ọphu ẹphe e-keta okiphe nna phẹ. ");
INSERT INTO izz_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Pfuaru ndu Ízurẹlu; sụ phẹ-a: Ọ -bụru lẹ nwoke bẹ nwụhuru nụ; ọphu ọ nwụtaduru nwa-nwoke; g'e wotajẹ okiphe, rwuberu iya nụ woru nụ nwada iya. ");
INSERT INTO izz_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ọ -bụru l'onye ọbu ta nwụtafudaru nwa-nwanyị; g'e wotajẹ okiphe, rwuberu iya nụ ọbu woru nụ unwune iya kẹ nwoke g'ọ bụru iphe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Teke ọbu l'o to nwefuda unwune nwoke; g'e woru okiphe ono, rwuberu iya nụ woru nụ nwune nna iya phẹ kẹ nwoke g'ọ bụru iphe phẹ. ");
INSERT INTO izz_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ọ -bụru lẹ nna, nwụru onye ọbu te nwedu unwune nwoke; g'e woru okiphe, rwuberu iya nụ ọbu nụ ndu ẹphe l'iya bụ ọkpobe abụbu g'ọ bụru iphe phẹ. Iphe ono bụ omelalị, a tọru ọkpa iya doberu ndu Ízurẹlu; ẹgube Chipfu tụru iya Mósisu l'ekemu.” ");
INSERT INTO izz_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Tọbudu iya bụ; Chipfu sụ Mósisu: “Nyihu eli úbvú Abarimu-a je anọdu hụmakota alị ono, mu nụru ndu Ízurẹlu ono. ");
INSERT INTO izz_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ị -hụmachaẹ ya phọ bẹ ịi-nwụhu lapfushia ndibe unu; ẹgube ono nwune ngu nwoke, bụ Erọnu nwụhuru. ");
INSERT INTO izz_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Iphe, kparụ iya nụ bụ l'unu kwefuru ike l'opfu mu lẹ teke ono, ndu Ízurẹlu gụjeru aphụ lẹ mgboru mini ono, dụ l'echiẹgu Zinu ono. Ọphu unu adụdu ike dobe mu nsọ l'iphu phẹ.” (Mini ono bụ mini Meriba, dụ lẹ Kadẹshi lẹ mgbẹgu Zinu.) ");
INSERT INTO izz_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mósisu sụ Chipfu: ");
INSERT INTO izz_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Gẹ Chipfu; mbụ Chileke ọphu gude ndzụ onyemonye họta nụ onye a-nọdu edu ndu Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Onye e-vutajẹru phẹ ụzo l'ejeje mẹ l'alwalwa; mbụ onye a-nọdu edu phẹ eje ejeje alwa alwalwa; gẹ ndibe gụbe Chipfu ta adụshi g'atụru, te enwedu onye eche iya nụ.” ");
INSERT INTO izz_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ọo ya bụ; Chipfu sụ Mósisu: “Duta Jioshuwa nwa Nunu, bụ onye Unme kẹ mụbe Chipfu bu l'ẹhu; byabẹ iya ẹka l'ishi. ");
INSERT INTO izz_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Duru iya g'o je apfụru l'atatiphu Eleyaza, bụ onye uke Chileke; mẹ l'atatiphu ndu Ízurẹlu l'ophu; g'ị nọdu l'atatiphu ndu ono woru ozi ono ye iya l'ẹka. ");
INSERT INTO izz_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Harụ ike nkengu ye iya l'ẹka; k'ọphu iphe, bụ Ízurẹlu l'ophu a-nọduje eme iphe, ọ sụru g'ẹphe mee. ");
INSERT INTO izz_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Gẹ Jioshuwa pfụru l'atatiphu Eleyaza, bụ onye uke Chileke. Eleyaza egude ido, urimu jee l'iphu Chipfu je ajịa Chipfu g'ọ maru g'o pfuru opfu ẹhu iya. Ọ bụru iphe, Jioshuwa sụru gẹ ndu Ízurẹlu mee bẹ ẹphe a-tụkoje mee. Ọ -sụ gẹ ndu Ízurẹlu tụgbua; ẹphe atụgbua; ọ -sụ g'ẹphe bata; yẹle ẹphe a-tụko bata.” ");
INSERT INTO izz_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mósisu mee gẹ Chipfu pfuru iya. O duta Jioshuwa pfụbe l'atatiphu Eleyaza, bụ onye uke Chileke; mẹ l'atatiphu edzudzu-ọha Ízurẹlu. ");
INSERT INTO izz_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ọo ya bụ; o byibe Jioshuwa ẹka l'ishi woru ozi ono ye iya l'ẹka bụ iphe, Chipfu shi l'ọnu Mósisu pfua. ");
INSERT INTO izz_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Chipfu sụ Mósisu: ");
INSERT INTO izz_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Tụru ekemu nụ ndu Ízurẹlu; sụ phẹ: Unu leta ẹnya nụje mu ngwẹja, rwuberu mu nụ; mbụ nri, e gude egweru mu ngwẹja; mbụ ngwẹja ono, a kpọru ọku, mkpọ iya dụ mu ree. Unu nụje mu iya lẹ teke bụ orwuberu iya. ");
INSERT INTO izz_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Sụ phẹ lẹ-a: ‘Waa ngwẹja, a kpọru ọku, unu e-gweje nụ Chipfu baa: ụnwu ebili labọ, gbachaaru apha; ọphu 'adụdu ẹka iphe mebyiru iya. Unu gweje iya mbọkumboku; g'ọ bụru ngwẹja-akpọ-ọku, unu e-gweje tekenteke. ");
INSERT INTO izz_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Unu gbuje ebili lanụ l'ụtsu; unu egbua ebili lanụ l'ụzenyashi. ");
INSERT INTO izz_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Unu yeje iya ngwẹja-nri gwee; mbụ ụzo lanụ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ, a tsụru l'ikwe; manụ e-ji eze ekpemu. ");
INSERT INTO izz_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ọo ya bụ ngwẹja-akpọ-ọku, eegweje mbọkumboku, bụ iya bụ g'e meru iya dobe l'úbvú Sayịnayi; mbụ ngwẹja ono, a kpọru ọku, mkpọ iya dụ Chipfu ree. ");
INSERT INTO izz_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Unu -gbua ebili lanụ; unu yekọbe iya ngwẹja-mẹe gwee; mbụ mẹe, jiru nkeru-ẹno ọtu-lupfu otumu. Ọ bụru l'ẹka-dụ-nsọ bẹ unu a-gbashịjeru Chipfu ngwẹja-mẹe ono; mbụ mẹe, shihuru ike. ");
INSERT INTO izz_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Unu egbufua ebili lanụ l'ụzenyashi; yekọbekwa iya phọ ngwẹja-nri; waa ngwẹja-mẹe ẹgube ono, ọ dụ lẹ k'ụtsu phọ. Unu gwee ngwẹja ono; g'ọ bụru ngwẹja, a kpọru ọku, mkpọ iya dụ Chipfu ree.’ ” ");
INSERT INTO izz_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“A -bya l'eswe-atụta-unme; unu gbuje ebili labọ, gbachaaru apha, 'adụdu ẹka iphe mebyiru iya; gude gwee ngwẹja. Unu egude ụzo labọ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ; gude gwee ngwẹja-nri. Unu yekọbe iya ngwẹja-mẹe, ayịjeru iya nụ. ");
INSERT INTO izz_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ono bụ ngwẹja-akpọ-ọku, unu e-gweje l'eswe-atụta-unme; yekwarụ ngwẹja-akpọ-ọku, eegweje mbọkumboku phọ; yẹle ngwẹja-mẹe, ayịjeru iya nụ.” ");
INSERT INTO izz_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Mbọku mbụ, ọnwa fụru gẹdegede bẹ unu e-gwejeru Chipfu ngwẹja-akpọ-ọku. Unu gudeje ụnwu oke-eswi labọ; waa ebili lanụ; mẹ ụnwu ebili ẹsaa, gbachaaru apha, adụdu ẹka iphe mebyiru iya; gude gwee ngwẹja ono. ");
INSERT INTO izz_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Unu -gbua oke-eswi ono nanụ bẹ unu e-yekọbeje iya ngwẹja-nri gwee; mbụ ụzo ẹto l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ. Unu -gbua ebili ono; unu yekọbe iya ngwẹja-nri gwee; mbụ ụzo labọ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ. ");
INSERT INTO izz_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Unu -gbua nwa ebili lanụ; unu eyekọbe iya ngwẹja-nri gwee; mbụ ụzo lanụ l'ime nkwẹka ukpokutu ereshi, e keru ụzo iri; gwọo lẹ manụ. Ono bụ ngwẹja-akpọ-ọku, mkpọ iya dụ Chipfu ree; mbụ ngwẹja, a kpọru ọku gweeru Chipfu. ");
INSERT INTO izz_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ngwẹja-mẹe, a-yịjeru iya nụ bụ: unu -gbua oke-eswi; unu eyekọbe iya mẹe, jiru nkeru-ẹbo ọtu-lupfu otumu. Ọ -bụru l'ọo ebili; unu eyekọbe iya mẹe, jiru nkerẹto ọtu-lupfu otumu gwee. Unu -gbua nwa ebili; unu eyekọbe iya mẹe, jiru nkeru-ẹno ọtu-lupfu otumu gwee. Noo kẹ ngwẹja-akpọ-ọku, unu e-gweje l'ọnwa l'ọnwa; mbụ l'ọnwa, dụkota l'ime apha. ");
INSERT INTO izz_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Unu gbuje mkpi lanụ gude gwee ngwẹja-iphe-ẹji nụ Chipfu; a -gụfukwa ngwẹja-akpọ-ọku, eegweje mbọkumboku; yẹle ngwẹja-mẹe, ayịjeru iya nụ.” ");
INSERT INTO izz_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16",